﻿USE sofia;
DROP TABLE IF EXISTS sofia.byr_w_vpl;
CREATE TABLE byr_w_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES byr_w_vpl WRITE;
INSERT INTO byr_w_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Sɨnyamwɨnyagaa' kɨgaakuna Kwaaga taba' myɨma'nyamwɨ Godɨyarɨne Yagaalyai mwaryaagemwɨnyɨ. Nabaai, Godɨyai mwaaragemwɨ kamɨnyɨmwɨ Godɨyarɨne Yagaalyai mwaarɨ'. Gotɨyarɨne Yagaalyai sagwai Godɨyai. ");
INSERT INTO byr_w_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Sɨnyamwɨnyagaa' kunegaa' aayamwɨdaa'nyɨ Godɨyalyɨ sagwai mwarɨbainyɨna yaagelyɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Godɨyai sara kyabwɨra' sagwai wɨyangɨ sara wagagei. Aane pɨrɨ' kɨrɨ' kamɨ saba yɨma'naga' mɨ'. Aawa, sagwai wagagengɨ wɨya sa. ");
INSERT INTO byr_w_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Sɨnyamwɨ sagaa' sagwarɨ kaalyabwi waragelyɨ. Kaala sabwi a'mwe wɨyaraabɨre Paagelyɨ. Yɨnɨga sai a'mweinaabɨna kunya tewaanya yabwɨrya'ne nejaabɨnɨgerɨna. Kunya tewaanya yabwɨrya'ne wɨjaabɨna kaneya' paaga sabɨ nabyaa mwaindaanyaine. (Godɨyarɨna nabyaa yabwɨtaanyaine.) ");
INSERT INTO byr_w_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Saburɨdaa'nyɨ sɨgɨnya kayaa'nayaburɨ Godɨyare paage' wannyɨna. Nabaai sɨgɨnya sa' paagebɨ mwabɨlayɨnɨgesɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Godɨyai yabwɨ'na “A'mwera paagebɨ mwaaimbɨga!” yabwɨraga sɨnyamwɨ a'mwerɨ wɨdaasagelyɨ. Sai Sonɨ (pabɨtaajɨya yandei) wɨdaasagelyɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","A'mwe sagwai salɨguragyɨ'nei pɨna. “A'mweraabɨ a'mwengɨ Jisaasi Paagerɨna wɨjalɨguragana!” taga wɨdaasagei pɨna. “Kadɨga wɨ'napɨjɨ Naangerɨ lɨmwagapɨga!” tagei pɨna. ");
INSERT INTO byr_w_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Sonɨ kamɨ sai Paagei mɨka! Aawa. “Paaga nabwɨ'nya sarɨna salɨguragana!” tagelyɨra. ");
INSERT INTO byr_w_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tɨbi Paagei Kwaaga tabagɨ waraabaga a'mwe kajainajainaabɨna Paaga nebulya'nanyalyɨ. A'mwe wɨyainaabɨ kunya tewaanya yabwɨrya'ne nejaabandei. ");
INSERT INTO byr_w_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nabaai, Kwaaga tabagɨ sai pamwaaina ya'. Sɨnyamwɨ Godɨyai kyabwɨra' sagwai Kwaaga taba' sara wagɨna. Sara wagɨna yaga pamwaaina kya' kɨrɨ' Kwaaga Tabagɨ mwaaryara kamɨ sagwarɨ myabwɨramaaryɨ yesalyɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Kamnya Anga Yɨjɨrelɨna pɨna yaga mwaaindaasɨ kamɨjɨyara mamaaryɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Sara yɨna yeba mamaaryɨ kye' kɨrɨ' a'mwera pwara “Nebulyasɨra. Naangelyɨra,” teba maarɨna ye'. Maarɨna kye' sai wɨya saraabɨ kamnya tɨragɨnyabwi wɨjaabɨna ya'. Kamnya tɨragɨnya sabwi sagwara Godɨyale kwaimɨraayara yɨma'nyɨ'nebulyɨ. Kamɨ sagwarɨnajɨ kamɨre yebyabɨnajɨ lɨmwagatɨbɨsaraabɨnebulyɨ. Yɨ sagwara mudɨgera yɨma'nyɨna ye'. ");
INSERT INTO byr_w_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","A'mweraabɨre yɨjabagaabɨdaa'nyɨ tawengɨna mudɨgera myɨma'nyɨna. Aawa. Kɨraagejɨgɨya sɨndujaburɨ mudɨgera myɨma'nyɨna. Aawa. A'mweraabɨre tɨragɨnyabɨ mudɨgera myɨma'nyɨna. Aawa. Godɨyai kebwi yabwɨ'na “Sagwara nɨmɨre kwaimɨraayara mudɨgeraabɨ yawagɨnɨma!” kada' yɨma'nɨgabɨnɨgengɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Godɨyarɨne Yagaalyai a'mwe kɨraa'nagei yɨma'nyɨna yagei nemɨnyɨmwɨ kamnya selɨ ange' yɨradaakuna. Kamɨre kɨraagejɨgɨ wɨramwaaina yɨna yandaasɨ tɨnya tara wangano' “O, Nabwɨ'nyai tɨragɨnaangei taaga!” Sara tandaa kamɨre paagebɨ tɨnya wangano. Kanɨmaangerɨdaa'nyai kambei yamagɨnarɨgabaaimbɨta paaga sasɨ. Sagwarɨ yuneba yanga kaimwangebulyɨ nebulyabulyɨ maanga yegu'nɨgelyɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","A'mwe Sonɨ kamɨnyɨna nejalɨguraganda saga tara tanganna “A'mwe tajarɨna yɨnggɨdelyɨ. Nɨmɨ Godɨyale yagaala kyɨnggɨdɨmwa tɨbiya pwai pojɨ yɨnggɨdɨbwaagadei Naangelyɨ. Nɨmɨ sagwainyɨ mɨga! Nɨmɨ maarɨgeinyɨra/wabeinyɨra. Nɨmɨ myɨma'nyagaa' kuna mwaryaage'na Sɨnyamwɨnyalyɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Sagwai maanga yegu'nɨgebɨdaa'nyɨ nemɨ wɨyainaabɨna wana nabwɨ'nya nejaabande'na tewaanna mwaaigo. Nemɨnyɨ kamɨre yanga kaimwanggaimwange' nejaabanda nejaabɨnɨgelyɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Sare' Godɨyai kujaa' Ne Mojɨji Godɨyale Kɨmwɨnya tewaanya' wɨjaabɨna. Wɨjaabɨna neyɨnɨge' nemɨnyɨmwɨ Godɨyai Kɨraajɨtɨya Jisaasɨrɨ wɨdasaabɨna. Wɨdasaabɨna kyɨnɨ' sagwarɨ nemɨnyɨna yanga kaimwangebulyɨ nebulyabulyɨ yɨma'nɨnɨge'nanyɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Godɨyarɨ a'mwe Kwaaga tabagɨyaina wangandaanyarɨna mɨ'. Aane pwai kwai tɨnya mwanganyɨ. Aawa. Godɨyai, kambei kanɨmaangeryaba kusɨmagɨnna mwaarɨgei nemɨnyɨ yɨbwarɨdaakwia neyɨgelyɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mwanyɨgaa' Sonɨ mwaaraga Jisaasi pagerɨ tɨnya wanganaasɨna yaga a'mweraabɨ wɨdɨna “Yɨdaanyi! Tajai Godɨyalei Sipɨjipɨya tɨmwɨnyara! Kayaa'nayanna a'mwera sipɨjipɨyarɨ lamɨna yandɨbɨ' kwaraanyaba Godɨyarɨna tɨga nasɨ'na yandebaaimbɨ' sai Kwaagebagɨ mwaaryainaabɨre kayaa'nayanna marasɨsa'na paradelyɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Sagwarɨna yɨnggɨdandɨnyalyɨ. “Nɨmɨ pɨmeinyɨ, tɨbi a'mwei padelyɨ. Nɨmɨ myɨma'nyagaa' sai kuna mwaaryaagalyɨ. Sai sɨnyamwɨnyai Naangalyɨ. Nɨmɨ wabeinyɨra. ");
INSERT INTO byr_w_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","‘Pojɨyai Naanga Kwarɨnera,’ yabwɨrena kamɨnyɨ myabwɨranganyainyɨ. Aawa. ‘Sagwarɨna Yɨjɨrelɨyaraabɨ yɨbwarɨdaakwia'na yɨma!’ tena pɨma. Aarya yɨnggyandɨnya (lɨbamabandɨnya) sabɨ tara sabwɨryinde' ‘O, sai Naangai taaga!’” ");
INSERT INTO byr_w_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Sonɨ tɨnya mena paigɨnaraga a'mwe Sudaayaraabɨ wɨjalɨguragɨna “Sugunyabɨ Godɨyalebadaa'nyɨ Kuryai Tewaanyai kwaamɨryaimbɨsai waraabɨna yaga a'mwe sarɨ mwaarɨbainɨgarɨ tɨnya wanganerɨnera. ");
INSERT INTO byr_w_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Sɨnyamwɨ kamɨnyɨ myabwɨranganyainyɨ. Aawa. Pabɨtaajɨya'na nyɨdasaabagai sagwai nyɨnda' ‘Tɨbidaa'nyɨ tara tongandeigɨnyɨ. Kurya Tewaanyai a'mwe pwarɨ pwaramwaaina yaja' wanganakɨjɨ tara sabwɨte' “Ai, sai a'mweraabɨna Kurya Tewaanyarɨ yanga wɨjaabadei taaga!” Kɨmɨ aaryabɨ pabɨtaajɨya' sɨde' sai Kuryarɨ pabɨtaajɨya' yadelyɨ.’ ");
INSERT INTO byr_w_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Sara wɨdɨna nyage' tɨnya nabyaa wangameinyɨ yɨnggɨjalɨguragɨbaiga. Sai Godɨyale Kawaarɨbaangalyɨra.” ");
INSERT INTO byr_w_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Sudaaya pwara Perɨjigɨmwɨnya yandɨbɨ' mwaarɨna yebe pwai Nikodimaajai wo'nɨgai Perɨjiyai mwaarɨna yagalyɨ. Sai a'mwe naangai Sudaayaraabɨ maremwaaindei mwaaragalyɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mwaarɨna yaga sagwɨja pɨrɨbɨ Jisaasɨryɨmwɨ pɨna yaga pamwaaina yaga wɨdɨna “Wɨdɨbwaagyaigi/yibwaagyaigi ‘Godɨyai kɨdasɨmwaabɨgaigi pagɨna wɨdɨbwaagyɨna neyɨbaigɨ. Sare' tare'nesɨ. A'mwera wɨjɨwaainyangɨ yɨbaigɨ. Tɨragɨnya yɨbaigɨ Godɨyai magɨgaimwagyajɨ kwajɨ sara myɨ kyɨdɨ' tɨragɨnya tabwi,’ sara yabwɨ'mona.” ");
INSERT INTO byr_w_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jisaasi sa'na wɨdɨna/ma'maa'na “Naanga nebula'na kɨdɨbaiga. A'mwe pwai kwai ayagi mudɨgai myɨma'nyɨ yajai Godɨyai maremwaaradeba tɨnya mwanganyɨ yannelyɨ.” ");
INSERT INTO byr_w_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimaajai wɨdɨna “A'mwe naangai mudɨgai yɨma'nya'na kadara yojɨ/yajɨ yɨma'nadelaga? Pɨgasaai a'mwei kanaangebɨ munyawɨgɨ ayagɨjɨ wɨraminyɨna kyajɨ kanaange' kadara maaradelaga ayagwara?” ");
INSERT INTO byr_w_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Sai sa'na wɨdɨna “Naanga nebula'na kɨdɨbaiga. Kurya Tewaanyai a'mwe pwarɨ aari myɨ kyajɨ mudɨga mwɨmwaaigyɨ kyajɨ sai Godɨyale maremwaaindeba wɨradei mɨga! ");
INSERT INTO byr_w_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","A'mweraabɨre kwaimɨraabyai mɨgwɨ'naga yagɨnnagalyɨ. Godɨyalei, kamɨre munyawɨgɨ Kurya Tewaanyai puramwaaina kyajɨ sai a'mwe Godɨyale Kuryai kɨnɨnnagalyɨ mudɨgai. ");
INSERT INTO byr_w_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kɨdɨme'na “Semɨ mudɨga ayagi sɨma'nyɨra!” kɨdɨme'na atɨga maru'nata myɨnnera! ");
INSERT INTO byr_w_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yɨgwɨja kamɨ sa' kaanna wɨna yandebaaimbɨsasɨ. Yɨgwɨja' kadɨga wɨ'nandɨnyaigi “Samwɨnna wawade' taaga? Sabadaa'nyɨ pade' taaga?” Tandɨnyaigi mɨ'. Aawa. Sare'na Godɨyale Kurya Tewaanyai kajaijare munyawɨgɨ pwɨramwaaina yɨnɨgai mudɨga yɨma'nɨ'. Mudɨgai tewaanna yanda a'mwera tɨnya wangamaigya'. Kumɨ mwangamaigya' aaya kaabɨlabɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimaajai ma'maa'na “Nyɨndɨmaanya' kadara yɨma'nɨnɨgabaga?” ");
INSERT INTO byr_w_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Sai wɨdɨna “Yɨjɨrelɨyainaabɨre nedɨbwaagandɨnyaigi sabwi myabwɨramaaryigɨnyaigi taaga? ");
INSERT INTO byr_w_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Naanga nebula'na kɨdɨbaigo. Nabyaa yabwɨramaataanya yabwɨtaa yɨnggɨdɨbaigo. Tɨnya nabyaa wangandaanya yɨnggɨdɨbaigo. Sara yɨnggɨdɨbaigo'na nemɨre salɨguragyabɨ mamaa'maigyasalabilyɨra. Sabwi kadɨga myɨbaigyata sa' pe'na yɨbaigya'? ");
INSERT INTO byr_w_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kwaaga tabagɨ yɨnɨgangɨna kyɨnggɨdɨma malɨmwaga'maigya'. “Nebulasɨ,” sara majɨ yɨmaasa' Sugunyabɨ yɨnɨgangɨna yɨnggɨdɨmwɨja' kara tɨlɨmwagyindelabiraga! ");
INSERT INTO byr_w_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Sugunyabɨna yɨraawagai a'mwei pwai kwai mɨga. Sugunyabɨ A'mweraabɨne Kwaimɨraabyai mwaaraga sabɨdaa'nyɨ sai yɨmbei waraaba'.” ");
INSERT INTO byr_w_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kɨgaa' a'mwamaayaba Ne Mojɨji kwaari'makamaala' yɨjabɨ pwɨyaga wɨdaakuna yaa'. Kamaalarɨ makyɨryaagabaaimbɨ' yɨjabɨ tamagya'na A'mweraabɨne Kwaimɨraabyarɨ sagɨbaaimbɨ' makyimbɨtelyɨra. ");
INSERT INTO byr_w_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Sagwai “Kajaijai nyɨlɨmwagarajɨ kaala wɨyagaa'nebwi maarana!” kadajɨ sara makyimbɨtelyɨra. ");
INSERT INTO byr_w_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Sare' tare'nesɨ. Kwaaga tabagɨyainaabɨna Godɨyale kare naanga kwia' Godɨyai nemɨnyɨna kawaarɨbaanga yɨmberɨ nejaabagalyɨ. “Kajaijai sagwarɨ wɨlɨmwagarajɨ myɨwawanna! Aawa. Kaala wɨyagaa'nebwi maarana!” taga nejaabagalyɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Sare' tare'nanyɨ. Godɨyai tɨna “Nyɨbwaarɨbaangai a'mweraabɨ kotɨya'na maaryawɨbwaradela!” majaga myasaabya'. Aawa. “Nyɨbwaalɨbaangarɨ a'mweraabɨna padaigasamaaja yɨma!” taga kwaaga tabagɨ yasaabɨna ya' Godɨyai. ");
INSERT INTO byr_w_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kabwaalɨbaangarɨna lɨmwagaja pwarɨ Godɨyai kotɨya' maaryawɨbwatei mɨ'. Malɨmwagyaja pwai kotɨya' mena yawɨbwa'nɨgalyɨ. Godɨyale Kawaarɨbaanga yɨmberɨna kamɨre yebyabɨnajɨ malɨmwagaryaja'na kotɨya' mena tɨnɨgesɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kotɨya'na tara tɨnɨ' “Nemɨre kwaaga tabagɨ pwai nebula' nedɨbwaagaga'na Paagei waraabɨna yaga kɨrɨ' a'mwera kayaa'naya yandɨbɨsara kayaa'nayabwi sɨgɨnyaburɨna wɨbwɨ'nagare. Paagerɨna wɨbwɨ'nagara mɨ'. Sare' tare'nesɨ. Kumɨ yandɨbɨsa kayaa'nayangɨra,” sare'na tɨnɨgesɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sare' tare'nesɨ. Kajaijai kayaa'naya yandei Paagerɨna sɨmɨlɨga wimanɨgai Paageryɨmwɨnna mabyɨ yɨbanɨ'. “Paageryaba pwara nɨmɨre kayaa'nayabwi nanyangambɨga!” taga mabɨbanɨ'. ");
INSERT INTO byr_w_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Sara yandaasɨ kɨrɨ' pwai nebula'na tewaanna yandei Paageryɨmwɨnna nabyaa pɨbanɨ'. “Paageryaba kwawa'mujɨ pwara yabwɨsa'na ‘Godɨyarɨ wɨya sa tewaanna sɨbanɨga!’” taga kaanna pɨbanɨgalyɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","(Sonɨ lɨbamabya yaagai wɨjaa'.) “Kamɨ Naangei nyabɨlabɨgalyɨ. Nɨmɨ naangeinyɨ myɨma'nɨmwɨneinyɨ. Nɨmɨ wabeinyɨ yɨma'nɨmɨdeinyɨ,” wɨdɨna ya' Sonɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Munyabadaa'nyɨ tɨragɨnyai waraabagai wɨyainaabɨ newabɨlabɨgalyɨ. Kwaagebagɨdaa'nyɨ pwaina Kwaagebagɨyaina kwaagebagɨyabwi wɨdɨna, kwaajɨ kwaajɨ yagaala wɨdɨna yandaanyaine. Sugunyabɨdaa'nyai wɨyainaabɨ newabɨlabɨgalyɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Sai Godɨyaryaba tewaanyabwi tɨnya wanganagangɨ kadɨga wɨ'nagangɨ sangɨna salɨguragɨna. Sare salɨguragɨna kya' kɨrɨ' aane pwai kwai kadɨga wɨ'naga kamɨre yagaala' mwɨ'nya'. Aawa. ");
INSERT INTO byr_w_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pwai kamɨre salɨguragya' taapɨna yage' yɨ “Gotɨyai nebula'nayai!” tɨragɨnna tɨna ya'. ");
INSERT INTO byr_w_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Sare' tare'nesɨ. Sagwarɨ Godɨyai yasaabɨna kya' Godɨyale yagaalangɨ wɨdɨbwaagɨna. Sare' tare'nesɨ. Godɨyai sagwarɨna kamɨre Kuryarɨ wɨjaabɨna ya'. Godɨyai kamɨre Kuryarɨ wabe'na wɨjaabagarɨna mɨ'. Naanga wɨyabwi wɨjaabagarɨna. Godɨyai kamɨre Kuryarɨ yɨnagu wɨjaabaga'na sai Godɨyale yagaala' nayaa wɨdɨna neya'. ");
INSERT INTO byr_w_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Kawaarɨbaangarɨna Kanɨmaangarɨ tewaanya wɨbu'nanda yɨraaya yanda tɨragɨnyajɨ wɨyajɨ mwangɨna yanda wɨdɨna “Wɨya tɨmaremwaara!” wɨdagarɨna. ");
INSERT INTO byr_w_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kawaarɨbaangarɨ nabyaa lɨmwagatei kaala wɨyagaa' wɨyagaa'nebwi kɨnɨnnɨgalyɨ. Kwai Kawaarɨbaangarɨ malɨmwagaradei kaalabwi tɨnya mwanganyɨ. Aawa. Godɨyarɨ sɨnya sɨmɨrɨga wɨryabwi sagwarɨ kuna wɨwarɨgalyɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Sarebɨdaa'nyɨ Sudaajai ya'ma'na yagagaa' Jisaasi wɨdɨna “Tagaa' A'mweraabɨne Kwaimɨraabyai paa'nɨgai yɨma'nɨmaga. Tagaa' kamɨnyɨna Godɨyai paa'nɨgai yɨma'nɨmaga. ");
INSERT INTO byr_w_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kamɨnyɨna Godɨyai paa'nɨgai yɨma'najai A'mweraabɨne Kwaimɨraabyarɨ paa'nɨgarɨ wɨmwaaigadelyɨ. Yɨme'nyapɨ' paa'nɨgarɨ wɨmwaaigadelyɨ. ");
INSERT INTO byr_w_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nɨmnya kwaimɨraabyalabi, tɨbi wabegaa'/wɨbegaa' semɨnyaba kuna mwaaigeinyɨ. Pɨrɨna yapɨjɨ kɨrɨ' Sudaayaraabɨ wɨdɨmwatebaaimbɨ' tagaa' yɨnggɨdɨbaiga. Nɨmɨ wɨmwɨjamwɨ tɨwindelai mɨ'. ");
INSERT INTO byr_w_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Yagaaigɨmwɨnya mudɨga' yɨnggɨjaabaiga. Sɨnggya'mweraabɨna tewaanya yɨnggɨbu'nana! Nɨmɨnyɨ semɨnyɨna tewaanya nyɨbu'nandebaaimbɨ' semɨnyɨ sɨnggya'mweraaabɨna tewaanya yɨnggɨbu'nana! ");
INSERT INTO byr_w_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Semɨ sara yɨnapɨjɨ saburɨdaa'nyɨ a'mwe wɨyara semɨnyɨna yabwɨ'na ‘Sagwara Jisaasɨlerera.’ Yɨ semɨnyɨ wɨbu'nyabwi waraja' sara yabwɨ'na yɨnggyɨpɨtelabilyɨra.” ");
INSERT INTO byr_w_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Yo, sare' tare'nesɨ. Nɨmɨ yagaala tewaanyabɨna wagɨla manyɨbwa'nyandeinyɨ. Sare' tare'nesɨ. Yagaala tewaanya sa' kajarajara lɨmwagapɨjaraabɨ Godɨyai wɨbadaigasamaarya'ne sa' Godɨyare tɨragɨnya tɨ'nagesɨ. Tɨragɨnya Sudaayaraabɨdaa'nyɨ nabaai Sudaayara mamwaaryɨgasaraabɨjɨ wɨbadaigasamaarya'nesɨ. ");
INSERT INTO byr_w_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","……Sare' Godɨyare pugwɨyabɨ tara tɨnɨgabaaimbɨ'nanyɨ, “Pwai Godɨyarɨ lɨmwagate sarerɨna ‘Yɨda'maraangerɨ wɨmwaaigɨmwa,’ tojɨyai wɨyagaa' kaala mwaaradelyɨ.” ");
INSERT INTO byr_w_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Yɨ kadatarebɨnyaga! Nemɨ Sudaayaina a'mwe pwaraabɨ wabɨlabaanneina tɨgaga! Aawa nebulyasɨ. Sare' tare'nesɨ. Nemɨ sɨdasa'na tɨbi'na tɨmwo “Yɨ wɨyaina wagɨlyabɨ kwaagemwɨ mwaaigoinera Sudaayainajɨ Anga Pimaginya (Kɨrikɨya) kwarajɨ.” ");
INSERT INTO byr_w_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Sabaaimbɨ' tara tɨnɨgesɨ. Godɨyaryaba yɨda'maraanga aane pwai kwai mɨ'. Arɨgemwɨnyɨ. Aane pwai kwai mamwaaryɨ'. ");
INSERT INTO byr_w_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","A'mwe pwai sɨmunya wɨwarɨgei mɨ'. Godɨyarɨna pwai pɨrɨbɨrya yɨbanɨgei mɨ'. ");
INSERT INTO byr_w_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Yɨ wɨyara Godɨyarɨ yagarya'ma'mwaasare. Wɨyara yɨragureba waryaanyara yɨma'nɨmwaasare. Nabwɨ'nyabwi yande aane pwai mɨ'. Sasarei aane pwai kwai mamwaaryɨ'. ");
INSERT INTO byr_w_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Taarɨsabɨdaa'nyɨ kɨrebudɨrɨnyabɨ newinɨbanɨga wɨdandɨbɨsare. Taarɨsasɨ kwaajɨ yagaala wɨdandɨbɨsare. Naawɨnaanyale kwaamɨnya' a'mweraabɨ tamagandebaaimbɨ' Yagaala nabinabinya kayaaga yɨgalya'ne wɨdandɨbɨsare. ");
INSERT INTO byr_w_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","A'mweraabɨ kayaaga tɨragɨnna yɨgalya'ne Yagaala kayaa'nayanna paasiyagaala wɨdandɨbɨsare. ");
INSERT INTO byr_w_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Yɨgwɨkaannagera a'mwe tamya'nera Yarai kaanyɨbe'na yamaryandɨbɨsare. ");
INSERT INTO byr_w_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Kayaaga yɨgalagyɨ'nera wɨna yadɨbɨ' Taanginya kwaraarya wɨjaayɨ'nera wondɨbɨsare. ");
INSERT INTO byr_w_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Kwaamu'nanyaburɨne nagarya' yabwɨramaatɨbɨtara mɨ'. Pwarajɨ abaaijɨmunyabwi ye'mwannamwaaindɨbɨtara mɨ'. ");
INSERT INTO byr_w_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“Godɨyai Naangelyɨra,” myabwɨryɨ yandɨbɨ' Kumɨre tɨnyaraabɨ Godɨyarɨne lɨgebwi mwaryɨga. Godɨyale pukwɨyabɨ sara tɨnɨgengɨra. ");
INSERT INTO byr_w_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Nabaai sara tɨnɨgenna nemɨ yabwɨ'mwo. Wɨya Kɨmwɨnya tɨnɨge nemɨ Sudaayaina saburɨ talaangemwɨ wɨra'nata yɨgoina sara ya'ne tɨnɨgengɨ. Sare' kɨrɨ' Sudaayainaabɨna tajabwi yɨnggɨdɨmwebwi yɨwetawagya warɨgesɨ. Sarebɨdaa'nyɨ Godɨyai yawɨbwata'negaa' nemɨrebwina “Sudaayarajɨ maanga pɨpaina yɨpɨga! Nabaai a'mwe wɨyamwɨnyara nɨmɨnyɨna yɨwetawagya sabwi kɨnɨnnagera mwaaimbɨga!’ taga Kɨmwɨnya kɨnɨnnɨgeinaabɨ talaangemwɨ nemaarurawagageine. ");
INSERT INTO byr_w_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Sare'na tarebɨnyɨ. Godɨyale yawɨbwata'nebwina Kɨmwɨnya saburɨ mɨdɨnyabɨna “A'mwe yɨda'maraangeigɨnyɨ. Nɨmɨreiginyɨ,” Godɨyai kɨraa'naga aane pwarɨ kwarɨ wɨdade' mɨ'. Aawa. Sare' tare'nanyɨ. Kɨmwɨnya sabwi nemɨre wagɨla saburɨ yɨne'na neyɨbwarɨdaakwɨbanɨgesɨ sagɨrɨ'na. ");
INSERT INTO byr_w_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Nabaai tagaa' Godɨyai a'mweraabɨ kamɨre yɨda'maraanga sabwi kamɨnyɨ yɨda'maraangeraabɨ wɨmwaaigya'nebwi wi'na neyɨbwarɨdaakwagebulyɨ. Sa' kɨmwɨnyaburaabɨ mɨdɨnya'nebɨdaa'nyɨ myɨma'nyagesɨ. Aawa. Sa' pɨrɨbɨ yɨma'nagesɨ. Kɨrɨ' pɨgarɨgurya Kɨmwɨnyasɨ wɨ'nawɨdɨbwaagyaasaraabɨre tɨnɨgesɨ nabwɨ'nya yɨda'maraanga tajabwina salɨkuragɨnɨgesɨ. ");
INSERT INTO byr_w_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Yɨ Jisaasi Kɨraajɨtɨyarɨ lɨmwabɨjaraabɨna Godɨyai “Yɨda'maraangeraabɨ nɨmɨreraabɨ wɨmwaaigɨma!” tadelyɨ. Yɨ lɨmwabɨja wɨyaraabɨnesɨ. Sare' padaigasamaasabwi tare'nesɨ. A'mwe Sudaayarebwi nabinyabwi mɨ'. Anga naanga pimagɨnya pwai kwarebwi nabinyabwi mɨ'. ");
INSERT INTO byr_w_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Sare' tare'nesɨ. Wɨya a'mwera Sudaayarajɨ anjɨmya wɨyangɨyarajɨ wagɨlya'nebwi yandɨbɨsare. Godɨyai paaga tɨragɨnyasɨyaryaba menyaba mwaaigasare. ");
INSERT INTO byr_w_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Sasareraabɨ Godɨyai yange'na tewaanna wɨgaimwanda Kɨraajɨtɨyai Jisaasɨrɨ kamaryasaaba' sagwai ayagi mubya yamaaryɨ'nei sara kya' Godɨyai “A'mwe yɨda'maraangelalyɨra. Nɨmɨrelalyɨra,” wɨdɨna. Sa'na sagwara mamubyandɨbɨsare. Sa'na Kɨraajɨtɨyarɨ sɨgumalesɨ. ");
INSERT INTO byr_w_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Sɨnyamwɨ Gotɨyai Kɨraajɨtɨyarɨ tagɨlagagei paraga kamɨre tawe' a'mweraabɨre wagɨla sa' mumbya'ne' waraabagesɨ. Gotɨyarɨ a'mweraabɨre wagɨlyabwina sɨnya tɨga wɨdatebulyɨ. Kɨraajɨtɨyarɨ lɨmwabɨjaraabɨna sɨnya tɨga sabwi mumbamaarasɨ'nya'nei paragelyɨ. Yɨ nabaai sasare saburɨ Godɨyai “Nɨmɨ yɨda'maraangeinyɨ yɨda'na yandɨnyainyɨ,” neyɨbwarɨdaakwagebulyɨ. Sare' tarebɨnyɨ. Kɨgaa' Godɨyai kwaamu' kabe yemwaainda a'mweraabɨre kayaa'nayanna yeta sabwina wanganagɨna. ");
INSERT INTO byr_w_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Kɨrɨ' “‘Godɨyai yɨda'maraangei mɨga!’ nadɨpɨndɨga!” taga tadagaasagaa' Godɨyai “Nɨmɨ yɨda'maraangeinyɨ yɨda'na yandɨnyainyɨ,” taga sara neyɨbwarɨdaakwia'nei Kɨraajɨtɨyarɨ maryasaabagelyɨ. Sasare saburɨ Godɨyai kamɨ sai yɨda'maraangerɨna neyɨbwarɨdaakwanda yɨ a'mwe wɨyaraabɨnei Jisaasɨrɨ lɨmwagajarɨna “A'mwe yɨda'maraangelyɨ. Nɨmɨrelyɨra,” tandelyɨ. Yɨ wɨyaraabɨ wɨlɨmwabɨjaraabɨ sara wɨdandelyɨra. ");
INSERT INTO byr_w_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Sarebɨdaa'nyɨ Godɨyai “Yɨda'maraangelalyɨ,” nedage'na yɨ nagarya' a'mweraabɨne yebya makyɨrya'nebwi kaba warɨga! Yɨ wana aawaawa. Nagarya sarɨ' kaanya mena ligɨ'nɨgesɨ. Nagarya tajarɨgɨ perɨ' tagarigɨ'narɨ'? Godɨyale Kɨmwɨnyaburɨ mɨdɨnya sabɨ tɨgaga? Aawa. Sabɨna mɨ'. Aawa. Kɨraajɨtɨyarɨ lɨmwanga saburɨ sagɨrɨ' nagarya sarɨgɨ kalalɨmwamanɨ'. ");
INSERT INTO byr_w_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Sare' tare'nesɨ. Nemɨ tɨragɨnna tara tandaanyɨ “Godɨyai a'mwei Kɨraajɨtɨyarɨ lɨmwagajarɨ tɨbanɨgelyɨ ‘A'mwe sai yɨda'maraangelyɨ. Nɨmɨrelyɨra.’” A'mwe Kɨmwɨnyaburɨna yaamɨjɨ yune mɨdɨnajarɨna Godɨyai sara majandelyɨ. ");
INSERT INTO byr_w_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","A'mweraabɨne yebya mamakɨrya'ne' pɨbwi tarɨga? Tare' sabwɨryɨla! Godɨyai sai Godɨyai Sudaayaraabɨnannei taaga! Anjɨmya wɨyangɨyarajɨyaraabɨne Godɨyai mindaaga! Yayo! Godɨyai sai anjɨmya wɨyangɨya pwara kwaraabɨjɨnelyɨra. ");
INSERT INTO byr_w_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Godɨyai kambe pwaina Naangelyɨ. Sarebɨ Sudaayara kɨraagejɨ' kurya tatɨbɨsara Kɨraajɨtɨyarɨ lɨmwambɨjaraabɨna “Yɨda'maraangerera,” tanda nabaai anjɨmya wɨyangɨyara kɨraagejɨ' kurya madabyandɨbɨsara Kɨraajɨtɨyarɨ lɨmwambɨjaraabɨnajɨ abaaina tɨbanɨgelyɨ. ");
INSERT INTO byr_w_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Sarebɨdaa'nyɨ lɨmwanga tajabɨ yɨda'maraangeina yɨma'nandaanya'na Kɨmwɨnya sabwi tadadɨbaimaigona? Arɨgemwɨnyɨra. Aawa. Kɨmwɨnyabwi nebulya'na yɨda'na marɨdaakwia yɨbaigo. ");
INSERT INTO byr_w_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Sarebɨdaa'nyɨ yɨ tagaasagaa' Kɨraajɨtɨyai Jisaasɨrɨ wɨramwaaigasaraabɨna yagaala yawɨbwata'ne sɨdata'ne mwaryɨ'. ");
INSERT INTO byr_w_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Sare' tare'nesɨ. Kɨraajɨtɨyai Jisaasi yagebɨ Kuryai kaala kɨjaabanderebwi kayaa'nayabulyɨ yune naanga paryabulyɨ saburaai mena wɨla kyɨtalamaara'. ");
INSERT INTO byr_w_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Yɨ sare' tare'nesɨ. A'mweraabɨre kɨraagejɨgɨya yabwɨta sabɨna kɨmwɨnyabwi yɨ'neina waryaanyaina mwaaigo'na Kɨmwɨnyabwi kayaa'nayaburɨ padaigasamaa'na myɨ neyannebulyɨra. Sara myɨ yande' Godɨyai sara yagesɨ. Godɨyai kamnya Kabwaalɨbaangerɨ maryasaabagelyɨ. Sarei a'mwe kayaa'nayaimbɨ' kɨraa'nɨgei yɨma'nagelyɨ. Kamɨ a'mweraabɨre kayaa'naya pwaramarasɨ'nyɨ'nei waraabagelyɨ. Yɨ a'mweraabɨ kayaa'nayabwi wɨrarɨgeburɨ Godɨyai sɨda'na kya' Kɨraajɨtɨyai a'mweraabɨneba kayaa'nayanne tɨbɨgɨta'na paragelyɨ. ");
INSERT INTO byr_w_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Godɨyai nemɨnyɨna “Sagwara kɨmwɨnyabwi tagɨnɨga yɨda'maraangengɨ yuna yandɨbɨsaraabɨ wɨmwaaigɨma!” kada' sara paragelyɨ. Sareina a'mweraabɨre kɨraagejɨgɨya yabwɨta sabɨ kaanya myamaryandaanyɨ. Aawa. Nemɨ Kurya Tewaanya sarɨ kaanya yamaryandaanyainaabɨnesɨ. ");
INSERT INTO byr_w_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Sare' tare'nesɨ. A'mwera a'mweraabɨre kɨraagesɨyara kumɨre sɨmunyangɨ kɨraagejɨgɨyanna yabwɨrirɨgɨtɨbɨsare. Nabaai Kuryaryɨyara kumɨre sɨmunyangɨ Kuryalenna yabwɨrirɨgɨtɨbɨsare. ");
INSERT INTO byr_w_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Sare' tare'nesɨ. Kɨraagejɨgɨya sɨmunyabɨ a'mwe sara yune naanga paryabwi Godɨyarɨna kɨmaja yɨremwaaryabwi maa'maigasare. Yɨ nabaai Kurya Tewaanyale sɨmunyabɨ a'mwe sara kaalyasɨ sɨmunya kwaamu'nayasɨ maa'maigasare. ");
INSERT INTO byr_w_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Sarebɨ kɨraagejɨgɨya yabwɨta sa' sɨmunyangɨ maremwaarajara Godɨyale yɨgamaangera yɨma'nɨmwaasare. Kɨraagejɨgɨya sɨmunya' Gotɨyarɨna yɨgamaangesɨ. Sare' tare'nesɨ. Sagɨrɨ' Godɨyale Kɨmwɨnyabɨ wɨra'nate' mɨ'. Tare'nesɨ. Yɨ nabaai sagɨrɨ' sara yɨnɨga yanne' mɨ'. ");
INSERT INTO byr_w_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Kɨraagejɨgɨyangɨ mwaaindɨbɨ' a'mwe sarera Godɨyarɨ yɨraaya wigarya'nera mamwaaryɨ yɨpɨnere. ");
INSERT INTO byr_w_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Semɨ kɨraagejɨgɨyangɨ mamwaaryɨga'. Aawa. Godɨyale Kurya Tewaanyai semɨnyɨ wɨrayɨnggɨmwaaindori Kurya Tewaanyarɨ wɨramwaaigasalalyɨ. Nabaai, yɨ pwai kwai Kɨraajɨtɨyale Kurya Tewaanyai maayai a'mwe sai Kɨraajɨtɨyalei mɨ'. ");
INSERT INTO byr_w_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Nabaai Kɨraajɨtɨyai semɨnyɨ wɨrayɨnggɨmwaarajai yɨ pɨrɨ' taresɨ. Kayaa'nayabwine'na semɨre kɨraagejɨ' paradejɨgɨra. Yɨ pɨrɨ' taresɨ. Semɨnyɨna Godɨyai “Yɨda'maraangelai nɨmɨrelalyɨ,” mena yɨnggɨdage'na Kuryai kaala mena yɨnggɨmwaaigagelalyɨ. ");
INSERT INTO byr_w_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Godɨyai Jisaasɨrɨ painɨgeraabyamwɨ yɨdɨgaabagere Kuryai semɨnyɨ wɨrayɨnggɨmwaaindanari Kɨraajɨtɨyai Jisaasɨrɨ paryarɨ yɨdɨgaabagei semɨ parapɨjɨyagaa' semɨre kɨraagejɨgɨ kaala yɨnggɨjaabadelyɨ. Kuryai semɨnyɨ wɨrayɨnggɨmwaaindebɨ kɨraagejɨgɨ kaala yɨnggɨjaabadelyɨ. ");
INSERT INTO byr_w_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Yɨ sarebɨdaa'nyɨ, nya'mwelai, nemɨ tɨbɨgɨta wɨjaabya'ne kɨnɨnnageine. Tɨbɨgɨta sa' Kurya Tewaanyarɨ mwaaryɨ'nesɨ. Kɨraagejɨgɨya yabwɨsangɨna tɨbɨgɨta aawa. Nemɨ kɨraagejɨgɨya yabwɨsangɨna mwaaryɨ'ne tɨbɨgɨta mwaryɨ'. ");
INSERT INTO byr_w_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Sare' tare'nesɨ. Semɨ kɨraagejɨgɨya yabwɨsangɨna mwaaimbɨja' yɨ semɨ yune naanga tɨbaryɨra. Kɨrɨ' Kuryale tɨragɨnyabɨ semɨ kɨraagejɨgɨya yabwɨsa ya tamagɨpɨja' yɨ kaala tɨmwaaryindelalyɨ. ");
INSERT INTO byr_w_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Sare' tare'nesɨ. Godɨyale Kurya Tewaanyai kajarajaraabɨ wibwarɨdaakwɨbanɨgera yɨ sagwara Godɨyale kabwaalɨbaangere. ");
INSERT INTO byr_w_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Sare' tare'nesɨ. Semɨ Godɨyarɨna lɨga ayagi ya'ne' karabujɨwamwɨnyabɨ yɨnggyɨdɨwagamaremwaara yɨnggyande Kuryarɨ mamaaryesalyɨ. Aawa. Kabwaalɨbaangelarɨ yɨnggɨmwaaigaga Kuryarɨ maaresalyɨ. Yɨ sagwarɨ, nemɨ Godɨyarɨ saga tandaanyɨ “Tataala! Nɨmwala!” ");
INSERT INTO byr_w_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Kuryai kamɨ sagwai nemɨre kuryarajɨ nemɨ Kɨraajɨtɨyarɨ lɨmwandaanyainaabɨna tara salɨgurakɨbanɨ' “Gotɨyale kwaimɨraayalalyɨra.” ");
INSERT INTO byr_w_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Nabaai Godɨyale kwaimɨraayaina mwaraaja' Nɨmwai sare wɨya tewaanya maraadeinera. Pɨrɨ' taresɨ. Godɨyale wɨya tewaanya maraadeinera. Pɨrɨ' taresɨ. “Kɨraajɨtɨyalyɨ paaga tɨragɨnya' maraana!” tawaajɨ Kɨraajɨtɨyalyɨ taanginya ye'mwannamaraaja' Kɨraajɨtɨyai wɨya tewaanya maarade ye'mwannamaraadeinera. ");
INSERT INTO byr_w_vpl VALUES ("HB1_1","088_1_1","HEB","1","1","1","Kɨgaakuna kwala naangegaa' Godɨyai kamɨnyɨ wɨ'nawɨdɨbwaagyaraabɨ sɨmunya pɨnɨnna pɨrɨ' wɨdɨna, pɨnɨnna pɨrɨ' wɨdɨna. Yɨ sara kujaa' sagwara nemɨre Ne sɨnyamwɨnyaraabɨ sɨmunya nabinabinya pɨbura wɨjaasara kwaraaryare. ");
INSERT INTO byr_w_vpl VALUES ("HB1_2","088_1_2","HEB","1","2","2","Kɨrɨ' nabaai tagaa' aayagasa Godɨyai yagaala nedage' kamɨre Kabwaalɨbaangei nedagesɨ. Sagwarɨ Kanɨmaangele wɨya maaryɨ'nerɨ Godɨyai mena tagɨlakagelyɨ. Nabaai Kabwaalɨbaanga sagwarɨ Kwaaga tasɨ sugunya kɨrɨsɨ Godɨyai yabɨgaryaagengɨ. ");
INSERT INTO byr_w_vpl VALUES ("HB1_3","088_1_3","HEB","1","3","3","Kabwaalɨbaangei sagwai Godɨyale paaga tɨragɨnyabɨ lɨbamwaja naangelyɨ. Yɨ nemɨnyɨ Paaga naanga nemwadandelyɨ. Sagwai Godɨyarɨ abaaina nebulya'nayalyɨ. Kamɨre yagaala tɨragɨnya kɨnɨnnɨge' tanda wɨyangɨ tɨragɨnya yɨbaimwanda wɨya sarengɨ lɨmwagatelyɨ. Kayaa'nayangɨne tɨbɨkɨsa tuimwagasɨta yɨ'ne' sagwai wamwɨnya yunebanna yɨ'mwannaga Kingɨya Naangei munya kepeba mwaarɨgele aangajimagɨ tɨragɨnnɨgeba mwaara'. ");
INSERT INTO byr_w_vpl VALUES ("HB1_4","088_1_4","HEB","1","4","4","Kabwaalɨbaangei Kanɨmaangerɨ yebya tewaanya nawɨ'nyaange' mena maarage' yɨ mamaayaraabɨre yebyabɨ wabɨlabagabaaimbɨ' yɨ sasare sagɨrɨbɨ kamɨ sai mamaayaraabɨna naanga nebulya'na yɨma'nagelyɨ. Yɨ sagwara sarɨ kwaagemwɨ wɨra'nagasalyɨ. ");
INSERT INTO byr_w_vpl VALUES ("HB1_5","088_1_5","HEB","1","5","5","Sare' tarebɨnyɨ. Sɨnyamwɨ sagaa' Godɨyai mamaayarajɨya aane pwai kwarɨ tara mwɨja' “Kɨmɨ nɨmɨnyɨ nyɨmbwaalɨbaangeiginyɨra. Tagaa' kɨmaamaangeinyɨ kɨmwaaigɨmweiginyɨ.” Kɨrɨ' Kabwaalɨbaangerɨ sara wɨda'. Yɨ sagwai mamaayarɨna ayagi mwɨja' “Kamɨnyɨ kanɨmaangeinyɨ yɨma'nɨmɨdeinyɨ. Nɨmɨnyɨ nyɨmbwaalɨbaangei yɨma'nadelyɨ.” ");
INSERT INTO byr_w_vpl VALUES ("HB1_6","088_1_6","HEB","1","6","6","Kɨrɨ' Kwaagebagɨ mwaaryaraabyɨmwɨnna sagwai kamɨre aaya mudɨgwaimɨraabyarɨ makwaraabagegaa' sarei ta' “Mamaaya wɨya Godɨyainyɨrera sagwarɨ yɨraaya nabyaa maripɨga!” ");
INSERT INTO byr_w_vpl VALUES ("HB1_7","088_1_7","HEB","1","7","7","Nabaai sagwai mamaayaraabɨna tara ta' “Kamɨre mamaayaraabɨ yɨgwɨjapɨsaraabɨ wɨmwaaigandere. Kamɨre wɨdaayandɨbɨsaraabɨ tɨtaarɨsapɨsaraabɨ wɨmwaaigandere. ");
INSERT INTO byr_w_vpl VALUES ("HB1_8","088_1_8","HEB","1","8","8","Kɨrɨ' Kabwaalɨbaangerɨna tara ta' “Godɨyaigi, wɨyagaa' wɨyagaa'ne kingɨnamwaaryɨsabɨ tɨmaremwaaideiginyɨ. Kɨmɨre a'mweraabɨ kingɨyɨsarɨsɨ yɨda'nanyabwina yawɨbwaramaremwaaindɨnyaiginyɨ. ");
INSERT INTO byr_w_vpl VALUES ("HB1_9","088_1_9","HEB","1","9","9","Kɨmɨnyɨ yɨda'maraanga sabwina tewaanya kɨbu'nandeiginyɨ. Kɨmwɨnyangɨ kalajegɨbaryabwina sɨmɨlɨga kwimwaarɨgeiginyɨ. Mɨdɨnɨnyabɨdaa'nyɨ Godɨyainyɨ kɨmɨre Godɨyainyɨ yɨrewelɨya' kɨdɨngeiginyɨ. Yɨ welɨya taja' kɨmɨnyɨ yɨraaya kyɨgalageiginyɨ. Sa'mwera yɨbaigɨnyabaaimbɨ' yɨraaya yɨbaigatara mɨ'.” ");
INSERT INTO byr_w_vpl VALUES ("HB1_10","088_1_10","HEB","1","10","10","Nabaai Kabwaalɨbaangerɨna tara ta' “Naangeigi sɨnyamwɨ Kwaaga tada' wagyaanyaiginyɨ. Nabaai sugunya' kɨmnya ajɨraalyɨ yabɨgaryaanyaiginyɨ. ");
INSERT INTO byr_w_vpl VALUES ("HB1_11","088_1_11","HEB","1","11","11","Wɨyabaai yɨnagu kayaaga yɨnyɨna yadebaalyɨ. Kɨrɨ' kɨmɨ aawa. Wɨyagaa' mwaaindɨnyaiginyɨ. Wɨyabaalyɨ wɨya pɨnɨjɨ aya yɨma'nadengɨ. Paajɨ'ma'nya pɨrɨ' aya yɨma'nyɨna yadebaaimbɨsangɨ. ");
INSERT INTO byr_w_vpl VALUES ("HB1_12","088_1_12","HEB","1","12","12","Yɨ yɨbɨja aya' kɨ'mwagakɨna yadebaaimbɨ' Kɨmɨ wɨya sangɨ tɨgɨ'mwagakɨdeiginyɨ. A'mwei paajɨ'ma'nya yadaigamaa'na yandebaaimbɨ' Kɨmɨ wɨya sangɨ yadaigamaata sɨdengɨ. Kɨrɨ' kɨmɨ yuna sana tɨmwaaindeiginyɨ. Kɨmɨre kwaramegaa' wi'na yɨwawade mɨ'.” ");
INSERT INTO byr_w_vpl VALUES ("HB1_13","088_1_13","HEB","1","13","13","Pɨgaa' kɨgaa' Godɨyai mamaaya tarajɨya pewarɨ wɨdagelaga!. Aawa. Kabwaalɨbaangerɨna tara tɨnɨ' “Kɨmɨ nɨmɨre aangasɨrɨ tɨragɨnyaba tɨmwaara! Kɨmɨnyɨ talaangemwɨ wɨra'narya'negaa'na yɨgamaangeraabɨ kwagɨmɨdegaa'nayɨ.” ");
INSERT INTO byr_w_vpl VALUES ("HB1_14","088_1_14","HEB","1","14","14","Aawa. Mamaayara yɨ sagwara kuryarera. Yɨ kurya sagwara Godɨyarɨ wɨdaayandɨbɨsare. Godɨyai a'mwera kamɨre yuna padaigasamaaryɨ'neraabɨna kaimwagya'ne mamaayaraabɨ maryaasandere. ");
INSERT INTO byr_w_vpl VALUES ("J11_1","092_1_1","1JN","1","1","1","Tarei sɨnyamwɨ/sɨnyɨmwɨ kɨgaakuna Kwaaga taba' myɨma'nyamwɨ aayamwɨdaa'nyɨ mwaryaagarɨnesɨ. Sarerɨ Nedasaabandeina wɨmɨdɨnoi kadɨga wɨ'norɨna. Sarerɨ nemɨre tɨnya wanganorɨna. Sarerɨ yabwɨranganorɨna. Sarerɨ nemɨre aja mwanganorɨna. Sagwai Godɨyale Yagaalai wɨyagaa' wɨyagaa'ne kaalaburɨ aaya kaabɨlarɨnesɨ. ");
INSERT INTO byr_w_vpl VALUES ("J11_2","092_1_2","1JN","1","2","2","Kaalaburɨ aaya kaabɨla tajagwai ku'maayabanna yɨma'naabɨna kya' nemɨ tɨnya wanganorɨna. Tɨnya wangano'na nabyaa salɨguragandaa yɨnggɨdandaanyɨ. Wɨyagaa' wɨyagaa'ne kaalaburɨ aaya kaabɨlai kɨgaakuna Nɨmwaryɨ ye'mwannamwaaryaagalyɨ. Sare sai ku'maayaba neyɨjɨwaainadaa'nyɨ sarɨ tɨnya wanganorɨna. ");
INSERT INTO byr_w_vpl VALUES ("J11_3","092_1_3","1JN","1","3","3","Sagwarɨ tɨnya wanganona kadɨga wɨ'no sarɨna semɨnyɨjɨ yɨnggɨdɨbaigo. “Nemɨjɨ abaaijɨmunya ye'mwannamwaaraana!” tona yɨnggɨdɨbaigo. Yɨbaai nemɨre ye'mwannamwaarya' taresɨ. Nɨmwaryɨ kamɨre Kawaarɨ' Jisaasi Kɨraajɨtɨyaryɨ abaaijɨmunya ye'mwannamwaaigoinera. ");
INSERT INTO byr_w_vpl VALUES ("J11_4","092_1_4","1JN","1","4","4","“Abaaijɨmunya ye'mwannamwaarya'nebɨna yɨraaya naanga yɨnebanna newarana!” tona yagaala taja' yɨda'maigo. ");
INSERT INTO byr_w_vpl VALUES ("J11_5","092_1_5","1JN","1","5","5","Yagaala ta' Kɨraajɨtɨyai kaneda' kadɨga wɨ'nona yɨnggɨdɨbaigo. Sa' taresɨ. Godɨyai paagebɨ aaya kaabɨlalyɨ. Sagwarɨ sɨgɨnya wabe aane pɨrɨ' kɨrɨ' mwɨwarɨgalyɨ. ");
INSERT INTO byr_w_vpl VALUES ("J11_6","092_1_6","1JN","1","6","6","Sare'na sɨgɨnyabɨ kayaa'na mwaaindaa kwaajɨ taaja' “Sagwaryɨ abaaijɨmunya ye'mwannamwaaigeinyɨ,” kwaajɨ yagaala tandaa yagaala nebwina sa'neburɨ myɨbaigo. ");
INSERT INTO byr_w_vpl VALUES ("J11_7","092_1_7","1JN","1","7","7","Aawa. Paagebɨ tewaanna mwaaindebaaimbɨ' paagebɨ tewaanna mwaaraaja'na Kɨraajɨtɨyale pwarajɨ abaaijɨmunya se'mwannamwaaigo. Yɨbaai tewaanna mwaaraaja'na Godɨyale Kawaarɨbaangai Jisaasɨle tawebɨ nemɨre kayaa'naya wɨyabwi nemaarasɨ'nanda tawe sagɨrɨ' kɨrɨga neduimwagasɨ'nade'nanyɨ. ");
INSERT INTO byr_w_vpl VALUES ("J11_8","092_1_8","1JN","1","8","8","Nemɨ tɨnyɨna “Nɨmɨ kayaa'nayabwi kuneinyɨra,” tɨnaaja' sɨmunyangɨ kwaajɨ yabwɨtaanyainera. Sarebɨ nebula' nemɨre sɨmunyangɨ wɨranewate' mɨ'. ");
INSERT INTO byr_w_vpl VALUES ("J11_9","092_1_9","1JN","1","9","9","Nemɨre kayaa'nayanna salɨguragɨnaaja' Godɨyai “Kumɨre kayaa'naya maarasɨ'nɨma! Kumɨre kɨrɨgisa'naya wɨya, yɨ yɨda'maraangabwi maaya wɨyaburɨ tuimwagasɨ'nɨma!” tajɨ “Kayaa'naya maarasɨ'nɨmɨdeinyɨ,” tɨnɨga'na nabyaa lɨmwannɨgai, yɨda'maraangai mwaarɨgai sara yadelyɨ. ");
INSERT INTO byr_w_vpl VALUES ("J11_10","092_1_10","1JN","1","10","10","Yɨbaai Godɨyai neda' “Wɨyalabi kayaa'naya yɨgasalabilyɨra.” Sarebɨdaa'nyɨ nemɨ “Kayaa'naya myɨgeinyɨ,” tɨnaaja' Godɨyarɨna tɨna “Sagwai kwaajɨ yagaala tandelyɨ.” Nemɨ kwaajɨ sara taaja' kamɨre yagaala' nemɨre sɨmunyabɨ wɨranewate' mɨ'. ");
INSERT INTO byr_w_vpl VALUES ("J12_1","092_2_1","1JN","2","1","1","Nɨmɨre kwaimɨraabya wabelabi, yagaala taja' pɨgarɨguri yɨnggidawasɨbaiga. Semɨ kayaa'naya myɨpɨne'na “Wɨdɨbwaagɨma!” tena yɨnggidawasɨbaiga. Sare' kɨrɨ' a'mwe pwai kwai kayaa'naya' yaja' nemɨnyɨne kayaa'nayanna Nɨmwarɨ marewɨdandei mwaarɨ'. Sagwai Jisaasi Kɨraajɨtɨyai yɨnda'maraangalyɨ. ");
INSERT INTO byr_w_vpl VALUES ("J12_2","092_2_2","1JN","2","2","2","Sarei nemɨre kayaa'nayanna Godɨyarɨ sɨnya sɨmɨrɨga widebwi mubamaarasɨ'nyɨ'nei paragalyɨ. Nemɨrenna yɨmbenna mɨ'. Aawa. Kwaaga wɨya tabagɨyara anjɨmyaraabɨne kayaa'nayannanyɨra. ");
INSERT INTO byr_w_vpl VALUES ("J13_1","092_3_1","1JN","3","1","1","Yɨdaanyi! Nɨmwai nemɨnyɨne kare naanga wimagelyɨ. “‘Nɨmɨre kwaimɨraabyara,’ dɨma!” taga Kɨraajɨtɨyarɨ lɨmwandaanyainaabɨna kare naanga windeine. “Godɨyainyɨre kwaimɨraabyarera,” tage' nebulasɨ. Kamɨre kwaimɨraabyainera. A'mwe Kwaagebagɨyabwinera Kɨraajɨtɨyarɨna myabwɨresabɨna “Kamɨre kwaimɨraabyarera,” maneyabwɨribaigya'. ");
INSERT INTO byr_w_vpl VALUES ("J13_2","092_3_2","1JN","3","2","2","Nyɨbu'nandelabi, tagaa' nemɨ Godɨyale kwaimɨraabyaine. Tɨbi nemɨ pewarabɨsaina yɨma'nabaadeinaabaga'? Sabɨ myabwɨranganyaine. Kɨrɨ' nemɨ tara yabwɨ'maigo. Tɨbi sagaa' Kɨraajɨtɨyai ku'maayaba yɨma'naabadegaa' kamɨ sagwaimbɨ' yɨma'naadeine. ");
INSERT INTO byr_w_vpl VALUES ("J13_3","092_3_3","1JN","3","3","3","Yɨbaai sai tewaanyai kɨrɨgisa'naya kunei mwaarɨgabaaimbɨ' a'mwe kajaijai sagwarɨna sara yemwaarɨgai Kɨraajɨtɨyarɨna tewaanyai yɨma'nɨbanɨgalyɨ. ");
INSERT INTO byr_w_vpl VALUES ("J15_6","092_5_6","1JN","5","6","6","Tajagwai Jisaasi Kɨraajɨtɨyai aaryabɨ lɨbamabya yabɨnesɨ kamɨre tawe' waraabaga paragabɨnesɨ Sugunyabɨdaa'nyai waraabaga'nanyɨ. Yɨne aari lɨbamabya sabwinebɨna waraabagai mɨ'. Aawa. Aaryabɨnebwinajɨ tawebɨnebwinajɨ waraabagalyɨ. Kuryai nebulabɨ aaya kaabɨlarɨne'na Kurya sagwai yagaala sa'na salɨguragadelyɨ. ");
INSERT INTO byr_w_vpl VALUES ("J15_7","092_5_7","1JN","5","7","7","Salɨguragya tabaai tasa warɨgannanyɨ. ");
INSERT INTO byr_w_vpl VALUES ("J15_8","092_5_8","1JN","5","8","8","Yɨ pwai Kuryai, yɨ pɨrɨ' aarya', yɨ pɨrɨ' tawe'. Tabaai tata sa yagaala yɨmbe pɨrɨ'naya' salɨkuragandesɨ. Salɨguragya sa' taresɨ. Jisaasi Godɨyale Kawaarɨbaangalyɨ. ");
INSERT INTO byr_w_vpl VALUES ("J15_9","092_5_9","1JN","5","9","9","A'mwera salɨguragɨpɨja' “Nebulasɨ,” tandaanyɨ. Yɨdaanyi! Godɨyai salɨguragya' a'mweraabɨrebɨ wɨwabɨlabɨgasɨ. Sarebɨdaa'nyɨ Kawaarɨbaangarɨna Godɨyai nejalɨguragande' nebulasɨ. Godɨyale salɨguragya tare'nanyɨ. Jisaasi Nyɨbwaarɨbaangalyɨ. ");
INSERT INTO byr_w_vpl VALUES ("J15_10","092_5_10","1JN","5","10","10","Godɨyale Kawaarɨbaangarɨ lɨmwandei kamɨre sɨmunyabɨ salɨguragya sa' wɨwarɨgalyɨ. Godɨyarɨne' malɨmwagandei tandelyɨ “Godɨyai kwaajɨ yagaala tandelyɨ.” Godɨyai Kawaarɨbaangarɨna “Nɨmɨnyɨdaa'nyalyɨ,” salɨguragya' malɨmwagande'na tandelyɨ “Kwaajɨ yagaala tandelyɨ.” ");
INSERT INTO byr_w_vpl VALUES ("J15_11","092_5_11","1JN","5","11","11","Salɨguragya taresɨ. Godɨyai wɨyagaa' wɨyagaa'ne kaala'nebwi nejaabagasɨ. Kaala'ne saburɨ kaabɨla' Kawaarɨbaangarɨ wɨrawɨwarɨga. ");
INSERT INTO byr_w_vpl VALUES ("J15_12","092_5_12","1JN","5","12","12","Sarebɨdaa'nyɨ Kawaarɨbaangei kɨnɨnnɨgei kaalya'ne sabwi kɨnɨnnɨgelyɨ. Godɨyale Kawaarɨbaangai maayai kaala'ne sabwi maayalyɨ. ");
INSERT INTO byr_w_vpl VALUES ("J15_13","092_5_13","1JN","5","13","13","Yagaala taja yɨnggidawasɨmaaba. Godɨyale Kawaarɨbaangarɨ lɨmwandɨbɨsalabi, “‘Wɨyagaa' wɨyagaa'ne kaala'ne sabwi kɨnɨnnɨgeine,’ tɨpɨga!” tena yɨnggidawasɨmaaba. ");
ALTER TABLE byr_w_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
