﻿USE sofia;
DROP TABLE IF EXISTS sofia.bxh_vpl;
CREATE TABLE bxh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bxh_vpl WRITE;
INSERT INTO bxh_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Bwaꞌibwaꞌina yai, Yaubada galewa yo tanoꞌubu ya fatubudi. ");
INSERT INTO bxh_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Tanoꞌubu mate afaꞌafana yo hige i poiꞌumai. Na kamumu mate hoꞌowa hewana ya fakou, yo Yaubada Yaluwana mate hoꞌowa hewana ya famohafu. ");
INSERT INTO bxh_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Habahim Yaubada iyen, “Haga mala ta fataumahata.” Yo fede ya taumahata. ");
INSERT INTO bxh_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Yaubada mala ya ita mate ya loholoho. Yo fede mala yo kamumu ya dailidi. ");
INSERT INTO bxh_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Mala hesana ya tole lahai, na kamumu hesana ya tole iꞌipa. Maihala ya bulu, mate itete lahai bwaꞌibwaꞌina. ");
INSERT INTO bxh_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Yaubada iyen, “Hoꞌowa aba dailina i taumahata, be hoꞌowa i daili luwagai.” ");
INSERT INTO bxh_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Yo fede, hoꞌowa hewa yai yo ubu yai Yaubada ya ginaulidi be sa lau hudoꞌi. ");
INSERT INTO bxh_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Bili daili hesana ya tole Galewa. Maihala ya bulu, mate itete lahai fafaluwagana. ");
INSERT INTO bxh_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Habahim Yaubada iyen, “Hoꞌowa galewa ubuna yai i falau esega ai tefa esega, na tanohi i taumahata.” Yo fede ya taumahata. ");
INSERT INTO bxh_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Yaubada tanohi hesana ya tole Tanohi. Na hoꞌowa sa falau esega hesana ya tole Gabogabo. Yaubada ya itadi mate sa loholoho. ");
INSERT INTO bxh_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Habahim Yaubada iyen, “Ai tanohi oyagi nene hudoꞌi - hudoꞌi yo hawahawa ti tala inꞌin, ti fuwa be ti lau liꞌe.” Yo fede, ginaulidi sa in. ");
INSERT INTO bxh_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Oyagi nene hesa - hesa yo somo anꞌan sa in tanohi yai, ginaulidi Yaubada ya itadi mate sa loholoho. ");
INSERT INTO bxh_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Iꞌipa ya ofi, na hwalahwalala hesa mate itete lahai fafaihonana. ");
INSERT INTO bxh_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Yaubada iyen, “Mala ti sina ai galewa be lahai yo iꞌipa ti dailidi. Maladi ni, adi paisowa mate lahai, bolima, haiꞌin yo haibeꞌu fafaꞌilaladi. ");
INSERT INTO bxh_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Haba maladi sa sina lidi tanohi ai hewana.” Yo fede ya tubu. ");
INSERT INTO bxh_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Yaubada mala laꞌilaꞌidi luwaga ya ginaulidi. Maihala lahai ya ita watan na nawalahi mate iꞌipa ya ita watan. Yo kipwala hinaga ya ginaulidi. ");
INSERT INTO bxh_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Maladi galewa yai ya toledi be tanoꞌubu sa sinai. ");
INSERT INTO bxh_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Lahai yo iꞌipa sa tanuwagaidi, be kamumu yo lahai sa dailidi. Yaubada ya itadi mate sa loholoho. ");
INSERT INTO bxh_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Maihala ya bulu, mate itete lahai fafatina. ");
INSERT INTO bxh_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Yaubada iyebom, “Suisui hudoꞌi - hudoꞌi, hoꞌowa ti gogo famohafu. Yo ataiꞌa ti failofolofoidi be galewa ti famohafu.” ");
INSERT INTO bxh_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Yo fede Yaubada, gabogabo ginaulidi laꞌilaꞌidi, yo somo hoꞌowa yai mwahumwahulidi ya fatubudi. Ataiꞌa nene hesa - hesa sa lofolofo galewa yai hinaga ya fatubudi. Ya itadi mate sa loholoho. ");
INSERT INTO bxh_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ya faloholohodi, na iyen, “Au talu fanafanatu be gabogabo yo tanohi au famohafudi.” ");
INSERT INTO bxh_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Maihala ya bulu mate itete lahai fafaligigina. ");
INSERT INTO bxh_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Yaubada iyen, “Tanohi ginaulidi mwahumwahulidi nene hudoꞌi - hudoꞌi ti tubu: suisui manamanasadi, yekoyekodi, kanekanenedi yo kamokomodaladi.” Yo fede, somo Yaubada ya libaedi sa tubu. ");
INSERT INTO bxh_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Yaubada suisui te ya ginaulidi, na ya itadi mate sa loholoho. ");
INSERT INTO bxh_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Habahim, Yaubada iyen, “Taumoho ta ginauli doha ita. Haba tanoꞌubu mahudoꞌina: gabogabo hamadi, yada ataiꞌadi, yosiyosi, suisui kanekanenedi yo kamokamodaladi ya tanuwagaidi.” ");
INSERT INTO bxh_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Yo fede Yaubada, ena liba yai taumoho yo waihin, nenedi doha In, ya fatubudi, ");
INSERT INTO bxh_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Habahim ya faloholohodi, na iyen, “Au talu fanafanatu, be nanatumiu tanohi mahudoꞌina ti miyai yo ti tanuwagai. Gabogabo hamadi, yada ataiꞌadi yo ginauli mwahumwahulidi tanohi yai tigatigadi yo kanekanekanedi haba ami ita watanidi hinaga.” ");
INSERT INTO bxh_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Habahim iyen, “Ginauli iniꞌinidi fafaliꞌedi mahudoꞌidi tanohi mahudoꞌina yai yo oyagi fuwafuwadi tumatumadi mahudoꞌidi hinaga E felemiu, ami anꞌan. ");
INSERT INTO bxh_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Suisui, ataiꞌa yo ginauli tanohi yai kanekanenedi yo kamokomodaladi ginauli inꞌindi E feledi, adi anꞌan.” Yo fede, sa tubu. ");
INSERT INTO bxh_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ginauli mahudoꞌidi Yaubada ya fatubudi ya itadi, mate sa loholoho wananaha! Maihala ya bulu, mate itete lahai fafaligigi esegana. ");
INSERT INTO bxh_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Yo fede, galewa yo tanohi yo ginauli mahudoꞌidi, mate Yaubada ya ginauli faꞌofidi. ");
INSERT INTO bxh_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","3","Lahai fafaligigi luwagana yai Yaubada ana paisowa ya faꞌofi, be lahaina ya kawa loholohoꞌen yo ya fatabu. Habahim ya anyawasi. ");
INSERT INTO bxh_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Itete sidohana tanoꞌubu ena ginaginaulina. Aba Fatubu 2:4-25 Fuyana Guyau Yaubada tanoꞌubu yo galewa ya ginaulidi mate, ");
INSERT INTO bxh_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","hige somo laꞌi i in tanohi yai, paꞌana hola hige i faꞌusa, yo hige sai laꞌi gabu i paisowai. ");
INSERT INTO bxh_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Na yomayoman yai hoꞌowa ya kalamahano be tanohi ya faꞌwau. ");
INSERT INTO bxh_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Habahim afusa ya abi tanohi yai na taumoho ya falasa. Ya yahafuwa lau hisuna yai be taumohona ya adidili yo ya mwahiu. ");
INSERT INTO bxh_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Maihala ena aba kepama yai gabu ya ginauli Iden yai. Habahim taumoho ya falasa, amainiya ya tole. ");
INSERT INTO bxh_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Oyagi nene hudoꞌi - hudoꞌi ya ginaulidi be sa in. Itaꞌitadi sa loholoho na anꞌandi olidi. Mwahuli oyagina mate gabu atiꞌatipuna yai yo oyagi hesa hesana loholoho yo heyaya aba ita lobahidi hinaga amainiya. ");
INSERT INTO bxh_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Yomayoman ya didi lidi Iden, be gabuna ya fahoꞌowa. Hoꞌowa gwaluna yai ya saꞌa, be saꞌana oulina fati. ");
INSERT INTO bxh_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Saꞌa bwaꞌibwaꞌina mate hesana Pison mate Hawila nuꞌuna ya didi fataꞌiꞌili, na gole amainiya. ");
INSERT INTO bxh_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Gole wananaha, maꞌi panepanena fisafisadi yo umeꞌehu namanamalidi amainiya sa lobahidi). ");
INSERT INTO bxh_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Saꞌa fafaluwagana mate hesana Gihon ya didi lau Kusi Nuꞌuna yai. ");
INSERT INTO bxh_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Saꞌa fafaihonana hesana Tigilesi mate Asiliya tefa saisaina yai ya didi lau. Na fafatina mate hesana Ifeleti. ");
INSERT INTO bxh_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Habahim taumohona ya lawen Iden. Gabuna yai ya tole be ya ita watan yo ya paisowai. ");
INSERT INTO bxh_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Na ya falaugagayo, iyen, Oyagi mahudoꞌidi gabu yai te, uludi gonowana wa andi. ");
INSERT INTO bxh_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Loholoho yo heyaya aba ita lobahidi oyagina uluna, tabu u an, Ibe uluna wa an, haba wa peꞌi. ");
INSERT INTO bxh_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Guyau hinaga iyen, Taumoho iyabona hige i loholoho. Haba ana sagu yo tau saguhina dudulaina E ginauli. ");
INSERT INTO bxh_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Be ataiꞌa, yosiyosi yo suisui yekoyekodi tanohi yai ya falasadi. Habahim ya lawedi Adam lisina, na hesa somo ya tole, mate, logena. In moho hige laꞌi, gonowana i saguhi. ");
INSERT INTO bxh_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Yo fede, taumoho ni ya lau faꞌeno. Habahim, oitalina esega ya abifahi, na omatana ya fasusu buluhi. ");
INSERT INTO bxh_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Oitalina yai waihin ya ginauli, be ya lawen Adam lisina. ");
INSERT INTO bxh_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Adam iyen, Yee–, matabahim doga nenena doha yau, itete yau siyadagu, taugu yai sa kamfahi yo fisihogu tefana. Haba hesana E tole waihin, paꞌana taumoho oitalina yo fisihona yai Guyau ya ginauli. ");
INSERT INTO bxh_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Logena, taumoho haba tinana yo tamana ya lau afuledi, na ma lahuna sa miya esega, be sa famala esega. ");
INSERT INTO bxh_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Taumoho yo waihin ma tau afaꞌafadi, in moho, hige ti taumayamaya. ");
INSERT INTO bxh_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Guyau Yaubada suisui yekoyekodi ya ginaulidi, na ganahewana yai mate weso lau bwalabwala yai ya sonoga wananaha, habahim suisui hahaisa. Weso ya libalau waihin lisina iyen, Oyagi gabu yai ni wananaha Yaubada ya falibamiu, “Tabu uludi au anidi?” ");
INSERT INTO bxh_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Waihin ya libalau weso lisina iyen, Gonowana gabu yai oyagi uludi ꞌe anidi. ");
INSERT INTO bxh_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","In moho, Yaubada iyen, Oyagi gabu atipuna yai, tabu au an yo tabu au eliꞌina, doꞌata haba ami peꞌi. ");
INSERT INTO bxh_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Weso ya libalau waihin lebena iyen, Ya bwala! Ibege au peꞌi. ");
INSERT INTO bxh_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Yaubada ya sibai mate yena oyagi ni uluna ami an, matamiu haba sa lahalahai, yo umi haba doha Yaubada, be heyaya yo loholoho ami sibaidi. ");
INSERT INTO bxh_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Oyagi uluna waihin ya ita mate ya fagado lelelehi, be iyen, Yena E an, haba E sonoga. Yo fede uluna ya losi be tefana ya an, na lahuna ana, tefana ya felen be ya an hinaga. ");
INSERT INTO bxh_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Oyagi uluna tefana sa an, mate nuwadi sa tasoꞌe be sa nuwatuhu lobahi iti ma tau afaꞌafadi, yo fede oyagi doha kuhou mate lugudi sa hinoꞌidi, be sa liꞌodi. ");
INSERT INTO bxh_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Hwaya ya biga, na gabu yai Guyau Yaubada ya laolaoma, ahena daguguna taumoho ni ma lahuna sa atahi, yo fede oyagi fatau bulubuluhidi yai sa alasimo. ");
INSERT INTO bxh_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Na Guyau Yaubada ya yogalau taumoho lebena, iyen, Um somo yai? ");
INSERT INTO bxh_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Alinana ya fafuyo iyen, Gabu yai ahem daguguna E atahi, na E ꞌwasabu, paꞌana yau ma tau afaꞌafagu yo fede E alasimo. ");
INSERT INTO bxh_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Yaubada ya fatiꞌo, iyen, Sai ya falibam ma tau afaꞌafam? Oyagi uluna E laugagayoꞌen, haꞌa wa an? ");
INSERT INTO bxh_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Taumoho iyen, Waihin wa tole maꞌegu, in, oyagina uluna ya felegu be E an. ");
INSERT INTO bxh_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Yo fede Guyau Yaubada ya libalau waihin lisina iyen, Somo wa ginauli? Waihin iyen, Weso ya bwalaigu be oyagi uluna E an. ");
INSERT INTO bxh_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Habahim, Guyau Yaubada ya libalau weso lisina iyen, Paꞌana laulau ni wa ginauli, kaumanana ya laowa hewam yai. Suisui manamanasadi yo yekoyekodi ganahewadi yai um haba heyaya laꞌilaꞌi wa fahoina. Haba ai bogam wa felifeli. Am kalahe, haba ma afusana wa an esegahi, fuya ouꞌouli. ");
INSERT INTO bxh_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Um yo waihin yo ami hiti mulita haba ami fawaiyunu. In haba kulum ya bwaꞌi golugolu, Na um haba ahe geduna wa nali. ");
INSERT INTO bxh_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Guyau ya libalau waihin lisina iyen, Em fanatu yai haba kamkamna laꞌilaꞌi wa fahoina. Kamkamna yai, haba nanatum wa yosidi. Em gadosisi haba ya ota esegahi lahum lisina yai be in haba am tanuwaga. ");
INSERT INTO bxh_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","18","Hinaga ya libalau Adam lisina iyen, Oyagi uluna E falaugagayoꞌen mate tabu u an! In moho, lahum alinana wa lau watan be uluna wa an. Debam yai tanohi E kaumananaen. Gabu yai haba hawa nulinulidi sa tala inꞌin, na haba wa ankamkamna, be kalahe wa lobahi, yo somo iyabodi sa in hinaga, am kalahe. ");
INSERT INTO bxh_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Haba wa an muyahasa yo wa paisowa adidili be kalahe wa lobahi, ya lau ee–, ai muli haba wa peꞌi, wa fuyo tanohi. Paꞌana tanohi yai E falasam. Um afusa, be yena wa peꞌi haba wa famala afusa. ");
INSERT INTO bxh_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam lahuna hesana ya tole, Iwa paꞌana in tau mwahumwahuli tinadi. ");
INSERT INTO bxh_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Habahim edi kaleko suisui ꞌwapidi yai Guyau Yaubada ya ginaulidi, be ya faliꞌodi. ");
INSERT INTO bxh_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Habahim, Guyau Yaubada iyen, Dodoga te sa famala doha Ita, paꞌana loholoho yo heyaya haꞌa sa sibaidi. Tabu nimadi ti lolon be mwahuli oyagina uluna ti abi be ti an. Doꞌata, haba sa miya ee–, hige anadan. ");
INSERT INTO bxh_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Yo fede Guyau Yaubada ya weꞌaidi Iden Gabuna yai. Tanohi lisina yai ya falasadi, mate lisina yai, hinaga adi sa uma. ");
INSERT INTO bxh_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Yaubada, gabu yai ya lau weꞌaidi, mulina yai gabu tefa saisaina yai, anelu ya toledi, hesadi Selubim. Baineti ya ala balabalelem hinaga ya tole ya taꞌitaꞌiꞌili asiꞌasi tefa ouꞌouli yai, be mwahuli oyagina edaꞌedana ya gudu. ");
INSERT INTO bxh_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam ma lahuna Iwa sa eno bili, yo fede Iwa ya boga be natuna Kaina ya yosi. Na ya liba iyen, Guyau ena faisagusagu yai natugu taumoho E yosi. ");
INSERT INTO bxh_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Muliyai natuna hesa hesana Abela ya yosi. Fuyanna sa lalaꞌi, Abela mate yosiyosi tau itaꞌita watanidi, na Kaina mate gabu tau paipaisowa. ");
INSERT INTO bxh_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Fuya hesa Kaina kalahe ya umahidi, anꞌandi ya abidi ya lau Guyau ya felen ena antalasam. ");
INSERT INTO bxh_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abela hinaga sipi natuna halahala fwauna tubu loholohona ya wunui be tefana ya lau Guyau ya felen, ena antalasam. Guyau Abela ya ita faloholoho yo ena antalasam hinaga. ");
INSERT INTO bxh_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","In moho Kaina ena antalasam Guyau hige i ita faloholoho. Yo fede Kaina ya manabala be ya dulu. ");
INSERT INTO bxh_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Habahim Guyau ya libalau Kaina lisina iyen, Paꞌana somo be wa manabala? Sidohana be wa duludulu? ");
INSERT INTO bxh_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ibe wa sibai somo wa ginauli ya loholoho, haba wa kwade. Na paꞌana heyaya wa ginauli, heyaheyaya haꞌa em edaꞌeda ya dulu tawan be ya tanuwagaim. In moho bena wa anfalen. ");
INSERT INTO bxh_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Habahim Kaina tasina Abela ya faliba iyen, Te lau, te laulau tiga. Fuyana sa laulau tiga Kaina tasina ya tohai be ya wunui. ");
INSERT INTO bxh_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Habahim Guyau ya libalau Kaina lisina iyen, Hidam Abela somo yai? Alinana Kaina ya bui iyen, Hige ya sibai. Yau hige hidagu ya itaꞌita watan. ");
INSERT INTO bxh_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Guyau iyen, Somo wa ginauli? Tasim ꞌwasinana tanohi yai ya yogayoga hasaema lisigu. ");
INSERT INTO bxh_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Aho ite E kaumananaem. E duwim nuꞌu yai te. Hidam ꞌwasinana ya tabuliwa, itaꞌitana doha tanohi te moꞌana i tasoꞌe be ꞌwasinana i tofi, fuyana wa lau funuhi. ");
INSERT INTO bxh_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Yena ai tanohina ni wa paisowa, gabuna ibege anꞌanna. Um haba tau laulau gaibu ai tanoꞌubu. ");
INSERT INTO bxh_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam ma lahuna Iwa sa eno bili fuyo, natudi taumoho, na hesana sa tole: Seti. Iwa iyen, Yaubada ya ainauya fuyoꞌigu. Natugu Abela falau damahina, fuyanna hidana ya wunui. ");
INSERT INTO bxh_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seti hinaga natuna taumoho. Hesana ya tole: Inosi. Fuyanna yai mate dodoga sa fatubu Guyau hesana sa fadebasae. ");
INSERT INTO bxh_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Dodoga tanoꞌubu yai Guyau ya itadi mate fuya ouꞌouli edi laulau yo edi nuwanuwatuhu sa heyaya wananaha, ");
INSERT INTO bxh_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","be Guyau ya fatalapili lau dodoga ya ginaulidi tanoꞌubu yai, be nuwana ya heyaya. ");
INSERT INTO bxh_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Yo fede Guyau ya liba iyen, Ginauli somo mahudoꞌidi E ginaulidi tanoꞌubu yai haba E abifahidi. Paꞌana dodoga nuwagu sa faheyaya. ");
INSERT INTO bxh_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","In moho Guyau Nowa ya ita faloholoho. ");
INSERT INTO bxh_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Itete Nowa dedena: Nanatuna faihona hesadi mate, Sem, Ham yo Diyapeti. Nowa ena fuya yai mate hige ena lau pono hesa. Yaubada moho ya famuli watan. ");
INSERT INTO bxh_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Dodoga mahudoꞌidi mate Yaubada matana yai heyaya sa laulau ginauli be heyaheyaya wa ya tadada. ");
INSERT INTO bxh_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Nuꞌu mahudoꞌina Yaubada ya ita mate heyaya ya famohafu yo dodoga laulau heyaheyayadi sa miyamiyaꞌedi. ");
INSERT INTO bxh_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Yo fede Yaubada ya libalau Nowa lisina iyen, Paꞌana debadi yai tanoꞌubu mahudoꞌina heyaheyaya ya mohafu, Yau haba dodoga adi sigasiga E tole yo nuꞌu mahudoꞌina haba E faheyaya hinaga. ");
INSERT INTO bxh_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Em waga u ginauli ai oyagi loholohodi. Bilidi u ginaulidi na ganahewa yo ganamuli kolutaꞌa u toledi. ");
INSERT INTO bxh_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Wagana u ginauli doha ite: lofana 137 mita, magagana 22 mita, na hewana 14 mita. ");
INSERT INTO bxh_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Solasolana u tole lumalumana ai ubuna aꞌawana doha 45 sentimita yo hiti faihona u toledi, na edaꞌedana ai sadai u tole. ");
INSERT INTO bxh_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Haba diboli utuꞌutu E fatamaliyawa ai tanohi, be ginauli mwahumwahulidi mahudoꞌidi haba ya faheyayadi. Ginauli be sa peꞌi. ");
INSERT INTO bxh_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","In moho yali haba E ginauli ai lisim. Um, lahum yo nanatum ma lalahudi haba ami luhu waga ganahewana. ");
INSERT INTO bxh_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Yosiyosi, suisui kamokamodaladi yo ataiꞌa tinabawa yo tamoꞌana nene hesa - hesa u abidi be haba sa mwahumwahuli. ");
INSERT INTO bxh_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Kalahe hesa - hesa gonowana sa an, u abidi, tefana suisui adi na tefana ami, mate u pei gogondi. ");
INSERT INTO bxh_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Yo fede somo Yaubada ya fatalaha mate Nowa ya ginauli watanidi. ");
INSERT INTO bxh_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Habahim Yaubada ya libalau Nowa lisina iyen, Ma lahum, yo nanatumiu, ma lalahudi, au luhulau waga ganahewana, paꞌana E ita mate hiti tanoꞌubu yai te, um ibom wa dudulai. ");
INSERT INTO bxh_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Yosiyosi anꞌan faligigi luwaga ma lalahudi yo suisui dabudabu ma lalahudi u lawedi. ");
INSERT INTO bxh_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Yo ataiꞌa faligigi luwaga, nene hesa - hesa, ma lalahudi, u lawedi hinaga. Be haba sa mwahumwahuli ai tanoꞌubu. ");
INSERT INTO bxh_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Lahai faligigi luwaga mulidi yai haba tanoꞌubu E faꞌusa ee–, lahai 40 yo maihona 40, be ginauli mwahumwahulidi mahudoꞌidi haꞌa E ginaulidi haba E kamfahidi. ");
INSERT INTO bxh_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Yo fede Guyau somo ya fatalaha mate ya ginauli watanidi. ");
INSERT INTO bxh_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Fuyana Nowa ena bolima 600 mate diboli utuꞌutu ya laoma tanoꞌubu yai. ");
INSERT INTO bxh_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nowa, lahuna, afa nanatuna yo lalahudi, diboli utuꞌutu sa gelaen be sa luhu waga yai. ");
INSERT INTO bxh_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Suisui luwaga - luwaga anꞌan yo dabudabudi, ataiꞌa yo suisui mahudoꞌidi tigatigadi, ");
INSERT INTO bxh_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","tamoꞌanadi yo tinabawadi, sa laoma Nowa lisina be waga yai sa luhu doha Yaubada haꞌa Nowa ya faliba. ");
INSERT INTO bxh_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Lahai faligigi luwaga mulidi yai diboli utuꞌutu ya laoma tanoꞌubu. ");
INSERT INTO bxh_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Lahai 40 utufi hola ya laolaoma tanoꞌubu yai na hoꞌowa sa siu be waga ya pouli. ");
INSERT INTO bxh_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ginauli mwahumwahulidi mahudoꞌidi tanoꞌubu yai: dodoga, suisui, ginauli kamokamodaladi yo ataiꞌa mate Guyau ya abifahidi. Nowa yo safalumadi waga ganahewana yai mate sa mwahuli. ");
INSERT INTO bxh_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Yaubada Nowa ya faliba iyen, ");
INSERT INTO bxh_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Ma lahum, nanatumiu yo afa lalahudi ai waga au kalamahano. ");
INSERT INTO bxh_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Suisui, ataiꞌa, yo suisui kamokomadaladi mahudoꞌidi au lawedi ganamuli. Haba sa talu fafanatu be tanoꞌubu mahudoꞌina sa famohafu. ");
INSERT INTO bxh_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Yo fede Nowa ma lahuna yo nanatuna ma lalahudi waga sa lau afulen, na sa tulubeꞌu. ");
INSERT INTO bxh_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Suisui, ataiꞌa yo suisui kamokamodaladi mahudoꞌidi waga sa lau afulen, na sa tulubeꞌu hinaga. ");
INSERT INTO bxh_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Habahim Nowa antalasam katakatanna ya ginauli, na suisui yo ataiꞌa anꞌandi ya abidi be ya gabudi. Ena antalasam ya lau Yaubada lisina. ");
INSERT INTO bxh_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Guyau Antalasam panena loholohona ya atahi, na nuwana yai iyen, Dodoga ma kikiꞌinadi ya laoma ee–, sa lalaꞌi edi nuwatuhu mate, heyaya haba sa ginaginauli. In moho tanohi ibege ya kaumananaen fuyoi. Ginauli mwahumwahulidi haꞌa E ginaulidi, ibege ya faheyaya fuyoꞌidi. ");
INSERT INTO bxh_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Uma fuyana yo falolo fuyana, gogoma yo gigibwali, haiꞌin yo haibeꞌu, lahai yo iꞌipa, ibege ti ofi, yo tanoꞌubu ya miya esegahi, ya lau ee–, fuya hige ana siga. ");
INSERT INTO bxh_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Yaubada ena loholoho Nowa ma afa nanatuna ya feledi. Ya libalau lisidi iyen, Au talu fananatu be tanoꞌubu au famohafu. ");
INSERT INTO bxh_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Suisui, ataiꞌa, suisui kamokomodaladi yo hama haba sa miyamiya na sa ꞌwasaꞌwasabuwemiu. Haba gigibwali E felemiu be nimamiu yai ami ita watanidi. ");
INSERT INTO bxh_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Fuwafuwa yo ginauli mahudoꞌidi E felemiu te, au andi. ");
INSERT INTO bxh_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Na tabu fisiho ma ꞌwasiꞌwasinana au an, paꞌana mwahuli mate ꞌwasina yai. ");
INSERT INTO bxh_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ꞌWasinamiu haba E fatala doha ite: Yena suisui hesa doga ya wunui, suisui ni haba sa lau funuhi hinaga. Na yena doga hesa, doga ya wunui, haba ami lau funuhi paꞌana ꞌwasinana mate mwahuli pwalana. ");
INSERT INTO bxh_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Yaubada dodoga ya ginauli doha In. be yena sai doga ya wunui, dogana haba sa wunui hinaga. ");
INSERT INTO bxh_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Na umi, au talu fanafanatu yo au tadada be tanohi mahudoꞌina au famohafu. ");
INSERT INTO bxh_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Yaubada ya libalau Nowa ma afa nanatuna lisidi iyen, ");
INSERT INTO bxh_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Yau aho ite egu yali E ginauli lisimiu yai yo laulauwewemiu matamiu yai, ");
INSERT INTO bxh_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","yo ginauli mwahumwahulidi mahudoꞌidi maidamiu waga yai ami kalamahano. ");
INSERT INTO bxh_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","E ginauli lisimiu yai mate ginauli mwahumwahulidi mahudoꞌidi yo tanohi ibege utufi i faheyaya fuyoꞌidi. ");
INSERT INTO bxh_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Yau yo umi yo ginauli mwahumwahulidi mahudoꞌidi, maꞌemiu yali fafaꞌilalana te ginauli. Yali te hiti mahudoꞌina matamiu yai enehedi hinaga. ");
INSERT INTO bxh_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Yau haba ai yada ꞌwasinaꞌubo E tole, yali fafaꞌilalana, Yau yo tanohi lisimiu yai. ");
INSERT INTO bxh_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Yena yada tanohi sa fakou, na ꞌwasinaꞌubo ya taumahata, ");
INSERT INTO bxh_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","haba egu yali E nuwanuwatuhui, Yau yo um lisida yai, yo ginauli mwahumwahulidi mahudoꞌidi hinaga lisidi yai. Ibege ginauli mwahumwahulidi mahudoꞌidi utufi i faheyaya fuyoꞌidi. ");
INSERT INTO bxh_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Bwaꞌibwaꞌina, dodoga mahudoꞌidi tanoꞌubu yai mate alina esega sa fapaisowa. ");
INSERT INTO bxh_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Tefa saisai yai sa aulaha sa laoma ee–, sa mahano Babela Gonna yai sa miya. ");
INSERT INTO bxh_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Sa faliba fuyoꞌidi tiyen, Au laoma! Haba bwadagowa te abi be te gabu fapoꞌidi. Be luma edi aba ginaulina mate ginaulidi sa fanonohaidi. ");
INSERT INTO bxh_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Na tiyen, Matabahim, haba duhu balabalamumu hesa te ginauli yo luma hesa laꞌilaꞌi na hewa lofalofana te ginauli ya hasai ee–, galewa. Haba sa noꞌonoꞌoꞌeda be tabu ta failaulauwida. ");
INSERT INTO bxh_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Habahim Yaubada ya lidima be duhu balabalamumu yo luma hewa lofalofa dodoga sa ginauli, ya ita, ");
INSERT INTO bxh_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","be iyen, Itete mate boga esega yo alina esega yai sa libaliba, yo itete mate fatufatubu moho. Mulina yai sa fanuha somo sa nuwatuhui bena sa ginauli, haba sa ginauli. ");
INSERT INTO bxh_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Haga ta lidi be edi alina ta bui, be tabu alinadi ti atahi lobahi fuyoi. ");
INSERT INTO bxh_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Yo fede Yaubada ya fadabalaladi, be sa lau tanoꞌubu tefa hesa - hesa yai, na duhu balabalamumu ginaulina, sa fatautau. ");
INSERT INTO bxh_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Duhu balabalamumuna, hesana sa tole: Babela, paꞌana amainiya Yaubada dodoga mahudoꞌidi edi alina ya buidi, na sa failaulauwidi be sa lau tanoꞌubu tefa haisa yai. ");
INSERT INTO bxh_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Itete Tela laulauwewena: Abelam, Nahola, yo Halan. Tamadi mate Tela. Lota mate, tamana Halan. ");
INSERT INTO bxh_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Fuyanna Halan, Ula Nuꞌuna yai Kaladiya ganahewana yai, ya peꞌi mate tamana hola ya miyamiya. ");
INSERT INTO bxh_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abelam mate lahuna Salaiya, na Nahola lahuna Milika. Halan natuna mate Milika yo Isika. ");
INSERT INTO bxh_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Salaiya mate ya agali. ");
INSERT INTO bxh_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tela natuna Abelam, wahana Halan natuna Lota, yo botiyana Salaiya, Abelam natuna, mate mahudoꞌidi Kaladiya dodogadi edi nuꞌu Ula yai sa aulaha bena sa lau Kanana. In moho, sa lau ee–, Halan nuꞌuna yai amainiya sa miya. Na hige ti abi mahano Kanana yai. ");
INSERT INTO bxh_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tela ena bolima 205 habahim ya peꞌi Halan Nuꞌuna yai. ");
INSERT INTO bxh_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Guyau ya libalau Abelam lisina, iyen, Em nuꞌu, em dodoga yo tamam ena luma dodogadi u lau afuledi na u lau tanohi haba E faꞌitam ainiya. ");
INSERT INTO bxh_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Egu gigibwali yai haba laulauwewem nuꞌu lalaꞌi sa fatubudi, yo egu faloholoho haba ai lisim, na hesam haba E falaꞌi, na um haba wa famala dodoga edi loholoho. ");
INSERT INTO bxh_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Yena sai ya kawa loholohoꞌem, mate Yau hinaga haba E kawa loholohoꞌen, na sai ya kaumananaem haba E kaumananaen. Debam yai egu loholoho haba ya talu dodoga mahudoꞌidi tanoꞌubu yai ai lisidi. ");
INSERT INTO bxh_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Yo fede, Guyau alinana Abelam ya lau watan be maꞌena Lota sa lau. Fuyana Halan sa lau afulen mate Abelam ena bolima 75. ");
INSERT INTO bxh_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abelam lahuna yo madiyana Lota ya foyahidi. Ena ginauli, yosiyosi, yo ena dodoga Halan nuꞌuna yai ya lawe gogonidi. Na sa lau Kanana tanohina, be sa mahano amainiya. ");
INSERT INTO bxh_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abelam tanohina ya tafo dadai, ya lau ee–, oyagi laꞌilaꞌi hesa Sekem nuꞌuna yai hesana Mole, amainiya ana sigasiga. Fuyana yai Kanana dodogadi amainiya sa miyamiya. ");
INSERT INTO bxh_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Guyau ya taumahata Abelam lisina yai, na iyen, Tanohi te haba laulauwewem E feledi. ");
INSERT INTO bxh_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abelam ma lahuna Idipi yai sa aulaha be sa lau Negebi. Edi ginauli yo yosiyosi mahudoꞌidi sa lawe esegahidi yo fede, Lota ya lau watanidi. ");
INSERT INTO bxh_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abelam ya fagogo wananaha; ena bulumakau, sipi, siluba yo gole sa ouli wananaha. ");
INSERT INTO bxh_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Negebi yai ya lau nuꞌu hesa - hesa yai ee–, ya mahano lau edi aba pei palai bwaꞌibwaꞌina yai, Beteli yo Ai atiꞌatipudi yai; ");
INSERT INTO bxh_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","be somo yai katakatan ena aba ginauli bwaꞌiyena yai, amainiya Abelam ya lauꞌuꞌula lau Guyau lisina. ");
INSERT INTO bxh_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Fuyana Lota Abelam ya laulau watan, in hinaga ena sipi, bulumakau, yo palai. ");
INSERT INTO bxh_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","In moho, tanohina yai, yosiyosi adi ban hige i laꞌi, be hige gonowana ti miya esega. ");
INSERT INTO bxh_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Yo fede, Abelam ena yosiyosi tau ita watanidi yo Lota ena yosiyosi tau ita watanidi sa faibayaho. Fuyana yai mate Kanana yo Pelesi dodogadi hinaga nuꞌuna yai ni sa miyamiya. ");
INSERT INTO bxh_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Yo fede, Abelam ya libalau Lota lisina iyen, Tabu um yo yau e em yosiyosi tau ita watanidi yo yau egu ma afa haidada ta faibayaho, paꞌana um mate efagu. ");
INSERT INTO bxh_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Tanohi hola mahudoꞌina - ta faitamodaili; yena wa lau tefa seuseuli, yau haba E lau tefa siba, na yena wa lau tefa siba haba yau E lau tefa seuseuli. ");
INSERT INTO bxh_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lota ya itaꞌita lau, Diyodan gonna ya lau ee–, Sowa, mahudoꞌina ya ita, mate hoꞌowa sa ouli doha Guyau ena gabu Iden yai yo doha Idipi tanohina. (Fuyana yai mate Guyau hola hige Sodom yo Gomola i lau kwayaidi). ");
INSERT INTO bxh_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Amainiya sa faitamo daili. Lota Diyodan gonna ya fasinabo be ya aulaha ya lau maihala ena aba tala hitima yai. ");
INSERT INTO bxh_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abelam ya gogo Kanana nuꞌuna yai, na Lota mate taon atiꞌatipudi yai ya gogo, Diyodan gonna yai. Ena palai ya faꞌobiyo Sodom sadaina yai. ");
INSERT INTO bxh_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Fuyana yai Sodom dodogadi sa nuwatuhu lau wata be heyaya sa laulau ginauli Guyau matana yai. ");
INSERT INTO bxh_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lota haꞌa ya lau na mulina yai Guyau ya libalau Abelam lisina, iyen, Em aba obiꞌobiyo yai matam u falaba hitin be u itaꞌita leu, u itaꞌita sai, u itaꞌita hasa yo u itaꞌita lidi; ");
INSERT INTO bxh_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","tanohi mahudoꞌina wa ita mate haba laulauwewem aiꞌedi E duwai. ");
INSERT INTO bxh_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Yau haba laulauwewem boludi E felem doha fufuꞌa, be yena sai gonowana fufuꞌa ya fatili, mate laulauwewem haba gonowana ya fatilidi. ");
INSERT INTO bxh_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","U lau tanohina u tafo dadai paꞌana haba E felem. ");
INSERT INTO bxh_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Yo fede, Abelam ena palai ya faꞌaulaha bodaidi ya lau Hebelon yai be oyagi laꞌilaꞌi Mamale, sadaina yai ya gogo. Amainiya antalasam aba gabuna katakatanna ya ginauli. ");
INSERT INTO bxh_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Kin fati mate Sodom yo Gomola yai ginauli yo kalahe sa gelaedi na sa lau. ");
INSERT INTO bxh_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abelam madiyana Lota mate, Sodom yai ya miyamiya, yo fede sa aulen yo ena ginauli mahudoꞌidi sa abidi. ");
INSERT INTO bxh_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","In moho, doga hesa ya gela be ya lau sulu Hebelu dogana, Abelam ena ya liba. In mate Mamale ena oyagi laꞌilaꞌidi sadaidi yai ya miyamiya. Mamale ena sulu Amoli. Haihaidana mate Esikoli yo Ane. Iti mahudoꞌidi mate maꞌedi Abelam adi sana. ");
INSERT INTO bxh_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abelam wasa ya atahiyen mate madiyana Lota sa tohai, yo fede, ena tau hiyala dodogadi ena tau paisowa nanatudi 318 ya yoga gogonidima, be baꞌibaꞌisa fati sa weꞌa dudu lidi ee–, Dan duhu laꞌina yai. ");
INSERT INTO bxh_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Amainiya ena tau hiyala ya pei daili, na iꞌipana adi waiyunu sa laufidi be sa an fadabalalaidi na sa weꞌaidi ee–, Hoba, Damaseko tefa lidilidina yai. ");
INSERT INTO bxh_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ginauli somo adi waiyunu sa abidi mate sa fafuyodi. Madiyana Lota yo ena ginauli mahudoꞌidi, wawahin yo dodoga haisa hiyala yai sa gelaedi mate sa fafuyodi hinaga. ");
INSERT INTO bxh_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abelam maꞌena Kedolama yo babaꞌisa haisa ma afa haidana sa hiyala be ya lei hafihafitidi habahim Sodom edi baꞌisa ya lau be ya failobahi Sawe gonna yai (hesana hesa, “Baꞌisa ena Gon.”) ");
INSERT INTO bxh_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Habahim, Salem edi baꞌisa, Melekisideki, fwalawa yo wain ya abidi, be ya lawedi Abelam lisina. In mate Yaubada Hewa Wananaha ena tau antalasam. ");
INSERT INTO bxh_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Melekisideki ena faloholoho Abelam ya felen, na iyen, Yaubada Hewa Wananaha, Galewa yo Tanoꞌubu Tau Ginaulina haba ena loholoho ya fatalu ai lisim. ");
INSERT INTO bxh_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Hewa Wananaha Yaubadana te fadebasae paꞌana am waiyunu ya lei hafihafitidi. Ginauli somo - somo Abelam ya abidi, ya daili be pei safuhudohudoꞌi, na habahim pei esega ya abi be Melekisideki ya felen. ");
INSERT INTO bxh_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodom edi baꞌisa ya libalau Abelam lisina, iyen, Ginauli mahudoꞌidi u abidi na egu dodoga moho, u fele fafuyogu. ");
INSERT INTO bxh_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","In moho Abelam ya libalau Sodom edi kin lisina, iyen, Yaubada ya Hasai Wananaha Guyauna, Galewa yo Tanoꞌubu Tau Ginaulidi, hesana yai E angwala mate, ");
INSERT INTO bxh_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ibege somo hesa kiukiu doha kaleko bodibodi mahinadi e sendolo auꞌaudi lisim yai ya abi. Doꞌata uwen, “Abelam E fagogo be aho te, in doga.” ");
INSERT INTO bxh_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Somo egu dodoga haꞌa sa an, mate logena. In moho, tau saguhigu faihona: Ane, Esiko yo Mamale mate edi u soi. ");
INSERT INTO bxh_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Muli yai habahim, Yaubada eno suwai yai ya libalau Abelam lisina, iyen, Tabu u ꞌwasabu, Yau haba E bobodiyem, yo maisam haba ya laꞌi. ");
INSERT INTO bxh_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Na Abelam iyen, Aee–, Yaubada Hewa Wananaha Guyauna, hola hige natugu na somo haba wa felegu? Yena E peꞌi, egu tau paisowa Damaseko dogana, Eliyesi mate, doha natugu be haba egu ginauli mahudoꞌidi ya abidi! ");
INSERT INTO bxh_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Na Abelam ya liba fuyo, iyen, Um hige natugu laꞌi u felegu. Lisina yai egu tau paisowa haba egu ginauli mahudoꞌidi ya abidi. ");
INSERT INTO bxh_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Guyau ya libalau Abelam lebena iyen, Taumoho te, ibege em ginauli i abidi, paꞌana natum haba E felem be em ginauli mahudoꞌidi haba aiꞌena. ");
INSERT INTO bxh_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Habahim kamumu yai, Yaubada, Abelam ya lawen ena palai ganamuli yai, be ya faliba, iyen, U itaꞌita hasa galewa, be kipwala u itadi haba gonowam wa fatilidi? Um laulauwewem haba sa ouli wananaha doha kipwala. ");
INSERT INTO bxh_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abelam, Yaubada ya kawawananahaꞌen, yo fede, Yaubada Abelam ya ita fadudulai. ");
INSERT INTO bxh_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Maihala ya bulubulu, Abelam matana ya enoꞌeno, be ya eno wafu. Maꞌesega, na kamumu lubilubi fatau ꞌwasaꞌwasabuna ya fakou hafihafiti. ");
INSERT INTO bxh_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Habahim Guyau ya libalau Abelam lisina, iyen, Wa siba mate, am hiti mulita haba ai nuꞌu hesa sa miya taꞌotaꞌowawa. Haba sa fahisu faheyayadi doha fayofayo tau abidi ya lau ee–, bolima 400. ");
INSERT INTO bxh_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","In moho, tau lau fayofayodi haba E fakamkamnadi mulina yai, haba nuꞌu ni ginaulidi sa abidi be sa lau afulen. ");
INSERT INTO bxh_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Haba wa miya gwaugwau ee–, wa tautaulaꞌi wananaha, habahim wa peꞌi be sa boꞌusaim. ");
INSERT INTO bxh_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Laulauwewem hiti fafatina haba sa fuyoma, paꞌana Amoli dodogadi edi heyaya hige i laꞌi, be doꞌata te haba kamkamna ti abi. ");
INSERT INTO bxh_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abelam lahuna Salaiya ya hamoꞌafi na ena tau paisowa Idipi waihinna hesana Hagala. ");
INSERT INTO bxh_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Yo fede, Salaiya ya libalau Abelam lisina iyen, Guyau ya taꞌai mulimuliyegu lisina yai ibege ya fanatu. U lau be maꞌem egu tau paisowa au eno bili, nuwana ai lisina haba agu boga ya tadada. Salaiya ena nuwatuhu, Abelam ya ehe watawatan. ");
INSERT INTO bxh_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Fuyana Abelam ya miyamiya Kanana nuꞌuna yai bolima safuhudohudoꞌi mulidi yai, laulau te ya tubu; Salaiya ena tau paisowa Hagala ya lawen lahuna Abelam lisina. In Idipi waihinna na ya felen be ya famala lahuna. ");
INSERT INTO bxh_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Yo fede, Hagala natuna taumoho ya yosi, na Abelam hesana ya tole Isamaiyeli. ");
INSERT INTO bxh_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Fuyana Abelam ena bolima 86 mate Hagala Isamaiyeli ya yosi. ");
INSERT INTO bxh_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abelam ena bolima 99 na Guyau ya taumahata lebena yai. Ya faliba iyen, Yau Yaubada Tau Gigibwali. U famuli watanigu yo em laulau bena sa dudulai! ");
INSERT INTO bxh_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Egu yali haba E ginauli ai lebem yo laulauwewem haba ya tadada. ");
INSERT INTO bxh_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Yo fede, Abelam ya hoba lidi tanohi yai, na Yaubada ya libama lisina, iyen, ");
INSERT INTO bxh_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Egu yali te ai lebem E ginauli: Um haba dodoga ouꞌouli Tamadi. ");
INSERT INTO bxh_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Hige gonowana hesam ti atahi fuyoi Abelam, haba tiyen, Abelaham paꞌana E fasinabom be haba nuꞌu ouꞌouli adi ulutubu. ");
INSERT INTO bxh_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Am hiti mulita haba sa tadada, yo haisa haba sa famala kin. ");
INSERT INTO bxh_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Um yo am hiti mulita ai lisimiu haba yali E ginauli be, yalina ni ya ota esegahi. Yalina doha ite: Yau haba emi Yaubada yo am hiti mulita matamiu yai sa tubutubu haba edi Yaubada hinaga. ");
INSERT INTO bxh_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Kanana tanohina, aho ite, amainiya ami gogogo, mate dodoga haisa enehedi, in moho, tanohina ni mahudoꞌina um yo nanatum yo nanatum nanatudi E felemiu. Haba ya famala aiꞌemiu ee–, hige anadan. Nanatum ma afa nanatudi haba Yau edi Yaubada. ");
INSERT INTO bxh_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Yaubada ya libalau Abelaham lisina, iyen, Aho ite yalina haba um yo am hiti mulita nanatudi ami lau watan. ");
INSERT INTO bxh_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Yalina bena ami lau watan mate doha ite: wawaya tatau lisim yai bena mwagisadi dududi ꞌwapidi wa tomodi. ");
INSERT INTO bxh_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Fagabi te bena ami ginauli, be haba yali fafaꞌilalana um yo Yau lisida yai. ");
INSERT INTO bxh_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Tatau sa yosidi, na edi lahai faligigi faihona, yo saluma em luma yai sa tubu ye em moni yai wa une laolaoma lebedi yai, iti hige nanatum, mate wa fagabidi hinaga. ");
INSERT INTO bxh_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Sa tubu em luma yai ye em moni yai wa une mate bena fagabi te sa abi. Egu yali te, bena yali otaꞌota fahina. ");
INSERT INTO bxh_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Taumoho sai ya waiyoꞌo, be mwagisana duduna ꞌwapina ti tomo haba sa tomo afulen paꞌana yali wa ya ꞌwaiyoꞌoꞌen. ");
INSERT INTO bxh_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Yaubada ya libalau Abelaham lisina, iyen, Lahum ibege u atahi fuyoi, “Salaiya.” Hesana haba “Sala.” ");
INSERT INTO bxh_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Haba egu loholoho E felen, na ai lisina haba natum taumoho ya yosi! Haba egu loholoho E felen, be ya famala nuꞌu ouꞌouli tinadi na laulauwewena yai haba kin sa tubu. ");
INSERT INTO bxh_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abelaham ya hoba lidi tanohi yai na ya liuhwa yo ibona ya libaliba, iyen, Yau haꞌa egu bolima 100 na haba sidohana be E fanatu? Sala haꞌa ena bolima 90 na haba gonowana ya fanatu? ");
INSERT INTO bxh_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abelaham ya liba fuyo Yaubada lisina, iyen, Aee–, em dudulai bena Isamaiyeli wa ita watan yo em loholoho wa felen. ");
INSERT INTO bxh_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","In moho, Yaubada ya liba, iyen, Tabu u liba doha. Lahum Sala haba natum taumoho ya yosi, na hesana haba wa tole Isako. Yau haba egu yali otaꞌota fahina E fawananaha ai lebena yo ana hiti mulita ai lisidi. ");
INSERT INTO bxh_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Isamaiyeli nuwatuhu wa anꞌeta haꞌa E atahi. Be tabu u mode. Egu faloholoho haba Isamaiyeli E felen, Na haba ya talu fanafanatu be ya famala boga yalayalaga yo ya famala sulu 12 edi aba fatubu, edi nuꞌu laꞌilaꞌi tamadi. ");
INSERT INTO bxh_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","In moho egu yali haba E ginauli Isako ai lisina, logena Sala haba ya yosi bolima hesa lahaina doha itete. ");
INSERT INTO bxh_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Yaubada ya libaliba ofi, ya lau afulen. ");
INSERT INTO bxh_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Somo Yaubada ya faliba mate, lahaina yai ya ginauli watan, be Abelaham natuna Isamaiyeli, salumadi ena luma yai sa tubu yo dodoga haisa nanatudi tatau ya fagabidi. ");
INSERT INTO bxh_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abelaham ena bolima 99, na mwagisana duduna ꞌwapina sa tomo. ");
INSERT INTO bxh_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Na natuna Isamaiyeli ena bolima mate 13. ");
INSERT INTO bxh_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abelaham ma natuna Isamaiyeli mate, tataudi luwaga mwagisadi dududi ꞌwapidi sa tomodi, lahai esega yai. ");
INSERT INTO bxh_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Yo tatau mahudoꞌidi Abelaham ena luma yai yo ena luma yai sa yosidi e sa unedi taꞌowawa lisidi yai mate, ma afa haidadi sa fagabi esegahidi. ");
INSERT INTO bxh_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Mamale ena oyagi laꞌilaꞌi sadaina yai, Guyau ya taumahata Abelaham lisina yai. Lahai laꞌi yai ena palai luhuluhu launa yai ya taꞌataꞌai. ");
INSERT INTO bxh_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abelaham ena aba taꞌataꞌai yai, ya itaꞌita hasa be tatau faihona ya itadi. Yo fede, ya feula lau lebedi, na ya failobahidi ma faꞌatitina ya dulu tanohi yai. ");
INSERT INTO bxh_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Abelaham ya liba, iyen, Aee–, egu guyau! Ibe wa mata amnaꞌegu, tabu u bayawaigu. Yau, um em tau paisowa. ");
INSERT INTO bxh_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Hola au anyawasi oyagi te ai loguloguna, na E lau hoꞌowa E yahiyama be ahemiu ami kaisudi. ");
INSERT INTO bxh_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Kalahe hola ami ya leyama au an, be haba amnamiu sa loholoho na habahim ami lau. Aho te ami laoma emi tau paisowa lebena. Alinana sa bui, tiyen, Ya loholoho wananaha! Somo wa nuwatuhui, u ginauli. ");
INSERT INTO bxh_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Yo fede, Abelaham ya fabelele lau Sala lisina palai ganahewana yai be iyen, Feula! U lau be fwalawa loholohona u tepa falaꞌi be u gabu. ");
INSERT INTO bxh_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Habahim ya fabelele ya lau bulumakau baiwadi yai, gubugubufwauna ya tohai, be ena paula tau abina ya felen, be ya asui feufeulai. ");
INSERT INTO bxh_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Na ya lau be bata yo miluki yo bulumakau asuꞌasuna ya abi nonohaidi ya ledima, be ya fakalahedi. Sa kalahe na in ya mwaimwaito oyagi ubuna yai. ");
INSERT INTO bxh_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Na sa fatiꞌoi, tiyen, Lahum Sala somo yai? Alinadi ya bui iyen, Kwalau au–, palai yai. ");
INSERT INTO bxh_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Habahim Guyau iyen, Bolima hesa maihala doha itete, Haba E fuyoma, na lahum Sala haba natum taumoho ya yosi. Sala ya ataꞌatahi, ena palai luhuluhu launa yai. ");
INSERT INTO bxh_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abelaham haꞌa ya tautaulaꞌi na Sala ya tinatinalaꞌi be hige gonowana i fanatu. ");
INSERT INTO bxh_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Yo fede, Sala ya liuhwa, na nuwa ganahewana yai iyen, Lahugu haꞌa ya tautaulaꞌi, yo yau haꞌa E tinalaꞌi, na haba sidohana bena E fanatu? ");
INSERT INTO bxh_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Habahim Guyau ya libalau Abelaham lisina, iyen, Paꞌana somo be Sala ya liuhwa na iyen, “Yau haꞌa E tinalaꞌi na sidohana haba E fanatu?” ");
INSERT INTO bxh_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ginauli somo hige gonowana Guyau i ginauli? Bolima hesa lahaina doha itete, Haba E fuyoma lisim, na lahum Sala haba natuna taumoho. ");
INSERT INTO bxh_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sala ya ꞌwasabu. Yo fede, ya bwala, iyen, Yau hige ya liuhwa. Na Guyau iyen, Na fede, wa liuhwa! ");
INSERT INTO bxh_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Fuyana taumana sa auꞌaulaha sa lau, Abelaham ya faꞌalatuhudi, Sodom sa itaꞌita lawen, amainiya ya ita faꞌoiluhudi. ");
INSERT INTO bxh_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Habahim Guyau iyebom, Somo bena E ginauli, haba Abelaham E faliba, e hafena? ");
INSERT INTO bxh_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abelaham laulauwewena haba sa adidili yo sa ouli, be dodoga mahudoꞌidi tanoꞌubu yai ai lisina haba loholoho sa abi. ");
INSERT INTO bxh_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Logena E fasinabo be haba nanatuna yo wahawahana, ya eda bwaꞌiyedi be Guyau ena laulau sa miyamiyaꞌedi, be Guyau ena liba fasunuma Abelaham lisina yai, ya ginauli. ");
INSERT INTO bxh_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Habahim Guyau iyen, Sodom yo Gomola dodogadi mate edi heyaheyaya sa laꞌi wananaha, yo laulau heyaheyayadi sa laulau ginauli mate, wasadi E atahiyedi. ");
INSERT INTO bxh_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Lisina yai, haba E lidi E itadi haba E sibai mate wananaha e bwalabwala. ");
INSERT INTO bxh_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Tatau luwaga sa aulaha sa lau Sodom, na Abelaham mate Guyau nuwanuwana yai ya obiꞌobiyo. ");
INSERT INTO bxh_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Habahim, Abelaham ya sigilau lisina, iyen, Haba tau dudulai yo tau heyaya wa wunu gogonidi? ");
INSERT INTO bxh_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ibe dodoga dudulaidi 50 duhu laꞌi ganahewana yai, haba sidohadi? Wananaha haba nuꞌuna wa faheyaya fahudoꞌi? E, haba nuꞌuna wa lau nuwa sahafu, dodoga 50 debadi yai? ");
INSERT INTO bxh_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Um, bena dodoga dudulaidi yo heyaheyayadi wa lau funuhi gogonidi? Mate hige laulau loholohona. Hige gonowana tau heyaya yo tau dudulai ai lisidi u ginauli doha. Tanoꞌubu tau fakasana bena laulau dudulaina ya ginauli. ");
INSERT INTO bxh_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Guyau iyen, Yena dodoga dudulaidi 50 Sodom duhu laꞌi ai ganahewana E lobahidi mate, ai debadi haba nuꞌuna ibege ya faheyaya. ");
INSERT INTO bxh_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Habahim Abelaham ya liba fuyo, iyen, Yau afusa gaibu. Hige egu loholoho hesa. In moho, aho te, E libalau Guyau lisina. Hige ya ꞌwasabu. ");
INSERT INTO bxh_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ibe dudulaidi 50, na faligigi sa heyaya? Haba duhu laꞌi mahudoꞌina wa faheyaya dodoga faligigi debadi yai? Guyau iyen, Ibe dudulaidi 45, hige gonowana ya faheyayadi. ");
INSERT INTO bxh_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abelaham ya liba fuyo Guyau lisina iyen, Ibe ainiya 40 wa lobahidi, haba sidohadi? Guyau iyen, 40 debadi yai ibege somo ya ginauli ai lisidi. ");
INSERT INTO bxh_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Habahim, iyen, Guyau tabu u manabala, hola ya falibam. Na ibe dodoga 30 dudulaidi ainiya wa lobahidi, haba nuꞌuna wa faheyaya? Yaubada iyen, Yena 30 E lobahidi, ibege somo ya ginauli. ");
INSERT INTO bxh_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abelaham iyen, Aho te, E libalau Guyau lisina, hige ya ꞌwasabu. Ibe 20 ainiya wa lobahidi, haba nuꞌuna wa faheyaya e higeꞌe? Guyau iyen, Yena 20, ibege ya lau kwaya. ");
INSERT INTO bxh_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Habahim, Abelaham iyen, Guyau tabu u manabala, na hola ya liba fuyo ma esega. Ibe safuhudohudoꞌi ainiya wa lobahidi, haba sidohadi? Alinana Guyau ya bui, iyen, Safuhudohudoꞌi ai debadi, ibege ya lau kwaya. ");
INSERT INTO bxh_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Lahaina yai, Guyau maꞌena Abelaham sa libaliba ofi. Habahim Guyau ya aulaha na Abelaham ya fuyo ena palai. ");
INSERT INTO bxh_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Maimailafina yai, Anelu luwaga sa mahano lau Sodom, na Lota mate ya taꞌataꞌai duhu laꞌi luhuluhu launa yai. Fuyana ya itadi mate ya obiyo fahi, be ya lau ya failobahidi, na ya hoba lidi, be ena faꞌatiti ya ginauli. ");
INSERT INTO bxh_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Na ya libalau lisidi iyen, Aee–, egu Guyau, Yauwedo! Au laoma egu luma be ahemiu au kaisudi. Haba iꞌipa aiteꞌi ami lau eno, na hwalahwalala haba ami aulaha boda. Alinana sa bui, tiyen, Higeꞌe, haba ai duhu laꞌi dobidobina ꞌe eno. ");
INSERT INTO bxh_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Na Lota ya dudu wananaha be ena nuwatuhu sa lau watan, yo fede, sa lau ena luma, be fwalawa fafayisti gesana ya tegategai, be ya fakalahedi. ");
INSERT INTO bxh_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Hola ma tuhutuhulidi, na Sodom duhu laꞌi dodogadi, hewahewali yo tatau lalaꞌi sa laoma be luma sa gana panpanen. ");
INSERT INTO bxh_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Na sa yogayoga lau Lota lisina, tiyen, Maihona yai tatau sa laoma lisim, mate somo yai? U ledima be ma afa haidamai ai luma gwaꞌu. ");
INSERT INTO bxh_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lota ya kalamahano lau ganamuli be luma edaꞌedana ya gudu. ");
INSERT INTO bxh_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Na ya libalau lebedi, iyebom, Afa haidagu, hafena! Tabu laulau heyaheyayana ni au ginauli. ");
INSERT INTO bxh_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Nanatugu luwaga wawahin hola hige gindi ti soꞌedi, haba E fakalamahanodima be emi nuwatuhu somo ai lebedi ami ginauli na tatau luwaga te, tabu somo ai lebedi au ginauli. Sa laoma te agu gilu. Iti agu matagabano. ");
INSERT INTO bxh_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Sa yogayoga tiyen, Um sai? U suha. Um yogayoga hiti, na sidohana bena wa famala ama tanuwaga? Doꞌata ꞌe tala faheyayam. Maꞌedi Lota sa faiꞌabi, be bena edaꞌeda sa lubi lopa. ");
INSERT INTO bxh_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Yo fede, matagabano luwaga luma ganahewana yai sa abilau Lota sa solu fafuyo ganahewa, na edaꞌeda sa gudu. ");
INSERT INTO bxh_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Dodoga edaꞌeda hafohafona yai, matadi sa fakwanabunabudi be edaꞌeda hafohafona sa fakaukau. ");
INSERT INTO bxh_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Yo fede, matagabano luwaga Lota sa faliba, tiyen, Afa botiyam, nanatum tatau yo wawahin e afa efam haisa duhu laꞌi ganahewana yai, e higeꞌe? U gelaedi. ");
INSERT INTO bxh_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Paꞌana dobuna te edi heyaheyaya sa laꞌi wananaha, logena be Guyau ya fatamalimai ꞌe laoma bena ꞌe gabu golu. ");
INSERT INTO bxh_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Be Lota ya lau nanatuna wawahin luwaga afa lalahudi haꞌa ya fasinabodi, ya falibadi iyen, Feula! Au aulaha, paꞌana Guyau duhu laꞌi te, haba ya gabu golu. Na edi nuwatuhu bena haga ya laulau faliuhwa. ");
INSERT INTO bxh_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ya ifi tatatali, anelu, Lota sa eli duduidi, tiyebom, Feula! U aulaha! Lahum yo afa nanatum wawahin luwaga u gelaedi. Doꞌata duhu laꞌi ena heyaheyaya yai, ami aiheyadoiti. ");
INSERT INTO bxh_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","In moho, Lota nuwana ya luwaluwaga. Yo fede, anelu sa abilau ma lahuna yo nanatudi wawahin luwaga nimadi yai sa solu weꞌaweꞌadi, be sa lau duhu laꞌi ganamulina yai, paꞌana Guyau ya nuwatohatohaedi. ");
INSERT INTO bxh_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Sa lau ganamuli yai, na anelu hesa ya falibadi, iyen, Nanabumiu, au gela! Tabu au timuli bui, yo tabu ai gonu au anyawasi. Au gela au lau tuꞌa. Haba ibege au peꞌi. ");
INSERT INTO bxh_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Maihala ya kepama, Lota ya mahano nuꞌuna yai. ");
INSERT INTO bxh_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Habahim, galewa yai, umeꞌehu ala balebalelemdi Guyau ya fatamalidima. Yo fede, Sodom yo Gomola sa alagolu. ");
INSERT INTO bxh_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Duhu laꞌi lalalaꞌi yo kikiꞌina mahudoꞌidi ya faheyayadi. Ginauli mwahumwahulidi yo umaꞌuma, oyagi, hawahawa yo suisui mahudoꞌidi ya gabu goludi. ");
INSERT INTO bxh_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lota lahuna mate mulidi yai ya laolaoma, na bena haga ya timuli. Yo fede, ya falen alita tupina ya obiꞌobiyo doha oitau. ");
INSERT INTO bxh_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Guyau ya loholoho Sala lisina yai, be somo Yaubada ya liba fasunuma wa, ya fawananaha. ");
INSERT INTO bxh_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Abelaham natuna taumoho, Sala ya yosi. Yaubada ena liba fasunuma ya fawananaha ena fuya tautaulaꞌi yai. ");
INSERT INTO bxh_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Sala natuna ya yosi, be Abelaham hesana ya tole: Isako. ");
INSERT INTO bxh_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Isako ena fuya tubu na ya lau ee–, lahai faligigi faihonana, Yaubada alinana Abelaham ya falau watan, be Isako mwagisana duduna ꞌwapina ya tomofahi. ");
INSERT INTO bxh_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Fuyana Abelaham ena bolima 100, Sala natudi Isako, ya yosi. ");
INSERT INTO bxh_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sala iyen, Yaubada agu liuhwa ya leyama, yo salumadi wasagu sa atahiyen, haba ma afa haidagu ꞌe liuhwa gogo. ");
INSERT INTO bxh_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Be Sala ya liba, iyen, Hige gonowana sai hesa Abelaham i faliba mate Sala haba wawaya ya ita watandi! In moho, ena fuya tautaulaꞌi yai natuna E yosi. ");
INSERT INTO bxh_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Gwama ya laꞌi ofi be nom sa fadabu, lahaina yai, Abelaham anꞌangogo laꞌilaꞌi ya ginauli. ");
INSERT INTO bxh_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Fuya ma esega, Hagala Natuna Isamaiyeli ya fafamanabala Isako lisina yai, na Sala ya ita. ");
INSERT INTO bxh_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Yo fede, ya libalau Abelaham lisina, iyen, Fayofayo tau abina waihinna ma natuna u duidi ti lau hudoꞌi paꞌana fayofayo tau abina natuna hige gonowana em ginauli tefana i abi. ");
INSERT INTO bxh_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abelaham nuwana ya heyaya wananaha, natuna Isamaiyeli lisina yai. ");
INSERT INTO bxh_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","In moho, Yaubada, Abelaham ya faliba, iyen, Tabu nuwam u famode. Somo lahum Sala ya falibam, u lau watan, paꞌana Isako ai lisina haba hesam ya laꞌi yo haba wa tadada. ");
INSERT INTO bxh_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Na hinaga em tau paisowa Hagala natuna Isamaiyeli ai lisina haba am hiti mulita ya tadada nuꞌu tefa mahudoꞌina yai, paꞌana Isamaiyeli hinaga um natum. ");
INSERT INTO bxh_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Bobonna ma hwalahwalalana Abelaham ya eno obiyo be anꞌan yo hoꞌowa leduna ya abi nonohaidi be Hagala ya fabahei, na habahim ma natuna ya duidi, be nuꞌu sa lau afulen. Hagala ma natuna sa lau Belesiba, nuꞌuna pitapitalina yai sa laulau gaibu. ");
INSERT INTO bxh_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Muli yai, habahim, Yaubada Abelaham ya lauꞌita. Ya libalau lebena, iyen Abelaham! Na Yaubada alinana Abelaham ya bui, iye, Yau ite. ");
INSERT INTO bxh_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Habahim Yaubada iyebom, Natu eseꞌesegam, Isako, wa fanuha wananahai, u foyahi, be u lau Moleya nuꞌuna. Ainiya natum u gabu golu, be ya famala em ainauya, tuꞌa hesa haba E libaen, ai hewana. ");
INSERT INTO bxh_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Bonbonna hola ma hwalahwalalana, Abelaham ya obiyo. Ena ainauya oyagina ya abi nonohai, be donki hewana yai ya au fapatudi. Tau paisowa luwaga yo Isako Abelaham ya foyahidi, sa lau, nuꞌuna somo Yaubada haꞌa ya faliba ana halulu. ");
INSERT INTO bxh_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Lahai fafaihonana yai, Abelaham matana ya falaba hitiꞌi, mate nuꞌuna eda lofalofa yai, ya ita lawen. ");
INSERT INTO bxh_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ena tau paisowa ya falibadi, iyen, Maꞌemiu donki aiteꞌi au miyamiya, na maꞌegu gwama te, ꞌe lau au–, ꞌe lauꞌuꞌula, na ai muli haba ꞌe fuyoma lisimiu. ");
INSERT INTO bxh_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abelaham ainauya oyagina ya abi, be Isako ya fabahei, na in nigo yo tauꞌala ya abidi, be sa lau luwaluwaga. ");
INSERT INTO bxh_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isako ya libalau tamana lisina, iyen, Tamagu? Abelaham natuna alinana ya bui, iyen, Natugu, somo? Isako iyen, Tauꞌala yo oyagi haꞌa ite, na ainauya sipi natuna, somo yai? ");
INSERT INTO bxh_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abelaham alinana ya bui, iyen, Natugu, Yaubada, ainauya sipi natuna haba ya nonohai, be te gabu golu. ");
INSERT INTO bxh_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Sa mahano lau Yaubada nuꞌuna ya libalibaen, Abelaham katakatan ya ginauli, na oyagi hewana yai ya toledi, habahim natuna ya auꞌaui, na ya faꞌeno oyagi hewadi yai. ");
INSERT INTO bxh_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Habahim nigo ya abi, na ya gegei, bena natuna ya gwali. ");
INSERT INTO bxh_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Na Yaubada ena anelu galewa yai ya yoga lidi lebena, iyen, Abelaham! Abelaham! Alinana Abelaham ya bui, iyen, Yau ite. ");
INSERT INTO bxh_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Yaubada iyen, Tabu nimam u faguli gwama ai hewana. Tabu somo hesa u ginauli ai lisina. Atabahim E sibai, mate Yaubada wa ꞌwasabuwen, paꞌana natum eseꞌesegana, hige u nuhafi. ");
INSERT INTO bxh_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abelaham matana ya falaba hitiꞌi, na ya timuli, mate sipi tamoꞌana ya ita, donana ya fatalaꞌafi oyagi kiukiu lagana yai. Ya lau ya abi, na ya gabu golu, ena ainauya. Ya famala natuna falau damahina. ");
INSERT INTO bxh_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abelaham nuꞌuna hesana ya tole: “Guyau ena felefele.” Aho te nuꞌuna hesana sa atahi “Guyau ena Felefele Oyana.” ");
INSERT INTO bxh_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Guyau ena anelu galewa yai ya liba fuyo, iyen, ");
INSERT INTO bxh_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Laulau te wa ginauli, be natu eseꞌesegam, hige u oihalaen. Be Yaubada ya angwala, iyen, ");
INSERT INTO bxh_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Egu loholoho haba E felem, na am hiti mulita haba sa tadada doha kipwala galewa yai, yo doha gelegele gabogabo sadaina yai, na adi waiyunu edi duhu balabalamumu haba sa eli halahalaedi. ");
INSERT INTO bxh_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Laulauwewem ai debadi, tanoꞌubu mahudoꞌina haba egu loholoho E feledi, paꞌana egu liba wa awaꞌabiyen. ");
INSERT INTO bxh_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Habahim Abelaham yo Isako sa fuyo ena tau paisowa lebedi, be sa fuyo Belesiba. Amainiya, sa miya fiyo. ");
INSERT INTO bxh_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Iyakobo ya fuyoma Padan Alam, na Yaubada ya taumahata fuyo lisina yai be ena faloholoho ya felen. ");
INSERT INTO bxh_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Yaubada ya libalau Iyakobo lisina iyen, Hesam “Iyakobo,” in moho hesam ibege ti atahi fuyoi “Iyakobo.” Hesam haba “Isalaela.” Logena Yaubada, Iyakobo hesana ya tole Isalaela. ");
INSERT INTO bxh_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Na Yaubada ya libalau lisina iyen, Yau Hewa Wananaha Yaubadana. U talu fanafanatu! Nuʼu boludi u fatubudi yo kin haba lisim yai sa tubu. ");
INSERT INTO bxh_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Tanohi Abelaham yo Isako E feledi haba E felem hinaga, yo tanohina te haba E fele faꞌawa wahawaham lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Habahim edi aba libaliba nuꞌuna yai, Yaubada ya lau afulen. ");
INSERT INTO bxh_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Iyakobo fafaꞌilala umeꞌehuna ya bono edi aba libaliba nuꞌuna yai. Ena antalasam wain yo oliwe ya fagoidi ya hin hewana yai, be ya famala Yaubada ena Nuʼu Fafatabuna. ");
INSERT INTO bxh_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Edi aba libaliba nuꞌuna mate Iyakobo hesana ya tole Beteli. ");
INSERT INTO bxh_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","17","Habahim Beteli yai sa aulaha. Efalati hola ma lofana na Leisulu taulina ya faꞌoitagu. Ena labalaba ya pilipili be ena kamkamna ganahewana yai tau abi falabalaba ya libalau lisina iyen, Tabu u ꞌwasabu paꞌana natum taumoho hesa. ");
INSERT INTO bxh_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Hanahanau haba ya peꞌi, na natuna hesana ya tole Ben-Oni. In moho tamana, Iyakobo hesana ya tole Beniyamin. ");
INSERT INTO bxh_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Leisulu ya peꞌi be Efalati edaꞌedana sadaina yai sa boꞌusai, (logena Betelehem). ");
INSERT INTO bxh_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Boꞌusana yai Iyakobo umeꞌehu ya bono. Umeʼehuna aho te mate Leisulu boꞌusana fafaʼilalana. ");
INSERT INTO bxh_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Iyakobo ya aulaha boda, ya lau Migidali Edeli ya famuli, be ena palai ya faʼobiyo bodai. ");
INSERT INTO bxh_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Iyakobo nuꞌuna yai hola ya gogogo na lahuna Bilaha yo natuna, Leubena sa luma gwaꞌu na wasadi ya atahi. Iyakobo nanatuna tatau mate safuhudohudoꞌi luwaga. ");
INSERT INTO bxh_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Liya nanatuna mate: tau tuwaha, Leubena, Simiyon, Lewi, Diuda, Isaka yo Sebulun. ");
INSERT INTO bxh_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Na Leisulu nanatuna mate Diyosepa yo Beniyamin. ");
INSERT INTO bxh_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Leisulu ena paula tau abina, Bilaha nanatuna mate Dan yo Nafatali. ");
INSERT INTO bxh_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Liya ena paula tau abina Silipa nanatuna mate Gada yo Asela. Iyakobo nanatuna te Padan Alam yai sa yosidi. ");
INSERT INTO bxh_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Iyakobo ya lau tamana, Isako lisina, Mamale nuꞌuna yai, Kiliyati-Aba sadaina yai. Aho te hesana Hebelon, Abelaham yo Isako edi aba gogo beyabeyana. ");
INSERT INTO bxh_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isako ya miya ee–, ena boliman 180. ");
INSERT INTO bxh_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Ya tautaulaꞌi wananaha, habahim ya peꞌi be nanatuna Isowa yo Iyakobo sa boꞌusai. ");
INSERT INTO bxh_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Isako somo yai ena aba miya mate amainiya hinaga natuna Iyakobo ya miya, Kanana tanohina yai. ");
INSERT INTO bxh_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Nanatuna dededi doha ite: Diyosepa mate hewali gubufwau, ena boliman 17 na ma afa haidana sipi sa itaꞌita watanidi. Afa haidana afa tinadi mate Bilaha yo Silipa, tamana lalahuna haisa. In moho wasadi heyayana Diyosepa tamadi ena ya liba. ");
INSERT INTO bxh_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Fuyana yai Iyakobo mate Diyosepa ya fanuha wananahai habahim nanatuna tatau hahaisa, paꞌana ena tautaulaꞌi fuyana yai na natuna ni ya tubu. Be logena, ana luhuluhu uliꞌulina ya ginauli. ");
INSERT INTO bxh_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Fuyana haidana sa ita mate tamadi ya gadosisiyen wananahai, yo fede sa ꞌwaiyoꞌoꞌen, hige ti faꞌifaꞌiluwen yo hige ti liba komakoman lau lisina. ");
INSERT INTO bxh_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Fuya hesa, Diyosepa ya eno suwai, be fuyana haidana edi ya dede mate habahim sa ꞌwaiyoꞌoꞌen wanawananahai. ");
INSERT INTO bxh_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ya falibadi iyen, Agu eno suwai hola emi ya dede, ");
INSERT INTO bxh_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","“Gabu yai witi pilipilinidi na hige walolona na egu pili ya obiyo dudulai, na umi emi pili sa obiyo fafataꞌiꞌili be sa dulu lidi lisina yai.” ");
INSERT INTO bxh_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Haidana sa faliba tiyen, Em nuwatuhu bena um ema baꞌisa?! Yo bena wa ita watanimai?! Ana eno suwai yo somo ya libaen lisina yai sa waiyoꞌo wananahaꞌen. ");
INSERT INTO bxh_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Fuya hesa Diyosepa afa haidana tamadi ena sipi sa lawedi Sekem nuꞌuna sadaina yai sa faꞌanbandi. ");
INSERT INTO bxh_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Mulidi yai, Iyakobo ya libalau Diyosepa lisina, iyen, Wa sibai afa haidam mate Sekem nuꞌuna sadaina yai sipi sa fafaꞌanbandi. Haba E fatamalim wa lau lebedi. Diyosepa tamana alinana ya bui iyen, Ya loholoho wananaha. ");
INSERT INTO bxh_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Yo fede Iyakobo ya libalau Diyosepa lisina iyen, Afa haidam yo sipi u lau u itadi, sidohadi, haba wa fuyoma be wasadi egu wa liba. Habahim Hebelon gonna yai ya fatamali ya lau. Fuyanna Diyosepa ya mahano Sekem nuꞌuna yai, ");
INSERT INTO bxh_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","mate ya fafalau gaibu na ya leu yo ya sai nuꞌuna yai. Taumoho hudoꞌi ya ita be ya fatiꞌoi, iyen, Somo wa yoꞌoyoꞌoi? ");
INSERT INTO bxh_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Diyosepa taumoho wa alinana ya bui, iyen, Haidagu E yoꞌoyoꞌoidi. Ibe wa falibagu iti somo yai sipi sa fafaꞌanbandi? ");
INSERT INTO bxh_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Taumoho wa iyen, Amaiteꞌi na haꞌa sa lau. E atahi tiyen, “Te lau Dotan.” Yo fede Diyosepa afa tuwahana ya lau watandi be ya lobahidi Dotan nuꞌuna sadaina yai. ");
INSERT INTO bxh_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Haidana eda lofalofa yai sa itaꞌita lau be sa ita. Hola hige i mahano lau lisidi na sa oilibaen bena haba sa wunui. ");
INSERT INTO bxh_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ibodi sa oiꞌoiliba, tiyen, Ma! Tau eno suwai ya laoma! ");
INSERT INTO bxh_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Au laoma ta wunui be ta lofe lidiyen ai hoꞌowa puluna hesa te haba tawa, “Suisui lululudi sa nali funuhi.” Haba ana eno suwai aniyona ya fawananaha, e higeꞌe?! ");
INSERT INTO bxh_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Fuyana Leubena ya atahiyen, mate haidana ya lau biliyedi, Iye, Tabu ta wunui. ");
INSERT INTO bxh_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Tabu ꞌwasinana nimada yai i didi. Ai pulu pitapitalina te, ta lofe lidiyen, nuꞌu pitapitalina yai te. Na tabu nimamiu i talu ai hewana. Leubena ya libalau haidana lisidi yai doha, paꞌana ena nuwatuhu mate, bena haba ya fofofahi be ya fafuyo tamadi lisina. ");
INSERT INTO bxh_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Fuyanna Diyosepa ya mahano lau mate, haidana ana luhuluhu uliꞌulina sa pwala fahi, ");
INSERT INTO bxh_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","na sa bahei be sa lofe lidiyen pulu pitapitalina yai. Puluna mate afafana, hige hoꞌowa. ");
INSERT INTO bxh_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Habahim sa taꞌai be sa kalahe; na sa itaꞌita lau mate Midiyan dodogadi Isamaiyeli laulauwewena tau uneꞌune Gileyada yai sa laolaoma sa itadi. Edi kamela hewadi yai mate mulamula hahahana yo panepanedi sa husanidi na sa lau Idipi. ");
INSERT INTO bxh_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Hidadi Diuda ya liba iye, Somo loholoho ainiya haba te abi, ibe tasida te wunui na ꞌwasinana te fui? ");
INSERT INTO bxh_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Au laoma ta uneꞌuneꞌen Midiyan dodogadi ai lisidi. Tabu ta wunui, in ꞌwasinada tefana. Yo fede haidana wa hidadi ena nuwatuhu sa lau watan. ");
INSERT INTO bxh_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Yo fede, fuyanna Midiyan dodogadi sa mahanoma mate Diyosepa afa haidana pulu pitapitalina yai sa solu hitiyama be sa uneꞌuneꞌen siluba ouꞌoulina 20. Isamaiyeli dodogadi, Diyosepa sa une be sa lawen Idipi. ");
INSERT INTO bxh_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Fuyana Leubena ya mahano fuyoma pulu pitapitalina ya ita, mate Diyosepa hige amainiya, yo fede ena kaleko ya ankam giginidi. ");
INSERT INTO bxh_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ya fuyo be haidana ya falibadi iye, Gwama hige amainiya! Haba somo E ginauli? ");
INSERT INTO bxh_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Habahim, haidana gouti sa wunui be ꞌwasinana yai Diyosepa ana leli sa dauꞌwai. ");
INSERT INTO bxh_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Leli uliꞌulina wa sa fafuyo tamadi lisina be sa liba, tiyen, Leli te ꞌe lobahi, haga u ita komakomaniꞌi. Bena natum ana leli e higeꞌe? ");
INSERT INTO bxh_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Tamadi leli ya ita lobahi na ya liba, iyen, Ii–, natugu ana leli! Nuwana suisui anꞌannalidi ti nali puliti! ");
INSERT INTO bxh_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Iyakobo ya nuwa heyaya be ena leli ya ankam pulitinidi na leli beyabeyadi ya liꞌodi. Natuna ya nuwa heyayaꞌen fuya lofalofa. ");
INSERT INTO bxh_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Nanatuna tatau yo wawahin nuwana bena sa faloholoho. In moho hige i fanuha. Ya liba iye, Agu nuwa heyaya te haba ai lisigu sigana bee–, E peꞌi. ");
INSERT INTO bxh_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Diyosepa tau unena sa lawen Idipi be sa uneꞌuneꞌen Kin Falo ena tau paisowa, gati edi baꞌisa hesana Potifa lisina yai. ");
INSERT INTO bxh_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Habahim Diyosepa sa lidiyen Idipi. Fuyana sa lawen amainiya, Idipi dogana Potifa, Falo ena tau paisowa hesa, gati edi laꞌilaꞌina Diyosepa ya une fahi Isamaiyeli dodogadi lebedi yai. ");
INSERT INTO bxh_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Guyau mate maꞌena Diyosepa, be ya famala tau fagogo na ya miyamiya ena baꞌisa Idiꞌidipina ena luma yai. ");
INSERT INTO bxh_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ena baꞌisa Potifa Diyosepa ya ita mate Guyau maꞌena, be Diyosepa somo ya ginaulidi mate sa loholoho wananaha. ");
INSERT INTO bxh_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potifa, Diyosepa ya mata amnaꞌen be ya famala in ena tau ita wata laꞌilaꞌina. Potifa ya tole be ena luma yo ena ginauli mahudoꞌidi ya ita watanidi. ");
INSERT INTO bxh_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Fuyana Potifa, Diyosepa ya faꞌobiyo ena luma yo ena ginauli mahudoꞌidi ya ita watandi mate, ena luma yo ana gabu Guyau ya faloholohodi, Diyosepa debana yai. ");
INSERT INTO bxh_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potifa ena ginauli mahudoꞌidi ya tole afuledi Diyosepa lisina yai, hige somo hesa i modeꞌen. Ena mode moho mate somo bena ya an. Diyosepa ya tau gigi yo hewalina ya loholoho. ");
INSERT INTO bxh_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Hige walolona, Potifa lahuna nuwana ya fabwala be ya libalau Diyosepa lebena iyen, U laoma, be ta eno! ");
INSERT INTO bxh_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","In moho Diyosepa ya waiyoꞌo, yo fede ya libalau waihin lisina, iyebom, Egu baꞌisa ya tolegu be ginauli mahudoꞌidi luma yai te E ita watanidi, logena be hige ginauli hesa i modeꞌen. ");
INSERT INTO bxh_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Hige baꞌisa laꞌilaꞌi luma yai te doha yau. Hige somo hesa i laugagayoꞌen lisigu yai. In moho hige i falibagu bena um be yau ta eno, paꞌana um mate lahuna. Sidohana haba laulau heyaheyayana te E ginauli Yaubada matana yai? ");
INSERT INTO bxh_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Fuya ouꞌouli waihin ya libalibalau Diyosepa lisina, na hige i fanuha bena i lau sadaina e maꞌena ti eno. ");
INSERT INTO bxh_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Lahai esega Diyosepa ya lau luma ganahewana be ana paisowa ya ginauli, na hige tau paisowa laꞌi ganahewa yai. ");
INSERT INTO bxh_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Waihin ya abilau ana luhuluhu yai na iyen, U laoma, ta eno! In moho, Diyosepa ya tagu asi be ya lau ganamuli yo fede ana lululuhu waihin ya fafafahi be nimana yai. ");
INSERT INTO bxh_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Lahaina yai, Diyosepa ya gela be ya lau ganamuli, na luhuluhu moho waihin ya tohatohai nimana yai, yo fede, ");
INSERT INTO bxh_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","waihin ya yoga lau tau paisowa lisidi ena luma yai, iyen, Ami ita! Lahugu, Hebelu dogana ya leyama lebeda mate ya fataumayamayada! Ya luhuma amaiteꞌi be bena maꞌegu ꞌe eno, in moho E yogayogaꞌen. ");
INSERT INTO bxh_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Maihalana yai ya atahi E fafatala yogaꞌen bena sagu E lobahi, yo fede ana luhuluhu ya lau afulen sadaigu yai na ya gela. ");
INSERT INTO bxh_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ana luhuluhu ya tole sadaina yai ee–, ena baꞌisa ya mahanoma. ");
INSERT INTO bxh_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Habahim enehena ya dede. Iyen, Hebelu dogana tau lau fayofayo wa leyama lisida mate ya laoma lisigu be bena ya aiheyaꞌegu. ");
INSERT INTO bxh_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","In moho E yogayoga bena sa saguhigu, yo fede ana luhuluhu ya lau afulen sadaigu yai na ya gela. ");
INSERT INTO bxh_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Fuyana Diyosepa ena baꞌisa lahuna dedena ya atahiyen, na waihin iyen, Em tau lau fayofayo ya tohatohaigu! Mate ya gafu pou. ");
INSERT INTO bxh_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Potifa, Diyosepa deli yai ya tole, kin ena pilisin edi aba miyamiya yai. ");
INSERT INTO bxh_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Na Guyau mate maꞌena yo ya faloholoho be mata amna deli tau ita watanina ya felen. ");
INSERT INTO bxh_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Yo fede deli baꞌisana, Diyosepa ya tole pilisin edi baꞌisa, yo paisowa mahudoꞌidi amainiya mate ya ita watan. ");
INSERT INTO bxh_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Be hige i mode, paꞌana Guyau maꞌena Diyosepa yo somo ya ginaulidi Guyau ya faloholohodi. ");
INSERT INTO bxh_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Fuya fisa mulidi yai, Idipi edi kin ana wain kapuna tau lawelawenina yo fwalawa tau gabugabu babaꞌisadi, lau pono sa ginauli kin lisina yai. ");
INSERT INTO bxh_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Ya manabala tau paisowa laꞌilaꞌidi luwaga te, lisidi yai, ");
INSERT INTO bxh_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","be ya falau delidi gati edi baꞌisa ena luma yai, somo yai Diyosepa ena aba falau delina. ");
INSERT INTO bxh_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","5","Gati edi baꞌisa, Diyosepa ya tole be ya ita watanidi. Kaputi tau lawelawenina yo fwalawa tau gabugabu deli yai sa miya lahai fisa mulidi yai, sa faiꞌeno suwai iꞌipa esega yai. In moho eno suwaidi aniyodi hige gonogonowadi. ");
INSERT INTO bxh_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Bobonna Diyosepa ya laoma ya itadi mate sa nuwa dubu. ");
INSERT INTO bxh_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Yo fede ya fatiꞌoidi iyen, Paꞌana somo nenemiu sa heyaya? ");
INSERT INTO bxh_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Alinana sa bui tiyen, Tataumai luwaga ama eno suwai hige sai hesa haba aniyodi i liba famahatadi. Habahim Diyosepa ya falibadi iyen, Yaubada in ibona mate eno suwai aniyodi ya fafamahatadi! Ami eno suwaidi au falibagu. ");
INSERT INTO bxh_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Yo fede kapu tau lawenina ana eno suwai ya dedei Diyosepa lisina yai, iyen, Agu eno suwai yai wain mahinana E ita nuwanuwagu yai, ");
INSERT INTO bxh_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","lagana faihona. Hige walolona ya taya, na wain uludi dulidi sa nanau. ");
INSERT INTO bxh_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Falo ana kapu E abiꞌabiꞌi, na wain uludi E abidi be E folo kapu ni ganahewana yai na Falo E felen. ");
INSERT INTO bxh_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Diyosepa ya faliba iyen, Am eno suwai aniyona doha ite: Laga faihona aniyona mate lahai faihona. ");
INSERT INTO bxh_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Lahai faihona mulidi yai Falo haba ya fafuyom be am paisowa wa abi fuyoi. Kapu haba wa felefelen doha ainiyadi. ");
INSERT INTO bxh_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Na yena ginauli sa lau dudulai lebem yai mate aee–, u nuwatuhuigu yo u nuwatohatohaegu. Falo u faliba be i kam fahigu deli yai te, ");
INSERT INTO bxh_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","paꞌana Hebelu edi tanohi yai sa angafuhigu be sa laweguma amaiteꞌi. Amaiteꞌi hinaga hige somo hesa ya ginauli faheyaya be halana yai haba ti falau deligu. ");
INSERT INTO bxh_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Fuyana kaputi tau lawelawenina, ana eno suwai aniyona Diyosepa ya dedei mate fwalawa tau gabugabu nuwana yai ya mahata, yo fede iyen, Yau hinaga agu eno suwai: Kulugu yai mate fwalawa noho faihona. 17 Noho hewa yai mate kalahe gabugabudi hudoꞌi - hudoꞌi Kin ana. In moho nohona hewa yai, kalahedi ataiꞌa sa anidi. ");
INSERT INTO bxh_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Diyosepa iyen, Noho faihona aniyona mate lahai faihona. ");
INSERT INTO bxh_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Lahai fafaihonadi yai Falo haba gadom ya ibo na ya fakautim ai oyagi. Na ataiꞌa haba taum sa aniꞌi. ");
INSERT INTO bxh_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Lahai fafaihonana mate Falo ena fuya tubu fanuwa hitinina, be ena tau paisowa laꞌilaꞌidi mahudoꞌidi edi anꞌangogo ya ginauli. Kapu tau lawelawendi edi baꞌisa yo fwalawa tau gabugabudi edi baꞌisa deli yai Falo ya soꞌe fahidi be ya lawedi ena tau paisowa lalalaꞌi nuwanuwadi yai. ");
INSERT INTO bxh_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Kapu tau lawelawendi edi baꞌisa ana paisowa ya fele fuyoi, be haba kapu ya tole bodai Falo ai nimana. ");
INSERT INTO bxh_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Na fwalawa tau gabugabudi edi baꞌisa ya fakauti, doha eno suwaidi Diyosepa ya liba famahata lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","In moho, kapu tau lawelawenina edi baꞌisa hige Diyosepa i nuwatuhui, ya nuwa fuiyen. ");
INSERT INTO bxh_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Bolima luwaga sa ofi, Falo ya eno suwai: Eno suwai ganahewana yai bena haga ya obiꞌobiyo Naili Hoꞌowana sadaina yai, ");
INSERT INTO bxh_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","na bulumakau faligigi luwaga tubutubudi hoꞌowa yai sa kalamahanoma be sa an hawahawa. ");
INSERT INTO bxh_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Mulidi yai, hinaga faligigi luwaga golegoledi, hoꞌowana yai hinaga sa kalamahanoma be sa obiꞌobiyo hoꞌowa kanaꞌugaugana yai. ");
INSERT INTO bxh_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Be golegoledi mate tubutubudi faligigi luwaga sa anidi. Yo fede Falo ya eno obiyo. ");
INSERT INTO bxh_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Habahim ya eno fuyo be ya eno suwai boda: Ana eno suwai mate witi maihawadi laꞌadi faligigi luwaga sa lau idahe sa in hewa esega yai. ");
INSERT INTO bxh_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Mulidi yai, kuludi laꞌadi faligigi luwaga sa in, sa kiu wananaha be yawana gigibwalina ya gabudi. ");
INSERT INTO bxh_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Witi maihawadi kikiꞌina mate witi maihawadi lalaꞌi yo laulau idahedi faligigi luwaga sa domdi. Habahim Falo ya obiyo; ya nuwatuhu lobahi mate, eno suwai. ");
INSERT INTO bxh_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Hwalahwalalana nuwana ya faiꞌabi, yo fede dodoga sibasibadi yo ayaꞌayahan mahudoꞌidi Idipi yai adi liba ya fatamalidi be sa laoma. Falo ana eno suwai ya falibadi in moho hige sai gonowana aniyodi i liba famahatadi. ");
INSERT INTO bxh_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Habahim kapu tau lawelawendi edi baꞌisa ya libalau Falo lisina iyen, Lau pono E ginauli matabahim haba E libaen. ");
INSERT INTO bxh_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Fuya ma esega, wa manabala, yau yo fwalawa tau gabuna lisimai yai be wa falau delimai gati edi baꞌisa ena luma yai. ");
INSERT INTO bxh_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Iꞌipa esega tataumai luwaga ꞌe faiꞌeno suwai, na eno suwaidi mate aniyodi sa laulau hudoꞌi. ");
INSERT INTO bxh_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Fuyana yai Hebelu hewalina, gati baꞌisana ena tau paisowa, mate maꞌemai. Ama eno suwai ꞌe faliba be aniyodi ya liba famahatadi lisimai yai. ");
INSERT INTO bxh_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Be aniyodi sa tubu: Yau agu paisowa E abi fuyoi, na hidagu sa fakauti. ");
INSERT INTO bxh_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Yo fede Diyosepa ana liba Falo ya fatamali, be feula deli yai sa leyama. Sapulana ya ibodi yo ena leli ya liꞌodi na ya laoma Falo lisina. ");
INSERT INTO bxh_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Falo ya libalau Diyosepa lisina iyen, Agu eno suwaina, hige gonowana sai haba aniyona i falibagu. Na wasam egu sa liba mate yena eno suwai sa dedeidi lisim yai mate, gonowana aniyodi wa liba famahatadi. ");
INSERT INTO bxh_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Falo alinana Diyosepa ya bui, iyebom, Hige gonowagu ya ginauli, in moho Yaubada haba em bui loholohona ya felen. ");
INSERT INTO bxh_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Habahim Falo ya libalau Diyosepa lebena iye, Agu eno suwai yai mate Naili hoꞌowana bubuna yai E obiꞌobiyo, ");
INSERT INTO bxh_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","fuyana yai bulumakau tinatinabawadi tubutubu loholohodi faligigi luwaga sa kepa hasaema hoꞌowa yai be sa anban hawahawa pwaludi yai. ");
INSERT INTO bxh_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Mulidi yai bulumakau faligigi luwaga yagayagadi yo nene heyaheyayadi hinaga sa kepa hasaema hoꞌowa yai. Hola hige bulumakau doha ya itadi Idipi tanohina yai. ");
INSERT INTO bxh_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Yagayagadi heyaheyayadi wa, bulumakau tubutubudi faligigi luwaga sa an faꞌofidi. ");
INSERT INTO bxh_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","In moho sa an maꞌudaidi mulina yai, nenedi hige ti buidi, paꞌana bogadi hige ti iyaꞌiya. Hige gonowana sai i ita lobahidi, mate sa anidi. Habahim E obiyo. ");
INSERT INTO bxh_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Agu eno suwai hesa doha ite, witi faligigi luwaga E itadi, sa lau idahe. Paꞌadi esega yai sa in. ");
INSERT INTO bxh_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Habahim mulidi yai witi faligigi luwaga hohohoyadi yo kikiꞌina wa, yawana ya towa be ya faheyayayadi, mate sa kala moꞌa. ");
INSERT INTO bxh_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Witi kikiꞌina wa witi laulau idahedi faligigi luwaga wa sa dom faꞌofidi. Nesu tau-itaꞌita E falibadi, in moho hige sai gonowana i liba famahata lisigu yai. ");
INSERT INTO bxh_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Habahim Diyosepa ya libalau Falo lebena iyen, Am eno suwaidi mate esega yo gonogonowadi. Yaubada somo haba ya ginauli mate ya famahata lebem yai. ");
INSERT INTO bxh_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bulumakau tubutubudi faligigi luwaga aniyona mate bolima faligigi luwaga, yo hinaga witi kuludi laꞌadi loholohodi faligigi luwaga; aniyodi gonogonowadi. ");
INSERT INTO bxh_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Bulumakau golegoledi faligigi luwaga muli yai sa kepama aniyona mate bolima faligigi luwaga, yo witi kuludi laꞌadi heyaheyayadi yawana gigibwalina ya gabudi aniyona mate bolima faligigi luwaga: Aniyona mate haba bolima faligigi luwaga galamo wesawesasa. ");
INSERT INTO bxh_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Somo E fafalibam te haba ya tubu paꞌana Yaubada somo haba ya ginauli, mate ya famahata lisim yai. ");
INSERT INTO bxh_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Mahula laꞌilaꞌi haba ai Idipi tanohina bolima faligigi luwaga. ");
INSERT INTO bxh_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","In moho ai muli haba galamo wesawesasa bolima faligigi luwaga. Haba mahula Idipi yai sa nuwa fuiyen, na galamo wesawesasa haba nuꞌuna ya faheyaya. ");
INSERT INTO bxh_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Mahula nuꞌuna haba sa nuwa fuiyen, paꞌana galamo wesawesasa muli yai ya laolaoma mate haba ya heyaya wananaha. ");
INSERT INTO bxh_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Baꞌisa! Eno suwai nene luwaga wa abidi, mata paꞌana mate Yaubada haꞌa ya nuwatuhu fatoha nonohai, be ibege walolona haba ya ginauli. ");
INSERT INTO bxh_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Be um Falo, bena doga nuwanuwatuhuna yo sibasibana wa yoꞌoi be wa tole be Idipi tanohina ya tanuwagai. ");
INSERT INTO bxh_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Bena tanohi tau ita watanidi wa faꞌobiyodi haba mahula bolima faligigi luwaga ganahewadi yai na Idipi sa lau gabu mate hesa - hesa ena pei faligigi yai mate ai ganahewadi nimagogo esega haba kin sa felen ya famala doha edi takesi. ");
INSERT INTO bxh_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Kin Falo ena gigibwali yai, mahula bolimandi matada yai, kalahena mahudoꞌina bena sa tano gogoidi be sa toledi siti yai, adi anꞌan. ");
INSERT INTO bxh_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Kalahe te bena gwalaidi nuꞌu te ana. Haba galamo wesawesasa bolima faligigi luwaga ai Idipi mate fapaisowadi, be ibege galamo wesawesasa nuꞌu i faheyaya. ");
INSERT INTO bxh_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Nuwatuhu ni, Falo yo ena tau paisowa laꞌilaꞌidi mahudoꞌidi sa fanuha. ");
INSERT INTO bxh_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Yo fede Falo ya fatiꞌoidi iyebom, Haba taumoho hesa te yoꞌoi doha Diyosepa. Taumohona bena Yaubada Yaluwana lisina yai. ");
INSERT INTO bxh_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Habahim Falo ya libalau Diyosepa lebena iyen, Fuyana Yaubada ginaulidi te ya faꞌitam, hige sai hesa nuwanuwatuhuna yo sibasibana doha um. ");
INSERT INTO bxh_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Um haba egu luma loholohona wa ita watan, yo egu dodoga mahudoꞌidi haba em nuwatuhu sa lau watanidi. Aba taꞌai faꞌatitina debana yai yau haba E laꞌi, habahim um. ");
INSERT INTO bxh_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Yo fede Falo ya libalau Diyosepa lisina iyen, Yau aho te, E tolem tau itaꞌita wata be Idipi tanohina mahudoꞌina wa ita watan. ");
INSERT INTO bxh_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Habahim Falo ana nimakau nima gigina yai ya kamfahi na ya tole Diyosepa nimana gigina yai. Luhululu loholohona sa ginauli lisina yai ya faleli yo gadogado gole yai sa ginauli ya fagadoi. ");
INSERT INTO bxh_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Diyosepa hesana Falo ya tole, Safenata Paneya na Potifela natuna Asenata ya felen ya fai. Potifela mate in Idipi yaubadana edi tau anꞌantalasam On Nuꞌuna yai. Yo fede Diyosepa Idipi nuꞌuna mahudoꞌina ya ita watan. ");
INSERT INTO bxh_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Fuyana Diyosepa ena boliman 30 mate, ya paisowa fatubu Idipi edi Kin Falo, enehena. Habahim Diyosepa Falo ya lau afulen na ya lau Idipi nuꞌuna mahudoꞌina ya ita. ");
INSERT INTO bxh_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Mahula, boliman faligigi luwaga. ");
INSERT INTO bxh_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Idipi yai, mahula bolima faligigi luwaga ganahewadi yai, kalahe mahudoꞌina Diyosepa ya tano gogoidi. Tefa hesa - hesa yai, kalahe sa uma mate hinaga ya pei gogonidi siti hesa - hesa yai. ");
INSERT INTO bxh_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Diyosepa kalahe boluna ya pei gogonidi, doha gabogabo gelegeledi; sa ouli wananaha, be fatili ya fatautau. ");
INSERT INTO bxh_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Hola galamo wesawesasa bolimanna hige i fatubu na, Diyosepa nanatuna tatau luwaga, lahuna Asenata ya yosidi. Tineꞌeuna tamana mate Potifela, Idipi edi yaubada hudoꞌi On nuꞌuna yai, edi tau antalasam hesa. ");
INSERT INTO bxh_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Tau tuwaha hesana ya tole Manase na iyen, Paꞌana Yaubada ya ginauligu be egu pilipili ouꞌouli yo tamagu ana boga mahudoꞌidi E nuwa fuiyedi. ");
INSERT INTO bxh_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Mahula Idipi yai bolima faligigi luwaga ya ofi, ");
INSERT INTO bxh_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","na galamo wesawesasa bolima faligigi luwaga ana fuya, doha haꞌa Diyosepa ya libaen. Nuꞌu hahaisa yai galamo wesawesasa. In moho, Idipi nuꞌuna yai dodoga mahudoꞌidi mate, adi sa soi. ");
INSERT INTO bxh_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Fuyanna Idipi mahudoꞌina sa fatubu galamo wesawesasa amnana sa abi, dodoga kalahe sa anꞌeta Falo lisina yai. Habahim Falo Idipi mahudoꞌidi ya falibadi iyen, Au lau Diyosepa lisina, somo ya falibamiu, au lau watan. ");
INSERT INTO bxh_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Fuyana galamo wesawesasa nuꞌu mahudoꞌina ya nuhuli, Diyosepa kalahe lumadi ya soꞌedi be kalahe ya uneꞌuneꞌedi Idipi dodogadi lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Yo fede, nuꞌu mahudoꞌidi dodogadi sa laoma Idipi be witi sa unedi Diyosepa lebena yai. ");
INSERT INTO bxh_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Witi, Idipi yai wasana Iyakobo ya atahiyen be nanatuna ya falibadi iyen, Sidohana be ami famata kinokino? ");
INSERT INTO bxh_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Wasa E atahiyen mate witi Idipi yai. Au hasai be ada au une. Doꞌata guliyam ya kamfunuhida. ");
INSERT INTO bxh_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Habahim Diyosepa haidana safuhudohudoꞌi sa hasai be witi sa unedi Idipi yai. ");
INSERT INTO bxh_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","In moho Diyosepa tasina Beniyamin, Iyakobo ya oihalaen, paꞌana tamana ya ꞌwasabu ibe heyaya i lobahi. ");
INSERT INTO bxh_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Be witi tau uneꞌune haisa sa laulau mate, Iyakobo nanatuna maidadi paꞌana galamo wesawesasa Kanana nuꞌuna yai hinaga. ");
INSERT INTO bxh_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Fuyana tanohina yai Diyosepa ya gawana, kalahe ya uneꞌuneꞌedi dodoga lisidi yai. Be fuyana haidana sa mahano, sa dulu lidi tanohi yai. ");
INSERT INTO bxh_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Maihalana yai haidana ya ita lobahidi, in moho bena haga in fali alina be ya fatiꞌo sagasagali lisidi yai. Iyen, Somo yai ami laoma? Alinana sa fafuyo tiyen, Kanana nuꞌuna yai ꞌe laoma, bena kalahe ꞌe une. ");
INSERT INTO bxh_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Haidana ya ita lobahidi, na iti hige in ti ita lobahi. ");
INSERT INTO bxh_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Habahim ya eno suwaiyedi wa, ya nuwatuhuidi be ya falibadi iyebom, Umi tau ita sipo! Ami laoma ema nuꞌu ena belubelu ami mainenei. ");
INSERT INTO bxh_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Alinana sa bui tiyen, Ema baꞌisa, higeꞌe. Ai em tau paisowa, ꞌe laoma witi ꞌe une. ");
INSERT INTO bxh_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Hesa - hesa ya libalau hidana lisina iyen, Dudulaina mate hidada debana yai heyaya te fahoina. Ena kamkamna te ita, fuyanna in pulu yai na ya anꞌetaida bena te saguhi, in moho hige ta modeꞌen. Debana yai sa toleda deli yai lahai faihona. ");
INSERT INTO bxh_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Leubena iyen, Haꞌa E falibamiu yawa, “Tabu heyaya au ginauli gwama ni ai lebena. In moho hige au mode! Aho ite haba ꞌwasinana giluna te bahei.” ");
INSERT INTO bxh_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Iti hige ti siba mate alinadi Diyosepa ya sibai, paꞌana fuyanna ya fafalibadi mate doga hesa ya buibuiʼi lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Habahim Diyosepa haidana ya falibadi iyen, Au sigima! Maihalana yai sa sigilau iyen, Yau hidamiu Diyosepa! Logegu, ami uneꞌune afulegu Idipi lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Yo hinaga iyen, Aho te, tabu au nuwa heyaya yo au manabala fuyoimiu paꞌana ami uneꞌuneꞌegu amaiteꞌi. Aniyona mate bena dodoga E fofo fahidi be Yaubada ya dui bwaꞌiyeguma amaiteꞌi. ");
INSERT INTO bxh_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Galamo wesawesasa bolimanna fafaluwagana nuꞌu yai te, na faligigi hola otadi mate ibege tanohi giyalina, uma yo lau gabu. ");
INSERT INTO bxh_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","In moho Yaubada ya dui bwaꞌiyeguma bena E fofomiu, E abi famwahulimiu yo bena laulauwewemiu E gwalaidi, be sa mwahumwahuli ai tanoꞌubu. ");
INSERT INTO bxh_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Logena Yaubada ya duiguma amaiteꞌi. Hige umi au duiguma. Ya tolegu doha Falo tamana, ena luma mahudoꞌina E tanuwagai yo Idipi mahudoꞌina tau ita watanina. ");
INSERT INTO bxh_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Doꞌata te, feula au fuyo tamada lebena be au faliba auwen, “Natum Diyosepa alinana doha ite: Guyau haꞌa ya tole Idipi mahudoꞌina tau ita watanina. Be u lidi lisina. Tabu u fadagege!” ");
INSERT INTO bxh_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","“Haba ai fadidina wa gogo, Gosen nuꞌuna yai: nanatum yo afa waham, em yosiyosi - sipi, gouti, bulumakau yo somo mahudoꞌidi lisim yai. ");
INSERT INTO bxh_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","“Ainiya haba ya ita watanim, paꞌana galamo wesawesasa bolima faligigi hola otadi. Yena higeꞌe, um yo am boga mahudoꞌidi ibege emi gogo.” ");
INSERT INTO bxh_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Yo fede Idipi sa lau afulen na sa fuyo tamadi Iyakobo lebena Kanana tanohina yai. ");
INSERT INTO bxh_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Sa faliba tiyen, Diyosepa ma mwahumwahulina! In mate Idipi mahudoꞌina ya ita watan. Iyakobo ya tauhiti; hige i kawawananahaꞌedi. ");
INSERT INTO bxh_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","In moho fuyanna Diyosepa somo ya falibadi mahudoꞌina sa dedei lisina yai yo aba husahusa Diyosepa ya fatamalidi bena haba ai lisidi sa husai fafuyo ya itadi, nuwana ya talu. ");
INSERT INTO bxh_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Be Iyakobo iyen, Matabahim E kawawananaha! Natugu Diyosepa hola ya mwahumwahuli. Matagu ma laulauna haba E lau E ita. ");
INSERT INTO bxh_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yo fede Iyakobo ena somo mahudoꞌidi ya faꞌaulahadi, na fuyanna ya mahano Belesiba yai, antalasam ya ginaulidi tamana Isako, ena Yaubada lisina yai. ");
INSERT INTO bxh_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Na iꞌipana Yaubada ya libalau lisina tautau yai, iyen, Iyakobo! Iyakobo! Alinana ya bui iyen, Ho, yau ite. ");
INSERT INTO bxh_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Yaubada Iyen, Yau, Tamam ena Yaubada. Tabu u ꞌwasabu, u hasai Idipi, ainiya haba yau E ginaulim be wa famala nuꞌu laꞌilaꞌi. ");
INSERT INTO bxh_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Haba E lau watanim be te hasai Idipi, na haba E fafuyom hinaga. Em fuya peꞌi yai, Diyosepa haba nimana yai matam ya kamtoudi. ");
INSERT INTO bxh_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Habahim Iyakobo Belesiba nuꞌuna ya lau afulen be nanatuna tatau sa lawen, yo lalahudi maidadi nanatudi kikiluka mate telela Falo ya fatamalidi amainiya sa awa. ");
INSERT INTO bxh_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Edi yosiyosi yo edi ginauli Kanana yai sa abidi mate hinaga sa lawedi. Na Iyakobo yo laulauwewena mahudoꞌidi sa lau Idipi: ");
INSERT INTO bxh_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Nanatuna tatau, afa wahana tatau, nanatuna wawahin, afa wahana wawahin yo nanatuna mahudoꞌidi ya lawedi. ");
INSERT INTO bxh_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Habahim, Iyakobo mate, Diuda ya dui bwaꞌiyen ya lau Diyosepa lebena be Gosen edaꞌedana bena ya fatalaha. Na fuyanna sa mahanoma Gosen nuꞌuna yai, ");
INSERT INTO bxh_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Diyosepa ena saliyoti sa nonohai be ya lau tamana ya failobahi Gosen yai. Maihalana yai tamana ya ita mate, ya safu na ya tan lofalofa. ");
INSERT INTO bxh_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Iyakobo ya libalau Diyosepa lebena iyen, Matabahim gonowana E peꞌi, paꞌana hola ma mwahumwahulim, E itam. ");
INSERT INTO bxh_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Isalaela mahudoꞌidi sa miya Idipi yai Gosen nuꞌuna yai, amainiya sa fagogo yo nanatudi sa ouli. ");
INSERT INTO bxh_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Iyakobo ya miya Idipi yai bolima 17, na ena bolima laꞌina mate 147. ");
INSERT INTO bxh_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ena peꞌi fuyana ya hanahanauma, natuna Diyosepa ya faliba, iyen, Nimam ai gasagu solasoladi u tole, na u angwala mate, ibege ai Idipi u boꞌusaigu. ");
INSERT INTO bxh_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Egu fanuha bena afa tamagu edi aba boꞌusaidi ainiya wa boꞌusaigu; Idipi i otawa na au lawegu somo yai edi aba toledi. Alinana Diyosepa ya fafuyo, iyen, Somo wa falibagu haba E lau watan. Iyakobo iyen, U angwala mate, haba wa lau-watan. ");
INSERT INTO bxh_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Be Diyosepa ya angwala, na Iyakobo, ena aba enoꞌeno yai Guyau ya fadebasae. ");
INSERT INTO bxh_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Fuya fisa mulidi yai, Diyosepa ena sa liba tiyen, Tamam ya asiyebo. Yo fede nanatuna tatau Manase, yo Ifelaim maidana sa lau. ");
INSERT INTO bxh_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Iyakobo sa faliba tiyen, Natum Diyosepa ya laoma lisim. Yo fede ya faꞌadidili fuyoi be ya taꞌai ena aba eno yai. ");
INSERT INTO bxh_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Iyakobo ya libalau Diyosepa lebena iyen, Lusi nuꞌuna yai Yaubada Hewa Wananaha yai ya taumahata lebegu yai Kanana tanohina yai be amainiya ena faloholoho ya felegu, ");
INSERT INTO bxh_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","na ya falibagu iyen, “Nanatum boludi haba E felem, na am hiti mulita haba sa famala boga yalayalaga. Yo tanohina haba E duwai wahawaham mulim yai edi tanohi otaꞌota fahina.” ");
INSERT INTO bxh_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Lahaina yai, hola hige ya laowa Idipi na nanatum luwaga tatau, Ifelaim yo Manase haꞌa sa tubu haba aiꞌegu; doha nanatugu tatau Leubena yo Simiyon. ");
INSERT INTO bxh_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Yena nanatum hahaisa sa tubu mulidi yai, mate um enehem; Na ai muli tanohina sa soiyen mate Ifelaim yo Manase ai hesadi haba nanatum hahaisa edi tefa sa feledi. ");
INSERT INTO bxh_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Diyosepa ya abilau wawaya luwaga nimadi yai, Ifelaim ya sana lau Iyakobo seuseulina yai, na Manase ya sana lau Iyakobo sibana yai, habahim ya lawedi tamana fadidina yai. ");
INSERT INTO bxh_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","In moho Isalaela nimana ya lau fabaladi be sibana yai ya abilau tau mulita Ifelaim boluboluna yai, na seuseulina yai ya abilau tau tuwaha Manase boluboluna yai. ");
INSERT INTO bxh_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Habahim ena faloholoho Diyosepa ya felen na iyen, Haba Yaubada, In logenana beyabeyana afa tamagu Abelaham yo Isako sa famuli watan, Yaubadana, in tau ita watanigu egu mwahuli mahudoꞌina fuyandi yai ya laoma ee–, lahai te, ");
INSERT INTO bxh_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","aneluna, in ya fofofahigu heyaheyaya mahudoꞌina yai, In, logena, haba ena faloholoho wawaya te ya feledi. Haba hesagu yo afa tamagu Abelaham yo Isako hesadi sa libalibaedi, yo haba sa tadada ai tanoꞌubu hewana. ");
INSERT INTO bxh_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Maihalana yai Diyosepa ya ita mate tamana sibana ya tole Ifelaim boluboluna yai, be nuwana ya heyaya; yo fede ya abilau tamana nimana Ifelaim boluboluna yai, ya tohai na bena ya tole lawen Manase ai boluboluna. ");
INSERT INTO bxh_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yo fede, Diyosepa iyen, Tamagu, Itete tau tuwaha. Ai sibam u abilau ai boluboluna. ");
INSERT INTO bxh_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","In moho tamana ya ꞌwaiyoꞌo, be iyen, E siba, natugu! In hinaga haba ya famala boga yalayalaga. In moho tasina haba ya laꞌi, habahim in, yo wahawahana haba sa tadada. ");
INSERT INTO bxh_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Lahaina yai ena faloholoho ya feledi, iyen, Ai hesamiu haba Isalaela faloholoho sa fapaisowa be tiyen: “Haba Yaubada ya ginaulimiu doha Ifelaim yo Manase.” Yo fede, Ifelaim ya tole bwaꞌiyen, na Manase muli yai. ");
INSERT INTO bxh_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Habahim Iyakobo ya libalau Diyosepa lisina iyen, Egu foꞌo hanahanau haba ya nanau. In moho Yaubada haba maꞌem yo ya fafuyom afa tamam edi tanohi. ");
INSERT INTO bxh_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Diuda Diuda, haidam haba sa noꞌonoꞌoꞌem, paꞌana am waiyunu ai gadodi haba wa abi. Haidam haba sa dulu matam yai. ");
INSERT INTO bxh_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Um doha laiyon gubugubufwauna. Am mwaiha wa wunui, na wa fuyoma. Wa eno na taum wa lolondi, doha laiyon laꞌilaꞌi adiꞌadidilina, haba sai gonowana ya fanohim? ");
INSERT INTO bxh_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Tuꞌe nimam yai, ibege i beꞌu, e baꞌisa ena tuꞌe, ahena solasoladi yai, ibege hinaga i beꞌu, ana sigana ee–, ya laoma tanuwagana lebena yo nuꞌu sa awa abi, mate in ena. ");
INSERT INTO bxh_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Haba em donki gubugubu fwauna wa auꞌauꞌaui, ai wain mahinana loholohona yai. Em leli haba wain yai wa kaisudi, wain nenena doha ꞌwasina balebalelemna. ");
INSERT INTO bxh_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Matam sa kwasina wain nomnomna yai, na susu nomnomdi yai be moꞌam sa kafu. ");
INSERT INTO bxh_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Fuyanna Iyakobo nanatuna ya faliba maꞌudaidi ahena ya toledi ena aba eno yai na ya umesi afulen. ");
INSERT INTO bxh_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Fuyana Diyosepa afa haidana tamadi sa ita mate ya peꞌi, be tiyen, Fuyana somo mahudoꞌina lisina yai te ginauli faheyaya, Be bena haba i manabalaꞌeda na i oilibaeda be haba ana hala i abi. ");
INSERT INTO bxh_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Be wasa tau lawenna sa fatamali lawen Diyosepa lisina be iyen, Tamam hola hige i peꞌi na ya liba, iyen, ");
INSERT INTO bxh_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","“Haidam, Tamam ena Yaubada ena tau paisowa, somo heyayana sa ginauli lisim yai mate edi heyayana u nuwatuhu afulen.” Diyosepa wasa te ya atahiyen, yo fede ya tan, paꞌana hola hige ti sibai mate, edi heyaya haꞌa ya nuwatuhu afulen. ");
INSERT INTO bxh_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Habahim afa tuwahana sa laoma be sa hoba lidi nuwanuwana yai, na tiyen, Ai em tau lau fayofayo. ");
INSERT INTO bxh_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Na Diyosepa ya falibadi iyen, Tabu au ꞌwasabu. Yau hige Yaubada. ");
INSERT INTO bxh_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Umi emi nuwatuhu bena ami faheyayagu, in moho Yaubada ya bui be somo aho ite ami ginauli ya faloholoho be dodoga boludi ya fofofahidi. ");
INSERT INTO bxh_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Be tabu au ꞌwasabu! Umi yo nanatumiu haba E ita watanimiu. Ena liba yai nuwadi ya liba faꞌadidilidi yo ya faliba komakomanꞌidi. ");
INSERT INTO bxh_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Diyosepa yo tamana ana boga mahudoꞌina sa miya Idipi yai. Ena bolima 110 na ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yo Ifelaim nanatuna hiti fafaihonana ya ita. Yo Manase natuna taumoho Makili nanatuna sa tubu sa toledi Diyosepa ahe paꞌana yai ya itadi hinaga. ");
INSERT INTO bxh_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Habahim Diyosepa haidana ya falibadi iyen, Haba E peꞌi. Yaubada haba ya nuwatuhuimiu be nuꞌu yai te ya foyahimiu, ami lau tanohi ya liba fasunumaꞌen, Abelaham, Isako yo Iyakobo lisidi yai ainiya. ");
INSERT INTO bxh_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Habahim Diyosepa ya liba be Isalaela nanatuna sa angwala tiyen, Yaubada haba ya saguhimiu, be siyadagu nuꞌu yai te ami baheidi. ");
INSERT INTO bxh_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Diyosepa ena bolima oulina 110 habahim ya peꞌi. Sa famaꞌi Idipi yai, na lati yai sa husan. ");
INSERT INTO bxh_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Iyakobo mananatuna sa lau Idipi, maꞌadi boga mate: ");
INSERT INTO bxh_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Leubena, Simiyon, Lewi, ");
INSERT INTO bxh_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Diuda, Isaka, Sebulun, Beniyamin, ");
INSERT INTO bxh_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Nafatali, Gada, yo Asela. ");
INSERT INTO bxh_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Iyakobo laulawenena oulina mate 70. Natuna Diyosepa haꞌa ya miya-bwaꞌi Idipi yai. Habahim, sa lau lebena. ");
INSERT INTO bxh_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Muli yai Diyosepa ya peꞌi. Afa haidana yo faledi hiti mahudoꞌidi hinaga sa peꞌi. ");
INSERT INTO bxh_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","In moho, wahawahana, Isalaela sa talu fanafanatu. Sa ouli wananaha be Idipi nuꞌuna sa famohafu wananahai. Boliman sa ouli wananaha, mulidi yai kin fwaufwauna hesa, hige Diyosepa i sibai, ya famala kin Idipi nuꞌuna yai. ");
INSERT INTO bxh_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","10","Ena dodoga ya falibadi iyen, Isalaela dodogadi sa ouli wananaha habahim ita. Bena te gududi tabu ti tadada. Ibe ada waiyunu ti saguhidi be ti hiyalaida na eda nuꞌu ti lau afulen. ");
INSERT INTO bxh_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Yo fede Idipi dodogadi mate fayofayo tau ita watandi sa faꞌobiyodi be Isalaela fayofayo yai sa dalu beleleidi paisowa yai. Isalaela dodogadi hinaga Baꞌisa Falo ana kalahe aba peipei gogondi taondi luwaga sa ginaulidi. Hesadi mate Pitom yo Lamese. ");
INSERT INTO bxh_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Sa lau fayofayoꞌedi be adi siga somo. In moho sa talu fanafanatu be Gosen nuꞌuna sa famohafu. Yo fede Idipi dodogadi sa ꞌwasabuwedi, ");
INSERT INTO bxh_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","Edi miya sa faheyaya wananahai, be paisowa mwahumwahudi doha biliki, simenta yo paisowa hesa - hesa gabu yai sa ginaulidi. Edi kamkamna yai Idipi hige edi nuwatohatoha Isalaela lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Yo fede Kin Falo liba adidilina ena dodoga ya feledi, iyen, Hebelu nanatudi tatau mahudoꞌidi haba ai hoꞌowa ami fakapulolodi. In moho, wawahin ti otawa. ");
INSERT INTO bxh_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Fuyana yai sulu Lewi dogana ena sulu waihinina hesa ya fai. ");
INSERT INTO bxh_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Na waihin, natuna taumoho ya yosi. Natuna nenena ya loholoho, yo fede ya simo nawalahi faihona. ");
INSERT INTO bxh_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Habahim, hawahawa hesana papailusi sa fapaisowa be noho sa fatuli, na kolutaꞌa yai sa pati fataꞌiꞌili be tabu hoꞌowa i luhulau ganahewana. Nohona yai gwama ya husai na ya lau be hawahawa lolofa hoꞌowa ganahewana yai ya simo. ");
INSERT INTO bxh_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Gwama wa lofuna sadai yai ya alasimo, be ya maimainene bena somo lofuna ai lisina ya tubu, haba ya ita. ");
INSERT INTO bxh_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Kin Falo natuna waiwaihin ya laoma bena ya sigu, na ena fayofayo tau abina waihin, mate ya tigatiga hoꞌowa sadaina yai. Ya itaꞌita lau be noho ya ita, hawahawa solasoladi yai. Yo fede, ena tau lau fayofayo ya fatamali, be ya lau ya abi. ");
INSERT INTO bxh_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Baꞌisa Falo natuna, noho ya ita mate, gwama ganahewa yai, ya tantan, be nuwana ya heyayaꞌen. Be iyen, Itete Hebelu wawayana hesa. ");
INSERT INTO bxh_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Yo fede, lofuna ya lau lisidi, be ya fatiꞌo, iyen, Gonowana E lau be Hebelu waihinina hesa E faliba be ya faseda? ");
INSERT INTO bxh_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Alinana ya bui, Ii–, Gonowana. Yo fede tineꞌeu ya lau, be gwama tinana ya aulen. ");
INSERT INTO bxh_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Baꞌisa Falo Natuna gwama tinana ya faliba, iyen, Gwama te u ita watan. Haba E famaisam. Yo fede ya abi, be ya ita watan. ");
INSERT INTO bxh_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Muli yai, gwama ya laꞌi, ya lawen baꞌisa natuna lisina, be ya faseda doha natuna wananahana. Iyabona iyen, Hoꞌowa yai ya poupouli, na E abi hitin, haba hesana E tole “Mose.” ");
INSERT INTO bxh_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mose ya fulasa, ya lau ena dodoga Sulu Hebelu fayofayo yai sidohana edi laulau beleleidi ya kepaidi. Yo Idipi dogana hudoꞌi, Mose falena alina taumohona ya talatalai ya ita hinaga. ");
INSERT INTO bxh_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mose ya itaꞌita asiꞌasi, be hige sai laꞌi i ita, yo fede, Idipi dogana ya lau funuhi, be silanna ya fui gelegele yai. ");
INSERT INTO bxh_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Bobonna ya fuyo mate, Hebelu tataudi luwaga sa lululu. Tau ponoli lisina yai ya libalau, iyen, Paꞌana somo hidam wa talai? ");
INSERT INTO bxh_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Taumoho wa Mose ya faliba, iyen, Sai ya tolem ema baꞌisa yo tau fafalau fatala dogana? Bena wa lau funuhigu doha Idipi dogana wa lau funuhi? Yo fede, Mose ya ꞌwasabu be nuwana yai iyen, Somo E ginauli mate dodoga haꞌa sa itagu? ");
INSERT INTO bxh_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Baꞌisa Falo wasa ya atahiyen, be ya anpate bena Mose ya lau funuhi. In moho, Mose ya gela be ya lau Midiyan Nuꞌuna yai ya miya. ");
INSERT INTO bxh_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mose botiyana Detelo, Midiyan dodogadi edi tau antalasam ena sipi yo gouti ya itaꞌita watanidi, ma baibaiwadi ya foya doheyedi nuꞌu pitapitalina be ya lau Sainai tuꞌana fafagabina yai. ");
INSERT INTO bxh_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Amainiya Yaubada ena anelu ya taumahata felen doha oyagi balebalelemna oyagi kiukiu atiꞌatipuna yai. Oyagi kiukiu ya alaꞌala, ya ita. In moho hige i ala fofo. ");
INSERT INTO bxh_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Nuwana yai iyen, Hige ya nuwatuhu lobahi. Paꞌana somo be oyagi kiukiu ni, hige i ala ofi? ");
INSERT INTO bxh_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Yaubada ya itaꞌita lau mate Mose ya sigisigilau, yo fede oyagi kiukiu, ganahewana yai ya yoga lau lisina iyen, Mose! Mose! Alinana Mose ya bui iyen, Yau, ite. ");
INSERT INTO bxh_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Guyau iyen, Tabu u sigima. Am ahe sumasuma u kamfahidi, paꞌana tanohi fafagabina yai wa obiꞌobiyo. ");
INSERT INTO bxh_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Yau mate wahawaham Abelaham, Isako, yo Iyakobo edi Yaubada. Yo fede Mose matana ya fakoudi paꞌana ya ꞌwasabu, Tabu Yaubada i ita. ");
INSERT INTO bxh_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Habahim Guyau iyen, Wananaha, egu dodoga sidohana edi fafahisu faheyayadi yo edi fafakamnadi Idipi yai haꞌa E ita. Tau lau faliuhwaidi debadi yai edi tan E atahi. Edi kamkamna E sibai. ");
INSERT INTO bxh_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Lisina yai E lidima bena Idipi nimadi yai haba E fofofahidi yo tanohina yai E abifahidi na E hasaedima ai tanohi loholohona te, ya laꞌi yo mahulana. Kanana, Hiti, Amoli, Pelesi, Hiwi, yo Debusi aho edi aba miya. ");
INSERT INTO bxh_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Egu dodoga edi tan E atahi wananahai, yo Idipi sidohana edi fafahisu faheyayadi yo edi fafakamkamnadi haꞌa E ita. ");
INSERT INTO bxh_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Aho te E duim, wa lau Idipi edi Kin lisina, be haba egu dodoga edi nuꞌu yai wa foyahidima. ");
INSERT INTO bxh_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Na Mose ya libalau Yaubada lisina, iyen, Yau doga gaibu. Yau sai be haba E lau Kin Falo lisina, be Isalaela E auledi Idipi yai? ");
INSERT INTO bxh_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Yaubada ya liba fuyo, iyen, Yau haba maꞌem, yo yena dodoga Idipi yai wa ledima, haba ai tuꞌana te ami fadebasaegu. Haba wa fawananaha mate Yau E fatamalim. ");
INSERT INTO bxh_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","In moho Mose ya liba fuyo iyen, Ibe E lau Isalaela dodogadi lisidi be E falibadi, yawa, “Wahawahamiu edi Yaubada ya duigu be E laoma lisimiu, haba sa fatiꞌoigu, tiyen, “Hesana somo? Haba somo E falibadi?” ");
INSERT INTO bxh_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Yaubada iyen, “Yau mate Yau!” Doha ite haba wa falibadi: In sai hesana “Yau” mate ya duigu be E laoma lebemiu. ");
INSERT INTO bxh_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","16","Isalaela u falibadi mate, Yau, Yaubada! Abelaham, Isako, yo Iyakobo, edi Yaubada. Logena, ya duigu be E laoma lisimiu. Hesagu te, haba ya ota esegahi; hiti mulita mahudoꞌidi haba hesagu sa atahi doha. U lau be Isalaela baꞌibaꞌisadi u yoga gogondi na u falibadi mate, Yau Guyau Yaubada, haꞌa E taumahata wahawahamiu yo umi hinaga lisimiu yai. Yo fede, Yaubada iyen, U falibadi mate, Yau E laoma lisidi be somo Idipi sa ginauli lisidi yai, haꞌa E itadi. ");
INSERT INTO bxh_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Na Guyau Mose ya faliba iyen, Haba iwala esega moho E leyama Falo yo Idipi dodogadi ai lisidi. Ai mulina haba ya biya afulemiu be nuꞌuna ami lau afulen. Na ena fuya biya afulemiu yai haba mahudoꞌimiu ya weꞌa ofinimiu. ");
INSERT INTO bxh_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","3","Guyau, Idipi dodogadi nuwadi ya buidi be Isalaela dodogadi sa mata amnaꞌedi. Na Idipi ganahewana yai Falo ena tau paisowa laꞌilaꞌidi yo dodoga hinaga mate Mose sa ita hitin. Yo fede iyen, Dodoga u falibadi: Tatau yo wawahin, sadaidi yai tau miya somo sa ginaulidi siluba yai yo gole yai bena sa anꞌetaidi. ");
INSERT INTO bxh_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Be Mose iyen, Guyau ya liba doha ite: Ai iꞌipa atipuna haba Idipi Nuꞌuna mahudoꞌina E bayawa. ");
INSERT INTO bxh_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Idipi nanatudi tatau halahalafwaudi yo Falo natuna halahafwauna haba tamana ya falau fadamahi ya lidi ee–, waihinna aba gisigisi yai ya paipaisowa, natuna taumoho tau tuwaha mate mahudoꞌidi haba sa peꞌi yo yosiyosi nanatudi halahalafwaudi haba mahudoꞌidi sa peꞌi. ");
INSERT INTO bxh_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Idipi nuꞌuna haba tan ꞌwalaꞌwalaui ya nuhuli. Hola hige tantan hesa doha ite, e ibege hesa fuya matada yai hinaga. ");
INSERT INTO bxh_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Idipi nuꞌuna haba tan ꞌwalaꞌwalaui ya nuhuli. Hola hige tantan hesa doha ite, e ibege hesa fuya matada yai hinaga. Na Isalaela dodogadi ganahewadi yai ibege ꞌwayowa ti gunanalu lau doga e yosiyosi hesa ai lisina. Logena, haba umi ami sibai mate Guyau Idipi yo Isalaela ya tole hinelidi. ");
INSERT INTO bxh_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Idipi yai Guyau ya libalau Mose yo Elon lisidi iyen, ");
INSERT INTO bxh_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Nawalahina bwaꞌibwaꞌina te, umi emi nawalahi. Emi bolima nawalahina bwaꞌibwaꞌina. ");
INSERT INTO bxh_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Isalaela mahudoꞌidi au falibadi mate nawalahi te lahaina fafa safuhudohudoꞌina yai, taumoho hesa - hesa bena sipi gubugubufwauna ya abi ana boga adi. Luma esega be adi esega. ");
INSERT INTO bxh_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Yena luma hesa ana boga hige ti ouli, be hige gonowadi ti an faꞌofi, bena sadaidi yai tau miya adi tefa sa feledi. Doga oulina yai sa soiyedi, ya lau wee–, gonogonowadi. ");
INSERT INTO bxh_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Yosiyosi ami fasinabodi bena tamoꞌanadi edi bolima esega, sipi e gouti, na asiꞌasiyebo gesadi, ");
INSERT INTO bxh_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Bena ami ita watandi ee–, nawalahi ni lahai 14 ya abi, habahim ai toutou bulu ami wunuidi. ");
INSERT INTO bxh_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Somo yai mwaiha ni edi aba anidi lumadi mate, bena ꞌwasina begana sa fawawadi luma edaꞌedadi tape duhuduhudi yai yo hewadi yai. ");
INSERT INTO bxh_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Maihonana eseꞌesegana yai bena mwaihana asuꞌasuna maꞌena waiꞌa kalakalapina yo fwalawa sesese gesana gabugabuna sa anidi. ");
INSERT INTO bxh_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Tabu sipi ma idaꞌidahena au an yo tabu au buꞌa. Bena mahudoꞌina ami gabu ai oyagi. Kuluna, ahena yo tauna ganahewadi bena ami gabudi. ");
INSERT INTO bxh_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Tabu au antole. Yena antole ya ota ee–, ya lahai, hwalahwalana bena ami gabu goludi. ");
INSERT INTO bxh_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Sipi emi anꞌanna haba doha ite: Emi luhuluhu bena ami bwaꞌulu yai ami faluhudi. Sendolo bena ami liꞌodi yo emi tuꞌe, ai nimamiu na bena ami an feufeulaidi. Ite Guyau ena Bayawa. ");
INSERT INTO bxh_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Iꞌipana ni haba Idipi nuꞌuna E bayawai be tatau yo yosiyosi nanatudi halahala fwaudi E tala funuhidi. Yau Guyau! Idipi dodogadi edi yaubada bwalabwaladi mahudoꞌidi haba E fakasadi. ");
INSERT INTO bxh_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Yena luma somo yai ꞌwasina E ita, ya famala emi fafaꞌilala, haba E bayawaimiu. Fuyana Idipi E fakamkamnadi, mate ibege iwala hesa i faheyayamiu. ");
INSERT INTO bxh_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Lahai te bena ami fafanuwa hitin. Hitina yo hitina, mataꞌasina bena ami ginauli Guyau lebena yai, be ya famala laugagayo otaꞌota fahina. ");
INSERT INTO bxh_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Idipi ami lau afulen, na fuya mulidi, ai lahai faligigi luwaga bena fwalawa fafayisti gesana ami an. Ai lahai bwaꞌibwaꞌina mate bena yisti emi luma yai ami lawe hudoꞌiyedi. Sai fwalawa fafayistina ana ya an lahai bwaꞌibwaꞌina yai ee–, lahai fafafaligigi luwagana yai, haba Isalaela lisidi yai sa tomo afulen. ");
INSERT INTO bxh_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Lahai bwaꞌibwaꞌina yo ai lahai fafaligigi luwagana bena ami faꞌoigogo be ami fadebasaegu. Ai lahaidi te, tabu au paisowa, na kalahe moho bena abi nonohaina, dodoga mahudoꞌidi adi. Ite moho gonowana ami ginauli. ");
INSERT INTO bxh_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Hitina yo hitina “Fwalawa Fafayisti Gesana Mataꞌasina” bena ami fafanuwa hitin, paꞌana lahaina ami boga Idipi yai E foya fahidi. ");
INSERT INTO bxh_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Mose, Isalaela babadadi mahudoꞌidi ya yoga gogonidi, be ya falibadi, iyen, Esega - esega haba sipi e gouti gubugubufwauna ya abi be ya lau funuhi. Haba maꞌana boga, Bayawa Anꞌangogona sa ginauli. ");
INSERT INTO bxh_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Mula hesa hesana Hisopa laꞌana esega au abi be yosiyosi ꞌwasinana aba hinina ainiya au dauꞌwai, na ai aba tape duhuduhu yo lau fabala au fawawadi. Ai mulina tabu u kalamahano be ya lau ee–, hwalahwalala. ");
INSERT INTO bxh_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Yena Guyau ya lau Idipi ya laufi bena ya wunuidi, haba ʼwasina ya ita luma tape duhuduhudi yai yo lau fabala yai, haba Tau Laulau Funu Aneluna emi luma ya bayawaidi, be ibege i lau funuhimiu. ");
INSERT INTO bxh_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Laugagayo te bena umi, nanatumiu yo wahawahamiu fuya matamiu yai ami fafalau watan. ");
INSERT INTO bxh_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Lahaina Guyau ena liba fasunuma nuꞌuna ami mahano, somo yai haba ya felemiu ni, bena faꞌatiti abiꞌabina te ami laulawen. ");
INSERT INTO bxh_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Na yena nanatumiu sa fatiꞌoimiu, tiyen, “Faꞌatiti abiꞌabina te, aniyona somo?” ");
INSERT INTO bxh_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Alinadi haba ami bui auwen, “Itete Guyau ena Bayawa Antalasamna fafaʼatitina paꞌana Idipi yai Isalaela edi luma ya bayawaidi na Idipi ya lau funuhidi, na ita higeꞌe.” Mose ya libaliba ofi mate Isalaela dodogadi sa hoba lidi be Guyau sa fadebasae. ");
INSERT INTO bxh_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Guyau liba adidilidi Mose yo Elon ya falibadi mate Isalaela dodogadi sa ginauli watanidi. ");
INSERT INTO bxh_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Iꞌipa atipuna yai Idipi nanatudi tau tuwaha mahudoꞌidi Guyau ya tala funuhidi. Falo natuna tau tuwaha ya lidi ee–, tau lau deli nanatudi bwaꞌibwaꞌidi yo yosiyosi nanatudi yosi bwaꞌibwaꞌina hinaga ya tala funuhidi. ");
INSERT INTO bxh_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Falo yo ena tau paisowa lalaꞌi yo Idipi dodogadi mahudoꞌidi ma iꞌipana sa obiyo na sa tan ꞌwalaꞌwaluidi, paꞌana luma mahudoꞌidi mate amainiya hinaga peꞌi. ");
INSERT INTO bxh_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Iꞌipana yai, Falo ya liba be Mose yo Elon sa laoma lisina. Ya falibadi iyen, Au aulaha! Egu dodoga au lau afuledi. Haꞌa doha ami fatiꞌo bena Guyau ami fadebasae, be au lau! ");
INSERT INTO bxh_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Emi yosiyosi baiwadi au lawedi. Na egu au anꞌeta be Guyau i nuwatohatohaegu. ");
INSERT INTO bxh_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Idipi dodogadi, Isalaela sa duidi bena feula edi nuꞌu sa lau afulen paꞌana Idipi edi nuwatuhu, tiyen, Doꞌata ꞌe peꞌi ofi. ");
INSERT INTO bxh_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Habahim Isalaela dodogadi Lamesi Nuꞌuna yai sa lau fote sa lau Sukoti Nuꞌuna. Ouꞌoulidi begana doha 600,000 na maʼedi wawahin yo wawaya hinaga. ");
INSERT INTO bxh_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Isalaela yo dodoga hahaisa ma afa haidadi sa laulau Sukoti Nuꞌuna. Yosiyosi baiwadi hinaga sa foyahidi. ");
INSERT INTO bxh_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Fwalawa fafayisti gesana Idipi yai sa leyama mate, lisina yai adi sa tegai, paꞌana fuyana Idipi yai sa weꞌa kokokolidi mate hige edi solasola bena adi kalahe ti nonohaidi. ");
INSERT INTO bxh_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Isalaela dodogadi Idipi yai sa miya mate bolima lofana 430. ");
INSERT INTO bxh_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Bolima 430 lahaina ofiꞌofina yai, Guyau ena dodoga pelena Idipi sa lau afulen. ");
INSERT INTO bxh_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Paꞌana maihonana yai Guyau ya tuhutuhuli be bena ya foya fahidi ai Idipi. Logena bolima ouꞌouli iꞌipa ni sa fasinabo ya famala Guyau edi aba nuwatuhuina be Isalaela hitina mahudoꞌina haba sa tuhutuhuli yo Guyau sa faꞌatitiyen, fuya ouꞌouli. ");
INSERT INTO bxh_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Guyau ya libalau Mose yo Elon lisidi, iyen, Bayawa anꞌangogona laugagayodi, itete: Laolaoma dogana ibege bayawa anꞌangogona kalahena ana i an. ");
INSERT INTO bxh_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Yena tau paisowa laꞌi ami une mate, mwagisana duduna ꞌwapina ami ibo papa bwaꞌiyen, in haba gonowana bayawa anꞌangogona anꞌanna ya an. ");
INSERT INTO bxh_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Sai laʼi ya miya fuya tupotupo lisimiu yai e moni ya paisowai ibege i anꞌan. ");
INSERT INTO bxh_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Ai luma somo ami abi nonohai mate ainiya bena ami andi, na tabu fisihona laʼi au lawen luma ganamulina. Yo sipi siyadana, tabu laꞌi au dem pwai. ");
INSERT INTO bxh_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Isalaela dodogadi mahudoꞌidi anꞌangogo te bena sa faʼatitiyen, ");
INSERT INTO bxh_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Laolaoma dodogadi lebem yai sa miyamiya yo tatau mahudoꞌidi falem tau miya sa fanuha bena Guyau ena Bayawa Anꞌangogona kalahena adi sa an, mate bena mwagisadi dududi ꞌwapidi sa ibo fahidi. Ai mulina gonowana sa kalahe na iti haba doha emi nuꞌu dodogadi haisa. ");
INSERT INTO bxh_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Laugagayona eseʼesegana Isalaela sa laulawen mate laolaoma hinaga sa laulawen. ");
INSERT INTO bxh_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Guyau liba adidili na ya libaen Mose yo Elon lebedi yai mate Isalaela mahudoꞌidi sa lau watanidi. ");
INSERT INTO bxh_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Lahaina yai ni, dodoga sulu yai Guyau ya fakalamahanodima Idipi yai. ");
INSERT INTO bxh_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Guyau ya libalau Mose lisina iyen, ");
INSERT INTO bxh_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Isalaela nanatudi tatau tau bwaꞌibwaꞌidi yo yosiyosi tamoꞌanadi tubu bwaꞌi mahudoꞌina au fatabudi yau ai lebegu. Tau wananaha e suisui, mahudoꞌina yau egu. ");
INSERT INTO bxh_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","12","Doha Guyau haꞌa ya liba fasunumaꞌen wahawahamiu lebedi yai: In haba ya lawemiu Kanana edi ai nuꞌu be haba ya felemiu. Ai mulina bena wawaya tatau tau tuwaha mahudoꞌidi yo yosiyosi tamoꞌanadi tubu bwaꞌibwaꞌidi mahudoꞌidi ami fele afuledi Guyau lisina yai. Mahudoꞌidi mate in ena. ");
INSERT INTO bxh_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Sipi natuna u antalasamen be donki natuna tamoꞌana yosi bwaꞌibwaꞌi maisana, na yena hige u fanuha bena u une bui mate donkina gadona wa filisi. Natum tau tuwaha u une bui fuyoi hinaga, paꞌana nanatumiu tau tuwahadi tatau mahudoꞌidi mate Guyau enehena. ");
INSERT INTO bxh_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Fuya matada yai, yena natum taumoho ya fatiꞌoim, iyen, “Laulau te ginaginaulidi te aniyona somo?” U faliba uwe, “Guyau ena gigibwali yai Idipi yai ya foya fahimai. Somo yai sa lau fayofayoꞌemai amainiya.” ");
INSERT INTO bxh_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Fuyana Falo ena mata dulu yai be hige i biya afulemai, yo fede wawaya tatau tubu bwaꞌibwaꞌidi yo suisui tubu bwaꞌibwaꞌidi mahudoꞌidi Idipi yai, Guyau ya wunuidi. Laulau te debana yai suisui nanatudi tubu bwaꞌibwaꞌidi ta antalasamedi yo nanatumai tatau tau tuwahadi ta une buidi. ");
INSERT INTO bxh_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Antalasam fafanuwa hitinina te doha fafaꞌilala nimam yai yo deba pogam yai mate Guyau ena gigibwali yai ya foyahida Idipi yai. ");
INSERT INTO bxh_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Sukoti nuꞌuna sa lau afulen, mulina yai palai sa pei hitinidi Etam nuꞌuna pitapitalina duduna yai. ");
INSERT INTO bxh_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Lahai yai Guyau ya bwaꞌi yada piꞌana yai be ya ita watanidi na iꞌipa yai mate oyagi balebalelemna yai mala ya feledi, be haba ai lahai e iꞌipa sa lau. ");
INSERT INTO bxh_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Fuyana Idipi edi Baꞌisa sa faliba mate Isalaela haꞌa sa gela, yo fede maꞌena tau paisowa lalaꞌidi edi nuwanuwatuhu sa buidi. Na tiyen, Paꞌana somo Isalaela te biya afuledi sa lau? Aho te hige gonowana ti paisowa boda. ");
INSERT INTO bxh_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Yo fede, ena saliyoti ya nonohaidi be ena tau hiyala ma afa haidana sa lau. ");
INSERT INTO bxh_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Ena saliyoti 600 loholoho wananahadi maꞌedi saliyoti hahaisa Idipi yai ya lawedi. Saliyoti mahudoꞌidi maꞌadi tanuwaga. ");
INSERT INTO bxh_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Guyau mate Idipi edi Baꞌisa Falo nuwana ya fapoꞌi be Isalaela ya lau weꞌa watanidi. Na Isalaela hige ti ꞌwasabu, ma nuwa adidilidi sa lau moho. ");
INSERT INTO bxh_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Falo ena hosi yo saliyoti, hosi tau gelugeluidi, yo tau hiyala mate, Isalaela dodogadi sa lau weꞌa watanidi, be somo yai edi an pei gwaꞌu Gabogabo Balebalelemna yai, Pi Hahiloti sadaina yai na Baꞌala Sefon mate tefa yai sa itaꞌita lawen. ");
INSERT INTO bxh_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Fuyana Falo ya kepa lau, na Isalaela sa itaꞌita hasa sa itadi sa laolaoma adi halulu, sa ꞌwasabu yo fede sa tan lau Guyau lisina. ");
INSERT INTO bxh_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Mose sa faliba tiyen, Nuwana Idipi nuꞌuna hige boꞌusa, be logena wa foyaimai nuꞌu pitapitalina yai te bena ꞌe peꞌi?! Idipi yai wa foya fahimai mate somo haꞌa wa ginauli?! ");
INSERT INTO bxh_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Idipi yai haꞌa ꞌe falibam, aiyawa, “U lau afulemai! Haba Idipi dodogadi edi ꞌe paisowa. Ibe edi ꞌe paisowa nuwana haba i loholoho wananaha, habahim peꞌi nuꞌu pitapitalina yai.” ");
INSERT INTO bxh_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mose dodoga alinadi ya bui iyen, Tabu au ꞌwasabu. Au obiyo esegahimiu na Guyau aho te ya fofofahimiu haba ami ita. Idipi dodogadi aho te ami itadi ibege au ita fuyoꞌidi. ");
INSERT INTO bxh_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Guyau haba enehimiu ya hiyala. Nuwamiu moho bena sa adidili. ");
INSERT INTO bxh_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Habahim Guyau ya libalau Mose lisina, iyen, Paꞌana somo be ami tantan laoma lisigu? Isalaela u falibadi be ti aulaha. ");
INSERT INTO bxh_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Em tuꞌe u lau hitini be nimam u lolon gabogabo ai hewana na gabogabo haba ya pei daili be Isalaela dodogadi haba ai tanohi pitapitalina sa dohe. ");
INSERT INTO bxh_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Idipi haba nuwadi E fapoꞌidi be Isalaela haba sa luhu watanidi. Falo ma ena tau hiyala, saliyoti, yo ena hosi tau gelugeluidi ai lisidi somo E ginauli haba sa noꞌoꞌegu. ");
INSERT INTO bxh_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Fuyanna somo E ginauli faꞌofi, Falo, ena saliyoti yo hosi tau gelugeluidi lisidi yai, haba Idipi sa sibai mate, Yau Guyau. ");
INSERT INTO bxh_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Yaubada ena anelu, Isalaela edi hiyala tataudi nuwanuwadi yai ya fuyo mulidi yai na yada piꞌana nuwanuwadi yai hinaga ya fuyo mulidi yai be ya todi, ");
INSERT INTO bxh_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Idipi yo Isalaela atiꞌatipudi yai, yadana Idipi ya fakamumudi, na Isalaela mala ya feledi be hiyala tataudi maihonana hige gonowadi ti sigilau Isalaela lisidi. ");
INSERT INTO bxh_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mose nimana ya lolon lawen gabogabo hewana na Yaubada kaluwabu adiꞌadidilina ya fatowa be gabogabo ya tamo daili. Maihona ya towa ee–, tanohi ya pitali. ");
INSERT INTO bxh_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Yo fede, Isalaela sa sola gabogabo yai be tanohi pitapitalina sa lau watan. Hoꞌowa ya peiꞌi, tefa luwaluwaga yai doha bilibili. ");
INSERT INTO bxh_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Idipi sa lau weꞌa watanidi be sa tafo gayogayo gabogabo yai ma hosihosidi, edi saliyoti, yo tau awaidi. ");
INSERT INTO bxh_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Begana haba ya ifi tatatali, Yaubada oyagi balebalelemna piꞌana yai yo yada yai ya itaꞌita lidima be ya fanuwa ponoponodi. ");
INSERT INTO bxh_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Saliyoti ya falau sopudi be adi paisowa ya laꞌi. Idipi tiyen, Guyau Isalaela edi ya lau! Ta lau afuledi! ");
INSERT INTO bxh_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Yaubada ya libalau Mose lebena iyen, Nimam u lolon lawen gabogabo ai hewana be haba ya didi fuyoma be Idipi ma salisaliyotidi yo hosi tau awaidi ai hewadi. ");
INSERT INTO bxh_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Yo fede, Mose nimana ya lolon lawen gabogabo hewana yai. Ya lahai mate, gabogabo ya didi fuyoma. Idipi bena sa gela, in moho, Guyau ya pei lidiyedi gabogabo yai. ");
INSERT INTO bxh_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Gabogabo ya didi fuyoma be Falo ena tau hiyala mahudoꞌidi sa lau weʼa wata be edi saliyoti, hosi yo tau awaidi mahudoꞌidi sa kapulolo, hige sai laʼi i mwahuli. ");
INSERT INTO bxh_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Isalaela ibodi moho sa sola gabogabo ganahewana yai, na gabogabo mate, tefa luwaluwaga yai ya peiꞌi. ");
INSERT INTO bxh_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Lahaina yai mate, Yaubada Isalaela ya saguhidi Idipi nimadi yai. Idipi sa faipeꞌipeꞌinidi, gelegele yai sa itadi. ");
INSERT INTO bxh_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Na fuyana Isalaela, gigibwali laꞌilaꞌi sa ita, Guyau ya famahata Idipi lisidi yai, mate dodoga Guyau sa ꞌwasabuwen, be edi sunuma sa tole lisina yai, yo ena tau paisowa, Mose lisina yai. ");
INSERT INTO bxh_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Habahim Mose yo Isalaela dodogadi wana te sa wanai Guyau lisina yai: Haba E wana lau Guyau lisina paꞌana in ya hasai wananaha. In mate hosi yo tau awaidi ya fakapulolodi gabogabo yai. ");
INSERT INTO bxh_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Guyau tau sagusaguhigu adiꞌadidilina; yo in agu lili, in tau fofofahigu. In egu Yaubada haba E fadebasae. Tamagu ena Yaubada, haba E tole hitin. ");
INSERT INTO bxh_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Guyau mate, tau hiyala; Hesana mate Guyau. ");
INSERT INTO bxh_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Falo ena saliyoti yo ena tau hiyala ya peidi gabogabo yai. Ena tau paisowa loholohodi mate, Gabogabo Balebalelemna yai sa kapulolo. ");
INSERT INTO bxh_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Gabogabo ya fakoudi; sa bulu lidi badamna yai doha umeꞌehu. ");
INSERT INTO bxh_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Guyau, Agutoꞌi! Nima sibam ena adidili ya faꞌabi noꞌonoꞌo be waiyunu ya lei hafihafitidi yo ya fili pwaipwaidi. ");
INSERT INTO bxh_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Em adidili yai, saluma sa fawaiyunum wa pei lidiyedi. Em manabala doha oyagi alaꞌalana be wa gabudi doha hawahawa tuyatuyadi peꞌipeꞌidi oyagi ya gabu faꞌala fofodi. ");
INSERT INTO bxh_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Wa yahafuwa hisum galidi yai Hwayahwayau gabogabo ya peiꞌi, doha bilibili, na badamna ya pitali. ");
INSERT INTO bxh_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Waiyunu ya nuwa saesae iyen, “Haba E weꞌa watanidi be E fafuyodima; edi gogo haba E soiyedi, na somo E fanuha haba E abi aiꞌegu; haba egu baineti E abi na E wunuidi.” ");
INSERT INTO bxh_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Wa yahafuwa lau, yo fede, Idipi sa kapulolo; sa bulu gabogabo yai, doha somo mwahumwahuna ya bulu. ");
INSERT INTO bxh_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Aee–, Guyau, yaubada ouꞌouli ganahewadi yai, hige sai hesa doha um. Um, tabuna wananahana, yo em namanamali ya loholoho, yo noꞌo abiꞌabidi wa lau ginauli! ");
INSERT INTO bxh_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Nima sibam wa lolon be tanohi ama waiyunu, ya domdi. ");
INSERT INTO bxh_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Em dodoga wa une fahidi, haba wa foyahidi em gadosisi otaꞌota fahina yai. Em adidili yai haba wa ita watanidi, be sa lau em aba miya fafatabuna yai. ");
INSERT INTO bxh_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Dodoga sa atahi, be ꞌwasabu ya famohafudi; Filisitiya dodogadi nuwadi sa dagugu. ");
INSERT INTO bxh_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Idom babadadi, aluwadi sa potifahi, Mowabi edi tatau menamenadi, sa tabutabubu; na Kanana dodogadi nuwadi sa welo. ");
INSERT INTO bxh_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ꞌWasabu, mahudoꞌidi ya famohafudi. Aee–, Guyau nimam gigibwalina yai ibege ti mwahiu, doha umeꞌehu hige gonowana ti mwahimwahiu ee–, em dodoga wa une fafuyodi, sa bayawa. ");
INSERT INTO bxh_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Um haba wa ledima em tuꞌa yai wa famiyadi, nuꞌuna, um Yaubada, haꞌa wa abi nonohai be em aba miya. Lumana tabuna Iyabom wa faꞌobiyo. ");
INSERT INTO bxh_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Guyau haba wa kin ee–, hige ana siga. ");
INSERT INTO bxh_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Fuyana Falo, ena hosi, saliyoti yo tau awaidi sa gayo gabogabo yai, Guyau ya fahin dagi fuyoi be Idipi sa kapulolo, na Isalaela tanohi pitapitalina yai sa dohe. ");
INSERT INTO bxh_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Habahim Peloweta Miliyam, Elon lofuna tambalin ya abi, na wawahin mahudoꞌidi ma tambatambalin sa lau watan yo sa leꞌileꞌi. ");
INSERT INTO bxh_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miliyam edi ya wana, Au wana lau Guyau lisina, paꞌana ada waiyunu haꞌa ya lei hafihafitidi; hosi yo tau awaidi ya fakapulolodi. ");
INSERT INTO bxh_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Habahim Mose Isalaela dodogadi Gabogabo Balebalelemna yai ya foyahidi, be sa lau nuꞌu pitapitalina hesana Sula. Lahai faihona nuꞌu pitapitalina yai sa lau, na hige hoꞌowa laꞌi ti lobahi. ");
INSERT INTO bxh_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Sa mahano nuꞌu hesa hesana Mala yai. In moho, hoꞌowana mate ya kalapi, be hige gonowana ti nom. Logena, hesana sa tole: Mala. ");
INSERT INTO bxh_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Dodoga sa fatalapili Mose lisina yai, tiyen, Somo haba ꞌe nom? ");
INSERT INTO bxh_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mose ya lauꞌuꞌula lau Guyau lebena, be Guyau oyagi piꞌana Mose ya faꞌita, na ya pei lawen hoꞌowa yai; yo fede, hoꞌowa wa, amnana ya loholoho. Amainiya, Guyau laugagayo ya feledi, be bena sa lau watanidi, yo amainiya hinaga ya lau itadi. ");
INSERT INTO bxh_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Fuyanna Isalaela dodogadi Idipi sa lau afulen mate Elim nuꞌuna yai sa aulaha. Nawalahi fafaluwagana yai, na lahaina safuhudohudoꞌi fafaligiginana yai sa mahano Sin Nuʼuna Pitapitalina yai. Sin nuꞌuna mate Elim yo Sainai atiꞌatipudi yai. ");
INSERT INTO bxh_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Nuꞌu pitapitalina yai, mahudoꞌidi sa fatalapili lau Mose yo Elon lisidi. ");
INSERT INTO bxh_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Tiyen, Idipi yai ibe Guyau ya lau funuhimai haba olina. Amainiya ꞌe miyamiya mate ama mwaiha yo kalahe. Na aho te, ami foyahimai, be ꞌe laoma amaiteꞌi, haba guliyam ya kamfunuhimai. ");
INSERT INTO bxh_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Habahim Guyau ya libalau Mose lisina iyen, Ai galewa haba ami kalahe E fatamali lidiyeyawa. Lahai ouꞌouli dodoga bena sa lau ganamuli be lahai esega nonoina yai adi sa tano gogo. Haba laulau yai te E lauꞌitadi be E siba mate egu liba sa lau watan, e higeꞌe. ");
INSERT INTO bxh_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Lahai fafaligigi esegana yai, haba lahai luwaga kalahena sa tanoi, be sa abi nonohai. ");
INSERT INTO bxh_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Guyau, Mose ya falibadi, iyen, ");
INSERT INTO bxh_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Isalaela u falibadi, uwen, “Emi fatalapili mahudoꞌina haꞌa Guyau ya atahiyedi, be maimailafi haba anihi E felemiu. Na hwalahwalala haba kalahe laꞌina somo sa fanuha, sa abi. Haba sa sibai Yau Guyau, mate edi Yaubada.” ");
INSERT INTO bxh_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Maimailafina ataiꞌa baiwadi sa lofoma be nuꞌu sa lau fafamohafu. Yo fede sa tohaidi, be sa buꞌadi, adi mwaiha. Na ya ifi tatatali mate, kipwala bwasuludi edi aba pei palai ya fataꞌiꞌili. ");
INSERT INTO bxh_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Kipwala bwasuludi sa pitali na ginauli hesa hebehebena nenena doha hama hunadi tanohi hewana yai sa ota. ");
INSERT INTO bxh_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Isalaela sa ita mate hige ti sibai, be sa fafatiꞌo fuyoꞌidi, tiyen, Ite somo? Mose ya falibadi, iyen, Guyau ami kalahe ya felemiu, bena ami an. ");
INSERT INTO bxh_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Guyau ya fatalahamiu iyen, “Bena emi luma ganahewana yai tau miya oulina yai ami, ami tano watan, doga esega - esega, ana laꞌina lita esega.” ");
INSERT INTO bxh_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Yaubada Isalaela ya falibadi be sa ginauli doha: haisa sa tano faꞌouli, na haisa fisa moho. ");
INSERT INTO bxh_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Na fuyana sa lufadi, mate sai ya tano falaꞌi, mate ana hige i laꞌi wananaha, na sai ana begana mate, hige i kiu wananaha. ");
INSERT INTO bxh_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mose ya falibadi iye, Tabu laꞌi au antole bobon enehena. ");
INSERT INTO bxh_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","In moho haisa hige Mose alinana ti lau watan, be adi tefadi sa antoledi. Hwalahwalalana mate, sa hulohulo, yo sa bofa, be Mose ya manabalaꞌedi. ");
INSERT INTO bxh_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Hwalahwalala ouꞌouli esega - esega ana ya tano, gonogonowana yai; na maihala ya gigibwali, somo ota fahina tanohi yai, sa welo. ");
INSERT INTO bxh_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Lahai fafaligigi esegana yai mate, lahai luwaga anꞌannina sa abi nonohaidi, lita fati be doga esega ana. Luma esega - esega edi babada sa laoma be Mose enehena sa liba, ");
INSERT INTO bxh_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","be alinadi ya bui, iyen, Guyau ya fatalahamiu mate bobon ena anyawasi lahaina tabuna. Aho te, somo bena ami gabu, mate au gabu yo somo bena, ami buꞌa mate, au buꞌa. Na somo ota fahina mate, au tole hudoꞌiyen bobon, enehena. ");
INSERT INTO bxh_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Mose somo ya fafatalahadi sa ginauli watan. Somo ota fahidi, sa toledi bobon enehena, hige ti heyaya e ti hulohulo. ");
INSERT INTO bxh_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mose iyen, Kalahena aho te au aniꞌi paꞌana aho te Sabati lahaina, Guyau enehena. Aho ibege kalahe laꞌi ai tanohi. ");
INSERT INTO bxh_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Lahai fafaligigi esegana yai haba kalahe ami, ami tano, na lahai fafaligigi luwagana, mate anyawasi lahaina. Ibege kalahe laꞌi ainiya au lobahi. ");
INSERT INTO bxh_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","In moho, lahai fafaligigi luwagana yai dodoga haisa sa lau, kalahe sa yoꞌo, na hige adi ti lobahi. ");
INSERT INTO bxh_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Habahim Guyau ya libalau Mose lisina iyen, Dodoga te haba ma fisa alinagu ami moꞌa peiyedi? ");
INSERT INTO bxh_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Bena ami siba mate Yau, Guyau, emi anyawasi E felemiu. Debana yai, lahai fafaligigi esegana yai mate, lahai luwaga kalahena E felemiu. Lahai fafaligigi luwagana yai ni dodoga mahudoꞌidi edi aba miya yai haba sa miya, na ibege edi luma ti lau afuledi. ");
INSERT INTO bxh_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Be lahai fafaligigi luwagana yai, dodoga sa anyawasi. ");
INSERT INTO bxh_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Isalaela dodogadi kalahena hesana sa tole “mena.” Itaꞌitana doha tuma kafukafuna, na amnana doha bisiketa, ma amoꞌamona sa gabu. ");
INSERT INTO bxh_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Bolima 40 Isalaela dodogadi mena sa anꞌaniꞌi ee–, Kanana nuꞌuna sa lau mahano, be amainiya sa miya. ");
INSERT INTO bxh_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Nonoi sa fapaisowa mate, edi noho, laꞌina gonogonowana doha 20 lita. ");
INSERT INTO bxh_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Isalaela mahudoꞌidi Sin Nuꞌuna Pitapitalina sa lau afulen. Guyau ena liba yai sa lau nuꞌu hesa - hesa. Lefidim yai edi palai sa peidi, in moho amainiya hige hoꞌowa be haba adi ti nom. ");
INSERT INTO bxh_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Sa fatalapili Mose lisina yai, tiyen, Hoꞌowa u felemai be ai nom. Mose alinadi ya bui iyen, Sidohana be Guyau ami lauꞌita? Emi nuwatuhu bena Guyau ibege i saguhida? ");
INSERT INTO bxh_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Na dodoga mate sa gadomagu be hola sa fafatalapili Mose lebena yai, tiyen, Paꞌana somo Idipi yai wa foya fahimai be te laoma? Bena ma nanatumai yo ema yosiyosi gadomagu ya kamfunuhimai? ");
INSERT INTO bxh_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Yo fede Mose ya lauꞌuꞌula lau Guyau lisina iyen, Somo haba dodoga te ai lisidi E ginauli? Begana haba sa lau umeꞌehuigu. ");
INSERT INTO bxh_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Guyau, Mose ya faliba iyen, Isalaela babadadi haisa ma afa haidam au bwaꞌi. Em tuꞌe haꞌa wa fapaisowa be Naili Hoꞌowana wa lubi daili, u abi hinaga. ");
INSERT INTO bxh_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Haba ai matam E obiyo umeꞌehu ai hewana, Sainai Tuꞌana yai. Tuꞌe u faꞌoiyen ai umeꞌehu, haba hoꞌowa ya didima be dodoga sa nom. Yo fede, Mose doha ya ginauli Isalaela babada matadi yai. ");
INSERT INTO bxh_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Nuꞌuna hesana ya tole, “Masa yo Meliba,” paꞌana Isalaela sa fatalapili yo paꞌana Guyau sa lauꞌita fuyana tiyen, Guyau maꞌeda, e higeꞌe? ");
INSERT INTO bxh_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amaleki sa laoma be Isalaela sa tulufi lawedi Lefidim yai. ");
INSERT INTO bxh_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mose ya libalau Diyesuwa lisina, iyen, Dodoga haisa u abidi be Amaleki au hiyalaidi. Bobon haba tuꞌe Yaubada ya felegu E abi, na ai uduhuli hewana E obiyo. ");
INSERT INTO bxh_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yo fede, Diyesuwa, Mose alinana ya lau watan, be sa lau Amaleki sa hiyalaidi, na Mose, Elon yo Hula mate, sa hasai uduhuli hewana yai. ");
INSERT INTO bxh_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Yena Mose nimana ya lau hitin mate, Isalaela edi adidili sa abi. In moho yena nimana ya tole lidiyen, Amaleki edi adidili sa abi. ");
INSERT INTO bxh_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Yena Mose nimana sa yahayaha, Elon yo Hula, umeꞌehu sa leyama be hewana yai ya taꞌai, na iti sadaina yai sa obiyo be nimana sa laulau hitin, sa toha didin yee–, maihala ya bulu. ");
INSERT INTO bxh_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Yo fede Diyesuwa, Amaleki ya lei hafihafitidi baineti yai. ");
INSERT INTO bxh_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yaubada ginauli mahudoꞌina ya ginauli fuyanna Idipi yai Mose yo Isalaela dodogadi ya fofofahidi wasana mate botiyana Detelo, Midiyan edi tau anꞌantalasam, ya atahiyen. ");
INSERT INTO bxh_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","Mose lahuna, Sipola ma nanatuna tatau luwaga ya fatamali lawedi botiyana lisina mate ya yogaidi ena luma yai. Natuna hesa hesana Gesom paꞌana Mose iyen, Nuꞌu hesa yai E laoma, ");
INSERT INTO bxh_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","na natuna hesa hesana ya tole Eliyesa paꞌana ya liba iyen, Fuyanna Idipi edi baꞌisa bena ya wunuigu na tamagu ena Yaubada ya saguhigu. ");
INSERT INTO bxh_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Detelo yo Mose lahuna Sipola ma nanatuna sa laoma nuꞌu pitapitalina yai, somo yai Mose edi palai aba peidi, Yaubada ena Tuꞌa Fafagabina sadaina yai. ");
INSERT INTO bxh_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Liba haꞌa ya fatamali bwaꞌiyen Mose lisina yai mate iti sa laulau lisina. ");
INSERT INTO bxh_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Sa mahanoma mate Mose ya lau ya failobahidi. Botiyana nuwanuwana yai ya dulu na ya tamahiti be ya falafu. Ya lautoꞌiyedi habahim sa luhulau palai yai. ");
INSERT INTO bxh_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ginauli mahudoꞌina Yaubada ya ginauli Idipi dodogadi maʼedi edi baꞌisa lebedi yai bena sidohana Isalaela dodogadi ya fofofahidi mate Mose botiyana ena ya liba. Edaꞌeda yai heyaheyaya sa fahoinadi na Guyau sidohana ena fofofahidi hinaga ya falibadi. ");
INSERT INTO bxh_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Guyau ginauli loholohodi mahudoꞌidi Isalaela lebedi yai ya ginaulidi be Idipi nimadi yai ya fofofahidi. Detelo ya atahiyen mate nuwana ya amna, ");
INSERT INTO bxh_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","be iyen, Guyau te fadebasae, in logena Idipi dodogadi nimadi yai yo edi kin, Falo nimana yai ya fofofahimiu. ");
INSERT INTO bxh_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Matabahim E siba mate Guyau ya gigibwali wananaha habahim yaubada hudoꞌi - hudoꞌi. Ya ginauli doha ite paꞌana Idipi dodogadi Isalaela sa abi heyayaidi. ");
INSERT INTO bxh_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Habahim, Detelo antalasam gabugabuna yo antalasam hahaisa ya leyadima Yaubada lisina na Elon maꞌena Isalaela babadadi mahudoꞌidi sa lau be sa anꞌangogo Yaubada matana yai. ");
INSERT INTO bxh_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","14","Bobonna Mose dodoga ya falau fataladi. Sa obiyo fataꞌiꞌili hwalahwalala ya lau ee–, maimailafi. Fuyanna Mose ginauli mahudoꞌina ya ginauli Detelo ya ita mate ya fatiꞌo iyen, Sidohana be doha ite wa ginauli dodoga lisidi yai? Paꞌana somo ibom wa falau fataladi na dodoga mahudoꞌidi sa obiyo fataꞌiꞌilim hwalahwalala ya lau ee–, maimailafi? ");
INSERT INTO bxh_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mose botiyana Detelo alinana ya bui fafuyo iyen, E ginauli doha ite paꞌana dodoga sa laoma lebegu bena Yaubada ena fanufanuha sa sibai. ");
INSERT INTO bxh_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Yena edi pilipili, sa ledima lisigu haba E fadosidi yo Yaubada ena laugagayo E fasibadi. ");
INSERT INTO bxh_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Habahim Detelo iyen, Hige laulau dudulaina u ginauli. ");
INSERT INTO bxh_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Um yo dodoga haba kamnamiu ami faheyayadi paꞌana paisowa ni ya laꞌi, hige gonowam ibom u ginauli. ");
INSERT INTO bxh_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Aho te u ataꞌatahima na haba E liba fasibasibam. Yo Yaubada haba maꞌem! Um dodoga edi tau libaliba Yaubada lisina yai yo edi pilipili wa ledima lisina. ");
INSERT INTO bxh_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Yaubada ena laugagayo bena wa liba fanuwa tagudi yo miyamiya sidohana, u fatalahadi. Somo bena sa ginauli mate u fatalahadi hinaga. ");
INSERT INTO bxh_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Tatau paisowa gonowadi sa ginauli mate u fasinabodi. Iti bena Yaubada tau ꞌwasabuwenna yo dodoga dududulaidi yo bena laulau bwalabwala adi ꞌwaiꞌwaiyoꞌo. Haba dodoga 1000, 100, 50, yo 10 sa ita watanidi. ");
INSERT INTO bxh_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Iti haba dodoga sa fafadudulaidi fuya ouꞌouli. Pilipili lalalaꞌi mahudoꞌidi haba sa lediwa lebem na kikiꞌinadi iti ibodi haba sa fadudulaidi. Haba am paisowa begana sa fakufefe be ami faimalamalaha. ");
INSERT INTO bxh_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Yena Yaubada ena nuwatuhu wa lau watan be doha wa ginauli, ibege i kamnam i heyaya yo dodoga ni haba ma nuwa taludi sa fuyo edi luma. ");
INSERT INTO bxh_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Detelo ena gaimumu Mose ya lau watan ");
INSERT INTO bxh_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","be Isalaela mahudoꞌidi ganahewanadi yai babaꞌisa paisowa gonowadi sa ginauli, ya lau famwaito be sa famala 1000, 100, 50, yo safuhudohudoꞌi adi tanuwaga. ");
INSERT INTO bxh_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Adi paisowa mate dodoga sa fafadudulaidi fuya ouꞌouli. Pilipili lalalaꞌi sa lawedi Mose lisina na kikiꞌina ibodi sa fadudulaidi. ");
INSERT INTO bxh_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Habahim Mose botiyana ya lau aiyoniyen be Detelo ya fuyo ena nuꞌu. ");
INSERT INTO bxh_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Isalaela dodogadi Idipi sa lau afulen. Lefidim Nuꞌuna yai sa aulaha mate nawalahi luwaga sa ofi habahim sa mahano Sainai nuꞌuna pitapitalina yai be amainiya edi palai sa faꞌobiyodi, tuꞌa paꞌana yai. ");
INSERT INTO bxh_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Habahim Mose ya hasai Yaubada lebena na tuꞌa yai Guyau ya yoga lau lisina be ya faliba iyen, Isalaela dodogadi iti Iyakobo laulauwewena u falibadi doha ite: ");
INSERT INTO bxh_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Somo E ginauli Idipi lisina yai haꞌa ami ita yo ami sibai sidohana E baheimiu be E leyamamiu lisigu, doha magesubu, natuna gubugubufwauna ya bahei mabena yai. ");
INSERT INTO bxh_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Be egu liba ibe ma nuwa ofi fahimiu ami lau watan yo egu yali nuwamiu yai ami abi didini, haba dodoga nuꞌu mahudoꞌidi ganahewadi yai E fasinabomiu, egu fatabu dodogadi paꞌana tanoꞌubu mahudoꞌina, Yau, enehegu. ");
INSERT INTO bxh_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Mahudoꞌimiu haba egu tau anꞌantalasam yo egu dodoga fafatabudi. ");
INSERT INTO bxh_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Yo fede, Mose ya fuyo lidi be babada ya yoga gogonidi. Habahim Guyau somo ya faliba, mahudoꞌina ya falibadi. ");
INSERT INTO bxh_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Na dodoga mahudoꞌidi ena liba sa bui tiyen, Guyau somo ya falibam haba mahudoꞌina ꞌe ginauli. Yo fede somo sa faliba wa, ya fuyo be Guyau ya faliba. ");
INSERT INTO bxh_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Guyau ya libalau Mose lisina iyen, Haba yada dubadubana ai ganahewana E laoma lisim, be te libaliba. Haba dodoga sa atahi na haba um sa kawawananahaꞌem. Habahim dodoga somo sa libaen mate, Mose ya lau be Guyau ena ya liba. ");
INSERT INTO bxh_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Na Guyau alinana ya bui iyen, U lau dodoga lebedi be u falibadi mate aho yo bobon fadebasae enehena ti abi nonoha be edi nuwanuwatuhu yo laulau ti fadudulaidi yo edi kaleko ti kaisudi. ");
INSERT INTO bxh_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Na ai lahai fafaihonana bena haꞌa sa nonoha, paꞌana lahaina ni haba ai Sainai Tuꞌana E leta lidiwa na dodoga mahudoꞌidi haba sa itagu ");
INSERT INTO bxh_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Dodoga adi sigasiga tuꞌa paꞌana yai au tole fataiꞌilidi haba ibege sigasigadi ti diꞌoidi, na u falibadi tabu tuꞌa ni ti finahei e ti sigilau sadaina yai. Yena sai ya diꞌo, haba ami tala funuhi. ");
INSERT INTO bxh_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Bena ami lau umeꞌehui e ai kukupidu ami gwali, na tabu au abiꞌina. Dodoga yo yosiyosi ami ginaulidi doha. In moho, yena bwagigi sa yufi mate, dodoga tuꞌa ti finahe. ");
INSERT INTO bxh_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Habahim, Mose ya fuyo lidi dodoga ya falibadi be sa abi nonoha. Edi ginauli sa kaisudi, ");
INSERT INTO bxh_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","na Mose ya falibadi, iyen, Asubena au nonoha, tabu au luma gwaꞌu. ");
INSERT INTO bxh_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Lahai fafaihonana hwalahwalalana, namanamali yo palepalele na yada piꞌana laꞌilaꞌi, tuꞌa hewana yai ya taumahata, yo fede, bwagigi alinana laꞌilaꞌi sa atahi. Dodoga mahudoꞌidi ꞌwasabu ya kam fafatabubudi. ");
INSERT INTO bxh_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mose dodoga edi palai yai ya auledi be sa lau tuꞌa paꞌana yai, Amainiya Yaubada sa failobahi. ");
INSERT INTO bxh_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Sainai tuꞌana mate gafu laꞌilaꞌi ya fakou buluhi, paꞌana Yaubada ya lidima doha oyagi alaꞌalana. Gafu afaꞌafa gigigibwalina. Nuꞌuna mahudoꞌina mate ya tuhutuhu. ");
INSERT INTO bxh_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Bwagigi alinana mate ya laꞌi wananaha, na Mose ya libalau Yaubada lisina, na palele luhana yai, Mose alinana Yaubada ya bui, iyen. ");
INSERT INTO bxh_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yaubada ya lidima Sainai tuꞌana hewana yai, be Mose ya yogai hasaen. ");
INSERT INTO bxh_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Habahim Guyau ya libalau lisina iyen, U fuyo lidi be dodoga u liba fanuwa tagudi tabu adi sigasiga ti diꞌoidi be ti laoma ti itagu; yena sa dudu be sa laoma, boludi haba sa peꞌi. ");
INSERT INTO bxh_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Yaubada ya liba, na ena libadi itete: ");
INSERT INTO bxh_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Yau Guyau emi Yaubada! Lau fayofayo nuꞌuna yai E fakalamahanomiu. ");
INSERT INTO bxh_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Tabu yaubada hahaisa au fadebasaedi, Yau moho. ");
INSERT INTO bxh_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Galewa, tanoꞌubu e hoꞌowa ginaulidi nenedi oitaudi tabu au ginaulidi. ");
INSERT INTO bxh_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Tabu au tuli bono e au lauꞌuꞌula lau oitau hesa lisina, paꞌana Yau Guyau emi Yaubada mate nuwa elaꞌela Yaubadana. Tina yo tama edi heyaya debadi yai, nanatu E faꞌankamkamnadi ya lau ee–, hiti fafaihonana yo hiti fafatitina, ");
INSERT INTO bxh_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","na safalumadi sa fanuha wananahaigu yo egu laugagayo sa fafamuli watanidi mate E gadosisiyedi ee–, laulauwewedi hitina 1000 ya famuli. ");
INSERT INTO bxh_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Guyau emi Yaubada hesana tabu au kai wegowegogoꞌen paꞌana hesana tau kai wegowegogoꞌenna ibege Guyau i lau nuwa sahafuwen. ");
INSERT INTO bxh_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Sabati lahaina au nuwanuwatuhui yo au fafaꞌatitiyen. ");
INSERT INTO bxh_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Lahai faligigi esega ai ganahewana, emi paisowa au ginaulidi, ");
INSERT INTO bxh_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","na lahai fafaligigi luwagana mate Guyau emi Yaubada ena Sabati. Lahai te ai ganahewana ibege paisowa hesa au ginauli, um, nanatum em tau lau fayofayo, em yosiyosi yo taꞌowawa em luma yai. ");
INSERT INTO bxh_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Lahai faligigi esega ganahewana yai Guyau galewa, tanoꞌubu, gabogabo yo ginauli mahudoꞌidi ganahewadi yai ya ginaulidi. Na lahai fafaligigi luwagana yai ya anyawasi. Logena Guyau Sabati lahaina ya faloholoho yo ya fatabuwen. ");
INSERT INTO bxh_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Tamam yo tinam u faꞌatitiyedi, haba gonowana tanohi Guyau em Yaubada ya felem, ai lisina wa miya lofalofa. ");
INSERT INTO bxh_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Tabu sai laꞌi u wunui. ");
INSERT INTO bxh_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Taumoho e waihina mai nahinahi tabu mai nahinahi hesa maꞌem au eno bili. ");
INSERT INTO bxh_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Tabu u angafu. ");
INSERT INTO bxh_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Sadaim yai tau miya tabu bwalabwala yai u fagilu gaibui. ");
INSERT INTO bxh_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Sadaim yai tau miya lahuna tabu u gado lelehiyen gaibui. Ena luma, ena tau lau fayofayo tautaumoho e waiwaihin, ena yosiyosi yo ena somo hesa hinaga, tabu u gado lelehiyedi. ");
INSERT INTO bxh_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Palai Tabuna yai Guyau ya yoga lau Mose lebena iyebom, ");
INSERT INTO bxh_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Itete mate antalasam abiꞌabidi lau faꞌatadi. Isalaela dodogadi u falibadi uwe, Sai yosiyosi ya antalasamen Guyau lisina yai mate gonowana bulumakau e sipi e gouti esega ya leyama ena Antalasam. ");
INSERT INTO bxh_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Yena ena antalasam bulumakau, bena tamoꞌana tubutubu loholohona ya leyama Palai Tabuna e Tabanaikeli aba luhuluhu launa yai be habaGuyau ya ita faloholoho. ");
INSERT INTO bxh_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Antalasam tau leyamana bena nimana ya tole lawen antalasam gabugabuna kuluna yai ya famala ena heyaya aba nuwa afulenna be Guyau haba ya ita faloholoho na ena heyaya ya nuwatuhu afuledi. ");
INSERT INTO bxh_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Guyau matana yai bena bulumakau tamoꞌana gubufwauna ya lau funuhi na Elon nanatuna, iti antalasam tau gabugabudi haba yosiyosi ꞌwasinana ni sa abi be aba antalasam sadaidi fati sa lau sibusibuwedi Palai Tabuna aba luhuluhu launa yai. ");
INSERT INTO bxh_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","ꞌWapina ya papa na fisihona ya lau iboꞌiboi. ");
INSERT INTO bxh_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Tau antalasam Elon, nanatuna tatau bena oyagi sa toledi aba antalasam hewana yai na sa yufi. ");
INSERT INTO bxh_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","9","Antalasam tau leyamana bena hoꞌowa ya abi be yosiyosi ganahewana yo ahena ya kaisudi na antalasam tau gabugabudi ya feledi. Piꞌadi, kuluna yo momona haba sa gabu faꞌofidi aba antalasam hewana yai. Ainauya te mate oyagi yai sa gabu na panena ya loholoho wananaha Guyau lisina yai. ");
INSERT INTO bxh_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Guyau ya libalau Mose lisina iyen, Yena bulumakau tinabawa e tamoꞌana sai ya leyama ena nuwa esega anꞌangogona antalasamna lisigu yai mate tabu tubutubu heyayana. ");
INSERT INTO bxh_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Nimana bena ya tole yosiyosi kuluna yai habahim ya lau funuhi Aba Oigogo Palaina Tabuna aba luhuluhu launa yai. Elon nanatuna, iti antalasam tau gabugabudi haba ꞌwasinana sa abi be aba antalasam sadaina fati sa lau sibusibuidi. ");
INSERT INTO bxh_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","4","Yosiyosi momonana ganahewana yai, pouna luwaga ma momonadi mudumuduna sadaina yai, yo atena tefana loholohona bena ya ledima sa gabudi, na ya famala ena ainauya Guyau lisina yai. ");
INSERT INTO bxh_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Elon nanatuna haba yosiyosi atena, pouna yo momona sa tole lawedi oyagi hewana yai be ya famala edi antalasam panena loholohona Guyau lisina yai. ");
INSERT INTO bxh_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Guyau ya libalau Mose yo Elon lisidi, iyen, ");
INSERT INTO bxh_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Yena sai hesa tauna pouna, lepela e balalatina e bonu kamokamoꞌuꞌuna tauna yai, na yena ya nuwatuhui ꞌwapi iwalana heyaheyayana ya abi, mate i lau tau antalasam Elon e natuna hesa lebena. ");
INSERT INTO bxh_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Tau antalasam haba ꞌwapi iwalana ni ya ita komakomaniꞌi, na ibe sadaina yai olo sa kafukafu yo ya bonu sigi lidi mate ni: ꞌwapi asiyebona, be tau antalasam haba ya liba famahata mate hola ma bonuna yo ma bidana. ");
INSERT INTO bxh_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Na ibe ꞌwapina moho ya kafu, hige i bonu sigi lidi. Na bonuna sadaina yai ya leꞌaleꞌa, yo olona hige ti kafu, mate tau antalasam haba dogana ya tole hudoꞌiyen lahai faligigi luwaga. ");
INSERT INTO bxh_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Lahai faligigi luwaga sa ofi, ai mulina tau antalasam haba dogana ni ya ita fuyoi, na ibe bonuna ni hige i fafalaꞌi be tauna i faheyaya haba ya liba mate, dogana iyabona ya miya fuyo lahai faligigi luwaga. ");
INSERT INTO bxh_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Lahai faligigi fafaluwagana yai, tau antalasam dogana ni haba ya ita fuyoi. Na ibe bonuna hige tauna i faheyaya na ya mwafo, haba ya liba famahata mate ya aꞌa yo ya loholoho. Mate tan ya balati moho. Dogana bena in ena kaleko ya kaisudi haba ya aꞌa. ");
INSERT INTO bxh_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Tau antalasam haba dogana tauna ya ita ya aꞌa, na ibe ai muli tauna balatina sa falaꞌidi, bena ya lau tau antalasam ya ita bodai. ");
INSERT INTO bxh_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Tau antalasam bena dogana ya ita fuyoi na ibe balatina ya falaꞌi haba ya liba famahata mate ya asiyebo na ana asiyebona mate ya anfafaꞌawa. ");
INSERT INTO bxh_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Yena sai asiyebo heyayana ꞌwapina yai, bena sa lawen tau antalasam lisina, ");
INSERT INTO bxh_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Be haba ya ita komakomaniꞌi na ibe poꞌuna kafukafuna ꞌwapina yai na olona ya bui be ya kafu yo yena fisihona ya taumahatama, yo bonuna hola ma idaꞌidahena yo ma ꞌwauna, ");
INSERT INTO bxh_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","mate ni, ꞌwapi asiyebona otaꞌota fahina. Tau antalasam haba ya liba famahata mate iwala hesa mwafomwafo gesana. Ibege i tole hudoꞌiyen, paꞌana asiyebona tauna yai haꞌa dodoga sa ita, be ibege ti lau fadidina yai. ");
INSERT INTO bxh_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Kuluna ya lidi, ahena haba tau antalasam ya ita, mahudoꞌina ya fakou, ");
INSERT INTO bxh_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","tau antalasam haba ya ita komakomaniꞌi fuyoi. Na ibe bonuna sa pitali yo tauna mahudoꞌina ya kafu, haba ya liba famahata mate in ya aꞌa yo ya loholoho. ");
INSERT INTO bxh_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Yena sai ꞌwapi iwalana heyaheyayana ya abi, bena kaleko taputapulitidi ya liꞌodi na kuluna tabu i suwali, moꞌana bena ya fakou na yena dodoga sa hanahanau lau lisina haba ya yogalau lisidi iyen, Yau E anꞌiwala. ꞌWapi asiyebona ya abigu. Tabu au laoma sadaigu yai! ");
INSERT INTO bxh_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","ꞌWapi asiyebona otaꞌotana tauna yai mate hola ma asiyebona. Sa tole hudoꞌiyedi be dodoga tau anꞌiwala gesagesadi ibege maꞌedi ti miya gogo. ");
INSERT INTO bxh_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Guyau ya libalau Mose lebena iyen, Isalaela e taꞌowawa sai Isalaela ganahewadi yai ya miyamiya na fisiho ma ꞌwasina ya an, haba E taꞌai mulimuliyen yo E tomo afulen ena dodoga lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Somo ya mwahumwahuli ꞌwasina E felemiu bena emi heyaya maisana ami fagoi antalasam aba gabuna hewana yai. ꞌWasina mate mwahuli pwalana, be lisina yai Guyau ya une fuyoꞌida. ");
INSERT INTO bxh_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Guyau ya libalau Mose lisina iyen, ");
INSERT INTO bxh_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Isalaela dodogadi u falibadi uwe, “Guyau, mate emi Yaubada. ");
INSERT INTO bxh_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Isalaela dodogadi, beyabeyana ma afa haidamiu ami miyamiya Idipi yai na aho E lawemiu Kanana. Tabu emi laulau doha Idipi yo Kanana dodogadi. ");
INSERT INTO bxh_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","“Yau Guyau, emi Yaubada Au ataꞌatahi na egu laugagayo au lau watan komakomanidi. ");
INSERT INTO bxh_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","“Yau Guyau! Egu oibulu yo egu laugagayo au lau watanidi! Sai hige i awa abiyedi, ibege i mwahuli. ");
INSERT INTO bxh_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“Yau Guyau! Tabu sai laꞌi efana hesa maꞌena ti luma gwaꞌu.” Guyau iyen, ");
INSERT INTO bxh_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Yena waihin ena nawalahi asiyebona ya abi, tabu au luma gwaꞌui, paꞌana in ya bida. ");
INSERT INTO bxh_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Falem tau miya lahuna tabu u luma gwaꞌui. Haba ya fabidahem. ");
INSERT INTO bxh_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Yau Guyau emi Yaubada! Tabu natumiu laꞌi au antalasamen Moleka lebena yai. Yena ami ginauli doha haba ami fataumayamayagu. ");
INSERT INTO bxh_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Tabu tatau luwaga ti luma gwaꞌu, doha taumoho maꞌena waihin sa luma gwaꞌu. Laulau ni Yaubada ya ꞌwaiyoꞌo. ");
INSERT INTO bxh_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“Tabu taumoho e waihin laꞌi maꞌena suisui ti luma gwaꞌu be i fabida fuyoi, mate hige i dudulai. ");
INSERT INTO bxh_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Logena, laulaudi te, tabu laꞌi i fabidahemiu, paꞌana laulaudi te debadi yai, Kanana dodogadi safaluma haba E weꞌaidi matamiu yai, haꞌa sa fabidahedi.” ");
INSERT INTO bxh_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Guyau ya libalau Mose lisina iyen, ");
INSERT INTO bxh_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Isalaela dodogadi u faꞌoigogodi na u falibadi uwe, “Bena tabuna miyana ami miyamiyaꞌen paꞌana Yau, Guyau emi Yaubada tabuna.” Lewitikusi 19:17-18 Guyau hinaga iyen, ");
INSERT INTO bxh_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Yena nuwam yai hidam wa ita faheyaya, u lau be maꞌem au tole fadudulai. Yena doha wa ginauli, ibege ena heyaya giluna u bahei. ");
INSERT INTO bxh_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Yau Guyau E liba mate, “Tabu am hala u abi e hidam u mana balaʼen. In moho falem tau miya bena wa gadosisiyen doha wa gadosisi fuyoim.” ");
INSERT INTO bxh_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Yena doga hesa ya lau dodoga peꞌipeꞌidi tau fafalibadi lebedi, bena edi sibasiba ya abi, mate haba E taꞌai mulimuliyen na E tomo afulen ena dodoga lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Guyau ya libalau Mose lisina iyen, Isalaela dodogadi u falibadi uwe, Sai hidana ya talai, haba hinaga in sa talai. ");
INSERT INTO bxh_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Yena siyada ya oi pwai mate hinaga siyadana haba, sa oi pwai. Yena hidana matana ya oi golu haba hinaga matana sa oi golu. Hidana moꞌana inna ya oi losi mate in hinaga haba moꞌana inna sa oi losi. Doga hesa ya faꞌomata haba, in hinaga, sa faꞌomata. ");
INSERT INTO bxh_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Yau, Guyau emi Yaubada! Yena sai yosiyosi ya wunui, bena ya falau damahi. Na sai doga ya wunui, bena in hinaga sa wunui. ");
INSERT INTO bxh_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Laugagayo eseꞌesegana te bena sai nuꞌuna yai sa yosi yo taꞌowawa mate sa lau watan. ");
INSERT INTO bxh_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Guyau ya libalau Mose lebena iyen, ");
INSERT INTO bxh_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Elon ma afa nanatuna tatau u falibadi uwen, “Isalaela em aba faloholohodi mate itete. ‘U falibadi uwen, ");
INSERT INTO bxh_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“Guyau ena loholoho lisimiu yai yo i bobodiyemiu; ");
INSERT INTO bxh_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Nenena i fasina lisimiu yai yo i fanuwatohatohaemiu; ");
INSERT INTO bxh_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","I ita faloholohomiu yo nuwamiu i fadaumwalidi. ");
INSERT INTO bxh_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Ibe yena hesagu sa fapaisowa Isalaela dodogadi ai lisidi, yau haba loholoho E feledi.” ");
INSERT INTO bxh_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Guyau ya libalau Mose lisina iyen, ");
INSERT INTO bxh_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Sulu safuhudohudoꞌi luwaga ganahewadi yai, sulu esega ena tau lau kulukulu u fasinabo be u fatamalidi ti lau Kanana tanohina, logenana haba E felemiu, ti tafo dadai. ");
INSERT INTO bxh_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Mose mate Yaubada ena liba ya lau watan, be suludi hesa - hesa Isalaela ganahewana yai tau lau kulukulu 12 ya fasinabodi. Yo fede, Palan nuꞌuna pitapitalina yai sa aulaha sa lau Kanana. ");
INSERT INTO bxh_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Fuyanna Mose ya fatamalidi sa lau Kanana sa tafo dadai, ya falibadi iyen, Au lidi Negebi Nuʼuna be au lau nuꞌu uduꞌuduhulidi yai. ");
INSERT INTO bxh_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Tanohina au ita, somo - somohena yo dodogadi amaniya sa miyamiya, sa fuluga, e sa belu, sa ouli e higeꞌe. ");
INSERT INTO bxh_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Edi aba miya tanohina somo - somohena? Ya loholoho e ya heyaya? Taon fafaganadi e fafagana gesagesadi yai sa miyamiya? ");
INSERT INTO bxh_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Tanohina somo - somohena? Ya mahula e higeꞌe? Oyagi amainiya e higeꞌe? Au anpate adidili be tanohi ni, fuwafuwana haisa au ledima. Wain uludi adi fuya nanau bwaꞌibwaꞌi, fuyana. ");
INSERT INTO bxh_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Yo fede, Diyin Nuꞌu Pitapitalina yai sa fatubu be Kanana tanohina sa tafo dadai ee–, sa lau Lehobo, Lebo Hamata sadaina yai, Kanana Nuꞌuna duduna tefa saisaina. ");
INSERT INTO bxh_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Sa tafo dada lahai 40 mulina yai sa fuyo ");
INSERT INTO bxh_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Kadesi nuꞌuna, Palan nuꞌuna pitapitalina be edi tafo dada yai somo sa itadi mate, Mose, Elon yo Isalaela mahudoꞌidi edi sa liba, yo fuwafuwadi sa abidi hinaga sa faꞌitadi. ");
INSERT INTO bxh_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Mose edi fafalibana doha ite: Wa duimai be ꞌe lau tanohina ꞌe kepai mate ya mahula wananaha! Ma! Fuwafuwadi itete. ");
INSERT INTO bxh_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","In moho dodoga amainiya sa miyamiya mate, sa adidili wananaha, edi taon sa laꞌi wananaha yo ganana ya lofa wananaha. Anaki dodogadi laulauwewedi hinaga amainiya ꞌe itadi. Kwaludi sa lofa yo tau gigi! ");
INSERT INTO bxh_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amaleki dodogadi Negebi yai sa miya; Hiti, Debusi yo Amoli dodogadi nuꞌu uduꞌuduhulina yai sa miya na Kanana dodogadi gabogabo sadaina yo Diyodan hoꞌowana sa miya watan. Sa laꞌi wananaha. ");
INSERT INTO bxh_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","In moho Kelebi edi liba ya anlau tomotomoꞌi Mose matana yai be sa doꞌo. Iyen, Tanohi ni, gonowada te lau te abi, aiꞌeda. ");
INSERT INTO bxh_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","In moho, tatau maꞌena sa lidi tiyen, Hige gonowada ta fatupadi. Sa fuluga wananaha! ");
INSERT INTO bxh_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Muli yai tau tafo dadaina wasa bwalabwala sa fataꞌiꞌili Isalaela dodogadi ganahewadi yai. Tiyen, Tanohina hige i mahula be haba dodoga mahudoꞌidi amainiya ibege adi kalahe. Dodogadi sa laꞌi wananaha. ");
INSERT INTO bxh_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Anaki wahawahadi ꞌe itadi mate sa laꞌi wananaha. Ai nenemai doha kupati, na iti sa itamai doha kupati hinaga. ");
INSERT INTO bxh_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Iꞌipana dodoga mahudoꞌidi sa tan ꞌwalaꞌwalawui. ");
INSERT INTO bxh_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Sa fatalapili Mose yo Elon lebedi yai tiyen, Nahalidi hige ai Idipi e ai nuꞌu pitapitalina te, ta peꞌi! ");
INSERT INTO bxh_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Sidohana be Guyau ya laweda tanohi te, lisina yai? Haba sa wunuida na lalahuda yo nanatuda, haba sa gelaedi. Ya loholoho moho ibe te fuyo Idipi. ");
INSERT INTO bxh_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Sa fafatiꞌo fuyoꞌidi tiyen, Haga tau lau kulukulu ta fasinabo be ta fuyo Idipi. ");
INSERT INTO bxh_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Yo fede, Isalaela nuwanuwadi yai, Mose yo Elon sa hoba lidi tanohi yai. ");
INSERT INTO bxh_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Habahim Nun natuna, Diyesuwa yo Diyefunehi natuna, Kelebi, tanohi tau tafo dadaina haisa, edi kaleko sa kamgigidi, ");
INSERT INTO bxh_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","na sa libalau Isalaela mahudoꞌidi lebedi tiyen, Tanohina ꞌe tafo dadai mate ya loholoho wananaha. ");
INSERT INTO bxh_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Nuꞌu mahumahula. Na yena Guyau nuwana ya loholoho lebeda yai haba ya foyahida, te lau niya be aiꞌeda ya feleda. ");
INSERT INTO bxh_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Tabu moho Guyau au moꞌa peiyen yo dodoga tanohina yai ni, au ꞌwasabuwedi paꞌana haba te lei hafihafitidi. Hige tau bobodiyedi na ita Guyau maꞌeda be tabu au ꞌwasabuwedi. ");
INSERT INTO bxh_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","In moho Isalaela mahudoꞌidi sa oiliba bena sa lau umeꞌehuidi. Makai ma luwaga, Guyau ya taumahata lau Isalaela mahudoꞌidi lebedi Oigogo Palaina hewana yai, ma namanamalina. ");
INSERT INTO bxh_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Habahim Guyau ya libalau Mose yo Elon lisidi iyen, ");
INSERT INTO bxh_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Dodoga heyaheyayadi te, edi fatala pili lebegu yai haga i lofa. E tausiꞌololo! ");
INSERT INTO bxh_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Be u falibadi uwe, “Guyau ya liba iye, Yau E miya esegahigu! Ginaulidi somo ami libaedi E atahiyedi, haba E ginauli watanidi ai lebemiu. ");
INSERT INTO bxh_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Safalumamiu emi bolima 20 na ya hasai yo hesamiu sensisi bukana yai, mahudoꞌimiu haba ami peꞌi ai nuꞌu pitapitalina te paꞌana ami fatala piliyegu. ");
INSERT INTO bxh_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","“Tanohi E liba fasunumaʼen aiꞌemiu mate ibege sai laꞌi i mahano lau ai lisina. Diyefunehi natuna, Kelebi yo Nun natuna, Diyesuwa moho haba sa mahano lau niya. ");
INSERT INTO bxh_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Nanatumiu ami libaedi auwe, ‘Ama waiyunu haba, nanatumai, sa tohaidi.” In moho higeꞌe! Haba E lawedi be tanohina ami ꞌwaiyoꞌoꞌen, ainiya haba sa miyai. ");
INSERT INTO bxh_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","In moho, umi, ai nuꞌu te haba ami peꞌi. ");
INSERT INTO bxh_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ami lau afulegu doha waihin lahuna ya lau afulen na ya lau taumoho hesa - hesa lebena. Lisina yai nanatumiu haba sipi tau itaꞌita wata ai nuꞌu pitapitalina te, haba sa ankamkamna bolima 40 yo hiti te dogana ofiꞌofina ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Tanohi ami tafo dadai lahai 40 lisina yai bena ami ankamkamna bolima 40, emi heyaya debadi yai. Bolima esega mate lahai esega, enehena. Ami fawaiyunugu, logena, kamkamnana haba ami fahoina. ");
INSERT INTO bxh_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","“E liba dudulai! Ginaulidi te haba E ginauli watanidi dodoga heyaheyayadi te ai lisidi, safalumadi sa nuwa esega be sa taꞌai mulimuliyegu. Haba sa peꞌi ofi ai nuꞌu pitapitalina te. Yau, Guyau haꞌa E liba.” ");
INSERT INTO bxh_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Nawalahi bwaꞌibwaꞌina ganahewana yai, Isalaela dodogadi mahudoꞌidi sa mahano nuꞌu pitapitalina hesa yai hesana Diyin, be Kadesi yai sa miya. Amainiya, Miliyam ya peꞌi be sa boꞌusai. ");
INSERT INTO bxh_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Nuꞌuna yai ni, hige adi hoꞌowa, be sa faꞌoiꞌesega na Mose yo Elon sa fawaiyunuꞌidi. ");
INSERT INTO bxh_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Sa fatalapili tiyen, Fuyanna afa haidamai sa peꞌi, Guyau matana yai, egoba haꞌa ꞌe peꞌi! ");
INSERT INTO bxh_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Sidohana be ai, Guyau ena dodoga, wa foyahimai nuꞌu pitapitalina yai te? Be haba ꞌe peꞌi aiteꞌi maꞌemai yosiyosi? ");
INSERT INTO bxh_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Amainiya hige hoꞌowa, yo hige witi, figi e wain e pomaganata. Sidohana be Idipi yai wa abimai, be wa foyafahimai be wa lawemai nuꞌu heyaheyayana yai te? ");
INSERT INTO bxh_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mose maꞌena Elon dodoga sa lau afuledi, be sa lau Aba Oiꞌoigogo Gwaꞌuna luhuluhu launa yai, sa hoba lidi, na Guyau ena namanamali ya taumahata lebedi yai. ");
INSERT INTO bxh_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Habahim, Guyau ya libalau Mose lisina, iyen, ");
INSERT INTO bxh_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Fuya ouꞌouli tuꞌe wa fafapaisowa mate u abi, na um yo Elon, dodoga au faꞌoigogo esegahidi. Be umeꞌehu laꞌilaꞌi ni u faliba dodoga ai matadi. Haba hoꞌowa ma alu babadana ya didima, be dodoga yo yosiyosi adi sa nom. ");
INSERT INTO bxh_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Yo fede, Mose tuꞌe ya abi, doha haꞌa Guyau ya fatalahaꞌen. ");
INSERT INTO bxh_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Mose maꞌena Elon dodoga sa faꞌoigogo esegahidima umeꞌehu sadaina yai na Mose iyen, Tau kawayagala, au ataꞌatahi! Ai umeꞌehu te bena hoꞌowa ami ꞌe leyama? ");
INSERT INTO bxh_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","In moho, Guyau alinana hige i lau watan be tuꞌe ya lau hitiꞌi, be umeꞌehu yai ya oitagu, ma luwaga, yo fede hoꞌowa ma alu babadana ya didima, be dodoga yo edi yosiyosi sa nom. ");
INSERT INTO bxh_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","In moho, Mose yo Elon Guyau ya liba suꞌuidi iyen, Hige au sunumaꞌegu be Isalaela dodogadi matadi yai hige egu gigibwali tabuna au kawawananahaꞌen. Logena, tanohi haꞌa E liba fasunuma bena enehemiu, ibege um Mose u foyahi lawedi ainiya. ");
INSERT INTO bxh_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Meliba Hoꞌowadi yai te amainiya Isalaela dodogadi sa fatalapili lau Guyau lisina be amainiya Guyau ena fatabu, dodoga ya faꞌitadi. ");
INSERT INTO bxh_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Holai Tuꞌana yai, Idom Nuꞌuna sigasigana sadaina yai, Guyau ya libalau Mose yo Elon lisidi yai iyen, ");
INSERT INTO bxh_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Tanohi haꞌa E liba fasunuma bena enehemiu mate Elon ibege i lau niya. Haba ya peꞌi paꞌana Meliba nuꞌuna yai tataumiu luwaga egu liba ami moꞌa peiyen. ");
INSERT INTO bxh_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Elon ma natuna Eliyesa u foya hasaedi Holai Tuꞌana. ");
INSERT INTO bxh_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Na amainiya, Elon ena antalasam lelidi u unufahidi be Natuna Eliyesa u faluhufi. Ai tuꞌana haba Elon ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Guyau somo ya libaen mate Mose ya ginauli watan. Holai Tuꞌana sa finahe, Isalaela mahudoꞌidi matadi yai. ");
INSERT INTO bxh_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Tuꞌa hewana yai, Elon ena leli Mose ya wunufahidi be Eliyesa ya faluhufi. Amainiya, Elon ya peꞌi na Mose maꞌena Eliyesa sa leta fuyo lidi. ");
INSERT INTO bxh_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Fuyana dodoga mahudoꞌidi, ena peꞌi wasana sa atahiyen mate halana sa tan nawalahi esega. ");
INSERT INTO bxh_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Habahim Isalaela dodogadi Holai Tuꞌana sa lau afulen, na Idom sa gebaen, be Gabogabo Balebalelemna Edaꞌedana sa lau watan. Edaꞌeda yai sa laulau ee–, sa tau siꞌololo. ");
INSERT INTO bxh_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Sa fatalapili Yaubada yo Mose lisidi yai tiyen, Idipi yai ami abimai be haba ai nuꞌu pitapitalina te ꞌe peꞌi! Amaiteꞌi hige kalahe yo hoꞌowa! Kalahe heyaheyayana te hige ai fanuha. ");
INSERT INTO bxh_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Habahim, Guyau weso anꞌanlewadi ya fatamali lawedi ganahewadi yai be dodoga sa annalinidi be boludi sa peꞌi. ");
INSERT INTO bxh_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Habahim dodoga sa laoma Mose lisina na tiyen, Heyaheyaya ꞌe ginauli. ꞌE fatalapili Guyau lisina yai yo um lisim yai. Guyau ai lisina ema u anꞌeta be weso te i abifahidi. Yo fede Mose dodoga enehedi ya lauꞌuꞌula. ");
INSERT INTO bxh_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Guyau Mose ya faliba iyen, Weso, ai kapa u ginauli be ai duhu duduna u oi fapatu lawen be u bono. Na yena sai laꞌi weso ya nali gonowana ya itaꞌita hasa weso kapa yai ni ya ita, haba ya loholoho. ");
INSERT INTO bxh_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Yo fede Yaubada somo ya libaen mate Mose ya lau watan be weso ya ginauli kapa yai. Logena, safalumadi weso sa annalinidi na weso kapa yai ni sa ita, mate sa loholoho. ");
INSERT INTO bxh_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Isalaela sa aulaha boda be Oboto nuꞌuna yai palai sa pei hitinidi. ");
INSERT INTO bxh_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Habahim, Oboto yai sa aulaha boda, be palai sa pei hitinidi nuꞌu pitapitalina yai, Iye-Abalim nuꞌuna yai, Mowabi tefa saisaina yai. ");
INSERT INTO bxh_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Amainiya sa lau Seledi Gonna yai palai sa pei hitinidi. ");
INSERT INTO bxh_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Muliyai, sa aulaha boda sa lau Alanon Hoꞌowana tefana, nuꞌu pitapitalina yai. Amoli dodogadi adi sigasiga sadaina yai palai sa pei hitinidi. ");
INSERT INTO bxh_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Isalaela dodogadi wasa tau lawendi sa fatamali lawedi Amoli edi Kin hesana Sihon lisina, na tiyen, ");
INSERT INTO bxh_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","U laliyemai be em tanohi yai ai bayawa. Ibege ai lau em wain gabudi yai yo em gabu hahaisa yai yo ibege am hoꞌowa ai puludi ai nom. Kin ena Edaꞌeda moho haba ꞌe lau watan ee–, em nuꞌu ꞌe famuli. ");
INSERT INTO bxh_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","In moho, Kin Sihon hige i fanuha bena ena ai tanohi ti lau. Be ena dodoga ya faꞌoi esegahidi na sa lau Dahasa taonna, nuꞌuna pitapitalina yai, Isalaela sa hiyalaidi. ");
INSERT INTO bxh_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","In moho, Isalaela, Kin Sihon maꞌena dodoga mahudoꞌidi sa lei hafihafitidi be boludi sa peꞌi, na ena tanohi sa abi. Alanon Hoꞌowana yai ya lidi ee–, Daboki Hoꞌowana, Amon dodogadi adi sigasiga yai, paꞌana Amon dodogadi edi tanohi sigasigana sa gana buluhi komakomaniꞌi be Isalaela hige gonowana ti lau niya. ");
INSERT INTO bxh_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Amoli edi taon Hesibon yo nuꞌu hahaisa sa miya fataꞌiꞌili mate Isalaela sa abidi be sa gogoidi. ");
INSERT INTO bxh_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Logena Isalaela, Amoli edi tanohi yai sa miya. ");
INSERT INTO bxh_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Mose, tau ita sipo ya fatamalidi sa lau Dasa nuꞌuna mulina yai. Isalaela, Dasa taonna yo nuꞌu hahaisa sadaina yai sa lei hafihafitidi be Amoli dodogadi amainiya sa miyamiya sa lau weꞌaidi. ");
INSERT INTO bxh_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Habahim sa timuli bui, edaꞌeda ya lau Basan sa lau watan na Basan edi Kin, Oga, maꞌena ena tau hiyala mahudoꞌidi sa kalamahano be adi waiyunu sa tulufi lawedi Edelei nuꞌuna yai. ");
INSERT INTO bxh_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Guyau ya libalau Mose lisina iyen, Tabu u ꞌwasabuwen! In yo ena dodoga mahudoꞌidi yo ena tanohi, E tole afuledi lisim yai: Amoli ena Kin, Sihon, Hesibon nuꞌuna ya ita watan na somo haꞌa ami ginauli lisina yai mate, laulauna gonogonowana au ginauli Kin Oga ai lisina hinaga. ");
INSERT INTO bxh_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Yo fede, Isalaela dodogadi, Kin Oga yo nanatuna tatau yo ena nuꞌu dodogadi mahudoꞌidi sa wunuidi. Hige sai laꞌi i mwahumwahuli. Habahim, tanohi wa sa abi, aiꞌedi. ");
INSERT INTO bxh_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Habahim Isalaela sa aulaha sa lau Mowabi Gonna be palai sa pei hitinidi Diyodan Hoꞌowana sadaina yai. Na Diyeliko taonna mate hoꞌowa ni tefana yai. ");
INSERT INTO bxh_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Na, Isalaela somo sa ginauli Amoli lebedi yai mate Dipo natuna Kin Balaki ya ita. ");
INSERT INTO bxh_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Isalaela sa ouli wananaha be Mowabi dodogadi sa ꞌwasabu heyaya! ");
INSERT INTO bxh_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Yo fede Mowabi dodogadi Midiyan babadadi sa falibadi tiyen, Baiwa te, haba ginauli mahudoꞌina sadaida yai sa faheyaya, doha bulumakau hawahawa sa an faꞌofidi. Fuyanna yai Dipo natuna Balaki mate Mowabi edi kin. ");
INSERT INTO bxh_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Wasa tau lawendi ya fatamali lawedi Beyo natuna Balam lisina. Sa lau ee–, sa mahano Ifeleti Hoꞌowana sadaina yai ena nuꞌu wananahana Peto yai. Sa faliba tiyen, Sulu hesa Idipi yai ya laoma. Ya tadada heyaheyaya be nuꞌu sadaigu yai sa miya fafamohafu. ");
INSERT INTO bxh_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Aho te, u laoma be dodoga te u kaumananaedi paꞌana sa adidili wananaha. Yena doha ite wa ginauli, nuwana yau gonowana haba E lei hafihafitidi, be E weꞌaidi. Logena, E siba mate safalumadi wa liba faloholohodi mate, wananaha haba loholoho sa lobahi na safalumadi wa kaumananaedi mate haba heyaya sa fahoina. ");
INSERT INTO bxh_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Habahim Mowabi yo Midiyan babadadi mate Balam ena kaumanana maisa sa abi be sa lawen lisina. Fuyanna sa mahano, somo Balaki ya falibadi, mate sa faliba. ");
INSERT INTO bxh_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balam ya falibadi iyen, Iꞌipa te aiteꞌi au eno. Na bobon Guyau ena bui somo ya felegu, haba E falibamiu. Be, Mowabi babadadi maꞌedi Balam sa miya. ");
INSERT INTO bxh_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Yaubada ya laoma Balam lisina be ya fatiꞌoi iyen, Tatau lisim yai te, safaluma? ");
INSERT INTO bxh_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balam, Yaubada alinana ya bui iyen, Dipo natuna Balaki. In mate Mowabi edi Kin na wasa te ya fatamaliyama: ");
INSERT INTO bxh_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Sulu hesa Idipi yai ya laoma, mate sa tadada heyaheyaya, be nuꞌu sa lau fafamohafu. Aho u laoma be dodoga te lisigu yai u kaumananaedi. Kaumanana ni lisina yai nuwana haba E lei hafihafitidi be E weꞌaidi. ");
INSERT INTO bxh_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","In moho Yaubada ya libalau Balam lisina iyen, Tabu ma afa haidam au lau! Tabu Isalaela dodogadi u kaumananaedi paꞌana egu loholoho haꞌa E feledi. ");
INSERT INTO bxh_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Hwalahwalalana, Balam ya obiyo. Babada, Balaki ya duidima wa ya falibadi iyen, Au fuyo emi nuꞌu paꞌana Guyau ya laugagayoꞌegu be ibege yau maꞌemiu ta lau. ");
INSERT INTO bxh_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Na Mowabi babadadi sa fuyo Balaki lisina be tiyen, Balam ya waiyoꞌo wananaha, be hige maꞌemai ai laoma. ");
INSERT INTO bxh_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Yo fede hwalahwalala Balam ya obiyo be ena aba taꞌai donki taulina yai ya abi nonohai. Habahim maꞌena Mowabi babadadi sa lau Balaki lebena. ");
INSERT INTO bxh_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Fuyanna ya lau mate Yaubada ya manabala heyaheyaya be ena aba lau Guyau ena anelu ya obiyo bulubuluhi. Balam ena donki yai ya awa na sa laulau maꞌena ena tau paisowa luwaga. ");
INSERT INTO bxh_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Na donki ya itaꞌita lau be Guyau ena anelu ya ita ma baibainetina ya obiꞌobiyo edaꞌeda yai, be donki ya timuli bui be ya lau gabu ganahewana. Yo fede, Balam ya talai be bena ya fafuyoyama edaꞌeda. ");
INSERT INTO bxh_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Habahim Guyau ena anelu ya sigilau wain gabudi luwaga umeꞌehu yai sa katandi atiꞌatipudi yai, somo yai edaꞌeda ena aba mwakoko yai be ya obiyo. ");
INSERT INTO bxh_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Fuyanna donki Guyau ena anelu ya ita mate ya sigilau gana sadaina yai be Balam ahe laulauna ya eli hafiti gana yai be Balam, donki ya tala bodai. ");
INSERT INTO bxh_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Habahim anelu begana ya sigilau be somo yai solasola ya mwatiti heyaya, amainiya ya obiyo fuyo. Hige gonowana bena i timuli bui ai sibana e ai seulina. ");
INSERT INTO bxh_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Fuyana donki anelu ya ita mate ya hoba tanohi yai na Balam mate hewana yai. Yo fede manana ya bala be ena tuꞌe yai ya talai. ");
INSERT INTO bxh_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Habahim Guyau ena gigibwali yai donki ya libalau Balam lisina iyen, Somo E ginauli lebem yai be ma faihona wa talaigu? ");
INSERT INTO bxh_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balam donki ena bui ya felen iyen, Em abiꞌabigu doha yau yauyaule! Ibe baineti nimagu yai aho te E wunuim. ");
INSERT INTO bxh_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Donki wa Balam ya faliba iyen, Yau em donki! Fuya ouꞌouli wa awaꞌawaigu ee–, aho ite. Hige doha ite egu abiꞌabim beyabeyana! Balam iyen, Iꞌi–, Higeꞌe! ");
INSERT INTO bxh_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Habahim Guyau Balam matana ya falaladi be anelu ya ita ya obiꞌobiyo ma baibainetina edaꞌeda yai, yo fede, makai, ma luwaga! Na ya hoba lidi tanohi yai. ");
INSERT INTO bxh_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Na Guyau ena anelu Balam ya faliba iyen, Sidohana be em donki wa talai ma faihona? Am lali wa lawelawen te E ita faheyaya be E laoma bena em edaꞌeda E naha buluhi. ");
INSERT INTO bxh_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Donki ya itagu be ya gebaegu ma faihona. Ibe higeꞌe, nuwana aho te haꞌa ya wunuim na donki moho haba E biya afulen. ");
INSERT INTO bxh_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Alinana Balam ya bui iyen, Heyaya E ginauli! Hige ya siba mate, um edaꞌeda yai wa naha buluhigu. Yena nuwam hige i loholoho haba E fuyo. ");
INSERT INTO bxh_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Anelu, Balam ya faliba iyen, Dodoga te ma afa haidam au lau. In moho somo E libaen lisim yai moho bena wa libaen. Habahim Balam ma afa haidana sa lau. ");
INSERT INTO bxh_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Habahim Balam wasa te ya libaen: Dipo natuna Balaki u obiyo! Be somo haba E libaen, u atahi. ");
INSERT INTO bxh_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Yaubada hige i laulau bwalabwala doha ita dodoga; Yaubada hige nuwana i buibuiꞌi doha ita. Somo ya liba fasunuma mate ya ginauli watan. Ya liba moho na ginauli sa tubu. ");
INSERT INTO bxh_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Yaubada ya falibagu bena Isalaela E liba faloholohodi. Yena Guyau haꞌa ya liba faloholohodi, Yau hige gonowana ya bui be ya liba faheyayadi. ");
INSERT INTO bxh_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Fuya matada yai Iyakobo laulauwewena, Isalaela, ibege heyaheyaya e pilipili ti fahoinadi. Guyau edi Yaubada mate, maꞌedi. Na sa yoga famahata mate, In edi Kin. ");
INSERT INTO bxh_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Yaubada, Idipi yai ya auledima. Be ena adidili doha bulumakau tamoꞌana yekoyekona. ");
INSERT INTO bxh_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Isalaela ibege ti kaumananaedi yo ibege ayahan ti gwalidi yo kalawan ti kalawanidi. Aho te dodoga haba tiyen, Yaubada somo ya ginauli, Isalaela enehedi, hola au ita! ");
INSERT INTO bxh_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Isalaela doha laiyon manamanabalana. Hige gonowana i anyawasi ee–, ana ban ya an, yo ꞌwasinana ya nom. ");
INSERT INTO bxh_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Kin hesa haba ya laoma, hige ya ita, yo hige sadaigu yai. Kipwala haba Isalaela Nuꞌuna yai ya kepama, Kin ma tuꞌetuꞌena haba ai Isalaela ya obiyoma. In haba Mowabi dodogadi yo Seti dodogadi kulukuludi ya futu gisigisidi. ");
INSERT INTO bxh_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Ana waiyunu, Idom haba ya lei hafihafitidi. Yo Seya adi waiyunu haba ya lei hafihafitidi hinaga. Be edi tanohi ya abidi, na Isalaela dodogadi haba sa adidili wananaha. ");
INSERT INTO bxh_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Iyakobo ena ai sulu haba tanuwaga hesa ya ita wata. Be tau mwahuli sa miyamiya taondi yai, ya faheyayadi. ");
INSERT INTO bxh_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Fuyanna Isalaela dodogadi, Akasiya nuꞌuna yai sa miyamiya tatau maꞌedi Mowabi wawahindi bena sa eno bili. ");
INSERT INTO bxh_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Wawahin te Isalaela tataudi sa yogaidi be antalasam sa lau ginauli edi yaubada bwalabwaladi lisidi yai be ma afa haidadi sa kalahe, na edi yaubada bwalabwala sa fadebasaedi. ");
INSERT INTO bxh_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Yo fede, Isalaela sa falau esegahi lawedi Mowabi dodogadi lisidi yai be edi yaubada bwalabwalana hesana Baꞌala-Peo sa fadebasae. Be Guyau ya manabala wananaha lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Habahim Guyau, Mose ya faliba iyen, Dodoga tau foyafoyahidi kawakawa yagaladi u abidima u wunuidi be mahata tautau yai u toledi ai matagu, haba Yau egu manabala Isalaela lebedi yai E nuwatuhu afuledi. ");
INSERT INTO bxh_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Mose Isalaela edi tau lau fakasa ya falibadi, iyen, Umi hesa - hesa emi tatau safalumadi sa falau esegahidi Baꞌala-Peo lisina yai mate au wunuidi. ");
INSERT INTO bxh_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Lahaina yai Mose yo dodoga mahudoꞌidi Aba Fadebasaena Gwaꞌuna luhuluhu launa yai sa tantan. Yo fede Isalaela taumohona hesa, Midiyan waihinna ya foyahi leyama ana boga edi gwaꞌu yai sa ita. ");
INSERT INTO bxh_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Fuyana tau antalasam Elon natuna Eliyesa natuna Finiyasi mate laulau te ya ita be oigogo ya lau afulen, na ya lau alahiya ya abi. ");
INSERT INTO bxh_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Habahim taumohona ya lau watan ya lau ena gwaꞌu ganahewana yai, be ya difa dagi, be waihin ya gwali esegahi. Yo fede, iwala heyaheyayana Isalaela lisidi yai wa, ya fatautau. ");
INSERT INTO bxh_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","In moho dodoga ouꞌoulidi 24,000 haꞌa sa peꞌi. ");
INSERT INTO bxh_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Na Guyau, Mose ya faliba iyen, ");
INSERT INTO bxh_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Ibege ya manabala fuyo! Finiyasi laulau somo ya ginauli mate yau haꞌa egu nuwanuwatuhu doha. In ibege i ita afuledi be yaubada hahaisa ti fafadebasaedi; Yau moho emi Yaubada haba ami fadebasaegu. Logena, egu manabala in ya fatuwa funuhi, be Isalaela hige ya faheyayadi. ");
INSERT INTO bxh_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Finiyasi u faliba mate in lisina yai egu miya daumwali yalina E ginauli. ");
INSERT INTO bxh_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Haba yau yo Finiyasi yali ꞌe ginauli be laulauwewena haba antalasam paisowana sa ginauli lau ee–, hige anadan paꞌana hige i ita afuledi, be yaubada hahaisa ti famuli watandi. Ena fanuha bena yau moho edi Yaubada be ena laulau ni debana yai haba dodoga edi heyaya E nuwa afuledi. ");
INSERT INTO bxh_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Habahim Guyau Mose ya faliba iyen, Yaluwagu mate Nun natuna Diyesuwa lisina yai. U leyama be nimam u tole hasaen ai boluboluna. ");
INSERT INTO bxh_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Diyesuwa u lawen be i obiyo tau antalasam, Eliyesa yo dodoga mahudoꞌidi ai matadi, na u liba famahata mate haba ya falau damahim be dodoga ya foyahidi. ");
INSERT INTO bxh_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Em gigibwali Diyesuwa u felen, be haba Isalaela dodogadi ena liba sa lau watan. ");
INSERT INTO bxh_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Diyesuwa haba tau antalasam, Eliyesa ai matana ya obiyo, na yena Guyau ena nuwatuhu hige i mahata, haba, Ulim ya fapaisowa be Guyau ena nuwatuhu ya yoꞌoi. Ibe Yaubada iyen, au lau, mate Isalaela dodogadi mahudoꞌidi maꞌedi Diyesuwa haba sa lau sa hiyala. Na ibe iye, au fuyo, mate haba sa fuyo. ");
INSERT INTO bxh_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Yo fede Guyau somo Mose ya faliba mate Mose ya ginauli watan. Diyesuwa ya leyama be ya faꞌobiyo tau antalasam Eliyesa yo Isalaela dodogadi mahudoꞌidi matadi yai. ");
INSERT INTO bxh_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Mose, Diyesuwa ya fasinabo bena falau fadamahina; nimana ya tole lawedi hewana yai, be haba in dodoga tau foyahidi, doha haꞌa Guyau, Mose ya faliba. ");
INSERT INTO bxh_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Mowabi Gonna yai Diyodan Hoꞌowana sadaina yai na Diyeliko mate tefa yai, amainiya Guyau, Mose ya faliba iyen, ");
INSERT INTO bxh_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Isalaela dodogadi u fatalahadi doha ite: Yena Diyodan ami gayo dohe ami lau Kanana Nuꞌuna, ");
INSERT INTO bxh_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","dodoga amainiya sa miyamiya bena ami falakodi. Edi oitau umeꞌehu yai yo powati yai sa ginaulidi, yo edi aba fafadebasae mahudoꞌidi au lau kwayaidi. ");
INSERT INTO bxh_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Edi nuꞌu haꞌa E felemiu, au abi be ainiya au gogo. ");
INSERT INTO bxh_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Pelei yai, tanohi au daili, sulu hesa - hesa laꞌina yai. Boga laꞌilaꞌi edi tefa laꞌilaꞌi na boga kiukiu edi tefa kiukiu. ");
INSERT INTO bxh_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Yena dodoga nuꞌu yai ni sa miyamiya hige au weꞌadi, safalumadi ami famiyadi haba sa famala doha muꞌali matamiu ganahewadi yai e nulinulidi lisilisimiu yai. Iti haba sa fapilipilimiu ai tanohina ni. ");
INSERT INTO bxh_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Yena hige au weꞌaidi, haba somo haꞌa E nuwatuhui bena E ginauli ai lisidi, haba E ginauli ai lisimiu. ");
INSERT INTO bxh_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Habahim Guyau Mose ya faliba, iyen, ");
INSERT INTO bxh_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","Bena Isalaela wa falibadi uwen, “Fuyana Diyodan Hoꞌowana ami gayo dohe, be ami lau Kanana nuꞌuna, ");
INSERT INTO bxh_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","Aba Gela Taondi haisa au abi nonohaidi be yena sai laꞌi doga hesa ya tala gaibui be ya peꞌi mate, i gela i lau ainiya i alasimo. ");
INSERT INTO bxh_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Aba Gela Taondi ni haba ya famala ena aba alasimo, be doga peꞌipeꞌina ni, ana boga tabu ana gum ti abi. Tau aiyunu haba gonowana ya miya ee–, lau fatala fuyana. ");
INSERT INTO bxh_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Aba Gela Taondi ni haba ya famala ena aba alasimo, be doga peꞌipeꞌina, ni, ana boga tabu ana gum ti abi. Tau aiyunu haba gonowana ya miya ee–, lau fatala fuyana.” ");
INSERT INTO bxh_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Habahim Mose Isalaela dodogadi ya falibadi, iyen, Au ataꞌatahi komakoman! Laugagayo mahudoꞌidi E fatalahamiu, bena ami lau watanidi haba ami miya lofalofa yo ami lau somo yai tanohi Guyau afa wahamiu edi Yaubada ya feledi, aiꞌedi, ami abi, enehemiu. ");
INSERT INTO bxh_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Laugagayo, yau haꞌa E felemiu, tabu hagahagana au tole lawen, o laꞌi au kam fahi. Guyau ena Laugagayo E felemiu moho, au lau watanidi. ");
INSERT INTO bxh_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Laugagayo te au lau watan komakomanidi, be haba nuꞌu hahaisa dodogadi, emi nuwatuhu loholohona yo emi sibasiba sa ita lobahidi. Yena laugagayodi sa atahiyedi, haba tiyen, “Moꞌisa, Isalaela mate nuꞌu laꞌilaꞌi yo dodogadi sa sibasiba yo edi nuwatuhu sa loholoho.” ");
INSERT INTO bxh_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Hige nuꞌu hesa laꞌilaꞌi ena yaubada sadaidi doha ita. In moho, Guyau eda Yaubada mate sadaida yai, na yena te anꞌetai haba ya saguhida. ");
INSERT INTO bxh_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Laugagayodi, aho te, E felemiu mate, sa dudulai yo sa loholoho. Hige nuꞌu hesa laꞌina doha somo, ena laugagayo doha ite. Diutelonomi 4:32-34, 39-40 Mose ya liba hinaga iyen, ");
INSERT INTO bxh_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","34","Guyau emi Yaubada hige doha yaubada hahaisa. Idipi yai ena adidili yai ya foyahimiu, be ya lau itamiu. Noꞌo ginaulidi yo fafaꞌilala ya lau ginauli matamiu yai. Debamiu yai, Idipi ya hiyalaidi be kamkamna laꞌilaꞌi sa fahoina. Ya abimiu, be ami famala ena dodoga, be fuyana Sainai Tuꞌana yai oyagi ya ala balebalelem ganahewana yai ya falibamiu. Haꞌa ami atahi, na hige au peꞌi! Ginauli doha ite, beyabeyana ya tubu, e higeꞌe? Higeꞌe! Fuyana Guyau ena fuya bwaꞌibwaꞌina dodoga ya ginaulidi tanoꞌubu yai, haga au nuwatuhui. Tanoꞌubu mahudoꞌina au yoꞌoi! Hige yaubada hesa, ginaulidi doha ite i ginaulidi. ");
INSERT INTO bxh_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Aho te, bena wa nuwatuhui mate, Guyau in Yaubada galewa hewa wananahana yai yo tanoꞌubu yai. Hige Yaubada hesa. ");
INSERT INTO bxh_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Ena laugagayo E felemiu, aho te, bena ami lau watanidi, be haba umi yo laulauwewemiu ami miya loholoho yo emi miya ya lofa, nuꞌu, Guyau emi Yaubada ya felemiu ai lisina ee–, hige anadan. ");
INSERT INTO bxh_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Isalaela, au ataꞌatahi! Guyau eda Yaubada, in iyabona mate Guyau! ");
INSERT INTO bxh_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Ma nuwamiu, yo yaluwamiu ma ofi fahidi, yo ma adidilimiu. Guyau emi Yaubada au gadosisiyen. ");
INSERT INTO bxh_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Laugagayodi, E fafalibamiu, aho te, bena ami nuwatuhu didinidi. ");
INSERT INTO bxh_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Nanatumiu bena ami fatalahadi: Yena emi ai luma, ami taꞌataꞌai, yo edaꞌeda yai ami laulau, e ami laulau eno, yo yena ami eno obiyo, bena fuya ouꞌouli, ami fafanuwa hitinidi. ");
INSERT INTO bxh_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Mose ya libalau lisidi hinaga, iyen, Fuyana tanohi bena ami abi, Guyau emi Yaubada ya lawemiu niya, haba nuꞌudi faligigi-luwaga dodogadi ya lawe hudoꞌiyedi ai nuwanuwamiu. Hesadi mate: Hiti, Giligasi, Amoli, Kanana, Pelisi, Hiwi, yo Diyebusi. Iti sa ouli yo sa adidili wananaha, habahim umi. ");
INSERT INTO bxh_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Fuyana ya biya afuledi nimamiu yai, be ami lei hafihafitidi mate, bena ami wunu faꞌofidi; tabu au nuwatohatohaedi, yo tabu maidamiu yali au ginauli. ");
INSERT INTO bxh_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Umi tabu ainiya au nahi, yo nanatumiu tabu au oi libaedi be ti faidi ");
INSERT INTO bxh_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","paꞌana nanatumiu haba sa foya ponolidi be, yaubada hahaisa sa fadebasaedi. Na Guyau haba ya manabalaimiu, be haba feula ya faheyaya ofimiu. ");
INSERT INTO bxh_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Doha ite haba ami ginauli ai lisidi: Antalasam edi aba gabudi katakatandi ami lubi lopalopadi, edi umeꞌehu fafatabudi sa faꞌobiyodi, ami andem pidipidinidi habahim ami andem gisigisidi. Edi yaubada waiwaihin, Asela, fafaꞌilalana duhudi, au oi fagulidi, yo edi oitau taditadidi au angabuꞌidi. ");
INSERT INTO bxh_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Paꞌana Guyau emi Yaubada haꞌa ya fatabumiu, bena in, enehena. Dodoga mahudoꞌidi tanoꞌubu yai te, umi iyabomiu moho ya fasinabomiu, be ena dodoga. ");
INSERT INTO bxh_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Tanoꞌubu yai te, umi hige au ouli. In moho, Guyau ya gadosisiꞌemiu yo ya fasinabomiu. ");
INSERT INTO bxh_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Ya gadosisiꞌemiu yo ya fanuha bena somo haꞌa ya liba fasunuma afa wahamiu lebedi yai, ya fawananaha. Sa lau fayofayoꞌemiu Idipi edi kin lisina yai. In moho, Guyau ena gigibwali yai ya abi fafuyomiu. ");
INSERT INTO bxh_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Bena ami siba wananaha mate, Guyau emi Yaubada, in iyabona Yaubada. Fuya ouꞌouli ena angwala wahawahadi lisidi yai haba ya fafawananahadi, yo ya gadosisiyemiu be nimana didigana yai, lau fayofayo yai ya abifahimiu Kin Falo ena gigibwali yai. ");
INSERT INTO bxh_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","In moho salumadi sa ꞌwaiꞌwaiyoꞌoꞌen, ibege i nuwa sahafuwedi, na haba ya faheyayadi. ");
INSERT INTO bxh_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Logena, aho te, somo ꞌe fatalahamiu, laugagayodi, ami famuli watanidi. ");
INSERT INTO bxh_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Au nuwatuhui sidohana Guyau emi Yaubada eda lofalofa yai ena foyafoyahimiu nuꞌu pitapitalina yai, bolima 40 mulidi yai. Ya nuwa lidilidiyemiu yo ya lau itamiu, be haba emi nuwanuwatuhu ya sibaidi. Ena laugagayo haba ami lau watanidi, e higeꞌe? ");
INSERT INTO bxh_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Ya faꞌanguliyammiu be haba ami nuwa lidilidi. Habahim, mena yai ya fakalahemiu. Mena te, beyabeyana ma afa wahamiu hige au sibai, be hige au anꞌanniꞌi. Doha ite ya ginauli, paꞌana bena ya fatalahamiu, mate dodoga ibege anꞌan ai lisina ibona ti mwahumwahuli, na Guyau ena liba moho, ai lisina haba sa mwahuli. ");
INSERT INTO bxh_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Au itaꞌita komakoman! Tabu Guyau emi Yaubada au nuwa afulen, na tabu ena laugagayo somo E falibamiu lahai ite, au nuwa afuledi. ");
INSERT INTO bxh_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Yena ami andan be bogamiu sa yahayaha, yo luma loholohodi ami lau ginauli be ami gogoidi. ");
INSERT INTO bxh_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","Yo yena emi bulumakau, gouti, sipi, emi siluba yo gole sa ouli wananaha, yo ginauli mahudoꞌina lisimiu yai, sa ouli heyaya, ");
INSERT INTO bxh_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","au itaꞌita komakoman! Nuwa saesae ibe i tanuwagaimiu, be Guyau emi Yaubada au nuwa afulen. In logena, Idipi nuꞌuna yai ya foyahimiu, yo lau fayofayo yai, ya fofofahimiu. ");
INSERT INTO bxh_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Tabu au nuwa afulen! Ya foya lawemiu nuꞌu laꞌilaꞌina pitapitalina fatau ꞌwasaꞌwasabuna yai. Amainiya mate weso anꞌanlewadi yo kalanadenade. Nuꞌuna ya fagado magu, hige hoꞌowa! In moho, Guyau umeꞌehu yai hoꞌowa ya fadidiyama. ");
INSERT INTO bxh_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Ya fakalahemiu mena yai, nuꞌu pitapitalina yai. Mena te beyabeyana afa wahamiu hige ti anꞌanniꞌi. Guyau doha ite ya ginauli lisimiu yai; ya nuwa lidilidiyemiu yo bena ya lau itamiu, be ai ofiꞌofina haba loholoho ya leyawa lisimiu. ");
INSERT INTO bxh_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Haba auwen, “Egu gigibwali yo egu adidili yai, egu gogo E fatubudi.” ");
INSERT INTO bxh_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","In moho, Guyau emi Yaubada au nuwatuhui paꞌana In, logena, ya faꞌadidilimiu be emi gogo ami fatubudi. Yo fede, ena yali ya fawananaha lisimiu yai, doha haꞌa ya fawananaha afa wahamiu lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Egu liba te ai nuwamiu au nuwanuwatuhudi. Yo ai nimamiu yo debamiu au audi, ya famala fafaꞌilala. ");
INSERT INTO bxh_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Nanatumiu bena ami fatalahadi: Emi ai luma, ami taꞌataꞌai, yo edaꞌeda yai ami laulau, e emi aba eno yai, yo yena ami eno obiyo, mate bena mahudoꞌidi ami fafanuwa hitinidi. ");
INSERT INTO bxh_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","Au ita! Aho te, nuwatuhu luwaga E felemiu: Loholoho e kaumanana au abi. ");
INSERT INTO bxh_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Aho te, Guyau emi Yaubada ena laugagayo E felemiu. Yena ami lau watan, haba ena loholoho ya felemiu. ");
INSERT INTO bxh_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","Yena hige au lau watan, na ami timuli bui be yaubada hahaisa beyabeyana hige au fadebasaedi, na aho ite ami fadebasaedi haba ya kaumananaemiu. ");
INSERT INTO bxh_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","Laugagayodi te, E felemiu, bena ami lau watan komakomanidi. ");
INSERT INTO bxh_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","Hola hige aba anyawasi nuꞌuna yai au mahano yo emi ginauli Guyau emi Yaubada ya felemiu hige au mahano lobahidi, ");
INSERT INTO bxh_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","In moho, Diyodan Hoꞌowana haba ami gayo dohe be tanohi Guyau emi Yaubada ya felemiu, ainiya haba ami miya daumwali ai tanohina. Guyau haba ya bobodiyemiu ami waiyunu ganahewadi yai. ");
INSERT INTO bxh_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","Yena ami luhulau tanohi Guyau emi Yaubada ya felemiu bena aiꞌemiu ami abi, yo ami gogoi, haba auwen, “Nuꞌu hahaisa sadaida yai mate edi kin. Eda ta faꞌobiyo. Haba ita doha iti.” ");
INSERT INTO bxh_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","Na, kin sai Guyau emi Yaubada ya fasinabo ami faꞌobiyo in bena hidamiu hesa ai ganahewamiu. Tabu taꞌowawa hesa in hige Isalaela dogana au fasinabo. ");
INSERT INTO bxh_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","Kin te ibege hosi boludi aiꞌena i abidi e dodoga i fatamali fuyoꞌidi Idipi be hosi hahaisa ti abidi, paꞌana Guyau emi Yaubada haꞌa ya falibamiu iyen, Tabu au fuyo niya. ");
INSERT INTO bxh_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","Tabu lalahuna ti ouli. Doꞌata ginauli te ya foya ponoli be Guyau ya lau afulen. Yo tabu siluba yo gole boludi i abidi. ");
INSERT INTO bxh_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","Ibe ya kin, bena laugagayo bukana te, sulu Lewi tau antalasam lebedi yai ya leyama be, enehena, ya uli faꞌawa. ");
INSERT INTO bxh_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","Laugagayo te bena ai sadaina yo bena ya fatifatilidi fuya ouꞌouli haba ya anpate be Guyau ena Yaubada ya faꞌatitiyen yo ena laugagayo ya lau watan komakomanidi. ");
INSERT INTO bxh_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","Buka fatili yai haba ya nuwa lidilidi be afa haidana ibege i ita fakiudi yo ibege i timuli bui, be laugagayo i lau afulen, na i leu e i sae. Habahim in yo laulauwewena haba edi nuꞌu sa tanuwagai ee–, hitina yo hitina. ");
INSERT INTO bxh_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","11","Yena ami lau tanohi Guyau emi Yaubada ya felemiu ai lisina, tabu nuꞌudi ni edi laulau heyaheyayadi au laulauwedi: Tabu sai laꞌi, natuna i antalasamen ai oyagi alaꞌalana, Tabu sai laꞌi, nesu itaꞌita i fapaisowadi be doga i fagilu yo i fakasa. Tabu sai laꞌi fafaꞌilala i fapaisowadi be somo haba ya tubu ai fuya matada ena aba siba. Tabu sai laꞌi i ayahan e i kalawan. Tabu sai laꞌi i abi ginauli, Yo tabu sai laꞌi i lau dodoga peꞌipeꞌi lebedi, be i fatiꞌo lau onaꞌahanadi lisidi. ");
INSERT INTO bxh_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","Sai yena laulau te ya ginaulidi mate, sa heyaya wananaha Guyau emi Yaubada lisina yai, be laulau te, debadi yai haba Guyau emi Yaubada nuꞌu ni dodogadi, ai nuwanuwamiu ya fageladi. ");
INSERT INTO bxh_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","Tabu Yaubada somo hesa ai lisina i fagilumiu. ");
INSERT INTO bxh_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Dodogadi ni, sa ataꞌatahi lau, ayahan lebedi, yo fafaꞌilala sa fapaisowadi be doga sa fagilu yo sa fakasa. In moho, edi tanohi begana haba ami abi. Na Guyau emi Yaubada ya laugagayoꞌemiu, be tabu bena edi laulau te, au laulauwedi. ");
INSERT INTO bxh_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Guyau emi Yaubada haba peloweta hesa doha yau, ai ganahewamiu ya faꞌobiyo; na bena ami ataꞌatahi lau lebena. ");
INSERT INTO bxh_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","Fuyana ami faꞌoigogo Holebi yai, Guyau emi Yaubada ami anꞌanꞌetai doha ite, auwen, Tabu Guyau ema Yaubada alinana ai atahi e oyagi ala balebalelemna ai ita fuyo. Doꞌata ꞌe peꞌi! ");
INSERT INTO bxh_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Guyau, ya falibagu, iyen, Somo sa libaen mate ya loholoho. ");
INSERT INTO bxh_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Peloweta hesa haba E faꞌobiyo doha um, hidamiu hesa, ai ganahewamiu; ginauli mahudoꞌina E faliba haba ai moꞌana ya falibamiu. ");
INSERT INTO bxh_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Guyau iyen, In, haba ai hesagu, ya libaliba na yena sai hige i lau watan, haba E panisi. ");
INSERT INTO bxh_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","Yena peloweta hesa, in iyabona, hesagu yai ya libaliba, na Yau hige ya faliba, bena sa wunui, yo peloweta hesa yaubada hahaisa ai hesadi ya libaliba, mate hinaga bena sa wunui. ");
INSERT INTO bxh_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","Nuwana, ami nuwanuwatuhu, auwen, Sidohana haba ꞌe siba mate, wasa te hige Guyau lisina yai i laoma? ");
INSERT INTO bxh_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","Yena peloweta Guyau ai hesana somo ya libaen, na hige i tubu mate wasa ni, hige Guyau lisina yai i laoma. Peloweta ni, iyabona ena nuwatuhu yai ya libaliba; tabu au ꞌwasabuwen. ");
INSERT INTO bxh_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","Habahim Mose ya libalau be Diyesuwa ya laoma Isalaela dodogadi matadi yai, na ya faliba iyen, Tabu u ꞌwasabu. Bena wa adidili, paꞌana dodoga te, haba ma afa haidam ami lau tanohi Guyau haꞌa ya libaen bena afa wahamiu, enehedi, lebena be ganahewadi yai tanohi bena wa daili hesa - hesa ena tefa wa duwai, aiꞌena. ");
INSERT INTO bxh_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","Guyau ya bwaꞌiyem, yo haba maꞌem. In ibege i lau afulem. Tabu u ꞌwasabu yo nuwam i belubelu. ");
INSERT INTO bxh_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","Habahim Mowabi gonna yai, Mose Nebo Tuꞌana ya finahe hasa, tupina hesana Pisiga hewana yai, na Diyeliko mate, tefa yai. Amainiya, Guyau tanohi mahudoꞌina ya faꞌita, Giliyada ya lau ee–, Dan, ");
INSERT INTO bxh_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","yo Nafatali mahudoꞌina, Efalaim, yo Manase Nuꞌudi ya lau Diuda tanohina ya lau ee–, Gabogabo tefa leuleuna yai ya faꞌita. ");
INSERT INTO bxh_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","Negebi yo Diyeliko gonna, na Diyeliko hesana hesa mate Palam Taonna ya lau ee–, Sowa hinaga ya faꞌita. ");
INSERT INTO bxh_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","Habahim Guyau, Mose ya faliba iyen, Tanohina, logena ite, fuyana E angwalaꞌen be Abelaham, Isako yo Iyakobo E falibadi yawa, “Haba laulauwewemiu E feledi.” Tanohina wa, ite E faꞌitam. In moho ibege u lau niya. ");
INSERT INTO bxh_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Na Guyau ena tau paisowa Mose, Mowabi Nuꞌuna yai ya peꞌi, doha haꞌa Guyau ya libaen. ");
INSERT INTO bxh_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","Guyau Mowabi yai, Mose ya boꞌusai na Beti Peo nuꞌuna, tefa yai. In moho somo yai ya boꞌusai hige sai laꞌi i sibai ee–, aho ite. ");
INSERT INTO bxh_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","Mose ena bolima handele-twenti, ma adidilina yo matana hige ti gafu na ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","Isalaela dodogadi Mowabi gonna yai sa tantan yo sa logo ee–, lahai 30. ");
INSERT INTO bxh_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","Nun natuna Diyesuwa mate Yaluwa ya famohafu be ya sonoga wananaha paꞌana Mose nimana ya tole hasaen hewana yai. Logena Isalaela dodogadi sa ataꞌatahi lau lisina. Somo haꞌa Guyau, Mose ya fatalaha mate sa lau watanidi. ");
INSERT INTO bxh_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","Aho te, hige peloweta hesa i obiyo Isalaela ganahewadi yai doha Mose, Guyau ya siba wananahai yo maꞌena sa faꞌawa efa. ");
INSERT INTO bxh_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","Logena, Guyau, Mose ya fatamali lawen Idipi be noꞌo yo fafaꞌilala ginaulidi ya lau ginauli Kin Falo yo ena tau paisowa yo ena nuꞌu dodogadi matadi yai. ");
INSERT INTO bxh_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","Logena, hige sai hesa gigibwali laꞌilaꞌina i fapaisowa e laulau fatau didididigadi i lau ginauli doha Mose ya lau ginauli, Isalaela dodogadi mahudoꞌidi matadi yai. ");
INSERT INTO bxh_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Hola hige i ifi tatatali na Akasiya sa lau afulen, na sa leu Diyodan Hoꞌowana sadaina yai, be amainiya edi palai sa faꞌobiyo fuyoꞌidi. Na sa bagibagi bena sa lau tefa. ");
INSERT INTO bxh_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Ya lau ee–, lahai fafaihonana, babaꞌisa sa lau palai hesa - hesa, ");
INSERT INTO bxh_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","be dodoga sa falibadi, itiyen, Yena tau antalasam ami itadi, Guyau emi Yaubada ena Laugagayo Aba Husaꞌina sa iloꞌiloloi mate, emi palai au lopadi, na au lau watanidi. ");
INSERT INTO bxh_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Beyabeyana hige umi amaiteꞌi, be aba launa ami fakau. Haba sa faꞌitamiu. In moho, tabu au sigilau sadaina. Aꞌawana doha kilomita esega. ");
INSERT INTO bxh_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Habahim Diyesuwa dodoga ya falibadi iyen, Taumiu au faꞌaꞌadi. Yaluwamiu enehena au nonoha. Paꞌana bobon Yaubada ena gigibwali yai haba noꞌo laulauna ya fataumahata lisida yai. ");
INSERT INTO bxh_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Diyesuwa ya libalau tau antalasam lisidi yai, iyen, Laugagayo au abi hitin, be au iloloi, na au lawen be dodoga au famulidi. Yo fede, alinana sa lau watan, be sa iloloi. ");
INSERT INTO bxh_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Yaubada Diyesuwa ya faliba iyen, Aho, haba E fatubu be hesam E tole hitin. Isalaela mahudoꞌidi haba sa faꞌatitiyem, be haba sa siba, Yau maꞌem, doha maꞌegu Mose. ");
INSERT INTO bxh_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Tau antalasam u falibadi mate saluma Laugagayo tau baheina, yena ami mahano Diyodan Hoꞌowana bubuna yai, au lau, au obiyo hoꞌowana fotefotena yai. ");
INSERT INTO bxh_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Yo fede, Diyesuwa ya libalau Isalaela lisidi, iyen, Au laoma aiteꞌi, haba Yaubada eda Guyau ena liba te atahiyen. ");
INSERT INTO bxh_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","13","Yaubada ena Laugagayo Aba Husaꞌina haba te ita, be haba te siba sidohana In Tanoꞌubu Mahudoꞌina eda Guyau. Tau antalasam dodogadi haba sa iloloi bwaꞌiyen, be sa doheyen Diyodan yai. Yena ahedi sa bwaꞌiyedi Diyodan Hoꞌowana yai mate, haba ya didi tau, na uluna yai haba ya siu fuyo hasa. Doha, haba te siba, In Tanoꞌubu Mahudoꞌina eda Guyau. Itete sidohana haba te siba Yaubada Mwahumwahulina ganahewada yai, be In haba wananaha, Kanana, Hiti, Hiwi, Pelisi, Giligasi, Amoli yo Diyebusi dodogadi haba ya lau weꞌaidi hinaga. Na aho te, au siꞌoꞌinadi dodoga 12, esega - esega Isalaela sulu hesa - hesa yai. ");
INSERT INTO bxh_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","15","Mahula fuyana mate, be Diyodan Hoꞌowana ena fuya wewe. Habahim, dodoga edi palai sa lopadi, bena Diyodan Hoꞌowana haba sa gayo dohe. Laugagayo tau baheina, iti, sa bwaꞌiyedi. Na tau antalasam te, sa gayo lau hoꞌowa yai, ");
INSERT INTO bxh_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","Maꞌesega, na hoꞌowa ya tiwa, paꞌana ulu yai ya siu fuyo hasa, Adam yo Salatan lumadi yai. Hoꞌowa gwaluna ya tiwa, ya lau Gabogabo Peꞌipeꞌina. Habahim, gonowana dodoga sa lau tefa, tefa leuleuna yai, Diyeliko nuꞌuna yai. ");
INSERT INTO bxh_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Sa dohe sa lau tefa tanohi pitapitalina yai, na Laugagayo tau baheina, gelegele atipuna yai sa obiꞌobiyo. Sa obiꞌobiyo ee–, Isalaela dodoga mahudoꞌidi sa laoma sa lau tefa. ");
INSERT INTO bxh_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Ya lau ee–, Isalaela mahudoꞌidi sa ofi lau tefa, Yaubada Diyesuwa ya faliba, iyebo, ");
INSERT INTO bxh_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","Dodoga 12 u siꞌoꞌinadi sulu esega - esega yai, na u falibadi, uwen, ");
INSERT INTO bxh_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","Au lau Diyodan Hoꞌowana atipuna yai, somo yai tau antalasam sa obiꞌobiyo, be umeꞌehu esega - esega ami abidi, be ami bahe lawedi somo yai emi an abi pei palai yai, iꞌipa te. ");
INSERT INTO bxh_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Be Diyesuwa dodoga te ya yoga gogonidi, ");
INSERT INTO bxh_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","be ya falibadi, iyebo, Au lau be, Guyau eda Yaubada ena Laugagayo Aba Husaꞌina au bwaꞌiyedi, be hoꞌowa atipuna yai umeꞌehu au baheidi, sulu esega - esega Isalaela ganahewada yai. ");
INSERT INTO bxh_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","Ite umeꞌehu te haba eda fafaꞌilala somo Yaubada ya ginauli. Fuya matada yai, yena nanatumiu sa fatiꞌo, “Umeꞌehu te, aniyona somo?” ");
INSERT INTO bxh_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","Haba ami falibadi, auwe, “Umeꞌehu te haba ya fafanuwa hitinida, fuyana Yaubada ena Laugagayo Aba Husaꞌina sa ilolo lawen tefa, Hoꞌowana mate ya tiwa. Ya famala eda fafaꞌilala, fuya hige ana siga.” ");
INSERT INTO bxh_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Diyesuwa dodogadi wa ya fatalahadi, be ena liba sa lau watan. Umeꞌehu 12 sa abidi Diyodan atipuna yai, Isalaela sulu esega - esega sa bahe leuwedi, bena haba edi aba abi gwaꞌu yai sa toledi. ");
INSERT INTO bxh_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Diyesuwa umeꞌehu te ya pei gogondi. Na umeꞌehu wa hola otadi. ");
INSERT INTO bxh_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Na hola hige i pei gogondi, tau antalasam Diyodan atipuna yai sa obiꞌobiyo. Ya lau ee–, Yaubada Diyesuwa ya faliba be ginauli mahudoꞌina sa ginauli faꞌofidi, doha Mose haꞌa Diyesuwa ya faliba. Sa obiyo ee–, na dodoga mahudoꞌidi sa feula, be sa lau tefa. ");
INSERT INTO bxh_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","Sa ofi lau tefa, habahim, tau antalasam Laugagayo Aba Husaꞌina sa mulitama, na dodoga sa kinokinodi. ");
INSERT INTO bxh_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Na sulu faihona wa, Leubena, Gada, yo Manase tefana, hiyala dodogadi ma nonohadi, ma afa haidadi sa bwaꞌi, sa lau tefa, doha beyabeyana Mose haꞌa ya fatalahadi. ");
INSERT INTO bxh_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","Yaubada ena tau hiyala mahudoꞌidi 40,000 sa lau tefa Diyeliko Gonna yai, sa abi nonoha bena haba sa hiyala. ");
INSERT INTO bxh_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Lahaina yai ni, Yaubada Diyesuwa hesana ya tole hitin, Isalaela matadi yai, na ena miyamiya fuyanidi yai sa faꞌatitiyen, doha Mose sa faꞌatitiyen. ");
INSERT INTO bxh_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Yaubada ya libalau Diyesuwa lebena, iye, ");
INSERT INTO bxh_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","Laugagayo tau baheina u fatalahadi, be Diyodan yai ti gayo hitima. ");
INSERT INTO bxh_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Be Diyesuwa, Yaubada ena liba ya lau watan. ");
INSERT INTO bxh_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","Tau antalasam sa gayo hiti dakodako yai, yo fede hoꞌowa ya didi. Yo fede, Diyesuwa hesana sa faꞌatitiyen, paꞌana noꞌo itete sa ita. ");
INSERT INTO bxh_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Nawalahi Mati, lahaina 25 yai, Yaubada ena gigibwali ya famahata, Isalaela dodogadi lebedi yai, lahaina sa lau tefa, be Giligala yai palaidi sa peidi, Diyeliko tefa saisaina yai. ");
INSERT INTO bxh_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Be Diyesuwa umeꞌehu Diyodan yai sa abidi wa, amainiya ya pei gogondi. ");
INSERT INTO bxh_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","Be ya liba Isalaela lebedi yai, iyebom, Bobon asubena, yena ami hiti mulita sa fatiꞌo, tiyebom, “Umeꞌehu te, aniyona somo?” ");
INSERT INTO bxh_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","Au falibadi, auwen, “Guyau eda Yaubada, hoꞌowa ena fuya fatedena yai, Isalaela sa lau tefa. ");
INSERT INTO bxh_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Yo hoꞌowa ya fatede, be gonowana te lau tefa, doha beyabeyana Gabogabo Balebalelemna ya fatede, eneheda.” ");
INSERT INTO bxh_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Haba dodoga mahudoꞌidi tanoꞌubu yai te, sa siba sidohana Yaubada ena gigibwali ya laꞌi, na haba hesana te fadebasae, fuya hige ana siga. ");
INSERT INTO bxh_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Amoli edi babaꞌisa Diyodan tefa leuleuna yai yo Kanana edi babaꞌisa Gabogabo Laꞌilaꞌi tefana yai, wasa sa atahiyen sidohana Yaubada Diyodan Hoꞌowana ya fatede, na Isalaela mahudoꞌidi sa lau tefa. Yo fede, Amoli yo Kanana edi babaꞌisa nuwadi sa belubelu. Ya famala edi ꞌwasabu. ");
INSERT INTO bxh_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Fuyanna yai, Yaubada ya libalau Diyesuwa lebena, iyen, Emi wauꞌoya au oipididi, be Isalaela tataudi mwagisadi dududi ꞌwapidi au ibo fahidi. ");
INSERT INTO bxh_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Yo fede, sidohana Yaubada ya fatalaha, ya ginauli watan, be Isalaela tataudi mwagisadi dududi ꞌwapidi sa ibofahidi. Tuꞌana ni hesana sa tole, “Mwagisa Dududi ꞌWapidi Aba Ibofahidi.” ");
INSERT INTO bxh_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","6","Fuyanna Isalaela Idipi sa lau afulen, tatau mahudoꞌidi mwagisadi dududi ꞌwapidi haꞌa sa ibodi. In moho, fuyanna nuꞌu pitapitalina yai sa laulau, boliman 40 ganahewana yai, nanatudi mwagisadi ꞌwapidi hola hige ti ibofahidi, yo hinaga saluma hiyala tataudi Idipi sa lau afulen, paꞌana Yaubada ena liba hige ti lau watan, yo fede ya kaumananaedi, be nuꞌu pitapitalina yai haꞌa sa peꞌi, doha iyen, Tabu au lau Nuꞌu Mahumahulana yai, haꞌa hiti bwaꞌibwaꞌidi lisidi yai E liba fasunumaꞌedi. ");
INSERT INTO bxh_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Tatau wa, nanatudi hola hige mwagisadi dududi ꞌwapidi ti ibo papadi. Logedidi, iti Diyesuwa ena tau paisowa ya fatalahadi, be mahudoꞌidi mwagisadi dududi, ꞌwapidi sa tomofahidi. ");
INSERT INTO bxh_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Mulina yai, Nuꞌu mahudoꞌina sa miya edi palai yai, ya lau ee–, omatadi sa mwafo. ");
INSERT INTO bxh_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Na Yaubada ya libalau Diyesuwa lebena, iyen, Beyabeyana afa wahamiu Idipi yai sa fakamkamnadi, be aho te emi taumayamaya E ibo afulen. Itete sidohana nuꞌuna te hesana sa tole Giligala. ");
INSERT INTO bxh_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Fuyanna Giligala yai sa miyamiya, Diyeliko Gonna yai, nawalahi lahaina 14 maimailafina yai, Bayawa Anꞌangogona sa ginauli. ");
INSERT INTO bxh_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Bobonna, mate fuya bwaꞌibwaꞌina Kanana adi kalahe sa andi: fwalawa tumadi nefanefadi, yo fwalawa hige siusiuna, tegategadi. ");
INSERT INTO bxh_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Yo fede, fuyana Diyesuwa Isalaela ya lawedi Kanana yai mate, Kanana dodogadi adi gabu anꞌandi sa kalakalahe, na ma esega, mena ya beꞌutau, hige ti abi. ");
INSERT INTO bxh_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Diyesuwa ya sigilau Diyeliko sadaina yai, na matana ya lau hitin yo fede, taumoho hesa ya ita nuwanuwana yai, ya obiꞌobiyo, ma kepakepatana. Diyesuwa ya hasai, ya fatiꞌo iyen, Um hidamai, o ama waiyunu? ");
INSERT INTO bxh_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Alinana ya bui, iyen, Higeꞌe. Yau mate Yaubada ena Hiyala Tau Lau kulukuluwena. Na Diyesu wa ya hoba lidi, be ya faꞌatitiyen, na iyen, Egu Baꞌisa, yau em tau paisowa. Somo wa fanuha, haba E ginauli. ");
INSERT INTO bxh_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Baꞌisa wa, iyen, Ahem sumadi u abifahidi, paꞌana tanohi fafagabina yai wa obiꞌobiyo. Yo fede, ena liba Diyesuwa ya lau watan. ");
INSERT INTO bxh_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","In moho, Diyeliko edaꞌeda sa gududi, be tabu Isalaela dodogadi ti luhulau e ti kalamahanoma, paꞌana iti adi waiyunu. ");
INSERT INTO bxh_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Guyau ya libalau Diyesuwa lisina, iyen, Nuꞌu te haꞌa E nuwa afulen nimam yai, be edi baꞌisa laꞌilaꞌi yo ena hiyala tataudi haꞌa E lei hafihafitidi. ");
INSERT INTO bxh_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Lahai faligigi esega ganahewadi yai, Um yo em hiyala tataudi au lau nuꞌu ni au fataꞌiꞌili, be lahai esega, haba ma esega ami fataꞌiꞌili. ");
INSERT INTO bxh_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Tau antalasam faligigi luwaga edi bwagigi ti abidi, be ti bwaꞌi. Na Laugagayo Aba Husaꞌina, mate ai mulidi. In moho, lahai fafaligigi luwagana yai, fuyana bwagigi sa yufi, mahudoꞌimiu ami lau, ami taꞌiꞌili ma faligigi luwaga. ");
INSERT INTO bxh_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Haba sa yufi fawewehi, ma esega, tatau sa halahalabo, na Diyeliko ganana haba ya talopalopa. Habahim, mahudoꞌimiu ami dudulai, ami luhulau duhu balabalamumu yai. ");
INSERT INTO bxh_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","7","Diyesuwa ya libalau tau antalasam lisidi, iyen, “Tatau au falibadi, bena sa fatubu, be duhu balabalamumu sa fataꞌiꞌili. Tau hiyala pele hesa sa bwaꞌi, mulina yai bwagigi tau abina faligigi luwaga, habahim, laugagayo tau baheina.” ");
INSERT INTO bxh_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","9","Diyesuwa somo ya falibadi, doha sa ginaulidi: Habahim, tau hiyala pele hesa sa bwaꞌi; mulina yai, tau antalasam bwagigi sa yufi; atipu yai, tau antalasam, iti laugagayo tau baheina, mulidi yai, hiyala pele hesa. Ma esega, bwagigi sa yufidi, dagugudi. ");
INSERT INTO bxh_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Na Diyesuwa tatau ya fatalahadi, iyen, Tabu au halabo, yo tabu liba hesa au libaen, ya lau wee–, ana siga E falibamiu. ");
INSERT INTO bxh_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Habahim, tatau mahudoꞌidi ya falibadi, be Yaubada ena Laugagayo Aba Husaꞌina sa iloloi, be duhu balabalamumu sa fataꞌiꞌili ma esega, habahim, sa fiyoma edi aba miya yai; amainiya sa eno. ");
INSERT INTO bxh_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","13","Bobon ma hwalahwalalana, Diyesuwa ya obiyo. Itete haba lahai fafaluwagana, tau antalasam yo hiyala tataudi duhu balabalamumu wa sa fataꞌiꞌili bodai gonogonowana doha bon: Bwaꞌibwaꞌidi tau hiyala pele hesa; mulina yai, tau antalasam faligigi luwaga, bwagigi tau yufidi; atipu yai, Laugagayo tau baheina; mulidi yai, hiyala pele hesa. Itete, fafaluwagana, bwagigi sa yufidi, alinadi. ");
INSERT INTO bxh_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Lahaina yai, duhu balabalamumu sa fataꞌiꞌili bodai ma esega moho, be sa fuyoma edi aba miya. Doha ite sa ginaginauli, ya lau wee–, lahai faligigi esega. ");
INSERT INTO bxh_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Ya ifi tatatali, lahai fafaligigi luwagana yai, sa obiyo, be nuꞌu ni sa fataꞌiꞌili ma faligigi luwaga doha fuya bwaꞌibwaꞌina yai. ");
INSERT INTO bxh_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Fafaligigi luwagana yai sa taꞌiꞌili, tau antalasam begana haba bwagigi sa fadagugu, na Diyesuwa tatau mahudoꞌidi ya falibadi be sa halabo, yo iye, Nuꞌu te Yaubada haꞌa ya feleda! Duhu balabalamumu yo ginauli mahudoꞌidi ganahewana yai bena ami faheyaya esegahidi; ya famala eda antalasam Yaubada eda Guyau, enahena. ");
INSERT INTO bxh_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Na waihin matamata heyayana, Lahaba moho, ma afa efana, tabu ti faheyayadi, paꞌana in eda tau ita sipo ya simodi. ");
INSERT INTO bxh_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Tabu bena ginauli fafagabidi hesa au abidi. Yena ami ginauli doha, mate haba heyaheyaya ami leyama Isalaela ganahewada yai. ");
INSERT INTO bxh_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Ginauli mahudoꞌidi mate, powati afaꞌafa doha: siluba, gole, kapa, yo ayan, mate te tole hudoꞌi, Yaubada enehena. Ya famala Guyau ena ainauya. ");
INSERT INTO bxh_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Yo fede, ma esega tau antalasam bwagigi sa yufidi sa atahiyedi. Habahim sa halabo laꞌilaꞌi. Yo fede, ganana ya talopalopa! Tau hiyala mahudoꞌidi sa dudulai hasa duhu balabalamumu ganahewana yai be sa eli halaen. ");
INSERT INTO bxh_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Kepata yai duhu balabalamumu dodogadi: tatau lalaꞌi, wawahin lalaꞌi, yo wawaya kikiꞌina mahudoꞌidi sa lau funuhidi, yo bulumakau, sipi, yo donki mahudoꞌidi hinaga sa lau funuhidi. ");
INSERT INTO bxh_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Diyesuwa tau ita sipo luwaga wa ya faliba, iyen, Au luhulau Lahaba ena luma, be ma afa efana au ledima, doha ami liba fasunumaꞌen. ");
INSERT INTO bxh_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Yo fede, hewahewali sa lau, be waihin matamata heyayana sa foyahiyama, ma tinana yo tamana, afa lofuna, yo ana boga mahudoꞌidi, be sa famiya komakomanidi edi tefa yai. ");
INSERT INTO bxh_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Duhu laꞌi sa gabu golu, habahim edi ginauli mahudoꞌidi sa gabu esegahidi. Na powapowati moho sa lau afuledi, Yaubada enehena: siluba, gole, kapa, yo ayan. ");
INSERT INTO bxh_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","In moho, Diyesuwa Lahaba ya tole komakomani, ma afa efana, tabu ti talaidi, paꞌana luwaga wa haꞌa ya simodi, fuyanina yai ya fatamali lawedi Diyeliko yai. Fuyanna yai, Lahaba ena hiti mulita hola sa miyamiya Isalaela yai. ");
INSERT INTO bxh_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Lahaina yai, Diyesuwa ya angwala, iyen, Yena sai ya anpate bena Diyeliko nuꞌuna te ya ginauli fuyoi, mate haba Yaubada ya kaumananaen. Sai laꞌi Yena gana paꞌana ya ginauli bodai, ena maisa mate haba natuna bwaꞌibwaꞌina ya peꞌi. Sai laꞌi yena gana edaꞌedana ya ginauli bodai, haba natuna mulimulitana ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Yaubada mate Diyesuwa maꞌena. Wasana ya tadada, be nuꞌu dodogadi mahudoꞌidi sa sibai. ");
INSERT INTO bxh_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Diyesuwa Isalaela Sulu mahudoꞌidi ya faꞌoigogodi, Sekem Nuꞌuna yai, be edi tanutanuwaga, baꞌibaꞌisa, yo tau fakasa mahudoꞌidi sa laoma Yaubada matana yai. ");
INSERT INTO bxh_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Na ya falibadi, iyen, Itete somo Yaubada eda Guyau ya libaen, Hiti bwaꞌibwaꞌi edi fuya yai, Ifeleti Hoꞌowana tefana yai sa miya, yo yaubada haisa sa fadebasaedi. Amainiya, ami ulu tubu hesa hesana Tela mate Abelaham yo Nahola tamadi. ");
INSERT INTO bxh_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Amainiya Ifeleti yai, Abelaham E foyahi lawen, Kanana Nuꞌuna mahudoꞌina yai, yo ana hiti mulita boludi E fatadadadi, yo natuna E felen, hesana Isako. ");
INSERT INTO bxh_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","Na Isako nanatuna E felen, hesadi Iyakobo yo Isowa, yo tuꞌadi haisa Idom nuꞌuna yai Isowa E felen, enehena. Na Iyakobo maꞌana hiti mulita sa lau Idipi. ");
INSERT INTO bxh_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","Fuya lofalofa mulina yai, Mose yo Elon E faꞌobiyodi tau saguhigu. Habahim, heyaheyaya laꞌilaꞌi E leyama Idipi yai. ");
INSERT INTO bxh_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","Na afa wahamiu E lawe hudoꞌiyedi. Fuyanna Idipi sa lau afulen, Idipi maꞌedi hosi tau awaidi yo hosi edi saliyoti, amainiya sa lau weꞌaidi. Na fuyanna sa mahanoma Gabogabo Balebalelemna sadaina yai, ");
INSERT INTO bxh_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","sa anꞌeta laoma, itiye, “Aee–, u saguhimai!” Na kamumu E tole, iti yo Idipi dodogadi atiꞌatipudi yai. Na gabogabo E fasiu fuyoi, be sa kapulolo. Ami siba somo E ginauli Idipi lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","Nuꞌu pitapitalina yai ami miya ee–, fuya lofalofa, habahim, E lawemiu Amoli Nuꞌuna yai, Diyodan tefa saisaina yai. Sa hiyalaimiu, na E galatatamiu. Edi tanohi ami abi, enehemiu, na E lau funuhidi umi debamiu yai. ");
INSERT INTO bxh_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","Na dodoga luwaga, hesa hesana mate Balaki. Tamana hesana Sipoli. In mate Mowabi edi baꞌisa laꞌilaꞌi. Na hesa hesana Balam, tamana mate Beyoli. Mowabi dodogadi, maꞌedi baꞌisa sa hiyalaimiu. Yo fede, Balaki liba ya fatamali lawen, Balam lebena. Ya faliba bena ya kaumananaemiu. ");
INSERT INTO bxh_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","In moho, ibege ya ataꞌatahi lau Balam lisina, be ya liba fasunumaimiu. Itete sidohana E faloholohomiu Balaki lisina yai. ");
INSERT INTO bxh_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","Fuyanna, Diyodan hoꞌowana ami lau tefa, be ami mahano laoma Diyeliko Nuꞌuna yai, dodogadi sa hiyalaimiu, doha Amoli, Pelisi, Kanana, Hiti, Giligasi, Hiwi yo Debusi sa hiyalaimiu. In moho, egu sagu yai, ami lei hafihafitidi. ");
INSERT INTO bxh_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","Bumo hinaga E fatamali bwaꞌiyedi, be Amoli yo edi babaꞌisa luwaga sa weꞌaidi. Hige bena emi kepata yai, e emi pidu yai au faꞌwasabudi. ");
INSERT INTO bxh_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","Na umaꞌuma tanohidi, yo duhu laꞌi ginaginauli nonohadi E felemiu, mate hige au ginaulidi. Na aho, umaꞌuma uludi nonohadi ami anꞌannidi, wain yo oliwe gabudi, umi hige laꞌi au umahidi. ");
INSERT INTO bxh_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","Diyesuwa iyen, Yaubada au faꞌatitiyen, yo ma nuwa ofimiu au famuli watan. Ami mumuga edi yaubada doha oitau au peidi yo au nuwa fuiyedi, yaubadadi beyabeyana Idipi, yo Ifeleti Nuꞌudi yai sa famuli watanidi. Na Yaubada Wananaha moho au famuli watan. ");
INSERT INTO bxh_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Ibe yena Yaubada Wananaha hige au fanuha, mate, lahai te, nuwamiu au hinelidi. Haba yaubada tausomo ami lau watanidi? Ami mumuga, Ifeleti yai edi yaubada haisa? E Amoli edi yaubada haisa iti edi tanohi yai te, aho te miyamiya? In moho, maꞌagu boga haba Yaubada eda Guyau ꞌe lau watan. ");
INSERT INTO bxh_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Dodoga ena liba sa bui, itiyen, Ibege Yaubada Wananaha ai nuwa fuiyen, na yaubada haisa ai famuli watanidi. ");
INSERT INTO bxh_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Edi aba lau fayofayoida Idipi yai, Yaubada eda Guyau ya foyafoyahida, yo ena gigibwali ya famahatadi, be te itadi, yo ya ita wata loholohoꞌida nuꞌu haisa somo yai eda aba lau yai. ");
INSERT INTO bxh_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Eda fuya mahanoma tanohi yai te, Amoli dodogadi, tanohi tau miyaina, Yaubada ya lau weꞌaidi. Haba ai hinaga Guyau ꞌe famuli watan, In eda Yaubada. ");
INSERT INTO bxh_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","20","Na Diyesuwa ya libalau lisidi yai, iyen, Nuwana, hige gonowamiu, Guyau au famuli watan. Ibege emi heyaheyaya i nuwa afuledi. Paꞌana In mate Yaubada Esega. Haba ya fawaiyunuꞌemiu yena yaubada haisa ami famuli watanidi, yo haba ya faheyayamiu yena nuꞌu haisa yaubadadi ami famuli watanidi. Beyabeyana ya loholoho lisimiu yai. In moho, haba ya faheyayamiu, yena ami ginauli doha. ");
INSERT INTO bxh_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Diyesuwa alinana sa bui, itiyen, Ii–, haba Guyau ꞌe famuli watan. ");
INSERT INTO bxh_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","Diyesuwa edi liba ya bui, iyen, Au fawananaha fuyoimiu, haba nuwamiu ami hinelidi, be Yaubada ami famuli watan. Sa liba, tiyen, Ii–, ꞌE liba dudulai! ");
INSERT INTO bxh_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Ya liba adidili lebedi yai, iyen, Yena wananaha, nuꞌu haisa yaubadadi au abi afuledi, Guyau, Isalaela eda Yaubada, au tauꞌului. ");
INSERT INTO bxh_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Habahim, Diyesuwa sa faliba, itiyen, Haba Guyau eda Yaubada ꞌe lau watan, na ena laugagayo hinaga ꞌe lau watan. ");
INSERT INTO bxh_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","Lahaina yai, Diyesuwa yo dodoga edi yali sa ginauli Yaubada matana yai. Sekem Nuꞌuna yai ni, laugagayo haisa ya feledi bena sa lau watanidi. ");
INSERT INTO bxh_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","Yo fede, Yaubada ena laugagayo bukana yai ya ulidi, habahim, Yaubada ena tanohi fafagabina yai ni, umeꞌehu laꞌilaꞌi ya bono, oyagi hesa hesana oki paꞌana yai. ");
INSERT INTO bxh_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Ya libalau ouꞌoulidi lisidi, iyen, Umeꞌehu te eda yali fafaꞌilalana, paꞌana Yaubada ena liba mahudoꞌidi lisida yai, umeꞌehu te ya atahiyedi. Yo fede, in haba tau fawananahana lisimiu yai. Haba eda Yaubada ami kawawananahaꞌen, na tabu au lau afulen! ");
INSERT INTO bxh_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Mulina yai, Diyesuwa dodoga mahudoꞌidi ya fatamalidi sa lau hesa - hesa ena nuꞌu yai. ");
INSERT INTO bxh_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Mulina yai, Yaubada tau saguhina, Diyesuwa, Nun natuna, ya peꞌi. Ena boliman mate 110. ");
INSERT INTO bxh_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Ena nuꞌu hesana Timnata Sala, Efalaim Tuꞌadi ganahewadi yai, mate tuꞌa hesa hesana Gaꞌasi tefa lidilidina yai amainiya sa boꞌusai. ");
INSERT INTO bxh_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Diyesuwa ma miyamiyana, Isalaela Yaubada sa lau watan, ya lau ee–, ya peꞌi. Mulina yai, Diyesuwa ena babaꞌisa sadaina yai ma miyamiyadi, Yaubada sa lau watan hinaga, paꞌana ginauli mahudoꞌidi Yaubada ya famahatadi lisidi yai, matadi yai sa itadi. ");
INSERT INTO bxh_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Beyabeyana, Idipi yai, Diyosepa silanna sa lawen, be adi ulutubu, Iyakobo, adi bwana tanohina haꞌa ya une, maisana mate siluba ouꞌoulidi 100, Hamoli nanatudi lebedi yai, amainiya Sekem nuꞌuna yai sa boꞌusai. ");
INSERT INTO bxh_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Yo Eliyesa, Elon natuna ya peꞌi hinaga, be sa boꞌusai, Gibiya Nuꞌuna yai. Nuꞌuna mate Efalaim Tuꞌadi ganahewadi yai, haꞌa sa felen, Eliyesa natuna Fineyasi, enehena. ");
INSERT INTO bxh_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","Diyesuwa yo babada ma mwamwahulidi mate Isalaela dodogadi hola Guyau sa fafamuli watan. Guyau ginauli lalaꞌi ya lau ginauli enehedi mate mahudoꞌidi sa ita. ");
INSERT INTO bxh_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","Nun natuna, Diyesuwa mate Guyau tau famuli wataninna. Ena bolima 110 na ya peꞌi, ");
INSERT INTO bxh_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","be ena tanohi Guyau ya felen amainiya sa boꞌusai. Tanohina mate Timnata Helesi nuꞌuna yai, Efalaim piupiu hitidi yai, Gaꞌasi tuꞌana tefa lidilidina yai. ");
INSERT INTO bxh_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Hiti te ya peꞌi mulina yai mate hiti mulita hige Guyau ti sibai yo somo ya laulau ginauli Isalaela enehedi hige ti sibai hinaga. ");
INSERT INTO bxh_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","Isalaela dodogadi heyaya sa ginauli Yaubada matana yai be Baꞌala oitaudi sa fadebasaedi. ");
INSERT INTO bxh_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","Afa wahadi Guyau edi Yaubada sa nuwa afulen, Logenana Idipi yai ya foya fahidi. Yaubada hahaisa sa famuli watanidi na dodoga sadasadaidi yai edi yaubada sa fadebasaedi be Guyau manana sa fabala. ");
INSERT INTO bxh_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","Guyau sa nuwa afulen be Baꞌala yo Asitoleti oitaudi sa fadebasaedi. ");
INSERT INTO bxh_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","Guyau ya manabala heyaheyaya Isalaela lebedi yai na ya ita afuledi tau lau kwaya lisidi yai be sa lau kwayaidi yo edi ginauli sa angafuhidi hinaga. Adi waiyunu sadasadaidi yai ya nuwa afuledi be sa lei hafihafitidi. ");
INSERT INTO bxh_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","Ibe Isalaela sa lau sa hiyala ibege Guyau i saguhidi be waiyunu haba sa lei hafihafitidi, doha haꞌa ya angwala lebedi yai. Yo fede nuwadi sa faiꞌabi. ");
INSERT INTO bxh_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","Habahim Guyau diyadi ya faꞌobiyodi be Isalaela dodogadi tau lau kwaya lisidi yai ya fasagufahidi. ");
INSERT INTO bxh_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","In moho Isalaela hige diyadi edi liba ti atahiyedi. Sa lau yaubada hahaisa sa famuli watandi yo sa fadebasaedi doha doga, tau matamata heyaya ya fafamuli watandi. Iti hige doha afa wahadi, Guyau ena laugagayo sa famuli watandi. Edi laulau hige ti laulawen be feula, Guyau sa nuwa afulen. ");
INSERT INTO bxh_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Adi waiyunu mate, Isalaela sa fakamkamnadi yo sa abi heyayaidi Guyau ya atahi be diyadi ya fasinabo. Guyau, diyadi maꞌena na ya saguhi be adi waiyunu nimadi yai ya fofofahidi. Diyadi ena fuya yai mate Guyau, Isalaela dodogadi ya nuwatohatohaedi. ");
INSERT INTO bxh_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Fuyanna diyadi ya peꞌi mate Guyau sa nuwa afulen yo sa heyaya wananaha habahim afa wahadi. Yaubada bwalabwaladi sa famuli watandi yo sa fadebasaedi. Hige gonowana laulau heyaheyayadi yo nuwa lau wata ti fatautau. ");
INSERT INTO bxh_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Beyabeyana, Isalaela hola hige edi kin mate, tau fafadudulai edi fuya ita watanidi yai, nuꞌuna mate guliyam laꞌilaꞌi. Yo fede, taumoho hesa hesana Elimileka, in Sulu Efalata mate Betelehem yai sa miyamiya Diudeya Nuꞌuna ganahewana yai. Ma lahuna Naomi yo nanatudi luwaga, Malon yo Kiliyon, sa aulaha sa lau sa miya Mowabi Nuꞌuna yai. Fuyana amainiya sa miyamiya, ");
INSERT INTO bxh_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Elimileka ya peꞌi. Lahuna Naomi ma nanatuna luwaga ya peꞌi afuledi. ");
INSERT INTO bxh_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Yo fede, Mowabi wawahindi Opa yo Luta sa faidi. Bolima safuhudohudoꞌi sa ofi, mulina yai, ");
INSERT INTO bxh_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Malon yo Kiliyon hinaga sa peꞌi. Yo fede, Naomi hige lahuna yo nanatuna. ");
INSERT INTO bxh_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Boliman fisa sa ofi, mulina yai Naomi ya atahiyen mate, Guyau haꞌa ena dodoga ena loholoho ya feledi, be sa mahula. Yo fede, ya nonoha na, ma afa lawana Mowabi Nuꞌuna sa lau afulen. ");
INSERT INTO bxh_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Sa fatubu, sa aulaha sa lau Diudeya na edaꞌedana yai ");
INSERT INTO bxh_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","ya libalau lebedi, iye, Au fuyo, be afa tinamiu ma afa haidamiu au miya! Haba Guyau ya loholoho lisimiu yai, doha ami loholoho lisigu yai yo tau peꞌi lisidi yai hinaga. ");
INSERT INTO bxh_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","10","Haba Guyau ya saguhimiu be emi nahi ya famahatadi, na ami nahi fuyo, be emi luma ami fatubu bodaidi. Habahim, Naomi ya falafudi, na sa fatubu sa tan. Sa libalau, tiyen, Higeꞌe! Haba ꞌe lau watanim, be te lau haidam lisidi. ");
INSERT INTO bxh_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Naomi alinadi ya fafiyo iyen, Nanatugu, au fuyo! Paꞌana somo be ami lau watanigu? Ami nuwatuhui bena haba E fanatu fuyo, be nanatugu tatau, na haba ami faidi? ");
INSERT INTO bxh_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Au fuyo emi nuꞌu! Paꞌana yau mate E tinalaꞌi, be hige gonowana ya nahi fuyo. E nuwatuhui, egu fuya ya ofi. Na ibe iꞌipa te E nahi, na nanatugu tatau, ");
INSERT INTO bxh_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","Haba tabu au nahi na ami bagibagiyedi ee–, sa hewali? Nanatugu, higeꞌe! Ami sibai mate hige gonowana. Yaubada ya taꞌai mulimuliyegu, be nuwagu ya heyayaꞌemiu. ");
INSERT INTO bxh_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Yo fede, hinaga sa tan fuyo. Habahim, Opa lawana ya falafu, be ya fuyo, na Luta ya toha didini. ");
INSERT INTO bxh_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Be Naomi ya libalau lisina iyen, Luta, falem nahi ya fuyo afa efana yo ena yaubada lisidi. Maꞌem au fuyo emi nuꞌu. ");
INSERT INTO bxh_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Luta iye, Tabu u fatamali fafuyogu! Wa lau somo: yau maꞌem, yo somo yai wa miya: yau maꞌem, Haidam: haidagu, Em Yaubada: egu Yaubada. ");
INSERT INTO bxh_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Ai somo wa peꞌi: haba ainiya E peꞌi hinaga, yo haba ainiya sa boꞌusaigu. Haba Yaubada ya kaumananaegu, yena somo E ginauli faheyaya. Ibe hige somo hesa i hinelida. Na peꞌi moho haba ya hinelida. ");
INSERT INTO bxh_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Yo fede, Naomi ya nuwatuhui mate Luta ya dudu wananaha, be hige somo hesa i libaen. ");
INSERT INTO bxh_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Sa lau ee–, sa mahano Betelehem yai. Dodoga mahudoꞌidi nuwadi sa amna, na wawahin sa fatiꞌo fuyoꞌidi, tiyen Itete moꞌisa, Naomi? ");
INSERT INTO bxh_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Naomi, alinadi ya fafuyo, iyen, Tabu au atahigu Naomi, Au atahigu Kalapi, paꞌana Yaubada ya fanuwa heyayagu. ");
INSERT INTO bxh_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Amateꞌi E aulaha mate, egu ginauli boludi. Na Yaubada ya fafuyoguma te, hige egu ginauli. Tabu au atahigu Naomi, paꞌana Yaubada, Tau Gigibwali, ya kaumananaegu na heyaheyaya ya felegu. ");
INSERT INTO bxh_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Itete sidohana Naomi ma lawana Luta, Mowabi Nuꞌuna yai, sa fuyoma. Fuyanna sa mahano mate, mahula ya fatubu Betelehem yai. Kalahe hudoꞌi hesana bali, nenena doha laisi, ena fuya anaho. ");
INSERT INTO bxh_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Naomi hwabuna Elimileka efana hesa hesana Bowasi. In ya bada yo ya mahula. ");
INSERT INTO bxh_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Fuya esega, Luta ya libalau Naomi lisina, iyen, Ibe wa liba afulegu, E lau dodoga edi gabu yai, be tau paisowa kalahe somo yai sa lau afuledi E tanoꞌidi. Egu siba gonowana nuwana, doga hesa haba ya itagu, yo haba ya fanuhagu, be ai lisina E paisowa. Luta alinana Naomi ya bui, iyen, Natugu, u lau! ");
INSERT INTO bxh_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Yo fede, Luta ya lau gabu hesa yai, be tau paisowa mulidi yai ya lau, be kalahe sa lau afuledi, ya tano gogoidi. Nuwa supu yai ya lau Bowasi ena gabu yai. ");
INSERT INTO bxh_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Hige walolona Bowasi, Betelehem yai ya mahano fuyoma, be tau paisowa ya lautoꞌiyedi, iye, Yaubada maꞌemiu. Na iti, alinana sa fafuyo, tiyen, Yaubada i saguhim. ");
INSERT INTO bxh_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Bowasi ya fatiꞌo lau tau paisowa edi baꞌisa lebena, iyen, Waihin hasahasalana ni, sai? ");
INSERT INTO bxh_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Tau paisowa tau ita watandi alinana ya bui, Waihin te, laolaoma. Mowabi yai maꞌena Naomi sa fiyoma. ");
INSERT INTO bxh_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Na ya anꞌetaigu, iyen, U abigu be tau paisowa ai mulidi, anꞌan ya tano. Haꞌa ya paisowa fatubu hwalahwalala yai, be atabahim, logulogu yai ya anyawasi. ");
INSERT INTO bxh_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Yo fede, Bowasi ya libalau Luta lebena yai, iyen, Hola ya fatalaham. Tabu kalahe ai gabu hesa u tano. Aiteꞌi moho, egu tau paisowa ma afa haidam. ");
INSERT INTO bxh_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","U itaꞌita lau somo yai sa paisowa, bena ma afa haidam, Haꞌa egu tau paisowa tatau E falibadi yo E laugagayoꞌedi, ibege ti fasinam. Na yena gadom ya magu, u lau be hoꞌowa sa yahi kaulidi, am u nom. ");
INSERT INTO bxh_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Luta ya dulu lidi ena faꞌatiti ya ginauli, na ya libalau Bowasi lebena, iyen, Yau taꞌowawa. Sidohana be wa modeꞌegu? Yo paꞌana somo wa abi loholohoꞌigu? ");
INSERT INTO bxh_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Bowasi alinana ya bui iyen, Haꞌa E siba, lawam ena ginauli mahudoꞌidi wa ginaulidi, lahum ena fuya peꞌi mulina yai. E siba sidohana tamam, tinam yo em nuꞌu wa lau afuledi, na wa laoma, beyabeyana dodoga hige u sibaidi, lisimai yai wa miya. ");
INSERT INTO bxh_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Somo wa ginauli, haba Yaubada ya famaisam, be maisam mahudoꞌina haba wa abi Isalaela eda Yaubada lebena yai, haba loguloguna yai ya bobodiyem. In lebena yai wa laoma, mwahuli wa abi. ");
INSERT INTO bxh_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Bowasi alinana Luta ya bui, iyen, Baꞌisa, um wa loholoho wananaha lebegu yai. Nuwagu wa faꞌadidili, paꞌana wa abi komakomanigu. In moho, E nuwatuhui mate, yau hige em tau paisowa laꞌi maꞌegu gonogonowamai. ");
INSERT INTO bxh_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Kalahe fuyana yai Bowasi ya libalau Luta lisina, iyen, U laoma, be fwalawa tefana u abi, na u bwalui ai liꞌu. Yo fede, ma afa haidana tau paisowa sa taꞌai, na Bowasi kalahe gabugabudi haisa ya fatamali lawen lisina. Ya anꞌan ee–, bogana ya yahayaha. In moho, ana kalahe ya antole; hige i faꞌofidi. ");
INSERT INTO bxh_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","16","Habahim, ya aulaha be ya fuyo gabu. Ana ya tano boda. Muli yai Bowasi ena tau paisowa ya falibadi, iyen, Au ita afulen, tabu somo au libaen ai lebena. In moho, gabu anꞌandi pilidi yai, haisa au solu fahidi be au lau afuledi, haba ai ana ya tanoꞌidi. ");
INSERT INTO bxh_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Amainiya Luta ana kalahe ya tano gogo ee–, ya mailafi. Na ya abi lisi mate, begana haba 10 kilograms ya lobahi. ");
INSERT INTO bxh_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","In kalahe ya tanoꞌidi, na ya fuyo edi nuꞌu be lawana ya faꞌita, oulina fisa, yo hinaga anꞌan antoledi ya felen. ");
INSERT INTO bxh_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Naomi ya fatiꞌo lau Luta lisina, iyen, Somo yai wa tanoꞌidi? Sai ena gabu yai wa paisowa? Haba taumoho ni Yaubada ya fanuwa loholoho, paꞌana ya abim be wa paisowa. Yo fede, Luta, Naomi ya faliba mate Bowasi ena gabu yai ya paipaisowa. ");
INSERT INTO bxh_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Naomi ya libalau lawana lebena, iyen, Guyau ena faloholoho Bowasi ai lisina! Ena liba fasunuma tau mwahuli yo tau peꞌi lisidi yai hige ofina! Yo ya liba fiyo, iyen, Taumoho ni ama hwahwayasa hesa wananahana. In tau ita watanimai. ");
INSERT INTO bxh_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Luta Bowasi alinana ya libaen, Hinaga iye, Bena ma afa haidagu, ena tau paisowa, ꞌe paisowa ee–, ꞌe lau gabu faꞌofi. ");
INSERT INTO bxh_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Na Naomi ya libalau Luta lebena, iyen, Ihi–, Natugu, loholohona mate wawahin ni ma afa haidam au paisowa Bowasi ena ai gabu. Yena doga hesa ena ai gabu wa paisowa ibe ti iwalaim. ");
INSERT INTO bxh_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Yo fede, maꞌedi Luta bali yo witi gabudi luwaga sa lau gabu ofinidi. Na amainiya ma lawana sa miya esega. ");
INSERT INTO bxh_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Fuya fisa sa ofi, habahim, Naomi ya libalau Luta lisina yai, iye, Yau haba lahum E yoꞌoi. Be haba ibomiu emi luma. ");
INSERT INTO bxh_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Wa siba wawahin saluma ma afa haidam ami paipaisowa edi baꞌisa hesana Bowasi mate ama hwahwayasa. U ataꞌatahi. Iꞌipa te, haba bali anꞌandi sa abi lisidi yo sa oiluhidi. ");
INSERT INTO bxh_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","U siwa, em maꞌi panepanena u maꞌiyen, yo luhuluhu loholohodi u liꞌodi, na u lau somo yai ena aba peipei hineli. Tabu i sibaim mate, um amainiya ee–, ya anꞌan, yo ya nom maꞌuda. ");
INSERT INTO bxh_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Bena wa siba komakoman somo yai ya eno, na yena ya eno wafu, u lau ena kabobo u lau hitin, na ai ahena sadaina u eno. Haba somo ya falibam be, wa ginauli. ");
INSERT INTO bxh_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Naomi alinana Luta ya bui, iyen, Nuwatuhu mahudoꞌidi wa libaedi haba E lau watanidi. ");
INSERT INTO bxh_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Yo fede, Luta ya lau Bowasi ena aba pei hineli nuꞌuna yai, be lawana somo ya faliba mate, mahudoꞌina ya ginauli. ");
INSERT INTO bxh_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Fuyanna, Bowasi ya anꞌan yo ya nom maꞌuda, ma amna loholohona ya lau kalahe peina yai ya eno. Yo fede, Luta ya lau fafamatano be kabobo ya abi hitin, na ya guli lidi ahena yai. ");
INSERT INTO bxh_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Iꞌipana yai Bowasi ya eno bui, waihin ahena sadaina yai ya laulau eno, ya tau hitiyen. ");
INSERT INTO bxh_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Bowasi ya fatiꞌo, iyen, Um sai? Luta alinana ya bui, iye, Baꞌisa, Yau! Em mwahu mate, bena wa faigu, be wa ita watanigu, paꞌana am hwahwayasa mate yau. ");
INSERT INTO bxh_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Bowasi ya liba, iyen, Guyau ya loholoho lisim yai, paꞌana em abi loholoho lisigu yai ya laꞌi, doha hige Naomi em abiꞌabiyena. Nuwana ibe haꞌa u lau hewali mahumahulana e dehadehana u yoꞌoi. In moho, higeꞌe. ");
INSERT INTO bxh_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Luta, atabahim, tabu u mode. Yau haba ginauli mahudoꞌidi wa fanufanuhadi E ginaulidi; doha dodoga nuꞌu yai te haꞌa sa sibaim, mate um waihin loholohona. ");
INSERT INTO bxh_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Wananaha mate um egu hwabu, haba E ita watanim. In moho, taumoho hesa in am hwahwayasa wananahana, habahim, yau. ");
INSERT INTO bxh_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Maihona te haba aiteꞌi wa miya, haba hwalahwalala te lobahi e higeꞌe, haba sai ya ita watanim. Yena higeꞌe, E liba dudulai, Yaubada matana yai mate, Yau haba mwahum E bahei. Doꞌata te, aiteꞌi wa miya ee–, hwalahwalala. ");
INSERT INTO bxh_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Yo fede, ahena sadaina yai ya guli fuyo, na hola ma kamumuna, ya obiyo, paꞌana tabu nuꞌu ti mahata be ti ita yo Bowasi hige i fanuha bena sai i siba mate, in amainiya. ");
INSERT INTO bxh_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Bowasi ya libalau lisina, iyen, Em fakou u kamfahi be aiteꞌi u hese. Ena liba ya lau watan, yo fede, bali laꞌina begana haba doha 20 kilograms ya fagoi ganahewana yai, na ya saguhi be sa lau hitin, na dabayalona yai ya tole. Habahim ya fuyo duhu laꞌi. ");
INSERT INTO bxh_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Fuyana Luta ya fuyoma lawana lisina. Naomi ya fatiꞌo, iyen, Natugu, sidohana? Habahim, somo mahudoꞌina Bowasi ya ginauli, enehena ya dede, ");
INSERT INTO bxh_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","yo hinaga, bali te ya felegu, na iyen, Ibege ma nima fafam u fuyo lawam lisina. ");
INSERT INTO bxh_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Habahim Naomi ya liba, iyen, Natugu, u bagibagi ee–, somo hesa ya taumahata. Bowasi ibege i anyawasi, ana siga ginauli mahudoꞌidi sa dudulai. ");
INSERT INTO bxh_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Habahim, Bowasi ya lau aba oiꞌoigogo nuꞌuna yai, be taon laꞌilaꞌi edaꞌedana hafohafona yai, amainiya ya taꞌai. Elimileka efana hesa, taumoho Bowasi haꞌa ya oilibaen, ya laoma, yo fede, Bowasi ya yoga lau lisina, iye, Hidagu, u laoma aiteꞌi, u taꞌai. ");
INSERT INTO bxh_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Habahim, Bowasi taon babaꞌisadi safuhudohudoꞌi ya falibadi, be amainiya sa taꞌai hinaga. ");
INSERT INTO bxh_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Ya libalau efana lisina, iyen, Naomi mate Mowabi yai ya fiyoma. Aho ya fanuha bena efada Elimileka ena tanohi ya uneꞌuneꞌen. ");
INSERT INTO bxh_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Be egu nuwatuhu bena um wa sibai hinaga, aho te ibe wa fanuha, u une, dodoga sa taꞌataꞌai ai matadi. Na yena wa ꞌwaiyoꞌo mate u liba dudulai haba yau E abi. Taumoho wa, iyen, Haba E une. ");
INSERT INTO bxh_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Bowasi iyen, Ya loholoho. In moho, ibe tanohi Naomi lisina yai te mahudoꞌina wa une mate, Mowabi edi hwabu Luta haba wa fai, be tanohi mahudoꞌina mate, taumoho peꞌipeꞌina afa efana ai lebedi haba ya ota esega. ");
INSERT INTO bxh_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Mwahu tau famaisana alinana ya bui, iyen, Doha mate, haba nuwagu E bui, be, ibege tanohi ni ya une, paꞌana ibe itaꞌitana doha yau nanatugu ibege ti abi bodai. Um u une. Yau E waiyoꞌo. ");
INSERT INTO bxh_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Fuyandi yai ni, yena bena tau uneꞌune sa tole komanidi, o ginauli bena sa buidi, edi laulau mate bena ginauli tanuwagadi ana ahe sumasuma ya kamfahi be tau uneꞌune ya felen. Ite laulauna haba Isalaela sa ita mate, edi mwahu haꞌa sa fadudulai. ");
INSERT INTO bxh_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Yo fede, ya libalau Bowasi lebena, iyen, Um u une. Na ana ahe sumasuma ya kamfahi, be Bowasi ya felen. ");
INSERT INTO bxh_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Habahim, ya libalau babaꞌisa yo dodoga haisa lisidi, Aho te, mahudoꞌimiu matamiu yai mate, haꞌa ginauli mahudoꞌidi Naomi lebena yai E unedi, Elimileka ma nanatuna Kiliyon yo Malon, enehedi. ");
INSERT INTO bxh_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Ofiꞌofina mate, Luta, Mowabi waihinina, Malon hwabuhwabuna haba ya famala lahugu. Itete mate, haba tau peꞌi ana boga edi ginauli mahudoꞌidi E liba buluhidi, paꞌana tabu Elimileka hesana ti nuwa fuiyen. Elimileka ana boga, ena luma yo ena tanohi haba sa ota esega. Matamiu yai ami itagu. ");
INSERT INTO bxh_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Babaꞌisa yo dodoga haisa sa liba fasunumaꞌen, tiyen, Wananaha, ita mate, haꞌa te ita. Haba eda Yaubada lahum ena abiꞌabina doha Lahela yo Liya, be Iyakobo nanatuna boludi sa yosidi. Haba um wa mahula, Sulu Efalata ganahewana yai, yo ai Betelehem haba hesam sa falaꞌi. ");
INSERT INTO bxh_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Haba nanatumiu Yaubada ya felemiu, be waihin hasahasalana te ya yosidi, be haba laulauwewemiu fafahesadi Pelesi, Diuda yo Tama natuna. ");
INSERT INTO bxh_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Yo fede, Bowasi Luta ya lawen ena luma be ya famala lahuna. Yaubada ena loholoho ya felem, yo fede, ya boga, be natuna taumoho ya yosi. ");
INSERT INTO bxh_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Wawahin sa libalau Naomi lisina yai, tiyen, Yaubada te fadebasae! In aho te, waham ya felem, be haba ya ita watanim. Gwama te ai Isalaela haba in doga laꞌilaꞌi hesa! ");
INSERT INTO bxh_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Lawam mate ya fanuha wananahaim, yo em ginauli mahudoꞌidi ya ginaulidi, doha ibe nanatum faligigi luwaga edi itaꞌita watanim. Na aho waham ya felem, haba mwahuli fwaufwau ya leyama lisim, yo hinaga em tinatinalaꞌi yai, tau ita watanim. ");
INSERT INTO bxh_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Naomi, gwama ya abi be ya faseda. ");
INSERT INTO bxh_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Na wawahindi amainiya sa miyamiya tiyen, “Naomi natuna taumoho.” Be hesana sa tole, Obedi. ");
INSERT INTO bxh_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","22","Kin Deiwidi laulauwewena ena aba fatubu mate: Pelesi, Heselon, Lam, Aminadaba, Nason, Salamon, Bowasi, Obedi, Desi, yo Deiwidi. Ite lauwewedi mate, Pelesi yai ya fatubu, ya lau wee–, Deiwidi yai. ");
INSERT INTO bxh_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Sulu Efalaim dogana hesa hesana Elikana, ena nuꞌu mate Lamataim-Sofi nuꞌuna ganahewana yai. Efalaim piudi yai, ya miyamiya. In mate Diyeloham natuna. Diyeloham, Elihu natuna. Elihu, Tohu natuna na Tohu mate Sufi natuna. ");
INSERT INTO bxh_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Lalahuna luwaga. Hesa hesana Hana, na hesa Penina. Penina ya fanatu na Hana ya agali. ");
INSERT INTO bxh_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Bolima ouꞌouli taumoho te ena nuꞌu yai ya hasahasai Silo bena Guyau Gigibwali Mahudoꞌidi Tanuwagadi ya fadebasae yo antalasam ya ginaginaulidi lebena yai. Fuyanna yai, Tau antalasam Baꞌisana hesana Eli. Eli nanatuna tatau luwaga, Hofini yo Fineyasi mate, Guyau ena anꞌantalasam paisowana sa ginaginauli nuꞌuna yai. ");
INSERT INTO bxh_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Yena antalasam lahaina ya mahano Elikana haba antalasam suisuidi ya nigohidi be lahuna Penina yo nanatuna tatau yo wawahin adi yopeyope ya feledi. ");
INSERT INTO bxh_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Guyau, Hana ya faꞌagali be hige nanatuna. In moho Elikana ya fanuha wananahai be ana yopeyope laꞌilaꞌi ya felen. ");
INSERT INTO bxh_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Guyau Hana ya faꞌagali. Logena, fuya ouꞌouli Penina haba Hana ya anꞌan kibiyen bena ya eli famanabala. ");
INSERT INTO bxh_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Laulauna te bolima ouꞌouli ya laulawen. Na yena Hana ya hasai Guyau ena luma mate Penina haba ya lululu felen yo ya eli fatantan be ibege i anꞌan. ");
INSERT INTO bxh_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Elikana, Lahuna ya faliba komakomaniꞌi iyen, Hidagu! Paꞌana somo be wa tan? Sidohana hige u kalahe? Nuwam ya heyaya be? Wananaha hige natum. Nuwagu yai yawa, “Wa fanuha wananahaigu! In moho Ibe nanatum boludi haba wa fanuha wananahaigu, habahim itete.” ");
INSERT INTO bxh_vpl VALUES ("S11_9","010_1_9","1SA","1","9","10","Silo yai sa kalahe maꞌuda mate Hana ya obiyo. Nuwa kalapi ya lau fafamohafu be ya lau ya tan heyaheyaya Guyau lisina yai. Maihalana yai Guyau ena luma edaꞌedana duhuna sadaina yai mate tau antalasam, Eli aba taꞌai yai ya taꞌataꞌai. ");
INSERT INTO bxh_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Hana ya angwala iyen, Hewa Wananaha Guyauna, u itagu! Yau em tau paisowa, na egu nuwa kalapi wa ita mate, tabu u nuwa afulegu, u nuwatuhuigu! Yena natugu taumoho wa felegu haba E fele fuyoiyawa lisim be em ya paisowa ena mwahuli mahudoꞌina yai. Angwala fafaꞌilalana mate kuluna ibege i ibo. ");
INSERT INTO bxh_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Hana ya laulauꞌuꞌula lau Guyau lisina, na Eli mate, Hana moꞌana yo sopana ya kinokinoꞌidi. ");
INSERT INTO bxh_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","Eli ena nuwatuhu bena haga ya nom, paꞌana hige alinana i atahi, ");
INSERT INTO bxh_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","be ya faliba iyen, Maihala somo nom haba wa fatautau? Am wain u lawe hudoꞌiyen. ");
INSERT INTO bxh_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Hana alinana ya bui iyen, Baꞌisa, hige ya nom, egu nuwa kalapi Guyau E faliba. ");
INSERT INTO bxh_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","E lauꞌuꞌula doha ite paꞌana nuwagu hige i loholoho be tabu u nuwatuhui uwen, “waihin heyayana.” ");
INSERT INTO bxh_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Eli alinana ya bui iyen, U nuwa talu, na u lau! Somo wa anꞌanꞌetai Isalaela eda Yaubada lisina yai i felem. ");
INSERT INTO bxh_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Hana ya liba iyen, Baꞌisa, agutoꞌi, u mata amnaꞌegu. Habahim ya lau ya anꞌan be hige i nuwa heyaya fuyo. ");
INSERT INTO bxh_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Bobonna ma hwalahwalalana, Elikana maꞌana boga sa eno obiyo be Guyau sa fadebasae. Habahim sa fuyo edi luma Lama. Elikana ma lahuna sa luma gwaꞌu be ena anꞌeta Guyau lisina yai sa fawananaha. ");
INSERT INTO bxh_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Habahim, Hana ya boga be natuna taumoho ya yosi. Hesana ya tole Samuwela, iyebom, Guyau lisina yai E anꞌetai, be ya felegu. ");
INSERT INTO bxh_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Fuyana Elikana yo ana boga mahudoꞌidi sa hasai Silo bena bolima esega esega antalasamna sa ginauli Guyau ai lisina yo bena ena angwala ya fawananaha, ");
INSERT INTO bxh_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Hana hige i lau. Ya libalau Elikana lisina iyebom, Gwama nom E fadabu, ai mulina haba E lawen Guyau ena ai luma. E fele afulen ai lisina haba ainiya ya miya, ena fuya mahudoꞌidi yai. ");
INSERT INTO bxh_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Elikana alinana ya bui iyen, Somo wa nuwatuhui ya dudulai, u lau watan yo au miya ee–, nom ya dabu. Guyau ena liba fasunuma moho i fawananaha. Na waihin luma yai ya miya na natuna ya ita watan ee–, nom ya dabu. ");
INSERT INTO bxh_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Samuwela, ma kiukiuna, nom ya dabu mulina yai, mate tinana ya hasaen Guyau ena luma, Silo yai. Bulubulumakauna ena bolima faihona yo fwalawa laꞌina kilogram safuhudohudoꞌi yo wain ilena hinaga ya abi hasaedi. ");
INSERT INTO bxh_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Bulumakau sa wunui, mulina yai mate gwama sa lawen Eli lebena. ");
INSERT INTO bxh_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Be tinana iyen, Baꞌisa, wananaha, yau waihinigu, logegu, E obiꞌobiyo sadaim yai, na E laulauꞌuꞌula lau Guyau lisina. ");
INSERT INTO bxh_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Gwama te egu anꞌeta yai, be egu anꞌetana debana yai Guyau ya felegu. ");
INSERT INTO bxh_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Be aho te E fele afulen haba Guyau ena ya paisowa fuya ouꞌouli. Be ainiya Guyau sa fadebasae. ");
INSERT INTO bxh_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Na Hana ya lauꞌuꞌula iyen, Nuwagu ya amna Guyau lisina yai, paꞌana ya faꞌadidiligu. Ya fofofahigu, logena nuwagu ya amna, be agu waiyunu E liuhwaꞌedi. ");
INSERT INTO bxh_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","Hige sai hesa fafatabuna doha Guyau; Hige sai hesa sadaim yai. Hige poꞌa hesa, tau bobodiyenda, doha eda Yaubada, Hige sai hesa i itaꞌita wata doha Um, ema Yaubada. ");
INSERT INTO bxh_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","Tabu keke hesana au atahi; Nuwa saesae au fatautau. Paꞌana Guyau Yaubada ginauli mahudoꞌina ya sibaidi, be emi laulau haba ya fakasadi. ");
INSERT INTO bxh_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","Guyau, um tau hiyala edi kukupidu tau dem pwaipwaidi; na dodoga belubeludi wa faꞌadidilidi. ");
INSERT INTO bxh_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Dodoga mahumahuladi sa guliyam, aho te adi kalahe monina sa paisowaidi, in moho, tau guliguliyam, aho te sa mahula. Waihin hamohamoꞌafina wa ya fanatu be nanatuna faligigi luwaga, na waihin fanafanatuna ya baꞌe be ya nuwa kalapi. ");
INSERT INTO bxh_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","Guyau, peꞌi yo mwahuli fuyo ya leyama, Dodoga ya toledi boꞌusa yai yo ya famwahuli fuyoꞌidi. ");
INSERT INTO bxh_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","Haisa Guyau ya fagogo gesagesadi na haisa ya fagogodi; haisa ya tole lidilidiyedi, na haisa ya tole hitinidi. ");
INSERT INTO bxh_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","Tau gogo gesagesa ya faꞌobiyo fuyoꞌidi afusa yai na tau kuꞌu mate afusa yai ya lau hitinidi. Be haba baꞌisa lalaꞌi nanatudi, ma afa haidadi sa taꞌai gogo. Na nuꞌudi yai haba dodoga sa faꞌatitiyedi. Tanoꞌubu mahudoꞌina mate Guyau enehena, yo ginauli mahudoꞌina edi aba ota yai ya toledi. ");
INSERT INTO bxh_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","Dodoga loholoho ya ita watanidi, na tau laulau heyaya haba sa tauyamuhi ai kamumu. In moho dodoga adiꞌadidilidi edi adidili ibege i ota esegahi. ");
INSERT INTO bxh_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","Safalumadi Guyau sa fawaiyunu, In haba ya faheyayadi doha gulewa sa dem golu. Ena manabala ataꞌatahina haba doha palele galewa yai. Guyau haba tanoꞌubu mahudoꞌina ya fakasa. Ena kin haba ya faꞌadidili yo ena fafasinabo ni, haba ya fanuwa adidili. ");
INSERT INTO bxh_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Habahim, Elikana yo ena dodoga sa lau edi nuꞌu Lama yai, na gwama Samuwela sa lau afulen be Guyau ena ya paisowa. Ana tanuwaga mate, Tau antalasam Eli. ");
INSERT INTO bxh_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Samuwela mate Guyau ena ya paisowa na ana tanuwaga Eli. Fuyandi yai mate Guyau hige fuya ouꞌouli i libalibalau dodoga lebedi yo tautau hige ti tautaumahata dodoga ai lisidi. ");
INSERT INTO bxh_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Eli matana haꞌa sa heyaya wananaha. Begana haba sa tou. Iꞌipa hesa ya enoꞌeno ena bili yai. ");
INSERT INTO bxh_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Samuwela mate ya enoꞌeno Guyau ena luma yai, Yaubada ena Laugagayo Aba Husanina bilina sadaina yai. Hola ma iꞌipana na Yaubada ena luma lampana hola ma malamalana. ");
INSERT INTO bxh_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","Habahim, Guyau Samuwela ya yogai. Iyen, Samuwela! Alinana Samuwela ya bui iyen, Ho? Yau ite. ");
INSERT INTO bxh_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Ya obiyo be ya tafo lau Eli lisina, iyen, Wa yogaigu. Yau ite. Na Eli iyen, Yau hige ya yogaim; u fuyo u eno. Be Samuwela ya fuyo ya eno. ");
INSERT INTO bxh_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","Guyau ya yoga fuyo, iyen, Samuwela! Samuwela ya obiyo be ya lau Eli lebena, iyen, Wa yogaigu. Yau ite. Eli ya faliba iyen, Natugu, yau hige ya yogaim; u fuyo u eno. ");
INSERT INTO bxh_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Samuwela hola hige Guyau i sibai paꞌana beyabeyana hola hige Guyau i libalau lisina. Logena, Guyau alinana hige i atahi lobahi. ");
INSERT INTO bxh_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Guyau Samuwela ya yogai fafaihonana be Samuwela ya obiyo ya lau Eli lebena, na iyen, Wa yogaigu be E laoma. Habahim, Eli ya nuwatuhu lobahi mate Guyau gwama kiukiu ni, ya yogayogai. ");
INSERT INTO bxh_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Yo fede ya libalau Samuwela lisina, iyen, U lau u eno na yena ya yoga fuyoim uwen, “Guyau, u liba. Yau, em tau paisowa, E ataꞌatahi.” Habahim, Samuwela ya lau be ena aba eno yai ya eno-fuyo. ");
INSERT INTO bxh_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Guyau ya laoma ya obiyo amainiya na Samuwela ya yogai doha bwaꞌibwaꞌina ena yogayogaina, iyen, Samuwela! Samuwela! Yo fede Samuwela iyen, U liba! Yau em tau paisowa, E ataꞌatahi. ");
INSERT INTO bxh_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Habahim, Guyau iyen, Isalaela dodogadi ai ganahewadi haba ginauli heyaheyayana E ginauli. Yena sa atahiyen haba aluwadi sa potifahi, be ibege somo hesa ti ginauli. ");
INSERT INTO bxh_vpl VALUES ("S13_12","010_3_12","1SA","3","12","13","Eli afa nanatuna tatau hesagu sa kai wegowegogoꞌen yo laulau heyaheyayadi sa ginaulidi be egu laugagayo hige ti famuli watandi. In moho Eli hige i falibadi ti fatautau. Be, ai maihalana ni haba Eli maꞌana boga E faꞌankamkamnadi, doha ginauli mahudoꞌina haꞌa E falibadi yo laulauwewena haba E faꞌankamkamnadi hige anadan. ");
INSERT INTO bxh_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Logena, E angwala Eli maꞌana boga lebedi yai yawa, “Emi ainauya e emi antalasam ami ledima lebegu yai, mate hige gonowana emi heyaya ni ya nuwatuhu afuledi.” ");
INSERT INTO bxh_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Samuwela liba ni ya atahi mulina yai ya lau ya eno ee–, hwalahwalala habahim ya obiyo be Guyau ena luma edaꞌedadi ya soꞌedi. Tautau ya ita ni, mate ya ꞌwasabu be Eli hige ena i liba, ");
INSERT INTO bxh_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","in moho Eli ya yogai be iyen, Natugu, Samuwela! Alinana Samuwela ya bui iyen, Ho, Yau ite! ");
INSERT INTO bxh_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Eli ya fatiꞌo iyen, Guyau somo ya falibam? U libaen. Tabu u simo. Yena hige u falibagu Yaubada haba ya faꞌankamkamnam. ");
INSERT INTO bxh_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Yo fede, Samuwela ginauli mahudoꞌina ena ya liba. Hige laꞌi i simo. Habahim Eli iyen, In Guyau. Somo ya nuwatuhui ya dudulai mate i ginauli. ");
INSERT INTO bxh_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Samuwela ya laꞌi mate Guyau maꞌena, be somo mahudoꞌina Samuwela ya libalibaen mate Guyau ya fawananahadi. ");
INSERT INTO bxh_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Dan nuꞌuna sigasigana yai ya hasai ee–, Belesiba nuꞌuna sigasigana. Isalaela dodogadi mahudoꞌidi sa sibai mate Samuwela, Guyau ena peloweta. ");
INSERT INTO bxh_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Silo nuꞌuna yai, Guyau ya taumahata be ya libaliba famahata Samuwela lebena yai. Na Samuwela ena liba ya laoma Isalaela mahudoꞌidi lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("S18_1","010_8_1","1SA","8","1","2","Samuwela nanatuna tatau luwaga. Bwaꞌibwaꞌina hesana Diyoweli na tau mulita hesana Abaidiya. Ya tautaulaꞌi be nanatuna ya fasinabodi bena Isalaela edi tau fafadudulai Belesiba nuꞌuna yai. ");
INSERT INTO bxh_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Tamadi ena laulau sa dudulai. In moho nanatuna edi laulau hige ti loholoho. Nuwadi moni sa andi, yo dodoga sa bwala fahidi moni yai. Be logena, fakasa dudulaidi hige ti ginaginaulidi. ");
INSERT INTO bxh_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Yo fede Isalaela babadadi sa faꞌoigogo esegahidi be sa laoma Samuwela lisina, Lama nuꞌuna yai. ");
INSERT INTO bxh_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","Sa faliba tiyen, Wa tautaulaꞌi yo nanatum em laulau hige ti lau watanidi; aho te kin u fasinabo. Haba ya foyahida, be ita haba doha nuꞌu hahaisa dodogadi, maꞌedi kin. ");
INSERT INTO bxh_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Fuyana Kin sa anꞌetai mate, Samuwela nuwana yai hige i dudulai be ya lauꞌuꞌula lau Guyau lisina. ");
INSERT INTO bxh_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Guyau iyen, Somo mahudoꞌina sa falibam bena wa ginauli, u lau watan. Hige um ti ꞌwaiyoꞌoꞌem. Na yau sa ꞌwaiyoꞌoꞌegu, tabu ya Kin boda. ");
INSERT INTO bxh_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Fuyanna Idipi yai E hasaidima mate fuya ouꞌouli sa nuwanuwa afulegu na yaubada hahaisa sa fafamuli watanidi. Na aho te hinaga doha sa ginauli lebem yai. ");
INSERT INTO bxh_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","In moho, somo sa falibam bena wa ginauli, u lau watan. Sidohana haba kin ena abiꞌabiyedi mate, u faliba fanuwatagudi. ");
INSERT INTO bxh_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Yo fede, Guyau ena liba mahudoꞌina, safalumadi sa anꞌeta bena edi kin mate Samuwela edi ya liba. ");
INSERT INTO bxh_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","Iyen, Kin, yena ya tanuwaga na ya eli dudulimiu, haba doha ite ya ginauli: Nanatumiu tatau haba ya lawedi ena tau hiyala. Haba ena saliyoti ya fapaisowadi, yo ena hosi sa awaidi na haisa haba sa tafolau kin ena saliyoti ai nuwanuwadi. ");
INSERT INTO bxh_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Haisa haba ya abidi ena tau foyafoya be pele esega - esega ganahewana yai tau hiyala ouꞌoulidi 1,000 sa foyahidi na haisa haba pele hesa - hesa ganahewana yai tau hiyala ouꞌoulidi 50 sa foyahidi. Haisa haba ena ai gabu sa fapulu yo haisa anaho fuyana yai haba sa lau kin ana kalahe sa lau gabui. Na haisa hola haba hiyala ginaulidi sa lau ginauli, yo hosi edi saliyoti wawalidi sa lau ginauli. ");
INSERT INTO bxh_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Baꞌisa hesa ya famala edi bada laꞌilaꞌi hesana Kisi, na tamana mate Abiyela na Abiyela tamana, Selolo. Selolo tamana mate Bekolati na Bekolati tamana, Afiya na Afiya ena sulu Beniyamin. ");
INSERT INTO bxh_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Kisi natuna Saulo, mate hewalina ya loholoho wananaha, habahim Isalaela tataudi haisa. Kwaluna ya lofa wananahana habahim iti. ");
INSERT INTO bxh_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Fuya hesa mate Kisi ena donki sa asina be ya libalau natuna Saulo lisina iyebom, Tau lau fayofayo hesa maꞌem au lau, be donki au yoꞌoidi. ");
INSERT INTO bxh_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Lahaina hola, Saulo maꞌena tau lau fayofayo gwamana hola hige ti laoma lebena na Guyau ya libalau Samuwela lisina iyebom, ");
INSERT INTO bxh_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","Bobon maihala doha ite taumoho hesa, in Beniyamin Nuꞌuna dogana, haba E fatamaliyawa lebem. Ai boluboluna oliwe uluna gilisina u fagoi, haba sa ita lobahi mate yau E fasinabo bena egu dodoga Isalaela ya foyahidi. Filisitani dodogadi lebedi yai haba E fofo fahidi. Egu dodoga edi kamkamna haꞌa E ita yo edi tan haꞌa E atahi. ");
INSERT INTO bxh_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Habahim Samuwela oliwe uluna gilisina aba husanina ya abi be ya hin Saulo boluboluna yai. Ya falafu na iyen, Guyau ya fasinabom bena ena dodoga wa foyahidi. Logena, egu abiꞌabim doha ite. ");
INSERT INTO bxh_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","Yena aho wa lau afulegu, haba tatau luwaga Leisulu boꞌusana Selesaha yai, Beniyamin nuꞌuna sigasigana sadaina yai, wa lobahidi. Haba sa falibam tiyen, Donki ami yoꞌoyoꞌoidi haꞌa sa lobahidi be tamam, hige donki i modeꞌedi. In moho, aho te ya libaliba, hola iyen, “Somo haba E ginauli be natugu E lobahi?” ");
INSERT INTO bxh_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","Samuwela ya libalau Saulo lisina, iyebom, Mulina yai haba wa lau Yaubada ena Uduhuli, Gibeya nuꞌuna yai. Filisitani tau hiyala edi aba miya mate uduhuli ni mulina yai. Taon ni, wa hanahanaui mate peloweta pelena aba fadebasae nuꞌuna yai ni sa lidilidima, haba wa failobahidi. Haba hapi yo ginauli hudoꞌi doha gita yo tambalin sa aiheyaidi yo figo sa yufidi. Haba sa leꞌi yo Yaubada ena liba sa fafatala yogaꞌen. ");
INSERT INTO bxh_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","Maihalana yai ni, Guyau Yaluwana ma gigibwalina haba ya luhufim be ma afa haidam haba ena liba ami fatala yogayogaꞌen; na Guyau haba nuwam ya fafalifalihu fuyoi. ");
INSERT INTO bxh_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Yena fafaꞌilala te sa tubu, mulina yai somo wa ita ya loholoho, mate u ginauli, paꞌana Yaubada maꞌem. ");
INSERT INTO bxh_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","U bwaꞌi, u lau Giligala taonna, haba ainiya te failobahi be haba antalasam E gabudi yo nuwa esega antalasamdi E ginaulidi Guyau ai lisina. Ainiya u bagibagi lahai faligigi luwaga ee–, E mahanowa. Habahim E falibam somo wa ginauli. ");
INSERT INTO bxh_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Saulo ya timuli bui bena haba Samuwela ya lau afulen, na yo fede Yaubada, Saulo nuwana ya fafalifalihu. Lahaina yai, ginauli mahudoꞌina Samuwela, Saulo ena ya liba mate, sa fawananaha. ");
INSERT INTO bxh_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","Saulo yo ena tau lau fayofayo sa mahano lau Yaubada ena Uduhuli, Gibeya yai mate peloweta pelena sa laoma Saulo sa failobahidi na sa lau gogo sa lau. Feula, Yaubada Yaluwana ma gigibwalina Saulo ya luhufi be hinaga ya fatubu Yaubada ena liba ya lau yogaꞌen. ");
INSERT INTO bxh_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Safalumadi Saulo sa sibai mate sa ita ya libaliba peloweta be sa noꞌo tiyen, Kisi natuna ya somo? Wananaha in peloweta? ");
INSERT INTO bxh_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","Taumoho hudoꞌi amainiya ya miyamiya alinadi ya bui iyebom, Tau foyahidi sai? Somo ya tubu Saulo lebena yai sa ita be sa noꞌo, na ya famala edi libaliba, be haba Saulo fatiꞌona sa fafalau boda tiyebom, Saulo, wananaha peloweta? ");
INSERT INTO bxh_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","Saulo ya liba peloweta maꞌuda, mate ya hasai aba fadebasae nuꞌuna. ");
INSERT INTO bxh_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","Muliyai, Saulo madiyana ya fatiꞌo lau Saulo yo ena tau lau fayofayo lisidi iyebom, Somo yai ami laoma? Saulo iyebom, Donki ꞌe laulau yoꞌoidi be ꞌe yoꞌo asaha, yo fede ꞌe lau Samuwela lebena. ");
INSERT INTO bxh_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","Na madiyana iyebom, Samuwela somo ya falibamiu. Au falibagu. ");
INSERT INTO bxh_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Saulo alinana ya bui iye, Ya falibamai mate donki haꞌa sa lobahidi. Samuwela ya libalau Saulo lisina mate in haba ya famala Isalaela edi kin, in moho Saulo, madiyana hige ena i liba. ");
INSERT INTO bxh_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Habahim, Samuwela Isalaela dodogadi mahudoꞌidi ya yoga gogondima Guyau matana yai Misipa taonna yai na ya libalau lisidi iyebom, ");
INSERT INTO bxh_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","Ita Isalaela eda Yaubada yo eda Guyau alinana doha ite, “Isalaela dodogadi, Idipi yai Yau E fofofahidima. Idipi edi gigibwali yai yo nuꞌu mahudoꞌidi sa fafaꞌankamkamnadi, lisidi yai E fofofahidi.” ");
INSERT INTO bxh_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Yau emi Yaubada. Pilipili ouꞌouli lisidi yai E fofofahimiu na aho te, ami ꞌwaiyoꞌoꞌegu, na ami anꞌetaigu bena emi kin E felemiu. Haꞌai! Beti, emi sulu yo ami boga hesa - hesa yai au faꞌoigogoma Guyau ai matana. ");
INSERT INTO bxh_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Habahim, Samuwela sulu hesa - hesa ya falibadi sa laoma na sulu Beniyamin ya fasinabo. ");
INSERT INTO bxh_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Yo fede, Samuwela sulu Beniyamin ya falibadi sa laoma nuwanuwana yai sa obiyo, na boga Matili ya fasinabo. Be boga yai te, Kisi natuna Saulo ya fasinabo. Na fuyanna sa yoꞌoi mate in hige amainiya. ");
INSERT INTO bxh_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Be Guyau sa fatiꞌoi, tiyebom, Dogana ya laoma, e higeꞌe? Guyau alinadi ya bui iyebom, Ginauli ganahewadi yai ya alasimo. ");
INSERT INTO bxh_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Yo fede, sa lautafo be sa lau sa leyama, be sa faꞌobiyo dodoga matadi yai. Kwaluna ya lofa wananaha, hige doha iti. ");
INSERT INTO bxh_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Samuwela dodoga ya falibadi iyebom, Guyau taumoho ya fasinabo, logena ma! Dodoga mahudoꞌidi ganahewadi yai hige sai hesa doha in. Habahim, dodoga mahudoꞌidi sa yoga laꞌilaꞌi tiyen, Kin haba ya miya boliman lofalofa! ");
INSERT INTO bxh_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","Muli yai, Samuwela dodoga ya falibadi iyen, Au laoma! Te lau Giligala, be ainiya eda kin haba te fawananaha bodai. ");
INSERT INTO bxh_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","Yo fede, dodogadi mahudoꞌidi sa lau Giligala be amainiya Guyau sa fadebasae yo Saulo sa fawananaha kin. Amainiya hinaga miya daumwali antalasamdi sa lau ginauli Guyau lebena yai be mahudoꞌidi hinaga sa anꞌangogo. Isalaela dodoga mahudoꞌidi maꞌedi Saulo nuwadi sa amna wananaha. ");
INSERT INTO bxh_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Samuwela ya libalau Saulo lebena iyebom, Wa yauyaule! Guyau, emi Yaubada hige ena laugagayo u lau watan. Ibe ena liba wa lau watan, haba um yo am hiti mulita ya biya afulemiu be Isalaela ami foyahidi be hige anadan. ");
INSERT INTO bxh_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","In moho, aho te, na ya lawen, um ibege u foyahidi. Taumoho hesa inonona loholohona, Guyau haꞌa ya lobahi bena ya lau fadamahim be ena dodoga haba ya foyahidi. Paꞌana Guyau ena laugagayo hige u lau watan. ");
INSERT INTO bxh_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Muli yai Samuwela ya libalau Saulo lisina, iyebom, Guyau ya duigu be haꞌa E famaꞌim, be haꞌa wa famala kin, yo Isalaela dodogadi wa foyafoyahidi. Na aho te, Guyau ena liba u atahi! ");
INSERT INTO bxh_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Guyau Tau Gigibwali iyen, “Fuyanna Isalaela dodogadi Idipi yai sa laolaoma mate Amaleki dodogadi afa wahawahadi sa nahaidi be sa eli bulubuluhidi. Logena aho te, Amaleki haba E faꞌankamkamnadi. ");
INSERT INTO bxh_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Au lau Amaleki dodogadi au duhu mahanoꞌidi be edi ginauli mahudoꞌidi au faheyayaidi. Tabu au nuwatohatohaedi. Tatau, wawahin, wawaya nomnomdi yo lalaꞌi, edi bulumakau, sipi, kamela, yo donki mahudoꞌidi au wunuidi. ");
INSERT INTO bxh_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Yo fede Saulo liba ya fatamali be ena tau hiyala sa laoma. Isalaela suludi hahaisa ganahewadi yai 200,000 sa lau fote sa laoma yo hinaga Diuda suluna ganahewana yai 10,000 sa laoma. Sa faꞌoigogo esega Telaim taonna yai. ");
INSERT INTO bxh_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Habahim Saulo ena tau hiyala ya foyahidi sa lau Amaleki dodogadi sa weꞌa dudu lidi. Hawila yai sa fatubu ee–, Sula taonna yai, Idipi nuꞌuna tefa saisaina yai. ");
INSERT INTO bxh_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Amaleki edi kin, Agagi ya tohai, na ena dodoga mahudoꞌidi ya wunu ofinidi. ");
INSERT INTO bxh_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","In moho Saulo maꞌena tau hiyala dodogadi, hige Agagi ti wunui. Ena sipi yo bulumakau lalaꞌi loholohodi yo gubugubu fwaudi, hinaga hige ti wunuidi yo ginauli loloho mahudoꞌidi hinaga hige ti faheyayaidi. In moho yosiyosi yo ginauli mahudoꞌidi megomegodi yo hige ti fanufanuhadi mate sa faheyaya faꞌofinidi. ");
INSERT INTO bxh_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Guyau ya libalau Samuwela lisina iyebom, ");
INSERT INTO bxh_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","Nuwagu ya heyaya, paꞌana Saulo E fasinabo kin. In moho, ya miya mulimuliyegu yo egu laugagayo hige i lau watanidi. Fuyanna Guyau ena liba Samuwela ya atahiyen, mate Saulo ya manabalaꞌen, be iꞌipa lofalofa Guyau ya anꞌanꞌetai. ");
INSERT INTO bxh_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Bobonna ma hwalahwalalana Samuwela ya aulaha ya lau Saulo ya yoꞌoi. In moho, ena sa liba mate, haꞌa ya lau Kameli nuꞌuna yai. Amainiya Saulo ena fafaꞌilala umeꞌehuna ya bono be haba dodoga sa faꞌatitiyen. Habahim Saulo ya aulaha boda, be ya lidi Giligala. ");
INSERT INTO bxh_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Fuyanna Samuwela yo Saulo sa failobahi mate Saulo ya libalau lisina iyebom, Samuwela, Guyau ena faloholoho haba ai lisim. Yau ena laugagayo E lau watan. ");
INSERT INTO bxh_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Samuwela alinana ya bui iyebom, Ibe yena doha, paꞌana somo be sipi nenelidi yo bulumakau hwadududi E atahi? ");
INSERT INTO bxh_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Saulo, alinana ya bui iyebom, Yosiyosi te, tau hiyala, Amaleki dodogadi lebedi yai sa abidima. Sipi yo bulumakau mahudoꞌidi haꞌa sa wunuidi. Na loholohodi moho sa tole hudoꞌiyedi be haba Guyau, um em Yaubada sa felen ya famala edi antalasam. ");
INSERT INTO bxh_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Samuwela ya libalau Saulo lisina iyebom, U fatautau! Iꞌipa yai Guyau somo ya falibagu hola ya falibam. Saulo iyebom, U falibagu. ");
INSERT INTO bxh_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Samuwela ena liba ya bui iyen, Beyabeyana em nuwanuwatuhu mate bena um hige doga fafahesana, na aho te, um Isalaela tau foyahidi. Guyau ya fasinabom be um Isalaela edi kin. ");
INSERT INTO bxh_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Guyau ya fatamalim iyen, “Em tau hiyala maꞌem au lau Amaleki dodogadi heyaya sa laulau ginauli, au faheyayadi. Au hiyalaidi ee–, mahudoꞌidi au wunu faꞌofidi.” ");
INSERT INTO bxh_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","Ya falibam tabu gogo laꞌi u abi. In moho edi gogo wa faiꞌabiꞌabinidi, be heyaya wa ginauli Guyau matana yai, paꞌana hige ena laugagayo u lau watan. ");
INSERT INTO bxh_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Saulo iyen, Na Guyau doha ena liba E lau watan. Ya falibagu E lau Amaleki dodogadi mahudoꞌidi E wunu faꞌofidi, na Kin Agagi E fafuyoyama. ");
INSERT INTO bxh_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","In moho tau hiyala sipi yo bulumakau hahaisa loholohodi somo - somo sa abidi mate hige ti wunuidi na sa ledima Giligala, be antalasam haba sa ginauli Guyau em Yaubada lisina yai. ");
INSERT INTO bxh_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Habahim Samuwela iyen, Yena Guyau ena liba te lau watan, haba nuwana ya amna wananaha, habahim, yosiyosi ami gabudi be antalasam ami felen. Antalasam mate abiꞌabi loholohona, in moho, Guyau ena liba laulau watanina ya hasai wananaha. Sipi tamoꞌana fisihona tefadi Guyau felenina mate abiꞌabi loholohona, in moho, ena liba atahi watanina ya hasai wananaha. ");
INSERT INTO bxh_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Yena dodoga sa timuli bui be Guyau sa fawaiyunu, itaꞌitana doha dodoga nesu itaꞌita sa fapaisowadi. Yena sa nuwa saesae, itaꞌitana doha oitau ti fadebasae. Paꞌana Guyau ena laugagayo wa ꞌwaiyoꞌoꞌen. Logena, Um kin, ya ꞌwaiyoꞌoꞌem hinaga. ");
INSERT INTO bxh_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Samuwela ya timuli bui bena ya aulaha ya lau na Saulo ya abilau ana luhuluhu duduna yai be ya solu gigi. ");
INSERT INTO bxh_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Samuwela ya faliba iyen, Aho te, Guyau, Isalaela em foyafoya ya kamfahi um lisim yai, na falem tau miya hesa haba ya felen, sai in ya loholoho wananaha, habahim um. ");
INSERT INTO bxh_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Yaubada, Isalaela ena namanamali hige i bwalabwala e ena nuwanuwatuhu i bui, paꞌana in hige tau wananaha be haba ena nuwanuwatuhu i bui. ");
INSERT INTO bxh_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Habahim, Samuwela ya fuyo Lama, na Saulo ya fuyo ena luma Gibeya yai. ");
INSERT INTO bxh_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Na Samuwela hige i lau Saulo i ita fuyoi ee–, ya peꞌi. In moho, halana ya tan eloꞌelolosi. Guyau hinaga nuwana ya heyaya fuyana Saulo ya fasinabo Isalaela edi kin. ");
INSERT INTO bxh_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Guyau ya libalau Samuwela lisina iyen, Saulo wa tanisi, haga i lofa! Ena tanuwaga Isalaela yai, mate E ꞌwaiyoꞌo. Oliwe uluna gilisina em sipi donana u famohafu na u lau Betelehem. Amainiya taumoho hudoꞌi hesana Desi nanatuna ganahewadi yai mate hesa haꞌa E fasinabo kin, Saulo falau damahina. ");
INSERT INTO bxh_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Samuwela ya fatiꞌo iyen, Haba sidohana egu laulau? Saulo liba te ya atahiyen haba ya wunuigu! Guyau iyen, Bulumakau tinabawa gubugubufwauna u abi na uwen, “E laoma antalasam E ginauli Guyau ai lisina.” ");
INSERT INTO bxh_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Guyau somo ya libaen, Samuwela ya lau watan. Fuyanna ya mahano Betelehem yai mate taon babadadi sa failobahi, yo fede ꞌwasabu ya kam fafatabubudi, na sa fatiꞌo, tiyen, Ma nuwa loholohom wa laoma? ");
INSERT INTO bxh_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Samuwela alinadi ya bui iyen, Ii–, ma nuwa loholohogu E laoma bena antalasam E ginauli Guyau ai lisina. Au fatabu fuyoimiu haba te lau antalasam aba gabuna yai. Habahim, Samuwela, Desi ma nanatuna ya fatabuwedi be ya yogaidi sa lau antalasam ganahewana yai. ");
INSERT INTO bxh_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Fuyanna sa mahano, Samuwela ya itaꞌitalau be Desi natuna tau tuwaha Eliyabi ya ita be nuwana yai, iyen, Taumoho ya obiꞌobiyo Guyau matana yai, mate logena, Guyau ya fasinabo kin. ");
INSERT INTO bxh_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","In moho, Guyau ya libalau Samuwela lisina iyen, E ꞌwaiyoꞌoꞌen be tabu hewalina yo kwaluna au nuwatuhui. Ginauli somo Guyau ya itaꞌitai mate dodoga hige ti ita. Doga, falena doga moho tauna ganamulina ya itaꞌitai, na Guyau doga nuwana ganahewana ya itaꞌitai. ");
INSERT INTO bxh_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Desi nanatuna tatau faligigi luwaga sa lau Samuwela lebena. In moho, Samuwela ya libalau Desi lisina iyen, Higeꞌe! Guyau hige iti i fasinabodi. ");
INSERT INTO bxh_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Yo fede ya fatiꞌo lau Desi lisina, iyen, Nanatum tatau mahudoꞌidi logedi itete? Desi iyen, Higeꞌe. Tau mulita wananaha hola hige i laoma. In, sipi ya itaꞌita watandi. Na Samuwela iyen, Ana liba au fatamali be i laoma; ibege hola ta anꞌangogo ana siga ee–, ya mahanoma. ");
INSERT INTO bxh_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Yo fede, Desi, doga hesa ya fatamali be Deiwidi ya foyahiyama. In mate nenena yo hewalina sa loholoho wananaha. Fuyanna Deiwidi ya mahano, Guyau ya libalau Samuwela lisina iyen, In logena! U obiyo be oliwe uluna gilisina u hin ai kuluna. ");
INSERT INTO bxh_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Yo fede Samuwela oliwe uluna gilisina sipi donana yai ya fagoi Deiwidi kuluna yai, afa haidana matadi yai. Maꞌesega na, Guyau Yaluwana ya talu Deiwidi hewana yai be–, ma gigibwalina be ya ota esegahi. Habahim Samuwela ya fuyo Lama nuꞌuna. ");
INSERT INTO bxh_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Yaubada Yaluwana Saulo ya lau afulen na Guyau yaluwa heyaheyayana ya fatamali lawen Saulo lisina be ya fafaꞌwasabu. ");
INSERT INTO bxh_vpl VALUES ("S118_5","010_18_5","1SA","18","5","6","Saulo hiyala haisa ganahewadi yai mate Deiwidi ya fafatamali, ya lau ya lulu be ana waiyunu ya lei hafihafitidi. Yo fede Saulo ya tole hitiꞌi be tau hiyala edi tau lau kulukulu. Na Isalaela dodoga mahudoꞌidi yo hiyala tau foyafoyahidi haisa hinaga nuwadi sa amna. Tau hiyala edi fuya fuyoma fuyana Deiwidi Golaiyeti ya wunui mate Isalaela wawahindi edi taon mahudoꞌidi sa laoma be Kin Saulo sa failobahi. Wana fanuwa kwadekwadedi sa wanaidi, tambalin sa oidi yo ginauli hesa doha gita sa aiheyaidi ma sagasagadi. ");
INSERT INTO bxh_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Wawahin wana sa wanawanai yo sa leꞌileꞌi. Tiyebom, Saulo waiyunu 1,000 ya wunuidi; In moho, Deiwidi mate 10,000! ");
INSERT INTO bxh_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Wana ni, Saulo ya atahi lobahi mate hige i fanuha yo fede manana ya bala. Nuwana yai iyen, Wawahin, Deiwidi sa faꞌanhaga, tiyen, in 10,000 ya wunuidi na yau agu haga 1,000 moho. Nuwana Deiwidi ti fanuha, bena haba ai muli ti faꞌobiyo edi kin! ");
INSERT INTO bxh_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Fuyanna yai ni ya lawen mate Saulo, Deiwidi ya nuwa elaꞌelaꞌen. ");
INSERT INTO bxh_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","Deiwidi ya lau tau antalasam, Ahimeleki lisina. Ahimeleki ꞌwasabu ya kamfafatabubu edi failobahi yai na ya fatiꞌo lau Deiwidi lisina iyen, Hige sai hesa maꞌem? Paꞌana somo be iyabom wa laoma? ");
INSERT INTO bxh_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","Deiwidi, ya libalau Ahimeleki lisina, iyen, Kin ya falibagu bena ginauli hesa E ginauli. In moho ya falibagu tabu sai laꞌi ena u liba. Yau egu tau hiyala haꞌa E falibadi be ai nuꞌu hesa haba ꞌe failobahi. ");
INSERT INTO bxh_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Kalahe somo lebem yai? Fwalawa faligigi e somo lebem yai u felegu! ");
INSERT INTO bxh_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Tau antalasam Deiwidi alinana ya bui iyen, Yau hige fwalawa gaibu lebegu yai. In moho, fwalawa fafatabuna haisa neꞌi. Gonowana ami, ami an yena hige wawahin ma afa haidamiu au eno, lahai fisa. ");
INSERT INTO bxh_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","Deiwidi iyen, Wananaha, wawahin hige ma afa haidamai ai eno. Yena ꞌe lau ꞌe hiyala, mate hewahewali sa fatabu fuyoꞌidi. Aho te ꞌe ita wata komakomani fuyoimai be haba paisowa te gonowamai ꞌe ginauli! ");
INSERT INTO bxh_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Amainiya hige fwalawa hesa, be tau antalasam, fwalawa fafatabuna Guyau matana yai ya toletolei, ya abi be Deiwidi ya felen. Lahaina yai fwalawa ni, mate ya beyabeya be ya abifahi na fwaufwauna ya tole. ");
INSERT INTO bxh_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","Fuyanna yai mate Filisitani, Isalaela sa hiyalaidi Giliboa Tuꞌana yai. Isalaela tau hiyala sa gelagela na Filisitani sa weꞌa watanidi be boludi sa wunuidi. ");
INSERT INTO bxh_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","Filisitani, Saulo ma nanatuna sa falakodi be nanatuna: Diyonatan, Abinadabi yo Malikisua sa wunuidi. ");
INSERT INTO bxh_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Saulo sa gana fataꞌiꞌili be hiyala mate ya heyaya wananaha. Ana waiyunu kukupidu yai sa gwali be omatana ya kamkamna heyaya. ");
INSERT INTO bxh_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","Saulo ena heti yo mada tau baheina ya faliba iyen, Em baineti u solu fahi be u gwali funuhigu, doꞌata Filisitani dodogadi sa lau faliuhwaꞌegu yo sa gwali funuhigu. In moho, ena heti tau baheina ya ꞌwasabu be hige i wunui, yo fede, Saulo ena baineti ya abi be ibona ya siho fuyoi. ");
INSERT INTO bxh_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Heti tau baheina Saulo ya ita ya peꞌi, yo fede in hinaga ena baineti yai ya siho fuyoi be hinaga ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","Isalaela suludi mahudoꞌidi sa laoma Deiwidi lebena, Hebelon nuꞌuna yai na tiyen, Ai afa efam. ");
INSERT INTO bxh_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","Beyabeyana, Saulo hola ma kinna um logem Isalaela eda tau hiyala wa foyahidi wa lau wa hiyahiyala be Guyau ya falibam iyen, “Um haba egu dodoga Isalaela wa ita watanidi doha sipi tau itaꞌitawata sipi ya ita watanidi yo haba wa famala edi baꞌisa.” ");
INSERT INTO bxh_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","Isalaela babadadi mahudoꞌidi sa laoma Kin Deiwidi lebena Hebelon nuꞌuna yai be maꞌedi sa angwala Yaubada matana yai. Habahim, oliwe uluna gilisina sa fagoi kuluna yai bena sa fawananaha mate Deiwidi Isalaela edi Kin. ");
INSERT INTO bxh_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","Deiwidi ena bolima 30 mate ya famala kin na ya ita wata ee–, boliman 40. ");
INSERT INTO bxh_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","Waiyunu Deiwidi sa miya fataꞌiꞌili. In moho Guyau ya itaꞌita watan yo ya saguhi be ana waiyunu ya lei hafihafitidi. Mulina yai, ya miya daumwali ena luma loholohona yai. Lumana ni oyagi loholohona hesana sida, lisina yai sa ginauli. ");
INSERT INTO bxh_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","Mulina yai, ya libalau Peloweta Neitan lebena iyen, Yau amaiteꞌi luma loholohona sida yai sa ginauli amainiya E gogogo, na Yaubada ena Laugagayo Aba Husanina hola ya otaꞌota palai yai. ");
INSERT INTO bxh_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Neitan kin alinana ya bui iyen, Somo wa nuwatuhui u ginauli. Paꞌana Guyau maꞌem. ");
INSERT INTO bxh_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","In moho, iꞌipana yai Guyau ya libalau Neitan lisina iyen, ");
INSERT INTO bxh_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","U lau be egu tau paisowa Deiwidi, u faliba uwen, “Guyau ya liba doha ite: ‘Um hige, logem, bena egu luma u ginauli!” ");
INSERT INTO bxh_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","Guyau ya liba boda iyen, Aho ite, egu tau paisowa Deiwidi u faliba uwen, “Guyau Tau Gigibwali ya liba doha ite: E abifahim, sipi wa itaꞌita watanidi edi aba anꞌanban yai na, aho te, E abim be wa famala egu dodoga Isalaela tau foyafoyahidi. ");
INSERT INTO bxh_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","Em aba lau somo yai mate yau maꞌem. Na am waiyunu mahudoꞌidi matam yai haꞌa E lei hafihafitidi. Aho te hesam haba E falaꞌi, doha tatau fafahesadi tanoꞌubu yai te. ");
INSERT INTO bxh_vpl VALUES ("S27_10","011_7_10","2SA","7","10","11","Yau haba egu dodoga, Isalaela edi tanohi E feledi be ya famala edi nuꞌu, be ai lisina haba E famiya komakomanidi. Tau foyafoya egu fuya faꞌobiyodi yai mate nuꞌu hahaisa dodogadi heyaheyayadi Isalaela dodogadi sa tulutulufidi. Ibege ti ginauli fuyoi doha, yo ibege ami waiyunu ti guwe fuyoimiu, haba ami miya daumwali. “Guyau ya angwala lebem yai mate In iyabona haba ya fafaꞌobiyomiu kin, um yo laulauwewem. ");
INSERT INTO bxh_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Yena wa peꞌi be sa boꞌusaim wahawaham edi aba toledi yai, haba laulauwewem hesa E faꞌobiyo, ya lau fadamahim. In haba natum hesa na ena tanuwaga yai haba E faꞌadidili. ");
INSERT INTO bxh_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","In logena hesagu yai haba egu luma ya ginauli, yo haba E faꞌobiyo kin, hige anadan. ");
INSERT INTO bxh_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Yau haba tamana, na in haba natugu. Ibe heyaya ya ginauli haba ai mada E pidili doha tau tamatama natuna ya pidili. ");
INSERT INTO bxh_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Haꞌa Saulo lebena yai egu gadosisi E abifahi be kin yai E kamfahi na um E faꞌobiyom, wa lau fadamahi. In moho egu gadosisi lebena yai hige gonowana ya abifahi. ");
INSERT INTO bxh_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","Am boga haba ya tadada yo laulauwewem haba sa obiyo kin hige anadan.” ");
INSERT INTO bxh_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Guyau liba mahudoꞌina ya liba famahata Neitan lebena yai mate Deiwidi ena ya liba. ");
INSERT INTO bxh_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","Umaꞌuma fuyanna yai, kin edi fuya lau hiyala maihalana yai mate Deiwidi, Diyowabi maꞌena hiyala tau lau kulukuluwedi yo Isalaela edi tau hiyala mahudoꞌidi ya fatamalidi sa lau Amon dodogadi sa hiyalaidi. Sa lei hafihafitidi yo Laba taonna laꞌilaꞌi sa fasai bulubuluhidi. Fuyanna yai mate Deiwidi hige maꞌedi ti lau. Ya miya Yelusalem yai. ");
INSERT INTO bxh_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","Fuya hesa maimailafi wananaha yai, Deiwidi ena aba eno yai ya obiyo be ya leu ya sae ena luma hewana yai. Amainiya ya itaꞌita lau mate waihin hasalana loholohona ya sigusigu ya ita. ");
INSERT INTO bxh_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","Yo fede, Deiwidi doga hesa ya fatamali ya lau be ya fatiꞌo kadada. Taumoho ya fuyoma be iyen, Betesiba, Eliyam natuna, Hiti dogana Ulaiya lahuna. ");
INSERT INTO bxh_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","Habahim, Deiwidi liba ya fatamali bena sa foyahi lawen lisina. Ya laoma lebena be maꞌena sa eno bili. (Nawalahi asiyebona ya ofi, na tauna ya kaikaisu.) Habahim, ya fuyo ena luma. ");
INSERT INTO bxh_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","Waihin ya boga be liba ya fatamali lawen Deiwidi lisina iyen, Yau E boga. ");
INSERT INTO bxh_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","Yo fede, Deiwidi liba ya fatamali lawen Diyowabi lebena iyen, Hiti dogana, Ulaiya, u faliba i laoma lebegu. ");
INSERT INTO bxh_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","Fuyanna Ulaiya ya mahano ya fatiꞌo iyen, Diyowabi yo tau hiyala sa loholoho? Na hiyala sidosidohana? ");
INSERT INTO bxh_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","Habahim, Deiwidi ya libalau Ulaiya lisina iyen, U lidi em luma be ahem u kaisu, na u anyawasi. Yo fede, Ulaiya wa, Deiwidi ena luma loholohona ya lau afulen. Ya lau na mulina yai kin ena ainauya ya fatamali lawen Ulaiya ena luma. ");
INSERT INTO bxh_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","In moho, Ulaiya hige i lau ena luma, na kin ena luma aba luhuluhu launa yai ya eno ma afa haidana kin ena tau paisowa. ");
INSERT INTO bxh_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","Deiwidi ena sa liba mate Ulaiya hige i lau ena luma be ya fatiꞌoi iyen, Edaꞌeda lofalofa yai wa laoma? Paꞌana somo hige u lau em luma? ");
INSERT INTO bxh_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","Ulaiya ya libalau Deiwidi lebena iyen, Laugagayo aba husanina ya otaꞌota palai yai, na Isalaela yo Diuda tau hiyaladi mate palaidi aba pei yai hinaga sa miyamiya. Egu hiyala tau lau kulukuluwena, Diyowabi maꞌena em tau hiyala mate edi palai sa peidi Laba taonna mulimulina yai. Logena, hige gonowana ya lau egu luma be ya anꞌan, ya nom yo ma lahugu ai eno. Yau ibege ya ginauli doha, higeꞌe wananaha! ");
INSERT INTO bxh_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","Habahim, Deiwidi ya libalau Ulaiya lebena iyen, Aho te, aiteꞌi u miya; bobon haba E fatamali fuyoim. Yo fede, lahaina yai ni Ulaiya ya miya Yelusalem yai. ");
INSERT INTO bxh_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","Deiwidi mate, Ulaiya ya anꞌetai be sa kalahe gogo na ya fanom yauyaule. In moho, iꞌipana mate Ulaiya hige i lau ena luma Ya lau Kin ena tau paisowa pwaludi yai be ena leiyafa yai ya eno. ");
INSERT INTO bxh_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","Hwalahwalalana, Deiwidi wasa ya atahi mate iꞌipa yai, Ulaiya hige i fuyo ena luma, yo fede, leta ya uli, Diyowabi enehena, be Ulaiya ya lawen ya felen. ");
INSERT INTO bxh_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","Wasa ni ganahewana yai ya uli iyen, Diyowabi, Hiyala somo yai ya alaꞌala wananaha mate Ulaiya u fatamali bwaꞌiyen be tau hiyala ai nuwanuwadi. Habahim, tau hiyala ma afa haidam au muli suwasuwa be haba ami waiyunu iyabona sa tala funuhi. ");
INSERT INTO bxh_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","Diyowabi maꞌena tau hiyala Laba taonna sa fafataꞌiꞌili be somo yai adi waiyunu edi tau hiyala adiꞌadidilidi edi aba naha mate Ulaiya ya fatamali lawen amaniya. ");
INSERT INTO bxh_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","Fuyanna taon ni tataudi sa kalamahanoma be Diyowabi sa hiyalai mate Deiwidi ena tau hiyala haisa sa wunuidi. Yo Ulaiya hinaga sa wunu esegahi. ");
INSERT INTO bxh_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","Betesiba lahuna Ulaiya wasana ya atahi mate ya tan eloꞌelolosi. ");
INSERT INTO bxh_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","Logo fuyana ya ofi, Deiwidi doga hesa ya fatamali be waihin ya foyahiyama ena luma yai ya famala lahuna be natuna bogana yai ya yosi. In moho, somo Deiwidi ya ginauli mate Guyau hige nuwana i amnaen. ");
INSERT INTO bxh_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","Guyau, peloweta hesa hesana Neitan ya fatamali lawen Deiwidi lisina. Ya laoma lisina be iyen, Tatau luwaga taon hesa yai. Hesa ya fagogo na hesa higeꞌe. ");
INSERT INTO bxh_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","Tau fagogo mate ena sipi yo bulumakau sa ouli, ");
INSERT INTO bxh_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","na tau fagogogo gesagesa mate sipi gubugubufwauna tinabawa esega moho ya une. Hige somo hesa. Taumoho te, nanatuna yo sipi maꞌedi ya itaꞌita watanidi be–, ya laꞌi. Ana anꞌan tefana mate ya soiyen be sipi ana ya felefelen. Ana kaputi yai ya nom yo ai nimana ya enoꞌeno hinaga. Itaꞌitana doha natuna waihin. ");
INSERT INTO bxh_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","Fuya hesa tau antaumana ya laoma tau fagogogo ena luma. Hige i fanuha bena ena sipi e bulumakau laꞌi i fapaisowa be taumana ana i lau buꞌa. Yo fede, ya lau be tau fagogo gesagesa ena sipi gubugubufwauna tinabawa ya abi, sa wunui be taumana ana anꞌan sa abi nonohai. ");
INSERT INTO bxh_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","Deiwidi ya manabala heyaya tau fagogo lebena yai be ya libalau Neitan lisina iyen, Guyau wananaha ya mwahumwahuli, hesana yai E liba mate somo taumoho ya ginauli ni, ibe moho ya peꞌi! Somo ya ginauli te, mate hige ena nuwatohatoha tau gogo gesagesa lebena yai. ");
INSERT INTO bxh_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","Debana yai, bena sipi nanatudi fati tau gogo gesagesa ya felen ena maisa, paꞌana hige i nuwatohatohaen. ");
INSERT INTO bxh_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","Habahim, Neitan ya libalau Deiwidi lisina iyen, Um taumohom, logem! Guyau, Isalaela eda Yaubada ya liba doha ite: “Yau E fasinabom Isalaela edi kin yo Saulo ena gigibwali yai E fofofahim. ");
INSERT INTO bxh_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","Am tanuwaga Saulo ena luma yo lalahuna E fele afuledi nimam yai. E faꞌobiyom Isalaela yo Diuda wa tanuwagaidi. Na yena hige gonowam, yau gonowagu haba ginauli haisa E felem. ");
INSERT INTO bxh_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","Paꞌana somo Guyau ena liba wa ꞌwaiyoꞌoꞌen be heyaya wa ginauli matana yai? Hiyala yai Ulaiya wa ita afulen be Amon dodogadi edi baineti yai, sa wunui. Na lahuna wa abi, lahum. ");
INSERT INTO bxh_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","Egu liba hige u lau watan, na wa ita lidilidiyegu be Ulaiya, Hiti dogana, lahuna wa abi, lahum. Logena be, laulauwewem aho te na fuya matadi yai, baineti yai haba sa wunuidi.” ");
INSERT INTO bxh_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","Guyau ya liba doha ite: “Am boga ganahewana yai haba E fapilipilim. Ai matam haba lalahum E abidi be lahai esega - esega taumoho hesa E felen be maꞌena ai mahata sa luma gwaꞌu. ");
INSERT INTO bxh_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","Um simosimo yai laulau te wa ginaulidi be dodoga ibege ti siba. Na Yau E ginauli haba ai mahata, Isalaela dodogadi mahudoꞌidi ai matadi.” ");
INSERT INTO bxh_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","Habahim, Deiwidi ya libalau Neitan lisina iyen, Yau heyaya E ginauli Guyau matana yai. Neitan, Deiwidi alinana ya bui iyen, Guyau em heyaya ya nuwa afulen. Um ibege u peꞌi. ");
INSERT INTO bxh_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","In moho, laulau te wa ginauli mate, wananaha Guyau hige u faꞌatitiyen. Logena, natumiu taumoho ami yosi haba ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","Neitan ya lau ena luma mulina yai, Deiwidi natuna, Ulaiya lahuna ya yosi. Guyau ena gigibwali yai ya faꞌasiyebo, be asiyebo heyaya ya abi. ");
INSERT INTO bxh_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","Deiwidi enehena ya anꞌeta gadogadola Guyau lebena yai. Ya waiyoꞌo kalahe na iꞌipadi ena ai luma mate ya laulau eno ai matu. ");
INSERT INTO bxh_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","Babada ena luma yai sa paipaisowa Deiwidi bena sa abi famwaito na ya waiyoꞌo yo hige i fanuha ma afa haidana ti kalahe. ");
INSERT INTO bxh_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","Nogeya! Lahai fafaligigi luwagana yai, gwama ya peꞌi. Ena tau lau fayofayo, Deiwidi falibana sa ꞌwasabu be nuwadi yai tiyen, Gwama hola ma mwahumwahulina, Deiwidi te fafaliba, in moho, hige gonowana i ataꞌatahi. Haba sidohana eda fafalibana mate gwama haꞌa ya peꞌi? Ibe somo hesa i ginauli be i faheyaya fuyoi? ");
INSERT INTO bxh_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","Tau laufayofayo sa fafaꞌasu fenafena. Ya itadi be ya nuwatuhui mate gwama haꞌa ya peꞌi. Yo fede, iyen, Gwama ya peꞌi? Alinana sa bui tiyen, Ii–, ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","Habahim Deiwidi matu yai ya obiyo be ya lau ya sigu. Tauna ya famaꞌi yo ena kaleko ya senisidi na ya lau Guyau ena luma yai ya fadebasae. Habahim, ya fuyo ena luma. Ya anꞌeta anꞌan be ana sa lau dala be ya kalahe. ");
INSERT INTO bxh_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","Ena tau lau fayofayo sa fatiꞌoi tiyen, Somo wa ginauli te, mate ꞌe nuwa ponoꞌen. Gwama hola ma mwahumwahulina mate wa anhudi yo wa tan na aho wawaya ya peꞌi mate wa obiyo be wa anꞌan! ");
INSERT INTO bxh_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","Alinadi ya bui iyen, Gwama hola ma mwahumwahulina mate E anhudi yo E tan. Yau yawa, “Bena Guyau haba i nuwatohatohaegu be wawaya i famwahuli.” ");
INSERT INTO bxh_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","Na aho ya peꞌi. Paꞌana somo be haba E anhudi? Hige gonowagu haba ya famwahuli fuyoi. Ibe yau E peꞌi haba E lau lebena, na in peꞌi yai hige gonowana i fuyoma lebegu. ");
INSERT INTO bxh_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","Habahim Deiwidi lahuna, Betesiba ya fanuwa loholoho, be ya lau maꞌena sa eno. Natuna taumoho hesa ya yosi be hesana sa tole Solomon, be Guyau ya fanuha wananahai. ");
INSERT INTO bxh_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","Guyau ena Peloweta Neitan ya faliba bena hesana hesa sa tole Dedidaiya paꞌana Guyau ya gadosisiyen. ");
INSERT INTO bxh_vpl VALUES ("K12_10","012_2_10","1KI","2","10","12","Deiwidi ya kin Isalaela yai bolima 40. Na Hebelon yai bolima faligigi luwaga. Yelusalem yai bolima 33. Solomon tamana Deiwidi ya falau damahi be ya kin, yo hige gonowana sai i famwahimwahiu. Deiwidi ya peꞌi Yelusalem yai, na tefana hesa hesana “Deiwidi ena Nuꞌu” amainiya sa boꞌusai. ");
INSERT INTO bxh_vpl VALUES ("K13_3","012_3_3","1KI","3","3","3","Solomon, tamana Deiwidi ena laulau ya lau watanidi be Guyau ya fanuha. In moho antalasam yo maꞌi panepanedi ya gabudi ai piupiu hiti. ");
INSERT INTO bxh_vpl VALUES ("K13_4","012_3_4","1KI","3","4","4","Aba fadebasae loholohona hesa mate Gibiyon Nuꞌuna yai, habahim nuꞌu hahaisa enehedi. Logena, Baꞌisa Solomon ya lau amainiya be antalasam 1,000 ya gabudi. ");
INSERT INTO bxh_vpl VALUES ("K13_5","012_3_5","1KI","3","5","5","Maihonana eno suwai yai Guyau ya taumahata Solomon lisina Gibiyon yai. Na Guyau iyebom, Somo wa fanuha bena E felem mate u anꞌetai. Alinana Solomon ya bui, iyen, ");
INSERT INTO bxh_vpl VALUES ("K13_7","012_3_7","1KI","3","7","7","Guyau egu Yaubada aho te, em tau paisowa wa tolegu baꞌisa, tamagu Deiwidi falau damahina. In moho yau doha wawaya kiukiu. Yo tanuwaga paisowana sonogana hige ya sibai. ");
INSERT INTO bxh_vpl VALUES ("K13_8","012_3_8","1KI","3","8","8","Em dodoga wa fasinabodi ganahewadi yai, yau em tau paisowa. Sa ouli wananaha, hige gonowana sai haba i fatilidi. ");
INSERT INTO bxh_vpl VALUES ("K13_9","012_3_9","1KI","3","9","9","Aee–, nuwatuhu sibasiba u felegu haba heyaya yo dudulai E ita lobahidi. Haba em dodoga itaꞌita watanidi E sibai. Yena hige u felegu hige gonowagu haba em nuꞌu laꞌilaꞌi te ya ita watan. ");
INSERT INTO bxh_vpl VALUES ("K13_10","012_3_10","1KI","3","10","10","Yaubada iyen, Solomon, em anꞌeta E fanuha. ");
INSERT INTO bxh_vpl VALUES ("K13_11","012_3_11","1KI","3","11","11","Egoba miya lofalofa yo fagogo anꞌetadi wa anꞌetaidi e am waiyunu bena E wunuidi anꞌetana wa anꞌeta. In moho sibasiba wa etai be haba dudulai yai dodoga wa foyahidi. ");
INSERT INTO bxh_vpl VALUES ("K13_12","012_3_12","1KI","3","12","12","Lisina yai, haba sibasiba E felem be wa sonoga diꞌoi. Hige sai hesa beyabeyana e fuya matada yai ena sibasiba doha. ");
INSERT INTO bxh_vpl VALUES ("K13_13","012_3_13","1KI","3","13","13","Yo hinaga somo um hige u anꞌetai mate haba E felem. Haba wa fagogo yo haba sa faꞌatitiyem em miya fuyandi yai. Yo hesam haba ya laꞌi, habahim kin mahudoꞌidi. ");
INSERT INTO bxh_vpl VALUES ("K13_14","012_3_14","1KI","3","14","14","Yena wa awa abiyegu yo egu laugagayo wa lau watanidi doha tamam Deiwidi, haba wa miya lofalofa. ");
INSERT INTO bxh_vpl VALUES ("K13_15","012_3_15","1KI","3","15","15","Solomon ya eno obiyo ya nuwatuhu lobahi mate Yaubada ya libama lisina eno suwai yai. ");
INSERT INTO bxh_vpl VALUES ("K13_16","012_3_16","1KI","3","16","16","Wawahin matamata heyayadi luwaga sa laoma kin Solomon sa ita be edi pilipili ya fadudulai. ");
INSERT INTO bxh_vpl VALUES ("K13_17","012_3_17","1KI","3","17","17","Hesauna iyen, Egu baꞌisa, waihin te luma esega yai ꞌe gogogo. Maꞌegu ꞌe miyamiya na natugu taumoho E yosi. ");
INSERT INTO bxh_vpl VALUES ("K13_18","012_3_18","1KI","3","18","18","E yosi na lahai faihona mulidi yai, waihin te hinaga natuna taumoho ya yosi. Ibomai lumana yai ni ꞌe miyamiya, hige sai laꞌi maꞌemai. ");
INSERT INTO bxh_vpl VALUES ("K13_19","012_3_19","1KI","3","19","19","Iꞌipana yai, waihin te natuna ya eno hafiti be ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("K13_20","012_3_20","1KI","3","20","20","Iꞌipa atipuna E eno tau ꞌwafuꞌwafu na natuna peꞌipeꞌina ya leyama ya faꞌeno nuwanuwagu yai. Na natugu ya lawen ya faꞌeno nuwanuwana yai. ");
INSERT INTO bxh_vpl VALUES ("K13_21","012_3_21","1KI","3","21","21","Hwalahwalalana E obiyo bena natugu E fanom na E ita mate peꞌipeꞌina! Ya ifi tatatalima na E ita komakomaniꞌi mate hige natugu. ");
INSERT INTO bxh_vpl VALUES ("K13_22","012_3_22","1KI","3","22","22","Solomon matana yai wawahin luwaga te, sa liba faiꞌabi. Hesa iyen, Higeꞌe! Peꞌipeꞌina um natum na mwahumwahulina yau natugu. Na waihin bwaꞌibwaꞌina ya liba fuyo, iyen, Higeꞌe, mwahumwahulina, yau natugu. ");
INSERT INTO bxh_vpl VALUES ("K13_23","012_3_23","1KI","3","23","23","Habahim, Kin iyen, Itete iyebom, “Gwama peꞌipeꞌina te um natum na mwahumwahulina yau natugu,” na hesa iyen, “Higeꞌe, mwahumwahulina yau natugu na peꞌipeꞌina um natum.” ");
INSERT INTO bxh_vpl VALUES ("K13_24","012_3_24","1KI","3","24","24","Yo fede, ya liba fuyo iyen, Baineti au leyama. Yo fede baineti sa leyama sa felen. ");
INSERT INTO bxh_vpl VALUES ("K13_25","012_3_25","1KI","3","25","25","Habahim iyen, Gwama mwahumwahulina au tala dagi be hesa ena tefa na, hesa ena tefa. ");
INSERT INTO bxh_vpl VALUES ("K13_26","012_3_26","1KI","3","26","26","Waihin bwaꞌibwaꞌina natuna ya fanuwatohatohaen be ya libalau kin lebena iyen, Aee–, egu baꞌisa! Gwama tabu u tala dagi! Ma mwahumwahulina waihin ni u felen! Na waihin hesa iyen, Higeꞌe, u tala dagi! Tabu sai u felen. ");
INSERT INTO bxh_vpl VALUES ("K13_27","012_3_27","1KI","3","27","27","Yo fede kin iyen, Tabu au tala dagi! Waihin bwaꞌibwaꞌina au felen. In tinana wananaha! ");
INSERT INTO bxh_vpl VALUES ("K13_28","012_3_28","1KI","3","28","28","Baꞌisa Solomon wawahin sidohana ena fafadudulaidi, Isalaela dodogadi sa atahiyen be sa noꞌoꞌen, paꞌana sa ita lobahi mate Yaubada sibasiba ya felen be dudulai yai ya paisowa. ");
INSERT INTO bxh_vpl VALUES ("K14_20","012_4_20","1KI","4","20","20","Solomon ena fuya kin yai dodoga sa gogogo Diuda yai yo Isalaela yai mate sa ouli wananaha doha gelegele gabogabo yai. Mahudoꞌidi sa kwade paꞌana hige ti guliyam yo hige gadodi ti magu. ");
INSERT INTO bxh_vpl VALUES ("K14_21","012_4_21","1KI","4","21","21","Solomon ena nuꞌu ana sigasiga mate: Ifeleti Hoꞌowana yai bwauli yo bolima edi aba towa atiꞌatipudi yai ya lidi bee–, Filisitani edi nuꞌu, yawana ena aba towa yai, na ya lau bee–, Idipi. Ena fuya yai nuꞌudi te takesi sa fafamaisa lisina yai. ");
INSERT INTO bxh_vpl VALUES ("K14_25","012_4_25","1KI","4","25","25","Ena fuya yai, dodoga mahudoꞌidi Isalaela yo Diuda ganahewana yai sa miya daumwali. Dan duhu laꞌina tefa lidilidina yai ya hasahasai ee–, Belesiba. Adi boga hesa - hesa edi umaꞌuma logulogudi yai sa anlogulogu. ");
INSERT INTO bxh_vpl VALUES ("K15_1","012_5_1","1KI","5","1","1","Fuyana Taya nuꞌuna edi Baꞌisa Hailam mate ya atahiyen mate Solomon sa fasinabo Isalaela edi baꞌisa, tamana Deiwidi falau damahina. Yo fede ena dodoga lalaꞌi ya duidi sa lau Solomon lisina, be ena lautoꞌi sa felen, paꞌana ena faꞌilu loholohona. ");
INSERT INTO bxh_vpl VALUES ("K15_2","012_5_2","1KI","5","2","2","Solomon wasa te ya fatamali fuyoi Hailam lisina iyen, ");
INSERT INTO bxh_vpl VALUES ("K15_3","012_5_3","1KI","5","3","3","Sidohana tamagu Deiwidi nuꞌu sadasadai dodogadi mahudoꞌidi, maidadi sa hiyala haꞌa wa sibai. Logena be Guyau ena Yaubada hesana aba faꞌatitiyenna Lumana hige i ginauli ya lau ee–, tau hiyalaina Guyau ya lei hafihafitidi. ");
INSERT INTO bxh_vpl VALUES ("K15_4","012_5_4","1KI","5","4","4","Aho te, Guyau egu Yaubada, in egu tau hiyala. Mahudoꞌidi ya liba fataludi be hige waiyunu e heyaheyaya hesa. ");
INSERT INTO bxh_vpl VALUES ("K15_5","012_5_5","1KI","5","5","5","Egu nuwatuhu te, E fanuha ibe Guyau egu Yaubada hesana aba faꞌatitiyenna lumana E ginauli. Doha Guyau, tamagu Deiwidi haꞌa ya faliba iyen, “Natum taumoho E faꞌobiyo baꞌisa, tau falau damahim haba hesagu aba faꞌatitiyenna lumana ya ginauli.” ");
INSERT INTO bxh_vpl VALUES ("K15_6","012_5_6","1KI","5","6","6","Em tau paisowa u falibadi ti lau Lebanon nuꞌuna be oyagi sida egu ti oidi. Egu tau paisowa haba maꞌedi em tau paisowa sa paisowa. Saidon tataudi oyagi oina sa siba na yau egu tau paisowa sa fakau. Maisa somo wa libaen haba dudulai yai E famaisa watan. ");
INSERT INTO bxh_vpl VALUES ("K16_1","012_6_1","1KI","6","1","1","Solomon ya kin Isalaela yai mate bolima fati na habahim ena tau paisowa sa fatubu Dubu Tabuna sa faꞌobiyo Dibi nawalahina yai, Bayawa Anꞌangogona nawahalina fafaluwagana yai. Na bolima 480 mulidi yai Isalaela dodogadi Idipi sa lau afulen. ");
INSERT INTO bxh_vpl VALUES ("K16_7","012_6_7","1KI","6","7","7","Umeꞌehu edi aba sapisapi nuꞌuna yai amainiya dubu ana umeꞌehu sa pidi nonohaidi. Lumana sa ginauli mate hige hama, geyageya e aba paisowa ginaulidi ti fapaisowadi. Dubu edi aba faꞌobiyona yai powapowati dagugudi hige ti atahiyedi. ");
INSERT INTO bxh_vpl VALUES ("K16_11","012_6_11","1KI","6","11","11","Habahim Guyau ya libalau Solomon lisina, iyebom, ");
INSERT INTO bxh_vpl VALUES ("K16_12","012_6_12","1KI","6","12","12","Dubu Tabuna wa ginaginauli te, yena egu laugagayo wa awa abiyedi yo somo E libaedi wa famuli watanidi, lisina yai egu liba fasunuma haba E fawananaha lisim yai, doha tamam Deiwidi lisina yai E ginauli. ");
INSERT INTO bxh_vpl VALUES ("K16_13","012_6_13","1KI","6","13","13","Haba maidagu egu dodoga Isalaela E miya, ibege ya lau afuledi. ");
INSERT INTO bxh_vpl VALUES ("K16_14","012_6_14","1KI","6","14","14","Yo fede Solomon Dubu Tabuna ya ginauli faꞌofi. ");
INSERT INTO bxh_vpl VALUES ("K18_1","012_8_1","1KI","8","1","1","Habahim Isalaela ganahewadi yai sulu hesa - hesa yo boga hesa - hesa babadadi Baꞌisa Solomon ya yoga gogondima Yelusalem yai na ya falibadi bena Guyau ena yali aba husanina sa bahe hasaꞌen Deiwidi ena nuꞌu, Saiyon. ");
INSERT INTO bxh_vpl VALUES ("K18_3","012_8_3","1KI","8","3","3","Fuyana Isalaela babadadi sa mahano, tau antalasam yali aba husanina sa bahei. ");
INSERT INTO bxh_vpl VALUES ("K18_4","012_8_4","1KI","8","4","4","Tau antalasam yo sulu Lewi tataudi Guyau ena yali aba husanina yo Palai Tabuna ma ginaulina sa bahe hasaedi Yaubada ena Luma. ");
INSERT INTO bxh_vpl VALUES ("K18_5","012_8_5","1KI","8","5","5","Solomon yo Isalaela dodogadi mahudoꞌidi sa faꞌoigogoma yali aba husanina hafohafona yai. Sipi yo bulumakau boludi sa anꞌantalasamedi, hige gonowana ti fatilidi. ");
INSERT INTO bxh_vpl VALUES ("K18_6","012_8_6","1KI","8","6","6","Habahim tau antalasam Guyau ena yali aba husanina sa leyama Yaubada ena Luma Tabuna ganahewana, be Bili Fafatabuna Wananaha yai, Anelu hesadi Selubim mabedi ubudi yai, sa tole. ");
INSERT INTO bxh_vpl VALUES ("K18_10","012_8_10","1KI","8","10","10","Tau antalasam Bili Fafatabuna Wananahana yai sa kalamahanoma mate Guyau ena Luma Tabuna yada ya fakou ");
INSERT INTO bxh_vpl VALUES ("K18_11","012_8_11","1KI","8","11","11","be tau antalasam hige edi paisowa ti ginauli paꞌana Guyau namanamalina yadana ya lidima Luma Tabuna ya famohafu. ");
INSERT INTO bxh_vpl VALUES ("K18_22","012_8_22","1KI","8","22","22","Habahim Solomon, Guyau ena aba antalasam hafohafona yai ya obiyo, Isalaela dodogadi nuwanuwadi yai na nimana ya lolo hasaedi galewa, ");
INSERT INTO bxh_vpl VALUES ("K18_23","012_8_23","1KI","8","23","23","na ya lauꞌuꞌula iyebom, Isalaela ema Yaubada! Hige Yaubada hesa galewa yai e tanoꞌubu yai doha um. Um em tau paisowa sai gadosisi yalina ma nuwa ofi fahina ya famuli watan mate em gadosisi yalina wa fawananaha lisina yai. ");
INSERT INTO bxh_vpl VALUES ("K18_27","012_8_27","1KI","8","27","27","In moho Um Yaubada! Hige gonowana ai tanoꞌubu u miya, higeꞌe wananaha. Galewa hinaga hige i laꞌi haba ainiya u miya, be Luma Tabuna E ginauli te ya kiu wananaha, hige gonowana ainiya u gogo. ");
INSERT INTO bxh_vpl VALUES ("K18_28","012_8_28","1KI","8","28","28","Aee–, Guyau egu Yaubada, yau em tau paisowa! Egu lauꞌuꞌula aho te, u atahi be somo E anꞌetai, u fawananaha. ");
INSERT INTO bxh_vpl VALUES ("K18_29","012_8_29","1KI","8","29","29","Beyabeyana wa libaen uwen, “Ainiya haba ami fadebasaegu be aee–, Guyau! Dubu Tabuna te, iꞌipa yo lahai u ita watan. Amaiteꞌi E lauꞌuꞌula laowa te, u atahi. ");
INSERT INTO bxh_vpl VALUES ("K18_30","012_8_30","1KI","8","30","30","Yau yo em dodoga Isalaela, ema anꞌeta u atahi. Yena E sana lau nuꞌuna be E lauꞌuꞌula mate em aba miya Galewa yai, ainiya ema lauꞌuꞌula u atahi, na ema heyaya u nuwatuhu afuledi.” ");
INSERT INTO bxh_vpl VALUES ("K18_41","012_8_41","1KI","8","41","41","Yena taꞌowawa eda lofalofa yai sa laoma hesam debana yai. ");
INSERT INTO bxh_vpl VALUES ("K18_42","012_8_42","1KI","8","42","42","Na dodoga sa sana lau Luma Tabuna lisina be sa lauꞌuꞌula, haba sa atahi mate hesam ya laꞌi, yo em gigibwali yo ginauli lalaꞌi wa ginaulidi haba sa atahiyedi. ");
INSERT INTO bxh_vpl VALUES ("K18_43","012_8_43","1KI","8","43","43","Em aba miya galewa yai, ainiya edi anꞌeta u atahi be haba dodoga mahudoꞌidi tanoꞌubu yai te hesam sa sibai yo sa faꞌatitiyem doha ai em dodoga, Isalaela. Haba sa sibai Luma Tabuna E ginauli te, mate hesam edi aba faꞌatitiyenna. ");
INSERT INTO bxh_vpl VALUES ("K110_1","012_10_1","1KI","10","1","1","Solomon hesana ya laꞌi yo Guyau sidohana ena fafaꞌatitiyenna wasana Siba edi Hatafele ya atahiyen yo fede ya lau lebena be fatiꞌo poꞌipoꞌidi ya fatiꞌoi. ");
INSERT INTO bxh_vpl VALUES ("K110_2","012_10_2","1KI","10","2","2","Ma afa haidana tau paisowa peidi, anꞌan aba fahahadi, gole laꞌilaꞌi yo umeꞌehu wasawasadi kamela sa fabaheidi, na sa lau Yelusalem. Sa mahano mate ena nuwanuwatuhu mahudoꞌina Solomon ya faliba. ");
INSERT INTO bxh_vpl VALUES ("K110_3","012_10_3","1KI","10","3","3","Ena fatiꞌo mahudoꞌina Solomon ya buidi, hige fatiꞌo hesa i poꞌi lebena yai. ");
INSERT INTO bxh_vpl VALUES ("K110_4","012_10_4","1KI","10","4","4","Solomon ena sibasiba ya atahi, yo Luma Tabuna laꞌilaꞌina ya faꞌobiyo, ya ita. ");
INSERT INTO bxh_vpl VALUES ("K110_5","012_10_5","1KI","10","5","5","Kalahe hatahata yai, yo tatau lalaꞌi sidohana edi taꞌataꞌai, yo ena tau paisowa lalaꞌi edi leli lolofa loholohodi yo nomnom kaputidi tau felefele mate Siba Hatafelena ya itadi. Antalasam gabugabudi Solomon ya antalasamendi Guyau ena Luma Tabuna yai hinaga ya itadi, be ya noꞌo heyaya. ");
INSERT INTO bxh_vpl VALUES ("K110_6","012_10_6","1KI","10","6","6","Hatafele ya libalau Kin Solomon lisina, iyen, Em sibasiba yo ginauli lalaꞌi wa ginaulidi wasadi egu nuꞌu yai E atahiyedi mate wananaha! ");
INSERT INTO bxh_vpl VALUES ("K110_7","012_10_7","1KI","10","7","7","Fuyanna hige ya kawawananaha ee–, E laoma amaiteꞌi matagu yai E itadi, habahim E kawawananaha. In moho somo sa falibagu mate begana moho, em sibasiba yo em fagogo ya laꞌi wananaha, habahim somo E atahiyen. ");
INSERT INTO bxh_vpl VALUES ("K110_8","012_10_8","1KI","10","8","8","Em tatau nuwadi sa kwade, yo tatau lalaꞌi safaluma fuya ouꞌouli ai matam sa obiyo na em sibasiba libadi sa ataꞌatahiyedi mate sa kwade hinaga. ");
INSERT INTO bxh_vpl VALUES ("K110_9","012_10_9","1KI","10","9","9","Guyau em Yaubada E fadebasae. In ya ita faloholohom be ya faꞌobiyom Isalaela edi kin. Guyau ena gadosisi otaꞌota fahina Isalaela enehedi be ya faꞌobiyom kin. Haba Isalaela dudulai yai yo loholoho yai wa foyahidi. ");
INSERT INTO bxh_vpl VALUES ("K111_1","012_11_1","1KI","11","1","2","Guyau hige i fanuha bena Isalaela yaubada bwalabwala ti fadebasaedi. Debana yai ya liba fanuwa tagudi tabu nuꞌu haisa wawahinidi ti faidi. Solomon lalahuna boludi ganahewadi yai tausomo ya fanuha wananahaidi mate itete: Kin Falo natuna, Mowabi, Amon yo Idom, Sidon yo Hiti wawahinidi. Ganahewadi yai mate Falo natuna ya fanuha wananahai. ");
INSERT INTO bxh_vpl VALUES ("K111_3","012_11_3","1KI","11","3","3","Yo hatafele 700 ya faidi, na 300 mate ena fayofayo tau abidi. Yo fede sa foya ponoli. ");
INSERT INTO bxh_vpl VALUES ("K111_4","012_11_4","1KI","11","4","4","Solomon ena tautaulaꞌi yai, lalahuna sa lawen be edi yaubada ya fadebasaedi. Tamana Deiwidi ena laulau hige i lau watan be Guyau Yaubada i fadebasae. ");
INSERT INTO bxh_vpl VALUES ("K111_5","012_11_5","1KI","11","5","5","Sidon edi yaubada bwalabwala Asiteleti yo Amon edi yaubada heyaheyayana hesana Moleka, mate Solomon ya fadebasaedi. ");
INSERT INTO bxh_vpl VALUES ("K111_7","012_11_7","1KI","11","7","7","Yelusalem ganamulina tefa saisaina piupiu hitina yai, Mowabi edi yaubada heyayana hesana Kemosi yo Amoli edi yaubada heyayana Moleka aba fadebasaedi Solomon ya ginaulidi. ");
INSERT INTO bxh_vpl VALUES ("K111_8","012_11_8","1KI","11","8","8","Afa lalahuna mahudoꞌidi ya fagonafidi, be haba mulamula panepanedi yo antalasam hahaisa sa gabudi edi yaubada lisidi. ");
INSERT INTO bxh_vpl VALUES ("K111_9","012_11_9","1KI","11","9","9","Isalaela edi Guyau yo edi Yaubada ya taumahata ma luwaga Solomon lisina yai. In moho ya moꞌa peiyen. Yo fede Guyau manana ya bala, ");
INSERT INTO bxh_vpl VALUES ("K111_10","012_11_10","1KI","11","10","10","paꞌana haꞌa ya falaugagayo tabu yaubada haisa i famuli watanidi. In moho Solomon hige ena laugagayo i lau watan. ");
INSERT INTO bxh_vpl VALUES ("K111_11","012_11_11","1KI","11","11","11","Yo fede Yaubada ya libalau lisina iyen, Somo E falibam hige u lau watan na em nuwatuhu moho wa lau watan. E angwala mate em dudulai haba E abifahi be em tau paisowa E felen. ");
INSERT INTO bxh_vpl VALUES ("K111_12","012_11_12","1KI","11","12","12","In moho paꞌana Deiwidi mate tamam, be haba hola em aba taꞌai yai wa miyamiya. Natum haba hola E bagi watan ee–, ya famala kin, habahim em aba taꞌai haba E abifahi. ");
INSERT INTO bxh_vpl VALUES ("K111_13","012_11_13","1KI","11","13","13","In moho, ibege nuꞌu mahudoꞌidi ya abifahidi lisina yai, haba sulu esega E felen egu tau paisowa Deiwidi debana yai, yo Yelusalem debana yai, paꞌana E fasinabo. ");
INSERT INTO bxh_vpl VALUES ("K111_26","012_11_26","1KI","11","26","26","Nebati natuna Delebowam, ya liba faiꞌabi Kin Solomon lisina yai hinaga. In ena tau paisowa hesa laꞌilaꞌi na ena nuꞌu mate Seleda taonna, Ifelaim nuꞌuna yai. Tinana hwabuhwabu, hesana Seluwa. ");
INSERT INTO bxh_vpl VALUES ("K111_27","012_11_27","1KI","11","27","27","Delebowam sidohana ena liba faiꞌabi kin lisina yai dedena doha ite: Solomon tamana Deiwidi, ena taon Yelusalem halu hobodi ya lau famohafu yo ganana tamotundi ya ginauli fuyoꞌidi. ");
INSERT INTO bxh_vpl VALUES ("K111_28","012_11_28","1KI","11","28","28","Delebowam in tau paisowa loholoho na Solomon ya ita mate gonowana, be ya tole Sulu Manase yo Ifelaim edi paisowa pelena tau ita watanina. ");
INSERT INTO bxh_vpl VALUES ("K111_29","012_11_29","1KI","11","29","29","Fuya hesa Yelusalem ganamulina yai, Delebowam edaꞌeda yai ya laulau na Ahaida, Silo edi Peloweta mate ya failobahi. Hige sai hesa maꞌedi, ibodi moho. Na peloweta wa luhuluhu falifalihuna ya luhufi. ");
INSERT INTO bxh_vpl VALUES ("K111_30","012_11_30","1KI","11","30","30","Ahaida luhuluhu fwaufwauna tauna yai ya abifahi be ya kamgigi senana safuhudohudoꞌi luwaga. ");
INSERT INTO bxh_vpl VALUES ("K111_31","012_11_31","1KI","11","31","31","Habahim Delebowam ya faliba iyen, “Sena safuhudohudoꞌi u abidi, enehem, paꞌana Guyau, Isalaela edi Yaubada ya liba iyen, ‘U itaꞌita, Yau mate, Solomon haba E kamfahi ena aba tanuwaga nuꞌuna yai na sulu safuhudohudoꞌi haba E felem.” ");
INSERT INTO bxh_vpl VALUES ("K111_32","012_11_32","1KI","11","32","33","Solomon ya taꞌai mulimuliyegu. Egu laulau hige i laulauwedi. Yo fede ya lauꞌuꞌula lau Sidon edi yaubada bwalabwala waihin hesana Asitoleti, Mowabi dodogadi edi yaubada, Kemosi yo Amon dodogadi edi yaubada, Moleka lisidi hinaga. Hige loholoho i ginauli matagu yai yo egu liba yo laugagayo hige i lau watanidi. Hige doha tamana, Deiwidi ena laulau. Deiwidi egu tau paisowa na Isalaela suludi mahudoꞌidi ganahewadi yai E fasinabo yo Yelusalem hinaga E fasinabo, yau, enehegu. Debadi yai sulu esega moho haba E biya afulen be Solomon hola ya ita watan. ");
INSERT INTO bxh_vpl VALUES ("K111_35","012_11_35","1KI","11","35","35","Peloweta Ahaida ya libalau Delebowam lisina, iyen, Isalaela dodogadi haba E abifahidi Solomon natuna ena aba baꞌisa nuꞌuna yai, na haba sulu safuhudohudoꞌi E felem. ");
INSERT INTO bxh_vpl VALUES ("K111_40","012_11_40","1KI","11","40","40","Kin Solomon ya anpate bena Delebowam ya wunui. In moho Delebowam ya gela be ya lau Idipi. Be Sisaki Nuꞌuna yai ya miya ee–, Solomon ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("K111_42","012_11_42","1KI","11","42","42","Solomon, Isalaela mahudoꞌina ya ita watan mate bolima laꞌina 40. ");
INSERT INTO bxh_vpl VALUES ("K111_43","012_11_43","1KI","11","43","43","Habahim ya peꞌi be tamana Deiwidi ena Nuꞌu yai sa boꞌusai. Yo fede, natuna Lehebowam ya falau damahi. ");
INSERT INTO bxh_vpl VALUES ("K112_1","012_12_1","1KI","12","1","1","Isalaela dodogadi sa faꞌoigogo Sekem yai na Solomon natuna, Lehebowam ya lau amainiya bena sa faꞌobiyo edi kin. ");
INSERT INTO bxh_vpl VALUES ("K112_2","012_12_2","1KI","12","2","3","Nebati natuna Delebowam ya lau Idipi paꞌana Kin Solomon ya ꞌwasabuwen. Fuyanna Idipi yai wasa ya atahiyen mate Solomon ya peꞌi, yo natuna sa faꞌobiyo kin, mate ya fuyoma. Yo fede, Delebowam ana liba sa fatamali be maidana Isalaela mahudoꞌidi sa lau Kin Lehebowam lisina be Delebowam iyen, ");
INSERT INTO bxh_vpl VALUES ("K112_4","012_12_4","1KI","12","4","4","Tamam, Solomon paisowa mwahumwahudi ya felemai, na um tabu em abiꞌabimai doha. Haba em ita wata ganahewana yai ꞌe miya. ");
INSERT INTO bxh_vpl VALUES ("K112_5","012_12_5","1KI","12","5","5","Alinadi Kin Lehebowam ya bui iyen, Au lau lahai faihona habahim ami fuyoma lebegu. Yo fede dodoga, sa lau. ");
INSERT INTO bxh_vpl VALUES ("K112_6","012_12_6","1KI","12","6","6","Mulidi yai, Kin Lehebowam tamana tau sagusaguhina, iti Solomon ena tau paisowa lalaꞌi ya faꞌoilibadi iyen, Dodoga haba somo E falibadi? ");
INSERT INTO bxh_vpl VALUES ("K112_7","012_12_7","1KI","12","7","7","Ena liba sa bui tiyen, Yena wa fanuha dodoga wa saguhidi, edi nuwatuhu bena wa lau watan, haba em ita wata ganahewana yai sa miyamiya. ");
INSERT INTO bxh_vpl VALUES ("K112_8","012_12_8","1KI","12","8","8","In moho Lehebowam edi nuwatuhu ya ꞌwaiyoꞌoꞌen na ana hiti tataudi, enehena sa paipaisowa, ya faꞌoilibadi. ");
INSERT INTO bxh_vpl VALUES ("K112_9","012_12_9","1KI","12","9","9","Ya fatiꞌoidi iyen, Emi nuwatuhu somo? Dodoga sa libaliba laoma lisigu tiyen, “Ema paisowa u famalahadi, tabu doha tamam ena fuya yai.” Haba somo E falibadi? ");
INSERT INTO bxh_vpl VALUES ("K112_10","012_12_10","1KI","12","10","10","Ana hiti tataudi alinana sa bui tiyen, Dodoga aho sa falibabam tiyen, “Ema paisowa u famalahadi, u falibadi uwe, ‘Yau doga nuwa poꞌipoꞌigu, hige doha tamagu! ");
INSERT INTO bxh_vpl VALUES ("K112_11","012_12_11","1KI","12","11","11","In paisowa mwahumwahudi ya felemiu na yau haba mwahumwahu wananahadi E felemiu! In balawa yai ya talaimiu na yau haba seni yai E talaimiu.” ");
INSERT INTO bxh_vpl VALUES ("K112_12","012_12_12","1KI","12","12","12","Lahai faihona mulidi yai Delebowam maꞌena dodoga mahudoꞌidi sa fuyo Kin Lehebowam lisina be edi fatiꞌo buina sa abi doha haꞌa Kin Lehebowam ya libaen iyen, Lahai faihona mulidi yai au fuyoma lisigu. ");
INSERT INTO bxh_vpl VALUES ("K112_13","012_12_13","1KI","12","13","13","Baꞌisa Lehebowam dodoga lalaꞌi hige edi liba i lau watan na ya liba siꞌosiꞌololo lau lisidi. ");
INSERT INTO bxh_vpl VALUES ("K112_14","012_12_14","1KI","12","14","14","Ana hiti tataudi moho edi nuwatuhu ya lau watan. Ya liba iyen, Yau doga nuwa poꞌipoꞌi wananahana, hige doha tamagu! Tamagu paisowa mwahumwahudi ya felemiu na yau haba mwahumwahu wananahadi E felemiu! In balawa yai ya talamiu na yau haba seni yai E talamiu! ");
INSERT INTO bxh_vpl VALUES ("K112_15","012_12_15","1KI","12","15","15","Guyau ya fanuha bena doha ite ya tubu. Logena, Kin Lehebowam hige dodoga edi liba i lau watan be haba Guyau ena liba fasunuma Delebowam lisina yai, aniyona ya tubu doha Peloweta Ahaida ya libaen. ");
INSERT INTO bxh_vpl VALUES ("K112_16","012_12_16","1KI","12","16","16","Isalaela dodogadi sa nuwatuhu lobahi kin hige i fanuha bena edi nuwatuhu i lau watan be sa faliba tiyen, Ai hige Desi natuna ye Deiwidi ana boga tefana! Ai hige ena sulu dodogadi! Isalaela dodogada ta fuyo eda nuꞌu, Deiwidi laulauwewena haba ena dodoga ya ita watanidi! Yo fede Isalaela dodogadi sa fuyo hasa edi nuʼu. ");
INSERT INTO bxh_vpl VALUES ("K112_17","012_12_17","1KI","12","17","17","In moho, Isalaela dodogadi salumadi sa miyamiya Diuda taondi yai, Lehebowam hola ya itaꞌita watanidi. ");
INSERT INTO bxh_vpl VALUES ("K112_18","012_12_18","1KI","12","18","18","Isalaela dodogadi, kin ya duidi be pele yai sa paipaisowa. Tau itaꞌita watanidi mate taumoho hudoꞌi hesana Adonilam. Kin Lehebowam taumoho te, ya fatamali lawen Isalaela lebedi bena sidohana haba ya fafuyodima ena ita wata ganahewana yai. In moho sa lau umeheꞌui be ya peꞌi. Lehebowam feula ya gelu ena saliyoti yai be ya fuyo Yelusalem. ");
INSERT INTO bxh_vpl VALUES ("K112_19","012_12_19","1KI","12","19","19","Fuyanna yai ya laoma ee–, aho ite, Isalaela suludi tefa lidilidi yai yo Deiwidi laulauwewena sa faitole muli. ");
INSERT INTO bxh_vpl VALUES ("K112_20","012_12_20","1KI","12","20","20","Fuyanna Isalaela dodogadi sa atahiyen mate Delebowam Idipi yai ya fuyoma be sa yoga lawen edi aba faꞌoigogo yai be sa faꞌobiyo Isalaela suludi mahudoꞌidi edi kin. Sulu Diuda moho ya miya esegahi Deiwidi laulauwewena ena ita wata ganahewana yai. ");
INSERT INTO bxh_vpl VALUES ("K112_25","012_12_25","1KI","12","25","25","Nuꞌu piupiu hitidi Efalaim nuꞌuna yai, Kin Delebowam, Sekem taonna ganana ya faꞌobiyo na amainiya ya miya. Habahim ya aulaha ya lau be nuꞌu hesa hesana Penuweli ganana ya faꞌobiyodi. ");
INSERT INTO bxh_vpl VALUES ("K112_26","012_12_26","1KI","12","26","27","Fuya hesa Delebowam ya nuwanuwatuhu iyen, Isalaela dodogadi sa hasahasai Yelusalem edi ainauya sa anꞌantalasamedi Guyau ena Luma Tabuna yai na ibe sa fuyo Diuda dogana, Kin Lehebowam lisina, haba sidohana? Haba sa wunuigu na egu nuꞌu yai te, Lehebowam haba sa faꞌobiyo edi kin. ");
INSERT INTO bxh_vpl VALUES ("K112_28","012_12_28","1KI","12","28","28","Delebowam ena nuwatuhu ena tatau sibasibadi ya falibadi be sa ehe watawatan. Yo fede bulumakau nanatuna oitaudi luwaga gole yai ya ginaulidi. Habahim Isalaela ya falibadi, iyen, Ami laulau Yelusalem, fadebasae ana halulu mate edaꞌedana ya lofa. Aee–, Isalaela! Emi yaubada E ginaulidi, au laoma au fadebasaedi. Iti logedidi, Idipi yai sa foyahimiu. ");
INSERT INTO bxh_vpl VALUES ("K112_29","012_12_29","1KI","12","29","29","Bulumakau oitauna gole Beteli yai ya tole na hesa Dan yai, ");
INSERT INTO bxh_vpl VALUES ("K112_30","012_12_30","1KI","12","30","30","be ginaulidi te, sa famala heyaya, paꞌana dodoga sa laulauꞌuꞌula lau lisidi. Edaꞌeda ya lofa in moho sa lau Dan be sa lauꞌuꞌula lau hesa lebena. ");
INSERT INTO bxh_vpl VALUES ("K112_31","012_12_31","1KI","12","31","31","Delebowam piu yai aba lauꞌuꞌula ya lau ginauli hinaga na dodoga gaibu ya fasinabodi tau antalasam. In moho iti hige sulu Lewi. ");
INSERT INTO bxh_vpl VALUES ("K116_30","012_16_30","1KI","16","30","30","Omili natuna Ahaba laulau heyaheyayadi ya ginaulidi Yaubada matana yai. Hige sai hesa ena laulau doha. ");
INSERT INTO bxh_vpl VALUES ("K116_31","012_16_31","1KI","16","31","31","Ena laulau doha Delebowam. In moho ya diꞌo wananaha be ya falau maimaiti mate Sidon edi kin Etebaꞌala natuna Desabela ya fai hinaga, yo fede ya fatubu Baꞌala ya fadebasae. ");
INSERT INTO bxh_vpl VALUES ("K116_32","012_16_32","1KI","16","32","32","Samaliya yai dubu ya ginauli, Baꞌala enehena, ganahewana yai aba antalasam ya ginauli. ");
INSERT INTO bxh_vpl VALUES ("K116_33","012_16_33","1KI","16","33","33","Ahaba, hinaga Aselaha, oitauna duhuna ya bono be Isalaela, edi Guyau yo edi Yaubada ya famanabala. Paꞌana Isalaela edi kin mahudoꞌidi heyaya sa ginaulidi, mate sa lau fuyoma. Na in ya diꞌo wananaha. ");
INSERT INTO bxh_vpl VALUES ("K117_1","012_17_1","1KI","17","1","1","Tisibi dogana hesana Ilaidiya, Gileyada nuꞌuna yai ya gogogo, ya libalau Ahaba lebena iyen, E liba dudulai Isalaela edi Guyau yo edi Yaubada E fafadebasae matana yai mate haba bolima fisa ibege usa yo kipwala bwasuludi, ya lau ee–, ana sigana yau E liba. ");
INSERT INTO bxh_vpl VALUES ("K117_8","012_17_8","1KI","17","8","8","Habahim Guyau ya libalau Ilaidiya lisina. Iyen, ");
INSERT INTO bxh_vpl VALUES ("K117_9","012_17_9","1KI","17","9","9","Itete na u lau Selafata yai u miya, Sidon taonna sadaina yai. Hwabuhwabu hesa amainiya E faliba haba ya fakalahem. ");
INSERT INTO bxh_vpl VALUES ("K117_10","012_17_10","1KI","17","10","10","Yo fede Ilaidiya ya lau Selafata. Fuyanna ya mahano lau, hwabu oyagi ya tanotano gogo ya ita taon aba luhuluhu launa yai. Yo fede ya yoga lau lisina iyen, Aee–, ibe gonowana hoꞌowa begana huliu yai wa leyama be agu E nom. ");
INSERT INTO bxh_vpl VALUES ("K117_11","012_17_11","1KI","17","11","11","Ya laulau hoꞌowa ana halulu na ya yoga fuyo iyen, Aee–, fwalawa agu begana hinaga u abi. ");
INSERT INTO bxh_vpl VALUES ("K117_12","012_17_12","1KI","17","12","12","Hwabu ya libalau Ilaidiya lisina iyen, Wananaha Guyau em Yaubada ya mwahumwahuli na hesana yai E falibam mate hige agu fwalawa. Agu fwalawa ni, nima gogo esega yo oliwe masina begana wananaha fuhena yai. Oyagi E tanotano gogo te, bena E lau luma be ma natugu ama anꞌan ofiꞌofina E gabu be ꞌe an. Na mulina haba ꞌe miyamiya moho ee–, ꞌe peꞌi. ");
INSERT INTO bxh_vpl VALUES ("K117_13","012_17_13","1KI","17","13","14","In moho Ilaidiya ya libalau kaihwabu lisina iyen, Tabu u ꞌwasabu! Guyau Isalaela edi Yaubada ya liba iyen, “Fwalawa huliuna yo oliwe masina fuhena ibege i ofi ee–, Guyau usa ya leyama be tanohi ya faꞌwau!” Be u lau luma na somo wa libaen, u ginauli watan. Bwaiꞌibwaꞌina bena fwalawa agu begana wa ginauli. Habahim somo ota fahina begana, ma natum ami wa gabu. ");
INSERT INTO bxh_vpl VALUES ("K117_15","012_17_15","1KI","17","15","15","Yo fede ya lau luma be somo Ilaidiya ya faliba mate ya ginauli watan. Habahim, Ilaidiya yo waihin ma natuna, lahai ouꞌouli mate adi kalahe, ");
INSERT INTO bxh_vpl VALUES ("K117_16","012_17_16","1KI","17","16","16","doha haꞌa Guyau ya liba fasunuma Ilaidiya lisina yai fuyanna iyen, Fwalawa huliuna yo oliwe masina fuhena ibege ti ofi. ");
INSERT INTO bxh_vpl VALUES ("K117_17","012_17_17","1KI","17","17","17","Fuya hesa, waihin ni natuna ya lepa. Ana lepa ya falaꞌi be ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("K117_18","012_17_18","1KI","17","18","18","Yo fede ya libalau Ilaidiya lisina iyen, Aee–, um Yaubada ena peloweta! Sidohana be wa ginauli doha ite lisigu yai? Wa laoma ite bena egu heyaya wa faꞌitagu logena natugu wa wunui? ");
INSERT INTO bxh_vpl VALUES ("K117_19","012_17_19","1KI","17","19","19","Na Ilaidiya ya libalau lisina iyen, Natum u leyama. Ilaidiya gwama wa, silanna ya abi hwabu nimana yai be ya hasaen bili, be ya faꞌota lidiyen Ilaidiya ena aba enoꞌeno yai. ");
INSERT INTO bxh_vpl VALUES ("K117_20","012_17_20","1KI","17","20","20","Habahim ma alina laꞌilaꞌina ya lauꞌuꞌula lau Guyau lisina iyen, Aee–, Guyau, egu Yaubada! Sidohana be hwabu te wa fakamkamna? Ya tauꞌulu be lebena yai E miya, na aho natuna wa kamfunuhi be ya peꞌi? ");
INSERT INTO bxh_vpl VALUES ("K117_21","012_17_21","1KI","17","21","21","Yo fede Ilaidiya, silan ya hoba tawan ma faihona, na ya tan Guyau lisina iyen, Aee–, Guyau, egu Yaubada! Gwama te u famwahuli fuyoi. ");
INSERT INTO bxh_vpl VALUES ("K117_22","012_17_22","1KI","17","22","22","Guyau mate Ilaidiya ena tan ya atahi yo fede gwama ya mwahuli fuyo, ");
INSERT INTO bxh_vpl VALUES ("K117_23","012_17_23","1KI","17","23","23","be Ilaidiya ya bahe lidiyen tinana ya felen, na iyen, Wa ita. Natum ya mwahuli! ");
INSERT INTO bxh_vpl VALUES ("K117_24","012_17_24","1KI","17","24","24","Waihin ya libalau Ilaidiya lisina iyen, Aho te E siba um Yaubada ena peloweta be somo wa libalibaedi mate wananaha Guyau ya libalibawa lisim. ");
INSERT INTO bxh_vpl VALUES ("K118_1","012_18_1","1KI","18","1","2","Fuya ya lofa hige i usa na guliyam laꞌilaꞌi Samaliya yai. Boliman fafaihonana yai Guyau ya libalau Ilaidiya lisina iyen, U lau Kin Ahaba u failobahi na usa haba E fatamaliyawa tanohi. Yo fede Ilaidiya ya lau kin Ahaba ya failobahi. ");
INSERT INTO bxh_vpl VALUES ("K118_17","012_18_17","1KI","18","17","17","Fuyanna Ahaba, Ilaidiya ya ita, mate ya libalau lisina, iye, Um logem pilipili wa laulau ginauli Isalaela nuꞌuna yai? ");
INSERT INTO bxh_vpl VALUES ("K118_18","012_18_18","1KI","18","18","18","Ilaidiya, Ahaba alinana ya bui iye, Yau hige pilipili hesa Isalaela yai ya ginauli. Um yo tamam maꞌana boga moho pilipili ami ginaginaulidi. Guyau ena laugagayo hige au famuli watanidi yo ami laulauꞌuꞌula lau Baꞌala oitaudi lisidi. ");
INSERT INTO bxh_vpl VALUES ("K118_19","012_18_19","1KI","18","19","19","Aho te, Isalaela dodogadi mahudoꞌidi u yoga gogondima Kameli ai Tuꞌana. Baꞌala ena peloweta ouꞌoulidi 450 yo Aselaha ena peloweta 400, mate Desabela ena hatahata yai sa kalakalahe, u ledima. ");
INSERT INTO bxh_vpl VALUES ("K118_20","012_18_20","1KI","18","20","20","Yo fede Ahaba liba ya fatamali lawen Isalaela nuꞌuna mahudoꞌina be dodoga mahudoꞌidi yo peloweta sa faꞌoigogoma Kameli Tuꞌana yai. ");
INSERT INTO bxh_vpl VALUES ("K118_21","012_18_21","1KI","18","21","21","Habahim Ilaidiya dodoga matadi yai ya obiyo na iyen, Nuwamiu hige au fadosidi feufeulaidi, paꞌana nuwatuhu luwaga sa faiꞌabi ganahewamiu yai. Yena Guyau, in Yaubada, beti au famuli watan; na yena Baꞌala, in yaubada, beti au famuli watan! In moho, dodoga hige somo ti libaen. ");
INSERT INTO bxh_vpl VALUES ("K118_22","012_18_22","1KI","18","22","22","Yo fede Ilaidiya ya libalau lebedi iyen, Yau Guyau ena peloweta, ibogu moho E miyamiya, na Baꞌala ena peloweta ouꞌoulidi 450. ");
INSERT INTO bxh_vpl VALUES ("K118_23","012_18_23","1KI","18","23","23","Bulumakau tamoꞌana luwaga au ledima lebemai. Baꞌala ena peloweta haba bulumakau esega sa abi be sa wunui. Ai mulina haba sa nigohi be sa faꞌota oyagi ai hewadi, antalasam aba gabuna katakatanna yai, in moho oyagina tabu ti yufi. Bulumakau hesa haba yau E abi nonohai be ai oyagi hewana E faꞌota na oyagina ibege ya yufi hinaga. ");
INSERT INTO bxh_vpl VALUES ("K118_24","012_18_24","1KI","18","24","24","Habahim ami lauꞌuꞌula lau emi yaubada lisina na yau haba E lauꞌuꞌula lau egu Guyau lisina. Yaubada tau somo eda lauꞌuꞌula ya atahi be oyagi ya ala mate logenana yaubada wananahana. Yo fede dodoga mahudoꞌidi sa ehe watawatan. ");
INSERT INTO bxh_vpl VALUES ("K118_25","012_18_25","1KI","18","25","25","Habahim Ilaidiya ya libalau Baꞌala ena peloweta lisidi iyen, Ami ouli wananaha. Emi antalasam au ginauli bwaꞌiyen. Bulumakau hesa au abi nonohai. Tabu oyagina au yufi na au lauꞌuꞌula lau emi yaubada lisina. ");
INSERT INTO bxh_vpl VALUES ("K118_26","012_18_26","1KI","18","26","26","Yo fede bulumakau esega sa abi nonohai be sa tole antalasam aba gabuna katakatanna hewana yai, na hwalahwala sa lauꞌuꞌula lau Baꞌala lisina ya lau ee–, maimailafi. Sa lauꞌuꞌula ma alina laꞌilaꞌidi tiyen, Aee–, Baꞌala, ema lauꞌuꞌula te, u atahi! Antalasam aba gabuna katakatanna sa ginauli wa sa saga fataꞌiꞌili, in moho edi lauꞌuꞌula hige sai hesa buina i leyama. ");
INSERT INTO bxh_vpl VALUES ("K118_27","012_18_27","1KI","18","27","27","Maimailafina Ilaidiya ya fatubu ya lau faliuhwaꞌedi. Iye, Au lauꞌuꞌula laꞌilaꞌi! In yaubada wananaha! Bena somo i nuwanuwatuhui. Ye bena i mode ye i adau. Nuwana i eno, au fanohi! ");
INSERT INTO bxh_vpl VALUES ("K118_28","012_18_28","1KI","18","28","28","Yo fede sa lauꞌuꞌula ma alina laꞌilaꞌidi na edi abiꞌabi sa laulauwedi - baineti yai sa antomotomo fuyoꞌidi yo alahiya yai sa gwaligwali fuyoꞌidi ee–, ꞌwasinadi sa didi. ");
INSERT INTO bxh_vpl VALUES ("K118_29","012_18_29","1KI","18","29","29","Ma alina laꞌilaꞌidi sa lauꞌuꞌula ee–, maimailafi, na antalasam maihalana ya talai hige dagugu hesa, hige sai laꞌi edi lauꞌuꞌula i atahi. ");
INSERT INTO bxh_vpl VALUES ("K118_30","012_18_30","1KI","18","30","30","Habahim Ilaidiya dodoga ya yogaidi. Iye, Au laoma lebegu. Yo fede sa laoma lebena be Guyau ena antalasam katakatanna talotalopana, ya ginauli fuyoi, ");
INSERT INTO bxh_vpl VALUES ("K118_31","012_18_31","1KI","18","31","31","Habahim umeꞌehu safuhudohudoꞌi luwaga ya abidi. Umeꞌehu esega mate sulu esega - esega Isalaela ganahewana yai fafaꞌilalana. Sulu te mate Iyakobo nanatuna hesadi. Na In mate hesana hesa Guyau ya tole: Isalaela. ");
INSERT INTO bxh_vpl VALUES ("K118_32","012_18_32","1KI","18","32","32","Umeꞌehu te lisidi yai, antalasam aba gabuna katakatanna ya ginauli. Ya famala Guyau hesana aba faꞌatitiyenna. Habahim dulein ya sala, antalasam aba gabuna katakatanna ya fataꞌiꞌili, gonowana hoꞌowa laꞌina 15 lita ainiya sa fagoi. ");
INSERT INTO bxh_vpl VALUES ("K118_33","012_18_33","1KI","18","33","33","Oyagi ya fataꞌu antalasam katakatanna hewana yai. Habahim bulumakau ya nigohi be ya toledi oyagi hewadi yai na iye, Hoꞌowa au yahi be huliu lalaꞌi fati au famohafudi, na ai huliu ami yahidi be ami fagoi lawen antalasam ma oyagina ai hewadi. ");
INSERT INTO bxh_vpl VALUES ("K118_34","012_18_34","1KI","18","34","34","Ya falibadi iyen, Au yahi boda be ai huliu au fagoi! Be sa ginauli fuyoi. Fafaihonana ya liba iye, Au ginauli fuyoi! Be sa ginauli ma faihona. ");
INSERT INTO bxh_vpl VALUES ("K118_35","012_18_35","1KI","18","35","35","Hoꞌowa ya didi lidi be katakatan hoꞌowa ya siꞌu fataꞌiꞌili be dulein ya famohafu. ");
INSERT INTO bxh_vpl VALUES ("K118_36","012_18_36","1KI","18","36","36","Maimailafina, antalasam maihalana yai, peloweta Ilaidiya ya lau katakatan sadaina yai be ya lauꞌuꞌula. Iyen, Aee–, Abelaham, Isako yo Iyakobo edi Yaubada! Aho ite bena wa famahata wananahaim mate um Isalaela edi Yaubada yo hinaga u famahata mate yau em tau paisowa. Ginauli mahudoꞌina wa falibagu be E ginaulidi hinaga bena wa famahatadi. ");
INSERT INTO bxh_vpl VALUES ("K118_37","012_18_37","1KI","18","37","37","Aee–, egu lauꞌuꞌula te u atahi! Haba dodoga sa siba, mate um Guyau Yaubada yo, nuwadi wa buidi, um lisim yai. ");
INSERT INTO bxh_vpl VALUES ("K118_38","012_18_38","1KI","18","38","38","Maꞌesega na, Guyau ena oyagi alaꞌalana galewa yai ya lidima be bulumakau, oyagi, umeꞌehu yo tanohi, ya gabu faꞌofinidi yo hoꞌowa duleinna, hinaga ya tofi faguma. ");
INSERT INTO bxh_vpl VALUES ("K118_39","012_18_39","1KI","18","39","39","Fuyanna dodoga mahudoꞌidi laulau te sa ita mate, sa hoba lidi tanohi yai na sa tantan tiyen, Wananaha, Guyau, In Yaubada! Guyau, In Yaubada! ");
INSERT INTO bxh_vpl VALUES ("K118_40","012_18_40","1KI","18","40","40","Na Ilaidiya ya libalau lisidi iyen, Baꞌala ena peloweta au tohaidi, tabu laꞌi au falau! Yo fede dodoga wa Baꞌala ena peloweta mahudoꞌidi sa tohaidi, be Ilaidiya ya foya lidiyedi Kison Gonna yai be amainiya sa wunuidi. ");
INSERT INTO bxh_vpl VALUES ("K118_41","012_18_41","1KI","18","41","41","Na Ilaidiya ya libalau Ahaba lisina iyen, Usa laꞌilaꞌi ya laolaoma daguguna E atahi. U lau somo am u an yo u nom. ");
INSERT INTO bxh_vpl VALUES ("K118_42","012_18_42","1KI","18","42","42","Yo fede kin Ahaba ya lau ya anꞌan, yo somo ana ya nom, na Ilaidiya mate ya hasai Kameli Tuꞌana yai be ya dulu lidi tanohi yai. Kuluna ya tole tulina luwaga solasoladi yai, na ya lauꞌuꞌula. ");
INSERT INTO bxh_vpl VALUES ("K118_43","012_18_43","1KI","18","43","43","Habahim ena tau paisowa ya faliba iyen, U leu be gabogabo u ita. Yo fede ya leu be ya itaꞌita lau gabogabo yai. Na ya fuyom Ilaidiya ya faliba iyen, Hige somo hesa ya ita amainiya. Ilaidiya ena tau paisowa ya dui fuyoi be gabogabo ya kepai ma faligigi luwaga. ");
INSERT INTO bxh_vpl VALUES ("K118_44","012_18_44","1KI","18","44","44","Ya fuyoma, iyen, Yada kiukiu, laꞌina doha doga nimana, gabogabo yai ya pohe hasaema E ita. Yo fede Ilaidiya ya faliba iye, U lau Kin Ahaba u faliba uwe, “Usa ibe i eli buluhim be em ai saliyoti u awa u lidi.” ");
INSERT INTO bxh_vpl VALUES ("K118_45","012_18_45","1KI","18","45","45","Hige walolona, galewa ya faduba. Hwayahwayau ya fatubu ya towa yo ya usa laꞌilaꞌi. Na Kin Ahaba ena saliyoti yai ya awa be ya lau Desilili nuꞌuna. ");
INSERT INTO bxh_vpl VALUES ("K118_46","012_18_46","1KI","18","46","46","Ilaidiya ena adidili Guyau lisina yai ya abi, be ana luhuluhu ya abi hitin. Ya faluhu noꞌunoꞌu lawen ana bwaꞌulu yai na ya lautafotafo, be Ahaba ena saliyoti ya famuli, na ya bwaꞌi ya lau Desilili nuꞌuna. ");
INSERT INTO bxh_vpl VALUES ("K119_1","012_19_1","1KI","19","1","1","Ahaba ya mahano luma yai, Ilaidiya ginauli mahudoꞌina ya ginauli wasadi Desabela ena ya dede. Habahim ena ya liba komakoman, sidohana Baineti yai Baꞌala edi peloweta mahudoꞌina ena wunuwunuidi. ");
INSERT INTO bxh_vpl VALUES ("K119_2","012_19_2","1KI","19","2","2","Be Desabela wasa tau lawenna ya dui ya lau Ilaidiya lisina, iyen, Bobon maihala doha ite yau haba E wunuim doha peloweta wa wunuidi. Yena yau hige ya ginauli, yaubada hahaisa haba sa fakamkamnagu yo hinaga sa wunuigu. ");
INSERT INTO bxh_vpl VALUES ("K119_3","012_19_3","1KI","19","3","3","Ilaidiya ya ꞌwasabu be ya gela ya lau Belesiba, mwahulina debana yai. Diuda Nuꞌuna yai ya mahano be amainiya ena tau paisowa ya lau afulen. ");
INSERT INTO bxh_vpl VALUES ("K119_4","012_19_4","1KI","19","4","4","Na lahai esega ya lawen ee–, ya mahano nuꞌu pitapitalina yai, yo fede, ya lau oyagi kiukiu hesana uyaꞌuya ubuna yai ya taꞌai, na ya anꞌeta bena ya peꞌi. Iyen, Guyau, Yau aꞌai! Egu mwahuli u abifahi aho te, paꞌana yau doha afa wahagu hige ai loholoho. ");
INSERT INTO bxh_vpl VALUES ("K119_5","012_19_5","1KI","19","5","5","Yo fede ya eno lidi. Ma esega na anelu ya abiꞌona, na ya faliba iyen, U obiyo be u anꞌan. ");
INSERT INTO bxh_vpl VALUES ("K119_6","012_19_6","1KI","19","6","6","Ya mainene taꞌiꞌili na kuluna sadaina yai fwalawa tegategana maniꞌo yai sa gabu yo ile ma hoꞌowana sa otaꞌota ya itadi. Yo fede ya anꞌan yo hoꞌowa ana ya nom na ya eno fuyo. ");
INSERT INTO bxh_vpl VALUES ("K119_7","012_19_7","1KI","19","7","7","Habahim Guyau ena anelu ya fuyoma ya abiꞌona fuyoi na ya faliba iyen, U obiyo be fwalawa am hesa u an. Em adau te ya lofa. ");
INSERT INTO bxh_vpl VALUES ("K119_8","012_19_8","1KI","19","8","8","Yo fede ya obiyo ya anꞌan yo hoꞌowa ana ya nom. Ya adidili be lahai 40 yo iꞌipa 40 ya lawen ee–, ya mahano Sainai Tuꞌana yai. Tuꞌana mate Yaubada ena tuꞌa. ");
INSERT INTO bxh_vpl VALUES ("K119_9","012_19_9","1KI","19","9","9","Maihonana ya lau duyufi yai ya eno. 1 Kin 19:9-18 Habahim Guyau ya faliba iyen, Ilaidiya, somo amaiteꞌi wa ginaginauli? ");
INSERT INTO bxh_vpl VALUES ("K119_10","012_19_10","1KI","19","10","10","Ilaidiya Guyau alinana ya bui iyen, Gigibwali Yaubadana, fuya ouꞌouli um moho em E paisowa. Isalaela dodogadi em yali otaꞌota fahina sa ꞌwaiyoꞌoꞌen, em antalasam katakatandi sa dem fahifahidi yo em peloweta sa wunuidi. Yau ibogu moho, na aho te bena sa wunuigu hinaga. ");
INSERT INTO bxh_vpl VALUES ("K119_11","012_19_11","1KI","19","11","11","Yo fede Guyau iyen, U lau u obiyo ai matagu paꞌana haba E bayawa. Ilaidiya ya obiꞌobiyo na Guyau ya bayawa, yo fede hwayahwayau adiꞌadidilina ya towa lau oya yai be ya lubi dailidi yo umeꞌehu ya lubi gisigisidi. In moho Guyau hige hwayahwayau ganahewana yai. Hwayahwayau mulina yai mate mwanuꞌunuꞌu, na Guyau hige mwanuꞌunuꞌu ganahewana yai hinaga. ");
INSERT INTO bxh_vpl VALUES ("K119_12","012_19_12","1KI","19","12","12","Mwanuꞌunuꞌu mulina yai, oyagi alaꞌalana, in moho Guyau hinaga hige oyagi alaꞌalana ganahewana yai. Oyagi alaꞌalana mulina yai, faꞌatu fenafena daudaumwalina, ");
INSERT INTO bxh_vpl VALUES ("K119_13","012_19_13","1KI","19","13","13","Ilaidiya ya atahi. Yo fede ana luhuluhu ya solu hitiꞌi be nenena ya fakou, na ya lau duyufi aba luhuluhu launa yai ya obiyo. Habahim alina hesa ya atahi iyen, Ilaidiya, somo amaiteꞌi wa abiꞌabiꞌi? ");
INSERT INTO bxh_vpl VALUES ("K119_14","012_19_14","1KI","19","14","14","Ilaidiya iyen, Gigibwali Yaubadana, fuya ouꞌouli um moho em E paipaisowa. In moho Isalaela dodogadi em yali otaꞌota fahina sa ꞌwaiyoꞌoꞌen yo em antalasam katakatandi sa dem fahifahidi na em peloweta baineti yai sa wunuidi. Yau ibogu moho na aho te hinaga bena sa wunuigu! ");
INSERT INTO bxh_vpl VALUES ("K119_15","012_19_15","1KI","19","15","15","Guyau ya faliba iyen, U fuyo em aba laoma yai be u lau nuꞌuna pitapitalina hesa Damaseko sadaina yai. Yena wa mahano, oliwe masina u abi be u fagoi Hasaela ai boluboluna. Haba ya famala Siliya edi kin. ");
INSERT INTO bxh_vpl VALUES ("K119_16","012_19_16","1KI","19","16","16","Yo Nimsi natuna, Dehu boluboluna yai hinaga u fagoi. Haba ya famala Isalaela edi kin, yo Safata natuna Ilaisa, Abela Mehola dogana ai boluboluna hinaga u fagoi. Haba ya lau fadamahim, in peloweta. ");
INSERT INTO bxh_vpl VALUES ("K119_17","012_19_17","1KI","19","17","17","Yena sai hesa Hasaela lebena yai ya gela, Dehu haba ya wunui, na salumadi Dehu lebena yai sa gela, Ilaisa haba ya wunuidi. ");
INSERT INTO bxh_vpl VALUES ("K119_18","012_19_18","1KI","19","18","18","Na Isalaela ouꞌoulidi 7,000, - salumadi hige ti laulauꞌuꞌula lau Baꞌala lisina e oitaudi haisa lisidi. ");
INSERT INTO bxh_vpl VALUES ("K119_19","012_19_19","1KI","19","19","19","Ilaidiya amainiya ya lau Safata natuna, Ilaisa ya lobahi, gabu laꞌilaꞌina yai tanohi ya giyagiyali. Gabuna yai mate tatau safuhudohudoꞌi luwaga, taumoho esega - esega ena bulumakau luwaga gabu yai sa paipaisowa. Bulumakau ofiꞌofidi luwaga maꞌedi Ilaisa sa mulimulita. Ilaidiya ya lau lebena be ana luhuluhu ya pei lawen Ilaisa dabayalona yai. ");
INSERT INTO bxh_vpl VALUES ("K119_20","012_19_20","1KI","19","20","20","Yo fede ena bulumakau ya lau afuledi na Ilaisa ya tafo watan na iyen, Hola ya lau tinagu yo tamagu ya falafudi yo ya lau aiyoniyedi habahim E lau watanim. Ilaidiya ya libalau Ilaisa lisina, iye, U fuyo, in moho somo E ginauli lebem yai, mate u nuwanuwatuhui. ");
INSERT INTO bxh_vpl VALUES ("K119_21","012_19_21","1KI","19","21","21","Habahim Ilaidiya ya lau, na Ilaisa ana bulumakau ya abidi be ya wunuidi. Aba giyagiyali oyagina yai, oyagi ya yufi be bulumakau amainiya ya gabudi be dodoga ya feledi sa andi. Habahim Ilaidiya ya famuli watan be ya famala ena tau paisowa. ");
INSERT INTO bxh_vpl VALUES ("K22_1","013_2_1","2KI","2","1","1","Fuyanna Guyau bena haba Ilaidiya ya abi hasaꞌen galewa bwai filifili yai, mate Ilaidiya maꞌena Ilaisa Giligala nuꞌuna sa lau afulen, na sa laoma edaꞌeda yai. ");
INSERT INTO bxh_vpl VALUES ("K22_2","013_2_2","2KI","2","2","2","Ilaidiya ya libalau Ilaisa lisina iyen, Aiteꞌi u miya. Guyau ya duigu bena E lau Beteli. Na Ilaisa iyen, Wananaha, Guyau ya mwahumwahuli, yo hesana yai, wa mwahuli hinaga, be ibege ya lau afulem. Yo fede maꞌena sa lau Beteli. ");
INSERT INTO bxh_vpl VALUES ("K22_3","013_2_3","2KI","2","3","3","Peloweta baiwadi Beteli yai sa miyamiya sa laoma Ilaidiya lisina be sa fatiꞌoi, tiyen, Wa sibai, aho te Guyau haba em baꞌisa Ilaidiya ya abi hudoꞌiyen ai lisim? Na Ilaisa iyen, Ii–, E sibai. In moho tabu au libalibaen. ");
INSERT INTO bxh_vpl VALUES ("K22_4","013_2_4","2KI","2","4","4","Habahim Ilaidiya ya libalau Ilaisa lisina iyen, Ilaisa aiteꞌi u miyamiya. Guyau ya duigu bena E lau Diyeliko. Na Ilaisa iyen, Wananaha, Guyau ya mwahumwahuli, yo In hesana yai, um wa mwahumwahuli hinaga, be ibege ya lau afulemiu. Yo fede maꞌena sa lau Diyeliko. ");
INSERT INTO bxh_vpl VALUES ("K22_5","013_2_5","2KI","2","5","5","Peloweta pelena Diyeliko yai sa miyamiya mate sa laoma sa fatiꞌoi tiyen, Wa sibai, Aho te, ai lisim, Guyau haba em Baꞌisa, ya lawe hudoꞌiyen? Na Ilaisa iyen, Moꞌisa, E siba, in moho tabu au libalibaen. ");
INSERT INTO bxh_vpl VALUES ("K22_6","013_2_6","2KI","2","6","6","Habahim Ilaidiya ya faliba iyen, U miyamiya aiteꞌi. Guyau ya duigu bena E lau Diyodan. Na Ilaisa iyen, Wananaha Guyau ya mwahumwahuli, yo hesana yai, um wa mwahumwahuli hinaga, be ibege ya lau afulem. Yo fede tataudi luwaga sa lau. ");
INSERT INTO bxh_vpl VALUES ("K22_7","013_2_7","2KI","2","7","7","Peloweta pelena, ouꞌoulidi 50 sa lau be sa obiꞌobiyo, begana aꞌawadi ya lofa, na sa sana lau Ilaidiya yo Ilaisa lebedi, sa obiꞌobiyo Diyodan Hoꞌowana sadaina yai. ");
INSERT INTO bxh_vpl VALUES ("K22_8","013_2_8","2KI","2","8","8","Ilaidiya ana luhuluhu ya kamfahi be ya noꞌu, habahim hoꞌowa yai ya oiyen yo fede hoꞌowa ya tamo daili be tanohi pitapitalina yai tataudi luwaga sa dohe tefa. ");
INSERT INTO bxh_vpl VALUES ("K22_9","013_2_9","2KI","2","9","9","Fuyana sa mahano tefa yai, Ilaidiya ya libalau Ilaisa lisina iyen, Somo wa fanuha, u falibagu, haba E ginauli, enehem, na habahim Guyau ya lawe hudoꞌiyegu. Yo fede Ilaisa ena bui ya felen iyen, Em adidili yo gigibwali, Yaubada ya felem, tefana u felegu yo ai hewana Yaubada ena namanamali, yo ginauli mahudoꞌina lisim yai u felegu. Doha taumoho natuna tau baguna, gogo mahudoꞌina ya felen aiʼena. Be haba E falau damahim peloweta edi baꞌisa. ");
INSERT INTO bxh_vpl VALUES ("K22_10","013_2_10","2KI","2","10","10","Ilaidiya iyen, Ginauli poꞌipoꞌina wa anꞌetai. Yena Guyau wa ita, ya abifahigu lebem yai, somo wa anꞌetai, haba ya felem. Na yena hige u ita, somo wa anꞌetai ibege i felem. ");
INSERT INTO bxh_vpl VALUES ("K22_11","013_2_11","2KI","2","11","11","Edaꞌeda yai sa laulau libaliba, ma esega na, hosi ma oyagi alaꞌalana yo saliyoti ma oyagi alaꞌalana sa taumahata Ilaidiya maꞌena Ilaisa atiꞌatipudi yai be sa dailidi. Na Guyau bwai filifili yai Ilaidiya ya hasaꞌen galewa. ");
INSERT INTO bxh_vpl VALUES ("K22_12","013_2_12","2KI","2","12","12","Ilaisa laulau te ya ita mate ya tan ꞌwalaꞌwalawui, iyen, Tamagu! Tamagu! Isalaela edi saliyoti yo hosi tau awaidi E itadi! Na matana yai ya tauyamuhi be hige i ita fuyoi. Yo fede ana luhuluhu ya kamgigi luwagai. ");
INSERT INTO bxh_vpl VALUES ("K22_13","013_2_13","2KI","2","13","13","Fuyana Guyau Ilaidiya ya hasaꞌen galewa, In ana luhuluhu ya beꞌu lidi tanohi yai. Na Ilaisa luhuluhuna ya abi hitin, na ya fuyo Diyodan Hoꞌowana sadaina yai ya obiyo. ");
INSERT INTO bxh_vpl VALUES ("K22_14","013_2_14","2KI","2","14","14","Na luhuluhu ya oiyen hoꞌowa yai, na ya liba iyen, Guyau, Ilaidiya ena Yaubada somo yai? Yo fede, fuyanna luhuluhu hoꞌowa yai, ya faʼoiyen, hoꞌowa ya tamo daili luwagai be ya dohe tefa. ");
INSERT INTO bxh_vpl VALUES ("K22_15","013_2_15","2KI","2","15","15","Peloweta pelena ouꞌoulina 50 Diyeliko yai, hola otadi tefa yai sa maimainenei tiyen, Gigibwali, Ilaidiya lisina yai mate Ilaisa haꞌa ya abi. Yo fede sa lau sa failobahi, nuwanuwana yai sa tuli bono na sa dulu tanohi yai, ");
INSERT INTO bxh_vpl VALUES ("K22_16","013_2_16","2KI","2","16","16","Na tiyen, Ouꞌoulimai 50 na E adidili. U laliyemai be, ai lau em baꞌisa ai yoꞌoi. Nuwana Guyau Yaluwana Ilaidiya ya abi hitiʼi, be ya lawen tuꞌa e gunuwala haisa amaniya i faꞌota lidiyen. Ilaisa edi bui ya feledi iyen, Higeꞌe, tabu au lau. ");
INSERT INTO bxh_vpl VALUES ("K22_17","013_2_17","2KI","2","17","17","Na sa eli dududuꞌi ee–, ya taumayamaya, be hige gonowana i gududi. Yo fede iyen, Au lau. Be tatau 50 sa duidi sa lau sa yoꞌoi ee–, lahai faihona sa ofi, na hige ti lobahi. ");
INSERT INTO bxh_vpl VALUES ("K22_18","013_2_18","2KI","2","18","18","Ilaisa mate Diyeliko yai ya miyamiya na fuyanna sa fuyoma ya falibadi iyen, Doha haꞌa E falibamiu yawa, “Tabu au lau.” ");
INSERT INTO bxh_vpl VALUES ("K24_8","013_4_8","2KI","4","8","8","Fuya hesa Ilaisa ya lau Sunem. Amainiya mate waihin fafagogona hesa ya miyamiya, ya liba be Ilaisa ya laoma ya kalahe ena luma yai be yena fuya hesa ya fuyo haba ainiya ya anꞌan. ");
INSERT INTO bxh_vpl VALUES ("K24_9","013_4_9","2KI","4","9","9","Waihin ya libalau lahuna lisina iyen, E siba taumoho ya laolaoma te, Yaubada ena fatabu dogana. ");
INSERT INTO bxh_vpl VALUES ("K24_10","013_4_10","2KI","4","10","10","Haga bili kiukiu ai luma hewana ta ginauli be aba enoꞌeno, na hatahata, aba taꞌataꞌai yo lampa te toledi be taumohona yena ya laoma haba ainiya ya miya. ");
INSERT INTO bxh_vpl VALUES ("K24_11","013_4_11","2KI","4","11","11","Fuya hesa Ilaisa ya fuyo Sunem. Ya hasai ena bili be ya eno. ");
INSERT INTO bxh_vpl VALUES ("K24_14","013_4_14","2KI","4","14","14","Muli yai Ilaisa ya fatiꞌo lau ena tau paisowa Gehasi lisina, iyen, Somo haba E ginauli, enehena? Gehasi iyen, Hige natuna, yo lahuna ya tautaulaꞌi. ");
INSERT INTO bxh_vpl VALUES ("K24_15","013_4_15","2KI","4","15","15","Ilaisa iyen, U yogaiyama. Yo fede ya yogai na ya laoma be Ilaisa ena bili aba luhuluhu launa yai ya obiyo. ");
INSERT INTO bxh_vpl VALUES ("K24_16","013_4_16","2KI","4","16","16","Ilaisa ya libalau waihin lisina iyen, Bolima hesa, maihalana doha ite haba natum wa labalabai. Na waihin wa Ilaisa alinana ya bui iyen, Egu baꞌisa, higeꞌe! Um Yaubada ena peloweta be tabu em tau paisowa u bwalai! ");
INSERT INTO bxh_vpl VALUES ("K24_17","013_4_17","2KI","4","17","17","In moho ya fawananaha mate waihin ya boga doha haꞌa bolimanna Ilaisa ya libaen mate maihalana yai natuna ya yosi. ");
INSERT INTO bxh_vpl VALUES ("K24_42","013_4_42","2KI","4","42","42","Taumoho hesa Baꞌala-Salisa taonna yai ya laoma. Bali anaho bwaꞌibwaꞌidi yai fwalawa sa gabudi mate 20 ya abidi, yo bali tumadi hinaga ya abidi, be ya ledima, Ilaisa ana ya felen. Yo fede Ilaisa ya libalau ena tau paisowa lisina, iyen, Dodoga u feledi ti andi. ");
INSERT INTO bxh_vpl VALUES ("K24_43","013_4_43","2KI","4","43","43","Na tau lau fayofayo ya liba iyen, Ii–yui, kalahe te hige dodoga 100 gonowadi. Ilaisa alinana ya bui iyen, Guyau ya liba iyen, “Haba sa anꞌan ee–, bogadi sa yahayaha na ota fahidi u feledi.” ");
INSERT INTO bxh_vpl VALUES ("K24_44","013_4_44","2KI","4","44","44","Yo fede tau lau fayofayo, kalahe dodoga ya feledi sa andi. In moho sa an toledi doha haꞌa Guyau ya libaen. ");
INSERT INTO bxh_vpl VALUES ("K25_1","013_5_1","2KI","5","1","1","Neimani mate Siliya edi kin ena tau hiyala tau lau kulukuluwendi yo nuwanuwa adiꞌadidilina. Guyau ya saguhi be Siliya dodogadi adi waiyunu sa lei hafihafitidi. Siliya edi kin ya ita falaꞌi be ya faꞌatitiyen. In moho ya lepela. ");
INSERT INTO bxh_vpl VALUES ("K25_2","013_5_2","2KI","5","2","2","Beyabeyana tau hiyala Siliya nuꞌuna sa lau afulen sa lau Isalaela sa duhu mahanoꞌidi na tineꞌeu hesa sa tohai be sa lawen Neimani lahuna lebena be ya famala ena tau lau fayofayo. ");
INSERT INTO bxh_vpl VALUES ("K25_3","013_5_3","2KI","5","3","3","Muli yai tineꞌeu Neimani lahuna ya faliba iyen, Ibe moho egu baꞌisa ya lau peloweta ya ita Samaliya yai haba ya faloholoho. ");
INSERT INTO bxh_vpl VALUES ("K25_9","013_5_9","2KI","5","9","9","Yo fede Neimani ena hosi yo saliyoti yai ya lau Ilaisa ena luma edaꞌedana hafohafona yai ya obiyo. ");
INSERT INTO bxh_vpl VALUES ("K25_10","013_5_10","2KI","5","10","10","Ilaisa ena tau paisowa ya dui lawen Neimani lisina, be ya faliba, iyen, U lau Diyodan Hoꞌowana be u kaisum ma faligigi luwaga, haba ꞌwapim ya mwafo na wa loholoho. ");
INSERT INTO bxh_vpl VALUES ("K25_11","013_5_11","2KI","5","11","11","Neimani ma manabalana ya lau na iyen, Guyau ena Yaubada hesana yai yo haba nimana ya lau hitiniyama bonugu hewana yai be ya faloholohogu. ");
INSERT INTO bxh_vpl VALUES ("K25_12","013_5_12","2KI","5","12","12","Damaseko taon hoꞌowadi, Abani yo Fahapa mate sa loholoho wananaha habahim Isalaela hoꞌowadi. Ibe Damaseko hoꞌowadi yai E kaisugu haba E loholoho. Yo fede ya timuli bui be ma manabalana ya lau. ");
INSERT INTO bxh_vpl VALUES ("K25_13","013_5_13","2KI","5","13","13","Neimani ena tau lau fayofayo sa laoma lisina tiyen, Baꞌisa! Ibe peloweta ya falibam ginauli laꞌilaꞌi hesa wa ginauli, haba wa ginauli. Be yena Peloweta iyen, “U lau u kaisum be u aꞌa,” bena moho ena liba wa lau watan. ");
INSERT INTO bxh_vpl VALUES ("K25_14","013_5_14","2KI","5","14","14","Yo fede Neimani Yaubada ena peloweta alinana ya lau watan be ya lidi Diyodan Hoꞌowana yai ya topu lidi ma faligigi luwaga. Yo fede Neimani ꞌwapina ya sabusabu doha hewali ꞌwapina na ya loholoho. ");
INSERT INTO bxh_vpl VALUES ("K25_15","013_5_15","2KI","5","15","15","Habahim Neimani maꞌena ena tatau sa fuyo Yaubada ena peloweta Ilaisa lisina. Neimani ya obiyo Ilaisa nuwanuwana yai na iyen, Aho te E siba tanoꞌubu mahudoꞌina yai, Isalaela edi Yaubada ibona Yaubada! Yau em tau lau fayofayo! Logena egu ainauya te u abi. ");
INSERT INTO bxh_vpl VALUES ("K25_16","013_5_16","2KI","5","16","16","Alinana Ilaisa ya bui iyen, Wananaha Guyau ya mwahumwahuli! Yau ena tau paisowa be hesana yai E liba ibege ainauya hesa ya abi. Neimani ya dudui bena ainauya ya abi na Ilaisa ya ꞌwaiyoꞌo wananaha. ");
INSERT INTO bxh_vpl VALUES ("K25_17","013_5_17","2KI","5","17","17","Be Neimani iyen, Ite mulina, antalasam gabugabudi yo antalasam hahaisa haba E lau ginauli Guyau ai lisina moho, ibege yaubada hesa ai lisina. Egu ainauya hige u abi be i otawa na aee–, Isalaela tanohina moho egu u felegu ya lawen, laꞌina mate miule luwaga gonowadi sa bahei. ");
INSERT INTO bxh_vpl VALUES ("K25_18","013_5_18","2KI","5","18","18","In moho, ginauli hesa moho Guyau lisina yai, bena egu heyaya ya nuwatuhu afulen. Egu kin E faꞌatitiyen. Debana yai E saguhi be maꞌegu ꞌe luhu ena yaubada bwalabwala Limon ena dubu yai lauꞌuꞌula ana halulu. Bena ya tuli bono mate, ma luwaluwagamai ꞌe tuli bono paꞌana ya guna fesasa nimagu yai. Be laulau esega te debana yai, yau, em tau paisowa, egu heyaheyaya te, u nuwa afulen. ");
INSERT INTO bxh_vpl VALUES ("K25_19","013_5_19","2KI","5","19","19","Na Ilaisa, ya libalau Neimani lisina, iyen, Ma nuwa talum u lau. Yo fede ya lau. ");
INSERT INTO bxh_vpl VALUES ("K217_5","013_17_5","2KI","17","5","6","Kin Hosiyeya ena boliman fafaligigi fatina yai Isalaela ya ita watan mate fuyana yai Asiliya edi Kin, Isalaela mahudoꞌina ya eli halahalaen. Boliman faihona Samaliya taonna sa fasai bulubuluhi. Asiliya edi kin, Samaliya dodogadi ya tohaidi, be ya lawedi Asiliya. Haisa ya famiyadi Hala Taonna yai, na haisa Habo Hoꞌowana sadaina yai ya famiyadi Gosan Nuꞌuna ganahewana yai. Na hahaisa mate Mediya taondi yai ya famiyadi. ");
INSERT INTO bxh_vpl VALUES ("K217_7","013_17_7","2KI","17","7","7","Isalaela dodogadi mate, beyabeyana Guyau ya abi hasaedima Idipi edi Kin Falo ena gigibwali yai. In moho, Yaubada ena laulau hige ti famuli watan yo ginaulidi te, sa tubu paꞌana Isalaela heyaheyaya sa ginaulidi Guyau edi Yaubada matana yai. ");
INSERT INTO bxh_vpl VALUES ("K217_8","013_17_8","2KI","17","8","8","Yaubada hahaisa sa fadebasaedi yo nuꞌu matadi yai Guyau haꞌa ya weꞌaidi, edi laulau sa lau watanidi, doha Isalaela edi kin edi laulau. ");
INSERT INTO bxh_vpl VALUES ("K217_9","013_17_9","2KI","17","9","9","Duhu balabalamumu ganadi yai edi yaubada bwalabwala aba fadebasaedi sa ginaulidi. Simosimo yai, Isalaela laulau haisa sa ginaulidi edi Yaubada matana yai mate hige ti dudulai. Tau gati edi aba itaꞌita lau ya lau wee–, duhu balabalamumu ganadi yai edi yaubada bwalabwala aba fadebasaedi sa ginaulidi. ");
INSERT INTO bxh_vpl VALUES ("K217_10","013_17_10","2KI","17","10","10","Umeꞌehu tabudi yo yaubada bwalabwala Asela duhudi sa faꞌobiyodi piupiu hiti mahudoꞌina yai yo oyagi laꞌilaꞌidi logulogudi yai. ");
INSERT INTO bxh_vpl VALUES ("K217_11","013_17_11","2KI","17","11","11","Piupiu hiti aba fadebasaedi mahudoꞌidi yai omwaga sa gabudi, doha beyabeyana nuꞌu matadi yai, be Yaubada ya weꞌaidi. Laulau heyaheyayadi sa ginaulidi be Yaubada sa fanuwa halahala. ");
INSERT INTO bxh_vpl VALUES ("K217_12","013_17_12","2KI","17","12","12","Iti oitau sa fadebasaedi, in moho, Guyau ya falibadi iyen, Umi tabu doha ite au ginauli. ");
INSERT INTO bxh_vpl VALUES ("K217_24","013_17_24","2KI","17","24","24","Babilon, Kuta, Awa, Hamata, yo Sefwalawaim dodogadi Asiliya edi kin ya ledima be Samaliya taonidi yai ya famiyadi, Isalaela dodogadi falau damahidi. Samaliya nuꞌuna sa abi, enehedi, be amainiya sa gogo. ");
INSERT INTO bxh_vpl VALUES ("K217_25","013_17_25","2KI","17","25","25","Fuyana amainiya sa miya bwaꞌibwaꞌi hige Guyau ti fafadebasae, yo fede laiyon ya fatamali lawedi be dodoga haisa sa wunuidi. ");
INSERT INTO bxh_vpl VALUES ("K217_26","013_17_26","2KI","17","26","26","Asiliya edi Kin wasa te sa faliba tiyen, Tau falau damahi wa duidi sa lau Samaliya taonidi sa gogo mate, nuꞌu ni yaubadana somo ya fanufanuha hige ti sibai. Logena laiyon ya fatamali lawedi be sa wunuwunuidi. ");
INSERT INTO bxh_vpl VALUES ("K217_27","013_17_27","2KI","17","27","27","Yo fede Asiliya edi kin liba ya tole, iyen, Tau antalasam Samaliya yai haꞌa te tohaidi, be eda fayofayo tau abina mate, esega au dui i fuyo Samaliya i miya. Be nuꞌu ni yaubadana somo ya fanuha haba dodoga ya fatalahadi. ");
INSERT INTO bxh_vpl VALUES ("K217_28","013_17_28","2KI","17","28","28","Logena, tau antalasam esega sa abi Asiliya yai, sa dui ya lau Beteli taonna yai ya gogo, be sidohana Yaubada fafadebasaena ya fatalahadi. ");
INSERT INTO bxh_vpl VALUES ("K217_29","013_17_29","2KI","17","29","29","In moho pele esega - esega edi aba miya yai edi yaubada bwalabwala sa ginaulidi taon hahaisa yai, be Samaliya edi oitau aba faꞌobiyodi yai sa famwaitodi piupiu hiti yai. ");
INSERT INTO bxh_vpl VALUES ("K218_1","013_18_1","2KI","18","1","1","Fuyanna Ela natuna, Hosiyeya ena bolima fafaihonana ya kin Isalaela yai, Ahasi natuna, Hesekaiya ya famala kin Diuda Nuꞌuna yai. ");
INSERT INTO bxh_vpl VALUES ("K218_2","013_18_2","2KI","18","2","2","Ena bolima 25 ya famala kin, na ya ita wata Yelusalem yai boliman 29. Tinana hesana Abaida, in Sekalaiya natuna. ");
INSERT INTO bxh_vpl VALUES ("K218_3","013_18_3","2KI","18","3","3","Hesekaiya laulau dudulaidi ya ginaulidi Guyau matana yai, doha wahana Deiwidi. ");
INSERT INTO bxh_vpl VALUES ("K218_4","013_18_4","2KI","18","4","4","Yaubada bwalabwaladi aba fadebasaedi ya anfaheyayaidi, umeꞌehu tabudi ya dem ifiꞌifidi yo edi yaubada waiwaihin, hesana Aselaha duhudi ya ibodi. Beyabeyana Mose, weso ya ginauli kapa yai mate ya andem pwaipwaiꞌidi hinaga. Wesona hesana “Nehusitan.” Na Isalaela dodogadi antalasam sa anꞌangabu lau lisina, fuya lofalofa ya lau ee–, ya andem pwaipwai faꞌofi. ");
INSERT INTO bxh_vpl VALUES ("K218_5","013_18_5","2KI","18","5","5","Hesekaiya, Isalaela edi Yaubada ya sunumaꞌen. Diuda edi kin mahudoꞌidi ganahewadi yai, kin bwaꞌibwaꞌidi yo mulimulitadi, hige sai laꞌi doha in. ");
INSERT INTO bxh_vpl VALUES ("K218_6","013_18_6","2KI","18","6","6","Guyau ya fafamuli watan yo laugagayo Mose ya felen mate ya laulau watanidi. ");
INSERT INTO bxh_vpl VALUES ("K218_7","013_18_7","2KI","18","7","7","Guyau maꞌena, be somo ya ginaulidi mate sa loholoho wananaha. Asiliya edi baꞌisa ena fanuha bena Diuda Nuꞌuna ya abi hinaga, in moho Hesekaiya ena ita wata ya ꞌwaiyoꞌo yo hige ena i paipaisowa. ");
INSERT INTO bxh_vpl VALUES ("K218_8","013_18_8","2KI","18","8","8","Filisitani dodogadi mate, Hesekaiya ena tau hiyala sa lei hafihafitinidi yee–, Gasa taonna ganana laꞌilaꞌi yai adi siga. ");
INSERT INTO bxh_vpl VALUES ("K221_1","013_21_1","2KI","21","1","1","Manase ena boliman safuhudohudoꞌi luwaga ya kin be Yelusalem ya ita watan ee–, boliman 50. Tinana hesana mate Hefasiba ");
INSERT INTO bxh_vpl VALUES ("K221_2","013_21_2","2KI","21","2","2","heyaheyaya ya ginauli Guyau matana yai, na heyaheyaya ni, doha dodoga beyabeyana Kanana yai Guyau ya falakodi Isalaela matadi yai. ");
INSERT INTO bxh_vpl VALUES ("K221_3","013_21_3","2KI","21","3","3","Yaubada bwalabwaladi aba fadebasaedi lumadi tamana, Hesekaiya ya anfaheyayaidi mate ya ginauli fuyoꞌidi yo galewa kipwaladi hinaga ya fadebasaedi. Antalasam aba gabugabudi katakatandi ya ginaulidi oitau Baꞌala enehena yo Aselaha oitauna duhuna hinaga ya ginauli mate gonogonowana doha Isalaela edi kin, Ahaba ya ginauli. ");
INSERT INTO bxh_vpl VALUES ("K221_4","013_21_4","2KI","21","4","4","Guyau ena Luma Tabuna ganahewana yai antalasam aba gabugabudi katakatandi yaubada bwalabwala enehedi, ya ginaulidi. In moho Guyau ena Luma Yelusalem yai ni, beyabeyana haꞌa ya libaen iye “Hesagu ainiya haba ya ota.” ");
INSERT INTO bxh_vpl VALUES ("K221_5","013_21_5","2KI","21","5","5","Guyau ena Luma Tabuna dobidobina luwaga mate amainiya antalasam aba gabugabudi katakatandi ya ginaulidi, galewa kipwaladi enehedi. ");
INSERT INTO bxh_vpl VALUES ("K221_6","013_21_6","2KI","21","6","6","Natuna ya antalasamen oyagi alaꞌalana yai. Ayahan ya anpate yo nesu itaꞌita ya fapaisowadi be haba doga ena aba fagiluna be ya fakasa. Dodoga sa anꞌanmasi yo yaluyaluwa ya libalibalau lebedi. Heyaya laꞌilaꞌi ya ginauli Guyau matana yai be manana ya fabala. ");
INSERT INTO bxh_vpl VALUES ("K221_10","013_21_10","2KI","21","10","10","Guyau ena tau paisowa, yo peloweta moꞌadi yai iyen, ");
INSERT INTO bxh_vpl VALUES ("K221_11","013_21_11","2KI","21","11","11","Diuda edi kin Manase, heyaheyaya lalalaꞌi ya ginaulidi, sa ouli wananaha, habahim Amoli dodogadi, tau miya bwaꞌi. Ena oitau debadi yai Diuda ya foya ponolidi. ");
INSERT INTO bxh_vpl VALUES ("K221_12","013_21_12","2KI","21","12","12","Debana yai, Isalaela edi Guyau yo edi Yaubada iyen, Heyaheyaya hesa haba E leyama Yelusalem yo Diuda Nuꞌu a ai lisidi. Haba safaluma sa atahiyen mate sa tauhiti. ");
INSERT INTO bxh_vpl VALUES ("K221_13","013_21_13","2KI","21","13","13","Lufa E fapaisowa Samaliya yo Ahaba ana boga lisidi yai, mate haba E fapaisowa be Yelusalem E lufa. Yau haba Yelusalem E sau afulen doha disi ya sau na ya fabui homo. ");
INSERT INTO bxh_vpl VALUES ("K221_14","013_21_14","2KI","21","14","14","Egu dodoga ota fahidi, safalumadi hige ti wunuidi, haba E taꞌai mulimuliyedi yo E fele afuledi adi waiyunu Asiliya lisidi yai be edi tanohi yo edi ginauli mahudoꞌidi haba sa lau kwayaidi. ");
INSERT INTO bxh_vpl VALUES ("K221_15","013_21_15","2KI","21","15","15","Doha ite haba E ginauli paꞌana heyaya haꞌa beyabeyana sa ginauli matagu yai, fuyanna wahawahadi Idipi edi fuya lau afulenna ya laoma ee–, aho te, na hola otadi lisina yai, managu sa fabala. ");
INSERT INTO bxh_vpl VALUES ("K221_16","013_21_16","2KI","21","16","16","Oitau fadebasaedi lisidi yai Manase Diuda dodogadi ya foya ponolidi be heyaheyaya sa ginauli Guyau matana yai. Falau maimaitina, Manase tau laulau dudulai ya wunuidi be ꞌwasinadi Yelusalem ya nuhuli, ya leu ee–, dudu, na ya sai ee–, dudu. ");
INSERT INTO bxh_vpl VALUES ("K221_18","013_21_18","2KI","21","18","18","Manase ya peꞌi mate Usa gabuna yai sa boꞌusai, kin ena luma loholohona dobidobina yai. Na natuna Amon ya falau damahi. ");
INSERT INTO bxh_vpl VALUES ("K221_19","013_21_19","2KI","21","19","19","Amon ena boliman 22 ya obiyo kin be Yelusalem ya ita watan boliman luwaga. Tinana hesana Mesulemeta, Halusi natuna na ena nuꞌu Dotiba. ");
INSERT INTO bxh_vpl VALUES ("K221_20","013_21_20","2KI","21","20","20","Amon hinaga heyaheyaya ya ginaulidi Guyau matana yai, doha tamana Manase. ");
INSERT INTO bxh_vpl VALUES ("K221_21","013_21_21","2KI","21","21","21","Tamana ena laulau ya laulauwedi be ya laulauꞌuꞌula lau ena oitau lisidi. ");
INSERT INTO bxh_vpl VALUES ("K221_22","013_21_22","2KI","21","22","22","Afa wahawahana edi Guyau Yaubada, ya ꞌwaiyoꞌoꞌen. Ena laulau hige i laulawen. ");
INSERT INTO bxh_vpl VALUES ("K221_23","013_21_23","2KI","21","23","23","Baꞌisa ena tau paisowa lalaꞌi, simosimo yai sa oilibaen bena sa wunui, yo fede, sa wunui ena luma loholohona yai. ");
INSERT INTO bxh_vpl VALUES ("K221_24","013_21_24","2KI","21","24","24","Habahim Diuda dodogadi haisa, Baꞌisa Amon tau wunuina sa wunuidi. Na natuna, Diyosaiya sa faꞌobiyo kin, tamana falau damahina. ");
INSERT INTO bxh_vpl VALUES ("K222_1","013_22_1","2KI","22","1","1","Diyosaiya ena boliman faligigi faihona ya famala kin be Yelusalem ya ita watan boliman 31. Tinana hesana Dedidaiya, Adaiya natuna ena nuꞌu Bosikata taonna. ");
INSERT INTO bxh_vpl VALUES ("K222_2","013_22_2","2KI","22","2","2","In ena laulau sa dudulai Guyau matana yai yo tamana Deiwidi ena laulau, ya laulauwedi. Hige i timutimuli fuyo laulau heyaheyayadi lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("K222_11","013_22_11","2KI","22","11","11","Fuyanna laugagayo bukana sa fatili, na kin ya atahiyen mate, ana luhuluhu ya kamgigi. ");
INSERT INTO bxh_vpl VALUES ("K222_12","013_22_12","2KI","22","12","12","Liba adiꞌadidilina ya tole: Tau antalasam, Hilikaiya lisina yai, Safan natuna, Ahikam, Maikaiya natuna, Akibo, tau uliꞌuli, hesana Safan, yo kin tau liba fasibasibana, Asaiya lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("K222_13","013_22_13","2KI","22","13","13","Iyen, Afa wahawahada, laugagayo sa ulidi buka yai te, mate hige ti laulau watanidi, be Guyau ya manabala heyaya lebeda yai. Na au lau Yaubada ena Luma Tabuna be Guyau ai lisina egu au anꞌeta yo Diuda tanohina dodogadi edi au anꞌeta hinaga. Buka sa lobahi ganahewana yai somo ya uli, bena ami fatiꞌoi. ");
INSERT INTO bxh_vpl VALUES ("K222_16","013_22_16","2KI","22","16","16","Guyau iyen, Yau haba Yelusalem E faheyaya yo dodogadi haba E faꞌankamkamnadi, be somo buka ganahewana yai Diuda edi kin ya fatili haba ya fawananaha. ");
INSERT INTO bxh_vpl VALUES ("K222_17","013_22_17","2KI","22","17","17","Sa nuwa fuiyegu, na antalasam sa angabu lau yaubada hahaisa lisidi. E manabala Yelusalem dodogadi lisidi yai paꞌana oitau mahudoꞌidi sa ginaulidi, ibege nuwagu i talu. ");
INSERT INTO bxh_vpl VALUES ("K222_18","013_22_18","2KI","22","18","18","Diuda edi kin ya fatamalimiu bena Guyau ami fatiꞌoi, mate au faliba, auwen, “Isalaela edi Guyau Yaubada, ya liba doha ite: ‘Somo egu buka yai sa ulidi haꞌa wa lau watanidi. ");
INSERT INTO bxh_vpl VALUES ("K222_19","013_22_19","2KI","22","19","19","Paꞌana fuyanna wa atahi somo heyaheyayana haba E ginauli Yelusalem dodogadi lisidi yai, yo nuꞌuna lisina yai, be ya famala kaumanana nuꞌuna yo nuꞌu afaꞌafana, yo paꞌana wa nuwa talu na wa tole lidilidi fafuyom matagu yai, yo paꞌana am luhuluhu wa kamgigi yo wa tan eloꞌelolosi na wa nuwa bui nuwanuwagu yai. Logena, Yau Guyau, E falibam mate, em anꞌeta haꞌa E atahi. ");
INSERT INTO bxh_vpl VALUES ("K222_20","013_22_20","2KI","22","20","20","Wa peꞌi be sa boꞌusaim, ai mulim heyaheyaya te, haba E leyama Yelusalem yai.” Habahim kin ena tau paisowa, Peloweta Holida ena bui, sa fafuyo Kin Diyosaiya lebena. ");
INSERT INTO bxh_vpl VALUES ("K223_1","013_23_1","2KI","23","1","1","Habahim Diuda yo Yelusalem babadadi Kin Diyosaiya ya yoga gogondima ");
INSERT INTO bxh_vpl VALUES ("K223_2","013_23_2","2KI","23","2","2","be ma afa haidana sa hasai Guyau ena Dubu Tabuna. Tau hasai mate: Diuda tataudi, Yelusalem dodogadi, tau antalasam yo peloweta dodoga mahudoꞌidi, fafahesadi yo fafahesa gesagesadi hinaga. Yali Bukana sa lobahi amainiya, kin ya fatili nuwanuwadi yai. ");
INSERT INTO bxh_vpl VALUES ("K223_3","013_23_3","2KI","23","3","3","Habahim Dubu Tabuna duhuna sadaina yai Kin Diyosaiya ya obiyo na yalina ya fawananaha bodai Guyau matana yai, be haba Guyau ya famuli watan yo ena laugagayo ya abi didin, yo yalina ma nuwa ofi fahina yo ma yaluwa ofi fahina ya ginauli fuyoi, be angwala libadi buka yai sa ulidi, ya fawananahadi. Habahim dodoga mahudoꞌidi sa angwala, haba yalina nuwadi yai ya ota. ");
INSERT INTO bxh_vpl VALUES ("K223_4","013_23_4","2KI","23","4","4","Kin Diyosaiya liba adiꞌadidilina ya tole: tau antalasam edi baꞌisa Hilikaiya lisina yai, yo tau antalasam hahaisa, yo Yaubada ena Luma aba luhuluhu launa tau ita watanna lebedi yai, iyen, Baꞌala, Aselaha yo kipwala galewa oitaudi, Luma Tabuna ganahewana yai bena ami kamfahidi. Ya falibadi be ginaulidi sa angabuidi Yelusalem mulimulina yai, Kidilon gonna yai na afusadi sa lawen Beteli taonna. ");
INSERT INTO bxh_vpl VALUES ("R236_14","015_36_14","2CH","36","14","14","Tau antalasam babaꞌisadi mahudoꞌidi yo dodoga mate Yaubada hige ti sunusunumaꞌen. Nuꞌu hahaisa dodogadi edi laulau heyaheyayadi sa laulauwedi yo Guyau ena Dubu Yelusalem yai haꞌa ya fatabu, edi abiꞌabina doha luma gaibu. ");
INSERT INTO bxh_vpl VALUES ("R236_15","015_36_15","2CH","36","15","15","Afa wahawahadi edi Guyau yo edi Yaubada, fuya ouꞌouli ya liba fanuwa tagudi ena wasa tau lawendi lebedi yai, paꞌana ena dodoga yo ena Aba Miya, Dubu Tabuna, ya nuwatohatohaedi. ");
INSERT INTO bxh_vpl VALUES ("R236_16","015_36_16","2CH","36","16","16","In moho Yaubada ena liba sa ꞌwaiyoꞌoꞌen, ena wasa tau lawendi, sa ala liuliuhwaꞌedi, yo ena peloweta sa ita lidilidiyedi ee–, Yaubada ya manabalaꞌedi, be hige aba famamayona. ");
INSERT INTO bxh_vpl VALUES ("R236_17","015_36_17","2CH","36","17","17","Habahim Guyau, Babilon edi Kin, Nebukanesa, nuwana ya lafei, be edi tau hiyala Yelusalem taonna sa tulufi, be Diuda hewahewalidi Dubu Tabuna ganahewana yai, sa wunuidi baineti yai. Hige hewali, hasala e tautaulaꞌi hesa i mwahuli. Yaubada, mahudoꞌidi ya tole afuledi Nebukanesa nimana yai. ");
INSERT INTO bxh_vpl VALUES ("R236_18","015_36_18","2CH","36","18","18","Ginaulidi mahudoꞌidi, lalalaꞌi yo kikiluka, maisadi lalaꞌi Yaubada ena Dubu Tabuna yai, yo Kin maꞌena tau paisowa edi ginauli mahudoꞌidi sa lawedi Babilon. ");
INSERT INTO bxh_vpl VALUES ("R236_19","015_36_19","2CH","36","19","19","Yaubada ena Dubu Tabuna sa gabu yo Yelusalem ganana sa dem lopalopa, luma lalaꞌi mahudoꞌidi sa gabudi yo ginauli maisadi lalaꞌi, amainiya sa faheyayadi. ");
INSERT INTO bxh_vpl VALUES ("R236_20","015_36_20","2CH","36","20","20","Diuda dodogadi salumadi hige ti wunuidi na sa mwahuli mate sa lawedi Babilon be Kin ma nanatuna edi tau lau fayofayo ee–, Pesia, Babilon Nuꞌuna sa lei hafihafitidi, habahim, sa lau fayofayo tauwendi. ");
INSERT INTO bxh_vpl VALUES ("R236_21","015_36_21","2CH","36","21","21","Fuyanna Diuda edi tanohi yai sa miyamiya, mate bolima faligigi-luwaga ganahewana yai tanohina hige ti faꞌanyawasi. Na fuyana sa lawe hudoꞌiyedi Babilon yai mate tanohina sa ita afulen bee–, bolima 70. Be Guyau ena liba fasunuma peloweta Delamaiya lisina yai wa, ya fawananaha. ");
INSERT INTO bxh_vpl VALUES ("R236_22","015_36_22","2CH","36","22","22","Boliman bwaꞌibwaꞌina yai Sailusi ena fuya kin Pesia nuꞌuna yai, Guyau liba fasunuma peloweta Delamaiya haꞌa ya faliba mate ya fawananaha be Kin Sailusi nuwa ya lafei bena ya libalibaen yo ya uli. ");
INSERT INTO bxh_vpl VALUES ("R236_23","015_36_23","2CH","36","23","23","Somo Kin Sailusi ya libaen mate itete, “Guyau, Galewa Yaubadana, mate nuꞌu mahudoꞌina tanoꞌubu yai ya felegu yo ya fasinabogu bena ena Dubu Tabuna ai Yelusalem E ginauli, Diuda Nuꞌuna yai. Salumadi Yaubada enehena mate Guyau emi Yaubada haba maꞌemiu, mate au leu niya.” ");
INSERT INTO bxh_vpl VALUES ("ER3_1","016_3_1","EZR","3","1","1","Nawalahi fafaligigi-luwagana yai Isalaela dodogadi edi taon sa miyaidi. Mahudoꞌidi sa faꞌoigogo Yelusalem yai. ");
INSERT INTO bxh_vpl VALUES ("ER3_2","016_3_2","EZR","3","2","2","Habahim Diyosadaki natuna, Diyesuwa, falena tau antalasam yo Silitiyeli natuna, Selubabeli maꞌana boga sa fatubu antalasam aba angabuna sa ginauli Isalaela edi Yaubada enehena. Bena ainiya Guyau antalasam sa gabu. Laugagayo somo Guyau ena peloweta Mose, ya uli mate sa falau watan. ");
INSERT INTO bxh_vpl VALUES ("ER3_3","016_3_3","EZR","3","3","3","Diuda dodogadi tau miya fataꞌiꞌilidi mate sa ꞌwasabuwedi. In moho aba anꞌantalasam sa ginauli boda somo yai beyabeyana edi aba ginaulina, be amainiya lisina yai hwalahwala yo maimailafi ouꞌouli antalasam sa angabu lau Guyau lisina. ");
INSERT INTO bxh_vpl VALUES ("ER3_4","016_3_4","EZR","3","4","4","Habahim Mose laugagayo ya uli sa falau watan be anꞌangogona gwaꞌuna sa ginauli. Lahai hesa - hesa antalasam sa gabudi ana nonoi yai. ");
INSERT INTO bxh_vpl VALUES ("ER3_5","016_3_5","EZR","3","5","5","Muliyai, Fuya Ouꞌouli Ainauya sa ginaginaulidi mate sa ginaulidi yo Nawalahi Fwaufwau Antalasamna, Guyau ena Mataꞌasi Lahaidi Tabudi Fafasinabodi mahudoꞌidi antalasamdi, yo hinaga Ainauya Ma Nuwa Ofifahidi sa Ledima Antalasamna, mate hinaga sa gabudi, Guyau enehena. ");
INSERT INTO bxh_vpl VALUES ("ER3_6","016_3_6","EZR","3","6","6","Guyau ena Dubu Tabuna aba faꞌobiyona umeꞌehudi hola hige ti toledi na haꞌa antalasam sa angabu nawalahi fafaligigi-luwagana yai, lahai bwaꞌibwaꞌina yai. ");
INSERT INTO bxh_vpl VALUES ("ER3_7","016_3_7","EZR","3","7","7","Habahim Kin Sailusi, Diuda dodogadi ya falibadi be Dubu Tabuna sa ginauli fuyoi, umeꞌehu tau pidipididi yo luma tau lau ginauli sa famaisadi. Sidon yo Taiya dodogadi adi kalahe, wain yo oliwe gilisina sa feledi, be oyagi sida haba ai Lebanon gabogabona sa fapouli lawen Diyopa nuꞌuna. Pesia edi kin ya yaliyen doha. ");
INSERT INTO bxh_vpl VALUES ("ER3_8","016_3_8","EZR","3","8","8","Bolima fafaluwagana na nawalahi fafaluwagana yai, Diuda dodogadi edi fuyoma Yelusalem na mulina yai, sa fatubu Guyau ena Dubu Tabuna sa ginauli. Tau paisowadi mate: Silitiyeli natuna, Selubabeli yo Diyosadaki natuna, Diyesuwa maꞌadi boga, yo afa haidadi hahaisa: antalasam tau gabugabudi, sulu Lewi dodogadi yo salumadi mahudoꞌidi adi waiyunu sa lawedi Babilon sa falau fayofayoꞌidi na sa fuyoma Yelusalem. Sulu Lewi hewahewalidi edi bolima 20 yo ya hasaen sa fasinabodi be paisowa sa uluꞌuluwen. ");
INSERT INTO bxh_vpl VALUES ("ER6_16","016_6_16","EZR","6","16","16","Habahim Isalaela dodogadi, tau antalasam, sulu Lewi yo salumadi sa lawe hudoꞌiyedi nuꞌu hesa yai na sa fuyoma Yelusalem mate Dubu Tabuna sa fatabu ma nuwa loholohodi. ");
INSERT INTO bxh_vpl VALUES ("NH8_1","017_8_1","NEH","8","1","1","Dodoga mahudoꞌidi sa faꞌoigogo esegama dobidobi yai, Hoꞌowa Edaꞌedana Hafohafona yai. Laugagayo tau lau faꞌataenna Esela sa faliba bena Mose ena Laugagayo Bukana ya fakalamahanoyama. ");
INSERT INTO bxh_vpl VALUES ("NH8_2","017_8_2","NEH","8","2","2","Nawalahi fafaligigi-luwagana yai na lahai bwaꞌibwaꞌina mate tau antalasam, Esela, Laugagayo Bukana ya leyama tatau, wawahin yo tau atahi lobahina mahudoꞌidi lebedi. ");
INSERT INTO bxh_vpl VALUES ("NH8_3","017_8_3","NEH","8","3","3","Dobidobi yai, Hoꞌowa Edaꞌedana Hafohafona yai mate Esela Laugagayo Bukana ya fatili falaꞌi tatau, wawahin yo tau atahi lobahina hahaisa lebedi yai. Ya ifi tatatali mate ya fatubu ya fatili ee–, lahai laꞌi. ");
INSERT INTO bxh_vpl VALUES ("NH8_4","017_8_4","NEH","8","4","4","Faꞌoigogo fatafatana lofalofa sa ginauli mate hewana yai laugagayo tau lau faꞌataenna, Esela ya mwaito. Nima sibana yai sa mwaito mate: Matitaiya, Sema, Anaiya, Ulaiya, Hilikaiya yo Maseiya. Na seuseulina yai mate: Pedaiya, Miseli, Malikiya, Hasum, Hasibadana, Sekalaiya yo Mesulam. ");
INSERT INTO bxh_vpl VALUES ("NH8_5","017_8_5","NEH","8","5","5","Laugagayo Bukana ya soꞌe mate dodoga mahudoꞌidi sa itaꞌita hasa be sa ita, paꞌana in hewa yai. Maihalana, Laugagayo Bukana ya kalasi, mahudoꞌidi sa obiyo. ");
INSERT INTO bxh_vpl VALUES ("NH8_6","017_8_6","NEH","8","6","6","Esela iye, Guyau hesana E lau hitin! In Yaubada Adiꞌadidilina! Dodoga mahudoꞌidi nimadi sa lau hitindi tiyen, “Moꞌisa! Wananaha!” Habahim sa hoba lidi tanohi yai na Guyau sa fadebasae. ");
INSERT INTO bxh_vpl VALUES ("NH8_7","017_8_7","NEH","8","7","7","Sulu Lewi Laugagayo Bukana tau liba faneganegana hesadi mate: Diyesuwa, Bani, Selebiya, Diyamin, Akubu, Sabetai, Hodaiya, Maseiya, Kelita, Asiliya, Diyosabada, Hanan yo Pelaiya. Na dodoga edi aba obiꞌobiyo yai sa ataꞌatahi. ");
INSERT INTO bxh_vpl VALUES ("NH8_8","017_8_8","NEH","8","8","8","Somo ya fatifatili, aniyona sa liba famahata be dodoga sa nuwatuhu lobahi. ");
INSERT INTO bxh_vpl VALUES ("NH8_9","017_8_9","NEH","8","9","9","Fuyana dodoga, laugagayo libadi ni sa atahi mate, sa tan, be Gawana Nehemaiya, yo Esela, (in tau antalasam yo laugagayo tau lau faꞌataenna) yo Sulu Lewi, iti laugagayo tau liba fanegadi, mahudoꞌidi sa falibadi tiyen, “Guyau, emi Yaubada matana yai lahai te, mate tabuna. Be tabu au tan!” ");
INSERT INTO bxh_vpl VALUES ("NH8_10","017_8_10","NEH","8","10","10","Na Nehemaiya iye, Au lau be anꞌan loholohodi ami au an, yo nomnom amꞌamnadi ami au nomdi. Na salumadi hige somo adi ti nonohai mate adi au feledi. Lahai te, Guyau ena lahai fafatabuna. Guyau ena kwade mate emi adidili be tabu nuwamiu ti heyaya. ");
INSERT INTO bxh_vpl VALUES ("JB1_1","019_1_1","JOB","1","1","1","Taumoho hudoꞌi hesana Diyobi mate Udi Nuꞌuna yai ya miyamiya. Hige somo laꞌi lebena yai ti fagilu paꞌana in doga dudulaina. Yaubada ya fafadebasae yo heyaya ya anꞌanfaledi. ");
INSERT INTO bxh_vpl VALUES ("JB1_2","019_1_2","JOB","1","2","2","Nanatuna tatau faligigi luwaga yo wawahin faihona. ");
INSERT INTO bxh_vpl VALUES ("JB1_3","019_1_3","JOB","1","3","3","Ena sipi oulidi 7 tausan, kamela 3 tausan bulumakau 1 tausan yo donki 5 handele. Ya fagogo wananaha habahim tefa saisai dodogadi. ");
INSERT INTO bxh_vpl VALUES ("JB1_4","019_1_4","JOB","1","4","4","Nanatuna tatau, hesa - hesa ana fuya mataꞌasi ya ginauli ena luma yai na afa lolofudi faihona sa yogaidi be maidadi sa anꞌangogo. ");
INSERT INTO bxh_vpl VALUES ("JB1_5","019_1_5","JOB","1","5","5","Mataꞌasi ofina yai, Diyobi ya yogaidi sa laoma be ya abi nonohaidi. Hwalahwalala ya eno obiyo haba ainauya antalasam ya gabu nanatuna enehedi, paꞌana ena nuwatuhu iyen, “Bena nanatugu heyaya ti ginauli yo nuwadi yai Yaubada ti kaumananai.” Laulau te ya famala Diyobi ena miyamiya, fuya ouꞌouli. ");
INSERT INTO bxh_vpl VALUES ("JB1_6","019_1_6","JOB","1","6","6","Fuya hesa anelu sa laoma be sa fataumahata fuyoꞌidi Guyau nuwanuwana yai, na Tau Laulau Fagilu, Satani, ya lau watanidi hinaga. ");
INSERT INTO bxh_vpl VALUES ("JB1_7","019_1_7","JOB","1","7","7","Guyau ya libalau Tau Laulau Fagilu lisina iyen, Somo yai wa laolaoma? Na ena bui ya felen iyen, Tanoꞌubu E lau tiga fataꞌiꞌili. E leuleu yo E saesae ganahewana yai. ");
INSERT INTO bxh_vpl VALUES ("JB1_8","019_1_8","JOB","1","8","8","Habahim Guyau ya libalau Tau Laulau Fagilu lebena iyen, Egu tau paisowa, Diyobi haꞌa wa nuwatuhu fadosi e higeꞌe? Hige sai hesa doha in. Hige somo hesa lisina yai ti fagilu yo in doga dudulaina. Yaubada ya fafadebasae yo heyaya ya anꞌanfaleꞌedi. ");
INSERT INTO bxh_vpl VALUES ("JB1_9","019_1_9","JOB","1","9","9","Yaubada alinana Tau Laulau Fagilu, Satani, ya bui iyen, Diyobi hige i fadebasae gaibuim! ");
INSERT INTO bxh_vpl VALUES ("JB1_10","019_1_10","JOB","1","10","10","Fuya ouꞌouli, ana boga yo ena ginauli wa bobobodiyedi. Em faloholoho lebena yai be ya fagogo, ena sipi yo bulumakau sa tadada. ");
INSERT INTO bxh_vpl VALUES ("JB1_11","019_1_11","JOB","1","11","11","In moho aho, ibe ginauli mahudoꞌidi lebena yai wa kamfahidi, haba ya kaumananaem. ");
INSERT INTO bxh_vpl VALUES ("JB1_12","019_1_12","JOB","1","12","12","Guyau ya libalau Tau Laulau Fagilu lebena iyen, Logena, ena ginauli mahudoꞌidi nimam yai E toledi. In moho, tabu u abilau tauna yai. Habahim Tau Laulau Fagilu, Guyau ya lau afulen. ");
INSERT INTO bxh_vpl VALUES ("JB1_13","019_1_13","JOB","1","13","13","Lahai hesa Diyobi nanatuna sa anꞌangogo yo wain sa nomnom tuwahadi taumoho ena luma yai. ");
INSERT INTO bxh_vpl VALUES ("JB1_14","019_1_14","JOB","1","14","14","Wasa tau leyamana ya laoma Diyobi ya faliba iyen, Em bulumakau aba giyagiyali sa felifeliꞌi na donki mate fadidi yai sa anꞌanban. ");
INSERT INTO bxh_vpl VALUES ("JB1_15","019_1_15","JOB","1","15","15","Sabe dodogadi, em tau lau fayofayo sa tulufidi be mahudoꞌidi sa wunuidi na yosiyosi mahudoꞌidi sa angafuhidi. Yau ibogu moho E gela be E laoma, em E liba! ");
INSERT INTO bxh_vpl VALUES ("JB1_16","019_1_16","JOB","1","16","16","Hola ma libalibana yo fede wasa tau leyamana hudoꞌi ya laoma ya liba iyen, Namanamali em sipi yo tau itaꞌita watanidi mahudoꞌidi ya angabuidi. Yau ibogu moho, E gela E laoma em E liba! ");
INSERT INTO bxh_vpl VALUES ("JB1_17","019_1_17","JOB","1","17","17","Hola ma libalibana na wasa tau leyamana fafa faihonana ya laoma ya liba iyen, Tau angafu pwaludi faihona iti Kaladiya dodogadi sa laoma be em kamela mahudoꞌidi sa angafuhidi na em tau lau fayofayo sa wunuidi. Yau ibogu moho, E gela E laoma em E liba! ");
INSERT INTO bxh_vpl VALUES ("JB1_18","019_1_18","JOB","1","18","18","Hola ma libalibana na wasa tau leyamana fafatina ya laoma ya liba iyen, Nanatum sa anꞌangogo yo wain sa nomnom tuwahadi ena luma yai. ");
INSERT INTO bxh_vpl VALUES ("JB1_19","019_1_19","JOB","1","19","19","Ma esega na nuꞌu pitapitalina yai hwayahwayau laꞌilaꞌi ya towama! Luma ya towa fafataꞌiꞌili be ya guli. Nanatum mahudoꞌidi ya saꞌinidi be sa peꞌi. Na yau ibogu moho, E gela E laoma em E liba. ");
INSERT INTO bxh_vpl VALUES ("JB1_20","019_1_20","JOB","1","20","20","Yo fede Diyobi ya mwaito be ana luhuluhu ya kamgigi yo kuluna ya holi, ena nuwa heyaya fafaꞌilalana. Habahim ya guli lidi tanohi yai be Guyau ya fadebasae. ");
INSERT INTO bxh_vpl VALUES ("JB1_21","019_1_21","JOB","1","21","21","Na iyen, E tubuma, ma tau afaꞌafagu. Na ma tau afaꞌafagu haba E peꞌi. Guyau somo ya felegu, haꞌa ya fafuyo; In moho, Guyau E fadebasae. ");
INSERT INTO bxh_vpl VALUES ("JB1_22","019_1_22","JOB","1","22","22","Diyobi pilipili ya fahoina, in moho hige ena lau fagilu hesa Yaubada lebena yai, yo hige ena heyaya hesa. ");
INSERT INTO bxh_vpl VALUES ("JB2_1","019_2_1","JOB","2","1","1","Fuya hesa anelu sa laoma Guyau matana yai na Tau Laulau Fagilu, Satani, hinaga ya laoma. ");
INSERT INTO bxh_vpl VALUES ("JB2_2","019_2_2","JOB","2","2","2","Guyau ya libalau Tau Laulau Fagilu lisina iyen, Somo yai wa laolaoma? Guyau alinana, Tau Laulau Fagilu ya bui iyen, Tanoꞌubu E lau tiga fataꞌiꞌili. E leu yo E sai ganahewana yai. ");
INSERT INTO bxh_vpl VALUES ("JB2_3","019_2_3","JOB","2","3","3","Habahim Guyau ya libalau Tau Laulau Fagilu lebena iyen, Egu tau lau fayofayo, Diyobi haꞌa wa nuwatuhu fadosi e higeꞌe? Hige sai laꞌi doha in. In doga dudulaina, hige gilu hesa lisina yai. Yaubada ya fafadebasae yo heyaya ya anꞌanfaleꞌedi. Satani! Wa nuwa liuwigu bena pilipili hige aniyona hesa E felen, in moho laulau dudulaidi hola ya ginaginaulidi yo hola ya fafadebasaegu. ");
INSERT INTO bxh_vpl VALUES ("JB2_4","019_2_4","JOB","2","4","4","Tau Laulau Fagilu iyen, Edi mwahuli debadi yai dodoga haba edi ginauli mahudoꞌidi sa nuwa afuledi, bena tabu ti peꞌi. ");
INSERT INTO bxh_vpl VALUES ("JB2_5","019_2_5","JOB","2","5","5","Haga u abilau tauna yai be u fakamkamna, haba ai nuwanuwam ya kaumanana fafaheyayam. ");
INSERT INTO bxh_vpl VALUES ("JB2_6","019_2_6","JOB","2","6","6","Guyau ya libalau Tau Laulau Fagilu lebena iyen, Logena, nimam yai E tole afulen, in moho tabu u wunui. ");
INSERT INTO bxh_vpl VALUES ("JB2_7","019_2_7","JOB","2","7","7","Habahim Tau Laulau Fagilu, Guyau ya lau afulen na ya lau be bonu kamokamoꞌuꞌu ya yala fafinahe Diyobi lisina yai. Tauna mahudoꞌina sa tupitupi, ahe laulauna yai ya hasai ee–, kuluna. ");
INSERT INTO bxh_vpl VALUES ("JB2_8","019_2_8","JOB","2","8","8","Diyobi afusa yai ya taꞌai paꞌana nuwana ya heyaya, na gulewa senana ya abi be bonu kamokamoꞌuꞌuna ya kamkam holidi. ");
INSERT INTO bxh_vpl VALUES ("JB2_9","019_2_9","JOB","2","9","9","Lahuna ya libalau lisina iyen, Paꞌana somo em kawawananaha yo laulau dudulaidi sa ota esegahi? Yaubadana u kaumananaen be u peꞌi! ");
INSERT INTO bxh_vpl VALUES ("JB2_10","019_2_10","JOB","2","10","10","Diyobi, lahuna ena liba ya bui iyen, Wa libaliba doha waihin yauyaulena. Loholoho, Yaubada ya feleda, haba te abi. Na heyaya te ꞌwaiyoꞌoꞌen? Libadi yai te, Diyobi hige i liba heyaya. ");
INSERT INTO bxh_vpl VALUES ("JB2_11","019_2_11","JOB","2","11","11","Fuyanna haidana faihona sa atahi mate pilipili ya fahoina, be sa faꞌoi esega, bena sa lau Diyobi lisina. Be ena kamkamna ganahewana yai, nuwana sa liba faꞌadidili. Afa haidana hesadi mate: Elifasi, Teman Taonna dogana, Bilidada, Suwa Nuꞌuna dogana, yo Sofala, Namati Nuꞌuna dogana. ");
INSERT INTO bxh_vpl VALUES ("JB2_12","019_2_12","JOB","2","12","12","Edaꞌeda lofalofa yai sa ita lawen na Diyobi hige ti ita lobahi. Sa fatubu sa tan laꞌilaꞌi, na adi luhuluhu sa kam giginidi yo gegebula sa pei hasa kuludi yai. ");
INSERT INTO bxh_vpl VALUES ("JB2_13","019_2_13","JOB","2","13","13","Habahim maꞌedi tanohi yai sa taꞌai amainiya ee–, lahai faligigi luwaga yo iꞌipa faligigi luwaga sa ofi. Hige ti fagagali paꞌana ena kamkamna sa ita ya laꞌi wananaha. ");
INSERT INTO bxh_vpl VALUES ("JB3_1","019_3_1","JOB","3","1","1","Habahim Diyobi ya fatubu ya kaumananaen. ");
INSERT INTO bxh_vpl VALUES ("JB3_2","019_3_2","JOB","3","2","3","Iyen, Aee–, Guyau, ibe edi fuya yosigu, tabu ti nuwatuhui, na maihonana tiyen, “gwama sa yosi!” ");
INSERT INTO bxh_vpl VALUES ("JB3_4","019_3_4","JOB","3","4","4","Lahaina ni u bui be i kamumu; Haba Yaubadana ibege i modeꞌen. Tabu mala i sina, ai hewana. ");
INSERT INTO bxh_vpl VALUES ("JB3_5","019_3_5","JOB","3","5","5","Lahaina i kamumu lubilubi, yo yada dubadubadi, galewa yo maihala ti fakoudi. ");
INSERT INTO bxh_vpl VALUES ("JB3_6","019_3_6","JOB","3","6","6","Iꞌipa, kamumu i abi didini; Tabu edi fuya yosigu lahaina ti fatili esegahi, egu fuya tubu lahaina ti saufahi! ");
INSERT INTO bxh_vpl VALUES ("JB3_7","019_3_7","JOB","3","7","7","Iꞌipana i agali, doha waihin hige i fanatu. Tabu kwade laꞌilaꞌi maihona yai ni. ");
INSERT INTO bxh_vpl VALUES ("JB3_8","019_3_8","JOB","3","8","8","Tau kaukaumanana lahaina ni ti kaumananaen, safalumadi sa nonoha bena Lewaitan sa liba faleꞌo fahi. ");
INSERT INTO bxh_vpl VALUES ("JB3_9","019_3_9","JOB","3","9","9","Hwalahwalala kipwaladi tabu ti mala, yo tabu i ifi tatatali. Lahai i bagi asahai. ");
INSERT INTO bxh_vpl VALUES ("JB3_10","019_3_10","JOB","3","10","10","Beyabeyana tabu ti yosigu, be pilipili tabu ya fahoinadi. ");
INSERT INTO bxh_vpl VALUES ("JB3_11","019_3_11","JOB","3","11","11","Sidohana be hige ya peꞌi, tinagu bogana ganahewana yai? Ye ena fuya yosigu yai? ");
INSERT INTO bxh_vpl VALUES ("JB3_12","019_3_12","JOB","3","12","12","Sidohana be tinagu ya labalabaigu, yo ya fafanomgu? ");
INSERT INTO bxh_vpl VALUES ("JB3_13","019_3_13","JOB","3","13","13","Ibe moho E peꞌi, egoba E anyawasi esega. ");
INSERT INTO bxh_vpl VALUES ("JB3_14","019_3_14","JOB","3","14","14","Maidagu kin yo babada tanoꞌubu yai, safalumadi edi luma loholohodi haꞌa sa lau ginauli na aho te sa faheyayadi. ");
INSERT INTO bxh_vpl VALUES ("JB3_15","019_3_15","JOB","3","15","15","Yo maidagu tau foyafoya fafagoledi, edi luma siluba sa famohafu. ");
INSERT INTO bxh_vpl VALUES ("JB4_1","019_4_1","JOB","4","1","1","Habahim Elifasi Tema dogana, Diyobi alinana ya bui iyen, ");
INSERT INTO bxh_vpl VALUES ("JB4_2","019_4_2","JOB","4","2","2","Ibe E libaliba haba wa manabalaꞌegu e higeꞌe? Sai haba gonowana moꞌagu ya gudu? ");
INSERT INTO bxh_vpl VALUES ("JB4_3","019_4_3","JOB","4","3","3","E siba, dodoga boludi wa fatalahadi, na megomegodi wa faꞌadidilidi. ");
INSERT INTO bxh_vpl VALUES ("JB4_4","019_4_4","JOB","4","4","4","Dodoga edi pilipili yai sa faꞌalu betibeti, yo salumadi tulidi sa mwahu, haꞌa nuwadi wa liba faꞌadidilidi. ");
INSERT INTO bxh_vpl VALUES ("JB4_5","019_4_5","JOB","4","5","5","In moho aho pilipili wa fafahoina. Lisina yai mate nuwam ya belubelu; ya oi tawaim, yo fede, haꞌai! Em adidili ya ofi. ");
INSERT INTO bxh_vpl VALUES ("JB4_6","019_4_6","JOB","4","6","6","Em kawa wananaha Yaubada lisina yai, yo em laulau dudulai sa famala em sunuma. ");
INSERT INTO bxh_vpl VALUES ("JB4_7","019_4_7","JOB","4","7","7","Aho haga u nuwanuwatuhu! Tau laulau dudulai sai laꞌi hige i peꞌi, yo heyaya hige i fafahoinadi! ");
INSERT INTO bxh_vpl VALUES ("JB4_8","019_4_8","JOB","4","8","8","Egu itaꞌita yai mate, safalumadi heyaheyaya sa umahidi, yo pilipili sa falili, haba heyaheyaya sa falolodi. ");
INSERT INTO bxh_vpl VALUES ("JB38_1","019_38_1","JOB","38","1","1","Habahim bwai filifili ganahewana yai Guyau, Diyobi ena bui ya felen iyebom, ");
INSERT INTO bxh_vpl VALUES ("JB38_2","019_38_2","JOB","38","2","2","Um sai itete? Egu nuwatuhu wa fafadosi fuyoꞌidi. Wa libalibaidi bena haga um tau sonoga. In moho, higeꞌe. ");
INSERT INTO bxh_vpl VALUES ("JB38_3","019_38_3","JOB","38","3","3","Yena um taumoho, u obiyo adidili. Haba E fatiꞌoim na egu bui wa felegu. ");
INSERT INTO bxh_vpl VALUES ("JB38_4","019_38_4","JOB","38","4","4","Fuyanna tanoꞌubu aba fatubuna E tole mate, um somo yai? Yena wa sibai, u falibagu. ");
INSERT INTO bxh_vpl VALUES ("JB38_5","019_38_5","JOB","38","5","5","Sai tanoꞌubu laꞌina ya lufa? Yo sai mahina ya wewehi fadohe? Haꞌa wa sibai? ");
INSERT INTO bxh_vpl VALUES ("JB38_6","019_38_6","JOB","38","6","6","Tanohi aba fatubuna umeꞌehuna somo yai sa tole? E sai tanoꞌubu aba fatubuna ya abi didiꞌi? ");
INSERT INTO bxh_vpl VALUES ("JB38_7","019_38_7","JOB","38","7","7","Fuyanna mate hwalahwalala kipwaladi mahudoꞌidi sa wana gogo esega. Yo anelu mahudoꞌidi sa yogayoga ma nuwa kwadedi. ");
INSERT INTO bxh_vpl VALUES ("JB38_8","019_38_8","JOB","38","8","8","Gabogabo sai ya gudu, fuyanna ena aba tubu yai ya pisalama? Be gabogabo ena aba otaꞌota yai ya ota, hige ana sigasiga i diꞌoi? ");
INSERT INTO bxh_vpl VALUES ("JB40_1","019_40_1","JOB","40","1","1","Guyau ya libalau Diyobi lisina, iyen ");
INSERT INTO bxh_vpl VALUES ("JB40_2","019_40_2","JOB","40","2","2","Diyobi, Yau, Hewa Wananaha Yaubadana hola wa faifaibayahoꞌegu. Haba wa fatautau e higeꞌe? Yena wa fafagilugu, beti, egu fatiꞌo te u buidi! ");
INSERT INTO bxh_vpl VALUES ("JB40_3","019_40_3","JOB","40","3","3","Habahim Diyobi ya liba fuyo Guyau lisina iyebom, ");
INSERT INTO bxh_vpl VALUES ("JB40_4","019_40_4","JOB","40","4","4","Yau hige ya loholoho. Em liba haba sidohana egu buibuina? Moꞌagu E gudu ibege somo ya libaen. ");
INSERT INTO bxh_vpl VALUES ("JB40_5","019_40_5","JOB","40","5","5","Ibege somo hesa ya libaen fuyoi, paꞌana E liba diꞌo. ");
INSERT INTO bxh_vpl VALUES ("JB42_1","019_42_1","JOB","42","1","1","Habahim Guyau, Diyobi, alinana ya bui iyebom, ");
INSERT INTO bxh_vpl VALUES ("JB42_2","019_42_2","JOB","42","2","2","E siba mate um gonowana ginauli mahudoꞌidi wa ginaulidi. Em nuwatuhu hige aba guduna hesa. ");
INSERT INTO bxh_vpl VALUES ("JB42_3","019_42_3","JOB","42","3","3","Wa fatiꞌoigu uwe, “Sidohana ma nuwa afaꞌafam wa libaliba? Sidohana be egu nuwatuhu wa fafadosi fuyoꞌidi?” Wananaha, E libaliba gaibu, doha tawa, “Ya siba.” Ginaulidi sa loholoho wananaha, in moho hige egu sibasiba haba ya sai tawatawanim. ");
INSERT INTO bxh_vpl VALUES ("JB42_4","019_42_4","JOB","42","4","4","Guyau uwe, “Aho ite u ataꞌatahi! Haba E libaliba. Haba E fatiꞌoim na egu bui wa felegu!” ");
INSERT INTO bxh_vpl VALUES ("JB42_5","019_42_5","JOB","42","5","5","Beyabeyana wasam E atahi, na aho te, E ita, tau wananahaim. ");
INSERT INTO bxh_vpl VALUES ("JB42_6","019_42_6","JOB","42","6","6","Egu liba mahudoꞌina debana yai E taumayamaya be E taꞌai lidi gegebula yo afusa yai, egu nuwa bui fafaꞌilalana. ");
INSERT INTO bxh_vpl VALUES ("JB42_7","019_42_7","JOB","42","7","8","Guyau, Diyobi ya faliba mulina yai, habahim ya libalau Teman dogana, Elifasi lisina, iyebom, Um yo afa haidam luwaga E manabalaꞌemiu paꞌana liba dudulaidi E falibamiu hige au libaedi, na ami lau bwalabwala, hige doha egu tau paisowa Diyobi, in ya libaliba dudulai. Emi yauyaule debana yai, aho te bulumakau tamoꞌanadi faligigi luwaga yo sipi tamoꞌanadi faligigi luwaga au abidi be au lau Diyobi lebena emi antalasam au gabudi. Haba emi ya lauꞌuꞌula na E atahi, be ibege ya fataumayamayamiu. ");
INSERT INTO bxh_vpl VALUES ("JB42_9","019_42_9","JOB","42","9","9","Habahim Elifasi, in Tema dogana, Bilidada, Suhu dogana yo Sofala, Namati dogana Guyau somo ya falibadi mate sa ginauli watan be Diyobi ena lauꞌuꞌula Guyau ya atahi. ");
INSERT INTO bxh_vpl VALUES ("JB42_10","019_42_10","JOB","42","10","10","Afa haidana faihona enehedi ya lauꞌuꞌula; mulina yai habahim, Guyau, Diyobi ya fagogo fuyoi. Ena ginauli asiꞌasinadi ya lau fadamahi fuyoꞌidi, yo hewadi yai hinaga ya falau tawa fuyoi. ");
INSERT INTO bxh_vpl VALUES ("JB42_11","019_42_11","JOB","42","11","11","Guyau pilipili mahudoꞌidi ya leyama lisina yai. Debana yai afa haidana, afa lolofuna yo safalumadi Diyobi sa sibai sa laoma ena luma be maꞌedi sa anꞌangogo. Ena kamkamna ganahewana yai maꞌedi amainiya yo nuwana sa liba fatalu. Edi ainauya hesa - hesa ena siluba yo beya adi salusalu gole yai sa ginaulidi, sa felen. ");
INSERT INTO bxh_vpl VALUES ("JB42_12","019_42_12","JOB","42","12","12","Fuya mulimulitadi yai Guyau, Diyobi ya ainauya diꞌoi, habahim fuya bwaꞌibwaꞌina yai. Be aho te, ena sipi 14 tausan, kamela 6 tausan, bulumakau 2 tausan, yo ena donki 1 tausan. ");
INSERT INTO bxh_vpl VALUES ("JB42_13","019_42_13","JOB","42","13","13","Yo nanatuna sa peꞌi tatau faligigi luwaga yo wawahin faihona, ya falau damahidi. ");
INSERT INTO bxh_vpl VALUES ("JB42_14","019_42_14","JOB","42","14","14","Natuna waihin bwaꞌibwaꞌina hesana ya tole Demaima, fafaluwagana hesana Kesiya na fafaihonana hesana Kelen-Hapuka. ");
INSERT INTO bxh_vpl VALUES ("JB42_15","019_42_15","JOB","42","15","15","Diyobi nanatuna hasaladi sa loholoho wananaha habahim wawahin hahaisa nuꞌu mahudoꞌina yai. Tamadi ena ginauli ya daili be nanatuna hesa - hesa ena ya felen, nanatuna tatau yo wawahin mahudoꞌidi ya fagonafidi. ");
INSERT INTO bxh_vpl VALUES ("JB42_16","019_42_16","JOB","42","16","16","Mulina yai Diyobi ya miya lofalofa ee–, boliman 140, be afa wahawahana yo nanatudi sa tubu hinaga ya itadi. ");
INSERT INTO bxh_vpl VALUES ("JB42_17","019_42_17","JOB","42","17","17","Ya tautaulaꞌi wananaha, habahim ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Salumadi hige dodoga heyaheyayadi edi nuwanuwatuhu ti lau watanidi, yo tau heyaya edi miyamiya hige ti miyamiyaꞌedi, e Yaubada tau ꞌwaiyoꞌoꞌenna hige ti modeꞌedi mate, nuwadi ti amna. ");
INSERT INTO bxh_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Lisina yai, Yaubada ena laugagayo awaꞌabina kwadena sa lobahi, be sa fatili, na sa fadosi iꞌipa yo lahai. ");
INSERT INTO bxh_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Iti doha oyagi sa umahi hoꞌowa bubuna yai be adi fuya yai sa fuwa, siuhwalo fuyana, ibege ti hohoya edi maliyaho aniyona ya taumahata. ");
INSERT INTO bxh_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Dodoga heyaheyayadi edi laulau hige doha ite; iti doha hawahawa wenuna hwayahwayau ya yofohi. ");
INSERT INTO bxh_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Tau heyaya mate Yaubada haba ya fakasadi. Yaubada ena dodoga ibege maꞌedi ti miya esega. ");
INSERT INTO bxh_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Dodoga dudulaidi mate Yaubada ya ita watanidi yo ya bobodiyedi, na tau heyaya mate Yaubada haba ya fakamkamnadi. ");
INSERT INTO bxh_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Aee–, Guyau, ema Yaubada, dodoga mahudoꞌidi tanoꞌubu yai sa sibai, mate um wa hasai wananaha. Em namanamali ya mala wananaha, habahim galewa malana. ");
INSERT INTO bxh_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Wawaya nom haꞌa sa dabu, yo ma nomnomdi haba sa fadebasaen. Ami waiyunu lisidi yai haba ya ita watanimiu, yo ya bobodiyemiu; Sai haba ya fakamkamnamiu. ");
INSERT INTO bxh_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Ibege ya gogo gesagesa, paꞌana fuya ouꞌouli, Guyau ya itaꞌita watanigu, doha sipi tau ita wata. ");
INSERT INTO bxh_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","1 Ya faꞌanyawasigu hawahawa idaꞌidahedi yai yo ya foya lauwegu hoꞌowa daudaumwalina yai. ");
INSERT INTO bxh_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Yaluwagu ya fafwaufwau fuyoi. Hesana yai edaꞌeda dudulaina yai ya foyahigu. ");
INSERT INTO bxh_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Yena E lau hobohobo kamukamumuna yai ibege heyaheyaya laꞌi ya ꞌwasabuwen, paꞌana um maꞌegu. Em pidipidili yo em tuꞌe sa bobodiyegu. ");
INSERT INTO bxh_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Agu waiyunu matadi yai, agu anꞌangogo wa abi nonohai. Kulugu wa famaꞌi. Agu kapu wa famohafu tabutabuliwa. ");
INSERT INTO bxh_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Wananaha, egu miya mahudoꞌina yai, wa faloholohogu yo wa gadogadosisiyegu. Na yau haba Guyau ena ai luma E gogo ee–, hige anadan. ");
INSERT INTO bxh_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Guyau mate egu mala yo tau fafamwahuli. In egu mwahuli tau faꞌadidilina be sai haba E ꞌwasabuwen? ");
INSERT INTO bxh_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Yena agu waiyunu, heyaya dodogadi sa duhu mahanoꞌigu bena sa faheyayagu, iti moho haba sa faꞌalu betibeti be sa beꞌu. ");
INSERT INTO bxh_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Ibe sa fataꞌiꞌiligu; ibege ya ꞌwasabu. Yo yena agu halulu sa laoma, haba nuwagu ya adidili. ");
INSERT INTO bxh_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Guyau lisina yai ginauli esega E anꞌetai yo E fanuha wananahai mate, bena Guyau, ena luma yai E miya, fuya ouꞌouli, egu mwahuli ganahewana yai be nenena loholohona E itaꞌitai yo E laulauꞌuꞌula lau lisina ena Dubu Tabuna yai. ");
INSERT INTO bxh_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Yena pilipili E fahoina haba ya bobodiyegu. Haba ena palai fafatabuna yai ya simogu, yo umeꞌehu hewa wananahana yai haba ya tolegu. ");
INSERT INTO bxh_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Habahim, E tamahiti, be agu waiyunu sa fataꞌiꞌiligu E tiꞌe tawaidi be ibege ti lei hafihafitigu. Em luma fatabuna yai haba egu antalasam E ginauli ma wowogu; Haba E wana yo dagugu loholohona E ginauli be Guyau E fadebasae. ");
INSERT INTO bxh_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Aee–, Guyau, u nuwatohatohaegu, yena E yoga laꞌilaꞌi alinagu u atahi be u bui. ");
INSERT INTO bxh_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Wa liba uwen, “U laoma u fadebasaegu!” Logena e laoma. ");
INSERT INTO bxh_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Yau em tau lau fayofayo! Tabu u manabalaꞌegu be u taꞌai mulimuliyegu. Um tau sagusaguhigu, Yaubada, um tau famwahuligu; tabu u nuwa afulegu. ");
INSERT INTO bxh_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Ibe tamagu yo tinagu sa lau afulegu. Guyau haba ya abi komakomanigu. ");
INSERT INTO bxh_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Aee–, Guyau! Agu waiyunu debadi yai em miyamiya, u faꞌatagu, be laulau dudulaidi, ya miyamiyaꞌedi. ");
INSERT INTO bxh_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Agu waiyunu liba bwalabwaladi sa libaedi, sa fanuha bena sa faheyayagu be tabu u fele afulegu lebedi yai. ");
INSERT INTO bxh_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","E sunumaꞌen mate Guyau ena loholoho haba E ita, hola ma mwahuligu. ");
INSERT INTO bxh_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Be Guyau u sunumaꞌen yo nuwam i adidili. ");
INSERT INTO bxh_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Fuya hesa Abimeleki matana yai Deiwidi doha yauyaule be ya fatamali ya lau. Muli yai, Yaubada sidohana Deiwidi ena sagusaguhina lahaina yai, mate lilina Deiwidi ya uli. Fuya ouꞌouli haba Guyau E fafadebasae, fadebasaena sopagu yai ibege ya fatautau. ");
INSERT INTO bxh_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Guyau haba E toletole hitin, safalumadi sa abi faheyayadi, ti ataꞌatahi be ti kwade. ");
INSERT INTO bxh_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Mahudoꞌida Guyau te fadebasae, yo hesana te lau hitin gogo. ");
INSERT INTO bxh_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","E lauꞌuꞌula lau Guyau lisina be ya atahi; yo egu ꞌwasabu mahudoꞌidi yai ya fasagu fahigu. ");
INSERT INTO bxh_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Salumadi Guyau sa sunumaꞌen bena ya saguhidi, mate nuwadi ti kwade, paꞌana fuya ouꞌouli haba ya sagusaguhidi. ");
INSERT INTO bxh_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Tau gogo gesagesa te, sa lauꞌuꞌula lau Guyau lisina, be Guyau ya atahi, edi pilipili mahudoꞌidi yai, ya fasagu fahidi. ");
INSERT INTO bxh_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Salumadi Guyau sa fafadebasae mate Yaubada ena anelu ya bobodiyedi yo heyaya yai ya fafasagufahidi. ");
INSERT INTO bxh_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Haga au lau dadai, haba ami ita lobahi, Guyau ya loholoho, Tau sunusunumaꞌenna haba nuwadi sa amna. ");
INSERT INTO bxh_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Umi ena dodoga fafatabudi, Guyau au faꞌatitiyen paꞌana salumadi sa fafaꞌatitiyen ibege ti kuꞌu. ");
INSERT INTO bxh_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Laiyon gonowana adi anꞌan ya ofi be haba sa guliyam, na salumadi Guyau sa sunusunumaꞌen mate, ibege ginauli loholohodi hesa lisina yai ti kuꞌu. ");
INSERT INTO bxh_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Nanatugu, au laoma be au ataꞌatahi; Guyau fafaꞌatitina haba E fatalahamiu. ");
INSERT INTO bxh_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Sai ya fanuha ya miya lofalofa, yo loholoho ya fahoina, ");
INSERT INTO bxh_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","lelona yo sopana bena ya komanidi, tabu i fapaisowa faheyayadi yo tabu i laulau bwalabwala. ");
INSERT INTO bxh_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Heyaheyaya yai bena wa nuwabui, yo bena wa anpate adidili, be miyamiya daudaumwalina wa miyamiyaꞌedi. ");
INSERT INTO bxh_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Guyau tau laulau dudulai ya bobodiyedi, na yena edi tan ya atahiyedi haba ya fasagufahidi; ");
INSERT INTO bxh_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","na nenena ya fasana hudoꞌiyen, tau heyaya lisidi yai; yo sa peꞌi, haba ya nuwa fuiyedi. ");
INSERT INTO bxh_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Guyau, tau laulau dudulai edi tan ya atahi. Haba ya saguhidi, edi pilipili mahudoꞌidi yai haba ya fasagu fahidi. ");
INSERT INTO bxh_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Guyau mate fadidi yai, salumadi sa nuwa belubelu ya fasagu fahidi. ");
INSERT INTO bxh_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Tau laulau dudulai, pilipili boludi ya fahoinadi, in moho Guyau ya fasagufahi pilipili lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Guyau ya ita watan komakomaniꞌi be hige siyadana laꞌi i tapwai. ");
INSERT INTO bxh_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Heyaya tau ginaulina haba ya faheyaya fuyoi. Na tau laulau dudulai adi waiyunu haba sa fakamkamnadi. ");
INSERT INTO bxh_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Guyau haba ena tau lau fayofayo ya sagu fahidi; yo salumadi sa sunumaꞌen bena In tau saguhidi, ibege heyaya ti fahoina. ");
INSERT INTO bxh_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Deiwidi ana wana. Fuyanna maꞌena Betesiba heyaya sa ginauli mate Peloweta Neitan ya lau lisina. (2 Samuwela 11 yo 12) Aee–, Guyau, em fanufanuha ya ota esegahi, be u nuwa tohatohaꞌegu. Um tau fanuwatohatoha, be egu heyaya u nuwatuhu afuledi, ");
INSERT INTO bxh_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Egu heyaya mahudoꞌidi u kaisu afuledi. ");
INSERT INTO bxh_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Egu heyaya E sibaidi na fuya ouꞌouli E nuwanuwatuhuidi. ");
INSERT INTO bxh_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Um moho lisim yai heyaheyaya E ginauli, laulau heyayana matam yai E ginauli; be fuyanna wa falibagu uwen, “Heyaya wa ginauli!” Mate, wa liba dudulai. ");
INSERT INTO bxh_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Hola tinagu bogana yai ya lau ee–, ena fuya yosigu yai mate haꞌa E heyaya. ");
INSERT INTO bxh_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Um wa fanuha wananaha bena ma nuwa ofi fahigu E laowa lisim, tabu ya nuwa luwaluwaga; sibasiba um wa fatalahagu. ");
INSERT INTO bxh_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Egu heyaheyaya u nuwa afuledi. Na u kaisugu, haba E aꞌa. ");
INSERT INTO bxh_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Nuwagu wa fakamkamna yo yaluwagu wa lau lidiyen, in moho E atahi egu heyaheyaya wa nuwatuhu afuledi be nuwagu ya amna wananaha yo E kwade. ");
INSERT INTO bxh_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Tabu egu heyaya u itaꞌita lau lisidi, na mahudoꞌina u nuwatuhu afuledi. ");
INSERT INTO bxh_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Aee–, Yaubada, nuwagu yo yaluwagu mahudoꞌina u fafwaufwau fuyoi. ");
INSERT INTO bxh_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Tabu u tole hudoꞌiyegu, e Yaluwam Tabuna lisigu yai u lawe hudoꞌiyen. ");
INSERT INTO bxh_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","U saguhigu be em liba, nuwa amnana i abigu. Doha egu fuya nuwabui bwaꞌibwaꞌina yai. Nuwagu u faloholoho fuyoi. ");
INSERT INTO bxh_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Habahim em laulau tau heyaya E faꞌatadi be haba sa timuli bui lisim. ");
INSERT INTO bxh_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Aee–, Yaubada, lau pono yai u fofofahigu, yo u bobodiyegu na em laulau dudulai debadi yai haba E wana. ");
INSERT INTO bxh_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Aee–, Guyau, u saguhigu be ya libaliba na haba E fadebasaem. ");
INSERT INTO bxh_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Suisui antalasamedi, yo antalasam gabugabudi hinaga hige nuwam ti amnaedi. ");
INSERT INTO bxh_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Aee–, Yaubada, nuwagu ya tamo golugolu mate egu antalasamna logena; Yaubada um nuwa lidilidi yo nuwa talu wa fanuha. ");
INSERT INTO bxh_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Aee–, Yaubada u nuwatohatohaemai, yo u nuwa amnaꞌemai na em loholoho u felemai. ");
INSERT INTO bxh_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Be em laulau ai tanoꞌubu ti sibaidi. Tau abiꞌabi famwahuli um, bena sa sibaim. ");
INSERT INTO bxh_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Yaubada! Dodoga ti fadebasaem; dodoga mahudoꞌidi ti fadebasaem! ");
INSERT INTO bxh_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Dodoga nuꞌu mahudoꞌina yai ti wana ma kwadedi, paꞌana dudulai yai wa fadudulaidi. Yo wa foya fadudulaidi. ");
INSERT INTO bxh_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Yaubada! Dodoga ti fadebasaem. Mahudoꞌidi ti fadebasaem! ");
INSERT INTO bxh_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Habahim gabu anꞌandi sa anaho; Yaubada Eda Yaubada ya aiꞌainauyaida. ");
INSERT INTO bxh_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Yaubada i ainauyaida, be dodoga mahudoꞌidi tanoꞌubu yai haba sa faꞌatitiyen. ");
INSERT INTO bxh_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Aee–, Guyau, hitina yo hitina, um tau ita watanimai. ");
INSERT INTO bxh_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Tuꞌa yo tanoꞌubu hola hige ti tubu, na um ibom Yaubada ota otafahina. ");
INSERT INTO bxh_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Dodoga wa bui fafuyodi afusa. Uwen, “Umi tau peꞌi, au fafuyo afusa!” ");
INSERT INTO bxh_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Boliman tausan-esega um matam yai mate doha bon moho, haꞌa ya ofi, e doha iꞌipa esega tuhulina. ");
INSERT INTO bxh_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Dodoga edi mwahuli wa tomo feulaidi doha eno suwai ya ofi. Iti doha hawahawa hesa hwalahwalaladi ya in, ");
INSERT INTO bxh_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","na maimailafidi ya hohoya be ya peꞌi, ");
INSERT INTO bxh_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","laulauna doha manabalam ya fadawa wunumai, haba em manabala ꞌe ꞌwasabuwen. ");
INSERT INTO bxh_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Ema heyaya wa famahatadi, simosimodi hinaga wa itadi. ");
INSERT INTO bxh_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Ema miya lahaidi mahudoꞌidi yai wa manamanabalaꞌemai, ema mwahuli wa tomo feulaidi doha yahafuwa. ");
INSERT INTO bxh_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Gonowana te miya boliman 70, na yena te fulufuluga haba 80, in moho ema miya lahaidi yai pilipili yo kamkamna ꞌe fafahoinadi, na hige walolona ꞌe peꞌi. ");
INSERT INTO bxh_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Hige sai em manabala laꞌina i sibai, na ibe ꞌe siba haba ꞌe ꞌwasabuwem. ");
INSERT INTO bxh_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","U fatalahamai be em sibasiba ai abi, ema lahai ya tupo. ");
INSERT INTO bxh_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Aee–, Guyau, u feulama. Em tau lau fayofayo ai, u nuwatohatohaimai. ");
INSERT INTO bxh_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Hwalahwalaladi em gadogadosisi otaꞌotafahina lisina yai u famohafumai be ema miya lahaidi mahudoꞌidi yai haba ma kwademai ꞌe wana. ");
INSERT INTO bxh_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Boliman lofadi somo wa fafapilipilimai mate bolimandi lofadi hinaga nuwamai u fakwadedi. ");
INSERT INTO bxh_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Em paisowa gigibwalina u faꞌitamai, ai em tau laufayofayo lisimai yai, yo em gigibwali namanamalina, nanatumai u faꞌitadi. ");
INSERT INTO bxh_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Guyau ema Yaubada, u ainauyaimai; ema paisowa hinaga ti loholoho. ");
INSERT INTO bxh_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Au laoma! Te wana lau Guyau lisina, tau famwahulida te wowoʼen ma kwadeda. ");
INSERT INTO bxh_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Te laoma lisina ma lautoꞌida; dagugu laꞌilaꞌi te ginaulidi yo te wana ma kwadeda ya lau lisina. ");
INSERT INTO bxh_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Guyau mate In Hewa Wananaha Yaubadana, yaubada mahudoꞌidi edi wasawasa. ");
INSERT INTO bxh_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Tanoꞌubu mahudoꞌina mate in, enehena, gon yai ya hasai be–, oya yai yo. ");
INSERT INTO bxh_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Gabogabo yo tanohi pitapitalina ya fatubudi, mate In tanuwagadi. ");
INSERT INTO bxh_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Au laoma te tuli bono be Guyau tau fatubuda te fadebasae. ");
INSERT INTO bxh_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Paꞌana in eda Yaubada na ita ena gana ganahewana yai doha sipi tau itaꞌita watanidi ena sipi ya bobodiyedi. Aee–, aho te ibe ami ataꞌatahi lau lisina! ");
INSERT INTO bxh_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Tabu nuwamiu au guduguduidi doha afa wahamiu somo sa ginauli Meliba yai, lahaina yai Masa yai, nuꞌu pitapitalina yai. ");
INSERT INTO bxh_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Amainiya afa tamamiu sa lau itagu. Ginauli E ginaulidi sa itadi haꞌa. Na hola sa anpateigu. ");
INSERT INTO bxh_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Bolima 40 egu manabala hiti ni lisidi yai. Ayawa, “Dodoga ni, nuwadi sa anꞌanloya gaibu, egu laulau hige ti sibaidi.” ");
INSERT INTO bxh_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Be manabala yai E angwala bena tabu ti luhulau egu aba anꞌanyawasi yai. ");
INSERT INTO bxh_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Tanoꞌubu mahudoꞌimiu ma kwademiu, au halabo lau Guyau lisina. ");
INSERT INTO bxh_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Guyau au fadebasae ma nuwa loholohomiu. Au laoma Guyau matana yai ma kwademiu yo ma wanawanamiu. ");
INSERT INTO bxh_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Guyau mate Yaubada! In ya ginaulida bena, enehena. Ita ena dodoga doha sipi baiwadi. ");
INSERT INTO bxh_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Au luhulau edaꞌedana hafohafona yai, ma laulautoꞌimiu, au luhulau Dubu Tabuna dobidobina yai ma fadebasaemiu! Au lautoꞌiyen yo hesana au fadebasae. ");
INSERT INTO bxh_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Paꞌana Guyau ya loholoho wananaha. Ena gadosisi otaꞌotafahina ya ota esegahi ya lau ee–, hige anadan, yo hitina - hitina ena sunuma ya ota esegahi ya lau ee–, hige anadan. ");
INSERT INTO bxh_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Aee–, Yaluwagu, Guyau u fadebasae! Ma nuwa ofi fahigu hesana fafatabuna E fadebasae! ");
INSERT INTO bxh_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Aee–, yaluwagu, Guyau u fadebasae. Ena ainauya mahudoꞌidi haba E nuwa nuwatuhuidi, ");
INSERT INTO bxh_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","in egu heyaheyaya mahudoꞌidi ya nuwatuhu afuledi yo agu asiyebo mahudoꞌidi ya faloholohodi, ");
INSERT INTO bxh_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Peꞌi yai ya famwahuli fuyoꞌigu, be ena faloholoho yai, in ya gadogadosisiyegu yo ya fanuwatohatohaegu. ");
INSERT INTO bxh_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Egu miya lahaidi ganahewadi yai ginauli loholohodi ya aiꞌainauyaigu, be haba taugu ena adidili ya fafwaufwau fuyoi doha magesubu gubugubufwauna. ");
INSERT INTO bxh_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Guyau laulau dudulaina yai safalumadi sa ita lidilidiyedi ya saguhidi. ");
INSERT INTO bxh_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Ena nuwatuhu Mose ya fatalaha, yo ena paipaisowa Isalaela dodogadi hinaga ya fatalahadi. ");
INSERT INTO bxh_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Guyau in fafanuwatohatohana yo anꞌansoina, hige i manamanabala feula yo ena gadosisi ya fafatadada. ");
INSERT INTO bxh_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","In ibege fuya ouꞌouli i laulau fagilu, yo ena manabala ibege i ota esegahi. ");
INSERT INTO bxh_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Eda heyaya debadi yai in gonowana ya fakamkamnada, in moho ibege i ginauli. ");
INSERT INTO bxh_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Doha galewa tanoꞌubu ya saipwai mate ena gadosisi laꞌina tau fafaꞌatitiyenna lebedi yai. ");
INSERT INTO bxh_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Eda heyaheyaya lofana doha tefa saisai yai, na ya lau ee–, tefa leuleu yai mate ya kamfahidi. ");
INSERT INTO bxh_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Doha taumoho nanatuna ya fanuwatohatohaedi mate doha Guyau tau faꞌatitiyenna ena fanuwatohatohaedi. ");
INSERT INTO bxh_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Paꞌana ya sibai, ita tanohi moho lisina yai ya ginaulida, be ya nuwatuhui ita hige dodoga adiꞌadidilida. ");
INSERT INTO bxh_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Eda miya lahaidi yai doha hawahawa, doha mula inꞌin gaibudi, sa taya be sa peꞌi. ");
INSERT INTO bxh_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Hwayahwayau ya towa tawaidi be sa failaulauwidi na hige sai i ita fuyoꞌidi. ");
INSERT INTO bxh_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Safalumadi Guyau sa ita hitiꞌi, ena gadosisi otaꞌota fahidi. Lisidi yai, ena loholoho haba ya ota esegahi ya lau ee–, hitina yo hitina. ");
INSERT INTO bxh_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","Umi, safalumadi ena liba fasunuma yo laugagayo sa atahiyedi, mate bena sa awaꞌabiyedi. ");
INSERT INTO bxh_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Guyau galewa ya abi ena aba taꞌai, be amainiya ginauli mahudoꞌidi ya tanuwagaidi. ");
INSERT INTO bxh_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Guyau au fadebasae! Umi, ena anelu adiꞌadidilidi yo dididigadi, yo umi ena laugagayo au awaꞌabiyedi, yo au ataꞌatahi lau somo ya libalibaedi. ");
INSERT INTO bxh_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Wananaha! Guyau au fadebasae! Umi, Galewa ena hiyala dodogadi, yo umi, ena tau paisowa, be ena nuwatuhu ami laulau watandi, ");
INSERT INTO bxh_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Ginauli mahudoꞌidi ya ginauli ena aba baꞌisa nuꞌuna mahudoꞌina yai, Guyau, au fadebasaen. Guyau ee–, egu nuwanuwatuhu yai E fadebasaem. ");
INSERT INTO bxh_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Guyau ya libalau egu Guyau lisina; Ai sibagu u taꞌai ya lau ee–, am waiyunu E abidi, be ahem ubuna yai E toledi. ");
INSERT INTO bxh_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Guyau! Em gigibwali ya tadada Saiyon Nuꞌuna yai, be am waiyunu haba wa tanuwagaidi. ");
INSERT INTO bxh_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Lahaina ni haba am waiyunu wa hiyalaidi. Haba em dodoga sa faisagusagu. Doha hwahwalala sibudi, tanohi sa faꞌwau, am hewahewali tatau haba sa laoma sa saguhimiu. ");
INSERT INTO bxh_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Guyau haꞌa ya angwala yo ibege nuwana i bui. Um haba tau antalasam hige ana siga, doha Melekisideki ena pele. ");
INSERT INTO bxh_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Guyau mate In nima sibam yai, lahaina ni yena ya manabala haba kin ya faheyayadi. ");
INSERT INTO bxh_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Haba ena fakasa ya fatalu ai nuꞌu hesa - hesa, be haba silan yai ya famohafudi, na tanoꞌubu edi kin haba ya sai tawanidi. ");
INSERT INTO bxh_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Sagasaga edaꞌeda sadaina yai, haba ainiya Kin hoꞌowa ya nom, be tauna ya faꞌadidilidi. Ana waiyunu haba ya lei hafihafitidi. ");
INSERT INTO bxh_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Beth Haba sidohana taumoho hewahewalina ena mwahuli ya bobodiyei? Bena Em laugagayo ya awa abiyedi. ");
INSERT INTO bxh_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Nuwagu ma ofi fahina em laugagayo E awa abiyen. U ita watanigu, be ibege em laugagayo ya lau afuledi. ");
INSERT INTO bxh_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Em liba E nuwatuhui nuwagu yai, be ibege heyaheyaya ya ginauli ai lisim. ");
INSERT INTO bxh_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Guyau ee–, E fadebasaem. Em laugagayo u fatalahagu. ");
INSERT INTO bxh_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Laugagayo mahudoꞌidi moꞌam yai wa libaedi. E liba fuyoꞌidi. ");
INSERT INTO bxh_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","E kwade fuyanna em laugagayo E laulau watandi, habahim gogo wasawasadi. ");
INSERT INTO bxh_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Em abiꞌabi yo em laulau E nuwatuhu fadosidi. ");
INSERT INTO bxh_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Em laugagayo E nuwa amnaedi, ibege nuwagu i fui. ");
INSERT INTO bxh_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Wana Tau Lau Kulukuluwenna, Deiwidi ana Wana Hesa Guyau, wa siba wananahaigu nuwagu ganahewana wa ita faꞌofi. ");
INSERT INTO bxh_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Egu taꞌai yo egu obiyo haꞌa wa sibaidi. Edam ya lofa in moho egu nuwanuwatuhu haꞌa wa sibaidi. ");
INSERT INTO bxh_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Egu leu, egu sae yo egu anyawasi wa sibaidi. Egu laulau mahudoꞌidi haꞌa wa itadi. ");
INSERT INTO bxh_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Guyau, hola hige liba hesa ya libaen na haꞌa wa siba. ");
INSERT INTO bxh_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Um egu eda wa bwaꞌiyen yo hinaga muligu yai wa laolaoma, em gigibwali yai wa bobobodiyegu. ");
INSERT INTO bxh_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Sibasiba doha ite mate noꞌona hige gonowagu, ya hasai wananaha be hige gonowana somo ya ita lobahi. ");
INSERT INTO bxh_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Siya haba E fuyofuyoꞌegu be ibege u itagu? ");
INSERT INTO bxh_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Ibe E hasai galewa, um amainiya; ibe E peꞌi be sa boꞌusaigu, um hinaga amainiya. ");
INSERT INTO bxh_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Ibe E lofo lau maihala ena aba kepama nuꞌuna yai, e E lau maihala ena aba bulu nuꞌuna yai E miya, ");
INSERT INTO bxh_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","ai nuꞌudi ni hinaga haba wa foyahigu, na em adidili aba bobodiyegu. ");
INSERT INTO bxh_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Yau gonowagu kamumu E faliba ya simogu e mala ya fataꞌiꞌiligu gonowana e faliba ya iꞌipa. ");
INSERT INTO bxh_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","In moho kamumu yai hige gonowana ya ala simoꞌem hinaga. Iꞌipa lisim yai ya mahata doha lahai. Kamumu yo mahata um lisim yai gonogonowadi. ");
INSERT INTO bxh_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","15","Tinagu bogana ganahewana yai wa itagu; um ibom moho wa siba yau amainiya, kamumu ganahewana yai. Taugu mahudoꞌidi wa ginaulidi, wa fasusu gogondi tinagu bogana ganahewana yai. E fadebasaem paꞌana wa ginauli loholohoꞌigu yo wa ginauli komakomanigu. E siba wananaha em paisowa sa fanuwa noꞌonoꞌo wananaha. ");
INSERT INTO bxh_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Taugu hola hige u fasusu gogondi na hola hige lahai bwaꞌibwaꞌina i tubu, mate haꞌa wa itagu. Na egu mwahuli lofana fisa haꞌa wa uli nonohai em buka yai. ");
INSERT INTO bxh_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","Aee–, egu Yaubada, hige gonowana em nuwatuhu ya siba ofinidi, paꞌana sa ouli wananaha! ");
INSERT INTO bxh_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Hige gonowana hinaga ya fatilidi paꞌana sa ouli wananaha, habahim gelegele fufuꞌadi! Yena bena mahudoꞌina E fatili, mate yena E eno obiyo, um maꞌegu. ");
INSERT INTO bxh_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Aee–, egu Yaubada, E fanuha wananaha bena heyaya tau laulau ginauli wa wunuidi! Yo tau aiꞌaiyunu wa falakodi. ");
INSERT INTO bxh_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Sa liba fafaheyayam yo hesam hige ti faꞌatitiyen. ");
INSERT INTO bxh_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","22","Guyau, tau ꞌwaiyoꞌoꞌem hinaga E ꞌwaiyoꞌoꞌedi. Em liba hige ti lau watan be iti agu waiyunu. ");
INSERT INTO bxh_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Nuwagu ganahewana u mainene komakomaniꞌi, egu nuwanuwatuhu u sibaidi. ");
INSERT INTO bxh_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Laulau heyaheyayadi somo lisigu yai u faꞌitagu na u foya lawegu mwahuli edaꞌedana otaꞌotafahina lisina yai. ");
INSERT INTO bxh_vpl VALUES ("PR1_7","021_1_7","PRO","1","7","7","Guyau ꞌwasabuna mate sibasiba fatufatubuna, na yauyauledi mate gaimumu sa ꞌwaiyoꞌoꞌedi. ");
INSERT INTO bxh_vpl VALUES ("PR1_8","021_1_8","PRO","1","8","8","Natugu, tamam ena gaimumu u atahiyedi yo tinam ena lau faꞌata tabu u awayagalaꞌedi. ");
INSERT INTO bxh_vpl VALUES ("PR1_9","021_1_9","PRO","1","9","9","Edi lau faꞌata haba ya saguhim, wa famala doga dudulaina, doha mula kulum yai, yo doha gadogado gadom yai nenem ya faloholoho. ");
INSERT INTO bxh_vpl VALUES ("PR5_8","021_5_8","PRO","5","8","8","Waihin matamata heyayana u gebaen, Tabu u lau ena luma. ");
INSERT INTO bxh_vpl VALUES ("PR5_9","021_5_9","PRO","5","9","9","Doꞌata dodoga ibege ti faꞌatitiyem yo dodoga heyayadi haba sa wunuim. ");
INSERT INTO bxh_vpl VALUES ("PR5_21","021_5_21","PRO","5","21","21","Doga somo ya ginaginauli mate Guyau ya ita faꞌofindi yo ena aba lau mahudoꞌidi ya mainene komaniꞌi. ");
INSERT INTO bxh_vpl VALUES ("PR5_22","021_5_22","PRO","5","22","22","Laulau heyaheyayadi ya laulauwedi yo ena heyaya sa au didini. ");
INSERT INTO bxh_vpl VALUES ("PR5_23","021_5_23","PRO","5","23","23","Ya yauyaule na hige i ita wata fuyoi, ena eda ya lau palei be ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("PR6_20","021_6_20","PRO","6","20","20","Natugu, tamam yo tinam ginauli mahudoꞌidi sa fatalaham u lau watandi. ");
INSERT INTO bxh_vpl VALUES ("PR6_21","021_6_21","PRO","6","21","21","Edi liba u sogohidi ");
INSERT INTO bxh_vpl VALUES ("PR6_22","021_6_22","PRO","6","22","22","Yena edaꞌeda yai wa laulau, edi lau fagagayo haba sa fatalaham. Em eno yai libadi te haba sa bobodiyem. Yena wa eno obiyo haba sa libawa lisim. ");
INSERT INTO bxh_vpl VALUES ("PR6_23","021_6_23","PRO","6","23","23","Edi lau faꞌata yai, edaꞌeda sa faꞌitam doha mala kamumu yai. Sa liba suꞌuim yo sa fatalaham sidohana bena edaꞌeda dudulaina sa faꞌitam, ");
INSERT INTO bxh_vpl VALUES ("PR6_24","021_6_24","PRO","6","24","24","be tabu sadaim yai tau miya, waihinina matamata heyaheyayana ena liba amꞌamnadi yai i foya fagegewalim. ");
INSERT INTO bxh_vpl VALUES ("PR6_25","021_6_25","PRO","6","25","25","Tabu hasalana yai nuwam i abi e ena kinokinoi yai i nohoim. ");
INSERT INTO bxh_vpl VALUES ("PR8_22","021_8_22","PRO","8","22","23","Sibasiba ya liba iyen, Beyabeyana fuya fatufatubuna yai Yaubada ena paisowa ya fatubu ya ginauli mate, bwaꞌibwaꞌina yau, ya ginauligu, habahim tanoꞌubu ya ginauli. ");
INSERT INTO bxh_vpl VALUES ("PR8_24","021_8_24","PRO","8","24","24","Fuyanna hola hige gabogabo yo hola hige hoꞌowa yomayoman yai ti kalamahano na yau haꞌa E tubu. ");
INSERT INTO bxh_vpl VALUES ("PR8_25","021_8_25","PRO","8","25","25","E tubu bwaꞌi, habahim tuꞌa yo uduhuli. ");
INSERT INTO bxh_vpl VALUES ("PR8_26","021_8_26","PRO","8","26","26","Hola hige tanoꞌubu yo gabu na yau haꞌa E tubu. ");
INSERT INTO bxh_vpl VALUES ("PR8_27","021_8_27","PRO","8","27","27","Fuyana Yaubada galewa ya ginauli yo gabogabo adi dandan ya lufadi, mate yau amainiya. ");
INSERT INTO bxh_vpl VALUES ("PR8_28","021_8_28","PRO","8","28","28","Fuyana yada galewa yai ya toledi yo gabotun ubuna yai yomayoman lisidi yai hoꞌowa aliꞌalitana ya pisapisalama, be gabogabo ya siu mate yau amainiya. ");
INSERT INTO bxh_vpl VALUES ("PR8_29","021_8_29","PRO","8","29","29","Yau amainiya fuyana Yaubada gabogabo anadandan ya tole yo ya lau fagagayo bena tabu i siu be anadan i hin diꞌoi. Tanoꞌubu ena aba ota ya faꞌobiyo mate yau amainiya hinaga. ");
INSERT INTO bxh_vpl VALUES ("PR8_30","021_8_30","PRO","8","30","30","Fuyanna yau fadidina yai na paisowa sibasibana mate lebegu yai. Fuya ouꞌouli nuwana E fafaꞌamna, yo fuya ouꞌouli maꞌegu mate egu kwade. ");
INSERT INTO bxh_vpl VALUES ("PR8_31","021_8_31","PRO","8","31","31","Tanoꞌubu yo dodoga ya ginaulidi E itadi mate E kwade wananaha. ");
INSERT INTO bxh_vpl VALUES ("PR9_1","021_9_1","PRO","9","1","1","Sibasiba ena luma ya ginauli; ana duhu faligigi luwaga uliꞌulidi ya tadidi. ");
INSERT INTO bxh_vpl VALUES ("PR9_2","021_9_2","PRO","9","2","2","Kalahe ya abi nonohai mataꞌasi laꞌilaꞌi ana yo ana wain ya faꞌasi; ena fatafata hinaga ya abi nonohai. ");
INSERT INTO bxh_vpl VALUES ("PR9_3","021_9_3","PRO","9","3","3","Ena tau lau fayofayo wawahindi ya duidi sa lau be tefa hewa wananahana taon lisina yai, dodoga sa yogaidi. ");
INSERT INTO bxh_vpl VALUES ("PR9_4","021_9_4","PRO","9","4","4","Tiyen, “Faꞌeli toutou yo yauyaule ti laoma egu luma. ");
INSERT INTO bxh_vpl VALUES ("PR9_5","021_9_5","PRO","9","5","5","Au laoma, agu kalahe au an yo wain E faꞌasi ami au nom. ");
INSERT INTO bxh_vpl VALUES ("PR9_6","021_9_6","PRO","9","6","6","Faꞌeli toutou au fatautau, haba ami miya. Sibasiba au famuli watan.” ");
INSERT INTO bxh_vpl VALUES ("PR13_1","021_13_1","PRO","13","1","1","Wawaya nuwanuwatuhuna mate tamana ena gaimumu ya atahiyedi. Na doga nuwanuwa saesaena mate gaimumu hige i atahiyedi. ");
INSERT INTO bxh_vpl VALUES ("PR13_4","021_13_4","PRO","13","4","4","Doga ꞌwaweꞌwawewena ginauli ya fanuha wananahaidi in moho ibege i abidi, na tau paisowa adidili somo ya fanuha haba ya abi. ");
INSERT INTO bxh_vpl VALUES ("PR13_24","021_13_24","PRO","13","24","24","Sai natuna hige i pidili mate ya ꞌwaiyoꞌoꞌen, na sai natuna ya gadosisiyen mate ya fadudulai. ");
INSERT INTO bxh_vpl VALUES ("PR17_21","021_17_21","PRO","17","21","21","Wawaya yauyaulena tamana nuwana ya faheyaya. Be tamana hige i kwade. ");
INSERT INTO bxh_vpl VALUES ("PR20_4","021_20_4","PRO","20","4","4","Tau ꞌwaweꞌwawewe, uma fuyana yai hige i paisowa, mate ibege ana kalahe. ");
INSERT INTO bxh_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","Ibe wa fatubu laulau dudulaina wawaya wa fatalaha komakomaniꞌi, haba ya laulauwedi ee–, ya bwaibwai. ");
INSERT INTO bxh_vpl VALUES ("PR23_13","021_23_13","PRO","23","13","13","Natum ya lau pono u fadudulai. Tabu u ita afulen; ibe wa pidili, ibege i peꞌi. ");
INSERT INTO bxh_vpl VALUES ("PR23_14","021_23_14","PRO","23","14","14","Nuwana haba ena mwahuli wa fasagufahi. ");
INSERT INTO bxh_vpl VALUES ("PR24_30","021_24_30","PRO","24","30","30","Doga ꞌwaweꞌwawewena yauyaulena ana gabu E bayawai. ");
INSERT INTO bxh_vpl VALUES ("PR24_31","021_24_31","PRO","24","31","31","E ita, pole sa dau hafihafiti yo ya hawa heyaheyaya na gabu ganana umeꞌehuna hige i obiꞌobiyo. ");
INSERT INTO bxh_vpl VALUES ("PR24_32","021_24_32","PRO","24","32","32","Ginaulidi te, E mainene komakomanidi; E fadosidi nuwagu yai be E ita lobahi. ");
INSERT INTO bxh_vpl VALUES ("PR24_33","021_24_33","PRO","24","33","33","Wa daludalui. Anyawasi begana wa daludalui. Nimam u noꞌudi begana, na u anyawasi! ");
INSERT INTO bxh_vpl VALUES ("PR24_34","021_24_34","PRO","24","34","34","Haba wa fagogo gesagesa maꞌamaꞌai doha tau angafu ya laoma, yo em ginauli sa kuꞌu doha tau angafu ya abidi. ");
INSERT INTO bxh_vpl VALUES ("PR26_13","021_26_13","PRO","26","13","13","Doga ꞌwaweꞌwawewena ya miyabon, paꞌana ena nuwatuhu bena laiyon edaꞌeda yai. ");
INSERT INTO bxh_vpl VALUES ("PR26_15","021_26_15","PRO","26","15","15","Doga ꞌwaweꞌwawewena ya fafanonoha; hige gonowana ana kalahe yai i saguhi fuyoi. ");
INSERT INTO bxh_vpl VALUES ("PR29_3","021_29_3","PRO","29","3","3","Doga nuwanuwatuhu sibasibana mate tamana haba ya kwade lisina yai, na sai laꞌi, wawahin matamata heyayadi ya fafaꞌiluwedi haba ena moni sa abi faꞌofi. ");
INSERT INTO bxh_vpl VALUES ("PR29_15","021_29_15","PRO","29","15","15","Pidipidili yo liba suꞌu mate wawaya ya fasibasiba na wawaya hige sai i fadudulai, tinana haba ya fataumayamaya. ");
INSERT INTO bxh_vpl VALUES ("PR29_17","021_29_17","PRO","29","17","17","Nanatumiu au fadudulaidi, haba emi miya sa fadaumwalidi yo haba ibege ti fataumayamayamiu. ");
INSERT INTO bxh_vpl VALUES ("PR31_10","021_31_10","PRO","31","10","10","Waihin paisowa mahudoꞌina gonowana ya ginauli mate ya loholoho wananaha, habahim gogo haisa doha posalu taumoho ya lobahi. ");
INSERT INTO bxh_vpl VALUES ("PR31_11","021_31_11","PRO","31","11","11","Taumoho ni, lahuna ya sunumaꞌen be ibege somo lisina yai i kuꞌu. ");
INSERT INTO bxh_vpl VALUES ("PR31_12","021_31_12","PRO","31","12","12","Waihin fuya ouꞌouli, loholoho moho ya leyama lahuna lisina na hige heyaya. Mate ya loholoho. ");
INSERT INTO bxh_vpl VALUES ("PR31_13","021_31_13","PRO","31","13","13","Mahina ya abidi, be ya fapaisowadi kaleko ya lau bodi. ");
INSERT INTO bxh_vpl VALUES ("PR31_19","021_31_19","PRO","31","19","19","Nimana yai mahina ya loidi. ");
INSERT INTO bxh_vpl VALUES ("PR31_20","021_31_20","PRO","31","20","20","Tau gogo gesagesa yo salumadi sa kuꞌu ya sagusaguhidi. ");
INSERT INTO bxh_vpl VALUES ("PR31_30","021_31_30","PRO","31","30","30","Waihin nene sedisedina, hasalana loholohona, ana bela haba ya waꞌe na waihin sai Guyau ya faꞌatitiyen mate sa noꞌonoꞌoꞌen. ");
INSERT INTO bxh_vpl VALUES ("PR31_31","021_31_31","PRO","31","31","31","Somo ya ginauli mate ena ainauya au felen, ena paisowa debana yai, haba sa liba hitihitiniꞌi duhu balabalamumu ai hafohafona. ");
INSERT INTO bxh_vpl VALUES ("EC1_1","022_1_1","ECC","1","1","1","Tanuwaga hesa Deiwidi natuna in Yelusalem edi kin ena gaimumu. ");
INSERT INTO bxh_vpl VALUES ("EC1_2","022_1_2","ECC","1","2","2","Iyen, Hige aniyona! Wananaha hige aniyona! Ginauli mahudoꞌina hige aniyona. ");
INSERT INTO bxh_vpl VALUES ("EC1_3","022_1_3","ECC","1","3","3","Taumoho paisowa mahudoꞌina ya ginauli tanohi yai, mate lisina yai somo ya lobahi? ");
INSERT INTO bxh_vpl VALUES ("EC1_4","022_1_4","ECC","1","4","4","Hitina ya laoma yo ya lau in moho tanoꞌubu otaꞌotana. ");
INSERT INTO bxh_vpl VALUES ("EC1_5","022_1_5","ECC","1","5","5","Maihala ya kepa na ya sina ee–, ya bulu na feula ya fuyo ena aba kepama yai be haba bobon ya sina boda. ");
INSERT INTO bxh_vpl VALUES ("EC1_6","022_1_6","ECC","1","6","6","Hwayahwayau ya towa hasa na ya bui be ya towa lidi, ya taꞌitaꞌiꞌili be ya fuyo ena aba towa bwaꞌibwaꞌina yai. ");
INSERT INTO bxh_vpl VALUES ("EC1_7","022_1_7","ECC","1","7","7","Hoꞌowa mahudoꞌidi sa didi lidi be gabogabo yai sa pei taluhidi. In moho gabogabo hige i mohafu. Haba sa fuyo ai ulu be ainiya sa didi fuyo lidi gabogabo. ");
INSERT INTO bxh_vpl VALUES ("EC1_8","022_1_8","ECC","1","8","8","Haba sai somo ya libaen? Ginauli mahudoꞌidi tanoꞌubu yai nenedi eseꞌesegadi, hige ti buidi, yo sa fakamna heyaheyaya. Ginauli boludi te itadi yo liba hudohudoꞌi te atahiyedi in moho hige gonogonowada. Te gado bena te itaꞌita, yo te ataꞌatahi ya laulaui moho. ");
INSERT INTO bxh_vpl VALUES ("EC1_9","022_1_9","ECC","1","9","9","Beyabeyana somo sa tubu haba sa lau boda fuyo. Dodoga somo beyabeyana sa ginaulidi haba sa ginauli fuyoꞌidi. Tanohi yai hige ginauli hesa falifalihuna. ");
INSERT INTO bxh_vpl VALUES ("EC1_10","022_1_10","ECC","1","10","10","Doga haba sidohana iyen, “Hola au ita! Ite ginauli falifalihuna.” Higeꞌe! Ginauli te, haꞌa beyabeyana amaiteꞌi; ita hola hige ta tubu. In, haꞌa amaiteꞌi. ");
INSERT INTO bxh_vpl VALUES ("EC1_11","022_1_11","ECC","1","11","11","Hige gonowana sai laꞌi hiti halo dodogadi i nuwatuhuidi, yo hiti hesa ai mulida sa tubu, ibege hiti ai mulidi sa tubu, ti nuwatuhuidi hinaga. ");
INSERT INTO bxh_vpl VALUES ("EC1_12","022_1_12","ECC","1","12","12","Yau tanuwaga yo yau beyabeyana Isalaela edi kin, Yelusalem yai. ");
INSERT INTO bxh_vpl VALUES ("EC1_13","022_1_13","ECC","1","13","13","Sibasiba yoꞌoyoꞌoina yai egu fuya E pei, bena sidohana ginauli mahudoꞌidi tanoꞌubu yai sa tubu te, paꞌana wananahana E yoꞌoi be E sibai. Yaubada mwahu laꞌilaꞌi dodoga lisidi yai ya tole. ");
INSERT INTO bxh_vpl VALUES ("EC1_14","022_1_14","ECC","1","14","14","Ginauli mahudoꞌidi sa ginaulidi maihala yai haꞌa E itadi, mahudoꞌidi hige aniyodi. E tafotafo watanidi, mate hige aniyodi, doha hwayau E tafotafo watan. ");
INSERT INTO bxh_vpl VALUES ("EC1_15","022_1_15","ECC","1","15","15","Somo haꞌa sa filisi hige gonowana ti fadudulai fuyoi. Somo hige amainiya, hige gonowana ti fatili. ");
INSERT INTO bxh_vpl VALUES ("EC1_16","022_1_16","ECC","1","16","16","Nuwagu yai yawa, “Yau E sibasiba wananaha, habahim kin hahaisa beyabeyana haꞌa Yelusalem yai. Ami ita! Yau sibasiba yo sonoga haꞌa E abidi.” ");
INSERT INTO bxh_vpl VALUES ("EC1_17","022_1_17","ECC","1","17","17","Sibasibana ena aba laoma somo yai, yo laulau yauyauledi E anpate bena E yoꞌoidi. In moho, E lobahi mate doha hwayahwayau E weꞌaweꞌai. ");
INSERT INTO bxh_vpl VALUES ("EC1_18","022_1_18","ECC","1","18","18","Sibasiba ya ouli, mate nuwa dubu hinaga ya laꞌi wananaha. Sibasiba ya laꞌi wananaha, mate nuwa heyaya hinaga doha. ");
INSERT INTO bxh_vpl VALUES ("EC2_1","022_2_1","ECC","2","1","1","Nuwagu yai yawa, “Haga nuwagu ya lau watan, ya lau ya kwadekwade gaibu be loholoho sidohana haba E lobahi.” In moho laulau te, hige aniyona. ");
INSERT INTO bxh_vpl VALUES ("EC2_2","022_2_2","ECC","2","2","2","E ita lobahi mate, liuliuhwa gaibu, laulau yauyaulena. Na kwade gaibu lisina yai, ibege loholoho ya lobahi. ");
INSERT INTO bxh_vpl VALUES ("EC2_3","022_2_3","ECC","2","3","3","Hola loholoho aniyona E yoꞌoi. Logena be nomnom yauyaule yo kwade hesa - hesa E anpateidi. E gado bena E siba somo ya loholoho dodoga lisidi yai, ai maihala tupotupona tanoꞌubu yai te. ");
INSERT INTO bxh_vpl VALUES ("EC2_4","022_2_4","ECC","2","4","4","Ginauli mahudoꞌina E ginauli. Egu luma E ginaulidi yo wain E umahidi gabudi yai. ");
INSERT INTO bxh_vpl VALUES ("EC2_5","022_2_5","ECC","2","5","5","Gabu E lau ginauli be ganahewadi yai fuwafuwa nene hesa - hesa E umahidi. ");
INSERT INTO bxh_vpl VALUES ("EC2_6","022_2_6","ECC","2","6","6","Hoꞌowa ipuna E ginauli, ainiya haba hoꞌowa E yahi be umaꞌuma laulau idahedi E fanom hoꞌowadi. ");
INSERT INTO bxh_vpl VALUES ("EC2_7","022_2_7","ECC","2","7","7","Egu tau lau fayofayo tatau yo wawahin E unedi, yo egu tau lau fayofayo haisa mate egu luma yai sa tubu. Egu bulumakau yo sipi baiwadi sa ouli, habahim dodoga haisa Yelusalem yai. ");
INSERT INTO bxh_vpl VALUES ("EC2_8","022_2_8","ECC","2","8","8","Siluba yo gole aiʼegu E abidi. Babaꞌisa yo nuʼu boludi edi gogo loholohodi hinaga E abidi. Tau wana tatau yo wawahin E fasinabodi hinaga. Tau lau fayofayo wawahin boludi E faidi sa famala doha lalahugu. ");
INSERT INTO bxh_vpl VALUES ("EC2_9","022_2_9","ECC","2","9","9","Yau E hasai wananaha habahim dodoga haisa Yelusalem yai. ");
INSERT INTO bxh_vpl VALUES ("EC2_10","022_2_10","ECC","2","10","10","Matagu yai somo E ita mate E fanuha bena E abi, yo nuwagu moho tanoꞌubu kwadena. In moho nuwagu ya loholoho egu paisowa lisina yai paꞌana egu abi peꞌipeꞌi logena maisagu. ");
INSERT INTO bxh_vpl VALUES ("EC2_11","022_2_11","ECC","2","11","11","Fuyanna ginauli mahudoꞌina nimagu yai E ginauli yo somo E ankamkamnaꞌen be loholoho E abi, E mainene sipoi be E lobahi mate ginauli mahudoꞌina te, hige aniyodi. Doha hwayau E tafotafo watan, hige agu loge. Maihala yai hige somo laꞌi ya abi. Ginauli mahudoꞌina ganahewana yai te mate E sibasiba wananaha. ");
INSERT INTO bxh_vpl VALUES ("EC2_12","022_2_12","ECC","2","12","12","Habahim egu nuwanuwatuhu E bui be sibasiba E ita sipoi. Kabakabaleya yo gelogeloma hinaga E nuwatuhu fadosidi. Kin, somo haꞌa ya ginauli mate, tau lau fadamahina haba somo hesa ya ginauli? ");
INSERT INTO bxh_vpl VALUES ("EC2_13","022_2_13","ECC","2","13","13","E nuwatuhu lobahi mate sibasiba ya loholoho wananaha, habahim yauyaule, doha mala ya loholoho wananaha, habahim kamumu. ");
INSERT INTO bxh_vpl VALUES ("EC2_14","022_2_14","ECC","2","14","14","Tau sibasiba ena aba lau ya sibai na yauyaulena higeꞌe. In moho E nuwatuhu lobahi mate, luwaluwagadi edi fuya ofi nenena esega. ");
INSERT INTO bxh_vpl VALUES ("EC2_15","022_2_15","ECC","2","15","15","Habahim nuwagu yai yawa, “Yau haba E peꞌi doha doga yauyaulena.” Be sibasiba lebena yai somo haba E abi? Ite hinaga hige aniyona. ");
INSERT INTO bxh_vpl VALUES ("EC2_16","022_2_16","ECC","2","16","16","Logena doga sibasibana haba doha yauyaulena, sa nuwa fuiyen maꞌamaꞌaen. Lahaidi sa laolaoma ibege ti nuwatuhuidi. Doga sibasibana hinaga bena ya peꞌi, doha doga yauyaulena! ");
INSERT INTO bxh_vpl VALUES ("EC2_17","022_2_17","ECC","2","17","17","Logena mwahuli te, E ꞌwaiyoꞌoꞌen, paꞌana paisowa maihala yai ya faꞌankamkamnagu. Mahudoꞌina hige aniyona doha hwayau E tafotafo watan, na hige agu loge. ");
INSERT INTO bxh_vpl VALUES ("EC2_18","022_2_18","ECC","2","18","18","Ginauli mahudoꞌidi E ginaulidi maihala yai mate, E waiyoꞌoꞌedi wananahaidi, paꞌana ibe E lau afuledi, mate doga hesa muligu yai haba aiꞌena. ");
INSERT INTO bxh_vpl VALUES ("EC2_19","022_2_19","ECC","2","19","19","Doga sibasibana e yauyaulena, sai ya sibai? Ma adidiligu yai, egu sibasiba yo adidili yai, paisowa mahudoꞌidi E ginaulidi maihala yai. In moho haba ya tanuwagaidi. Ite hinaga hige aniyona. ");
INSERT INTO bxh_vpl VALUES ("EC2_20","022_2_20","ECC","2","20","20","Paisowa yai E abi peꞌipeꞌi, E nuwatuhui be nuwagu ya kuꞌu. ");
INSERT INTO bxh_vpl VALUES ("EC2_21","022_2_21","ECC","2","21","21","Doga gonowana ena sibasiba yai ena paisowa ya ginauli, na habahim ya lau afulen, be sai hige i kamna heyayaꞌen, aiꞌena. Ite ya heyaya wananaha yo hinaga hige aniyona. ");
INSERT INTO bxh_vpl VALUES ("EC2_22","022_2_22","ECC","2","22","22","Maihala yai taumoho ya paisowa peꞌipeꞌi, na lisina yai somo ya lobahi? ");
INSERT INTO bxh_vpl VALUES ("EC2_23","022_2_23","ECC","2","23","23","Ena mwahuli fuyadi yai mate ena paisowa ya fakamna heyaya. Ai iꞌipadi ya nuwanuwatuhu hinaga hige i anyawasi. Ite hinaga hige aniyona. ");
INSERT INTO bxh_vpl VALUES ("EC2_24","022_2_24","ECC","2","24","24","Doga hige gonowana somo loholohona i ginauli, na bena moho ya nom yo ya an, yo hinaga bena nuwana ya loholoho ena paisowa lisidi yai. Ite hinaga E ita mate, Yaubada ena gigibwali yai ya ginaulidi. ");
INSERT INTO bxh_vpl VALUES ("EC2_25","022_2_25","ECC","2","25","25","Paꞌana ibe in higeꞌe, haba somo ya an? E haba sidohana nuwana ya loholoho? ");
INSERT INTO bxh_vpl VALUES ("EC2_26","022_2_26","ECC","2","26","26","Sai Yaubada nuwana ya fafaloholoho, mate sibasiba, sonoga yo kwade ya felen, in moho, tau heyaya mate Yaubada gogo loholohodi, fafatabudi paisowadi lisidi yai ya fakamna heyayadi, na ai mulina haba sa fele lawen Yaubada nuwana tau faloholohona lisidi. Ite hinaga hige aniyona, doha hwayahwayau ya tafotafo watan, na hige adi loge. ");
INSERT INTO bxh_vpl VALUES ("EC3_1","022_3_1","ECC","3","1","1","Ginauli mahudoꞌina maꞌana lahai; galewa ubuna yai maꞌana fuya. ");
INSERT INTO bxh_vpl VALUES ("EC3_2","022_3_2","ECC","3","2","2","Tubu fuyana yo peꞌi fuyana, uma fuyana yo lau gabu fuyana. ");
INSERT INTO bxh_vpl VALUES ("EC3_3","022_3_3","ECC","3","3","3","Aiyunu fuyana yo faloholoho fuyana, lau lopa fuyana yo ginauli fuyo fuyana, ");
INSERT INTO bxh_vpl VALUES ("EC3_4","022_3_4","ECC","3","4","4","Tantan fuyana yo kwade fuyana, nuwa heyaya ana fuya yo leꞌi ana fuya. ");
INSERT INTO bxh_vpl VALUES ("EC3_5","022_3_5","ECC","3","5","5","Umeꞌehu fafapei fuyana yo pei gogonidi fuyana, fagado bainewa fuyana, yo fagado bainewa haꞌasi. ");
INSERT INTO bxh_vpl VALUES ("EC3_6","022_3_6","ECC","3","6","6","Yoꞌo fuyana, yo yoꞌo sa fatautau, ita wata fuyana, yo fapei fuyana. ");
INSERT INTO bxh_vpl VALUES ("EC3_7","022_3_7","ECC","3","7","7","Kampuliti fuyana yo bodibodi fuyana, moꞌa pwakum fuyana yo libaliba fuyana, ");
INSERT INTO bxh_vpl VALUES ("EC3_8","022_3_8","ECC","3","8","8","Gadosisi fuyana yo fawaiyunu fuyana, Hiyala fuyana yo miya daumwali fuyana. ");
INSERT INTO bxh_vpl VALUES ("EC3_9","022_3_9","ECC","3","9","9","Tau paisowa ena paisowa yai, somo ya lobahi? ");
INSERT INTO bxh_vpl VALUES ("EC3_10","022_3_10","ECC","3","10","10","Yaubada mwahu ya tole dodoga lebedi yai mate E ita. ");
INSERT INTO bxh_vpl VALUES ("EC3_11","022_3_11","ECC","3","11","11","Ginauli mahudoꞌina ya ginauli komakomaniꞌidi adi maihala yai. Fuya hige ana siga Guyau ya tole dodoga nuwadi yai, in moho somo Yaubada ya ginauli fuya bwaꞌibwaꞌina yai ya lau ee–, ofiꞌofina yai, mate hige gonowana ta nuwatuhu lobahi. ");
INSERT INTO bxh_vpl VALUES ("EC4_9","022_4_9","ECC","4","9","9","Dodoga luwaga sa loholoho wananaha, habahim doga esega, paꞌana edi paisowa yai haba sa faisagusagu fuyoꞌidi, be loholoho sa lobahi. ");
INSERT INTO bxh_vpl VALUES ("EC4_10","022_4_10","ECC","4","10","10","Ibe esega ya beꞌu, haba hesa ya faꞌobiyo fuyoi, na doga ibona mate ya fanuwatohatoha, hige tau saguhina. ");
INSERT INTO bxh_vpl VALUES ("EC4_11","022_4_11","ECC","4","11","11","Doha dodoga luwaga sa eno luwaluwaga be ibege ti waꞌoꞌo, na doga ibona haba ya waꞌoꞌo. ");
INSERT INTO bxh_vpl VALUES ("EC4_12","022_4_12","ECC","4","12","12","Doga ibona gonowana sa dulu mahanoi be sa lei hafihafiti, na dodoga luwaga haba sa faisagusagu fuyoꞌidi. Dodoga faihona mate sa fuluga wananaha doha balawa, mahina faihona yai sa ginauli hige gonowana i tamotu maꞌamaꞌai. ");
INSERT INTO bxh_vpl VALUES ("EC5_10","022_5_10","ECC","5","10","10","Sai moni gadosisina lebena yai haba fuya ouꞌouli ya gadogado moni. Ite hinaga hige aniyona. ");
INSERT INTO bxh_vpl VALUES ("EC5_11","022_5_11","ECC","5","11","11","Yena em moni sa ouli, dodoga boludi haba sa laowa, sa saguhim be ami fapaisowa ofina. Doga fafamonina ena moni ya ita yo monina ena lau hinaga ya ita. ");
INSERT INTO bxh_vpl VALUES ("EC5_12","022_5_12","ECC","5","12","12","Dodoga sa paisowa adidili haba sa eno komakoman, anꞌan begana e laꞌilaꞌi sa an, in moho haba sa eno. Na dodoga fafamonidi, haba sa modemodeꞌen be ibege ti eno komakoman. ");
INSERT INTO bxh_vpl VALUES ("EC5_13","022_5_13","ECC","5","13","13","Heyaya laꞌilaꞌina hesa E ita tanoꞌubu yai te mate doha ite: Doga hesa haba moni laꞌilaꞌi ya abi, na yena ya oihalayen haba ya faheyaya fuyoi. ");
INSERT INTO bxh_vpl VALUES ("EC5_14","022_5_14","ECC","5","14","14","Doha ibe haisa edi moni na sa kai wegowegogoꞌen be moni ya ofi. Yena sa peʼi nanatudi ibege edi moni. Be yena sa peꞌi, nanatudi ibege edi moni. ");
INSERT INTO bxh_vpl VALUES ("EC5_15","022_5_15","ECC","5","15","15","Mahudoꞌida haba doha ite, te tubuma ma tau afaꞌafada, na yena te peꞌi, ginauli mahudoꞌina te paisowai haba te lau afulen, ibege laꞌi ta lawen. ");
INSERT INTO bxh_vpl VALUES ("EC7_15","022_7_15","ECC","7","15","15","Egu mwahuli kufakufana yai te, ginauli luwaga E itadi: doga dudulaina ena miya hige i lofa, in moho ya peꞌi, na doga heyaheyayana ya miya lofalofa ena heyaya yai. ");
INSERT INTO bxh_vpl VALUES ("EC7_16","022_7_16","ECC","7","16","16","Tabu dudulai u diꞌoi be u dudulai wanawananaha, yo sibasiba u diꞌoi be u sibasiba wanawananaha. Doꞌata wa faheyaya fuyoim. ");
INSERT INTO bxh_vpl VALUES ("EC7_17","022_7_17","ECC","7","17","17","Tabu hinaga heyaya u diꞌoi, be u heyaya wanawananaha, yo tabu u yauyaule. Hola hige em peꞌi fuyana na sidohana wa gado peꞌi feula? ");
INSERT INTO bxh_vpl VALUES ("EC7_18","022_7_18","ECC","7","18","18","Ya loholoho ibe fanuwatagu libadi te ami nuwa nuwatuhuidi; sai Guyau ya faꞌatitiyen haba laulau heyaheyayadi luwaga te, ya gebaedi. ");
INSERT INTO bxh_vpl VALUES ("EC7_19","022_7_19","ECC","7","19","19","Tau sibasiba esega mate ya adidili wananaha, habahim babaꞌisa safuhudohudoꞌi ma adiꞌadidilidi, taon yai. ");
INSERT INTO bxh_vpl VALUES ("EC7_20","022_7_20","ECC","7","20","20","Tanoꞌubu yai te hige sai i dudulai. Doga laulau loholohodi ya ginaginaulidi, in moho heyaya ya ginauli hinaga. ");
INSERT INTO bxh_vpl VALUES ("EC8_16","022_8_16","ECC","8","16","16","Fuyanna E nuwatuhui mate: sidohana sibasiba haba E abi, na iꞌipa yo lahai, paisowa somo sa laulau tanoꞌubu yai, E tuhutuhuli moho. Hige gonowana ya eno. ");
INSERT INTO bxh_vpl VALUES ("EC8_17","022_8_17","ECC","8","17","17","In moho Yaubada somo ya ginaginauli tanoꞌubu yai ibege au nuwatuhu lobahi. Haba ami anpate adidili bena ami yoꞌoi be aniyona ami sibai in moho hige gonowamiu. Tau sibasiba haba iye, “E siba.” In moho higeꞌe. ");
INSERT INTO bxh_vpl VALUES ("EC11_9","022_11_9","ECC","11","9","9","Hewahewali yo hasahasala! Ma tubu loholohomiu emi kwade au kwadeyedi, yo emi fanufanuha au lau watanidi. In moho, somo ami ginaulidi, Yaubada haba ya fakasamiu. ");
INSERT INTO bxh_vpl VALUES ("EC11_10","022_11_10","ECC","11","10","10","Tabu ginauli hesa i famodemiu, yo kamkamna i felemiu. Haba hewalimiu yo hasalamiu, ibege ti ota lofalofa. ");
INSERT INTO bxh_vpl VALUES ("EC12_1","022_12_1","ECC","12","1","1","Ma hewahewalimiu yo ma hasahasalamiu, tabu Tau Ginaulimiu au nuwa fuiyen, doꞌata emi fuya tautaulaꞌi yo tinatinalaꞌi yai auwe, “Hige amna hesa loholohona ai lobahi.” ");
INSERT INTO bxh_vpl VALUES ("EC12_2","022_12_2","ECC","12","2","2","Bena ami nuwatuhui, doꞌata emi fuya tautaulaꞌi yo tinatinalaꞌi yai, matamiu sa gafu doha maihala, nawalahi yo kipwala sa ꞌwahuꞌwahuhuli yo doha usa yadadi galewa sa fafakamumu. ");
INSERT INTO bxh_vpl VALUES ("EC12_3","022_12_3","ECC","12","3","3","Nimamiu, aba bobodiyemiu hola hige ti tabutabubu, yo ahemiu sa fafaꞌadidilimiu hola hige ti belubelu, moꞌamiu hola hige ti gabo lisina yai ami anꞌan aba mamaina, matamiu ma loholohodi lisina yai ami itaꞌita, mate bena Tau Ginaulimiu, ami nuwatuhui. ");
INSERT INTO bxh_vpl VALUES ("EC12_4","022_12_4","ECC","12","4","4","Beyamiu lisina yai dagugu edaꞌeda yai emi aba atahiyenna. Hola hige ti doꞌo, yo wawahin sa paipaisowa dagugudi, wana yo dagugu hesa - hesa, hola ami ataꞌatahiyedi mate, bena Yaubada ami nuwatuhui. Ataiꞌa edi gwane yai haba sa fanohimiu in moho ibege au atahi komakoman. ");
INSERT INTO bxh_vpl VALUES ("EC12_5","022_12_5","ECC","12","5","5","Tau Ginaulimiu bena ami nuwatuhui, yo edaꞌeda launa ami ꞌwasabuwedi, doꞌata ami beꞌu. Kulumiu hola hige ti fou ofi doha didiyali tayadi, yo hola hige au lau welawelai. Doha kupati hanahanau haba ya peꞌi, yo emi amna hola hige ti tomatoma, mate bena ami nuwatuhui. Ma mwahumwahulimiu bena ami nuwatuhui. Tabu au bagibagi ee–, peꞌi fuyana, yena ami peꞌi, haba ami lau Biula. Na dodoga haba halamiu sa tan eloꞌelolosi. ");
INSERT INTO bxh_vpl VALUES ("EC12_6","022_12_6","ECC","12","6","6","Aho te, au nuwatuhui paꞌana haba ami peꞌi doha mahina pwalana ya tamotu, yo gulewa ya tamo golugolu yo doha hoꞌowa aba yahiyahi ya tamo golugolu, yo balawa, hoꞌowa aba yahiyahina ya tamotu. ");
INSERT INTO bxh_vpl VALUES ("EC12_7","022_12_7","ECC","12","7","7","Ami peꞌi, haba ami fuyo tanohi, na yaluwamiu haba sa fuyo Yaubada lisina. ");
INSERT INTO bxh_vpl VALUES ("EC12_8","022_12_8","ECC","12","8","8","Yau, Tau lau faꞌata, yawa, “Ginauli mahudoꞌidi hige aniyona! Kufana!” ");
INSERT INTO bxh_vpl VALUES ("EC12_9","022_12_9","ECC","12","9","9","Yau, Tau lau faꞌata mate, E sibasiba wananaha be E anfatalahaen dodoga lebedi yai be haba sa sibasiba hinaga. Nuwatuhu te, E fadosi komakomanidi, wananaha e higeꞌe? Be gaimumu te E pei dailidi. ");
INSERT INTO bxh_vpl VALUES ("EC12_10","022_12_10","ECC","12","10","10","E anpate be E liba fadudulaidi, habahim E ulidi be sa famala gaimumu wananahadi. ");
INSERT INTO bxh_vpl VALUES ("EC12_11","022_12_11","ECC","12","11","11","Doga sibasibana ena liba sa faꞌankamkamna in moho ya fafadudulai doha tuꞌe, tau paisowa ya abi doha tuꞌe tau paisowa ya eliꞌeliyen bulumakau yai be haba ya foya dudulaiꞌi. Ibe ena gaimumu loholohona ya pei gogondi buka yai, haba ya ota hige anadan. Ibege i fatautau doha powati tau paisowa ya tutu fapatu lawen oyagi yai be ya abi didin. ");
INSERT INTO bxh_vpl VALUES ("EC12_12","022_12_12","ECC","12","12","12","Natugu, u itaꞌita komakoman! Ginauli hahaisa u lau afuledi. Uliꞌuli paisowana ibege i ofi, na sibasiba anpatena ya faꞌamna heyaheyaya! ");
INSERT INTO bxh_vpl VALUES ("EC12_13","022_12_13","ECC","12","13","13","Gaimumu mahudoꞌidi haꞌa ami atahidi be egu liba E falafusofa doha ite: ");
INSERT INTO bxh_vpl VALUES ("EC12_14","022_12_14","ECC","12","14","14","Guyau emi laulau simosimodi haba ya fakasadi, loholohodi yo heyaheyayadi, be Yaubada au faꞌatitiyen yo ena laugagayo au famuli watanidi paꞌana ya ginaulimiu. ");
INSERT INTO bxh_vpl VALUES ("IS2_1","024_2_1","ISA","2","1","1","Tautau yai, Yaubada ya taumahata Eimosi natuna Isaiya lebena yai be ena nuwatuhu somo Diuda yo Yelusalem lisidi yai ya faliba. ");
INSERT INTO bxh_vpl VALUES ("IS2_2","024_2_2","ISA","2","2","2","Iyen, “Fuya matada yai Dubu Tabuna ena aba mwaito tuꞌana haba tuꞌa hahaisa ya sai tawanidi. Nuꞌu boludi haba sa fabaiwama ainiya” ");
INSERT INTO bxh_vpl VALUES ("IS2_3","024_2_3","ISA","2","3","3","be dodoga boludi haba tiyen, “U laoma, ta lau Yaubada ena tuꞌa, ta lau Isalaela edi Guyau ena Dubu Tabuna. Ena laulau haba ya fatalahada be gonowana te lau watanidi. Yaubada ena lau faꞌata mate Yelusalem yai sa tulu beꞌuma; be Saiyon Tuꞌana yai ena dodoga ya falibadi.” ");
INSERT INTO bxh_vpl VALUES ("IS2_4","024_2_4","ISA","2","4","4","Pilipili nuꞌu laꞌilaꞌidi yai haba ya tole fadudulaidi. Edi kebolo haba sa bibidi be sa famala tanohi aba giyagiyali, na edi baineti haba sa ginauli fuyoꞌidi be sa famala umaꞌuma aba iboꞌibodi. Nuꞌu hesa ibege i lau nuꞌu hesa i hiyala fuyoi, hiyala sa lubulubui ibege ti lubulubui fuyo. ");
INSERT INTO bxh_vpl VALUES ("IS2_5","024_2_5","ISA","2","5","5","Iyakobo laulauwewena, aho te, Yaubada mala ya feleda bena te lau watan! ");
INSERT INTO bxh_vpl VALUES ("IS5_1","024_5_1","ISA","5","1","1","Hola lili te ya wanai na au atahi, Hidagu ena wain gabuna lilina. Lilina doha ite: Hidagu mate ena wain gabuna uduhuli mahumahulana yai. ");
INSERT INTO bxh_vpl VALUES ("IS5_2","024_5_2","ISA","5","2","2","Tanohina ya giyali na umeꞌehuna ya tanoi; be wain loholohodi ya umahidi. Aba itaꞌita wata lumana ya ginauli, Wain uludi ena aba folofolodi galina laꞌilaꞌi sa pidi umeꞌehu yai. Habahim wain uludi edi fuya nanau ya bagiyen, in moho nanaudi mate sa tabulu. ");
INSERT INTO bxh_vpl VALUES ("IS5_3","024_5_3","ISA","5","3","3","Yo fede hidagu iyen, “Tau miya Yelusalem yai yo Diudeya yai, egu gabu yo yau haga au fadosimai. ");
INSERT INTO bxh_vpl VALUES ("IS5_4","024_5_4","ISA","5","4","4","Nuwana hige somo laꞌi ya ginauli egu gabu yai te? Be logena uludi sa tabulu na yau egu fanuha wa, higeꞌe. ");
INSERT INTO bxh_vpl VALUES ("IS5_5","024_5_5","ISA","5","5","5","Egu wain gabuna mate haba egu abiꞌabina doha ite; wain gogolana ya in be ya yabalu haba E anꞌoiꞌidi yo ganaganana haba E lopa fahi be suisui adi banwawa yai ya fuyo. ");
INSERT INTO bxh_vpl VALUES ("IS5_6","024_5_6","ISA","5","6","6","Haba E ita afulen be hawa sa in, na ibege ya gula yawasidi e ya samuidi. Yada haba E lau biliyedi, be ibege i usa ai hewadi.” ");
INSERT INTO bxh_vpl VALUES ("IS5_7","024_5_7","ISA","5","7","7","Wain gabuna Hewa Wananaha Guyauna ya umahi mate logena Isalaela Nuꞌuna na wain mahinadi mate Diuda dodogadi Ena fanuha bena loholoho sa ginaginauli. In moho, ya itadi sa aiyunu. Laulau dudulaidi ya fanuha bena sa ginaulidi. In moho ya atahi sa tantan bena sidohana sagu sa lobahi. ");
INSERT INTO bxh_vpl VALUES ("IS6_1","024_6_1","ISA","6","1","1","Kin Usaiya ena peꞌi bolimanna ganahewana yai Guyau E ita. Ena aba taꞌai namanamalina yai ya taꞌataꞌai, ya hasai wananaha yo ena leli mate ya lofa be Dubu Tabuna ya famohafu. ");
INSERT INTO bxh_vpl VALUES ("IS6_2","024_6_2","ISA","6","2","2","Ginauli mwahumwahulidi hesadi Selafim mate sa ala balebalelem. Guyau sa mwaito fataꞌiꞌili. Hesa - hesa mate mabena faligigi esega: Mabe luwaga mate nenedi aba fakouna, mabe luwaga mate taudi aba fakouna na luwaga mate edi aba lofolofo. ");
INSERT INTO bxh_vpl VALUES ("IS6_3","024_6_3","ISA","6","3","3","Sa faifaiyoga lau hesa - hesa lisina, tiyen, Tabuna, Tabuna, Tabuna! Yaubada Hewa Wananaha yai mate tabuna. Ena namanamali tanoꞌubu mahudoꞌina ya nuhuli. ");
INSERT INTO bxh_vpl VALUES ("IS6_4","024_6_4","ISA","6","4","4","Alinadi dagugudi yai mate Dubu paꞌana ya tuhutuhu, yo Dubu mate gafu ya famohafu. ");
INSERT INTO bxh_vpl VALUES ("IS6_5","024_6_5","ISA","6","5","5","Yawa, “Aiyui! Haba E kamkamna paꞌana liba mahudoꞌidi E libaedi sopagu yai mate heyaya aꞌafa, yo dodoga mahudoꞌidi maidagu ꞌe miya esega, edi liba hinaga sa heyaya. In moho matagu luwaga yai Baꞌisa, Guyau Tau Gigibwali, E ita!” ");
INSERT INTO bxh_vpl VALUES ("IS6_6","024_6_6","ISA","6","6","6","Na habahim Selafim hesa ya lofo lidi lebegu. Antalasam aba suwasuwa yai, maniꞌona ya fakapu hafiti, na ya suwa lawen. ");
INSERT INTO bxh_vpl VALUES ("IS6_7","024_6_7","ISA","6","7","7","Oyagi maniꞌona, sopagu ya faꞌeliꞌona na iyen, “Ginauli te haꞌa sopam ya eliꞌona, be aho te em heyaheyaya sa ofi, yo em heyaheyaya haꞌa Yaubada ya nuwa afuledi.” ");
INSERT INTO bxh_vpl VALUES ("IS6_8","024_6_8","ISA","6","8","8","Habahim Yaubada alinana E atahi iyen, Sai haba E dui? Sai haba egu wasa ya lawen? Alinana E bui fuyoi, yawa, Yau ma! U duigu! ");
INSERT INTO bxh_vpl VALUES ("IS7_10","024_7_10","ISA","7","10","10","Guyau ya liba fuyo Kin Ahasi lisina iyen, ");
INSERT INTO bxh_vpl VALUES ("IS7_11","024_7_11","ISA","7","11","11","“Guyau em Yaubada u fatiꞌoi be fafaꞌilala ai tanohi ubuna o ai galewa hewa wananahana i felem.” ");
INSERT INTO bxh_vpl VALUES ("IS7_12","024_7_12","ISA","7","12","12","In moho Ahasi iyen, “Ibege Guyau ya lauꞌita. Yau ibege fafaꞌilala ya anꞌetai.” ");
INSERT INTO bxh_vpl VALUES ("IS7_13","024_7_13","ISA","7","13","13","Yo fede Isaiya iyen, Baꞌisa Deiwidi wahana, aho ite u ataꞌatahi! Dodoga haꞌa edi loholoho wa lau lubui, na ite hinaga bena Yaubada ena loholoho wa lau lubui? ");
INSERT INTO bxh_vpl VALUES ("IS7_14","024_7_14","ISA","7","14","14","Debana yai, Guyau ibona haba fafaꞌilala ya felem: fafaꞌilalana mate tineꞌeu nuwa supusupuna ya boga haba natuna taumoho ya yosi, na hesana haba ya tole “Imanuwela.” ");
INSERT INTO bxh_vpl VALUES ("IS8_21","024_8_21","ISA","8","21","21","Haba sa itaꞌita hasa galewa, ");
INSERT INTO bxh_vpl VALUES ("IS8_22","024_8_22","ISA","8","22","22","e tanohi sa kinokinoi, in moho ibege somo hesa ti ita, haba pilipili moho yo kamumu. Kamumu ganahewana yai haisa sa andudu balabala. ");
INSERT INTO bxh_vpl VALUES ("IS9_1","024_9_1","ISA","9","1","1","Hige gonowana edi edaꞌeda hesa haba ti gela, lahai heyaheyayadi yai te. Beyabeyana, Sebulun yo Nafatali Nuꞌudi, Yaubada ya fataumayamayadi. In moho, fuya matada yai haba nuꞌudi ya ita falaꞌidi, Gabogabo Laꞌilaꞌi yai ya lau bee–, Diyodan Hoꞌowana tefa saisaina yo Galili hinaga somo yai taꞌowawa edi aba miya. ");
INSERT INTO bxh_vpl VALUES ("IS9_2","024_9_2","ISA","9","2","2","Dodoga safaluma kamumu yai sa laulau, mala laꞌilaꞌi sa ita. Kamumu laꞌilaꞌi yai sa miyamiya. In moho mala ya sina lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("IS9_3","024_9_3","ISA","9","3","3","Guyau um wa fatadadadi, yo edi kwade wa falaꞌidi; be sa kwade matam yai doha dodoga lau gabu fuyana yai sa kwade, yo doha taumoho hiyala yai ginauli ya abidi na ya kwade. ");
INSERT INTO bxh_vpl VALUES ("IS9_6","024_9_6","ISA","9","6","6","Gwama kiukiu ya tubu ita eneheda. Yaubada natuna ya feleda! In ya famala eda Baꞌisa. Yo hesana haba: Tau Fafadudulai Loholohona, Yaubada Tau Gigibwali, Tamada Otaꞌota Esegahina, Nuwatalu Baꞌisana. ");
INSERT INTO bxh_vpl VALUES ("IS9_7","024_9_7","ISA","9","7","7","Ena gigibwali hige ana siga, nuwa talu haba ya ota esegahi. Deiwidi ena nuꞌu haba ya ita watan, be ya faꞌadidili. Haba fuya ouꞌouli ya ita wata, dudulai yai yo nuwa talu yai. Guyau Tau Gigibwali haba ya fawananaha bena ginauli mahudoꞌidi te sa tubu. ");
INSERT INTO bxh_vpl VALUES ("IS9_8","024_9_8","ISA","9","8","8","Guyau haꞌa Isalaela dodogadi ya liba fanuwatagudi, ");
INSERT INTO bxh_vpl VALUES ("IS9_9","024_9_9","ISA","9","9","9","be mahudoꞌidi sa sibai Efalaim yo Samaliya edi duhu balabalamumu hinaga sa sibai in moho sa nuwa saesae yo sa nuwa poꞌi. Be tiyen, ");
INSERT INTO bxh_vpl VALUES ("IS9_10","024_9_10","ISA","9","10","10","Biliki yo oyagi hesana sukamo yai luma sa eli hitinidi haꞌa sa guli, in moho ai haba E faꞌobiyodi ai umeꞌehu yo oyagi hesana sida yai. ");
INSERT INTO bxh_vpl VALUES ("IS11_1","024_11_1","ISA","11","1","1","Kin Deiwidi hitina doha oyagi sa oi faguli. Na tuhutuhuna yai tutulina sa in hasa be kin fwaufwauna Deiwidi laulauwewena yai haba ya obiyo hasaema. ");
INSERT INTO bxh_vpl VALUES ("IS11_2","024_11_2","ISA","11","2","2","Guyau Yaluwana haba ya talu ai hewana, In sonoga yo nuwatuhu lobahi Yaluwana, yo liba fasibasiba yo gigibwali Yaluwana. Sibasiba yo Guyau ꞌwasabuna Yaluwana, ");
INSERT INTO bxh_vpl VALUES ("IS11_3","024_11_3","ISA","11","3","3","Logena, haba Guyau ꞌwasabuna yai, amna loholoho ya lobahi. Somo matana yai ya itadi e somo ya atahiyedi, haba ibege i fakasadi. ");
INSERT INTO bxh_vpl VALUES ("IS11_4","024_11_4","ISA","11","4","4","Haba tau kuꞌu, laulau dudulai yai ya fakasadi, yo gelogeloma dodogadi haba nuwatuhu loholoho yai enehedi ya fakasadi. Ena liba yai haba dodoga sa panisidi, yo haba dodoga heyaheyayadi ya faꞌankamkamnadi, be sa peꞌi. Yahafuwana yai haba tau heyaya ya wunuidi. ");
INSERT INTO bxh_vpl VALUES ("IS11_5","024_11_5","ISA","11","5","5","Laulau dudulai yo liba dudulai mate ana bwaꞌulu ");
INSERT INTO bxh_vpl VALUES ("IS11_6","024_11_6","ISA","11","6","6","ꞌWayoꞌwayowa yo sipi haba sa miya esega, yo lepodi yo goti nanatudi haba sa eno gogo. Bulumakau nanatudi yo laiyon nanatudi haba sa anban gogo. na wawaya kiukiu haba suisui ni ya foyahidi. ");
INSERT INTO bxh_vpl VALUES ("IS11_7","024_11_7","ISA","11","7","7","Bulumakau yo beya haba sa anban esega, na suisuidi afa nanatudi haba sa eno esega. Laiyon haba hawahawa ya anidi doha bulumakau. ");
INSERT INTO bxh_vpl VALUES ("IS11_8","024_11_8","ISA","11","8","8","Doha wawaya kiukiu weso anꞌannalina galina sadaina yai ya aiꞌaiheya, yo wawaya hesa nimana ya tole lawen nohina yai. ");
INSERT INTO bxh_vpl VALUES ("IS11_9","024_11_9","ISA","11","9","9","Guyau ena Tuꞌa Saiyon Fafatabuna yai, ibege heyaya e somo hesa i faꞌankamkamna. Guyau ena sibasiba haba nuꞌu mahudoꞌina ya mohafu, doha hoꞌowa gabogabo ya famohafu. ");
INSERT INTO bxh_vpl VALUES ("IS11_10","024_11_10","ISA","11","10","10","Fuyanna yai, haba Desi laulauwewena hesa ya mwaitoma, doha oyagi lamna yai inna ya tutulima. Ya famala doha fafaꞌilala, nuꞌudi haba sa faꞌoigogo lisina yai yo ena aba anyawasi nuꞌuna haba ya loholoho wananaha. ");
INSERT INTO bxh_vpl VALUES ("IS35_1","024_35_1","ISA","35","1","1","Nuꞌu pitapitalina yo tanohi fafahoꞌowa gesana haba sa kwade, Nuꞌu laulau gesana haba ya kwade yo ya taya doha mula hewadi tupodi. ");
INSERT INTO bxh_vpl VALUES ("IS35_2","024_35_2","ISA","35","2","2","Haba ya tahalasi be ya taya, yo ya kwade be ya wana laꞌilaꞌi. Lebanon ena loholoho haba ya felen, Kameli Tuꞌana yo Salon Gonna edi loholoho, be Guyau ena namanamali yo eda Yaubada didigana haba sa ita. ");
INSERT INTO bxh_vpl VALUES ("IS35_3","024_35_3","ISA","35","3","3","Nima belubeludi yo tuli tabutabubudi ya faꞌadidilidi. ");
INSERT INTO bxh_vpl VALUES ("IS35_4","024_35_4","ISA","35","4","4","Dodoga nuwadi sa ꞌwasaꞌwasabu au falibadi, auwen, “Au adidili. Tabu au ꞌwasabu! Emi Yaubada haba ya laoma be ami hala ya abi, yo ami waiyunu haba ya fakamkamnadi.” ");
INSERT INTO bxh_vpl VALUES ("IS35_5","024_35_5","ISA","35","5","5","Tau mata toutou haba matadi ya falaladi, na tau beya tuitui haba beyadi sa taꞌafasi. ");
INSERT INTO bxh_vpl VALUES ("IS35_6","024_35_6","ISA","35","6","6","Haba tau dabidabi ya dago, doha diya Na tau libaliba gesa haba sa kwade. Hoꞌowa haba sa faipisapisalaidi nuꞌu pitapitalina yai. ");
INSERT INTO bxh_vpl VALUES ("IS35_7","024_35_7","ISA","35","7","7","Yo tanohi pitapitalina haba yomayoman sa famohafudi, yo gelegele gigibwalina ya famala hoꞌowa kodona. Somo yai ꞌwayoꞌwayowa edi aba miya, haba tomwali hawahawadi, bagili yo papailusi ainiya sa in. ");
INSERT INTO bxh_vpl VALUES ("IS35_8","024_35_8","ISA","35","8","8","Ainiya haba edaꞌeda laꞌilaꞌi, hesana mate “Tabuna edaꞌedana.” Tau heyaya ibege edaꞌedana ti lau watan; salumadi sa laulau niya mate, edi edaꞌeda yo ya une fahidi haba edana sa lau watan. ");
INSERT INTO bxh_vpl VALUES ("IS35_9","024_35_9","ISA","35","9","9","Laiyon ibege laꞌi ainiya; Suisui anꞌannalidi ibege laꞌi i tau bayawa lau niya. Salumadi Yaubada ya fofofahidi moho, haba edaꞌedana sa lau watan. ");
INSERT INTO bxh_vpl VALUES ("IS35_10","024_35_10","ISA","35","10","10","Haba sa mahano ai Yelusalem ma wanadi. Kwade hige ofina haba adi kokukoku. Kwade yo nuwa amna haba ya tanuwagaidi, nuwa heyaya yo amna heyaya sa failauwidi. ");
INSERT INTO bxh_vpl VALUES ("IS40_1","024_40_1","ISA","40","1","1","Eda Yaubada iyen, “Egu dodoga nuwadi au liba fataludi. ");
INSERT INTO bxh_vpl VALUES ("IS40_2","024_40_2","ISA","40","2","2","Au liba bigabiga lau Yelusalem lisina, yo au faliba mate: Ibege ti lau fayofayo fuyoimiu. Emi kamkamna ana siga itete. Yau, Guyau, emi heyaya haꞌa E famaisadi.” ");
INSERT INTO bxh_vpl VALUES ("IS40_3","024_40_3","ISA","40","3","3","Doga hesa ya yogayoga iyebom, “Ai nuꞌu pitapitalina edaꞌeda au faꞌaꞌa! Edaꞌeda dudulaina au ginauli, Guyau eda Yaubada enehena. ");
INSERT INTO bxh_vpl VALUES ("IS40_4","024_40_4","ISA","40","4","4","Dahadaha au famohafudi; tuꞌa yo uduhuli au fatabatabadi. Piupiu hitidi au fadudulaidi yo mala heyaheyaya haba sa famala gon. ");
INSERT INTO bxh_vpl VALUES ("IS40_5","024_40_5","ISA","40","5","5","Habahim Yaubada ena namanamali didigana haba ya taumahata, be dodoga mahudoꞌidi sa ita. Libadi te, Guyau moꞌana yai sa tulu beꞌuma!” ");
INSERT INTO bxh_vpl VALUES ("IS40_6","024_40_6","ISA","40","6","6","Alina hudoꞌi ya liba iyen, “Wasa au duwai!” Yo fede E fatiꞌo, yawa, “Wasa somo haba E duwai?” Iyen, “U liba, uwen, ‘Dodoga mahudoꞌimiu mate doha hawahawa yo mula; Paꞌana ibege ti ota lofalofa.” ");
INSERT INTO bxh_vpl VALUES ("IS40_7","024_40_7","ISA","40","7","7","Yena Guyau ya yahafuwa lau hawahawa yo mula hewadi yai haba sa hohoya. Wananaha dodoga mate doha. Hige ti ota fuya lofalofa. ");
INSERT INTO bxh_vpl VALUES ("IS40_8","024_40_8","ISA","40","8","8","Mula yo hawahawa haba sa hohoya, in moho somo eda Yaubada ya libaen, mate ya ota esegahi. ");
INSERT INTO bxh_vpl VALUES ("IS40_9","024_40_9","ISA","40","9","9","Sai wasa loholohona wa leyama Saiyon, u hasai tuꞌa lofalofana. Ai Yelusalem wasa te, u fatala yogayogaꞌen, tabu u ꞌwasabu; Diuda taonidi u falibadi uwe, “Ma! Emi Yaubada ite!” ");
INSERT INTO bxh_vpl VALUES ("IS40_10","024_40_10","ISA","40","10","10","Guyau, emi Yaubada ya laoma ma gigibwalina ya famala emi baꞌisa, Maisana, logena ena dodoga, ya fofofahidi, ma afa haidana sa laoma. ");
INSERT INTO bxh_vpl VALUES ("IS40_11","024_40_11","ISA","40","11","11","Haba doha tau itaꞌita wata sipi ya foyahidi be sa anban; Sipi nanatudi haba ya foyahi gogonidima be ya labadi yo sipi fanafanatudi haba ya foyahidi. ");
INSERT INTO bxh_vpl VALUES ("IS42_1","024_42_1","ISA","42","1","1","Itete egu tau paisowa, Yau E faꞌadidili, yo E fasinabo, nuwagu ya loholoho lisina yai; Yaluwagu haꞌa E tole lisina yai, be dudulai haba ya leyama nuꞌu ouꞌouli. ");
INSERT INTO bxh_vpl VALUES ("IS42_2","024_42_2","ISA","42","2","2","In ibege i fatala bwasabwasa, e i ꞌwalaꞌwalaꞌuwi o i yogayoga ai edaꞌeda. ");
INSERT INTO bxh_vpl VALUES ("IS42_3","024_42_3","ISA","42","3","3","Didiyali nobunobuna ibege i kampwai, o mala ya leꞌileꞌi ibege i fapeꞌi. In moho dudulai haba ya leyama. ");
INSERT INTO bxh_vpl VALUES ("IS42_4","024_42_4","ISA","42","4","4","Ibege nuwana i belubelu yo paisowa i fatautau ana sigana ee–, dudulai ya leyama tanoꞌubu mahudoꞌina yai, yo dodoga bonabonaluwa yai hinaga ena lau faꞌata sa bagibagiyen. ");
INSERT INTO bxh_vpl VALUES ("IS42_5","024_42_5","ISA","42","5","5","Yaubada galewa, tanoꞌubu yo ginauli mahudoꞌidi ya ginaulidi na dodoga tanoꞌubu yai mwahuli yo yahafuwa ya feledi. Logena ya liba doha ite: ");
INSERT INTO bxh_vpl VALUES ("IS42_6","024_42_6","ISA","42","6","6","“Yau, Guyau, E yogaim, yo gigibwali E felem bena E ita haba dudulai ya tubu ai tanoꞌubu. Um ai debam haba yali E ginauli dodoga mahudoꞌidi ai lebedi; Yo um ai debam Yau haba mala E leyama ai nuꞌudi. ");
INSERT INTO bxh_vpl VALUES ("IS42_7","024_42_7","ISA","42","7","7","Dodoga mata toutoudi haba matadi wa falaladi. Yo tau lau deli, kamumu yai sa miyamiya haba wa soꞌe fahidi.” ");
INSERT INTO bxh_vpl VALUES ("IS49_3","024_49_3","ISA","49","3","3","Guyau ya libama lebegu iyebom, “Isalaela! Um egu tau paisowa. Debam yai, dodoga haba sa faꞌatitiyegu.” ");
INSERT INTO bxh_vpl VALUES ("IS49_5","024_49_5","ISA","49","5","5","Hola hige tinagu i yosigu, Guyau Yaubada ya fasinabogu Ya falasagu ena tau lau fayofayo be haba Isalaela dodogadi E aule fafuyoꞌidima, Guyau ya faꞌatitiyegu yo In egu adidili uluꞌulu gwagona. ");
INSERT INTO bxh_vpl VALUES ("IS49_6","024_49_6","ISA","49","6","6","Guyau ya falibagu iyen, “Aee, egu tau paisowa, Am paisowa haba E felem, mate hige bena Isalaela dodogadi sa mwahuli ibodi moho u fafuyodima, na haba wa famala mulimuli dodogadi edi mala hinaga, be egu mwahuli otaꞌotafahina sa abi.” ");
INSERT INTO bxh_vpl VALUES ("IS49_14","024_49_14","ISA","49","14","14","In moho Saiyon iyen, “Guyau ya lau afulegu, yo ya nuwa fuiyegu. Yo fede alinana Guyau ya bui, iyen, ");
INSERT INTO bxh_vpl VALUES ("IS49_15","024_49_15","ISA","49","15","15","“Waihin natuna ya fafanom, gonowana ya nuwa fuiyen e ya yosiyama ibege i gadosisiyen? Wananaha, fuya hahaisa haba natuna ya nuwa fuiyen, In moho, Yau ibege ya nuwa fuiyen! ");
INSERT INTO bxh_vpl VALUES ("IS49_16","024_49_16","ISA","49","16","16","“Yelusalem, ibege ya nuwa fuiyem, paꞌana hesana haꞌa E uli nimagu yai. ");
INSERT INTO bxh_vpl VALUES ("IS49_17","024_49_17","ISA","49","17","17","“Aee Yelusalem! Nanatum ti fuyoma feula. Saluma bena sa faheyayam, mate begana haba sa laoma. Na salumadi sa faheyayam haba sa lau afulem.” ");
INSERT INTO bxh_vpl VALUES ("IS50_4","024_50_4","ISA","50","4","4","Somo haba E libaen mate Guyau, Yaubada ya fasibagu, be safalumadi sa nuwa belubelu E liba faꞌadidilidi. Hwalahwalala ouꞌouli ya fanofanohigu bena haba E ita lobahi be ena nuwatuhu E falau watan. ");
INSERT INTO bxh_vpl VALUES ("IS50_5","024_50_5","ISA","50","5","5","Beyagu haꞌa ya soꞌedi ena nuwatuhu hige ya ꞌwaiyoꞌoꞌen yo hige ya tole mulimuliyen. ");
INSERT INTO bxh_vpl VALUES ("IS50_6","024_50_6","ISA","50","6","6","Tauligu E nuwa afulen be tau talaigu amainiya sa oi, na papaligu E feledi be sapulagu sa laꞌa fahidi; E itaꞌita lau lebedi na sa lau kanikanisoigu yo sa liuliuhwaꞌegu. ");
INSERT INTO bxh_vpl VALUES ("IS50_7","024_50_7","ISA","50","7","7","In moho Guyau Yaubada ya saguhigu logena, dodoga ibege ti ita faheyayagu, somo haba E fahoina mate nuwagu ya adidili, na E siba ibege ya taumayamaya. ");
INSERT INTO bxh_vpl VALUES ("IS50_8","024_50_8","ISA","50","8","8","In, sai ya ita faloholohogu, mate sadaigu yai. Maihalana yai haba sai ya sadigu? Haga ta lau fatala! Tau fagilugu sai? Au ita afulen be i liba mataigu! ");
INSERT INTO bxh_vpl VALUES ("IS50_9","024_50_9","ISA","50","9","9","Guyau Yaubada In tau sagusaguhigu. Safalumadi sa fagilugu? Tau fafagilugu haba sa tauyamuhi; doha kwalikwali kaleko sa anidi. ");
INSERT INTO bxh_vpl VALUES ("IS52_7","024_52_7","ISA","52","7","7","Wasa tau leyamana tuꞌa ya diꞌoma, sa ita mate nuwadi sa kwade wananaha. Yelusalem dodogadi ya falibadi iyebom, “Wasa Loholohona E leyama, fanuwa esega yo mwahuli wasadi. Guyau mate emi Kin!” ");
INSERT INTO bxh_vpl VALUES ("IS52_8","024_52_8","ISA","52","8","8","Yelusalem tau bobodiyenna, sa yogayoga ma kwadedi. Saiyon yai Guyau ya fuyo, sa ita wananahai. ");
INSERT INTO bxh_vpl VALUES ("IS52_9","024_52_9","ISA","52","9","9","Yelusalem dodogadi, emi aba talotalopa yai au obiyo! Au yogayoga ma kwademiu. Paꞌana Guyau haꞌa nuwamiu ya liba fataludi, na ya laoma bena ya fofofahimiu. ");
INSERT INTO bxh_vpl VALUES ("IS52_10","024_52_10","ISA","52","10","10","Yaubada ena gigibwali tabuna haꞌa ya famahata. Haba ya fofofahimiu yo dodoga tanoꞌubu mahudoꞌina yai ena gigibwali haba sa ita. ");
INSERT INTO bxh_vpl VALUES ("IS52_13","024_52_13","ISA","52","13","13","Guyau iyen, “Egu tau paisowa haba ana paisowa ya fawananaha. Haba sa ita falaꞌi yo hesana sa lau hitin. ");
INSERT INTO bxh_vpl VALUES ("IS52_14","024_52_14","ISA","52","14","14","Salumadi haꞌa sa ita, mate sa tau hiti. Nenena ya bui yo itaꞌitana ya heyaya. Hige doha tau wananaha. ");
INSERT INTO bxh_vpl VALUES ("IS52_15","024_52_15","ISA","52","15","15","Nuꞌu boludi dodogadi haba ya fanoꞌodi, yo kin boludi haba ya faꞌoigogodi. Na safaluma ma supusupudi haba sa ita lobahi.” ");
INSERT INTO bxh_vpl VALUES ("IS53_1","024_53_1","ISA","53","1","1","Sai haꞌa ema wasa ya kawawananahaꞌen? Yo Guyau ena gigibwali haꞌa sai ya ita? ");
INSERT INTO bxh_vpl VALUES ("IS53_2","024_53_2","ISA","53","2","2","Guyau ena tau paisowa ya in, doha liꞌe ya sipolaꞌa, yo doha oyagi ya tutuli hasaema tanohi pitapitalina yai. Nenena ya heyaya be hige ta modeꞌen, yo hige hewalina yai, haba nuwada i abi. ");
INSERT INTO bxh_vpl VALUES ("IS53_3","024_53_3","ISA","53","3","3","Te ita lidilidiyen yo te ꞌwaiyoꞌoꞌen. In moho kamkamna yo kalapi ya fahoinadi. Te sana mulimuliyen. Hige sai laꞌi i fanuha bena nenena i ita, yo hige ta fafaꞌatitiyen. ");
INSERT INTO bxh_vpl VALUES ("IS53_4","024_53_4","ISA","53","4","4","Kamkamnadi te, ita egoba te ginaulidi, in moho In ya baheidi. Eda nuwatuhu bena haga ena ankamkamna mate Yaubada ya fatamaliyama. ");
INSERT INTO bxh_vpl VALUES ("IS53_5","024_53_5","ISA","53","5","5","In moho, eda heyaya yai, sa famwalofo yo tauna sa faꞌomatadi. Sa talai, paꞌana eda heyaya debadi yai. Nuwa talu ya leyama, be ana omata sa faloholohoda. ");
INSERT INTO bxh_vpl VALUES ("IS53_6","024_53_6","ISA","53","6","6","Mahudoꞌida doha sipi gegegedi, hesa - hesa ena nuwatuhu ya lau watan. In moho kamkamna bena ita te fahoina mate Guyau ya fabahei. ");
INSERT INTO bxh_vpl VALUES ("IS53_7","024_53_7","ISA","53","7","7","Sa fahisu faheyaya yo sa fakamkamna. In moho hige somo i libaen; sa foyahi doha sipi gubugubufwauna be sa wunui. Hige somo hesa i libaen, doha sipi sa lawen be olona sa tomodi na hige i kehe. ");
INSERT INTO bxh_vpl VALUES ("IS53_8","024_53_8","ISA","53","8","8","Sa au be ana maisa sa felen na habahim sa lawen be sa wunui. Hige sai laꞌi i modeꞌen. Egu dodoga edi heyaheyaya maisadi yai sa wunui. ");
INSERT INTO bxh_vpl VALUES ("IS53_9","024_53_9","ISA","53","9","9","In hige i bwalabwala yo hige heyaya laꞌi i ginauli. In moho maꞌena dodoga inono heyaheyayadi sa toledi, yo tau fagogo maidana sa boꞌusaidi. ");
INSERT INTO bxh_vpl VALUES ("IS53_10","024_53_10","ISA","53","10","10","Guyau ena nuwatuhu yai bena ena fayofayo tau abina ya ankamkamna be ya famala antalasam. Haba dodoga edi heyaya aba nuwa afulenna. Matabahim haba ya miya fuya lofalofa be laulauwewena ya itadi. Guyau ena nuwatuhu mahudoꞌidi mate ya ginaulidi. ");
INSERT INTO bxh_vpl VALUES ("IS53_11","024_53_11","ISA","53","11","11","Yaluyaluwana ena kamkamna mulina yai, mwahuli malana haba ya ita, be nuwana ya talu. Ena sibasiba yai, Egu tau paisowa dudulaina edi heyaheyaya ya baheidi, yo ya nuwatuhu afuledi. ");
INSERT INTO bxh_vpl VALUES ("IS53_12","024_53_12","ISA","53","12","12","Debana yai ena tefa haba E felen dodoga fafahesadi ganahewadi yai. Tau heyaya yo tau loholoho haba ya hinelidi, paꞌana ena mwahuli ya fele afulen, be ya peꞌi. Yo tau heyaya maidana sa falau esegahidi. In moho, eda heyaya ya bahei, yo tau heyaya edi ya anꞌeta. ");
INSERT INTO bxh_vpl VALUES ("IS54_5","024_54_5","ISA","54","5","5","Tau Ginaulim mate doha lahum. Hesana mate Guyau Gigigibwalina. In tau une fahim, Yaubada fafatabuna Isalaela enehem. Hesana mate “Tanoꞌubu mahudoꞌina edi Yaubada.” ");
INSERT INTO bxh_vpl VALUES ("IS54_6","024_54_6","ISA","54","6","6","Isalaela, um doha waihin hasahasalana, lahuna ya lau afulen be nuwana ya heyaya. In moho Guyau em Yaubada ya yoga fafuyom na iye, ");
INSERT INTO bxh_vpl VALUES ("IS54_7","024_54_7","ISA","54","7","7","“E ꞌwaiyoꞌoꞌem maihala tupotupo. In moho E fanuwatohatohaem, Be haba E fafuyom. ");
INSERT INTO bxh_vpl VALUES ("IS54_8","024_54_8","ISA","54","8","8","E manabala heyaya be E sana mulimuliyem fuya tupotupo. In moho egu gadosisi otaꞌota fahina debana yai haba E fanuwatohatohaem! Yau em Guyau, tau fofofahim E falibam doha ite.” ");
INSERT INTO bxh_vpl VALUES ("IS54_9","024_54_9","ISA","54","9","9","“Nowa ena fuya yai E angwala mate ibege tanoꞌubu ya faheyaya bodai ai utufi. Be aho te E angwala mate ibege ya manabala be ya faheyayam. ");
INSERT INTO bxh_vpl VALUES ("IS54_10","024_54_10","ISA","54","10","10","Tuꞌa lalaꞌi sa dihodiho, yo kikiꞌina sa tauyamuhi, in moho egu gadosisi, enehem, haba ya ota esegahi lisim yai. Nuwa talu angwalana E ginauli haba ya ota esegahi. Yau, Guyau, tau fafanuwatohatohaem E falibam doha ite.” ");
INSERT INTO bxh_vpl VALUES ("IS55_1","024_55_1","ISA","55","1","1","Safaluma gadomiu sa magu, mahudoꞌimiu au laoma, au laoma hoꞌowa ami au nom; yo hige emi moni, au laoma, au uneꞌune be au kalahe! Au laoma be wain yo miluki fafamaisa gesana yo hige uneꞌune au une. ");
INSERT INTO bxh_vpl VALUES ("IS55_2","024_55_2","ISA","55","2","2","Anꞌan heyaheyayadi tabu emi moni ainiya au pei gaibuidi, yo somo hige boga yahayaha, tabu ainiya emi maliyaho au pei gaibuidi. Hola au ataꞌatahi, be kalahe loholohona ami au an, haba kalahe loholohona yai emi amna loholoho ami abi. ");
INSERT INTO bxh_vpl VALUES ("IS55_3","024_55_3","ISA","55","3","3","Egu liba au atahi na au laoma lisigu, haba ami mwahuli. Haba yali otaꞌota fahina E ginauli ai lebemiu, yo Deiwidi lisina yai egu gadosisi otaꞌota fahina haba E felemiu. ");
INSERT INTO bxh_vpl VALUES ("IS55_4","024_55_4","ISA","55","4","4","Au ita! E faꞌobiyo be nuꞌu ouꞌouli edi baꞌisa yo tau fafadudulai. In egu wikinisi dodoga lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("IS55_5","024_55_5","ISA","55","5","5","Umi haba ami yogalau nuꞌu hahaisa lebedi, nuꞌudi mate hige au sibaidi. Yo umi hige au sibaidi, in moho haba sa laoma, paꞌana yau Guyau Isalaela edi Yaubada Tabuna, yo yau E ita faloholohomiu. ");
INSERT INTO bxh_vpl VALUES ("IS55_6","024_55_6","ISA","55","6","6","Yaubada ena peloweta iyebom “Guyau hola au yoꞌoi. Au yoga lau lisina, hola sadaimiu yai. ");
INSERT INTO bxh_vpl VALUES ("IS55_7","024_55_7","ISA","55","7","7","Emi laulau yo nuwatuhu heyaheyayadi ti otawa. Au timuli bui Guyau eda Yaubada lisina. Haba ya nuwatohatohaemiu be emi heyaheyaya ya nuwa afuledi.” ");
INSERT INTO bxh_vpl VALUES ("IS55_8","024_55_8","ISA","55","8","8","Guyau iyebom: “Egu nuwatuhu yo egu laulau mate hige doha enehemiu. ");
INSERT INTO bxh_vpl VALUES ("IS55_9","024_55_9","ISA","55","9","9","Gonogonowana doha galewa ya hasai wananaha habahim tanoꞌubu, be egu nuwatuhu yo egu laulau mate sa hasai wananaha habahim enehemiu. ");
INSERT INTO bxh_vpl VALUES ("IS55_10","024_55_10","ISA","55","10","10","Usa yo sinou galewa yai sa beꞌuma. Be hige ti fuyo hasa, na hola tanoꞌubu sa fahoꞌowa. Be umaꞌuma haba sa anꞌan yo sa lau liꞌe, tau umaꞌuma enehena. ");
INSERT INTO bxh_vpl VALUES ("IS55_11","024_55_11","ISA","55","11","11","Egu liba mate doha. Hige ya liba gaibu. Be somo E fatamali, mate ma aniyodi. Somo E libaen haba sa ginauli watanidi. Be egu liba moꞌagu yai E fapesa ma aniyodi.” ");
INSERT INTO bxh_vpl VALUES ("IS56_1","024_56_1","ISA","56","1","1","Guyau ena dodoga ya falibadi iyebom, “Somo ya dudulai yo ya loholoho mate au ginauli, yo miyamiya loholohodi bena ami miyamiyaꞌedi, paꞌana begana haba E saguhimiu yo egu dudulai wananahana E famahata. ");
INSERT INTO bxh_vpl VALUES ("IS56_6","024_56_6","ISA","56","6","6","Taꞌowawa salumadi sa fele fuyoꞌidi Guyau lisina bena ena sa paisowa, bena Guyau hesana sa fanuha, yo sa fadebasae, salumadi mahudoꞌidi Sabati sa faꞌatitiyen yo hige ti kaiwegowegogoꞌen, yo salumadi egu yali sa abi didin. ");
INSERT INTO bxh_vpl VALUES ("IS56_7","024_56_7","ISA","56","7","7","Haba E lawemiu egu Tuꞌa Fafatabuna yai yo egu aba lauꞌuꞌula lumana yai, be kwade E felemiu. Ainauya gabugabudi yo antalasam haisa haba nuwagu sa abi egu aba antalasam yai. Egu Dubu mate Aba Laulauꞌuꞌula, egu dodoga nuꞌu ouꞌouli yai, enehedi.” ");
INSERT INTO bxh_vpl VALUES ("IS58_7","024_58_7","ISA","58","7","7","Salumadi sa guliyam mate ami kalahe adi au soi; tau leuleu saisai hige edi luma mate, au yoga hitinidi emi ai luma. Salumadi ma kofakofadi au falelidi; afa efamiu tabu au siꞌeiyedi. ");
INSERT INTO bxh_vpl VALUES ("IS58_8","024_58_8","ISA","58","8","8","Haba emi mala sa sina doha hwalahwalala maihalana, be haba feula, na ami loholoho. Emi laulau dudulaidi haba sa eda bwaꞌiyemiu, na Guyau ena namanamali haba mulimiu ya bobodiyen. ");
INSERT INTO bxh_vpl VALUES ("IS58_9","024_58_9","ISA","58","9","9","Yena ami anꞌetai, Guyau haba alinamiu ya bui, na sagu ami anꞌetai haba iyen, “Yau ite!” Dodoga haisa ami abi faheyayadi, e ami fagilu gaibuidi, e ami liba fafaheyayadi, mate bena ami fatautau. ");
INSERT INTO bxh_vpl VALUES ("IS58_10","024_58_10","ISA","58","10","10","Yena tau guliguliyam kalahe adi au soi, yo safaluma edi mwahuli sa heyaya, au saguhidi Haba kamumu ai ganahewana emi mala ya sina, na maihona haba doha lahai laꞌi maihalana. ");
INSERT INTO bxh_vpl VALUES ("IS61_1","024_61_1","ISA","61","1","1","Guyau Hewa Wananaha yai, Yaluwana mate hewagu yai, paꞌana Guyau haꞌa ya baguigu, be wasa loholohona, tau gogo gesegesa E falibadi. Tau nuwa heyaya nuwadi E faꞌamnadi, yo deli yai haba E soꞌe fahidi. ");
INSERT INTO bxh_vpl VALUES ("IS61_2","024_61_2","ISA","61","2","2","Guyau ena nuwa amna bolimanna bena E falibadi, yo adi gum, bolimanna bena edi E liba. Tau tan bena nuwadi E faꞌamnadi. ");
INSERT INTO bxh_vpl VALUES ("IS61_3","024_61_3","ISA","61","3","3","Tau logo Saiyon yai sa anouya haba E faꞌanbonadi. Tan falau damahina mate haba kwade E feledi, Nuwa belubelu yaluwana ya ofi na sa fadebasae. Iti haba hesadi “Dudulai oyagidi” Guyau ya umahidi, be hesana aba lau famahatana. ");
INSERT INTO bxh_vpl VALUES ("IS61_6","024_61_6","ISA","61","6","6","Haba hesamiu sa atahidi “Guyau ena tau antalasam,” yo haba umi “Yaubada ena tau paisowa.” Haba Nuꞌu hahaisa edi loholoho yai ami miyamiya yo ami nuwa saesaedi, doha enehemiu. ");
INSERT INTO bxh_vpl VALUES ("IS61_7","024_61_7","ISA","61","7","7","Sa lawe hudoꞌiyedi, taumayamaya buina haba egu dodoga edi gogo sa ouli, Na hige faꞌatiti, buina mate edi gogo yai haba sa kwade; yo edi tanohi ana sigasiga haba ya falaꞌi. Be kwade hige ofina, mate iti, enehedi. Egu nuwa adidili yai haba egu dodoga E famaisadi, be egu yali otaꞌota fahina ai lisidi E ginauli. ");
INSERT INTO bxh_vpl VALUES ("IS61_8","024_61_8","ISA","61","8","8","Guyau iyen, “Dudulai E fanuha! Angafu yo laulau heyaheyayadi agu ꞌwaiꞌwaiyoꞌo. Egu dodoga haba E famaisadi, yo maidagu haba yali otaꞌota fahina ꞌe ginauli. ");
INSERT INTO bxh_vpl VALUES ("IS61_9","024_61_9","ISA","61","9","9","Laulauwewedi yo afa wahadi haba ai nuꞌuna sa sibaidi be salumadi sa itadi haba tiyen, ‘Iti mate Guyau ena faloholoho dodogadi.” ");
INSERT INTO bxh_vpl VALUES ("IS61_10","024_61_10","ISA","61","10","10","Nuwagu ya amna wananaha Guyau lisina yai. Yaluwagu ya kwade Yaubada lebena yai, paꞌana ya faleligu famwahuli lelina yai. Yo dudulai lelina yai ya sumagu. Doha tau nahi tautaumoho kuluna ya faꞌanbona doha tau antalasam na waiwaihin ana salusalu ya liꞌodi. ");
INSERT INTO bxh_vpl VALUES ("IS61_11","024_61_11","ISA","61","11","11","Guyau haba fadebasae yo dudulai ya famahata nuꞌu mahudoꞌina tanoꞌubu yai doha liꞌe sa sipo laꞌa tanohi yai. Be Guyau hewa wananaha yai haba dudulai yo fadebasae ya ginauli, be sa sipo laꞌa nuꞌu mahudoꞌidi matadi yai. ");
INSERT INTO bxh_vpl VALUES ("IS64_4","024_64_4","ISA","64","4","4","Beyabeyana hige sai laꞌi yaubada hesa wasana i atahiyen yo nenena i ita, doha Um. Um ibom mate salumadi sa bagibagiyem enehedi wa paisowa. ");
INSERT INTO bxh_vpl VALUES ("IS64_5","024_64_5","ISA","64","5","5","Wa laoma be salumadi ma nuwa amnadi dudulai sa laulau ginauli, wa saguhida. Yo em laulau sa miyamiyaꞌedi, wa yoga hitinidi. In moho heyaya hola E laulau ginauli, be manam E fabala. Haba sidohana ema mwahumwahuli? ");
INSERT INTO bxh_vpl VALUES ("IS64_6","024_64_6","ISA","64","6","6","Mahudoꞌimai tau heyaya. Ema laulau dudulaidi mahudoꞌidi doha ahe sausau bidabidadi. Ai E hohoya doha oyagi lugudi; Yo doha hwayahwayau ema heyaya ya uya hudoꞌiyedi. ");
INSERT INTO bxh_vpl VALUES ("IS64_7","024_64_7","ISA","64","7","7","Hige sai hesam yai i lauꞌuꞌula, e, i miya esegahi lisim yai. Be wa sana mulimuliyemai, yo wa ita afulemai, be ema heyaya sa lawe hudoꞌiyemai. ");
INSERT INTO bxh_vpl VALUES ("IS64_8","024_64_8","ISA","64","8","8","In moho, Guyau, um Tamamai. Ai bwadagowa, na um tau falasa. Nimam yai wa falasamai. ");
INSERT INTO bxh_vpl VALUES ("IS64_9","024_64_9","ISA","64","9","9","Guyau, tabu em manabala u falofa, yo ema heyaheyaya tabu ai nuwam ti ota. Ema lauꞌuꞌula u atahiyedi, be u nuwatohatohaemai paꞌana mahudoꞌimai, em dodoga. ");
INSERT INTO bxh_vpl VALUES ("JR1_4","025_1_4","JER","1","4","4","Guyau ya libama lisigu iyen, ");
INSERT INTO bxh_vpl VALUES ("JR1_5","025_1_5","JER","1","5","5","Boga yai hola hige ya falasam, na haꞌa E fasinabom, yo hola hige u tubu na haꞌa E fagabim. E fasinabom haba nuꞌu ouꞌouli edi peloweta. ");
INSERT INTO bxh_vpl VALUES ("JR1_6","025_1_6","JER","1","6","6","Guyau alinana E bui, yawa, Hewa Wananahana Guyauna, hige ya sibai haba sidohana egu libaliba. Yau wawaya! ");
INSERT INTO bxh_vpl VALUES ("JR1_7","025_1_7","JER","1","7","7","In moho Guyau ya falibagu iyen, “Tabu u liba uwe, ‘Yau wawaya.’ U lau dodoga lisidi be somo E falibam, edi u liba.” ");
INSERT INTO bxh_vpl VALUES ("JR1_8","025_1_8","JER","1","8","8","Guyau ya liba iyen, Tabu u ꞌwasabuwedi! Yau maꞌem yo haba E bobodiyem! ");
INSERT INTO bxh_vpl VALUES ("JR1_9","025_1_9","JER","1","9","9","Habahim Guyau nimana ya lolon be sopagu ya abiꞌona na ya libama lisigu iyen, Egu liba haꞌa E felem. U libalibaedi! ");
INSERT INTO bxh_vpl VALUES ("JR1_10","025_1_10","JER","1","10","10","Aho ite gigibwali E felem gonowana kin nuꞌu ouꞌouli yai edi paipaisowa wa lei hafihafitidi be wa an faheyayaidi doha luma wa anlubi lopalopaidi e umaꞌuma wa laꞌa fahidi. Na nuꞌu hahaisa edi kin wa saguhidi doha liꞌe wa umahidi, e luma wa faꞌobiyo fuyoꞌidi. ");
INSERT INTO bxh_vpl VALUES ("JR1_17","025_1_17","JER","1","17","17","Guyau ya liba doha ite, iye, Delamaiya, u abi nonoha! Be u obiyo u lau, somo E falibam, u falibadi. Tabu u ꞌwasabu yo tabu nuwam i mode. Yau moho bena wa ꞌwasabuꞌegu. ");
INSERT INTO bxh_vpl VALUES ("JR1_18","025_1_18","JER","1","18","18","Ma! Adidili E felem doha taon ganana lofalofa wananahana e doha duhu powati e doha bilibili kapa. Ibege Kin yo ena tau paisowa iti dodoga lalalaꞌi yo antalasam tau gabugabudi yo Diuda dodogadi ibege ti lei hafihafitim. ");
INSERT INTO bxh_vpl VALUES ("JR1_19","025_1_19","JER","1","19","19","Haba sa faꞌwaiyunum, in moho hige gonowadi ti sai tawatawaim, paꞌana Yau maꞌem be haba E fofofahim. Yau, Guyau, E liba doha. ");
INSERT INTO bxh_vpl VALUES ("JR6_13","025_6_13","JER","6","13","13","Isalaela dodogadi, puꞌopuꞌou yo dodoga fafahesadi mate gogo nuwadi ya famohafudi; peloweta yo antalasam tau laulau ginauli sa laulau bwalabwala. ");
INSERT INTO bxh_vpl VALUES ("JR6_14","025_6_14","JER","6","14","14","Edi nuwatuhu mate bena dodoga edi kamkamna ya kiu, doha omata kiukiu, be hige ti modeꞌedi. In moho, egu dodoga edi kamkamna sa lalaꞌi wananaha doha omata lalaꞌidi. Auwe “Ginauli mahudoꞌidi sa dudulai.” In moho, higeꞌe. Ginauli hige ti lau dudulai. ");
INSERT INTO bxh_vpl VALUES ("JR17_5","025_17_5","JER","17","5","5","Guyau ya liba doha ite, iyen, Yena sai laꞌi tanoꞌubu dogana ya sunumaꞌen, yo ena fanufanuha moho ya laulau watanidi, na Yau, Guyau, ya sana mulimuliyegu mate haba E kaumananaen. ");
INSERT INTO bxh_vpl VALUES ("JR17_6","025_17_6","JER","17","6","6","Itaꞌitana haba doha oyagi hige i in loholoho nuꞌu pitapitalina yai, e doha tano aliꞌalitana yai, hige dodoga ti miyai, mate ya miya amainiya. Bobonna asubena, ibege somo hesa loholohona i lobahi. ");
INSERT INTO bxh_vpl VALUES ("JR17_7","025_17_7","JER","17","7","7","Sai ya sunusunumaꞌegu haba loholoho E felen. ");
INSERT INTO bxh_vpl VALUES ("JR17_8","025_17_8","JER","17","8","8","In haba itaꞌitana doha oyagi hoꞌowa sadaina yai ya in hasa, be lamna mate sa susu lau hoꞌowa. Siuhwalo yai hige i mode. Luguna mate sa lau idahe. Yena hige usa mate ibege i mode. Ya fuwa moho. ");
INSERT INTO bxh_vpl VALUES ("JR17_9","025_17_9","JER","17","9","9","Sai gonowana dodoga nuwadi ya sibaidi? Fuya ouꞌouli sa buibuinidi, be heyaya yo laulau bwalabwala doha bonu laꞌilaꞌidi, na hige gonowana sai haba i faloholohodi. ");
INSERT INTO bxh_vpl VALUES ("JR17_10","025_17_10","JER","17","10","10","In moho Yau, Guyau, dodoga nuwadi E sibaidi. Edi nuwatuhu yo edi amna E mainene komakomanidi, Habahim esega - esega ena miyamiya yo ena paipaisowa, maisana E felen. ");
INSERT INTO bxh_vpl VALUES ("JR20_5","025_20_5","JER","20","5","5","Isalaela adi waiyunu haba E laliyedi be Diuda edi kin boludi, edi gogo loholohodi, siluba yo gole mahudoꞌidi haba sa tanogogoꞌidi be sa lawedi Babilon. ");
INSERT INTO bxh_vpl VALUES ("JR20_6","025_20_6","JER","20","6","6","Pasula, um yo safalumadi sa miyamiya em luma yai haba sa lawemiu Babilon, um yo afa haidam boludi safalumadi ami liba peloweta bwalabwala. Ainiya, haba ami peꞌi be sa boꞌusaimiu. ");
INSERT INTO bxh_vpl VALUES ("JR20_7","025_20_7","JER","20","7","7","Delamaiya iyen, Guyau, Um wa nuwa liuwigu, be wa bwala fahigu, Um mate wa adidili wananaha habahim yau, be wa lei hafihafitigu. Dodoga mahudoꞌidi sa ala liuliuhwaꞌegu, fuya ouꞌouli. ");
INSERT INTO bxh_vpl VALUES ("JR20_8","025_20_8","JER","20","8","8","Yena bena E liba, mate E yoga laꞌilaꞌi, yawa, “Lau faheyaya yo lulu haba ami lobahidi.” Paꞌana em wasa E libalibaen. Safaluma sa atahiyen mate fuya ouꞌouli sa liba fafaheyayagu yo sa liba fafataumayamayagu. ");
INSERT INTO bxh_vpl VALUES ("JR20_9","025_20_9","JER","20","9","9","Na yena yawa, “Yaubada haba E nuwa fuiyen,” be ibege ai hesana ya libaliba fuyo, ena liba ya alaꞌala doha oyagi alaꞌalana nuwagu yai. E anpate bena E abi didin ai nuwagu, in moho hige gonowagu. ");
INSERT INTO bxh_vpl VALUES ("JR20_10","025_20_10","JER","20","10","10","E ataꞌatahi na dodoga mahudoꞌidi sa fafaꞌasu fenafena tiyen, “Nuꞌu mahudoꞌina mate ꞌwasabu ya nuhuli! Delamaiya ta saman, na ta saman!” Yo afa haidagu edi fanuha bena E beꞌu. Sa faifailiba fuyoꞌidi tiyen, “Nuwana haba ena liba i an fuyo, yo somo heyaheyayana ya ginauli haba te bui fuyoi.” ");
INSERT INTO bxh_vpl VALUES ("JR20_11","025_20_11","JER","20","11","11","In moho Um, Yaubada, mate egu tefa yai, doha tau hiyala adiꞌadidilina, wa hasai wananaha, be salumadi bena sa fakamkamnagu haba sa anpate asahaigu. Paꞌana haba ibege adi loge, hige edi faꞌatiti, ya ota esegahi ee–, hige anadan. ");
INSERT INTO bxh_vpl VALUES ("JR20_12","025_20_12","JER","20","12","12","In moho, Yaubada Hewa Wananaha yai, dudulai yai dodoga wa itadi; somo nuwadi yai haꞌa wa sibaidi. Logena, agu hala u abi agu waiyunu lisidi yai, paꞌana egu nuwa pilipili E toleyawa nimam yai. ");
INSERT INTO bxh_vpl VALUES ("JR20_13","025_20_13","JER","20","13","13","Te wana lau Guyau lisina yo te fadebasae! Tau gogo gesagesa, dodoga heyaheyayadi edi gigibwali yai Guyau ya fasagu fahidi. ");
INSERT INTO bxh_vpl VALUES ("JR23_1","025_23_1","JER","23","1","1","Guyau ya liba iyen, Heyaheyaya laꞌilaꞌina haba ya lau egu tau foyafoya lisidi, paꞌana iti doha sipi tau ita watandi salumadi edi yosiyosi sa ita wata faheyayadi be sa faidabalalaidi. ");
INSERT INTO bxh_vpl VALUES ("JR23_2","025_23_2","JER","23","2","2","Debana yai Guyau, Isalaela eda Yaubada, ya libalau dodoga tau ita watanidi lisidi, iyen, Egoba egu dodoga ami ita wata komakomanidi. In moho ami abi faheyayadi yo ami fagegedi. Haba kamkamna E fatalu ai hewamiu paꞌana heyaheyaya ami laulau ginauli. ");
INSERT INTO bxh_vpl VALUES ("JR23_3","025_23_3","JER","23","3","3","Yau ibogu haba egu dodoga otaꞌota fahidi tanoꞌubu mahudoꞌina yai E auledima be E foya fafuyodima edi nuꞌu, Isalaela, egu gana ai ganahewana. Aiteꞌi haba sa talu fanafanatu be sa tadada. ");
INSERT INTO bxh_vpl VALUES ("JR23_4","025_23_4","JER","23","4","4","Guyau ya liba boda iyen, Sipi tau ita watandi haba E faꞌobiyodi be sipi sa ita wata komakomainidi. Ibege sipi ni ti ꞌwasabu fuyo e ti tiletilele, e laꞌi i asina. ");
INSERT INTO bxh_vpl VALUES ("JR23_5","025_23_5","JER","23","5","5","Guyau ya liba iyen, Lahaidi sa laolaoma, Yau haba doga hesa E fasinabo. Deiwidi Laulauwewena Dudulaina haba ya famala tanuwaga. Laulau dudulai yo sibasiba yai haba ya tanuwaga. ");
INSERT INTO bxh_vpl VALUES ("JR23_6","025_23_6","JER","23","6","6","Itete mate tau fasinabo hesana: “Guyau Eda Dudulai.” Fuyana yai ni haba Diuda dodogadi sa mwahuli, na Isalaela haba sa miya gwaugwau. ");
INSERT INTO bxh_vpl VALUES ("JR23_29","025_23_29","JER","23","29","29","Guyau iyen, Egu liba doha oyagi balebalelemna ya ala. Na doha hama umeꞌehu ya oi ifiꞌifi. ");
INSERT INTO bxh_vpl VALUES ("JR31_7","025_31_7","JER","31","7","7","Itete Yaubada ya liba, iyebom, Ma kwademiu au wana Isalaela enehena, Hesana ya laꞌi wananaha, nuꞌu hahaisa ganahewadi yai. Emi fadebasae lilina haba ami wanai, auwen, “Yaubada, em dodoga, salumadi sa lau afuledi, mate u fofofahidi.” ");
INSERT INTO bxh_vpl VALUES ("JR31_8","025_31_8","JER","31","8","8","Ai tefa lidilidi haba E auledima, yo tanoꞌubu ana ai sigasiga E faꞌoigogodima. Tau mata toutou, tau laulau gesa, tau bogaboga, yo salumadi edi labalaba sa hanahanau, haba mahudoꞌidi sa laoma. Be haba sa talu fanafanatu fuyo. ");
INSERT INTO bxh_vpl VALUES ("JR31_9","025_31_9","JER","31","9","9","Egu dodoga ma tandi haba sa fuyoma. Na ma laulauꞌuꞌuladi haba E foyahidima. Haba E foya lawedi hoꞌowa sadaina yai, ai eda dudulaidi, be ibege ti faꞌalu betibeti. Paꞌana Yau, Isalaela tamana. Na natugu tau tuwaha mate Efalaim. ");
INSERT INTO bxh_vpl VALUES ("JR31_31","025_31_31","JER","31","31","31","Guyau iyen, Lahaina ya laolaoma, haba yali falifalihuna E ginauli, ma afa haidagu Isalaela yo Diuda dodogadi. ");
INSERT INTO bxh_vpl VALUES ("JR31_32","025_31_32","JER","31","32","32","Guyau ya liba doha ite, iyen, Yalina ibege doha yali afa wahawahadi ma afa haidagu ai ginauli. Fuyana Idipi yai E abi nimaidi na E foyahi lawedi mulimuli, yali ni sa utusi. In moho, E gadosisiyedi doha taumoho lahuna ya gadosisiyen. ");
INSERT INTO bxh_vpl VALUES ("JR31_33","025_31_33","JER","31","33","33","Guyau iyen, Yali falifalihuna maidagu Isalaela dodogadi ꞌe ginauli, logena itete. Ai muli Yau haba egu laugagayo ai ganahewadi E tole, yo ai nuwadi E ulidi. Yau haba edi Yaubada, na iti haba egu dodoga. ");
INSERT INTO bxh_vpl VALUES ("JR31_34","025_31_34","JER","31","34","34","Guyau ya liba iyen, Ibege sai hesa falena tau miya wasagu ena i liba, o haba hidana i fatalaha be iyen “Guyau u sibai!” Paꞌana mahudoꞌidi haba sa sibaigu, kikiꞌina yo lalaꞌi. Yau haba edi heyaya E liba afulen yo haba E nuwatuhu afulen. ");
INSERT INTO bxh_vpl VALUES ("JR33_14","025_33_14","JER","33","14","14","Yaubada iyen, Ginauli loholohodi E liba fasunumaꞌedi haba E fawananahadi. Ana maihala ya laolaoma Isalaela yo Diuda dodogadi lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("JR33_15","025_33_15","JER","33","15","15","Doha oyagi tutulina lahaina yai Yau haba Deiwidi laulauwewena hesa E fasinabo be ya famala Baꞌisa. Ai nuꞌudi ni Baꞌisa E faꞌobiyo be haba fakasa dudulaidi ya ginaulidi. ");
INSERT INTO bxh_vpl VALUES ("JR33_16","025_33_16","JER","33","16","16","Fuyandi ni, haba Diuda dodogadi sa mwahuli, Yo sa miya gwaugwau. Yo hesa te sa atahi, tiyen, “Yelusalem dodogadi Guyau eda Dudulai.” ");
INSERT INTO bxh_vpl VALUES ("JR38_4","025_38_4","JER","38","4","4","Habahim babaꞌisa sa libalau Kin lisina, tiyen, Delamaiya hige dodoga i saguhidi. Ena libaliba yai tau hiyala yo dodoga nuꞌu balabalamumu yai ya faꞌwasabudi, be nuwadi sa belubelu. Doga te bena te wunui. ");
INSERT INTO bxh_vpl VALUES ("JR38_5","025_38_5","JER","38","5","5","Kin Sedekaiya alinadi ya ehe watawatan iyen, Nimamiu yai E toleyawa. Somo ami fanuha au ginauli, hige gonowana ya gudumiu. ");
INSERT INTO bxh_vpl VALUES ("JR38_6","025_38_6","JER","38","6","6","Yo fede Delamaiya sa lawen Kin natuna Malakiya ana hoꞌowa aba oiꞌoi felenna yai. Puluna mate Malakiya ena gati edi dobidobi yai. Delamaiya mahina yai sa fadalo lidiyen pulu ganahewana yai. In moho hige hoꞌowa, mwano moho. Yo fede Delamaiya ya lau sopu mwano yai. ");
INSERT INTO bxh_vpl VALUES ("LM1_1","026_1_1","LAM","1","1","1","Beyabeyana Yelusalem yai, doga ya ouli wananaha, na aho ite, afaꞌafana! Hesana beyabeyana ya laꞌi nuꞌu hahaisa ganahewadi yai, na aho ite doha hwabuhwabu. Beyabeyana in doha hatafele, na aho ite ya famala tau lau fayofayo. ");
INSERT INTO bxh_vpl VALUES ("LM1_2","026_1_2","LAM","1","2","2","Diuda dodogadi maihonadi sa tan eloꞌelolosi. Tau gadogadosisiyedi mahudoꞌidi sa lau afuledi, hige tau abi famatanodi. Afa haidadi mahudoꞌidi sa sana mulimuliyedi, sa famala adi waiyunu. ");
INSERT INTO bxh_vpl VALUES ("LM1_3","026_1_3","LAM","1","3","3","Be sa lawedi sa famala edi tau lau fayofayo yo mwahu sa fabaheidi. Mulimuli dodogadi ganahewadi yai sa miya na hige aba anyawasi loholohona ti lobahi. Waiyunu mate, Diuda dodogadi sa weꞌa dudu lidi bee–, sa fasai bulubuluhidi. Hige edi aba gela hesa. ");
INSERT INTO bxh_vpl VALUES ("LM1_4","026_1_4","LAM","1","4","4","Iti kapole–, Saiyon edaꞌedadi mate afaꞌafadi. Itaꞌitadi doha ti tantan, paꞌana hige sai laꞌi i lau watanidi i lau be Yaubada i fadebasae. Yelusalem Taonna aba luhuluhu launa afaꞌafana. Tau antalasam sa tan nuwa heyaya, yo wawahin hasahasaladi sa tan eloꞌelolosi. ");
INSERT INTO bxh_vpl VALUES ("LM1_5","026_1_5","LAM","1","5","5","Ana waiyunu sa famala ena baꞌisa, habahim sa miya gwaugwau. Ena heyaya debadi yai, Guyau ya fakamkamna na nanatuna sa tohaidi be sa lawedi nuꞌu eda lofalofa. ");
INSERT INTO bxh_vpl VALUES ("LM1_6","026_1_6","LAM","1","6","6","Beyabeyana Yelusalem itaꞌitana olina, na aho ite higeꞌe. Ena babaꞌisa doha suisui guliguliyamna, tauna sa belubelu paꞌana hige kalahe, ma belubeluna ya gela tau faꞌoyowa matadi yai. ");
INSERT INTO bxh_vpl VALUES ("LM1_7","026_1_7","LAM","1","7","7","Edi kamkamna lahaidi yai, yo fuyana sa leuleu yo sa saisai mate, ginauli loholohodi mahudoꞌidi beyabeyana iti enehedi sa nuwatuhuidi. Isalaela dodogadi hige tau saguhidi fuyanna waiyunu sa fasai bulubuluhidi. Yelusalem ena heyaheyaya yai adi waiyunu sa itadi mate sa ala liuliuhwaꞌedi. ");
INSERT INTO bxh_vpl VALUES ("LM3_19","026_3_19","LAM","3","19","19","Egu kamkamna yo egu lau gaibu E nuwatuhuidi mate nuwagu ya kalapi doha kapasiya. ");
INSERT INTO bxh_vpl VALUES ("LM3_20","026_3_20","LAM","3","20","20","E nuwanuwatuhuidi be nuwagu ya belubelu. ");
INSERT INTO bxh_vpl VALUES ("LM3_21","026_3_21","LAM","3","21","21","In moho ginauli esega yena E nuwatuhui, haba nuwagu ya adidili fuyo mate: ");
INSERT INTO bxh_vpl VALUES ("LM3_22","026_3_22","LAM","3","22","22","Guyau ena gadosisi otaꞌota fahina yai, hola te mwahumwahuli, yo ena nuwatohatoha ibege i ofi. ");
INSERT INTO bxh_vpl VALUES ("LM3_23","026_3_23","LAM","3","23","23","Hwalahwalala ouꞌouli ena gadosisi yo ena nuwatohatoha falifalihudi. Yo ena sunuma ya laꞌi wananaha. ");
INSERT INTO bxh_vpl VALUES ("LM3_24","026_3_24","LAM","3","24","24","Guyau E sunumaꞌen paꞌana In egu gogo mahudoꞌina. ");
INSERT INTO bxh_vpl VALUES ("LM3_25","026_3_25","LAM","3","25","25","Safalumadi Guyau sa sunusunumaꞌen, yo sa yoꞌoyoꞌoi, mate ya loholoho lebedi yai. ");
INSERT INTO bxh_vpl VALUES ("LM3_26","026_3_26","LAM","3","26","26","Ya loholoho, ma nuwa taluda, Guyau ena abi famwahuli te bagiyen. ");
INSERT INTO bxh_vpl VALUES ("LM3_27","026_3_27","LAM","3","27","27","Ya loholoho hinaga, doga ma hewalina e ma hasalana ena mwahu ya baheidi. ");
INSERT INTO bxh_vpl VALUES ("LM3_28","026_3_28","LAM","3","28","28","Guyau lebena yai mwahudi ya tole. Debana yai iyabona ya taꞌai be ya fafamakano. ");
INSERT INTO bxh_vpl VALUES ("LM3_29","026_3_29","LAM","3","29","29","Bena ya hoba lidi, ma nuwa lidilidina Guyau lisina, nuwana, sunuma hola otana. ");
INSERT INTO bxh_vpl VALUES ("LM3_30","026_3_30","LAM","3","30","30","Yena sai ya fanuha bena ya talai, bena papalina ya felen be ya lau papaliꞌi. Haba ya taumayamayaꞌen. ");
INSERT INTO bxh_vpl VALUES ("LM3_31","026_3_31","LAM","3","31","31","Paꞌana Guyau ibege i ꞌwaiyoꞌoꞌen be hige anadan. ");
INSERT INTO bxh_vpl VALUES ("LM3_32","026_3_32","LAM","3","32","32","Guyau nuwa heyaya, nuwana haba ya leyama lisina. In moho ena nuwatohatoha yo ena gadosisi lebena yai ya ota esegahi. ");
INSERT INTO bxh_vpl VALUES ("LM3_33","026_3_33","LAM","3","33","33","Yo hige i fanuha, bena nuwa heyaya yo kamkamna i felen. ");
INSERT INTO bxh_vpl VALUES ("EK1_28","027_1_28","EZK","1","28","28","Itete mate Guyau ena namanamali nenena ya taumahata. Fuyana E ita mate, E beꞌu be E hoba lidi tanohi yai. Na alina hesa E atahi. ");
INSERT INTO bxh_vpl VALUES ("EK2_1","027_2_1","EZK","2","1","1","Ya libama iyen, Doga Natuna, u obiyo! Haba E libawa lisim. ");
INSERT INTO bxh_vpl VALUES ("EK2_2","027_2_2","EZK","2","2","2","Hola ma libalibana na Yaubada Yaluwana ya luhufigu be ya faꞌobiyogu. Na ya libaliba E atahi. ");
INSERT INTO bxh_vpl VALUES ("EK2_3","027_2_3","EZK","2","3","3","Iyen, Doga Natuna, Yau E fatamalim, wa lau tau awayagalaꞌegu Isalaela dodogadi lisidi. Afa wahawahadi yo iti sa awaꞌawayagalaꞌegu ya laoma ee–, aho te. ");
INSERT INTO bxh_vpl VALUES ("EK2_4","027_2_4","EZK","2","4","4","Dodogadi nuwadi sa poꞌi, be E fatamalim, wa lau lisidi. U falibadi, uwen, “Itete Guyau Yaubada alinana!” ");
INSERT INTO bxh_vpl VALUES ("EK2_5","027_2_5","EZK","2","5","5","Ibaꞌi, haba em liba sa atahiyen e higeꞌe? Paꞌana iti tau awayagala. Na haba sa sibai mate peloweta haꞌa maꞌedi. ");
INSERT INTO bxh_vpl VALUES ("EK17_22","027_17_22","EZK","17","22","22","Guyau Yaubada ya liba doha ite: Sida oyagina tutulina inna hewana yai haba E abi be oya hewa lofalofa ainiya E umahi. ");
INSERT INTO bxh_vpl VALUES ("EK17_23","027_17_23","EZK","17","23","23","Isalaela tuꞌana lofalofa yai ni haba ya in be ya failagalagai yo ya fuwa. Haba itaꞌitana ya loholoho wananaha. Ataiꞌa nene hesa - hesa haba sa abi nohi yo sa anlogulogu ainiya. ");
INSERT INTO bxh_vpl VALUES ("EK17_24","027_17_24","EZK","17","24","24","Oyagi mahudoꞌidi tanaꞌai yai haba sa siba mate Yau, Guyau, oyagi laꞌilaꞌi E oi faguli na kiukiu hewana E falofa. Oyagi laulau idahedi E fahohoyadi na hohoyadi haba E faꞌin fuyoꞌidi. Yau Guyau somo haꞌa E libaen, haba E ginauli. ");
INSERT INTO bxh_vpl VALUES ("EK18_25","027_18_25","EZK","18","25","25","In moho umi auwen, “Somo Guyau ya ginaulidi mate hige ti dudulai.” Isalaela dodogamiu hola au ataꞌatahima lisigu. Emi nuwatuhu mate bena egu abiꞌabi hige ti dudulai. In moho, emi laulau hige ti dudulai! ");
INSERT INTO bxh_vpl VALUES ("EK18_26","027_18_26","EZK","18","26","26","Yena doga dudulaina, laulau loloho ya ꞌwaiyoꞌoꞌedi na laulau heyaheyayadi ya lau ginauli, haba ya peꞌi. Ana matapaꞌa mate ena heyaheyaya debadi yai haba ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("EK18_27","027_18_27","EZK","18","27","27","Na yena doga heyaheyayana ena miyamiya ya buidi na loholoho yo dudulai ya ginaulidi, haba ya mwahuli. ");
INSERT INTO bxh_vpl VALUES ("EK18_28","027_18_28","EZK","18","28","28","Heyaya ya ita lobahidi be ena laulau ya buidi, lisina yai ibege i peꞌi, haba ya miya. ");
INSERT INTO bxh_vpl VALUES ("EK33_7","027_33_7","EZK","33","7","7","Tanoꞌubu dogana, aho ite, um E fasinabom be Isalaela dodogadi wa bobodiyedi. Egu liba fanuwatagu u falibadi. ");
INSERT INTO bxh_vpl VALUES ("EK33_8","027_33_8","EZK","33","8","8","Yena Yau, Yaubada yawa, Doga heyaheyaya, wananahana haba ya peꞌi! Na, um Isikiyeli, hige dogana u liba fanuwatagu be ena laulau i buidi, be ena heyaheyaya debadi yai ya peꞌi mate um haba giluna E fabaheim. ");
INSERT INTO bxh_vpl VALUES ("EK33_9","027_33_9","EZK","33","9","9","Yena wa liba fanuwatagu na ena laulau hige i buidi, be ya peꞌi ena heyaya debadi yai, haba wa mwahuli. ");
INSERT INTO bxh_vpl VALUES ("EK34_11","027_34_11","EZK","34","11","12","Guyau Yaubada ya liba doha ite: Yau ibogu haba egu sipi E laulau yoꞌoidi yo E ita watanidi. Gonogonowana doha sipi tau itaꞌita wata ena sipi sa gege, ya fofofahidima be ya ita watanidi. Lahaina ni ya tole yada yo kamukamumu, egu dodoga sa failaulauwidi nuꞌu hahaisa yai, haba E fofofahidima be E ita watanidi. ");
INSERT INTO bxh_vpl VALUES ("EK34_15","027_34_15","EZK","34","15","15","Guyau Yaubada ya liba doha ite: Yau ibogu haba egu sipi E modeꞌedi yo edi aba anꞌanyawasi loholohona yai E faꞌanyawasi. ");
INSERT INTO bxh_vpl VALUES ("EK34_16","027_34_16","EZK","34","16","16","Sa asina haba E yoꞌoidi be E fafuyodima. Sa anꞌomata haba adi omata E sumadi yo asiꞌasiyebodi haba E faloholohodi. In moho, tubutubudi yo adiꞌadidilidi haba E anfaheyayanidi, paꞌana sa andom yo haidadi hige adi ti feledi. Yau haba laulau dudulai yai E foyahidi. ");
INSERT INTO bxh_vpl VALUES ("EK34_17","027_34_17","EZK","34","17","17","Na umi egu sipi! Yau, Guyau Yaubada, E falibamiu doha ite: Haba E fakasamiu yo E dailimiu, doha sipi tau itaꞌita watanina sipi yo gouti ya dailidi. ");
INSERT INTO bxh_vpl VALUES ("EK36_16","027_36_16","EZK","36","16","16","Yaubada ya libama lisigu, iyen, ");
INSERT INTO bxh_vpl VALUES ("EK36_17","027_36_17","EZK","36","17","17","Doga Natuna! Fuyana Isalaela dodogadi ma gogodi, mate heyaya yai edi nuꞌu ni sa miya fabida. Edi laulau E ita, ya heyaya wananaha doha waihin ena nawalahi asiyebona ");
INSERT INTO bxh_vpl VALUES ("EK36_18","027_36_18","EZK","36","18","18","be egu nuwa halahala E fatalu hewadi yai, paꞌana nuꞌuna sa fafabida, sa aiyunu, yo oitau sa taba ohuꞌidi. ");
INSERT INTO bxh_vpl VALUES ("EK36_19","027_36_19","EZK","36","19","19","Edi laulau yai E fakasadi be E anfadabalalaidi sa lau taꞌowawa nuꞌudi yai. ");
INSERT INTO bxh_vpl VALUES ("EK36_20","027_36_20","EZK","36","20","20","In moho, edi aba lau somo yai, hesagu fafatabuna sa kai wegowegogoꞌen paꞌana nuꞌu hahaisa dodogadi sa libaedi tiyen, “Dodoga ni, Guyau enehena, in moho ena nuꞌu sa lau afulen. Nuwada hige gonowana i saguhidi?” ");
INSERT INTO bxh_vpl VALUES ("EK36_21","027_36_21","EZK","36","21","21","Isalaela dodogadi edi aba lau somo yai hesagu fafatabuna sa kai wegowegogoꞌen mate E modeꞌen paꞌana hige ti faꞌatitiyen. ");
INSERT INTO bxh_vpl VALUES ("EK36_22","027_36_22","EZK","36","22","22","Be Isalaela dodogadi u falibadi uwe, Guyau Yaubada ya liba doha ite, Somo bena E ginauli te, hige umi debamiu yai, hesagu fafatabuna debana yai, fuyanna hige au faꞌatitiyen nuꞌu ouꞌouli yai. ");
INSERT INTO bxh_vpl VALUES ("EK36_23","027_36_23","EZK","36","23","23","Fuyanna hesagu laꞌilaꞌi ena fafatabu E famahata nuꞌu ouꞌouli yai, hesaguna ami kai wegowegogoꞌen lisidi yai, haba sa sibai mate Yau, Guyau. Haba E fapaisowamiu be haba sa sibai mate Yau tabuna. Yau, Guyau Yaubada, egu liba, ");
INSERT INTO bxh_vpl VALUES ("EK36_24","027_36_24","EZK","36","24","24","Nuꞌu hahaisa yai haba E abi fafuyomiu emi ai tanohi. ");
INSERT INTO bxh_vpl VALUES ("EK36_25","027_36_25","EZK","36","25","25","Hoꞌowa aꞌawana haba E lau sibuwen ai hewamiu be somo nuwamiu sa fabidadi yo emi tabataba ohu oitau lebedi yai haba E kaisu afuledi. ");
INSERT INTO bxh_vpl VALUES ("EK36_26","027_36_26","EZK","36","26","26","Haba nuwamiu yo emi nuwanuwatuhu E fafwaufwau fuyoꞌidi. Nuwamiu poꞌipoꞌidi doha umeꞌehu haba E buidi, be ami tauꞌulu. ");
INSERT INTO bxh_vpl VALUES ("EK36_27","027_36_27","EZK","36","27","27","Yaluwagu haba E felemiu, be egu laugagayo mahudoꞌidi ami lau watanidi yo ami awaꞌabiyedi. ");
INSERT INTO bxh_vpl VALUES ("EK36_28","027_36_28","EZK","36","28","28","Tanohina beyabeyana ami ulutubu E feledi ainiya haba ami miya. Umi haba egu dodoga, na Yau haba emi Yaubada. ");
INSERT INTO bxh_vpl VALUES ("EK37_1","027_37_1","EZK","37","1","1","Guyau ena gigibwali hewagu yai be Yaluwana yai ya lawegu gon hesa atipuna yai, na amainiya mate dodoga siyadadi ya mohafu. ");
INSERT INTO bxh_vpl VALUES ("EK37_2","027_37_2","EZK","37","2","2","Ya foyahigu E leu yo E sae gonna yai ni, na siyada kokoyagidi boludi E itadi nuꞌu ya wala otaꞌen. ");
INSERT INTO bxh_vpl VALUES ("EK37_3","027_37_3","EZK","37","3","3","Ya fatiꞌoigu iyen, Tanoꞌubu dogana! Siyada ni, gonowadi sa mwahuli, e higeꞌe? Na alinana E bui yawa, Guyau Yaubada, um ibom wa sibai. ");
INSERT INTO bxh_vpl VALUES ("EK37_4","027_37_4","EZK","37","4","4","Habahim ya falibagu iyen, Siyadadi u liba pelowetaidi uwe, Siyada kokoyagidi! Guyau ena liba hola au atahi! ");
INSERT INTO bxh_vpl VALUES ("EK37_5","027_37_5","EZK","37","5","5","Guyau Yaubada ya libawa lisimiu doha ite: “Haba yahafuwa E felemiu be ami mwahuli fuyo.” ");
INSERT INTO bxh_vpl VALUES ("EK37_6","027_37_6","EZK","37","6","6","Bwaꞌibwaꞌina haba wanowano galamiu yo fisihomiu E fasusudi. Ai mulina haba ꞌwapimiu E fapatu. Habahim yahafuwa E felemiu be ami mwahuli fuyo na haba ami sibai mate Yau, Guyau. ");
INSERT INTO bxh_vpl VALUES ("EK37_7","027_37_7","EZK","37","7","7","Yo fede somo ya falibagu E lau watan be E liba peloweta. Hola ma libalibagu na E atahi: Siyada sa faikalekaleledi na sa faisusu fuyoꞌidi. ");
INSERT INTO bxh_vpl VALUES ("EK37_8","027_37_8","EZK","37","8","8","Ma maimaineneigu, na wanowano gala, fisiho yo ꞌwapi E itadi sa taumahata siyada yai. In moho hige yahafuwadi. ");
INSERT INTO bxh_vpl VALUES ("EK37_9","027_37_9","EZK","37","9","9","Yo fede ya falibagu iyen, “Tanoꞌubu dogana! Yahafuwa u liba pelowetai doha ite: ‘Guyau Yaubada iyen, “Hwayahwayau tefa mahudoꞌina yai au towama be au yahafuwa lau silan ni lisidi, be haba sa mwahuli fuyo.” ");
INSERT INTO bxh_vpl VALUES ("EK37_10","027_37_10","EZK","37","10","10","Yo fede somo ya falibagu E lau watan. Hwayahwayau E liba pelowetaidi be yahafuwa silan ya luhufidi. Makai! Ma esega! Na sa mwahuli fuyo, ma lau obiyodi, itaꞌitadi doha tau hiyala pwaluna laꞌilaꞌi. ");
INSERT INTO bxh_vpl VALUES ("EK37_11","027_37_11","EZK","37","11","11","Habahim ya libama iyen, Tanoꞌubu dogana! Isalaela dodogadi mate doha siyada ni. Sa liba tiyen, “Siyadada sa kokoyagi yo hige eda sunuma. Guyau ya tomo afuleda.” ");
INSERT INTO bxh_vpl VALUES ("EK37_12","027_37_12","EZK","37","12","12","Be egu dodoga u liba pelowetaidi uwe, “Guyau Yaubada ya liba doha ite: Ma! Boꞌusamiu haba E soꞌedi be E kamfahimiu na haba E fafuyomiu Isalaela Nuꞌuna. ");
INSERT INTO bxh_vpl VALUES ("EK37_13","027_37_13","EZK","37","13","13","Ai lahaina boꞌusamiu E soꞌedi be E fakalamahanomiu haba ami sibai mate, Yau, Guyau. ");
INSERT INTO bxh_vpl VALUES ("EK37_14","027_37_14","EZK","37","14","14","Haba Yaluwagu E tole ai lisimiu be ami mwahuli fuyo yo emi ai nuꞌu wananahana haba ami gogo, na haba ami sibai mate Yau, Guyau. E libaen. Somo E libaen mate E ginauli watan.” ");
INSERT INTO bxh_vpl VALUES ("EK47_1","027_47_1","EZK","47","1","1","Taumohona ya fafuyogu Dubu laꞌilaꞌina yai, amainiya mate edaꞌedana hafohafona ubuna yai Yomayoman ya dididima E ita. Dubu tefa leuleuna yai ya fatubu, be ya didi ya lau telona sadaina yai be ya lau dobidobi tefa hasahasaina yai. ");
INSERT INTO bxh_vpl VALUES ("EK47_2","027_47_2","EZK","47","2","2","Tefa saesae edaꞌedana yai E kalamahano be dubu E lau afulen be E taꞌiꞌili lau tefa hasahasai edaꞌedana yai. ");
INSERT INTO bxh_vpl VALUES ("EK47_8","027_47_8","EZK","47","8","8","Yomayoman kiukiu E ita ya didima tefa hasahasai edaꞌedana yai. Taumoho wa iyen: Hoꞌowa te tefa hasahasai yai ya didima be Diyodan hoꞌowana gonna yai ya pei taluhi be ya lau gabogabo peꞌipeꞌina yai, amainiya mate alita ya falamo be ya famala hoꞌowa wananaha. ");
INSERT INTO bxh_vpl VALUES ("EK47_9","027_47_9","EZK","47","9","9","Hoꞌowa te ena aba didi yai, mate suisui hudoꞌi - hudoꞌi yo hama, paꞌana mwahuli yo hoꞌowa gogogomana ya leyama gabogabo peꞌipeꞌina yai. ");
INSERT INTO bxh_vpl VALUES ("EK47_12","027_47_12","EZK","47","12","12","Oyagi fuwafuwadi haba hoꞌowana sa in watawatan be nawalahi esega - esega haba sa fuwa. Lugudi ibe ti hohoya, paꞌana hoꞌowa dubu yai ya didima, haba adi sa nom, be haba sa fapaisowa be dodoga sa fafaloholohodi. ");
INSERT INTO bxh_vpl VALUES ("DN7_13","028_7_13","DAN","7","13","13","Maihonana eno yai, tautau hesa E ita, doha Doga Natuna. Yada yai nuwanuwagu yai ya laolaoma. Na sa lawelawen Doga Otaꞌota fahina lisina. ");
INSERT INTO bxh_vpl VALUES ("DN7_14","028_7_14","DAN","7","14","14","Dudulai, faꞌatiti yo aba baꞌisa ya felen. Nuꞌu mahudoꞌina yo alina hesa - hesa dodogadi haba sa fadebasae. Na ena nuꞌu haba ya ota esegahi. Yo ena ita wata paisowana ibege i ofi. ");
INSERT INTO bxh_vpl VALUES ("DN12_1","028_12_1","DAN","12","1","1","Lahai ni haba Anelu edi Baꞌisa, Maikol, em dodoga tau bobodiyendi ya taumahata. Pilipili haba ya heyaya wananaha, habahim nuꞌu edi fuya fatubu, na ya laoma be aho. In moho salumadi hesadi Yaubada ya ulidi ena buka yai haba ya fofofahidi. ");
INSERT INTO bxh_vpl VALUES ("DN12_2","028_12_2","DAN","12","2","2","Salumadi haꞌa sa peꞌi haba sa mwahuli fuyo. Haisa haba sa mwahuli esegahidi na haisa haba sa taumayamaya esegahidi yo haba dodoga sa ꞌwaiyoꞌoꞌedi. ");
INSERT INTO bxh_vpl VALUES ("DN12_3","028_12_3","DAN","12","3","3","Salumadi sa sibasiba yo laulau dudulai yai, dodoga sa fatalahadi, haba sa sina doha maihala galewa yai na sa namanamali doha kipwala. ");
INSERT INTO bxh_vpl VALUES ("HS11_1","029_11_1","HOS","11","1","1","Isalaela dodogadi ma wawayadi, mate E gadosisiyedi yo natugu Idipi yai E yoga fahiyama. ");
INSERT INTO bxh_vpl VALUES ("HS11_2","029_11_2","HOS","11","2","2","Na hola E yogayogaidi, in moho sa luhu afulegu. Sa antalasam lau Baꞌala lisina, yo ainauya panepanedi sa gabudi oitau lisidi. ");
INSERT INTO bxh_vpl VALUES ("AM8_4","031_8_4","AMO","8","4","4","Isalaela dodogamiu au ataꞌatahi, umi logemiu dodoga gogo gesagesa edi nuꞌu yai ami fahisu heyayaidi. ");
INSERT INTO bxh_vpl VALUES ("AM8_5","031_8_5","AMO","8","5","5","Ami libaliba auwen, Sabati yo Nawalahi Falifalihu Mataꞌasidi fafatabudi te, feula ti ofi! Haba ema kalahe ꞌe uneꞌuneidi. Na maisa te lau hitinidi, yo nonoi bwalabwala te fapaisowadi, be tau uneꞌune te bwalafahidi. ");
INSERT INTO bxh_vpl VALUES ("AM8_6","031_8_6","AMO","8","6","6","Witi ma wenuna te uyaꞌuyai mate haba te uneꞌuneꞌen. Tau fagogo gesagesa ana hagahaga hige gonowana i famaisa, doha ahe sumasuma hige gonowana i famaisa mate haba te une fahi be eda fayofayo tau abina. ");
INSERT INTO bxh_vpl VALUES ("AM8_7","031_8_7","AMO","8","7","7","Isalaela edi Guyau Yaubada ya angwala, iyen, Edi laulau heyaheyayadi, ibege nuwagu i fui. ");
INSERT INTO bxh_vpl VALUES ("AM8_10","031_8_10","AMO","8","10","10","Egu gigibwali yai haba mataꞌasi yo wana ami fatautau na haba ami tan eloʼelosisi. Baiki haba ami liʼodi yo kulumiu ami holidi. Haba ami tan eloʼelosisi, doha tawa “Natumiu taumoho esega dumaduma ya peʼi.” Ai lahai ni haba kalapi laꞌilaꞌi ami fahoina. ");
INSERT INTO bxh_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Fuya ma esega, Yaubada ya libalau Amitai natuna Diyona lisina. Iyen, ");
INSERT INTO bxh_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","U lau Ninewa duhu balabalamumuna be u sagaliyedi; paꞌana dodogadi edi heyaheyaya haꞌa E sibaidi. ");
INSERT INTO bxh_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Yo fede, Diyona, edaꞌeda hesa ya lau watan paꞌana hige i fanuha Yaubada ena nuwatuhu i lau watan. Ya leu Diyopa nuꞌuna yai, be waga hesa ya lobahi ya laulau Sipani. Yo fede ena pasisi ya famaisa na bena ya awa gela maidana, waga tau paisowadi, be sa aulaha sa leu Sipani, paꞌana tabu Yaubada ena nuwatuhu i lau watan. ");
INSERT INTO bxh_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Debana yai Yaubada yauma laꞌilaꞌi ya fatamali gabogabo yai mate ya adidili wananaha be waga bena ya lubi dagidagi. ");
INSERT INTO bxh_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Waga tau paisowadi sa ꞌwasabu wananaha, yo fede hesa - hesa ya anꞌeta lau ena yaubada lisina be haba sagu ya lobahi. Ginauli mahudoꞌina waga ganahewana yai sa lofe taluhidi gabogabo yai, be tabu i bulu. Maihalana yai Diyona ya lidi waga ganahewana yai, be ya eno ꞌwafu. ");
INSERT INTO bxh_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Waga tau ulinna Diyona ya ita be ya fatiꞌoi, iyen, Sidohana be wa laulau eno? Haga u obiyo be u lauꞌuꞌula lau em Yaubada lisina be i saguhida. Nuwana haba i nuwatohatohaeda, be ibege ta peꞌi. ");
INSERT INTO bxh_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Waga tau paisowadi sa liba, tiyen, Haga, nesu itaꞌita yai, ta yoꞌoi, haba te lobahi, sai ena ponoli yai be heyaheyaya te lobahi. Yo fede nuwatuhuna sa lau watan, be Diyona gilu ya bahe. ");
INSERT INTO bxh_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Yo fede sa liba, tiyen, Um ꞌe fagilum. Aho te, u falibamai! Somo amaiteꞌi wa ginaginauli? Em nuꞌu somo? ");
INSERT INTO bxh_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Diyona alinadi ya bui, iyen, Yau Hebelu dogana, Galewa Yaubadana, “Yawe,” tanohi yo gabogabo tau ginaulidi E fadebasae ");
INSERT INTO bxh_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Yau aho E gela, paꞌana Yaubada ena nuwatuhu hige ya lau watan. Yo fede, waga tau paisowadi sa tau hiti, be sa liba, ite, Sidohana be doha wa ginauli? ");
INSERT INTO bxh_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Hwayahwayau ya falaꞌi, yo fede waga tau paisowadi sa fatiꞌoi, itebom, Ibe somo ai lisim ꞌe ginauli haba yauma te ya fatautau? ");
INSERT INTO bxh_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Diyona alinadi ya bui, iyen, Au pei lidiyegu, haba gabogabo ya daumwali. E sibai mate egu ponoli yai yauma ya abi esegahimiu. ");
INSERT INTO bxh_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Waga tau paisowadi sa anpate adidili bena waga sa lawen sadai yai. In moho, hige gonowadi paꞌana ainiya, ena abi ya heyaya wananaha. ");
INSERT INTO bxh_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Yo fede, sa anꞌeta lau Yaubada lebena, tiyen, Yaubada, somo ꞌe ginauli doga te lisina yai; tabu u manabalaꞌemai, um em nuwatuhu yai ꞌe ginauli. ");
INSERT INTO bxh_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Habahim Diyona sa abi hitiꞌi; be sa lofe taluhi gabogabo yai. Yo fede, gabogabo ya daumwali. ");
INSERT INTO bxh_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Amainiya, waga tau paisowaidi Isalaela edi Yaubada sa ꞌwasabuwen, yo fede sa kawawananahaꞌen, be edi antalasam sa ginauli, na sa angwala haba sa famuli watan. ");
INSERT INTO bxh_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Yaubada ena nuwatuhu yai hama laꞌilaꞌi ya fatamali be Diyona ya dom. Na ya miya bogana yai lahai faihona yo maihona faihona. ");
INSERT INTO bxh_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Diyona mate hama laꞌilaꞌi bogana yai na ya lauꞌuꞌula lau ena Yaubada lisina. Iyen, ");
INSERT INTO bxh_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Egu Guyau, egu kamkamna te ganahewana yai E anꞌeta laowa lisim; na egu anꞌeta wa atahiyen. Aba peꞌi nuꞌuna yai E anꞌetaim. ");
INSERT INTO bxh_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Um em nuwatuhu yai, be sa lofe lidiyegu gabogabo ipuꞌipuna wananahana yai. Be gabogabo ya fuigu yo bagodu sa laoma hewagu yai sa lau. ");
INSERT INTO bxh_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Nuwagu yai yawa, Nuwana haꞌa u ꞌwaiyoꞌoꞌegu, be ibege ya lobahim. Be nuwagu mate ya mode wananaha; paꞌana em Dubu Tabuna Yelusalem yai, ibege ya ita fuyoi. ");
INSERT INTO bxh_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Gabogabo ya eli buluhi wananahaigu. Gabogabo hawahawadi kulugu sa fakou buluhi. ");
INSERT INTO bxh_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Gabogabo ganahewana yai, tuꞌa edi aba susu fatubu. Amainiya sa gudu buluhigu. In moho, um Yaubada egu Guyau aba peꞌi yai wa fafuyoguma. ");
INSERT INTO bxh_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Yaubada, amnagu E atahi mate haba E peꞌi, yo fede E anꞌeta laowa lebem, na em aba miya yai egu lauꞌuꞌula wa atahiyen. ");
INSERT INTO bxh_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Be yaubada bwalabwala lisidi yai, tau laulauꞌuꞌula lau dodogadi mate, loholoho lisim yai sa ꞌwaiyoꞌoꞌen. ");
INSERT INTO bxh_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","In moho, yau haba E fadebasaem; nuwam aba faloholohona haba E felem; be E angwala mate, somo wa fatalahagu haba E ginauli, Mwahuli Edaꞌedana esega um! ");
INSERT INTO bxh_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Debana yai, Yaubada ya liba be hama ya lau Diyona ya fula afulen fote yai. ");
INSERT INTO bxh_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Yaubada ya liba fuyo Diyona lisina. Iyen, ");
INSERT INTO bxh_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","U lau Ninewa, duhu balabalamumuna yai, be alinagu te dodoga u falibadi. ");
INSERT INTO bxh_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Yo fede, Diyona, Yaubada ena liba ya awaꞌabiyen, be ya lau Ninewa. Nuꞌuna ya laꞌi wananaha, gonowana lahai faihona ai ganahewana sa laufi. ");
INSERT INTO bxh_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Lahai bwaꞌibwaꞌi yai, Diyona ya lau be duhu balabalamumuna ya mahano, habahim ya fatubu ya falibadi. Iyen, Lahai 40 mulina yai Ninewa Nuꞌuna, Yaubada haba ya faheyaya. ");
INSERT INTO bxh_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Ninewa dodogadi mahudoꞌidi, habahim, sa kawawananahaꞌen be edi hineli sa ginauli bena mahudoꞌidi sa andabu. Sa logo be edi baiki sa liꞌodi hinaga, edi nuwabui fafaꞌilalana. ");
INSERT INTO bxh_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Fuyana Ninewa edi kin wasa ya atahiyen, ya logo hinaga. Ena aba taꞌai ya lau afulen, yo ena leli loholohodi ya kamfahidi, na baiki ya liꞌo, na ya lau afusa yai ya taꞌai. ");
INSERT INTO bxh_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Laugagayo ya fatamali Ninewa dodogadi lisidi yai. Iyen, Itete yau yo dodoga lalaꞌi, alinamai, dodoga yo emi bulumakau, sipi, tabu somo laꞌi ti an yo ti nom. ");
INSERT INTO bxh_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Dodoga yo emi yosiyosi bena baiki ami fakoudi, mahudoꞌimiu, bena ma nuwa ofi fahimiu ami lauꞌuꞌula lau Yaubada lisina yo laulau heyaheyaya tabu au ginauli. ");
INSERT INTO bxh_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Yena ita doha te ginauli, nuwana Yaubada Wananahana haba nuwana ya bui, be ibege ta peꞌi. ");
INSERT INTO bxh_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Be somo sa ginauli mate, Yaubada ya ita mate moꞌisa, nuwadi sa buidi, be laulau heyaheyayadi sa fatautaudi. Yo fede, somo Yaubada ya libaen bena ya ginauli wa, nuwana ya bui, be hige i ginauli lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Nuwatuhuna ni Diyona hige i fanuha, be ya famala ena manabala. ");
INSERT INTO bxh_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Yo fede, ya lauꞌuꞌula, iyen, Guyau, doha haꞌa E falibam, fuyana hola hige egu nuꞌu ya lau afulen mate, bena doha ite wa ginauli? Logena be E gela E lau Sipani! E siba mate, um tauꞌulu yo nuwatohatoha Yaubadana. Fuya ouꞌouli wa nuwa talu, wa tauꞌulu, ma nuwa ofi fahim, yo fuya ouꞌouli hinaga nuwam wa bui, be ibege heyaheyaya u ginaulidi. ");
INSERT INTO bxh_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Guyau, aho te, E falibam ibe wa lau funuhigu mate, ya loholoho! ");
INSERT INTO bxh_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Yaubada wa, Diyona alinana ya bui, iyen, Em dudulai somo be wa manabala? ");
INSERT INTO bxh_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Diyona ya finahe hasa duhu balabalamumuna ganamulina yai ya taꞌai. Mulina yai ena gwaꞌu ya pei, be ya anlogulogu. Habahim ya bagibagi haba somo Ninewa ai lisidi ya tubu bena ya ita. ");
INSERT INTO bxh_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Habahim, Yaubada ya liba be mahina hudoꞌi ya in hasa, be Diyona ya faꞌanlogulogu, haba kamnana ya loholoho. Diyona nuwana ya amna wananaha mahina lisina yai. ");
INSERT INTO bxh_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Bobonna ya ifi tatatali, Yaubada ena nuwatuhu yai, mwatamwata mahina wa ya faheyaya, yo fede, ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Maihala haꞌa ya kepama, Yaubada bolibolima gigibwalina ya fatowa, yo maihala gigibwalina Diyona kuluna ya sinai, be egoba ya tau peꞌipeꞌi, na iyen, Ibe E peꞌi mate, ya loholoho. ");
INSERT INTO bxh_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Yo fede, Yaubada ya libalau lisina, iyen, Em dudulai somo be mahina te wa luluwen? Alinana Diyona ya bui, iyen, Maꞌegu dudulai be E manabala. Manabalana ni, ibe ya kamfunuhigu! ");
INSERT INTO bxh_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Yaubada ya libalau lisina, iyen, Mahina ni maihona esega ganahewana yai ya in, na bobonna ya peꞌi. Um hige somo u ginauli lisina yai, yo hige u faꞌin. ");
INSERT INTO bxh_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Egu nuwatohatoha laꞌina haba doha somo, Ninewa duhu balabalamumuna ni ai lisidi? In moho ganahewana yai mate, dodoga loholohodi 120,000 ya diꞌoi, yo edi yosiyosi hinaga oulina doha. ");
INSERT INTO bxh_vpl VALUES ("MC5_1","034_5_1","MIC","5","1","1","Yelusalem dodogamiu! Emi hiyala tataudi au yoga gogondima. Nuꞌu haisa edi hiyala tataudi sa gana panpanda! Isalaela edi baꞌisa haba sa duhu mahanoi! ");
INSERT INTO bxh_vpl VALUES ("MC5_2","034_5_2","MIC","5","2","2","Yaubada iyebom, Betelehem Efalata, Diuda nuꞌuna ganahewana yai mate um taon kiukiu, na ai ganahewam haba Isalaela edi baꞌisa ya tubu, wahawahana yo ena sulu mate beyabeyana haꞌa amaiteꞌi sa miyamiya ya laoma bee–, aho te. ");
INSERT INTO bxh_vpl VALUES ("MC5_3","034_5_3","MIC","5","3","3","Yaubada haba ena dodoga Isalaela ya sana mulimuliyedi ya lau ee–, ana lahai ya mahano, mate waihin hesa, natuna taumoho haba ya yosi. Ai mulina, gwama te, ana boga nuꞌu hudoꞌi - hudoꞌi yai haba sa fuyoma, ma afa efadi sa faꞌoigogo esega, edi ai tanohi. ");
INSERT INTO bxh_vpl VALUES ("MC5_4","034_5_4","MIC","5","4","4","Yena ya laoma, Guyau Yaubada ena adidili yo ena faꞌatiti haba ya felen. Be ena dodoga haba ya tanuwagaidi. Dodoga haba sa miya gwaugwau, paꞌana tanoꞌubu dodogadi haba sa faꞌatitiyen. ");
INSERT INTO bxh_vpl VALUES ("ZC9_9","039_9_9","ZEC","9","9","9","Yelusalem dodogamiu! Nuwamiu ti amna yo au yoga laꞌilaꞌi. Ami ita! Emi baꞌisa ya laoma lisimiu. Ena laulau sa dudulai yo waiyunu ya sai tawatawandi yo ya lei hafihafitidi. Ya nuwa lidilidi be donki gubugubufwauna ya awai. ");
INSERT INTO bxh_vpl VALUES ("ZC9_10","039_9_10","ZEC","9","10","10","Guyau iyen, Yau haba saliyoti Isalaela yai E kamfahidi yo hiyala hosidi Yelusalem yai haba E abidi. Kukupidu hiyala yai sa fapaisowadi haba sa tapwaipwai. Em fuya tanuwaga yai, haba nuꞌu haisa ma afa haidadi sa fanuwa esega. Em Aba Baꞌisa mate gabogabo yai te ya fatubu ya lau ee–, gabogabo hahaisa yai, yo Ifeleti Hoꞌowana ya lau ee–, tanohi ana sigasiga. ");
INSERT INTO bxh_vpl VALUES ("ZC12_10","039_12_10","ZEC","12","10","10","Guyau iyen, Deiwidi laulauwewena yo Yelusalem tau miyaina haba egu gigibwali yai E ginaulidi be sa fafaꞌita nuwatohatoha yo haba lauꞌuꞌula amnana ya abidi. Sa gwaligu be E peꞌi, mate dodoga sa ita. Be halagu sa tan doha natudi esega dumaduma e halahalafwauna halana sa tan eloꞌelolosi. ");
INSERT INTO bxh_vpl VALUES ("ZC12_11","039_12_11","ZEC","12","11","11","Ai lahaina haba tan laꞌilaꞌi ai Yelusalem doha Megido gonna yai, Hadada Limon nuꞌuna edi tantansina. ");
INSERT INTO bxh_vpl VALUES ("ZC13_1","039_13_1","ZEC","13","1","1","Guyau, Tau Gigibwali iyen, Ai Lahaina haba hoꞌowa yomayomanna ya didima, be Deiwidi laulauwewena yo Yelusalem tau miyaina edi heyaya yo nuwatuhu bidabidadi haba ya kaisu fahidi. ");
INSERT INTO bxh_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Itete Yesu Keliso wasana loholohona. In mate Yaubada Natuna. ");
INSERT INTO bxh_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ena fatufatubu mate haꞌa peloweta Isaiya ya uli doha ite: Yaubada iyen, “Egu wasa tau lawenina haba E dui bwaꞌiyen, be em edaꞌeda ya faꞌaꞌa nonohai.” ");
INSERT INTO bxh_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Doga hesa nuꞌu pitapitalina yai ya yogayoga iyebom, “Guyau ena edaꞌeda au abi nonohai; ena aba lau au fadudulai haba ya lau watan!” ");
INSERT INTO bxh_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","5","Yo fede Diyon ya laoma nuꞌu pitapitalina yai be ya lauguguya. Dodoga boludi Yelusalem taonna yai yo Diudeya Nuꞌuna yai sa lau lisina be ya falibadi iyen, Au nuwabui na au babasito. Haba emi heyaheyaya ni Yaubada ya nuwa afuledi. Yo fede edi heyaheyaya sa liba famahatadi be Diyodan Hoꞌowana yai ya fafababasitodi. ");
INSERT INTO bxh_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Diyon ena leli ya liꞌodi mate kamela olodi yai ya ginaulidi na ana bwaꞌulu mate yosiyosi ꞌwapina na ana kalahe mate digolele yo amoꞌamo. ");
INSERT INTO bxh_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Dodoga ya falibadi iyen, Doga muligu yai ya laoma mate in ya hasai wananaha, habahim yau. Yau hige ya loholoho haba ya dulu lidi be ana sendolo mahinadi ya tatadi. ");
INSERT INTO bxh_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yau haba E fababasitomiu hoꞌowa yai na In haba ai Yaluwa Tabuna ya fababasitomiu. ");
INSERT INTO bxh_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Lahaidi yai ni Yesu, taon hesa hesana Nasaleta, Galili nuꞌuna yai ya laoma be Diyon wa Yesu ya fababasito Diyodan Hoꞌowana yai. ");
INSERT INTO bxh_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu hoꞌowa yai ya pohema. Galewa ya tasoꞌe ya ita na Yaluwa Tabuna doha waliliya ya lidima hewana yai. ");
INSERT INTO bxh_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na alina Galewa yai ya libama iyen, Um mate Natu Eseꞌesegagu. E fanuha wananahaim. ");
INSERT INTO bxh_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Yo fede Yaluwa Tabuna ya foyahi lawen nuꞌu pitapitalina yai. ");
INSERT INTO bxh_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Amainiya ya miya lahai 40 na Diyabolo ya lauꞌita. Suisui yekoyekodi amainiya hinaga. In moho anelu sa laoma be sa saguhi. ");
INSERT INTO bxh_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Diyon sa falau deli na mulina yai Yesu ya lau Galili be Yaubada wasana loholohona ya lauguguyaꞌen iyen, ");
INSERT INTO bxh_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yaubada ena lahai peloweta sa libalibaen mate ya fawananaha yo Yaubada Aba Baꞌisa haꞌa ya sigima! Nuwamiu au buidi yo wasa loholohona au kawawananahaꞌen! ");
INSERT INTO bxh_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Galili gelegelena yai Yesu ya laulau na tau hamahama luwaga ya itadi. Saimon ma hidana Endulu, edi hagida sa peipeiꞌidi gabogabo yai. ");
INSERT INTO bxh_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu ya falibadi iyen, Au lau watanigu. Haba dodoga sidohana onaꞌonadi E fatalahamiu. ");
INSERT INTO bxh_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Makai ma luwaga, edi hagida sa lau afuledi na maꞌedi sa lau. ");
INSERT INTO bxh_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ya aulaha boda yo fede Diyemsi ma hidana Diyon ya itadi. Iti mate Sebedi nanatuna. Waga yai edi hagida sa abiꞌabi nonohaidi. ");
INSERT INTO bxh_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesu ya itaꞌita lau be ya itadi yo fede ya fayogadi. Tamadi Sebedi, sa luhu afulen waga yai, maidana edi tau paisowa na Yesu maꞌedi sa lau. ");
INSERT INTO bxh_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu yo tau famuli watanina sa mahano lau Kapanayum taonna yai na Sabati hudoꞌi yai Yesu ya lau aba oiꞌoigogo lumana yai be ya fatubu ya lau faꞌata. ");
INSERT INTO bxh_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yo fede ena lau faꞌata sa noꞌoꞌen paꞌana In maꞌena dudulai yo gigibwali yai ya lau faꞌata. Hige doha laugagayo tau lau faꞌataendi. ");
INSERT INTO bxh_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hige walolona doga hesa ya luhulau aba oiꞌoigogo lumana yai. Doga te, yaluwa heyaheyayana ganahewana yai. Ya ꞌwalaꞌui iyebom, ");
INSERT INTO bxh_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Yesu, Um mate Nasaleta dogana. Somo wa fanuha lisimai yai? Wa laoma te bena wa lau funuhimai? Haꞌa E sibaim! Um mate Yaubada ena Wasa Tau Leyamana Fafatabuna! ");
INSERT INTO bxh_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu ya libalau yaluwa heyaheyayana lisina iyen, U famakano na doga ni u lau afulen! ");
INSERT INTO bxh_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Yaluwa heyaheyayana doga te ya kamfafatabubu na ya halabo yo fede ya kalamahano. ");
INSERT INTO bxh_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Dodoga sa noꞌo. Yo fede sa famoꞌa libaliba tiyen, Mate somo? Nuwana lau faꞌata fwaufwaudi haisa? Doga te, gigibwali lisina yai logena yaluwa heyaheyayadi ya falibadi be alinana sa lau watan! ");
INSERT INTO bxh_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Na Yesu wasana ya tadada feula Galili tefa mahudoꞌina yai. ");
INSERT INTO bxh_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu yo tau famuli watanina maꞌedi Diyemsi yo Diyon aba oiꞌoigogo lumana sa lau afulen be sa dudulai sa lau Saimon yo Endulu edi luma. ");
INSERT INTO bxh_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimon botiyana waiwaihin tauna sa gigibwali be ya laulau eno na wasana Yesu ena sa liba. ");
INSERT INTO bxh_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yo fede ya lau ya ita. Ya abilau nimana yai be ya abi famwaito. Yo fede tauna gigibwalidi sa talu mwalugulugu be ya paulaidi. ");
INSERT INTO bxh_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Maihala ya bulu mulina yai dodoga tau asiꞌasiyebo yo salumadi yaluwa heyaheyayadi ganahewadi yai, mahudoꞌidi sa ledima Yesu lebena. ");
INSERT INTO bxh_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Taon dodogadi mahudoꞌidi sa faꞌoigogoma luma hafohafona yai. ");
INSERT INTO bxh_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Salumadi asiyebo hudoꞌi - hudoꞌi sa abidi mate Yesu ya faloholohodi yo yaluwa heyaheyayadi ganahewadi yai ya liba afuledi. Yaluwa heyaheyayadi mate hige gonowana somo ti libaen paꞌana iti sa sibai mate, in sai. ");
INSERT INTO bxh_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Hwalahwalala ma kamukamumuna Yesu ya obiyo be ya lau mala tupwam yai. Amainiya ya lauꞌuꞌula. ");
INSERT INTO bxh_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimon ma afa haidana sa lau sa yoꞌoi yee–, ");
INSERT INTO bxh_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","sa lobahi. Sa faliba tiyen, Dodoga boludi mate sa yoꞌoyoꞌoim. ");
INSERT INTO bxh_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yo fede Yesu alinadi ya bui iyebom, Nuꞌu hahaisa sadasadai yai bena te laufidi be haba ainiya E lauguguya hinaga. Logena E laoma. ");
INSERT INTO bxh_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Na Galili mahudoꞌina ya fataꞌiꞌili be aba oiꞌoigogo lumadi yai ya lauguguya yo yaluwa heyaheyayadi ya liba duidi. ");
INSERT INTO bxh_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Taumoho lepela ya abi ya laoma ya tulibono Yesu nuwanuwana yai, na ya anꞌetai iyen, Yena wa fanuha, um gonowana wa faloholohogu. ");
INSERT INTO bxh_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu ya nuwatohatohaen be ya abilau tauna yai na iyen, E fanuha. U loholoho! ");
INSERT INTO bxh_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yo fede lepela asiyebona ya ofi na ya loholoho. ");
INSERT INTO bxh_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Habahim Yesu, doga ni ya falaugagayo iyen, Tabu u fatala libalibaen, na u lau tau antalasam lisina be i ita sipoim. Haba ya fawananaha dodoga ai lisidi mate am asiyebo haꞌa ya ofi. Ai mulina habahim Mose antalasam somo ya libaen u ginauli watan. Yo fede ya dui be ya lau. ");
INSERT INTO bxh_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Taumoho wa ya lau be ya fatala libalibaen nuꞌu ouꞌouli yai be Yesu hige gonowana i lau mahamahata ai taon. Logena ya miya tauduma mala tupwam yai, na dodoga tefa hesa - hesa yai sa laoma lisina. ");
INSERT INTO bxh_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Lahai fisa sa ofi mulidi yai, Yesu ya fuyo Kapanayum na wasana sa atahiyen mate In ya mahano fuyoma luma. ");
INSERT INTO bxh_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Yo fede dodoga boludi sa faꞌoigogoma be luma sa lau fafamohafu. Hige solasola laꞌi edaꞌeda hafohafona yai. Yesu mate Yaubada ena liba ya fafalibadi. ");
INSERT INTO bxh_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yo fede tatau fati taumoho ahe peꞌipeꞌina sa baheiyama Yesu lisina. ");
INSERT INTO bxh_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Hige gonowadi bena ti lawen lisina paꞌana dodoga sa ouli wananaha. Yo fede luma hewana yai solasola sa ginauli be doga wa sa fadalolo Yesu ena aba obiꞌobiyo yai. ");
INSERT INTO bxh_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Edi sunuma laꞌina ya ita yo fede Yesu doga ahena sa peꞌipeꞌi ya faliba iyebom, Natugu, em heyaheyaya haꞌa E liba afuledi. ");
INSERT INTO bxh_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Laugagayo tau lau faꞌataena haisa amainiya sa taꞌataꞌai nuwadi yai itebom, ");
INSERT INTO bxh_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Sidohana be ya liba doha? Ataꞌatahina doha Yaubada hesana i kaiwegowegogoꞌen! Yaubada iyabona gonowana heyaheyaya ya liba-afuledi! ");
INSERT INTO bxh_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Edi nuwanuwatuhu Yesu haꞌa ya sibai yo fede ya libalau lisidi, Paꞌana somo be ami nuwanuwatuhu doha ite? ");
INSERT INTO bxh_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Somo ya malaha? Ibe tawa, “Taumoho tauna sa peꞌipeꞌi, em heyaheyaya E nuwatuhu afuledi,” e haba tawa, “U obiyo! Em aba eno u abi na u aulaha.” ");
INSERT INTO bxh_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bena ami sibai mate Doga Natuna ena gigibwali tanoꞌubu yai te gonowana heyaya ya liba afuledi. ");
INSERT INTO bxh_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Logena tau asiyebo E faliba yawa, “U obiyo! Em aba eno u abi na u lau em luma.” ");
INSERT INTO bxh_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Matadi yai ya obiyo be ena aba eno ya abi na ya aulaha. Ouꞌoulidi sa noꞌo na Yaubada sa fadebasae tiyen, Hige somo laꞌi ai ita doha ite! ");
INSERT INTO bxh_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu ya fuyo Galili Gabogabona sadaina yai na baiwa laꞌilaꞌi sa laoma lisina be ya lau faꞌataidi. ");
INSERT INTO bxh_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ya laulau na takesi tau tanotano Lewi, in Alefaiyesi Natuna, ena ofesi yai ya taꞌataꞌai ya ita. Yesu ya libalau lebena iyen, U famuli watanigu. Yo fede Lewi ya aulaha be Yesu ya famuli watan. ");
INSERT INTO bxh_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Dodoga boludi Yesu sa famuli watan. In hola Lewi ena luma yai na takesi tau tanotano yo dodoga heyaheyayadi maidadi Yesu yo tau famuli watanina sa kalahe gogo. ");
INSERT INTO bxh_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Laugagayo tau lau faꞌataenna yo Falesiya Yesu sa ita ya kalakalahe maidana takesi tau tanotano yo dodoga heyaheyayadi. Yo fede sa fatiꞌo lau ana hewahewali lisidi, tiyen, Paꞌana somo be maidana takesi tau tanotano yo tau heyaya sa kalahe? ");
INSERT INTO bxh_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Edi fatiꞌo Yesu ya atahiyen yo fede iyebom, Yau hige ya laoma dodoga dudulaidi adi halulu. Tau heyaya debadi yai E laoma. Tau asiꞌasiyebo doketa sa fanuha. Tau asiꞌasiyebo gesa doketa hige ti fanuha. ");
INSERT INTO bxh_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Diyon Babasito ana hewahewali yo Falesiya sa andabu na Yesu ana hewahewali higeꞌe. Yo fede dodoga haisa sa lau Yesu lisina be sa fatiꞌoi, iyen, Paꞌana somo Diyon Babasito ana hewahewali yo Falesiya adi hewahewali sa andabu? Na um em hige. ");
INSERT INTO bxh_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu alinadi ya bui iyebom, Ami sibai bena taumana ibege ti kalahe fafanahi ganahewana yai? Hige gonowana! Tau nahi fwaufwau maꞌedi ibege ti ginauli doha. ");
INSERT INTO bxh_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","In moho ana lahai ya laolaoma haba tau nahi ni sa lawe-hudoꞌiyen. Lahaina yai ni haba afa haidana sa andabu. ");
INSERT INTO bxh_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Hige hola sai laꞌi kaleko senana fwaufwau i abi be luhuluhu beyabeyana i lau polaꞌen. Paꞌana lau pola fwaufwauna haba ya tanoꞌunoꞌu be kaleko beyabeyana ya eli gigi falaꞌi. ");
INSERT INTO bxh_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Hige hola sai wain fwaufwauna i fagoi lawen ile beyabeyana yai. Paꞌana ile beyabeyana haba ya tamogigi. In moho yena wain fwaufwau ai ile fwaufwau wa fagoi, haba wain yo ile ibege ti heyaya. ");
INSERT INTO bxh_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabati yai Yesu ya lau witi gabuna yai. Tau famuli watanina sa lau watan be witi anꞌandi sa fufudi. ");
INSERT INTO bxh_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Yo fede Falesiya dodogadi sa libalau Yesu lisina tiyen, Am hewahewali hola u itadi! Eda Sabati laugagayona sa utusi. ");
INSERT INTO bxh_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu iyen, Fuyana Deiwidi maꞌana hewahewali sa guliyam, somo sa ginauli? Bukana nuwana hige au fatili? ");
INSERT INTO bxh_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tau Antalasam Baꞌisana Abiyata ena fuya yai, Deiwidi ya lau Yaubada ena Luma yai be fwalawa fafatabuna ana ya an. Eda laugagayo ya libaen mate tau antalasam moho ibodi bena adi sa an. In moho Deiwidi ana hewahewali adi ya feledi sa an. ");
INSERT INTO bxh_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Habahim, Yesu ena liba ya falafusofa iyen, Yaubada Sabati ya ginauli dodoga debadi yai. Hige dodoga i ginaulidi Sabati debana yai. ");
INSERT INTO bxh_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Logena Doga Natuna mate Sabati Guyauna. ");
INSERT INTO bxh_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Fuya hesa Yesu ya fuyo aba oiꞌoigogo lumana ganahewana yai. Amainiya taumoho hesa nima dagedagelona. ");
INSERT INTO bxh_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Dodoga amainiya edi fanuha bena Yesu sa au. Yo fede sa maisimo komakomaniꞌi haba ai Sabati taumoho nima dagedagelona ni ya faloholoho e higeꞌe? ");
INSERT INTO bxh_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu ya libalau doga wa lisina iyen, Ai matamai, u mwaito. ");
INSERT INTO bxh_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Habahim ya fatiꞌo lau dodoga lisidi, iyen, Ai Sabati haba loholoho te ginauli e heyaya te ginauli? Bena doga te famwahuli e te wunui? Hige sai laꞌi alinana i bui. ");
INSERT INTO bxh_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu ya itaꞌita lau lisidi ma manabalana yo nuwana ya heyaya paꞌana sa nuwa poꞌi. Habahim taumoho nima dagedagelona ya faliba iyen, Nimam u lolon. Ya lolon yo fede ya loholoho fuyo. ");
INSERT INTO bxh_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Yo fede feula aba oigogo lumana Falesiya sa lau afulen be sa faꞌoigogo maidadi Heloda ena pele na sa oiliba bena Yesu sa wunui. ");
INSERT INTO bxh_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesu yo tau famuli watanna sa lau Galili Gabogabona na baiwa sa lau watanidi. Somo ouꞌouli ya ginaulidi wasadi sa atahiyedi. Yo fede Diudeya yo Idumeya Nuꞌudi yo Diyodan Tefa Saisaina, Yelusalem, Taya yo Saidon taondi yo nuꞌu hahaisa sadasadai yai, ana baiwa sa tuhuyama. ");
INSERT INTO bxh_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Baiwa ya laꞌi wananaha. Yo fede Yesu tau famuli watanna ya falibadi bena ena waga sa abi nonohai paꞌana tabu ena paisowa ti eli dogodogoi. Dodoga boludi haꞌa ya faloholohodi, debana yai safalumadi sa asiyebo mate sa andudu balabala be sa eliꞌona. ");
INSERT INTO bxh_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Yo hinaga yaluwa heyaheyayadi dodoga ganahewadi yai Yesu sa ita mate sa guli nuwanuwana yai na sa ꞌwalaꞌui tiyen, Um mate Yaubada Natuna! ");
INSERT INTO bxh_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yesu yaluwa heyaheyayadi ya falibadi iyen, Tabu au libalibaegu. ");
INSERT INTO bxh_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu ya lau tuꞌa, na ena fanufanuha dodogadi ya yogaidi be sa laoma lisina. ");
INSERT INTO bxh_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Safuhudohudoꞌi luwaga ya siꞌoꞌinadi be iti sa famala tau faꞌona wasawasa be in maꞌedi na ya duidi be sa guguya. ");
INSERT INTO bxh_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Yo dudulai ya feledi be yaluwa heyaheyayadi sa liba duidi. ");
INSERT INTO bxh_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Safuhudohudoꞌi luwaga ya siꞌoꞌinadi mate hesadi itete: Saimon (Hesana hesa Yesu ya tole, Pita.) ");
INSERT INTO bxh_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Diyemsi yo Diyon iti Sebedi nanatuna luwaga. (Yesu hesadi ya toledi: Bowanegesi. Aniyona mate Palele Nanatuna.) ");
INSERT INTO bxh_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Endulu, Pilipi, Batolomiu, Matiu, Tomasi, Diyemsi, in Alefaiyesi natuna, Tadiyesi, Saimon Seloti, ");
INSERT INTO bxh_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","yo Diudasi Isakaliyoti, in Yesu ana tau wewe. ");
INSERT INTO bxh_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Habahim Yesu ya luhulau luma hesa yai, na baiwa sa faꞌoigogo fuyo be In yo tau famuli watanina hige gonowana ti kalahe. ");
INSERT INTO bxh_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Dodoga sa kawa bwadebwadeꞌen be afa efana wasana sa atahiyen, yo fede sa lau bena sa aulen. ");
INSERT INTO bxh_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Laugagayo tau lau faꞌataenna Yelusalem yai sa laoma tiyen, Yaluwa heyaheyayadi edi baꞌisa, Belesebulu, mate ganahewana yai! Logena gigibwali ya felen be yaluwa heyaheyayadi ya liba duidi. ");
INSERT INTO bxh_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yo fede Yesu ya yogaidima lisina be heyaheyason yai ya falibadi iyebom, Satani haba sidohana falena satani ya liba dui? ");
INSERT INTO bxh_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","25","Yena nuꞌu esega dodogadi sa lulu fuyoꞌidi haba sa failaulauꞌidi yo boga esega yai doha haba hinaga sa failaulauꞌidi. ");
INSERT INTO bxh_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Yena Satani ena nuꞌu ya daili fakiukiu mate ibege i adidili. Haba ya failaulaui. ");
INSERT INTO bxh_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Hige gonowana sai hesa, doga adiꞌadidilina ena luma i lopa be ena ginauli i angafuhidi. Bena ya auꞌaui bwaꞌiyen, habahim ya angafu. ");
INSERT INTO bxh_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","E liba dudulai mate sai heyaya ya ginauli yo sai Yaubada hesana ya liba faheyaya mate edi heyaheyaya ni Yaubada haba ya nuwa afuledi. ");
INSERT INTO bxh_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Na yena sai Yaluwa Tabuna ya liba faheyaya mate hige gonowana heyaheyaya ni i nuwa afulen paꞌana heyaya otaꞌotafahina ya ginauli. ");
INSERT INTO bxh_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Yesu ya liba doha ite paꞌana dodoga haisa sa libaliba tiyen, “In mate yaluwa heyaheyayana ganahewana yai.”) ");
INSERT INTO bxh_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Habahim Yesu tinana yo tatasina sa mahanoma be luma ganamulina yai sa obiꞌobiyo. Wasa sa fatamali lawen ganahewa mate In sa laulau yoꞌoi. ");
INSERT INTO bxh_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Baiwa sa taꞌai fataꞌiꞌili na sa faliba tiyen, Tinam, tatasim yo lolofum sa laulau yoꞌoim. Iti mate ganamuli yai. ");
INSERT INTO bxh_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu alinadi ya bui iyen, Tinagu sai yo tatasigu salumadi? ");
INSERT INTO bxh_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Habahim, ya itaꞌita lau lisidi na iyen, Tinagu yo afa haidagu logedidi itete! ");
INSERT INTO bxh_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yena sai Yaubada ena nuwatuhu ya lau watan mate hidagu, lofugu yo tinagu. ");
INSERT INTO bxh_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu ya lau faꞌata boda gabogabo sadaina yai na baiwa ya laꞌi wananaha, yo fede waga hesa ya poupouli amainiya ya awa lau be ya taꞌai. Na dodoga mate fote yai. ");
INSERT INTO bxh_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Heyaheyason ya fapaisowadi ena lau faꞌata yai be ginauli boludi ya fatalahadi iyen, ");
INSERT INTO bxh_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Au ataꞌatahi! Fuya ma esega doga hesa ya lau be witi tumadi ya lau falili ena gabu yai. ");
INSERT INTO bxh_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Haisa sa beꞌu edaꞌeda yai yo fede ataiꞌa sa laoma be sa anidi. ");
INSERT INTO bxh_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Haisa sa beꞌu tanohi umeꞌumeꞌehuna yai be sa in feufeula. Maihala ya kepama witi wa ya nefadi be sa hohoya paꞌana tanohi ya hebehebe be hige ti abi lam sigi lidi. ");
INSERT INTO bxh_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tuma haisa sa sagigi lidi hawahawa nulinulidi ganahewadi yai be sa in. In moho sa waboꞌidi be hige ti in loholoho yo hige ti fuwa. ");
INSERT INTO bxh_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Haisa mate sa beꞌu tanohi loholohona yai be sa in yo sa fuwa loholoho be haisa tumadi naunaudi na haisa sa duliduli. ");
INSERT INTO bxh_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ofiꞌofina, Yesu iyen, Au ataꞌatahi komakoman! ");
INSERT INTO bxh_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu iyabona na tau ataꞌatahi haisa maidadi safuhudohudoꞌi luwaga sa laoma be Yesu sa fatiꞌoi tiyen, Heyaheyason aniyodi haga ema u liba? ");
INSERT INTO bxh_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu ya falibadi iyen, Yaubada Aba Baꞌisa libana simosimona mate haꞌa E falibamiu. Na dodoga haisa mate heyaheyason yai sa atahiyen. ");
INSERT INTO bxh_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","“Haba sa ita na in moho ibege ti ita lobahi; haba sa ataꞌatahi na in moho ibege ti nuwatuhu lobahi. Ibe moho nuwadi sa buidi haba edi heyaheyaya ya nuwa afuledi.” ");
INSERT INTO bxh_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Habahim Yesu ya fatiꞌoidi iyen, Yena heyaheyason te hige au sibai mate haba haisa sidohana emi sibasibaidi? ");
INSERT INTO bxh_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tau falili mate Yaubada ena wasa tau umahina. ");
INSERT INTO bxh_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Dodoga haisa itaꞌitadi doha tuma edaꞌeda yai. Wasa sa atahiyen yo fede Diyabolo ya laoma be libana nuwadi yai ya abi fahi. ");
INSERT INTO bxh_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Dodoga haisa iti doha tuma sa beꞌu lidi tanohi umeꞌumeꞌehuna yai. Wasa sa atahiyen yo fede sa abi ma nuwa amnadi. ");
INSERT INTO bxh_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","In moho hige i abi lam nuwadi yai be hige i ota lofalofa. Yena pilipili e kamkamna sa laoma wasa ni debana yai feula na sa muli suhasuha. ");
INSERT INTO bxh_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Na dodoga haisa doha tuma sa in hawahawa nulinulidi ubudi yai. Iti logedidi wasa tau atahiyenna. ");
INSERT INTO bxh_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","In moho: mode hudoꞌi - hudoꞌi, bena sa fagogo, yo fanufanuha haisa nuwadi sa famohafudi. Yo fede wasa sa eli bulubuluhi be hige ti fuwa. ");
INSERT INTO bxh_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Dodoga haisa mate doha witi tumadi sa falili tanohi loholohona yai. Wasa sa atahiyen yo fede sa lau watan be uludi sa toledi. Haisa naunaudi na haisa sa duliduli. ");
INSERT INTO bxh_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu hinaga ya liba iyen, Yena lampa wa gabu haba ai gulewa wa fakou e ai aba eno ubuna wa tole? Higeꞌe! Haba ai mahata wa tole. ");
INSERT INTO bxh_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ginauli simosimodi haba sa taumahata na somo sa fakou haba bubulina sa kamfahi. ");
INSERT INTO bxh_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Fafabeyamiu, au ataꞌatahi komakoman! ");
INSERT INTO bxh_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yo ya falibadi hinaga iyen, Somo ami atahi mate au fadosi komakomaniꞌi! Lufa laꞌina somo wa fapaisowa haba gonogonowana ai lisim sa fapaisowa e haba ya diꞌoi. ");
INSERT INTO bxh_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yena sai somo lisina yai mate Yaubada haba ya falaꞌi. Na sai higeꞌe mate somo begana lisina yai hinaga haba ya kamfahi. ");
INSERT INTO bxh_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu ya liba fuyo iyen, Yaubada Aba Baꞌisa itaꞌitana doha taumoho hesa tuma ya lau falili gabu yai. ");
INSERT INTO bxh_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Lahai fisa mulidi yai tuma wa ya in. In moho sidohana ena inꞌin yo ena laꞌilaꞌi hige i sibai. ");
INSERT INTO bxh_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tanohi iyabona tuma wa ya faꞌin be ya fuwa. Bwaꞌibwaꞌina mate atipuna bigabigana ya taumahata, habahim ya taya be tumana ya toledi. ");
INSERT INTO bxh_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ya anaho be ya tomo. ");
INSERT INTO bxh_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu ya falibadi iyebom, Yaubada Aba Baꞌisa doha somo? Heyaheyason somo haba te fapaisowa be te fatau gonogonowa? ");
INSERT INTO bxh_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Itaꞌitana doha ite: Taumoho hudoꞌi umaꞌuma hesa tumana kiukiu wananaha ya umahi. ");
INSERT INTO bxh_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Hige walolona ya in, be gabu anꞌandi haisa ya tubu famulidi na ataiꞌa sa lofoma be lagadi logulogudi yai edi nohi sa ginaulidi. ");
INSERT INTO bxh_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Heyaheyason boludi doha itete Yesu ya fapaisowadi be dodoga enehedi ya dede, be haba gonowana sa nuwatuhu lobahidi. ");
INSERT INTO bxh_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Heyaheyason yai moho ya falibadi na yena iyabodi mate aniyodi ya dede famahatadi tau famuli watanna lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Maimailafina Yesu tau famuli watanina ya falibadi iyen, Haga ta lau gabogabo tefana. ");
INSERT INTO bxh_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Waga haisa amainiya hinaga. Tau famuli watanina baiwa sa lau afuledi, na sa awa lau Yesu ena aba taꞌataꞌai wagana yai be sa lau tefa. ");
INSERT INTO bxh_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Hige walolona hwayahwayau adiꞌadidilina ya towa be bagodu sa hin diꞌo. Begana haba waga sa famohafu. ");
INSERT INTO bxh_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu ya eno unuwa yai waga mulina yai. Tau famuli watanina sa fanohi tiyen, Tanuwaga! Haba te peꞌi. Sidohana hige u mode? ");
INSERT INTO bxh_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu ya obiyo be ya liba adidili lau hwayahwayau yo bagodu lisidi iyen, Au fatautau! Yo fede hwayahwayau ya towa motu na ya daumwali fuyo. ");
INSERT INTO bxh_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Habahim Yesu ya falibadi iyebom, Sidohana be ami ꞌwasabu? Emi sunuma, e higeꞌe? ");
INSERT INTO bxh_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","In moho sa ꞌwasabu wananaha be sa famoꞌa libaliba tiyen, Sai itete? Hwayahwayau yo bagodu ena liba sa lau watan! ");
INSERT INTO bxh_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Galili Gabogabona yai sa dohe be Gelasa nuꞌuna yai sa duna. ");
INSERT INTO bxh_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu ya tulubeꞌu na taumoho hudoꞌi yaluwa heyaheyayadi ganahewana yai ya laoma. Bwana yai ya kalamahano be ya laoma Yesu lisina. ");
INSERT INTO bxh_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","In mate duyufi atiꞌatipudi yai ya gogogo. Hige gonowana sai i faseni bodai. ");
INSERT INTO bxh_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Fuya ouꞌouli nimana yo ahena sa fasenidi in moho seni ya eli motudi yo powati ahena yai ya dem pwaipwaidi. Hige gonowana sai i abi famamayo. ");
INSERT INTO bxh_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Lahai yo iꞌipa ya laulau gaibu ai bwana yo ai tuꞌa. Ya ꞌwalaꞌwalawui yo tauna ya anseseidi ai umeꞌehu senadi. ");
INSERT INTO bxh_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yesu hola ya laolaoma na dogana ya itaꞌita lau be ya ita yo fede ya fabelele be nuwanuwana yai ya tulibono. ");
INSERT INTO bxh_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Habahim ya liba laꞌilaꞌi iyen, Yesu, Hewa Wananaha Yaubadana Natuna! Somo lisigu yai wa fanuha? E anꞌetaim Yaubada hesana yai, tabu u fakamkamnagu! ");
INSERT INTO bxh_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Ya liba doha paꞌana Yesu iyen, “Yaluwa heyaheyayadi doga ni au lau afulen!”) ");
INSERT INTO bxh_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yo fede Yesu ya fatiꞌo lau lisina iyen, Hesam somo? Taumoho iyen, Hesagu “Baiwa–,” ꞌe ouli wananaha! ");
INSERT INTO bxh_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ya anꞌeta lau Yesu lebena tabu yaluwa heyaheyayadi ai nuꞌu ni i lau weꞌaidi. ");
INSERT INTO bxh_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na sadai yai mate salai baiwadi sa suwasuwali daha sadaina yai. ");
INSERT INTO bxh_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Yo fede yaluwa heyaheyayadi Yesu sa anꞌetai tiyen, Aee–, u fatamalimai ai lau salai ai ganahewadi ai miya. ");
INSERT INTO bxh_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yo fede Yesu ya duidi be sa kalamahano na sa lau salai baiwadi doha 2,000 sa luhufidi. Salai sa leta kokoli daha yai be sa dago lidi hoꞌowa yai. Yo fede sa kapulolo. ");
INSERT INTO bxh_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Salai tau itaꞌita watanidi sa gela be sa lau sa fatala libalibaen taon yai yo mulimulina nuꞌudi yai be dodoga sa laoma somo ya tubu sa ita. ");
INSERT INTO bxh_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sa mahanoma Yesu lisina, taumoho wa uluna ya dudulai. Kaleko ya liꞌo, na ya taꞌataꞌai sa ita. Yo fede mahudoꞌidi sa ꞌwasabu. ");
INSERT INTO bxh_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Somo ya tubu taumoho ni yo salai lisidi yai salumadi sa ita, mate dodoga edi sa liba. ");
INSERT INTO bxh_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Yo fede Yesu sa faliba tiyen, Aee–, ema nuꞌu u lau afulen! ");
INSERT INTO bxh_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Waga yai Yesu ya awa na doga ya faloholoho wa ya libalau lisina iyen, Aee–, Yesu, bena E lau watanim! ");
INSERT INTO bxh_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yo fede alinana, Yesu ya bui iyen, Hige gonowana! U fuyo em luma yo am boga lisidi be Guyau ena nuwatohatoha lisim yai yo somo ya ginauli lebem yai enehedi u liba. ");
INSERT INTO bxh_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yo fede doga wa ya aulaha ya lau Dekapolisi Nuꞌuna yai be somo Yesu ya ginauli lisina yai ya falibadi. Salumadi sa atahiyen mate sa noꞌo. ");
INSERT INTO bxh_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Waga yai Yesu sa dohe be sa mahano yo fede baiwa sa faꞌoigogon. ");
INSERT INTO bxh_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Aba oiꞌoigogo baꞌisana hesana Diyailusi ya mahanoma Yesu ya ita yo fede ya hoba lidi ahena yai. ");
INSERT INTO bxh_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ya anꞌeta gadogadola lau lisina iyen, Natugu waiwaihin mate nuꞌanuꞌana. Te lau be wa abilau ai tauna haba ya loholoho! ");
INSERT INTO bxh_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yo fede Diyailusi maꞌena Yesu sa lau. Dodoga mate sa faipapipapi na sa laulau watanidi. ");
INSERT INTO bxh_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Waihin hesa ana asiyebo mate ꞌwasina ya miyamiya afulen ee–, bolima safuhudohudoꞌi luwaga. ");
INSERT INTO bxh_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Doketa boludi fuya lofalofa edi mulamula yai sa fafakamkamna. Ena moni mahudoꞌina ya pei faꞌofi bena haba loholoho ya lobahi. In moho ana asiyebo ya fafalaꞌi. ");
INSERT INTO bxh_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Yesu wasana waihin wa ya atahiyen be nuwana yai iyen, Ibe ana luhuluhu moho E abiꞌona haba E loholoho. Yo fede Yesu mulina yai ya laoma be dodoga pwaludi yai ya andudu balabala be ana luhuluhu ya abiꞌona. ");
INSERT INTO bxh_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Amna ya atahi mate ꞌwasina ya miyamiya afulen ya fatautau yo ena kamkamna wa ya ofi. ");
INSERT INTO bxh_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu amna ya abi mate gigibwali ya lau afulen. Yo fede baiwa ganahewadi yai ya timuli bui be ya fatiꞌo iyen, Sai agu luhuluhu ya abiꞌina? ");
INSERT INTO bxh_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tau anpate alinana sa bui tiyen, Baiwa haꞌa wa ita, na sidohana be uwen, “Sai ya abiꞌinagu?” ");
INSERT INTO bxh_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yo fede Yesu ya itaꞌita asiꞌasi be tau abiꞌinana ya yoꞌoi. ");
INSERT INTO bxh_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Waihin asiꞌasiyebona somo lisina yai ya tubu ya sibai yo fede ma ꞌwasabuna ya laoma be ya tulibono ahena yai na ya faliba dudulain. ");
INSERT INTO bxh_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu iyen, Natugu, nuwam i amna! Em kawawananaha debana yai asiyebona ni, ibege u abi fuyoi. ");
INSERT INTO bxh_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu hola waihin asiꞌasiyebona ya fafaliba na Diyailusi ena luma yai dodoga sa laoma be aba oigogo baꞌisana sa faliba tiyen, Natum haꞌa ya peꞌi. Tabu u modemode lau tanuwaga lisina. ");
INSERT INTO bxh_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Sa libaliba, Yesu ya atahi yo fede iyen, Tabu u ꞌwasabu! U kawawananaha moho. ");
INSERT INTO bxh_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Diyemsi ma hidana Diyon yo Pita iyabodi maꞌedi Yesu sa lau, na hige sai hesa. ");
INSERT INTO bxh_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Sa mahano lau Diyailusi ena luma yai, bobohalahala yo tan sa atahi. ");
INSERT INTO bxh_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ya luhulau luma yai be ya falibadi iyen, Bobohalahala yo tan te sidohana? Tineꞌeu ni hige i peꞌi. Mate ya eno! ");
INSERT INTO bxh_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yo fede sa liuhwaꞌen. Habahim mahudoꞌidi ya duidi sa lau ganamuli. Na tamana, tinana yo tau famuli watanna faihona ya auledi be sa lau tineꞌeu edi aba tolena bilina yai. ");
INSERT INTO bxh_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ya abilau nimana yai na ya faliba iyen, Talita, koum! (Aniyona mate, “Tineꞌeu kiukiu, E falibam, ‘U obiyo!”) ");
INSERT INTO bxh_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Hige walolona na ya laulau tiga. (Ena bolima mate 12). Laulau te debana yai edi noꞌo sa ofi. ");
INSERT INTO bxh_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu ya laugagayoꞌedi tabu sai, ena ti liba, yo ya falibadi bena sa fakalahe. ");
INSERT INTO bxh_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Galili nuꞌuna Yesu ya lau afulen na ya fuyo ena nuꞌu wananahana, Nasaleta. Yo fede ana hewahewali sa lau watan. ");
INSERT INTO bxh_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabati yai ya lau faꞌata Diusi edi aba oiꞌoigogo lumana yai. Yo fede dodoga boludi sa noꞌo. Na tiyen, Libadi te sai lisina yai ya sana taluhidi? Sibasiba sai ya felen be noꞌo abiꞌabidi ya lau ginauli? ");
INSERT INTO bxh_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","In luma tau laulau ginauli, yo Maliya natuna! Tatasina mate: Diyemsi, Diyosepa, Diuda yo Saimon. Lolofuna mate maidada te miyamiya. Logena, ena nuꞌu dodogadi sa ꞌwaiyoꞌoꞌen. ");
INSERT INTO bxh_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu ya falibadi iyen, Peloweta nuꞌu mahudoꞌina yai sa faꞌatitiyen. In moho ena nuꞌu dodogadi yo afa efana yo ana boga mate sa ꞌwaiyoꞌoꞌen. ");
INSERT INTO bxh_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Hige gonowana noꞌo abiꞌabidi laꞌi i ginauli ainiya. Tau lepalepa fisa moho nimana ya tole lawedi hewadi yai be sa loholoho. ");
INSERT INTO bxh_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yo fede ya famala Yesu ena tauhiti paꞌana hige edi sunuma. Maleko 6:6b-13 Yesu ya taꞌiꞌili nuꞌu hesa - hesa be dodoga ya faꞌatadi. ");
INSERT INTO bxh_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tau faꞌona wasawasa 12 ya yoga gogonidima be dudulai ya feledi bena yaluwa heyaheyayadi sa liba duidi. Yo fede luwaga - luwaga ya fatamalidi. ");
INSERT INTO bxh_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ya laugagayodi iyen, Ami lau, tabu somo hesa au abi. Tuꞌe moho, tabu kalahe, tobo e moni. ");
INSERT INTO bxh_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sendolo au awai na tabu luhuluhu hesa au abi. ");
INSERT INTO bxh_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ya falibadi hinaga iyen, Somo yai sa yoga hitinimiu, ai lumana ami gogo ee–, ami aulaha boda. ");
INSERT INTO bxh_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Yena ami mahano ai taon hesa na dodoga hige ti yoga hitinimiu e emi liba hige ti atahiyen nuꞌuna ni au lau afulen. Ahemiu afusadi au oi luhiluhidi, haba ya famala edi heyaya aba ita lobahina. ");
INSERT INTO bxh_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Habahim ya falibadi be sa lau dodoga sa guguyaidi na bena sa nuwabui. ");
INSERT INTO bxh_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yaluwa heyaheyayadi sa liba duidi yo tau asiꞌasiyebo oliwe masina yai sa famaꞌidi be sa loholoho. ");
INSERT INTO bxh_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kin Heloda liba te ya atahiyen paꞌana Yesu hesana ya tadada nuꞌu ouꞌouli yai yo fede haisa tiyen, Diyon Babasito ya mwahuli fuyo logena gigibwali te ya abi be fafaꞌilala ya lau ginauli. ");
INSERT INTO bxh_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Haisa hinaga tiyen, In Ilaidiya. Na haisa tiyen, In doha peloweta haisa bwaꞌibwaꞌidi. ");
INSERT INTO bxh_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kin Heloda wasa ya atahiyen yo fede iyen, Diyon Babasito gadona haꞌa E ibo, mate ya mwahuli fuyo! ");
INSERT INTO bxh_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Ena fafatubu doha ite: Diyon Babasito Heloda ya fafaliba iyen, Hige i dudulai bena hidam lahuna Helodiya u kamofahi! Yo fede, Kin Heloda ya liba be Diyon sa faseni be sa falau deli. ");
INSERT INTO bxh_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Helodiya ya manabala Diyon lisina yai be bena ya wunui, in moho hige gonowana. ");
INSERT INTO bxh_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kin wa Diyon ya ꞌwasabuwen be ya bobodiyen. Ya sibai mate in doga dudulaina yo fatabu dogana. Diyon ena liba ya fanuha wananahaidi. In moho nuwana ya faiꞌabi paꞌana ponoli haꞌa ya ginauli. ");
INSERT INTO bxh_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Fuya hesa lahuna Helodiya ena solasola ya lobahi mate Heloda ena fuya tubu nawalahina yai. Yo fede anꞌangogo ya ginauli be gabeman laꞌilaꞌidi, hiyala babaꞌisadi yo Galili tefadi babadadi ya yoga gogoidima. ");
INSERT INTO bxh_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Helodiya natuna waihin ya laoma edi ya leꞌi, be Heloda yo ana taumana nuwadi sa amna. Yo fede baꞌisa wa tineꞌeu ya faliba iyen, Somo wa fanuha haba E felem. ");
INSERT INTO bxh_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ya liba dudulai tineꞌeu lisina yai iyen, E angwala mate yena em fanuha somo wa libaen haba E felem. Yena uwen, em nuꞌu tefana u daili be u felegu, mate gonowana! ");
INSERT INTO bxh_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Yo fede tineꞌeu wa ya lau tinana ya fatiꞌoi iyen, Tinagu somo haba E anꞌetai? Tinana alinana ya bui iyen, Diyon Babasito kuluna u anꞌetai. ");
INSERT INTO bxh_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tineꞌeu wa ya fabelele ya fuyo baꞌisa lisina be iyen, E fanuha bena aho te, Diyon Babasito kuluna ai gaeba wa felegu! ");
INSERT INTO bxh_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kin nuwana ya heyaya, in moho hige gonowana ena nuwatuhu i ꞌwaiyoꞌoꞌen paꞌana ena angwala haꞌa ya ginaulidi ana taumana matadi yai. ");
INSERT INTO bxh_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Yo fede gati hesa ya fatamali ya lau deli yai be Diyon gadona ya ibo motu, ");
INSERT INTO bxh_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","habahim gaeba yai kuluna ya abiyama be tineꞌeu ya felen. Na ya lawen be tinana ya felen. ");
INSERT INTO bxh_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wasana sa atahiyen be ana hewahewali sa lau silanna sa abi be sa boꞌusai. ");
INSERT INTO bxh_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tau faꞌona wasawasa sa fuyoma be maꞌedi Yesu sa faꞌoigogo be somo sa ginaulidi yo edi lau faꞌata wasadi ena sa liba. ");
INSERT INTO bxh_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yesu maꞌana hewahewali hige edi solasola haba ti kalahe paꞌana dodoga boludi sa lau yo sa laoma. Yo fede iyebom, Ta lau nuꞌu laulau gesa yai, be ainiya au anyawasi. ");
INSERT INTO bxh_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yo fede waga yai sa awa modigafu na sa lau atiꞌatipu hesa yai. ");
INSERT INTO bxh_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","In moho dodoga boludi sa ita lobahidi be taon mahudoꞌidi yai sa tafo bwaꞌibwaꞌi be sa mahano bwaꞌi. ");
INSERT INTO bxh_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Waga ya mahano Yesu ya tulubeꞌu yo fede baiwa ya itadi be ya nuwatohatohaedi. Paꞌana itaꞌitadi doha sipi hige tau ita watanidi na sa laulau koko. Logena ginauli boludi ya fatubu ya fatalahadi. ");
INSERT INTO bxh_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ya maimailafi yo fede tau famuli watanina sa laoma lisina be tiyen, Ita itete balabala gaibu yai. ");
INSERT INTO bxh_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Dodoga te u duidi ti lau nuꞌu mulimulina yai kalahe adi ti unedi. ");
INSERT INTO bxh_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Na Yesu alinadi ya bui iyebom, Umi kalahe au feledi. Tiyen, Wa fanuha bena siluba handele luwaga ꞌe abidi be fwalawa ꞌe unedi na ꞌe fakalahedi? ");
INSERT INTO bxh_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yo fede Yesu ya fatiꞌoidi iyen, Fwalawa fisa? Haga au lau au yoꞌo. Sa yoꞌo be sa fuyoma tiyen, Fwalawa faligigi yo hama luwaga. ");
INSERT INTO bxh_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesu ya libalau tau famuli watanina lisidi iyen Dodoga au falibadi, be ti taꞌai pwalupwaluidi ai hawahawa. ");
INSERT INTO bxh_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Yo fede haisa oulidi 100 sa taꞌai, na haisa oulidi 50. ");
INSERT INTO bxh_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Habahim Yesu fwalawa faligigi yo hama luwaga ya abidi na ya itaꞌita hasa galewa na ya faloholohodi. Fwalawa ya ifidi, na hama luwaga ya kampwaidi be tau famuli watanina ya feledi sa soiyedi dodoga mahudoꞌidi lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mahudoꞌidi sa kalahe be bogadi sa yahayaha. ");
INSERT INTO bxh_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Habahim tau famuli watanina fwalawa yo hama antoledi sa tano gogoidi be noho 12 sa famohafudi. ");
INSERT INTO bxh_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tatau sa fakalahedi ouꞌoulidi 5,000. ");
INSERT INTO bxh_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yesu tau famuli watanina ya duidi be feula waga yai sa awa na sa dohe Betesaida. Na muli yai baiwa ya duidi. ");
INSERT INTO bxh_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ya lautoꞌiyedi mulina yai, ya finahe hasa tuꞌa yai be ya lauꞌuꞌula. ");
INSERT INTO bxh_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Toutou bulu yai mate waga haꞌa gabogabo atipuna yai, na Yesu mate iyabona fote yai. ");
INSERT INTO bxh_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tau famuli watanina ya itadi mate sa fulufuluga afuledi bena waga sa lefaꞌen paꞌana hwayau sa tulu matai. Hola hige i ifi tatatali, gabogabo hewana yai ya lau lisidi. Bena ya bayawaidi, ");
INSERT INTO bxh_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","na sa itaꞌita lau be sa ita gabogabo hewana yai ya laulau. Edi nuwatuhu bena haga onaꞌonaha, be sa ꞌwalaꞌwalaui. ");
INSERT INTO bxh_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Mahudoꞌidi sa ita be sa ꞌwasabu wananaha. Yo fede Yesu ya libalau lisidi iyebom, Nuwamiu ti adidili! Tabu au ꞌwasabu, Yau! ");
INSERT INTO bxh_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yo fede ya awalau waga yai na hwayahwayau ya towa motu. Tau famuli watanina edi noꞌo sa ofi. ");
INSERT INTO bxh_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nuwadi sa lau fabui homodi, paꞌana 5,000 ya fakalahedi aniyona wananahana hige ti nuwatu lobahi. ");
INSERT INTO bxh_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Sa dohe Genesaleta nuꞌuna yai, amainiya edi waga sa ankai. ");
INSERT INTO bxh_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sa tulubeꞌu, yo fede dodoga Yesu sa ita lobahi. ");
INSERT INTO bxh_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Wasana sa atahiyen in somo yai, mate feula sa lau nuꞌu ouꞌouli yai be tau asiꞌasiyebo edi aba laulau eno yai sa baheidima lisina. ");
INSERT INTO bxh_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yena Yesu ya lau luma yai e taon yai e nuꞌu mulimulidi yai, tau asiꞌasiyebo sa lawedi maketi yai be sa anꞌetai bena ena leli duduna moho sa abiꞌina. Salumadi ena leli sa abiꞌina mate sa loholoho. ");
INSERT INTO bxh_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Falesiya yo laugagayo tau lau faꞌataenna hahaisa Yelusalem yai sa laoma be sa faꞌoigogo Yesu lisina yai. ");
INSERT INTO bxh_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yesu tau famuli watanina haisa sa kalakalahe ma nima bidabidadi. Falesiya sa ita faheyayadi paꞌana edi laulau hige ti falau watan. ");
INSERT INTO bxh_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Falesiya yo Diusi mahudoꞌidi ibege ti kalahe gaibu, yena afa wahawahadi edi laulau sa laulauwedi be nimadi sa kaisudi, mate haba sa kalahe. ");
INSERT INTO bxh_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Yena ai maketi sa fuyoma edi abiꞌabi sa falau watan be nimadi sa kaisudi, haba sa kalahe. Yo kaputi, gulewa, gaeba yo aba kalakalahe ginaulidi bena sa kaisudi. ");
INSERT INTO bxh_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yo fede Falesiya yo laugagayo tau lau faꞌataenidi Yesu sa fatiꞌoi tiyen, Sidohana be tau famuli watanim hige wahawahada edi laulau ti lau watanidi na ma nima bidabidadi sa kalahe? ");
INSERT INTO bxh_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu alinadi ya bui iyen, Umi dodoga bwalabwalamiu! Isaiya ya liba dudulai fuyana ya libaemiu, ena uliꞌuli yai iyebom, “Yaubada, iyen, ‘Nuwa maitimiu yai Guyau ami fadebasae. ");
INSERT INTO bxh_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yo ita eda laugagayo moho dodoga ami fatalahadi!” ");
INSERT INTO bxh_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yaubada ena laugagayo ami tole hudoꞌiyedi na dodoga edi lau faꞌata ami lau watanidi. ");
INSERT INTO bxh_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu ya falibadi iyen, Yaubada ena laugagayo ami ꞌwaiyoꞌoꞌen, na emi lau faꞌata bena ami lau watanidi. Hige i loholoho! ");
INSERT INTO bxh_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Yo fede Mose ya falaugagayodi iyen, “Tamam yo tinam u faꞌatitiyedi. Yena sai tinana e tamana ya liba faheyayadi dogana bena sa wunui.” ");
INSERT INTO bxh_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","In moho emi lau faꞌata yai auwen, “Yena sai hige i fanuha bena tinana e tamana i saguhidi haba ena aba anfale ya libaen iyen, ‘Ite Koban (aniyona mate Yaubada ena ainauya), be tamana yo tinana ibege i saguhidi.” ");
INSERT INTO bxh_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Laulaudi te debadi yai Yaubada ena liba ami kaiwegowegogoꞌen paꞌana abiꞌabi ouꞌouli ami ginaulidi doha itete, be emi lau faꞌata ami fapaisowadi dodoga lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu, baiwa ya yoga fafuyodima lisina be iyen, Mahudoꞌimiu, au ataꞌatahi haba ami sibai, ");
INSERT INTO bxh_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","kalahe ami an, ibege i fabidahemiu. Na liba heyaheyayadi moꞌamiu yai ami libalibaedi mate iti logedidi haba sa fabidahemiu. ");
INSERT INTO bxh_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Au ataꞌatahi komakoman! ");
INSERT INTO bxh_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Baiwa ya lau afulen, na ya lau luma ganahewana habahim tau famuli watanina heyaheyasonna te aniyona sa fatiꞌoi. ");
INSERT INTO bxh_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu alinadi ya bui iyen, Umi hola ma nuwa supusupumiu! Sidohana be hige au nuwatuhu lobahi? Hige somo ganamuli yai i luhulau doga ganahewana haba i fabida, ");
INSERT INTO bxh_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","paꞌana ya lau boga yai moho be ya kalamahano fuyo. Hige i luhulau nuwanuwana. (Liba te debana yai Yesu iyen, “Kalahe mahudoꞌidi ibege ti fabidaheda.”) ");
INSERT INTO bxh_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Na hinaga ya liba iyen, Somo doga ganahewana yai ya hala liwaꞌen mate logena ya fabida. ");
INSERT INTO bxh_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Paꞌana doga nuwana ganahewana yai, be nuwatuhu heyaheyayadi sa kalamahano doha: nuwatuhu heyaheyayadi, luma gwaꞌu hudoꞌi - hudoꞌi, angafu, aiyunu, doga hesa lahuna maꞌena sa luma gwaꞌu, ");
INSERT INTO bxh_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","anduma, laulau heyaheyaya, laulau bwalabwala, luma gwaꞌu nuwanuwatuhudi, nuwa elaꞌela, lau mwanunu, nuwa saesae, yo nuwatuhu yauyaule–, ");
INSERT INTO bxh_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ginauli heyaheyayadi mahudoꞌidi te, mate ganahewadi yai sa laoma be sa fabidaheda. ");
INSERT INTO bxh_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Galili nuꞌuna Yesu ya lau afulen na ya leu Taya nuꞌuna. Ya mahano lau mate ya lau luma hesa ganahewana paꞌana hige i fanuha bena sai i sibai mate in amainiya. In moho hige gonowana i miya alasimo. ");
INSERT INTO bxh_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Yaluwa heyaheyayana mate waihin hesa, natuna waihin ganahewana yai. Waihin wasa ya atahiyen mate Yesu ya laoma, yo fede ya lau be ya hoba lidi ahena yai. ");
INSERT INTO bxh_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","In mate Giliki Waihinina Fonika Nuꞌuna yai ya tubu, Siliya ganahewana yai. Yesu ya anꞌetai bena yaluwa heyaheyayana natuna ganahewana yai ya liba dui. ");
INSERT INTO bxh_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yo fede Yesu iyen, Hola wawaya ti kalahe bwaꞌi! Hige i loholoho bena wawaya adi kalahe ta peidi be ꞌwayowa ti anidi. ");
INSERT INTO bxh_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Waihin Yesu alinana ya bui, iyen, Baꞌisa, wawaya adi mapula tebolo ubuna yai haba ꞌwayowa sa anidi! ");
INSERT INTO bxh_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yo fede Yesu ya libalau waihin lisina iyen, Em bui ni debana yai u fuyo em luma, haba wa fawananaha mate yaluwa heyaheyayana natum ganahewana yai haꞌa ya kalamahano. ");
INSERT INTO bxh_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ya mahano fuyo mate natuna ena aba laulau eno yai Yaluwa heyayana haꞌa ya lau afulen. ");
INSERT INTO bxh_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Taya Nuꞌuna Yesu ya lau afulen na ya lau Sidon be Dekapolisi edaꞌedana ya lau watan ya lau Galili Gabogabona. ");
INSERT INTO bxh_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Amainiya taumoho hudoꞌi beya tuituina yo libaliba gesana dodoga sa leyama lisina. Yesu sa anꞌetai bena nimana ya tole lawen ai hewana. ");
INSERT INTO bxh_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yo fede dodoga pwaludi yai, ya foya hudoꞌiyen be nimana gigidi ya tole lawedi beya sogona yai. Habahim ya kaniso na ya abilau lelona yai. ");
INSERT INTO bxh_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Na Yesu ya itaꞌita hasa galewa yo fede ya nahasi iyen, Haa–, Efata! (Diusi alinadi yai, aniyona mate “Beyam ti taꞌafasi!”) ");
INSERT INTO bxh_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yo fede taumoho wa beyana sa taꞌafasi yo liba ya libaedi mate sa dudulai. ");
INSERT INTO bxh_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Muliyai Yesu dodoga ya falibadi iyen, Tabu au fatala libalibaen. In moho sa fatala libalibaen. ");
INSERT INTO bxh_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Salumadi sa atahiyen sa noꞌo wananaha tiyen, Somo mahudoꞌina ya ginauli sa loholoho! In gonowana tau beya tuitui ya faloholohodi be beyadi sa taꞌafasi yo tau libaliba gesa sa libaliba! ");
INSERT INTO bxh_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Lahaidi yai ni baiwa hesa ya faꞌoigogoma, mate hige adi kalahe. Yo fede Yesu ana hewahewali ya yogaidima na iyen, ");
INSERT INTO bxh_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Dodoga te, E fanuwatohatohaedi, na adi kalahe sa ofi, paꞌana lahai faihona ma afa haidagu. ");
INSERT INTO bxh_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yena E duidi sa lau edi luma ma guliyamdi haba matadi sa kwadekwade ai edaꞌeda paꞌana haisa adi eda sa lofa. ");
INSERT INTO bxh_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tau famuli watanina sa fatiꞌo tiyen, Ai malatupwam te haba ai somo kalahe te lobahi be te fakalahedi? ");
INSERT INTO bxh_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu ya fatiꞌoidi iyen, Fwalawa fisa lebemiu yai? Alinana sa bui tiyen, Faligigi luwaga moho. ");
INSERT INTO bxh_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Dodoga ya falibadi be sa taꞌai tanohi yai. Habahim fwalawa faligigi luwaga ya abidi na Yaubada ya lautoꞌiyen. Ya ifidi na tau famuli watanina ya feledi be sa soiyedi baiwa lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Hama fisa Yesu ya abidi na Yaubada ya lautoꞌiyen be tau famuli watanina ya feledi sa soiyedi hinaga. ");
INSERT INTO bxh_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Mahudoꞌidi sa kalahe be bogadi sa yahayaha. Ouꞌoulidi doha 4,000. Adi antole sa tanogogondi be noho faligigi luwaga sa famohafudi. Habahim Yesu ya duidi be sa lau. ");
INSERT INTO bxh_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Na maꞌana hewahewali waga yai sa lau Dalamanuta nuꞌuna. ");
INSERT INTO bxh_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Falesiya edi fanuha bena Yesu sa fasai buluhi yo fede sa laoma be sa fatiꞌoi bena galewa fafaꞌilalana ya faꞌitadi. ");
INSERT INTO bxh_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yo fede Yesu ya nahasi na iyebom, Sidohana be hiti te ami fanuha bena fafaꞌilala E ginauli be ami ita? E faliba dudulaimiu mate ibege laꞌi ya ginauli. ");
INSERT INTO bxh_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yo fede ya lau afuledi na ya awa waga yai be sa lau gabogabo tefana. ");
INSERT INTO bxh_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tau famuli watanina nuwadi sa fui be hige fwalawa adi ti abi faꞌouli. Esega dumaduma mate waga yai. ");
INSERT INTO bxh_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu ya falibadi iyen, Au ita komakoman! Falesiya yo Heloda adi yisti ibe au abi. ");
INSERT INTO bxh_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Liba wa ibodi sa fafadosi tiyen, Nuwana fwalawa hige laꞌi ta abi, logena ya liba doha. ");
INSERT INTO bxh_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Edi nuwanuwatuhu, mate Yesu haꞌa ya sibai yo fede ya fatiꞌoidi iyen, Paꞌana somo ami liba auwen, “Hige ama fwalawa?” Hige somo au nuwatuhu lobahi, Nuwanuwamiu sa poꞌi?! ");
INSERT INTO bxh_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Matamiu yo beyamiu na hige hola somo au ita yo au atahi lobahi. Nuwamiu sa fui ");
INSERT INTO bxh_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Fuyana fwalawa faligigi E ifidi dodoga 5,000 adi, anꞌan otafahidi ami tanogogo mate noho fisa ami famohafudi? Alinana sa bui tiyen, Noho safuhudohudoꞌi luwaga. ");
INSERT INTO bxh_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Na Yesu ya fatiꞌo boda iyen, Fuyana fwalawa faligigi luwaga E ifidi dodoga 4,000 adi, mate antoledi ami tano gogoidi be noho fisa ami famohafudi? Alinana sa bui tiyen, Noho faligigi luwaga. ");
INSERT INTO bxh_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yo fede Yesu ya fatiꞌoidi iyen, Na sidohana be hige au nuwatuhu lobahi? ");
INSERT INTO bxh_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Betesaida nuꞌuna yai sa laoma yo fede dodoga haisa amainiya taumoho mata toutouna sa leyama Yesu lisina be sa anꞌetai bena ya abiꞌina. ");
INSERT INTO bxh_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu taumoho wa ya abi nimai be ya foya hudoꞌiyen tefa hesa yai. Matana ya kanisoidi, na muli yai ya abilau tauna yai na iyen, Somo laꞌi wa ita, e higeꞌe? ");
INSERT INTO bxh_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Taumoho wa ya itaꞌita hasa na iyen, Ii–, dodoga E itadi doha oyagi sa laulau tiga. ");
INSERT INTO bxh_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu nimana ya tole fuyoi taumoho matana yai. Habahim matana sa nega be ginauli ya ita lobahidi. ");
INSERT INTO bxh_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ya faliba iyen, Tabu u fuyo duhu laꞌi yai. Habahim ya dui. ");
INSERT INTO bxh_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Habahim Yesu yo tau famuli watanina sa lau luma haisa Sesaliya Filipo sadaina yai na edaꞌeda yai ya fatiꞌoidi iyen, Dodoga haba tiyen, “Yau sai?” ");
INSERT INTO bxh_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Yo fede tau famuli watanina tiyen, Dodoga haisa tiyen, “Um Diyon Babasito.” Haisa tiyen, “Um Ilaidiya,” na haisa tiyen, “Um mate peloweta hesa.” ");
INSERT INTO bxh_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Be ya fatiꞌoidi iyen, Na umi haba auwen, “Yau sai?” Alinana, Pita ya bui, Um mate Keliso, Yaubada ena Fasinabo Dogana. ");
INSERT INTO bxh_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu ya laugagayoꞌedi, iyebom, Ami nuwa gado. Tabu au fatala libalibaegu. ");
INSERT INTO bxh_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu ya fatubu tau famuli watanina ya faꞌatadi iyen, Doga Natuna haba kamkamna boludi ya fahoinadi. Haba babada yo tau antalasam babaꞌisadi yo laugagayo tau lau faꞌataena sa ꞌwaiyoꞌoꞌen. Haba sa wunui na lahai faihona ai mulidi ya mwahuli fuyo. ");
INSERT INTO bxh_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Liba te Yesu ya dede faneganega. Yo fede Pita ya foya hudoꞌiyen, be ya liba suꞌui. ");
INSERT INTO bxh_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","In moho, Yesu ya timuli bui ana hewahewali lisidi, na ma liba suꞌu hinaga, In ya libalau Pita lisina, iyebom, Satani, u lau afulegu! Em nuwanuwatuhu doha dodoga edi nuwatuhu. Hige Yaubada ena nuwatuhu! ");
INSERT INTO bxh_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Habahim tau famuli watanina yo baiwa ya yoga gogondima lisina be ya falibadi iyebom, Yena sai ya famuli watanigu ginauli mahudoꞌidi ti otawa. Ena kolosi moho i bahei na i lau watanigu. ");
INSERT INTO bxh_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yena sai ena mwahuli ya modemodeꞌen, mate ibege ana loge. Na sai ena mwahuli ya nuwa afulen, yau debagu yai yo wasa loholohona debana yai mate haba ya mwahuli. ");
INSERT INTO bxh_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ibe sai tanoꞌubu nuwanuwatuhudi moho ya modemodeꞌedi, na yaluwana hige i nanabuwen ai somo haba dudulai ya abi? ");
INSERT INTO bxh_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Somo haba doga ya ginauli be yaluwana ya une fafuyo? ");
INSERT INTO bxh_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Umi mate tau muli suhasuha Yaubada matana yai. Lahai pilipilidi yai te yena hiti heyaheyayadi ganahewadi yai sai ya taumayamayaꞌegu yo egu liba hinaga ya taumayamayaꞌen, mate Doga Natuna haba ya taumayamayaꞌen ena fuya laoma yai maidana anelu tabudi Tamada ena namanamali yai. ");
INSERT INTO bxh_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu ya falibadi iyen, E faliba dudulaimiu mate salumadi haisa ibege ti peꞌi ee–, Yaubada Aba Baꞌisa ma gigibwalina ya laoma sa ita. ");
INSERT INTO bxh_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Lahai faligigi esega mulidi yai Pita, Diyemsi yo Diyon, Yesu ya foya hudoꞌiyedi be sa lau tuꞌa lofalofana yai. Sa itaꞌita lau na Yesu nenena ya lau hudoꞌi. ");
INSERT INTO bxh_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ana leli sa kafu wananaha be sa famata anꞌan. Hige gonowana tanoꞌubu yai te sai laꞌi i ankaisu be ti kafu doha. ");
INSERT INTO bxh_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yo fede Ilaidiya yo Mose sa taumahata be maꞌedi Yesu sa libaliba. ");
INSERT INTO bxh_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita iyen, Tanuwaga, ya loholoho wananaha be ai amaiteꞌi! Haba gwaꞌu faihona ꞌe ginaulidi. Um em, Mose ena, yo Ilaidiya ena. ");
INSERT INTO bxh_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Sa ꞌwasabu wananaha be Pita ya libaliba gaibu.) ");
INSERT INTO bxh_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Habahim yada ya laoma be ya fakoudi na ganahewana yai alina hudoꞌi sa atahi iyen, Itete Natugu, E fanuha wananahai. Au ataꞌatahi lau lisina! ");
INSERT INTO bxh_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Yo fede sa itaꞌita asiꞌasi na hige sai laꞌi ti ita. Yesu moho maꞌedi. ");
INSERT INTO bxh_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tuꞌa yai sa letama, Yesu ya laugagayoꞌedi iyen, Somo ami ita tabu sai laꞌi au faliba ya lau wee–, Doga Natuna ya obiyo fuyo peꞌi yai. ");
INSERT INTO bxh_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ena laugagayo sa lau watan na iti ibodi moho sa lau fadosi tiyen, “Obiyo fuyo peꞌi yai” aniyona somo? ");
INSERT INTO bxh_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Yo fede Yesu sa fatiꞌoi, iyen, Sidohana be laugagayo tau lau faꞌataenna tiyen, “Ilaidiya haba ya laoma bwaꞌi?” ");
INSERT INTO bxh_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Alinadi ya bui iyen, Moꞌisa, Ilaidiya haba ya bwaꞌi, be ginauli mahudoꞌina ya faloholoho bodai. Buka Tabuna yai sa libaen mate, “Yau, Doga Natuna, haba E ankamkamna suꞌusuꞌu yo haba sa ꞌwaiyoꞌoꞌegu?” ");
INSERT INTO bxh_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","E falibamiu mate Ilaidiya haꞌa ya laoma be dodoga sa fahisu faheyaya doha Buka Tabuna ya libaen. ");
INSERT INTO bxh_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Fuyanna Yesu maꞌana hewali faihona tuꞌa yai sa fuyoma baiwa laꞌilaꞌi haidadi sa gana fataꞌiꞌilidi na maidadi laugagayo tau lau faꞌataenidi sa faifaibayaho sa itadi. ");
INSERT INTO bxh_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Maihalana yai baiwa Yesu sa ita be sa tauhiti. Sa lautafo lau lisina be sa lautoꞌiyen. ");
INSERT INTO bxh_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu ana hewahewali ya fatiꞌoidi, iyen, Somo ami faibayahoꞌen maidamiu dodoga ni? ");
INSERT INTO bxh_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Taumoho hesa pwalu yai, iyen, Tanuwaga, natugu E leyama lisim paꞌana yaluwa heyaheyayana lisina yai be hige i libaliba. ");
INSERT INTO bxh_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Yena ya luhufi haba ya lofe lidiyen ai tanohi yo ya gwasagwasa pulo na moꞌana ya nalididiꞌi yo tauna sa siꞌololo. Am hewahewali E falibadi bena sa liba dui. Na hige gonowadi. ");
INSERT INTO bxh_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu dodoga ya falibadi, iyen, Gwama ni au leyama lisigu. Tau kawawananaha gesa hitimiu, hige emi sunuma. Ai lisimiu haba E miya lofana doha somo? Ma fisa haba emi mwahu E bahei? ");
INSERT INTO bxh_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Yo fede sa leyama lisina. Maihalana yai Yaluwa heyaheyayana ya itaꞌita lau be Yesu ya ita yo fede yaluwa ni, gwama ya pei lidiyen tanohi yai be ya tapitapi pili yo ya gwasagwasa pulo. ");
INSERT INTO bxh_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu ya fatiꞌoi iyen, Atasina yai ya fatubu? Gwama tamana iyen, Ma kiukiuna ya fatubu. ");
INSERT INTO bxh_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Fuya ouꞌouli ya pei lawen ai oyagi alaꞌalana yo ai hoꞌowa be bena ya wunui. Aee–, yena gonowam u nuwatohatohaimai be u saguhimai. ");
INSERT INTO bxh_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu iyen, Sidohana be wa liba, uwen, “Yena gonowam?” Tau sunuma gonowana ginauli mahudoꞌidi ya ginaulidi. ");
INSERT INTO bxh_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yo fede gwama tamana ya yoga lau, iyen, E kawawananaha! In moho egu kawawananaha hige i laꞌi, be u saguhigu. ");
INSERT INTO bxh_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pwalu ya suꞌusuꞌuma Yesu lebena yai yo fede ya libalau yaluwa heyaheyayana lisina iyen, Um yaluwa doꞌodoꞌona yo libaliba gesana, E falibam gwama ni u kalamahano afulen na tabu u luhu fuyoi. ");
INSERT INTO bxh_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yaluwa heyaheyayana ya ꞌwalaꞌui na gwama ya kamfafatabubu na ya kalamahano. Gwama itaꞌitana doha doga peꞌipeꞌina be mahudoꞌidi tiyen, Haꞌa ya peꞌi! ");
INSERT INTO bxh_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yesu ya abilau gwama nimana yai be ya faꞌobiyo. ");
INSERT INTO bxh_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Habahim, sa lau luma ganahewana na ana hewahewali sa fatiꞌo modigafui, Sidohana be yaluwa heyaheyayana ni hige ai liba dui? ");
INSERT INTO bxh_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu iyen, Hige somo laꞌi gonowana. Lauꞌuꞌula moho gonowana yaluwa heyaheyayadi doha ite ya duidi sa lau ganamuli. ");
INSERT INTO bxh_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nuꞌu ni sa lau afulen na sa lau Galili. Yesu hige i fanuha bena sai hesa i sibai mate in somo yai, ");
INSERT INTO bxh_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","paꞌana tau famuli watanina, ya fatalahadi. Ya libalau lisidi iyebom, Doga Natuna haba sa fele lawen dodoga dodoga nimadi yai, be sa wunui na lahai fafaihonana yai haba ya mwahuli fuyo. ");
INSERT INTO bxh_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","In moho liba te aniyona hige ti nuwatuhu lobahi. Sa ꞌwasabu be hige ti fatiꞌoi. ");
INSERT INTO bxh_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kapanayum nuꞌuna yai sa mahano lau be sa lau luma ganahewana. Habahim Yesu tau famuli watanina ya fatiꞌoidi iyebom, Edaꞌeda yai somo ami faibayahoꞌen? ");
INSERT INTO bxh_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","In moho hige alinana ti bui paꞌana edaꞌeda yai ibodi sa faifaibayaho mate sai haba ya hasai wananaha. ");
INSERT INTO bxh_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu ya taꞌai na habahim ana hewahewali safuhudohudoꞌi luwaga ya yoga gogondima na ya falibadi iyen, Yena sai ya fanuha ya bwaꞌi mate bena ya mulita wananaha yo in mate dodoga mahudoꞌidi edi tau lau fayofayo. ");
INSERT INTO bxh_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yo fede wawaya kiukiu hesa ya faꞌobiyo atiꞌatipudi yai. Ya fagado bainewaꞌen na ya falibadi iyen, ");
INSERT INTO bxh_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Sai laꞌi hesagu yai wawaya doha itete ya yoga hitin mate, yau hinaga ya yoga hitinigu, yo sai ya yoga hitinigu, mate tau fatamaliguma hinaga ya yoga hitin. Hige ibogu moho! ");
INSERT INTO bxh_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Diyon ya libalau Yesu lisina iyen, Tanuwaga, doga hesa ꞌe ita hesam yai demoni ya liba duidi. Yo fede ꞌe lau biliyen paꞌana in hige i laulau watanida. ");
INSERT INTO bxh_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu ya falibadi iyen, Tabu au lau biliyen paꞌana hige sai laꞌi noꞌo laulaudi hesagu yai i lau ginauli na haba feula i liba faheyayagu. ");
INSERT INTO bxh_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Sai hige i ꞌwaiyoꞌoꞌeda mate eneheda. ");
INSERT INTO bxh_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","E faliba dudulaimiu mate yena sai hoꞌowa ya felemiu, paꞌana umi enehegu, haba maisana ya abi. ");
INSERT INTO bxh_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yena sai hesa wawaya kiukiu ya foya ponoli be ena sunuma ya fagogoma, loholohona mate dogana ai gadona umeꞌehu laꞌilaꞌi sofana habahim fakapulolona ai gabogabo. ");
INSERT INTO bxh_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ibe nimam hesa ya falau ponom be heyaya wa ginauli u ibo motu! Ya loholohona ma nima eseꞌesegam, haba wa mwahuli. Hige i loholoho ma nima luwaluwagam sa lawem oyagi alaꞌalana hige anadan. ");
INSERT INTO bxh_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Amainiya, hulohulo ibege ti peꞌi yo oyagi alaꞌalana ibege ti fatuwa funuhi. ");
INSERT INTO bxh_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na ibe ahem hesa ya falau ponom be heyaya wa ginauli, u ibofahi! Ya loholoho ma ahe eseꞌesegam, haba wa mwahuli. Hige i loholoho bena ma ahe luwaluwagam sa pei lawem ai oyagi alaꞌalana. ");
INSERT INTO bxh_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Amainiya hulohulo ibege ti peꞌi yo oyagi alaꞌalana ibege ti fatuwa funuhi. ");
INSERT INTO bxh_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Yo ibe matam hesa ya falau ponom be heyaya wa ginauli u limofahi! Ya loholohona ma mata eseꞌesegam, haba wa lau Yaubada Aba Baꞌisa. Hige i loholoho ma mata luwaluwagam sa pei lawem ai oyagi alaꞌalana. ");
INSERT INTO bxh_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Amainiya hulohulo ibege ti peꞌi yo oyagi alaꞌalana ibege ti fatuwa funuhi. ");
INSERT INTO bxh_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Doga mahudoꞌina haba sa faꞌaꞌa doha antalasam sa faꞌaꞌa alita yai. ");
INSERT INTO bxh_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Alita mate ya loholoho in moho yena amnana ya ofi haba sidohana em fafaꞌalita fuyoina? Alita ai nuwamiu i ota, na au miya gogo, ma nuwa esegamiu. ");
INSERT INTO bxh_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Habahim Yesu Kapanayum nuꞌuna ya lau afulen na ya lau Diudeya Nuꞌuna yai be Diyodan Hoꞌowana ya gayo dohe. Ena laulau mate fuya ouꞌouli baiwa ya faꞌoigogoma lisina haba ya fafatalahadi. ");
INSERT INTO bxh_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Falesiya haisa Yesu sa anpate bena sa fasai buluhi, be sa fatiꞌoi tiyen, Eda laugagayo ya libaen, taumoho lahuna gonowana ya tausohoꞌen? ");
INSERT INTO bxh_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Alinadi Yesu ya bui iyen, Mose laugagayo somo ya felemiu? ");
INSERT INTO bxh_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tiyen, Mose dudulai taumoho ya felen, be tausoho pepana ya uli na habahim lahuna ya dui. ");
INSERT INTO bxh_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu ya falibadi iyen, Mose laugagayo te ya uli enehemiu paꞌana nuwamiu sa poꞌi. ");
INSERT INTO bxh_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","“Fatubu yai Yaubada dodoga ya ginaulidi, taumoho yo waihin. ");
INSERT INTO bxh_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Logena taumoho haba tinana yo tamana ya lau afuledi na ma lahuna sa miya esega, be sa famala esega. ");
INSERT INTO bxh_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Be iti hige luwaga na sa famala esega.” ");
INSERT INTO bxh_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Somo Yaubada haꞌa ya falau esegahi mate doga ibege i fatausohodi. ");
INSERT INTO bxh_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yesu maꞌana hewahewali sa fuyo luma ganahewana habahim liba wa aniyona sa fatiꞌoi. ");
INSERT INTO bxh_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ya falibadi iyen, Taumoho lahuna ya tausohoꞌen be waihin hesa ya fai mate luwagadi ni ponoli sa ginauli. ");
INSERT INTO bxh_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Gonogonowana doha waihin lahuna ya tausohoꞌen na taumoho hesa ya fai mate sa ponoli. ");
INSERT INTO bxh_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Dodoga haisa wawaya sa ledima Yesu lebena bena ya abiꞌonadi na tau famuli watanina sa sagasagaliyedi. ");
INSERT INTO bxh_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu ya itadi be manana ya bala. Yo fede ya libalau tau famuli watanina lebedi iyen, Wawaya ti laoma lisigu. Tabu au gududi, paꞌana Yaubada Aba Baꞌisa mate dodoga doha wawaya itete, enehedi. ");
INSERT INTO bxh_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yena sai ya kawawananaha doha wawaya haba Yaubada Aba Baꞌisa ya luhufi. ");
INSERT INTO bxh_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Habahim wawaya ya labadi na nimana ya tole hewadi yai be ena loholoho ya feledi. ");
INSERT INTO bxh_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu edaꞌeda yai ya laulau na taumoho hesa ya lautafotafoma be nuwanuwana yai ya tulibono na ya fatiꞌoi iye, Tanuwaga loholohona, somo haba E ginauli be mwahuli hige ofina E lobahi? ");
INSERT INTO bxh_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu iyebom, Sidohana be wa kawa loholohoꞌegu? Hige sai laꞌi i loholoho doha Yaubada. ");
INSERT INTO bxh_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Laugagayo mate haꞌa wa sibaidi: Tabu u aiyunu; tabu doga hesa lahuna maꞌem au eno bili; tabu u angafu; tabu u lau bwalabwala; tabu bwalabwala yai hidam ena ginauli hesa u abi. Tamam yo tinam bena wa faꞌatitiyedi. ");
INSERT INTO bxh_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Taumoho iye, Tanuwaga, ma wawayagu na ya laoma be aho ite mate laugagayodi ni E laulau watanidi. ");
INSERT INTO bxh_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu ma gadosisina ya mainene lau lisina, na iye, Ginauli esega moho hige u ginauli. U fuyo be em ginauli mahudoꞌidi u uneꞌunedi na monidi tau gogo gesagesa u feledi. Na u lau watanigu. Ai Galewa haba wa fagogo. ");
INSERT INTO bxh_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Liba ni ya atahiyen yo fede ma nuwa heyayana ya aulaha. Paꞌana ya fagogo wananaha. ");
INSERT INTO bxh_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu ya itaꞌita lau ana hewahewali lebedi na ya falibadi iye, Yaubada Aba Baꞌisa luhuluhu launa mate tau fagogo lisidi yai ya pili. ");
INSERT INTO bxh_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tau famuli watanina liba ni sa atahi be sa tauhiti. Na Yesu ya falibadi iyen, Nanatugu, Yaubada Aba Baꞌisa luhuluhu launa mate ya pili wananaha. ");
INSERT INTO bxh_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamela hige gonowana ai diu galina i luhulau! Haba ya talaꞌafi. Gonogonowana doha, tau fagogo hige gonowana i luhulau Yaubada ena Aba Baꞌisa. ");
INSERT INTO bxh_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yo fede tau famuli watanina aluwadi sa potifahi be sa fatiꞌo fuyoꞌidi tiyen, Sai haba ya mwahuli? ");
INSERT INTO bxh_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu ya itaꞌita lau lebedi na iyen, Dodoga hige gonowadi. In moho Yaubada gonowana ginauli mahudoꞌidi ya ginaulidi. ");
INSERT INTO bxh_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita iyen, Wa sibai mate ginauli mahudoꞌidi ꞌe lau afuledi na ꞌe lau watanim. ");
INSERT INTO bxh_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu iyen, Wananaha, E falibamiu. Yena sai ena nuꞌu, haidana, lolofuna, tinana, tamana, nanatuna e ena gabu ya lau afuledi Yau debagu yai yo wasa loholohona debana yai, ");
INSERT INTO bxh_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","haba loholoho ya fahoina. Haba ena luma, haidana, lolofuna, afa tinana, nanatuna yo ena gabu sa ouli wananaha. Haba ya ankamkamna hinaga na fuya matada yai haba mwahuli hige ofina ya lau lobahi. ");
INSERT INTO bxh_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Salumadi sa bwaꞌi haba sa mulita yo salumadi sa mulita haba sa bwaꞌi. ");
INSERT INTO bxh_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu ya bwaꞌi na ana hewahewali mate mulina yai sa laulau watan be sa hasai Yelusalem. Safuhudohudoꞌi luwaga sa noꞌo, na dodoga mate sa ꞌwasabu. Yesu ana hewahewali ya lawe hudoꞌiyedi be ginauli somo - somo haba sa tubu ai lisina mate ya falibadi. ");
INSERT INTO bxh_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Iyen, Hola E falibamiu, ai Yelusalem haba Doga Natuna sa fele lawen tau antalasam babaꞌisadi yo laugagayo tau lau faꞌataena ai nimadi. Diusi dodogadi sa fagilu bena ya peꞌi yo fede sa fele lawen taꞌowawa lisidi, ");
INSERT INTO bxh_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","be iti haba sa lau faliuhwaꞌen, sa lau kanisoi, sa pidili yo sa wunui. In moho lahai fafaihonana yai haba ya mwahuli fuyo. ");
INSERT INTO bxh_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Habahim Sebedi nanatuna luwaga Diyemsi yo Diyon sa laoma Yesu lisina be tiyen, Tanuwaga, ginauli hesa ꞌe fanuha bena wa ginauli enehemai. ");
INSERT INTO bxh_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu iyen, Ginaulina somo bena enehemiu E ginauli? ");
INSERT INTO bxh_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Alinana sa bui tiyen, ꞌE fanuha bena hesa ai sibam ya taꞌai, na hesa ai seulim em Nuꞌu Namanamalina yai. ");
INSERT INTO bxh_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu ya falibadi iyebom, Somo ami anꞌanꞌetai mate hige au sibai. Gonowamiu haba ami kamkamna doha Yau? Ibe peꞌi babasitona E abi, haba gonowamiu ami abi doha? ");
INSERT INTO bxh_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Alinana sa bui tiyen, Ai gonowamai. Yesu ya falibadi iyen, Ii–, haba ami ankamkamna doha Yau! Yo peꞌi babasitona hinaga haba ami abi. ");
INSERT INTO bxh_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","In moho, Yau hige egu dudulai bena haba yawa, “Tataumiu luwaga ai sibagu yo ai seuligu au taꞌai. Sai ena aba taꞌai Yaubada haꞌa ya abi nonohai mate, in enehena.” ");
INSERT INTO bxh_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Safuhudohudoꞌi sa atahi be Diyemsi yo Diyon sa manabalaꞌedi. ");
INSERT INTO bxh_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yo fede Yesu ya yoga gogondima na ya falibadi, iyen, Ami siba mate taꞌowawa edi nuwatuhu bena iti babaꞌisa, be edi nuꞌu sa ita watanidi. Edi babaꞌisa lalaꞌi, edi gigibwali sa fapaisowa edi dodoga lisidi yai be edi nuwatuhu haba sa lau watanidi. ");
INSERT INTO bxh_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tabu emi laulau doha. Sai ya fanuha ya hasai wananaha, in bena mahudoꞌidi edi tau lau fayofayo. ");
INSERT INTO bxh_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Yo yena sai ya fanuha ya bwaꞌi, in ya famala emi tau paula. ");
INSERT INTO bxh_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Doga Natuna ya laoma tanohi yai hige bena dodoga ena ti paisowa. In bena dodoga edi ya paisowa yo ena mwahuli ya pei, be dodoga ouꞌouli ya une fafuyodi. ");
INSERT INTO bxh_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Habahim sa mahano lau Diyeliko nuꞌuna yai. Yesu ma ana hewahewali yo baiwa laꞌilaꞌi nuꞌuna sa lau afulen na tau anꞌanꞌeta hesa mata toutouna hesana Batimaiyesa edaꞌeda sadaina yai ya taꞌataꞌai. In mate Timaiyesi natuna. ");
INSERT INTO bxh_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ya atahi mate Yesu, Nasaleta dogana, ya laolaoma yo fede ya yoga iyen, Yesu, Deiwidi Laulauwewena! U nuwatohatohaegu! ");
INSERT INTO bxh_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Dodoga boludi sa sagasagaliyen bena ya famakano. In moho ya yoga laꞌilaꞌi boda, iyen, Deiwidi Laulauwewena! U nuwatohatohaegu! ");
INSERT INTO bxh_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yo fede Yesu ya bwaꞌi tohai na, iyen, Au yogaiyama! Be doga mata toutouna sa fayoga tiyen, Ya yogaim, be u obiyo! Na nuwam i adidili! ");
INSERT INTO bxh_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yo fede kaleko, tauna yai ya pei, na ya obiyofahi be ya lau Yesu lisina. ");
INSERT INTO bxh_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu ya fatiꞌoi, iyen, Em fanuha somo bena E ginauli? Taumoho mata toutouna iyen, Tanuwaga, E fanuha bena matagu wa falaladi. ");
INSERT INTO bxh_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu ya faliba iyen, U lau! Em kawawananaha haꞌa ya faloholohom. Yo fede matana ya falaladi. Yesu ya famuli watan be edaꞌeda yai sa lau. ");
INSERT INTO bxh_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Sa mahano lau Betifegi yo Betani, Oliwe Piuna sadaina yai, na Yelusalem sa hanahanaui be Yesu ana hewahewali luwaga ya fatamalidi. ");
INSERT INTO bxh_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Na iyen, Au lau nuꞌu hesa matamiu yai. Yena ami mahano lau haba donki natuna ami ita. Amainiya sa fadaꞌi na hola hige sai i awai. Au tatafahi be au leyama. ");
INSERT INTO bxh_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Yena sai iyen, “Somo ami ginaginauli?” Mate au faliba auwe, “Guyau ya fanuha. Na haba ꞌe fatamali fafuyoyama.” ");
INSERT INTO bxh_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yo fede sa lau be donki natuna sa ita edaꞌeda yai, na sa auꞌaui luma hafohafona yai. Sa tata ");
INSERT INTO bxh_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","na dodoga haisa amainiya sa obiꞌobiyo tiyen, Hei! Ami tata be? ");
INSERT INTO bxh_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Na Yesu somo ya falibadi, enehedi sa liba be donki wa sa nuwaꞌen. ");
INSERT INTO bxh_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Sa lawen Yesu lebena. Adi luhuluhu donki taulina yai sa hesedi, habahim Yesu ya taꞌai hiti. ");
INSERT INTO bxh_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Dodoga boludi adi luhuluhu sa hesedi edaꞌeda yai na haisa oyagi lagadi ma lugulugudi gabu yai sa talafahidi, be edaꞌeda yai sa hesedi. ");
INSERT INTO bxh_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tau bwaꞌi yo haisa tau lau wata sa laulau yogayoga, tiyen, Hosana, Yaubada te fadebasae! In, Guyau hesana yai ya laoma - Yaubada ena loholoho i felen! ");
INSERT INTO bxh_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Yaubada ena loholoho ya feleda paꞌana aho te ada ulutubu Deiwidi ena tanuwaga laulaudi haba Yesu ya abi hitin fuyoi! Hosana, hewa wananahana yai! Yaubada te fadebasae! ");
INSERT INTO bxh_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu ya mahano lau Yelusalem, be ya luhulau Dubu Tabuna dobidobina yai, be ginauli mahudoꞌidi ya ita sipoidi. Maihala ya ofi, yo fede maꞌana hewahewali safuhudohudoꞌi luwaga sa lau Betani. ");
INSERT INTO bxh_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Bobonna Betani yai sa fuyo Yelusalem na Yesu ya guliyam. ");
INSERT INTO bxh_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Manamanaꞌa yai ya itaꞌita lau be oyagi hesa doha kuhou luguna ya ita, yo fede ya lau be ya ita mate lugu afaꞌafana paꞌana hige ana fuya. ");
INSERT INTO bxh_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Habahim Yesu ya libalau oyagi ni lisina iyen, Tabu u fuwa! Tabu sai hesa anꞌanim i an! Na tau famuli watanina somo ya libaen, sa ataꞌatahi. ");
INSERT INTO bxh_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Sa mahano lau Yelusalem yai na Yesu ya lau Dubu Tabuna dobidobina yai. Tau uneꞌune yo tau maketi mahudoꞌidi ya fadabalaladi. Nuꞌu hahaisa edi moni tau laulau senisi edi tebolo ya buidi, yo ataiꞌa doha waliliya tau uneꞌuneidi edi aba taꞌai hinaga ya buidi. ");
INSERT INTO bxh_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yo Yesu iyen, Tabu sai hesa somo laꞌi u leyama ai Dubu Tabuna dobidobina. ");
INSERT INTO bxh_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Na habahim dodoga ya fatalahadi iyen, Buka Tabuna yai sa uli mate Yaubada iyen, “Egu Dubu Tabuna mate nuꞌu mahudoꞌina edi aba lauꞌuꞌula. Na umi ami fapaisowa be ya famala tau angafu edi aba alasimo.” ");
INSERT INTO bxh_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tau antalasam babaꞌisadi yo laugagayo tau lau faꞌataena liba ni sa atahiyen yo fede edaꞌeda sa yoꞌo bena Yesu sa wunui. Sa ꞌwasabuwen paꞌana baiwa mahudoꞌina ena lau faꞌata sa noꞌoꞌen. ");
INSERT INTO bxh_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Maimailafina Yesu maꞌana hewahewali taonna sa lau afulen. ");
INSERT INTO bxh_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Bobonna ma hwalahwalalana edaꞌeda yai sa laulau na oyagi doha kuhou sa ita ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita ya nuwatuhui yo fede Yesu ya faliba iyen, Tanuwaga, oyagi wa kaumananai wa, u ita, ya peꞌi! ");
INSERT INTO bxh_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu iyebom, Yaubada au kawawananahaꞌen. ");
INSERT INTO bxh_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","E faliba dudulaimiu mate sai yena ya kawawananaha na tabu i nuwa luwaluwaga na ya libalau tuꞌa lisina iyen, “U lau, u lofe lidiyem ai gabogabo.” Mate somo ya libaen haba ya tubu. ");
INSERT INTO bxh_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Logena, E falibamiu yawa, “Lauꞌuꞌula yai, somo ami anꞌetai, bena ami kawawananaha mate haꞌa ami abi, haba Yaubada ya felemiu. ");
INSERT INTO bxh_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Somo ami ita faheyaya haidamiu lisadi yai fuyana ami mwaito be ami lauꞌuꞌula mate au nuwatuhu afuledi. Haba Tamamiu Galewa yai emi heyaya ya nuwatuhu afuledi. ");
INSERT INTO bxh_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","“Yena dodoga edi heyaya hige au nuwatuhu afuledi mate Tamamiu galewa yai emi heyaya ibege i nuwatuhu afuledi.” ");
INSERT INTO bxh_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Sa mahano fuyoma Yelusalem, be Yesu ya lau Dubu Tabuna dobidobina ya laulau tiga na tau antalasam babaꞌisadi, laugagayo tau lau faꞌataena, yo babada hahaisa sa laoma lisina. ");
INSERT INTO bxh_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Sa fatiꞌoi tiyen, Dudulai somo wa fapaisowa be ginaulidi te wa ginaulidi? Yo sai dudulai te ya felem be wa ginauli doha? ");
INSERT INTO bxh_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu alinadi ya bui, iyebom, Fatiꞌo esega haba E fatiꞌoimiu, na buina au felegu. Habahim dudulai somo E fapaisowa be laulau te E ginaulidi emi E liba. ");
INSERT INTO bxh_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Au falibagu! Diyon ena fafababasito somo yai ya laoma? Galewa yai e dodoga lisidi yai? ");
INSERT INTO bxh_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yo fede tau antalasam babaꞌisadi yo laugagayo tau lau faꞌataena ibodi sa fadosi tiyen, Yena tawa, “Galewa yai,” haba iyen, “Sidohana Diyon hige au kawawananahaꞌen?” ");
INSERT INTO bxh_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Na yena tawa, “Dodoga lisidi yai–, mate sa ꞌwasabuwedi paꞌana dodoga mahudoꞌidi edi nuwatuhu mate Diyon in peloweta wananaha.” ");
INSERT INTO bxh_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yo fede Yesu alinana sa bui tiyen, Hige ai siba. Yesu ya falibadi iyen, Yau hinaga dudulai somo E fapaisowa be laulau te E ginaulidi ibege ya falibamiu. ");
INSERT INTO bxh_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Heyaheyason hesa Yesu ya falibadi, iyen, Doga hesa wain gabuna ya umahi na ya ganai. Wain aba folona ya ginauli yo gati lumana hewana lofalofa ya faꞌobiyo. Muliyai dodoga haisa ya toledi be gabu sa ita watan na ya lau ya lauwasi. ");
INSERT INTO bxh_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wain ena fuya anaho yai mate gabu tanuwagana ena tau lau fayofayo ya dui lawen lisidi na iyen, U lau u falibadi be wain monina egu tefa ti felem, be u leyama. ");
INSERT INTO bxh_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tau itaꞌita wata fayofayo dogana sa tohai be sa talai na sa dui fafuyo ma nima afaꞌafana. ");
INSERT INTO bxh_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Habahim gabu tanuwagana tau lau fayofayo hesa hinaga ya dui, na kuluna sa dem tili yo sa liba fafaheyaya. ");
INSERT INTO bxh_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Fafaihonana ya dui mate sa wunui. Tau lau fayofayo peidi hinaga ya duidi. In moho Laulauna gonogonowana, haisa sa pidilidi, na haisa sa wunuidi. ");
INSERT INTO bxh_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ofiꞌofina, natuna ya fanuha wananahai ya dui na iyen, Natugu haba sa faꞌatitiyen. ");
INSERT INTO bxh_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Gabu tau ita watanina ibodi sa libaliba tiyen, Gabu tanuwagana natuna itete. In haba tamana ena tanohi ya abidi. Ta wunui! Ena tanohi haba te abi! ");
INSERT INTO bxh_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Yo fede natuna sa tohai be sa wunui, na silanna sa pei lawen gabu mulimulina yai. ");
INSERT INTO bxh_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Gabu tanuwagana haba somo ya ginauli? Haba ya laoma be ya wunuidi na dodoga haisa ya ledima be wain gabuna sa ita watan. ");
INSERT INTO bxh_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Uliꞌuli te haꞌa ami fatili. “Tau abi luma umeꞌehu sa ꞌwaiyoꞌoꞌen mate muli yai ya famala umeꞌehu otaꞌotafahina. ");
INSERT INTO bxh_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","“Itete Guyau ya ginauli be itaꞌitana mate ya loholoho wananaha!” ");
INSERT INTO bxh_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yo fede Diusi babaꞌisadi edaꞌeda sa yoꞌo bena Yesu sa au paꞌana heyaheyason ni, iti tautaudi. In moho dodoga baiwadi sa ꞌwasabuwedi be Yesu sa lau afulen. ");
INSERT INTO bxh_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Muli yai Heloda ena pele yo Falesiya mate dodoga sa duidi sa lau Yesu lisina be haba ena libaliba yai sa fasai buluhi. ");
INSERT INTO bxh_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Be tiyen, Tanuwaga, ꞌe sibai mate um doga dudulaina. Dodoga lalaꞌi yo kikiꞌina edi nuwatuhu heyaheyayadi ibege u lau watandi, in moho Yaubada ena liba, dudulai yai wa lau faꞌataen. Be, haga u falibamai, takesi ꞌe famaisa Loma edi Sisa ai lisina ya dudulai e hige? Haba ꞌe tole e hafena? ");
INSERT INTO bxh_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","In moho edi bwala Yesu haꞌa ya sibai be alinadi ya bui, iyebom, Sidohana be ami fasai bulubuluhigu? Haga moni au leyama be ya ita. ");
INSERT INTO bxh_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Esega sa felen, na iyen, Sai tautauna yo hesana moni yai te? Alinana sa bui tiyen, Sisa, Loma edi Kin. ");
INSERT INTO bxh_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yo fede Yesu iyen, Somo Kin Sisa ena, mate au felen. Na Yaubada ena, mate Yaubada au felen. Yo fede edi noꞌo sa ofi! ");
INSERT INTO bxh_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Habahim Sadusi haisa (iti sa liba mate dodoga ibege ti obiyo fuyo) sa laoma Yesu lisina be tiyen, ");
INSERT INTO bxh_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Tanuwaga, Mose ya uli mate yena taumoho ma lahuna hige nanatudi na taumoho ya peꞌi, hidana hwabuna haba ya fai na ya fanatu mate sa famala tau peꞌi nanatuna. ");
INSERT INTO bxh_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Doga hesa nanatuna tatau faligigi luwaga. Tau tuwaha ya nahi be hige nanatuna na ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Fafaluwagana hwabu wa ya fai, be hige natuna na hinaga ya peꞌi. Fafaihonana hinaga hwabu ya fai be hige natuna. ");
INSERT INTO bxh_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Doha, na ya lau wee–, waihin wa, tatau faligigi luwaga ya fai ofinidi, mate hige natudi, na sa peꞌi. Ofiꞌofina mate waihin hinaga ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Obiyo fuyo lahaina yai, waihinna ni haba sai lahuna? Paꞌana tataudi faligigi luwaga waihinina haꞌa sa fai. ");
INSERT INTO bxh_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu alinadi ya bui iyen, Ami lau pono paꞌana Buka Tabuna yo Yaubada ena gigibwali hige au sibai. ");
INSERT INTO bxh_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tau peꞌipeꞌi sa obiyo fiyo, iti mate doha anelu galewa yai. Ibege ti nahi boda. ");
INSERT INTO bxh_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Obiyo fuyo libana Mose ena buka yai ami fatili e higeꞌe? Somo yai Yaubada ya libalau Mose lisina oyagi ala balebalelemna ganahewana yai, fuyanna iyen, “Abelaham, Isako yo Iyakobo edi Yaubada mate Yau.” ");
INSERT INTO bxh_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ami lau pono wananaha! In mate tau mwahumwahuli edi Yaubada. Hige tau peꞌipeꞌi edi Yaubada. ");
INSERT INTO bxh_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Laugagayo tau lau faꞌataena hesa ya laoma, edi liba ya atahi. Ya sibai mate Sadusi edi liba Yesu ya bui loholohoꞌidi yo fede ya fatiꞌoi iyen, Laugagayo mahudoꞌina ganahewana yai tausomo ya hasai wananaha? ");
INSERT INTO bxh_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu iyen, Esega ya hasai wananahana mate itete: “Isalaela au ataꞌatahi! Guyau in iyabona eda Yaubada. ");
INSERT INTO bxh_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yaubada u gadosisiyen ma nuwa ofifahim, em nuwatuhu mahudoꞌina, yaluwam mahudoꞌina, yo ma adidilim.” ");
INSERT INTO bxh_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Laugagayo fafaluwagana mate itete: “Falem tau miya u gadosisiyen, doha um wa gadosisi fuyoim.” Laugagayodi luwaga te, sa hasai wananaha, habahim hahaisa. ");
INSERT INTO bxh_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Laugagayo tau lau faꞌataenna ya libalau Yesu lisina iyen, Tanuwaga, wa liba dudulai mate, Yaubadana, esega; hige sai hesa; In ibona moho. ");
INSERT INTO bxh_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Yaubada u gadosisiyen ma nuwa ofi fahim, em nuwatuhu mahudoꞌina, yo ma adidilim. Falem tau miya u gadosisiyedi, doha um wa gadosisi fuyoim. Laugagayo luwaga te sa hasai wananaha, habahim yosiyosi gabugabudi yo ainauya hahaisa Yaubada te felen aba antalasam gabuna yai. ");
INSERT INTO bxh_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ena bui Yesu ya atahi mate ya dudulai, yo fede ya faliba iyen, Yaubada Ena Aba Baꞌisa hige i lofa lisim yai. Yo fede sa ꞌwasabu be hige somo hesa Yesu ti fatiꞌo fuyoi. ");
INSERT INTO bxh_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Fuyana Yesu ya laulau faꞌata Dubu Tabuna dobidobina yai, ya fatiꞌo iyen, Sidohana be laugagayo tau lau faꞌataenna itiye, “Keliso mate Deiwidi laulauwewena?” ");
INSERT INTO bxh_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yaluwa Tabuna nuwatuhu Deiwidi ya felen be iyen, “Guyau ya libalau egu Guyau lisina, ‘Ai sibagu u taꞌai yee–, am waiyunu E toledi ai ahem ubuna.” ");
INSERT INTO bxh_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Ibe Deiwidi iyen, ‘Um Guyau,’ haba sidohana be in Deiwidi laulauwewena?” Na baiwa laꞌilaꞌi, ya ataꞌatai ma nuwa kwadedi. ");
INSERT INTO bxh_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu ena lau faꞌata ganahewana yai iyebom, Laugagayo tau lau faꞌataedi, au ita sipoꞌidi! Salumadi sa fanuha bena edi leli lofalofadi na sa leu yo sa sai ai maketi be haba dodoga sa laulautoꞌiyedi. ");
INSERT INTO bxh_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Aba oiꞌoigogo lumadi yai yo mataꞌasi ganahewadi yai sa fanuha bena aba taꞌai loholohodi yai sa taꞌai. ");
INSERT INTO bxh_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Hwabuhwabu edi luma ginaulidi sa bwalafahidi be ai edi, sa abidi, yo lauꞌuꞌula sa falofadi. Lau bwalabwala te lisidi yai haba kamkamna lalaꞌi sa fahoinadi. ");
INSERT INTO bxh_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Diusi edi Dubu Tabuna yai Yesu ya taꞌataꞌai, moni aba husanina sadaina yai be dodoga boludi moni sa toletole ya kinokinoꞌidi. Tau fagogo boludi mate moni lalaꞌi sa toledi; ");
INSERT INTO bxh_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","na hwabuhwabu hige ena moni ya laoma be moni kapa kikiꞌuka luwaga ya husanidi, laꞌina doha 5 toea. ");
INSERT INTO bxh_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ana hewahewali ya yoga gogondima na ya falibadi iyen, E faliba dudulaimiu! Hwabuhwabu tau gogo gesagesana te, ainauya laꞌilaꞌi ya tole aba husanina yai, na habahim hahaisa. ");
INSERT INTO bxh_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tau fafagogo mate edi tefa sa ota, na waihin ni ena moni ofiꞌofina. Ana kalahe edaꞌedana logena, ya tole ofiꞌi. ");
INSERT INTO bxh_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu Dubu Tabuna ya laulau afulen na ana hewali hesa iyen, Tanuwaga, luma loholohodi yo umeꞌehu lalaꞌi u itadi! ");
INSERT INTO bxh_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu iyen, Luma lalaꞌi te ami itadi? Ibege umeꞌehu hesa, hesa ai hewana i ota. Mahudoꞌidi haba sa anlubi lopalopaidi. ");
INSERT INTO bxh_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Oliwe Piuna yai Yesu ya taꞌataꞌai na Dubu Tabuna ya ita lawen tefa yai. Pita, Diyemsi, Diyon yo Endulu ibodi Yesu sa fatiꞌoi tiyen, ");
INSERT INTO bxh_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","U falibamai, fuya somo haba ginaulidi te sa tubu? Yo fafaꞌilala somo haba ya taumahata be ꞌe sibai mate fuyana ya hanahanau? ");
INSERT INTO bxh_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Na Yesu ya falibadi iyen, Au ita komakoman, ibe ti bwalafahimiu! ");
INSERT INTO bxh_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Dodoga boludi hesagu yai haba sa laoma tiyen, “Yau Keliso.” Be boludi haba sa bwalaidi. ");
INSERT INTO bxh_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Yena hiyala sadai yai ye eda lofalofa yai wasadi ami atahiyedi, tabu au ꞌwasabu. Ginauli doha ite haba sa tubu, in moho lahai ofiꞌofina hola. ");
INSERT INTO bxh_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nuꞌu hesa haba maidadi nuꞌu hesa sa hiyala, mwanuꞌunuꞌu yo galamo wesawesasa haba nuꞌu haisa yai. Somo heyaheyayadi sa tubu te, doha kamkamna bwaꞌibwaꞌina wawahin sa fahoina edi fuya fanatu yai. ");
INSERT INTO bxh_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Au itaꞌita komakoman! Haba sa aumiu be sa lawemiu emi nuꞌu koniseladi lisidi be Diusi edi aba oiꞌoigogo lumadi yai sa pidilimiu. Gawana yo kin nuwanuwadi yai haba ami obiyo, yau debagu yai, be wasa loholohona ami falibadi. ");
INSERT INTO bxh_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Na wasa loholohona bena ami lauguguya bwaꞌiyen ai nuꞌu mahudoꞌina. ");
INSERT INTO bxh_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na yena sa aumiu be ami lau fatala, tabu au mode wananaha auwen, “Somo haba ꞌe libaen?” Somo ya mahata nuwamiu yai au libaen moho, paꞌana Yaluwa Tabuna ya libaliba, hige umi. ");
INSERT INTO bxh_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Doga hidana haba ya fele afulen be sa wunui yo doha, Tau tamatama haba ya ginauli natuna ai lisina. Wawaya haba sa timuli bui be tamadi yo tinadi sa wunuidi. ");
INSERT INTO bxh_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Debagu yai haba mahudoꞌidi sa fawaiyunuwemiu. Na sai ya nuwa adidili ya lau ee–, lahai ofiꞌofina haba ya mwahuli. ");
INSERT INTO bxh_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesu iyen, “Ginauli hesa fatau ꞌwasaꞌwasabu wananahana” in tabu ainiya, haba ami ita ya obiꞌobiyo nuꞌuna yai ni. (Tau fatifatili bena ya nuwatuhu lobahi.) Na salumadi Diudeya yai bena sa gela lau tuꞌa. ");
INSERT INTO bxh_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Sai ena luma hewana yai tabu i lidi luma ganahewana, be ginauli hesa i abi. ");
INSERT INTO bxh_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Sai gabu yai tabu i fuyo luma ana luhuluhu i abi. ");
INSERT INTO bxh_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Lahaidi ni sa mahanoma mate wawahin bogabogadi yo nanatudi sa fafanomdi lisidi yai ya heyaya wananaha. ");
INSERT INTO bxh_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yaubada au anꞌetai be ginaulidi te tabu fuya gogoma yai ti tubu, ");
INSERT INTO bxh_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","paꞌana pilipili ai lahaidi ni haba sa heyaya wananaha. Hige doha fuya bwaꞌibwaꞌina yai Yaubada tanoꞌubu ena fuya ginaulina yai ya laoma ee–, aho ite. Ai muli, ibege ti tubu fuyo. ");
INSERT INTO bxh_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ibe Guyau, pilipili lahaidi ni, hige i fatupodi ibege doga hesa i mwahuli. In moho, salumadi ya fasinabodi debadi yai mate, Yaubada lahaidi ni ya fatupodi. ");
INSERT INTO bxh_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Lahaina yai ni yena sai iyen, “Keliso ami ita” e “In logena auu–.” Mate, tabu au kawawananaha. ");
INSERT INTO bxh_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Paꞌana keliso yo peloweta bwalabwaladi haba sa laoma be noꞌo yo fafaꞌilala sa lau ginauli, yena gonowanadi mate Yaubada ena fasinabo dodogadi haba sa foya ponolidi. ");
INSERT INTO bxh_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Logena bena ami ita komakoman! Somo matada yai haba ya tubu mate haꞌa E falibamiu. ");
INSERT INTO bxh_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Pilipili lahaidi sa ofi na ai mulina haba maihala ya kamukamumu yo nawalahi ibege i sina. ");
INSERT INTO bxh_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kipwala galewa yai haba sa beꞌu yo galewa ginaulidi haba sa mwahmwahiu. ");
INSERT INTO bxh_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ai lahaina ni Doga Natuna haba sa ita ma gigibwali laꞌilaꞌina yo ma namanamalina ya laolaoma yada yai. ");
INSERT INTO bxh_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","In haba anelu ya fatamali lawedi tefa bwauli, yawana, bolima yo yalasi edi aba towa yai. Na Yaubada ena fasinabo dodogadi haba sa faꞌoigogo esegahidi, tanoꞌubu ana dan ya lau ee–, galewa ana dandan. ");
INSERT INTO bxh_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Oyagi doha kuhou lau faꞌatana te au nuwatuhui. Yena lagana sa tutuli ami sibai mate siuhwalo ya laolaoma. ");
INSERT INTO bxh_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Doha, yena ginaulidi te sa tubu ami itadi mate ami sibai, lahaidi ni sa hanahanauma. ");
INSERT INTO bxh_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","E faliba dudulaimiu mate, dodogadi haisa aho te sa miyamiya ibege ti peꞌi ee–, ginaulidi mahudoꞌidi te sa tubu. ");
INSERT INTO bxh_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Galewa yo tanoꞌubu haba sa ofi in moho, yau egu liba ibege i ofi. ");
INSERT INTO bxh_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Hige sai laꞌi lahaina yo maihalana i sibai. Anelu galewa yai hinaga hige ti sibai yo Natuna hinaga hige i sibai. Tamana iyabona ya sibai. ");
INSERT INTO bxh_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Au ita komakoman yo au tuhutuhuli! Paꞌana maihalana hige au sibai. ");
INSERT INTO bxh_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Doha taumoho hesa ena nuꞌu ya lau afulen na ya lau eda lofalofa. Ena tau lau fayofayo hesa - hesa ana paisowa ya felen. Luma edaꞌedana hafohafona tau itaꞌita watanina mate ya faliba bena ya tuhutuhuli. ");
INSERT INTO bxh_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Logena bena ami tuhutuhuli paꞌana luma tanuwagana ena fuyoma maihalana hige au sibai. Haba maimailafi e ai iꞌipa atipuna ye kamkam gwanegwane yai ye ya ifi tatatali. ");
INSERT INTO bxh_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ibe i mahanoma feula be i lobahimiu ma enomiu. ");
INSERT INTO bxh_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Somo E fafalibamiu mate haba mahudoꞌidi E falibadi yawa, “Au tuhutuhuli.” ");
INSERT INTO bxh_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Lahai luwaga moho haba Bayawa yo Fwalawa Fafayisti Gesana Anꞌangogodi. Tau antalasam babaꞌisadi yo laugagayo tau lau faꞌataendi, edaꞌeda sa yoꞌo bena bwalabwala yai haba Yesu sa tohai be sa wunui. ");
INSERT INTO bxh_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tiyen, Tabu anꞌangogo yai ta ginauli. Doꞌata dodoga te eli fasifasinadi be lulu sa fatubu. ");
INSERT INTO bxh_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betani nuꞌuna yai Yesu ya kalakalahe lepela dogana hesa hesana Saimon ena luma yai. Waihin hesa maꞌi panepanena hesana nada, maisana ya laꞌi ya abi, na ya luhuma luma yai. Maꞌi botolona gadona ya dem pwai na ya fagoi Yesu bolobolona yai. ");
INSERT INTO bxh_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Dodoga haisa amainiya sa fatalapili tiyen, Sidohana be maꞌi panepanena ya anfagofafogo elaꞌen? ");
INSERT INTO bxh_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Yo fede sa fafatala pili tiyen, Ibe te uneꞌuneyen mate maisana laꞌina doha doga esega ya paisowa bolima esega, na maisana haba tau gogo gesagesa felendi. ");
INSERT INTO bxh_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","In moho Yesu iyen, Sidohana be ami mode lisina yai? I otawa. In laulau loholohona ya ginauli lisigu yai. ");
INSERT INTO bxh_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tau gogo gesagesa fuya ouꞌouli maꞌemiu, na lahai hesa - hesa haba ami saguhidi. In moho, Yau ibege fuya ouꞌouli maꞌemiu. ");
INSERT INTO bxh_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Waihin te, somo gonowana ya ginauli, ya ginauli watan, be taugu ya famaꞌi nonohai, na habahim toletoletau lahaina. ");
INSERT INTO bxh_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","E faliba dudulaimiu mate tanoꞌubu mahudoꞌina yai somo yai wasa loholohona sa lauguguyaꞌen, mate waihin te somo haꞌa ya ginauli wasana haba sa fafanuwa hitin. ");
INSERT INTO bxh_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Habahim Diudasi Isakaliyoti, in mate tau famuli wata safuhudohudoꞌi luwaga hesa, ya aulaha ya lau tau antalasam babaꞌisadi lisidi, be Yesu ana ya wewe. ");
INSERT INTO bxh_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ena nuwatuhu ya falibadi, yo fede nuwadi sa amna be sa liba fasunuma mate moni haba sa felen. Habahim Diudasi ya fatubu edaꞌeda ya yoꞌo. ");
INSERT INTO bxh_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Fwalawa Fafayisti Gesana Anꞌangogona lahaina bwaꞌibwaꞌina yai sipi sa lau funuhidi be Bayawa Anꞌangogona sa abi nonohai. Yesu ana hewahewali sa fatiꞌoi tiyen, Haba ꞌe lau ai somo, Bayawa Anꞌangogona ꞌe abi nonohai? ");
INSERT INTO bxh_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yo fede Yesu ana hewahewali luwaga ya fatalahadi iyen, Au lau taon yai taumoho hesa hoꞌowa leduna ya bahebahei haba ya lobahimiu. Au lau watan, ");
INSERT INTO bxh_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","be luma tausomo ainiya ya luhulau, tanuwagana au faliba auwen, “Tanuwaga ya fatiꞌo mate: ‘Maꞌagu hewahewali, Bayawa Anꞌangogona Ai bili tausomo haba ꞌe kalahe?” ");
INSERT INTO bxh_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Bili laꞌilaꞌi hewa yai haꞌa sa faꞌaꞌa nonohai haba ya faꞌitamiu. Ainiya eneheda, au abi nonoha. ");
INSERT INTO bxh_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yo fede ana hewali luwaga sa aulaha sa lau taon yai be somo Yesu ya fatalahadi sa itadi. Amainiya Bayawa Anꞌangogona sa abi nonohai. ");
INSERT INTO bxh_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Maimailafina Yesu maꞌana hewahewali safuhudohudoꞌi luwaga sa mahanoma aba kalahe yai. ");
INSERT INTO bxh_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yesu iyen, E falibamiu mate sai esega ganahewamiu yai, haba agu ya wewe. Dogana maꞌeda te kalakalahe. ");
INSERT INTO bxh_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nuwadi sa heyaya be esega - esega sa fatiꞌo lau Yesu lisina, tiyen, Bena yau? ");
INSERT INTO bxh_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu alinadi ya bui iyen, Safuhudohudoꞌi luwaga ganahewamiu yai, sai esega nimamai maꞌegu ꞌe bwaluidi aiyohe yai, mate in, logena. ");
INSERT INTO bxh_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Doga Natuna haba ya peꞌi doha Buka Tabuna haꞌa ya libaen. In moho agu tau wewe haba heyaheyaya laꞌilaꞌi ya fahoina. Loholohona moho dogana ni tabu ti yosi. ");
INSERT INTO bxh_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Sa kalakalahe na Yesu fwalawa ya abi na ya lauꞌuꞌula lau Yaubada lisina, habahim ya ifi be ana hewahewali ya feledi na iyen, Itete au abi be au an. Itete Yau taugu. ");
INSERT INTO bxh_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Habahim kaputi ya abi na Yaubada ya lautoꞌiyen na ya feledi be mahudoꞌidi adi sa nom. ");
INSERT INTO bxh_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesu iyen, Itete mate yau ꞌwasinagu. Yaubada ena yali fwaufwauna fafaꞌilalana ya tabuliwa dodoga mahudoꞌidi debadi yai. ");
INSERT INTO bxh_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","E faliba dudulaimiu mate wain te ibege ya nom fuyoi ya lau ee–, Yaubada ena Aba Baꞌisa yai haba E nom fuyo. ");
INSERT INTO bxh_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Wana hesa sa wanai mulina yai sa aulaha sa lau Oliwe Piuna. ");
INSERT INTO bxh_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu ya libalau lisidi, Mahudoꞌimiu haba ami lau afulegu na ami gela. Buka Tabuna yai haꞌa ya libaen iyen, “Yaubada haba sipi tau ita watanina ya lau funuhi na sipi haba sa failaulauwidi.” ");
INSERT INTO bxh_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","E mwahuli fuyo ai mulina, haba E bwaꞌi E lau Galili. ");
INSERT INTO bxh_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita iyen, Mahudoꞌidi haba sa suha papa afulem, na Yau hige gonowana. ");
INSERT INTO bxh_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu iyen, Pita, E liba dudulai lisim yai mate iꞌipa te hola kamkam ibege i gwane ma luwaga na haba wa faleleꞌegu ma faihona. ");
INSERT INTO bxh_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita ya aso, iyen, Hige gonowana ya faleleꞌem, haba te peꞌi luwaluwaga. Na ana hewahewali mahudoꞌidi edi liba gonogonowadi. ");
INSERT INTO bxh_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sa laoma Getesemeni nuꞌuna. Yesu ya libalau ana hewahewali lebedi yai iyen, Aiteꞌi au taꞌataꞌai na hola E lau E lauꞌuꞌula. ");
INSERT INTO bxh_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pita, Diyemsi yo Diyon maꞌedi Yesu sa lau. Nuwa kamkamna laꞌilaꞌi yo nuwa mwahu ya laoma tauna ya famohafu. ");
INSERT INTO bxh_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yo fede ya falibadi iyen, Nuwa heyaya nuwagu yai ya laꞌi wananaha begana haba ya kamfunuhigu. Aiteꞌi au miyamiya na au tuhutuhuli. ");
INSERT INTO bxh_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Begana ya sigilau, ya lofe lidiyen tanohi yai na ya lauꞌuꞌula iyen, Yena gonowana, ibege kamkamna lahaina te ya fahoina. ");
INSERT INTO bxh_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ya lauꞌuꞌula iyen, Aba, Tamagu, ginauli mahudoꞌidi um gonowam. Kamkamna te u abi fahi lisigu yai. In moho hige yau egu fanuha, um em fanuha. ");
INSERT INTO bxh_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Habahim ya fuyo ana hewahewali faihona lisidi na ya itadi sa enoꞌeno. Ya libalau Pita lebena, Saimon, wa eno? Hige gonowana u tuhutuhuli awa esega moho? ");
INSERT INTO bxh_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Au tuhutuhuli yo au laulauꞌuꞌula haba ibege lau lubu au fahoina. Yaluwamiu sa nonoha na taumiu sa belubelu. ");
INSERT INTO bxh_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Maꞌesega moho ya lau afuledi na ya fuyo ya lauꞌuꞌula. Libadi gonogonowadi ya libaedi. ");
INSERT INTO bxh_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ya fuyoma ana hewahewali lisidi ya itadi sa maimaiduꞌe be hige somo ti faliba. ");
INSERT INTO bxh_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Fafaihonana ya fuyoma na ya falibadi iyen, Hola ma enomiu? Ma anyawasimiu? Maihalana ya mahano! Haꞌasi, Doga Natuna aho te sa fele lawen dodoga heyaheyayadi lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Au obiyo ta lau! Agu tau wewe ya laoma! ");
INSERT INTO bxh_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu ma libalibana yo fede Diudasi, in safuhudohudoꞌi luwaga hesa, maidana dodoga boludi ma baibainetidi yo ma kepakepatadi sa mahanoma. Iti mate tau antalasam babaꞌisadi, babada yo laugagayo tau lau faꞌataendi sa duidima. ");
INSERT INTO bxh_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tau wewe mate fafaꞌilala hudoꞌi haꞌa babaꞌisa ya falibadi iyen, Sai E falafu mate logenana. Au tohai be au lawen, na ami gati komokomaniꞌi. ");
INSERT INTO bxh_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Fuyana Diudasi ya mahano ya dudulai ya lau Yesu lisina iyen, Tanuwaga! Na ya falafu. ");
INSERT INTO bxh_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Yo fede Yesu sa tohai be sa lawen. ");
INSERT INTO bxh_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tau obiꞌobiyo hesa amainiya ena baineti ya faguli be Tau Antalasam edi Baꞌisa ena tau lau fayofayo beyana ya talafahi. ");
INSERT INTO bxh_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Alinadi Yesu ya bui iyen, Bena Yau tau angafu? Logena ma baibainetimiu yo ma kepakepatamiu ami laoma ami augu. ");
INSERT INTO bxh_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Fuya ouꞌouli yau maꞌemiu Dubu Tabuna dobidobina yai E laulau faꞌata na hige au augu. In moho Buka Tabuna bena ya fawananaha. ");
INSERT INTO bxh_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Habahim ana hewahewali mahudoꞌidi sa gela afulen. ");
INSERT INTO bxh_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Hewali hudoꞌi ya lau kaleko na Yesu ya laulau watan mate sa tohai, ");
INSERT INTO bxh_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","yo fede ya dalu peidi be kaleko ya taufahi na ma tau afa afaꞌafana ya gela. ");
INSERT INTO bxh_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yesu sa lawen Tau Antalasam Baꞌisana lisina na tau antalasam haisa, babada lalaꞌi yo laugagayo tau lau faꞌataena mate sa faꞌoigogo amainiya. ");
INSERT INTO bxh_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita muli yai ya laoma be ya luhulau Tau Antalasam edi Baꞌisa ena luma dobidobina yai. Be maidana gati sa taꞌai na ya anmwahibo. ");
INSERT INTO bxh_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tau Antalasam edi Baꞌisa yo Sanhedeli mahudoꞌidi edi fanuha bena liba wananaha laꞌi sa lobahidi, haba ainiya bena Yesu sa wunui. In moho hige somo laꞌi ti lobahi. ");
INSERT INTO bxh_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tau fagiluna boludi edi liba bwalabwala sa libaedi mate hesa - hesa ena ya laulau hudoꞌi. ");
INSERT INTO bxh_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Haisa sa obiyo be liba bwalabwala sa libaedi Yesu lisina yai tiyen, ");
INSERT INTO bxh_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ꞌE atahi ya libaliba iyen, “Dubu Tabuna dodoga sa ginauli haba E dem lopa. Na lahai faihona ganahewadi yai hesa haba E faꞌobiyo fuyoi. Dubuna mate hige dodoga nimadi yai ti ginauli.” ");
INSERT INTO bxh_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Hesa - hesa ena liba ya lau hudohudoꞌi. Hige edi liba esega. ");
INSERT INTO bxh_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tau Antalasam edi Baꞌisa ya obiyo mahudoꞌidi matadi yai na ya fatiꞌo lau Yesu lisina iyen, Sa fagilum te haga alinadi u bui. ");
INSERT INTO bxh_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","In moho Yesu hige somo laꞌi i libaen. Yo fede Tau Antalasam edi Baꞌisa ya fatiꞌo fuyoi iyen, Um Keliso, Loholoho Tau Abina Natuna? ");
INSERT INTO bxh_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu iyen, Yau, Logegu. Haba Doga Natuna ya taꞌataꞌai Gigibwali Yaubadana sibana yai na yada yai ya laolaoma, ami ita. ");
INSERT INTO bxh_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tau Antalasam Baꞌisana ena leli ya ankamgiginidi na iyen, Hei! Hige gonowana wikinisi hesa haba ta yoꞌoi! ");
INSERT INTO bxh_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yesu ya liba pono iyen, “Yau maꞌegu Yaubada gonogonowamai.” Ami atahi! Emi nuwatuhu somo? Mahudoꞌidi sa fagilu, be ehe watawatan tiyen, Ii–, peꞌi moho. ");
INSERT INTO bxh_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Habahim haisa Yesu sa lau kanikanisoi Matana sa suma yo sa talai na tiyen, U anmasi, sai ya talaim! Habahim gati sa lawen be sa lau papaliꞌi. ");
INSERT INTO bxh_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita mate hola luma dobidobina yai na Tau Antalasam edi Baꞌisa ena tau lau fayofayo waihinna ya laoma, ");
INSERT INTO bxh_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ya italau be Pita ya ita ya anꞌanmwahibo yo fede iyen, Um hinaga maꞌem Yesu Nasaleta. ");
INSERT INTO bxh_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","In moho Pita ya falele iyen, Somo wa libalibaen hige ya nuwatuhu lobahi! Yo fede edaꞌeda hafohafona yai ya kalamahano na kamkam ya gwane. ");
INSERT INTO bxh_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tineꞌeu wa ya itaꞌita lau be Pita ya ita fuyoi yo fede tau obiꞌobiyo ya falibadi iyebom, Ite ana hewali hesa. ");
INSERT INTO bxh_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","In moho Pita ya falele boda. Hige walolona na dodoga sa obiꞌobiyo Pita sadaina yai sa faliba tiyen, Wananaha! Um hidana hesa. Paꞌana um Galili yai wa laoma. ");
INSERT INTO bxh_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pita ya angwala dodoga lisidi iyen, Taumohona ami libalibaen hige ya sibai. ");
INSERT INTO bxh_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hige walolona kamkam ya gwane boda. Yo fede Yesu ena liba Pita ya nuwatuhuidi fuyana ya faliba iyen, Ibege hola kamkam i gwane ma luwaga na haba wa falele ma faihona mate hige u sibaigu. Yo fede Pita ya tan eloꞌelolosi. ");
INSERT INTO bxh_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ma hwalahwalalana tau antalasam babaꞌisadi, dodoga lalaꞌi, laugagayo tau lau faꞌataena yo Sanhedeli mahudoꞌidi sa faꞌoigogo na edi sa oiliba be Yesu sa au na sa lawen Pailati lisina. ");
INSERT INTO bxh_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailati ya fatiꞌo lau Yesu lisina iyen, Um Diusi edi Kin? Alinana, Yesu ya bui iyen, Ii–, logena. ");
INSERT INTO bxh_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tau antalasam babaꞌisadi ginauli mahudoꞌidi debadi yai Yesu sa fagilu. ");
INSERT INTO bxh_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pailati ya fatiꞌo bodai iyen, Ginauli boludi haladi yai sa fagilum be alinadi haga u bui? ");
INSERT INTO bxh_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","In moho, Yesu hola hige i libaliba, be Pailati ya noꞌo. ");
INSERT INTO bxh_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bayawa Anꞌangogona yai edi laulau mate tau lau deli esega, sai sa fanuha haba Pailati ya soꞌefahi. ");
INSERT INTO bxh_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Doga hesa hesana Balabasi ma haidana haisa hiyala sa fatubu maidadi gabeman be sa aiyunu. Yo fede halana yai sa lau deli. ");
INSERT INTO bxh_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Baiwa sa laoma be Pailati sa anꞌetai, bena doga hesa ai deli ya soꞌefahi. ");
INSERT INTO bxh_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailati ya fatiꞌoidi iyen, Ami fanuha bena Diusi emi Kin E soꞌefahi? ");
INSERT INTO bxh_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailati ya sibai mate tau antalasam babaꞌisadi Yesu sa nuwa elaꞌelaꞌen, logena sa leyama lisina. ");
INSERT INTO bxh_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","In moho tau antalasam babaꞌisadi mate dodoga sa eli fasifasinadi be tiyen, Balabasi u soꞌefahi! ");
INSERT INTO bxh_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailati ya libalau lisidi, iyen, Aho auwen, “In Diusi edi Kin.” Haba somo ai lisina E ginauli? ");
INSERT INTO bxh_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Sa yogayoga tiyen, U tutu fapatu! ");
INSERT INTO bxh_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailati ya fatiꞌo, Sidohana? Pilipili somo ya ginauli? Sa yoga laꞌilaꞌi tiyen, U tutu fapatu! ");
INSERT INTO bxh_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailati ena fanuha bena dodoga nuwadi ya faloholohodi, yo fede Balabasi ya soꞌefahi. Habahim ya liba be Yesu sa pidili yo bena haba sa lawen sa tutu fapatu. ");
INSERT INTO bxh_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Hiyala dodogadi Yesu sa lawen Gawana ena Luma dobidobina yai na faledi tau hiyala sa yoga gogondi. ");
INSERT INTO bxh_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Yesu mate Kin edi leli kapikapitana sa faliꞌo na kokukoku sa ginauli nulinuli yai be kuluna yai sa fakoku. ");
INSERT INTO bxh_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sa yogalau lisina tiyen, Diusi edi Kin! Um mwahulim, hige ana siga! ");
INSERT INTO bxh_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kuluna yai sa oiꞌoi, sa lau kanisoi yo sa tulibono be edi fadebasae bwalabwala sa ginauli. ");
INSERT INTO bxh_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Sa laulau faliuhwaꞌen ya ofi, luhuluhu kapikapitana sa unufahi na ana leli sa faliꞌo fuyoi. Habahim sa foya lawen Yelusalem ganamulina yai be bena sa tutu fapatu. ");
INSERT INTO bxh_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Na Sailin dogana hesa hesana Saimon nuꞌu kiukiu yai ya laolaoma duhu laꞌi ganahewana. Na hiyala dodogadi sa bayahoi be Yesu aba tutu fapatuna ya bahei. Saimon nanatuna mate Alesandiya yo Lufosi. ");
INSERT INTO bxh_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yesu sa foya lawen nuꞌu hesa hesana Gologota. (Aniyona mate Kulukulu Nuꞌuna.) ");
INSERT INTO bxh_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Amainiya mate wain maꞌena kamkamna mulamulana sa faꞌasi esegahidi be sa felen. Na hige i nom. ");
INSERT INTO bxh_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Sa tutu fapatu mulina yai, ana leli sa pei dailidi na habahim sa pelei be haba sai tausomo ya wini mate ya abi, enehena. ");
INSERT INTO bxh_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yesu edi fuya tutu fapatuna mate naen koloki hwalahwalala. ");
INSERT INTO bxh_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Edi aba fagiluna sa uli oyagi tabatabana yai tiyen, “Diusi edi Kin,” mate sa tutu fapatu Yesu kuluna maitina yai. ");
INSERT INTO bxh_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Tau angafu luwaga hinaga sa tutu fapatudi, esega sibana yai, na esega seuseulina yai. Logena, sa fawananaha Buka Beyabeyana yai, tiyen, “In maꞌedi dodoga heyeheyayadi sa tutu fapatudi.” ");
INSERT INTO bxh_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Dodoga sa bayabayawa mate sa liba fafaheyaya yo kuludi sa fafakwadedi na tiyen, Agu ya moꞌisa! Um bena Dubu Tabuna wa dem lopalopa na lahai faihonana yai haba wa faꞌobiyo fuyoi! ");
INSERT INTO bxh_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","U fofofahi fuyoim be ai aba tutu fapatum ni u tulu beꞌuma! ");
INSERT INTO bxh_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tau antalasam babaꞌisadi yo laugagayo tau lau faꞌataena hinaga Yesu sa lau faliuhwaꞌen tiyen, Haisa ya fofofahidi na in hige gonowana i fofofahi fuyoi. ");
INSERT INTO bxh_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Keliso, Isalaela eda Kin, aho te haga ai aba tutu fapatum ni u tulu beꞌuma be ai itam. Haba ꞌe kawawananahaꞌem. Salumadi Yesu maꞌedi sa tutu fapatudi mate Yesu sa liba fafaheyaya hinaga. ");
INSERT INTO bxh_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Lahai laꞌi yai nuꞌu mahudoꞌina mate ya kamumu esegahi ee–, awa faihona. ");
INSERT INTO bxh_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tili koloki yai Yesu ya yoga laꞌilaꞌi iyen, Eloi! Eloi! Lama sabatani? Aniyona mate, Egu Yaubada! Egu Yaubada! Paꞌana somo wa nuwa afulegu? ");
INSERT INTO bxh_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Dodoga haisa amainiya sa obiꞌobiyo sa atahi be tiyen, Au atahi. Ilaidiya ya yogayogai. ");
INSERT INTO bxh_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Taumoho hesa ya lautafo be bwalofi ya abi ya bwalu lidiyen wain tabutabuluna yai na didiyali yai ya gwaliyen be ya lolo hasaen Yesu gibulana yai na iyen, Haga ta ita! Ilaidiya bena haba i laoma i taluhi? ");
INSERT INTO bxh_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu ya ꞌwalaꞌui yo fede ya tuhufahi. ");
INSERT INTO bxh_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Bili daili kalekona Dubu Tabuna ganahewana yai ya tapuliti luwagai, hewa yai ya lidi ubu. ");
INSERT INTO bxh_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Hiyala tau lau kulukuluwena ya obiꞌobiyo Yesu nuwanuwana yai mate sidohana Yesu ena peꞌipeꞌi ya ita. Na iyen, Doga itete mate wananaha Yaubada Natuna. ");
INSERT INTO bxh_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wawahin haisa mate eda lofalofa yai sa itaꞌitama. Ganahewadi yai mate Maliya Magadala, Salome yo Maliya hudoꞌi (Diyemsi kiukiu yo Diyosesi tinadi). ");
INSERT INTO bxh_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Fuyana Yesu Galili yai mate, wawahin te sa lau watan yo sa sagusaguhi. Na hahaisa maꞌedi sa lau Yelusalem mate amainiya hinaga. ");
INSERT INTO bxh_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Abi Nonoha Lahaina na maimailafina Sabati faꞌatitina ya fatubu. Yo fede Alamatiya dogana hesana Diyosepa ma nuwa adidilina ya lau Pailati lisina be Yesu silanna ya anꞌetai. In mate Konisela hesa Sanhedeli ganahewana yai na sa fafaꞌatitiyen. Yaubada Aba Baꞌisa Nuꞌuna ya laolaoma ibona ya bagibagiyen. ");
INSERT INTO bxh_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Fuyana Pailati ya atahiyen Yesu haꞌa ya peꞌi mate ya tauhiti. Yo fede hiyala tau lau kulukuluwenna ya yogai be somo ya atahiyen wa, ya fatiꞌoi be tau hiyala iyen, Wananaha, haꞌa ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pailati ya fawananaha mate haꞌa ya peꞌi. Yo fede ya liba be Yesu silanna Diyosepa ya abi. ");
INSERT INTO bxh_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Habahim Diyosepa silanna ya taluhi lidiyen, na kaleko loholohona ya une amainiya ya suma. Bwanali haꞌa sa pidi nonohai galina yai ya boꞌusai. Habahim umeꞌehu ya fatapipili be ya gudu buluhi. ");
INSERT INTO bxh_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maliya Magadala yo Maliya Diyosesi tinana Yesu aba boꞌusaina sa ita. ");
INSERT INTO bxh_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabati lahaina mulina, Maliya Magadala, Salome yo Maliya Diyemsi tinana maꞌi panepanedi sa unedi. Bena bobonna haba sa lau Yesu silanna sa famaꞌi. ");
INSERT INTO bxh_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bobonna, nuꞌu ya ifi tatatali na sa aulaha sa lau boꞌusa. ");
INSERT INTO bxh_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Edaꞌeda yai sa laulau na ibodi sa fatiꞌo fuyoꞌidi, tiyen, Sai haba umeꞌehu boꞌusa hafohafona yai ni ya fatapipili? Sa tamahiti mate boꞌusa guduna umeꞌehu laꞌilaꞌi haꞌa sa fatapipili. ");
INSERT INTO bxh_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Sa luhulau boꞌusa yai mate taumoho hewahewalina ena leli kafukafuna tefa siba yai ya taꞌataꞌai. Yo fede aluwadi sa potifahi. ");
INSERT INTO bxh_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Na iyen, Tabu au ꞌwasabu. Yesu Nasaleta, In sa tutu fapatu, ami yoꞌoyoꞌoi. Haꞌa ya obiyo fuyo! In hige amaiteꞌi. Edi aba tolena haꞌa ami ita. ");
INSERT INTO bxh_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Au lau be ana hewahewali Pita ma haidana au falibadi auwen, “In haba ya bwaꞌi Galili. Ainiya haba ami ita, doha haꞌa ya falibamiu.” ");
INSERT INTO bxh_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Wawahin wa sa tauhiti na ma tabutabubudi sa gela sa lau boꞌusa ganamulina. Hige sai somo ti faliba paꞌana sa ꞌwasabu. ");
INSERT INTO bxh_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sandei hwalahwalalana Yesu peꞌi yai ya obiyo fuyo na ya taumahata bwaꞌi Maliya Magadala lisina yai. In, logena, yaluwa heyaheyayadi faligigi-luwaga ganahewana yai ya liba duidi. ");
INSERT INTO bxh_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Salumadi ma afa haidana sa logo yo sa tantan mate, enehedi ya liba iyen, ");
INSERT INTO bxh_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yesu ya mwahuli fuyo! Yau E ita! In moho hige ti kawawananahaꞌen. ");
INSERT INTO bxh_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mulina yai Yesu ya taumahata dodoga luwaga lisidi yai fuyana sa laulau nuꞌu hesa. Nenena ya sedi be hige ti ita lobahi. ");
INSERT INTO bxh_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Sa fuyo be haidadi sa falibadi. In moho hige ti kawawananahaꞌedi. ");
INSERT INTO bxh_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ofiꞌofina yai Yesu ya taumahata ana hewahewali safuhudohudoꞌi esega lisidi yai fuyanna sa kalakalahe. Ya sagasagaliyedi paꞌana sa nuwa poꞌi yo salumadi Yesu sa ita ya obiyo fuyo mate hige ti kawawananahaꞌedi. ");
INSERT INTO bxh_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ya libalau lisidi iyen, Au lau tanoꞌubu mahudoꞌina yai wasa loholoho te, dodoga ai lisidi au duwai. ");
INSERT INTO bxh_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sai ya kawawananaha be sa fababasito haba ya mwahuli, In moho, sai hige i kawawananaha haba ena heyaya debana yai sa fagilu. ");
INSERT INTO bxh_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tau kawawananaha haba noꞌo ginaulidi sa lau ginauli. Dimoni haba ai hesagu sa liba duidi yo alina hesa - hesa yai haba sa libaliba. ");
INSERT INTO bxh_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Yena weso ai nimadi sa abidi yo anꞌanlewa sa nomdi ibege ti peꞌi yo sa abilau tau asiꞌasiyebo ai lisidi haba sa loholoho. ");
INSERT INTO bxh_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Guyau Yesu ya libaliba ofi mulina yai, sa hasaen Galewa be Yaubada sibana yai ya taꞌai. ");
INSERT INTO bxh_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Habahim ana hewahewali sa lau sa lauguguya nuꞌu ouꞌouli yai. Na Yaubada ya saguhidi be ena liba ya fawananaha fafaꞌilala lisidi yai. Maleko 16:9-10 9-10 Wawahin sa lau be liba tupotupona Pita ma afa haidana sa falibadi. Muli yai Yesu ana hewahewali ya fatamalidi sa lau, tefa saisai yai yo tefa leuleu yai be wasa tabuna yo miya lofalofana yo mwahuli otaꞌotafahina wasana sa falibadi. ");
INSERT INTO bxh_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Yauwedo, Yaubada Tau Fanuhana egu buka bwaꞌibwaꞌina yai ginauli somo E ulidi mate ginauli mahudoꞌidi Yesu ya fatubu ya ginauli yo ya lau faꞌataen, haꞌa enehemiu E liba ya lau ee–, sa hasaiyen galewa. ");
INSERT INTO bxh_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Hola hige Yaubada i hasaen galewa na safalumadi ya fasinabodi be ena tau faꞌona wasawasa ya liba fasibasibadi Yaluwa Tabuna ena gigibwali yai. ");
INSERT INTO bxh_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ena peꞌi mulina yai ya taumahata tatau te, lisidi yai ma boludi laulau hudoꞌi - hudoꞌi yai be ya faꞌita lobahidi mate In ya mwahuli fuyo. Lahai 40 ganahewadi yai ya taumahata lisidi yai na Yaubada ena Aba Baꞌisa Nuꞌuna wasana enehedi ya liba. ");
INSERT INTO bxh_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Fuya hesa, maꞌedi sa kalakalahe na ya falibadi iyen, Tabu Yelusalem au lau afulen, na ainauya E falibamiu au bagiyen. Ainauyana mate Tamagu ya liba fasunumaꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Diyon hoꞌowa yai ya fafababatisomiu na lahai fisa ai mulina haba Yaluwa Tabuna yai ami babasito. ");
INSERT INTO bxh_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Fuyana sa faꞌoigogo esega sa fatiꞌoi tiyen, Guyau, aho te ema nuꞌu Isalaela haba wa fele fuyoꞌimai e higeꞌe? ");
INSERT INTO bxh_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu alinadi ya bui iyen, Maihaladi e lahaidi mate Tamagu ena gigibwali yai ya nonohaidi. Umi hige enehemiu be haba adi fuya au sibaidi. ");
INSERT INTO bxh_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Fuyana Yaluwa Tabuna ya laoma ai hewamiu haba gigibwali Yaubada ai lisina ami abi be ai Yelusalem, Diudeya yo Samaliya mahudoꞌina yo tanoꞌubu anadan yai haba ami liba famahatagu. ");
INSERT INTO bxh_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ya libaliba ofi, mulina yai, matadi yai Tamana ya abi hasaen galewa, yada yai be hige gonowana ti ita. ");
INSERT INTO bxh_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Hola matadi sa alalolo lau galewa na yo fede tatau luwaga adi leli kafukafudi sa mwaito afuledi sadaidi yai. ");
INSERT INTO bxh_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Na tiyen, Galili tatau sidohana be amainiya ami obiꞌobiyo na ami maimainene hasa galewa? Yesu ite lebemiu yai sa abi hasaen galewa te, mate haba ya fuyoma gonogonowana doha ami ita ya hasai. ");
INSERT INTO bxh_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Habahim Oliweta Piuna sa lau afulen na sa fuyo Yelusalem. Nuꞌudi te lofana doha kilomita esega. ");
INSERT INTO bxh_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Fuyana sa mahano, sa hasai edi aba miyamiya bilina yai. Iti mate Pita, Diyon, Diyemsi yo Endulu; Pilipi yo Tomasi, Batolomiu yo Matiu; Alefaiyesi natuna Diyemsi yo Saimon Seloti yo Diyemsi natuna Diudasi. ");
INSERT INTO bxh_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Fuya ouꞌouli sa fafaꞌoigogo na sa laulauꞌuꞌula ma haidadi wawahin yo Yesu haidana yo tinana Maliya hinaga. ");
INSERT INTO bxh_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Lahaidi yai ni Yesu tau kawawananahaina 120 ganahewadi yai, Pita ya obiyo fahi ");
INSERT INTO bxh_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","be iyen, Afa haidagu! Beyabeyana, Buka Tabuna yai sa uli tiyen, Yaluwa Tabuna ena gigibwali yai, Deiwidi, Diudasi wasana ya libaen mate haꞌa ya fawananaha fuyanna Yesu ana waiyuna ya foyahidi be sa tohai. ");
INSERT INTO bxh_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Diudasi hidamai hesa ema pele yai yo paisowa tau saguhimai. ");
INSERT INTO bxh_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ena lau pono maisana monina ya abi be tanohi ya une. Tanohina yai mate ya fatutu baꞌa be ya peꞌi. Bogana ya tamo dagi be tagina mahudoꞌina ya faikalamahanoi. ");
INSERT INTO bxh_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Dodoga mahudoꞌidi Yelusalem yai wasana sa atahiyen be alinadi yai nuꞌuna hesana sa tole “Akeladama.” Aniyona mate “ꞌWasina Nuꞌuna.”) ");
INSERT INTO bxh_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita iyen, Samsi bukana yai sa uli tiyen, “Ena luma haba afaꞌafana, ibege sai i gogoi,” yo sa uli hinaga tiyen, “Sai hesa ana paisowa i abi.” ");
INSERT INTO bxh_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Lisina yai hidada hesa bena te fasinabo. In yo Yesu maꞌeda fuya ouꞌouli te laulau asiꞌasi. ");
INSERT INTO bxh_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Diyon ena fuya fafababatiso ya lau ee–, Yaubada, Yesu lebeda yai ya abi hasaen galewa. Sai te famwaito, maꞌeda ena mwahuli fuyo dedena haba te fatadada. ");
INSERT INTO bxh_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Yo fede dodoga luwaga hesadi sa fafinahedi: Mataiyasi yo Diyosepa, hesana hesa Basabasi na hesa Diyusitusi. ");
INSERT INTO bxh_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Na sa lauꞌuꞌula tiyen, Guyau, doga mahudoꞌina ena nuwatuhu wa sibai. Tatau luwaga te u faꞌitamai. Sai wa fasinabo haba tau faꞌona wasawasa adi paisowa ya ginauli, fuyana Diudasi ya biya afulen na ya lau ena aba laoma. ");
INSERT INTO bxh_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Habahim dodoga luwaga ni, sa aiheya failakoꞌedi umeꞌehu yai be Mataiyasi ya abi. Sa falau esegahi maidana tau faꞌona wasawasa 12 edi pei yai. ");
INSERT INTO bxh_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Fuyanna Pentekosi lahaina yai Tau kawawananaha mahudoꞌidi sa faꞌoigogo tefa esega yai. ");
INSERT INTO bxh_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Maꞌesega na dagugu laꞌilaꞌi doha hwayahwayau galewa yai ya lidima be aba taꞌataꞌai lumana ya tafo nuhuli. ");
INSERT INTO bxh_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Habahim somo doha oyagi balebalelemna ya faidabadabalalai be doga esega - esega ya talu hewana yai. ");
INSERT INTO bxh_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Yaubada, Yaluwana Tabuna mahudoꞌidi ya famohafudi be gigibwalina yai sa fatubu alina hudoꞌi - hudoꞌi yai sa libaliba. ");
INSERT INTO bxh_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Fuyana yai Diusi iti Yaubada tau ꞌwasabuwenna nuꞌu mahudoꞌina yai sa faꞌoigogo esegahidi Yelusalem yai. ");
INSERT INTO bxh_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Dagugu sa atahiyen be baiwa laꞌilaꞌi ya faꞌoigogoma be somo - somo sa libalibaen mate, esega - esega alina yai ya atahi lobahi. ");
INSERT INTO bxh_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Sa tauhiti ma lau noꞌodi tiyen, Hola au atahi. Dodoga mahudoꞌidi sa libaliba te mate Galili dodogadi. ");
INSERT INTO bxh_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Sidohana be esega - esega te atahi alinada yai sa libaliba? ");
INSERT INTO bxh_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ita eda aba laoma mate: Patiya yai, Mediya yai, na haisa Elam yai. Ita hahaisa mate Mesopotamia yai, Diudeya, Kapadosiya, Pontusi yo Eisiya yai, ");
INSERT INTO bxh_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","yo Figiya, Pamfiliya, Idipi yo Libiya tefadi yai, Sailin nuꞌuna sadasadaina yai te laoma. Na hahaisa mate tau antaumana Loma yai sa laoma Yelusalem. ");
INSERT INTO bxh_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Diusi yo taꞌowawa safaluma Diusi edi laulauꞌuꞌula sa laulau watan, yo Keliti yo Alabiya, mahudoꞌida te atahi mate Yaubada laulau gigigibwalidi yo noꞌo ginaulidi, te atahiyedi alinada yai! ");
INSERT INTO bxh_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Sa noꞌo yo sa nuwa ponopono be sa fafatiꞌo fuyoꞌidi tiyen, Ite aniyona somo? ");
INSERT INTO bxh_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Na hahaisa sa lau faliuhwaꞌedi tiyen, Sa nom yauyaule? ");
INSERT INTO bxh_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Habahim Pita yo tau faꞌona wasawasa safuhudohudoꞌi esega sa obiyo fahi na ya liba laꞌilaꞌi baiwa lisidi iyen, Falegu Diusi yo salumadi mahudoꞌimiu Yelusalem yai ami miyamiya, au ataꞌatahi laoma lisigu na aniyona somo haba emi E liba. ");
INSERT INTO bxh_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Emi nuwatuhu bena tatau te sa nom yauyaule. Higeꞌe! Itete hola 9 koloki ma hwalahwalalana. ");
INSERT INTO bxh_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Itete fuya bwaꞌibwaꞌina yai Peloweta Diyoweli haꞌa ya libaen: ");
INSERT INTO bxh_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Yaubada iyen, “‘Fuya ofiꞌofidi yai haba Yaluwagu E fagoi dodoga mahudoꞌidi ai lebedi. Yo nanatumiu wawahin yo tatau haba sa liba peloweta. Ami hewahewali haba tautau sa itadi, yo emi tautaulaꞌi haba sa eno suwai. ");
INSERT INTO bxh_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Yo egu tau paisowa tatau yo wawahin lahaidi yai ni haba Yaluwagu E fagoi ai lebedi, be haba wasa loholohona sa lauguguyaꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Noꞌo abiꞌabidi haba E ginaulidi ai galewa, yo ai tanoꞌubu. Haba fafaꞌilala, ꞌwasina yo oyagi balebalelemdi yo madagafu E fataumahatadi. ");
INSERT INTO bxh_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Maihala haba ya kamukamumu, na Guyau ena fuyoma lahaina haꞌa ya sigisigima. ");
INSERT INTO bxh_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Yena sai Guyau hesana ya ataꞌatahi haba ya mwahuli.” ");
INSERT INTO bxh_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita iyen, Isalaela dodogadi, au ataꞌatahi! Ganahewamiu yai Yesu Nasaleta ena dudulai Yaubada ya fawananaha, logena lisina yai noꞌo yo fafaꞌilala ya ginaulidi mate umi ami sibaidi. ");
INSERT INTO bxh_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yaubada ena nuwatuhu yai Yesu ya fasinabo nonohai be sa tole afulen nimamiu yai, na dodoga heyaheyayadi sa saguhimiu be ami tutu fapatu kolosi yai. ");
INSERT INTO bxh_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","In moho Yaubada ya famwahuli fuyoi peꞌi kamkamnana yai paꞌana peꞌi hige gonowana i abi didini. ");
INSERT INTO bxh_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kin Deiwidi haꞌa ya libaen iyen, “Fuya ouꞌouli Yaubada sadaigu yai E itaꞌitai. Paꞌana In maꞌegu, be ibege agu waiyunu ya ꞌwasabuwedi.” ");
INSERT INTO bxh_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Lisina yai nuwagu ya amna be E kwade yo E fadebasae. Yo E gogo susunuma mate taugu haba ya anyawasi, ");
INSERT INTO bxh_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","paꞌana ibege tau peꞌipeꞌi edi nuꞌu yai u lau afulegu, yo ibege em Fatabu Dogana u ita afulen, be tauna i molu ai boꞌusa. ");
INSERT INTO bxh_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mwahuli edaꞌedana haꞌa wa faꞌitagu; Yo Um ai matam haba E kwade wananaha. ");
INSERT INTO bxh_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Afa haidagu, E faliba komakomaꞌinimiu mate ada ulu tubu Deiwidi haꞌa ya peꞌi be sa boꞌusai na boꞌusana mate hola otana amaiteꞌi. ");
INSERT INTO bxh_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","In mate peloweta na ya sibai mate Yaubada haꞌa ya angwala lisina yai haba Deiwidi laulauwewena hesa ya famala Baꞌisa gonogonowana doha in Deiwidi. ");
INSERT INTO bxh_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Fuya matada yai somo haba ya tubu, mate Deiwidi haꞌa ya sibai, be ya liba iyen, “Keliso haba ya mwahuli fuyo, yo ibege ai boꞌusa i ita afulen be silanna i molu.” ");
INSERT INTO bxh_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Boꞌusa yai Yaubada, Yesu te ya famwahuli fuyoi, be matamai yai haꞌa ꞌe ita. ");
INSERT INTO bxh_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Tamana Yaubada ya tole hitiꞌi be sibana yai aba fafaꞌatiti yai ya taꞌai. Ena liba fasunuma mate Yaluwa Tabuna ya felen, Yesu. Logena ya fagoi lidiyen hewada yai mate, haꞌa ami ita yo ami atahiyen. ");
INSERT INTO bxh_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Deiwidi hige i hasai galewa. In moho ya liba iyen, “Guyau Yaubada ya libalau egu Guyau lisina iyen, ‘Ai sibagu u taꞌai, ");
INSERT INTO bxh_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ya lau ee–, am waiyunu E toledi ai ahem ubudi doha ahem aba tolena.” ");
INSERT INTO bxh_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Lisina yai Isalaela mahudoꞌidi bena sa siba komakomaꞌi mate Yesu te, In ami tutu fapatu, logena Yaubada ya tole Guyau yo Keliso. ");
INSERT INTO bxh_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Dodoga liba te sa atahiyen. Yo fede aluwadi sa potifahi be Pita yo tau faꞌona wasawasa hahaisa sa falibadi tiyen, Afa haidamai somo haba te ginauli? ");
INSERT INTO bxh_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita alinadi ya bui iyen, Esega - esega u nuwabui be u babasito Yesu Keliso hesana yai haba em heyaheyaya ya nuwa afulen na Yaubada ena ainauya, Yaluwa Tabuna wa abi. ");
INSERT INTO bxh_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Liba fasunuma te ya laowa umi, nanatumiu yo safalumadi iti eda lofalofa yai tau miya enehemiu yo safalumadi Guyau eda Yaubada ya yogaimiu, enehemiu. ");
INSERT INTO bxh_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Habahim, Pita ya lauguguya lofalofa na ya liba adidili lau tau ataꞌatahi lisidi yai iyen, Yaubada au anꞌetai be hiti heyayana ganahewadi yai te, haba ya saguhimiu be ami anfaleꞌedi. ");
INSERT INTO bxh_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Safalumadi ena liba sa lau watan mate sa fababatisodi na lahaina yai dodoga laꞌina tausan faihona sa lobahi be sa falau esegahi tau faꞌona wasawasa edi pei yai be edi pei ya laꞌi. ");
INSERT INTO bxh_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Edi fuya sa peidi tau faꞌona wasawasa edi lau faꞌata yai yo edi faꞌoigogo yai sa anꞌangogo yo sa laulauꞌuꞌula gogo. ");
INSERT INTO bxh_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Noꞌo ginaulidi boludi yo fafaꞌilala hudoꞌi - hudoꞌi tau faꞌona wasawasa sa laulau ginauli be dodoga sa ꞌwasabu. ");
INSERT INTO bxh_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tau kawawananaha mahudoꞌidi sa fafaꞌoigogo fuya ouꞌouli yo ginauli mahudoꞌina lebedi yai sa faifaisagusagu fuyoꞌidi. ");
INSERT INTO bxh_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Edi tanohi yo edi ginauli sa uneꞌune afuledi na monidi sa abidi be faledi tau kawawananaha salumadi ginauli hahaisa lebedi yai, higeꞌe mate edi sa soi. ");
INSERT INTO bxh_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Lahai esega - esega sa faꞌoigogo ai Dubu Tabuna dobidobina yo edi ai luma sa kalahe gogo ma nuwa taludi yo ma kwadedi, ");
INSERT INTO bxh_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","lahai esega - esega salumadi sa anꞌeta be Yaubada ya famwahulidi mate sa falau esegahidi, be tau kawawananaha edi pei ya laꞌi. Yaubada sa fadebasae, yo dodoga edi abi loholoho sa kwadedi. ");
INSERT INTO bxh_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Fuya ma esega lauꞌuꞌula maihalana yai, Pita yo Diyon sa hasai Dubu Tabuna. Maihalana mate tili koloki maimailafi. ");
INSERT INTO bxh_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Lahaina yai ni taumoho hesa ahe dabidabina sa bahe lawen dubu edaꞌedana hesa hesana “Aba Luhuluhu Lau Loholohona.” Dogana ni tinana bogana yai haꞌa doha. Fuya ouꞌouli ainiya sa fafataꞌai be salumadi sa laoma sa luhuluhu lau haba ya anꞌeta moni lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Fuyana Pita yo Diyon ya itadi bena haba sa luhulau Dubu Tabuna ganahewana, ya anꞌeta moni lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Sa itaꞌita lau lisina na Pita iyen, U itaꞌitama lebemai! ");
INSERT INTO bxh_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Yo fede taumoho wa ya itaꞌita lau lebedi na ena nuwatuhu bena somo haba sa felen. ");
INSERT INTO bxh_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Habahim Pita iyen, Yau hige egu moni na somo lebegu yai haba E felem? Yesu Keliso Nasaleta dogana hesana yai u mwaito be u laulau! ");
INSERT INTO bxh_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nimana sibana yai ya saguhi be ya faꞌobiyo. Hige walolona taumohona ahe laulauna yo talutalumodi sa adidili. ");
INSERT INTO bxh_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ahena feula ya bwaꞌiyedi na ya fatubu ya laulau. Habahim maꞌedi sa lau Dubu Tabuna dobidobina ganahewana yai, ya laulau yo ya dagodago, Yaubada ya fafadebasae! ");
INSERT INTO bxh_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Fuyana dodoga mahudoꞌidi sa ita ya laulau yo Yaubada ya fafadebasae. ");
INSERT INTO bxh_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Sa nuwatuhu lobahi mate taumohona eseꞌesegana fuya ouꞌouli ai Dubu Tabuna Aba Luhuluhu Launa Loholohona yai ya taꞌataꞌai na ya anꞌanꞌeta. Yo fede mahudoꞌidi sa noꞌo wananaha mate sidohana be doha. ");
INSERT INTO bxh_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tau anꞌanꞌeta hola Pita yo Diyon lisidi yai ya abiꞌabi didi na dodoga mahudoꞌidi sa lautafo lau lisidi ma noꞌodi. Iti mate Dubu Tabuna tefana hesa hesana “Solomon ena Aba Anlogulogu” yai. ");
INSERT INTO bxh_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Fuyana Pita dodoga ni ya itadi, ya libalau lebedi iyen, Isalaela dodogadi, sidohana be ami kinoimai, emi nuwatuhu mate ai ema loholoho Yaubada matana yai, e ema gigibwali yai, be taumoho te ya laulau? ");
INSERT INTO bxh_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abelaham, Isako, Iyakobo yo afa wahada edi Yaubada logenana, ena tau paisowa Yesu, ya tole hitin. Yesu ami tole afulen nimadi yai be bena haba sa wunui. Pailati bena ya biya afulen na matana yai ami faleleyen. ");
INSERT INTO bxh_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Gigibwali yo Tau Laulau Dudulai Dogana ami waiyoꞌoꞌen na tau aiyunu ami anꞌetai bena sa soꞌe fahi be sa leyawa lisimiu. ");
INSERT INTO bxh_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","“Mwahuli Paꞌana,” Yesu, ami wunui. In moho Yaubada peꞌi yai ya faꞌobiyo fuyoi. Ai tau itana. ");
INSERT INTO bxh_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yesu hesana yai ena gigibwali ꞌe kawawananahaꞌen be taumoho ami ita yo ami sibai mate ya faꞌadidili. Wananaha! Yesu hesana sunumana lisina yai mate taumoho te ya faloholoho. Haꞌa mahudoꞌimiu ami ita. ");
INSERT INTO bxh_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Afa haidagu, aho te, E sibai mate umi yo emi babaꞌisa somo ami ginaginauli Yesu lisina yai mate, hige au sibai. ");
INSERT INTO bxh_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Na Yaubada ya fawananaha doha ite; somo beyabeyana haꞌa ya liba famahata peloweta lisidi yai mate Yaubada ena Fasinabo Dogana haba ya kamkamna be ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Au nuwabui na Yaubada au famuli watan haba emi heyaya ya nuwatuhu afuledi yo yaluwamiu ya faꞌadidilidi, ");
INSERT INTO bxh_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","na haba Keliso ya fatamaliyama, haꞌa ya fasinabo nonohai, logena Yesu. ");
INSERT INTO bxh_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ai galewa bena ya miya ee–, Yaubada ginauli mahudoꞌidi ya fadudulai fuyoꞌidi, doha beyabeyana ena peloweta tabudi ya falibadi be sa libaen. ");
INSERT INTO bxh_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Paꞌana Mose iyen, “Guyau emi Yaubada haba Peloweta hesa ganahewamiu yai ya faꞌobiyo, doha yau. Ginauli mahudoꞌidi ya falibamiu bena ami atahiyedi. ");
INSERT INTO bxh_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Yena sai laꞌi hige peloweta ni ena liba i awaꞌabiyen haba Yaubada ena dodoga ganahewadi yai sa kamfahi na sa wunui.” ");
INSERT INTO bxh_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Wananaha! Somo aho lahai te ya laulau mate Peloweta mahudoꞌidi Samuwela yai ya lawen, haꞌa beyabeyana sa libaen. ");
INSERT INTO bxh_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yaubada ena liba fasunuma peloweta lisidi yai mate enehemiu. Haꞌa ami abi, yo yali ya ginauli afa wahawahamiu lisidi yai ya fagonafimiu. Yaubada ya libalau Abelaham lisina iyen, “Am hiti mulita debadi yai haba dodoga mahudoꞌidi tanoꞌubu yai te, E faloholohodi.” ");
INSERT INTO bxh_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Fuyana Yaubada, ena tau paisowa Yesu ya fasinabo nonohai be ya fatamali bwaꞌiyeyawa bena ya faloholohomiu yo emi laulau heyaheyayadi ya buidi. ");
INSERT INTO bxh_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita yo Diyon hola dodoga sa fafalibadi na tau antalasam hahaisa yo Dubu tau gatinina baꞌisana yo Sadusi hahaisa sa lau lebedi. ");
INSERT INTO bxh_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Iti sa nuwa kwaipili paꞌana Pita yo Diyon sa fasibadi mate Yaubada haba doga mahudoꞌina peꞌi yai ya famwahuli fuyoi gonogonowana doha Yesu ena fafamwahuli fuyoꞌina. ");
INSERT INTO bxh_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Sa audi be sa gudu buluhidi deli yai ya lau bee–, ya lahai paꞌana haꞌa maihala ya ofi. ");
INSERT INTO bxh_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","In moho liba tau atahiyenna boludi sa kawawananaha be dodoga oulidi 3000. ");
INSERT INTO bxh_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Bobonna Diusi babaꞌisadi, babada yo edi laugagayo tau lau faꞌataꞌedi sa faꞌoigogo Yelusalem yai. ");
INSERT INTO bxh_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Tau Antalasam Baꞌisana, Anasi, mate amainiya maꞌena Kaiyafasi, Diyon, yo Alekisanda. Tatau haisa, mate Tau Antalasam Baꞌisana ana boga maꞌedi hinaga. ");
INSERT INTO bxh_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pita yo Diyon sa ledima Anasi maꞌana boga matadi yai na sa fatiꞌoidi tiyen, Gigibwali somo - somohena yo sai hesana yai ami ginauli doha ite? ");
INSERT INTO bxh_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Yaluwa Tabuna Pita ya famohafu dodoga ya falibadi iyen, Dodoga edi babaꞌisadi yo babada! ");
INSERT INTO bxh_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Paꞌana somo aho te, ami fatiꞌo buibuimai fuyanna ginauli loholohona ꞌe ginauli tau laulau gesa te lisina yai, yo auwe, “Doga te, sidohana ema fafaloholohona?” ");
INSERT INTO bxh_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Umi yo Isalaela dodogadi mahudoꞌidi bena ami sibai mate Yesu Keliso in Nasaleta dogana. In, logena, ami tutu fapatu. In moho Yaubada peꞌi yai ya famwahuli fuyoi. In hesana yai taumoho matamiu yai ya obiꞌobiyo te, ya faloholoho. ");
INSERT INTO bxh_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Buka Tabuna, Yesu, logena ya libalibaen iyen, “Duhu te, umi tau abi luma ami ꞌwaiyoꞌoꞌen na aho te In luma ana duhu otaꞌotafahina hesa.” ");
INSERT INTO bxh_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tanoꞌubu yai te, ibege sai ai lebena mwahuli ta lobahi paꞌana ibege sai hesa ai hesana haba ta mwahuli. ");
INSERT INTO bxh_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Sanhedeli, Pita yo Diyon edi nuwa adidili sa ita mate sa noꞌoꞌedi paꞌana sa nuwatuhu lobahi mate iti, supusupudi, hige ti fatalahadi. Yo sa nuwatuhu lobahi hinaga mate iti, Yesu tau famuli watanina. ");
INSERT INTO bxh_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","In moho hige somo ti libaen paꞌana taumoho laulau gesana Yaubada ya faloholoho te, sa ita ya obiꞌobiyo maꞌena Pita yo Diyon. ");
INSERT INTO bxh_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Be sa eli duduidi bena Sanhedeli edi oigogo sa lau afulen na nuwatuhu sa yoꞌo boda. ");
INSERT INTO bxh_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Sa fafatiꞌo fuyoꞌidi tiyen, Tatau te, haba sidohana eda abiꞌabidi? Yelusalem tau miyaina mahudoꞌidi sa sibai mate iti fafaꞌilala gigibwalidi haꞌa sa famahatadi, ibege ta faleleyedi. ");
INSERT INTO bxh_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","In moho gigibwali sa famahatadi wasana te, bena te gudu na tabu ti faꞌona wasawasaꞌen be i tadada ai ganahewadi. Tatau luwaga te, bena te liba fanuwa tagudi be tabu Yesu ai hesana sai hesa ti faliba fuyoi. ");
INSERT INTO bxh_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Yo fede sa yoga fafuyodi na sa falibadi bena tabu Yesu hesana ti libalibaen yo ti lau faꞌataen. ");
INSERT INTO bxh_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","In moho Pita yo Diyon alinadi sa bui tiyen, Umi iyabomiu au fadosi. Tausomo Yaubada matana yai ya dudulai bena ꞌe lau watan, emi liba e Yaubada ena liba? ");
INSERT INTO bxh_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ginauli somo ꞌe itadi yo ꞌe atahiyedi hige gonowana libana ai fatautau. ");
INSERT INTO bxh_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Sa liba fafaꞌwasabudi, habahim, sa duidi be sa lau. Hige adi mata hesa somo be haba ti panisidi, paꞌana somo ya laulau te, dodoga mahudoꞌidi Yaubada sa fafadebasae. ");
INSERT INTO bxh_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Taumoho ya loholoho te, mate ena boliman laꞌina 40 ya diꞌoi. ");
INSERT INTO bxh_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pita yo Diyon sa soꞌe fahidi mate sa fuyo edi dodoga lebedi be somo tau antalasam baꞌibaꞌisadi yo babada sa libaen, edi sa liba. ");
INSERT INTO bxh_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Fuyanna tau kawawananaha sa atahiyen mate mahudoꞌidi sa fafaꞌoigogo be sa lauꞌuꞌula lau Yaubada lisina tiyen, Galewa, tanoꞌubu, gabogabo yo ginauli mahudoꞌidi ganahewadi yai, Um, Yaubada, tau ginaulidi. ");
INSERT INTO bxh_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Yaluwa Tabuna ena gigibwali yai wa libalau ama ulutubu Deiwidi, em tau paisowa, lisina uwen, “Paꞌana somo mulimuli dodogadi sa manabala? Yo dodoga somo heyaheyayana bena sa ginauli, sa oiꞌoi niguguwen? ");
INSERT INTO bxh_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tanoꞌubu babaꞌisadi sa obiyo nonoha na tanutanuwaga sa faꞌoigogo bena Guyau yo ena Fasinabo Dogana, Keliso maꞌedi sa lulu.” ");
INSERT INTO bxh_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Wananaha, Heloda yo Pontiyusi Pailati maꞌedi mulimuli dodogadi yo Isalaela tataudi sa faꞌoigogo esega taon yai te, be edi sa oiliba bena em Tau Paisowa Fafatabuna, Yesu wa fasinabo, bena sa wunui. ");
INSERT INTO bxh_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Iti, somo em gigibwali yai yo em nuwatuhu yai haꞌa wa libaen bena ya tubu, mate sa ginauli watan. ");
INSERT INTO bxh_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Be Guyau! Somo sa liba faꞌwasabumai te, u nuwatuhui. Na ai, em tau paisowa, nuwamai te u faꞌadidilidi be em liba ai libalibaen. ");
INSERT INTO bxh_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nimam u lolon be tau asiꞌasiyebo u faloholohodi yo fafaꞌilala yo noꞌo ginaulidi u lau ginauli em Tau Paisowa Fafatabuna Yesu, hesana yai. ");
INSERT INTO bxh_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Sa lauꞌuꞌula ofi mulina yai, edi aba faꞌoigogo lumana ya tuhutuhu. Yaluwa Tabuna mahudoꞌidi ya famohafudi be ma nuwa adidilidi Yaubada ena liba sa libalibaen. ");
INSERT INTO bxh_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tau kawawananaha nuwadi yo edi nuwanuwatuhu esega. Hige sai laꞌi iyen, “Egu ginauli te, yau ibogu enehegu.” Sa soiyedi be haidadi edi sa feledi. ");
INSERT INTO bxh_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tau faꞌona wasawasa ma-gigibwalidi Guyau Yesu ena obiyo fuyo sa libalibaen na Yaubada ena ainauya laꞌilaꞌi ya fatalu mahudoꞌidi lebedi yai. ");
INSERT INTO bxh_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ganahewadi yai ni, hige sai i fafagogo gesa. Sai fafatanohidi e fafalumadi mate tanohidi e lumadi sa uneꞌune afuledi. ");
INSERT INTO bxh_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Maisadi sa abidi be tau faꞌona wasawasa sa feledi na monidi haba sa soiyedi be gonogonowadi, ");
INSERT INTO bxh_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Lewi dogana hesa Saipelesi bonabonaluwana yai ya laoma. Hesana Diyosepa yo in, tau faꞌona wasawasa. Hesana hesa sa tole Banabasi (aniyona mate, in nuwadi Tau Libaliba Faꞌadidili Natuna.) ");
INSERT INTO bxh_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ena tanohi ya uneꞌune afulen na monina ya leyama be tau faꞌona wasawasa ya feledi. ");
INSERT INTO bxh_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","In moho amainiya mate doga hesa hesana Ananiya, ma lahuna Safila edi ginauli haisa sa uneꞌune afuledi. ");
INSERT INTO bxh_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ena nuwatuhu yai monina tefana ya nuhafi enehena, be lahuna ena nuwatuhu hinaga ya lau watan, na tefana mate amainiya tau faꞌona wasawasa ya feledi. ");
INSERT INTO bxh_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pita ya libalau lisina iyen, Satani nuwam ya famohafu, be ena nuwatuhu wa lau watan. Yaluwa Tabuna wa bwalai na tanohi monina te, tefana wa nuhafi. ");
INSERT INTO bxh_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tanohina hola hige u uneꞌuneꞌen mate um enehem; na wa uneꞌuneyen, mulina yai monina hinaga enehem. Sidohana be laulau ni wa ginauli? Mate, hige dodoga u bwalaidi, na Yaubada wa bwalai! ");
INSERT INTO bxh_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Maꞌesega na, Ananiya, liba te ya atahiyen yo fede ya guli lidi ma lau peꞌina na saluma wasana sa atahiyen, mate sa ꞌwasabu. ");
INSERT INTO bxh_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Yo fede hewahewali sa laoma, be silanna sa suma na sa bahe lawen ganamuli be sa boꞌusai. ");
INSERT INTO bxh_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Hige lofana na lahuna hinaga ya luhuma. Somo ya tubu mate hige i siba. ");
INSERT INTO bxh_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita waihin te ya fatiꞌoi iyen, U falibagu, itete Um ma lahum emi tanohi maisana laꞌina sa felemiu? Waihin Pita alinana ya bui iyen, Ii–, maisana laꞌina, logena. ");
INSERT INTO bxh_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Yo fede Pita ya libalau lisina, iyen, Sidohana be ma lahum ami oiliba na Yaubada Yaluwana Tabuna ami lauꞌita be ami bwalai? Lahum tau boꞌusaina mate eda hafohafona yai; haba um hinaga sa bahe lawen ganamuli be sa boꞌusaim. ");
INSERT INTO bxh_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Makai, ma esega! Na ya guli lidi ahena yai be ya peꞌi. Hewahewali sa luhuma be sa ita mate haꞌa ya peꞌi. Yo fede sa bahe fakalamahano be lahuna sadaina yai sa boꞌusai hinaga. ");
INSERT INTO bxh_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tau kawawananaha mahudoꞌidi yo salumadi haisa wasana sa atahiyen mate sa ꞌwasabu palapa. ");
INSERT INTO bxh_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Fafaꞌilala boludi yo noꞌo abiꞌabidi tau faꞌona wasawasa sa lau ginauli dodoga lisidi yai. Tau kawawananaha mahudoꞌidi Dubu Tabuna ganamulina yai sa faꞌoigogo “Solomon ena Aba Anlogulogu” ubuna yai. ");
INSERT INTO bxh_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Hige sai hesa nuwana i adidili bena haba i patu lau lisidi yai. In moho dodoga mahudoꞌidi mate sa ita hitihitinidi. ");
INSERT INTO bxh_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","In moho tatau yo wawahin hahaisa sa kawawananaha Guyau lisina yai be sa falau esegahi lawedi Yesu tau famuli watanna edi pei yai. ");
INSERT INTO bxh_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tau faꞌona wasawasa edi abiꞌabi yai dodoga lepalepadi sa ledima edaꞌeda laꞌilaꞌidi yai, na sa faꞌenodi aba eno yo leiyafa yai. Yena Pita, haisa ya tau bayawaidi na tautauna ya lau lisidi haba adi asiyebo sa ofi. ");
INSERT INTO bxh_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Dodoga baiwadi Yelusalem sadasadaina taondi yai sa faꞌoigogo. Tau lepalepa yo salumadi yaluwa heyaheyayadi ganahewadi yai mahudoꞌidi sa loholoho. ");
INSERT INTO bxh_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tau Antalasam Baꞌisana yo afa haidana mahudoꞌidi, iti mate Sadusi pelena ganahewana yai, na nuwa elaꞌela ya famohafudi yo fede bena sa audi. ");
INSERT INTO bxh_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Tau faꞌona wasawasa sa audi be deli yai sa toledi. ");
INSERT INTO bxh_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","In moho, maihonana yai, Guyau ena anelu deli edaꞌedadi ya soꞌedi be ya foya lawedi ganamuli yai na ya falibadi iyen, ");
INSERT INTO bxh_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Au lau be Dubu Tabuna Dobidobina ai ganahewana au obiyo be mwahuli fwaufwau wasana mahudoꞌina dodoga edi au liba.” ");
INSERT INTO bxh_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ya ifi tatatali, anelu somo ya libaen wa, sa lau watan be sa luhulau Dubu Tabuna Dobidobina yai sa fatubu sa lau faꞌataidi. Tau Antalasam Baꞌisana yo ena pele liba sa fatamali lawen Isalaela babadadi, iti Sanhedeli dodogadi sa faꞌoigogoma. Habahim liba sa fatamali lawen deli be tau faꞌona wasawasa sa ledima. ");
INSERT INTO bxh_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","In moho fuyana tau gati sa mahano lau deli yai mate tau faꞌona wasawasa hige ti itadi, yo fede, sa fuyo be Sanhedeli sa falibadi, ");
INSERT INTO bxh_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ꞌE mahano lau deli lumana yai na ꞌe ita mate edaꞌeda ma guduguduna na fafakapu hafitina yo tau itaꞌita wata edaꞌeda hafohafodi yai sa miyamiya na edaꞌeda ꞌe soꞌe lawen mate hige sai laꞌi ai lobahi ganahewa yai. ");
INSERT INTO bxh_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tau antalasam babaꞌisadi yo dubu tau itaꞌita watanna edi baꞌisa wasa te sa atahiyen be sa nuwanuwatuhu palapa mate ai fuya matadi yai haba somo ya tubu. ");
INSERT INTO bxh_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Habahim doga hesa ya laoma be iyen, Hola au ita! Dodoga deli yai ami gududi wa, mate Dubu Tabuna dobidobina yai sa laulau faꞌata! ");
INSERT INTO bxh_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Yo fede Dubu tau itaꞌita watanna edi baꞌisa maꞌana hewahewali sa lau be tau faꞌona wasawasa sa fafuyodima. In moho hige ti dalu beleleidi paꞌana sa ꞌwasabu ibe dodoga ti manabalaꞌedi be ti abi umeꞌehuidi. ");
INSERT INTO bxh_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tau faꞌona wasawasa sa foya lawedi ganahewa. Sanhedeli babadadi matadi yai sa faꞌobiyodi; bena haba, Tau Antalasam Baꞌisana ya fatiꞌoidi, ");
INSERT INTO bxh_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Laugagayo adiꞌadidilina haꞌa E falibamiu bena tabu doga te ai hesana au lau faꞌata. In moho hesana hola dodoga ami fafaꞌatadi be Yelusalem nuꞌuna haꞌa ya nuhuli bena haba doga te ꞌwasinana giluna ami fabaheimai. ");
INSERT INTO bxh_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita yo tau faꞌona wasawasa haisa alinana sa bui tiyen, Yaubada ena liba bena ꞌe lau watan. Hige doga hesa! ");
INSERT INTO bxh_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Afa wahada edi Yaubada, Yesu peꞌi yai ya famwahuli fuyoi. In logena ami tutu fapatu kolosi yai. ");
INSERT INTO bxh_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yaubada ya tole hitiꞌi aba faꞌatitina tefa sibana yai be ya famala tau foyafoya yo tau fafamwahuli be haba Isalaela ya fanuwa buidi yo edi heyaheyaya ya nuwatuhu afuledi. ");
INSERT INTO bxh_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ginaulidi te, ai yo Yaluwa Tabuna hinaga ꞌe famahatadi. In logena, sai Yaubada ya felen, salumadi iti ena liba tau lau watanina lebedi yai. ");
INSERT INTO bxh_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tanutanuwaga, liba te sa atahiyen mate, manadi sa bala heyaheyaya be sa fanuha bena sa wunuidi. ");
INSERT INTO bxh_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","In moho Falesiya dogana hesa hesana Gamaliyeli yo in, laugagayo tau lau faꞌataenina hesa. Dodoga mahudoꞌidi sa fafaꞌatitiyen wananahai, Tanutanuwaga pwaludi yai ya obiyo na ya liba be tau faꞌona wasawasa sa lawedi mulimuli yai, begana. ");
INSERT INTO bxh_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Habahim ya libalau tanutanuwaga lisidi iyen, Isalaela tataudi! Somo bena lisidi yai ami ginauli mate hola au nuwanuwatuhu komakoman. ");
INSERT INTO bxh_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ami nuwatuhui Teudasi ena fuya yai na ya libaliba bena in doga hesa laꞌilaꞌi na doga ouꞌoulidi doha 400 sa famuli watani. In moho sa wunui na tau famuli watanina mahudoꞌidi sa failaulauwidi. Yo fede ena paisowa ya fatautau. ");
INSERT INTO bxh_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Na Teudasi mulina yai, sensisi fuyana yai, Galili dogana hesa hesana Diuda, ena fuya yai, ena pele ya foyahi be sa faiꞌabi gabeman lisidi yai. In hinaga sa wunui yo fede tau famuli watanina sa failaulauwidi. ");
INSERT INTO bxh_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Be laulau te lisina yai ami hoꞌowa E sala. Tabu somo au ginauli dodoga te ai lisidi. Au ita afuledi! Yena somo sa oilibaen yo sa ginauli ibodi edi sibasiba yai, haba ya fatautau. ");
INSERT INTO bxh_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Na yena Yaubada lisina yai ya laoma, hige gonowana au gududi. Itaꞌitana doha Yaubada maꞌemiu au faifaiꞌabi. ");
INSERT INTO bxh_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gamaliyeli ena libaliba yai, Diusi babadadi nuwadi ya abidi. Tau faꞌona wasawasa sa yogaidi lau ganahewa sa pidilidi na sa falibadi tabu Yesu hesana ti libaen fuyo. Habahim sa biya afuledi. ");
INSERT INTO bxh_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tau faꞌona wasawasa Sanhedeli sa lau afulen ma nuwa loholohodi paꞌana Yesu hesana taumayamayana kamkamnana sa fahoina. ");
INSERT INTO bxh_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Fuya ouꞌouli ai Dubu Tabuna dobidobina yo ai luma hesa - hesa, lau faꞌata yo wasa loholoho mate Yesu in logena Keliso, Guyau ena Fasinabo Dogana, fatadadana hige ti fatautau. ");
INSERT INTO bxh_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Fuyandi yai mate Yesu tau famuli watanina ya tadada be ya laꞌi ya lau ee–, Diusi pele luwaga sa faibayaho. Pele hesa mate Hebelu alinadi wananaha tau sibaina na pele hesa Giliki alinadi sa fapaisowa. Salumadi Giliki alinadi sa fapaisowa tiyen, Fuya ouꞌouli anꞌanna ami soisoiyedi mate ema hwabuhwabu hige adi au feledi. ");
INSERT INTO bxh_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yo fede tau famuli watanina 12 te, dodoga mahudoꞌidi sa yoga gogonidi, na tiyen, “Hige i dudulai bena ai, Yaubada ena libalau faꞌatana ai fatautau be haba kalahe soiyenna ai modeꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Afa haidamai, dodoga faligigi luwaga ai ganahewamiu au famwaitodi. Iti bena Yaluwa Tabuna yo sonoga ya lau fafamohafudi be haba ginauli te, sa ita watanidi ");
INSERT INTO bxh_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","na ai haba ema fuya mahudoꞌina ꞌe pei ai lauꞌuꞌula yo lau faꞌata paisowana yai.” ");
INSERT INTO bxh_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tau faꞌona wasawasa edi nuwatuhu dodoga mahudoꞌidi sa fanuha. Yo fede Sitiwin ma afa haidana Pilipi, Pokulasi, Nikano, Timon, Pamena yo, Nikolasi sa famwaitodi. Sitiwin mate tau sunuma yo Yaluwa Tabuna ya lau fafamohafu, na Nikolasi mate in Antiyoka dogana na sa fanuwa bui be Diusi edi Yaubada ya kawawananahaꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Dodoga faligigi luwaga te, sa lau matadi yai sa mwaito na tau faꞌona wasawasa nimadi sa tole lawedi hewadi yai na enehedi sa lauꞌuꞌula be gigibwali sa abi. ");
INSERT INTO bxh_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Yo fede Yaubada ena liba ya tadada be ya lau. Na Yesu tau famuli watanina Yelusalem nuꞌuna yai mate sa ouli be ya laulau. Na Diusi tau antalasam dodogadi peidi Yesu sa kawawananahaꞌen hinaga. ");
INSERT INTO bxh_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Yaubada, inonona loholohona yo ena gigibwali Sitiwin ya lau fafamohafu, be fafaꞌilala yo noꞌo ya lau ginauli dodoga ganahewadi yai. ");
INSERT INTO bxh_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Diusi dodogadi edi oigogo pelena hesa sa atahi “Biya Afuledi Tataudi” ganahewana yai mate dodoga haisa. Iti mate Sailin yo Alesandiya nuꞌudi tau laolaoma ma afa haidadi Diusi hahaisa Silisiya yo Eisiya nuꞌudi yai tau laolaoma, maꞌedi Sitiwin sa faibayaho. ");
INSERT INTO bxh_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","In moho Yaluwa Tabuna, Sitiwin sibasiba ya felen be somo ya libaen hige gonowana moꞌana ti bui. ");
INSERT INTO bxh_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Yo fede “Biya Afuledi” pelena dodoga haisa simosimo yai sa nuwa liuꞌidi be haba sa liba tiyen, Mose yo Yaubada ya liba fafaheyayadi na ꞌe atahi! ");
INSERT INTO bxh_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Dodoga, babada yo laugagayo tau lau faꞌataenna sa eli fasifasinadi yo fede Sitiwin sa tohai be sa foya lawen Diusi dodogadi edi Konisela hesana “Sanhedeli” matadi yai. ");
INSERT INTO bxh_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Habahim tatau haisa sa ledima be sa bwala tiyen, Doga te, eda Dubu Tabuna yo Mose ena laugagayo ya lau paliyedi. ");
INSERT INTO bxh_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ꞌE atahi ya libaliba hinaga iyen, “Yesu Nasaleta dogana te, haba Dubu Tabuna ya lubi lopa yo ulutubu laulaudi Mose ya ledima enehemai te haba ya buidi!” ");
INSERT INTO bxh_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Babada safalumadi Sanhedeli Konisela ganahewana yai sa taꞌataꞌai mate matadi sa ala lolo lau Sitiwin lisina na sa ita mate nenena doha anelu. ");
INSERT INTO bxh_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Yo fede Tau Antalasam Baꞌisana Sitiwin ya fatiꞌoi iyen, “Ite liba te, moꞌisa?” ");
INSERT INTO bxh_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Alinana, Sitiwin ya bui fafuyo iyen, Afa haidagu yo afa tamagu au ataꞌatahima! Hola hige wahada Abelaham i lau Halan yai i gogo na Hewa Wananaha Yaubadana ya taumahata lebena yai, Mesopotamia nuꞌuna yai ");
INSERT INTO bxh_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","be ya libalau lisina iyen, “Em nuꞌu yo am boga u lau afuledi na u lau be nuꞌuna haba E faꞌitam ainiya u miya.” ");
INSERT INTO bxh_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Yo fede, Kaladiya dodogadi edi nuꞌu ya lau afulen na ya lau Halan yai ya miya. Abelaham tamana ya peꞌi na mulina yai Yaubada ya duiyama eda aba miyamiya yai te. ");
INSERT INTO bxh_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Yaubada hige tanohina laꞌi, Abelaham i felen be ai ena, hige itawa piꞌana laꞌi, higeꞌe wananaha! In moho Yaubada ya liba fasunuma mate haba ya felen ma afa wahawahana, enehedi. Yaubada liba fasunuma lahaina yai ni, ya ginauli mate Abelaham hola hige natuna. ");
INSERT INTO bxh_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yaubada ya faliba doha ite, “Wahawaham haba ai nuꞌu hesa sa gogo. Ainiya haba sa lau fayofayoꞌedi yo sa fahisu faheyayadi ee–, bolima oulina 400 yo. ");
INSERT INTO bxh_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","In moho dodoga ni, haba E fakasadi. Ai mulina haba nuꞌu ni, sa lau afulen na ai nuꞌu te, haba sa fadebasaegu.” ");
INSERT INTO bxh_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Yaubada hinaga mwagisa dududi ꞌwapidi tomofahina yalina Abelaham ya felen be fuyanna Abelaham natuna Isako ya tubu na ena lahai faligigi-faihona mate mwagisana duduna ꞌwapina ya ibo papa. Doha mate ya laulauꞌi fuyanna Isako natuna Iyakobo yo Iyakobo nanatuna safuhudohudoꞌi-luwaga sa tubuma. Isalaela dodogadi wahawahadi fafasaedi ouꞌoulidi 12 tamadi mate Iyakobo. ");
INSERT INTO bxh_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Iyakobo nanatuna, tasidi Diyosepa sa nuwa elaꞌelaꞌen be sa uneꞌuneꞌen bena ai Idipi haba sa lau fayofayoꞌen. In moho Yaubada hige i nuwa afulen ");
INSERT INTO bxh_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","be ena kamkamna mahudoꞌidi lisidi yai ya fofofofahi. Yaubada, Diyosepa ya fasonoga yo ena sagu yai Idipi edi Kin nuwana ya abi be Diyosepa ya ita faloholoho. Na Baꞌisa Falo, Diyosepa ya famwaito Gawana be Idipi nuꞌuna mahudoꞌina yo Kin ena luma yo ginauli mahudoꞌidi ya ita watanidi. ");
INSERT INTO bxh_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Idipi yo Kanana nuꞌudi yai galamo wesawesasa be kamkamna laꞌilaꞌi sa fahoina. Wahawahada hige gonowana bena kalahe ti lobahi, ");
INSERT INTO bxh_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","na Iyakobo wasa ya atahiyen mate Idipi yai kalahe. Yo fede nanatuna ya fatamalidi. Nanatuna mate ita wahawahada na edi fuya bwaꞌibwaꞌina ya fatamali lawedi niya. ");
INSERT INTO bxh_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Fuyanna afa haidana sa fuyo mate Diyosepa ya liba famahata fuyoi lisidi yai in hidadi. Lahaina yai Idipi edi Kin, Diyosepa ana boga ya sibaidi. ");
INSERT INTO bxh_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Mulina yai, Diyosepa wasa ya fatamali lawen tamana Iyakobo lisina yo ana boga ouꞌoulidi 75 lisidi bena mahudoꞌidi sa laoma Idipi. ");
INSERT INTO bxh_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Habahim Iyakobo maꞌana boga sa aulaha sa lau Idipi sa miya ee–, sa peꞌi, amainiya. ");
INSERT INTO bxh_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Silandi sa lawedi eda lofalofa yai be somo yai duyufi hesa Abelaham haꞌa ya famaisa sulu Hamoli lisidi yai mate amainiya sa toledi. Duyufina Sekem yai, Kanana nuꞌuna ganahewana yai. ");
INSERT INTO bxh_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Eda dodoga Idipi yai haꞌa sa ouli na Yaubada ena liba fasunuma Abelaham lisina yai fawananahana mate ya hanahanau. ");
INSERT INTO bxh_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Habahim kin hesa Diyosepa hige i sibai, ena fuya ya ita wata be Idipi ya ita watan, ");
INSERT INTO bxh_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","na wahawahada edi dudulai ya faleleꞌedi be ya fakamkamnadi. Ya duduidi be nanatudi kikiluka sa bahe lawedi mulimuli yai sa faꞌota toledi be haba ainiya sa peꞌi. ");
INSERT INTO bxh_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Fuyana yai ni Mose sa yosi hewalina loholohona. Nawalahi faihona tamana yo tinana edi luma yai sa simosimoi. ");
INSERT INTO bxh_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Fuyanna sa faꞌota tole mulimuli yai, Idipi edi Kin natuna waihin ya lawen ya abi falaꞌi be ya famala natuna. ");
INSERT INTO bxh_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Idipi edi sibasiba mahudoꞌina sa fatalaha be ya famala doga hesa laꞌilaꞌi, libaliba yai yo abiꞌabi yai. ");
INSERT INTO bxh_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Fuyana Mose ena bolima 40, nuwatuhu ya abi mate bena falena Isalaela dodogadi ya kepaidi. ");
INSERT INTO bxh_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Idipi dogana hesa falena Isalaela dogana ya fahisu faheyaya ya ita. Yo fede ya lau ana ya fofo be Idipi dogana ya wunui. ");
INSERT INTO bxh_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","(Mose ena nuwatuhu bena ena dodoga haba sa nuwatuhu lobahi mate in, Yaubada, ya fafapaisowa be ya fofofo fahidi, in moho higeꞌe). ");
INSERT INTO bxh_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Bobonna Isalaela dodogadi luwaga sa lululu be bena ya lau biliyedi na ya liba iyen, “Hola au ataꞌatahi. Umi Isalaela eseꞌesegamiu. Sidohana be ami lulu fuyoꞌimiu?” ");
INSERT INTO bxh_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Tau antala mate Mose ya dem fapululu lawen sadai yai na iyen, “Sai ya faꞌobiyom bena um ema baꞌisa yo tau fafadudulaimai? ");
INSERT INTO bxh_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wa fanuha bena wa wunuigu doha bon Idipi dogana wa wunui?” ");
INSERT INTO bxh_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Fuyana Mose liba ni ya atahiyen mate Idipi ya gela afulen na ya lau Midiyan nuꞌuna yai ya gogo taꞌotaꞌowawa. Amainiya ya nahi be nanatuna tatau luwaga sa yosidi. ");
INSERT INTO bxh_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Bolima 40 sa ofi na mulina yai nuꞌu pitapitalina atiꞌatipuna yai tuꞌa hesa hesana Sainai mate amainiya oyagi kiukiu ya ala balebalelem na ganahewana yai anelu ya taumahata lau Mose lisina. ");
INSERT INTO bxh_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mose ginauli ni ya ita mate ya noꞌo be ya sigilau oyagi sadaina yai bena ya ita komakomaniꞌi na Guyau alinana ya atahi, ");
INSERT INTO bxh_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Wahamiu Abelaham, Isako yo Iyakobo yau edi Yaubada.” Mose ꞌwasabu ya kamfafatabubu be hige gonowana i itaꞌitai. ");
INSERT INTO bxh_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Habahim Guyau ya libalau lebena iyen, “Am sendolo u kamfahidi paꞌana em aba obiꞌobiyo ni nuꞌu fafagabina. ");
INSERT INTO bxh_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Egu dodoga Idipi yai edi kamkamna haꞌa E ita wananahai yo edi tan haꞌa E atahi be E laoma bena E fofo fahidi. Matabahim u laoma, haba E fatamalim wa fuyo Idipi.” ");
INSERT INTO bxh_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Mose in logena Isalaela dodogadi sa waiyoꞌoꞌen, be sa fatiꞌoi tiyen, “Sai ya faꞌobiyom bena um ema baꞌisa yo tau fafadudulaimai?” In logena, Yaubada ya fatamaliyama bena edi baꞌisa yo tau fofofahidi anelu ena sagu yai fuyana ya taumahata lau lisina oyagi balebalelemna yai. ");
INSERT INTO bxh_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Dodoga Idipi yai ya foya fahidi. Fafaꞌilala yo noꞌo ya lau ginauli Idipi yai, Gabogabo Balebalelemna yai yo bolima 40 nuꞌu pitapitalina yai. ");
INSERT INTO bxh_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mose, in logena, Isalaela dodogadi ya falibadi iyen, “Yaubada haba emi peloweta ya fatamaliyama, gonogonowana doha yau na in haba ami boga hesa.” ");
INSERT INTO bxh_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","In logena maꞌena Isalaela dodogadi nuꞌu pitapitalina yai sa faꞌoigogo esega. Wahawahada hinaga ma afa haidana yo maꞌena anelu ya libalau lisina Sainai Tuꞌana. Amainiya mwahuli wasana Yaubada lisina yai ya abi be ya fatadada ya lau ee–, ita aho te lisida yai. ");
INSERT INTO bxh_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","In moho wahawahada sa waiyoꞌoꞌen be ena liba sa moꞌa peiyedi na nuwadi sa fuyofuyo Idipi. ");
INSERT INTO bxh_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Yo fede Elon sa faliba tiyen, “Mose ya somo? In Idipi yai ya foyafahimai na aho te, sidohana? Beti! Ema yaubada haisa u lau ginauli be haba sa foyahimai.” ");
INSERT INTO bxh_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Habahim oitau sa ginauli nenena doha bulumakau natuna. Antalasam sa angabu lau lisina na sa anꞌangogo be somo sa ginauli nimadi yai ni mate sa fadebasae. ");
INSERT INTO bxh_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Yo fede Yaubada ya taꞌai mulimuliyedi yo ya nuwa afuledi be galewa kipwaladi sa fadebasaedi doha peloweta edi buka yai sa uli tiyen, “Isalaela dodogadi! Boliman 40 nuꞌu pitapitalina yai antalasam ami ledima lisigu, e higeꞌe? ");
INSERT INTO bxh_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","“Higeꞌe! Emi yaubada Moleka ami husai aba husanina yai be ami bahebahe asiꞌasiyen yo emi yaubada hesa hesana Lefan, oitauna kipwala, ami ginauli. Oitaudi ami ginaulidi be ami fadebasaedi. Haba E duimiu be ami lau Babilon ai mulina na yalayalawen ainiya ami miya hudoꞌi.” ");
INSERT INTO bxh_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Yaubada Aba Lobahina Palaina” ginaginaulina nuwatuhuna Yaubada, Mose ya felen mate wahawahada sa fapaisowa be Gwaꞌu ni sa ginauli na sa lawelawen nuꞌu pitapitalina yai. ");
INSERT INTO bxh_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Diyesuwa ena fuya foyafoya yai afa wahawahada Gwaꞌu ni sa abi na sa bahe lawen taꞌowawa dodogadi edi nuꞌu fuyana Yaubada ya weꞌaidi wahawahada nuwanuwadi yai be edi nuꞌuna sa eli halahalaen. Amainiya ya ota esegahi ee–, Deiwidi ena fuya yai yo. ");
INSERT INTO bxh_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Yaubada, Deiwidi ya ita faloholoho be Deiwidi ya anꞌetai iyen, Guyau! Ibe gonowana em “Luma Tabuna” E ginauli? ");
INSERT INTO bxh_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","In moho Solomon lumana ya faꞌobiyo, enehena. ");
INSERT INTO bxh_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","In moho Hewa Wananaha Yaubadana hige luma dodoga ti ginaulidi ganahewadi i miyamiya; doha peloweta haꞌa ya libaen iyen, ");
INSERT INTO bxh_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Yaubada ya liba doha ite, “Galewa mate Yau egu aba taꞌataꞌai na tanoꞌubu mate ahegu aba tolena. Luma somo - somohena haba ami ginauli, enehegu, e ai somo haba E anyawasi? ");
INSERT INTO bxh_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Yau nimagu yai ginauli mahudoꞌina te, E ginauli!” ");
INSERT INTO bxh_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sitiwin ya liba ya lau iyen, Nuwamiu haga ti poꞌi yo nuwamiu doha dodoga hige Yaubada ti sibai! Beyamiu sa doꞌo wananaha be Yaubada wasana hige au atahi didin! Umi emi laulau doha wahawahamiu, Yaluwa Tabuna ami gudugudui! ");
INSERT INTO bxh_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Peloweta mahudoꞌidi Yaubada ya fatamali leyawa lisimiu mate wahawahamiu sa fahisu faheyayadi yo Tau Laulau Dudulai ena laoma wasana tau libaenna hinaga sa wunuidi. In logena, Keliso, Fasinabo Dogana, na aho ite ana ami liba talu be ami wunui. ");
INSERT INTO bxh_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Umi logemiu laugagayo anelu lisidi yai ami abi na hige au lau watan! ");
INSERT INTO bxh_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Fuyana Sanhedeli Konisela babada, Sitiwin ena liba sa atahi mate manadi sa bala be nima gigidi sa noꞌudi na sa fafaꞌita. ");
INSERT INTO bxh_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Sitiwin haꞌa Yaluwa Tabuna ya mohafu be ya itaꞌita hasa galewa be Yaubada ena namanamali ya ita na Yesu hinaga ya ita ya obiꞌobiyo Yaubada tefa sibana. ");
INSERT INTO bxh_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Iyen, Au itaꞌita hasa! Galewa ya tasoꞌe E ita na Doga Natuna ya obiꞌobiyo Yaubada sibana yai! ");
INSERT INTO bxh_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Makai, ma esega! Diusi edi Konisela dodogadi sa halabo fahi. Nimadi yai beyadi sa tipa buluhidi na sa tulufi lawen. ");
INSERT INTO bxh_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Sa solu weꞌa lawen taon mulimulina yai be sa laulau umeꞌehui amainiya. Tau itana adi luhuluhu sa toledi mate hewali hesana Saulo, ya itaꞌitaidi. ");
INSERT INTO bxh_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Sa laulau umeꞌehui na Sitiwin ya yoga lau Guyau lisina iyen, Guyau Yesu yaluwagu u leyawa! ");
INSERT INTO bxh_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ya tulibono na ya yoga laꞌilaꞌi iyen, Guyau! Tabu edi heyaya ai lisina u sadidi! Yo fede ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo mate Sitiwin ena peꞌi ya laliyen. Lahaina yai ni, Yelusalem yai, kamkamna lalaꞌi sa fahoina dubu dodogadi lisidi yai. Tau kawawananaha mate sa faidabalalaidi sa lau Diudeya yo Samaliya tefadi yai. ");
INSERT INTO bxh_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Na tau faꞌona wasawasa moho ibodi sa miya Yelusalem yai. Yaubada tau faꞌatitiyenna dodogadi haisa, Sitiwin sa boꞌusai na halana sa tan heyaheyaya. ");
INSERT INTO bxh_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Na Saulo ya fatubu be ya lau luma hesa - hesa yai be tau kawawananaha ya fahisu faheyayadi. Tatau yo wawahin ya solu kwakikwakinidi be ya gududi deli yai. ");
INSERT INTO bxh_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Salumadi Saulo ya fadabalaladi mate edi aba lau yai, Yesu wasana sa fatadada. ");
INSERT INTO bxh_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilipi mate ya lidi taon hesa Samaliya nuꞌuna yai be amainiya Keliso, (Fasinabo Dogana) wasana dodoga enehedi ya liba. ");
INSERT INTO bxh_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","7","Yaluwa heyaheyayadi dodoga ganahewadi yai sa kalamahano ma ꞌwalaꞌwalawidi yo dodoga dabidabidi yo taudi sa peꞌipeꞌi ya faloholohodi. Pilipi somo ya libaedi sa atahiyedi yo noꞌo abiꞌabidi ya lau ginaulidi sa itadi. Yo fede sa ataꞌatahi komakoman lau lisina. ");
INSERT INTO bxh_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Be taonna yai ni kwade laꞌilaꞌi! ");
INSERT INTO bxh_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Taumoho hesa hesana Saimon amainiya ya gogogo. Ana haha ya ginaulidi be Samaliya dodogadi ya fanoꞌodi. Ya nuwasaesae be iyen, Yau doga laꞌilaꞌi. ");
INSERT INTO bxh_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Yo fede dodoga gaigaibu yo dodoga lalaꞌi nuꞌu ni ganahewana yai mate sa ataꞌatahi komakoman lau ena liba yai na tiyen, Ite doga te, “Yaubada ena gigibwali dogana.” In doga laꞌilaꞌi. ");
INSERT INTO bxh_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Sa ataꞌatahi komakoman paꞌana fuya lofalofa ana haha yai ya fafanoꞌodi. ");
INSERT INTO bxh_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Fuyana wasa loholohona Pilipi ya libaen sa atahiyen. Yo fede Yaubada ena Nuꞌu yo Yesu Keliso hesana sa kawawananahaꞌedi be tatau yo wawahin sa babasito. ");
INSERT INTO bxh_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon hinaga ya kawawananaha be ya babasito. Muli yai, tau ayahan maꞌena Pilipi sa laulau asiꞌasi be fafaꞌilala yo noꞌo Pilipi ya lau ginauli, ya itadi. ");
INSERT INTO bxh_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tau faꞌona wasawasa Yelusalem nuꞌuna yai wasa sa atahiyen mate Samaliya dodogadi haꞌa Yaubada ena liba sa abi. Yo fede Pita yo Diyon sa fatamali lawedi lisidi. ");
INSERT INTO bxh_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Yaluwa Tabuna hola hige i laoma hesa - hesa lisina yai. Yesu Keliso moho hesana yai sa fababasitodi. Pita yo Diyon sa mahano lau mate tau kawawananaha enehedi sa lauꞌuꞌula be haba Yaluwa Tabuna sa abi. ");
INSERT INTO bxh_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","18","Habahim, nimadi sa tole lawedi hewadi yai be Yaluwa Tabuna sa abi. Yo fede Saimon ya ita. Yo fede, tataudi luwaga bena haba moni ya feledi. ");
INSERT INTO bxh_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Na iyen, Gigibwali te yau hinaga au felegu. Haba yena nimagu sai laꞌi ai hewana E tole haba Yaluwa Tabuna ya luhufidi. ");
INSERT INTO bxh_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","In moho, alinana, Pita ya bui fuyoi iyen, Haba um yo em moni ami lau oyagi alaꞌalana! Em nuwatuhu bena Yaubada ena ainauya wa une ai moni? ");
INSERT INTO bxh_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Paisowa yai te, um ibege maꞌemai paꞌana em nuwatuhu hige ti dudulai Yaubada matana yai. ");
INSERT INTO bxh_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Em laulau heyaheyayadi lisidi yai u nuwabui na Guyau u anꞌetai. Nuwana em nuwanuwatuhu ni Guyau haba ya nuwa afuledi? ");
INSERT INTO bxh_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","E ita mate wa nuwa elaꞌela wananaha yo nuwanuwatuhu heyaheyaya sa au didinim. ");
INSERT INTO bxh_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Saimon ya libalau Pita yo Diyon lisidi iyen, Egu au anꞌeta lau Guyau lisina be ginauli somo aho ami libalibaedi tabu laꞌi ya fahoina. ");
INSERT INTO bxh_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Guyau wasana yo edi ita lobahi sa libalibaen na habahim, sa aulaha be sa fuyo Yelusalem. Edi aba lau yai, Samaliya ganahewana yai luma edaꞌeda sadaidi yai, amainiya, wasa loholohona sa falibadi. ");
INSERT INTO bxh_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Guyau ena anelu ya libalau Pilipi lisina iyen, U nonoha na nuꞌu pitapitalina edaꞌedana u lau watan. Edaꞌedana te, Yelusalem yai ya fatubu be ya lau Gasa Nuꞌuna yai. ");
INSERT INTO bxh_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Yo fede Pilipi ya nonoha be ya aulaha. Edaꞌeda yai ya laulau na Itiyopiya yuniki ya ita. Yuniki mate doga laꞌilaꞌi hesa Itiyopiya Nuꞌuna yai na alinadi yai edi Kwin e edi hatafele sa atahi mate Kandake na taumoho te ena moni tau ita watanina. Ya lau Yelusalem Yaubada taba ohuna ana halulu. Na saliyoti yai ya fuyo ena nuꞌu. Ya awa ya laulau na Peloweta Isaiya ena uliꞌuli ya fatifatili. ");
INSERT INTO bxh_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Yaluwa Tabuna ya libalau Pilipi lisina iyen, U lau be saliyoti ni ai sadaina u fafabeya pei. ");
INSERT INTO bxh_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pilipi ya lautafotafo ee–, ya mahano lobahi na ya atahi mate taumoho wa Peloweta Isaiya ena uliꞌuli ya fatifatili. Ya fatiꞌoi iyen, Somo wa fatifatili ni aniyona wa sibai e higeꞌe? ");
INSERT INTO bxh_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Taumoho wa Pilipi alinana ya bui fafuyo iyen, Sidohana haba egu sibasiba yena sai hige i liba famahata lisigu yai? E fakau! Yo fede yuniki wa Pilipi ya faliba be ya finahe saliyoti hewana yai be maꞌena sa awa luwaluwaga. ");
INSERT INTO bxh_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Uliꞌulina lausoisoina ya fatifatili mate logena itete, Sa foyahi, doha sipi sa foyahi be bena sa lau funuhi, yo doha sipi natuna olona sa tomo na hige i kehe, in hinaga hige alinana. ");
INSERT INTO bxh_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","In sa fataumayamaya yo ena dudulai sa faleleꞌen. Hige sai laꞌi gonowana bena ana hiti mulita i dedei, paꞌana ena mwahuli tanoꞌubu yai anadan yai ya mahano. ");
INSERT INTO bxh_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Baꞌisa wa Pilipi ya fatiꞌoi iyen, U falibagu, Peloweta somo ya libalibaen? In, e sai hesa? ");
INSERT INTO bxh_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Habahim Pilipi lausoisoina Isaiya ena uliꞌuli yai te, ya fatubu ya dede bee–, Yesu wasana loholohona enehena ya liba famahata lisina yai. ");
INSERT INTO bxh_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Na edaꞌeda yai sa lau wee–, nuꞌu hesa yai sa mahano. Amainiya hoꞌowa. Yo fede baꞌisa wa iyen, Ma! Hoꞌowa ite. Somo ya guduguduigu be tabu u fababasitogu? ");
INSERT INTO bxh_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilipi alinana ya bui iyen, Yena nuwam ma ofi fahina Yesu wa kawawananahaꞌen, gonowana haba E fababasitom. Yuniki alinana ya bui iyen, Wananaha! Yesu Keliso mate Yaubada Natuna. ");
INSERT INTO bxh_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Itiyopiya dogana wa ya liba be saliyoti sa abi tohai. Tataudi luwaga sa tulubeꞌu na sa gayo lidi hoꞌowa ganahewana be Pilipi baꞌisa wa ya fababasito. ");
INSERT INTO bxh_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Hoꞌowa sa gayo hiti afulen. Yo fede Guyau Yaluwana Pilipi ya abi be ya lawe hudoꞌiyen. Baꞌisa hige Pilipi i ita fuyoi. In moho ma kwadena ya lau. ");
INSERT INTO bxh_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pilipi, Asotusi Taonna yai ya taumahata be ya lau Siseliya Taonna. Ena aba lau yai, nuꞌu mahudoꞌina yai, wasa loholohona te ya libalibaen lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo, Guyau tau famuli watanina ya liba fafaꞌwasabudi bena ya wunuidi. Ya lau Tau Antalasam Baꞌisana, ");
INSERT INTO bxh_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ya anꞌetai be pepa hesa ya uli lawen Diusi edi aba oigogo Damaseko yai, enehedi. Be ibe sai laꞌi, waihin e taumoho salumadi “Guyau Yesu ena Edaꞌeda” sa famuli watan, ya audi be ya fafuyodima Yelusalem. ");
INSERT INTO bxh_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Saulo ya laoma Damaseko taonna hanahanauna yai. Yo fede mala laꞌilaꞌina ya lidima galewa yai be ya sina fafataꞌiꞌili. ");
INSERT INTO bxh_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Yo fede Saulo ya beꞌu lidi tanohi yai na alina hesa ya atahi ya liba laoma lisina yai iyen, Saulo, Saulo! Paꞌana somo be wa fakamkamnagu? ");
INSERT INTO bxh_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Alinana ya bui iyen, Guyau, Um sai? Yesu wa, Saulo alinana ya bui fafuyo iyen, Yau Yesu. Logegu wa fahisu faheyayagu. ");
INSERT INTO bxh_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","U obiyo be u lau taon! Ainiya haba somo sa falibam wa ginauli. ");
INSERT INTO bxh_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Salumadi maꞌedi Saulo sa laulau mate sa todi na hige somo hesa ti libaen; hige dogana ti ita, na alina afaꞌafana moho sa atahi. ");
INSERT INTO bxh_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo tanohi yai ya obiyoma be matana ya falaladi. In moho hige somo laꞌi i ita. Yo fede sa abi nimai be sa foya lawen Damaseko. ");
INSERT INTO bxh_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Lahai faihona hige gonowana somo laꞌi i ita, i an e i nom. ");
INSERT INTO bxh_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tau kawawananaha dogana hesa Damaseko yai hesana Ananiya. Tautau hesa ya ita. Ganahewana yai Guyau ya libalau lisina iyen, Ananiya! Alinana ya bui fafuyo iyen, Ho! Guyau, yau ite. ");
INSERT INTO bxh_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","NA Guyau ya libalau lisina iyen, U abi nonoha be u lau edaꞌeda hesana “Edaꞌeda Dudulaina” u lau watan. Diudasi ena luma yai, Tasusi dogana hesa hesana Saulo u fatiꞌoi. In mate ya laulauꞌuꞌula, ");
INSERT INTO bxh_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","na haꞌa tautau yai ya ita mate taumoho hesa hesana Ananiya ya ita ya luhuma be nimana ya tole lawen hewana yai be haba matana ya falala be ya itaꞌita fuyo. ");
INSERT INTO bxh_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiya Guyau alinana ya bui iyen, Guyau, dodoga boludi wasana sa libalibaen, yo laulau heyaheyayadi Yelusalem yai ya ginaginaulidi em fatabudi dodoga lisidi yai, haꞌa E atahi. ");
INSERT INTO bxh_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Tau antalasam babaꞌisadi gigibwali sa felen na ya laoma Damaseko be safalumamai hesam ꞌe fafapaisowa, bena ya aumai. ");
INSERT INTO bxh_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Na Ananiya alinana Guyau ya bui iyen, U lau paꞌana haꞌa E fasinabom be in haba egu tau lau fayofayo, haba hesagu ya fatadada taꞌowawa yo kin hahaisa yo Isalaela dodogadi lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ginauli mahudoꞌidi haba ya ankamkamnaꞌedi Yau debagu yai mate haba E faꞌita. ");
INSERT INTO bxh_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Yo fede Ananiya ya aulaha be ya lau Saulo ena aba miyamiya lumana yai, ya luhulau be nimana ya tole lawen hewana yai. Na iyen, Hidagu Saulo, Guyau Yesu In, logena, edaꞌeda yai wa laolaoma na ya taumahata lisim yai. Ya fatamaligu te bena haba matam ya tasoꞌe be wa itaꞌita fuyo. Be haba Yaubada, Yaluwana Tabuna ya famohafum. ");
INSERT INTO bxh_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Yo fede ginauli hesa doha hama hunadi Saulo matana yai sa beꞌuma be ya itaꞌita fuyo. Habahim ya obiyo be ya babasito. ");
INSERT INTO bxh_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ya kalahe mulina yai, habahim ya adidili fuyo. Paisowa 9:19-25 Lahai fisa ya miya Damaseko yai maꞌena tau famuli watanna haisa. ");
INSERT INTO bxh_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Yo fede ya lau Diusi edi aba oigogo be ya lau faꞌata iyen, Yesu mate In, Yaubada Natuna. ");
INSERT INTO bxh_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Safalumadi sa atahiyen mate sa noꞌo na sa fafatiꞌo fuyoꞌidi tiyen, In logena, Yelusalem yai be salumadi sa laulauꞌuꞌula Yesu hesana yai ya faheyayadi! Ena laoma amaiteꞌi mate paꞌana somo? Dodoga bena ya audi be ya fafuyodi tau antalasam babaꞌisadi lisidi. ");
INSERT INTO bxh_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","In moho Saulo ena lauguguya mate ya gigibwali wananaha yo ya faꞌita lobahidi mate wananaha Yesu, In mate Keliso, Fasinabo Dogana, be nuwadi ya abidi na Diusi dodogadi Damaseko yai sa miyamiya wa hige gonowana alinana ti bui. ");
INSERT INTO bxh_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Lahai fisa sa ofi mulina yai Diusi dodogadi sa faꞌoigogo esega be sa oiliba bena Saulo haba sa wunui. ");
INSERT INTO bxh_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","In moho Diusi edi nuwatuhu wa Saulo ya atahiyen. Lahai yo iꞌipa Damaseko taonna edaꞌedadi hafohafodi yai sa nahanahai bena haba ainiya sa wunui. ");
INSERT INTO bxh_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Itete sidohana ena gelagela: Iꞌipa hesa yai Saulo tau famuli watanina sa foyahi lawen be maigele laꞌilaꞌi ganahewana yai sa husan be sa fadalolo lidiyen taon ganana solasolana hesa yai. ");
INSERT INTO bxh_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Fuyana Saulo, Yelusalem yai ya mahano, ya anpate bena tau faꞌona wasawasa ma afa haidana sa faꞌoigogo esega. In moho mahudoꞌidi sa ꞌwasabuwen paꞌana hige ti kawawananaha mate in haꞌa Yesu ya famuli watan. ");
INSERT INTO bxh_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Na Banabasi ya foyahi lawen lisidi be ya faliba komakomanidi sidohana Saulo, Guyau ya ita edaꞌeda yai na Guyau ya libalau lisina. Mate edi ya liba hinaga, Yesu hesana yai hinaga ya lauguguya ma nuwa adidilina Damaseko nuꞌuna yai. ");
INSERT INTO bxh_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Yo fede Saulo maꞌedi sa miya na Yelusalem nuꞌuna mahudoꞌina yai ya leu yo ya sae be Yesu wasana ya lauguguyaꞌen ma nuwa adidilina. ");
INSERT INTO bxh_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Na Diusi dodogadi Giliki alinadi yai sa libaliba mate maꞌedi Saulo sa faibayaho. Yo fede sa anpate bena haba sa wunui. ");
INSERT INTO bxh_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Fuyanna haidana te liba sa atahiyen. Yo fede Saulo sa lawen Siseliya. Amainiya sa fatamali lawen ena nuꞌu, Tasusi. ");
INSERT INTO bxh_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Habahim, tau kawawananaha mahudoꞌidi Diudeya, Galili yo Samaliya nuꞌudi mahudoꞌidi yai sa miya daumwali begana ya lofa. Yaubada tau kawawananaha ya fafaꞌadidilidi yo Yaluwa Tabuna ya sagusaguhidi be edi pele ya tadada yo edi miya yai Guyau sa fafaꞌatitiyen. ");
INSERT INTO bxh_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Neꞌi lahaina yai Pita ya aulaha be ya lau nuꞌu ouꞌouli ya antaumana be Lida yai fatabu dodogadi ya kepaidi. ");
INSERT INTO bxh_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Amainiya doga hesa hesana Eniyasi ya lobahi, ahena sa peꞌipeꞌi be hige gonowana ena aba eno i lau afulen ee–, bolima faligigi-faihona hige i mwaito. ");
INSERT INTO bxh_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita ya libalau lisina iyen, Eniyasi, Yesu Keliso ya faloholohom! U obiyo be em aba eno u noꞌu. Yo fede Eniyasi ya obiyo. ");
INSERT INTO bxh_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Dodoga peidi Lida taonna yai yo Salon gonna yai sa miyamiya, sa ita. Yo fede sa timuli bui Guyau lisina. ");
INSERT INTO bxh_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Diyopa taonna yai mate waihin hesa hesana Tabita. In mate Yesu tau famuli watanna hesa. (Hesana Giliki alinadi yai mate Doleka.) Fuya ouꞌouli mate loholoho ya ginaginauli yo tau fagogo gesagesa ya sagusaguhidi. ");
INSERT INTO bxh_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Fuyanna yai mate ya asiyebo be ya peꞌi. Silanna sa faꞌaꞌa be bili hewa yai sa faꞌota. ");
INSERT INTO bxh_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Diyopa ya lau Lida mate hige i lofa. Logena, Yesu tau famuli watanna Diyopa taonna yai wasa sa atahiyen mate Pita in Lida yai. Yo fede dodoga luwaga sa fatamali lawen be Pita sa anꞌetai tiyen, Aee–, u laoma. Feula! ");
INSERT INTO bxh_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Na Pita ya aulaha be maꞌedi sa lau. Fuyana ya mahano lau, yo fede sa foya lawen bili hewa yai. Amainiya mate hwabuhwabu mahudoꞌidi sa obiꞌobiyo, sa gana panpannen, na sa tantan. Kaleko yo luhuluhu hahaisa ma miyana na ya lau bodi mate, Pita sa faꞌita. ");
INSERT INTO bxh_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita mahudoꞌidi ya duidi be sa lau ganamuli na ya tulibono be ya lauꞌuꞌula. Habahim ya timuli bui be ya sana lau silan lisina na ya liba iyen, Tabita, u obiyo! Yo fede tau peꞌi wa matana ya falaladi be Pita ya ita na ya obiyo be ya taꞌai. ");
INSERT INTO bxh_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita ya abi famwaito. Habahim, fatabu dodogadi mahudoꞌidi ya yogaidi yo hwabuhwabu hinaga, be Tabita wa ya fele fuyoꞌidi ma mwahumwahulina! ");
INSERT INTO bxh_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Wasana mate Diyopa nuꞌuna mahudoꞌina ya tadada be dodoga boludi Guyau sa kawawananahaꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita Diyopa yai begana ya miya falofa maꞌena doga hesa hesana Saimon. In suisui ꞌwapidi tau abiꞌabi nonohaidi. ");
INSERT INTO bxh_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Doga hesa hesana Koniliyesi mate Sesaliya taonna yai ya miyamiya. In mate hiyala tau lau kulukuluwenna na ena tau hiyala pelena hesana “Itali Ledimenti.” ");
INSERT INTO bxh_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","In mate Yaubada tau fafaꞌatitiyenna hesa yo in maꞌana boga mahudoꞌidi Yaubada sa fafadebasae. Yo hinaga Diusi dodogadi tau fagogo gesagesa ya saguhi komakomanidi yo fuya ouꞌouli ya laulauꞌuꞌula lau Yaubada lisina. ");
INSERT INTO bxh_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Fuya hesa lahai laꞌi doha 3 koloki, tautau hesa ya ita. Yaubada ena anelu ya ita wananahai, ya laoma lisina be ya faliba iyen, Koniliyesi! ");
INSERT INTO bxh_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Koniliyesi ma ꞌwasabuna anelu ni ya kinokinoi lauwen na iyen, Baꞌisa, sidohana? Anelu, Koniliyesi alinana ya bui iyen, Em lauꞌuꞌula yo em faisagusagu tau gogo gesagesa lisidi yai mate ya famala em ainauya aba fafanuwa hiti Yaubada lisina yai. ");
INSERT INTO bxh_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Doꞌata te, tatau haisa u fatamalidi ti lau Diyopa be taumoho hesana Saimon, hesana hesa Pita, ti foyahiyama. ");
INSERT INTO bxh_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ena falihesa ena luma gabogabo sadaina yai maꞌena sa miyamiya. Saimonna mate in suisui ꞌwapidi tau abiꞌabi nonohaidi. Saimonna mate in suisui ꞌwapidi tau abiꞌabi nonohaidi. ");
INSERT INTO bxh_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Anelu ya libaliba ofi mulina yai ya lau na Koniliyesi ena tau lau fayofayo luwaga yo ena tau hiyala hesa ya yogaidi. Ena tau hiyala ni Yaubada ya tabataba ohuwen yo Koniliyesi enehena ya paisowa. ");
INSERT INTO bxh_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Somo ya tubu ni edi ya liba. Habahim ya fatamalidi sa lau Diyopa. ");
INSERT INTO bxh_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Bobonna lahai laꞌi yai, Diyopa sa hanahanauꞌi. Pita mate in amainiya na ya hasai luma hewana bena ya lauꞌuꞌula. ");
INSERT INTO bxh_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","11","Ya guliyam be ya fanuha bena somo ana ya an. Kalahe hola sa abiꞌabi nonohai na tautau ya ita. Galewa ya tasoꞌe ya ita na ginauli hesa nenena doha kaleko laꞌilaꞌi duduna fati sa fadalolo lidiyeyama. ");
INSERT INTO bxh_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ganahewana yai mate suisui fafaꞌahedi fati, ginauli kamokamodaladi yo kanekanenedi yo ataiꞌa yekoyekodi hinaga. ");
INSERT INTO bxh_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Alina hesa ya libalau lisina iyen, Pita, U obiyo u wunui be am u an! ");
INSERT INTO bxh_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Na Pita alinana ya bui iyen, Guyau, hige gonowana! Somo dabudabu hige ya anꞌandi. ");
INSERT INTO bxh_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Alina wa ya liba boda lau Pita lisina iyen, Somo Yaubada ya faloholoho te an. Tabu u kawa dabudabuwen! ");
INSERT INTO bxh_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ma faihona doha ite habahim ginauli te sa fafuyo hasaen galewa. ");
INSERT INTO bxh_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Tautau ni aniyona somo mate Pita hola ya fafadosi na Koniliyesi ana hewahewali haꞌa ya fatamalidi mate Saimon ena luma sa yoꞌoyoꞌoi be sa lobahi. Amainiya sa obiꞌobiyo edaꞌeda hafohafona yai. ");
INSERT INTO bxh_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Sa yoga lau be sa fatiꞌo tiyen, Ami taumana hesa hesana Saimon Pita amaiteꞌi? ");
INSERT INTO bxh_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita tautau ni aniyona hola ya fafadosi yo fede Yaluwa iyen, U ataꞌatahi! Tatau faihona sa laulau yoꞌoim haꞌa sa mahanoma ite. ");
INSERT INTO bxh_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","U obiyo be u feula lidi u itadi. Tabu u nuwa ladu na ma afa haidam au lau paꞌana yau E fatamalidima. ");
INSERT INTO bxh_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Yo fede Pita ya leta lidi be ya falibadi iyen, Aee–! Ami yoꞌoyoꞌoigu. Yau logegu ite. Sidohana be ami laoma? ");
INSERT INTO bxh_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Alinana sa bui tiyen, Hiyala tau lau kulukuluwenna hesana Koniliyesi ya fatamalimai. Diusi mahudoꞌidi sa liba faloholoho tiyen, “Koniliyesi mate Yaubada tau fafaꞌatitiyenna yo tau laulau dudulai hesa.” Yaubada ena anelu tabuna ya libalau lisina bena te lau ena luma be somo wa libaen haba ya atahi. ");
INSERT INTO bxh_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Habahim, Pita ya falibadi sa lau luma ganahewana be sa famala ana taumana. Paisowa 10:23-33 Bobonna ma hwalahwalalana, ma afa haidadi Diyopa tau kawawananaha hahaisa sa aulaha sa lau. ");
INSERT INTO bxh_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Lahai fafaluwagana yai sa mahano lau Siseliya. Koniliyesi ma afa efana yo afa haidana safalumadi ya yogaidi mate Pita sa bagibagiyen amainiya. ");
INSERT INTO bxh_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita bena ya luhulau, na yo fede Koniliyesi maꞌena sa failobahi. Koniliyesi ya hoba lidi ahena yai be ya fadebasae. ");
INSERT INTO bxh_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","In moho Pita ya abi famwaito na iyen, U obiyo! Yau doga gaibu yo ita gonogonowada. ");
INSERT INTO bxh_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita yo Koniliyesi sa laulau libaliba ee–, sa luhulau luma ganahewana na amainiya mate dodoga boludi haꞌa sa faꞌoigogo, ya itadi. ");
INSERT INTO bxh_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ya libalau lisidi iyen, Haꞌa ami siba fuyoimiu mate ai Diusi ema andabu yo sigu yawasi laugagayodi yai ya libaen mate tabu umi, nuꞌu hahaisa dodogamiu, yo ai, ta faꞌilu. In moho Yaubada ya faꞌitagu mate tabu laugagayo ni lisidi yai, doga ya ita faheyaya. ");
INSERT INTO bxh_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Na fuyana wa fatamalidima agu halulu mate hige ya waiyoꞌo. Bena E fatiꞌoimiu, “Somo lisina yai be sa laufigu?” ");
INSERT INTO bxh_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Koniliyesi iyen, Lahai faihona haꞌa sa ofi mulidi yai na maihala doha 3 koloki maimailafi mate E laulauꞌuꞌula egu luma yai te. Yo fede taumoho hudoꞌi ena leli namanamalina nuwanuwagu yai ya obiyo, ");
INSERT INTO bxh_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","na iyen, “Koniliyesi! Yaubada em lauꞌuꞌula haꞌa ya atahi yo tau fagogo gesagesa wa saguhidi hinaga ya itadi. ");
INSERT INTO bxh_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Dodoga hahaisa u fatamalidi ti lau be taumoho hudoꞌi hesana Saimon Pita ana halulu Diyopa nuꞌuna yai. In mate taumana na ena falihesa lisina yai ya miyamiya yo in logena suisui ꞌwapidi tau abiꞌabi nonohaidi. Saimon ena luma mate gabogabo sadaina yai.” ");
INSERT INTO bxh_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Yo fede E fatamalidi sa laowa am halulu na ya loholoho be wa laoma. Aho te mahudoꞌimai ꞌe faꞌoigogoma Yaubada matana yai ꞌe bagibagiyem be ginauli mahudoꞌina Guyau haꞌa ya falibam ema wa liba ꞌe atahi. ");
INSERT INTO bxh_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pita ya liba fatubu na iyen, Aho te E sibai mate Yaubada hige doga laꞌi i ita fasae e i ita fakiu. Wananaha! Ita mahudoꞌida mate gonogonowada. ");
INSERT INTO bxh_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Safalumadi edi laulau sa dudulai yo Yaubada sa fafadebasae mate enehena. Fali alina hinaga maꞌeda gonogonowada. ");
INSERT INTO bxh_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yaubada nuwa esega wasana loholohona ya fatamali lawen Isalaela dodogadi lisidi be Yesu Keliso ya libalibaen, haꞌa ami sibai. In mahudoꞌidi edi Guyau! ");
INSERT INTO bxh_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Somo sa laulau Diudeya Nuꞌuna mahudoꞌina yai mate haꞌa ami sibaidi. Ya fatubu Galili yai fuyanna Diyon, babasito wasana ya libaen, mulina yai. ");
INSERT INTO bxh_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Yaubada, sidohana Nasaleta dogana, Yesu ena fafamohafuna Yaluwa Tabuna yo gigibwali lisidi yai haꞌa ami sibai. Yaubada mate maꞌena na ya lau nuꞌu ouꞌouli yai be loholoho ya lau ginauli yo safalumadi Diyabolo ya fafaheyayadi, mahudoꞌidi ya faloholohodi. ");
INSERT INTO bxh_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ginauli mahudoꞌidi ya ginaulidi Diusi dodogadi edi nuꞌu yai yo Yelusalem nuꞌudi yai ni, haꞌa matamai yai ꞌe itadi. Habahim sa wunui be oyagi yai sa tutu fapatu. ");
INSERT INTO bxh_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","In moho lahai fafa faihonana yai, Yaubada ya famwahuli fuyoi na ya fataumahata, ");
INSERT INTO bxh_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","be safalumamai Yaubada haꞌa ya fasinabomai ꞌe ita na hige doga mahudoꞌina i ita. Ai logena maꞌemai ꞌe kalahe yo ꞌe nom gogo ena mwahuli fuyo lahaina mulina yai. ");
INSERT INTO bxh_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ya liba adidili lisimai yai bena wasa loholohona ꞌe lauguguyaꞌen dodoga ai lisidi yo bena ꞌe liba famahata mate, In logena, Yaubada ya fasinabo bena peꞌipeꞌidi yo mwahumwahulidi tau fakasadi. ");
INSERT INTO bxh_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Peloweta mahudoꞌidi haꞌa wasana sa liba famahata tiyen, “Safalumadi sa kawawananahaꞌen haba edi heyaheyaya ya nuwa afuledi, Yesu hesana gigibwalina yai.” ");
INSERT INTO bxh_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita hola ma libalibana na saluma ena wasa sa atahiyen mate Yaluwa Tabuna ya lidima hewadi yai. ");
INSERT INTO bxh_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Tau kawawananaha mwagisadi dududi ꞌwapidi tomotomodi maꞌedi Pita Diyopa yai sa laoma mate sa noꞌo paꞌana Yaubada ena ainauya, Yaluwa Tabuna ya fatamaliyama taꞌowawa dodogadi lisidi yai hinaga. ");
INSERT INTO bxh_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","47","Sa atahi mate alina hesa - hesa yai sa libaliba yo Yaubada sa fafadebasae. Yo fede Pita iyen, Yaluwa Tabuna dodoga ni ya famohafudi gonogonowana doha ita. Babasito hoꞌowa yai hige gonowana sai i gududi. ");
INSERT INTO bxh_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Yo fede ya falibadi bena Yesu Keliso ai hesana sa babasito be Pita sa anꞌetai bena lahai fisa maꞌedi hola sa miya. ");
INSERT INTO bxh_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Tau faꞌona wasawasa yo tau kawawananaha hahaisa Diudeya Nuꞌuna yai sa atahi mate taꞌowawa dodogadi hinaga Yaubada wasana sa abi. ");
INSERT INTO bxh_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Fuyana Pita ya hasai Yelusalem, saluma mwagisa ꞌwapina tomona sa fanuha, sa fatalapili tiyen, ");
INSERT INTO bxh_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","na sa liba tiyen, Sidohana be taꞌowawa edi luma yai wa antaumana yo maidam ami kalahe gogo! Na iti hige “mwagisa ꞌwapina tomona” laulauna ti lau watan. ");
INSERT INTO bxh_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Yo fede somo ya tubu mate Pita ya faliba dudulaidi. ");
INSERT INTO bxh_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Diyopa taonna yai E laulauꞌuꞌula na tautau hesa E ita. Na tautau yai mate ginauli hudoꞌi galewa yai sa dalolo lidima. Nenena doha kaleko hesa laꞌilaꞌi duduna fati E ita na sadaigu yai ya todi. ");
INSERT INTO bxh_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ganahewana E mainene komakomaniꞌi mate suisui fafaꞌahedi fati, Suisui yo ataiꞌa yekoyekodi, yo ginauli kamokamodaladi, amainiya E itadi. ");
INSERT INTO bxh_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Habahim alina hudoꞌi E atahi ya libama lisigu iyen, “Pita, u obiyo! Be am u lau funuhi be u an!” ");
INSERT INTO bxh_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Na alinana E bui, yawa, “Guyau, hige gonowana! Ginauli fafalaugagayodi yo dabudabudi hola hige moꞌagu yai ti luhu.” ");
INSERT INTO bxh_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Alina ya liba boda galewa yai, fafaluwagana iyen, “Tabu somo laꞌi u kawa dabudabuwen mate Yaubada haꞌa ya kawa loholohoꞌedi!” ");
INSERT INTO bxh_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ginauli te ma faihona ya taumahata E ita, habahim mahudoꞌina sa fafuyo hasaen galewa. ");
INSERT INTO bxh_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Hige lofana na dodoga faihona Siseliya yai sa fatamalidima agu halulu be sa mahanoma egu aba miyamiya lumana yai. ");
INSERT INTO bxh_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Yaluwa, nuwagu ya lau fasowali be nuwagu hige i ladu. Yo fede ma afa haidagu, tau kawawananaha faligigi esega te, ꞌe lau. Diyopa yai ꞌe aulaha ꞌe lau Siseliya be ꞌe luhulau Koniliyesi ena luma. ");
INSERT INTO bxh_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Yo fede, Koniliyesi wa, ema ya dede sidohana anelu ya ita ena luma yai ya obiꞌobiyo na anelu ya libalau lisina iyen, “Dodoga u fatamalidi ti lau Diyopa be doga hesa hesana Saimon Pita ti foyahiyama. ");
INSERT INTO bxh_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","In haba emi ya wasa duwai be Guyau haba um yo am boga mahudoꞌidi ya fofofahimiu be ami mwahuli.” ");
INSERT INTO bxh_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Fuyana E fatubu E libaliba, na yo fede Yaluwa Tabuna ya lidima iti hewadi yai gonogonowana doha ita, fuya bwaꞌibwaꞌina yai. ");
INSERT INTO bxh_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Habahim, Guyau ena liba te E nuwatuhui iyen, “Diyon mate hoꞌowa yai ya fafababasito na umi mate Yaluwa Tabuna yai haba ami babasito.” ");
INSERT INTO bxh_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ya mahata wananaha mate Yaubada ena ainauya taꞌowawa ya feledi gonogonowana doha ita te kawawananaha Yesu Keliso lisina yai. Yau hige gonowagu Yaubada ena paisowa ya gudu. ");
INSERT INTO bxh_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Fuyana liba te sa atahiyen yo fede fatalapili sa fatautau na Yaubada sa fadebasae tiyen, “Yaubada fedebom taꞌowawa dodoga hinaga ya ainauyaidi be sa nuwabui be mwahuli hige anadan sa abi.” ");
INSERT INTO bxh_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Fuyana Sitiwin sa lau funuhi umeꞌehu yai, na mulina yai yo fakamkamna laꞌilaꞌi debana yai. Tau kawawananaha hahaisa sa faigelagelainidi be sa lau Fonisiya, Saipelesi yo Antiyoka nuꞌudi yai. Amainiya Yaubada wasana sa libalibaen Diusi dodogadi lisidi yai moho, na hige dodoga hahaisa lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","In moho tau kawawananaha haisa iti Saipelesi yo Sailin dodogadi mate sa lau Antiyoka Nuꞌuna be tau alina Giliki hinaga sa falibadi be Yesu Keliso wasana loholohona sa lauguguyaꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Guyau ena gigibwali yai sa lauguguya be dodoga boludi Guyau sa kawawananahaꞌen be sa nuwabui. ");
INSERT INTO bxh_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Fuyana wasa te, tau kawawananaha Yelusalem yai sa atahiyen mate Banabasi sa fatamali lawen Antiyoka. ");
INSERT INTO bxh_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ena fuya mahano yai Yaubada ena aiꞌainauya lisidi yai ya itadi be nuwana ya amna. Yo fede nuwadi ya liba faꞌadidilidi bena Guyau sa abi didiꞌi ma nuwa ofi fahidi. ");
INSERT INTO bxh_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabasi mate in doga loholohona. Yaluwa Tabuna yo sunuma ya lau fafamohafu be dodoga boludi sa falau esegahi lawen Guyau lisina yai. ");
INSERT INTO bxh_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Habahim Banabasi ya lau Tasusi be Saulo ya yoꞌoi. ");
INSERT INTO bxh_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Fuyanna ya lobahi yo fede Saulo ya foyahi lawen Antiyoka be taudi luwaga, maꞌedi tau kawawananaha ma afa haidadi sa faꞌoigogo esega yo baiwa laꞌilaꞌi sa laulau fafaꞌata ya lau ee–, bolima esega. Be amainiya edi fuya bwaꞌibwaꞌina yai Keliso tau famuli watanna hesadi sa tole mate Kulistin. ");
INSERT INTO bxh_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Lahaina yai mate peloweta haisa Yelusalem yai sa lau Antiyoka. ");
INSERT INTO bxh_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Hudoꞌi mate hesana Agabusi. Yaluwa nuwana ya lau fasowali yo fede ya obiyo be ya liba famahata mate galamo wesawesasa haba nuꞌu mahudoꞌina ya fahoina. (Habahim muli yai guliyam te ya tubu Loma nuꞌuna yai Baꞌisa Laꞌilaꞌi Empela Kaladiusi ena fuya tanuwaga yai). ");
INSERT INTO bxh_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Yesu tau famuli watanna sa oiliba mate hesa - hesa ena ainauya laꞌina yai ya ainauya be haba sa fatamali lawen afa haidadi Diudeya yai sa gogogo, aba saguhidi. ");
INSERT INTO bxh_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Sa ginauli doha ite, habahim edi ainauya wa Banabasi yo Saulo sa fatamali lawen Diudeya babadadi lisidi yai, be tau kawawananaha, sa feledi. ");
INSERT INTO bxh_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Fuyanna yai mate Kin Heloda ya fatubu tau kawawananaha haisa ya abidi be ya fahisu faheyayadi. ");
INSERT INTO bxh_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ya liba be Diyon hidana, Diyemsi, baineti yai sa wunui, ");
INSERT INTO bxh_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","yo ya ita mate Diusi dodogadi nuwadi sa amna yo fede ya lau Pita hinaga ya au. (Ena fuya anꞌauꞌau mate Fwalawa Fafayisti Gesana Anꞌangogona yai.) ");
INSERT INTO bxh_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pita sa au mulina yai, sa gudu buluhi deli yai. Amainiya tau ita wata pele fati, na pele hesa - hesa ganahewana yai mate dodoga fati; pele hesa be ana fuya ya ita wata. Heloda ena nuwatuhu mate Bayawa Anꞌangogona ai mulina haba sa foyahi lawen be sa falau fatala dodoga ai matadi. ");
INSERT INTO bxh_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pita deli yai hola sa abi didini, na tau kawawananaha mate enehena sa anꞌeta adidili Yaubada lisina yai. ");
INSERT INTO bxh_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Heloda bobonna Pita haba ya falau fatala na Pita mate iꞌipa yai ya laulau eno gati luwaga atiꞌatipudi yai. Sa auꞌaui seni luwaga yai na gati luwaga hinaga mate deli edaꞌedana hafohafona sa ita watan. Bobonna habahim, Heloda, Pita haba ya falau fatala. ");
INSERT INTO bxh_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Maꞌesega na, Yaubada ena anelu ya taumahata yo mala ya sina deli ganahewana yai. Anelu ya abilau Pita lisilisina yai na ya fanohi iyen, U obiyo! Feula! Yo fede, seni nimana yai sa taufahi. ");
INSERT INTO bxh_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Habahim anelu iyen, Am bwaꞌulu u au yo am bwaꞌi dala u liꞌodi. Be Pita ena liba ya lau watan. Anelu iyen, Am luhuluhu u luhufi be u lau watanigu. ");
INSERT INTO bxh_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita anelu ya lau watan be sa lau deli bilina ganamulina. Anelu somo ya ginaginauli mate wananahana, na hige i sibai. Ena nuwatuhu bena haga tautau ya itaꞌitai. ");
INSERT INTO bxh_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Gati bwaꞌibwaꞌina yo gati mulimulitana sa bayawaidi be sa mahano lau taon edaꞌedana yai. Na ana gudu aiyan yai sa ginauli mate ibona ya tasoꞌe be sa lau ganamuli. Edaꞌeda esega sa lau watan, yo fede anelu ya lau afulen. ");
INSERT INTO bxh_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Habahim, Pita ya nuwatuhu lobahi, be iyen, Matabahim, E siba wananaha mate Guyau ena anelu ya duiyama be Heloda nimana yai ya fofofahigu yo Diusi somo bena sa ginauli lisigu yai, ibege i tubu. ");
INSERT INTO bxh_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Fuyanna ya nuwatuhu lobahi, yo fede ya lau Diyon Maleko tinana hesana Maliya ena luma. Amainiya boludi sa faꞌoigogo be sa laulauꞌuꞌula. ");
INSERT INTO bxh_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita aba luhuluhu lau edaꞌedana yai ya oiꞌoi, yo fede tau lau fayofayo waihinina hesa hesana Loda ya laoma bena edaꞌeda ya soꞌe. ");
INSERT INTO bxh_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pita alinana ya atahi lobahi mate nuwana ya amna, in moho edaꞌeda hige i soꞌe na ya lautafo ya fuyo be ya falibadi iyen, Pita mate edaꞌeda hafohafona yai ya obiꞌobiyo. ");
INSERT INTO bxh_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Tiyen, Bena u kabakabaleya! In moho ya duduwen iye, Wananaha! Hige ya bwala. Na alinana sa bui, tiyen, Mate, ena anelu. ");
INSERT INTO bxh_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","In moho Pita hola edaꞌeda yai ma oiꞌoina. Fuyanna edaꞌeda sa soꞌe be sa ita mate sa tauhiti. ");
INSERT INTO bxh_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pita nimana yai fafaꞌilala ya ginauli be gagali sa fatautau. Habahim sidohana deli yai Guyau ya foyafahi enehedi ya dede iyen, Diyemsi ma afa haidana edi au liba. Habahim ya lau afuledi na ya lau nuꞌu hesa. ");
INSERT INTO bxh_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Hwalahwalalana tau hiyala sa nuwa ponopono na tiyen, Pita sidohana ena laulau? ");
INSERT INTO bxh_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Heloda ya falibadi be sa yoꞌoi. In moho hige gonowadi ti lobahi. Habahim gati ya fatiꞌo fifisidi be ya liba bena sa wunuidi. Mulina yai Heloda Diudeya Nuꞌuna ya lau afulen na ya lau Sesaliya yai ya miya begana. ");
INSERT INTO bxh_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Heloda mate Taya yo Sidon dodogadi ya manabalaꞌedi. Yo fede sa faꞌoi esegahidi na sa lau be sa ita. Bwaꞌibwaꞌina mate Kin ena luma tau ita watanina hesana Belasetu sa nuwa oiꞌi be haba ya saguhidi, paꞌana adi kalahe mate Kin ena nuꞌu yai ya laolaoma. Logena sa lau Heloda lisina be nuwa esega sa anꞌetai. ");
INSERT INTO bxh_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Lahaina sa golu Kin Heloda ena leli ya liꞌodi. Habahim ena aba taꞌai loholohona yai ya taꞌai na ya libaliba. ");
INSERT INTO bxh_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Na dodoga sa yogayoga tiyen, Hige doga i libaliba. Itete yaubada hesa! ");
INSERT INTO bxh_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Heloda Yaubada hige i faꞌatitiyen be hige walolona Yaubada ena anelu, mwatamwata ya yala fafinahe be sa an funuhi. ");
INSERT INTO bxh_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","In moho, Yaubada wasana ya laꞌi yo ya tadada. ");
INSERT INTO bxh_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Yelusalem yai Banabasi yo Saulo adi paisowa sa faꞌofi be sa fuyo Antiyoka maꞌedi Diyon Maleko. ");
INSERT INTO bxh_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Dubu Antiyoka nuꞌuna yai mate peloweta yo tau lau faꞌata haisa amainiya: Banabasi, Simiyon (hesana hesa “Duba”), Lusiusi (Sailin dogana), Manayen (maꞌena Kin Heloda sa laꞌilaꞌi saema), yo Saulo. ");
INSERT INTO bxh_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Fuya hesa sa laulauꞌuꞌula lau Guyau lisina yo sa anꞌandabu na Yaluwa Tabuna ya falibadi, iyen, “Banabasi yo Saulo au fatabudi, be haba adi paisowa hesa E feledi sa ginauli.” ");
INSERT INTO bxh_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Sa lauꞌuꞌula yo sa andabu mulina yai, nimadi sa tole lawedi lebedi yai, na sa duidi be sa lau. ");
INSERT INTO bxh_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Yaluwa Tabuna ena liba yai Banabasi yo Saulo sa lau Selusiya be waga yai sa awa sa lau Saipelesi Bonabonaluwana. ");
INSERT INTO bxh_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Salamisi taonna yai sa mahano mate Yaubada wasana sa lauguguyaꞌen Diusi edi aba oiꞌoigogo lumana yai. Tau sagusaguhidi Diyon Maleko maꞌedi. ");
INSERT INTO bxh_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bonabonaluwana mahudoꞌina sa laufi ee–, Pafosi taonna yai mate, doga hesa ayaꞌayahanna sa lobahi hesana Ba-Yesu. In Diusi dogana hesa. In moho, in peloweta bwalabwalana. ");
INSERT INTO bxh_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Bonabonaluwa ni edi gawana hesana Segiyo Paulo, ena tau paisowa. Gawana mate doga sibasibana. Ya fanuha bena Yaubada ena liba ya atahi, be Banabasi yo Saulo ya yogaidi sa laoma lisina. ");
INSERT INTO bxh_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Tau ayaꞌayahan ni, (Giliki alinadi yai mate, hesana Elimasi) ya nuwa oiꞌi, be Gawana ena kawawananaha nuwana yai, ya fagogoma. ");
INSERT INTO bxh_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Habahim, Saulo, hesana hesa Paulo, Yaluwa Tabuna ya famohafu be ya itaꞌita lau tau ayaꞌayahan lisina, na iyen, ");
INSERT INTO bxh_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Um Diyabolo natuna yo laulau dudulai mahudoꞌidi adi waiyunu! Diyabolo ena bwalabwala hudoꞌi - hudoꞌi sa famohafum, be fuya ouꞌouli, wa anpate bena Guyau ena laulau dudulaidi wa buidi, be bena bwalabwala! Haba wa fatautau e higeꞌe? ");
INSERT INTO bxh_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Guyau ena gigibwali haba ya talu ai hewam be matam haba sa tou, na fuya haisa ibege maihala malana u ita. Yo fede, Elimasi matana sa gafu, na ya leu ya sae, bena haba sai hesa ya abi nimai. ");
INSERT INTO bxh_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Fuyana Gawana somo ya tubu ya ita mate, Guyau wasana lau faꞌatana ya noꞌoꞌen, be ya kawawananaha. ");
INSERT INTO bxh_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pafosi taonna yai Paulo ma afa haidana waga yai sa awa be sa lau Pelega taonna, Pamfiliya Nuꞌuna yai. Amainiya Diyon Maleko ya lau afuledi na ya fuyo Yelusalem. ");
INSERT INTO bxh_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Habahim Pelega sa lau afulen na sa aulaha boda sa lau Antiyoka, Pisidiya Nuꞌuna yai. Sabatina yai sa luhulau Diusi edi aba oigogo yai be sa taꞌai. ");
INSERT INTO bxh_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mose ena Laugagayo yo peloweta edi uliꞌuli hahaisa sa fatilidi na mulina yai aba oigogo babaꞌisadi liba sa fatamali lawen Paulo ma afa haidana lisidi, tiyen, “Haidamai, haba emi liba faꞌadidili somo? ꞌE fanuha bena ema ami liba!” ");
INSERT INTO bxh_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulo ya obiyo fahi, nimana yai fafaꞌilala ya ginauli, na ya liba iyen, Isalaela tataumiu yo taꞌowawa mahudoꞌimiu salumadi Yaubada ami fafadebasaeꞌen, au ataꞌatahima! ");
INSERT INTO bxh_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Isalaela dodogadi yo ita eda Yaubada wahawahada ya fasinabodi yo Idipi yai fuyanna sa miya taꞌowawa mate ya fatadadadi be sa talu fanafanatu. Yaubada ena gigibwali yai Idipi yai ya foya fahidima, ");
INSERT INTO bxh_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","yo laulau somo sa miyamiyaꞌen nuꞌu pitapitalina yai, in moho hola ya ita watanidi ee–, bolima 40. ");
INSERT INTO bxh_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kanana nuꞌuna yai nuꞌu ouꞌoulidi faligigi luwaga ya faheyayadi, na tanohidi ena dodoga ya feledi, aiꞌedi. ");
INSERT INTO bxh_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ginauli te sa tubu ya lau ee–, be bolima begana haba 450 mulina yai, Yaubada tau fafadudulai ya feledi ya lau wee–, Peloweta Samuwela ena fuya yai. ");
INSERT INTO bxh_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Habahim dodoga Samuwela sa anꞌetai tiyen, “Bena ema kin.” Be Beniyamin ena sulu yai Kisi natuna Saulo ya feledi ya famala edi kin, bolima 40. ");
INSERT INTO bxh_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Yaubada Saulo ya abifahi mulina yai, Deiwidi ya faꞌobiyo, enehedi. Yaubada Deiwidi te ya libaen, iyen, “Dogana E gadolele mate, E lobahi. In mate Desi natuna, Deiwidi. Ginauli mahudoꞌina E fanuha bena ya ginauli, haba ya ginauli watan.” ");
INSERT INTO bxh_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Yaubada ena liba fasunuma ya fawananaha doha ite, Deiwidi laulauwewena yai Yaubada mate tau fafamwahuli Yesu ya leyama Isalaela lebedi ");
INSERT INTO bxh_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Hola hige Yesu ana paisowa i fatubu na Diyon Isalaela dodogadi mahudoꞌidi ya lauguguyaidi bena sa nuwabui yo sa babasito. ");
INSERT INTO bxh_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Diyon ana paisowa ya fafaꞌofi lawen na ya liba iyen, “Ami sibai bena yau, sai? Sai ami bagibagiyen mate hige yau. Muligu yai ya laolaoma mate in ya laoma yau hige ya loholoho haba ana sendolo mahinadi ya tatafahidi.” ");
INSERT INTO bxh_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Afa haidagu, Abelaham afa wahana yo taꞌowawa dodogadi salumadi Yaubada ami fafadebasae! Mwahuli wasana te haꞌa ya laoma ita lisida. ");
INSERT INTO bxh_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yelusalem dodogadi maꞌedi edi babaꞌisa somo peloweta edi uliꞌuli yai, mate hige Yesu ti ita lobahi. In moho edi lau fagilu lisina yai mate peloweta edi uliꞌuli Sabati fuya ouꞌouli sa fatifatilidi wa, sa fawananaha. ");
INSERT INTO bxh_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Hige mata hesa loholohona ti lobahi, be haba Yesu ti wunui, in moho, Pailati sa anꞌetai, bena ya tutu fapatu. ");
INSERT INTO bxh_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Fuyanna wasana mahudoꞌina Buka Tabuna yai sa uli, sa ginauli watan ya ofi, mate aba tutu fapatuna yai sa taluhi fahi be sa boꞌusai. ");
INSERT INTO bxh_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","In moho peꞌi yai Yaubada ya famwahuli fuyoi, ");
INSERT INTO bxh_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","be lahai peidi ya taumahata lau safalumadi maꞌena Galili yai sa lau Yelusalem lisidi. Iti sa fatala libalibaen eda dodoga lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Wasa loholohona ꞌe leyama lisimiu! Somo Yaubada haꞌa ya liba fasunuma bena ya ginauli wahawahada lebedi yai, aho te, ita iti laulauwewedi lisida yai ya fawananaha, fuyana Yesu peꞌi yai ya famwahuli. Doha Samsi fafaluwagana yai sa uli tiyen, “Um mate Natugu. Aho te, Yau E famala Tamam.” ");
INSERT INTO bxh_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Wananaha peꞌi yai Yaubada ya faꞌobiyo fuyoi, ibege i molu, doha Buka Tabuna yai haꞌa ya libaen, iyen, “Libadi wananahadi yo fafatabudi faloholohodi somo, Deiwidi E liba fasunumaꞌen, haba E felemiu.” ");
INSERT INTO bxh_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Gonogonowana doha lausoisoi hesa yai hinaga ya libaen, iyen, “Doga Fafatabuna ibege u ita afulen, i molu.” ");
INSERT INTO bxh_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Deiwidi ena fuya yai mate, Yaubada ena nuwatuhu Deiwidi ya ginauli watan. Habahim ya peꞌi, be afa wahawahana edi aba toledi yai sa boꞌusai, be tauna sa molu. ");
INSERT INTO bxh_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","In moho, Yaubada sai ya faꞌobiyo fuyoi, hige i molu. In mate Yesu! ");
INSERT INTO bxh_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Afa haidagu, E fanuha bena ami sibai mate heyaya biya afulenna Yesu lebena yai, haꞌa sa lauguguyaꞌen lisimiu yai. ");
INSERT INTO bxh_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mose ena laugagayo hige gonowana heyaya yai i biya afulemiu. In moho, safalumadi Yesu sa kawawananahaꞌen, haba heyaya yai ya biya afulen. ");
INSERT INTO bxh_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Au ita komakoman! Somo peloweta sa libaedi, ibe ti tubu ai lisimiu: ");
INSERT INTO bxh_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Tau ala liuliuhwaꞌenna! Haba ami noꞌo, in moho haba ami peꞌi! Paꞌana emi ai fuya haba ginauli E ginaulidi. Ibe sai emi ya liba, ibege au kawawananahaꞌen!” ");
INSERT INTO bxh_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulo yo Banabasi Diusi edi aba oigogo lumana bena haba sa lau afulen, na Diusi yo taꞌowawa salumadi Yaubada sa fafadebasaeꞌen, sa anꞌeta bodaidi, tiyen, Sabati hesa au fuyoma, be ginaulidi te ema au dede fuyo. ");
INSERT INTO bxh_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Oigogo ofina yai, Paulo yo Banabasi sa laulau na Diusi yo taꞌowawa salumadi Diusi edi Yaubada sa kawawananahaꞌen, sa lau watanidi. Tataudi luwaga sa liba faꞌadidilidi, tiyen, Bena Yaubada ena anꞌansoi ami laulawen. ");
INSERT INTO bxh_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sabati hesa yai begana haba taon dodogadi mahudoꞌidi sa faꞌoigogoma, Guyau wasana sa atahi. ");
INSERT INTO bxh_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Diusi dodoga baiwadi sa itadi mate sa nuwa elaꞌela wananaha be Paulo ena liba sa anꞌeli dogodogoi yo sa liba fafaheyaya. ");
INSERT INTO bxh_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","In moho, Paulo yo Banabasi ma nuwa adidilidi, tiyen, Wananahana bena Yaubada libana ꞌe faliba bwaꞌiyemiu, na umi Diusi dodogamiu libana te, ami waiyoꞌoꞌen. Na ami laulau fagilu fuyoꞌimiu. Logena mwahuli otaꞌota fahina hige gonowana au abi be aho te ꞌe lau afulemiu na ꞌe lau taꞌowawa lisidi. ");
INSERT INTO bxh_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Doha ite Guyau ya fatalahada, “E fasinabomiu bena ami famala taꞌowawa edi mala, be tanoꞌubu dodogadi mahudoꞌidi haba egu mwahuli otaꞌota fahina sa abi.” ");
INSERT INTO bxh_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Taꞌowawa sa atahiyen mate nuwadi sa amna be Guyau ena liba sa faꞌatitiyen na safalumadi ya fasinabodi bena mwahuli otaꞌotafahina sa abi mate sa kawawananahaꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Guyau ena liba ya tadada ya lau, nuꞌu mahudoꞌina yai. ");
INSERT INTO bxh_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","In moho Diusi dodogadi mate, wawahin fafahesadi salumadi Yaubada sa fafadebasae yo taon babaꞌisadi sa eli fasifasinadi, na Paulo yo Banabasi sa liba fafaheyayadi yo edi nuꞌu yai sa lau weꞌaidi. ");
INSERT INTO bxh_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Diusi edi nuwa poꞌi debana yai, Paulo yo Banabasi ahedi afusadi sa oiluhiluhidi, na habahim sa lau Ikonium. ");
INSERT INTO bxh_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Yesu tau famuli watanina, nuwadi sa kwade wananaha yo Yaluwa Tabuna ya famohafudi. ");
INSERT INTO bxh_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Laulauna eseꞌesegana ya tubu Ikonium nuꞌuna yai. Amainiya Paulo yo Banabasi sa lau Diusi edi aba oigogo lumana yai be sa lauguguya. Edi libaliba yai nuwadi sa abidi be Diusi yo taꞌowawa dodogadi boludi sa kawawananaha. ");
INSERT INTO bxh_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","In moho Diusi safalumadi Yesu hige ti fanuwa ti kawawananahaꞌen mate taꞌowawa sa eli fasifasinadi be tau kawawananaha sa fawaiyunuwedi. ");
INSERT INTO bxh_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Amainiya sa miya lofalofa be Guyau ena anꞌansoi wasana sa libalibaen ma nuwa adidilidi. Wasana ena fafawananaha mate noꞌo yo fafaꞌilala sa laulau ginauli ena gigibwali yai. ");
INSERT INTO bxh_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Dodogadi taon yai mate sa daili luwagaidi; hahaisa Diusi edi tefa yai na haisa tau faꞌona wasawasa edi tefa yai. ");
INSERT INTO bxh_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Habahim taꞌowawa haisa yo Diusi haisa maꞌedi edi babaꞌisa nuwadi sa fadosidi bena tau faꞌona wasawasa sa abi faheyayadi yo bena sa lau umeꞌehuidi be haba sa peꞌi. ");
INSERT INTO bxh_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","In moho fuyanna tau faꞌona wasawasa wa sa atahiyen, yo fede sa gela be sa lau Lisita yo Debi tefadi yai, Laikoniya Nuꞌuna ganahewana yai yo nuꞌu hahaisa fadifadidi yai. ");
INSERT INTO bxh_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Amainiya wasa loholohona sa lauguguyaꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lisita nuꞌuna yai, taumoho hesa fuyanna tinana ya yosi, mate ya dabi, hige gonowana i laulau. ");
INSERT INTO bxh_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ya taꞌai, na Paulo ena liba ya ataꞌatahi. Paulo ya kino didiꞌi, be ena kawawananaha gonowana ya faloholoho. ");
INSERT INTO bxh_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Na ya liba laꞌilaꞌi, iyen, Ai ahem, u obiyo dudulai! Taumoho ni ya dago hasa, yo fede, ya fatubu ya laulau. ");
INSERT INTO bxh_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Fuyanna Paulo somo ya ginauli dodoga sa ita, yo fede, Laikoniya alinadi yai sa halahalabo, tiyen, Yaubada haꞌa sa famala doha dodoga, be sa lidima lisimai yai! ");
INSERT INTO bxh_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Banabasi hesana sa atahi: “Dusi,” yo Paulo sa atahi “Hemesi,” paꞌana Paulo mate edi tau libaliba. ");
INSERT INTO bxh_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Yaubada bwalabwala “Dusi,” edi dubu aba famwaitona mate, taon ganamulina yai. Dusi ena tau antalasam edi mula hinodi yo bulumakau ya ledima edaꞌeda hafohafona yai, paꞌana in yo taon dodogadi sa fanuha bena edi antalasam tau faꞌona wasawasa sa ginauli lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Paulo yo Banabasi somo dodoga haba sa ginauli sa atahiyen. Yo fede, adi luhuluhu sa pulitidi, na sa lautafotafo lau be baiwa atiꞌatipuna yai, na sa halahalabo felendi, tiyen, ");
INSERT INTO bxh_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Tatau, paꞌana somo be ami ginauli doha? Ai dodoga gaibu moho, doha umi! Wasa loholohona ꞌe leyama te, bena ꞌe falibamiu, be ginauli gaibu ni ami lau afuledi, na ami timuli bui, Yaubada Mwahumwahulina ami famuli watan. In galewa, tanohi, gabogabo, yo somo ouꞌouli ganahewadi yai tau ginaulidi. ");
INSERT INTO bxh_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Beyabeyana yai mate, nuꞌu mahudoꞌidi dodogadi ya ita afuledi, be edi nuwatuhu sa lau watanidi. ");
INSERT INTO bxh_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Fuya ouꞌouli ya fafamahata fuyoi mate, In Yaubada Wananahana. Logena, ginauli lolohodi ya faꞌita lobahimiu: galewa yai usa ya usa, mahula adi fuya yo kalahe ya felemiu, yo kwade nuwamiu ya fafamohafudi.” ");
INSERT INTO bxh_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Lisita dodogadi libadi te sa atahiyen, in moho hige ti modeꞌedi, na sa dudu moho bena antalasam sa ginauli lebedi yai. Na Paulo yo Banabasi sa fuluga be sa gududi. ");
INSERT INTO bxh_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Diusi haisa Antiyoka yo Ikonium nuꞌudi yai sa laoma, be dodoga nuwadi sa abidi. Paulo sa laulau umeꞌehui, be sa feli kwakikwaki lawen, taon mulimulina yai. Edi nuwatuhu bena haga haꞌa ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","In moho, Tau kawawananaha Paulo sa obiyo fataꞌiꞌili, mulina yai mate ya obiyo be ya luhu fuyo taon ganahewana. Bobonna, Banabasi maꞌena sa lau Debi. ");
INSERT INTO bxh_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulo yo Banabasi wasa loholohona sa wasawasaꞌen Debi nuꞌuna yai, be dodoga boludi nuwadi sa abidi, na Yesu sa famuli watan. Habahim, sa fuyo Lisita yo Ikonium, be sa lau Antiyoka Pisidiya nuꞌuna yai. ");
INSERT INTO bxh_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Tau kawawananaha nuꞌudi yai, nuwadi sa liba faꞌadidilidi, be bena edi kawawananaha Yaubada lisina yai ya ota esegahi, na tiyen, “Pilipili hudoꞌi - hudoꞌi bena te fahoinadi, habahim, Yaubada ena Aba Baꞌisa Nuꞌuna haba te luhufi.” ");
INSERT INTO bxh_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Tau kawawananaha pele hesa - hesa yai babada sa lau faꞌobiyo. Sa lauꞌuꞌula yo sa andabu, be babadadi ni Guyau sa kawawananahaꞌen mate, ena itaꞌita wata ganahewana yai sa toledi. ");
INSERT INTO bxh_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidiya nuꞌuna sa lau afulen, habahim sa laoma Pamfiliya nuꞌuna. ");
INSERT INTO bxh_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Amainiya wasa loholohona sa lauguguyaꞌen Pelega nuꞌuna yai. Habahim sa lau Ataliya. ");
INSERT INTO bxh_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Amainiya, waga yai sa gelu be sa fuyo Antiyoka, Siliya Nuꞌuna yai, paꞌana adi paisowa haꞌa sa faꞌofi. Nuꞌuna yai ni, mate Paulo yo Banabasi haꞌa sa fele afuledi Yaubada ena itaꞌita wata ganahewana yai. ");
INSERT INTO bxh_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Fuyanna sa mahano fuyoma Antiyoka yai, mate tau kawawananaha sa faꞌoigogodi. Somo Yaubada ya ginauli lisidi yai yo taꞌowawa dodogadi nuwadi ya famahatadi be sa kawawananaha, edi sa liba. ");
INSERT INTO bxh_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Amainiya, Paulo yo Banabasi maꞌedi Yesu tau famuli watanina sa miya fuya lofalofa. ");
INSERT INTO bxh_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tatau haisa Diudeya yai sa laoma Antiyoka, be tau kawawananaha sa faꞌatadi. Mose ena laugagayo yai sa uli, tiyen, Yena mwagisamiu dududi ꞌwapidi hige tomotomodi, Yaubada hige gonowana i fofofahimiu. ");
INSERT INTO bxh_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Tatau ni, maꞌedi Paulo yo Banabasi lau faꞌata te sa faibayahoꞌen, yo fede, Paulo, Banabasi yo tau kawawananaha haisa sa fasinabodi, be sa hasai Yelusalem be tau faꞌona wasawasa, yo babada haisa amainiya lebedi yai, lau faꞌatana te sa fatiꞌoidi. ");
INSERT INTO bxh_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Tau kawawananaha sa duidi sa lau, be Fonisiya yo Samaliya Nuꞌudi sa bayawaidi, na sidohana taꞌowawa edi nuwanuwa bui, enehedi sa liba. Wasa te, kwade laꞌilaꞌi ya leyama tau kawawananaha lisidi. ");
INSERT INTO bxh_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Sa mahano Yelusalem yai, tau kawawananaha, tau faꞌona wasawasa, yo babada sa lautoꞌiyedi, be ginauli mahudoꞌina Yaubada lisidi yai ya ginauli, edi sa liba. ");
INSERT INTO bxh_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Na tau kawawananaha haisa, iti Falesiya dodogadi edi pele yai, sa mwaito be tiyen, Taꞌowawa bena mwagisadi dududi ꞌwapidi tomodi yo bena Mose ena laugagayo sa lau watan. ");
INSERT INTO bxh_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tau faꞌona wasawasa yo babada sa oigogo be fatiꞌo te sa fadosidi. ");
INSERT INTO bxh_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Sa fadosi fuya lofalofa, habahim, Pita ya mwaito, be ya dede, iyen, Afa haidagu, ami sibai mate Yaubada, beyabeyana haꞌa umi ganahewamiu yai yau ya fasinabogu, bena wasa loholohona te taꞌowawa ai moꞌagu sa atahiyen, be haba sa kawawananahaꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Yaubada doga mahudoꞌina ena nuwatuhu ya sibai, be fuyanna Yaluwa Tabuna ya feledi mate ya faꞌita lobahidi, iti in enehena, doha ita. ");
INSERT INTO bxh_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Iti yo ita gonogonowada. Edi kawawananaha yai, nuwadi ya faꞌaꞌadi. ");
INSERT INTO bxh_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Aho te sidohana be Yaubada ami anpate waloloi? Manana ami fafabala. Mwahu, tau kawawananaha ami feledi te, hige gonowana afa wahada yo ita haba ta bahei! ");
INSERT INTO bxh_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Higeꞌe! Guyau Yesu ena anꞌansoi lisina yai te kawawananaha be ya fofofahida gonogonowana doha iti. ");
INSERT INTO bxh_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Mahudoꞌidi sa famakano, be sa ataꞌatahi. Na Banabasi yo Paulo sidohana Yaubada ya fapaisowadi, be fafaꞌilala yo noꞌo sa lau ginauli taꞌowawa lisidi yai, wasana edi sa liba. ");
INSERT INTO bxh_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Sa libaliba ofi mulina yai, Diyemsi iyen, Haidagu, au ataꞌatahima! ");
INSERT INTO bxh_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Sidohana, Yaubada taꞌowawa ya modeꞌedi, be haisa ya abidi, enehena mate, Saimon haꞌa ya falibada, ");
INSERT INTO bxh_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Peloweta edi liba ya fawananaha, doha Buka Tabuna yai sa uli, tiyen, ");
INSERT INTO bxh_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Ite ai mulina haba E fuyoma, be Deiwidi ena Palai Tabuna E faꞌobiyo fuyoi. Ena heyaheyaya haba E fadudulaidi, na haba E faꞌadidili fuyoi. ");
INSERT INTO bxh_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Be haba dodoga haisa, Guyau sa yoꞌoi, Logedidi, taꞌowawa, safalumadi E yogaidi be iti, enehegu, ");
INSERT INTO bxh_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Doha haꞌa beyabeyana, Guyau ya libaen.” ");
INSERT INTO bxh_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Diyemsi hinaga iyen, Logena, nuwagu yai E fadosi mate, taꞌowawa salumadi sa nuwabui, tabu ta famwahudi. ");
INSERT INTO bxh_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","In moho, bena te uliꞌuli lau lebedi, be te falibadi mate, somo oitau lebedi yai sa antalasamedi, tabu ti anidi. Tabu ꞌwasiꞌwasina ti anidi, yo suisui gadodi filifilisidi hinaga tabu ti anidi. Yo luma gwaꞌu hudoꞌi - hudoꞌi hige Yaubada ena laugagayo yai, tabu ti ginaulidi. ");
INSERT INTO bxh_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Paꞌana, beyabeyana ya laoma ee–, aho ite, mate Mose ena laugagayo sa fatifatili Sabati ouꞌouli aba oiꞌoigogo lumadi yai yo taon hesa - hesa yai sa laulauguguyaꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Habahim tau faꞌona wasawasa yo babada, maꞌedi tau kawawananaha mahudoꞌidi, sa lau fadosi be dodoga ganahewadi yai sa fasinabodi, na sa fatamalidi sa lau Antiyoka maꞌedi Paulo yo Banabasi. Yo fede, babada luwaga, Diudasi (hesana hesa mate Basaba) yo Sailasi sa faꞌobiyodi, babada, ");
INSERT INTO bxh_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","be lisidi yai uliꞌuli sa fatamali: Ai afa haidamiu, Tau faꞌona wasawasa yo babada, ema lautoꞌi ꞌe fatamaliyawa, umi taꞌowawa lisimiu yai, salumadi Antiyoka, Siliya Nuꞌuna yai yo Silisiya yai tau miya. ");
INSERT INTO bxh_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ꞌE atahiyen mate ganahewamiu yai dodoga haisa sa laowa, sa anꞌeli dogodogoꞌemiu, be nuwamiu sa famodedi. In moho, ai hige ai eheꞌedi. ");
INSERT INTO bxh_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Mahudoꞌimai nuwamai esega, be dodoga haisa ꞌe fasinabodi. Afa haidamai loholohodi, Banabasi yo Paulo, maꞌedi ꞌe fatamalidi sa laowa lebemiu. ");
INSERT INTO bxh_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Guyau Yesu Keliso debana yai, sa nuwa afuledi, heyaheyaya yai. ");
INSERT INTO bxh_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Logena, somo ꞌe uliꞌuliꞌi te, Diudasi yo Sailasi, moꞌadi yai haba sa fawananaha ai lisimiu. ");
INSERT INTO bxh_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Yaluwa Tabuna lisina yai ꞌe nuwatuhu fadosi mate ya loholoho, yo ai hinaga, tabu bena laugagayo haisa ti famwahumiu. Ginaulidi moho te, ibodi, au lau watanidi: ");
INSERT INTO bxh_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Somo, oitau lebedi yai sa antalasamedi, tabu au anidi; Tabu ꞌwasiꞌwasina au anidi yo suisui gadodi filifilisidi, hinaga tabu au anidi. Yo luma gwaꞌu hudohudoꞌi hige Yaubada ena laugagayo yai, tabu au ginauli. Yena ami lau watanidi, ibege heyaya au fahoina. Aiyon. ");
INSERT INTO bxh_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Wasa tau lawenina sa duidi be sa lidi Antiyoka. Amainiya tau kawawananaha boludi sa faꞌoigogodi, be uliꞌuli wa sa feledi. ");
INSERT INTO bxh_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Fuyanna edi liba faꞌadidili, wasana sa fatili, nuwadi sa amna! ");
INSERT INTO bxh_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Diudasi yo Sailasi mate iti peloweta hinaga, be edi liba mahudoꞌina yai dodoga sa liba faꞌadidilidi. ");
INSERT INTO bxh_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Amainiya sa miya ee–, habahim, haidadi sa fatamali fafuyodi ma nuwa loholohodi sa fuyo, safalumadi sa fatamalidi, lebedi. ");
INSERT INTO bxh_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Na Sailasi nuwatuhu ya abi, be ya miya. ");
INSERT INTO bxh_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo yo Banabasi sa miyamiya Antiyoka yai, be dodoga haisa maꞌedi, Guyau libana te sa lau faꞌataen yo sa lauguguyaꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Lahai fisa mulidi yai, Paulo ya libalau Banabasi lisina, iyen, Ta fuyo, taon hahaisa yai haidada ta kepaidi, be somo yai Guyau libana eda aba lauguguyaꞌenna, sidohana edi paipaisowa haga ta itadi. ");
INSERT INTO bxh_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabasi ya fanuha bena Diyon Maleko maꞌedi sa lau. ");
INSERT INTO bxh_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","In moho, Paulo ya dudu wananaha be Diyon Maleko hige maꞌedi ti lau, paꞌana Pamfiliya yai ya lau afuledi, be adi paisowa wa hige maꞌedi ti lawen, be ti faꞌofi. ");
INSERT INTO bxh_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Sa faibayaho wananaha, yo fede, sa faitamo dailidi. Banabasi, Maleko ya foyahi, be waga yai sa lau Saipelesi Bonabonaluwana. ");
INSERT INTO bxh_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulo, Sailasi ya fasinabo, mulina yai tau kawawananaha sa fele afuledi Guyau ena itaꞌita wata yai, habahim, sa lau. ");
INSERT INTO bxh_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Edi lau yai Siliya yo Silisiya Nuꞌudi sa antaumanaidi, be tau kawawananaha amainiya nuwadi sa liba faꞌadidilidi. ");
INSERT INTO bxh_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo ya laoma Debi, habahim ya lau Lisita nuꞌuna yai. Amainiya mate, Yesu tau famuli watanina hesa hesana Timoti ya miyamiya. Tinana Diusi waihinina yo in tau kawawananaha hesa. In moho, tamana Giliki dogana. ");
INSERT INTO bxh_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Afa haidana mahudoꞌidi Lisita yo Ikonium yai, Timoti sa kawaloholohoꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo ya fanuha bena Timoti maꞌena sa lau. Diusi nuꞌudi yai sa miyamiya sa sibai mate, Timoti tamana Giliki dogana, yo fede, mwagisana duduna ꞌwapina mate, Paulo ya tomofahi. ");
INSERT INTO bxh_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Sa lau taon hesa - hesa ganahewadi yai, be tau faꞌona wasawasa yo babada Yelusalem yai laugagayo somo haꞌa sa libaedi, bena sa miya watanidi ni, tau kawawananaha, edi sa liba famahata. ");
INSERT INTO bxh_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Tau kawawananaha edi sunuma sa faꞌadidilidi yo lahai esega - esega edi pele ya tadada be ya laꞌilaꞌi ya laulau. ");
INSERT INTO bxh_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Filigiya yo Galeisiya nuꞌudi mate, Paulo ma haidana, sa luhufidi, paꞌana Yaluwa Tabuna ya gududi, be ibege Guyau wasana ai Eisiya ti lauguguyaꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Sa laoma Misiya nuꞌuna anadan yai, sa anpate bena Bitiniya Nuꞌuna sa luhufi. In moho, Yesu Yaluwana ya nuhafidi. ");
INSERT INTO bxh_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Yo fede, Bitiniya sa bayawai moho, be sa lau Tolasi. ");
INSERT INTO bxh_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Maihonana Paulo, Masedoniya taumohona tautauna ya ita. Ya obiꞌobiyo, na ya anꞌanꞌeta lau Paulo lisina iyen, U laoma Masedoniya be u saguhimai! ");
INSERT INTO bxh_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulo tautau ni ya ita, mulina yai, feula na ꞌe abi nonoha, bena haba ꞌe lau Masedoniya. ꞌE siba mate, Yaubada ena yogaimai te, bena ꞌe lau, wasa loholohona ꞌe lauguguyaꞌen ai lisidi. ");
INSERT INTO bxh_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tolasi nuꞌuna yai ꞌe awa, be ꞌe boboyo ꞌe lau Samotase bonabonaluwana, na bobonna mate, ꞌe dohe ꞌe lau Neyapolisi taonna. ");
INSERT INTO bxh_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Amainiya, ꞌe leu Filipi, Loma edi aba baꞌisa nuꞌuna hesa laꞌilaꞌi, Masedoniya Nuꞌuna yai, be amainiya ꞌe miya lahai fisa. ");
INSERT INTO bxh_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sabati yai ꞌe lau hoꞌowa sadaina, taon ganamulina yai. Ema nuwatuhu bena haga Diusi edi aba laulauꞌuꞌula hesa amainiya. Be ꞌe taꞌai, na ꞌe fatubu ꞌe libalau wawahin salumadi sa faꞌoigogoma amainiya, lisidi. ");
INSERT INTO bxh_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Tau ataꞌatahi esega ganahewadi yai hesana mate Lidiya. In Tayataila waihinina, yo Yaubada ya fafadebasae. Kaleko kapikapitadi maisa laꞌilaꞌidi ya uneꞌuneꞌedi. Guyau, waihinna nuwana ya tasoꞌe be ya ataꞌatahi lau Paulo lisina. ");
INSERT INTO bxh_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","In yo ena luma tau miyaina sa babasito, mulina yai mate ya anꞌetaimai, iyen, Yena ami nuwatuhui, Guyau Yesu E kawawananahaꞌen mate au laoma egu ai luma, au miya. Yo fede, ya nuwa liumai be ꞌe famala ana taumana. ");
INSERT INTO bxh_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Fuya ma esega, ꞌe lau aba lauꞌuꞌula nuꞌuna, na tau lau fayofayo waihinina hesa ꞌe failobahi. Yaluwa heyaheyayana ganahewana yai, be somo haba ya tubu ai matadi ya libalibaedi be moni laꞌilaꞌi ya ginauli ana tanutanuwaga, enehedi. ");
INSERT INTO bxh_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Paulo maꞌemai ꞌe laulau, na waihinna te ya lau watanimai, be ya yoga laꞌilaꞌi, iyen, Dodoga te Hewa Wananaha Yaubadana ena tau lau fayofayo! Mwahuli wasana sa laulauguguyaꞌen lebemiu yai. ");
INSERT INTO bxh_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Fuya ouꞌouli doha ite ya ginaginauli, ya laulau ee–, Paulo ya nuwa halahala yo fede, ya timuli bui, be ya libalau yaluwa heyaheyayana lisina, iyen, Yesu Keliso hesana yai E falibam, waihin ni u lau afulen! Maihalana yai ni, ya lau afulen. ");
INSERT INTO bxh_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ana tanutanuwaga sa sibai mate, edi moni aba ginaginaulina edaꞌedana haꞌa ya kwalugeluge. Yo fede, Paulo yo Sailasi sa tohaidi, be sa feli lawedi maketi yai, babaꞌisa matadi yai sa faꞌobiyodi. ");
INSERT INTO bxh_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Sa foya lawedi Loma edi tau fafadudulai lebedi, na tiyen, Diusi dodogadi te, eda dodoga sa eli fasifasinadi. ");
INSERT INTO bxh_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Laulau haisa sa lau faꞌataꞌedi, mate, ita, Loma dodogada, te laugagayoꞌedi. Abiꞌabi te, hige gonowana ta abi watandi. ");
INSERT INTO bxh_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Yo fede, dodoga mahudoꞌidi Paulo yo Sailasi sa tulufidi, habahim, tau fadudulai sa liba be adi luhuluhu sa pwala fahidi, na mada yai sa talaidi. ");
INSERT INTO bxh_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Sa tala fafaheyayadi, mulina yai, deli yai sa gudu buluhidi, be deli tau ita watanina sa faliba bena ya gudu komanidi. ");
INSERT INTO bxh_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Deli tau ita watanina sa faꞌoiliba, be ya lawedi deli bilina ganahewana yai, Amainiya, ahedi sa tole lawedi timba luwaga atiꞌatipudi yai, be sa hafitidi. ");
INSERT INTO bxh_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nuwana doha maihona atipuna, Paulo yo Sailasi sa laulauꞌuꞌula yo sa wanawana lau Yaubada lisina, na tau lau deli haisa mate, sa ataꞌatahi watanidi. ");
INSERT INTO bxh_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Maꞌesega! Mwanuꞌunuꞌu laꞌilaꞌi ya fatubu, be deli lumana umeꞌehudi paꞌa yai ya fadihodihodi. Yo fede, edaꞌeda mahudoꞌidi sa tasoꞌe yo tau lau deli mahudoꞌidi ahedi senidi sa taufahi. ");
INSERT INTO bxh_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Deli tau ita watanina ya eno obiyo mate, deli edaꞌedadi haꞌa sa tasoꞌe, ya itadi. Ena nuwatuhu bena haga tau lau deli haꞌa sa gela, be ena baineti ya solufahi, bena ya gwali fuyoi. ");
INSERT INTO bxh_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Na Paulo ya yoga laꞌilaꞌi, iyen, Tabu ibom u faheyaya fuyoim! Ai mahudoꞌimai, ite! ");
INSERT INTO bxh_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Deli tau itaꞌita watanina mala ya anꞌetai, na ya lautafo lau, be ya guli lidi Paulo yo Sailasi ahedi yai, ma tabutabubuna. ");
INSERT INTO bxh_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Habahim, ya foya lawedi ganamuli, be ya fatiꞌoidi, iyen, Babaꞌisa, somo haba E ginauli, be Guyau ya fofofahigu? ");
INSERT INTO bxh_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Alinana sa bui, tiyen, Guyau Yesu u kawawananahaꞌen, haba um yo em luma tau miyaina mahudoꞌidi ya fofofahimiu be ami mwahuli. ");
INSERT INTO bxh_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Habahim in yo dodoga haisa ena luma yai Guyau ena liba, sa falibadi. ");
INSERT INTO bxh_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Iꞌipana atiꞌatipuna yai ni, deli tau ita watanina ya lawedi, be adi omata ya kaisudi; habahim feula na, in yo ena luma tau miyaina mahudoꞌidi sa babasito. ");
INSERT INTO bxh_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Paulo yo Sailasi ya lawedi ena luma yai, be adi kalahe sa suwa. In yo ana boga mahudoꞌidi nuwadi sa amna, paꞌana Yaubada sa kawawananahaꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Hwalahwalalana, Loma edi Tau fafadudulai, pilisiman sa duidi sa lau, be deli tau ita watanina sa faliba, tiyen, Tatau ni, u soꞌefahidi. ");
INSERT INTO bxh_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Yo fede, deli tau ita watanina Paulo ya faliba, iyen, “Tau fafadudulai liba sa fatamaliyama, bena um yo Sailasi E soꞌefahimiu. Matabahim, ma nuwa esegahimiu, au lau.” ");
INSERT INTO bxh_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Paulo, pilisiman ya falibadi, iyen, Ai mate Loma dodogamai! Na hige ti falau fatalamai, in moho dodoga matadi yai sa talaimai be deli yai sa gudumai. Aho te, bena simosimo yai sa soꞌefahimai? Hige gonowana! Iti bena sa laoma, be sa kamfahimai. ");
INSERT INTO bxh_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Habahim pilisiman, Paulo somo ya falibadi ni, tau fafadudulai edi sa liba. Fuyanna sa atahi, Paulo yo Sailasi iti Loma dodogadi mate, sa ꞌwasabu. ");
INSERT INTO bxh_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Yo fede, sa lau lebedi, be sa anꞌetaidi be edi heyaheyaya sa nuwatuhu afuledi. Habahim sa foya lawedi ganamuli, na sa falibadi be duhu laꞌi sa lau afulen. ");
INSERT INTO bxh_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulo yo Sailasi deli sa lau afulen, be sa lau Lidiya ena luma. Amainiya, tau kawawananaha sa failobahidi yo nuwadi sa liba faꞌadidilidi, habahim sa lau. ");
INSERT INTO bxh_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulo yo Sailasi sa lau Amfipoli yo Apoloniya duhu laꞌidi yai, be sa lau Tesalonika. Amainiya mate Diusi edi aba oiꞌoigogo lumana hesa. ");
INSERT INTO bxh_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paulo in haꞌa ena kamani, ya lau Diusi edi aba oiꞌoigogo lumana. Sabati Lahaidi faihona dodoga ma afa haidadi Buka Tabuna libadi amainiya sa liba faneganegadi, ");
INSERT INTO bxh_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","yo ya fawananaha bukana yai ni, mate Keliso bena ya ankamkamna yo ya mwahuli fuyo. Ya falibadi, iyen, Yesu wasana E guguyaꞌen lisimiu yai te, mate In Keliso yo In Fasinabo Dogana. ");
INSERT INTO bxh_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Diusi hahaisa, yo wawahin fafahesadi yo Giliki dodogadi safalumadi Yaubada sa fafadebasae nuwadi ya abidi, be in yo Sailasi ma afa haidadi sa laoma esega. ");
INSERT INTO bxh_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","In moho, Diusi dodogadi haisa sa nuwa elaꞌela, yo fede, dodoga inono heyaheyayadi maketi yai sa abi gogoidima, be maꞌedi adi sana na taon dodogadi sa eli fasifasinadi, be doga hesa hesana Deisen ena luma sa tulufi. Paulo yo Sailasi sa yoꞌoidi, bena sa aule fakalamahanodima dodoga lisidi. ");
INSERT INTO bxh_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Sa yoꞌo asahaidi, yo fede Deisen yo tau kawawananaha haisa sa solu kwakikwakidi be sa lawedi taon babaꞌisadi lisidi na sa sagasagali tiyen, Dodogadi ni, pilipili sa laulau ginauli nuꞌu mahudoꞌina yai! Na aho ite, sa laoma amaiteꞌi, laulauna hinaga doha. ");
INSERT INTO bxh_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Deisen ya famiyadi ena luma yai na mahudoꞌidi mate Loma Nuꞌuna edi Kin, Sisa, ena laugagayo sa moꞌa peiyen, yo sa libaliba tiyen, Kin hesa, mate hesana Yesu. ");
INSERT INTO bxh_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Liba te sa atahi mate dodoga boludi yo taon babadadi sa fanuwa halahaladi. ");
INSERT INTO bxh_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Babada wa sa liba be Deisen ma afa haidana sa sadidi, habahim sa biya afuledi. ");
INSERT INTO bxh_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ya iꞌipa lau yo fede tau kawawananaha Paulo yo Sailasi sa duidi sa lau Beleya. Sa mahano lau, mate sa lau Diusi edi aba oiꞌoigogo lumana yai. ");
INSERT INTO bxh_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beleya dodogadi nuwadi sa tasoꞌe, hige doha Tesalonika dodogadi, paꞌana fuyanna yai ni liba sa atahi mate sa fanuha wananaha. Fuya ouꞌouli Uliꞌuli Tabudi sa laulau fadosinidi, be haba sa siba mate, wananaha. ");
INSERT INTO bxh_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Diusi boludi, Giliki wawahindi fafahesadi yo Giliki tataudi boludi, somo Paulo ya lauguguyaꞌen, sa kawawananahaꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","In moho, Diusi dodogadi Tesalonika yai sa miyamiya, sa atahi mate Beleya nuꞌuna yai, Paulo Yaubada ena liba ya lauguguyaꞌen, be sa lau amainiya hinaga, be dodoga pwaludi sa eli fasifasinadi. ");
INSERT INTO bxh_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Tau kawawananaha, Paulo sa dui lawen gelegele, na Sailasi yo Timoti sa miya Beleya yai. ");
INSERT INTO bxh_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Amainiya, salumadi Paulo sa fatau saguwen, be sa lau Atensi. Habahim, Paulo ya fafalibadi, iyen, Ami fuyo mate, Sailasi yo Timoti au falibadi, be feula ti laoma lisigu! ");
INSERT INTO bxh_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulo, Atensi nuꞌuna yai Sailasi yo Timoti ya bagibagiyedi. Taonna ya ita mate oitau sa mohafu, be nuwana hige i loholoho. ");
INSERT INTO bxh_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Yo fede, Paulo ma afa haidana Diusi dodogadi yo Giliki dodogadi salumadi Yaubada tau ꞌwasaꞌwasabuwenna ena liba sa fafadosidi, ai aba oiꞌoigogo lumana yo fuya haisadi saluma ya lobahidi ai maketi mate hinaga maidana sa libaliba. ");
INSERT INTO bxh_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Dodoga haisa, edi pele hesadi: Epikule yo Sitowiko, mate sibasiba tau lau faꞌataenna maꞌedi Paulo sa faibayaho. Haisa sa fafatiꞌo fuyoꞌidi, tiyen, Doga ni, somo bena ya libaen? Ena liba mate, kufana! Haisa tiyen, Nuwana, taꞌowawa edi yaubada hahaisa i libalibaedi. Sa liba doha paꞌana Paulo mate, Yesu yo ena obiyo fuyo wasana loholohona ya lauguguyaꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Paulo sa foya lawen, Alepagusi Piuna yai be amainiya edi oigogo ganahewana yai, sa faliba, tiyen, Lau faꞌata fwaufwauna wa lau faꞌataen te, somo? ꞌE fanuha bena ꞌe siba. ");
INSERT INTO bxh_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ginauli haisa wa libaedi mate ꞌe fakaudi be ꞌe fanuha bena aniyodi ꞌe sibaidi. ");
INSERT INTO bxh_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Atensi yo taꞌowawa dodogadi amainiya sa gogogogo mate, ginauli fwaufwaudi moho, sa atahiyedi yo sa libalibaedi. Ginaulidi te, lebedi yai edi fuya sa pei na hige somo hesa lisina yai.) ");
INSERT INTO bxh_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Habahim, Paulo ya obiyo be Alepagusi Konisela nuwanuwadi yai, iyen, Umi Atensi dodogamiu! E itamiu mate ma nuwa ofifahimiu emi yaubada ami fadebasaedi, laulau hudohudoꞌi yai. ");
INSERT INTO bxh_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Emi nuꞌu E fafataꞌiꞌili, na emi aba fafadebasae nuꞌudi E mainene komakomanidi, na aba antalasam hudoꞌi E ita, sa uli tiyen, “Yaubada Hesa Hige ta Sibai, Enehena.” Logena, somo ami fafadebasae, na hige au sibai mate, haba E falibamiu: ");
INSERT INTO bxh_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Yaubada, tanohi tau ginaulina yo ginauli mahudoꞌina ganahewana yai ya ginaulidi, mate In Galewa yo Tanoꞌubu Guyauna. In moho, dubu dodoga nimadi yai sa ginaulidi mate, hige lisidi yai i gogogo. ");
INSERT INTO bxh_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Dodoga hige gonowana somo Yaubada enehena ti ginauli e ti felen paꞌana ibege i kuꞌu. In iyabona mwahuli, yawasi yo ginauli mahudoꞌina, dodoga mahudoꞌidi ya feledi. ");
INSERT INTO bxh_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Doga esega debana yai, doga nene hesa - hesa ya ginaulidi, be tanoꞌubu mahudoꞌina sa miyai. Edi lahai ya nonohai yo edi tanohi sigasigadi ya toledi. ");
INSERT INTO bxh_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Yaubada ya ginauli doha ite, be haba dodoga sa yoꞌoi yo sa anpate adidili be gonowana haba ti lobahi. Paꞌana Yaubada hige edaꞌeda lofalofa yai, ita esega - esega sadaida yai. ");
INSERT INTO bxh_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Doha uliꞌuli hesa ya libaen iyen, “In lisina yai te mwahumwahuli, te mwahiu yo te famala tau wananaha.” Doha hinaga lili tau laulau uli haisa sa uli tiyen, “Ita hinaga laulauwewena.” ");
INSERT INTO bxh_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Logena, ibe ita Yaubada laulauwewena. Tabu Yaubada ta nuwatuhui bena In doha oitau dodoga edi sonoga yai sa ginauli: gole, siluba e umeꞌehu yai. ");
INSERT INTO bxh_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Fuyanna dodoga Yaubada sa fakafakau mate, hige i fagiludi, Na aho te, iyebom, “Dodoga mahudoꞌimiu nuꞌu ouꞌouli yai te, bena ami nuwabui!” ");
INSERT INTO bxh_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Yaubada lahai haꞌa ya nonohai ai lisina haba ena Fasinabo Dogana tanoꞌubu mahudoꞌina ya fakasa ma dudulaina. Yesu peꞌi yai ya faꞌobiyo fuyoi mate, in ena fawananaha, dodoga mahudoꞌidi lebedi yai. ");
INSERT INTO bxh_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Fuyana mwahuli fuyo libana sa atahi mate, haisa sa liuliuhwaꞌen. Na haisa tiyen, Ai ꞌe fanuha bena em liba ni ꞌe atahi fuyoi. ");
INSERT INTO bxh_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Yo fede pwaludi yai Paulo ya lau afuledi. ");
INSERT INTO bxh_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Tatau fisa sa famala Paulo tau famuli watanina yo Yesu sa kawawananahaꞌen. Ganahewadi yai mate: Daiyonisi, in mate Alepagusi dogana hesa laꞌilaꞌina, yo hinaga waihin hesa hesana Damalisi, yo dodoga haisa. ");
INSERT INTO bxh_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Muli yai, Paulo Atensi Nuꞌuna ya lau afulen na ya lau Kolinto. ");
INSERT INTO bxh_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Diusi dogana hesa amainiya ya lobahi hesana Akuila. Ena aba tubu mate Pontusi. Ma lahuna Pisila Itali nuꞌuna yai sa laoma Kolinto. Paꞌana Sisa Kilaudiya ena laugagayo ya tole mate, Diusi dodogadi Itali duhu laꞌi Loma yai ainiya tabu ti miya, habahim ya lau beleleidi be sa lau. Yo fede Paulo ya lau ya kepaidi. ");
INSERT INTO bxh_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ya miya amainiya be ma afa haidana palai sa laulau bodi. Ya famala ena moni edaꞌedana gonogonowana doha iti. ");
INSERT INTO bxh_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sabati ouꞌouli aba oiꞌoigogo ai lumana, sa oiꞌoiliba bena sidohana Diusi yo Giliki ya nuwa oidi. ");
INSERT INTO bxh_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Fuyana Sailasi yo Timoti Masedoniya yai sa laoma, Paulo ena fuya ya pei laulauguguya yai, yo ya liba faneganega Diusi dodogadi lisidi yai mate: Yesu in Keliso. ");
INSERT INTO bxh_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Fuyanna Diusi dodogadi Paulo sa soꞌa fapito yo sa liba fafaheyaya, yo fede ena leli afusadi ya oi luhiluhidi, be ya faꞌita lobahidi mate iti hige Yaubada nuwana ti faloholoho. Ya falibadi, iyen, Yena ami gege, tabu au fagilugu! Aho te, haba E lau taꞌowawa lisidi. ");
INSERT INTO bxh_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Faibayaho te debana yai, Paulo ya lau afuledi. Na ya dohe lau taꞌowawa dogana hesana Titusi Dasitusi ena luma. In Yaubada tau taba ohuina hesa. Ena luma mate aba oiꞌoigogo lumana sadaina yai. ");
INSERT INTO bxh_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Diusi tau foyahidi hesana Kelisipusi yo ena luma tau miyaina mahudoꞌidi, Guyau sa kawawananahaꞌen, yo Kolinto taonna dodoga peidi, wasa sa atahiyen, be sa kawawananaha na sa babasito. ");
INSERT INTO bxh_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Iꞌipa hesa tautau yai Guyau, Paulo ya faliba, iyebom, Tabu u ꞌwasabu! U fafalibadi! U kulu bonoi moho! ");
INSERT INTO bxh_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Yau maꞌem! Ibege sai i faheyayam. Paꞌana taon yai te, egu dodoga sa ouli. ");
INSERT INTO bxh_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Be yo fede Paulo amainiya ya miya ee–, bolima esega nawalahi faligigi esega. Na Yaubada ena liba yai dodoga ya fafatalahadi. ");
INSERT INTO bxh_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Loma babadadi, Galiyo sa faꞌobiyo be Akaiya Nuꞌuna edi Gawana. Ena fuya yai Diusi sa faꞌoigogo be Paulo sa tohai na sa lawen aba lau fatala yai. ");
INSERT INTO bxh_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Sa liba, tiyen, Taumoho te, ema laugagayo ya utusi be dodoga ya faꞌata ponolidi, be hige fadebasae dudulaina ti ginauli Yaubada lisina yai. ");
INSERT INTO bxh_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paulo bena haba ya libafahi, na yo fede, Galiyo, Diusi ya falibadi, iyen, “Ibe wananaha, heyaheyaya kiukiu e laꞌilaꞌi ya ginaginauli, haba emi liba E atahi watan. ");
INSERT INTO bxh_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Na yena ibe umi Diusi emi hesa atahi, liba yo laugagayo lisidi yai; ami famoꞌa oiꞌoi, mate ibomiu au fadudulai. Yau ibege ya fahawasimiu!” ");
INSERT INTO bxh_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Yo fede, aba lau fatala lumana yai ya duidi, be sa lau ganamuli. ");
INSERT INTO bxh_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Habahim, Diusi edi aba oiꞌoigogo tau laulau kulukuluwenna hesana Sositenesi, Giliki dodogadi sa tohai, be aba lau fatala hafohafona yai sa talai. In moho, Galiyo hige i mode. ");
INSERT INTO bxh_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo begana ya miya maidana tau kawawananaha Kolinto yai. Bena ya lau Siliya Nuꞌuna. Yo fede ya lau afuledi, na maidana Pisila yo Akuila sa lau Sensiliya. Hola hige ti auꞌaulaha, na Paulo hola kuluna sa holi paꞌana ena angwala ya ginauli. ");
INSERT INTO bxh_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Fuyanna sa mahano Efeso yai, amainiya Paulo, Pisila yo Akuila ya lau afuledi. Na in ya lau Diusi edi aba oiꞌoigogo lumana yai be ma afa haidana sa laulau fadosi. ");
INSERT INTO bxh_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Dodoga sa anꞌetai bena hola begana ya miya lisidi yai, na hige i tauꞌulu. ");
INSERT INTO bxh_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ya lautoꞌiyedi na iyen, Yena Yaubada ena nuwatuhu yai, haba E fuyoma E itamiu. Habahim Efeso yai waga yai ya awa. ");
INSERT INTO bxh_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Sesaliya yai ya mahano. Habahim ya lau tau kawawananaha Yelusalem yai, ya lautoꞌiyedi. Amainiya ya fuyo Antiyoka, Siliya Nuꞌuna yai. ");
INSERT INTO bxh_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Lahai fisa maꞌedi sa miya Antiyoka yai. Mulina yai, ya aulaha ya lau nuꞌu hesa - hesa Galeisiya yo Filigiya Nuꞌudi ganahewadi yai, be Yesu tau famuli watanina ouꞌoulidi nuwadi ya liba faꞌadidilidi. ");
INSERT INTO bxh_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Fuyanna yai ni, Diusi dogana hesa hesana Apolosi ya laoma Efeso. In mate tau liba sonoga hesa yo Uliꞌuli Tabudi ya siba wananaha. Dogana mate Alesandiya Duhu Laꞌi yai sa yosi. ");
INSERT INTO bxh_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","“Guyau ena Edaꞌeda” mate, dodoga Apolosi sa fatalaha, be ma nuwa adidilina Yesu wasana dudulai yai, ya lau faꞌataen. In moho Diyon ena babasito moho ya sibai. ");
INSERT INTO bxh_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ya fatubu ya libaliba ma nuwa adidilina Diusi aba oiꞌoigogo lumana yai. Fuyanna Pisila yo Akuila wasana sa atahiyen mate Apolosi sa foya lawen edi luma be “Yaubada ena Edaꞌeda” sa faliba faneganega lisina yai. ");
INSERT INTO bxh_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolosi ya fanuha bena ya lau Akaiya Nuꞌuna. Yo fede tau kawawananaha Efeso yai, nuwana sa liba faꞌadidili, yo leta sa uli lawen afa haidadi lisidi Akaiya yai. Leta yai sa falibadi bena ainiya haba sa failobahi. Ena fuya mahano yai, tau kawawananaha salumadi Yaubada ena ainauya ya feledi mate Apolosi ena sagu laꞌilaꞌi lisidi yai. ");
INSERT INTO bxh_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Dodoga matadi yai, ya liba adidili, be Diusi edi liba ya liba golugoludi yo Uliꞌuli Tabuna yai ya fawananaha mate Yesu in Fasinabo Dogana, Keliso. ");
INSERT INTO bxh_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolosi hola ma miyamiyana Kolinto Taonna yai. Na Paulo Eisiya Nuꞌuna ganahewana yai ya lau fote leu Efeso taonna. Amainiya tau famuli watanina haisa ya failobahidi, ");
INSERT INTO bxh_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","be ya fatiꞌoidi, iyen, Fuyanna ami kawawananaha mate, Yaluwa Tabuna ami abi, e hola? Alinana sa bui, tiyen, Higeꞌe! Yaluwa Tabuna mate somo? Hige wasana ai sibai. ");
INSERT INTO bxh_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paulo ya fatiꞌoidi iyen, Babasito somo - somohena ami abi? Alinana sa bui tiyen, Diyon ena babasito. ");
INSERT INTO bxh_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paulo iyen, Diyon ena babasito mate tau nuwabui, enehedi. Habahim Diyon, Isalaela dodogadi ya falibadi mate mulina yai, doga tau laoma ni bena sa kawawananahaꞌen - mate Yesu ai lisina. ");
INSERT INTO bxh_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Wasa te sa atahiyen, yo fede Guyau Yesu hesana yai sa babasito. ");
INSERT INTO bxh_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paulo nimana ya tole lawen lisidi, yo fede Yaluwa Tabuna ya laoma lebedi. Alina hesa - hesa yai sa libaliba yo nuwatuhu somo Yaluwa ya feledi sa libalibaedi. ");
INSERT INTO bxh_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Tatau oulina doha safuhudohudoꞌi luwaga. ");
INSERT INTO bxh_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulo ya lau Diusi edi aba oiꞌoigogo lumana yai be amainiya nawalahi faihona ma nuwa adidilina dodoga maꞌena sa libaliba. Nuwadi bena sidohana ya abidi be sa laoma Yaubada lisina ya famala edi baꞌisa. ");
INSERT INTO bxh_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","In moho, haisa sa nuwa poꞌi be ena liba hige ti lau watan yo “Guyau ena Edaꞌeda Fafamuli Watanina” sa liba faheyaya dodoga matadi yai. Yo fede, Paulo ya lau afuledi na tau kawawananaha ma afa haidana sa lau be doga hesa hesana Tailanusi ena aba lau faꞌata lumana yai, ya lau faꞌata lahai esega - esega yai. ");
INSERT INTO bxh_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Lau faꞌata ni sa laulawen ee–, boliman luwaga be Diusi yo Giliki salumadi Eisiya nuꞌuna yai sa miyamiya mate Yaubada ena liba sa atahiyen. ");
INSERT INTO bxh_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Yaubada Paulo ya fapaisowa be noꞌo sa diꞌo wananaha, ya lau ginauli, ");
INSERT INTO bxh_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","be yena muyahasa aba sausau e liꞌo dala Paulo tauna sa eliꞌina na sa lawedi tau asiꞌasiyebo sa faꞌeliꞌinadi haba sa loholoho yo yaluwa heyaheyayadi sa lau afuledi. ");
INSERT INTO bxh_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Diusi haisa fuya ouꞌouli sa lau sa adaꞌadau be yaluwa heyaheyayadi sa liba duidi mate hinaga sa anpate bena yaluwa heyaheyayadi sa liba duidi Guyau Yesu hesana yai. Yo fede yaluyaluwa ni sa falibadi tiyen, Yesu hesana Paulo ya fapaisowa be ya lauguguya mate hesana yai, au kalamahano! ");
INSERT INTO bxh_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Diusi edi tau antalasam baꞌisana hudoꞌi hesana Sekewa nanatuna tatau faligigi luwaga laulau ni sa ginaginauli. ");
INSERT INTO bxh_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Fuya hesa yaluwa heyaheyayana hudoꞌi alinadi ya bui iyen, Yesu yo Paulo hinaga E sibaidi. Na umi safaluma? ");
INSERT INTO bxh_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Yo fede doga yaluwa heyaheyayana lisina yai ni ya tulufidi be ya lei hafihafitidi. Ya antalainidi, be ma tau afaꞌafadi yo ma omaꞌomatadi ena luma sa gela afulen. ");
INSERT INTO bxh_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Wasa te Diusi yo Giliki, Efeso yai sa miyamiya, sa atahiyen mate mahudoꞌidi ꞌwasabu ya famohafudi be Guyau Yesu hesana sa faꞌatitiyen. ");
INSERT INTO bxh_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Habahim tau kawawananaha peidi sa laoma Paulo lisina yai be edi heyaheyaya sa liba famahatadi. ");
INSERT INTO bxh_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Tau ayaꞌayahan yo tau kalakalawan hahaisa edi ginauli bukadi sa abi gogondima, be sa gabu goludi dodoga matadi yai. Bukadi maisadi sa pei gogondi, mate, laꞌina doha siluba piꞌadi 50 tausan. ");
INSERT INTO bxh_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Laulaudi te lisidi yai, Guyau ena liba ya tadada heyaheyaya, ma gigibwalina. ");
INSERT INTO bxh_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Efeso yai somo sa tubu na mulidi yai, Paulo ena nuwatuhu bena ya lau Yelusalem. Na hola ya bwaꞌi ya lau Masedoniya yo Akaiya Nuꞌudi yai, na ai mulina, haba ya lau Yelusalem. Yo iyen, Ainiya, habahim E lau Loma E antaumanaidi. ");
INSERT INTO bxh_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Tau saguhina luwaga, Timoti yo Elasetusi ya fatamalidi, sa lau Masedoniya na in Eisiya nuꞌuna yai ya miya begana. ");
INSERT INTO bxh_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Fuyanna yai, faibayaho laꞌilaꞌi ya tubu mate, “Guyau ena Edaꞌeda” debana yai. ");
INSERT INTO bxh_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Siluba tau laulau ginauli hesana Dimetiyusi, yaubada bwalabwala waihinina hesana Atemesi, aba fafadebasaena dubuna tautauna mate lumadi kikiluka siluba yai ya ginaulidi be lisidi yai tau paisowa sa uneꞌuneidi be maisadi, moni laꞌilaꞌidi sa abiꞌabinidi. ");
INSERT INTO bxh_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Yo fede, maidadi salumadi nima paisowa hudohudoꞌidi lisidi yai doha iti adi paisowa ya yoga gogondi sa laoma be ya falibadi iyen, Tatau! Paisowa yai te, ami sibai mate eda moni eda aba lobahina. ");
INSERT INTO bxh_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Dodoga boludi Efeso yo Eisiya Nuꞌuna yai, Paulo ya nuwa oidi be ya foya ponolidi mate haꞌa ami itadi yo ami atahiyedi, yo ya liba, iyen, “Dodoga nimadi yai yaubada sa laulau ginauli, hige yaubada wananahadi.” ");
INSERT INTO bxh_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Heyaya amainiya! Hige moni eda aba ginaulina moho Paulo i liba faheyaya. Yo hinaga yaubada waiwaihinna, Atemesi, aho te, sa fadebasae Eisiya nuꞌuna mahudoꞌina yo tanoꞌubu mahudoꞌina yai, ibege ena dubu ti faꞌatitiyen yo ena gigibwali haba ya gogoma. ");
INSERT INTO bxh_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Baiwa liba te sa atahiyen yo fede sa gafu pou be sa halahalabo tiyen, “Efeso dodogada! Eda yaubada, Atemesi ya hasai wananaha!” Na ti yoga boda, “Efeso dodogada! Eda yaubada, Atemesi ya hasai wananaha!” ");
INSERT INTO bxh_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Taon dodogadi, bobohalahala ya laꞌi wananaha be Masedoniya dodogadi luwaga, Geiyesi yo Alisitaku, iti Paulo afa haidana, sa solu weꞌaweꞌa lawedi aba oigogo laꞌilaꞌina yai. ");
INSERT INTO bxh_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo ya fanuha bena ya lau baiwa matadi yai ya libaliba, na tau kawawananaha sa laugagayoꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Eisiya babadadi haisa, Paulo afa haidana, hinaga liba sa fatamali. Sa anꞌetai bena tabu i lau aba fafaꞌoigogo laꞌilaꞌi yai. ");
INSERT INTO bxh_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Dodoga sa faꞌoigogoma mate, nuwadi sa ponopono; haisa ginauli hesa sa halahalaboꞌen, na haisa somo hesa. Somo ana halulu sa lau niya mate, dodoga boludi hige ti sibai. ");
INSERT INTO bxh_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Diusi dodogadi sa andudu balabala be Alesandiya sa lawen baiwa nuwanuwadi yai. Na haisa baiwa ganahewana yai, sa yoga lau lisina, sa fatalaha bena somo ya laulau te ya liba famahata. Habahim, Alesandiya nimana ya lau hitin bena gagali sa fatautau be haba ya falibadi mate somo ya laulau te, hige Diusi dodogadi adi gilu. ");
INSERT INTO bxh_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Fuyanna sa nuwatuhu lobahi in Diusi dogana mate mahudoꞌidi sa halahalabo gogo tiyen, Efeso dodogada! Eda yaubada, Atemesi ya hasai wananaha! Doha mate sa laulau bodai ee–, awa luwaga sa ofi. ");
INSERT INTO bxh_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Efeso edi taon kalakina, ya lau biliyedi be gagali sa fatautau. Na iyen, Efeso taonna tataumiu! Doga mahudoꞌina tanoꞌubu yai sa sibai mate Atemesi ena dubu yo umeꞌehu fafatabuna galewa yai ya beꞌuma, ita te itaꞌita watanidi. ");
INSERT INTO bxh_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Mahudoꞌimiu mate ami sibai mate ginaulidi te, wananaha. Au famakano! Tabu au nuwa feula! ");
INSERT INTO bxh_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Tatau ami foyahidima amaiteꞌi mate hige eda dubu yai ti angafu, e eda yaubada waiwaihinna ti liba fafaheyaya. ");
INSERT INTO bxh_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Aba lau fatala soꞌesoꞌedi, yo tau fafadudulai sa miyamiya, be ibe Dimetiyusi yo falena tau paisowa edi fatala pili sai hesa lisina yai, gonowana sa fadudulai. ");
INSERT INTO bxh_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Yena liba haisa sa otaꞌota, mate hinaga ai aba lau fatala haba sa fadudulaidi. ");
INSERT INTO bxh_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Somo aho te ya tubu, mate hige aniyona. Yena ami bobohalahala, ai halana haba sa fagilumiu be sa falau fatalamiu. Haba somo ami libaen? ");
INSERT INTO bxh_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ya libaliba ofi, mulina yai, oigogo ya gudu. ");
INSERT INTO bxh_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Bobohalahala ya ofi na habahim Paulo liba ya fatamali lawen Guyau tau famuli watanina lisidi be sa laoma lebena. Ena liba faꞌadidili ya libaen lebedi yai, habahim ya lau aiyoniyedi na ya aulaha ya lau Masedoniya. ");
INSERT INTO bxh_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ena aba lau yai nuꞌudi ya bayawaidi ni mate liba faꞌadidili boludi dodoga edi ya liba, habahim ya mahano lau Giliki Nuꞌuna yai. ");
INSERT INTO bxh_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Amainiya ya miya nawalahi faihona. Hanahanau haba ya lau Siliya, na ya siba mate Diusi nuwatuhu heyaheyayana sa oiꞌoilibaen bena sa ginauli ai lisina, yo fede, nuwana ya bui be ya fuyo Masedoniya. ");
INSERT INTO bxh_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Timoti, Pilusi natuna Sopata, Beleya dogana, Alisitaku yo Sekundu, Tesalonika dodogadi, Gaiyu, Debi dogana, Tisiku yo Tofimu, Eisiya dodogadi. Dodoga te maꞌedi Paulo sa lau. ");
INSERT INTO bxh_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Waga yai sa bwaꞌi sa lau Tolasi be amainiya yau yo Paulo sa bagibagiyemai. ");
INSERT INTO bxh_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Na tataumai luwaga ꞌe lau fote ꞌe lau Filipi nuꞌuna. Fwalawa Fafayisti Gesana Mataꞌasina mulina yai, waga hudoꞌi yai ꞌe awa, ꞌe lau ee–, lahai faligigi mulina yai ꞌe mahano Tolasi Nuꞌuna yai be tau bwaꞌi maidamai ꞌe faꞌoigogo esegahimai. Amainiya e miya lahai faligigi luwaga. ");
INSERT INTO bxh_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Lahai bwaꞌibwaꞌina wiki ganahewana yai ꞌe falau esegahimai bena ꞌe anꞌangogo. Paulo dodoga ya fafalibadi ee–, iꞌipa atipuna paꞌana bobonna haba ya lau afuledi. ");
INSERT INTO bxh_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ema aba oiꞌoigogo bilina, hewa yai mate lampa boludi amainiya. ");
INSERT INTO bxh_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Hewali hesa hesana Yutikasi mate bilitun yai ya taꞌataꞌai. Paulo ena libaliba ya lofa ee–, hewali te matana ya enoꞌeno. Ya eno tau ꞌwafuꞌwafu yo fede luma hitina fafa faihonana yai ya eno beꞌu be ya lidi tanohi yai. Sa abi hitin mate peꞌipeꞌina. ");
INSERT INTO bxh_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paulo ya lidi, ya hoba tawan be ya laba. Na ya falibadi iyen, Tabu au mode, ma mwahumwahulina! ");
INSERT INTO bxh_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Habahim ya finahe fuyo hewa be fwalawa ya ifi, be sa an. Ya libaliba ee–, maihala ya kepama na mulina yai ya lau afuledi. ");
INSERT INTO bxh_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Dodoga ma nuwa loholohodi hewali te ma mwahumwahulina sa lawen luma. ");
INSERT INTO bxh_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ꞌE bwaꞌi ꞌe lau waga, be ꞌe awa ꞌe lau Asosi. Ainiya haba Paulo ya awa, paꞌana in ya falibamai mate ya lau fote. ");
INSERT INTO bxh_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Asosi yai ꞌe failobahi fuyo be waga yai maꞌemai ꞌe lau Mitilene. ");
INSERT INTO bxh_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Bobonna ꞌe awa boda ee–, ꞌe mahano Kiyosi bonabonaluwana. Bobonna ꞌe dohe Samosi bonabonaluwana, na lahai fafaihonana yai ꞌe mahano lau Miletu taonna. ");
INSERT INTO bxh_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo ena nuwatuhu bena Efeso ꞌe bayawai, tabu maihala ai pei ai Eisiya Nuꞌuna. Ibe sidohana na yena gonowana ai Pentekosi lahaina ꞌe mahano Yelusalem. ");
INSERT INTO bxh_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Miletu nuꞌuna yai, Paulo liba ya fatamali lawen Efeso dubu tanutanuwagadi lebedi bena sa laoma sa failobahi. ");
INSERT INTO bxh_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Sa mahano ya falibadi iyen, Fuya ouꞌouli yau maꞌemiu na egu miyamiya haꞌa ami sibai. Lahai bwaꞌibwaꞌina E mahanoma Eisiya Nuꞌuna yai, ya laoma ee–, aho te. ");
INSERT INTO bxh_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Diusi edi nuwatuhu heyaheyayadi lebegu yai ya famala egu pilipili, In moho, E nuwa lidilidi yo ma matasulugu Guyau ena paisowa E ginaulidi. ");
INSERT INTO bxh_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ginaulidi somo E laulauguguyaꞌedi, aba saguhimiu mate E lau faꞌataen luma hesa - hesa yai. Hige laꞌi ya nuhafi. ");
INSERT INTO bxh_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Diusi yo Giliki dodogadi E liba fanuwa tagudi, bena sa nuwa bui Yaubada ai lisina yo Yesu eda Guyau bena sa kawawananahaꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Yaluwa Tabuna ena dudu yai, aho te E lau Yelusalem. Somo haba ainiya ya tubu lisigu yai, hige ya sibai. ");
INSERT INTO bxh_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Taon mahudoꞌidi yai, Yaluwa Tabuna ya liba fanuwa tagugu mate deli, pilipili yo heyaheyaya sa bagibagiyegu. ");
INSERT INTO bxh_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Yau hige ya mode wananaha lisigu yai. Ibe moho failako te E faꞌofi yo Guyau Yesu paisowa ya felegu mate bena Yaubada ena ainauya, wasana loholohona, liba famahatana hinaga bena E faꞌofi. ");
INSERT INTO bxh_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","E laulau asiꞌasi, Yaubada ena Aba Baꞌisa Nuꞌuna E laulauguguyaꞌen lisimiu yai. Aho te E sibai, ibege au ita fuyoꞌigu. ");
INSERT INTO bxh_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Lisina yai aho ite, E liba famahata lisimiu yai mate, yena sai laꞌi ya fuyo mulina, ena heyaheyaya giluna ibege ya bahei. ");
INSERT INTO bxh_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Paꞌana Yaubada ena nuwatuhu mahudoꞌidi mate E fafalibamiu, hige ya nuhafidi. ");
INSERT INTO bxh_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Be ibomiu au ita watan fuyoꞌimiu, yo safalumadi mahudoꞌidi Yaluwa Tabuna nimamiu yai ya tole afuledi hinaga au ita watanidi. Iti logedi, Yaubada ena dubu dodogadi, Natuna ꞌwasinana yai ya unedi. ");
INSERT INTO bxh_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Egu siba gonowana mate yena E lau afulemiu, ꞌwayoꞌwayowa anꞌannalidi haba sa laoma ganahewamiu yai, be sipi sa fadabalaladi. ");
INSERT INTO bxh_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Dodoga haisa ganahewamiu yai, liba dudulaidi haba sa fakampiledi, be bwalabwala. Bena haba Guyau tau famuli watanna haisa sa foya hudoꞌiyedi. ");
INSERT INTO bxh_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Au ita komakoman, yo au nuwatuhui! Ma matasulugu, iꞌipa yo lahai, bolima faihona liba fanuwa tagu lisimiu yai hige ya fatautau. ");
INSERT INTO bxh_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Be aho te, E tole afulemiu Yaubada lisina yai. Ena ainauya ya duwai libana au nuwatuhui! Gonowana ya faꞌadidilimiu, be dodogadi fafagabidi mahudoꞌidi maꞌedi haba ainauya ami abidi, aiꞌemiu. ");
INSERT INTO bxh_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Hige sai laꞌi ena siluba, gole o leli ginaulidi ya fanuhadi. ");
INSERT INTO bxh_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Umi haꞌa ami siba mate nimagu luwaga E fapaisowadi be yau yo haidagu ema fanufanuha E ginaulidi. ");
INSERT INTO bxh_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Abiꞌabi mahudoꞌina haꞌa E faꞌitamiu. Bena te paisowa adidili be tau belubelu te saguhidi. Yesu Keliso alinana doha ite, Wa ansoi mate kwadena ya laꞌi, na sa felem mate kwadena ya kiu. Libadi te bena nuwamiu yai sa ota esegahidi. ");
INSERT INTO bxh_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paulo ya libaliba ofi, sa tuli bono gogo be ya lauꞌuꞌula. ");
INSERT INTO bxh_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Mahudoꞌidi sa fagado bainewaꞌen, sa falafu yo sa tan. ");
INSERT INTO bxh_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Nuwadi sa heyaya wananaha, paꞌana iye, Ibege au ita fuyoꞌigu. Yo fede, sa lau watan be maꞌedi sa lau waga. ");
INSERT INTO bxh_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ꞌE lau aiyoniyedi ma nuwa heyayamai, na ꞌe lau afuledi. Waga yai ꞌe awa be ꞌe dudulai, ꞌe lau Kosi. Bobonna Lodesi bonabonaluwana ꞌe mahano be amainiya ꞌe lau Patala. ");
INSERT INTO bxh_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Waga hesa ꞌe lobahi ya laulau Fonisiya, yo fede, amainiya ꞌe awa ꞌe lau. ");
INSERT INTO bxh_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ꞌE lau ee–, Saipelesi bonabonaluwana tefa seuseulimai yai ꞌe ita. Amainiya ꞌe dudulai ꞌe lau Siliya Nuꞌuna. Waga ana husahusa Taila taonna yai haba sa lau fapesa, be Amainiya ꞌe tulubeꞌu, ");
INSERT INTO bxh_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","na ꞌe lau Yesu tau famuli watanina haisa ꞌe yoꞌoyoꞌoidi ee–, ꞌe lobahidi be ma afa haidamai ꞌe miya lahai faligigi luwaga. Yaluwa Tabuna ena gigibwali yai Paulo sa faliba, tabu i lau Yelusalem. ");
INSERT INTO bxh_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ema fuya awa lahaina yai, dubu dodogadi mahudoꞌidi, ma afa lalahudi yo nanatudi, sa lau watanimai ꞌe lau taon ganamulina. ꞌE lau gelegele yai be amainiya ꞌe tuli bono, na ꞌe lauꞌuꞌula. ");
INSERT INTO bxh_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Esega - esega ꞌe lautoꞌiyen, habahim waga ꞌe awa boda, na iti sa fuyo edi luma. ");
INSERT INTO bxh_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Taila ꞌe lau afulen, na ꞌe lau Pitolemaisi. Amainiya afa haidamai ꞌe lautoꞌiyedi, be lisidi yai ꞌe miya lahai esega. ");
INSERT INTO bxh_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Bobonna ꞌe awa boda ee–, ꞌe mahano Sesaliya taonna yai. Be amainiya tau laulauguguya hesana Pilipi lebena yai ꞌe miya. Tau faisagusagu faligigi luwaga beyabeyana sa fasinabodi Yelusalem yai, maꞌedi. ");
INSERT INTO bxh_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Nanatuna fati hasahasaladi mate tau liba peloweta. ");
INSERT INTO bxh_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Lahai fisa amainiya ꞌe miya, mulina yai mate peloweta hesa hesana Agabusi Diudeya yai ya lidima lebemai. ");
INSERT INTO bxh_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Paulo ana bwaꞌulu, Agabusi ya abi na ibona nimana yo ahena ya audi na iyen, Yaluwa Tabuna alinana doha ite: bwaꞌulu tanuwagana te, haba Diusi sa auꞌaui ai Yelusalem doha itete na haba sa fele lawen taꞌowawa lisidi. ");
INSERT INTO bxh_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ai yo nuꞌu ni dodogadi, liba te ꞌe atahiyen mate Paulo ꞌe liba buluhi, tabu i lau Yelusalem. ");
INSERT INTO bxh_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Na Paulo alinadi ya bui iyebom, Somo ami ginauli? Tabu au tantan! Nuwagu ami fafaheyaya. Ai Yelusalem ibe sa augu be sa wunuigu Guyau Yesu debana yai, mate gonowana. ");
INSERT INTO bxh_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Hige gonowana ai nuwa liuꞌi, yo fede nuwamai ya toma, be aiyawa, “I otawa! Yaubada ena nuwatuhu moho i ginauli.” ");
INSERT INTO bxh_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Lahai fisa amainiya ꞌe miya, mulidi yai, ema ꞌe nonoha na ꞌe lau Yelusalem. ");
INSERT INTO bxh_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Sesaliya dodogadi haisa, iti Yesu tau famuli watanina, ma afa haidamai ꞌe lau gogo be sa lawemai Minason lebena. In Saipelesi dogana yo Yesu tau famuli watanina hesa bwaꞌibwaꞌina. ");
INSERT INTO bxh_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Yelusalem ꞌe mahano mate afa haidamai sa yoga hitinimai ma kwadedi. ");
INSERT INTO bxh_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Bobonna Paulo maꞌemai ꞌe lau Diyemsi lebena; na dubu babadadi mahudoꞌidi, sa laoma. ");
INSERT INTO bxh_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paulo ya lautoꞌiyedi na habahim, ena paisowa ganahewana yai somo Yaubada ya ginauli taꞌowawa lisidi yai, wasadi edi ya dede. ");
INSERT INTO bxh_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Sa atahiyen, yo fede mahudoꞌidi Yaubada sa fadebasae. Na dodoga haisa Paulo sa faliba tiyebom, Hidamai, wa siba mate amaiteꞌi, Diusi tausan boludi Yesu haꞌa sa kawa wananahaꞌen yo hinaga ma adidilidi Mose ena Laugagayo sa abi didin. ");
INSERT INTO bxh_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Yelusalem yai sa atahiyen, mate Diusi sa miyamiya taꞌowawa nuꞌudi yai wa lau faꞌatadi, uwen, “Tabu Mose ena Laugagayo au lau watanidi, Tabu nanatumiu mwagisadi dududi ꞌwapidi au ibodi, Yo tabu ada ulu tubu laulaudi ti lau watanidi.” ");
INSERT INTO bxh_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Haꞌa sa atahiyen mate um haꞌa wa mahanoma. Be haba sidohana eda libaliba? ");
INSERT INTO bxh_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Somo ꞌe falibam u ginauli be dodoga fati edi angwala haꞌa sa ginauli ma afa haidamiu au lau, ");
INSERT INTO bxh_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","be au faꞌaꞌa fuyoimiu, yo edi antalasam u famaisadi. Mulina habahim kuludi sa holidi. Be haba dodoga sa ita lobahi, mate wananaha, Mose ena laugagayo wa laulau watan. Na somo - somo sa libalibaedi, fede bwalabwala. ");
INSERT INTO bxh_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Tau kawawananaha iti taꞌowawa dodogadi, haꞌa ꞌe uliꞌuli lau lebedi, be ema nuwatuhu ꞌe falibadi, aiyawa, “Somo oitau lebedi yai sa antalasamedi, tabu ti anidi. Tabu ꞌwasiꞌwasina ti anidi, yo suisui gadodi filifilisidi hinaga tabu ti anidi. Yo luma gwaꞌu hudoꞌi - hudoꞌi hige Yaubada ena laugagayo yai, tabu ti ginaulidi.” ");
INSERT INTO bxh_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Bobonna dodoga wa Paulo ya auledi, be maꞌedi sa faꞌaꞌa fuyoꞌidi. Habahim ya lau Dubu Tabuna dobidobina yai be antalasam tau ita watandi ya falibadi, haba lahaina somo edi faꞌaꞌa ya ofi, yo atasi haba esega - esega ena ainauya tau antalasam ya gabu. ");
INSERT INTO bxh_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Edi lau faꞌaꞌa lahaidi faligigi luwaga begana haba sa ofi, na Diusi haisa Eisiya Nuꞌuna yai tau laoma sa laoma Paulo sa ita Dubu Tabuna dobidobina yai. Yo fede, dodoga boludi sa eli fasifasinadi, be Paulo sa tohai. ");
INSERT INTO bxh_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Na sa yogayoga tiyen, Isalaela dodogamiu! Au saguhimai! Doga te, Mose ena Laugagayo yo Dubu Tabuna te ya liba faheyayadi yo ita hinaga. Yo hesauna, eda laugagayo ya utusi, mate Giliki dodogadi haisa ya foyahi lawedi dobidobi yai te. ");
INSERT INTO bxh_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Paulo, maꞌena Efeso dogana hesana Tofimu taon yai sa itadi be edi nuwatuhu bena haga Paulo ya foya lawen amainiya. ");
INSERT INTO bxh_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Dodoga haisa taon yai sa eli fasifasinadi be tefa hesa - hesa yai sa leꞌo fahima, be Paulo haꞌa sa tohai wa, sa solu kwakikwaki lawen Dubu Tabuna dobidobina fafaluwagana ganana mulina yai. Hige walolona na edaꞌeda sa gududi. ");
INSERT INTO bxh_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Bena sa tala funuhi na wasa ya lau Loma tau hiyala edi baꞌisa lebena, mate bobohalahala laꞌilaꞌi Yelusalem yai. ");
INSERT INTO bxh_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Yo fede, feula na, hiyala tau lau kulukuluwenna yo ena tau hiyala ya foyahidi be sa lautafo lidi baiwa lisidi. Baiwa wa tau hiyala sa itadi yo fede Paulo talaina sa fatautau. ");
INSERT INTO bxh_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Tau hiyala edi baꞌisa ya lau Paulo ya au, yo ya liba be seni luwaga yai sa faseni. Habahim ya fatiꞌo iyen, Sai itete? Ena ponoli somo? ");
INSERT INTO bxh_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Pwaludi yai mate dodoga sa fatala yogayoga. Hesa - hesa ena liba ya laulau hudoꞌi. Bobohalahala ya laꞌi be hiyala baꞌisana hige gonowana Paulo ana mata paꞌana wananahana i lobahi. Yo fede tau hiyala ya falibadi be Paulo sa lawen edi baleki. ");
INSERT INTO bxh_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Tau hiyala Paulo sa famahano pampeꞌo yai, yo fede sa bahei, paꞌana dodogadi boludi sa manabala. ");
INSERT INTO bxh_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Dodoga boludi sa laulau watan, sa halahalabo, tiyen, Au tala funuhi! ");
INSERT INTO bxh_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Tau hiyala begana haba Paulo sa lawen edi baleki ganahewana. Na Paulo ya fatiꞌo lau komanda lisina iyen, Ibe gonowana somo hola E falibam? Baꞌisa iyen, Giliki alinadi fede wa siba! ");
INSERT INTO bxh_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Um Idipi dogam? Logena, nahalidi yai ite, gabeman bena wa hiyalaidi yo dodoga 4,000 wa lawedi nuꞌu pitapitalina yai. ");
INSERT INTO bxh_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulo iyen, Higeꞌe! Yau Diusi dogana. Na, Tasusi taonna yai sa yosigu, Sisiliya nuꞌuna yai, nuꞌu fafahesana yau dogana wananahana. Aee–, ibe gonowana dodoga somo E falibadi? ");
INSERT INTO bxh_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Tau hiyala edi baꞌisa ya tauꞌulu, yo fede Paulo pampeꞌo yai ya mwaito, nimana ya lau hitiꞌi be sa famakano, na Hebelu alinadi yai ya libalau lisidi. ");
INSERT INTO bxh_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Falegu Diusi, hola au ataꞌatahi, na egu E tona galagala. ");
INSERT INTO bxh_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Hebelu dodogadi alinadi yai ya fafalibadi sa atahi mate sa famakano; habahim Paulo iyen, ");
INSERT INTO bxh_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Yau Diusi dogana, Tasusi yai sa yosigu Sisiliya nuꞌuna yai na Yelusalem yai E laꞌilaꞌi. Gamaliyeli mate agu tanuwaga yo in ada ulu tubu edi laugagayo ya fatalaha komakomaniꞌigu. Yau hinaga E fele fuyoꞌigu Yaubada ena paisowa yai, gonogonowana doha aho, umi te. ");
INSERT INTO bxh_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","‘Yesu ena Edaꞌeda” tau lau watanina mate E faꞌankamkamnadi. Haisa E falau delidi yo haisa E wunuidi. ");
INSERT INTO bxh_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","“Tau Antalasam Baꞌisana yo Sanhedeli Konisela sa sibai mate E liba dudulai, paꞌana beyabeyana pepa sa uli be sa felegu, be E lawen faleda Diusi haisa Damaseko yai E feledi, be Yesu tau kawawananahaꞌenna E ledima Yelusalem yai be E faꞌankamnadi.” ");
INSERT INTO bxh_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Edaꞌeda yai E laulau ee–, begana haba lahai laꞌi, mate Damaseko E hanahanaui, yo fede, mala namanamalina galewa yai ya sina fataꞌiꞌiligu. ");
INSERT INTO bxh_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","E beꞌu lidi tanohi yai, na alina ya libama lisigu E atahi iyen, “Saulo, Saulo! Paꞌana somo wa fakamkamnagu?” ");
INSERT INTO bxh_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Alinana E bui yawa, “Guyau, um sai?” Na ya libama iyen, “Yau Yesu, Nasaleta dogana, logegu, wa fakamkamnagu.” ");
INSERT INTO bxh_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Afa haidagu mala sa ita na doga ya libalibama hige ti atahi lobahi. ");
INSERT INTO bxh_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","E fatiꞌo yawa, “Guyau, somo haba E ginauli?” Na iyen, “U mwaito na u lau Damaseko. Ainiya somo bena wa ginaulidi haba sa falibam.” ");
INSERT INTO bxh_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Mala namanamalina matagu ya an, be sa tou, yo fede afa haidagu sa abi nimaigu be sa foya lawegu Damaseko. ");
INSERT INTO bxh_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Taumoho hesa amainiya ya miyamiya hesana Ananiya ya laoma lebegu. In Yaubada ena laugagayo ya famuli watan komakomaniꞌidi be Diusi mahudoꞌidi amainiya sa fafaꞌatitiyen. ");
INSERT INTO bxh_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ya laoma lisigu be sadaigu yai ya obiyo na iyen, “Hidagu Saulo, matam ti loholoho fuyo!” Yo fede, matagu sa loholoho be gonowana E ita. ");
INSERT INTO bxh_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ananiya iyen, “Afa wahawahada edi Yaubada haꞌa ya fasinabom, bena haba ena fanufanuha wa sibai, Tau Laulau Dudulai Dogana haba wa ita, yo alinana wa atahi. ");
INSERT INTO bxh_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Somo wa ita yo wa atahiyen haba wasana wa fatadada dodoga mahudoꞌidi ai lebedi. ");
INSERT INTO bxh_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Somo wa bagibagiyen? U obiyo, be ti fababasitom! Guyau hesana yai u anꞌeta be em heyaheyaya i kaisudi!” ");
INSERT INTO bxh_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Fuyanna E fuyo Yelusalem, Dubu Tabuna dobidobina yai E laulauꞌuꞌula na tautau E ita. ");
INSERT INTO bxh_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Tautau ni ganahewana yai Guyau ya libama lisigu iyen, “Feula! Yelusalem u lau afulen paꞌana dodoga te hige gonowana wasagu wa libalibaen ti abi.” ");
INSERT INTO bxh_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Alinana E bui yawa, “Guyau! Dodoga te haꞌa sa sibaigu. Beyabeyana E lau edi aba oiꞌoigogo lumadi yai be safalumadi sa kawawananahaꞌem E antalainidi yo E falau delidi. ");
INSERT INTO bxh_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Na wasam tau fatadadana Sitiwin, sa lau umeꞌehui, mate yau amainiya. Ena peꞌi yau E ehe watan, yo tau wunuina adi luhuluhu E itaꞌita watanidi.” ");
INSERT INTO bxh_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Habahim Guyau ya falibagu iyen, “U lau! Yau E fatamalim be wa lau edaꞌeda lofalofa, be wa lau taꞌowawa lisidi.” ");
INSERT INTO bxh_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Paulo, taꞌowawa wasadi ya libalibaedi, yo fede sa sagasagali ma alina laꞌilaꞌidi tiyen, Au wunui! Hige ena dudulai bena i mwahuli. ");
INSERT INTO bxh_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Edi manabala sa famahata be sa halahalabo, luhuluhu sa kamfahidi yo gegebula sa tepa be sa fafapei hasa. ");
INSERT INTO bxh_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Tau hiyala edi baꞌisa laꞌilaꞌi ya liba be Paulo sa lawen edi baleki. Ena tau hiyala ya falibadi bena sa pidili, yo sa fatiꞌoi, sidohana be sa halahalabo lau lebena. ");
INSERT INTO bxh_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Paulo sa au fapatu bena sa talai, na ya libalau hiyala tau lau kulukuluwenna ya obiꞌobiyo lisina, iyen, Wananaha laugagayo ya libaen bena Loma dogana hola hige ti sadi, ami tala gaibui? ");
INSERT INTO bxh_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Hiyala tau lau kulukuluwenna ya atahi mate ya lau ena baꞌisa laꞌilaꞌi ya fatiꞌoi iyen, Somo wa ginaginauli? Doga ni Loma dogana! ");
INSERT INTO bxh_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Yo fede tau hiyala edi baꞌisa ya lau Paulo ya fatiꞌoi iyen, Haga u falibagu. Wananaha um Loma dogana? Paulo iyen, “Ii–, Yau Loma Dogana.” ");
INSERT INTO bxh_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Habahim hiyala tau lau kulukuluwenna baꞌisana iyen, Yau E laoma mate moni laꞌilaꞌi E pei be E famala Loma dogana. Paulo alinana ya bui iyen, Tinagu ya yosigu, yau Loma dogana. ");
INSERT INTO bxh_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Haisa bena sa fatiꞌoi mate sa suha afulen. Paꞌana hiyala tau lau kulukuluwenna edi baꞌisa ya siba mate Paulo in Loma dogana, na sa seni napai, yo fede, ya ꞌwasabu. ");
INSERT INTO bxh_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Bobonna hiyala tau lau kulukuluwenna edi baꞌisa ya fanuha bena Paulo ana mata ya yoꞌoi. Yo fede ya liba, be senina sa kamfahidi, na tau antalasam babaꞌisadi yo Sanhedeli pelena mahudoꞌidi ya faꞌoigogodi. Habahim Paulo ya leyama be matadi yai ya faꞌobiyo. ");
INSERT INTO bxh_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo, Sanhedeli ya kino didinidi na iyen, Falegu Isalaela! Yaubada matana yai egu laulau sa dudulai ya laoma ee–, aho te, yo nuwagu yai hige somo heyaheyayana ya ginauli. ");
INSERT INTO bxh_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Yo fede Tau Antalasam Baꞌisana, Ananiya ya liba, be safalumadi Paulo fadidina yai sa mwaimwaito bena ai moꞌana sa oi. ");
INSERT INTO bxh_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Habahim Paulo ya libalau lisina iyebom, Um doha ginauli hesa mulimulina nenena olina, na ganahewana ya bida heyaya! Wa taꞌai, be laugagayo yai bena wa fadudulaigu, in moho, laugagayona wa utusi, be wa falibadi sa talaigu! Yaubada haba hinaga ya talaim. ");
INSERT INTO bxh_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Dodoga haisa Paulo sadaina yai sa obiꞌobiyo tiyen, Fede Yaubada ena Tau Antalasam Baꞌisana fafalibana doha? ");
INSERT INTO bxh_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulo alinadi ya bui iyen, Haidagu, hige ya sibai mate, in Tau Antalasam Baꞌisana. Doha haꞌa sa uli tiyen, “Dodoga adi tanuwaga tabu u liba faheyaya!” ");
INSERT INTO bxh_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paulo ya siba mate haisa iti Sadusi na haisa mate Falesiya, yo fede Sanhedeli ganahewana yai ya yoga laꞌilaꞌi iyen, Afa haidagu! Yau hinaga Falesiya, Falesiya hesa natuna yau. Ami falau fatalagu paꞌana E kawawananaha mate tau peꞌipeꞌi haba sa mwahuli fuyo! ");
INSERT INTO bxh_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Libana te ya libaen yo fede Falesiya yo Sadusi sa faibayaho fuyoꞌidi be sa faitamo dailinidi. ");
INSERT INTO bxh_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Sadusi sa liba mate hige mwahuli fuyo yo hige anelu yo yaluyaluwa. In moho Falesiya mate ginaulidi te sa kawawananahaꞌedi.) ");
INSERT INTO bxh_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Bobohalahala ya laꞌi ya laulau na laugagayo tau lau faꞌataena haisa, iti Falesiya peledi sa obiyo fahi, be sa liba adidili tiyen, Doga te, hige ena heyaya somo ai lobahi! Nuwana yaluyaluwa e anelu i libalibama lisina! ");
INSERT INTO bxh_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Faibayaho ya laꞌi wananaha, yo fede Komanda ya ꞌwasabu be iyen, Ibe Paulo ti tabe motumutu. Yo fede ena tau hiyala ya duidi be sa lidi (yai), Paulo sa mupafahi nuwanuwadi yai, be sa lawen tau hiyala edi baleki. ");
INSERT INTO bxh_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Maihonana mate Guyau ya obiyo Paulo sadaina yai na iyen, Nuwam i adidili! Yelusalem yai ꞌwasagu haꞌa wa duwai, ai Loma hinaga haba doha wa ginauli. ");
INSERT INTO bxh_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Bobonna Diusi haisa simosimo yai edi sa oiliba. Sa angwala mate ibege somo hesa ti an e ti nom ee–, Paulo sa wunui. ");
INSERT INTO bxh_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Oiliba te ganahewana yai mate dodoga ouꞌoulidi 40 ya diꞌoi. ");
INSERT INTO bxh_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Habahim sa lau tau antalasam edi babaꞌisa yo Diusi babadadi lisidi na tiyen, ꞌE angwala haꞌa mate ibege somo ai an ee–, Paulo ꞌe wunui. ");
INSERT INTO bxh_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Aho te, Sanhedeli maꞌemiu emi anꞌeta bwalabwala au fatamali lawen Loma edi Komanda lisina be Paulo i fatamaliyama lisimiu na auwe, “ꞌE fanuha bena Paulo ꞌe fatiꞌo buibui be matana somo ꞌe sibai.” Haba ai edaꞌeda ꞌe nahai, be ꞌe unui. ");
INSERT INTO bxh_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Paulo ena golowa edi oiliba heyaheyayana wasana ya atahiyen. Yo fede ya lau tau hiyala edi baleki yai be Paulo ya liba fanuwatagu. ");
INSERT INTO bxh_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Habahim Paulo ya yoga lau hiyala tau lau kulukuluwenna hesa lisina iyen, Hewali te u lawen komanda lisina. Somo hesa bena ya faliba. ");
INSERT INTO bxh_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Yo fede hiyala tau lau kulukuluwenna ya lawen Komanda lisina be ya faliba iyen, Tau lau deli, Paulo, ya yogaigu na ya anꞌetaigu bena hewali te E leyama lisim be nuwatuhu hesa haba em ya liba. ");
INSERT INTO bxh_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Komanda, hewali ni ya foya hudoꞌiyen be ya fatiꞌoi iyen, Somo bena wa falibagu? ");
INSERT INTO bxh_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Alinana hewali ya bui iyen, Diusi babadadi nuwadi esega be sa anꞌetaim bena bobon Paulo wa lawen Sanhedeli lisidi, be au bwalabwala yai sa fatiꞌo buibui. ");
INSERT INTO bxh_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","In moho tabu alinadi u lau watanidi paꞌana tau nahaina ouꞌoulidi 40 ya diꞌo mate sa bagibagiyen. Haꞌa sa angwala mate ibege somo ti an o ti nom ee–, Paulo sa wunui. Haꞌa sa nonoha, na em yali moho sa bagibagiyen. ");
INSERT INTO bxh_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Habahim komanda, hewali ya liba fanuwatagu iyen, U koman! Tabu sai hesa u faliba mate edi bwala te, haꞌa wa fafinaheyama lisigu. Yo fede ya dui ya lau. ");
INSERT INTO bxh_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Habahim komanda ena hiyala tau lau kulukuluwendi luwaga ya yogaidima be fatalawaudi iyen, Tau hiyala 200, yo hosi tau awaidi 70, yo alahiya tau abidi 200, au nonohaidi. Haba 9 koloki ma afa haidamiu ami lau Sesaliya. ");
INSERT INTO bxh_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Hosi fisa au abi nonohaidi, be haba Paulo ma loholohona ami lawen Gawana Filiki lisina. ");
INSERT INTO bxh_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Na habahim Komanda leta ya uli doha ite: ");
INSERT INTO bxh_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Yau Kilaudiya Laisiya E uliꞌuliwa, Um ma hesam, Gawana Filiki! Yauwedo. ");
INSERT INTO bxh_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Doga te, Diusi sa tohai be egoba sa wunui. In moho tau hiyala ma afa haidagu ꞌe laoma be ꞌe galatata, paꞌana E sibai, in, Loma dogana. ");
INSERT INTO bxh_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Somo lisina yai sa fafagilu E fanuha bena E sibai. Logena E lawen Diusi edi Konisela Sanhedeli lisidi. ");
INSERT INTO bxh_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","E lobahi mate iti ibodi edi laugagayo fatiꞌodi yai sa fafagilu. Hige laꞌi i ginauli ponoli haba ti falau deli e ti wunui. ");
INSERT INTO bxh_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Muliyai, egu sa liba mate Diusi haisa simosimo yai sa oiꞌoiliba bena doga te sa wunui. Yo fede feula E duiyawa lisim yo tau fagiluna E falibadi somo lisina yai sa sadi, bena sa fafinaheyawa lebem. ");
INSERT INTO bxh_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Tau hiyala nuwatuhu te sa lau watan be maihonana Paulo sa lawen Antipatili Taonina. ");
INSERT INTO bxh_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Bobonna tau lau fote sa fuyo edi baleki Yelusalem yai na hosi tau awaidi maꞌedi Paulo sa lau Sesaliya, ");
INSERT INTO bxh_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","be pepa Gawana sa felen na Paulo sa tole afulen lisina yai. ");
INSERT INTO bxh_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gawana leta te ya fatili ofiꞌi, ya fatiꞌo lau Paulo lisina iyen Em nuꞌu somo? Gawana ya lobahi mate in Sisiliya dogana. ");
INSERT INTO bxh_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Paulo ena liba Gawana Filiki ya atahi, be iyen, Yena tau fagilum sa mahanoma haba em pilipili E fadudulai. Habahim ya liba be Paulo sa gatiꞌi Heloda ena luma laꞌilaꞌina yai. ");
INSERT INTO bxh_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Lahai faligigi mulidi yai Tau Antalasam Baꞌisana, Ananiya, yo babada haisa maꞌedi loiya, hesana Tetulusi sa lidi Sesaliya sa lau Gawana Filiki matana yai, be Paulo sa sadi. ");
INSERT INTO bxh_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Habahim Paulo sa yoga lawen na Tetulusi ya fatubu ya libaliba iyen, Baꞌisa! Em ita wata ganahewana yai ꞌe miya komakoman fuya lofalofa, yo em sibasiba yai ema miyamiya haꞌa wa fadudulaidi. ");
INSERT INTO bxh_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Filiki! Laulau hesa - hesa yai yo tefa ouꞌouli yai ema lautoꞌi laꞌilaꞌi um lisim yai. ");
INSERT INTO bxh_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Hige ya fanuha bena amnam ya faheyaya. Aee–, E anꞌetaim moho ibe ema liba tupotupona te wa atahi. ");
INSERT INTO bxh_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Doga te E lobahi mate, in heyaheyaya tau laulau fatubu; Diusi dodogadi nuꞌu hesa - hesa yai, in tau eli fasifasinadi yo Nasaleta Pelena tau foyahina hesa. ");
INSERT INTO bxh_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","8","Yo Dubu Tabuna hinaga ya anpate bena ya faheyaya, logena ꞌe tohai. Dogana te ena libaliba hola u fadosi yo ena laulau u ita sipoi, haba iyabom wa sibai somo halana be ꞌe sadi. ");
INSERT INTO bxh_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Tetulusi somo ya libaen mate Diusi sa ehe watawatan. Tiyen, Ii–, Logena! ");
INSERT INTO bxh_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Habahim Gawana nima yai Paulo ya faliba be ya libaliba. Yo fede Paulo iyen, E siba mate, um tau fafadudulai bolima lofalofa nuꞌu yai te. Be ma nuwa loholohogu egu E tona galagala. ");
INSERT INTO bxh_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ibom, gonowana wa yoꞌoi be wa fawananaha mate lahai safuhudohudoꞌi luwaga ganahewadi yai Yaubada fadebasaena ana halulu E hasai Yelusalem, ");
INSERT INTO bxh_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","hige sai laꞌi maꞌegu ai faibayaho na ti lobahimai Dubu Tabuna dobidobina yai e dodoga ya eli fasifasinadi Diusi edi aba oiꞌoigogo lumadi yai e duhu laꞌi mahudoꞌina ganahewana yai. ");
INSERT INTO bxh_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Sadi somo sa ginauli lisigu yai, hige gonowana ti fawananahadi lebem yai. ");
INSERT INTO bxh_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","E faliba dudulaim moho mate afa wahamai edi Yaubada E fafadebasae, na “Edaꞌeda” mate yau E fafamuli watan. Diusi safaluma Keliso hige ti famuli watan, edi nuwatuhu mate Yesu ena lau faꞌata mate bwalabwala. Yo hinaga ginauli mahudoꞌidi Mose ena Laugagayo yai yo Peloweta sa ulidi mate E kawawananahaꞌedi. ");
INSERT INTO bxh_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Egu sunuma Yaubada lebena yai gonogonowana doha tau sadigu te. Logena, tau laulau dudulai yo tau heyaya haꞌa sa peꞌi, haba sa obiyo fuyo. ");
INSERT INTO bxh_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Fuya ouꞌouli E anpate adidili bena egu laulau sa dudulai Yaubada matana yai yo dodoga matadi yai hinaga. ");
INSERT INTO bxh_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Yelusalem E lau afulen bolima fisa, habahim E fuyom. E laoma bena egu antalasam E ginauli yo egu dodoga tau deha bena E ainauyaidi. ");
INSERT INTO bxh_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Dubu Tabuna ganahewana yai egu lau faꞌaꞌa haꞌa E abi, ya ofi na sa lau lobahigu. Hige bobohalahala yo hige baiwa ma afa haidagu. ");
INSERT INTO bxh_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","In moho, Diusi haisa Eisiya yai sa miyamiya, iti ibe aiteꞌi, haba edi sadigu mata paꞌana somo ai matam sa libaen. ");
INSERT INTO bxh_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Yena higeꞌe, beti, salumadi iti amaiteꞌi, fuyanna E obiyo Sanhedeli matadi yai, na lau pono somo E ginauli bena sa libaen. ");
INSERT INTO bxh_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ginauli esega moho mate nuwana fuyanna matadi yai E obiyo na E yoga, yawa, “E kawawananaha mate, tau peꞌipeꞌi haba sa mwahuli fuyo! Logena, aho te wa fadudulaigu.” ");
INSERT INTO bxh_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Habahim Filiki, in “Edaꞌeda Dodogadi” tau sibaina mate, lau fatala ya golu boda na iyen, Yena Komanda Laisiya ya mahanoma, haba fadudulai ofiꞌofina E ginauli ai lisim. ");
INSERT INTO bxh_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Be hiyala tau lau kulukuluwenna ya faliba, iyen, Paulo u gatin, na fuya haisa u soꞌe fahi haba haidana sa laoma ena fanuha somo ena sa felen. ");
INSERT INTO bxh_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Lahai fisa sa ofi, mulidi yai, Filiki lahuna Dusila ya aulen be maꞌena sa laoma. In mate Diusi waihinina. Paulo ana liba ya fatamali be ya laoma, Yesu Keliso sunumaꞌenna libana bena ya dedei be sa atahi. ");
INSERT INTO bxh_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Laulau dudulaina, eda amna tabu i foya faheyayada, yo fakasa lahaina ya laolaoma, mate Paulo ya guguyaꞌen. Ma libalibana na Filiki ya ꞌwasabu, be iyen, Aꞌai, na u lau! Yena egu solasola haba E yoga fuyoꞌim. ");
INSERT INTO bxh_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Fuyanna yai ni mate, ena nuwatuhu bena haba Paulo ya nuwa liui be moni ena ya felen. Logena, ya yogayoga fuyoiyama be fuya ouꞌouli maꞌena sa libaliba. ");
INSERT INTO bxh_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Bolima luwaga sa abi didin mulidi yai, Posiu Fesitu, Filiki ya falau damahi be ya gawana. In moho Filiki bena Diusi nuwadi ya faloholoho be Paulo, hige i soꞌe fahi. ");
INSERT INTO bxh_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Gawana Fesitu ya mahanoma nuꞌuna yai, na lahai faihona mulidi yai, Sesaliya Nuꞌuna ya lau afulen na ya aulaha ya hasai Yelusalem. ");
INSERT INTO bxh_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Amainiya maꞌena tau antalasam babaꞌisadi yo Diusi babadadi sa faꞌoigogo be edi lau fagilu sa fafinahe bodai. ");
INSERT INTO bxh_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Fesitu sa anꞌetai be bena Paulo ya fatamali lawen Yelusalem, paꞌana ai edaꞌeda haba sa nahai be sa wunui. ");
INSERT INTO bxh_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Alinadi ya bui iyen, Paulo haꞌa deli yai Sesaliya yai. Hige walolona haba E fuyo niya. ");
INSERT INTO bxh_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Yo fede ya falibadi iyen, “Tanutanuwaga haisa ma afa haidagu ai lau Sesaliya. Be yena taumoho te somo ya ginauli faheyaya haba ana sadi ami felen.” ");
INSERT INTO bxh_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesitu maꞌedi sa miya nuwana lahai 8 e 10, na habahim sa lidi Sesaliya. Bobonna aba lau fatala yai ya taꞌai na habahim ya lau faliba be Paulo sa leyama. ");
INSERT INTO bxh_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paulo sa famahanoyama, Diusi safalumadi Yelusalem yai sa laoma sa obiyo fafataꞌiꞌili, na edi lau fagilu peidi sa libaedi Paulo hewana yai, in moho, edi aba fagiluna hige aba fawananahadi. ");
INSERT INTO bxh_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paulo ena ya tona galagala iyen, Yau hige Diusi edi laugagayo ya utusi, e Dubu Tabuna ya faheyaya, e Loma edi Kin Sisa lisina yai somo ya ginauli faheyaya. ");
INSERT INTO bxh_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fesitu, bena Diusi nuwadi ya faloholoho, yo fede ya fatiꞌo lau Paulo lisina iyen, Wa fanuha bena wa lau Yelusalem, be ainiya E falau fatalam? ");
INSERT INTO bxh_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulo iyen, Hige gonowana! Itete Loma Baꞌisana, Sisa, ena aba fafalau fatala yai, bena aiteꞌi sa falau fatalagu. Um hinaga haꞌa wa sibai mate hige somo laꞌi ya ginauli faheyaya Diusi lebedi yai. ");
INSERT INTO bxh_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ibe laugagayo E utusi, yo somo E ginauli faheyaya maisana peꞌi, mate ena dudulai. Ibege ya anfaleyen. In moho, ibe yena bwalabwala yai agu maisa sa felegu, hige sai laꞌi ena dudulai bena i tolegu nimadi yai. Logena, Loma Baꞌisana Sisa E anꞌetai bena egu lau fatala ya atahi. ");
INSERT INTO bxh_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fesitu tau faliba fasibasibana, maidana sa oiliba ofi, mate ya libalau Paulo lisina iyen, Haꞌa Loma Baꞌisana wa anꞌetai, be haba wa lau lisina. ");
INSERT INTO bxh_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Lahai fisa mulidi yai Kin Agilipa yo lofuna Benisi sa lau Sesaliya be Fesitu sa antaumanai yo sa lautoꞌiyen. ");
INSERT INTO bxh_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Amainiya sa miya lahai fisa, habahim, Fesitu, Paulo wasana ya dedei Kin Agilipa lisina yai. Iyen, Taumoho hesa amaiteꞌi, Filiki ya falau deli be ya lau afulen. ");
INSERT INTO bxh_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Na fuyanna E lau Yelusalem, tau antalasam baꞌisadi yo Diudeya babadadi sa anꞌetaigu, bena ana sadi E felen. ");
INSERT INTO bxh_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Na alinadi E bui, yawa, “Ai Loma ema laulau mate, ibege doga ai fagilu napai be ai fele afulen tau fagiluna nimadi yai. Bwaꞌibwaꞌina bena enehena ya tona galagala ai matadi.” ");
INSERT INTO bxh_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Tau fagiluna sa laoma amaiteꞌi mate hige ya bagibagi. Bobonna, aba laulau fatala yai E taꞌai na liba E fatamali be Paulo sa leyama. ");
INSERT INTO bxh_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Tau fagiluna sa mwaito be sa libaliba, na nuwagu yai yawa, “Haba somo lisina yai ana sadi sa felen?” ");
INSERT INTO bxh_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Fedebom, edi lauꞌuꞌula abiꞌabina moho yo doga hesa hesana Yesu, haꞌa ya peꞌi, Paulo ya libaen mate ya mwahuli fuyo, haladi yai sa faibayaho. ");
INSERT INTO bxh_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Mata paꞌana yoꞌoina mate ulugu ya kuꞌu, be Paulo E fatiꞌoi ibe gonowana ya lau Yelusalem be ainiya haba fadudulai bodaina. ");
INSERT INTO bxh_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","In moho, Paulo ya anꞌetaigu bena E abi didin ee–, Baꞌisa Sisa haba ya falau fatala fuyoi. Lisina yai E liba, be sa gati fuyoi ee–, E fatamali lawen Loma Baꞌisana lisina. ");
INSERT INTO bxh_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Kin Agilipa iyen, Egu fanuha bena doga ni ena liba E atahi. Fesitu iyen, Bobon habahim wa atahi. ");
INSERT INTO bxh_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Bobonna Agilipa yo Benisi sa leli na sa lau honehone be sa luhulau aba lau fatala ganahewana yai maidadi hiyala tau lau kulukuluwena haisa, yo taon babadadi. Na habahim, Fesitu ya lau faliba, be Paulo sa leyama. ");
INSERT INTO bxh_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fesitu iyen, Kin Agilipa yo salumadi aho amaiteꞌi, doga te ami ita? Diusi mahudoꞌidi amaiteꞌi yo Yelusalem yai edi fatala pili lebena yai, logena sa anꞌetaigu be E falau fatala. Na sa halahalabo tiyen, Ibe ya peꞌi mate, ya loholoho! ");
INSERT INTO bxh_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","E lobahi mate hige ana mata hesa debana yai haba i peꞌi. In ena anꞌeta Loma Baꞌisana lebena yai, haba E fatamali lawen Loma. ");
INSERT INTO bxh_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Somo haba E uli Kin enehena? Ana sadi hige i mahata! Sidohana haba Sisa egu fafalibana? Logena E foyahiyama lisimiu yo, um Kin Agilipa, matam yai! Ana mata yoꞌoina mulina yai, haba Sisa ena E uliꞌuli be E faliba. ");
INSERT INTO bxh_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Hige i dudulai bena tau lau deli aba fagiluna hige ya lobahi na haba ya dui i lau Sisa lisina. ");
INSERT INTO bxh_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agilipa ya libalau Paulo lisina iyen, E yaliyem bena em wa libaliba. Yo fede Paulo nimana ya lolon, na ya fatubu ya libaliba iyen, ");
INSERT INTO bxh_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Kin Agilipa, itete egu solasola! Diusi somo lebena yai sa fagilugu, aho te egu E tona galagala matam yai. ");
INSERT INTO bxh_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Paꞌana ema laulau yo ema faibayaho haꞌa wa sibaidi. Logena, E anꞌetaim, bena wa tauꞌulu na wa ataꞌatahi laoma lebegu. ");
INSERT INTO bxh_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Ma kiukiugu sidohana egu miyamiya ya fatubu egu nuꞌu yai ya lau ee–, Yelusalem yai hinaga, Diusi mahudoꞌidi sa sibai. ");
INSERT INTO bxh_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Be haꞌa sa sibaigu fuya lofalofa. Na yena sa fanuha, beti ti famahata mate ema lauꞌuꞌula abiꞌabina ganahewana yai, yau mate “Falesiya” yo tau lau fagagayo hesa beyabeyana. ");
INSERT INTO bxh_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Be aho ite, E obiyo mahata lisim yai, paꞌana somo Yaubada ya liba fasunuma afa wahamai lebedi yai mate E kawa wananahaꞌen, halana yai sa sadigu. ");
INSERT INTO bxh_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Iꞌipa yo lahai ema sulu 12 laulauwewedi ma nuwa ofi fahidi sa fafadebasae, na liba fasunuma te, ma sunumadi sa fafamata watan be haba ainiyona ya tubu sa ita. Aee, Baꞌisa, sunuma fafamata watan te debana yai Diusi dodogadi sa fagilu gaibuigu. ");
INSERT INTO bxh_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Paꞌana somo Diusi, hige gonowana au kawawananaha mate Yaubada gonowana tau peꞌipeꞌi ya famwahuli fuyoꞌidi? ");
INSERT INTO bxh_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Beyabeyana egu nuwanuwatuhu laꞌilaꞌi bena ginauli mahudoꞌidi E laulau ginauli ni, Yesu Nasaleta hesana E faheyaya. ");
INSERT INTO bxh_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Yelusalem yai laulaudi te, E ginaginaulidi. Antalasam babaꞌisadi, tau nuwa bui boludi sa biya afuledi nimagu yai be E falau delidi; yena bena sa wunuidi, mate E ehe watawatanidi. ");
INSERT INTO bxh_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Fuya ouꞌouli Diusi edi aba oiꞌoigogo lumadi hahaisa yai E panipanisidi yo E eli duduidi be Yesu hesana sa liba faheyaya. E manabala wananaha yo fede E lau taꞌowawa edi duhu laꞌi hesa - hesa yai, be E fakamkamnadi. ");
INSERT INTO bxh_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Tau antalasam babaꞌisadi agu paisowa sa felegu be sa duigu E lau Damaseko. ");
INSERT INTO bxh_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Kin Agilipa, lahai laꞌi yai edaꞌeda yai E laulau na mala hesa E ita galewa yai. Ya mala wananaha, hige doha maihala. Ma afa haidagu ya sina fataꞌiꞌilimai. ");
INSERT INTO bxh_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Mahudoꞌimai ꞌe beꞌu lidi tanohi yai, na alina hesa E atahi ya libama lisigu Hebelu alinamai yai iyen, “Saulo, Saulo! Paꞌana somo wa fakamkamnagu? Mate, wa fakamkamna fuyoim. Gonogonowana doha bulumakau ya fakamkamna fuyoi tanuwagana ena tuꞌe yai na ahena yai ya oiꞌoi fapito.” ");
INSERT INTO bxh_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","E fatiꞌo yawa, “Baꞌisa, um sai?” Be Guyau alinagu ya bui iyen, “Yau Yesu, logegu wa fakamkamnagu. ");
INSERT INTO bxh_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","U obiyo! Lebem yai E taumahata, paꞌana E fasinabom, haba um egu tau paisowa. Somo aho E faꞌitam yo fuya matada yai somo sa taumahata, haba wa dedeidi. ");
INSERT INTO bxh_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Haba E fofofahim falem Isalaela yo taꞌowawa dodogadi lisidi yai. Yau E duim wa lau lisidi. ");
INSERT INTO bxh_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Haba wa faꞌita lobahidi be kamumu yai wa fafuyodima mala yai yo Satani ena gigibwali sa lau afulen na sa fuyoma Yaubada lisina, na haba edi kawawananaha lisigu yai edi heyaheyaya E nuwatuhu afuledi, be egu fatabu dodogadi ma afa haidagu ꞌe miya esega. Salumadi sa anpate bena sa fakamkamnam, haba E fofofahim.” ");
INSERT INTO bxh_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Logena be, Kin Agilipa, fuyana Yesu galewa yai ya liba lidima lisigu, tautau yai be ena liba E lau watan. Hige ya awayagala. ");
INSERT INTO bxh_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","E guguyaidi: bwaꞌibwaꞌina Damaseko yai, habahim Yelusalem, Diudeya nuꞌu mahudoꞌina yai yo taꞌowawa lisidi yai hinaga, mate bena edi heyaheyaya sa nuwa afuledi be Yaubada sa famuli watan haba te ita mate wananaha sa nuwa bui. ");
INSERT INTO bxh_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Guguya te halana yai Diusi bena sa wunuigu, yo fede sa tohaigu, Dubu Tabuna dobidobina yai. ");
INSERT INTO bxh_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","In moho, aho ite Yaubada ya sagusaguhigu, be E obiyo amaiteꞌi, na E liba famahata dodoga fafahesadi yo puꞌopuꞌoudi lebedi yai. Somo Mose yo peloweta haꞌa sa libaen haba ya tubu E libalibaen watan. ");
INSERT INTO bxh_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Mate, Yaubada ena Fasinabo Dogana, Keliso, haba ya kamkamna; na haba ya obiyo fuyo bwaꞌi, be mala wasana Diusi yo taꞌowawa dodogadi ya falibadi. ");
INSERT INTO bxh_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Libadi yai te, Paulo enehena ya oiꞌoilele, na Fesitu ena liba ya an eli dogodogoi iyen, Paulo, nuwana u bwadebwade! Em sibasiba ya kamfabwadebwadem! ");
INSERT INTO bxh_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Alinana Paulo ya bui, Baꞌisa, yau hige ya bwadebwade! Yau E libaliba dudulai. ");
INSERT INTO bxh_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Baꞌisa Agilipa! Somo E libalibaedi te, hige simosimo yai ti tubu. E siba wananaha mate haꞌa wa sibaidi. Logena nuwagu ya adidili, be E falibam. ");
INSERT INTO bxh_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Baꞌisa Agilipa, Peloweta wa kawawananahaꞌedi e higeꞌe? E sibai mate wa kawawananahaꞌedi. ");
INSERT INTO bxh_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agilipa ya libalau Paulo lisina iyen, Wa sibai haba gonowam nuwagu wa bui feufeulai, be E famala “Kulistin”? ");
INSERT INTO bxh_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Ena liba Paulo ya bui iyen, Haba emi nuwabui tefana ya lofa o ya tupo, na egu lauꞌuꞌula Yaubada lisina yai mate bena um yo salumadi aho ite ami ataꞌatahi ami famala doha yau - na in moho tabu ti senimiu! ");
INSERT INTO bxh_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Habahim Agilipa, Benisi, Gawana Fesitu, yo salumadi maꞌedi sa mwaito. ");
INSERT INTO bxh_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Sa lau ganamuli yai, na tiyen, Doga te hige ana mata hesa bena ti falau deli, e ti wunui. ");
INSERT INTO bxh_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Be Agilipa ya libalau Fesitu lebena yai iyen, Doga te, ibe hige Sisa i anꞌetai, egoba haꞌa ti soꞌe fahi. ");
INSERT INTO bxh_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Sa oilibaemai mulina yai bena ai waga ꞌe awa ꞌe lau Itali. Paulo yo tau lau deli haisa mate, Loma hiyala tau lau kulukuluwena nimana yai sa tole afuledi. Hesana mate Diuliyesi. In Loma ena hiyala pelena hesa, hesana “Baꞌisa Sisa ena Ledimenti” ");
INSERT INTO bxh_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Adamitiyum wagana hesa ya nonoha haba ya tafo dunaduna Eisiya Nuꞌuna tefa hahaisa yai. Yo fede Alisitaku maꞌemai ꞌe awa. Ena nuꞌu Tesalonika, Masedoniya Nuꞌuna ganahewana yai. ");
INSERT INTO bxh_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Bobonna ꞌe mahano Sidon yai. Hiyala tau lau kulukuluwena, Diuliyesi, ena laulau sa loholoho be ya libalau Paulo lisina iyen, U lau haidam u kepaidi be somo wa fanuha, haba em sa soi. ");
INSERT INTO bxh_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Amainiya ꞌe gelu boda na hwayahwayau mate ꞌe tutu matai. Yo fede, ꞌe lau Saipelesi bonabonaluwana tefa hasahasaina hoyona yai. ");
INSERT INTO bxh_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","E tomo doheyen Sisiliya yo Pamfiliya solasoladi yai ꞌe lau ee–, taon hesa hesana Miula, Laisiya Nuꞌuna ganahewana yai ꞌe duna. ");
INSERT INTO bxh_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Amainiya hiyala tau lau kulukuluwenna Idipi edi waga hesa, Alesandiya taonna yai ya laoma, ya lobahi ya laulau Itali, yo fede ꞌe awa. ");
INSERT INTO bxh_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Lahai fisa, hwayahwayau maꞌemai ꞌe faiꞌabi, be benai - benai ꞌe leuleu ee–, Kinidusi taonna ꞌe hanahanaui. Bena haba ꞌe bayawai, in moho hwayau ya adidili wananaha, be hige gonowamai aba launa ai lau watan. Yo fede ꞌe tomo doheyen Keliti Bonabonaluwana. Salamone Hisu tetena ꞌe giuliꞌi, be bonabonaluwana ni fatau hoyohoyona ꞌe lau watan. ");
INSERT INTO bxh_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ꞌE anꞌanpate adidili be ꞌE faꞌabi sadasadai ee–, gadowa hesa hesana “Gadowa Loholohona” Laseya taonna sadaina yai, ꞌe mahano. ");
INSERT INTO bxh_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Amainiya fuya ꞌe pei yo adauna ya heyaya wananaha, paꞌana Anhudi Lahaina ya ofi mate aniya heyaya fuyana. Be Paulo ya liba fanuwa tagudi iyen, ");
INSERT INTO bxh_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Babada, E siba eda adau te haba ya heyaya. Waga yo ginauli, haba yauma ya faheyayadi, yo nuwana haba ta peꞌi hinaga. ");
INSERT INTO bxh_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Na hiyala tau lau kulukuluwenna mate, waga kapenana yo waga tanuwagana edi liba ya lau watan na Paulo ena liba hige i modeꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Gadowa te, ai gogoma fuyana hige i loholoho be dodoga boludi edi fanuha bena sa lau Finikesi Gadowana be hwayahwayau fuyanna ainiya sa miya. (Keliti bonabonaluwana yai, Finikesi Gadowana hafohafona mate yalasi yo yawana edi aba towa yai. Be yena hwayahwayau ya towa, ibege i abidi.) ");
INSERT INTO bxh_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Yawana ya fatubu ya towa benai benai be waga tau eyaisina yo waga tanuwagana edi nuwatuhu bena haga gonowadi haba sa lau. Yo fede waga ana anka sa solu hitin, na Keliti bonabonaluwana sadaina sa boboyo watan. ");
INSERT INTO bxh_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Hige walolona na kaluwabu ya towa lidima bonabonaluwa yai. ");
INSERT INTO bxh_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Yauma waga ya yufi pipin, be ena aba lau hige gonowana i tafo watan, yo fede, hwayahwayau moho ana haba ꞌe tafo watan, ");
INSERT INTO bxh_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","be ꞌe boboyo ee–, bonabonaluwa kiukiu tefa yawana yai hesana Kauda, hoyona yai. Amainiya, aba fafaꞌoituhu sa solu hitin. ");
INSERT INTO bxh_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Habahim, waga sa auꞌauwi paꞌana sa ꞌwasabu ibe i dem lopalopa. Ana wolewole sa noꞌudi na ya laulau pwapo. Edi ꞌwasabu mate ibe i tata hiti ai gelegele tupina be i lubi lopalopa Libiya hanahanaudi yai. Yo fede waga aba fadaluluna sa fadalolo be sa fabebeda. Na hwayau waga ya yufi pipin lawen oula. ");
INSERT INTO bxh_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Hwayahwayau yo bagodu edi abi ya lau sinaꞌala; be bobonna waga ana kaihusa tefana sa lofe taluhidi, ");
INSERT INTO bxh_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","na lahai fafa faihonana yai, mate iti ibodi nimadi yai waga aba paisowana ginaulidi hudoꞌi - hudoꞌi sa lofe taluhidi hinaga. ");
INSERT INTO bxh_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Fuya lofalofa hige maihala yo kipwala ai itadi, na yauma hola ma adidilina. Yo fede nuwamai sa toma, ayawa, “Woo ee–, anadan, haba te peꞌi.” ");
INSERT INTO bxh_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Fuya lofalofa hige somo laꞌi ti an, yo fede Paulo ya falibadi iyebom, Babada, nahalidi Keliti yai ibe alinagu ami lau watan na tabu ta adau. Haba ibege heyaheyaya ta fahoina. ");
INSERT INTO bxh_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Lisina yai aho te, E anꞌetaimiu, bena nuwamiu ami faꞌadidilidi! Haba ibege sai laꞌi i peꞌi; eda waga moho haba ya bulu. ");
INSERT INTO bxh_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Maihona yai Yaubada (In sai E fafamuli watan yo yau hinaga enehena) ena anelu ya laoma lisigu. ");
INSERT INTO bxh_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Na iyen, “Paulo, tabu u ꞌwasabu! Baꞌisa Sisa bena ai matana wa obiyo. Be Yaubada ena loholoho um lisim yai, debana yai mate salumadi maidam ami awa, ibege ti peꞌi.” ");
INSERT INTO bxh_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Be tatau, nuwamiu ti adidili! Yaubada E kawawananahaꞌen mate somo ya falibagu haba ya tubu. ");
INSERT INTO bxh_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Be haba bonabonaluwa laꞌi ainiya te oi hiti hasa. ");
INSERT INTO bxh_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Hwayau ya towatowa na ꞌe aleꞌalele maihona ouꞌoulina 14 Mediteleniya Gabogabona yai. Iꞌipa atipuna yai waga tau paisowa amna sa atahi mate fote sa hanahanaui. ");
INSERT INTO bxh_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Yo fede mahina duduna yai ginauli hesa mwahumwahuna sa au na sa fadalolo lidiyen gabogabo, be oula lofana sa lufa. Sa lobahi mate lofana 40 metres. Hige walolona na sa lufa bodai. Matabahim begana ya fote, lofana 30 metres. ");
INSERT INTO bxh_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Yo fede sa ꞌwasabu, ibe waga ti fatata hitiꞌi, be anka fati sa fadalolo lidiyedi waga mulina yai, na sa lauꞌuꞌula bena ya lahai. ");
INSERT INTO bxh_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Waga tau paisowa bena waga sa gela afulen; be fafaꞌoituhu sa fadawe lidiyen gabogabo yai, edi bwala bena haga anka haba ai waga kuluna sa fabuludi. ");
INSERT INTO bxh_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Be Diuliyesi yo tau hiyala, Paulo ya falibadi iyen, Yena waga tau paisowa hige ai waga ti miya, haba ami peꞌi. ");
INSERT INTO bxh_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Yo fede, fafaꞌoituhu balawadi, tau hiyala sa tomofahi be ya alele. ");
INSERT INTO bxh_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Begana haba ya ifi tatatali, mahudoꞌidi Paulo ya falibadi iyen, Au kalahe, paꞌana wiki luwaga hige somo hesa au an. ");
INSERT INTO bxh_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Lisina yai aho te, E anꞌetaimiu, bena ami anꞌan, haba taumiu sa adidili be ibege sai laꞌi u peꞌi. ");
INSERT INTO bxh_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Paulo ya falibadi mulina yai, fwalawa tefana ya abi be ya ifi na Yaubada ya lautoꞌiyen. Habahim ya an, mahudoꞌidi matadi yai. ");
INSERT INTO bxh_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Mahudoꞌidi nuwadi sa adidili fuyo be sa anꞌan. ");
INSERT INTO bxh_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Tau awa waga yai mate, oulimai 276. ");
INSERT INTO bxh_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Mahudoꞌimai ꞌe kalahe maꞌuda, waga ana kaihusa, witi, sa lofe lidiyen gabogabo yai, be waga ya malaha. ");
INSERT INTO bxh_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ya ifi tatatali, nuꞌu hige ti ita lobahi, in moho gelegele sa ita gadowa yai be ana halulu sa lau bena ainiya sa duna. ");
INSERT INTO bxh_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Yo fede anka sa ibo motudi, yo eyaisi balawadi sa tatadi. Na habahim wolewole hesa waga hisuna yai sa uꞌei, be waga ya dudulai lau fote. ");
INSERT INTO bxh_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Hola ma laudi yo fede ya tata hiti gelegele tupina yai. Hisuna ya lau sopu yo fede ya talaꞌafi na waga mulina mate bagodu sa lubi lopalopa. ");
INSERT INTO bxh_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Tau hiyala sa oiliba bena tau lau deli mahudoꞌidi sa wunuidi, tabu ti tuba hiti be ti gela. ");
INSERT INTO bxh_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Nogeya, hiyala tau lau kulukuluwena hige i fanuha bena Paulo i peꞌi be edi nuwatuhu hige i fanuha. Safaluma tuba sa siba ya falibadi be sa dago bwaꞌi gabogabo yai be sa tuba hasa gelegele yai. ");
INSERT INTO bxh_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Na tau tubatuba gesa ya falibadi bena sa abiꞌabi didi waga tebina sa tapwaipwai, amainiya, sa tuba poupouwedi be sa duna sae fote, ma loholohodi. Itete sidohana mahudoꞌimai ꞌe tuba hiti, ma loholohomai. ");
INSERT INTO bxh_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ai, ma loholohomai fote yai, habahim ꞌe sibai bonabonaluwa te hesana Malata. ");
INSERT INTO bxh_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Dodoga amainiya mate sa abi komakomaniꞌimai. Ya usa na nuꞌu ya gogoma, yo fede oyagi sa yufi be ꞌe anmwahibo. ");
INSERT INTO bxh_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paulo oyagi lagalagadi ya tano gogoidi, be ya fafapei lau oyagi alaꞌalana yai. Weso anꞌan nalina oyagi gigibwalina amnana ya atahi, yo fede ya kalamahanoma, be Paulo nimana ya nali. ");
INSERT INTO bxh_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Malata dodogadi wa weso sa ita Paulo nimana yai ya kaukauti yo fede ibodi sa libaliba tiyen, Moꞌisa, doga te mate tau aiyunu hesa! Paꞌana gabogabo yai ya gelama ma loholohona. In moho “Tau Fakasa yaubadana” ya fanuha bena Paulo ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Na Paulo nimana ya tawa luhiluhiyen, yo fede, weso ya lubi fapito lawen oyagi alaꞌalana yai. In moho Paulo hige i peꞌi. ");
INSERT INTO bxh_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Sa kinokinoi, na tiyebom, Nimana haba ya pou e haba ya guli lidi be ya peꞌi. Sa bagi watan ee–, aꞌawana ya lofa, na hige somo i tubu lisina yai. Edi nuwanuwatuhu sa buidi, be sa liba tiyen, Nuwana in yaubada hesa! ");
INSERT INTO bxh_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ema aba tuba hiti (nuꞌuna) sadaina yai mate bonabonaluwa ni, baꞌisana Pubilisi ena tanohi. Ya yoga hitinimai be lahai faihona ai ana taumana. ");
INSERT INTO bxh_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Pubilisi tamana ya lepa. Tauna sa gigigibwali yo ya lau mulimuli mate ꞌwasina. Paulo ya lau tau lepa ena aba enoꞌeno yai be ya abilau tauna yai na ya lauꞌuꞌula, yo fede Guyau ena gigibwali yai ya faloholoho. ");
INSERT INTO bxh_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Laulau te ya tubu, mulina yai mate tau lepalepa mahudoꞌidi bonabonaluwa yai ni, sa laoma, be ya faloholohodi hinaga. ");
INSERT INTO bxh_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Fuyana ai amainiya, ainauya boludi sa felemai. ");
INSERT INTO bxh_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Nawalahi faihona mulidi yai, Alesandiya wagana hesa hesana “Oitau Godegode” yalasi hola ya ita watan Malata bonabonaluwana yai ee–, ya towa motu, habahim ya lau Loma. Yo fede somo ꞌe fanufanuhadi ema sa soi ꞌe husaidi wagana yai na ꞌe awa be ꞌe adau boda. ");
INSERT INTO bxh_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Silakusi taonna yai ꞌe mahano be amainiya ꞌe miya, lahai faihona. ");
INSERT INTO bxh_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Amainiya ꞌe gelu boda, be ꞌe duna Legium taonna yai. Bobonna hwayahwayau mulimai yai ya towama be ꞌe boboyo ee–, lahai fafaihonana yai ꞌe duna Puteoli taonna yai. ");
INSERT INTO bxh_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Amainiya tau kawawananaha haisa ꞌe failobahidi. Sa yoga hitinimai, be lebedi yai ꞌe miya wiki esega. Habahim ꞌe lau fote ꞌe lau Loma. ");
INSERT INTO bxh_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Tau kawawananaha hahaisa Loma yai wasamai sa atahiyen be sa laoma bee–, taon hesa hesana “Apusi Maketi” yo “Taumana Lumadi Faihona” amainiya sa lobahimai. Paulo ya itadi mate Yaubada ya lautoꞌiyen yo nuwana ya adidili. ");
INSERT INTO bxh_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Fuyanna ꞌe mahano lau Loma yai, gabeman hesa Paulo ya faliba be iyabona ya gogo hudoꞌi, na tau gatinina mate tau hiyala hesa. ");
INSERT INTO bxh_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Lahai faihona mulidi yai, Diusi babadadi, Paulo ya yoga gogoidima be iyen, Falegu Isalaela! Hige eda dodoga lisidi yai somo ya faheyaya, e ada ulutubu miyamiyadi ya utusidi. In moho, Diusi babadadi Yelusalem yai sa augu yo sa fele lawegu Loma Gabeman dodogadi nimadi yai. ");
INSERT INTO bxh_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Loma gabeman babaꞌisadi sa fatiꞌo buibuigu yo sa fanuha bena sa soꞌe fahigu, paꞌana hige somo hesa ya faheyaya debana yai haba ya peꞌi. ");
INSERT INTO bxh_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","In moho Diusi babadadi sa ꞌwaiyoꞌo. Hige egu edaꞌeda hesa somo be, Loma edi Baꞌisa, Sisa, E anꞌetai bena ya falau fatala fuyoꞌigu, na hige bena falegu Diusi ya fagiludi. ");
INSERT INTO bxh_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Mata paꞌa te debana yai E lau falibaimiu be ami laoma bena E itamiu yo te libaliba. Paꞌana Isalaela ena sunuma yai seni yai te sa augu. ");
INSERT INTO bxh_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Sa libalau Paulo lisina tiyen, Wasam hige Diudeya yai ema ti uliyama yo afa haidada Isalaela amainiya sa laoma hige wasam somo heyaheyayana ti libaen ai atahiyen. ");
INSERT INTO bxh_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","In moho em nuwanuwatuhu bena ꞌe sibai paꞌana dodoga nuꞌu ouꞌouli yai mate “Guyau Edaꞌedana” pelena te sa ꞌwaiꞌwaiyoꞌoꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Yo fede ana lahai sa golu maꞌedi Paulo. Na lahaina yai ni, dodoga boludi sa laoma Paulo ena aba miyamiya yai. Yaubada ena Aba Baꞌisa Nuꞌuna wasana ya dede famahata lebedi yai, hwalahwalala ya lau ee–, ya maihona. Ya anpate bena nuwadi ya abidi be haba Yesu wasana, Mose ena laugagayo yai yo peloweta edi uliꞌuli yai, sa kawawananahaꞌen. ");
INSERT INTO bxh_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Haisa, ena libaliba yai nuwadi ya abidi na haisa hige ti kawawananaha. ");
INSERT INTO bxh_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Sa faibayaho be hige nuwadi esega. Sa fatubu bena sa aulaha, na Paulo ena liba ofiꞌofina yai, iyen, Yaluwa Tabuna ena gigibwali yai, Peloweta Isaiya wahawahamiu ya faliba dudulaidi iyen, ");
INSERT INTO bxh_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Yaubada ya liba, doha ite: Au lau be dodoga te, ai lisidi auwe, “Haba ami ataꞌatahi, na ibege au nuwatuhu lobahi; haba ami ita, na ibege au ita lobahi.” ");
INSERT INTO bxh_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Dodoga te sa nuwa poꞌi wananaha, nuwadi sa anꞌanloya be beyadi sa tipadi yo matadi sa fatoudi. Ibe higeꞌe, haba matadi sa falaladi, be ginauli sa itadi, yo beyadi haba sa taꞌafasi, be liba sa atahiyedi, yo ginauli haba sa nuwatuhu lobahidi; haba sa timuli be sa fuyoma lisigu, na haba E faloholohodi. ");
INSERT INTO bxh_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Paulo ena liba ya falafu sofa iyen, Logena, E fanuha bena ami siba mate, Yaubada ena famwahuli wasana haꞌa ya lau taꞌowawa lisidi yai be iti haba sa atahiyen! ");
INSERT INTO bxh_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Ya liba ofi mulina yai, Diusi ma faifaibayahodi sa aulaha sa lau. ");
INSERT INTO bxh_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paulo luma hesa ya famaisa be amainiya ya gogo boliman luwaga. Na safalumadi sa laoma lisina mate ya yoga hitinidi, ma nuwa loholohona ");
INSERT INTO bxh_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ma nuwa adidilina, Yaubada ena Aba Baꞌisa Nuꞌuna wasana ya libalibaen yo Guyau Yesu Keliso wasana ya fatalahadi. Hige gonowana sai laꞌi i gudu. ");
ALTER TABLE bxh_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
