﻿USE sofia;
DROP TABLE IF EXISTS sofia.bxh24_vpl;
CREATE TABLE bxh24_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bxh24_vpl WRITE;
INSERT INTO bxh24_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Mesaiya ana ulutubu mate logedi itete: Abelaham yo Kin Deiwidi. ");
INSERT INTO bxh24_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","6a","Abelaham yai ya fatubu na ya lau be Kin Deiwidi yai, wahawahana mate: Abelaham natuna Isako, Isako, natuna Iyakobo, Iyakobo nanatuna Diuda ma haidana. Diuda ma lahuna Tama, nanatudi mate Pelesi yo Sela. Pelesi natuna mate Heselan. Heselan natuna Lam, Lam natuna, Aminadabi, na Abinadabi natuna Nason, Nason natuna mate Salamon. Salamon ma lahuna Lahaba natudi mate Bowasi. Na Bowasi ma lahuna Luta natudi mate Obedi. Obedi natuna Desi, na Desi natuna Kin Deiwidi. ");
INSERT INTO bxh24_vpl VALUES ("MT1_6b","070_1_6b","MAT","1","6b","11","Deiwidi yai ya fatubu na ya lau be Babilon sa lawedi, Yesu wahawahana mate: Deiwidi natuna Solomon. Solomon tinana Ulaiya, lahuna Betesiba, Solomon natuna Lehebowam, Lehebowam natuna Abaidiya, Abaidiya natuna Asa, Asa natuna Diyosafata, Diyosafata natuna Diyeholam, Diyeholam natuna Usaiya, Usaiya natuna Dotan, Dotan natuna Ahasi, Ahasi natuna Hesekaiya, Hesekaiya natuna Manase, Manase natuna Amon, Amon natuna Diyosaiya, na Diyosaiya natuna Diyowakin yo haidana, logedi sa tohaidi be sa lawedi Babilon. ");
INSERT INTO bxh24_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Fuyanna Babilon sa lau afulen, mulina yai na ya lau be Yesu sa yosi, wahawahana hitina itete: Dekonaiya nanatuna Seyatiyeli, Seyatiyeli natuna Selubabeli, Selubabeli natuna Abiudi, Abiudi, natuna Eliyakim, Eliyakim natuna Asoli, Asoli natuna Sadoka, Sadoka natuna Akim; Akim natuna Eliuda, Eliuda natuna Elisala, Elisala natuna Matan, Matan natuna Iyakobo, Iyakobo natuna Diyosepa, Diyosepa lahuna Maliya. In logena, Yesu ya yosi, sa atahi Keliso. ");
INSERT INTO bxh24_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yesu ana ulutubu ya fatubu Abelaham yai, ya lau ee–, Deiwidi, mate 14. Na Deiwidi yai na ya lau ee–, sa tohaidi sa lawedi Babilon mate 14 hinaga, Sa lawedi Babilon yai na ya lau ee–, Keliso ena fuya yai, mate wahawaha oulina 14 hinaga. ");
INSERT INTO bxh24_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Itete sidohana haꞌa Yesu Keliso ya tubu. Tinana Maliya Diyosepa sa fasinabo. Na hola hige ti miya esega, be tineꞌeu wa ya siba fuyoi mate Yaubada Yaluwana debana yai ya boga. ");
INSERT INTO bxh24_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Na in mate taumoho dudulaina. Hige i fanuha bena Maliya i fataumayamaya, yofede, simosimo yai bena ya lau afulen. ");
INSERT INTO bxh24_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nuwatuhuna fuyanna hola ya fadofadosi, na Guyau ena anelu, eno suwai yai ya fataumahata lisina yai, iyen, Diyosepa, Deiwidi ana hiti mulita, tabu u ꞌwasabu na Maliya u fai. Paꞌana ya fasiu mate Yaubada Yaluwana ena nuwatuhu yai. ");
INSERT INTO bxh24_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","In haba natuna taumoho ya yosi, na hesana haba wa tole, Yesu, paꞌana ena dodoga edi heyaya debadi yai haba ya fofofahidi. ");
INSERT INTO bxh24_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ginauli mahudoꞌidi sa tubu te bena Guyau ena liba haba ya fawananaha, doha, haꞌa Peloweta Isaiya iyen, ");
INSERT INTO bxh24_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Haga au nuwatuhui! Waihin hudoꞌi, hola hige i eno lau, haba ya boga, na haba natuna taumoho ya yosi, na haba hesana sa tole, <<Imanuwela.>> Mate aniyona, <<Yaubada maꞌeda.>> ");
INSERT INTO bxh24_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Diyosepa ya eno tauhiti, yofede anelu ena liba ya lau watan, be Maliya ya fai. ");
INSERT INTO bxh24_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Na inmoho, hola hige maꞌena ti eno bili, ya lau ee–, natuna ya yosi. Na Diyosepa hesana ya tole, <<Yesu.>> ");
INSERT INTO bxh24_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu ena aba tubu mate taon hesa hesana Betelehem, Diudeya Nuꞌuna yai. Fuyanna doga hesa hesana Heloda mate edi kin, Kipwala Tau Fadosidi haisa sa mahano leuma Yelusalem yai. ");
INSERT INTO bxh24_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Be sa fatiꞌo, tiyen, Wawaya ya tubu bena Diusi emi Kin, mate, in somo yai? Fafaꞌilalana kipwala ya sina ꞌe ita, tefa saisai yai, lebena yai ꞌe laoma, bena ꞌe fadebasae. ");
INSERT INTO bxh24_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Fuyanna Kin Heloda wasa ya atahiyen, mate maidana Yelusalem dodogadi sa nuwadubu. ");
INSERT INTO bxh24_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Yofede, Diusi edi tau antalasam baꞌibaꞌisadi ya yoga gogonidi yo laugagayo tanutanuwagadi, be ya fatiꞌoidi, iyen, Ai somo haba Keliso, ya tubu? ");
INSERT INTO bxh24_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Alinana sa bui, iten, O, Betelehem, Diudeya Nuꞌuna ganahewana yai! Doha ite, peloweta hudoꞌi ya uli haꞌa iyen, ");
INSERT INTO bxh24_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Betelehem dodogadi, Diudeya ganahewana yai, emi nuꞌu hige i tubu gaibu, Diudeya nuꞌudi ganahewadi yai, paꞌana ganahewam yai, Tau Uluweda haba ya tubu hasa. Fuya matada yai, in haba Isalaela dodogadi Tau Uluwedi. ");
INSERT INTO bxh24_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Yofede, Heloda simosimo yai, Kipwala Tau Lau Fadosi ya faꞌoilibadi, na ya fatiꞌoidi, iyen, Kipwala ami ita bwaꞌiyen, mate fuya som? Yofede, sa faliba. ");
INSERT INTO bxh24_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Habahim ya fatamalidi, be sa lau Betelehem na iyen, Gwama te au yoꞌoi komakomaniꞌi. Yena ami lobahi au fuyoma be au falibagu. Haba yau hinaga E lau be E fadebasae. ");
INSERT INTO bxh24_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kin ya fatalahadi ya ofi, sa lau afulen. Na kipwala tefa saisai yai sa ita ya bwaꞌi yee–, somo yai gwama ena aba tubu nuꞌuna hewana yai ya todi. ");
INSERT INTO bxh24_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Fuyana kipwala sa ita mate kwade ya famohafudi. ");
INSERT INTO bxh24_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Na sa luhulau luma ganahewana yofede Gwama wa sa ita, ma tinana Maliya. Yofede, sa tulibono, be sa dulu, hesana yai. Yo ena ainauya maisadi laꞌilaꞌidi faihona sa lahafahidi: Gole, mulamula panepanena hesa, yo oyagi hesa lutuna panepanena sa felen. ");
INSERT INTO bxh24_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mulina yai, habahim, Yaubada, eno suwai yai, ya liba fanuwatagudi be tabu ti fuyo Heloda lisina yai, yofede, edaꞌeda hesa sa lau watan, be sa fuyo sai edi nuꞌu. ");
INSERT INTO bxh24_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Fuyana ha'a sa aulaha habahim, eno suwai yai Guyau ena Anelu ya taumahata Diyosepa lebena yai na iyen, U obiyo. Gwama ma tinana u gelaꞌedi be au lau Idipi. Ainiya au miya ee–, ana siga E falibam, haba ami fuyoma. Heloda mate gwama te ya laulau yoꞌoi, bena haba ya wunui. ");
INSERT INTO bxh24_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Diyosepa ya eno obiyoma, gwama ma tinana ya auledi, na iꞌipa yai sa lau Idipi. ");
INSERT INTO bxh24_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Amainiya sa miya ee–, Heloda ya peꞌi. Yaubada alina doha ite: Natugu ai Idipi E yoga fahiyama. Haba liba te peloweta haꞌa ya libaen, ya fawananaha. ");
INSERT INTO bxh24_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Heloda ya nuwatuhu lobahi, mate taumana tefa saisai yai sa laoma mate sa bwalai, yofede, ya gafupou. Liba adiꞌadidili ya fatamali, be wawaya tatau mahudoꞌidi Betelehem yai edi bolima luwaga yo ubuna yai yo nuꞌu haisa sadaina yai, mate mahudoꞌidi sa wunuidi, paꞌana gwama ena fuya tubu Magi ena sa liba. ");
INSERT INTO bxh24_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Somo ya tubu te mate Peloweta Delamaiya ya libaen ya fawananaha: ");
INSERT INTO bxh24_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Alina sa atahi, Lama yai, sa tan eloꞌelolosi. Leisulu nanatuna haladi ya tantan. Famakanona sa fakaukau, Paꞌana nanatuna mahudoꞌidi sa peꞌi ofi. ");
INSERT INTO bxh24_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Heloda ya peꞌi mulina yai, Idipi yai Yaubada ena Anelu eno suwai yai ya taumahata lau, Diyosepa lisina. ");
INSERT INTO bxh24_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Be iyen, U obiyo be gwama ma tinana u fafuyodi Isalaela Nuꞌuna, paꞌana gwama tau lau funuhina, haꞌa sa peꞌi. ");
INSERT INTO bxh24_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yofede, Diyosepa ya obiyo, gwama ma tinana ya auledi, na sa fuyo Isalaela. ");
INSERT INTO bxh24_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Diyosepa ya atahiyen mate Akelausi tamana Heloda ya falau damahi, be Diudeya edi kin, be lau Diudeya, ya ꞌwasabu. Inmoho Yaubada eno suwai yai ya faliba, yofede ya lau Galili Nuꞌuna. ");
INSERT INTO bxh24_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Be Nasaleta taonna yai ya gogo. Na doha peloweta ena liba ya fawananaha, iyen, In haba ya famala Nasaleta dogana. ");
INSERT INTO bxh24_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Fuyandi yai Diyon Babasito ya laoma Diudeya Nuꞌuna pitapitalina yai be ya fatubu ya lauguguya, iyen, ");
INSERT INTO bxh24_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nuwamiu au buidi, paꞌana Galewa Aba Baꞌisa Nuꞌuna mate, haꞌa ya sigima! ");
INSERT INTO bxh24_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Diyon logenana Peloweta Isaiya ya libalibaen iyen, Doga hesa nuꞌu pitapitalina yai ya yogayoga, iyen, <<Guyau ena edaꞌeda au abi nonohai; ena edaꞌeda au fadudulai haba ya lau watan!>> ");
INSERT INTO bxh24_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Diyon ena leli ya liꞌodi mate kamela olodi yai sa ginauli na ana bwaꞌulu mate yosiyosi ꞌwapina. Na ana kalahe mate digolele yo amoꞌamo. ");
INSERT INTO bxh24_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yelusalem yai dodoga sa laoma yo Diudeya Nuꞌuna mahudoꞌidi yai, yo Diyodan Hoꞌowana mahudoꞌina sadaina yai sa laoma lisina. ");
INSERT INTO bxh24_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Edi heyaya sa liba famahatadi, na Diyon ya fababasitodi Diyodan yai. ");
INSERT INTO bxh24_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Fuyanna Falesiya yo Sadusi boludi ya itadi sa laoma bena ya fababasitodi, ya falibadi, iyen, Umi weso! Emi nuwatuhu bena Yaubada panisi ya fatamalidima ami anfaleꞌedi?! ");
INSERT INTO bxh24_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bena ginaulidi ni ami ginaulidi haba sa fawananaha mate, bena haga haꞌa ami nuwabui. ");
INSERT INTO bxh24_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Emi nuwatuhu bena haba panisi ami anfaleꞌen fuyana ami liba, auwen, <<Abelaham mate wahamiu.>> E falibamiu mate Yaubada gonowana umeꞌehu te ya abidi be Abelaham wahawahana ya ginaulidi! ");
INSERT INTO bxh24_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ilama haꞌa ya nonoha bena oyagi ma lamdi ya oi fabui suludi. Oyagi tausom hige i fuwa loholoho haba oi fagulina be gabu goluna. ");
INSERT INTO bxh24_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ai hoꞌowa E fababasitomiu be dodoga haba sa ita mate, umi haꞌa ami nuwabui, inmoho doga muligu yai ya laoma haba ai Yaluwa Tabuna yo oyagi alaꞌalana yai ya fababasitomiu. In ya gigibwali, na habahim yau. Yau hige ya loholoho haba ana ahe sumasuma ya bahei. ");
INSERT INTO bxh24_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ena sabolo ya lawelawen haba witi ya abilisi. Haba ena witi ya pei gogonidi, ena ai aba peipei gogo lumadi, na haba wenudi mate, oyagi alaꞌalana hige gonowana i peꞌi, ainiya ya gabu goludi. ");
INSERT INTO bxh24_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Lahaina yai, Yesu Galili ya lau afulen be ya laoma Diyon lisina, be haba ai Diyodan Hoꞌowana ya fababasito. ");
INSERT INTO bxh24_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Inmoho, Diyon hige i fanuha. Yofede Diyon iyebom, Yesu, um bena wa fababasitogu, na sidohana be wa laoma lisigu? ");
INSERT INTO bxh24_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Alinana Yesu ya bui, iyen, Aꞌai! Haba doha wa ginauli. Be haba laulauna te Yaubada ena nuwatuhu mahudoꞌina te falau watan. Yofede, Diyon ya tauꞌulu. ");
INSERT INTO bxh24_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu ya babasito, na hoꞌowa yai ya pohema. Galewa ya tasoꞌe. Yaubada Yaluwana ya lidima ya ita, nenena doha waliliya, be hewana yai ya taꞌai. ");
INSERT INTO bxh24_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Habahim alina galewa yai ya libama, iyen, Itete Natugu Wananahana. E gadosisiyen yo nuwagu ya faꞌamna wananahai. ");
INSERT INTO bxh24_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Na habahim Yaluwa Tabuna Yesu ya foyahi lawen nuꞌu pitapitalina yai be Satani haba ya lauꞌita. ");
INSERT INTO bxh24_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Lahai 40 yo iꞌipa 40 ganahewadi yai hige somo laꞌi gadona yai i lidi. ");
INSERT INTO bxh24_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Na habahim Satani ya laoma lisina be iyen, Yena um Yaubada Natuna, umeꞌehu te u falibadi be ti falen fwalawa. ");
INSERT INTO bxh24_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yofede, Yesu iyen, Uliꞌuli Tabuna iyen, <<Doga ibege fwalawa ibona i anꞌanniꞌi. Inmoho, Yaubada ena liba mahudoꞌina ya libaedi mate gonowana haba ya mwahuli.>> ");
INSERT INTO bxh24_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Habahim Satani Yesu ya foya lawen Yelusalem, Siti Fafatabuna, be Dubu Laꞌilaꞌi hewana yai ya faꞌobiyo. ");
INSERT INTO bxh24_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Na ya faliba iyen, Yena um Yaubada Natuna, u dago, paꞌana Uliꞌuli Tabuna iyen, <<Yaubada haba ena anelu ya falibadi, be ai nimadi haba sa kapupum, be ibege ahem ai umeꞌehu u oiyedi.>> ");
INSERT INTO bxh24_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Alinana Yesu ya bui, iyebom, Inmoho Buka Tabuna hinaga iyen, <<Tabu Yaubada em Guyau lauꞌita yai u tole.>> ");
INSERT INTO bxh24_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ofiꞌofina mate Satani Yesu ya lawen tuꞌa lofalofana yai be nuꞌu mahudoꞌina yo edi loholoho ya faꞌita. ");
INSERT INTO bxh24_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Diyabolo iyen, <<Ginaulidi ni haba E felem, yena wa tulibono be wa fadebasaegu.>> ");
INSERT INTO bxh24_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu iyen, U lau hudoꞌi, Diyabolo! Buka Tabuna iyen, <<Yaubada em Guyau ibona moho bena wa fadebasae yo ena wa paisowa!>> ");
INSERT INTO bxh24_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yofede Diyabolo, Yesu ya lau afulen; na anelu sa laoma be sa saguhi. ");
INSERT INTO bxh24_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu ya atahiyen mate Diyon sa falau deli, yofede ya lau Galili. ");
INSERT INTO bxh24_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nasaleta yai hige i miya. Ya lau Kapanayum yai ya miya, taon hesa Galili Gabogabona sadaina yai, Sebulun yo Nafatali nuꞌudi yai. ");
INSERT INTO bxh24_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Debana yai Peloweta Isaiya ena liba ya fawananaha, iyen, ");
INSERT INTO bxh24_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebulun yo Napatali Nuꞌudi, edaꞌeda ya lau gabogabo, Diyodan tefana yai, Galili, taꞌowawa edi nuꞌu! ");
INSERT INTO bxh24_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Dodoga kamumu yai sa miyamiya haba mala laꞌilaꞌi sa ita. Salumadi sa miyamiya peꞌi nuꞌuna kamukamumuna yai mala haba ya sina ai lisidi. * ");
INSERT INTO bxh24_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Lahaina yai Yesu ena wasa ya lauguguyaꞌen fatubu, iyen, Nuwamiu au buidi, paꞌana Galewa Aba Baꞌisa Nuꞌuna ya sigisigima! ");
INSERT INTO bxh24_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu mate Galili Gabogabona gelegelena yai ya laulau na, tau hamahama luwaga ya itadi, Saimon, hesana hesa Pita, yo hidana Endulu, sa hagihagida. ");
INSERT INTO bxh24_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu ya falibadi iyen, Au lau watanigu, haba sidohana doga onaꞌonana E fatalahamiu. ");
INSERT INTO bxh24_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yofede edi hagida sa luhu afuledi na sa lau watan. ");
INSERT INTO bxh24_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ya aulaha boda hinaga, Sebedi nanatuna luwaga Diyemsi yo Diyon ya itadi. Iti mate edi waga yai ma tamadi, edi hagida sa abiꞌabi nonohaidi. Yesu ya yogaidi, ");
INSERT INTO bxh24_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","yofede, edi waga yo tamadi sa luhu afuledi, na maꞌedi sa lau. ");
INSERT INTO bxh24_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu Galili mahudoꞌina ya fataꞌiꞌili, be Diusi edi aba oiꞌoigogo yai ya lau faꞌata, yo Galewa Aba Baꞌisa Nuꞌuna wasana loholohona ya lauguguyaꞌen yo dodoga adi asiyebo hudoꞌi-hudoꞌi ya faloholohodi. ");
INSERT INTO bxh24_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Wasana ya tadada Siliya Nuꞌuna mahudoꞌina yai, be salumadi sa asiyebo yo kamkamna hudoꞌi-hudoꞌi sa abidi, yaluwa heyaheyayadi, peꞌipeꞌi bubu yo dabidabidi mate dodoga sa ledima be mahudoꞌidi Yesu ya faloholohodi. ");
INSERT INTO bxh24_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Baiwa laꞌilaꞌi Galili yai yo <<Taon Safuhudohudoꞌi>> yai, Yelusalem yai, Diudeya yo Diyodan tefa dohedohena nuꞌudi sa lau watan. ");
INSERT INTO bxh24_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Baiwa laꞌilaꞌi Yesu ya itadi, be ya finahe hasa uduhuli hesa yai amainiya ya taꞌai. Tau famuli watanina sa obiyo fataꞌiꞌili. ");
INSERT INTO bxh24_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Habahim ya fatubu ya faꞌatadi. ");
INSERT INTO bxh24_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Iyen, Salumadi yaluwa yai sa deha, nuwadi ti amna wananaha, Galewa Aba Baꞌisa Nuꞌuna mate iti enehedi. ");
INSERT INTO bxh24_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Salumadi sa nuwa heyaya, nuwadi ti amna wananaha. Paꞌana Yaubada haba nuwadi ya liba fataludi. ");
INSERT INTO bxh24_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Tau nuwa lidilidi nuwadi ti amna! Paꞌana Yaubada haba tanoꞌubu ya feledi! ");
INSERT INTO bxh24_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Salumadi dudulai guliyamna yo gadomaguna lisidi yai, mate nuwadi ti kwade! Yaubada haba ya famohafudi. ");
INSERT INTO bxh24_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Tau nuwatohatoha, nuwadi ti amna! Paꞌana Yaubada haba ya nuwatohatohaedi hinaga! ");
INSERT INTO bxh24_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Salumadi nuwadi sa aꞌa, nuwadi ti kwade, paꞌana Yaubada haba sa ita! ");
INSERT INTO bxh24_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Tau laulau bili salumadi, nuwadi ti kwade. Paꞌana Yaubada haba ya kawa natuwedi! ");
INSERT INTO bxh24_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Salumadi dudulai debana yai sa ankamkamna, nuwadi ti amna wananaha, paꞌana Galewa Aba Baꞌisa Nuꞌuna iti enehedi! ");
INSERT INTO bxh24_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Salumamiu dodoga sa liba faheyayamiu, sa fakamkamnamiu yo liba bwalabwala yai wasamiu sa faheyayadi yau debagu yai mate, au kwade. ");
INSERT INTO bxh24_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Laulauna eseꞌesegana sa ginauli peloweta bwaꞌidi lisidi yai Nuwamiu ti amna yo au kwade, paꞌana maisamiu laꞌilaꞌi galewa yai ya otaꞌota. ");
INSERT INTO bxh24_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Umi mate dodoga adi alita. Inmoho yena alita ni amnana ya ofi, haba sidohana faꞌamna fuyoina? Ya heyaya, haba peina moho be dodoga ai hewana sa bwaꞌi. ");
INSERT INTO bxh24_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yo umi mate tanoꞌubu mahudoꞌina ana mala. Yena siti uduhuli yai sa ginauli hige gonowana ti simo. ");
INSERT INTO bxh24_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Lampa te gabu ibege ai gulewa ta fabuihomo. Haba aba fataꞌaina yai te tole, be dodoga luma yai mala ya feledi. ");
INSERT INTO bxh24_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Gonogonowana doha, em mala bena ya sina dodoga ai lisidi, be haba ginauli loholohodi wa ginaulidi sa itadi haba Tamam galewa yai sa fadebasae. ");
INSERT INTO bxh24_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Tabu emi nuwatuhu mate Yau E laoma bena Peloweta edi lau faꞌata yo Mose ena laugagayo haba ya falautomdi. Higeꞌe. Inmoho fawananahadi haluluna E laoma. ");
INSERT INTO bxh24_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Galewa yo tanoꞌubu haba sa tauyamuhi. Inmoho, E faliba dudulaimiu mate laugagayo piꞌana o ena koma kiukiu ibege i tauyamuhi ana siga ee–, ginauli mahudoꞌina ya fawananaha. ");
INSERT INTO bxh24_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Be yena, sai laꞌi laugagayo te ya moꞌa peiyen, yo dodoga haisa ya fatalahadi be sa ginauli doha, haba Galewa Nuꞌuna, sa ita fakium. Na inmoho, sai laꞌi laugagayo te ya famuli watanidi yo dodoga haisa ya fatalahadi be sa famuli watanidi mate ai Galewa Basileiyana haba sa ita hitiꞌi. ");
INSERT INTO bxh24_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","E falibamiu pa'ana, gonowana haba Galewa Nuꞌuna ami sola, yena nuwamiu sa adidili, be tabu Falesiya yo laugagayo tau lau faꞌataedi au lau watanidi, na Yaubada ena nuwatuhu ami lau watan, haba Galewa Basileiyana ami luhuhu sola. ");
INSERT INTO bxh24_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Beyabeyana haba dodoga sa falibadi, tiyen, <<Tabu au aiyunu mate au atahiyen, na yena sai ya aiyunu mate ai halana haba ya lau fatala.>> ");
INSERT INTO bxh24_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Inmoho, E falibamiu yena sai hidana ya manabalaꞌen, mate hinaga haba ya lau fatala. Yo yena hidana ya liba faheyaya mate haba Sanhedeli ai matadi ya obiyo. Yo sai hidana ya kawa yauyauleꞌen haba heyaya ya lobahi oyagi alaꞌalana yai. ");
INSERT INTO bxh24_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Lisina yai, ibe yena em ainauya bena wa felen aba antalasam yai na amainiya wa nuwatuhui mate, hidam ena, ana manabala lisim yai hola otana, ");
INSERT INTO bxh24_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","em ainauya ai aba antalasam u lau afulen, na u fuyo hidam lisina be em fadududulai u ginauli, habahim u fiyoma em ainauya Yaubada u felen. ");
INSERT INTO bxh24_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Yena sai somo halana yai ya samanim, tau samanin ma'em pilipilina ni, au fadudulai heuheulai, ibe i tolem tau fafadudulai ai lisina be tau fafadudulai i tole lawem pilisiman ai lisina be ai deli i tolem. ");
INSERT INTO bxh24_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","E liba dudulai, ainiya haba wa miya ee–, ana siga am sadi wa famaisa ");
INSERT INTO bxh24_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Haꞌa ami sibai mate: kelele laugagayo. ");
INSERT INTO bxh24_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Inmoho, aho te E falibamiu: Sai laꞌi waihin ya ita na nuwa ganahewana yai ya gadolelehiyen, mate haꞌa ya kelele nuwana yai. ");
INSERT INTO bxh24_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Be yena matam tefa sibam ya falauponom, u limofahi, be u pei! Ibe taum mahudoꞌina i faheyaya be u alagolu ai oyagi alaꞌalana. ");
INSERT INTO bxh24_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Be yena nima sibam ya falauponom, u ibo motu be u pei! Doꞌata taum mahudoꞌina ya faheyaya be wa alagolu ai oyagi alaꞌalana hesana Gehena. ");
INSERT INTO bxh24_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Hinaga sa liba, tiyen, Sai lahuna ya tausohoꞌen mate bena tausoho pepana ya uli be ya felen. ");
INSERT INTO bxh24_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Inmoho, E falibamiu doha ite: <<Waihin sai hige i kelele na lahuna ya tausohoꞌen, be waihin ya nahi boda mate waihin ya kelele. Na yena taumoho sai waihin tautausohona ni ya fai mate taumohona ya kelele hinaga.>> ");
INSERT INTO bxh24_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Beyabeyana dodoga sa fafalibadi haꞌa ami atahiyen, <<Tabu em angwala u utusi. Somo GUYAU lisina yai wa angwalaꞌen, bena wa ginauli watan.>> ");
INSERT INTO bxh24_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Inmoho E falibamiu: Yena ami angwala, tabu u angwala hasa galewa, paꞌana Yaubada ena aba tanuwaga nu'una, ");
INSERT INTO bxh24_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","o ai tanohi, paꞌana mate ahena ena aba faꞌanyawasina. Ye tabu Yelusalem hesana au atahi, paꞌana Kin Laꞌilaꞌi ena siti. ");
INSERT INTO bxh24_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Hinaga tabu u angwala ai kulum, paꞌana ibege kulu maihawadi laꞌi u ginauli be i kafu or i duba. ");
INSERT INTO bxh24_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Bena wa liba moho uwen, <<Ii–>> o <<Higeꞌe.>> Somo hesa wa libaen, mate Diyabolo lisina yai ya laoma. ");
INSERT INTO bxh24_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Laugagayo beyabeyana ganahewana yai haꞌa ami sibai. Sa libaen, tiyen, <<Yena sai matam ya oigolu, mate dogana matana hinaga u oigolu. Yo yena sai moꞌam ya oitutu, mate hinaga moꞌana hinaga u oitutu.>> ");
INSERT INTO bxh24_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Inmoho, ahoꞌite E falibamiu: Sai somo lisim yai ya ginauli faheyaya, mate tabu am hala u abi. Yena sai ya lau-papalinim, tefa hesa u felen be ainiya i oi hinaga. ");
INSERT INTO bxh24_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Sai bena ya foyahim tau fadudulai matana yai be am luhuluhu ya abi, mate luhuluhu lofalofana hinaga u felen. ");
INSERT INTO bxh24_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Na yena hiyala dogana ya duduim be ena tobo wa bahei lawen somo yai am sigasiga ya tole, mate hagahagana u abi lawen. ");
INSERT INTO bxh24_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Yena sai somo ya etai lisim yai, u felen; yo sai somo lisim yai bena ya abi be ya fapaisowa hinaga u felen. ");
INSERT INTO bxh24_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Haꞌa sa libaen, tiyen: <<Hidam u gadosisiyen, na am waiyunu u ꞌwaiyoꞌoen.>> ");
INSERT INTO bxh24_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Inmoho, E falibamiu: <<Am waiyunu u fanuha, yo saluma sa liba fafaheyayam, enehedi u lauꞌuꞌula.>> ");
INSERT INTO bxh24_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Umi haba Tamam galewa yai nanatuna. Ena maihala ya fasina tau heyaya yo tau loholoho enehedi. Usa ya fatamali tau miya dudulai yo tau miya heyaya enehedi. ");
INSERT INTO bxh24_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yena salumadi sa gadogadosisiyemiu ibodi ami fanuhadi, paꞌana somo haba Yaubada ya famaisamiu? Mate iti tau takesi tau tano edi laulau. ");
INSERT INTO bxh24_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yo yena afa efamiu ibodi ami lautoꞌiyedi, na dodoga haisa higeꞌe, mate haba sidohana? Salumadi Yaubada hige ti sibai edi laulau doha. ");
INSERT INTO bxh24_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Bena inonomiu sa loholoho wananaha doha Tamamiu galewa yai inonona sa loholoho. ");
INSERT INTO bxh24_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Bena ami ita komakoma'i yena <<emi laulau dudulaidi>> ami ginaulidi. Tabu dodoga ai matadi be ti itadi. Do'ata ibege maisa la'i au abi Tamamiu Galewa yai ai lisina. ");
INSERT INTO bxh24_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yena tau gogo gesagesa wa ainauyai, tabu bwagigi u yufi doha tau lau bwalabwala sa ginauli ai aba oiꞌoigogo yo ai eda'eda la'ila'i be haba dodoga sa noꞌonoꞌoedi. E falibamiu, haꞌa maisadi mahudoꞌina sa abi. ");
INSERT INTO bxh24_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Inmoho, yena tau gogo gesagesa wa saguhi, mate somo sibam ya ginauli bena tabu seuseulim i sibai. ");
INSERT INTO bxh24_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Be em felefele simosimo yai wa ginauli. Tamam Galewa yai, ya ita haba ya famaisa. ");
INSERT INTO bxh24_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yena ami lauꞌuꞌula, tabu tau lau bwalabwala edi laulau au lau watanidi! Sa fanuha bena ai aba oigogo yo ai edaꞌeda giugiulidi sa obiyo na sa lauꞌuꞌula, be haba dodoga sa noꞌonoꞌoedi. E faliba dudulaimiu mate maisadi haꞌa sa abi. ");
INSERT INTO bxh24_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Yena ami lauꞌuꞌula, au lau emi ai bili. Edaꞌeda au gudu, na au lauꞌuꞌula lau Tamam hige ta ita lisina. Haba Tamamiu somo simisimo yai ami ginauli, ya famaisamiu. ");
INSERT INTO bxh24_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Yena wa lauꞌuꞌula, tabu em liba u falofadi, doha mulimuli tataudi edi laulau. Edi nuwatuhu mate, Yaubada haba ya atahiyedi, paꞌana edi lauꞌuꞌula mate sa lofa. ");
INSERT INTO bxh24_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tabu umi doha, Tamam haꞌa ya siba bwaꞌi somo wa fanuha, muli yai habahim wa anꞌetai. ");
INSERT INTO bxh24_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Bena doha ite wa laulauꞌuꞌula: <<Tamamai Galewa yai wa miyamiya, Hesam tabuna ti faꞌatitiyen, ");
INSERT INTO bxh24_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","yo em Aba Baꞌisa bena wa fatubu dodoga ai lisidi Em nuwatuhu tanohi yai ti ginauli doha Galewa yai. ");
INSERT INTO bxh24_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Lahai esega-esega kalahena ama u felemai. ");
INSERT INTO bxh24_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ema laulau heyaheyayadi lisimai yai u liba afuledi, doha dodoga heyaheyaya lisimai sa ginauli ꞌe nuwa afuledi. ");
INSERT INTO bxh24_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yena noho 'e fahoina, tabu u ita tuhumai, be ai Tau Faheyayamai u fasagu fahimai. (Aba Baꞌisa Nuꞌuna enehem, gigibwali enehem, loholoho diꞌoina enehem, fuyanina hige ana siga!) Wananaha.>> ");
INSERT INTO bxh24_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yena dodoga haisa heyaya lisimiu yai sa ginauli, na ami nuwa afuledi, Tamamiu Galewa yai hinaga haba emi heyaya ya nuwa afuledi. ");
INSERT INTO bxh24_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Na yena hige dodoga haisa edi heyaya au nuwa afuledi, Tamamiu hinaga ibege emi heyaya i nuwa afuledi. ");
INSERT INTO bxh24_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yena ami anhudi, tabu nenem au faheyayadi doha dodoga bwalabwaladi edi laulau. Laulau bwalabwaladi sa ginauli, be dodoga haisa, nenedi sa faheyaya fuyoꞌidi mate bena sa faꞌitadi, mate bena haga sa andabu. E falibamiu, maisadi haꞌa sa abi. ");
INSERT INTO bxh24_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Yena wa anhudi u matabui yo kulum u suwali. ");
INSERT INTO bxh24_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Haba haidam haisa ibege ti sibai mate, um wa anhudi. Yaubada ibona, in hige ta ita, In ya sibai, yo Tamam, somo simosimo yai wa ginauli ya ita wa, maisam haba ya felem. ");
INSERT INTO bxh24_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Tabu tanoꞌubu ginaulidi lisidi yai u fagogo. Gonowana haba sa masi, kwalikwali haba sa andi, yo tau angafu haba sa abidi. ");
INSERT INTO bxh24_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Bena, Galewa enehena wa nonoha, hige gonowana haba kwalikwali yo masi ti faheyayadi, yo tau angafu ti abidi. ");
INSERT INTO bxh24_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Emi gogo somo yai ami toledi, haba nuwamiu hinaga ainiya. ");
INSERT INTO bxh24_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Matada mate tauda ana mala. Yena matam sa loholoho, mate taum mahudo'ina haba mala ya famohafu. ");
INSERT INTO bxh24_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Na yena matam sa heyaya, taum haba ya kamumu. Be yena mala ganahewam yai ya kamumu mate, kamumu haba ya laꞌi wananaha. ");
INSERT INTO bxh24_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Hige gonowana bena doga esega, na ena babaꞌisa luwaga. Hesa haba ya fanuha na hesa ya ꞌwaiyoꞌoen. Hesa haba ya awaꞌabiyen na hesa ya moꞌa peiyen. Hige gonowana moni yo Yaubada enehedi u paisowa. ");
INSERT INTO bxh24_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Lisina yai E falibamiu mate, tabu tanoꞌubu miyamiyana au modeꞌen wananahai. Somo haba ami an yo ami nom, o taumiu yai haba somo ami liꞌo. Kalahe ya loholoho wananahana habahim mwahuli?! O leli ginaulidi sa loholoho habahim tauda?! ");
INSERT INTO bxh24_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ataiꞌa sa lofolofo taꞌiꞌili haga au itadi. Hige ti umaꞌuma yo ti lau gabu be ti peinidi. Inmoho Tamamiu Galewa yai ya ita watanidi! Doga mate ya hasai wananaha, habahim atai'a. ");
INSERT INTO bxh24_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sai wa mode wananaha wa sibai haba em mwahuli begana wa falofa? ");
INSERT INTO bxh24_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Sidohana be leli lisidi yai ami mode? Mula sa in, hola au itadi, iti hige ti paisowa o ibodi edi leli ti ginaulidi. ");
INSERT INTO bxh24_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Inmoho, E falibamiu mate, Kin Solomon ena gogo ganahewadi yai, hige ena leli ginaulidi laꞌi nenena i loholoho doha mula laꞌi te. ");
INSERT INTO bxh24_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yena hawahawa tanohi yai sa inꞌin, Yaubada ya falelidi, aho, sa taya na bobon sa hohoya be sa gabudi. Lisina emi nuwatuhu bena umi ibege i modemiu? Umi emi kawawananaha haꞌa ti kiu? ");
INSERT INTO bxh24_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tabu au mode wananaha, auwen, <<Ama kalahe, ama hoꞌowa yo ema leli, haba ai somo sa laoma?>> ");
INSERT INTO bxh24_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mulimuli dodogadi ginaulidi te sa gadolelehiyedi. Inmoho Tamamiu Galewa yai, emi fanufanuha haꞌa ya sibaidi. ");
INSERT INTO bxh24_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Bena moho, Yaubada ena Aba Baꞌisa yo somo Yaubada ya fanuha ami yoꞌoi bwaꞌiyedi, habahim ginauli haisa te haba ya felemiu. ");
INSERT INTO bxh24_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Be tabu bobon modena au nuwanuwatuhu. Paꞌana bobon ibona modena haba ya ginauli. Lahai esega-esega maꞌana mode dumaduma. ");
INSERT INTO bxh24_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Tabu haidam u fakasadi, ibe um hinaga Yaubada i fakasam. ");
INSERT INTO bxh24_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Haba Yaubada ya fakasamiu gonogonowana doha haidamiu emi fafakasadi, lufa somo ami fapaisowadi haba ai lisimiu Yaubada doha ya ginauli. ");
INSERT INTO bxh24_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Paꞌana somo hidam matana muꞌalina wa ita, na um matam yai mwadale laꞌilaꞌi hige u modeꞌen? ");
INSERT INTO bxh24_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Sidohana be wa libalau hidam lebena, uwen, <<Haga u laoma be matam muꞌalina ya kamfahi?>> Na um matam yai oyagi mwadalena otana? ");
INSERT INTO bxh24_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Um doga bwalabwalana! Bwaꞌibwaꞌina mate matam yai mwadalena u kamfahi, mulina haba matam ya nega na hidam matana muꞌalina wa kamfahi. ");
INSERT INTO bxh24_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ginauli fafatabudi tabu ꞌwayowa u feledi. Doꞌata sa timuli bui haba sa nalim. Yo em giniꞌuba matapoudi tabu u pei lawedi salai ai nuwanuwadi. Doꞌata sa bwaꞌi golugoludi. ");
INSERT INTO bxh24_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Au anꞌetai, Yaubada haba ya felemiu; au yoꞌoi, haba ami lobahi; au oiꞌoi, haba edaꞌeda ya soꞌe. ");
INSERT INTO bxh24_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Sai ya anꞌetai haba ya felen; sai ya yoꞌoi haba ya lobahi, yo edaꞌeda haba sa soꞌe yena sai ya oiꞌoi. ");
INSERT INTO bxh24_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ibe sai natum fwalawa ya anꞌeta haba umeꞌehu wa felen? ");
INSERT INTO bxh24_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O, yena hama ya anꞌetai, haba weso wa felen be ya an? ");
INSERT INTO bxh24_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yena nuwamiu yai auwen, <<Ai tau heyaya,>> inmoho nanatumiu ainauya loloho ami feledi. Lisina yai Tamamiu Galewa yai ai lisina somo ami anꞌetai haba ainauya loholoho ya felemiu. ");
INSERT INTO bxh24_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Lisina yai, somo ami fanuhadi dodoga haba ai lisimiu sa ginauli, umi hinaga bena ai lisidi ami ginauli doha. Paꞌana peloweta dodogadi edi liba, yo Mose ena laugagayo aniyodi wananaha logedi itete. ");
INSERT INTO bxh24_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Edaꞌeda hafohafona kiukiu ainiya au luhulau, paꞌana peꞌi edaꞌedana mate ya taliya na dodoga boludi sa laulau watan. ");
INSERT INTO bxh24_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Inmoho, mwahuli edaꞌeda hafohafona ya kiu, yo aba launa, ya mwatiti. Dodoga fisa moho haba sa lau watan. ");
INSERT INTO bxh24_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ami ita komakoman, peloweta bwalabwaladi lisidi yai. Sa laoma lisimiu nenedi doha sipi, inmoho ganahewadi yai doha ꞌwayoꞌwayowa manamanabaladi. ");
INSERT INTO bxh24_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Edi abiꞌabi yai haba ami ita lobahidi. Mahina luguna nulinulina ibege i fuwa be uluna doha kuhou. Na kuhou ibege i fuwa be waen. ");
INSERT INTO bxh24_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Logena, oyagi loholohona haba uluna loholohona, na oyagi heyayana haba uluna ya heyaya. ");
INSERT INTO bxh24_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Na oyagi tubutubu loholohona, ibege anꞌanina heyaheyayadi i toledi, yo oyagi heyayana ibege i fuwa loholoho. ");
INSERT INTO bxh24_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Be oyagi laꞌi hige i fuwa loholoho, haba oina be gabu goluna. ");
INSERT INTO bxh24_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Lisina yai, peloweta bwalabwala edi laulau yai haba ami ita lobahidi. ");
INSERT INTO bxh24_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ibege mahudoꞌimiu safaluma auwen, <<Guyau, Guyau!>> Haba ibege Galewa Aba Baꞌisa Nuꞌuna u luhu sola. Inmoho, Salumadi Tamagu Galewa yai, ena nuwatuhu sa lau watan mate haba sa luhu sola Galewa Aba Baꞌisa Nuꞌuna yai. ");
INSERT INTO bxh24_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Fakasa fuyana ya mahano, dodoga boludi haba sa libama lisigu, tiyen, <<Guyau, Guyau! Hesam yai Yaubada libana ꞌe libalibaen, hesam yai yaluwa heyayadi ꞌe liba duidi, yo noꞌo abiꞌabidi hinaga ꞌe ginaulidi.>> ");
INSERT INTO bxh24_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Haba alinadi E bui, yawa, <<Yau hige ya sibaimiu. Au lau hudoꞌi, umi dodoga heyaheyayamiu!>> ");
INSERT INTO bxh24_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yena sai egu liba ya atahiyen, e ya awaꞌabiyen mate, in doha doga sonosonogana ena luma bwanali hewana yai ya faꞌobiyo. ");
INSERT INTO bxh24_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Usa ya usa, bolowada sa wewe, yo hwayahwayau lumana ya famwahimwahiu. Inmoho hige i guli, paꞌana bwanali hewana yai ya ginauli. ");
INSERT INTO bxh24_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Inmoho sai egu liba te ya atahiyen, na ya moꞌa peiyedi mate, in doha doga yauyaulena, ena luma gelegele yai moho ya ginauli. ");
INSERT INTO bxh24_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Usa ya usa, bolowada ya wewe, yo hwayahwayau ya towa be lumana ya fadihodiho. Yofede ya guli be ya dem lopalopa. ");
INSERT INTO bxh24_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Libadi Yesu ya libaedi mulina yai mate ena lau faꞌata yai dodoga sa noꞌo, ");
INSERT INTO bxh24_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","paꞌana ena lau faꞌata doha sai maꞌena dudulai na hige doha laugagayo tau lau faꞌataina. ");
INSERT INTO bxh24_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Fuyana Yesu uduhuli yai ya letama, dodoga baiwadi sa lau watan. ");
INSERT INTO bxh24_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Taumoho lepela asiyebona ya abi, ya laoma Yesu nuwanuwana yai ya tulibono na iyen, Baꞌisa, yena wa tauꞌulu, mate u faloholohogu. ");
INSERT INTO bxh24_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu ya abilau, taumohona tauna yai, na alinana ya bui fafuyo, iyen, E tauꞌulu. U loholoho! Yofede, taumoho wa ana asiyebo ya ofi. ");
INSERT INTO bxh24_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Habahim, Yesu ya libalau dogana lisina iyen, U ataꞌatahi! Tabu sai ena u liba. U dudulai bee–, tau antalasam i ita sipoim. Yo ainauya Mose ena laugagayo ya libaen mate u gabu. Haba sa siba haꞌa wa loholoho. ");
INSERT INTO bxh24_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu ya mahano lau Kapanayum. Loma edi hiyala tau lau kulukuluina ya laoma be ya anꞌeta lau Yesu lisina bena haba ya saguhi. ");
INSERT INTO bxh24_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Iyen Aee–! Guyau, egu tau paisowa ya asiyebo be ya enoꞌeno luma yai. Hige gonowana i famwahiu yo ena kamkamna ya fafalaꞌi. ");
INSERT INTO bxh24_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu iyen, Haba E lau be E faloholoho. ");
INSERT INTO bxh24_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Na hiyala tau lau kulukuluina iyen, Guyau, tabu u laoma egu luma. Yau hige ya dudulai. U liba moho, haba egu tau paisowa ya hwaina. ");
INSERT INTO bxh24_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Paꞌana yau mate, dodoga lalaꞌi haisa gabuladi yai E paipaisowa hinaga. Na tau hiyala haisa mate gabulagu yai. Esega haba E faliba <<U lau!>> haba ya lau. Na hesa E faliba, yawa, <<U laoma!>> haba hinaga ya laoma. Na egu fayofayo tau abina E faliba, yawa, <<Ite u ginauli!>> haba ya ginauli. ");
INSERT INTO bxh24_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu ya atahiyedi, be ya noꞌo, yofede ya libalau dodoga sa laulau watan lisidi iyen, E faliba dudulaimiu, hige sai Isalaela yai ya lobahi, ena kawawananaha laꞌina doha doga te! ");
INSERT INTO bxh24_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","E falibamiu mate dodoga haba sa laoma maihala ena aba kepama yai yo ena aba bulu yai be sa taꞌai mataꞌasi yai maꞌedi Abelaham, Isako, yo Iyakobo, Galewa Nuꞌuna yai. ");
INSERT INTO bxh24_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Inmoho, safaluma bena haba Aba Baꞌisa Nuꞌuna dodogadi mate, haba sa pei lawedi ganamuli be ai kamumu sa tantan yo gadigadidi sa nali didinidi. ");
INSERT INTO bxh24_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Habahim Yesu ya libalau hiyala tau lau kulukuluina lisina, iyen, U lau em luma! Em kawawananaha debam yai somo wa fanuha haba ya tubu. Yofede, maihalana yai ni, hiyala tau lau kulukuluwenna ena tau paisowa ya loholoho. ");
INSERT INTO bxh24_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Fuyana Yesu ya lau Pita ena luma yai Pita botiyana waiwaihin mate ya atuꞌuhi ya ita ena aba enoꞌeno yai. ");
INSERT INTO bxh24_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu ya abilau tau asiyebo nimana yai, yofede ana atuꞌuhi ya talu mwalugulugu na ya paulaidi. ");
INSERT INTO bxh24_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Maimailafina, yaluwa heyaheyayadi dodoga ganahewadi yai sa ledima Yesu lebena. Yesu liba yai moho, na yaluwa heyeheyayadi ya liba duidi yo salumadi sa asiyebo sa loholoho. ");
INSERT INTO bxh24_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Logena, Peloweta Isaiya ya libaen, iyen, In iyabona adi asiyebo ya baheidi yo edi kamkamna ya abifahidi. Lisina yai Yesu ya ginauli doha, be libana ni ya fawananaha. ");
INSERT INTO bxh24_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu dodoga baiwadi ya itadi sa obiyo fataꞌiꞌili yofede ana hewahewali ya falibadi be sa lau gabogabo tefana. ");
INSERT INTO bxh24_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Laugagayo tau lau faꞌataina hesa ya laoma, be iyen, Tanuwaga, yau E nonoha, em aba lau somo yai haba E lau watanim. ");
INSERT INTO bxh24_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu iyen, ꞌWayoꞌwayowa edi gali, yo ataiꞌa hinaga edi nohi, inmoho Doga Natuna hige ena aba eno. ");
INSERT INTO bxh24_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yesu tau famuli watanina hesa iyen, Guyau, bwaꞌibwaꞌina u biya afulegu be ya lau tamagu ya boꞌusai. ");
INSERT INTO bxh24_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu iyen, U famuli watanigu, tau peꞌi falena tau peꞌi haba sa boꞌusai. ");
INSERT INTO bxh24_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu yo ana hewahewali waga yai sa awa gogo. ");
INSERT INTO bxh24_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na hige walolona, hwayahwayau laꞌilaꞌi ya abi mahano. Edi waga bena haba ya bulu. Na Yesu mate haꞌa ya eno ꞌwafu. ");
INSERT INTO bxh24_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ana hewahewali sa lau be sa fanohi, tiyen, Guyau, u saguhida! Ite haba te peꞌi! ");
INSERT INTO bxh24_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu iyen, Paꞌana somo be ami ꞌwasabu? Emi sunuma haga ti kiu! Habahim ya obiyo be hwayahwayau yo bagodu ya falibadi be sa fatautau. Yofede, daumwali laꞌilaꞌi. ");
INSERT INTO bxh24_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Mahudoꞌidi sa noꞌo tiyen, Taumoho somosomohena itete? Hwayahwayau yo bagodu alinana sa awaꞌabiyen. ");
INSERT INTO bxh24_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Fuyana Yesu ya mahano lau gabogabo tefana yai, Gadala Nuꞌuna yai, tatau luwaga demoni ganahewadi yai bwana yai sa laolaoma be Yesu sa lobahi. Luwagadi sa inonodi sa heyaya wananaha be nuꞌuna sa bobolei be ibege sai i lau niya. ");
INSERT INTO bxh24_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Maꞌesega na, sa ꞌwalaꞌui, tiyen, Yaubada Natuna, somo wa fanuha lisimai yai? Maihala hige dudulaina i abi, na wa laoma bena wa fakamkamnamai? ");
INSERT INTO bxh24_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Salai baiwadi mate sa banban, aꞌawadi hige i lofa. ");
INSERT INTO bxh24_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Yofede, yaluwa heyaheyayadi wa, Yesu sa faliba, tiyen, Yena bena wa liba afulemai, u dui lawemai salai baiwadi ni, ai ganahewadi. ");
INSERT INTO bxh24_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu iyen, Au lau! Yofede, sa kalamahano, be sa lau salai sa luhufidi. Be salai baiwana sa tafo sa lidi daha yai, sa dago hoꞌowa ganahewana yai be sa kapulolo. ");
INSERT INTO bxh24_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Salai tau itaꞌita watanidi sa gela, sa lau taon. Demoni sa luhufidi tataudi somo ya tubu lebedi yai mate dededi tau gela sa dedei. ");
INSERT INTO bxh24_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yofede, doga mahudoꞌina taon ganahewana yai sa lau be Yesu sa failobahi, be sa faliba, tiyen, Ema nuꞌu te u lau afulen! ");
INSERT INTO bxh24_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu waga yai ya awa boda, be ya fuyo ena nuꞌu. ");
INSERT INTO bxh24_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Amainiya tau dabidabi hesa ya enoꞌeno ena leiyafa yai be dodoga haisa sa baheiyama Yesu lisina. Dodoga wa, edi kawawananaha laꞌina somo ya ita, yofede ya libalau doga dabidabina lisina, iyen, Natugu, u nuwa adidili, em heyaya E nuwa afuledi. ");
INSERT INTO bxh24_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Laugagayo tau lau faꞌataendi haisa ibodi sa nuwanuwatuhu, tiyen, Doga te Yaubada hesana ya kaiwegowegogoꞌen! ");
INSERT INTO bxh24_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu edi nuwanuwatuhu haꞌa ya sibai, yofede, iyen, Paꞌana somo nuwatuhu heyaheyayadi ami nuwanuwatuhuidi? ");
INSERT INTO bxh24_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Sidohana? Somo ya malaha? Yena yawa, <<Em heyaheyaya haꞌa E liba afuledi?>> o yawa, <<U obiyo be u laulau?>> ");
INSERT INTO bxh24_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Haba E faꞌita lobahimiu mate, Doga Natuna ena gigibwali tanoꞌubu yai gonowana heyaheyaya ya liba afuledi. Yofede, ya libalau doga dabidabina lisina, iyen, U obiyo! Em leiyafa u bahei, na u lau em luma! ");
INSERT INTO bxh24_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Doga wa ya obiyo be ya lau ena luma. ");
INSERT INTO bxh24_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Dodoga sa ita, mate sa ꞌwasabu, na Yaubada sa fadebasae, paꞌana in logenana gigibwali dodoga ya feledi. ");
INSERT INTO bxh24_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu ya aulaha ya laulau, na takesi tau tano hesa ya ita ena ofesi yai ya taꞌataꞌai. Hesana mate Matiu. Yesu ya libalau lebena iyen, U famuli watanigu! Yofede ya obiyo be Yesu ya famuli watan. ");
INSERT INTO bxh24_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Fuyana Yesu ya kalakalahe Matiu ena luma yai, Takesi tau tano boludi yo dodoga heyaheyayadi haisa sa laoma be sa kalahe gogo ma'edi Yesu yo ana hewahewali. ");
INSERT INTO bxh24_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Falesiya haisa laulau te sa ita, be ana hewahewali sa fatiꞌodi, tiyen, Dodoga doha ite sidohana be ami tanuwaga maꞌedi sa kalahe? ");
INSERT INTO bxh24_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu alinadi ya atahi be iyen, Tau lepalepa gesa doketa hige ti fanuha, tau lepalepa moho iyabodi. ");
INSERT INTO bxh24_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Au italau Buka Tabuna yai be liba te aniyona au fadosi, <<Yau nuwatohatoha E fanuha, na antalasam E ꞌwaiyoꞌoedi.>> Paꞌana E laoma, hige tau dudulai adi halulu. Tau heyaya debadi yai E laoma. ");
INSERT INTO bxh24_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Diyon Babasito tau famuli watanina hinaga sa laoma Yesu lisina, be sa fatiꞌo tiyen, Sidohana be ai yo Falesiya ꞌe andabu, na um am hewali, higeꞌe? ");
INSERT INTO bxh24_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu alinadi ya bui iyen, Ami sibai mate, tau nahi fwaufwau afa haidana haba hige ti nuwadubu, ye? Hige gonowana! Inmoho, ana lahai ya laoma haba taumoho sa lawe hudoꞌiyen, lahaina yai habahim sa andabu. ");
INSERT INTO bxh24_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hige sai luhuluhu beyabeyana tapulitina i yome kaleko senana fwaufwauna yai, paꞌana popo fwaufwau haba ya kiu be luhuluhu beyabeya tapulitina ya falaꞌi. ");
INSERT INTO bxh24_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Hige gonowana haba sai waen fwaufwau i fagoi aba hinidi beyabeyana yai. Yena sa ginauli doha, aba hinidi haba sa tamo dagi. Waen haba ya tabuliwa, yo aba hinidi sa heyaya. Higeꞌe! Waen fwaufwau haba sa hin ai aba hinina fwaufwau yai, be waen yo aba hinidi ibege ti heyaya. ");
INSERT INTO bxh24_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu ma libalibana na, baꞌisa hesa ya abi mahano lisina yai, ya tulibono, na iyen, Mamaꞌitena yai ite, natugu ya peꞌi. U laoma, be u abiꞌina moho, haba ya mwahuli. ");
INSERT INTO bxh24_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yofede, Yesu yo tau famuli watanina, baꞌisa wa sa lau watan. ");
INSERT INTO bxh24_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Waihin hudoꞌi hinaga ꞌwasina ya miyamiya afuledi be–, bolima safuhudohudoꞌi-luwaga. Yesu mulina yai ya laoma be ena leli duduna ya abiꞌina. ");
INSERT INTO bxh24_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Nuwa ganahewana yai iyen, Ibe ena leli duduna moho E abiꞌina, haba E loholoho. ");
INSERT INTO bxh24_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Habahim, Yesu ya timuli be ya ita, yofede iyen, Natugu, Tabu u ꞌwasabu! Em kawawananaha haꞌa ya faloholohom. Maihalana yai waihin wa ya loholoho. ");
INSERT INTO bxh24_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Habahim, Yesu ya aulaha boda be ya luhulau baꞌisa ena luma yai, mate fino tau yufidi ya itadi, yo bobohalahala ya atahi. ");
INSERT INTO bxh24_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yesu iyen, Au lau ganamuli, mahudoꞌimiu! Tineꞌeu kiukiu ni hige i peꞌi. Mate ya eno moho. Yofede, mahudoꞌidi Yesu sa liuhwaꞌen. ");
INSERT INTO bxh24_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Luma tanuwagana dodoga mahudoꞌina ya duidi be sa lau ganamuli. Habahim Yesu ya luhulau tineꞌeu ena bili, na ya abilau nimana yai, yofede, ya obiyo. ");
INSERT INTO bxh24_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Wasana nuꞌu mahudoꞌina ya tafo nuhuli. ");
INSERT INTO bxh24_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Amainiya Yesu ya aulaha, na matatoutou luwaga sa lau watan. Sa yogayoga, tiyen, Deiwidi Natuna, U nuwatohatohaemai! ");
INSERT INTO bxh24_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Fuyana Yesu ya luhulau luma ganahewana, matatoutou luwaga sa lau lisina. Yesu ya fatiꞌoidi, iyen, Ami kawawananaha mate, gonowana haba E faloholohomiu? Alinana sa bui fuyoi, tiyen, Ii, Guyau!! ");
INSERT INTO bxh24_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Habahim, matadi ya abiꞌinidi, na iyen, Emi kawawananaha debana yai, haba ami loholoho! ");
INSERT INTO bxh24_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yofede, matadi sa loholoho boda. Yesu ya lau biliyedi iyen, Tabu sai laꞌi au faliba! ");
INSERT INTO bxh24_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Inmoho sa lau be Yesu wasana sa fatala libalibaen nuꞌuna yai. ");
INSERT INTO bxh24_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Sa auꞌaulaha mate, taumoho demoni ya luhufi yo hige i libaliba, sa leyama Yesu lisina. ");
INSERT INTO bxh24_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ya liba afulen, yofede, taumohona ya liba. Dodoga sa noꞌo tiyen, Hige somo laꞌi doha ite, Isalaela yai ai ita. ");
INSERT INTO bxh24_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Inmoho, Falesiya tiyen, mate Yaluwa Heyaheyayadi edi Baꞌisa, gigibwali ni ya felen be yaluwa heyaheyayadi ya liba duidi. ");
INSERT INTO bxh24_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu ya antaumana ya lau taon yo luma hesa-hesa yai be edi aba oiꞌoigogo lumadi yai Yaubada Aba Baꞌisa Nuꞌuna Wasana Loholohona ya lau faꞌataen yo tau anꞌiwala, tau asiyebo ya faloholohodi. ");
INSERT INTO bxh24_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Dodoga baiwadi ya itadi be, ya nuwatohatohaedi, paꞌana sa nuwamode yo hige tau saguhidi, doha sipi hige tau ita watanina. ");
INSERT INTO bxh24_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yofede, ya libalau ana hewahewali lisidi iyen, Witi yo bali adi fuya anaho, inmoho tau tanogogo hige ti ouli. ");
INSERT INTO bxh24_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Au lauꞌuꞌula lau gabu tanuwagana lisina, haba tau paisowa haisa ya fatamalidima, be ena gabu sa paisowai. ");
INSERT INTO bxh24_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu ana hewahewali 12 ya yogaidi be gigibwali ya feledi, haba yaluwa heyaheyayadi dodoga ganahewadi yai, yo asiyebo hudoꞌi-hudoꞌi haba sa faloholohodi. ");
INSERT INTO bxh24_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tau faꞌona wasawasa ya fasinabodi hesadi itete: Bwaꞌibwaꞌina mate Saimon. Hesana hesa Pita, yo hidana Endulu; Sebedi nanatuna, Diyemsi yo hidana Diyon; ");
INSERT INTO bxh24_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipi, Batolomiu, Tomasi, yo takesi tau tanotano Matiu, yo Alefaiyesi natuna Diyemsi yo Tadiyesi; ");
INSERT INTO bxh24_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon Seloti, yo Diudasi, Yesu ana tau wewe. ");
INSERT INTO bxh24_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Dodoga safuhudohudoꞌi luwaga, Yesu ya faꞌoinigugudi mulina yai ya duidi, na iyen, Tabu au lau taꞌowawa ai pwaludi o au sola lau Samaliya edi taon hesa-hesa yai. ");
INSERT INTO bxh24_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Au lau Isalaela sipidi sa gege ai lisidi moho. ");
INSERT INTO bxh24_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ami lauwasi mate wasa te au guguyaꞌen auwen, <<Galewa Aba Baꞌisana Nuꞌuna mate ya sigisigima.>> ");
INSERT INTO bxh24_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tau peꞌi au famwahulidi. Tau asiyebo au faloholohodi yo demoni dodoga ganahewadi yai au liba duidi. Yo lepela tau abidi au faloholohodi. Gigibwali E felemiu hige au famaisa, be ami fapaisowa mate tabu au kawa maisa. ");
INSERT INTO bxh24_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Gole, siluba, o moni, tabu au abidi. ");
INSERT INTO bxh24_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Emi adau yai te, tabu paosi, luhuluhu hagahagana, tabu buti o tuꞌe au abidi,paꞌana, tau paisowa wa, ena fanufanuha mate dodoga adi paopao. ");
INSERT INTO bxh24_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Yena ai taon ami mahano, dodoga dudulaidi au yo'o haba ai lisidi ami miya ee–, ami aulaha boda. ");
INSERT INTO bxh24_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ai lumana ami luhulau, auwen, <<Yauwedo.>> ");
INSERT INTO bxh24_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Yena luma dodogadi sa failobahimiu, ainiya au miya. Inmoho yena hige ti ita wata komakoma'inimiu, mate luma o taonna au lau afulen. ");
INSERT INTO bxh24_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Na sai hige i yoga hitimiu, o emi liba hige ti atahiyen, nuꞌuna au lau afulen, na ahemiu fufuꞌadi au oiluhiluhidi. ");
INSERT INTO bxh24_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","E falibamiu mate, ai <<Fakasa Lahaina>> haba Yaubada haba Yaubada ena manabala la'ila'i ya talu ai taon ni, habahim Sodom yo Gomola. ");
INSERT INTO bxh24_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yau E duimiu, doha sipi, ꞌwayoꞌwayowa pwaludi yai. Debana yai bena ami sonoga doha weso, yo bena ami tauꞌulu doha waliliya. ");
INSERT INTO bxh24_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Au ita komakoman! Dodoga haba sa aumiu, be sa lawemiu edi nuꞌu koniseladi lisidi yai, yo Diusi edi aba oigogo yai sa pidilimiu. ");
INSERT INTO bxh24_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Yau debagu yai haba sa lawemiu gawana yo kin matadi yai, be sa falau fatalamiu, na iti yo taꞌowawa ai matadi haba egu ami wikinisi. ");
INSERT INTO bxh24_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Yena sa aumiu tabu au mode, auwen, <<Sidohana haba ema libaliba yo somo haba ꞌe libaen?>> Maihalana yai ni, somo bena ami libaen mate Yaubada haba ya felemiu. ");
INSERT INTO bxh24_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Libadi ami libaedi mate hige umi emi nuwatuhu. Ai ganahewamiu haba Tamamiu Yaluwana ya libaliba lau lisidi. ");
INSERT INTO bxh24_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Dodoga haba ꞌwasinadi tefadi sa liba afuledi be sa wunuidi, yo tama haba natuna ya liba afulen hinaga doha; na wawaya haba afa tinadi yo afa tamadi edi abiꞌabidi doha, be dodoga haba sa lau funuhidi be sa peꞌi. ");
INSERT INTO bxh24_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yau debagu yai haba dodoga mahudoꞌidi sa ꞌwaiyoꞌoemiu. Inmoho, sai ya nuwa adidili be sigana yai, haba Yaubada ya fofofahi. ");
INSERT INTO bxh24_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ai taon laꞌi sa liba faheyayamiu au gela, au lau taon hesa. E faliba dudulaimiu mate, ibege Isalaela taondi yai ami paisowa au faꞌofidi, na haba Doga Natuna ya fuyoma. ");
INSERT INTO bxh24_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Sibasiba tau anpateina dogana mate ana tanuwaga hige i diꞌoi. Tau lau fayofayo dogana, ibege gonowana ena baꞌisa i saipwai. ");
INSERT INTO bxh24_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Lisina yai tau sikulu maꞌena ana tanuwaga gonogonowadi, na fayofayo tau abina ena baꞌisa gonogonowadi. Yena boga esega ganahewada yai eda baꞌisa sa kawa Belesebuluwen mate ita hinaga sa kawa Belesebuluweda. ");
INSERT INTO bxh24_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Tabu dodoga au ꞌwasabuwedi, ginauli somo simosimodi haba sa taumahata, na liba simosimodi haba liba famahatadi. ");
INSERT INTO bxh24_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Somo E falibamiu kamumu yai, bena ami liba bodaidi ai mahata, yo somo beyam yai sa faꞌatu fenafena bena dodoga wa faliba lidiyedi ai luma hewana. ");
INSERT INTO bxh24_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Saluma iti taumiu gonowana sa wunuidi, na yaluwamiu hige gonowana ti wunuidi mate, tabu au ꞌwasabuwedi. Inmoho, Yaubada, In gonowana tauda yo yaluwada ya gabu goludi ai oyagi balebalelemna hesana Gehena, logena, In au ꞌwasabuwen! ");
INSERT INTO bxh24_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Toea ainiya gonowana ataiꞌa kikiꞌuka luwaga wa famaisadi. Inmoho, Tamamiu ai matana ibege hesa i beꞌu ai tanohi. ");
INSERT INTO bxh24_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Umi kulumiu maihawadi mate, mahudoꞌina haꞌa ya fatilidi. ");
INSERT INTO bxh24_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Be tabu au ꞌwasabu. Umi maisamiu ya laꞌi, habahim ataiꞌa kikiluka. ");
INSERT INTO bxh24_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yena sai ya liba famahata haisa ai lebedi mate, in yau enehegu. Ai Galewa haba E ginauli doha Tamagu ai lisina. ");
INSERT INTO bxh24_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Inmoho, sai laꞌi iyen, Yau hige Yesu ya sibai. Tamagu Galewa yai ai lisina haba E ꞌwaiyoꞌoen. ");
INSERT INTO bxh24_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Tabu emi nuwatuhu mate nuwa esega E leyama tanoꞌubu. Higeꞌe, baineti moho E leyama. ");
INSERT INTO bxh24_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Wawaya haba ma afa tamadi sa lulu, na wawahin ma afa tinadi sa lulu. Afa nanatudi wawahin ma afa lawadi sa lulu. ");
INSERT INTO bxh24_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Doga ana waiyunu wananahana mate, ena luma dodogadi. ");
INSERT INTO bxh24_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Sai tamana o tinana ya fanuha wananahaidi, na habahim yau, mate hige gonowana in enehegu, yo sai natuna taumoho o waihin ya gadosisiyen wananahai habahim yau, mate hige gonowana in enehegu hinaga. ");
INSERT INTO bxh24_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sai yena ena kolosi hige i bahei na i famuli watanigu, mate in hige gonowana i famala tau famuli watanigu. ");
INSERT INTO bxh24_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sai ena nuwatuhu yai, ya anpate be ibona mwahuli ya lobahi, haba ibege i abi, na sai ena mwahuli ya pei yau debagu yai, haba mwahuli ya lobahi. ");
INSERT INTO bxh24_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Sai ya yoga hitim mate, Yau ya yoga hitinigu, na sai ya yoga hitinigu mate, tau fatamaligu ya yoga hitini. ");
INSERT INTO bxh24_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yena sai laꞌi peloweta dogana ya yoga hitin, paꞌana in peloweta dogana mate peloweta maisana haba ya abi. Na yena sai doga dudulaina ya yoga hitin paꞌana in doga dudulaina mate doga dudulaina maisana haba ya abi. ");
INSERT INTO bxh24_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","E faliba dudulaimiu mate, yena sai ho'owa gogomana dodoga kiki'inadi te ya feledi, paꞌana in tau famuli watanigu, dudulaina mate, maisana haba ya abi. ");
INSERT INTO bxh24_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu tau famuli watanina 12 ya fatalahadi mulina yai, nuꞌuna ya lau afulen, na ya lau ya lau faꞌata yo ya lauguguya, Galili taondi yai. ");
INSERT INTO bxh24_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Fuyana Diyon deli yai, Keliso somo ya ginaginaulidi, wasadi ya atahiyedi. Yofede tau famuli watanina haisa ya duidi sa lau Yesu lisina. ");
INSERT INTO bxh24_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Sa fatiꞌoi tiyen, U falibamai! Um logem Diyon ya libaen haba wa laoma, o doga hesa haba ꞌe bagiyen? ");
INSERT INTO bxh24_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu alinadi ya bui fuyoi iyen, Somo ami ita yo ami atahiyen, au fuyo, be Diyon au faliba auwen, ");
INSERT INTO bxh24_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","<<Tau matatoutou haba matadi sa falaladi, yo tau dabidabi haba sa laulau. Saluma asiyebo taudi yai mate sa loholoho; Tau beya tuitui beyadi sa taꞌafasi, yo tau peꞌi sa mwahuli fuyo; yo wasa loholohona mate sa duwai tau gogo gesagesa lisidi yai.>> ");
INSERT INTO bxh24_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yena sai hige i nuwa heyaya lisigu yai, nuwana i amna! ");
INSERT INTO bxh24_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Diyon tau famuli watanina sa lau na mulidi yai, habahim, Diyon wasana Yesu ya dedei fatubu baiwa lisidi yai, iyen, Fuyana ami lau nuꞌu pitapitalina yai, somo bena ami ita? Hwayahwayau hawahawa ya fafamwahiudi bena ami itadi? ");
INSERT INTO bxh24_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ami lau ni somo bena ami ita? Taumoho ena leli loholohodi bena ami ita? Higeꞌe! Salumadi edi leli loloho mate kin edi luma namanamalidi yai sa gogo! ");
INSERT INTO bxh24_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ami lau bena somo ami ita? Peloweta hesa bena ami ita ye? Ii–, moꞌisa, inmoho, doga ni peloweta mahudoꞌidi ya diꞌoidi. ");
INSERT INTO bxh24_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","In logenana wasana Buka Tabuna yai sa uli, tiyen, <<Yaubada iyen, <Haba egu wasa tau lawenna E fatamali bwaꞌiyen, be em edaꞌeda ya sepa nonohai.>>> ");
INSERT INTO bxh24_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","E falibamiu hige waihin laꞌi natuna maꞌena Diyon Babasito gonogonowadi. Inmoho, sai ya kiu Galewa Aba Baꞌisa yai mate ya laꞌi wananaha, habahim Diyon Babasito. ");
INSERT INTO bxh24_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Diyon Babasito ena fuya yai na ya laowa be ahoꞌite, dodoga inoꞌinono heyaheyaya Galewa Aba Baꞌisa Nuꞌuna sa anpatei bena sa lau gili fahi. ");
INSERT INTO bxh24_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Paꞌana Peloweta mahudoꞌidi yo Laugagayo sa libalibaen, ya laoma ee–, Diyon ena fuya yai. ");
INSERT INTO bxh24_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Yo ibe yena tiyen, <<Ilaidiya haba ya laoma,>> logenana bena ami tauꞌulu, mate Ilaidiya, na logenana In Diyon. ");
INSERT INTO bxh24_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Sai fafabeyana mate libana i falau watan! ");
INSERT INTO bxh24_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Hiti ahoꞌite haba E fagonogonowaꞌedi doha ite? Iti doha wawaya kikiꞌina maketi yai sa taꞌataꞌai, na sa yogayoga lau haidadi lisidi, tiyen, ");
INSERT INTO bxh24_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","<<Emi ꞌe figo, na hige au leꞌi. Peꞌi lilidi ꞌe wanaidi, na hige au tan.>> ");
INSERT INTO bxh24_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Fuyana Diyon ya laoma, ya andabu yo hige waen i nom, be doga mahudoꞌina tiyen, <<Yaluwa heyaheyayana ganahewana yai.>> ");
INSERT INTO bxh24_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Na Doga Natuna ya laoma, ya kalahe yo ya nom, be dodoga tiyen, <<Doga te hola au ita! In ya andom, yo ya nom wananaha. Takesi tau tano yo tau heyaya hidadi!>> Inmoho sonoga aba fawananahana mate ena paisowa loholohodi yai. ");
INSERT INTO bxh24_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yofede, taon laꞌilaꞌidi somo yai Yesu ena no'o abi'abidi mahudo'idi ya ginaulidi mate ya liba suꞌuidi, paꞌana nuwadi hige ti buidi. ");
INSERT INTO bxh24_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Iyen, Kolasin Nuꞌuna Yo Betesaida Nuꞌuna! Au nuwadubu! Pa'ana noꞌo abiꞌabidi lisimiu yai E ginaulidi, ibe E ginaulidi ai Taiya yo Sidon egoba beyabeyana haꞌa sa nuwabui be baiki sa liꞌodi yo sa anꞌouya. ");
INSERT INTO bxh24_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","E faliba dudulaimiu mate, Fakasa Lahaina yai haba Yaubada ena nuwatohatoha laꞌilaꞌi ya lau Taiya yo Sidon lisidi, habahim umi! ");
INSERT INTO bxh24_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na umi Kapanayum dodogadi! Emi fanuha bena ibomiu haba ami hasai Galewa? Haba ami lau dodoga peꞌipeꞌidi edi aba miya. Ibe noꞌo abiꞌabidi lisimiu yai E ginauli ai Sodom E ginaulidi, egoba iti sa miya be–, ahoꞌite! ");
INSERT INTO bxh24_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Bena ami kawawananaha mate, Fakasa ana Lahai yai, Yaubada haba nuwatohatoha la'ila'i Sodom ai lisidi ya ginauli, na habahim umi. ");
INSERT INTO bxh24_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Lahaina yai Yesu iyen, Tamagu E fadebasaem, Galewa yo Tanohi edi Guyau, paꞌana ginauli te wa simodi tau sibasiba yo tau nuwanuwatuhu lisidi yai wa simodi, na wa fataumahatadi wawaya kikiꞌina lisidi yai. ");
INSERT INTO bxh24_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Wananaha, Tamagu, pa'ana um em fanuha yai wa ginauli doha! ");
INSERT INTO bxh24_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tamagu mate, ginauli mahudoꞌina ya felegu. Natuna hige sai i sibai, Tamana ibona ya sibai. Na Tau Tamatama hige sai i sibai, Natuna ibona ya sibai, yo sai Natuna ya fasinabodi mate haba ai lisidi ya fataumahata. ");
INSERT INTO bxh24_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Saluma ami ewaꞌewa sa mwahu yo ami bayaho heyaya, mahudoꞌimiu au laoma lisigu, haba E faꞌanyawasimiu. ");
INSERT INTO bxh24_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Egu oibaho au abi be ai dabayalomiu au tole, na sibasiba ai lisigu au anpatei, paꞌana yau mate tau nuwa lidilidi, yo yau tau gadosisi be haba anyawasi ami lobahi. ");
INSERT INTO bxh24_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Paꞌana egu oibaho E felemiu mate, hige i mwahu. Yo ami ewaꞌewadi E fabahemiu, sa kufefe. ");
INSERT INTO bxh24_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sabati Lahaina yai Yesu ya lau witi gabudi hesa ganahewana yai ya laulau tiga. Tau famuli watanina sa guliyam, yofede witi sa anhole be tumadi sa anidi. ");
INSERT INTO bxh24_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Falesiya sa itadi yofede sa libalau Yesu lisina tiyen, Tau famuli watanim eda laugagayo sa utusi be Sabati yai laulau ni sa ginauli. ");
INSERT INTO bxh24_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu alinadi ya bui iyen, Nuwana Deiwidi somo ya ginauli, fuyana maꞌana hewahewali sa guliyam mate, hige Bukana au fatili? ");
INSERT INTO bxh24_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ya luhulau Yaubada ena luma yai, be maꞌana hewahewali fwalawa fatafatabuna sa an, inmoho eda laugagayo ya libaen, ibege sai i an. Tau antalasam ibodi haba sa an. ");
INSERT INTO bxh24_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nuwana Laugagayo hige au fatili mate Sabati ouꞌouli tau antalasam ai Luma Tabuna, Sabati Lahaina sa utusi, na inmoho hige edi heyaheyaya? ");
INSERT INTO bxh24_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","E falibamiu ginauli hesa amaiteꞌi mate, ya hasai wananaha, habahim Aba Antalasam Dubuna. ");
INSERT INTO bxh24_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Buka Tabuna iyen, Nuwatohatoha mate yau E fanuha. Yosiyosi ami antalasamedi mate, hige ya fanuhadi. Ibe itete, moꞌisa aniyona ami sibai, egoba dodoga edi heyaheyaya ibege au fagiludi. ");
INSERT INTO bxh24_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Paꞌana Doga Natuna mate Sabati Guyauna. ");
INSERT INTO bxh24_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nuꞌuna Yesu ya lau afulen na ya lau Diusi edi aba oigogo lumana yai. ");
INSERT INTO bxh24_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Amainiya mate, taumoho hesa nimana ya dabi. Yofede, dodoga haisa amainiya bena Yesu sa fagilu be sa fatiꞌoi tiyen, Sabati Lahaina yai gonowana asiyebo sa faloholohodi? ");
INSERT INTO bxh24_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu alinadi ya bui, iyen, Ibe um sai laꞌi em sipi, na Sabati yai ya beꞌulidi gali yai, haba wa abi hitin e higeꞌe? ");
INSERT INTO bxh24_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Doga mate ya hasai wananaha habahim sipi! Lisina yai eda Laugagayo ya libaen, bena doga ai Sabati te saguhi. ");
INSERT INTO bxh24_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Habahim ya libalau taumoho nima dabidabina lisina, iyen, Nimam u lolon! Nimana ya lolon, yofede, ya loholoho boda, doha nimana hesa. ");
INSERT INTO bxh24_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Inmoho, Falesiya sa lau be simosimo yai sa oiliba bena Yesu sa wunui. ");
INSERT INTO bxh24_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu mate edi oiliba simosimo yai haꞌa ya sibai, be nuꞌuna ya lau afulen; na baiwa sa lau watan. Salumadi sa asiyebo ya faloholohodi. ");
INSERT INTO bxh24_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Na ya falibadi mate tabu sai laꞌi wasana enehena ti dede. ");
INSERT INTO bxh24_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Laulau te ya ginauli paꞌana Yaubada somo ya libaen Peloweta Isaiya lisina yai, haba ya fawananaha, fuyana peloweta wa iyen, ");
INSERT INTO bxh24_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Itete egu tau paisowa, yau E fasinabo. E fanuha wananaha, yo nuwagu ya faꞌamna. Yaluwagu haba E tole ai lisina, be fakasa dudulaina ya libaen, nuꞌu ouꞌouli yai. ");
INSERT INTO bxh24_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ibege i faibayaho o i sagali, yo ai edaꞌeda ibege i fatala bwasabwasa. ");
INSERT INTO bxh24_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tau belubelu haba ya abi komakomanidi, na tau gelogeloma haba ya saguhidi. ");
INSERT INTO bxh24_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Hesana yai, nu'u mahudo'ina haba edi sunuma sa tole ai lisina. ");
INSERT INTO bxh24_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Habahim dodoga haisa taumoho hesa matatoutouna yo hige i libaliba paꞌana yaluwa heyaheyayadi ganahewana yai, sa leyama Yesu lisina. Yesu dogana ya faloholoho, be matana ya falala yo ya liba. ");
INSERT INTO bxh24_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Dodoga mahudoꞌidi sa noꞌo, be tiyen, Nuwana Deiwidi natuna? ");
INSERT INTO bxh24_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Falesiya sa atahiyen, be alinadi sa bui, tiyen, Yaluwa heyaheyayadi ya liba afuledi moho paꞌana demoni edi baꞌisa, Belesebulu, gigibwali ya felen, be doga te demoni ya liba duidi. ");
INSERT INTO bxh24_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Edi nuwatuhu mate, Yesu haꞌa ya sibai, yofede, ya libalau lebedi, iyen, Nuꞌu somo sa daili fuyoꞌidi, be sa lulu, ibege i ota lofalofa. Yo duhu laꞌi o boga esega sa hineli fuyoꞌidi, be sa lulu mate, ibege edi adidili hesa. ");
INSERT INTO bxh24_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Be ibe pele hesa haidana maꞌedi sa lulu, Satani ena nuꞌu ganahewana yai mate, haꞌa sa hinelidi be yena adi waiyunu sa duhu mahanoidi ibege edi adidili hesa. ");
INSERT INTO bxh24_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Yena Belesebulu ena gigibwali E fapaisowa, be yaluwa heyayadi E liba duidi mate, tau famuli watanimiu sai ena gigibwali sa fapaisowa be yaluwa heyayadi sa liba afuledi? Iti logedidi haba sa fakasamiu. ");
INSERT INTO bxh24_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Higeꞌe! Hige Belesebulu! Wananahana mate Yaubada Yaluwana In gigibwali ya felegu be yaluwa heyaheyayadi E liba duidi. Aniyona mate Yaubada ena Nuꞌu haꞌa ya mahanoma lisimiu yai. ");
INSERT INTO bxh24_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ibege sai laꞌi gonowana doga adiꞌadidilina ena luma i lopa, be ena ginauli i angafuhidi, yena doga adiꞌadidilina ni ya auꞌaui bwaꞌiyen, ai muli, habahim ena ginauli ya angafuhidi. ");
INSERT INTO bxh24_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Sai laꞌi hige yau egu, mate wananaha ya fawaiyunuwegugu. Sai laꞌi hige i saguhigu be ai tano gogo mate, tau anfadabalala. ");
INSERT INTO bxh24_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Lisina yai, E falibamiu mate, dodoga gonowana edi heyaya yo liba heyaheyayadi somo sa libaedi, haba Yaubada ya nuwa afuledi. Inmoho, sai ginauli heyaheyayadi Yaluwa Tabuna lisina yai ya libaedi mate, ibege Yaubada i nuwa afuledi. ");
INSERT INTO bxh24_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Sai Doga Natuna lisina yai somo ya libaen, gonowana haba E nuwa afulen. Inmoho, sai somo heyaheyayana Yaluwa Tabuna lisina yai ya libaen mate, ibege Yaubada i nuwa afulen, ahoꞌite, o fuya matada yai. ");
INSERT INTO bxh24_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Oyagi yena ya in loholoho, mate haba ya fuwa loholoho. Yena oyagina ni ya tubu heyaya mate, haba ibege i fuwa loholoho. Oyagina uluna yai haba te ita lobahi. ");
INSERT INTO bxh24_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Umi weso! Sidohana haba ginauli loholoho ami libaedi yena nuwatuhu heyaheyayadi lisimiu yai? Somo nuwada yai, haba moꞌada yai te liba famahata. ");
INSERT INTO bxh24_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Doga loholohona ginauli loloho nuwana yai sa otaꞌota, haba ya libaedi. Doga heyayana ginauli heyayadi nuwana yai sa ota, haba ya libaedi. ");
INSERT INTO bxh24_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Fakasa Fuyana yai, doga mahudoꞌina liba heyaheyayadi somo sa libaedi haba Yaubada ya famahatadi yo lisidi yai haba maisadi sa abidi. ");
INSERT INTO bxh24_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Em liba yai haba Yaubada ya fakasam. Be haba em heyaya o hige'e?! ");
INSERT INTO bxh24_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Habahim Laugagayo Tau Lau Faꞌataina yo Falesiya haisa, sa liba, tiyen, Tanuwaga, ꞌe fanuha bena noꞌo fafaꞌilalana wa ginauli be ꞌe ita. ");
INSERT INTO bxh24_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu alinadi ya bui, iyen, Aho, dodoga Yaubada hige ti modeꞌen. Lisina yai sa heyaya wananaha, yo hige ti kawawananahaꞌen. Ami fanuha bena noꞌo fafaꞌilalana E ginauli, ye?! Hige gonowana! Fafaꞌilala esega E ginauli be haba ami ita mate: Peloweta Diyona fafaꞌilalana. ");
INSERT INTO bxh24_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Laulauna gonogonowana doha Diyona. Lahai faihona yo iꞌipa faihona hama laꞌilaꞌi bogana yai ya miya. Doga Natuna hinaga haba doha lahai yo iꞌipa faihona ai tanohi ganahewana ya miya. ");
INSERT INTO bxh24_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Fakasa Fuyana yai, Ninewa dodogadi haba sa obiyo be sa fagilumiu, paꞌana fuyana Diyona ya lauguguya, sa atahi be nuwadi sa buidi. Na E falibamiu, ginauli hesa mate ya laꞌi wananaha, habahim Diyona! ");
INSERT INTO bxh24_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Fakasa Fuyana yai Seba edi Hatafele haba ya obiyo, be ya fagilumiu, paꞌana ana eda ya lofa na ena nuꞌu yai ya aulaha be ya laoma Baꞌisa Solomon ena liba sibasibadi ya atahiyedi. Na aho'ite mate ginauli hesa ya la'i habahim, Solomon mate amaite'i! ");
INSERT INTO bxh24_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yena yaluwa heyaheyayana doga ya gela afulen, na ya lau be nuꞌu pitapitalina yai ena aba miya ya yoꞌo, be haba ya anyawasi. Yena hige aba miya i lobahi, ");
INSERT INTO bxh24_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","haba ya liba, iyebom, <<Egu luma bwaꞌibwaꞌina, E lau afulen, haba E fuyo E gogoi.>> Yofede, ya fuyo be luma wa ya ita mate, hige sai amainiya yo itaꞌitana ya aꞌa, yo ginauli mahudoꞌina sa pei gogon komakomain. ");
INSERT INTO bxh24_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Habahim ya fuyo, be yaluwa heyaheyayadi faligigi-luwaga ya foyahidima; iti sa heyaya wananaha, habahim in. Sa laoma be amaniya sa gogo. Dogana aho'ite ena mwahuli mate ya heyaya wananaha habahim bwa'ibwa'ina yai. Hiti heyaheyaya te, ai lisidi haba laulau te sa tubu. ");
INSERT INTO bxh24_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu mate, dodoga hola ya fafalibadi, na tinana yo haidana sa mahano, be ganamuli yai sa obiyo. Sa fanuha bena maꞌedi Yesu sa libaliba. ");
INSERT INTO bxh24_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yofede, doga hesa ganahewa yai ya libalau Yesu lebena, iyen, Tinam yo tatasim mate ganamuli yai sa obiꞌobiyo, bena somo sa falibam. ");
INSERT INTO bxh24_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu alinana ya bui, iyen, Tinaguna sai? yo haidagudi salumadi? ");
INSERT INTO bxh24_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Habahim nimana ya lolon lawen tau famuli watanina lisidi, iyen, Ami ita! Tinagu yo haidagu logedi itete! ");
INSERT INTO bxh24_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tamagu Galewa yai ena fanuha sai ya ginauli mate, in hidagu, lofugu, yo tinagu. ");
INSERT INTO bxh24_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Lahaina yai, Yesu luma ya lau afulen, na ya lau gabogabo sadaina yai, ya taꞌai be ya lau faꞌata. ");
INSERT INTO bxh24_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Baiwa laꞌilaꞌi sa laoma sa faꞌoigogoi yofede waga yai ya awa, be ganahewana yai ya taꞌai, na dodoga, iti gelegele yai sa obiyo. ");
INSERT INTO bxh24_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Palabole ya fapaisowadi be ginauli peidi ya falibadi iyen, Fuya esega taumoho hesa ya lau be witi tumadi ya lau falili. ");
INSERT INTO bxh24_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tumadi ya lau falili mate: haisa sa be'u edaꞌeda yai, be ataiꞌa sa laoma sa anidi. ");
INSERT INTO bxh24_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Haisa sa be'u tanohi umeꞌumeꞌehu yai, tanohina hige i pwatapwata yofede, hige walolona sa kalamoꞌa. ");
INSERT INTO bxh24_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Maihala ya sina yofede sa hohoya be sa pe'i paꞌana lamdi hige ti sigilidi. ");
INSERT INTO bxh24_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tumadi haisa sa beꞌu pole pwaludi yai. Pole sa in be tuma hige ti in. ");
INSERT INTO bxh24_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Na haisa, sa be'u tanohi loholohona yai. Sa in, be sa fuwa, haisa 100, haisa 60, na haisa 30. ");
INSERT INTO bxh24_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu ena liba ofiꞌofina iyen, Yena fafabeyamiu, au ataꞌatahi komakoman! ");
INSERT INTO bxh24_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Habahim tau famuli watanina sa laoma Yesu lisina be sa fatiꞌoi, Paꞌana somo be dodoga wa fatalahadi mate palabole wa fapaisowadi? ");
INSERT INTO bxh24_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu alinadi ya bui iyen, Galewa ena Aba Baꞌisa sibasibana simosimona Yaubada ya fataumahata lisimiu yai, na dodoga te, iti higeꞌe. ");
INSERT INTO bxh24_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sai haꞌa somo lisina yai, haba hesa sa felen, be ena boludi. Na sai higeꞌe, mate somo begana lebena yai sa abifahi. ");
INSERT INTO bxh24_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Egu libaliba yai palabole E fapaisowadi mata paꞌana: <<Fafamatadi, na ibege somo ti ita. Yo fafabeyadi, inmoho ibege somo ti atahi o aniyona ti sibai.>> ");
INSERT INTO bxh24_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Isaiya ena liba haꞌa ya libaen mate iti sa fawananaha fuyana iyen, <<Dodoga te fafabeyadi, be sa ataꞌatahi, na ibege aniyona ti sibai. Yo fafamatadi, be somo sa itadi, inmoho ibege ti ita lobahidi, ");
INSERT INTO bxh24_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","paꞌana edi nuwanuwatuhu sa kikiluka, Ibe matadi sa falaladi, yo beyadi yai sa ataꞌatahi, haba nuwadi yai, aniyodi sa nuwatu lobahidi, na sa fuyoma lisigu, be E faloholohodi.>> ");
INSERT INTO bxh24_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Na umi, ami loholoho, paꞌana matamiu ami falaladi yo beyamiu sa taꞌafasi. ");
INSERT INTO bxh24_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","E faliba dudulaimiu, mate peloweta yo dodoga dudulaidi boludi, edi fanuha mate somo umi ami itadi, yo ami atahiyedi bena iti doha. Inmoho, hige gonowadi. ");
INSERT INTO bxh24_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Au ataꞌatahi, haba tuma tau falilina aniyona E dedei, be ami sibai. ");
INSERT INTO bxh24_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Yena sai Basileiya wasana ya atahiyen, na hige gonowana i nuwatuhu lobahi mate, Iti nenedi doha tuma edaꞌeda sadaina yai sa falilidi. Diyabolo ya laoma be somo nuwana yai ya abifahidi. ");
INSERT INTO bxh24_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Haisa sa beꞌulau tano umeꞌumehuna yai mate, iti Yaubada wasana tau atahiyenna, na feula sa abi, ma nuwa amnadi. ");
INSERT INTO bxh24_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Inmoho, nuwadi yai hige ti nuwatuhu didin, be hige i ota lofalofa. Be heyaheyaya ya laoma paꞌana liba wa debana yai, feula na nuwadi sa bui fuyoꞌidi. ");
INSERT INTO bxh24_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Na witi tumadi haisa sa beꞌu nulinuli ganahewadi yai mate, saluma wasa tau atahiyenna. Inmoho, mwahuli modemodena yai, yo tano'ubu gadolelehiyedi lisidi yai, Yaubada ena liba hige ti fanuha, be ibege ti fuwa loholoho. ");
INSERT INTO bxh24_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Na tuma tanohi loholohona yai sa beꞌulidi aniyona mate, saluma liba sa atahiyen yo aniyona sa nuwatuhu lobahi be sa fuwa, haisa 100, haisa 60, haisa 30. ");
INSERT INTO bxh24_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Palabole hesa Yesu ya dedei, Galewa Aba Baꞌisa itaꞌitana doha ite. Doga hesa ena gabu yai, tuma loholohodi ya falilidi. ");
INSERT INTO bxh24_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Iꞌipa esega, dodoga mahudoꞌidi sa eno ꞌwafu, ana waiyunu ya laoma be hawahawa ya falilidi, witi pwaludi yai, habahim ya fuyo. ");
INSERT INTO bxh24_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Witi yo hawahawa sa in gogo be witi anꞌannidi sa fatubu sa toledi, na habahim tau paisowa sa ita lobahi mate hawahawa sa in hinaga. ");
INSERT INTO bxh24_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Doga wa ena tau paisowa sa laoma lisina be tiyen, <<Guyau, tuma loloho afaꞌafa am gabu yai wa umahidi, na hawahawa ni siya ti laoma?>> ");
INSERT INTO bxh24_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Alinadi ya bui iyen, <<Waiyunu hesa ya laoma be doha ya ginauli.>> Sa fatiꞌoi, tiyen, <<Bena ꞌe lau be ꞌe laꞌa fahidi?>> ");
INSERT INTO bxh24_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Alinadi ya bui iyen, <<Hafena! Paꞌana yena hawahawa ami suluhidi, ibe witi au laꞌa esegahidi. ");
INSERT INTO bxh24_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ti otawa. Hawahawa yo witi ti faiꞌin yee–, lau gabu fuyana. Habahim tau lau gabu E falibadi, be hawahawa sa laꞌai bwaꞌiyedi, sa auꞌaugogoidi sa gabudi, na witi sa tano gogoꞌidi, be sa pei gogon, aba pei gogo ai lumana.>> ");
INSERT INTO bxh24_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Palabole hesa Yesu hinaga ya dedei, Galewa ena Aba Baꞌisa itaꞌitana doha ite. Doga hesa tuma doha saihala dimdim ya abi be ya umahi ena gabu yai. ");
INSERT INTO bxh24_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tuma mahudoꞌidi ganahewadi yai mate, in ya kiu wananaha. Yena ya in mate, umaꞌuma mahudoꞌina ya tubu famulidi. Ya famala doha oyagi kiukiu na ataiꞌa sa laoma, ai lagana sa nohi. ");
INSERT INTO bxh24_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu hola palabole hesa ya dedei, iyen, Galewa ena Aba Baꞌisa Nuꞌuna mate doha ite. Waihin hesa yisti ya abi, na fwalawa laꞌina 40 lita maꞌena ya falamo be fwalawa mahudoꞌina ya siu. ");
INSERT INTO bxh24_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu ginauli mahudoꞌina ya libaedi baiwa lisidi yai mate, palabole ya fapaisowadi. Hige itawa, somo ya libaen lisidi yai mate hige palabole i fapaisowa. ");
INSERT INTO bxh24_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Be somo peloweta ya libaen aba fawananaha mate doha ite, <<Tanoꞌubu ena fuya fatubu yai na ginauli simosimodi haba palabole yai E libaedi.>> ");
INSERT INTO bxh24_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Habahim ya lau afuledi, na ya lau luma ganahewa. Tau famuli watanina sa laoma lisina, be tiyen, Hawahawa palabolena aniyona u falibamai. ");
INSERT INTO bxh24_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu alinadi ya bui, iyen, Tuma loholohona tau falilina mate, Doga Natuna. ");
INSERT INTO bxh24_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Gabu mate Tanoꞌubu, na tuma loholoho mate, Basileiya nanatudi. Na hawahawa mate Diyabolo nanatudi. ");
INSERT INTO bxh24_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Na waiyunu hawahawa ya umahidi mate Diyabolo. Lau gabu fuyana aniyona mate, Tanoꞌubu ena fuya ofi. Tau lau gabu mate anelu. ");
INSERT INTO bxh24_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Yena hawahawa sa lagaufidi, haba sa gabudi. Tanoꞌubu ena fuya ofi yai, laulau te haba ya tubu. ");
INSERT INTO bxh24_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Doga Natuna haba ena anelu ya fatamalidima, be Aba Baꞌisa Nuꞌuna yai salumadi dodoga sa fafaꞌata ponolidi be heyaheyaya sa ginaulidi, haba sa laꞌa fahidi. ");
INSERT INTO bxh24_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Be sa gabudi ai oyagi balebalelemna. Ainiya haba sa tan yo gadigadididi sa nali didinidi. ");
INSERT INTO bxh24_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Na fuyanna yai mate, Yaubada ena dodoga haba sa sina doha maihala, Tamadi ena Aba Baꞌisa Nuꞌuna yai. Yena fafabeyamiu, au ataꞌatahi komakoman! ");
INSERT INTO bxh24_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Galewa ena Aba Baꞌisa Nuꞌuna nenena doha ginauli hesa loholohona gabu yai sa simo. Taumoho hesa ya lobahi, yofede ya simo bodai. Gabagabana ya tubi, na ya lau be ena gogo mahudoꞌina ya uneꞌune afuledi, na gabuna ni ya unefahi. ");
INSERT INTO bxh24_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Hesauna mate Galewa Aba Baꞌisa doha bisinisi dogana giniꞌuba loloho ya yoꞌoyoꞌoi. ");
INSERT INTO bxh24_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Giniꞌuba wa esega ya lobahi, na maisana ya laꞌi, ya fuyo be ena gogo mahudoꞌina ya une afuledi, habahim gini'uba ya une. ");
INSERT INTO bxh24_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Heyaheyason hesauna doha ite: Galewa Aba Baꞌisa Nuꞌuna doha hagida sa pei gabogabo yai na haba hama nene hesa-hesa sa ona. ");
INSERT INTO bxh24_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Hagida ya mohafu yofede, tau hama sa weꞌa hitin fote yai, na habahim sa taꞌai be hama loloho sa tanoidi be sa husa noho yai. Na heyayadi sa peidi. ");
INSERT INTO bxh24_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tanoꞌubu ena fuya ofi yai, anelu haba sa laoma be tau loholoho yo tau heyaya sa hinelidi. ");
INSERT INTO bxh24_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Tau heyaya haba sa peidi ai oyagi balebalelemna. Ainiya haba sa tan yo gadigadidi sa nali didinidi. ");
INSERT INTO bxh24_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu ya fatiꞌoidi, iyen, Ginauli te haꞌa ami sibaidi? Alinana sa bui, tiyen, Ii–, ꞌe nuwatuhu lobahi! ");
INSERT INTO bxh24_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ya falibadi iyen, Yena laugagayo tau lau faꞌataina mahudoꞌidi Galewa Aba Baꞌisa Nuꞌuna lau faꞌatana sa abi mate doha luma tanuwagana ena aba peipei gogo yai ginauli fwaufwaudi yo beyabeyadi ya fakalamahanodima. ");
INSERT INTO bxh24_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu heyaheyason wa ya dede ofinidi. Nuꞌuna ni ya lau afulen. ");
INSERT INTO bxh24_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Na ya fuyo ena nuꞌu wananahana be Diusi edi aba oigogo lumana yai ya lau faꞌata, na salumadi sa ataꞌatahi mate, sa noꞌo. Yofede, sa fatiꞌo, tiyen, Ena sibasiba somo yai ya abidi? Yo noꞌo laulaudi ni, sidohana ena ginaginaulidi? ");
INSERT INTO bxh24_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","In kapenta natuna? Yo tinana Maliya. Haidana mate, Diyemsi, Diyosepa, Saimon yo Diudasi. ");
INSERT INTO bxh24_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Afa lofuna maidada te gogogo. Laulaudi mahudoꞌidi te somo yai taumoho te ya abidi? ");
INSERT INTO bxh24_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yofede, sa ꞌwaiyoꞌoen. Yesu ya falibadi iyen, Peloweta dogana mate, nuꞌu ouꞌouli yai sa faꞌatitiyen. Inmoho, ena nuꞌu yai yo ana boga lisidi yai, ibege ti faꞌatitiyen. ");
INSERT INTO bxh24_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ena nuꞌu yai mate hige noꞌo abiꞌabidi boludi i ginaulidi, paꞌana hige ti kawawananaha. ");
INSERT INTO bxh24_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Fuyana yai Gawana Heloda, Galili Nuꞌuna tau ita watanina mate, Yesu wasana ya atahiyen. Ena tau paisowa ya falibadi, iyen, ");
INSERT INTO bxh24_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Moꞌisa Diyon Babasito peꞌi yai ya obiyo fuyo! Logena, gigibwali lebena yai be noꞌo abiꞌabidi ya lau ginauli. ");
INSERT INTO bxh24_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Bwaꞌibwaꞌina mate, Heloda haꞌa ya liba be Diyon sa au, be deli yai sa gudu buluhi. Mata paꞌana mate, Helodiya, tasina Pilipi lahuna halana yai. ");
INSERT INTO bxh24_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Paꞌana Diyon mate, Heloda ya faliba iyen, Waihin wa fai mate, wa laupono! ");
INSERT INTO bxh24_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heloda ya fanuha bena ya tala funuhi. Inmoho, Diusi dodogadi ya ꞌwasabuwedi, paꞌana edi nuwatuhu mate, Diyon peloweta hesa. ");
INSERT INTO bxh24_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Heloda ena fuya tubu lahaina yai, lahuna Helodiya natuna waiwaihinna, dodoga boludi nuwanuwadi yai ya leꞌileꞌi. Heloda nuwana ya amna, ");
INSERT INTO bxh24_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","be ya liba fasunumaꞌen, iyen, E liba dudulai mate, somo wa fanuha, haba E felem! ");
INSERT INTO bxh24_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tau tinatina mate, haꞌa natuna ya faꞌoinigugu bwaꞌiyen, iyen, Doꞌata te, aiteꞌi, itete Diyon Babasito kuluna ai gaeba wa felegu! ");
INSERT INTO bxh24_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kin Heloda nuwana ya heyaya. Inmoho, paꞌana haꞌa ya liba fasunuma ana taumana matadi yai mate, tineꞌeu ena fanuha somo haba ya felen. ");
INSERT INTO bxh24_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yofede, ya liba be Diyon deli yai, gadona sa ibo. ");
INSERT INTO bxh24_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kuluna gaeba yai sa leyama, be tineꞌeu sa felen, be ya lawen tinana ya felen. ");
INSERT INTO bxh24_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Diyon tau famuli watanina sa laoma silanna sa bahei be sa boꞌusai. Habahim sa fuyo be Yesu ena sa liba. ");
INSERT INTO bxh24_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Lahaina yai Diyon wasana Yesu ya atahiyen, yofede waga yai ya gelu modigafu be ya lau nuꞌu laulau gesana yai. Dodoga wasana sa atahiyen yofede, edi taon sa lau afuledi, na sa laufote be sa lau watan. ");
INSERT INTO bxh24_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu waga yai ya tulubeꞌu, na dodoga boludi ya itadi be ya nuwatohatohaedi, yofede salumadi sa asiyebo ya faloholohodi. ");
INSERT INTO bxh24_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Maimailafina tau famuli watanina sa laoma lisina be tiyen, Haꞌa ya maimailafi. Amaiteꞌi hige taon laꞌi. Dodoga u duidi be ti lau luma haisa haba ainiya kalahe adi sa unedi. ");
INSERT INTO bxh24_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Alinadi ya bui iyen, Ibege ti lau. Umi kalahe adi au feledi be ti an! ");
INSERT INTO bxh24_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Alinana sa bui, tiyen, Fwalawa faligigi yo hama luwaga dumaduma moho, itete. ");
INSERT INTO bxh24_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu iyen, Gonowana, au ledima. ");
INSERT INTO bxh24_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Dodoga ya falibadi, be sa taꞌai hawahawa hewadi yai. Habahim fwalawa faligigi yo hama luwaga ya abidi. Ya itaꞌita hasa galewa, na ena lautoꞌi Yaubada ya felen. Fwalawa wa ya ifidi; tau famuli watanina ya feledi be dodoga sa feledi. ");
INSERT INTO bxh24_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mahudoꞌidi sa kalahe be–, bogadi sa yahayaha. Habahim, taꞌifiꞌifidi sa antoledi, ana hewahewali sa tano gogoidi be noho 12 sa famohafudi. ");
INSERT INTO bxh24_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tatau oulina sa kalahe mate 5,000, wawahin yo wawaya mate hige ti fatili esegahidi. ");
INSERT INTO bxh24_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sa kalahe mulina yai, Yesu ana hewali ya dalu beleleidi be sa awa waga yai na sa dohe bwaꞌi hoꞌowa tefana. Mulidi yai dodoga ya duidi be sa laulau. ");
INSERT INTO bxh24_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Sa failaulau habahim, ibona ya finahe hasa tuꞌa be ya lauꞌuꞌula. Maimailafina mate, Yesu ibona amainiya. ");
INSERT INTO bxh24_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Maihalana yai, mate, waga haꞌa hoꞌowa atipuna yai. Bagodu ya lubilubi faꞌeo, paꞌana hwayahwayau, nuwanuwadi yai ya towama. ");
INSERT INTO bxh24_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Maihala doha 3 o 6 kiloki atipudi yai, Yesu ya laoma ana hewahewali lisidi hoꞌowa hewana yai. ");
INSERT INTO bxh24_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Sa ita ya laolaoma hoꞌowa hewana yai be sa ꞌwasabu. Edi nuwatuhu bena haga onaꞌonaha yofede sa ꞌwalaꞌwalawui. ");
INSERT INTO bxh24_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesu ya libalau lisidi, iyen, Au nuwa adidili! Yau! Tabu au ꞌwasabu. ");
INSERT INTO bxh24_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Yofede, alinana Pita ya bui, iyen, Guyau, yena moꞌisa um, u liba, be ya laowa lisim ai gabogabo hewana. ");
INSERT INTO bxh24_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Pita alinana, Yesu ya bui iyen, U laoma! Yofede, Pita, waga yai ya kalamahano be gabogabo hewana yai ya lau Yesu lisina. ");
INSERT INTO bxh24_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Hwayahwayau laꞌilaꞌi ya laoma amnana ya atahi, be ya ꞌwasabu, yofede ya buluhidi gabogabo ganahewana, na ya yogalau, iyen, Guyau, u saguhigu! ");
INSERT INTO bxh24_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yofede, Yesu ya tiꞌe lau, be Pita ya tohai na iyen, Em kawawananaha haga i kiu! Paꞌana somo be wa nuwa luwaluwaga? ");
INSERT INTO bxh24_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tataudi luwaga sa awalau waga yai, habahim ya daumwali. ");
INSERT INTO bxh24_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tau famuli watanina haisa waga yai, Yesu sa fadebasae, na tiyen, Wananaha, um Yaubada Natuna. ");
INSERT INTO bxh24_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Fuyana waga yai sa dohe, Genesaleta Nuꞌuna yai sa duna. ");
INSERT INTO bxh24_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Dodogadi mate, Yesu haꞌa sa sibai. Yofede liba sa fatamalidi, be tau lepalepa tefa hesa-hesa yai sa ledima Yesu lisina. ");
INSERT INTO bxh24_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Sa anꞌetai be ena leli moho bena sa abiꞌinadi. Na salumadi ena leli moho tau abiꞌinana mate, adi asiyebo sa ofi. ");
INSERT INTO bxh24_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Falesiya yo laugagayo tau lau faꞌataina Yelusalem yai sa laoma be Yesu sa fatiꞌoi tiyen, ");
INSERT INTO bxh24_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Sidohana be tau famuli watanim hiti baguna lau faꞌatadi sa utusi be nimadi hige ti kaisudi, habahim ti kalahe? ");
INSERT INTO bxh24_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu alinadi ya bui iyen, Paꞌana somo Yaubada ena laugagayo ami ꞌwaiyoꞌoen, na iyabomiu emi lau faꞌata ami lau watan? ");
INSERT INTO bxh24_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yaubada alinana iyen, <<Tinam yo tamam bena wa faꞌatitiyedi,>> yo <<sai tinam e tamam ya liba faheyayadi mate, bena ami tala funuhi.>> ");
INSERT INTO bxh24_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Inmoho, ami lau faꞌata mate, yena dodoga somo lisidi yai bena sa fapaisowadi be tamadi o tinadi sa saguhidi, na tiyen <<Ite Yaubada enehena.>> ");
INSERT INTO bxh24_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Na ami ulutubu edi laugagayo debana yai auwen, <<Tabu tamamiu yo tinamiu au faꞌatitiyedi, be abiꞌabi te lisina yai, Yaubada ena laugagayo ami ꞌwaiyoꞌoen.>> ");
INSERT INTO bxh24_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Umi dodoga bwalabwalamiu! Wananaha mate Isaiya haꞌa ya liba famahatamiu, iyebom: ");
INSERT INTO bxh24_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","<<Yaubada iyen, <Dodoga te, moꞌadi yai sa fadebasaegu moho, Na Yaluwadi mate, higeꞌe. ");
INSERT INTO bxh24_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Edi fadebasae lisigu yai hige aniyona, paꞌana dodoga edi laugagayo sa lau faꞌataedi, na bena haga yau egu laugagayo!>>> ");
INSERT INTO bxh24_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Habahim Yesu baiwa ya yoga gogonidi na sa laoma lisina be ya falibadi, iyen, Egu liba au ataꞌatahi, yo ai nuwamiu ti ota! ");
INSERT INTO bxh24_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Doga moꞌana yai somo ya luhulau mate, hige i faheyaya. Inmoho, somo moꞌana yai ya libaen mate, doga ya faheyaya. ");
INSERT INTO bxh24_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yofede, tau famuli watanina sa laoma lisina be tiyen, Wa sibai mate um em liba yai, be Falesiya nuwadi hige ti loholoho? ");
INSERT INTO bxh24_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu alinadi ya bui, iyen, Umaꞌuma somo, hige Tamagu Galewa yai i umahi mate, haba ya laꞌa fahi. ");
INSERT INTO bxh24_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tabu au mode lisidi yai! Iti tau matatoutou tau foyahidi. Be yena matatoutou laꞌi hidana ya foyahi, tataudi luwaga haba ai gali sa dobi. ");
INSERT INTO bxh24_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita ya libalau Yesu lisina iyen, Liba te aniyona haga u falibamai. ");
INSERT INTO bxh24_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu iyen, Hola ma nuwa ponoponomiu? ");
INSERT INTO bxh24_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ami siba, e higeꞌe? Somo moꞌa yai ya lidi boga ganahewana yai be ya kalamahano. ");
INSERT INTO bxh24_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Inmoho somo moꞌa yai ya kalamahano mate, nuwanuwana yai ya laoma, be ginaulina doga ya fabidahe. ");
INSERT INTO bxh24_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nuwanuwana yai nuwanuwatuhu heyaheyayadi sa laoma, be sa foyahi lawen: ya aiyunu, kelele, laulau heyaheyayadi haisa, yo angafu, lau bwalabwala, yo bwalabwala yai dodoga sa falau fatala. ");
INSERT INTO bxh24_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iti ginaulidi te, doga sa fabida. Na nimamiu hige au kaisudi na ami kalahe mate doga yaluwana hige i fabida. ");
INSERT INTO bxh24_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nuꞌuna ni Yesu ya lau afulen, na ya lau Taiya yo Sidon nuꞌudi tefadi yai. ");
INSERT INTO bxh24_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kanana waihinina nuꞌuna yai ni ya gogogo, ya laoma Yesu lebena be ya anꞌeta gadogadola lau lisina yai iyen, Deiwidi Natuna! U nuwatohatohaegu! Natugu mate, yaluwa heyaheyayadi ganahewana yai sa gogo, be amnana ya heyaya wananaha. ");
INSERT INTO bxh24_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesu hige waihin somo i faliba. Tau famuli watanina sa laoma, be tiyen, U dui be i lau! Ya laulau watanida be ya fadineida! ");
INSERT INTO bxh24_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Habahim Yesu alinadi ya bui, iyen, Yaubada ya fatamaliguma Isalaela edi sipi asiꞌasina debadi yai. ");
INSERT INTO bxh24_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Yofede, waihin wa ya laoma be ahena yai ya hobalidi, na iyen, Guyau, u saguhigu! ");
INSERT INTO bxh24_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Alinana ya bui, iyen, Wawaya adi kalahe ibege ta abidi, be ꞌwayowa ta feledi ti anidi. ");
INSERT INTO bxh24_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yesu alinana, waihin ya bui, iyen, Guyau, somo wa libaen mate, wananaha. Inmoho ꞌwayowa mate edi baꞌisa ana mapula sa beꞌulidi ena hatahata gabulana yai sa anidi. ");
INSERT INTO bxh24_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yofede, Yesu ya libalau waihin lisina iyen, Waihin, em kawawananaha ya laꞌi wananaha! Somo wa fanuha haba wa abi. Yofede, maihalana yai natuna ya loholoho. ");
INSERT INTO bxh24_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu ya aulaha boda, be ya lau Galili Hoꞌowana bwaibwaiꞌuꞌuna laꞌilaꞌina yai. Tuꞌa hesa ya finahe, be amainiya ya taꞌai. ");
INSERT INTO bxh24_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Baiwa laꞌilaꞌi sa laoma lisina, yo ahe dabidabi, matatoutou, libaliba gesa yo lepalepa haisa tau abidi sa ledima Yesu lisina, be ya faloholohodi. ");
INSERT INTO bxh24_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Dodoga sa noꞌo paꞌana: libaliba gesadi sa liba, ahe dabidabi ya faloholohodi, be sa laulau, yo matatoutou matadi sa falaladi. Yofede, Isalaela edi Yaubada sa fadebasae. ");
INSERT INTO bxh24_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu ena tau famuli wata ya yoga gogonidi, na iyen, Dodoga te E fanuwatohatohaedi, paꞌana sa laulau watanigu ee–, lahai faihona, be aho te hige adi kalahe. Hige ya fanuha bena ya dui fafuyodi ma guliyamdi, paꞌana ai edaꞌeda ibe ti guli. ");
INSERT INTO bxh24_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tau famuli watanina Yesu sa fatiꞌoi, tiyen, Ai nuꞌu pitapitalina te, ai somo haba kalahe te abi be doga boluna te fakalahe? ");
INSERT INTO bxh24_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu alinadi ya fafuyo, iyen, Fwalawa fisa lisimiu yai? Alinana sa bui, tiyen, Faligigi luwaga moho, yo hama kikiluka fisa. ");
INSERT INTO bxh24_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yofede, Yesu dodoga wa ya falibadi be sa taꞌai bigabiga. ");
INSERT INTO bxh24_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Habahim, fwalawa faligigi-luwaga yo hama fisa wa ya abidi, na Yaubada ya lautoꞌiyen. Habahim ya ifidi, be tau famuli watanina ya feledi be dodoga adi sa feledi. ");
INSERT INTO bxh24_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mahudoꞌidi sa kalahe, be bogadi sa yahayaha, habahim, Yesu tau famuli watanina kalahe antoledi sa tano bee–, noho faligigi-luwaga sa famohafudi. ");
INSERT INTO bxh24_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tatau tau kalahe mate oulina 4,000, na wawahin yo wawaya hige ti fatilidi. ");
INSERT INTO bxh24_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Habahim dodoga wa Yesu ya duidi be sa fuyo, na waga yai ya awa be sa lau Magadan Nuꞌudi. ");
INSERT INTO bxh24_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Falesiya yo Sadusi bena Yesu sa lauꞌita, yofede, sa laoma lisina, be sa fatiꞌoi bena fafaꞌilala laꞌi ya ginauli ai Galewa be sa ita. ");
INSERT INTO bxh24_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yofede, Yesu alinadi ya bui, iyen, Yena maihala ya bulu, auwen, <<Haba ya siuhwalo, paꞌana galewa ya antala sabisabi.>> ");
INSERT INTO bxh24_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na hwalahwalala auwen, <<Haba ya usa, paꞌana galewa ya faduba yo ya balelem.>> Gonowamiu haba galewa nenena yai ami anmasiyen. Inmoho, hige gonowamiu bena lahai te nenena doha somo au sibaidi! ");
INSERT INTO bxh24_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Aho lahai te dodogamiu ami heyaya yo Yaubada hige au kawawananahaꞌen! Be fafaꞌilala bena laꞌi E ginauli? Hige gonowana! Fafaꞌilala esega haba E falibamiu mate, Diyona au nuwatuhui. Habahim ya lau afuledi, na ya aulaha. ");
INSERT INTO bxh24_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tau famuli watanina mate, sa dohe gabogabo tefana yai, na nuwadi ya fui, be fwalawa hige laꞌi ti abi. ");
INSERT INTO bxh24_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu ya libalau lisidi, iyebom, Au ita komakomaꞌi! Falesiya yo Sadusi edi yisti tabu au tulufi. ");
INSERT INTO bxh24_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Amainiya hola libana ibodi sa fadosi, tiyen, Nuwana fwalawa hige laꞌi ta abi, be ya liba doha. ");
INSERT INTO bxh24_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu mate somo sa libalibaen haꞌa ya sibai, yofede, ya fatiꞌoidi, Paꞌana somo ibomiu ami oiꞌoiliba doha? Paꞌana fwalawa hige laꞌi au abi? Emi kawawananaha haga ti kiu! ");
INSERT INTO bxh24_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Haꞌa ami nuwatuhu lobahi, e higeꞌe? Hige au nuwatuhui fuyana fwalawa faligigi E ifidi, be dodoga 5,000 E feledi, sa an? Na noho fisa ami famohafudi? ");
INSERT INTO bxh24_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Yo fwalawa faligigi-luwaga dodoga 4,000 sa an? Na noho fisa ami famohafudi? ");
INSERT INTO bxh24_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Sidohana be hige au nuwatuhu lobahi, mate yau hige fwalawa libana ya fafalibamiu? Falesiya yo Sadusi edi fwalawa fafasesena tabu au fapaisowa mate libana E fafalibamiu! ");
INSERT INTO bxh24_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Habahim tau famuli watanina sa nuwatuhu lobahi mate, in hige fwalawa fafasiuna i libalibaen. Fedebom Falesiya yo Sadusi edi lau faꞌata ya libalibaen. ");
INSERT INTO bxh24_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu ya lau nuꞌu hesana Sesaliya Filipi taon laꞌilaꞌina sadaina yai. Amainiya tau famuli watanina ya falibadi, iyen, Haba dodoga tiyen, <<Doga Natuna mate sai?>> Tau famuli watanina tiyen, ");
INSERT INTO bxh24_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Haisa tiyen, <<Diyon Babasito,>> na haisa tiyen, <<Ilaidiya,>> na haisa tiyen, <<Delamaiya o peloweta haisa.>> ");
INSERT INTO bxh24_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Alinadi ya bui, iyen, Na umi haba auwen, <<Yau sai?>> ");
INSERT INTO bxh24_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pita Yesu alinana ya fafuyo, iyen, <<Um mate Keliso, Yaubada Mwahumwahulina Natuna.>> ");
INSERT INTO bxh24_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu iyen, Saimon, Diyona Natuna, Yaubada ena ita faloholoho lisim yai! Paꞌana hige doga laꞌi i fatalaham. Wananahana mate, Tamagu Galewa yai ya fataumahata lisim yai. ");
INSERT INTO bxh24_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Lisina yai E falibam, Pita: Um mate <<umeꞌehu.>> Haba umeꞌehuna ai hewana egu dubu E faꞌobiyo, be Peꞌi Edaꞌeda Hafona hesana Hadesi, ibege i sai tawatawan. ");
INSERT INTO bxh24_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Galewa Nuꞌuna soꞌesoꞌena haba E felem. Tanohi yai somo wa gudu mate, Galewa yai haba sa gudu hinaga, yo somo wa soꞌe tanohi yai, haba ai Galewa sa soꞌe hinaga. ");
INSERT INTO bxh24_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Habahim, Yesu tau famuli watanina ya laugagayoꞌedi, tabu sai ena ti liba, mate in Keliso. ");
INSERT INTO bxh24_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Lahaina yai na ya lawen, Yesu ya fatubu tau famuli watanina enehedi ya liba, iyen, Haba E lau Yelusalem, be babada, antalasam baꞌibaꞌisadi, yo laugagayo tau lau faꞌataina haba fakamkamna hesa-hesa sa ginauli ai lisigu. Yo haba sa wunuigu. Inmoho, lahai faihona yai ai mulidi haba E mwahuli fuyo. ");
INSERT INTO bxh24_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita, Yesu ya foya hudoꞌiyen, na ya libasuꞌui, iyen, Guyau, hige gonowana! Ibege somo ti ginauli ai lebem! ");
INSERT INTO bxh24_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu ya timuli bui, be Pita ya faliba, iyen, U lau hudoꞌi, um Diyabolo! Egu aba faꞌalu betibeti wa tole te, paꞌana em nuwatuhu, dodoga lisidi yai ya laoma, hige Yaubada. ");
INSERT INTO bxh24_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Habahim, Yesu ya libalau, tau famuli watanina lebedi iyen, Yena sai ya fanuha, be ya famuli watanigu, mate ena mode ti otawa. Em kolosi u bahei na u lau watanigu. ");
INSERT INTO bxh24_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Paꞌana sai ena mwahuli ya modemode'en ibege i abi fuyoi. Na sai ena mwahuli ya pei debagu yai, haba ya abi fafuyo. ");
INSERT INTO bxh24_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ibe doga sai tanohi mahudoꞌina ya abi fahudoꞌi, na ena mwahuli ya pei, haba somo ya lobahi? Higeꞌe, be higeꞌe wananaha! Hige gonowana haba somo i ginauli, be haba ena mwahuli i fafuyo. ");
INSERT INTO bxh24_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Doga Natuna haba ya laoma Tamana ena faꞌatiti laꞌilaꞌi wananahana yai yo ena anelu maꞌedi. Habahim, doga hesa-hesa ena paisowa gonogonowana yai ya famaisa watan. ");
INSERT INTO bxh24_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","E falibamiu mate, haisa maꞌeda amaiteꞌi ibege hola ti peꞌi yee–, Doga Natuna ena Basileiya yai ya laolaoma sa ita. ");
INSERT INTO bxh24_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Lahai faligigi-esega mulina yai, Yesu maꞌena Pita, Diyemsi yo hidana Diyon ya auledi, be iyabodi sa lau tuꞌa lofalofana sa finahei. ");
INSERT INTO bxh24_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Amainiya Yesu nenena ya sedi nuwanuwadi yai. Itaꞌitana doha maihala, yo ena leli sa kafukafu doha mala. ");
INSERT INTO bxh24_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yofede tau famuli watanina faihona wa Mose yo Ilaidiya sa itadi maꞌedi Yesu sa libaliba. ");
INSERT INTO bxh24_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Amainiya Pita ya libalau lisina, iyen, Baꞌisa, agu a moꞌisa na ai amaiteꞌi! Ibe wa fanuha, haba gwaꞌu faihona aiteꞌi ꞌe faꞌobiyodi, um em esega, Mose ena esega, yo Ilaidiya hinaga ena. ");
INSERT INTO bxh24_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ma libalibana, yofede, yada namanamalina ya laoma be ya fakou buluhidi, na yada ganahewana yai alina hudoꞌi ya libama lisidi, iyebom, Itete Natu Eseꞌesegagu, nuwagu tau faꞌamnana. Alinana au lau watan! ");
INSERT INTO bxh24_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Maihalana yai tau famuli watanina alina wa sa atahiyen, ꞌwasabu ya famohafudi. Yofede sa guli lidi tanohi yai. ");
INSERT INTO bxh24_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu ya fuyoma lisidi be ya abiꞌinadi, na iyen, Au mwaito! Tabu au ꞌwasabu! ");
INSERT INTO bxh24_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Sa tamahiti mate hige sai hesa ti ita, Yesu ibona moho sa ita. ");
INSERT INTO bxh24_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tuꞌa yai sa leta fuyo lidi, na Yesu ya lau biliyedi, iyen, Somo aho ami itadi tabu au fatala libalibaedi ana sigana Doga Natuna peꞌi yai ya mwahuli fuyo. ");
INSERT INTO bxh24_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Habahim, tau famuli watanina Yesu sa fatiꞌoi, Sidohana be laugagayo tau lau faꞌataena sa libaen mate, bena Ilaidiya haba ya bwaꞌima? ");
INSERT INTO bxh24_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu alinadi ya bui, iyen, Mate, wananaha, Ilaidiya haba ya bwaꞌima, be ginauli mahudoꞌina ya nonohai. ");
INSERT INTO bxh24_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Inmoho, E falibamiu mate, Ilaidiya haꞌa ya laoma, na dodoga hige ti ita lobahi, be edi fanufanuha mahudoꞌina haꞌa lisina yai sa ginaulidi. Laulauna eseꞌesegana yai haba ai nimadi Doga Natuna sa fakamkamna. ");
INSERT INTO bxh24_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yofede, tau famuli watanina nuwadi yai ya taumahata mate, Diyon Babasito fede, ya libalibaen. ");
INSERT INTO bxh24_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sa fuyoma dodoga boludi lisidi yai, na taumoho hesa ya laoma Yesu lisina, be ya tulibono nuwanuwana yai, ");
INSERT INTO bxh24_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","na iyen, Guyau, natugu u nuwatohatohaen! In mate ya peꞌipeꞌi bubu, yo ana asiyebona ya laꞌilaꞌi, be fuya ouꞌouli ai oyagi alaꞌaladi ya guli lidi, o ai hoꞌowa ganahewadi. ");
INSERT INTO bxh24_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","E lawen, tau famuli watanim lisidi, inmoho, hige gonowadi ti faloholoho. ");
INSERT INTO bxh24_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu alinana ya bui, iyen, Dodogamiu te hige au kawawananaha yo haga au nuwa poꞌi! Lofana somo bena haba ai lisimiu E gogo?! Yo haba E faꞌadidilimiu, ma fisa?! Gwamana au leyama lisigu! ");
INSERT INTO bxh24_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu, yaluwa heyaheyayana ya liba suꞌui, yofede, gwama ya kalamahano afulen. Lahaina yai ya loholoho. ");
INSERT INTO bxh24_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Muli yai, tau famuli watanina sa laoma Yesu lebena, be sa fatiꞌo simosimo, tiyen, Paꞌana somo be ai hige gonowamai yaluwa heyaheyayana ni ai liba afulen? ");
INSERT INTO bxh24_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu alinadi ya bui, iyen, Paꞌana emi kawawananaha hige ti laꞌi. E falibamiu mate, ibe emi kawawananaha laꞌina doha saihala dimdim tumana, gonowana tuꞌa te ami faliba, auwen, <<Aiteꞌi u auꞌaulaha be u lau neꞌi!>> Haba ya lau. Gonowana abiꞌabi hudoꞌi-hudoꞌi ami ginaulidi! ");
INSERT INTO bxh24_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Ginauli doha ite, uꞌula yo anhudi yai moho te dui afuledi.) ");
INSERT INTO bxh24_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tau famuli watanina mahudoꞌidi sa faꞌoigogo esega, Galili yai, na Yesu ya falibadi, iyen, Doga Natuna haba sa liba afulen ana waiyunu lisidi yai, ");
INSERT INTO bxh24_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","be haba sa wunui; na lahai faihona ai mulidi, haba ya mwahuli fuyo. Yofede, tau famuli watanina nuwadi sa heyaya. ");
INSERT INTO bxh24_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Fuyana Yesu yo tau famuli watanina sa mahanoma Kapanayum nuꞌuna yai, Dubu Tabuna ainauyana tau tanoina sa laoma Pita lisina be sa fatiꞌoi, tiyen, Emi Baꞌisa Dubu ainauyana ya tole? ");
INSERT INTO bxh24_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Alinadi Pita ya bui, iyen, Ii, ainauya ya toletolei. Pita ya luhulau luma ganahewana yai. Yesu ya liba bwaꞌibwaꞌi, iyen, Saimon, em nuwatuhu somo? Nu'u baba'isadi haba salumadi ai lisidi takesi sa tano? Edi dodoga ai lisidi e taꞌowawa? ");
INSERT INTO bxh24_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Alinana Pita ya bui, iyen, Taꞌowawa. Yesu iyebom, Ya loholoho, inmoho itaꞌitana mate, nuꞌu ni, tau miyaina, ibege ti tole. ");
INSERT INTO bxh24_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Inmoho, tabu dodoga ta famwahudi. U lau ai hoꞌowa be em kauli u pei. Hama bwaꞌibwaꞌina wa solu, moꞌana u kam hafa haba moni hesana dinali-fati wa ita. U lawen be u feledi. Um yo yau eda takesi. ");
INSERT INTO bxh24_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Fuyana yai tau famuli watanina sa laoma Yesu lisina, be sa fatiꞌoi, tiyen, Galewa Aba Baꞌisa Nuꞌuna yai, sai ya hasai wananaha? ");
INSERT INTO bxh24_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yofede, Yesu wawaya kiukiu hesa ya yogaiyama, be nuwanuwadi yai ya faꞌobiyo, ");
INSERT INTO bxh24_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","na iyen, E faliba dudulaimiu, yena ami miya bui doha wawaya kikiꞌina mate, gonowana Galewa Basileiyana ami sola. ");
INSERT INTO bxh24_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Debana yai, sai ya fakiu fuyoi doha gwama kiukiu te mate haba ya laꞌi ai Galewa Basileiyana. ");
INSERT INTO bxh24_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yo sai hesa hesagu yai na wawaya kiukiu laꞌi ya yoga hitin, mate ya yoga hitinigu hinaga. ");
INSERT INTO bxh24_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Na yena wawaya kikiluka te, sai ya bwalafahidi, be edi kawawananaha lisigu yai ya fagogomadi, ena dudulai mate, dogana ni ai gadona umeꞌehu laꞌilaꞌi ami sofa, na ai gabogabotum ami fakapululolo. ");
INSERT INTO bxh24_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kapole, tanoꞌubu, paꞌana heyaheyaya ya laꞌi wananaha lisina yai, dodoga ya ginaulidi be sa faꞌalu betibeti! Ginaulidi doha haba sa tubu. Inmoho, sai tau ginaulina, mate heyaheyaya laꞌilaꞌi haba ya fahoina. ");
INSERT INTO bxh24_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yena nimam o ahem heyaheyaya ya ginauli mate, u ibo afulen be u pei! Ena dudulai mate, nimam esega o ahem esega ai mwahuli haba wa mwahuli. Hige i loholoho bena ahem luwaga yo nimam luwaga ti heyaya, be ti peim ai oyagi ala'alana ya lau ee–, hige ofina. ");
INSERT INTO bxh24_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na yena matam amainiya heyaheyaya ya leyama, u limofahi, be u pei! Haba matam eseꞌesega yai wa lau mwahuli hige ana siga, tabu matam luwaluwaga be ti peim ai Gehena oyagi ala'alana. ");
INSERT INTO bxh24_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Au ita komakoman, wawaya kiukiu doha itete tabu au ita lidilidiyen. Mata paꞌana haba E falibamiu: edi anelu Galewa yai mate, fuya ouꞌouli Tamagu Galewa yai, sadaina yai sa miyamiya. ");
INSERT INTO bxh24_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Doga Natuna ya laoma be safaluma sa lau asiꞌasina haba ya fofofahidi. ");
INSERT INTO bxh24_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","E faliba dudulaimiu mate, yena taumoho esega ena sipi 100, na esega ya asina, haba 99 ya lau afulen ai tu'a, na asi'asinana ya yo'oi ee–, ya lobahi. ");
INSERT INTO bxh24_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yena ya lobahi, E falibamiu, nuwana ya amna diꞌoi sipi gegena lisina yai, habahim gegege gesadi 99. ");
INSERT INTO bxh24_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Gonogonowana doha, Tamamiu Galewa yai hige i fanuha bena wawaya kikiꞌuka te, laꞌi i asina. ");
INSERT INTO bxh24_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yena hidam, heyaheyaya ya ginauli lisim yai, u lau lisina be ena heyaya u faꞌita lobahi. In be um ibomiu moho, ami fadudulai. Yena alinam ya lau watan, mate nuwana haꞌa ya faloholoho. ");
INSERT INTO bxh24_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ibe yena hige alinam i lau watan, doga esega o luwaga maꞌemiu ami lau, be haba emi pilipilina wa liba famahata dodogadi te ai lisidi, doha Buka Tabuna yai iyen. ");
INSERT INTO bxh24_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Yena ya ꞌwaiyoꞌo be hige alinadi i lau watan, habahim, dubu tanutanuwagadi au falibadi. Na yena dubu ya moꞌa peiyen, au abi'abiyen doha tau kawawananaha gesana yo takesi tau tanotano. ");
INSERT INTO bxh24_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","E faliba dudulaimiu, somo ami auꞌaui tanoꞌubu yai haba ai Galewa hinaga sa auꞌaui. Na somo wa tata tanoꞌubu yai haba ai Galewa hinaga sa tata. ");
INSERT INTO bxh24_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","E faliba fuyo'imiu hinaga mate, yena dodogami luwaga emi nuwatuhu esega be somo ami anꞌetai, haba emi nuwatuhuna tamagu Galewa yai ya ginauli, enehemiu. ");
INSERT INTO bxh24_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Paꞌana luwaga e faihona sa faꞌoigogo hesagu yai, Yau amainiya maꞌedi. ");
INSERT INTO bxh24_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Habahim Pita ya laoma be Yesu ya fatiꞌoi, iyen, Guyau, ibe hidagu laulau heyaheyayana lisigu yai ya ginauli, ma fisa haba ena heyaheyaya E nuwa afuledi? ma faligigi-luwaga ye? ");
INSERT INTO bxh24_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Alinana Yesu ya bui, iyen, Higeꞌe! Hige ma faligigi-luwaga! Ma fuya 70 x 7. ");
INSERT INTO bxh24_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Galewa Basileiyana nenena doha ite: Kin hudoꞌi ena tau paisowa sidohana ena moni edi fafapaisowadi mate maidana ena tau paisowa sa pei gogonidi. ");
INSERT INTO bxh24_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Bena haba ya ita sipoidi fatubu, taumohona hesa, ana hagahaga K10,000.00 sa leyama lisina. ");
INSERT INTO bxh24_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Dogana mate hige gonowana moni ni i famaisa. Ena baꞌisa ya liba be in, yo lahuna, yo nanatudi yo edi gogo mahudo'idi sa uneꞌune afuledi be haba adi hagahaga sa famaisa. ");
INSERT INTO bxh24_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ena tau paisowa wa ya guli lidi ahena yai, na ya anꞌeta gadogadola. Iyen, <<U nuwatalu lisigu yai! Haba agu hagahaga E famaisa!>> ");
INSERT INTO bxh24_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Baꞌisa ya ita nuwatohatohaen, yofede ana hagahaga ya tomo afuledi. ");
INSERT INTO bxh24_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Taumoho wa ya lau be falena tau paisowa ya lobahi. In ya anhagahaga hidana te lisina yai - kina fisa moho. Yofede, ya tohai be gadona ya mwakamwakai na iyen, <<Am hagahaga lisigu yai u maisadi!>> ");
INSERT INTO bxh24_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Falena tau paisowa ya guli lidi, na ya anꞌetai, iyen, <<U nuwatalu lisigu yai! Haba E famaisa fuyoꞌidi!>> ");
INSERT INTO bxh24_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Na hige i fanuha. Hidana moho ya lawen, ya falau deli yee–, bena ya famaisadi, habahim sa soꞌefahi. ");
INSERT INTO bxh24_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Falena tau paisowa haisa sa ita, be nuwadi sa heyaya, yofede, sa lau, ginauli mahudoꞌina edi Baꞌisa ena sa liba. ");
INSERT INTO bxh24_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Yofede, baꞌisa wa na tau paisowa ya yogai lawen lisina be iyen, <<Em laulau haꞌa ti heyaya! Am hagahaga lisigu yai E tomo afuledi, paꞌana wa anꞌetaigu, be doha E ginauli. ");
INSERT INTO bxh24_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Um hinaga bena falem tau paisowa em abiꞌabina doha, gonogonowana doha somo lisim yai E ginauli.>> ");
INSERT INTO bxh24_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Baꞌisa, manana ya bala wananaha. Ena tau paisowa ya panisi deli yai ee–, ana siga ana hagahaga mahudoꞌidi ya famaisa ofinidi. ");
INSERT INTO bxh24_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Habahim, Yesu ena liba ofiꞌofina ya libaen, iyen, Yena nuwamiu ganahewana yai, hidamiu ena heyaheyaya hige au nuwa afulen, haba Tamagu Galewa yai ai lisimiu ya ginauli doha. ");
INSERT INTO bxh24_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Libadi te Yesu ya libaedi, muli yai, Galili ya lau afulen, na ya lau Diudeya Nuꞌuna, Diyodan Hoꞌowana tefana. ");
INSERT INTO bxh24_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Baiwa laꞌilaꞌi sa famuli watan, be adi asiyebo amainiya ya faloholohodi. ");
INSERT INTO bxh24_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Falesiya dodogadi haisa sa laoma be sa fatiꞌoi bena haba sidohana na sa fasai buluhi, Ema laugagayo ya libaen, gonowana taumoho lahuna ya tausohoꞌen, yena maꞌena mata paꞌa? ");
INSERT INTO bxh24_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu alinadi ya bui, iyen, Fatufatubu yai, Yaubada taumoho yo waihin ya ginaulidi mate, Buka Tabuna yai ya libaen, ami fatili e higeꞌe? ");
INSERT INTO bxh24_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yo Yaubada iyen, <<Mata paꞌa te debana yai, taumoho haba tamana yo tinana ya lau afuledi na ma lahuna sa famala iti esega. ");
INSERT INTO bxh24_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","<<Lisina yai, iti hige luwaga, esega moho. Somo Yaubada haꞌa ya falau esegahi mate doga ibege i fatausohodi. ");
INSERT INTO bxh24_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Falesiya sa fatiꞌo boda, tiyen, Paꞌana somo be, Mose ena laugagayo ya libaen, iyen, <<Tausoho yalina haba sa uli be waihin sa felen, ai mulina haba ya tausohoꞌen be ya duiyen?>> ");
INSERT INTO bxh24_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu alinadi ya bui, iyen, Mose ya laliyen be lahum haba wa tausohoꞌen, paꞌana nuwamiu sa poꞌi. Inmoho, fatufatubu yai hige doha. ");
INSERT INTO bxh24_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","E falibamiu, mate ibe waihin ena laulau sa dudulai yo waihinina hige i kelele, na taumoho wa lahuna ya tausohoꞌen, be waihin hesa ya fai, taumoho wa ya kelele. ");
INSERT INTO bxh24_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tau famuli watanina tiyen, Ibe taumoho yo waihin edi nuwanuwatuhu doha, loholohona tabu ti nahi! ");
INSERT INTO bxh24_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Alinadi Yesu ya bui, iyen, Doga mahudoꞌina ibege liba te ti lau watan. Salumadi liba te tau nuwatuhu lobahina haba sa lau watan. ");
INSERT INTO bxh24_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mata paꞌa hudoꞌi-hudoꞌi debadi yai be dodoga haisa hige ti nahi mate doha ite: Haisa, iti sa yosidima doha, ibege ti nahi; haisa dodoga sa nigohidi be hige gonowana ti fanatu; na haisa mate, Galewa Basileiya Nuꞌuna debana yai, ibege ti nahi. Liba te, sai gonowana ya abi, mate i abi. ");
INSERT INTO bxh24_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Dodoga haisa wawaya sa ledima Yesu lisina, be haba nimana ya toledi ai hewadi, yo edi ya lauꞌuꞌula. Inmoho, tau famuli watanina, dodogadi sa sagasagaliyedi. ");
INSERT INTO bxh24_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu iyen, Ti otawa! Ti laoma lisigu! Tabu au guduguduidi, paꞌana Galewa Basileiyana mate iti enehedi. ");
INSERT INTO bxh24_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nimana yai ya abiꞌinadi, habahim nuꞌu ni ya lau afulen. ");
INSERT INTO bxh24_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Fuya maꞌesega, hewali hesa ya laoma Yesu lisina, be iyen, Tanuwaga, laulau loholohona somo haba E ginauli, be mwahuli hige sigana ainiya E mahano? ");
INSERT INTO bxh24_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Alinana Yesu ya bui, iyen, Paꞌana somo, somo ya loholoho fatiꞌona wa fatiꞌogu? Esega moho, In Yaubada mate ya loholoho. Yena wa fanuha bena mwahuli otaꞌotafahina wa abi, mate ena laugagayo u awaꞌabiyedi. ");
INSERT INTO bxh24_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Hewali wa ya fatiꞌo boda iyen, Laugagayo tausom? Alinana Yesu ya fafuyo iyen, Tatau yo wawahin mai nahinahi tabu au eno bili maidamiu mai nahinahi haisa. Tabu u aiyunu; tabu u angafu; tabu hidam u fagilu napai; ");
INSERT INTO bxh24_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","tamam yo tinam bena wa faꞌatitiyedi; yo falem tau miya u gadosisiyedi, doha um wa gadosisiyem. ");
INSERT INTO bxh24_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Hewali wa iyen, Mahudoꞌidi E miyamiyaꞌedi. Na somo hesa hola hige ya ginauli? ");
INSERT INTO bxh24_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu ya libalau lisina, iyen, Yena wa fanuha bena wa loholoho wananaha, u lau be em ginauli mahudoꞌina u uneꞌune afuledi, na maisadi tau gogo gesagesa u feledi, na u laoma, u famuli watanigu! Ai Galewa, habahim wa fagogo. ");
INSERT INTO bxh24_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hewali ya atahi, yofede, ma nuwa heyayana ya aulaha, paꞌana in ya fagogo wananaha. ");
INSERT INTO bxh24_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesu ya libalau tau famuli watanina lisidi, iyen, E falibamiu, tau fagogo dodogadi bena Yaubada sa famuli watan mate lisidi yai ya pili. ");
INSERT INTO bxh24_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Libana eseꞌesegana haba E falau boda mate, kamela gonowana diu ai galina ya luhulau. Na tau fagogo Yaubada ena Basileiya luhuluhu launa lisidi yai pilipili. ");
INSERT INTO bxh24_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tau famuli watanina sa atahi, yofede, sa noꞌo. Sa fatiꞌo, tiyen, Fede! Sai haba ya mwahuli? ");
INSERT INTO bxh24_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu ya itaꞌita lau lisidi, na alinadi ya bui, iyen, Dodoga hige gonowadi. Na Yaubada gonowana ginauli mahudoꞌidi ya ginaulidi. ");
INSERT INTO bxh24_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Habahim, Pita ya fatiꞌo, iyen, Ai ginauli mahudoꞌina haꞌa ꞌe lau afulen, na ꞌe famuli watanim. Somo haba ꞌe abi? ");
INSERT INTO bxh24_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu ya falibadi, iyen, E liba dudulai mate, fuyana yai ginauli sa fafalifalihudi, yo Doga Natuna ena aba taꞌai namanamalina yai ya taꞌai, be ginauli mahudoꞌina ya fakasa, haba umi, tau famuli watanigu ouꞌoulimiu safuhudohudoꞌi luwaga, haba ai aba taꞌai 12 ami taꞌai hinaga. Be Sulu Isalaela safuhudohudoꞌi luwaga ami fakasadi. ");
INSERT INTO bxh24_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Sai laꞌi ena luma, haidana, lofuna, tamana, tinana, nanatuna o tanohi ya lau afuledi, yau debagu yai mate haba ya fagogo wananaha, yo mwahuli hige sigana haba ya abi. ");
INSERT INTO bxh24_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Inmoho, saluma iti tau bwaꞌi mate, haba sa mulita, na haisa sa mulita, haba sa bwaꞌi ");
INSERT INTO bxh24_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Galewa Basileiyana itaꞌitana doha ite. Fuya maꞌesega, doga hesa ma hwalahwalalana ya aulaha, be ya lau dodoga ya fatalawaudi, be haba ena ai waen gabuna sa paisowa. ");
INSERT INTO bxh24_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ya falibadi mate lahai esega haba ya famaisadi, kina esega, na ya fatamalidi, be ena waen gabuna yai sa paisowa. ");
INSERT INTO bxh24_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","9 koloki ya lau mate haisa maketi yai ya itadi, sa fafamiya gaibu. ");
INSERT INTO bxh24_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ya falibadi iyen, <<Umi hinaga au lau egu ai waen gabuna au paisowa. Haba maisa dudulaina E felemiu.>> ");
INSERT INTO bxh24_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Yofede, sa lau sa paisowa. Lahai laꞌi yo maimailafina yai, laulauna eseꞌesegana ya ginauli. ");
INSERT INTO bxh24_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Maimailafi doha 5 koloki ya lau maketi yai, dodoga haisa hinaga ya itadi, sa miyamiya gaibu. Yofede, ya fatiꞌoidi, iyen, <<Paꞌana somo be emi fuya ami pei gaibu, na hige somo au ginauli?>> ");
INSERT INTO bxh24_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Alinana sa bui, tiyen, <<Hige sai laꞌi i fatalawaumai.>> Ya falibadi, iyen, <<Au lau egu ai gabu, au paisowa hinaga.>> ");
INSERT INTO bxh24_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Maimailafina, habahim gabu tanuwagana ena tau paisowa edi baꞌisa ya faliba, iyen, <<Tau paisowa u yogaidima! Tau paisowa mumulita, maisadi u fele bwaꞌiyedi; na tau paisowa bwaꞌi, maisadi u fele mulitaidi.>> ");
INSERT INTO bxh24_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Maimailafi yai tau paisowa fatubu maisadi K1.00 sa abidi. ");
INSERT INTO bxh24_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Na salumadi maihala dudulaina yai sa paisowa be–, ya mailafi, edi nuwatuhu haba maisa katupwanalina sa abi. Inmoho, iti tau paisowa bwaꞌi yo mailafi yai tau fatubu, mate mahudoꞌidi maisadi K1.00. ");
INSERT INTO bxh24_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Maisadi sa abidi, mulina yai gabu tanuwagana sa fatalapiliyen, tiyen, ");
INSERT INTO bxh24_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","<<Tau paisowa wa abi mulitaidi sa paisowa awa esega moho, na maisadi wa feledi mate doha ai maisamai. Inmoho ai mate ꞌe pewalosimai yo maihala hige i palemai.>> ");
INSERT INTO bxh24_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Hidadi hesa alinana gabu tanuwagana ya bui iyen, <<Hidagu, hige ya bwalaim. Haꞌa E falibam mate K1.00 yai haba E famaisam be wa tauꞌulu.>> ");
INSERT INTO bxh24_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","<<Maisam moho u abi na u lau em luma. Yau egu fanuha yai be tau bwaꞌi yo tau mulita maisamiu gonogonowadi. ");
INSERT INTO bxh24_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yau egu moni, na paꞌana somo be tabu ibogu egu nuwatuhu ya lau watan? Nuwana u nuwa eleꞌela paꞌana E famaisa komokomaim?>> ");
INSERT INTO bxh24_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Habahim, Yesu ena liba ofiꞌofina, iyen, Mulimulitadi haba sa bwaꞌi, na bwaꞌibwaꞌidi haba sa mulita. ");
INSERT INTO bxh24_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu ya lau Yelusalem ana halulu, na ana hewahewali 12, ya foya hudoꞌiyedi be ya falibadi, iyebom, ");
INSERT INTO bxh24_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Te hasahasai Yelusalem, haba Doga Natuna ana sa wewe tau antalasam babaꞌisadi yo laugagayo tau lau faꞌataina ai lisidi be sa wunui. ");
INSERT INTO bxh24_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Haba taꞌowawa sa feledi be sa lau faliuhwaꞌen, sa talai, yo sa tutu fapatu. Inmoho, lahai faihona ai mulidi, haba Yaubada ya famwahuli fuyo. ");
INSERT INTO bxh24_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Habahim, Sebedi lahuna ma nanatuna luwaga sa laoma Yesu lisina, be ya tulu bono, sadaina yai, na ya anꞌeta lau Yesu lisina. ");
INSERT INTO bxh24_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Alinana Yesu ya fafuyo iyen, Somo wa fanuha? Waihin iyen, Yena wa famala Baꞌisa mate nanatugu luwaga te, edi aba taꞌai u feledi, hesa ai sibam na hesa ai seulim. ");
INSERT INTO bxh24_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu iyen, Somo wa fatifatiꞌoi, hige u sibai. Sebedi nanatuna luwaga wa Yesu ya falibadi, iyen, Gonowamiu haba egu kamkamna te ami sigufi saguhigu? Alinana sa fafuyo, tiyen, Ai gonowamai. ");
INSERT INTO bxh24_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu ya falibadi iyen, Gonowamiu haba egu kamkamna ami sigufi saguhigu. Inmoho, yau hige egu dudulai, bena haba ai sibagu yo ai seuligu au taꞌai. Salumadi edi aba taꞌai Tamagu ya abi nonohaidi, mate iti logedidi haba ainiya sa taꞌai. ");
INSERT INTO bxh24_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tau famuli watanina safuhudohudoꞌi haisa sa atahi, be, Sebedi nanatuna luwaga sa manabalaꞌedi. ");
INSERT INTO bxh24_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yofede, Yesu mahudoꞌidi ya yoga gogonidi, na ya falibadi, iyen, Ami sibai mate, taꞌowawa tau foyahidi gigibwali lisidi yai, be edi dodoga sa laulau beleleidi. Yo edi babaꞌisa edi gigibwali sa fapaisowa be edi dodoga sa dalu beleleidi. ");
INSERT INTO bxh24_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Na umi, tabu emi nuwatuhu doha. Ibe umi esega sai wa fanuha bena wa fadoga laꞌilaꞌim mate, um bena dodoga edi wa paisowa; ");
INSERT INTO bxh24_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","yo yena sai bena in ya eda bwaꞌiyemiu, bena emi fayofayo tau abina. ");
INSERT INTO bxh24_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Doha, Doga Natuna ya laoma tanohi yai, hige bena dodoga ena ti paisowa. Higeꞌe, In bena dodoga edi ya paisowa yo ena mwahuli ya pei be dodoga ouꞌouli ya une fafuyodi. ");
INSERT INTO bxh24_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu yo tau watanina bena Diyeliko Nuꞌuna haba sa lau afulen, na dodoga baiwadi sa famuli watanidi. ");
INSERT INTO bxh24_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tau matatoutoudi luwaga mate, edaꞌeda sadaina yai sa taꞌataꞌai, sa atahiyen mate, Yesu haba ya laoma ya lau. Yofede, sa yogayoga tiyen, Deiwidi Natuna! U nuwatohatohaemai! ");
INSERT INTO bxh24_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Dodoga baiwadi wa, tau matatoutou luwaga sa sagasagaliyedi tiyen, Au famakano! Inmoho, hige edi liba ti lau watan. Sa yoga laꞌi boda tiyen, Deiwidi Natuna! U nuwatohatohaemai! ");
INSERT INTO bxh24_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu ya obiyo tohai na ya yogaidi, be ya fatiꞌoidi iyen, Emi fanuha somo lisigu yai bena E ginauli? ");
INSERT INTO bxh24_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Alinana sa bui tiyen, Guyau, ꞌe fanuha bena matamai wa faloholohodi! ");
INSERT INTO bxh24_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu ya ita nuwatohatohaedi, be ya abilau matadi yai. Hige walolona, matadi sa falaladi yofede sa famuli watan. ");
INSERT INTO bxh24_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu maꞌana hewahewali Yelusalem nuꞌuna sa hanahanaui, sa laoma taon kiukiu hesa hesana Betifegi, Oliwe Uduhulina yai. Amainiya Yesu ana hewali luwaga ya dui bwaꞌiyedi, ");
INSERT INTO bxh24_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","na ya fatalahadi iyen Au lau nuꞌu hesa matamiu yai, amainiya ni, haba donki hesa ma natuna ami lobahidi. Donkidi au tatadi be au ledima ai lebegu, ");
INSERT INTO bxh24_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","na yena sai somo ya libaen, au faliba auwen, <<Baꞌisa ya fanuhadi,>> na maꞌesega haba ya fatamalidi. ");
INSERT INTO bxh24_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Peloweta dogana ena liba fasunuma mate ahoꞌite ya fawananaha iyen, ");
INSERT INTO bxh24_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Saiyon natuna tineꞌeu au faliba, auwen, <<Em kin ya laolaoma lisim hola u ita, Doga nuwa lidilidina, ya awa donki yai, yo donki gubugubufwauna hewana yai.>> ");
INSERT INTO bxh24_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yofede, ana hewali luwaga Yesu somo ya fatalahadi mate sa ginauli watan. ");
INSERT INTO bxh24_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Be donki ma natuna gubugubufwauna sa ledima, yo edi leli sa hesedi dagiladi yai na Yesu leli hewadi yai ni ya taꞌai. ");
INSERT INTO bxh24_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Dodoga boludi adi leli ginaulidi sa hesedi edaꞌeda yai, na haisa oyagi lagadi sa talafahidi be sa hesedi edaꞌeda yai hinaga. ");
INSERT INTO bxh24_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Baiwa sa bwaꞌi yo sa mulita sa yogayoga, tiyen, Hosana! Um Deiwidi Natuna! Um, Yaubada hesana yai wa laoma, Sai Guyau hesana yai ya laoma, Guyau haba ya faloholoho! Hosana! Hewa wananaha yai. ");
INSERT INTO bxh24_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Lahaina yai Yesu ya mahano lau Yelusalem yai, dodoga mahudoꞌidi Duhu Balabalamumu yai mate sa tauhiti be tiyen, Sai itete? ");
INSERT INTO bxh24_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Yofede baiwa tiyen, Itete mate Yesu Nasaleta edi peloweta, Galili yai ya laoma. ");
INSERT INTO bxh24_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu ya lau edi Antalasam Lumana Laꞌilaꞌi ganana ganahewana yai, be dobidobina yai tau uneꞌune mahudoꞌidi amainiya ya lau weꞌaidi. Loma edi moni tau lau senisi be Diusi edi moni haba sa feledi, edi hatahata ya anbuinidi, yo salumadi ataiꞌa doha waliliya sa uneꞌuneꞌedi, edi aba taꞌai ya buidi hinaga. ");
INSERT INTO bxh24_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Na ya falibadi iyen, Buka Tabuna yai sa uli mate Yaubada iyen, <<Egu Dubu Tabuna mate hesana Aba Laulauꞌuꞌula Lumana.>> Inmoho umi mate ami ginauli doha tau angafu edi aba alasimo. ");
INSERT INTO bxh24_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yofede, matatoutou yo tau dabidabi sa laoma lisina Dubu Tabuna yai; be ya faloholohodi. ");
INSERT INTO bxh24_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Inmoho maihalana yai antalasam babaꞌisadi yo laugagayo tau lau faꞌataendi ginauli loloho Yesu ya ginaulidi sa itadi, yo wawaya sa yogayoga Dubu Tabuna dobidobina yai tiyen, Hosana, um Deiwidi Natuna. Be sa manabala Yesu lisina yai. ");
INSERT INTO bxh24_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Sa fatiꞌoi tiyen, Wawaya sa libaliba ni wa atahi lobahidi? Yesu iyen, I, nuwana Uliꞌuli Tabuna hige au fatili mate? <<Wawaya nom haꞌa sa dabu, yo hola ma nomnomdi haꞌa ami fatalahadi be, moꞌadi yai Yaubada sa fafadebasae.>> ");
INSERT INTO bxh24_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Habahim ya lau afuledi, na ya lau Betani duhu balabalamumuna ganamulina be maihonana amainiya ya eno. ");
INSERT INTO bxh24_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ma hwalahwalalana Yesu ya fuyo Yelusalem, na ya guliyam. ");
INSERT INTO bxh24_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Oyagi kuhou ya ita edaꞌeda sadaina yai. Yofede ya lau be ya ita, na hige i fuwa. Luguna moho. Ya libalau oyagi wa lisina, iyen, Ibege u fuwa boda! Yofede, kuhou wa ya hohoya be ya peꞌi. ");
INSERT INTO bxh24_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tau famuli watanina sa ita, be sa noꞌo, na tiyen, Sidohana be oyagi kuhou te ya hohoya be, ya peꞌi feufeula? ");
INSERT INTO bxh24_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu alinadi ya bui iyen, E falibamiu, yena ami kawawananaha yo tabu au nuwa luwaluwaga, gonowana haba ami ginauli doha somo oyagi te lisina yai E ginauli. Yo hige oyagi te iyabona, gonowana haba hinaga ami libalau tuꞌa te lisina, auwen, <<U aulaha, be u lau ai gabogabo u peim.>> Haba emi liba ya lau watan. ");
INSERT INTO bxh24_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yena ami kawawananaha, lauꞌuꞌula yai somo ami anꞌetai, haba ami abi. ");
INSERT INTO bxh24_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu ya luhulau Dubu Tabuna dobidobina yai be, ya laulau faꞌata. Yofede, Tau Antalasam Baꞌibaꞌisadi yo babada sa laoma lisina, be sa fatiꞌo lau lisina, tiyen, Dudulai somo wa fapaisowa be laulau te wa ginaulidi? Yo sai dudulai ya felem? ");
INSERT INTO bxh24_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Alinadi Yesu ya bui iyen, Egu fatiꞌo esega haba E fatiꞌoimiu. Yena egu bui ami felegu, mate haba dudulai somo debana yai be laulau te E ginaulidi, emi E liba. ");
INSERT INTO bxh24_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Diyon ena babasito Galewa yai ya laoma, e dodoga lisidi yai? Ibodi hola sa lau fadosi, be tiyen, Yena tawa, <<Galewa yai,>> haba ya fatiꞌoida, iyen, <<Paꞌana somo be Diyon hige au kawawananahaꞌen?>> ");
INSERT INTO bxh24_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Inmoho, ibe tawa, <<Dodoga lisidi yai.>> Mate bena te ita komakoman dodoga lisidi, paꞌana iti mahudoꞌidi edi nuwatuhu mate Diyon, in peloweta. ");
INSERT INTO bxh24_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yofede, Yesu alinana sa bui, tiyen, Hige ai sibai. Yesu iyen, Yau hinaga laulau te E ginaulidi gigibwalina somo yai E abi ibege ya falibamiu. ");
INSERT INTO bxh24_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Haga heyaheyason te au fadosi? Taumoho hudoꞌi nanatuna luwaga. Ya lau tau tuwaha lisina, be ya faliba iyen, <<Natugu, doꞌata u lau ai waen gabuna u paisowa.>> ");
INSERT INTO bxh24_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Natuna ya kaikulahai, iyen, <<E ꞌwaiyoꞌo!>> Muli yai, nuwana ya bui, be ya lau. ");
INSERT INTO bxh24_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Habahim, tamadi ya lau natuna hesa lisina, be libana gonogonowana ya faliba be tau mulita iyen, <<I, tamagu, haba E lau.>> Inmoho, hige i lau. ");
INSERT INTO bxh24_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Tataudi luwaga tausomo tamadi ena nuwatuhu ya lau watan? Alinana sa fafuyo, tiyen, <<Bwaꞌibwaꞌina.>> Yesu ya falibadi iyen, E falibamiu mate, takesi tau tano yo wawahin matamata heyayadi haba Yaubada ena Aba Baꞌisa sa luhu sola, habahim umi. ");
INSERT INTO bxh24_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Diyon ya laoma lisimiu, be dudulai edaꞌedana bena ya faꞌitamiu, inmoho, hige au kawawananaha, na takesi tau tano yo wawahin matamata heyayadi sa kawawananahaꞌen. Yo hinaga ami ita mulina yai, hige au nuwabui yo hige au kawawananahaꞌen. ");
INSERT INTO bxh24_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu iyen, Hola au ataꞌatahi na heyaheyason hesa emi ya dede. Fuya maꞌesega, tanohi tanuwagana waen gabuna ya umahi, ya gana fataꞌiꞌili, waen aba folofolona ya sala, na habahim aba itaꞌita wata lumana ya faꞌobiyo. Muliyai waen tau paisowadi haisa, nimadi yai ya toledi, be waen gabuna sa ita watan, na ya lau ya lauwasi, nuꞌu hesa yai. ");
INSERT INTO bxh24_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Waen wa uludi fuya losina yai, ena paisowa tau abidi ya duidi be bena ena tefana sa abiyama. ");
INSERT INTO bxh24_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Waen tau paisowaina, gabu tanuwaga wa ena tau paisowa sa tohaidi: hesa sa pidili, hesa sa tala funuhi na, hesa sa lau umeꞌehui. ");
INSERT INTO bxh24_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Fuya hesa haisa hinaga ya duidi, matabahim begadi sa ouli, hige doha bwaꞌibwaꞌina. Inmoho laulauna gonogonowana, waen tau paisowaina mate fayofayo tau abidi sa abi madaidi. ");
INSERT INTO bxh24_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ofiꞌofina mate natuna ya dui na iyen, <<Nuwana haba natugu ti faꞌatitiyen.>> ");
INSERT INTO bxh24_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tau paisowa wa natuna sa ita, sa fanuwa libaliba tiyen, <<Gabu tanuwagana natuna itete. Haba te lau funuhi, na ena gabu te tanuwagai!>> ");
INSERT INTO bxh24_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Yofede sa tohai, be sa lawen gabu ganamulina yai. Amainiya sa tala funuhi. ");
INSERT INTO bxh24_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu ya fatiꞌo lau ana hewahewali lisidi. Iyen, Yena waen gabuna tanuwagana ya laoma, somo haba ya ginauli, tau paisowa ai lebedi? ");
INSERT INTO bxh24_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tiyen, Dodoga heyaheyayadi ni haba ya tala funuhidi, na gabuna haba ya tole tau ita wata haisa nimadi yai, be haba yena losi fuyana yai maihala dudulaina yai ena tefa sa felen. ");
INSERT INTO bxh24_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu ya falibadi, iyen, Buka Tabuna somo ya libaen ami fatili o higeꞌe? Libana doha ite: <<Umeꞌehu luma tau faꞌobiyona sa ꞌwaiyoꞌoen doha ginauli gaibu mate, ya bui be dodoga edi loholoho. Itete Yaubada ya ginauli; te ita mate te noꞌonoꞌoen!>> ");
INSERT INTO bxh24_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Lisina yai E falibamiu, umi Yaubada ena dodoga inmoho haba emi dudulai ya abifahi be nu'u tausomo Yaubada sa awa'abiyen ya feledi. ");
INSERT INTO bxh24_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Doga sai ya beꞌu umeꞌehu te ai hewana, mate haba ya lubi pwaipwai. Na yena umeꞌehu te ya beꞌu, doga laꞌi ai hewana mate haba ya tapwaipwai be ya falen afusa. ");
INSERT INTO bxh24_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tau Antalasam Baꞌibaꞌisadi yo Falesiya Yesu ena heyaheyason sa atahiyedi, be sa sibai mate, iti edi laulau ya libalibaedi. ");
INSERT INTO bxh24_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Yofede, edaꞌeda sa yoꞌo bena Yesu sa au. Inmoho, dodoga sa ouli be sa ꞌwasabuwedi, paꞌana dodoga edi nuwatuhu bena haga Yesu mate, peloweta hesa. ");
INSERT INTO bxh24_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu heyaheyason ya fapaisowa bodai be dodoga ya falibadi, iyebom, ");
INSERT INTO bxh24_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Galewa Aba Baꞌisa Nuꞌuna itaꞌitana doha kin natuna ya nahi na anꞌangogo ya ginauli. ");
INSERT INTO bxh24_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ena tau paisowa ya duidi, be sa lau safaluma ya fanuhadi bena sa laoma fafanahi anꞌangogona yai sa falibadi. Inmoho, hige ti fanuha. ");
INSERT INTO bxh24_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Yofede, fayofayo tau abidi haisa hinaga ya fatalahaidi, iyen, <<Ami lau auwen <Baꞌisa ena anꞌangogo haꞌa ya nonoha; ana bulumakau tubutubudi yo gubugubufwaudi mate sa nigohidi, ginauli mahudoꞌina haꞌa ya nonoha, logena ya duimai ꞌe laoma ami halulu.>>> ");
INSERT INTO bxh24_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Inmoho, ana taumana hige ti fanuha, be edi nuwatuhu sa lau watanidi. Hesa ya lau ena gabu, hesa ya lau ena moni paisowana ya ginauli, ");
INSERT INTO bxh24_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","na haisa mate ena tau paisowa sa tohaidi, be sa tala fafaheyayadi, habahim sa wunuidi. ");
INSERT INTO bxh24_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Baꞌisa manana ya bala; yofede, ena hiyala dodogadi ya duidi, be tau tala sa wunuidi yo edi taon sa gabu golu. ");
INSERT INTO bxh24_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Muli yai, habahim, ena tau paisowa ya yogaidi, be ya falibadi iyen, <<Egu mataꞌasi haꞌa ya nonoha, agu taumana E fanuhadi mate hige edi dudulai bena faꞌatiti te sa abi. ");
INSERT INTO bxh24_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Doꞌata ite au lau be ai edaꞌeda laꞌilaꞌidi dodoga boludi ami lobahidi au falibadi be ti laoma mataꞌasi yai te.>> ");
INSERT INTO bxh24_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Yofede, ena tau paisowa ya duidi sa lau edaꞌeda yai be dodoga sa lobahidi, sa lau faliba napanapai, loholohodi yo heyaheyayadi, be sa laoma mataꞌasi baꞌuna yai be lumana sa lau fafamohafu. ");
INSERT INTO bxh24_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Baꞌisa ya lau luma ganahewana, be ana taumana ya itadi mate, esega hige fafanahi lelina i luhufi. ");
INSERT INTO bxh24_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Baꞌisa ya fatiꞌo lau doga wa lisina, iyen, <<Hidagu paꞌana somo hige fafanahi lelina u liꞌo na wa laoma amaiteꞌi?>> Taumohona hige somo i libaen. ");
INSERT INTO bxh24_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kin ena tau paisowa ya falibadi, be doga wa nimana yo ahena sa audi, na sa pei lawen kamumu yai, be amainiya sa tan yo gadigadidi sa nali didinidi. ");
INSERT INTO bxh24_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu ena liba ya falafusofa, iyen, Boludi sa yogaidi. Inmoho, fisafisadi moho haba ya fasinabodi. ");
INSERT INTO bxh24_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Falesiya sa lau, be sa oiliba, bena haba Yesu ena liba yai sa fasai buluhi. ");
INSERT INTO bxh24_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Habahim Falesiya tau famuli watanina yo Heloda ena Pele sa duidi sa lau Yesu lebena be sa fatiꞌoi, tiyen, Tanuwaga, ꞌe sibai mate wa liba dudulai yo Yaubada ena fanuha, dudulai yai wa lau faꞌataen dodoga lisidi yai. Dodoga haisa edi nuwanuwatuhu hige u modeꞌedi, paꞌana hige gonowana u ata'atahi lau sai hesa ai lisina. ");
INSERT INTO bxh24_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Lisina yai, em nuwanuwatuhu haga u falibamai? Loma edi Baꞌisa Sisa ai lisina takesi ꞌe tole ye ya otawa? ");
INSERT INTO bxh24_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu mate edi nuwanuwatuhu heyaheyayadi haꞌa ya sibai, yofede ya falibadi iyebom, Umi tau lau bwalabwala! Sidohana bena ami fasai buluhigu? ");
INSERT INTO bxh24_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Moni ami fapaisowa be takesi ami famaisa haga laꞌi au leyama be ya ita? Yofede sa leyama lisina. ");
INSERT INTO bxh24_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ya fatiꞌoidi iyen, Sai nenena yo hesana moni yai te? ");
INSERT INTO bxh24_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Alinana sa bui, tiyen, Loma edi Baꞌisa, Sisa. Yofede, Yesu ya falibadi, iyen, Yena doha, somo Baꞌisa Sisa enehena, mate au felen, na somo Yaubada ena, mate Yaubada au felen. ");
INSERT INTO bxh24_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Liba ni sa atahiyen mate sa noꞌo. Yofede sa lau afulen, be sa lau nuꞌu hesa. ");
INSERT INTO bxh24_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sadusi edi nuwatuhu mate dodoga sa peꞌi ibege ti mwahuli fuyo. Yofede lahaina eseꞌesegana yai sa laoma Yesu lisina, be sa fatiꞌoi. ");
INSERT INTO bxh24_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Tiyen, Tanuwaga, Mose ya libaen mate, yena taumoho hige natuna na ya peꞌi, hidana bena ena hwabu ya fai, be haba nanatuna mate sa famala tau peꞌi nanatuna. ");
INSERT INTO bxh24_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Waihin hesa natu faligigi-luwaga. Ganahewadi yai, tau tuwaha ya nahi, be hige natuna, na ya peꞌi. Yofede hidadi hesa edi hwabu ya fai. ");
INSERT INTO bxh24_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Inmoho, hige natuna. Laulauna gonogonowana fafafaihonana ya lau bee–, adi huhumau, mate edi hwabu sa fai, na hige nanatudi. ");
INSERT INTO bxh24_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ofiꞌofina waihin ya peꞌi. ");
INSERT INTO bxh24_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tau peꞌipeꞌi edi fuya obiyo fuyo lahaina yai, waihin ni haba sai lahuna? Paꞌana mahudoꞌidi haꞌa sa fai. ");
INSERT INTO bxh24_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Alinadi Yesu ya bui, iyebom, Emi nuwatuhu hige ti dudulai! Paꞌana Buka Tabuna yo Yaubada ena gigibwali hige au sibaidi. ");
INSERT INTO bxh24_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yena tau peꞌipeꞌi sa obiyo fuyo, iti haba doha galewa aneludi be ibege ti nahi. ");
INSERT INTO bxh24_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mwahuli fuyo pe'i yai libana Yaubada haꞌa ya falibamiu, nuwana hige au fatili?! Iyen, ");
INSERT INTO bxh24_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","<<Yau mate Abelaham, Isako yo Iyakobo edi Yaubada.>> In mate hige tau peꞌi edi Yaubada. Inmoho tau mwahumwahuli edi Yaubada. ");
INSERT INTO bxh24_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yofede, dodoga boludi sa atahiyen, na ena lau faꞌata, sa noꞌoen. ");
INSERT INTO bxh24_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Maihalana yai Yesu ya lau faꞌata sa atahi be Sadusi hige alinadi. Yofede Falesiya sa faꞌoigogo. ");
INSERT INTO bxh24_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ganahewadi yai, hidadi hesa, in laugagayo tau sibaina ya laoma be fatiꞌo yai te, bena Yesu ya lauꞌita, iyen. ");
INSERT INTO bxh24_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Tanuwaga, laugagayo tausomo ya laꞌi wananaha? ");
INSERT INTO bxh24_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ena fatiꞌo Yesu ya bui iyen, <<Em Yaubada bena wa gadosisiyen, ma nuwa ofifahim, yaluwam mahudoꞌina yo em nuwatuhu mahudoꞌina.>> ");
INSERT INTO bxh24_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Itete Laugagayo bwaꞌibwaꞌina yo laꞌilaꞌi wananaha: ");
INSERT INTO bxh24_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Fafaluwagana doha ite: <<Falem tau miya bena wa gadosisiyen gonogonowana doha um wa gadosisi fuyoim.>> ");
INSERT INTO bxh24_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mose ena laugagayo mahudoꞌina yo Peloweta edi lau faꞌata mate, laugagayo luwaga te ya laba gogonidi. ");
INSERT INTO bxh24_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Falesiya sa faꞌoigogo esega habahim, Yesu ya fatiꞌoidi, iyen, ");
INSERT INTO bxh24_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","<<Emi nuwatuhu mate, Fasinabo Dogana Keliso in sai? Yo in sai natuna?>> Alinana sa bui tiyen, In Deiwidi laulauwewena. ");
INSERT INTO bxh24_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ya falibadi iyen, Sidohana be, Yaluwa Tabuna Deiwidi ya luhufi be ya kawa Guyauwen? Paꞌana iyen, ");
INSERT INTO bxh24_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","<<GUYAU ya libama egu Guyau lisina: iyen, <Ai sibagu u taꞌai. Ana sigana am waiyunu E toledi ai ahem ubuna.>>> ");
INSERT INTO bxh24_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Yena bena Deiwidi ya kawa guyauwen, sidohana be ya kawa natuwen? ");
INSERT INTO bxh24_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Lahaina yai, na ya lawen mate hige sai laꞌi Yesu ena fatiꞌo i bui, yo hige sai hesa i fatiꞌo bodai. ");
INSERT INTO bxh24_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Habahim Yesu ya libalau tau famuli watanina yo baiwa lisidi yai, iyen, ");
INSERT INTO bxh24_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Laugagayo tau lau faꞌataena yo Falesiya mate iti Mose ena laugagayo tau libalibaena. ");
INSERT INTO bxh24_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Lisina yai umi bena somo sa libaedi ami awaꞌabiyedi yo ami lau watanidi; inmoho, tabu edi abiꞌabi au lau watanidi, mata paꞌana mate somo sa lauguguyaꞌedi mate, hige ti famuli watanidi. ");
INSERT INTO bxh24_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Dodoga mwahu sa feledi, be hige gonowana ti baheidi. Na iti hige somo ti ginaulidi be dodoga ti saguhidi haba laugagayo ti lau watanidi. ");
INSERT INTO bxh24_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ginauli mahudoꞌina sa ginauli bena sa noꞌonoꞌoꞌedi. Yo Uliꞌuli Tabudi lausoisoidi aba husaidi sa falaꞌidi, be nimadi yai yo debadi yai sa audi, yo edi leli masalusaludi sa liꞌodi. ");
INSERT INTO bxh24_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ai mataꞌasi yo aba oigogo lumadi ganahewadi yai bena aba taꞌai loloho yai sa taꞌai. ");
INSERT INTO bxh24_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ai aba maketi nuꞌudi sa fanuha bena dodoga sa lautoꞌiyedi yo dodoga bena sa kawa tanuwagaꞌedi. ");
INSERT INTO bxh24_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Umi tabu ti kawa tanuwagaꞌemiu, paꞌana umi boga esega, yo ami tanuwaga esega. ");
INSERT INTO bxh24_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Yo tabu ai tanoꞌubu sai hesa au kawa tamaꞌen, paꞌana Tamamiu esega dumaduma galewa yai. ");
INSERT INTO bxh24_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tabu sai ti kawa tanuwagaꞌem, paꞌana ami tanuwaga, esega dumaduma Keliso. ");
INSERT INTO bxh24_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ganahewamiu yai sai ya laꞌi wananaha mate, emi tau lau fayofayo. ");
INSERT INTO bxh24_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Na sai ya falaꞌi fuyoi, haba Yaubada ya fakiu, na sai ya fakiu fuyoi, haba Yaubada yo tole hitiꞌi. ");
INSERT INTO bxh24_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Kapole, umi Laugagayo tau lau faꞌataena yo Falesiya! Umi tau lau bwalabwala! Dodoga edi Basileiya edaꞌedana ami gudu. Salumadi sa anpate bena sa luhu mate edi eda'eda ami fapilipili. Umi hinaga ibege au luhu. ");
INSERT INTO bxh24_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kapole, laugagayo tanuwagadi yo Falesiya, umi tau lau bwalabwala! Miya tupitupi haba ami fahoina! Paꞌana kaikaihwabu edi luma ginaulidi ami lau fayafaya gogoidi. Yo hinaga nuwamiu maitidi mate, emi lauꞌuꞌula ami falofadi. Lisina yai maisa mwahumwahuna haba Yaubada ya felemiu. ");
INSERT INTO bxh24_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kapole! Laugagayo tau lau faꞌatadi yo Falesiya, umi tau lau bwalabwala! Heyaheyaya haba ami fahoina! Paꞌana, fote yo gabogabo ami laufidi, be bena doga hesa ami nuwa liui, yena nuwana ami abi, be kamkamna laꞌilaꞌi Gehena yai ya fahoina, habahim umi. ");
INSERT INTO bxh24_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Tau ita wata dodogamiu matamiu sa tou, kapole, heyaya haba ami fahoina! Auwen, <<Yena Dubu Tabuna hesana yai ami angwala, mate angwalana hige aniyona. Inmoho, yena sai Dubu Tabuna ana gole lisina yai ya angwala, mate angwala wananahana.>> ");
INSERT INTO bxh24_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Umi yauyaule yo matamiu sa tou! Ginauli somo ya loholoho wananaha? Gole, ye Dubu Tabuna?! Dubu Tabuna sidohana be gole ya fatabu mate, paꞌana gole ni Dubu Tabuna ganahewana yai. ");
INSERT INTO bxh24_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ami liba hinaga, auwen, <<Yena sai aba antalasam hesana yai ya angwala mate hige aniyona. Inmoho, yena ainauya somo aba antalasam hewana yai, na hesana yai ya angwala mate, angwala wananahana.>> ");
INSERT INTO bxh24_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tau matatoutou, tausomo ya laꞌi wananaha? Ainauya e aba antalasam? Ainauya! Paꞌana ainauya aba gabuna hewana yai ya otaꞌota, logena ainauyana ya fatabu. ");
INSERT INTO bxh24_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Logena be, yena aba antalasam hesana yai doga ya angwala, aba antalasam yo ainauya mahudoꞌidi hewana yai ni lisidi yai ena angwala ya ginauli. ");
INSERT INTO bxh24_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Yo sai Dubu Tabuna hesana yai ya angwala mate, Dubu Tabuna ganahewana tau miya Yaubadana hesana yai ya angwala hinaga. ");
INSERT INTO bxh24_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Yo sai Galewa hesana yai ya angwala mate, Yaubada ena aba taꞌai yo hewana yai tau taꞌai ya angwalaedi. ");
INSERT INTO bxh24_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Laugagayo tau lau faꞌataendi yo Falesiya, heyaheyaya laꞌilaꞌi haba ami fahoina, Umi tau lau bwalabwala! Emi ainauya mula panepanedi haisa: minti, anise, yo kumino, ami antole nagoꞌedi Yaubada enehena. Inmoho laugagayo laꞌilaꞌidi doha: dudulai, nuwatohatoha yo kawawananaha famuli watanidi mate, ami lau paleidi. Egoba, laugagayo fwaufwaudi yo beyabeyadi ami lau watanidi. ");
INSERT INTO bxh24_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Umi tau ita wata matatoutoudi! Digudigu haba ami fagoi lisi, na kamela haba ami dom! ");
INSERT INTO bxh24_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Laugagayo tau lau faꞌataena yo Falesiya, heyaheyaya laꞌilaꞌi haba ami fahoina, umi tau lau bwalabwala! Kaputi yo disi ganamulidi moho ami kaisudi, na ganahewadi mate anduma yo nuwa lau wata sa mohafu. ");
INSERT INTO bxh24_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Falesiya matatoutoudi! Bwaꞌibwaꞌina bena kaputi yo disi ganahewadi ami faꞌaꞌadi, haba ganamulidi hinaga sa aꞌa. ");
INSERT INTO bxh24_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Kapole! Heyaheyaya laꞌilaꞌi haba Falesiya yo laugagayo tau lau faꞌataena ami fahoinadi, umi tau lau bwalabwala! Itaꞌitamiu doha boꞌusa poipoi kafudi, itaꞌitadi sa famata anꞌan. Inmoho, ganahewadi mate tau peꞌipeꞌi siyadadi yo ginauli bidabidadi haisa hinaga. ");
INSERT INTO bxh24_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Gonogonowana doha, ganamulimiu ami fataumahatadi, dodoga lisidi yai bena haga umi ami dudulai. Inmoho, ganahewamiu mate bidahe ya mohafu. ");
INSERT INTO bxh24_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Kapole, Falesiya yo laugagayo tau lau faꞌataina, umi tau lau bwalabwala, haba ami ankamkamna! Peloweta boꞌusadi ami ginauli bodaidi yo tau dudulai boꞌusadi ami fapasadi. ");
INSERT INTO bxh24_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Habahim, auwen, <<Ibe afa wahamai edi fuya yai ai amainiya, mate ibege ai segeyahi be peloweta ai antalaidi.>> ");
INSERT INTO bxh24_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Logena, ami fataumahata fuyo'imiu, mate salumadi peloweta tau wunuidi laulauwewedi umi. ");
INSERT INTO bxh24_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Doha i laulaui, be–, afa wahamiu somo sa fatubu mate au faꞌofi. ");
INSERT INTO bxh24_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Umi weso yo weso nanatuna! Gehena oyagi alaꞌalana haba sidohana emi gebagebaina? ");
INSERT INTO bxh24_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Debana yai peloweta haisa, dodoga sonosonogadi yo tau lau faꞌata E duidima. Haisa haba ami wunuidi be ami tutu fapatudi; na haisa haba emi aba oigogo lumadi yai ami talaidi, yo ami weꞌaidi sa lau, duhu laꞌi hesa, na doha. ");
INSERT INTO bxh24_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Logena, laulau loloho dodogadi ꞌwasinadi tanoꞌubu yai ami fatabuliwadi maisadi mate giludi ami baheidi. Dudulai dogana Abela ꞌwasinana, na ya laoma be Belakaiya natuna Sekalaiya ꞌwasinana, in mate Dubu Tabuna yai yo aba antalasam atiꞌatipudi yai haꞌa ami wunui. ");
INSERT INTO bxh24_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Matamiu yai E liba dudulai mate, gilu mahudoꞌina te haba hiti itete sa bahei. ");
INSERT INTO bxh24_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Isi Yelusalem! Yelusalem isi! Um logem wasa tau lawenidi wa wunuidi yo salumadi Yaubada ya duidiwa lisim mate wa lau umeꞌehuidi. Fuya ouꞌouli egu fanuha bena nanatum E dalidali gogo, doha kamkam tinabawana nanatuna ya hoba tawanidi, inmoho hige u fanuha! ");
INSERT INTO bxh24_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Em Dubu Tabuna afaꞌafana hola u ita. ");
INSERT INTO bxh24_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","E falibam, Hige gonowana u ita bodaigu ana sigana wa liba, uwen, Sai, Yaubada hesana yai ya laoma, Yaubada, bena ya faloholoho! ");
INSERT INTO bxh24_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Dubu Tabuna Yesu ya lau afulen na ana hewahewali sa laoma lisina be Dubu Tabudi lumadi sa faꞌita. Yesu ya fatiꞌo lau lebedi iyebom, ");
INSERT INTO bxh24_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ginauli mahudoꞌidi ni ami itadi? E liba dudulai lisimiu yai mate umeꞌehudi ni ibege laꞌi i otaꞌota. Hidana ai hewana, haba sa faibeꞌuidi. ");
INSERT INTO bxh24_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu mate Oliwe Uduhulina yai ya taꞌataꞌai, na ana hewahewali sa lau modimodi gafuma lisina, be tiyen, U falibamai, atasi somo haba sa tubu, yo em laoma fafaꞌilalana haba doha somo yo tanoꞌubu ena ofi atasi? ");
INSERT INTO bxh24_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Alinadi Yesu ya bui, iyen, Au ita komakomaꞌi. Tabu sai i bwalafahimiu. ");
INSERT INTO bxh24_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Paꞌana dodoga boludi haba hesagu sa fapaisowa tiyen, <<Yau mate Keliso,>> be haba sa bwalafahimiu. ");
INSERT INTO bxh24_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Hiyala dagugudi haba sadaimiu yai ami atahiyedi, yo tefa hesa yai haba wasadi hinaga ami atahiyedi. Inmoho tabu aluwamiu ti potifahi. Ginauli hudoꞌi-hudoꞌi haba sa tubu. Inmoho, fuyana hola ya laolaoma. ");
INSERT INTO bxh24_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tefa hesa haba maꞌedi tefa hesa sa hiyala, yo nuꞌu hesa haba maꞌedi nuꞌu hesa sa hiyala. Galamo wesawesasa yo mwanuꞌunuꞌu haba sa tubu ai nuꞌu haisa. ");
INSERT INTO bxh24_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Itete mate kamkamna fatufatubuna. ");
INSERT INTO bxh24_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Lahaidi ni haba sa fakamkamnamiu yo sa wunuimiu. Tefa mahudoꞌidi haba sa ꞌwaiyoꞌoemiu Yau debagu yai. ");
INSERT INTO bxh24_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Boludi haba edi kawawananaha sa gogoma. Maihalana yai na haidadi adi sa wewe yo sa fatole muli. ");
INSERT INTO bxh24_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Peloweta bwalabwaladi boludi haba sa laoma be sa bwalafahimiu. ");
INSERT INTO bxh24_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Paꞌana heyaheyaya ya laꞌi wananaha, dodoga boludi haba edi gadosisi haba sa welo. ");
INSERT INTO bxh24_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Inmoho, sai ya nuwa adidili bee–, ana siga yai mate, mwahuli hige ofina haba ya abi. ");
INSERT INTO bxh24_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Yaubada ena Aba Baꞌisa wasana loholohona mate haba ai tanoꞌubu mahudoꞌina sa lauguguyaꞌen. Ai mulina habahim tanoꞌubu ya ofi. ");
INSERT INTO bxh24_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Be yena tau anfaheyaya in nuꞌu tau faꞌasi tau faꞌasi wolewolena ami ita ya obiꞌobiyo Dubu Tabuna yai. In, Peloweta Daniyela beyabeyana ya libaen mate, yena tau fatifatili dogana haba aniyona ya fadosi lobahi. ");
INSERT INTO bxh24_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Salumadi Diudeya yai tau miya ti gela ti lau tuꞌa. ");
INSERT INTO bxh24_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yena sai ena luma hewana yai, tabu i lau leta, be ena ginauli luma ganahewana yai i tano gogo. ");
INSERT INTO bxh24_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Sai gabu yai tabu i fuyo, be ana luhuluhu i abi. ");
INSERT INTO bxh24_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Lahaidi yai te mate, wawahin nanatudi sa fafanomdi yo boga ganahewadi yai mate kamkamna laꞌilaꞌi haba sa fahoina. ");
INSERT INTO bxh24_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Inmoho, bena Yaubada ami anꞌetai be tabu ai fuya gogoma o ai Sabati au gela. ");
INSERT INTO bxh24_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Paꞌana lahaidi yai te kamkamna lalaꞌi haba sa tubu. Yaubada tanoꞌubu ya falasa fuyandi yai, kamkamna nenedi doha itete te fahoinadi ya laoma, be ahoꞌite, ai muli ibege doha ite hinaga i tubu fuyo. ");
INSERT INTO bxh24_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ibe lahaidi ni hige ti noꞌudima, ibege sai i mwahuli, Inmoho, Yaubada ena fasinabo dodogadi debadi yai lahaidi haba sa tupo. ");
INSERT INTO bxh24_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Lahaidi yai yena sai iyen, <<Yaubada ena Fasinabo Dogana, ma! Hola u ita!>> ye iyen <<Ma, ne'i!>> Tabu u kawawananahaꞌedi. ");
INSERT INTO bxh24_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Paꞌana Keliso bwalabwala yo peloweta bwalabwala haba sa taumahata be fafaꞌilala yo noꞌo abiꞌabidi sa lau fatubu, be yena gonowanadi haba Yaubada hineli dodogadi sa bwalafahidi. ");
INSERT INTO bxh24_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Logena E faliba bwaꞌiyemiu. ");
INSERT INTO bxh24_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Be yena sai ya falibamiu, iyen, <<Logena au–, nuꞌu pitapitalina yai!>> tabu au lau; o iyen, <<Logena ma, luma bilina ganahewana yai!>> tabu au kawawananaha. ");
INSERT INTO bxh24_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Gonogonowana doha namali ya tili tefa hasahasa yai, na ya lau tefa lidilidi yai, Doga Natuna ena laolaoma haba doha. ");
INSERT INTO bxh24_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Somo yai somo peꞌipeꞌina, mate gigiya haba ainiya sa faꞌoigogo. ");
INSERT INTO bxh24_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","<<Lahaidi yai ni, na heyaheyaya ni mulidi yai, maihala haba ya fakamumu, yo nawalahi ibege i sina; kipwala galewa yai haba sa beꞌu, yo somo gigigibwalina galewa yai haba sa tilele.>> ");
INSERT INTO bxh24_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Maihalana yai, Doga Natuna fafaꞌilalana haba ya taumahata ai galewa, na tefa ouꞌouli haba sa tan. Doga Natuna haba sa ita, ya laolaoma ai yada hewadi, ma  namanamalina yo ma gigibwalina. ");
INSERT INTO bxh24_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Hilimoya sa yufi falaꞌi na anelu ya fatamali bwaꞌiyedi sa lau galewa yo tanoꞌubu adi dan yai ena fasinabo dodogadi sa tanogogoꞌidi. ");
INSERT INTO bxh24_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Oyagi kuhou heyaheyasonna hola ya falibamiu; yena ya in be luguna sa tutuli ami sibai mate haiꞌin fuyana. ");
INSERT INTO bxh24_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Yena fafaꞌilala mahudoꞌina te ami itadi, ami sibai Yesu ena laoma ya hanahanauma emi papeꞌo gwalugwaluna yai. ");
INSERT INTO bxh24_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","E faliba dudulaimiu, mate hiti te ibege ti peꞌi ana sigana ginauli mahudoꞌidi te sa tubu. ");
INSERT INTO bxh24_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Galewa yo tanoꞌubu haba sa ofi, inmoho egu liba ibege ti ofi. ");
INSERT INTO bxh24_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ana lahai yo maihalana hige sai i sibai, hige Galewa aneludi, o Tau Natunatu. Tamana iyabona moho ya sibai. ");
INSERT INTO bxh24_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Doga Natuna ena laolaoma nenena doha somo mate haꞌa doha Nowa ena fuya yai. ");
INSERT INTO bxh24_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Bolowada hola hige i wewe fatubu, na lahaidi yai, dodoga sa nom yo sa kalahe, yo fafanahi, ya laulau ee–, Nowa ya awalau waga yai. ");
INSERT INTO bxh24_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Inmoho, hige begana edi ita lobahi somo ana sigana bolowada ya laoma be ya aleleidi. Doga Natuna ena laolaoma haba gonogonowana doha. ");
INSERT INTO bxh24_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Maihalana yai, tatau luwaga haba gabu yai sa paipaisowa. Yaubada haba esega ya lawen, na hesa haba ya lau afulen. ");
INSERT INTO bxh24_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wawahin luwaga hinaga haba witi sa bibibin, be fwalawa sa ginauli. Yaubada haba hesa ya lawen, na hesa haba ya lau afulen. ");
INSERT INTO bxh24_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Lisina yai bena ami nononoha, paꞌana emi Guyau, lahai somo haba ya laoma mate hige emi siba. ");
INSERT INTO bxh24_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ibe luma tanuwagana ya sibai fuyana somo tau angafu ya laoma haba ya tuhutuhuli. Be tau angafu ibege i angafu. ");
INSERT INTO bxh24_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Be logena, umi hinaga fuya ouꞌouli bena ami nononoha, paꞌana Doga Natuna ena laolaoma, doha fafatauhiti, hige au sibai. ");
INSERT INTO bxh24_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Sai haba fayofayo tau abina loholohona? Logena, in haba ena tau paisowa ya ita wata komakomaniꞌidi, yo haba maihala dudulaidi yai ya fakalahedi. ");
INSERT INTO bxh24_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yena ena baꞌisa ya lau fuyofuyoma na ya ita haba ya kawa loholohoen. ");
INSERT INTO bxh24_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","E liba dudulai matamiu yai, mate haba ya tole be ena ginauli mahudoꞌina ya ita watanidi. ");
INSERT INTO bxh24_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Na yena fayofayo tau abina ni ya heyaya be nuwana yai iyen, <<Egu baꞌisa ya miya hudoꞌi fuya lofalofa.>> ");
INSERT INTO bxh24_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Yofede, ya fatubu be falena fayofayo tau abidi ya antalaidi, ya kalahe yo ya nom maidana tau nom peledi. ");
INSERT INTO bxh24_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Fayofayo tau abina ena ba'isa ena laoma lahaina yo maihalana hige i sibai. ");
INSERT INTO bxh24_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Haba ya lau fabubui na ya fatamali lawen, maidana tau lau bwalabwala sa miya. Amainiya mate tan yo moꞌa aba nalididinidi. ");
INSERT INTO bxh24_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Galewa Aba Baꞌisa Nuꞌuna itaꞌitana doha wawahin nuwanuwasupudi safuhudohudoꞌi, edi lampa sa abidi, na sa lau taumoho sa fanahi, sa bagibagiyen. ");
INSERT INTO bxh24_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Faligigi sibasibadi, na faligigi yauyauledi. ");
INSERT INTO bxh24_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Yauyauledi edi lampa sa abidi, inmoho edi kelesin hige fahafudi ti abidi. ");
INSERT INTO bxh24_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Sibasiba edi lampa ma kelesinidi yo fahafudi sa abidi. ");
INSERT INTO bxh24_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tau nahi wa begana ya boneyawa be mahudoꞌidi matadi sa enoꞌeno yofede sa eno. ");
INSERT INTO bxh24_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Maihona atipuna yai sa fatala neꞌeneꞌeꞌen, tiyen, <<Haidamai! Tau nahi ya mahano. Au lau au failobahin.>> ");
INSERT INTO bxh24_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nuwanuwasupudi sa obiyo fahi, edi lampa sa abi nonohaidi. ");
INSERT INTO bxh24_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Yauyauledi faligigi wa sa anꞌeta lau, wawahin sibasibadi lebedi, tiyen, <<Aee–, kelesin ema au hinidi. Ema lampa sa peꞌi.>> ");
INSERT INTO bxh24_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Sibasibadi tiyen, <<Ai haꞌa gonogonowamai. Au lau tau uneꞌune lisidi yai, emi au unedi.>> ");
INSERT INTO bxh24_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Sa aulaha sa lau, na mulidi yai, tau nahi ya mahano. Tau nonoha faligigi wa sa lau fafanahi baꞌuna yai, na edaꞌeda sa gudu. ");
INSERT INTO bxh24_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mulidi yai, kelesin tau yoꞌo sa mahanoma, be sa oiꞌoi, tiyen, <<Baꞌisa, Baꞌisa, ema edaꞌeda u soꞌe!>> ");
INSERT INTO bxh24_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Alinadi ya bui, iyen, <<E faliba dudulaimiu mate, E fakaumiu.>> ");
INSERT INTO bxh24_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Lisina yai, Yesu ena liba ya falafusofa, iyebom, Au nonoha, paꞌana ana lahai yo ana maihala hige au sibai. ");
INSERT INTO bxh24_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Lahaidi yai ni Galewa Basileiyana haba doha ite. Fuya hudoꞌi taumoho hesa bena haba ya lau ya lauwasi; ena tau paisowa ya yoga gogondima, be hesa-hesa ya tole, haba ena ginauli sa ita watanidi. ");
INSERT INTO bxh24_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Esega-esega ena sibasiba laꞌina yai ya soi watan: hesa 5 tausan kina ya felen, hesa 2 tausan kina na hesa 1 tausan kina ya felen. Habahim ya lau ya lauwasi. ");
INSERT INTO bxh24_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","5 tausan tau abina hige i bagibagi ya lau ya fapaisowa be 5 tausan hesa ya lobahi. ");
INSERT INTO bxh24_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Abiꞌabina eseꞌesegana mate tausan luwaga tau abina ya laulauwen be hagahaga tausan luwaga hinaga ya lobahi. ");
INSERT INTO bxh24_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Inmoho, tausan esega tau abina wa ya aulaha ya lau be ena baꞌisa ena moni ya pului tanohi ganahewana yai. ");
INSERT INTO bxh24_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Fuya lofalofa ya ofi, mulidi yai, tau paisowa edi baꞌisa ya mahano fuyoma, be ena moni maidana sa pei gogonidi. ");
INSERT INTO bxh24_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","5 Tausan tau abina ya fapaisowa be 5 tausan hesa ya ginauli iyen, <<Baꞌisa, wa ita! Kina tausan faligigi wa felegu, na E fapaisowa be tausan faligigi hesa E ginauli.>> ");
INSERT INTO bxh24_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Alinana ena baꞌisa ya bui, iyen, <<Ya loholoho wananaha, Um egu tau paisowa loholoho yo dudulai dogana! Ginauli kikiꞌina itaꞌita watanidi yai mate wa loholoho, debana yai haba E tole hitim be ginauli boludi wa ita watanidi. U laoma, be egu kwade tefana u kwadeꞌen!>> ");
INSERT INTO bxh24_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Habahim tausan luwaga tau fapaisowana ya laoma hinaga, be ena baꞌisa ya faliba, iyebom, <<Baꞌisa, wa ita! Tausan luwaga wa felegu be E falaꞌi mate em hagahaga hinaga tausan luwaga, ma!>> Ena baꞌisa iyen, <<Ya loholoho wananaha, um egu tau paisowa loholoho yo dudulaina! ");
INSERT INTO bxh24_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Um mate moni kikiꞌina itaꞌita watanidi yai wa loholoho. Lisina yai, um haba E tole hitinim be ginauli boludi wa ita watanidi. U laoma, be egu kwade tefana u kwadeꞌen!>> ");
INSERT INTO bxh24_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ofiꞌofina mate, 1 tausan tau abina ya luhuma, be iyen, <<Baꞌisa, E sibaim mate um tau nuwa kipi hesa; wa lau gabu mate hige u umahidi na wa tanogogo mate tumadi hige u falili. ");
INSERT INTO bxh24_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Logena E ꞌwasabuwem, be E lau em moni E pulu tanohi ganahewana yai. Be wa ita! Somo wa felegu ma gonogonowana E fele fuyoim.>> ");
INSERT INTO bxh24_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ena baꞌisa iyen, <<Um mate tau paisowa heyaheyayana yo matamata peꞌipeꞌina! Haꞌa doha wa sibai mate, mahula E lau gabuidi mate, hige yau ya umahidi, yo umaꞌuma E tano gogoꞌidi mate hige tumadi ya falili? ");
INSERT INTO bxh24_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Wa somo? be egu moni hige u lau banika yai u tole, haba E fuyoma mate egu moni hudohudoꞌina ma hantapuna E abi fafuyo?>> ");
INSERT INTO bxh24_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","<<Debana yai, ena 1,000 kina lisina yai haba ami kamfahi, be 10,000 kina tau abina ami felen. ");
INSERT INTO bxh24_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Paꞌana sai somo haꞌa lebena yai mate haba hesa E felen, be ena boludi. Na sai somo begana lisina yai haba E kamfahi. ");
INSERT INTO bxh24_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na tau paisowa heyayana haba ami weꞌai ya lau ai kamukamumu. Ainiya haba ya tan yo gadigadina ya nalididin.>> ");
INSERT INTO bxh24_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yena Doga Natuna ma  namanamalina ya laoma, maꞌena ena anelu haba ena aba taꞌai namanamalina yai ya taꞌai. ");
INSERT INTO bxh24_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nuꞌu mahudoꞌidi dodogadi haba sa faꞌoigogoma ai lisina, na haba ya hinelidi doha sipi yo gouti sa hinelidi. ");
INSERT INTO bxh24_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Haba sipi ai sibana ya toledi, na gouti ai seulina ya toledi. ");
INSERT INTO bxh24_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Na habahim, Kin ya libalau tefa siba yai lisidi, iyen, <<Au laoma, safaluma umi Tamagu ya faloholohomiu, fuyana tanoꞌubu ena fuya falasana yai na Aba Baꞌisa emi loholoho ya abi nonohaidi au abi. ");
INSERT INTO bxh24_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Paꞌana E guliyam na agu kalahe ami felegu. Gadogu ya magu na hoꞌowa ami felegu be E nom. Yau taꞌowawa na ami yoga hitinigu. ");
INSERT INTO bxh24_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Hige egu ginauli na umi egu ami soi. Sa falau deligu na ami laoma ami kepaigu. E lepa na ami ita watanigu.>> ");
INSERT INTO bxh24_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tau dudulai dodogadi haba alinana sa fafuyo, tiyen, <<Guyau, sofuyana ꞌe itam wa guliyam na ꞌe fakalahem, o gadom ya magu na hoꞌowa ꞌe felem? ");
INSERT INTO bxh24_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Fuya som ꞌe itam um mate taꞌowawa, na ꞌe yoga hitinim, yo hige em leli na ginauli em ꞌe soi? ");
INSERT INTO bxh24_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Wa asiyebo yo um deli yai, na ma fisa ꞌe laowa ꞌe kepaim?>> ");
INSERT INTO bxh24_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kin haba iyen, <<E faliba dudulaimiu, somo kiukiu ami ginaulidi haidagu te lisidi yai mate ami ginauli lebegu.>> ");
INSERT INTO bxh24_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Habahim ya libalau seulina yai lisidi iyen, <<Umi safaluma Yaubada ya kaumananaꞌedi! Au lau hudoꞌi! Satani yo ena anelu adi oyagi alaꞌalana ibege i peꞌi, nonohana yai au alagolu. ");
INSERT INTO bxh24_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Paꞌana E guliyam na hige au ita galewaigu, gadogu ya magu na hige somo au felegu be ya nom. ");
INSERT INTO bxh24_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yau taꞌowawa, na hige au yoga hitinigu. Hige egu leli ginaulidi na egu hige au soi. E asiyebo yo E lau deli. Inmoho nuwamiu sa anꞌanloya hudoꞌi.>> ");
INSERT INTO bxh24_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Alinana hinaga haba sa bui, tiyen, <<Guyau, fuya somo ꞌe itam wa guliyam, e gadom ya magu o um taꞌowawa, o hige em leli ginauli o wa asiyebo o um deli yai - na hige ai saguhim?>> ");
INSERT INTO bxh24_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Alinadi haba ya bui iyen, <<E faliba dudulaimiu, somo hige au ginaulidi haidagu te lisidi yai, mate hige au ginauli yau lisigu yai.>> ");
INSERT INTO bxh24_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yofede, iti haba sa lau kamkamna otaꞌota fahina, na tau dudulai haba sa lau mwahuli hige ofina yai. ");
INSERT INTO bxh24_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ginauli mahudoꞌidi Yesu ya libaedi mulina, ana hewahewali ya falibadi iyen, ");
INSERT INTO bxh24_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Ami sibai mate, asubena haba Bayawa Anꞌangogona, aimuli haba Doga Natuna sa fele afulen be sa tutu fapatu ai kolosi. ");
INSERT INTO bxh24_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Habahim tau antalasam baꞌibaꞌisadi yo babada lalaꞌi sa faꞌoigogo esega Tau Antalasam Baꞌisana hesana Kaiyafasi ena luma yai. ");
INSERT INTO bxh24_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Edaꞌeda sa yoꞌo na sa oiꞌoiliba bena sidohana, bwalabwala yai, Yesu sa tohai, be sa lau funuhi. Inmoho sa liba, tiyen, ");
INSERT INTO bxh24_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tabu ai mataꞌasi fuyana, paꞌana doꞌata, dodoga ena sa lau be lulu sa fatubu. ");
INSERT INTO bxh24_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu hola Betani yai, lepela dogana hesana Saimon ena luma yai, ");
INSERT INTO bxh24_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","waihin hesa maꞌi panepanena maisana laꞌilaꞌina alabasita botolona yai ya abi, na ya laoma Yesu lisina, be aba kalahe, baꞌuna yai, boluboluna yai ya fagoi. ");
INSERT INTO bxh24_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yesu tau famuli watanina sa ita, be manadi sa bala. Yofede sa fatiꞌo tiyen, Paꞌana somo be maꞌi ya aiheyaꞌen? ");
INSERT INTO bxh24_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Maꞌi ni maisana ya laꞌi wananaha. Egoba te uneꞌuneꞌen be monina tau gogo gesagesa te feledi. ");
INSERT INTO bxh24_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Somo sa libaen mate, Yesu haꞌa ya sibai, yofede iyen, Paꞌana somo waihin te ami fatalapiliyen? Ginauli loholohona ya ginauli lisigu yai. ");
INSERT INTO bxh24_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tau gogo gesagesa fuya ouꞌouli maꞌemiu, na Yau ibege fuya ouꞌouli maꞌemiu. ");
INSERT INTO bxh24_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Taugu yai maꞌi ya hin, mate, egu toletoletau abi nonohana ya ginauli. ");
INSERT INTO bxh24_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","E faliba dudulaimiu mate, somo yai Wasa Loholohona te sa lauguguyaꞌen tefa hesa-hesa yai, haba waihin te somo ya ginauli lisigu yai fafaꞌilalana sa dedei. ");
INSERT INTO bxh24_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Habahim safuhudohudoꞌi luwaga hesauna hesana Diudasi Isakaliyoti ya lau Antalasam Baꞌisana lisina, ");
INSERT INTO bxh24_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","be ya fatiꞌoi, iyen, Ibe doga ni, ana E wewe ai lisimiu, haba maisagu somo ami felegu? Yofede siluba piꞌadi 30 sa fatilidi be sa felen. ");
INSERT INTO bxh24_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Amainiya na ya lawen mate Diudasi edaꞌeda ya yoꞌo haba sidohana ena felefele afulenna nimadi yai. ");
INSERT INTO bxh24_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Fwalawa Sesese Gesana Anꞌangogona lahaina bwaꞌibwaꞌina yai, tau famuli watanina sa laoma be Yesu sa fatiꞌoi tiyen, Ai somo haba em ꞌe abi nonoha, be Bayawa Anꞌangogona wa ginauli? ");
INSERT INTO bxh24_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Alinadi ya bui, iyen, Au lau duhu laꞌi, be yena taumoho hesa ami lobahi mate au faliba, auwen, <<Tanuwaga alinana doha ite, iyen, <Ena fuya haꞌa ya hanahanauma, be bena maꞌena ana hewahewali Bayawa Anꞌangogona sa abi nonohai em ai luma.>>> ");
INSERT INTO bxh24_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yofede, ana hewahewali alinana sa lau watan, be Bayawa Anꞌangogona sa abi nonohai. ");
INSERT INTO bxh24_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Maimailafina, Yesu maꞌena hewahewali sa taꞌai aba kalahe baꞌuna yai be sa kalahe gogo. ");
INSERT INTO bxh24_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sa kalakalahe na ya falibadi, iyen, E faliba dudulaimiu, ganahewamiu yai sai esega haba agu wa wewe. ");
INSERT INTO bxh24_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nuwadi sa heyaya be esega-esega ya libalau lisina iyen, Guyau bena Yau, ye? ");
INSERT INTO bxh24_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Alinadi ya bui iyen, Sai maꞌegu nimamai ꞌe dauꞌwaidi otogole yai te, mate agu tau wewe. ");
INSERT INTO bxh24_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Doga Natuna doha wasana sa uli mate, haba ya peꞌi. Inmoho Doga Natuna ana tau wewe ni, haba heyaheyaya laꞌilaꞌi ya fahoina! Loholohona moho ibe dogana ni tabu ti yosi. ");
INSERT INTO bxh24_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Habahim, ana tau wewe, Diudasi, iyen, Baꞌisa, nuwada yau? Yesu iyen, Na, ii–. ");
INSERT INTO bxh24_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Anꞌangogo ganahewana yai, Yesu fwalawa ya abi na Yaubada ya lautoꞌiyen ya ifi be tau famuli watanina ya feledi, na iyen, Au abi be au an. Itete yau taugu. ");
INSERT INTO bxh24_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Habahim, kaputi ya abi. Yaubada ya lautoꞌiyen, na habahim ya feledi. Na iyen, Au nom, mahudoꞌimiu. Itete yau ꞌwasinagu. ");
INSERT INTO bxh24_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ꞌWasinagu te yali fwaufwauna, ya tabuliwa dodoga mahudoꞌidi debadi yai, be edi heyaya haba Yaubada ya nuwa afuledi. ");
INSERT INTO bxh24_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","E falibamiu, waen masina te, ibege ya nom fuyoi, ahoꞌite na ya lau ee–, Yau yo umi te nom fuyoi Tamagu ena Aba Baꞌisa Nuꞌuna yai. ");
INSERT INTO bxh24_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yofede, wana hesa sa wanai, mulina, sa lau Oliwe Uduhulina. ");
INSERT INTO bxh24_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Habahim Yesu ya falibadi, iyen, Maihona te haba emi kawawananaha lisigu yai sa welo, paꞌana Uliꞌuli Tabuna iyen: <<Tau ita wata haba sa wunui, na sipi baiwadi haba sa dabalala.>> ");
INSERT INTO bxh24_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Inmoho haba E mwahuli fuyo, na mulina yai, haba E bwaꞌi, be E lau Galili. ");
INSERT INTO bxh24_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita iyen, Bwagana! Mahudoꞌidi haba sa dabalala um debam yai, na yau hige gonowana ya lau afulem. ");
INSERT INTO bxh24_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Alinana Yesu ya bui iyebom, E faliba dudulaim, maihona te kamkam ibege hola i gwane mate, haba wa faleleꞌegu ma faihona. ");
INSERT INTO bxh24_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita iyen, Bwagana, haba te peꞌi, hige gonowana ya faleleꞌem. Mahudoꞌidi edi libana gonogonowana. ");
INSERT INTO bxh24_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Habahim Yesu maꞌana hewahewali sa lau nuꞌu hesa hesana Getesemeni, na habahim ya falibadi iyen, Aiteꞌi, au taꞌataꞌai, na yau haba E lau ai kwalau neꞌi, E lauꞌuꞌula. ");
INSERT INTO bxh24_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pita yo Sebedi nanatuna luwaga ya foyahidi be maidana sa lau. Nuwa heyaya yo kamkamna nuwana sa famohafu, na ya libalau lisidi iyen, ");
INSERT INTO bxh24_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nuwa heyaya ganahewagu yai mate, ya laꞌi wananaha. Begana haba ya faheyayagu. Aiteꞌi au miya, na au tuhutuhuli watanigu. ");
INSERT INTO bxh24_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Begana ya sigilau, habahim, ya hoba lidi tanohi yai, na ya lauꞌuꞌula iyen, Tamagu, yena um em nuwatuhu yai mate, kamkamna lisigu yai te u abifahi! Inmoho, hige yau egu fanuha, um em fanuha yai. ");
INSERT INTO bxh24_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Na habahim ya fuyo ana hewahewali faihona lisidi, be ya itadi, sa laulau eno. Yofede, ya libalau Pita lisina, Tataumiu faihona! Sidohana hige umi be yau ta tuhutuhuli maihala tupotupo ganahewana yai? ");
INSERT INTO bxh24_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Au tuhutuhuli yo au lauꞌuꞌula! Haba ibege lauꞌita au lobahi. Yaluwamiu sa nonoha. Inmoho, ꞌwapimiu sa belubelu. ");
INSERT INTO bxh24_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Fafaluwagana ya fuyo, be ya lauꞌuꞌula iyen, Tamagu, yena kaputi te, hige gonowana u lawe hudoꞌiyen ana sigana E nom mate, um em nuwatuhu haba E lau watan. ");
INSERT INTO bxh24_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ya fuyoma mate, ya ita bodaidi sa laulau eno, paꞌana matadi sa maigibo. ");
INSERT INTO bxh24_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yofede ya lau afuledi na fafaihonana ya fuyo ya lauꞌuꞌula mate, libadi gonogonowadi ya libaedi. ");
INSERT INTO bxh24_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Habahim ya fuyoma ana hewali lisidi, be ya falibadi, iyen, Hola ma enoꞌenomiu yo ma anyawasimiu? Ana maihala ya talai, yo Doga Natuna mate ana sa wewe dodoga heyaheyayadi nimadi yai. ");
INSERT INTO bxh24_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Au mwaito, te auꞌaulaha! Agu tau wewe ya laoma! ");
INSERT INTO bxh24_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu hola ma libalibana na yofede, Diudasi, Yesu ana hewali hesa ya mahano. Dodoga boludi maidana sa laoma, ma nigonigodi yo ma kepakepatadi. Tau antalasam yo baꞌibaꞌisa haisa sa fatamalidi. ");
INSERT INTO bxh24_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tau nuwa afulenna mate, dodoga wa haꞌa ya fanigugudi, iyen. Taumohona E falafu mate, in dogana ami fanuha. Au tohai! ");
INSERT INTO bxh24_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Diudasi ya dudulai Yesu lisina na iyen, Tanuwaga, Yauwedo. Na habahim, ya falafu. ");
INSERT INTO bxh24_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu alinana ya bui, iyen, Hidagu, au abi watawatan feulai. Habahim, sa laoma, be Yesu sa tohai, na sa toha didin. ");
INSERT INTO bxh24_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yesu ana hewali hesa ena baineti ya solu fahi be Tau Antalasam edi Baꞌisa ena fayofayo tau abina beyana ya tala sapi. ");
INSERT INTO bxh24_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu iyen, Em baineti u husai fafuyo, paꞌana sai baineti ya abi haba bainetina yai ya pe'i. ");
INSERT INTO bxh24_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Emi nuwatuhu bena hige gonowagu haba Tamagu ya anꞌetai be anelu pele laꞌilai oulina safuhudohudoꞌi luwaga i fatamalidima be agu ti fofo? ");
INSERT INTO bxh24_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Inmoho yena somo bena ya tubu na hige'e, mate Buka Tabuna haba sidohana fafawananahana? ");
INSERT INTO bxh24_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Maihalana yai Yesu ya libalau baiwa lisidi, iyen, Emi nuwatuhu mate, yau pilipili tau laulau fatubu? Be logena ma baibainetimiu yo ma kepakepatamiu ami laoma be ami augu? ");
INSERT INTO bxh24_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ginauli mahudoꞌidi sa tubu te mate peloweta edi uliꞌuli bena ya fawananahadi. Yofede tau famuli watanina mahudoꞌidi sa dabalala, na ibona sa lau afulen. ");
INSERT INTO bxh24_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Saluma Yesu sa tohai mate, sa lawen Kaiyafasi ena luma. In Tau Antalasam Dodogadi edi Baꞌisa. Amainiya mate laugagayo tau lau faꞌataenna yo babada sa bagibagiyen. ");
INSERT INTO bxh24_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita mate, muli yai ibona ena atiꞌatipu, Tau Antalasam Baꞌisana ena luma ganana ganamulina yai. Muli yai, habahim, ya luhulau, be maidana Kaiyafasi ena tau gati sa taꞌataꞌai gogo, dobidobi yai, be somo haba Yesu ai lisina sa ginauli ya ita. ");
INSERT INTO bxh24_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tau antalasam babaꞌisadi, yo Sanhedeli peledi mate, mata bwalabwala sa yoꞌo, be bena ainiya haba Yesu sa wunui. ");
INSERT INTO bxh24_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tau wikinisi boludi sa laoma, inmoho hige ana mata hesa ti lobahi. Ofiꞌofina mate wikinisi bwalabwala luwaga sa obiyoma, ");
INSERT INTO bxh24_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","na tiyen, Doga te iyen, <<Yau gonowagu Yaubada ena Dubu Tabuna E lubi lopalopa, na lahai faihona ai ganahewana haba E faꞌobiyo fuyoi.>> ");
INSERT INTO bxh24_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Yofede Antalasam Baꞌisana ya obiyo be Yesu ya faliba iyen, Dodoga edi lau fagilu hewam yai te, haga u bui? ");
INSERT INTO bxh24_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Inmoho Yesu ya doꞌo. Yofede, Antalasam Baꞌisana wa ya liba boda, iyen, Yaubada Mwahumwahulina hesana yai E falibam mate, u falibamai yena um mate Fasinabo Dogana, Keliso, Yaubada Natuna, e higeꞌe? ");
INSERT INTO bxh24_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Alinana Yesu ya bui iyen, Ii–, somo wa libaen mate, logena. Inmoho mahudoꞌimiu E falibamiu mate: Fuya matada yai haba Doga Natuna ya taꞌai Yaubada Hewa Wananaha yai, ai sibana, yo ai Galewa yadadi haba ya laoma ami ita. ");
INSERT INTO bxh24_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yofede Antalasam Baꞌisana ena leli ya pulitidi na iyen, Yaubada matana yai ya liba heyaya! Hige gonowana wikinisi haisa haba ta yoꞌoi! Yaubada ya liba faheyaya haꞌa ami atahi. ");
INSERT INTO bxh24_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Emi nuwatuhu doha somo? Alinana sa bui, tiyen, Ii–, peꞌi moho. ");
INSERT INTO bxh24_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yofede sa lau kanisofi, yo sa talai, na haisa sa lau papaliꞌi. ");
INSERT INTO bxh24_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Na tiyen, <<Keliso,>> yena um peloweta dogana, salumadi sa talaim, u falibamai! ");
INSERT INTO bxh24_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita hola ya taꞌataꞌai luma laꞌilaꞌina dobidobina yai, na Tau Antalasam Baꞌisana ena paula tau abina ya laoma be iyen, Um hinaga mate Yesu Galili maꞌem. ");
INSERT INTO bxh24_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Inmoho, mahudoꞌidi matadi yai ya falele. Alinana ya bui, iyen, Somo um wa libalibaen mate yau hige ya siba. ");
INSERT INTO bxh24_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Habahim Pita ya aulaha ya lau edaꞌeda hafohafona yai na, waihin hesa hasahasalana ya ita, be dodoga ya falibadi iyen, Doga te, maꞌena Yesu Nasaleta. ");
INSERT INTO bxh24_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Na ya falele boda, yo ya angwala, iyen, Dogana mate yau hige ya sibai! ");
INSERT INTO bxh24_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hige walolona na, saluma aho amainiya sa obiꞌobiyo, sa lau Pita lebena yai na tiyen, Na fede, um hidadi hesa. Alinam dagudaguguna ya famahatam, mate um Galili dogana. ");
INSERT INTO bxh24_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Habahim ya angwala hasa matadi yai, Dogana hige ya sibai! Hige walolona, kamkam ya gwane. Yofede, somo Yesu ya libaedi wa, ya nuwatuhuidi, ");
INSERT INTO bxh24_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kamkam ibege hola i gwane, mate haba wa faleleꞌegu ma faihona. Yofede ya lau ganamuli yai, be nuꞌu ya lau tantansinidi. ");
INSERT INTO bxh24_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ya ifi tatatali, tau antalasam yo baꞌibaꞌisa edi sa oiliba bena Yesu sa lau funuhi. ");
INSERT INTO bxh24_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Sa auꞌaui, habahim sa foyahi lawen, Pailati lisina. In Loma edi Baꞌisa Diudeya ganahewana yai mate, in edi gawana. ");
INSERT INTO bxh24_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Fuyanna Diudasi, Yesu ana tau wewe, ya siba mate Yesu sa fagilu bena sa wunui, yofede ya nuwatuhu lobahi mate laupono ya ginauli yo ya nuwabui. Yofede siluba oulina 30 ya fafuyodi Tau Antalasam Baꞌisana yo babada lisidi. ");
INSERT INTO bxh24_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ya falibadi iyen, Egu heyaheyaya, paꞌana doga dudulaina ꞌwasinana E fatabuliwa. Alinana sa fafuyo, tiyen, Mate um em mode. Ai hige ema mode amainiya. ");
INSERT INTO bxh24_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yofede Diudasi moni ya peidi Dubu Tabuna tefana yai na ya auꞌaulaha ya lau be ya faluke fuyoi. ");
INSERT INTO bxh24_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tau antalasam babaꞌisadi moni wa sa tanoꞌidi, na tiyen, Moni te hige gonowana ai Dubu Tabuna ta fapaisowa, paꞌana itete ꞌwasina maisana. ");
INSERT INTO bxh24_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Yofede, sa nuwanuwatuhu be Gulewa Tau Laulau ginauli ena gabu sa une, be taꞌowawa adi bwana sa ginauli. ");
INSERT INTO bxh24_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Logena, ahoꞌite mate, nuꞌuna hesana sa ataꞌatahi <<ꞌWasina Nuꞌuna.>> ");
INSERT INTO bxh24_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Lisina yai, Peloweta Delamaiya ena liba sa fawananaha, (fuyana) iyen, Isalaela dodogadi maisa sa lau yogaen, <<Siluba 30 hewana yai mate sa abidi. ");
INSERT INTO bxh24_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Be Gulewa Tau Laulau ginauli ena gabu sa une, gonogonowana doha Yaubada ya falibagu. ");
INSERT INTO bxh24_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu, Gawana Pailati matana yai ya obiyo, na ya fatiꞌoi, iyen, Um Diusi edi Kin? Alinana Yesu ya bui, iyen, Somo wa libaen mate, logena. ");
INSERT INTO bxh24_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tau antalasam laꞌilaꞌidi yo babada edi gilu bwalabwala lisina yai, hige laꞌi i bui. ");
INSERT INTO bxh24_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Habahim Pailati ya fatiꞌo iyen, Ginauli mahudoꞌidi sa fagilum ni, wa atahiyedi, e higeꞌe? ");
INSERT INTO bxh24_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Inmoho, edi lau fagilu mahudoꞌidi, mate hige Yesu laꞌi i bui. Yofede, Gawana ya noꞌo wananaha. ");
INSERT INTO bxh24_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Fuya ouꞌouli, Gawana ena laulau mate, yena Bayawa Anꞌangogona fuyana ya laoma, haba dodoga sa liba, be sai deli yai sa soꞌefahi. ");
INSERT INTO bxh24_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Fuyana yai mate, tau lau deli hesa, hesana Balabasi. ");
INSERT INTO bxh24_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Dodoga sa faꞌoigogoma, yofede Pailati ya fatiꞌo lau lisidi, iyen, “Emi fanuha dogana tausomo bena E soꞌefahi: Balabasi, o Yesu, hesana hesa Keliso?” ");
INSERT INTO bxh24_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Haꞌa ya sibai mate sa leyama ya lau fatala paꞌana sa nuwa elaꞌelaꞌen. ");
INSERT INTO bxh24_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailati mate aba lau fatala yai hola ya taꞌataꞌai, na lahuna alina ya fatamali lawen lisina iyen, Doga dudulaina ni tabu ai lisina somo u ginauli. Maihona yai doga ni E eno suwaiyen be in debana yai kamkamna laꞌilaꞌi E fahoina. ");
INSERT INTO bxh24_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Inmoho, antalasam babaꞌisadi yo babada, dodoga sa nuwa liuidi mate Balabasi bena sa soꞌefahi, na Yesu wunuina libana moho bena sa oilibaen. ");
INSERT INTO bxh24_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Yofede, Gawana ya fatiꞌo lau lebedi iyen, Tataudi luwaga haba tausomo ami fanuha bena E soꞌefahi? Tiyen, Balabasi. ");
INSERT INTO bxh24_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailati ya fatiꞌo bodaidi iyen, Na Yesu, sa kawakawa Kelisoꞌen ai lisina haba somo E ginauli? Mahudoꞌidi alinana sa bui, tiyen, U tutu fapatu! ");
INSERT INTO bxh24_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pailati iyen, Na bee–, ena laupono somo? Sa yoga laꞌilaꞌi, tiyen, U tutu fapatu! ");
INSERT INTO bxh24_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Yofede Pailati nuwana yai ya lobahi mate, haꞌa sa leihafihafiti, yo bobohalahala mate ya laꞌilaꞌi. Be hoꞌowa ya abi, na ya nima kaisu baiwa matadi yai na iyen, Doga dudulaina ꞌwasinana te ibege giluna au fabaheigu, umi haba ami bahei. ");
INSERT INTO bxh24_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Mahudoꞌidi tiyen, Doga te, ꞌwasinana haba ai yo nanatumai giluna ꞌe bahei. ");
INSERT INTO bxh24_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yofede Pailati Balabasi ya soꞌefahi. Na ya liba be Yesu sa pidili, habahim tau hiyala ya feledi, be haba sa tutu fapatu. ");
INSERT INTO bxh24_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Habahim, Gawana Pailati ena tau hiyala Yesu sa lawen edi aba oigogo, be hiyala dodogadi mahudoꞌidi sa fataꞌiꞌili. ");
INSERT INTO bxh24_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ena leli sa pwala fahidi, na leli ginaulina hesa balebalelemna sa faliꞌo. ");
INSERT INTO bxh24_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Na habahim nulinuli sa fatuli, be sa fakoku kuluna yai, yo tuꞌe bigabigana nima sibana yai sa tole lawen hinaga. Habahim, sa tulibono nuwanuwana yai na sa lau faliuhwaꞌen, tiyen, Diusi edi Baꞌisa, yauwedo! ");
INSERT INTO bxh24_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Sa kanisofi, yo tuꞌe wa sa abi be kuluna yai sa oiꞌoiyen. ");
INSERT INTO bxh24_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Edi faꞌatiti bwalabwalana ya ofi, na mulina yai, leli ginaulina ni sa kamfahi, na in ena ginauli sa faliꞌo fuyoi. Mulina yai, habahim, sa foyahi lawen, bena sa tutu fapatu. ");
INSERT INTO bxh24_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Sa aulaha, sa lau ganamuli. Sailin dogana hesa sa lobahi, hesana Saimon. Sa bayahoi, be Yesu aba tutu fapatuna ya bahei. ");
INSERT INTO bxh24_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Sa laoma nuꞌu hesa hesana Gologota. (Aniyona mate Kulukulu Nuꞌuna). ");
INSERT INTO bxh24_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Amainiya mate waen sa falamo maꞌena nomnom kalakalapi hesa sa felen be ya nomina, be ya ꞌwaiyoꞌoen. ");
INSERT INTO bxh24_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sa tutu fapatu mulina yai, habahim ena leli sa soiyedi, habahim sa aiheya failakoꞌedi haba sai esega ya abi. ");
INSERT INTO bxh24_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Mulina yai sa taꞌai amainiya, na sa itaꞌita watan. ");
INSERT INTO bxh24_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ana mata paꞌana sa uli, be Yesu kuluna hewana yai sa tutu fapatu, Uliꞌulina doha ite, <<Itete Yesu, Diusi edi Baꞌisa.>> ");
INSERT INTO bxh24_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tau angafu luwaga mate, maꞌedi Yesu sa tutu fapatudi, hesa sibana yai na hesa seuseulina yai. ");
INSERT INTO bxh24_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Saluma sa bayawai mate, sa lau faliuhwaꞌen. Kuludi sa talatala oiyedi, na sa liba, tiyen, ");
INSERT INTO bxh24_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Um bena Aba Antalasam Dubuna wa faheyaya, na lahai faihona ai ganahewana haba wa faꞌobiyo fuyoi, haga ibom u saguhi fuyoim! Yena moꞌisa um Yaubada Natuna, haga beti ai aba tutu fapatum ni u tulubeꞌuma! ");
INSERT INTO bxh24_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Laulauna eseꞌesegana, tau antalasam yo laugagayo tau laulau faꞌataina yo Isalaela babada lalaꞌi sa lau faliuhwaꞌen hinaga. ");
INSERT INTO bxh24_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Tiyen, Dodoga haisa ya saguhidi, inmoho ibege ibona i saguhi fuyoi! In Isalaela eda Baꞌisa, e higeꞌe? Ibe doꞌata te, ai aba tutu fapatuna ni ya tulubeꞌuma, haba te kawawananahaꞌen. ");
INSERT INTO bxh24_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","In Yaubada ya kawawananahaꞌen, na ya liba bena in Yaubada Natuna. Haga beti, ta ita haba Yaubada bena i fanuha haba doꞌata te i famwahuli! ");
INSERT INTO bxh24_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Laulauna gonogonowana tau angafu luwaga Yesu ma afa haidana sa fakautidi mate, Yesu sa liba fafaheyaya. ");
INSERT INTO bxh24_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Lahai laꞌi mate, nuꞌu mahudoꞌina ya kamumu lubilubi, ya lau ee–, ya mailafi. ");
INSERT INTO bxh24_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Maihala doha 3 koloki, Yesu ya yoga laꞌilaꞌi, iyen, Eli, Eli, lama sabatani? Aniyona mate, Egu Yaubada, paꞌana somo wa nuwa afulegu? ");
INSERT INTO bxh24_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Haisa sa obiꞌobiyo amainiya sa atahiyen be tiyen, Ilaidiya ya yogayogaim. ");
INSERT INTO bxh24_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Feula na, hudoꞌi ya lau, be bwalofi ya abi. Ya dauꞌwai waen kalakalapina yai, na siꞌosiꞌo yai ya lolon hasaen, be bena Yesu ya nom. ");
INSERT INTO bxh24_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Haisa tiyen, I otawa! Haba Ilaidiya ya laoma ya fofofahi, te ita, e higeꞌe? ");
INSERT INTO bxh24_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yofede Yesu ya yoga laꞌilaꞌi fuyo. Maꞌesega na, yawasina ya ofi. ");
INSERT INTO bxh24_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yesu ya peꞌi, yofede, mwanuꞌunuꞌu ya fatubu be tanohi ya mwahimwahiu. Yofede, bwanali sa taꞌifiꞌifi. Na Dubu Tabuna ganahewana yai, bili daili kalekona ya tapuliti luwagai, hewa yai ya lidi ubu. ");
INSERT INTO bxh24_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Boꞌusa sa tasoꞌe, na dodoga tabudi haꞌa sa peꞌi mate, sa mwahuli fuyo. ");
INSERT INTO bxh24_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Boꞌusa yai sa kalamahano. Na Yesu ena obiyo fuyo, mulina yai mate sa lau duhu balabalamumu tabuna yai, be dodoga boludi matadi yai sa taumahata. ");
INSERT INTO bxh24_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Fuyana tau hiyala dodogadi haisa maꞌedi baꞌisa, Yesu sa ita watan. Na mwanuꞌunuꞌu sa fahoina, yo ginauli te sa itadi, mate sa ꞌwasabu wananaha, be tiyen, Moꞌisa, in mate Yaubada Natuna wananahana. ");
INSERT INTO bxh24_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wawahin boludi mate amainiya, manamanaꞌa yai sa obiꞌobiyo. Iti Galili yai Yesu sa lau watan, be somo ya fanuha haba sa felen. ");
INSERT INTO bxh24_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ganahewadi yai mate, Maliya Magadala, ena falihesa Diyemsi yo Diyosepa tinadi, yo Sebedi nanatudi tinadi. ");
INSERT INTO bxh24_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Maihala hola hige i bulu, na Alimatiya dogana hesa fafagogona hesana Diyosepa ya laoma. In mate Yesu ena tau kawawananahaꞌenna hesa. ");
INSERT INTO bxh24_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ya lau Pailati ya anꞌetai, bena Yesu silanna ya abi. Pailati ya tauꞌulu be liba ya fatamali bena Yesu silanna sa felen. ");
INSERT INTO bxh24_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yofede, Diyosepa silan wa ya abi, ya suma fataꞌiꞌili kabobo fwaufwauna yai. ");
INSERT INTO bxh24_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Habahim in ana bwana fwaufwauna bwanali yai haꞌa ya pidi nonohai, amainiya ya boꞌusai. Na Diyosepa umeꞌehu ya fatapipili, be boꞌusa hafohafona ya gudu, na ya lau afulen. ");
INSERT INTO bxh24_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maliya Magadala yo Maliya hesa mate, sadai yai sa taꞌataꞌai, na boꞌusa sa maimainenei. ");
INSERT INTO bxh24_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sabati abi nonohana lahaina, na bobonna, yofede antalasam babaꞌisadi yo Falesiya sa lau Pailati lisina be tiyen, ");
INSERT INTO bxh24_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Baꞌisa, doga bwalabwalana ni, ma mwahumwahulina ya liba iyen, <<Lahai faihona ai mulidi haba E mwahuli fuyo.>> ");
INSERT INTO bxh24_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Debana yai, haba tau gati wa faliba, be boꞌusa sa gatini komakomaniꞌi, ya lau wee–, lahai faihona sa ofi. Paꞌana ana hewahewali ibe ti lau be silanina ti angafuhi. Na haba dodoga sa bwalaidi tiyen, <<In haꞌa ya mwahuli fuyo.>> Bwalabwala mulimulitana te, haba ya heyaya wananaha habahim bwala bwa'ibwa'ina. ");
INSERT INTO bxh24_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Alinadi Pailati ya bui iyen, Gati au abi be au lau boꞌusa au gudu au komakomaniꞌi. ");
INSERT INTO bxh24_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Yofede sa lau be boꞌusa sa gudu komakomaniꞌi, yo gati sa toledi. ");
INSERT INTO bxh24_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabati mulina yai, wiki lahai bwaꞌibwaꞌina yai, ya ifi tatatali, Maliya Magadala yo ena falihesa sa lau boꞌusa sa kepai. ");
INSERT INTO bxh24_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Maꞌesega na, mwanuꞌunuꞌu laꞌilaꞌi nuꞌu ya fadihodiho, paꞌana Yaubada ena anelu galewa yai ya lidima, be ya lau boꞌusa umeꞌehuna ya fatapipili, na hewana yai ya taꞌai. ");
INSERT INTO bxh24_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nenena ya namanamali, na ena leli sa kafu doha goula. ");
INSERT INTO bxh24_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tau gati sa ꞌwasabuwen, be sa tabutabubu. Hige ti mwahimwahiu. Sa famala doha tau peꞌipeꞌi. ");
INSERT INTO bxh24_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Anelu ya libalau wawahin luwaga lisidi iyen, Tabu au ꞌwasabu! E sibai mate, Yesu sa wunui, ami yoꞌoyoꞌoi. ");
INSERT INTO bxh24_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","In hige amaiteꞌi. Haꞌa ya mwahuli fuyo, gonogonowana doha haꞌa ya libaen. Ena aba eno hola au laoma, au ita. ");
INSERT INTO bxh24_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Haba feula ami fuyo, be ana hewali edi, ami liba, auwen, <<In haꞌa ya mwahuli fuyo, be ya bwaꞌi ya lau Galili. Ainiya haba ami ita. Logena, E falibamiu te.>> ");
INSERT INTO bxh24_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Yofede, wawahin wa, boꞌusa sa lau afulen, na sa fabelele sa lau. Sa ꞌwasabu, inmoho, sa kwade. Sa lautafo sa lau, be tau famuli watanina haba sa falibadi. ");
INSERT INTO bxh24_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Hola sa laulau tafo, na maꞌesega, Yesu ya mwaito afulen, nuwanuwadi yai, na iyen, Yauwedo. Sa laoma nuwanuwana yai. Ahena yai sa abilau, na sa fadebasae. ");
INSERT INTO bxh24_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Habahim Yesu ya falibadi, iyen, Tabu au ꞌwasabu. Au lau, be afa haidagu au falibadi be ti lau Galili. Ainiya haba sa itagu. ");
INSERT INTO bxh24_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wawahin wa hola edaꞌeda yai ma laudi, na gati haisa sa lau Yelusalem taonna yai, be ginauli mahudoꞌidi sa tubu mate, sa wasa duwaiyedi, tau antalasam babaꞌisadi yo babada lisidi yai. ");
INSERT INTO bxh24_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tau antalasam babaꞌisadi sa faꞌoigogoma maidadi babada, be sa oiliba. Habahim, hiyala tataudi moni laꞌilaꞌi sa feledi, ");
INSERT INTO bxh24_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","na sa falibadi, tiyen, Haba ami liba, auwen, <<Ai ꞌe eno, na iꞌipana ana hewali sa lau samosamonene, be silanina sa angafuhi.>> ");
INSERT INTO bxh24_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Yena wasa te, Gawana ya atahiyen, haba emi ꞌe oilele. Tabu gilu au bahei. ");
INSERT INTO bxh24_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Yofede, tau hiyala moni wa sa abi, na somo sa fatalahadi mate, sa lau watan. Wasa te mate, Diusi dodogadi mahudoꞌidi sa fatadada ya laoma bee–, ahoꞌite hinaga. ");
INSERT INTO bxh24_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tau famuli watanina 11 sa lau Galili tuꞌana hesa yai, somo yai Yesu ya fatalahadi nuꞌuna bena ainiya sa failobahi, sa lau niya. ");
INSERT INTO bxh24_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Amainiya Yesu sa ita, yofede, sa fadebasae. Inmoho, haisa mate sa nuwa luwaluwaga. ");
INSERT INTO bxh24_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu ya sigilau sadaidi yai, na ya falibadi iyen, Gigibwali mahudoꞌidi galewa yai yo tanoꞌubu yai Yaubada haꞌa ya felegu. ");
INSERT INTO bxh24_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Lisina yai au lau nuꞌu ouꞌouli yai be dodoga au faꞌatadi yo au fababasitodi, Tau Tamatama, Natuna yo Yaluwa Tabuna hesadi yai, be haba sa famala tau famuli watanigu. ");
INSERT INTO bxh24_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Na haba ami fatalahadi be ginauli mahudoꞌidi E libaedi sa lau watanidi. Haba fuya ouꞌouli Yau maꞌemiu, ya lau ee–, tanoꞌubu ena fuya ofi yai. ");
ALTER TABLE bxh24_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
