﻿USE sofia;
DROP TABLE IF EXISTS sofia.bwu_vpl;
CREATE TABLE bwu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bwu_vpl WRITE;
INSERT INTO bwu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yeezu Kirisita kokpieŋsaŋa ale nna. Wa kokpieŋsaŋa meena po, ka naawa Deevid jam le wa kokpieŋ kpak. Abraham me jam le Deevid kokpieŋ kpak. ");
INSERT INTO bwu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham yaa jam biak Aizik, ate Aizik biak Jekob ate Jekob biak Juda ale wa yuama. ");
INSERT INTO bwu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda biak Perezi ale Zera, Tamara a jam ale ba mawa. Perezi a yaa jam biak Ayeziron, ate Ayeziron me a biak Aram. ");
INSERT INTO bwu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram a yaa jam biak Aminadab, ate Aminadab me a biak Naason, ate Naason me a biak Salimon. ");
INSERT INTO bwu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimon a yaa jam biak Boazi, Arayab a jam ale wa mawa. Boazi a yaa jam biak Obed, Arut a jam ale wa mawa. Obed me a biak Jese. ");
INSERT INTO bwu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jese a yaa jam biak naawa Deevid. Deevid a yaa jam biak Solomon, wa mawa a liŋ jam ka Yuraya pɔk. ");
INSERT INTO bwu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon yaa jam biak Ariyoboam, ate Ariyoboam me a biak Abaija ate Abaija me a biak Asa. ");
INSERT INTO bwu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa a yaa jam biak Jeyosafat, ate Jeyosafat me biak Joram ate Joram me a biak Yuzaya. ");
INSERT INTO bwu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yuzaya a yaa jam biak Jotam, ate Jotam me a biak Ayazi, ate Ayazi me a biak Ayezekaya. ");
INSERT INTO bwu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ayezekaya a yaa jam biak Manasa, ate Manasa me a biak Amon, ate Amon me a biak Josia. ");
INSERT INTO bwu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josia a yaa jam biak Jekonaya ale wa yuama. Dila po ate nuruba a yaa jam yik Juuma a ta cheŋ tɛŋ kanyi, ate ba jam a wi ayen Babilon. ");
INSERT INTO bwu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Juuma ale ga paari Babilon tɛŋka la, ate Jekonaya a yaa jam biak Sealtiel ate Sealtiel me a biak Zerubabel. ");
INSERT INTO bwu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabel a yaa jam biak Abayud, ate Abayud me a biak Eliakim, ate Eliakim me a biak Azor. ");
INSERT INTO bwu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor a yaa jam biak Zadok, ate Zadok me a biak Akimu, ate Akimu me a biak Elayud. ");
INSERT INTO bwu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elayud a yaa jam biak Eleaza, ate Eleaza me a biak Matan, ate Matan me a biak Jekob. ");
INSERT INTO bwu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekob a yaa jam biak Josefi waai ate Mɛɛri a jam yali la. Mɛɛri a jam ka Yeezu waai ate ba jam a wi ayen Varibasidɔwa ate Naawen a weeni ayen wa le tom wa la ma. ");
INSERT INTO bwu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","A nyini Abraham daaŋa po a ga paari Deevid daaŋa po, kokpieŋsaŋa a jam ka pi ale banaansi. A nyini Deevid daaŋa po a ga paari diipo ate ba yik ba a ta cheŋ Babilon tɛŋka la, kokpieŋsaŋa a jam ka pi ale banaansi me. A ŋman nyini diipo ate ba yik ba a ta cheŋ Babilon tɛŋka la a ga paari diipo ate ba biak Yeezu Kirisita la, kokpieŋsaŋa a jam ka pi ale banaansi me. ");
INSERT INTO bwu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ba le jam biak Yeezu Kirisita dii la ale nna. Yeezu mawa yoi jam ale Mɛɛri. Mɛɛri jam siak kama ayen wa yali nidɔa wanyi ate ba jam a wi ayen Josefi. Alege diipo ate ba an diem jam yali chaab la, Naawen Chiika jam nyɛ kama ate Mɛɛri a deri ta puuk. ");
INSERT INTO bwu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josefi a jam ka nuru maŋ a kasim jam a yaali ayen wa a tom wie ŋaai ale ka wamaŋsa la. Wa an jam a yaali ayen wa pa Mɛɛri a nyo chivie po nuruma nimbie. Dila nyiŋ la wa yaa jam a yaali ayen wa suk a zɛri wa. ");
INSERT INTO bwu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ase Josefi ale diem jam boro a poli wieŋa de la, da yeŋ po wa yaa nya Naawen sabiilowa goadaasima po. Sabiilowa yaa weeni wa ayen, “Fi Josefi waai ale ka naawa Deevid ŋaaŋbiik la, kan te fi kpaziim a nagi ale Mɛɛri fi yenni ta kulika, dii nyiŋ la ka Naawen Chiika ale basi ate wa ta puuka. ");
INSERT INTO bwu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nipowa de Mɛɛri le biak ka nidɔabili. Ku a fe kama ayen fi te wa yue ayen Yeezu dii nyiŋ la, ka wala le wa vari wa nuruma ba wabaataŋa po a basi.” ");
INSERT INTO bwu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nyaku de meena jam nyɛ kama ayen ku sak ayen dii ate Naawen biisiteerɔma po wanyiwa a jam ŋmarisi Naawen gbaŋka po dila po dila po la a chim wensie. ");
INSERT INTO bwu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Wa jam ŋmarisi ayen, “Ka nipɔkbili dii ale kan diem seba nidɔa la, le wa yik puuk a biak nidɔabili, ate ba te wa yoi ayen Emanuel”, (yonni de kiri ale “Naawen a bo ale ti kama”). ");
INSERT INTO bwu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josefi a yaa le yiti wa goomu jigini la, wa yaa deri nyɛ dii ate Naawen sabiilowa poom weeni wa la, ale ge yaa ta Mɛɛri a kuli wa yenni. ");
INSERT INTO bwu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Wa le jam ta Mɛɛri a kuli la, wa an jam goa ale wa nyaya, ale ge ate wa taam ga biak wa biika. Wa le jam biak la, Josefi yaa te biika yoi ayen Yeezu. ");
INSERT INTO bwu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ba jam biak Yeezu ka Betilihem tɛŋka ate ka bo Judia po la. Va ŋala po, naab waai ale jam soa tɛŋ kala meena a nya la yue jam ale Ayerod. Da yeŋ po ate nuru baai ale jam seba chiŋmarisa kie la, a yaa jam nyini kori nummu po niŋniŋ a jam tɛŋ kaai ate ba a wi ayen Jerusalem la. ");
INSERT INTO bwu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ba le jam paari dula jigini la, ba yaa nya tɛŋ kala nuruba ba gela a yaa bek ba ayen, “Ka be ate ba biak biik kaai le ka jam chim Juuma naawa la? Tama nya ka wa chiŋmarika kori nummu po ate ti yaa va ka a cheena ayen ti zuli wa.” ");
INSERT INTO bwu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Naawa Ayerod ale wom ale nichamma a bek biika wie la, ku yaa deri a daani wa nna yegayega. Ku jam maari a daani Jerusalem demma meena me kama. ");
INSERT INTO bwu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ayerod yaa wi Juuma Puusika Yenni kpaŋŋa ale Juuma Sinsaŋŋa sagrɔma meena ate ba jam jigi yeŋ ate wa yaa bek ba ayen, “Ka be ate ba le biak waai ate Naawen jam weeni ayen wa le tom wa ate wa jam la?” ");
INSERT INTO bwu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ba yaa weeni wa ayen, “Ka Naawen biisiteerɔma po wanyi ale jam ŋmarisi Naawen gbaŋka po dila po dila po ayen ba le biak wa ka Betilihem tɛŋka kaai ale bo Judia po la. Wa pilim ŋmarisi ayen, ");
INSERT INTO bwu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ba le biak niŋdeero Betilihem tɛŋka po, ate wa a nya m nuruma Juuma zuk. Ka dila ale soa ate Betilihem chim tɛŋkpieŋ a gaam tɛŋ sii meena ale bo Judia po la.’ ” ");
INSERT INTO bwu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ayerod ale ga wom dii ate ba weeni la, wa yaa wi nicham baai ale nyini kori nummu po a jam la, ate ba dek ba nyiini jam wa jigi. Ba le jam la, wa yaa bek ba ayen, “Nama seba diipo ate ni piilim nya chiŋmarika la?” Ba yaa weeni wa ba le nya ka diipo la. ");
INSERT INTO bwu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Wa le ŋman wom wieŋa de me la, wa yaa weeni ba ayen, “Ni cheŋ Betilihem tɛŋka po a ga kpesi gisi nya ase biika bo ka be. Ni dan nya wa, ni ŋman pilim jam weeni mu, ate mi me cheŋ ga maa nya wa abe m zuli wa.” ");
INSERT INTO bwu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nichamma yaa yiti cheŋ Betilihem tɛŋka. Ba le jam bo siuku po a cheŋ la, ba yaa ŋman nya chiŋmarika, kaai ale jam nyini kori nummu po la, ate ka de ba niŋ, a ta ba ga zaani juijui ate biika Yeezu a jam boro la zuk. ");
INSERT INTO bwu_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ba le ga nya chiŋmarika ale ka za dula jigini la, ba sue yaa deri peenti nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ba yaa ga jo yenni po a nya biika ale wa mawa Mɛɛri ate ba yaa kpi dunduna tɛŋ dula jigini a te wa zula, ale ge yaa lagi ba foritaŋa a yeeri ba tiirimu a te wa. Ba jam ta ka ligmɔniŋ, ale “ferankinsense” ate ku a nyɛ ase zauŋkunuŋ la, ale “muur” kpa buui nyum ale masa la. Ba le nyɛ dila a ga nueri la, ba yaa cheŋ ayen ba vuusi. ");
INSERT INTO bwu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ba le diem jam dua a vuusi la, Naawen yaa jam weeni ba, ba goadaasima po ayen, “Ni kan ŋman pilim cheŋ naawa Ayerod jigiya.” Nichamma ale yiti la, ba yaa va siuk yoŋ a taam kuli ba dek tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ba le cheŋ ga nueri la, Josefi yaa ŋman nya Naawen sabiiloma po wanyi wa goadaasima po, ate wa weeni Josefi ayen, “Ayerod a gisi biika ayen wa ko kama. Yiti nna nwuli a ta biika ale ka mawa chali cheŋ tɛŋ kaai ate ba a wi ayen Ejipiti la. Ni dan ga paari dula jigini, ni kasim boro ate ku ga paari diipo meena ate mi ayen m weeni ni, ate ni ŋman pilim jam dela la.” ");
INSERT INTO bwu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Sabiilowa ale weeni dila nueri la, Josefi yaa deri yiti yok diipo nna nwuli a ta biika ale ka mawa a chali cheŋ Ejipiti. ");
INSERT INTO bwu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ba noa batawa meena jam bo ka dula jigini a ta ga paari diipo ate Ayerod a kpi la. Ba jam nyɛ dila kama, ayen Naawen biisiteerɔma wanyiwa ale jam ŋmarisi dii Naawen gbaŋka po la a sum jam chim wensie. Wa jam ŋmarisi kama ayen Naawen weeni ayen, “M wi m biika kama a ta nyini Ejipiti po a nyini.” ");
INSERT INTO bwu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ayerod ale miŋi ayen nichamma paasi wa kama la, wa sui yaa jam kaasi nna yegayega, ate wa yaa wi wa sojima ate ba jam wa jigi, ate wa yaa tom ba ayen ba nyini cheŋ Betilihem tɛŋka ale tɛŋ sii meena ale gilim ka la a yik bisii meena ale ka nidɔabilisa an gaam bena ŋaye la a ko. Wa lueri bisila kama dii nyiŋ la wa wom nichamma jigi kama ayen ba ale piilim nya chiŋmari ka la ku ka bena ŋaye. ");
INSERT INTO bwu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Sojima yaa le ko bisaŋa a nueri la, dii ate Naawen biisiteerɔwa Jerimaya weeni la, a yaa jam sum chim wensie. ");
INSERT INTO bwu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Wa jam weeni kama ayen, “Nuruba ale wom kaarik ale ka a kaari Arama tɛŋka. Ti makpieŋka Arekel ale a kaari wa bisa nyiŋ. Ba meena a kpi kama. Waai karo a baga a nyɛ ate wa sunni a yɔgi.” ");
INSERT INTO bwu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ayerod ale jam kpi la, Naawen sabiilo yaa ŋman pilim cheŋ Josefi jigi Ejipiti. ");
INSERT INTO bwu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","A yaa weeni Josefi wa goadaasima po ayen, “Naawa ale a yaali ayen wa ko fi biika la, kpi kama. Yiti pa biika ale ka mawa a ta ba a ŋman pilim cheŋ Izirali.” ");
INSERT INTO bwu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Dula jigini Josefi yaa yiti a ta ba ŋman pilim cheŋ ba tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ba le ga paari Izirali la, ba yaa wom ayen Ayerod biika, waai ate ba jam a wi wa ayen Akilayasi la, ale ŋman de Judia naamu. Wieŋa de meena yaa jam basi ate Josefi kpaziim a nagi ale dula jigini boka, ate Naawen yaa ŋman biisi ale wa wa, goadaasima po ");
INSERT INTO bwu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ayen, wa cheŋ ga se wa yenni tɛŋ kaai ate ba a wi ayen Nazaret ate ka bo Galili la, po. Josefi ale ga nyɛ dila la, dii ate Naawen biisiteerɔma jam weeni dila po dila po la, yaa jam chim wensie. Ba jam weeni kama ayen, “Nuruba le jam wi Naawen biika ayen ka Nazaret deno.” ");
INSERT INTO bwu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Va ŋala po nuru wanyi ale jam boro ate ba a wi wa ayen Jɔɔn. Da yeŋ, wa yaa yiti a cheŋ ga jo Judia goanni po a boro a sak nuruba Naawen wie ale a te ba soka me ale nyiam. ");
INSERT INTO bwu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Wa yaa weeni ba ayen, “Ni meena basi ni wabaataŋa abe ni ge va Naawen siuku, dii nyiŋ la, Naawen naamu a mɔata kama.” ");
INSERT INTO bwu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Naawen biisiteerɔwa waai ate ba jam a wi ayen Azaya la, a jam ŋmarisi Jɔɔn wie kama a nyo Naawen gbaŋka po dila po dila po ayen, “Nuru ale bo goanni po a mooli ayen, ‘Ni gomsi Nyɔnɔwa siuku abe ni yuarisi ku.’ ” ");
INSERT INTO bwu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ba jam pa ka laalaakomi kobta a nyɛ Jɔɔn gataŋa, wa jam pa ka chiakgbain me a bobi wa chiaka. Wa jam a ŋobi ka tintue ale a de siita me. ");
INSERT INTO bwu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nuruba yegayega yaa jam nyini Jerusalem tɛŋka ale Judia tɛŋsaŋa meena ale tɛŋ sii meena ale jam za gilim beli dii ate ba a wi ayen Jodan la noai la, a cheŋ Jɔɔn jigi ayen ba wom wa sinsaŋŋa. ");
INSERT INTO bwu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ba le ga wom wa wieŋa la, ba yaa deri siak ayen ba ka wabaata nyam ale basi ate Jɔɔn a ta ba a siŋ Jodan benni po a te ba soka. ");
INSERT INTO bwu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Da yeŋ ate, Jɔɔn yaa nya Juuma baai ate ba jam a wi ayen Farisiiba ale baai me ate ba jam a wi ba ayen Sajusiba la yegayega ale ba cheena wa jigi ayen wa te ba soka. Wa yaa weeni ba ayen, “Ni a nyɛ ase ka wiiga la. Ka wana ale weeni ni ayen Naawen le jam ta supuurim ale ni abe wa te ni waalika ate ni yaa chali a sugi? ");
INSERT INTO bwu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ni be basi ni wabaataŋa abe ni a nyɛ wamaŋsa ate ku sak nuruba ayen ni sum tagri kama ni suniima po. ");
INSERT INTO bwu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ni kan a poli ayen ni le ka Abraham ŋaaŋbisa la, kula le baga a tagri ni wabaataŋa. Ni basi ate m weeni a sak ni ayen Naawen dek baga kama a pa tintanaŋa de a nyɛ ate ŋa a chim Abraham ŋaaŋbisa. ");
INSERT INTO bwu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nama a nyɛ ase ka tiib sii ale kan a yoani la. Naawen poom saasi wa lakpieŋka a magsi kama ayen wa che ni a lonsi tɛŋ abe wa pisi ni a ta ga nyo bolim po. ");
INSERT INTO bwu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mi, Jɔɔn, pa ka nyiam a te ni soka ate ku a sak nuruba ayen ni basi ni wabaataŋa kama. Nuru wanyi ale bo mi ŋaaŋ cheena. Wa le jam pa Naawen Chiika ale bolim a te ni soka. Wala pagra kama a gaam mi. Mi posima kama ale m nin ji wa nuensaŋa. ");
INSERT INTO bwu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wala le pa ka doalaadi a fobi wa zaaŋa. Wa dan fobi nueri, wa yaa le yaliŋa kama abe wa pa zabeeŋa a nyo wa bunni po ale ge vottaŋa a pa nyo bolim buui ate nuru waai an baga a kpimsi la po.” ");
INSERT INTO bwu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Va ŋala po Yeezu a yaa basi Galili ale ge cheŋ Jodan benni po ayen Jɔɔn te wa soka nyiamu po. ");
INSERT INTO bwu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jɔɔn ale ga nya Yeezu la, wa yaa zɛri ayen wa kan te wa soka ale ge weeni wa ayen, “Ku an magsi ayen fi jam mi jigi ate mi a te fu soka, alege ku a magsi kama ayen fi a te mi soka.” ");
INSERT INTO bwu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yeezu a yaa weeni wa ayen, “Fi te mi soka, dii nyiŋ la ku ka Naawen dek yaalika ayen fi nyɛ dila.” Jɔɔn a yaa siak. ");
INSERT INTO bwu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jɔɔn ale te wa soka a nueri ate Yeezu a yaa nyini nyiamu sunsuŋ a jueli la, wa yaa deri nya wenŋmazuk ale ku lagri ate wa nya Naawen Chiika a siŋ jam kali wa zuk ase nangbaŋ la. ");
INSERT INTO bwu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nuru baai ale jam za dula jigini la, a yaa wom lueluk ate ku nyini wenŋmazuku po a weeni ayen, “Ka mi biik kaai ate m mariŋ la ale nna. M sui a peenti ale wa ka nna yegayega.” ");
INSERT INTO bwu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Da yeŋ ate Naawen Chiika yaa jam de Yeezu niŋ a ta wa cheŋ ga jo sagini po, dii nyiŋ la ka Velinvendika ale jam a yaali ayen wa tu Yeezu dula jigini a nyɛ wa nya. ");
INSERT INTO bwu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yeezu ale jam bo sagini po la, wa an jam de ŋandiinta a ta ga paari daa pisinaansi, ate kom yaa jam ta wa nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Velinvendika yaa jam wa jigi a weeni wa ayen, “Fi dan sum ka Naawen biik, be nyɛ ate tintanaŋa de a chim boroboruk a te fu.” ");
INSERT INTO bwu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yeezu yaa tulisi ayen, “Ba ŋmarisi Naawen gbaŋka po kama ayen, ‘Nurubiik an boro ka ŋandiinta nyiini nyiŋŋa, alege wa boro ka wari dii meena ale a nyini Naawen noai po a nyini la nyiŋ.’ ” ");
INSERT INTO bwu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Velinvendika yaa ŋman ta Yeezu cheŋ tɛŋ weleŋka Jerusalem a ta wa ga jueli zaani Juuma Puusika Yenni zukparuku a, ");
INSERT INTO bwu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","yaa weeni wa ayen, “Fi dan sum ka Naawen dek biik, be nyini yenni de zuk a yok zi tɛŋ ate m nya, dii nyiŋ la fi dek seba ayen ba ŋmarisi Naawen gbaŋka po kama ayen, ‘Wa le weeni wa sabiiloma baai ale gilim fu la, ate ba pa ba nisimaŋa a yik fu a tara, ate fi dan ga mɔata tɛŋka abe fi kan pa fi naŋsaŋa a fobi tanaŋa ate si toriŋi.’ ” ");
INSERT INTO bwu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yeezu yaa ŋman tulisi wa ayen, “Ba ŋmarisi Naawen gbaŋka po me kama ayen, ‘Ku a fe kama ayen fi kan nyɛ fi nyɔnɔwa Naawen a nya.’ ” ");
INSERT INTO bwu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Velinvendika yaa ŋman ta Yeezu cheŋ ga jueli guuk woŋ zuk a yaa dak tɛŋka meena tɛŋsaŋa ale si nalimu a sak wa, ");
INSERT INTO bwu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","a yaa le ge weeni wa ayen, “Fi dan siak ayen fi kpi duna tɛŋ mi niŋ a te mu zula, m le basi ate fi soa ŋantaŋa de meena ate m dak a sak fu la.” ");
INSERT INTO bwu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yeezu yaa ŋman tulisi wa ayen, “Sitaana, basi mi abe fi cheŋ du m tɛŋ. Ba ŋmarisi Naawen gbaŋka po kama ayen, ‘A zuli fi nyɔnɔwa Naawen abe fi a puusi a te wala nyiini.’ ” ");
INSERT INTO bwu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Velinvendika ale wom dii ate Yeezu a weeni la, wa yaa deri basi wa ale ge cheŋ. Naawen yaa tom sabiiloba ayen ba jam maari Yeezu. ");
INSERT INTO bwu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Da yeŋ ate nuruba yaa yik Jɔɔn a ta wa ga lik. Yeezu ale wom dii ate ba nyɛ la, wa yaa yiti cheŋ ga jo Galili po. ");
INSERT INTO bwu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Yeezu yaa ga va Nazaret tɛŋka po a gaam taam a ga bo Kapernaum tɛŋka, ate ka bo Zebulun ale Nafitali po a mɔata Galili mogi kpeeni noai la. ");
INSERT INTO bwu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yeezu jam cheŋ dula jigini kama ayen dii ate Naawen biisiteerɔwa Azaya a ŋmarisi Naawen gbaŋka po dila po dila po la, a chim wensie. Wa jam ŋmarisi ka, ");
INSERT INTO bwu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zebulun ale Nafitali wie ate si bo siuk kuui ale a cheŋ mogi kpeeni noai la. Si bo ka Jodan benni kauk kuŋkula la, Galili po. Nuru baai ale jam bo dula la a daa Juuba. ");
INSERT INTO bwu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nuru baai ale jam bo legi po la a yaa nya bolim kama. Bolim a yaa jam baai ale jam mɔata kum jigi la kama.” ");
INSERT INTO bwu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","A nyini da ŋala po a ta a cheŋ, Yeezu nyiem a jam kasim a sak nuruma kama ayen, “Ni basi ni wabaataŋa abe ni ge va Naawen wensie siuku. Naawen naamu a mɔata kama.” ");
INSERT INTO bwu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yeezu ale jam bo Galili mogi kpeeni noai a cheŋ la, wa yaa jam nya nuru ale wa suok ate ba a wi ba ayen Simon ale Andiru ale ba bo nyiamu po a yuk ba ŋmaasa dii la ba jam ka jum yigrisa. ");
INSERT INTO bwu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yeezu yaa zaani dula jigini a weeni ba ayen, “Ni jueli jam va mi ŋaaŋ. Nama a kasim yik ka juma a ta jam paari jinla, alege yɔgyɔgla de mi a pa ka tuim paali a te ni. Ayen ni nyɛ ate nuruba a jam va mi ŋaaŋ.” ");
INSERT INTO bwu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Wa le weeni ba dila a ga nueri la, ba yaa deri pa ba ŋmaasaŋa a basi ale ge jueli a va wa ŋaaŋ. ");
INSERT INTO bwu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Wa le ŋman ga cheŋ maga dek la, wa yaa ŋman nya nuru ale wa suok ate ba jam a wi ba ayen Jeemsi ale Jɔɔn. Ba jam ka nuru waai ate ba a wi ayen Zebedi la bisa. Ba le ba kowa a jam kala ka ba ŋaaruŋku po a gomsi ba ŋmaasaŋa a magsi. Yeezu yaa wi ba, ");
INSERT INTO bwu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ate ba me deri basi ba kowa ale ŋaaruŋku ale ge yiti a cheŋ ga va wa ŋaaŋ. ");
INSERT INTO bwu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Va ŋala po Yeezu kasim jam bo ka Galili po a nyeemu, ale a jo ba tuka diinaŋa po a sak nuruma Naawen wamaŋsaŋa wie a weeni ba ayen, Naawen naamu a mɔata kama. Wa jam maari a tebi yuariba me kama juijui meena ate wa jam boro la. ");
INSERT INTO bwu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yeezu wie yaa jam waaŋ a tagli tɛŋ kaai ate ba jam a wi ayen Siriya la po meena. Kula a jam basi kama ate baai meena ale jam bo tɛŋ kala po la, a jam ta ba yuariba a jam wa jigi ayen wa tebi ba. Chichiribaata ale jam bo ba gela zuima po, ba gela a lo kpiŋkpinsa, ate mba me nisima ale ba naŋsa a jam kpi. Yeezu a jam tebi ba meena kama. ");
INSERT INTO bwu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nuru bɔari yegayega a yaa jam nyini Galili tɛŋka ale Jerusalem ale Judia ale Dekapolis tɛŋsaŋa ale tɛŋ sii meena ale bo Jodan benni kuŋkɔŋini la, meena a jam va Yeezu ŋaaŋ. ");
INSERT INTO bwu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Da yeŋ ate Yeezu yaa nya nuru bɔari nna yegayega ate wa yaa ta wa ŋaaŋviirima a ga jueli guuk kunyi zuk a kali du. Wa ŋaaŋviirima a yaa jam tigsi a gilim wa, ");
INSERT INTO bwu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ate wa yaa piilim ba sakka. Yeezu yaa weeni ba ayen, ");
INSERT INTO bwu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Baai ale seba ayen ba an welema Naawen nimbie po la, a ta supeentik kama dii nyiŋ la, ba le de Naawen Naamu. ");
INSERT INTO bwu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Baai ale a kum la, a ta supeentik kama dii nyiŋ la, Naawen le basi ate ba sue yok. ");
INSERT INTO bwu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Baai me ale a zaab ba dek la, a ta supeentik kama dii nyiŋ la ba le nya ŋanta baai ate Naawen a puulim ayen wa le te ba la. ");
INSERT INTO bwu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Baai me ale kasim ta ku nyiŋbiiri ba suniima po ayen ba a tom dii ate Naawen a yaali la, a ta supeentik kama dii nyiŋ la, Naawen le te ba ŋanta baai ate ba a yaali la. ");
INSERT INTO bwu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Baai me ale kasim ta jiirim ale nuruba la, a ta supeentik kama dii nyiŋ la, Naawen le ta jiirim ale ba me. ");
INSERT INTO bwu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Baai me suniima ale lagri ale Naawen la, a ta supeentik kama dii nyiŋ la, wa le basi ate bala a nya wa. ");
INSERT INTO bwu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Baai me ale a maari nuruba ate ba ta noayeŋ ale chaab la, a ta supeentik kama, dii nyiŋ la Naawen le wi ba ayen wa bisa. ");
INSERT INTO bwu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Baai me ate nuruba a namsi ba nna yegayega ba ale a tom Naawen yaalika nyiŋ la, a ta supeentik kama, dii nyiŋ la, ba le de Naawen naamu. ");
INSERT INTO bwu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nuruba a dan a le ni, ale a namsi ni, ale a velimu a te ni, ni ale a va mi siuku la nyiŋ, ni basi ate ni sue a peenti. ");
INSERT INTO bwu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Siuk kula po ate nuruba a jam namsi Naawen biisiteerɔma baai ale jam boro dila po dila po la, nna yegayega. Ni tutuna a dua wenŋmazuk kama ate Naawen ayen wa te ni. Ni be ta supeentik. ");
INSERT INTO bwu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nama a nyɛ ase ka yesa la nurubiik meena jigi. Ase yesa dan jogi si masim, nuru karo a baga nyɛ ate si masimu a pilim a boro. Ku be dan nyɛ dila, nuruba a nya si ase ka yekayaata la, ate ba a pa si yuk a basi ate nuruba a tabi si zuk a taam. ");
INSERT INTO bwu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ni be a nyɛ me ase ka bolim ate ba tɔati ate bu a nya tɛŋka meena zuk la. Yeri dii ate ba se zaani guuk zuk la, jaab an baga a lik di.” ");
INSERT INTO bwu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nuru waai a karo a tɔati wa bolim a pa chin vuk bu a zaani. Nuru wala pa bu a zaani ka jaab zuk, ate bu a nya dɔkku po meena. ");
INSERT INTO bwu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Siuk kula po me, ku a fe ate nama me dek a basi ate nuru meena a nya ni tuimmaŋsaŋa, ate ba baga a pak ti kowa Naawen waai ale bo wenŋmazuk la. ");
INSERT INTO bwu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ni kan a poli ayen mi jam kama ayen m ko Moosis ale Naawen biisiteerɔma Sinsaŋŋa a basi. Mi an jam ayen m ko ŋa a basi, alege m jam kama ayen m basi ate nuruma a miŋ ba sinsaŋŋa wensie kiri. ");
INSERT INTO bwu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Wensie ate mi a weeni ni, nuru waai a kan baga a ko Sinsaŋŋa wafiik me la a basi, alege ate wenzuk ale tɛŋka meena a jam nueri. ");
INSERT INTO bwu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nuru waai a dan zɛri Naawen Sinsak fiisaŋa dinyi vaka alege a sak nuruba ayen ba me a zɛri, kula nyɔnɔ le jam wari ka ŋaaŋ Naawen naamu po. Nuru waai me a be dan va Naawen Sinsaŋŋa ale a sak nuruba ayen ba a va ŋa, wala le de ka niŋ Naawen naamu po. ");
INSERT INTO bwu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","M be a weeni ni kama ayen ni siaka a dan kan gaam Juuma Sinsaŋŋa sagrɔma, ale Farisiima ni waai a kan jo Naawen naamu po. ");
INSERT INTO bwu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ni wom ayen nuruba jam sak ni kokpieŋsaŋa dila po dila po ayen, ‘Kan ko nuru. Ase waai dan jam ko nuru, ba a yik wa kama a ta cheŋ boteka yenni’. ");
INSERT INTO bwu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Alege mi a weeni ni kama yɔgyɔgla de ayen nuru waai sui a dan puuri ale wa suok ba a yik wa kama a ta a cheŋ boteerɔwa jigi. Nuru waai me a dan weeni wa suok ayen wa ka kiriya, ba a yik wa kama a ta a cheŋ boteerɔma jigi. Nuru waai me a be dan weeni wa suok ayen wa ka beruk, Naawen a le pa kula nyɔnɔwa a nyo bolim buui ale kan maari a kpimsi la po. ");
INSERT INTO bwu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ni nyiem dan a yaali ayen ni pa tiirim a te Naawen wa puusika yenni po, alege ni ŋman teeri ayen ni sue a puuri ale ni suaata wie nyiŋ, ");
INSERT INTO bwu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ni pa ni tiirimu a dueni puusika yenni po abe ni ga ate nama ale ni suaataŋa a biisi a niak chaab. Ni dan nyɛ dila a nueri, ni yaa ŋman pilim cheŋ a ga pa ni tiirimu a te Naawen. ");
INSERT INTO bwu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nuru waai a dan ta ni a cheŋ boteka yenni, ni basi ate nama ale kula nyɔnɔ a biisi a niak chaab siuku po. Ni dan kan nyɛ dila ale ge ate ni paari ku jigini, wa le ta ni kama a ga nyo boteerɔma wanyi nisima po ate boteerɔwa a pa ni a te soji ate wa ta ni a ga lik dɔk po. ");
INSERT INTO bwu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mi ale a weeni ni ayen nama a le kasim a bo ka dula jigini ate ni ga tuni ni pamaŋa meena a nueri abe ba lagi ni. ");
INSERT INTO bwu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nama a wom ayen nuruba a sak ni kokpieŋsaŋa dila po dila po ayen ba kan nyɛ kaboŋsa. ");
INSERT INTO bwu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Alege mi a weeni ni kama yɔgyɔgla de ayen nuru waai a dan nya nipɔk a yaali ayen wa goa ale wa, kula nyɔnɔ a nyɛ ka kaboŋ wa sunum po. ");
INSERT INTO bwu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Fi juga nummu a dan a nyɛ ate fi a nyɛ wabaata, yeeri bu a yuk basi. Fi dan jok fi nyiŋka kauk a zunchoŋ Naawen ale yuk fi nyiŋka meena a nyo bolim buui ale kan maari a kpimsi la po. ");
INSERT INTO bwu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Fi juga nisaŋa me a dan a nyɛ ate fi a nyɛ wabaata, gebi si a yuk basi. Fi dan jok fi nisaŋa sinyi a zunchoŋ Naawen ale yuk fi nyiŋka meena a nyo bolim buui ale kan maari a kpimsi la po. ");
INSERT INTO bwu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Nuruba a ŋman sak ba me dila po dila po ayen nuru waai a dan zɛri wa pɔk, ku a fe ate wa ŋmarisi gbaŋ ate ku sak nuruba ayen wa zɛri wa kama. ");
INSERT INTO bwu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Alege mi a weeni ni kama yɔgyɔgla de ayen nuru waai a dan zɛri wa pɔk, alege daa ayen wa a yaali ka nidɔaba, ate wa yali nidɔa wa choa, ka wa dek ale basi ate wa powa a tom kaboŋsa tuima. Nuru waai me ale a faari wa la a nyɛ ka kaboŋ. ");
INSERT INTO bwu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Nama a wom ayen nuruba a sak ni kokpieŋsaŋa dila po dila po ayen ba dan puulim ayen ba nyɛ wari ba kan basi di nyeka alege ku a fe ate ba nyɛ dii ate ba puulim ale nyɔnɔwa la. ");
INSERT INTO bwu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Alege mi a weeni ni yɔgyɔgla de ayen ni dan a puulim, ni kan pe. Ni kan pe wenŋmazuk yoi nyiŋŋa dii nyiŋ la Naawen boka jigi ale la. ");
INSERT INTO bwu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ni be kan pe tɛŋzuk meena yoi nyiŋŋa, dii nyiŋ la ka Naawen naŋsa tabika jigi ale la. Ni be kan pe Jerusalem tɛŋka yoi nyiŋ me, dii nyiŋ la ka nakpioŋku boka jigi ale la. ");
INSERT INTO bwu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni be kan pe ni zuima yoi nyiŋŋa, dii nyiŋ la nama an baga a tagri zuyeŋ ate ka a chim zupeelik yaase zusɔbliga. ");
INSERT INTO bwu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ni dan nyɛ wari ate ba bek, ni siak ayen ni nyɛ kama, ni be dan kan nyeya weeni ayen ni an nyeya. Ni dan biisi a gaam nyaku de, ni wieŋa meena a nyini ka Velinvendika jigi. ");
INSERT INTO bwu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nama a wom ayen nuruba a sak ba dila po dila po ayen, ‘Nuru waai a dan yeeri fi num, fi me a yeeri wa me nummu. Nuru waai, a dan voori fi nyini, fi me a voori wa me nyini.’ ");
INSERT INTO bwu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Alege mi a weeni ni kama yɔgyɔgla de ayen nuru waai a dan nyɛ ni a kaasi, nama me abe kan ŋman a nyɛ wa dila degadega. Nuru waai a dan fɔbi fi juga tapiaka, fi basi ate wa fɔbi gala tapiaka. ");
INSERT INTO bwu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nuru waai a dan ta fu a cheŋ boteka yenni fi garuk nyiŋ, fi be ŋman a pa fi garuk kpioŋ a gum du a te wa. ");
INSERT INTO bwu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nuru waai a dan daani fu ayen fi ji wa koalima a ta cheŋ mɛɛli dinyi, fi be ji a ta cheŋ mɛɛla ŋaye a te wa. ");
INSERT INTO bwu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nuru waai a dan juisi ni jaab, ni pai a te wa. Nuru waai a dan a yaali ayen wa piem jaab ni piem a te wa. ");
INSERT INTO bwu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nama wom ayen nuruba a sak ni kokpieŋsaŋa dila po dila po ayen, ba a yaali ba dɔaba abe ba a kisi ba dachaasa. ");
INSERT INTO bwu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Alege mi a weeni ni kama yɔgyɔgla de ayen ni a yaali ni dachaasaŋa abe ni a tom tuimmaŋsa a te ba. Ni a puusi a te Naawen ate wa a maari baai ale a namsi ni nna yegayega la. ");
INSERT INTO bwu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nama a dan a nyɛ dila, Naawen waai ale bo wenŋmazuk la, a le basi ate ni chim wa bisa. Wa nyɛ wenbinni ayen di a nyagsi nuru baata ale nuru maŋsa zuk ale basi ate ŋmoruku a ni baai ale a nyɛ wabaata ale baai me ale a nyɛ wamaŋsa la zuk. ");
INSERT INTO bwu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ni dan a yaali baai ale a yaali ni la nyiini, Naawen ayen wa nyɛ ka se a pa wa tiirimu a te ni? Lampoo cheesiroma me a yaali baai ale a yaali ba la kama. ");
INSERT INTO bwu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ni dan a puusi ni dɔaba nyiini, nama a nyɛ ka boa a gaamu nuruba ale a nyɛ dii la? Baai ale kan seba Naawen la a puusi ka dila. ");
INSERT INTO bwu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ni a nyɛ wamaŋsa ase ni kowa Naawen waai ale bo wenŋmazuk, ale a nyɛ wamaŋsa dii la. ");
INSERT INTO bwu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ni dan tom tuimmaŋsa a te nuruba, ni kan a nyɛ ŋa a lagri ate nuru meena a nya ŋa. Ni dan a nyɛ dila, ni kan baga a tuesi tutuna ŋaai ate ni kowa Naawen waai ale bo wenŋmazuk a yaali ayen wa te ni la. ");
INSERT INTO bwu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ni dan pai jaab a te nuru waai kan mooli a sak nuruba ase venta nyamma ale a nyɛ dii ba tuka diinaŋa po ale yabaŋa po la. Ba a nyɛ dila ayen ka nuruba a pak ba. Bala chaama poom tuesi ba tutuna kama. ");
INSERT INTO bwu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ni dan a maari nuru waai ni kan basi ate ni doa maŋsa a poom seba ku noai po. ");
INSERT INTO bwu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ni dan a suk a nyɛ dila, ni Kowa Naawen, waai ale a nya dii ate ni a nyɛ la ale tuni ni. ");
INSERT INTO bwu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ni dan puusi a te Naawen, ni kan a puusi ase venta nyamma ale a puusi dii la. Bala chaama a yaali ayen ba nyiem zaani ka ba tuka diinaŋa po yaase yabaŋa po a puusi ate nuruba a nya ba. Mi ale a weeni ni ayen ba poom tuesi ba tutunaŋa kama. ");
INSERT INTO bwu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Alege ni dan a yaali ayen ni puusi a te Naawen, ni jo ni diinaŋa po ni dek ni nyiini abe ni lik ni tuaataŋa a puusi a te ni kowa Naawen, waai ate ni kan nya wa la. Ate ni Kowa, waai ale a nya ni la a te ni jaab buui ate ni a yaali la. ");
INSERT INTO bwu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ni dan puusi a te wa, ni kan a biisi wie nna yegayega ate ŋa ka kiriya ase bogluk kaarisaŋa ale a nyɛ dii la. Ba a poli kama ayen biik yegayega ale basi ate ba bogtaŋa a wom ba. ");
INSERT INTO bwu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ni abe kan a nyɛ ase bala la. Ni Kowa Naawen a poom seba jaab buui ate ni a yaali wa jigi la kama ale ge ate ni a bek wa. ");
INSERT INTO bwu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ni be puusi a te Naawen ase nnala la. ‘Ti Ko Naawen, fi waai ale bo wenŋmazuk la, Basi ate fi yoi weleŋka a yiti ate fi nya zula. ");
INSERT INTO bwu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Fi naamu abe jam, ate fi ale a yaali dii la, a nyɛ tɛŋzuk de, ase ku le ka dii wenŋmazuk la. ");
INSERT INTO bwu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Te ti jinla de ŋandiin tii ate ti a yaali la. ");
INSERT INTO bwu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Voŋ ti wabaata a te ti ase tama ale voŋ a te chaab dii la. ");
INSERT INTO bwu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kan basi ate ti jo nyenyaka po, abe fi vari ti Velinvendika jigi a basi.’ ");
INSERT INTO bwu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ni dan voŋ a te baai ale nyɛ ni a kaasi la, ni Kowa Naawen, waai ale bo wenŋmazuk la, a le voŋ a te nama me. ");
INSERT INTO bwu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ni be dan kan voŋ a te baai ale nyɛ kaasi ni la, ni Kowa Naawen me a kan voŋ a te ni. ");
INSERT INTO bwu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ni dan boro a bobi noa, ni kan kaasi ni nimbeeŋa ase venta nyamma ale a nyɛ dii la. Ba a kaasi ba nimbeeŋa kama ayen waai meena nya ba ale bobi noa la. Mi ale a weeni ni, ba poom nya ba tutunaŋa kama dera. ");
INSERT INTO bwu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ni dan bobi noa, ni be puuri ni nimbeeŋa abe ni chaasi ni zuimaŋa, ");
INSERT INTO bwu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ate nuruba a kan baga a seba ayen ni bobi ka noa. Ni Kowa Naawen waai ale a nya dii meena ate ni a sugi a nyɛ la, wa le te ni ni tutunaŋa. ");
INSERT INTO bwu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ni kan pa ŋanta yegayega a dueni tɛŋzuk de, ate miari a de kaasi, yaase nyiam a siŋ ba po a kaasi ba, yaase zueba a we a jo du a zu ba. ");
INSERT INTO bwu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Alege ni pa ni ŋantaŋa yegayega a dueni wenŋmazuk. Miari ale nyiam a kan baga a kaasi ba dula jigini. Zueba me a kan baga a we jo dula jigini a zu ba. ");
INSERT INTO bwu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ni popola meena a bo ka juijui ate ni ŋantaŋa yegayega a boro la. ");
INSERT INTO bwu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Nimbeeŋa a nyɛ ase ka bolim la a te nyiŋka. Nimbeeŋa a dan nala nyiŋka an bo legi po. ");
INSERT INTO bwu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Alege ni nimbeeŋa a dan kan nala nyiŋka a bo ka legi po. Ase bolim buui ale bo ale ni la dan ka legi, legi dila bie kama yegayega. ");
INSERT INTO bwu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Nuru yeŋ an baga a tomu a te kpaga ŋaye, dii nyiŋ la ku a fe kama ate wa a yaali wanyi abe wa kisi nwala. Wa le ta siaka ale wanyiwa abe wa a zɛri nwala noai. Siuk kula po me, ni kan baga a tomu a te Naawen abe ni ŋman yaali ligra a gum du. ");
INSERT INTO bwu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ku de nyiŋ mi a weeni ni ayen ni kan te ku a daani ni, ni le ni nyɛ dii a nya ŋandiinta ale nyiam ate ni baga boro la, yaase gatta a jo la. Ni nyuvooŋa an gaam ŋandiinta ale gatta? ");
INSERT INTO bwu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ni nya nuinsaŋa sii ale bo wenŋmazuku a yiti la. Si kan kpa talita yaa si a che za a pa ŋa a nyo bua po. Ni Kowa Naawen waai ale bo wenŋmazuk la ale a nya si zuk. Nama an gaam nuinsaŋa? ");
INSERT INTO bwu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ni waai baga a nyɛ ate wa bena a woŋa a gum du wa yiila nyiŋŋa? ");
INSERT INTO bwu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ka boa ate ku a daani ni gatta nyaka nyiŋŋa? Ni nya wuutaŋa puutaŋa ale ka dii la. Ti kan tom tuima a baali gatta a te ti dega. ");
INSERT INTO bwu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Alege mi a weeni ni, ni teeri Juuma naawa waai ate ba jam a wi wa ayen Solomon la. Wa jam ka nuru waai ale jigsi a gaam ba meena dila po dila po alege wa an jam a jo gatta ate ti nala a soa se wuutaŋa de puutaŋa la. ");
INSERT INTO bwu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ka Naawen ale a te wuutaŋa gatta. Ti kan kasim a boro a beni, dii nyiŋ la wenkarik a nyiem a dan paari, bolim ale a de ti. Nama a gaam wuutaŋa kama Naawen nimbie po. Dila nyiŋ la, wa an baga a te nama gatta? Ni siaka an zuaya. ");
INSERT INTO bwu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ni be kan a daani ni dega abe ni a weeni ayen, ‘Ti te nyɛ ka se a nya ŋandiinta a de? Ti te nya nyiam ka be a nyu yaase ti te nya gatta ka be a jo?’ ");
INSERT INTO bwu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Baai ale kan daa Juuba la a nyiem a kasim a yaali ka ŋantaŋa de chaama, alege ni Kowa waai ale bo wenŋmazuk la, a seba ayen nama a yaali ba kama. ");
INSERT INTO bwu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ni basi ate ni niŋ a bo ale Naawen naamu ale wa le a yaali ayen ni a tom dii a te wa la a gaam jaab buuri meena ate wa yaa te ni jaab buuri meena ate ni a yaali la. ");
INSERT INTO bwu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nyaku de nyiŋ ni kan basi ate chum wie a daani ni. Daaŋa meena a ta wie kama ate ŋa a daani. Kan ŋman yaali daanika a gum danni ale ta daani kaai la po. ");
INSERT INTO bwu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ni be kan a bo ni chaab buusa ate Naawen kan bo nama me buusa. ");
INSERT INTO bwu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nama ale a bo ni chaab buusa dii la, Naawen me ale bo ni buusa ka dila degadega. Ni ale pai dii a nyɛ, ale nuruba la, Naawen me ale pai dila degadega a nyɛ ale ni. ");
INSERT INTO bwu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ka boa ale soa ate ni a nya yaata ni suaata nina po alege kan kpesi da tii ale bo ni dek ninaŋa po la? ");
INSERT INTO bwu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ka boa ale soa ate nama a weeni ni suaataŋa ayen, ‘Ni basi ate ti yeeri yaata ni ninaŋa po’, alege daata a bo nama dek ninaŋa po? ");
INSERT INTO bwu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nama a paasi ka ni dek. Ni be liŋ a yeeri da tii ale bo ni dek ninaŋa po la, ale ge ate ni baga a nya yeeri yaataŋa ni suaataŋa ninaŋa po. ");
INSERT INTO bwu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ni kan a pa ŋan maŋsa a te baasa, dii nyiŋ la si le chiem a dom ni. Ni kan pa ni ŋanta baai ate ba nyaka a tua la a dueni die niŋŋa, dii nyiŋ la ŋa le tabi ba zuk a kaasi. ");
INSERT INTO bwu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ni dan puusi a bek Naawen ayen wa te ni jaab, wa le te ni. Ni dan a yaali jaab wa jigi, ni le nya. Ni dan wi wa wa tuoku noai, wa le siak abe wa lak a te ni. ");
INSERT INTO bwu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Baai meena ale a puusi a bek Naawen ayen wa te ba ŋanta la, wa le te ba. Baai meena me ale a yaali ŋanta wa jigi la, ba le nya ba. Baai ale a wi wa wa tuoku noai la, wa le wom ba abe wa lak a te ba. ");
INSERT INTO bwu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nama baai ale ka koba la, kom a dan ta fi biik ate wa a yaali boroboruk, fi le pai tintain a te wa. ");
INSERT INTO bwu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Wa dan a yaali jum fi le pai waab a te wa? ");
INSERT INTO bwu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nama ka nuru baata, alege ni seba ŋan maŋsa a pa a te ni bisaŋa. Ni kowa Naawen, waai ale bo wenŋmazuk la, a baga a te baai ale a puusi a te wa la, ŋan maŋsa kama. ");
INSERT INTO bwu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ni a tom tuimmaŋsa a te ni suaataŋa ase nama ale a yaali ayen ba tom dii a te ni la. Moosis ale Naawen biisiteerɔma Sinsaŋŋa kiri ale la. ");
INSERT INTO bwu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ni va tuok kuui ale migla la a jo, dii nyiŋ la tuok kuui ale a jo bolim buui ale kan maari a kpimsi la jigini a lagri kama. Ate siuk kuui ale a cheŋ du la po chelim an tua. Nuruba yegayega abe le a va ku. ");
INSERT INTO bwu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Alege siuk kuui ale a jo nyuvuri dii ale kan ta kpeglimka jigini la po chelim tua kama. Nuruba maga ale nya siuk kula a va. ");
INSERT INTO bwu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ni kpesi a nya venta biisiteerɔma. Ba dan jam ni jigi, ba a nyɛ ase ka piisa la, alege ba suniimaŋa po ba a nyɛ ase ka piina la. ");
INSERT INTO bwu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ni le seba ba ale ka baai la ba tuima nyiŋ. Zaauŋ an baga a yoani tuita, fetiib me an baga a yoani chaama. ");
INSERT INTO bwu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Timaŋ a yoani ka yoana dek. Tibiok me a yoani ka yoan baata. ");
INSERT INTO bwu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Timaŋ a kan yoani yoan baata. Tibiok me an baga a yoani yoana dega. ");
INSERT INTO bwu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ti buui ale kan a yoani yoan maŋsa la, ba a che bu kama a yugi a basi bolim po ate bu a de. ");
INSERT INTO bwu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Dila la ni le seba venta biisiteerɔma ba tuimaŋa nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ku daa waai meena ale a wi mi ayen, ‘Ti Nyɔnɔ’ la ale ba nya siuk a jo mi naamu po, alege ka baai nyiini ale a tom dii ate mi Kowa Naawen waai ale bo wenŋmazuk a yaali la, bala le ba jo wa naamu po. ");
INSERT INTO bwu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wa dan jam ayen wa bo tɛŋka meena demma buusa, nuruba yegayega a le weeni wa ayen, ‘Ti Nyɔnɔ, tama a sak nuruba kama fi wamaŋsaŋa wie fi yonni nyiŋ. Ti be ŋman pa fi yonni nyiŋ a yiak chichiribaata nuruba zuima po a basi. Ti be pa fi yonni nyiŋ me a tom wakperikaliisa nna yegayega.’ ");
INSERT INTO bwu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ba dan biisi a nueri, mi le weeni ba ayen, ‘Mi ze ni. Nama baai ale tom wabaata la, ni cheŋ du mi tɛŋ.’ ");
INSERT INTO bwu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Waai meena ale a wom mi wieŋa de ale a va ŋa la, bala a nyɛ ase ka yam nyɔnɔ waai ale se wa yeri a zaani pinjaaliŋ zuk la. ");
INSERT INTO bwu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Dai yeŋ po ate ŋmoruk a yaa jam ni nna yegayega ate viok kpioŋku me a fɔbi wa yenni ate belaŋa a sueri a nyini, alege di an loya dii nyiŋ la yenni nyɔnɔwa a se di ka pinjaaliŋ zuk. ");
INSERT INTO bwu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Waai meena ale a wom mi wieŋa de alege kan va ŋa la, bala a nyɛ se ka beruk kuui ale se ku yeri a zaani tambusuŋ zuk la. ");
INSERT INTO bwu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Dai yeŋ po ate ŋmoruk a yaa jam ni nna yegayega ate va kpioŋku me a fɔbi wa yenni ate belaŋa a sueri a nyini, ate di yaa deri lo burummm.” ");
INSERT INTO bwu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yeezu ale biisi wieŋa de meena a nueri la, ku yaa cha nuru bɔanni meena wa sinsaŋŋa nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Wa sak ba kama ale wa dek pagrim. Wa ale a sak ba dii la ale Juuma Sinsak sagrɔma sakka a jam daa wayeŋŋa. ");
INSERT INTO bwu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yeezu ale jam nyini guuku zuk a siŋ la, nuru bɔari yegayega a yaa va wa. ");
INSERT INTO bwu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Gami dinyi a yaa yiti a cheŋ ga kpi duna tɛŋ wa niŋ a saalim wa ayen, “M Nyɔnɔ, be tebi m tuemu de a te mu ase fi nin a yaali.” ");
INSERT INTO bwu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yeezu a yaa teeri nisa a tiri wa ale weeni wa ayen, “M tebi fu kama, dii nyiŋ la mi a yaali kama ayen fi nya nyiŋyɔgsa.” Wa ale weeni dila la, gamini tuemu a yaa deri basi wa ate wa nya nyiŋyɔgsa. ");
INSERT INTO bwu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yeezu a ŋman weeni wa ayen, “Kan weeni a sak waai ya, alege be cheŋ Juuma Puusika Yenni tomteerɔma wanyi jigi ate wa nya fu. Wa dan nya fu, be basi ate wa nyɛ kaabka a te fu ase ti kokpieŋka Moosis ale jam a sak ti dii dila po dila po la. Kula a le sak nuruba ayen fi tuemu a nueri kama.” ");
INSERT INTO bwu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yeezu ale ga paari Kapernaum tɛŋka la, sojiba kpagi dinyi a yaa jam tu wa a saalim wa ayen wa maari wa. ");
INSERT INTO bwu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Wa yaa weeni Yeezu ayen, “M Nyɔnɔ, m tomteerɔwa ale bo yeri ate wa naŋsa ale wa nisima kpi ate wa a nam nna yegayega.” ");
INSERT INTO bwu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yeezu yaa weeni wa ayen, “M le jam a nyɛ ate wa nya nyiŋyɔgsa.” ");
INSERT INTO bwu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Sojima kpagini a yaa ŋman weeni wa ayen, “Aaya, m Nyɔnɔ. Mi daa nuru waai ale magsi ayen fi jam m yenni la. Juijui ate ti za nna, fi dek a weeni fi wanni ate m tomteerɔwa a nya nyiŋyɔgsa. ");
INSERT INTO bwu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mi me ta nuruba baai ale ŋman ta pagrim mi zuk la kama, ale ta sojiba a nya ba zuk me. M dan weeni wanyi ayen wa cheŋ, wa a cheŋ kama. M dan ŋman weeni wa choa ayen wa jam, wa a jam kama. M dan weeni m tomteerɔwa ayen wa tom tuini a te mu, wa a tomu kama.” ");
INSERT INTO bwu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Wa ale weeni dii la, a yaa deri cha Yeezu nna yegayega. Wa yaa chiem weeni nuru bɔanni meena baai ale va wa la ayen, “Mi a weeni ni ka wensie, mi an nya nuru Izirali ate wa ta siaka ase nuruwa de la. ");
INSERT INTO bwu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ni wom mi wieŋa de nalimnyiini. Dai yeŋ po nuruba ale nyini konni ale yeniŋka geŋ a jam jo Naawen naamu po a de ŋandiinta ale Abraham, ale Aizik ale Jekob. ");
INSERT INTO bwu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Alege baai ale magsi ayen ba jo dula jigini la, Naawen ale yuk ba basi legini po, dula ba le kasim a kum kama ale a ŋobi nyina.” ");
INSERT INTO bwu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yeezu ale biisi nyaku de a nueri la, wa yaa ŋman cheemu sojima kpagini jigi a weeni wa ayen, “Kuli yeri. Fi ale ta siaka la nyiŋ, mi le nyɛ a te fu.” Wa tomteerɔwa a yaa deri nya nyiŋyɔgsa. ");
INSERT INTO bwu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yeezu a yaa cheŋ ga jo Piita yenni po a yaa nya ale wa ŋanuba a wiagi. Wa nyiŋ ale jam toliŋ ate wa doa dɔkku po. ");
INSERT INTO bwu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yeezu a yaa jo wa dɔkku po a tiri wa nisaŋa ate wa a deri nya nyiŋ yɔgsa. Wa yaa yiri yaali nyiam a te ba. ");
INSERT INTO bwu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Wein ale jam a siŋ la, tɛŋka demma a yaa ta yuariba ale baai ate chichiribaata a bo ba zuima po la a jam Yeezu jigi. Wa yaa pa wa wanni a yiak chichiribaataŋa nuruba zuima po a basi alege a tebi yuaroma meena. ");
INSERT INTO bwu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Wa nyɛ nyaku de kama ate ku sak ayen dii ate Naawen biisiteerɔwa Azaya a ŋmarisi Naawen gbaŋka po dila po dila po la a jam ka wensie. Wa jam a weeni ayen, “Wala dek le wa tuesi ti tuetaŋa meena.” ");
INSERT INTO bwu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yeezu ale nya nuru bɔanni ale ba gilim wa la, wa yaa weeni wa ŋaaŋviirima ayen ba cheŋ a ga gaam mogi kpeeni a taam jueli kauk kuŋkula. ");
INSERT INTO bwu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ase ba ale jam boro a gomsi ayen ba cheŋ la, Juuma Sinsak sagrɔma po wanyi a yaa jam Yeezu jigi a weeni wa ayen, “M Sagrɔ, m gomsi a magsi kama ayen m va fu a cheŋ juijui meena ate fi a cheŋ la.” ");
INSERT INTO bwu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yeezu a yaa weeni wa ayen, “Suemkparita a bo ka vie po ale ge nuinsa me a bo tugta po alege mi Saalobiika a ka jigiya a duagi a goa.” ");
INSERT INTO bwu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yeezu ŋaaŋviirima wanyi a yaa ŋman weeni wa ayen, “M Nyɔnɔ, mi me a yaali kama ayen m va fu, alege basi ate m liŋ a ga pa m kowa a gu.” ");
INSERT INTO bwu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yeezu a yaa weeni wa ayen, “Jam a va mi yɔgyɔgla de, abe fi basi ate baai ale kpi la a gu ba dek kpeema.” ");
INSERT INTO bwu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yeezu ale wa ŋaaŋviirima a yaa jo ŋaaruŋku po a cheŋ. ");
INSERT INTO bwu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ase ba ale jam a cheŋ la, va kpioŋ a yaa deri yiti a fuk nna yegayega. Ku yaa fɔbi nyiamu ate bu a yiti a nagi ŋaaruŋku ate bu gela me a jo ŋaaruŋku po ate ku a nyɛ ku siŋ nyiamu tɛŋ. Nyaku de meena ale jam a nyɛ la, Yeezu a jam doa ŋaaruŋku po a goa kama. ");
INSERT INTO bwu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Wa ŋaaŋviirima a yaa nagi wa a yiti a weeni wa ayen, “Ti Nyɔnɔ, tama a bo ka kum po. Vari ti a basi.” ");
INSERT INTO bwu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yeezu yaa yiti a begi ba ayen, “Ka boa ate nama a chali yɔgsumɔa? Ni siaka an soa diiya?” Wa yaa weeni vioku ayen ku basi alege weeni nyiamu me ayen bu baliŋ. Vioku a deri basi ate nyiamu me a baliŋ. Bu an ŋman a choa ale maga dek me. ");
INSERT INTO bwu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ku yaa deri cha ba nna yegayega. Ba yaa begi chaab ayen, “Ka boan jaab nuru ale nna? Wa baga a biisi ale vioku ale nyiamu ate ba a wom wa noai.” ");
INSERT INTO bwu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ba ale gaam a taam paari mogi kpeeni kauk kuŋkula la, ba yaa ga paari nuru baai ate ba a wi ba ayen Gergesimba la tɛŋka. Nuruba baye ale jam bo dula jigini a ta chichiribaata ba zuima po. Nuru waai an jam baga a nyiem a va siuk kula. Yeezu ale ga nyini ŋaaruŋku po a siŋ tɛŋ la, nuruba bayewa a yaa deri nyini juijui ate ba a gu nuruba la, a jam tu wa. ");
INSERT INTO bwu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ba wanyi a yaa kaari a bek wa ayen, “Fi Naawen biika, ka boa ate fi a yaali ti jigiya? Dai dii danni ate Naawen ayen wa jam a bo tɛŋka meena demma buusa la an diem a paariya. Fi liŋ a de ka niŋ jam ayen fi basi ate ti namu abe fi ge ate dai dila danni a paari?” ");
INSERT INTO bwu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Dula jigini die a yaa jam za guuk zuk a de. ");
INSERT INTO bwu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Chichiribaataŋa a yaa saalim Yeezu a weeni wa ayen, “Fi dan a yaali ayen fi yiak ti ate ti nyini be basi ate ti nyini a ga jo deeŋa po.” ");
INSERT INTO bwu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yeezu a yaa weeni ba ayen, “Ni be cheŋ dula jigini.” Ti yaa nyini nuruma jigi a ga jo deeŋa po ate deeŋa a chali a ga va guuku nakpiak a sali siŋ a lo mogi kpeeni po a kpi. ");
INSERT INTO bwu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Baai ale jam a nya deeŋa zuk la a yaa chali cheŋ ba tɛŋka a ga weeni baai ale bo dula la dii ale nyɛ nuruma bayewa baai ate chichiribaataŋa a jam bo ba zuimaŋa po la. ");
INSERT INTO bwu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tɛŋ kala demma ale jam a wom dii ate ba weeni la, ba meena a yaa nyini ba yeeŋa po a jam tu Yeezu a saalim wa ayen wa basi ba tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yeezu a yaa ga jo ŋaaruŋku po a ŋman pilim a lo mogi kpeeni jueli cheŋ wa dek tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Dula jigini ate nuru a boro ate wa nisima ale wa naŋsa a kpi. Nuruba a yaa pa wa dueni jaab zuk a ta jam Yeezu jigi. Yeezu a yaa le nya ba siaka ale wa ale soa dii la, wa yaa weeni nuru waai nisimaŋa ale wa naŋsaŋa ale kpi la ayen, “M biiga, yik fi dek abe fi kan te ku a daani fu. M voŋ fi wabaataŋa a te fu kama.” ");
INSERT INTO bwu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Juuma Sinsaŋŋa sagrɔma ba gela a jam bo dula jigini a yaa poli ba popola po ayen, “Wa ale a biisi dii la a nyɛ nna ase wa ka Naawen la.” ");
INSERT INTO bwu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yeezu a poom seba wa dek popola po ba ale a poli dii la kama a yaa bek ba ayen, “Ka boan popola baata ate nama a poli? ");
INSERT INTO bwu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ase mi dan weeni nuruwa de ate wa nisima ale wa naŋsa a kpi la ayen m voŋ wa wabaataŋa a te wa a yaase wa yiti a cheŋ, ka kuna dek ale pagra? ");
INSERT INTO bwu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mi a yaali kama ayen ni seba ayen mi Saalobiika a ta siuk kama tɛŋzuk meena a baga voŋ nuruba wabaata a te ba.” Wa yaa weeni nuru waai ale a wiak la ayen, “Yiti a zaani abe fi pai fi jaamu a cheŋ kuli fi yenni.” ");
INSERT INTO bwu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nuruwa a yaa deri yiti a zaani a pa wa jaamu a cheŋ kuli. ");
INSERT INTO bwu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Yɔgsum nna yegayega a yaa deri yik baai meena ale jam za dula la. Ba yaa te Naawen pimpauk, dii nyiŋ la wa ale te Yeezu siuk ate wa baga a tom tuini de la. ");
INSERT INTO bwu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yeezu a yaa le basi dula jigini ale cheŋ la, wa yaa nya nuru ate ba a wi wa ayen Matiu. Wa jam kala ka lampoo dɔkku po a tuesi lampoo. Yeezu a yaa weeni wa ayen, “Yiti a jam va mi.” Wa yaa deri basi wa tuimaŋa ale ge yiti a ga va wa. ");
INSERT INTO bwu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yeezu ale wa ŋaaŋviirima a yaa cheŋ Matiu yenni ayen ba de ŋandiinta. Lampoo cheesiroba ale wabaata nyam nna yegayega a yaa jam gum wa ale wa ŋaaŋviirima po, ate ba meena a yaa kala a de ŋandiinta. ");
INSERT INTO bwu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisiiba ba gela a yaa nya ba ale ba a de ŋandiinta. Ba yaa bek wa ŋaaŋviirima ayen, “Ka boa ate ni sagrɔwa ale wabaata nyam ale lampoo cheesiroba a de ŋandiinta ale chaaba?” ");
INSERT INTO bwu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yeezu a yaa wom dii ate ba a bek la a yaa tulisi ba ayen, “Nuru baai ale ta nyiŋyɔgsa la, bala a kan cheŋ tiim nyɔnɔ jigiya, alege ka yuariba nyiini. ");
INSERT INTO bwu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ba jam a ŋmarisi Naawen gbaŋka po dila po dila po ayen wa weeni ayen, ‘Nama ale ta jiirim ale chaab dii la a peenti mi sui a gaam nama ale a ko duŋsa a kaabi a te mi la kama.’ Ni be cheŋ a ga gisi dii ate Naawen a weeni ni la kiri. Mi an jam ayen m wi ka nuru maŋsa, alege ka wabaata nyam.” ");
INSERT INTO bwu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Da yeŋ Jɔɔn waai ale jam a te nuruba soka la, ŋaaŋviirima a yaa jam Yeezu jigi a bek wa ayen, “Ka boa ate tama ale Farisiima ŋaaŋviirima a kasim a bobi noa alege fi ŋaaŋviirima a kan bobi?” ");
INSERT INTO bwu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yeezu yaa bek ba ayen, “Ase nuru a dan faari nipɔk, wa dɔama sue a kaasi kama? Aawo, ŋa kan kaasi. Dai cheena kama ate nipɔkfiaka nyɔnɔwa a dan kan bo ale ba, ba yaa bobi noa.” ");
INSERT INTO bwu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Wa yaa ŋman weeni ba ayen, “Nuru a kan pa garuchiak paalik a laŋ garuk kpaga. Ba dan nyɛ dila, garuku a kan beni ku le cheeri a gum du. ");
INSERT INTO bwu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ba kan pa dapagrik a su bunlɔk kpak po. Ba dan nyɛ dila, bunlɔkku a pusi kama ate daamu a waaŋ. Ba pai dapagrik a su ka bunlɔk paaluk pu.” ");
INSERT INTO bwu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yeezu ale biisi a nueri la, Juuma po kpagi dinyi a yaa jam a kpi duna tɛŋ wa niŋ a weeni wa ayen, “Ka m lie ale deri kpi. Mi a saalim fu ayen fi jam a pa fi nisaŋa a tiri wa ate wa yiti kum po.” ");
INSERT INTO bwu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yeezu yaa yiti va wa ate wa ŋaaŋviirima me a va cheŋ. ");
INSERT INTO bwu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Nipɔk wanyi a yaa jam bo dula a jam a wiagi bena pi ale ŋaye. Wa jam a lo ka chiak. Wa yaa poli wa sunum po ayen, “M dan baga a paari wa garuku nɔanni a tiri, m le nya nyiŋyɔgsa.” Wa yaa va Yeezu ŋaaŋ a magi tiri wa garuku. ");
INSERT INTO bwu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yeezu a yaa viriŋ ŋaaŋ a nya wa ale weeni ayen, “M lie yik fi dek abe fi kan basi ate ku a daani fu. Fi ale ta siaka ale mi dii la a basi kama ate fi nya nyiŋyɔgsa.” Wa le weeni nyaku de la, nipowa yaa deri nya nyiŋyɔgsa. ");
INSERT INTO bwu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yeezu ale ga paari Juuma kpagini yenni la, wa yaa nya yiyiirisa ale ba kala dula jigini alege baai me a kum. ");
INSERT INTO bwu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Wa yaa weeni ba ayen, “Ni meena a yiti nyini. Biika an kpiya, alege wa a goa kama.” Ba ale wom dila la, ba yaa deri a la wa. ");
INSERT INTO bwu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nuruma meena a yaa le nyini la, Yeezu a yaa jo biika dɔkku po a yik wa nisaŋa ate wa yiti. ");
INSERT INTO bwu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Dii ate Yeezu a nyɛ la, a yaa deri waaŋ tɛŋ sii meena ale gilim dula jigini la. ");
INSERT INTO bwu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yeezu ale nyini dula jigini a nyini a cheŋ la, yeeba baye a yaa wom wa a yaa deri cheŋ va wa. Ba yaa kaari a wi wa a weeni ayen, “Naawa Deevid ŋaaŋbiika, ti a saalim fu ayen fi ta jiirim ale ti.” ");
INSERT INTO bwu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yeezu ale ga jo dɔk la, yeema bayewa a yaa jam wa jigi. Yeezu yaa bek ba ayen, “Nama ta siaka ayen mi baga a tebi ni?” Ba yaa siagi. ");
INSERT INTO bwu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dula jigini Yeezu a yaa tiri ba ninaŋa ale weeni ba ayen, “Basi ate ku nyɛ ase ni siaka ale ka dii la.” ");
INSERT INTO bwu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ba ninaŋa a yaa deri lagri ate ba a nya. Yeezu a yaa kaam ba ayen, “Ku a fe kama ate ni kan weeni waai dii ale nyɛ la.” ");
INSERT INTO bwu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Alege nuruba bayewa de a ta ga weeni ate ku tagli tɛŋ sii meena ale mɔata dula jigini la. ");
INSERT INTO bwu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ase nuruba bayewa ale jam a cheŋ la, nuruba ba gela a yaa jam ta nuru wa choa a jam Yeezu jigi. Chichiribiok ale jam bo wa zukku po ate wa an jam baga a biisi. ");
INSERT INTO bwu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yeezu ale yiak chichiribioku ate ku nyini nuruwa zukku po a nyini la, wa yaa deri a biisi. Ku yaa deri cha nuru baai meena ale za dula la. Ba yaa weeni chaab ayen, “Tama an diem a nya wanni de choa Izirali.” ");
INSERT INTO bwu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Alege Farisiima a weeni ayen, “Ka chichiribaataŋa kpagini ale te wa pagrimu ate wa baga a yiak chichiribaata nuruba zuima po.” ");
INSERT INTO bwu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Va ŋala po Yeezu yaa kasim a nyiem tɛŋkpieŋsaŋa ale tɛŋkpansaŋa meena. Wa jam a sak nuruba Naawen naamu wie ba tuka diinaŋa po, ale a tebi yuariba yegayega me. ");
INSERT INTO bwu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Wa ale ga nya ŋanbɔanni la, wa jiirim yaa jam bo ale ba dii nyiŋ la ku jam a daani ba kama nna yegayega ate ba yaa yaali maarika. Ba jam a nyɛ ase ka piisa ale kan ta naapeerik la. ");
INSERT INTO bwu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Wa yaa jam a weeni wa ŋaaŋviirima ayen, “Ka cheka tuima ale boro nna yegayega, alege cheeroma an piisiya. ");
INSERT INTO bwu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ni puusi a te Naawen waai ale ka cheka nyɔnɔwa la ate wa basi ate cheeroba yegayega a jam a che abe ba vaari a ta jo.” ");
INSERT INTO bwu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yeezu a yaa wi wa ŋaaŋviirima pi ale bayewa ate ba jam wa jigi, ate wa yaa pa wa pagrimu a te ba, ate ba nyini a cheŋ a nyiem a yiak chichiribaata nuruba zuima po ale a puusi ate yuariba a nya nyiŋyɔgsa. ");
INSERT INTO bwu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Wa tuimtomdɔma pi ale bayewa yue a jam ale Simon waai ate Yeezu a jam te wa yue paani ayen Piita la, ale wa yuawa Andiru ale Jeemsi ale wa me yuawa Jɔɔn, Zebedi bisaŋa, ");
INSERT INTO bwu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ale Filip ale Batolomiu ale Tomasi ale Matiu waai ale jam ka lampoo cheesirowa la, ale Jeemsi, Alfiyus biika, ale Tadiusi, ");
INSERT INTO bwu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ale Simon ale jam a nyɛ ayen Juuma a nya ba dek zuk la, ale Judas Iskariot waai ale jam a ta Yeezu a ga bobri a sak la. ");
INSERT INTO bwu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yeezu a yaa weeni ba ayen, “Ni dan basi dela ale ge cheŋ, ni kan va Samaria tɛŋsaŋa po ale baai ale kan daa Juuba la tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ni nyiem Juuma ale bo tɛŋ sii la nyiini. Ba a nyɛ se ka piisa ale be ŋa siuk la. ");
INSERT INTO bwu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ni cheŋ a ga sak ba ayen Naawen naamu a mɔata kama. ");
INSERT INTO bwu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ni puusi a te yuaroma ale gamaŋa ate ba nya nyiŋyɔgsa, abe ni nagi kpeeba kum po a yiti abe ni a yiak chichiribaata nuruba zuima po a basi. Pagrimu de ate mi a pa te ni la, ni an tuniya, nama me a pa te abe ni kan yaali tutuna. ");
INSERT INTO bwu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ni kan pa ligra a nyo ni fotaŋa po. ");
INSERT INTO bwu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ni kan pa koalima yaase fotta ale garujuenta ale nuensa ale tachegsa. Ku a magsi kama ayen tuimtomdisa a de ba tuimaŋa nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ni dan ga paari tɛŋ, ni jo ka po a gisi nuru waai ale wa te ni tia abe wa tuesi ni la. Ni dan nya nuru wala choa, ni be bo ale wa a ta ga paari dai dii dai ate ni a basi dula la. ");
INSERT INTO bwu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ni dan ga jo yenni po, ni puusi ba abe ni weeni ba ayen Naawen ale te ba suyɔgini. ");
INSERT INTO bwu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ba dan te ni tia, Naawen a le te ba suyɔgini. Ba dan kan te ni tia, Naawen a kan te ba suyɔgini. ");
INSERT INTO bwu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tɛŋ kaai nuruba a yaase yeri dii dem a dan kan te ni tia ale kan yaali ayen ba wom dii me ate ni tara ayen ni weeni ba la, ni kpaanti ni naŋsaŋa paasuku a basi dula jigini, ate ku sak ayen ba me zɛri ba kama. ");
INSERT INTO bwu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ni wom mi nalim nyiini. Naawen a dan jam ayen wa bo tɛŋka meena demma buusa, wa le ta jiirim ale nuru baai ale jam bo tɛŋ sii ate ba a wi ayen Sodom ale Gomora la po a gaam ba. ");
INSERT INTO bwu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ni wom mi nalimnyiini. Nama baai ate mi a tom la, a nyɛ ase ka piisa ale bo piina sunsuŋ la. Dila nyiŋ la ku a fe kama ayen ni ta yam ase wiiga la abe ni yik ni dek ase nangbaŋsa la. ");
INSERT INTO bwu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ni kpesi ni dek dii nyiŋ la nuruba a le yik ni ale pagrim a ta cheŋ boteka yenni. Ba le miiri ni me ale fiŋsa ba tuka diinaŋa po. ");
INSERT INTO bwu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ba le ta ni a cheŋ a ga zaani nalima ale kpaga niŋ ate ba bo ni buusa mi nyiŋ. Ba dan nyɛ ni dila ni yaa le nya siuk a biisi ale ba ale baai me ale kan daa Juuba la Naawen wamaŋsaŋa wie. ");
INSERT INTO bwu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ba dan ta ni a jam boteka yenni po, ni kan basi ate dii ate ni ayen ni biisi la a daani ni. Ku dan jam paari ni biik, Naawen a le sagi ni ate ni biisi. ");
INSERT INTO bwu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Wie ŋaai ate ni ayen ni biisi la a kan chim nama dek wie, alege ŋa le nyini ka ni Kowa Naawen Chiika jigi. ");
INSERT INTO bwu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nuruba a le jam yik ba suaata a te nuruba ba gela ate ba ko ba. Bisa koba a le jam a yik ba me a nyɛ ba dila degadega. Bisa me a le jam nyɛ ba koba ale ba maba dila me. ");
INSERT INTO bwu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Waai meena a le kisi ni, dii nyiŋ la nama ale a va mi la. Nuru waai a dan ta suduŋni ale ninam ate ku beni, Naawen a le vari wa a basi. ");
INSERT INTO bwu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ba dan a daani ni tɛŋ kaai po ni basi dula abe ni chali cheŋ tɛŋ yoŋ. Wensie ate mi a weeni ni, ni kan baga a tom ni tuimaŋa meena Izirali tɛŋsaŋa po a nueri ale ge ate mi Saalobiika a pilim jam. ");
INSERT INTO bwu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Zamsirɔ waai an baga a seba a gaam wa sagrɔ. Tomteerɔ waai me an baga a chim nuru kpioŋ a gaam wa nyɔnɔ. ");
INSERT INTO bwu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Zamsirɔ a pii ka nyiŋ wa dek ayen wa magsi chaab ale wa sagrɔ. Tomteerɔ me a yaali kama ayen wa dan nya siuk wa ale wa nyɔnɔwa a magsi chaab. Nuruba a dan a wi mi ayen Beelzebu, chichiribaata meena kpagini, ba le wi nama wie ate ŋa gaam di. ");
INSERT INTO bwu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ni be kan a chali nuruba yɔgsumɔa. Wie ŋaai ale lik dua yɔgyɔgla de la ale jam nyini peelim, wie ŋaai meena ale chim wasusuga la ba le jam seba ŋa. ");
INSERT INTO bwu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Dila nyiŋ ku a fe kama ate ni a sak nuruba wie ŋaai ate mi a suk a sak ni la, a lagri. ");
INSERT INTO bwu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ni kan a chali yɔgsum ale nuru baai ale a ko nuruba nyiŋlammu la, dii nyiŋ la ba an baga a ko ba chiisaŋa. Ku magsi kama ayen ni a chali Naawen waai ale baga a kaasi nuruba nyiŋsa ale ba chiisa bolim buui ale kan maari a kpimsi la po yɔgsum. ");
INSERT INTO bwu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ni baga kama a pa ligbiri a da nuinsa siye yabaŋa po, alege si po bunyi a dan poom a lo tɛŋ, ni Kowa Naawen a seba ku po kama. ");
INSERT INTO bwu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Alege nama, Naawen a chiini ni zuisaŋa meena ni zuimaŋa po kama. ");
INSERT INTO bwu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nyaku de nyiŋ nama kan a chali yɔgsum ale dii ate nuruba ayen ba nyɛ ni la. Ni gaam nuinsaŋa ka nna yegayega Naawen nimbie po. ");
INSERT INTO bwu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Waai meena ale a weeni a lagri nuruba nimbie po ayen ka mi ale soa ba la, mi me a le weeni dila degadega m Kowa Naawen waai ale bo wenŋmazuk la nimbie po. ");
INSERT INTO bwu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Waai meena ale kan weeni a lagri nuruba nimbie po ayen ka mi ale soa ba la, mi me a kan biisi m Kowa Naawen waai ale bo wenŋmazuk la nimbie po. ");
INSERT INTO bwu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ni kan a poli ayen mi sakka de a le basi ate nuruba a tigsi jam jigi yeŋ a boro ale suyɔgini. Ku le basi kama ate nuruba a poori chaab. ");
INSERT INTO bwu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Bisa a le ŋman tulim a ta chaab ale ba koba. Leeba me a le ŋman tulim a ta chaab ale ba maba. Sampooba me ale tulim ta chaab ale ba ŋianipooba. ");
INSERT INTO bwu_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ku dan jam ase nnala la, ni le seba ayen nuru dek dɔkdem ale wa dachaasa. ");
INSERT INTO bwu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Nuru waai ale a yaali wa ko a yaase wa ma a gaam mi la an magsi ayen wa va mi. Nuru waai me ale a yaali wa biik a yaase wa lie a gaam mi la an magsi ayen wa va mi. ");
INSERT INTO bwu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nuru waai a ale kan gomsi a magsi ayen wa nya ninam a yaase wa kpi mi nyiŋ la an magsi ayen wa va mi. ");
INSERT INTO bwu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nuru waai ale a yaali wa dek nyuvuri ale kan yaali ayen wa nya ninam la, kula nyɔnɔ a le jok wa nyuvunni. Nuru waai a dan jok wa nyuvuri mi nyiŋ, wa le ŋman nya di. ");
INSERT INTO bwu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Nuru waai a dan te ni tia ale tuesi ni, kula nyɔnɔ a te ka mi me tia dila. Nuru waai me ale a te mi tia ale a tuesi mi la, wa te ka Naawen waai ale tom mi la tia dila. ");
INSERT INTO bwu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nuru waai ale a te Naawen biisiteerɔwa tia, dii nyiŋ la wa le tom a te Naawen la, da yeŋ po wa le nya ku tutuna. Nuru waai me ale a te nuru maŋ tia ayen wa le ka nuru maŋ la nyiŋ, da yeŋ po wa le nya ku tutuna. ");
INSERT INTO bwu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ni wom mi nalimnyiini. Nuru waai a dan pa nyayɔgsik a te mi ŋaaŋviirima po wanyi, da yeŋ po wa le tuesi ku tutuna.” ");
INSERT INTO bwu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yeezu ale biisi ale wa ŋaaŋviirima pi ale bayewa a nueri la, wa yaa basi dula jigini ale ge cheŋ tɛŋ sii ale mɔata dula la ayen wa sak ba Naawen wamaŋsaŋa wie. ");
INSERT INTO bwu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jɔɔn waai ale jam a te nuruba soka la, a diem a jam bo ka naawa Ayerod dɔkku kuui ate ba a lik nuruba la po. Jɔɔn ale wom dii ate Yeezu a jam a tom la, wa yaa tom wa ŋaaŋviirima po ba gela ate ba cheŋ Yeezu jigi. ");
INSERT INTO bwu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ba ale ga paari wa jigi la, ba yaa bek wa ayen, “Ka fi ale nuru waai ate Jɔɔn a weeni ayen fi le jam la, yaa ti deema a limsi nuru yoŋŋɔa?” ");
INSERT INTO bwu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yeezu a yaa weeni ba ayen, “Ni ŋman pilim cheŋ a ga weeni Jɔɔn dii ate nama a wom ale a nya la. ");
INSERT INTO bwu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Yeeba a nya, gbanisa me a baga a cheŋ, gama me a nya nyiŋyɔgsa. Tukpara nyam a wom, ale nagi kpeeba kum po a yiti. M be sagi ŋanjagsa me Naawen wamaŋsaŋa wie. ");
INSERT INTO bwu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nuru baai ale kan ta chichama ale mi la, sue a peenti kama.” ");
INSERT INTO bwu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ase Jɔɔn ŋaaŋviirima a yaa ale ŋman pilim a bo siuku po a cheŋ la, Yeezu a yaa chiem a weeni nuru bɔanni Jɔɔn wie. Wa yaa weeni ba ayen, “Nama ale nyini a cheŋ Jɔɔn jigi sagini po la, nama a jam a poli ayen ni le nya ka boa? Nama a poli ayen ni le nya ka chichama nyɔnɔ? ");
INSERT INTO bwu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nama a nyini cheŋ ayen ni nya ka boa? Nama a cheŋ dula ayen ni nya ka nuru waai ale jo garuk nalinsa la? Baai ale a jo garuk tila chaama la a bo ka nalima yie po. ");
INSERT INTO bwu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ni be weeni mu, ni nyini cheŋ ayen ni nya ka boa? Naawen biisiteerɔma yaa? Ni basi ate m weeni ni ayen ni nya ka waai ale gaam Naawen biisiteerɔma meena la. ");
INSERT INTO bwu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ba ŋmarisi Jɔɔn wie Naawen gbaŋka po kama dila po dila po ayen Naawen a weeni ayen, ‘Ka mi tomteerɔwa ale nna. M be le liŋ a tom wa fi niŋ ate wa gomsi siuk a te fu.’ ");
INSERT INTO bwu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Wensie ate mi a weeni ni, Jɔɔn waai ale a te nuruba soka ale nyiam la a gaam nuru baai meena ale jam boro a ta nyini dila po dila po la kama, alege Naawen naamu po waai ale ka baaŋ la a ŋman zuak a gaam Jɔɔn kama. ");
INSERT INTO bwu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","A ta nyini diipo ate Jɔɔn a piilim a sak nuruba la a ta jam paari jinla, pagrim nyam a kasim a yaali kama ayen ba kaasi Naawen naamu. ");
INSERT INTO bwu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","A ta nyini diipo ate Naawen a liŋ pa wa Sinsaŋŋa a te Moosis la ale Naawen biisiteerɔma meena ale jam a sak nuruba dii la a ta jam paari Jɔɔn jamka me nuruma de meena a biisi Naawen naamu wie kama. ");
INSERT INTO bwu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ni dan siak a te dii ate ba ŋmarisi la, ni le miŋ ayen Jɔɔn ka Naawen biisiteerɔwa Elaja. Ba ŋmarisi Naawen gbaŋka po ayen wa le ŋman pilim jam. ");
INSERT INTO bwu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ni lagri ni tueŋa a wom dii ate m weeni a sak ni la. ");
INSERT INTO bwu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Yɔgyɔgla de, m le pai jinla demma a magsi chaab ale ka boa? Ba a nyɛ se ka bisa ale tigsi chaab a kala yaba po a wi ba dɔaba a weeni ba ayen, ");
INSERT INTO bwu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tama a yi ka nipɔkfiak yiila, alege nama a kan gogi. Ti a yi kum yiila, alege ni sue a kan kaasi.’ ");
INSERT INTO bwu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jɔɔn ale jam bobi wa nɔanni la, waai meena a jam a weeni kama ayen chichiribiok ale bo wa zukku po. ");
INSERT INTO bwu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mi Saalobiika ale jam, a de ale nuruba la, waai meena a jam a weeni kama ayen, ‘Ni nya nuruwa de. Wa ka puuk nyɔnɔ ale a nyu daam me nna yegayega. Wa ka lampoo cheesiroba ale wabanyeerisa doa.’ Naawen a sak nuruba ka wa wensie siutaŋa tii ale ka tɔgatɔga la.” ");
INSERT INTO bwu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yeezu a tom wakperikaliisa yegayega tɛŋ sii ale mɔata la po, alege tɛŋ sila demma an diem a jam basi ba wabaataŋa. Wa yaa tɔariŋ ba ayen, ");
INSERT INTO bwu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Nama Koraziin demma ku le jam tua kama ni jigi. Nama Beteseida demma, ku le jam tua kama nama me jigi. Ase mi a dan poom a tom wakperikaliisaŋa de ka Taaya ale Saidon tɛŋsaŋa po ase mi ale tom dii nama jigi la, baai ale jam bo dula dila po dila po la ate basi ba wabaataŋa kama. Ba te jo ka garuk tii ale a lu ba nyiŋsaŋa la abe ba nyɛ tintuem a yuk ba zuimaŋa. Nyaku de te le sak nuruba kama ayen ba ŋman va ka Naawen siuku. ");
INSERT INTO bwu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Wensie ate mi a weeni ni Naawen a dan jam ayen wa bo tɛŋzuk meena demma buusa wa le ta jiirim ale Taaya ale Saidon demma a gaam nama kama. ");
INSERT INTO bwu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nama Kapernaum demma, ni a yaali kama ayen ni pa ni dek jueli wenŋmazuk. Dai dila danni a dan paari, ba le yuk ni basi bolim buui ale kan maari a kpimsi la po. Ase mi dan poom a tom wakperikaliisaŋa de ka Sodom tɛŋka po dila po dila po, ase m le tom dii la, Naawen a kan bo ba buusa a kaasi ba. ");
INSERT INTO bwu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Wensie ate mi a weeni ni Naawen a dan jam ayen wa bo tɛŋzuk meena demma buusa wa le ta jiirim ale Sodom demma a gaam ni.” ");
INSERT INTO bwu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Va ŋala po Yeezu a yaa puusi a te Naawen ayen, “M dek ko, fi waai ale ka wenŋmazuk ale tɛŋzuk meena nyɔnɔ. Wie ŋaai ate fi a zɛri yam nyam sakka ale ge a pa suk ba la, fi pa ka ŋala a sak baai ale kan seba gbaŋ la. Mi a te fi jiam wieŋa de nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","M Koa, fi ale yaali ayen ku nyɛ dii la ale la.” ");
INSERT INTO bwu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yeezu ale puusi a nueri la, wa yaa cheemu a weeni nuru bɔanni ayen, “M Kowa a pa jaab buuri meena a te mu kama. Nuru waai a ze Naawen biika ka wa kowa nyiini ale seba wa. Nuru waai me a ze kowa ka wa biika nyiini ale seba wa. M basi kama ate baai ate m lueri la seba wa me. ");
INSERT INTO bwu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Nama meena baai ale ji jib kpeenta ale jiak la, ni jam mi jigi. Mi a le te ni vuusum. ");
INSERT INTO bwu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mi sinsaŋŋa a nyɛ se ka naabkpaama duok la. Ni pa ku a su ni ŋeeŋa po ate ni baga. Mi ka nuru waai ale seba m dek taka la. Ni dan basi ate mi a sak ni, ni le nya vuusum. ");
INSERT INTO bwu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Duok kuui ate mi a pai a te ni la, ku ta cheŋka an tua. Jib tii ate mi a pai a ji ni la an dobra.” ");
INSERT INTO bwu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ba Vuusum Daaŋa po dinyi Yeezu ale wa ŋaaŋviirima a yaa jam cheŋ va nuru talim po. Ba la cheŋ la, kom a yaa ta wa ŋaaŋviirima ate ba yaa wie “wiiti” ayen ba ŋobi. ");
INSERT INTO bwu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farisiima ba gela ale nya dii ate ba a nyɛ la, ba yaa bek Yeezu ayen, “Ka boa ate fi ŋaaŋviirima a kaasi ti Vuusum Danni kisiku?” ");
INSERT INTO bwu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yeezu a yaa bek ba ayen, “Nama an diem karim Naawen gbaŋka po a miŋ naawa Deevid wie a chak ya? ");
INSERT INTO bwu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dii po ate nuru waai ate ba a wi wa ayen Abiata ate wa jam ka Juuma Puusika Yenni tomteerɔma la, da yeŋ ate kom a yaa jam ta Deevid ale wa dɔama. Wa yaa jo Puusika Yenni po a pa boroboruk a we a ŋobi ale ge a wie a te wa dɔama ate ba me a ŋobi. Ba kan te nuru yoŋ a ŋobi boroboruku de ka Juuma Puusika Yenni tomteerɔwa nyiini ale a ŋobi ku. ");
INSERT INTO bwu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nama an karim dii ate Moosis a ŋmarisi Naawen gbaŋka po ayen Juuma Puusika Yenni tomteerɔma nyiini ale a tom wa Puusika Yenni po Vuusum Danni la? Ba nyiem a kasim a a kaasi ti Vuusum Danni kisiku kama, alege nuru waai a kan nya ba kaasuŋku. ");
INSERT INTO bwu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ni basi ate m weeni ni ayen nuru a bo dela a zuak gaam Juuma Puusika Yenni kama. ");
INSERT INTO bwu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ba ŋmarisi Naawen gbaŋka po ayen wa weeni kama ayen, ‘Nama ale ta jiirim ale chaab dii la a peenti mi sui a gaam nama ale a ko duŋsa a kaabi a te mi la kama.’ Ni dan seba wieŋa de kiri, kuna magsi ayen nama a bu baai ale kan nyɛ a kaasi la buusa. ");
INSERT INTO bwu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Mi Saalobiika ale soa Vuusum Daaŋa me.” ");
INSERT INTO bwu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yeezu a yaa basi dula jigini ale ge a cheŋ ga jo Juuma tuka dɔkku po. ");
INSERT INTO bwu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nuru wanyi ale jam bo dula ate wa nisa a kpi. Nuru baai ale jam bo dula la, a jam a limsi kama ayen ba nya se Yeezu le tebi nuruwa nisaŋa Vuusum Danni po yaase wa kan tebi ate ba baga a nya wari biisi. ");
INSERT INTO bwu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yeezu a yaa weeni ba ayen, “A se nama waai poosuk a dan lo vili po Vuusum Danni ni kan yeeri ku? ");
INSERT INTO bwu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nurubiik a be gaam poosuk kama nna yegayega. Ka dila ale soa ate nuru a dan maari wa suok Vuusum Danni po, wa kan kaasi Vuusum Danni kisiku.” ");
INSERT INTO bwu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Wa yaa weeni nuru waai nisaŋa ale kpi la ayen wa teeri si. Wa yaa teeri si a deri nya nyiŋyɔgsa. ");
INSERT INTO bwu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farisiima a yaa yiti dula jigini a nyini a yaa gisi siuk ayen ba ko Yeezu. ");
INSERT INTO bwu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yeezu ale wom dii ate ba a yaali ayen ba nyɛ wa la, wa yaa basi dula jigini ale ge cheŋ. Nuruba yegayega a jam va wa ate wa tebi ba tuetaŋa meena. ");
INSERT INTO bwu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Wa ale tebi ba la, wa yaa weeni ba ayen ba kan weeni a sak nuru wa ale nyɛ dii la. ");
INSERT INTO bwu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Wa weeni ba nyaku de kama ayen dii ate Naawen biisiteerɔwa Azaya a ŋmarisi dila po dila po la a chim wensie. Wa ŋmarisi kama ayen Naawen a weeni ayen, ");
INSERT INTO bwu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ka mi tuimtomdɔwa waai ate mi a lueri a te m dek la, ale nna. Mi a yaali wa kama. M sui me a peenti ale wa nna yegayega. M le pai m chiika a nyo wa sunum po ate wa sak baai ale kan daa Juuba la nyemagsika. ");
INSERT INTO bwu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Wa daa sak ba nyaku de, wa kan yaali ayen wa ale ba a ta nampaga ale chaab a yaase wa a na ba yabaŋa po. ");
INSERT INTO bwu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wa le maari ŋanjagsa baai ale nyɛ a se wuuk tii ale wie la abe wa pa wa pagrimu a te nuru baai ale seba ba dek taka la, dii nyiŋ la bala a nyɛ se ka bolim ate ba tɔati a zaani la. Wa kan basi nyaku de nyeka a se ka wa ta nyemagsika a jam tɛŋzuk de. ");
INSERT INTO bwu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Waai meena yiila ale bo ka wa jigi.” ");
INSERT INTO bwu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Da ŋala po nuruba ba gela a yaa ta nuru wanyi a jam Yeezu jigi. Wa jam ka gaauŋ ale yi me, dii nyiŋ la chichiribiok ale jam bo wa zukku po. Yeezu a yaa tebi wa ate wa ŋman baga a biisi ale a nya. ");
INSERT INTO bwu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ku yaa cha nuru bɔanni ate ba yaa bek chaab ayen, “Nuruwa de, ka naawa Deevid ŋaaŋbiik yaa?” ");
INSERT INTO bwu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Farisiima ale wom dii ate nuruma a biisi ale chaab la, ba yaa weeni ba ayen, “Chichiribaataŋa meena kpagini ate ba a wi ayen Beelzebu la ale a te wa pagrim ate wa baga a yiak chichiribaata nuruba zuima po a basi.” ");
INSERT INTO bwu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yeezu a jam seba dii ate Farisiima a poli la kama a yaa weeni ba ayen, “A se tɛŋ kaai dem a dan poori ba dek ta chaab, ba dachaasa a kan va dila nyiŋ a ko ba? Ase yeri yeŋ po dem a dan tulim a ta chaab yeri dila a waaŋ kama. ");
INSERT INTO bwu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","A se Sitaana ale wa tuimtomdɔma a dan ta chaab, wa naamu a kan beni ale ge a lo. ");
INSERT INTO bwu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nama a weeni ayen Beelzebu ale kasim a pa wa pagrimu a te mi ate mi baga a yiak chichiribaata nuruba zuima po a basi. Ka wana ale a te nama ŋaaŋviirima pagrimu ate ba a yiak chichiribaata a basi. Ni dek ŋaaŋviirima ale a tom dii la a sak kama ayen dii ate nama a biisi mi wie la a daa wensie. ");
INSERT INTO bwu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ka Naawen Chiika ale a te mi pagrim ate mi a yiak chichiribaata nuruba zuima po a basi. Nyaku de a sak ni kama ayen Naawen naamu a jam diiri ni kama. ");
INSERT INTO bwu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Nuru karo a baga a jo pagrɔ yeri po a zu wa ŋanta ka wa nin liŋ a yik wa a bobi alege pai ŋantaŋa. ");
INSERT INTO bwu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Nuru waai a dan zɛri mi ŋaaŋ zaanika, kula nyɔnɔ a kaasi ka mi ale a tom dii la. Nuru waai a dan kan a maari mi ate ti tigsi a gum chaaba, kula nyɔnɔ a kati a waaŋ kama. ");
INSERT INTO bwu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Wensie ate mi a weeni ni, Naawen baga kama a voŋa te nuruba ba wabaata meena ale ba ale a le wa dii la me. Alege nuruba a daa le Naawen Chiika, Naawen a kan baga a voŋ a te ba. ");
INSERT INTO bwu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nuruba a daa le mi Saalobiika Naawen ale baga a voŋ a te ba. Nuruba abe daa le Naawen Chiika, Naawen a kan baga a voŋ a te ba diipo diipo.” ");
INSERT INTO bwu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yeezu a yaa ŋman weeni Farisiima ayen, “Timaŋ a yoani ka yoana maŋsa, alege tibiok a yoani ka yoana baata. Nuruba a baga a miŋ timaŋ ale tibiok ka si yoanaŋa nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nama a nyɛ se ka wiiga la. A se nama a daa tom wabaata ni le nyɛ ka se a biisi wamaŋsa? Wie ŋaai ate nama a biisi la a nyini ka ni dek puusa po. ");
INSERT INTO bwu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nuru sunum a bo ka wa ŋanta zaanika jigi. Wamaŋsa a dan bo dula, wa a yeeri ŋa kama a biisi. Wabaata me a dan bo du, wa a yeeri ŋa me kama a biisi. ");
INSERT INTO bwu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Wensie ate mi a weeni ni, Naawen a dan jam ayen wa bu tɛŋzuk meena demma buusa, wa le bek waai meena wa ka ya tii ate ba biisi la. ");
INSERT INTO bwu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Naawen le pa ka wie ŋaai ate ni biisi la a bu ni buusa. Nama ale biisi ŋaai meena ate wa wom la le basi ate wa weeni ayen ni kaasi kama yaa se ni ze ku po.” ");
INSERT INTO bwu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Da ŋala po Juuma Sinsak sagrɔma ale Farisiima ba gela a yaa jam Yeezu jigi a weeni wa ayen, “Ti Sagrɔ, tama a yaali kama ayen fi tom wakperikaliik ate ti nya.” ");
INSERT INTO bwu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yeezu a yaa weeni ba ayen, “Nama jinla demma a zɛri Naawen ka nna yegayega ale a tom tuimbaata. Mi a kan siagi a tom wakperikaliik a te nama yɔgyɔgla de. Wakperikaliik sii ate nama le nya dai yeŋ po la ale dii ate Naawen a tom a te wa biisiteerɔwa waai ate ba jam a wi wa ayen Jona la. ");
INSERT INTO bwu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Naawen a jam tom jum kpiem ate bu ga ne Jona. Wa jam a bo bu poni po ka daa ŋata. Siuku la po me ba dan jam ko mi Saalobiika, nuruba le gu mu. Ba dan gu mu, daa ŋata danni m le yiti kum po. ");
INSERT INTO bwu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Naawen a dan jam ayen wa bu tɛŋzuk meena demma buusa baai ale bo tɛŋ kaai ate ba a wi ayen Niineve la, le jam a yiti a biisi gaam ni. Jona a le jam sak ba Naawen wie dila po dila po la, ba jam a basi ba wabaataŋa kama ale va wa. Mi waai ale bo dela ale ni la, a zuak gaam Jona kama nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Naawen a dan jam ayen wa bu tɛŋzuk meena demma buusa, Siiba tɛŋka nipɔk naawa, le jam a yiti a biisi gaam ni. Wa nyini ka nna niŋniŋa a jam naawa Solomon jigi ayen wa wom wa yammu wieŋa. Mi waai ale bo dela ale ni la, a zuak gaam Solomon kama nna yegayega.” ");
INSERT INTO bwu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yeezu a yaa ŋman weeni Farisiima ayen, “Chichiribiok a dan nyini nuru zuk po a nyini, ku a cheŋ ka sagini po a ga nyeema a gisi vuusum jigi. Ku dan kan baga a nya jigi ya. ");
INSERT INTO bwu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ku a weeni ka ku dek ayen, ‘Basi ate m ŋman a ga jo nuru waai zukku po ate m poom boro la.’ Ku dan ŋmani a ga jo dula jigini, ku yaa ale nya ayen ku jigini a gomsi magsi kama. ");
INSERT INTO bwu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ku yaa ŋman nyini dula jigini a nyini a ga gisi a nya ku chichiribaata ti chaab tiyopoi a ta ŋmani ga jo nuruwa zukku po. Chichiribaata tiyopoi wa tuimbaataŋa a pagra a gaam m kula tuimaŋa kama chichiribiok kula a dan tom ku tuimaŋa a nueri, nuru wa la ale poom ka dii la a gaam wa daam wa kama. Ku le ku nyɛ dii ale jinla demma baai ale a tom wabaata la ale la.” ");
INSERT INTO bwu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yeezu ale diem boro a biisi la, wa mawa ale wa suaataŋa a yaa jam za peelim a tom nuru ayen wa jo a wi wa. ");
INSERT INTO bwu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Wa yaa jam Yeezu jigi a weeni wa ayen, “Fi mawa ale fi suaataŋa a za peelim a yaali fu.” ");
INSERT INTO bwu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nuruba yegayega ale jam kala a gilim Yeezu ate wa yaa bek ba ayen, “Ka wana ale mi ma? Be ka bana ale mi suaata?” ");
INSERT INTO bwu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Wa yaa dak ayen ba nya wa ŋaaŋviirima, ale weeni ba ayen, “Mi maba ale mi suaataŋa ale la. ");
INSERT INTO bwu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Baai meena ale a tom dii ate mi kowa a yaali la, bala ale mi suaata, ale mi tɔaba, ale mi maba.” ");
INSERT INTO bwu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Dai dila danni Yeezu a yaa basi dula ale ŋmani a cheŋ mogi kpeeni noai a ga kala a sak nuruma Naawen wie. ");
INSERT INTO bwu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nuru bɔari yegayega a yaa jam za a gilim wa. Ba ale jam a piisi la nyiŋ ale soa ate wa yaa a yiti a ga jo ŋaaruŋ po a siŋ nyiamu po a torisi a cheŋ niŋ maga dega, ale ge ate nuru bɔanni a yaa za nyiamu noai. ");
INSERT INTO bwu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Wa yaa magsi wamagsima a sak ba wie nna yegayega a weeni ba ayen, “Nuru wanyi ale jam boro a yaa nyini a cheŋ wa talim ayen wa yuk wa ŋanborinta ase muma la. ");
INSERT INTO bwu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wa ale jam boro a yuk la, beeŋa gela a lo siuku po ate nuinsa a jam pisi ŋa meena. ");
INSERT INTO bwu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Beeŋa gela me a lo tintana po. Ŋala an jam baga a nyini nwuli, dii nyiŋ la tantaŋa an jam soa dii ya dula jigini. ");
INSERT INTO bwu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kantueŋ ale jam a moak la, ŋa meena yaa jak dii nyiŋ la ŋa ka naŋsa ate ŋa yaa a kpi. ");
INSERT INTO bwu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Beeŋa gela me a lo munsa po a yaa nyini. Munsaŋa me a chim gerigi ŋa. ");
INSERT INTO bwu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Beeŋa gela me a lo tɛŋ naluŋ po a nyini a biak nalimnyiini. Ŋaai a ta bie pisita, ŋaai pisiyuebi, ŋaai me a ta kook.” ");
INSERT INTO bwu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yeezu yaa a ŋman weeni ba ayen, “Nama baai ale ta tue a wom la, ni wom mi nalimnyiini.” ");
INSERT INTO bwu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yeezu ale jam kala wa dek wa nyiini la, wa ŋaaŋviirima a yaa jam a bek wa ayen, “Ka boa ale soa ate fi a daa sak nuruba, fi a pa wamagsima a sak ba?” ");
INSERT INTO bwu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yeezu a yaa weeni ba ayen, “Naawen a pa wa naamu wieŋa a lagri sak ni kama alege wa an nyɛ nna la a te ba. ");
INSERT INTO bwu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nuru waai a dan tara, Naawen ale gum du a te wa ate wa ta yegayega. Nuru waai a dan kan ta jaabɔa, mak kaai ate wa ta la, Naawen ale tuesi. ");
INSERT INTO bwu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ka dila nyiŋ ale soa ate mi a magsi wamagsima a sak nuruba la. Ba ta nina alege an baga a nya. Mi daa biisi ale ba, ba kan miŋ mi ale a biisi dii la kiri ya. ");
INSERT INTO bwu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Dii ate Naawen biisiteerɔwa Azaya a ŋmarisi ba wie Naawen gbaŋka po dila po dila po la ka wensie. Wa ŋmarisi ayen Naawen a weeni ayen, ‘Nuruma de a wom ale a wom kama alege ba kan miŋi. Ba a nya ale a nya alege ba kan nya. ");
INSERT INTO bwu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Dii nyiŋ la ba popolaŋa a lik kama, ba tueŋa me a kpari ate ba ninaŋa a yi. Ba dan kan nyɛ ka dila ba ninaŋa a ta nya kama, ate ba tueŋa a wom ate ba popolaŋa me a miŋ. Ate ba basi ba wabaataŋa ate m voŋ a te ba.’ ");
INSERT INTO bwu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nama a ta supeentik kama. Ni ninaŋa a baga nya ate ni baga a miŋ dii ate weeni la kiri. ");
INSERT INTO bwu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ni basi ate m weeni ni ayen Naawen biisiteerɔma ale Naawen nuruma yegayega a yaali kama ayen ba nya wie ŋaai ate nama a nya la nna yegayega, alege ba an baga a nya ŋa. Ba a yaali ayen ba wom wie ŋaai ate nama a wom la nna yegayega, alege ba an baga a wom ŋa. ");
INSERT INTO bwu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ni goori a wom mi ale a ayen m sak ni boridowa wamagsini la kiri. ");
INSERT INTO bwu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bie ŋaai ale lo siuku po la a nyɛ se ka Naawen Naamu po wamaŋsaŋa ŋaai ate nuruba a wom alege kan miŋ ŋa kiri la. Sitaana a yaa jam nna nwuli a tuesi wamaŋsaŋa ba suniimaŋa po. ");
INSERT INTO bwu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Bie ŋaai ale a lo tanaŋa po la a nyɛ se ka baai ale a wom wamaŋsaŋa ate ba sue a peenti la. ");
INSERT INTO bwu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Alege wamaŋsaŋa a kan siŋ ba suniimaŋa po ate ba a ta ŋa a beni. Ninam a dan jam yik ba wamaŋsaŋa vaka nyiŋ, ba yaa deri basi. ");
INSERT INTO bwu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Bie ŋaai ale a lo munsaŋa jigini la a nyɛ se ka baai ale a wom wamaŋsaŋa, alege tɛŋzuk meena ŋantaŋa yaalika ale ba ligraŋa yaalika yegayega ka, ŋala meena a kaasi ka wamaŋsaŋa ate ba an baga a ta ŋa a beni. ");
INSERT INTO bwu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Bie ŋaai ale a lo tɛŋ naluŋku po la a nyɛ se ka baai ale a wom wamaŋsaŋa ate ŋa a jo ba suniima po nalimnyiini ale baga a biak a ta bie pisita, ŋaai pisiyuebi ate ŋa gela me a ta bie kook la.” ");
INSERT INTO bwu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yeezu yaa ŋman magsi wamagsima ŋa chaab ale ba ayen, “Naawen Naamu a nyɛ se ka nuru waai ale cheŋ wa talim ayen wa bori wa ŋanborinta la. ");
INSERT INTO bwu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Dii po ate nuru meena a goa la wa dachiak a yaa yiti yokku po a cheŋ nuruwa talimu a ta wuu bie a ga bori bu po ale ge cheŋ. ");
INSERT INTO bwu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ŋantaŋa ale nyini a chim a mɔata puusa yikka la, wuutaŋa me a nyini a chimu. ");
INSERT INTO bwu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Da yeŋ po talimu nyɔnɔwa tomteerɔma a yaa jam a bek wa ayen, ‘Ti nyɔnɔ, ŋan baai ate fi a pa ta ga a bori fi talimu po la, ŋa daa ŋanmaŋsa? Ka boa ale soa ate wuuta a nyini ŋa po a soa di?’ ");
INSERT INTO bwu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Wa yaa weeni ba ayen, ‘Ka m dachiak ale bori wuutaŋa ŋa po.’ Ba yaa ŋman bek wa ayen, ‘Fi a yaali ayen ti ga voori wuutaŋa a basi?’ ");
INSERT INTO bwu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Wa yaa weeni ba ayen, ‘Ni basi ti, dii nyiŋ la ni dan ga ayen ni voori ti, nama a le maa voori ŋantaŋa me a basi. ");
INSERT INTO bwu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ni basi ate ŋantaŋa ale wuutaŋa a gum chaab a chim. Cheka danni a dan paari, m le basi ate cheeroma a che ŋa meena abe ba yaa luk wuutaŋa a ju abe ba ge ŋantaŋa dek a ta ga nyo m bunni po.’ ” ");
INSERT INTO bwu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yeezu yaa a ŋman magsi wamagsini ale ba ayen, “Naawen Naamu a nyɛ se ka be dii ate ba a wi ayen ‘Mastad’ ate nuruba a pa di a bori ba talita po la. ");
INSERT INTO bwu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Di ka bie meena po be fiik. Di dan nyini a chim, di a zuagi kama a gaam ti fiisaŋa meena, ate nuinsa a jam a yɔgi si tugta bu zuk.” ");
INSERT INTO bwu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yeezu a ŋman diem a magsi wamagsini di choa ale ba ayen, “Naawen Naamu a nyɛ se ka nipɔk a nyiem ale pa dabinta a nyo boroboruk zom po ate ku fuusi a zuak dii la.” ");
INSERT INTO bwu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yeezu a nyiem a dan boro a sak nuru bɔanni, wa nyiem a kasim a magsi ka wamagsima ale ba. Wa kan weeni wariya alege a kan magsi wa magsi. ");
INSERT INTO bwu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Wa a nyɛ nyaku de kama ate ku sak ayen dii ate Naawen biisiteerɔwa a ŋmarisi Naawen gbaŋka po dila po dila po la a chim wensie. Wa ŋmarisi ayen Naawen a weeni ayen, “Mi dan boro a sak nuruba, m le magsi ka wamagsima ale ba. Mi ale nyɛ tɛŋzuk meena la, m pa ka wie nna yegayega a suk, alege m le pa ŋa a sak ba a lagri.” ");
INSERT INTO bwu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Dula jigini Yeezu a yaa basi nuru bɔanni ale ge a ga jo yenni po. Wa ale ga jo yenni po la, wa ŋaaŋviirima a yaa jam a weeni wa ayen, “Fi ale a magsi wuutaŋa ale ŋanborintaŋa po wamagsini dii a sak ti la, tama a yaali kama ayen fi weeni di kiri a sak ti.” ");
INSERT INTO bwu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yeezu a yaa weeni ba ayen, “Waai ale bori ŋanborintaŋa la a nyɛ ase ka mi Saalobiika la. ");
INSERT INTO bwu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Talimu a magsi chaab ale ka tɛŋzuk meena, ale ge ate ŋanborintaŋa a magsi chaab ale nuru baai ate Naawen a soa la. Wuutaŋa me a magsi chaab ale ka nuru baai ate Sitaana a soa la. ");
INSERT INTO bwu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Dachiak kaai ale bori wuutaŋa la ale Sitaana. Cheka danni a magsi chaab ale ka tɛŋzuk meena kpeglimka danni. Cheeroma me a magsi chaab ale ka Naawen sabiiloma. ");
INSERT INTO bwu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","A se Cheeroma ale a tigsi wuutaŋa a gum chaab a ju dii la, tɛŋzuk meena kpeglimka danni me ale nyɛ a se ka dila la. ");
INSERT INTO bwu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mi Saalobiika a le tom Naawen sabiiloma ate ba tigsi baai ale a tom wabaata ale baai ale a sak nuruba wabaata tomka siuk la meena. ");
INSERT INTO bwu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Sabiiloma a le pa ba a yuk basi bolim buui ale kan maara kpimsi la po ate ba bo dula a kaari abe ba ŋobi ba nyinaŋa. ");
INSERT INTO bwu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tuimmaŋsa nyamma a za ba a nyagsi a se ka wenbinni la ba nyɔnɔwa Naamu po. Nama baai ale ta tue la, ni wom mi. ");
INSERT INTO bwu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Naawen Naamu a nyɛ se ka nuru waai ale tu a nya jaab ate wa silima. Wa sui yaa peenti nna yegayega ate wa chuili tanta a si alege a ga pa wa ŋanta meena a da a jam da tɛŋ kala. ");
INSERT INTO bwu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Naawen naamu a nyɛ se ka gerindɔ waai ale a gisi ayen wa da tintain ate ba a wi ayen ‘pearl’. ");
INSERT INTO bwu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Wa dan nya kpain dii diak ale pagra a gaam ŋa meena la, wa yaa ga a pa wa ŋanta meena a da. Wa le da a nueri la, wa yaa ŋmani a cheŋ waai ale ta tintanni a da la jigi a ga da. ");
INSERT INTO bwu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Naawen Naamu a nyɛ se ka nuru waai ale a yuk ŋmiak a basi beli kpeeni po a yik juma tɔgatɔga la. ");
INSERT INTO bwu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ŋmiaka a dan sueri, jumyigrɔwa a yaa dari ka a ta jueli kuŋkɔŋini. Wa dan ta ŋa a jueli, wa yaa kali tɛŋ a luk jum ŋaai ate ba ŋobi la a nyo chinni po ale ge a pa jum ŋaai ate ba kan ŋobi la a yuk a basi. ");
INSERT INTO bwu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Siuku la po me, tɛŋzuk meena kpeglimka a dan jam paari, Naawen sabiiloma a le luk nuru maŋsaŋa ale nuru baataŋa tɔgatɔga a zaani. ");
INSERT INTO bwu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Wa le pa wabaataŋa nyamma a ta ga a yuk basi bolim buui ale kan maari a kpimsi la po. Dula jigini ba le kum nna yegayega abe ba a ŋobi ba nyinaŋa.” ");
INSERT INTO bwu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yeezu ale a magsi wamagsimaŋa de a nueri la, wa yaa bek nuruma ayen, “Nama a miŋ dii ate mi a biisi ale ni la kiri a chagi ya?” Ba yaa weeni wa ayen, “Mm, ti miŋ ya.” ");
INSERT INTO bwu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yeezu a ŋman weeni ba ayen, “Juuma Sinsaŋŋa sagrɔma waai a dan chim mi ŋaaŋviiro Naawen Naamu po, wala a nyɛ se ka yeri nyɔnɔ ale yeri ba ŋan paala ale wa ŋan kpagsa wa dɔk po la.” ");
INSERT INTO bwu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yeezu ale a sak nuruma de a nueri la, wa yaa basi dula jigini, ");
INSERT INTO bwu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","alege a cheŋ wa dek tɛŋka. Da yeŋ po wa yaa cheŋ a ga jo ba Juuma tuka dɔkku po a sak nuruma Naawen wie. Ku yaa jam a cha nuru baai ale jam a bo dula jigini la. Ba yaa bek chaab ayen, “Nuruwa de a nya yammu de ka be? Wa nyɛ ka se a tom wakperikaliisaŋa nna? ");
INSERT INTO bwu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Daa wala ale chapentawa biika la? Daa Mɛɛri biika ale la? Da Jeemsi ale Josefi ale Judas ale Simon suok ale la? ");
INSERT INTO bwu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Wa tɔama an bo daa de la? Wa nyɛ ka se a seba nna?” ");
INSERT INTO bwu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nuruma meena sue an jam masa ale wa, dii nyiŋ la ba seba wa kiri meena kama. Yeezu a yaa weeni ba ayen, “Waai meena a te Naawen biisiteerɔwa zula kama, alege ka wa dek tɛŋka demma ale wa dɔk demma nyiini ale ka a te wa zula.” ");
INSERT INTO bwu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Wa an jam a tom wakperikaliisa yegayega dula jigini, dii nyiŋ la ba jam ka siaka ale wa. ");
INSERT INTO bwu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Da ŋala po Galili demma naawa waai ate ba a wi wa ayen Ayerod la, a yaa wom Yeezu wie. ");
INSERT INTO bwu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Wa yaa wi wa kpaŋŋa a weeni ba ayen, “Jɔɔn waai ale jam a te nuruba soka ale nyiam la a yiti kum po kama. Ka dila ale soa ate wa baga a tom wakperikaliisaŋa de.” ");
INSERT INTO bwu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ayerod a jam faari ka wa suoku waai ate ba a wi wa ayen Filip la powa. Wa yue a jam ale Ayerodiasi. ");
INSERT INTO bwu_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jɔɔn a liŋ jam a weeni Ayerod kama ayen, “Fi ale nyɛ dii ale fi suoku powa la an nala.” Jɔɔn ale weeni dii la a basi kama ate Ayerodiasi a nyɛ ate Ayerod a tom wa nuruma ba gela ate ba ga yik Jɔɔn a lik dɔk po. ");
INSERT INTO bwu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ayerod a jam a yaali ayen wa ko wa kama, alege wa jam a chali Juuma yɔgsum, dii nyiŋ la ba jam a poli kama ayen Jɔɔn a jam ka Naawen biisiteerɔma po wanyi. ");
INSERT INTO bwu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ayerod biamu benni danni ale jam a paari la, wa yaa wi nuruba yegayega ayen ba jam a maa de wa biamu danni ŋandiintaŋa. Ba ale jam a tigsi chaab a boro a de la, Ayerodiasi leewa a yaa jo dɔk kuui ate ba jam kala a de la, a yaa gogi. Wa gogtaŋa a jam a te Ayerod supeentik nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Wa yaa a pe a weeni wa ayen, “Jaab buui meena ate fi a yaali la, weeni mu ate m te fu.” ");
INSERT INTO bwu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nipɔkbinni a yaa nyini a cheŋ wa mawa jigi a bek wa jaab buui ate wa ayen wa yaali naawa jigi la. Wa ale biisi ale wa mawa a nueri la, wa yaa ŋmani a cheŋ Ayerod jigi a weeni wa ayen, “Mi a yaali kama ayen fi basi ate fi nuruma a ga gebi Jɔɔn zukku a ta jam te mu.” ");
INSERT INTO bwu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Wa wieŋa a jam kaasi Ayerod sui nna yegayega, alege wa an jam baga a zɛri ya, dii nyiŋ la wa jam a pe kama ale nipɔkbinni nuruma meena nimbie po. Wa yaa weeni wa sojima ");
INSERT INTO bwu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ayen ba cheŋ juijui ate ba lik Jɔɔn la a ga gebi wa zukku a ta jam. ");
INSERT INTO bwu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ba ale ga nyɛ dila a nueri la, ba yaa pa zukku a dueni taasi tanlaŋ po a ta ŋmani a cheŋ ga te nipɔkbinni. Wa yaa tuesi ku a ta ga te wa mawa. ");
INSERT INTO bwu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jɔɔn ŋaaŋviirima ale jam a wom dii ale nyɛ la, ba yaa cheŋ a ga pa wa nyiŋka a ta ga gu. Ba yaa ga weeni Yeezu. ");
INSERT INTO bwu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yeezu ale ga wom dii ale nyɛ Jɔɔn la, wa yaa cheŋ a ga jo ŋaaruŋ po a cheŋ sagini po wa dek wa nyiini. A se wa ale jam a cheŋ la, nuruba yegayega a yaa nya wa. Ba yaa basi ba tɛŋsaŋa ale a yiti a de niŋ a chali a ga paari du ale ge ate wa yaa wari ŋaaŋ a jam. ");
INSERT INTO bwu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yeezu ale a nyini ŋaaruŋku po a siŋ tɛŋ la, wa yaa nya nuru bɔari nna yegayega ale ba za a limsi wa. Wa jiirim a yaa jam bo ale ba ate wa yaa tebi baai ale a yuagi la. ");
INSERT INTO bwu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Wa ale wa ŋaaŋviirima ale jam a bo dula jigini ate ku beni la, ba yaa jam a weeni wa ayen, “Nya ti meena a za ka sagi po ate wenni me a siŋ ti dela. Basi ate nuru bɔanni a cheŋ tɛŋkpansaŋa po a ga da ŋandiinta a de.” ");
INSERT INTO bwu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yeezu a yaa weeni ba ayen, “M kan yaali ayen m basi ate ba cheŋi, alege nama dek a te ba ŋandiinta ate ba de.” ");
INSERT INTO bwu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ba yaa weeni wa ayen, “Tama a ta ka borobotta tinu ale juma ŋaye dela jigini.” ");
INSERT INTO bwu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Wa yaa weeni ba ayen, “Ni ta a jam te mu.” Ba yaa ga a ta jam. ");
INSERT INTO bwu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yeezu a yaa weeni ate nuruma meena a kali tɛŋ dula jigini, ate wa yaa a pa borobottaŋa tinuwa ale jumaŋa ŋayewa a zak wa zuk a nya wenŋmazuk a puusi a te Naawen ayen wa niak ti. Wa ale puusi a ga nueri la, wa yaa wie boroboruku a pa te wa ŋaaŋviirima ayen ba pa a chari nuruma, ");
INSERT INTO bwu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ate ba meena a yaa ŋobi chak. Ba ale ŋobi a ga nueri la, Yeezu ŋaaŋviirima a yaa pa busisa pi ale siye a pa ŋandiin taliŋa a sueri si. ");
INSERT INTO bwu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Baai ale jam a ŋobi boroboruku ale jumaŋa la nidɔama nyiini a jam ka tusa ŋanu. ");
INSERT INTO bwu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yeezu yaa weeni wa ŋaaŋviirima ayen ba jo ŋaaruŋku po a taamu mogi kpeeni kauk kuŋkula ŋaaŋ nyiŋ, abe ba ge ate wa banti nuru bɔanni ate ba kuli ba yeeŋa. ");
INSERT INTO bwu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wa ale banti ba a nueri la, wa yaa cheŋ a ga jueli guuk kunyi zuk ayen wa puusi a te Naawen. Tɛŋka ale jam a sobri la, Yeezu dek wa nyiini ale jam bo dula. ");
INSERT INTO bwu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Wa ŋaaŋviirima a yaa jam bo ŋaaruŋku po nyiamu sunsuŋ ate vioku a fɔbi ba ŋaaruŋku a basi kauk yoŋ. ");
INSERT INTO bwu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ku ale jam a paari vari kpadiaka kumka po la, Yeezu a yaa nyini guuku zuk a siŋ a cheŋ a ga siŋ mogini po a za nyiamu zuk a cheŋ wa ŋaaŋviirima jigi. ");
INSERT INTO bwu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ba meena ale nya wa ale wa za nyiamu zuk a cheŋ cheena ba jigi la, yɔgsum a yaa deri yik ba nna yegayega. Ba yaa kaari nna yegayega, dii nyiŋ la ba jam a poli ayen wa ka kok. ");
INSERT INTO bwu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yeezu a yaa deri kpabi a weeni ba ayen, “Ka mi. Ni yigi ni dek abe ni kan a chali yɔgsumɔa.” ");
INSERT INTO bwu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Piita a yaa weeni wa ayen, “M Nyɔnɔ, ku dan ka fi, be weeni mu ate m nyini ŋaaruŋku po a cheŋ nyiamu zuk a jam fi jigi.” ");
INSERT INTO bwu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yeezu a yaa weeni wa ayen, “Be nyini a jam.” Piita a yaa basi ŋaaruŋku ale nyini a cheŋ Yeezu jigi. ");
INSERT INTO bwu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","A se wa ale jam a cheŋ la, wa yaa nya ale vioku a jam a pagra kama nna yegayega. Yɔgsum a ya deri yik wa ate wa yaa a siŋ nyiamu tɛŋ. Wa yaa kaari a weeni ayen, “M Nyɔnɔ, yik mu.” ");
INSERT INTO bwu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yeezu a yaa deri teeri wa nisaŋa a yik wa ale a weeni wa ayen, “Ka boa ate fi ka siaka ale mi ale a chamu?” ");
INSERT INTO bwu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yeezu ale Piita a yaa cheŋ a ga jo ŋaaruŋku po. Ba ale ga jo ku po a nueri la, vioku a yaa deri basi. ");
INSERT INTO bwu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Wa ŋaaŋviirima baai ale jam a tali a bo ŋaaruŋku po la a yaa pak Yeezu ayen, “Wensie fi sum ka Naawen biik.” ");
INSERT INTO bwu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ba yaa jam a taam jueli mogi kpeeni kauk kuŋkula a ga paari tɛŋ kaai ate ba a wi ayen Genesaret la. ");
INSERT INTO bwu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Baai ale jam bo dula la, a yaa nya Yeezu a deri miŋ wa. Ba yaa deri tom ayen ba ta yuaroma a jam wa jigi. ");
INSERT INTO bwu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ba yaa saalim wa ayen wa basi ate yuaroma a tiri wa garuku nɔanni ate ba baga a nya nyiŋyɔgsa. Baai meena ale jam a tiri wa garuku nɔanni la a nya nyiŋyɔgsa kama. ");
INSERT INTO bwu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Farisiima ale Juuma Sinsak sagrɔma ba gela a yaa nyini Jerusalem tɛŋka a tigsi chaab a jam Yeezu jigi a bek wa ayen, ");
INSERT INTO bwu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ka boa ate fi ŋaaŋviirima a zɛri ti kokpieŋsaŋa sinsaŋŋa vaka? Ba kan nari ba nisimaŋa a magsi alege a de ŋandiinta.” ");
INSERT INTO bwu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yeezu a yaa weeni ba ayen, “Nama a kasim a va ka ni dek kisitaŋa, alege a kan va Naawen sinsaŋŋa. ");
INSERT INTO bwu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ba ŋmarisi Naawen gbaŋka po dila po dila po ayen wa weeni ayen, ‘Nama a kasim a te ni koba ale ni maba zula.’ Waai a dan le wa ko a yaa se wa ma, ba ko kula nyɔnɔ. ");
INSERT INTO bwu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nama a nyiem a kasim a sak nuruba ni kokpieŋsaŋa siuku ayen nuru waai a dan weeni wa ko ale wa ma ayen jaab buui ate wa a ayen wa pai a maari wa la ka Naawen ale soa. ");
INSERT INTO bwu_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nama a kan basi ate nuru wala a maari ba. Ni daa nyɛ dila, nama a va ka ni kokpieŋsaŋa siuku ale ge a kaasi Naawen sinsaŋŋa. ");
INSERT INTO bwu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nama ka venta nyam Naawen biisiteerɔwa Azaya ale ŋmarisi nama wie dii Naawen gbaŋka po la ka wensie. Wa ŋmarisi ayen, ");
INSERT INTO bwu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Naawen a weeni ayen, nuruma de a pa ka ba noa nyiini a zuli mi, alege ba suniimaŋa a ka mi jigi ya. ");
INSERT INTO bwu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ba nyiem a kasim a pa ka nurubisa kisita a sak nuruba ale a weeni ayen ti ka Naawen kisita. Ka dila ale soa ate ba puusaŋa a ka kiri mi jigi la.’ ” ");
INSERT INTO bwu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yeezu yaa ŋman wi nuru bɔanni ate ba jam wa jigi. Wa yaa weeni ba ayen, “Ni lagri ni tueŋa a wom ate ni miŋ dii ate mi a yaali ayen m weeni a sak ni la. ");
INSERT INTO bwu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ŋanta baai ale a jo ni noaŋa po la a kan te ni daŋta, alege ŋanta baai ale nyini ni noaŋa po a nyini la, ale a te ni daŋta.” ");
INSERT INTO bwu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Wa ŋaaŋviirima a yaa weeni wa ayen, “Fi ale a weeni dii la, Farisiima sue an peenti ya.” ");
INSERT INTO bwu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yeezu a yaa weeni wa ŋaaŋviirima ayen, “Mi Kowa waai ale bo wenŋmazuk la a nyɛ se ka kpaaro waai a nyiem ale kasim a bori wa ŋanta la. Da yeŋ po wa le weeni wa tomteerɔma ayen ba ga a voori ŋanta baai meena ale chim ŋan kayaata la a yuk basi. ");
INSERT INTO bwu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ni kan basi ate Farisiima ale a biisi dii la a daani ni. Ba a nyɛ se ka yeeba ale a dari chaab dii la. Ba meena a le ga a lo ka goluk po.” ");
INSERT INTO bwu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piita a yaa weeni wa ayen, “Be weeni wamagsini de kiri a sak ti.” ");
INSERT INTO bwu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yeezu a yaa bek ba ayen, “Nama me a ka yammɔa? ");
INSERT INTO bwu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nama a ze ayen ŋanta baai ale a va ni noaŋa po a jo ni puusaŋa po la me a va ka ni bitagifiisa me a nyiini? ");
INSERT INTO bwu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ni an miŋ ya? Ni noaŋa po biika a nyini ka ni suniimaŋa po a nyini ale a basi ate ni a ta daŋta. ");
INSERT INTO bwu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ŋanta baai ale bo nuru sunum po la ale a basi ate wa poli wabaata ale a tom kaboŋsa ale nipɔk yaalik tuima ale a ko chaab ale a zu ale a velimu a te chaab ale a kaasi chaab yue. ");
INSERT INTO bwu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tuimaŋa de meena ale a basi ate nuruba a ta daŋta. Nuruba a dan ka a nari ba nisima ale ge a de ŋandiinta a se Farisiima kisiku ale a va dii la, kula a kan basi a te ba a ta daŋta.” ");
INSERT INTO bwu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yeezu a yaa ŋman basi dula jigini ale ge a cheŋ Taaya ale Saidon tɛŋsaŋa. ");
INSERT INTO bwu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nipɔk wanyi ale nyini Keenan a bo dula jigini. Wa yaa jam a saalim Yeezu ayen, “M Nyɔnɔ, fi waai ale ka naawa Deevid ŋaaŋbiik la, ta jiirim ale mu, dii nyiŋ la chichiribiok ale bo m lie zuk po a daani wa.” ");
INSERT INTO bwu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yeezu a yaa sina. Wa ŋaaŋviirima a yaa jam a weeni wa ayen, “Ti Nyɔnɔ, ti a saalim fu ayen fi yiak nipowa de ate wa ŋmani ti ŋaaŋ, dii nyiŋ la wa va ti kama a nuemu.” ");
INSERT INTO bwu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yeezu a yaa weeni ba ayen, “Naawen ale tom mu ayen m cheŋ Juuma baai ale a nyɛ a se piisa ale be la, nyiini jigi.” ");
INSERT INTO bwu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nipowa ale wom dii ate wa a weeni la, wa yaa kpi dunduna tɛŋ Yeezu niŋ a weeni wa ayen, “M Nyɔnɔ, mi a saalim fu kama ayen fi maari mu.” ");
INSERT INTO bwu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yeezu yaa a weeni wa ayen, “Ku an magsi ayen ba pa bisaŋa ŋandiinta a te baasa.” ");
INSERT INTO bwu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nipowa a yaa weeni wa ayen, “M Nyɔnɔ, dii ate fi weeni la ka wensie, alege baasaŋa a de ka ŋandiin tii ate bisaŋa a de ale a tali la.” ");
INSERT INTO bwu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yeezu a yaa weeni wa ayen, “Fi ta siaka ale mi ka nna yegayega. M le nyɛ dii ate fi a yaali la a te fu.” Wa ale weeni dila la, nipowa lie wa a yaa deri nya nyiŋyɔgsa. ");
INSERT INTO bwu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yeezu a yaa ŋman basi dula jigini ale ge a ga bo Galili mogi kpeeni noai a nyiemu a yaa ga paari jigi a jueli a kala guuk kunyi zuk. ");
INSERT INTO bwu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Wa le kala dula jigini la, nuru bɔari a yaa jam wa jigi ale ba yɔgnyeensa. Yɔgnyeensaŋa de jam ka gbanisa ale yeeba ale gbatta ale gaauŋta. Yeezu a yaa puusi ate ba nya nyiŋyɔgsa. ");
INSERT INTO bwu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nuru bɔanni meena ale nya ale gaauŋtaŋa a biisi ate gbaritaŋa me a yiti a zaani a baga a cheŋ, ate gbanisaŋa me naŋsaŋa a teenti ate yeema me ninaŋa a lagri ate ba a nya la, ku yaa cha ba nna yegayega. Ba yaa pak Izirali Naawenni ale a te wa zula wieŋa de meena nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yeezu a yaa wi wa ŋaaŋviirima a weeni ba ayen, “M jiirim a bo ale nuruma de meena kama, dii nyiŋ la ba kasim a bo ale mi kama daa ŋata, alege ba an diem a de ŋandiinta. M dan basi ayen ba kuli ale kommu, ba le viiri siuku niŋ.” ");
INSERT INTO bwu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wa ŋaaŋviirima a yaa bek wa ayen, “Dela ka sagi po. Te ti nya ŋandiinta ka be ate ba paari nuruma de a soa nna?” ");
INSERT INTO bwu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yeezu a yaa bek ba ayen, “Ka borobotta ti dina ate ni tara?” Ba yaa weeni wa ayen, “Ka borobotta tiyopoi ale juma maga la ale boro.” ");
INSERT INTO bwu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Wa yaa weeni nuru bɔanni meena ayen ba kali tɛŋ. ");
INSERT INTO bwu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Wa yaa pa borobottaŋa tiyopoi wa ale jumaŋa a puusi a te Naawen ayen wa niak ti, a yaa le ge a wie a te wa ŋaaŋviirima ayen ba pa a chari nuru bɔanni. Ba yaa pa a chari ba meena. ");
INSERT INTO bwu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ba meena a yaa ŋobi a chak a yaa le ge ate Yeezu ŋaaŋviirima a pa boroboruk tii ale tali la a sueri busisa siyopoi. ");
INSERT INTO bwu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nuru baai ale ŋobi boroboruku ale jumaŋa la, nidɔama meena nyiini a jam ka tusa ŋanaansi. ");
INSERT INTO bwu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nuruma ale de nueri la, Yeezu a yaa banti ba ayen ba kuli, ale ge ate wa ale wa ŋaaŋviirima a ga jo ŋaaruŋ po a cheŋ a ga paari tɛŋ kaai ate ba a wi ayen Magdala la. ");
INSERT INTO bwu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisiiba ale Sajusiba ba gela a yaa jam Yeezu jigi ayen wa tom wakperikaliik a sak ba ate ba miŋ ayen wa pagrimu a sum nyini ka Naawen jigi. ");
INSERT INTO bwu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Wa yaa weeni ba ayen, “Wenbinni a daa siŋ ate chiŋmaaŋa a muni ni seba kama ayen ŋmoruk a kan ni. ");
INSERT INTO bwu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Wenbinni a dan pusi a jueli ate chiŋmaaŋa a sobri, ni seba kama ayen ŋmoruk a le ku ni. Ni dan poom seba ayen ŋmoruk le ni yaa se ku kan ni alege nama an baga a seba wie ŋaai a le ŋa nyɛ jinla la kiri ya.” ");
INSERT INTO bwu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yeezu a yaa ŋman weeni ba ayen, “Nama jinla demma a zɛri Naawen ka nna yegayega ale a tom wabaata. Mi a kan siagi a tom wakperikaliik a te nama yɔgyɔgla de. Wakperikaliik kaai ate nama a le nya da yeŋ po la ale dii ate Naawen a tom ale wa biisiteerɔwa Jona dila po dila po la.” Wa yaa basi ba ale ge cheŋ. ");
INSERT INTO bwu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ba ale bo ŋaaruŋku po a taamu mogi kpeeni kauk kuŋkula la, Yeezu ŋaaŋviirima a yaa baŋi ba ŋandiintaŋa a basi ŋaaŋ. ");
INSERT INTO bwu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yeezu a yaa weeni ba ayen, “Ni a limsi abe ni kpesi ni dek ale Farisiima ale Sajusima dabintaŋa.” ");
INSERT INTO bwu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Wa yaa ale weeni dila la, ba yaa bek chaab ayen, “Ka tama ale kan ta boroboruk la ale soa ate wa a weeni dila?” ");
INSERT INTO bwu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yeezu a yaa seba ayen ba an jam a miŋi ayen wa a sak ba ka Farisiima sinsaŋŋa wie. Ka dila nyiŋ ale soa ate wa yaa a bek ba ayen, “Ka boa ate boroboruk kuui ate nama a baŋi la a daani ni ate nama a biisi ku wie? Nama a ka siaka ale mi nalimnyiini. ");
INSERT INTO bwu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nama an diem a miŋ ya? Nama a kan teeri dii po ate mi a pa borobotta tinuwa a wie a chari ate nuruba tusa ŋanuwa la? Ka busisa si dina ate ni pa a sueri?” ");
INSERT INTO bwu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Wa yaa ŋman bek ba ayen, “Mi ale ŋman a pa borobotta tiyopoiwa a wie a chari ate nuruba tusa ŋanaansiwa la, ka busisa si dina ate ni pa a sueri? ");
INSERT INTO bwu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mi a poom a weeni ni kama ayen ni kpesi ni dek ale Farisiima ale Sajusima sinsaŋŋa. Mi a poom kan biisi ale ni ka boroboruk kuui ate ni baŋi basi ŋaaŋ la wie.” ");
INSERT INTO bwu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yeezu ŋaaŋviirima ale ga wom dii ate wa biisi la, ba yaa deri miŋ ayen wa a sak ba kama ayen ba kpesi ba dek ale Farisiima ale Sajusima sinsaŋŋa. Daa ayen wa jam a weeni ba kama ayen ba kpesi ba dek ale ba dabin tii ate ba pa a nyo ba boroboruku po la. ");
INSERT INTO bwu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ku ŋaaŋ nyiŋ Yeezu ale wa ŋaaŋviirima yaa cheŋ tɛŋkpaŋ sii ale jam gilim Siizariya Filipai tɛŋka la. Ba ale ga paari dula jigini la, wa yaa bek ba ayen, “Nuruba a weeni ayen mi Saalobiika ka wana?” ");
INSERT INTO bwu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ba yaa weeni wa ayen, “Ba gela a weeni ayen fi ka Jɔɔn waai ale jam a te nuruba soka ale nyiam la. Mba me a weeni ayen fi ka Naawen biisiteerɔwa Elaja, ale ge ate mba me a weeni ayen ka Naawen biisiteerɔwa waai ate ba a wi wa ayen Jerimaya la, a yaa se wa biisiteerɔma po wanyi ale ŋman pilim jam.” ");
INSERT INTO bwu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Wa yaa bek ba ayen, “Nama dek a weeni ayen mi ka wana?” ");
INSERT INTO bwu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Piita a yaa weeni wa ayen, “Fi ka Naawen waai ale boro la, biik. Fi be ŋman ka Varibasidɔwa waai ate Naawen a jam weeni ayen wa le tom wa ate wa jam la.” ");
INSERT INTO bwu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yeezu a yaa weeni wa ayen, “Fi Simon, Jɔɔn biika, Naawen a le basi ate fi sui a peenti nna yegayega. Nurubisa an sak fu wensie ŋaai ate fi biisi la, alege m Kowa waai ale bo wenŋmazuk la, le sak fu. ");
INSERT INTO bwu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Dila nyiŋ ate mi a weeni fi Piita, baai ate Naawen a soa la a nyɛ se ka yeri ate mi a boro a se la, ate fi a chim yenni nyubini. Sitaana ale wa chichiribaataŋa meena a kan baga a kaasi di diipo diipo meena wuu. ");
INSERT INTO bwu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","M le pa Naawen namu chaafiisaŋa a te fu. Ŋanta baai ate fi pa zaani tɛŋzuk de ayen nuruba a va ba la, bala me a le zaani wenŋmazuk. Ŋanta baai me ate fi a kan pa a zaani tɛŋzuk de la, bala me a kan zaani dula jigini.” ");
INSERT INTO bwu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Wa ale a biisi ale Piita a nueri la, wa yaa weeni wa ŋaaŋviirima meena ayen ku a fe kama ate nama dek a kan weeni a sak nuru waai ya ayen ka mi ale Varibasidɔwa waai ate Naawen a weeni ayen wa le tom wa ate wa jam da yeŋ po la. ");
INSERT INTO bwu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","A nyini va ŋala po a ta a cheŋ, Yeezu a yaa weeni wa ŋaaŋviirima a lagri ayen, “Ku magsi kama ayen m cheŋ Jerusalem tɛŋka. Dula jigini tɛŋka kpaŋŋa ale Juuma Puusika Yenni kpaŋŋa ale Juuma Sinsak sagrɔma meena a le basi ate mi a nam nna yegayega abe ba ge a ko mu, alege ku dan paari daa ŋata dai m le yiti kum po.” ");
INSERT INTO bwu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Piita a yaa le a wom wa wieŋa la, wa yaa yik wa a ta wa a taam nakpiak nyiŋ a tɔariŋ wa ayen, “Naawen dek a le maari ate dila a kan jam fi jigi ya.” ");
INSERT INTO bwu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yeezu a yaa viriŋ a weeni Piita ayen, “Cheŋ du mi tɛŋ di nyiŋ la fi ta ka Sitaana popola. Fi a daani mu kama ale m tuima tomka. Fi la biisi dii la an nyini daa Naawen jigi ya, alege dii nyini ka nuruba jigi.” ");
INSERT INTO bwu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yeezu a yaa ŋman weeni wa ŋaaŋviirima ayen, “Nuru a daa yaali ayen wa va mi ŋaaŋ, basi ate wa liŋ a zɛri wa dek yaalika, abe wa pa wa jabarimu a vi wa maŋkpalaŋa zuk a jam va mi. ");
INSERT INTO bwu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nuru waai nina a dan muni wa dek yaalika nyiŋ, kula nyɔnɔ a le jam a lo. Nuru waai ale pa mi ale Naawen wamaŋsaŋa a nyo wa dek yaalika nyiŋ la, wala a le jam a tuesi Naawen nyuvuri paalini. ");
INSERT INTO bwu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nuru waai a dan baga a nya tɛŋzuk masimu meena, ka boa nyuenta ate wa a ayen wa nya? Wa kan baga tuesi Naawen nyuvuri dii ale kan ta kpeglimka la. Ka boa ate nuru ayen wa pa a gerimu a nya wa nyuvuriya? ");
INSERT INTO bwu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mi Saalobiika a le ŋman pilim a jam ale Naawen pagrimu ale wa zulaŋa ale wa sabiiloma. M dan jam m le tuni waai meena a magsi ba tuima le ka dii la. ");
INSERT INTO bwu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ni basi ate m weeni ni ayen nuruba a bo dela jigini kama a kan kpi ase ka ba nya mi Saalobiika ale m cheena a se naab la.” ");
INSERT INTO bwu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Daa ŋayuebi ale jam a taam la, Yeezu a yaa wi Piita ale Jeemsi ale wa suoku Jɔɔn a ta ba a jueli guuk kpioŋ kunyi zuk a bo dula ba dek ba nyiini. ");
INSERT INTO bwu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ba ale jam a bo dula la, Yeezu nimbidiaka a yaa tagri ba niŋ ale a nyagsi a se wenbinni la. Wa gataŋa me a tagri ale peenti ale a nyagsi nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ba yaa nya Elaja ale Moosis a boro a biisi ale Yeezu. ");
INSERT INTO bwu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Piita a yaa weeni Yeezu ayen, “M Nyɔnɔ, tama ale bo dela la a nala kama. Basi ate ti pili viita tita a te ni ate fi a soa kunyi, Moosis me a soa kunyi abe Elaja a soa kunyiwa.” ");
INSERT INTO bwu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Piita ale diem boro a biisi la, chiŋma nyagsini a yaa deri jam a lik ba. Ba yaa a wom lueluk chiŋmanni po ate ku weeni ayen, “Ka mi biika ate mi a yaali la ale nna. Wa a nyɛ ate m sui a peenti. Dila nyiŋ la ni be wom wa.” ");
INSERT INTO bwu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yeezu ŋaaŋviirima ale wom lueluku la, yɔgsum a yaa deri yik ba nna yegayega, ate ba nyiŋsa a gok ate ba yaa lo tɛŋ a pa ba loga a vugi tɛŋ. ");
INSERT INTO bwu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yeezu a yaa jam ba jigi a tiri ba ale weeni ba ayen, “Ni yiti ŋmai abe ni kan te ni kpaziim a nagi.” ");
INSERT INTO bwu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ba ale yiti ŋmai a gisi nya la, ba an jam a nya waai ya, alege ka Yeezu nyiini ale jam za ba tɛŋ. ");
INSERT INTO bwu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ba ale nyini guuku zuk a siŋ la, Yeezu a yaa weeni ba ayen, “Dii ate ni nya la, ni kan weeni a sak waai ya a se ka da dii danni ate mi Saalobiika a yiti kum po la.” ");
INSERT INTO bwu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ba yaa bek Yeezu ayen, “Ka boa ale soa ate Juuma Sinsak sagrɔma a weeni ayen ka Elaja a le wa liŋ a jam?” ");
INSERT INTO bwu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Wa yaa weeni ba ayen, “Ku ka wensie ate Elaja a liŋ a jam a gomsi jaab meena. ");
INSERT INTO bwu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mi a weeni ni kama ayen Elaja a poom jam kama. Nuruba a jam ze ayen ka wa ale la ate ba yaa nyɛ wa dii ate ba a yaali la. Ba abe le nyɛ mi Saalobiika me ka dila degadega.” ");
INSERT INTO bwu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Wa ŋaaŋviirima ale wom dii ate wa biisi la, ba yaa deri miŋ ayen wa a biisi ka Jɔɔn sokateerɔwa wie. ");
INSERT INTO bwu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ba ale jam a biisi ale chaab a nueri la, ba yaa a jam paari wa ŋaaŋviirima mbala ate nuru bɔari yegayega a za a gilim ba. Nuru wanyi a yaa jam a kpi dunduna tɛŋ Yeezu niŋ. ");
INSERT INTO bwu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","A yaa weeni wa ayen, “M Nyɔnɔ, ta jiirim ale m biika, dii nyiŋ la kpiŋkpinsa ale ta wa ale a daani wa nna yegayega. Wa nyiem a kasim a a lo ka botta po ale nyaata po a nyɛ ayen wa ko wa dek. ");
INSERT INTO bwu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","M saalim ka fi ŋaaŋviirima ayen ba tebi wa, alege ba an baga a tebi wa.” ");
INSERT INTO bwu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yeezu a yaa weeni ayen, “Nama jinla demma a ka siaka ale mi ale kasim a nyɛ a kaasi. Nama a yaali ayen mi a bo ale ni a paari ka dimpo abe ni miŋ mu? Mi ale yik m dek ale ni a paari ka dimpo? Ta biika a jam mi jigi denna.” ");
INSERT INTO bwu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ba yaa ta wa a jam Yeezu jigi, ate wa yaa weeni chichiribioku ayen ku nyini biika jigi a nyini. Wa ale weeni dila la, biika a yaa deri nya nyiŋyɔgsa. ");
INSERT INTO bwu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yeezu ŋaaŋviirima a yaa nya wa ba dek ba nyiini a yaa bek wa ayen, “Ka boa ale soa ate tama an poom baga a yiak chichiribioku ate ku nyini biika jigi ya?” ");
INSERT INTO bwu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Wa yaa weeni ba ayen, “Nama siaka an zuak ya. Ni basi ate m weeni ni ayen a se ni siaka a dan soa a se be dii ate ba a wi ayen ‘Mastad’ la, nama ate baga kama a weeni guuk kpioŋku de ayen ku yiti dula jigini a cheŋ. Ku le sum a yiti. Ku dan ka dila, ni baga kama a nyɛ jaab buuri meena. ");
INSERT INTO bwu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Alege chichiribioku de choawa dan kan daa noai bobika ale puusa nalimnyiini, ni an baga a yiak ate ku a nyini.” ");
INSERT INTO bwu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Yeezu ale wa ŋaaŋviirima a yaa basi dula jigini ale ge cheŋ Galili. Ba ale ga paari dula la, wa yaa weeni ba ayen, “Nuruba a le jam a yik mi Saalobiika a nyo nuru baai ale ba ko mu la nisima po, alege daa ŋatawa danni m le yiti kum po.” Wa ŋaaŋviirima ale wom wieŋa de la, ba sue a yaa kaasi nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yeezu ale wa ŋaaŋviirima ale ga paari Kapernaum tɛŋka po la, Juuma Puusika Yenni lampoo cheesiroma a yaa jam Piita jigi a bek wa ayen, “Fi sagrɔwa a tuni Juuma Puusika Yenni lampoowa?” ");
INSERT INTO bwu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piita a yaa weeni ba ayen, “Mm, wa a tuni kama.” Piita ale jo yenni po ayen wa weeni wa dii ale nyɛ la, Yeezu a yaa de niŋ a bek wa ayen, “Simon Piita, ka bana ale a tuni lampoo a te tɛŋka kpaŋŋa? Ka nichamma yaa ka tɛŋka demma? Fi a poli ka se?” ");
INSERT INTO bwu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piita yaa weeni wa ayen, “Ka nichamma ale a tuni.” Yeezu a yaa weeni wa ayen, “Ku kiri ale tɛŋka demma a kan tuni. ");
INSERT INTO bwu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Alege tama a kan yaali ayen ti daani nuruma de. Cheŋ mogi kpeeni a ga pa fi ŋmiaka a yuk a yik juma nyiamu po. Jum buui ate fi liŋa a yik la, fi le nya ligri bu nɔanni po dii ale a magsi mi ale fi Juuma Puusika Yenni lampoowa tutuna la.” Ta di a cheŋ a ga tuni a te lampoo cheesiroma. ");
INSERT INTO bwu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Da yeŋ po Yeezu ŋaaŋviirima a yaa jam wa jigi a bek wa ayen, “Ka wana ale kpagi Naawen Naamu po?” ");
INSERT INTO bwu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yeezu a yaa yik biik wanyi a ta jam a zaani ba niŋ, ");
INSERT INTO bwu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","a yaa weeni ba ayen, “Ni basi ate m weeni ni ayen a se ka ni pa ni dek a chim a se bisa la, kan daa di ni kan jo Naawen Naamu po. ");
INSERT INTO bwu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nuru waai ale yik wa dek ale a nyɛ ase biik la ale a chim kpagi Naawen Naamu po. ");
INSERT INTO bwu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nuru waai ale a tuesi biika de mi vaka nyiŋ la, wala a tuesi ka mi dila. ");
INSERT INTO bwu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Nuru waai a dan nya biik ate wa ta siaka ale mi, alege ate wa paasi wa ayen wa va siuk kuui ale kan nala la, kula nyɔnɔ a magsi ka ba pa miik a bobi niri a pa yik wa ŋiri a ta wa a ga yuk basi mogi kpeeni nyiamu po, kula ale zunchoŋa. ");
INSERT INTO bwu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nuruba ba gela a nyiem a kasim a yaali kama ayen ba a paasi nuruba ate ba a va tuim kaasima siuk. Ku ale jam bie baai ale nyɛ dila la jigi. ");
INSERT INTO bwu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Nuru waai a dan pa wa nisima a yaa se wa nantuok a tom wabiok, ku a fe ate wa gebi wa nisimaŋa a yaa se wa nantuoku a yuk basi. Nuru waai a dan ta ni yeŋ a yaa se naŋ yeŋ ale nya nyuvuri dii ale kan ta kpeglimka la, kula ale zunchoŋa a gaam wa ale ta nisima siye a yaa se naŋsa siye alege a cheŋ a ga jo bolim buui ale kan maara kpimsi la po. ");
INSERT INTO bwu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nuru waai a dan pa wa num a tom wabiok, ku a fe ate wa yeeri bu a yuk basi. Nuru waai ale ta num bunyi ale ge a ta nyuvuri dii ale kan ta kpeglim la, kula ale zunchoŋa a gaam wa le ta nina ŋaye ale ge a jo bolim buui ale kan maara kpimsi la po. ");
INSERT INTO bwu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Nama a kpesi ni dek abe ni ka a nya bisaŋa de a se ba daa nuruba la. Ni basi ate m weeni ni ayen ba sabiiloma a bo ka m kowa Naawen waai ale bo wenŋmazuk la, jigi. ");
INSERT INTO bwu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mi Saalobiika a jam ayen m gisi ka baai ale be la a vari ba a basi. ");
INSERT INTO bwu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Nuru waai a dan ta piisa kook ate kunyi a be, nama a poli ayen nuru wala a le nyɛ ka se? Wa a basi ka nŋala guutaŋa zuima ale ge a gisi kunyiwa. ");
INSERT INTO bwu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mi a weeni ni kama ayen wa dan nya ku, wa sui ale peenti nna yegayega ku nyiŋ a gaamu nŋala meena. ");
INSERT INTO bwu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Siuku la po ni Kowa Naawen waai ale bo wenŋmazuk la, a kan yaali ayen bisaŋa de po wanyi a be. ");
INSERT INTO bwu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Fi suok a dan nyɛ fu a kaasi, cheŋ wa jigi a ga weeni wa ayen wa nyɛ fu kaasi kama. Wa dan siak wa le kaasi la, fi ale wa ale ŋman niak chaab. ");
INSERT INTO bwu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Wa dan zɛri yik fi doa wanyi a yaa se baye ate ba chim fi seeroba a maa biisi fi ale fi suoku ale a ayen ni biisi dii la. ");
INSERT INTO bwu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Wa dan ŋman zɛri ba me ta ba a cheŋ ate ni ga a weeni a sak Yeezu ŋaaŋviirima ku meena. Wa be dan ŋman zɛri ba me, nama a kan ŋman ta wari ale wa a se nama ale kan ta wari ale lampoo cheesiroma ale baai ale kan da Kirisita bisa dii la. ");
INSERT INTO bwu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Wensie ate mi a weeni ni ayen ŋanta baai, ate nama a pa zaani tɛŋzuk de ayen nuruba a va ba la, bala me a le zaani wenŋmazuk. Ŋanta baai me ate nama a kan pa a zaani tɛŋzuk de la, bala me a kan zaani dula jigini. ");
INSERT INTO bwu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“M be ŋman a weeni ni kama a gum du ayen nama baye a dan tu chaab a puusi a te Naawen wari nyiŋ ale ta siaka ni kowa Naawen waai ale bo wenŋmazuk la, a le pa a te ni. ");
INSERT INTO bwu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nuruba baye a yaa se nuruba bata a dan tu chaab mi yonni nyiŋ mi a le bo ale ba.” ");
INSERT INTO bwu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Da yeŋ po ate Piita a yaa jam Yeezu jigi a bek wa ayen, “M Nyɔnɔ, a se m suok a dan kasim a nyɛ mu a kaasi ka bu dina ate mi ayen m voŋ a te wa? Ku noai buyopoi yaa?” ");
INSERT INTO bwu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yeezu a yaa weeni wa ayen, “Daa buyopoi dekki, alege kasim a a voŋa te wa a ta a cheŋ. ");
INSERT INTO bwu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Basi ate m weeni ku kiri ale ka dii la a sak fu. Naawen naamu a nyɛ se ka tɛŋ kaai naab la. Da yeŋ po ate wa yaa wi wa tomteerɔma ayen wa bek ba a wom a se ba tuimaŋa ka se. ");
INSERT INTO bwu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ba meena ale tigsi chaab a jam la, wa yaa a wi wa tomteerɔma po wanyi a ta nyini a zaani ba niŋ. Nuruwa de a jam a piem ka ligra nna yegayega naawa jigi, ");
INSERT INTO bwu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","alege wa an jam a baga a tuni ŋa a te wa. Naawa ale ga wom nyaku de la, wa yaa weeni wa nuruma ayen ba ga koalim wa ŋanta baai meena ate wa ta la a da abe ba yik wa dek ale wa dɔk demma meena a ta ga da ate ba chim yom. Dila a le basi ate wa baga a nya wa ligraŋa meena. ");
INSERT INTO bwu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tomteerɔwa ale wom dii ate naawa a weeni la, wa yaa deri a kpi dunduna tɛŋ wa niŋ a saalim wa ayen, ‘M nyɔnɔ, yik fi sunni m le tuni fu ŋa meena.’ ");
INSERT INTO bwu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Naawa a yaa jam ta jiirim nna yegayega ale wa a yaa voŋ wa pamini meena a te wa ale a weeni wa ayen wa a cheŋ. ");
INSERT INTO bwu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Tomteerɔwa a yaa le basi naawa yenni ale cheŋ la, wa yaa ga tu naawa tomteerɔma po wanyi. Nuru waai ate wa tu la a jam a ta ka wa ligra nna maga dega. Wa ale ga paari nuruwa la, wa yaa deri bobi nuruwa a ŋmeeni ale a weeni wa ayen, ‘Tuni mu m ligraŋa meena’. ");
INSERT INTO bwu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Wa pamini nyɔnɔwa a yaa kpi dunduna tɛŋ wa niŋ a saalim wa ayen, ‘Yik fi sunni m le tuni fu ŋa meena.’ ");
INSERT INTO bwu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Alege tomteerɔwa a zɛri ale ta wa a ga lik dɔk po a ta ga paari dii po ate wa baga a tuni wa pamini meena la. ");
INSERT INTO bwu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Naawa tomteerɔma ba gela ale wom dii ale nyɛ la, ku yaa daani ba nna yegayega ate ba yaa cheŋ naawa jigi a weeni wa ba ale wom dii la. ");
INSERT INTO bwu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Naawa ale wom la, wa yaa wi tomteerɔwa ate wa jam wa jigi ate wa yaa weeni wa ayen, ‘Fi ka kiri ya. Fi ale jam saalim mi la, m voŋ fi pamini meena dii ate fi ta la kama a te fu. ");
INSERT INTO bwu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","M ta jiirim ale fu kama. Fi me ate poom a ta jiirim ale waai ale de fi pamini la kama.’ ");
INSERT INTO bwu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Naawa sui a yaa a jam a puuri nna yegayega ale wa tomteerɔwa ate wa yaa a basi ate wa nuruma a yik wa a ta ga lik dɔk po ale a te wa waalika a ta ga paari dii po ate wa tuni wa pamini meena a nueri la.” ");
INSERT INTO bwu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yeezu biika ale mɔata kpeglimka la, wa yaa weeni baai meena ale a wom la ayen, “Mi Kowa Naawen ale bo wenŋmazuk la ale nyɛ ni ka dila degadega ase ni a nin kan voŋ a te chaaba ale ni suniima meena.” ");
INSERT INTO bwu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yeezu ale biisi a ga nueri la, wa yaa basi Galili ale ŋman cheŋ Judia a taam Jodan beni kauk kuŋkula. ");
INSERT INTO bwu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nuru bɔari yegayega a yaa jam wa jigi ate wa tebi yɔgnyeensaŋa meena dula jigini. ");
INSERT INTO bwu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisiima ba gela a yaa jam wa jigi ayen ba choa wa noai a nya a se wa ale biisi wari a kaasi ya. Ba yaa bek wa ayen, “Nuru waai a dan zɛri wa pɔk, kula a kisi?” ");
INSERT INTO bwu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yeezu a yaa weeni ba ayen, “Ba ŋmarisi Naawen gbaŋka po ayen, ‘Ku piilimka po ate Naawen a nyɛ tɛŋzuk meena la, wa nyɛ ka nidɔa ale nipɔk.’ ");
INSERT INTO bwu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","A yaa weeni ayen, ‘Ku nala kama ate nidɔa a basi wa ko ale wa ma ale ge a ga faari nipɔk ate ba noai bayewa a chim bunyi. Nama an diem a karim kula?’ ");
INSERT INTO bwu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ba ŋman daa nuruba baye, ba yaa ka nuru yeŋ. Dila nyiŋ la baai ate Naawen a basi ate ba chim nuru yeŋ la, ku an magsi ayen nuru a poori ba.” ");
INSERT INTO bwu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farisiima a yaa bek wa ayen, “Dii ate fi a weeni la ka wensie, alege ka boa ate Moosis a sak nuruba dila po dila po ayen nuru waai a dan zɛri wa pɔk, kula nyɔnɔ a ŋmarisi gbaŋ ate ku sak nuruba ayen wa zɛri wa powa kama?” ");
INSERT INTO bwu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yeezu a yaa weeni ba ayen, “Moosis a te ni siuk ayen ni a nyɛ dila kama dii nyiŋ la ni sakka a pagra kama. Alege ku jam daa dila a nyini diipo ate Naawen a nyɛ tɛŋka la. ");
INSERT INTO bwu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Dila nyiŋ nuru waai pɔk a dan kan pa wa dek a te nidɔa yoŋ wa, alege ate wa zɛri wa powa ale faari nipɔk wa choa kula nyɔnɔwa a nyɛ ka kaboŋ.” ");
INSERT INTO bwu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wa ŋaaŋviirima a yaa weeni wa ayen, “Ku dan ka dila nidɔa ale wa pɔk jigi, ku zunchoŋa kama ate nidɔaba meena a kali dakɔksa.” ");
INSERT INTO bwu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Wa yaa weeni ba ayen, “Waai meena a kan baga a va mi sinsaŋŋa de. Ka baai nyiini ate Naawen a lueri la, a le ba va ŋa. ");
INSERT INTO bwu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Dila wie tɔgatɔga nyiŋ ale soa ate nuruba a kan faari nipooba. Ba gela a kan faari dii la ba biak ba ka dila. Baai me a kan faari dii la ba je ba kama. Mba me a kan faari Naawen naamu nyiŋ. Baai ale baga a va mi sinsaŋŋa de la, ni basi ate ba a va ŋa.” ");
INSERT INTO bwu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Dula jigini nuruba ba gela a yaa pa ba bisa a ta a jam Yeezu jigi ayen wa pa wa nisaŋa a tiri ba abe wa puusi a te ba, alege wa ŋaaŋviirima a yaa tɔariŋ ba. ");
INSERT INTO bwu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yeezu a yaa weeni wa ŋaaŋviirima ayen, “Ni te bisaŋa siuk ate ba jam mi jigi. Ni kan yiak ba. Nama a ze ayen ka bala ale soa Naawen naamu?” ");
INSERT INTO bwu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Wa yaa pa wa nisaŋa a tiri ba a yaa le ge a cheŋ. ");
INSERT INTO bwu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","A se Yeezu ale jam bo siuku po a cheŋ la, nuru wanyi a yaa jam a bek wa ayen, “M Sagrɔ, ka boan jaab tuim maŋ a le mi m tom ate m baga a nya nyuvuri dii ale kan ta kpeglimka la?” ");
INSERT INTO bwu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yeezu a yaa bek wa ayen, “Ka boa ate fi a bek mu ŋan maŋsa wie? Nuru waai an baga a chim nuru maŋ ŋa ka Naawen nyiini. Fi daa yaali ayen fi nya nyuvuri dii ale kan ta kpeglimka la, be va sinsaŋŋa.” ");
INSERT INTO bwu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nuruwa a yaa bek wa ayen, “Ka boan jaab sinsaga?” Yeezu a yaa weeni wa ayen, “Juuma Sinsaŋŋa ale nna. Kan ko nuru, kan nyɛ kaboŋsa, kan zu, kan chim venta seero, ");
INSERT INTO bwu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","a zuli fi ma ale fi ko abe fi a yaali fi saalo choa ase fi dek la.” ");
INSERT INTO bwu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nuruwa a yaa weeni wa ayen, “Wieŋa de meena mi kasim a va ŋa kama. Mi abe ŋman nyɛ ka boa a gum du?” ");
INSERT INTO bwu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yeezu a yaa weeni wa ayen, “Fi dan a yaali ayen fi kan ta kaasuŋɔa ate fi nya nyuvuri dii ale kan ta kpeglimka la, cheŋ ga pai fi ŋanta meena a da a pa ligraŋa a te niwomma abe fi jam a va mi. Fi dan nyɛ dila fe le jam a nya ŋanta Naawen jigi.” ");
INSERT INTO bwu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Wa ale wom dii ate Yeezu a weeni wa la, wa sui a yaa deri kaasi, dii nyiŋ la wa jam ka jigsiro. Wa yaa deri cheem wa ŋaaŋ te Yeezu a cheŋ. ");
INSERT INTO bwu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yeezu a yaa weeni wa ŋaaŋviirima ayen, “Ku le pagra a te baai ale ka jigsiroba la a baga jo Naawen naamu po. ");
INSERT INTO bwu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ni yaala ate m ŋman weeni ni ayen ase laalaakomi a dan baga a va garupein vorub po a taamu a nyini ŋanta nyɔnɔ me a baga a jo Naawen naamu po kama.” ");
INSERT INTO bwu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ku yaa cha wa ŋaaŋviirima nna yegayega ate ba yaa weeni chaab ayen, “Ku dan ka dila, ka wana a le wa baga a jo Naawen naamu po?” ");
INSERT INTO bwu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yeezu a yaa nya ba a weeni ayen, “Dan ka nuruba nyiini jigi, ku kan baga a nyɛ, alege dan ka Naawen jigi, wie meena a baga a nyɛ kama.” ");
INSERT INTO bwu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Dula jigini Piita a yaa weeni wa ayen, “Nya, tama basi ka ti ŋanta meena ale jam va fu. Tama ale nya ka boa ku nyiŋŋa?” ");
INSERT INTO bwu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yeezu a yaa weeni ba ayen, “Wensie ate mi a weeni ni, mi Saalobiika a dan ŋman jam ayen m soa tɛŋzuk meena demma abe m bo ba buusa, nama ŋaaŋviiriba pi ale bayewa de a le jam a bo Izirali dɔkdemma pi ale bayewa buusa. ");
INSERT INTO bwu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nuru waai ale basi wa yeri ale wa suaata ale wa tɔaba ale wa koba ale wa maba ale wa bisa ale wa kadugsa mi nyiŋ la, Naawen a le ŋman a pa wa ŋanta bala po wanyiwanyi kook kook a gum du a te wa abe wa pa nyuvuri dii ale kan ta kpeglimka me a te wa. ");
INSERT INTO bwu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nuru baai yegayega ale bo niŋ yɔgyɔgla de la, le jam a taam ka ŋaaŋ. Baai me ale bo ŋaaŋ la a le jam a taam de niŋ.” ");
INSERT INTO bwu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yeezu a yaa ŋman weeni ba ayen, “Naawen naamu a nyɛ ase ka talim nyɔnɔ la. Saliuk yokyokwa wa yaa yiti a gisi nuruba ayen ba kpa wa talimu po a te wa. ");
INSERT INTO bwu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Wa yaa le nya ba la, wa yaa weeni ba ayen ba dan kpa ate wenni a siŋ, wa le tuni ba dai dila danni ligraŋa. Ba ale siak la, wa yaa ta ba a cheŋ wa talimu po. ");
INSERT INTO bwu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Wenni ale jueli magla, wa yaa cheŋ yabaŋa po a ga nya nuruba ba gela ale ba za. ");
INSERT INTO bwu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Wa yaa weeni ba ayen, ‘Ni dan cheŋ ka mi talimu po a ga kpa a te mi nna m te a tuni ni ka dii ale a magsi la.’ Ba yaa siak a cheŋ. ");
INSERT INTO bwu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Wenbinni ale ga jueli wenzuk sunsuŋ la, wa yaa ŋman basi ate kpaaroba ba gela a cheŋ wa talimu po a ga gum mbala po. ");
INSERT INTO bwu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Wenbinni ale mɔata siŋka la, wa ŋman cheŋ yabaŋa po a ga nya nuruba ale ba za. Wa yaa bek ba ayen, ‘Ka boa ate nama a kasim a za denna danni meena?’ ");
INSERT INTO bwu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ba yaa weeni wa ayen, ‘Nuru karo a te ti tuini ayen ti tomu.’ Wa yaa ŋman weeni ba ayen, ‘Nama me a cheŋ m talimu po a ga kpa.’ ");
INSERT INTO bwu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Wenbinni ale siŋ la, talimu nyɔnɔwa a yaa cheŋ wa talimu po a ga weeni kpaaroma kpagini ayen, ‘Wi kpaaroma meena ate ba jam.’ Wa yaa pa ligraŋa a te kpagini ayen wa ŋɔa a tuni ba, ale weeni wa ayen, ‘Piilim a tuni baai ale wari ŋaaŋ a jam la abe fi ge a tuni baai ale liŋ a jam la ŋaaŋ nyiŋ.’ ");
INSERT INTO bwu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Dula jigini kpagini a yaa tuni baai ale poom jam ale wenni a mɔata siŋka la, dai dila danni meena ligraŋa. ");
INSERT INTO bwu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kpagini ale boro a tuni baai ale a liŋ de niŋ a jam la, ba yaa poli ayen ba ligraŋa a le gaam baai ale jam ŋaaŋnyiŋ la ligraŋa kama, alege kpagini a tuni ba me ka dai dila danni meena ligraŋa. ");
INSERT INTO bwu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Wa ale ga tuni ba ba ligraŋa a nueri la, ba yaa ŋuuni ale talimu nyɔnɔwa. ");
INSERT INTO bwu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Kpaaroma po wanyi a yaa jam a weeni wa ayen, ‘Nuru baai ate fi basi ate ba wari ŋaaŋ a jam la, bala an kpa ate ku beniya. Tama a kpa kama ale kantueŋka ate wenni a ga siŋ, alege ate fi a yaa tuni ba a soa se fi ale fi tuni tama dii la.’ ");
INSERT INTO bwu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Talimu nyɔnɔwa a yaa weeni kpaarowa ayen, ‘M doa, goori a wom mi. Mi an gebi ni ligra a basiya, dii nyiŋ la mi ale nama a siak kama ayen m tuni ni dai yeŋ dai tutuna. ");
INSERT INTO bwu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Dila nyiŋ ni ta ni ligraŋa a kuli. M dek ale a yaali ayen m tuni baai ale wari ŋaaŋ a jam la me dai yeŋ dai tutuna. ");
INSERT INTO bwu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","M ka siuk a nyɛ m dek ale a yaali dii la ale m ligraŋa? Mi ale tuni nuruma de ligraŋa a gaam dii ate ba kpa la, nyiŋ ale soa ate nama a de nyunni ale ba.’ ” ");
INSERT INTO bwu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yeezu biika ale mɔata kpeglimka la, wa yaa weeni ba ayen, “Baai ale bo ŋaaŋ la, bala a le ba taam niŋ, alege ate baai ale de niŋ la me, a ŋman taam ŋaaŋ.” ");
INSERT INTO bwu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yeezu ale wa ŋaaŋviirima pi ale bayewa ale jam bo siuku po a cheŋ Jerusalem tɛŋka la, wa yaa weeni ba ba dek ba nyiini ayen, ");
INSERT INTO bwu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ni nya, ti bo ka ti siuku po a cheŋ Jerusalem tɛŋka. Ti dan paari dula jigini, nuruba ale yik mi Saalobiika a ta mu a ga nyo Juuma Puusika Yenni kpaŋŋa ale Juuma Sinsak sagrɔma nisima po. Bala a le bo mi kummu buusa. ");
INSERT INTO bwu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Abe ba ta mu a ga nyo baai ale kan daa Juuba la nisima po. Ba le nyɛ mu a la, abe ba nak mu abe ba yaa ko mu, alege daa ŋata dai Naawen a le basi ate m yiti kum po.” ");
INSERT INTO bwu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Da ŋala po Zebedi powa a yaa jam Yeezu jigi ale wa bisa bayewa a yaa kpi duna tɛŋ Yeezu niŋ a saalim wa ayen wa nyɛ wari a te wa. ");
INSERT INTO bwu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yeezu a yaa bek wa ayen, “Fi a yaali ayen m nyɛ ka boa a te fu?” Wa yaa weeni wa ayen, “Fi Naamu deka danni a dan paari, be pe ale mi ayen m bisaŋa bayewa le jam a kali fi tɛŋ ate wanyi a bo fi juga abe nwala me a bo fi gala.” ");
INSERT INTO bwu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yeezu a yaa weeni wa ayen, “Jaab buui ate fi a yaali la, fi ze dii ale bo ku ŋaaŋ a cheena la. Ninam buui ate mi ayen m nam la, fi bisaŋa ale baga a maa namu?” Wa bisaŋa a yaa weeni ayen, “Mm, ti le baga.” ");
INSERT INTO bwu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yeezu a yaa weeni ba ayen, “Wensie ninam buui ate mi ayen m nam la, nama me a le namu, alege m juŋŋa ale m galaŋa kalika jigini, Naawen ale wa lueri nuru baai a le ba kali du la la. Daa mi ale magsi ayen m lueri.” ");
INSERT INTO bwu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wa ŋaaŋviirima piwa ale wom la, ba sue a yaa puuri nna yegayega ale mbala bayewa. ");
INSERT INTO bwu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yeezu a yaa tigsi ba meena chaab a weeni ba ayen, “Ni seba ku le ka dii ale baai ale kan daa Juuba la. Baai ale a wi ba dek ayen nalima la, ba soa ka ba tɛŋka demma ale a sak ba pagrim. Ba kpaŋŋa me a sak ba pagrim kama. ");
INSERT INTO bwu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ku ka siuk ate nama me a va kula. ");
INSERT INTO bwu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nuru waai dan a yaali ayen wa chim nama naab ase ka wa a tom tuima ase tomteerɔ la a te nama. ");
INSERT INTO bwu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mi saalobiika an jam ayen m gisi ka nuru baai ale a tomu a te mi la. M jam ayen m tomu a te ka tɛŋka meena demma abe m kpi a tuesi ba a basi.” ");
INSERT INTO bwu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yeezu ale wa ŋaaŋviirima ale a cheŋ Jeriko tɛŋka la, ate nuru bɔari yegayega a va wa. ");
INSERT INTO bwu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ba ale jam a nyini tɛŋka po a nyini la, yeeba baye a yaa jam kala siuku nakpiak nyiŋ. Ba ale wom ayen Yeezu a va dula jigini a taam la, ba yaa kaari a wi wa ayen, “Ti Nyɔnɔ, fi naawa Deevid ŋaaŋbiika, ta jiirim ale ti abe fi maari ti.” ");
INSERT INTO bwu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nuru bɔanni a yaa weeni ba ayen ba goori ba wanni, alege ba zɛri ale a kaari nna yegayega a gaam ba le poom a kaari dii la ale ŋman wi wa ayen, “Ti Nyɔnɔ, fi naawa Deevid ŋaaŋbiika, ta jiirim ale ti abe fi maari ti.” ");
INSERT INTO bwu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yeezu a yaa zaani a wi ba ate ba jam wa jigi ate wa yaa bek ba ayen, “Nama a yaali ayen m nyɛ ka boa a te ni?” ");
INSERT INTO bwu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ba yaa weeni wa ayen, “M Nyɔnɔ, tama a yaali kama ayen fi nyɛ ate ti ninaŋa a lagri a te ti ate ti baga a nya.” ");
INSERT INTO bwu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yeezu jiirim a yaa jam bo ale ba ate wa yaa pai wa nisaŋa a tiri ba ninaŋa. Ba ninaŋa a yaa deri lagri ate ba yaa deri va wa. ");
INSERT INTO bwu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ba yaa jam paari tɛŋfiik kaai ate ba a wi ayen Betfaaji ale guuk kuui ate ba a wi ayen Olivi Guuku ate ka jam mɔata Jerusalem tɛŋka la. Yeezu a yaa wi wa ŋaaŋviirima po baye a ");
INSERT INTO bwu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","weeni ba ayen, “Nama a liŋ de niŋ a cheŋ ga jo tɛŋfiika po. Ni dan deri ga jo dula, ni le nya boniŋ ale ka biik ate ba bobi a zaani. Ni foli si a ta jam. ");
INSERT INTO bwu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ni dan boro a foli si nuru a le bek ni ayen, ‘Ka boa ate nama a nyɛ?’ Ni weeni wa ayen ka ni nyɔnɔwa ale a yaali si. Ni dan weeni dila, wa le te ni siuk ate ni foli si a ta jam.” ");
INSERT INTO bwu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yeezu a weeni ba nyaku de kama ate ku sak ayen dii ate Naawen biisiteerɔma wanyi wa a ŋmarisi Naawen gbaŋka po dila po dila po la a jam a chim wensie. Wa ŋmarisi ayen, ");
INSERT INTO bwu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Cheŋ a ga weeni tɛŋ kaai ate ba a wi ayen Zayon la demma ayen ni naawa waai ale seba wa dek yik la a le do bompaalik a jam ni jigi.” ");
INSERT INTO bwu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Wa ŋaaŋviirima bayewa a yaa de niŋ a cheŋ a ga nyɛ dii ate Yeezu a weeni ba la. ");
INSERT INTO bwu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ba yaa ga foli bonika ale ka biika a ta si a jam Yeezu jigi. Ba le ta si a ga paari wa la, ba yaa yeeri ba gattaŋa ti gela a pa vi bompaalika chiaka zuk ate Yeezu a yaa jueli a kali. ");
INSERT INTO bwu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nuru bɔari yegayega a yaa jam gilim ba ate nuruba yegayega a pa ba gatta a pati a dueni siuku po ayen Yeezu a ta wa bonika a cheŋ va ti zuk a taam. Ba gela me a cheŋ siuku nakpiak a ga che tiisa vaata a pati a dueni siuku po. ");
INSERT INTO bwu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ba le jam a bo siuku po a cheŋ ate baai a jam de niŋka, ale baai me a jam de ŋaaŋka la, meena a yaa zuli wa ale a kaari ayen, “Ti a pak fu. Fi waai ale ka naawa Deevid ŋaaŋbiik la. Naawen a niak waai ale cheena nyɔnɔwa yonni nyiŋ la. Ti a pak fu nalimnyiini.” ");
INSERT INTO bwu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yeezu ale ga jo Jerusalem tɛŋka po la, tɛŋka meena demma a yaa deri ta tugurik ale chaab. Ba meena a yaa jam a bek chaab ayen, “Ka wana ale nuruwa de?” ");
INSERT INTO bwu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nuru bɔanni ba gela baai ale Yeezu ale va chaab a ga jo tɛŋka po la, a yaa weeni ba ayen, “Nuruwa de ka Naawen biisiteerɔwa Yeezu. Wa nyini ka Nazaret tɛŋ kaai ale bo Galili la.” ");
INSERT INTO bwu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yeezu a ga jo Juuma Puusika Yenni po ate nuruba a jam boro a gerim dula jigini. Wa yaa vi ba meena ate ba nyini dula a nyini, ale ge a zak nuru baai ale jam ta ligraŋa a tagri la teebulitaŋa a tulim kpib, ale tusi baai ale ta nangbaŋsaŋa a da la zukpaglisaŋa a lonsi. ");
INSERT INTO bwu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Wa yaa bek ba ayen, “Nama a ze dii ate ba ŋmarisi Naawen gbaŋka po la? Ba ŋmarisi ayen, ‘Mi Yenni de ka puusika yeri.’ Ba ŋmarisi nyaku de kama alege nama a pa di a chim zueba kalika jigi.” ");
INSERT INTO bwu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nuruba a yaa ta yeeba ale gbatta a jam Yeezu jigi ate wa tebi ba dula jigini. ");
INSERT INTO bwu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Juuma Puusika Yenni kpaŋŋa ale Juuma Sinsak sagrɔma ale ga nya wakperikaliik sii ate wa tom la ale bisaŋa ale a pak wa dii la ale a weeni ayen, “Ti a pak fi naawa Deevid ŋaaŋbiika la”, ba sue a yaa puuri ale Yeezu. ");
INSERT INTO bwu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ba yaa bek Yeezu ayen, “Fi kan wom ba le a weeni dii la?” Yeezu yaa siak ale ge a bek ba ayen, “Nama an diem karim a wom dii ate ba ŋmarisi Naawen gbaŋka po ayen, ‘Naawen a lueri ka bisa ale biluaata ayen ba a pak wa.’ ” ");
INSERT INTO bwu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yeezu a yaa basi ba ale ge a cheŋ nyini tɛŋka po a cheŋ tɛŋ kaai ate ba a wi ayen Betani la po ga goa. ");
INSERT INTO bwu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Vari ale ŋman a veenti la saliuk, ba yaa basi Betani tɛŋka ale ge a ŋman a cheŋ Jerusalem tɛŋka ate kom a yaa jam ta Yeezu. ");
INSERT INTO bwu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ba le jam bo siuku po a cheŋ la, wa yaa nya kiŋkaŋ ale ka za siuku nakpiak. Wa yaa cheŋ ka tɛŋ ayen wa nya ase ka ta moota ya ate wa de, alege jaab a jam ka ka zuwa. Ka vaata nyiini ale jam boro. Yeezu a yaa weeni kiŋkaŋka ayen, “A nyini jinla danni a ta a cheŋ, nuru waai a kan ŋman a nya fi yoana a de.” Wa le ga weeni dila la, kiŋkaŋka vaataŋa meena a yaa deri jak ate ka kpi. ");
INSERT INTO bwu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Wa ŋaaŋviirima ale nya nyaku de la, ku yaa chim wakperikaliik nna yegayega ba jigi. Ba yaa bek chaab ayen, “Kiŋkaŋka a nyɛ ka se a deri kpi nna nwuli?” ");
INSERT INTO bwu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yeezu a yaa weeni ba ayen, “Ni basi ate m weeni ni ayen nama a dan ta siaka ale mi ale ka chichama, nama le baga a tom dii ate mi a nyɛ ale kiŋkaŋka la kama. Ni baga weeni guuku de me dek ayen ku yiti a cheŋ a ga zaani mogi kpeeni po ate ku sum a nyɛ dila. ");
INSERT INTO bwu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nama a dan ta siaka ale mi nalimnyiini ale a puusi a te Naawen ayen wa te ni jaab, wa a te ni kama.” ");
INSERT INTO bwu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ba le ga paari Jerusalem tɛŋka po la, ba yaa ŋman jo Juuma Puusika Yenni po. Yeezu ale jam boro a sak nuruma la, Juuma Puusika Yenni kpaŋŋa ale Juuma kpaŋŋa a yaa jam wa jigi a bek wa ayen, “Ka wana ale te fu pagrimu de ate fi a tom tuimaŋa de? Ka wana ale te fu siuk me ate fi a nyeemu jigi meena a tom tuimaŋa de?” ");
INSERT INTO bwu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yeezu a yaa weeni ba ayen, “Mi me ta wari ayen m bek ni. M dan bek ni ate ni baga a tulisi mu, m le weeni ni waai ale te mu pagrimu ate mi a tom tuimaŋa de meena la. ");
INSERT INTO bwu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jɔɔn ale jam a te nuruma soka la, ka Naawen ale jam te wa pagrimu yaa ka nuruba?” Wa le bek ba dila la, ba yaa ta nampaga ale chaab ayen, “Ti dan weeni ayen ka Naawen ale te wa pagrimu, wa le bek ti ayen, ka boa ate nama an siak a te wa?” ");
INSERT INTO bwu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ba gela a weeni ayen, “Ti dan weeni ayen ka nuruba ale te wa pagrimu, nuru bɔanni sue a le puuri ale ti, dii nyiŋ la ba a wi Jɔɔn ayen ka Naawen biisiteerɔ.” ");
INSERT INTO bwu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ba yaa tulisi Yeezu ayen, “Tama ze.” Yeezu a yaa weeni ba ayen, “Mi me kan weeni ni waai ale te mu pagrimu ate mi a tom tuimaŋa de meena la. ");
INSERT INTO bwu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ni wom dii ate mi tara ayen m weeni a sak ni la. Nuru wanyi ale jam boro a ta wa bisa baye. Da yeŋ po wa yaa weeni wa be kpagini ayen, ‘Cheŋ a ga kpa m talimu po jinla.’ ");
INSERT INTO bwu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Wa biika a yaa weeni wa ayen, ‘Mi kan yaali ayen m cheŋi.’ Ku le nyɛ maga dek la, wa yaa ŋman tagri wa popola a yaa cheŋ talimu. ");
INSERT INTO bwu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ku an jam beniya ate kowa a yaa cheŋ baaŋka jigi a weeni wa me ayen wa cheŋ a ga kpa talimu po. Wala a yaa siak, alege wa an cheŋiya.” ");
INSERT INTO bwu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Dula jigini Yeezu a yaa bek Juuma ayen, “Bisaŋa de bayewa, ka ba wana dek ale tom dii ate ba kowa a yaali la?” Ba yaa weeni wa ayen, “Ka kpagini.” Yeezu a yaa ŋman weeni ba ayen, “Wensie ate mi a weeni ni, lampoo cheesiroma ale nipɔk baai ale ka nidɔa yaalisa la a le basi ba wabaataŋa abe ba de ni niŋ a jo Naawen naamu po. ");
INSERT INTO bwu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jɔɔn Sokateerɔwa a jam kama ayen wa sak ni wensie siuku kuui ate nama ayen ni va la, alege ni jam ka siaka ale wa sinsaŋŋa. Lampoo cheesiroma ale nipɔk baai ale ka nidɔa yaalisa la meena a jam ta siaka ale wa sinsaŋŋa kama. Nama dek a seba nyaku de kama, alege nama an jam a basi ni wabaataŋa tomka ale ge va wa.” ");
INSERT INTO bwu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yeezu a yaa ŋman weeni ba ayen, “Ni basi ate m weeni ni wamagsini di choa. Nuru wanyi ale jam boro a kpa wa talim fiik. Wa yaa che daata a ti a gilim bu meena a yaa gomsi bu puuka po meena a yaa yaali nuruba ayen ba a limsi bu abe ba a tom bu po. Wa le nyɛ dila a nueri la, wa yaa nyeemu a cheŋ niŋniŋa. ");
INSERT INTO bwu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wa talimu tiisaŋa yoanaŋa pisika po ale jam a paari la, wa yaa tom wa tomteerɔma ba gela ayen ba cheŋ a ga tuesi yoanaŋa gela wa nuruma jigi a ta jam te wa. Ba yaa cheŋ ba jigi. ");
INSERT INTO bwu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Ba le ga paari dula jigini la, nuruma yaa yik ba a nak ba wanyi ale a ko wanyi ale ge a pisi tana a yuk nwala me. ");
INSERT INTO bwu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Talimu nyɔnɔwa a yaa ŋman tom wa tomteerɔma ba yega a gaam wa le poom a tom mbala dii la, alege nuruma a ŋman nyɛ ba me ase mbala la degadega. ");
INSERT INTO bwu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Wa yaa le ga tali wa dek bipoosini la, talimu nyɔnɔwa a yaa weeni wa dek ayen, ‘M le tomu ka m dek biika, dii nyiŋ la wala a dan cheŋ dula jigini ba le te wa zula.’ Wa yaa tom wa ate wa cheŋ. ");
INSERT INTO bwu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nuruma ale ga nya wa biika ale wa cheena la, ba yaa weeni chaab ayen, ‘Biika de kowa a dan jam kpi, wala a le wa tuesi wa kowa ŋantaŋa meena. Ni basi ate ti ko wa, ate wa kowa a dan jam kpi abe tama a soa wa ŋantaŋa meena.’ ");
INSERT INTO bwu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Biika ale ga paari talimu po la, ba yaa yik wa a ko wa a yaa vuuri wa a ta nyini talimu po a nyini peelim.” ");
INSERT INTO bwu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yeezu a yaa bek ba ayen, “Nama a poli ayen talimu nyɔnɔwa a dan wom nyaku de, ka boa ate wa ayen wa nyɛ tomteerɔma?” ");
INSERT INTO bwu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ba yaa weeni Yeezu ayen, “Wa le jam a yik ba kama a ko abe wa pa wa talimu a ŋman te nuruba ba chaab, ate wa tiisaŋa yoanaŋa pisika wein a dan paari, abe wa nya wa denni.” ");
INSERT INTO bwu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yeezu a yaa weeni ba ayen, “Nama an diem a karim Naawen gbaŋka po wieŋa a wom ale miŋ ŋa kiri juijui ate ba weeni ayen, ‘Tintain dii ate seeroma a zɛri ayen di daa tintain maŋ la, dila ale di tulim chim tintain maŋ a gaam ŋa meena. Naawen ale nyɛ dila. Di ka wakperikaliik ti jigi.’ ” ");
INSERT INTO bwu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yeezu ale biisi ga mɔata nuerika la, wa yaa weeni ba ayen, “Nuruwa talim fiika a nyɛ ase ka Naawen naamu la. Naawen a le yiak ni ate ni nyini wa naamu po a nyini abe wa ŋman pa bu a te baai ale a tom tuimmaŋsa la. ");
INSERT INTO bwu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nuru waai a dan lo tintanni de zuk di a gebi wa ka nna gela gela. Tintanni abe dan lo nuru waai zuk di a piak wa ka nna se zom la.” ");
INSERT INTO bwu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Juuma Puusika Yenni kpaŋŋa ale Farisiima ale wom dii ate Yeezu a biisi la, ba yaa deri miŋ ayen wa a biisi ka ba wie. ");
INSERT INTO bwu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ba yaa jam a yaali ayen ba yik wa, alege ba jam a chali ka nuru bɔanni yɔgsum. Nuru bɔanni a jam a poli kama ayen Yeezu a jam ka Naawen biisiteerɔma po wanyi. ");
INSERT INTO bwu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yeezu yaa ŋman magsi wamagsini a sak nuru bɔanni ayen, ");
INSERT INTO bwu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Naawen naamu a nyɛ se ka naab waai biik ale faari nipɔk ate wa yaa gomsi ayen wa wi nuruba ate ba jam wa yenni a de ŋandiinta abe ba gogi a te wa la. ");
INSERT INTO bwu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Wa yaa tom wa tomteerɔma ayen ba nyeemu a wi nuruba ate ba jam, alege ba an jam a yaali ayen ba jamu. ");
INSERT INTO bwu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Wa yaa ŋman wi wa tomteerɔma ba gela a weeni ba ayen, ‘Ni cheŋ a ga weeni nuruma ayen, ti nyɔnɔwa ŋandiin kpeentaŋa a gomsi nueri kama. Wa luk wa naakpeemaŋa ale pakpeemaŋa a ko a dik ayen wa te ni. Dila nyiŋ ni pii nyiŋ a jam.’ Wa le weeni ba a ga nueri la, wa yaa tom ba ate ba cheŋ. ");
INSERT INTO bwu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Alege nuru baai ate naawa a wi ayen ba jam la, niŋ a jam ka ale dii ate wa ta la. Ba wa wanyi a jam a cheŋ ka wa talim. M wa me a cheŋ yaba ayen wa gerim. ");
INSERT INTO bwu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Baai ale jam a tali la, a yaa yik naawa tomteerɔma a nak ko. ");
INSERT INTO bwu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Naawa ale wom dii ate ba nyɛ wa nuruma la, wa sui a yaa jam a puuri nna yegayega ate wa yaa tomu wa sojima ate ba cheŋ nuruma tɛŋka. Ba le ga paari dula jigini la, ba yaa yik nuru baai ale ko naawa tomteerɔma la a ko ale ju ba tɛŋka meena ale bolim a kaasi. ");
INSERT INTO bwu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Sojima ale jam bo siuku po a cheŋ la, naawa a yaa ŋman wi tomteerɔ paalisa ate ba jam wa jigi ate wa yaa weeni ba ayen, ‘Ŋandiin kpien tii ate mi a basi ate ba digi la a magsi deka kama, alege nuru baai ate mi a wi la, an magsi ti deka. ");
INSERT INTO bwu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ni nyini a cheŋ sukpeentaŋa po a ga wi waai meena ate nama a nya ba dula jigini la a ta jam ate ba de ŋandiintaŋa.’ ");
INSERT INTO bwu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Wa tomteerɔma a yaa nyini a cheŋ sukpeentaŋa po a wi waai meena ate ba nya dula la. Nuru maŋsa ale nuru baata a yaa jam tigsi chaab a sueri naawa yenni. ");
INSERT INTO bwu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ba meena ale jam tigsi a nueri la, naawa a yaa jo juijui ate ba boro la ayen wa puusi ba. Wa le nyiem bo nuruma po a diak waai meena nisima la, wa yaa ga nya nuru wanyi ale wa an jo garuk maŋsa. ");
INSERT INTO bwu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Naawa a yaa weeni wa ayen, ‘M doa, ka boa ale soa ate fi a jo kala dɔkku de po ale ge fi an jo garuk maŋsa?’ Wa le bek wa dila la, nuruwa a yaa jam kala a ka wari a tulisi. ");
INSERT INTO bwu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Naawa a yaa chiem a weeni wa tomteerɔma ayen, ‘Ni yik nuruwa de a bobi wa naŋsaŋa ale wa nisaŋa a gum chaab a ta wa a nyini a yuk basi legini po. Dula jigini wa le kum nna yegayega abe wa a ŋobi wa nyinaŋa.’ ” ");
INSERT INTO bwu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yeezu ale biisi a mɔata nuerika la, wa yaa weeni nuru bɔanni ayen, “Naawen a wi nuruba yegayega ayen ba jam wa jigi, alege wa lueri ka ba maga la.” ");
INSERT INTO bwu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farisiima a yaa basi wa ale nyini. Ba yaa zok ayen ba choa wa noai a nya ase wa le weeni wari a kaasi ya, ate ba nya siuk a ko wa. ");
INSERT INTO bwu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ba yaa tom ba ŋaaŋviirima ale Ayerod nuruma po ba gela wa jigi. Ba yaa weeni wa ayen, “Ti Sagrɔ, ti seba ayen fi ka wensie nyɔnɔ. Fi niŋ a ka dii meena ate nuruba a biisi fi wie la po. Fi kan chali yɔgsum ale wensie biisika ale waai meena ale nuru kpeenta me nimbie po. ");
INSERT INTO bwu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ti dan tuni ti lampoowa a te ti nakpioŋku Siiza, kula a nala yaa ku an nala? Ti tuni yaa ti kan tuni?” ");
INSERT INTO bwu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yeezu a poom seba ayen ba a yaali kama ayen ba choa wa noai nya, ate wa yaa weeni ba ayen, “Nama ka venta nyam. Ka boa ale soa ate ni a paasi mu? ");
INSERT INTO bwu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ni te mu ligra ŋaai ate ni pa a tuni lampoowa la dinyi ate m nya.” Ba yaa ta dinyi a jam te wa. ");
INSERT INTO bwu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yeezu yaa bek ba ayen, “Ka wana zuk ale wa yoi ale dua ligni nyiŋŋa?” ");
INSERT INTO bwu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ba yaa weeni wa ayen, “Ka nakpioŋku Siiza zukku ale wa yonni ale dua di zuk.” Yeezu yaa weeni ba ayen, “Ni be pa jaab buui meena ate Siiza a soa la a te wa, abe ni pa jaab buui meena me ate Naawen a soa la a te Naawen.” ");
INSERT INTO bwu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ba ale wom dila la, ku yaa cha ba nna yegayega, ate ba yaa basi wa ale ge cheŋ. ");
INSERT INTO bwu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Dula jigini Sajusima ba gela a yaa jam Yeezu jigi. Bala a jam ka siaka ayen nuruba a dan kpi, ba ale ŋman yiti kum po. ");
INSERT INTO bwu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ba yaa weeni wa ayen, “Ti Sagrɔ, Moosis a sak ti Naawen gbaŋka po ayen, ‘Nuru waai a dan faari nipɔk ate ba an biagi ale chaaba alege ate wa chorowa a kpi, tama a basi kama ate wa yua a faari nipowa a biak bisa a te wa ate wa yonni a kan be.’ ");
INSERT INTO bwu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nuruba bayopoi ale jam boro, ate ba meena a yaa chim ma yeŋ ale ko yeŋ bisa. Kpagini a yaa faari nipɔk. Wa le wa powa an jam a biak ale chaab a nyaya, ale ge ate nidɔawa a kpi. Waai ale ŋman pa saŋ la a yaa faari wa mɔwa powa ale ge ba me an jam a biak a nyaya ale ge ate wa me a kpi. ");
INSERT INTO bwu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ba meena bayopoiwa a faari nipɔk wala kama a taam tu. ");
INSERT INTO bwu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Nidɔama bayopoiwa meena ale kpi la, ku an jam beniya ate nipowa me a yaa kpi. ");
INSERT INTO bwu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Yɔgyɔgla, da dii dai ate nuruba meena ayen ba yiti kum po la, nuruba bayopoiwa de meena ale faari nipowa de a nya la, ka ba wana ale wa soa wa?” ");
INSERT INTO bwu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yeezu a yaa weeni ba ayen, “Ni ze Naawen gbaŋka po wieŋa nalimnyiini. Ka dila ale soa ate ni be ni siuku ale diem ze Naawen pagrimu me la. ");
INSERT INTO bwu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Da dii danni ate nuru meena a yiti kum po la, nipooba faarika a kan boro. Ba meena a le jam a nyɛ ase ka Naawen sabiiloma baai ale bo wenŋmazuk la. ");
INSERT INTO bwu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nama a dan kan ta siaka ayen nuruba a le yiti kum po, ku a sak kama ayen nama an karim Naawen gbaŋka po wieŋa a miŋ ku kiri juijui ate Naawen a weeni ayen, ");
INSERT INTO bwu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Mi ka Naawen dii ate ni kokpieŋsaŋa Abraham ale Aizik ale Jekob a puusi a te la.’ Baai ale ka kpeeba la an baga a puusi a te Naawen ya, alege ka baai nyiini ale ka ŋanvuuta la.” ");
INSERT INTO bwu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nuru bɔanni ale wom dii ate wa boro a sak ba la, ku yaa cha ba nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farisiima ale wom ayen Yeezu biika a masa gaamu Sajusima biika la, ba yaa a tigsi chaab a jam Yeezu jigi. ");
INSERT INTO bwu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ba wanyi, waai ale jam seba Juuma Sinsaŋŋa nalimnyiini la, a yaa jam ayen wa choa Yeezu noai a nya ale bega. ");
INSERT INTO bwu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Wa yaa bek wa ayen, “M Sagrɔ, ka Juuma Sinsaŋŋa po di dina ale gaamu ŋa meena?” ");
INSERT INTO bwu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yeezu a yaa weeni wa ayen, “ ‘A yaali Naawen ale fi sunum ale fi chiik ale fi popola meena.’ ");
INSERT INTO bwu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Sinsaŋŋa de ale gaamu ŋa meena. ");
INSERT INTO bwu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Sinsak ŋaai ale ŋman pa saŋ la ale nna, ‘A yaali fi choa ase fi dek la.’ ");
INSERT INTO bwu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sinsak ŋaai meena ate Naawen a weeni Moosis la ale Naawen biisiteerɔma meena sinsaŋŋa a nyini ka sinsaŋŋa de ŋayewa po.” ");
INSERT INTO bwu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Dai yeŋ po Farisiima ba gela a yaa ale ŋman tigsi chaab a jam Yeezu jigi la, wa yaa bek ba ayen, ");
INSERT INTO bwu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nama a weeni ayen Varibasidɔwa ka wana ŋaaŋbiik la?” Ba yaa weeni wa ayen, “Wa ka naawa Deevid ŋaaŋbiik.” ");
INSERT INTO bwu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Wa yaa ŋman bek ba ayen, “Ku dan ka dila, ka boa ale soa ate Naawen chiika a weeni Deevid ayen wa a wi Varibasidɔwa ayen wa nyɔnɔ? Ba ŋmarisi Naawen gbaŋka po ayen Deevid a weeni ayen, ");
INSERT INTO bwu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Mi Nyɔnɔwa Naawen a weeni mi Nyɔnɔwa ayen, kali mi juga geŋ ate ku jam a paari diipo ate mi ayen m basi ate ni dachaasaŋa a chim ni yom la.’ ");
INSERT INTO bwu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ase Deevid dek a dan a wi wa ayen ‘wa Nyɔnɔ’, wa nyɛ ka se a ŋman baga a chim Deevid ŋaaŋbiiga?” ");
INSERT INTO bwu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nuru waai a jam karo a baga a tulisi Yeezu. A nyini da dila danni a ta a cheŋ, nuru waai an ŋman jam bek Yeezu bega. ");
INSERT INTO bwu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yeezu a yaa ŋman sak nuru bɔanni ale wa ŋaaŋviirima. ");
INSERT INTO bwu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Wa yaa weeni ba ayen, “Juuma Sinsak sagrɔma ale Farisiima nyiini ale ta siuk ayen ba a kasim a sak nama sinsak ŋaai ate Naawen a pa te Moosis la. ");
INSERT INTO bwu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Bala dek me a kan va ba ale a sak ni dii la nalimnyiini. Ka dila ale soa ate ku chim fifiok ayen nama va dii ate ba a sak ni la, alege ni kan a va ba nyeka ale ka dii la. ");
INSERT INTO bwu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ba nyiem a gomsi ka jib dobrita a ta ti a jam dueni ayen nuruma a koati a ji, alege ba dek a kan maari a pa ba nisima a tiri a nya. ");
INSERT INTO bwu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ba kasim a nyɛ ka wie nna yegayega ayen nuruba a nya ba. Ba nyiem gebi ka gbaŋsa a ŋmarisi Naawen wieŋa a dueni du a pa bobi ba dieŋa ale ba nisaŋa nyiŋ. Ba gattaŋa zuesaŋa me a woŋŋa kama. ");
INSERT INTO bwu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ba dan tigsi chaab ayen ba de ba dakpeeni ŋandiintaŋa, a yaase ba jo ba tuka dɔkku po, ba a yaali kama ayen ba a kali zukpaglik sii ate ba kpaŋŋa a kali la zuk. ");
INSERT INTO bwu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ba nyiem a kasim a yaali kama ayen nuruba a puusi ba yabaŋa po abe ba a zuli ba abe ba a wi ba ayen, ‘Sagrɔba’. ");
INSERT INTO bwu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ni kan ta kanjanta abe ni a yaali ayen nuruba a wi ni ayen, ‘Sagrɔba’. Nama meena ka suaata ale ta sagrɔ wanyi dekki. ");
INSERT INTO bwu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ni kan a wi nuru waai ale bo tɛŋzuk de la ayen ni ‘Koa’, dii nyiŋ la ni meena a ta ka ko yeŋ ate wa bo wenŋmazuk. ");
INSERT INTO bwu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ni kan ta kanjanta abe ni a yaali nuruba ayen ba a wi ni ayen ‘Niŋdeeroba’. Mi waai ate nuruba a wi ayen Varibasidɔwa la nyiini ale nama meena niŋdeero. ");
INSERT INTO bwu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ni dan a yaali ayen ni gaam ni suaata, ku a fe kama ayen ni pa ni dek a chim ase ba tomteerɔba la. ");
INSERT INTO bwu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nuru waai a dan zak wa dek ŋmai, Naawen ale basi ate wa siŋ tɛŋ. Alege waai a dan yik wa dek tɛŋ tɛŋka, Naawen ale zak kula nyɔnɔwa ŋmai. ");
INSERT INTO bwu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Nama Juuma Sinsak sagrɔma ale Farisiima, ku le jam a tua kama ni jigi. Ni ka velinvendisa. Nama ale a sak nuruma dii la a nyɛ ase nama a yik ka Naawen naamu nansiuŋku tuoku a ligi ba nimbie po la. Nama dek a kan yaali ayen ni jo du, ni be kan basi ate nuruba a jo du. ");
INSERT INTO bwu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Nama Juuma Sinsak sagrɔma ale Farisiima, ku le jam a tua kama ni jigi. Ni ka velinvendisa. Nama nyiem a ga a paasi ka pukoga a tuesi ba ŋanta ale ge a paasi waai meena a puusi puusa woŋta a te Naawen. Dila nyiŋ la, wa dan jam ayen wa bo ni buusa, ni waalika le zuak yegayega. ");
INSERT INTO bwu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Nama Juuma Sinsak sagrɔma ale Farisiima, ku le jam a tua kama ni jigi. Nama ka velinvendisa. Nama nina a muni ka nna yegayega ayen ni nyɛ ate nuruba a tagri a va nama Naawen puusika siuku. Ba dan a va nama nyeka ba yaa tom tuimbaata a nya waalika a gaam nama. ");
INSERT INTO bwu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Nama baai ale de nuruba niŋ a ta ba a cheŋ ale kan nya siuku la, ku le jam a tua kama ni jigi. Nama a sak kama ayen, ‘Nuru waai a dan wi Juuma Puusika Yenni yoi a pe ŋmoruk, ku daa wariya. Alege wa dan wi ligmɔniŋka ale bo Juuma Puusika Yenni po la yoi a pe ŋmoruk, ku ka wakpeeni.’ ");
INSERT INTO bwu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nama bettaŋa nna, ka ba wana ale gaam wa choa? Juuma Puusika Yenni yaa ligmɔniŋka ale bo di po la? Ka Juuma Puusika Yenni ale a basi ate ligmɔniŋka a nala. ");
INSERT INTO bwu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ni be ŋman a sak me ayen, ‘Waai a dan wi Juuma Puusika Yenni jaab buui zuk ate ba a nyɛ kaabka la yoi a pe ŋmoruk ku daa wariya. Alege waai a dan wi Naawen tiirimu buui ale bo wa puusika yenni po la yoi a pe, ku ka wari.’ ");
INSERT INTO bwu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ni ka betta ale nyɛ ase yeeba la. Ka ba wana ale gaam wa choa? Tiirimu yaa jaab buui zuk ate tiirimu a dua la? Ka jaab buui zuk ate tiirimu a dua la ale a nyɛ ate tiirimu a welema. ");
INSERT INTO bwu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nuru waai a dan wi kaab teka jigini ale bo Juuma Puusika Yenni po la yoi a pe, wa maa pe ka tiirim buui ale dua ku zuk la yoi me nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nuru waai abe dan wi Juuma Puusika Yenni yoi a pe, wa maa pe Naawen waai ale bo di po la me yoi nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nuru waai a dan wi wenŋmazuk yoi a pe, wa maa pe ka Naawen zukpaglika, kaai ate wa a kali ka zuk la, yoi me nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Nama Juuma Sinsak sagrɔma ale Farisiima, ku le jam a tua kama ni jigi. Ni ka velinvendisa. Ni a sak kama ayen ŋanta baai ate ni a pa a nyo jenta po la, ni a lueri ku noai piwa po bunyi a te Naawen. Alege nyemagsika ale jiirim ale wensie ale nyɛ wari yegayega la ni zɛri. Wie ŋaai ale magsi ayen ni a nyɛ la ale la ase ni a nin poom a nyɛ nŋala. ");
INSERT INTO bwu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ni a nyɛ ase ka yeeba la. Nama nyiem zɛri ka nanjiuŋ neka alege ne laalaakomi. ");
INSERT INTO bwu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Nama Juuma Sinsak sagrɔma ale Farisiima, ku le jam a tua kama ni jigi. Ni ka velinvendisa. Ku a nyɛ ka nna ase ni ale a nari beerisa ale china ŋaaŋ alege a basi puusaŋa po dii la. Ni suniimaŋa po a sueri ale ka butuom nyeka nyiini. ");
INSERT INTO bwu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nama Farisiima a nyɛ ase ka yeeba la. Ni liŋ sugri ni suniimaŋa po ate nuruba a sum seba ayen nama a tom ka tuimmaŋsa. ");
INSERT INTO bwu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Nama Juuma Sinsak sagrɔma ale Farisiima, ku le jam a tua kama ni jigi. Nama ka velinvendisa. Nama a nyɛ ase ka boosi tii nyiŋsa ale a nyagsi alege ti puusaŋa po a sueri ale koba nyiini ale daŋ me nna yegayega la. ");
INSERT INTO bwu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Siuk kula po ate nama a nyiem a paasi nuruba ayen nama a tom ka tuimmaŋsa, alege ni suniimaŋa po a sueri ale ka tuimbaata ale venta nyiini. ");
INSERT INTO bwu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Nama Juuma Sinsak sagrɔma ale Farisiima, ku le jam a tua kama ni jigi. Nama ka velinvendisa. Nama a nyɛ ate Naawen biisiteerɔma ale nuru maŋsa baai ale kpi dila po dila po la, boositaŋa a kasim a nyagsi. ");
INSERT INTO bwu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ni nyiem a kasim a weeni chaab ayen ase tama a dan jam maa bo ka ti kokpieŋsaŋa tɛŋka po, tama ate an jam maa gum ba po a ko Naawen biisiteerɔma. ");
INSERT INTO bwu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nama a siak kama ayen nama ka baai ale ko Naawen biisiteerɔma la, ŋaaŋbisa. ");
INSERT INTO bwu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ni kokpieŋsaŋa ale piilim dii la, ni kasim a tom nueri. ");
INSERT INTO bwu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ni kokpieŋsaŋa a jam a nyɛ ase ka wiiga la. Dila nyiŋ la nama me a nyɛ ka dila. Naawen a dan jam ayen wa bo tɛŋzuk meena demma buusa, wa le weeni ayen nama a lo kama, ale a pa ni a nyo bolim buui ale kan maara kpimsi la po. Nama a poli ayen nama a le nyɛ ka se a chali be dula jigini? ");
INSERT INTO bwu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mi a weeni ni kama ayen, mi a le tom biisiteerɔba ale yam nyam ale sagrɔba ate ba jam ni jigi. Nama a le pa ba gela a yik ŋanbarinta nyiŋsa a ko ba, abe ni miiri ba gela ale fiŋsa ni tuka dɔkku po abe ni yiak ba ate ba nyini ni tɛŋsaŋa po a nyini. ");
INSERT INTO bwu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ni kokpieŋsaŋa a liŋ jam ko ka nuru wanyi waai ate ba a wi ayen Abil ate wa an jam a kaasi wari la. Ba jam a ko nuru maŋsa yegayega. Nuru waai ate ba jam a ko kpeglim la a jam le Zakaria, Barakaya biika. Ba jam a ko wa a mɔata ka kaab teka jigini Juuma Puusika Yenni po. Naawen a le te ni waalika abe wa weeni ayen nama ale soa baai meena ale jam kan kaasi wari la, kummu. ");
INSERT INTO bwu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Wensie ate mi a weeni ni Naawen a le te Juuma baai ale diem boro jinla la waalika abe wa weeni ayen bala ale soa wieŋa de meena a nyɛ.” ");
INSERT INTO bwu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Dula jigini Yeezu a yaa weeni ayen, “Nama Jerusalem demma, ni nyiem a kasim a ko biisiteerɔma baai ate Naawen a tom ba ni jigi la. Mi nyiem a kasim a yaali kama ayen m pɔbi ni meena a tara ase kpiak a ale a pɔbi ka bisa dii la, alege nama a kan siagi. ");
INSERT INTO bwu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ku kan beni ate Juuma Puusika Yenni a kaasi. ");
INSERT INTO bwu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mi a weeni nama kama yɔgyɔgla de ayen ni kan ŋman nya mi ase ka m ŋman pilim jamka danni. Da dila danni a dan paari, nama a le weeni ayen, ‘Ni basi ate ti a te waai ate Naawen a tom la pimpauk.’ ” ");
INSERT INTO bwu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yeezu ale yiti Juuma Puusika Yenni po a nyini la, wa ŋaaŋviirima a yaa wi wa ayen wa zaani a nya Juuma Puusika Yenni. ");
INSERT INTO bwu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Wa yaa weeni ba ayen, “Ni basi ate m weeni a sak ni. Ku danni a cheena kama ate nuruba a jam a kaasi jaab buuri ale bo dela la. Ba kan basi tintain yeŋ me di choa zuwa.” ");
INSERT INTO bwu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yeezu ale wa ŋaaŋviirima nyiini a yaa cheŋ a ga jueli a kala Olivi Guuku zuk. Ba yaa bek wa ayen, “Ka boa a le ku nyɛ ate ku sak ti ayen fi jamka ale tɛŋka zuk meena kpeglimka danni a mɔata kama?” ");
INSERT INTO bwu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Wa yaa weeni ba ayen, “Ni kpesi ni dek ate waai a kan paasi ni. ");
INSERT INTO bwu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nuruba yegayega a le jam a pa mi yonni nyiŋ a wi ba dek a weeni ayen ba ka Varibasidɔwa waai ate Naawen a weeni ayen wa le tom wa la abe ba paasi nuruba yegayega. Ku a fe kama ayen nama a kan va ba. ");
INSERT INTO bwu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ni dan wom kpaliŋsa wie ate si gela a mɔata ale ge si gela me a bo niŋniŋa, ni kan a chali yɔgsumɔa. Kula a le sak ni ayen tɛŋka kpeglimka danni a mɔata kama. ");
INSERT INTO bwu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tɛŋka meena demma ale ba nalima meena a le yiti a cheŋ a ga tu chaab kpaliŋsa po. Tɛŋka me a le choa nna yegayega ate kom a jam tɛŋka meena po. ");
INSERT INTO bwu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Wieŋa de meena a nyɛ ase ka nipɔk logi ale a dom alege ate wa a biak la. ");
INSERT INTO bwu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Nuruba a le yik ni a ta ni a ga nyo baai ale ba basi ate ni nya ninammu la nisima po ate ba ko ni. Waai meena a le kisi ni mi vaka nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Va ŋala po nuruba yegayega baai ale jam a ta siaka ale mi la, a le ŋmani mi ŋaaŋ vaka. Ba le kisi chaab abe ba a bobri chaab a sak. ");
INSERT INTO bwu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Biisiteerɔba yegayega baai ale kan seba Naawen la, a le jam a paasi nuruba yegayega. ");
INSERT INTO bwu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nuruba yegayega a le jam a basi chaab yaalika, dii nyiŋ la nuruba tuimbaata a le jam a waaŋi a tagli jigi meena. ");
INSERT INTO bwu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Waai a dan pik a ga paari ku nueri ka, Naawen a le vari wa a basi. ");
INSERT INTO bwu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nuruba a le jam a pa Naawen wamaŋsaŋa a sak nuruba Naawen naamu wie. Waai meena ale bo tɛŋka zuk la le liŋ wom wa wamaŋsaŋa wieŋa ale ge ate tɛŋka meena a kpeglim. ");
INSERT INTO bwu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ni wom mi wieŋa de nalimnyiini. Naawen biisiteerɔ waai ate ba a wi wa ayen Daniel la, a jam ŋmarisi wabiok kuui ale ku jam a basi ate nuruba a namu la wie kama Naawen gbaŋka po dila po dila po. Nama a le nya ku ale ku za juijui ale kan magsi ayen ku zaani la.” (Nuru waai ale a karim wieŋa de la, abe miŋ chak.) ");
INSERT INTO bwu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Baai meena ale bo Judia tɛŋka po la, a yiti a pii nyiŋ a chali nna yegayega a ga suk guutaŋa po. ");
INSERT INTO bwu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Baai ale bo ba gbirima zuima la a dan wom wabioku de wie, ba kan ŋman a yaali ayen ba siŋ a jo ba diinaŋa po a pa ba ŋanta. ");
INSERT INTO bwu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Baai me ale bo ba kadugsa po la a dan wom wanni de, ba me a kan ŋman jo ba diinaŋa po ayen ba pa ŋanta. ");
INSERT INTO bwu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Da ŋala po ku le jam a pagra nna yegayega a te nipɔk puusa ale baai ale ta biluaata la. ");
INSERT INTO bwu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ni a puusi a te Naawen ate kula kan jam a pagra a te nuruba ŋoota wenya yaase ba Vuusum Danni. ");
INSERT INTO bwu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ku dan pari da ŋala ninam buui ate nuruba ale nam la ale gaam ninam meena ate nuruba, a nam a ta nyini diipo ate Naawen a nyɛ tɛŋka la. Ninam bula choa a kan ŋman jam. ");
INSERT INTO bwu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Naawen a poom yeeri ninam daaŋa po ŋa gela a basi kama, dii nyiŋ la baai ate wa lueri ayen ba jam a va wa la nyiŋ. Wa dan kan yeeri ninammu daaŋa gela a basiya, waai ate kan nyini ninammu po a nyini. ");
INSERT INTO bwu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Da ŋala po nuru a le weeni ayen, ‘Nya, Varibasidɔwa bo ka dela.’ Wa choa me a le weeni ayen, ‘Varibasidɔwa bo ka dula.’ Ni kan a wom ba. ");
INSERT INTO bwu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nuruba ba gela me a le yiti a paasi nuruba a weeni ayen ka ba ale Varibasidɔwa. Ba baai me a le jam a weeni ayen ba ka Naawen biisiteerɔma. Ba le jam a tom wakperisa nna yegayega a paasi nuru baai ate Naawen a lueri ayen ba a va wa la, ase ba a nin baga. ");
INSERT INTO bwu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ni wom mi wieŋa de nalimnyiini. Mi a poom liŋ a weeni ni ba le cheena ayen ba nyɛ ni dii la kama. ");
INSERT INTO bwu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Va ŋala po nuru wanyi a le weeni ayen, ‘Ni nya, Varibasidɔwa a bo ka sagini po.’ Wa choa me a le weeni ni ayen, ‘Ni nya, Varibasidɔwa a suk a bo ka dewa.’ Nama a kan a wom ba. ");
INSERT INTO bwu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mi Saalobiika ŋman jamka ale nyɛ a ase ka nyagsika la a nyini kori a taam siŋ yeniŋ ate nuruba a nya. ");
INSERT INTO bwu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Ni seba ayen duinsa ale a gilim kauk kuui la, jakpiuk ale doa dula. ");
INSERT INTO bwu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Da ŋala po ninammu a dan jam nueri, wenbinni ale chirika a le chim ka legi ate chiŋmarisaŋa me meena a nyini wenŋmazuk a lo tɛŋ. Ŋantaŋa de meena ale bo wenŋmazuk a ta pagrim la, Naawen ale jam yik ba choa. ");
INSERT INTO bwu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nuruba ale deri nya saalobiika chiŋmaaŋa po ale wa cheena. Tɛŋka meena demma ale kum, dii nyiŋ la ba le nya mu ale m nyini chiŋmaaŋa po a cheena ale m pagrimu ale m zulaŋa ale m nalimu nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Naawen sabiiloma po ba wanyi ale jam a pa damuniŋ a peeri nna yegayega. Wa dan nyɛ dila, mi yaa a le tom sabiiloma ate ba waaŋ a sueri tɛŋka meena a tigsi nuru baai ate Naawen a lueri la. ");
INSERT INTO bwu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ni basi ate kiŋkaŋ a sak ni wari kiri. Ni nyiem a dan nya ale ka boro a pusi vaata, ni seba ayen kpari wein a mɔata kama. ");
INSERT INTO bwu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Siuk kula po me, ni dan nya wieŋa de meena ale ŋa boro a nyɛ, ni le seba ayen da ŋala a mɔata kama. ");
INSERT INTO bwu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ni basi ate m weeni ni nyaku de ayen jinla demma a kan kpi ase ka wieŋa de meena a jam nyɛ. ");
INSERT INTO bwu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Wenŋmazuk ale tɛŋzuk meena a le jam a nueri da yeŋ po, alege mi wieŋa a kan taamu diipo diipo. ");
INSERT INTO bwu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nuru waai a ze mi Saalobiika ŋman jamka danni. Mi ale Naawen sabiiloma me dek a ze, alege ka m kowa Naawen nyiini ale seba. ");
INSERT INTO bwu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mi ŋman jamka a le nyɛ ase ka dii ale jam a nyɛ ale nuru waai ate ba a wi wa ayen Nowa dila po dila po la. ");
INSERT INTO bwu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ase Nowa ale jam boro a nyɛ wa ŋaaruŋ kpioŋku la, waai meena a jam boro a nyɛ ka wa dek ale a yaali dii la. Ba jam kasim a de ŋandiinta ale a nyu ate nidɔaba me a faari nipooba. Ba kasim a nyɛ ka dila a ta ga paari diipo ate Nowa a jo wa ŋaaruŋku po alege ate nyiam a jam la. ");
INSERT INTO bwu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ba jam a ze ayen Naawen a le basi ate nyiam jam a sueri tɛŋka meena a gbiti ba a ko. Mi Saalobiika jamka a le nyɛ ase ka dai dila danni la. ");
INSERT INTO bwu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Dai dila dek danni nuruba baye a le bo ba kadugsa po a kpa, ate Naawen a pa wanyi a ta cheŋ abe wa ge wanyi wa. ");
INSERT INTO bwu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nipooba baye a le bo nanzuk po a num zom, ate wa pa wanyi abe wa ge wanyi wa. ");
INSERT INTO bwu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Ni kpesi ni dek abe ni a limsi, dii nyiŋ la ni ze dai dii danni ate ni nyɔnɔwa a cheena la. ");
INSERT INTO bwu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ni basi ate m weeni ni ayen ase yeri nyɔnɔ a dan seba ayen zueba a le jam wa yeri, wa a le kasim a nya kama ate zuema a kan baga a jo zu. Wa kan goa ase ka wa nin yik ba. ");
INSERT INTO bwu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Diipo ate nama a kan ŋman a poli ayen mi Saalobiika a le jam la, dila po ale m cheena. Ka dila ale soa ayen ni kasim a gomsi a magsi a limsi la. ");
INSERT INTO bwu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ka nama wana dek ale wa chim wensie ale yam nyɔnɔ wieŋa de meena po? Ku a nyɛ ase ka yeri nyɔnɔ waai ale lueri wa tomteerɔma po wanyi ayen wa chim kpagi mbala zuk abe wa a te ba ŋandiinta ate ba a de a yaa le ge a nyeemu la. ");
INSERT INTO bwu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yenni nyɔnɔwa a dan nyini wa le cheŋ juijui la a jam a nya ale tomteerɔwa a nyɛ dii ate wa weeni wa la, tomteerɔwa sui a le peenti. ");
INSERT INTO bwu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Wensie ate mi a weeni ni, yenni nyɔnɔwa a yaa le basi ate wa a nya wa yenni ŋantaŋa meena zuk a te wa. ");
INSERT INTO bwu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Alege tomteerɔwa waai ate yenni nyɔnɔwa a lueri la, a dan ka nyiŋworuk nyɔnɔ, wa a weeni wa dek kama ayen wa nyɔnɔwa a kan jamu nwuli. ");
INSERT INTO bwu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Dila nyiŋ la wa yaa yik wa tomteerɔ chaama a nak kama alege a cheŋ a ga gum baai ale boro a de ŋandiinta ale a nyu daata a bugi la jigi. ");
INSERT INTO bwu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Dai dii danni ate wa kan poli ayen wa nyɔnɔwa a cheena la, dai dila danni dek ate wa cheena. ");
INSERT INTO bwu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Wa nyɔnɔwa a dan jam nya dii ate wa tom la, wa sui a le puuri nna yegayega ale wa, ate wa namsi wa abe wa pa wa a gum chaab ale velinvendisaŋa. Wa ale bo ka dula a kum abe wa gobi wa nyinaŋa. ");
INSERT INTO bwu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Mi a dan ŋman jam, Naawen naamu a le nyɛ ase ka nipɔkbilisa piwa baai ale yiti a pa ba zeuŋta a ta cheŋ ayen ba ga tu nipɔkfiaka nyɔnɔwa la. ");
INSERT INTO bwu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ba piwa po ka banu ale jam ta yam, alege mbala banuwa me a jam chim betta. ");
INSERT INTO bwu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bettaŋa tinuwa a yaa pa ba zeuŋtaŋa alege ba an pa kpaam a magsi ase mbula a dan nueri abe ba pa nyoro la. ");
INSERT INTO bwu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Alege yammu nyamma a ta kpaam a gum du a magsi ayen mbula a dan nueri abe ba pa nyoro. ");
INSERT INTO bwu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nipɔkfiaka nyɔnɔwa a yaa an jam nwuli, ate nipɔkbilisaŋa a yaa doa a goa. ");
INSERT INTO bwu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ku le jam paari goota sunsuŋ la, nuru wanyi a yaa kaari ayen, ‘Nipɔkfiaka nyɔnɔ a cheena. Ni yiti nwuli ate ni ga tu wa.’ ");
INSERT INTO bwu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nipɔkbilisaŋa piwa a yaa deri yiti nna nwuli a viriŋi ayen ba nya ase ba zeuŋtaŋa a deema a de ya. ");
INSERT INTO bwu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bettaŋa nyamma zeuŋtaŋa kpaamu nyiini ale jam a nueri, ate ba yaa weeni yammu nyamma ayen ba nyɛ ba kpaamu a te ba ate ba nyo ba zeuŋtaŋa po. ");
INSERT INTO bwu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Yammu nyamma a yaa weeni ba ayen, ‘Tama kpaamu an soa diiya. Dila nyiŋ, ni cheŋ yeeŋa po a ga da kpaam.’ ");
INSERT INTO bwu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Bettaŋa a yaa cheŋ ayen ba da ba kpaamu. Ba le cheŋi a ga nueri la, nipɔkfiaka nyɔnɔwa a yaa jam. Yammu nyamma baai ale poom ta ba kpaamu a magsi la, a yaa deri va nipɔkfiaka nyɔnɔwa a jo yenni po ayen ba maa de nipɔkfiak ŋandiintaŋa. Ba meena ale jo yenni po a nueri la, ba yaa yik nansiuŋku tuoku a lik. ");
INSERT INTO bwu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ku le ga nyɛ maga dek la, bettaŋa tinuwa a yaa le a ŋmani a jam a paari la ale tuoku a lik kama. Ba yaa za tuoku noai a nagi ale a wi ayen ba jam a lagri a te ba. ");
INSERT INTO bwu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nipɔkfiaka nyɔnɔwa ale wom ba luelutaŋa la, wa yaa weeni ba ayen, ‘Ni goori ni wanni abe ni cheŋ du. Mi a ze ni ale ka baai la.’ ” ");
INSERT INTO bwu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yeezu ale biisi a nueri la, wa yaa weeni wa ŋaaŋviirima ayen, “Ni chiibi a limsi, dii nyiŋ la ni ze diipo ate mi a cheena la. ");
INSERT INTO bwu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Mi a dan ŋman jam, Naawen naamu a le nyɛ ase ka nuru waai ale gomsi a magsi ayen wa nyiem la. Wa le gomsi a nueri la, wa yaa wi wa tomteerɔma batawa a yaa pai wa ŋantaŋa meena a nyo ba nisima po ayen ba a nya ba zuk ate wa jam. ");
INSERT INTO bwu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Wa yaa pa wa ŋantaŋa a chari ba a va waai meena ale a tom wa tuima dii la. Wa yaa te niŋ nyɔnɔwa ligra tusa ŋanu, ale a te waai ale pa saŋ la ligra tusa ŋaye, ale ge a te butawa nyɔnɔwa ligra tusidi. Wa le chari ba a ga nueri la, wa yaa cheŋ. ");
INSERT INTO bwu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tomteerɔ waai ale tuesi ligra tusa ŋanuwa la, a pa ŋa kama a gerim a nya ligra tusa ŋanu nyuenta. ");
INSERT INTO bwu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Buyewa nyɔnɔwa me waai ale tuesi ligra tusa ŋayewa la, a pa ŋa kama a gerimu a nya ligra tusa ŋaye me nyuenta. ");
INSERT INTO bwu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Alege tomteerɔ waai ale tuesi ligra tusini la a pa wa nyɔnɔwa ligraŋa kama a tu tɛŋ a gu. ");
INSERT INTO bwu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ku yaa ale ga beni ate ba nyɔnɔwa a nyini wa nyeerimu jigini a jam la ate wa yaa a wi ba ayen ba jam wa jigi. Ba le jam wa jigi la, wa yaa bek ba ayen wa a yaali kama ayen wa nya waai meena ale pa wa ligra a gerimu a nya dii nyuenta la. ");
INSERT INTO bwu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tomteerɔwa waai ale tuesi ligra tusa ŋanuwa la, a yaa cheŋ a nyini a taam zaani wa niŋ a weeni wa ayen, ‘M nyɔnɔ, fi daam pa ka ligra tusa ŋanu a te mi ate mi yaa pa ŋa a gerim a nya ligra tusa ŋanu nyuenta a ŋman gum du.’ ");
INSERT INTO bwu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Wa nyɔnɔwa a yaa weeni wa ayen, ‘Fi ka nuru maŋ ale nyɛ ate ku nala. Mi daam pa ka ligra maga dega a nyo fi nisima po alege fi a yaa baga a nyɛ ate ŋa zuak a gum du. Yɔgyɔgla de mi a yaali kama ayen m pai ligra yegayega a nyo fi nisima po ate fi ale mi ta supeentik.’ ");
INSERT INTO bwu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Tomteerɔwa waai ale tuesi ligra tusa ŋayewa la, me a yaa nyini a taam zaani wa niŋ a weeni ayen, ‘M nyɔnɔ, fi daam pa ka ligra tusa ŋaye a te mi ate mi yaa pa ŋa a gerimu a nya ligra tusa ŋaye nyuenta a ŋman gum du.’ ");
INSERT INTO bwu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Wa nyɔnɔwa a yaa weeni wa ayen, ‘Fi me ka nuru maŋ ale nyɛ ate ku nala. Mi daam pa ka ligra maga dega a nyo fi nisima po, alege fi a yaa baga a nyɛ ate ŋa zuak a gum du. Yɔgyɔgla de mi a yaali kama ayen m pai ligra yegayega a nyo fi nisima po, ate fi ale mi ale ta supeentik.’ ");
INSERT INTO bwu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Tomteerɔwa waai ale tuesi ligra tusini la, me a yaa nyini a taam zaani wa niŋ a weeni ayen, ‘M nyɔnɔ, m seba ayen fi nyeka tua kama, dii nyiŋ la fi a che ka za ŋaai ate fi an bori la ale a vaari za ŋaai me ate fi an fobi la. ");
INSERT INTO bwu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Fi le pai ligraŋa a te mi la, mi daam a chalika yɔgsum a yaa ta ŋa a ga tu tɛŋ a gu. Nya, lig ŋaai ate fi daam a pa te mi la ale nna.’ ");
INSERT INTO bwu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Wa nyɔnɔwa ale wom dii ate wa weeni la, wa sui a yaa jam a puuri nna yegayega ale wa ate wa yaa weeni wa ayen, ‘Fi ka nuru biok ale nyiŋworuk nyɔnɔ. Fi a poli kama ayen mi a che ka za ŋaai ate mi an bori la ale a vaari za ŋaai me ate mi an fobi la. ");
INSERT INTO bwu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ku magsi kama ayen fi daam ate pa m ligraŋa a te ka nuru waai ale wa pa ŋa a gerimu a nya nyuenta a gum du a te mu la. ");
INSERT INTO bwu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tuesi ligraŋa wa jigi a pa ŋa a te m tomteerɔma wanyi wa waai ale ta ligra tusa piwa la. ");
INSERT INTO bwu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nuru waai ale a pii nyiŋ la, a le nya ŋanta a gum du, alege waai ale kan a pii nyiŋ la a kan nya jaabɔa. ");
INSERT INTO bwu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ni yik nyiŋworuk nyɔnɔwa de a ta wa a nyini peelim a yuk basi legini po. Dula jigini wa le kum nna yegayega, abe wa a ŋobi wa nyinaŋa.’ ");
INSERT INTO bwu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Mi Saalobiika ale Naawen sabiiloma a dan jamu, m le jam a kala ka m naamu zukpaglika zuk a yaa soa tɛŋka meena. ");
INSERT INTO bwu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Abe m wi waai meena ate ba tigsi a jam m tɛŋ. Ba dan jam, m le poori ba buye ase naapeerik ale a poori wa piisa ale wa bua dii la. ");
INSERT INTO bwu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","M le yik baai ale a nyɛ ase piisa la a zaani m juga geŋ, abe m yik baai me ale a nyɛ ase bua la a zaani m gala geŋ. ");
INSERT INTO bwu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Mi waai ale soa tɛŋzuk meena la, a le weeni baai ale bo m juga geŋ la ayen, ‘M Kowa Naawen a maari ni abe wa niak ni. Wa le jam a nyɛ tɛŋzuk meena la, wa gomsi ka ŋanta a zaani a te ni. Ni be jam a tuesi ba yɔgyɔgla de. ");
INSERT INTO bwu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kom ale jam a yik mi la, nama a te mu ŋandiinta ate m de. Nyanyuila me ale jam ta mu la, ni te mu nyiam ate m nyu. M le jam ka nichaano la, ni nyɛ m tia ale a ta mu a jo ni yieŋa po. ");
INSERT INTO bwu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mi ale jam kan ta gatta la, ni te mu gatta ate m jo. Mi ale jam a wiak la, ni nya m zuk. Ba le jam a yik mu a lik dɔk po la, ni jam a puusi mu.’ ");
INSERT INTO bwu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Baai ale ka tomdo maŋsa ale za m juga geŋ la, ba wanyi a le weeni mu ayen, ‘M Nyɔnɔ, ka dimpo ate tama a nya fu ale kom a ta fu ate ti te fu ŋandiinta ate fi de? Ka dimpo me ate tama a nya fu ale nyanyuila a ta fu ate ti te fu nyiam ate fi nyu? ");
INSERT INTO bwu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ka dimpo ate tama a nya fu ale fi chim nichaano ate tama a nyɛ fi tia ale a yik fu a ta jo ti yieŋa po? Ka dimpo me ate tama a nya fu ale fi an jo gatta ate tama a te fu gatta ayen fi jo? ");
INSERT INTO bwu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ka dimpo me ate tama a nya fu ale fi a wiak yaa ba yik fu a lik dɔk po ate tama a jam puusi fu?’ ");
INSERT INTO bwu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mi a le weeni ba ayen, ‘Wensie ate mi a weeni ni ayen dii meena ate nama a nyɛ a te mi ŋaaŋviirima po baaŋka me dek la, ni nyɛ a te ka mi dila.’ ");
INSERT INTO bwu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Dula jigini m le chiem a weeni tuimbaata nyamma baai ale bo m gala geŋ la ayen, ‘Nama baai ate Naawen a ka te ni la, ni cheŋ du mi tɛŋ a cheŋ bolim buui ale kan maara kpimsi ate Naawen a gomsi a magsi a te Sitaana la ale wa sabiiloma la. ");
INSERT INTO bwu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kom ale jam ta mu la, nama an te mi ŋandiinta ayen m de. Nyanyuila ale jam a yik mu la, nama an te mi nyiam ayen m nyu. ");
INSERT INTO bwu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mi le jam ka nichaano la, nama an te mi tia ale ta mu a jo ni yieŋa po. Mi le jam kan ta gatta a jo la, nama an te mi gatta ayen m jo. Mi le jam a wiak ale bo likka dɔk po me la, nama an jam ayen ni nya mi zuwa.’ ");
INSERT INTO bwu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Baai ale jam za m gala geŋ la, ba wanyi a le weeni mu ayen, ‘M Nyɔnɔ, ka dimpo ate tama a nya fu ale kom a yaase nyanyuila a ta fu? Ka dimpo me ate tama a nya fu ale fi ka nichaano yaa fi ka gatta a jo? Ka dimpo ate tama a nya fu ale fi a wiak yaa ba yik fu a lik dɔk po, alege tama an maari fu?’ ");
INSERT INTO bwu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","M le ŋman a weeni ba ayen, ‘Wensie ate mi a weeni ni ayen diipo meena ate nama an jam maari mi ŋaaŋviirima po baaŋka me dek la, nama an maari daa mi.’ ");
INSERT INTO bwu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Naawen a le yik baai ale a tom tuimbaata la a nyo juijui ate ninam yegayega a boro ate ku ka kpeglimka me la, alege tuimmaŋsa nyamma ale nya nyuvuri dii ale kan ta kpeglimka.” ");
INSERT INTO bwu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yeezu ale jam a sak wa ŋaaŋviirima wieŋa de meena a nueri la, wa yaa weeni ba ayen, ");
INSERT INTO bwu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Tigi kpeeni dii ate Juuma a wi ayen Gaambasika Tigini la a tali ka daa ŋaye ate di paari. Ŋa dan jam paari, ba le yik mi Saalobiika a ta ga nyo baai a le ba pa mu a kpi jabarim nyiŋ ate m kpi la, nisima po.” ");
INSERT INTO bwu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Va ŋala po Juuma Puusika Yenni kpaŋŋa ale Juuma kpaŋŋa a yaa tigsi chaab Kayafas waai ale jam ka ba kpagi la yekpeeni po, ");
INSERT INTO bwu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ayen ba poli a nya siuk ate ba va a suk yik Yeezu a ko. ");
INSERT INTO bwu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Alege ba yaa ŋman weeni chaab ayen, “Ase ti dan a yik wa nuru bɔanni baai ale tigsi chaab ayen ba de tigini de la sunsuŋ, ba le jam a yiti ale noayeŋ a nyiem a kaasi tuima tɛŋka po.” ");
INSERT INTO bwu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Da yeŋ po ate Yeezu a yaa jam bo nuru wanyi ate ba a jam a wi wa ayen, Simon la yenni po dii ale jam bo Betani tɛŋka la a de ŋandiinta. Simon wala a jam ta ka gama tuem, alege ate bu yaa a nueri. ");
INSERT INTO bwu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nipɔk wanyi a yaa nyini peelim a ta kpa buui ate bu nyummu a masa nna yegayega la a jam jo Yeezu jigi a kpiiri bu a nyo wa zuk. ");
INSERT INTO bwu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yeezu ŋaaŋviirima ale ga nya nipowa ale nyɛ dii la, ba sue yaa puuri ale wa. Ba yaa jam a poli ba suniima po ayen, “Ka boa ale soa ate nipowa de a pa kpaamu a yik kaasi nna la? ");
INSERT INTO bwu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Wa dan poom a pa bu a da ligra yegayega a pa ŋa a te niwomma, dila an zunchoŋa?” ");
INSERT INTO bwu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yeezu a yaa jam seba dii ate ba a poli la, a yaa weeni ba ayen, “Ka boa ate wa le a nyɛ dii la a daani nama? Ni basi wa, dii nyiŋ la wa tom ka wamaŋ a te mi. ");
INSERT INTO bwu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Niwoba a kasim a bo ale nama kama daa meena, alege mi a kan bo ale ni a ta a cheŋi. ");
INSERT INTO bwu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nipowa de a kpiiri a nyo mi zuk a deri gomsi mi nyiŋka a magsi ka guka. ");
INSERT INTO bwu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Wensie ate mi a weeni ni, juijui meena ate nuruba a sak Naawen wamaŋsaŋa la, ba le weeni nipowa de ale nyɛ dii a te mi la. Ba le kasim a teeri wa yoi diipo meena wuu.” ");
INSERT INTO bwu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Da ŋala po Yeezu ŋaaŋviirima pi ale bayewa po wanyiwa waai ate ba a wi wa ayen Judas Iskariot la, a jam a yiti a cheŋ Juuma Puusika Yenni kpaŋŋa jigi, ");
INSERT INTO bwu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","a weeni ba ayen, “Ase mi a dan baga a yik Yeezu a ta wa a jam a nyo ni nisima po, nama a le te mu ka boa?” Wa le bek ba dila la, ba yaa deri a chiini ligbie pisita a te wa dula jigini. ");
INSERT INTO bwu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","A nyini da ŋala po a ta a cheŋ, Judas a yaa nyiem a gisi ka siuk ayen wa ta Yeezu a ga bobri a sak. ");
INSERT INTO bwu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Juuma Gaambasika Tigini yaa jam paari. Da ŋala po ba nyiem a kasim a ŋobi ka boroboruk kuui ate ba kan pa dabinta a nyoro la. Yeezu ŋaaŋviirima a yaa jam wa jigi a bek wa ayen, “Ka be ate fi a yaali ayen ti ga gomsi Gaambasika Tigini ŋandiintaŋa ate fi jam a de?” ");
INSERT INTO bwu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wa yaa weeni ba ayen, “Ni cheŋ nuru wanyi jigi tɛŋka po a ga weeni wa ayen, ‘Ti Sagrɔwa ale tom ti ayen ti jam a weeni fu ayen wa kummu danni a mɔata kama. Tama ale wa ale a yaali ayen ti de Gaambasika Tigini ŋandiintaŋa fi yenni po.’ ” ");
INSERT INTO bwu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wa ŋaaŋviirima a yaa cheŋ ga nyɛ dii ate wa weeni la a yaa dik ŋandiintaŋa dula jigini. ");
INSERT INTO bwu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Wenni ale jam a siŋ la, Yeezu ale wa ŋaaŋviirima pi ale bayewa a yaa tigsi chaab a kala a de ŋandiintaŋa. ");
INSERT INTO bwu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ba le jam boro a de la, wa yaa weeni ba ayen, “Wensie ate mi a weeni ni, nama po wanyi ale a yaali ayen wa ta mi a ga bobri a sak.” ");
INSERT INTO bwu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Wa ŋaaŋviirima ale wom dii ate wa weeni ba la, ba meena sue a yaa jam kaasi ate ba yaa bek wa wanyi wanyi ayen, “M Nyɔnɔ, ka mi?” ");
INSERT INTO bwu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yeezu a yaa weeni ba ayen, “Nuru waai ale kala dela pa wa boroboruk a maari a siuk jentaŋa ale mi dek la, a le wa ta mu a ga bobri a sak. ");
INSERT INTO bwu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mi Saalobiika a le kpi ase ka dii ate ba ŋmarisi Naawen gbaŋka po dila po dila po la. Ku le pagra a te waai a le wa ta mu a ga bobri a sak la. Ba dan jam kan biak wa, kula ate zunchoŋ kama.” ");
INSERT INTO bwu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas waai ale jam a yaali ayen wa ta Yeezu a ga bobri la a yaa bek wa ayen, “M Nyɔnɔ, ka mi?” Yeezu a yaa weeni wa ayen, “Ka fi.” ");
INSERT INTO bwu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ba le jam boro a de la, Yeezu yaa pa boroboruk a puusi a te Naawen ayen wa niak ku. Wa le puusi a te Naawen a nueri la, wa yaa we boroboruku a chari wa ŋaaŋviirima ale weeni ba ayen, “Ka mi nyiŋka ale nna. Ni ŋɔa a ŋobi.” ");
INSERT INTO bwu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Wa yaa ŋman pai beerik ale daam a puusi a te Naawen ayen wa niak bu. Wa le puusi a te Naawen a nueri la, wa yaa pai a te ba ale weeni ba ayen, “Ka mi ziimu ale nna. Ni ŋɔa a nyu. M le pa bu a te nuruba yegayega, ate Naawen a voŋ ba tuimbaataŋa a te ba. M dan nyɛ dila, ku le sak ayen wa ale wa nuruma a ta ka noayeŋ ale chaab. ");
INSERT INTO bwu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Wensie ate mi a weeni ni, bu de ate mi a nyu la, m kan ŋman nyu ase ka m nin jo m kowa Naawen naamu po a ŋman nyu ale ni.” ");
INSERT INTO bwu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ba le de ŋandiintaŋa a nueri la, ba yaa yi yiili a pak Naawen ale ge a nyini dula jigini a cheŋ ga jueli Olivi Guuku zuk. ");
INSERT INTO bwu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yeezu a yaa weeni ba ayen, “Ba ŋmarisi Naawen gbaŋka po a weeni ayen, ‘Naawen a le jam a ko naapeerika, abe wa ge wa piisaŋa a basi ate ŋa chali a waaŋ chaab.’ Yokku de nama meena a le chali a waaŋ abe ni ge mi nyiini ");
INSERT INTO bwu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Alege m dan yiti kum po, m le de ni niŋ a cheŋ Galili tɛŋka po.” ");
INSERT INTO bwu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piita yaa weeni wa ayen, “Fi ŋaaŋviirima meena a dan basi fu, mi kan maara basi fu diipo.” ");
INSERT INTO bwu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yeezu yaa weeni wa ayen, “Basi ate m weeni fu, yokku de fi a le pagsi ku noai buta ayen fi ze mi, ale ge ate vari kpadiaka a kum.” ");
INSERT INTO bwu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piita yaa ŋman weeni wa ayen, “Mi kan weeni ayen m ze fu. Mi dan poom ayen m kpi ale fu, mi kan weeni dila.” Wa ŋaaŋviirima meena me a weeni dila degadega. ");
INSERT INTO bwu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ba yaa jam paari jigi ate ba a wi ayen Getsemani, ate Yeezu a yaa weeni wa ŋaaŋviirima ayen, “Ni kali dela ate m cheŋ a ga puusi a te Naawen abe m jam.” ");
INSERT INTO bwu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Wa le a cheŋ la, wa yaa basi ate Piita ale Jeemsi ale wa suoku Jɔɔn, Zebedi bisaŋa a va wa. Ku yaa jam kperi wa ate wa piilim boro a nya ninam nna yegayega ate wa sui me a yaa kaasi nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Wa yaa weeni ba ayen, “M sui ale kaasi a gaam taam nna yegayega, ate ku a nyɛ nna ase mi a yaali ayen kpi la. Ni be limsi mu dela ate m jam.” ");
INSERT INTO bwu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Wa le ŋman cheŋ maga dega la, wa yaa kpi duna tɛŋ a puusi a te Naawen ayen, “M Koa, mi a saalim ayen ku dan ka fi popeentik, be yeeri namka de mi jigi a basi. Nyɛ fi dek ale a yaali dii la, alege daa mi ale a yaali dii la.” ");
INSERT INTO bwu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wa le ŋman pilim a nyini wa puusika jigini a jam la, wa yaa nya wa ŋaaŋviirima batawa a doa goa. Wa yaa weeni Piita ayen, “Ka boa ate nama an baga a kali a limsi maga ale ge a goa? ");
INSERT INTO bwu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ni yiti a puusi a te Naawen ate Sitaana a kan paasi ni ate ni va wa nɔaya. Ni suniima po nama a yaali ayen ni a nyɛ mi yaaka, alege ni nyiŋsaŋa an pagra. Dila ale soa ate nama a goa la.” ");
INSERT INTO bwu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Wa yaa ŋman pilim cheŋ wa puusika jigini a ga puusi a te Naawen ayen, “M Koa, ku dan kan ta nyeka alege ate fi a yaali ayen m nam be basi ate fi ale a yaali dii la a nyɛ.” ");
INSERT INTO bwu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wa yaa ŋman pilim a jam a paari ale wa ŋaaŋviirima a doa a goa, dii nyiŋ la goom ale jam ta ba nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yeezu a yaa ŋman pilim cheŋ a ga puusi a te Naawen ase wa le poom a puusi dii la. ");
INSERT INTO bwu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Butawa po Yeezu yaa ŋman pilim a jam paari a bek ba ayen, “Ni diem a doa a goa kama? Wie meena a nueri kama. Di danni a paari ya ate ba ayen ba yik mi Saalobiika a nyo tuimbaata nyam nisima po. ");
INSERT INTO bwu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ni yiri ate ti cheŋ. Nuru waai ale ta mu a ga bobri sak la ale la a cheena.” ");
INSERT INTO bwu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yeezu ale diem boro a biisi la, Judas waai ale jam ka wa ŋaaŋviirima po wanyi la, a yaa jam wa jigi ale nuru bɔari yegayega. Juuma Puusika Yenni kpaŋŋa ale Juuma kpaŋŋa ale tom ba. Ba jam ta ka gebi kpeensa ale dua a jam ayen ba yik wa. ");
INSERT INTO bwu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Bumbobrowa a poom weeni ba kama ayen, “Ti dan ga paari ba, nuru waai ate mi a puusi ale a gbaari wa la, ka wala ale la. Ni yik wa ale pagrim.” ");
INSERT INTO bwu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nuru bɔanni ale jam a ga mɔata Yeezu la, Judas a yaa deri cheŋ a ga puusi ale gbaari wa a weeni wa ayen, “Mi Sagrɔ, suyɔgini a bo ale fu.” ");
INSERT INTO bwu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yeezu a yaa weeni wa ayen, “M doa, nyɛ dii ate fi a poli ayen fi nyɛ mu la.” Baai ale jam va Judas la, a yaa yik wa ale pagrim. ");
INSERT INTO bwu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yeezu ŋaaŋviirima po wanyi a deri yeeri wa gebi kpieŋ a che Juuma Puusika Yenni kpagi kpeeni yomma po wanyi turi a gebi lonsi tɛŋ. ");
INSERT INTO bwu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yeezu a yaa weeni wa ayen, “Pa fi gebika a ŋman su ka fooku po. Nuru waai ale ta gebi kpieŋ a che kpaliŋ po la, a dan kan a kpesi, ba le pa gebi kpieŋ ka choa a ko wa. ");
INSERT INTO bwu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nama a ze ayen mi baga kama a wi m kowa ayen wa tomu wa sabiiloma baai ale piisi nna yegayega la ate ba jam a maari mu? ");
INSERT INTO bwu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","M dan nyɛ dila, wie ŋaai ate ba ŋmarisi mi wie Naawen gbaŋka po dila po dila po la a kan chim wensie.” ");
INSERT INTO bwu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yeezu a yaa viriŋi a bek nuru bɔanni ayen, “Mi ka zue ate nama a ta gebi kpeensa ale dua a jam ayen ni yik mu? Daa meena mi a kasim bo ale ni Juuma Puusika Yenni po a sak ni kama, alege nama an jam a yik mu. ");
INSERT INTO bwu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ba le ŋmarisi Naawen gbaŋka po dii la a sum chim ka wensie jinla.” Dula jigini wa ŋaaŋviirima meena a yiti a chali ale ge wa. ");
INSERT INTO bwu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ba yaa ta Yeezu a cheŋ Juuma Puusika Yenni kpagini waai ate ba a wi wa ayen Kayafas la jigi. Ba le jam a ga paari dula la, Juuma Sinsak sagrɔma ale Juuma kpaŋŋa a yaa jam tigsi chaab. ");
INSERT INTO bwu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piita a yaa magi va ba ŋaaŋ a jam jo Juuma Puusika Yenni kpagi kpeeni yenni dabiaka po a cheŋ a ga kala ale kpagini limsidɔma ayen wa nya dii ale di nyɛ la. ");
INSERT INTO bwu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Juuma Puusika Yenni kpaŋŋa ale boteerɔma meena a jam bo dula a gisi nuru ayen wa weeni a sak ba ayen wa nya Yeezu ale wa boro a tom wabiok ate ba baga a nya siuk a ko wa. ");
INSERT INTO bwu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ba yaa gisi a kpeeri. Alege nuruba yegayega a diem nyini a jam za ba niŋ ayen ba velim wie a te wa. Kula ŋaaŋnyiŋ nuruba baye a yaa nyini a jam za ba niŋ. ");
INSERT INTO bwu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","A weeni ayen, “Tama a wom ale Yeezu a weeni ayen wa baga a kaasi Juuma Puusika Yenni, abe wa ŋman a se di daa ŋata po.” ");
INSERT INTO bwu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Juuma Puusika Yenni kpagi kpeeni a yaa yiti a cheŋ a ga zaani ba meena sunsuŋ a yaa bek Yeezu ayen, “Fi ka wari a tulisi ale ŋaai meena ate ba a biisi a te fu la?” ");
INSERT INTO bwu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Alege Yeezu a yaa sina. Kpagi kpeeni a yaa ŋman weeni wa ayen, “Mi a yaali kama ayen fi pe Naawen waai ale boro la yonni nyiŋ abe fi weeni mu wensieŋa.” Wa yaa bek Yeezu ayen, “Fi ka Naawen biika waai ate ba a wi wa ayen Varibasidɔwa la?” ");
INSERT INTO bwu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yeezu a yaa weeni wa ayen, “Mm, mi ale la. Ni basi ate m weeni ni ayen da yeŋ po fi le nya mi Saalobiika ale m kala Naawen juga geŋ. Fi le ŋman nya mu ale m nyini Naawen jigi chiŋmaaŋa po a cheena.” ");
INSERT INTO bwu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Wa le weeni dila la, Juuma Puusika Yenni kpagi kpeeni a yaa yik wa garuku a dari cheeri ale weeni ba ayen, “Ti kan ŋman a yaali seeroba. Ni meena a wom wa le pa wa dek a magsi chaab ale Naawen la. ");
INSERT INTO bwu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nama a poli ka se, wa lo yaa wa an loya?” Ba meena a yaa weeni ayen, “Wa lo kama. Ku magsi ba ko wa kama.” ");
INSERT INTO bwu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nuruma ba gela a yaa chesi tintueta a basi wa nyiŋ ale a nak wa. ");
INSERT INTO bwu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","A weeni ayen, “Fi a weeni ayen fi ale Varibasidɔwa. Be miŋ baai ale a nak fu la.” ");
INSERT INTO bwu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ba le ta Yeezu a nyɛ nyaku de meena la, Piita a diem bo ka yenni dabiaka po. Nipɔkbili wanyi a yaa jam boro. Wa jam ka Juuma Puusika Yenni kpagi kpeeni dɔgleema po wanyi. Wa yaa nya Piita a weeni wa ayen, “Daa fi ale poom va Galili tɛŋka denowa Yeezu la?” ");
INSERT INTO bwu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Wa yaa pagsi ale baai meena ale za dula la nimbie po ale weeni wa ayen, “Ka boa ate fi a begi mi dila? Mi ze fi ale a biisi dii la.” ");
INSERT INTO bwu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Wa le weeni dila la, wa yaa yiti a cheŋ a ga za nansiuŋku noai. Nipɔkbili wa choa a ŋman diem nya wa dula jigini ale wa za ate wa yaa weeni nuru baai ale za mɔata wa la ayen, “Nuruwa de ka Yeezu ŋaaŋviirima po wanyi.” ");
INSERT INTO bwu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piita a yaa ŋman pagsi ayen, “M pe ya, mi ze nuruwa de.” ");
INSERT INTO bwu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ku an jam beniya ate baai ale jam za mɔata wa la wanyi a yaa weeni wa ayen, “Fi ka ba wanyi, dii nyiŋ la fi a biisi ase ka Galili deno la.” ");
INSERT INTO bwu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Piita a yaa weeni wa ayen, “M pe ya, ka wensie ate mi a biisi. Mi ze nuru waai wie ate fi a biisi la.” Wa le weeni dila a ga nueri la, vari kpadiaka a yaa deri kum. ");
INSERT INTO bwu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ate Piita a yaa teeri dii ate Yeezu a poom weeni wa ayen wa le pagsi ku noai buta ayen wa ze wa, ale ge ate vari kpadiaka a kum la. Wieŋa de meena a yaa nyɛ ate Piita sui a kaasi ate wa yaa deri nyini a kum nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Vanni ale veenti la, Juuma Puusika Yenni kpaŋŋa ale Juuma kpaŋŋa meena a ŋman tigsi chaab ayen ba poli ba le ba nyɛ dii a ko Yeezu la. ");
INSERT INTO bwu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ba le biisi le chaab a nueri la, ba yaa bobi wa nisimaŋa a ta wa cheŋ gominawa waai ate ba a wi wa ayen Paalɔt la jigi. ");
INSERT INTO bwu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas waai ale jam ta Yeezu a ga bobri a sak la, ale nya ba le bo Yeezu buusaŋa dii la, wa sui a yaa jam kaasi, ate wa yaa ŋman pilim a cheŋ Juuma Puusika Yenni kpaŋŋa ale Juuma kpaŋŋa jigi ayen wa pa ba ligbeeŋa pisitawa a te ba. ");
INSERT INTO bwu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Wa le ga paari dula la, wa yaa weeni ba ayen, “Naawen a nya mi kaasuŋku kama, dii nyiŋ la mi a ta ka nuru waai ale kan seba wari noai po la, a jam bobri a sak nama. Yɔgyɔgla de nama me a yaa bo wa kum buusa.” Ba yaa weeni wa ayen, “Kula a daa tama niŋŋa, alege ka fi dek niŋ.” ");
INSERT INTO bwu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas ale ga wom dii ate ba weeni la, wa yaa pa ligraŋa a yuk basi Juuma Puusika Yenni sunsuŋ, ale ge a nyini a ga bobi miik a kpi. ");
INSERT INTO bwu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Judas ale ga nyini la, Juuma Puusika Yenni kpaŋŋa a yaa yiti a pisi ligraŋa ale weeni chaab ayen, “Ligraŋa de tama pa ŋa a da ka nuru nyuvuri. Ti Sinsaŋŋa a kan siagi ayen ti pa ŋa a maa gum Juuma Puusika Yenni ligraŋa po.” ");
INSERT INTO bwu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ba le nya chaab a nueri la, ba yaa pa ligraŋa a da tɛŋ kaai ate ba a wi ayen samɔnsa meka jigi la. Ba jam a yaali kama ayen ba pa dula jigini a chim nicham guka jigi. ");
INSERT INTO bwu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ka dila ale soa ate nuruba a deema a wi dula jigini ayen ziimu jigini la. ");
INSERT INTO bwu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Naawen biisiteerɔwa waai ate ba a wi wa ayen Jerimaya la a jam a ŋmarisi nyaku de wie kama dila po dila po ayen, “Juuma a jam siak kama ayen ba pa ligbeeŋa pisitawa a da samɔnsaŋa meka jigini. Ba yaa pa ligraŋa a da tɛŋka ase Naawen ale poom a weeni ba dii la.” Dii ate Juuma Puusika Yenni kpaŋŋa a tom la a basi kama ate Jerimaya wieŋa a chim wensie. ");
INSERT INTO bwu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yeezu a yaa jam taam a zaani Paalɔt niŋ. Paalɔt a yaa bek wa ayen, “Ka fi ale Juuma naawa la?” Yeezu a yaa weeni wa ayen, “Ka fi ale a weeni dila.” ");
INSERT INTO bwu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Alege Juuma Puusika Yenni kpaŋŋa ale Juuma kpaŋŋa ale jam a ŋma wa la, wa an jam weeni wariya. ");
INSERT INTO bwu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Paalɔt yaa bek wa ayen, “Fi kan wom ba ale a ŋma fu ale wie ŋaai meena la?” ");
INSERT INTO bwu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Alege Yeezu an jam tulisi wayeŋ me la. Ku yaa jam cha Paalɔt nna yegayega ale wa ale kan a tulisi wari la. ");
INSERT INTO bwu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bena meena Juuma Gaambasika Tigini a nyiem a dan paari, gominawa Paalɔt a nyiem lak nuru waai ate tɛŋka demma a yaali ayen wa lak ate wa nyini likka dɔkku po a nyini la a basi kama. ");
INSERT INTO bwu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nuru wanyi ale jam boro ate ba a wi ayen Barabasi ate ba jam maa yik wa a lik. Nuruba a jam seba wa ka nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Paalɔt a yaa bek nuru baai meena ale tigsi chaab la ayen, “Nama a yaali ayen m basi ka ba wana? Barabasi yaa Yeezu waai ate ba a wi ayen Varibasidɔwa la?” ");
INSERT INTO bwu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Paalɔt jam seba ayen ka Juuma Puusika Yenni kpaŋŋa nyunni nyiŋ ale soa ate ba yik Yeezu a ta jam wa jigi. ");
INSERT INTO bwu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Paalɔt ale jam diem kala boteka dɔkku po la, wa powa a yaa tom weeni wa ayen, “Kan nyɛ nuruwa de jaabɔa ale wa an kaasi wariya. Dii nyiŋ la deemwa yokku mi goadaasim wa wari kama ate ku daani mi nna yegayega.” ");
INSERT INTO bwu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Juuma Puusika Yenni kpaŋŋa ale Juuma kpaŋŋa a yaa weeni nuru bɔanni ayen ba saalim ate wa lak Barabasi a basi abe wa ge ate ba ko Yeezu. ");
INSERT INTO bwu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Paalɔt a yaa bek nuru bɔanni ayen, “Nuruma de bayewa, nama a yaali ayen m basi ka ba wana?” Ba yaa tulisi wa ayen, “Ti a yaali ayen fi basi ka Barabasi.” ");
INSERT INTO bwu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Wa yaa ŋman bek ayen, “M be m nyɛ Yeezu waai ate ba a wi ayen Varibasidɔwa la ka se?” Ba meena yaa tulisi ayen, “Basi ate ba kpi wa jabarimu nyiŋ ate wa kpi.” ");
INSERT INTO bwu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Wa ŋman bek ba ayen, “Ka boan jaab wabiok ate wa nyɛ?” Ba yaa kaari nna yegayega ayen, “Basi ate ba kpi wa jabarimu nyiŋ ate wa kpi.” ");
INSERT INTO bwu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Paalɔt a yaa nya ayen wa an baga a nyɛ wariya dii nyiŋ la, ba nuemka ale ta kpaliŋ a jam. Wa yaa pa nyiam a nari wa nisaŋa nuru bɔanni niŋ, ale weeni ba ayen, “Mi niŋ maa ka nuruwa de kum po, ku bo ka nama dek jigi.” ");
INSERT INTO bwu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nuru bɔanni a yaa weeni wa ayen, “Basi ate wa kummu nyiŋ ninammu a jam tama ale ti bisaŋa jigi.” ");
INSERT INTO bwu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Paalɔt a yaa lak Barabasi a basi ale basi ate ba miiri Yeezu. Ba ale miiri wa nueri la, wa yaa pa wa te ayen ba ta wa ga kpi jabarimu nyiŋ ate wa kpi. ");
INSERT INTO bwu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Paalɔt sojima a yaa yik Yeezu a ta jo ba gominawa yenni dabiaka po ate ba meena a yaa gilim wa. ");
INSERT INTO bwu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ba yaa yeeri wa gattaŋa ale pa garuk monuŋ a jo wa. ");
INSERT INTO bwu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","A pa munsa a yok zutok a pa vuk wa zukku ale pa tachek a nyo wa juga nisaŋa po. Ba yaa kpi duna wa niŋ a nyɛ wa a la, ale a weeni ayen, “Juuma naawa kasim boro taam wuu.” ");
INSERT INTO bwu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ba jam chesi tintueta a basi wa nyiŋ ale pa duok a nak wa zukku. ");
INSERT INTO bwu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ba ale nyɛ wa la a ga nueri la, ba yaa yeeri garuk monuku ale pa wa dek gattaŋa a jo wa a ta wa nyini cheŋ ayen ba kpi wa jabarimu nyiŋ ate wa kpi. ");
INSERT INTO bwu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ba ale jam bo siuku po a cheŋ la, ba yaa zik Simon ale wa cheena tɛŋka po ate sojima a fe wa ate wa tuesi Yeezu jabarimu ji. Simon a jam ka tɛŋ kaai ate ba a wi ayen Sairini la deno. ");
INSERT INTO bwu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ba yaa ga paari juijui ate ba a wi ayen Golgota la. Ku kiri ale zukoluku jigini. ");
INSERT INTO bwu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ba yaa pa tiim a nyo daam po a lam nya ale pa te Yeezu ayen wa nyu alege wa an jam nyu ya. ");
INSERT INTO bwu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ba yaa yik Yeezu a kpi wa jabarimu nyiŋ, ale pa wa gattaŋa a chari chaab. Ba jam nak ka gbaŋ a nya waai ale magsi garuk kuui deka la. ");
INSERT INTO bwu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ba ale nak gbaŋka wa gattaŋa nyiŋ a nueri la, ba yaa kala a limsi ayen waai a kan vari wa a basi. ");
INSERT INTO bwu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ba yaa pa tapagi a ŋmarisi di nyiŋ ayen, KA JUUMA NAAWA ALE NNA a pa di kpi jabarimu zuk. ");
INSERT INTO bwu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ba jam maa kpi ka zueba baye ŋanbarinta nyiŋ a gum Yeezu po, ate ba wanyi a bo wa juga, nwala me a bo wa gala. ");
INSERT INTO bwu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nuru baai ale jam va dula a taam la a yaa zak zuk nya wa a mati ba noa ale a le wa ayen, ");
INSERT INTO bwu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Fi weeni ayen fi le kaasi Juuma Puusika Yenni abe fi ŋman se di a nueri daa ŋata po. Fi dan ka Naawen biik be nyini jabarimu zuk a siŋ a vari fi dek a basi.” ");
INSERT INTO bwu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Juuma Puusika Yenni kpaŋŋa ale Juuma Sinsak sagrɔma, ale Juuma kpaŋŋa me a jam a la wa ale a weeni ayen, ");
INSERT INTO bwu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Wa jam baga a vari nuruba a basi kama, alege wa an baga a vari wa dek a basi. Daa wa ale Juuma naawa? Wa dan nyini jabarimu zuk a siŋ ti yaa le ta siaka ale wa. ");
INSERT INTO bwu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Wa ta siaka kama ayen Naawen ale bo le wa ale weeni ayen wa ka Naawen biik. Ti be le nya ase Naawen ale vari wa a basi ya.” ");
INSERT INTO bwu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Zue baai ate ba jam kpi ba a gum Yeezu po la, me a le wa dila degadega. ");
INSERT INTO bwu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Wenni ale jam jueli a bo wenzuk sunsuŋ la, legi a yaa jam lik tɛŋ kala meena a ta ga paari wenbalini. ");
INSERT INTO bwu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Legini ale jam basi la, Yeezu a yaa kaari nna yegayega a weeni wa dek tɛŋka biika po ayen, “Eloi, eloi, lama sabagtani.” Ku kiri ale, “M Kowa Naawen, m Kowa Naawen, ka boa ate fi zɛri mu?” ");
INSERT INTO bwu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nuru baai ale jam za dula jigini la ba gela a wom dii ate wa weeni la kama. Ba yaa weeni ayen, “Wa a wi ka Naawen biisiteerɔwa Elaja.” ");
INSERT INTO bwu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ba po wanyi a yaa chali cheŋ ga pa sosok a lusi damiisiŋ po a pa yik duok woŋ nyiŋ a zak ta jueli Yeezu noai. ");
INSERT INTO bwu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nuru mbala yaa weeni ayen, “Ni basi ate ti limsi a nya ase Elaja a le jam a yik wa a ta nyini jabarimu zuk a siŋ tɛŋ ya.” ");
INSERT INTO bwu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yeezu a yaa ŋman kaari nna yegayega a yaa le ge a kpi. ");
INSERT INTO bwu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Wa ale jam kpi la, garuk kpioŋ kuui ate ba jam pa a kasi Juuma Puusika Yenni po la, a yaa jam cheeri ku ŋmazuk a ta siŋ paari ku tɛŋ. Naawen a jam basi kama ate tɛŋka a choa ate pinaŋa a na a mobi, ");
INSERT INTO bwu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ate baai meena ale jam a va Naawen alege a kpi la boositaŋa a lagri ate ba yiti kum po, ");
INSERT INTO bwu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","alege basi boositaŋa. Ku ŋaaŋ nyiŋ ate Yeezu a yiti kum po la ba yaa jo Jerusalem tɛŋka po. Nuruba yegayega ale jam a nya ba. ");
INSERT INTO bwu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sojima kpagini ale soji baai ale jam a limsi la ale nya tɛŋka choaka ale dii meena ale nyɛ la ku yaa cha ba nna yegayega. Ba yaa weeni ayen, “Wensie, nuruwa de sum ka Naawen biik.” ");
INSERT INTO bwu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nipɔk baai ale jam maari Yeezu Galili tɛŋka po la a jam za mɔata dula a nya dii meena ale nyɛ la kama. ");
INSERT INTO bwu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Baai ale jam bo ba po la ale Mɛɛri Magdala ale Mɛɛri, Jeemsi ale Josefi mawa, ale Zebedi powa. ");
INSERT INTO bwu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Jigsiro wanyi ale jam nyini tɛŋ ate ba a wi ayen, Arimatia. Wa yoi a jam ale Josefi. Wa jam ka waai ale ta siaka ale Yeezu. ");
INSERT INTO bwu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Da dila danni junɔai ate wa yaa cheŋ Paalɔt jigi a saalim wa ayen wa basi ate wa ga yeeri Yeezu nyiŋka jabarimu zuk a ta cheŋ ga gu. Paalɔt a yaa siak ayen wa ga yeeri Yeezu nyiŋka jabarimu zuk a ta ga gu. ");
INSERT INTO bwu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josefi a yaa basi dula jigini alege cheŋ ga yeeri Yeezu nyiŋka jabarimu zuk a yaa pa garuk paaluk a pili ka ");
INSERT INTO bwu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","a ta ga dueni puŋ vorub paalik po. (Tɛŋ kala demma a jam a gu ba nuruma ka pina vie po). Wa yaa bilim tintain kpeeni a lik puŋku vorumu nɔanni. ");
INSERT INTO bwu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mɛɛri Magdala ale Mɛɛri nwala a jam kali ka dula a tuk vorumu nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Vari ale ŋman Veenti la, ba Vuusum Danni saliuku Juuma Puusika Yenni kpaŋŋa ale Farisiima a yaa cheŋ Paalɔt jigi a weeni wa ayen, ");
INSERT INTO bwu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Ti deema teeri velinvendika ale jam boro la wa weeni ayen, ‘M le yiti kum po ku daa ŋata dai.’ ");
INSERT INTO bwu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Be basi ate ba ga a limsi vorumu ate ku paari daa ŋata ate wa ŋaaŋviirima a kan magi yeeri wa abe ba weeni nuruma ayen wa yiti kum po. Dan kan daa di ventaŋa de ale gaam wa le liŋ velim dii la.” ");
INSERT INTO bwu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Paalɔt a yaa siak ale basi ayen sojiba cheŋ a ga ŋmasi a limsi vorumu. ");
INSERT INTO bwu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ba yaa cheŋ ga daani tintanni ayen waai dan bilim di abe ba miŋ a yaa le basi ate sojima a limsi vorumu. ");
INSERT INTO bwu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ba Vuusum Danni ale taam la, Mɛɛri Magdala ale Mɛɛri nwala a yaa cheŋ ba nya juijui ate ba gu Yeezu la. ");
INSERT INTO bwu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tɛŋka yaa jam choa nna yegayega, ate sabiilo a nyini wenŋmazuk a siŋ bilim tintanni a dueni nakpiak a kali di zuk. ");
INSERT INTO bwu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Sabiilowa a jam kasim a nyagsi kama ase wein ale a chagsi dii la. Wa gattaŋa me a peenti nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Yɔgsum yaa yik baai ale a limsi vorumu la nna yegayega ate ba nyiŋsaŋa a gok ate ba nyɛ nna ase ba kpi la. ");
INSERT INTO bwu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Sabiilowa a yaa weeni nipooma ayen, “Ni kan chali yɔgsumɔa, mi seba ayen ni a gisi ka Yeezu waai ate ba kpi wa jabarimu nyiŋ la. ");
INSERT INTO bwu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wa ka dela jigini, wa yiti kum po kama ase wa ale liŋ weeni ni dii la. Ni jam a nya juijui ate ba pa wa a dueni la. ");
INSERT INTO bwu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ni cheŋ nwuli a ga weeni wa ŋaaŋviirima ayen wa yiti kum po kama, wa be de ka niŋ a cheŋ Galili tɛŋka. Ni le nya wa dula jigini. Ni teeri m le weeni ni dii la.” ");
INSERT INTO bwu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ba yaa basi dula jigini ale supeentik a ga weeni wa ŋaaŋviirima dii meena ate sabiilowa a weeni ba la. ");
INSERT INTO bwu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Yeezu a yaa tu ba dula jigini a yaa weeni ba ayen, “Suyɔgini a bo ale ni.” Ba yaa domsi kali a puusi wa. ");
INSERT INTO bwu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yeezu yaa weeni ba ayen, “Ni kan chali yɔgsumɔa abe ni ga weeni m suaataŋa ayen ba cheŋ Galili tɛŋka a ga tu mu dula jigini.” ");
INSERT INTO bwu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nipooma ale cheŋ a ga nueri la, sojima gela a yaa cheŋ tɛŋka po a ga weeni Juuma Puusika Yenni kpaŋŋa dii meena ale nyɛ la. ");
INSERT INTO bwu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Juuma Puusika Yenni kpaŋŋa a yaa tu chaab ale tɛŋka kpaŋŋa ate ba pa ligra yegayega a te sojima ale weeni ba ayen, ");
INSERT INTO bwu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Ni weeni ayen nama a doa goa kama ate wa ŋaaŋviirima a jam zu pa wa. ");
INSERT INTO bwu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Gominawa a dan poom wom ti le biisi a vari ni a basi.” ");
INSERT INTO bwu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Sojima yaa tuesi ligraŋa ale weeni ate ku paari Juuma meena ayen Yeezu ŋaaŋviirima ale zu pa wa vorumu po. ");
INSERT INTO bwu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Wa ŋaaŋviirima pi ale wanyiwa a yaa cheŋ a ga jueli guuk kunyi zuk Galili tɛŋka po juijui ate Yeezu a weeni ba ayen ba cheŋ la. ");
INSERT INTO bwu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ba ale nya wa dula jigini la ba yaa puusi wa. Ba gela a jam diem ta ka chichama. ");
INSERT INTO bwu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yeezu a yaa forisi paari ba a weeni ba ayen, “Naawen a te mi pagrim kama wenŋmazuk ale tɛŋzuk meena. ");
INSERT INTO bwu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ni cheŋ tɛŋsa meena a sak nuruba ate ba va mi, abe ni a te ba soka Kowa Naawen ale wa biika ale wa chiika pagrim nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ni sak ba ate ba va wie ŋaai meena ate mi a sak ni la. M le bo ale ni a ga paari tɛŋka kpeglimka.”");
INSERT INTO bwu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","4","Dila po dila po Naawen jam weeni wa biisiteerɔma wanyi ate ba a wi ayen Azaya la, ayen wa ŋmarisi nyo Naawen gbaŋka po ayen, “ ‘Wa le tom nuru ate wa de niŋ jam gomsi siuku a magsi a te waai ale wa jam la.’ Lueluk ale a kaari goanni po a weeni ayen, ‘ni gomsi Nyɔnɔwa siuku abe ni teenti ku.’ ” Naawen biika ate ba a wi ayen Yeezu Kirisita la wamaŋsaŋa wie ale nna. Ku be piilim kama a magsi chaab ale Azaya ale ŋmarisi dii Naawen gbaŋka po la. Ku ŋaaŋnyiŋ ate nuru wanyi ate ba a wi ayen Jɔɔn a yaa nyini goanni po a jam a sak nuruba Naawen wie ale a te ba soka ale a weeni ba ayen, “Ni meena basi ni wabaataŋa, abe ni va Naawen siuku. Ni dan tagri m le te ni soka ate Naawen a voŋ ni wabaataŋa a te ni.” ");
INSERT INTO bwu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nuruba yegayega a yaa nyini tɛŋkpieŋka Jerusalem ale tɛŋ sii meena ale gilim ka a bo Judia po la a jam Jɔɔn jigi. Ba ale wom wa sinsaŋŋa la, ba yaa tɔk ba tuimbaataŋa meena a sak Naawen ale ge ate Jɔɔn yaa te ba soka beli dii ate ba a wi ayen Jodan la po. ");
INSERT INTO bwu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ba jam pa ka laalaakomi kobta a nyɛ Jɔɔn garuku. Wa jam pa ka chiakgbain a bobi wa chiaka. Wa jam a ŋobi ka tintue ale a de siita me. ");
INSERT INTO bwu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Wa jam a mooli kama ayen, “Nuru wanyi ale bo mi ŋaaŋ a cheena. Wa ta pagrim a gaam mi kama. Mi posima ale m nin chim yomo waai ale wa domsi a kali wa niŋ a yeeri wa nuensaŋa a te wa. ");
INSERT INTO bwu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nyiam ate mi pa a so ni nyiŋsaŋa, alege waai ale cheena la, a le pa ka Naawen Chiika a sueri ni suniimaŋa.” ");
INSERT INTO bwu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Da ŋala po Yeezu a jam nyini tɛŋ kanyi ate ba a wi ayen Nazaret ate ka jam bo tɛŋ kaai ate ba a wi ayen Galili la po. Wa yaa jam Jɔɔn jigi ayen Jɔɔn te wa soka Jodan benni po. ");
INSERT INTO bwu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jɔɔn ale te wa soka a nueri ate Yeezu a yaa nyini nyiamu sunsuŋ a jueli la, wa yaa deri nya wenŋmazuku ale ku lagri ate wa nya Naawen Chiika a siŋ jam kali wa zuk nna ase nangbaŋ la, ");
INSERT INTO bwu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ate lueluk a yaa nyini wenŋmazuku po a weeni Yeezu ayen, “Fi ale m be kaai ate m mariŋ la. M sui a peenti ale fu kama.” ");
INSERT INTO bwu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Dula jigini Naawen Chiika a yaa basi ate Yeezu a cheŋ ga jo goanni po juijui ate goaduŋsa a boro la. ");
INSERT INTO bwu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Wa jam bo dula jigini ate ku paari ka da pisinaansi. Da ŋala po Sitaana a yaa jam wa jigi a nyɛ wa nya ayen wa siak a te wa, alege Sitaana an jam baga a paasi wa. Naawen yaa tom sabiiloba ayen ba jam maa maari wa. ");
INSERT INTO bwu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Da yeŋ po nuruba a yaa yik Jɔɔn a ta wa ga lik dɔk po. Ku ŋaaŋnyiŋ ate Yeezu a yaa jam Galili tɛŋka po a mooli Naawen wamaŋsaŋa ayen, ");
INSERT INTO bwu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Da ŋaai ate Naawen dak ayen wa naamu le jam la, a mɔata kama. Ni basi ni tuimbaataŋa abe ni ta siaka ale wa wamaŋsaŋa.” ");
INSERT INTO bwu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yeezu ale va Galili mogi kpeeni noai a taam la, wa yaa nya nuru wanyi ale wa suok. Ba yue ale Simon ale Andiru, ate ba yaa za a yuk ba ŋmaasaŋa a basi nyiamu po. ");
INSERT INTO bwu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yeezu yaa wi ba ayen, “Ni jam va mi ŋaaŋ. Nama daam ka jum yigrisa, alege jinla mi a te ni ka tuim paali ayen ni nyɛ ate nuruba a jam va mu.” ");
INSERT INTO bwu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ba yaa ale wom dila la, ba yaa deri basi ba ŋmaasaŋa ale va wa. ");
INSERT INTO bwu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Wa ale ga cheŋ maga la, wa yaa ŋman nya nuruba baye ate ba a wi ba ayen Jeemsi ale Jɔɔn. Ba jam ka nuru waai ate ba a wi ayen Zebedi la, bisa. Ba ale ba kowa ale wa tomteerɔma ale jam kala ba ŋaaruŋku po a gomsi ba ŋmaasaŋa. ");
INSERT INTO bwu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yeezu a yaa wi ba, ate ba yaa basi ba kowa ale wa tomteerɔma ŋaaruŋku po ale cheŋ ga va wa. ");
INSERT INTO bwu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yeezu ale wa ŋaaŋviirima yaa cheŋ ga jo tɛŋ kaai ate ba a wi ayen Kapernaum la po. Juuma Vuusum Danni ale jam paari la, Yeezu yaa cheŋ ga jo ba tuka dɔkku po a boro a sak ba Naawen wie. ");
INSERT INTO bwu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nuruma ale wom wa sinsaŋŋa la, ku yaa cha ba, dii nyiŋ la wa sinsaŋŋa a kan neensi Juuma Sinsaŋŋa sagrɔma. Wa sakka a ta pagrim a gaam ba sinsaŋŋa kama. ");
INSERT INTO bwu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Dula jigini nuru ale jam ta chichiribiok ate ku bo wa zukku po. Wa yaa jam jo ba tuka dɔkku po a kaari ayen, ");
INSERT INTO bwu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yeezu Nazaret denowa, fi a yaali ka boa ti jigiya? Fi jam ayen fi kaasi ti kama? M seba ayen fi ka Naawen nuru weleŋ.” ");
INSERT INTO bwu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yeezu a yaa weeni chichiribioku ayen, “Goori abe fi nyini wa zukku po a nyini.” ");
INSERT INTO bwu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Chichiribioku a deri basi ate nuruwa nyiŋka a gok a yaa kaari a nyini wa jigi a nyini. ");
INSERT INTO bwu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ku yaa cha nuruma meena ale jam bo dula la, ate ba weeni ayen, “Ni nya nuruwa de ta pagrim a weeni chichiribaata ate ti a wom wa noai a nyini nuruba zuima po a nyini.” Ba ya bek chaab me ayen, “Ka boan jaab sinsak paala ale nna?” ");
INSERT INTO bwu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Galili tɛŋka po nuruma yegayega a jam wom Yeezu ale tom dii la kama. ");
INSERT INTO bwu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yeezu a yaa basi tuka dɔkku ale ge cheŋ. Wa ale Jeemsi ale Jɔɔn a yaa cheŋ ga jo Simon ale Andiru yenni po. ");
INSERT INTO bwu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Yeezu ale jo yenni po la, ba yaa weeni wa ayen ka Simon ŋanuba ale a yuak. Wa nyiŋka jam toliŋ ka nna yegayega ate wa jam dua wa dɔkku po. ");
INSERT INTO bwu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yeezu a yaa jo nipowa dɔkku po a yik wa nisaŋa a zak ate wa yiri ŋmai. Wa ale nyɛ dila la, wa nyiŋka a yaa deri yok ate wa yiri yaali nyiam a te ba. ");
INSERT INTO bwu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wein ale siŋ la, tɛŋka po demma a pa ba yɔgnyeensa ale baai ate chichiribaata a jam bo ba zuima po la a ta ba jam Yeezu jigi. ");
INSERT INTO bwu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tɛŋka po demma meena a yaa tigsi chaab a jam yeri dii po ate Yeezu a boro la. ");
INSERT INTO bwu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Wa tebi nuruba yegayega baai ate nyiŋtuila tɔgatɔga a jam ta ba la, ale a yiak chichiribaata yegayega nuruba zuima po a basi. Yeezu an jam te chichiribaataŋa siuk ate ti weeni wariya, dii nyiŋ la ti poom seba wa ale ka waai la kama. ");
INSERT INTO bwu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Saliuk yokyok ate vanni an diem a jam veenti la, Yeezu a yaa yiri a nyini tɛŋka po a cheŋ juijui ate nuru a karo la a puusi a te Naawen dula jigini. ");
INSERT INTO bwu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Vanni ale veenti la, Simon ale wa vaanchaama yaa yiri a nya ale Yeezu a karo. Ba yaa nyini ayen ba gisi wa. ");
INSERT INTO bwu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ba ale nya wa la, ba yaa weeni wa ayen, “Nuru meena a nyeemu a gisi fu kama.” ");
INSERT INTO bwu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yeezu a yaa weeni ba ayen, “Ni te ti cheŋ tɛŋ sii ale tali la ate m sak dula nuruma Naawen wie ate ba wom. Ka dila nyiŋ ate m jam.” ");
INSERT INTO bwu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wa yaa nyiem a gilim Galili tɛŋka a sak nuruba Naawen wieŋa ba tuka diinaŋa po. Wa jam yiak chichiribaata nuruba zuima po a basi me. ");
INSERT INTO bwu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Gami dinyi a yaa jam Yeezu jigi a kpi duna tɛŋ wa niŋ a saalim wa ayen, “Fi dan siak, fi baga a tebi mu kama, ate mi a nya nyiŋyɔgsa.” ");
INSERT INTO bwu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yeezu a yaa ta jiirim ale wa nna yegayega a yaa teeri wa nisaŋa a tiri wa ale weeni wa ayen, “M siaya. Ta nyiŋyɔgsa.” ");
INSERT INTO bwu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Wa ale weeni dila la, nyiŋtuilaŋa yaa deri basi gamini ate wa nya nyiŋyɔgsa. ");
INSERT INTO bwu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Yeezu a yaa weeni wa ale nin muna ayen, “Kan weeni sak nuru waaiya fi le nyɛ dii a nya nyiŋyɔgsa la. Cheŋ Naawen Puusika Yenni tomteerɔma wanyi jigi a pa fi dek a sak wa, abe fi nyɛ kaabi kaai ale magsi ase Moosis ale sak ti dii dila po dila po la. Dila le sak nuruba ayen fi yaa ta nyiŋyɔgsa kama.” ");
INSERT INTO bwu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Gamini yaa basi dula jigini. Wa an jam va Yeezu ale weeni wa dii la, alege wa jam goanti a nyeemu a weeni wa a meena kama Yeezu ale tebi wa dii la. Dila nyiŋ ate Yeezu an ŋman baga a nyini peelim a jam tɛŋka po wa yaaka. Wa yaa ga bo goanni po ate nuruba nyini tɛŋsa yegayega po a jam wa jigi. ");
INSERT INTO bwu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Daa ale ŋman jam taam la, Yeezu a yaa basi dula ale ŋman cheŋ Kapernaum tɛŋka po a ga jo yeri dinyi po. Tɛŋka po demma a yaa wom ayen wa jam ya. ");
INSERT INTO bwu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nuruba yegayega yaa jam tigsi chaab yeri dii po ate wa boro la. Yenni meena a jam sueri kama ate nansiuŋku noai a ka zaanika jigiya, ate Yeezu a yaa boro a sak ba Naawen wie. Nuru wanyi ale jam boro ate wa nisima ale wa naŋsa a jam kpi. ");
INSERT INTO bwu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Wa yaa ale boro a sak nuruma la, nuruba banaansi a yaa pa nuru waai ate wa nisaŋa ale wa naŋsaŋa a kpi la, a dueni jaab zuk a ta wa a jam Yeezu jigi. ");
INSERT INTO bwu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ba an jam baga a vuri nuruma po a paari Yeezu, dii nyiŋ la nuruma a jam piisi kama. Ba jam pa nuruwa kama a ta jueli yenni zuk a vuri vorub yenni sunsuŋ a yaa pa miisa a bobi jaamu a pa wa ta va vorumu po a siŋ dueni Yeezu niŋ. ");
INSERT INTO bwu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yeezu ale jam seba ayen ba ta siaka yegayega ale wa la, wa yaa weeni nuru waai ate wa nisaŋa ale wa naŋsaŋa a kpi la ayen, “M biiga, m voŋ fi wabaataŋa a te fu kama.” ");
INSERT INTO bwu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Juuma Sinsaŋŋa sagrɔma ba gela ale jam maa kala dula jigini la, a yaa poli ba zuima po ayen, ");
INSERT INTO bwu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nuruwa de ale a biisi dii la, ku nala? Wa ale a nyɛ dii la ku ka leeta Naawen jigi. Ka Naawen dek wa nyiini ale a voŋ wabaata a te.” ");
INSERT INTO bwu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yeezu a poom seba wa dek popola po ba ale a poli dii la kama. Wa yaa bek ba ayen, “Ka boan jaab popola ate nama a poli ni zuima po? ");
INSERT INTO bwu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","11","Mi nin weeni nuruwa de ate wa nisimaŋa ale wa naŋsaŋa a kpi la, ayen Naawen voŋ wa wabaataŋa a te wa a yaase wa yiri a cheŋ, ka kuna dek ale pagra?” Wa ale ga bek dila la, wa yaa cheemu a weeni nuru waai ale a yuak la ayen, “Yiri a zaani ŋmai, abe fi pai fi jaamu ate fi a goa wa zuk la a cheŋ kuli fi yenni.” Yeezu a nyɛ nna kama ate ku sak ayen ni seba ayen ka wa Saalobiika ale ta pagrim tɛŋzuk meena a baga a voŋ nuruba wabaata a te ba. ");
INSERT INTO bwu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nuruwa a yaa deri yiri a zaani ŋmai ale pa wa jaamu a cheŋ nyini. Ku yaa cha nuru baai meena ale jam za dula jigini la. Ba yaa pak Naawen a weeni ayen, “Tama an diem a nya nyaku de choa ase ka jinla nyiini.” ");
INSERT INTO bwu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yeezu yaa basi dula jigini ale ŋman pilim cheŋ Galili mogi kpeeni noai, ate nuru bɔari a yaa jam wa jigi ate wa boro a sak ba Naawen wie. ");
INSERT INTO bwu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wa ale sak ba a nueri la, wa yaa cheŋ ga zik nuru waai ate ba a wi ayen Livai, la. Wa jam ka nuru waai ate ba a wi wa ayen Alfiyus la biik. Wa jam kala ka lampoo cheesika dɔk po a tuesi lampoo. Yeezu yaa weeni wa ayen, “Yiri a jam va mi ŋaaŋ.” Wa yaa basi wa tuimaŋa ale yiri a ga va wa. ");
INSERT INTO bwu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yeezu ale wa ŋaaŋviirima a yaa cheŋ Livai yenni ayen ba de ŋandiinta. Lampoo cheesiroba ale wabaata nyam yegayega a jam maa va Yeezu ŋaaŋ ate ba gela me a yaa jam gum wa ale wa ŋaaŋviirima po, ate ba meena a kala a de ŋandiinta. ");
INSERT INTO bwu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Juuma Sinsaŋŋa sagrɔma baai ate ba a wi ayen Farisiiba la, ba gela a yaa nya ba ale ba a de ŋandiintaŋa. Ba yaa bek wa ŋaaŋviirima po wanyi ayen, “Ka boa ale a sak ate Yeezu a siak a te lampoo cheesiroba ale wabaata nyam a kali a le wa a de ŋandiinta?” ");
INSERT INTO bwu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yeezu ale wom dila la, wa yaa weeni ba ayen, “Fi dan kan a yuagi fi kan cheŋ waai ale a tebi nuruba la jigiya, alege ka yuariba nyiini. Mi an jam ayen m wi ka nuru baai ale a poli ayen ba ka nuru maŋsa la, alege ka wabaata nyam ate m jam ayen m wi.” ");
INSERT INTO bwu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Da yeŋ po Jɔɔn waai ale a te nuruba soka la ŋaaŋviirima ale Farisiima ŋaaŋviirima a yaa bobi noa. Nuruba ba gela a yaa jam Yeezu jigi a bek wa ayen, “Ka boa ate Jɔɔn ŋaaŋviirima ale Farisiima ŋaaŋviirima a bobi noa, alege fi ŋaaŋviirima a kan bobi?” ");
INSERT INTO bwu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yeezu a yaa magsi wamagsini bek ba ayen, “Nipɔkfiaka nyɔnɔwa dɔama a baga a bobi noa? Aaya. Nipɔkfiaka nyɔnɔwa ale diem boro ale ba la, ba an baga a nyɛ dila. Mi ale m ŋaaŋviirima abe ale ka dii la ale la. ");
INSERT INTO bwu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Alege ku cheena ate nuruba le yik wa a ta cheŋ, dila po wa ba yaa le bobi noa.” ");
INSERT INTO bwu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Wa yaa ŋman magsi wamagsini di choa ayen, “Ba kan pa garuchiak paalik a laŋ garuk kpaga. Ba dan nyɛ dila, garuku le cheeri a gum du, a yaase, ");
INSERT INTO bwu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ba kan pa da paalik a su bunlɔk kpak po. Ba dan nyɛ dila, bunlɔkku a na kama ate daamu a waaŋi. Ku dan nyɛ dila, nuruwa a jok wa bunlɔkku ale wa daamu meena kama. Da paalik a magsi ka bunlɔk paaluk suka.” ");
INSERT INTO bwu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Juuma Vuusum Daaŋa po dinyi ate Yeezu ale wa ŋaaŋviirima a yaa va nuru wanyi talim po a taam. Ba ale a cheŋ la, wa ŋaaŋviirima a yaa wie “wiiti” zuima a ŋobi. ");
INSERT INTO bwu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farisiima ba gela ale jam nya dila la, ba yaa bek Yeezu ayen, “Nya, ka boa ate fi ŋaaŋviirima a kaasi tama Vuusum Danni kisiku?” ");
INSERT INTO bwu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yeezu yaa bek ba ayen, “Nama an diem karim Naawen gbaŋka po a miŋ na waai ate ba a wi ayen Deevid la wie? Da ŋaai po ate nuru waai ate ba a wi ayen Abiata a jam chim Naawen Puusika Yenni kpagi kpeeni la, ate kom a yaa jam ta Deevid ale wa dɔama. ");
INSERT INTO bwu_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Wa yaa ga jo Naawen Puusika Yenni po a pa boroboruk kuui ate nuruba a ta jam te Naawen la a we ŋobi ale ge a we a te wa dɔama ate ba me a ŋobi. Tama Sinsaŋŋa a weeni kama ayen nuru yoŋ an maara a ŋobi boroboruku de ka Naawen Puusika Yenni tomteerɔma nyiini. ");
INSERT INTO bwu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","“Naawen an lueri Vuusum Danni ayen ka di soa nuruba, wa nyɛ ka nuruba ale ge lueri Vuusum Danni ayen di chim da maŋ a te ba. ");
INSERT INTO bwu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Dila nyiŋ la, mi Saalobiika ale soa Vuusum Daaŋa me.” ");
INSERT INTO bwu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yeezu a yaa ŋman cheŋ ga jo ba tuka dɔkku po. Nuru wanyi ale jam bo dula ate wa nisa kpi. ");
INSERT INTO bwu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Baai ale jam bo dula la, a yaa limsi ayen ba nya ase Yeezu le tebi yaase wa kan tebi nuruwa nisaŋa Vuusum Danni ate ba baga a weeni wa ayen wa kaasi. ");
INSERT INTO bwu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yeezu a yaa weeni nuru waai ate wa nisaŋa a kpi la ayen, “Yiri ŋmai a jam de.” ");
INSERT INTO bwu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","A yaa ale ge a weeni nuruma ayen, “Nama seba Juuma Sinsaŋŋa kama. Ku magsi ayen ni tom ka tuimmaŋsa yaa tuimbaata ni Vuusum Danni? Ni te nuruba nyuvuri yaa ni ko ba?” Ba yaa goori nna chorototo. ");
INSERT INTO bwu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yeezu sui yaa puuri ale ba ate wa gisi nya ba ale su kaasuŋ dii nyiŋ la, ba tueŋa a kpari kama ate ba ka siaka ale wa. Wa yaa weeni nuruwa ayen wa teeri wa nisaŋa. Wa ale teeri si la, si yaa deri nya nyiŋyɔgsa. ");
INSERT INTO bwu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farisiima a yaa yiri a nyini peelim. Ba ale na waai ate ba a wi ayen Ayerod la nuruma a yaa tigsi chaab a poli siuk kuui ba le ba va a ko Yeezu la. ");
INSERT INTO bwu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yeezu ale wa ŋaaŋviirima a yaa nyini dula jigini a ŋman cheŋ mogi kpeeni noai. Nuruba yegayega a nyini Galili tɛŋka po a cheŋ va wa ŋaaŋ. ");
INSERT INTO bwu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ba gela a nyini Jerusalem ale Judia tɛŋsaŋa po. Ba gela me a nyini tɛŋka choa ate ba a wi ayen Idumia ale tɛŋ sii meena ale bo Jodan beli kpeeni ŋaaŋ nyiŋ la. Ba gela me a ŋman nyini tɛŋsa ate ba a wi ayen Taaya ale Saidon ale tɛŋ sii meena ale gilim dula jigini la. ");
INSERT INTO bwu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yeezu yaa weeni wa ŋaaŋviirima ayen ba gisi ŋaaruŋ a gomsi ku a zaani wa, dii nyiŋ la nuruma a piisi ka nna yegayega a yaa a tusi wa. Nuruma de meena ale wom Yeezu ale a nyɛ dii la ale soa ate ba jam wa jigi. ");
INSERT INTO bwu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yeezu a tebi nuruba yegayega dula jigini. Ka dila ale soa ate ba a tusi chaab ayen ba paari a tiri wa nya la. ");
INSERT INTO bwu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Baai ate chichiribaata a bo ba zuima po la ale nya wa la, ba yaa lo tɛŋ a kaari yegayega a weeni wa ayen, “Fi ka Naawen biik.” ");
INSERT INTO bwu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nna nyiem a dan nyɛ, Yeezu a nyiem a weeni chichiribaataŋa ka bunyi dekki ayen ti goori abe ti kan weeni sak nuruba wa ale ka waai la. ");
INSERT INTO bwu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","15","Yeezu ale wa ŋaaŋviirima a yaa cheŋ ga jueli guuk kunyi zuk. Wa ale jueli a nueri la, wa yaa wi nuru baai ate wa a yaali ayen ba jam wa jigi la. Wa yaa lueri nuruba pi ale baye a ta nyini nuru baai meena ate wa wi la po ayen ba jam va wa. Wa yaa weeni ba ayen, “M lueri ni kama ayen ni kasim bo ale mu. M le tom ni me ate ni nyini peelim a mooli Naawen wieŋa ate nuruba wom. M be le te ni pagrim ate ni baga a yiak chichiribaata nuruba zuima po a basi.” ");
INSERT INTO bwu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Wa nuruma pi ale bayewa yue ale Simon waai ate Yeezu a te wa yue paali ayen Piita la, ");
INSERT INTO bwu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ale Jeemsi ale wa suoku Jɔɔn. Jeemsi ale Jɔɔn a jam ka nuru waai ate ba a wi ayen Zebedi la bisa. Yeezu yaa ŋman te ba yue paali ayen Boanejisi. Di kiri ale nanpansa nuruba. ");
INSERT INTO bwu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Yeezu a yaa ŋman lueri Andiru ale Filip ale Batolomiu ale Matiu ale Tomasi ale Jeemsi waai ale jam ka nuru waai ate ba a wi ayen Alfiyus la, biik. Wa ŋman lueri Tadiusi ale Simon waai ale jam a nyɛ ayen Juuma a nya ba dek zuk la. ");
INSERT INTO bwu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Wa yaa ŋman lueri Judas Iskariot, nuru waai ale wa ta Yeezu a ga bobri a sak la. Wa yaa ale lueri ba a nueri la, ba meena a yaa va chaab a nyini guuku zuk a siŋ a cheŋ ga jo yeri dinyi po. ");
INSERT INTO bwu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nuru bɔari yegayega a yaa ŋman tigsi chaab a jam Yeezu jigi, ate wa ŋaaŋviirima an jam baga a nya siuk a de ŋandiinta. ");
INSERT INTO bwu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yeezu dɔkku demma ale wom dila la, ba yaa nyini ayen ba gisi a yik wa, dii nyiŋ la nuruba ale jam a weeni ayen, “Wa zukku a tagri kama.” ");
INSERT INTO bwu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Juuma Sinsaŋŋa sagrɔma ba gela a yaa nyini Jerusalem tɛŋka po a jam weeni chaab ayen, “Chichiribaataŋa meena naawa ate ba a wi ayen Beelzebu la, ale bo wa nyiŋka po a kasim a te wa pagrim ate wa baga a yiak chichiribaata nuruba zuima po a basi.” ");
INSERT INTO bwu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yeezu a yaa wi Juuma Sinsaŋŋa sagrɔma ate ba jam wa tɛŋ ate wa yaa magsi wamagsima a sak ba ale bek ba ayen, “Sitaana a nyɛ ka se a baga yiak wa dek tomteerɔma a basi? ");
INSERT INTO bwu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tɛŋ nuruba a dan a kpalim chaab, tɛŋ kala choa le kaasi kama. ");
INSERT INTO bwu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Yeri yeŋ dem a dan ta kpaliŋ ale chaab, ba le waaŋ ka chaab. ");
INSERT INTO bwu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Dila nyiŋ la Sitaana ale wa tomteerɔma a dan ta chaab, wa naamu a kan baga a zaani a beni. ");
INSERT INTO bwu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Siuk kula po la waai abe dan kan yik pagrɔ a bobiya, wa le nyɛ ka se a jo wa yenni po a zu wa ŋantaŋa? ");
INSERT INTO bwu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","29","“Ni basi ate m weeni nyaku de a sak ni ayen, Naawen le voŋ waai meena wabaata ale ba biisi kaasuŋ a te ba kama. Alege wa kan voŋ a te waai ale a le Naawen Chiika la, dii nyiŋ la, wabioku de a boro kama taam wuu.” ");
INSERT INTO bwu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Wa weeni ba wieŋa de kama, dii nyiŋ la nuruma ba gela a weeni kama ayen, “Wa ta ka chichiribiok wa zukku po.” ) ");
INSERT INTO bwu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ku ŋaaŋnyiŋ ate Yeezu suaataŋa ale wa mawa a yaa jam a za peelim a wi wa. ");
INSERT INTO bwu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nuru bɔari ale jam za gilim wa a yaa weeni wa ayen, “Fi mawa ale fi suaataŋa a za peelim a yaali fu.” ");
INSERT INTO bwu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Wa yaa bek ba ayen, “Ka wana ale mi ma? Be ka bana ale mi suaata?” ");
INSERT INTO bwu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Wa yaa chiem a nya ba meena ale kala a gilim wa la a yaa weeni ba ayen, “Ni nya, ka mi maba ale mi suaata ale nama. ");
INSERT INTO bwu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Baai meena ale a tom dii ate Naawen a yaali la, bala ale mi maba, ale m tɔaba, ale m suaata.” ");
INSERT INTO bwu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yeezu yaa ŋman jam Galili mogi kpeeni noai a sak nuruma Naawen wie. Nuruma a jam piisi ka nna yegayega a za gilim wa ate wa yaa yiri jo ŋaaruŋ po a kala. Ŋaaruŋku a jam bo ka nyiamu po ale ge ate nuruma a yaa za nyiamu noai. ");
INSERT INTO bwu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Wa yaa magsi wamagsima a sak ba wie nna yegayega ayen, ");
INSERT INTO bwu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ni wom mi nalimnyiini. Nuru wanyi ale jam boro a yaa nyini boro a yuk ŋanborinta ase muma la. ");
INSERT INTO bwu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wa yaa ale boro a yuk la, bieŋa gela a yaa lo siuku niŋ ate nuinsa a deri jam pisi ŋa meena, ");
INSERT INTO bwu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ŋa gela me a lo tintana po. Ŋa yaa nyini nna nwuli, dii nyiŋ la tantaŋa an jam soa diiya dula jigini. ");
INSERT INTO bwu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Wentueŋka ale jam nak ŋa la, ŋa yaa deri ko, dii nyiŋ la ŋa naŋsaŋa an jam baga a siŋ paari nyiamɔa. ");
INSERT INTO bwu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ŋa gela me a lo munsa po a yaa nyini. Munsaŋa me a nyini a geri ŋa ate ŋa an jam baga a biaya. ");
INSERT INTO bwu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ŋa gela me a lo tɛŋ naluŋ po a nyini a chim a biak a be nalimnyiini. Ŋaai ta bie pisita. Ŋa gela me pisiyuebi. Ŋa gela me ta kook.” ");
INSERT INTO bwu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yeezu ale ga nueri wa wamagsini la, wa yaa ŋman weeni ba ayen, “Nama baai ale ta tue a wom la, ni wom mi nalimnyiini.” ");
INSERT INTO bwu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wa ale jam kala wa dek wa nyiini la, baai ale jam a maa va wa ale wa ŋaaŋviirima pi ale bayewa la, a yaa bek wa ayen, “Fi wamagsimaŋa kie ale boa?” ");
INSERT INTO bwu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Wa yaa weeni ba ayen, “Naawen basi kama ayen ni seba wa naamu wasusuŋŋa, alege nuru yonta jigi m sinsaŋŋa a chim ka wamagsima, ate ");
INSERT INTO bwu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Ba a nya ale a nya alege ba kan nya, ba a wom ale a wom alege ba kan miŋ ŋa, dii nyiŋ la, ba dan nya ale miŋ ŋa, ba le tagri ba wabaata popolaŋa kama ate Naawen voŋ a te ba.’ ” ");
INSERT INTO bwu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yeezu yaa bek ba ayen, “Nama an baga wamagsini de kiri a miŋi? Ni be dan kan baga wamagsini de kiri a miŋi, ni yaa be le nyɛ ka se a baga a miŋ ŋa chaaba? ");
INSERT INTO bwu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nuru waai ale nyini a boro a yuk wa ŋanborintaŋa la, ku a nyɛ se ka Naawen wieŋa ate nuruba a sak la. ");
INSERT INTO bwu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Be ŋaai ale lo siuku po la, a nyɛ se ka baai ale a wom wa wieŋa, ale ge ate Sitaana a nyiem a deri jam a yeeri ŋa nwuli a ta nyini ba suniima po a nyini la. ");
INSERT INTO bwu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Be ŋaai me ale lo tintanaŋa po la, a nyɛ se ka baai ale a wom wa wieŋa ate ba sue a peenti, ");
INSERT INTO bwu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ale ge ate Naawen wieŋa a kan jo ba suniimaŋa po nalimnyiini la. Ba yaa va maga dega, alege ninam a dan yik ba, ba Naawen wieŋa vaka nyiŋ, ba nyiem a deri pa ŋa vaka a basi. ");
INSERT INTO bwu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Be ŋaai me ale lo munsaŋa po la, a nyɛ se ka baai ale a wom Naawen wieŋa ");
INSERT INTO bwu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","alege tɛŋka po wieŋa popolaŋa ale ba ligra yaalika yegayega ale ba ŋanta yaalika, ŋala meena a de ka Naawen wieŋa ate wamaŋ an baga a nyini ŋa po a nyini. ");
INSERT INTO bwu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Be ŋaai me ale lo tɛŋ naluŋku po la, a nyɛ se ka baai ale a wom Naawen wieŋa ate ŋa jo ba suniima po nalimnyiini la. Ba a nyɛ se ka ŋantaŋa ale nyini a yaa biak a be ate ŋa gela a ta bie pisita, ŋaai me pisiyuebi, ŋaai me bie kook dii la.” ");
INSERT INTO bwu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yeezu yaa bek ba ayen, “Nuru a dan tɔati wa bolimzeuŋ wa a pa ka chin a vuk ku? Yaase wa a pa a zaani ka gaduok tɛŋka? Aawo, wa a pa ku a zaani ka jaab zuk ate ku a nya dɔkku po meena. ");
INSERT INTO bwu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jaab buuri meena ale chim wasusugi la, a kan ŋman chim wasusugi nuruba jigiya. Dii meena ale ligi doa la, le nyini peelim ate nuruba nya. ");
INSERT INTO bwu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Dila nyiŋ, nama baai ale ta tue a wom la, ni wom mi nalimnyiini.” ");
INSERT INTO bwu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Wa ŋman pilim weeni ba ayen, “Ni kpesi a wom dii ate m tara ayen m weeni a sak ni la. Magsi kaai ate fi pa a magsi ŋanta a te nuru la, magsi kala degadega ate Naawen le pa magsi a te fi me, ate ku poom gaam taam. ");
INSERT INTO bwu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nuru waai nisa po ale ta la, Naawen le ŋman te wa ŋanta yegayega a gum du, alege waai nisa po ale kan ta la, Naawen le ŋman tuesi jaab fiik kaai ate wa poom ta la kama.” ");
INSERT INTO bwu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","27","Yeezu a yaa ŋman weeni ba ayen, “Naawen Naamu ale a nyɛ dii la ale nna. Nuru ale bori wa talim. Daa meena ate wa goa a yiri la, wa ze ŋantaŋa ale nyɛ dii a nyini ale a chim la. ");
INSERT INTO bwu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ka tɛŋka ale a wuuk bieŋa ate ŋa a nyini ale a chim ale ge a ta bie. Zabuli ale liŋ a chim, a pak a paari kiŋkari, a yaa ga a biak ale ge ate bieŋa a yaa ga kpeglim. ");
INSERT INTO bwu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ŋa yaa ale be a ga nueri la, nuruwa a yaa pa wa gebik a ta cheŋ wa talimu po a ga che dii nyiŋ la, ŋa cheka paari kama.” ");
INSERT INTO bwu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yeezu a yaa ŋman bek ba ayen, “Ti le pa ka boa a magsi chaab ale Naawen Naamu? ");
INSERT INTO bwu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Bu a nyɛ ase ka nna la. Ase nuru ale pa ‘mastad’ bie a bori la. Bieŋa a posima kama a gaam tɛŋzuk bie meena po. Wa yaa pa ŋa a bori ate ŋa nyini chim tikpieŋsa a ta naŋsa ale yɔgsum nna yegayega ate nuinsa a kali si zuk a yok tugta.” ");
INSERT INTO bwu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Wamagsima ŋaai chaab ate Yeezu a jam magsi a sak nuruba la ale nna. Wa jam magsi ka ŋa chaab nna yegayega a gum du ayen baai ale ta Naawen yammu la a baga a miŋ chak. ");
INSERT INTO bwu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wa an jam biisi wari dinyi la ale nuruba alege kan magsi wamagsini. Alege, wa ale wa ŋaaŋviirima a dan jam boro ba dek ba nyiini, wa nyiem a weeni wa wamagsimaŋa kie a sak ba kama. ");
INSERT INTO bwu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Dila danni junɔai Yeezu a yaa weeni wa ŋaaŋviirima ayen, “Ni te ti taam mogi kpeeni kauk kuŋkula.” ");
INSERT INTO bwu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Wa ŋaaŋviirima yaa basi nuru bɔanni ale cheŋ ga jo Yeezu ale kali ŋaaruŋ kuui po la ayen ba cheŋ. Nuruba ba gela me a jo ŋaarunta a maa va ba ŋaaŋ. ");
INSERT INTO bwu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ba ale a cheŋ la, va kpioŋ a yaa jam a nak ba ŋaaruŋku nna yegayega ate nyiamu me a yiri a jueli wein. Bu yaa jo ba ŋaaruŋku po ate ku a nyɛ ku siŋ nyiamu tɛŋ. ");
INSERT INTO bwu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yeezu a jam dua ŋaaruŋku po ba ŋaaŋ a kpagli ka dafeeluk a goa. Wa ŋaaŋviirima a yaa nak wa a yiri a bek wa ayen, “Ti Nyɔnɔ, fi niŋ ka ale ti ni wari nyiamu po?” ");
INSERT INTO bwu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Wa yaa yiri wa goomu jigini a zaani ŋmai a yaa weeni vioku ayen ku basi abe nyiamu me a nyɛ balaa. Vioku a yaa deri basi ate nyiamu me a baliŋ. Nyiamu an ŋman choaya ale maga dek me. ");
INSERT INTO bwu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yeezu a yaa bek wa ŋaaŋviirima ayen, “Ka boa ate nama a chali yɔgsumɔa? Nama diem ka siaka?” ");
INSERT INTO bwu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ku yaa cha ba ate ba a bek chaab ayen, “Nuruwa de, ka wana ate wa baga a biisi ale vioku ale nyiamu ate ba a wom wa nɔaya?” ");
INSERT INTO bwu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yeezu ale wa ŋaaŋviirima a yaa taam Galili mogi kpeeni kauk kuŋkula ŋaaŋ nyiŋ a ga paari nuru baai ate ba a wi ayen Gerasa la tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nuru wanyi a yaa jam bo tɛŋ kala po a ta chichiribiok wa zuk po. ");
INSERT INTO bwu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nuru waai jam karo a baga bobi wa. Ba jam pa ka choarima kpeema a bobi wa, alege wa baga a gebi ŋa. ");
INSERT INTO bwu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ba ŋman pa choarimaŋa ale kuta a bobi wa naŋsa ale wa nisima a ga jiak, alege wa ŋman gebi ŋa me meena. Waai a jam karo a ta pagrim a baga a yik wa. ");
INSERT INTO bwu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Wa jam bo ka ba ale a gu nuruba juijui la ale guuta zuima a nyiem a cheŋ ale a kaari nna yegayega ale a pa tintain laasa a gebi wa nyiŋka. ");
INSERT INTO bwu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","Yeezu ale nyini ŋaaruŋku po a siŋ la, nuruwa a jam za ka nuruma guka jigini ate ku jam yalima. Yeezu a yaa weeni chichiribioku ayen ku nyini nuruwa zukku po a nyini. Nuruwa ale nya Yeezu la, wa yaa chali a jam kpi duna tɛŋ wa niŋ, a yaa kaari nna yegayega a weeni wa ayen, “Fi Yeezu, Naawen kpeeni biika, fi a yaali ka boa mi jigiya? Chali Naawen yonni nyiŋ abe fi kan namsi mu.” ");
INSERT INTO bwu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yeezu yaa bek wa ayen “Fi yoi ale boa?” Ku yaa weeni wa ayen, “Mi yoi ale ‘Anurubɔari’, dii nyiŋ la ti piisi kama.” ");
INSERT INTO bwu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nuruwa a yaa saalim Yeezu nna yegayega ayen wa kan yiak chichiribaataŋa dula jigini a basi. ");
INSERT INTO bwu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Die ale jam piisi nna yegayega a za guuk kunyi zuk dula jigini a de. Ŋa jam paari ka tusa ŋaye. ");
INSERT INTO bwu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Chichiribaataŋa a yaa saalim Yeezu ayen wa basi ate ti ga jo dieŋa de po. ");
INSERT INTO bwu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yeezu a yaa te ti siuk. Ti yaa basi nuruwa ale nyini a ga jo dieŋa po ate ŋa meena yaa chali nna nwuli a siŋ ga lo mogi kpeeni nyiamu po a kpi. ");
INSERT INTO bwu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nuru baai ale jam a nya dieŋa zuk la, a yaa chali kuli ba yieŋa a ga weeni ba yieŋa demma ale baai meena ate ba jam a tu ba siuku niŋ la, dii ale nyɛ la. Tɛŋka demma a yaa nyini a cheŋ Yeezu jigi ayen ba nya dii ate baai ale a nya deeŋa la a weeni ba la. ");
INSERT INTO bwu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ba yaa jam a nya nuru waai ate chichiribaataŋa a jam bo wa zukku po la ale wa jo gatta a kala ale Yeezu. Wa an ŋman a yesimu. Yɔgsum a yaa deri yik ba. ");
INSERT INTO bwu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nuru baai ale jam nya dii ale nyɛ nuru wa jigi ale chichiribaataŋa ale dieŋa la, a yaa weeni a sak nuruba meena ale jam bo dula jigini la. ");
INSERT INTO bwu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tɛŋka demma ale wom dii ate ba weeni la, ba yaa jam a saalim Yeezu ayen wa nyini ba tɛŋka po nyini. ");
INSERT INTO bwu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yeezu a yaa ale cheŋ ayen wa jo ŋaaruŋku po la, nuru waai ale jam ta chichiribaataŋa la a jam saalim wa ayen wa basi ate wa maa va wa a cheŋ. ");
INSERT INTO bwu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yeezu an jam siaya, alege weeni wa ayen, “Kuli ga weeni fi yenni demma Nyɔnɔwa ale ta jiirim ale fu a maari fu dii la.” ");
INSERT INTO bwu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nuruwa a yaa cheŋ ga weeni nuru baai ale jam bo tɛŋsa piwa po la dii ate Yeezu a nyɛ a te wa la. Ku yaa cha baai meena ale jam a wom la. ");
INSERT INTO bwu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yeezu yaa ga jo ŋaaruŋku po a gaam taam mogi kpeeni kauk kuŋkula. Wa ale cheŋ a ga paari dula jigini la, nuru bɔari yegayega a yaa tigsi a gilim wa mogini noai. ");
INSERT INTO bwu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Juuma tuka dɔkku kpaŋŋa po wanyi ale jam maa bo nuru bɔanni po. Wa yoi a jam ale Jairus. Wa yaa ale ga nya Yeezu la, wa yaa jam wa niŋ ");
INSERT INTO bwu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","a saalim wa nalimnyiini ayen, “M dek koa, m lie ale a yuak a mɔata kum, ate mi a saalim fu ayen fi jam a pa fi nisa a ji wa zuk ate wa nya nyiŋyɔgsa.” ");
INSERT INTO bwu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yeezu a yaa va Jairus a cheŋ ate nuruba yegayega a yaa maa va wa a gilim wa. ");
INSERT INTO bwu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nipɔk wanyi a yaa jam bo dula a jam a yuak bena pi ale ŋaye. Wa tuemu a jam a nyɛ ase wa a lo ka chiak la. Ku kasim jam a nyɛ ka daa meena. ");
INSERT INTO bwu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tiita nyam yegayega a jam tebi wa a kpeeri. Wa jam kaasi wa ligra meena, alege tuemu an jam a basi wa ale a diem a daani wa me nna yegayega a gum du. ");
INSERT INTO bwu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Wa ale wom Yeezu wie la, wa yaa poli wa zuk po ayen, “M dan baga a paari wa garuku nɔanni a tiri, m le nya nyiŋyɔgsa.” ");
INSERT INTO bwu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Wa yaa cheŋ a ga jo nuru bɔanni po a ga tu Yeezu a yaa va wa ŋaaŋ a tiri wa garuku nɔanni. Wa le tiri garuku la, wa tuemu a deri basi wa, ate wa yaa miŋ ayen wa nya nyiŋyɔgsa kama dula jigini. ");
INSERT INTO bwu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yeezu a yaa deri miŋ ayen ku nyɛ wa jigi kama ase nuru ale tiri wa a yaa nya nyiŋyɔgsa la. Wa yaa cheemu ayen wa nya ase ka wana a yaa bek ayen, “Ka wana ale tiri mi garuku?” ");
INSERT INTO bwu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wa ŋaaŋviirima a yaa weeni ayen, “Fi kan nya nuruma ale piisi a gilim fu dii la, alege ate fi a bek ayen ka wana ale tiri fu?” ");
INSERT INTO bwu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yeezu a yaa diem gisi nya gilim ayen wa nya waai ale tiri wa la. ");
INSERT INTO bwu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nipowa kpaziim a yaa nak ate wa nyiŋka a gok. Wa jam seba ayen Yeezu a tebi wa kama ate wa yaa kpi duna tɛŋ wa niŋ a weeni wa ale wensie meena tuemu wie. ");
INSERT INTO bwu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yeezu a yaa weeni wa ayen, “M lie, fi siaka a basi ate fi nya nyiŋyɔgsa kama. Kuli yeri ale sunum masik, dii nyiŋ la fi tuemu a nueri kama.” ");
INSERT INTO bwu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yeezu ale diem bo dula a biisi la, nuruba ba gela a yaa nyini Jairus yenni a jam wa jigi a weeni wa ayen, “Fi leewa a kpi kama. Kan ŋman a daani Sagrɔwa ayen wa jamu.” ");
INSERT INTO bwu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yeezu ale wom dii ate ba weeni wa la, wa yaa weeni Jairus ayen, “Kan te ku a daani fu, alege kasim ta siaka.” ");
INSERT INTO bwu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yeezu an jam a yaali ayen nuru waai a va ba a cheŋ, alege ka Piita ale Jeemsi ale wa suoku Jɔɔn nyiini. ");
INSERT INTO bwu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ba ale ga paari nya ale ku a nyɛ ŋaglim Jairus yenni po ate nuruma a kumu ale a kaari nna yegayega la, ");
INSERT INTO bwu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yeezu a yaa cheŋ ga jo yenni po a bek ba ayen, “Ka boa ate nama a kum ale a kaari dila? Biika an kpiya. Wa a goa kama.” ");
INSERT INTO bwu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ba yaa deri a la wa wa nina po. Wa yaa yiak ate ba meena a nyini peelim, ale ge a yik biika kowa ale wa mawa ale wa ŋaaŋviirima batawa a yaa ta ba jo biika goomu dɔkku po. ");
INSERT INTO bwu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yeezu a yaa yik biika nisa a weeni wa ayen, “Nipɔkbiliga, yiri.” Ba a weeni ale ba dek tɛŋka biika ayen ka “Talita kumi.” ");
INSERT INTO bwu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nipɔkbinni a yaa deri a yiri zaani ŋmai a cheŋ. Biika jam ta ka bena pi ale ŋaye. Ku yaa cha baai meena ale jam bo dula jigini la nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yeezu a yaa weeni ba ayen ba nyɛ ŋandiinta a te wa ate wa de, ale ge kaam ba me ayen, “Ni kan basi ate nuru a wom dii ate mi nyɛ la.” ");
INSERT INTO bwu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yeezu yaa basi dula jigini ale ge cheŋ tɛŋ kaai ate wa liŋ jam boro la. Wa ŋaaŋviirima me a yaa va wa a cheŋ. ");
INSERT INTO bwu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ba ale diem bo dula jigini la, Juuma Vuusum Danni yaa paari ate ba cheŋ ga jo ba tuka dɔkku po ate, wa yaa sak nuruma Naawen wieŋa. Nuruba yegayega a jam bo dula jigini a wom Yeezu sinsaŋŋa ate ku yaa cha ba. Ba yaa bek chaab ayen, “Nuruwa de a nyɛ ka se a seba nna? Ka boan jaab yam ale nna ate Naawen te wa? Wa nyɛ ka se a tom wakperikaliisaŋa nna? ");
INSERT INTO bwu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Daa wala ale chapentawa a bo dela la? Daa Mɛɛri biika ale la? Daa wa suaata ale Jeemsi ale Josesi ale Judas ale Simon la? Wa tɔama me an bo daa dela la?” Dila nyiŋ ate Nazaret demma a jam zɛri wa. ");
INSERT INTO bwu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yeezu a yaa weeni ba ayen, “Waai meena a te Naawen biisiteerɔwa zula kama, alege ka wa dek tɛŋka demma ale wa suaataŋa, ale wa yenni demma nyiini ale kan a te wa zula.” ");
INSERT INTO bwu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Wa ale jam bo dula jigini la, wa an jam baga a nyɛ wariya alege, wa jam pa ka wa nisa a ji yɔgnyeensa ba gela zuima tebi ba. ");
INSERT INTO bwu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ku jam cha wa ka nna yegayega ale nuruma ale jam kan ta siaka la. Ba yaa basi dula jigini ale ge cheŋ tɛŋfiik sii ale jam bo dula la, a sak nuruba Naawen wieŋa. ");
INSERT INTO bwu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Wa yaa wi wa ŋaaŋviirima pi ale bayewa ate ba jam a tigsi chaab wa jigi ayen wa tom ba baye baye. Wa yaa te ba pagrim ate ba baga a yiak chichiribaata nuruba zuima po a basi. ");
INSERT INTO bwu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Wa yaa weeni ba ayen, “Nama ale a cheŋ la, ni kan pa koalima a yaase ŋandiinta, a yaase fotta, a yaase ligra dek me. Ni kan pa gatta ti chaab a gum ga tii ate ni jo la po. Ni su nuensa abe ni pa tachegsa nyiini a nyo ni nisima po a ta cheŋ. ");
INSERT INTO bwu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ni dan cheŋ ga paari tɛŋ kanyi ate ba te ni dɔk ayen ni goa, ni kasim a goa dɔk kula po a ta ga paari diipo ate ni a basi tɛŋ kala la. ");
INSERT INTO bwu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ni dan jam paari tɛŋ kanyi ate tɛŋ kala demma a dan kan te ni tia a yaase ba an wom dii ate ni ta ayen ni weeni a sak ba la, ni basi dula jigini abe ni kpaanti ni naŋsaŋa paasuku a basi dula ate ku sak ayen ni a kaam ba kama ba ale zɛri Naawen wieŋa la nyiŋ.” ");
INSERT INTO bwu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yeezu a yaa ale sak ba a ga nueri la, ba yaa cheŋ ayen ba ga sak nuruma Naawen wieŋa, ate ba basi ba tuimbaataŋa abe ba ŋman va Naawen wensie siuku. ");
INSERT INTO bwu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ba jam a yiak chichiribaata nuruba zuima po yegayega a basi ale a pa kpaam a boori a nyo yuariba zuima zuk a tebi ba. ");
INSERT INTO bwu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Naab Ayerod a jam wom Yeezu wie kama, dii nyiŋ la waai meena a yaa jam a biisi ka Yeezu wie. Ba gela a jam a weeni ayen wa ka Jɔɔn waai ale a te nuruba soka la, ale yiri kum po. Ka dila nyiŋ ale soa ate wa baga a tom wakperikaliisaŋa de. ");
INSERT INTO bwu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ba gela a pa wa chim ka Naawen biisiteerɔwa waai ale jam boro ate ba a wi ayen Elaja la. Ba gela me a jam a weeni ayen, “Wa ka Naawen biisiteerɔ waai ale a nyɛ ase baai ate Naawen jam tom la.” ");
INSERT INTO bwu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Naab Ayerod ale wom Yeezu wie la, wa yaa weeni wa dek ayen, “Nuruwa de ka Jɔɔn waai ale jam a te nuruma soka la. Mi basi ate ba gebi wa zukku kama alege wa ŋman yiri kum po.” ");
INSERT INTO bwu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Ayerod a jam faari ka wa suoku waai ate ba a wi ayen Filip la, powa. Wa powa yoi a jam le Ayerodiasi. Jɔɔn a liŋ jam weeni Ayerod kama ayen, “Fi ale nyɛ dii ale fi suoku powa la, an va Juuma Sinsaŋŋa yaalika.” A nyini da ŋala po a ta a cheŋ, Ayerodiasi a jam kisi Jɔɔn kama a yaa be a yaali ayen wa ko wa, alege wa an jam nya siuwa dii nyiŋ la, Ayerod a jam yik wa a lik ka dɔk po. ");
INSERT INTO bwu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ayerod a jam a chali Jɔɔn ka yɔgsum ale a te wa zula me, dii nyiŋ la wa seba ayen Jɔɔn ka nuru maŋ ale nuru weleŋ. Ka dila nyiŋ ale soa ate Ayerod an jam siak ayen ba ko wa. Jɔɔn sinsaŋŋa a jam a daani Ayerod ka nna yegayega alege wa diem a yaali ayen wa wom dii ate wa ta la. ");
INSERT INTO bwu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ku ŋaaŋnyiŋ ate Ayerodiasi da soŋku a yaa jam. Ayerod biamu danni ale jam paari la, wa yaa wi wa kpak kpeemaŋa ale wa sojima kpaŋŋa ale nuru kpeentaŋa baai meena ale jam bo Galili tɛŋka po la ayen ba jam maa de wa biamu danni ŋandiintaŋa. ");
INSERT INTO bwu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ba ale jam tigsi chaab a boro a de la, Ayerodiasi leewa a yaa jo dɔk kuui ate ba kala a de la po, a yaa gogi sak ba. Wa gogtaŋa a jam te Ayerod ale wa dɔama ka supeentik nna yegayega, ate Ayerod a yaa weeni wa ayen, “Fi ale a yaali jaab buui la, m le te fu.” ");
INSERT INTO bwu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Wa yaa ŋman pe a weeni wa ayen, “Jaab buui meena ate fi a yaali la, weeni mu, ate m te fu. Fi dan a yaali m tɛŋka naamu geli m le pa te fu.” ");
INSERT INTO bwu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nipɔkbinni a yaa nyini a cheŋ wa mawa jigi a yaa bek wa ayen, “Ka boa ate fi a yaali ayen m bek naawa jigiya?” Wa mawa a yaa weeni wa ayen wa bek wa ate wa gebi Jɔɔn zukku a te wa. ");
INSERT INTO bwu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Wa yaa ŋman pilim a ga jo naawa jigi nna nwuli a weeni wa ayen, “Mi a yaali ayen fi gebi ka Jɔɔn zukku yɔgyɔgla de a pa dueni taasi tanlaŋ po ate ba ta jam a te mu.” ");
INSERT INTO bwu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wa ale weeni nna la, ku jam kaasi Ayerod popola ka nna yegayega, alege wa an jam baga a zɛriya, dii nyiŋ la wa jam pe kama wa dɔama nimbie po ayen wa le te wa jaab buui meena ate wa a juisi wa jigi la. ");
INSERT INTO bwu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Wa yaa tom wa sojima po wanyi ayen wa gebi Jɔɔn zukku a ta jam. Sojiwa yaa cheŋ juijui ate ba lik Jɔɔn la a yaa gebi wa zukku ");
INSERT INTO bwu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","a pa dueni taasi tanlaŋ po a ta ŋmani a cheŋ ga te nipɔkbinni. Wa yaa tuesi a ta ga te wa mawa. ");
INSERT INTO bwu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jɔɔn ŋaaŋviirima ale jam wom dii ale nyɛ la, ba yaa ga pa wa nyiŋka a ta ga gu puŋ vorub po. ");
INSERT INTO bwu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yeezu tuimtomdɔma pi ale bayewa baai ate wa jam tom ba la, a yaa ŋman jam wa jigi a weeni wa dii meena ate ba tom ale dii meena ate ba sak nuruma la. ");
INSERT INTO bwu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bala ale Yeezu an jam nya siuk a kali de ŋandiinta, dii nyiŋ la nuruba yegayega a kasim a jam kama ale a kuli. Dila nyiŋ la, wa yaa weeni ba ayen, “Ni jam ate ti cheŋ jigi yoŋ ti dek ti nyiini a ga vuusi maga.” ");
INSERT INTO bwu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ba yaa basi dula jigini ale ge cheŋ a ga jo ŋaaruŋ po ayen ba cheŋ juijui ate nuru karo la. ");
INSERT INTO bwu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ba ale jam a cheŋ la, nuruba yegayega a yaa nya ba a deri miŋ ba. Ba yaa nyini ba tɛŋsaŋa po a chali va kuŋkɔŋini a de ba niŋ a ga paari ŋaaruŋku ale a cheŋ juijui la. ");
INSERT INTO bwu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yeezu ale nyini ŋaaruŋku po a siŋ la, wa yaa nya nuru bɔari nna yegayega ale ba za a limsi wa. Wa nya ba ase ba ka pa ŋaai ale kan ta naapeerik la. Wa jiirim a yaa jam bo ale ba ate wa yaa sak ba wie nna yegayega dula jigini. ");
INSERT INTO bwu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ba ale jam za dula jigini ate ku beni la, Yeezu ŋaaŋviirima a yaa jam wa jigi a weeni wa ayen, “Nya ti bo ka sagi po dela jigini ate wenni me a siŋ ti. ");
INSERT INTO bwu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Basi ate nuruma a cheŋ tɛŋ sii ale mɔata la po a ga da ŋandiinta a de.” ");
INSERT INTO bwu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yeezu a yaa weeni ba ayen, “Nama dek a te ba ŋandiinta ate ba de.” Ba yaa weeni wa ayen, “Ee, ti le nya ligra ka be ate ŋa paari a da ŋandiinta, ate ba de chagi?” ");
INSERT INTO bwu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yeezu ŋman bek ba ayen, “Ka boan ŋandiinta ate ni tara? Ni cheŋ a ga gisi nya.” Ba yaa cheŋ a ga nya ale ŋman pilim a jam weeni wa ayen, “Ti ta ka borobotta tinu ale juma ŋaye nyiini.” ");
INSERT INTO bwu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Wa yaa weeni nuruma meena ate ba kali tɛŋ wuuku po, nuruba kook kook, ba gela me pisinu pisinu a ga nueri. ");
INSERT INTO bwu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Di ŋaaŋnyiŋ ate Yeezu yaa pa borobotta tinuwa ale juma ŋayewa a yaa zak wa zuk nya wenŋmazuk a te Naawen jiam. Wa ale nyɛ Naawen jiam a ga nueri la, wa yaa ŋmari borobottaŋa ale jumaŋa a te wa ŋaaŋviirima ayen ba pa chari nuruma. ");
INSERT INTO bwu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Waai meena a jam ŋobi chak kama. ");
INSERT INTO bwu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ba ale ŋobi a ga nueri la, Yeezu ŋaaŋviirima a yaa pa ŋandiin tii ale tali la a sueri busisa pi ale siye. ");
INSERT INTO bwu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nidɔa baai ale jam de ŋandiintaŋa la a jam ka tusa ŋanu. ");
INSERT INTO bwu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yeezu a yaa weeni wa ŋaaŋviirima ayen ba cheŋ a ga jo ŋaaruŋku po a taam mogi kpeeni kauk kuŋkula ŋaaŋ nyiŋ a ga paari tɛŋ kaai ate ba a wi ayen Beteseida la, abe ba ge ate wa banti nuru bɔanni ate ba kuli ba yieŋa. ");
INSERT INTO bwu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wa ale banti ba a ga nueri la, wa yaa cheŋ a ga jueli guuk kunyi zuk ayen wa puusi a te Naawen. ");
INSERT INTO bwu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Junɔai ale jam paari la, Yeezu a jam za ka guuku zuk wa dek wa nyiini. Wa ŋaaŋviirima a yaa jam kala ŋaaruŋku po mogi kpeeni nyiamu sunsuŋ. ");
INSERT INTO bwu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Wa yaa nya ale vioku a nak ba ŋaaruŋku ate ba an baga a paari kuŋkɔŋini. Ku ale jam paari ate vari kpadiaka a kum la, wa yaa nyini guuku zuk a siŋ a cheŋ nyiamu zuk a ga ba jigi a yaa be a yaali ayen wa gaam ba a taam. ");
INSERT INTO bwu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ba meena ale nya wa ale wa a cheŋ nyiamu zuk la, ba yaa pa chim ayen, “Wa ka kok.” ");
INSERT INTO bwu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ba kpaziim a nak ate ba kaari nna yegayega. Yeezu a yaa weeni ba ayen, “Ka mi. Ni kan chali yɔgsumɔa, ni basi ate ni nyiŋsaŋa a pagra.” ");
INSERT INTO bwu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Wa yaa jam jo ŋaaruŋku po a gum ba po. Wa ale jo a ga nueri la, vioku a yaa deri zaani. Ku yaa cha ba nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ku jam cha ba, dii nyiŋ la, ba an jam miŋ Yeezu ale nyɛ dii a pa borobottaŋa a chari nuru bɔanni la kiriya. Ba popolaŋa a jam lik kama. ");
INSERT INTO bwu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ba yaa ale gaam taam a ga paari kauk kuŋkula ŋaaŋ nyiŋ la, ba yaa jam paari tɛŋ kaai ate ba a wi ayen Genesaret la. Dula jigini ba yaa bobi ba ŋaaruŋku a zaani. ");
INSERT INTO bwu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Yeezu ale nyini ŋaaruŋku po a siŋ la, nuruba a yaa deri miŋ wa, ");
INSERT INTO bwu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ate ba deri chali jo tɛŋka po meena ayen ba weeni a sak nuruba wa ale jam la. Juijui meena ate ba jam wom ayen wa boro la, ba yaa pa ba yuaroma a dueni ŋanta zuk a ta ga wa jigi ayen wa tebi ba. ");
INSERT INTO bwu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yeezu a yaa nyiem gilim tɛŋkpieŋsa ale tɛŋ fiisa ale tɛŋ kpaŋsa meena po. Nuruma ale ga wom ayen Yeezu cheena la, ba yaa chali kuli ba yieŋa a ta ba yuaroma a cheŋ yabaŋa po a saalim wa ayen wa basi ate ba tiri wa garuku nɔanni ate ba nya nyiŋyɔgsa. Baai meena ale tiri wa garuku la, a nya nyiŋyɔgsa kama. ");
INSERT INTO bwu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisiima ale Juuma Sinsaŋŋa sagrɔma ba gela a yaa nyini Jerusalem tɛŋka a jam tigsi chaab a gilim Yeezu. ");
INSERT INTO bwu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ba ale diem a jam bo wa jigi la, ba yaa nya ale wa ŋaaŋviirima a kaasi ba kisitaŋa kunyi, dii nyiŋ la ba an nari ba nisimaŋa ase Farisiima kisitaŋa ale a va dii la. ");
INSERT INTO bwu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Farisiima ale Juuma meena a nyiem kasim a va ka ba kokpieŋsaŋa kisuk kuui ale a sak ba ayen ba nyiem nari ba nisimaŋa abe ba de ŋandiinta la. ");
INSERT INTO bwu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ba dan nyini yaba a kuli, ba a de ka niŋ a sugri ba dek ale ge a de ŋandiinta. Ba a va ka ba kokpieŋsaŋa kisitaŋa meena tii ale a sak ba ayen ba a nari ba samɔnsa tɔgatɔga ale ba beerisa tɔgatɔga ale ba taasa tɔgatɔga la.) ");
INSERT INTO bwu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Farisiima ale Juuma Sinsaŋŋa sagrɔma yaa bek Yeezu ayen, “Ka boa nyiŋ ate fi ŋaaŋviirima a zɛri ti kokpieŋsaŋa nisima narika kisiku ale ge a de ŋandiinta?” ");
INSERT INTO bwu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yeezu a yaa weeni ba ayen, “Nama ka venta nyam. Naawen biisiteerɔwa Azaya ale jam ŋmarisi nama wie a nyo Naawen gbaŋka po dii la ka wensie. Wa ŋmarisi ayen Naawen a weeni ayen, ‘Nuruma de a puusi mi ale ka ba noa nyiini, alege ba suniimaŋa a ka mi jigiya. ");
INSERT INTO bwu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ba pa ka nurubiik kisita a sak nuruba ale a weeni ayen ti ka Naawen kisita. Ka dila nyiŋ ale soa ate ba puusaŋa chim kinla mi jigi la.’ ");
INSERT INTO bwu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Nama a basi ka Naawen Sinsaŋŋa vaka ale a va ni kokpieŋsaŋa kisitaŋa. ");
INSERT INTO bwu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Nama pa ka ni dek yam a zɛri Naawen Sinsaŋŋa vaka ayen ni nya siuk a va ni dek kisita sinsaŋŋa. ");
INSERT INTO bwu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moosis a jam ŋmarisi Naawen gbaŋka po ayen, ‘Ku a fe ate ni a zuli ni koba ale ni maba. Wa ŋman ŋmarisi ayen waai ale a le wa ko a yaase wa ma la, ku a fe ate ba ko wa.’ ");
INSERT INTO bwu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Alege nama nyiem a kasim a sak nuruba ayen nuru waai a dan weeni wa ko ale wa ma ayen jaab buui ate wa pa maari ba la ka ‘koban’ jaab, ku magsi ka wa kan a maari ba. ‘Koban’ kiri ale jaab buui ate ba a te Naawen la. ");
INSERT INTO bwu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ase nama a dan a nyɛ dila, ni a va ka ni dek sinsaŋŋa, ni a kaasi ka Naawen Sinsaŋŋa. Wie ŋa chaab nna degadega ate ni pa a sak nuruba ayen ba a va ŋa.” ");
INSERT INTO bwu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yeezu a yaa ŋman wi nuru bɔanni ate ba jam wa jigi ate wa weeni ba ayen, “Nama meena lak ni tueŋa a wom abe ni miŋ chak. ");
INSERT INTO bwu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ŋanta baai ale a jo ni puusa po la, a kan te ni daŋta, alege ka ŋanta baai ale a nyini ni noaŋa po a nyini la, ale a te ni daŋta. ");
INSERT INTO bwu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nama baai ale ta tue a wom la, ni wom nalimnyiini.” ");
INSERT INTO bwu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yeezu yaa ale basi nuru bɔanni ale ge cheŋ ga jo dɔk la, wa ŋaaŋviirima a yaa bek wa wa wamagsini kiri. ");
INSERT INTO bwu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yeezu a yaa tulisi ba ayen, “Nama an baga miŋ ayen ŋanta baai ale jo ni po la a kan te ni daŋta? Nama ze chak mi ale a weeni dii la? ");
INSERT INTO bwu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ba kan jo ni suniimaŋa po, ba a jo ka ni puusaŋa po a yaa ŋman pilim a nyini.” (Yeezu a weeni ba wieŋa de ayen ŋa sak ba ate ba kan ŋman a ta kisita ale ŋandiinta.) ");
INSERT INTO bwu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Wa ŋman weeni ba ayen, “Wie ŋaai ale a nyini nuru sunum po a nyini la, ale a te wa daŋta. ");
INSERT INTO bwu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Popola ŋaai ale bo nuruba suniima po la ale a basi ate ba a poli wabaata ale a basi ate ba a yaali nipooba ale nidɔaba, zueba, nuru kooroba, kaboŋ nyeerisa, butuom nyam, gaasa nyam, pimpaasima nyam, a tom tuim gbentisa, a de nyuri ale chaab, ale a le Naawen, kanjanta nyam, ale a tom betta tuima. ");
INSERT INTO bwu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Wabaataŋa de meena ale a nyini ba suniimaŋa po a nyini la, ale a kaasi ba.” ");
INSERT INTO bwu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yeezu a yaa basi dula jigini ale ge cheŋ Taaya ale Saidon tɛŋsaŋa po. Wa yaa cheŋ ga jo yeri dinyi po ayen wa suk wa dek ate waai a kan seba ayen wa bo dula, alege wa an jam baga a nya sukka jigiya. ");
INSERT INTO bwu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Nipɔk wanyi ale jam boro a yaa wom Yeezu wie. Nipowa kowa ale wa mawa a jam daa Juuba. Ba biak wa ka juijui ate ba a wi ayen Fonisia ate ka bo Siriya tɛŋka po la. Chichiribiok a yaa jam bo nipowa lie zuk po. Wa yaa wom Yeezu wari a yaa cheŋ wa jigi a ga kpi duna tɛŋ wa niŋ a saalim wa ayen wa yiak chichiribioku ate ku nyini wa leewa zukku po a nyini. ");
INSERT INTO bwu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yeezu a yaa tulisi nipowa ale wamagsini ayen, “Basi ate ba liŋ pa ŋandiinta a te bisa ate ba de chak. Ku an magsi ayen ba pa bisaŋa ŋandiintaŋa a te baasa ate si de.” ");
INSERT INTO bwu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nipowa a yaa weeni wa ayen, “M Nyɔnɔ, dii ate fi a weeni la ka wensie, alege baasaŋa a nyiem a de ka ŋandiin tii ate bisaŋa a de ale tali la.” ");
INSERT INTO bwu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yeezu a yaa ŋman weeni wa ayen, “Fi ale tulisi mu dii la ale soa ate mi a weeni fu ayen kuli yeri ale chichiribioku a poom basi fi leewa kama.” ");
INSERT INTO bwu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nipowa a yaa ale ga paari wa yenni la, wa yaa nya wa leewa ale wa dua wa goomu tiaka po. Chichiribioku a sum basi wa kama. ");
INSERT INTO bwu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yeezu a yaa basi Taaya tɛŋka ale ŋman pilim a jam va Saidon tɛŋka po a taam ga va Dekapolis wa po a taam cheŋ Galili mogi kpeeni. ");
INSERT INTO bwu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Wa ale ga paari dula la, nuruba a yaa ta nuru ate wa tue a kpari ate wa an baga a biisi nalimnyiini me. Ba yaa ta wa a jam Yeezu jigi a saalim wa ayen wa pa wa nisaŋa a vi wa nyiŋka ate wa nya nyiŋyɔgsa. ");
INSERT INTO bwu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yeezu a yaa yik wa a ta nyini nuru bɔanni po a taam nakpiak a yaa pa wa nandubsa siye a su nuruwa tueŋa po, ale ge a chesi tintueta a pa tiri nuruwa giŋgeluŋku. ");
INSERT INTO bwu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yeezu ale nyɛ dila a nueri la, wa yaa zak a nya wenŋmazuk a yaa ŋusi a weeni nuruwa ayen, “Efata.” Ku kiri ale, “Lagri.” ");
INSERT INTO bwu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Wa tueŋa a deri a wom ate wa giŋgeluŋku me a labri ate wa yaa baga a biisi nalimnyiini. ");
INSERT INTO bwu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yeezu a yaa weeni nuru baai ale ta wa a jam la bunyi dekki ayen ba kan weeni a sak waai dii ale nyɛ la, alege ba zɛri ale ŋmasi a jalisi wa a gum du ate nuruba yegayega a wom. ");
INSERT INTO bwu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ku yaa cha waai meena ate ba a weeni chaab ayen, “Nuruwa de a nyɛ wie meena ka nalimnyiini. Nya wa ale poom baga a nyɛ dii a tebi nuru waai tueŋa ale ka a wom ate wa an baga a biisi nalimnyiini la.” ");
INSERT INTO bwu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Da ale ŋman jam taam la, nuru bɔari yegayega a ŋman tigsi chaab a gilim Yeezu. Ba ale jam kan ŋman ta ŋandiinta ayen ba de la, Yeezu a yaa wi wa ŋaaŋviirima ate ba jam wa jigi ate wa yaa weeni ba ayen, ");
INSERT INTO bwu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“M jiirim a bo ale nuruma de, dii nyiŋ la ba ale bo ale mu daa ŋatawa de, alege ba ka ŋandiinta a de la. ");
INSERT INTO bwu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","M dan basi ate ba kuli ale kommu, ba le cha kama dii nyiŋ la ba kan ta pagrim a cheŋ paari ba yieŋa. Ba gela a nyini ka niŋniŋa a jam.” ");
INSERT INTO bwu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wa ŋaaŋviirima a yaa weeni ayen dela ka sagi po. “Ti le nya ŋandiinta ka be dela jigini ate ti paari nuruma de a soa nna?” ");
INSERT INTO bwu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yeezu yaa bek ba ayen, “Ka boan ŋandiinta ate ni tara?” Ba yaa tulisi wa ayen, “Ti ta ka borobotta tiyopoi.” ");
INSERT INTO bwu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Wa yaa weeni nuru bɔanni meena ayen ba kali tɛŋ. Ba yaa ale kali a nueri la, wa yaa pa borobottaŋa tiyopoiwa a yaa puusi a te Naawen ayen wa niak ŋandiintaŋa, a yaa ale ge a ŋmari te wa ŋaaŋviirima ayen ba pa chari nuru bɔanni. Ba yaa pa chari ba meena. ");
INSERT INTO bwu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wa ŋaaŋviirima me a jam ta juma maga dega ale ba. Yeezu a yaa tuesi ŋa a ŋman puusi a te Naawen ayen wa niak ŋa a yaa ale ge a pa te wa ŋaaŋviirima ate ba pa chari nuru bɔanni ŋmani. ");
INSERT INTO bwu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Ba meena yaa ŋobi chak, ale ge ate Yeezu ŋaaŋviirima a pisi ŋandiin tii ale tali la a sueri busisa siyopoi. Baai ale jam de ŋandiintaŋa la, a jam ka nuruba tusa ŋanaansi. Ba ale nyɛ dila a nueri la, wa yaa basi ate nuru bɔanni meena a kuli. ");
INSERT INTO bwu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Wa ale wa ŋaaŋviirima deri jo ŋaaruŋ po nwuli a cheŋ ga paari tɛŋ kaai ate ba a wi ayen Dalimanuta la. ");
INSERT INTO bwu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisiima ba gela a yaa jam Yeezu jigi a deri ta nampaga ale wa. Ba jam a yaali ayen ba yik wa kama. Ba yaa weeni wa ayen wa nyɛ wakperikaliik ate ku sak ayen wa pagrimu a sum nyini ka Naawen jigi la. ");
INSERT INTO bwu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yeezu a yaa weeni ayen “Mm, ka boa ale soa ate jinla demma yaali ayen ba nya wakperikaliiga? Mi a weeni ni ka wensie, nama ale a yaali dii la, m kan te ate ni nya di.” ");
INSERT INTO bwu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Wa yaa basi ba ale ŋman ga jo ŋaaruŋku po ayen wa gaam a taam mogi kpeeni kauk kuŋkula. ");
INSERT INTO bwu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ba ale jam boro a gomsi ayen ba cheŋ dula la, Yeezu ŋaaŋviirima a yaa baŋ ba ŋandiintaŋa a basi ŋaaŋ. Boroboruk kunyi dekki ate ba jam pa nyo ŋaaruŋku po. ");
INSERT INTO bwu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yeezu a yaa weeni ba ayen, “Ni a limsi abe ni a kpesi ni dek ale Farisiima ale Naawa Ayerod dabintaŋa.” ");
INSERT INTO bwu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wa ale weeni dila la, ba yaa bek chaab ayen, “Ka tama ale kan ta ti boroboruku la ale soa ate wa a weeni dila?” ");
INSERT INTO bwu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yeezu a yaa seba dii ate ba jam a biisi la ate wa yaa bek ba ayen, “Ka boa ale soa ate ni a biisi ayen ni ka ŋandiinta? Nama an diem baga a miŋi? Ku a nyɛ ase ni tueŋa a diem kpari kama la. ");
INSERT INTO bwu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nama diem a nyɛ ase ka nuru baai ate Naawen biisi ba wie wa gbaŋka po dila po dila po la. Ni ta nina kama alege ni kan nya. Ni be ta tue me kama, alege ni kan womu. ");
INSERT INTO bwu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nama baga a teeri diipo ate mi pa borobotta tinuwa a ŋmari chari nuruba tusa ŋanuwa la? Boroboruk talaŋa a jam sueri ka busisa si dina?” Ba yaa ŋman weeni wa ayen, “Ti sueri ka busisa pi ale siye.” ");
INSERT INTO bwu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Wa ŋman bek ba ayen, “Mi ale pa borobotta tiyopoiwa a ŋmari chari nuruba tusa ŋanaansiwa la, boroboruk talaŋa a sueri ka busisa si dina?” Ba yaa ŋman weeni wa ayen, “Ti sueri ka busisa siyopoi.” ");
INSERT INTO bwu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Wa yaa ŋman bek ba ayen, “Nama an diem a miŋya?” ");
INSERT INTO bwu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ba yaa jam paari tɛŋ kaai ate ba a wi ayen Beteseida. Nuruba ba gela a yaa jam ta yio wanyi a jam Yeezu jigi a saalim wa ayen wa pa wa nisaŋa a tiri wa nyiŋka ate wa ninaŋa a lagri. ");
INSERT INTO bwu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yeezu a yaa yik nuruwa nisaŋa a ta wa a nyini tɛŋka po a nyini a yaa chesi tintueta basi nuruwa ninaŋa po ale ge pa wa nisimaŋa me a vi nuruwa zuk ale bek wa ayen, “Fi baga a nya jaabɔa?” ");
INSERT INTO bwu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nuruwa a yaa lagi wa ninaŋa ayen wa nya, wa yaa weeni Yeezu ayen, “Mi a nya ka nuruba m niŋ ase tiisa la ate ba nyiem a cheŋ.” ");
INSERT INTO bwu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yeezu a ŋman pilim pa wa nisimaŋa a tiri nuruwa ninaŋa, ate ŋa yaa lagri ate wa yaa nya nna cheri. ");
INSERT INTO bwu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yeezu a yaa weeni wa ayen, “Kuli yeri, kan cheŋ tɛŋka po.” ");
INSERT INTO bwu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ku ŋaaŋnyiŋ Yeezu ale wa ŋaaŋviirima a yaa cheŋ tɛŋfiik sii ale jam gilim tɛŋ kaai ate ba a wi ayen Siizariya Filipai la. Ase ba ale jam bo siuku po a cheŋ la, wa yaa bek ba ayen, “Nuruba a weeni ayen mi ka wana?” ");
INSERT INTO bwu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ba yaa weeni wa ayen, “Ba gela ayen fi ka Jɔɔn waai ale jam a te nuruma soka la, ba gela me ayen fi ka Elaja. Mbala me a weeni ayen fi ka Naawen biisiteerɔma po wanyi.” ");
INSERT INTO bwu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Wa yaa ŋman bek ba ayen, “Nama dek a weeni ayen mi ka wana?” Piita a yaa weeni wa ayen, “Fi ale Kirisitawa waai ate Naawen a jam weeni ayen wa le tom wa ate wa jam vari nuruba a basi la.” ");
INSERT INTO bwu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yeezu a yaa kaam ba ayen, “Ni kan weeni dila a sak waai ya.” ");
INSERT INTO bwu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Dula jigini Yeezu a yaa pilim jam boro a sak ba ayen, “Nuruba le basi ate Mi Saalobiika a nam nna yegayega. Juuma kpaŋŋa ale Juuma Puusika Yenni kpaŋŋa ale Juuma Sinsaŋŋa sagrɔma ale zɛri mu, abe ba basi ate nuruba ko mu alege daa ŋata a dan paari m le yiri kum po.” ");
INSERT INTO bwu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wa biisi dila a lagri kama ayen ba miŋ chak. Piita ale wom wa wieŋa la, wa yaa yik wa a ta wa taam nakpiak a tɔariŋ wa wa ale weeni dila la nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yeezu a yaa gisi nya wa ŋaaŋviirima meena ale ge a yaa tɔariŋ Piita ayen, “Cheŋ du mi niŋ, Sitaana nyɔnɔ. Fi ale a biisi dii la an nyini daa Naawen jigiya, alege di nyini ka nurubiik jigi.” ");
INSERT INTO bwu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yeezu a yaa wi wa ŋaaŋviirima ale nuru bɔanni ate ba jam wa jigi ate wa yaa weeni ba ayen, “Nuru a dan a yaali ayen wa va mi ŋaaŋ, basi ate wa liŋ zɛri wa dek yaalika abe wa gomsi wa dek a magsi kum abe wa jam va mu. ");
INSERT INTO bwu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nuru waai nina a dan muni ayen wa vari wa dek nyuvuri a basi, kula nyɔnɔwa le jogi di kama, alege nuru waai a dan jogi wa nyuvuri wa le va mi la nyiŋ ale wa siaka ale Naawen wamaŋsaŋa nyiŋ, kula nyɔnɔwa le vari di a basi. ");
INSERT INTO bwu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Dila nyiŋ la, ka boan jaab nyuenta ate nuru le nya ase wa nin nya tɛŋzuk meena masimu ale ge jogi wa nyuvuriya? ");
INSERT INTO bwu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Jaab karo ate kula nyɔnɔwa le pa tagri a nya wa nyuvunni ase wa nin jogi di. ");
INSERT INTO bwu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yɔgyɔgla de, nama boro ale ka nuru baai ale ta gaasa ale a zɛri Naawen siuku vaka la. Da yeŋ po, Mi Saalobiika, le ŋman pilim jam tɛŋzuk de ale m Kowa nyagsika ale sabiilo welensaŋa. Nuru baai ale va mi la po wanyi, abe dan a chali chivie ale mi vaka yɔgyɔgla de, mi me a dan jam m le zɛri kula nyɔnɔwa.” ");
INSERT INTO bwu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yeezu a yaa weeni ba ayen, “Wensie ate mi a weeni ni, nama baai ale bo dela la, gela a kan kpi ase ka ba nin nya Naawen naamu ale bu cheena ale pagrim.” ");
INSERT INTO bwu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Daa ŋayuebi ale jam taam la, Yeezu a yaa wi Piita ale Jeemsi ale Jɔɔn a ta ba jueli guuk kpioŋ kunyi zuk ba dek ba nyiini. Ba ale jam bo dula jigini la, Yeezu a yaa deri tagri ba niŋ. ");
INSERT INTO bwu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Wa gattaŋa me a tagri ale peenti a nyagsi nna kpelimkpelim. Nuru waai a jam ka a baga a nyɛ ate ti a peenti ale a nyagsi dila. ");
INSERT INTO bwu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ba yaa nya Elaja ale Moosis ale ba boro a biisi ale Yeezu. ");
INSERT INTO bwu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Piita a yaa weeni Yeezu ayen, “Sagrɔ, tama ale bo dela la ku nala kama. Basi ate ti pili viita tita a te ni ate fi soa kunyi abe Moosis a soa kunyi abe Elaja me a soa kunyiwa.” ");
INSERT INTO bwu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Wa jam ze dii ate wa le weeni la, dii nyiŋ la wa ale mbala a jam a chali ka yɔgsum yegayega. ");
INSERT INTO bwu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Wein chiŋmari a yaa jam lik ba ate ba wom lueluk ale ku nyini chiŋmanni po a weeni ba ayen, “Mi be kaai ate m sui a mariŋ la ale nna. Ni wom wa.” ");
INSERT INTO bwu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ba ale wom a nueri la, ba yaa gisi nya ale nuru karo, ka Yeezu nyiini ale jam bo dula jigini ale ba. ");
INSERT INTO bwu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ba ale basi guuku zuk a siŋ la, Yeezu a yaa weeni ba ayen, “Dii ate ni poom nya la, ni kan weeni a sak waaiya, ase ka dai dii dai ate Mi Saalobiika a yiri kum po la.” ");
INSERT INTO bwu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ba yaa siak wa ale weeni dii la ale pa ŋa a nyo ba suniima po ale a bek chaab ayen, “Wa kummu po yirika kiri ale boa?” ");
INSERT INTO bwu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ba yaa bek Yeezu ayen, “Ka boa ate Juuma Sinsaŋŋa sagrɔma a weeni ayen ka Naawen biisiteerɔwa Elaja le wa liŋ jam abe wa ge ate Kirisitawa a jamu?” ");
INSERT INTO bwu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Wa yaa weeni ba ayen, “Ku ka wensie, Naawen gbaŋka sum weeni dila kama ayen Elaja le wa liŋ jam a gomsi jaab buuri meena. Jɔɔn waai ale jam a te nuruma soka la ale jam sum jam ate ku sak ayen Elaja ale la a jamu. Nuruba abe nyɛ wa dii ate ba a yaali la kama. Nyaku de abe a sak kama ayen Naawen ale ŋmarisi dii wa gbaŋka po la ka wensie. Naawen gbaŋka abe weeni kama ayen dai dii dai ate Mi Saalobiika le jam la, nuruba le zɛri mu a basi ate m namu nna yegayega.” ");
INSERT INTO bwu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ba ale jam biisi ale chaab a nueri la, ba yaa jam gum chaab ale wa ŋaaŋviirima mbala ate nuru bɔari yegayega a za gilim ba ate Juuma Sinsaŋŋa sagrɔma ba gela a yaa ta nampaga ale ba. ");
INSERT INTO bwu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nuru bɔanni ale jam nya Yeezu la, ku yaa cha ba nna yegayega ate ba yaa chali ga tu wa a puusi wa. ");
INSERT INTO bwu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yeezu a yaa bek wa ŋaaŋviirima ayen, “Ka boa ate nama ta nampaga ale sinsaŋŋa sagrɔma?” ");
INSERT INTO bwu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nuru wanyi yaa jam bo nuru bɔanni po a weeni wa ayen, “Sagrɔ, chichiribiok ale bo m biik zuk po ate wa an baga a biisi, wa be kan wom me. ");
INSERT INTO bwu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Chichiribioku a dan ga yiri, ku nyiem a pa wa kama a kasim a fobi tɛŋ diipo meena ate tintupuuk a nyini wa nɔanni po a nyini ate wa a ŋobi wa nyinaŋa ate wa nyiŋka me a deri. M be ta wa jam ka fi jigi alege fi poom karo ate m yaa saalim fi ŋaaŋviirima ayen ba yiak chichiribioku wa zukku po a basi alege ba an baga a nyeya.” ");
INSERT INTO bwu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yeezu a yaa chiem a weeni wa ŋaaŋviirima ayen, “Oo, nama ka siaka. Nama a yaali ayen mi bo ale ni a paari ka dimpo? Mi le ta suduŋni ale ni a paari ka dimpo?” Wa yaa ŋman weeni biika kowa ayen, “Ta biika jam dela.” ");
INSERT INTO bwu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wa yaa ta wa a jam Yeezu jigi. Chichiribioku ale ga nya Yeezu la, ku yaa deri yiri nna yegayega a pa biika a fobi tɛŋka ate wa yaa a bilim ate tintupuuk a nyini wa nɔanni po a nyini. ");
INSERT INTO bwu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yeezu a yaa bek biika kowa ayen, “Chichiribioku ale jo fi biika la, ka benaŋa dina?” Wa kowa a yaa weeni Yeezu ayen, “Ku jo wa ka wa bifiik po. ");
INSERT INTO bwu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Dai po dai po ku a yuk wa kama a lonsi bolim po ale nyiam po ayen ku ko wa. Fi dan baga a maari ti, be maari ti.” ");
INSERT INTO bwu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yeezu a yaa ŋman bek wa ayen, “Ka boa ate fi a begi ayen ase m nin baga? Wie meena a baga a nyɛ kama a te nuru waai ale ta siaka la.” ");
INSERT INTO bwu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Biika kowa a yaa deri kaari a weeni ayen, “Mi ta siaka kama, alege m siaka an soa diiya. Maari mu ate m ta siaka a gum du.” ");
INSERT INTO bwu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ba ale jam boro a biisi ale chaab la, nuru bɔari yegayega a yaa deri chali cheena Yeezu jigi. Wa ale nya ba la wa yaa deri weeni chichiribioku ayen, “Fi, chichiribiok kuui ale basi ate biika de an baga a biisi ale kan wom la, mi a biisi ale ka fi. Nyini biika jigi a nyini abe fi kan ŋman jo a bo ale wa.” ");
INSERT INTO bwu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Chichiribioku a yaa deri kaari nna yegayega a yuk wa a lonsi ale ge yaa nyini biika nyiŋka po a nyini, ale ge ate wa dua ase wa kpi la ate nuruba yegayega a jam a weeni ayen, “Wa kpi kama.” ");
INSERT INTO bwu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yeezu a yaa yik wa nisaŋa a zak wa a zaani ŋmai. ");
INSERT INTO bwu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yeezu ale wa ŋaaŋviirima ale cheŋ a ga jo dɔk po ba dek ba nyiini la, ba yaa bek wa ayen, “Ka boa ale soa ate tama an baga a yiak chichiribioku ate ku a nyini biika jigiya?” ");
INSERT INTO bwu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Wa yaa weeni ba ayen, “Chichiribioku de choawa ni dan kan puusi a te Naawen nalimnyiini, ni an baga a yiak ate ku a nyini.” ");
INSERT INTO bwu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yeezu ale wa ŋaaŋviirima yaa basi dula ale wa cheŋ taam Galili tɛŋka po. Ba yaa ale a cheŋ la, Yeezu a kan jam a yaali ayen nuru seba ba ale a cheŋ juijui la, ");
INSERT INTO bwu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","dii nyiŋ la wa a sak ka wa ŋaaŋviirima dii le cheena ayen di nyɛ la. Wa yaa weeni ba ayen, “Nuruba le jam yik Mi Saalobiika, a ta ga nyo nuru baai ale ba ko mu la nisa po, alege daa ŋata a dan paari, m le yiri kum po.” ");
INSERT INTO bwu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wa ale weeni dila la, ba an jam miŋ dii ate wa a biisi la kiriya, alege ba jam a chali ka yɔgsum ale wa bekka. ");
INSERT INTO bwu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ba yaa jam paari Kapernaum tɛŋka po a ga jo yeri po. Yeezu a yaa bek ba ayen, “Ti ale poom bo siuku po a cheena la, ka boan jaab nampaga ate nama poom a nagi?” ");
INSERT INTO bwu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Alege ba an weeni wa wariya, dii nyiŋ la ba ale poom bo siuku po la, ba ta ka nampaga ase ka ba wana ale wa chim kpagi a gaam ba meena. ");
INSERT INTO bwu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yeezu a yaa kali tɛŋ a wi wa ŋaaŋviirima pi ale bayewa ate ba jam wa jigi ate wa yaa weeni ba ayen, “Ni basi niŋ dekka yaalika. Nuru waai ale a yaali ayen wa chim niŋ deero la, ku a fe ate wa pa wa dek a zaani ŋaaŋ abe wa chim ba meena tomteerɔ.” ");
INSERT INTO bwu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Wa yaa yik biik wanyi a ta jam zaani ba sunsuŋ a pa wa nisaŋa a gbaari wa ale weeni ba ayen, ");
INSERT INTO bwu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Nuru waai ale a tuesi biik ase bisaŋa de wanyi mi nyiŋ la, ka mi ale la ate wa a tuesi. Nuru waai abe ale a tuesi mi la, wa kan tuesi ka mi nyiini alege wa a tuesi ka waai dek ale tom mu la me.” ");
INSERT INTO bwu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Da yeŋ ate Jɔɔn a yaa weeni Yeezu ayen, “Sagrɔ, tama nya ka nuru wanyi ale wa pa fi yonni nyiŋ a yiak chichiribaata nuruba zuima po a basi, ate tama a yaa weeni wa ayen wa basi, dii nyiŋ la wa daa tama po wanyi.” ");
INSERT INTO bwu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yeezu a yaa weeni ba ayen, “Ni dan ŋman nya wa ase dila la, ni basi wa abe ni kan weeni wa ate wa basi. Nuru waai a dan pa mi yonni nyiŋ a baga a tom wakperikaliik kula nyɔnɔwa a kan ŋman baga a kpabi kaasi mi yonni. ");
INSERT INTO bwu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nuru waai ale kan ta chaab ale ti la, kula nyɔnɔwa va ti kama. ");
INSERT INTO bwu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Wensie ate mi a weeni ni, nuru waai a dan nyɛ nyiam fiifiiga a te ni, ni ale ka mi ŋaaŋviiriba la nyiŋ, Naawen le tuni wa. ");
INSERT INTO bwu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Nuru waai abe dan nyɛ ate bisaŋa de wanyi a jok wa siaka, ku le zunchoŋ kama a te kula nyɔnɔwa ase ba nin pa ni kpeeni a bobi yik wa ŋiri a ta wa ga yuk basi mogi kpeeni nyiamu po ate wa kpi. ");
INSERT INTO bwu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nuru waai nisima a dan a nyɛ ayen wa jok wa siaka, kula nyɔnɔwa a gebi ni sila a basi, dii nyiŋ la, ku zunchoŋ kama ate kula nyɔnɔwa nya Naawen nyuvuri dii ale kan a kpeglim la ale ni yeŋ a gaam wa nin ta nisima siye ale ge cheŋ ninam jigi, juijui ate bolim boro a kan maara kpi la. ");
INSERT INTO bwu_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Nanzue ŋaai ale bo dula a de ba la a kan maari a kpi. Bolim buui me ale bo dula a de la a kan maari a kpimsi. ");
INSERT INTO bwu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nuru waai naŋ a dan a nyɛ ayen wa jok wa siaka, kula nyɔnɔwa a gebi naŋ kala a basi, dii nyiŋ la, ku zunchoŋ kama ate kula nyɔnɔwa nya nyuvuri dila ale naŋ yeŋ a gaam wa nin ta naŋsa siye ale ge cheŋ ninam jigi. ");
INSERT INTO bwu_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Nanzue ŋaai ale bo dula a de ba la a kan maari a kpi. Bolim buui me ale bo dula a de la a kan maari a kpimsi. ");
INSERT INTO bwu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nuru waai me num a dan a nyɛ ayen wa jok wa siaka, kula nyɔnɔwa a yeeri num bula a basi, dii nyiŋ la, ku zunchoŋ kama ate kula nyɔnɔwa jo Naawen Naamu po ale num bunyi a gaam wa nin ta nina ŋaye ale ge cheŋ ninam jigi. ");
INSERT INTO bwu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nanzue ŋaai ale bo dula a de ba la a kan maari a kpi. Bolim buui me ale bo dula a de la a kan maari a kpimsi. ");
INSERT INTO bwu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Ase dila po dila po ate ba jam pa yesa a nyo ŋanta baai ate ba pa a kaab Naawen, ayen ŋantaŋa chim ŋan welensa la, ku be le nyɛ ka dila ate waai meena a va bolim po a nyini abe wa ge nya welensa. ");
INSERT INTO bwu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yesa a masa kama. Yesaŋa masimu a dan jam nueri, ni le nyɛ ka se a ŋman te si masimma? Ase yesa ale a te jenta masim dii la, ku a fe kama ate nama dek meena a ta nyɛ magsika ale chaab ate ni boro ale masim.” ");
INSERT INTO bwu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yeezu a yaa basi dula jigini ale ge va Judia tɛŋka po a taam paari Jodan benni kauk kuŋkula. Nuru bɔari yegayega a yaa tigsi chaab a jam wa jigi ate wa yaa sak ba ase wa nyiem ale poom a sak ba dii la. ");
INSERT INTO bwu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farisiima ba gela a yaa jam wa jigi ayen ba choa wa noai a nya. Ba yaa bek wa ayen, “Ti Sinsaŋŋa a siak ayen nuru a basi wa powa?” ");
INSERT INTO bwu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yeezu a yaa bek ba ayen, “Moosis a sak ni ka se?” ");
INSERT INTO bwu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ba yaa tulisi wa ayen, “Wa sak ti kama ayen nuru waai a dan a yaali ayen wa basi wa pɔk, ku a fe ate wa ŋmarisi gbaŋ a te nipowa ate ku a sak waai meena ayen wa basi wa kama.” ");
INSERT INTO bwu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yeezu a yaa weeni ba ayen, “Moosis a sak ni kama, ayen ni a va siuk kula dii nyiŋ la, ni tue kan wom. ");
INSERT INTO bwu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","8","Alege ba ŋmarisi Naawen gbaŋka po ayen, ku piilimka po ate Naawen a nyɛ tɛŋka meena la, ‘Wa nyɛ ŋanta meena ka jaab duok ale jaab sari, nidɔa ale nipɔk,’ a yaa weeni ayen, ‘Ku ka wamaŋ ate nidɔa a basi wa ko ale wa ma, ale ge a ga faari nipɔk ate bala bayewa a chim bunyi, ba noa bayewa a ŋman daa nuruba baye, ba ka bunyi.’ ");
INSERT INTO bwu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Dila nyiŋ la, baai ate Naawen a basi ba ate ba chim bunyi la, nuru kan poori ba.” ");
INSERT INTO bwu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yeezu ale wa ŋaaŋviirima a yaa ŋman ga jo yeri po ate ba bek wa dii ate wa poom weeni ba la kiri. ");
INSERT INTO bwu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Wa yaa weeni ba ayen, “Nuru waai a dan basi wa pɔk ale ge a ŋman faari wa choa, wa nyɛ wa powa a kaasi kama. Wa nyɛ ka kaboŋ. ");
INSERT INTO bwu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nipɔk waai me a dan basi wa chora ale ge a ga yali nidɔa wa chora, wa me a nyɛ wa chorowa a kaasi kama. Wa nyɛ ka kaboŋ.” ");
INSERT INTO bwu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Dula jigini nuruba gela a yaa pa bisa a ta ba jam Yeezu jigi ayen wa te ba niaka. Ba ale nyɛ dila la, wa ŋaaŋviirima a yaa tɔariŋ ba. ");
INSERT INTO bwu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yeezu ale ga nya dii ate ba nyɛ la, wa sui a yaa jam a puuri nna yegayega ale wa ŋaaŋviirima ate wa yaa weeni ba ayen, “Ni te bisaŋa siuk ate ba jam mi jigi. Ni kan yiak ba, dii nyiŋ la bala chaab ale ba jo Naawen Naamu po. ");
INSERT INTO bwu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Wensie ate mi a weeni ni, ayen nuru waai ale kan pa wa dek a chim biik ayen wa nya Naawen Naamu la, wala choa kan tabi naŋ bu po.” ");
INSERT INTO bwu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yeezu a yaa pa bisaŋa wanyi wanyi a nyo wa nigoruk po a yaa pa wa nisaŋa a ji ba zuima a niak ba. ");
INSERT INTO bwu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yeezu ale basi dula jigini ale a cheŋ la, nuru wanyi a yaa chali jam tu wa a kpi duna tɛŋ wa niŋ a bek wa ayen, “Sagrɔ maŋŋa, mi le nyɛ ka se ate m nya nyuvuri dii ale kan ta kpeglimka la?” ");
INSERT INTO bwu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yeezu a yaa bek wa ayen, “Ka boa ate fi a wi mu ayen nuru maŋŋa? Nuru waai karo a chim nuru maŋ ase ka Naawen dek nyiini. ");
INSERT INTO bwu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Fi poom seba Moosis Sinsaŋŋa kama, yaa boa? Naawen a weeni ayen kan ko nuru, kan nyɛ kaboŋsa, kan zu, kan chim seero waai ale a velim la, kan a yaali degaamka. Ku a fe ate fi zuli fi ko ale fi ma.” ");
INSERT INTO bwu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nuruwa yaa weeni wa ayen, “Sagrɔ, mi kasim va Sinsaŋŋa de meena kama a ta nyini m biik po a jam paari jinla.” ");
INSERT INTO bwu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yeezu yaa nya wa ate wa jiirim dari wa ate wa weeni wa ayen, “Wa yeŋ dekki ale tali fi jigi. Cheŋ a ga pa fi ŋantaŋa meena a da a tuesi ligraŋa a te niwomma. Fi dan nyɛ dila ale ge jam va mi, fi le jigsi wenŋmazuk.” ");
INSERT INTO bwu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yeezu ale weeni wa dila la wa sui yaa deri kaasi ate wa yaa deri cheŋ ale sukaasuŋ dii nyiŋ la wa jam ka ŋanta nyɔnɔ a kan siak wa ŋantaŋa nyiŋŋa. ");
INSERT INTO bwu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yeezu yaa gisi nya wa ŋaaŋviirima meena ale weeni ba ayen, “Ku tua kama ate ŋanta nyam a baga a jo Naawen naamu po.” ");
INSERT INTO bwu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wa ale weeni dila la ku yaa cha ba. Wa yaa ŋman weeni ba ayen, “M bisa, ku sum tua kama ate saalo a baga jo Naawen naamu po. ");
INSERT INTO bwu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ku ka moali ate laalaakomi a va garupein num po a nyini, a gaam jigsiro a nin wa jo Naawen naamu po.” ");
INSERT INTO bwu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yeezu ale weeni ba dila la, ku yaa cha ba. Ba yaa weeni chaab ayen, “Ku be dan ka dila, ka wana le wa baga nya varibasika?” ");
INSERT INTO bwu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yeezu a yaa nya ba a weeni ayen, “Ku tua kama nurubiik jigi, alege ku ka moali Naawen jigi, dii nyiŋ la Naawen baga wie meena a nyɛ kama.” ");
INSERT INTO bwu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Dula jigini Piita a yaa weeni wa ayen, “Nya, tama basi ka ti ŋanta meena ale jam va fu.” ");
INSERT INTO bwu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yeezu a yaa ŋman weeni ba ayen, “Wensie ate mi a weeni ni, nuru waai ale basi wa yeri ale wa ko ale wa ma ale wa suaata ale wa tɔaba ale wa bisa ale wa kadugsa, mi ale Naawen wamaŋsaŋa nyiŋ la, ");
INSERT INTO bwu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","wa le nya ŋanta ale nuruba nna yegayega jinla a gaam baai meena ate wa basi la. Wa le ŋman nya yie, ale maba ale suaata, ale tɔaba, ale bisa ale kadugsa, alege wa le nya ninam me nna yegayega abe chum diipo wa yaa nya nyuvuri dii ale kan ta kpeglimka la. ");
INSERT INTO bwu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Baai ale de niŋ la yega ale jam wari ŋaaŋ ate baai ale wari ŋaaŋ la jam de niŋ.” ");
INSERT INTO bwu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ba ale jam bo siuku po a cheŋ Jerusalem tɛŋka la, Yeezu a yaa de ba niŋ ate ba a cheŋ. Baai meena ale jam va wa la, a jam a chali ka yɔgsum. Wa yaa poori wa ŋaaŋviirima pi ale bayewa a weeni ba dii ate nuruba ayen ba nyɛ wa la. ");
INSERT INTO bwu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Wa yaa weeni ba ayen, “Ni wom nalimnyiini. Ti dan paari Jerusalem, nuruba le jam yik Mi Saalobiika, a ta mu cheŋ a ga nyo Juuma Puusika Yenni kpaŋŋa ale Juuma Sinsaŋŋa sagrɔma nisima po. Ba le bo m kum buusa abe ba ta mu a ga nyo baai ale kan daa Juuba la nisima po. ");
INSERT INTO bwu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ba le la mu abe ba chesi tintueta a basi m nyiŋ, a nak mu abe ba yaa ko mu. Daa ŋata a dan paari mi le yiri kum po.” ");
INSERT INTO bwu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Dula jigini Zebedi bisaŋa Jeemsi ale Jɔɔn, a yaa jam Yeezu jigi a weeni wa ayen, “Ti Sagrɔ, ti a yaali ayen ti saalim fu kama ate fi nyɛ wari a te ti.” ");
INSERT INTO bwu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Wa yaa bek ba ayen, “Ka boa ate nama a yaali ayen mi nyɛ a te ni?” ");
INSERT INTO bwu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ba yaa weeni wa ayen, “Fi dan jam chim naab a soa nuru meena zuk a nya, ti a yaali kama ayen fi basi ate ti wanyi a kali fi juga, wanyi me a kali fi gala.” ");
INSERT INTO bwu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yeezu a yaa weeni ba ayen “Nama ze dii ate ni a bek la. Ninam buui ate mi ayen m nam la, nama le baga a maa nam bu?” ");
INSERT INTO bwu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ba yaa weeni wa ayen, “Ti le baga a maa nam.” Yeezu a yaa ŋman weeni ba ayen, “Wensie, ninam buui ate mi ayen m nam la, nama me le baga a nam kama. ");
INSERT INTO bwu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Alege mi ka siuk a lueri baai a le ba kali mi juga ale mi gala la. Ka Naawen le wa pa dula a te baai ate wa gomsi magsi ba la.” ");
INSERT INTO bwu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wa ŋaaŋviirima mbala piwa ale wom Jeemsi ale Jɔɔn ale bek Yeezu dii la, ba sue a yaa puuri nna yegayega ale ba. ");
INSERT INTO bwu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yeezu yaa wi ba ate ba jam tigsi chaab wa jigi ate wa yaa weeni ba ayen, “Tɛŋzuk de nalima ta pagrim ba nuruma zuk kama a nyɛ ba ale a yaali dii la. Ba kpaŋŋa me ta pagrim ba zuk kama. ");
INSERT INTO bwu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Alege ku an magsi ayen ku chim dila nama jigiya. Nuru waai a dan a yaali ayen wa chim nama kpagi, ku a fe ate wa chim ni meena tomteerɔ. ");
INSERT INTO bwu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nuru waai a dan a yaali ayen wa chim nama kpagi, ku a fe ate wa chim nama meena yomo. ");
INSERT INTO bwu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mi Saalobiika, an jam ayen m gisi ka nuruba ate ba a tom a te mu. M jam ayen m tom a te ka tɛŋzuk demma meena. M dan nyɛ dila, m le zaani nuruba yegayega naŋkula po a kpi a te ba a vari ba a basi.” ");
INSERT INTO bwu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ba yaa jam paari tɛŋ kanyi ate ba a wi ayen Jeriko, ate nuruba yegayega a yaa tigsi chaab a jam Yeezu jigi. Ba le jam a basi dula jigini ale a nyini la, ba yaa nya yio wanyi ale wa kala siuku noai a juisi. Wa yoi jam ale Baatimiusi. Ku kiri ale Timiusi biik. ");
INSERT INTO bwu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wa ale wom ayen ka Yeezu Nazaret denowa ale a taam la, wa yaa kaari a wi wa ayen, “Yeezu, fi waai ale ka naawa Deevid ŋaaŋbiik la, ta jiirim ale mu abe fi maari mu.” ");
INSERT INTO bwu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nuruma yega a yaa weeni wa ayen wa goori wa wanni, alege wa zɛri ale a kaari nna yegayega, a gaam wa ale poom a kaari dii la a ŋman weeni wa ayen, “Yeezu, fi waai ale ka naawa Deevid ŋaaŋbiik la, ta jiirim ale mu abe fi maari mu.” ");
INSERT INTO bwu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yeezu a yaa zaani a weeni ba ayen ba wi wa ate wa yiri a jam wa jigi. Ba yaa weeni wa ayen, “Te fi sui peenti abe fi yiri jam, dii nyiŋ la wa a wi fu kama.” ");
INSERT INTO bwu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yiowa a yaa yeeri wa kasaauku a dueni, ale yiri a zaani ŋmai a cheŋ ga Yeezu jigi. ");
INSERT INTO bwu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yeezu a yaa bek wa ayen, “Fi a yaali ayen mi nyɛ ka boa a te fu?” Wa yaa weeni wa ayen, “Sagrɔ, mi a yaali ayen fi nyɛ kama ate m ninaŋa a lagri a te mu.” ");
INSERT INTO bwu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yeezu a yaa weeni wa ayen, “Be cheŋ. Fi ale ta siaka ale mu dii la a basi kama ate fi ninaŋa a lagri.” Wa ninaŋa yaa deri lagri ate wa yaa va Yeezu a cheŋ. ");
INSERT INTO bwu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ba yaa jam paari tɛŋfiik sii ate ba a wi ayen Betfaaji ale Betani ale guuk kuui ate ba a wi ayen Olivi guuk la. Tɛŋsaŋa ale guuku a jam mɔata ka Jerusalem tɛŋka. Yeezu a yaa wi wa ŋaaŋviirima po baye a weeni ba ayen, ");
INSERT INTO bwu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Ni cheŋ a ga jo tɛŋfiik kaai ale bo ni niŋ la. Ni dan deri ga jo dula, ni le nya bompaalik ate ba bobi ka zaani. Nuru an diem a do ka nyaya. Ni foli ka a ta jam te mu. ");
INSERT INTO bwu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ni dan boro a foli ka, ate nuru bek ni dii nyiŋ ate ni a foli ka la, ni weeni wa ayen ka Nyɔnɔwa ale a yaali ka. Wa be dan nueri ale ka wa le ŋman basi ate ba ta ka a jam nwuli.” ");
INSERT INTO bwu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ba yaa cheŋ a ga nya bompaalik ale ka bobi za yeri nansiuŋ noai ate ba yaa foli ka. ");
INSERT INTO bwu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nuru baai ale jam za dula jigini la, a yaa nya ba a bek ayen, “Ka boa ale soa ate nama a foli ka?” ");
INSERT INTO bwu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ba yaa weeni ba dii ate Yeezu a poom weeni ba la, ate nuruma a yaa basi ate ba foli ka a ta cheŋ ga te wa. ");
INSERT INTO bwu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ba yaa ta bompaalika a ga te Yeezu, a yaa yeeri ba gattaŋa a pa vi bompaalika chiaka zuk ate Yeezu a yaa jueli a kali. ");
INSERT INTO bwu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nuruba yegayega a yaa jam pa ba gattaŋa a pati siuku niŋ ayen Yeezu a ta wa bonika a cheŋ va ti zuk a taam. Ba gela me a cheŋ siuku nakpiak a ga che tiisa vaata a ta jam pati siuku niŋ. ");
INSERT INTO bwu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ba ale jam bo siuku po a cheŋ la baai ale jam de niŋka la, ale baai me ale jam bo ŋaaŋka la, meena a yaa zuli wa a kaari ayen, “Naawen vari ti a basi. Naawen niak waai ale cheena Nyɔnɔwa yonni nyiŋ la. ");
INSERT INTO bwu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Naawen niak waai ale cheena ayen wa soa ti kokpieŋka Deevid naam buui ale cheena la. Fi, Naawen waai ale bo wenŋmazuk la, a vari ti a basi.” ");
INSERT INTO bwu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yeezu ale jam paari Jerusalem tɛŋka la, wa yaa cheŋ ga jo Juuma Puusika Yenni po a nyiem a nya jaab buuri meena ale bo di po la a yaa ale ge a ŋman nyini. Yeezu ale wa ŋaaŋviirima an jam bo dula jigini a beniya, dii nyiŋ la, wenni a jam a siŋ kama. Ba yaa basi dula jigini ale ŋman cheŋ Betani. ");
INSERT INTO bwu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Vari ale jam veenti la, ba yaa ŋman yiri a basi Betani ale nyini. Kom a yaa jam ta Yeezu. ");
INSERT INTO bwu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Wa yaa nya kiŋkaŋ a za niŋniŋ ate vaata a lik ka. Wa yaa cheŋ ga paari ka tɛŋ ayen wa nya ase ka ta moota ya ate wa de, alege moota a jam ka ka zuwa. Ka jam ta ka vaata nyiini, dii nyiŋ la ku jam daa moota wenya. ");
INSERT INTO bwu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yeezu a yaa ka te kiŋkaŋka ayen, “A nyini jinla danni a ta a cheŋ diipo meena wuu, nuru a kan ŋman nya fi moota a de.” Wa ŋaaŋviirima a yaa wom dii ate wa weeni la. ");
INSERT INTO bwu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ba ale ŋman jam paari Jerusalem tɛŋka la, Yeezu a yaa ŋman ga jo Juuma Puusika Yenni po. Nuruba ale jam bo di po a gerimu ale chaab. Wa yaa yiak ba meena ate ba nyini dula jigini a nyini, a zak nuru baai ale jam ta ligraŋa a tagri la teebulitaŋa a tulim kpib, a tusi baai ale ta nangbaŋsaŋa a da la zukpaglisaŋa me a lonsi. ");
INSERT INTO bwu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Wa an jam siak ayen waai a ŋman ta jaab a va Juuma Puusika Yenni po a taam nyini. ");
INSERT INTO bwu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ku ŋaaŋnyiŋ wa yaa ŋman sak nuruma ale bek ba ayen, “Nama ze dii ate ba ŋmarisi Naawen gbaŋka po dila po dila po la? Ba ŋmarisi ayen Naawen a weeni ayen, ‘Mi yenni ka tɛŋsa meena Puusika Yeri.’ Ba ŋmarisi nyaku de kama alege nama a pa di chim zueba sukka jigi.” ");
INSERT INTO bwu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yeezu ale ga weeni dila ate Juuma Puusika Yenni kpaŋŋa ale Juuma Sinsaŋŋa sagrɔma a ga wom la, ba yaa jam a gisi siuk ayen ba ko wa. Alege yɔgsum ale jam yik ba ale Yeezu ate ba an jam baga a nya siuk a tiri wa. Dii nyiŋ la wa sinsaŋŋa a jam cha nuruma kama. ");
INSERT INTO bwu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Junɔai ale jam paari la, Yeezu ale wa ŋaaŋviirima a yaa basi Jerusalem tɛŋka ale nyini a cheŋ. ");
INSERT INTO bwu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Vari ale ŋman veenti la, ba yaa va siuku a taam a yaa nya kiŋkaŋka ale ka kpi za. ");
INSERT INTO bwu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piita a yaa teeri Yeezu diem ale weeni dii la, a yaa weeni wa ayen, “Nya, kiŋkaŋ kaai ate fi diem a ka te ka la, ka meena a kpi kama.” ");
INSERT INTO bwu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yeezu a yaa weeni ba ayen, “Ni ta siaka ale Naawen. ");
INSERT INTO bwu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Wensie ate mi a weeni ni, waai ale ta siaka ale Naawen ale ka chichama ale sum siak ayen wa ale weeni dii la le nyɛ la, a baga a weeni gu kpioŋku kama ayen ku voori dula jigini a ga lo mogi kpeeni po ate Naawen sum nyɛ a te wa. ");
INSERT INTO bwu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Dila nyiŋ ni dan puusi a te Naawen a juisi jaab, ni ta siaka ayen ni nya jaamu kama ate Naawen yaa pa a te ni. ");
INSERT INTO bwu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Diipo meena ni daa ni puusi a te Naawen ni de niŋ a voŋ te baai ale nyɛ ni a kaasi la, abe ni ge a puusi a te Naawen waai ale bo wenŋmazuk la ate wa me a voŋ te ni. ");
INSERT INTO bwu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ni dan kan nyɛ dila, Naawen abe kan voŋ te nama me.” ");
INSERT INTO bwu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ba yaa ŋman jam Jerusalem tɛŋka po a ga jo Juuma Puusika Yenni po. Yeezu ale bo di po a nyiem la, Juuma Puusika Yenni kpaŋŋa ale Juuma Sinsaŋŋa sagrɔma ale tɛŋka kpaŋŋa meena a yaa tigsi chaab a jam wa jigi ");
INSERT INTO bwu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","a yaa bek wa ayen, “Ka boan pagrim ate fi ta a tom wieŋa de? Ka wana ale te fu siuk ate fi a nyiem a tom wieŋa de?” ");
INSERT INTO bwu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yeezu yaa weeni ba ayen, “Mi me le bek ni wari. M dan bek ni ate ni siak a tulisi mu, mi me le weeni sak ni pagrim buui ate mi ta tom wieŋa de la.” ");
INSERT INTO bwu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yeezu a yaa bek ba ayen, “Jɔɔn ale jam a te nuruba soka la, ka Naawen ale jam te wa pagrimu yaa ka nurubiiga?” ");
INSERT INTO bwu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wa le bek ba dila la, ba yaa ta nampaga ale chaab ayen, “Ti dan weeni wa ayen ka Naawen ale te wa pagrimu, wa le bek ti ayen, ‘Be ka boa ale soa ate ti an siak a te wa?’ ");
INSERT INTO bwu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ti be an baga a weeni me ayen ka nurubiik ale te wa pagrimu dii nyiŋ la, waai meena a seba wa ale jam ka Naawen biisiteerɔ la kama.” (Ate ba yaa chali yɔgsum). ");
INSERT INTO bwu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ba yaa weeni Yeezu ayen, “Tama ze.” Yeezu a yaa weeni ba ayen, “Mi me a kan weeni ni pagrim buui ate mi ta a tom wieŋa de la.” ");
INSERT INTO bwu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yeezu yaa magsi wamagsima a sak ba ayen, “Nuru wanyi ale jam boro a yaa kpa wa talim fiik, a vuk ti fiisa bu po ayen si a yoani. Wa yaa che daata a ti gilim bu meena ale ge gomsi jaab meena bu po a magsi. Wa ale nyɛ dila a ga nueri la, wa yaa yaali nuruba ayen ba a limsi bu abe ba a tom bu po ale ge nyiem a cheŋ tɛŋ m na niŋniŋa. ");
INSERT INTO bwu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wa talimu tiisaŋa yoanaŋa gbesika ale jam paari la, wa yaa tom wa tomteerɔma po wanyi ayen wa ga tuesi wa deka jigini a ta jam te wa. ");
INSERT INTO bwu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Wa ale ga paari dula la, nuruma a yaa yik wa a nak ale mini wa yoanaŋa ate wa pilim kuli niyaala. ");
INSERT INTO bwu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Talimu nyɔnɔwa yaa ŋman tom tomteerɔ wa choa ba jigi ate ba ŋman yik wa me a nak wa zukku, a pa wa a nyo chivie po. ");
INSERT INTO bwu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Wa yaa ŋman pilim tom wa choa ba jigi ate ba ko wala. Ba jam a nyɛ ka nuruba yega dila; a nak ba gela ale a ko ba gela me. ");
INSERT INTO bwu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Waai nyiini ale jam tali ayen wa tom la ale wa dek biika, waai ate wa mariŋ la. Wa yaa weeni wa dek ayen, ‘M dan tom m dek biika, ba le te wa zula.’ Wa yaa tom wa ate wa cheŋ ba jigi. ");
INSERT INTO bwu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Alege nuruma ale nya wa biika la, ba yaa weeni chaab ayen, ‘Biika kowa a dan kpi, wala le wa soa wa ŋantaŋa meena. Dila nyiŋ ni basi ate ti ko wa ate wa kowa chum dan kan boro abe tama soa wa ŋantaŋa.’ ");
INSERT INTO bwu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ba yaa yik wa a ko a vuuri wa a ta nyini talimu po a nyini peelim. ");
INSERT INTO bwu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Nama seba talimu nyɔnɔwa le wa nyɛ ba dii la? Wa le jam ko ba kama abe wa ŋman pa wa talimu a te nuru yonta.” ");
INSERT INTO bwu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Yeezu ale magsi wamagsini a nueri la, wa yaa bek ba ayen, “Nama an diem a karim nyaku de Naawen gbaŋka po? ‘Tain dii ate seeroma a zɛri ayen di an nala la, tain dila dek ale tulim a chim tain maŋ. ");
INSERT INTO bwu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Naawen ale nyɛ dila. Di ka wakperik ti jigi.’ ” ");
INSERT INTO bwu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yeezu ale weeni wieŋa de meena a ga nueri la, Juuma kpaŋŋa yaa deri miŋ ayen ka ba jigi ate wa pa wamagsini de a magsi dii nyiŋ la, ba zɛri wa kama. Ba yaa jam a yaali ayen ba yik wa, alege ba jam a chali nuru bɔanni yɔgsum, ate ba yaa jam basi wa ale ge cheŋ. ");
INSERT INTO bwu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Dula jigini Juuma kpaŋŋa a yaa tom Farisiima gela ale naawa Ayerod nuruma gela ayen ba ga choa Yeezu noai a wom. ");
INSERT INTO bwu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ba yaa jam weeni wa ayen, “Sagrɔ, ti seba ayen fi ka wensie nyɔnɔ. Fi niŋ ka dii meena ate nuruba a poli la po. Nuruba kpaŋta kan basi ate fi a tagri fi popola. Fi a sak Naawen wieŋa kama ale wensie. Ku magsi ayen ti tuni ti lampoowa a te nakpioŋku Siiza, yaa ku an magsi ya? Ti a tuni yaa ti kan a tuni?” ");
INSERT INTO bwu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yeezu a poom seba ba kiri kama ate wa yaa bek ba ayen, “Ka boa ate ni a yaali ayen ni choa m noai a wom? Ni ga ta ligbiri a jam te mu.” ");
INSERT INTO bwu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ba yaa ta ligbiri dinyi a jam te wa. Wa yaa bek ba ayen, “Ka wana zuk ale wa yoi ale dua ligni nyiŋŋa?” Ba yaa weeni wa ayen, “Ka nakpioŋku Siiza zuk ale wa yoi ale dua du.” ");
INSERT INTO bwu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Wa yaa weeni ba ayen, “Dan ka dila, ni be pa ŋanta baai ate Siiza a soa la a te wa, abe ni pa ŋanta baai me ate Naawen a soa la a te Naawen.” Ba ale wom dila la, ku yaa cha ba. ");
INSERT INTO bwu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Dula jigini nuru baai ate ba a wi ayen Sajusiba la, ba gela a yaa jam Yeezu jigi. Ba jam a poli kama ayen nuruba dan kpi, ba an ŋman baga a yiri kum po. ");
INSERT INTO bwu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ba yaa weeni Yeezu ayen, “Moosis a ŋmarisi wa gbaŋka po kama ayen, ‘Nuru waai a dan faari nipɔk ate wa ale wa an biak a nyaya ale ge ate wa kpi, ti a basi kama ate wa yuawa a faari nipowa a biak bisa a te wa ate wa yonni a kan be.’ ");
INSERT INTO bwu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nuruba bayopoi ale jam boro a chim suaata ate ba suok kpagini a faari nipɔk ate ba an biaya ale ge ate wa kpi. ");
INSERT INTO bwu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Waai ale pa saŋ la a yaa faari wa suoku powa, alege nipowa ale wa me an biak a nyaya ale ge ate wa me a kpi. Ba suok kuui ale pa saŋ butawa la me a nyɛ dila degadega. ");
INSERT INTO bwu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ba meena bayopoiwa a jam faari nipowa kama a taam tu, alege ba waai an biak ale wa ale ge kpi ya. Ku ŋaaŋnyiŋ ate nipowa me a yaa kpi. ");
INSERT INTO bwu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Yɔgyɔgla de ate nuruba bayopoiwa de meena a faari wa a nya la, dai dii dai ate nuruba meena ayen ba yiri kum po la, ka ba wana dek chekki ale wa soa nipowa de?” ");
INSERT INTO bwu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yeezu yaa weeni ba ayen, “Nama an diem a miŋ Naawen gbaŋka po wieŋa chagiya. Ka dila ale soa ate ni be siuku. Ni ze Naawen pagrimu me ale ka dii la. ");
INSERT INTO bwu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Dai dii dai ate nuruba meena ayen ba yiri kum po la, ba meena le tagri kama a nyɛ ase Naawen sabiiloma, baai ale bo wenŋmazuk la. Nidɔa a kan ŋman faari nipowa. Nipɔk me abe kan ŋman yali chora. ");
INSERT INTO bwu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Yɔgyɔgla de, a magsi chaab ale nuruba le ba yiri kum po la, nama an karim Moosis gbaŋka kauk kuui ale a biisi a magsi chaab ale ti fiika ate bolimu jam a nyɛ nna ase bu a de bu la? Dula jigini ku ŋmarisi kama ayen Naawen weeni Moosis kama ayen, ‘Wa ale Abraham ale Aizik ale Jekob Naawenni.’ ");
INSERT INTO bwu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dila a sak kama ayen wa daa kpilima Naawenya, wa ka ŋanvuuta Naawen, dila nyiŋ ni be siuku kama.” ");
INSERT INTO bwu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yeezu ale Sajusima ale boro a biisi la, Juuma Sinsaŋŋa sagrɔma wanyi a yaa wom ba ale a biisi dii la. Wa ale wom ale Yeezu a tulisi ba magsi la, wa yaa jam bek Yeezu ayen, “Ka Naawen Sinsaŋŋa po ŋa ŋan dek ale chim sinsak kpeema a gaam ŋa meena?” ");
INSERT INTO bwu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yeezu a yaa weeni wa ayen, “Sinsaŋŋa de ale chim sinsak kpeema a gaam ŋa meena. ‘Izirali demma ni wom nalimnyiini. Tama Nyɔnɔwa Naawen ka dinyi dekki. ");
INSERT INTO bwu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","A yaali wa ale fi sunum ale fi chiik ale fi popola ale fi pagrim meena.’ ");
INSERT INTO bwu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Sinsak kpeema ŋaai ale pa a saŋ la ale nna, ‘A yaali fi saalo choa ase fi dek la.’ Sinsaŋŋa ŋman karo a chim sinsak kpeema a gaam sinsaŋŋa de ŋayewa.” ");
INSERT INTO bwu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Juuma Sinsaŋŋa sagrɔwa a yaa weeni wa ayen, “Sagrɔ, fi wieŋa ka wensie. Naawen sum ka dinyi dekki. Naawen di choa a ŋman karo a gum wa po. ");
INSERT INTO bwu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Fi dan yaali wa ale fi sunum ale fi popola ale fi pagrim meena ale yaali fi saalo choa me ase fi dek la, dila ka wari kpeeni a gaam fi ale a ko duŋsa ale pa ŋanta ba chaab a kaab a te wa la kama.” ");
INSERT INTO bwu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nuruwa ale weeni dila la, Yeezu yaa seba ayen wa tulisi wa ka nalimnyiini ate wa yaa weeni wa ayen, “Ku tali ka magla ate fi jo Naawen naamu po.” Yeezu ale biisi ale nuruwa a ga nueri la, waai ŋman jam karo a ta zupagruk ayen wa bek wa wariya. ");
INSERT INTO bwu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Da yeŋ ate Yeezu a yaa jam boro a sak nuruma Juuma Puusika Yenni po. Wa yaa bek ba ayen, “Ka boa ale soa ate Juuma Sinsaŋŋa sagrɔma a weeni ayen Kirisitawa, waai ate Naawen le tom ate wa jam la, ale chim ka naawa Deevid ŋaaŋ biiga? ");
INSERT INTO bwu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Naawen Chiika jam basi kama ate Deevid weeni ayen, ‘Nyɔnɔwa Naawen weeni mi Nyɔnɔwa ayen, kali m juga nyiŋ a ta cheena diipo ate m le basi ate fi dachaasaŋa a chim fi yom la.’ ");
INSERT INTO bwu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ase Deevid dek a dan a wi Kirisitawa ayen wa, ‘Nyɔnɔ’, ku be zaani ka se ate wa ŋman baga a chim Deevid ŋaaŋbiiga?” Nuru bɔari nna yegayega ale jam boro a wom Yeezu sinsaŋŋa ale supeentik. ");
INSERT INTO bwu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Wa yaa weeni ba ayen, “Ni kpesi ni dek ate Juuma Sinsaŋŋa sagrɔma a kan paasi ni. Ba a yaali kama ayen ba jo ba garuk woŋtaŋa a bo yabaŋa po a nyiem a cheŋ ate nuruba a puusi ba abe ba a te ba zula me. ");
INSERT INTO bwu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ba a yaali kama ayen ba nyiem a kali zukpaglik sii ate nuru kpeentaŋa a kali la zuima ba tuka diinaŋa po. Ba nyiem a dan boro a nyɛ tigi ba a yaali kama ayen ba a kali zukpaglik sii ate ba kpaŋŋa a kali la zuk. ");
INSERT INTO bwu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ba nyiem a ga a paasi ka pukoga a tuesi ba ŋanta ale ge a paasi waai meena a puusi puusa woŋta a te Naawen. Wa dan jam ayen wa bo ba buusa, ba waalika le zuak yegayega.” ");
INSERT INTO bwu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yeezu a jam kala ka Juuma Puusika Yenni po a mɔata juijui ate nuruba ta ba ligra a jam a nyoro a te Naawen la, a yaa a nya. Ligra nyam yegayega ale jam maa bo Puusika Yenni po. Ba me yaa jam maa ta ligra nna yegayega a jam a nyoro. ");
INSERT INTO bwu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pukogi niwobo a yaa jam boro a ta wa ligbie ŋaye a jam nyoro. Ŋa a magsi chaab ale ka kubook. ");
INSERT INTO bwu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Yeezu yaa wi wa ŋaaŋviirima ate ba jam wa jigi ate wa yaa weeni ba ayen, “Ni wom dii ate m tara ayen m weeni a sak ni la. Ni nya pukogini de. Wa ligbie ŋayewa ate wa nyoro la, Naawen jigi wa tiirimu a gaam ligra nyamma de ligraŋa kama, dii nyiŋ la, ba te ka ligra dii ale kan tua ale ba pa teka la, alege pukogini de a pa ka wa ligraŋa meena ate wa ta la a ta jam nyoro.” ");
INSERT INTO bwu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yeezu yaa ale jam nyini Juuma Puusika Yenni po a nyini la, wa ŋaaŋviirima po wanyi a yaa weeni ayen, “Sagrɔ, nya yenni ale nala dii la?” ");
INSERT INTO bwu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yeezu a yaa tulisi ayen, “Ni nya yeri kpeeni de? Dai cheena ate ba le nak di meena a lonsi. Tain yeŋ me la a kan ŋman dua di choa zuwa.” ");
INSERT INTO bwu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ba yaa cheŋ ga jueli Olivi Guuku zuk a kala dula jigini a nya Juuma Puusika Yenni. Piita ale Jɔɔn ale Jeemsi ale Andiru a yaa bek Yeezu ba dek ba nyiini ayen, ");
INSERT INTO bwu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ka dimpo ate wieŋa de meena ayen ŋa nyɛ? Ka boa a le ku nyɛ ate ku sak ti ayen danni a mɔata?” ");
INSERT INTO bwu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yeezu a yaa weeni ba ayen, “Ni kpesi ni dek ate waai a kan paasi ni. ");
INSERT INTO bwu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nuruba yegayega le jam pa ba dek a chim Kirisitawa. Ba le paasi nuruba yegayega ayen ba va ba. ");
INSERT INTO bwu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ni dan wom kpaliŋsa wie ate si gela mɔata alege si gela me a bo niŋniŋa, ni kan a chali yɔgsumɔa. Ku a fe kama ayen nyaŋa de meena a nyɛ, alege ku kan sak kama ayen tɛŋka kpeglimka a mɔata kama. ");
INSERT INTO bwu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tɛŋsa le yiri a ta chaab. Tɛŋka me le choa m na yegayega ate kom a jam tɛŋka meena po. Ase nipɔk ale de niŋ a dom dii ale ge a biak la, ku a fe kama ayen wieŋa de meena me de niŋ nyɛ ale ge ate tɛŋka a jam kpeglim. ");
INSERT INTO bwu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","10","“Ni kpesi ni dek dii nyiŋ la, nuruba a le jam yik ni ale pagrim a ta ni cheŋ ba tuka diinaŋa kpaŋŋa jigi ate ba bo ni buusa abe ba nak ni. Ni ale a va mi la nyiŋ, ba le ta ni me a cheŋ ga zaani nalima niŋ ate ba me bo ni buusa, ate ni nya siuk a mooli Naawen wamaŋsaŋa a sak ba. Ku a fe kama ayen nuru meena a liŋ wom Naawen wamaŋsaŋa ale ge ate tɛŋka kpeglim. ");
INSERT INTO bwu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ba dan ta ni a cheŋ ga jo buusa boka dɔkku po, ni kan basi ate ni le ni biisi dii la a daani ni. Ni biisi dii meena ate Naawen le basi ate ni biisi la dii nyiŋ la, ka Naawen Chiika le ka sak ni ate ni biisi daa nama dega. ");
INSERT INTO bwu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kula danni a dan paari, suaata le yik chaab a te nuruba ate ba ko ba. Koba me ale nyɛ ba bisa dila, ate bisa me a nyɛ ba koba ale ba maba dila. ");
INSERT INTO bwu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Waai meena le kisi ni kama ni ale a va mi la nyiŋ. Alege waai a dan baga a chiib a zaani a tu ninammu de meena a ga nueri, Naawen le vari wa a basi. ");
INSERT INTO bwu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Da yeŋ ni le nya jaab buui ate Naawen kisa la ale wa za juijui ale kan magsi ayen wa zaani la. Ni dan nya dila ku a fe kama ate nama baai meena ale bo Judia tɛŋka po la a chali ga suk guutaŋa sunsuŋ.” (Nuru waai le wa karim nyaku de la, a ŋmasi miŋ chak.) ");
INSERT INTO bwu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","“Waai a dan za wa gboŋ zuk wa kan ŋman daani wa dek ayen wa siŋ a pa jaabɔa. ");
INSERT INTO bwu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Waai me ale bo wa kaduk po la, a kan ŋman kuli yeri ayen wa pa wa garuwa. ");
INSERT INTO bwu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Da ŋala po ku le jam tua ka nna yegayega a te nipɔk puusa ale baai ale ta biluaata la. ");
INSERT INTO bwu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ni a puusi a te Naawen ate nyaku de a kan jam nyɛ yoiya. ");
INSERT INTO bwu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","A zaani diipo ate Naawen a nyɛ tɛŋka la a ta jam paari jinla, ninammu de le gaam ninam meena ate nuru biik a nam ale diem kala ayen wa nam la kama. ");
INSERT INTO bwu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Alege Naawen a yeeri ninammu daaŋa gela a basi kama, baai ate wa lueri ayen ba jam va wa la nyiŋ. Wa dan kan yeeri ninammu daaŋa gela a basiya, waai kan nyini ninammu po a nyini. ");
INSERT INTO bwu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Da ŋala po waai dan weeni ayen, ‘Ni nya, Kirisitawa ale nna,’ yaase ‘Ni nya, Kirisitawa ale la,’ ni kan wom wa. ");
INSERT INTO bwu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nuruba gela a le jam yiri a paasi nuruba ayen ba ale Kirisitawa. Ba baai me le jam a weeni ayen ba ka Naawen biisiteerɔba. Ba le jam a tom wakperikaliisa nna yegayega a yaali ayen ba dan poom baga ba paasi baai ate Naawen a lueri ayen ba va wa la. ");
INSERT INTO bwu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ni be kpesi ni dek, dii nyiŋ la m ŋaam weeni wieŋa de meena kama ale ŋa an diem nyeya. ");
INSERT INTO bwu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Alege ninammu daaŋa a dan jam taam, wenbinni ale chiika meena le chim ka legi. ");
INSERT INTO bwu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Chiŋmarisaŋa le nyini wenŋmazuk a lo ate ŋanta baai meena ale bo wenŋmazuk a ta pagrim la me a choa. ");
INSERT INTO bwu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Dila po nuruba ale nya Mi Saalobiika, ale nyini chiŋmaaŋa po a cheena ale pagrim ale zula ale nalim. ");
INSERT INTO bwu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mi le tom sabiiloma ate ba jam tɛŋka meena po a tigsi nuru baai ate Naawen a lueri ayen ba va wa la. ");
INSERT INTO bwu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ni zamsi wari a magsi chaab ale kiŋkaŋ. Ni dan nya kiŋkaŋ ale ka pusi vaata, ni seba ayen wulum wein a paari kama. ");
INSERT INTO bwu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ni be dan nya wieŋa de ale ŋa piilim a nyɛ, ni yaa be seba ayen jamka mɔata kama. ");
INSERT INTO bwu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Wieŋa de meena ale nyɛ kama alege ate nuru baai ale boro la meena a kpi. ");
INSERT INTO bwu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Wenŋmazuk ale tɛŋka meena le jam taam kama. Alege mi wieŋa a kan maara taamu. ");
INSERT INTO bwu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Alege nuru waai a ze Mi Saalobiika ŋman jamka daiya. Mi dek ale Naawen sabiiloma ale bo wenŋmazuk la an baga a miŋ di danni, ka m kowa Naawen nyiini. ");
INSERT INTO bwu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ni kpesi ni dek abe ni a limsi dii nyiŋ la, ni ze m jamka daiya. ");
INSERT INTO bwu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ku a nyɛ se ka nuru ale a gomsi ayen wa nyiem a cheŋ satɛŋ niŋniŋ la. Wa yaa te wa tomteerɔma meena tuima ale weeni waai ale a nya yenni zuk la ayen wa a limsi. ");
INSERT INTO bwu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ba nyɔnɔwa a baga a jam junɔai gensa a yaase goota sunsuŋ a yaase kpadaasa kumsa po a yaase wenbinni ale a pusi diipo la kama. Ba waai ze wa le cheena diipo la. Siuk kula po me, nama waai a kan seba mi ŋman jamka danni. Dila nyiŋ la, ni kpesi ni dek abe ");
INSERT INTO bwu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ni kan basi ate ni Nyɔnɔwa a jam diiri ni ale ni dua a goa. ");
INSERT INTO bwu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","M kan weeni ka nama nyiini, mi a weeni ka waai meena. Ni kpesi ni dek abe ni a limsi.” ");
INSERT INTO bwu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Ku jam tali ka daa ŋaye ate Juuma tigi kpeeni dii ate ba a wi ayen Juuma Gaambasika Tigini la, tigi dii ate ba a ŋobi boroboruk kuui ale kan ta dabinta la a paari. Juuma Puusika Yenni kpaŋŋa ale Juuma Sinsaŋŋa sagrɔma a yaa jam a gisi siuk ayen ba yik Yeezu a ko. Ba yaa weeni ayen, “Ti kan yik wa tigini po, kan daa di nuruma le nyɛ kpaliŋ kpieŋ.” Dula jigini ba yaa nyɛ noayeŋ ba le ba nyɛ dii ate ba suk yik wa la. ");
INSERT INTO bwu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yeezu yaa cheŋ Betani tɛŋka a ga jo Simon, waai ate gamaŋa tuemu a jam yik wa ale ge nueri la yenni po. Wa yaa jam kala a de ŋandiinta ate nipɔk wanyi a ta kpaam jam. Kpaamu nyummu a jam masa kama ate bu diak a pagra. Nipowa yaa pa kpaamu a kpiiri basi Yeezu zukku zuk. ");
INSERT INTO bwu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","Nuru baai ale jam kala dula jigini la gela a yaa nya dii ate nipowa a nyɛ la, ate ba sue a yaa a puuri ale wa. Ba yaa poli ba zuima po ayen, “Ka boa ate nipowa de a pa kpaamu a yik kaasi dila? Wa dan pa bu a da kama m na, wa te nya ligra ka m na yegayega a te niwomma. Kula a gaam dii ate wa nyɛ la kama.” Ba yaa jam tɔariŋ wa. ");
INSERT INTO bwu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yeezu a yaa weeni ba ayen, “Ni basi wa. Ka boa ate ni a daani wa? Wa nyɛ ka wamaŋ a te mu. ");
INSERT INTO bwu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Niwomma a bo ale ni kama daa meena ate ni dan a yaali ni baga a maari ba. Alege mi a kan kasim bo ale ni. ");
INSERT INTO bwu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wa nyɛ ka wa ale baga a nyɛ dii meena la a te mu. Wa kpiiri kpa masika de mi nyiŋka kama a gomsi ka a magsi guka. ");
INSERT INTO bwu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Wensie ate mi a weeni ni, juijui meena ate nuruba le sak Naawen wamaŋsaŋa la, ba le weeni nipowa de ale nyɛ dii a te mu la kama a teeri wa wari.” ");
INSERT INTO bwu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Dula jigini Yeezu ŋaaŋviirima pi ale bayewa po wanyi, waai ate ba a wi ayen Judas Iskariot la a yaa cheŋ Juuma Puusika Yenni kpaŋŋa jigi a ga weeni ba ayen wa baga a maari ba kama ate ba a yik Yeezu. ");
INSERT INTO bwu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ba ale ga wom dila la, ba sue a yaa peenti m na yegayega, ate ba weeni wa ayen wa dan baga a maari ba, ba le te wa ligra. Judas a yaa basi dula jigini ale a gisi siuk kuui wa le wa va ate ba baga a yik Yeezu la. ");
INSERT INTO bwu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yeezu ŋaaŋviirima yaa jam wa jigi tigi dii ate ba a ŋobi boroboruk kuui ale kan ta dabinta la piilimka danni. Da dila me ale ba a ko Juuma Gaambasika Tigini piisaŋa. Ba yaa bek Yeezu ayen, “Ka be ate fi a yaali ayen ti ga gomsi Juuma Gaambasika Tigini ŋandiintaŋa ate ti de?” ");
INSERT INTO bwu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Wa yaa weeni wa ŋaaŋviirima po baye ayen, “Ni cheŋ a ga jo tɛŋka po. Dula jigini ni le nya nidɔa a ji nyiam ale samɔniŋ. ");
INSERT INTO bwu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ni va wa a ga jo yeri dii po ate wa a jo la. Ni dan ga jo ni weeni yenni nyɔnɔwa ayen, ‘Ti Sagrɔwa ale tom ti ayen ti jam bek fu dɔk kuui po ate wa ale wa ŋaaŋviirima ayen ba jam de ba Juuma Gaambasika Tigini ŋandiintaŋa la.’ ");
INSERT INTO bwu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wa le dak dɔk kpioŋ kunyi ate ba vaari ale gomsi ku meena po, ate ku bo ŋa chaab zuk la a sak ni. Ni yaa jo ku po, a gomsi jaab buuri meena a magsi ate ti kali a de.” ");
INSERT INTO bwu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ba yaa cheŋ ga jo tɛŋka po a nya dii meena ate Yeezu a poom weeni ba la, ate ba yaa gomsi ba Juuma Gaambasika Tigini ŋandiintaŋa dula jigini ale ge pilim ŋman a ga Yeezu jigi. ");
INSERT INTO bwu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Junɔai ale jam paari la, Yeezu ale wa ŋaaŋviirima pi ale bayewa a yaa jam kala a de. ");
INSERT INTO bwu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ba ale boro a de la, Yeezu a yaa weeni ba ayen, “Wensie ate mi a weeni ni meena ale kala a de ale mu la, ni po wanyi le wa ta mu a ga bobri sak m dachaasaŋa.” ");
INSERT INTO bwu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wa ŋaaŋviirima sue yaa kaasi ate ba bek wa wanyiwanyi ayen, “Ka mi? Ka mi?” ");
INSERT INTO bwu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yeezu a yaa weeni ba ayen, “Ku le chim ka nama pi ale bayewa po wanyi, waai ale a ŋmari boroboruku a siuk jentaŋa ale mu la, a le wa ta mu a ga bobri sak. ");
INSERT INTO bwu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mi, Saalobiika, ale kpi ase ka ba ale ŋmarisi dii Naawen gbaŋka po la. Alege ku le pagra kama a te waai dek ale wa ta mu a ga bobri sak la. Ku zunchoŋ kama ale ba nin poom kan biak wa.” ");
INSERT INTO bwu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ba ale boro a de ŋandiintaŋa la, Yeezu a yaa pa boroboruk a puusi a te Naawen a nyɛ wa jiam, alege ŋmari ku a chari wa ŋaaŋviirima ale weeni ba ayen, “Ni ŋɔa ŋobi, mi nyiŋka ale m na.” ");
INSERT INTO bwu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wa yaa ŋman pa beerik ale daam a puusi a te Naawen a nyɛ wa jiam, alege pa te ba ate ba nyu. ");
INSERT INTO bwu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Wa yaa weeni ba ayen, “Ka mi nyiŋka ziimu ale nna. Buui ale a nyini nuruba yega nyiŋ la, ayen ku sak ayen Naawen ale jam puulim ayen wa le nyɛ dii a te nurubiik la, wa sum a nyɛ kama. ");
INSERT INTO bwu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Wensie ate mi a weeni ni, m kan ŋman nyu daamu de ase ka dai dii danni ate m ŋman a nyu da paalimu Naawen naamu po la.” ");
INSERT INTO bwu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ba yaa yi yiili ale ge a nyini ga jueli Olivi Guuku zuk. ");
INSERT INTO bwu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yeezu yaa weeni ba ayen, “Ni meena ale chali abe ni ge mu dii nyiŋ la ba ŋmarisi Naawen gbaŋka po kama ayen, ‘Naawen le jam ko naapeerika, ate piisaŋa a yaa chali waaŋ chaab.’ ");
INSERT INTO bwu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Alege m dan yiti kum po, m le de ni niŋ a cheŋ Galili tɛŋka.” ");
INSERT INTO bwu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piita yaa weeni wa ayen, “Mbala meena a dan poom basi fu, mi kan maa basi fu diipo diipo.” ");
INSERT INTO bwu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yeezu yaa weeni wa ayen, “Basi ate m weeni a sak fu ayen, yokku de fi le pagsi ku noai buta ayen fi ze mu, ale ge ate vari kpadiaka a kum a nyɛ buye.” ");
INSERT INTO bwu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Piita yaa pii nyiŋ a ŋman weeni wa ayen, “Mi kan weeni diipo diipo ayen m ze fu. Mi dan poom ayen m kpi ale fu, mi kan weeni dila.” Wa ŋaaŋviirima mbala meena me a yaa weeni dila degadega. ");
INSERT INTO bwu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ba yaa jam paari jigi ate ba a wi ayen Getsemani, ate Yeezu a yaa weeni wa ŋaaŋviirima ayen, “Ni kali dela ate m ga puusi a te Naawen abe m jam.” ");
INSERT INTO bwu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Wa ale a cheŋ la, wa yaa basi ate Piita ale Jeemsi ale Jɔɔn a va wa. Wa sui a yaa jam kaasi nna yegayega, ate ");
INSERT INTO bwu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","wa weeni ba ayen, “M sui ale kaasi nna yegayega, ate ku a nyɛ nna ase mi a yaali ayen m kpi kama la. Ni be limsi dela ate m jam, abe ni kan goa.” ");
INSERT INTO bwu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Wa ale ga cheŋ maga dek la, wa yaa kpi duna tɛŋ a puusi a te Naawen ayen dan ka dii wa yeeri ninam buui ate wa za wa nam la wa jigi a basi. ");
INSERT INTO bwu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Wa puusi a te Naawen kama ayen, “M Koa, fi baga a nyɛ wari meena kama. Yeeri ninammu de m jigi a basi. Alege, nyɛ fi dek ale a yaali dii la, daa mi ale a yaali dii la.” ");
INSERT INTO bwu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wa yaa pilim jam a paari wa ŋaaŋviirima batawa ale ba dua a goa. Wa yaa weeni Piita ayen, “Simon, ni a goa kama? Nama an baga nya ate ku a beni fiifiik ale ge kan goa? ");
INSERT INTO bwu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ni a nya abe ni puusi a te Naawen ayen goom kan yik ni ate ni goa. Ni a yaali ayen ni nyɛ dii ate m weeni ni la kama, alege ni an baga a nyɛ dila ale ni dek pagrimɔa. Ni a yaali ka maarika m jigi.” ");
INSERT INTO bwu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Wa yaa ŋman ga puusi a te Naawen a weeni wa ale poom a weeni dii la. ");
INSERT INTO bwu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Wa yaa ŋman jam wa ŋaaŋviirima jigi ale ba ŋman dua a goa, dii nyiŋ la, goom ale jam ta ba nna yegayega, ate ba ze ba ale ba weeni wa dii la. ");
INSERT INTO bwu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Wa ale ŋman jam ku noai butawa la, wa yaa weeni ayen, “Ni diem a goa kama? Ku magsiya. Di danni a paari ya. Ba le yik Mi, Saalobiika a nyo nuru baata nisima po yɔgyɔgla de. ");
INSERT INTO bwu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ni yiri ate ti cheŋ. Nuru waai ale ta mu a ga bobri sak la ale la a cheena.” ");
INSERT INTO bwu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yeezu ale diem boro a biisi la, wa ŋaaŋviirima pi ale bayewa po wanyiwa Judas, a yaa jam wa jigi ale nuru bɔari. Juuma Puusika Yenni kpaŋŋa ale Juuma Sinsaŋŋa sagrɔma ale tɛŋka kpaŋŋa ale tom ba. Ba jam ta ka gebi kpeensa ale dua a jam ayen ba yik wa. ");
INSERT INTO bwu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Bumbobrowa a poom weeni ba kama ayen, “Ti dan ga paari ba, nuru waai ate mi a puusi wa la, ka waai ate ni a yaali la ale la. Ni yik wa a ta cheŋ abe ni kan te wa be.” ");
INSERT INTO bwu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ba ale ga paari Yeezu la, Judas a yaa deri ga wa jigi a wi wa ayen, “M Sagrɔ,” a yaa ale ge a puusi wa. ");
INSERT INTO bwu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Judas ale nyɛ dila la, nuruma a yaa deri yik Yeezu ale pagrim. ");
INSERT INTO bwu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yeezu ŋaaŋviirima po wanyi a yaa deri yeeri wa gebi kpieŋ a che Juuma Puusika Yenni kpagi kpeeni tomteerɔwa turi a lonsi tɛŋ. ");
INSERT INTO bwu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yeezu a yaa bek nuru bɔanni ayen, “Mi ka zue ate ni ta gebi kpeensa ale dua a jam ayen ni yik mu? ");
INSERT INTO bwu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Daa meena mi kasim bo ale ni kama Juuma Puusika Yenni po a sak nuruba, alege ni an yik mu. Alege ku a fe kama ayen ba ale ŋmarisi Naawen gbaŋka po dii dila po dila po la, a jam chim wensie.” ");
INSERT INTO bwu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Dula jigini Yeezu ŋaaŋviirima meena a yaa chali ale ge wa. ");
INSERT INTO bwu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nidɔa wanyi ale jam maa va Yeezu a yulum gatta peelik. Ba jam a yaali ayen ba yik wa kama, ");
INSERT INTO bwu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ate wa foli gatiaka a basi a te ba ale ge a yiri chali ale chabɔla. ");
INSERT INTO bwu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ba yaa ta Yeezu a cheŋ Juuma Puusika Yenni kpagi kpeeni yenni. Juuma Puusika Yenni kpaŋŋa ale tɛŋka kpaŋŋa ale Juuma Sinsaŋŋa sagrɔma a yaa jam tigsi chaab dula jigini, ayen ba bo Yeezu buusa. ");
INSERT INTO bwu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piita a yaa magi va ba ŋaaŋ a ga jo Juuma Puusika Yenni kpagi kpeeni yenni dabiaka po a ga kala ale kpagini tomteerɔma a ŋuuŋ bolim. ");
INSERT INTO bwu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Juuma Puusika Yenni kpaŋŋa ale boteerɔma meena a yaa jam a bek nuruba ayen ba wom Yeezu wakaasuŋ ba jigi ate ba nya siuk a ko wa. Alege ba an baga a nya wari ya. ");
INSERT INTO bwu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nuruba yegayega a jam velim wie a te wa kama alege ba noaŋa jam daa bunyi. ");
INSERT INTO bwu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ba gela a nyini a biisi venta wie ayen, ");
INSERT INTO bwu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tama wom ale wa a weeni ayen wa baga a kaasi Juuma Puusika Yenni dii ate nuruba a se la kama, abe wa ŋman se di daa ŋata po. Wa be kan pa nuruba ate ba se di.” ");
INSERT INTO bwu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Alege ba me wieŋa a jam daa noayeŋ wie. ");
INSERT INTO bwu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ba meena ale biisi a ga nueri la, Juuma Puusika Yenni kpagi kpeeni a yaa yiri a zaani ba meena niŋ a bek Yeezu ayen, “Fi ka wari a tulisi wieŋa de meena ate ba a biisi la po?” ");
INSERT INTO bwu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yeezu yaa sina. Wa yaa ŋman bek wa ayen, “Ka fi ale Naawen biika, Kirisitawa ate Naawen le tom la?” ");
INSERT INTO bwu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yeezu a yaa weeni wa ayen, “Mm, mi ale la. Da yeŋ ni le nya Mi, Saalobiika ale m kali Naawen kpeeni juga geŋ a nyini chiŋmaaŋa po a cheena.” ");
INSERT INTO bwu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Wa ale weeni dila la, Juuma Puusika Yenni kpagi kpeeni a yaa yik wa dek garuku a dari cheeri ayen ku sak ayen Yeezu ale weeni dii la a kabi wa kama ate wa yaa weeni boteerɔma ayen, “Ti an ŋman a yaali seeroba. ");
INSERT INTO bwu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ni meena a wom wa ale pa wa dek a magsi chaab ale Naawen la kama. Nama a poli ka se? Wa lo yaa wa an loya?” Ba meena a yaa bo mini wa ayen ku a magsi kama ayen wa kpi. ");
INSERT INTO bwu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Boteerɔma gela a yaa chesi tintueta a basi wa nyiŋ ale pa garuk a bobi lik wa ninaŋa a nak wa ale a bek ayen, “Fi seba waai dek ale nak fu la?” Nuru baai me ale ga yik Yeezu la yaa fobi wa a gum du. ");
INSERT INTO bwu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ba ale ta Yeezu a nyɛ dila la, Piita a diem jam bo ka yenni dabiaka po. Juuma Puusika Yenni kpagi kpeeni dɔgleema wanyi a yaa nya wa. ");
INSERT INTO bwu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Wa ale nya Piita ale wa kala a ŋuuŋ bolimu la, wa yaa bek wa ayen, “Fi daa Yeezu Nazaret denowa ŋaaŋviirima po wanyi?” ");
INSERT INTO bwu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Piita a yaa pagsi ayen, “Mi ze fi ale a weeni dii la.” Wa ale weeni dila la, wa yaa yiri a cheŋ ga za nansiuŋku noai. Dila powa kpadiak a yaa deri kum. ");
INSERT INTO bwu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nipɔkbinni ale ŋman nya wa ale wa za dula jigini la wa yaa weeni baai ale za dula la ayen, “Nuruwa de ka Yeezu ŋaaŋviirima po wanyi.” ");
INSERT INTO bwu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piita yaa ŋman pagsi ayen wa daa Yeezu ŋaaŋviirima po wanyi. Ku ŋaaŋnyiŋ, nuru baai ale jam za mɔata wa la a yaa weeni wa ayen, “Fi ka ba po wanyi, dii nyiŋ la fi me nyini ka Galili tɛŋka.” ");
INSERT INTO bwu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Piita yaa pe ayen wa ze nuru waai ate ba a weeni wa wie la. ");
INSERT INTO bwu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Wa ale pe la, vari kpadiaka a yaa deri kum a nyɛ buye ate Piita a deri teeri dii ate Yeezu a poom weeni wa ayen, wa le pagsi ku noai buta ayen wa ze wa ale ge ate vari kpadiaka a kum a nyɛ buye la. Wieŋa de meena a yaa nyɛ ate Piita sui a kaasi nna yegayega ate wa yaa deri a kum. ");
INSERT INTO bwu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Vari ale veenti la, saliuk yokyokwa Juuma Puusika Yenni kpaŋŋa ale tɛŋka kpaŋŋa ale Juuma Sinsaŋŋa sagrɔma ale boteerɔma a yaa ŋman kpabi tu chaab ayen ba zok ba le ba nyɛ Yeezu dii la. Ba ale zok ale chaab a ga nueri la, ba yaa bobi wa nisimaŋa a ta wa cheŋ tɛŋka gominawa Paalɔt jigi. ");
INSERT INTO bwu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ba ale ga paari la, Paalɔt a yaa bek Yeezu ayen, “Ka fi ale Juuma naawa la?” Yeezu yaa tulisi wa ayen, “Ka fi dek ale weeni dila.” ");
INSERT INTO bwu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Juuma Puusika Yenni kpaŋŋa jam a chiini ka wie nna yegayega ayen Yeezu a nyɛ kaasi. ");
INSERT INTO bwu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Dila nyiŋ Paalɔt yaa ŋman bek wa ayen, “Fi kan wom ba ale a chiini wieŋa nna yegayega a te fu la? Fi ka wariya a tulisi ba?” ");
INSERT INTO bwu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Alege Yeezu a jam sina. Wa an jam weeni wariya. Ku yaa cha Paalɔt. ");
INSERT INTO bwu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bena meena ba Juuma Gaambasika Tigini a nyiem a dan paari, Gominawa Paalɔt a nyiem lak nuru waai ate tɛŋka demma a yaali ayen wa lak ate wa nyini likka dɔkku po a nyini la a basi kama. ");
INSERT INTO bwu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nuru wanyi ale jam boro ate ba a wi ayen Barabasi ate ba jam maa yik wa a lik dii nyiŋ la, wa jam maa nyɛ ka noayeŋ ale wa tɛŋka demma ate ba nyɛ kpaliŋ ale baai ale a nya ba tɛŋka zuk la. Ba ale jam boro a nyɛ kpaliŋka la, ba jam ko ka nuruba gela. ");
INSERT INTO bwu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nuruba yegayega a yaa tigsi chaab a jam Paalɔt jigi a saalim wa ayen wa nyɛ dii ate wa nyiem poom a nyɛ tigini danni la a te ba. ");
INSERT INTO bwu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Wa yaa bek ba ayen, “Nama a yaali ayen m basi ka Juuma naawa?” ");
INSERT INTO bwu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Paalɔt a jam seba ayen ka Juuma Puusika Yenni kpaŋŋa nyunni nyiŋ ale soa ate ba yik Yeezu a ta jam wa jigi. ");
INSERT INTO bwu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Juuma Puusika Yenni kpaŋŋa a yaa weeni nuru bɔanni ayen ba a saalim ayen wa lak Barabasi a basi abe wa ge Yeezu. ");
INSERT INTO bwu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Paalɔt a yaa bek ba ayen, “Nuru waai ate nama wi ayen Juuma naab la, m nyɛ wa se?” ");
INSERT INTO bwu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ba meena a yaa kaari nna yegayega ayen, “Ni ko wa.” ");
INSERT INTO bwu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Paalɔt a yaa bek ba ayen, “Ka boan jaab wabiok ate wa tom?” Ba yaa kaari a gaam dila a weeni ayen, “Ni ko wa.” ");
INSERT INTO bwu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Paalɔt a jam a yaali kama ayen wa nyɛ ate nuru bɔanni supeentik. Wa yaa lak Barabasi a basi, ale ge basi ate ba miiri Yeezu ale kpaasa ale ge pa wa a te, ayen ba ta wa ga ko. ");
INSERT INTO bwu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Paalɔt sojima a yaa yik Yeezu a ta jo ba Gominawa yenni dabiaka po a yaa wi ba soji chaama ate ba jam. ");
INSERT INTO bwu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ba yaa pa garuk monuŋ a jo wa ale pa munsa a yok zutok a pa vuk wa zukku, ");
INSERT INTO bwu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","a yaa a puusi wa a weeni ayen, “Juuma naawa kasim boro taam wuu.” ");
INSERT INTO bwu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ba yaa pa duok, a nak wa zukku ale chesi tintueta a basi wa nyiŋ ale kpi duna wa niŋ a potim a nyɛ nna ase ba a te wa ka zula la. ");
INSERT INTO bwu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ba ale nyɛ wa la a ga nueri la, ba yaa yeeri garuk monuku ale pa wa dek gattaŋa a jo wa a ta wa nyini cheŋ ayen ba ko. ");
INSERT INTO bwu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ba ale jam bo siuku po a cheŋ la, ba yaa zik Simon ale wa cheena tɛŋka po ate sojima a fe wa ate wa tuesi Yeezu jabarimu ji. Simon a jam ka tɛŋ kaai ate ba a wi ayen Sairini la deno. Wa jam ka nuru baai ate ba a wi ayen Alezanda ale Arufusi la ko. ");
INSERT INTO bwu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ba yaa ta Yeezu a ga paari juijui ate ba a wi ayen Golgota la. Ku kiri ale “Zukoluku Jigini.” ");
INSERT INTO bwu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ba yaa pa tiim a nyo daam po ayen Yeezu nyu, alege wa an jam nyuya. ");
INSERT INTO bwu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Wenbinni ale jam kan diem a jueli paari wenzuk sunsuŋ la, ba yaa yik Yeezu a kpi wa jabarimu nyiŋ. Ba yaa pa wa gattaŋa a chari chaab. Ba jam nak ka gbaŋ a nya waai ale magsi garuk kuui deka la. ");
INSERT INTO bwu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ba yaa pa tapagi a ŋmarisi di nyiŋ ayen, KA JUUMA NAAWA ALE NNA a pa di kpi jabarimu zuk. ");
INSERT INTO bwu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ba jam maa kpi ka zueba baye ŋanbarinta nyiŋ a gum Yeezu po, ate ba wanyi a bo wa juga, nwala me a bo wa gala. ");
INSERT INTO bwu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ate ba le jam ŋmarisi dii Naawen gbaŋka po ayen, “Ba nyɛ wa ase ka zue la a yaa jam chim wensie.” ");
INSERT INTO bwu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nuru baai ale jam va dula a taam la a yaa zak zuk nya wa a mati ba noa ale a le wa ayen, “Mm, daa fi ale weeni ayen fi le kaasi Juuma Puusika Yenni abe fi ŋman se di a nueri daa ŋata po la? ");
INSERT INTO bwu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nyini jabarimu zuk a siŋ a vari fi dek a basi ate ti nya.” ");
INSERT INTO bwu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Juuma Puusika Yenni kpaŋŋa ale Juuma Sinsaŋŋa sagrɔma me a jam a la wa ale a weeni chaab ayen, “Wa jam baga a vari nuruba a basi kama, alege wa an baga a vari wa dek a basi. ");
INSERT INTO bwu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ka Juuma naawa, ale nna. Kirisitawa ate Naawen le tom ate wa jam la ale nna. Wa nyini jabarimu zuk a siŋ ate ti yaa siak a te wa.” Zuema bayewa baai ate ba jam kpi ba a gum Yeezu po la, me a le wa. ");
INSERT INTO bwu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wenni ale jam jueli a bo wenzuk sunsuŋ la, legi a yaa jam lik tɛŋ kala meena a ta ga paari wenbalini. ");
INSERT INTO bwu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Legini ale jam basi la, Yeezu a yaa kaari nna yegayega a weeni wa dek tɛŋka biika po ayen, “Eloi, eloi lema sabagtani.” Ku kiri ale, “M kowa Naawen, m kowa Naawen, ka boa ate fi zɛri mu?” ");
INSERT INTO bwu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nuru baai ale jam za dula jigini la ba gela wom dii ate wa weeni la. Ba yaa weeni chaab ayen, “Fi wom wa ale a wi Naawen biisiteerɔwa Elaja la?” ");
INSERT INTO bwu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ba po wanyi a yaa chali cheŋ ga pa sosok a lusi da miisiŋ po a pa yik do woŋ nyiŋ a zak ta jueli Yeezu noai. Wa ale diem a zak duoku ta la wa yaa chiem weeni baai ale jam za la ayen, “Ni basi ate ti limsi a nya ase Elaja a le jam a yik wa ta nyini jabarimu zuk a siŋ tɛŋ ya.” ");
INSERT INTO bwu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yeezu a yaa ŋman kaari nna yegayega a yaa ale ge a kpi. ");
INSERT INTO bwu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Wa ale jam kpi la, garuk kpioŋ kuui ate ba jam pa a kasi Juuma Puusika Yenni po la, a yaa jam cheeri ku ŋmazuk a ta siŋ paari ku tɛŋ. ");
INSERT INTO bwu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sojima kpagi dii ale jam za Yeezu jabarimu tɛŋ la a jam nya wa ale kpi dii la kama. Wa yaa weeni wa dek ayen, “Wensie, nuruwa de sum ka Naawen biik.” ");
INSERT INTO bwu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Nipɔk baai ale jam maari Yeezu Galili tɛŋka po la, ba gela a jam za mɔata dula a nya dii ale nyɛ la kama. Ba gela yue a jam ale Salomi ale Mɛɛri Magdala ale Mɛɛri, Jeemsi baaŋka ale Josesi mawa. Nipɔk baai ale jam va Yeezu a cheŋ Jerusalem tɛŋka po la, yegayega me a jam bo dula jigini kama. ");
INSERT INTO bwu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Nuru wanyi ale jam nyini tɛŋ ate ba a wi ayen, Arimatia. Wa yoi a jam ale Josefi. Wa jam ka Juuma boteerɔma po wanyi ate nuruba a zuli wa nna yegayega. Wa jam kasim a limsi ka diipo ate Naawen ayen wa jam chim naab tɛŋzuk de a nya tɛŋka meena la. Da dii ale pa a te ba Vuusum Danni la, ka da dii ate ba a gomsi ba dek nalimnyiini a limsi Vuusum Danni la. Da dila danni junɔai ate wa yaa yiri ale popo pagrim a cheŋ Paalɔt jigi a ga saalim wa ayen wa basi ate wa ga yeeri Yeezu nyiŋka jabarimu zuk a ta cheŋ ga gu. ");
INSERT INTO bwu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Paalɔt ale ga wom ayen Yeezu a kpi ka nna nwuli la, ku yaa deri cha wa nna yegayega. Wa yaa wi wa sojima kpagini a bek wa ayen, “Ka wensie wa sum kpi kama?” Kpagini a yaa tulisi wa ayen, “Mm, ka wensie wa sum kpi kama.” ");
INSERT INTO bwu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Dula jigini Paalɔt a yaa siak ayen Josefi ga yeeri Yeezu nyiŋka jabarimu zuk a ta ga gu. ");
INSERT INTO bwu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josefi a yaa basi dula jigini ale ge cheŋ ga da garuk a yaa ga yeeri Yeezu nyiŋka jabarimu zuk a yaa pa garuku a pili ka a ta ga dueni puŋ vorub paalik po. Tɛŋ kala demma a jam a gu ba nuruma ka pina vie po. Wa ale nyɛ dila a ga nueri la, wa yaa bilim tintain kpeeni a lik puŋku vorumu nɔanni. ");
INSERT INTO bwu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mɛɛri Magdala ale Josesi mawa Mɛɛri, a jam nya ba ale gu Yeezu juijui la kama. ");
INSERT INTO bwu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ba Vuusum Danni ale taam la, Mɛɛri Magdala ale Jeemsi mawa Mɛɛri ale Salomi a yaa ga da kpa masik ayen ba pa sa Yeezu nyiŋka. ");
INSERT INTO bwu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Laasidi dai, saliuk yokyok ate wenni pusi magla la, ba yaa cheŋ juijui ate ba gu Yeezu la. ");
INSERT INTO bwu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ba ale jam a cheŋ la, ba yaa bek chaab ayen, “Ka wana dek ale wa bilim tintanni puŋku vorumu noai a basi a te ti?” ");
INSERT INTO bwu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ba ale ga paari la, ba yaa nya tintanni ale di bilim dua nakpiak ale ge puŋku vorumu nɔanni a basi. Tintanni a jam zuak kama ale dobra. ");
INSERT INTO bwu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nipooma a yaa ga jo Yeezu guka jigini a yaa nya nidɔa wanyi ale wa kala ba juga geŋ a jo kasaauk peeluk ate yɔgsum a yaa jam yik ba nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nidɔawa a yaa weeni ba ayen, “Ni kan chali yɔgsumɔa. M seba ayen ni a gisi ka Yeezu Nazaret denowa waai ate ba kpi wa jabarimu nyiŋ la. Wa yiri kum po kama. Ni nya ba ale pa wa dueni juijui la nna. ");
INSERT INTO bwu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ni cheŋ ga weeni Piita ale Yeezu ŋaaŋviirima meena ayen, ‘Wa le de ba niŋ a cheŋ Galili tɛŋka po kama ase wa daam ale weeni ba dii la. Ba dan cheŋ dula, ba le nya wa.’ ” ");
INSERT INTO bwu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nipooma a yaa basi dula jigini ale ge chali a cheŋ. Ba kpaziim a yaa jam a nak nna yegayega ate ba nyiŋsaŋa a gok. Ba an jam a weeni sak waaiya, dii nyiŋ la ba jam a chali ka yɔgsum. ");
INSERT INTO bwu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yeezu ale yiri kum po Laasidi dai saliuk yokyok la wa liŋ pa wa dek a sak ka Mɛɛri Magdala waai ate wa jam yiak chichiribaata tiyopoiwa wa jigi a basi la. ");
INSERT INTO bwu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mɛɛri a yaa jam cheŋ Yeezu ŋaaŋviirima jigi. Ba meena sue a jam kaasi ka nna yegayega ate ba a kum. ");
INSERT INTO bwu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mɛɛri a yaa weeni ba ayen Yeezu a yiri kum po kama ŋman ta nyuvuri ate wa dek a nya wa. Alege ba an jam siak ayen ku ka wensie. ");
INSERT INTO bwu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ku ŋaaŋnyiŋ ate Yeezu a yaa jam tagri a pa wa dek a sak wa ŋaaŋviirima po bayewa, baai ale jam basi Jerusalem tɛŋka a cheŋ jigi yoŋ la. ");
INSERT INTO bwu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ba yaa pilim ŋmani a cheŋ wa ŋaaŋviirima mbala jigi a weeni ba ayen ba nya Yeezu kama, alege ba an jam siak ayen ku ka wensie. ");
INSERT INTO bwu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ku ale ŋman pilim ga nyɛ maga la, Yeezu ŋaaŋviirima pi ale wanyiwa a yaa jam kala a de ba ŋandiinta ate Yeezu a yaa jam pa wa dek a sak ba. Wa yaa tɔariŋ ba ayen ba ka nuru baai ale kan ta siaka la. Ba tueŋa a kpari ka nna yegayega ate ba an baga siak ale baai ale jam weeni a sak ba ayen ba nya wa kama ale wa yiri kum po la. ");
INSERT INTO bwu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Wa yaa weeni ba ayen, “Ni nyini a cheŋ tɛŋka meena po a mooli Naawen wamaŋsaŋa a sak waai meena. ");
INSERT INTO bwu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Baai meena ale ba ta siaka ale mi, a tuesi soka, Naawen le vari ba ba wabaataŋa po a basi, alege baai meena ale kan ba ta siaka ale mi la, Naawen le jam bo mini ba kama. ");
INSERT INTO bwu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Baai meena ale ta siaka ale mi la, le baga a nyɛ wie ate ku sak ayen Naawen ale sum tom ba. Ba le pa mi yonni nyiŋ a yiak chichiribaata nuruba zuima po a basi. Ba le baga a biisi be paalisa me. ");
INSERT INTO bwu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ba dan yik wiiga yaase ba dan nyu choŋ, jaab kan nyɛ ba. Ba le baga me a pa ba nisima a vi yɔgnyeensa zuk ate ba a nya nyiŋyɔgsa.” ");
INSERT INTO bwu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nyɔnɔwa Yeezu ale biisi a ga nueri la, wa yaa yiri a jueli wenŋmazuk a ga kala Naawen juga geŋ. ");
INSERT INTO bwu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Wa ŋaaŋviirima a yaa nyini a cheŋ tɛŋka meena po a mooli Naawen wamaŋsaŋa a sak nuruba. Nyɔnɔwa a jam bo ale ba kama diipo meena ale a maari ba ate ba a tom tuimkperisa nna yegayega ayen ku sak ayen ba wieŋa ka wensie.");
INSERT INTO bwu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Fi Teofilos waai ate mi Luuk a te fu zula nna yegayega la, ale a ŋmarisi gbaŋka de a te fu. Nuruba yegayega a pii nyiŋ kama ayen ba ŋmarisi wie ŋaai meena ale nyɛ tama sunsuŋ la. ");
INSERT INTO bwu_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Wie ŋaai meena ate ba ŋmarisi la a nyini ka seero baai ale nya ŋa ta nyini ku piilimka po ale a sak nuruba ŋa wie la jigi. ");
INSERT INTO bwu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Dila nyiŋ la, mi ale lagi nina a ŋmasi zamsi wieŋa de a ta nyini ŋa piilimka po la nyiŋ ale soa ate mi poli ayen ku nala kama ate m ŋmarisi ŋa meena ate ŋa va chaab a te ni. ");
INSERT INTO bwu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mi a ŋmarisi gbaŋka de a te fu kama ate fi baga a miŋ ayen wie ŋaai meena ate ba sak fu la a sum ka wensie. ");
INSERT INTO bwu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Va ŋaai po ate Ayerod a jam chim Judia tɛŋka naab la, Juuma Puusika Yenni kpagi wanyi ale jam boro. Wa yoi jam le Zakaria. Wa jam nyini ka kpagi diinaŋa po kunyi ate Abaija soa la. Zakaria powa yoi jam ale Elizabet. Elizabet me jam ka Juuma Puusika Yenni tomteerɔma po wanyi le. ");
INSERT INTO bwu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zakaria ale wa powa a jam ka nuru welensa ale a va Naawen sinsaŋŋa nalimnyiini. Ba jam ka wakaasuŋ Naawen jigi ya. ");
INSERT INTO bwu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Wa ale wa powa meena a jam kpaŋ ka nna yegayega, alege ba jam ka biiga, dii nyiŋ la wa powa Elizabet a jam ka kirik. ");
INSERT INTO bwu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Da yeŋ ate ku jam paari Zakaria buuni po wanyi ayen wa jo Juuma Puusika Yenni po a nyɛ kaabka la, ba yaa jam lueri ayen wa Zakaria jo nyɛ kaabka. ");
INSERT INTO bwu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Juuma Puusika Yenni tomteerɔma a ta ka ba nyeka a va a tom ba tuimaŋa. Ba yaa nak gbaŋ a lueri Zakaria ayen wa ju ŋanta baai nyum ale masa la kuŋkuŋku zuk a te Naawen. Wa yaa jo Juuma Puusika Yenni po. ");
INSERT INTO bwu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wa ale diem a jam bo di po la, nuru bɔanni baai ale jam ayen ba puusi Naawen la, a yaa tigsi chaab nna yegayega a jam za dabiaka po a puusi. ");
INSERT INTO bwu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zakaria ale jam boro pa ŋantaŋa a nyo bolimu po ayen ba de la, Naawen sabiiloma wanyi a yaa deri jam wa jigi a jam za kuŋkuŋku jigini juga geŋ. ");
INSERT INTO bwu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakaria ale nya wa la wa yaa deri a chali yɔgsum. ");
INSERT INTO bwu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Alege sabiilowa a yaa weeni wa ayen, “Zakaria, kan chali yɔgsum, dii nyiŋ la Naawen a wom fi puusaŋa kama. Wa be le basi ate fi powa a yik puuk a biak nidɔabili. Wa dan jam biak, te biika yonni ayen Jɔɔn. ");
INSERT INTO bwu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wa dan biak wa fi ale fi powa ale nuruba yegayega sue le peenti ka nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Naawen a le basi ate wa chim nuru kpioŋ Naawen nimbie po abe wa kan a nyu daamɔa yaase dapagriga. Naawen Chiika ale sueri wa a nyini wa biam po. ");
INSERT INTO bwu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Wa dan chim wa le basi ate Izirali demma yegayega a basi ba beemu suitaŋa abe ba ŋman va ba nyɔnɔwa Naawen. ");
INSERT INTO bwu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jɔɔn ale de Nyɔnɔwa niŋ ale pagrim ase Naawen biisiteerɔwa Elaja ale jam pagra dii la. Wa le jam yik koba ale ba bisa ate ba niak chaab. Wa ale ta baai ale kan a va Naawen siuku la a jam welensa nyamma yammu siuku po. Wa ale gomsi Nyɔnɔwa nuruma a magsi a te wa.” ");
INSERT INTO bwu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaria a yaa bek sabiilowa ayen, “Mi a le nyɛ ka se a seba ayen fi ale biisi dii la ka wensie? Mi ale m powa a kpaŋ kama.” ");
INSERT INTO bwu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Sabiilowa a yaa weeni wa ayen, “Mi ka Gabriel waai ale a zaani Naawen niŋ la. Wala abe le tom mu ayen m weeni fu wamaŋsaŋa de. ");
INSERT INTO bwu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mi ale weeni fu dii la a le jam chim ka wensie, diipo ale magsi la alege fi ka siaka ale mi ale weeni dii la. Dila nyiŋ la fi le chim ka gaauŋ a ta ga paari wieŋa de meena nyeka dai.” ");
INSERT INTO bwu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Dila po meena ale nuruma za ka dabiaka po a limsi ayen wa nyini. Ba yaa jam a weeni chaab ayen, “Ka boa ale soa ate wa a beni dɔkku po dila.” ");
INSERT INTO bwu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zakaria ale nyini yenni po a za nuru bɔanni meena niŋ la, wa an jam baga a biisi ate wa yaa pa wa nisimaŋa a magsi a sak ba. Nuruma ale nya Zakaria ate wa pa wa nisimaŋa a magsi wieŋa a sak ba la, ba yaa deri miŋ ayen wa nya ka wari Juuma Puusika Yenni po nna ase wa goa daasim kama la. ");
INSERT INTO bwu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zakaria tuimaŋa daaŋa ale nueri Juuma Puusika Yenni po la, wa yaa ŋman kuli wa yenni. ");
INSERT INTO bwu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Daa magla ale taam la, wa powa a yaa yik puuk a bo wa yenni po chiisa sinu ale kan nyeemu a ga jigiya. ");
INSERT INTO bwu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Dula jigini Elizabet yaa weeni ayen, “Yɔgyɔgla de Nyɔnɔwa a bola maari mu kama. Wa yeeri mu m chivieŋa po a basi kama nuruba nimbie po.” ");
INSERT INTO bwu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabet puuka ale nya chiisa siyuebi la, Naawen a yaa tom wa sabiilowa Gabriel ayen wa cheŋ tɛŋ kaai ate ba a wi ayen Nazaret ate ka bo Galili la po. ");
INSERT INTO bwu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nipɔkbili wanyi ale jam bo dula ate ba a wi ayen Mɛɛri. Wa jam siak kama ayen wa yali nidɔa wanyi ate ba a wi wa ayen Josefi. Josefi a jam ka naawa Deevid ŋaaŋbiik. ");
INSERT INTO bwu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Sabiilowa a yaa jam weeni Mɛɛri ayen, “Suyɔgini a bo le fu. Nyɔnɔwa a bo ale fu kama ale niak fu me nna yegayega.” ");
INSERT INTO bwu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mɛɛri ale wom dii ate sabiilowa a weeni wa la, ku yaa daani wa nna yegayega ate wa poli wa wanni kiri ale ka dii la. ");
INSERT INTO bwu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Sabiilowa a yaa ŋman weeni wa ayen, “Mɛɛri, kan basi ate fi kpaziim a nagi, dii nyiŋ la Naawen niak fu kama. ");
INSERT INTO bwu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wa weeni kama ayen fi le yik puuk a biak nidɔabili. Fi dan jam biak biika, wa yoi ale Yeezu. ");
INSERT INTO bwu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Wa le jam chim ka nuru kpioŋ nna yegayega. Ba le wi wa ayen ka Naawen Kpeeni biik. Ti Nyɔnɔwa Naawen le bobi wa naam ase wa le jam bobi wa kokpieŋka Deevid naam buui dila po dila po dii la. ");
INSERT INTO bwu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Wa le jam soa wa kokpieŋka Jekob ŋaaŋbisaŋa meena a ta a cheŋ diipo meena wuu, ate wa naamu a kan maa kpeglim.” ");
INSERT INTO bwu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mɛɛri a yaa weeni sabiilowa ayen, “Mi a diem ze nidɔa. Ku be le nyɛ ka se ate m yik puuga?” ");
INSERT INTO bwu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Sabiilowa yaa weeni wa ayen, “Naawen le pa ka wa Chiika a nyo fi po abe wa pa wa pagrimu me a lik fu. Biik kaai ate fi ayen fi biak la, nuruba le wi wa ayen ka welensa nyɔnɔ ale Naawen biik me. ");
INSERT INTO bwu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Be teeri fi suoku Elizabet wari. Nuruba a weeni kama ayen wa ka kirik alege wa ale wa kpaŋsaŋa meena wa ta ka puuk chiisa siyuebi ale nna. ");
INSERT INTO bwu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Wari karo ate Naawen an baga a nyɛ.” ");
INSERT INTO bwu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mɛɛri yaa weeni ayen, “Naawen dek ale soa mu. Wa yaa be basi ate ku nyɛ ase fi ale weeni dii la.” Sabiilowa yaa deri basi wa ale cheŋ. ");
INSERT INTO bwu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mɛɛri yaa deri gomsi a cheŋ nna nwuli nwuli a cheŋ tɛŋ kanyi ate ka bo guuta sunsuŋ Judia tɛŋka po. ");
INSERT INTO bwu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Wa le ga paari ku jigini la, wa yaa cheŋ ga jo Zakaria yenni po ayen wa puusi Elizabet. ");
INSERT INTO bwu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabet ale wom Mɛɛri lueluku la, wa biika a yaa deri a labri ponni po. Naawen a yaa basi ate wa Chiika a sueri Elizabet sunummu. ");
INSERT INTO bwu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ate wa yaa weeni Mɛɛri ale lueluk kpioŋ ayen, “Naawen niak fu kama a gaam nipooba meena. Biik kaai ate fi le biak la, Naawen niak wa kama. ");
INSERT INTO bwu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ka boa ale soa ate wa kpeeni de a nyɛ mi jigiya ate mi Nyɔnɔwa ma a cheena ayen wa puusi mu? ");
INSERT INTO bwu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mi ale poom wom fi lueluku la, m biika a deri a labri kama ale supeentik. ");
INSERT INTO bwu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Fi ta supeentik kama, dii nyiŋ la fi ta siaka kama ayen dii ate ti Nyɔnɔwa Naawen weeni fu la a le sum nyɛ kama.” ");
INSERT INTO bwu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Dula jigini Mɛɛri yaa weeni ayen, “Mi a pagi Naawen ale ka m sunum meena. ");
INSERT INTO bwu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mi sui a peenti kama, ayen Naawen ka m varibasidɔ, ");
INSERT INTO bwu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","a teeri mi waai ale ka wa tomteerɔma po nuru fiik la wari. A ta nyini jinla danni a ta a cheŋ waai meena le kasim a wi mi ayen ka supeentik nyɔnɔ, ");
INSERT INTO bwu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","dii nyiŋ la Naawen kpeeni tom ka tuim kpeema a te mu. Wa yonni abe welema kama. ");
INSERT INTO bwu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Wa kasim ta jiirim kama ale baai meena ale a zuli wa la. ");
INSERT INTO bwu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wa jam pa ka wa pagrimu yegayegaka a yik kanjanta nyam ale ba wie nyeka popola meena a kaasi. ");
INSERT INTO bwu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wa yik nalim kpeema a yeeri ba naam po ale ge basi ate nuru baai ale kan ta zaana jigi la a ŋman taam de ba niŋ. ");
INSERT INTO bwu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wa be maari a te baai ate kom ta ba la ŋandiinta yegayega ale ge a basi ate baai ale jigsi la a chim ŋanjagsa. ");
INSERT INTO bwu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Wa maari tama wa tomteerɔma Izirali demma a yaa teeri ta jiirim ale Abraham ale wa ŋaaŋbisaŋa taam wuu ase wa ale jam puulim ale ti kokpieŋsaŋa ayen wa le nyɛ dila, a te ba la.” ");
INSERT INTO bwu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mɛɛri ale biisi nueri la wa yaa wari bo ale Elizabet a paari chiisa sita ale ge yaa ŋman kuli wa yenni. ");
INSERT INTO bwu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabet biamu danni ale jam paari la, wa yaa biak nidɔabili. ");
INSERT INTO bwu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wa dɔkdemma ale wa vaanchaama baai ale jam mɔata wa la, a yaa wom Naawen ale ta jiirim yegayega ale wa dii la ate ba meena ale wa a yaa jam ta supeentik nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Biika ale jam paari daa naaniŋ la nisomma yaa jam ba ale biak wa juijui la ayen ba gebi wa yoanni. Ba ale nyɛ dila a ga nueri la, ba yaa weeni ayen biika me yoi ale Zakaria, ase wa kowa la. ");
INSERT INTO bwu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Alege biika mawa a yaa zɛri ale weeni ba ayen, “Wa yonni ale Jɔɔn.” ");
INSERT INTO bwu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ba yaa weeni wa ayen, “Nama buuni po waai a karo a ta yoi dila.” ");
INSERT INTO bwu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ba yaa pa ba nisimaŋa a magsi a biisi wie ale biika kowa a bek wa ayen, “Fi a yaali ayen fi te biika yonni ayen ka boa?” ");
INSERT INTO bwu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakaria yaa weeni ba ayen ba ga ta jaab a jam ate wa ŋmarisi. Ba ale ta jaamu a jam la, wa yaa ŋmarisi jaamu zuk ayen, “Wa yoi ale Jɔɔn.” Nyaku de yaa deri cha ba nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Zakaria ale ŋmarisi a nueri la, wa yaa deri ŋman baga a biisi ate wa yaa te Naawen pimpauk. ");
INSERT INTO bwu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ba vaanchaama meena ale jam bo dula jigini a mɔata ba ate ba wom ale Zakaria a ŋman a biisi la, ba yaa jam a chali yɔgsum nna yegayega ate wapaani de wie a yaa tagli tɛŋ sii ale jam bo guutaŋa sunsuŋ Judia tɛŋka po la. ");
INSERT INTO bwu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Baai meena ale jam wom la, ku yaa cha ba ate ba yaa pa ku nyo ba suniima po a poli ku wie ale a bek chaab ayen, “Biika de ale chim ka nuru boan choa ase wa nin chimu?” Ba jam a bek wa nyaku de kama dii nyiŋ la, Nyɔnɔwa Naawen pagrimu a jam bo ale wa kama. ");
INSERT INTO bwu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Naawen Chiika a yaa jam sueri Jɔɔn kowa Zakaria ate wa biisi Naawen wieŋa. Wa yaa weeni ayen, ");
INSERT INTO bwu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ti Nyɔnɔwa waai ale ka tama Izirali Naawenni la, a jam tama jigi kama a vari ti a basi. Ni be basi ate ti a pak wa nyaku de nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Wa te ti ka nuru kpioŋ waai ale ka naawa Deevid ŋaaŋbiik la. Wa le chim ka ti varibasidɔ. ");
INSERT INTO bwu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Dila po dila po ate Naawen a weeni wa biisiteerɔma baai ate wa lueri a te wa dek la, ayen ba ŋmarisi wa gbaŋka po ayen, ");
INSERT INTO bwu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","wa puulim kama ayen wa le vari ti, ti dachaasa nisima po a basi ale baai ale kisi ti la nisima po a basi. ");
INSERT INTO bwu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Wa ŋman weeni ayen wa le ta jiirim ale ti kokpieŋsaŋa abe wa kan baŋ wa ale ba ale nyɛ noayeŋ kaai ale chaab ayen ba kasim chim wa dek wa nyiini nuruba la. ");
INSERT INTO bwu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Wa jam puulim ka nna pagrik pagriga a te ti kokpieŋka Abraham ayen wa Naawen le vari ti, ti dachaasa nisima po a basi ate ti a va wa Naawen abe ti kan a chali yɔgsum. ");
INSERT INTO bwu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ate tama ale chim nuru welensa ale wayɔrisima nyam wa jigi ti boka meena po a ta a cheŋ. ");
INSERT INTO bwu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","M biiga, nuruba le weeni ayen fi ka Naawen kpeeni biisiteerɔ, dii nyiŋ la fi le liŋ de ti Nyɔnɔwa niŋ a gomsi wa siuku a magsi te wa, ");
INSERT INTO bwu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","abe fi weeni ayen Nyɔnɔwa le voŋ wa nuruma tuimbaataŋa a te ba ate ba nya varibasika. ");
INSERT INTO bwu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Ti Naawenni ka jiirim yegayega nyɔnɔ. Tama, a nyɛ ase ti bo ka legi po ate kum yaa pa bu yisuŋku a ligi ti la. Naawen varibasika abe a nyɛ ase ka vari ale boro a veenti a yaa dak siuku a sak ti ayen ti baga a nya suyɔgini la.” ");
INSERT INTO bwu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Zakaria biika, Jɔɔn yaa chim zuak a pagra ale wa nyiŋ ale wa chiik a yaa basi wa yenni ale ge cheŋ jo sagini po a bo dula jigini a ta ga paari da dii dai dek ate wa nyini piilim boro a sak Izirali demma la. ");
INSERT INTO bwu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Da ŋala po na kpioŋku Siiza Agustusi ale jam soa dula jigini meena a nya. Wa yaa jam a yaali ayen wa chiini a nya nuruba dii ale jam bo wa tɛŋka Aroom ale tɛŋ sii meena ate Aroom tɛŋka soa la. ");
INSERT INTO bwu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Chiinika de a jam ka piilim chiinika a magsi chaab ale diipo ate Kurinius a jam chim Siriya gomina la. ");
INSERT INTO bwu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Waai meena yaa jam cheŋ ba dek tɛŋsa ayen ba chiini ba. ");
INSERT INTO bwu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josefi yaa basi Nazaret tɛŋka ate ka bo Galili tɛŋka po la a yaa cheŋ tɛŋ kaai ate ba a wi ayen Betilihem ate ka bo Judia tɛŋka po la. Ba jam a wi Betilihem ayen ka Deevid tɛŋ. Josefi a jam cheŋ dula jigini kama ayen ba maa chiini wa dii nyiŋ la wa jam ka naawa Deevid waai ate ba jam biak dula jigini dila po dila po la, ŋaaŋbiik. ");
INSERT INTO bwu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mɛɛri waai ale jam siak ayen wa yali wa la a jam ta ka wa poklari puuka ale ge va wa cheŋ la. ");
INSERT INTO bwu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ba ale jam bo Betilihem tɛŋka po la, wa biamu danni a yaa paari, ");
INSERT INTO bwu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","tɛŋ kala po, wa yaa biak wa poklari biamu nidɔabili a yaa pa garuk a pili wa a dueni daka dii po ate ba pa duŋsaŋa ŋandiintaŋa a nyoro ate si a ŋobi la, dii nyiŋ la nichamma dɔkku jam sueri kama ate ba a te ba zoŋ ayen ba goa. ");
INSERT INTO bwu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Naapeerisa yaa jam bo goanni po a mɔata dula jigini a limsi ba piisa yok kula. ");
INSERT INTO bwu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Naawen sabiilo a yaa jam pa wa dek a sak ba ate Naawen nyagsika a yaa deri nyagsi gilim ba meena ate yɔgsum yaa deri yik ba nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Sabiilowa yaa weeni ba ayen, “Ni kan chali yɔgsumɔa. Nyɔnɔwa Naawen ale tom mu ayen m ta wamaŋsa ŋaai le ŋa nyɛ ate nuru meena sui peenti nna yegayega la, a jam weeni a sak ni. ");
INSERT INTO bwu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Jinla yokku ba biak ka nidɔabili naawa Deevid tɛŋka Betilihem po. Ba biak wa ayen wa chim ka nama ale waai meena Nyɔnɔ ale Varibasidɔ. Wa ka Kirisitawa waai ate Naawen le tom ate wa jam la. ");
INSERT INTO bwu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ni yiri cheŋ dula jigini a ga nya biika ate ba pa garuku a pili wa dueni dakanni po la. Ni dan nya biika, nyaku de le basi ate ni miŋ ayen dii ate mi a weeni ni la ka wensie.” ");
INSERT INTO bwu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Sabiilowa ale biisi ga nueri la, sabiiloba yegayega a yaa deri nyini wenŋmazuk a jam gum wa po ate ba meena a yaa yi yiili a pak Naawen ayen, ");
INSERT INTO bwu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ni basi ate ti te Naawen waai ale bo wenŋmazuk la, zula yegayega. Wala ale a te baai ale bo tɛŋzuk de ate wa sui peenti ale ba la suyɔgini.” ");
INSERT INTO bwu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sabiiloma ale yi ba yiini a nueri la, ba yaa ŋman yiri jueli wenŋmazuk. Dula jigini naapeerisaŋa yaa weeni chaab ayen, “Ni basi ate ti cheŋ Betilihem tɛŋka po a ga nya wa dii ate ti Nyɔnɔwa weeni sak ti la.” ");
INSERT INTO bwu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ba yaa deri yiri nyɛ nwuli cheŋ ga nya Mɛɛri ale Josefi ale biika ale wa dua dakari po. ");
INSERT INTO bwu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Naapeerisaŋa ale nya biika la, ba yaa weeni Josefi ale Mɛɛri dii ate sabiilowa weeni ba biika wie la. ");
INSERT INTO bwu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Dii ate naapeerisaŋa weeni la, a yaa deri cha baai meena ale jam wom la. ");
INSERT INTO bwu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mɛɛri yaa deri ta wieŋa de a teeri ŋa ale poli ŋa wie nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Naapeerisaŋa yaa ŋman cheŋ ba piisaŋa jigini. Ba ale jam bo siuku po a cheŋ la, ba yaa jam a biisi a pak Naawen a te wa zula wie ŋaai ate ba wom ale ge nya me la nyiŋ. Wieŋa de a sum jam ka wa ŋaai meena ate Naawen sabiilowa a weeni sak ba la. ");
INSERT INTO bwu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Biika ale jam paari da naaniŋ la, ba yaa gebi wa yoanni ale ge a yaa wi wa yonni ayen Yeezu. Yonni de ate Naawen sabiilowa a te wa ale ge ate wa mawa yik puuka la. ");
INSERT INTO bwu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Da dii danni ate Mɛɛri ayen wa cheŋ a ga nyɛ wa biamu welensa kaabka ase Moosis Sinsaŋŋa ale a weeni dii la, Josefi ale wa a yaa pa Yeezu ate ba cheŋ Jerusalem tɛŋka po ayen ba pa biika a sak Naawen dula jigini. ");
INSERT INTO bwu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ba jam ŋmarisi Naawen gbaŋka po kama dila po dila po ayen, “Kaliak a dan jam biak wa poklari biik, nidɔabili, ka Naawen ale soa nidɔabili dila.” ");
INSERT INTO bwu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Sinsaŋŋa me a sak kama ayen ku a fe kama me ayen ba ko nangbaŋsa siye a nyɛ nipowa biamu welensa kaabka, Josefi ale Mɛɛri ale ba biika ale jam cheŋ ayen ba nyɛ dii la ale la. ");
INSERT INTO bwu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nuru wanyi ale jam bo Jerusalem ate ba a wi wa ayen Simeyon. Wa jam ka nuru maŋ ale a va Naawen nalimnyiini ate Naawen Chiika jam bo ale wa. Wa jam a limsi ka da dii dai dek ate Naawen ayen wa tom waai le wa jam vari Izirali demma a basi la. ");
INSERT INTO bwu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Naawen Chiika ale jam puulim ale wa ayen wa kan kpi ase ka wa nin nya Kirisitawa waai ate Naawen dek a weeni ayen wa le tom da yeŋ ate wa jam la. ");
INSERT INTO bwu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Josefi ale Mɛɛri ale biika Yeezu ale ga paari Jerusalem tɛŋka po la, ba yaa cheŋ ga jo Juuma Puusika Yenni po ayen ba nyɛ dii ate Naawen gbaŋka po a weeni la. Ba ale ga jo la, ba yaa nya Simeyonwa de ate Naawen Chiika a dari wa a ta jam dula jigini. ");
INSERT INTO bwu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeyon yaa tuesi biika nyo wa nisima po a pak Naawen a weeni ayen, ");
INSERT INTO bwu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“M Nyɔnɔ, jinla, fi nyɛ dii ate fi puulim ayen fi le nyɛ la kama. Yɔgyɔgla de fi yaa le basi ate mi fi tomteerɔwa kpi ale suyɔgini, ");
INSERT INTO bwu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","dii nyiŋ la, mi dek nya waai le wa vari nuruba basi la kama. ");
INSERT INTO bwu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Be ka fi ale gomsi wa a magsi ate nuru meena tɔgatɔga a yaa nya. ");
INSERT INTO bwu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Wa le nyɛ ase ka bolim ate ba tɔati zaani la. Wa le sak baai ale kan daa Izirali dem la ate ba a va fi wensie siuku abe wa zak Izirali demma baai ate fi lueri te fi dek ayen ba chim fi nuruba la zuima zaani.” ");
INSERT INTO bwu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Biika kowa ale wa mawa ale wom dii ate Simeyon a biisi biika wie la, ku yaa cha ba nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeyon a yaa te ba niaka ale weeni biika mawa Mɛɛri ayen, “Ka Naawen ale tom biika de ayen wa jam basi ate Izirali demma yegayega a nya kaasuŋ, abe wa basi ate ba yegayega me a nya varibasika. Naawen le tom wa ate wa dak wensie siuku a sak nuruba alege nuruba yegayega le zɛri wa kama, ");
INSERT INTO bwu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Abe ba tɔk ba wasusuŋŋa a lagri. Fi dek sunum po le kaasi ate fi nya ninam nna yegayega nna se ba pa ka gebi woŋ a chubi fi sunum vuri la.” ");
INSERT INTO bwu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Naawen biisiteerɔ ale jam boro ate ba a wi wa ayen Ana. Wa jam ka nuru waai ate ba a wi ayen Fanuel la, le. Fanuel jam nyini ka nuru baai ate ba a wi ba ayen Asɛ la, buuni po. Ana ale jam yali wa chorowa la, ba jam bo ale chaab ka bena ŋayopoi ale ge ate wa chorowa a kpi. Ale ge ate wa yaa chim pukogi a ta bena pinaanuŋ ale ŋanaansi. Wa kasim a jam bo ka Juuma Puusika Yenni po ale kan nyini peelimɔa. Yok ale kantueŋ meena, wa jam kasim a zuli ka Naawen ale a bobi noai a puusi Naawen. ");
INSERT INTO bwu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Josefi ale Mɛɛri ale jam boro a biisi ale Simeyon la, Ana yaa jam gum ba po. Wa le nya biika la, wa yaa te Naawen jiam wa nyiŋ a yaa ale ge basi ba ale cheŋ ga weeni Jerusalem demma baai meena ale jam a limsi ayen Naawen vari ba a basi la, biika wie. ");
INSERT INTO bwu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josefi ale Mɛɛri ale nyɛ dii ate Naawen gbaŋka po a weeni ba a nueri la, ba yaa basi Jerusalem tɛŋka ale pilim ŋmani cheŋ ba dek tɛŋka Nazaret ate ka bo Galili tɛŋka po la. ");
INSERT INTO bwu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Biika yaa chim a ta pagrim ale yam nna yegayega ate Naawen jam a niak wa. ");
INSERT INTO bwu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bena meena Juuma Gaambasika Tigini a dan paari, Yeezu kowa ale wa mawa nyiem a cheŋ ka Jerusalem tɛŋka a ga maari a de ");
INSERT INTO bwu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yeezu ale jam paari bena pi ale ŋaye la, wa kowa ale wa mawa ale wa a yaa va chaab a cheŋ ayen ba maa de ase ba kisiku ale a weeni dii la. ");
INSERT INTO bwu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ba tigini daaŋa ale jam nueri la, wa nyamma a yaa basi tɛŋ kala ayen ba kuli. Ba ale jam a kuli la, ba jam ze ayen ba biika, Yeezu, a jam wari bo ka Jerusalem. ");
INSERT INTO bwu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ba jam a poli ayen wa maa bo ka nuruma po. Ba ale jam a cheŋ ate wenni a siŋ la, ba yaa nyiem bo ba mabisaŋa ale nuru baai ate ba seba la po a gisi wa. ");
INSERT INTO bwu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ba ale gisi wa nuruma po a kpeeri la, ba yaa ŋmani a cheŋ Jerusalem tɛŋka po ayen ba gisi wa boka jigi dula jigini. ");
INSERT INTO bwu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Daa ŋata ale jam paari la, ba yaa nya wa ale wa bo Juuma Puusika Yenni po. Wa ale Juuma sagrɔma ale jam kala ale chaab ate wa yaa a wom ba, ale a bek ba bega. ");
INSERT INTO bwu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ba me a jam a bek wa ka bega. Baai meena ale jam bo dula jigini la a wom wa ale a tulisi ba ale yam dii la kama. Ku yaa cha ba. ");
INSERT INTO bwu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Wa nyamma ale ga nya wa la, ku yaa deri cha ba nna yegayega. Wa mawa a yaa bek wa ayen, “M biiga, ka boa ate fi nyɛ tama dila. Ku daani fi kowa ale mi kama nna yegayega ate ti a gisi fu.” ");
INSERT INTO bwu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Wa yaa weeni ba ayen, “Ka boa ate nama a nyiem a gisi mu? Nama ze ayen ku magsi kama ate m bo m kowa yenni po?” ");
INSERT INTO bwu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Alege wa nyamma an jam miŋ wa le weeni ba dii la kiriya. ");
INSERT INTO bwu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yeezu a yaa yiri ate wa ale ba a va chaab a ŋmani cheŋ Nazaret tɛŋka ate wa yaa siak ba noai dula jigini ase wa nyiem ale a nyɛ dii la. Wa mawa yaa pa dii meena ale nyɛ la a nyo wa sunum po ale ta ŋa a teeri. ");
INSERT INTO bwu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yeezu yaa chim a pak a yaa ta yam a gum du ale a nyɛ ate Naawen ale nuruba sue a peenti. ");
INSERT INTO bwu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nakpioŋku Tiberiusi Siiza ale jam de wa naamu a paari bena pi ale ŋanu la, Pontios Paalɔt me jam chim ka Judia gomina, ate Ayerod me chim Galili Naab, ate wa suoku me Filip, a jam soa Ituriya ale Takonitisi tɛŋsaŋa a nya, ate Lisaniasi me a jam soa Abilene tɛŋka me a nya. ");
INSERT INTO bwu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasi ale Kayafas ale jam chim Juuma Puusika Yenni kpagi kpeemaŋa, dila powa, Zakaria biika Jɔɔn a jam bo ka sagini po. Naawen yaa biisi ale Zakaria biika Jɔɔn goanni po. ");
INSERT INTO bwu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jɔɔn a yaa nyiem a gilim tɛŋ sii meena ale kali Jodan benni noai la a sak nuruba a weeni ba ayen, “Ni meena basi ni tuimbaataŋa abe ni va Naawen siuku. Ni dan tagri, m le te ni soka ate Naawen a voŋ ni tuimbaataŋa a te ni.” ");
INSERT INTO bwu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ase Azaya Naawen biisiteerɔwa ale ŋmarisi Naawen gbaŋka po dii la ayen, “Lueluk ale a kaari sagini po a weeni ayen, ‘Ni gomsi Nyɔnɔwa siuku abe ni teenti ku. ");
INSERT INTO bwu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ni sueri golaŋa meena ate ŋa magsi chaab. Kunkutimaŋa ale guutaŋa meena a magsi chaab ale tɛŋka. Ni yuarisi siuk tii meena ale goalim la, siuk tii meena ale ta tintana la, ni gomsi ti ate ti soa ase chaab la, ");
INSERT INTO bwu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ate nurubiik meena a yaa nya Naawen Varibasika.’ ” ");
INSERT INTO bwu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nuru bɔari a yaa nyini jam Jɔɔn jigi ayen wa te ba soka. Jɔɔn yaa weeni ba ayen, “Ni a nyɛ ase ka waapiisa la. Ka wana ale weeni ni ayen ni baga a chali a nyini waali kaai ate Naawen za wa te ni la po? ");
INSERT INTO bwu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ni be a tom tuim ŋaai ale ŋa sak ayen ni basi ni tuimbaataŋa tomka kama la, abe ni kan a weeni ni dek ayen, ‘Abraham ka tama ko.’ Ni basi ate m weeni a sak ni ayen Naawen baga pa tintanaŋa de kama a nyɛ ate ŋa a chim Abraham ŋaaŋbisa. ");
INSERT INTO bwu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ni nya liaka abe gomsi magsi ayen ka che tiimu kinni naŋsaŋa kama. Ti sii meena me ale kan a yoani yoan maŋsa la, ka le gebi si kama a lonsi tɛŋ, ate ba pa si a yuk basi bolim po.” ");
INSERT INTO bwu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nuruma a yaa bek Jɔɔn ayen, “Yɔgyɔgla de, ti be le nyɛ ka se?” ");
INSERT INTO bwu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wa yaa tulisi ba ayen, “Waai a dan ta gatta tiye, ku a fe kama ayen wa pa kunyi a te waai ale kan ta garuk la. Waai me abe ale ta ŋandiinta la, ku a fe kama ayen wa me nyɛ wa ŋandiintaŋa gela a te waai ale kan ta ŋandiinta a de la.” ");
INSERT INTO bwu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Lampoo cheesiroba ba gela ale maa jam ayen ba tuesi soka. Ba me yaa bek Jɔɔn ayen, “Ti Sagrɔ, tama me abe ale nyɛ ka se?” ");
INSERT INTO bwu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Wa yaa tulisi ba me ayen, “Ku a fe kama ayen ni kan tuesi nuruba ligra a gaam ba ale weeni ni ayen ni tuesi dii la.” ");
INSERT INTO bwu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sojiba ba gela me a jam bek wa ayen, “Tama me abe ti nyɛ ka se?” Wa yaa tulisi ba me ayen, “Ku a fe kama ayen ni kan vari nuru jaabɔa, a yaase ni velim a te wa a tuesi wa jaabɔa, ku a fe kama ate ni basi ate ni nina sueri ale ni tutunaŋa.” ");
INSERT INTO bwu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nuruma ale wom dila la, ku yaa deri cha ba ate ba deri ta yiila a poli ayen da dii dai Jɔɔn ka Kirisitawa waai ate Naawen le tom ate wa jam la. ");
INSERT INTO bwu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Alege Jɔɔn yaa tulisi ba meena ayen, “Mi a te ni soka ale ka nyiam nyiini, alege nuru ale bo ŋaaŋ cheena. Wa ta pagrim gaam mi. Mi posima ale m nin chim waai ale wa domsi a kali wa niŋ a yeeri wa nuensaŋa a te wa la. Nuru wala ale cheena la, wa le pa ka Naawen Chiika ale bolim a sueri ni suniimaŋa. ");
INSERT INTO bwu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wa gomsi magsi kama ayen wa yali wa zaaŋa. Wa dan yali nueri, wa le tali zabeeŋa nyo wa bunni po abe wa yaa ju vottaŋa ale bolim buui ale kan a kpimsi la.” ");
INSERT INTO bwu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jɔɔn jam magsi ka wie ŋa chaab nna yegayega ase nna la, a sak nuruma Naawen wamaŋsaŋa wie. ");
INSERT INTO bwu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Alege da yeŋ ate Jɔɔn tɔariŋ naab Ayerod nuruma nimbie po ayen ka boa ale soa ate wa faari wa suoku powa Ayerodiasi, ale maara tom tuimbaata ti chaab me a gum du. ");
INSERT INTO bwu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Dii ate Ayerod a nyɛ ate di ŋmasi bie la ale wa ale yik Jɔɔn a lik la. ");
INSERT INTO bwu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nuruma meena ale jam boro a tuesi soka la, Yeezu a jam maa tuesi soka kama. Yeezu yaa boro a puusi Naawen ate wenŋmazuku a deri lagri, ");
INSERT INTO bwu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ate Naawen Chiika a siŋ jam wa zuk ase nangbaŋ la, ate lueluk a yaa nyini wenŋmazuku po a weeni Yeezu ayen, “Fi ale m dek biik. Mi a yaali fu ka nna yegayega. M sui peenti ale fu kama.” ");
INSERT INTO bwu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yeezu a jam a nyɛ ase ka bena pisita la alege yaa piilim wa sinsaŋŋa. Nuruba jam a poli kama ayen Yeezu kowa ale Josefi. Yeezu buuni po abe ale ka dii la ale nna: Josefi kowa ale Ayeli. Ayeli kowa ale Matati. ");
INSERT INTO bwu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matati kowa ale Livai. Livai kowa ale Meliki. Meliki kowa ale Janai. Janai kowa ale Josefi. Josefi kowa ale Matatiasi. ");
INSERT INTO bwu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatiasi kowa ale Amos. Amos kowa ale Nayum. Nayum kowa ale Ɛzli. Ɛzli kowa ale Nagai. Nagai kowa ale Maat. ");
INSERT INTO bwu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maat kowa ale Matatiasi. Matatiasi kowa ale Semein. Semein kowa ale Josek. Josek kowa ale Joda. Joda kowa ale Joanan. ");
INSERT INTO bwu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joanan kowa ale Aresa. Aresa kowa ale Zerubabel. Zerubabel kowa ale Sealtiel. Sealtiel kowa ale Neri. Neri kowa ale Meliki. ");
INSERT INTO bwu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Meliki kowa ale Addi. Addi kowa ale Kosam. Kosam kowa ale Ɛlimadam. Ɛlimadam kowa ale Ɛri. Ɛri kowa ale Josua. ");
INSERT INTO bwu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Josua kowa ale Ɛlieza. Ɛlieza kowa ale Jorim. Jorim kowa ale Matati. Matati kowa ale Livai. Livai kowa ale Simeyon. ");
INSERT INTO bwu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simeyon kowa ale Juda. Juda kowa ale Josefi. Josefi kowa ale Jonam. Jonam kowa ale Eliakim. Eliakim kowa ale Melea. ");
INSERT INTO bwu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Melea kowa ale Mena. Mena kowa ale Mataata. Mataata kowa ale Natan. Natan kowa ale Deevid. Deevid kowa ale Jese. ");
INSERT INTO bwu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jese kowa ale Obed. Obed kowa ale Boazi. Boazi kowa ale Salimon. Salimon kowa ale Naason. Naason kowa ale Aminadab. ");
INSERT INTO bwu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadab kowa ale Ademin. Ademin kowa ale Arini. Arini kowa ale Ayeziron. Ayeziron kowa ale Perezi. Perezi kowa ale Juda. Juda kowa ale Jekob. ");
INSERT INTO bwu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jekob kowa ale Aizik. Aizik kowa ale Abraham. Abraham kowa ale Tɛra. Tɛra kowa ale Nayo. Nayo kowa ale Serug. ");
INSERT INTO bwu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serug kowa ale Areu. Areu kowa ale Peleg. Peleg kowa ale Ɛba. Ɛba kowa ale Sɛla. Sɛla kowa ale Kenan. ");
INSERT INTO bwu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kenan kowa ale Afakasad. Afakasad kowa ale Sɛm. Sɛm kowa ale Nowa. Nowa kowa ale Lamek. Lamek kowa ale Metusela. ");
INSERT INTO bwu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Metusela kowa ale Ɛnok. Ɛnok kowa ale Jared. Jared kowa ale Mayalale. Mayalale kowa ale Kenan. Kenan kowa ale Ɛnos. ");
INSERT INTO bwu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ɛnos kowa ale Sɛti. Sɛti kowa ale Adam. Adam kowa ale Naawen. ");
INSERT INTO bwu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yeezu yaa nyini Jodan benni jigini a ŋman jam ate Naawen Chiika a sueri wa sunummu a yaa ta wa cheŋ ga jo sagini po, ");
INSERT INTO bwu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","juijui ate Sitaana jam pa da pisinaansi meena a nyɛ wa nya la. Da pisinaansi wa de meena wa an jam de jaabjaabɔa. Da ŋala meena ale jam taam la kom nna yegayega ale jam ta wa. ");
INSERT INTO bwu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Wa ale jam bo sagini po an de jaabjaab la Velinvendika yaa weeni wa ayen, “Fi dan sum ka Naawen biik, be nyɛ ate tintanni de a tagri chim boroboruk a te fu,” ");
INSERT INTO bwu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yeezu yaa tulisi ayen, “Ba ŋmarisi Naawen gbaŋka po kama ayen, ‘Nurubiik an boro ka ŋandiinta nyiini nyiŋa.’ ” ");
INSERT INTO bwu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Yeezu ale tulisi dila la, Velinvendika yaa zak wa a ta jueli ŋmazuk a deri sak wa tɛŋzuk meena tɛŋsaŋa ale soa dii la, ");
INSERT INTO bwu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ale weeni wa ayen, “M le te fu pagrim ate fi soa tɛŋzuk de meena ale jigsika meena. Naawen ale pa ku meena a nyo m nisima po. M baga kama pa a te waai dek ate mi a yaali la. ");
INSERT INTO bwu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Fi dan siak a te mu zula, m le pa ku meena a te fu.” ");
INSERT INTO bwu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yeezu yaa ŋman tulisi ayen, “Ba ŋmarisi Naawen Gbaŋka po ayen, ‘Ku a fe kama ayen ni a te Nyɔnɔwa ni Naawenni nyiini zula abe ni a tom a te wala nyiini.’ ” ");
INSERT INTO bwu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Velinvendika yaa ŋman ta wa a cheŋ Jerusalem tɛŋka a ta wa ga jueli kali Juuma Puusika Yenni zuk nna niŋniŋa a yaa weeni wa ayen, “Fi dan sum ka Naawen biik, nyini dula jigini a yok zi tɛŋ, ");
INSERT INTO bwu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","dii nyiŋ la, ba ŋmarisi Naawen Gbaŋka po ayen, ‘Naawen a le basi ate wa sabiiloma a nya fi zuk.’ ");
INSERT INTO bwu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ba ŋman ŋmarisi ayen, ‘Sabiiloma le yik fu kama nalimnyiini ate fi zi ale ge tanaŋa kan te fu tuem.’ ” ");
INSERT INTO bwu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Alege Yeezu yaa tulisi Velinvendika ayen, “Ba ŋmarisi Naawen Gbaŋka po ayen, ‘Kan nyɛ fi Nyɔnɔwa fi Naawenni a nya.’ ” ");
INSERT INTO bwu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Velinvendika ale nyɛ wa nya a nueri la, wa yaa basi Yeezu alege a limsi da dii danni ale magsi la ate wa ŋman nyɛ wa a nya. ");
INSERT INTO bwu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yeezu yaa basi dula jigini ale pilim ŋman cheŋ Galili tɛŋka ale Naawen Chiika pagrimu. Nuru meena tɛŋ kala po a jam wom Yeezu wie kama. ");
INSERT INTO bwu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Wa jam nyiem cheŋ ba tuka diinaŋa po kama a sak nuruma ate ba meena jam a te wa pimpauk nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Wa yaa cheŋ wa dek tɛŋka Nazaret juijui ate wa chim la, a yaa ga jo ba tuka dɔkku po ba Vuusum Danni ase wa nyiem ale poom a nyɛ dii la. Wa yaa yiri zaani ayen wa karim Naawen gbaŋka. ");
INSERT INTO bwu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ba yaa pa ka geli juijui ate Azaya Naawen biisiteerɔwa ŋmarisi la a te wa ate wa lagri ka a nya juijui ate ku ŋmarisi ayen, ");
INSERT INTO bwu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ti Nyɔnɔwa Chiika a bo ale mu kama, dii nyiŋ la, wa lueri mu kama ayen m pa Naawen wamaŋsaŋa a sak baai ale ka ŋanjagsa la. Wa tom mu me kama ayen m ga weeni niwomma, baai ate pagrɔba a yik ba kpaliŋ po a ta ba la ayen ba nya vuusum kama, abe m weeni yeeba ayen Naawen nyɛ kama ate ba ninaŋa lagri, abe m weeni baai me ate nuruba basi ate ba a nam la ayen Naawen nyɛ ate ba nya vuusum kama, ");
INSERT INTO bwu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","abe m weeni ayen diipo ate Naawen le ta varibasika jam te wa nuruma la a jam kama.” ");
INSERT INTO bwu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yeezu ale karim nna a nueri la, wa yaa yik gbaŋka lik ale pa te nuru waai ale pa ka a te wa la ale ge kali tɛŋ, ate ba yaa kasim a nya wa nna ziim. ");
INSERT INTO bwu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yeezu yaa piilim biik a weeni ba ayen, “Jinla danni, nama dek abe ale wom Naawen Gbaŋka karuŋku de la, ku sum chim ka wensie.” ");
INSERT INTO bwu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Waai meena ale wom wa wieŋa de la, ba yaa pak wa. Ku jam cha ba ka nna yegayega ale wie ŋaai ale jam nyini wa noai po a nyini la ate ba yaa bek chaab ayen, “Daa Josefi biika ale nna?” ");
INSERT INTO bwu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Alege Yeezu yaa tulisi ba ayen, “M seba chak kama ayen ni le weeni mu wamagsini de ayen, ‘Tiim nyɔnɔ, tebi fi dek.’ Ni le weeni mu ayen ni wom dii meena ate m nyɛ Kapernaum tɛŋka po la kama. Ku be magsi ka fi nyɛ dila fi dek tɛŋka po.” ");
INSERT INTO bwu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yeezu ale miŋ ba popolaŋa la, wa yaa weeni ba ayen, “Wensie ate mi a weeni ni nyaku de ayen nuru dan weeni ayen wa ka biisiteerɔ, wa dek tɛŋ demma a kan yaali wa nyummɔa. ");
INSERT INTO bwu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Ni basi ate m weeni a sak ni ayen, diipo ate Naawen biisiteerɔwa Elaja jam boro la, pukoga yegayega ale jam bo Izirali tɛŋka. Dii po ate ŋmoruku an jam ni ate ku paari bena ŋata ale chiisa siyuebi la, kom kpiem ale jam bo tɛŋka meena po. ");
INSERT INTO bwu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Alege Naawen an jam tom Elaja nya ba de waai jigiya. Wa jam tom wa ka pukogi dinyi jigi ate wa bo Zarefat tɛŋka po ate ka bo Saidon tɛŋka po la. ");
INSERT INTO bwu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ni basi ate m ŋman weeni a sak ni ayen diipo ate Naawen biisiteerɔ wa choawa Ɛlaisa a jam boro la, gama nna yegayega ale jam bo Izirali tɛŋka po alege ba wanyi la an jam nya nyiŋyɔgsa, ka dinyi nyiini waai ate ba a wi ayen Naaman ate wa nyini Siriya tɛŋka la, ale jam nya nyiŋyɔgsa.” ");
INSERT INTO bwu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Waai meena tuka dɔkku po ale wom wieŋa de meena la, ku yaa te ba supuurim nna yegayega, ");
INSERT INTO bwu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ate ba yaa dari wa a ta nyini tɛŋka po a nyini a yaa ta wa jueli guuk kuui zuk ate ba tɛŋka a jam za la. Ba jam poli kama ayen ba yuk wa ate wa nyini guuku zuk a siŋ lo tɛŋ, a kpi. ");
INSERT INTO bwu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Alege ku ŋaaŋnyiŋ ate wa yaa va nuruma sunsuŋ a nyini cheŋ. ");
INSERT INTO bwu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Wa jam cheŋ ka Kapernaum tɛŋka ate ka bo Galili tɛŋka po me la. Ba Vuusum Danni ale jam paari la, wa yaa sak ba. ");
INSERT INTO bwu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Wa sinsaŋŋa jam cha ba kama, dii nyiŋ la ŋa ta ka pagrim ŋa po. ");
INSERT INTO bwu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nuru ale jam ta chichiribiok wa zukku po a maa bo tuka dɔkku po, a yaa kaari nna yegayega a weeni ayen, ");
INSERT INTO bwu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yeezu Nazaret denowa, fi a yaali ka boa ti jigiya? Fi jam ayen fi kaasi ti kama? M seba fi ale ka waai la kama, fi ka Naawen nuru weleŋka.” ");
INSERT INTO bwu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Alege Yeezu weeni chichiribioku ayen, “Goori abe fi nyini wa zukku po a nyini.” Chichiribioku yaa deri chiak nuruwa a pa fobi tɛŋ waai meena niŋ alege ate ku nyini wa zukku po a nyini. Ku an jam te nuruwa tuem. ");
INSERT INTO bwu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Waai meena ale nya dila la, ku yaa cha ba nna yegayega ate ba yaa bek chaab ayen, “Ka boan jaab sinsaga ale nna? Ni nya nuruwa de ale ta pagrim a baga a weeni chichiribaata nuruba zuima po ate ti a nyini?” ");
INSERT INTO bwu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Baai meena ale jam kala a gilim Kapernaum tɛŋka la, a jam wom Yeezu ale tom dii la kama. ");
INSERT INTO bwu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yeezu yaa basi tuka dɔkku alege cheŋ ga jo Simon yenni. Wa ale ga jo yenni po la, ba yaa weeni wa ayen ka Simon ŋanuba ale a yuak. Wa nyiŋka a jam toliŋ ka nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yeezu yaa jo wa jigi a zaani wa tɛŋ a yaa weeni nyiŋtuilaŋa ale nin muna ayen ŋa basi wa. Wa ale weeni dila la, nyiŋtuilaŋa a yaa basi wa ate wa yaa deri yiri yaali nyiam a te ba. ");
INSERT INTO bwu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Wein ale jam boro a siŋ la, nuru baai ale jam ta nuruba ate tueta tɔgatɔga a jam ta ba la a yaa pa ba meena a ta jam Yeezu jigi ate wa pa wa nisaŋa a vi ba meena zuk ate ba meena yaa nya nyiŋyɔgsa. ");
INSERT INTO bwu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Chichiribaata me a jam nyini ba yegayega zuima po a nyini a kaari a weeni ayen, “Yeezu, fi ka Naawen biik!” Alege Yeezu jam weeni si kama ale nin muna ayen si nyini. Wa an jam te si siuk ayen si weeni wari ya dii nyiŋ la, chichiribaata a jam seba kama ayen wa ka Varibasidɔwa waai ate Naawen le tom ate wa jam la. ");
INSERT INTO bwu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Vanni ale ga veenti la, wa yaa yiri cheŋ juijui ate nuru karo la. Alege nuruma a diem gisi nya wa a jam wa jigi a lik wa tara, kan siak ayen wa basi ba, ");
INSERT INTO bwu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","alege wa yaa weeni ba ayen, “Ku a fe kama ayen m cheŋ tɛŋsa si chaab a ga sak Naawen wamaŋsaŋa wie ate ba me wom, dii nyiŋ la ka dila nyiŋ ate wa tom mu.” ");
INSERT INTO bwu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yeezu yaa nyiem gilim Juuma tɛŋsaŋa meena tuka diinaŋa po a sak Naawen wamaŋsaŋa. ");
INSERT INTO bwu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Dai yeŋ ate Yeezu jam za Genesaret mogi kpeeni noai a sak nuru bɔari. Nuru bɔanni ale jam a tusi chaab ayen ba wom Naawen wamaŋsaŋa la, ");
INSERT INTO bwu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yeezu yaa nya ale ŋaarunta tiye a za mogini noai. Jum yigrisa ale jam soa ti a yaa pa ti zaani alege ga boro a sugri ba ŋmaasaŋa. ");
INSERT INTO bwu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Wa yaa jo kali ŋaaruŋ kuui po ate Simon soa la, a yaa weeni wa ayen wa dam ku ate ku siŋ nyiamu po magla. Simon yaa dam ku ate ku siŋ nyiamu po magla ate Yeezu yaa kali ku po alege a sak nuruma. ");
INSERT INTO bwu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wa ale biisi nueri la, wa yaa weeni Simon ayen ba dam ba ŋaaruntaŋa a siŋ liŋku po a yuk ba ŋmaasaŋa ale ba le yik juma. ");
INSERT INTO bwu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon yaa tulisi wa ayen, “M Nyɔnɔ, yokku meena tama kasim a yuk kama alege ti an yik jaabjaabɔa. Alege fi dan weeni dila, mi le yuk nya.” ");
INSERT INTO bwu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ba yaa yuk basi nyiamu po a yik juma nna yegayega a gaam taam ate ba ŋmaasaŋa tali maga ate si cheeri. ");
INSERT INTO bwu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ba yaa kamsi wi ba vaanchaama ale bo ŋaaruŋ kuŋkula po la ayen ba jam a maa maari ba. Ba ale jam la, ba yaa maa chaab a vaari jumaŋa a sueri ŋaarunta tiyewa ate ti jam tali maga ate ti siŋ nyiamu tɛŋ. ");
INSERT INTO bwu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Piita ale jam nya dii ale nyɛ la, wa yaa kpi duna tɛŋ Yeezu niŋ a weeni wa ayen, “Basi mu m dek nyiini, m Nyɔnɔ, dii nyiŋ la, mi ka tuimbaata nyɔnɔ.” ");
INSERT INTO bwu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","10","Wa weeni dila kama dii nyiŋ la, ku jam cha wa ale wa dɔama kama. Ku jam cha wa jum yigri chaama Zebedi bisaŋa kama, Jeemsi ale Jɔɔn. Alege Yeezu a weeni Simon ayen, “Kan chali yɔgsum, a ta nyini jinla a cheŋ, mi a te fu ka tuim paali, ayen fi nyɛ ate nuruba a jam va mu.” ");
INSERT INTO bwu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ba ale dam ba ŋaaruntaŋa a jueli kuŋkɔŋini la, ba yaa basi jaab meena ale ge va Yeezu. ");
INSERT INTO bwu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tɛŋ kanyi ate nuru jam ta gama tuem. Nuru wa ale nya Yeezu la, wa yaa kpi duna tɛŋ wa niŋ a saalim wa ayen, “M dek nyɔnɔ, fi dan siak, fi baga a tebi mu kama ate mi a nya nyiŋyɔgsa.” ");
INSERT INTO bwu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yeezu yaa teeri wa nisaŋa a tiri wa ale weeni ayen “M siak ya. Ta nyiŋyɔgsa.” Wa ale weeni dila la, tuemu yaa deri basi wa ate wa nya nyiŋyɔgsa. ");
INSERT INTO bwu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yeezu yaa weeni wa ale nin muna ayen, “Kan weeni a sak nuru waai ya, ku ale nyɛ dii ate fi nya nyiŋyɔgsa la. Cheŋ Juuma Puusika Yenni kpaŋŋa po wanyi jigi a pa fi dek a sak wa. Wa dan nya fu weeni wa ate wa nyɛ kaabka a te fu ase Moosis ale sak ti dii dila po dila po la. Dila a le sak nuruba kama ayen yɔgyɔgla de fi yaa ta nyiŋyɔgsa.” ");
INSERT INTO bwu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Alege waai meena jam wom Yeezu wie ka nna yegayega ate nuru bɔari a yaa jam wa jigi ayen ba wom wa sinsaŋŋa abe wa tebi ba tuetaŋa. ");
INSERT INTO bwu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Alege Yeezu jam basi ba kama ale cheŋ juijui ate nuru karo la ayen wa puusi Naawen. ");
INSERT INTO bwu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Da yeŋ ate Yeezu a jam boro a sak la, Farisiima ale Juuma Sinsaŋŋa sagrɔma a yaa jam ayen ba wom. Ba jam nyini ka tɛŋfiisaŋa meena ale bo Galili tɛŋka po la. Ba gela me a jam nyini Judia ale Jerusalem tɛŋsaŋa. Ti Nyɔnɔwa pagrimu abe jam bo ale Yeezu kama ate wa baga a tebi nuruba. ");
INSERT INTO bwu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wa ale jam boro a sak la, nuruba yaa jam ji nuru wanyi ale jaab. Wa nisa ale wa naŋsa ale jam kpi. Ba yaa pii nyiŋ ayen ba ta wa jo a dueni Yeezu niŋ, ");
INSERT INTO bwu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","alege nuruma jam piisi ka nna yegayega ate ba an jam baga vuri ba po a paari Yeezu. Ba yaa pa nuruwa a ta jueli dɔkku zuk a vuri vorub gboŋku sunsuŋ a yaa pa miisa a bobi jaamu a pa wa ta va vorumu po a siŋ dueni Yeezu niŋ. ");
INSERT INTO bwu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yeezu ale jam seba ayen ba ta siaka yegayega ale wa la, wa yaa weeni nuruwa ate wa nisaŋa ale wa naŋsaŋa a kpi la ayen, “Nidɔa, Naawen voŋ fi wabaataŋa te fu kama.” ");
INSERT INTO bwu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Juuma Sinsaŋŋa sagrɔma ba gela ale Farisiima ale jam maa kala dula a wom Yeezu ale weeni dii la, a yaa a bek chaab ayen, “Nuruwa de ale a biisi dii la, ku nala? Wa ale a biisi dii la ku ka leeta Naawen jigi. Ka wana ale baga a voŋ nuru wabaata a te wa, nin kan daa Naawen nyiini?” ");
INSERT INTO bwu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Alege Yeezu a jam seba ba ale a poli dii la kama, ate wa bek ba ayen, “Ka boa ale soa ate ni ta bek ŋala chaab ni suniima po? ");
INSERT INTO bwu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ni basi ate m bek ni wari ayen, ‘Ka ku kuna dek ale moali ate m weeni? Mi nin weeni nuruwa de ayen fi nya voŋteka a yaase m weeni ayen yiti cheŋ?’ ” ");
INSERT INTO bwu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yeezu nyɛ nna kama ayen ba seba ayen ka wa saalobiika ale ta pagrim tɛŋzuk meena a baga a voŋ nuruba wabaata a te ba. Wa yaa chiem weeni yɔgnyieŋka ayen, “Yiri zaani ŋmai, abe fi pa fi tiaka a cheŋ kuli fi yenni.” ");
INSERT INTO bwu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nuruwa yaa deri yiri zaani ba meena niŋ, a yaa pa wa tiaka a pak Naawen a kuli. ");
INSERT INTO bwu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ku yaa cha waai meena ale za dula jigini la. Ba yaa pak Naawen ale a weeni ayen, “Jinla, tama nya wakperikaliisa.” Yɔgsum jam yik ba ka nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yeezu ale basi yenni ale a cheŋ la, wa yaa nya lampoo cheesido wanyi ate ba a wi wa ayen Livai. Wa jam kala ka lampoo cheesika dɔk po a tuesi lampoo. Yeezu yaa weeni wa ayen, “Yiri a jam va mi ŋaaŋ.” ");
INSERT INTO bwu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Yeezu ale weeni dila la, Livai a yaa basi wa tuimaŋa meena ale yiri va wa. ");
INSERT INTO bwu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Livai yaa ta Yeezu a kuli yeri a nyɛ tigi kpeeni nna yegayega a te wa. Lampoo cheesiroba nna yegayega ale nuru ba chaab ale jam maa kala a de ale ba. ");
INSERT INTO bwu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisiima ale Juuma Sinsaŋŋa sagrɔma ale nya ale ba kala a de la, ba yaa ŋuuni ale chaab a yaa bek Yeezu ŋaaŋviirima ayen, “Ka boa ate nama a gum chaab ale Lampoo cheesiroba ale wabaata nyam a kala a de ale a nyu?” ");
INSERT INTO bwu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yeezu ale wom dila la, wa yaa weeni ba ayen, “Daa nyiŋyɔgsa nyam ale a yaali tiim nyɔnɔ, ka yuariba nyiini. ");
INSERT INTO bwu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mi an jam ayen m wi ka nuru baai ale a poli ayen ba ka nuru welensa la, alege ka wabaata nyam ate mi jam ayen m wi ate ba basi ba tuimbaataŋa tomka.” ");
INSERT INTO bwu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ba yaa weeni Yeezu ayen, “Jɔɔn Sokateerɔwa ŋaaŋviirima a nyiem kasim a bobi ka noa ale a puusi Naawen me. Farisiima ŋaaŋviirima me a nyiem a bobi kama, alege, fi Yeezu, ŋaaŋviirima kan bobi noa ale ge goanti a de.” ");
INSERT INTO bwu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yeezu yaa tulisi ba ale wamagsini ayen, “Nipɔkfiaka nyɔnɔwa dɔama a baga a bobi noa? Aaya! Nipɔkfiaka nyɔnɔwa ale diem boro ale ba la, ba an baga a nyɛ dila. ");
INSERT INTO bwu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Alege ku cheena ate nuruba le yik wa a ta cheŋ, dila powa, ba yaa le bobi noa.” ");
INSERT INTO bwu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Wa yaa ŋman magsi wamagsini di choa ayen, “Ba kan cheeri garuk paaluk garuchiak a laŋ garuk kpaga. Ba dan nyɛ dila ba a kaasi garuk paaluku kama. Garuchiak paalika me abe kan magsi garuk kpakka.” ");
INSERT INTO bwu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Wa ŋman pilim a magsi di choa ayen, “Ba kan pa da paalik a su bunlɔk kpak po. Ba dan nyɛ dila, bunlɔkku a na kama ate daamu a waaŋi. Ku dan nyɛ dila, nuruwa a jok wa bunlɔkku ale wa daamu meena kama. ");
INSERT INTO bwu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Dapaalik a magsika bunlɔk paaluk suka.” ");
INSERT INTO bwu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Wa yaa ŋman weeni me ayen, “Nuru abe karo a nyu dakpaga ale ŋman a yaali dapaaliga, dii nyiŋ la, wa le weeni ayen ka da kpakka ale nala.” ");
INSERT INTO bwu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Juuma Vuusum Danni po dinyi ate Yeezu ale wa ŋaaŋviirima a yaa ga jo nuru wanyi talim po. Ba ale a cheŋ la, wa ŋaaŋviirima a yaa wie “wiiti” zuima a piak a ŋobi. ");
INSERT INTO bwu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Farisiima ba gela ale jam nya dila la, ba yaa bek ba ayen, “Nya, ka boa ate ni a kaasi tama Vuusum Danni kisiku?” ");
INSERT INTO bwu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yeezu yaa tulisi ba ayen, “Nama an diem karim Naawen gbaŋka po a wom kommu ale jam yik Deevid ale wa dɔama ate ba nyɛ dii la? ");
INSERT INTO bwu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Wa an jo daa Naawen Yenni po a pa boroboruk kuui ate nuruba ta jam te Naawen la a ŋmari ŋobi ale ge ŋmari te wa dɔama ate ba me ŋobi? Nama ze ayen kan daa Juuma Puusika Yenni kpaŋŋa nyiini, nuru yoŋ kan maari a ŋobi boroboruk kula?” ");
INSERT INTO bwu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yeezu yaa ŋman weeni ba ayen, “Ka Mi Saalobiika ale soa Vuusum Daaŋa me.” ");
INSERT INTO bwu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Vuusum Danni di choa ale ŋman jam paari la, Yeezu yaa ga jo ba tuka dɔkku po a boro a sak. Nuru wanyi ale jam maa boro ate wa juga nisa kpi. ");
INSERT INTO bwu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Juuma Sinsaŋŋa sagrɔma ale Farisiima ale jam maa bo dula la, a yaa jam a limsi ayen ba nya ase Yeezu le tebi nuruwa yaase wa kan tebi. Ku ale jam ka ba Vuusum Danni ate wa dan tebi abe ba baga a nya siuk a tɔariŋ wa. ");
INSERT INTO bwu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Alege Yeezu jam miŋ ba ale a poli dii la kama ate wa yaa weeni nisim kpiitaŋa nyɔnɔwa ayen, “Jam zaani dela.” Nuruwa yaa yiri a ga zaani dula, ");
INSERT INTO bwu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ate Yeezu yaa weeni nuruma ayen, “Mi a yaali ayen m bek ni ka wari ayen, Vuusum Danni a weeni ti kama ayen ti a tom tuimmaŋsa a te nuruba yaa di a weeni ti kama ayen ti tom tuimbaata a te nuruba? Ku be a weeni ti kama me ayen ti te nuruba nyuvuri yaa ti ko ba?” ");
INSERT INTO bwu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yeezu bek ba nyaŋa de meena ale gisi nya ba meena a yaa weeni nisim kpiitaŋa nyɔnɔwa ayen, “Teeri fi nisaŋa” ate nuruwa yaa teeri wa nisaŋa a deri ta nyiŋyɔgsa. ");
INSERT INTO bwu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Alege ku yaa deri te Farisiima supuurim nna yegayega ate ba yaa zok ale chaab ba le ba nyɛ Yeezu dii la. ");
INSERT INTO bwu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Da ŋala po da yeŋ ate Yeezu a ga jueli guuk kunyi zuk ayen wa puusi Naawen. Dila danni wa jam puusi ka Naawen kantueŋka ale yokku meena. ");
INSERT INTO bwu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Vari ale veenti la, wa yaa wi wa ŋaaŋviirima a yaa lueri a ta nyini ba meena po nuruba pi ale baye a yaa te ba yoi ayen tuimtomdɔba. Tuimtomdɔma de jam ale: ");
INSERT INTO bwu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Simon, (waai ate wa te wa yoi paali ayen Piita la), ale Andiru (waai ale ka Simon suok la), ale Jeemsi, ale Jɔɔn, ale Filip, ale Batolomiu, ale Matiu, ale Tomasi, ale Jeemsi (Alfiyus biika), ale Simon ale jam a nyɛ ayen Juuma a nya ba dek zuk la, ale Judas (Jeemsi biika), ale Judas Iskariot, waai le wa ta Yeezu a ga bobri sak la. ");
INSERT INTO bwu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yeezu ale ga nyini guuku zuk a siŋ ale wa ŋaaŋviirima la, wa yaa cheŋ ga zaani juijui ate tɛŋka a dua magsi chaab la. Wa ŋaaŋviirima yegayega ale nuru bɔari me nna yegayega a jam nyini Judia tɛŋka meena ale Jerusalem ale Taaya ale Saidon tɛŋsaŋa ale kali nya kpeemu noai la. Ba meena jam jam kama ayen ba wom wa sinsaŋŋa abe wa tebi ba tuetaŋa me. ");
INSERT INTO bwu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Baai ale jam ta chichiribaata ba zuima po ate ti a daani ba la a jam maa nya nyiŋyɔgsa kama me. ");
INSERT INTO bwu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nuru bɔanni a yaa kasim jam a tusi chaab ayen ba tiri wa, dii nyiŋ la, pagrim ale jam nyini wa jigi a jam a te ba meena nyiŋyɔgsa. ");
INSERT INTO bwu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Wa yaa zak wa zuk a nya wa ŋaaŋviirima ale deri piilim sakka ayen, “Nama, mi ŋaaŋviirima, baai ale ka ŋanjagsa la ta supeentik kama, dii nyiŋ la, nama le de Naawen Naamu. ");
INSERT INTO bwu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nama baai ate kom ta ni yɔgyɔgla la, ta supeentik kama, dii nyiŋ la, ni chum le chak. Nama baai ale a kum yɔgyɔgla la, ta supeentik kama, dii nyiŋ la, ni chum le la. ");
INSERT INTO bwu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nama baai ate nuruba kisi ni la, ale a zɛri ni ale a le ni ale a weeni ayen ni ka nuru baata la, nyaŋa de meena ni ale a va mi Saalobiika nyiŋ, la ta supeentik kama. ");
INSERT INTO bwu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ni a gok ale supeentik ba ale a nyɛ ni dila la, dii nyiŋ la, tutuna kpeema ale bo wenŋmazuk a limsi ni. Daa nama nyiini ale piilim a nya dila, ba kokpieŋsaŋa a jam nyɛ Naawen biisiteerɔma jigi ka dila degadega. ");
INSERT INTO bwu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Alege nama baai ale jigsi la ku ale bie ni jigi kama dii nyiŋ la, nama poom deri nya ni masimu kama yɔgyɔgla. ");
INSERT INTO bwu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nama baai ale chak yɔgyɔgla la, ku ale bie ni jigi dii nyiŋ la, kom le yik ni chum diipo. Nama baai me ale a la yɔgyɔgla la, ku ale bie ni jigi dii nyiŋ la, ni le kum chum diipo. ");
INSERT INTO bwu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nama baai ate nuru meena a te ni pimpauk la, ku ale bie ni jigi dii nyiŋ la, ba kokpieŋsaŋa a jam biisi ka dila degadega a magsi chaab ale biisiteerɔ baai ale jam a velim dila po dila po ayen ba ka Naawen biisiteerɔba la. ");
INSERT INTO bwu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Alege mi a biisi ale ka nama baai ale a wom la ayen ku a fe kama ayen ni ta yaalika ale ni dachaasa abe ni a tom tuimmaŋsa a te baai ale kisi ni la ");
INSERT INTO bwu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","abe ni a niak baai ale a ka a te ni la, abe ni a puusi Naawen a te baai ale a le ni la. ");
INSERT INTO bwu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Waai a dan fɔbi fi tapiak, virim ka choawa me a te wa ate wa fɔbi. Waai me abe dan yeeri fi garigeli ale pagrim, yeeri garuk kuui me ate fi jo garigenni a vi ku zuk la a te wa. ");
INSERT INTO bwu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Waai a dan juisi ni jaab, ku a fe ate ni te wa. Waai abe dan pa ni jaab me ni kan bek wa ate wa te ni. ");
INSERT INTO bwu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ni nyɛ ni chaab jigi ase nama me ale a yaali ayen nuru nyɛ nama me jigi dii la. ");
INSERT INTO bwu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ni dan ta yaalika ale baai ale ta yaalika ale ni la, ni a poli ayen ni ale tuesi niaka? Ni basi ate m weeni a sak ni ayen tuimbaata nyam dek a ta yaalika kama ale baai ale ta yaalika ale ba la. ");
INSERT INTO bwu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ni be dan a tom tuimmaŋsa a te baai me ale a tom tuimmaŋsa a te nama me la, ni a poli ayen ni ale tuesi niaka? Boan nyiŋŋa, tuimbaata nyam a nyɛ ka dila degadega me. ");
INSERT INTO bwu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ni be dan te nuru maarika ale ge ta yiila ayen wa me a le te ni maarika, ni a poli ayen ni ale tuesi niaka? Tuimbaata nyam me a te maarika ka tuimbaata nyam me ale a yiili ayen bala me le te ba maarika. ");
INSERT INTO bwu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Alege ku a fe kama ate ni ta yaalika ale ni dachaasa abe ni a tom tuimmaŋsa a te nuruba, abe ni kan a yiili ayen ba me le tom tuimmaŋsa a te nama me, abe ni a te nuruba maarika, abe ni ka a yiili ayen nuru bala me a le maari nama me. Ni dan nyɛ nyaŋa de meena ni tutuna kpeema ŋaai ale bo ŋaaŋ la, le zuak ka nna yegayega ate ku sak ayen ni ka Naawen kpeeni bisa, dii nyiŋ la, wa diem ta jiirim kama ale baai ale kan a nyɛ nuru jiam ase ba nin nyɛ wari a te ba la. Wa ta jiirim me kama ale gaasa nyam. ");
INSERT INTO bwu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ni ta jiirim ase ni kowa Naawen ale ta jiirim dii la. ");
INSERT INTO bwu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ni dan a bo nuruba buusa, nama dek me le nya ka buusa boka. Dila nyiŋ la, ni kan a bo nuruba buusa. Ni voŋ a te nuruba ate nama me nya voŋteka. ");
INSERT INTO bwu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ni te nuru jaab ate Naawen pa jaab a te nama me ate ku poom gaam taam sueri a nyini. Dii nyiŋ la, fi le pa poli kaai a magsi jaab a te nuru la, poli kala degadega ate Naawen le pa magsi a te nama me.” ");
INSERT INTO bwu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Wa ŋman pilim magsi wamagsini di choa ayen, “Yio an baga a dari yio. Ba dan nyɛ dila, ba noa bayewa a lo ka goluk po. ");
INSERT INTO bwu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ŋaaŋviiro an gaam wa kpagiya alege kpagini a dan sak wa nalimnyiini, wa a nyɛ ase ka kpagini la. ");
INSERT INTO bwu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ka boa ale soa ate fi a nya yiok kuui ale bo fi vaanchoa nummu po la alege fi an baga a nya duok kuui ale bo fi dek nummu po la? ");
INSERT INTO bwu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Fi baga a nyɛ ka se a weeni fi vaanchoa ayen, ‘M doa, basi ate m pa yiok fi nummu po a basi’, alege an baga nya duok kuui ale dua fi dek nummu po la? Ni basi ate m weeni a sak ni ayen ni ka pimpaasiroba. De niŋ a pa duok kuui ale bo fi dek nummu po la a basi ate fi baga nya nalimnyiini a pa yeri kuui ale bo fi vaanchoawa nummu po la a basi.” ");
INSERT INTO bwu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yeezu yaa ŋman magsi ayen, “Tiib buui ale ta nyiŋyɔgsa la, kan yoani yoan baata, ti buui me ale kan ta nyiŋyɔgsa la, kan yoani yoan maŋsa, ");
INSERT INTO bwu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","dii nyiŋ la, ba a miŋ tiib ka bu yoana jigi boan nyiŋa moota a kan yoani zaauŋ zuwa yaase gaa kan yoani kangbegi zuwa. ");
INSERT INTO bwu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nuru maŋ a tom ka tuimmaŋsa a ta a nyini wa sunum po a nyini. Nuru biok me a tom ka tuimbaata a ta a nyini wa sunum bioku po a nyini. Dii nyiŋ la, wa dii ale bo nuru sunum po la, ka dila degadega ate wa a biisi. ");
INSERT INTO bwu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ka boan nyiŋ ale soa ate ni a wi mu ayen, ‘Nyɔnɔ, Nyɔnɔ,’ alege ni kan nyɛ dii ate mi a weeni ni la? ");
INSERT INTO bwu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nuru waai a dan jam mi jigi a wom m wieŋa ale va ŋa m le weeni a sak ni wa ale ka nuru waai choa la. ");
INSERT INTO bwu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wa a nyɛ ase ka nuru ale boro a se wa yeri la. Wa tu ka goluk ate ku siŋ nna yegayega a yaa paari tintana a nyubi wa nyubini. Ŋmoruk ale ga ni a sueri tɛŋka meena la, beli a yaa sueri a nyini ate nyiamu a chali ga a nak wa yenni alege bu an baga viti yenni a lonsiya, dii nyiŋ la, wa se di kama nalimnyiini ate di pagra. ");
INSERT INTO bwu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Alege m ŋman a weeni kama ayen nuru waai a dan wom m wieŋa ale ge kan va ŋa, wala choa a nyɛ ase ka nuru ale se wa yeri alege wa an nyubi nyubi la. Benni nyiamu ale mobi la, wa yenni a yaa deri lo paari tɛŋ nna bugibugi.” ");
INSERT INTO bwu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yeezu ale biisi nueri la, wa yaa cheŋ Kapernaum tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Aroom tɛŋka demma sojima kpagi dinyi ale jam ta wa tomteerɔ. Kpagini jam a yaali wa ka nna yegayega. Wa tomteerɔwa a yaa jam a yuak a mɔata kum. ");
INSERT INTO bwu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kpagini ale wom Yeezu wie la, wa yaa tom Juuma kpaga ŋa gela ayen ba cheŋ a ga wi Yeezu ate wa jam tebi wa tomteerɔwa. ");
INSERT INTO bwu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ba yaa jam Yeezu jigi a saalim wa a weeni wa dila, ale ge weeni wa me ayen, “Kpagini de ka waai ale magsi ayen fi maari wa la. ");
INSERT INTO bwu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Wa a yaali ti nuruma ka nna yegayega ate wa yaa se tuka dɔk a te ti.” ");
INSERT INTO bwu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yeezu a yaa va ba a cheŋ kpagini yenni. Wa ale jam tali maga ate wa paari yenni la, kpagini a yaa tom wa dɔaba ayen ba ga weeni wa ayen, “M dek nyɔnɔ, kan daani fi dek ayen fi jam m yenni. Mi posima ale fi nin jam jo m yenni po. ");
INSERT INTO bwu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Be ka dila ale soa ate m dek an jam fi jigiya. Biisi biik nyiini ale m tomteerɔwa a le nya nyiŋyɔgsa kama. ");
INSERT INTO bwu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mi me ka nuru waai ale a tom a te kpaga ŋa chaab la. Alege m ta sojiba kama baai me ate mi me a nya ba zuk la. M dan weeni ba wanyi ayen wa cheŋ dela, wa a cheŋ kama, m dan weeni wanyi me ayen wa jam de, wa a jam kama, m dan weeni m tomteerɔwa ayen, ‘Nyɛ nna,’ wa a nyɛ kama.” ");
INSERT INTO bwu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Wa ale weeni nyaŋa de meena a nueri ate Yeezu wom la, ku jam cha Yeezu ka nna yegayega ate wa virim weeni nuru bɔanni ale jam va wa la ayen, “Tɛŋka meena ale dua, mi an diem nya siaka de choa. Izirali dek tɛŋka po me mi an nya ka choa.” ");
INSERT INTO bwu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kpagini ale tom nuru baai la, a yaa pilim kuli kpagini yenni a ga a paari a nya ale tomteerɔwa a ta nyiŋyɔgsa kama. ");
INSERT INTO bwu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ku ŋaaŋnyiŋ ate Yeezu cheŋ tɛŋ kanyi ate ba a wi ayen Neen. Wa ŋaaŋviirima ale nuru bɔari nna yegayega ale jam maa va wa. ");
INSERT INTO bwu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ba ale ga boro a mɔata noai dii ale a jo tɛŋka po la, Yeezu yaa nya ale nuru wanyi a kpi ate ba ji a ta a nyini. Wa mawa biik meena a jam ale nuruwa. Wa mawa be jam ka pukogi. Nuru bɔari a yaa jam maa nyini tɛŋka po a va wa. ");
INSERT INTO bwu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nyɔnɔwa ale nya pukogini la, jiirim yaa yik Nyɔnɔwa ate wa weeni pukogini ayen, “Kan a kum”. ");
INSERT INTO bwu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yeezu yaa cheŋ a ga tiri tiaka ate nuru baai ale ji kpiowa la, a yaa deri zaani. Yeezu yaa weeni kpiowa ayen, “M biiga, mi ale a weeni fu ayen fi yiri.” ");
INSERT INTO bwu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kpiowa yaa deri yiri a biisi ate Yeezu yaa pa wa a te wa mawa. ");
INSERT INTO bwu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Yɔgsum yaa jam yik ba meena ate ba a te Naawen pimpauk ale a weeni ayen, “Biisiteerɔ kpioŋ ale pa wa dek a sak tama. Naawen abe ale jam ayen wa vari wa nuruma a basi.” ");
INSERT INTO bwu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Wanni de ate Yeezu nyɛ la, a yaa jam tagli Judia tɛŋka meena ale tɛŋ sii meena ale jam kala a gilim ka la. ");
INSERT INTO bwu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jɔɔn ŋaaŋviirima ale wom wieŋa de meena la, ba yaa weeni sak wa. Wa yaa wi ba baye a tom ba ");
INSERT INTO bwu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ayen ba cheŋ Nyɔnɔwa jigi a ga bek wa ayen, “Ka fi ale waai ate Naawen weeni ayen wa le tom ate wa jam la, yaa ti a yiili nuru yoŋŋɔa?” ");
INSERT INTO bwu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ba ale jam paari Yeezu la, ba yaa weeni ayen, “Jɔɔn Sokateerɔwa ale tom ti fi jigi ayen ti bek fu ayen, ‘Ka fi ale waai ate Naawen weeni ayen wa le tom ate wa jam la, yaa ti a yiili nuru yoŋŋɔa?’ ” ");
INSERT INTO bwu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ba ale jam za a limsi dula jigini la, Yeezu jam tebi ka nuruba nna yegayega tueta ale yiak chichiribaata nuruba zuima po a basi, ale lagi yeeba yegayega nina. ");
INSERT INTO bwu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Wa yaa tulisi Jɔɔn nuruma ayen, “Ni pilim ŋman cheŋ ga weeni Jɔɔn dii ate nama nya ale wom me la. Ni nya baai nina daam ale ligi la, ba yaa a nya kama, baai daam ale ka gbatta ale gbaŋsa la, ba yaa a yiri a cheŋ, baai daam ale ka gama, ba yaa ta nyiŋyɔgsa, baai daam ale ka tukpara nyam la, ba yaa a wom, kpeeba a yiri kum po, ŋanjagsaŋa a wom wamaŋsaŋa. ");
INSERT INTO bwu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Baai ale kan ta chichama ale mi la, ta supeentik kama.” ");
INSERT INTO bwu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jɔɔn ŋaaŋviirima ale basi Yeezu ale a kuli la, Yeezu yaa deri piilim a biisi Jɔɔn wie ale nuru bɔanni, a bek ba ayen, “Nama ale jam nyini cheŋ sagini po la nama poli ayen ni nya ka boa? Nama a poli ayen ni nya ka nuru ate wa a nyɛ ase wuuk ate viok a fugi la? ");
INSERT INTO bwu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nama nyini ayen ni nya ka nuru ate wa jo garuk nalinta? Aawo, nuru baai ale a jo garuk nalinta ale a de masim la, a bo ka nalima yie. ");
INSERT INTO bwu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mi a bek ka nama ayen ni weeni a sak mu jaab buui dek ate nama nyini ayen ni nya la? Ni nyini ayen ni nya ka biisiteerɔ? Mm, ni nya wari kama di gaam biisiteerɔ. ");
INSERT INTO bwu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ka waai ate ba ŋmarisi wa wie Naawen Gbaŋka po la ale nna ayen, Naawen weeni ayen, ‘Ni nya, mi a tom ka m nuru ayen wa de fi niŋ a gomsi siuku magsi a te fu.’ ");
INSERT INTO bwu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mi a weeni ni kama ayen Jɔɔn a gaam ka waai meena ate nipɔk a biak la. Alege waai ate ba a zaab Naawen naamu po la, a poom gaam Jɔɔn kama.” ");
INSERT INTO bwu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nuruma meena a jam wom wa kama. Ba ale lampoo cheesiroma a jam siak kama a va wie ŋaai meena ate Naawen a yaali la ate Jɔɔn a te ba soka. ");
INSERT INTO bwu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Alege Farisiima ale Juuma Sinsaŋŋa sagrɔma a jam zɛri Naawen ale a yaali ayen wa nyɛ dii a te ba la kama ate ba yaa zɛri ayen Jɔɔn kan te ba soka. ");
INSERT INTO bwu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yeezu yaa ŋman ayen, “Ka boan jaab ate mi le pa a magsi chaab ale jinla demma nna? Ba a nyɛ ase ka boan la? ");
INSERT INTO bwu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ba a nyɛ ase ka bimbaansa ale kala yaba peelim po a wi chaab a weeni ayen, ‘Tama peeri damunsaŋa kama alege fi kan gogi? Tama be ŋman yi ka kuuna yiila alege fi kan kumu?’ ");
INSERT INTO bwu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Siuk kula po Jɔɔn Sokateerɔwa ale jam jam la, wa jam bobi ka noai, a kan de ŋandiinta yaase wa nyu daam, ate ni jam a weeni ayen, ‘Wa ta ka chichiribiok wa zuk po.’ ");
INSERT INTO bwu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ku ŋaaŋnyiŋ ate mi Saalobiika me a jam a de ale a nyu la, ni jam weeni kama me ayen, ‘Mi baga a de ale a nyu, ka nna yegayega, ayen mi ka lampoo cheesiroba ale tuimbaata nyam doa.’ ");
INSERT INTO bwu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Alege ni basi ate m weeni a sak ni ayen, diipo meena yam nyam a nyiem dan nya Naawen yammu, ba a miŋ bu kama.” ");
INSERT INTO bwu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisii wanyi ale jam wi Yeezu ayen wa jam de ŋandiinta ale wa ate Yeezu yaa cheŋ ate ba kala a de. ");
INSERT INTO bwu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tɛŋ kala po nipɔk ale jam boro. Wa jam ka waba nyeerik. Wa ale wom ayen Yeezu a bo Farisii wa yeri a de ŋandiinta la, wa yaa ta kpa buui nyum ale masa la jam Yeezu jigi, kpaamu jam sueri ka kpaam cheŋbili. ");
INSERT INTO bwu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Wa yaa zaani Yeezu tɛŋ a kum ale pa wa ninyiamu a sugri Yeezu naŋsaŋa ale ge a yaa domsi kali tɛŋ a pa wa zuisaŋa a duisi wa naŋsaŋa ate si ko, ale a puusi, a yaa pa kpaamu a kpiiri si zuk. ");
INSERT INTO bwu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Farisiiwa ale nya dila la, wa yaa weeni wa dek wa popola po ayen, “Nuruwa de a daam dan sum ka Naawen biisiteerɔ, wa te seba nipowa de ale ka waai choa a tiri wa la kama, dii nyiŋ la, nipowa ka waba nyeerik.” ");
INSERT INTO bwu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yeezu ale miŋ nuruwa ale a poli nna la, wa yaa tulisi wa ayen Simon, “M ta ka wari ayen m weeni a sak fu.” Simon me a yaa bek wa ayen, “Ka boan wari, sagrɔ?” ");
INSERT INTO bwu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yeezu yaa weeni wa ayen, “Nuru ale jam boro a yaa piem wa ligra a te nuruba baye. Nuruma de wanyi a jam piem ka daa kobsinu tutuna, wanyi me piem daa pisinu tutuna. ");
INSERT INTO bwu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ba noa bayewa an ŋman jam baga a tuni nuruwa ligraŋa a te wa. Nuruwa yaa voŋ te ba meena ale weeni ba ayen ba basi ba pamaŋa tunika. Ka ba wana dek ale ta yaalika yegayega yɔgyɔgla de ale nuruwa de?” ");
INSERT INTO bwu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon yaa tulisi Yeezu ayen, “Mi a poli ayen ka waai ale ta nuruwa ligra yegayega alege wa voŋ a te wa la, le wa ta yaalika nna yegayega ale wa.” Yeezu yaa tulisi wa ayen, “Fi biisi ka wensie”, ");
INSERT INTO bwu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ale ge yaa virim nipowa jigi a bek Simon ayen, “Fi nya nipowa de? Mi ale jo fi yenni po alege fi an te mu nyiam ayen m ŋɔa sugri m naŋsaŋa alege nya wa de sugri ka mi naŋsaŋa ale wa ninyiam ale ŋman pa wa zuisaŋa a duisi si ate si ko. ");
INSERT INTO bwu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Fi an te mi tia, alege diipo ate mi ga jo yenni de po la, wa an diem basi mi puusa. ");
INSERT INTO bwu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Fi an pa kpaam a kpiiri m zuwa, alege wa pa ka kpa masik a kpiiri basi m naŋsaŋa zuk. ");
INSERT INTO bwu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Wa ta yaalika ka nna yegayega dii nyiŋ la, wa nya voŋ teka kama wa wabaataŋa nyiŋ. Alege waai ale nya voŋteka magla la, a ta ka yaalika magla me.” ");
INSERT INTO bwu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yeezu yaa weeni nipowa ayen, “Fi nya voŋteka kama.” ");
INSERT INTO bwu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Baai meena ale jam maa boro a de la, a yaa jam a bek chaab ayen, “Ka wana ale nna, a voŋ nuruba wabaata a te ba?” ");
INSERT INTO bwu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Alege Yeezu yaa weeni nipowa ayen, “Fi siaka vari fu basi kama, cheŋ ale suyɔgini.” ");
INSERT INTO bwu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ku ŋaaŋnyiŋ ate Yeezu yaa nyiem gilim a cheŋ tɛŋkpieŋsa ale tɛŋfiisa a sak nuruba Naawen wamaŋsaŋa wie a magsi chaab ale Naawen Naamu. Wa ŋaaŋviirima pi ale bayewa a jam maa bo ale wa kama. ");
INSERT INTO bwu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nipooba gela me baai ate wa jam yiak chichiribaata ba zuima po a basi ale ba gela me baai ate wa jam tebi ba tueta la a jam maa va wa kama. Nipooma de jam ale Mɛɛri waai ale jam nyini Magdala tɛŋka ate Yeezu yiak chichiribaata tiyopoi wa zukku po a basi la ale ");
INSERT INTO bwu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Chuuza waai ale jam ka Naawa Ayerod tomteerɔma kpagi la, powa Joana ale Suzana ale nipooba ba chaab nna yegayega. Nyaba de meena ale jam pa ba dek ŋanta a nya Yeezu ale wa ŋaaŋviirima zuk. ");
INSERT INTO bwu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nuru bɔari nna yegayega a yaa nyini tɛŋsa tɔgatɔga a jam wa jigi ase wa ale va si po a taam la. Ba ale jam jam wa jigi a piisi nna yegayega la wa yaa piilim sakka ale wamagsini ayen, ");
INSERT INTO bwu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Nuru wanyi ale jam boro a yaa nyini boro a yuk ŋanbie, bieŋa gela a yaa lo siuku niŋ ate nuruba a yaa tabi ŋa zuk taam ate nuinsa a deri jam pisi ŋa meena. ");
INSERT INTO bwu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ŋa gela me a lo tintana po. Ŋa ale nyini a chim la, ŋa yaa jak a kpi dii nyiŋ la, tantaŋa an jam soa dii dula jigini ate nyiam a duagi. ");
INSERT INTO bwu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ŋa gela me a lo munsa po a yaa nyini a gum chaab ale munsaŋa ate si gerigeri ŋa. ");
INSERT INTO bwu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ŋa gela me a lo tɛŋ naluŋ po a nyini a chim biak a be bie kook dinyidinyi nyiŋ.” Yeezu ale weeni wa wamagsini de a nueri la, wa yaa weeni ba ayen, “Nuru waai ale ta tue a wom la, wa wom mi nalimnyiini.” ");
INSERT INTO bwu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Wa ŋaaŋviirima ale bek wa wamagsini de kiri la, ");
INSERT INTO bwu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","wa yaa tulisi ba ayen, “Naawen basi kama ate nama seba wa naamu wasusuŋŋa alege nuruba gela jigi, ŋa chim ka wamagsima nyiini ate ba a nya ale a nya alege ba kan miŋ, ba a wom ale a wom alege ba kan miŋ ŋa.” ");
INSERT INTO bwu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yeezu yaa weeni ayen wamagsini kiri ale m na: “Bieŋa ka Naawen wieŋa. ");
INSERT INTO bwu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Be ŋaai ale lo siuku po la ka nuru baai ale wom Naawen wieŋa de la, ate Sitaana a yaa jam jo ba suniimaŋa po a pa ŋa ta nyini ate ba kan nya siuk a siak a te ŋa ate ba a nya varibasika. ");
INSERT INTO bwu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Be ŋaai me ale lo tintanaŋa po la, a nyɛ se ka baai ale wom ŋa ate ba sue peenti alege ŋa kan jo ba suniimaŋa po nalimnyiini la. Ba yaa va ŋa maga dega, alege nyenyaka a dan jam ba jigi Naawen wieŋa vaka nyiŋ, ba nyiem deri pa ŋa vaka a basi. ");
INSERT INTO bwu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Be ŋaai ale lo munsaŋa po la, a nyɛ ase ka baai ale wom ŋa alege tɛŋka po wieŋa popolaŋa ale ba ligra yaalika yegayegaka ale ba ŋanyaalika, ŋala meena a de ka Naawen wieŋa ate wamaŋ an baga nyini ŋa po a nyini. ");
INSERT INTO bwu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Be ŋaai ale lo tɛŋ naluŋku po la, a nyɛ ase ka baai ale wom ŋa ale ta ŋa ba suniima po a va ŋa nalimnyiini ale a zuli wa ale a tom tuimmaŋsa la.” ");
INSERT INTO bwu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yeezu a yaa ŋman magsi wamagsini di choa ayen, “Nuru karo a tɔati wa bolimzeuŋ ale ŋman pa jaab a lik ku a yaase wa pa ku a zaani gaduok tɛŋka. Alege wa dan tɔati, wa a pa ku a zaani ka jaab zuk ate ku a nya ate baai ale a jo dɔkku po la a nya bolimu. ");
INSERT INTO bwu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Boan nyiŋŋa, wari karo a suk ate di kan nyini peelim ate nuruba a nya, yaase wari karo a chim wasusugi ate di kan nyini peelim ate waai meena a seba.” ");
INSERT INTO bwu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yeezu yaa pa wanni de a biisi nueri a weeni ayen, “Be ŋman lak tue wom wa dii ate Naawen a weeni la. Dii nyiŋ la, waai ale seba Naawen maga dek la, Naawen le basi kama ate wa ŋman seba wa nna yegayega a gum du, alege waai me ale kan seba wa, alege a poli ayen wa seba wa la, Naawen le basi kama ate wa kan poom seba wa ale maga dek me la.” ");
INSERT INTO bwu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Dula jigini, Yeezu suaataŋa ale wa mawa a yaa jam wa jigi alege, ba ale jam paari la, ba an baga a nya wa dii nyiŋ la, nuruma a jam piisi ka nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nuruma yaa weeni Yeezu ayen, “Fi mawa ale fi suaataŋa a za peelim a yaali ayen ba nya fu.” ");
INSERT INTO bwu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yeezu yaa weeni nuruma meena ayen, “Mi ma ale mi suaata ale baai ale wom Naawen wanni ale siak a te di la.” ");
INSERT INTO bwu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Da yeŋ ate Yeezu ale wa ŋaaŋviirima a yaa jo ŋaaruŋ po ate wa weeni ba ayen, “Ni te ti taam mogi kpeeni kauk kuŋkula.” Ba yaa siak ate ba a taam. ");
INSERT INTO bwu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ba ale bo nyiamu po a cheŋ la, goom a yaa deri yik Yeezu. Va kpioŋ a yaa yiri ale ba diem bo nyiamu po. Ba ŋaaruŋku a yaa nyɛ ase nyiamu a sueri ku la ate ba yaa poli ayen ba bo ka kum po. ");
INSERT INTO bwu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ba yaa nak Yeezu a yiri a weeni wa ayen, “Ti Nyɔnɔ, Ti Nyɔnɔ, ti boro a kpi kama.” Yeezu yaa yiri a weeni vioku ayen ku basi abe nyiamu a nyɛ balaa. Vioku a yaa deri basi ate nyiamu me a baliŋ. Ba waai an ŋman choaya ale maga dek me. ");
INSERT INTO bwu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yeezu yaa bek wa ŋaaŋviirima ayen, “Ni siaka le?” Ku yaa cha ba ate ba kpaziim a nak ate ba yaa weeni chaab ayen, “Nuruwa de, ka wana ate wa baga a biisi ale vioku ale nyiamu ate ba a wom wa nɔaya?” ");
INSERT INTO bwu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yeezu ale wa ŋaaŋviirima a yaa jam paari Gerasa tɛŋka. Tɛŋka de bo ka Galili mogi kpeeni kori geŋ. ");
INSERT INTO bwu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Wa ale ga nyini ŋaaruŋku po a ga siŋ tɛŋ la, Gerasa deno ate chichiribaata a jam bo wa zuk po a yaa jam Yeezu jigi. Ku jam beni ka nna yegayega. Wa an jam a jo gatta. Wa be jam bo daa yeri po, wa jam bo ka juijui ate ba a gu kpeeba la a goa boositaŋa sunsuŋ. ");
INSERT INTO bwu_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Wa ale nya Yeezu la, wa yaa lo tɛŋ wa niŋ a yaa kaari ate ku jueli nna yegayega ayen, “Fi a yaali ka boa m jigiya, fi Yeezu Naawen kpeeni biika? Mi a saalim, kan namsi mu.” ");
INSERT INTO bwu_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Wa weeni dila kama dii nyiŋ la, ka Yeezu ale na chichiribioku ayen ku nyini wa zukku po a nyini. Wa jam ka chichiribiok kuui ale kasim a jam a daani wa nna yegayega la. Ba jam yik wa kama a pa choarima a bobi wa nisa ale wa naŋsa alege wa nyiem diem gebi ŋa ale ge ate chichiribioku a ta wa cheŋ ga bo sagini po. ");
INSERT INTO bwu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yeezu yaa bek wa ayen, “Fi yoi ale boa?” Wa yaa tulisi ayen, “Mi yoi ale Anurubɔari.” Dii nyiŋ la, chichiribaataŋa a jam piisi ka nna yegayega a jo wa. ");
INSERT INTO bwu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","chichiribaataŋa a yaa saalim Yeezu ayen wa kan na ti ate ti cheŋ ninam jigiya. ");
INSERT INTO bwu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Die ale jam piisi nna yegayega a za guuk kunyi zuk dula jigini a de. Chichiribaataŋa a yaa saalim Yeezu ayen wa basi ate ti nyini a ga jo dieŋa po ate ŋa yaa chali siŋ a ga lo mogi kpeeni nyiamu po a kpi. ");
INSERT INTO bwu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Chichiribaataŋa meena yaa nyini nuruwa zukku po a ga jo dieŋa ate ŋa meena chali siŋ mogi kpeeni nyiamu po a kpi. ");
INSERT INTO bwu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nuru baai ale jam a nya dieŋa zuk la ale nya dii ale nyɛ la, ba yaa chali kuli ba yieŋa a ga weeni tɛŋka po demma ale baai meena ale jam bo ba tatta po la. ");
INSERT INTO bwu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nuruma yaa nyini cheŋ Yeezu jigi ayen ba nya dii ale nyɛ la. Ba yaa nya nuru waai ate chichiribaataŋa a poom ta wa la ale wa kala Yeezu tɛŋ a jo gatta. Wa an ŋman a yesimu. Yɔgsum a yaa deri yik ba. ");
INSERT INTO bwu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Baai ale nya dii meena ale nyɛ la, a yaa weeni sak nuruba ba chaab ayen nuru waai ate chichiribaataŋa a jam ta wa la a yaa ta ka nyiŋyɔgsa. ");
INSERT INTO bwu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gerasa demma meena, a yaa weeni Yeezu ayen wa nyini ba tɛŋka po a nyini, dii nyiŋ la yɔgsum nna yegayega ale jam yik ba. Yeezu a yaa cheŋ ga jo ŋaaruŋku po a pilim ŋmani. ");
INSERT INTO bwu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nuru waai ate chichiribaataŋa a ta wa la, a yaa saalim Yeezu ayen wa basi ate wa maa va wa a cheŋ. Yeezu yaa zɛri ale weeni wa ayen. ");
INSERT INTO bwu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Pilim kuli fi yenni a ga weeni sak waai meena Naawen ale nyɛ dii a te fu la.” Nuruwa yaa cheŋ ga jo tɛŋka meena po a weeni Yeezu ale tom dii a te wa la. ");
INSERT INTO bwu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yeezu ŋman pilim ŋmani mogini kauk kuŋkula juijui ate wa poom basi la. Nuru bɔari a yaa te wa tia, dii nyiŋ la, ba kasim jam a limsi wa kama. ");
INSERT INTO bwu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ku an jam bo la beniya alege ate nuru wanyi a yaa deri jam lo Yeezu naŋsa tɛŋ a saalim wa ayen wa maa va wa ate ba kuli wa yenni. Nuruwa yoi jam ale Jairus. Wa jam ka ba tuka diinaŋa kunyi kpagi. ");
INSERT INTO bwu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Wa jam ta ka wa le yeŋ ate wa a yuak a mɔata kum. Nipɔkbinni a jam ka bena pi ale ŋaye. Yeezu ale jam siak ate ba cheŋ la, nuruma jam piisi ka nna yegayega a yaa jam a tusi wa. ");
INSERT INTO bwu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nipɔk ale jam maa bo ba po a yuak ate ku ga paari bena pi ale ŋaye. Wa tuomu a jam a nyɛ ase wa a lo ka chiak la. Wa jam pa wa ŋantaŋa meena tuesi ka tiita alege nuru a jam karo a baga tebi wa. ");
INSERT INTO bwu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nuruma ale jam gilim Yeezu dila la, wa yaa va Yeezu ŋaaŋnyiŋ a tiri wa garuku nɔanni. Wa ale tiri la, wa chiaka loka yaa deri basi wa. ");
INSERT INTO bwu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yeezu yaa bek ayen, “Ka wana ale tiri mi la?” Ba meena yaa pagsi ayen daa ba. Piita yaa weeni ayen, “Nyɔnɔ, ka nuruma ale gilim fu dii la ale tusi fu.” ");
INSERT INTO bwu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Alege Yeezu tulisi wa ayen, “Ka nuru ale tiri mu dii nyiŋ la, m seba kama ayen pagrim ale nyini m jigi a nyini.” ");
INSERT INTO bwu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nipowa ale miŋ ayen Yeezu miŋ kama la, wa yaa nyini ate wa nyiŋka a gok a lo Yeezu niŋ a weeni ate waai meena wom dii nyiŋ ale soa ate wa tiri Yeezu a deri nya nyiŋyɔgsa la. ");
INSERT INTO bwu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yeezu yaa weeni wa ayen, “M lie fi siaka a basi kama ate fi nya nyiŋyɔgsa, be cheŋ ale suyɔgini.” ");
INSERT INTO bwu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yeezu ale diem jam boro a biisi la, nidɔa wanyi a yaa nyini Jairus yenni a jam weeni Jairus ayen, “Fi leewa kpi kama, kan ŋman daani Sagrɔwa.” ");
INSERT INTO bwu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yeezu ale wom nna la, wa yaa weeni Jairus ayen, “Kan chali yɔgsum, ta siaka nyiini ale wa le nya nyiŋyɔgsa kama.” ");
INSERT INTO bwu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yeezu ale paari Jairus yenni la, wa an siak ate nuruba a maa va wa jo alege ka Piita ale Jɔɔn ale Jeemsi ale biika kowa ale wa mawa ale jam maa va jo. ");
INSERT INTO bwu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nuruma jam a kum kama ale a kaari alege Yeezu yaa weeni ba ayen, “Ni kan a kum boan nyiŋŋa, wa an kpiya, wa a goa kama.” ");
INSERT INTO bwu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wa ale weeni ba dila la, ba yaa a la wa ale ge seba chak ayen nipɔkbinni kpi kama. ");
INSERT INTO bwu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Alege Yeezu a yaa zak nipɔkbinni nisa ale weeni wa ayen, “Biiga, yiri ŋmai.” ");
INSERT INTO bwu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yeezu ale weeni dila la, nipɔkbinni chiika a pilim jam ate wa deri yiri bunyi dekki. Yeezu yaa weeni ba ayen ba nyɛ ŋandiinta a te wa ate wa de. ");
INSERT INTO bwu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ku yaa cha wa nyamma alege Yeezu yaa kaam ba ayen ba kan weeni a sak waaiya dii meena ale nyɛ la. ");
INSERT INTO bwu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Da yeŋ ate Yeezu a yaa wi wa ŋaaŋviirima pi ale bayewa ate ba jam jigi yeŋ ate wa te ba pagrim ayen ba baga a yiak chichiribaata meena wuu nuruba zuima po a basi abe ba a tebi tueta. ");
INSERT INTO bwu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Wa yaa tom ba ayen ba ga sak nuruba Naawen Naamu wie abe ba a tebi nuruba. ");
INSERT INTO bwu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wa ŋman weeni ba ayen, “Nama ale a cheŋ la, ni kan pa jaabjaab ale ni. Ni kan pa tachegsa, a yaase fotta, a yaase ŋandiinta, yaase ligra, abe ni kan pa gatta ti chaab a gum ga tii ate ni jo la po. ");
INSERT INTO bwu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yeri dii meena wuu ate ni a jo la, ni goa dula ate ku ga paari diipo ate ni a yaali ayen ni basi tɛŋ kala la. ");
INSERT INTO bwu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ni dan jam paari tɛŋ kanyi ate tɛŋ kala demma a dan kan te ni tia, ni daa basi dula jigini ni kpaanti ni naŋsaŋa paasuku a basi dula ate ku sak ayen ni a kaam ba kama ba ale zɛri Naawen wieŋa la nyiŋ.” ");
INSERT INTO bwu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yeezu ale ga biisi nueri la, ba yaa cheŋ tɛŋsaŋa meena a sak Naawen wamaŋsaŋa ale a tebi nuruba jigi meena. ");
INSERT INTO bwu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galili tɛŋka Naawa Ayerod a yaa jam wom wie ŋaai meena ale jam a nyɛ la, alege wa an jam miŋ ŋa kiri ya, dii nyiŋ la, nuruba gela ale jam a weeni ayen ka Jɔɔn ale yiri kum po, ");
INSERT INTO bwu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ba gela me a jam a weeni ayen ka Elaja ale ŋman pilim jam, ba gela me a jam a weeni ayen ka dila po dila po Naawen biisiteerɔma wanyi ale yiti kum po. ");
INSERT INTO bwu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ayerod a yaa weeni ayen, “Mi gebi Jɔɔn zukku kama a basi alege ka wana ale la ate mi a wom wa wie?” Dila nyiŋ, Ayerod a yaa jam kasim a yaali ayen wa nya Yeezu. ");
INSERT INTO bwu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Baai ate Yeezu jam tom la a yaa pilim jam a weeni wa dii meena ate ba nyɛ la. Wa yaa yik ba a ta taam nakpiak ba dek ba nyiini ate ba cheŋ tɛŋ kaai ate ba a wi ayen Beteseida la. ");
INSERT INTO bwu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nuru bɔanni ale wom ba wari la, ba yaa saŋ va ba jam paari ba ate wa nyɛ ba tia ale sak ba Naawen Naamu wie ale tebi baai me ale jam a yaali tebika la. ");
INSERT INTO bwu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Wenni ale jam boro a siŋ la, wa ŋaaŋviirima pi ale bayewa a yaa jam wa jigi a weeni wa ayen, “Basi ate nuruma cheŋ tɛŋfiisaŋa ale tattaŋa ale gilim la a da ŋandiinta a de abe ba gisi goom jigi dii nyiŋ la, tama ale bo dela la, nuru ka dela jigini ayen wa nya ba zuwa.” ");
INSERT INTO bwu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Alege Yeezu yaa weeni ba ayen, “Nama te ba ŋandiinta ate ba de.” Ba yaa tulisi wa ayen, “Tama ta ka borobotta tinu nyiini ale juma ŋaye. Fi a yaali ayen ti ga da ka ŋandiinta a te nuruma de meena?” ");
INSERT INTO bwu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Dii nyiŋ la nuruma jam ka nidɔaba tusa ŋanu. Wa yaa weeni wa ŋaaŋviirima ayen ba weeni ba ate ba kali tɔgatɔga nuruba pisinu pisinu. ");
INSERT INTO bwu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Wa ŋaaŋviirima a yaa nyɛ dila. ");
INSERT INTO bwu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yeezu yaa pa borobotta tinuwa ale juma ŋayewa a yaa zak zuk a nya wenŋmazuk a nyɛ Naawen jiam ale ge a yik borobottaŋa ale jumaŋa a ŋmari a pa te wa ŋaaŋviirima ayen ba chari nuruma. ");
INSERT INTO bwu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ba meena a jam de chak kama ale tali ate wa ŋaaŋviirima yaa cheesi ŋandiin talaŋa sueri busisa pi ale siye. ");
INSERT INTO bwu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Da yeŋ ate Yeezu a jam boro a puusi Naawen wa dek wa nyiini, wa ŋaaŋviirima nyiini ale jam maa bo dula jigini. Yeezu yaa bek ba ayen, “Nuruba a weeni ayen mi ka wana?” ");
INSERT INTO bwu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wa ŋaaŋviirima yaa tulisi wa ayen, “Ba gela a wi fu ayen ka Jɔɔn Sokateerɔwa, ba gela me a wi fu ayen ka Elaja a yaa ŋman pilim jamu. Mba me a weeni ayen fi ka dila po dila po Naawen biisiteerɔma po wanyi waai ale yiri kum po la.” ");
INSERT INTO bwu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Wa yaa ŋman bek ba ayen, “Alege nama dek a weeni ayen mi ka wana?” Piita yaa tulisi wa ayen, “Fi ale Varibasidɔwa waai ate Naawen a jam weeni ayen wa le tom ate wa jam la.” ");
INSERT INTO bwu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yeezu yaa kaam ba ale weeni ba ale nin muna ayen ba kan weeni nuru waai wanni de, ");
INSERT INTO bwu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Wa yaa ŋman weeni ayen, “Nuruba le basi ate mi Saalobiika a nam nna yegayega ate nisomma ale Juuma Puusika Yenni kpaŋŋa ale Juuma Sinsaŋŋa sagrɔma a zɛri mu abe ba basi ate nuruba ko mu alege daa ŋata a dan paari m le yiri kum po.” ");
INSERT INTO bwu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Wa yaa weeni ba meena ayen, “Nuru waai a dan a yaali ayen wa va mi, ku a fe kama ayen wa zɛri wa dek yaalika abe wa gomsi wa dek daa meena a magsi kum abe wa jam va mu. ");
INSERT INTO bwu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Dii nyiŋ la, waai a dan kan gomsi wa dek a magsi kum alege goanti a yaali ayen wa boro wa dek nyiŋ, kula choa nyɔnɔwa, a jok wa nyuvunni kama. Waai abe dan jok wa nyuvuri wa ale va mi la nyiŋ kula nyɔnɔwa le vari wa nyuvunni a basi. ");
INSERT INTO bwu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Boan nyiŋŋa, ka boan jaab nyuenta ate nuru le nya ase wa nin nya tɛŋzuk de meena masimu ale ge jogi wa nyuvuri ya? ");
INSERT INTO bwu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nuru waai abe dan a chali chivie nyaka ale mi ale m sinsaŋŋa, mi Saalobiika a dan ŋman pilim jam ale m zulaŋa ale Kowa zulaŋa ale wa sabiiloma zulaŋa mi me le chali chivie ale kula nyɔnɔwa. ");
INSERT INTO bwu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Alege mi a weeni ka wensie ayen nama baai ale za dela la, ni ba gela a kan kpi abe ni ge nya Naawen Naamu.” ");
INSERT INTO bwu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yeezu ale biisi wieŋa de, ate daa ŋayopoi a jam taam la, wa yaa yik Piita ale Jeemsi ale Jɔɔn a ta ba jueli guuk kunyi zuk ayen ba puusi Naawen. ");
INSERT INTO bwu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yeezu ale jam boro a puusi la, wa nimbidiaka a yaa deri tagri ate wa gattaŋa me a tagri a peenti a nyagsi nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nuruba baye a yaa deri za a biisi ale wa. Ba jam ka Moosis ale Elaja. ");
INSERT INTO bwu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ba me a jam a nyagsi ka nna yegayega. Ba jam boro a biisi ale Yeezu a magsi chaab ale ka wa ale wa cheŋ Jerusalem a ga kpi ate ku nueri a va Naawen popolaŋa ale magsi dii la. ");
INSERT INTO bwu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Goom nna yegayega ale jam yik Piita ale wa vaanchaama. Ba ale yiri goomu po la, ba yaa nya Yeezu nyagsika yegayegaka ale nidɔama bayewa ale ba za ale wa. ");
INSERT INTO bwu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nidɔama bayewa ale jam boro a yaa ba basi Yeezu abe ba cheŋ la, Piita yaa weeni Yeezu ayen, “M Nyɔnɔ, tama ale bo dela dii la a nala kama. Basi ate ti viita tita a te ni ate fi soa kunyi abe Moosis soa kunyi abe Elaja me a soa kunyi.” (Piita jam ze dii ate wa a biisi la.) ");
INSERT INTO bwu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Piita ale jam boro a biisi dila la, chiŋmari yaa jam lik ba. Di ale jam lik ba la ate yɔgsum a yaa yik ba ate ");
INSERT INTO bwu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","lueluk a yaa nyini chiŋmanni po a weeni ayen, “Yeezu ale Mi Biik ate m lueri, ni be wom wa nalimnyiini.” ");
INSERT INTO bwu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Lueluku ale ga biisi nueri la, ba yaa nya ale Yeezu a za wa dek wa nyiini. Va ŋala po ba an jam weeni sak nuru waaiya dii ate ba nya la. ");
INSERT INTO bwu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Vari ale veenti ate ba nyini guuku zuk a siŋ la, nuru bɔari ale jam tu wa. ");
INSERT INTO bwu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nuru a yaa nyini nuru bɔanni po a kaari a yaa weeni ayen, “M Sagrɔ, mi a saalim fu kama ayen fi nya m biika, wala nyiini ale m biik. ");
INSERT INTO bwu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Chichiribiok ale ta wa ate wa nyiem deri a kaari nna yegayega. Ku dan ga yiri, ku nyiem kasim chiak wa kama a fɔbi tɛŋ ate tintupuuk a nyini wa nɔanni po a nyini. Ku kasim a nyɛ ka dila a te wa mula ku kan maari a basi wa. ");
INSERT INTO bwu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","M be poom saalim ka fi ŋaaŋviirima ayen ba yiak ku wa zukku po a basi alege ba an baga a nyeya.” ");
INSERT INTO bwu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yeezu yaa weeni ayen, “Nama jinla demma baai tue ale kpari ate ni ka siaka me la, nama a yaali ayen mi bo ale ni ate ku paari ase ka dimpo la? M be le ta suduŋni ale ni ate ku ga paari ka dimpo?” Wa yaa weeni biika kowa ayen, “Ta fi biika a jam dela.” ");
INSERT INTO bwu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Biika kowa ale jam ta wa cheena la, chichiribioku a yaa chiak biika a fɔbi tɛŋ ate wa nyiŋka deri a gok. Alege Yeezu yaa weeni chichiribioku ale nin muna ale ge a tebi biika a yaa pa wa a te wa kowa. ");
INSERT INTO bwu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ku yaa cha waai meena ate ba yaa nya Naawen pagrimu ale ka dii la. Ba meena ale jam nya wakperikaliisaŋa de meena ate wa nyɛ la, Yeezu yaa weeni wa ŋaaŋviirima ayen, ");
INSERT INTO bwu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ni kan bagim wie ŋaai ate mi a yaali ayen m weeni ni la. Wieŋa de ale, ba le yik Mi Saalobiika kama a nyo nuruba nisa po.” ");
INSERT INTO bwu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Alege ba an jam miŋ wa ale biisi dii la kiriya. Ku jam ka wa susugi ba jigi ate ba kan baga a miŋ di kiriya. Alege yɔgsum ale jam ta ba ate ba an bek wa ale weeni dii la kiriya. ");
INSERT INTO bwu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ku ŋaaŋnyiŋ ate wa ŋaaŋviirima a yaa ta nampaga ale chaab a bek chaab ase ka ba wana ale nuru kpioŋ ba meena po. ");
INSERT INTO bwu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yeezu yaa miŋ ba ale ta popola ŋaai ba suniimaŋa po la, wa yaa yik biik wanyi a zaani wa tɛŋ ");
INSERT INTO bwu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","a yaa weeni ba ayen, “Nuru waai a dan zuli biik ase biika de la mi nyiŋ, wa zuli ka mi dila. Waai me abe ale a zuli mi la, a zuli ka waai me ale tom mi ate m jam la, boan nyiŋŋa, waai ate nama a poli ayen wa daa nuru kpioŋ ni meena po la, ka wala dek ale nuru kpioŋ ni meena po.” ");
INSERT INTO bwu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jɔɔn yaa weeni Yeezu ayen, “M Nyɔnɔ, tama nya ka nuru wanyi ate wa pa fi yonni nyiŋ a yiak chichiribaata nuruba zuima po a basi ate tama yaa weeni wa ayen wa basi, dii nyiŋ la, wa daa tama po.” ");
INSERT INTO bwu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Alege Yeezu yaa weeni wa ayen, “Wa kan weeni wa ayen wa basi dii nyiŋ la, nuru waai a dan kan a nyɛ ayen fi basi dii ate fi a nyɛ la, kula nyɔnɔwa, a maari fu kama.” ");
INSERT INTO bwu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yeezu daaŋa ale jam mɔata ayen wa cheŋ wenŋmazuk la, wa yaa poli wa popola meena ayen wa a cheŋ ka Jerusalem tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Wa yaa tom nuruba ayen ba de niŋ a cheŋ Samaria tɛŋka tɛŋfiik kanyi po a ga gomsi magsi a limsi wa. ");
INSERT INTO bwu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Alege nuruma a jam zɛri kama ayen wa kan jam ba tɛŋka dii nyiŋ la, ba jam seba chak kama ayen Yeezu popola meena a bo ka wa Jerusalem chelimu po. ");
INSERT INTO bwu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wa ŋaaŋviirima Jeemsi ale Jɔɔn ale nya ale nuruma a zɛri wa la, ba yaa bek Yeezu ayen, “Ti Nyɔnɔ, fi a yaali ayen ti basi ate bolim nyini wenŋmazuk a jam de nuruma de?” ");
INSERT INTO bwu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ba ale bek wa dila la, wa yaa chiem nya ba a weeni ba ale nin muna, ");
INSERT INTO bwu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ate ba basi tɛŋ kala chelim ale ge cheŋ tɛŋfiik ka choa. ");
INSERT INTO bwu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ba ale jam bo siuku po a cheŋ la, nuru wanyi a yaa weeni Yeezu ayen “M le va fu a cheŋ juijui meena ate fi a cheŋ la.” ");
INSERT INTO bwu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yeezu yaa tulisi wa ayen, “Goaduŋsa ta vie kama a jo, nuinsa me abe ta tugta kama me a jo, alege Mi Saalobiika potim ka m dek yeri a goa.” ");
INSERT INTO bwu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yeezu yaa weeni nuru wa choa ayen, “Jam va mu.” Alege nuru wala a yaa tulisi Yeezu ayen, “M Nyɔnɔ, basi ate m liŋ cheŋ a ga pa m kowa a gu abe m jam va fu,” ");
INSERT INTO bwu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Alege Yeezu yaa tulisi nuruwa me ayen, “Ku a fe kama ayen fi basi ate kpeema a pa ba dek kpeeba a gu, alege fi tuini ale fi cheŋ ga biisi Naawen Naamu wie ate nuruba wom.” ");
INSERT INTO bwu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nuru wa choa me a ŋman weeni Yeezu ayen, “M Nyɔnɔ, m le va fu kama alege, mi a saalim ayen fi basi ate m liŋ banti m yenni demma abe m jam va fu.” ");
INSERT INTO bwu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yeezu ŋman tulisi wa me ayen, “Waai a dan pa wa nisa a vi niigakunni zuk a kpa alege ŋman cheemu a nya ŋaaŋ, kula nyɔnɔwa an magsi Naawen naamu po boka.” ");
INSERT INTO bwu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ku ŋaaŋnyiŋ ate Yeezu yaa ŋman lueri nuruba pisiyopoi a yaa tom ba baye baye ayen ba de niŋ a cheŋ tɛŋsaŋa meena po ale juijui meena ate wa dek weeni ayen wa le cheŋ la. ");
INSERT INTO bwu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Wa yaa weeni ba ayen, “Tɛŋka a nyɛ ase ka talim kpiem ate ŋandiinta a zuak nna yegayega bu po alege tuimtomdɔma an piisi la. Ni yaa be juisi ŋandiintaŋa nyɔnɔwa ate wa tom tuimtomdɔba ate ba nyɛ ate ŋandiintaŋa jo dɔk. ");
INSERT INTO bwu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ni yaa be a cheŋ. Ni nya, mi a tom ni kama ayen ni nyini a cheŋ ase pabisa ate ba pa basi piina sunsuŋ dii la. ");
INSERT INTO bwu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ni dan a cheŋ, ni waai kan pa ligra foowa yaase foruwa, a yaase nuensa. Ni kan wari zaani siuk ayen ni puusi waai ya. ");
INSERT INTO bwu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yeri dii meena wuu ate ni a jo di po, ni nyiem liŋ puusi yenni demma a weeni ayen, ‘Naawen le ta niaka jam yenni de po.’ ");
INSERT INTO bwu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nuru waai abe dan bo yenni po ate wa a yaali ayen Naawen niak wa yenni, niak kaai ate nama a te wa la, le bo ale wa. Alege nuru a dan boro ate wa kan yaali Naawen niak wa la niak kaai ate nama weeni ayen ka bo yenni po la le pilim ŋman jam ka ni dek jigi. ");
INSERT INTO bwu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ni dan bo yeri po, ni kasim bo dila po a de abe ni a nyu jaab buuri meena ate ba nyɛ a te ni la dii nyiŋ la, ku a fe kama ayen ba tuni tuimtomdɔwa wa tutunaŋa. M ŋman a weeni ni kama ayen ni kan a togli yie. ");
INSERT INTO bwu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ni dan cheŋ tɛŋ po ate ba nyɛ ni tia, ni de jaab buuri meena ate ba nyɛ a te ni la. ");
INSERT INTO bwu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Yɔgnyeensa a dan bo tɛŋka po ni tebi ba abe ni weeni ba ayen Naawen Naamu a mɔata ba kama. ");
INSERT INTO bwu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Alege ni dan ga jo tɛŋ po ate ba an nyɛ ni tia, ni taam ka su kpeentaŋa a zaani a weeni ayen, ");
INSERT INTO bwu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ni tɛŋka tintain tii dek ale maŋ tama nantaataŋa la, tama kpaanti ka tila a basi ni nyiŋ ate ku sak ayen ti a kaam ni kama, abe ni seba nyaku de ayen, “Naawen Naamu a mɔata ba kama.” ’ ");
INSERT INTO bwu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","M be a weeni a sak ni kama ale wensie ayen da dii danni ate Naawen cheena ayen wa bo buusa a te waai meena la, ku le pagra ka nna yegayega a poom gaam ku ale jam pagra dii a te Sodom tɛŋka la. ");
INSERT INTO bwu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Koraziin ale Beteseida tɛŋsaŋa a jok wein kama boan nyiŋa, ase Taaya ale Saidon tɛŋsaŋa a daam dan nya, Ka Naawen ale nyɛ wakperikaliik sii la ase nama Koraziin ale Beteseida demma ale nya ŋa dii la, ba daam te basi ba tuimbaataŋa tomka kama daŋdaŋŋa ale sui kaasuŋ. ");
INSERT INTO bwu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Alege, dai dii danni ate Naawen a le jam bo nuruba buusa la, ku kan pagra yegayega a te Taaya ale Saidon demma ase nama Koraziin ale Beteseida demma ate ku ale pagra dii yegayega a te ni la. ");
INSERT INTO bwu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Alege nama Kapernaum demma a poli kama ayen ba ale zak ni zaani kama ate ni cheŋ wenŋmazuk wa. Ni basi ate m weeni a sak ni ayen ku a fe kama ate ni siŋ bolim buui ale kan maara kpimsi la po.” ");
INSERT INTO bwu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yeezu yaa weeni wa ŋaaŋviirima ayen, “Waai a dan wom nama, wa wom mi me kama, alege waai a dan zɛri nama, wa zɛri mi me kama. Waai abe ale a zɛri mi la, a kan zɛri ka mi nyiini, wa a zɛri ka waai dek ale tom mi la.” ");
INSERT INTO bwu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nuruba pisiyopoiwa ate Yeezu a jam tom ba ayen ba nyiem cheŋ tɛŋsaŋa po la, a yaa ŋman pilim jam ale supeentik a weeni Yeezu ayen, “Ti Nyɔnɔ, chichiribaata me dek a siak te ti kama fi yonni nyiŋ.” ");
INSERT INTO bwu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Wa yaa tulisi ba ayen, “Mi nya Sitaana ale wa nyini wenŋmazuk nna ase wenni ale nyagsi la a jam lo. ");
INSERT INTO bwu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ni nya de m te ni ka pagrim ate ni baga a tabi wiiga ale nuenta zuima, ale dachiaka Sitaana ale wa pagrimu meena, alege nyaŋa de meena po wariwari a kan daani ni. ");
INSERT INTO bwu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Alege mi a weeni kama ayen ni kan basi ate ni sui peenti nyiini ale chichiribaataŋa ale siak a te ni la, ni basi ate ni sueŋa peenti ale ba ale ŋmarisi ni yueŋa wenŋmazuk po la.” ");
INSERT INTO bwu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yeezu ale biisi dila a nueri la, Naawen Chiika a yaa deri te wa supeentik ate Yeezu yaa weeni ayen, “M Kowa, fi waai ale ka wenŋmazuk ale tɛŋzuk Nyɔnɔ la, mi a te fi jiam ale fi ale pa fi wieŋa a suk ale baai ale ta yam ale miŋchakka la jigi ale ge pa ŋa a sak baai ale kan ta yam ale miŋchakka la. Mm, wensie m Kowa, nyaku de meena abe ka fi dek ale a yaali dii la ate fi nyɛ.” ");
INSERT INTO bwu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yeezu yaa ŋman weeni ayen, “Ŋanta meena, mi Kowa ale pa ba a te mi. Nuru waai abe ze mi wa Biika ale ka waai la, ka m kowa nyiini ale seba. Be ka wana ale seba mi Kowa? Ka mi wa Biika nyiini, ale baai ate mi, wa Biika a yaali ayen m dak wa a sak la.” ");
INSERT INTO bwu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Wa yaa virim wa ŋaaŋviirima nyiini jigi a weeni ba ayen, “Nama baai ale a nya wieŋa de ate ni a nya nna la, ta supeentik kama. ");
INSERT INTO bwu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Dii nyiŋ la, Naawen biisiteerɔba yegayega ale nalima yegayega a jam a yaali kama ayen ba nya nama ale nya dii la, alege ba an jam nya ya. Ba jam a yaali kama me ayen ba wom nama ale wom dii la, alege ba an jam wom ya.” ");
INSERT INTO bwu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Sinsaŋŋa sagrɔma po wanyi a yaa yiri zaani a bek Yeezu bega ayen wa nyɛ wa a nya. Wa yaa jam bek Yeezu ayen, “M Sagrɔ, m le nyɛ ka se ate m nya nyuvuri dii ale kan ta kpeglimka la?” ");
INSERT INTO bwu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yeezu yaa tulisi wa ayen, “Ba ŋmarisi Sinsaŋŋa po ayen ka boan la? Ŋa a weeni ayen ka boa?” ");
INSERT INTO bwu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nuruwa yaa tulisi ayen ba ŋmarisi kama ayen, “Ku a fe kama ate fi yaali Nyɔnɔwa fi Naawenni ale fi sunum meena, ale fi chiik meena, ale fi pagrim meena ale fi popola meena, abe fi yaali fi saalo choa ase fi ale a yaali fi dek dii la.” ");
INSERT INTO bwu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yeezu yaa tulisi wa ayen, “Fi tulisi mu a magsi kama, be nyɛ nyaŋa de meena, ale fi le boro.” ");
INSERT INTO bwu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Alege Sinsaŋŋa sagrɔwa ale jam a yaali ayen wa sak ayen wa ka wayɔrisima nyɔnɔ la, wa yaa bek Yeezu ayen, “Ka wana abe ale mi vaanchoa?” ");
INSERT INTO bwu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yeezu yaa tulisi wa ale wamagsini ayen, “Nuru ale jam nyini Jerusalem tɛŋka a siŋ Jeriko tɛŋka. Wa yaa ga jo zueba sunsuŋ ate ba yeeri wa gattaŋa ale nak wa a mɔata koka a yaa basi wa ale ge cheŋ. ");
INSERT INTO bwu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Juuma Puusika Yenni kpaŋŋa po wanyi a yaa yiti va siuk kula me a cheŋ. Wa ale jam nya ale nuruwa dua la, wa yaa logri va siuku nakpiak a taam. ");
INSERT INTO bwu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Livai demma po wanyi me jam nyini va siuk kula degadega a cheŋ. Wala me ale jam paari nya nuruwa la, wa me a logri va siuku nakpiak a taam. ");
INSERT INTO bwu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Alege Samaria deno me a yaa nyini siuk kula degadega a cheŋ a yaa jam paari nya nuruwa ate jiirim a yaa yik wa ale nuruwa, ");
INSERT INTO bwu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ate wa yaa cheŋ wa jigi a pa kpaam a sugri wa niraŋa, alege pa daam a kpiiri nyo ŋa po a yaa bobi ŋa. Wa ale nyɛ dila a ga nueri la, wa yaa pa nuruwa a kali wa dek duŋka zuk a ta wa cheŋ yeri dinyi po a nya wa zuk nalimnyiini ate ");
INSERT INTO bwu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","vanni ga veenti ate wa pa daa ŋaye tutuna ligra a te yenni nyɔnɔwa alege weeni wa ayen, ‘Ŋmasi nya wa zuk. Fi ale a kaasi ligra a yaase ŋandiinta dii meena nuruwa nyiŋ la, m dan pilim ŋman jam m le tuni fu ku meena.’ ” ");
INSERT INTO bwu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yeezu ale weeni wanni de a nueri la, wa yaa bek Sinsaŋŋa sagrɔwa ayen, “Fi ale wom wanni de la, nuruma de batawa po ka ba wana ale nuru waai ate zuema nak la vaanchoa?” ");
INSERT INTO bwu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Sinsaŋŋa sagrɔma yaa tulisi ayen, “Ka nuru waai ale nya wa a ta jiirimu ale wa la.” Yeezu yaa tulisi wa ayen, “Be cheŋ ga nyɛ ase nuru wala ale nyɛ dii la degadega.” ");
INSERT INTO bwu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ku ŋaaŋnyiŋ ate Yeezu ale wa ŋaaŋviirima a jam a cheŋ la, ba yaa jam paari tɛŋfiik kanyi po ate nipɔk wanyi a jam tuesi wa a ta jo wa yenni po. Nipowa yoi ale Maata. ");
INSERT INTO bwu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Wa suok me ale jam boro ale wa, wa me yoi ale Mɛɛri. Mɛɛri a yaa jam kala Nyɔnɔwa tɛŋ a wom wa sinsaŋŋa, ");
INSERT INTO bwu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","alege Maata popola meena jam bo ka dikka jigini. Wa sui an jam peenti ale Mɛɛri ale jam basi wa dek wa nyiini ate wa boro a dik la, ate wa yaa cheŋ Yeezu jigi a ga bek wa ayen, “M Nyɔnɔ, ku peenti fi sui kama ate fi nya mi dek m nyiini ale boro a dik ŋandiintaŋa la? Weeni m suoku ate wa jam maa maari mu.” ");
INSERT INTO bwu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Alege Nyɔnɔwa yaa tulisi wa ayen, “Maata, Maata, ka boan ale soa ate fi basi ate wie yegayega a danni fu? ");
INSERT INTO bwu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Fi ze ayen ka wa yeŋ nyiini ale magsi nyeka? Mɛɛri abe lueri ka wamaŋ kala. Nuru a kan baga a tuesi di wa jigi ya.” ");
INSERT INTO bwu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Da yeŋ po ate Yeezu a yaa jam cheŋ jigi dinyi a boro a puusi Naawen. Wa ale ga puusi nueri la, wa ŋaaŋviirima po wanyi a yaa weeni ayen, “M Nyɔnɔ, sak ti ate ti seba Naawen puusa ase Jɔɔn ale sak wa ŋaaŋviirima dii la.” ");
INSERT INTO bwu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yeezu yaa weeni ba ayen, “Ni daa ni puusi, ni be puusi nna, ‘Tama Ko, basi ate nuruba te fi yonni zula, di ale welema la nyiŋ. Basi ate waai meena a va fi noai ase ba Naab la. ");
INSERT INTO bwu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Te ti da yeŋ da yeŋ ŋandiinta, ");
INSERT INTO bwu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Abe fi voŋ ti wabaataŋa a te ti, dii nyiŋ la, tama a voŋ a te baai ale a nyɛ wie a kaasi tama la kama. Kan te ti a jo nyenyaka po.’ ” ");
INSERT INTO bwu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yeezu yaa ŋman weeni ba ale wamagsini ayen, “Ase nama po wanyi a nin ta doa ate fi yaa yiri goota sunsuŋ po a cheŋ wa jigi a weeni wa ayen, ‘M doa, m cheena ayen fi piem mu ka borobotta tita, ");
INSERT INTO bwu_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","dii nyiŋ la, m doa ale nyiem jam m yenni yɔgyɔgla, alege m ka jaabjaab ayen m te wa ate m cheena fi jigi ayen fi maari mu.’ ");
INSERT INTO bwu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ate wa yaa duak wa dɔkku po a tulisi fu ayen, ‘Kan daani mu. Dɔkku kpari kama yɔgyɔgla de. Mi ale m bisaŋa abe dua a goa kama. Mi an baga a yiri a te fi jaabɔa.’ ");
INSERT INTO bwu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ka nama wana dek doa le wa tulisi nna? Ni basi ate m weeni a sak ni ayen, wa dan poom kan baga a yiri a te fu boroboruku, fi ale ka wa doa la nyiŋ. Wa ale yiti a te fu jaab meena ate fi a yaali la dii la, fi ale ka a chali chivie alege kasim a bek la. ");
INSERT INTO bwu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ni be basi ate m weeni a sak ni ayen waai a dan a yaali jaab, wa bek Naawen ale wa le te wa, wa gisi me ale wa le nya, wa dan za dɔkku noai a nak ba le lak te wa. ");
INSERT INTO bwu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Boan nyiŋa, nuru waai abe ale a bek jaab wari la a nya kama, waai me abe ale a gisi jaab la a nya kama, waai me abe ale a nak dɔkku nɔanni la, ku a lagri kama a te wa. ");
INSERT INTO bwu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Biik a dan juisi wa ko ayen wa te wa jum wa le pa waab a te wa? ");
INSERT INTO bwu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Yaase wa dan juisi kpajein wa le pa nuoŋ a te wa? ");
INSERT INTO bwu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Alege nama baai ale chim wabanyeerisa la a dan seba tiirim maŋsa ni bisa teka m be m ŋman weeni ka ti kowa ale bo wenŋmazuk la a nin yaa wa pa Naawen Chiika a te baai a ale a juisi wa la?” ");
INSERT INTO bwu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Da yeŋ ate Yeezu yaa ŋman boro a yiak chichiribiok nuru wanyi zuk po a basi. Chichiribioku a jam ka gaauŋ a yaa nyɛ ate nuruwa chim gaauŋ me. Chichiribioku ale ga nyini la, nuruwa yaa ŋman baga a biisi ate ku deri cha nuru baai ale bo dula la. ");
INSERT INTO bwu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Alege nuruma gela a yaa jam weeni ayen, “Ka chichiribaataŋa naawa, Beelzebu ale te wa pagrimu ate wa baga a yiak chichiribaata nuruba zuima po a basi.” ");
INSERT INTO bwu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ba gela a jam a yaali ayen ba nyɛ wa a nya, yaa weeni wa ayen wa be nyɛ wari ate ba nya ate ku sak ba ayen wa pagrimu a nyini ka wenŋmazuk. ");
INSERT INTO bwu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Alege Yeezu ale jam miŋ ba popolaŋa ale ka dii la, wa yaa weeni ba ayen, “Tɛŋ kaai ale poori ka dek tɔgatɔga a kpalim chaab ale ka dek ka nyiini la, a kan beni, ka a tali ka guuta. Yie a dan a nyɛ kpaliŋsa ale chaab ba a poori ka chaab. ");
INSERT INTO bwu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Sitaana me abe ka dila degadega. Wa dan poori wa dek a ta chaab ale wa dek, wa naamu ale nyɛ ka se a baga a zaani? Nama weeni kama ayen ka chichiribaataŋa naawa, Beelzebu pagrim nyiŋ ale soa ate m baga a yiak chichiribaata nuruba zuima po a basi. ");
INSERT INTO bwu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Be dan ka wala pagrim ate mi baga a nyɛ dila, ni basi ate m bek ni ayen nama dek nuruma abe nya ba pagrimu me ka be a baga a nyɛ wa ŋala chaama? Bala abe le ba bo ni buusa ale ni le tulisi dii la. ");
INSERT INTO bwu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ku be dan ka Naawen pagrim nyiŋ ate mi baga a yiak chichiribaata nuruba zuima po a basi, ku be a sak kama ayen Naawen Naamu jam ni jigi kama. ");
INSERT INTO bwu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Nidɔa pagrɔ a dan gomsi wa dek a magsi a limsi wa yeri, wa jaab kan be. ");
INSERT INTO bwu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Alege nidɔa pagrɔ wa choa waai ale ta pagrim gaam wa la, a dan jam tu chaab ale wa a nak wa yiak, wa le tuesi ŋanta baai meena ate nuruwa a pa gomsi wa dek la kama alege a pa wa ŋantaŋa a chari wa dɔaba. ");
INSERT INTO bwu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Nuru waai abe ale kan va mi la, a kan yaali mi nyummɔa. Waai me abe ale kan basi ate mi ale wa a maa chaab a tigsi ŋantaŋa a nyo jigi yeŋ la, kula nyɔnɔwa abe ŋmasi kati a waaŋ kama. ");
INSERT INTO bwu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Chichiribiok a dan nyini nuru zuk po a ga nyini, ku yaa nyiem bo ka goanni po a cheŋ a gisi jigi ayen ku vuusi. Ku be dan kan nya jigi ayen ku vuusi, ku ŋman a weeni ka ku dek ayen, ‘M le ŋman pilim cheŋ ka yeri dii ate m basi la.’ ");
INSERT INTO bwu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wa dan jam paari wa le nya ale ba vaari yenni po kama a gomsi di a magsi. ");
INSERT INTO bwu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ku dan nya dila, ku pilim a ŋmani kama a ga a ta chichiribaata ti chaab tiyopoi tii ale ŋman chim chichiribaata dek nalimnyiini a gaam ku dek la a jam. Ti meena yaa maa chaab a jo bo nuruwa zukku po. Nna abe basi kama yɔgla, ate nuru a ŋmasi bie gaam wa ale poom liŋ ka dii la.” ");
INSERT INTO bwu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yeezu ale biisi nna a nueri la, nipɔk wanyi ale jam maa bo nuru bɔanni po a yaa lagi wa lueluku biisi ate ku jueli wein ayen, “Yeezu, nipɔk waai ale biak fu ate fi ŋoosi wa a chim la ta wein kama.” ");
INSERT INTO bwu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Alege Yeezu yaa tulisi nipowa ayen, “Aawo, ka baai ale a wom Naawen Wanni ale va di la ale ta wein.” ");
INSERT INTO bwu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nuruma a jam ŋmasi zuak ka nna yegayega a gilim Yeezu ate wa jam diem boro a sak ba. Wa yaa weeni ayen, “Jinla demma ka nuru baata, nya ba ale a bek mu ayen m nyɛ wakperikaliik ate ku sak ayen m nyini ka Naawen jigi. Mi a weeni ni kama ayen ba kan nya wakperikaliik a ŋman gum dii ale nyɛ Naawen biisiteerɔ waai ate ba a wi ayen Jona la jigi ya. ");
INSERT INTO bwu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ase Jona ale jam chim wari dii a te tɛŋ kaai ate ba a wi ayen Niineve la, dila degadega ate mi Saalobiika a le chim wari a te jinla demma me. ");
INSERT INTO bwu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tɛŋ kanyi ale boro ate ba a wi ka ayen Siiba. Tɛŋka de naawa jam ka nipɔk. Dila powa ni dek kokpieŋka Solomon a jam ka waai ale ta yam nna yegayega, ate tɛŋzuk meena jam seba wa noai po la. Da yeŋ ate Siiba Naawa de a yaa nyini wa tɛŋka a jam wa jigi ayen wa wom wa yammu sinsaŋŋa. Alege wa dii ale bo dela la a gaam Solomon kama. Ni be basi ate m weeni a sak ni ayen da dii danni ate Naawen le jam bo nuruba buusa la, Siiba Naawa de le yiri zaani kama a tɔariŋ jinla tɛŋka demma ale nin muna. ");
INSERT INTO bwu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Buusa boka danni me a dan paari, Niineve demma me le yiri zaani kama a tɔariŋ ni dii nyiŋ la, ba ale wom Jona sinsaŋŋa la, ba basi ba tuimbaataŋa tomka kama. Ni be basi ate m ŋman weeni a sak ni ayen wa dii ale bo dela la, a gaam Jona kama.” ");
INSERT INTO bwu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yeezu yaa ŋman magsi wamagsini ayen, “Nuru karo a tɔati bolimzeuŋ a pa ku sugi a yaase wa pa jaab a lik ku. Wa pa ku a zaani ka jaab zuk ate ku a nya, ate baai ale a jo dɔkku po la a nya bolimu. ");
INSERT INTO bwu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Fi nummu abe a nyɛ ase ka bolimzeuŋ a soa fi nyiŋka meena. Fi nummu abe dan nala, fi nyiŋka meena a sueri ale ka bolimu nyagsika. Alege nummu a dan kaasi fi nyiŋka meena a sueri ale ka legi. ");
INSERT INTO bwu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Be kpesi fi dek ayen jaab buui ale bo fi po la ka welensa alege daa legiya. ");
INSERT INTO bwu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Fi nyiŋka meena abe dan sueri ale welensa ate ka juijui ka biem po, ka meena be le bo ka welensa po ase fi nyiem ale tɔati bolim ate fi a nya dii la.” ");
INSERT INTO bwu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yeezu ale jam biisi a nueri la, Farisii wanyi a yaa weeni ayen ba kuli ate ba de ŋandiinta. Yeezu yaa siak ate ba jo kali ayen ba de, ");
INSERT INTO bwu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ate ku cha Farisii wa nna yegayega ate wa nya ale Yeezu a de alege an nari wa nisaŋa ase ba kisiku ale a sak dii la. ");
INSERT INTO bwu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nyɔnɔwa a yaa weeni wa ale wamagsini ayen, “Nama Farisiima a nyiem sugri ka beerisaŋa ale taasaŋa ŋaaŋsa, alege ni puusaŋa po ka varuk popola ale gaasa nyiini ale sueri. ");
INSERT INTO bwu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ni ka betta. Nama ze ayen Naawen ale nyɛ jaab ŋaaŋ la wa maa nyɛ ka wa puuka po me? ");
INSERT INTO bwu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Dila nyiŋ la ni pa ŋanta baai ale bo beerisaŋa ale taasaŋa po la a te ŋanjagsaŋa ate jaab meena a nala a te ni. ");
INSERT INTO bwu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Alege nama Farisiima a jok wein kama boan nyiŋa, ni a te Naawen ka jaab buui ate wa soa la a ta nyini ni tinaŋ masisa ale tinaŋ tɔasa ale tinaŋsa si chaab a gum du alege, chiem ni ŋaaŋ a te wensieŋa. Ni be ka yaalika me ale Naawen ya. Ku be a fe kama ayen ni te jam a yaali wensie tuima kama abe ni ta yaalika me ale Naawen abe ni kan basi ŋala meena. ");
INSERT INTO bwu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Nama Farisiima abe ŋman diem jok wein kama, dii nyiŋ la, ni a yaali ka zukpaglik sii ate ba lueri a te nuru baai ale magsi zula teka la zuima kalika ni tuka diinaŋa po. Ni be a yaali kama me ayen nuruba a puusi ni a te ni zula yaba peelitaŋa po ate waai meena a nya ni. ");
INSERT INTO bwu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ni be jok wein me kama dii nyiŋ la, ni a nyɛ ase ka boosita ale doa alege nuruba an baga a nya ti a yaase ba ze ayen ti ka boosita la.” ");
INSERT INTO bwu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Juuma Sinsaŋŋa sagrɔma po wanyi a yaa tulisi wa ayen, “M Sagrɔ, fi ale biisi nna la, fi le tama me kama.” ");
INSERT INTO bwu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yeezu yaa tulisi wa ayen, “Nama Sinsaŋŋa sagrɔma me jok wein kama dii nyiŋ la, ni basi kama ate nuruba a ji jib tii ale gaam ale jika alege nama a kan poli ayen ni pa niyeŋ a tabri ji ba. ");
INSERT INTO bwu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Boan nyiŋŋa, ni se ka boosi nalinsa a te Naawen biisiteerɔma baai dek ate nama kokpieŋsaŋa a ko la. ");
INSERT INTO bwu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Dila nyiŋ nama nyeka a sak kama ayen ni siak kama ale ni kokpieŋsaŋa ale nyɛ dii la. Boan nyiŋŋa ka bala ale ko ba ate nama me yaa a se boositaŋa a teeri ba. ");
INSERT INTO bwu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Dila ale soa ate Naawen Yammu a weeni ayen, ‘M le tom biisiteerɔba ale tuimtomdɔba ate ba jam ba jigi. Ba be le ko biisiteerɔma ale tuimtomdɔma de ba gela abe ba basi ate ba gela a nya ninam.’ ");
INSERT INTO bwu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ku be a fe kama ayen jinla demma a nya waalika ba ale ko biisiteerɔma de meena la a ta nyini diipo ate ba nyɛ tɛŋka la, ");
INSERT INTO bwu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","a ta nyini Abil a ga paari Zakaria ate ba jam ko Juuma Puusika Yenni kuŋkuŋku ale welensaŋa jigini sunsuŋ la. Ka wensie, jinla demma ale nya waalika nyaŋa de meena nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“M be ŋman a weeni ka nama Sinsaŋŋa sagrɔma ayen ni jogi wein kama, boan nyiŋŋa ka nama ale ta sebika saafiika. Ni dek abe kan jo, alege ni kan siak ayen baai ale a yaali joka la a jo.” ");
INSERT INTO bwu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yeezu ale ga basi dula jigini ale cheŋ la, Sinsaŋŋa sagrɔma ale Farisiima a jam a tɔariŋ wa kama nalimnyiini a bek wa bega nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","a pii nyiŋ a nyɛ ayen wa biisi kaasi ate ba nya siuk a bo wa buusa. ");
INSERT INTO bwu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ase nuru bɔanni ale kasim jam de tusa diichoa jigi yeŋ a yaa tabi chaab zuk la, Yeezu a yaa de niŋ a weeni wa ŋaaŋviirima ayen, “Ni kpesi ni dek ale Farisiima dabintaŋa, mi a weeni ka ba pimpaasimaŋa. ");
INSERT INTO bwu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Wari karo ayen di suk yɔgyɔgla a dua ate di kan maari a nyini peelim chum diipo. Wari dii meena me ale chim wasusugi la, ku a fe kama ayen di nyini peelim ate nuruba seba. ");
INSERT INTO bwu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Dila nyiŋ la, fi dan biisi wari legi po, ku a fe kama ayen kantueŋ ba wom di. Wari dii me ate fi waasi dɔk po la, ku a fe kama ayen di jueli gboŋ ate nuruba wom. ");
INSERT INTO bwu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“M dɔaba, ni kan a chali yɔgsum ale nurubiiga. Wa baga a ko ka fi nyiŋka alege ku ŋaaŋnyiŋ wa an ŋman baga a nyɛ fi wari di choa. ");
INSERT INTO bwu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ni basi ate m dak a sak ni waai ale magsi ayen ni a chali yɔgsum la. Wala ale Naawen, waai ale wa ko fu abe wa ta pagrim a ŋman pa fu a yuk basi bolim buui ale kan maari kpi la po. Wensie ate mi a weeni ayen ka wala ate ku a fe ayen ni chali wa yɔgsum. ");
INSERT INTO bwu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ba kan yik nuin fiisa sinu a da ka ligbie ŋaye? Alege Naawen kan baŋ bunyi la wari ya. ");
INSERT INTO bwu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Naawen poom seba fi zukku zuisaŋa ale piisi soa dii la kama. Dila nyiŋ la, ni kan chali yɔgsum, boan nyiŋŋa, Naawen jigi nama gaam nuin fiisa diichoa kama. ");
INSERT INTO bwu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nuru waai a dan nyini peelim nuruba niŋ a weeni ayen wa va ka mi, Mi Saalobiika me a le nyɛ ka dila degadega Naawen sabiiloma niŋ. ");
INSERT INTO bwu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Alege waai me a dan nyini peelim nuruba niŋ a zɛri mi, Mi Saalobiika me a le nyini ka peelim a zɛri wa me Naawen sabiiloma niŋ. ");
INSERT INTO bwu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Nuru waai a dan le Mi Saalobiika kula nyɔnɔwa a le nya voŋteka kama, alege waai a dan le Naawen Chiika, kula nyɔnɔwa kan nya voŋteka. ");
INSERT INTO bwu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nuruba dan yik fu a ta jam zaani tuka diinaŋa po a yaase nalima niŋ a yaase kpaga niŋ, ayen ba bek fu bega, kan basi ate ku daani fu ale fi le fi nyɛ dii a biisi nyini la a yaase fi le fi biisi dii la, ");
INSERT INTO bwu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","dii nyiŋ la, dila powa, Naawen Chiika a le sak fu fi le fi biisi dii la.” ");
INSERT INTO bwu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nuru a yaa nyini nuru bɔanni po a bek Yeezu ayen, “Sagrɔ, weeni m suoku ate wa basi ate ti lueri ti kowa ale tali ŋanta baai a te ti la a chari chaab.” ");
INSERT INTO bwu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yeezu yaa tulisi wa ayen, “M doa, ka wana ale te mi siuk ayen m bo nama buusa a yaase m lueri ŋanta a chari nama niyewa?” ");
INSERT INTO bwu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yeezu bek ba dila alege a yaa weeni nuru bɔanni meena ayen, “Ni kpesi ni dek ate ni kan chim ŋanyaalik nyamma dii nyiŋ la, nyuvuri potim daa ni nin a nya ŋanta yegayega.” ");
INSERT INTO bwu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yeezu yaa magsi wamagsini de a sak ba ayen, “Jigsiro ale jam ta wa talim ate bu yaa ta ŋanta nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Wa yaa poli ayen, ‘M ka jigi a nyo m ŋantaŋa de meena du. M le nyɛ ka se?’ ");
INSERT INTO bwu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Wa yaa ŋman weeni wa dek ayen, ‘M le nyɛ ka nna: M le nak ka m buaŋa a lonsi abe m se bu kpeema a pa m ŋantaŋa meena a nyoro. ");
INSERT INTO bwu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","M dan nyɛ dila a nueri m yaa weeni m dek ayen, m dega, fi ta ŋandiinta ka nna yegayega a de ate ku ga a paari bena yegayega. Kan a yiili, a de abe fi a nyu abe fi a nyɛ fi yaaka.’ ");
INSERT INTO bwu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Alege Naawen yaa weeni wa ayen, ‘Fi ka beruk, yokku de ku a fe kama ate fi kpi. Be ka wana a le wa soa fi ŋantaŋa de meena ate fi gomsi zaani la?’ ");
INSERT INTO bwu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Ku be ale ka dii la ale la ale baai ale kasim pa ŋanta a zaani a jigsi la jigi alege Naawen nimbie po ba ka jaabɔa.” ");
INSERT INTO bwu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yeezu yaa weeni wa ŋaaŋviirima ayen, “Dila abe ale soa ate mi a weeni ni ayen ni kan a yiili ale ni nyuvooŋa, ase ni le nya ŋandiinta ka be a de vuugi, a yaase gatta a jo lik ni nyiŋsaŋa. ");
INSERT INTO bwu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Dii nyiŋ la, nyuvuri a gaam ŋandiinta kama, fi nyiŋka me abe gaam gatta kama. ");
INSERT INTO bwu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nama dek abe nya tɛŋka nuinsaŋa, si kan bori ŋanta yaase si a che ŋanta, si ka bua ayen si pa ŋanta a nyoro, alege nyaku de meena ka Naawen ale a te si ŋandiinta. Nama abe gaam nuinsa kama! ");
INSERT INTO bwu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ni basi ate m bek ni wari, ka nuru wana dek ale kasim a yiili ale wa bena noai ate wa yiilika a basi ate bein yeŋ la a lueri gum wa benaŋa po? ");
INSERT INTO bwu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Fi be dan kan baga a nyɛ wa fiika de, ka boan ale soa ate fi a yiili nyaŋa de meena. ");
INSERT INTO bwu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ni ŋman nya tiisaŋa ale wuutaŋa ale a nyɛ ba puutaŋa la, ba kan tom a yaase ba a yok gatta, alege ni basi ate m weeni sak ni ayen Nakpioŋku Solomon ale jam jigsi dii nna yegayega la, wa jam ka gatta ate ti nala a paari tiisaŋa ale wuutaŋa de puutaŋa. ");
INSERT INTO bwu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Alege Naawen abe dan a te ti ga tila chaab wuutaŋa de tii nyiem ale boro jinla alege chum ba ŋman pa ti nyo bolim po la, ku a fe kama ayen wa te nama me gatta. Ka boa ale soa ate nama siaka an soa diiya? ");
INSERT INTO bwu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Dila nyiŋ ni kan kasim a yiili abe ni pa ni popola meena a basi ni ale ni de abe nyu jaab buui la jigiya. ");
INSERT INTO bwu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Dii nyiŋ la, ka baai ale kan seba Naawen la ale kasim chali a vi ŋantaŋa de, alege nama kowa poom seba ayen nama me a yaali ŋantaŋa de kama. ");
INSERT INTO bwu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Dila nyiŋ ni de niŋ a pa ni popola meena a basi Naawen naamu po alege ate Naawen a yaa basi ate ŋantaŋa de meena me a jo ni nisa po.” ");
INSERT INTO bwu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yeezu yaa ŋman weeni ayen, “Nama baai ale kan piisi la ate mi a weeni ni ayen, ku an magsi ayen ni a chali yɔgsum, dii nyiŋ la, ni kowa poli kama ayen ku ka wamaŋ nna yegayega ate wa pa wa naamu a te ni. ");
INSERT INTO bwu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ni pa ni ŋanta baai ate ni ta la a da a pa ligraŋa a te ŋanjagsa. Ni yaali ligra fot tii ale kan maari a kaasi la, ate ni jigsika meena a bo wenŋmazuk juijui ate ŋanta kasim boro taam wuu ate zueba an baga zu la, a yaase ŋanta an baga de ba la. ");
INSERT INTO bwu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Dii nyiŋ la, ni jigsika ale bo juijui la, ni sunummu me a bo ka dula. ");
INSERT INTO bwu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Ni gomsi ni dek a limsi Mi Saalobiika jamka ase yom nyiem ale gomsi ba dek dii a limsi ate ba nyɔnɔwa ga nyini nipɔk faarika tigi po a jam la. Tomteerɔma nyiem jo ka ba gattaŋa a tɔati ba kanaasaŋa ate ba nyɔnɔwa yaa dan jam a wi ba abe ba lagi dɔkku nɔanni bunyi dekki ate wa yaa jo. ");
INSERT INTO bwu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Baai ate ba nyɔnɔ a jam a paari ale ba kan goa la, ta wein kama. Wensie, wa dan jam nya dila, wa le yeeri wa kasaauku a dueni tɛŋ abe wa de niŋ a yik ba kali ate ba de ŋandiinta ate wa dek a de niŋ a poom nyɛ ŋandiintaŋa a chari. ");
INSERT INTO bwu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ba nyɔnɔwa a dan ŋman pilim jam a paari yok dii po ale ba kan goa, tomteerɔ bala ta wein kama. ");
INSERT INTO bwu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Alege yɔgyɔgla de ni basi ate m weeni a sak ni ayen, yenni nyɔnɔwa abe dan seba dii po ate zuewa a le jam wa yenni la, wa te kan goa ale ge basi ate ba a kaasi wa yenni a jo di po. ");
INSERT INTO bwu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Dila nyiŋ la, mi a weeni ni kama ayen ku a fe kama ate nama me gomsi ni dek a magsi dii nyiŋ la, Mi Saalobiika a le jam ka diipo ate ni kan poli ayen m le jam la.” ");
INSERT INTO bwu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Piita yaa bek Yeezu ayen, “M Nyɔnɔ, fi a weeni wamagsini de a sak ka tama nyiini yaa waai meena?” ");
INSERT INTO bwu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yeezu yaa weeni ayen, “Ku be a fe kama ayen ni meena chim yanta nyam ase tomteerɔ waai ale ka yam nyɔnɔ ate wa nyɔnɔwa yaa lueri wa ayen wa a nya wa yenni zuk nalimnyiini abe wa a nyɛ ŋandiinta a te yom bimbala diipo meena ale magsi ayen wa nyɛ a te ba la. ");
INSERT INTO bwu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Alege tomteerɔ waai ale nyɛ nyaku de ate wa nyɔnɔwa nyiem a jam yeri a yaa nya la, ta wein kama. ");
INSERT INTO bwu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Wensie, ate mi a weeni fu ayen wa nyɔnɔwa a le pa wa ŋantaŋa meena a nyo ka wa nisa po ayen wa a nya. ");
INSERT INTO bwu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Alege tomteerɔwa a dan weeni ayen wa nyɔnɔwa goa a beni ka yegayega ale jamka, ate wa yaa yiri a nak wa yom bimbala, nidɔama ale nipooma meena a gum chaab alege a yaa nyɛ ŋandiinta a de ale nyu daam buk, ");
INSERT INTO bwu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","wa nyɔnɔwa ale ŋman pilim a jam ka da dii danni ate wa kan poli ayen wa le jam la. Wa nyɔnɔwa a dan jam paari, wa le te tomteerɔwa de ka waalika ase baai ale kan a va Naawen noai la po. ");
INSERT INTO bwu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Tomteerɔ waai ale seba wa nyɔnɔwa ale a yaali ayen wa nyɛ dii a te wa alege wa kan gomsi wa dek a nyɛ la, ale nya ka waalika ale nagta nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Alege tomteerɔ waai ale kan seba wa nyɔnɔwa ale a yaali ayen wa nyɛ dii a te wa alege wa nyɛ wari dii ale magsi wa nya nagta la, wa le nya ka nagta nna magla. Nuru dan te fu yegayega, wa a poli ayen wa tuesi fi jigi ka yegayega me. Wa be dan te fu nna yegayega gaam taam, wa poli ayen wa tuesi fi jigi ka nna yegayega me a gaam taam.” ");
INSERT INTO bwu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yeezu yaa weeni ayen, “M jam ayen m cheeni ka bolim a basi tɛŋzuk. M dek be a yaali kama ayen bu te tɔati ya. ");
INSERT INTO bwu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","M ta ka ninam ayen m musi bu po ase nuru ale a musi nyiam po dii la. M sui abe kaasi kama ase ka m nin tuesi ninammu de a nueri. ");
INSERT INTO bwu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nama a poli ayen mi jam ayen m ta ka suyɔgini a jam tɛŋzuk de? Aawo, ni basi ate m weeni a sak ni ayen m jam ayen m ta ka chaab poorika jam. ");
INSERT INTO bwu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","A ta nyini yɔgyɔgla a cheŋ, nuruba banu a dan bo ba yeri po, ba le poori ka tɔgatɔga ate nuruba bata a maa chaab a ta chaab ale nuruba baye. ");
INSERT INTO bwu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ate ko ale ta chaab ale wa biik ate biika me a ta chaab ale ka kowa. Ate ma ale ta chaab ale wa lie ate lie wa me a ta chaab ale wa mawa. Ate ŋianipɔk ale ta chaab ale wa sampɔk ate sampowa me a ta chaab ale wa ŋianipowa.” ");
INSERT INTO bwu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yeezu yaa ŋman weeni nuruma ayen, “Nama nyiem a dan ga nya chiŋmari ale di sobri ni deri a poli kama ayen ka ŋmoruk ale a yaali ku ni ate ku sum ni. ");
INSERT INTO bwu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ni nyiem a dan ga nya ale viok a nyini yiseok geŋ a cheena, ni a poli kama ayen wulum wein a mɔata ate bu sum jam. ");
INSERT INTO bwu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ni ka pimpaasiroba. Ni baga a nya tɛŋka ale chiŋmaaŋa kama a baga a seba ku ale ka dii la. Be ka boa ale soa ate ni an baga miŋ wa ŋaai ale a nyɛ yɔgyɔgla la? ");
INSERT INTO bwu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ka boa ale soa ate ni an baga a poli wa dii ale magsi nyeka la? ");
INSERT INTO bwu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nuru a dan poti ni a ta ni cheŋ, ni biisi magsi chaab ate wa kan dari ni ale pagrim a ta cheŋ nuru waai ale a biisi biisaŋa la jigiya. Wa dan nyɛ dila biisaŋa nyɔnɔwa a le pa ni a nyo ka polisa nisa po ate ba me yaa pa ni a nyo likka dɔk po. ");
INSERT INTO bwu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","M be le weeni ni ayen, ni be nya ba kan lagi ni ate ni nyini ase ka ni nin tuni pamini meena a kan tali ale ligbiri me la.” ");
INSERT INTO bwu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yeezu ale jam boro a biisi la, nuruba gela a yaa jam weeni a sak wa naawa Paalɔt ale ko Galili demma ba gela ba ale jam boro a nyɛ kaabka a te Naawen dii la. ");
INSERT INTO bwu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ba ale weeni sak wa dila la, wa yaa tulisi ba ayen, “Nama a poli ayen Galili demma de baai ale jam nam nna la, a chim ka tuimbaata nyam a gaam Galili demma mbala? ");
INSERT INTO bwu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aawo, ni be dan kan basi ni tuimbaataŋa tomka, nama me le kpi ka bala ale kpi dii la. ");
INSERT INTO bwu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yaase ni basi ate m ŋman bek ni ayen, nama a poli ayen nuruba pi ale naaniŋka ate Jerusalem tɛŋka Sailom yeri kpien woŋku a jam lo ba zuk a ko ba la a chim ka tuimbaata nyam a gaam nuru baai meena ale bo Jerusalem tɛŋka po la? ");
INSERT INTO bwu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aawo, alege mi a weeni kama ayen ni dan kan basi ni tuimbaataŋa nama me le kpi kama.” ");
INSERT INTO bwu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yeezu yaa magsi wamagsini ayen, “Nuru ale jam ta kiŋkaŋ wa talim po. Nuruwa yaa yiri da yeŋ a yaali moota alege wa an nya jaabɔa. ");
INSERT INTO bwu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Wa yaa weeni waai ale a nya talimu zuk la, ayen, ‘Nya de, bena ŋata ale nna ate mi kasim a yaali moota kiŋkaŋka de zuk alege kan nya jaabɔa. Che bu lonsi, ale mi ze jaab buui nyiŋ ale soa ate bu a de tɛŋka ŋandiintaŋa la.’ ");
INSERT INTO bwu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Wa yaa tulisi wa ayen, ‘M nyɔnɔ, basi ate bu zaani benni de ŋmani ate m tu gilim bu a nyɛ bibaam a yuk gilim bu. ");
INSERT INTO bwu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Bein a dan ŋman paari ate bu yoani, ku nala, alege bu dan kan yoani ya, fi yaa che lonsi.’ ” ");
INSERT INTO bwu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Da yeŋ ba Vuusum Danni dinyi dai ate Yeezu jam boro a sak nuruba ba tuka diinaŋa kunyi po. ");
INSERT INTO bwu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nipɔk wanyi a yaa jam maa boro ate chichiribiok a bo wa zuk po a nyɛ ate wa chim gbaruk a paari bena pi ale naaniŋ. Tuemu a jam nyɛ kama ate wa gori an ŋman baga a teenti wa dek a zaani. ");
INSERT INTO bwu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yeezu ale ga nya wa la, wa yaa wi nipowa ayen, “Nipowa, fi kan ŋman chim gbaruwa”, ");
INSERT INTO bwu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","a yaa pa wa nisaŋa a vi nipowa zuk ate wa yaa deri teenti wa dek bunyi dekki a yiri zaani ŋmai a te Naawen pimpauk. ");
INSERT INTO bwu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Alege tuka dɔkku kpagini ale ga nya dila la, wa sui yaa puuri dii nyiŋ la, ku jam ka ba Vuusum Daaŋa po dinyi ate Yeezu nyɛ dila. Tuka dɔkku kpagini a yaa weeni nuruma ayen, “Daa ŋayuebi ale boro ate ti pa ŋala a tom tuima. Nuru waai a dan a yaali ayen wa nya tebika wa jam daaŋa de po. Ku daa ti Vuusum Danni ate ba a nyɛ dila!” ");
INSERT INTO bwu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yeezu yaa tulisi wa ayen, “Nama ka pimpaasiroba boan nyiŋŋa, nama wanyi wanyi a foli ni niiga ale ni bonsaŋa kama a nya ba zuk a ta a cheŋ ate ba a nyu nyiam ni Vuusum Danni. ");
INSERT INTO bwu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yɔgyɔgla, be ka Abraham ŋaaŋbiik ale nna ate Sitaana kasim ta wa keŋkeŋ a ga paari bena pi ale naaniŋ. Ku be an magsi ayen mi me foli nipowa de ale bo Sitaana nisa po la Vuusum Danni?” ");
INSERT INTO bwu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yeezu tulisika de a jam pa wa dachaasaŋa nyo ka chivie po nna yegayega alege nuruma sue a jam peenti ka nna yegayega ale wakperikaliik sii ate Yeezu jam nyɛ la. ");
INSERT INTO bwu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yeezu yaa bek ayen, “Naawen Naamu a nyɛ ase ka boan la? M le pa ka boan jaab a magsi chaab ale bu? ");
INSERT INTO bwu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Bu a nyɛ ase ka nna la. Bu a nyɛ ase ka be dii ate ba a wi ayen ‘mastad’ ate nuru yaa pa bori wa talim po la. Binni a yaa nyini a chim tiib ate nuinsa yaa jam a yok si tugta bu naŋsaŋa nyiŋ.” ");
INSERT INTO bwu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yeezu ŋman bek ayen, “M be le ŋman pa ka boa a magsi chaab ale Naawen Naamu? ");
INSERT INTO bwu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Bu a nyɛ ase ka dabinta ate nipɔk a pa nyo taasi kpeeni ale boroboruk zom po ate bu piri nna yegayega a sueri di meena dii la.” ");
INSERT INTO bwu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yeezu yaa va tɛŋkpieŋsaŋa ale tɛŋ fiisaŋa po a cheŋ Jerusalem ale a sak nuruma. ");
INSERT INTO bwu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nuru wanyi a yaa bek wa ayen, “M Nyɔnɔ, nuru baai a le ba nya varibasika la an soa diiya?” Yeezu yaa tulisi ba ayen, ");
INSERT INTO bwu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ni nyɛ nyiŋbiiri ate ni va dɔk kuui nɔanni ale kan soa dii la a jo dii nyiŋ la nuruba yegayega a le ba pii nyiŋ ayen ba va dula jo alege ba kan baga. ");
INSERT INTO bwu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yenni nyɔnɔwa yaa dan yiri lik dɔkku nɔanni ni yaa weeni ayen, ‘M nyɔnɔ lagi dɔkku nɔanni a te ti.’ Ni dan weeni dila, wa le tulisi ni ayen, ‘Mi ze ni ale nyini ka juijui la.’ ");
INSERT INTO bwu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ate ni yaa weeni wa ayen, ‘Tama ale fi a de ŋandiinta ale chaab kama. Fi be sak nuruba tama tɛŋka kama.’ ");
INSERT INTO bwu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Alege wa le ŋman tulisi ayen, ‘Mi ze ni le nyini ka juijui la. Nama gaasa nyamma, ni be mi niŋ!’ ");
INSERT INTO bwu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ni ni a kum kama abe ni pa nisima a su noa po a dom ase ni nin nya Abraham ale Aizik ale Jekob ale Naawen biisiteerɔma meena a bo Naawen Naamu po. Dila powa ale nama bo ka bu peelim. ");
INSERT INTO bwu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nuruba ale nyini kori geŋ ale yeri niŋ geŋ ale yiseoku geŋ ale wiiluku geŋ a jam kali fi jigi, fi jigi tigi kpeeni po Naawen naamu po. ");
INSERT INTO bwu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ate ba gela baai daam ale wari ŋaaŋ yɔgyɔgla la a yaa de niŋ ale ge ate ba gela me baai ale de niŋ yɔgyɔgla de la a yaa wari ŋaaŋ.” ");
INSERT INTO bwu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Yeezu ale boro a biisi la, Farisiima ba gela a yaa jam wa jigi a weeni wa ayen, “Ku a fe kama ayen fi basi dela jigini abe fi nyini a cheŋ jigi yoŋ dii nyiŋ la, Naawa Ayerod a yaali ayen wa ko fu kama.” ");
INSERT INTO bwu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yeezu yaa tulisi ba ayen, “Ni ga weeni pimpaasima nyɔnɔwa ayen m bo ka dela a yiak chichiribaata nuruba zuima po a basi ale a tebi ba gela me jinla ale chum ate vonuŋ a dan paari abe m nueri m tuimaŋa. ");
INSERT INTO bwu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Alege ku a fe kama ayen m bo m siuku po a cheŋ jinla ale chum ale vonuŋ dii nyiŋ la, ku an magsi ayen Naawen biisiteerɔwa a kpi jigi jigiya, ka Jerusalem tɛŋka po nyiini ate wa le kpi.” ");
INSERT INTO bwu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yeezu yaa ŋman weeni ayen, “Oo, Jerusalem, Jerusalem, tɛŋ kaai demma ale a yuk Naawen biisiteerɔma, baai ate wa tom ba ni jigi la ni yuk ale tana a ko. Ka bu dina ate mi kasim a yaali ayen m yik ni nuruma a pɔbi ni ase kpiak ale a pɔbi ka bisa dii la alege ni kasim a zɛri? ");
INSERT INTO bwu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Dila nyiŋ la, da yeŋ cheena ate Juuma Puusika Yenni a kan nya nuru di po. Be ka wensie ate mi a weeni ni ayen ni kan ŋman nya mi alege ate di danni jam ate ni yaa weeni ayen, ‘Naawen le niak waai ale a jam ti Nyɔnɔwa yonni nyiŋ la.’ ” ");
INSERT INTO bwu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Vuusum Daaŋa dinyi ale jam paari la, Yeezu yaa cheŋ Farisii denowa wanyi yeri ayen wa de ŋandiinta. Nuruwa jam ka kpagi. Dila danni Farisiima ale Naawen Sinsaŋŋa sagrɔma yaa kasim jam a nya Yeezu ase wa le nyɛ wari ya. ");
INSERT INTO bwu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nuru wanyi a yaa boro ate wa nisima ale wa naŋsa a jam fuusi nna yegayega a yaa za Yeezu niŋ ");
INSERT INTO bwu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ate Yeezu yaa bek Sinsaŋŋa sagrɔma ale Farisiima ayen, “Sinsaŋŋa a siak ate nuru a tebi yɔgnyeensa Vuusum Danni yaa ŋa kan siagi?” ");
INSERT INTO bwu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Alege ba an tulisi wariya. Yeezu yaa tebi nuruwa ate wa kuli. ");
INSERT INTO bwu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yeezu yaa bek ba ayen, “Ase ni wanyi a nin ta biik yaase naab ate ba wanyi a yaa lo vilini po Vuusum Danni, ni kan yeeri biika, yaase naamu Vuusum Danni dila degadega a ta a nyini?” ");
INSERT INTO bwu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Alege ba an jam baga a tulisi wa beŋŋa de me po. ");
INSERT INTO bwu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ba ale jam a kali ayen ba de la, Yeezu yaa nya ale nichamma ba gela a lueri jigi maŋsaŋa a kali. Yeezu ale nya dila la, wa yaa biisi magsi wamagsini ayen, ");
INSERT INTO bwu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nuru a dan wi fu ayen fi jam maa de tigi ŋandiinta, kan kali jigi maŋŋa. Dii nyiŋ la, ku baga a nyɛ kama ate nuru waai ale ŋman chim nuru kpioŋ a gaam fi la a jam ayen wa maa de tigini ŋandiintaŋa. ");
INSERT INTO bwu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ku dan nyɛ dila, nuru waai ale wi fu ayen fi jam a maa de tigini ŋandiintaŋa la, a le jam ŋaaŋnyiŋ a weeni fu ayen fi yiri abe fi ge ate nuru waai ale ŋman gaam fu la a kali. Dila abe a ta ka chivie a jam fi jigi, dii nyiŋ la, wa ale weeni fu ate fi siŋ tɛŋ la nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Alege, nuru abe dan wi fu ase dila la, fi dan cheŋ, ga kali juijui ale kan magsi fi kali la, ate waai ale wi fu la a yaa jam fi jigi a weeni fu ayen, ‘M doa, yiri jueli jam kali jigi maŋka de.’ Nna le ta zula a jam fi jigi ate waai meena nya. ");
INSERT INTO bwu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Dii nyiŋ la, nuru waai ale pa wa dek a chim nuru kpioŋ la, ba le zaab wa, alege nuru waai ale a zaab wa dek la, a le chim ka nuru kpioŋ.” ");
INSERT INTO bwu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yeezu yaa weeni Farisii waai ale wi wa ayen wa jam ate ba de la ayen, “Fi dan nyɛ kantueŋ a yaase yok ŋandiinta a poli ayen fi wi ate nuruba jam maa de, kan wi fi dɔaba yaase fi suaata yaase fi mabisa yaase fi kalimotido baai me ale jigsi la, dii nyiŋŋa la, bala meena waai a dan nyɛ ŋandiinta tigi, ase dila la ba pilim a wi fi me kama. Dila abe dan nyɛ, ku a sak ase fi nya fi ale nyɛ dii la tutuna kama. ");
INSERT INTO bwu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Fi dan ta ŋandiinta tigi, wi ŋanjagsa, ");
INSERT INTO bwu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ale gbatta, ale gbaŋsa, ale yeeba ate fi nya niaka, dii nyiŋ la, bala waai an baga nyɛ wari ase dila la a tuni fu. Ka Naawen a le wa tuni fu dai dii danni ate wayɔrisima nyam le yiri kum po la.” ");
INSERT INTO bwu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nidɔama wanyi ale jam maa kala a de ŋandiintaŋa la a yaa wom dii ate Yeezu a weeni la a yaa weeni wa ayen, “Baai a le ba kali a de Naawen Naamu tigini ŋandiintaŋa la, ta wein kama.” ");
INSERT INTO bwu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yeezu me yaa tulisi wa ale wamagsini ayen, “Nuru ale jam nyɛ wa ŋandiinta tigi nna yegayega a yaa wi nuruba nna yegayega ayen ba jam de. ");
INSERT INTO bwu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ba ale ga dik ŋandiintaŋa a nueri la, wa yaa tom wa tomteerɔwa ayen wa nyiem a weeni baai meena ate wa wi la ayen ba jam ale jaab meena a gomsi magsi kama. ");
INSERT INTO bwu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Alege ba meena wanyi wanyi a yaa tulisi ayen ba kan nya siuk a jam. Waai ate tomteerɔwa a de niŋ ga weeni la, yaa weeni ayen, ‘M da ka tɛŋ ate ku a fe ayen m ga nya ka. Mi a saalim mi an baga a jam.’ ");
INSERT INTO bwu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wanyi me a jam weeni ayen, ‘M da ka m lalikpaansa bunu ate mi a cheŋ ayen m ga pa si kpa nya. Mi a saalim mi an baga a jam.’ ");
INSERT INTO bwu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wa choa me a jam weeni ayen, ‘M faari ka nipɔk, dila nyiŋ mi an baga jam.’ ");
INSERT INTO bwu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Tomteerɔwa a yaa ŋman kuli a ga weeni wa nyɔnɔwa nyaŋa de meena. Ku yaa puuri wa nyɔnɔwa sui nna yegayega ate wa weeni wa tomteerɔwa ayen, ‘Chali nyini tɛŋka po su kpeentaŋa niŋ ale gugottaŋa po a wi ŋanjagsa ale gbatta ale yeeba ale gbaŋsa ate ba jam.’ ");
INSERT INTO bwu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ku an bola beni ya ale ge ate tomteerɔwa a nyini a pilim jam weeni wa ayen, ‘M nyɔnɔ, m nyɛ dii ate fi weeni mu ayen m nyɛ la kama. Ba jam kama alege dɔkku an diem sueriya.’ ");
INSERT INTO bwu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tomteerɔwa nyɔnɔwa yaa ŋman weeni wa ayen, ‘Cheŋ jigi ŋaai meena ale kali gilim tɛŋka po la a ga fe nuruba ate ba jam sueri m yenni. ");
INSERT INTO bwu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mi ale a weeni ni ayen baai meena ate m liŋ wi la, ba wanyi me la noai a kan tiri mi ŋandiintaŋa de.’ ” ");
INSERT INTO bwu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Da yeŋ ate nuru bɔari a yaa va Yeezu a cheŋ ate wa chiem a weeni ba meena ayen, ");
INSERT INTO bwu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nuru waai ale a jam mi jigi ayen wa chim m ŋaaŋviiro la an baga a chim ase kula nyɔnɔwa a nin ta yaalika ale mi a gaam wa ale a yaali wa ko, yaase wa ma, yaase wa pɔk yaase wa bisa yaase wa suaata yaase wa tɔaba yaase wa dek me dii la. ");
INSERT INTO bwu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Waai a dan a yaali ayen wa va mi alege an gomsi wa dek a magsi kummɔa, kula nyɔnɔwa an baga chim mi ŋaaŋviiro. ");
INSERT INTO bwu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ase ni wanyi a dan a poli yeri kpien woŋ jueli wein seka, wa a kali ka zimm a poli wa a le wa pa jaab buui ale jaab buui a se ate yenni ga nueri la. Wa ale poli nya me ase wa ta ba yegayega ya. ");
INSERT INTO bwu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kan daa di, wa dan nyubi nyubini alege wa an baga a se nueriya waai meena le nya wa ale nyɛ dii la a la wa kama ");
INSERT INTO bwu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","a weeni ayen, ‘Ni nya nuruwa de ale piilim wa yeri seka alege an baga a se nueri yie.’ ” ");
INSERT INTO bwu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Yeezu ŋman pilim magsi di choa ayen, “Naab abe dan nyini peelim ale nuruba tusa pi ayen wa kpalim chaab ale naab wa choa waai ale ta nuruba tusa pisiye la, ku a fe kama ate wa kali tɛŋ zimm a poli a nya ase wa ta pagrim yegayega a baga tu chaab ale naab nwala ya. ");
INSERT INTO bwu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Wa be dan nya ale wa an baga, wa a tom ka nuruba ate ba de niŋ a ga tu naab nwala siuku po a saalim wa ate ba nyɛ magsi chaab alege ate naawa dek a diem bo siuku po niŋniŋ a cheena.” ");
INSERT INTO bwu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yeezu yaa weeni ayen, “Dila nyiŋ la mi a weeni ni kama ayen ni wanyi me la an baga chim mi ŋaaŋviiro ase ka wa nin yeeri wa nisa jaab buuri meena ate wa ta la po. ");
INSERT INTO bwu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Yesa masa kama, alege si masimu a dan kan boro fi an ŋman baga nyɛ ate si a masa. ");
INSERT INTO bwu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Si ŋman ka kiriya a magsi bibaam a yaase jaabjaab pa nyeka ba be yuk si a basi kama. Waai abe ale ta tue a wom mi ale a biisi dii la, ni basi ate wa wom.” ");
INSERT INTO bwu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Da yeŋ ate lampoo cheesiroba yegayega ale wabaata nyam bachaab a jam ayen ba wom Yeezu sinsaŋŋa. ");
INSERT INTO bwu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Farisiima ale Juuma Sinsaŋŋa sagrɔma a yaa maa chaab a ŋuuni a weeni ayen, “Nuruwa de a pa wa dek a gum chaab ale ka wabaata nyam ale a de ale ba me.” ");
INSERT INTO bwu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yeezu yaa weeni wamagsini a bek ba ayen, ");
INSERT INTO bwu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ase ni wanyi a nin ta piisa kook ate kunyi be, wa a nyɛ ka se? Wa le basi ka pa ŋaŋŋala pineuk ale neoku sagini po alege yaa nyiem a gisi kuui ale be la ate wa nya ku. ");
INSERT INTO bwu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Wa dan ga nya ku wa sui ale peenti yegayega ate wa a zak ku a vi ŋmankpala ta kuli. Wa dan ta kuli wa yaa wi baai ale kali mɔata wa la ale wa dɔama a ta ba jam jigi yeŋ a weeni ba ayen, ‘M sui peenti ka nna yegayega dii nyiŋ la, m nya pa kuui ale be la kama. Ni be basi ate ti meena sue peenti’ ");
INSERT INTO bwu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mi a weeni ni kama ayen ka supeentik kala degadega ale ka bo wenŋmazuk ase tuimbaata nyɔnɔ wanyi a nin basi wa tuimbaataŋa tomka. Wala nyiŋ, supeentik yegayega bo wenŋmazuk kama ale waai ale tagri basi wabaata nyeka la a gaam supeentik kaai ate wa ta ale nuruba pineuk ale neok baai ale ka wayɔrisima nyam la kama.” ");
INSERT INTO bwu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yeezu yaa ŋman magsi wamagsini di choa ayen, “Ase nipɔk wanyi a nin ta ligbie pi ate ligbinni dinyi a yaa be wa a nyɛ ka se? Wa tɔati ka bolimzeuŋ a vari dɔkku meena a gisi nalimnyiini ate wa ga nya di. ");
INSERT INTO bwu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Wa dan ga nya di wa ale wi wa dɔama ale baai ale kali mɔata wa ate ba jam jigi yeŋ a weeni ba ayen, ‘M sui peenti yegayega dii nyiŋ la, m nya m ligbie dii ale be la kama. Ni be basi ate ti sue peenti.’ ");
INSERT INTO bwu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Supeentik kala dega dega ate Naawen Sabiiloma a tara ase tuimbaata nyɔnɔ wanyi a nin basi wa tuimbaata tomka.” ");
INSERT INTO bwu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yeezu yaa ŋman magsi wamagsini di choa ayen, “Nuru ale boro a ta wa nidɔabilisa baye. ");
INSERT INTO bwu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wa bibaaŋka a yaa weeni wa ayen, ‘M koa, ŋanta baai ate fi ale lueri a chari mi ale m suoku la, pa mi ŋantaŋa a te mi yɔgyɔgla.’ Nuruwa yaa siak a yaa chari ba wa ŋantaŋa. ");
INSERT INTO bwu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Daa magla ale ga taam la, bibaaŋka a yaa pa wa ŋantaŋa meena a da a yaa yiri cheŋ satɛŋ nna niŋniŋa. Dula jigini wa yaa nyɛ nanbolini a kaasi wa ligraŋa meena. ");
INSERT INTO bwu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Wa ale ga de wa ŋantaŋa meena a nueri la, kom nna yegayega a yaa jam tɛŋ kala alege wa ŋman ka jaabjaabɔa. ");
INSERT INTO bwu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Wa yaa cheŋ tɛŋ kala nuru wanyi jigi ate nuru wala a yaa ta wa a cheŋ wa talim ayen wa a nya die zuk. ");
INSERT INTO bwu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Wa sui ate jam peenti kama yegayega ase wa nin nya siuk a maari a de deeŋa ŋandiintaŋa, alege nuru an jam te wa jaabjaabɔa. ");
INSERT INTO bwu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Alege ku ŋaaŋnyiŋ ate wa yammu jam la, wa yaa weeni wa dek ayen, ‘M kowa tomteerɔma meena a ta ŋandiinta ka nna yegayega a gaam ba deka alege mi bo dela ayen m kpi ale kom. ");
INSERT INTO bwu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","M le yiri kama a kuli ga weeni m kowa ayen, M Koa, m tom ka wabiok Naawen ale fi jigi. ");
INSERT INTO bwu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ku an ŋman magsi fi ale wi mu ayen fi biiga, a nyɛ mu ase fi tomteerɔma po wanyi la.’ ");
INSERT INTO bwu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Biika ale ga poli dila la, wa yaa deri yiri a kuli wa kowa jigi. “Wa ale jam bo siuku po a cheena yeri la, wa kowa a yaa nya wa. Jiirim a yaa yik wa kowa ate wa chali nyini a ga tu wa siuku niŋ a pa wa nisaŋa meena gbaari wa biika alege a yaa puusi wa. ");
INSERT INTO bwu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Biika yaa weeni ayen, ‘M koa, m tom ka wabiok Naawen ale fi jigi. Ku an ŋman magsi ayen fi wi mu ayen fi biiga.’ ");
INSERT INTO bwu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Alege wa kowa yaa na wi tomteerɔma ayen ba nyɛ nwuli a ta garuk kuui ale nala nna yegayega wa gattaŋa meena po la a jam jo wa. Wa weeni ba ayen, ‘Ni pa nifelinni a su wa nisaŋa abe ni pa nuensa a su wa. ");
INSERT INTO bwu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ni ga yik naabiik kaai ale biigi la a ta jam ko. Ate ti nyɛ ŋandiin kpeenta tigi ate ti nyɛ supeentik ale chaab. ");
INSERT INTO bwu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Dii nyiŋ la, m biika de a jam kpi kama, alege yɔgyɔgla de wa vua kama, wa jam be kama alege yɔgyɔgla de ti nya wa kama.’ Ba yaa deri piilim ba ŋandiintaŋa deka ale diinta. ");
INSERT INTO bwu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ba ale jam boro a nyɛ nyaŋa de meena la, wa bikpagini a diem jam bo ka talim. Wa yaa ale jam nyini peelim a cheena a jam boro a mɔata yeri la, wa yaa wom yiilaŋa ale gogtaŋa. ");
INSERT INTO bwu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Wa ale jam paari la, wa yaa wi tomteerɔma wanyi a bek wa ayen, ‘Ka boan ale a nyɛ?’ Tomteerɔwa yaa tulisi wa ayen, ");
INSERT INTO bwu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘Ka fi yuawa ale ŋman pilim jam ate fi kowa yaa ko naabiik kpieŋ tanjaŋini, dii nyiŋ la wa nya biika kama ale jaabjaab ka wa, wa ta nyiŋyɔgsa kama.’ ");
INSERT INTO bwu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Bikpagini ale wom nna la, wa sui a yaa a puuri nna yegayega ate wa zɛri ayen wa kan ŋman a jo yenni. Wa kowa yaa nyini saalim wa ayen wa jo ");
INSERT INTO bwu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","alege wa tulisi wa ayen, ‘Nya de, benaŋa de meena wuu ate mi tom te fu nna ase yomo la, m be an zɛri fi noai me. Ka boan jaab ate fi nyɛ te mi? Ale buuk me la, fi an te mi ayen m nyɛ ŋandiinta tigi ale m dɔama. ");
INSERT INTO bwu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Alege fi biika de waai ale ta fi ŋantaŋa a cheŋ ga yik kaasi nipɔk kaasuŋta zuk, a yaa dan pilim jam fi yiri yik naabiik kaai ale zuak nna yegayega la, a ko te wa!’ ");
INSERT INTO bwu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Wa kowa yaa tulisi wa ayen, ‘M biiga, fi kasim bo ale mi ka daa meena, m be ale ta jaab buui meena la ka fi abe ale soa. ");
INSERT INTO bwu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Alege ku magsi kama ayen ti boro a de ale a gok dii nyiŋ la, fi yuawa a daam kpi kama alege yɔgyɔgla de wa vua kama, wa daam be kama alege yɔgyɔgla de ti nya wa kama.’ ” ");
INSERT INTO bwu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yeezu yaa ŋman weeni wamagsini ale wa ŋaaŋviirima ayen, “Nuru ale jam boro a jigsi nna yegayega a yaa ta tomteerɔ waai ale a nya wa ŋantaŋa meena zuk la. Wa jam ka wa tomteerɔma meena kpagi. Nuruba yaa bobri ale jigsirowa ayen, nuruwa kaasi wa ligraŋa kama. ");
INSERT INTO bwu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jigsirowa yaa wi wa a bek wa ayen, ‘Ka boan jaab wari ate mi a wom a magsi chaab ale fi dila? Pai m ŋantaŋa meena ale fi ale nyɛ ba dii ale dii la a te mu, dii nyiŋ la, fi an ŋman baga a chim waai ale a nya m ŋantaŋa meena zuk la.’ ");
INSERT INTO bwu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tomteerɔwa yaa weeni wa dek ayen, ‘M nyɔnɔwa a yaa wa yiak mu kama tuimaŋa po. M be le nyɛ ka se nna? M be ka pagrim a kpa, chivie abe ta mu ase m nin nyiem a juisi. ");
INSERT INTO bwu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aaya, m seba m le m nyɛ dii yɔgyɔgla de la, ate m dan jogi m tuimaŋa abe m ta dɔaba baai ale ba nyɛ m tia ase m nin cheŋ ba yeeŋa la.’ ");
INSERT INTO bwu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Wa yaa wi nuru baai meena ale ta wa nyɔnɔwa pama la, ate ba jam wa nyɔnɔwa jigi a bek niŋ denowa ayen, ‘Fi ta m nyɔnɔwa ka dina?’ ");
INSERT INTO bwu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nuruwa yaa tulisi ayen, ‘M ta ka kpaam pami samɔnsa kook.’ Wa yaa weeni wa ayen, ‘Pa fi pamini gbaŋka nwuli a ŋmarisi ka po ayen fi ta ka kpaam pami samɔnsa pisinu.’ ");
INSERT INTO bwu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Wa ŋman pilim bek nuru wa choa dila degadega, ate nuruwa tulisi wa ayen, ‘Mi ta ka “wiiti” pami busisa tusidi.’ Wa ŋman pilim weeni wa me ayen, ‘Wa ŋmarisi a nyo wa pamini gbaŋka po nwuli ayen wa ta ka “wiiti” busisa kobsa naaniŋ pami.’ ");
INSERT INTO bwu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Tomteerɔwa de nyɔnɔwa a yaa te wa pimpauk ale wa yammu tuimaŋa de ate wa baga tom ayen wa nya wa dek chum diipo la nyiŋ. Ka wensie ate mi a weeni ayen jinla tɛŋka demma a ta yam kama a seba tuima tomka a gaam nuru baai ale a va Naawen noai la.” ");
INSERT INTO bwu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yeezu yaa ŋman biisi a cheŋ a weeni ayen, “Dila nyiŋ, m be a weeni kama ayen ni pa tɛŋzuk de jigsika a de dɔata ale nuruba ate jigsika a dan kan boro, abe ba nyɛ ni tia wenŋmazuk yeeŋa po. ");
INSERT INTO bwu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nuru waai ale ta wensie wafiisa zuk la, a ta wensie kama me ale wakpeema. Waai me abe ale kan ta wensie wafiisa zuk la, a ka wensie me ale wakpeema. ");
INSERT INTO bwu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Naawen pa tɛŋzuk de ŋantaŋa ba gela a nyo ka ni nisima po. Ni be dan kan pa ba a tom tuima a magsi chaab ale wa ale weeni ayen ni pa ba a nyɛ dii la, wa be le nyɛ ka se a ta siaka ale ni ate wa pa wensie jigsika a te ni? ");
INSERT INTO bwu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ni be dan kan ta wensie me ale jaab buui ale chim nuru jaab la, ka wana le wa pa jaab a te nama ate wa chim ni jaabɔa. ");
INSERT INTO bwu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Tomteerɔ waai abe karo a ta nuruba baye ate ba chim wa nyamma ate wa tom a te ba meena, dii nyiŋ la, ku a fe kama ayen wa kisi ba wanyi a be wa a yaali ba wanyi yaase wa a zuli wanyi abe wa a le wanyiwa. Nuru an baga a pa wa dek a te Naawen ale ŋman pa wa dek a te ligra yaalika me.” ");
INSERT INTO bwu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisiima ale wom nyaŋa de meena la, ba yaa nyɛ wa a la dii nyiŋ la, ba ka nuru baai ale a yaali ligra nna yegayega la. ");
INSERT INTO bwu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yeezu yaa weeni ba ayen, “Nama ka baai ale a chim nuruba nimbie po ayen ba pa ni chim nuru maŋsa alege ka Naawen nyiini ale seba ni suniimaŋa po ale ka dii la. Dii nyiŋ la, wie ŋaai ate nurubiik a pa ŋa a chim wamaŋsa la, ŋa ka ŋaai ate Naawen kisa la. ");
INSERT INTO bwu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moosis Sinsaŋŋa ale Naawen biisiteerɔma biisaŋa jam ta pagrim kama a ta jam paari diipo ate Jɔɔn Sokateerɔwa a jam boro la, alege a zaani dila powa, nuruba a kasim a wom Naawen wamaŋsaŋa sinsaŋŋa a magsi chaab ale Naawen Naamu kama ate waai meena a fe ayen ba jo bu po. ");
INSERT INTO bwu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Alege ku an tɔa ti wenŋmazuk ale tɛŋzuk a muriŋ be, alege ku pagra kama ate Moosis Sinsaŋŋa po dinyi magla me la a muriŋ be. ");
INSERT INTO bwu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Nuru waai a dan zɛri wa pɔk alege faari wa choa, kula nyɔnɔwa a nyɛ ka kaboŋ. Nuru waai me abe ale a faari nipɔk waai ate ba zɛri la, a nyɛ ka kaboŋ me. ");
INSERT INTO bwu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Jigsiro ale jam boro a kasim a jo garuk tii diak ale pagra nna yegayega la. Daa meena wa kasim jam a de ka masim. ");
INSERT INTO bwu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Jajak me ale jam boro. Wa yoi ale Lazarus. Nira ale kasim jam nyɛ wa nyiŋka meena ate baasa kasim jam a leeli ŋa me. Wa kasim jam doa ka jigsirowa de yenni nansiuŋku. Wa sui a jam peenti ka nna yegayega ase wa nin nya siuk ate wa de ŋandiin tii ale jam a lo jigsirowa teebuluku tɛŋ la. ");
INSERT INTO bwu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Da yeŋ ate jajakka de a yaa kpi ate Naawen sabiiloma yaa pa wa a ta jueli ga kali wenŋmazuk Abraham tɛŋ. ");
INSERT INTO bwu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Da yeŋ ate jigsirowa me yaa kpi ate ba gu wa, ate wa cheŋ kpiluŋ juijui ate wa nyiŋka a kasim jam a dom nna yegayega ate wa zak zuk a nya Abraham ale wa yalima nna yegayega ate Lazarus me a yaa kala wa gauŋ. ");
INSERT INTO bwu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Jigsirowa a yaa kaari a wi Abraham ayen, ‘M koa, ta jiirim ale mu abe fi tom ate Lazarus pa wa nandummu a lusi nyiam po ate bu zi m giŋgeluŋ ku nyiŋ, dii nyiŋ la, m nyiŋka meena ale a dom nna yegayega bolimu de po.’ ");
INSERT INTO bwu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Alege Abraham yaa tulisi wa ayen, ‘M biiga, a teeri diipo ate fi jam vua la, fi jam ta ka ŋanmaŋsaŋa meena alege Lazarus a jam soa ŋanbaataŋa meena. Alege yɔgyɔgla de, wa boro a de ka masim dela jigini, alege ate fi ta nyiŋdomma nalimnyiini. ");
INSERT INTO bwu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Daa dila nyiini, ale kaasiya, ka goluk ale limsa a dua tama ale fi sunsuŋ, ate baai ale a yaali ayen ba nyini dela a jam fi jigi la, an baga a taamu, yaase waai me abe dan a yaali ayen wa nyini fi jigi a jam tama jigi wa an baga a taamu.’ ");
INSERT INTO bwu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Jigsirowa a yaa weeni ayen, ‘Ku be dan ka dila, mi a saalim kama m koa ayen fi tom Lazarus ate wa cheŋ m kowa yenni ");
INSERT INTO bwu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","juijui ate m ta suaata tinu la. Wa ga kaam ba ate bala me kan jam nyiŋdomma jigini de.’ ");
INSERT INTO bwu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abraham yaa tulisi wa ayen, ‘Fi suaataŋa a ta Moosis ale Naawen biisiteerɔma sinsaŋŋa kama ate ŋa a kaam ba, ku be a fe kama ayen fi suaataŋa abe lagi tue a wom ŋa ale a weeni ba dii la.’ ");
INSERT INTO bwu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Jigsirowa a yaa ŋman tulisi ayen, ‘M koa, aawo, alege nuru a dan yiri tama baai ale ka kpilima la po a cheŋ ga weeni ba ku a fe kama ayen ba basi ba tuimbaataŋa tomka.’ ");
INSERT INTO bwu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham ŋman tulisi wa ayen, ‘Ba dan kan a yaali ayen ba wom Moosis ale Naawen biisiteerɔma sinsaŋŋa ale a weeni dii la, nuru a dan poom yiri kpilima po me a ga weeni ba, ba kan diem a wom.’ ” ");
INSERT INTO bwu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yeezu yaa weeni wa ŋaaŋviirima ayen, “Ku a fe kama ayen nuruba nyɛ ni nya ate ni tom wabaata. Alege waai ale wa nyɛ dila la, a jogi wein kama. ");
INSERT INTO bwu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ku ate zunchoŋ kama a te kula nyɔnɔ ase ba nin pa ni kpeeni a bobi yik wa ŋiri a ta wa ga yuk basi mogi kpeeni nyiamu po a gaam wa nin nyɛ ate bisaŋa de wanyi a tom wabiok. ");
INSERT INTO bwu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Dila nyiŋ la, ni kpesi ni dek ale wa dii meena ate ni a nyɛ la. “Fi suok a dan nyɛ wabiok, tɔariŋ wa ale nin muna ate wa dan basi wa wabaataŋa tomka fi voŋ te wa. ");
INSERT INTO bwu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Wa be dan nyɛ kaasi fu a paari ku noai buyopoi da yeŋ ale ŋman weeni fu ku noai buyopoi ayen wa siak wa kaasuŋku ku a fe kama ayen fi voŋ te wa.” ");
INSERT INTO bwu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tuimtomdɔma yaa weeni ba Nyɔnɔwa ayen, “Nyɛ ate ti siaka a zuak a nyoro.” ");
INSERT INTO bwu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ate wa me yaa tulisi ba ayen, “Ni siaka a dan soa ase jabiri fiik la, ni baga weeni kiŋkaŋka de kama ayen, ‘Voori fi dek a yiri ga zaani mogi kpeeni nyiamu po’, ate ka sum siak ni noa a yiri ga zaani du. ");
INSERT INTO bwu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ase ni wanyi a nin ta tomteerɔ ate wa a kpa a yaase wa a kasi fi piisa. Wa nin ga nyini sagini a jam, fi deri a weeni wa ayen wa nyɛ nwuli a jam de wa ŋandiintaŋa? ");
INSERT INTO bwu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ni kan goanti weeni wa kama ayen, ‘Dik junɔai ŋandiinta a te mu abe fi pa garuk naluŋ jo a limsi mu ate m de a nueri abe fi me yaa de fi ŋandiinta?’ ");
INSERT INTO bwu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nama a poli ayen ku a fe kama ate tomteerɔwa nyɔnɔwa nyɛ wa jiam ale wa ale weeni wa ate wa nyɛ dii la? Aawo. ");
INSERT INTO bwu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ku be ka dila, nama me jigi. Ni dan tom Naawen ale weeni ni ayen ni tom dii la a nueri, ni weeni ni dek ayen, ‘Tama ka tomteerɔba. Dila nyiŋ la ku an magsi wa nyɛ ti jiam. Ti tom ka dii ale magsi ayen ti tom la.’ ” ");
INSERT INTO bwu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yeezu ale jam bo siuku po a cheŋ Jerusalem la, wa jam va ka Samaria ale Galili tɛŋsa sunsuŋ po a cheŋ. ");
INSERT INTO bwu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Wa jam boro a jo ka tɛŋfiik po a yaa ga zik gama pi ate ba za nna niŋniŋa, ");
INSERT INTO bwu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","a kaari ate ku a jueli a weeni ayen, “Ti Nyɔnɔ, Yeezu, ta jiirim ale ti.” ");
INSERT INTO bwu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yeezu ale nya ba la, wa yaa weeni ba ayen, “Ni cheŋ a ga pa ni dek a sak Juuma Puusika Yenni kpaŋŋa.” Gamaŋa ale jam bo siuku po a cheŋ Puusika Yenni kpaŋŋa jigi la, ba yaa deri nya nyiŋyɔgsa. ");
INSERT INTO bwu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ba wanyi ale chuiri nya ale wa ta nyiŋyɔgsa la, wa yaa pilim ŋmani ale a pak Naawen ate ku a jueli nna yegayega ");
INSERT INTO bwu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","a yaa jam paari Yeezu a lo wa naŋsa tɛŋ a nyɛ wa jiam. Nuruwa a jam ka Samaria deno. ");
INSERT INTO bwu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yeezu yaa bek wa ayen, “Daa nuruba pi ale nya nyiŋyɔgsa la? Mbala neoku a bo ka be? ");
INSERT INTO bwu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ba wanyi me la an baga pilim ŋman jam a te Naawen pimpauwa ka nichaanowa de nyiini?” ");
INSERT INTO bwu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yeezu yaa weeni wa ayen, “Yiri zaani a cheŋ. Fi siaka ale basi ate fi nya nyiŋyɔgsa.” ");
INSERT INTO bwu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisiima ba gela yaa bek Yeezu ayen, “Ka dimpo ate Naawen Naamu a le jamu?” Yeezu yaa tulisi ba ayen, “Nama a poli kama ayen ni nya wie ate ku sak ayen Naawen Naamu a cheena, alege ni kan nya bu dila, ");
INSERT INTO bwu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","yaase nuru kan weeni ayen, ‘Nya de, bu bo ka dela’, yaase, ‘Bu bo ka dula.’ Boan nyiŋŋa, Naawen Naamu a bo ka ni sunsuŋ.” ");
INSERT INTO bwu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Wa yaa weeni wa ŋaaŋviirima ayen, “Daa cheena kama ate ni le kasim a yaali ayen ni jogi nya dii po ate Mi Saalobiika le soa m naamu la, alege ni kan nya. ");
INSERT INTO bwu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nuruba abe le weeni ni ayen, ‘Ni nya dula, ni nya dela.’ Ba dan weeni dila, ni kan cheŋ, ni be kan va ba me. ");
INSERT INTO bwu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ase ŋmoruk a nyiem ale a ni ate wenni a nyagsi taam dela a ŋman nyagsi taam dela, la Mi Saalobiika me danni a dan jam ku le nyɛ ka dila degadega. ");
INSERT INTO bwu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Alege, ku a fe kama ayen wa de niŋ a nam nna yegayega ate jinla demma me abe le zɛri wa. ");
INSERT INTO bwu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ase ku ale jam ka dii Nowa vaaŋa po la, ku a le chim ka dila degadega Mi Saalobiika me daaŋa po. ");
INSERT INTO bwu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Diipo ate Nowa a jam boro la, nuruba jam a de ale a nyu kama. Nidɔama me a jam a faari nipooba, nidɔaba me a pa ba leeba a yalisi. Nuruba jam a nyɛ ka dila a ta jam paari da dii danni ate Nowa yaa jo ŋaaruŋku po alege ate nyiamu a jam tagli tɛŋka a ko ba meena la. ");
INSERT INTO bwu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ku jam nyɛ ka dila degadega Lɔti daaŋa po. Dila powa, waai meena a kasim jam a de kama ale a nyu, ale a da diak me, ale a bori, ale se yie. ");
INSERT INTO bwu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Da dii danni ate Lɔti basi Sodom tɛŋka la, bolim ale tintain tuila ale jam nyini wenŋmazuk a jam ko ba meena. ");
INSERT INTO bwu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ku le nyɛ ka dila degadega da dii dai ate Mi Saalobiika ale pa m dek a sak nuruba la. ");
INSERT INTO bwu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Da dila danni, nuru waai a dan bo wa gboŋ zuk wa kan ŋman siŋ jo wa dɔkku po ayen wa pa wa ŋanta, dila degadega nuru waai me ale bo peelim wa talim po la, a kan ŋman pilim jam yeriya. ");
INSERT INTO bwu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ni teeri Lɔti powa wari! ");
INSERT INTO bwu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nuru waai ale pii nyiŋ a nyɛ ayen wa vari wa dek nyuvuri a basi la, ale jok di kama. Waai me abe ale a jok wa nyuvuri la, le vari di a basi kama. ");
INSERT INTO bwu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Basi ate m weeni a sak ni ayen da dila danni yokku, nuruba baye ale ba dua ta yeŋ po a goa, ate Naawen jam pa ba wanyi a ta cheŋ alege nwala a dueni. ");
INSERT INTO bwu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nipooba baye me ale maa chaab a boro a num zom ate Naawen jam pa ba wanyi a ta cheŋ ale ge nwala a zaani. ");
INSERT INTO bwu_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nuruba baye ale bo kaduk po a kpa ate Naawen jam pa ba wanyi a ta cheŋ alege nwala a zaani.” ");
INSERT INTO bwu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wa ŋaaŋviirima yaa bek wa ayen, “Ti Nyɔnɔ, ka be ate nyaŋa de a le nyɛ?” Wa yaa tulisi ba ayen, “Jakpiuk ale dua juijui la, duinsa a bo ka dula.” ");
INSERT INTO bwu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yeezu yaa magsi wamagsini a sak wa ŋaaŋviirima Wa weeni wamagsini kama ayen di deŋsi ba kpa ate ba kasim a puusi Naawen. ");
INSERT INTO bwu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Wamagsini ale, “Tɛŋ kanyi po nuru ale jam boro. Wa jam a biisi ka biisa. Wa jam kan chali yɔgsum ale Naawen, yaase nurubiiga. ");
INSERT INTO bwu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Pukogi me ale jam bo tɛŋ kala po a yaa nyiem kasim a cheŋ nuruwa de jigi a saalim wa ayen wa maa maari wa ate wa nyɛ buusa ale wa dachiak. ");
INSERT INTO bwu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ku jam beni ka nna yegayega alege wa jam zɛri wa maarika kama. Alege ku ŋaaŋnyiŋ wa weeni wa dek ayen, ‘M seba ayen m kan chali Naawen m be kan zuli nurubiik me ");
INSERT INTO bwu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","alege, pukogini de ale kasim a daani mu dii la, m le nya ku zuk ate wa nya wa ale a yaali dii la. M dan kan nyɛ dila, wa a le kasim a jam kama ate m ga jiak.’ ” ");
INSERT INTO bwu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yeezu yaa weeni ba ayen, “Ni wom venta nyɔnɔwa de ale weeni dii la. ");
INSERT INTO bwu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ase nuruwa dan weeni dila, nama kan poli ayen Naawen le bo buusa a te wa dek nuruma baai ale a kaari yok ale kantueŋ ayen wa maari ba la? Wa le beni abe wa maari ba? ");
INSERT INTO bwu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Basi ate m weeni a sak ni ayen wa le bo buusa a te ba ka nna nwuli. Alege Mi Saalobiika a dan ŋman pilim jam tɛŋzuk de m le nya siaka nuruba jigiya?” ");
INSERT INTO bwu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yeezu yaa ŋman jam magsi wamagsini di choa a te nuru baai ale jam a poli ayen ba ka nuru maŋsa a kan pa waai meena a chim nuruba la. Wa yaa magsi wamagsini ayen, ");
INSERT INTO bwu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Nuruba baye ale jam boro a yaa jam jo Naawen Puusika Yenni po ayen ba puusi Naawen. Ba wanyi a jam ka Farisii, wanyi me a jam ka lampoo cheesido. ");
INSERT INTO bwu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Farisii wa a yaa yiri zaani wa dek wa nyiini a yaa puusi Naawen ayen, ‘Naawen mi a nyɛ fi jiam, boan nyiŋŋa, m daa nuru baai chaab ale a vari la, yaase baai ale kan ta wensie la, yaase kaboŋ nyeeroba la. Mi a te fi jiam me ayen m daa lampoo cheesirowa ale za dula la. ");
INSERT INTO bwu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Daa ŋayopoi meena po mi a bobi ka noai daa ŋaye. M be a va kisi kuui ale a sak ti ayen jaab buui meena ate ti a nya la, ti poori ba tɔgatɔga ku noai pi a yaa lueri piwa po bunyi a te fi la kama.’ ");
INSERT INTO bwu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Alege lampoo cheesirowa me a ga za niŋniŋ wa tɔga a kan poom a yaali ayen wa zak zuk a nya wenŋmazuwa. Wa yaa yik nimbie a kaasi a weeni ayen, ‘Oo, Naawen ta jiirim ale mu, dii nyiŋ la, m ka wabaata nyɔnɔ.’ ” ");
INSERT INTO bwu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yeezu yaa weeni ayen, “Basi ate m weeni a sak ni ayen daa Farisiiwa alege ka lampoo cheesirowa de ate Naawen voŋ wa wabaataŋa a te wa, ale ge ate wa yaa kuli yeri. Ni basi ate m ŋman weeni a sak ni ayen nuru waai ale a pa wa dek a chim nuru kpioŋ la, ba le zaab wa alege waai ale a zaab wa dek la, a le chim ka nuru kpioŋ.” ");
INSERT INTO bwu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nuru ba gela a yaa ta ba biluaata a jam Yeezu jigi ayen wa pa wa nisa a vi ba zuk. Wa ŋaaŋviirima ale nya dila la, ba yaa tɔariŋ ba ayen ba kan nyɛ dila, ");
INSERT INTO bwu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","alege Yeezu yaa wi ba ate ba jam wa jigi ate wa yaa weeni wa ŋaaŋviirima ayen, “Ni basi ate bisaŋa jam mi jigi. Ni kan yiak ba, dii nyiŋ la, ka nuruba ase bisaŋa de chaab la ale soa Naawen Naamu. ");
INSERT INTO bwu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ni a teeri nyaku de ayen, waai a dan kan a nyɛ wa dek ase bisaŋa de wanyi la, wa kan nya Naawen Naamu.” ");
INSERT INTO bwu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Da yeŋ ate kpagi dinyi a yaa bek Yeezu ayen, “Sagrɔ maŋŋa, m nin nyɛ se ale m nya nyuvuri dii ale kan ta kpeglimka la?” ");
INSERT INTO bwu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yeezu yaa bek wa ayen, “Ka boa ate fi a wi mu ayen nuru maŋŋa? Nuru karo a chim nuru maŋŋa, ka Naawen nyiini. ");
INSERT INTO bwu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Fi dek a seba Naawen Sinsaŋŋa kama, ŋa ale nna: ‘Kan nyɛ kaboŋsa. Kan ko nuru. Kan zu. Kan chim seero waai ale a velim la. Zuli fi ko ale fi ma.’ ” ");
INSERT INTO bwu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nuruwa yaa tulisi ayen, “A ta nyini dii po ate mi jam ka biik la, mi kasim va ka Sinsaŋŋa de meena a jam paari jinla.” ");
INSERT INTO bwu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yeezu ale wom nna la, wa yaa weeni nuruwa ayen, “Fi tali ka wayeŋ ate fi nyɛ. Pa jaab meena ate fi ta la a da a pa ligraŋa a te ŋanjagsa ate fi nya jigsika wenŋmazuk. Fi dan nyɛ dila, fi yaa va mi.” ");
INSERT INTO bwu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nuruwa ale wom nna la, wa sui a yaa deri a kaasi nna yegayega dii nyiŋ la, wa jam ka jigsiro nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yeezu ale nya ale wa sui kaasi la, wa yaa weeni ayen, “Ku tɔa kama ate jigsiroba de Naawen Naamu. ");
INSERT INTO bwu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ase laalaakomi ale kan baga a va garupein num po a nyini dii la, ku be pagra kama me nna yegayega ate jigsiro de Naawen Naamu.” ");
INSERT INTO bwu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Baai ale jam wom nna la a yaa bek ayen, “Be ka wana a le wa nya varibasika?” ");
INSERT INTO bwu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Alege Yeezu yaa tulisi ba ayen, “Dii ate nurubiik an baga nyɛ la, Naawen baga nyɛ kama.” ");
INSERT INTO bwu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Piita yaa weeni wa ayen, “Nya, tama basi ti yeeŋa kama ale jam va fu.” ");
INSERT INTO bwu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yeezu yaa weeni ba ayen, “Nuru waai a dan basi wa yeri ale wa pɔk ale wa suaata ale wa ko ale wa ma, a yaase wa bisa Naawen Naamu nyiŋ, ");
INSERT INTO bwu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Naawen ale te kula nyɔnɔwa ŋanta bala chaab nna yegayega gaam taam wa ale poom ta dii la, ale chum diipo ate wa nya nyuvuri dii ale kan ta kpeglimka la.” ");
INSERT INTO bwu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Da yeŋ ate Yeezu yaa poori wa ŋaaŋviirima pi ale bayewa a ta nyini m bala po a yaa weeni ba ayen, “Ni nya, ti a cheŋ ka Jerusalem tɛŋka. Naawen biisiteerɔma ale ŋmarisi dii meena a magsi chaab ale Mi Saalobiika la, ti dan ga a paari dula, ba ale ŋmarisi dii meena la a le chim ka wensie. ");
INSERT INTO bwu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Boan nyiŋŋa, ba le sum yik mu kama, a pa mu nyo nuru baai ale kan daa Juuba la nisima po ba a le la mu, a le mu, a chesi tintueta a basi m nyiŋ ");
INSERT INTO bwu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ba a le miiri mu abe ba ko mu, alege daa ŋata dai, m le yiri kum po.” ");
INSERT INTO bwu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yeezu ale biisi nna la, wa ŋaaŋviirima an jam miŋ ku kiriya. Dii nyiŋ la Naawen an jam lak ku kiri a sak ba, ate ba an miŋ wa ale a biisi dii la. ");
INSERT INTO bwu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yeezu ale boro a mɔata Jeriko tɛŋka la, yio ale jam kala siuku niŋ a juisi. ");
INSERT INTO bwu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Wa ale wom ale nuru bɔanni a va wa tɛŋ a taam la, wa yaa bek ayen, “Ka boa ale la?” ");
INSERT INTO bwu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nuruma yaa tulisi wa ayen, “Ka Yeezu Nazaret denowa ale a taam.” ");
INSERT INTO bwu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Yiowa yaa kaari a weeni ayen, “Yeezu, Naawa Deevid ŋaaŋbiika, ta jiirim ale mu.” ");
INSERT INTO bwu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nuruma ale jam de niŋ ka la a yaa weeni wa ayen wa goori wa wanni alege wa zɛri ale a kaari nna yegayega a gaam wa ale poom a kaari dii la a ŋman weeni ayen, “Naawa Deevid ŋaaŋbiika, ta jiirim ale mu.” ");
INSERT INTO bwu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yeezu yaa zaani a weeni ayen ba ta nuruwa a jam wa jigi. Wa ale jam paari la, Yeezu yaa bek wa ayen, ");
INSERT INTO bwu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Fi a yaali ayen m nyɛ ka boa a te fu?” Wa yaa weeni wa ayen, “M Nyɔnɔ, mi a yaali ayen fi nyɛ kama ate m ninaŋa a lagri a te mu.” ");
INSERT INTO bwu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yeezu yaa weeni wa ayen, “Be lagri a nya. Fi siaka a basi kama ate fi nya nyiŋyɔgsa.” ");
INSERT INTO bwu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yeezu ale weeni dila la, wa ninaŋa deri lagri ate wa a nya, ate wa yaa va Yeezu a te Naawen pimpauk. Nuru bɔanni ale nya nna la, ba meena yaa te Naawen pimpauk. ");
INSERT INTO bwu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yeezu yaa ga jo Jeriko tɛŋka a va ka po a taam. ");
INSERT INTO bwu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nuru wanyi ate ba a wi wa ayen Zakiyos. Wa jam ka lampoo cheesiroba kpagi a jigsi nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Wa yaa jam a yaali ayen wa nya Yeezu alege wa an jam baga dii nyiŋ la, wa jam gela kama ate nuru bɔanni a yaa jam lik wa. ");
INSERT INTO bwu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Wa yaa chali de niŋ a ga jueli kiŋkaŋ ayen wa nya wa dii nyiŋ la Yeezu le jam va ka dula a taam. ");
INSERT INTO bwu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yeezu ale jam paari dula jigini la, wa yaa zak nya wa weeni wa ayen, “Zakiyos, nyɛ nwuli a siŋ tɛŋ, dii nyiŋ la, ku a fe kama ayen m goa fi yenni jinla.” ");
INSERT INTO bwu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakiyos yaa kpabi siŋ a nyɛ wa tia ale supeentik nalimnyiini. ");
INSERT INTO bwu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nuru baai ale jam nya dila la, ba yaa jam a ŋuuni a weeni ayen, “Wa jo ayen wa chim ka tuimbaata nyɔnɔwa de nichaano.” ");
INSERT INTO bwu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakiyos yaa yiri zaani a weeni Nyɔnɔwa ayen, “Wom, m Nyɔnɔ, m le pa ŋanta baai meena ate mi ta la geli a te ŋanjagsa, abe m daam dan velim tuesi nuru jaab, m le tuni wa jaab wala degadega ku noai bunaansi.” ");
INSERT INTO bwu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yeezu yaa weeni wa ayen, “Varibasika jam yenni de po jinla kama, wa ale maa ka Abraham ŋaaŋbisaŋa po wanyi la nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Boan nyiŋŋa, Mi Saalobiika a jam ayen m gisi ka baai ale be la ate m vari ba a basi.” ");
INSERT INTO bwu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nuruma ale jam diem za a wom wieŋa de la, wa yaa magsi wamagsini, dii nyiŋ la wa jam mɔata Jerusalem tɛŋka kama, ate ba jam a poli ayen Naawen Naamu a jam mɔata ka jamka nwuli. ");
INSERT INTO bwu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Wa yaa magsi wa wamagsini ayen, “Nuru kpioŋ ale jam boro, a yaa yiri da yeŋ a cheŋ satɛŋ nna niŋniŋa ayen ba bobi wa naam abe wa ŋman pilim jam. ");
INSERT INTO bwu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Wa ale a yaali wa basi wa yenni abe wa cheŋ la, wa yaa wi wa tomteerɔma po pi a chari ba wanyiwanyi ligra a soa si chaab la ale ge weeni ba ayen, ‘Ni pa ligraŋa de a gerim ate m cheŋ abe m pilim jam.’ ");
INSERT INTO bwu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Wa tɛŋka demma a jam kisi wa kama, ate ba yaa tom nuruba ate ba saŋ wa ŋaaŋ a ga weeni ayen, ‘Ti kan yaali nuruwa de ayen wa chim ti naaba.’ ");
INSERT INTO bwu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ba yaa jam bobi nuruwa naamu ate wa pilim jam. Wa ale jam paari la, wa yaa wi wa tomteerɔma ayen ba jam ate wa bek ba nya ase ba gerim a nya ka boan nyuenta. ");
INSERT INTO bwu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ba wanyi a yaa de niŋ a jam weeni ayen, ‘Nyɔnɔ, fi ligraŋa vi ka ku noai pi a gum du.’ ");
INSERT INTO bwu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nuruwa yaa weeni wa ayen, ‘Fi nyɛ wamaŋ, tomteerɔ. Fi ale ta wensie ale wafiisa la nyiŋ ale soa ate mi a pa tɛŋkpieŋsa pi a nyo fi nisima po ayen fi a nya si meena zuk.’ ");
INSERT INTO bwu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tomteerɔ waai ale pa a saŋ la a jam weeni wa ayen, ‘Nyɔnɔ, fi ligraŋa vi ka ku noai bunu.’ ");
INSERT INTO bwu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Wa yaa weeni tomteerɔ wala me ayen, ‘Fi soa ka tɛŋkpieŋsa sinu zuk a nya.’ ");
INSERT INTO bwu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Tomteerɔ wanyi me a jam weeni wa ayen, ‘M nyɔnɔ, fi ligraŋa ale nna. Mi pa di a bobi ka laki po a dueni fu. ");
INSERT INTO bwu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mi a chali fu kama, dii nyiŋ la, fi nyeka tɔa ka ma, fi a tuesi ka ŋanta baai ale kan daa fi ŋanta la nuruba jigi ale a che ŋanta baai me ate fi an bori la.’ ");
INSERT INTO bwu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Wa yaa weeni wa ayen, ‘Fi ka tomteerɔ kaasuŋ, m le pa ka fi dek biika a dak fi kaasuŋku a sak fu. Ka fi ale seba ayen mi nyeka tɔa, a tuesi ŋanta baai ale kan daa m ŋanta la nuruba jigi ale a che jaab buui ate mi an bori la. ");
INSERT INTO bwu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Be ka boa ale soa ate fi an pa m ligni a te nuru ate wa ta a tom ate diipo ate m le pilim jam la m nya nyuenta di po?’ ");
INSERT INTO bwu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Wa yaa weeni nuru baai ale jam za dula la ayen, ‘Ni tuesi ligbinni ale bo wa jigi la a te yomo waai ale ta ligbie piwa la.’ ");
INSERT INTO bwu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ba yaa weeni wa ayen, ‘M nyɔnɔ, wa an poom ta ka ligbie pi?’ ");
INSERT INTO bwu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Alege nuruwa yaa tulisi ba ayen, ‘Ase ba ale weeni dii ayen waai nisa po ale ta la, wala a le ŋman nya ŋanta ka nna yegayega a gum du, alege waai nisa po ale poom kan ta la, kula nyɔnɔwa ale poom ta dii magla la, wa a le jok bala me kama a gum du. ");
INSERT INTO bwu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Alege mi dachaasaŋa, baai ale jam kan a yaali ayen mi chim ba Naab la, ta ba a jam dela a ko ba ate m nya.’ ” ");
INSERT INTO bwu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yeezu ale magsi wamagsini de a nueri la, wa yaa de niŋ a cheŋ Jerusalem tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Wa ale jam boro a mɔata tɛŋfiisaŋa, Betfaaji ale Betani ate si mɔata Olivi Guuku la, Yeezu yaa tom wa ŋaaŋviirima po baye ");
INSERT INTO bwu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","a weeni ba ayen, “Ni cheŋ tɛŋfiik kaai ale bo ni niŋ la. Ni dan ga jo ka po ni le nya boniŋ ate nuru waai an diem do ka ale ka bobi za. Ni foli ka a ta jam dela. ");
INSERT INTO bwu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nuru a dan bek ni jaab buui nyiŋ ale soa ate ni a foli ka la, ni weeni wa ayen, ‘Ka Nyɔnɔwa ale a yaali.’ ” ");
INSERT INTO bwu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ba yaa cheŋ ga nya dii dek ate Yeezu weeni ba la. ");
INSERT INTO bwu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ba ale jam boro a foli ka la, ka nyamma yaa bek ba ayen, “Ka boan nyiŋ ate ni a foli ka?” ");
INSERT INTO bwu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ŋaaŋviirima yaa tulisi ba ayen, “Ti Nyɔnɔwa ale a yaali ka”, ");
INSERT INTO bwu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ate ba yaa ta bonika a cheŋ Yeezu jigi a yaa yeeri ba kasaautaŋa a vi ka zuk a gomsi magsi ate Yeezu do. ");
INSERT INTO bwu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Wa ale jam a cheŋ la, nuruba yaa pa ba kasaautaŋa a pati dueni tɛŋka siuku po. ");
INSERT INTO bwu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Wa ale jam boro a mɔata Jerusalem a yaa churinti nyini Olivi Guuku zuk a siŋ la, wa ŋaaŋviirima meena yegayega a piilim deri a te Naawen pimpauk ate ku a jueli nna yegayega, ale ba ale jam nya wakperikaliik pagri sii meena la. ");
INSERT INTO bwu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ba yaa a pak Naawen a weeni ayen, “Naawen niak naab waai ale cheena Nyɔnɔwa yonni nyiŋ la. Suyɔgini a bo Naawen jigi, ale nalim a bo wenŋmazuk.” ");
INSERT INTO bwu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Farisiima ba gela ale jam maa bo nuru bɔanni po la, a yaa weeni Yeezu ayen, “Ti Sagrɔ, weeni fi ŋaaŋviirima ate ba goori.” ");
INSERT INTO bwu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yeezu yaa tulisi ba ayen, “Ni basi ate m weeni ayen ba dan poom goori me, tintanaŋa dek le yi yiila a pak Naawen ase bala la.” ");
INSERT INTO bwu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Wa ale jam mɔata tɛŋka po ate wa ga nya ka la, wa deri a kum ka nyiŋ ");
INSERT INTO bwu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","a weeni ayen, “Ase ni dan poom seba ni le ni nyɛ dii ate suyɔgini a jam la ku te zunchoŋ kama alege ŋa meena a suk kama ni jigi. ");
INSERT INTO bwu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Di danni cheena kama, ate ni dachaasaŋa a jo gilim ni jigi meena a basi sunsuŋ. ");
INSERT INTO bwu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ba ale kaasi ni tɛŋka abe ba ko ni ale ni bisaŋa meena. Ba kan basi tintain yeŋ me la ate di dua di choa zuwa. Nyaŋa de meena le nyɛ kama dii nyiŋ la, diipo ate Naawen jam ayen wa vari ni a basi la, ni jam zɛri kama.” ");
INSERT INTO bwu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yeezu yaa ga jo Juuma Puusika Yenni po a yiak baai ale jam bo di po a gerim la ");
INSERT INTO bwu_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ale weeni ba ayen, “Ba ŋmarisi Naawen gbaŋka po ayen Naawen a weeni ayen yenni a le chim ka puusika yeri. Alege nama goanti pa di chim ka zueba yeri.” ");
INSERT INTO bwu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Daa meena Yeezu a kasim jam a sak ka nuruba Juuma Puusika Yenni po. Juuma Puusika Yenni kpaŋŋa ale Juuma Sinsaŋŋa sagrɔma ale nisomma jam a yaali kama ayen ba ko wa ");
INSERT INTO bwu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","alege ba an baga a jam nya siuwa, dii nyiŋ la, nuruma meena a kasim jam a wom ka wa sinsaŋŋa. Ba kan jam a yaali ayen ba jogi ale wa yeŋ la womka. ");
INSERT INTO bwu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Da yeŋ ate Yeezu a jam bo Juuma Puusika Yenni po a sak nuruma Naawen wamaŋsaŋa. Juuma Puusika Yenni kpaŋŋa ale Juuma Sinsaŋŋa sagrɔma ale nisomma a yaa jam ");
INSERT INTO bwu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","a bek wa ayen, “Ka wana ale te fi siuk ate fi a nyɛ wieŋa de? Ka wana ale te fu siuk wa?” ");
INSERT INTO bwu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yeezu yaa tulisi ba ayen, “Ni basi ate mi me bek ni wari. ");
INSERT INTO bwu_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jɔɔn ale jam a te nuruba soka la, wa jam nya wa pagrimu ka Naawen jigi yaa nuru biik jigiya?” ");
INSERT INTO bwu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ba yaa deri a zok ale chaab, “Ti ti tulisi wa ayen ka boa? Ti be dan weeni ayen bu nyini ka Naawen jigi wa le bek ti ayen be ka boa ate ti jam ka siaka ale Jɔɔn wieŋa. ");
INSERT INTO bwu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Alege ti dan weeni me ayen bu nyini ka nurubiik jigi, nuru bɔanni ale za dela la ba a le yuk ti kama ale tintana dii nyiŋ la, ba seba chak kama ayen Jɔɔn ka Naawen biisiteerɔ.” ");
INSERT INTO bwu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ba yaa tulisi ayen, “Ti ze Jɔɔn pagrimu ale nyini juijui la.” ");
INSERT INTO bwu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yeezu yaa weeni ba ayen, “Mi me abe kan weeni a sak ni jaab buui pagrim nyiŋ a te mi a nyɛ wieŋa de la.” ");
INSERT INTO bwu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yeezu yaa magsi wamagsini de a sak nuruma ayen, “Nuru wanyi ale jam boro a yaa kpa wa talim fiik, a vuk tiisa. Wa yaa pa nuruba ayen ba a limsi bu ale ge yaa yiri nyiem a cheŋ tɛŋ ka choa a ga beni nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wa talimu tiisaŋa yoanaŋa pisika ale jam paari la, wa yaa tom tomteerɔ ayen wa ga tuesi yoana ŋaai ate wa soa la wa nuruma jigi a ta jam te wa. Tomteerɔwa ale ga paari talimu po la, nuruma yaa yik wa a nak wa a yiak wa ate wa cheŋ ale nisim kotta. ");
INSERT INTO bwu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Wa yaa ŋman tom tomteerɔ wa choa alege ba ŋman yik wa me a nak ate wa nya chivie nalimnyiini a yiak wa ate wa cheŋ ale nisim kotta. ");
INSERT INTO bwu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Wa ŋman tom tomteerɔ wa choa a nyɛ buta, ba ŋman yik wa me a nak a te wa tuom a yiak wa ate wa nyini. ");
INSERT INTO bwu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Talimu nyɔnɔwa yaa bek wa dek ayen, ‘M le nyɛ ka se nna m le tom ka m dek biika waai ate m mariŋ la ate wa cheŋ, da dii dai ba a le te wa zula.’ ");
INSERT INTO bwu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nuruma yaa ale ga nya nuruwa dek biika la, ba yaa weeni chaab ayen, ‘Talimu nyɔnɔwa dek biika ale nna. Wa dan kpi, ka wala le soa wa ŋantaŋa. Basi ate ti ko wa ate wa ŋantaŋa meena a chim tama ŋanta.’ ");
INSERT INTO bwu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ba yaa yik wa a ta wa nyini talimu po a nyini a ko wa.” Yeezu ale magsi wamagsini nna a nueri la, wa yaa bek ayen, “Talimu nyɔnɔwa le nyɛ nuruma de ka se?” ");
INSERT INTO bwu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Wa le jam ko ba kama abe wa pa talimu a nyo nuruba ba chaab nisima po.” Nuruma ale wom nna la, ba yaa weeni ayen, “Ti a saalim Naawen ayen wa kan basi ate dila nyɛ.” ");
INSERT INTO bwu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Wa yaa nya ba ale weeni ayen, “Be ka boa ate ba ŋmarisi Naawen gbaŋka nna ayen, ‘Tintain dii ate seeroma a zɛri ayen di an nala la, tintain dila degadega ale ŋman chim tintain maŋka ŋa meena po.’ ");
INSERT INTO bwu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nuru waai abe dan lo tintanni de zuk, kula nyɔnɔwa nyiŋka a le pasi ka meena meena, alege nuru waai ate tintanni de a lo wa zuk la, di a le num wala choa nyiŋka ase ka zom la.” ");
INSERT INTO bwu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Juuma Sinsaŋŋa sagrɔma ale Juuma Puusika Yenni kpaŋŋa a yaa jam pii nyiŋ ayen ba yik Yeezu dila powa, dii nyiŋ la, ba jam miŋ kama ayen wa pa ka ba a magsi wamagsini. Alege ba an jam nya siuk a yik wa dii nyiŋ la, yɔgsum ale jam ta ba ale nuruma. ");
INSERT INTO bwu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ba yaa kasim jam a gisi siuk ayen ba yik wa. Ba yaa tom nuruba a weeni ba ayen ba pa ba dek a chim wensie nyam a ga bek Yeezu bega ate ba nya siuk a yik wa a te Gominawa waai ale ta pagrim la. ");
INSERT INTO bwu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nuruma de ale jam Yeezu jigi la, ba yaa weeni wa ayen, “Ti sagrɔ, tama seba ayen fi ale a biisi dii ale a sak nuruba dii la ka wensie. Tama seba me ayen fi ka waai ale kan a luk nuruba la, alege fi a sak ka wensie sinsaŋŋa ŋaai ale a sak nurubiik Naawen ale a yaali ayen wa boro dii la. ");
INSERT INTO bwu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Be weeni nyaku de a sak ti, tama Sinsaŋŋa a siak ate ti tuni ti lampoowa a te nakpioŋku Siiza yaa Sinsaŋŋa kan siagi?” ");
INSERT INTO bwu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Alege Yeezu poom seba ba yammu noai po kama ate wa yaa weeni ba ayen, ");
INSERT INTO bwu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ni sak mu ligbiri.” Ba yaa ta ligni jam ate wa yaa bek ba ayen. “Ka wana zuk ale wa yoi ale dua di nyiŋŋa?” Ba yaa tulisi wa ayen, “Ka Siiza.” ");
INSERT INTO bwu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yeezu yaa weeni ba ayen, “Ku be dan ka dila, ni be pa jaab buui meena ale magsi ayen ni pa te Siiza la, a te wa, abe ni pa jaab buui meena ale magsi ayen ni pa te Naawen la, a te wa.” ");
INSERT INTO bwu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Wa ale jam tulisi ba dii nna la, ku yaa cha ba nna yegayega ate ba yaa goori nna chorototo. Ba an jam baga a yik wa nuruma nimbie po, wa ale tulisi ba dila la nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Dula jigini, Sajusiba ba gela a yaa jam Yeezu jigi, a bek wa bega. Sajusima meena jam a weeni kama ayen nuruba dan kpi, ba an ŋman baga a yiri kum po. Ba yaa bek Yeezu ayen, ");
INSERT INTO bwu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ti Sagrɔ, Moosis ale ŋmarisi nyaku de a te ti a weeni ayen, ‘Nuru a dan faari wa pɔk ate ba an biak biik ale ge ate nuruwa a dan kpi, ku a fe kama ate wa suok a faari pukogini a biak bisa a te wa suoku waai ale kpi la.’ ");
INSERT INTO bwu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yɔgyɔgla de, nuruba bayopoi ale jam boro a chim suaata ate ba so kpagini a faari nipɔk ate wa an biak ale wa nya ale ge kpi. ");
INSERT INTO bwu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Waai ale pa a saŋ wa la me a yaa faari wa suoku powa alege nipowa ale wa me an biak a nya ya ale ge ate wa kpi. ");
INSERT INTO bwu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ba suok kuui ale pa a saŋ butawa la, a nyɛ kula me degadega. Ba meena bayopoiwa a faari nipɔk wala kama a taam tu alege ba waai ale wa an biak a nya ya ale ge kpi. ");
INSERT INTO bwu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ku ŋaaŋnyiŋ ate nipowa me a yaa kpi. ");
INSERT INTO bwu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Yɔgyɔgla de, ate nuruma bayopoiwa de meena a faari wa a nya la, da dii dai ate nuruba meena ayen ba yiri kum po la, ka wana le wa soa nipowa de?” ");
INSERT INTO bwu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yeezu yaa tulisi ba ayen, “Tɛŋzuk de demma a faari ka nipooba, a pa ba leeba me a yalisi choroba, ");
INSERT INTO bwu_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","alege nuru baai ale magsi ba yiri kum po a yaa bo tɛŋ kaai ale bo ŋaaŋ cheena la, ba kan yali chaaba. ");
INSERT INTO bwu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ba ba a nyɛ ase ka Naawen Sabiiloma la. Ba kan ŋman maari a kpi. Ba yaa ka Naawen bisa dii nyiŋ la, ba yiri kum po kama. ");
INSERT INTO bwu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moosis dek abe weeni nyaku de ate ku lagri kama ayen nuru baai ale kpi la le yiri kum po kama boan nyiŋŋa juijui ate wa ŋmarisi Naawen gbaŋka po a magsi chaab ale juijui ate wa nya bolimu goanni po ate bu a nyɛ nna ase bu a de ka ti fiik la wa weeni ayen, ‘Nyɔnɔwa ka ti kokpieŋsaŋa Abraham Naawen, Aizik Naawen, ale Jekob Naawen.’ ");
INSERT INTO bwu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ni poom seba kama ayen Naawen be daa kpilima Naawenya, alege wa ka ŋanvuuta Naawen, boan nyiŋŋa, waai meena vua kama wa jigi.” ");
INSERT INTO bwu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Juuma Sinsaŋŋa sagrɔma ba gela a yaa weeni ayen, “Sagrɔ, fi biisi ka nalimnyiini.” ");
INSERT INTO bwu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Dii nyiŋ la, ba ŋman ka siuk a bek wa bega ŋa chaaba. ");
INSERT INTO bwu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Alege Yeezu yaa bek ba ayen, “Ka boa ale soa ate ba a weeni ayen Kirisitawa waai ate Naawen a le tom wa ate wa jam la a le chim ka Naawa Deevid ŋaaŋbiiga? ");
INSERT INTO bwu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Wanni abe ale ka dii la ale Naawa Deevid dek a weeni Naawen gbaŋka Yiilaŋa dinyi po kama ayen, ‘Nyɔnɔwa Naawen weeni mi Nyɔnɔwa ayen, kali mi juga geŋ ");
INSERT INTO bwu_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ate ku jam paari diipo ate m le basi ate fi nya pagrim fi dachaasaŋa zuk.’ ");
INSERT INTO bwu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ase Deevid dek dan a wi Kirisitawa waai ate Naawen a le tom ate wa jam la, ayen wa Nyɔnɔ, ku be zaani ka se a te Kirisita a baga a chim Naawa Deevid ŋaaŋbiiga?” ");
INSERT INTO bwu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nuruma meena jam a za a wom kama ate Yeezu yaa weeni wa ŋaaŋviirima ayen, ");
INSERT INTO bwu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ni kpesi ni dek ale Juuma Sinsaŋŋa sagrɔma baai ale a yaali ayen ba jo ba kasaautaŋa a nyiem a cheŋ a yaali ayen waai a ta a puusi ba, yaba peelitaŋa po la, baai ale a yaali me ayen ba kali zukpaglik sii ate ba lueri zaani tuka diinaŋa po la. Ba ka nuru baai me ale a yaali ayen ba kali nuru kpeenta zukpaglisa zuima ŋandiin kpeenta tiŋŋa po la. ");
INSERT INTO bwu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ba be ka baai me ale a yaali pukoga paasi deka la, ale baai me ale a puusi Naawen venta puusa woŋta la. Ba la chaab waalika le gaam taam ka nna yegayega.” ");
INSERT INTO bwu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yeezu yaa jam kala Juuma Puusika Yenni po a mɔata juijui ate nuruba ta ba ligra a jam a nyoro a te Naawen la, a yaa nya ba. ");
INSERT INTO bwu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Wa yaa jam nya pukogi dinyi, wa jam ka jajak a yaa maa ta wa ligbie ŋaye a jam ayen wa lonsi du. ");
INSERT INTO bwu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yeezu yaa weeni ayen, “Wensie ate mi a weeni ni ayen, pukogi niwobowa de ale nyo ligri ŋaai du la, wa tiirimu a gaam mbala meena tiirintaŋa kama. ");
INSERT INTO bwu_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Dii nyiŋ la, mbala te ka ligra dii ale kan tɔa ale ba pa teka la alege pukogi niwobowa de a pa ka wa ligraŋa meena ate wa ta la a ta jam nyoro.” ");
INSERT INTO bwu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yeezu ŋaaŋviirima ba gela a jam a weeni ka Juuma Puusika Yenni ale nala dii ale di tintain nalinsaŋa ale tiirim tii meena ate nuruba te Naawen ate ba ŋmirisi di la. Yeezu yaa weeni ayen, ");
INSERT INTO bwu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Dii meena ate ni a nya nna la, di danni cheena ate nuruba jam nak di a lonsi. Ba kan basi tintain yeŋ me la di choa zuwa.” ");
INSERT INTO bwu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ba yaa bek wa ayen, “Ka dimpo ate wieŋa de ayen ŋa nyɛ? Ka boa ale ku nyɛ ate ku sak ti ayen danni a mɔata?” ");
INSERT INTO bwu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yeezu yaa weeni ba ayen, “Ni kpesi ni dek ate waai a kan paasi ni. Nuruba yegayega le jam mi yonni nyiŋ a pa ba dek a chim Kirisitawa waai ate Naawen a le tom la, a velim a weeni ayen di danni abe paari kama. Ni kan va ba. ");
INSERT INTO bwu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ni dan wom tigurisa wie ale kpaga ale a nya baai zuk la, a nyɛ kpaliŋ ale ba kpaŋŋa ni kan a chali yɔgsum. Ku a fe kama ayen nyaŋa de meena a nyɛ alege ku kan sak kama ayen tɛŋka kpeglimka a le deri jam kama.” ");
INSERT INTO bwu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Wa yaa ŋman weeni ba ayen, “Tɛŋsa gela dem ale ba nalima meena a le yiri a cheŋ ga tu chaab kpaliŋ po. ");
INSERT INTO bwu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tɛŋka me a le choa nna yegayega ate kom ale tue pagrisa jam jigi meena. Wakperikaliisa nna yegayega ale wie ŋaai ale ŋa te nuruba yɔgsum la le nyɛ wenŋmazuk chiŋmaaŋa po. ");
INSERT INTO bwu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Alege wieŋa de a dan yaa ŋa nyɛ, ku a fe kama ayen nuruba ale ba yik ni ale pagrim a basi ate ni nam nna yegayega. Ba a le yik ni a ta ni cheŋ ba tuka diinaŋa kpaŋŋa jigi ate ba bo ni buusa a yaase ba ta ni a ga lik likka diina po a yaase ba a le ta ni a cheŋ ga zaani nalima ale kanbonnalima niŋ. Ni ale a va mi la nyiŋ ale soa ate ba a le nyɛ ni dila. ");
INSERT INTO bwu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Dila powa nyaku de a le te ni siuk ate ni baga weeni mi wie a sak ba. ");
INSERT INTO bwu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ba dan ta ni a ga jo buusa boka dɔkku po, ni kan basi ate ku a daani ni ale dii ate ni tara ayen ni biisi ale boteerɔwa la, ");
INSERT INTO bwu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","dii nyiŋ la mi le weeni sak ni ni le ni weeni dii la. M be le te ni yam ate ni dachaasaŋa a kan ba a biisi gaam ni. ");
INSERT INTO bwu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ni dek koba ale ni maba ale ni suaata ale ni kobisa ale ni dɔaba a le yik ni ale pagrim a te ate ba ko ni ba gela. ");
INSERT INTO bwu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Waai meena a le kisi ni kama mi nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Alege zuik yeŋ me la ni zuimaŋa po a kan be. ");
INSERT INTO bwu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Dila nyiŋ ni yik ni dek nalimnyiini a siak a te ni ninam ate ni vari ni dek basi kama. ");
INSERT INTO bwu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ni dan ga nya ale sojiba a jam gilim Jerusalem tɛŋka, ni be seba ayen ka kaasika a mɔata kama. ");
INSERT INTO bwu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ni dan nya ale dila boro a nyɛ, nama baai ale bo Judia tɛŋka po la ni chali nna yegayega a ga suk guutaŋa sunsuŋ. Baai ale bo tɛŋka dek po la, ba basi dula jigini. Baai me ale bo peelim la, ba kan cheŋ tɛŋka dek po. ");
INSERT INTO bwu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Dii nyiŋ la, ase ba ale ŋmarisi dii Naawen gbaŋka po ayen da ŋala po ka ‘Waalika Da’ la le sum chim ka wensie. ");
INSERT INTO bwu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Da ŋala po, nipɔk baai ale ta puusa ale biluaata la jok wein kama. Dii nyiŋ la, kaasuŋ nna yegayega a le ku jam tɛŋka de, waalika nna yegayega me a le ka jam nuruma de jigi. ");
INSERT INTO bwu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ba a le pa ka gebi woŋta me a ko ba gela. Ba a le yik ba gela me a ta cheŋ tɛŋsa yegayega. Nuru baai ale kan daa Juuba la, a le kaasi Jerusalem abe ba bo ka po paari ba danni ate ba ale basi. ");
INSERT INTO bwu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Wakperikaliisa ale si a nyɛ wenbinni ale chiika ale chiŋmarisaŋa jigi. Sukaasuŋ nna yegayega a le di jam tɛŋzuk de nuruma meena jigi ate yɔgsum yik ba ale nya kpeemu ale a wuuri dii ate bu nyamiisaŋa me a nyɛ dii la. ");
INSERT INTO bwu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Yɔgsum a le yik nuruba kama ate ba cha ase ba ale a limsi dii ale di nyɛ tɛŋzuk meena la, dii nyiŋ la, chiŋmarisaŋa ale bo wenŋmazuk la, le tagri si suitaŋa kama. ");
INSERT INTO bwu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ŋala meena ŋaaŋnyiŋ, ate Mi Saalobiika a yaa pa m dek a sak ate nuruba yaa nya mu ale m bo chiŋmari po a cheena ale pagrim ale nyagsika nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wieŋa de a dan piilim nyeka ni yiri zaani ŋmai abe, ni zak ni zuima ŋmai dii nyiŋ la, ni varibasika danni mɔata kama.” ");
INSERT INTO bwu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yeezu yaa magsi wamagsini de a sak ba ayen, “Ni nya kiŋkaŋ ale tiisaŋa meena. ");
INSERT INTO bwu_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ase ni dan ga nya si ale si pusi vaata, ni seba ayen wulum wein a mɔata kama. ");
INSERT INTO bwu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ni be dan nya wieŋa de me ale ŋa piilim boro a nyɛ, ni yaa be seba ayen Naawen Naamu a mɔata kama. ");
INSERT INTO bwu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Wensie ate mi a weeni ni ayen jinla demma a kan kpi ase ka ba liŋ nya wieŋa de meena nyeka. ");
INSERT INTO bwu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Wenŋmazuk ale tɛŋka meena a le jam kpeglim ka da yeŋ. Alege mi wieŋa a kasim ta ka pagrim taam wuu. ");
INSERT INTO bwu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ni kpesi ni dek ate ni kan pa ni dek meena a te deka ale nyuka abe ni kan a daani ni dek ale nyeboka wie, kan daa di, Da dila danni a le jam diiri ni kama. ");
INSERT INTO bwu_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Dii nyiŋ la, da dila danni ale diiri waai meena kama ase baruk ate ba bari yik jaab la. ");
INSERT INTO bwu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Alege, m ŋman a weeni kama ayen ni kpesi ni dek daa meena, a puusi Naawen ayen ni a le ta pagrim ate ni baga nyini wieŋa de meena a le cheena ayen ŋa nyɛ la po a nyini ate ni baga zaani Mi Saalobiika niŋ.” ");
INSERT INTO bwu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yeezu a jam pa ka da ŋala meena a kasim a sak nuruba Juuma Puusika Yenni po. Junɔai nyiem a dan jam paari, wa a nyini kama a cheŋ guuk kuui ate ba a wi ayen Olivi guuk la. ");
INSERT INTO bwu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Saliuk yokyok foribi, nuruma meena a nyiem jam ka Juuma Puusika Yenni a wom wa sinsaŋŋa. ");
INSERT INTO bwu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ku jam tali ka magla ate Juuma tigi kpeeni dii ate ba a wi ayen Juuma Gaambasika Tigini la danni a paari. Da dila danni ale ba piilim a ŋobi boroboruk kuui ale kan ta dabinta ku po la. ");
INSERT INTO bwu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ku ale jam boro a mɔata da kpeeni la, Juuma Puusika Yenni kpaŋŋa ale Juuma Sinsaŋŋa sagrɔma a jam a gisi ka siuk ayen ba ko Yeezu, alege ba an baga dii nyiŋ la ba jam a chali ka yɔgsum ale nuruma. ");
INSERT INTO bwu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sitaana a ya basi ate Yeezu ŋaaŋviirima pi ale bayewa po wanyi a siak te wa. Wa yoi ale Judas Iskariot. ");
INSERT INTO bwu_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas yaa cheŋ Juuma Puusika Yenni kpaŋŋa ale Yenni limsidɔma jigi a biisi ale ba wa a le wa nyɛ dii a yik Yeezu a te ba la. ");
INSERT INTO bwu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ba sue a yaa jam peenti nna yegayega ate ba weeni ayen ba a le tuni wa ligra. ");
INSERT INTO bwu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas me a yaa jam siak a deri piilim a gisi siuk kuui ate ba yik Yeezu diipo ate nuru bɔanni karo la. ");
INSERT INTO bwu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tigini danni piilimka ate ba a ŋobi boroboruk kuui ale kan ta dabinta la, ba a pa ka pabisa a nyɛ kaabka a gomsi a magsi ayen ba de Juuma Gaambasika Tigini ŋandiintaŋa. ");
INSERT INTO bwu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Da dila danni, Yeezu yaa tom Piita ale Jɔɔn a weeni ba ayen, “Ni cheŋ a ga gomsi ti Gaambasika Tigini ŋandiintaŋa ate ti de.” ");
INSERT INTO bwu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ba yaa bek wa ayen, “Fi a yaali ayen ti cheŋ ka be a ga gomsi magsi?” ");
INSERT INTO bwu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Wa yaa tulisi ba ayen, “Ni nya de, ni ale a cheŋ tɛŋka po la, nidɔa ale wa ji nyiam ale samɔniŋ a jam tuni. Ni maa va wa a ga jo yeri dii po ate wa ga a jo la. ");
INSERT INTO bwu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ni dan ga jo, ni bek yenni nyɔnɔwa ayen, ‘Sagrɔwa a weeni ayen, fi dak nichamma dɔk kuui ate wa ale wa ŋaaŋviirima le jo kali de Gaambasika Tigini ŋandiintaŋa la a sak ti?’ ");
INSERT INTO bwu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wa le dak ŋmazuk dɔk kpioŋ kunyi ate ba vari ale gomsi ku meena po a sak ni. Ni yaa jo ku po a gomsi jaab buuri meena a magsi ate ti kali a de.” ");
INSERT INTO bwu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ba yaa cheŋ ga jo tɛŋka po a nya dii meena ate Yeezu a poom weeni ba la, ate ba yaa gomsi ba Gaambasika Tigini ŋandiintaŋa a magsi. ");
INSERT INTO bwu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ku ale jam paari diipo ate ba ayen ba de la, Yeezu ale wa tuimtomdɔma a yaa maa chaab kali ayen ba de. ");
INSERT INTO bwu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Wa yaa weeni ba ayen, “M poom kasim a yaali ka nna yegayega ayen m kali a de Gaambasika Tigini ŋandiintaŋa de ale nama abe m ge a nam ");
INSERT INTO bwu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","dii nyiŋ la, m kan de deka de diipo diipo ase ka da dii danni ate Naawen Naamu ale jam la ate ti yaa de ate deka de a sak ni ka wie la.” ");
INSERT INTO bwu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yeezu yaa pa beerik ale daam a puusi a te Naawen a nyɛ wa jiam ale ge a weeni ba ayen, “Ni ŋɔa a chari chaaba, ");
INSERT INTO bwu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","dii nyiŋ la, m kan ŋman nyu daamu de ase ka Naawen Naamu a nin jam.” ");
INSERT INTO bwu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Wa yaa ŋman pa boroboruk a puusi Naawen a nyɛ wa jiam, a yik ku a wie a te ba ale ge weeni ba ayen, “Ni ŋɔa ŋobi, mi nyiŋka ale nna ate m pa a te ni. Ni nyiem kasim a nyɛ nna ate ni a teeri m wari.” ");
INSERT INTO bwu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Dila degadega, ba ale ga de nueri la, wa yaa ŋman pa beerika ale daamu a weeni ba ayen, “Beerika de ale daamu a kpiiri basi a te ka nama ayen yɔgyɔgla de Naawen a va mi ziimu nyiŋ yaa basi ate wa dek ale nuruba a ta noayeŋ paalik ale chaab. ");
INSERT INTO bwu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Alege nuru waai le wa ta mi a ga bobri a sak la, a maa kali ka dela ale mi a de. ");
INSERT INTO bwu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ka Naawen ale poli ku ayen Mi Saalobiika a kpi alege nuru waai dek a le wa ta Mi Saalobiika a ga bobri sak la, ku le bie wa jigi.” ");
INSERT INTO bwu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Wa ŋaaŋviirima yaa jam a bek ba dek ayen, “Ka tama wana a le wa nyɛ dila?” ");
INSERT INTO bwu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Wa ŋaaŋviirima a yaa jam a nak nampaga ale chaab a bek chaab ayen, “Ka tama po wana dek ate nuruba a poli ayen wa ka nuru kpioŋ a gaam ti meena?” ");
INSERT INTO bwu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yeezu yaa weeni ba ayen, “Tɛŋzuk de nalimaŋa ta pagrim ka nna yegayega a gaamu ba nuru baai zuk ate ba a nya la. Nuruma ka wariwari a maari a biisi. Ba a wi ba nalimaŋa ayen ka ba maaroba. ");
INSERT INTO bwu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Alege nama jigi ku be daa dila, ku a fe kama ayen waai ale chim nuru kpioŋ ni meena po la, a pa wa dek a chim ni meena baaŋ, waai me abe ale chim ni niŋdeero la, ku a fe kama ayen wa chim ni tomteerɔ. ");
INSERT INTO bwu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Basi ate m bek ni nyaku de ayen, nuruma de bayewa, ka ba wana ale gaam wa choa, waai ale kali tɛŋ a de ŋandiintaŋa la yaa waai ale nyɛ ŋandiintaŋa a te waai ale kali tɛŋka a de la? Daa waai ale kali tɛŋka a de la ale gaam waai ale a te wa la? Alege mi bo ni po ase ka nuru waai ale ka tomteerɔ la. ");
INSERT INTO bwu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Nama kasim bo ale mi ale m ninammu meena kama. ");
INSERT INTO bwu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ase mi kowa ale pa wa naamu a nyo mi nisima po dii la, mi me ase m kowa ale nyɛ dii la, a te ni ka siuk ");
INSERT INTO bwu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ate ni a de abe ni a nyu m naamu po, abe ni kali zukpaglisa zuima a nya Izirali buuni pi ale buyewa meena zuk. ");
INSERT INTO bwu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, Simon kpesi fi dek ale Sitaana a juisi ka siuk ayen wa nyɛ ni meena a nya. Wa ale yeeri ŋan maŋsaŋa ŋan baataŋa po, ase kparo ale yali votta a basi ale a ge ŋan bieŋa dii la. ");
INSERT INTO bwu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Alege, mi puusi Naawen a te fi Simon kama ayen fi kan basi fi siaka. Fi dan tagri a siak mi noai ase ti ale poom a nyɛ dii yɔgyɔgla la ku a fe kama ate fi nyɛ ate fi suaataŋa a ta pagrim me.” ");
INSERT INTO bwu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simon Piita yaa tulisi wa ayen, “M Nyɔnɔ, mi gomsi magsi kama ayen m maa va fu a cheŋ likka dɔk a yaase m kpi ale fu.” ");
INSERT INTO bwu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yeezu yaa weeni wa ayen, “Mi a le a weeni fi Piita ayen, fi ale pagsi ku noai buta ayen fi ze mi, alege ate kpadiaka a kum.” ");
INSERT INTO bwu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yeezu yaa bek ba ayen, “Diipo ate mi jam tom ni ate ni cheŋ alege ka ligra fook, yaase fɔrok, yaase nuensa la, ni jam jogi jaabɔa?” Ba yaa tulisi wa ayen, “Aawo, ti an jam jogi jaabjaabɔa.” ");
INSERT INTO bwu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yeezu yaa weeni ba ayen, “Alege yɔgyɔgla de ate mi a weeni ni ayen waai a dan ta ligra fook, yaase fɔrok ku a fe kama ayen wa pai. Waai abe dan kan ta gebi woŋ ku a fe kama me ayen wa pa wa kasaauk a da a yaa pa ligraŋa a da gebi kala choawa. ");
INSERT INTO bwu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Boan nyiŋŋa, ba ale ŋmarisi Naawen gbaŋka po dii ayen, ‘Ba jam pa wa a gum chaab ale ka zueba la’, ku a fe kama ayen dila chim wensie mi jigi. Dii nyiŋ la, ba ale ŋmarisi dii dila po dila po a magsi chaab ale mi la, a boro a chim ka wensie.” ");
INSERT INTO bwu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ba yaa tulisi wa ayen, “Ti Nyɔnɔ, tama ta ka gebi sila chaab siye.” Yeezu yaa tulisi ba ayen, “Dila magsi kama.” ");
INSERT INTO bwu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yeezu ale wa ŋaaŋviirima yaa basi dula jigini ale ge cheŋ Olivi Guuku ase wa nyiem ale a nyɛ dii la. ");
INSERT INTO bwu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Wa ale jam paari dula jigini la, wa yaa weeni ba ayen, “Ni a puusi Naawen ate ni kan pa ni dek te nyenyaka.” ");
INSERT INTO bwu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Wa yaa poori wa dek wa tɔga a taam nakpiak a kpi duna tɛŋ a puusi Naawen ayen, ");
INSERT INTO bwu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“M koa, ku dan ka fi yaalika, yeeri ninammu de m jigi a basi, alege nyɛ fi dek ale a yaali dii la, daa mi ale a yaali dii la.” ");
INSERT INTO bwu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Naawen sabiiloma wanyi a yaa jam wa jigi a te wa pagrim. ");
INSERT INTO bwu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ase wa a le jam a yiili wa ninammu wie la, wa yaa ŋman puusi Naawen a gum du ate wulum a kasim jam a zi nna ase ka ziim ale a zi tɛŋ la. ");
INSERT INTO bwu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Wa ale ga puusi Naawen nueri la, wa yaa yiri ŋman pilim jam wa ŋaaŋviirima jigi a jam a paari ale ba dua a goa dii nyiŋ la ba sue ale jam kaasi ");
INSERT INTO bwu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ate wa yaa bek ba ayen, “Ka boa ate ni dua a goa? Ni yiri a puusi Naawen ate ni kan pa ni dek te nyenyaka.” ");
INSERT INTO bwu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Wa ale jam diem boro a biisi nna la, nuruba yegayega ale Judas waai ale jam ka wa ŋaaŋviirima po pi ale bayewa la a yaa de ba niŋ a cheena. Wa yaa forisi paari Yeezu a puusi wa. ");
INSERT INTO bwu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Alege Yeezu yaa weeni Judas ayen, “Judas, fi a dak Mi Saalobiika a sak ale ka puusa?” ");
INSERT INTO bwu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yeezu ŋaaŋviirima baai ale jam maa bo ale Yeezu ale ga nya dii ale di nyɛ la, a yaa bek Yeezu ayen, “Nyɔnɔ, ti pa ti gebik wonsaŋa a chubi ba?” ");
INSERT INTO bwu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ba wanyi a yaa deri che Juuma Puusika Yenni kpagi kpeeni tomteerɔma po wanyi juga turi. ");
INSERT INTO bwu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yeezu yaa weeni ba ayen, “Dila magsi kama”. Wa yaa tiri nuruwa tunni ate di deri nueri. ");
INSERT INTO bwu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yeezu yaa bek Juuma Puusika Yenni kpaŋŋa ale Yenni limsidɔma ale nisomma baai meena ale jam nyini jam ayen ba yik wa la, ayen “Mi ka zue ate nama ta gebi woŋta ale dua a jam ayen ni yik mu? ");
INSERT INTO bwu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Daa meena mi kasim bo ale nama kama Juuma Puusika Yenni po a sak nuruba alege nama an jam pa nisa a tiri mu, ka nama me danni ale nna, di be ka da dii me ate Sitaana ta siuk pa wa pagrimu a tom tuima la.” ");
INSERT INTO bwu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ba yaa yik wa a ta wa cheŋ Juuma Puusika Yenni kpagi kpeeni yenni. Piita yaa wari ŋaaŋ a cheŋ a vi. ");
INSERT INTO bwu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ba ale jam tɔati bolim yenni dabiaka po a maa chaab a kali la, Piita jam maa bo ba po kama. ");
INSERT INTO bwu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nipɔkbili wanyi ale jam boro. Wa jam ka pɔkdɔklie. Nipɔkbinni de ale nya ale Piita kala bolimu niŋ la, wa yaa nya wa nna ziim, a weeni ayen, “Nuruwa de a poom bo ale wa kama.” ");
INSERT INTO bwu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Piita yaa pagsi ayen, “Nipɔkbiliga, mi poom ze wa.” ");
INSERT INTO bwu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ku an bula beniya ale ge ate nuru wa choa a ŋman nya wa a weeni ayen, “Fi me ka ba po wanyi.” Alege Piita ŋman weeni ayen, “Nidɔa, mi maa daa ba po.” ");
INSERT INTO bwu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ku ale ŋman ga beni maga dega la, nuru wa choa a ŋman weeni ale nin muna ayen, “Mi seba chak kama ayen nuruwa de a jam maa bo ale wa kama, dii nyiŋ la, nuruwa de ka Galili tɛŋka deno.” ");
INSERT INTO bwu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Alege Piita ŋman weeni ayen, “Nidɔa, mi ze fi ale a biisi dii la.” Wa ale diem boro a biisi dila la, kpadiaka yaa kum, ate Nyɔnɔwa yaa, viriŋ nya Piita ");
INSERT INTO bwu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ate Piita yaa teeri Nyɔnɔwa ale poom weeni wa dii ayen, “Fi le pagsi kama ku noai buta ayen fi ze mu ale ge ate kpadiaka kum yokku de.” ");
INSERT INTO bwu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Piita ale ga teeri dila la, wa yaa nyini peelim kum nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nuru baai ale jam ta Yeezu la, a yaa nyɛ wa a la ale a nak wa, ");
INSERT INTO bwu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","a yaa pa ŋanta a bobi lik wa ninaŋa me a yaa bek wa ayen, “Weeni a sak ti waai ale nak fu la.” ");
INSERT INTO bwu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ba jam biisi ka wie ŋa chaab nna yegayega a le wa. ");
INSERT INTO bwu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Vari ale ga veenti la, nisomma a yaa jam tu chaab. Ba gela a jam ka Juuma Puusika Yenni kpaŋŋa, ba gela me Juuma Sinsaŋŋa sagrɔba. Nuru baai ale jam ta Yeezu la a yaa ta wa a cheŋ ba jigi ate ba yaa bek wa ayen, ");
INSERT INTO bwu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Fi ka Kirisitawa waai ate Naawen weeni ayen wa a le tom ate wa jam la, be weeni a sak ti.” Alege wa yaa tulisi ba ayen, “M dan weeni a sak ni, ni kan ta siaka. ");
INSERT INTO bwu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","M be dan begi ni bega ni kan tulisi mu. ");
INSERT INTO bwu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Alege a zaani jinla a ta a cheŋ, Mi Saalobiika a le kali ka Pagrɔwa Naawen juga geŋ.” ");
INSERT INTO bwu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ba meena a yaa ŋman begi wa ayen, “Fi abe ka Naawen biika?” Yeezu ŋman tulisi ba ayen, “Nama ale weeni.” ");
INSERT INTO bwu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ba yaa bek chaab ayen, “Ka boan jaab wari ate ti ŋman a yaali ayen ti wom a magsi chaab ale nuruwa de dii nyiŋ la, ti wom ku kama a ta nyini wa dek noai po ayen ti an velim ya.” ");
INSERT INTO bwu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nisomma meena yaa yiri ta Yeezu a cheŋ Gominawa Paalɔt jigi. ");
INSERT INTO bwu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Juijui ate ba tɔariŋ wa a weeni ayen, “Tama yik nuruwa de kama ale wa boro a paasi ti nuruma ayen ba kan a tuni ba lampoowa a te nakpioŋku Siiza. Wa maari a weeni me ayen wa dek ale Kirisitawa. Ku kiri ale wa ka naab.” ");
INSERT INTO bwu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Gominawa Paalɔt a yaa bek wa ayen, “Ka fi ale Juuma naawa la?” Yeezu yaa tulisi wa ayen, “Fi ale weeni.” ");
INSERT INTO bwu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Paalɔt yaa weeni Juuma Puusika Yenni kpaŋŋa ale nuru bɔanni ayen, “Mi an nya nuruwa de wari dii ate wa kaasi la.” ");
INSERT INTO bwu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ba yaa ŋmasi a biisi nna yegayega ayen, “A zaani Galili tɛŋka a jam paari Judia tɛŋka a ta ga paari dela, wa kasim a sak nuruma kama ayen ba basi ate kaasuŋ jam.” ");
INSERT INTO bwu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Paalɔt ale wom nna la, wa yaa bek ayen, “Nuruwa de ka Galili deno?” ");
INSERT INTO bwu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Paalɔt ale wom ayen Yeezu nyini ka juijui ate Naab Ayerod a jam a nya ka zuk la, wa yaa basi ate ba ta Yeezu a cheŋ wala jigi. Dila po wa Naab Ayerod dek a jam bo ka Jerusalem tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Naab Ayerod ale nya Yeezu la, ku yaa peenti wa sui nna yegayega boan nyiŋ, wa kasim jam a yaali ka nna yegayega ayen wa nya wa dii nyiŋ la, wa wom ka wa wari ate wa yaa jam a yiili ayen wa le nyɛ wakperikaliik ate wa nya. ");
INSERT INTO bwu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Naab Ayerod yaa bek wa bega nna yegayega alege Yeezu an jam tulisi wa. ");
INSERT INTO bwu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Juuma Puusika Yenni kpaŋŋa ale Juuma Sinsaŋŋa sagrɔma a yaa za dula a tɔariŋ Yeezu ale nin muna. ");
INSERT INTO bwu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Naab Ayerod ale wa sojima a yaa nyɛ Yeezu a la ale a nyɛ wa jigi nna ase wa daa nuru la. Ba ale nyɛ dila la ba yaa pa kasaauk naluŋ jo Yeezu ate Naab Ayerod yaa weeni ate ba ta wa ŋman cheŋ Paalɔt jigi. ");
INSERT INTO bwu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Da dila danni Naab Ayerod ale Paalɔt a deri de dɔata ale chaab. Ba jam ka dachaasa alege ate nyaku de a nyɛ. ");
INSERT INTO bwu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Paalɔt yaa wi Juuma Puusika Yenni kpaŋŋa ale kpaga ŋa chaab ale nuruma ");
INSERT INTO bwu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","a yaa weeni ba ayen, “Nama ale ta nuruwa de a jam mi jigi a weeni mi ayen wa a dak ka siuk kaasuŋta a sak nuruma. Yɔgyɔgla de nama dek a be nya mi ale bek wa beŋŋa meena alege mi an nya dii meena ate nama weeni ayen wa kaasi la. ");
INSERT INTO bwu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ayerod me a be an nya wa wakaasuŋŋɔa dii nyiŋ la, ka wala ale basi wa ate wa jam tama jigi. Nuruwa de an nyɛ wariwari a magsi kummɔa. ");
INSERT INTO bwu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","M be le basi kama ate m sojima miiri wa abe m basi wa ate wa cheŋ.” ");
INSERT INTO bwu_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Bena meena ba Juuma Gaambasika Tigini a nyiem dan jam paari ku nyiem a fe kama ayen Gominawa Paalɔt lak nuru waai ate wa tɛŋka demma a yaali ayen ba lak ate wa nyini likka dɔkku po a nyini la a basi. ");
INSERT INTO bwu_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","19","Nuru wanyi ale jam boro ate ba a wi ayen Barabasi ate ba jam maa yik wa a lik dii nyiŋ la, wa jam maa nyɛ ka noai yeŋ ale wa tɛŋka demma a yaa nyɛ kpaliŋ ale baai ale a nya wa tɛŋka zuk la ate wa ko nuruba ate ba yaa yik wa a lik. Nuruma yaa maa chaab a kaari ate ku jueli nna yegayega a weeni ayen, “Ko wa abe fi yeeri Barabasi a basi te ti.” ");
INSERT INTO bwu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Paalɔt yaa ŋman biisi ale ba a yaali ayen wa yeeri Yeezu a basi. ");
INSERT INTO bwu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Alege nuruma a ŋman kaari ate ku jueli nna yegayega a weeni ayen, “Kpi wa jabarim nyiŋ, kpi wa jabarim nyiŋ.” ");
INSERT INTO bwu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Dii ale a saari butawa la, Paalɔt yaa bek ba ayen, “Ka boa? Ka boan jaab wabiok ate wa nyɛ? Mi an nya wa dii ate wa kaasi a magsi wa kpi la. M le basi kama ate m sojima miiri wa abe m basi wa.” ");
INSERT INTO bwu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Alege nuruma yaa ŋman kaari ate ku jueli nna yegayega a gaam dii ate ba poom kaari la a weeni ayen, ba kpi wa jabarim nyiŋ ate wa kpi. Ba kaarika de a jam basi kama ate ba de. ");
INSERT INTO bwu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Paalɔt yaa siak bo buusa te ba ");
INSERT INTO bwu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","a yaa lak Barabasi waai ale jam maa nyɛ noayeŋka ale wa tɛŋka demma a nyɛ kpaliŋka a ko nuruba ate ba yik wa a lik la a te ba, Paalɔt yaa pa Yeezu a te wa sojima ayen ba nyɛ wa dii ate ba a yaali la. ");
INSERT INTO bwu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sojima a yaa ta Yeezu a cheŋ a yaa ga zik nuru wanyi ale wa cheena tɛŋka po. Wa yoi ale Simon. Wa jam nyini ka Sairini. Sojima yaa yik wa a fe wa ate wa ji Yeezu jabarimu a va wa ŋaaŋ. ");
INSERT INTO bwu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nuru bɔari nna yegayega ale jam va wa. Nipooba ale jam maa bo ba po, a yaa kum ale a kaari Yeezu nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yeezu yaa virim nya ba a weeni ba ayen, “Jerusalem nipooba, ni kan a kum a te mi, ni a kum a te ni dek ale ni bisaŋa. ");
INSERT INTO bwu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Dii nyiŋ la, daa le cheena ate nuruba ale weeni ayen, ‘Nipɔk baai ale kan ka bisa la, baai ale kan biak nya la, baai ate bisa an ŋoosi la a ta wein la.’ ");
INSERT INTO bwu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Dila powa ale nuruba a le weeni guuk kpeentaŋa ayen, ‘Ni lo ti zuk,’ abe ba weeni guuk fiisaŋa me ayen, ‘Ni lik ti.’ ");
INSERT INTO bwu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ni be wom wamagsini de, nipooba, ‘Ase duoku ale yɔgsa alege ba a nyɛ nna la, ka boa a le di nyɛ ase ku nin ko?’ ” ");
INSERT INTO bwu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tuim kaasima nyam baye a te ba jam maa ta ba ale Yeezu a cheŋ ayen ba kpi ba. ");
INSERT INTO bwu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ba ale jam paari juijui ate ba a wi ayen “Zukoluku La”, ba yaa kpi wa jabarimu nyiŋ. Tuim kaasima nyamma me bayewa ba kpi wanyi a zaani wa juga, wanyi me a zaani wa gala. ");
INSERT INTO bwu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yeezu yaa weeni ayen, “M Koa, voŋ te nuruma de dii nyiŋ la, ba ze ba ale a nyɛ dii la.” Ba ale kpi wa la, ba yaa nak gbaŋ a lueri wa gattaŋa a chari chaab. ");
INSERT INTO bwu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nuruma yaa za a nya wa, alege ba kpaŋŋa yaa nyɛ wa a la a weeni ayen, “Wa vari nuru ba chaab a basi, basi ate wa vari wa dek a basi ase wa nin ka Varibasidɔwa, waai ate wa lueri la.” ");
INSERT INTO bwu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sojima me a jam a nyɛ wa a la a pa da miisiŋ a te wa a nyɛ ase ba a te wa ka zula la. ");
INSERT INTO bwu_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ale a weeni ayen, “Fi dan ka Juuma naab, be vari fi dek a basi.” ");
INSERT INTO bwu_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ba jam ŋmarisi ka jaab tapagi nyiŋ ayen, KA JUUMA NAAWA ALE NNA a yaa pa di a maŋ wa jabarimu zuk. ");
INSERT INTO bwu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tuim kaasimaŋa nyamma bayewa ate ba jam maa kpi ba a gum Yeezu po la, bala wanyi a yaa jam a le wa ayen, “Fi daa Varibasidɔwa? Be vari fi dek ale tama me a basi.” ");
INSERT INTO bwu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Alege wa vaanchoawa a yaa tɔariŋ wa ayen, “Fi kan chali Naawen ya ale ba ale nyɛ ti meena bunyi dii la? ");
INSERT INTO bwu_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ba ale nyɛ tama dii la, ku magsi kama dii nyiŋ la, ka tama tuim kaasimaŋa tutuna ale nna ate ti boro a tuesi. Alege nuruwa de an kaasi wariya.” ");
INSERT INTO bwu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Wa biisi dila ale ge a yaa weeni ayen, “Yeezu, fi dan jam ase naab la, teeri m wari.” ");
INSERT INTO bwu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yeezu yaa weeni wa ayen, “Wensie ate mi a weeni fu ayen jinla fi a le bo ale mu Naawen jigi.” ");
INSERT INTO bwu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Wenbinni ale ga jueli wenzuk sunsuŋ la, wenbinni a yaa sobri ate ku yaa deri nyɛ nna birim ate legi a yaa lik tɛŋ kala meena a ta dila a jam paari kantueŋ baŋ buta, ");
INSERT INTO bwu_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ate garuk kpioŋ kuui ate ba pa lik a kasi buye Juuma Puusika Yenni po la, a yaa jam cheeri poori buye. ");
INSERT INTO bwu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yeezu yaa kaari nna yegayega ate ku jueli ayen, “M Koa, m pa m chiika a nyo fi nisima po”. Wa ale weeni dila la, wa yaa deri kpi. ");
INSERT INTO bwu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sojima kpagini ale jam za dula a yaa nya dii ale nyɛ la, wa yaa te Naawen pimpauk a weeni ayen, “Nuruwa de a sum jam ka wayɔrisima nyɔnɔ.” ");
INSERT INTO bwu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nuru bɔari ale jam jam ayen ba nya dii le di nyɛ la. Ba ale nya dii meena ale nyɛ la ba yaa pilim ŋmani a kuli ale sukaasuŋ. ");
INSERT INTO bwu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Baai meena ale jam seba Yeezu nalimnyiini a chak la, ale nipɔk baai me ale jam va wa a nyini Galili a jam la, bala meena a jam za ka niŋniŋa alege a nya. ");
INSERT INTO bwu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nuru wanyi ale jam nyini Juuma tɛŋ kanyi ate ba a wi ayen Arimatia, wa yoi a jam ale Josefi, wa jam ka nuru maŋ ale chim welensa nyɔnɔ. Wa jam maa ka nisomma, po wanyi. Alege wa an jam siak ale ba ale poli a nyɛ Yeezu dii la. Wa kasim jam a limsi ka diipo ate Naawen a le jam soa nuruba la. ");
INSERT INTO bwu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Josefi wa de ale jam cheŋ Paalɔt jigi a ga saalim wa ayen wa basi ate wa ga yeeri kpiowa jabarimu zuk. ");
INSERT INTO bwu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Paalɔt yaa siak ate wa ga yeeri wa a ta nyini jabarimu zuk a siŋ, a yaa pa garupali peeluk a vili wa a ta wa ga gu puŋ vorub ate ba keri la po. Kpio an jam duak bu po a nya ya. ");
INSERT INTO bwu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Da dila danni ka da dii ate ba a gomsi ba dek a limsi ba Vuusum Danni la. Vuusum Danni abe jam boro a piilim kama me. ");
INSERT INTO bwu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nipɔk baai ale jam va Yeezu a nyini Galili tɛŋka a jam la a yaa jam va Josefi a cheŋ ga nya vorumu ate Yeezu dua bu po juijui la ");
INSERT INTO bwu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ale ge a yaa pilim ŋmani a ga gomsi kpa masisa. Vuusum Danni a yaa ale jam paari la, ba vuusi kama ase ba sinsaŋŋa ale a sak ba dii la. ");
INSERT INTO bwu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Laasidi Dai saliuk yokyok wa ate nipooma yaa yiri ale ba kpa masisaŋa a cheŋ boosuku jigini. ");
INSERT INTO bwu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ba yaa ga a paari a nya ale tintain dii ate ba pa lik boosuk nɔanni la ale di bilim ale ge boosuku nɔanni a basi. ");
INSERT INTO bwu_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ate ba yaa jo bu po alege ba an nya Nyɔnɔwa Yeezu nyiŋka. ");
INSERT INTO bwu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ba yaa za dula jigini ate ku cha ba. Nuruba baye a yaa jo garuk peeta ate ti a nyagsi nna kpelimkpelim a deri za ba tɛŋ. ");
INSERT INTO bwu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Yɔgsum a yaa yik nipooma ate ba pa ba zuima a su tɛŋ ate nuruma yaa bek ba ayen, “Ka boa ale soa ate ni a gisi nuru waai ale vua la kpilima sunsuŋŋa? ");
INSERT INTO bwu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wa ka dela, wa yiri kum po kama. Ni teeri wa ale jam weeni ni dii diipo ate ni jam bo ale wa Galili tɛŋka po la. ");
INSERT INTO bwu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Wa ale jam weeni ayen, ‘Mi Saalobiika ku a fe kama ate nuruba a yik mu a pa nyo tuimbaata nyam nisima po, ate ba kpi mu jabarim nyiŋ alege daa ŋata dai m le yiri kum po.’ ” ");
INSERT INTO bwu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nipooma yaa teeri wa wieŋa de ");
INSERT INTO bwu_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ate ba yaa pilim ŋmani a jam weeni nyaku de a sak wa ŋaaŋviirima pi ale wanyiwa ale nuru mbala meena. ");
INSERT INTO bwu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nipooma jam ale Mɛɛri waai ale nyini Magdala la, ale Joana, ale Jeemsi mawa Mɛɛri, nyaba de ale nipooba ba chaab baai ale jam bo ale ba la yaa weeni wieŋa de a sak tuimtomdɔma. ");
INSERT INTO bwu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Alege tuimtomdɔma jigi, wieŋa de a jam chim ka sunsuelima, dila nyiŋ, ba an jam siak ayen ku ka wensie. ");
INSERT INTO bwu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Piita yaa yiri chali cheŋ boosuku jigini a ga chuiri nya alege wa an nya jaabɔa, ka gatta nyiini. Ku yaa cha wa nna yegayega ate wa kuli. Wa jam a poli ka dii dek chekki ale nyɛ la. ");
INSERT INTO bwu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Da dila danni degadega ate Yeezu ŋaaŋviirima baye a yaa jam a cheŋ tɛŋfiik ate ba a wi ka ayen Imayas, ka jam ka mɛɛla ŋayopoi ale Jerusalem tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ba ale bo siuku po a cheŋ la, ba yaa a biisi ŋaai meena ale nyɛ la. ");
INSERT INTO bwu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ba ale jam a biisi ŋa wie ale a magsi ŋa la, Yeezu dek a yaa forisi paari ba ate ba va chaab a cheŋ ");
INSERT INTO bwu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","alege jaab ale jam nyɛ ate ba an jam baga a miŋ wa. ");
INSERT INTO bwu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yeezu yaa bek ba ayen, “Ka boan jaab wari ate nama biisi a cheŋ la?” Ba yaa za nna zimm ale sukaasuŋ. ");
INSERT INTO bwu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ba wanyi ate ba a wi ayen Kiliyopas, wala a yaa tulisi wa ayen, “Ka fi nyiini ale nichaano Jerusalem tɛŋka po a ze wa ŋaai ale bo ka po daaŋa de la?” ");
INSERT INTO bwu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Wa yaa bek ba ayen, “Ka boan wie?” Ba yaa tulisi wa ayen, “A magsi chaab ale Yeezu Nazaret deno waai ale jam ka Naawen biisiteerɔ ate wa wie ale wa biik a pagra Naawen jigi ale nuru meena jigi la. ");
INSERT INTO bwu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ate tama Puusika Yenni kpaŋŋa ale tɛŋka nisomma a yaa yik wa ayen ba bo buusa a ko wa. Ba yaa sum kpi wa jabarim nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Alege tama jam a yiili kama ayen ka wala le wa vari Izirali tɛŋka a basi, daa dila nyiini, ku daa ŋata ale jinla ate nyaku de meena a nyɛ la. ");
INSERT INTO bwu_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Daa dila nyiini me, tama buuni po, nipooba ale weeni wari ate di cha ti nna yegayega. Ba cheŋ ka wa boosuku jigini saliuk yokyokku de ");
INSERT INTO bwu_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","alege ba an nya wa nyiŋka. Ba yaa pilim jam a weeni ayen ba nya Naawen sabiiloba ate ba weeni ba ayen wa vua kama. ");
INSERT INTO bwu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Baai ale jam maa bo ale tama la ba gela a cheŋ boosuku jigini kama a ga nya nipooma ale poom liŋ weeni ba dii la degadega. Ba an nya wa.” ");
INSERT INTO bwu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yeezu yaa weeni ba ayen, “Ni ka betta! Ka boa ale soa ate ni an baga a ta siak ale Naawen biisiteerɔma ale biisi dii la. ");
INSERT INTO bwu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ku kan jam a fe kama ayen Kirisitawa ate Naawen a le tom ate wa jam la a nam ale wieŋa de abe wa ge nya wa zulaŋa?” ");
INSERT INTO bwu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yeezu a yaa piilim deri a weeni wie ŋaai meena ate ba ŋmarisi Naawen gbaŋka po a magsi chaab ale wa dek la kiri. Wa jam piilim ta nyini ka Moosis ale Naawen biisiteerɔma meena a weeni ŋa kie a sak ba. ");
INSERT INTO bwu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ba yaa jam boro a mɔata tɛŋfiik kaai ate ba a jam a cheŋ la. Yeezu yaa nyɛ ase wa a taam ka niŋ la. ");
INSERT INTO bwu_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Alege ba yaa yik wa a weeni ayen, “Ti kuli ga goa dii nyiŋ la, wenni boro a siŋ kama ate tɛŋka boro a sobri.” Wa yaa siak va kuli. ");
INSERT INTO bwu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ba ale boro a de la, wa yaa pa boroboruk a nyɛ Naawen jiam a wie ku a yaa pa a te ba ");
INSERT INTO bwu_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ate ba nina a yaa deri lagri ate ba miŋ wa ate wa yaa deri murum be ba nina po. ");
INSERT INTO bwu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ba yaa weeni chaab ayen, “Ti ale poom bo siuku po ate wa a biisi dii a magsi chaab ale ba ale ŋmarisi Naawen gbaŋka po dii la, an poom a te ti masim ti suniima po?” ");
INSERT INTO bwu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ba yaa deri yiri bunyi a cheŋ Jerusalem tɛŋka. Dula jigini, ba yaa ga nya wa ŋaaŋviirima pi ale wanyiwa ale ba tigsi chaab a kali jigi yeŋ ale baai meena ale jam a maa kali ale ba la ");
INSERT INTO bwu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ale ba kala a biisi ayen, “Ti Nyɔnɔwa a sum yiri kum po kama a pa wa dek a sak Simon.” ");
INSERT INTO bwu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kiliyopas ale nwala yaa weeni a sak ba dii meena ale nyɛ siuku po la ale wa ale wie boroboruku ate ba miŋ wa dii la. ");
INSERT INTO bwu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ba ale jam boro a biisi nna la, Yeezu dek a deri jam za ba sunsuŋ a weeni ba ayen, “Ni boro ale suyɔgini.” ");
INSERT INTO bwu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ate yɔgsum nna yegayega a jam yik ba ate ba poli ayen ba nya ka kok. ");
INSERT INTO bwu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Alege wa yaa bek ba ayen, “Ka boa ale a daani ni? Ka boa ale soa ate ni ta chichama ni zuimaŋa po? ");
INSERT INTO bwu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ni nya m nisimaŋa ale m naŋsaŋa ate ni miŋ ayen ka mi dek ale la. Ni tiri mu a nya ate ni seba ayen daa kowa dii nyiŋ la, kok ka nyiŋŋa ale koba ase ni ale nya mi ale ta dii la.” ");
INSERT INTO bwu_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Wa ale weeni dila la, wa yaa pa wa nisaŋa ale wa naŋsaŋa a sak ba. ");
INSERT INTO bwu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ba an diem jam siak ayen ku ka wensie, dii nyiŋ la, supeentik ale jam bo ba jigi ate ku cha ba me. Yeezu yaa bek ba ayen, “Ni ta jaab dela a de?” ");
INSERT INTO bwu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ba yaa pa jum digima te wa ");
INSERT INTO bwu_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ate wa ŋobi ate ba nya. ");
INSERT INTO bwu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Wa yaa weeni ba ayen, “Wieŋa de degadega ate mi jam weeni ni diipo ate mi jam diem bo ale ni la, ayen wie ŋaai meena ale bo Naawen gbaŋka po ate Moosis ŋmarisi Sinsaŋŋa gbaŋka po la, ale Naawen biisiteerɔma gbaŋsaŋa ale gbaŋ kanyiwa ate ba a wi ayen Yiila Gbaŋ la po a magsi chaab ale mi la, ku a fe kama ayen ŋa chim wensie.” ");
INSERT INTO bwu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Wa yaa lagri ba popolaŋa ayen ba miŋ chak ba ale ŋmarisi dii Naawen Gbaŋka po la. ");
INSERT INTO bwu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Wa yaa weeni ba ayen, “Ba ŋmarisi ka po ayen, ku a fe kama ate Mi Varibasidɔwa ate Naawen le tom ate m jam la, a nam abe daa ŋata dai m yaa yiri kum po. ");
INSERT INTO bwu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ku be a fe kama me ayen nuruba pa mi yonni nyiŋ a sak nuru meena tɛŋzuk de ayen ba basi ba tuimbaataŋa tomka ate Naawen voŋ te ba. Sinsaŋŋa de le piilim ka Jerusalem tɛŋka a ta a cheŋ tɛŋka meena. ");
INSERT INTO bwu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nama dek be nya wieŋa de meena kama ale ni dek nina. ");
INSERT INTO bwu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mi dek le basi ate m kowa ale puulim la a jam ni jigi. Alege, ku a fe kama ayen ni bo tɛŋka de po a limsi ate pagrim nyini wenŋmazuk a jam ni jigi.” ");
INSERT INTO bwu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Wa yaa de ba niŋ ate ba nyini tɛŋka dek po a ta ba cheŋ ga paari Betani tɛŋka, ate wa yaa zak wa nisaŋa a te ba niaka. ");
INSERT INTO bwu_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Wa ale jam boro a te ba niaka la, Naawen yaa deri pa wa a ta jueli wenŋmazuk. ");
INSERT INTO bwu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ba yaa pilim cheŋ Jerusalem ale supeentik nna yegayega ");
INSERT INTO bwu_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","a kasim jam bo Juuma Puusika Yenni po a pak Naawen.");
INSERT INTO bwu_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Piilimka po wenŋmazuk ale tɛŋzuk meena a jam karo, alege Nyuvuri Wanni a poom a liŋ boro kama. Wanni nyiem kasim bo ale ka Naawen diipo meena. Wanni me ale Naawen dek a jam ka bunyi. ");
INSERT INTO bwu_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","A nyini ku piilimka po a ta a cheŋ, Wanni a nyiem kasim jam bo ale ka Naawen diipo meena. ");
INSERT INTO bwu_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Naawen ale basi ate wa nyɛ wenŋmazuk ale tɛŋzuk meena ale ŋanta baai meena ale bo wenŋmazuk ale tɛŋzuk la. Jaab buui meena ka Naawen ale basi ate wa nyɛ. ");
INSERT INTO bwu_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nyuvuri dii ale kan ta kpeglimka la, a bo ka Wanni jigi. Nyuvunni de ale ta bolim a jam tɛŋzuk ayen nuru meena a nya. ");
INSERT INTO bwu_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Wa nyuvuri a nyɛ se ka bolim ate ba tɔati ate bu a nya legi po dii la. Legini an baga a kpimsi bolimu. ");
INSERT INTO bwu_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nuru wanyi ale jam boro ate ba a wi wa ayen Jɔɔn ate Naawen a tom wa. ");
INSERT INTO bwu_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Wa jam kama ayen wa sak nuruba bolimu wie, ate ba nya siuk a wom abe ba ta siaka. ");
INSERT INTO bwu_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Daa Jɔɔn a jam le bolimu, alege ka Naawen ale tom wa ayen wa jam a sak nuruba bolimu wie. ");
INSERT INTO bwu_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Wala a jam le bolim maŋka dek buui ale jam tɛŋka meena po, ayen waai meena a baga a nya siuk a bo bu jigini. ");
INSERT INTO bwu_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nyuvuri Wanni a jam bo ka tɛŋka meena po. Naawen ale basi ate wa nyɛ ka ale jaab buuri meena ale bo ka zuk la, alege tɛŋka meena demma a jam ze wa le ka waai la. ");
INSERT INTO bwu_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Wa jam ka wa dek tɛŋka demma, jigi alege ba zɛri wa. ");
INSERT INTO bwu_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Alege baai ale a tuesi wa ale ta siaka ale wa la, wa te ba ka siuk ate ba chim Naawen bisa. ");
INSERT INTO bwu_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nuruba a nyiem ale kasim a biak ba bisa dii la a kan basi ate ba a chim Naawen bisa. Ku jam daa nuruba dek yaalika nyiŋ ale soa ate wa chim ba ko. Ku jam ka wa dek yaalika nyiŋ ate wa chim ba ko. ");
INSERT INTO bwu_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nyuvuri Wanni a jam chim ka nurubiik ate Naawen a pa wa niaka ale wa wensieŋa a te wa ate wa jam a boro ale ti. Wa nyiini ale wa Kowa Biik. Ate ti nya wa zulaŋa ale wa nalimu ate wa tuesi wa Kowa jigi la. ");
INSERT INTO bwu_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jɔɔn a jam sak nuruba wa wie ale a kaari a weeni ayen, “Mi a weeni ni nuruwa de wie kama. Wa bo ka mi ŋaaŋ a saŋ cheena. Wa liŋ boro kama ale ge ate ba biak mi. Ka dila ale soa ate wa chim kpagi a gaam mi la.” ");
INSERT INTO bwu_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Wa niaka ale zuak la nyiŋ ate wa baga a niak ti meena. Wa abe le kasim a niak ti kama diipo meena. ");
INSERT INTO bwu_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Naawen ale basi ate Moosis a pa wa Sinsaŋŋa a te nuruba alege ka Yeezu nyiŋ ate Naawen a sak ti wa niaka ale wa wensieŋa. ");
INSERT INTO bwu_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nuru waai an diem a nya Naawen ya, alege wa be yeŋka waai ale Naawen ale ka bunyi ale ŋman bo wa jigi la, wala a sak ti wa wie kama. ");
INSERT INTO bwu_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Dai yeŋ po Juuma kpaŋŋa ale jam bo Jerusalem tɛŋka la a yaa tom Juuma Puusika Yenni tomteerɔma ale baai ate ba a wi ba ayen Livaiba la, ba gela ayen ba cheŋ a ga bek Jɔɔn ayen, “Ka fi ale Varibasidɔwa waai ate Naawen a weeni ayen wa le tom wa la?” ");
INSERT INTO bwu_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jɔɔn an jam a zɛri ba tulisika alege weeni ba a lagri ayen, “Daa mi ale Varibasidɔwa.” ");
INSERT INTO bwu_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ba yaa ŋman bek wa ayen, “Fi be ka wana? Fi ka Naawen biisiteerɔwa waai ate ba a wi ayen Elaja la?” Jɔɔn a yaa weeni ayen, “Mi daa wala.” Ba yaa ŋman bek wa ayen, “Ka fi ale Naawen biisiteerɔwa waai ate tama a poli ayen Naawen ale tom wa ti jigi la?” Jɔɔn ŋman weeni ba ayen, “Aawo, daa mi.” ");
INSERT INTO bwu_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ba yaa weeni wa ayen, “Be weeni ti fi ale ka waai la. Kan daa di ate ti ŋman cheŋ baai ale tom ti la jigi, ba a yaali kama ayen ti weeni ba wari. Fi abe ka wana?” ");
INSERT INTO bwu_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jɔɔn a yaa weeni ba ayen, “Naawen biisiteerɔwa waai ate ba a wi ayen Azaya la a jam ŋmarisi Naawen gbaŋka po dila po dila po a weeni ayen Naawen a weeni ayen, ‘Mi ka lueluk kuui ale a kaari sagini po a weeni ayen, teenti Nyɔnɔwa siuku a te wa jam.’ ” ");
INSERT INTO bwu_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Juuma baai ale jam a tom Naawen Puusika Yenni tomteerɔma ale Livaiba Jɔɔn jigi la, a jam ka baai ate ba a wi ba ayen Farisiiba la. ");
INSERT INTO bwu_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Baai ate ba tom la a yaa ŋman bek Jɔɔn ayen, “Kan daa fi ale Varibasidɔwa waai ate Naawen a weeni ayen wa le tom la a yaa se Elaja yaa Naawen biisiteerɔ nwala, ka boa ale soa ate fi a te nuruma soka ale nyiamɔa?” ");
INSERT INTO bwu_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jɔɔn a yaa weeni ba ayen, “Mi a te ka nuruba soka ale nyiam ayen m gomsi ba a magsi ate ba a limsi nuru waai a le cheena la. Wa dek a bo ti sunsuŋ dela kama jinla. Nama dek a ze nuru wala ale ka waai la. ");
INSERT INTO bwu_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Wala a bo ka mi ŋaaŋ a cheena. Mi posima ale m nin domsi a kali wa niŋ a yeeri wa nuensaŋa a te wa.” ");
INSERT INTO bwu_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Wieŋa de meena a nyɛ ka Betani tɛŋka po, Jɔɔn a jam a te nuruma soka ka Jodan benni kuŋkɔŋ ndila. ");
INSERT INTO bwu_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Vari ale veenti la Jɔɔn a yaa nya Yeezu ale wa cheena wa jigi, ate wa yaa weeni baai ale jam mɔata dula jigini la ayen, “Ni nya, nuruwa de a nyɛ ase ka posuk ate Juuma a nyiem a kasim a pa a ko a te Naawen la. Wala ale a basi ate Naawen a voŋ tɛŋka meena demma nyɛ kaasuŋku. ");
INSERT INTO bwu_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ni teeri mi ale weeni wa wie dii ale ni la. Mi a liŋ weeni ni ayen nuru ale bo mi ŋaaŋ a cheena. Wa poom liŋ a boro kama ale ge ate ba biak mi. Ka dila ale soa ate wa chim kpagi a gaam mi la. ");
INSERT INTO bwu_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mi poom a liŋ ze wa le ka waai la, alege mi liŋ de ka wa niŋ a jam dela ayen m te nuruma soka ale nyiam ate m baga a pa wa a sak Izirali demma.” ");
INSERT INTO bwu_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Dula jigini ate Jɔɔn a yaa ŋman weeni ba ayen, “Mi nya Naawen Chiika ale ka nyini wenŋmazuk ase nangbaŋ la a siŋ a jam kali Yeezu zuk. ");
INSERT INTO bwu_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mi a jam ze wa le ka waai la, alege Naawen waai ale tom mi ayen m jam a te nuruba soka la a liŋ a weeni mi kama ayen, waai ate nama a nya ale Naawen Chiika a jam a wari wa zuk la, wala a le wa sueri ni suniimaŋa ale Naawen Chiika. ");
INSERT INTO bwu_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mi nya wieŋa de meena kama. Wensie ate mi a weeni ni ayen wa sum ka Naawen Biik.” ");
INSERT INTO bwu_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Vari ale ŋman a veenti la, Jɔɔn ale wa ŋaaŋviirima baye a yaa ŋman jam bo dula jigini, ");
INSERT INTO bwu_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ate Jɔɔn a yaa nya Yeezu ale wa cheŋ a taamu. Jɔɔn a yaa weeni ba ayen, “Ni nya nuruwa de, wa a nyɛ ase ka Naawen Posuk la.” ");
INSERT INTO bwu_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Wa ŋaaŋviirima bayewa ale wom dii ate wa weeni la, ba yaa deri basi wa ale cheŋ ga va Yeezu. ");
INSERT INTO bwu_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ba le jam a vi Yeezu ŋaaŋ la, wa yaa chiem a nya ba ale ba va wa ŋaaŋ la ate wa yaa bek ba ayen, “Ka wana ate nama a gisi?” Ba yaa weeni wa ayen, “Arabi, fi yenni bo ka be?” (Arabi kiri ale Sagrɔ.) ");
INSERT INTO bwu_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Wa yaa weeni ba ayen, “Ni va mu a jam nya.” Ba yaa va wa a ga nya wa le bo juijui la. Ba jam a ga paari wa boka jigini ale wenni a gbeliŋ kama ate ba yaa jam bo dula ate tɛŋka a ga sobri. ");
INSERT INTO bwu_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nuruma bayewa wanyi a jam ka Andiru, Simon Piita suok. ");
INSERT INTO bwu_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andiru ale jam a ŋman kuli yeri la, wa yaa deri a cheŋ Simon jigi a ga weeni wa ayen, “Tama jinla a nya Kirisitawa waai ale Varibasidɔwa ate Naawen a weeni ayen wa le tom wa ate wa jam la kama.” ");
INSERT INTO bwu_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Wa yaa ta Simon a cheŋ Yeezu jigi. Yeezu a yaa nya wa a weeni ayen, “Fi le Simon, Jɔɔn biika la. Mi a yaali ayen m te fu ka yue paali ayen Sifas dii ate nuruba ayen ba a wi fu la.” (Yue dila ale Piita ka bunyi, di kiri ale puŋ.) ");
INSERT INTO bwu_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Vari ale ŋman veenti la Yeezu a yaa cheŋ Galili. Wa yaa nya nuru wanyi ate ba a wi wa ayen Filip. Wa yaa weeni wa ayen, “Jam va mu.” ");
INSERT INTO bwu_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip a jam nyini ka tɛŋ kanyi ate ba a wi ayen Beteseida. Andiru ale Piita me a jam nyini ka dula. ");
INSERT INTO bwu_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip me a yaa cheŋ ayen wa nya nuru wanyi ate ba a wi wa ayen Natani. Wa le ga nya wa la, wa yaa weeni wa ayen, “Moosis ale Naawen biisiteerɔma a jam ŋmarisi Naawen gbaŋka po dila po dila po ayen Varibasidɔwa ate Naawen a jam weeni ayen wa le tom wa ate wa jam la, tama a nya wa kama. Wa ka Yeezu, Josefi biika, waai ale nyini Nazaret la.” ");
INSERT INTO bwu_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natani a yaa bek Filip ayen, “Ti baga a nya maaka Nazaret tɛŋka po?” Filip a yaa ŋman weeni wa ayen, “Jam a nya.” ");
INSERT INTO bwu_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ba le jam a ga mɔata Yeezu la, wa yaa weeni baai ale jam bo ale wa la, ayen, “Ni nya Izirali denowa de waai ale cheena mi jigi la, wa ka wensie nyɔnɔ.” ");
INSERT INTO bwu_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natani a yaa ga paari Yeezu a bek wa ayen, “Fi nyɛ ka se a seba mi?” Yeezu yaa weeni wa ayen, “Fi ale poom kala kiŋkaŋka tɛŋ la, mi nya fu kama ale ge ate Filip a wi fu.” ");
INSERT INTO bwu_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natani ale wom dii ate Yeezu a weeni la, wa yaa weeni wa ayen, “M Sagrɔ, fi sum ka Naawen biik. Fi ale Izirali Naawa.” ");
INSERT INTO bwu_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yeezu a yaa weeni wa ayen, “Fi ta siaka ale mi kama mi ale weeni ayen m nya ale fi kali kiŋkaŋka tɛŋ la? Fi ale nya wakperikaliisa a gaam nyaku de.” ");
INSERT INTO bwu_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Dula jigini Yeezu a yaa cheemu a weeni baai ale jam za la ayen, “Wensie ate mi a weeni ni ayen ni le nya wenzuk ale ku lagri ate Naawen sabiiloma a nyini wenŋmazuk nna ase ba a siŋ Saalobiika zuk la ale ŋman pilim a jueli.” ");
INSERT INTO bwu_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Daa ŋaye ale jam taam la, nuru wanyi a yaa faari nipɔk tɛŋ kaai ate ba a wi ayen Kena ate ka bo Galili la po. Yeezu mawa a jam boro kama. ");
INSERT INTO bwu_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ba yaa jam wi Yeezu ale wa ŋaaŋviirima ayen ba jam nipɔkfiaka yenni. ");
INSERT INTO bwu_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nipɔkfiaka nyɔnɔwa a jam te nuru baai ale jam la ka daam. Daamu yaa le nueri la, Yeezu mawa a yaa ga weeni wa ayen daamu a nueri kama. ");
INSERT INTO bwu_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yeezu a yaa weeni wa ayen, “Kan weeni mu dii ate mi ayen m nyɛ la, dii nyiŋ la diipo ate mi a yaali ayen m nyɛ wari la an diem a paari ya.” ");
INSERT INTO bwu_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Wa mawa ale wom wieŋa de la, wa yaa cheemu a weeni yenni tomteerɔma ayen, “Wa dan weeni ayen ni nyɛ wari, ni nyɛ.” ");
INSERT INTO bwu_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Samɔniŋ kpeensa siyuebi ale jam bo yenni po. Samɔniŋ kanyi a jam a su ase ka bogtiba naaniŋ nyiam la. Juuma a nyiem a dan boro a gomsi ayen ba de ŋandiinta, ba a ŋari nyiam a nyo samɔnsaŋa de po a sugri ba dek. ");
INSERT INTO bwu_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yeezu a yaa weeni yenni tomteerɔma ayen, “Ni ŋari nyiam a sueri samɔnsaŋa.” Ba yaa ŋari a sueri, ");
INSERT INTO bwu_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","wa yaa weeni ba ayen, “Ni ŋari bu a ta ga te waai ale ka kpagini a nya nichamma zuk la.” Ba yaa ŋari nyiamu a ta ga te wa. ");
INSERT INTO bwu_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kpagini ale lam nya buui ale tagri a chim daamu a nya la, wa yaa ze bu le nyini ka juijui la, alege ka yenni tomteerɔma baai ale ŋari a ta ga te wa la, nyiini ale seba bu le nyini juijui la. Kpagini a yaa wi nipɔk fiaka nyɔnɔwa a weeni wa ayen, ");
INSERT INTO bwu_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Nuruba a dan wi ba dɔaba ayen ba jam ate ba de ŋandiinta, ba nyiem a liŋ a pa ka da masik a te ba ate ba nyu. Ba yaa dan nyu da masika a chak, yenni tomteerɔma a nyiem a yaa pa ka da buui ale kan masa la a ŋman ta nyini a gum du ayen ba nyu. Alege fi tomteerɔma a pa ka da masika a ta wari ŋaaŋ a jam.” ");
INSERT INTO bwu_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yeezu a piilim tom ka wakperikaliika de Kena tɛŋka ate ka bo Galili po la. Wakperikaliika de a jam sak ka wa ŋaaŋviirima ayen Naawen pagrimu a bo wa jigi kama. Dila nyiŋ ate ba yaa a jam ta siaka ale wa. ");
INSERT INTO bwu_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nipɔk fiaka diintaŋa ale jam a taam la, Yeezu ale wa mawa ale wa yuama ale wa ŋaaŋviirima a yaa basi dula jigini ale ge cheŋ tɛŋ kanyi ate ba a wi ayen Kapernaum a yaa bo dula daa maga. ");
INSERT INTO bwu_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juuma Gaambasika Tigini a jam mɔata kama ate Yeezu ale wa ŋaaŋviirima a yaa cheŋ Jerusalem tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ba yaa ga jo Juuma Puusika Yenni po. Dula jigini wa yaa nya nuruba yegayega ate ba boro a ta niiga ale piisa ale nangbaŋsa a da. Baai me ale jam ta ligra a tagri la a kala dula jigini. ");
INSERT INTO bwu_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yeezu a yaa yaali miisa a melim chaab ase fiŋ la a yiak niiga ale piisaŋa ale duŋsa si chaab a ta nyini. Wa ŋman yik baai ale ta ligra a tagri la teebulitaŋa a tulim kpib ate ba ligraŋa meena a waaŋ tɛŋ. ");
INSERT INTO bwu_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Wa le nyɛ dila a nueri la, wa yaa weeni baai ale ta nangbaŋsaŋa a da la ayen, “Ni pa ŋantaŋa de meena dela a ta nyini. Ka boa ate nama a nyɛ wieŋa de meena ale pa m kowa yenni a chim yaba?” ");
INSERT INTO bwu_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Wa ŋaaŋviirima ale wom dii ate wa jam a biisi la, ba yaa teeri dii ate ba jam ŋmarisi Naawen gbaŋka po dila po dila po a weeni ayen, “Mi ale a yaali Naawen yenni dii la a le ku nyɛ ate mi kpi.” ");
INSERT INTO bwu_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Juuma kpaŋŋa a yaa jam bek Yeezu ayen, “Ka wana dek ale te fi siuk ayen fi nyiem a tom tuimaŋa de meena? Be tom wakperikaliik ate ku sak ti ayen fi ta siuk a tom dila.” ");
INSERT INTO bwu_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yeezu a yaa weeni ba ayen, “Ni be nak Juuma Puusika Yenni de a lonsi tɛŋ ate mi a ŋman se di a nueri daa ŋata po.” ");
INSERT INTO bwu_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ba yaa weeni wa ayen, “Tama nuruma a pa ka bena pisinaansi ale ŋayuebi a se di. Tama a be dan nak di a lonsi, fi ale baga a pa daa ŋata a ŋman se di a nueri?” ");
INSERT INTO bwu_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Alege Yeezu an jam biisi a magsi chaab ale ka Juuma Puusika Yenni dii ale bo Jerusalem tɛŋka po la. Wa jam biisi a magsi chaab ale ka wa dek nyiŋka. ");
INSERT INTO bwu_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yeezu ale jam a kpi ate Naawen a basi ate wa yiti kum po la, wa ŋaaŋviirima a yaa jam teeri dii ate wa weeni la. Ba yaa jam ta siaka ale Yeezu ale weeni ba dii la, ale ba le ŋmarisi wa wie Naawen gbaŋka po dii la ka wensie. ");
INSERT INTO bwu_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yeezu ale jam boro a de Juuma Gaambasika Tigini Jerusalem tɛŋka po la, nuruba yegayega a jam nya wa wakperikaliik sii ate wa jam a tom la, a yaa ta siaka ale wa. ");
INSERT INTO bwu_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Alege Yeezu an jam a pa wa dek a te ba, dii nyiŋ la wa jam seba ba le ka nuru baai la ka meena. ");
INSERT INTO bwu_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Wa an jam a yaali ayen waai a sak wa ba le ka nuru baai la dii nyiŋ la wa seba ba popolaŋa kama. ");
INSERT INTO bwu_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nuru wanyi ale jam boro ate ba a wi wa ayen Nikodimusi. Wa jam ka Juuma kpaŋŋa po wanyi ale Farisiima po me wanyi. ");
INSERT INTO bwu_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Yok kunyi po ate nuruwa de a yaa cheŋ Yeezu jigi a ga weeni wa ayen, “M Sagrɔ, tama seba fi ka sagrɔ waai ate Naawen a tom fu. Nuru an baga a tom tuimkperikaliik sii ate fi a tom la ka Naawen a nin bo ale wa.” ");
INSERT INTO bwu_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yeezu a yaa weeni wa ayen, “Wensie ate mi a weeni fu ayen nuru an baga a jo Naawen naamu po, ka ba nin pilim biak wa.” ");
INSERT INTO bwu_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimusi a yaa bek wa ayen, “Ba ale nyɛ ka se a pilim biak nuru waai ale chim ya? Wa an ŋman baga a jo wa mawa ponni po ate ba a biak wa buye.” ");
INSERT INTO bwu_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yeezu a yaa weeni wa ayen, “Wensie ate mi a weeni fu ayen nuru an baga a jo Naawen naamu po, ka ba nin biak wa ale nyiam ale pilim biak wa ale Naawen Chiika. ");
INSERT INTO bwu_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nurubisa a biak bisa kama alege Naawen Chiika a te ka nyuvuri dii ale kan ta kpeglimka la. ");
INSERT INTO bwu_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kan te ku cha fu dii nyiŋ la mi ale a weeni ayen se ba nin pilim biak fu la. ");
INSERT INTO bwu_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Vioku a fuk a cheŋ ka juijui meena ate ku a yaali la, ate fi me a wom ku fukka, alege fi ze ku le nyini juijui la yaase ku ale a cheŋ juijui la. Ku abe ka dila ale waai meena ate Naawen Chiika a biak la.” ");
INSERT INTO bwu_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimusi a yaa bek wa ayen, “Nyaku de ale nyɛ ka se a baga a nyɛ?” ");
INSERT INTO bwu_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yeezu a yaa weeni wa ayen, “Fi ka sagrɔ kpioŋ a bo Izirali tɛŋka alege an baga a miŋ mi ale weeni fu dii la kiri ya? ");
INSERT INTO bwu_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Wensie ate mi a weeni fu ayen ti a biisi ka wie ŋaai ate ti seba ŋa, la ale a weeni wie ŋaai ate ti nya ŋa la a sak alege ni waai a kan siagi. ");
INSERT INTO bwu_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ni ka siaka ale mi ase m nin weeni tɛŋka de zuk wie, ni abe ni nyɛ ka se a ta siaka ale mi ase m nin weeni wenŋmazuk wie. ");
INSERT INTO bwu_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nuru karo a jueli wenŋmazuwa ka Mi Saalobiika ale nyini wenŋmazuk a jam tɛŋzuk de. ");
INSERT INTO bwu_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Ase Moosis ale jam pai kutuku a nyɛ waamu a magim dua woŋku nyiŋ a zak zaani sagini po la, dila dek ate ba le yik mi Saalobiika a kpi jabarimu nyiŋ a zak zaani. ");
INSERT INTO bwu_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ate waai meena ale a ta siaka ale mi la ale nya nyuvuri dii ale kan ta kpeglimka. ");
INSERT INTO bwu_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Naawen a yaali tɛŋka meena demma ka nna yegayega ate wa tom wa be yeŋka ba jigi, ate baai ale ta siaka ale wa la a kan kpi alege ba le nya nyuvuri dii ale kan ta kpeglimka la. ");
INSERT INTO bwu_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Naawen an tom wa biika ayen wa jam chim ka tɛŋzuk meena demma buteerɔ, alege wa jam chim ka ba varibasidɔ. ");
INSERT INTO bwu_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Baai ale ta siaka ale Naawen biika la, Naawen a kan bu ba buusa. Baai ale kan ta siaka ale wa biika la, Naawen a poom bu ba buusa kama, dii nyiŋ la ba an ta siaka ale wa be yeŋka. ");
INSERT INTO bwu_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Naawen ale a poli ba jigi dii la ale nna. Wa biika a nyɛ se ka bolim ate wa tom ate wa jam tɛŋzuk meena la. Nuruba yegayega a lueri ka legini po boka alege a kan yaali ayen ba bo bolimu ale a nya juijui la, dii nyiŋ la ba a tom ka wabaata. ");
INSERT INTO bwu_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ba seba ayen ba dan bo bolimu nyaka jigini a tom ba wabaataŋa, waai meena a le nya dii ate ba a nyɛ la kama. Ka dila ale soa ate ba kan yaali ayen ba mɔata bolimu jigini. ");
INSERT INTO bwu_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Alege baai ale a tom dii ale ka wensie la, bala a kan chali bolimu jigini boka. Ba a tomu ba tuimaŋa ate ŋa a sak kama ayen ba a tom ka dii ate Naawen a yaali la.” ");
INSERT INTO bwu_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ku de ŋaaŋ nyiŋ, Yeezu ale wa ŋaaŋviirima a yaa basi dula jigini ale ge cheŋ tɛŋ kanyi ate ka bo Judia. Ba ale wa a yaa jam bo dula daa maga dega a te nuruba soka ale nyiam. ");
INSERT INTO bwu_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jɔɔn me a jam a te nuruba soka ale nyiam tɛŋ kanyi po ate ba a wi ayen Enon, ka an yalima ale Salim tɛŋka, dii nyiŋ la nyiamu a jam zuak kama dula jigini. Nuruba a yaa jam a cheŋ wa jigi ate wa a te ba soka ale nyiam. ");
INSERT INTO bwu_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ku de ŋaaŋ nyiŋ ale ba yik Jɔɔn a ligi la. ");
INSERT INTO bwu_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Dai yeŋ po ate Juuma po ba wanyi a yaa jam Jɔɔn ŋaaŋviirima jigi a ta nampaga ale ba soka teka nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ba yaa jam Jɔɔn jigi a weeni wa ayen, “Ti Sagrɔ, fi baga a teeri nuru waai ale poom a bo ale ti Jodan benni kauk kuŋkula ale dii ate fi poom a weeni wa wie a sak ti la? Yɔgyɔgla de wa yaa te ka nuruba soka ale nyiam ate waai meena a cheŋ wa jigi.” ");
INSERT INTO bwu_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jɔɔn a yaa weeni ba ayen, “Nuru an baga a lueri wari wa dega, ka Naawen a nin te wa. ");
INSERT INTO bwu_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nama teeri ayen mi a poom weeni ni ayen daa mi ale Varibasidɔwa waai ate Naawen a weeni ayen wa le tom la. Naawen a tom mi ate mi de ka wa niŋ a jam ayen m gomsi wa siuku a magsi a te wa. ");
INSERT INTO bwu_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nuru waai a dan faari nipɔk, ka wala dek ale soa wa. Mi a nyɛ ase ka nipɔk fiaka nyɔnɔwa doa la. Mi sui a peenti kama ayen mi a mɔata wa ale a wom wa lueluku. Nuruma a dan a basi mi ale ge a cheŋ Yeezu jigi ayen wa te ba soka ale nyiam, kula a peenti mi sui ka nna yegayega a gaam ku le poom ka dii la. ");
INSERT INTO bwu_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ku magsi kama ayen wala a jueli ŋmai abe mi a bo tɛŋ.” ");
INSERT INTO bwu_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Waai ale nyini wenŋmazuk la a gaam waai meena kama. Waai ale nyini tɛŋzuk de la, ka tɛŋzuk de nuru ale a biisi tɛŋzuk de wie, alege waai ale nyini wenŋmazuk la a gaam waai meena kama. ");
INSERT INTO bwu_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Wa a weeni ka wie ŋaai ate wa nya ale wom la alege waai a ka siaka ale ŋa. ");
INSERT INTO bwu_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Alege waai ale ta siaka ale wa wieŋa la a sak kama ayen Naawen ka wensie nyɔnɔ. ");
INSERT INTO bwu_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Waai ate Naawen tom la a biisi ka Naawen wieŋa, dii nyiŋ la Naawen a basi ate wa Chiika a bo ale wa kama. ");
INSERT INTO bwu_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Naawen a yaali wa biika kama ate wa pai jaab buuri meena pagrim a te wa. ");
INSERT INTO bwu_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Baai meena ale ta siaka ale wa biika la a nya nyuvuri dii ale kan ta kpeglimka la kama. Baai meena me ale kan ta siaka ale wa ale kan va wa noai la, a kan nya nyuvuri dila, alege Naawen ale waali ba. ");
INSERT INTO bwu_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Farisiima a yaa jam wom ayen nuruba yegayega a jam va Yeezu ŋaaŋ ale a basi ate wa a te ba soka ale nyiam a gaam Jɔɔn. Daa Yeezu dek ale jam a te nuruma soka, alege ka wa ŋaaŋviirima. ");
INSERT INTO bwu_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yeezu ale jam a miŋ ayen Farisiima a wom kama la, wa ale wa ŋaaŋviirima a yaa basi Judia ale ŋmani a cheŋ Galili. ");
INSERT INTO bwu_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yeezu a yaa poli ayen ba le va ka siuk kuui ale a va Samaria la a cheŋ Galili. ");
INSERT INTO bwu_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ba yaa jam paari Samaria tɛŋ kanyi ate ba a wi ayen Saika. Saika ale talim buui ate Juuma kokpieŋka Jekob a pa te wa biika Josefi dila po dila po la an jam yalima ale chaaba. ");
INSERT INTO bwu_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Vili dii ate Jekob a jam tu la a bo ka dula jigini. Yeezu ale jiak la wa yaa kali vilini tɛŋ a vuusi. Wenbinni a jam jueli ka wenzuk sunsuŋ. ");
INSERT INTO bwu_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Wa ŋaaŋviirima a yaa basi wa ale ge cheŋ tɛŋka po ayen ba da ŋandiinta a ta jam. Yeezu ale diem kala a vuusi la, Samaria nipɔk wanyi a yaa jam ayen wa ŋari nyiam vilini po. Yeezu a yaa weeni wa ayen wa nyɛ nyiamu a te wa ate wa nyu. ");
INSERT INTO bwu_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nipowa a yaa weeni wa ayen, “Fi ka Juu alege mi a chim Samaria tɛŋka nipɔk. Ka boa ale soa ate fi a juisi nyiam mi jigi ya?” (Juuma a kan pai tama beerisa a nyu nyiamɔa, ba abe kan de tama china po.) ");
INSERT INTO bwu_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yeezu a yaa weeni wa ayen, “Ase fi dan seba Naawen tiirimu kama ale waai ale a juisi nyiamu fi jigi la, fi ate le juisi nyiam wa jigi ate wa te fu nya buui ale a te nyuvuri la.” ");
INSERT INTO bwu_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nipowa yaa weeni wa ayen, “M Nyɔnɔ, fi ka jaŋarimɔa alege vilini me a limsa. Fi ayen fi nya, nya bula ka be a te mi? ");
INSERT INTO bwu_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tama kokpieŋka, Jekob, ale tu vilini de dila po dila po, ayen wa ale wa dɔk demma ale wa duŋsaŋa a nya nyiam a nyu di po. Fi a be zuak a gaam ti kokpieŋka Jekob kama?” ");
INSERT INTO bwu_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yeezu a yaa weeni wa ayen, “Baai meena ale a nyu nyiam vilini de po la, nyanyuila ale ŋman a yik ba. ");
INSERT INTO bwu_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Baai meena ale a nyu nya buui ate mi a te ba la, nyanyuila a kan ŋman yik ba diipo diipo. Mi ale m te nya buui la ale kasim a buli kama a te ba nyuvuri dii ale kan ta kpeglimka la.” ");
INSERT INTO bwu_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nipowa a yaa le ga wom dii ate Yeezu a weeni la, wa yaa weeni wa ayen, “M nyɔnɔ, be te mu fi nyiamu de ate nyanyuila a kan ŋman yik mu ate m ŋman jam dela a ŋari nyiamɔa.” ");
INSERT INTO bwu_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yeezu a yaa weeni wa ayen, “Cheŋ a ga wi fi chorowa ate ni jam.” ");
INSERT INTO bwu_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Wa yaa weeni wa ayen, “Mi ka chora.” Yeezu a yaa weeni wa ayen, “Fi ale weeni dii la ka wensie. ");
INSERT INTO bwu_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Fi yali nidɔaba a paari ka ku noai bunu nidɔa waai ate fi boro ale wa jinla la wala ka fi nɔŋ. Fi ale weeni mu dii la ka wensie.” ");
INSERT INTO bwu_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nipowa a yaa weeni wa ayen, “M nyɔnɔ, fi ale a biisi dii la a basi kama ate m miŋ ayen fi ka Naawen biisiteerɔma po wanyi. ");
INSERT INTO bwu_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nya guuk kpioŋku de kuui ale za dela la. Ti kokpieŋsaŋa a puusi a te Naawen ka kula zuk alege nama Juuma a weeni ti ayen ka Jerusalem tɛŋka ale Naawen puusi teka jigi.” ");
INSERT INTO bwu_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yeezu a yaa weeni wa ayen, “Ku danni a cheena ate nuruba a kan ŋman puusi a te Naawen guuku de zuk yaase Jerusalem tɛŋka po. ");
INSERT INTO bwu_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nama Samaria demma, ni sum ze waai dek ate ni puusi a te la. Tama Juuma a seba waai dek ate ti puusi a te la kama. Dii nyiŋ la, wala ale basi ate Juuma po wanyi a vari tɛŋka meena demma ba tuimbaataŋa po a basi. ");
INSERT INTO bwu_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ku danni a cheena kama ate baai ale a puusi a te Naawen ale wensie la a jam puusi dila, dii nyiŋ la wa Chiika a bo ka ba suniimaŋa po. Ti Kowa Naawen ale a yaali ayen nuruba a puusi a te wa dii la ale la. ");
INSERT INTO bwu_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Naawen ka Chiik, ka dila ale soa ate nuruba an baga a puusi a te wa, ase ka kula nyɔnɔwa a nin liŋ ta wa Chiika wa sunum po ate ka maari wa.” ");
INSERT INTO bwu_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nipowa a yaa weeni wa ayen, “M seba ayen Varibasidɔwa waai ate Naawen a weeni ayen wa le tom wa la a le jam. Wa dan jam, wa le sak ti wie meena.” ");
INSERT INTO bwu_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yeezu a yaa weeni wa ayen, “Mi ka wala waai ale a biisi ale fu la.” ");
INSERT INTO bwu_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Wa le a diem boro a biisi la, wa ŋaaŋviirima a yaa deri ŋman jam. Ba le nya Yeezu ale nipowa a za a biisi la, ku yaa deri cha ba nna yegayega, alege ba waai an jam a begi wa ayen ka boa ate wa a biisi ale wa yaa se jaab buui wari ate ba a biisi la. ");
INSERT INTO bwu_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Dula jigini nipowa a yaa basi wa nyiamu liika ale ŋmani a cheŋ tɛŋka po a ga weeni nuruma ale bo dula jigini la ayen, ");
INSERT INTO bwu_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ni jam a nya nuru ale weeni mi wie ŋaai ate mi nyɛ la. Wala ale baga a chim Varibasidɔwa waai ate Naawen a weeni ayen wa le tom wa la?” ");
INSERT INTO bwu_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ba le wom dii ate wa weeni la, ba yaa deri nyini a cheŋ Yeezu jigi. ");
INSERT INTO bwu_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ase nipowa ale jam bo siuku po a kuli la, Yeezu ŋaaŋviirima a yaa saalim wa ayen, “Ti Sagrɔ, ti a saalim fu ayen fi ŋɔa ŋandiintaŋa a de.” ");
INSERT INTO bwu_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Wa yaa weeni ba ayen, “Nama a ze ŋandiin tii ate mi a tara ayen m de la.” ");
INSERT INTO bwu_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Wa ŋaaŋviirima a yaa bek chaab ayen, “Ka nuru yaa be le ta ŋandiinta a jam a te wa ale ge tama a ze ya?” ");
INSERT INTO bwu_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yeezu a yaa weeni ba ayen, “Mi dan va Naawen waai ale tom mu la yaalika ale a tom tuimaŋa ŋaai ate wa pa te mu la a nueri, kula a nyɛ a se ka ŋandiintaŋa tii ate m nyiem a kasim a de la. ");
INSERT INTO bwu_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Juuma kpaŋŋa a nyiem a kasim a weeni ayen ku dan paari chiisa sinaansi po, ti le che ti ŋantaŋa, alege mi a weeni ni kama ayen, ni dek a pa ni nina a nya kadugsaŋa. Ŋantaŋa a za magsi ka cheka yɔgyɔgla de. ");
INSERT INTO bwu_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nuru waai ale a che ŋantaŋa la a tuesi tutuna kama. Wa ale a tigsi ŋanbeeŋa la a nyɛ ase ka nuruba la, ate nuru bala a nya nyuvuri dii ale kan ta kpeglimka la. Dila nyiŋ boridowa ale cheerowa sue ale peenti ale chaab.” ");
INSERT INTO bwu_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Yeezu a yaa ŋman weeni wa ŋaaŋviirima ayen, “Juuma kpaŋŋa a nyiem ale kasim a weeni dii ayen nuru wanyi ale a bori ate wanyi me a che la, ka wensie. ");
INSERT INTO bwu_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ku a nyɛ ase ka mi ale tom ni ayen ni cheŋ a ga che ŋanta Naawen kaduka po. Nuru yonta ale bori ba ale cheŋ ale ge ate nama ayen ni nya ba tuimaŋa nyuenta.” ");
INSERT INTO bwu_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria tɛŋka nipowa ale ga weeni wa tɛŋka demma ayen ba jam a nya nuru waai ale weeni wie ŋaai meena ate wa nyɛ la, ba yegayega a yaa jam ta siaka ale Yeezu. ");
INSERT INTO bwu_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ba yaa jam wa jigi a saalim wa ayen wa jam a bo ale ba. Yeezu a yaa siak a wari ba jigi daa ŋaye. ");
INSERT INTO bwu_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Wa le jam bo ale ba la, wa yaa sak ba Naawen wie ate ba yegayega a ta siaka ale wa a gum baai ale poom a ta siaka la po. ");
INSERT INTO bwu_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ba yaa weeni nipowa ayen, “Tama an ta siaka ale wa ka fi ale weeni ti dii la nyiini nyiŋŋa, alege ka wa sakka nyiŋ ale soa ate ti ta siaka ale wa. Ti seba ayen ka Naawen ale sum a tom wa ayen wa jam a vari tɛŋzuk meena demma ba tuimbaata po a basi.” ");
INSERT INTO bwu_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Daa magla ale jam taam la, Yeezu a yaa basi dula jigini ale ge cheŋ Galili. ");
INSERT INTO bwu_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Wa dek a poom weeni kama ayen Naawen biisiteerɔ dek tɛŋka demma a kan te wa zula. ");
INSERT INTO bwu_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ba ale paari Galili la nuruma a jam te wa tia kama dii nyiŋ la ba cheŋ ga de Gaambasika Tigini Jerusalem kama ale nya wie ŋaai meena ate wa tom la. ");
INSERT INTO bwu_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yeezu a yaa ŋman cheŋ Kena tɛŋka ate ka bo Galili la. Ka dula jigini ate wa nyɛ ate nyiamu a tagri a chim daamu la. Kpagi dinyi a yaa jam bo dula jigini ate wa biik a yaa bo Kapernaum tɛŋka po a wiak. ");
INSERT INTO bwu_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Wa le wom ayen Yeezu a basi Judia ale ŋman jam Galili la, wa yaa jam Yeezu jigi ayen wa saalim wa ate ba va chaab a cheŋ Kapernaum tɛŋka ate wa tebi wa biika waai ale mɔata kum la. ");
INSERT INTO bwu_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yeezu a yaa weeni wa ayen, “Nuruba a kan ta siaka ale mi a se ka mi a liŋ tom wakperikaliisa ate ba nya.” ");
INSERT INTO bwu_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kpagini a yaa weeni wa ayen, “M Nyɔnɔ, fi dan kan va mu a kuli nwuli, m biika a le kpi.” ");
INSERT INTO bwu_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yeezu a yaa weeni wa ayen, “Kuli yeri a ga nya fi biika ale wa ta nyiŋyɔgsa kama.” Kpagini a yaa deri siak ale Yeezu ale weeni dii la a yaa le ge a kuli. ");
INSERT INTO bwu_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Wa le jam bo siuku po a kuli la, wa tomteerɔma ba gela a yaa tu wa siuku niŋ a weeni wa ayen, “Fi biika a ta nyiŋyɔgsa kama.” ");
INSERT INTO bwu_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Wa yaa bek ba ayen, “Ka dimpo ate wa nya nyiŋyɔgsaŋa?” Ba yaa weeni wa ayen, “Ka deemwa wein gbelini ate wa yuamu a basi wa.” ");
INSERT INTO bwu_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Biika kowa a yaa deri teeri ayen ka diipo ate Yeezu a weeni wa ayen wa biika a nya nyiŋyɔgsa kama la. Wa yaa ga paari yeri a nya ale dii ate wa tomteerɔma a weeni wa la sum ka wensie. Wa le wa dɔkdemma meena a yaa ta siaka ale Yeezu dii ate wa nyɛ la nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yeezu ale nyini Judia a jam Galili la wa tebi kpagini biika a gum wa wakperikaliisaŋa po a nyɛ ka buye. ");
INSERT INTO bwu_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Daa magla ale jam a taam la, Yeezu a yaa ŋman cheŋ Jerusalem tɛŋka ayen wa maa de Juuma tigi dinyi. ");
INSERT INTO bwu_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Beli fiik ale jam bo dula a mɔata tɛŋka nansuiŋtaŋa kunyi ate ba a wi ayen piisa nansiuŋ. Juuma a wi dula jigini ale ba dek tɛŋka biika ayen ka Betezata. Kusuŋta tinu ale jam gilim benni nɔanni. ");
INSERT INTO bwu_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Yuariba yegayega ale jam dua kusuŋ tila po. Ba gela a jam ka yeeba, ba gela me a chim gbanisa, ba gela me naŋsa ale ba nisima a kpi a yaa dua a limsi nyiamu choaka. ");
INSERT INTO bwu_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Naawen sabiilo a nyiem ale jam a siŋ nyiam po a puŋ. Wa dan puŋ jueli waai ale de niŋ a siŋ nyiamu po la a nya nyiŋyɔgsa kama. ");
INSERT INTO bwu_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nuru wanyi a yaa maa boro ate yuamu a ta wa paari bena pisita ale naaniŋ. ");
INSERT INTO bwu_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yeezu a yaa nya wa ale wa dua, wa yaa deri seba ayen tuemu a yik wa ate ku beni kama ate wa yaa bek wa ayen, “Fi a yaali ayen fi nya nyiŋyɔgsa?” ");
INSERT INTO bwu_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yuarowa a yaa weeni wa ayen, “M nyɔnɔ, nyiamu a nyiem a dan choa, m ka nuru ate wa pa mu a ta ga a nyo bu po nwuli. M nyiem a dan pii nyiŋ a yaali ayen m forisi a paari bu, nuru yoŋ a nyiem ale a de niŋ a paari du ale a ge mu.” ");
INSERT INTO bwu_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yeezu yaa weeni wa ayen, “Yiti a zaani abe fi kpamsi fi tiaka a cheŋ.” ");
INSERT INTO bwu_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nuruwa a yaa deri nya nyiŋyɔgsa a yiti zaani ale kpamsi wa tiaka a cheŋ. Dai dii danni ate nyaku de a nyɛ la a jam ka Juuma Vuusum Dai. ");
INSERT INTO bwu_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Juuma kpaŋŋa ba gela a yaa nya Yeezu ale tebi nuruwa dii la a yaa weeni wa ayen, “Ku a kisi kama ate fi ji fi tiaka tama Vuusum Danni po.” ");
INSERT INTO bwu_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wa yaa weeni ba ayen, “Nuru waai ale tebi mu la ale weeni mu ayen m pai tiaka a cheŋ.” ");
INSERT INTO bwu_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ba yaa bek wa ayen, “Ka wana ale weeni fu ayen fi nyɛ ku de?” ");
INSERT INTO bwu_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nuru waai ale nya nyiŋyɔgsaŋa la a jam ze Yeezu ale ka waai la, dii nyiŋ la nuru bɔari ale jam bo dula ate Yeezu a moali nyini. ");
INSERT INTO bwu_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ku ŋaaŋ nyiŋ Yeezu a yaa ŋman nya wa Juuma Puusika Yenni po a weeni wa ayen, “Yɔgyɔgla de fi yaa ta nyiŋyɔgsa kama. Be kan ŋman a tom tuimbaata. Fi dan ŋman tom tuimbaata, fi le nam a gaam ku le jam ka dii la.” ");
INSERT INTO bwu_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yeezu ale ga weeni wa nyaku de a nueri la, nuruwa a yaa deri nyini a cheŋ a ga weeni Juuma kpaŋŋa ayen ka Yeezu ale tebi wa. ");
INSERT INTO bwu_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ba le ga wom ayen ka Yeezu ale jam tebi nuruwa ba Vuusum Danni la, ba yaa deri a daani Yeezu nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yeezu a yaa weeni ba ayen, “M Kowa Naawen a kasim a tom wa tuimaŋa kama diipo meena. Mi me a tom ase ka wala la.” ");
INSERT INTO bwu_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yeezu ale ga weeni ayen ka Naawen ale wa Kowa la, ku jam a nyɛ ase wa ale wa ka bunyi la. Wa wieŋa de meena ale wa le kaasi ba Vuusum Danni dii la a jam basi kama ate ba nina a jam muni ate ba a yaali ayen ba ko wa. ");
INSERT INTO bwu_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Dula jigini Yeezu a yaa weeni ba ayen, “Wensie ate mi a weeni ni ayen mi waai ale ka Naawen biik la an baga a nyɛ mi dek nyiŋ wari ya. Dii meena ate m Kowa a tom la, mi me a tom ka dila degadega. ");
INSERT INTO bwu_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Wa a yaali mu ale a sak mu dii meena ate wa dek a tom la. M Kowa Naawen ale sak mu wa kpeema ate m tom ate ŋa zuak a gaam nyaku de ate ku cha ni. ");
INSERT INTO bwu_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ase wa ale basi ate kpeeba a yiti kum po la. Mi waai ale ka wa biik la, mi me ale te baai ate mi a yaali la nyuvuri. ");
INSERT INTO bwu_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Wa kan bo nuruba ba tuimbaata buusa. Wa pa dila a nyo ka mi nisima po. ");
INSERT INTO bwu_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ate waai meena a te mu zula ase ba ale a te m Kowa dii la. Waai ale kan a te mi zula la, a kan te mi Kowa Naawen waai ale tom mi la me zula. ");
INSERT INTO bwu_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ni wom dii ate mi tara ayen m weeni ni la nalimnyiini. Baai meena ale a wom mi sakka de ale ta siaka ale Naawen waai ale tom mi la, wa le nya nyuvuri dii ale kan ta kpeglimka la. Naawen a kan bu wa buusa dii nyiŋ la ba poom nya nyuvuri kama. ");
INSERT INTO bwu_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Wensie ate mi a weeni ni ayen ku danni a cheena, di be poom a pa a kama ate baai ale a nyɛ ase kpeeba la ale wom Naawen Biika lueluk a nya nyuvuri dii ale kan ta kpeglimka la. ");
INSERT INTO bwu_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ase m Kowa ale basi ate nuruba a boro la, wa te mu pagrim kama ate mi me a basi ate nuruba a boro. ");
INSERT INTO bwu_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Wa te mu siuk kama ayen m bo nuruba buusa dii nyiŋ la mi ka Saalobiik. ");
INSERT INTO bwu_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ni kan basi ate mi ale a weeni ni dii la a cha ni. Ku danni a cheena kama ate baai meena ale kpi la a wom mi lueluku a yiti kum po. ");
INSERT INTO bwu_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Baai meena ale tom tuimmaŋsa la, m Kowa ale basi ate ba yiti kum po abe wa pa nyuvuri dii ale kan ta kpeglimka la a te ba. Baai meena me ale tom tuimbaata la, wa le yiti ba kum po abe wa te ba waalika. ");
INSERT INTO bwu_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Mi an baga a tom mi dek wari ya. Mi a bo buusa ase ka Naawen ale weeni mu dii la. Dila m boteka ka wensie. M kan yaali ayen m va m dek yaalika, alege ka waai ale tom mu la yaalika ate mi a va. ");
INSERT INTO bwu_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Dan ka mi nyiini ale weeni ni mi ale ka waai la, nama ate a weeni kama ayen m wieŋa a daa wensie. ");
INSERT INTO bwu_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","33","Alege Jɔɔn waai ale jam a te nuruba soka la a za ka mi ŋaaŋ, dii nyiŋ la ŋaai meena ate wa a sak nuruma mi wie la, ka wensie. Nama dek a tom nuruba ate ba cheŋ wa jigi ate wa biisi mi wie kama. ");
INSERT INTO bwu_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mi niŋ ka ale dii ate nuruba a biisi mi wie la, alege mi a weeni ni kama ayen ni a teeri dii ate Jɔɔn a weeni mi wie la ate ku maari ni ate ni nya varibasika. ");
INSERT INTO bwu_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jɔɔn a jam a nyɛ ase ka zeuŋ ate ba tɔati ate ku a nyagsi ate wa ale biisi dii la a peenti ni sue. ");
INSERT INTO bwu_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jɔɔn a sak nuruba mi wie, alege wie gela ale boro a sak nuruba mi wie a gaam Jɔɔn ale a sak ni dii la. Tuimkperikaliik sii ate mi Kowa a tom mi ayen m jam a tom la, ŋala ale a sak nuruba ayen ka wa ale waai ale tom mu la. ");
INSERT INTO bwu_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nama an diem a wom wa lueluwa a yaase ni nya wa, alege wa a kasim a sak nama mi wie kama. ");
INSERT INTO bwu_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Wa tom mi ka nama jigi, alege ni ka siaka ale mi. Ka dila ale soa ate wa sinsaŋŋa a ka ni suniimaŋa po la. ");
INSERT INTO bwu_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nama a kasim a karim Naawen gbaŋka kama daa meena dii nyiŋ la nama a poli kama ayen ka karimka a le basi ate ni nya nyuvuri dii ale kan ta kpeglimka la. Alege wa gbaŋka a diem a sak nama ka mi wie, ");
INSERT INTO bwu_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","alege nama a kan yaali ayen ni jam mi jigi ya ate ni nya nyuvuri dii ale kan ta kpeglimka. ");
INSERT INTO bwu_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Mi kan yaali ayen nuruba a pak mu, ");
INSERT INTO bwu_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","alege mi seba ni ale ka nuru baai la nalimnyiini, a seba me ayen ni kan yaali Naawen ya. ");
INSERT INTO bwu_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","M Kowa Naawen ale tom mu ayen m jam a zaani wa naŋkula po, alege nama an tuesi mu. Alege nuru waai a dan jam wa dek nyiŋ, ni a tuesi wa kama. ");
INSERT INTO bwu_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nama a yaali chaab zula teka alege ni kan yaali zula ŋaai ate Naawen ale baga a te ni la. Ni be ni nyɛ ka se a ta siaka ale mi? ");
INSERT INTO bwu_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nama a kan poli ayen mi a le ta biisigaamka ale ni m Kowa niŋŋa. Nama a ta ka popola Moosis jigi ale wa le a sak ni dii la. Wala ale waai a le wa biisi a gaam ni la. ");
INSERT INTO bwu_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ase ni dan jam ta siaka ale Moosis kama, ni te ta siaka ale mi kama dii nyiŋ la wala ale ŋmarisi mi wie. ");
INSERT INTO bwu_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ni be ale kan ta siaka ale Moosis ale ŋmarisi dii la, ni le nyɛ ka se a ta siaka ale mi?” ");
INSERT INTO bwu_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ku de ŋaaŋ nyiŋ, Yeezu ale wa ŋaaŋviirima a yaa basi dula jigini ale ge a ŋmani a taam Galili mogi kpeeni kuŋkɔŋini. Mogini de yue di choa a jam le Tiberiasi mogi. ");
INSERT INTO bwu_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ba le jam a cheŋ la, nuru bɔari a yaa va ba, dii nyiŋ la ba nya Yeezu ale jam a tom wakperikaliik sii ale yuaroma tebika la. ");
INSERT INTO bwu_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yeezu ale wa ŋaaŋviirima ale ga paari dula jigini la, ba yaa a ga jueli a kala guuk kunyi zuk. ");
INSERT INTO bwu_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Juuma Gaambasika Tigini a jam mɔata kama. ");
INSERT INTO bwu_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yeezu a yaa cheemu a nya nuru bɔanni ale ba cheena ate wa yaa bek Filip ayen, “Ti ti nya ŋandiinta ka be a te nuru bɔanni nna ate ba de?” ");
INSERT INTO bwu_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Wa dek a jam seba dii ate wa ayen wa nyɛ la kama, alege wa jam a yaali kama ayen wa nyɛ Filip a nya. ");
INSERT INTO bwu_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip a yaa weeni wa ayen, “Ti dan kan pai ligra a gaam ŋaai ate ti ta la a da ŋandiinta ku kan paari a de ba ale maga dek me.” ");
INSERT INTO bwu_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Filip ale ga weeni nyaku de a nueri la, Andiru, Simon Piita yuawa, a yaa weeni Yeezu ayen, ");
INSERT INTO bwu_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Nidɔabili wanyi ale bo dela a ta borobotta tinu ale juma ŋaye, alege ŋantaŋa de a kan paari nuruma de meena.” ");
INSERT INTO bwu_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yeezu a yaa weeni ba ayen, “Ni basi ate nuru bɔanni a kali tɛŋ.” Wuuk yegayega ale jam bo dula jigini. Nuruma a yaa kali tɛŋ. Ba nidɔama nyiini a jam ka tusa ŋanu. ");
INSERT INTO bwu_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yeezu a yaa pa borobottaŋa ale jumaŋa a puusi a te Naawen ayen wa niak ti ale ge a pa chari nuruma ate ba ŋobi. Ba ale chari a te waai meena a ga nueri la, ba meena a yaa ŋobi chak. ");
INSERT INTO bwu_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Yeezu a yaa weeni wa ŋaaŋviirima ayen, “Ni cheŋ a ga pisi ŋandiin talaŋa ate bala a kan kaasi.” ");
INSERT INTO bwu_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ba yaa pisi ŋandiin tii ate nuru bɔanni a de ale tali la a sueri busa pi ale siye. ");
INSERT INTO bwu_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nuruma ale nya wakperikaliik kaai ate Yeezu a tom te ba la, ba yaa weeni chaab ayen, “Nuruwa de a sum ka biisiteerɔ waai ate Naawen a weeni ayen wa le tom wa ate wa siŋ jam tɛŋzuk de la.” ");
INSERT INTO bwu_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yeezu ale ga wom dii ate ba jam a biisi ale chaab la, wa yaa yiti dula jigini a cheŋ a nyini guuku zuk a siŋ tɛŋ a cheŋ a jo guutaŋa po wa dek wa nyiini. Wa jam seba ayen ba nina ale muni ayen ba yik wa ale pagrim a bobi ba naab. ");
INSERT INTO bwu_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Wenni ale jam a siŋ la, wa ŋaaŋviirima a yaa ŋman cheŋ mogi kpeeni noai, ");
INSERT INTO bwu_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","a ga jo ŋaaruŋ po ayen ba taam kuŋkɔŋini ndila a ga paari Kapernaum tɛŋka. Tɛŋka ale jam a sobri la, Yeezu an diem a jam ba jigi ya. ");
INSERT INTO bwu_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Va kpioŋ a yaa deri a yiti a fɔbi ba ŋaaruŋku ale a nyɛ ate nyiamu a choa nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Wa ŋaaŋviirima ale damu ba ŋaaruŋku a cheŋ ga paari mɛɛla ŋata yaase ŋanaansi la, ba yaa nya Yeezu ale wa bo nyiamu zuk a cheŋ cheena ba jigi. Ba le ga nya wa la, yɔgsum a yaa deri yik ba. ");
INSERT INTO bwu_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yeezu a yaa weeni ba ayen, “Ka mi. Ni kan chali yɔgsumɔa.” ");
INSERT INTO bwu_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Wa le ga paari ba ŋaaruŋku la, ba meena sue a yaa peenti ate ba weeni wa ayen wa jo ba ŋaaruŋku po. Yeezu ale ga jo a gum ba po la, ba yaa deri paari kuŋkɔŋini kauk kuui ate ba a cheŋ la. ");
INSERT INTO bwu_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Vari ale veenti la, nuru bɔanni baai ale jam a wari ŋaaŋ la a jam miŋ kama ayen ka ŋaaruŋ yeŋ ale boro. Ba jam seba me ayen Yeezu an va ale wa ŋaaŋviirima alege ba cheŋ kama ale ge wa. Ŋaaruŋ yoŋ tii ale nyini Tiberiasi a yaa jam dula jigini kauk kuui ate Yeezu a puusi a te Naawen jiam alege ate ba ŋobi boroboruku la. ");
INSERT INTO bwu_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nuru bɔanni a yaa le gisi Yeezu a jiak la, ba yaa ga jo ŋaaruntaŋa po a va a cheŋ Kapernaum tɛŋka ayen ba nya wa. ");
INSERT INTO bwu_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nuruma ale ga nya Yeezu la, ba yaa bek wa ayen, “Ti Sagrɔ, fi jam dela ka dimpo?” ");
INSERT INTO bwu_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yeezu a yaa weeni ba ayen, “Wensie ate mi a weeni ni ayen ŋandiin tii ate mi diem a te ni ate ni de a chak la ale basi ate ni a gisi mu. Ni kan gisi mu ka m tuimkperikaliisaŋa miŋka nyiŋŋa. ");
INSERT INTO bwu_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ni kan basi ate ni yam meena, a bo ale ŋandiin tii a le ti jam a kaasi la, alege ni basi ate ni yam meena a bo ale ŋandiin tii ale a te nyuvuri dii ale kan ta kpeglimka la. Naawen waai ale ka mi ko la a za ka mi ŋaaŋ ayen mi ka wa biik. Ka dila ale soa ate mi a baga a pa nyuvuri dila a te ni.” ");
INSERT INTO bwu_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ba yaa bek wa ayen, “Tama ayen ti nyɛ ka se ate ku peenti Naawen sui ya?” ");
INSERT INTO bwu_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yeezu a yaa weeni ba ayen, “Ni dan a yaali ayen ni nyɛ ate Naawen sui a peenti, ni ta siaka ale mi waai ate wa tom ni jigi la.” ");
INSERT INTO bwu_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ba yaa weeni wa ayen, “Boan wakperikaliik ate fi ale tom ate ti nya abe ti ge a ta siaka ale fu? ");
INSERT INTO bwu_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Fi seba ayen ti kokpieŋsaŋa a jam de ka ŋandiinta ate ba wi ayen ‘maana’ la sagini po ase ba ale ŋmarisi Naawen gbaŋka po ayen, ‘Moosis a jam a nya ka ŋandiinta chiŋmaaŋa po a te wa nuruma ayen ba de’ ”. ");
INSERT INTO bwu_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yeezu a ŋman weeni ba ayen, “Wensie ate mi a weeni ni ayen Moosis an jam a nya ŋandiintaŋa ka chiŋmaaŋa po a te ni kokpieŋsaŋa, alege ka mi Kowa Naawen ale pa te ba. ");
INSERT INTO bwu_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ŋandiin tii ate Naawen a te la a nyɛ se ka waai ale nyini wenŋmazuk a jam ayen wa te tɛŋka demma nyuvuri dii ale kan ta kpeglimka la.” ");
INSERT INTO bwu_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ba yaa weeni wa ayen, “Ti Nyɔnɔ, fi kasim a te ti ŋandiintaŋa de.” ");
INSERT INTO bwu_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yeezu a yaa weeni ba ayen, “Mi a nyɛ se ka ŋandiin tii ale a te nyuvuri la. Baai ale a jam mi jigi la, kom a kan ŋman a yik ba diipo diipo. Baai me ale ta siaka ale mi la, nyanyuila a kan ŋman a yik ba diipo diipo. ");
INSERT INTO bwu_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mi poom a liŋ a weeni ayen ni nya mu kama alege ni diem a ka siaka ale mu. ");
INSERT INTO bwu_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Baai ate m Kowa a pa te mu la, a le jam m jigi ate m tuesi ba. Mi kan zɛri baai meena a le ba jam mi jigi la diipo diipo. ");
INSERT INTO bwu_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Dii nyiŋ la mi an nyini wenŋmazuk a jam ayen m tom ka mi dek ale a yaali dii la alege ka waai ale tom mu la ale a yaali dii la. ");
INSERT INTO bwu_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Waai ale tom mu la yaalika ale nna. Baai ate wa pa te mu la, m le nya ba zuk ate ba kan be. Wa ale basi ate ba yiti kum po abe wa pa nyuvuri dii ale kan ta kpeglimka la a te ba. ");
INSERT INTO bwu_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","M Kowa me yaalika ale ka dii la ale nna. Baai meena ale ta siaka ale mu la, wa ale te ba nyuvuri dii ale kan ta kpeglimka la. Wa ale basi ate ba yiti kum po kpeglimka danni.” ");
INSERT INTO bwu_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nuruma ale ga wom Yeezu ale a biisi dii ayen wa ale nyuvuri ŋandiintaŋa tii ate Naawen a tom ate wa nyini wenŋmazuk la, ba yaa ŋuuni. ");
INSERT INTO bwu_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ba yaa weeni chaab ayen, “Nuruwa de ka Yeezu, Josefi biika, yaa da di? Ti seba wa kowa ale wa mawa kama. Ka boa ale soa ate wa a weeni ayen wa nyini ka wenŋmazuk po a jamu?” ");
INSERT INTO bwu_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yeezu a yaa weeni ba ayen, “Ni basi ni ŋuunika. ");
INSERT INTO bwu_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nuru waai an baga a jam mi jigiya ase ka m Kowa waai ale tom mu la, dek a nin dari wa a ta jam mi jigi, ate m basi ate wa yiti kum po kpeglimka danni ate wa nya nyuvuri dii ale kan ta kpeglimka la. ");
INSERT INTO bwu_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Naawen biisiteerɔma ŋmarisi Naawen gbaŋka po dila po dila po ayen, ‘Naawen a le jam a sak nuruba meena.’ Baai meena ale a wom dii ate m Kowa a weeni la ale a va wa sinsaŋŋa la, wa le dari ba a ta jam mi jigi. ");
INSERT INTO bwu_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nuru waai an diem a nya mi Kowa. Mi waai ate wa tom ni jigi la, nyiini ale nya wa. ");
INSERT INTO bwu_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Wensie ate mi a weeni ni ayen baai meena ale ta siaka ale mi la a poom tuesi wa nyuvuri dii ale kan ta kpeglimka la kama. ");
INSERT INTO bwu_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mi ale ŋandiin tii ale a te nyuvuri la. ");
INSERT INTO bwu_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ni kokpieŋsaŋa a jam de ka ŋandiin tii ate ba a wi ayen ‘maana’ la sagini po dila po dila po ale ge ba kpi, ");
INSERT INTO bwu_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","alege baai meena ale a de nyuvuri ŋandiin tii ale nyini wenŋmazuk la, bala a kan kpi. ");
INSERT INTO bwu_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mi ale nyuvuri ŋandiin tii ale nyini wenŋmazuk a jam la. Baai meena ale a de ŋandiintaŋa de la ale nya nyuvuri dii ale kan ta kpeglimka la. Ŋandiin tii ate mi ayen m pa te ba la ale m nyiŋka, ate tɛŋka demma a baga a nya nyuvuri dii ale kan ta kpeglimka la.” ");
INSERT INTO bwu_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nuruma ale ga wom dii ate Yeezu a weeni la, ba yaa ta nampaga nna yegayega ale chaab wa le a weeni dii la nyiŋ ayen, “Nuruwa de ale nyɛ ka se a pa wa nyiŋka a te ti ate ti ŋobi?” ");
INSERT INTO bwu_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yeezu a yaa weeni ba ayen, “Wensie ate mi a weeni ni ayen ni a dan kan ŋobi Mi Saalobiika nyiŋka ale nyu m ziimu, Naawen nyuvuri dii ale kan ta kpeglimka la a kan baga a bo ni suniimaŋa po. ");
INSERT INTO bwu_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Baai meena ale a ŋobi mi nyiŋka ale a nyu m ziimu la a poom tuesi wa nyuvuri dii ale kan ta kpeglimka la kama. M dan jam ayen m bo tɛŋzuk meena demma buusa, m le nak ba kum po a yiti. ");
INSERT INTO bwu_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mi nyiŋka ale ŋandiin maŋsaŋa dek ale m ziimu me ale chim nyu maŋka. ");
INSERT INTO bwu_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Baai meena ale a ŋobi mi nyiŋka ale a nyu mi ziimu la a bo ale mi kama ale ge mi me a bo ale ba. ");
INSERT INTO bwu_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","M Kowa waai ale ka nyuvuri nyɔnɔwa la, ale tom mu ni jigi. Wala nyiŋ ale soa ate mi a boro. Siuk kula po me baai meena ale a ŋobi mi la, ale boro mi nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nyuvuri ŋandiintaŋa ale ŋandiin tii ate Moosis a jam pa te ni kokpieŋsaŋa ate ba de dila po dila po ale ge a kpi la, daa wayeŋŋa. Naawen ale tom wa nyuvuri ŋandiintaŋa ate ti nyini wenŋmazuk a jam, ate baai meena a le ba de ti la, a tuesi nyuvuri dii ale kan ta kpeglimka la.” ");
INSERT INTO bwu_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yeezu a jam bo ka Juuma tuka dɔkku kuui ale bo Kapernaum tɛŋka po la, a sak wieŋa de meena. ");
INSERT INTO bwu_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yeezu ŋaaŋviirima yegayega ale jam wom dii ate wa sak la, a yaa weeni chaab ayen, “Wa sinsaŋŋa a pagra kama. Waai an baga ŋa a va.” ");
INSERT INTO bwu_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yeezu ale jam a miŋ ayen ba boro a zu wa ŋaaŋ la, wa yaa bek ba ayen, “Mi sinsaŋŋa ayen ŋa nyɛ kama ate ni pa mi ŋaaŋ vaka a basi? ");
INSERT INTO bwu_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ase ni dan nya mi Saalobiika ale m ŋmani a jueli wenŋmazuk po, ni ale poli ka se? ");
INSERT INTO bwu_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Waai ale a te nyuvuri la ale Naawen Chiika alege nurubiik pagrim an baga a nyɛ ku de. Mi ale biisi wie ŋaai ate ni la ale a basi ate Naawen Chiika a jam ni jigi. ");
INSERT INTO bwu_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Alege ni gela a ka siaka ale mi ale a sagi dii la.” (Yeezu ale piilim a sak wa ŋaaŋviirima la, wa jam seba baai ale ba kan ta siaka ale wa la kama ale waai a le wa ta wa a ga bobri a sak la.) ");
INSERT INTO bwu_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Dula jigini Yeezu a yaa ŋman weeni ba ayen, “Ka dila ale soa ate mi a liŋ sak ni ayen nuru waai an baga a jam mi jigi ase ka M Kowa a nin dari wa a ta jam mi jigi la.” ");
INSERT INTO bwu_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Wa ŋaaŋviirima ale ga wom dila la, ba yegayega a yaa deri basi wa ŋaaŋ vaka. ");
INSERT INTO bwu_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yeezu ale ga nya ba le nyɛ dii la, wa deri chiem wa ŋaaŋviirima pi ale bayewa jigi a bek ba ayen, “Nama me ayen ni basi mi kama?” ");
INSERT INTO bwu_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Piita a yaa weeni wa ayen, “M Nyɔnɔ, ka wana jigi ate ti a yaali ayen ti cheŋi? Fi ale waai ale ta Naawen nyuvuri dii ale kan ta kpeglimka la sinsaŋŋa a sak ti. ");
INSERT INTO bwu_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tama abe ta siaka ale ŋa kama ale seba ayen ka fi ale Naawen nuru weleŋka.” ");
INSERT INTO bwu_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yeezu a yaa weeni ba ayen, “Mi a lueri ni ka nuruba pi ale baye ayen ni chim mi ŋaaŋviiriba, alege ni po wanyi ka Sitaana nuru.” ");
INSERT INTO bwu_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Wa jam a biisi ka waai ate ba a wi wa ayen Judas, Simon Iskariot biika la, wie. Yeezu a jam seba ayen wa le bobri wa a sak. ");
INSERT INTO bwu_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nyaku de ŋaaŋ nyiŋ, Yeezu a yaa nyiem a gilim Galili tɛŋka. Wa jam seba ayen Juuma kpaŋŋa baai ale jam bo Judia tɛŋka po la a gisi ka siuk ayen ba ko wa. Ka dila ale soa ate wa kan jam a yaali ayen wa ŋmani a cheŋ dula jigini. ");
INSERT INTO bwu_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Juuma tigi dii ate ba a wi ayen Kusuŋta Tigi la, a jam mɔata kama. ");
INSERT INTO bwu_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Wa suaataŋa a yaa jam a weeni wa ayen, “Basi dula jigini abe fi cheŋ Judia tɛŋka po, ate fi ŋaaŋviirima baai ale bo dula la me a nya fi tuimkperikaliisaŋa sii ate fi a tom la.” ");
INSERT INTO bwu_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ba ŋman weeni wa ayen, “Nuru a kan suk wie ŋaai ate wa a tom la ase wa ale a yaali ayen ba seba wa. Fi abe le a tom wieŋa de la, basi ate tɛŋka meena a seba fu.” ");
INSERT INTO bwu_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yeezu suaataŋa an jam a ta siaka ale wa. ");
INSERT INTO bwu_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yeezu a yaa weeni ba ayen, “Ku an diem a magsi ayen mi cheŋ dula yɔgyɔgla de, alege nama a baga a cheŋ diipo meena ate ni a yaali la kama. ");
INSERT INTO bwu_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tɛŋka meena demma an kisi nama alege ba kisi mi kama, dii nyiŋ la mi kasim a weeni ba kama ba ale a tom tuimbaata la, alege ba an kisi nama. ");
INSERT INTO bwu_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nama a cheŋ Jerusalem a ga de tigini, dii nyiŋ la ku an magsi ayen mi a cheŋ dula jigini yɔgyɔgla de.” ");
INSERT INTO bwu_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yeezu ale weeni nyaku de la, wa yaa wari a bo Galili tɛŋka po. ");
INSERT INTO bwu_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Wa suaataŋa ale jam a basi wa ale cheŋ tigini la, Yeezu me a yaa magi va ba ŋaaŋ a cheŋ. ");
INSERT INTO bwu_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Juuma kpaŋŋa baai ale jam a tigsi chaab a bo Jerusalem tɛŋka la a jam a gisi ka Yeezu ale a bek chaab wa boka jigi. ");
INSERT INTO bwu_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nuruba yegayega a yaa jam a waasi a biisi wa wie. Ba gela a jam a weeni ayen wa ka nuru maŋ, alege baai me a weeni ayen wa a paasi ka nuruba. ");
INSERT INTO bwu_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ba meena a jam a chali ka ba kpaŋŋa yɔgsum. Ka dila ale soa ate ba an jam a biisi wa wie ate ku a jueli la. ");
INSERT INTO bwu_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Tigini daaŋa ale jam a chalisi a soa se chaab la, Yeezu a yaa ga jo Juuma Puusika Yenni po a boro a sak nuruma. ");
INSERT INTO bwu_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Wa sinsaŋŋa a yaa cha Juuma kpaŋŋa baai ale jam bo dula la. Ba yaa weeni chaab ayen, “Nuruwa de a ka sagrɔ ate wa sak wa ale nyɛ ka se a seba wieŋa de meena a sagi tama?” ");
INSERT INTO bwu_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yeezu a yaa weeni ba ayen, “Mi sinsaŋŋa ka Naawen ale tom mi la wie, ŋa daa mi dek wie. ");
INSERT INTO bwu_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Baai meena ale a yaali ayen ba va Naawen yaalika la, a le miŋ ase mi sinsaŋŋa a nyini ka Naawen jigi yaa mi dek. ");
INSERT INTO bwu_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nuru waai ale a biisi wa dek wie la a yaali kama ayen nuruba a te wa zula. Nuru waai ale a yaali ayen wa a te waai ale tom wa la zula la, wala ka wensie nyɔnɔ. Venta a ka wa jigiya. ");
INSERT INTO bwu_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moosis ale te ni Naawen Sinsaŋŋa, wa an te ni? Alege ni waai a kan zuli ŋa. Ka boa ale soa ate ni a yaali ayen ni ko mu?” ");
INSERT INTO bwu_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nuru bɔanni a yaa weeni wa ayen, “Fi a yesim kama. Ka wana ale a yaali ayen wa ko fu?” ");
INSERT INTO bwu_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yeezu a yaa weeni ba ayen, “Mi tom ka wakperikaliik kanyi ni Vuusum Danni ate ku cha ni nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moosis a sak ni kama ayen ni a gebi ni bisaŋa yuaŋa alege ka ni kokpieŋsaŋa ale a piilim ku, ate nama a gebi biik yuari Vuusum Danni po. ");
INSERT INTO bwu_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nama abe dan nyɛ dila Vuusum Danni po alege an nyɛ kaasi Moosis Sinsaŋŋa ka boa ale soa ate nama sue a puuri ale mi m le tebi nuruwa Vuusum Danni la? ");
INSERT INTO bwu_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ni kan a bo nuruba buusa ale ba peelim tuima ale ka dii la, alege ni a bo ba wensie buusa.” ");
INSERT INTO bwu_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nuru baai ale jam bo Jerusalem tɛŋka po la, ba gela a yaa weeni chaab ayen, “Daa nuruwa de ate kpaŋŋa a yaali ayen ba ko la? ");
INSERT INTO bwu_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ni be nya, wa le la a za peelimu po a sak nuruma alege ti kpaŋŋa a kan yaali ayen ba nyɛ wa wariya. Ba baga a seba ayen wa sum ka Varibasidɔwa waai ate Naawen ayen wa le tom la? ");
INSERT INTO bwu_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Varibasidɔwa a dan jam, waai a kan seba wa ale nyini juijui la. Alege tama meena seba nuruwa de ale nyini juijui la kama.” ");
INSERT INTO bwu_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yeezu ale diem a jam bo Juuma Puusika Yenni po a sak nuruma la, wa yaa weeni ate ku jueli ayen, “Nama a seba mi ale nyini juijui la? Mi an jam daa m dek nyiŋŋa. Waai ale tom mu la ka wensie nyɔnɔ. Ni abe ze wa, ");
INSERT INTO bwu_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","alege mi ale seba wa. Mi ale wa a jam bo ka jigi yeŋ ale ge ate wa tom mi ni jigi.” ");
INSERT INTO bwu_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nuruma gela ale wom dii ate wa weeni la, ba yaa jam a yaali ayen ba yik wa alege nuru an pa nisa a tiri wa dii la wa yikka danni an diem a paari ya. ");
INSERT INTO bwu_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nuru bɔanni po yegayega a jam ta siaka ale wa, a yaa weeni chaab ayen, “Ase Varibasidɔwa a dan poom jam, wa le baga a tom wakperikaliisa a gaam nuruwa de?” ");
INSERT INTO bwu_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisiima ale wom nuru bɔanni ale a waasi Yeezu wie dii la, ba le Juuma Puusika Yenni kpaŋŋa a yaa wi chaab a biisi alege a tom ba dek nuruba ayen ba ga yik Yeezu. ");
INSERT INTO bwu_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yeezu a yaa weeni ba ayen, “Mi le bo ale ni daa maga dega abe m ge a ŋman cheŋ waai ale tom mu la jigi. ");
INSERT INTO bwu_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ni le nyiem a gisi mi boka jigi, alege ni kan ŋman nya mu dii nyiŋ la ni kan baga a cheŋ juijui ate mi a cheŋ la.” ");
INSERT INTO bwu_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Juuma kpaŋŋa a yaa bek chaab ayen, “Wa ti an a yaali ayen wa cheŋ ka Girik tɛŋsaŋa ate tama nuruma a maa boro la a sak Girik demma yaa? ");
INSERT INTO bwu_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Wa weeni ti ayen ti le nyiem a gisi wa boka jigi, alege ti kan ŋman nya wa. Wa ŋman weeni ti me ayen ti kan baga a cheŋ juijui ate wa a cheŋ la. Nyaku de kiri ale boa?” ");
INSERT INTO bwu_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Juuma tigini dai dii dai dek ale jam a kpeglim la ale nin muna dai. Dai dila danni Yeezu a yaa yiti a zaani nuru bɔanni niŋ a weeni ate ku jueli ayen, “Baai meena ate nyanyuila a ta ba la, a jam mi jigi ate m te ba nyiam ate ba nyu. ");
INSERT INTO bwu_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ba ŋmarisi Naawen gbaŋka po dila po dila po ayen, ‘Nyiam a le nyini baai ale ta siaka ale mi la suniima po a kasim a chali a nyini.’ ” ");
INSERT INTO bwu_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yeezu ale biisi ale ba dii nyiamu jigi la, a magsi chaab ale ka Naawen Chiika. Naawen an diem a pa wa Chiika a te baai ale ta siaka ale Yeezu la, dii nyiŋ la Yeezu an diem a yiti a jueli Naawen jigi ya. ");
INSERT INTO bwu_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nuru bɔanni ale wom dii ate Yeezu a weeni la, ba gela a yaa weeni chaab ayen, “Nuruwa de a sum le biisiteerɔwa waai ate Naawen a weeni ayen wa le tom wa la.” ");
INSERT INTO bwu_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ba gela me a weeni ayen, “Ka wala ale Varibasidɔwa ate Naawen a weeni ayen wa le tom la.” Mbala me a weeni ayen, “Varibasidɔwa an baga a chim Galili deno. ");
INSERT INTO bwu_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ba ŋmarisi Naawen gbaŋka po ayen, ‘Varibasidɔwa ale chim ka Naawa Deevid ŋaaŋbiik. Ba le biak wa ka Betilihem, tɛŋ kaai ate Deevid nyini la.’ ” ");
INSERT INTO bwu_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nyaku de meena a yaa jam basi ate nuru bɔanni a poori chaab nna tɔgatɔga. ");
INSERT INTO bwu_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ba gela a jam a yaali kama ayen ba yik wa, alege nuru waai an jam a tiri wa. ");
INSERT INTO bwu_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nuru baai ate Juuma Puusika Yenni kpaŋŋa ale Farisiima a jam tom ba ayen ba ga yik Yeezu la, a ŋman pilim a cheŋ ale ka niyaala. Baai ale tom ba la a yaa bek ba ayen, “Ka boa ate ni an yik wa a ta jam ya?” ");
INSERT INTO bwu_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nuruma a yaa weeni ba ayen, “Nuruwa de biika, tama an diem a maa wom ka choa.” ");
INSERT INTO bwu_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farisiima a yaa weeni ba ayen, “Wa sum a maa paasi nama me kama? ");
INSERT INTO bwu_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nama diem a wom ale kpaŋŋa yaase Farisiima wanyi a ta siaka ale wa. ");
INSERT INTO bwu_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nuru bɔanni baai ale za a wom wa sinsaŋŋa la, a ze Moosis Sinsaŋŋa, dila nyiŋ la Naawen ale waali ba.” ");
INSERT INTO bwu_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimusi waai ale jam a liŋ biisi ale Yeezu la a jam maa ka Farisiima po wanyi. Wa yaa weeni wa vaanchaama ayen, ");
INSERT INTO bwu_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Tama Sinsaŋŋa a sak ti kama ayen ti dan kan de niŋ a bo nuru buusa a wom wa dek noai po ti an baga a weeni ayen wa biisi lo ya.” ");
INSERT INTO bwu_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ba yaa bek wa ayen, “Fi me a nyini ka Galili tɛŋka? Be nya Naawen gbaŋka po ate fi miŋ ayen biisiteerɔ an nyini Galili tɛŋka.” ");
INSERT INTO bwu_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ba meena a yaa yiti a waaŋ chaab a kuli ba yeeŋa. ");
INSERT INTO bwu_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yeezu me a yaa basi dula jigini ale ge a cheŋ ga jueli Olivi Guuku zuk. ");
INSERT INTO bwu_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Vari ale veenti la saliuk wa yaa ŋman siŋ a cheŋ ga jo Juuma Puusika Yenni po. Nuru bɔari a yaa ŋman tigsi a gilim wa ate wa yaa kala a sak ba. ");
INSERT INTO bwu_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Wa le jam boro a sak ba la, Juuma Sinsaŋŋa sagrɔma ale Farisiima a yaa yik nipɔk wanyi a ta jam zaani ba meena niŋ. Ba jam yik nipowa de ale wa boro a nyɛ ka kaboŋ. ");
INSERT INTO bwu_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Baai ale ta wa a jam la a yaa weeni Yeezu ayen, “Ti Sagrɔ, tama nya wa kama ale wa boro a goa ale nidɔa. ");
INSERT INTO bwu_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ti Sinsaŋŋa po, Moosis a sak ti kama ayen ti dan nya nipɔk ale wa boro a nyɛ dila, ti pisi tintana a yuk wa a ko. Fi a poli nyaku de ka se?” ");
INSERT INTO bwu_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ba bek wa dila kama ayen ba nyɛ wa a nya ate wa dan tulisi be abe ba weeni ayen wa kaasi ya. Alege Yeezu an jam a tulisi ba a yaa le ge a koori tɛŋ a pa wa nandub a ŋmarisi tɛŋ. ");
INSERT INTO bwu_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ba le diem za a bek wa la, wa yaa yiti nya ba ale weeni ayen, “Nuru waai dek ale seba ayen wa an diem a maa tom tuimbiok a nya la, wala dek abe liŋ a pai tintain a yuk nipowa.” ");
INSERT INTO bwu_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Wa le weeni dila la, wa yaa ŋman koori tɛŋ a ŋmarisi. ");
INSERT INTO bwu_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ba le wom wa wieŋa la, ba yaa waaŋ chaab wanyi wanyi, ŋankpagsaŋa a de niŋ ate mbala a pa saŋ. Ba yaa jam a tali ka Yeezu ale nipowa nyiini dula jigini. ");
INSERT INTO bwu_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yeezu a yaa ŋman yiti ŋmai a nya nipowa ale bek wa ayen, “Ba bo ka be? Nuru waai a karo ayen wa bo mini fu?” ");
INSERT INTO bwu_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nipowa a yaa weeni Yeezu ayen, “M Nyɔnɔ, waai karo.” Yeezu a yaa weeni wa ayen, “Mi me a kan bo mini fu. Be cheŋ a kuli abe fi kan ŋman a tom tuimbaata.” ");
INSERT INTO bwu_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Va ŋala po Yeezu a yaa ŋman boro a sak nuru bɔanni ayen, “Mi a nyɛ se ka bolim ate ba tɔati la a te tɛŋzuk meena demma. Baai meena ale a va mi la a kan ŋman a cheŋi legi po. Mi a le de ba niŋ ase bolim la a dak siuku a sak ba abe m te ba Naawen nyuvuri dii ale kan ta kpeglimka la.” ");
INSERT INTO bwu_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farisiima a yaa wom wa le biisi dii la a yaa weeni wa ayen, “Fi a biisi a pak ka fi dek, dila abe kan sak wari ya.” ");
INSERT INTO bwu_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yeezu a yaa weeni ba ayen, “Mi a biisi a pak ka m dek alege ku ka wensie dii nyiŋ la m seba m le nyini juijui la kama ale a ŋman seba m le a cheŋ juijui la me. Nama ze mi ale nyini juijui la yaase m le a cheŋ juijui la me. ");
INSERT INTO bwu_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nama a kasim a bo nuruba buusa ka ba peelim tuima ale ka dii la, alege mi kan bo waai buusa. ");
INSERT INTO bwu_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ase mi dan poom a bo nuru waai buusa, m buusaŋa ka wensie, dii nyiŋ la daa mi nyiini ale a bo buusaŋa, m Kowa Naawen waai ale tom mu la a bo ale mu kama. ");
INSERT INTO bwu_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ba ŋmarisi ni sinsaŋŋa po kama ayen nuruba baye a dan siak a ta noayeŋ ale chaab wari nyiŋ, ba wanni ka wensie. ");
INSERT INTO bwu_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mi a biisi a pak ka m dek, m Kowa waai ale tom mu la me a biisi a pak ka mi.” ");
INSERT INTO bwu_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ba yaa bek wa ayen, “Fi kowa bo ka be?” Yeezu a yaa weeni ba ayen, “Ni ze mi yaase m Kowa, ni dan seba mi ni seba m Kowa me kama.” ");
INSERT INTO bwu_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yeezu a jam kala ka Juuma Puusika Yenni po a mɔata juijui ate nuruma a nyiem a pa ba ligraŋa a ta jam a nyoro a te Naawen la a sak nuru bɔanni wieŋa de meena. Nuru waai an jam a yik wa dii nyiŋ la wa yikka danni an diem a jam paari ya. ");
INSERT INTO bwu_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yeezu a ŋman weeni ba ayen, “Mi a gomsi kama ayen m cheŋ jigi. M daa cheŋ, ni kan baga a va mu a cheŋi. Nama a le nyiem a gisi mu, alege ni le kpi ale ni tuimbaataŋa.” ");
INSERT INTO bwu_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Juuma kpaŋŋa ale ga wom dii ate wa biisi la, ba yaa weeni chaab ayen, “Wa a weeni ka tama ayen ti kan baga a va wa a cheŋ wa ale a cheŋ juijui la. Ku de be a sak kama ayen wa a yaali ayen wa ko ka wa dek ya?” ");
INSERT INTO bwu_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yeezu a yaa weeni ba ayen, “Nama ka tɛŋzuk de nuruba, alege mi nyini ka wenŋmazuk, nama nyini ka tɛŋzuk de alege mi an nyini tɛŋzuk de. ");
INSERT INTO bwu_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Dila ale soa ate mi a weeni ayen ni le kpi ale ni tuimbaataŋa la. Ni le kpi ale ni tuimbaataŋa ase ni a nin kan ta siaka ale mi le weeni ayen mi ka waai la.” ");
INSERT INTO bwu_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ba yaa bek wa ayen, “Fi ka wana?” Yeezu a yaa weeni ba ayen, “Mi poom a liŋ weeni ni mi ale ka waai la kama. ");
INSERT INTO bwu_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","M ta ka wie yegayega ayen m weeni ayen ni kaasi ya. Waai ale tom mu la ka wensie nyɔnɔ, mi me a sak tɛŋzuk de nuruma ka dii nyiini ate m wom m Kowa jigi la.” ");
INSERT INTO bwu_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Juuma kpaŋŋa an diem a jam miŋ ayen Yeezu a jam a sak ba ka wa Kowa Naawen wie. ");
INSERT INTO bwu_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Wa yaa ŋman weeni ba ayen, “Ni dan jam yik mi Saalobiika a kpi jabarimu nyiŋ, ni le miŋ mi ale a weeni ayen mi ka waai la, ate ni seba ayen mi a kan nyɛ wari ale m dek pagrimɔa. Alege mi a biisi ka m Kowa ale sak mu dii la. ");
INSERT INTO bwu_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Waai ale tom mu la dek a bo ale mu kama wa an basi mu m dek m nyiini dii nyiŋ la m kasim a tom ka dii ale a peenti wa sui la.” ");
INSERT INTO bwu_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yeezu ale biisi a nueri la, baai ale jam a wom wa la, yegayega a yaa jam ta siaka ale wa. ");
INSERT INTO bwu_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Dula jigini Yeezu a yaa ŋman weeni baai ale jam ta siaka ale wa la ayen, “Ni dan va mi wensie sinsaŋŋa de, ni le chim mi ŋaaŋviirimaŋsa. ");
INSERT INTO bwu_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ni le miŋ wensieŋa ate wensieŋa a vari ni a basi.” ");
INSERT INTO bwu_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ba yaa weeni wa ayen, “Tama ka ti kokpieŋka Abraham ŋaaŋbisa, alege ti an diem a chim nuruba yom a nya ya. Fi ale a weeni ti dii ayen fi wensieŋa a le vari ti yomtiri po a basi la kiri ale boa?” ");
INSERT INTO bwu_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yeezu a yaa weeni ba ayen, “Wensie ate mi a weeni ni ayen waai dek ale a tom tuimbaata la a chim ka tuimbaata yomo. ");
INSERT INTO bwu_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nuru yomo a ka siuk ale wa jaabɔa, alege nuru dek biik a ta siuk ale wa ŋanta meena kama. ");
INSERT INTO bwu_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mi, Naawen Biika, a dan vari fu a basi fi sum a nya varibasika kama. ");
INSERT INTO bwu_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mi seba ayen ni ka Abraham ŋaaŋbisa, alege ni a yaali ayen ni ko mu, dii nyiŋ la ni kan yaali ayen ni wom m sinsaŋŋa. ");
INSERT INTO bwu_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mi a biisi ka mi ale nya dii m kowa jigi la alege nama a biisi ni kowa ale weeni dii la.” ");
INSERT INTO bwu_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ba yaa weeni wa ayen, “Ka Abraham ale tama ko.” Yeezu a yaa weeni ba ayen, “Abraham a dan sum ka nama ko, ku te a fe kama ayen ni va wa wamaŋsaŋa. ");
INSERT INTO bwu_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nama ba gela a yaali kama ayen ni ko mu, dii nyiŋ la mi ale a sak ni wensie wie ŋaai ate Naawen a sak mu la. Abraham an jam baga a nyɛ wari ase nyaku de la. ");
INSERT INTO bwu_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nama a dan a nyɛ dila, ku a nyɛ ase ni a va ka ko yoŋ naŋkula po la.” Ba yaa weeni wa ayen, “Naawen nyiini ale tama Ko.” ");
INSERT INTO bwu_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yeezu a yaa weeni ba ayen, “Ase Naawen a dan sum ka nama Ko, nama a te a yaali mi kama, dii nyiŋ la mi nyini ka wa jigi. Mi an jam denna ka m dek nyiŋŋa, alege ka Naawen ale tom mu. ");
INSERT INTO bwu_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nama an baga a wom mi sinsaŋŋa, dii nyiŋ la ni zɛri ŋa womka kama. ");
INSERT INTO bwu_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ni ka ni kowa Velinvendika bisa ate ni a yaali ayen ni a va wa yaalika. A nyini piilimka po wa ka nuru koorik. Wa an maa va wensie siuwa dii nyiŋ la wensie ka wa jigi ya. Wa daa velim wa a nyɛ dila kama dii la venta a piilim ka wa jigi ale chim venta naab. ");
INSERT INTO bwu_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mi a sak ni ka dii ale ka wensie la, alege nama a kan ta siaka ale mi ale a weeni ni dii la. ");
INSERT INTO bwu_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nama waai a ka dela a baga a sak mu wa dii ate mi a nyɛ kaasi la. Ase mi a dan kasim a sak ni ka wensie, ka boa abe le soa ate nama a kan ta siaka ale dii ate mi a sak ni la? ");
INSERT INTO bwu_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Baai ale ka Naawen bisa la a nyiem a kasim a wom wa ale a weeni ba dii la kama. Nama ale kan a yaali ayen ni wom Naawen wieŋa dii la a sak kama ayen ni daa wa bisa.” ");
INSERT INTO bwu_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Dula jigini Juuma kpaŋŋa a yaa weeni Yeezu ayen, “Tama ale weeni ayen fi ka Samaria deno ate chichiribiok a bo fi zukku po la, daa wensie ate ti a weeni?” ");
INSERT INTO bwu_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yeezu a yaa weeni ba ayen, “Chichiribiok a ka mi zukku po. Mi a te m Kowa zula kama, alege nama a kan te mi zula. ");
INSERT INTO bwu_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mi a kan yaali zula a te m dega, alege ka m Kowa ale a yaali ayen nuruba a te mu zula, wa abe ni wa bo baai ale zɛri mu la buusa. ");
INSERT INTO bwu_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Wensie ate mi a weeni ni, waai ale a va mi sinsaŋŋa la ale nya nyuvuri dii ale kan ta kpeglimka la.” ");
INSERT INTO bwu_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Juuma kpaŋŋa a yaa weeni wa ayen, “Yɔgyɔgla de ti sum seba kama ayen chichiribiok ale bo fi zukku po, ti kokpieŋka Abraham ale Naawen biisiteerɔma meena a kpi ka dila po dila po. Alege fi a weeni ti ayen baai meena ale a va fi sinsaŋŋa la a kan maa kpi. ");
INSERT INTO bwu_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ti kokpieŋka Abraham kpi kama. Fi a poli ayen fi zuak a gaam wa kama. Naawen biisiteerɔma me a kpi, fi ti an a poli ayen fi ka wana?” ");
INSERT INTO bwu_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yeezu a yaa weeni ba ayen, “Ase mi a dan yaali ka zula a te m dek zula ŋala a kan ta kiri ya. Waai ale a te mi zula la ale m Kowa waai dek ate nama a wi ayen ni Naawen la. ");
INSERT INTO bwu_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nama a ze wa, alege mi a seba wa kama. Mi a dan weeni ayen m ze wa, m ka velinvendik ase nama la. M seba wa kama ale a va wa sinsaŋŋa. ");
INSERT INTO bwu_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nama kokpieŋka Abraham ale jam a nya mu ale m cheena tɛŋzuk de la, wa sui a jam peenti kama nna yegayega.” ");
INSERT INTO bwu_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Juuma kpaŋŋa a yaa weeni wa ayen, “Fi an diem a paari bena pisinu ale nyɛ ka se a seba Abraham?” ");
INSERT INTO bwu_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yeezu a yaa weeni ba ayen, “Ni wom dii ate mi a yaali ayen m weeni a sak ni la nalimnyiini. Mi poom a jam liŋ boro kama ale ge ate ba biak Abraham.” ");
INSERT INTO bwu_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Juuma kpaŋŋa ale ga wom nyaku de la, ba yaa pisi tintana ayen ba yuk wa, alege Yeezu a yaa suk a taam nyini Juuma Puusika Yenni po a nyini. ");
INSERT INTO bwu_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Dai yeŋ ate Yeezu a yaa nyiem a cheŋ a ga zik nidɔa wanyi ate ba jam a biak wa ale yiisa. ");
INSERT INTO bwu_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yeezu ŋaaŋviirima a yaa bek wa ayen, “Ti Sagrɔ, ka boa ale soa ate ba biak wa ale yiisaŋa? Ka wa dek tuimbaata nyiŋ yaa ka wa nyamma tuimbaata nyiŋ ale soa ate wa yi?” ");
INSERT INTO bwu_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yeezu a yaa weeni ba ayen, “Wa yiisaŋa a ka wari a nyɛ ale wa dek tuimbaata yaase wa nyamma tuimbaata. Wa yi kama ayen ku sak nuruba Naawen pagrimu a le bu tom dii la. ");
INSERT INTO bwu_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yɔgyɔgla ate ku ka kantueŋ la ti le tom ka waai ale tom mu la tuimaŋa. Tɛŋka abe za ka sobi kama ate waai a kan ŋman baga a tom tuima. ");
INSERT INTO bwu_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mi ale diem bo tɛŋzuk de la, mi a nyɛ ase ka bolim ate ba tɔati a zaani ate bu a nyagsi a te tɛŋka meena demma la.” ");
INSERT INTO bwu_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yeezu ale biisi a nueri la, wa yaa chesi tintueta a basi tɛŋ a pa wa nandummu a yik tintuetaŋa ale tantaŋa a dam chaab a pa sa nuruwa ninaŋa. ");
INSERT INTO bwu_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","A yaa weeni wa ayen, “Cheŋ a ga puuri fi ninaŋa beli fiik kaai ate ba a wi ayen Sailom la nyiamu po.” Sailom kiri ale juijui ate mi a tom fu la. Nuruwa a yaa cheŋ a ga puuri wa ninaŋa ate ŋa deri lagri ate wa a nya. ");
INSERT INTO bwu_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Wa ale kuli yeri la, nuru baai yeeŋa ale za mɔata wa yenni ale baai ale jam a nya wa ale wa nyiem a juisi la, a yaa bek chaab ayen, “Daa nuruwa de a nyiem ale kasim a kala denna a juisi la?” ");
INSERT INTO bwu_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ba gela a weeni ayen, “Ka wa ale la.” Mbala me a weeni ayen, “Daa wa ale la, alege wa a neensi wa kama.” Nuruwa dek a yaa weeni ba ayen, “Ka mi ale la.” ");
INSERT INTO bwu_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ba yaa bek wa ayen, “Fi ninaŋa a nyɛ ka se a lagri?” ");
INSERT INTO bwu_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Wa yaa weeni ba ayen, “Nuru waai ate ba a wi wa ayen Yeezu la, ale tu mu a yaa chesi tintueta a dam ale tanta a pa sa mi ninaŋa ale ge a weeni ayen m cheŋ a ga puuri ŋa Sailom beli fiika nyiamu po. Mi ale cheŋ a ga puuri ŋa la ŋa yaa deri a nya.” ");
INSERT INTO bwu_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ba yaa ŋman bek wa ayen, “Wa bo ka be?” Wa yaa weeni ba ayen, “M ze.” ");
INSERT INTO bwu_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ba yaa yik nuru waai ale jam a yi la a ta wa a cheŋ Farisiima jigi. ");
INSERT INTO bwu_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Dai dii danni dek ate Yeezu a pa tantaŋa a sa nuruwa ninaŋa ate ŋa lagri la, a jam ka Juuma Vuusum Dai. ");
INSERT INTO bwu_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Farisiima a yaa bek wa ayen, “Fi ninaŋa a nyɛ ka se a lagri?” Wa yaa weeni ba ayen, “Wa pa ka tanta a sa mi ninaŋa. Mi ale cheŋ a ga puuri ŋa la, ŋa yaa deri a nya.” ");
INSERT INTO bwu_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farisiima ale wom dii ate wa weeni la, ba gela a weeni chaab ayen, “Waai ale nyɛ dila la an baga a nyini Naawen jigi ya, dii nyiŋ la wa nyɛ ku ka ti Vuusumu Danni.” Mbala me a weeni chaab ayen, “Ase nuruwa de a dan ka tuimbaata nyɔnɔ, wa ti an wa nyɛ se a tom tuimkperikaliika de?” Ate ba ta noa tɔgatɔga. ");
INSERT INTO bwu_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ba yaa ŋman begi nuruwa ayen, “Nuru waai ate fi a weeni ayen wa lagi fi ninaŋa la, fi ti an a poli ayen wa ka wana?” Wa yaa weeni ba ayen, “Wa ka Naawen biisiteerɔ.” ");
INSERT INTO bwu_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Farisiima a kan jam a siagi ayen nuruwa de a liŋ a yi kama ale ge ŋman a nya. Ba yaa wi wa nyamma. ");
INSERT INTO bwu_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","A bek ba ayen, “Ka nama biik ale nna? Ase nama a dan biak wa ale yiisa, wa nyɛ ka se a ŋman baga a nya?” ");
INSERT INTO bwu_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ba yaa weeni ba ayen, “Wa ka tama biik ate ti biak wa ale yiisaŋa. ");
INSERT INTO bwu_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Alege tama an baga a miŋi wa le nyɛ dii a nya la yaase waai ale lagi wa ninaŋa a te wa la. Nama dek a bek wa, wa ninaŋa ale nyɛ dii a lagi la, dii nyiŋ la wa pak kama ale ta yam a baga a weeni a sak ni.” ");
INSERT INTO bwu_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nuruwa nyamma a jam a chali ka yɔgsum ale Farisiima ate ba yaa tulisi ba dila. Farisiima a jam liŋ weeni kama ayen nuru waai a dan weeni ayen wa ta siaka ayen Yeezu ale Varibasidɔwa ate Naawen ayen wa le tom wa la, ba ale yeeri kula nyɔnɔ ba tuka dɔkku po. ");
INSERT INTO bwu_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ka dila nyiŋ ate wa nyamma a weeni ayen ba begi wa dek ale wa pak kama ale ta yam a baga a weeni ba dii ale nyɛ la. ");
INSERT INTO bwu_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Farisiima a yaa ŋman wi nuru waai ale jam a yi la a weeni wa ayen, “Tama a seba kama ayen nuru waai ale lagi fi ninaŋa la ka wabanyeerik. Yɔgyɔgla de be pe Naawen ayen fi le weeni wensie nyiini a sak ti.” ");
INSERT INTO bwu_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nuruwa a yaa weeni ba ayen, “Mi ze ase wa ka wabanyeerik yaa wa daa wabanyeeriga. Wa yeŋ ate mi a seba, mi jam yi kama, alege yɔgyɔgla de m ŋman pilim a nya.” ");
INSERT INTO bwu_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ba yaa ŋman begi wa ayen, “Fi ninaŋa a nyɛ ka se a lagri?” ");
INSERT INTO bwu_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Wa ŋman weeni ba ayen, “Mi poom a liŋ weeni ni kama, alege ni an wom ya. Nama a yaali ayen m weeni ate ni ŋman wom kama? Dai dii dai nama me dek a yaali kama ayen ni chim wa ŋaaŋviiriba.” ");
INSERT INTO bwu_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ba le wom dila la, ba yaa deri a tɔariŋ wa ayen, “Fi ka wala ŋaaŋviirima po wanyi, alege tama ka Moosis ŋaaŋviiriba. ");
INSERT INTO bwu_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tama seba ayen Naawen a jam a biisi ale Moosis kama dila po dila po, alege nuru waai ale lagi fi ninaŋa la, tama ze wa le nyini juijui la.” ");
INSERT INTO bwu_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nuruwa a yaa weeni ba ayen, “Nyaku de ka wakperikaliik mi jigi, nama a ze wa ale nyini juijui la alege wa lagi mi ninaŋa. ");
INSERT INTO bwu_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ti seba kama ayen Naawen a kan wom wabaata nyamma. Wa a wom ka baai ale a te wa zula ale a tom wa yaalika la. ");
INSERT INTO bwu_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","A nyini diipo ate Naawen a nyɛ tɛŋzuk meena la a ta jam paari jinla, nuru waai an diem a lagi nuru ate ba biak wa ale yiisa, nina. ");
INSERT INTO bwu_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nuruwa de a dan kan nyini Naawen jigiya wa ti an kan baga a nyɛ wari ya.” ");
INSERT INTO bwu_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ba yaa weeni wa ayen, “Fi nyamma a biak fu kama ate fi pak ale tuimbaata. Fi a poli ayen fi ale ta zupagruk a baga a sak tama?” Ba yaa yiak ate wa nyini ba tuka dɔkku po a nyini. ");
INSERT INTO bwu_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yeezu ale wom dii ale nyɛ la, wa yaa gisi a yik nuru waai ate wa tebi la a bek wa ayen, “Fi ta siaka ale Saalobiika?” ");
INSERT INTO bwu_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nuruwa a yaa weeni wa ayen, “M Nyɔnɔ, weeni a sak mu wa le ka waai la ate m ta siaka ale wa.” ");
INSERT INTO bwu_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yeezu a yaa weeni wa ayen, “Fi poom nya wa kama, waai ale a biisi ale fu la wala ale la.” ");
INSERT INTO bwu_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nuruwa a yaa domsi kali Yeezu niŋ a weeni ayen, “M Nyɔnɔ, m ta siaka ale fu.” ");
INSERT INTO bwu_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yeezu a yaa weeni wa ayen, “Mi jam tɛŋka de zuk kama ayen m basi ate baai nina ale kan lagri la, a lagri abe baai nina ale lagri la a yi.” ");
INSERT INTO bwu_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisiima baai ale jam mɔata dula jigini la ba gela a yaa wom wa le weeni dii la. Ba yaa weeni wa ayen, “Fi a yaali ayen fi weeni ka tama ayen tama nina an lagi ya?” ");
INSERT INTO bwu_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yeezu a yaa weeni ba ayen, “Ase nama ninaŋa a dan yi kama, mi ate kan weeni ayen ni nyɛ a kaasi, alege nama ale a weeni ayen ni ninaŋa a lagri alege ŋa an lagri la, ale soa ate mi a weeni ayen ni nyɛ kaasi la.” ");
INSERT INTO bwu_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Da ŋala po Yeezu a yaa magsi wamagsini ayen, “Wensie ate mi a weeni ni. Nuru waai a dan jo piisa zoŋ po alege an va zoŋku nɔanni a jo ya, kula nyɔnɔ ka zue. ");
INSERT INTO bwu_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nuru waai ale kasim a va zoŋku nɔanni a jo la, wala ale naapeerika dek. ");
INSERT INTO bwu_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Zoŋku nɔanni limsidɔwa a nyiem ale kasim a lak ku nɔanni a te naapeerika ate wa jo a wi wa piisaŋa yueŋa ate ŋa a va wa a nyini, dii nyiŋ la ŋa seba wa lueluku kama. ");
INSERT INTO bwu_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ŋa meena a yaa dan nyini, wa nyiem a yaa de ka ŋa niŋ ate ŋa a vi wa, dii nyiŋ la ŋa seba wa kama. ");
INSERT INTO bwu_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ŋa nyiem a kasim a va ka naapeerika nyiini. Nuru yoŋ a dan de ŋa niŋ, ŋa a chali kama a waaŋ chaab, dii nyiŋ la ŋa ze wa.” ");
INSERT INTO bwu_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yeezu ale magsi wamagsini a nueri la, baai ale jam a wom wa la an jam miŋ di kiri ya. ");
INSERT INTO bwu_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nyaku de nyiŋ, Yeezu a yaa ŋman weeni ba ayen, “Wensie ate mi a weeni ni. Mi a nyɛ se ka piisaŋa zoŋku nɔanni la. ");
INSERT INTO bwu_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nuru baai ale liŋ jam ale ge mi la a nyɛ se ka zueba la, ate piisaŋa an miŋ ba luelutaŋa. ");
INSERT INTO bwu_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mi a nyɛ se ka piisaŋa zoŋku nɔanni la, baai meena ale basi ate mi a vari ba ba tuimbaata po a basi la, a nyɛ se ka piisa ale kasim a jo ŋa zoŋku po ale a ŋman a nyini a de wuuk dii la. ");
INSERT INTO bwu_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Zue a nyiem jam kama ayen wa zu, abe wa ko, abe wa kaasi, alege mi a jam kama ayen ni nya nyuvuri dii ale kan ta kpeglimka la. Di ka nyuvuri maŋ kaai ate Naawen a pa a te ni. ");
INSERT INTO bwu_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Mi ale naapeerik maŋka waai ale gomsi a magsi a yaali ayen m kpi piisaŋa nyiŋ la. ");
INSERT INTO bwu_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ase ba dan pa nuru ayen wa a nya piisaŋa zuk, abe ba a tuni wa, wa kan nya ŋa nalimnyiini. Piuk a dan jam a jo ŋa po ayen ku yik ŋa, naapeerik kaai ate ba pai ate wa a nya ŋa zuk la, a chali kama, ale a ge ŋa, dii nyiŋ la daa wa dek ale soa ŋa. ");
INSERT INTO bwu_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ba ale a tuni wa ate wa a nya ŋa la nyiŋ ale soa ate wa kan zaani a vari ŋa a basi. ");
INSERT INTO bwu_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Mi ale naapeerik maŋka. M seba ŋa kama ate ŋa me a seba mu. ");
INSERT INTO bwu_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Siuk kula po me, mi seba m Kowa kama ate m Kowa me a seba mu. Mi a potim gomsi magsi kama ale m dek yaalika ayen m kpi a te m piisaŋa. ");
INSERT INTO bwu_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mi a soa piisa ŋa chaab kama, alege ate ŋa bo jigi yoŋ. Ku a fe ate m cheŋ dula jigini ate ŋa wom mi lueluku ate ŋa baga a va mu. Ŋa le jam a gum chaab ale nŋala ate ŋa meena a chim pa yena abe naapeerik yeŋ nyiini a nya ŋa zuk. ");
INSERT INTO bwu_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“M Kowa a yaali mu, dii nyiŋ la m le kasim a gomsi a magsi ayen m kpi la. M dan jam kpi, m le yiti kum po. ");
INSERT INTO bwu_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nuru karo a baga a ko mu ase ka mi dek a nin siak ate ba ko mu. M ta siuk a siak alege ta siuk a zɛri alege m Kowa ale weeni ayen m nyɛ dila.” ");
INSERT INTO bwu_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Farisiima ale ga wom Yeezu ale weeni dii la, ba yaa ta nampaga ale chaab. ");
INSERT INTO bwu_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ba yegayega a yaa weeni ayen, “Nuruwa de chichiribiok ale bo wa zukku po. Wa a yesim kama. Ka boa ate ni a wom wa?” ");
INSERT INTO bwu_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mbala me a weeni ayen, “Ase chichiribiok a dan bo nuruwa de zuk po, wa kan baga a biisi nna la. Chichiribiok an baga a nyɛ ate yeeba nina a lagri.” ");
INSERT INTO bwu_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ŋoota wein a dan jam paari, Juuma a nyiem a kasim a de ka tigi a teeri dai dii dai ate ba pai ba puusika yenni a nyo Naawen dek nisima po dila po dila po la. ");
INSERT INTO bwu_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Da ŋala sunsuŋ, Yeezu a yaa cheŋ va Juuma Puusika Yenni kusuŋ kuui ate ba a wi ayen Naawa Solomon Kusuŋku la. ");
INSERT INTO bwu_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yeezu a yaa jam a cheŋ ate Juuma ba gela a yaa ga tu wa a deri gilim wa a zaani ba sunsuŋ a bek wa ayen, “Ku ale paari ka dimpo ate fi ale weeni ti fi ale ka waai la? Be weeni ti wensie, ka fi ale varibasidɔwa ate Naawen ayen wa ale tom la?” ");
INSERT INTO bwu_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yeezu a yaa weeni ba ayen, “Mi poom a liŋ a weeni ni mi ale ka waai la kama, alege nama a ka siaka ale dii ate mi a weeni la. Tuim ŋaai ate mi a tom m Kowa pagrimu nyiŋ la, ale a sak ni ayen dii ate mi a weeni ni la ka wensie. ");
INSERT INTO bwu_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Alege ni ka siaka ale mi, dii la ni a nyɛ ka nna ase ni daa mi piisa la. ");
INSERT INTO bwu_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mi seba m piisaŋa kama ate ŋa me a seba m lueluku ale a va mu, ");
INSERT INTO bwu_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ate mi a pai nyuvuri dii ale kan ta kpeglimka la a te ŋa, ate Naawen a kan ŋman a te ŋa waalika abe wa basi ŋa ate ŋa kan ta kiriya. Nuru waai an baga a fe a vari ŋa mi jigiya. ");
INSERT INTO bwu_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mi Kowa waai ale pagra a gaam jaab buuri meena la, ale pa ŋa a nyo mi nisima po. Wala dek me abe kan basi ate waai a fe vari ŋa mi jigiya. ");
INSERT INTO bwu_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mi ale m Kowa ka bunyi.” ");
INSERT INTO bwu_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nuruma ale ŋman wom dii ate wa a weeni la, ba yaa pisi tintana ayen ba yuk wa. ");
INSERT INTO bwu_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yeezu a yaa weeni ba ayen, “Mi Kowa a basi kama ate mi tom tuimmaŋsa nna yegayega ate nama a nya. Be ka nyaŋa de di din dek nyiŋ ate nama a yaali ayen ni yuk mu a ko?” ");
INSERT INTO bwu_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nuruma a yaa weeni wa ayen, “Tama a kan yaali ayen ti ko fu fi tuimmaŋsa nyiŋŋa, alege fi me ka nurubiik ale ge fi pa fi dek a magsi chaab ale Naawen. Ka dila ale soa ate ti a yaali ayen ti ko fu la.” ");
INSERT INTO bwu_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yeezu a yaa weeni ba ayen, “Ba ŋmarisi Naawen gbaŋka po kama ayen nama ale mi ka bunyi. ");
INSERT INTO bwu_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ti seba ayen wa gbaŋka po wieŋa ka wensie diipo meena. Naawen weeni ayen baai ate wa pai wa wieŋa a te ba la ale wa ka bunyi. ");
INSERT INTO bwu_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Mi Kowa ale lueri mi a tom mu ate m jam tɛŋzuk de. Dila nyiŋ la mi a dan weeni ayen mi ka wa biik, ka boa ale soa ate nama a weeni ayen m le wa? ");
INSERT INTO bwu_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ni be kan ta siaka ale mu ase m nin kan a tom dii ate m Kowa a yaali la. ");
INSERT INTO bwu_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Alege m dan a tom ka m Kowa ale a yaali dii la, ni dan poom kan ta siak ale mu, ni ti an ta siaka ale m tuimaŋa ate ni seba a chak ayen m kowa a bo ale mu kama, ate mi me a bo ale m Kowa.” ");
INSERT INTO bwu_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Juuma kpaŋŋa a jam a yaali ayen ba yik Yeezu kama, alege wa baga a va ba po a taam nyini. ");
INSERT INTO bwu_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Wa le ga nyini la, wa yaa cheŋ a taam Jodan benni kuŋkɔŋini juijui ate Jɔɔn a jam a te nuruba soka la a bo dula. ");
INSERT INTO bwu_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nuruba yegayega a yaa jam wa jigi a weeni chaab ayen, “Jɔɔn an jam tom wakperikaliisa, alege wie ŋaai meena ate wa biisi nuruwa de wie la, ka wensie,” ");
INSERT INTO bwu_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ate nuruba yega deri ta siaka ale Yeezu dula jigini. ");
INSERT INTO bwu_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Nuru wanyi ale jam bo Betani tɛŋka ate ba a wi ayen Lazarus. Wa jam ta ka tɔaba baye, ba yue ale Mɛɛri ale Maata. Ba me a jam bo ka Betani tɛŋka. Ba wanyi wa Mɛɛri ale waai ale jam pa kpa buui ate bu nyummu a masa la, a kpiiri a basi nyɔnɔwa naŋsaŋa nyiŋ ale ge a yik wa zukku zuisaŋa a bili si la. Lazarus a yaa jam a yuak. ");
INSERT INTO bwu_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Wa tɔama a yaa tom weeni Yeezu ayen, “Ti Nyɔnɔ, fi dek dɔawa Lazarus ale a wiak.” ");
INSERT INTO bwu_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yeezu ale wom la, wa yaa weeni ayen, “Lazarus yuamu a dan poom ko wa, daa ku kpeglimka ale la. Ku nyɛ dila kama ayen nuruba a te Naawen ale wa biika zula nna yegayega.” ");
INSERT INTO bwu_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yeezu a jam a yaali Maata ale wa suoku ale Lazarus ka nna yegayega, ");
INSERT INTO bwu_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","alege wa ale wom Lazarus yuamu la wa yaa jam bo juijui ate wa boro la daa ŋaye. ");
INSERT INTO bwu_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Daa ŋayewa ale jam a taam la, wa yaa weeni wa ŋaaŋviirima ayen, “Ni basi ate ti ŋman cheŋ Judia tɛŋka.” ");
INSERT INTO bwu_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ba yaa weeni wa ayen, “Ti Sagrɔ, dula jigini ate nuruma a jam a yaali ayen ba yuk fu ale tintanaŋa la. Ku an diem beni ya ate fi a yaali ayen ti ŋman cheŋ dula?” ");
INSERT INTO bwu_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yeezu a yaa weeni ba ayen, “Wenbinni a dan pusi a ga siŋ, danni meena ale soa dii la ale la, yaa daa di? Mi a nyɛ se ka bolim la a te tɛŋzuk demma meena. Waai ale a cheŋ kantueŋ la, a kan nagi naŋ a lo, dii la wa ale a nya la nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Alege wa dan a cheŋ yok wa a nak ka naŋ a lo dii nyiŋ la wa kan nya.” ");
INSERT INTO bwu_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yeezu a yaa ŋman weeni ba ayen, “Ti dɔawa Lazarus a goa kama. M le cheŋ a ga nagi wa a yiti.” ");
INSERT INTO bwu_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Wa ŋaaŋviirima a yaa weeni wa ayen, “Ti Nyɔnɔ, wa be dan a goa kama, wa le nya nyiŋyɔgsa.” ");
INSERT INTO bwu_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ba jam a poli ayen Lazarus a sum doa a goa kama, alege ba jam ze ayen Yeezu ale weeni dii la kiri ale wa kpi kama. ");
INSERT INTO bwu_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yeezu a yaa biisi ku meena a lagri a sak ba ayen, “Lazarus a kpi kama. ");
INSERT INTO bwu_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nama nyiŋ mi sui a peenti kama ale mi ale kan bo dula jigini ale wa la, kula ale basi ate ni ta siaka ale mu. Ni te ti cheŋ wa jigi.” ");
INSERT INTO bwu_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yeezu ŋaaŋviirima po wanyiwa Tomasi ate ba a wi wa me ayen yibika la a yaa weeni wa ŋaaŋviiro chaama ayen, “Ni basi ate ti va ti sagrɔwa cheŋ, ate tama ale wa meena a maa chaab a kpi.” ");
INSERT INTO bwu_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yeezu ale wa ŋaaŋviirima ale ga paari Betani tɛŋka la, baai ale jam bo dula la a yaa weeni wa ayen ba le gu Lazarus la jinla a ta ka daa ŋanaansi. ");
INSERT INTO bwu_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani tɛŋka ale Jerusalem tɛŋka an jam yalima ale chaaba. ");
INSERT INTO bwu_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nyaku de nyiŋ ate Judia demma yegayega a jam dula jigini ayen ba puusi Maata ale Mɛɛri ba suoku kummu nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Maata ale ga wom ayen Yeezu a bo siuk a cheena la, wa yaa deri yiti a nyini ayen wa ga tu wa. Mɛɛri ale jam a wari kala yenni po. ");
INSERT INTO bwu_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maata a yaa ga tu Yeezu a weeni wa ayen, “M Nyɔnɔ, fi dan poom bo dela, m suoku ate an kpiya. ");
INSERT INTO bwu_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","M seba ayen jaab buuri meena ate fi a bek Naawen jigi la, wa le nyɛ te fu.” ");
INSERT INTO bwu_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yeezu a yaa weeni wa ayen, “Fi suoku a le yiti kum po.” ");
INSERT INTO bwu_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maata a yaa weeni wa ayen, “M seba ayen tɛŋka meena kpeglimka a dan jam paari, wa le yiti kum po.” ");
INSERT INTO bwu_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yeezu a yaa weeni wa ayen, “Mi ale waai ale baga a nak nuruba kum po a yiti ale ŋman a basi ate ba a nya nyuvuri la. Nuru waai a dan ta siaka ale mi ale ge kpi, m le basi ate wa yiti a nya nyuvuri. ");
INSERT INTO bwu_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Waai ale bo bo kaai choa ate Naawen a yaali la ale ta siaka ale mi la a kan kpi alege wa ale nya nyuvuri dii ale kan ta kpeglimka la. Fi ta siaka ale nyaku de?” ");
INSERT INTO bwu_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Wa yaa weeni wa ayen, “M Nyɔnɔ, m ta siaka. M be ŋman ta siaka ayen fi ale Varibasidɔwa, Naawen biika waai ate Naawen a weeni ayen wa le tom wa ate wa jam la.” ");
INSERT INTO bwu_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maata ale biisi a ga nueri la, wa yaa ŋman jo yenni po a ga wi Mɛɛri a ta taam nakpiak ba dek ba nyiini a weeni wa ayen, “Sagrɔwa a jam kama ale a yaali ayen wa nya fu.” ");
INSERT INTO bwu_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mɛɛri a yaa deri yiti a cheŋ Yeezu jigi. ");
INSERT INTO bwu_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yeezu an diem a jam jo tɛŋka po. Wa diem a jam za ka juijui ate Maata a tu wa la. ");
INSERT INTO bwu_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nuru baai ale jam ayen ba puusi Mɛɛri la, ale ga nya wa le yiti nna nwuli a nyini la, ba me a yaa yiti va wa, dii nyiŋ la ba a poli ayen wa a cheŋ ka juijui ate ba gu wa tɔawa la ayen wa kum. ");
INSERT INTO bwu_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mɛɛri a yaa cheŋ a ga tu Yeezu a domsi kali wa niŋ a weeni wa ayen, “M Nyɔnɔ, fi dan poom bo dela, m suoku ate an kpiya.” ");
INSERT INTO bwu_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yeezu ale ga nya ale Mɛɛri ale nuru baai ale jam va wa la, a kum la, ku yaa daani wa sui nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Wa yaa bek ba ayen, “Ka be ate ni gu wa?” Ba yaa weeni wa ayen, “Ti Nyɔnɔ, jam a nya.” ");
INSERT INTO bwu_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yeezu me yaa kum. ");
INSERT INTO bwu_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nuruma ale jam nya wa kumsaŋa la, ba gela a yaa weeni chaab ayen, “Wensie wa sum a yaali wa ka nna yegayega.” ");
INSERT INTO bwu_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Alege ba gela weeni ayen, “Daa nuruwa de ale jam a lagri nuruwa ninaŋa la, ku be nyɛ ka se ate wa an tebi Lazarus ale ge basi ate wa kpi?” ");
INSERT INTO bwu_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Lazarus ale jam a kpi la, ba jam a pa wa kama a nyo puŋ vorub po a yaa pai tintain a ligi vorumu nɔanni. Yeezu ale ga paari puŋku vorumu la, ba jiirim a yaa dari wa. ");
INSERT INTO bwu_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ate wa yaa weeni ba ayen, “Ni lagi tintanni a basi nakpiak.” Maata, Lazarus tɔawa, yaa deri weeni wa ayen, “M Nyɔnɔ, ti le gu wa la ka daa ŋanaansi jinla. Nna po de wa a nyuŋ kama.” ");
INSERT INTO bwu_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yeezu a yaa weeni wa ayen, “Mi an poom a liŋ a weeni fu ayen fi dan ta siaka ale mi, fi le nya Naawen pagrimu ale ka dii la?” ");
INSERT INTO bwu_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ba yaa bilim tintanni vorumu noai a basi ate Yeezu a yaa zak wa zukku a nya wenŋmazuk ale weeni ayen, “M Koa, mi a te fi jiam fi le kasim a wom mu la. ");
INSERT INTO bwu_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mi dek a seba ayen fi a wom mu kama, alege mi a biisi ale fu kama ate baai ale za dela ale mu la a nya ate ba baga a ta siaka ale mu ayen ka fi ale sum tom mu.” ");
INSERT INTO bwu_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Wa ale weeni dila la, wa yaa deri kaari a wi ayen, “Lazarus, yiti a nyini peelim.” ");
INSERT INTO bwu_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Wa yaa deri yiti a nyini peelim. Wa jam a yiti a nyini ale ka garuk guuŋku ate ku vili a gilim wa nisaŋa ale wa nimbidiaka ale wa naŋsaŋa meena. Yeezu a yaa weeni ba ayen, “Ni foli garuku abe ni ge wa ate wa cheŋ.” ");
INSERT INTO bwu_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nuru baai ale jam ayen ba puusi Mɛɛri ale Maata la, yega a jam nya dii ate Yeezu a tom la kama a yaa ta siaka ale wa. ");
INSERT INTO bwu_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Mbala me gela a chali cheŋ Farisiima jigi a ga weeni ba dii ale nyɛ la. ");
INSERT INTO bwu_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Farisiima ale ga wom ba le a weeni dii la, ba yaa wi Juuma Puusika Yenni kpaŋŋa ayen ba jam ate ba tigsi chaab a poli ba le ba nyɛ dii la. Ba yaa le jam la, ba yaa weeni chaab ayen, “Nuruwa de a tom ka tuimkperikaliisa nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ku a fe kama ate ti nyɛ nuruwa de wari. Ti dan basi ayen wa a tom wa le ta dii la, waai meena a le va wa kama. Ba dan va wa dila Aroom demma baai ale soa ti la, a le jam a kaasi ti Juuma Puusika Yenni abe ba ko ti meena.” ");
INSERT INTO bwu_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Juuma Puusika Yenni kpagi kpeeni Kayafas a yaa weeni ba ayen, “Nama waai a ka yammɔa. ");
INSERT INTO bwu_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nama a ze ayen ni dan basi ate nuruwa de a kpi te ti meena ku ale zunchoŋ ale ti meena ale kpi ya.” ");
INSERT INTO bwu_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Wa le jam a weeni dii la an nyini daa wa dek jigiya. Dii nyiŋ la wa jam ka Juuma Puusika Yenni kpagi kpeeni, wa jam a nyɛ se ka Naawen biisiteerɔma po wanyi ale jam a weeni ayen Yeezu a le kpi a te Juuma. ");
INSERT INTO bwu_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Daa dila nyiini alege Yeezu a dan kpi, Naawen nuruma baai meena ale waaŋ a bo tɛŋka meena zuk la, a le jam a tigsi chaab a chim bunyi. ");
INSERT INTO bwu_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","A nyini dai dila danni a cheŋ ba jam a gisi ka siuk ayen ba ko Yeezu. ");
INSERT INTO bwu_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yeezu ale ga wom dii ate ba a yaali ayen ba nyɛ la, wa an ŋman a nyiem Judia tɛŋka po. Wa ale wa ŋaaŋviirima a yaa basi dula jigini ale cheŋ ga bo tɛŋ kaai ate ba a wi ayen Ɛfraim ate ka mɔata goanni la. ");
INSERT INTO bwu_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Juuma Gaambasika Tigini ale jam mɔata la, nuruba yegayega a yaa basi ba tɛŋsa ale ge a cheŋ Jerusalem tɛŋka ayen ba liŋ gomsi kisita wie abe ba ge ate daaŋa a paari. ");
INSERT INTO bwu_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ba le ga paari dula jigini la, ba yaa nyiem a gisi Yeezu. Nuruma de ba gela a yaa tigsi chaab Juuma Puusika Yenni po a weeni chaab ayen, “Nama a poli ayen wa le jam a maa de tigini yaa wa kan jamu?” ");
INSERT INTO bwu_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Farisiima ale Juuma Puusika Yenni kpaŋŋa a weeni kama ate ku paari waai meena ayen waai a dan seba Yeezu boka jigi, kula nyɔnɔ a jam a weeni ba ate ba cheŋ a ga yik wa. ");
INSERT INTO bwu_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ku le jam tali daa ŋayuebi ate Juuma Gaambasika Tigini a paari la, Yeezu a yaa ŋman cheŋ Betani tɛŋka. Lazarus waai ate Yeezu a jam nak wa a yiti kumu po la yenni. ");
INSERT INTO bwu_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Lazarus tɔama a jam nyɛ ka ŋandiinta ayen ba de ate Yeezu ale Lazarus a yaa jam kala ale chaab ate Maata a yaa ta ŋandiintaŋa a jam te ba. ");
INSERT INTO bwu_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mɛɛri yaa ta kpaam ate bu nyum a masa ate bu ligraŋa me a pagra nna yegayega a nyo kpaam cheŋbili po. Ba le jam boro a de la, wa yaa ta bu a jam a pa bu meena a kpiiri a basi Yeezu naŋsaŋa nyiŋ a yaa le ge a yigi wa zukku zuisaŋa a bili si. Yenni meena a jam a sueri ale ka kpaamu nyummu. ");
INSERT INTO bwu_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yeezu ŋaaŋviirima po wanyi waai ate ba a wi ayen Judas Iskariot la, a yaa jam bo dula. Wala jam le waai a le wa ta Yeezu a ga bobri sak la. Wa le ga nya dii ate Mɛɛri a nyɛ la, wa yaa weeni ba ayen, ");
INSERT INTO bwu_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ase nipowa de a dan poom a pa kpaamu de a da, wa te le nya ligra yega a pa te ŋanjagsaŋa.” ");
INSERT INTO bwu_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas niŋ a jam karo ale ŋanjagsa maarika, dii nyiŋ la wa jam ka zue. Wala ale jam a nya Yeezu ŋaaŋviirima ligraŋa zuk ale a pa ŋa gela a maari wa dek. ");
INSERT INTO bwu_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yeezu a yaa weeni wa ayen, “Basi wa abe fi kan a daani wa. Wa liŋ a de ka niŋ a kpiiri kpaamu de a nyo mi nyiŋka a gomsi mu a magsi m guka. ");
INSERT INTO bwu_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ŋanjagsa a kasim bo ale ni kama, alege mi a kan bo ale ni a beni.” ");
INSERT INTO bwu_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nuruba yega ale jam wom ayen Yeezu a bo Betani tɛŋka la, ba yaa cheŋ ayen ba nya wa. Ba jam a yaali kama ayen ba nya Lazarus waai ate Yeezu a nak wa kum po a yiti la me. ");
INSERT INTO bwu_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Juuma Puusika Yenni kpaŋŋa ale jam a gisi siuk ayen ba ko Yeezu la, a jam a yaali ayen ba ko Lazarus kama me. ");
INSERT INTO bwu_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Dii nyiŋ la Juuma ba yega a jam a basi ba kpaga ale ge a ta ka siaka ale Yeezu wa ale nagi Lazarus a yiti kumu po la. ");
INSERT INTO bwu_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Vari ale veenti la nuru bɔanni ale jam ayen ba maa de Gaambasika Tigini la, a yaa wom ayen Yeezu a cheena Jerusalem. ");
INSERT INTO bwu_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ba yaa ŋasi kpinkparuk vaata a tu wa ale a kaari a weeni ayen, “Ti a pak Naawen! Naawen a niak waai ale cheena Nyɔnɔwa yonni nyiŋ la! Naawen a niak Izirali naawa.” ");
INSERT INTO bwu_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yeezu yaa yaali boniŋ a doa ase ba ale ŋmarisi Naawen gbaŋka po ayen, ");
INSERT INTO bwu_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Nama Jerusalem demma ni kan chali yɔgsumɔa, ni naawa ale la a doa bombiik a cheena ni jigi.” ");
INSERT INTO bwu_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yeezu ŋaaŋviirima an jam a miŋ nyaku de kiri ya alege, ka wa le jam a kpi a ŋman yiti kum po a jueli wenŋmazuk la, ale basi ate ba yaa teeri dii ate ba jam a ŋmarisi la kiri. ");
INSERT INTO bwu_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nuru baai ale jam boro a nya Yeezu ale nagi Lazarus ate wa yiti kum po la, ale weeni dii ale nyɛ la a sak nuruma. ");
INSERT INTO bwu_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ka dila ale soa ate nuruba yegayega a jam nyini a tu Yeezu la. Ba jam wom kama ayen wa ale tom wakperikaliika de. ");
INSERT INTO bwu_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Farisiima yaa weeni chaab ayen, “Wa a yaali ayen wa gaam ti kama. Ni nya nuruma de meena ale soa dii a va wa la.” ");
INSERT INTO bwu_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Va ŋala po me nuruba gela ate ba a wi ayen Girik ale jam ayen ba maa de Gaambasika Tigini. ");
INSERT INTO bwu_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ba yaa jam Yeezu ŋaaŋviirima wanyi ate ba a wi ayen Filip la jigi. Wa jam nyini ka Beteseida ate ka bo Galili tɛŋka la. Ba yaa weeni wa ayen, “Ti Nyɔnɔ, ti a yaali kama ayen ti nya Yeezu.” ");
INSERT INTO bwu_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip a yaa ga weeni Andiru ate ba noai bayewa a yaa va chaab a ga weeni Yeezu. ");
INSERT INTO bwu_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yeezu a yaa weeni ba ayen, “Ku danni a paari kama ate Saalobiika ale nya zula ale nalim yegayega. ");
INSERT INTO bwu_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Wensie ate mi a weeni ni. Fi dan ka pai biri a bori ya di ka di dek di nyiini alege fi dan bori, di a poak kama alege a nyini a be a nya bie yegayega. ");
INSERT INTO bwu_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nuru baai niŋ ale kan karo ale ba dek nyuvooŋa la, Naawen a le pa wa nyuvuri dii ale kan ta kpeglimka la a te ba. Nuru baai me niŋ ale boro ale ba dek nyuvooŋa la ale jok ŋa. ");
INSERT INTO bwu_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Baai ale a yaali ayen ba tom a te mi la a jam a va mi ate ba a bo juijui meena ate mi a boro la. Ba dan nyɛ dila, m kowa a le te ba zula.” ");
INSERT INTO bwu_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yeezu ale biisi a ga nueri la, wa yaa weeni ba ayen, “M sui a kasim kaasi kama. Yɔgyɔgla de mi ze m nin weeni dii la. M weeni ayen m Koa yeeri mu a ta nyini ninammu de po yaa. Alege mi ale jam dii nyiŋ la ale la ayen m jo ninammu de po.” ");
INSERT INTO bwu_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Dula jigini wa yaa puusi a te Naawen ayen, “M Koa, basi ate nuruba a te fu zula.” Wa le weeni dila a ga nueri la, ba yaa deri a wom lueluk wenŋmazuk a weeni ayen, “Mi poom a liŋ basi ate nuruba a te mi zula kama ale ge m le ŋman a basi ate ba nyɛ dila dek.” ");
INSERT INTO bwu_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nuru bɔanni baai ale jam za dula jigini la a yaa wom lueluku ate ba gela a yaa weeni chaab ayen, “Ku a nyɛ ase ka wein ale a kum la.” Mbala me a weeni ayen, “Ka Naawen sabiilo ale a biisi ale wa.” ");
INSERT INTO bwu_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","32","Yeezu a yaa weeni ba ayen, “Wie ŋaai ate ni a wom la daa mi nyiŋŋa, alege ka nama nyiŋ ate Naawen a biisi. Dai dii danni ate Naawen a yaali ayen wa bo tɛŋzuk meena demma buusa abe wa nak Sitaana waai ale soa ba la, a yiak la, a mɔata kama. Ba dan yik mi a kpi jabarimu nyiŋ, m le basi ate nuruba yegayega a jam m jigi.” ");
INSERT INTO bwu_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Wa ale weeni ku de la a jam a sak ka wa le wa nam dii a kpi la.) ");
INSERT INTO bwu_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nuru bɔanni yaa weeni wa ayen, “Ba ŋmarisi Naawen gbaŋka po ayen Varibasidɔwa waai ate Naawen a weeni ayen wa le tom la, a le boro kama diipo meena wuu. Ka boa ale soa ate fi a weeni tama ayen nuruba a le yik Saalobiika a kpi jabarim nyiŋ ate wa kpi? Saalobiika de ka wana?” ");
INSERT INTO bwu_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yeezu a yaa weeni ba ayen, “Mi a nyɛ ase ka bolim ate ba tɔati ate m bo ale ni la. Ni be kasim a cheŋ ale bu diem a nya ate legini a kan paari ni. Waai ale a cheŋ legi po la a ze wa ale a cheŋ juijui la. ");
INSERT INTO bwu_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ni be a ta siaka ale mi waai ale a nyɛ ase bolim la ale m diem bo ale ni, ate ni chim m bisa.” Yeezu ale biisi a nueri la, wa yaa cheŋ a ga suk. ");
INSERT INTO bwu_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yeezu a jam tom ka wakperikaliisa nna yegayega nuruma meena nimbie, alege ba yegayega a jam ka siaka ale wa. ");
INSERT INTO bwu_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ka dila ale soa ate dii ate Naawen biisiteerɔ Azaya a jam ŋmarisi Naawen gbaŋka po dila po dila po la, a chim wensie la. Wa ŋmarisi ayen, “M Nyɔnɔ, ka wana ale ta siaka ale wie ŋaai ate tama sak la? Nyɔnɔwa a sak wa pagrimu ale ka wana?” ");
INSERT INTO bwu_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Azaya a ŋman ŋmarisi baai ale jam kan ta siaka ale Yeezu la wie ayen, ");
INSERT INTO bwu_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Naawen ale ligi ba ninaŋa ale ba popolaŋa me ate ba ninaŋa a kan nya, ate ba popolaŋa me a kan miŋi, ate ba kan baga a tagri, ate m voŋ ba tuimbaataŋa a te ba.” ");
INSERT INTO bwu_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Azaya ale jam nya Yeezu zulaŋa ale wa nalimu la ale soa ate wa ŋmarisi nyaku de la. ");
INSERT INTO bwu_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Juuma kpaŋŋa yega a jam ta siaka ale Yeezu kama, alege ba an jam a biisi wa wie a lagri, dii nyiŋ la Farisiima ale yiak ba ba tuka diinaŋa po. ");
INSERT INTO bwu_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Juuma kpaŋŋa a yaali kama ayen nuruba a te ba zula a gaam ba le a yaali ayen Naawen a te ba zula dii la. ");
INSERT INTO bwu_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Dula jigini Yeezu a yaa basi ate wa lueluku a jueli a weeni nuru bɔanni ayen, “Nuru waai ale ta siaka ale mi la, a ta siaka ale Naawen waai ale tom mu la me kama. ");
INSERT INTO bwu_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nuru waai ale nya mi la, a nya Naawen waai ale tom mu la me kama. ");
INSERT INTO bwu_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mi a jam tɛŋka de zuk meena kama ase bolim la ayen baai meena ale ta siaka ale mi la a kan ŋman bo legi po. ");
INSERT INTO bwu_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mi a kan bo baai meena ale a wom mi wieŋa ale kan va ŋa la buusa. Mi an jam ayen m bo ka tɛŋka meena demma buusa, alege m jam ayen m vari ba ka ba tuimbaataŋa po a basi. ");
INSERT INTO bwu_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tɛŋzuk meena kpeglimka a dan jam paari, wie ŋaai ate mi a biisi la a le bo nuru baai meena ale a zɛri mi ale m wieŋa la buusa. ");
INSERT INTO bwu_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mi ale a sak nama wie ŋaai la an nyini daa mi dek jigiya, alege m Kowa waai ale tom mu la ale te mu wieŋa ayen m sak ni. ");
INSERT INTO bwu_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Wie ŋaai meena ate wa pa te mu la mi pa ŋa a sak ni kama. Wa wieŋa a te ka nyuvuri dii ale kan ta kpeglimka la.” ");
INSERT INTO bwu_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ku jam tali ka dai yeŋ ate Gaambasika Tigini a paari. Yeezu a jam seba ayen wa yikka danni a mɔata kama ate wa basi tɛŋzuk de abe wa ŋmani a cheŋ wa kowa jigi. Wa jam kasim a yaali baai ale bo tɛŋka po ate wa soa la kama a ga paari wa kum. ");
INSERT INTO bwu_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Wenni ale jam a siŋ ate tɛŋka a sobi la, Yeezu ale wa ŋaaŋviirima a yaa jam boro a de yok ŋandiinta. Velinvendika a poom basi ate Judas Iskariot, Simon biika a ta ka popola ayen wa bobri Yeezu a sak. ");
INSERT INTO bwu_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yeezu a jam seba ayen wa kowa waai ale tom wa ate wa jam tɛŋzuk de la, ale pa jaab buuri meena pagrim a te wa. Wa be jam a seba me ayen wa nyini ka Naawen jigi a jam, alege ŋman pilim a cheŋ Naawen jigi. ");
INSERT INTO bwu_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ba le diem boro a de la, Yeezu a yaa yiti ŋmai a yeeri wa garuk kuui ate wa jo a basi ŋmai la a dueni tɛŋ ale ge a pai papa a bobi wa chiaka. ");
INSERT INTO bwu_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Wa yaa ŋari nyiam a nyo chin kpien po a pa ta nyiem a sugri wa ŋaaŋviirima naŋsaŋa a gilim ale a bili si ale papawa. ");
INSERT INTO bwu_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Wa ale sugri a ga paari Simon Piita la Piita a yaa weeni wa ayen, “M Nyɔnɔ, fi ayen fi sugri mi naŋsaŋa kama?” ");
INSERT INTO bwu_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yeezu a yaa weeni wa ayen, “Fi ze dii ate mi a nyɛ a te fu yɔgyɔgla de la kiriya, alege ku dan ga nyɛ maga, fi le miŋ di kiri.” ");
INSERT INTO bwu_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piita yaa weeni wa ayen, “Mi a kan basi ate fi a sugri mi naŋsaŋa diipo diipo.” Yeezu a yaa weeni wa ayen, “Fi dan kan basi ate mi a sugri si, fi kan ŋman a maa chim mi ŋaaŋviirima po wanyi.” ");
INSERT INTO bwu_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Piita a yaa deri kpabi tulisi wa ayen, “Ku be dan ka dila, be kan sugri m naŋsaŋa nyiini, maa sugri m nisimaŋa ale m zukku meena me.” ");
INSERT INTO bwu_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yeezu a ŋman weeni wa ayen, “Fi dan so fi nyiŋka a be, ka nala kama, alege fi dan ŋman cheŋ a ga jigi, fi naŋsaŋa a daŋ kama. Si le daŋ la, fi yaa sugri ka fi naŋsaŋa nyiini.” Wa le biisi ale Piita a nueri la, wa yaa ŋman chiem wa ŋaaŋviirima jigi a weeni ba ayen, “Yɔgyɔgla de ni suniima meena a nala kama, alege ka ni po wanyi sunum ale daŋi.” ");
INSERT INTO bwu_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yeezu a poom seba waai dek a le wa ta wa a ga bobri a sak la kama, dila ale soa ate wa weeni dila la. ");
INSERT INTO bwu_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yeezu ale sugri ba naŋsaŋa a nueri la, wa yaa pa wa garuku a ŋman jo ale pilim cheŋ wa kalika jigini a weeni ba ayen, “Ni miŋ dii ate m nyɛ a te ni la kiri ya? ");
INSERT INTO bwu_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nama a kasim a wi mi ayen ka ni sagrɔ ale ni nyɔnɔ. Kula a magsi kama, dii nyiŋ la mi sum ka ni sagrɔ ale ni nyɔnɔ. ");
INSERT INTO bwu_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mi waai ale ka ni nyɔnɔ ale ni sagrɔ la, ale sugri ni naŋsaŋa. Nama dek me a sugri chaab naŋsa. ");
INSERT INTO bwu_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mi a nyɛ ka magsa a sagi ni ayen ni a va. ");
INSERT INTO bwu_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Wensie ate mi a weeni ni. Yomo a kan zuagi a gaam wa nyɔnɔ. Tomteerɔ me an baga a zuagi a gaam waai ale tom wa la. ");
INSERT INTO bwu_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Yɔgyɔgla de ate ni seba wensieŋa la ni sue a le peenti ase ni nin a nyɛ dila. ");
INSERT INTO bwu_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Mi ale a biisi dii ale ni la, daa ni meena ate mi a weeni, alege ka baai nyiini ate m lueri a te m dek la. Ba ŋmarisi Naawen gbaŋka po ayen, ‘Waai a le wa ta mu a ga bobri a sak la, wala ate mi ale wa a de ŋandiintaŋa ale chaab.’ Ba le ŋmarisi wieŋa de dii la, a le jam a chim ka wensie. ");
INSERT INTO bwu_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Dila nyiŋ la, m liŋ a weeni ni kama, ayen ku dan jam boro a nyɛ, ni ta siaka ale mi ale weeni ayen m ka waai la. ");
INSERT INTO bwu_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Wensie ate mi a weeni ni. Baai meena ale a te waai ate mi a tom la, tia la, a te ka mi tia dila. Baai meena ale a te mi tia me la, ba a te ka waai ale tom mu la tia dila.” ");
INSERT INTO bwu_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yeezu ale biisi a nueri la, ku yaa daani wa, wa sunum po nna yegayega. Wa yaa weeni wa ŋaaŋviirima ayen, “Wensie ate mi a weeni ni, ni po wanyi a le wa ta mu a ga bobri sak.” ");
INSERT INTO bwu_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ba yaa deri gisi a nya chaab ale a poli le ka waai dek la. ");
INSERT INTO bwu_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Waai ate Yeezu a jam a yaali ba po nna yegayega la a jam kala kama a mɔata wa. ");
INSERT INTO bwu_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Piita a yaa magsi a weeni wa ayen wa bek Yeezu a miŋ waai dek a le wa nyɛ wa dila la. ");
INSERT INTO bwu_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Waai ate Yeezu a jam a yaali nna yegayega la, a yaa forisi paari a bek wa ayen, “M Nyɔnɔ, ka wana dega?” ");
INSERT INTO bwu_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yeezu a yaa weeni wa ayen, “Waai ate mi a pa boroboruku a siuk jentaŋa a te wa la, wa le la.” Wa yaa deri pa boroboruk a siuk jentaŋa a te Judas Iskariot, Simon biika. ");
INSERT INTO bwu_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas ale ga tuesi boroboruku la, Sitaana a yaa deri a jam jo wa popola po ate ŋa tagri. Yeezu a yaa weeni wa ayen, “Cheŋ nwuli a ga nyɛ dii ate fi ta la.” ");
INSERT INTO bwu_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Baai ale jam a tigsi ale wa a boro a de ŋandiintaŋa la, an jam a miŋ wa le weeni dii la kiriya. ");
INSERT INTO bwu_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas a jam ale waai ale a nya ba ligraŋa zuk la. Dila nyiŋ la, ba jam a poli kama ayen Yeezu a tom wa kama ayen wa cheŋ a ga da ŋanta a magsi tigini, yaase wa te niwomma ligra. ");
INSERT INTO bwu_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas ale ga tuesi boroboruku la, wa yaa deri yiti a nyini a cheŋ. Ku jam ka yok ate wa nyini la. ");
INSERT INTO bwu_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","32","Judas a yaa le cheŋ a ga nueri la, Yeezu a yaa weeni wa ŋaaŋviirima mbala ayen, “Nuruba yegayega a le ba te Naawen pimpauk dii ate nuruba ayen ba nyɛ mi la nyiŋ. Diipo ate Naawen ayen wa pa wa zulaŋa ale wa nalimu yegayegaka a te mi Saalobiika la a mɔata kama. Ku kan beni ate wa nyɛ ku. ");
INSERT INTO bwu_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","M bisa, mi a kan bo ale ni ate ku beni. M dan cheŋ, ni le nyiem a gisi m boka jigi. Ni teeri diipo ate m weeni Juuma kpaŋŋa ayen ba kan baga a va mu a cheŋ juijui ate mi a cheŋ la. Ni kan baga a cheŋ juijui ate mi a cheŋ la. ");
INSERT INTO bwu_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Sinsak paali ate mi a yaali ayen ni va. Ni a yaali chaab nalimnyiini. Mi ale yaali ni a soa dii la ni a yaali chaab dila. ");
INSERT INTO bwu_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ni daa yaali chaab dila, waai meena a le seba ayen ni ka mi ŋaaŋviiriba.” ");
INSERT INTO bwu_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Piita a yaa bek wa ayen, “M Nyɔnɔ, fi a cheŋ ka be?” Yeezu a yaa weeni wa ayen, “Fi kan baga a va mu a cheŋ yɔgyɔgla de, alege ku dan ga nyɛ maga, fi le baga a va mu.” ");
INSERT INTO bwu_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piita a ŋman bek wa ayen, “M Nyɔnɔ, ka boa ale soa ate mi an baga a va fu yɔgyɔgla de? Mi a gomsi a magsi kama ayen m kpi fi nyiŋ.” ");
INSERT INTO bwu_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yeezu a yaa bek wa ayen, “Fi sum gomsi a magsi ayen fi kpi mi nyiŋŋa? Wensie ate mi a weeni fu. Fi le weeni nuruba ku noai buta yokku de ayen fi ze mi abe varikpadiaka a kum.” ");
INSERT INTO bwu_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Dula jigini Yeezu a yaa weeni wa ŋaaŋviirima ayen, “Ni kan basi ate wari a daani ni, ni suniima po. Ni ta siaka ale Naawen abe ni ta siaka ale mi. ");
INSERT INTO bwu_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mi Kowa boka jigini a ta ka diina nna bɔari bɔari ya. Mi abe pilim a cheŋ ku jigini kama, ayen m gomsi jigi a te ni. Ase ku dan kan daa dila, m te kan weeni ni. ");
INSERT INTO bwu_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","M dan gomsi ŋa a nueri, m le ŋman jam a ta ni a cheŋ ku jigini ate nama ale mi a maa chaab a bo jigi yeŋ. ");
INSERT INTO bwu_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ni seba mi ale a cheŋ juijui la kama ale siuk kuui ale a cheŋ ku jigini la.” ");
INSERT INTO bwu_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi a yaa weeni wa ayen, “M Nyɔnɔ, tama a diem ze juijui dek ate fi a cheŋ la. Ti be ti nyɛ ka se a seba siuk kuui ale a cheŋ dula jigini la?” ");
INSERT INTO bwu_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yeezu a yaa weeni wa ayen, “Mi ale siuk kuui ale a cheŋ dula la ale ŋman chim wensie ale nyuvuri dii ale kan ta kpeglimka la nyɔnɔ. Nuru waai an baga a cheŋ mi Kowa jigiya ase ka wa nin va mi jigi. ");
INSERT INTO bwu_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nama ale seba mi ale ka waai yɔgyɔgla de la, kula le basi ate ni seba m Kowa ale ka waai la me. A nyini jinla a ta a cheŋ ni yaa nya wa kama ale seba wa.” ");
INSERT INTO bwu_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip a jam diem ze wa le a biisi dii la kiriya. Wa yaa weeni wa ayen, “M Nyɔnɔ, tama ale a yaali dii nyiini la ale fi basi ate ti nya fi Kowa.” ");
INSERT INTO bwu_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yeezu a yaa weeni wa ayen, “Tama a bo le chaab ate ku beni kama alege fi a ze mi? Waai meena ale nya mi la, a nya m Kowa kama. Ka boa ale soa ate fi weeni ayen m dak m kowa a sak ni? ");
INSERT INTO bwu_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Fi ka siaka ayen mi a bo ale m Kowa ate m Kowa me a bo ale mu? Mi ale sagi ni wie ŋaai meena la an nyini daa mi dek jigi ya. M Kowa waai ale bo ale mu la, ale a tom wa tuimaŋa.” ");
INSERT INTO bwu_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yeezu a yaa cheemu a weeni wa ŋaaŋviirima meena ayen, “Ni ta siaka ayen m Kowa a bo ale mu kama ate mi me a bo ale wa. Be dan kan daa di ni be ta siaka ale m tuimkperikaliik sii ate ni nya ale maa tom la nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Wensie ate mi a weeni ni, baai ale ta siaka ale mi la a le ba a tom dii ate mi a tom la. Bala dek a le tom tuimkperikaliisa a gaam dii ate mi a tom la, dii nyiŋ la mi a le ŋmani a cheŋ m Kowa jigi la. ");
INSERT INTO bwu_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ni dan juisi jaab buuri meena mi yonni nyiŋ m le nyɛ a te ni ate nuruba a va mi nyiŋ a nya Naawen zulaŋa. ");
INSERT INTO bwu_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ni basi ate m ŋman a weeni ni, jaab buuri meena ate ni a juisi ayen mi a nyɛ a te ni mi yonni nyiŋ la, m le nyɛ. ");
INSERT INTO bwu_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ni dan a yaali mu, ni le va dii ate mi a weeni ni la. ");
INSERT INTO bwu_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Mi le saalim m Kowa ate wa te ni Maaro wa choa ate wa kasim a bo ale ni. ");
INSERT INTO bwu_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Wa ka Chiik kaai ale wa sak Naawen ale ka waai la. Tɛŋzuk demma a kan siak ayen wa ka ba Maaro, dii nyiŋ la ba kan nya wa, ba be ze wa. Alege nama seba wa kama, dii nyiŋ la wa bo ale ni kama. ");
INSERT INTO bwu_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“M kan basi ni, ni dek ni nyiini. M le ŋman jam ni jigi. ");
INSERT INTO bwu_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Dai dii danni ate tɛŋzuk de meena demma a kan ŋman nya mu la a mɔata kama, alege nama a le ŋman nya mu kama. Mi abe nin kasim a boro la nama me ale kasim boro. ");
INSERT INTO bwu_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Dai dila danni a dan pari, ni le seba ayen mi bo ale ka m Kowa ate nama a bo ale mi ale ge ate mi me a bo ale nama. ");
INSERT INTO bwu_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Baai ale a wom mi wieŋa ale a va ŋa la a sak kama ayen ba a yaali mu. Mi me a le pa m dek a sak ba abe mi a yaali ba. Ba le a yaali mu la nyiŋ, m Kowa me a le yaali ba.” ");
INSERT INTO bwu_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nuru wanyi ale jam bo dula jigini ate ba a wi wa ayen Judas, alege wa daa Judas Iskariot waai ale ta Yeezu a ga bobri sak la. Wa yaa weeni Yeezu ayen, “M Nyɔnɔ, fi le nyɛ ka se a pa fi dek a sak tama nyiini alege daa tɛŋka meena demma?” ");
INSERT INTO bwu_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yeezu a yaa weeni wa ayen, “Baai ale a yaali mi la a va ka m sinsaŋŋa. Bala me ate m Kowa a yaali ate mi ale wa a jam bo ba suniimaŋa po. ");
INSERT INTO bwu_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Baai ale kan a yaali mi la a kan va m sinsaŋŋa. Mi ale a sak ni dii la an nyini daa mi dek jigiya, alege ka m Kowa waai ale tom mu la jigi. ");
INSERT INTO bwu_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Mi ale diem bo ale ni la, ale soa ate mi a weeni ni wieŋa de. ");
INSERT INTO bwu_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","M Kowa a le tom Maarowa waai ale ka Naawen Chiika la ate ka jam mi yonni nyiŋ a sak ni abe wa teeri ni dii meena ate mi a weeni ni la. ");
INSERT INTO bwu_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Mi a le basi ate ni ta suyɔgini ase mi dek jigi ale ka dii la. Suyɔgini dii ate mi ayen m te ni la ka di tɔga ale tɛŋka meena demma suyɔgini. Ni kan a yiili abe ni a chali yɔgsumɔa. ");
INSERT INTO bwu_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mi poom a liŋ weeni ni kama ayen m le cheŋ m Kowa jigi abe m ŋman pilim jam. Ase ni dan sum a yaali mu, ni sue a le peenti, ale m ale a cheŋ m Kowa jigi la dii la m Kowa a zuak kama a gaam mi. ");
INSERT INTO bwu_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mi a weeni ni wieŋa de kama abe ŋa ge a jam nyɛ, ate ŋa dan jam a nyɛ abe ni ta siaka ale mu. ");
INSERT INTO bwu_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mi kan yaali ayen m biisi wa bɔari ale ni, dii nyiŋ la Sitaana waai ale soa tɛŋzuk de meena demma la, a cheena kama. Wa ka pagrim mi zuwa. ");
INSERT INTO bwu_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Alege tɛŋka meena demma a le seba ayen mi a yaali m Kowa kama, dila me abe ni soa ate mi a tom wa dii meena ate wa a weeni mu la. “Ni basi ate ti yiti a cheŋ jigi yoŋ.” ");
INSERT INTO bwu_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yeezu yaa ŋman weeni ba ayen, “Mi a nyɛ se ka tiib la. Mi Kowa me a nyɛ se ka nuru waai ale a nya tiimu zuk la. ");
INSERT INTO bwu_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Wa nyiem a kasim a gebi naŋ sii ale kan a yoani la a basi kama ale a gebi sii ale a yoani la a magsi chaab ate si a yoani yoana yega. ");
INSERT INTO bwu_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Naawen a poom liŋ sugri ni suniimaŋa kama ale wie ŋaai ate mi a sagi ni la. ");
INSERT INTO bwu_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ni be kasim a bo ale mi ate mi me a bo ale ni. Naŋ a kan baga yoani yoana ka dega, ka naŋka a nin bo kinni nyiŋ ale ka baga a yoani. Siuk kula po ni dan kan bo ale mi ni kan baga a nyɛ wariya. ");
INSERT INTO bwu_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Mi ale kinni alege nama a chim naŋsaŋa. Waai ale bo ale mi ate mi me a bo ale wa la ale yoani yoana yega. Ni kan baga a nyɛ wariya ase mi nin kan bo ale ni. ");
INSERT INTO bwu_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Waai ale kan bo ale mi la m Kowa a le gebi wa a basi ase tiib naŋsa la, naŋ sila a dan ko ba tigsi si kama a nyo bolim po a ju. ");
INSERT INTO bwu_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ni dan bo ale mi ate m wieŋa a bo ale ni, ni dan juisi jaab buui ate ni a yaali la Naawen a le te ni. ");
INSERT INTO bwu_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ni dan a yoani yoana kula a le sak ayen ni ka mi ŋaaŋviiriba ate m Kowa a nya zula. ");
INSERT INTO bwu_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mi a yaali ni ase ka m Kowa ale a yaali mu dii la. Ni kasim a ta yaalika ale mu. ");
INSERT INTO bwu_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ni dan tom a va mi yaalika m le kasim a yaali ni ase mi ale a tom a va m Kowa yaalika ate wa yaali mu dii la. ");
INSERT INTO bwu_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Mi a weeni ni wieŋa de kama ayen ni ta supeentik kaai ate mi ta la. ");
INSERT INTO bwu_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Sinsak paali ate mi a yaali ayen ni va di. Ni a yaali chaab ase mi ale yaali ni dii la. ");
INSERT INTO bwu_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nuru waai a dan zaani wa dɔaba naŋkula po a kpi a te ba, yaali kaai ate wa ta ale wa dɔama la a gaam jaab buuri meena kama. ");
INSERT INTO bwu_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ni dan a va dii ate mi a sak ni la, ni ka mi dɔaba. ");
INSERT INTO bwu_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Wie ŋaai meena ate m Kowa a weeni mu la, ŋala ale mi a pa weeni ale ni. Ka dila ale soa ate mi a weeni ayen ni ka m dɔaba la. Mi a kan yaali ayen m ŋman weeni ayen ni ka mi tuimtomdɔba, dii nyiŋ la tuimtomdɔ a ze wa nyɔnɔ ale ta dii la. ");
INSERT INTO bwu_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Daa nama ale lueri mi ayen m chim ni nyɔnɔ, alege ka mi ale lueri nama ayen ni a tom tuimmaŋsa ŋaai ale kan a kaasi la a te mu. Ni dan tom ŋa dila ni le baga a pa mi yonni nyiŋ a juisi ŋanta baai ate ni a yaali la m Kowa jigi ate wa te ni. ");
INSERT INTO bwu_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Wa dii ate mi a chiib a weeni ni la ale ni kasim a yaali chaab nalimnyiini. ");
INSERT INTO bwu_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ase tɛŋka meena demma a dan kisi ni mi ŋaaŋ vaka nyiŋ, ni be teeri ayen ka mi ate ba jam a liŋ kisa. ");
INSERT INTO bwu_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ase nama ale tɛŋka meena demma a dan jam bo ka jigi yeŋ ale chaab, ba te a yaali ni kama, alege ka mi ale lueri ni ate nama ale ba an bo ale chaab la ale soa ate ba kisi ni. ");
INSERT INTO bwu_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ni teeri dii ate m weeni ni ayen yomma an baga a zuak a gaam wa nyɔnɔ la. Ba jam a daani mi ka nna yegayega. Dila dek dek ate ba a yaali ayen ba daani nama me la. Ba dan wom mi sinsaŋŋa kama, ba te le wom nama sinsaŋŋa me. ");
INSERT INTO bwu_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ba le daani ni dii nyiŋ la ba ze waai ale tom mi la. Ba le ŋman a daani ni, ni ale a va mi la nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","M jam kama ayen m weeni ba ate ba basi ba wabaataŋa siuku vaka, alege ba zɛri. Dila nyiŋ Naawen a dan bo ba buusa ayen ba lo ya, ba an ŋman baga a weeni wari ale wa. ");
INSERT INTO bwu_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Waai ale kisi mi la, a kisi m Kowa me kama. ");
INSERT INTO bwu_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mi tom ka tuimkperikaliik sii ate waai an baga a tom la, ba nimbie po. Dila nyiŋ Naawen a le weeni ba ayen ba nyɛ kaasiya. Ba dek a nya ŋaai meena ate mi a nyɛ la kama ale ba nimbie alege ba diem kisi mi ale m Kowa. ");
INSERT INTO bwu_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ba kisi mu nna la kama ayen dii ate ba ŋmarisi Naawen gbaŋka po dila po dila po la a chim wensie. Ba ŋmarisi ayen, ‘ba kisi mu kama kinla nyiŋ.’ ");
INSERT INTO bwu_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Mi poom a liŋ weeni ni kama ayen Maarowa waai ale ka Naawen Chiika la ale pai Naawen wensie wieŋa a sak ni, wa abe le nyini ka m Kowa jigi. M le tom wa ate wa nyini m Kowa jigi a jam a biisi mi wie. ");
INSERT INTO bwu_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ate nama me a baga a biisi mi wie dii nyiŋ la ni bo ale mu kama a nyini piilimka. ");
INSERT INTO bwu_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Mi a weeni nama wieŋa de kama, ate ni kan jok siaka ale mi. ");
INSERT INTO bwu_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Juuma a le yiak ni ba tuka diinaŋa po a basi. Ku danni me dek a le jam a paari ate baai a le ba ko ni la a poli ayen ba a tom ka dii ate Naawen a yaali la. ");
INSERT INTO bwu_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ba le nyɛ ni nyaŋa de meena, dii nyiŋ la ba ze mi yaase m Kowa. ");
INSERT INTO bwu_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mi a weeni ni wieŋa de kama ate da ŋala, a dan paari ate ba boro a nyɛ ni dila abe ni teeri mi ale weeni ni dii la. “Mi an weeni ni wieŋa de piilimka po, dii la m le jam bo ale ni la. ");
INSERT INTO bwu_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yɔgyɔgla de m ŋmani a cheŋ ka waai ale tom mu la jigi, alege ni waai a karo ayen wa bek mi m le a cheŋ juijui la. ");
INSERT INTO bwu_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mi ale weeni ni wieŋa de meena la a nyɛ kama ate ni sui a kaasi nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Alege wensie ate mi a weeni ni, ku ale zunchoŋ ni jigi ase m nin cheŋ m Kowa jigi, dii nyiŋ la m dan kan cheŋ ya, Maarowa a kan jam ni jigi ya. Alege m dan cheŋ m le tom wa ate wa jam a maari ni. ");
INSERT INTO bwu_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Wa dan jam, wa le basi ate tɛŋzuk de meena demma a miŋ ba le ta popola kaasima ale tuimbaata dii la, ale ba le ta popola kaasima ale Naawen buusaŋa dii la. ");
INSERT INTO bwu_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ba ta popola kaasima ale tuimbaata dii la ba ka siaka ale mi. ");
INSERT INTO bwu_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ba ta popola kaasima ale wayɔrisima dii la mi a cheŋ ka m Kowa jigi ate ni kan ŋman nya mu. ");
INSERT INTO bwu_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ba ta popola kaasima ale Naawen buusaŋa dii la Naawen a poom bo Sitaana waai ale soa tɛŋka demma meena la buusa kama. ");
INSERT INTO bwu_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Mi ta ka wie nna yegayega ayen m weeni a sak ni a gum du, alege ŋa zuak kama a gaam ni womka. ");
INSERT INTO bwu_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Naawen Chiika kaai ale ka wensie nyɔnɔ la, a le jam a bo ni suniimaŋa po, ka le de ni niŋ a sak ni wensie siuku. Ka le ka sak ni dii la a kan nyini daa ka dek jigi ya. Wie ŋaai ate mi ale m Kowa a weeni ka la, ŋala a le ka pai a sak ni. Ka le sak ni me wie ŋaai ale diem cheena ayen ŋa nyɛ la wie. ");
INSERT INTO bwu_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ka le te mi zula yegayega, dii nyiŋ la ka le wom mi wieŋa ŋaai ate mi a weeni ka la abe ka pai a sak ni. ");
INSERT INTO bwu_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Jaab buuri meena ate m Kowa a ta la ka mi ale soa. Ka dila ale soa ate mi a weeni ni ayen Naawen Chiika a le wom dii ate mi a weeni ka la abe ka pai a sak ni. ");
INSERT INTO bwu_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Mi a kan bo ale ni a beni abe m ge a cheŋ m Kowa jigi ya. Mi a dan cheŋ wa jigi ku kan beni ate ni ŋman nya mu.” ");
INSERT INTO bwu_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yeezu ale biisi a ga nueri la, wa ŋaaŋviirima ba gela a yaa weeni chaab ayen, “Wa a weeni ka tama ayen wa kan bo ale ti a beni abe wa ge a cheŋ wa kowa jigi ya. Wa ŋman a weeni ti kama ayen wa dan cheŋ ku kan beni ate ti ŋman nya wa. Nyaku de meena ate wa biisi la, kiri ale boa? ");
INSERT INTO bwu_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Tama ze dii ate wa a weeni ayen wa kan beni la kiri ya.” ");
INSERT INTO bwu_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yeezu a jam seba kama ayen ba a yaali ayen ba bek wa kama. Wa yaa weeni ba ayen, “Ku kan beni ate ni kan ŋman nya mu, ku be kan beni ate ni ŋman nya mu. Ka ku de ate ni a bek chaaba? ");
INSERT INTO bwu_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Wensie ate mi a weeni ni ayen mi dan basi ni, tɛŋka meena demma sue a le peenti nna yegayega, alege nama dek sueŋa a le kaasi kama nna yegayega. Ni sukaasimaŋa ale tulim a chim supeentik. ");
INSERT INTO bwu_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nipɔk a dan boro a dom wa puuk, wa sui a nyiem kaasi kama. Wa dan jam biak a ga nueri, wa yaa bagim wa sukaasuŋku kama, ale ta supeentik wa biika nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nama sue a kaasi kama yɔgyɔgla de, alege m dan ŋman nya ni, ni sueŋa a peenti kama nna yegayega. Nuru karo a baga a tuesi supeentika de ni jigi ya. ");
INSERT INTO bwu_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Dai dila danni a dan jam paari ni kan begi mu jaabɔa. Wensie ate mi a weeni ni ayen ni a le baga a pa mi yonni nyiŋ a juisi jaab buuri meena ate nama a yaali la m Kowa jigi ate wa te ni. ");
INSERT INTO bwu_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","A ta nyini dila po a jam paari jinla danni, nama an diem a juisi wa jaabɔa mi yonni nyiŋŋa. Ni be juisi wa ate wa te ni ate ni sueŋa a peenti a gaam taam. ");
INSERT INTO bwu_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Wie ŋaai ate mi a kasim a weeni ni la, ka wamagsima ate ni an baga ŋa kiri a miŋ, alege ku danni a cheena kama ayen m sak ni m Kowa wie a lagri ate ku kan ŋman tua a te ni. ");
INSERT INTO bwu_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Dai dila danni a dan paari, ni kan ŋman nya mi ayen mi a basi ate m Kowa a te ni ŋanta baai ate ni a yaali la. Nama dek a baga kama a puusi a te wa mi yonni nyiŋ ate wa a te ni. ");
INSERT INTO bwu_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Mi Kowa a le te ni jaab buui ate ni a yaali la, dii nyiŋ la wa a yaali ni ka nna yegayega. Nama a yaali mu kama ale ta siaka ayen m nyini ka m Kowa Naawen jigi. ");
INSERT INTO bwu_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mi a nyini ka wa jigi a jam tɛŋzuk de. Yɔgyɔgla de mi a basi tɛŋzuk kama ayen m ŋmani a cheŋ wa jigi.” ");
INSERT INTO bwu_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Wa ŋaaŋviirima ale ga wom dii ate wa a weeni la, ba yaa weeni wa ayen, “Yɔgyɔgla de tama a yaa miŋ fi ale a weeni dii la kiri kama. Ku an ŋman tua a te ti. ");
INSERT INTO bwu_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ti seba ayen fi seba wie meena kama. Ku daa nuru ŋman bek fu bega. Ku de a basi kama ate tama a ta siaka ayen fi nyini ka Naawen jigi.” ");
INSERT INTO bwu_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yeezu a yaa weeni ba ayen, “Ni sum ta siaka ale mu yɔgyɔgla de? ");
INSERT INTO bwu_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ni wom mi nalimnyiini. Ku kan beni ate nama meena ale chali a kuli ni yeeŋa abe ni ge basi mi nyiini, alege m Kowa a kan basi mu, dii nyiŋ la wa bo ale mu kama. ");
INSERT INTO bwu_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mi a weeni ni wieŋa de kama ate ni dan bo ale mi ni ni ta suyɔgini. Tɛŋka demma ale namsi ni alege ni ta sunum pagrik mi nak de Naawen dachaasa kama.” ");
INSERT INTO bwu_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yeezu ale biisi a ga nueri la, wa yaa zak wa zuk a nya wenŋmazuk a weeni ayen, “M Koa, m kummu danni a mɔata kama. Sak nuruba fi zulaŋa ale fi nalim buui ate fi pa te mi la, ate mi a te fu zula. ");
INSERT INTO bwu_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Fi te mu pagrim kama nurubiik meena zuk ayen m baga a pai nyuvuri dii ale kan ta kpeglimka la a te baai meena ate fi a te mu la. ");
INSERT INTO bwu_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Fi ka wanyi dekki ale wensie nyɔnɔ. Nuru waai a dan seba fi ale mi waai ate fi tom la, wala nyiini ale ta nyuvuri dii ale kan ta kpeglimka la. ");
INSERT INTO bwu_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Tuim ŋaai ate fi pa te mu ayen m tom la a basi ate tɛŋka meena demma a nya fi zulaŋa ale fi nalimu kama. Yɔgyɔgla de mi a be nueri tuimaŋa kama. ");
INSERT INTO bwu_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","M Koa, te mu zula fi dek nimbie po, zula ŋaai ate mi ale fi a jam ta alege ate fi nyɛ tɛŋka la. ");
INSERT INTO bwu_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nuru baai ate fi lueri ba tɛŋka po a te mi la, mi a basi ate ba seba fu kama. Fi ale soa ba a yaa pa ba a te mi. Ba be va fi noai kama. ");
INSERT INTO bwu_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Yɔgyɔgla de ba yaa seba ayen jaab buuri meena ate mi ta la a nyini ka fi jigi. ");
INSERT INTO bwu_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Wie ŋaai ate fi a weeni mu la, m pa ŋa kama a sak ba, ate ba ta siaka ayen ka fi ale tom mu ba jigi. ");
INSERT INTO bwu_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“M kan puusi a te ka tɛŋka meena demma, alege mi a puusi a te ka baai ale ta siaka ale mi la. Fi ale soa ba ale lueri ba a te mi. ");
INSERT INTO bwu_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Mi nuruba meena ka fi nuruba. Fi nuruba me meena ka mi nuruba. Ba ale va mi dii la a sak ka nuruba ayen mi ta zula ka nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Yɔgyɔgla de mi cheena ka fi jigi, m kan ŋman bo tɛŋzuk de, alege bala dek ba nyiini a le ba bo tɛŋzuk de. M Ko Weleŋa a nya ba zuk nalimnyiini ale fi pagrimu ate ba chim bunyi ase mi ale fi ale ka bunyi dii la. ");
INSERT INTO bwu_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ase mi ale diem a jam bo ale ba dii la, mi pa ka fi pagrimu a nya ba zuk. Mi a nya ba zuk kama ate ba wanyi an be ya, alege ka waai ale yeeri wa dek ayen ba ale ŋmarisi wa wie dii Naawen gbaŋka po dila po dila po la a jam chim wensie. ");
INSERT INTO bwu_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Yɔgyɔgla de mi cheena ka fi jigi. Ka dila ale soa ate mi a puusi a te fu ba nyiŋ ayen ba sue a peenti ase mi sunni ale ka dii la. ");
INSERT INTO bwu_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Wie ŋaai meena ate fi weeni mu la m pa ŋa kama a sak ba. Tɛŋka meena demma a kisi ba kama, dii nyiŋ la ba daa bunyi ase mi ale tɛŋka meena demma me ale kan daa bunyi dii la. ");
INSERT INTO bwu_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mi a kan puusi a te fu ayen ka fi yeeri ba tɛŋka po a basi, alege mi a yaali kama ayen fi lik ba a tanla ate Velinvendika a kan paari ba. ");
INSERT INTO bwu_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ba le tɛŋzuk de demma a daa bunyi ase mi ale tɛŋka meena demma ale kan daa bunyi dii la. ");
INSERT INTO bwu_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Fi wie ŋaai ate mi a pa sak ba la ka wensie. Be pa ba ate ba chim fi nuruba ate ba va fi wensieŋa. ");
INSERT INTO bwu_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mi ale a tom ba ayen ba cheŋ a ga sak tɛŋka meena demma fi wie ase fi ale tom mi me ayen m jam a sak ba dii la. ");
INSERT INTO bwu_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ba nyiŋ mi pai m dek a te fu ayen ba baga a pai ba dek a te fu. ");
INSERT INTO bwu_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Mi kan puusi a te ka mi ŋaaŋviirima dek ba nyiini, alege ka baai meena a le ba ta siaka ale mi ba sinsaŋŋa nyiŋ la. ");
INSERT INTO bwu_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Be maari ba ate ba ta noai yeŋ ale chaab. M Koa, fi ale mi ka bunyi. Maari ba ate ba ta noai yeŋ ate tɛŋzuk de meena demma a ta siaka ayen ka fi ale tom mi ba jigi. ");
INSERT INTO bwu_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Fi zulaŋa ale fi nalimu ate fi a pa te mi la, mi a pai a te ba kama ate ba baga a ta noai yeŋ ale chaab ase tama la. ");
INSERT INTO bwu_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mi a bo ale ba kama ate fi a bo ale mi ayen ba ta noai yeŋ ate tɛŋka meena demma a seba ayen fi ale tom mi alege a yaali ba ase fi ale a yaali mi dii la. ");
INSERT INTO bwu_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“M Koa, fi ale pai m ŋaaŋviirima a te mu. Mi a yaali kama ayen ba bo ale mu juijui ate mi a cheŋ la ate ba nya zula ŋaai ale nalim buui ate fi a te mi la, dii la fi a yaali mi kama piilimka po alege a nyɛ tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","M Ko waai ale ka tuimmaŋsa nyɔnɔ la, tɛŋka meena demma a ze fu, alege mi a seba fu kama ate m ŋaaŋviirima me a seba ale ka fi ale tom mu ba jigi la. ");
INSERT INTO bwu_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mi sak ba fi ale ka waai la kama. M le kasim a sak ba ate yaali kaai fi ta ale mi la bo ba jigi ate mi me a baga a bo ale ba.” ");
INSERT INTO bwu_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yeezu ale jam a puusi a te wa Kowa a nueri la, wa le wa ŋaaŋviirima a yaa basi dula jigini ale ge lo beli fiik kaai ate ba a wi ayen, Kidron la a jueli a ga jo jigi ate ba vuk tiisa. ");
INSERT INTO bwu_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas waai ale jam a yaali ayen wa ta Yeezu a ga bobri a sak la, a jam seba dula jigini kama, dii nyiŋ la wa ale Yeezu ale wa ŋaaŋviirima meena a nyiem a kasim a cheŋ ka ku jigini. ");
INSERT INTO bwu_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Juuma Puusika Yenni kpaŋŋa ale Farisiima a yaa tigsi sojiba ale baai ale jam a limsi Juuma Puusika Yenni la jigi yeŋ ate Judas a yaa de ba niŋ a ta ba cheŋ juijui ate ba vuk tiisaŋa la ayen ba yik Yeezu. Ba jam a pa ka ba gebi woŋsa ale ba kanaasa ale do woŋta. ");
INSERT INTO bwu_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yeezu a jam seba dii a le cheena ayen di nyɛ la kama a yaa cheŋ ayen wa tu ba. Wa le tu ba la, wa yaa bek ba ayen, “Nama a gisi ka wana?” ");
INSERT INTO bwu_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ba yaa weeni wa ayen, “Ti a gisi ka Yeezu Nazaret denowa.” Wa yaa weeni ba ayen, “Ka mi ale la.” Judas waai ale ta wa a ga bobri a sak la, a jam maa za dula kama ale ba. ");
INSERT INTO bwu_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yeezu ale weeni ayen ka wa ate ba a gisi la, ba yaa tori ŋaaŋ nyiŋ a lo tɛŋ. ");
INSERT INTO bwu_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yeezu a yaa ŋman bek ba ayen, “Nama a gisi ka wana?” Ba ŋman diem weeni wa ayen, “Ti a gisi ka Yeezu Nazaret denowa.” ");
INSERT INTO bwu_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Wa yaa ŋman weeni ba ayen, “Mi poom a liŋ weeni ni kama ayen ka mi ale la. Dan ka mi ate ni a yaali ayen ni yik, ni be basi ate m ŋaaŋviirima cheŋ abe ni yik mi nyiini.” ");
INSERT INTO bwu_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Wa weeni nyaku de kama ayen wa ale poom liŋ weeni wa Kowa dii ayen wa kan yaali ayen wa jok nuru baai ate wa lueri a te wa la, po wanyi la a chim wensie. ");
INSERT INTO bwu_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Dula jigini Simon Piita a yaa deri yeeri gebi woŋ a che Juuma Puusika Yenni kpagi kpeeni yomma po wanyi juga tunni a lonsi tɛŋ. Yomo wala yue a jam le Malakusi. ");
INSERT INTO bwu_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yeezu a yaa weeni Piita ayen, “Pa fi gebika a ŋman su ka jigini, fi a poli kama ayen mi kan nam ninam buui ate m Kowa a weeni ayen m jam a namu la.” ");
INSERT INTO bwu_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Yeezu ale biisi a ga nueri la, sojima ale ba kpagini ale baai ale jam a limsi Juuma Puusika Yenni la, a yaa yik Yeezu a bobi wa nisaŋa, ");
INSERT INTO bwu_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","a ta wa a cheŋ nuru waai ate ba a wi wa ayen Anasi la yenni. Juuma Puusika Yenni kpagi kpeeni yue a jam le Kayafas. Anasi a jam ka wa chichambiik. ");
INSERT INTO bwu_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafas a jam le nuru waai ale liŋ a weeni Juuma ayen ku a magsi kama ate nuru yeŋ a zaani ba meena naŋkula po a kpi a te ba la. ");
INSERT INTO bwu_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Anasi a jam seba Yeezu ŋaaŋviirima po wanyi kama. Wa ale Piita a yaa jam va nuru bɔanni ŋaaŋ a cheŋ juijui ate ba jam ta Yeezu a cheŋ la. Ba le ga paari Anasi yenni la, ŋaaŋviiro wala a yaa taam jo dabiaka po, ");
INSERT INTO bwu_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","alege Piita yaa jam wari nansiuŋku noai. Ku an jam a beniya ate Yeezu ŋaaŋviiro waai ate Anasi a jam seba la a yaa ŋman nyini dabiaka po a cheŋ nansiuŋku noai a saalim nipɔkbinni waai ale jam a limsi nansiuŋku la ale ta Piita a jo dabiaka po. ");
INSERT INTO bwu_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nipɔkbinni a yaa bek Piita ayen, “Fi daa nuru wala ŋaaŋviirima po wanyi?” Piita a yaa weeni wa ayen, “Aawo, mi daa ba po wanyi.” ");
INSERT INTO bwu_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Yenni tuimtomdɔma ale baai ale jam a limsi Juuma Puusika Yenni la, a yaa jam yaali kaala a cheeni bolim dabiaka sunsuŋ a za gilim a ŋuuŋi, dii nyiŋ la, ŋoota ale jam boro. Piita me yaa cheŋ ga gum ba po. ");
INSERT INTO bwu_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ba le jam ta Yeezu a ga jo yenni po la, Anasi a yaa bek wa ku le ka dii wa sinsaŋŋa ale wa ŋaaŋviirima jigi la. ");
INSERT INTO bwu_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yeezu a yaa weeni wa ayen, “Mi nyiem a kasim a sak nuruma ba tuka diinaŋa ale Naawen Puusika Yenni po juijui ate ba a tigsi chaab la kama. Mi an suk a biisi wariya. ");
INSERT INTO bwu_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Fi kan a begi mi, alege a begi baai ate mi a sak la, dii nyiŋ la bala dek a seba mi ale weeni ba dii la kama.” ");
INSERT INTO bwu_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Wa le ga weeni dila la, baai ale jam a limsi Juuma Puusika Yenni la wanyi a yaa deri fobi Yeezu ale weeni wa ayen, “Ka boan jaab ale soa ate fi a biisi dila ale kpagini?” ");
INSERT INTO bwu_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yeezu yaa weeni wa ayen, “Ase mi dan biisi ka wari a kaasi, fi a weeni ka nuruma de meena di ale ka dii la, alege m dan nyɛ magsi kama, be ka boa ale soa ate fi a fobi mu?” ");
INSERT INTO bwu_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yeezu nisaŋa a diem a bobi kama. Anasi ale biisi ale wa nueri la, wa yaa basi ate ba ta Yeezu cheŋ Kayafas waai ale jam ka Juuma Puusika Yenni kpagi kpeeni la jigi. ");
INSERT INTO bwu_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Piita a jam diem bo ka dabiaka po a ŋuuŋi bolimu. Baai ale jam za ale wa la po wanyi a yaa bek wa ayen, “Fi daa nuru wala ŋaaŋviirima po wanyi?” Wa yaa pagsi ayen, “Aawo, mi daa ba po wanyi.” ");
INSERT INTO bwu_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Juuma Puusika Yenni kpagi kpeeni yomma po wanyi a jam ka nuru waai ate Piita a jam a gebi wa tunni la suok. Wa yaa weeni Piita ayen, “Daa fi ale nuru wala ate mi a poom nya ni juijui ate ba vuk tiisaŋa la?” ");
INSERT INTO bwu_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piita ŋman pagsi ayen, “Aawo, daa mi.” Wa ale ga weeni dila la, vari kpadiaka a yaa deri kum. ");
INSERT INTO bwu_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Vari ale veenti la saliuk yokyok foribi ate Kayafas a basi ate sojima yaa ta Yeezu cheŋ gominawa yenni. Ba ale cheŋ la Juuma a jam wari za ka peelim dii nyiŋ la ba an jam a yaali ayen ba daŋ ba dek ate ba kan baga a de Gaambasika Tigini ŋandiintaŋa. ");
INSERT INTO bwu_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Gominawa yoi jam ale Paalɔt. Wa yaa nyini dabiaka po a begi Juuma ayen, “Ka boan jaab wari ate nama a ta ayen wa kaasi ya?” ");
INSERT INTO bwu_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ba yaa weeni wa ayen, “Ase wa dan kan nyɛ ka wari a kaasi ya, tama te kan ta wa a jam dela.” ");
INSERT INTO bwu_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Paalɔt a yaa weeni ba ayen, “Ni be ta wa a cheŋ ga bo wa dii ate ni nyiem a bo ni nuruma, buusa la.” Ba yaa weeni wa ayen, “Nama Aroom demma a kan siak ate ti a bo nuruba kum buusa.” ");
INSERT INTO bwu_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Juuma ale jam a yaali ayen Paalɔt yik Yeezu a kpi jabarimu nyiŋ ate wa kpi la, a jam basi kama ate dii ate Yeezu a weeni wa ŋaaŋviirima la, a chim wensie. ");
INSERT INTO bwu_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Paalɔt a yaa ŋmani jo boteka yenni po a yaa weeni wa sojima ate ba ga ta Yeezu a jam ate wa yaa weeni wa ayen, “Ka fi ale Juuma Naawa?” ");
INSERT INTO bwu_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yeezu a yaa bek wa ayen, “Ka fi dek ale a bek wanni de yaa ka nuruba ale weeni fu ayen fi bek mu?” ");
INSERT INTO bwu_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Paalɔt a yaa weeni wa ayen, “Fi a poli ayen mi ka Juu? Ka fi dek nuruba ale Juuma Puusika Yenni kpaŋŋa, a ta fu a jam nyo mi nisa po. Ka boan jaab wabiok ate fi tomu?” ");
INSERT INTO bwu_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yeezu a yaa weeni wa ayen, “Mi naamu a ka tɛŋzuk de. Ase bu dan bo ka tɛŋzuk de, mi nuruma a te nyɛ ka kpaliŋ a vari mi Juuma kpaŋŋa jigi a basi. M be ŋman a weeni fu kama ayen mi naamu a ka tɛŋzuk de.” ");
INSERT INTO bwu_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Paalɔt a yaa bek wa ayen, “Fi be sum ka naaba?” Yeezu a yaa weeni wa ayen, “Fi ale weeni ayen m ka naab. Ba biak mu ka tɛŋzuk de ayen m sak nuruba wensie wie. Baai ale a yaali ayen ba chim wensie nyam la ale a wom mi sinsaŋŋa.” ");
INSERT INTO bwu_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Paalɔt a yaa bek wa ayen, “Ka boa ale wensie?” Wa yaa ŋman nyini peelim a weeni Juuma ayen, “Mi an baga a nya wabiok kuui ate nuruwa de a tom a magsi kum la. ");
INSERT INTO bwu_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ni Gaambasika Tigini daaŋa a nyiem a dan jam paari bena meena, mi nyiem a lak ka nuru baai ate mi yik a lik la po wanyi a basi. Nama a yaali ayen m basi waai ale ka Juuma naab la?” ");
INSERT INTO bwu_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ba meena a yaa kaari ate ku jueli ayen, “Tama a kan yaali wa. Ti a yaali ka Barabasi.” (Barabasi a jam ka zue.) ");
INSERT INTO bwu_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Paalɔt ale wom dii ate nuruma a weeni la, wa yaa basi ate sojima a miiri wa. ");
INSERT INTO bwu_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ba le miiri wa la, ba yaa yaali munsa a yok zutok ate ka a nyɛ ase naab zutok la a vuk wa zukku ale ge pa garuk monuŋ a jo wa, ");
INSERT INTO bwu_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","a yaa fobi wa ale a puusi wa ayen, “Juuma Naawa, ti a puusi fu.” ");
INSERT INTO bwu_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ba le jam a nyɛ dila la, Paalɔt a yaa ŋman nyini Juuma jigi dabiaka po a weeni ba ayen, “M le ŋman ta wa a nyini a sak ni, ate ni seba ayen mi an nya wa kaasuŋ wa jigiya.” ");
INSERT INTO bwu_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Wa le ga weeni nyaku de la, sojima yaa deri ta Yeezu a nyini zaani nuru bɔanni niŋ. Wa diem a jam jo ka wa garuk monuŋku ale wa munsa zutoka. Paalɔt a yaa weeni nuru bɔanni ayen, “Ni nya, nuruwa ale nna.” ");
INSERT INTO bwu_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Juuma Puusika Yenni kpaŋŋa ale baai ale jam a limsi Juuma Puusika Yenni la ale nya Yeezu la, ba yaa kaari ate ba luelutaŋa a jueli a weeni Paalɔt ayen, “Ko wa! Ko wa!” Paalɔt a yaa weeni ba ayen, “Mi an nya wa kaasuŋ ale nuruwa de. Ni ta wa cheŋ ga kpi jabarimu nyiŋ ate wa kpi.” ");
INSERT INTO bwu_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nuru bɔanni a yaa weeni wa ayen, “Tama sinsaŋŋa a sak ti kama ayen ku a magsi kama ate nuruwa de a kpi, dii nyiŋ la wa pa ka wa dek a chim Naawen Biik.” ");
INSERT INTO bwu_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Paalɔt ale wom dii ate ba weeni la, yɔgsum a yaa yik wa nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Wa yaa ŋman cheŋ ga jo boteka yenni po, a yaa bek Yeezu ayen, “Fi nyini ka be?” Alege Yeezu an tulisi ya. ");
INSERT INTO bwu_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Paalɔt a yaa ŋman bek wa ayen, “Fi ka wari a weeni? Mi ta pagrim kama a baga a vari fu a basi ale ŋman baga a weeni ayen ba ta fu a cheŋ a ga kpi jabarimu nyiŋ ate fi kpi.” ");
INSERT INTO bwu_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yeezu a yaa weeni wa ayen, “Ase Naawen a dan kan te fu pagrimu de, fi an baga a nyɛ mi wariya. Ka dila ale soa ate mi a dan kpi, nuru waai ale pa mu a nyo fi nisa po la, wala kaasuŋku a gaam fi kaasuŋku la.” ");
INSERT INTO bwu_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Paalɔt ale wom Yeezu wieŋa la, wa yaa deri a nyɛ wa popola bunyi ayen wa vari wa a basi. Nuru bɔanni ale jam a miŋ dii ate wa a yaali ayen wa nyɛ la, ba yaa ŋman kaari ate ku jueli nna yegayega ayen, “Fi dan basi ate nuruwa de a cheŋ, fi kan va ti nakpioŋku waai ate ba a wi wa ayen Siiza la nɔaya. Ase nuru waai me a dan pa wa dek a chim naab, wa me a kan va Siiza nɔaya.” ");
INSERT INTO bwu_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Paalɔt ale wom dii ate ba weeni la, wa yaa ŋman basi ate wa sojima a ta Yeezu a de wa niŋ a cheŋ ga jueli kuŋkuŋku zuk. Juuma a jam a wi dula jigini ale ba dek tɛŋka biika ayen ka Gabata. Paalɔt a yaa kali boteka zukpaglika zuk. ");
INSERT INTO bwu_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Paalɔt ale jam a ga jo a kali diipo la ale wenbinni a jam bo ka wein zuk sunsuŋ. Da dila danni me ate Juuma a boro a gomsi ba Gaambasika Tigini daaŋa. Paalɔt a yaa weeni nuru bɔanni ayen, “Ni nya, ni naawa ale nna.” ");
INSERT INTO bwu_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ba yaa ŋman kaari ayen, “Ko wa! Ko wa! Basi ate ba kpi wa jabarimu nyiŋ!” Paalɔt a yaa weeni ba ayen, “Nama a yaali ayen m basi ate ba ta ni naawa a ga kpi ka jabarimu nyiŋŋa?” Juuma Puusika Yenni kpaŋŋa baai ale jam bo nuru bɔanni po la, a yaa kaari ayen, “Na waai nyiini ate ti ta la ale Siiza.” ");
INSERT INTO bwu_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Paalɔt a yaa jam weeni wa sojima ayen ba ta Yeezu a cheŋ a ga kpi wa jabarimu nyiŋ ate wa kpi. Ba yaa deri yik wa. ");
INSERT INTO bwu_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ba jam pai ka jabarim a te Yeezu ayen wa ji ate ba cheŋ juijui ate Juuma a wi ale ba dek tɛŋka biika ayen, “Golgota” la. Dula jigini kiri a jam le zukoluku jigini. ");
INSERT INTO bwu_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ba le ga paari ku jigini la, ba yaa pa wa a kpi jabarimu nyiŋ. Ba jam maa ta ka nuruba baye a jam kpi ŋanbarinta nyiŋ dula jigini a gum Yeezu po, ate wanyi a bo wa gala nwala me a bo wa juga. ");
INSERT INTO bwu_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Paalɔt a yaa jam weeni wa sojima ayen ba ŋmarisi dii ate Yeezu a nyɛ la a pa maŋ wa jabarimu nyiŋ. Dii ate ba jam ŋmarisi la ale, ");
INSERT INTO bwu_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ba le jam kpi Yeezu juijui la an yalima ale Jerusalem tɛŋka. Juuma yegayega a yaa jam nyini ba tɛŋka a cheŋ ayen ba nya jaab buui ale jam a nyɛ la. Ba le ga paari dula jigini la, ba yaa nya sojima ale ŋmarisi dii a pa maŋ la. Ba jam pa ka biisa buta a ŋmarisi, si jam ka Juuma ale Girik demma ale Aroom demma biisaŋa. ");
INSERT INTO bwu_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Juuma Puusika Yenni kpaŋŋa yaa ŋmani a cheŋ Paalɔt jigi a ga weeni wa ayen, “Ku an magsi ayen fi poom weeni fi sojima ate ba ŋmarisi ayen wa ka Juuma Naaba. Fi te weeni ba ate ba poom a ŋmarisi ayen, wa weeni kama ayen wa ka Juuma Naab.” ");
INSERT INTO bwu_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Paalɔt a yaa weeni ba ayen, “Dii ate mi basi ate ba ŋmarisi la, ale la.” ");
INSERT INTO bwu_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sojima ale jam kpi Yeezu jabarimu nyiŋ a nueri la ba yaa pai gattaŋa a poori bunaansi ate waai meena a pai bunyi. Ba jam pai wa garuk kuui ate ba an baali ku alege yok ku la me. ");
INSERT INTO bwu_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ba yaa weeni chaab ayen, “Ni kan basi ate ti cheeri ku, alege ni basi ate ti nak gbaŋ a nya waai dek ale wa de garuku la.” Sojima ale ga nyɛ dila la, dii ate ba jam ŋmarisi Naawen gbaŋka po dila po dila po la a yaa chim wensie. Ba ŋmarisi ayen, “Ba pai mi gattaŋa a chari chaab, alege a pai m garuk woŋku kuui ate m jo a basi tɛŋ la, a nak gbaŋ ayen ba nya waai dek ale wa de la.” Sojima ale jam nyɛ dii la ale la. ");
INSERT INTO bwu_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yeezu mawa, ale wa mawa suoku, ale Kolopase powa Mɛɛri ale Mɛɛri Magdala ale jam za a mɔata Yeezu. ");
INSERT INTO bwu_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yeezu yaa nya wa mawa ale wa za mɔata wa ŋaaŋviiro waai ate wa jam a yaali nna yegayega la. Wa yaa weeni wa mawa ayen, “M ma, wa ka fi biik.” ");
INSERT INTO bwu_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Yeezu yaa ŋman weeni wa ŋaaŋviiro waai ate wa a yaali nna yegayega la ayen, “Wa ka fi ma.” A nyini da dila danni, a ta a cheŋ wa ŋaaŋviiriwa a yaa jam kasim a nya wa mawa zuk kama. ");
INSERT INTO bwu_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yeezu ale weeni dila la, wa yaa deri seba ayen wa tuimaŋa tɛŋzuk de a nueri kama, ate wa yaa weeni ayen, “Nyanyuila ale ta mu.” Wa weeni wieŋa de kama ate dii ate ba ŋmarisi Naawen gbaŋka po dila po dila po la a chim wensie. ");
INSERT INTO bwu_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Daam ale jam bo chin po a za dula, nuru baai ale jam za dula jigini la wanyi a yaa yaali sosok a pa lusi daamu po a pa yik duok woŋ nyiŋ a zak ta jueli Yeezu jigi ayen wa nyu. ");
INSERT INTO bwu_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yeezu a yaa nyu ale a weeni ayen, “Ku nueri kama.” Wa le weeni dila a ga nueri la, wa yaa deri chigsi wa zukku tɛŋ a kpi. ");
INSERT INTO bwu_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Juuma a kan jam a yaali ayen Yeezu ale nuruba bayewa a bo dula jigini, dii nyiŋ la ba tigini daaŋa ale cheena la nyiŋ. Ba tigini daaŋa po dinyi a jam ka ba Vuusum Dai. Ba gela yaa cheŋ Paalɔt jigi a ga weeni wa ayen ba a saalim wa kama ayen wa basi ate wa sojima a cheŋ ga we ba naŋsaŋa ate ba kpi nwuli abe ba yeeri ba ate ba nyini ŋanbarintaŋa zuima a siŋ. ");
INSERT INTO bwu_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Wa yaa siak ate ba cheŋ. Ba le ga la, ba yaa liŋ we nuru baai bayewa ate ba kpi a gum Yeezu po dula jigini la naŋsaŋa. ");
INSERT INTO bwu_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ba le ga ayen ba we Yeezu naŋsaŋa la, ba yaa nya ale wa kpi kama ate ba yaa pa wa naŋsaŋa weka a basi. ");
INSERT INTO bwu_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sojima wanyi a yaa pa wa gbaluku a chubi wa gauŋku a pusi ate ziim ale nyiam a nyini du a nyini. ");
INSERT INTO bwu_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ka mi dek, Jɔɔn, ale nya ale m nina. Ka dila ale soa ate mi ale ŋmarisi dii la ka wensie la. Mi a weeni ni kama ayen ni ta siaka ale ku. ");
INSERT INTO bwu_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Sojiwa ale ga nyɛ dila la, ba le jam a ŋmarisi dii Naawen gbaŋka po dila po dila po la a chim ka wensie. Ba ŋmarisi ayen, “Kobi yeŋ me la an jam we wa nyiŋka po.” ");
INSERT INTO bwu_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ba ŋman ŋmarisi Naawen gbaŋka po ayen, “Nuruba a le nya nuru waai ate ba pa gbaluk a boro a chubi wa la.” ");
INSERT INTO bwu_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nuru wanyi ale jam boro ate ba a wi wa ayen Josefi ate wa jam nyini tɛŋ kanyi ate ba a wi ayen Arimatia. Wa jam ka Yeezu ŋaaŋviirima po wanyi, alege wa yaa jam a suk wa dek Juuma kpaŋŋa nyiŋ. Wa yaa jam cheŋ Paalɔt jigi a ga saalim wa ayen wa basi ate wa sojima a ga yeeri Yeezu ate wa nyini jabarimu zuk a siŋ tɛŋ ate wa ta ga gu. Paalɔt a yaa jam te wa siuk. ");
INSERT INTO bwu_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimusi waai ale jam liŋ cheŋ Yeezu jigi yokku la, a jam maa bo dula kama a yaa ta wa kpaam, bu nyummu a jam masa kama. ");
INSERT INTO bwu_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Josefi ale Nikodimusi a yaa jam pa kpaamu a sa Yeezu nyiŋka ale ge a pa guka garupali a vili wa. Juuma ale a gu ba nuruba dii la ale la. ");
INSERT INTO bwu_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Juijui ate ba kpi Yeezu jabarimu nyiŋ la, ba jam vuk ka tiisa. Dula jigini puŋ vorub ale jam boro ate ba an diem a gu nuru du a nya ya. ");
INSERT INTO bwu_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ba jam a yaali ayen ba ta Yeezu a ga gu ka vorub bula po, dii nyiŋ la Juuma Gaambasika daaŋa a jam paari kama a nueri. ");
INSERT INTO bwu_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Laasidi dai saliuk yokyok, ate Mɛɛri Magdala a yaa yiti a cheŋ juijui ate ba gu Yeezu la. Wa le ga paari la, wa yaa nya ale tintain dii ate ba pa lik vorumu nɔanni la a jam bilim kama a basi nakpiak. ");
INSERT INTO bwu_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Wa yaa ŋmani chali cheŋ Simon Piita ale Yeezu ŋaaŋviiro waai ate wa jam a yaali wa nna yegayega la jigi a yaa weeni ba ayen, “Nuruba ale yeeri ti Nyɔnɔwa vorumu po. Mi be ze ba le ta wa a cheŋ juijui la.” ");
INSERT INTO bwu_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piita ale Yeezu ŋaaŋviiro nwala a yaa deri yiti a chali cheŋ dula jigini. ");
INSERT INTO bwu_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Yeezu ŋaaŋviiro waai ate wa jam a yaali wa nna yegayega la, a liŋ de Piita niŋ kama a chali a paari vorumu jigini. ");
INSERT INTO bwu_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Wa le chuiri nya la, ka guka garuku kuui ate ba jam pa vili Yeezu nyiŋka la ale jam doa vorumu po alege wa an jo du. ");
INSERT INTO bwu_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Piita a yaa jam a fobi taam a ga jo vorumu po a nya ale ka guka garuku ale doa du. ");
INSERT INTO bwu_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Wa ŋman nya garuk kuui ate ba jam pa bobi Yeezu zukku la ale ku doa ku tɔga, garuk kula ale guka garuku an jam a doa ale chaaba. ");
INSERT INTO bwu_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Yeezu ŋaaŋviiro waai ale liŋ a paari dula la a yaa jo a gum Piita po. Wa yaa gisi a nya jaab buuri meena a yaa le ge a ta siaka ayen wa yiti kum po kama. ");
INSERT INTO bwu_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ba an diem a jam miŋi dii ate ba ŋmarisi Naawen gbaŋka po dila po dila po ayen, “Ku a fe kama ate wa yiti kum po la.” ");
INSERT INTO bwu_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ba yaa basi dula ale ge a kuli. ");
INSERT INTO bwu_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mɛɛri Magdala a jam za ka peelim a kum. Wa me a yaa chuiri ayen wa nya bu po. ");
INSERT INTO bwu_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Wa le chuiri la, wa yaa nya Naawen sabiiloba baye ale ba jo garuk peelita a bo vorumu po. Ba jam kala ka juijui ate ba jam pa Yeezu a dueni la ate wanyi a kala wa zukku duaka jigini ale ge nwala me a kala wa naŋsaŋa jigini. ");
INSERT INTO bwu_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Sabiiloma a yaa bek wa ayen, “Ka boa ate fi a kumu?” Wa yaa weeni ba ayen, “Nuruba ale pai m Nyɔnɔwa a ta cheŋ, ate m ze ba le ta wa a ga dueni juijui la.” ");
INSERT INTO bwu_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Wa le a weeni nyaku de la, wa yaa chiem a nya Yeezu ale wa za wa ŋaaŋ, alege wa an jam a miŋ wa. ");
INSERT INTO bwu_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yeezu a yaa bek wa ayen, “Ka boa ate fi a kumu? Fi a gisi ka wana?” Mɛɛri a jam a poli ayen ka waai ale a limsi tiisaŋa la ale la a yaa weeni wa ayen, “Dan ka fi ale yeeri m nyɔnɔwa, weeni mu juijui ate fi ta wa ga dueni la ate m ga pa wa.” ");
INSERT INTO bwu_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yeezu a yaa weeni wa ayen, “Mɛɛri.” Ate wa yaa chiem wa jigi a weeni ale wa dek tɛŋka biika ayen, “Araboni.” Ku kiri ale, “M Sagrɔ.” ");
INSERT INTO bwu_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yeezu a ŋman weeni wa ayen, “Kan tiri mu, dii nyiŋ la mi an diem a cheŋ m Kowa jigi ya. Cheŋ m ŋaaŋviirima jigi a ga weeni ba ayen ku kan beni m le ŋman cheŋ waai ale ka mi Koa ale ba koa, waai ale ka mi Naawen ale ba Naawen la jigi.” ");
INSERT INTO bwu_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Dula jigini Mɛɛri a yaa cheŋ ŋaaŋviirima jigi a ga weeni ba ayen wa nya ba Nyɔnɔwa kama ale dii meena ate wa weeni a sak wa ayen wa weeni ba la. ");
INSERT INTO bwu_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Laasidi dai junɔai yok, Yeezu ŋaaŋviirima a jam tigsi ka chaab a bo yeri dinyi po ale lik tuaataŋa meena, dii nyiŋ la ba jam a chali ka Juuma kpaŋŋa yɔgsum. Ba le jam a kala la, Yeezu a deri jam jo za ba sunsuŋ a yaa weeni ba ayen, “Naawen a te ni suyɔgini.” ");
INSERT INTO bwu_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Wa yaa lagri wa nitalaŋa po a sak ba ale a ŋman cheemu wa gauŋku me ayen ba nya. Ba yaa deri jam seba ayen ka ba Nyɔnɔwa ale la ate ba suniima a yaa peenti nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yeezu yaa ŋman weeni ba ayen, “Naawen ale te ni suyɔgini. Mi Kowa ale tom mi ate m jam tɛŋzuk de siuk kula po me ate mi a tom nama yɔgyɔgla de ayen ni cheŋ tɛŋka meena demma jigi.” ");
INSERT INTO bwu_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Wa le weeni ba dila a ga nueri la, wa yaa vuusi a basi ba nyiŋ ale weeni ayen, “Ni ŋɔa Naawen Chiika.” ");
INSERT INTO bwu_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ni dan voŋ nuruba wabaata a te ba, Naawen ale voŋ te ba alege ni dan kan voŋ nuruba wabaata a te ba, Naawen a kan voŋ te ba. ");
INSERT INTO bwu_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yeezu ale jam wa ŋaaŋviirima jigi la, ba po wanyi wa waai ate ba a wi wa ayen Tomasi yibika la, a jam ka ba po. ");
INSERT INTO bwu_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tomasi a yaa le ŋman jam juijui ate Yeezu ŋaaŋviirima a jam tigsi chaab la, ba yaa weeni wa ayen, “Tama nya ti Nyɔnɔwa kama.” Tomasi yaa weeni ba ayen, “Mi a kan baga a siagi ka mi a nin nya wa nitalaŋa po juijui ate ba pa peemaŋa a kpi la abe m pa m nisaŋa a su wa gauŋku vurika jigini a nya.” ");
INSERT INTO bwu_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Daa ŋayopoi ale jam taam la, Yeezu ŋaaŋviirima ale Tomasi a ŋman jam a tigsi chaab yenni po ale lik tuata meena. Yeezu a yaa ŋman jam zaani ba sunsuŋ a weeni ba ayen, “Naawen a le te ni suyɔgini.” ");
INSERT INTO bwu_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Wa yaa weeni Tomasi ayen, “Pa fi nisaŋa a tiri mi nitalaŋa a nya juijui ate ba pa peemaŋa a kpi la abe fi pa fi nisaŋa a su m gauŋku po a nya. Basi fi chichamaŋa abe fi ta siaka ale mi.” ");
INSERT INTO bwu_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi yaa weeni wa ayen, “M Nyɔnɔ ale m Naawen.” ");
INSERT INTO bwu_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yeezu a weeni wa ayen, “Fi ale a nya mi la ate fi ta siaka ale mi. Baai a le kan nya mi ale ta siaka ale mi la, sue ale peenti.” ");
INSERT INTO bwu_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ŋaaŋviirima nimbie Yeezu a tom ka wakperikaliisa gela nna yegayega ate ŋa an ŋmarisi gbaŋka de po. ");
INSERT INTO bwu_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Alege ŋa de a ŋmarisi kama gbaŋka de po ayen ni ta siaka ayen Yeezu ale varibasidɔwa, Naawen biika ate ni siaka nyiŋ ni nya nyuvuri dii ale kan ta kpeglimka la. ");
INSERT INTO bwu_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ku le ga nyɛ maga la, Yeezu a yaa ŋman tu wa ŋaaŋviirima Galili mogi kpeeni noai. Mogini yoi di choa ale Tiberiasi. Dii a yaa le nyɛ la ale nna. ");
INSERT INTO bwu_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Wa ŋaaŋviirima baai ale jam a tigsi dula jigini la, ale Simon Piita ale Tomasi yibika ale Natani waai ale nyini Kena ate ka bo Galili tɛŋka po la, ale Zebedi bisaŋa ale mba baye. ");
INSERT INTO bwu_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Piita a yaa weeni ba ayen, “Mi a cheŋ kama ayen m yik juma.” Ba yaa weeni wa ayen, “Tama me a yaali kama ayen ti va fu a cheŋ.” Ba yaa deri a ga jo ŋaaruŋ po a cheŋ. Yok kula ba an jam nya juma a yigi ya. ");
INSERT INTO bwu_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Vari ale veenti la saliuk ba yaa nya Yeezu ale wa za nyiamu noai, alege ba an jam baga a miŋ wa. ");
INSERT INTO bwu_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ba le diem a bo niŋ a cheena Yeezu jigi la wa yaa wi a bek ba ayen, “M bisa, ni an nya juma a yigi ya?” Ba yaa weeni wa ayen, “Ti an yigi jaabɔa.” ");
INSERT INTO bwu_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Wa yaa weeni ba ayen, “Ni pa ni ŋmiaka a yuk basi ŋaaruŋku juga geŋ ate ni nya juma a yik dula jigini.” Ba le ga nyɛ dii ate wa weeni ba la, ba yaa deri yik juma nna yegayega ate ba an ŋman baga a dari ba ŋmiaka ate ka a jo ŋaaruŋku po. ");
INSERT INTO bwu_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yeezu ŋaaŋviiriwa waai ate wa jam a yaali nna yegayega la ale ga nya dii ale nyɛ la, wa yaa weeni Piita ayen, “Nuru waai ale za ti niŋ la, ka ti Nyɔnɔwa ale la.” Simon Piita ale ga wom wa le weeni dii la, wa yaa pa wa tuimaŋa garuku a jo lik wa dek a yaa yok zi nyiamu po ayen wa ga tu Yeezu. ");
INSERT INTO bwu_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ŋaaruŋku a diem jam yalima ase ka nantuok noai kobsita la ale ge ate Piita a yok zi la. Yeezu ŋaaŋviirima baai ale diem a jam bo ŋaaruŋku po la a yaa dari ba ŋmiaka a ta paari nyiamu noai. ");
INSERT INTO bwu_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ba le ga nyini ŋaaruŋku po a siŋ tɛŋ la, ba yaa nya Yeezu ale wa kala a se juma kaala bolim zuk ale pa boroboruk me a dueni wa tɛŋ. ");
INSERT INTO bwu_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Wa yaa weeni ba ayen, “Ni ga lueri jumaŋa gela a ta jam.” ");
INSERT INTO bwu_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Piita a yaa de ba niŋ a ga yik ŋmiaka a dari ka a ta jueli kuŋkɔŋini, a yaa yeeri jumaŋa. Ŋa meena a jam ka juma kook ale pisinu ale ŋata. Ŋa jam a piisi kama nna yegayega alege ba ŋmiaka an jam a cheeri ya. ");
INSERT INTO bwu_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yeezu yaa weeni ba ayen, “Ni jam a kali ate ti ŋobi.” Ba wanyi me an jam a begi wa le ka waai la, dii nyiŋ la ba meena a jam seba ayen wa ka ba nyɔnɔwa. ");
INSERT INTO bwu_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yeezu a yaa pa jumaŋa ale boroboruku a chari ba meena. ");
INSERT INTO bwu_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Wa le yiti kum po diipo la, wa ale wa ŋaaŋviirima tu chaab nna la a nyɛ ka ku noai buta. ");
INSERT INTO bwu_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ba le ga de a nueri la, Yeezu yaa weeni Simon Piita ayen, “Fi Simon, Jɔɔn biiga, fi a yaali mi a gaamu mbala?” Piita yaa weeni wa ayen, “M Nyɔnɔ, fi seba ayen mi a yaali fu kama.” Yeezu yaa weeni wa ayen, “Be a nya baai ale a va mu la zuk ase naapeerik ale a nya wa pabisa zuk dii la.” ");
INSERT INTO bwu_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yeezu a ŋman bek wa ayen, “Fi Simon, Jɔɔn biiga, fi a yaali mu?” Piita yaa weeni wa ayen, “M Nyɔnɔ, fi seba ayen mi a yaali fu kama.” Yeezu yaa weeni wa ayen, “Be a nya baai ale a va mu la zuk ase naapeerik ale a nya piisa zuk dii la.” ");
INSERT INTO bwu_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yeezu a ŋman pilim bek wa ku noai butawa ayen, “Fi Simon, Jɔɔn biiga, fi a yaali mu?” Piita ale ga wom Yeezu ale bek wa dii ku noai butawa la, wa sui a yaa deri kaasi ate wa yaa weeni wa ayen, “M Nyɔnɔ, fi seba wie meena kama. Fi seba ayen mi a yaali fu kama.” Yeezu yaa ŋman weeni wa ayen, “Be a nya baai ale va mu la zuk ase naapeerik ale a nya wa piisa zuk dii la. ");
INSERT INTO bwu_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Wensie ate mi a weeni fu. Ase fi ale diem a jam ka paalik la, fi nyiem a gomsi ka fi dek a cheŋ fi le a yaali juijui meena la. Fi dan jam a kpagimu, fi ale zaani kama ate nuruba a bobi fu a ta cheŋ juijui ate fi kan yaali la.” ");
INSERT INTO bwu_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yeezu a weeni nyaku de ayen ku sak Piita ka wa le wa kpi siuk kuui po a te Naawen zula dii la. Wa le biisi nyaku de a ga nueri la, wa yaa weeni Piita ayen, “Jam va mu.” ");
INSERT INTO bwu_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piita yaa cheemu a nya Yeezu ŋaaŋviiriwa waai ate wa a yaali nna yegayega la ale wa bo ba ŋaaŋ a vi. Wala a jam le waai ale jam kala a mɔata Yeezu Gaambasika Tigini danni ale bek wa ayen, “Ka wana a le wa ta wa a ga bobri a sak la?” ");
INSERT INTO bwu_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piita ale ga nya wa ale wa a vi ba ŋaaŋ la, wa yaa bek Yeezu ayen, “M Nyɔnɔ, ku cheena ayen ku nyɛ nuruwa de jigi me ka se?” ");
INSERT INTO bwu_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yeezu yaa weeni wa ayen, “Mi a dan a yaali ayen wa boro ate m pilim jam paari wa, fi niŋ karo, fi dek a ti an jam va mu.” ");
INSERT INTO bwu_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yeezu ale biisi dii ale wa ŋaaŋviiro nwala la, ku yaa deri a tagli wa ŋaaŋviirima mbala meena jigi ayen waai ate Yeezu a yaali nna yegayega la, a kan ŋman maa kpi diipo diipo. Yeezu an jam a weeni ayen wa kan maa kpi, alege wa weeni ka Piita ayen wa dan a yaali ayen wa boro ate wa pilim a jam paari wa, wa niŋ karo. ");
INSERT INTO bwu_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ka mi Jɔɔn waai ale ŋmarisi gbaŋka de la ale Yeezu a yaali nna yegayega la. Wie ŋaai meena ale nyɛ ate mi a ŋmarisi a nyo gbaŋka de po la, mi a nya ŋa kama ale m dek nimbie. Ti meena abe seba ayen wieŋa de ka wensie. ");
INSERT INTO bwu_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yeezu a tom ka tuima nna yegayega a gum mi ale ŋmarisi dii gbaŋka de po la. Mi a poli ayen ŋa meena a dan ŋmarisi a nyo gbaŋsa po dɔk a kan bo tɛŋka zuk a paari a dueni si du.");
INSERT INTO bwu_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Teofilos, m poom liŋ ŋmarisi te fu a weeni Yeezu ale jam bo ale ti a piilim wa tuimaŋa dii ale sak nuruba me alege a yaa cheŋ wenŋmazuk la. Wa yaa weeni wa tuimtomdɔ baai ate wa lueri a te wa dek la, ale pa Naawen Chiika pagrimu a sak ba ba le ba a tom dii la. ");
INSERT INTO bwu_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Wa ale kpi la, ŋaaŋ nyiŋ ku ale jam paari daa pisinaansi la, wa yaa pa wa dek a sak ba ate ku paari dii choa ayen ku sak ba ayen wa vua kama. Wa yaa sak ba Naawen naamu wie. ");
INSERT INTO bwu_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Wa ale jam boro ale ba la, Yeezu a yaa ŋman weeni ba ale nin muna ayen, “Ni kan ŋman basi Jerusalem abe ni cheŋ tɛŋ ka choa. Ni limsi ate ni nya m Kowa tiirim buui ate wa puulim ayen wa le pa a te ni la. Nama dek abe baga teeri ayen m poom weeni nyaku de a sak ni kama. ");
INSERT INTO bwu_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jɔɔn a pa ka nyiam a so nuruba, alege ku kan beni ate Naawen pa wa chiika ase soka la a sueri ni suniimaŋa.” ");
INSERT INTO bwu_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Da yeŋ ate Yeezu ale wa tuimtomdɔma a jam kala ale chaab ate ba yaa a bek wa ayen, “Ti Nyɔnɔ, yɔgyɔgla de fi le basi ate Juuma a soa ba dega?” ");
INSERT INTO bwu_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yeezu a weeni ba ayen, “Mi Kowa ale dak da ŋaai ate wie ayen ŋa nyɛ la, ni waai niŋ a karo. ");
INSERT INTO bwu_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Naawen a le pa wa chiika a sueri ni suniimaŋa ate ka basi ate ni ta pagrim yegayega ate ni cheŋ Jerusalem ale Judia ale Samaria ale tɛŋka meena nuruma jigi a sak ba mi wie.” ");
INSERT INTO bwu_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yeezu ale biisi a nueri la, Naawen a yaa pa wa a ta jueli wenŋmazuk. Ba yaa za a nya wa ale a jueli la, ate chiŋmari a jam lik wa ta jueli ate ba an ŋman nya wa. ");
INSERT INTO bwu_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ba ale za a nya la, nuruba baye a deri jam a za ba niŋ. Ba jam jo ka garuk peeta, ");
INSERT INTO bwu_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","a yaa weeni ba ayen, “Nama Galili demma, ka boa ate ni diem za a nya chiŋmanni po? Ase nama ale nya Naawen ate wa pa Yeezuwa de a ta jueli wenŋmazuk dii la, da yeŋ po wa le ŋman siŋ tɛŋzuk de ka dila degadega.” ");
INSERT INTO bwu_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tuimtomdɔma yaa nyini guuk kuui ate ba a wi ayen Olivi Guuk la zuk a siŋ a cheŋ Jerusalem tɛŋka. Ku jam yalima ase ka mɛɛli geli la ale Jerusalem. ");
INSERT INTO bwu_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ba ale jam paari la, ba yaa ga jueli ŋmazuk dɔkku po ate ba poom boro la. Ba jam ka Piita, ale Jɔɔn, ale Jeemsi, ale Andiru, ale Filip, ale Tomasi, ale Batolomiu, ale Matiu, ale Jeemsi (Alfiyus biika), ale Simon waai ale jam a nyɛ ayen Juuma a nya ba dek zuk la, ale Judas (Jeemsi biika). ");
INSERT INTO bwu_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nyaba de meena, ale nipooma ale Yeezu mawa Mɛɛri ale Yeezu suaataŋa a kasim jam wari ka Naawen puusika ale popola yena. ");
INSERT INTO bwu_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Da yeŋ ate baai meena ale ta siaka ale Yeezu la, a yaa jam jigi yeŋ ayen ba nyɛ tuka. Ba jam paari ka nuruba kook ale pisiye. Piita yaa yiri zaani a piilim biik ayen, ");
INSERT INTO bwu_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“M suaata ku a fe kama ayen Naawen Chiika ale weeni Deevid ayen wa ŋmarisi dii a nyo Naawen gbaŋka po la, a chim wensie. Deevid a jam ŋmarisi magsi chaab ale ka Judas. Wa jam ka Judas, a dak Yeezu a sak nuru bɔanni ate ba yik wa. ");
INSERT INTO bwu_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Wa jam ka tama po wanyi a jam a tom dii ate Yeezu lueri wa ayen wa me a tom la.” ");
INSERT INTO bwu_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ligi ŋaai ate ba jam tuni wa ale ge ate wa tom wabioku de la, Judas jam pa ŋa a da ka talim. Ku ŋaaŋnyiŋ ate wa lo ate wa puuka meena a na di sunsuŋka po ate wa nyuaataŋa meena a yaa nyini peelim. ");
INSERT INTO bwu_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Waai meena Jerusalem tɛŋka po a jam wom wanni de kama ate ba yaa jam a wi talim bula tɛŋka ayen Akeldama. Ku kiri ale Ziimu tɛŋka.) ");
INSERT INTO bwu_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Boan nyiŋŋa, ba ŋmarisi Naawen gbaŋka po gbaŋ kanyi ate ba a wi ayen yiila gbaŋ la ayen, ‘Basi ate wa yenni a chim yeri korok. Basi ate nuru kan bo di po.’ Ba ŋmarisi me ayen, ‘Basi ate nuru yoŋ a tagri wa a tom wa tuimaŋa.’ ");
INSERT INTO bwu_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Dila nyiŋ la, nuru waai ale maa va tama diipo meena wuu ate Nyɔnɔwa a jam a nyiem ale tama la, ");
INSERT INTO bwu_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","a piilim a ta nyini diipo ate Jɔɔn Sokateerɔwa a jam boro la a ta jam paari jinla danni ate Naawen yaa jam ta wa a cheŋ la, ku a fe kama ayen nuru wala choa a maa bo ale ti a chim waai le wa weeni sak nuruba a magsi chaab ale Nyɔnɔwa ale yiri kum po la.” ");
INSERT INTO bwu_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ba yaa lueri nuruba baye ayen ba yaa lueri bala po wanyi. Nuruma de jam ale Josefi. Wa jam ta ka yue ŋaye me, ate ba wi ayen Baasabas yaase Jasitus. Wa choawa yoi me ale Matayas. ");
INSERT INTO bwu_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ba yaa puusi Naawen ayen, “Nyɔnɔ, fi seba nuru meena sunum po ale ka dii la kama. Be sak ti nuruma de bayewa po, fi ale lueri ka waai ");
INSERT INTO bwu_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ayen wa tagri tuimtomdɔ wa Judas tuim ŋaai ate wa basi ale cheŋ juijui ate wa nyini la a tom.” ");
INSERT INTO bwu_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ba yaa nak gbaŋ ayen ba lueri nuru wala ate gbaŋka a yaa lueri Matayas ate ba yaa pa wa a gum tuimtomdɔba pi ale wanyiwa po. ");
INSERT INTO bwu_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Juuma dakpeeni danni ate ba a wi ayen Pentekos ale jam paari la, Yeezu ŋaaŋviirima meena a yaa tigsi chaab jigi yeŋ. ");
INSERT INTO bwu_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ba ale jam bo jigi yeŋ la, ba yaa wom chiok ase ŋmoruk viok la a deri nyini wenŋmazuk a jam sueri yenni juijui meena ate ba jam kala la. ");
INSERT INTO bwu_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ba yaa nya bolimŋiak a siŋ jam kala ba zuimaŋa zuk tɔgatɔga a nyɛ ase giŋgeluŋta la. ");
INSERT INTO bwu_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ate Naawen Chiika a jam sueri ba suniimaŋa a te ba pagrim ate ba deri a biisi bisii ale kan daa ba dek tɛŋsaŋa biisa la. ");
INSERT INTO bwu_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Juuma yegayega baai nina ale muni ale wensiuku vaka la a poom jam nyini tɛŋka meena po a jam Jerusalem tɛŋka po kama. ");
INSERT INTO bwu_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ba ale wom dii ale nyɛ la, nuru bɔanni yegayega a yaa tigsi chaab ate ku yaa cha ba nna yegayega, dii nyiŋ la ba wom ba ale a biisi ale ba dek tɛŋsaŋa biisa la. ");
INSERT INTO bwu_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ku jam ka wakperikaliik ba jigi ate ba yaa weeni chaab ayen, “Nuru baai ale a biisi nna la, daa Galili demma? ");
INSERT INTO bwu_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ku nyɛ ka se ate tama baga a wom ba ale a biisi ti wanyi wanyi tɛŋsaŋa biisaŋa? ");
INSERT INTO bwu_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tama ka Patiya dem, ale Miidi dem, ale Iilam dem, ale Mesopotamiya dem, ale Judia dem, ale Kapadosia dem, ale Pontus dem, ale Asia dem, ");
INSERT INTO bwu_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ale Firijiya dem, ale Pamfiliya dem. ale Ejipiti dem, ale Libia demma baai ale kala mɔata Sairini la. Ti ba gela ka Juuba, ti ba gela daa Juuba a va Juuma wensiuku la a yaa chim nicham a nyini Aroom tɛŋka la. ");
INSERT INTO bwu_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Tama ba gela ka Kariti dem ale Arab dem. Tama a biisi ka biisa tɔgatɔga, alege tama a wom ba ale a biisi ale ti dek tɛŋsaŋa biisaŋa a magsi chaab ale Naawen tuimkperisaŋa wie ale ka dii la kama.” ");
INSERT INTO bwu_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ku jam ka wakperikaliik ba meena jigi ate ba jam tuim a yaa a weeni chaab ayen, “Ka nyaku de kiri ale boa?” ");
INSERT INTO bwu_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Alege mbala me a yaa nyɛ Yeezu ŋaaŋviirima a la ale a weeni chaab ayen, “Nuruma de a nyu ka daam a yib.” ");
INSERT INTO bwu_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Alege Piita yaa ale za ale mbala pi ale wanyiwa la yaa weeni ale lueluk kpioŋ ayen, “Nama Juuma ale baai meena ale bo Jerusalem tɛŋka la, ni meena a lagri ni tueŋa a wom dii ate m tara ayen m weeni a sak ni la. ");
INSERT INTO bwu_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ni basi ate m weeni a sak ni ayen, ni a poli kama ayen nuruma de a nyu ka daam a yib, alege ku daa wensie. Nama kan nya ku ale diem ka saliuk baŋ m neok wa? ");
INSERT INTO bwu_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Naawen biisiteerɔwa Joel jam ŋmarisi Naawen gbaŋka po ayen Naawen a weeni ayen, ");
INSERT INTO bwu_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Tɛŋka meena kpeglimka a dan mɔata, m le nyɛ ka nna. M le kpiiri Naawen Chiika a nyo nuru meena suniima po. Ni nidɔabilisa ale ni nipɔkbilisa le biisi Naawen wieŋa ase ba ka Naawen biisiteerɔba la, ni bipaaluku me le nya wie ase ba goa a daasim kama la, ni nisomma me le goa goadaasima. ");
INSERT INTO bwu_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Wensie, m le poom basi me ate ka jam nuru baai ale a tom a te mu la jigi, nidɔaba ale nipooba. M le basi ate m Chiika jam ba jigi ate ba chim m biisiteerɔba a yaa weeni mi ale a biisi dii la a sak nuruba. ");
INSERT INTO bwu_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","M le nyɛ wakperikaliisa wenŋmazuk ale tɛŋzuk de ate nuruba nya. Ba a le nya ziim, ale bolim ale nyuisa nna kpito, ");
INSERT INTO bwu_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","wenbinni le sobri, ate chiika tagri a muni nna ase ziim la. Nyaŋa de meena a le nyɛ kama alege ate Nyɔnɔwa Dakpeeni a yaa jam. ");
INSERT INTO bwu_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Dila powa waai abe ale a wi Nyɔnɔwa yonni la, le nya varibasika.’ ");
INSERT INTO bwu_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Izirali demma, ni lagi tue a wom wieŋa de. Naawen lueri Yeezu Nazaret denowa kama. Wa be va ka wala nyiŋ a nyɛ wakpeema ale wakperikaliisa ayen ku sak ni ayen ka wa ale lueri wa. Wa abe nyɛ wieŋa de ka nama nimbie po. Ni be seba nyaku de a chak kama nalimnyiini. ");
INSERT INTO bwu_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yeezuwa de ate nama a yik a te tuimbaata nyam ayen ba ko wa. Ni be ale nyɛ dii la, ka Naawen ale poli ku ayen ku nyɛ dila. ");
INSERT INTO bwu_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Alege Naawen a vari wa kama kum po a basi a yaa nak wa a yiri kum po dii nyiŋ la wa jam daa waai ate kum a baga yik wa a tara. ");
INSERT INTO bwu_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Boan nyiŋŋa, ti kokpieŋka Deevid a ŋmarisi Naawen gbaŋka po kama a magsi chaab ale wa ayen, ‘Mi kasim jam a nya Nyɔnɔwa kama ale wa bo ale mu. Wa kasim mɔata mu kama ate yɔgsum kan yik mu. ");
INSERT INTO bwu_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Dila nyiŋ m sui a jam peenti kama ate m biika meena po supeentik a kasim boro. M seba ayen m le kpi kama alege mi a vuusi kama ale yiila, ");
INSERT INTO bwu_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","boan nyiŋŋa, fi kan zɛri mu a basi ate m cheŋ kpiluŋŋɔa, yaase fi basi ate fi welensa nuruwa a puak vorumu po. ");
INSERT INTO bwu_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Fi sak mu nyeboka siuku kama. M le bo ale fu dii la a basi kama ate m sui peenti yegayega.’ ” ");
INSERT INTO bwu_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Piita yaa ŋman biisi ayen, “M suaata, ni basi ate m biisi lak a sak ni ayen ni kokpieŋka Deevid a kpi kama ate ba gu wa. Wa boosuku abe diem boro kama a jam paari jinla. ");
INSERT INTO bwu_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Wa jam ka Naawen biisiteerɔma wanyi a seba Naawen ale puulim dii ale wa la. Naawen jam puulim kama ayen wa le nyɛ ate Deevid ŋaaŋbisaŋa po wanyi a chim naab ase Deevid dek ale jam ka naab dii la. ");
INSERT INTO bwu_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Deevid abe jam nya Naawen ale jam ayen wa nyɛ dii la kama, ate wa yaa biisi a magsi chaab ale waai ate wa lueri la le wa kpi abe wa yiri kum po la, Deevid yaa biisi ayen, ‘Naawen an jam yuk wa a basi kpiluŋŋɔa. Wa be an jam puak vorumu po me.’ ");
INSERT INTO bwu_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Naawen abe nak Yeezuwa de a yiri kum po kama. Tama abe nya wanni de kama a yaa weeni a sak ni. ");
INSERT INTO bwu_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Naawen zak wa kama a kali wa dek juga geŋ ate wa yaa tuesi Naawen Chiika wa Kowa Naawen jigi ase wa ale jam puulim dii ayen wa a le pa Naawen Chiika a te wa la. Ni be ale a nya ale a wom dii yɔgyɔgla de la, ka wa tiirimu ate Yeezu a pa kpiiri sueri tama. ");
INSERT INTO bwu_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Boan nyiŋŋa Deevid dek an jueli wenŋmazuwa, alege weeni ti Naawen Gbaŋka po ayen, ‘Nyɔnɔwa a weeni mi Nyɔnɔwa ayen, Kali dela, mi juga geŋ ");
INSERT INTO bwu_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ate ku ga paari diipo ate m le basi ate fi dachaasaŋa a chim fi yom la.’ ");
INSERT INTO bwu_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Nama Izirali demma ku a fe kama ayen ni seba a chak ayen ka Yeezuwa de ate ni yik wa a kpi jabarimu nyiŋ la ate Naawen basi ate wa chim Nyɔnɔ ale waai ate wa lueri la.” ");
INSERT INTO bwu_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nuruma ale jam wom Piita biika de meena a nueri la, yɔgsum yaa yik ba nalimnyiini, ate ba yaa bek Piita ale tuimtomdɔ mbala, ayen, “Ti suaata, ti be ti nyɛ ka se?” ");
INSERT INTO bwu_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piita yaa tulisi ba ayen, “Ni meena basi ni tuimbaataŋa tomka abe ni tuesi soka Yeezu Kirisita yoi nyiŋ ate wa voŋ ni wabaataŋa a te ni ate ni yaa nya Naawen tiirimu buui ale ka Naawen Chiika la. ");
INSERT INTO bwu_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Dii nyiŋ la, Naawen jam puulim kama ayen wa ale pa tiirimu de a te nama ale ni bisa ale baai me ale yalima la ale waai meena ate Nyɔnɔwa tama Naawenni a wi ba a te wa dek la.” ");
INSERT INTO bwu_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piita jam biisi ka wa bɔari nna yegayega ale deŋsi ba kpa a weeni ayen, “Ni vari ni dek a ta nyini ninam buui ale cheena nyeka tuem nyamma jigi la.” ");
INSERT INTO bwu_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nuruba yegayega a jam siak a te wa ale biisi dii la kama ate ba yaa tuesi soka. Waai meena ale jam ta siaka a maa gum ba po da dila danni la, a jam paari ka nuruba tusa ŋata. ");
INSERT INTO bwu_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ba kasim jam pa ka ba dek a te tuimtomdɔma sinsaŋŋa, ba an jam poori chaab ale ba popola ale ba ŋanta ba nyeboka meena po, ba jam pa ba dek meena a te Nyɔnɔwa ŋandiintaŋa deka. Ba jam pa ba dek me a te ka Naawen puusa. ");
INSERT INTO bwu_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Yɔgsum nna yegayega ale jam yik waai meena. Naawen a jam va ka tuimtomdɔma nyiŋ a nyɛ wakperikaliisa nna yegayega ale nyɛ wie me ŋaai ale a sak ba ayen wa bo ale ba kama la. ");
INSERT INTO bwu_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Baai meena ale ta siaka a va wensiuku la, a kasim jam boro ale ka chaab ba popola ale ba tuima jigi a pa ba ŋantaŋa a maari chaab ");
INSERT INTO bwu_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","a pa ba ŋantaŋa a da a pa ligraŋa a chari chaab a magsi ale ba wanyi wanyi ale sum a yaali dii la. ");
INSERT INTO bwu_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Daa meena ba kasim a nyɛ ka tuka ale popola yena Juuma Puusika Yenni po. Ba maa chaab me ba yeeŋa po a de ba ŋandiintaŋa ale supeentik ale chaab ");
INSERT INTO bwu_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ale a pak Naawen, ale ta supeentik ale nuruba meena. Daa meena Nyɔnɔwa a ta ka nuru baai ale a nya varibasika la jam a gum ba po. ");
INSERT INTO bwu_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Da yeŋ ate Piita ale Jɔɔn a yaa yiri wenbalini (baŋ buta) a cheŋ Juuma Puusika Yenni ayen ba puusi Naawen. Diipo ate tɛŋ kala nuruba ga a puusi Naawen la ale la. ");
INSERT INTO bwu_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Juuma Puusika Yenni a jam ta ka noa bɔari. Nɔanni dinyi yoi ale Nalim noai. Nuru ale jam chim gbaruk a ta nyini wa biamu danni ate ba yaa kasim ta wa daa meena a jam a dueni Puusika Yenni nɔanni ate ba a wi ayen Nalim Noai la. Ba yaa nyiem ta wa jam ayen wa a juisi nuru baai ale a jo Juuma Puusika Yenni po la. ");
INSERT INTO bwu_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Wa ale jam nya Piita ale Jɔɔn ale ba cheena ayen ba jo la, wa yaa juisi ba ayen ba te wa jaab. ");
INSERT INTO bwu_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ba yaa nya wa nina po nna ziim, ate Piita yaa weeni wa ayen, “Nya tama.” ");
INSERT INTO bwu_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Wa yaa kasim a nya ale a yiili ayen wa ale nya ka jaab ba jigi. ");
INSERT INTO bwu_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Alege Piita yaa weeni wa ayen, “Mi ka ligra, alege m le te fu ka mi ale ta jaab buui la. Yeezu Kirisita Nazaret denowa yonni nyiŋ ate mi a weeni fu ayen fi yiri zaani cheŋ.” ");
INSERT INTO bwu_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Piita yaa yik wa juga nisaŋa a maa maari wa ate wa yiri. Nuruwa naŋsaŋa a le kunaŋa a deri ta pagrim nna nwuli ");
INSERT INTO bwu_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ate wa yok jueli wein a jam zi a yaa va ba a maa bo Juuma Puusika Yenni po a cheŋ ale yok a zi a pak Naawen ");
INSERT INTO bwu_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ate nuruma meena a nya wa ale a cheŋ ale a pak Naawen la ");
INSERT INTO bwu_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ate ba yaa miŋ ayen wa ka waai ale a kali Nalim Nɔanni a juisi la. Ku yaa chim wakperikaliik nna yegayega a te ba. ");
INSERT INTO bwu_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Piita ale Jɔɔn a yaa pilim jam bo ka Yenni po juijui ate ba a wi ayen Solomon Posuk la. Nuruwa ale jam bobi Piita ale Jɔɔn nna keŋkeŋ a ta la, ku yaa cha nuruma meena ate ba yaa chali cheŋ Piita ale Jɔɔn jigi. ");
INSERT INTO bwu_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Piita ale nya nuruma la wa yaa weeni ba ayen, “Izirali demma, ka boa ale soa ate ni basi ate wanni de a cha ni? Be ka boan me ale soa ate ni a nya ti dila? Nama poli ayen ku ka tama dek pagrim nyiŋ yaase ti dek wein siuk tuima nyiŋ ale soa ate tama nyɛ ate nuruwa de a baga a cheŋ? ");
INSERT INTO bwu_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Aawo, ku ka Abraham ale Aizik ale Jekob ale ti kokpieŋsaŋa Naawenni ale te zula wa tomteerɔwa Yeezu. Alege nama ale yik wa a te Gominawa Paalɔt a yaa zɛri wa wa niŋ. Paalɔt jam poom a yaali ayen wa vari wa a basi kama alege nama zɛri. ");
INSERT INTO bwu_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yeezu a jam ka welensa ale wayɔrisima nyɔnɔ, alege nama zɛri wa kama alege weeni Paalɔt ayen wa yeeri nuru koorowa a te ni. ");
INSERT INTO bwu_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nama be ko ka nyuvuri teerɔwa. Naawen abe nak wa yiri kum po kama. Tama be nya wanni de kama a yaa weeni a sak ni. ");
INSERT INTO bwu_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ku be poom ka wala yonni pagrim nyiŋ ale siaka wa yonni nyiŋ ate nuruwa de ate ni seba wa la a nya nyiŋyɔgsa ate ni a nya wa ate wa ta pagrim. Ni ale a nya dii nna la, ku ka siaka Yeezu yonni nyiŋ ate nuruwa a tara a yaa nya nyiŋyɔgsa nalimnyiini nama meena nimbie po. ");
INSERT INTO bwu_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Yɔgyɔgla de m suaata, m seba ayen nama ale ni kpaŋŋa ale nyɛ Yeezu dii la, ni ze kama, ate ni nyɛ. ");
INSERT INTO bwu_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Alege, nama ale nyɛ dii la, ku ka Naawen ale pa te wa biisiteerɔma meena dila po dila powa a yaa weeni ayen, ku a fe kama ate waai ate wa lueri la a nam. Ku sum jam chim ka wensie. ");
INSERT INTO bwu_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Dila nyiŋ ni be tagri a basi ni tuimbaataŋa ate Naawen a voŋ a te ni. Ni dan nyɛ dila supeentik ale nyini Nyɔnɔwa jigi a jam ni jigi ");
INSERT INTO bwu_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ate wa basi ate Yeezu waai ale ka Kirisitawa ate wa poom lueri wa a te ni la a yaa jam ni jigi. ");
INSERT INTO bwu_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Wa ale kasim bo ka wenŋmazuk ate ku ga paari diipo ate wa le jam nyɛ wie meena a magsi ase Naawen ale jam pa wa biisiteerɔ welensaŋa a biisi dii dila po dila po la. ");
INSERT INTO bwu_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Boan nyiŋŋa, Moosis a weeni kama ayen, ‘Nyɔnɔwa fi Naawenni a le tom ate biisiteerɔ jam ase mi la. Biisiteerɔwa de a chim ka ni dek nuru. Ku be a fe kama ayen ni siak a va wari meena ate wa a weeni ni ayen ni nyɛ la. ");
INSERT INTO bwu_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nuru waai abe ale kan a va dii ate biisiteerɔwa de a weeni la, ku a fe kama ayen Naawen poori wa nuruma po a kaasi wa.’ ");
INSERT INTO bwu_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Biisiteerɔma baai meena ale biisi a ta nyini Samuel la, ale baai me ale pa saŋ wa la, bala meena a biisi magsi chaab ale ka wie ŋaai ale nyɛ daaŋa de la. ");
INSERT INTO bwu_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nama be ka biisiteerɔma de bisa. Naawen abe ale jam nyɛ noayeŋka dila po dila po ale ni kokpieŋsaŋa la, nama abe maa ta noayeŋ kala me kama ase wa ale jam weeni Abraham ayen, ‘M le va ka fi ŋaaŋbisaŋa nyiŋ a niak waai meena tɛŋzuk.’ ");
INSERT INTO bwu_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Dila nyiŋ ate Naawen lueri wa yomowa de niŋ tom wa nama jigi ayen wa te ni niaka. Niaka de ale wa a le nyɛ ate nama waai meena a basi wa gaasa suitaŋa vaka.” ");
INSERT INTO bwu_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ba ale jam boro a biisi ale nuruma la, Juuma Puusika Yenni kpaŋŋa ale Juuma Puusika Yenni limsidɔma kpagini ale nuru baai ate ba a wi ayen Sajusi la, a yaa maa chaab a jam ba jigi ");
INSERT INTO bwu_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ale supuurim dii nyiŋ la Piita ale Jɔɔn a jam a sak nuruma kama ayen Yeezu a yiri kum po kama. Dila abe a sak kama ayen baai ale kpi la a le yiri kum po kama. ");
INSERT INTO bwu_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Dila nyiŋ ba yaa yik Piita ale Jɔɔn a lik ate vari veenti dii nyiŋ la, ku jam poom deri ka junɔai. ");
INSERT INTO bwu_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Alege baai yegayega ale wom ba sinsaŋŋa la, a jam siak a te ŋa kama ate ba meena a gum chaab paari nidɔaba tusa ŋanu. ");
INSERT INTO bwu_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Vari ale veenti la, Juuma nalimaŋa ale nisomma ale Juuma Sinsaŋŋa sagrɔma a jam tigsi chaab Jerusalem tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ba jam tu chaab ale ka Anasi waai ale ka Juuma Puusika Yenni kpagi kpeeni la, ale nuru baai ate ba a wi ayen Kayafas ale Jɔɔn ale Alezanda la ale baai meena ale ka Anasi dɔkdemma po la. ");
INSERT INTO bwu_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ba yaa yik tuimtomdɔma a zaani ba niŋ a bek ba ayen, “Ka boan jaab pagrim nyiŋ a yaase ka wana yoi nyiŋ ate nama nyɛ nna?” ");
INSERT INTO bwu_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Naawen Chiika abe ale jam sueri Piita la, wa yaa tulisi ba ayen, “Nuruma kpaga ale nisomma, ");
INSERT INTO bwu_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Nama a dan a bek tama jinla a magsi chaab ale wamaŋ kaai ate ti nyɛ a te gbaruku la ale jaab buui nyiŋ ate nuruwa de a nya nyiŋyɔgsa la, ");
INSERT INTO bwu_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ku a fe kama ayen nama meena ale Izirali tɛŋka demma meena a seba ayen ka Yeezu Kirisita Nazaret denowa waai ate ni yik kpi jabarimu nyiŋ ate Naawen nak wa yiri kum po la, wala yonni nyiŋ ate nuruwa de ale za ni niŋ la a nya nyiŋyɔgsa. ");
INSERT INTO bwu_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ba ale ŋmarisi dii Naawen gbaŋka po la ka wensie a magsi chaab ale Yeezu ayen, ‘Tintain dii ate seeroma a zɛri la a chim ka tintain maŋ ŋa meena po.’ ");
INSERT INTO bwu_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Varibasika a va ka wala nyiini nyiŋ a jam. Nuru ka tɛŋzuk de ate Naawen a te ti ate kula nyɔnɔwa a baga vari ti a basi. Ka wala nyiini.” ");
INSERT INTO bwu_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ba ale jam nya ale Piita ale Jɔɔn a ta pagrim a baga biisi nna alege ba an zamsi gbaŋ a paari niŋ la, ku yaa cha ba nna yegayega ate ba yaa miŋ ayen ba jam boro ale ka Yeezu. ");
INSERT INTO bwu_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Alege ba jam ka wari a weeni, dii nyiŋ la, nuru waai ate ba tebi la a jam za ale ka Piita ale Jɔɔn. ");
INSERT INTO bwu_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ba yaa weeni ba ayen ba nyini kpaŋŋa dɔkku po a nyini peelim. Piita ale Jɔɔn ale ga nyini la, kpaŋŋa yaa deri piilim a biisi ale chaab ayen, ");
INSERT INTO bwu_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ti baga a nyɛ nuruma de ka se? Wakperikaliika de ate ba nyɛ nna ate waai meena Jerusalem tɛŋka po a nya la? Ti be an baga a nak nampaga me ale di me. ");
INSERT INTO bwu_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ti be dan a yaali ayen wanni de a kan ŋman tagli jigi meena, ni basi ate ti kaam ba ayen ba kan ŋman pa Yeezu yonni nyiŋŋa a biisi wari ale waaiya.” ");
INSERT INTO bwu_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ba yaa wi Piita ale Jɔɔn a kaam ba ayen ba kan ŋman pai Yeezu yonni nyiŋ a biisi a yaase ba sak waaiya. ");
INSERT INTO bwu_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Alege Piita ale Jɔɔn a yaa tulisi ba ayen, “Nama dek a be weeni nyaku de ase ka ku kuna dek ale magsi Naawen jigi ase ka ti zuli nama yaa ti zuli Naawen ya? ");
INSERT INTO bwu_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Boan nyiŋŋa, tama an baga basi dii ate tama dek a nya ale wom la biiga.” ");
INSERT INTO bwu_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kpaŋŋa a yaa ŋman kaam ba ale nin muna a gum du a yaa basi ba ate ba cheŋ, dii nyiŋ la ku jam pagra kama ate ba nya siuk a te ba waalika, boan nyiŋŋa, nuruma meena a kasim jam a te ka Naawen pimpauk ale dii ale nyɛ la. ");
INSERT INTO bwu_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Dii nyiŋ la, nuru waai ate wakperikaliika de a jam nyɛ wa jigi ate wa nya nyiŋyɔgsa la, a jam gaam bena pisinaansi kama. ");
INSERT INTO bwu_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ba ale jam pa Piita ale Jɔɔn a basi la, ba yaa pilim ŋman cheŋ ba Kirisita bisa vaanchaama jigi a weeni a sak ba Juuma Puusika Yenni kpaŋŋa ale nisomma ale weeni ba dii la. ");
INSERT INTO bwu_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ba ale wom la, ba yaa maa chaab a puusi Naawen ayen, “Ti Nyɔnɔ, fi waai ale nyɛ wenŋmazuk ale tɛŋ ale nyakpeemu ale ŋanta baai meena ale bo ba po, ate fi soa ba la, ");
INSERT INTO bwu_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","fi va Naawen Chiika nyiŋ a pa biisi ale ti kokpieŋka Deevid waai ale ka fi tomteerɔ la ate wa yaa weeni ayen, ‘Ka boa ale soa ate nuru baai ale kan daa Juuba la sue a puuri nna yegayega? Ka boa ale soa ate nuruma ta popola kayaata? ");
INSERT INTO bwu_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tɛŋka meena nalimaŋa gomsi ba dek a magsi ka kpaliŋ. Niŋdeeroma de meena abe nyɛ ka tuka ayen ba nyɛ kpaliŋ ale Nyɔnɔwa Naawen ale Kirisitawa ate Naawen a weeni ayen wa le tom wa la.’ ");
INSERT INTO bwu_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ku be sum ka wensie, Naawa Ayerod ale Gominawa Pontios Paalɔt a nyɛ tuka kama tɛŋka de po ale Izirali dem ale baai ale kan daa Izirali dem la a maa chaab a zok ayen ba nyɛ Yeezu waai ale ka tomteerɔ weleŋka ate fi nyɛ wa ate wa chim Kirisitawa la wari. ");
INSERT INTO bwu_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ba tu ka chaab ayen ba nyɛ wanni de, alege ba ŋman ze ayen ka fi dek ale fi pagrim popola ayen di la nyɛ. ");
INSERT INTO bwu_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yɔgyɔgla de, Nyɔnɔ, nya ba ale a nyigsi ti dii ale popola ŋaai ayen ba nyɛ ti jigi la. Be basi ate tama fi tomteerɔma a ta pagrim a biisi fi wamaŋsaŋa abe ti kan a chali yɔgsum. ");
INSERT INTO bwu_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pa fi pagrimu a tebi nuruba, abe fi te siuk ate ti pa fi tomteerɔ weleŋka Yeezu yonni a nyɛ wakperikaliisa ate nuruba nya.” ");
INSERT INTO bwu_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ba ale jam puusi a nueri la, juijui ate ba jam kala la, a yaa jam a choa. Naawen Chiika a jam sueri ba meena suniimaŋa kama ate ba yaa deri piilim a biisi Naawen wamaŋsaŋa ale nyiŋpagra. ");
INSERT INTO bwu_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Baai meena ale jam ta siaka ale Yeezu la, a jam ta ka noai yeŋ ale popola yena. Ba waai jam karo a weeni ayen wa ŋanta baai ate wa ta la ka wa dek wa nyiini ŋanta, alege ba meena a pa ba ŋantaŋa a chari ka chaab. ");
INSERT INTO bwu_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tuimtomdɔma a yaa jam a sak kama ale pagrim ayen ba nya Yeezu ale yiri kum po la kama. Naawen a jam niak ba kama nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nuru a jam ka ba po a nam a yaali jaabɔa. Baai meena ale jam soa tɛŋsa ale yie la, a pa da kama, a ta ligraŋa ");
INSERT INTO bwu_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","a jam a te tuimtomdɔma. Ligraŋa de ba yaa pa kama a chari ba meena a magsi chaab ale ba wanyiwanyi ale sum a yaali ligra dii la. ");
INSERT INTO bwu_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nuru wanyi ale jam boro. Wa yoi ale Josefi. Wa jam ka Livai deno ate ba biak wa tɛŋ kaai ate ba a wi ayen Saipurus la. Tuimtomdɔma a jam te wa ka yoi ayen Banabas. Di kiri ale nuru waai ale a deŋsi nuruba kpa la. ");
INSERT INTO bwu_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nuruwa de waai ale jam ka ba po la, a yaa jam pa wa tɛŋ a da a yaa ta ligraŋa a jam te tuimtomdɔma. ");
INSERT INTO bwu_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Alege nuru ale jam boro. Wa yoi ale Ananaiyas. Wa powa yoi ale Safira. Ba yaa maa chaab a pa ba ŋanta a da. ");
INSERT INTO bwu_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ba yaa maa chaab a poori ligraŋa ŋa gela a ta ba dek ale ge nŋala a te tuimtomdɔma. ");
INSERT INTO bwu_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ba ale ta ligraŋa a jam tuimtomdɔma jigi la, Piita yaa bek wa ayen, “Ananaiyas, ka boa ale soa ate fi basi ate Sitaana paasi fu ate fi velim ale Naawen Chiika alege a yaa tali tɛŋka ligraŋa gela? ");
INSERT INTO bwu_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Diipo ate fi an diem pa ka a da la, daa fi ale jam soa ka? Fi be ale pa ka me a da la, ligraŋa me daa fi ale soa? Be ka boa ale soa ate fi poli a nyɛ wanni de? Nya de, fi an velim ale daa nurubiiga, fi velim ale ka Naawen.” ");
INSERT INTO bwu_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaiyas ale wom nna la, wa yaa deri lo tɛŋ a kpi ate yɔgsum nna yegayega a yaa yik baai meena ale jam wom nyaku de la. ");
INSERT INTO bwu_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nidɔa paaluk baai ale jam bo dula la a yaa pa garupali a vili wa nyiŋka a ji wa ta nyini cheŋ a ga gu. ");
INSERT INTO bwu_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ku ale ga beni maga dek la, wa powa a yaa jam jo. Wa jam ze dii ale nyɛ la. ");
INSERT INTO bwu_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piita a yaa weeni wa ayen, “Weeni a sak mu, fi ale fi chorowa ale pa ni tɛŋka da la, ka ligraŋa meena ale la ate nama a ta jam?” Nipowa yaa tulisi Piita ayen, “Mm, ŋa meena ale la.” ");
INSERT INTO bwu_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Piita yaa bek wa ayen, “Be ka boa ale soa ate fi ale fi chorowa a maa chaab ayen ni nyɛ Nyɔnɔwa Naawen Chiika a nya? Nya de, nidɔa baai ale ta fi chorowa a ga gu la, a ŋman cheena kama dɔkku noai yɔgyɔgla de. Ba be a le ji fi me kama a ta nyini ga gu.” ");
INSERT INTO bwu_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Wa yaa deri lo Piita naŋsa tɛŋ a kpi. Nidɔa paaluku a yaa jam jo a nya ale wa kpiya ate ba yaa ji wa a ta nyini a ga gu wa chorowa tɛŋ. ");
INSERT INTO bwu_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Yɔgsum nna yegayega a yaa jam yik Kirisita bisaŋa meena ale baai meena me ale jam wom wieŋa de la. ");
INSERT INTO bwu_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tuimtomdɔma kasim jam a nyɛ ka wakperikaliisa nna yegayega nuruma po. Baai ale ta siaka la, a kasim jam a nyɛ tuka ale chaab ka Solomon Posuku jigini Juuma Puusika Yenni po. ");
INSERT INTO bwu_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nuru waai ale jam kan daa ba po la a jam a chali ka yɔgsum ayen wa pa wa dek a gum ba po. Alege nuruma a kasim jam a te ba ka pimpauk nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nuru bɔari nna yegayega nidɔaba ale nipooba baai ale jam ta siaka ale Nyɔnɔwa la a kasim jam a gum ba po. ");
INSERT INTO bwu_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tuimtomdɔma ale jam a nyɛ dii la a basi kama ate nuruba ji yɔgnyeensa ale gaduaata ale taasa a ta ba nyini suitaŋa niŋsa ayen Piita a dan va a taam abe wa yisuŋku a jogi va ba zuk a taam. ");
INSERT INTO bwu_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nuru bɔari nna yegayega a jam nyini tɛŋ sii ale kala gilim Jerusalem tɛŋka la a ta nuru baai ale a yuak a yaase chichiribaata a bo ba zuima po la a jam. Ba meena jam nya nyiŋyɔgsa kama. ");
INSERT INTO bwu_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Alege Juuma Puusika Yenni kpagi kpeeni ale wa vaanchaama meena Sajusi demma a yaa jam a de nyuri ale tuimtomdɔma. ");
INSERT INTO bwu_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Dila nyiŋ la, ba yaa yik tuimtomdɔma a lik dɔk kuui po ate ba a lik waai meena ku po la. ");
INSERT INTO bwu_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Yok kuui ate ba lik ba la, Naawen sabiilo a yaa jam lak likka diinaŋa noaŋa a ta tuimtomdɔma a nyini a yaa weeni ba ayen, ");
INSERT INTO bwu_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ni cheŋ a ga jo zaani Juuma Puusika Yenni po a weeni nuruma nyuvuri paalini de kiri ale ka dii la.” ");
INSERT INTO bwu_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tuimtomdɔma yaa siak wa nɔanni a yaa yiri saliuk yokyok a ga jo Juuma Puusika Yenni po a sak nuruma. Dila powa Juuma Puusika Yenni kpaŋŋa kpagi kpeeni ale wa vaanchaama yaa wi Juuma nisomma meena ate ba jam jigi yeŋ a nyɛ tuka. Ba yaa tom nuruba ayen ba cheŋ likka diinaŋa a ga ta tuimtomdɔma a jam ba niŋ. ");
INSERT INTO bwu_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Alege nuruma baai ate ba tom ayen ba ga ta ba a jam la a yaa cheŋ ga a paari alege tuimtomdɔma ka likka dɔkku po ate ba pilim ŋman jam a weeni a sak ba ayen, ");
INSERT INTO bwu_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Tama ale ga a paari likka dɔkku la ku jam lik kama nalimnyiini ate baai ale za a limsi la a diem za a limsi. Alege tama ale ga lagi dɔkku nɔanni la, tama an nya nuru du.” ");
INSERT INTO bwu_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Juuma Puusika Yenni limsidɔma kpagini ale Juuma Puusika Yenni kpaŋŋa ale ga wom dila la, ba yaa tuim ate ba a poli jaab buui ate wanni de le ta jam la. ");
INSERT INTO bwu_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nuru wanyi a yaa jam jo ba jigi a weeni ba ayen, “Ni wom de, nuru baai ate ni yik a lik la, a za Juuma Puusika Yenni po a sak nuruma.” ");
INSERT INTO bwu_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Puusika Yenni limsidɔma kpagini ale wa nuruma a yaa maa chaab a cheŋ a ga ta tuimtomdɔma a ŋman jam. Ba an jam nyɛ pagrim a yik ba dii nyiŋ la ba jam a chali ka yɔgsum ayen nuruma nin zaan yuk ba ale tintana. ");
INSERT INTO bwu_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ba yaa ta tuimtomdɔma a jam zaani kpaŋŋa niŋ ate Juuma Puusika Yenni kpagi kpeeni a yaa bek ba ayen, ");
INSERT INTO bwu_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tama an weeni ni ale nin muna ayen, ni kan pa Yeezu yonni nyiŋ a sak nuruba? Alege nama dek abe nya ni ale kasim a pa ni sinsaŋŋa a sueri Jerusalem tɛŋka po dii la. Ni be a yaali kama ayen ni weeni ayen ka tama ale soa ate wa kpi?” ");
INSERT INTO bwu_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piita ale tuimtomdɔ mbala a yaa tulisi ayen, “Ku a fe kama ayen ti siak a te Naawen noai a gaam nurubiik noai. ");
INSERT INTO bwu_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ni ale yik Yeezu a kpi jabarimu nyiŋ a ko wa la, tama ale ti koma Naawenni a nak wa a yiri kum po kama. ");
INSERT INTO bwu_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Naawen zak wa kama a kali wa dek juga ase Niŋdeero ale Varibasidɔ la ayen ku te Izirali demma siuk ate ba basi ba wabaataŋa tomka ate ba nya wabaataŋa voŋteka. ");
INSERT INTO bwu_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Naawen Chiika waai ate Naawen a pa a te baai ale a zuli wa noai la, ale a weeni wieŋa de. Tama abe maa nya wieŋa de kama ate ti weeni a sak nuruba.” ");
INSERT INTO bwu_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kpaŋŋa ale wom nna la, ku yaa puuri ba sue nalimnyiini ate ba jam a yaali ayen ba ko ba. ");
INSERT INTO bwu_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Alege kpaŋŋa po wanyi a jam ka Farisii. Wa yoi ale Gamaliil. Wa jam ka Juuma Sinsaŋŋa sagrɔ. Waai meena a kasim jam a te wa zula ka nna yegayega. Wala a yaa yiri zaani kpaŋŋa po a weeni ayen ba ta tuimtomdɔma a nyini peelim ate ku nyɛ maga dega. ");
INSERT INTO bwu_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Wa yaa weeni tuka demma ayen, “Izirali demma, ni kpesi ni dek ale ni ale ni nyɛ dii nuruma de jigi la. ");
INSERT INTO bwu_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nama dek baga teeri ayen nuru waai ate ba a wi ayen Teudasi la a jam pa wa dek a sak kama ayen wa ka nuru kpioŋ nna yegayega ate nuruba yaa jam paari nidɔaba kobsinaansi a pa ba dek a te wa. Alege Aroom demma ko wa kama ate wa ŋaaŋviirima meena a jam waaŋ chaab ate wa wanni me a be. ");
INSERT INTO bwu_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Dila ŋaaŋnyiŋ ate Judas Galili denowa me a jam jam diipo ate ba jam boro a chiini nuruma la. Wa ale jam jam la, nuru bɔari ale jam va wa me. Alege ba ko wa me kama ate wa nuruma meena a waaŋ chaab. ");
INSERT INTO bwu_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Dila nyiŋ ate mi a weeni ni ayen ni kan nyɛ nuruma de wariya. Ni basi ba ba dek ba nyiini. Boan nyiŋŋa, ba ale poli dii ale a nyɛ ba nyeka la, ku dan nyini ka nurubiik dek popola jigi, ku a le murum be kama, ");
INSERT INTO bwu_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","alege ku dan nyini ka Naawen jigi, ni an baga ale nak a yiak ba. Ni be kpesi ni dek ate ni kan kpalim chaab ale Naawen ya.” Gamaliil ale weeni dila a ga nueri la, ba yaa deri pa wa sinsaŋŋa, ");
INSERT INTO bwu_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","a yaa wi ate tuimtomdɔma jo ate ba nak ba ale weeni ba ale nin muna ayen ba kan pa Yeezu yonni nyiŋ a biisi wariya, alege basi ba ate ba cheŋ. ");
INSERT INTO bwu_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tuimtomdɔma ale jam basi ba la, ba sue a jam peenti kama dii nyiŋ la, ka Naawen ale pa ba a chim nuru baai ale magsi ayen ba nam a nya chivie Yeezu yonni nyiŋ la. ");
INSERT INTO bwu_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Daa meena Juuma Puusika Yenni po ale nuruba yie po ba kasim jam bo ka ŋa po a sak nuruba ayen Yeezu ka Kirisitawa (waai ate Naawen a weeni ayen wa a le tom ate wa jam la). ");
INSERT INTO bwu_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Va ŋala po ate Yeezu ŋaaŋviirima a yaa jam piisi a gum du la, kpaliŋ a yaa jam yiri ba sunsuŋ, Juuma baai ale jam a biisi Giriki demma biika la, ale baai me ale jam a biisi Juuma biika la. Baai ale jam a biisi Giriki biika la, a jam a ŋuuni kama ayen ba pukoŋŋa a kan jam maari a nya ligi ŋaai ate nuruba jam pa a chari daa meena la. ");
INSERT INTO bwu_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tuimtomdɔma pi ale bayewa a yaa wi ŋaaŋviirima meena ate ba jam jigi yeŋ ate ba weeni ba ayen, “Ku an magsi ayen ti basi Naawen wamaŋsaŋa sakka abe ti ta ligra tuima. ");
INSERT INTO bwu_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Dila nyiŋ m suaata, ni lueri nuruba bayopoi baai dek ate nama a seba ayen Naawen Chiika ale yam, sueri ba kama la, ate tama yaa pa ligra tuimaŋa de a nyo ba nisima po. ");
INSERT INTO bwu_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Abe tama dek a pa ti dek a te Naawen puusa ale wa wamaŋsaŋa sinsaga ase ti ale kasim a nyɛ dii la.” ");
INSERT INTO bwu_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ba meena sue a yaa kasim jam peenti kama ale tuimtomdɔma ale weeni dii nna la. Ba yaa lueri Sitiven waai ale jam ta siaka nalimnyiini la ale ta Naawen Chiika me la. Baai ale pa saŋ la ale: Filip, ale Porokorus, ale Nikano, ale Timon, ale Paminas, ale Nikolasi. Wa jam nyini ka Antiok a yaa tagri wa dek dila po dila po maa va Juuma wensiuku alege wa daa Juu. ");
INSERT INTO bwu_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ba yaa pa ba a sak tuimtomdɔma ate ba puusi Naawen a te ba a pa ba nisima a vi ba zuk. ");
INSERT INTO bwu_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Naawen wanni a yaa kasim jam a tagli Jerusalem meena ate ŋaaŋviirima ale bo dula la a jam piisi a gum du. Juuma Puusika Yenni kpaŋŋa yegayega me a jam ta siaka ale sinsaŋŋa kama. ");
INSERT INTO bwu_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sitiven abe jam ka waai ate Naawen a te wa niaka nna yegayega ate pagrim a sueri wa la. Wa jam tom ka wakperikaliisa nna yegayega nuruma sunsuŋ. ");
INSERT INTO bwu_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Alege tuka dɔk kunyi po nuruba ale jam boro a te ba dek yue ayen Aŋmandaayom. Juuma ale jam maa nyini Sairini ale Alezandiria ale Silisiya, ale Asia tɛŋsaŋa la a yaa jam maa bo ba po. Nya ba de meena a yaa jam maa chaab a ta nampaga ale Sitiven. ");
INSERT INTO bwu_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Alege Naawen Chiika a jam te Sitiven ka yam ate wa dan jam biisi wari, ba an baga a tulisi wa. ");
INSERT INTO bwu_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ba yaa biisi ale noamasim ale nuruma ayen ba weeni ayen ba wom ale wa a le Moosis ale Naawen. ");
INSERT INTO bwu_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ba ale nyɛ nna la, ku yaa te nuruma ale nisomma ale Juuma Sinsaŋŋa sagrɔma nyiŋpagra ate ba yik Sitiven ale pagrim a ta wa a cheŋ tuka kpaŋŋa jigi. ");
INSERT INTO bwu_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ba yaa ta nuruba ba gela a jam jo ayen ba velim a te wa a weeni ayen, “Nuruwa de a kasim a le ti Juuma Puusika Yeri Weleŋka ale Moosis Sinsaŋŋa kama. ");
INSERT INTO bwu_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tama wom kama ale wa weeni me ayen Yeezuwa de a le daasi Juuma Puusika Yenni a lonsi abe wa tagri kisi tii meena ate Moosis a te ti la.” ");
INSERT INTO bwu_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Baai meena ale kali kpaŋŋa tuka dɔkku po la, a yaa kasim jam a nya Sitiven nna zii, a yaa nya ale wa nimbidiaka a nyagsi nna ase Naawen sabiilo nimbidiak la. ");
INSERT INTO bwu_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Juuma Puusika Yenni kpagi kpeeni yaa bek Sitiven ayen, “Nuruma ale a weeni dii la ka wensie?” ");
INSERT INTO bwu_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitiven yaa tulisi wa ale biik ayen, “M suaata ale m koba, ni lak tue a wom mi ale ta dii ayen m biisi la. Naawen waai ate ku magsi ayen nuruba a zuli wa la, a jam pa wa dek a sak ti kowa Abraham kama. Dila powa, Abraham diem jam bo ka Mesopotamiya tɛŋka. Wa an diem jam cheŋ Yaran Naawen yaa jam jam wa jigi Mesopotamiya tɛŋka po ");
INSERT INTO bwu_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","a weeni wa ayen, ‘Basi fi tɛŋka ale fi dɔkdemma abe fi cheŋ tɛŋ kaai ate mi ayen m dak a sak fu la.’ ");
INSERT INTO bwu_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Abraham yaa basi Kaldiya tɛŋka ale ge cheŋ a ga bo Yaran tɛŋka. Abraham kowa ale ga kpi la, Naawen yaa weeni Abraham ayen wa jam tɛŋka de ate ni boro yɔgyɔgla nna la. ");
INSERT INTO bwu_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Dila powa Naawen an jam te Abraham tɛŋka de juijuiya ayen Abraham dek abe soa dela ale fiifiik me la. Alege Naawen jam puulim kama ayen wa a le pa ka a te wa ate wa ale wa ŋaaŋbisa meena a soa ka. Diipo ate Naawen weeni Abraham nna la, wa jam diem ka biiga. ");
INSERT INTO bwu_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Naawen ale weeni wa dii la ale nna ayen, ‘Fi ŋaaŋbisaŋa a le cheŋ ka satɛŋ a ga chim nicham ate ba deri pa ba a chim yom dula jigini. Tɛŋ kala demma le basi ate ba nam ate ku ga paari bena kobsinaansi. ");
INSERT INTO bwu_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Alege tɛŋ kala ate ba tom a te la, mi le bo ka buusa. Dila ŋaaŋnyiŋ ba a le basi tɛŋ kala abe ba nyini a jam dela jigini a te mi zula.’ ");
INSERT INTO bwu_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Naawen yaa weeni Abraham ayen wa gebi wa yoanni ate ku sak ayen wa ale Abraham a yaa ta ka noai yeŋ ale chaab. Abraham a yaa biak Aizik a gebi wa me yoanni wa biam da naaniŋ dai. Aizik me yaa biak Jekob ate Jekob me a yaa chim wa bisa pi ale bayewa ko. (Bisaŋa de ale se Izirali yezuima pi ale ŋayewa.) ");
INSERT INTO bwu_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Jekob bisaŋa yaa a de nyuri ale ba suoku Josefi a deri yik wa a da ate wa chim yomo Ejipiti tɛŋka. Alege Naawen a jam bo ale wa kama ");
INSERT INTO bwu_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","a maa maari a vari wa a basi nalimnyiini ale dii meena wuu ale a daani wa la. Josefi ale din jam a zaani Ejipiti nakpioŋku niŋ la, Naawen yaa te wa nyɛ maŋ ale yam ate ku peenti Ejipiti naawa poi ate wa deri nyɛ Josefi ate wa chim Ejipiti ale wa Yenni Gomina a nya tɛŋka ale wa Yenni zuk. ");
INSERT INTO bwu_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Kom a yaa jam jam Ejipiti ale Keenan tɛŋsaŋa ate ninam nna yegayega a yaa jam. Ti kokpieŋsaŋa an jam baga a nya ŋandiinta. ");
INSERT INTO bwu_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jekob ale wom ayen ŋandiinta a bo Ejipiti tɛŋka la, wa yaa tom wa bisaŋa ti koma ayen ba cheŋ dula jigini. Ba piilim chelim ale la. ");
INSERT INTO bwu_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ba ale ŋman pilim cheŋ dii a nyɛ buye la, Josefi a yaa basi ate wa suaataŋa a miŋ wa, ate Naawa a yaa seba Josefi dɔkdemma. ");
INSERT INTO bwu_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josefi yaa te tuntomiŋ wa kowa Jekob a weeni wa ayen wa ale wa dɔkdemma meena nuruba pisiyopoi ale banuwa a jam Ejipiti tɛŋka a maa boro ale wa. ");
INSERT INTO bwu_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jekob a yaa koalim cheŋ Ejipiti tɛŋka a bo dula a yaa kpi ate ti kokpieŋsaŋa me kpi ");
INSERT INTO bwu_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ate ba yaa pa ba a ta jam tɛŋka de juijui ate ba a wi ayen Sikiim la a gu ba. Ba jam gu ba ka vorub buui po ate ba gu Abraham la. Abraham dek ale jam da vorumu ale ligra Ayaamo bisaŋa jigi Sikiim tɛŋka po. ");
INSERT INTO bwu_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Alege Naawen ale jam puulim dii ale Abraham la a jam mɔata kama. Ti nuruma a yaa ŋmasi jam a piisi a gum du Ejipiti tɛŋka po. ");
INSERT INTO bwu_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Naawa ale jam kpi la ku ŋaaŋnyiŋ ate naab wa choa a yaa ŋman jam soa Ejipiti tɛŋka a nya. Dila po wa Josefi a jam poom kpi kama ate ku beni. Napaalika de jam ze Josefi. ");
INSERT INTO bwu_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Wala a jam ta ka gaasa nna yegayega ale ti kokpieŋsaŋa a fe ba ayen ba pa ba biluaataŋa a ta nyini peelim a dueni ate ba kpi. ");
INSERT INTO bwu_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Dila powa ale ba jam biak Moosis. Wa jam nala ka nna yegayega. Wa jam bo ka wa kowa yenni ate ba a nya wa zuk ate ku ga paari chiisa sita. ");
INSERT INTO bwu_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ba ale jam maa pa wa a dueni peelim ayen wa kpi la, naawa le ale jam pa wa ate wa chim wa dek biik a yaa a nya wa zuk. ");
INSERT INTO bwu_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ba jam sak wa kama Ejipiti demma Yammu meena ale ka dii la ate wa yaa chim nuru kperikaliik wie po ale wa biik po. ");
INSERT INTO bwu_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Moosis ale chim paari bena pisinaansi la, ku yaa jam wa popola po ayen wa cheŋ ga nya wa suaataŋa Izirali bisaŋa. ");
INSERT INTO bwu_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Wa yaa nya ale Ejipiti deno wanyi ale wa a nyɛ Izirali deno wanyi gaasa nna yegayega. Moosis yaa ga ayen wa maari wa suoku Izirali denowa. Wa yaa nyɛ dila a deri ko Ejipiti denowa. ");
INSERT INTO bwu_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Wa jam poli kama ayen wa dek nuruma le miŋ ayen Naawen le pa ka wa a vari ba a basi, alege ba an jam miŋya. ");
INSERT INTO bwu_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Vari ale veenti la Moosis yaa nya ale Izirali demma baye a ta chaab ate wa yaa pii nyiŋ ayen wa gaari ba. Wa yaa weeni ba ayen, ‘Nidɔaba, ni wom de, ni ka suaata, ka boa ale soa ate ni a kpaliŋ chaaba.’ ");
INSERT INTO bwu_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Alege nuru waai ale jam a namsi wa choawa la a yaa tusi Moosis ate wa taam nakpiak ale ge bek Moosis ayen, ‘Ka wana ale ti an bobi fi naam ate fi a biisi tama biisa? ");
INSERT INTO bwu_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Fi a yaali ayen fi ko mi me kama ase deemwa ate fi ko Ejipiti denowa dii la?’ ");
INSERT INTO bwu_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moosis ale wom nna la, wa yaa basi Ejipiti tɛŋka ale yiri chali cheŋ a ga bo Midian tɛŋka. Dula jigini wa yaa biak bisa baye. ");
INSERT INTO bwu_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Bena pisinaansi ale ga taam la, Naawen sabiilo a yaa jam Moosis jigi sagini po guuk kuui ate ba a wi ayen Sinaai Guuk la tɛŋ. Sabiilowa a jam a pa wa dek a sak Moosis bolimu po ate Moosis yaa nya bolimu ale bu a nyɛ nna ase bu a de tiib la. ");
INSERT INTO bwu_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moosis ale jam nya dila la, ku yaa cha wa ate wa yaa forisi paari ayen wa ŋmasi nya chak. Wa yaa jam wom Nyɔnɔwa lueluk ale ku a weeni ayen, ");
INSERT INTO bwu_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Mi ka fi kokpieŋsaŋa Naawen, Abraham ale Aizik ale Jekob Naawen.’ Yɔgsum yaa yik Moosis ate wa nyiŋka a gok ate wa an ŋman jam baga a pa wa nina viriŋ a nya bu. ");
INSERT INTO bwu_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ti Nyɔnɔwa yaa weeni wa ayen, ‘Yeeri fi nuensaŋa, dii nyiŋ la, fi ale za juijui la, ka welensa tɛŋ. ");
INSERT INTO bwu_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","M nya m nuruma ale bo Ejipiti tɛŋka a nam dii nna yegayega la kama. M be wom ba funfobla me kama ate m siŋ jam ayen m vari ba a basi. Gomsi fi dek yɔgyɔgla de ate m tom ate fi cheŋ Ejipiti.’ ");
INSERT INTO bwu_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moosiswa de ate ba jam zɛri wa ale a bek wa ayen, ‘Ka wana ale ti an bobi fi naam ate fi a biisi tama biisa?’ Ka Naawen dek ale tom wa ba jigi. Wa jam basi ate ka Sabiilowa waai ale jam jam wa jigi tiimu ale a de la po la a maa maari wa ayen wa soa ba a nya ba zuk abe wa chim ba varibasidɔ? ");
INSERT INTO bwu_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Wa sum jam de nuruma niŋ kama a ta ba a nyini Ejipiti tɛŋka po a nyini a nyɛ wakperikaliisa ale wie ŋaai ale a sak ayen Naawen bo ale wa kama Ejipiti tɛŋka po ale mogi kpeeni dii ate ba a wi ayen Nyamonuŋ la po, ale sagini po ate ku ga paari bena pisinaansi. ");
INSERT INTO bwu_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moosiswa de abe ale weeni Izirali demma ayen, ‘Naawen a le tom ka wa biisiteerɔ ase mi la ate wa nyini ni po.’ ");
INSERT INTO bwu_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moosiswa de abe ka waai ale jam bo Izirali demma po diipo ate ba jam tigsi chaama sagini po la. Wa jam boro kama diipo ate Naawen sabiilowa a jam biisi ale wa Sinaai Guuku zuk la. Wa be tuesi Naawen tuntomiŋ kaai ale a te ti nyuvuri la kama yaa pa ka a te ti. ");
INSERT INTO bwu_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Alege ti kokpieŋsaŋa a zɛri wa noai kama. Ba tusi wa a basi ka nakpiak ale a yiili ba suniima po ayen ba dan baga abe ba pilim cheŋ Ejipiti tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ba yaa weeni Moosis suoku Aaron ayen, ‘Nyɛ bogluk tii a le ti de ti niŋ la a te ti. Moosiswa de waai ale ta ti nyini Ejipiti tɛŋka po a nyini la, ti ze jaab buui ale nyɛ wa la.’ ");
INSERT INTO bwu_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ka dila powa ate ba nyɛ bogluk ate ku a neensi naabiik ate ba yaa a kaab ku, a nyɛ ŋandiinta tiga a te ku zula, jaab buui ate ba nyɛ ale ba dek nisima la. ");
INSERT INTO bwu_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Dila nyiŋ Naawen yaa pa wa ŋaaŋ a te ba a pa ba basi ayen ba a zuli chiŋmarisaŋa ase ba ale ŋmarisi dii Naawen biisiteerɔma gbaŋka po kaai ale bo Naawen gbaŋka po dii la ayen, ‘Izirali demma, diipo ate ni jam bo sagini po ate ku ga paari bena pisinaansi la, daa mi ate ni jam kaab duŋsaŋa a te la. ");
INSERT INTO bwu_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ni jam pa ka bogluk kuui ate ba a wi ayen Molok la viuku a ji. Ni jam maa pa ka ni chiŋmarika bogluku ate ba a wi ayen Arifan la jameemu a ji a ta cheŋ me. Bala meena ka bogluta ate ni nyɛ a yaa te ti zula. Dila nyiŋ m le basi ate nuruba a ta ni cheŋ gaam Babilon tɛŋka a be.’ ");
INSERT INTO bwu_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Ti kokpieŋsaŋa ale jam bo sagini po la, ba jam ta ka viuk kuui ate ba pa garuku a nyɛ ku ate ba baga kpiti ku a a ta a cheŋ jigi meena ate ba a yaali la. Naawen Sinsaŋŋa piika ate wa jam ŋmarisi ŋa la a jam bo ka viuku de po. Ba jam nyɛ viuku kama ase Naawen ale weeni Moosis ale sak wa me ayen ba nyɛ ku dii la. ");
INSERT INTO bwu_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ku ŋaaŋnyiŋ ate ti kokpieŋsaŋa a tuesi ku ba koma jigi la, a jam ji ku kama diipo ate ba jam va Josua ate ba jam tuesi tɛŋ sii ate Naawen a jam yiak ka nuruma alege ate ba a cheŋ la. Ba jam ta Viuku ka dila tɛŋ sila po ate ku ga paari diipo ate Deevid jam la. ");
INSERT INTO bwu_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Naawen sui jam peenti ale wa kama ate wa bek Naawen ayen wa basi ate wa se yeri a te wa Naawen waai ale ka wa kokpieŋka Jekob Naawen la. ");
INSERT INTO bwu_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Alege Naawen jam basi kama ate Deevid biika Solomon a se yenni a te Naawen. ");
INSERT INTO bwu_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Alege ni basi ate m weeni a sak ni ayen wieŋa de meena wuu po Naawen kpeeni ka daa yie po ŋaai ate nurubisa a pa ba nisima se la, ase Naawen biisiteerɔwa ale weeni dii ayen Naawen weeni ayen, ");
INSERT INTO bwu_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Wenŋmazuk ale mi zukpaglik kpeeŋka, tɛŋzuk de abe ale juijui ate m pa m naŋsaŋa a tabi ka zuk a vuusi la. Ka boan jaab yeri ate nama ale se a te mi? Ka be ate mi a le boro? ");
INSERT INTO bwu_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Daa mi dek ale nyɛ nyaba de meena?’ ” ");
INSERT INTO bwu_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sitiven yaa ŋman biisi a cheŋ a weeni ayen, “Ni ka tukpara nyam. Ni a nyɛ ase ni daa Naawen nuruba la. Ni nyiem kasim a zɛri Naawen Chiika kama. Ase ni kokpieŋsaŋa ale nyɛ dii la, nama me a nyɛ ka dila degadega. ");
INSERT INTO bwu_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Naawen biisiteerɔma wanyi me la a jam boro ate ni koma an basi ate wa namya? Ba jam maa ko ba baai me ale jam mooli sak ayen Wayɔrisima Nyɔnɔ a cheena la. Wayɔrisima Nyɔnɔwa de abe ale nama bobri sak ate ba yik wa a ko la. ");
INSERT INTO bwu_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nama abe ale jam tuesi Naawen Sinsaŋŋa. Naawen sabiiloma dek abe ale jam pa ŋa a te ni. Alege ni an siak a te ŋa.” ");
INSERT INTO bwu_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kpaŋŋa ale wom Sitiven ale a biisi dii la, ku yaa te ba supuurim nna yegayega ate ba ŋobi nyina. ");
INSERT INTO bwu_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Alege Sitiven sunummu ale poom jam sueri ale Naawen Chiika la wa yaa zak zuk a nya wenŋmazuk a yaa nya Naawen nyagsika a yaa nya me ale Yeezu za Naawen juga geŋ. ");
INSERT INTO bwu_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Sitiven yaa weeni ayen, “Ni nya de, mi nya kama ale wenŋmazuk a lagi ate Saalobiika a za Naawen juga geŋ.” ");
INSERT INTO bwu_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kpaŋŋa a yaa kaari nna yegayega a weeni ayen ba kan ŋman a yaali ayen ba wom wa. Ba yaa chali cheŋ wa jigi ");
INSERT INTO bwu_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","a yik wa a ta nyini tɛŋka po a nyini a yaa pa tintana a yuk wa ayen ba ko. Seeroma me a yeeri ba kasaautaŋa a dueni bipaalik kanyi ate ba a wi ayen Sɔɔl naŋsa tɛŋ ayen wa a nya. ");
INSERT INTO bwu_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ba ale jam a yuk wa la, Sitiven a kasim jam a wi ka Nyɔnɔ ayen, “M Nyɔnɔ Yeezu, ŋɔa m chiika.” ");
INSERT INTO bwu_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Wa yaa kpi duna tɛŋ a weeni ate ku jueli ayen, “M Nyɔnɔ, kan teeri wabioku de ate fi bek ba.” Wa ale weeni nna la, wa yaa deri kpi. ");
INSERT INTO bwu_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sɔɔl a jam maa ka baai ale siak ayen ba ko Sitiven la po wanyi. Da dii danni ate ba ko Sitiven la, Kirisita bisaŋa ale a tu chaab Jerusalem tɛŋka la a deri piilim ninam nna yegayega nyaka. Baai ale ta siaka ale Yeezu la, a yaa jam waaŋ chaab Judia ale Samaria tɛŋsaŋa meena po. Ka tuimtomdɔma nyiini ale jam kan waaŋ chaaba. ");
INSERT INTO bwu_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nuru baai ale ŋmasi jam yaali Naawen siuku nna yegayega la, ale jam ta Sitiven a ga gu ale a kaari nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Alege Sɔɔl a jam diem pii ka nyiŋ a nyiem gilim a cheŋ yeeŋa dinyi dinyi a basi ate Kirisita bisaŋa ale a tu chaab la a nam a dari ba meena nidɔaba ale nipooba a yuk basi likka diinaŋa po. ");
INSERT INTO bwu_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Baai meena ale ta siaka ate ba waaŋ jigi meena la, a yaa jam nyiem a cheŋ jigi meena a sak Naawen wamaŋsaŋa. ");
INSERT INTO bwu_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip jam cheŋ ka Samaria tɛŋkpieŋka dek po a sak nuruba. Varibasidɔwa ate Naawen weeni ayen wa le basi ate wa jam la wie. ");
INSERT INTO bwu_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nuru bɔanni ale jam nya wakperikaliik sii ate Filip nyɛ la, ba yaa ŋmasi lagi ba tueŋa nalimnyiini a wom wa sinsaŋŋa. ");
INSERT INTO bwu_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Wie ŋaai ale jam nyɛ la gela ale, nuruba yegayega baai ale jam ta chichiribaata ba zuima po la, a kaari ate ti a nyini, ale baai naŋsa ale ba nisima ale jam kpi la, a jam nya nyiŋyɔgsa kama. ");
INSERT INTO bwu_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Dila nyiŋ la, supeentik nna yegayega a jam bo tɛŋ kala po kama. ");
INSERT INTO bwu_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nuru wanyi ale jam bo tɛŋ kala po. Wa yoi jam ale Simon. Wa jam ka tiita nyɔnɔ. Wa jam pa ka tiita a nyɛ wakperikaliisa nna yegayega ate ŋa cha Samaria demma. Wa jam pa wa dek a chim ka nuru kpioŋ. ");
INSERT INTO bwu_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Waai meena nuru kpeenta ale nuru fiisa tɛŋ kala po a jam a wom wa ka nna yegayega a weeni ayen, “Nuruwa de ta ka Naawen pagrim kpiem buui ate ti a wi wa ayen Pagrim kpioŋ la.” ");
INSERT INTO bwu_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ba jam a wom wa kama nalimnyiini dii nyiŋ la, wa wakperikaliisaŋa a jam cha ba beni ka nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Alege ba ale jam wom Filip sinsaŋŋa a magsi chaab ale Naawen Naamu ale Yeezu Kirisita pagrimu wie la, ba meena nidɔaba ale nipooba a jam tuesi ka soka. ");
INSERT INTO bwu_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon dek a jam maa ta siaka kama. Ba ale jam te wa soka a ga nueri la, wa yaa jam maa boro ale Filip ate ku kasim jam a cha wa ate wa nya Naawen ale pa wa nyɛ wakperikaliisa ale wie ŋaai ale a sak ayen Naawen bo ale wa kama la. ");
INSERT INTO bwu_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tuimtomdɔma ale jam bo Jerusalem la a yaa wom ayen Samaria demma a tuesi Naawen Wanni kama la, ba yaa tom Piita ale Jɔɔn ayen ba cheŋ ba jigi. ");
INSERT INTO bwu_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ba ale jam cheŋ a ga paari la, ba yaa puusi Naawen a te baai ale ta siaka la ayen ba tuesi Naawen Chiika. ");
INSERT INTO bwu_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Dii nyiŋ la, Naawen Chiika an diem jam siŋ ba waai zuwa. Ba jam tuesi ka soka nyiini Nyɔnɔwa Yeezu yonni nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Piita ale Jɔɔn a yaa pa ba nisimaŋa a vi ba zuk ate Naawen yaa te ba Naawen Chiika. ");
INSERT INTO bwu_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon ale nya ayen tuimtomdɔma a pa ba nisima a vi ba zuk ate ba tuesi Naawen Chiika la, wa yaa pa ligra ayen wa te Piita ale Jɔɔn, ");
INSERT INTO bwu_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","a weeni ba ayen, “Ni te mi me pagrimu de choawa ate mi me a dan pa m nisimaŋa a vi nuru zuk, abe wa me a tuesi Naawen Chiika.” ");
INSERT INTO bwu_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Alege Piita a yaa tulisi wa ayen, “Fi ale fi ligraŋa meena maa chaab a kpi, boan nyiŋŋa, fi a poli kama ayen fi baga a da Naawen tiirimu ale ka ligra! ");
INSERT INTO bwu_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Fi niŋ a maa ka ti tuimaŋa po dii nyiŋ la, fi sunummu a ka nyemagsika ale Naawenya. ");
INSERT INTO bwu_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Dila nyiŋ, ku a fe kama ayen fi tagri fi popola baataŋa de abe fi puusi ate Nyɔnɔwa a voŋ a te fu fi ale poli wanni de choawa la nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Dii nyiŋ la, m nya kama ale fi sunummu a kasim sueri ale ka nyuri ate ku basi ate fi an baga a chala be fi wabaataŋa jigiya.” ");
INSERT INTO bwu_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon a yaa weeni Piita ale Jɔɔn ayen, “Mi a saalim, ni puusi a te Nyɔnɔwa a te mu ate wieŋa de meena ate ni biisi la a kan jam mi jigiya.” ");
INSERT INTO bwu_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Piita ale Jɔɔn ale biisi soa se ba ale seba Yeezu a soa dii la, ale maa sak ba Naawen wamaŋsaŋa a ga nueri la, ba yaa pilim ŋman cheŋ Jerusalem tɛŋka. Ba ale jam bo siuku po a cheŋ la, ba jam sak Naawen wamaŋsaŋa Samaria tɛŋfiisaŋa yegayega po kama. ");
INSERT INTO bwu_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nyɔnɔwa sabiilo a yaa weeni Filip ayen, “Gomsi fi dek a yiri cheŋ a va yeniŋ gala nyiŋ a va siuk kuui ale dua Jerusalem ale Gaza tɛŋka sunsuŋ la.” (Ku ka siuk kuui ale va sagini po a cheŋ la.) ");
INSERT INTO bwu_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Filip a yaa yiri a cheŋ. Wa ale jam bo siuku po a cheŋ la, wa yaa ga tu Itoopiya tɛŋka kpagi kpien dinyi. Wa me a jam bo ka siuku po a kuli. Wa jam a nya ka Itoopiya tɛŋka nipɔk Naawa ligraŋa zuk. Kpagi kpeeni de jam cheŋ ka Jerusalem tɛŋka ayen wa puusi Naawen a yaa puusi nueri a kuli. Wa jam kala ka jaab po ate wusuma dari ta a cheŋ. Wa ale kala wa jaamu po a cheŋ la, wa jam a karim ka Naawen biisiteerɔwa Azaya ale ŋmarisi dii Naawen gbaŋka po la. ");
INSERT INTO bwu_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Naawen Chiika a yaa weeni Filip ayen, “Yiri a ga pa fi dek gum chaab ale nuruwa.” ");
INSERT INTO bwu_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filip a yiri a chali cheŋ wa jigi a yaa wom ale wa a karim ka Naawen biisiteerɔwa Azaya gbaŋka. Filip a yaa bek wa ayen, “Fi miŋ a chak dii ate fi a karim la?” ");
INSERT INTO bwu_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Kpagini a yaa tulisi wa ayen, “Mi a le nyɛ ka se a miŋ chak ase nuru a nin kan weeni ku kiri a sak mu?” Wa yaa wi Filip ate wa jueli a maa kali jaamu po ale wa. ");
INSERT INTO bwu_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nuruwa ale jam a karim dii la ale nna, “Ase posuk ate ba ta a cheŋ ayen ba ko la, ase pabiik ate ba a gebi ka kobtaŋa a basi alege ka kan kaari la, wa an jam weeni wariya. ");
INSERT INTO bwu_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Wa jam nya chivie alege ba jam mini wa wensieŋa kama. Nuru karo ale baga a biisi wari a sak wa ŋaaŋbisaŋa, dii nyiŋ la, wa nyuvunni tɛŋzuk de a kpeglim kama.” ");
INSERT INTO bwu_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kpagini a yaa bek Filip ayen, “Weeni a sak mu ka wana ate biisiteerɔwa a biisi wa wari nna? Ka wa dek yaa ka nuru yoŋŋɔa?” ");
INSERT INTO bwu_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filip a yaa deri pa karimka de a piilim biik a weeni Naawen wamaŋsaŋa a magsi chaab ale Yeezu. ");
INSERT INTO bwu_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ba ale jam va chaab a cheŋ siuku po la, ba yaa jam paari jigi ate nyiam a dua ate kpagini a yaa weeni Filip ayen, “Nyiam ale nna. Ka boan ale wa kasi ate fi kan te mu soka?” ");
INSERT INTO bwu_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filip a yaa weeni wa ayen, “Fi ale nya soka ase fi nin siak ale fi sunum meena.” Kpagini yaa tulisi wa ayen, “Mm, m siak ya ale m sunum meena ayen Yeezu Kirisita ka Naawen biik.” ");
INSERT INTO bwu_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Kpagini yaa nyɛ ate jaamu a zaani, ate wa ale Filip a yaa maa chaab a siŋ nyiamu po ate Filip a te wa soka. ");
INSERT INTO bwu_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ba ale nyini nyiamu po a jueli la, Naawen Chiika a yaa deri ta Filip a cheŋ ale ge kpagini nyiini. Kpagini an ŋman nya wa, alege a yaa cheŋ wa chelimu ale supeentik. ");
INSERT INTO bwu_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip a yaa deri nya ale wa dek a bo ka tɛŋ kaai ate ba a wi ayen Azotus la. Wa nyini tɛŋ kala a cheŋ Siizariya tɛŋka. Wa ale jam bo siuku po a cheŋ la, wa jam a sak Naawen wamaŋsaŋa ka tɛŋsaŋa meena. ");
INSERT INTO bwu_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Nyaŋa de meena ale jam a nyɛ la, alege Sɔɔl a kasim jam diem boro a nyigsi Nyɔnɔwa ŋaaŋviirima kama ayen wa a le ko ba. Wa yaa jam cheŋ Juuma Puusika Yenni kpagi kpeeni jigi ");
INSERT INTO bwu_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","a bek wa ayen wa ŋmarisi gbaŋsa a te wa ate wa ta ga te Damasikus tɛŋka tuka diinaŋa demma, ate gbaŋsaŋa te wa siuk ate wa dan nya waai ale wa ka Nyɔnɔwa siuku nuru, nidɔa yaase nipɔk, abe wa yik kula nyɔnɔwa a bobi a ta cheŋ Jerusalem tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sɔɔl yaa ale bo siuku po a cheŋ ate wa jam mɔata Damasikus tɛŋka la, wenŋmazuk a yaa nyagsi nna yegayega a gilim wa. ");
INSERT INTO bwu_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sɔɔl yaa lo tɛŋ a wom ale lueluk a weeni wa ayen, “Sɔɔl, Sɔɔl, ka boa ale soa ate fi a namsi mu nna?” ");
INSERT INTO bwu_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Alege Sɔɔl a yaa weeni wa ayen, “Ka wana, m Nyɔnɔ?” Ate lueluku a yaa tulisi wa ayen, “Ka mi Yeezu ate fi a namsi, ");
INSERT INTO bwu_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","alege yiri a jo tɛŋka po ale fi le wom dii ale magsi ayen fi nyɛ la.” ");
INSERT INTO bwu_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nidɔa baai ale jam maa va wa a cheŋ la a jam wom ka lueluku alege ba an nya nuru. Ba be an ŋman jam baga a biisi. ");
INSERT INTO bwu_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sɔɔl ale ga yiri ŋmazuk la, wa ninaŋa yaa ligi ate wa an ŋman baga a nya. Ba yaa yik wa nisima a ta wa cheŋ Damasikus tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ku jam paari ka daa ŋata alege wa an diem a nya. Wa be an jam de ŋandiinta a yaase wa nyu nyiam. ");
INSERT INTO bwu_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Yeezu ŋaaŋviirima po wanyi ale bo Damasikus tɛŋka. Wa yue jam ale Ananaiyas. Nyɔnɔwa a yaa jam jam wa jigi nna se wa goa daasim kama la a yaa weeni wa ayen, “Ananaiyas.” Ate wa yaa tulisi ayen, “M Nyɔnɔ, nya mi ale nna.” ");
INSERT INTO bwu_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Nyɔnɔwa a yaa weeni wa ayen, “Yiri a cheŋ siuk kuui ate ba a wi ayen Suyorosuŋ la. Fi dan ga paari Judas yenni, bek ayen fi a yaali ka nuru waai ate ba a wi ayen Sɔɔl ate wa nyini Taasus tɛŋka la. Wa boro a puusi ka Naawen. ");
INSERT INTO bwu_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Wa seba kama ayen fi cheena dii nyiŋ la, wa jam nya nuru nna ase wa goa daasim kama la, ale wa cheena wa jigi. Nuruwa yoi ale Ananaiyas. Wa jam nya wa kama ate wa jam pa wa nisima a vi wa zuk ayen wa ninaŋa ŋman lagri.” ");
INSERT INTO bwu_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananaiyas a yaa tulisi Nyɔnɔwa ayen, “M Nyɔnɔ, mi wom ka nuruba yegayega jigi nuruwa de ale basi ate fi nuruma a nam yegayega dii Jerusalem tɛŋka po la. ");
INSERT INTO bwu_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Wa be tuesi ka pagrim Juuma Puusika Yenni kpaŋŋa jigi a jam Damasikus tɛŋka po ayen wa yik waai ale a wi fi ayen wa Nyɔnɔ la.” ");
INSERT INTO bwu_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nyɔnɔwa a yaa weeni Ananaiyas ayen, “Cheŋ, dii nyiŋ la m potim lueri wa kama ayen wa chim mi tomteerɔ a weeni mi yonni a sak nuru baai ale kan daa Izirali demma la, ale ba nalim kpeema me, ale Izirali demma dek. ");
INSERT INTO bwu_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mi dek abe a le sak wa ninam buui ate wa a le nam mi yonni nyiŋ la.” ");
INSERT INTO bwu_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananaiyas yaa cheŋ ga jo yenni a pa wa nisimaŋa a vi Sɔɔl zuk a weeni wa ayen, “M suok, Sɔɔl, Nyɔnɔwa Yeezu dek waai ale pa wa dek a sak fu siuk kuui po dek ate fi va a jam dela la ale tom mu fi jigi ayen m weeni fu ayen fi ninaŋa a ŋman lagri abe Naawen Chiika a sueri fi sunummu.” ");
INSERT INTO bwu_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Wa ale ga weeni nueri la, ŋanta nna ase jum pagta la a yaa nyini Sɔɔl ninaŋa po a nyini lo ate dula jigini wa yaa ŋman baga a nya. Wa yaa yiri zaani a tuesi soka. ");
INSERT INTO bwu_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Wa ale ga de ŋandiinta la, wa pagrimu a yaa ŋman pilim jam. Sɔɔl yaa jam goa da maga dega Damasikus tɛŋka po ale ŋaaŋviirima. ");
INSERT INTO bwu_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Wa yaa deri cheŋ ga jo Juuma tuka diinaŋa po a deri piilim a sak nuruma Yeezu wie a weeni ba ayen, “Yeezu ka Naawen Biik.” ");
INSERT INTO bwu_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Baai meena ale jam wom wa sinsaŋŋa la, ku yaa cha ba nna yegayega ate ba a bek chaab ayen, “Ee, daa nuru waai ale jam bo Jerusalem tɛŋka a basi ate baai meena ale a wi Yeezu ayen ba Nyɔnɔ la a namu? Wa be jam dela daa dila nyiŋ ayen wa yik ba a ta cheŋ Juuma Puusika Yenni kpaŋŋa jigiya?” ");
INSERT INTO bwu_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Alege Sɔɔl a yaa ŋmasi jam ta ka pagrim nna yegayega a sak wa sinsaŋŋa ale a biisi a nak nampaga nna yegayega ate ku yaa tuim Juuma baai ale jam bo Damasikus tɛŋka po la. Ba bula ŋman jam ka wari a weeni. Wa jam a nyɛ wieŋa de kama ayen ku sak ayen Yeezu sum ka Kirisitawa ate Naawen weeni ayen wa a le tom ate wa jam la. ");
INSERT INTO bwu_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Daa yegayega ale ga taam la, Juuma a yaa jam jigi yeŋ a nyɛ tuka a poli ayen ba ko Sɔɔl. ");
INSERT INTO bwu_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Alege wa jam wom ba ale poli ayen ba nyɛ wa dii la kama. Daa meena yok ale kantueŋ ba kasim jam za ka tɛŋka po tuaataŋa noa a limsi ayen ba dan nya wa abe ba ko wa. ");
INSERT INTO bwu_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Alege da yeŋ yok po ate Sɔɔl ŋaaŋviirima a yaa pa wa a nyo busik po a ta wa va siaka tokparuku ate wa siŋ cheŋ. ");
INSERT INTO bwu_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sɔɔl ale jam cheŋ Jerusalem tɛŋka la, wa jam pii nyiŋ a yaali ayen wa maa pa wa dek a gum Yeezu ŋaaŋviirima po. Alege ba an jam poli ayen wa maa ka Yeezu ŋaaŋviiro. Yɔgsum a yaa jam yik ba. ");
INSERT INTO bwu_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Alege nuru waai ate ba a wi ayen Banabas la yaa maari wa a ta wa jam Yeezu tuimtomdɔma jigi. Banabas yaa weeni sak ba Sɔɔl ale jam bo siuku po a cheŋ Damasikus ate wa nya Nyɔnɔwa ate wa biisi ale wa dii la. Wa ŋman weeni sak ba Sɔɔl ale jam nyini peelim dii Damasikus tɛŋka po a pa Yeezu yonni nyiŋ a sak nuruba ale kan chali yɔgsum la. ");
INSERT INTO bwu_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ba yaa siak ate Sɔɔl a maa boro ale ba Jerusalem tɛŋka po a nyini peelim a sak nuruba Nyɔnɔwa yonni nyiŋ ale kan chali yɔgsum. ");
INSERT INTO bwu_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Wa jam a biisi kama ale a nak nampaga ale baai ale ka Juuma a wom Girik demma biika la. Ba yaa jam pii nyiŋ a yaali ayen ba ko wa. ");
INSERT INTO bwu_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Wa Kirisita bisa suaataŋa ale ga seba la, ba yaa ta wa cheŋ Siizariya tɛŋka, a yaa zaani dula jigini a basi wa ate wa a cheŋ Taasus tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kirisita bisaŋa ale a tu chaab meena a jam bo Judia tɛŋka meena po la, ale Galili tɛŋka meena po la, ale Samaria tɛŋka meena po la a yaa jam boro ale ka masim. Ba siaka jam ta ka pagrim a kasim jam a chim nna yegayega a gum du ate ba va Nyɔnɔwa siuku ale a chali wa. Naawen Chiika abe jam a maari ba kama ate ba jam piisi a gum du. ");
INSERT INTO bwu_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piita kasim jam nyeemu a cheŋ ka Kirisita bisaŋa ale a tu chaab la jigi, jigi meena. Da yeŋ ate wa yaa cheŋ Lida tɛŋka, ayen wa puusi Naawen Nuruma. ");
INSERT INTO bwu_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Dula jigini wa yaa nya nuru wanyi ate ba a wi wa ayen Aniiyas la. Wa jam gbariŋ kama an baga a cheŋ ate wa kasim jam dua tiak po ate ku ga paari bena naaniŋ. ");
INSERT INTO bwu_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piita yaa wi wa ayen, “Aniiyas”, a weeni wa ayen, “Yeezu Kirisita a basi kama ate fi nya nyiŋyɔgsa. Yiri ŋmai a kpamsi fi tiaka.” Aniiyas a yaa deri yiri nna bunyi dekki. ");
INSERT INTO bwu_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nuru baai meena ale bo Lida ale Saaron tɛŋsaŋa ale nya wa la, ba me yaa deri tagri a maa va Nyɔnɔwa. ");
INSERT INTO bwu_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Nipɔk ale jam bo Jopa tɛŋka. Wa maa ka waai ale ta siaka ale Yeezu la. Wa yoi ale Tabita. Ba jam a wi wa ale Giriki demma biika ayen ka Dookas. Ku kiri ale yisik. Wa kasim jam a yaali tuimmaŋsa tomka ale a maari ŋanjagsa me. ");
INSERT INTO bwu_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Va ŋala po nyiŋtuila a yaa yik wa ate wa kpi. Ba ale jam so wa nyiŋka nueri la, ba yaa jam pa wa a ta jueli dueni ŋmazuk dɔk po. ");
INSERT INTO bwu_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida tɛŋka abe ale jam poom mɔata Jopa la, ŋaaŋviirima ale wom ale Piita bo Lida la, ba yaa tom nidɔaba baye wa jigi a saalim wa a weeni ayen, “Ti a saalim, nyɛ nwuli a jam dela.” ");
INSERT INTO bwu_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ba ale ga weeni Piita dila la, wa me a yaa yiri a maa va ba a cheŋ. Wa ale jam la, ba yaa ta wa jueli ŋmazuk dɔkku po. Pukoŋŋa meena a yaa jam gilim wa a kaari ale a sak Piita garuk tii meena ate Dookas a jam nyɛ ti diipo ate wa jam vua la. ");
INSERT INTO bwu_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piita yaa yiak ate ba meena nyini peelim ale ge a kpi duna tɛŋ a puusi Naawen ale ge a virim Dookas jigi a weeni wa ayen, “Tabita, yiri ŋmai.” Tabita yaa lagi wa ninaŋa. Wa ale ga nya Piita la, wa yaa yiri kali ŋmai. ");
INSERT INTO bwu_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piita yaa forisi paari wa a maa maari wa ate wa yiri zaani ŋmai. Piita yaa wi baai ale ta siaka ale Yeezu la, ale pukoŋŋa a yaa pa wa javuuk a te ba. ");
INSERT INTO bwu_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Waai meena Jopa tɛŋka po a jam wom wanni de kama ate nuruba yegayega a yaa jam siak a te Nyɔnɔwa. ");
INSERT INTO bwu_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piita jam goa Jopa kama da bɔari ale nuru wanyi ate ba a wi wa ayen Simon. Wa jam ka gbaŋzaba. ");
INSERT INTO bwu_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nuru ale jam bo Siizariya tɛŋka. Wa yoi jam ale Koniilos. Wa jam ka Aroom sojima beŋ kanyi kpaŋŋa po wanyi. Beŋ kala yoi jam ale, “Italiya beŋka.” ");
INSERT INTO bwu_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Wa jam a yaali ka Naawen siuku wie nna yegayega. Wa ale wa dɔkdemma meena a kasim jam a chali Naawen kama ale a te ŋanjagsa tiirinta nalimnyiini, ale a puusi Naawen daa meena. ");
INSERT INTO bwu_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Da yeŋ ate wenbalini a ta chiem kantueŋ baŋ buta la, ate ku yaa nyɛ wa jigi nna ase wa goa daasim kama la, ate wa yaa nya Naawen sabiilo chak nalimnyiini. Sabiilowa yaa weeni wa ayen, “Koniilos.” ");
INSERT INTO bwu_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ate Koniilos a yaa nya sabiilowa ale yɔgsum a yaa bek Sabiilowa ayen, “Mi a saalim ka boa M Nyɔnɔ?” Sabiilowa a yaa weeni wa ayen, “Fi puusaŋa ale fi tiirintaŋa ate fi a te ŋanjagsaŋa la, a basi kama ate Naawen ta fu wari. ");
INSERT INTO bwu_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Yɔgyɔgla de, be tom nidɔaba ate ba cheŋ Jopa a ga ta nuru wanyi ate ba a wi ayen Simon Piita a ta wa jam. ");
INSERT INTO bwu_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Wa a goa ale ka gbaŋzaba wanyi ate ba a wi ayen Simon. Wa yenni za ka nyakpeemu noai.” ");
INSERT INTO bwu_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Sabiilowa ale ga biisi ale wa a nueri ale cheŋ la, Koniilos a yaa wi wa tomteerɔma po baye ale soji wanyi waai ale kasim jam a yaali Naawen siuku wie me la. Wa jam ka waai ale kasim jam mɔata wa nalimnyiini a tom a te wa la. ");
INSERT INTO bwu_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Koniilos yaa weeni dii meena ale nyɛ la a sak ba ale ge a tom ba ayen ba cheŋ Jopa. ");
INSERT INTO bwu_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Vari ale ga veenti ate ba bo siuku po a cheŋ a yaa jam boro a mɔata tɛŋ kaai ate ba a cheŋ la, Piita yaa jam jueli gboŋ zuk kantueŋ sunsuŋ ayen wa puusi Naawen. ");
INSERT INTO bwu_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kom a yaa jam yik wa ate wa yaa jam a yaali ŋandiinta ayen wa de. Ba ale jam diem boro a dik ŋandiintaŋa la, ku yaa nyɛ wa jigi nna ase wa goa daasim la, ");
INSERT INTO bwu_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ate wa nya ale wenŋmazuk a lagri ate jaab ase gatta kpieŋ la ate jaab a yik ka noa bunaansiwa meena a yaa siŋ cheena tɛŋ. ");
INSERT INTO bwu_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Goaduŋsa meena kanyikanyi ale ŋanta baai meena ale a cheŋ ba loga nyiŋsa la wanyiwanyi, ale nuinsa meena bunyibunyi ale jam bo ka po. ");
INSERT INTO bwu_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Lueluk a yaa weeni Piita ayen, “Piita, yiri ŋmai, ko jaab buui dek ate fi a yaali la a de.” ");
INSERT INTO bwu_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Alege Piita yaa tulisi ayen, “Aawo, m Nyɔnɔ, dii nyiŋ la, mi an diem maa de jaab buui ale ka tama kisuk jaab la.” ");
INSERT INTO bwu_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Lueluku a ŋman pilim jam wa jigi a nyɛ buye a weeni wa ayen, “Naawen ale weeni jaab buui ayen wa ka jaweleŋ la, ku a fe kama ayen fi kan weeni ayen jaab wala ka fi kisuk jaabɔa.” ");
INSERT INTO bwu_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Nyaku de a jam nyɛ ka buta ale ge ate gatiaka a yaa ŋman yiri jueli wenŋmazuk. ");
INSERT INTO bwu_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piita ale jam boro a poli wanni de kiri ale ka dii la, nuru baai ate Koniilos a jam tom ba la a yaa bek Simon Yenni jigi a jam za tuoku noai ");
INSERT INTO bwu_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","a yaa wi a bek ayen, “Simon waai ate ba a wi ayen Piita me la bo dela?” ");
INSERT INTO bwu_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piita a jam diem boro a poli ka wanni kiri ale ka dii la ate Naawen Chiika a yaa weeni wa ayen, “Wom de, nidɔaba bata ale bo dela jigini a gisi fu. ");
INSERT INTO bwu_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Yiri siŋ tɛŋ a va ba a cheŋ. Kan basi ate ku daani fu dii nyiŋ la, ka mi ale tom ba fi jigi.” ");
INSERT INTO bwu_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piita a yaa yiri siŋ ba jigi a weeni ba ayen, “Ka mi ale nuru waai ate ni a gisi la. Ka boa ate ni jam?” ");
INSERT INTO bwu_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ba yaa tulisi wa ayen, “Ka soji kpagini Koniilos ale tom ti. Wa ka nuru waai ale ka nuru maŋ a chali Naawen nalimnyiini ate Juuma meena a zuli wa nna yegayega la. Naawen sabiilo ale weeni wa ayen wa tom wi fu ayen fi jam ate wa wom dii ate fi ta ayen fi weeni sak wa la.” ");
INSERT INTO bwu_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Piita yaa wi ba ate ba jo goa yok kula. Vari ale ga veenti la wa yaa maa va ba a cheŋ. Jopa demma ba gela baai ale ta siaka maara la a jam maa va ba a cheŋ. ");
INSERT INTO bwu_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Da dii ale pa a saŋ la, ba yaa cheŋ paari Siizariya tɛŋka, juijui ate Koniilos ale wa mabisa ale wa doa baai ate wa jam wi ba ayen ba jam la. Ba meena a jam kala a limsi Piita kama. ");
INSERT INTO bwu_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Piita ale jam paari Koniilos Yenni ayen wa jo la, Koniilos a yaa ale ga nya wa la, wa yaa kpi duna tɛŋ Piita niŋ, a puusi wa. ");
INSERT INTO bwu_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Alege Piita yaa zak wa a zaani a weeni wa ayen, “Yiri ŋmai, dii nyiŋ la, mi me ka nurubiik ase fi la.” ");
INSERT INTO bwu_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ba jam a biisi kama ale chaab ale ge a jo yenni po. Ba ale ga jo nueri la, Piita yaa nya ale nuruba yegayega a yaa tigsi chaab a kala. ");
INSERT INTO bwu_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Piita yaa weeni ba ayen, “Nama dek seba ayen Juuma wensiuku Sinsaŋŋa a kan basi ate Juu a cheŋ waai ale kan daa Juu la yeri a yaase wa pa wa dek a gum chaab ale ba. Alege Naawen sak mu kama ayen m kan weeni ayen nuru waai karo a welema a yaase wa ta daŋta. ");
INSERT INTO bwu_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Dila nyiŋ fi ale tom a wi mu la, mi an zɛriya. Yɔgyɔgla, be ka boan nyiŋ ate fi tom wi mu?” ");
INSERT INTO bwu_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Koniilos a yaa tulisi wa ayen, “Ku daa ŋanaansi ale jinla ate wanni de a nyɛ. Da yeŋ po wenbalini (a magsi chaab ale baŋ buta) ate mi jam boro a puusi Naawen m yenni po. Nuru a yaa deri jam za mi niŋ. Wa jam jo ka garuk peelita ate ti a nyagsi nna kpelimkpelim. ");
INSERT INTO bwu_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Wa yaa weeni mi ayen, ‘Koniilos, Naawen wom fi puusaŋa kama. Wa be teeri fi tiirintaŋa ate fi a te ŋanjagsa la kama. ");
INSERT INTO bwu_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tom nuru ate wa cheŋ Jopa tɛŋka a ga wi nuru wanyi Simon waai ate ba a wi wa ayen Piita me la. Wa bo ka Simon gbaŋzabawa yenni. Wa yenni mɔata ka nyakpeemu noai.’ ");
INSERT INTO bwu_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Dila nyiŋ ate m tom wi fu nna nwuli ate fi zuli mu a jam. Yɔgyɔgla de ti meena abe kala ka Naawen niŋ, ayen ti wom Nyɔnɔwa ale weeni fu dii ayen fi weeni a sak ti la.” ");
INSERT INTO bwu_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Piita yaa piilim biik a weeni ayen, “Yɔgyɔgla de m seba ayen ku ka wensie ayen Naawen kan lugi nuruba a yaali ba gela ale kan yaali ba gela. ");
INSERT INTO bwu_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Waai a dan a chali wa ale a tom dii ale nala a te wa, nuru wala choa dan poom nyini juijui meena, Naawen a yaali wa kama. ");
INSERT INTO bwu_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nama seba tuntomiŋ kaai ate Naawen ta cheŋ Izirali demma jigi a mooli sak nuruma wa wamaŋsaŋa la. Wamaŋsaŋa tuntomika ta ka suyɔgini a va Yeezu Kirisita waai ale ka waai meena Nyɔnɔ la jigi a jam. ");
INSERT INTO bwu_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","38","Nama seba ayen ka Jɔɔn Sokateerɔwa ale de niŋ a jam sak nuruba soka teka wie ale ge ate wanni de a nyɛ. Ni be seba Yeezu Nazaret denowa de waai ale pa wanni de a piilim sak Galili tɛŋka a ta jam paari Judia tɛŋka la kama. Nama seba me ayen Naawen ale te wa Chiika ale pagrim nalimnyiini dii la kama. Ni seba me wa ale jam nyeemu a tom wamaŋsaŋa tuimaŋa ale a tebi waai meena ate Sitaana ta ba la, dii nyiŋ la, Naawen jam boro ale wa kama. ");
INSERT INTO bwu_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Mi ale m vaanchaama abe nya wieŋa de meena ate wa nyɛ Juuma tɛŋka ale Jerusalem dek ate ti weeni a sak ni. Nuruba ale yik wa a kpi jabarim nyiŋ a ko wa. ");
INSERT INTO bwu_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","41","Alege ku daa ŋata dai ate Naawen nak wa yiri kum po a yaa basi ate wa pa wa dek a sak tama baai nyiini ate Naawen a poom lueri ti ayen ti weeni dii ate tama nya la a sak nuruba chaab. Naawen an basi ate wa pa wa dek a sak waai meena, alege ka tama nyiini ate ti de ŋandiinta ale nyu ale wa diipo ate wa yiri kum po nueri la. ");
INSERT INTO bwu_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Wa yaa weeni ti ale nin muna ayen ti pa Naawen wamaŋsaŋa a sak nuruba abe ti weeni a sak ba ayen wa ka waai ate Naawen lueri wa ayen wa bo buusa a te kpeeba ale ŋanvuuta la. ");
INSERT INTO bwu_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Naawen biisiteerɔma meena a biisi wa wari kama a weeni ayen waai a dan ta siak ale wa, kula nyɔnɔwa le va wa yonni pagrim nyiŋ a nya wa wabaataŋa voŋteka.” ");
INSERT INTO bwu_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Piita ale diem jam boro a biisi la, Naawen Chiika a yaa siŋ jam jo baai meena ale jam a wom wa biika la suniima po. ");
INSERT INTO bwu_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Juuma baai ale jam ta siaka a yaa jam maa va Piita a nyini Jopa tɛŋka a jam la, ku yaa jam cha ba ate ba nya ale Naawen te baai ale kan daa Juuma la Naawen Chiika me. ");
INSERT INTO bwu_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Dii nyiŋ la, ba jam wom kama ale ba a biisi be chaŋsa a pak Naawen ale wa ale nyɛ ŋaai meena la. Piita yaa ŋman biisi a weeni ayen, ");
INSERT INTO bwu_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Nuruma de me a tuesi Naawen Chiika kama ase tama me ale jam tuesi dii la. Nuru karo abe le weeni ayen ba kan tuesi soka ale nyiamɔa.” ");
INSERT INTO bwu_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Wa yaa weeni ayen ba tuesi soka Yeezu Kirisita yonni nyiŋ. Piita ale ga biisi nueri ayen wa kuli la, ba yaa saalim wa ayen wa goa ale ba daa maga abe wa kuli. ");
INSERT INTO bwu_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Tuimtomdɔma ale nuruba ba chaama ale ta siaka ate ba bo Judia tɛŋka meena po la, a yaa jam wom ayen nuru baai ale kan daa Juuba la me a siak a te Naawen Wanni kama. ");
INSERT INTO bwu_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Piita ale ŋman pilim cheŋ Jerusalem tɛŋka la, Juu baai ale a yaali ayen baai ale kan da Juuba la a gebi ba yuaŋa abe ba gum ba po la a yaa jam a tɔariŋ wa a weeni ayen, ");
INSERT INTO bwu_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ka boa ale soa ate fi cheŋ nuru baai ale kan daa Juuba la jigi a de ŋandiinta ale ba?” ");
INSERT INTO bwu_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Piita yaa piilim a tɔgi dii meena ale nyɛ la ayen, ");
INSERT INTO bwu_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Mi ale jam boro a puusi Naawen Jopa tɛŋka po la, ku yaa nyɛ mi jigi nna ase goadaasima la, ate mi yaa nya jaab nna ase gatta kpieŋ la ate jaab a yaa yik ka noa bunaansiwa meena a yaa siŋ cheena tɛŋ a jam zaani a mɔata mi. ");
INSERT INTO bwu_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mi yaa ŋmasi nya jaamu po nalimnyiini a yaa nya ale yeri duŋsa ale goaduŋsa ale ŋanta baai meena ale a cheŋ ba loga nyiŋsa, ale nuinsa. ");
INSERT INTO bwu_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mi yaa wom ale lueluk a weeni mi ayen, ‘Piita, yiri ŋmai. Ko a de.’ ");
INSERT INTO bwu_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mi yaa tulisi ayen, ‘M Nyɔnɔ, aawo, dii nyiŋ la, ba ale biam mi la, mi an diem maa de jaab buui ale ka tama kisuk jaab la.’ ");
INSERT INTO bwu_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Alege lueluku a nyini wenŋmazuk a ŋman weeni mi a nyɛ buye ayen, ‘Naawen ale weeni jaab buui ayen wa ka jaweleŋ la, ku a fe kama ayen fi kan weeni ayen jaab wala ka fi kisuk jaabɔa.’ ");
INSERT INTO bwu_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Nyaku de a jam nyɛ ka buta ale ge ate gatiaka a yaa ŋman yiri jueli wenŋmazuk. ");
INSERT INTO bwu_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Diipo ate jaamu a yiri a jueli la, nidɔaba bata a yaa deri nyini Siizariya tɛŋka a jam yeri dii po ate mi jam boro la a weeni mu ayen ba nyɔnɔwa ale bo Siizariya la ale tom ba mi jigi. ");
INSERT INTO bwu_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Naawen Chiika a yaa weeni mi ayen m yiri a cheŋ abe m kan basi ate ku daani mu. M suaataŋa bayuebiwa de abe maa va ka mi a nyini Jopa a jam ate ti meena a yaa jo Koniilos yenni po. ");
INSERT INTO bwu_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Wa yaa weeni a sak ti wa ale nya Naawen Sabiilo wa yenni po ate wa weeni wa ayen, ‘Tom nuru ate wa cheŋ Jopa tɛŋka a ga wi nuru wanyi ate ba a wi Simon waai ate ba a wi ayen Piita me la. ");
INSERT INTO bwu_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Wa ale biisi wie ale fu ate fi ale fi dɔkdemma meena a dan ta siaka ale ŋa, ni le nya varibasika.’ ");
INSERT INTO bwu_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Mi Piita ale jam piilim boro a biisi ale ba la, Naawen Chiika a deri siŋ jam ba suniima po ase wa ale pilim jam tama jigi dii la. ");
INSERT INTO bwu_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ate mi yaa teeri Nyɔnɔwa ale jam weeni dii la ayen, ‘Jɔɔn Sokateerɔwa a pa ka nyiam a te ni soka alege yɔgyɔgla de mi a le te ni soka kama ale Naawen Chiika.’ ");
INSERT INTO bwu_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Naawen abe jam pa ka tiirim bula a te ba ase wa ale jam pa bula degadega a te tama diipo ate tama a jam siak a te Nyɔnɔwa Yeezu Kirisita la. Naawen abe dan nyɛ dila, mi ka wana ate mi baga a weeni Naawen ayen wa kan nyɛ dila?” ");
INSERT INTO bwu_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ba ale ga wom nna la, ba yaa basi ba nampaga nakka ale ge a te Naawen pimpauk a weeni ayen, “Naawen a be poom te baai me ale kan daa Juuma la siuk kama ayen ba basi ba tuimbaataŋa tomka ate ba nya nyuvuri paalik.” ");
INSERT INTO bwu_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Diipo ate ba jam ko Sitiven ate ninam a jam jam baai ale ta siaka la jigi la ba jam chali waaŋ ka chaab. Dila powa, ba gela a jam chali cheŋ Fonisia ale Saipurus ale Antiok tɛŋsaŋa a yaa nyiem a sak Juuma nyiini Naawen wamaŋsaŋa. ");
INSERT INTO bwu_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ba gela me a jam ka nidɔaba a nyini Saipurus ale Sairini tɛŋsaŋa a cheŋ Antiok tɛŋka. Ba ale ga paari dula la, ba yaa sak baai ale kan daa Juuba la me. Ba jam sak ba ka Naawen wamaŋsaŋa a magsi chaab ale Nyɔnɔwa Yeezu. ");
INSERT INTO bwu_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nyɔnɔwa pagrimu a jam bo ale ba kama ate nuru bɔari nna yegayega a jam ta siaka ale sinsaŋŋa a yaa tagri ba dek a va Nyɔnɔwa. ");
INSERT INTO bwu_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Kirisita bisaŋa ale a tu chaab a bo Jerusalem tɛŋka a yaa ale ga wom nna la, ba yaa tom Banabas ayen wa cheŋ Antiok tɛŋka a ga nya. ");
INSERT INTO bwu_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Banabas a jam ka nuru maŋ a ta siaka nalimnyiini. Naawen Chiika me abe jam sueri wa sunummu kama nalimnyiini. Banabas ale ga paari Antiok a nya ale Naawen a niak ba dii la ku yaa te wa supeentik ate wa yaa deŋsi ba kpa a weeni ba ayen, ba pii nyiŋ a ta siaka ale ba suniima meena ale Nyɔnɔwa. Nuruba yegayega a yaa kasim jam ta siaka ale Nyɔnɔwa a gum mbala po. ");
INSERT INTO bwu_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Banabas a yaa cheŋ Taasus tɛŋka ayen wa gisi Sɔɔl. ");
INSERT INTO bwu_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Wa ale ga nya wa la, wa yaa yik wa a ta cheŋ Antiok. Ba noai bayewa a jam bo ka dula ale Kirisita bisaŋa ale a tu chaab la ate ku ga paari bein. Ba jam a sak ka nuru bɔari nna yegayega ben dila po. Ku jam ka Antiok tɛŋka de po ate nuruba piilim te baai ale ta siaka ale Yeezu la, yoi ayen Kirisita Bisa. ");
INSERT INTO bwu_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Dila powa, Naawen biisiteerɔba ba gela a yaa jam nyini Jerusalem tɛŋka a cheŋ Antiok tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Biisiteerɔma de wanyi yoi a jam ale Agabus. Wala a yaa yiri zaani ale Naawen Chiika pagrimu a weeni ayen kom pagrik ale za bu jam tɛŋzuk de meena. Kommu a sum jam jam kama diipo ate Nakpioŋku Kilɔdiyus a jam boro la. ");
INSERT INTO bwu_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ŋaaŋviirima a yaa jam maa chaab a poli waai meena wanyi wanyi ale baga te ligra dii ate ba pa ŋa a maari ba sua tintila baai me ale ta siaka a bo Judia tɛŋka po la. ");
INSERT INTO bwu_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ba yaa cheesi ba ligraŋa a pa ŋa a te Banabas ale Sɔɔl ate ba ta ŋa a ga te Kirisita bisaŋa ale a tu chaab la nisomma dula jigini. ");
INSERT INTO bwu_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Dila powa, Naab Ayerod a deri jam piilim kama a basi ate Kirisita bisaŋa ale a tu chaab la ba gela a nya ninam nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Wa jam basi kama ate ba yik Jɔɔn suoku Jeemsi a pa gebi kpieŋ a togri wa. ");
INSERT INTO bwu_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Wa ale ga nya ale wanni de a te Juuma popeentik la, wa yaa ŋman yik Piita. Ba yik wa a magsi chaab ale ka dii po ate Juuma a ta ba tigi kpeeni dii po ate ba kan ŋobi boroboruk kuui ale ta dabinta la. ");
INSERT INTO bwu_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ba ale jam yik Piita la, ba deri jam ta wa a ga lik kama, a yaa yaali sojiba pi ale bayuebi ate ba a limsi wa. Wa poori ba ka tɔgatɔga bunaansi. Naawa Ayerod jam nyɛ dila a poli kama ayen Juuma Gaambasika Tigini a dan taam abe wa ta wa nyini peelim ate ba bo wa buusa ate waai meena nya. ");
INSERT INTO bwu_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ba yaa ta Piita a ga lik. Wa ale jam bo likka dɔkku po la, Kirisita bisaŋa ale a tu chaab la a yaa jam puusi Naawen nalimnyiini a te wa. ");
INSERT INTO bwu_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Yok kuui ate Ayerod jam a poli ayen vari a dan veenti abe wa lagri Piita a ta nyini a te nuruma la, Piita jam doa ka limsidɔma baye sunsuŋ a goa. Ba jam pa ka choarima kpeema a bobi wa. Limsidɔba me ale jam za likka dɔkku noai. ");
INSERT INTO bwu_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Nyɔnɔwa sabiilo a yaa deri jam za dula ate ku yaa nyagsi nna yegayega likka dɔkku po, a choa Piita kpinkpaluk a yaa weeni wa ayen, “Nyɛ nwuli, yiri.” Wa ale ga weeni dila la, choarimaŋa yaa deri nyini Piita nisima po a gebi lo. ");
INSERT INTO bwu_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Sabiilowa yaa ŋman weeni ayen, “Pa fi gattaŋa a jo abe fi su fi neunsaŋa.” Piita yaa nyɛ dila ate Sabiilowa a ŋman weeni ayen, “Pa fi kasaauku a jo abe fi jam va mu.” ");
INSERT INTO bwu_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piita yaa va wa nyini likka dɔkku po a nyini alege ze ayen sabiilowa ale nyɛ dii la a sum ka wensie. Piita jam a poli kama ayen da dii dai wa a goa a daasim kama. ");
INSERT INTO bwu_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Sabiilowa ale Piita a yaa jam va chaab a cheŋ a jam gaam niŋka limsidɔma a ŋman jam gaam baai ale pa saŋ la, a yaa ga paari noa dii ate ba pa kutaŋa a nyɛ ate fi gaam ku abe fi yaa deri a jo tɛŋka po la. Ba ale jam a paari tuok kula la, ku yaa deri lagi ku dek ate ba taam nyini a va chaab a cheŋ siuku po. Ba ale cheŋ maga la, Sabiilowa a yaa deri basi Piita wa dek wa nyiini ale ge cheŋ be. ");
INSERT INTO bwu_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Piita yaa deri miŋ dii ale nyɛ wa jigi la ate wa yaa weeni ayen, “Yɔgyɔgla de m seba ayen ka Nyɔnɔwa ale tom wa sabiilowa ate wa jam vari mu Ayerod nisima po ale Juuma ale jam a poli dii la nisima po a basi.” ");
INSERT INTO bwu_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Wa ale miŋ nna la, wa yaa cheŋ Mɛɛri yenni. Mɛɛri a jam ka Jɔɔn ma. Jɔɔn yoi di choa a jam ale Maak. Piita ale jam a paari Mɛɛri yenni la, nuru bɔari nna yegayega ale jam tu chaab dula a boro a puusi Naawen. ");
INSERT INTO bwu_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Piita ale ga a nak dɔkku nɔanni la, pɔkdɔklie wa yue jam ale Aroda, a yaa jam tulisi Piita. ");
INSERT INTO bwu_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Wa ale ga wom lueluku a yaa miŋ ayen ka Piita la, ku yaa deri te wa supeentik nna yegayega ate wa an ŋman poom lagi dɔkku nɔanni alege deri chali a ga weeni ayen, “Ka Piita ale jam za peelim.” ");
INSERT INTO bwu_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ba yaa tulisi wa ayen, “Fi a yesiŋ kama?” Alege wa ŋman ŋmasi weeni ba ayen, “Mi a biisi ka wensie.” Ba ŋman tulisi wa ayen, “Ka wa chiika.” ");
INSERT INTO bwu_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ba ale jam a biisi dila la, Piita a diem a nak dɔkku nɔanni kama. Ba ale lagi nya wa la, ku yaa deri cha ba. ");
INSERT INTO bwu_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Wa yaa yuk nisa ayen ba goori ale ge yaa weeni a sak ba Nyɔnɔwa ale nyɛ dii ate wa nyini likka dɔkku po a nyini la. Wa yaa weeni ba ayen ba weeni nyaku de a sak Jeemsi ale mbala meena ale ta siaka la. Wa ale biisi nna a ga nueri la, wa deri basi ba ale ge nyini cheŋ jigi yoŋ. ");
INSERT INTO bwu_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Vari ale veenti la, ku yaa nyɛ nna ŋaglim sojima sunsuŋ ate ba a begi chaab jaab buui ale nyɛ Piita la. ");
INSERT INTO bwu_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ayerod a yaa weeni ba ayen ba nyiem gisi yik wa a ta jam. Ba jam gisi ka nalimnyiini alege ba an nya wa. Wa yaa wi sojima a bek ba alege a yaa weeni sojiba ba chaab ayen ba ta ba a ga ko. Ku ŋaaŋnyiŋ Ayerod yaa basi Judia tɛŋka ale ge cheŋ Siizariya a goa dula maga dega. ");
INSERT INTO bwu_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ayerod sui ale jam a puuri nna yegayega ale Taaya ale Saidon demma. Da yeŋ, ba yaa nyɛ noai yeŋ a cheŋ ayen ba nya wa. Ba jam de ka niŋ a nya nuru waai ale jam soa Naawa yenni meena a nya la. Wa yoi ale Balastus. Ba yaa jam nya wa ayen wa maa maari ba ate ba nya Naawa. Wa yaa siak te ba siuk. Ba yaa jo Naawa jigi a saalim wa ayen wa basi ate masim ale nyemagsika a jam ba sunsuŋ ate ku basi ate ba ŋman a nya ba ŋandiintaŋa ase wa nyeem ale poom a nyɛ dii la. ");
INSERT INTO bwu_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Da yeŋ ate Ayerod a potim lueri dai a yaa pa wa naam gattaŋa a jo, a yaa kali wa zukpaglika zuk a piilim biik a biisi ale ba. ");
INSERT INTO bwu_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nuruma yaa kaari ate ku jueli nna yegayega ayen, “Daa nuru ale a biisi, ka wein.” ");
INSERT INTO bwu_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Nyɔnɔwa sabiilowa a yaa deri fobi wa lonsi dii nyiŋ la, wa an zuli Naawen ya. Nanzue ale jam de wa ate wa yaa kpi. ");
INSERT INTO bwu_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nyaŋa de meena ale jam a nyɛ la, Naawen wamaŋsaŋa a kasim jam tagli ka jigi meena ate nuruba jam piisi a gum du. ");
INSERT INTO bwu_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabas ale Sɔɔl a yaa jam tom ba tuimaŋa a nueri kama Jerusalem tɛŋka po ale pilim ŋman Antiok. Ba jam ta ka Jɔɔn waai ate ba maara wi wa ayen Maak la a jam. ");
INSERT INTO bwu_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kirisita bisaŋa ale a tu chaab Antiok tɛŋka po la, a jam ta ka Naawen biisiteerɔba ba gela ale sagrɔba ba gela ba po. Ba yue jam ale Banabas ale Simon (waai me ate ba jam a wi ayen Asoblik la) ale Lusiyas Sairini denowa, ale Manayen (waai ale jam bo ale Naawa Ayerod waai ale jam ka Galili naab la) ale Sɔɔl. ");
INSERT INTO bwu_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Da yeŋ ate ba yaa boro a puusi Naawen a bobi ba noa, ate Naawen Chiika a yaa weeni ba ayen, “Ni poori Banabas ale Sɔɔl a te mu ate ba tom tuim dii ate mi wi ba ayen ba tom la.” ");
INSERT INTO bwu_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ba yaa maa chaab a bobi noa a puusi Naawen a pa ba nisima a vi ba zuk ale ge a yaa tom ba ayen ba a cheŋ. ");
INSERT INTO bwu_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Dila nyiŋ, Naawen Chiika a yaa tom Banabas ale Sɔɔl ate ba cheŋ Seliusiya tɛŋka a yaa zaani dula a jueli ŋaaruŋ a cheŋ Saipurus tɛŋka ");
INSERT INTO bwu_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","a yaa ga siŋ cheŋ Salamisi tɛŋka. Ba jam cheŋ ga jo Juuma tuka diinaŋa po a sak ba Naawen wanni. Jɔɔn Maak ale jam maa boro ale ba a maari ba ale ba tuimaŋa. ");
INSERT INTO bwu_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ba yaa ŋman jam basi dula jigini ale cheŋ Pafos tɛŋka. Tɛŋ kala po ba yaa jam nya sampoporik. Wa yoi ale Baayeezu. Wa jam ka Juu. Wa jam a paasi ka nuruba ayen wa ka Naawen biisiteerɔ. ");
INSERT INTO bwu_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Wa jam boro ale ka tɛŋka kpagini ate ba a wi wa ayen Saajus Pɔɔlus la. Pɔɔlus jam tagri ka Aroom kpaŋŋa zuk a nya Saipurus tɛŋka. Wa jam ka yam nyɔnɔ nna yegayega. Wa yaa wi Banabas ale Sɔɔl ayen ba jam weeni Naawen wanni a sak wa. ");
INSERT INTO bwu_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Alege sampoporika Elimas (wa yoi di choa a jam ale la ale Giriki tɛŋka biika) a kasim jam a zɛri ba kama ayen Gominawa kan nya siuk a ta siaka ale Naawen wamaŋsaŋa. ");
INSERT INTO bwu_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Naawen Chiika yaa sueri Sɔɔl (waai yoi di choa ale Pɔɔl la.) ate wa yaa nya sampoporika nimbie po nna zii ");
INSERT INTO bwu_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","a weeni ayen, “Fi ka Velinvendika biik. Fi ka wamaŋsa meena dachiak. Fi kasim sueri ale pimpaasima ale gaasa meena ate fi kasim pii nyiŋ a nyɛ ayen Nyɔnɔwa wensieŋa wieŋa a chim venta. ");
INSERT INTO bwu_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Yɔgyɔgla de, nya de, Nyɔnɔwa nisimaŋa a siŋ fi zuk kama. Fi le yi ate ku beni maga dega.” Pɔɔl ale ga biisi dila a nueri la, ku yaa nyɛ Elimas nina po nna ase legi la, ate wa yaa cheŋ a gilim a gisi ayen wa nya nuru ate wa yik wa nisima a ta wa a kuli. ");
INSERT INTO bwu_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gominawa ale ga nya dila la, wa yaa ta siaka yɔgla. Ku jam cha wa ka nna yegayega ate wa wom sinsaŋŋa de chaab a magsi chaab ale Nyɔnɔwa. ");
INSERT INTO bwu_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pɔɔl ale wa vaanchaama a yaa nyini Pafos a jueli ŋaaruŋ a cheŋ Periga tɛŋka kaai ale bo Pamfiliya tɛŋka po la. Alege Jɔɔn Maak a jam pa ba a basi ka Pamfiliya ale ge pilim ŋmani Jerusalem. ");
INSERT INTO bwu_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ba yaa basi Periga tɛŋka ale ge cheŋ Antiok tɛŋka kaai ale bo Pisidiya tɛŋka po la. Juuma Vuusum Danni ale jam paari la, Pɔɔl ale Banabas yaa jo ba tuka diinaŋa po a kala. ");
INSERT INTO bwu_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nuru wanyi ale ga karim ba Moosis Sinsaŋŋa gbaŋsaŋa po wieŋa ŋa gela ale Naawen biisiteerɔma ale ŋmarisi dii Naawen Gbaŋka po a nueri la, ba tuka diinaŋa kpaŋŋa a yaa tom tuntomiŋ Pɔɔl ale Banabas jigi a weeni ba ayen, “Ti suaata, ti a yaali kama ayen ni dan ta wari ayen ni weeni a deŋsi ti kpa ni be weeni a sak ti.” ");
INSERT INTO bwu_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pɔɔl yaa yiri zaani a zak wa nisima a puusi ba a yaa piilim biik ayen, “Izirali demma ale baai ale kan daa Izirali demma alege a chali Naawen la, nama meena lagi tue a wom dii ate m tara ayen m weeni a sak ni la. ");
INSERT INTO bwu_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Tama Izirali demma de Naawenni ale lueri ti kokpieŋsaŋa. Dii po ate ba jam chim nicham Ejipiti tɛŋka po la, Naawen jam basi ba kama ate ba chim nuru kpeenta. Naawen jam pa ka wa pagrimu a nyɛ ate ba nyini Ejipiti tɛŋka po a nyini. ");
INSERT INTO bwu_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Wa kasim jam duŋ wa sui sagini po ale ba kama ate ku ga paari bena pisinaansi. ");
INSERT INTO bwu_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Wa jam kaasi ka Keenan satɛŋsa siyopoi ale ge a yaa basi ate wa dek nuruma a soa tɛŋ sila. ");
INSERT INTO bwu_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nyaŋa de meena abe pa paari ka bena kobsinaansi ale pisinu ate Naawen a yaa jam te ba kpaga ayen ba a nya tɛŋsaŋa zuk. “Ba jam a nya si zuk ka dila ate ku ga paari dii po ate Naawen biisiteerɔ waai ate ba a wi ayen Samuel la a ga jam. ");
INSERT INTO bwu_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Izirali demma ale ga juisi ayen Naawen te ba naab la, Naawen yaa pa a nuru waai ate ba a wi ayen Sɔɔl la ayen wa chim ba naab ate ku ga paari bena pisinaansi. Sɔɔl jam ka kisi biik. Kisi jam nyini ka Benjamin buuni po. ");
INSERT INTO bwu_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ku ŋaaŋnyiŋ Naawen yeeri wa ale ge zak Deevid a zaani ayen wa chim ba naab. Naawen ale biisi dii a magsi chaab ale Deevid la ale nna ayen, ‘Mi nya kama ale ka Jese biika Deevid ale chim nuru waai ate mi sunummu a bo ale wa la. Wa ka nuru waai a le wa tom dii ate mi a yaali la nalimnyiini.’ ” ");
INSERT INTO bwu_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Pɔɔl yaa ŋman biisi a cheŋ a weeni ayen, “Ase Naawen ale jam puulim dii a magsi chaab ale varibasidɔwa la, ku jam ka Deevid wa de ŋaaŋbiika Yeezu ate Naawen a pa wa ayen wa chim Izirali demma varibasidɔ. ");
INSERT INTO bwu_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jɔɔn ale liŋ jam de niŋ a sak Izirali demma meena ayen ba tagri a basi ba wabaataŋa tomka abe ba tuesi soka ale ge ate Yeezu a yaa jam piilim wa tuimaŋa. ");
INSERT INTO bwu_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jɔɔn ale jam mɔata wa me tuimaŋa tom kpeglimka la, wa yaa bek nuruma ayen, ‘Nama dek a ta a poli ayen mi ka wana? Mi daa nuru waai ate ni a limsi la. Aawo, ni be nya wa bo ka mi ŋaaŋ a cheena. Mi posima kama ale m nin chim yomo waai le wa domsi a kali wa niŋ a yeeri wa nuensaŋa a te wa la.’ ” ");
INSERT INTO bwu_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Pɔɔl yaa ŋman biisi a cheŋ ayen, “M suaata, Abraham ŋaaŋbisa, ale nama baai ale kan daa Izirali demma a chali Naawen la, ka tama meena jigi ale varibasidɔwa tuntomiŋ ka de a jam. ");
INSERT INTO bwu_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Boan nyiŋ, nuru baai ale bo Jerusalem tɛŋka ale ba niŋdeeroma la, a jam ze ayen Yeezu ka varibasidɔwa. Ba be an jam miŋ Naawen biisiteerɔma wieŋa Naawen Gbaŋka po ate ba jam a karim Vuusum Daaŋa meena la a chak ya. Dila nyiŋ la, ba niŋdeeroma yaa bo buusa mini wa ayen ba ko wa. Ba ale nyɛ dila la, ba jam ze ayen ba poom a nyɛ dila a magsi chaab ale ka biisiteerɔma ale poom weeni dii la ate ku chim wensie. ");
INSERT INTO bwu_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ba an jam poom baga a nya wa dii ate wa kaasi a magsi ba ko wa la, alege ba diem jam saalim Gominawa Paalɔt kama ayen wa basi ate wa nuruma ko wa. Wa yaa siak ate ba ko wa. ");
INSERT INTO bwu_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ba ale ga nyɛ wa wieŋa de meena a magsi chaab ale dii ale ŋmarisi Naawen gbaŋka a nueri la, nuruba yaa yeeri wa jabarimu nyiŋ a ta siŋ tɛŋ a ta wa a ga dueni puŋ vorub po. ");
INSERT INTO bwu_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Alege Naawen a nak wa kama a nyini kpilima po a yiri ");
INSERT INTO bwu_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ate wa yaa jam pa wa dek a sak baai ale jam va ale wa a nyini Galili tɛŋka a cheŋ Jerusalem la. Wa jam pa wa dek a sak ba dila ate ku paari ka daa dii choa. Bala abe ale nya nyaŋa de la ale soa ate ba weeni a sak Izirali demma. ");
INSERT INTO bwu_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Tama abe bo dela ayen ka ti sak ni Naawen wamaŋsaŋa ayen Naawen ale puulim dii ale ti kokpieŋsaŋa la, wa a nyɛ kama. Yɔgyɔgla de, tama baai abe ale ka ba ŋaaŋbisa la, wa be nyɛ a te ti kama, boan nyiŋa, wa zak Yeezu a zaani kama, ase ba ale ŋmarisi yi dii ale saa buyewa Yiila Gbaŋka po la ayen, ‘Fi ka m biik, Jinla m sum chim ka fi ko.’ ");
INSERT INTO bwu_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Naawen abe ale weeni dii a magsi chaab ale wa ayen wa le nak wa a yiri kum po ate wa kan puak vorumu po la ale nna ayen, ‘Niak kaai ale welema ate m puulim ale Deevid ate ku a fe ayen ku nyɛ la, m le pa a te fu.’ ");
INSERT INTO bwu_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ase Deevid ale weeni jigi di choa Naawen Gbaŋka po dii ayen, ‘Fi Naawen kan basi ate fi nuru weleŋka a puak vorumu po.’ ” ");
INSERT INTO bwu_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Pɔɔl yaa ŋman biisi a cheŋ a weeni ayen, “Dii po ate Deevid a vua la wa tom tuim ŋaai ate Naawen a yaali la kama ale ge a kpi ate ba gu wa ale wa kokpieŋsaŋa ate wa puak. ");
INSERT INTO bwu_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Alege waai ate Naawen a nak wa a yiri kum po la an puak vorumu po. ");
INSERT INTO bwu_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Ni meena, m suaata, ku a fe kama ayen ni seba a chak ayen wa dii ate mi mooli a sak ni la ale wabaata voŋ teka. Wabaata voŋ teka de abe va ka Yeezu jigi a jam. Ku be a fe kama me ayen ni seba ayen waai ale ta siaka ale wa la, a nyini wa wabaataŋa po a nyini kama, wabaata tii ate Moosis Sinsaŋŋa an jam baga a vari ni ni wabaataŋa po a basi la. ");
INSERT INTO bwu_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Dila nyiŋ la, ni kpesi seba ate Naawen biisiteerɔma ale biisi dii la, a kan nyɛ ni jigiya. ");
INSERT INTO bwu_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ba ale weeni dii la ale nna. ‘Ni wom de, nama baai ale a le Naawen ale biisi dii la, ku le cha ni ate ni cheŋ be a yaa kpi. Boan nyiŋa, mi ale a nyɛ dii jinla la, ka wa dii ate nuru a dan poom tɔgi di kiri a sak ni, ni kan diem a ta siaka la.’ ” ");
INSERT INTO bwu_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pɔɔl ale Banabas ale ga sak nueri a nyini tuka dɔkku po a nyini la, nuruma yaa weeni ba ayen ba ŋman pilim jam ŋaaŋnyiŋ Vuusum Danni a ŋman sak ba wieŋa de gum du. ");
INSERT INTO bwu_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nuruma ale ga basi tuka dɔkku la, Juuma yegayega ale baai ale kan daa Juuba a maa chim Juuma wensiuku vaaroba la, yaa maa chaab a va ka Pɔɔl ale Banabas. Tuimtomdɔma a yaa biisi a deŋsi ba kpa ayen ba kasim boro ale Naawen niaka. ");
INSERT INTO bwu_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Juuma Vuusum Danni ale ŋman jam paari la, waai meena ale bo ba tɛŋka po la, a yaa jam ayen ba wom Nyɔnɔwa wanni. ");
INSERT INTO bwu_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Juuma ale ga nya ale nuruma piisi a soa dii la, ba suniimaŋa yaa deri sueri ale nyuri ate ba yaa a weeni ayen Pɔɔl ale a biisi dii la ka venta. Ba yaa jam a le wa me. ");
INSERT INTO bwu_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Alege Pɔɔl ale Banabas a yaa nyini peelim a biisi ale kan chali yɔgsum a weeni ayen, “Ku a fe kama ayen nama Juuma a liŋ wom Naawen wanni. Alege ni zɛri di kama ale a poli, ayen ku an poom magsi ni nya nyuvuri dii ale kan ta kpeglimka la. Tama abe le basi ni abe ti cheŋ baai ale kan daa Juuba la jigi. ");
INSERT INTO bwu_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Dii nyiŋ la, Nyɔnɔwa ale weeni ti dii la ale nna ayen, ‘M gomsi ni a magsi kama ayen ni sak baai ale kan daa Juuba la wensieŋa ase nuru waai ale ta bolim a jam legi po la. Ayen m ta varibasika a jam nuru meena jigi tɛŋzuk de meena.’ ” ");
INSERT INTO bwu_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Baai ale kan daa Juuba ale wom nna la, ku yaa te ba supeentik ate ba a te Nyɔnɔwa pimpauk wa wamaŋsaŋa nyiŋ. Nuru baai ate Naawen lueri ba ayen ba nya nyuvuri dii ale kan ta kpeglimka la a yaa ta siaka ale Pɔɔl ale Banabas ale sak ba dii la. ");
INSERT INTO bwu_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ate Nyɔnɔwa wanni a yaa tagli tɛŋ kala meena. ");
INSERT INTO bwu_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Alege Juuma a yaa paasi nipɔk baai ale kasim jam a yaali wensiuku vaka wie ate nuruba a te ba zula nna yegayega me la, ale kpaga kpeemaŋa ale a nya tɛŋka zuk la ayen ba basi ate Pɔɔl ale Banabas nya ninam. Ba yaa yiak ba ate ba nyini ba tɛŋka po a nyini. ");
INSERT INTO bwu_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pɔɔl ale Banabas yaa kpaanti ba naŋsaŋa tantaŋa a basi ba tɛŋka po ayen ku sak ayen ba a kaam ba kama. Ba nyɛ dila ale ge a yaa cheŋ Ikoonium tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Supeentik ale Naawen Chiika a yaa jam sueri Yeezu ŋaaŋviirima nalimnyiini Antiok tɛŋka po. ");
INSERT INTO bwu_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pɔɔl ale Banabas ale jam paari Ikoonium tɛŋka la, ba yaa ŋman jo Juuma tuka diinaŋa po a biisi nalimnyiini ate nuruba yegayega, Juuma ale baai ale kan daa Juuba la yaa jam ta siaka ale ba sinsaŋŋa. ");
INSERT INTO bwu_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Alege Juuma baai ale jam a zɛri ayen ba kan ta siaka ale Yeezu la a yaa jam a choa baai ale kan daa Juuba la, noa a weeni ayen Kirisita bisaŋa daa nuru maŋsa. ");
INSERT INTO bwu_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tuimtomdɔma a jam goa dula beni ka nalimnyiini a yaa nyini peelim a sak Nyɔnɔwa wie kan chali yɔgsum. Nyɔnɔwa abe jam te ba ka pagrim ate ba baga a nyɛ wakperikaliisa ayen ku sak ayen ba sinsaŋŋa a magsi chaab ale ka wa ale a yaali ba wa niaka nyiŋ dii la. ");
INSERT INTO bwu_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Tɛŋka po demma a yaa jam poori ka chaab buye, ba bunyi a va Juuma, ba bunyi me a va tuimtomdɔma. ");
INSERT INTO bwu_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Juuma ale baai ale kan daa Juuba la ba gela ale ba kpaŋŋa a yaa maa chaab a nyɛ noai yeŋ ayen ba nyɛ ate tuimtomdɔma nam abe ba yuk ba ale tintana a ko. ");
INSERT INTO bwu_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Tuimtomdɔma ale ga wom la, ba yaa chali cheŋ Lisitira ale Daabe ale tɛŋ fi sii meena ale bo si po la. Lisitira ale Daabe abe jam bo ka Likaaniya tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Jigi ŋala meena ate ba chali cheŋ la, ba jam sak Naawen wamaŋsaŋa kama. ");
INSERT INTO bwu_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Nuru ale jam bo Lisitira tɛŋka po a chim gbaruk a nyini wa biam po. Ba ale biak wa wa an ma cheŋ nyaya. ");
INSERT INTO bwu_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Wa yaa jam kala a wom Pɔɔl ale a biisi dii la. Pɔɔl a yaa nya wa nna zii, a yaa miŋ ayen nuruwa ta siaka kama a magsi wa nya nyiŋyɔgsa. ");
INSERT INTO bwu_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Pɔɔl yaa weeni wa ate ku jueli ayen, “Yiri zaani fi naŋsaŋa zuk.” Nuruwa yaa yok jueli wein a jam zi a yaa deri cheŋ a gilim. ");
INSERT INTO bwu_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nuru bɔanni ale nya dii ate Pɔɔl nyɛ la, ba yaa deri a na ate ku a jueli wein a weeni ale Likaaniya biika ayen, “Yɔgyɔgla de, boglutaŋa a yaa labri chim ka nuruba a siŋ jam tama jigi.” ");
INSERT INTO bwu_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ba yaa te Banabas yonni magsi chaab ale ba bogluku ayen Zeeyus. Ba jam te Pɔɔl me yue magsi chaab ale ba bogluk kpieŋku ayen Yemas dii la wa jam ale biisirowa. ");
INSERT INTO bwu_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Waai ale a kaab Zeeyus la a yaa ta lalisa ale tiisa puuta a ta jam kaabka yenni dɔkku nɔanni ayen wa ale nuru bɔanni a nyɛ kaabka a te tuimtomdɔma, kaabka yenni de a za ka juijui ale kan bo tɛŋka po la. ");
INSERT INTO bwu_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pɔɔl ale Banabas ale wom ba ale a yaali ayen ba nyɛ dii la, ba yaa yik ba gattaŋa a cheeri ayen ku sak ba ayen ba ale nyɛ dii la ka wabiok. Ba noa bayewa yaa a chali jo nuru bɔanni sunsuŋ a deri piilim a na ate ku a jueli a weeni ayen, ");
INSERT INTO bwu_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Nidɔaba, ka boa ate ni a nyɛ dila? Tama dek ka nurubisa ase nama me la. Tama bo dela kama ayen ti mooli Naawen wamaŋsaŋa a sak ni ate ni tagri a basi ŋankayaataŋa de chaab abe ni va Naawen dii ale vua a nyɛ wenzuk ale tɛŋ ale nyaataŋa ale ŋanta baai meena ale bo ba po la. ");
INSERT INTO bwu_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Dila po dila powa, Naawen jam basi kama ate waai meena a va ba dek ale a yaali siuk kuui la. ");
INSERT INTO bwu_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Alege wa va ka wie nna yegayega nyiŋ a nyɛ ayen ku sak nuruba ayen wa vua kama. Wieŋa de ale wa a te ni nyiam ate bu nyini wenzuk a jam diipo ale magsi la, wa a basi ate ni ŋanborintaŋa a nyɛ a niak diipo meena ale magsi la, wa a te ni ŋandiinta ate ni de a chak, ale a basi ate ni suniimaŋa a sueri ale supeentik.” ");
INSERT INTO bwu_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Tuimtomdɔma ale jam poom a biisi wieŋa de meena la, ba jam nam ka nna yegayega ate nuruma a basi kaab kaai ate ba jam ayen ba kaab a te ba la. ");
INSERT INTO bwu_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Juuma ba gela ale jam nyini Antiok ate ka bo Pisidiya ale Ikoonium tɛŋsaŋa la a jam. Bala ale jam nyɛ ate nuru bɔanni a va ba Juuma ale a yaali dii la. Ba yaa yik Pɔɔl a pa tintana a yuk wa a vuuri a ta nyini tɛŋka po a nyini. Ba ale jam nyɛ wa dila la ba jam a poli ayen wa kpi kama. ");
INSERT INTO bwu_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Alege Yeezu ŋaaŋviirima ale jam gilim wa. Dila ŋaaŋnyiŋ ate wa yaa yiri a ŋman ga jo tɛŋka po. Vari ale veenti la, wa ale Banabas a yaa cheŋ Daabe tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Dula jigini, Pɔɔl ale Banabas a jam sak Naawen wamaŋsaŋa a nya ŋaaŋviiriba ka nna yegayega. Ba yaa pilim ŋmani Lisitira ale Ikoonium, a zaani dula a cheŋ Antiok ate ka bo Pisidiya po la. ");
INSERT INTO bwu_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Jigaŋa de meena, ba kasim jam a deŋsi ka ŋaaŋviirima kpa, a weeni ba ayen ba kasim ta siaka ale Yeezu. Ba jam maa sak ba ayen, “Ku a fe kama ayen ti nya ninam yegayega abe ti ge jo Naawen Naamu po.” ");
INSERT INTO bwu_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pɔɔl ale Banabas ale Kirisita bisaŋa ale a tu chaab la a yaa maa chaab a bobi noa a puusi Naawen a yaa lueri kpaga a ta nyini Kirisita bisaŋa ale a tu chaab tɔga tɔga la po. Pɔɔl ale Banabas a yaa pa ba nyo Nyɔnɔwa waai ate ba ta siaka ale wa nalimnyiini la nisima po. ");
INSERT INTO bwu_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ba yaa jam va Pisidiya tɛŋka po a taam cheŋ Pamfiliya tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Dula jigini ba jam sak Naawen wamaŋsaŋa Periga me po ale ge a cheŋ Ataliya tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ba yaa zaani dula a jueli ŋaaruŋ a pilim ŋman Antiok juijui ate Kirisita bisaŋa ale a tu chaab la a liŋ pa ba a nyo Naawen nisima po ayen wa maari ba ate ba baga tom wa tuimaŋa ŋaai ate ba yaa tom nueri nna la. ");
INSERT INTO bwu_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ba ale jam paari Antiok la, ba yaa tigsi Kirisita bisaŋa ale a tu chaab la meena a nyo jigi yeŋ a weeni sak Naawen ale pa ba a tom dii meena la. Ba weeni a sak ba wa ale lagi siuk ate baai ale kan daa Juuba la a maa ta siaka. ");
INSERT INTO bwu_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pɔɔl ale Banabas a jam goa dula jigini kama ale ŋaaŋviirima meena ate ku beni nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Nuruba ale jam nyini Judia a jam Antiok tɛŋka a deri piilim a sak baai ale ta siaka ale Yeezu la sinsaga ayen, “Nuru karo a baga nya varibasika ase ka kula nyɔnɔwa a nin gebi wa yoanni ase Moosis Sinsaŋŋa ale a sak dii la.” ");
INSERT INTO bwu_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Dila nyiŋ la Pɔɔl ale Banabas a yaa jam ta nampaga nna yegayega ale ba. Baai ale ta siaka la a yaa lueri Pɔɔl ale Banabas ale baai ale ta siaka la gela a bo Antiok la ayen ba cheŋ Jerusalem a ga nya tuimtomdɔma ale kpaŋŋa wanni de zuk. ");
INSERT INTO bwu_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kirisita bisaŋa ale a tu chaab la a yaa basi ba siuku po ayen ba cheŋ. Ba ale jam va Fonisia ale Samaria tɛŋsaŋa po a cheŋ la, ba yaa va ba Kirisita be chaama ale bo dula la jigi, a yaa weeni sak ba ayen nuru baai ale kan daa Juuba la a tagri va Naawen. Wa paaliŋa de ate ba weeni a sak ba la yaa ta masim ale supeentik a jam ba meena jigi. ");
INSERT INTO bwu_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ba ale jam paari Jerusalem la, Kirisita bisaŋa ale a tu chaab la ale ba kpaŋŋa ale tuimtomdɔma a jam maa chaab a nyɛ ba tia kama ate ba weeni a sak ba meena Naawen ale pa ba a tom tuima dii la. ");
INSERT INTO bwu_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ba ale ga weeni nna a nueri la, baai ale ta siaka la gela baai ale ka Farisiima po nuruba la, a yaa yiri zaani ŋmai a weeni ayen, “Ku a fe kama ayen baai ale kan daa Juuba la a gebi ba yuaŋa. Ku a fe kama me ayen, ba kaam ba ayen ba a zuli Moosis Sinsaŋŋa ale a weeni dii la.” ");
INSERT INTO bwu_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tuimtomdɔma ale kpaŋŋa a yaa tu chaab ayen ba biisi wanni de. ");
INSERT INTO bwu_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ba ale nak nampaga di nyiŋ ate ku beni la, Piita yaa zaani a biisi ayen, “M suaata, nama dek seba ayen a ta nyini dila po dila po, Naawen ale jam lueri mi a ta nyini nama po a nyini ayen m ga sak baai ale kan daa Juuba la, Naawen wamaŋsaŋa ate ba wom abe ba ta siaka ale ŋa. ");
INSERT INTO bwu_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Naawen waai abe ale seba nurubiik meena popola ale ka dii la, a te Naawen Chiika baai ale kan daa Juuba la kama ase wa ale te tama me dii la ayen ku sak ayen wa ta yaalika ale ba kama ase wa ale ta yaalika ale tama me dii la. ");
INSERT INTO bwu_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Naawen nyɛ ba jigi kama ase wa ale a nyɛ, tama jigi dii me la. Siuk kula po, wa va ka ba siaka ale wa a yaa sugri ba wabaataŋa ba suniima po a basi. ");
INSERT INTO bwu_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Yɔgyɔgla de, ka boa ale soa ate nama a yaali ayen ni pa jib kpeemu de buui ate ti kokpieŋsaŋa a yaase tama dek an baga ji bu la ayen ŋaaŋviirima ji? Ni dan a nyɛ nna, ni a nyɛ ka Naawen a nya. ");
INSERT INTO bwu_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Alege tama seba a chak kama ayen tama ale va ti Nyɔnɔwa Yeezu niaka nyiŋ a nya varibasika ase bala me a le nya dii la.” ");
INSERT INTO bwu_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ba meena tuka po a kasim jam goori ka nna chorototo, ale a wom Pɔɔl ale Banabas ale jam a weeni Naawen ale pa ba a tom wakperikaliisa ale baai ale kan daa Juuba po dii la. ");
INSERT INTO bwu_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pɔɔl ale Banabas ale ga biisi nueri la, Jeemsi yaa tulisi ayen, “M suaata, ni meena lagi tue a wom mi. ");
INSERT INTO bwu_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ni wom Simon Piita ale tɔgi Naawen ale liŋ nyɛ dii a sak baai ale kan daa Juuba la a yaa piilim lueri ba po ba gela a soa ba la. ");
INSERT INTO bwu_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ase Naawen biisiteerɔma ale ŋmarisi Naawen Gbaŋka po a weeni a magsi chaab ale nyaku de la. Ba ŋmarisi weeni ayen Nyɔnɔwa a weeni: ");
INSERT INTO bwu_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Nyaku de ŋaaŋnyiŋ, m le pilim jam a nyɛ ate Deevid yenni ale lo la a ŋman zaani. M le ŋman pilim se di juijui ale lo la, abe m nyɛ ate di ŋman pagra. ");
INSERT INTO bwu_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ate nurubiik meena a jam mi jigi. Baai meena ale kan daa Juuba ate mi wi ba ayen m nuruba la, bala meena ale jam mi jigi. ");
INSERT INTO bwu_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nyɔnɔwa ale weeni nyaŋa de meena a ta nyini dila po dila po.’ ” ");
INSERT INTO bwu_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jeemsi yaa ŋman biisi a cheŋ a weeni ayen, “Dila nyiŋ mi a poli kama ayen ti kan a daani baai ale kan daa Juuba a yaa tagri a va Naawen la. ");
INSERT INTO bwu_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ku magsi ka ti ŋmarisi gbaŋ a te ba a weeni ba ayen, ba kan a de bogluta ŋandiinta dii nyiŋ la, ŋandiin tila an welema. Ti weeni ba me ayen ba kan bobi nipɔk baai ale kan daa ba pooba la a goa, abe ba kan a ŋobi jaab buui ate ba an togri la lammɔa abe ba kan a de ziim. ");
INSERT INTO bwu_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Baai ale kan daa Juuba la, le deri siak nyaŋa de kama, boan nyiŋŋa ba seba kama ayen Juuma baai ale bo juijui meena ale ba la, ba sak Moosis Sinsaŋŋa de kama ate ku beni yegayega. Ba be wom ale karim ŋa kama ba tuka diinaŋa po ba Vuusum Daaŋa meena po.” ");
INSERT INTO bwu_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tuimtomdɔma ale kpaŋŋa ale Kirisita bisaŋa ale a tu chaab la a yaa maa chaab a poli ayen ku nala kama ate ba lueri nuruba a ta nyini ba po a tom ba ale Pɔɔl ale Banabas ate ba cheŋ Antiok. Ba yaa lueri nuruba baye baai ale ta siaka la a te ba zula nalimnyiini la. Nuruba bayewa ale Judas (waai me ate ba a wi wa ayen Baasabas la) ale Silas. Ba yaa tom ba ayen ba ta gbaŋka a cheŋ. ");
INSERT INTO bwu_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ba ale jam ŋmarisi gbaŋka a weeni dii la ale nna ayen, “Tama ni suaataŋa tuimtomdɔma ale kpaŋŋa a maa chaab a puusi ti suaataŋa baai ale potim kan daa Juuba a nyini biam po ate ba bo Antiok ale Siriya ale Silisiya tɛŋsaŋa la. ");
INSERT INTO bwu_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Tama wom ayen nuruba gela ale nyini tama po a jam biisi wie ate ŋa daani ni ale nyɛ ate ni popola kaasi. Ti a weeni a sak ni kama ayen ni nya nuru bala an tuesi sinsaŋŋa tama jigi ayen ba jam biisi dila. ");
INSERT INTO bwu_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Dila nyiŋ ate tama meena a nyɛ tuka a yaa poli ate ti yaa siak a lueri nuru ba gela ayen ba va Pɔɔl ale Banabas ti sua tii ate ti mariŋ la a jam ni jigi. ");
INSERT INTO bwu_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Pɔɔl ale Banabas ka nuru baai ale pa ba nyuvoa a da ti Nyɔnɔwa Yeezu Kirisita nyiŋ la. ");
INSERT INTO bwu_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Dila nyiŋ ate ti yaa tom Judas ale Silas ni jigi. Ba ale poom weeni a sak ni dii meena wuu ate ti ŋmarisi gbaŋka de po la. ");
INSERT INTO bwu_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","“Naawen Chiika ale tama a maa chaab a siak kama ayen ti kan pa jib bu choa a ji ni. Ti ta ka wieŋa de nyiini ayen ti weeni a sak ni. Ku a fe kama ayen ni va ŋa. ");
INSERT INTO bwu_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Wieŋa de ale, Ni kan a de bogluta ŋandiinta, ni kan a de ziim, ni kan a ŋobi jaab buui ate ba an togri la lammɔa, ni kan a bobi nipɔk baai ale kan daa ni pooba la a goa. Ku a le nala kama ase ni a le kan a nyɛ wieŋa de. “Ni boro nalimnyiini.” ");
INSERT INTO bwu_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ba ale ŋmarisi gbaŋka nna a ga nueri la, ba yaa tom Pɔɔl ale Banabas ale ba vaanchaama ayen ba ta ka cheŋ Antiok. Ba ale ga paari la, ba yaa tigsi baai ale ta siaka la ate ba jam jigi yeŋ a yaa te ba gbaŋka. ");
INSERT INTO bwu_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ba ale ga karim ka a nueri la, gbaŋka wieŋa a yaa ta supeentik a jam ba jigi. ");
INSERT INTO bwu_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas ale Silas dek abe jam ka Naawen biisiteerɔba. Ba yaa bo ale ba a deŋsi ba kpa ayen ba nya pagrim. ");
INSERT INTO bwu_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ba ale ga daliŋ maga dega la, Antiok demma yaa te Judas ale Silas siuk ale suyɔgini ate ba pilim cheŋ baai ale tom ba la jigi. ");
INSERT INTO bwu_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Alege Silas jam nya kama ayen ku nala kama ate wa wari dula. ");
INSERT INTO bwu_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Alege Pɔɔl ale Banabas a jam wari ka Antiok a gum chaab ale nuruba chaab ate ba maa chaab a yaa sak nuruma Nyɔnɔwa wanni. ");
INSERT INTO bwu_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ku ale ga beni maga dega la, Pɔɔl a yaa weeni Banabas ayen, “Basi ate ti pilim ŋmani cheŋ jigi ŋaai meena ate ti sak Nyɔnɔwa wanni la a ga nya ase Kirisita bisaŋa a nyɛ ka se.” ");
INSERT INTO bwu_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabas a jam a yaali kama ayen Jɔɔn Maak a maa va ba a cheŋ. ");
INSERT INTO bwu_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Alege Pɔɔl an jam poli ayen ku magsi ayen Jɔɔn Maak a maa va cheŋ dii nyiŋ la wa an jam maa boro ale ba ate ku ga paari ba tuini kpeglimka. Wa jam zaani ka Pamfiliya tɛŋka a basi ba. ");
INSERT INTO bwu_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Nampaga a yaa deri jam ba sunsuŋ ate ba poori chaab tɔgatɔga. Banabas a yaa yik Maak ate ba jueli ŋaaruŋ a cheŋ Saipurus tɛŋka ");
INSERT INTO bwu_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ale ge ate Pɔɔl me a lueri Silas ate baai ale ta siaka a yaa pa ba nyo Naawen nisima po ayen wa nya ba zuk ale wa niaka, ");
INSERT INTO bwu_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ate ba cheŋ Siriya ale Silisiya tɛŋsaŋa a ga a deŋsi Kirisita bisaŋa ale a tu chaab la kpa dula a te ba pagrim. ");
INSERT INTO bwu_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pɔɔl yaa nyini Siriya ale Silisiya tɛŋsaŋa a cheŋ Daabe ale Lisitira. Kirisita bisaŋa wanyi ale jam bo Lisitira. Wa yoi jam ale Timoti. Wa mawa jam ka Juu a ta siaka ale Nyɔnɔwa. Alege Timoti kowa jam ka Giriki deno. ");
INSERT INTO bwu_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Kirisita bisaŋa meena ale jam bo Lisitira ale Ikoonium la, a kasim jam a pak Timoti kama. ");
INSERT INTO bwu_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pɔɔl a yaa jam a yaali ayen wa maa va a cheŋ. Pɔɔl yaa gebi wa yoanni dii nyiŋ la, Juuma meena ale jam bo dula jigini meena la, a jam seba ayen Timoti kowa ka Giriki deno. ");
INSERT INTO bwu_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ba ale jam va tɛŋsaŋa po a taam la, ba jam weeni sinsaŋŋa meena ŋaai ate tuimtomdɔma ale kpaŋŋa meena Jerusalem tɛŋka a sak baai ale ta siaka la kama. Ba weeni ba me ayen ba chiib a va sinsaŋŋa. ");
INSERT INTO bwu_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kirisita bisaŋa ale a tu chaab la siaka a yaa ŋmasi pagra a gum du ate ba jam a piisi daa meena a gum du. ");
INSERT INTO bwu_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ba yaa jam cheŋ a va Firijiya ale Galatia tɛŋsaŋa dii nyiŋ la, Naawen Chiika an jam te ba siuk ate ba sak Naawen wamaŋsaŋa Asia tɛŋka po. ");
INSERT INTO bwu_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ba ale jam paari Misiya tɛŋbanni la, ba jam poli kama ayen ba cheŋ Bitiniya tɛŋka alege Yeezu jam tom ka Naawen Chiika ayen wa weeni ba ayen ba kan cheŋ. ");
INSERT INTO bwu_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ba yaa va Misiya tɛŋka a taam siŋ Torowas tɛŋka. ");
INSERT INTO bwu_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ku yaa nyɛ Pɔɔl jigi yokku ase wa goa daasim kama la ate wa nya Masidoniya deno a za wa tɛŋ a saalim wa a weeni ayen, “Taam jam Masidoniya dela a maa maari ti.” ");
INSERT INTO bwu_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Wa ale ga nya nna la ase goadaasima la, ti yaa yiri a gomsi ayen ti cheŋ Masidoniya a poli weeni ti dek ayen Naawen weeni ti ayen ti cheŋ ka dula a ga sak ba wa wamaŋsaŋa. ");
INSERT INTO bwu_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ti yaa jueli ŋaaruŋ a zaani Torowas a gaam taam cheŋ Samotiras. Vari ale veenti la, ti yaa ŋman cheŋ Niyapolis. ");
INSERT INTO bwu_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ti yaa zaani dula a basi ŋaaruŋku ale ge cheŋ Filipai, ka Masidoniya tɛŋsaŋa po tɛŋ kpieŋ la. Aroom demma ale ba kpaga ale jam bo tɛŋka de po a nya ba zuk. Ti jam bo tɛŋ kala ate ku beni magla. ");
INSERT INTO bwu_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Juuma Vuusum Danni ate ti yaa basi tɛŋka po alege cheŋ siŋ benni noai juijui ate ti jam a poli ayen ti le nya jigi ale Juuma a tigsi chaab a boro a nyɛ Naawen puusa la. Ti yaa jam kala a biisi ale nipɔk baai ale jam tigsi chaab a kala dula la. ");
INSERT INTO bwu_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ti ale jam boro a biisi la, nipɔk wanyi ate ba a wi wa ayen Liidiya ale jam a wom dii ate ti jam a biisi la. Wa jam nyini ka Tayatira. Wa jam ta ka garuk sobta a gerim. Wa jam ka waai ale a te Naawen zula nna yegayega la. Dila nyiŋ la, Nyɔnɔwa yaa lagri wa popolaŋa ate wa a wom Pɔɔl ale jam a weeni dii la. ");
INSERT INTO bwu_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Wa ale wa dɔkdemma ale ga tuesi soka a nueri la, wa yaa wi tama a weeni ayen, “Nama a dan sum siak kama ayen mi ta siaka ale Nyɔnɔwa, ni be jam mi yenni a goa.” Wa jam weeni dila ate ku yik tama kama ate ti va wa a cheŋ. ");
INSERT INTO bwu_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Da yeŋ ate ti jam a cheŋ juijui ate Juuma a tigsi chaab a puusi Naawen la, ate nipɔkbili wanyi, wa jam ka yomo a yaa tu ti siuku niŋ. Chichiribaata ale jam ta wa ate wa baga a weeni chum dii po wie. Baai ale jam soa nipɔkbili yomowa de la, ba basi kama ate wa yaa a porisi a nya ligra nna yegayega a te ba. ");
INSERT INTO bwu_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Wa yaa jam kaari a wi Pɔɔl ale tama a weeni ayen, “Nuruma de ka Naawen kpeeni tomteerɔba. Ba a mooli a sak ni ka ni ale ni nyɛ dii ate ni nya varibasika la.” ");
INSERT INTO bwu_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Wa jam nyɛ nnala ate ku paari ka daa dii choa ate ku yaa puuri Pɔɔl sui nna yegayega ate dai dila danni Pɔɔl yaa virim a weeni chichiribioku ale bo wa zukku po la ayen, “Yeezu Kirisita yonni nyiŋ ate mi a weeni fu ayen fi nyini wa zuk po a nyini.” Chichiribioku a yaa deri basi wa dula jigini nna nwuli. ");
INSERT INTO bwu_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nipɔkbilika nyamma ale ga miŋ ale ba an ŋman baga a nya ligra la, ba yaa yik Pɔɔl ale Silas a vuuri ba a ta ba cheŋ kpaŋŋa jigi yaba peelimu po. ");
INSERT INTO bwu_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ba yaa ta ba jam Aroom tɛŋka kpaŋŋa jigi a weeni ba ayen, “Nuruma de ka Juuba. Ba be a daani ka ti tɛŋka demma. ");
INSERT INTO bwu_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ba a sak ka sinsak ŋaai ale kan a va tama Aroom demma sinsaŋŋa la. Ku be a fe kama ayen ti kan nyɛ dii ate ba a weeni ti la.” ");
INSERT INTO bwu_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nuru bɔanni a yaa maa gum ba po a yaa tu chaab ale Pɔɔl ale Silas. Ate kpaŋŋa a yaa yik Pɔɔl ale Silas gattaŋa a dari cheeri ale weeni ayen ba miiri ba. ");
INSERT INTO bwu_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ba ale miiri ba nna yegayega la, ba yaa ta ba a ga lik ale ge weeni likka dɔkku limsidɔwa ayen wa ŋmasi lik ba nalimnyiini. ");
INSERT INTO bwu_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Limsidɔwa ale ga wom nna la, wa yaa ta ba taam niŋniŋ dɔkku a lik a yaa pa duok kpioŋ ate ba keri vie, ku dobra nna yegayega a pa ba naŋsaŋa a su du. ");
INSERT INTO bwu_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Alege goota po sunsuŋ ale ga paari la, Pɔɔl ale Silas a yaa jam boro a puusi Naawen ale a yi yiila a pak Naawen. Baai ate ba jam maa yik ba a lik la, a yaa jam a wom Pɔɔl ale Silas ale a nyɛ dii la. ");
INSERT INTO bwu_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tɛŋka a yaa deri choa nna yegayega ate likka yenni me a choa ate ku an bola beniya ate diinaŋa noaŋa a deri lagri, ate choroma ŋaai ate ba pa bobi ligrima la a yaa deri gebi me. ");
INSERT INTO bwu_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Likka yenni limsidɔwa a yaa yiri ga a nya ale likka yenni noaŋa a lagriya. Wa yaa yeeri gebi woŋ ayen wa ko wa dek dii nyiŋ la, wa jam a poli kama ayen nuruma a nyini chali be kama. ");
INSERT INTO bwu_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Wa ale jam boro a ayen wa nyɛ dila la, Pɔɔl yaa nya a kaari ate ku jueli nna yegayega a weeni wa ayen, “Kan te fi dek tuem, ti meena bo ka dela.” ");
INSERT INTO bwu_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Limsidɔwa yaa wi ayen ba ta bolim a jam a yaa chali jo yenni po ate yɔgsum yik wa ate wa nyiŋka yaa a gok nna pampam ate wa yaa lo Pɔɔl ale Silas niŋ ");
INSERT INTO bwu_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","a yaa ta Pɔɔl ale Silas a nyini peelim ate wa yaa weeni ba ayen, “M koba, ku a fe ayen m nyɛ ka se ate m nya varibasika?” ");
INSERT INTO bwu_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ba yaa tulisi wa ayen, “Ta siaka ale Nyɔnɔ Yeezu, ale fi le nya varibasika, fi ale fi dɔkdemma meena.” ");
INSERT INTO bwu_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ba yaa sak wa ale baai meena ale bo wa yenni po la Nyɔnɔwa wanni. ");
INSERT INTO bwu_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Dila powa degadega yok kula ate nuruwa a yaa yik ba a sugri ba niraŋa ate ba deri te wa ale wa dɔkdemma soka. ");
INSERT INTO bwu_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Wa yaa ta ba jo wa dɔkku a nyɛ ŋandiinta a te ba. Wa dɔkdemma meena sue a yaa jam peenti nna yegayega dii nyiŋ la, ba ta siaka ale Naawen kama. ");
INSERT INTO bwu_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Vari ale ga veenti la, Aroom tɛŋka kpaŋŋa a yaa tom limsidɔba ale tuntomiŋ ka de ayen, “Ni basi ate nuru bala cheŋ.” ");
INSERT INTO bwu_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Limsidɔwa yaa weeni Pɔɔl ayen, “Aroom tɛŋka kpaŋŋa a tom weeni kama ayen m lagi fi ale Silas a basi. Dila nyiŋ yɔgyɔgla de, ni nyini cheŋ ale suyɔgini.” ");
INSERT INTO bwu_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Alege Pɔɔl yaa tulisi ba ayen, “Ba an nya ale ti kaasi wari ya, alege ba nak ti ate waai meena a nya. Tama ka Aroom dem. Ba nak ti a yaa ta ti ga yuk basi likka dɔkku po. Alege yɔgyɔgla de, ate ba yaa a yaali ayen ba basi ti ate nuru kan seba ku noai po? Aawo, dila kan tom! Ku a fe kama ate Aroom kpaŋŋa dek a jam dela jigini a lagi ti a basi.” ");
INSERT INTO bwu_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Limsidɔma a yaa ga weeni ate Aroom tɛŋka kpaŋŋa wom. Ba ale ga wom ayen Pɔɔl ale Silas ka Aroom demma la, yɔgsum yaa yik ba ");
INSERT INTO bwu_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ate ba cheŋ a ga weeni ba ayen ba kaasi ale ge yaa lagi ba ate ba nyini a yaa saalim ba ayen ba basi tɛŋka po. ");
INSERT INTO bwu_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pɔɔl ale Silas a yaa basi likka dɔkku ale ge cheŋ Liidiya yenni. Dula jigini, ba yaa tu chaab ale Kirisita bisinsila a yaa biisi wie a deŋsi ba kpa ale ge yaa basi ba ale cheŋ. ");
INSERT INTO bwu_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pɔɔl ale Silas a yaa ŋman va Amfipolise ale Apoloniya tɛŋsaŋa a taam cheŋ Tesalonika tɛŋka. Juuma tuka yeri dinyi ale jam za Tesalonika po. ");
INSERT INTO bwu_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ase Pɔɔl nyiem ale a nyɛ dii la, wa yaa cheŋ ga jo tuka yenni po. Wa jam bo ka dula ate ku paari Juuma Vuusum Danni ku noa buta a jo ba tuka yenni po a pa Naawen Gbaŋka a biisi a daliŋ ale ba a ");
INSERT INTO bwu_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","tɔgi Gbaŋka wieŋa kie a sak ba ayen ku sak ba ayen ku jam a fe kama ayen Kirisitawa waai ate Naawen a weeni ayen wa le tom ate wa jam la a nam ate ba yik wa a ko ale ge ate wa ŋman yiri kum po. Pɔɔl yaa weeni ayen, “Kirisitawa de ate Naawen puulim ayen wa le tom ate wa jam la, ale Yeezu. Be ka wala wie ate mi ta jam ayen m biisi a sak ni.” ");
INSERT INTO bwu_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Juuma ale wom nna la ba gela a yaa sum siak ayen Pɔɔl ale a biisi dii la ka wensie a yaa pa ba dek a gum chaab ale Pɔɔl ale Silas. Giriki demma me yegayega baai ale a chali Naawen la, ale nipooba ba gela baai ale chim nuru kpeenta la bala meena jam siak kama a maa va Pɔɔl ale Silas. ");
INSERT INTO bwu_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Alege Juuma a yaa jam a de nyuri ale Pɔɔl ale Silas. Juuma yaa yik tɛŋka po nuru baai ale kan a yaali tuima ale a yaali kpaliŋsa a bo tɛŋka po siuk kpeentaŋa niŋsa a nyiem a cheŋ la a nyo jigi yeŋ ate ba yaa maa chaab a nyɛ ate supuurim a jam waai meena jigi tɛŋka po ate ba a nuemu nna yegayega. Nuruma yaa nyɛ dila a chali cheŋ nuru wanyi ate ba a wi ayen Jeesin la yeri po. Ba jam a poli ayen ba a gisi ka Pɔɔl ale Silas dila ate ba dan nya ba abe ba yik ba a ta nyini peelim a te nuruma. ");
INSERT INTO bwu_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Alege ba ale jam nyɛ dila ale ge ba an nya ba la, ba yaa yik Jeesin dek ale Kirisita bisaŋa gela a vuuri a ta ba jam tɛŋka kpaŋŋa jigi a yaa a nuemu ate ku a jueli a weeni ayen, “Nuruma de a ta ka daanika a jam jigi meena. Yɔgyɔgla de, ba ale nna a jam tama tɛŋka po ");
INSERT INTO bwu_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ate Jeesin a yaa basi ate ba bo wa yenni po. Ba meena a kaasi ka Aroom tɛŋka nakpioŋku Siiza sinsaŋŋa. Ba a weeni kama ayen nakpioŋku choa ale boro. Wa yoi ale Yeezu.” ");
INSERT INTO bwu_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Tɛŋka po kpaŋŋa ale nuruma ale wom nna la, ku yaa ta popola tɔgatɔga nna yegayega a jam ba jigi. ");
INSERT INTO bwu_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Kpaŋŋa yaa basi ate Jeesin ale mbala a tuni ligi ŋaai ale magsi ba tuni la, abe ba basi ba ate ba yaa cheŋ. ");
INSERT INTO bwu_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tɛŋ ale jam sobri la, Kirisita bisaŋa a yaa basi ate Pɔɔl ale Silas a cheŋ Beria tɛŋka. Ba ale jam paari dula la, ba yaa ga jo Juuma Tuka Yenni po. ");
INSERT INTO bwu_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Tɛŋka la demma a jam a zunchoŋ Tesalonika demma de ale Naawen wamaŋsaŋa womka kama. Ba kasim jam lagi ba tue meena nalimnyiini kama a wom wamaŋsaŋa. Daa meena ba a karim ale a zamsi Naawen gbaŋka wieŋa kama ayen ba nya ase Pɔɔl ale a biisi dii la ka wensie ya. ");
INSERT INTO bwu_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Juuma yegayega a jam ta siaka kama ale wamaŋsaŋa. Girik tɛŋka nipooma yegayega baai ale chim nuru kpeenta la ale Giriki demma nidɔama a jam maa ta siaka kama. ");
INSERT INTO bwu_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Alege Juuma baai ale jam bo Tesalonika ale wom ayen Pɔɔl sak Naawen wanni Beria tɛŋka me po la, ba yaa ŋman jam dula me a yik nuruba a nyo jigi yeŋ a paasi ba ayen ba ta daanika a jamu. ");
INSERT INTO bwu_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kuna bula beniya ale ge ate Beria demma Kirisita bisaŋa a basi ate Pɔɔl a cheŋ nya kpeema kuŋkɔŋini, alege Silas ale Timoti a yaa wari Beria. ");
INSERT INTO bwu_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Nuru baai ale jam ta Pɔɔl a cheŋ ayen ba basi la, a jam ta wa a cheŋ paari ka Atens ale ge pilim ŋmani Beria. Pɔɔl jam te ba ka tuntomiŋ ayen ba weeni Silas ale Timoti ayen ba dan nya siuk yɔgyɔgla de ba jam wa jigi. ");
INSERT INTO bwu_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pɔɔl ale jam bo Atens tɛŋka a limsi Timoti ale Silas la, wa yaa jam nya ale bogluta a kasim jam sueri tɛŋka de po meena. Nyaku de a yaa jam te wa supuurim nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Daa meena wa kasim jam a daliŋ kama ale Juuma ale baai ale kan daa Juuba ale a chali Naawen la ba tuka yenni po. Daa meena me wa jam maara a daliŋ kama ale nuru baai meena ale bo yaba peelitaŋa po la. ");
INSERT INTO bwu_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Sagrɔba ale jam boro. Ba jam ka tɔgatɔga buye. Ba bunyi wa yoi a jam ale Ɛpikuriyos demma. Bunyiwa me yoi a jam ale Sitooyik demma. Ɛpikuriyos demma ale Sitooyikma sagrɔma me a jam maa nak nampaga kama ale Pɔɔl. Ba gela a jam bek wa ayen, “Nuruwa de a ti an za a nak ka boan jaab guŋgoŋ dila?” Ba gela me weeni ayen, “Ku a nyɛ ase wa a biisi ka tɛŋsa si chaab bogluta wie la.” Ba weeni dila kama dii nyiŋ la, Pɔɔl a yaa biisi a magsi chaab ale ka Yeezu ale kpi ale ŋman yiri kum po dii la. ");
INSERT INTO bwu_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Dila nyiŋ la, ba yaa weeni Pɔɔl ayen wa jam sagrɔma kpaŋŋa tuka jigini ate ba a wi ayen Ariyapagus la a jam siak wiik. Wa yaa siak a jam ate ba yaa bek wa ayen, “Pɔɔl, tama a yaali kama ayen fi weeni a sak ti sinsak paali ŋaai ate fi a sak la kiri. ");
INSERT INTO bwu_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ti ale wom ale wie ŋaai ate fi a weeni la gela ka wachansa ti tue po la ate ti a yaali ayen fi weeni ŋa kiri a sak ti.” ");
INSERT INTO bwu_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ba jam bek Pɔɔl nna kama dii nyiŋ la Atens demma ale nicham baai ale maa bo tɛŋka po dula la a nyiem kasim a yaali ayen ka ba a weeni chaab abe ba a wom me wa paala ale popola paala wie. Ba nyiem ŋman ka wari wari a nyɛ a gum nna po. ");
INSERT INTO bwu_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pɔɔl yaa yiri zaani Ariyapagus nuruma niŋ a weeni ba ayen, “M nya kama ale nama Atens demma a yaali Naawen wie ka nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Dii nyiŋ la, mi ale kasim va tɛŋka po a taam la, mi nya jigi ŋaai meena ate ni a kaab la ale bogluta ate ni se zaani a ŋmarisi kunyi nyiŋ ayen, ‘Naawen dii ate ti ze la.’ Ni be basi ate m weeni a sak ni ayen Naawen dii ate ni a te di zula alege ni ze di la, ka Naawen dila ate yɔgyɔgla de mi a biisi di wari a sak ni. ");
INSERT INTO bwu_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Wa ka Naawen waai ale nyɛ tɛŋka meena ale jaab buuri meena ale bo ka po la. Wa ka waai ale ka wenŋmazuk ale tɛŋzuk Nyɔnɔ la. Wa be an bo daa yeri ŋaai ate nurubisa se la po. ");
INSERT INTO bwu_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Yaase ku be kan fe kama ayen Naawen pa nurubiik ate wa nyɛ wari a te wa. Dii nyiŋ la ka wala dek ale a te nyuvuri jaab buuri meena. Be ka wala me ale a te nurubiik meena jaab buuri meena me. ");
INSERT INTO bwu_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Wa liŋ nyɛ ka nuru yeŋ, a yaa va nuru wala nyiŋ a nyɛ nuru bɔari tɔgatɔga tɛŋzuk de meena. Ka wa dek me abe ale poli diipo ate tɛŋsa tɔgatɔgaka tɛŋzuk de ale boro a beni la. Wala dek me abe ale daani tɛŋbanaŋa a te tɛŋsa tɔgatɔgaka tɛŋzuk de. ");
INSERT INTO bwu_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Naawen nyɛ nyaŋa de meena kama ayen ku basi ate nurubiik nyiem a gisi wa ate da dii dai ba baga a nya wa. Alege, ni basi ate m weeni a sak ni ayen Naawen mɔata ti ka nna farafara ");
INSERT INTO bwu_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ase nuru wanyi ale weeni dii ayen, ‘Ka wala ale basi ate ti vua a nyiem a cheŋ ale boro.’ Ku a nyɛ ase ka ni dek nuruma ale ŋmarisi dii ayen, ‘Tama me ka wa bisa la.’ ");
INSERT INTO bwu_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Tama a be dan ka Naawen bisa, ku a fe kama ayen ti kan a poli ayen wa a neensi ka kuta a yaase tintana ate nurubiik a pa wa dek yam a peesi ba la. ");
INSERT INTO bwu_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Diipo ate nurubiik a jam ze Naawen la, wa an jam te nurubiik waalika ase ku ale magsi ayen wa te ba dii la. Alege yɔgyɔgla de, wa yaa a weeni nurubiik meena jigi meena kama ayen ba tagri basi ba wabaata tuimaŋa tomka. ");
INSERT INTO bwu_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Boan nyiŋŋa, wa dak ka dai ayen dai dila danni abe wa pa nuru wanyi ate wa lueri ayen wa va wala nyiŋ a bo tɛŋzuk de meena wensie buusa. Nuru wala abe ale wa nak a yiri kum po ayen ku basi ate nuru meena seba chak nalimnyiini ku le sum nyɛ kama.” ");
INSERT INTO bwu_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nuruma ale wom ale Pɔɔl a biisi magsi chaab ale yiri kum po wie la, ba gela a yaa jam nyɛ wa a la. Ba gela me a weeni ayen, “Ti ŋman a yaali kama ayen fi biisi nyaku de wie ate ti wom.” ");
INSERT INTO bwu_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pɔɔl a yaa basi tuka jigini ale cheŋ. ");
INSERT INTO bwu_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nuru ba gela ale jam maa gum wa po a ta siaka ale Yeezu. Nuruma de po wanyi yoi ale Daanisios. Wa jam maa ka Ariyapagus kpaŋŋa po dinyi. Nipɔk me ale jam maa ta siaka. Wa me yoi ale Damaris. Nuruba ba chaab me a jam maa ta siaka a gum du. ");
INSERT INTO bwu_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pɔɔl ale ga biisi ale Ariyapagus kpaŋŋa tuka a nueri la, ku ŋaaŋnyiŋ ate wa yaa basi Atens ale cheŋ Korinti. ");
INSERT INTO bwu_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Dula jigini wa yaa nya Juu wanyi, ate ba a wi ayen Akiila. Ba biak wa ka Pontus tɛŋka. Wa ale wa pɔk ale jam nyini Italiya tɛŋka jam daaŋa de. Wa powa yoi ale Pirisila. Ba jam nyini tɛŋ kala jam kama dii nyiŋ la, Nakpioŋku Kilɔdiyus ale jam te wada ayen Juuma meena basi Aroom tɛŋka. Pɔɔl yaa cheŋ ayen wa nya Akiila ale wa powa. ");
INSERT INTO bwu_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Wa jam a goa ale ka bala ale a tom ale ba dii nyiŋ la Pɔɔl jam a baali ka duŋsa gbaŋsa a da ase Akiila ale wa powa ale jam a nyɛ dii la. ");
INSERT INTO bwu_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Juuma Vuusum Daaŋa meena wa nyiem jam ta ka biik ba tuka yenni po ale Juuma ale baai ale kan daa Juuba la a biisi ale a poli ayen wa dan baga abe wa nyɛ ate ba ta siaka ayen wa ale a biisi dii la ka wensie. ");
INSERT INTO bwu_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas ale Timoti ale nyini Masidoniya a jam la, ba jam a paari ale Pɔɔl yaa kasim jam pa ka daaŋa meena wa boka po a kasim a sak Juuma Naawen wamaŋsaŋa a biisi ate ku a lagri ayen Yeezu ale Kirisitawa waai ate Naawen weeni ayen wa le tom ate wa jam la. ");
INSERT INTO bwu_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Nuruma ale jam a weeni ale a biisi wa a kaasi ayen ba kan yaali wa ale a weeni dii la, Pɔɔl me yaa kpaanti wa gattaŋa paasuku ayen ku sak ba ayen wa a kaam ba kama a weeni ayen, “Ni dan be nama dek ale soa dila. Ku daa mi niŋŋa a zaani yɔgyɔgla de a ta a cheŋ m le cheŋ ka nuru baai ale kan daa Juuba la jigi.” ");
INSERT INTO bwu_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pɔɔl yaa basi ba ale cheŋ nuru wanyi waai ale kan daa Juu la yeri. Wa yoi ale Titus Jasitus. Wa jam ka waai ale a chali Naawen nna yegayega la. Wa yenni jam za mɔata ka Juuma tuka yenni. ");
INSERT INTO bwu_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Nuru waai ale jam chim tuka yenni kpagi la yoi ale Kirisipus. Wala ale wa dɔkdemma meena a jam ta siaka kama ale Nyɔnɔwa. Nuruba yegayega me Korinti tɛŋka a jam maa wom wamaŋsaŋa kama a yaa ta siaka a tuesi soka. ");
INSERT INTO bwu_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","10","Yok kunyi ate ku yaa nyɛ Pɔɔl jigi ase wa goa daasim kama la ate wa nya Nyɔnɔwa ate wa weeni ayen, “Kan chali yɔgsum, boan nyiŋŋa, mi bo ale fu, kama. Nuru karo a baga a te fi tuomɔa. Kan sina, a biisi boan nyiŋŋa, mi ta ka nuruba yegayega tɛŋka de po, baai ale a limsi ayen ba wom mi wanni.” ");
INSERT INTO bwu_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pɔɔl jam bo dula jigini ate ku paari ka bein ale geli a sak nuruma Naawen wanni. ");
INSERT INTO bwu_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nuru wanyi ale jam boro ate ba a wi wa ayen Galiyo, ate Aroom tɛŋka a jam lueri wa ate wa chim Gomina a tagri Aroom tɛŋka zuk a ga bo Korinti tɛŋka a nya Akaaya tɛŋka zuk. Diipo ate nuruwa de a jam chim Akaaya Gominawa la, dila powa ate Juuma a jam maa chaab a yik Pɔɔl ale pagrim a ta wa cheŋ dɔk kuui ate Aroom demma a biisi biisaŋa la. ");
INSERT INTO bwu_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ba jam a weeni kama ayen, “Nuruwa de Pɔɔl, a kasim pii ka nyiŋ a paasi nuruma ayen ba a te Naawen zula ŋaai ale kan a va sinsaŋŋa ale a sak dii la.” ");
INSERT INTO bwu_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pɔɔl ale deri lagi noai ayen wa biisi a vari wa dek basi la, Galiyo yaa weeni Juuma ayen, “Ku daam dan ka wari dii ale ka wabiok a yaase wakaasuŋ ate wa nyɛ, ku te nala kama ate m ta chichiiba ale nama Juuma nna, ");
INSERT INTO bwu_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","alege ku ka wa dii ale ka nampaga wari a magsi chaab ale wie ŋaai ate ni pa a biisi la, ale nuruba yue la, ale sinsak ŋaai ate nama nyiini a va la, ku a fe kama ayen ni dek abe biisi a magsi chaab. Mi kan chim wieŋa de chaab boteerɔ.” ");
INSERT INTO bwu_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Galiyo weeni dila ale ge yiak ba ate ba nyini biisa dɔkku po a nyini. ");
INSERT INTO bwu_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ba meena yaa yik Sositenisi waai ale jam ka tuka dɔkku kpagini la a zaani biisaŋa dɔkku niŋ a nak. Alege dila an jam daani Galiyo ale magla me. ");
INSERT INTO bwu_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔɔl jam bo Korinti tɛŋka ale Kirisita bisaŋa ate ku beni ka nna yegayega. Da yeŋ wa ale Pirisila ale wa chorowa Akiila a yaa banti ba ale ge jueli ŋaaruŋ a cheŋ Siriya. Ba ale jam zaani Keŋkeriya ayen wa jueli ŋaaruŋku a cheŋ la, Pɔɔl jam poni wa zukku kama, dii nyiŋ la wa pe kama a magsi chaab ale dila. ");
INSERT INTO bwu_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ba ale jam paari Efisos tɛŋka la, wa yaa basi Pirisila ale Akiila dula jigini. Pɔɔl yaa biisi biik ale Juuma ba tuka yenni po. ");
INSERT INTO bwu_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ba yaa weeni wa ayen wa goa magla ale ba alege Pɔɔl zɛri ");
INSERT INTO bwu_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","alege weeni ba ayen, “Ku dan ka Naawen yaalika m le pilim ŋman jam ni jigi.” Pɔɔl weeni dila ale jueli ŋaaruŋ a zaani Efisos a cheŋ. ");
INSERT INTO bwu_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Wa ale jam paari Siizariya la, wa yaa cheŋ Jerusalem a ga puusi Kirisita bisaŋa ale a tu chaab dula jigini la ale ge a yaa cheŋ Antiok. ");
INSERT INTO bwu_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Wa ale beni maga dula jigini la, wa yaa basi dula, ale va Galatia ale Firijiya tɛŋsaŋa po a deŋsi Kirisita bisaŋa kpa. ");
INSERT INTO bwu_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Juu wanyi ate ba a wi ayen Apolos ate ba biak wa Alezandiria la, a yaa jam Efisos. Wa jam ka waai ale baga a biisi nna yegayega ale seba Naawen Gbaŋka wieŋa nna yegayega me la. ");
INSERT INTO bwu_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Nuruba ale poom liŋ jam sak wa Nyɔnɔwa siuku wieŋa nna yegayega ate wa a biisi ale a sak ale nin muna a va siuku nalimnyiini wensie ŋaai ale a magsi chaab ale Yeezu la. Alege soka kaai nyiini ate wa jam seba la ale soka kaai ate Jɔɔn te la. ");
INSERT INTO bwu_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Wa yaa piilim a deri a biisi nyaŋa de meena ba tuka yenni po ale kan chali yɔgsum. Alege Pirisila ale Akiila ale wom biika la, ba yaa yik wa a tɔgi Naawen siuku meena wieŋa ate ŋa lagri a te wa nalimnyiini. ");
INSERT INTO bwu_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolos yaa poli ayen wa jueli ŋaaruŋ a cheŋ Akaaya tɛŋka. Kirisita bisaŋa ale jam bo Efisos la a yaa deŋsi wa kpai a ŋmarisi gbaŋ a te Akaaya Kirisita bisaŋa a saalim ba ayen ba tuesi wa nalimnyiini. Wa ale jam paari du la, wa jam maa maari nna yegayega baai meena ale va Naawen niaka nyiŋ a chim Kirisita bisa la. ");
INSERT INTO bwu_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Boan nyiŋŋa, wa kasim jam nak ka nampaga ale pagrim a biisi yiak Juuma. Ba nyini ka peelim a nak nampaŋŋa ale chaab dila ate Apolos a yaa biisi a ta nyini Naawen Gbaŋka wieŋa po ate ku lagri ayen ku sak ba ayen Yeezu ka Kirisita waai ate Naawen a weeni ayen wa le tom ate wa jam la. ");
INSERT INTO bwu_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos ale jam bo Korinti la, Pɔɔl yaa cheŋ va Galatia ale Firijiya tɛŋsaŋa sunsuŋ po a taam nyini cheŋ Efisos. Dula jigini, wa yaa nya ŋaaŋviiriba ba gela ");
INSERT INTO bwu_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","a yaa bek ba ayen, “Diipo ate nama chim Kirisita bisa la, nama tuesi Naawen Chiika?” Ba yaa tulisi wa ayen, “Tama an poom wom ayen Naawen Chiik boro.” ");
INSERT INTO bwu_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pɔɔl yaa bek ba ayen, “Ku be dan ka dila nama abe tuesi ka boan soka?” Ba yaa tulisi Pɔɔl ayen, “Ka Jɔɔn soka ate tama tuesi.” ");
INSERT INTO bwu_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pɔɔl yaa tulisi ayen, “Soka kaai ate Jɔɔn te la, wa te ka baai ale basi ba wabaataŋa tomka la. Wa jam te ba kama ale ge weeni Izirali demma ayen ba be pa ba dek a te waai ale bo ŋaaŋ a cheena la. Kula nyɔnɔwa ale Yeezu.” ");
INSERT INTO bwu_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ba ale wom nna la, ba yaa tuesi soka Nyɔnɔwa Yeezu yonni nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pɔɔl yaa pa nisima a vi ba zuk ate Naawen Chiika yaa siŋ jam ba zuk ate ba deri jam biisi be sii ale kan daa ba dek biisa la a yaa weeni Nyɔnɔwa ale weeni ba ayen ba weeni dii la. ");
INSERT INTO bwu_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Baai ale jam nyɛ nna la, a jam a nyɛ ase ka nuruba pi ale baye la. ");
INSERT INTO bwu_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Chiisa sita meena Pɔɔl kasim jam a jo ka Juuma tuka yenni po a biisi wie ale nuruma. Pɔɔl a kasim pii nyiŋ a biisi ale ba ayen ba miŋ chak Naawen Naamu wie ale ka dii la. ");
INSERT INTO bwu_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Alege ba gela tue a jam kpari ka nna yegayega ate ba jam kan yaali ayen ba ta siaka, ate ba jam a biisi be bulorisa nuruma meena niŋ a magsi chaab ale Nyɔnɔwa siuku. Dila nyiŋ la, Pɔɔl yaa yik ŋaaŋviirima ate ba maa chaab a basi ba ale cheŋ. Daa meena Tiranus yenni po Pɔɔl jam a biisi ka biik ale nuruba dɔk kpioŋ kuui po ate nuruba kali a sak nuruba la. ");
INSERT INTO bwu_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Wa kasim jam a nyɛ ka dila ate ku ga paari a yaase ku gaam bena ŋaye ate nuru baai meena ale jam bo Asia tɛŋka po la (Juuma ale baai ale kan daa Juuba) a jam wom Nyɔnɔwa wanni. ");
INSERT INTO bwu_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Naawen a jam pa Pɔɔl a tom wakperikaliisa gaam wakperikaliisa ale ka dii la kama. ");
INSERT INTO bwu_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Wa lakima ale tuima ga tii ate wa jam ta la, nuru a dan pa ŋanta bala wanyi a ta ga yɔgnyieŋ jigi kula nyɔnɔwa nyiŋtuilaŋa a yaase wa chichiribaataŋa a basi wa kama. ");
INSERT INTO bwu_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Juuma baai me ale jam boro a nyiem a gilim a yiak chichiribaata nuruba zuima po a basi la, ba me a jam pii ka nyiŋ pa Nyɔnɔwa Yeezu yonni nyiŋ a nyɛ dila. Ba yaa weeni chichiribaataŋa ayen, “Yeezu waai ate Pɔɔl a sak wa wieŋa la, yonni nyiŋ ate mi a weeni fu ayen fi nyini nuruwa zuk po a nyini.” ");
INSERT INTO bwu_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Baai ale jam a nyɛ nna la ka Juuma Puusika Yenni kpagi kpeeni wanyi bisa. Ba jam ka bisa bayopoi. Ba kowa yoi jam ale Sikiiva. ");
INSERT INTO bwu_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Chichiribioku yaa weeni ba ayen, “Mi seba Yeezu kama, m be seba Pɔɔl me kama. Alege nama, ka bana?” ");
INSERT INTO bwu_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nuruwa yaa deri yiri a tu chaab ale ba meena a nak ba yiak. Ba meena yaa yiri chali ale nira ale chabɔla a basi nuruwa yenni. ");
INSERT INTO bwu_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Juuma meena ale baai ale kan daa Juuba ate ba meena bo Efisos la a jam wom nyaku de kama ate yɔgsum yaa jam yik ba meena ate Nyɔnɔwa Yeezu yonni a jam nya zula nna yegayega. ");
INSERT INTO bwu_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Baai ale chim Kirisita bisa yɔgyɔgla de la bala yegayega a yaa jam nyini peelim a siak ale a weeni wie ŋaai ate ba jam nyɛ la. ");
INSERT INTO bwu_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ba yegayega baai ale jam ka sampoporisa a yaase tiita nyam la, a jam ta ba gbaŋ sii ate ba a nya si po a tom ba tuimaŋa la a jam jigi yeŋ waai meena nimbie po a ju ba a basi. Ba jam maa pa gbaŋsaŋa ligra meena a gum du kama, ŋa dan cheesi gum chaab ŋa a paari ka ligbie tusa pisinu. ");
INSERT INTO bwu_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Siuk kula po ate Nyɔnɔwa wanni a kasim jam a tagli tɛŋka meena ale pagrim. ");
INSERT INTO bwu_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Wieŋa de meena ale ga nyɛ la ŋaaŋnyiŋ ate Pɔɔl yaa poli wa zuk po ayen wa le va ka Masidoniya ale Akaaya ŋaaŋnyiŋ a taam cheŋ Jerusalem. Wa yaa weeni wa dek ayen, “M dan cheŋ dula, ku a fe kama ayen m basi dula abe m cheŋ Aroom tɛŋka.” ");
INSERT INTO bwu_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Dila nyiŋ wa yaa tom baai ale maara a maa wa la po baye, Timoti ale Erasitus ayen ba cheŋ Masidoniya ale ge ate wa dek a diem wari Asia tɛŋka ate ku beni maga. ");
INSERT INTO bwu_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ku jam ka nna po de ate daani kpieŋ a jam jam Efisos tɛŋka Nyɔnɔwa Siuku wieŋa nyiŋ. ");
INSERT INTO bwu_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Nuru ale jam boro ate ba a wi wa ayen Dimetirus. Wa jam pa ka kuta tii ale a nyagsi la, a nyɛ ŋanta a da. Wa jam a nyɛ ka bogluk kuui ate ba a wi ayen Atimis la yenni a da. Wa tuimaŋa de a jam basi kama ate baai ale a nyɛ ŋanta bala a da la a jam nya tuima. ");
INSERT INTO bwu_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Wa yaa jam wi nuruma de chaab ale baai ale a tom ale ba la ate ba jam jigi yeŋ ate ba nyɛ tuka. Wa yaa piilim wa biik ayen, “M dɔaba, nama dek seba ayen ti jigsika meena a nyini ka tuini de po. ");
INSERT INTO bwu_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Nama dek abe nya kama ale wom nuruwa de Pɔɔl ale a nyɛ dii la. Wa a weeni kama ayen bogluk tii ate nuruba pa ba nisima nyɛ la, a ka pagrim fiifiik me la. Wa a biisi dila a paasi nuruba yegayega kama. Efisos ale Asia tɛŋka meena po ba siak wa ale a biisi dii la kama. ");
INSERT INTO bwu