﻿USE sofia;
DROP TABLE IF EXISTS sofia.bwo_vpl;
CREATE TABLE bwo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bwo_vpl WRITE;
INSERT INTO bwo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1"," Dawitnat Abrahamn naar wottso Iyesus Krstos shuweyi s'ap'o haniye. ");
INSERT INTO bwo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham Yisak'i b́shuwi, Yisak' Yak'obi b́shuwi, Yak'ob Yihudnat bí'eshwotsi b́shuwi, ");
INSERT INTO bwo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yihudwere Faresnat Zaran Timari eteef máátswatse b́shuwi, Fares Hesroni b́shwi, Hesronwere Arami b́shuwi, ");
INSERT INTO bwo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramu Aminadabi b́shuwi, Aminadabu Ne'asoni b́shuwi, Ne'asonu Selmoni b́shuwi, ");
INSERT INTO bwo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Selmon Boezn Reaabi eteets máátswatse b́shuwi, Boez Iyobedn Ruuti eteef máátswatse b́shuwi, Iyobed Iseyi b́shuwi, ");
INSERT INTO bwo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isey Nugúso Dawiti b́shuwi. Nugúso Dawit Oriyo mááts teshtswatse Selemoni b́shuwi, ");
INSERT INTO bwo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Selemon Rob'ami b́shuwi, Rob'am Abiyayi b́shuwi, Abiyawere Asafi b́shuwi, ");
INSERT INTO bwo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaf Iyosaft'i b́shuwi, Iyosaft' Iyorami b́shuwi, Iyoram Oziyani b́shuwi, ");
INSERT INTO bwo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oziyanwere Iyo'atami b́shuwi, Iyo'atam Akazi b́shuwi, Akaz Hzk'iyasi b́shuwi, ");
INSERT INTO bwo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hzk'iyas Mnaseyi b́ shuwi, Mnaase Amos'i b́shuwi, Amos' Iyosyasi b́shuwi, ");
INSERT INTO bwo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iyosyas Israe'el ashaasho Babilon maants bo kishodek't damets dúr Ikoniyannat bí'eshwotsi b́shuwi. ");
INSERT INTO bwo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bokisho dek't Babiloni dameyakon Ikoniyan Salatiyal b́ shuwi Selatyal Zerubabeli b́ shuwi, ");
INSERT INTO bwo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabel Abiyodi b́shuwi, Abiyodu Eelyak'emi b́shwi, Eelyak'em Azori b́ shuwi, ");
INSERT INTO bwo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor Sadok'i b́shuwi, Sadok' Akimi b́shuwi, Akim Eelyudi b́shuwi, ");
INSERT INTO bwo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eeliyud Alazari b́shuwi, Alazar Matani b́shuwi, Matan Yak'obi b́shuwi, ");
INSERT INTO bwo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yak'ob Krstosi eteefo Iyesusi shuwtsu Mariyami wid'tso Yosefi b́shuwi. ");
INSERT INTO bwo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Eshe Abrahamatse tuut Dawitats b́borfetso tatse awd gubra, Dawitatse tuut kisho dek't Babilonits dameetsok b́borfetso tatse awd gubra, kisho dek't Babiloni dametsatse tuut waa Krstosok b́borfetso tatse awd gubree. ");
INSERT INTO bwo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iyesus Krstos b́shwetsok'o hank'oyi b́tesh, b́ índ Mariyam Yosefsh wid'eyat bbefere, bogonkerawon bi S'ayin shayiron maac'at' bdatseyi. ");
INSERT INTO bwo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Bin wid'tso Yosef ash kááw b́teshtsotse Maryami ash shinatse kish kitso geeratse, mansh áátson k'azk'ro b́gaw. ");
INSERT INTO bwo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ernmó keewan jango shiyanoke b́befere doonzo melakiyo gúmon bí'ats be'eyat hank'o bíet, «Dawit naaro Yosefo! Nwid'tsu Mariyam bmaac'tso S'ayin shayiron b́wottsotse bin nmoo maants dek'osh shatk'aye. ");
INSERT INTO bwo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Biye nungush na'o shwitwaniye, bí ashuwotsi morrotse b́kashitwotse b́shútso Iyesusi etetune.» ");
INSERT INTO bwo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Jaman b́wottsonwere doonzo nebiyiyo weeron b́keewtso b́s'eenetwok'owe, ");
INSERT INTO bwo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Hambe, baar na'a s'eenu mac'itwanee, nungush na'onowere shuwitwane, b́ shútsonwere ‹Amanu'eli› err s'eegetwe.» Amanu'eli etonwere «Ik'o nontoniye» etee. ");
INSERT INTO bwo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosef tokrotse b́ tuwor, doonzo melakiyo bísh b́keewtsok'on b́ wid'tsu Mariyami b́moomants dek'tbíami. ");
INSERT INTO bwo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Wotowa eree bna'o bshuufetsosh bin danatse. B́shútsonowere Iyesusi et b́s'eeg. ");
INSERT INTO bwo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nugúso Herodis dúr, Yihud datsatse daatseyiru Betelihem kitutse Iyesus b́shuweyiye hakon, k'eeni jango danfwots aaw keshomande Iyerusalem maants boweyi. ");
INSERT INTO bwo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Hank'o etnwere bo aati, «Shuwets Ayhudi nugúso aawoke? B́ k'eeno aawkeshon bek'aat bísh sagadosh waarone.» ");
INSERT INTO bwo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nugúso man b́shishtsok'on tek' b́wtsi, Iyerusalem ashjamonwere bínton tek'bowtsi, ");
INSERT INTO bwo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kahni naash jamwotsntonat ashuwotsitse nemo danifwotsi kakudek't, Krstos b́shuwetwo aawk'on b́wottsok'o boon bí aati. ");
INSERT INTO bwo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bowere hank'o ett bísh bo aaniyi «Nebiyiyon hank'o etts bek'o guut'etsotse, Krstos b́shuwet Yihud datsatse Betelem kitotsnee, ");
INSERT INTO bwo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Yihud dats kayotse daatseyiru Betelemee! Ti ash asho Isra'eli korde'er jishitwo n datsatse b́keshetwotse, Yhuditsi kit een eenwotsiyere eegonoru dasheratsne.› » ");
INSERT INTO bwo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Maniyere il Herodis k'eeni jango danfmanotsi ááshon s'eegidek't, k'eenman awr b́ be'etsok'o arikon aatt danbdek'i. ");
INSERT INTO bwo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Hank'o ettnwere Betelem maants boon woshb́k'ri «Amr na'o jango t'iwintsde danere, bín itdatstsok'onowere taawere amr bísh tsagaditwok'o waar taash keewwere.» ");
INSERT INTO bwo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Bowere Nugúso aap'o booshishihakon kesht boami, eshe! aawkeshon bobek'ts k'eeno na'i marmat'o b́beyirwok b́ned'efetsosh bo shinshinatse sha'efetst boon b́jishi. ");
INSERT INTO bwo_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","K'eenman bobek'tsok'on ayidek't gene'ubowtsi, ");
INSERT INTO bwo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mootsowere kindt na'i marmat'o bí'ind Mariyamnton b́befere bobek'i, b́shinats gúp gúp'at bosagadi, bo sat'nonowere k'eshdek't aawntso, it'anonat kerbeya etef shak' shaawo bísh bot'intsi. ");
INSERT INTO bwo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Herodis maantsowere bo aanerawok'o Ik'o gúmon boosh b́keewtsotse k'osh weerindon bodatsomand aanat k'azboami. ");
INSERT INTO bwo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","K'eeni jango danfwots boamiyakon, doonzo melakiyo Yosefats gúmon be'eyat, «Herodis na'i marmat'o úd'osh b́geyirwotse, tuur na'i marmat'o indunton de'er Gbs'maand k'ay amee, neesh tkeewfetsonowere manoke betee» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mann Yosef t'úwon tuut na'i marmato bí índnton dek't Gbs'maand k'az bíami. ");
INSERT INTO bwo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Manoknowere Herodis b́k'irfetso b́teshi, man b́wottsonúwere doonzo nebiyiyo weeron «T naayi Gbs' datsatse s'eegree» bíettso b́s'eenetwok'owe. ");
INSERT INTO bwo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodis maniyere il, k'eeni jango danfwots bín bo ant'elctsok'o t'iwints b́dek'tsok'on, ayidek't b́fayi, bísh kes' kes'fwotsi Betelihemnat bgúratse fa'a gal gal jamwotsmaants woshat, k'eeni jang danfwotsatse b́dúro aatt danb́dek'tsok'on bo nato gitnatonat maniyere dash wottswotsi Betelihemitsnat bgúratse fa'a, beyat teshtswots nungush nana'uwotsi úd'iyb'ishi. ");
INSERT INTO bwo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Manoor nebiyiyo Ermiyasn hank'o ett bek'on keewetso b́s'eeni. ");
INSERT INTO bwo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Rahel b nana'úwotssh bieep'fere, Kuhonat s'aamts eepi k'aaro Ramayitse b́ shisheyi Bnana'uwots kashon bo altsotse kup'dek'o k'azraniye.» ");
INSERT INTO bwo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodis b́ k'irihakon Doonzo melakiyo Gbs'itse Yosefats gúmon be'eyat, ");
INSERT INTO bwo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«Na'o kasho geyiru ashuwots bo kirtsotsnee tuur na'o indunton de'er Isra'el maants amee» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yosefwere tuut na'o indúnton Isra'elmants dek't bíaani. ");
INSERT INTO bwo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Wotowabako Arkelawos b́nih Herodis shegro Yihud datsatse b́ naasho b́shishtsok'on Yosef manmaants amo shat b́gutsi. Eré gúmon bín jishitwo imetsotse Gelil maants bíami. ");
INSERT INTO bwo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","«Nazrawiya eteetwe» ett nebiyiyon keewetso b́s'eenetwok'owo, Naazreti eteef kituts waat be b́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Manoor gupfo Yohans Yhud worwotse nabfere b́weyi. ");
INSERT INTO bwo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","B́daniferowere «Eshe! Ik' mengstu b karntsotse naandrone erere» b́ etfo. ");
INSERT INTO bwo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","« ‹Doonzo weerindo k'aniwere, B́fudonore káátswere!› etfetst worwotse kuhiru asho k'ároniye» ett́ nebiyo Isayas b́keewtso Yohans jangoni b́teh. ");
INSERT INTO bwo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohans taho kambli s'iron wozeka b́tesh, b́gebatsowere shaak'a bí edefo, b́ máfonwere p'elonat dok'shi mas'a b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Manoor Iyerusalemitse Yhud dats jamatse, Yordanos gúúr jamatse ash asho Yohans maantsa bowaafo. ");
INSERT INTO bwo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bowere bomorro keewfetst, Yordanos fokotse Yohans kishatsna bogupefo. ");
INSERT INTO bwo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ernmó Yohans ferisawino eteefwotsnat Seduk'awino eteefwotsitse aywots gupeyosh bíyo bowafere b́bek'tsok'on boosh hank'o bíeti «It dawnzi nana'uwotso! weyiru fayotse it keshetwok'o kone izi itsha? ");
INSERT INTO bwo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Eshe naandrone it ettsok'o kitsit fino finore. ");
INSERT INTO bwo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","‹Noo Abraham nana'uwots noone› eto itn b́kishitwok'o itsh ark'aye, Ik'o shútsanotsitse Abrahamsh nana'uwotsi tizosh falitwe etirwe itsha. ");
INSERT INTO bwo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Andmó, shakurtso miti shir jamotse fe'e. Mansh shuwi sheeng shuraw mit jamo k'ut'de'er tawots juwetwe. ");
INSERT INTO bwo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Eshe hamb taa, naandi jangosh aatson iti gupetwe, taayere il wetwonmó S'ayin shayironat tawon itn gupetwe, bíye taayere ayidek't bogfe, taa b́ tufitsi c'aamo dab́ kurosh bodktanaliye. ");
INSERT INTO bwo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Bíye b́ kishatse k'orbiyo detsfe, bínowere búts úro sheengshde'er s'ayintsitwe. Sndewonowere t'iwots gaas'etwee, buuyonmó tahraw tawon mitsitwe.» ");
INSERT INTO bwo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Manoor Iyesus Yohans kishon gupewosh Gelil datsatse tuut Yordanos foko maants b́weyi. ");
INSERT INTO bwo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yohansmó «Han woteratse, taa nkishon gupewo taash b́geyifere, aawk'oneya nee tmaants nweeti?» ett bín baziyo dek'b́twi. ");
INSERT INTO bwo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Iyesusmó «Ik'i shinatse kááw wotts fin jamo hank'on s'eentso noon b́geyitsotse, ando taan bazi k'aye» ett bísh bí aaniy. Yohanswere keewman wotowe ett bín b́gupi. ");
INSERT INTO bwo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Iyesus gupeyat aatsotse b́ keshtsok'on manoor daro k'esheeb́wtsi, Ik'i S'ayin shayiro kurkund araat Iyesus ats b́ oot'fere b́ bek'i. ");
INSERT INTO bwo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Manoor «Hambe, bín t geneúwitwo t shunts na'oni» etiru k'ááro darotse b́weyi. ");
INSERT INTO bwo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Maniyere il, Iyesus Diyablosń b́ fadetwok'o Ik'i shayiro worwo maants bín dek'tbíami. ");
INSERT INTO bwo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Manoknowere hab aawonat hab t'úwo b́ s'oomiyakon k'ak'b́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Faditwonúwere Iyesus maants waat «Nee arikon Ik'o naayi neena wotiyal, ááb shútsanotsi misho wotoore err azazowe» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Iyesusmó « ‹Asho b́ beet Ik'o nonotse keshet aap' jamona bako mish mec'ronaliye› ett guut'ere» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Maniyere il, diyablos Iyesusi S'ayin kitu Iyerusalem maants dek'amt Ik' maa tookats need'idek't, ");
INSERT INTO bwo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","« ‹Nee arikon Ik'o naay neena wotiyal n tufwotsi shútso b́towawok'o, Bokishon neen dambaan botep'etwok'o b́ melakiwotsi azazitwe› Ett́ guut'etsotse, hanatse dashan ntooko sha'e» bí et. ");
INSERT INTO bwo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iyesuswere anidekt « ‹Ando n doonz Izar Izeweri fadk'aye› ett guut'ere.» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Aaninwere diyablos Iyesusi ayidek't damb tuuts gurats kishdek't, datsatsi naash jamo bomangonton kitst ");
INSERT INTO bwo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","«Taash gúp'gup'ar n sagadiyal jaman neesh imetwe» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Manoor Iyesus, « ‹N doonz Izar Izewersh sagadowe b́ s'uznowere ik'iwe!› ett guut'etsotse ok tuwwe nee shed'anono!» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Maniyere il diyablos Iyesusi k'azb́k'ri, melakiwotswere waat bísh bofini. ");
INSERT INTO bwo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Iyesus Yohans b́tipewo b́ shishtsok'on Galil datsomand k'azbíami. ");
INSERT INTO bwo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazret kitu k'azk'rat, Zablonnat Nftalem awrajo Gelil aats k'ari ganoke fa'ú K'frnahom kitots waat b́beeyi. ");
INSERT INTO bwo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Man b́ wotwere, nebiyiyo Isayas hank'o ett b́keewts bek'on aap'etso b́ s'eenetwok'owa b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Aats k'aromaants dek't amiru werindonat Yordanos fokoniyere bak'etse Daatseyiru Zablon datso, Nftalem datso, Ik' ash woteraw Gelilo! ");
INSERT INTO bwo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","T'alwotse beyiru asho sháán eeno bek're, K'iri c'iisho bíyats b́dihts datsatse beyirwotsshowere shááno keshre.» ");
INSERT INTO bwo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Manortson b́tuutso Iyesus, «Ik'i mengstu bkarnotsotse naandrone erere!» et fetst nabo dek't b́tuwi. ");
INSERT INTO bwo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iyesus Gelil aats k'ari ganoke b́beshefere, mus' detsf eshu gitwots, boowere P'et'rosi eteefo S'imoonnat bí eshu Indriyasn bo mus'kambo aats k'aromaants boshap'fere b́bek'i. ");
INSERT INTO bwo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Iyesuswere «Tshuutso shoyde woore, Mus'o it detsirwok'o ashuwotsi taash it kakwitwok'o woshitwe» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Bowere manoor bo mus'i kambo k'azk'rat b́shuutso shoydek't botwi. ");
INSERT INTO bwo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Maniyere beshat, Zebdiwos nana'a wotts k'osh eshu gitetswotsi Yak'obnat Yohansn bek'b́k'ri. Bowere bonih Zebdiyosnton jeelbi abaats wotdek't bo mus'ikambo shipoke bobefere boon b́s'eegi. ");
INSERT INTO bwo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Bowere manoor bo jelbunat bonihn k'azk'rat b́ shuutso shoydek't boami. ");
INSERT INTO bwo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iyesus ayhudiyots Ik' k'oni mootse danifetst Ik'i mengsti doo shishi aap'i jango keewfetst, ay naari shodonat atsiweshon deshets ashuwotsi kashifetst Gelil dats jamatsa b́ guurefo. ");
INSERT INTO bwo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","B́ shútso Sooriya eteets dats jamatse b́ shishetsotse ash jamo shod naar ayonat, bo kishonat tufoon lasha'atswotsi, shod ayon kic'rwotsi, kim shayiro bogitsotse kindt fa'úwots, dikf shodo detstswotsenat dúr jametswotsnowere b́maants dek't boweyi, bíwere kashi bí'ishi. ");
INSERT INTO bwo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Gelil datsonat tats kitwotsitse Iyerusalemnat Yhudon, Yordanos fokoniyere bak'etse ayi ashuwots Iyesus shuutso shoyidek't bosha'i. ");
INSERT INTO bwo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iyesus b́ shuuts shoydek't sha'iru ay asho b́ bek'tsok'on, guri abaats kesht beeb́dek'i, b́ danifwots b́maants t'iinbodek'i. ");
INSERT INTO bwo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Hank'o et tnwere daniyo dek'b́twi. ");
INSERT INTO bwo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Dari mengstu bok b́wottsotse, Ik'ats te'eyirwots derekne. ");
INSERT INTO bwo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ik'o boon b́ k'up'shitwotse, shiyanirwots derekne. ");
INSERT INTO bwo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Sheeng ashuwots datso bo naatetwotse derekne. ");
INSERT INTO bwo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kááw keewo k'ak'irwotsnat shashwirwots, boworitwootse derekne. ");
INSERT INTO bwo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bosh maac'o k'ewetwosh maac' nefitwots derekne. ");
INSERT INTO bwo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nib s'ayin detstswots Ik'o bobek'etwotse derekno. ");
INSERT INTO bwo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ash ashi dagotse manonat jeenon woshitwots, Ik'i nana'uwotsiye eteetwotse derekne. ");
INSERT INTO bwo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kááw keewosh gisheyirwots Ik'i mengstu bok bwottsotse Derekne. ");
INSERT INTO bwo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«T jangosha err ashaashwots itn boc'ashor bogiishor, kooton it shúútso bot'afiwor derek itne. ");
INSERT INTO bwo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Dari mengstotse it daatsit k'awntso een b́wottsotse gene'ore, ayide gene'ore. Itiyere shin teshts nebiyiwotsi mank'o gishewo boats betsrne.» ");
INSERT INTO bwo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Manats dabt Iyesus hank'owa bíet, «It datsatsi beerok'o itne, ernmó beero b́shaawo b́ t'ut'etka wotiyal b́shaawo aak'alrniya aaniy daatso b́faliti? Úromaants juweyar ashon net'eyoniyere okoon shinomaants egoshor woteratse. ");
INSERT INTO bwo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Itiye datsansh sháán itne, guri abaats ageets kitu ááshosh falratsane. ");
INSERT INTO bwo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ashuwots c'eesho c'eeshde'er mootse fa'a ash jamwotssh b́sháánitwok'o girgijiyatsa bogedfoni bako oosh shirots dashan geraknee. ");
INSERT INTO bwo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mank'o ashuwots it sheeng fino be'ear it nih darotstso bo mangiytwok'o, it sháánonwere ash jami shinatse shááne.» ");
INSERT INTO bwo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Aaninwere Iyesus hank'o bíet, «Muse nemonat nebiyiwots danits dano gakosh twatsok'o itsh bíarerawok'owa, taaye bos'eentwok'o woshoshe t weyi bako gákosh waratse. ");
INSERT INTO bwo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ariko itsh keewirwe, daronat datson bobeshefetsosh nem jamo s'eenetwe bako nemotse fidel múk'na'a iku wee k'op'u t'afratsane. ");
INSERT INTO bwo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mansha tzazi múkna'anotsitse dab iku gaketwonat k'osh ashuwotswor bogaketwok'o boon danit asho dari mengstotse múk'ee b́wotitiye. Ernmó t tzazi jamanotsi s'eentsosh, k'oshwotswere bo s'eentsitwok'o boon danit asho dari mengstotse een wotitwe. ");
INSERT INTO bwo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Manshe kááw it woto nem danifwotsenat ferisawino eteefwotskoniyere bogo b́k'azal b́jamon dari mengstots it kindrawok'o itsh keewirwe. ");
INSERT INTO bwo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Yoots dúr teshts ashuwotssh eteetso shishrte, manwere ‹úd'k'aye, ash úd'tsats angshetwe› eteeke. ");
INSERT INTO bwo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Taamó itsh keewirwe, bíeshwi fayitw jamats angsha angsheti, ando bí'eshush, ‹Nee woterawani!› err c'ashetwo angshirwots shinatse bíats angsheti, ‹Dartsani› err c'ashetu jamo gahanem tawotsa b́kinditwok'o bíats angsheti. ");
INSERT INTO bwo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Eshe nee n wosho gizi wosh t'intseyiru t'arp'ezok Ik'osh n door, niyats iirts eshwo b́ beewo n gawitka wotiyal, ");
INSERT INTO bwo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","n wosho gizi wosh t'intsiru tarap'ezmanok gerk'rar, amr shini n eeshunton manewe, maniyere okoon aanar n wosho t'intswe. ");
INSERT INTO bwo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","N balngaro neen s'amire angishi moo maants b́ damfere weerindatse káári n balangaronton ik wotowe. Man woto b́k'zal n nbalangaro danyosh, danyonwere polisosh, polisonu beshde'er b́ ime tipi moots n kinditi. ");
INSERT INTO bwo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Aroniye neesh ti keewiri, niyats angshets santimi tebu day ni'ishfetsosh b́ jamon manitse keyatsne.» ");
INSERT INTO bwo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Manats dabt Iyesus hank'owa bíet, «Wido amk'aye!» eteetsok'o shishrte. ");
INSERT INTO bwo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Taamó itsh keewirwe, «Máátso s'iilt tewnts jamo, manoor b́ nibotse binton k'eeree» etre. ");
INSERT INTO bwo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","N k'ani ááwo morro nfinitwok'o neen b́woshitka wotiyal, kishde juk'rowe! niats jamó gahanemits b́ juwewoniyere níatsatse ikoko nt'ut'o neesh k'anefe. ");
INSERT INTO bwo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","N k'ani kisho morro n finitwok'o b́ k'aliyal, k'ut'de juk'rowe, niats jamo gahanemits b́ juwewoniyere niatsotse ikoku n t'ut'o k'anefe neesha. ");
INSERT INTO bwo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«B́ máátsu fakshitu jamo bin b́fakshtsok'o kitsit frmo bish ímee» etre. ");
INSERT INTO bwo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Taamó «Widi jangon b́wotiyala bako, b́ máátsu fakshitu jamo widets bwotitwk'owa bin b́woshiti, fakshetsu deke'etu jamonwere widetsiye b́wotiti.» ");
INSERT INTO bwo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ando shin ashuwotssh, «Kooton taark'ayere, ernmó it taaro doonzosh s'eentswere» eteetsonowere shishrte. ");
INSERT INTO bwo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Taamó, «B́jamonor taark'ayere» etirwe itsha. Daronwere Ik'i beyoki joor b́wottsotse, daronor b́wotiyal, ");
INSERT INTO bwo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Datsunwere doonzo tufi need'oko bwottsotse datsonor taark'ayere, nugus eeno kitu bwottsotse Iyerusalemno taark'ayere, ");
INSERT INTO bwo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","N took s'iirotse ikunor dab nas'o wosho wee aak' wosho nfalrawotse ntookonor b́wotiyal taark'aye. ");
INSERT INTO bwo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mansh it noon keew keewon «Ee» it etal «Ee» et wotowa wee «Iya'a» it etal «Iya'a» et wotowa bako maniyere beshtso shed'anikee. ");
INSERT INTO bwo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","« ‹Ááwi shegro ááwa, gáshi shegro gásha› eteetsok'o shishrte. ");
INSERT INTO bwo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Taamó hank'o etirwe itsha, gond itats finiru ashuwotsats weero wersh k'ayere. Ernmó nk'ani malalo jabitwosh ngiri malalo ananshde ime. ");
INSERT INTO bwo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ash iko nkito dek'osh geeyar niyatse b́moshal, n kotiyonor b́dek'etwok'o bísh k'ayk'rowe. ");
INSERT INTO bwo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ash iko ‹Taanton kuro kurde ik kilo metrok'o amee,› err neen b́shefiyal, nemon kuro kurde git kilometro bínton amee. ");
INSERT INTO bwo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Niyoke k'onitwosh ime, niyoke gushosh geyirwosh k'aze etk'aye.» ");
INSERT INTO bwo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Manats dabt Iyesus hank'owa bí'eti, « ‹N giyo shune, n balngaro shid'ee› eteetsok'o shishrte. ");
INSERT INTO bwo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Taa it balngarwotsi shunere, iti gishirwotssh Ik'o k'onwere» etirwe. ");
INSERT INTO bwo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Han it k'aliyal, darotse fa'o it nihsh nana'úwotsi wotitute. Bíye gondwotsnat sheengwotssh aawo kishirwee, mank'o kááwwotsnat k'uurwotssh bí awsho butsirwee. ");
INSERT INTO bwo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Iti shunir ashuwots s'uzi it shunal eeg k'awntse it detsi? Morretswots mank'o k'alirunoshna ");
INSERT INTO bwo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","It eshwots s'uzi jamo it aatitka wotiyal eshe aawne bogo it finirwoni? Ik' ash woterawotswor mank'o k'alirunoshna? ");
INSERT INTO bwo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Eshe daritstso it nih s'een b́wottsok'o itwere s'eenwotsi wotoore. ");
INSERT INTO bwo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Dabt Iyesus hank'owa bíet, «Ashuwots taan be'enee err sheeng fino ash shinatse finoniyere it tooko korde'ere, maniyalbakó daritsitso it nihoke eegor k'awntso daatsratste. ");
INSERT INTO bwo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Eshe t'owwotssh n'ímoor, ash shinatse shunewna etiru git alberetswots Ik' k'oni moonat werind weerindatse bo k'alirwok'o be'ewosh k'alk'ayere, arikon itsh keewirwe, booye shin shino bo k'awntso daatsdek'rnee. ");
INSERT INTO bwo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Neemó tewdi doon ni ímoor n k'ani kisho b́ k'alirwo n giri kisho b́danawok'owa. ");
INSERT INTO bwo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Eshe n tewdi doo áátson wotowe, ááshon finetso bek'irwo nnih n sheeng fini k'awntso neesh dashetwe. ");
INSERT INTO bwo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Ik'o it k'onor git alberetswotsk'o wot k'ayere! bo asho boosh b́bek'etwok'owa erŕ Ik' k'oni moonat werind weerindatse need'de Ik' k'ona boshunfoni. Ariko itsh keewirwe, bohe bok'awntso shin shino daatsdek'rnee. ");
INSERT INTO bwo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nee Ik'o nk'onormó, n moots kindde nfengesho ic'de'er ááshon beyirwo nnihi k'onwe, ááshon n k'ontso bek'irwo nnihi k'awntso neesh dashetwe. ");
INSERT INTO bwo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«It Ik'o it k'onor Ik' ash woterawwotskok'o ay ooshiwon keewk'ayere, bo ananshdek' ayoto bo keewtsosh Ik'o bok'ono b́ k'ebetwok'oweya boosh bíariri? ");
INSERT INTO bwo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Itmó it nih itsh geyit keewo bín it k'onfetsere shino b́ dantsotse bokok'o wotk'ayeree. ");
INSERT INTO bwo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Eshe it Ik'o it k'onor hank'o err k'onwere, ‹Darotse beyirwo nonihono! N shúútso mangwee, ");
INSERT INTO bwo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","N mengstu wowiyee, N shuno darotse b́ wottsok'o, Mank'o datsatsno wotowe. ");
INSERT INTO bwo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Noosh geyit misho hambets noosh ime. ");
INSERT INTO bwo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Noowere noon dádtswotssh oorowe noettsok'o Nofints morro noosh orowa eree, ");
INSERT INTO bwo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Gondatse noon kore bako, Fadeyots noon kindshk'aye, mengsto, angonat mangon Dúre dúron nike, Amen.› ");
INSERT INTO bwo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Ashuwots morro boosh orowa it etal, itshowere daritstso it nih itsh orowa etetuwe. ");
INSERT INTO bwo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ashuwots morro oorowe eto it k'azaalmó it morronowere daritstso it nih itsh orowe eraatse.» ");
INSERT INTO bwo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Manats dabt Iyesus hank'owa bíet, «It s'oomor, bo s'oomo ashuwots boosh bodanetwok'o, boshiitso wonawoniru git alberetswotsk'o, it shiitso sholik'ayere, arikon itsh keewirwe, booye bok'awntso dek'wtserne. ");
INSERT INTO bwo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Neemó n s'oomor n shiitso mashde'e, n tokatsowere fuurde'ee, ");
INSERT INTO bwo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mank'oon, eshe n s'oomo ááshon beyirwo nnihiyere okoon k'osho konwor danatse. Ááshon finetso bek'irwo nnihwere n k'awntso neesh dashetwe.» ");
INSERT INTO bwo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ando aani dabt Iyesus hank'owa bíet, «Barariyonat hajoon bot'afitwoke, úmp'etswotswere tishde bo úmpitwoke, datsanatse it tookosh gaalo ko'ik'ayeree. ");
INSERT INTO bwo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Maniyere barariyonat hajif keewwots t'afiyo bofalrawoke, ump'etswotswere tishr boúmp'erawok darots it gaalo ko'iwere. ");
INSERT INTO bwo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","N gaalo b́beeyirwoke n nibonúwere manoknee b́ daatseti. ");
INSERT INTO bwo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Ááwo atsi c'eeshee, manshe niááwo jeena wotiyal, niats jámó sháán wotitwe, ");
INSERT INTO bwo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ni ááwo jeen wotob́k'azalmó, niats jamo t'alwe b́wotiti. Eshe niatse fa'a shááno t'alu b́wotiyal, t'alwo aawk'owe iki b́ gonditik'uuna! ");
INSERT INTO bwo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Ash iko doonz gitosh guuts woto falratse, wee ikoniye b́shit'eti, k'oshonowere b́shuneti, wee ikosh amanek wotitwe, k'oshonowere gac'itwee, mank'o ash iko iknon Ik'onat gizonsh guuts woto falratse. ");
INSERT INTO bwo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Mansh eshe hank'o itsh etirwe, ‹Eege no meeti? Eege no úsheti? Egek'una no tahiti?› Eton it beyi jangosh shiyank'ayere, mishoniyere kasho, tahoniyere atso bowatsáá? ");
INSERT INTO bwo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Aab darotse bidiru kafwotsi s'iilere, bo shohatsnee, k'ec'atsnee, t'iwots gáác'atsnee, ernmó daritstso it nihye boon manziri. Eshe it kafwotsiyere ayidek'at bogftoshnáá? ");
INSERT INTO bwo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ititse kic'ar b́beeyi dúrats ik aaw dabdek'o falitwo kone bíí? ");
INSERT INTO bwo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ando mank'o tahi jangosh eegoshe it kic'iri, shiratsi fundwotsi aawk'o bo eenirwk'o s'iilere, booye finon ayidek't maawratsnee, jokeratsnee, ");
INSERT INTO bwo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","B́mang jamonton Solomonwoŕ dab́ boyitsi ikuk'o taheratse, etirwe itsha. ");
INSERT INTO bwo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Eshe hambets be'eyar yats tawots jwetwo shiratsi tootso, Ik'o hank'o b́ takitkawotiyal, it shapts imnetiyetswotso! itnere bogshde'er aawk'oneya tako b́k'azeti? ");
INSERT INTO bwo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Mansh eshe it ‹Eege nomeeti? Wee, eege noúsheti? Egeek'uwa notahiti?› Erfetsr shiyanon kic'k'ayere. ");
INSERT INTO bwo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Man daatsosho Ik' ash woterawotswor geyirunee, itsh jaman b́geyitwok'o daritstso it nih danfee. ");
INSERT INTO bwo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Itmó, shin shino Ik'i mengstonat kááwo gewoore. Oorts keew jamo itsh dabeetwe. ");
INSERT INTO bwo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yaatso b́tookish kic'itwee, yaatsish kic'k'ayere, aawosh b́gondoo bodfe.» ");
INSERT INTO bwo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Manats dabt́ Iyesus hank'owa bíet, «It atsats angsherawok'o konatsor angshk'ayere, ");
INSERT INTO bwo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","k'oshwotsats it angshtsok'o it atsowere angshetwe, mank'o it tatsts tatsi k'ac'ots itsho tatsetwe. ");
INSERT INTO bwo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ni ááwotse fa'a gindo nbe'aawo ni'eshu ááwitsi kiimo n s'iil eegishe? ");
INSERT INTO bwo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Eshe niááwotse gindo b́befere, ni'eshuush, ‹Aab ni ááwitsi kimman kishuna› nietet ááwk'oneya? ");
INSERT INTO bwo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nee git albertsono, shin niááwotse fa'a gindo kishwe, maniyere il, nieshu ááwotse fa'a kiimo kishosh shengshde bek'etune. ");
INSERT INTO bwo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Woshosh t'ints meets S'ayino kanwotssh imk'ayere, it ink'wo guritswots shinats juuk'ayere, gúritswots itko b́k'awntso shaaw gizon keewets malo botufon boneed'awok'owa, kanwotswere aanar itn shas'etunee. ");
INSERT INTO bwo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«K'onwere itsh imetwe, gewoore daatsitute, fengesho k'ofore itsh k'eshetwe. ");
INSERT INTO bwo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","K'onitu jamo dek'etwe, geyirwonúwere daatsitwe, fengesh k'ofitwoshowere k'eshetwe. ");
INSERT INTO bwo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ititse b́ na'o tusho b́k'onoor shútso imetwo kone? ");
INSERT INTO bwo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Mus'o b́k'onre dawnzo imetwá? ");
INSERT INTO bwo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Eshe it gondwotsi wotefetsat, it nana'úwotssh sheeng keewo imo it daniyakon, bérée, darotse fa'o it nihi bín k'onitwotssh bogshde aawk'owe sheeng keewo imo b́k'azeti! ");
INSERT INTO bwo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Eshe haniyak ashuwots itsh bok'alitwok'o it geyiru jamo itwere boosh mank'o k'alwere, nemonwere, nebiyiwots keewtso danonwere b́ keewirwo haniye. ");
INSERT INTO bwo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Fengesh t'ebún kindúwere, t'afo maants kindshit fengesho gawne, b́ werindonúwere eene. Manmaants kindit ashuwotswere ankatnee. ");
INSERT INTO bwo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kashomaants kindshiru werindonu t'ebee, b́ werindonwere kic'ike, bín daatsit ashuwotswere aynaliye. ");
INSERT INTO bwo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Mereeri gok'o tahde it maants weetwotsatse, bogitsotsnmó biik'ts boditsi Elah wotts kootets nebiyiwotsatse it atso korde'ere, ");
INSERT INTO bwo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bonowere it danet bo fini shuwonee. Angitsi t'ugi atatse weyini shuwo, koshshlatse belesi miti shuwo mec'eetwa? ");
INSERT INTO bwo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mank'o miti sheeng jamo shuwi sheengo shuwitwee, gond mitonwere gond shuwo shuwitwee. ");
INSERT INTO bwo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Miti sheengo gond shuwo shuwosh falratse, gond mitonwere sheeng shuwo shuwosh falratse. ");
INSERT INTO bwo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Sheeng shuwo shuraw mit jamo k'ut'de tawo maants juwetwe. ");
INSERT INTO bwo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mansh eshe, kootets nebiyiwotsi bofini shuwon boon danetute. ");
INSERT INTO bwo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","« ‹Doonzono! Doonzono!› taash etiru jamo daritsi mengstots kindratse, daritsi mengstots kinditwo darotse fa'o t nih shuntso finitwoniyee. ");
INSERT INTO bwo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Angshi aawots ayuwots, ‹Doonzono! Doonzono!! n shútson bek'o keewratsnowa? N shútson fo'erawo kishratsnowa? Nshútson ay adits keewwotsi k'alratsnowa?› Etetune taasha. ");
INSERT INTO bwo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Taawere manots aawots, ‹B́ jamon itn danatse! it gond finirwots tiyatse okaan wokoore!› eteetwe boosha. ");
INSERT INTO bwo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Ti aap'an k'ewde'er finats jitsit jamo b́ moo s'alats agts s'ek ashoni bí ariye ");
INSERT INTO bwo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Awshonú b́butsi, di'onwere b́di'ii, jongonwere jongat maa man b́ gifniy, ernmó, maaman shútsi s'alats bí agetsotse dihratsee. ");
INSERT INTO bwo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ti aap'tsan shisht finats jitsrawonmó b́ moo shiyats agts gik'ets ashoniye bíari. ");
INSERT INTO bwo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Awsho b́butsi, di'o b́ di'i, jongo jongat maaman b́gifnii, moonwere manoor dihbwtsi, b́dih dihonwere dihi gondo b́dhi.» ");
INSERT INTO bwo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iyesus keewanotsi keewt b́ ishtsok'on ashuwots b́ danits danatse tuutson bo'adi. ");
INSERT INTO bwo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Adtswotswere bí bo nem danifwotskok'o b́woterawo aletsok'o b́ daniyrwotsna b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iyesus guri abaatse b́ oot'tsok'on ay ashuwots b́ jafrats botuwi. ");
INSERT INTO bwo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Manoor een shodets ash iko waat b́ gubrats diht «Doonzono! ni eekiyal taan s'ayitso falitune» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iyesuswere b́ kisho jargdek't bín shú'at «Eekitwee, s'ayine!» bí eti. Een shodetsmanwere manoor bí een shodmanatsee s'ayin b́wútsi. ");
INSERT INTO bwo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Maniyere il Iyesus, een shodotse kashtsmansh hank'owa bíet, «Keewan konshor keewk'aye, ernmó nkashtsok'o amr kahniwotssh kitswe, boats gaw b́wotiisha, n kashtsotse Muse b́ azazts wosho Ik'osh t'intswe» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","K'frnahom kitotse Iyesus b́ kindtsok'on, Rom datstso balatsi naasho b́ maants t'int k'onfetst, ");
INSERT INTO bwo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Doonzono, t guutso durutsat ayidek't kic'efetstniye b́ k'eyiri» bí et. ");
INSERT INTO bwo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iyesuswere «Taa waar bín kashiytwee» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Balatse naash wottsonmó hank'o ett bísh bíaaniy, «Doonozono! nee tmoots nikindosh bodk ash taanaliye, b́wotefermó ik aap'u s'uzi keewwe bako, t guutso kashitwe. ");
INSERT INTO bwo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Taahe t tookon altswotssh alek wotefetsat, t shirotse tíaaliru kes' kes'fwotsi detsfe, boyitsi ikosh ‹Amee!› ti etor ametuwe, k'oshonwere ‹Wowe› ti etor weetwe, t guutsonwere ‹Han k'alwe› ti etor k'alitwe» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Han b́ shishtsok'on Iyesus bí adi, b́ shuuts shoydek't sha'iru ashuwotssh hank'o bíeti, «Arikon itsh keewirwe hankok'o bodts een imnetiyo detsts ik ashonor Isra'elitse daatsratse. ");
INSERT INTO bwo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ayuwots aaw keshonat aaw kindon weetúnee, Abrahamnton, Yisehak'nton, Yak'obnton dari mengsti mishi maratse beedek'etúne etirwe itsha. ");
INSERT INTO bwo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mengstaani naatosh boon b́ geyirwotsmó úratse fa'a t'alwotse bojweti. Manoknowere eeponat gash k'aashon wotitwe.» ");
INSERT INTO bwo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Maniyere il bali abaatsi naashmansh Iyesus «Amee! ni amantsok'o neesh wotowe» bí et. Guutsonwere manoori sa'aton kashb́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Maniyere il Iyesus P'et'ros moots b́ kindtsok'owon P'et'ros awu bi'atso k'ees't bíere shodat b́ k'eyirwok'o b́bek'i. ");
INSERT INTO bwo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","B kisho b́ shuu'útsok'on manoor biatsi k'ees'o bín faksh b́k'rere kashbwts, tuwatnwere Iyesussh b́fiini. ");
INSERT INTO bwo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Datsonwere b́ iltsok'on ashuwots Fo'erawwotsn detsets ay shodetswotsi Iyesusmaants dek't boweyi, bíwere b́ nooni aap'on kim shayirwotsi b́ kishi shodets jamwotsnowere b́ kashiyi. ");
INSERT INTO bwo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Man b́k'altsatse tuutson nebiyiyo Isayasn, «Bíhe no kúúno k'aa'úb́dek'i, no shodono kurb́dek'i» bek'on eteetso b́s'eeni. ");
INSERT INTO bwo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ash ayo bín gúrdekt bobefere bek't Iyesus b́ danifwtssh bak'ets bokimetwok'o b́azazi. ");
INSERT INTO bwo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Maniyere hakon nem danifo Iyesusok waat, «Danifono! ni'ametu jamok nshuutso sha'ona» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Iyesuswere, «Waangwots gop'o detsfne, daaratse bidíru kafwots kúto detsfne, ashna'onmó bíts kash b́dek'et beyoko deshatse» ett bíaaniy. ");
INSERT INTO bwo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","B́ danifwotsitse iko «Doonzono! shino amr tnihi duuhr twetwok'o taash eekowe» bí et. ");
INSERT INTO bwo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Iyesuswere «Neehe tshuutso shoy de'er wowe, k'irtswotsiye boko k'irtso duh bodek'etwok'o boon k'ay k'rore» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iyesus jelbots b́kidre, b́danifwots b́jafrats botwi. ");
INSERT INTO bwo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Eegurahi eeno aats k'aratse b́tuutsatse jongi eenman jelbu k'oot'osh bí eti, Iyesusmó manoor k'eya b́k'eyir. ");
INSERT INTO bwo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","B́ daniyfwots Iyesusok t'int «Doonzono! Aage t'afrone, noon fariwe!» ett bín tokrotse bo tuuzi. ");
INSERT INTO bwo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Bíwere «It imnetiyo itsh shaptswotso! eegoshe it shatiri?» bí et. Manyakowere Iyesus tuut jongonat aats k'aaron bíhadi, een s'ik etonu wotb́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ash ashuwotswere adt, «Jongonat aats k'arwots bísh boaleyiruhan aawk'o ashe?» bo et. ");
INSERT INTO bwo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Iyesus Gelil dats aats k'aroniye kimt, Gergesenon datsats b́ waatsok'on Fo'erawo boon b́detsts ash gitwots doowi beyoke kesht bínton gonke bowtsi, ayidek't shatiik boteshtsotse asho konwor man weeron besho falraka b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bowere «Nee, Ik'o naayo! nee nooke eeg kis'e ndetsi? Aawalo noon kic'iyosheya nweyi?» Etfetst bokuhi. ");
INSERT INTO bwo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Boyere muk'i okááne wokat fa'a beyoke gurits s'eeno b́ jinfera b́teshi. ");
INSERT INTO bwo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Fo'erawonwere, «Noon nkishitka wotiyal, oona neesha gurits s'een manmaats noon damiwee» ett bín bok'oni. ");
INSERT INTO bwo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Iyesuswere «Ameree!» bí eti. Mann ashuwotsitse kesht guritswotsits amt bokindi. Gurits jamwotswere gohi gúúratse tengsheyat oot't aats k'arots k'oot'eyt bok'iri. ");
INSERT INTO bwo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Guritswotsi jinirwotswere giifat kitots kindt jam keewo bokeewi, Fo'eraw boon detsts ashuwotsats wotts keewono bokeewi. ");
INSERT INTO bwo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Maniyere il kit manitsi ash jamó Iyesusi bek'osh boweyi, bín bobek'tsok'on bodatsatse keer bíametwok'o bok'oni. ");
INSERT INTO bwo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Maniyere il Iyesus jelbots kinddek't aats k'arotse kimt b́took kitumand b́weyi. ");
INSERT INTO bwo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Manoknowere ashuwots es'ats k'eyiru bíatso lasha'ats ash iko b́maand dek't boweyi. Bíwere bo aman amano bek't, bíatso lashatsosh, «T naayo! kup'owe shenono, n morr jamo neesh orowa eteere» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Manoor nemo danifwotsitse ik ikwots, «Ashaahan Ik'oniye b́ c'ashiri!» ett bonibotse bo gawi. ");
INSERT INTO bwo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Iyesuswere bo gawirwo dank'rat hank'o boosh bíeti, «It nibots eegoshe gond keewo itgawiri? ");
INSERT INTO bwo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","B́wotiyaloru n morro oorowe eteere etonat tuur amee! etotse aaw ketfa? ");
INSERT INTO bwo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ernmó ash na'o datsatse morro k'a'úbazosh alo b́ detstsok'o it danisha» ett biatso lasha'atsosh «Tuur ni'es'o kurde nmoo maants amee» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ashonwere tuut b́moo maants k'az bíami. ");
INSERT INTO bwo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ashuwotswere man bobek'tsok'on bo shati, hank'o bodtso alo ashosh b́ imtsotse Ik'o bo udi. ");
INSERT INTO bwo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Iyesus manoke tuut amoke b́befere Matiwosi eteefo t'ilish dek'eef beyoke b́befere bek't «T shuutso wowe» bíet. Bíwere tuut b́ shuutso b́ ami. ");
INSERT INTO bwo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Maniyere il Iyesus Matiwos mootse mishimaratse b́befere t'ilish ko'if aywotsnat morretswotsn man maants waat bínat b́ danifwotsnton mishimaratse beebodek'i. ");
INSERT INTO bwo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ferisawino eteefwotswere man bek't «It danifo eegoshe t'ilish ko'ifwotsnat morretswotsnton towat b́meyiri?» bo et. ");
INSERT INTO bwo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iyesuswere man shisht hank'o ett boosh bíaaniy, «Shoodetswotssha bako jeenwotssh atetso geyiratse. ");
INSERT INTO bwo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ameree ‹Taa t geyirwo mhretiya bako woshaliye› ett guut'etso eeg b́wottsok'o p'ec'ar t'iwintsde'ere. Taa twaa kááwwotssh b́woterawo morretswotssh orowe eto bodaatsitwok'o boon s'eegoshe» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Manoor, Yohans danifwots Iyesusok waat «Noonat ferisawino eteyirwotsn jam aawo s'oomere nos'omiri, n danifwotsmo eegoshe s'oomo bok'azi?» ett bín boaati. ");
INSERT INTO bwo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Bíwere hank'o ett boosh bíaaniy, «Guuyo bonton b́befere guuy deentswots shiyano boon geyifá? Ernmó guuyo booke b́dek'eet aawo weetwe, manoor s'oomitunee. ");
INSERT INTO bwo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Natts tahats bút'i handro shipetwo konwor aaliye, b́shipalmó bút'i handrman tahi dorman kushide'er b́ gaad'o iki gawintsitwee. ");
INSERT INTO bwo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Mank'o aats arwi natots weyini biri handro gáás'etwo konwor aaliye, man k'aleyalmó, aruman t'uu'niye b́wutsiti, weyini bírmanmó kuud'itwee, arwonwere awaashar finats jinaniyere b́ ooriti. Ernmó handr weyini bíro handr arwots gáás'o geyife, mank'oon gitetswots jeenon beetúne.» ");
INSERT INTO bwo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iyesus man boosh keewoke b́befere, naash iko b́ maants waat, b́ baronowere Iyesus shinats gup'gup'at́, «Hamb t na'ú k'irwtseranee, ernmó nee waar n kisho bíats ngedal kashitwanee» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iyesuswere tuut ashman shuutso shoydek't bí ami. B́danifwotswere b́shuutso shoydek't boami. ");
INSERT INTO bwo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Manoke, tatse git nat s'eenosh b s'atso kud'at need'o b́k'aye kic'iru mááts iku fa'a bteshi, manoor Iyesus shutsatse b́ tahi jilo bkishon b dets. ");
INSERT INTO bwo_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Man bk'alwere «B́taho s'uzi dab t t'awiyal kashitwe» etaat b nibotse gawat bteshtsotsna. ");
INSERT INTO bwo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Iyesuswere wongr et aanat bin b́ s'iiliyakon «Kup'owe t ni'e! n imnetiyo neen kashire» bíet. Máátsnwere manoor kash bgutsi. ");
INSERT INTO bwo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Maniyere il Iyesus naasho mook b́bodtsok'on shiyani gaato fugfwotsnat hakebak jod'efetst eepiru ashuwotsi b́bek'i. ");
INSERT INTO bwo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Bíwere «It únets hanoke ameree! na'ú tokra btokriri bako k'irratsane!» bíet. Boomó b́keewo aatsnit bí'ats bomiis'. ");
INSERT INTO bwo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ashuwots bokeshihakon, Iyesus na'ú bbeyiru maa kayots kindt b kisho b́dets, biwere btuwi. ");
INSERT INTO bwo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Keewman een b́wottsok'o gúúrmanatse shishe b́wutsi. ");
INSERT INTO bwo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Manoke tuut bíamfere Iyesusi shoydek't aaw dog gitwots bo tuu, boowere «Dawit naayo! oona neesha noosh maac'o k'ewowe!» et fetst bokuhefere botesh. ");
INSERT INTO bwo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Moots b́ kindtsok'on Iyesusok t'iin bodek'i, bíwere «Taa man k'alo tfalitwok'o amaniruteya?» bíet. Bowere «Ee, doonzono!» ett boaaniy. ");
INSERT INTO bwo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Maniyere il Iyesus bo ááwwotsi b́ kishon b́ shuu'ihakon, «It amantsok'o itsh wotowe!» bí et. ");
INSERT INTO bwo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Bo ááwonwere k'eshe b́wutsi, Iyesuswere «Keewan konshor keewk'ayere!» ett kup'idek't boosh b́ keewi. ");
INSERT INTO bwo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Boomó amt́ gúúrmanatse Iyesus shúútsi eeni jango bokeewi. ");
INSERT INTO bwo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bo ááw k'eshets ashuwots kesht boamtsok'on ash k'oshwots Fo'erawo bíatsotse s'eentso ash gidik' iko Iyesus maants dek't bowaa. ");
INSERT INTO bwo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Fo'erawonwere b́ gitsotse b́ keshtsok'on ash gidik'o noonkeewo dek't b́tuwi, ash ashonwere «Isra'elitse hank'o keewo b́ jamon be'e danake!» ett bo adi. ");
INSERT INTO bwo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ferisawino eteefwotsmó «Bíyere Fo'erawo b́ kishir Fo'erawwots naashonee» bo et. ");
INSERT INTO bwo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iyesuswere bo Ayhudi Ik' k'oni mootse danifetst, Ik'i mengsti doo shishiyo nabfetst, ashuwotsi shodonat atswesh jamotse kashifetst, kitonat gal jamotse bíananefoni. ");
INSERT INTO bwo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ash ashonmó jints deshaw mereerwotskok'o kic'efetst dáándat bobefere b́bek'tsok'on boosh maac'o b́k'ewi. ");
INSERT INTO bwo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mansh b́danifwotssh hank'o bíet «Mááyo kakwetwo aye, mááy katsman kakwitwotsmó aynaliye. ");
INSERT INTO bwo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Eshe fintswotsi mááy kakwok b́ woshitwok'o mááyi katso doonzi k'onwere.» ");
INSERT INTO bwo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iyesus tatse git b́ danifwotsi bíyok s'eegdek't, kim shayiro bokishitwok'o, shodonat kúúni shod jamon bokashitwok'o alo boosh b́ ími. ");
INSERT INTO bwo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tatse git wosheetsots shútsonwere hank'oyi, shin shinon P'et'rosi eteetso Sim'onnat bí eshu Indriyasi, Zebdiwos nana'uwots Yak'obnat Yohansn, ");
INSERT INTO bwo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip'os, Bert'elemiyos, Tomasi, t'ilish dek'fo Matiwosi, Ilfyos naay Yak'ob, Tadiwos ");
INSERT INTO bwo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Okooretso Sim'oni, Iyesusi beshidek't imtso Keriyot asho Yihudi. ");
INSERT INTO bwo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iyesus tatse gitwotsi, hank'o ett boon b́woshi, «Ik' ash woterawwotsok amk'ayere, Semari dats ashuwots kitotso kindk'ayere, ");
INSERT INTO bwo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Maniyere mereerikok'o t'afts Isra'el ashuwotsok ameree. ");
INSERT INTO bwo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Amrnwere ‹Dari mengstuuniye karnraniyee!› err nabúwere. ");
INSERT INTO bwo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Shodetswotsi kashiwere, k'irtswotsi tuuzwere, een shodetswotsi s'ayintsworee, Fo'erawwotsi kishwere, beenon it dek'tso beenon imere. ");
INSERT INTO bwo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Awntso wee ambaro wee k'áázo it borsots deshdek'k'ayre. ");
INSERT INTO bwo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Fintsosh b́ misho daatso bísh b́ geyitsotse it weerindatse k'arc'ito, git kito, gitl c'amono, gumbonowere de'amk'ayere. ");
INSERT INTO bwo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Bíts itkindts kitotse, wee gálútse, itn dek'et asho koni b́woto t'iwintsde dande'ere, manokman fakshr it keshfetsosh bíyoke teyere. ");
INSERT INTO bwo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ash moots it kindor jamo aatwere, ");
INSERT INTO bwo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Maa man it jeenosh b́wotititka wotiyal jeeno itoktso bísh boree, wotitkali wotiyalmó itoktso jeeno itsh aanowe. ");
INSERT INTO bwo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Asho konwor itide'awo wee it aap'tso k'ebo b́ k'azetka wotiyal gal man wee kit man k'ay it keshor it tufatsi k'undo teboree. ");
INSERT INTO bwo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Arikoniye itsh t keewiri, angshi aawots kit maniyere Sedomnat Gemor ashuwotsi fayet fayo ketefee. ");
INSERT INTO bwo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Hambe! mereerikok'o elahi taalotse iti twoshiri, mansh dawnzikok'o s'ekwotsi, erkndikok'o dingatwotsi wotoore. ");
INSERT INTO bwo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ashuwots angshosh jebats beshide itn imetune, ayhudiyots Ik' k'oni mootse iti jot'etune mansh ashuwotsatse itatso korde'ere. ");
INSERT INTO bwo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","T jangosh itn dats k'eezirwtsonat, naashwotsoko it aats angshetwok'o itin de'ameyor bonat Ik' ash woterawwots shinatse t jangosh gawitwotsi wotitute, ");
INSERT INTO bwo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mooshi jebats itn bot'intsor, it keewitwo manoori sa'atmann itsh imetwotse, ‹Aawuk'o k'alrniya, egek'una nokewiti?› err shiyanon kic'k'ayere. ");
INSERT INTO bwo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","It gitsotse bede keewitwo it nih daritstso shayironi bako itnaliye. ");
INSERT INTO bwo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Asho b́took eshwo k'irosh beshide imetwe, mank'o nihonúwere b́ took na'o k'irosh beshide imetwe, na'naonwere bo indnihwotsats balngar wotar tuwitúne, k'iroshowere boon beshide imetune. ");
INSERT INTO bwo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","T jangatse ash jamoke shit'eek wotitute, ernmó b́s'uwats b́borfetso kup'de'er ned'itwo kashitwe. ");
INSERT INTO bwo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kit ikutse gondbek'o itats bo ayiwor kit k'oshuts k'ay woc'ere, arikon itsh etirwe, ash na'o aanar b́waafetsosh Isra'el kit jametswotsi gúrar betsatste. ");
INSERT INTO bwo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Danirwo bín danifoniyere bowatse, guutsonwere b́ doonziyere bowatse. ");
INSERT INTO bwo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mansh danirwo bín danifokok'o, guutsonwere b́ doonzkok'o b́ bodal bísh bodfe. Moo doonzi ‹Beel Zebuliye› err bos'egiyakon b́ maa ashuwotsnmá maniyere bog gond shútson aawk'owe s'eego bok'azeti! ");
INSERT INTO bwo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Haniyak ashuwotsi shatk'ayere, ipetso b́ be'erawo ooritwo, ááshtsonwere b́daneraniye ooritwo eegor aaliye. ");
INSERT INTO bwo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Eshe taa t'alwotse itsh tkeewirwo, it sháánatse keewwere, shashikon it shishtso dambaan tuuts beyok waaŕ sháánatse daniwere. ");
INSERT INTO bwo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Meets úd'oniyere beshar kash úd'o falraw ashuwotsi shatk'ayere, maniyere kashonat meetson gahanem tawots juwo falitu Ik'o sharere. ");
INSERT INTO bwo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Dimbiti gitwots santim múk'wotsn kemefoshná? Wotowa eree, daritstso it nih bí eekerawon, dimbiti ikú datsatse fed'arr ooreratsanee. ");
INSERT INTO bwo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","It konmo dab it took s'ironwor taawekee. ");
INSERT INTO bwo_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Eshe it dimbiti aywotsiyere bogts k'awntsetswotsi itwottsotse b́ jamon shatk'ayere. ");
INSERT INTO bwo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Ash shinatse tjangosh gaw wotitu jametswotssh, taawere darotse fa'o tnih shinatse bísh gaw wotitwe. ");
INSERT INTO bwo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ash shinatse taan haalitu jamwotsi taawere darotstso tnih shinatse haalitwee. ");
INSERT INTO bwo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Taa twaa, jeeno datsats doosh ark'aye itsha, taa kes'a bako jeeno dek'waratsee. ");
INSERT INTO bwo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Taa twaa, nungush na'o b́ nihats, mááts na'ú bi indats, naayo máátsu bi awats, k'alewo tuzishee. ");
INSERT INTO bwo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mansh ashosh balangarwots b́ took maa ashuwotsiye bowotiti. ");
INSERT INTO bwo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Taayere bogo b́ indi wee b́nihi shunetwo, tik wotosh falratse, taayere bogo b́ nungush na'onat b́ máátsna'ú shunetwo tik woto falratse. ");
INSERT INTO bwo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","B́ took mask'aliyo kurde tshuutso sha'erawo asho tik woto falratse. ");
INSERT INTO bwo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","B́ kashu kashiyosh geyiru jamo bin t'afitwe, b́ kashu t jangosh t'afitu jamonmó bin kashitwe. ");
INSERT INTO bwo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Itn dek'etwo taan deketwe, taano dek'etwo taan woshtso Aabi dek'etwe. ");
INSERT INTO bwo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nebiyiyo nebiyi shútson dek'etwo nebiyi k'awntso daatsitwe, kááwo kááwi shútson dek'etwo kááwi k'awntso daatsitwe. ");
INSERT INTO bwo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Arikoniye itsh tietiri, t danif b́wottsatse tuutson, múk'anotsitse ikosh aats ak'o ik brc'k'o dab imetu asho b́ k'awntso t'ud'atsee.» ");
INSERT INTO bwo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iyesus tzazihanotsi b́ danif tatse gitwotssh b́ imihakon manoki beyok man k'azk'rat bíyok karnts kitwotsitse nabonat daniyosh bíami. ");
INSERT INTO bwo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Gupfo Yohans tipi mootse b́ befere, Krstos fino b́shishtsotse b́ danif k'atswotsi woshat, ");
INSERT INTO bwo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«Weetwe eteetso neenemó? K'osho koronó?» err Iyesusi bo aatitwok'o b́woshi. ");
INSERT INTO bwo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Iyesuswere hank'o ett boosh bíaaniy, «Amr it bek'tsonat it shishts jamo Yohanssh keewwere. ");
INSERT INTO bwo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Hambe! dogwots bek'irunee, shokltswots káwdek't sha'irune, een shodetswots s'ayinirune, waazdoogwots shishirune, k'irtswots tuwirune, t'owwtssh doo shishiyo nabeyirwee, ");
INSERT INTO bwo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","T jangosh t'arat'arerawo deereke.» ");
INSERT INTO bwo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yohans woshtswots bo amiyakon, Iyesus Yohans jango hank'o ett ashuwotssh keewo dek't b́tuu, «Aab eeg s'iiloshe woorwomants keshat it weyi? Jongi giwshirw elto s'iilisheya? ");
INSERT INTO bwo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Andoor eeg bek'ishe kesh itweyi? Sheeng tah tahdek'ts asho s'iilisheya? Sheeng tah tahtswotsiyere naash naashi mootsne bo fa'oni. ");
INSERT INTO bwo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Eshe, eegoshe it keshi? Nebiyo bek'isheya? Ee, dab nebiyiwoniyere ayidek't bogo bek'ishe etirwe itsha. ");
INSERT INTO bwo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Bíye ‹Hambe, n shin shinatse sha'arr, n weerindo k'anitwo t woshtso n shinats woshitwe› ett guut'etsok'one. ");
INSERT INTO bwo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Arikon itsh etirwe, máátswots boshuuts ashotse gupfo Yohansiyere bogo tuuratse, ernmó dari mengstotse ayidek't muk'efo bíyere bogfe. ");
INSERT INTO bwo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Gupfo Yohans dúúrtson tuut hambetsish b́borfetso dari mengstu ayidek'atniye biingifniyeyiri, kup'shde maak'oritwotsmó bin daatsitune. ");
INSERT INTO bwo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","«Nebiyi jamwots boimts danonat Muse kishatse imets nemo gupfo Yohansok b́borfetso bek'on keewrnee. ");
INSERT INTO bwo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Eshe bo bokeewtso dek'osh ekitute wotiyal, weetwe eteetso Eliyas hambe, bíhe Yohansiye. ");
INSERT INTO bwo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","K'ebet waaz detstso k'ewe! ");
INSERT INTO bwo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Ernmó dúranatsi ashuwotsi egontoniya arede t s'ileti k'úúna? Shiratse bedek't botohwotsi s'eegfetst, ");
INSERT INTO bwo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹Turaro itsh fugronee duuwatste! no jawernowere epo k'azrtee!› etiru nana'úwotsiye boariyee. ");
INSERT INTO bwo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mank'o gupfo Yohans b́woor mááyo b́marwonat woyini bíro b́úyawo b́waare, ‹Hanwo Fo'erawoniye bíatsotse fa'oni!› bísh boeti. ");
INSERT INTO bwo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ash na'o ando mafetst, úshfetst b́waare, ‹Hanwo! jaaletsonat weyini ushkee, t'ilsh ko'ifuuwotsnat morretswots kod'i ashe!› boeti. Wotowa bako dani telefu arik bwoto b́danet b finone.» ");
INSERT INTO bwo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Manats dabt Iyesus k'osh kitwotsiyere bogo ay adits keewwotsi b́ fints kitwots, naandrone boerawotse hank'o ett wok'aso dek't b́tuwi, ");
INSERT INTO bwo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Indowe neesha Korazine! Indowe neesha Betesayide! ititse k'aleets aditswots, T'irositsnat Sidon kitwotsitse k'alere wotink'ere manoke beyat teshts ashuwots shiyani taho tahde'er tulo boats buh de'er yoots naandrone etank'ne b́teshi! ");
INSERT INTO bwo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mansh eshe angshi aawots, itiyere T'irosnat Sidonitse teshtswotsko fayo ketitwe etirwe. ");
INSERT INTO bwo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Neewere K'frnahome!, darots n borfetso dambaan tuwo geefiya? Si'olits oot'etune! n gitsotse k'aleets aditsanotsi, Sidonitse k'alere wotink'ere kitman b t'afrawon hambetsish beyank'aniye bteshi! ");
INSERT INTO bwo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ari keewhanatse tuutsone neesh tkeewiri, angshi aawots Sedomi fayet fayo neen fayetwoniyere ketefee!» ");
INSERT INTO bwo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Manoor Iyesus hank'owa bíet «Daronat datsonsh doonzo nihono! keewan dantswotsnat t'iwintsitwotssh aatsat danawwotssh n kitstsotse neen udere, ");
INSERT INTO bwo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ee! nihono! han k'alo n shuno wotere. ");
INSERT INTO bwo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tnih jamkeewo taash imre, nihoniyere okoon naayo dantso konwor aaliye. Mank'o naayo niyere okoon niho dantso konwor aaliye, naayo b́kitsiyalabako konúwor niho dano falratse. ");
INSERT INTO bwo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«It angifinon maawtswotso! kuronweree itats b́mangts jamwots t maants woore! taawere kashdek'o itsh imetwe. ");
INSERT INTO bwo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","T k'ambariyo itats kurde'eree, tiatsnowere s'iilr dande'ere, taa dingatonat ttooko dashan detsk taane, it kashush kashdek'o daatsitute. ");
INSERT INTO bwo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","T k'ambaryonúwere kic'iratse, t kuronweree ketee.» ");
INSERT INTO bwo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Iyesus manoori sanbati aawon sndeyi taari taalotsna b́beshefere b́tesh, b́ danifwots k'ak'wtsat boteshtsotse sndeyi motso k'ut'dek't moo dek't botuwi. ");
INSERT INTO bwo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ferisawino eteefwots man bek't Iyesussh, «S'iile! n danifwots sanbati aawon k'alk'ayere eteetso bo k'aliri!» boeti. ");
INSERT INTO bwo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Iyesuswere boosh hank'o bíet, «Dawitnat bínton teshts ashuwots k'ak'at boteshor Dawit b́ k'altso b́jamon nababeratsteya? ");
INSERT INTO bwo_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Bí Ik'o moots kindt kahniwotsiyere okoon bín wotowa bínton teshtswotsi wotowa bomarawok'o nemon baziyetso, S'ayin tusho b́meyi. ");
INSERT INTO bwo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ando kahniwots sanbati aawon Ik' mootse finefetsr sanbati niwo bokimshor naand wotar boats b́tawerawok'o Muse weeron imetso nemotse guut'etso nababeratsteya? ");
INSERT INTO bwo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","S'uznmó Ik' mooniyere bogo hambe! hanoke b́fa'oni etirwe itsha. ");
INSERT INTO bwo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ando aani ‹Taa t geyirwo mhretiya bako woshaliyee› etiru mas'aafi keewirwo eeg b́ wottsok'o it t'iwintsink'ere morro deshaw ashuwotsats angshrawnk'tee b́teshi. ");
INSERT INTO bwo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ash na'o dab sanbatoshor doonze.» ");
INSERT INTO bwo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Beyok manoke tuut Iyesus ayhudi Ik' k'oni moots b́ kindi, ");
INSERT INTO bwo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Manoknowere b́kish iko lasha'ats ash iko fa'e b́tesh, Iyesusi bín bodetset keewo geyiru ik ik ashuwots, «Sanbati aawots shodtswotsi kashiyo nemotse fa'a?» eton bo'aati. ");
INSERT INTO bwo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Iyesuswere hank'o boosh bíet, «Ititse mereer iko detstso, b́ mereero sanbati aawots gop'ots b́shirotse b́fed'iyal geetsde kishrawo kone? ");
INSERT INTO bwo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Eshe, asho mereeroniyere aawk'owe bog k'awntsetsi woto b́k'azeti! Manshe sanbati aawon sheeng keewo fino baziyekaliye.» ");
INSERT INTO bwo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Maniyere il Iyesus b́kish lasha'ats ashosh, «N kisho jargwe» bí'et. Bíwere b́ jargree b́kisho kashwtsat ari b́ kish jeenok'o wotb́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ferisawino eteefwotsmó, manoke kesht Iyesusi aawk'o k'alde'er boúd'itwok'o shiyeyo dek'botuwi. ");
INSERT INTO bwo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Iyesusmó bo t'awi gondo dank'rat beyokmanoke k'azb́tuwi, ay ashuwotswere b́ shuutso shoydek't boami, shodts jamwotsnowere b́ kashiyi. ");
INSERT INTO bwo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ash ashuwotsshmó b́ jango konshor bokeewrawok'o kup'sh dek't bíazazi, ");
INSERT INTO bwo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Han b́wotwere nebiywo Isayasn bek'on keewetso b́s'eenishe. ");
INSERT INTO bwo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Hambe! galtdek'tso tguutsoni! Bíye taa tshnfonat bín tgeneeúwitwoniyee, T shayiro bíats beezitwe, Bíwere kááwts angsho ashuwotssh kuh keewitwe. ");
INSERT INTO bwo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Bí mooyatsee, wee kúheratse, Weer weeratsnowere b́ k'ááro shishetwo aaliye, ");
INSERT INTO bwo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Bí k'is'ets eltono dab tishatsee, S'úwiru gagi c'eeshonor takratsee, Man b́k'alirwere kááwts angsho da'a b́dek'fetsoshe. ");
INSERT INTO bwo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ik' ashwotera ashuwots bín jangitúne.» ");
INSERT INTO bwo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Maniyere il shed'ano bín s'eents ash iko ááwu dogonat gidik'o Iyesusok dek't boweyi, bíwere bín b́kashi, ashmanwere bek'onat noon keewon b́ fali. ");
INSERT INTO bwo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ash jamo adt, «Han Dawit naayi wotifa k'úúna?» boeti. ");
INSERT INTO bwo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ferisawino eteefwotsmó man boshishtsok'on «bí ‹Beel Zebuli› eteets Shed'ani naashona bako Sheed'no kishratsee» boeti. ");
INSERT INTO bwo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ieyesuswere bo asaabiyo dank'rat boosh hank'o bíet «Ik mengesto kayeyarr bí atsatsewo b́gawetka wotiyal mengst man dihe b́dihiti. Mank'o kit iko wee ik maa asho bíatsatsewo b́ k'aleyal kup'arr beyo falratse. ");
INSERT INTO bwo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Shed'anonwere Shed'ano b́kishitka wotiyal bíatsatsewo k'alere etee, eshe, b́ mengsto aawk'oneya kup'arr beyo b́faliti! ");
INSERT INTO bwo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Eshe, taa fo'erawotsi t kishir Beelzebulna wotiyal, it nanaonmó eegoneya bokishiri? Manshe it nana'uwots itats angshitune. ");
INSERT INTO bwo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Taa fo'erawo tkishir Ik'i shayrona wotiyal eshe Ik'i mengstu itmaants waarane etee. ");
INSERT INTO bwo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ando ash iko shino kúp'o b́tifawo kúp'man moots kindr b́ detstso biik'o aawk'o k'alrniya b́faliti. ");
INSERT INTO bwo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Taanton woteraw jamó taank'eefitkee, taanton kakurawo bad'iye b́bad'iri. ");
INSERT INTO bwo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mansh asho aawnari morro b́finitwosh wee c'ash jamosh oorowe eto daatsitwe etirwe itsha, S'ayin shayiro c'ashetu jamoshmó b́ morro bísh oorowe eteeratse. ");
INSERT INTO bwo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ash na'o c'ashetu jamo b́ morro bísh oorowe eto daatsitwe. S'ayin shayiro c'ashetu jamonmó datsanatse wotowa weet datsatse b́ morro bísh oorowe eteeratse. ");
INSERT INTO bwo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Mit jamo b́ shuwon b́ danefotse miti sheengo detso itsh geyife, b́ shuwonwere sheeng wotitwe, mito gond b́wotiyalmó b́ shuwonwere gonde b́wotefoni. ");
INSERT INTO bwo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","It dawnzi nana'otso! gondwotsi wotefetsat sheeng keewo keewosh awuk'o k'alrniya it faliti? Asho b́ nonotse b́ keewirwo b́ nibotse s'eent oortsoniye. ");
INSERT INTO bwo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","«Ash sheengo b́ nibi sheengotse s'eents sheeng keewo kishitwe, gond ashonwere b́ nibi gondotse s'eents gond keewo kishitwe. ");
INSERT INTO bwo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ariko itsh keewirwe, ashuwots kaashk'on bokeewiru aap' ik ikosh angshi aawots boon aatetwee. ");
INSERT INTO bwo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ni aap'tsatse tuutson neesh angshetwe, n aap'ts aap'atse tuutson ni'ats angshetwe.» ");
INSERT INTO bwo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Manoor nem danif ik ikwotsnat ferisawino etefwotsn Iyesussh, «Danifono! adits milikito n finere bek'osh geefone!» bo et. ");
INSERT INTO bwo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Wotowa bako hank'o ettni boosh bíaaniy «Gondonat amaneraw s'oot'o adits milikito bek'o geefe, wotowa eree nebiyiwo Yonas dúri adits milikitoniyere okoon k'osho adits milikito imeratse. ");
INSERT INTO bwo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yonas mus'i eeno maac'otse keez aawonat keez t'úwon b́ beshiyitsok'o, mank'o ash na'o dowootse keez aawonat keez t'úwon beshiyitwe. ");
INSERT INTO bwo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nenewe kitutsi ashuwots angshi aawots and dúranatse s'oot'anotsnton tuur bíyats angshitunee, Nenewe ashuwots Yonas nabtso bo shishor bo morrosh goynat naandrone etrne. Andmó Yonasiyere bogo hanoke fa'e. ");
INSERT INTO bwo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Múúrtsu naashú Solomon dani teleefo k'ebosh dats daaratse b́watsotse angshi aawots andi dúri s'oot'anotsnton tuur bo atsats angshitwaniyee, andmó Solomoniyere bogo hanoke fa'ee.» ");
INSERT INTO bwo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Haniye il Iyesus hank'owa bí'et, «Kim shayiro ash atsotse b́keshor kash b́dek'etwoko geyaarr aats aaloke shuuk' beyok b́gúúriti. Wotowa eré daatsratse, ");
INSERT INTO bwo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Mansh ‹T keshts moots aanarr amna› bíetet. Aanarr b́woorowere, b́ maaman baash wotaarr, s'ayinr, k'anwtsarr b́befere daatsitwe. ");
INSERT INTO bwo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Maniye okoon, kim shayiro amr bíyere gondts k'osh shawat Fo'erawwotsi de'er b́weti. Bowere shin Fo'erawman maa teshts asho atsotse kindde'e towaar bítse bobeti. Mansh ashman beyo baltsoniyere iltso iki gonde b́woiti. Gond dúranatsi s'oot'anotsats bodetuwonwere han arts keewe.» ");
INSERT INTO bwo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iyesus ash ashosh keewoke b́befere, bíndnat bí eshwotsn bínton keeweyo geyat́ úratse bo need'efere botesh.  ");
INSERT INTO bwo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Manoke teshts ashuwotsitse iko Iyesussh, «Hamb nindnat ni eshwotsn neen keewiyosh geeyatniye úratse boned'iri.» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Wotowa bako Iyesus «Tind kone? Ti eshwots konotsne?» ett bísh bí aaniy. ");
INSERT INTO bwo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Maniyere il b́danifwots maants kisho jargdek't kitsfetst hank'o bíet, «Tindnat tieshwots hamb, hanotsiye, ");
INSERT INTO bwo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Darotse fa'o tnih shuntso k'alitu jamwots tíeshuu, t mishu, tindu bonee.» ");
INSERT INTO bwo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Manots aawots Iyesus mootse kesht aats k'ari ganoke be b́dek'i, ");
INSERT INTO bwo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Asho ayat b́maants waat kakuwe b́wtsere bí jelbu ats keshdek't be b́dek'i, ash jamonwere, aats k'ari gúúratse need'dek'tni boteshi. ");
INSERT INTO bwo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Maniyere il ay keewo jewron hank'o ett keewo dek't b́tuwi, «Hambe! Goshts iko shook shookosh b́ keshi. ");
INSERT INTO bwo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","B́shookoro shook ik iko werindats b́ fed'ere kafwots waat bomeyi. ");
INSERT INTO bwo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","K'osh shookonwere shawi aalok dats t'orats fed'b́wtsi, datsmanatsowere shawi ayo bíaaltsotse dashan wokeratse b́tesh, mansh shookman manoor bos'b́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Wotowa eree aawo b́keshtsok'own shoolb́wtsi, s'ap'onowere b́ deshawotse shuuk' b́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","K'osh shookonúwere angitsi t'ugi taalots fe'd'bwtsi, angitsi t'ugmanotswere eent́ maayi bos' man guuk'dek't ooribok'ri. ");
INSERT INTO bwo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","K'osh shookonwere datsi sheengatse fed'at bos't ay shuwo b́ shuwi, iko balo, iko keez úbo, ikonwere shaash shuwo b́'imi. ");
INSERT INTO bwo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Shishet waaz detstso shiye!» ");
INSERT INTO bwo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Maniyere il b́ danifwots Iyesus maants t'int «Eegoshe nee ash ashosh jewron n keewiri?» bo eti. ");
INSERT INTO bwo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Bíwere hank'o ett boosh bíaaniy, «Itsh dari mengstotse aashts keewo dano imere, booshmó imeratse. ");
INSERT INTO bwo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Detsts ashosh iki boge imeti, bíshowere ayituwe, deshawatsnmó dab b́detstsonor boatse k'aa'úni dek'etiye. ");
INSERT INTO bwo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Be'efetsr be'awok'o, shishfetst shiyawok'o bowottsotse wee bot'iwintsrawotse hambe taa jewron boosh keewirwe. ");
INSERT INTO bwo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Mansh nebiyiwo Isayasn hank'o ett guut'etso boatse b́ s'eeneti, ‹Shishonó shishirútee, ernmó nibn de'atste, Bek'ono bek'etute, ernmó t'iwintsratste, ");
INSERT INTO bwo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ashaanots nibo dungutseree, bo waazo is'eewtseree, bo ááwonwere ship'r wtseree, mank'o woto b́k'azink'ere, bo ááwon s'iilr, bowaazonowere k'ewde'er, bonibono t'iwintsde'er, tmaants boanere boon tkashyank'oni b́teshi.› ");
INSERT INTO bwo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Eeŕnmó it ááwwots bo bek'irwotse, it waazwotswere boshishirwotse derekne. ");
INSERT INTO bwo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Arikon itsh keewirwe, nebiy aywotsnat kááwwotsn it itbek'irwan bek'o tewntniye boteshi, ernmó be'atsnee, it itshishirwanor shishosh tewntni boteshi, ernmó shiyatsne. ");
INSERT INTO bwo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Eshe it shookirwon ariyetso eeg b́wottsok'owo k'ewere, ");
INSERT INTO bwo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Weerindi gúúrats fed'ts shooko b́kitsir, Ik'i mengsti aap'o shisht t'iwintsraw ashoniye, manoor Shed'ano waarr b́nibotse shookets keewo k'aa'úb́dek'eti, ");
INSERT INTO bwo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Dats t'orats shooketso b́kitsir, Ik' aap'tso manoor b́shishor genee'uwon dek'et ashoni. ");
INSERT INTO bwo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ernmó manoorisha bako b́ nibotse s'ap'o geeratse, mansh Ik'i aap'atse tuutson gond bek'o wee gishewo bí ats b́bodtsok'on káárni b́dihiti. ");
INSERT INTO bwo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Angitsi t'ugi taalotse shooketso b́kitsir, Ik'i aap'o k'ebiru ashoniye, ernmó datsanatsi hasabiyonat gaal shuno b́nibots kindr Ik'i aap'o b́gúk'etwotse shuwalke b́ ooriti. ");
INSERT INTO bwo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Sheeng datsats shooketso b́ kitsirwo, Ik'i aap'o t'iwintsdek't k'ebdek'ts ashuwotsiye, man shuwo shuwitwee, iko balo, iko keez úbo, iko shaash shuwo imetwe.» ");
INSERT INTO bwo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Mank'o Iyesus hank'o ett k'osh jewro boosh b́ keewi, «Dari mengstú b́ goshi taalots sheeng shook shookts ashoniye biari, ");
INSERT INTO bwo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ernmó ash jamo b́k'eyihakon t'elato waat sndewots k'ero shook k'rat k'azbíami. ");
INSERT INTO bwo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Sndeyo eent́ b́shuwor k'ero manoor be'eb́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Mann taarman doonz guutswots b́ maants t'int ‹Doonzono! n tarotse shooki sheengo shokat teyatsiya? k'ero eewkneya b́ weyi?› boet. ");
INSERT INTO bwo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Bíwere ‹Han k'altso balangaroniyee› bíet. B́ guutswotswere, ‹Beree amr k'ero nowaat'etwok'o geefiya?› boet. ");
INSERT INTO bwo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Bímó hank'o ett boosh bíaaniy ‹Woteratse k'ero it waat'oor sndewo bínton wat'etute. ");
INSERT INTO bwo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Manshe k'ayk'rore, maay kakuwo b́borfetsosh sndewonat k'eron towaar eenne, maay kakuwo b́bodor k'es'irwotssh k'ero shino wad'eree, tawotse b́mis'etwok'owere jil jilon tiferee, sndewonmó kakude'er t t'iwots gac'eree› etetuwe.» ");
INSERT INTO bwo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iyesus manatsdabt k'osh jewro hank'o ett boosh b́keewi, «Ik'i mengstu ash iko dek'amt b́ tarots b́ shookts snafic' aaw arefaniye. ");
INSERT INTO bwo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Bihe shook jamotse muk'úniye bíeenormó mit jamoniyere bogfaniyee, mit eenonowere wotitwanee, kafwotswere waarr b jaabats kúto aade'er beetúne.» ");
INSERT INTO bwo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Andoor dabt aryidek't b́keewi, «Dari mengstu mááts ikú keez tatsi k'ac'on s'eents buudonton b bad'its boot' shashniye bíari, boot' shash man boot' jamo b́ shashetwok'o b́ k'ali.» ");
INSERT INTO bwo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iyesus jam keewanotsi jewron ashuwotssh b́keewi, jewralonowere eegor keewratse. ");
INSERT INTO bwo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Man b́wotirwere nebiyiwon hank'o et guut'etso b́s'eenetwok'owe, «T keewo jewron aap'etwee, Datsan bi'azeeron tuut aashat beyirwo keewitwe.» ");
INSERT INTO bwo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Maniyere il Iyesus ashuwotsi jamik'rat moots k'azbkindi, b́ danifwotswere b́maand t'int, «Taarotsi k'ero ariyetso biitso noosh biishde keewwe» bo eti. ");
INSERT INTO bwo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Iyesuswere hank'o ett boosh bí aaniy, «Shooki sheengo shooktso ash na'oniye, ");
INSERT INTO bwo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Taaronúwe datsaaniye, shooki sheengmaniye Ik'i mengsti na'na'úwotsiye, k'eronwere Shed'ani na'na'úwotsiye. ");
INSERT INTO bwo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","K'erman shookiye balangaro diblosiye, mááy kakwonúwere datsan b́s'uwi dúroniye, k'es'irwotswere melakiwotsiye. ");
INSERT INTO bwo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Arikon k'ero waad'de'er b́ saz saazon tifde'er mitsetwok'oo datsan s'uwor mank'o b́ wotiti, ");
INSERT INTO bwo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Manoor ash na'o b́melakiwotsi woshitwe, boowere morro fiinetwok'o k'aliwotsnat gondon finru jamwotsi b́ mengstotse kakude kishitúnee, ");
INSERT INTO bwo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Taaw gop'otso boon bojuwiti, manoknowere k'eet'i eenonat gásh k'aashon wotitwe. ");
INSERT INTO bwo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kááwotsmó bonih mengstotse aawok'o golitúnee, shishets waaz detstso shiye!» ");
INSERT INTO bwo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Manats dabt Iyesus hank'owa bíet, «Dari mengstú goshi taalots áátsets gaaluniye biari, Ash iko gaalman b́ daatstsok'on aaniy aatsb́k'ri, b́ geneeúwtsatse tuutson amt́ b́ detsts jamo kemdek't goshi datsman kewbdek'i.» ");
INSERT INTO bwo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Aaninwere Iyesus hnk'owa bíet, «Dari mengstu ink'u geyiru jaaktsoniye biariye, ");
INSERT INTO bwo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Jaaktsmanwere ayidek't mangts ink'uwo b́ daatstsok'on amt b́ detsts jamo kemk'rat ink'uman kewb́dek'i.» ");
INSERT INTO bwo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Manats dabt Iyesus hank'owa bíet, «Mank'o dari mengstu aats k'arots shap'ets mus'ikambuniye bíariye, biye b́ naar naaron mus'o kakuwituniye, ");
INSERT INTO bwo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","B s'eentsok'on mus' detsirwots aats k'ari gúúratse geetsde kishitúnee, bede'ernwere sheeng sheengo mec'de k'ac'ots gedetúne, gond gondonó okaan juwitúne. ");
INSERT INTO bwo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Dúri s'uworowere hank'owe b́wotitiye, melakiwots waarr morretswotsi kááwwotsitse galdek'etúnye. ");
INSERT INTO bwo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Gondwotsi taaw gop'ots juwitúne, manoknowere eeponat gásh k'ashone wotitiye.» ");
INSERT INTO bwo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ando aaniy Iyesus, «Jam han t'iwintsrteya?» bíet. Bowere «Ee doonzono!» boet. ");
INSERT INTO bwo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Bíwere, «Eshe dari mengstú sheengshdek't b mist'ryo dants nemo daniífoo, k'ac'i mootse handronat nat wotts k'ac'o de'er weetu k'ac'uwots doonzoni bíariye» ett boosh bíaani. ");
INSERT INTO bwo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iyesus jewranotsi keew b́ ishakon manoke k'azbíami. ");
INSERT INTO bwo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","B́ datso Nazret kito maants waat ayhudiyots Ik' bok'oniru maa mootse ashuwotsi b́danifere b́tesh, shishts jamwotswere adfetst hank'owa bo etfo, «Ashaan danitelefonat adits keewan eewkneya b́dowik'úna? ");
INSERT INTO bwo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Hań mito gashde doozfo nayiwoshna? B́ indwere Mariyami eteefúniyoshna? Bí eshwotswere Yak'obi, Yosefi, Sim'onnat Yhudnoshna? ");
INSERT INTO bwo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","B́mish mish jametswots hanoke nooknoshna? Eshe ashaan dani telefan eewkneya b́daatsi?» ");
INSERT INTO bwo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Manatse tuutson bín de'aniyere bo oori. Iyesusmó «Nebiywo mango b́ t'ut'et b́ took datsatsonat b́ took maa mec'rotsne» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Aman bok'aztsatse tuutson Iyesus manoke ay adits keewo fineratse b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Manoor Gelil dats k'eezfo Herodis, Iyesus shúúts eeni jango b́shishi. ");
INSERT INTO bwo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","B́ gútswotssh, «Han gupfo Yohansiye, bíye k'irotse tuure, adits keew jamanots bín bofineyr manshe» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodis Yohanisi detsidek't tipi'moots kindsht tpire b́teshi, man b́k'alwere eegoshe? Bí'eshu Filip'os mááts teshtsu Herodiyad jangatse tuutsone. ");
INSERT INTO bwo_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yohans Herodissh, «Nemon ní'eshu máátsu n dek'etwok'o baziyeke!» ett b́ teshtsotsna. ");
INSERT INTO bwo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Mansh Herodis Yohansi úd'osha b́geyefo, ernmó Ayhudi ashuwots nebiyiwok'o bín bos'ilfotse ashuwotsi b́shat. ");
INSERT INTO bwo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herodis shuweyi aawots Herodiyad ni'i waat s'eegets ashuwots taalotse k'afefetsat Herodisi b́ geneúshi. ");
INSERT INTO bwo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Manatse tuutson Herodis, «N geets keewo taan aatwe! Taawere neesh imetwe!» ett bish b́ taari. ");
INSERT INTO bwo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Biwere indú bish b'ízre, «Gupfo Yohans tooko saniyots gerde taash and ime!» biet. ");
INSERT INTO bwo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nugúsonwere manatse tuutson shiyan b́wtsi, wotowa eree b́ taartsonat bínton mishimaratse beyat teshtswots egetaash boeteti ett Yohans tooko bish imetwok'o bíazazi. ");
INSERT INTO bwo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Mansh tipi moo maants asho woshat, Yohns tooko tipi mootse b́ k'ut'iyi. ");
INSERT INTO bwo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","K'ut'ets tookonowere sahaniyots dek' waat na'úsh boimi, biwere bindsh dek'am imbk'ri. ");
INSERT INTO bwo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yohans danifwotswere waat duuno dek'am duukbok'ri, amtnwere keew man Iyesussh keewbok'ri. ");
INSERT INTO bwo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iyesus Yohans k'iro b́ shishtsok'on jelbots kinddek't ash aal beyok ikok bíaal bewosh bí ami. Ash ashonwere man boshishtsok'on kit kitotse kesht tufoon sha'efere b́ shuutso bo tuwi. ");
INSERT INTO bwo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iyesus jelbotse b́ oot'tsok'on ay asho bek't boosh maac'o b́k'ewi, boyitse shodetswotsnowere b́kashiy. ");
INSERT INTO bwo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Datsonwere b́iltsok'owon b́ danifwots b́ maants t'int́, «Beyokanwo dats basheree, datsonwere ilwtsere, mansh ash asho karnoke fa'a gál gálwotsits amr misho keew bodek'etwok'o damik'rowee» boet. ");
INSERT INTO bwo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ernmó Iyesus, «It bometwo boosh imere bako bo hank'on amo boosh geyiratse!» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","B́ danifwotswere, «Noo hanoke no dets úts tushwotsnat git mus'wots s'uziye» boet. ");
INSERT INTO bwo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Iyesuswere «Manotsi tiyok dowere!» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Maniyere il ash asho sisats bobetwok'o bíazazi, úúts tushonat mus' gitetswotsn k'audek't daromad s'iilt b́ deeriyakon tiitsdek't b́ danifwotssh b́'ime danifwots ashuwotssh bokayi. ");
INSERT INTO bwo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Jametswotswere maat bowori, tushi ooronowere, b́danifwots tatse git mishi maron s'eentsdek't bok'aaúwi. ");
INSERT INTO bwo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Maats ashuwotswere máátsonat nana'oniye okoon uts kumok'o bodts nungushwotsi boteshi. ");
INSERT INTO bwo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Maniyere il Iyesus b́ danifwotssh, «Taa ash asho t fakshfetsosh itye jelbúts kindde'er taayere shino bak'ets kimeree,» ett bíazazi. ");
INSERT INTO bwo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ash ashonowere deen b́k'rihakn Ik' k'onosh gur iko abaats kesh b́dek'i, datso b́ilorowere Iyesus manoke bíaali b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Manoor jelbú aats k'ari taalotse biamiru kaaton bmaand jongiru jongon togefetsat jongon giwuts aatso hake bako jod'eftsatni b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","T'úwitsi jed'i sa'atoniyere il Iyesus aats k'ari abaatse sha'efere b́ danifwotsmand b́weyi. ");
INSERT INTO bwo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","B́ danifwotswere aats k'ari abaatse sha'efe b́waafere bek't ayidek't shatoon tek'bowtsi, «Hanwo meeyee!» ett shatt bokúhi. ");
INSERT INTO bwo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Iyesuswere manoor, «Shenwotso! taane shatk'ayere» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Manoor P'et'ros, «Doonzono! Neena wotiyal aatsi abaatse sha'efere twetwok'o taan azazowe!» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Iyesuswere, «Wowe!» bíet. Mansh P'et'ros jelbútse oot't́ Iyesus maants amoosh aats k'aratse sha'o b́tuwi. ");
INSERT INTO bwo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ernmó jongi ango bek't shatb́wtsi, aats gitsots limo dek't b́tuutsok'on, «Doonzono! taan kashiwe!» ett b́kúhi. ");
INSERT INTO bwo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Iyesus manoor b́ kisho jargt detsdek't, «Nee n imnetiyo neesh shaptsan eegoshe n t'arat'ariri?» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Iyesusnat P'et'rosn jelbots bokindtsok'on jongo s'k et b́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jelbútse teshts jamwots, «Arikon nee Ik'o naay neene!» ett Iyesus shinatse gúp'gup'at bosagadi. ");
INSERT INTO bwo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Iyesusnat b́ danifwots aats k'aroniyere kimt Genseret' datsats bobodi. ");
INSERT INTO bwo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Datsmanatse teshts ashuwots Iyesusi b́woto bodantsok'on gúúrmanatse fa'a beyoke woshat shodetswotsi b́maants de'e weetwok'o bowoshi. ");
INSERT INTO bwo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Shodetswotswere b́ tahi jilo bodetsetwok'o bok'oni. Detsts jametswotswere boshodatse bokashi. ");
INSERT INTO bwo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Maniyakon Iyerusalemitse waats ferisawino eteefwotsnat nemo daifwotsn Iyesus maants waat bín hank'o ett boaati, ");
INSERT INTO bwo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«N danifwots, eenashwots nemo eegishe bogakiri, hambe! kisho bomasherawone misho bomeyiri!» ");
INSERT INTO bwo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iyesuswere hank'o ett boosh bíaaniy, «It eegishe it nemo kotosh etaat Ik'o aap'tso itgakiri? ");
INSERT INTO bwo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ik'onwo ‹Nindnat nnihn mangiwe, b́ nihnat bíndn c'ashetwoniye k'ire bíyats wotiti› ett azazere. ");
INSERT INTO bwo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Itmó ash iko b́ nihsh wee bíndsh ‹Neesh tk'aliyank'o woshok'o wosh́dek'at́ Ik'osh t'intsree› bí etal, ");
INSERT INTO bwo_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","‹Ash man b́ nihi wee bíndi mangiyo bísh geyiratse› it etiri, manshe it nemo kup'iyosh etaat Ik' nemo it gaakiri, ");
INSERT INTO bwo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","It tooko danawanotso! it jangosh Isayas hank'o ett b́ keewtso arikee, ");
INSERT INTO bwo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹Ash ashaan b́ noonon taan mangirwee, b́ nibonmó tiyoke woke, ");
INSERT INTO bwo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ash teronat niwo, nemok'o woshdek't danifetst dats mec'ron taan bo Ik'iri.› » ");
INSERT INTO bwo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Manats dabt́ Iyesus ashuwotsi bíyok s'eegt boosh hank'o bí et, «K'ewere! t'iwintsde'ere! ");
INSERT INTO bwo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ash kiimshfo nonotse keshetwoni bako noono maants kinditwoniyaliye!» ");
INSERT INTO bwo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Maniyere il b́danifwots b́ maants t'iindek't, «Ferisawino etfwotssh nkeewan boosh t'ugo b́ wottsok'o danriya?» ett bín boaat. ");
INSERT INTO bwo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Bímó hank'o ett boosh bíaaniy, «Daritstso t nih b́ tohaw mit jamo waad'itwee, ");
INSERT INTO bwo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bo doogwotsnat dogwotsi jishirwotsi bo wottsotse boon k'ayk'rore, dogo dogo b́jishiyal gitetswots gop'otse bo dihiti.» ");
INSERT INTO bwo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","P'et'rosmó Iyesussh, «Jewrman biitso noosh keewwe» bí et. ");
INSERT INTO bwo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Iyesuswere hank'owa bíet, «Andoor it t'iwintsrawonya itfa'oni? ");
INSERT INTO bwo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nonots kindiru jamo maac'omants ood'r úroo maants b́keshetwok'o t'iwintsratsteya? ");
INSERT INTO bwo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nonotse keshetwonmó nibotsna b́kesheti, ashono kimshitwo maniye. ");
INSERT INTO bwo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Gond asaabo, ash úd'o, wido amo, gobo, úmp'o, kooton gawo, ash shúúts t'afiyo, jamanots ash nibotsne bokeshfoni. ");
INSERT INTO bwo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ash kimshfwots hanotsi bako masheraw kishon mooniyere asho kimshratsee.» ");
INSERT INTO bwo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iyesus manoke kesht T'irosnat Sidon kitwots maants bíami. ");
INSERT INTO bwo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mann Kana'an dats mááts iku Iyesus maants waat, «Dawit naayo! Doonzono!! t na'ú kim shayiron detseyat b́ kic'irwotse oona neesha taash maac'o k'ewowe!» etaat b kuhi. ");
INSERT INTO bwo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Bímó ikunor noono bish bí aanirawo s'ik et b́wts, manoor b́dnifwots bíyok t'int «Máatsan noshuutso sha'at bkuhirwotse oona! neesha bin denee» ett bok'oni. ");
INSERT INTO bwo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Bíwere aanidek't «Taan wosheyiye Isra'elitse mererwotsk'o t'aftswots mec'roshee» ett bíaani. ");
INSERT INTO bwo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Máátsmanmó t'iinat b́ tufishirots tuk'maldek'at «Doonzono! oona neesha taan teúwee!» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iyesuswere «Nana'úwots misho de'er kanwotssh juwo wotitkaliye» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Biwere «Doonzono! ee arikee, ernmó kanwotswor mishimaratse fed'iru mishi fed'o mááfnee» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mann Iyesus, «Máátsune neena n imnetiyoniye eene! manshe nshuntsok'o neesh wotowe!» bíet. Máátsman nii'úwere manoori sa'atse kashbwtsi. ");
INSERT INTO bwo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iyesus manoke tuut Gelil aats k'ariganok b́waa, guri abaatse keshdek't beebwtsi. ");
INSERT INTO bwo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ay ashuwotswere shoklirwotsi, dogwotsi, durwotsi, gidik'uwotsnat k'osh shodetswotsi dek't Iyesus maants bowaa, b́ tufi shirots beez bok'ri, bí were kashi b́ íshi. ");
INSERT INTO bwo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mann ash asho dutswots noono bokeewfere, duruwots bokaashfere, shoklirwots kaatsdek't boshawefere, aaw dogwots bo s'iilfere bek't adt Isra'elko Izar Izeweri boudi. ");
INSERT INTO bwo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iyesus b́ danifuwotsi b́ maants s'eegdek't boosh hank'owa bíet, «Ashuwots taanton hanoke keez aawo tesht bometwo bodeshawotse boosh maac'o k'ewere, boamor weratse shoolr bodihrawok'o eweeron boon damiyo geeratse.» ");
INSERT INTO bwo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","B́ daniyirwots, «Beree ash jamansh bodet misho worwotse ewknya nodatsiti?» boeti. ");
INSERT INTO bwo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Iyesuswere «Amb́tś mishe it detsi?» ett boon bíaatí. Bowere, «Shawat mishonat muk'na'a mus' nana'úwots fa'ane» boet. ");
INSERT INTO bwo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Maniyeokon, Iyesus ashuwots dats bobetwok'o bíazazi, ");
INSERT INTO bwo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Shawt mishwotsnat mus'uwotsn k'a'údek't Ik'o udt, tiitsdek'tnwere b́danifwotssh b́imi, b́ danifwotswere ash ashosh bokayiy. ");
INSERT INTO bwo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Jametswotswere máát bowori, bomááre oortsonowere b́ danifwots kakudek't́ shawat mishimaron s'eents mishifed'o bo k'aaúwi. ");
INSERT INTO bwo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Maats ashuwotswere máátsonat nana'on taawerawon awd kum nungushno. ");
INSERT INTO bwo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Maniyere il Iyesus ash asho deen b́k'ri, jelbotsowere kinddek't Megedon dats kaywots maants bíami. ");
INSERT INTO bwo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ferisawino eteefwotsnat Seduk'awino etefwotsn Iyesusok boweyi, bín fadosh geeyat «Darotse adits keewo noosh kitswe» ett bín bo aati. ");
INSERT INTO bwo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Bímó hank'o ett boosh bí aaniyi, «Kooc'on daro b́ bírre it bek'or ‹Bilee b́wotiti› etirute, ");
INSERT INTO bwo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Datso b́gatsor guuron ando ‹Daro daawnar b́ aak'or hambets aawush mango butsetwe› it etiri, dari maac'o bíaro danosh falfte, ernmó dúri milkto dano falratste. ");
INSERT INTO bwo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Gondonat amaneraw s'oot'anots, mililkt bek'o geefne, ernmó nebiyo Yonas milkitoniye oko k'osh milkito imeratse.» Maniyere il Iyesus boon k'azk'rat k'osh beyokok bíami. ");
INSERT INTO bwo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","B́ danifwots aats k'aroniyere bokimoor batk'rat misho detsde'atsno botesh, ");
INSERT INTO bwo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Iyesus b́danifwotssh, «Nibn de'ere, Ferisawino etefutsnat Seduk'awino eteefuwots boot'shashatse it atso kordere» bí et. ");
INSERT INTO bwo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bowere, «Han bí'etir misho dek'woo nok'aztsoshe b́wotiti» ett boatsatseyo bokeeweyi. ");
INSERT INTO bwo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iyesusmó bo asaabirwo dandek't hank'o boosh bíet, «It amanerawotso! ‹Misho node'awoshe› etaat it atsatsewo eegishe it keeweyeri? ");
INSERT INTO bwo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Andoor t'iwintsratsteya? Úts misho úts kum ashosh b́ bodtsok'onat oorts mishifed'o ambts mishimaron s'eeno it k'aaútsok'o gawuratsteya? ");
INSERT INTO bwo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Mank'o shawat misho awd kum ashosh b́bodtsok'owonat oorts mishifed'o ambts mishi maron s'eentso it k'aa'útsok'o t'iwintsratste? ");
INSERT INTO bwo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Eshe ‹Ferisawino eteefuwotsnat Seduk'awino eteefuwots boot' shashatse it atso korde'ere!› etaat itsh tkeew mishi jango wotb́k'azo aawk'oneya t'iwintso it k'azi?» ");
INSERT INTO bwo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","B́ danifwotssh it atso korde'ere bí ettso ferisawno eteefuwtsnat Seduk'awino eteefuwotsn doyatsna bako bo mishi boot'shashatse b́woterawok'o danbodek'. ");
INSERT INTO bwo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iyesus Filip'os K'isariyi eteef dats kayuk b́bodtsok'on b́ danifwotssh, «Ashuwots Ash na'osh koni etee boetiri?» ett boon bíaati. ");
INSERT INTO bwo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bowere, «Ik ikwotsiye ‹Gupfo Yohansiye,› etirune, k'oshwots ‹Eliyasiye› etirune, ando k'oshuwots ‹Ermiyasiyee wee nebiyiwotsitse ikoniye› etfne» boet. ");
INSERT INTO bwo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Iyesuswere, «Itmó koni etfte tasha?» Bíet. ");
INSERT INTO bwo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Mann Sim'on P'etros aanidek't, «Neehe Krstos neene, Ik'o naay neene,» ett bísh bíaaniy. ");
INSERT INTO bwo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Iyesuswere Hank'o bísh bíeti, «Yona naay Sim'ono! derek neene! han neesh kits darotse fa'o tnihiye bako ashaaliye. ");
INSERT INTO bwo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Taawere hank'o etreneesha, nee P'et'ros neene, shutsi s'alanatsowe Ik' moo agetuwe, Ik' maa mannowere dab k'iri angonuwor da'aratse. ");
INSERT INTO bwo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Eshe, dari mengstu bín k'eshetwotsi neesh imetwe, datsatse n tiptso darotse tipekee b́wotiti datsatse n biitstso darotse bishke b́wotiti.» ");
INSERT INTO bwo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Maniyere il Iyesus b́ danifuwotssh bí Krstosi b́wottsok'owo konshor bokeewrawok'o bí azazi. ");
INSERT INTO bwo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Manortson tuut Iyesus b́ danifwotssh hank'o eto dek' b́tuu, «Iyerusalem maants amo taash geyife, manoknowere ee naashuwots, kahani naashuwotsnat nem danifwotsoke gondbek'o tiats bodetwe, taano úditunee, keezl aawonomó k'aytuwitwe.» ");
INSERT INTO bwo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","P'et'rosmó Iyesusi bíaali s'eegdek't́, «Doonzono! woteratse b́jamoona! keewan niats boratse!» etfetst bín fayo dek't b́tuwi. ");
INSERT INTO bwo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Iyesusmó wongr ett aanat P'et'rossh, «Nee shed'anono! tshinatse tuuwe! nee ashka bako Ik'iko ní asaaberawotse taash t'uugnenee» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Maniyere il Iyesus b́ danifuwotssh hank'owa bíet, «T jafrats woo geyiruwo b́ tooko juu k'rowe, b́ mask'aliyonowere kurde tshuutso sha'owe. ");
INSERT INTO bwo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","B́ kasho kashiwosh geyiru jamo b́ kashitwe t'ut'etwe, b́ kashu t jangosha err t'ut'etwonmó daatsitwe. ");
INSERT INTO bwo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Asho datsanatsi gaal jamo b́datsiyal, b́ kashunmó b́ t'afiyal eege bísh b́ k'aliti? Wee asho b́kashi shegro k'awntso dashosh falitwá? ");
INSERT INTO bwo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ash na'o b́ nih mangon wotde'er b́ melakiwotsnton weetwe, manóroweree ik ikon boosh bofinok'o bok'awntso dashetwe. ");
INSERT INTO bwo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Arikoniye itsh t keewiri, ash na'o b́ mengsti mangon b́waafere bobek'fetsosh hanoke need'iru ashaanotsitse k'irrawwots fa'ane.» ");
INSERT INTO bwo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Shrt aawoniyere il Iyesus P'et'rosi, Yak'abnat Yak'ob eshu Yohansi b́ shutsats s'eegdek't bí aal ayidek't danbaan tuuts guriabats k'azb́kesh. ");
INSERT INTO bwo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Manoke boshinatse bíaro wone b́wutsi, b́ shiitsonwere aawok'o b́ goli, b́ tahonwere nas't sháánok'o b́goli. ");
INSERT INTO bwo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Musenat Eliyasn Iyesusnton bokeewefere boats be'ebowts. ");
INSERT INTO bwo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Manoor P'et'ros Iyesussh, «Doonzono! hanoke nobeyink'eree noosh sheenge, mansh ni'ekitka wotiyal iko neesh, iko Musesh, iko Eliyassh, wotit gof keezwotsi awone» bí et. ");
INSERT INTO bwo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","P'et'ros man keewoke b́befere goliru daawno boon degb́k'ri, daawn manitsnowere «Tshuntso tna'o tmaac' k'eeztso haníyee, bín k'ewere!» etiru k'ááro b́weyi. ");
INSERT INTO bwo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","B́ danifwots k'aar man boshishtsok'on ayidek't bo tek'tsosh bobaron datsats gúp'gup' bowtsi. ");
INSERT INTO bwo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Iyesusmó bomaants t'int boon shuu'at «Tuuwere shatk'ayere!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Bowere dambaan kááwdek't bos'ile Iyesusiyere okoon konnor be'aatsno. ");
INSERT INTO bwo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Guratse oot'oke bobefere Iyesus, «Ash na'o k'irotse b́tuufetsosh it bek'tsan konshor keewk'ayere» ett b́danifwotsi bíazazi. ");
INSERT INTO bwo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","B́ danifwotswere, «Eshé, nem danifwots shino woo bín geyitwo Eliyasiye boetir eegoshe?» Ett bín boaati. ");
INSERT INTO bwo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Iyesuswere aaniy dek't, «Arikee, Eliyasiyere shino weetwe, bíye úno manutsitwee. ");
INSERT INTO bwo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ernmó Eliyas yoots shino waare etirwe itsha, ashuwotsmó bín danatsne, manshe bogeyiru jamo bíats bok'ali. Mank'o ash na'o bokishatse gond bek'o bín geyife.» ");
INSERT INTO bwo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Manoor b́danifwots Iyesus keewirwo gupfo Yohans jango b́wottsokowo boosh galb́gutsi. ");
INSERT INTO bwo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Iyesusnat b́danif keezetswots ash ashomants bo aantsok'on ash iko Iyesus maants waat b́ tufishirots tuk'maldek't hank'o bíet, ");
INSERT INTO bwo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Doonzono! oona neesha tna'osh maac'o k'ewowe, fo'erawo ayidek't bín gonde b́bek'shiri, tawotso aatsotso ayoto b́dikiri. ");
INSERT INTO bwo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","N danifwotsokowere doore b́teshi, ernmó bín kashiwosh falratsne.» ");
INSERT INTO bwo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Iyesuswere, «It amaneraw dúranatsi s'oot' k'uranotso! awrish b́borfetsone itnton tbeeti? Himo, awrish b́borfetsone iti t k'amiti? Aab na'o t maants dowere!» bí et. ");
INSERT INTO bwo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Iyesus fo'erawman bí hadi, fo'eronewere na'o atsotse k'az b́keshi, na'amanwere manoor kashb́utsi. ");
INSERT INTO bwo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Maniyere il b́ danifwots bo aal Iyesusok t'int, «Noo fo'erawman kisho nomaaw eegoshe?» ett boaati. ");
INSERT INTO bwo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Iyesuswere boosh hank'o bíet, «It amano it k'aztsoshe, arikon itsh keewirwe, senafic' aawi kayuk'o bodts imnetiyu detsfetee wotink'eree gurhansh ‹Hanoke tuur ok amee!› it etal ametuwe, itsh maawetwo eegor aaliye. ");
INSERT INTO bwo_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Han naari fo'erawo Ik' k'ononat s'oomiyona bako b́ jamon keyatse.» ");
INSERT INTO bwo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","B́ danifwots Gelil datsatse bokakwewor Iyesus hank'owa boosh bíet, «Ash na'o ash ashuwots kishatse beshiyeyar imetwe. ");
INSERT INTO bwo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Bowere bín úd'itune, ernmó keezl aawots k'irotse tuwitwee.» B́daniyrwotswere keewanatse tuutson ayidek't shiyan bowutsi. ");
INSERT INTO bwo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iyesusnat b́ daniyfwots K'frnahomits bobodtsok'on Ik'i moosh err dek'irwots P'et'rosok t'int́, «Iti danifo Ik' maa ereero dashalkeyaa?» ett boaati. ");
INSERT INTO bwo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","P'et'roswere, «Ee dashetwe» bíet. P'et'ros moo maants b́kidtsok'on Iyesus shino, «Sim'ono! eege neesh biari? Datsanatsi naashwots ereero wee t'ilisho bo dek'et konkneya? Bo nana'oknemó uri datsi ashokneya?» ett bíaati. ");
INSERT INTO bwo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","P'et'roswere, «Uri datsi ashaatsne» ett bíaani. Iyesuswere hank'o bíeti, «Beree bo nana'aúwots ereer dashotse aalne eteere? ");
INSERT INTO bwo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ernmó boosh t'ugo nowoterawok'o aats k'aromaants amr mus'i mak'at'ino sha'úwee, shin shino keshet mus'oodeshde'e, b́nono n wogor bítse gizo daatsitune, manowere de'er taanat neenko daye.» ");
INSERT INTO bwo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Manoor b́ danifuwots Iyesusok t'int, «Dari mengstotse jamoniyere bogo kone?» ett bo aati. ");
INSERT INTO bwo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iyesuswere na'í marmat' iko s'eegdek't bo taalots ned'ib́k'r, ");
INSERT INTO bwo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Hank'owo bíeti, «Arikone itsh ti etiri, woneyar nana'í marmat'uwotskok'o woto it k'azal b́ jamon dari mangstots kindratste. ");
INSERT INTO bwo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Na'i marmat'ankok'o b́ tooko dashan detsetwo dari mengstotse eene b́wotiti. ");
INSERT INTO bwo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Hank'o wotts na'o t shúútsosha err dek'etwo taan dek'etwe.» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Konwor wotowa asho taan amaniru muk'nana'anotsitse iko b́ dariyoniyere mangts dí'́i shútso b́ bimbats tifde'er ayide dashan gop'ts aatsi k'arotse juweyar k'ot'eeb́wtsink'eree bísh k'aniyank'e.» ");
INSERT INTO bwo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Manats dabt Iyesus hank'o bíet, «Ash ashuwotssh t'ug wotiru ashuwots jangatse tuutson indowe datsusha! wottso b́ wotiyalor t'ug wotit keewwots bowowo ooreratse, ernmó t'ugo wotitwo b́weetwok'o k'alitumansh indowe bísha! ");
INSERT INTO bwo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Mansh eshe n kisho wee n tufo morro n finitwok'o neen b́daritkawotiyal k'ut'de' juk'rowe! git kisho wee git tufo deshfetsr dúre dúri tawots njuwewoniree kish k'ut'o wee duro wotarr dúre dúri kashomaats kindo neesh k'anefe. ");
INSERT INTO bwo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ni ááwonúwere morro nfinitwok'o neen b́dariyal kishde okaan juk'rowe! git ááwo deshfetsŕ gahanem taw gop'ots njuwewoniyere ááw iketso wotaarr kasho maants kindo neesh k'anefe. ");
INSERT INTO bwo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Darotse fa'a bo melakiwots jam aawo darotse fa'o tnih shiitso bos'iilirwotse, k'ac'in nana'anotsitse dab́ ikonor it gac'erawok'o it tooko korde'ere.  ");
INSERT INTO bwo_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ash na'onúwor b́waa t'aftso kashiyoshe.» ");
INSERT INTO bwo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ando aaniy Iyesus hank'o bíeti, «Aab eeg arefa itsha? Bal mereer detsts ash iko boyitse iko b́k'aleyal balosh ik shapwotsi guri abaatse k'ayk'rar t'aftsman geyo amaalkeya? ");
INSERT INTO bwo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ariko itsh keewirwe, bín b́daatsor fa'a balosh ik shapwotsiyere t'aft daatsets ikmansh b́gene'úwiti. ");
INSERT INTO bwo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mank'o darotse fa'o itnih nana'a k'ac'nanotsitse ikonwore b́t'fitwok'o geyeratsee. ");
INSERT INTO bwo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Nieshu neen b́dadiyal neenat bín ikn wotde neesh b́t'afitso keewwe, n keewo b́ shishetka wotiyal aani nik woshdek'etuune, ");
INSERT INTO bwo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","N keewo shisho b́k'azalmo wee git wee keez ashuwots gawts gawo b́s'eenetwok'o neenton wee iko wee git asho de'er biyok amee. ");
INSERT INTO bwo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Boon k'ewatse bíetalmó Ik' moosh keewwe, Ik'i moonowere k'ewatse bí'etetka wotiyalowere Ik' danawok'o wee morretsok'o taawk'rowe. ");
INSERT INTO bwo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Arikoniyere itsh tietiri, datsatse it tiptetwoniye darotse tipekee b́wotiti, datsatse it biitsetwo daaratse bishke b́wotiti. ");
INSERT INTO bwo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Andoor aaniy itsh keewirwe, ititse gitetswots datsatse eegonor k'onosh ikwotar Ik'o bok'oniyal darotse fa'o t nih itsh s'eentsitwe. ");
INSERT INTO bwo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Gito wee keezo wotar tshúútson bokakwet beyokoke taa bo dagotse daatsetwe.» ");
INSERT INTO bwo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Manoor P'et'ros Iyesus maants t'int́, «Doonzono! tíeshuu taan b́dadiyal ambtsoto bísh oorowe erta? Shawatoto b́borfetsoneya?» ett bíaati. ");
INSERT INTO bwo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iyesuswere bísh hank'o bíet, «Shawatoti sheba bako shawatot mec'ra eraatse neesha, ");
INSERT INTO bwo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Mansh daritsi mengstu guutswotsnton tanoosh geyiru nugúsoniye bíari, ");
INSERT INTO bwo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nugusonwere taano dek't b́tuutsok'on ay miliyeniyon meklityo bíatse fa'a guuts iko detseyat b́weyi. ");
INSERT INTO bwo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Guuts man bíatse fa'a k'awntso dasho b́mááwtsotse bíwere b́ máátsunowere b́nan'úwotsnat b́ detsts jamonowere kemde'er bíats fa'a k'awntso b́dashetwok'o b́ doonz bíazazi. ");
INSERT INTO bwo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Guutsonmo b́ doonz shirots tuk'maldek't ‹Doonzono! oona neea! muk'i taash s'iilde'e, b́ jamonor neesh dashetwe!› ett bín b́ k'oni. ");
INSERT INTO bwo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","B́ doonzwere bísh maac'o k'ewat bín faksh b́k'ri, bíatsi k'awntsonoweree k'azb́k'ri. ");
INSERT INTO bwo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Ernmó guutsman manoke kesht amoke b́befere bal dinariyo gusho bíatse b́detstso b́ tooho daatsdek't b́ bimbo gúk'dek't, ‹Neesh t gushits gizo taash daye!› bí et. ");
INSERT INTO bwo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Guuts b́ toohmanwere b́tufishirotse diht́ ‹Oona neesha! taash muk'i k'amowee, neesh dashetwe!› ett b́ k'oni. ");
INSERT INTO bwo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ashmanmó k'aze bíet. Iki dabnwor detsdek't amt́ b́ k'awntso b́dashfetsosh tipi moots tipi b́k'ri. ");
INSERT INTO bwo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Bínk'ó wotts guuts guutswots man bobek'tsok'on ayidek't shiyanbowts, amtinwere wotts jamo bodoonzsh keewbok'ri. ");
INSERT INTO bwo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","doononwere guutsman s'eegidek't bísh hank'o bíet, ‹Nee gond guutsono! taan nk'onree jam k'awntsman neesh k'azre, ");
INSERT INTO bwo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Eshe, taa niatsi k'awntso neesh k'aztk'rok'o, nee ntooh wotts guutsosh k'azo neesh geyiyank'oshna b́teshi?› ");
INSERT INTO bwo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mansh doonzo fayat bíatsi k'awnts jamo b́dashfetsosh tipi maa naashosh beshidek't b́ ími. ");
INSERT INTO bwo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«Eshe itwere ik ikon it eshuwi itnibotse kishde neesh orowe eto itk'azal darotse fa'o tnihwor mank'o it aats k'alitwe.» ");
INSERT INTO bwo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iyesus man keew b́ ishiyakon Gelil datsatse tuut, Yordanos fokoniyere bak'etse Yihud datsats bíami. ");
INSERT INTO bwo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ay ashonwere b́jafrats botuwi, boyitsnowere shodtswotsi b́ kashiyi. ");
INSERT INTO bwo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Manoor ferisawino eteefwots b́ maants t'int bín fado geeyat, «Asho b́ máátsu ik jago bt'afiyal manatse tuutsonowere fakshuna bíetal nemo eekituwáá?» ett boaati. ");
INSERT INTO bwo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Iyesuswere hank'o ett boosh bí aaniy, «Shin Ik'o nungushonat máátson woshdek't boon bíaztsok'o nababeratsteya? ");
INSERT INTO bwo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ando aani ‹Man jangosh asho b́ nihnat bíndn k'aykraar b́ máátsunton ik wotitwe, gitetswotswere ik ats wotitúne› ");
INSERT INTO bwo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mansh bo maniyak ik atsnee bako gitnaaliyee. Eshe Ik'o s'anddek't ik b́woshtso asho b́ k'alawok'owa.» ");
INSERT INTO bwo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ferisawino eteefwotswere, «Béré, Muse eegishe ‹Keniho b́ máátsu b́ fakshetsok'o kitsit werek'eto imr bin fakshwe› bíetiri?» bo et. ");
INSERT INTO bwo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Bíwere boosh hank'owa bíet, «Museyiyere it máátsu itfakshitwok'o bíet itnibo kup' b́wottsi jangatsna bako shin mank'oyiyaliye b́teshi. ");
INSERT INTO bwo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Taamó ash iko widatse tuutson b́wotiyalabako b́ máátsu fakshr k'oshu b́dek'al gobetsi wotere» etirwe itsha? ");
INSERT INTO bwo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","B́ danifwotswere, «Kenihe mets jango hank'owi wotiyal mááts dek' k'azo k'anefe» boet. ");
INSERT INTO bwo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Iyesusmó hank'owa bíet «Mank'o keewo bofalitwok'o boosh imetswotssha bako jam ashosh faleratse. ");
INSERT INTO bwo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Gat wotat shuwetswots fa'ane, asho boon b́ gatitswotswere fa'ane, Ik'i mengstosh ett botookon botoko gatok'o taawtswots fa'ane, mansha keewan dek'osh falitwo de'e.» ");
INSERT INTO bwo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Manorowere b́kisho boats gerde'er Ik'o boosh b́k'onitwok'o ashuwots nana'o Iyesus maants dek't boweyi, b́ danifwotsmó ash asho bofayi. ");
INSERT INTO bwo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Iyesuswere «Dari mengstu hanotsk'owwotssh b́wottsotse nana'í marmat'úwotsi k'ayere t maants wonee, bazik'ayere» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","B́ kishonowere boats b́gediyhakon manoke beshat k'azbíami. ");
INSERT INTO bwo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ik aaw ash iko Iyesusmaants waat «Danifono! dúre dúri beyo daatsosh sheeng keewo k'alosh taan geyitwo eebik'úna?» ett bíaati. ");
INSERT INTO bwo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iyesuswere, «Sheeng keewi jango eegishe taan ni aatiri? Sheeng wottso Ik' ikoniye, kashomaats kindo ngeyiyalmó b́ tzaziyotsi s'eentswe.» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ashmanwere, «B́ tzaziyots aawotsnee?» bíet. Iyesusu hank'o ett bí aani, «Asho ud'k'aye, wido amk'aye, úmp'k'aye, kooton gawk'aye, ");
INSERT INTO bwo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","n nihnat nindn mangiwe, k'osh asho ntookok'o woshde shune, etiru tzaziyotsiye» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jawets na'amanwere, «Tzazi jamnotsnere s'eentsre, k'osho taash shapitwo eebik'una?» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iyesuswere, «B́ jamon s'eeno woto ngeyiyalee amŕ ndetstso kemde'er gizman t'owwotssh ime, darotse gaalo daatsitune, tshuutsonowere shoyde wowe» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jawets na'a manwere, ay gizo b́detstsotse man b́shishtsok'on shiyanefere k'azbiami. ");
INSERT INTO bwo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Maniyere il Iyesus b́ danifuwotssh hank'wa bíet, «Arikone itsh tkeewiri, gaalets ashosh dari mengstots kindoniye ayidek't mange. ");
INSERT INTO bwo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Andoor itsh keewirwe, Gaalets asho Ik'i mengstots b́ kindoniyere kambulo mafi furotse b́ besho ketefee.» ");
INSERT INTO bwo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","B́ danifuwots man boshishtsok'on ayidek't adt «Beree, kone kashosh faliti?» bo et. ");
INSERT INTO bwo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iyesus bo maants s'iilt, «Keew han ashosh faletkaliyee, Ik'oshomó jamo faletwe» bí et. ");
INSERT INTO bwo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Manoor P'et'ros, «Hambe, noo jamo k'azk'rat n jafrats sha'erone, eshe ebiyek'únaa nodatsiti?» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Iyesuswere boosh hank'o bíet, «Arikoniye itsh tietiri, Ash na'o b́ mang jorats be b́dek'ots andr datsuwatse tjafrats sha'atswots, it woor tatse git mangi jooratse itbeeti, tatse git Isra'el jirwotsatse angshitutee. ");
INSERT INTO bwo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","T jangosh err b́ moowwotsi, wee bí eshwotsi, wee b́ mishotsi, b́nihnat b́idono, wee b́nana'o, wee b́gosho k'azts jamo baloti gito dek'etwe, dúre dúri kashonowere daatsitwe. ");
INSERT INTO bwo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ernmó and shints wotts aywots shuuts oortswotsi wotitúne, shutsts wottswots shintswotsi wotitune.» ");
INSERT INTO bwo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Dari mengstú woyini miti beyoke finiru ashuwotsi k'at'arosh guuron keshts miti doonzoniye biariye. ");
INSERT INTO bwo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bí ik ik aawosh ik ik dinariyo dashosh keeweyat, finirwotsi weyini mitook b́woshi. ");
INSERT INTO bwo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Keez sa'atok'on kesht, fino bitst jebatse need'iru k'osh ashuwotsi b́bek'i, ");
INSERT INTO bwo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‹Itwere weyini mit boyok amr finore. Itsh imo geyit k'awntso dashetwe› bí eti. ");
INSERT INTO bwo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bowere weyini miti datsok boami, ando aaniy shrt sa'atonat jed'iy sa'atok'on kesht mank'o b́k'ali. ");
INSERT INTO bwo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tatse ik sa'atok'onowere k'osh ashuwotsi bo need'efere daatsdek't ‹Itmó aaw jamo fino bitsat hanoke it need'ir eegishe?› ett bíaati. ");
INSERT INTO bwo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bowere ‹Noon k'at'arit asho t'út'atniye› boeti, bíwere ‹Beree itwere weyini mitwots beyok amr finore› bíet. ");
INSERT INTO bwo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Datso b́iltsok'on weyini mitwots doonz fin manatse b́naashitsosh ‹Finirwotsi s'eerr ili k'at'aretswotsatse tuuzr shin k'at'aretswotsok b́borfetsosh bofintsi k'awntso boosh daye› bí eti. ");
INSERT INTO bwo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mansh tatse ik sa'aton k'at'aretswots ik ikon t'int ik ik dinariyo bodek'i. ");
INSERT INTO bwo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Shin k'at'aretswots bot'intsok'on bogshde bodek'etwok'o boosh bíar, ernmó boowere ik ikon ik ik dinariya bodek'i. ");
INSERT INTO bwo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Gizo k'aaú dek't́ weyini mito doonzats hank'o ett bomumundi, ");
INSERT INTO bwo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‹Hanots il waat bofin ik sa'atoshe, ernmó aaw jamo aaw k'es'atse mis'fetsat maawron jintswotsnton nonoton taal woshnk'ri.› ");
INSERT INTO bwo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Weyini miti doonzonwere, finirwotsitse ikosh hank'o ett bí aaniyi, ‹T mashono! neen eegor daderatsee, nokewe ik aawon neesh ik dinariyo dashoshoshnaa? ");
INSERT INTO bwo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Eshe nbano de'er amee, neesh tímtsok'o bodtso iltsanshowere imo shunre. ");
INSERT INTO bwo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","T took gizatse tshuntso k'alosh alo detsfoshna? Himo taa tewud doo twottsoshee nee n okoori?› » ");
INSERT INTO bwo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Maniyere il Iyesus, «Mank'o, shuutstsi teshtswots shintsi, shintsi teshtswots shuutstsi wotitune» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Maniyere il Iyesus Iyerusalem maantsan bíamfera b́tesh, amoke bobefere weeratse tatsegit b́danifwotsi boaali b́ maants s'eegdek't́ dek'amt́ hank'o boosh bíet, ");
INSERT INTO bwo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Hamb, Iyerusalem maantse noamiri, manoknee Ash na'o kahni naashwotsnat nemo danifwotssh beshide imetwe, boowere k'iri angsho bíats angshitúnee. ");
INSERT INTO bwo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ik'i ashwoteraw ashuwotssho beshide imetúnee, boowere trgc'o bíatso kaashetúne, bíno garafituno, bín jiitetúnee, ernmó keezl aawots k'irotse tuwitwee.» ");
INSERT INTO bwo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Maniyere il Zebdiwos nana'úwots ind, b nana'úwotsnton Iyesusmaants t'iinat b́ shinatse tuk'maldek'at ik keewo bish b́ k'alitwok'o bín b́ k'oni. ");
INSERT INTO bwo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Iyesuswere, «Eege ngeyiri?» bí eti. Biwere, «N mengstotse t nana'a gitets hanots iko giro maants, iko k'ano maants bobeetwok'owo taash woshwe!» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Iyesusmó «It itk'onirwo danatste, taa karnon túshet gondbek'i wanc'o úshosh falituteya?» bíet. Bowere «Ee falitwone!» boeti. ");
INSERT INTO bwo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Iyesuswere, «Arikon taa t úshet gond bek'i wanc'o úshetute, ernmó k'anonat giromaants bobetwok'o k'alitwo taanaliye, beyokman imetiye tnih boosh b́ k'anits ashuwots s'uzshe.» ");
INSERT INTO bwo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","B́ danif tatswots bok'onts k'onman boshishtsok'on eshu git manotsats fayogedbok'ri. ");
INSERT INTO bwo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Iyesusmó jametswotsi s'eegdek't hank'o boosh bí eti. «Ik' danaw ashuwotsatse naashtswots bo ash ashaatse alknee, boon jishirwotswere boon boaalefook'o danfte. ");
INSERT INTO bwo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","It dagotsnere mank'o woto geyiratse. Ernmó it dagotse een wot geyirwo it guuts wotowe. ");
INSERT INTO bwo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Mank'o ititse bogo wotosh geyirwo it guutso wotowe. ");
INSERT INTO bwo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ash na'oniye bí finar ayuwotsi kashiwosh b́ kasho beshide imoshe b́weyi bako bísh fineyishaliyee» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Maniyere il Iyarikoyitse kesht boamfere ash ash aywots Iyesus jafrats botuwi. ");
INSERT INTO bwo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ando weeri gúratse beyiru ash aaw dog gitetswots man weeron beshirwo Iyesusi b́ woto boshishtsok'on «Dawit naay doonzono! oona neesha, noosh maac'o k'ewowe!» ett bokuhi. ");
INSERT INTO bwo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ash ashonwere «Ishooree!» ett boon bofayi, bomó «Dawit naay doonzono! oona neesha noosh maac'o k'ewowe!» et fetst ayidek't bokúhi. ");
INSERT INTO bwo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iyesuswere need'dek't́ boon s'eegt «Itsh eeg tk'ale itgeyiri?» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bowere «Doonzono! no ááwwots bok'eshetwok'o woshwe!» boeti. ");
INSERT INTO bwo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iyesuswere boosh maac'o k'ewat bo ááwwotsi b́shuuí, bo ááwwotswere manoor bobek'i, boowere Iyesus jafrats boami. ");
INSERT INTO bwo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Iyesusnat b́ shuuts sha'irwots Iyerusalem maants bot'inor Debrezeyitn Bete Faageyi eteef galúts bobodtsok'on Iyesus b́danifwotsitse gitetswotsi hank'o ett woshbk'ri, ");
INSERT INTO bwo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«It shinatse fa'a galúts ameree, manokowere itbodtsok'on daaz iku bnaúnton tipetsu daatsitute, biishdeniye taash de'ewore. ");
INSERT INTO bwo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Asho konwor ikjago itn bíaatiyal ‹Doonzo boon b́geyirwoshee› erere. Bíwere daaz daazwotsi manoor doyitwe.» ");
INSERT INTO bwo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Man b́wotye nebiyiwon hank'o ett keewetso b́ s'eenishe, ");
INSERT INTO bwo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«S'iyon mááts naúsh ‹Hambe! Nnuguso bíatso dash detsedek't daazunat B́naú ats wotde n maants weetwe!› err bish keewwere.» ");
INSERT INTO bwo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","B́ danifwotswere amt Iyesus boosh b́ keewtsok'o bo k'ali. ");
INSERT INTO bwo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Daazunowere b na'úntoon bíyok dek't boweyi, botahonowere daazwots jik'ats gedbok'ri, Iyesuswere bíyats be b́dek'i. ");
INSERT INTO bwo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ash ashotse aywots botaho werindats ees'bok'ri, k'atsetswotswere maarets miti jaabo k'ut'dek't weerindatse boes'fera botesh. ");
INSERT INTO bwo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ash shin shinatse amiruwotsitsnat b́ jafratse weyirwotsitse teshtswots, «Hosa'ano Dawit naayshe! Doonzo shútson weetwo deereke! hosa'ana darotse!» ett bo kuhefera botesh. ");
INSERT INTO bwo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Iyesus Iyerusalemits b́ kindor kititsi ash jamo, «Han kone bí?» eton dimbirbowtsi. ");
INSERT INTO bwo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ash ashonwere, «Han Gelil datsatse fa'o Nazretitse waatso nebiyiwo Iyesusiye.» bo etí. ");
INSERT INTO bwo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Maniyere il Iyesus Ik' moots b́ kindi, manoknowere kemiruowtsnat keewiru ash jamo kish b́ ishí. Giz woniyiruwots maronat kurkund kemirwots jooronowere gúp'sh b́ ishi. ");
INSERT INTO bwo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","« ‹T moo Ik' k'oni maa eteetwe› ett guut'ere, itmó bík'tswots gemook'o woshrte!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Iyesus Ik' mootse b́befere ááw doogwotsnat shoklirwots b́ maants bo waare b́kashiyi. ");
INSERT INTO bwo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ernmó kahniy naashwotsnat nem danifwotsn Iyesus b́ k'alts adits keewo bobek'tsonat nana'i marmat'uwots Ik'i mootse «Dawit naaysh hosa'ana!» etfetst bokuhefere boshishtsotse bofayi. ");
INSERT INTO bwo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Mansh Iyesussh «Nanaúwots bo etirwo k'ebirwiya?» boeti, bíwere «Ee, k'ebirwee, ‹Nana'uwotsnat s'aats úshirwots nonotse udo k'anirnee› etirwo b́ jamon nababeratsteya?» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Boon k'azk'rat kitotse kesht Betaniya eteef galúts bíamí, manoko b́k'eeyi. ");
INSERT INTO bwo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Iyesus dats gats guuron kito maants aanat amfetst k'ak'b́wtsi, ");
INSERT INTO bwo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Belesi mit iku weerindi gúúratse bek't b maants bíami, ernmó biyatse maara bako eegor daatsratse. Mansh «Haniyehak b́ jamon shuwo níatse b́datserawok'owa!» bíet. Mitúnuwere manoor shuuk'bwtsi. ");
INSERT INTO bwo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","B́ danifwots man bobek'tsok'on «Belsi mitan iknun aawk'oneya shuuk' bgutsi?» ett bo'adi. ");
INSERT INTO bwo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iyesuswere hank'o ett boosh bíaaniy, «Arikone itsh tkeewiri, imnetiyo deshr t'arat'aro itk'azink'ere belesi mitu atsats k'aletsok'o k'almec'ro b́woterawon dab gurhansh ‹Hanoke tuur aats k'arots shap'ewe!› it etal itsh s'eenetwe. ");
INSERT INTO bwo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Amanar Ik' it k'onitu jamo daatsitute.» ");
INSERT INTO bwo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iyesus Ik' moots kind dek't daniyo dek't b́tuwi. Manoor kahni naashwotsnat ashitsi eenashwots b́ maants t'int «Jaman nk'alirwo eegi aloneya? Alhanowere neesh imtso kone?» Ett boaati. ");
INSERT INTO bwo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iyesuswere hank'o et boosh bíaaniy, «Taawere ik keewu iti aatuna, ti aattsu taash it aniyalee taawere jaman kon alon t k'alirwok'o itsh keewitwe. ");
INSERT INTO bwo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yohans gupo eewkneya b́weyi? Darotsneyamo ashokneya?» Bíere, bo boatsatseyosh hank'o ett boshiyeyi. « ‹Darotsne› noetal ‹béréé, eegoshe bín amano it k'azi› noosh bí'eteti, ");
INSERT INTO bwo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","‹Ashokike› noe'talmó, Yohansi jamwots nebiyok'o bos'ilirwosh, ashuwotsi noshati.» ");
INSERT INTO bwo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Manshe, «Danatsone» ett boaaniy. Bíwere «Taawor jamhan eegi alon tk'alirwok'o itsh keewratse» bí et. ");
INSERT INTO bwo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Manats dabt boosh hank'owa bí et, «Ash iko nana'a gitetswotsi detsfe b́tesh, boyitse iko maants t'int, ‹Tnaayo! hambets t weyini miti beyoke amr fino nfinitwok'owa› bíet. ");
INSERT INTO bwo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","B́naaywere ‹K'aze amatse› bíet. Ernmó il goynat finosh bíami. ");
INSERT INTO bwo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nihonwere b́naay ikok ando amt́ bíshowere mank'o b́ finitwok'o bín bíazazi, ‹Wotowe tniho ametuwe› bíet. Ernmó amatse. ");
INSERT INTO bwo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Eshe gitetsanotsitse b́ nih alo s'eentstso ááwnee?» Bowere «Shintsoni!» boeti, Iyesuswere boosh hank'o bíeti, «Arikoniye itsh tietiri, morretswotsnat gobetswotsn dari mengstots kindosh itiyere shinitunee. ");
INSERT INTO bwo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Gupfo Yohans kááwi weerindo itsh kitsosh b́ waare bín amaneratste, morretswotsnat gobetswotsmó bín amanernee, hanowere bek'aat dab naandrone etaat amaneratste.» ");
INSERT INTO bwo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Iyesus dabt hank'o bíeti, «K'osh jewro k'ewere, woyni mitwotsi tokts ash iko fa'e b́tesh, bí b́ weyini mit gúratse kas'o kas'bk'ri, weyini fis'eet gop'o ishdek't b́doozi, weyini kotosh wotit kaki geenzo agb́k'ri, maniyere hakon mitwots beyoko goshtswotssh kirayik'rat k'osh datso maants k'az bí'ami. ");
INSERT INTO bwo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mit shuwi woro b́bodtsok'on b́ bano bísh bodek'etwok'o b́ guutswotsi goshtswotsok b́woshi. ");
INSERT INTO bwo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Goshtswotsmó guutswotsi detsdek't iko botogi, iko boúd'i, k'oshonowere shútson botogi. ");
INSERT INTO bwo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Weyini mitwots doonz ando botaawo baltswotsiyere bogts k'osh guutswotsi aaniy b́woshi. Goshtswots boatsowere baltswotskok'o bo fini. ");
INSERT INTO bwo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Jamoniyere il weyni miti doonzo ‹T naayno mangitunee!› eton b́ naayi goshtswotsok b́ woshi. ");
INSERT INTO bwo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ernmó goshtswots b́ naayi bobek'tsok'on ‹Hanwo naatetwoniye›, woore úd'k'rar b́ detstsono naarde'onee!» boet. ");
INSERT INTO bwo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","B́ naaynowere weyini miti beyokoniyere ur dek'amt úd'bok'ri. ");
INSERT INTO bwo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","«Eshe, weyini mitwots doonz b́woor goshtsanotsi eeg b́k'alitwok'o arefa itsha?» ");
INSERT INTO bwo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bowere «Gond ashmanots s'uwatse boon gondo bek'shr t'afik'ritwe. Weyniy miti beyokonowere b́ shwono finde woor woron bísh kayitu goshts k'oshwotssh kiraayi b́k'riti.» boeti. ");
INSERT INTO bwo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Manats dabt́ Iyesus hank'owa bíeti, «S'ayin mas'aafotse ‹Ginbiyon maa agfwots bo gac'ts shútso bíye shúts kup'o tungúshatse kaatsde detsetwo b́woti, Hanwere doonzo finoniye, no ááwwotsshowere adike,› ett guut'etso b́ jamon nababeratsteya? ");
INSERT INTO bwo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«Eshe hank'o etirwe itsha, Ik'i mengsto itatse de'er shuu shuwitu ashuwotssh imetwe.  ");
INSERT INTO bwo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Shútsanats dihitwo tishitwee, shútsman bíatsats b́ dihit ashonmó gaans'eetwee.» ");
INSERT INTO bwo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kahni naashwotsnat ferisawino eteetswots jewretsanotsi boshishtsok'on Iyesus b́ keew bo jang b́wottsok'owo t'iwintsbodek'i. ");
INSERT INTO bwo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Mansh bín detso geyatni botesh, ernmó ash asho bín nebiyiyok'o bos'ilfotse shatbowtsi. ");
INSERT INTO bwo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iyesus aaniy hank'o ett jewron boosh b́keewfere b́teshi, ");
INSERT INTO bwo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Dari mengsto b́ na'osh jiwu k'anits nugúsoniye biariye. ");
INSERT INTO bwo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nugúsman b́ jiwok b́ s'eegets ashuwotsi boweetwok'o gawiyosh b́ guutswotsi bomaants b́woshi, ashuwotsmo jiwman maants wosh geratsno. ");
INSERT INTO bwo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","«Nugúsman k'osh guutswotsi aaniy hank'o ett b́woshi, ‹S'eegets ashuwotsok amrniye, Hamb, jiwosh meetwonat úshetuwone k'anik'rere minz gatwotsnat k'otsts shopwotsi shúkk'reree, jam keewo k'anwtsere, mansh jiwi moonat úshok woore!› err boosh keewwore. ");
INSERT INTO bwo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Boomó keewman aatsni k'rat bokaat kaaton iko b́ goshomand iko b́ jaakomand bíami. ");
INSERT INTO bwo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Oortswotswere b́ guutswotsi detsdek't ketiyon jot'dek' boúd'i, ");
INSERT INTO bwo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Manoor nugúso fayat kes' kes'f bíkwotsi woshat úd'ts manotsi úd'iibk'ri. Bo kitinowere tawon bo mitsitwok'o b́woshi, ");
INSERT INTO bwo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Maniyere il b́ guutswotssh hank'o bíeti, ‹Hamb, jiwi moonat úshon k'anwtsere, s'eegetswotsmo jiwansh woteraniye orernee. ");
INSERT INTO bwo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mansh weerindatse amr itdatsts ash jamo jiwi moonat úshomand s'eere.› ");
INSERT INTO bwo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","B́ guutswotswere weer weerats amt bodaatsts ash jamo gondwotsno, sheengwotsnowere kakubok'ri, mann jiwi maa eeno s'eegetswotsn s'eenb́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Ernmó Nugúso s'eegetswotsi s'iilosh jiwi maa eenots b́kindtsok'on, manoke jiwi taho taheraw iko bek'b́k'ri. ");
INSERT INTO bwo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Bísho hank'o bíeti, ‹T masho, jiwi taho ntaherawo aawk'oneya hanok n kindi?› ash manwere s'ik bí eti. ");
INSERT INTO bwo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nugúsonwere b́guutswtssh, ‹B́ kishonat b́ tufoon tifde'er kishr úratse fa'a t'aluwots juwore, manoknowere eeponat gash k'ashone wotiti› bíet.» ");
INSERT INTO bwo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Manats dabt́ Iyesus «Eshe, s'eegetswots aynee, bitsere marat'etswotsmó múk'nee.» ");
INSERT INTO bwo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Maniyere hakon ferisawino eteefwots amt aawk'o k'alr Iyesus noono b́ keewor bín bodetsetwok'o boshiyeyi, ");
INSERT INTO bwo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bo danifwotswere, Herodis ashuwotsnton Iyesusok woshat, «Danifono, neehe arkeewetso nwottsok'onat Ik'o weerindo arikon ndaniyirwok'o danfone ash shatonowere nk'aliru keewo aaliye, ashonat ashi dagonowere boga bogshratsnee.» bísh bo etiyakon, hank'o ett boaati. ");
INSERT INTO bwo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","«Aab́ noosh keewwe neesh eeg arefa? Rom nugúsosh ereero dasho nemeemó nemaalnee?» ");
INSERT INTO bwo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Iyesusmó bo gondo dank'rat, «It it took danawwotso! eegoshe tiyatse t'awo it geyiri? ");
INSERT INTO bwo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ereerosh dasheyiru gizo aab taash kitswere!» bíet. Mansh bo ik dinariyo dek'wat bísh bokitsi. ");
INSERT INTO bwo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Bíwere, «Aranatse dozets aronat guut'ets shúútson konke?» eton boon bíaati, ");
INSERT INTO bwo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bowere, «Rom dats nugúsoke!» boeti, bíwere, «Eshe nugúsoko nugúsosh, Ik'iko Ik'osh imere,» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bowere bín bok'ebiyakon b́ keew keewatse tuutson adt k'azk'rat boami. ");
INSERT INTO bwo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Manots aawots, «K'irtswots k'irotse tuwo aaliye» etef Seduk'awino eteefwots Iyesusok waat hank'o ett bín bo aati, ");
INSERT INTO bwo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Danifono! Muse ‹Ik asho na'o b́shurawo k'iron b́ maatswatse b́ k'aleyal k'irts eshuwo máátsu de'er k'irtsosh shááto shegrshwee,› etre. ");
INSERT INTO bwo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Shawat eshuwots nooke fa'ane boteshi, jamwotsitse k'aabo máátso dek't na'o b́shurawo k'irb́wtsi, mansh bíeshu muk'efo k'irtso máátsu b́dek'i. ");
INSERT INTO bwo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mank'o gitlonú, keezlonú shawatlok b́borfetso tar taron bin dek't bok'iri. ");
INSERT INTO bwo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Jamoniyere il máátsman k'ir b́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Eshe, shawatwots bin bodek'tsotse k'irtswots botuwor mááts b wotit aawshe?» ");
INSERT INTO bwo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Iyesusmó hank'o ett boosh bíaaniy, «It s'ayin mas'afwotsnat Ik'i ango it danawotsnee it sheliri. ");
INSERT INTO bwo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","K'irtswots k'irotse botwots darotse fa'a melakiwotskok'owa bowotiti bako de'atsno, de'eratsne. ");
INSERT INTO bwo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","K'irtswots tuwi jango itsh Ik'o b́ keewtso nababeratsteya? ");
INSERT INTO bwo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Bíye hank'owe bíeti, ‹Taa Abraham Ik'o, Yisehak' Ik'o, Yak'ob Ik'o taane› Mansh Ik'oniye kashetswots Ik'a bako k'irtswots Ik'aliye.» ");
INSERT INTO bwo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ash ashonwere man boshishtsok'on b́ daniyatse tuutson boad. ");
INSERT INTO bwo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Iyesus Seduk'awino etefwotssh noono boaanirawok'o woshdek't s'ik boetetuwok'o b́ wosho boshishtsok'on ferisawino eteyirwots ik wotdek't kakwe bowtsi. ");
INSERT INTO bwo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Boyitsnowere nemo danif iko, Iyesusi fado geeyat hank'o ett bíaati, ");
INSERT INTO bwo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Danifono! nemotse jamoniyere bogts tzaziyo aawne?» ");
INSERT INTO bwo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Iyesuswere hank'o ett bísh bíaaniy, «‹Doonzo n Ik'o Izar Izeweri n níb s'eenon, n kash jamon, n maac' s'eenon shune,› ");
INSERT INTO bwo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jamoniyere bogetsonat shints tzaziyo haniye. ");
INSERT INTO bwo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Hanowere artso gitl tzaziyo ‹K'osh asho n tookok'o woshde'er shune,› etirwoniye. ");
INSERT INTO bwo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nemonat nebiywots daniy jamo tzazi gitetsanotsatś need' dek'kne.» ");
INSERT INTO bwo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ferisawino eteefwots kakuwedek't bobefere Iyesus hank'o ett boon bíaati, ");
INSERT INTO bwo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Krstos jango eege it etiri? kon naayi arefa itsha?» boowere «Dawit naayiye» ett bísh boaaniy. ");
INSERT INTO bwo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Iyesuswere boosh hank'owa bíet, «Beree, Dawit Ik'i shayiron jisheyat b́ keewor eegoshe ‹Doonza!› et bín b́s'eegi? ");
INSERT INTO bwo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Bí ‹Doonzo t doonzsh: n balangarwotsi ntufishirots t woshfetsosh t k'anomaants beewe!› bíet. ");
INSERT INTO bwo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Eshe Dawit b́ tookon ‹Doonza› ett b́s'eegyhakon bere Krstos aawk'oneya b́ naayi woto b́faliti?» ");
INSERT INTO bwo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mann dab ik nonunor bísh aaniyosh faltso aali b́tesh, manots aawoniyere hakon bín aatosh aaw shúk'tso konúwor aali b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Maniyakon Iyesus ash ashonat b́ danifwotssh hank'o ett b́ keewi, ");
INSERT INTO bwo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Nemo danifwotsnat ferisawino eteefwots Muse jorats bedek'rne. ");
INSERT INTO bwo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mansh eshe bo itsh bo keewts jamo k'alwere, korde'ere, bo bofinirwonmó fink'ayere, bo bokeewirwo finats jitsraknee, ");
INSERT INTO bwo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Mangonat kic'its kuro tipdek't ash mangrats bokurifoni, botookishomó bojaabon t'awiyosh dab́ geeratsne. ");
INSERT INTO bwo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bofin jamo asho boon b́bek'etwok'owa etniye bofiiniri. Ik'o bok'onor kitabiya genzit bo gawintsiri, Ik' nem kotirwok'o botahefonowere b́ guuratsi s'aaro shipdek'tni bo geenzifoni, ");
INSERT INTO bwo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Jiwoke mang beyoko, ayhudiyots Ik' bok'onf mooke shints beyokoniye detso boshunfoni. ");
INSERT INTO bwo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Jebatsnowere ash jamo boosh gup' gup'aar jamo boon aatr ‹Danifono!› err bo s'eegetuwok'owe bogefoni, ");
INSERT INTO bwo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Itmó itko danifo ik s'uzo b́wottsotsnat it jametswere esshwwotsi it wottsotse ‹Danifono› eteyar s'eegek'ayere. ");
INSERT INTO bwo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ando aaniy it itdetsts niho darotse ik s'uzo b́wottsosh datsatse konnor ‹Nihono› err s'eegk'ayere. ");
INSERT INTO bwo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Iti danirwo Krstos s'uzi b́wottsosh ‹Daniruwono› err s'eegeyo k'ayere. ");
INSERT INTO bwo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ititse eeno it guutso wotowe. ");
INSERT INTO bwo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","B́ tooko dambaan detsetwo dashan aanitwe, b́ tooko dashan detsetwo dambaan wotitwe.» ");
INSERT INTO bwo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Asho dari mengstots b́ kindrawok'o, b́ fengesho is'iruwots it itgit alberetswotso, nemo danifuwotsnat ferisawino eteefuwotso! indowe itsha! it ittokoosh bíts kindratste, kindosh geyirwotsnowere bokindrawok'o bazirutee!  ");
INSERT INTO bwo_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nem danifuwotsnat ferisawino etfwotso, be'ewosha etaat geenzidek'at Ik'o it k'onirwats weebdek'at t'oow máátsuwots detstso ishbaziruwotso indowe itsha! manshe itatse ikibog angsho bodetuwe. ");
INSERT INTO bwo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","It took danaw nem danifwotsnat ferisawiwotso! indowe itsha! ayhudi woteraw ash iko ayhudi imnetiyo maants woniyosh datsatsno aats k'aratsno sha'at it gúriri, kindsh itdek'tsok'onowere, itiyere gitkisho ikibogo gahanemsh k'antso woshirutee! ");
INSERT INTO bwo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«It jishiru dooguwotso! indowe itsha! ‹Asho Ik' k'oni moon b́taariyale, eegor woteratse› etfte, ‹Ik' k'oni mootsi awntson b́ taariyalmo taarman bín detsetwe› etirute, ");
INSERT INTO bwo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","It shiyawwotsnat doogwotso! awntsonat awnts s'ayintsitu Ik'i mootse ááw bogfa? ");
INSERT INTO bwo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mank'o ‹Asho wosho t'intseyiru bewokoki t'arap'ezon b́ taariyal eegor woteratse,› woshman t'intseyiru k'ac'atse fa'a woshon b́taariyalmó taaro bín detsetwe etirute. ");
INSERT INTO bwo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","It doogwotso! woshonat woshman s'ayintsitu wosh t'intseyiru t'arap'ezoniyere ááw bogfa? ");
INSERT INTO bwo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Eshe wosh t'intseyiru t'arap'ezon taarirwo, wosh t'intseyiru t'arap'ezonat wosh t'intseyiru t'arap'ezatse fa'a keew jamone b́taariri. ");
INSERT INTO bwo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ik' moon taarituwo, Ik' moonat Ik'mootse fa'a Ik'one b́taariri. ");
INSERT INTO bwo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Daron taaritwonwere Ik'o mangi jooronat b́ jooratse beyirwonee b́ taariri. ");
INSERT INTO bwo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«It git alberets nem danifwotsnat ferisawiwotso! indowe itsha! arshudiko, k'ushuwiko, orobrikono tatslo imirutee, ernmó nemotse een eenwotsi k'azniye it k'riri, boowere kááw angshwotsi, orowe etonat amanetso wotoniye, ekeewi itk'ayawo hanoor k'alo itn geyife b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","It jishiru doogwotso! it úshiru jamwotso s'ungok'o muk'nana'a wottswotsi s'aldek'at it juwiri, kambulok'o een keewonmó it k'oot'iri! ");
INSERT INTO bwo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«It git alberets nemo danifwotsnat ferisawiwotso! indowe itsha? B́rc'k'onat saniyon úriweertso s'ayintsirute, b́ gitsonmó biik'onat jaalon bín s'eenke, ");
INSERT INTO bwo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nee dog ferisawiyono! shin shino brc'uk'onat saniyon b́ gitso s'ayintswee, manoor b́bootsonúwere s'ayin wotituwe. ");
INSERT INTO bwo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«It git alberets nem danifwotsnat ferisawiwotsn indowe itsha! bogitsotse ash duuni mak'tsonat kim keewo bítse s'eents, bo úronmo nora eteets nas' k'alamiyo fuutere sheengiru doowwotsiye it ariye. ");
INSERT INTO bwo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mank'owere it, úratse ashosh ash kááwo araatniye it be'eyiri, it gitsonmó git alberetsonat gondo s'eenwtsere. ");
INSERT INTO bwo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«It git alberets, nem danifwotsnat ferisawiwotso! indowe itsha! it nebiywots dowoniye it agiri, k'irts kááwwots hawltiyoniye it shengshiri. ");
INSERT INTO bwo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","‹Nonih shintswotsntoni noteshi wotink'ere nebiyiwots s'atso kuut'r bonton ikwoterawnk'one b́teshi› etirute. ");
INSERT INTO bwo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Eshe, nebiyiwotsi úd'ts ashuwots nana'o it woto it tookon gawirute. ");
INSERT INTO bwo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Eshe, it nihots dek' botuutso it were s'eentswere. ");
INSERT INTO bwo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","It dawnzwotso, dawnz nana'úwotso, gahanemits fayotse aawk'o k'alrniya oorosh it faliti? ");
INSERT INTO bwo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mansh hamb, taa nebiyiwotsi, dantelefetswotsi, danifwotsi it maants dowittwee, boyitse ik ikuwotsi úd'itutee, ik ikuwotsi jitetutee, ik ikwotsnowere bo Ik' k'oni mootse togetute, ik kitotse ik kitomaad gishitutee. ");
INSERT INTO bwo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Manatse tuutson kááwo Abeel s'atsatse de'er Ik'i moonat wosh t'intseyiru t'rap'ezi dagotse it úd'tsok b́ borfetsosh Berakiyu naay Zekariyas s'atsats b́ borfetsosh datsats kud'ts kááwwots s'atsatse tuuts fayo itatsatse b́bodeti, ");
INSERT INTO bwo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Arikoniye itsh tkeewiri, fay jamaaniye, and dúranatse shuwetsanotsats bodetwe.» ");
INSERT INTO bwo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Manats dabt́ hank'owa bíet, «Iyerusaleme, Iyerusaleme! nee nebiywotsi úd'irunee! nmaants woshetswotsi úd'at shútson togirunee! baaku b nana'o b gop'shots b kakufok'o, taawor n nana'o ikok kakuwosh ambtsote t geyi! itmó geratste. ");
INSERT INTO bwo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Eshe hambe, it moo bashar oritwe. ");
INSERT INTO bwo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Manshe ‹Doonzo shútson wetuwo deereke› it erfetsosh haniye il taan be'atste etirwe.» ");
INSERT INTO bwo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iyesus Ik' mootse kesht bíamfere b́ danifwots Ik' maa gmbiyo kitsosh b́ maants bot'iini. ");
INSERT INTO bwo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Bíwere «Jaman bek'irute? Arikone itsh tkeewiri, shúts iko ikats b́kororetsok'on gaaheraniyere ooritwo aaliye» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Debre zeyiti guratse Iyesus b́ befere b́ danifwots bo aal b́ maants t'int «Jam keewan b́wotit awre? N woonat dúri s'uwi milikito eebi?» ett boaat. ");
INSERT INTO bwo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iyesus hank'o ett boosh bíaani «Konwor asho itn b́darirawok'o itatso korde'ere! ");
INSERT INTO bwo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Aywots ‹Taa Krstos taane!› etfere t shútson weetune, ay ashuwotsnowere daritúnee. ");
INSERT INTO bwo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kes'i k'aaronat kes'i keewon shishetute, jaman b́ wotitwotse tek'k'ayere, b́ s'uwonmó borafa'ee. ");
INSERT INTO bwo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Asho ashaats tuwitwee, mengstonúwere mengstats kes'osh tuwitwe, besh beshar ik ik datsatse k'ak'onat dats shek'ewo wotituwe. ");
INSERT INTO bwo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Jaman na'a shuwo it'i shambo b́ tuuwortsok'oyiye. ");
INSERT INTO bwo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Manoor ash ashuwots iti gondbek'osh beshide'er imetúnee, iti úd'itúne, t shúútsosha err ash jamwotsoke shit'eek wotitute. ");
INSERT INTO bwo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Manoor aywots bo amantso haalar shuuts aanitune, iko iko beshide imetwe, ashuwots boatsatseyewo shit'etune. ");
INSERT INTO bwo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kootets nebiy aywots tuwitune, aywotsnowere shelitune, ");
INSERT INTO bwo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Gondo b́ aytsatse tutson, ay ashuwots shuno aak'wtsitwe. ");
INSERT INTO bwo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","S'uwaats b́borfetso k'amde kup'itwonmó kashitwe. ");
INSERT INTO bwo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ash jamosh gaw b́ wotitwok'o Ik'i mengsti doo shishiyan dats jamatse nabeetwe, manoor dúr s'uwo weetwe. ");
INSERT INTO bwo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Nebiyiyo Dan'el b́ keewtsok'on kiimshitu wic'its keewo S'ayin beyokoke b́ need'efere it bek'ore nababirwo man t'iwintsde'e! ");
INSERT INTO bwo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Manoor Yihud datsatse fa'úwots guromats woc'nee. ");
INSERT INTO bwo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Maa tokatse fa'o ik jagdek'osh oot'k'aye. ");
INSERT INTO bwo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Goshifokon fa'onúwere b́ tah dek'osh shuuts aank'aye, ");
INSERT INTO bwo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Manoor na'i maac'wotsnat na'a s'aatsirwotssh indowe boosha? ");
INSERT INTO bwo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","It giifi aawo jooshonat s'anbati aawon b́woterawok'o Ik'o k'onwere! ");
INSERT INTO bwo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Manoor datsu bíazeron tuut hambetsish b́borfetso wotdanawo, shinomaantsowere man artso b́ jamon woteraw gond bek'i eeno wotitwe. ");
INSERT INTO bwo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Aaw manots k'awuno bok'azink'ere ik ashonwor kasho falrawnk'e b́teshi, ernmó marat'ets ashuwotssha err aaw manots k'awnetúne. ");
INSERT INTO bwo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«Manoor asho konúwor wotowa ‹Hambe, Krstosiye hanoke fa'e!› wee ‹ekewoke b́ fa'oni!› itsh bíetal amank'ayere. ");
INSERT INTO bwo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kootets Krstosotsnat kootets nebiyiwots tuwitune, bo boosh b́ faleyal Ik'ik marat'etswotsnoor dab́ dariyosh een een adits keewwotsi kitsitunee. ");
INSERT INTO bwo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","«Eshe, keew jaman shin shino itsh keewre, ");
INSERT INTO bwo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Mansh ‹Ekebe worwotse b́ fa'oni!› itsh bo etal keshk'ayere, ‹Hambe aashts bewokoke b́fa'oni!› bo etal amank'ayere. ");
INSERT INTO bwo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Guumo darotse b́p'ark'or aaw keshon túút aaw kindon b́ be'efok'o, ashna'o woonúwere mank'o b́wotiti. ");
INSERT INTO bwo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Duuni beyok k'oorwots kakwetúnee.» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Gond bek'i aaw manotsiyere okoon manoor aaw t'alu wtsitwanee, aashitsunwere bshaano kitsatsane, k'eenwotswere darotse fed's'uwitúnee, darotsi angwotswere shek'etúnee. ");
INSERT INTO bwo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Maniyere il Ash na'o milikito daaratse be'etwe, manoor datsatse fa'a ash naarwots eepetúne. Ash na'onwere angonat een mangon dawnats wotde b́woor bek'etúnee. ");
INSERT INTO bwo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","B́ melakiwotsi gaati k'aari eeno bo shishitwk'o b́woshiti, boowere datsatse awd kaaton amr dari daaratse tuur dari daaratse fa'úwotsi bík galdek'ets ashuwotsi kakwitúne.» ");
INSERT INTO bwo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Belesi mit jewro dano itsh wotowe, b jaabwots s'uup kisho de botuuworonat b maarwotswere bo átor, manoor k'aawo b́t'intsok'o danfte. ");
INSERT INTO bwo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mank'owere jaman it bek'or ashna'o b́weyi aawo b́karntsok'o dande'ere. ");
INSERT INTO bwo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Arikoniye itsh tkeewiri, jaman b́ wotefetsosh and dúri s'oot' jaman besheratse. ");
INSERT INTO bwo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Daronat datson beshitke, ti aap'tsonmó besheratse.» ");
INSERT INTO bwo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Aawman jangonat sa'atmanmó nihoniyere okoon k'osho daritsi melakiwotsi wotiyalor, naayonu b́wotiyal, konúwor dantso aaliye. ");
INSERT INTO bwo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noh dúri wottsi naaro, ashna'o b́woorowere mank'o wotitwe. ");
INSERT INTO bwo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mandúr, t'afits aatsoniyere shino Noh markabuts b́kindfetsosh, ashuwots mafetst, boúshfetst, máátsono dek'ifetsit de'ifetsntni botesh. ");
INSERT INTO bwo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","T'afits aatso waat jametso fok b́dek'fetsosh datso danatsno b́tesh, ashna'o woonúwere arikon mank'oye b́wotiti. ");
INSERT INTO bwo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Manoor git ashuwots goshoke towaar finitúno. Iko k'aaú dek'etwe iko oritwe. ");
INSERT INTO bwo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mááts gitwots towaar dio di'itno, ikú k'aaú dek'etwe, ikú ooritwaniye. ");
INSERT INTO bwo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Eshe it doonz egoots b́weetuwok'o it danawotse kup'de korere. ");
INSERT INTO bwo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ernmó han dande'ere, moo doonz t'úwotse aawk'o sa'aton úmp'etso b́ weetwok'o b́ danink'ere, tuur kordek'ank'e b́teshi, b́ moonúwere b́ ishetwok'o k'ayk'rerawnk'e b́teshi. ");
INSERT INTO bwo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mank'o Ashna'o it gawraw sa'aton b́weetwotse k'ande'er beewere. ");
INSERT INTO bwo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«B́ maa ashuwotssh bo misho balon b́ imetwok'o, b́doonz b́meytsi ashuwotsats b́ naashitwo amanetsonat s'ek guutso kone? ");
INSERT INTO bwo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","B́ doonz b́waafere mank'o b́ finefere b́daatsit guutso deereke. ");
INSERT INTO bwo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Arikoniye itsh tietri, guutsman b́detsts dets jamatse naashini b́k'ritiye. ");
INSERT INTO bwo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Morrgond guuts manmó, ‹T doonz waraniyere ja'itwee› err gawr ");
INSERT INTO bwo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","bínton finiru b́tohuwotsi jot'o b́ tuwiyal mashtswotsntonwere maar b́ úshetka wotiyal, ");
INSERT INTO bwo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Guuts man doonz b́ gawraw aawonat b́danaw sa'atone b́ weeti, ");
INSERT INTO bwo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Guutsman doonz guutso tooko kawlni b́k'riti, b́ hit'onúwere git alberetswotsntone b́ woshiti, manoor eeponat gash k'ashone wotiti.» ");
INSERT INTO bwo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Manats dabt Iyesus hank'o etre, «Manoor dari mengstu boc'eesho detsdek't guuyo kotosh keshts baar nana'a tatswotsiye biari. ");
INSERT INTO bwo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Boyitse utswots wihno, útswots s'ekno botesh. ");
INSERT INTO bwo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Baarnana'a wihiwots bo c'eesho deshbodek'alor c'eeshmansh wotit zeyito k'osh zeyiti k'ac'ots detsde'atsno. ");
INSERT INTO bwo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Baar nana'a s'ekwotsmó bo c'eeshonton k'osh zeyito k'ac'ots detsdek'tni botesh. ");
INSERT INTO bwo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Guuyman b́ teshtsotse jametswotsats tokr gooro maawt k'eebowtsi. ");
INSERT INTO bwo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Taali tiits b́wottsok'onmó ‹Hambe, guuyoniye waare! keer de'ere!› etiru wac'ro shisheb́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Manoor baarnana'a jametswots tuut boc'eesho k'anibodek'i. ");
INSERT INTO bwo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Baar nana'a wihwots s'ekwotssh ‹no c'eeshó tahosh bí etirwotse oona itsha it zeyitatse noosh imere› boet. ");
INSERT INTO bwo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Baarnana'a s'ekwotsmó ‹Noonat itnsh bodet zeyito deshatsone. Maniyere suk'iyomand amŕ itsh wotit zeyito kewde'ere› ett boosh boaaniy. ");
INSERT INTO bwo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Baarnana'a wihiyots zeyit kéwo boami, manoor guuyo b́weyi. K'andek't beyiru barbarwots guuyonton jiwosh k'aniyets moonat úshi een moots kindbowtsi, b́ fengeshonúwere is'eeb́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ili oorts barwots wáát, ‹Doonzono! Doonzono! oona neesha! noosh k'eshwee!› boeti. ");
INSERT INTO bwo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Bímó ‹Arikoniye itsh tietiri, taa itn danatse!› ett boosh bíaani. ");
INSERT INTO bwo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Mansh bí aawonat b́ sa'aton it danawotse kup'de korere.» ");
INSERT INTO bwo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Iyesus hank'o ett k'osh jewron boosh b́ keew, «Manoor Ik'i mengstots kindi jango hank'owa b́ wotiti, k'osh dats amet ash iko b́ guutswotsi s'eegt b́ detstso boosh bímts naarok'owe bíari. ");
INSERT INTO bwo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Doonzo ik ikwotssh bo faltsok'o boosh b́ kayi, ikosh úuts meklityo, ikosh git meklityo, aani ikosh ik meklityo imt k'osh datso maants bí'ami. ");
INSERT INTO bwo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Úúts meklityo dek'tso manoor amt́ bín jaakt k'osh úuts meklityo b́ orshi. ");
INSERT INTO bwo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Git meklity dek'tso ando mank'o k'osho gitmeklityo oorshb́dek'i. ");
INSERT INTO bwo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ik meklit dek'tsonmó amt́ datso ishdek't b́ doonz gizo duukb́k'ri. ");
INSERT INTO bwo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ay aawo b́beshiyak guuts manots doonz waat b́gizo guutsmanotsnton taano dek' b́twu. ");
INSERT INTO bwo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Úúts meklityo dek'tso b́ doonzok waat úuts meklityo t'intst ‹Doonzono! úuts mekilitiyo taash imrne b́ teshi, hambe! k'osh úts meklitiyo oorshre!› bí eti. ");
INSERT INTO bwo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","B́ doonzuwere ‹Sheengo finrnee, nee dówónat amanets guutsono! múk' keewatse amanek wotat ndatsetsotse ay keewatse neen naashitwe, waakindr n doonz gene'úo kayde'e!› bí eti. ");
INSERT INTO bwo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Git meklitiyo dek'tso t'int ‹Doonzono git meklitiyo taash imrne b́teshi, hambe! k'osho git meklitiyo oorshre!› bíet. ");
INSERT INTO bwo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","B́doonzwere ‹Sheenge! nee amanetsonat sheeng guutsono muk' keewatse amanek wotat ndatsetsosh ay keewatse neen naashitwe, wowe ndoonz gune'úo kayde'e› bíet. ");
INSERT INTO bwo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ik meklitiyo dek'tsonwere t'int, ‹Doonzono! n shohawo k'es'etwo, n bad'irawoke kakuwit, maac'kup' asho nwottsok'oo danfee, ");
INSERT INTO bwo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mansh shatat amaat ngizoo datso ishdek'at duuktk'ri, hambe ngizooni!› bíet. ");
INSERT INTO bwo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","B́ doonzmó hank'o bíet, ‹Nee gondonat wih guutsono! t shohawoke t k'es'etwok'o t bad'irawoke t kakuwitwok'o n danka wotiyal, ");
INSERT INTO bwo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tgizo bankiyots gerk'ro neen geyife b́teshi, taa t waatsok'on t gizo b́shuwonton tdek'ank'oni. ");
INSERT INTO bwo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Erere ambarman de'er tats mekliti detstsosh imere. ");
INSERT INTO bwo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Detsts ashosh dabeetwe bíkonu aytwe, deshaw ashoknomó b́detstso dab de'e wútsetuwe. ");
INSERT INTO bwo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Woteraw guutsanmó úratsi t'aluwo maants kishde juwore, manokno gash k'ashonat eepon wotitwe.› ");
INSERT INTO bwo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Ash na'o b́ melaki jamwotsn jisheyar mangon b́woor b́magi jorats bedek'etwe, ");
INSERT INTO bwo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ash jamwots b́ shinats bokoeti, jintso mererwotsi eyshotse b́ galtsok'o bíwere ashuwotsi bo ik iketsatse gal b́dek'eti. ");
INSERT INTO bwo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mererwotsi b́ k'anomaantsan, eyishwotsi b́ giromadan b́ned'iti. ");
INSERT INTO bwo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Manoor nuguso b́ k'anomaantse faúwotssh hank'o bíeteti, ‹It tnih deertswotso! woore! datso bí azewori itsh k'ants mengtsto naarde'eree! ");
INSERT INTO bwo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","K'ak'at t teshor taan manzrtee, shashuwat t teshor taash ishrtee, ib wotat twaare it moowotse taan dek'at ibirtee, ");
INSERT INTO bwo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Araatsat tteshoor, taash taakrte, shodat tteshor tshodo fadrte, tip'eyat tteshor wáát taan aatrte.› ");
INSERT INTO bwo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Manoor kááwwots hank'o err bísh aanitune, ‹Doonzono, awure nk'ak'ere bek'aat neesh nomaanzi? Awure nshashwre bek'aat shashuwo neen nokishi? ");
INSERT INTO bwo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Awure ib n woto bek'aat nee noíbíyi? Awure ni aratsere bek'aat neesh notaki? ");
INSERT INTO bwo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Awure nshoore wee ntipere bek'aat waat neen nos'iili?› ");
INSERT INTO bwo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nugúsonwere ‹Arikone itsh tkeewiri, t eshwanotsitse muk'na'a ikosh itk'alts jamo taash it k'altsok'oyiye!› eton boosh bí aaniyiti. ");
INSERT INTO bwo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Maniyere il b́ giri aaromantse fa'uootssh hank'o bí eteti, ‹It c'ashetsanotso! tiatse okaan wokoore! Diyablosnat b́ shutsats sha'iru b́ melakiwotsnsh k'aniyets dúre dúri tawo maants ameree! ");
INSERT INTO bwo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","K'ak'atniye tteshi taan maanzratste, shashuwaatniye tteshi taan shashuwo kishatste. ");
INSERT INTO bwo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ib wotat waare b́teshi, taan ibiratstee, it mootse araatsatniye tteshi taash takratstee, shodatnu tipeyatnu t teshi taan aatratstee,› ");
INSERT INTO bwo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Bowere ‹Doonzono, k'ak'at wee shashuwat, ib wotat wee aratsat, shodat wee tipeyat ni'ere awre bek'aat neen tep'o no k'azi?› Err aanitune. ");
INSERT INTO bwo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nugúsonwere ‹Ariko itshi keewirwe, t eshwanotsitse muk'na'a wotts ikosh it k'alk'aztso taash it k'alrawok'oyiye› bíeteti. ");
INSERT INTO bwo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Mansh hanots dúre dúri t'afomand boamor, kááwwotsmó dúre dúri beyo maantsane boameti.» ");
INSERT INTO bwo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iyesus jam daniyo daniy b́k'rtsok'on b́ danifwotssh hank'o bíeti, ");
INSERT INTO bwo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Git aawoniyere okoon fazigi baaliyo b́wotitwok'o danfte, Ash na'onwere jitewosh besheyarr imetwe.» ");
INSERT INTO bwo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Manoor kahni naashwotsnat ashuwotsitse eenashwots kahni naashi naasho K'eyaf múúlotse kakwebowtsi. ");
INSERT INTO bwo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Manoknowere Iyesusi málon deshde boúd'itwok'o mál bok'ri. ");
INSERT INTO bwo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ernmó, «Ashuwots dagotse fayo b́tuurawok'o baaliy aawon wotk'aye» boeti. ");
INSERT INTO bwo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iyesusmó, Bitaniyi datsatse een shodets teshtso Sim'on mootsna b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Manoknowere Iyesus mishi maratse b́befere mááts ikú b́k'awntso ayidek' shaaw wotts shitúwo bín s'eents albast'rosiya eteets shútson dozets b́lk'at'iyo dek'at b́ maants bt'iini, shitú manowere b́tokats b kuut'i. ");
INSERT INTO bwo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","B́danifwots man bek't fayat hank'o boeti, «Shitúwan eegishe hank'o datsmec'ron b́ t'afiri? ");
INSERT INTO bwo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Shitúwan ay gizosh kemeyar t'owwotssh imo faleyank'e b́teshi!» ");
INSERT INTO bwo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Iyesuswere hank'o boetirwok'o dank'rat boosh hank'o bíeti, «Máátsani eegoshe it kic'iri? Biye taash sheeng keewo k'alraniye, ");
INSERT INTO bwo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","T'owwots úni aawo itoke bofa'oni, taamó jam aawo itnton hanoke beeratse. ");
INSERT INTO bwo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Bi shitúwan tiats b kuut'o taan duukeyorish k'aniyoshee. ");
INSERT INTO bwo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Arikon itsh keewirwe dats jamatse doo shishiyan b́keewetsoke bi b k'altson bin gawetwok'o bjango keewetwe.» ");
INSERT INTO bwo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Manoor tatse gitwotsitse ik wottso Keriyot dats asho Yhud, kahni naashwots maants amt, ");
INSERT INTO bwo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","«Iyesusi itsh beshide'er ti imal taash eege it imeti?» bíet. Bowere shaash t'agaro bo imi. ");
INSERT INTO bwo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Manoori sa'aton dek' tuut Iyesusi beshide b́imet sheeng aawa b́ geefoni b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tush meyi baaliyots shints aawots b́ danifwots Iyesusok t'int «Fazig ba'aliyi kooc' misho aawoke neesh nok'aniytwok'owe ngeyi?» ett boaati. ");
INSERT INTO bwo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Bíwere «Kitots itkindor it daatsit asho galok amr ‹Danifo tiaawo b́t'intsotse t danifwotsnton fazigi kooc'misho t meet nmootsnee etfe› erere» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","B́ danifwots Iyesus boosh bí ettsok'o bok'ali, fazigi kooc' misho bo k'aniyi. ");
INSERT INTO bwo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Datso b́iltsok'on Iyesus tatse git woshetswotsnton kooc' mishi marats beeb́dek'i. ");
INSERT INTO bwo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bomafero Iyesus, «Arikoniye itsh t keewiri, ititsi ikoniye taan beshide imetwe» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","B́ danifwots b́ keewts manatse tuutson aydek't shiyanat ik ikon, doonzono, «Taa wotifta?» ett aato dek' botuwi. ");
INSERT INTO bwo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ieyesuswere hank'o ett boosh bíaani, «Taan beshide imetwoniye taanton tohaat b́kishon sahaniyotse ito itdek'irwoniye. ");
INSERT INTO bwo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ash na'o b́ jangosh guut'etsok'on k'iritwe, ernmó Ash na'o beshide imet ashmansh indowe bína! ash man shuweraniye b́oorink'ee bísh k'anefe b́ teshi.» ");
INSERT INTO bwo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Bín beshide imetwo Yhudwere, «Danifono! taane k'uwa b́ wotiti?» bí eti. Iyesuswere, «Nee nittsok'oyiye» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bo mafere Iyesus tushman k'a'údek't b́deeri, tiitsdek't b́ danifwotssh, «Nahere mooree han tmetsoniye» ett boosh bí'imi. ");
INSERT INTO bwo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Wanc'mano k'aúdek'́t Ik'o údon b́ k'oniyakon hank'o ett boosh bí'imi, «It únets wanc'anitse úyeree, ");
INSERT INTO bwo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Han ay ash morro oorowe eti jangon taarewosh kuud'it t s'atsoniye. ");
INSERT INTO bwo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Tnihi mengstotse weyni shwi fíís' hanedro itnton túshet aawo b́ borfetsosh haniye okoon woyni shuwanatse fíís'otse gitlo úyatse etirwe,» ");
INSERT INTO bwo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Maniye il udi duubo duubt Debre zeyit guri abaats k'az bokeshi. ");
INSERT INTO bwo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Manoor Iyesus, b́ danifwotssh hanek'o bíeti, « ‹Jintso jot'etwee, mereer s'enwotsu bad'ni bowtsiti› ett guut'etsok'on t'uwanitse, it jametsanots taan k'ak'rar tiatse wos'etute. ");
INSERT INTO bwo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ernmó k'ironiye t tuwiyako itiyere shino Galil datso maants ametuwe.» ");
INSERT INTO bwo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Manoor P'et'ros, «K'osh jametswots dab neen k'ay boamal taa b́ jamon neen k'ayk'rar woc'atse!» ett b́ keewi. ");
INSERT INTO bwo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iyesuswere «Arikone neesh tietiri, hambets t'úwaanitse baako b́ k'adfetsosh keezoto taan haalitune» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","P'et'rosmó, «K'ira wotiyalor nenetoni t k'iriti bako b́ jamon neen haaleratse!» bíet. Oorts b́danifwotswere mank'o boet. ");
INSERT INTO bwo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Maniyere il Iyesus b́danifwotsnton Getesemaniy eteef beyokok bí ami, manok bobodtsok'on Iyesus b́ danifwotssh «Taa ekewok amr Ik'o t k'onfetsosh it hanoke betere» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Bínton P'et'rosnat Zebdiwos nana'a gitetswots b́ shutsatse dek't bíami, shiyanefetst kic'o dek't b́tuwi. ");
INSERT INTO bwo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Hank'owere boosh bíeti «K'iro tborfetsosh shiyanwtsere, it hanoke betere, tantonwere kup'ore.» ");
INSERT INTO bwo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Boyere muk'i okaan wokat amt́, datsats b́baron gup' gup'dek't, hank'o ett Ik'o b́ k'oni, «Nihono! faleetkawotiyal gondbek'i wanc'an tiyatsere ok beshowe! ernmó nee nshuntsok'owa bako taa t shuntsok'o wotk'aye.» ");
INSERT INTO bwo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Maniyere il b́danif keezwotsok aanat b́ waatsok'on bok'eefere boon b́daatsi, mansh P'et'rossh hank'o bíeti, «Taanton dab ik sa'atush kup'at it tokrerawon beyo falratsteya? ");
INSERT INTO bwo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Fadewots it kindrawok'o kup'de'er Ik'o k'onwere, shayiro arikon k'andek'kee, meetsonmó maawke.» ");
INSERT INTO bwo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ando aani gitlo Iyesus wokdek't amt «T nihono! gondbek'i úshi wanc'an t úyawon b́ besho faleratse wotiyal nee ni ettsok'o wotowe» ett b́ k'oni. ");
INSERT INTO bwo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ando aaniyi b́ danifwotsok aani b́ woor bo ááwo tokron maawt b́teshtsotse botookrefere boon b́ daatsi. ");
INSERT INTO bwo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ando aani boon k'azkraat amt shintsman aaniyi keewon keezlo Ik'o b́ k'oni. ");
INSERT INTO bwo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Maniyere il b́ danifwotsok waat boosh hank'o bíeti, «Anodoor k'ewoke itfa'oni? kashdek'oke itfa'oni? Hamb ash na'o morretswots kishots beshide'e imet sa'ato bodre, ");
INSERT INTO bwo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tuuwere amone! hamb taan beshide imetwo t'inree!» ");
INSERT INTO bwo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iyesus man keewoke b́befere, tatse git b́ danifwotsitse wottso iko Yhud b́weyi, bíntonwere shiki goradonat gumbo kurdek'ts ay ashuwots boweyi, boowere kahniy naashwotsnat eenashwotsoke woshekno botesh. ");
INSERT INTO bwo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Iyesusi beshide imetwo Yhud́ ash ashuwotssh «It geyirwoniye taa t joobitwoniye bín deshde'ere» eton milikito imtni b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yhud manoor waat Iyesusok t'ínt «Danifono! jeeno neesh wotowe!» ett b́ joobi. ");
INSERT INTO bwo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iyesuswere, «T mashono! eshe nwaats kis'o s'eentswe» bíet. Maniyere il ashuwots Iyesusok t'int detsbodek'i. ");
INSERT INTO bwo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Manoor Iyesusnton teshtswotsitse iko b́ kisho jargt b́ shiki gorado kaas'dek't́ kahani naasho guutso togt b́ waazo b́k'ut'i. ");
INSERT INTO bwo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Iyesusmó hanek'owa bíet, «Shik k'aa'utswots shikon bot'afitwotsee nshiko b́batots aani de'er gerk'rowee. ");
INSERT INTO bwo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Taa t nihi t k'oniyal bí ay kum kees'et melakiwotsi wosho b́ maawitk'o arefáá itsha? ");
INSERT INTO bwo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mank'oyi wotink'e ‹Gond bek'o bín geyife› etirwo S'ayn mas'afotstsi aap'o aawk'o k'alrniya b́ s'eeneti?» ");
INSERT INTO bwo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Manoori sa'ator, manoke ko'ets ash ashosh Iyesus hank'owa bíet, «Wonbedewo detsfwotskok'oye taan detsosh shikonat gumbon detsdekat it weyi? Aaw aawon Ik' mootse itn danifetsat itnton tbeyor taan deshatste b́teshi. ");
INSERT INTO bwo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ernmó jaman b́wotir nebiywotsn guut'etso b́s'eenetwok'owe.» Manoor b́ danif jametswots bín k'azk'rat bowos'i. ");
INSERT INTO bwo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Maniyakon Iyesusi detsdek'ts ashuwots kahni naasho K'eyaafok dek't boami, manoknowere nem danifwotsnat eenash eenashwots kakuweyatni botesh. ");
INSERT INTO bwo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","P'et'rosmóó kaahniywots naasho múúlok b́borfetso Iyesus jafrats wokoon sha'o b́ tuwi, biitsowere kinddek't keewman b́s'uufetso bek'osh múúl kotirwotsntoon be b́dek'i. ");
INSERT INTO bwo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kahini naashwotsnat ayhudiwots moosh mooshif jametswots Iyesus ats k'iro angshosh kooti gawo bogeyiri. ");
INSERT INTO bwo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kooti gaw gawiru aywots bí ats bot'iinalor, k'iro bí ats angshit gawo daatsratsno, il gaw gitetswots t'int, ");
INSERT INTO bwo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Ashaan ‹Ik'iko Ik' moo gaahde keez aawotse agosh falitwe› etre» ett bokeewi. ");
INSERT INTO bwo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kahniwots naashonwere tuut «Ashaanots ni aats bo gawiru jamansh eegor boosh aaniyalkneneya?» ett bíaat. ");
INSERT INTO bwo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Iyesusmo s'ik et b́wtsi. Kahniwotsatsi naashonwere aaniy Iyesussh «Beyat beyiru Ik'o shúútson neen taarirwe! nee Ik'o naay Krstosi nwoto noosh keewwe!» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Iyesuswere bísh hank'o bíet, «Nee níettsok'oyiye, ernmó haniyak ash na'o bí jam falts Ik'o k'ani aaromantse b́befere bek'etute, aaninwere mank'o darotse daawnatse wotde b́woor bek'etute etirwe.» ");
INSERT INTO bwo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Manoor kahniwotsatsi naasho nib k'úúnon b́ taho gaat't hank'o bíet, «Hamb Ik'e b́ c'ashiriye! b́ c'ashirwonowere it shishrte! haniyere bogo eeg gawe b́geyiti! ");
INSERT INTO bwo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Eshe, itsh eeg arefa?» boowere «K'ire bísh wotitiye!» ett boaaniyi. ");
INSERT INTO bwo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Manoor bo s'udo bíats bos'udi, bín bok'is'i, b́ k'eelatsowere jabefetst. ");
INSERT INTO bwo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«Krstoso! kone neen jot'tsoní? aab bek'on keewwe» boetiri botesh. ");
INSERT INTO bwo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","P'et'ros mooniyere úratse kahni naashwots k'aab naasho múúlotsna b́beyiri b́tesh, manoor gon iku b́ maants t'iinat «Nee weree Gelil datstso Iyesusntoniye n teshiye!» bí et. ");
INSERT INTO bwo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Bímó, «Nietirwo danatse!» eton jami shinatse jamere bíet. ");
INSERT INTO bwo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Keshosh fengeshomaand bí amfere gon k'oshu bek'k'rat manoke teshts ashuwotssh, «Ashaan Nazrettso Iyesusntoniye b́ teshi!» biet. ");
INSERT INTO bwo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","P'et'roswere «Ni etiru ashman danatse!» ett taaron aani b́ jamere bíet. ");
INSERT INTO bwo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Muk'i boteshihakon manoke need'dek't teshts ashuwots P'et'rosok t'iindek't «N noon keew keewo danifee, arikon neewor boyitse iko neene» boeti. ");
INSERT INTO bwo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Manoor P'et'ros, «Taa han danatse!» et fetst b́tooko c'ashfetst taaro dek't b́tuwi. Manoor baako b́ k'adi. ");
INSERT INTO bwo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","P'et'roswere, «Baako b́ k'adfetso keezoto taash bín danatse jamere etetune» ett Iyesus b́ keewts aap'o gaw b́dek'i. Úrats kesht s'aamts eepo bí eepi. ");
INSERT INTO bwo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Guur datsgatson kahni naashwotsnat dats eenash jametswots Iyesus ats b́k'iritwok'o angshosh boshiyeyi. ");
INSERT INTO bwo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Maniyak Iyesusi tipdek' amt dats k'eezirwo P'ilat'ossh beshidek't boími. ");
INSERT INTO bwo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Iyesusats angshetsok'o b́ bek'tsok'on bín beshi dek't imtso Yhud b́goyni, shaash t'agoronowere kahni naashwotsnat eenashwotssh hank'o ett aani b́k'ri, ");
INSERT INTO bwo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","«Ash s'ayino k'irosh beshidek'at t imtsotse morro finere.» Boomó «Eshe noon eege giri! man n took kis'e!» boet. ");
INSERT INTO bwo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Bíwere shaash t'agarman Ik' moots bad'ik'rat, bowoke k'az b́keshi, amtnwe guuk'at k'ir b́úwts. ");
INSERT INTO bwo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kahani naashwotswere shaash t'agar man k'aaúdek't «Ambaran s'atsi giz b́wottsotse Ik' mootse ko'íyeyiru gizots eeko nemon baziyeke» boet. ");
INSERT INTO bwo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mansh bo shiyeyakon ibwotsi dukosh b́ wotisha ett shal wozirwooke datso bokeewi. ");
INSERT INTO bwo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Manatse tuutson datsman andish bodt «S'ats datsa» ett b́s'egeyiri. ");
INSERT INTO bwo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Han jangatse tuutson «Esra'el nanaúwots bo k'oortsok'on bísh wotitwo shaash t'agaro bodek', ");
INSERT INTO bwo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Doonzonwe taan bíazaztsok'on shal wozet datsi k'awntso dashbok'ri» ett nebiyo Ermiyas bek'on b́keewtso b́s'eeni. ");
INSERT INTO bwo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Manoor Iyesus dats k'eeziru P'ilat'os shinats b́t'iini, dats k'ezirwonwere «Nee ayhudiyots naasho neeneya?» Ett bíaati, Iyesuswere «Nee ni'ettsok'oyiye» ett bí aani. ");
INSERT INTO bwo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ernmó kahni naashwotsnat eenashwotsn bín s'amiyosh bo etor eegor aaniratse. ");
INSERT INTO bwo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Maniyak P'ilat'os «Ay keewon neen bos'amirúwan shiyatsneya?» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Iyesusmó dats k'eezirwo ayidek't bí adfetsosh bín bos'aamiru keewosh eegoru aaniratse. ");
INSERT INTO bwo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Dats k'eezirwo woriwot woriwoton ayhudiyots fazigi worwot baloyon tipetswotsitse noosh bishowe err boaatfwotsitse iko b́shde'e faksho bo nema b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Manoor «Barbani» eteets gond finon daneets tipetso fa'e b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Manoor ashuwots ko'ebowtsere P'ilat'os, «Koni itsh t biitse it geyi? Berbannemó Krstosi eteyrwo Iyesusne?» ett boon bí aati. ");
INSERT INTO bwo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Hank'o b́ etts jangonwee okooron bín beshidek't boimirwok'o b́ dantsosha b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Manoor P'ilat'os b́ angshi jooratse b́ befere b́ moo gen, «B́ jangosh hmbets t'ú taa gúmotse aydek'at tikic'tsotse ash s'aynmanats eegoru nk'alrawok'owa» etaat bwoshi. ");
INSERT INTO bwo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Manoor kahani naashwotsnat eenash eenashwotsn «Barban bishowe! Iyesus úd'ewe!» err bo aatitwok'o ashuwotssh boizi. ");
INSERT INTO bwo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Dats k'ezirwonu, «Gitetswotsitse aawi itsh t bitsishe itgeyri?» ett ashuwotsi b́ aati. «Bowere Berbani noosh bíshe» bo eti. ");
INSERT INTO bwo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","P'lat'oswere «Eshe Krstosi eteetso Iyesusi aak'owe nok'aliti?» bíet. Jamwotswere «Jitewe!» ett boaani. ");
INSERT INTO bwo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Dats k'ezirwonu eegishe? «Bí b́ t'afitso eebi?» bíet. Boomó «Jitewe!» ett aydek't bokuhi. ");
INSERT INTO bwo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Hansh P'ilat'os keewan faye b́tiziti bako egoshoru b́ k'alrawok'o b́ bek'tsotse, manoor aatso de'eweetwok'o k'alt «Taa ashaan s'atsotse s'ayn taane, b́ s'atso it tokatse?» ett ashuwots shinatse b́kisho b́mashi. ");
INSERT INTO bwo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ash jamwotswere «B́ s'atso noonat nona'ats wotowe» boet. ");
INSERT INTO bwo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Manoor P'lat'os Barbani bitsdek't faksh b́k'r, Iyesusnmó b́ jot'iyakon b́ jiteyish beshidek't boosh b́ ími. ");
INSERT INTO bwo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Manoor dats k'eezirwo kes'fwots Iyesusi dats k'eziruman múlo maantsan dek't boami, kes'f jamwots Iyesusi gúrdek't ko'eebowtsi. ");
INSERT INTO bwo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","B́ tahono kishbazt tah bíro takbok'ri. ");
INSERT INTO bwo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Angitson shordek't dozets akliliya eteetso b́ tookats jip'ii bok'ri, b́ k'ani kishats gumbo detsik'rat, b́shinats tuk'mal dek't «Ayhudiyotsko nugusono! jeeno neesh wotowe!» ett bí ats nic'o bokaashi. ");
INSERT INTO bwo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bos'udono bíats bos'udfera boteshi, b́ kishatsenowere gumbo k'aaúdek't b́ took tookats bojot'fera botesh. ");
INSERT INTO bwo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bíats tirgic'o bo kaashiyakono tah biro kishbazt b́took taho takdek't, jitosh dek't bo ami. ");
INSERT INTO bwo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Dats keewirwo múúlotse keshoke bobefere Simoni eteefo K'erena eteets dats asho daatsdek't Iyesus mask'aliyo shefdek't b́kuritwok'o bowshi. ");
INSERT INTO bwo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Maniyere il b́bitsonwere «Took k'oola» eteef beyokok bobodi. ");
INSERT INTO bwo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Maniyeokon úmonton eekets weyni biro b́ úshetwok'o Iyesussh t'ints bok'ri, ernmó bí fadbek't úsho geeratse b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Iyesusi bojitiyakon b́ tahats it'o shap't kaybodek'i. ");
INSERT INTO bwo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Manoknowere bedek'tni bín bokotfere botesh. ");
INSERT INTO bwo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Bín s'amiyetsok'o kitsitwo, «Han ayhdiwots nugúso Iyesusiye?» Etirwo guut'etso b́ mask'aliy k'oyok gedbok'ri. ");
INSERT INTO bwo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Manoor Iyesusnton git wonbedewotsi iko k'ano maants iko giro maants jit bok'ri. ");
INSERT INTO bwo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","B́ ganoke beshefts teshts ashuwotswere gac'on botoko shek'efetst ");
INSERT INTO bwo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","«Nee Ik' k'oni moo gaahr keez aawotse agetuwonoo! aab n tooko kashiwe! Ik'o naayi n wotiyal aab mask'aliyatse ood'e!» eton bíats bokashfera botesh. ");
INSERT INTO bwo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mank'o kahniy naashwots nemo danifwotsntoonat eenashwotsnton hank'o ett bíats bokaashfere botesh. ");
INSERT INTO bwo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«K'oshwotsi kashire, b́tooknmó kashiyo falratse! bí Israe'el nugúsoni wotiyal aab mask'aliyatse ood'e, noowere bín amanone! ");
INSERT INTO bwo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Bí Ik'ats amanere, ‹Ik'o naay taane› etre, eshe Ik'o bín shunfee wotiyal and aab bín fariwe!» ");
INSERT INTO bwo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ando mank'o bínton jitets wombediwots bín boc'ashfera botesh. ");
INSERT INTO bwo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Shirt sa'aton b́tuutso jed'isa'ato b́ borfetso dats jamatse t'alu wotb́gutsi. ");
INSERT INTO bwo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jed'i sa'at b́ wottsok'oon Iyesus, «Elohe! elohe! lama sebek'tani?» eton k'aari eenon b́ kuhi, b́bitsonwere «T Ik'ono! t Ik'ono! eegishe taan k'aznk'ri?» eta. ");
INSERT INTO bwo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Manoke need'dek't teshts ashuwotsitse man shisht «Hanwo Eliyasiye b́ s'eegiri!» boet. ");
INSERT INTO bwo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Manoor boyitsi iko sefnegiya eteetso dek'wat shash keewo bíts s'eentsdek't gumbats geddek't Iyesus b́úshetwok'o t'intsb́k'ri. ");
INSERT INTO bwo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","K'oshwotsmó «Need'owe aab́ Eliyas waar bín kashitwe wotiyal be'one!» boet. ");
INSERT INTO bwo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Iyesus aaniy een k'ááron kuhat b́ kasho b́ ími. ");
INSERT INTO bwo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Manoor Ik'i meyitsi magarajiwo dambe dek't dash b́ borfetso gaad'at gitoko kayb́wts, datsonwere shek'eb́wtsi, shúts s'aalwotswere kap'ebowtsi, ");
INSERT INTO bwo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Dowwotswere bok'eshere k'irt teshts S'ayin ash aywots k'irotse botuwi. ");
INSERT INTO bwo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Dowootse keshtnwere Iyesus k'irotse b́ tuwiyakon S'ayn kitu Iyerusalemits bokindi, manokno ay ashuwotsats bobe'eyi. ");
INSERT INTO bwo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Balatsi naashonat bínton beyirwotsn Iyesusi kotirowots dats giwonat manoke wotts jamman bobek'tsok'on aydek't shatt «Arikon han Ik'o naayiye b́ teshi!» boet. ");
INSERT INTO bwo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wokoon wotdek't man s'iliru ay máátswots manoke fa'ano botesh, boowere Geliln tuut Iyesussh finefetst b́ shutsats bosha'efera boteshi. ");
INSERT INTO bwo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Boyitsnowere megdelawiti eteetsu Mariyamna Yak'obnat Yosef ind mariymna Zebdiyos nanaúwots indna manoke fa'úwotsi. ");
INSERT INTO bwo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Datso b́ iliyakono Yosefi eteets asho Armatiyas eteets kitutse gaalets ash iko manok b́weyi, bíwere Iyesus danifwotsitska b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ashmanwere, P'ilat'os maantsan amt Iyesus duuno b́ k'oni, P'ilat'oswere duunman bísh imetwok'o b́azazi. ");
INSERT INTO bwo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Manoor Yosef duunman orshdekt shemi s'aynon k'odb́k'r. ");
INSERT INTO bwo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","B́ tookish shúts s'alotse k'ewdek't b́dozts doowi handrots duukb́k'r, shúts eeno kukulshdek't doowi fengeshats is'k'rat kazbíami. ");
INSERT INTO bwo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Megdelawi dats ashu Mariyamnat k'oshu Mariyamn, manoke doowi shinatse bobefere boteshi. ");
INSERT INTO bwo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","K'andek'i aawoniyere yaatsok'o guur, kahni naashwotsnat feresawiyotsn ik wotdek' P'ilat'os maantsan amt hank'o boeti, ");
INSERT INTO bwo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","«Doonzono! dariifmań kashon befetst ‹Keez aawoniye okoon k'irotse tuwitwe› bíettso gawdek'rone. ");
INSERT INTO bwo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mansh b́ danifuwots amr úmp'de ashuwotssh ‹Hamb k'irotse tuure› boerawok'o doowman keez aawo b́ borfetso kotetwok'o azazowe, man wotob́k'azal ili b́dariytwo shintsoniyere ayide gonde b́ wotiti.» ");
INSERT INTO bwo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","P'ilat'oswer «Hambe, kotet kes'fwots fa'ane, de'amr it dantsok'on kotiwere» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Mansh amt shútsmanats matabon togk'rat doowman kes'fuwotsn bokoti. ");
INSERT INTO bwo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sambato b́ beshiyakon ik gawiyotsi shínts aawots Sanbata gudots guur goyoon Megdel dats ash wottsu Mariyamnat Mariyam k'oshun b́ dowu man s'ilosh boami. ");
INSERT INTO bwo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mann, gawerawo datso ayidek't shek'e b́wutsi, melakiyo darotse oot'wat doowo bín is'eets shútso kukulshk'rat bí'abats be b́dek'i. ");
INSERT INTO bwo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ik' melakiman shiitsonwere guumok'owa b́goliri b́teshi, b́tahonwe shetsok'o nas'a b́teshi. ");
INSERT INTO bwo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Kotirwotsu melakiyo bo shattsotse k'ewat duunok'o wotbowtsi, ");
INSERT INTO bwo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Melakiyonmó máátswotssh hank'o bíet, «Itiyere shatk'ayere, jitetso Iyesusi it geyrwok'o danfee, ");
INSERT INTO bwo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Bíwere hanoke aaliye shin b́ keewtsok'on k'azturee. Hanoke aaliye, b́ duukewoko waar s'iilere. ");
INSERT INTO bwo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Eshe kaari amr b́danifwotssh ‹K'irotse tuure! hamb, Gelil maantsan itiyere shino amree, manoke bín daatsitute!› err boosh keewwere, eshe itsh keewre.» ");
INSERT INTO bwo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Maniyere hakon máátswots shatonat ayidek't een geneewoon doowokere kááron k'az boami, b́danifwotssh keewosh bowos'i. ");
INSERT INTO bwo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Iyesus weerindatse boon daatst «Jeeno itsh wotowe!» bíet. Bowere b́ maantsan t'int b́ tufo detsdek't bísh bosagadi. ");
INSERT INTO bwo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Manoor Iyesus, «Shatk'ayere! amr Gelil maants boametuwok'o ti eshwotssh keewwere, taan bo bek'etuweree bíyokne» bíet. ");
INSERT INTO bwo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Máátsmanotsu amoke bobefere kes'irwotsitse ik ikuwots kitots amt́ wotts jam keewman kahani naashwotssh bokeewi. ");
INSERT INTO bwo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kahni naashwtsnat eenashwotsn ko'eyat boshiyeyakon kes'fwotssh ay ambaro imt hank'o boeti, ");
INSERT INTO bwo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","«Noo k'eyoke nobeferee b́ danifwots t'úwon waat úmp'dek't bo ami err ash ashuwotssh keewwere. ");
INSERT INTO bwo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Han dats k'eezirwo b́shishetkawotiyal no keewman jango bísh keewr itats gond keewo b́warawok'o woshitwone.» ");
INSERT INTO bwo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Manoor kes'fwots ambaro k'a'údek't boosh keewetsok'o bok'ali, keewanu hambetsish b́ borfetso ayhudiyotsoke b́keeweyiri. ");
INSERT INTO bwo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","B́ danif tatse ikwotswere Iyesus bo amish boosh b́kitstso, Geliln fa'a guromadan boami. ");
INSERT INTO bwo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bín bobek'tsok'on bísh bosagadi, ik ikuwotsu amanobok'azi, ");
INSERT INTO bwo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Iyesusu bowok t'int hank'o bíet, «Al jamo datsatsnowe daratsnowere taash imk'rere ");
INSERT INTO bwo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Datsatsi ash jamok amr, nihon, naayonat shayiri S'ayno shútson boon gufr t danifwotsi woshweree. ");
INSERT INTO bwo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Taa itn tiazazts jaman bok'alitwok'o boosh daniwere! eshe taa datsu besho b́borfetso jam aawo itntoniye tfaooniyee.»");
INSERT INTO bwo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hań Ik'onaayi Iyesus Krstosko doo shishiyo b́ tuwokoni. ");
INSERT INTO bwo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nebiyiyo Isayasn, «Hambe, nwerind foketwo T woshtso nshinatse beshide woshitwee. ");
INSERT INTO bwo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Hanwere ‹Doonzosh weerindo k'aniwere B́fudonowere manutsiwere› etfere, Worwotse b́k'aaro eenshde'k't keewiru asho k'aaroniyee» ett guut'etsok'one. ");
INSERT INTO bwo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Mansh gupfo Yohans «It morrosh orowe eto itdatsish naandrone err gupewere» ett worwotse kuhdek'et keewfere b́weyi. ");
INSERT INTO bwo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yhud datsonat Iyerusalem kitutse ay asho b́maantsa bowaafo, bo morro kish keewr Yordanosi eteets fokotse b́ kishatsna bogupefo. ");
INSERT INTO bwo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohans tahonwere kambuli s'iron wozeka b́tesh. B́gebatso shaak'a bí edefo, b́maafonwere p'elonat dok'shi mas'ona. ");
INSERT INTO bwo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Bí hank'owa bí'etfo «Túmr b́c'aami tipi joko bitsosh tborawo taayere ayidek' bogtso tshutsatse weeyirwe. ");
INSERT INTO bwo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Taa iti aatson gupetwe, bímó itn S'ayn shayiron gupetwe.» ");
INSERT INTO bwo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Manoor Iyesus Galili eteets datsatse beyiru Naazreti eteef kituts waat́ Yordanos fokotse Yohans kishon b́gupeyi. ");
INSERT INTO bwo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yohans manoor, Iyesus aatsotse b́keshtsok'on daro gaad'at́ b́k'eshefere, S'ayin shayiro kurkund areyat bíyats b́ oot'́fere b́bek'i. ");
INSERT INTO bwo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Manoor «Taan gene'úshtso t shunts na'o neene» etiru k'ááro darotse b́weyi. ");
INSERT INTO bwo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Manóór Ik'i Shayiro Iyesusi worwots dek't bí'ami. ");
INSERT INTO bwo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Manoknowere worwotse Shed'ano Iyesusi hab aawosh b́ fadfera b́teshi, dín s'ootswotsntoni b́ tesh, melkiwotsu bísh finernó botesh. ");
INSERT INTO bwo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohans detseyat tipimo b́ kindiyakon Iyesus, Ik'i mengsti jangosh doo shishiyo nabfere Galil maants b́weyi. ");
INSERT INTO bwo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","B́daniyoro, «Dúro s'uuwtsere, Ik'imengstu karnfere b́watsotse it naandrone erere, dooshishi nabetsono amanore!» bí etfo. ");
INSERT INTO bwo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Maniye il Iyesus Gelil aatsk'ari ganoke beshefetst Simon nat bí eshu Indriyasn mus' detsfwotsi boteshtsotse bo mus' kambo aats k'aro maants boshap'fere boon b́ bek'i. ");
INSERT INTO bwo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iyesuswere «T jafrats woore itsh tdanisha, err mus' it detsirwok'o ashuwotsi it detsetwok'ó woshitwe» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Bowere manoor bo mus' detsi kambo k'azk'rat́ b́shuutso bo tuwi. ");
INSERT INTO bwo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Maniyere múk'i beshat k'osh eshu gitwotsi b́bek'i. Bowere Zebdiyos nana'úwots Ya'ak'obnat Yohansna botesh. Bowere bo jelbotse bedek't bo mus' detsi kambo bok'anifera botesh. ");
INSERT INTO bwo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Iyesus manoor boon b́s'eegi. Bowere bonih Zebdiyosnat bísh fin finirwotsn jelbatse k'azk'rat Iyesus jafrats boami. ");
INSERT INTO bwo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Beshatnu K'frnahom kitots bobodi. Manoori waats sanbatots Iyesus Ayhdiwots Ik' k'oni mootse daniyo dek't b́twi. ");
INSERT INTO bwo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Iyesus, Muse nemo danifwots kok'o b́woterawo naashikook'o b́danifotse shishts jamwots b́daniyor ada bo adfo. ");
INSERT INTO bwo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ayhudiwots Ik' k'oni mootse beyiru ash iko gond shayiron s'eentso hank'o ett b́kúhi, ");
INSERT INTO bwo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Nazrettso Iyesuso, nee nooke eeg kis'e ndetsi? Noon t'afiyosh waafi? Nee koni n wottsok'o taa daank'reree. Ik'oko S'ayino neene.» ");
INSERT INTO bwo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iyesuswere gond shayirmansh «S'ik err, bí atsotse kee» ett b́fayi. ");
INSERT INTO bwo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Gond shayronwere ashman dikdek't b́s'ik'iyakon b́k'aaro eensh dek't kuhefetst bí atsotse b́ keshi. ");
INSERT INTO bwo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","«Eebi han naaroni? Hanwo handr daniyeya?» Gond shayirwotsi bí aloro bo bíshere bo aleyiri, ett adt bo atsatseyo aateyo dek' bo tuwi. ");
INSERT INTO bwo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Muk'i b́teyawo, Iyesus shúútso Galil gúúratsi dats jamatse dane b́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Muk'ib́teyawo Iyesus ayhudi Ik' k'oni mootse kesht Yak'obnat Yohansnton, Simoonnat Indryasn moots b́kindi. ");
INSERT INTO bwo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Maa manitsno Simon awu ats k'ees'its shodo shodat bk'efera btesh. Bshodmanowere manoor Iyesussh keewbok'ri. ");
INSERT INTO bwo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iyesuswere bmaand t'int́ bkisho detsdek't b́tuuzi. Bi atsi k'ees'onwere manoor binfakshb́k'ri. Tuwatnwere boon b ibiy. ");
INSERT INTO bwo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Aawu bkindre datso bí iliyakon ashuwots shodtswotsnat fo'erawon detsets jamwotsi Iyesusok dek't boweyi. ");
INSERT INTO bwo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kititsi ash jamo maa úratse kakwe b́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Iyesus ay naari shoodon kic'iru ay ashuwotsi kashi b́k'ri. Fo'eraw aywotsno b́kishi. Fo'erawwotswere bí koni b́woto danfno botesh. Ernmó bokeewrawok'o boon b́baziyi. ");
INSERT INTO bwo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Datso gatsosh bí etfere, Iyesus guuron tuut mootse kesht Ik' k'onosh ash aalok k'az bíami. ");
INSERT INTO bwo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoonnat bínton teshtswots bín geyo kesht boami. ");
INSERT INTO bwo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bín bodatstsok'ono «Ash jamonwo neenere b́geyiri» bo eti. ");
INSERT INTO bwo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Iyesuswere, «Taa twaa danyosh b́wottsotse doo shishiyo danyosh karnoke fa'a gal galóts amone!» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mann ayhudiwots Ik' k'oni maa mootse danifetsit fo'erawwotsnowere kishfere Galil dats jamatse b́gúúrefo b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Een shod detsts ash iko Iyesus maants waat b́ tufi shirots tuk'maldek't, «Ni eekiyal taan s'ayintso falfne» eton bín b́k'oni. ");
INSERT INTO bwo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iyesuswere bísh maac'o k'ewat, b́kisho jargdek't shu'efetst, «Eekere s'ayine!» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ashmanwere manoor bí een shodotse s'ayinb́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Iyesus ashmansh kup'shdek't, ntooko korde'e ett faksh b́k'r. ");
INSERT INTO bwo_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Wotts keewan ik doonzshor nkeewrawok'o ni tooko korde'e, ernmó amr ntooko kahniyosh kitswe. Ashjamosh gaw b́wotish nkashtsotse Muse k'aluwere bí etts wosho t'intswe» ett bíazazi. ");
INSERT INTO bwo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ernmó ashman manoke kesht keewman ashosh keewo dek't b́tuwi. Manatse tuutson Iyesus kit ikutsnor be'efetst kindo b́maawi. Ernmó kitoniye úratse ash aaloka b́befo. B́ wotefere ashuwots bo be beewoke b́ maants waa bowaafo. ");
INSERT INTO bwo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Múk' aawwotsiyere il Iyesus K'frnahom maants aanat b́weyi, manoke mootse b́beyirwok'o shisheb́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Moonwere bodo b́k'aye maa úronwere b́t'ebefetsosh ay asho kakwe b́wtsi. B́ doo shishiyi keewonowere boosh b́danifoni. ");
INSERT INTO bwo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Manoor awd ashuwots ash dur iko kurdek't bíyok boweyi. ");
INSERT INTO bwo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ash aytsatse tuutson duro Iyesusok de'et'ino maawt Iyesus kááwon maa tooko wogdek't duro bí ees'onton orshbok'ri. ");
INSERT INTO bwo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iyesuswere bo aman amano bek't durosh «T naayo n morro neesh orowa eteere» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Manoke bedek't teshts Muse nemo danifwotsitse ik ikewots bonibotse hank'o bo et. ");
INSERT INTO bwo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Ash han eegoshe hank'o c'asho Ik'ats b́ keewiri? Ik' ikoniye okoon morro orowe eto falitwo kone?» ");
INSERT INTO bwo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Muk'i b́teyawo Iyesus bonibotse bogawirwo hank'on dandek't boosh hank'o bí et, «Eegishe it nibotse man it gawiri? ");
INSERT INTO bwo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Durosh ‹N morro neesh orowe eteere› etonat ‹Tuur ni es'o kur de'er amee!› etotse aaw ketefa? ");
INSERT INTO bwo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ernmó Ash na'o datsatsi morro orowe etosh alo b́detstsok'o it danetwok'owa!» ett durosh, ");
INSERT INTO bwo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Tuwi, ni es'o kuurder ngalomand amee etirwe neesha» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Duronú manoor tuut bí es'o kurdek't ash jami shinatse b́ keshi. Mansh ash jamo adt «Hank'o b́jamon be'e danaknona» ett Ik'o bo údi. ");
INSERT INTO bwo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iyesuswere aani Galil aats k'aro ganok bíami, ash jamonúwere kakweyat b́maand boware boon b́danyi. ");
INSERT INTO bwo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Man weeron b́beshefere t'ilish dek'eefoke beyirwo Ilfyos naay Lewi bek't, «T jafrats wowe» bí et. Bíwere tuut b́jafrats bí'ami. ");
INSERT INTO bwo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Maniye il Iyesus Lewi mootse mishi maratse bedek'tni b́tesh. Ay asho b́ shuutso shoy dek' b́sha'iirwotse bínton t'ilish ko'iru aywotsnat morretswots, Iyesusnat b́ danifwotsnton mishi marats t'indek'tni botesh. ");
INSERT INTO bwo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ferisawino eteef jirwotsits wottswots Muse nemo danifwots, Iyesus t'ilish ko'ifwotsnat morretswotsnton b́maafere bek't «T'ilish ko'ifwotsntonat morretswotsnton eegoshe maat b́ úshiri?» ett b́ danifwotsi bo aati. ");
INSERT INTO bwo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iyesuswere man shisht, «Shodtswotssha bako jeen wotssh atetso geyirakee, taawere tweyiye kááw finirwotssh b́woterawo morretswots bo naandosh oorowe eto bodaatsitwok'o s'eegoshe» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yohans danifwotsnat ferisawino eteefwots s'ooma bos'oomefo. Ik ik ashuwots Iyesus maants waat «Yohansnat ferisawino eteyrwots danifwotswo s'oomere bo s'oomefoni n danifwots s'oomo bok'az eegoshe?» bo et. ");
INSERT INTO bwo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iyesuswere «Guuyo bonton b́befere guuy deentswots s'oomo boosh geyituwaa? Mank'oyaliye! guuyo bonton b́befere s'oomo boon geyiratse. ");
INSERT INTO bwo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ernmó guuyo booke b́ dek'et aawo weetwe. Manoor s'oomitúne. ");
INSERT INTO bwo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tah nataats but'i handro shipfo aaliye, mank'o k'aleyalmó handr bút'onúwre taahdoro geets de'e gad'ni b́k'riti, b́gad'manwere baltsoniyere ikini b́gonditiye. ");
INSERT INTO bwo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mank'o weyiniyon dutsets biro bíts gas'ef arwi natoots handr weyniy biro gas'fo aaliye, mank'o k'aleyalmó weyiniyon dutsets birmań arwi natman t'up'ini b́k'riti. Woyniyon dutsets birmanwere kud'ni b́wtsiti. Arumanwere k'awntsalke b́wotiti. Mansha handr woyniyon dutsets birosh handir arwe b́geyiti» bí'et. ");
INSERT INTO bwo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sanbati aawots Iyesus sndeyi tari taalon b́beshefera b́tesh. B́ danifwots amfets sendeyi motso k'ut'dek'o botwi. ");
INSERT INTO bwo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ferisawino eteyirwotswere «Hambe, n danifwots sanbati aawots fink'ayere eteesto eegishe bok'aliri?» ett bo'aati. ");
INSERT INTO bwo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Iyesuswere hank'o ett boosh bí'aani, «Dawit bínton sha'irwotsnton k'ak'at b́kic'or egb́k'altsok'oo nababeratsteya? ");
INSERT INTO bwo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abyatar kaheniyots naash b́tesho dúr, bí Ik'i moots kindt, kahniwotsi bako konwor b́marawok'o baziyetso, Ik'osh imets misho b́meyi bínton teshts ashuwotssh b́ími.» ");
INSERT INTO bwo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aaninwere Iyesus boosh hank'o bí et, «Sanbati aawu ashosha bi azeyi bako asho sanbati aawosh azeratse. ");
INSERT INTO bwo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mank'owa Ash na'o sanbati aawush bdonziye.» ");
INSERT INTO bwo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ayhdiwots Ik' k'oni moots Iyesus b́ kindi, manokno kish dúr ash iko fa'e b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Iyesusi s'aamiyo geyiru ashuwots, «Sanbati aawon ashaan b́kashiyo aab s'iilone!» ett kotdek'tni botesh. ");
INSERT INTO bwo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Iyesuswere kish dur ashmansh, «Waa taalotse need'owe» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Maniyere il, «Sanbati aawon fin k'ayere eteetso sheeng finemo gond fine? Kash wooriyemó kash úd'e?» ett boon bíaati. Boomó s'ik et bowtsi. ");
INSERT INTO bwo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iyesuswere bonibo b́ duungtsotse shiyanat bín gúrdek't fa'úwotsi sheet't ashmansh, «Nkisho jargwe» bí eti. Bíwere b́ jargtsok'on b́ kisho kash b́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Manoor ferisawino eteyirwots kesht ak'alde'er Iyesusi bot'afitwok'o Herodsnton boshiyeyi. ");
INSERT INTO bwo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iyesus b́ danirwotsnton Galil aats k'aromaants bí'ami. Gelilnat Yhuditse ay asho b́shuutso shoydek't b́twi. ");
INSERT INTO bwo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","B́ k'aliru keew jamo boshishtsok'on ay ashuwots b́ shuutso botwi, manotswere Galiln, Yhudn Iyerusalemn, Edomiyasn, Yordanosiye bak'ets datsatse, mank'o T'irosnat Sidon kitotse waatswotswere fa'ano botesh. ");
INSERT INTO bwo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Asho bí aytsatse tuutson ashuwots datso bí ats t'ebir bín bokic'irawok'o jelbo bo k'anyitwok'o b́daniyrwotssh b́ keewi. ");
INSERT INTO bwo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ay ashuwotsi shodotse kashit b́ teshtsotse shodon kic'iru jamwots bokishon bín detso geeyat, bísh datso bot'ebifera botesh. ");
INSERT INTO bwo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kim shayirwots bín bobek'or b́ shinats gup' gup'at, «Nee Ik'o naay neene!» etfetstni bokuhefo. ");
INSERT INTO bwo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Bímó koni b́wottsok'o kish bokeewrawok'o kup'i dek' boon b́fay. ");
INSERT INTO bwo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iyesus guri abaats b́keshtsok'on b́geyirwotsi b́maants b́ s'eegi, boowere b́maants bo t'iini. ");
INSERT INTO bwo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Bínton bobeyish, bo nabishowere, boon woshosho tatse gitwotsi galb́dek't «Woshetswotsi» ett bo shúútso b́kshi. ");
INSERT INTO bwo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Fo'erawwotsi bo kishitwok'owero alo boosh b́ imi. ");
INSERT INTO bwo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Galb́dek'ts tatse gitwotswere hanotsi, «P'et'rosi» ett b́ s'eegtso Sim'oni. ");
INSERT INTO bwo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","«Bo'anergesi» wee guumi na'uwotsi ett bo shúúts b́kishtswots Zebdiyos nanaúwots Yak'obnat Yohansna, ");
INSERT INTO bwo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Indriyasi, Flip'osi, Bertelmiyosi, Matiyosi, Tomasi, Ilfyos naay Yak'obi, Tadiwosi, wed'eyirwoni Sim'onnat, ");
INSERT INTO bwo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Iyesusi beshidek' imtso Kiriyot kittsi asho Yihudi. ");
INSERT INTO bwo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Maniyere il Iyesus moots b́kindi. Iyesusnat b́ danifwotsn mish moonor bomawfetsosh aani ankat ashuwots kakwe bowtsi. ");
INSERT INTO bwo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","«Iyesus geewtsere» eteere boshishtsotse b́ jagwots bín detsosh b́maand boweyi. ");
INSERT INTO bwo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Iyerusalemn oot' waats Muse nemo danifwots, «Bí'atsnee B'elzebuliye fa'oni, Fo'erawotsi b́kishiriye Fo'erawi naash wottso Beelzebulne!» ett bo keewi. ");
INSERT INTO bwo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Iyesuswere boon b́maand s'eegdek't́ jewrdek't hank'o boosh bí et, «Shed'ano aawk'o k'alderniya Shed'ano kisho b́ faliti? ");
INSERT INTO bwo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ik mengsto kayewtsarr bí atsatseyo b́ gawetka wotiyal mengst man kup'ar need'o falratse. ");
INSERT INTO bwo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mank'o Ik meyitsi asho bí atsatsewo b́k'aleyal kup'ar need'o falratse. ");
INSERT INTO bwo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Mansha Shed'ano bí atsatsewo b́ k'aletka wotiyal t'afa b́t'afiti bako beyo falratse. ");
INSERT INTO bwo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«Mank'o ash kúp' iko moots kindr b́detstso biik'oosh shin kúp'man b́ tifawo falitwo aaliye. ");
INSERT INTO bwo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«Ariko it́sh etirwe ashuwots bofiniru morronat bokeewiru c'ash jamosh boosh orowe eteetwe. ");
INSERT INTO bwo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ernmó S'ayn shayir c'ashetu jamo dúre dúrosh bo morro bo aatsa b́ wotiti bako b́ jamon boosh orowe eteeratse.» ");
INSERT INTO bwo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iyesus han b́ keewwere, «Kim shayire bíyatse fa'oni,» bo ettsosha b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Iyesus indnat bí eshwotsn bíyok boweyi. Uratsno need'dek't bíyok asho woshat bo s'eegi. ");
INSERT INTO bwo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Bín gúúrdek't́ beyiru ashuwots, «Hamb! nindnat n eshwots úratse need' dek't neene bogeyiri» ett bokeewi. ");
INSERT INTO bwo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Bí were «Tind kone? Tí eshwots konotsne?» ett bí aani. ");
INSERT INTO bwo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Bín gúrdek't́ beyiru ash aywots maantsan s'iilfetst, «Eshe! tindnat ti eshwots hanotsiye! ");
INSERT INTO bwo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ik' etts jamo k'alitwo ti'eshu, tmishu, tindu bíne.» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iyesus aani aats k'ari ganoke daniyo dek't b́tuwi. Ayidek't ayts ash asho b́ maants waat bokakwetsotse bí aats k'aratse fa'a jelbuts kindt be b́dek'i, ash jamonúwere aatsi k'ari gúúratsa b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ay keewwotsnowere jewron boosh b́dany. B́daniyoro boosh hank'owa bí'et. ");
INSERT INTO bwo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«K'ewere! goshtso b́shooko shookosh dek' b́keshi. ");
INSERT INTO bwo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","B́shookfere maay shook ik iko weeri gúrats fed' b́wtsi. Kafwotswere waat mec'dek't maa bok'ri. ");
INSERT INTO bwo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Shook k'osho shawi ayo bíaalok dats t'orats fed' b́ wtsi. B́ datso shawi ayo b́t'ut'tsotse manoor bos' b́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","B́ wotiyalor aawo bí'ats b́keshtsok'on shoolb́wtsi. Dashan ay geenzts s'ap'o b́ deshawotse shuuk' b́wts. ");
INSERT INTO bwo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","K'osh shookonúwere angits t'ugi taalots fed'b́wtsi. Angitsonu bí eentsok'on guk'b́dek'tsosh shuwalo b́ oori. ");
INSERT INTO bwo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Shook k'osho dats sheengats fed'at bos'b́wtsi. B́ bos'onwere eent shuwo b́imi, k'atso shasho, k'atso keez úbo, k'atsonúwere balo b́shwi.» ");
INSERT INTO bwo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Manats dabt́ Iyesus, «Shishts waaz detstso k'ewde'e!» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Iyesus bí'aali b́ wotor b́ shuuts sha'iru ashuwotsnat tatse git b́ danifwotsnsh jewron b́keewts keewi biitso boaati. ");
INSERT INTO bwo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Bíwere boosh hank'owa bí et, «Itsho Ik'i mengisti jango ááshts keewo it danetwok'o imere. Úre beyirwotsshmó boosh jamo jewrone keeweti. ");
INSERT INTO bwo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Man b́wotitwere, ‹Bo Ik'omaants aanarr, Bomorro boosh orowa eterawok'owe,› S'iilo s'ilfetsr bo be'awok'o Shísho shífetsr bot'iwintsrawok'owa,» eteetsok'one. ");
INSERT INTO bwo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Iyesuswere hank'owa boosh bí et, «Itshowere jewron keewetsan galiyalkeya? Bére, k'osh, jewron keewets jamwotsi ak'alde'erniya t'iwintso itfaliti? ");
INSERT INTO bwo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Shookirwo Ik'i aap'oni b́ shookri. ");
INSERT INTO bwo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ik' aap'tso shookewor, shooko shookere werindats fed'tsman b́kitsir Ik'i aap'tso bok'ebor manóór shed'ano wáát bonibitse shooketsman mec'dek' b́wtsts aashwtsi b́ kitsir. ");
INSERT INTO bwo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mank'o dats t'orats shooketsman b́kitsir, Ik'i aap'o boshishor manóór gene'on dek'ts ashuwotsi. ");
INSERT INTO bwo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ernmó manórisha bako bonibotse s'ap' de'atse. Muk'i boteshiyakon Ik'i aap'atse tuutson gishewo wee gond bek'o boats b́bodal manoor dihiniye bowtsiti. ");
INSERT INTO bwo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Angitsi taalots shooketsonmó b́kitsir Ik'i aap'tso k'ebiru ashuwotsi. ");
INSERT INTO bwo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Wotowa eree datsanatsi asaabiyo, gizi shunonat k'osh wotera tewnon bonibots kindr Ik'i aap'o gu'u b́dek'etwotse shuwalo b́ ooriti. ");
INSERT INTO bwo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Dats sheengats shooketsonmó, Ik'i aap'tso shisht t'iwintsdek't k'aaúdek'tswotsi b́kitsir. Man naaro k'atso shasho, k'atso keez úbo, ik ikonúwere bal shuwa b́shuwit. ");
INSERT INTO bwo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","«Asho c'eesho c'eeshde'e gongrots gedfamó wee oosho bí ats gúp'shfá? B́ gedfo b́ shááno b́be'etwok'o grgjiyatsosha? ");
INSERT INTO bwo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mank'o áátsetso b́ be'erawo, áshtso danerawon ooreratse. ");
INSERT INTO bwo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Eshe shishts waaz detstso k'ewde'e!» ");
INSERT INTO bwo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Aani Iyesus boosh hank'owa bí et, «It k'ebiru keewosh it tooko korde'ere, it tatsts tatsik'ac'on itsho tatsetwe, ikinwere itish ayide'erni dabeti. ");
INSERT INTO bwo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Detstsosh dabde'e imetwe, deshawatsnmó dab́ b́ detstsonor bí'atse k'aa'úniye dek'eti.» ");
INSERT INTO bwo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Manats dabt, Iyesus hank'owa bí et, «Ik'i mengistú datsats shook shokirw ashoniye bi ari. ");
INSERT INTO bwo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ashman t'ú tokritwe, aawo tuwitwe, aawk'o b́wottsok'o b́danawo shooko boc'b́wtsiti, een b́wtsiti. ");
INSERT INTO bwo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Datsunu b́tookon shino b́bos'o, ilo b gimbo kitsitwa, manyako b jáábatse shuwo daatsetwe. ");
INSERT INTO bwo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mayonúwere borbwtsor mááy kakwo b́bodtsotse asho manoor maac'iro k'anib́k'riti.» ");
INSERT INTO bwo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iyesus hank'owa bí et, «Ik'i mengstu kontoniya no nutsiti? Himo egoneneya aride'e no kitsiti biina? ");
INSERT INTO bwo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Snafic'i aawniye bi ari, bi shookewor datsatse fa'a shook jamotse múk'efuniye. ");
INSERT INTO bwo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Bi shookeyakonmó eenr bos' jamwotsiyere bbogeti, darotsi kafwots bshirotse kúto aade beyo bofalfetsosh een een jabwotsi kish dek'etúwane.» ");
INSERT INTO bwo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iyesuswere ashuwots t'iwintsdek'o bofalitwok'on, hanank'ón b́ keewo ay jewron boosh b́keewfoni. ");
INSERT INTO bwo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Bí b́ jewrerawo boon daniraka b́tesh, bo'aali bowootormo b́ danifwotssh jamkeewo iza b́ izfo. ");
INSERT INTO bwo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Manots kooc' Iyesus b́ danifwotssh, «Aats k'araniye bak'ets kimone» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ash asho k'azk'rat biyats keshdek't b́beyir jelbúts Iyesusi dek't boami. Jelb k'oshwotswere towat fa'ano botesh. ");
INSERT INTO bwo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Eegurahi kúp'o aatsatse tuut jelbuts aatso b s'eenfetso jongon giwts aatso jelbu togo dek't b́ tuwi. ");
INSERT INTO bwo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mank'o b́wotor Iyesus, jelbu shuutso maantsi kayotse k'oyo k'oy dek't b́k'efera b́tesh. B́ danifwots bín tuzdek't «Danyifono! noo nó t'affe nee no kis'o deshatsiya?» bo eti. ");
INSERT INTO bwo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Bíwere tokrotse tuut jongman bíhadi, aats k'armanshowere «S'ik eree» bí eti. Jongonu k'az b́k'ri, ay dek' s'ik etb́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Iyesuswere, «Hank'o itshatir eegoshe? Aak'owe imnetiyo it t'ut'i?» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Bowere ay shatwtsat, bo atsatsewo «Jongonat aats k'aron bísh bo aleyirwan kone bíwo?» bo eti. ");
INSERT INTO bwo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Gelil aatsk'aro jelebon kímt Gergesenon datsomand am bobodi. ");
INSERT INTO bwo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Iyesus jelbwatse b́ oot'tsok'on kim shayiron detsets ash iko doowi beewoke kesht manóór gonke b́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ashman doowi ganoka b́befo, konúwor habilyon tifr bín ned'iyosh falraka. ");
INSERT INTO bwo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ayoto muk'onat habiliyona bín tipefo, ernmó habiliyono k'ut'a b́k'ut'fo, muk'ono tishdeni b́juwefo mansh konwor bín deshde'er ned'iyosh falfo aali b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Úni aawonowere t'uwe aawon b́ned'irawo doowi bewokonat guri aab abaatse anaanar b́kuhefoni, bí atsonowere shútson k'ut'de'erni b́gaawifo. ");
INSERT INTO bwo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Bíwere Iyesusi wokoon b́ bek'tsok'on b́maand wos't b́gubron tuk'maldek't bísh b́sagadi. ");
INSERT INTO bwo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","K'aari eenon k'et'efetst́, «Nee Ik' eeno naay Iyesuso! Nee tiyoke eeg kis'e ndetsi? Ik'i shútson neen k'onre, oona neesha! taan ono bek'shk'aye!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Man bíettsonwere, «Nee gond shayirono ashaanitse kee!» ett azazat b́teshtsosha. ");
INSERT INTO bwo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iyesuswere «N shúútso kone?» ett bíaati, bíwere «Aywotsi nowottsotse t shútso kes'i jirwotsi.» ett bí aani. ");
INSERT INTO bwo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Datsmanatsnowere boon b́ giisherawok'o ayidek't b́k'oni. ");
INSERT INTO bwo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Manokno guritsi s'eeno guri ganoke jinirwots fa'ano botesh. ");
INSERT INTO bwo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Mansh «Oona neesha! amr guritswotsits nokindish noon bazik'aye,» ett bok'oni. ");
INSERT INTO bwo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Iyesuswere boosh bíeekere, gond shayirwots ashmanitse kesht guritswotsits bokindi, guritsi s'eenotse git kumok'o wotts guritswots gohatse tengsheyat oot't aatsi k'arots lim bowtsi. ");
INSERT INTO bwo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Gurits jinirwots giifat k'az boami, kitonat gat'ariyon keewman keewbok'ri, ash ashonwere wotts keewman bek'osh bo maa mootse bokeshi. ");
INSERT INTO bwo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Iyesusmaants bowatsok'on, kim shayiron detseyat teshts ashman bí'atso dandek't, b́ taho tah dek't, b́ befere bek't tek'bowtsi. ");
INSERT INTO bwo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Man shin bek'ts ashuwotswere kim shayirman bítse b́ s'eents ashonat guritswotsitse wotts jamo waatswtssh bokeewi. ");
INSERT INTO bwo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Manóór datsmanatsi ashuwots Iyesus bodatsatse keer k'ay bíametwok'o bo k'oni. ");
INSERT INTO bwo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Iyesus jelbúts kindoke b́befere fo'erawo bín s'eent teshts ashman, «Oona neesha! n shuutso amna» ett bín b́k'oni. ");
INSERT INTO bwo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Iyesusmó bísh eekeratse, ernmó, «N gal amr doonzo aawk'o een keewo neesh b́fintsok'owonat aak'o k'aldek't neesh maac'o b́k'ewtsok'o n maa ash ashosh keewwe,» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ashmanwere Iyesus bísh b́k'alts jamo «Tats kitwotsi» eteets datsatse keewfere b́ tuwi, shishts jamwotswere bo adi. ");
INSERT INTO bwo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iyesus jelbon aats k'aroniye bak'ets aani kímt bí aaniyakon ay asho bíyok kakwe b́wtsi, manormó bí aats k'ari gúúratsa b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Manoknó ayhudiwots Ik' k'oni maa naashwotsitse iko fa'e b́tesh. Iya'irosi eteets asho Iyesusi b́bek'tsok'on b́ tufishirots diht ");
INSERT INTO bwo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","«T na'a múk'efu k'iroshe bi'etiri, woorr kashon b́beyishe oona neesha! waar n kisho biyats gere!» ett kúp'idek't b́ k'oni. ");
INSERT INTO bwo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iyesuswere bínton towat bí ami, ay ashuwotswere b́ jafrats sha'at bísh datso bot'ebifere botesh. ");
INSERT INTO bwo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tatse git natosh s'atso kud'at ned'ok'azt bí'ere gond bek'iru mááts iku fa'a btesh. ");
INSERT INTO bwo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","At dants aaywotsok sha'a mawat gondo bek'aat b detsts giz jamo ishbazateni b tesh. Ernmó iki gondefera bí'ami bako b́ jamon shamp'eratsa. ");
INSERT INTO bwo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Bi were Iyesus jango shishat bteshtsotse gifniyeyiru ash dagotse b́ jiik'weeron waat b́ taho b t'awi. ");
INSERT INTO bwo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Hano b k'al, «Dab b́ tahats t bodal kashitwe,» etaat amanat b teshtsotsna. ");
INSERT INTO bwo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","S'ats kud'manu manór need' b́wtsi, b shodotsno b́ kashtsok'o bi atsotse bish b́shiyeyi. ");
INSERT INTO bwo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Iyesuswere manoor ango bí'atse b́keshtsok'o danb́k'ri, ashuwots maants wongr ett aanat, «Kone t taho t'awitsoni?» ett bí aati. ");
INSERT INTO bwo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","B́ danifwotswere, «Ash asho bí atsatsewo gifniyefetst n shuutso b́ sha'efere bek'fetsatniya ‹Kone ti ats bodi?› ni etiri?» bo et. ");
INSERT INTO bwo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Bíwere man k'altso koni b́ woto bek'osh wongr et aanat b́ s'iili. ");
INSERT INTO bwo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Máátsmanmo bi ats wottso b dantsotse shatoon k'ewefetsat b́ shinats dihat ari keewjamo bísh b keewi. ");
INSERT INTO bwo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Bíwere «T ni'e n imnetiyo neen kashire, jeenon amee, n gond bek'otsnowere kashowe,» bish b́ eti. ");
INSERT INTO bwo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iyesus man keewoke b́befere, ayhudiwots Ik' k'oni maa jishirwo gále waats ashuwots ayhudiwots Ik' k'oni maa jishf́mansh, «N naa'u k'irwtseraniyere! eshe haniyak eegoshe danifo n shambiriri?» bo eti. ");
INSERT INTO bwo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iyesusmó man shisht ayhudiwots Ik' k'oni maa jishfmansh, «Amanowe bako shatk'aye!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Iyesus P'et'rosnat Yak'obn, ando Yak'ob eshu Yohansiye okoon konúwor b́shutsoshoyde b́ warawok'o b́baziyi. ");
INSERT INTO bwo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ayhudiwots Ik' k'oni maa jishfman mook bobodtsok'on, Iyesus ashuwots waac'refetst bo eepfere, bo kuheferowe b́ bek'i. ");
INSERT INTO bwo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Gítsomand kindtnu, «Wac'r jamannat eepan, eegoshe? Na'ú tokra b tokri bako k'irratsane,» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ashuwotsmo bí atsa bomiis', Iyesusmó bo jametsi mootse kishbazt, na'ú nihnat indun, b́ shuuts shairwotsi dek't na'ú beyiru maa kayots b́ kindi. ");
INSERT INTO bwo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Na'ú kisho dets dek't, «T'alita kumi!» bish bí et. Man etonwere «Nee na'a múk'na'une neesh tuuwe etfe,» eta. ");
INSERT INTO bwo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Biwere tatse git nati na'a b wottsotse manóór hake bak sha'o dek' btuwi, hank'o b́ wotoro ashuwots ayidek' bo adi. ");
INSERT INTO bwo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Iyesusmó wotts keewan konúwor b́danawok'owa koneshor keew k'ayere ett, «B meetwo bish imere!» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iyesus manoke kesht b́datsomand b́ weyi, b́ danifwotswere b́shuutso shoydek't boweyi. ");
INSERT INTO bwo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sanbati aawon ayhudiwots Ik' k'oni mootse daniyo dek' b́twi, ash ayonwere manoke daatseyat bín bok'ebfera botesh, boowere «Ashaan keew jaman eewkneya b́daatsi? Eegi naari dane bísh imetsani? Adits keewanotsi aak'o k'aldek'tnya b́finiri?» ett bo adi. ");
INSERT INTO bwo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Aaninwere dabt «Han Mariyam naay mit gashfoniyoshna? Yak'obsho, Yosasho, Yihudsho, Simonsho bo eshwi woshna? B́mishots hanoke nontoniyosha bofa'oni?» ett gac'at bín de'aniyere bo oori. ");
INSERT INTO bwo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Iyesusmó, «Nebiyiyo k'osh dats ashoknee mango b́ datsiti, ernmó b́ took datsatse, b́ jagi datsatsnat b́ meyitsi ashuwots dagotsnmo gac'etwe,» ett boosh bíaany. ");
INSERT INTO bwo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Manokno k'ats shodetswotsats b́ kisho gedt kashiyoniye okoon adits finwotsi k'alo falratse. ");
INSERT INTO bwo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ash asho amaneraniyere bo'ortsatse tuutso ayi dek't bí'adi, maniyakon Iyesus gál gálots ananatni b́ danifo. ");
INSERT INTO bwo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tatse gitwotsi bíyok s'eegdek't git gito woshdek't b́woshi, kim shayirwotsatse alo boosh bí imi, ");
INSERT INTO bwo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Boamor weerindatse gumboniye okoon mish wotowa, k'arc'itono, gizono bo edots desh bode'aawok'o boon bí azazi. ");
INSERT INTO bwo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Boshowere hank'o bí eti, «It tufots c'aamo gerde'ere bako git kito dab kark'ayere, ");
INSERT INTO bwo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Aawoknoor ash maa ikots it kindor, datsman itfakshfetsosh itkindts maamanitsne it tesheti. ");
INSERT INTO bwo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ashuwots iti ibiyo k'ayr it keewo k'ebono bok'azts jamoke it tufatsi k'undo tebk'rar keer k'ayamere, manwere bo ats gawe b́ wotitiye.» ");
INSERT INTO bwo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Woshetswotswere manoke kesht, ash jamo naandrone bí'etetwok'o bodany. ");
INSERT INTO bwo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Fo'eraw aywotsnowere bokishi, ay ashuwotsatso zeyito futt bokashiyi. ");
INSERT INTO bwo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Iyesus shútso eent jamoke daneb́wtstsotse, nugúso Herodiswor b́ jangman shishb́k'ri. Ik ik ashuwots, «Gupfo Yohans k'irotse tuure, manshe adits keew jamanotsi k'aliruwo bíne» boetfere botesh. ");
INSERT INTO bwo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","K'oshwotswere, «Bíwo Eliyasiye» bo etfera botesh, oortswotswere «Yotsi nebiywotsitsi ikok'oyiye» bo etiri. ");
INSERT INTO bwo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodismó jam man shisht, «Han b́biimb tk'ut'itso Yohansiye, hambe! bík'irotse k'az tuure,» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodis bí'eshu Filip'os máátsu Herodyadi b́dek'tsosh, Yohansi biyatse tuutson detsidek't típmoo gedt́ bín tipitni b́ b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohans b́tipewere, Herodisish «Ni eshu máátsu dek'o nemotse aaliye!» err b́ keewfosha b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodiyadu mansh iirat Yohansi úd'iyosha b́geefo b́teshi, ernmó falratsa. ");
INSERT INTO bwo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodiswere maniye shin Yohans kááwonat S'ayn b́woto b́ dantsotse bín sharfetsni b́ kotiifo. Herodis Yohans keewo b́ shishtsi taawo kic'a b́ kic'efo, b́woteferor geneeúwona bín b́ k'eebfo. ");
INSERT INTO bwo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodis b́ shuweyi aawo mangiyosh naash naashwotssh, kes' jishirwotssh, Gelilitse fa'a daneets ik ikwotssh moonat ushon k'ani b́k'ri. Mannowere Herodiyad sheeng weero datsbdek'i. ");
INSERT INTO bwo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Manno Herodiyad ni'i móónat ushi moots kindat k'afefetsat Herodisnat bínton teshts ibwotsi b gene'ushi, naashonwere na'úsh, «N geets keewo b́wottso b́wotiyalor taan aatwe neesh imetwe» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","«Dab t mengsti badonor b́wotiyal, ni'aatts jamo neesh imetwe!» ett bish b́ taari. ");
INSERT INTO bwo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Biwere bi'indok amaat, «Eego aatuta?» bieti, bi'indwere « ‹Gupfo Yohans tooko taash imewe› err aatwe» bi et. ");
INSERT INTO bwo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Na'únwere manoor kááron naashomand aanat, «Gupfo Yohans tooko saniyots gerde and taash imeyish geefe,» etaat bi'ati. ");
INSERT INTO bwo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nugúsonwere keewmaanatse tuutso ayidek't shiyanbwtsi, wotowa bako s'eegets ashuwots shinatse b́ taartsotse bi attsman bish baziyo geeratse. ");
INSERT INTO bwo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mansh nuguso manoor kotiru kes' kes'fwotsitse, iko Yohans tooko k'ut'de b́ weetwok'o b́ wosh, kes'fonwere tipi maa manits amt Yohans tooko b́ k'ut'i, ");
INSERT INTO bwo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","K'ut'ets tokmano sahaniyots ged dek'wat na'úsh bí imi, na'únwere b indsh imbk'eri. ");
INSERT INTO bwo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yohans danifwotswere man bo shishtsok'on waat b́ duuno dek't bo duuki. ");
INSERT INTO bwo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Wosheetsots boon woshetsoke aani waat Iyesus shinatse kakwe bowtsi, bo danitsonat bo k'alts jamo bísh bokeewi. ");
INSERT INTO bwo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bíwere «Itiye itaal ash aaloke ikmaants amr muk'i kashde'ere,» bí eti, man bí'etwere b́maand weyirwonat amiruwon bo aytsotse misho dab bo metwoko bo t'ut'tsotsne. ");
INSERT INTO bwo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mansh boaali wotosh jelbots kind dek't ash aalok k'az boami. ");
INSERT INTO bwo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bo amfere ay ashuwots boon bek't danbok'r, kit kitotse kesht tufoon wos'fere boshino beshat book kakwebowtsi. ");
INSERT INTO bwo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Iyesus jelbutse b́ oot'or ay ashuwotsi b́ bek'i. Jints deshaw mereerwotskok'o bowottsotse boosh maac'o k'ewbwtsi, ay keewonowere boosh daniyo dek' b́ tuwi. ");
INSERT INTO bwo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Datso ilefere bí amtsotse b́ danifwotsi b́ maants t'int bísh hank'o bo et, «Hanokhaniye worwe, datsonwe ilere, ");
INSERT INTO bwo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Bo metwonu bí altsotse gúranatse fa'a gat'ariwotsnat gal galotse amr misho keew bodek'etwok'o hanotsi deenk'rowe.» ");
INSERT INTO bwo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Iyesusmó, «Bo bometwo boosh it imere» ett boosh bíaani. Bowere «Beree am bo meet misho git bal dinariyon kewde boosh imonowa?» boet. ");
INSERT INTO bwo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Bíwere, «Ambts mishe it detsi? Aab amr s'iilere,» bí eti, s'iiltnwere «Úts mishonat git mus'on fa'ee,» boeti. ");
INSERT INTO bwo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Iyesuswere ash ashosh kakuwe kakuwede'er, atts sismanats bo bezitwok'o b́ danifwotssh bí azazi. ");
INSERT INTO bwo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mansh ashuwots ikok balo ikoko balk'atso kakuwe kakuweyat be bodek'i ");
INSERT INTO bwo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Iyesuswere úts mishmannat git mus' manotsi k'aaú dek't daro maants kááw dek't s'iilt b́ deeri, mish mano tiitsdek't ashuwotssh bo kayitwok'o b́ danifwotssh bí ími, mank'o mus' gitwotsno jamwotssh b́ kayi. ");
INSERT INTO bwo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Jamwots máát bowori ");
INSERT INTO bwo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","B́ danifwotswere meere oorts mishi tiish tisho tatse git mari s'eeno bo kaakwi. ");
INSERT INTO bwo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mishman maats nungshwots taawó úts kumok'oy b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Iyesus manór ashuwotssh ameree etfetst b́ danifwots jelbots wotde'e bak'ets Bete Sayd maants kimr b́shino bok'ut'itwok'o boon bíazazi. ");
INSERT INTO bwo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Maniyere hakon bo atse k'aleyat Ik'o k'onosh guromants b́ keshi. ");
INSERT INTO bwo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Datsonwere b́ ilor jelbu aats k'ari taalotsa b tesh, bímo bíyal datsatsa b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","B́ danifwots bo shinatse jongiru jongatse tuutson jelbu joko maawt bo kic'efere bek'b́k'ri, t'úwotse jed'iy sa'atonat tatse git sa'ati dagotse aats k'aratse shaawefere bo maants b́ weyi, boyere beshar amosha b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ernmó bí aats k'ari abaatse shaawefere bí'amfere meyo boosh bíartsosh bo kuhi. ");
INSERT INTO bwo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jamwots bín bo bek'tsok'on tekbowtsi. Bímó manoor, «Kup'ore shenúwotso! taane! shatk'ayere!» bíet, ");
INSERT INTO bwo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jelbots kindt, bonton beb́dok'tsok'on jongo ned'b́wtsi, b́ danifwotsu ay dek't bo adí. ");
INSERT INTO bwo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Bo nibo dungwtsat, mishatse wotts adits keewman bo t'iwintsrawo ooratni bako, keewan boon adirawnk'e b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Aats k'aro bo kimtsok'on, Genseret'its am bo bodi, jelbu datsats t'intsdek't tipbok'ri. ");
INSERT INTO bwo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jelbu'abatse bo ot'tsok'ón manóór ashuwots Iyesusi danbok'ri. ");
INSERT INTO bwo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Bowere datsman gúratse hake bako wos'fetst Iyesus b́beyiru kááw jamok shodetswotsi es'ats kurdek't woo bo tuwi. ");
INSERT INTO bwo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bí amts jamoke gal galotse, kitotse, gat'ariyotsno shodtswotsi jebats kisht b́ shinats bo t'intsfera boteshi, b́ shemi jilo dab t'awiyosh bín bok'onfo, bíats bodts jamwotswere kasha bokashefo. ");
INSERT INTO bwo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ferisawino eteetswotsnat Iyerusalemn waats Muse nemo danif ik ikwots Iyesusmaants waat bín gúúrdek't kakwebowtsi. ");
INSERT INTO bwo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Iyesus b́ danifwotsitse niwon bo s'aynawo man etonwere kisho bo masherawon misho bomaafere bobek'i. ");
INSERT INTO bwo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ferisawino eteetswotsnat ayhudi eenashwotsn bo niwo koton sheengsh bo kisho bo masherawo marakno bo tesh. ");
INSERT INTO bwo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mank'o gawiyon bo aanoro bo masherawo marakno, wanc'ono, korono, k'áázon dozets kac'onat es'on mashok'o wotts ayo bo nemo bokotfo. ");
INSERT INTO bwo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Hank'o b́wottsotse ferisawino eteetswotsnat Muse nemo danirwots, «N danifwots eenash eenashwots nemo tiitst, eegishe kisho bomasherawo misho bomeyiri?» ett Iyesusi bo aati. ");
INSERT INTO bwo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Bímó hank'o ett boosh bíaani, «It git alberetswotso! Isayas it jangosh, ‹Ash ashaaniye bo noon mec'rone taan bomangiri bako Bo nibo tiyatse woke! ");
INSERT INTO bwo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ash niwo Ik'i nemok'o woshdek't danifetst k'awntsalosh taan bomangiyiri!› ett b́ keewts bek'o aree. ");
INSERT INTO bwo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","«Mansh it Ik'i alo k'azat ash nema it kotiri.» ");
INSERT INTO bwo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Maniye hakon Iyesus hank'owa boosh bí et, «It nemo kotosha etaat Ik'i nemo it tiitsiri, ");
INSERT INTO bwo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Muse, ‹N nihnat nindn mangiwe, aaninu b́ nihsh wee b́ indsh gondo keewit asho úd'ewe,› etre. ");
INSERT INTO bwo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Itmó hank'owa it etfoni, ‹Ash iko b́ nihnat bíndsh k'alo bín geyits keew jamoniye K'urbani wotere› man etonwere ‹Ik'osh imk'rekee› boosh bí'etal, ");
INSERT INTO bwo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","B́ indnat b́ nihi tep'o k'azo falfe etetute. ");
INSERT INTO bwo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Hank'onowere it took nemo k'otosha etaat Ik' aap'tso it gaakiri. Mank'onowere han artso ay keewe it k'aliri.» ");
INSERT INTO bwo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ash ashonowere aani b́ maants s'eegdek't, boosh hank'o bí eti, «It únets t'iwintsde taan k'ewere, ");
INSERT INTO bwo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ash kimshfoniye, ash gitsotse keshetwoniye bako, uratse ash gitsomaants kindirwoniye asho kimshrake! ");
INSERT INTO bwo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Eshe k'ebet waaz detstso k'ewe!» ");
INSERT INTO bwo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iyesus ash asho k'azk'rat moots b́ kindtsok'on b́ danifwots aridek' b́ keewtsman biitso bín bo aati. ");
INSERT INTO bwo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Bíwere hank'o ett boosh bíaani, «Itwere han t'iwintsratsteya? Uratse ash atsi gitsomaants kindit keewo ash kimsho b́falawok'o itsh galeratsa? ");
INSERT INTO bwo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Maac' weeron beshar uromaantsa b́ kesheti bako nibomand amatse». Hannowere Iyesus meetu jamo s'ayin b́wottsok'o b́ daniyi. ");
INSERT INTO bwo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Manats dabt hank'owa bíet, «Ash kimishfwots ashnibotse keshf keewwotsi. ");
INSERT INTO bwo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bowere, gond tewno, wido, úmp'o, ash úd'o, ");
INSERT INTO bwo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","gobo, jaalo, weeri gondo, ash dirsho, shiraats jintsi woto, okooro, onoo, b́ tooko dambaan danbaan detso, kis' deshawo wotonat hanotsiye. ");
INSERT INTO bwo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Gond keew jaman ash nibotsne b́ keshfoniye, ashono b́ kimshfoni.» ");
INSERT INTO bwo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iyesus manoke tuut T'iros kitu ganoke fa'a galots bíami, maa ikots kindit manoke b́ beyirwok'o konwor b́ danawok'o b́ geyi, wotowa bako ááshosh falratse. ");
INSERT INTO bwo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","B na'ú kim shayiron detsets mááts iku Iyesus jango shishat manóór waat b́ tufi shishirots b dihi. ");
INSERT INTO bwo_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Máátsunwe Sirofinik'e dats ashu wotat Griki noon keewf ashi b tesh, biwere bna'ú atsotse fo'erawo b́kishish Iyesusi b́k'oni, ");
INSERT INTO bwo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Iyesusmó, «Nana'i misho de'er kanwotssh imo woteratse aab shin nana'uwots worune,» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Bi were «Aree tdoonzo, b́ woteferor kanwotswor mari shirotse wotde nana'o b́ mafere fed'ts mishi fed'o mafnale,» etaat biaani. ");
INSERT INTO bwo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Mansh Iyesus, «N keewanatse tuutson fo'erawo n na'ú aatsótse keshre, éshe n gál amee!» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Biwere b galomaants bi aanór b na'ú fo'erawo fakshb́k'erere es' abaatse jeenon b k'eefere datsbdek'i. ");
INSERT INTO bwo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iyesus T'iros datsatse kesht k'az bíami, Sidon weeron amt Tats kita eteef datson Galil aats k'aromaants b́ weyi. ");
INSERT INTO bwo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Manoke gidik' wotat, aani dutso b́ maants dek't boweyi, b́ kishono bí ats b́ gedetwok'o bok'oni. ");
INSERT INTO bwo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iyesuswere ashman ashotse k'aldek't bí aali dek' amt b́ jaabo ash man waazots gedt, s'udono tuf ett asho alberono b́ shuu'í, ");
INSERT INTO bwo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Daromaand kááw dek't s'iilt ah ett kasho wosht ashmansh «Eeftah!» bí et. B́ biitsonwere «K'eshewe!» etee. ");
INSERT INTO bwo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Manóró b́ waazo k'eshe b́wutsi, bíalberonwere bish b́ wutsi, ik kic'alono s'ayintsdek't keewo dek' b́ tuwi. ");
INSERT INTO bwo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iyesus keewan konshor bokeewrawok'o ashuwotsi bí azazi, wotowa bako bokeewrawok'o bíazaztsoniye bogshdek't ay dek'tni bokewfo bo teshi. ");
INSERT INTO bwo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Shishts jamwotswere ay dek't adt, «Jam keewo sheengonee b́fiini! gidik'wotsu boshishetwok'o, dutswotswere bo keewitwok'owe b́ k'aliri!» bo et. ");
INSERT INTO bwo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Manoori aawwotsitse aani ay ashuwots kakwe bowtsi, bometwono deshatsno bo tesh, mann Iyesus b́ danifwotsi s'eegdek't boosh hank'o bí eti, ");
INSERT INTO bwo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Ashaanots hamb, taanton keez aawo teshrnee, bometwo eegor bo deshawotse boosh t maac'o k'ewere, ");
INSERT INTO bwo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Hank'on bo k'ak'tsok'on bo gálomants ameree err t fakshiyal weerindatse maawniye bowtsiti, dab boyitse ik ikwots wokooke waaknee.» ");
INSERT INTO bwo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","B́ danifwotswere, «Béré worwotse jam ashaanotssh bodet misho kone daatso faliti?» ett bísh bo aani. ");
INSERT INTO bwo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Iyesuswere, «Ambts misho detsfte?» ett boon bíaati, boowere, «Shawat misho detsfone» bo eti. ");
INSERT INTO bwo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ashuwots datsats beewne bíeti, shawat mishono dets dek't Ik'osh mango b́ ími, tiitsdek't ash ashosh bo imetwok'o b́ danifwotssh b́ ími, boowere ash ashosh bo t'intsi. ");
INSERT INTO bwo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ay woterawo mus' nana'úwotsno detsfno botesh, mus' manots jangosho Ik'o b́údiyakon ash ashosh bo t'intsitwok'o b́ danifwotssh b́ keewi. ");
INSERT INTO bwo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jam ashuwots máát bowori, méére oorts mishi tiish tishono kakut shawat een een maron s'eeno bo k'aaúwi. ");
INSERT INTO bwo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Maats ashuwotsu awd kumok'o wotituno botesh, Iyesus bono ameree ett faksh b́ k'ri. ");
INSERT INTO bwo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Maniyere il b́ danifwotsnton jelbats wotdek't Dalmanut awrajo maants k'azbíami. ");
INSERT INTO bwo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ferisawino eteyirwotsitse Iyesus maants waat bínton moosho dek' botwi, bín fadosh gawt darotse adits keew iko boosh b́kitsitwok'o bín bo'aati. ");
INSERT INTO bwo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iyesus ah ett kashowosht, «Dúranatsi s'oot'o adits keewo bísh k'aleyish eegosh geefa? Aroniye itsh t keewiri, dúranatsi na'osh b́ jamon adits keewo kitseratse!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Boon k'az k'rat aani jelbats wotdek't bak'etsomand k'az b́ kimi. ");
INSERT INTO bwo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","B́ danifwots misho bo battsatse tuutson jelbotse ik mishuniye okoon eegor deshatsno bo tesh. ");
INSERT INTO bwo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iyesuswere «Ferisawino eteefwotsnat Herodis boot' shashatse it atso korde'ere,» ett bí azazi. ");
INSERT INTO bwo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bowere «Han bí etir, daneraka misho no t'ut'tsosha b́wotiti» ett boatsatseyewo bokeewi. ");
INSERT INTO bwo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iyesusewere bo gawirwo dandek't hank'o boosh bí eti. «Misho no t'út'tsosha etaat eegoshe it gawiri? Andoor eegor t'iwintso falawwotsnat danawots itneya? It nibo andoor b́ dungtsok'oneya b́fa'oni? ");
INSERT INTO bwo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ááwo detsfetsat be'aatsteya? Waazono detsfetsat shiyatsteya? Aak'oneya gaweyo itsh b́ k'azi? ");
INSERT INTO bwo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Úts misho úts kúm ashosh t titsor b́ ooro ambts mari s'eene it k'aaúwi?» Bo were «Tatse git mari s'eena» bo eti. ");
INSERT INTO bwo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Mank'o shawat mishono awd kúm ashuwotssh t titsor oortso ambts mari s'eene it k'aaúwi?» Et boon bí aati. Bowere «Shawat mari s'eena» bo eti. ");
INSERT INTO bwo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Bíwere «Beree, andoor t'iwitsratsteya?» Bosh bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Betesayid maantsowere ambobodtsok'on ashuwots dog iko Iyesus maants dek' boweyi, shodtsman b́ shuuítwok'o bok'oni. ");
INSERT INTO bwo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Bíwere bek'falaw ashman b́ kisho detsdek't jishfere gálotse b́kishi, ashman ááwats s'udo tuf ett b́ kisho bíats gedt «Ik jago bek'irwiya?» ett bí aati. ");
INSERT INTO bwo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ááw doogonu kááw dek't, «Ee ashuwots taash be'eyirune, ernmó shaíru mitwotsiye taash bo ariri,» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ando aani Iyesus asho aawwotsats b́ kisho b́ gedi, manoor ashman t'iwitsdek' b́ s'iili, kashatnu jam keewo s'ayintsdek't b́ bek'i. ");
INSERT INTO bwo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Maniye il Iyesus «Galots kindk'aye,» ett b́ galomand bí ametuwok'o fakshb́k'ri. ");
INSERT INTO bwo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iyesusnat b́ danifwotsn Filip'os K'isariya eteyiru dats kayu ganoke fa'a galwots maants botwi, weeratse bobefere Iyesus, «Ash ashuwots taan koni etfnó?» Ett b́ danifwotsi bí aati. ");
INSERT INTO bwo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bowere, «Ik ikwots gupfo Yohansiye, k'atswots Eliyasiye, ando k'atswotswere nebiyiwotsitsi ikoniye etfne neesha,» ett bo aaniyi. ");
INSERT INTO bwo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","«Itmo taan koni etfte?» ett bí aati. P'et'roswe «Nee he, Ik'o futtso neene,» ett bí aani. ");
INSERT INTO bwo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Iyesusere, «T jango konshor keewk'ayere,» ett kúp'shdek' boosh b́ izi. ");
INSERT INTO bwo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Iyesus b́ danifwotsi hank'o ett daniyo dek'́ b́twi. «Ash na'o ay gond bek'o daatso bísh geyife, eenashwotsoke, kahni naashwotsnat Muse nemo danifwotsoke gac'etwe, úd'etwe, ernmó keez aawoniye okoon k'iro da'ar twitwe.» ");
INSERT INTO bwo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Keewano bek'shdek't boosh b́keewi, manóór P'et'ros bín bíaali ash aalok s'eegdek't fayo b́tuwi. «Hank'ó et k'aye» eton bín b́ fay. ");
INSERT INTO bwo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Iyesusmó wongr ett aanat b́ danifwotsi s'ilt́ P'et'rosi, «Nee shed'anan t shutsomandan amee! nee ashka bako Ik'iko gawratsne!» ett b́ fay. ");
INSERT INTO bwo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Maniyere il Iyesus ash asho b́ danifwotsnton s'eegdek't boosh hank'o bí et, «T jafrats woo shuntso fa'e wotiyal b́ tooko juk'rowe, b́ mask'aliyono kurde'er tshuutso wowe, ");
INSERT INTO bwo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","B́ kashu faridek'o geyiru jamo bin t'ut'etwe, s'uznmó t jangonat doo shishiyi jangosh b́ kasho beshide imetwo fari dek'etwe, ");
INSERT INTO bwo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Asho dats jamatsi gaal jamo daatsrr b́ kasho b́t'ut'al eege bísh b́ k'aliti? ");
INSERT INTO bwo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Asho b́ kashu woriyosh aak'o k'awntse dashosh b́ faliti? ");
INSERT INTO bwo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Haalirwotsnat morrets, dúranatsi s'oot'anots shinatse taanat tkeewi jangosh jitsitu jamosh, ash na'o tnih mangon S'ayin melakiwotston t wóór b́ jangosh taawere jitsitwe.» ");
INSERT INTO bwo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Manatse tuut Iyesus, «Itsh aroniye tietiri and hanoke fa'anotsitse ik ikwots Ik'i mengstú een angnon b́ woor bobek'fetsosh k'irrawots fa'ane» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Shirt aawoniye il Iyesus P'et'rosi, Yak'obnat Yohansn s'uzi b́ shutsats dek't, gur ayidek't eeno abaats kesh b́dek'i, bo shinatsno bí aro wone b́ wutsi. ");
INSERT INTO bwo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","B́ shemonu ayidek't golbwutsi, dats jik'atse konwor mashtso mankok'o mayde'er s'ayintso b́falawokó b́ wotefetso nas'buutsi. ");
INSERT INTO bwo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Manoor Eeliyasnat Musen be'eyat Iyesusnton bokeewefere boosh bobe'eyi. ");
INSERT INTO bwo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","P'et'rosuwe Iyesussh, «Danyirwono! hanoke beyo noosh sheenge, eshe iko neesh, iko Musesh, iko Eliyassh wotit keez gofwotsi awone» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","B́danif keezwots ayidek't boshattsotse P'et'eros b́ keewirwo danatse b́teshi. ");
INSERT INTO bwo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Dawnonu waat boon degb́dek'i, dawnotsno, «T shunts na'o haniye! bín k'ewere!» etiru k'ááro b́ shiyeyi. ");
INSERT INTO bwo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Manóóro wongr ett aanat bo s'iile boganoke Iyesus s'uzi bako konnor be'aatsno. ");
INSERT INTO bwo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Guri abaatse bo oot'or Iyesus, «Ash na'o k'irotse b́ tuufetsosh it bek'tsan konshor keewk'ayere» ett boon bí azazi. ");
INSERT INTO bwo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","B́keewtsono k'ebdek't bo nibots detsbodek'i, wotowa bako «K'irotse tuwa etaan eega etek'úna?» ett bo atsatsewo bo keeweyi. ");
INSERT INTO bwo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bowere, «Muse nemo daniyirwots Eliyasiye shino weetwoni bo etir eegoshe?» ett bo aati. ");
INSERT INTO bwo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Bíwere hank'o ett boosh bíaanyi, «Arikee, Eliyasiyere shino weetwe, unono káátsitwe, ernmó, ash na'o mangts gondbek'o b́ dek'etwonat b́ gac'etwok'on guut'etso aawk'one? ");
INSERT INTO bwo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Taamó Eliyasiye shino waare, b́ jangosh guut'etsok'on ashuwots boshuntsok'o bíats k'alrne» etirwe itsha. ");
INSERT INTO bwo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Iyesusnat b́ danif keezwotsn b́ danif ortswotsok aanat boowor ay ashuwots kakweyat boon gúúrdek't bo s'iili, Muse nemo danifwotsu b́ danifwotsnton bo moshfera bo teshi. ");
INSERT INTO bwo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ashjamo Iyesusi bobek'tsok'on adt bo tek'i, b́ maantsó wos't jamó bín bo aati. ");
INSERT INTO bwo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iyesuswere, «Bonton itmoosheyir eegi jange b́ teshi?» ett boon bíaat. ");
INSERT INTO bwo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ashuwots dagotse iko hank'o ett bí aani, «Danifono, gidik' woshts gond shayiron detsetso t na'onee n maants dek'waare, ");
INSERT INTO bwo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Bíyatse b́ twoor bín dike b́dikfoni, b́ nonotse úmbo kisht b́ gasho b́ k'ashfoni, bí atsonwere duunok'o shuu'ini b́ wutsefoni, kim shayirmano bo kishish n danifwotsi aatre b́ teshi, ernmó falratsne.» ");
INSERT INTO bwo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iyesuswere hank'o boosh bí eti, «It amaneraw ashaanots! awrish b́ borfetsone itnton t beeti? Awrish b́ borfetsone iti t k'amiti? Aab na'o t maants dowere!» ");
INSERT INTO bwo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bowere na'o b́ maants dek'boweyi, kim shayirmanwere Iyesusi b́bek'tsok'on na'o dikdek't b́ s'ik'íyi, na'onwere datsats p'up'urefetst úmbó kisho dek'b́twi. ");
INSERT INTO bwo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iyesuswere na'o nihsh, «Shodan awre hake bín b́ detsi?» et bí aati. Nihonwere hank'o ett bí aani, «Marmat'on detstniye. ");
INSERT INTO bwo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Úd'osho geeyat ayoto tawonat aatsots b́ fet'foni, ernmó k'alosh nfaliyal oona! noosh maac'o k'ewowe! nonowere tewu'e!» ");
INSERT INTO bwo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iyesuswere, «N faliyala etfi? Amanit ashosh jam keewo faletwe!» bí bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Manoor na'o nih, «Amanonere amanitwe, ernmó amano tmawituu jam keewatse nee taan faliwee!» ett b́ kuhi. ");
INSERT INTO bwo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iyesuswere ash ashuwots dimbirefetst bowaafe b́ bek'i, kim shayirmansh, «Nee dogonat gdik' wotts kim shayironó na'o atsotse n keshetwok'o anarnu bí atsots n kindrawok'o neen azazere!» ett b́ hadi. ");
INSERT INTO bwo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kim shayironúwere k'aari eenon k'eet'at, na'ono ay dek't b́ s'ik'iyakon b́ keshi, na'onúwere duunok'o wotb́wtstsosh aywotssh k'irk arbwtsi. ");
INSERT INTO bwo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ernmó Iyesus na'o kisho detsdek't tuuzbk'rí, na'onu tuut ned'b́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Iyesuswere moots b́kindór b́ danifwots, «Eshe eegoshe kim shayiro noo kisho nomaawi?» ett bí aali boaati. ");
INSERT INTO bwo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Bíwere, «Han naaro Ik' k'ononat s'oomiyon b́ wotiyala bako k'oshon eegonor keyatse.» et boosh bíaany. ");
INSERT INTO bwo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Iyesusnat b́ danifwotsn beyokman k'azk'rat Gelil weeron boami, b́ beyokono konwor b́danetwok'o Iyesus geeratse b́tesh, ");
INSERT INTO bwo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Man b́wottsonwere Iyesus b́ danifwotssh, «Ash na'o ashuwots kishots besheyar ímetwe, bo were bín úd'itúne, úd'eyakonmo keezl aawots tuwitwe.» etfetst boon b́daniri b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","B́ danifwotsmó keewan t'iwintsde'atsno, bo aatrawok'oyisho shatbowtsi. ");
INSERT INTO bwo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Iyesusnat b́ danifwots K'frnahom maants bo waa, Iyesus moots b́ kindihakon b́ danifwotssh, «Weratse waafetsat it mooshiru keewo eebi b́teshi?» et boon bíaati. ");
INSERT INTO bwo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Eree bomó s'ik et bobeyi, manwere weratse bo befere, «No únetsitse bogo kone?» et bo mooshfere boteshtsotsna. ");
INSERT INTO bwo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Bíwere be b́dek'iyakon tatsegitwotsi s'eegdek't, «Konwor wotowa asho shintso wotosh b́geyiyal únoniyere shuuts wotáár únosho guuts woto bín geytwe» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Na'í marmat' iko dek'wat bodagots ned'í bík'ri, gep'dek'tnu boosh hank'o bí et, ");
INSERT INTO bwo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Nana'anotsitse ikok'o t shúútsosha err dek'etwo taano dek'etwe, taano dek'etu jamo taan b́woterawo taan woshtso dek'etwe.» ");
INSERT INTO bwo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohans Iyesussh, «Danifono ash ikoniye n shúútson fo'erawo b́kishfere nobek'i, ernmó, noonton wotob́k'aztsotse bazirone» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Mannowere Iyesus hank'o bí et, «T shúútson adits keewo finefetsr manóór ti atsats gondo keewitwo bí altsotse k'ayk'rore, bazi k'ayere, ");
INSERT INTO bwo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Noon k'eferaw jamó nontoniye, ");
INSERT INTO bwo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Aroniye itsh ti etiri, Krstosk it wottsosh t shúútsosh dab́ aats ik brc'k'o itsh ishitwo b́ k'awntso t'ud'atsee» bíet. ");
INSERT INTO bwo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Konwor asho taan amaniru nana'a múk'anotsitse ikosh t'ug b́ wotoniyere di' shúts mango b́bimbats tífde'er aats k'arots b́ juwewo k'anefe. ");
INSERT INTO bwo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mansh n kishu neesh t'ugo bwotiyal k'ut'de juk'rowe! git kisho deshfetsr gahanemits n juwewoniye kish k'ut' wotar kash weero maants n kindo k'anefe. ");
INSERT INTO bwo_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Gahanem b́ shipir ash maafo k'irraka, b́ taawo tahraw beyoke. ");
INSERT INTO bwo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","N tufo neesh t'ugo b́ wotitkawotiyal, k'ut'de juk'rowe, git tufo deshfetsr gahanemits n juwewoniyere, dúr wotar kashomaants nkindo neesh k'anefe.  ");
INSERT INTO bwo_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Gahanem b́ shipro k'irrawo, b́ tawo tahraw beyoke. ");
INSERT INTO bwo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ni ááwonwere neesh t'ugo b́wotitka wotiyal kishde juk'rowe, git ááwo deshfetsr Gahanemits n juwewoniyere ik ááwetso wotar Ik'i mengstots kindo neesh k'anefe. ");
INSERT INTO bwo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Gahanemitse ash mááf shipro k'irraka, b́ tawonwere tahrakee. ");
INSERT INTO bwo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Wosho beeron b́ s'aynfok'o, asho ik ikon tawon s'ayno bín geyitwe. ");
INSERT INTO bwo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Beero sheenge, ernmó, beeri shaawo b́t'út'al eegneyá bín it shawshiti? «Ititsere shuneyi beeri shaawo beewe, it atsastewo ik wotarr jeenon beewere,» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iyesus manoke tuut, Yordanos fokoniye bak'etsonat Yihud datso maants bí ami. Aydek't ayts asho aani b́maants ko'ee b́wtsi, bíwere bali b́k'alfok'owa b́danyfo. ");
INSERT INTO bwo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fersawino eteetswotsitse k'atswots bíyok t'iinbodek'i, bín fado geeyat, «Asho máátso b́fakshitwk'o nemotse fa'áá?» ett bín bo'aati. ");
INSERT INTO bwo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Iyesuswere, «Muse keewan jango iti bí'azaztso eebi?» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bowere, «Museyiyere bin b́fakshtsok'o kitsit work'ato ímr b́ fakshitwok'o wotowe etre» bo eti. ");
INSERT INTO bwo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iyesuswere hank'o ett boosh bíaani, «Museyiyere tzaziyan itsh b́ guut' it maac'o kup'at bíere shisho itk'aynee, ");
INSERT INTO bwo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ernmó shintson azeetswotsi bíazor dek' b́ tuutsok'on ‹Ik'o nungushonat máátson woshdek'tni bíaziye. ");
INSERT INTO bwo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mansha asho b́ nihnat bí indn k'ayr b́ máátsunton ike b́wotiti. ");
INSERT INTO bwo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Gitwotswere ik atse bowotitye,› maniyehako git bowoto b́ oorere ike bowotiti. ");
INSERT INTO bwo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Eshe Ik'o ik b́ woshtso asho k'alk'aye.» ");
INSERT INTO bwo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Moo maants bo aanor b́ danifwots keewman jango aani Iyesusi bo aati. ");
INSERT INTO bwo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Bíwere hank'o ett boosh bíaany, «B́ máátsu fakshr k'osh mááts dek'etwo b́ máátsu ats dabt dek'ts gobetso wotere, ");
INSERT INTO bwo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mank'ó b kenihatse faksheyar k'osh nungushosh mááts ametuwú bíwere gobetsu woteraniye etee.» ");
INSERT INTO bwo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Boon b́ shuíítwok'o nana'o Iyesusok dek'tboweyi, ernmó b́ danifwots nana'a dek'weyirwotsi bo hadi. ");
INSERT INTO bwo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iyesuswere man b́bek'tsok'on b́ danifwotsi fayat hank'o boosh bíet, «Ik'i mengstu hanotsk'owwotssh b́wottsotse k'ayere nana'uwots tiyok wone, boon bazik'ayere, ");
INSERT INTO bwo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Aarikoniye itsh ti etiri, na'ok'o wotar Ik'i mengstu de'aawo b́jamon bits kindratse.» ");
INSERT INTO bwo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Maniye il nana'uwotsi matdek't b́ kisho bo ats geddek't boon b́ deeri. ");
INSERT INTO bwo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iyesus manoke kesht amoke b́befere ash iko b́maand wos'fere waat b́ shinatse tuk'maldek't, «Doo danífono, dúre dúri kasho daatsosh eeg k'alo taash geyifa?» ett bín bí aati. ");
INSERT INTO bwo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iyesuswere hank'o ett bísh bí aaniy, «Eegoshe doono taash nieetírí? Ik' ikoniye okoon konúwor dówó aaliye, ");
INSERT INTO bwo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","B́ tzaziwotsi danfnee, boowere, ‹Úd'k'aye, gobo amk'aye, úmp'k'aye, kooto gawk'aye, dirshk'aye, n nihnat nindn mangiwe› eteetswotsiye.» ");
INSERT INTO bwo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ashmanwere, «Danifono, tzazi hanotsi na'ortson kotdek're» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iyesuswere bín s'iilt shunbk'ri, et hank'o bísh bíet, «Neesh ortsu ik keew fa'ane, amee, ndetsts jáámo kemr n gizo tugretswotssh ime, ko'ííyets gaalo darotse daatsitune, manyere hakon t shutsats wowe» ");
INSERT INTO bwo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ashmanwere man b́shishtsok'on shiyanon b́ shiitso aak'bwutsi, aydek't detstsi b́ wottsosh shiyanefere k'az bíami. ");
INSERT INTO bwo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iyesus wongret aanat b́ danifwotsi s'iilt, «Gaaletsosh Ik' mengstots kindo aak'o kic'ike!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","B́ danifwots b́keewman shisht bo adi, Iyesusmó aani hank'owa bí et, «Nanawotso! Ik' mengsto maants kindo aak'o kic'itke! ");
INSERT INTO bwo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Gaalets asho Ik' mengtots b́ kindoniyere kambulo mafi fúrotse b́ besho ketefee.» ");
INSERT INTO bwo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","B́ danifwots ayidek't adt, «Béré hank'on kone fal kashitwoni?» ett bo atsatseyo bo'aateyi. ");
INSERT INTO bwo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iyesus bomaand s'iilt, «Arikon keewan ashuwotssh faleratse, Ik'oshmó faletwe, Ik'oshe jám keew falefe» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","P'et'roswere, «Hamb, noo úno k'azk'rat n jafratse waarone» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iyesuswere hank'o ett bí aani, «Aaroniye itsh ti etírí, t jangonat dooshishiyi jangosha ett b́ moo, wee b́ eshuwotsi, b́ mishotsi, b́ indi wee b́ nihi, wee b́na'ó, wee b́ detstso k'azet asho bogo daatsitwe, ");
INSERT INTO bwo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Dúranatsnoor gisheyonton dab́ moowwotsi, bí eshwotsi, b́ mishuwotsi, b́ nana'o, b́ taaronowere bal kisho daatsitwe, weyiru datsatsno dúre dúri beyo daatsitwe. ");
INSERT INTO bwo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Wotowa eree shinatse fa'a aywotsitse shuutstsi wotitune, shutsts teshtswotswere shintsi wotitune.» ");
INSERT INTO bwo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Iyerusalem maants daamet weerindatse bosha'efere, Iyesus bo shin shinatsa b́ sha'iri b́tesh, b́ danifwotswere keewanatse tuutson bo adi, b́ shutsatse weyirwotsu shat bowtsi. Aaninwere tatsegitwotsi bíyok t'intsdek't, bí ats bodet keewi jango hank'o ett boosh b́ keewi, ");
INSERT INTO bwo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Hamb Iyerusalem maants amishee no etiri, Ash na'oniye kahni naashwotsnat Muse nemo daniyrwotssh beshide'er imetwe, boowere k'iri keewo bí ats angshitune, Ik'i ash woterawwotssh beshide'er imetúnee, ");
INSERT INTO bwo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ik'i ash woterawotswere bí ats kaashetúne, bíats s'udetune, bíno jot'etune, úd'itune, ernmó keezl aawoniye okoon tuwitwe.» ");
INSERT INTO bwo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebdiwos nanauots Yak'obnat Yohansn Iyesusok t'int, «Danifono, neen nok'onitu jamo noosh nk'alitwok'o geefone» bo et. ");
INSERT INTO bwo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Bíwere, «Itsh eeg tk'ale it geyi?» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bowere, «N mengsti mangotse noyitsi iko n k'ano maants noyitsi iko n giromaants no beetwok'o alo noosh ime» bo et. ");
INSERT INTO bwo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Iyesusmó, «It it k'onírwo danatste, taa t úshet gond bek'i wanc'o úsho falituteya? Taa t gupet gupewono it fal gupeetuteya?» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bowere, «Ee, falitwone,» bo eti. Iyesuswere hank'o boosh bí eti, «Arikee taa t úshet gond bek'i wanc'o úshetute, taa t gupet gupewono gupetute, ");
INSERT INTO bwo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ernmó t giromaantsonat k'anomaants beyo imetwo taanaliye, han boosh ímeetwots Ik'o boosh b́k'anítswots s'uzshe.» ");
INSERT INTO bwo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Oorts tatswots man shisht Yak'obnat Yohansats fayo dek'botuwi. ");
INSERT INTO bwo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Iyesus jamwotsi b́ maants s'egdek'et boosh hank'o b́ eti, «Ik' ash woteraw ashuwotsats naashtswots, ash k'eezirwotsi err s'egeyirwok'onat bo jishirwotswere bo atse alo bo detstsok'o danfte, ");
INSERT INTO bwo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ititsnomó mank'o woto geyiratse, it dagotse een wotó geyirwo, it guuts woto bísh geyife, ");
INSERT INTO bwo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mank'o ititse jamoniye shintso woto geyirwo jamosh guuts wotowe. ");
INSERT INTO bwo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ash Na'oniyere ashuwotssh finonat b́ kashu ay ashuwots bin bokashit k'awntso woshde'er ímosha b́ weyi bako bísh bofinitwok'o waratse.» ");
INSERT INTO bwo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Maniyere il Iyesus b́ danifwotsnton Iyariko kito maants b́ weyi. Beshatnu kitotse kesht bí amor ayidek't ay ashuwots b́ jafrats bo sha'efera botesh, T'imewos naay Bert'elemiwosi eteets ááw dog ash iko weeri gúúratse bedek't k'ono b́ k'onfera b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nazrettso Iyesus man weeron b́ beshirwok'o danb́k'rtsok'on, «Dawit naay Iyesuso, oona neesha! taash maac'ó k'ewowe!» etfets kuho dek't b́twi. ");
INSERT INTO bwo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Aaywotsu, «S'ik eree!» ett bín bo hadi, bímó, «Dawit naayo aage! Oona neesha maac'o taash k'ewowe!» etfetst aydek't bogshdek't b́ kúhi. ");
INSERT INTO bwo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iyesuwere need'dek't, «Bín s'eere!» bí eti, boowere dogosh, «Eree kup'owe! tuuwe! Iyesusiye neene b́s'egiri!» bo et. ");
INSERT INTO bwo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bíwere b́ shemó juuk'rat t'oolat tuut Iyesusmaants bíami. ");
INSERT INTO bwo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iyesuswere, «Neesh eeg tk'alish geefi?» ett bín bí aati. Ash ááwu dogonwere, «Daniyrwono! oona neesha! ti'ááwo b́ bek'etwok'o taash woshwe,» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Iyesuswere, «Eree! amee, n imnetiyoniye neen kashire,» bí eti. Ashmanwere manoor bek'o b́fali, weerindono Iyesus shuutso shoy dek't b́ tuwi. ");
INSERT INTO bwo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Iyesusnat b́ danifwotsn Iyerusalem maants t'infe boowor Bete Fagenat Bitaniya eteets dats weeron waat Debrezeyit gurok bo bodi, Maniyako Iyesus b́ danifwotsitse gitwotssh hank'o ett b́ woshi, ");
INSERT INTO bwo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«It shinatse fa'a galuts shino ameree, bíyok it bodtsok'on konúwor ik asho bíyats kesh b́ danaw daazna'o tipetso daatsitute, bíno biishde'er hakan de'ewore. ");
INSERT INTO bwo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Konwor asho ‹Eegishe han it k'aliri?› bí'etala ‹Doonzosh b́ geytsotsnee erere, manoró aani doyitwe,› erere.» ");
INSERT INTO bwo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bowere amt daaz na'aman weeri gúúratse maa úratse tipetsok'on daatst bobitsi. ");
INSERT INTO bwo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Manoor manoke need'dek't teshts ashuwotsitse ik ikwots «Daazna'o it biitsir eegoshe?» ett bo aati. ");
INSERT INTO bwo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bowere Iyesus boosh b́ keewtso bo keewi, ashuwotsu k'az bok'r. ");
INSERT INTO bwo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","B́ danifwotsu daazna'o Iyesus maants dek'boweyi, bo tahono daazna'o jik'ats bo geere Iyesus bíats beeb́dek'i. ");
INSERT INTO bwo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ash aywotswere bo shemo weeratsa bo es'fera bo tesh, k'atswotswere bodootse maarets miti jaabo k'ut'dek't werindatsa bo es'fera boteshi. ");
INSERT INTO bwo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Shin shinats beshtswotsnat shutsatse shoy dek't weyiru jamwots, «Hosa'ana! Doonzo shútson wetwóniye deereke! ");
INSERT INTO bwo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Weyiru nonih Dawit mengestu deerekiye! darotsno hosa'ana!» ett bo kúhi. ");
INSERT INTO bwo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iyesuswere Iyersalemi b́ bodtsok'on Ik'i moots b́ kindi, gúúrmanatse fa'a keew jamo b́ s'ííli, datsonu b́'iltsotse tatse gitwotsnton Iyerusalemitse kesht Betaniy maants bí ami. ");
INSERT INTO bwo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Yaatsok'ono Betaniyere bo aanor Iyesus k'ak'bwtsi. ");
INSERT INTO bwo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bmaaró atts belesi mitu wokoon bek't daneraka shuwo biyatse b́datseyala et bmaand bí ami, ernmó bmaand b́ t'inor belesi shuwo b́ borafa'otse maaroniye okoon eegor biyatse daatsratse. ");
INSERT INTO bwo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mansho Iyesus belesi mitush, «Haniyak konwor ni atse shuwo maak'aye!» bí et. Han b́ keewferowere b́ danifwots boshishi. ");
INSERT INTO bwo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Iyerusalemits bobodtsok'on Ik'i moots kindt bítse kemirwotsnat keewiru ashuwotsi kisho dek' b́twi, giz wonyirwots t'arap'ezonat kúrkúnd kemirwots jorwotsi b́ gúp'shi, ");
INSERT INTO bwo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Asho konnor b́ wotiyal, eegi naari k'ac'o b́ wotiyalor, kurde'er Ik' k'oni maa manitse b́sha'erawok'o b́baziyi. ");
INSERT INTO bwo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Hank'o ett boon b́ daniy, « ‹T moo ash jamosh Ik' k'oni maa etitwe!› ett gut'eratsa? Itmo bik'tswotssh goop'ee it woshi.» ");
INSERT INTO bwo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kahni naashwotsnat Muse nemo danyrwots man b́keewfere bo shishi, ash jamonu b́ daniru danmaanatse tuutson adt boteshtsotse bín shatbowtsi, mann aak'ok'alde'er bín bo t'afiyet malo bo geefera botesh. ");
INSERT INTO bwo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Datsonwere b́ iltsok'on Iyesusnat b́ danifwotsn kitotse k'az bokeshi. ");
INSERT INTO bwo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yaats guurok'on weeron beshefetst belesi mit man b s'ap'onton shuuk'wtsat biere bobek'i. ");
INSERT INTO bwo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","P'et'roswere keewman gawdek't Iyesussh «Danifono! hambe, n c'ashts mitú shuuk' wtserane» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Iyesuswere boosh hank'o bí eti, «Ik'one amanore, ");
INSERT INTO bwo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Aarikoniye itsh ti etiri, konwor asho b́ nibotse b́ nibon amanar b́geyiyal keew jamo bísh b́wotitwok'o amanar, guran ‹Hanoke tuur aats k'arots shap'ewe,› bí'etal bísh wotitwe. ");
INSERT INTO bwo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Eshe itsh keewirwe, Ik' k'onon konnari keewonor it k'oniyal itsh k'alk'retsok'o woshr amanore, it k'oniru jamone itsh ímetwe. ");
INSERT INTO bwo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Darotse fa'o itnih it morro itsh oorowe bí etetwok'o, itwere k'onosh itned'or, asho ik keewon iti irire wotiyal bísh orowa erere.  ");
INSERT INTO bwo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","It k'oshwots fints morro boosh orowe eto itk'azalmó darotse fa'o it nih it fints morrosh itshor orowe eraatse.» ");
INSERT INTO bwo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Aaninwere Iyerusalem maants boweyi, Iyesuswere Ik' mootse ananoke b́befere kahni naashwots, Muse nemono danifwotsnat eenash eenashwotsn b́ maants waat́ ");
INSERT INTO bwo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","«Keewanotsi n finir kon aloneya?» himó keewanotsi n k'alitwok'o alo neesh imtso kone? ett bín boaati. ");
INSERT INTO bwo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iyesuswere boosh hank'owa bí et, «Taawere iti ik keewo aatitwe, it taash it aaniyal, taawere keewanotsi kon alon t k'alirwok'o itsh keewitwe. ");
INSERT INTO bwo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yohans gupo Ik'okike moo ashokike? Aab taash anyibe'ere,» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bowere, «And eshe eega erono?» Eton boatsatsewo shiyewo dek't botwi, « ‹Ik'okne› no etal ‹Beree eegoshe bín amano itk'azi?› eteetwe, ");
INSERT INTO bwo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","‹Ashokike,› no eetale?» Mank'o bo erawok'o ash jamo Yohansi arikon nebiyiye bo eetfosh shatbowtsi. ");
INSERT INTO bwo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mansha, «Noo danatsone.» ett bo aani. Iyesuswere, «Béré taawor kon alon keewanotsi tfinirwok'oo itsh keeweratse,» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Manats dabt Iyesus jewron hank'o ett keewo dek' b́ tuwi «Ash ikoniye weyinyi mito b́toki, b́ gúúrono b́ kas'i, woniyo fíís'osh wotit gop'ono ishdekt dóóz b́k'́ri, woyniwo kotoosh wotit ayidekt eents gmbyi kako agb́k'ri, maniyere hakon mítwots datsman goshtswotssh shiro imk'rat wok datso k'azbíami. ");
INSERT INTO bwo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Shuwo b́bodtsok'on, woyni shuwotse bísh bodowetwok'o b́ guutso goshtswotsok b́ woshi. ");
INSERT INTO bwo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Goshtswotsmó b́ guutso detsdek't tog bo ishihak kishi baashon damiy bok'ri. ");
INSERT INTO bwo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Doonzo aani k'osh guutso b́woshi, goshtsmanots manowere fas'dek't́ ketidek't bo damyi. ");
INSERT INTO bwo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Aaninu k'osho b́woshere úd'bok'ri, mank'o ayuwotsi b́woshere, ik ikotsi bo togi, k'oshwotsno bo úd'i. ");
INSERT INTO bwo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","And k'alosh bísh ortso b́ shunts na'o wosho s'uzi b́ tesh, mansh ‹Tnayi mangiyo k'ayatsne› ett gawdek't s'uwi aawatse b́ naay b́ woshi. ");
INSERT INTO bwo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ernmó goshtswots bo atsatsewo ‹Han eshe naatetwoniye! woore bín úd'k'rone! b́ naato noosh wotitwe› bo eti. ");
INSERT INTO bwo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mann detsdek't bo úd'i, woyiny mit beyok manoke kish dek't ur juubok'ri. ");
INSERT INTO bwo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«Eshe weyni doonzo eege b́ k'aliti k'una? doonzo b́tookon weetwe, gooshtswotsno úd'itwe, weyni mitmano k'oshwotsish imk'ritwe. ");
INSERT INTO bwo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Eshe, ‹Gmby agfwots bo gac'ts shútso Bíwere shúts kup'o shúts jamwotsi tungúshatse kaatsde detset shúts wot b́wtsi, ");
INSERT INTO bwo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Manúwere doonzo fínk fínee, no ááwoshowere adike› etirwo S'ayin mas'aafotse nababeratsteya?» ");
INSERT INTO bwo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ayhudi naashwots Iyesus jewrdek't b́ keewtsman boon s'iilitk b́woto t'iwints dek't danbok'rtsosh bín deshdek'o bo geyi, ernmó ashjamo shatt k'azk'rat bo ami. ");
INSERT INTO bwo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ferisawiwotsi eteefwtsnat Herodis jirwotsitse wotts ik ik ashuwots Iyesusi b́ noon keew keewon detsosh b́ maants bo wosheyi. ");
INSERT INTO bwo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bíyok t'iintnwere bísh hank'o boeti, «Danifono, neehe ar keewtso nwotonee danfone, ash shatonat eege taash eteti eton nfints keewo aaliye, Ik'i weerindono aronee n daniyiri, eshe, Rom nugúsosh ereer dasho niwe moo? Niwaalne? Ereerwonomo ereerk'ayono?» bo eti. ");
INSERT INTO bwo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Iyesuswere git alberetswotsi bowottsok'o dan k'rat «Eegoshe taan detso itgeyiri? Aab ambarman dewar taash kitswere,» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bowere ambaro bísh dek't boweyi, bíwere «Ambarmanatse fa'a arunat bíyats guut'ets shúútsu konkne?» ett bíaati. Bowere «Rom nugúsoke,» bo eti. ");
INSERT INTO bwo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Iyesuswere «Béré nugúsoko nugúsosh, Ik'oko Ik'osh ímeree,» ett boosh bíaaniy. Bowere bíaany anyatse tuutson bo'adi. ");
INSERT INTO bwo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","«K'írtswots tuwo aaliye,» etef Seduk'awino eteefwots Iyesus maants waat́ hank'o ett bo aati, ");
INSERT INTO bwo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Danyfono, ‹Ash iko na'o b́shuurawon k'iron b́máátsuatse b́k'aleyetka wotiyal bí eshu máátsmani de'er k'írtso shaato shegrshwee,› ett Muse noosh guut're. ");
INSERT INTO bwo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Eshe, shawat eshwwots fa'ano bo teshi, jam manotssh k'aabo máátso dek't na'o b́ shuurawon k'írb́wtsi, ");
INSERT INTO bwo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Bo eshu gitlonu máátsmani dek't́ na'o b́shuurawon k'irb́wutsi, keezlonwere mank'ó wotb́wtsi, ");
INSERT INTO bwo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mank'oon shawat eshwots bin dek't shááto boshegrishrawon k'irbos'uwi, jamoniyere il ando máátsman k'irbwtsi. ");
INSERT INTO bwo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Shawat eshwots tar taron bín dek'rneree, eshe k'irtswots bo twoor aawshe mááts bwotiti?» ");
INSERT INTO bwo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iyesuswere hank'o ett boosh bíaany, «It it shelir S'ayn mas'afwotsnat Ik'i angon it dartsoshe? ");
INSERT INTO bwo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","K'irtswotsiyere botwor darotse beyiru melakiwotskok'owa bowotiti bako de'aatsnó de'eratsne. ");
INSERT INTO bwo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","K'irotse tuwi janga wotiyal Ik'o Musesh buushitsi tawotse eeg bísh b́keewtsok'o Muse mas'aafotse nababeratsteya? Manwere ‹Taa Abraham Ik'o, Yisak' Ik'o, Yak'ob Ik'o taane,› bí ettsoniye. ");
INSERT INTO bwo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mansha Ik'o kashetswots Ik'a bako k'irtswots Ik'aliye, it imó ayidek'atniye it sheliri.» ");
INSERT INTO bwo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Muse nemo daniyirwotsitse iko bomooshirman b́k'ebfera b́teshi, Iyesus sheengshdek't boosh bíaanitsok'ó nem danifman t'iwintsb́dek'i, Iyesus maants t'iindek't «Jamoniye bog tzaziyo aawne?» ett b́aati. ");
INSERT INTO bwo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ieyesuswere hank'ó ett bísh bíaanyi, «Jamoniye bogts tzaziyo ‹Isra'elo! shiye, Izar Izewer no Ik'oniye ik Ik'e,› ");
INSERT INTO bwo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Neewere Doonzo Izar Izeweri n maac' s'eenon, n be jamon, nnib s'eenon, ni angi s'eenon shune, etirwonye. ");
INSERT INTO bwo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Han arts gitl tzaziyoniye, ‹k'osh asho n tokok'o woshde'er shune,› etirwoniye. Gitetsanotsiyere k'osho bogts tzaziyo aaliye.» ");
INSERT INTO bwo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Muse Nemo danifonwere Iyesussh hank'o bíet «Sheenge, danifono! ‹Ik'oniye ike, bíye oko Izar Izewer k'osho aaliye› etaat nkeewtsoniye aree. ");
INSERT INTO bwo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mansh asho Ik'o maac' s'eenonn, b́ be jamon, nib s'eenon, ang s'eenon shunonat k'osh asho b́ tokok'ó woshde'er shuno bísh geyife, tawats mitsr s'uwiyet wosho t'itsonat k'osh wosho Ik'osh t'intsoniyere git tzaziyanotsi koto boǵfee.» ");
INSERT INTO bwo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iyesuswere Muse Nemo danifman danitelefonat t'iwitson bíaanitsok'ó bek't «Neehe Ik'i mengstuuke wokk neenaliye» bí eti. Maniye hakon Iyesusi aatosh ááwu shuuk'tso konwor aali. ");
INSERT INTO bwo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iyesus Ik' mootse danifetst hank'o ett bíaat, «Muse nemo danyirwots ‹Mesiyo Dawit naayiye,› bo etír eegoshe? ");
INSERT INTO bwo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawit b́tookish S'ayn shayiron jisheyat ‹Ik'o t doonzsh N balangarwotsi n tufi shirots neesh t gerfetsosh T k'ani aaromand beewe,› etre. ");
INSERT INTO bwo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawit b́ tookon ‹Doonza› et b́s'eegiyakon eshe, Krstos Dawitsh aak'oneya b́ naay b́ wotiti?» Ay ashuwotsu gene'úona bín bok'ebiri botesh. ");
INSERT INTO bwo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iyesus b́ daniyor hank'o etre, «Tahi geenz geenzo karde hake bako gúúro, gawyotsno mangts jamo dek'osh shunírwots Muse nemo danyfwotsatse it atso kode'ere, ");
INSERT INTO bwo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bo ayhudiwots Ik' k'oni mootse mangts jooro, móónat úshi beyokno mang beyoko daatsoshe bogeefoní. ");
INSERT INTO bwo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Be'ewosh bo t'intsiru geenzide Ik' k'ononwere webdek't kenih k'irts máátswots detstso bo bik'foni, mansh boon bog angshe kotiri.» ");
INSERT INTO bwo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iyesus giz ko'iyeyiru sat'ni shinatse b́ beewor ashasho sat'nots gizo bo fet'fere s'iilfetst b́teshi, gaalets ayuwots ay gizo bo gedfere bo teshi, ");
INSERT INTO bwo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","T'oow mááts iku waat git santim wotit k'azwotsi manits dabbk'ri. ");
INSERT INTO bwo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iyesus b́ danifwotsi s'eegdek't hank'o bíet, «Aroniye itsh tietiri, sat'nots giz gedts ash jamwotsitse bogsh dek' gedtsuniye t'owu máátsaniye. ");
INSERT INTO bwo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","K'oshwots bo jamets bo ímiye bo detstsotse s'eent oortsoniye, bimó tugrets wotefetsat eegonor b orirawo b detsts jamo imraniye.» ");
INSERT INTO bwo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iyesus Ik' mootse keshfetst b́ danifwotsitse iko, «Danifonó, shútsanotsnat gmbiyanotsn s'ííle, adiknee!» bíeti ");
INSERT INTO bwo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iyesuswere «Gmbi een eenanotsi bek'irwiya? Shúts jamanots gaahitune, shútsats shútso kos'eyarr ooritwo aaliye,» ett bísh bíaany. ");
INSERT INTO bwo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Iyesus Ik' maa shinatse fa'a Debrezeyit guri abaatse b́befere P'et'rosu, Yak'obu, Yohansnat Indriyasn bo aal b́ maants t'iindek't ");
INSERT INTO bwo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Keewan b́wotitwo awre? Jaman wotosh b́t'ínor b́ mlkito eebi? Aab noosh keewwe» eton boaati. ");
INSERT INTO bwo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iyesuswere hank'o ett boosh bíaani, «Konwor iti b́darirawok'o it tooko korde'ere, ");
INSERT INTO bwo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ayuwotsiye ‹Taa Krstos taane!› etfere t shútson wetuune, ay ashono daritune, ");
INSERT INTO bwo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","It ganoke kes'o kes'ewonat kes'i jango it shishor tek' k'ayere, jaman b́woto oreratse, ernmó manoor dúri s'uwo borafa'ee. ");
INSERT INTO bwo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ash asho bíaatsatseyo, mengsto mengstats kes'o tuuzitwe, dats datsatse dats shek'ewonat k'ak'on wotitwe, jaman na'a it'í kic'o b́twortsok'o kic'e. ");
INSERT INTO bwo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Itwere it tookish it tooko korde'ere, ashuwots iti moosh moosheyirwok beshide'er ímetúne, ayhudiwots Ik' k'oni mootsnowere iti jot'etnee, gawo taash it wotitwok'o alirwotsnat naash naashwots shinats angshosh ned'itute. ");
INSERT INTO bwo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ernmó jaman b́woteftsere shino dooshishiyo datsjamatsi ashjamosh bodo bín geyife. ");
INSERT INTO bwo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ashuwots iti deshde angshosh bo t'intsor, ‹Eebí nokewiti k'úna?› err shiyank'ayere, S'ayin shayironi bako itnaliye keewiti. Eshnee, manóór itsh bí ímts mec'ro keewwere. ");
INSERT INTO bwo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Eshuwo bíeshuwi, niho b́na'o k'irosh beshide'er ímetwe, nana'onu bo ind nihats tuwitúne, bonowere úd'itune. ");
INSERT INTO bwo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Teshútsosha err ash jamoke shit'eek wotitute, ernmó k'amde'e b́s'uufetso kup'itwoniye kashitwe. ");
INSERT INTO bwo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Ando daatseyo bín b́geyiraw beewoke t'afo dowet wic'its keewo bek'etute, hanowere nababirwo t'iwintsde'a manóór Yihud datsatse fa'uwots guromants woc'nee, ");
INSERT INTO bwo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Maa tookats keshdk't fa'o ood'r mootse ik keewo dek'osh moots kindk'aye. ");
INSERT INTO bwo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tarotse fa'onu b́ shemdek'o shuuts aank'aye. ");
INSERT INTO bwo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Manóór na'i maac'wotsnat s'aats ishiru na'i indwotsnsh indowe boosha! ");
INSERT INTO bwo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Jaman joshon b́woterawok'o Ik'o k'onwore. ");
INSERT INTO bwo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Man dúr, Ik'o datso bí'azortson tuut andish b́borfetso be'e danerawo gond bek'o wotitwe, shinomaantsishor mank'óó kic'o b́jamon boratse. ");
INSERT INTO bwo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Doonzo aaw manotsi k'awintso b́k'azink'ere konwor kasho falrawnk'e, ernmó marat'ets ashuwotssha eteere aawmanots k'awnetúne. ");
INSERT INTO bwo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«Eshé konwor wotowa ‹Krstos hambe hanokna!› Wee ‹Ekebe ekewokna!› itsh bí'etal bín amank'ayere. ");
INSERT INTO bwo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kootets kirstosotsnat kootets nebiyiwots weetúne, bo boosh b́faleyink'ere marat'etswotswor dab́ bo orerawo dariyosh adits keewo finitúne. ");
INSERT INTO bwo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Jam keewo itsh shino keewre eshe it tooko korde'ere. ");
INSERT INTO bwo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Manoori aawwotsitse, gond bek'maniye il, aawu t'alwitwa, aashitsnu bshaano imatsaniye, ");
INSERT INTO bwo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","K'eenwotsu daaratse fed' s'wituno, daaratse beyiru angwotswere giwwtsituno. ");
INSERT INTO bwo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Maniyere hakon Ash Na'o een angonat een mangon daawnon b́ wááfere bek'etwe, ");
INSERT INTO bwo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","B́ melakiwotsno woshitwe, boowere awd kaaton amr datsonat dari deshok b́borfetso fa'úwotsi, bísh marat'ets ashuwotsi kakwitúno. ");
INSERT INTO bwo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Belesi mitú s'ílde'e biatse dande'ere, bjabwots k'uk'o botworonat bo maarwots bo atóór manoor k'aawo b́t'intsok'o danetute. ");
INSERT INTO bwo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mank'ó itwere jaman b́woto itbek'oor Ash Na'o weet aawo, waat maa úratse b́ karntsok'o dande'ere, ");
INSERT INTO bwo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Arikoniye itsh tietiri, and shuwetsanots bobeshefetsere jaman s'eenetwe. ");
INSERT INTO bwo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Daronat datson beshituno, ti aap'tsonmó b́jamon besheratse. ");
INSERT INTO bwo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Ernomó aawman jango nihoniyere okoon konwor dantso aaliye, darotsi melakiwotswor danatsne, naayonwor danatse. ");
INSERT INTO bwo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","B́ sa'ato awr b́wotitwok'o itdanawotse it tooko korde'ere, kup'ore. ");
INSERT INTO bwo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Manúwere, b́moo k'azk'rat wok datso amts ashoni bíari, bíwere b́gutswotsi ik ikon finats b́ naashiyi, bísh kotfono kup'de b́ kotetwok'o bísh b́ keewi. ");
INSERT INTO bwo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Eshe moo doonz b́weet aawo it danawotse it tooko korde'ere, wee kooc'omand, wee taali titsa, wee baaki k'adore, weyinmó guur weetwe, ");
INSERT INTO bwo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Gawerawo wáárr k'eyoke iti b́ daatsrawok'o kup'ore. ");
INSERT INTO bwo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","«Itsh t keewtsok'o, k'osh jametswots jangoshor kup'ore! etirwe.» ");
INSERT INTO bwo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ayhudi fazigi baaliyonat tushmeyi baaliyo mangiyosh git aawo oorat b́ befere, kahni naashwotsnat Muse Nemo danifwotsn, Iyesusi malon deshde'er boúd'it málo bo geyiri. ");
INSERT INTO bwo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ernomó ash ashuwots fayo tuzitune ett «Baaliyi aawon han k'alratsone,» bo eti. ");
INSERT INTO bwo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iyesus Bitaniya eteets datsatse een shodon detseyat teshtso Simon mootsna b́ tesh. Mishimaratsnó t'int b́befere, mááts iku b́ k'awntso ayidek't shaaw wottsonat mangts Nardosi shitúwo biitse s'eentso, Albast'rosiya eteets shútson dozets blk'at'iyo dek'at bweyi, blk'at'iyo titsat shitúwo Iyesus tookats kuut'bk'ri. ");
INSERT INTO bwo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Manoke fa'úotsitse ik ikwots wotts keewmaanatse tuutson fayat, «Shitúwan dats mec'ro eegoshe bíawashiti? ");
INSERT INTO bwo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Shitúwan kemeyink'ere ik asho ik nato fiinar b́ daatsit k'awntsoniyere bogosh kemde'er gizman t'owwotssh ímo faleyank'e b́teshi!» et bo atsatsewo bo keeweyi, máátsno bo bak'ni. ");
INSERT INTO bwo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ernmó Iyesus hank'owa bí et, «K'ayere Biina! eegoshe bin itkic'iri? Biye taash sheeng keewo k'alraniye, ");
INSERT INTO bwo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","T'owwots jam aawo itnton bo wottsosh it geyor boosh sheengo k'alosh falitute, ernmó jam aawo taan itoke daatsratste, ");
INSERT INTO bwo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Máátsaniye bfaltso k'alrane, t meetso b́ dukeftsre shini k'aniyosh shitúwo futrane. ");
INSERT INTO bwo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Aro itsh keewirwe, dats jik' jamatse doo shishyetsoki beyok jamoke, taash bk'altsann bin gawetwok'o bish keewetwe.» ");
INSERT INTO bwo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tatse gitwotsitse iko, Ask'rot datstso Yihud Iyesusi beshide imosh kahni naashwots maants bí ami. ");
INSERT INTO bwo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bowere man dan bodek'ortsok'on gene'úbowtsi, gizono bísh ímetwone bo eti. Bíwere Iyesusi beshide ímosh k'ants aawo b́ kotfera b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Fazig mereero bo shukeet tushmeyi baaliyi aaw shintsots, b́ danifwots Iyesusok t'int, «Fazigi kooc' misho móósh aawok amr neesh nok'aniyishe n geyeyi?» et bín bo aati. ");
INSERT INTO bwo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Iyesuswere b́ danifwotsitse gitwotsi hank'o et b́ woshi, «Kito maants ameree, manokno aats koro kuriru asho daatsitute, b́ jafrats ameree, ");
INSERT INTO bwo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","B́ kindit moots amr moo doonzosh, ‹Danyfo, t danifwotsnton fazigi kooc'i misho tmeetwok'o taash wotitwo ibi kaashitwoki moo aawne?› etfe erere. ");
INSERT INTO bwo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Bíwere dadri abaatse fa'o k'aniyetsonat es'k'rets maa gawno itsh kitsitwe, manoke taash k'aniwere.» ");
INSERT INTO bwo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","B́ danif gitwots manoke kesht kitu maants bo ami, arikon Iyesus ettsok'on daatsbodek'i. Fazigi kooc' mishono manoke bok'aniyi. ");
INSERT INTO bwo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Datso b́ ílere tatse gitwotsnton towat b́weyi, ");
INSERT INTO bwo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Marats t'int bo maafe Iyesus «Aroniye itsh tietiri, itítsi ikoniye taan beshide imetwe, bíwere and taanton kooc'misho mooke b́ fa'oniye,» bí et. ");
INSERT INTO bwo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bowere keewanatse tuutson shiyanat «Taan wotifa nietirwoni?» Etfetst tar taron boaati. ");
INSERT INTO bwo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Iyesusu hank'owa boosh bí et, «Ashmaniye it tatse gitwotsitse wottso iko and taanton s'awotse ito itdek'irwoniye, ");
INSERT INTO bwo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ash Na'o shin shin b́ jango guut'etsok'on k'iromaand bí amo oreratse, ernmó Ash Na'o beshide imetú ashmansh indowe bísha! ashmaniye balor shin shuweraniyere b́ oorink'e k'anefe!» ");
INSERT INTO bwo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bo móóke bo befere Iyesus misho k'aawdek't b́ deeri, tiitsdek'tnwere b́ danifwotssh «Nahere, han t meetsoniye» et boosh b́ ími. ");
INSERT INTO bwo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Úshi wanc'ono k'a'ú dek't Ik'o údt boosh b́ ími, jamwotsu úshets waanc'otse bo úshi. ");
INSERT INTO bwo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Hank'owere boosh bíeti, «Han aywotssh kuud'it handron taareyosh wotitwo t s'atsoniye. ");
INSERT INTO bwo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Arikoniye itsh ti'etirii, Ik'i mengitotse k'osh aron aani handr weyinyo túshfetso weyiniyi shuwatse fis'etsan aani úyatse.» ");
INSERT INTO bwo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Maniyere il Ik'i duubo duubt Debrezeyt guro maants bo keshi. ");
INSERT INTO bwo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iyesus b́ danifwotssh hank'owa bí et « ‹Jinirwono jod'de úd'itwe, mererwotswere bad'itúúne,› et guut'etsotse it únetswor taash bín danatsone etetute, tiyatsnowere shuuts aanitute, taan k'ayr wos'etute, ");
INSERT INTO bwo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ernmó k'irotse t twiyakon Gelil maants shino beshar ametuwe.» ");
INSERT INTO bwo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Manoor P'et'ros «K'oshwots bo jamets neen bohaliyalor, taa b́jamon neen haaleratse!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Iyesuswere «Ariko neesh etirwe, hambets t'úwaanitse baako gitoto b́k'adfetsere shino nee keezoto tjangosh, jamere taa bíndanatse etetune,» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","P'et'rosmó «K'ir b́wotiyal dab́ neentoni tk'iriti bako jamon neen danatse eraatse!» et kup'i dek't b́ keewi. B́ danif k'oshwotsu mank'o bo etfera botesh. ");
INSERT INTO bwo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Maniyere hakon Getesemaneyi eteets beyokok boami, Iyesus b́ danifwotssh, «Taa ekewoke Ik'o tk'onfere it hanok betere,» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","B́ shutsats P'et'rosna, Yak'obnat Yohansno dek't bí ami, manokno ayidek't shiyanefetst kic'o dek'b́tuwi. ");
INSERT INTO bwo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Hank'owo boosh bí eti, «T kashu k'írosh bborfetso shiyanwtsere, hanoke be teere, err kup'arr korere.» ");
INSERT INTO bwo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Boyere muk'i okaan wokdek't k'azbiami, datsats b́baron gup'gup'dek't faleetk b́wotiyal sa'at man b́beshitwok'o Ik'o b́ k'oni. ");
INSERT INTO bwo_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Hank'o bí eti, «Nihono, keew jamo neesh falefe, gond bek' úshi wanc'ani tiatse wokiwe, ernmó nee n shuntsok'owa bako taa t shuntsok'o wotk'aye.» ");
INSERT INTO bwo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","B́ danif keezwotsok aanat b́waatsok'on, k'eewwtsat bobefere b́ daatsi, mansh P'et'rossh «Simo'ono, k'eeniya nwtsi? Dab ik sa'atune beyo nmaawi?» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","«Fadeyi kic'ots it kindrawok'owe kup'ar Ik'o k'onwere, Shayironiye k'anke, meetsonmó maawke,» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Aaninu amt, enéé bí ettsmank'o et aani Ik'o b́ k'oni. ");
INSERT INTO bwo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ando aanat b́ woor, bo aawotse tokro mangt b́ teshtsosh tokrat bobefere, b́ daatsi, bísh bokeewirwono danatsno bo tesh. ");
INSERT INTO bwo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Keezlo aanat bomaand waat hank'o boosh bí eti, «Andoor it k'eetsok'oonya it fa'oni? Andoor kashdek'oke it fa'o? Ando bodre! sa'ato bodwtsree! hambe! Ash Na'o morretswots kishats beshide'er imetwe. ");
INSERT INTO bwo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Eshe tuuwere! amone! taan beshide imetwo hamb t'inre!» ");
INSERT INTO bwo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Manóór Iyesus man b́keewfere tatsegitwotsitsi iko wottso Yhud waa b́keshi, bíntonu gumbonat shiki goradon detsdek'ts ash aywots fa'ano bo tesh, boowere kahni naashwotsitse, Muse nemo danifwotsitse, eenashwotsokno woshekno bo teshi. ");
INSERT INTO bwo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Bín beshi de'er imetwo Yihud, «It it detsetiye taa jamó aatr t joobitwoniye, bíne t'iwintsde deshde ameree,» et boosh milikito ímtni b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yihud manoor wáát Iyesusok t'índek't «Danifono!» et bín b́ joobi. ");
INSERT INTO bwo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Maniyere il ash ashuwots Iyesusi detsbodek'i. ");
INSERT INTO bwo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Manoke ned'irwotsitse Iyesus shuuts sha'efwotsitse iko b́ shiki gorado kishdek't kahnyi naasho guutso waazo k'ut'b́k'ri. ");
INSERT INTO bwo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iyesus hank'owa boosh bí et, «Shiki goradonat gumbon dek'at it wáá taan wonbadewok'o detsoshe? ");
INSERT INTO bwo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Aaw aawon Ik'i mootse itn danifetsat itnton tbewor taan deshatste b́ teshi, ernmó han b́wotiye S'ayin mas'afwotsitsi keewetso b́s'eenetwok'owe.» ");
INSERT INTO bwo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","B́danifwots bojamets bín k'azt bowos'i. ");
INSERT INTO bwo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ket'i mitoon wozets nat'al mec'r tahtso jawets na'a iko s'uz Iyesus shuutso shoydek't amiruwe b́tesh, ashuwots bín dets bodek'or ");
INSERT INTO bwo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","B́nat'alu juuk'rat araatson wos'fere k'az bíami. ");
INSERT INTO bwo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Iyesusmó kahni naasho gal dekt boami, manoke kahni naashwots, eenashwotsnat Muse Nemo danif jamwots kakwe bowtsi. ");
INSERT INTO bwo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","P'et'roswere kahnyi naasho mook b́ bodfetso wokdek't Iyesus shuutso bí amfera b́teshi. Manoknowere guuts guutswotsnton bedek't tawo b́ kashfere b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kahniwots naash naashwotsna, moosh moshyf jamwots, Iyesusi úd'iyosh gaw wotitwo bogefere botesh, ernmó daatsratsno. ");
INSERT INTO bwo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Aaywotsu kooton bíats gawerno, b́woteferor bo gawor bo keewo ik woteraniyere b́ oori. ");
INSERT INTO bwo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ik ikwots tuut hank'o et kooto bí ats bogawi, ");
INSERT INTO bwo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Taa ash kishon ageets Ik'i maa han gaahde keez aawotse k'osho ash kishon finerawo agetwe ett b́keewfre shishrone.» ");
INSERT INTO bwo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Manbwotiyalor bo gawts gawo ik woteratse. ");
INSERT INTO bwo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kahni naashonúwre bo taalotse need'dek't, «Eegor aaniyalkneneya? Ashaanots ni'ats bo t'intsiru s'aamiyo eebi b́ naaroni?» ett Iyesusi bí aati. ");
INSERT INTO bwo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Iyesusmó s'k eta bí eti bako eegor aaniratse. Kahni naashmanwere «Deerets Ik'o Na'o Krstos neeneya?» ett aani bí aati. ");
INSERT INTO bwo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iyesuswere «Ee, taane, ash Na'o Ik'o k'ani aaro maantse b́befere bek'etute! ando aani daaratse daawnon aanar b́woor bek'etute» ");
INSERT INTO bwo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kahni naashonwere nibk'unon b́ taho gaat't «K'osh gawo eegoshe b́geyiti? ");
INSERT INTO bwo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Hambe! Ik'o b́c'ashirwok'onoor shishrte, eshe eege itsh bíari?» bí eti. Jametswots ik wotdek't «K'iro bísh wotitwe!» et bí ats boangshi. ");
INSERT INTO bwo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ik ikwotswere bo s'udo bí ats s'udo dek't bo tuwi, bí aawono shemoon p'uuridek't «Nee nebiyi nwotiyal aab neen kon b́ jot'tsok'ó dane!» etfetst kishi t'umon bo jot'fere botesh. K'oshwotswere jabefere dek't bo ami. ");
INSERT INTO bwo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","P'et'ros kahni naasho mooniye dashe b́ kas'otse b́befere kahniwotsitsi k'aabo gon iku waa b́ keshi, ");
INSERT INTO bwo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Bi P'et'ros tawo b́kashefere bek'aat t'iwintsdek' s'iilat «Neewor Nazrettso Iyesusntonye n teshi,» bísh bi et. ");
INSERT INTO bwo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Bímo «Taa danatse, eebi ni'eetirwoni,» ett bíhaali. Manówere et fengesho maants b́ keshtsok'on baako b́ k'adi. ");
INSERT INTO bwo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Gonunwere P'et'rosi bek'aat manoke ned'irwotssh «Hanwor bo jirotsitske!» etaat aani keewo dek' btwi, ");
INSERT INTO bwo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Bímó aani jamere taa bín danatse bí eti. Muk'i boteshiyakon manoke need'iru ashuwots P'et'rossh «Gelil dats ash n wottsok'o n noon keew keewo kitsirwe, manshe arikon neehe bo jirwotsits neene» bo et. ");
INSERT INTO bwo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Bímó «It etiru ash han taa danatse!» etfetst taart bí atso b́c'ashi. ");
INSERT INTO bwo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Manoor baako gitlo b́ k'adi, P'et'roswere «Baako gitoto b́k'adfetsere, keezoto taan jamere bín danatse etetune,» et Iyesus b́ keewtso keewo bísh gawe b́wtsere ay dek't bí'eepi. ");
INSERT INTO bwo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Guur dats b́gatstson kahni naashwots, eenashwotsnton, Muse nemo danifwotsnton, moosh mooshif jametswotsnton boshiyeyi, maniyere il Iyesusi típdek' amt P'ílat'ossh beshi dek't ím bok'ri. ");
INSERT INTO bwo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","P'ilat'os «Ayhudiy nugúso neeneya?» ett bíaati. Iyesuswere «Nee niettsok'oyiye,» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kahni naashwotsmó Iyesusi ay dek'tni bo s'aamifere bo tesh. ");
INSERT INTO bwo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Mansh P'ilat'os «S'iile! ambts keewon neen bos'aamirwok'ona! b́jamon eegor ni'aanitwo deshatsiya?» ett aani bíaati. ");
INSERT INTO bwo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","P'ilat'os bí'adfetsosh andoor Iyesus egoŕ aaniratse. ");
INSERT INTO bwo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","P'ilat'os worwot worwoton Ayhudi fazigi woroti baalyots ashuwots boosh b́bitsetwok'o bo'aatts tipitsi ash iko boosh biitsfe b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Manóór mengstats tuut datso s'eezits, asho úd't tipi moots kindtswots fa'ano botesh, manotsitsno iko Berbani eteef ashoni b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ash ashuwotswere P'ilat'os maants t'int bodantsok'on boosh b́k'alish bín bok'oni. ");
INSERT INTO bwo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bíwere «Ayhudí nugúso biishde itsh tfaksho geefteya?» ett boon bí'aati. ");
INSERT INTO bwo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Han bí'etirwere kahni naashwots Iyesusi beshidek't boímir okooron b́ wottsok'o b́dantsotsna b́tesh. ");
INSERT INTO bwo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kahni naashwots, «B́ shegro Berban noosh biitsewa,» err P'ilat'osi bok'onitwok'o ashuwotsi tuuz bok'ri. ");
INSERT INTO bwo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","P'ilat'oswere, «Béré, ayhudi nugúsa it etirwan aak'o k'aluta?» ett ashuwotsi aani bí aati. ");
INSERT INTO bwo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bowere «Bín jiire!» etfetst aani bokuhi. ");
INSERT INTO bwo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","P'ilat'oswere «Eegishe? Eege bí aawashits keewoní?» bí eti. Bowere «Bín jiire!» etfetst aydek't bo kuhi. ");
INSERT INTO bwo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","P'ilat'os ashuwotsi gene'ushosha ett Berbani bitsdek't boosh faksh b́k'ri, Iyesusnmó jot't b́jiitetwok'ó beshidek't imb́kri. ");
INSERT INTO bwo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kes' kes'irwots Iyesusi datsu keewirwo múúlok dek't bo ami, oorts kes' kes'iru jamwotsno bo s'eegi, ");
INSERT INTO bwo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tah birono bísh takbok'ri, angitso k'odetso wozdek't b́ tookats gúp'sh bok'ri, ");
INSERT INTO bwo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","«Ayhudi nugúsono aage! Jeeno neesh wotowe!» etfetst bíats kashfetst jamo bín bo'aatfere botesh. ");
INSERT INTO bwo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Guumbono b́ tookats bo togfere botesh, s'údono bíats s'udfetst tirgic'o bíats kashfetst tuk'maldek't b́ gubrats bo sagadfere botesh. ");
INSERT INTO bwo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bí'ats bokashihakon tah bíro kishbazt, b́took taho takbok'ri, jitosho bín dekt boami. ");
INSERT INTO bwo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Amoke bobefere K'eren dats ash wotts Iskndriyosnat Rufosn nih Sm'on gat'ariyon waat kitots b́ kindfere daats bodek'i, Iyesus mask'aliyo angnon b́kuritwok'o bowoshi. ");
INSERT INTO bwo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Maniyerehakon Iyesusi b́bitso took k'ola eteets beewoko Golgotók dek't boami. ");
INSERT INTO bwo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Manokno kerbewonton eeketso weyini biro b́ úshetwok'o boimi, eree bímó úyatse. ");
INSERT INTO bwo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Maniyere hakon jitbok'ri, b́tahwotsnó kon aawi b́dek'etwok'o it'o shap't kaybodek'i. ");
INSERT INTO bwo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Iyesusi bo jitor datso guur keez sa'ata b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","B́ t'afiyo kiitsoshowere «Ayhudi nugúsa» ett guut'etso guut'k'reyi. ");
INSERT INTO bwo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Gond finets gitetswotsi dek' waat Iyesusnton iko k'ano maants ikono b́giromaants jit bok'ri. ");
INSERT INTO bwo_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mank'onowere «Gond fintswotsnton b́ taaweyi,» ett keewetso b́ s'eenetwok'wa. ");
INSERT INTO bwo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","B́ganoke beshefetst teshts ashuwotsi gac'on botoko shek'efetst hank'o ett bín boc'ashfere botesh, «Indowe neená! nee Ik'i moo gaahr keez aawotse aak'ritwono! ");
INSERT INTO bwo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Aab́ and jitatse ood'ŕ ntooko kashiwe!» ");
INSERT INTO bwo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mank'oon kahni naashwotsnat Muse nemo danifwotsn bo atsatsewo hank'o ett bíats trgc'o bokaashi. «K'oshwotsi kashire, b́tokonmóó kashiyo falratse! ");
INSERT INTO bwo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Bí Krstosi Israe'el Nugusoni wotiyal bére aab and jitatse ood'e, noowere be'er bín amanone!» Mank'o bínton jitetswots wonbedewotswere bín boc'ashfere botesh. ");
INSERT INTO bwo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Aaw shrt sa'aton tuut jed'i sa'ato b́borfetso dats jamatse t'alwo wotb́wtsí. ");
INSERT INTO bwo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jed'i sa'at b́wottsok'on Iyesus «Elohe, elohe, lama sebek'tani,» ett k'áári eenon b́ kuhi. Mank'o etonwere «T Ik'ono, t Ik'ono! eegishe taan k'aznk'ri?» eta. ");
INSERT INTO bwo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Manoke need'at teshts ashuwotsitse ik ikwots b́ kuho shisht «Hambe! Eliyasiye b́ s'eegiri,» bo eti. ");
INSERT INTO bwo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Boyitsi iko wos't weyni biri shasho s'olok'o s'aamo spoonjiwots gupdek't s'entsb́k'ri, b́ úshetwok'owere gumbats ged dek't Iyesussh imt «Aab Eliyas wáár bín oorshitewe woto s'iilone!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Maniyehakon Iyesus k'áári eenon b́kuuhi, b́ kashunwe bí aatsotse k'az bkeshi. ");
INSERT INTO bwo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ik' mootsi magarajiyo dambe dek't dash b́borfetsó gaad'at́ gitok kayb́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","B́maask'aly shinatse eed' dek't́ teshts bali naasho Iyesus kasho bíatsotse aawk'on b́ keshtsok'o t'iwints dek' b́ bek'tsok'on, «Ash han arikon Ik'o naayiye bíteshi» bí eti. ");
INSERT INTO bwo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wokoon wotdek't s'iliru mááts ik ikwotswere manoke fa'ano botesh. Boyitsnó Megdel datstsu Mariyamu, muk'efo Yak'obnat Yosa ind Maryamu, Selomewwere fa'ano botesh. ");
INSERT INTO bwo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Bowere Iyesus Galiln b́ teshor, b́ shuutso sha'aŕ bísha bo finefo. Mank'owere Iyesusok Iyerusalem maantse waats aywots fa'ano botesh. ");
INSERT INTO bwo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Datso ilat b́teshtsotse sanbati kindi aawonat k'andek'i aawonowere b́ woti. ");
INSERT INTO bwo_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Manoró Ayhudi moosh moshifwotsitse iko teshtso Yosefi eteefo, mangiyets Armatiyas asho b́ weyi. Bíwere Ik'imengsto kotirw asha b́tesh. Bíwere b́sharawo P'ilat'os shinats t'int Iyesus duuno bísh b́ ímish b́ k'oni. ");
INSERT INTO bwo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","P'ilat'oswere «Aak'oneya hank'o káári b́k'iri» ett bí adi. Bali abaatse naashonó s'eegit́ «Arikon b́ k'iriyako ja'ará?» ett bíaati. ");
INSERT INTO bwo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Iyesus k'iro bali abaatse naasho atse b́ shishihakon duuno b́ dek'etwok'o Yosefsh bí eeki. ");
INSERT INTO bwo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yosef duuni shemo keewdek't mask'aliyatse Iyesus duuno orshdek't k'od b́k'ri, s'alatse k'ewdek't k'aniyets doowots duk b́k'ri. Shúts eeno kukulshdek' doowo ipbok'ri. ");
INSERT INTO bwo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Megdelawi eteetsu Mariyamnat Yosá ind Mariyamń Iyesusi eewk duketsok'o bos'iilfera botesh. ");
INSERT INTO bwo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sanbati aawo b́beshi hakon Megdelawi kititstsu Mariyam, Yak'ob ind Mariyamnat Selomen wotat́, Iyesus duunats fuutosh shitúwo keew bo dek'i. ");
INSERT INTO bwo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ik gawyotsi shints aaw wotts sanbat eenots guur t'úwon, aawu keshfere bwoor, doowo maants bo ami. ");
INSERT INTO bwo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bo «Shútso doowi nonatse konek'uwa noosh kukulshiti?» etfetst keewefere bo amir. ");
INSERT INTO bwo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Manowere bo etir doowo bín ipets shútso ayidek't een b́ teshtsosha, kááwdek't bo s'iilnmó shútso ik maants kukulwtsat́ b́befere bo bek'i. ");
INSERT INTO bwo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Doowotso bo kindor shemi nas' tahirwo jawetso k'anomaantse b́ befere bobek'tsotse tek'bowtsi. ");
INSERT INTO bwo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Bímó boosh hank'owa bí et «Tek'k'ayere! it it geyirwo jitt teshetso Nazrettso Iyesusi b́ wottsok'o danfee, bí k'az tuure, hanoke aaliye, b́duukeyokonúwere hambe s'iilere. ");
INSERT INTO bwo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Andoor ameree, b́ danifwotsnat P'et'rosnsh, ‹Haniyere shin Iyesus itsh b́ keewutsok'on bí Gelil maants itiyre shinar ametuwe, manokno bín bek'etute,› err boosh keewwere.» ");
INSERT INTO bwo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Máátswotswere shatoon k'ewefetst doowi ganoke kesht k'azbo'ami, ayidek't́ shatt boteshtsotse ik keewo konshor keewratsnó.  ");
INSERT INTO bwo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ik gawiyotse shints aawots Sanbata gudots Iyesus guuron k'irotse b́ tuwi hakon, shin shino shawat fo'erawo biyatse b́kishtsu Megdela eteef kititstsu Mariyamsh b́be'eyi. ");
INSERT INTO bwo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Biwere amaat, shiyanon eepoke fa'ua b́shuuts sha'efwotssh keew bk'ri. ");
INSERT INTO bwo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Biwere «Iyesus k'irotse tuut, kashon fa'ee, taawor ti ááwon bek're,» etaat boosh b keewi, ernmó boowor bin amaneratsno. ");
INSERT INTO bwo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Maniyere hakon gat'ariyomants amfetst teshts b́ danif gitwotssh Iyesus k'osh aron b́ be'e. ");
INSERT INTO bwo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bowere aanat b́danif oortswotssh keewbokri, ernmó manotsnor amaneratsno. ");
INSERT INTO bwo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Maniyere hakon tatse ikwots mishimarats t'int́ bomaafere Iyesus bo ats be'eeb́wtsi, «Iyesus k'irotse tuut kashon fa'ee no ááwono bek'rone,» ett boosh keewtswotsi aman bo k'aztsona et bo nib kup'osh boon b́k'efi. ");
INSERT INTO bwo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Hank'owa boosh bíet, «Dats jik' jamats ameree, ash jamoosho doo shishiyo daniwere. ");
INSERT INTO bwo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Amantsonat guupetson kashitwe, amanerawonmó bí ats angshetwe. ");
INSERT INTO bwo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Taan amanitu jamwots adits keewanotsi finituno, t shúútson fo'erawo kishituuno, handr noon keew keewonowere keewituuno, ");
INSERT INTO bwo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Dawunzwotsi bodetsalo, wee úd'it merziyo dab́ bo úshal eegor boon k'alratse, bo kishono shodtswotsats bo gedor shodtswotś kashitune.» ");
INSERT INTO bwo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Doonzo Iyesus jaman boosh b́keewiyhakon daromaand k'az bíami. Ik'o k'ani aaromants be b́wtsi. ");
INSERT INTO bwo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","B́ danifwotswere dats jamatse sha'at́ bo daniyi, doonzonúwere bonton b́ finefoni. Adits finono bo k'alitwok'o alo boosh ímt bo daniyru man ar b́wottsok'o b́ kup'shfoni.");
INSERT INTO bwo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Shiimets Tewofloso! No dagotse k'aleets keewwotsi kishde'er kitsit tarikiyo haniye shin aywots guut'rnee. ");
INSERT INTO bwo_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Wosh han noosh beshitswots shin shinon teshts ááwon bek'tswotsnat b́ aap'tso nab́t teshtswotsiye. ");
INSERT INTO bwo_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mank'owere taa shin shino tuzat jam keewo t'iwintsdek'at t s'iliyakoń b́ tarikiyo matsdek'at neesh t guut'etwok'o sheeng wotat taash b́ daatseyi. ");
INSERT INTO bwo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Han tk'alwere ndants dano ar b́woto sheegshde dań ndek'isha etaatniye. ");
INSERT INTO bwo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herods Yihud datsatse nugús wotat b́teshor, Aabiya kahni fini kayotse fin finirwotsitse Zekariyasi eteetso kahniya b́ tesh. Bíwere Aron naaratse shuwetsu Eelsabti eteets máátsu detsfe b́tesh. ");
INSERT INTO bwo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Gitwotswere Ik'o shinatse kááwwotsi bo teshi, Doonzo alonat teron iko bo shapirawona Ik'i shinatse sheeng beya bobefoni bo teshi. ");
INSERT INTO bwo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elsabet' mahan b teshtsotse na'o deshatsno botesh, ando gitwotsu ay dek't gaawerwtskno bo tesh. ");
INSERT INTO bwo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Manoor Zekariyas kahniwots jirwotsitse Ik'i mootse finosh b́ fini aawa b́tesh, mansha bí Ik'i shinatse b́ kahni fino b́finefera b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kahaniyots yoots bo k'alfok'ooń doonzo Ik' moots kindt it'ano s'uwiwosh bíats it'o keshb́wutsi. ");
INSERT INTO bwo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ik' mootsnowere it'ano s'uwiyewor, ash jamo úratse ned'de'rni Ik'o bok'onfo. ");
INSERT INTO bwo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Doonzo melakiyo it'an s'uwiyeyiru t'arap'ezoke k'aniweeron ned'irwo Zekariyas ats be'eeb́wtsi. ");
INSERT INTO bwo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zekariyas Ik'i melakiman b́bek'or tek'at shatb́wts. ");
INSERT INTO bwo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ernmó melakiyo bísh hank'owa bíet: «Zekariyaso! shatk'aye! Ik'o n k'ontso shishre, n máátsu Elsabet' nungush na'o neesh shuwitwaniye, b́ shútsono Yohansi err s'egetune. ");
INSERT INTO bwo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","B́ shuwewono geneúwi eeno neesh wotituwe, aywotsu b́ shuwewon mank'o genee'úwitunee. ");
INSERT INTO bwo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Bí doonzo shinatse een wotitwe, weyiniwon dutsets bironat k'osh mashit úsho úyatse, indu maac'otse b́befere S'ayn shayiron s'eenk wotitwe. ");
INSERT INTO bwo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Bí Isra'el ashotse aywotsi bo Doonz Izar Izewer maants aniyituwe, ");
INSERT INTO bwo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ari nebiyo Eliyas kok'o S'ayn shayironat angon wotaŕ nihwots nibo nana'o maants, aleraw ashuwots nibono kaawwots dan telofo maants aanitwe, ashaashwotsnowere doonzosh k'anbodek'etwok'o woshitwe.» ");
INSERT INTO bwo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ernmó Zekariyas melakiwosh «Keewan arik b́ woto eegneya t daneti? Taawere gaawerwtserere, tmáátsunwere gawerwtserane» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Melakiyonwe hank'o ett bísh bí aani, «Taa Ik'o shinatse ned'efo Gebreel taane, doo shishiyan neesh tkeewitwok'o Ik'oke wosheyat waare. ");
INSERT INTO bwo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Neemó bí aawo b́bodor wotitwo t keewts keewo amaneratsne, mansh neesh t keewts keew jaman wotar b́ s'eenfetso gidik' wotar s'k err nbeetesheti, noon keewono falatsne.» ");
INSERT INTO bwo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Manoor ash ashuwots Zekariysi bokotfera botesh, Ik'i mootse b́ ja'atsosh bo adi. ");
INSERT INTO bwo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zekariyas Ik' mootse b́ keshor ash ashuwotsnton keeweyo falratse b́ tesh, mansh bo Ik' mootse bek'o b́bek'tsok'oo danbok'ri, bí b́ kishon kitsfetstni boosh b́ daniyiri bako noon keewo falratse b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","B́fiino b́ s'uwi hakon Zekariyas b́ moo maants k'az bíami. ");
INSERT INTO bwo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Muk'i b́teshihakon b́ máátsu Elsabet na'o maac'bwtsi, úts shashosh b moots ááshutsatni b tesh, hank'owo bi et, ");
INSERT INTO bwo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Doonzo keewi sheenghan taash k'alre, ashuwots dagotse t gac'ewo tiatse k'aaú dek't juu k'rere.» ");
INSERT INTO bwo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elsabet bmac'ts shirtl shashon melakiyo Gebr'el Gelil datsatse fa'ú Naazreti eteef kituts Ik'oke b́ wosheyi. ");
INSERT INTO bwo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","B́ woshewwere Dawit naar wottso Yosefi eteef ashosh wid'ets baarna'a s'eenúka b́ tesh, b shútsonwere Mariyami b tesh. ");
INSERT INTO bwo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Melakiyonwere b maants waat, «Nee Ik'i s'aaton s'eentsune, jeeno neesh wotowe! doonzo neentoniye, Nee máátswotsitse derek neene» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Biwere melakiyo keew keewatse tuutson aydek'at tek'at, «Jam aatan awuk'o jam aate k'una?» etaat asaabbdek'i. ");
INSERT INTO bwo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Melakiyonwere hank'o bish bíet, «Mariyame! Ik'i shinatse n baatsirwotse shatk'aye, ");
INSERT INTO bwo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Eshe! Na'o mac'ituune, nungush na'ono shuwiytuune, b́ shútsono Iyesusi etetune. ");
INSERT INTO bwo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Bí were een wotitwe, jamoniyere damb bogo Ik'o naayiye eteetwe, doonzo Ik'o b́ nih Dawit naashi jooro imetuwe. ");
INSERT INTO bwo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Isra'el ashaatsnowere dúre dúrosh naashitwe, b́ naashonwere s'uwo deshatse.» ");
INSERT INTO bwo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariyam melakiyosh «Taaho baarna'a s'eenu taanere, bere, hank'ó keewan aak'oneya woto b́faliti?» bi eti. ");
INSERT INTO bwo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Melakiyonúwere hank'o ett bíaany, «S'ayin shayiro ni ats weetuwe, jamoniyere damb bogts Ik'o angonwere neen gúúpetuwe, mansh niyatse shuwet na'o S'ayno wotitwe, Ik'o naayiye eteetwe. ");
INSERT INTO bwo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Njaguu Elsabet dab mahani eteere beyat ja'at and b gaweriyakon nungush na'o maac' dek'raniye, b maac'ihakon and shirtl shasho bodrane. ");
INSERT INTO bwo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ik'osh maawet keewo aaliye.» ");
INSERT INTO bwo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maniyakon Mariyam, «Hamb! Taa doonzo gonú taane, taash niettsok'o wotowe» bieti. Manoor melakiyo biyoke k'az bí ami. ");
INSERT INTO bwo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Manoor Mariyam gur báár datso Yihud datsomantse fa'a kitu maants kááron tuwat bi ami. ");
INSERT INTO bwo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zekariyas mootso kindat Elsabetsh jamo b imi. ");
INSERT INTO bwo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elsabet Mariyam bin jamo bi aator b k'aaro bshishtsok'oon b maac'itsi na'o t'oolo gedb́k'ri. Elsabetwere S'ayn shayiron s'eengutsat ");
INSERT INTO bwo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","B k'aaro eensh dek'at hank'o bi et, «Nee máátswotsitse derek neene, niyatse shuweetwonwe deereke. ");
INSERT INTO bwo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Tdoonz ind taan s'iilo b waan taash aak'o mangi eene, ");
INSERT INTO bwo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","N jamo t shishtsok'on manoor t maac'otse fa'a na'o gene'on t'oolere. ");
INSERT INTO bwo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Doonzoke bish keewets aap'o b́s'eenetwotse nee amantsu aak'o deerek neene!» ");
INSERT INTO bwo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariyam hank'owa bi et «T kashu t doonzi úditwanee, ");
INSERT INTO bwo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","T shayiru t doonzn ti aton geneeúitwane, ");
INSERT INTO bwo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ik'o taan ashitsi ashe dash gonú b́ s'iiltsotse, Hambetse okoon shuwets jamo deretsuniye etetúne taasha, ");
INSERT INTO bwo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ik' kup'o een een keewwotsi taash k'alre. B́ shútsonwere S'ayine. ");
INSERT INTO bwo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ik'o bín shatirwotssh, Bo Na'i na'osh b́ mhretiyo woshitwe. ");
INSERT INTO bwo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","B́ kup' aaron bí ango kitsre, Bog noona ett it'irwotsnowere bo tewnonton boon bad'ik'reree. ");
INSERT INTO bwo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","K'eeziru een eenwotsno bo naashi jooratse oorshre, ernmó bo tooko dashan detsiru ashuwotsi mangon dambaan tizree. ");
INSERT INTO bwo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","K'ak'tswotsno sheeng keewon worire, Galetswotsnmó kishi baashon damik'rere. ");
INSERT INTO bwo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Abrahamnat b́ naarwotssh dúre dúrosh b́ kitsts mheretiyonowere gawdek't, B́ guutso Isra'eli tep'ree. Manowere b́k'al shin no nihotssh b́ jangits keewo s'eentsoshe.» ");
INSERT INTO bwo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariyamwere Elsabetnton keez shashosh b́teshiyhakon b galomaants aanat k'azbiami. ");
INSERT INTO bwo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elsabet b shuwi aawo b́bore nungush na'o shuubk'ri. ");
INSERT INTO bwo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","B giyuwotsnat b jag jamwotswere doonzo bish mhetiyo b́ woshtso shisht binton bo geneúwi. ");
INSERT INTO bwo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Na'o b́ shuwetsi shmtl aawon, bín gof damiyewor b giyuwotsnat b jagwotsn kakweyat bo weyi, b́ nih shútson Zekariyasi err s'egetwok'o geyatni botesh, ");
INSERT INTO bwo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Indunmó «Mank'o woteratse, b́ shútso Yohansiye» bi eti. ");
INSERT INTO bwo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bowere bish «N jagotse shútsann s'eegetso konwor aalneya?» bo eti. ");
INSERT INTO bwo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Maniye okoon nihosh, «N naayi koni err s'egetwok'owe ngeyi?» ett kolon bo aati. ");
INSERT INTO bwo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zekariyasu bín guut'etuwo bísh bo imetuwok'o aatdek't «B́shutsoniye Yohansiye» ett b́ guut'i, jametswotsu keewmaanatse tuutson bo adi. ");
INSERT INTO bwo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Manoor Zekariyas albero bishwtsat bí eree noonkeewo b́fali, Ik'o údo dek'b́tuwi. ");
INSERT INTO bwo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Manatse tuutson bogiyi jametswots shatoon tek'bowtsi, keewman gúrmanatsi Yhud dats jamwotsatse shiyeb́wtsi. ");
INSERT INTO bwo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Keewhan shishits jamwots, «Na'i marmat'an eeg wotishek'uwa?» ett bo atsatseyo bo aatefere botesh. Han b́wotiye Ik' kisho arikon bínton wotat bín b́tep'tsoshe. ");
INSERT INTO bwo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Na'i marmat'o nih Zekariyas S'ayin shayiron s'eenwtsat hank'o ett bek'on b́keewi, ");
INSERT INTO bwo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Bí ashuwotsi mheretiyon waa b́s'iltsonat b́ kashitsotse, Isra'elko Izar Izewer, doonzosh údo wotowe! ");
INSERT INTO bwo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","B́guutso Dawit naarotse kaashiyts kup'o noosh tuuzre, ");
INSERT INTO bwo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yoots shin dúrtson tuuzt b́ teshts S'ayin nebiyiwots noonon b́keewtsok'on, ");
INSERT INTO bwo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","B́ kashiwonwere no balangarwotsnat noon shit'iru jamwots kishotsene, ");
INSERT INTO bwo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Han b́ k'alwere nonihotssh mhretiyo b́ woshtsok'o B́keewts S'ayn taaro s'eentsosh gawdek'tniyee. ");
INSERT INTO bwo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Taaranowere, taaron b́ ím nonih Abramsha b́teshi. ");
INSERT INTO bwo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","B́ jangitsonwere no t'alatwots kishotse nas'o keer, Shatalon bísh no finishe, ");
INSERT INTO bwo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Mank'o beyi dúr jamon Ik'ishinatse S'ayinonat kááwon beyo nofalitwok'owe. ");
INSERT INTO bwo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Aaninu nee na'i marmat'ono, jamoniyere danb eents Ik'ko bek'etsoniye neene eteetwe. B́werindo k'aniyosh doonzoshinats beshar ametunee ");
INSERT INTO bwo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Doononwere bo morrosh boosh oorowe err Kashosh wotit dano boosh imetwe. ");
INSERT INTO bwo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Noko Izar Izewer maac' k'ewtsonat maac' nefon b́wottsotse bín kashet shááno danmbane noosh b́ shanetwok'o woshitwe. ");
INSERT INTO bwo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Manwere t'aluwonat k'iri c'ishotse fa'a jamwotssh shaanitwe, No shaaw shaawonowere jeeni weromants jishitwe.» ");
INSERT INTO bwo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Na'onu eenb́wtsi, shayironowere kup'b́wutsi, Isra'el ash jamosh b́ be'efetsosh worwotse b́beeyi. ");
INSERT INTO bwo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Man dúr Rom dats jami shirotse keeweyat beyiru ash jamwots bo taawetwok'o Rom nugúso Awugst'os bí azazi. ");
INSERT INTO bwo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Shints ash taawman taawewor Soriyi dats keewirwo K'ereniwosi b́tesh. ");
INSERT INTO bwo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mansh asho ik ikon b́shútso guut'eyish b́ shuwets dats datsomand bo amfera boteshi. ");
INSERT INTO bwo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosefwere b́ shuwewon Dawit naar b́teshtsotse Gelil datsatse fa'a Nazret kitutse tuut Yihud datsatse fa'a Dawit kitu Betelihem maants bíami, ");
INSERT INTO bwo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Guut'ewosh bíamu mac'at teshtsu b́wid'tsu Mariyamntona b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Betelihem kitutse bobefere Mariyam shuwi aawo bodb́wtsi. ");
INSERT INTO bwo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Manoknowere b k'aab́ na'o shuuk'rat bín eret tahon kaapbk'ri, ibi k'eefoke k'ewoko daatso bok'aztsotse minz kas'otse minzwots eeg eeg bomaf marats k'eez b́k'ri. ");
INSERT INTO bwo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Manoknowere, t'ú gizi s'een kotfetst sisatse k'eyiru giz jinfwots fa'ano bo tesh. ");
INSERT INTO bwo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mann, doonzo melakiyo boats be'eb́wtsi, Doonzo mangi shááno bogúúratse c'eesh b́k'ri, boowere ayidek'at shatbowtsi, ");
INSERT INTO bwo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Melakiwonmó hank'owa boosh bíet «Shat k'ayere! ash jamosh geneúi een wotitwo keewi sheengo itsh dek'at waare, ");
INSERT INTO bwo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hamb! Hambetse Dawit kituts kashitso itsh shuwere, bíwere doonzo Krestosiye. ");
INSERT INTO bwo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Haniye itsh milikit wotitwe, bín na'a erii tahotse kaapk'rets na'o gizwots kas'otse gizo eeg eeg maaf maratse b́ k'eefere daatsitute.» ");
INSERT INTO bwo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Dingaton darotsi melaki ayuwots, melkimanton ikwotat be'e bowutsi, Ik'ono údfetst́, ");
INSERT INTO bwo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Darotse Ik'osh mango wotowe! Datsno Ik'o b́shunts ash jamwotssh jeeno wotowe!» bo etfera botesh. ");
INSERT INTO bwo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Melakiyo boatse k'aleyat daromaants k'az bokeshiyakon giz jinirwots bo atsatseyo «Beré Betelihem maants amone, and wottsonat Ik'o noosh bek'sht b́kitsts keewo s'iilone» bo et. ");
INSERT INTO bwo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kááron amt Marymnat Yosefn daats bodek'i, na'i marmat'onwere gizi kas'otse gizwots bítse eeg eeg maaf maratse b́ k'eefere bobek'i. ");
INSERT INTO bwo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Na'i marmat'onowere bobek'iyakon b́ jango Ik'i melakiyo boosh b́ keewtso keewo dek botuwi. ");
INSERT INTO bwo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Keewman shishits jamwots giz jinfwots boosh bokeewts keewatse tuutson bo adi. ");
INSERT INTO bwo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maryammó, keew jaman b nibots detsdek'atni b asaabefo btesh. ");
INSERT INTO bwo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Giz jinirumanotsu, jam keewo melakiyo boosh b́ ettsok'o wotat bí eree bobek'tsonat boshishtsosh, Ik'o mangifetst bín údfetst, bo beyok k'az bo aani. ");
INSERT INTO bwo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Shimt aawo b́beshihakon na'o gof damiyoke, b́ shúútso «Iyesusi» ett s'egee. Hanwere b́ maac'eeftse shino melakiyo b́kishts shútsoni b́tesh. ");
INSERT INTO bwo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nemok'on, s'ayintsi teri aawo bodb́wts, mann Maryamnat Yosefn na'i marmat'o doonzo shinats t'intsosh Iyerusalem maants dek't bo ami. ");
INSERT INTO bwo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Han bok'alwere doonzo kitsts nemok'on «Nungush na'a wotts k'aab́ jamo doonzosh, galdek' imeke b́ wotiti» eteets tzaziyok'on guut'etsone. ");
INSERT INTO bwo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mank'o doonzo nemon «Git kurkundwotsi wee git eejiyi nana'uwotsi woshosh t'intso geyife» eteets alo fa'e b́tesh. ");
INSERT INTO bwo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Manoor Iyerusalemitse Sm'oni eteef ash iko fa'e b́tesh, bíwere b́kasho Ik'osh imk kááw asha b́ teshi, Isra'elsh weet kashiyono b́ kotiri b́ tesh. S'ayin Shayironwere bí atsatsa b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Bí doonzo mesihiyo b́be'aawo b́ k'irrawok'o S'ayin shayiro shaani dek't kitsre b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Manots aawots S'ayin shayiro b́gitsotse bín b́tuuzre Ik'i moo maants bíami, Yosefnat Mariyamwere bo nemok'on danetso na'osh finosh na'o dek't Ik' moots bo kindor ");
INSERT INTO bwo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Sim'on na'i marmat'o k'a'údek't erdekt, Ik'o údefetst hank'o bíet, ");
INSERT INTO bwo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Doonzono! hamb, jangiyat taash nimtso s'eenwtsere, Eshe haniye hakon taan nguutso jeenon k'aaúde'e. ");
INSERT INTO bwo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","N kashiyo ti aawon bek're, ");
INSERT INTO bwo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Bíwere ash jami shinatse nk'anitsoniye, ");
INSERT INTO bwo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Bíwere Ik' ash woteraw ashuwotssh aro kish kitsit shaano wotitwe, N ashuwotssh Isra'elsh mango wottsoniye.» ");
INSERT INTO bwo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yosefnat Mariyamnowere na'o jangosh keewets jamatse tuutson ada boadfoni. ");
INSERT INTO bwo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sim'on boon b́deeriyhakon bítsnor na'i marmat'o ind Mariyamsh hank'owa bí et, «Hambe! na'i marmat'an Isra'elitse ayuwotssh t'afosh, ayuwotssh kashi jango wotitwe, bíwere ayuwots b́keewo k'ew dek'o bok'azetwoniye milikit wotitwe. ");
INSERT INTO bwo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mannowere aywots nibotse fa'a aashts asaabiyo keer be'etwe, nnibonowere shiyani shiko kap'de beshitwe.» ");
INSERT INTO bwo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mank'o manoor Aser naar wotts Fanue'l ní Hanayi eteetsu bek'etsu fa'a b tesh. Ayi dekat gawerwtsk máátsi b tesh, b kenihnton shawat nato b beyihako keniho k'irb́wtsi, ");
INSERT INTO bwo_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Maniyehakon b nato habi gitonat awd nato b́ wotefetsosh Ik' mootse b orerawon s'oomiyon, Ik' k'onon, aawonat t'úwon Ik'osha bfinefera b tesh. ");
INSERT INTO bwo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Manoor biwere waat́ doonzo údo dek'btwi, na'i marmat'o jangosho Iyerusalem bín kashosh jangat kotirú jamwotssh bkeewufo. ");
INSERT INTO bwo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Doonzo nemotse finef jamo fin bok'rihakon Gelil datsatse daatseyiru bo beyiru bo kitu Nazret maants k'az bo aani. ");
INSERT INTO bwo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na'i marmat'onwere eenono eenfetst kup'efere bí ami, danonowere s'eenḱ wotb́wtsi, Ik'i s'atonwere bíntoni b́tesh. ");
INSERT INTO bwo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yosefnat Mariyamn worwot worwoton fazigi baaliyi aawor Iyerusalem maantsan bo amfo bo tesh. ");
INSERT INTO bwo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Iyesus tatse git nat wotbwtstsok'on bo nemok'on baaliman mangiyosh bo ami. ");
INSERT INTO bwo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Baaliyono ish bobazihakon bo bomoo maants bo aanor Iyesus Iyerusalemits oorb́wts, Yosefnat Mariyamnmó manoke b́ ooro danatsno botesh. ");
INSERT INTO bwo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Weratse sha'irwotsnton towat bí amiruwok'o boosh bí arere, ik aawjini sha'o sha'eron bo jini, maniye il bojag jamoknat bodants ash jamoke geyo dek' botuu. ");
INSERT INTO bwo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ernmó daatso bo maawutsotse geefere Iyerusalem maants bo aani. ");
INSERT INTO bwo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Keez aawoniye okoon Ik' mootse daatsbodeki, manokno aaydekt dantswots dagotse bedek't bo keewirwo k'ebfetst bosho aato b́t'intsfera b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","B́ keew k'ebts jamwots b́ t'iwintsirwok'onat boosh bíanirwok'o bek't bo adifera bo tesh. ");
INSERT INTO bwo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Yosefnat Mariyam bín Ik' mootse bobek'tsok'on ada bo adi, manoor indu, «Tnaayo eegishe hank'o taan nk'ali? N nihnat taan kic'at neen no geefera noteshi» bi et. ");
INSERT INTO bwo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Iyesuswere «Eegoshe taan it geyi? taa t nih mootse woto taash b́ geyitwok'o danatsteya?» bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Boomó bí b́ keewtsman t'iwintsratsno. ");
INSERT INTO bwo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Maniye il Iyesus Nazret maants bonton bíami, booshowere alya bí alefoni, b́ indwere keew jaman b nibotsa b detsfo. ");
INSERT INTO bwo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iyesus Ik'onat ash shinatse shuneek wotat, dan teleefonat need'on eenfere bí amfo. ");
INSERT INTO bwo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Rom nugús wottso T'ibariyos b́naashtsi tatse útsl naton P'ent'os P'ilat'os Yihud datso k'eezfoni b́tesh, Herodis Galil dats keweefoni b́ tesh, Mank'o bí eshu Filatp'os It'uriyasnat T'rakonidosi kewútso, Lisaniyosm Abilenensi kewtsoni botesh, ");
INSERT INTO bwo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hananat K'eyafwere kahniya bo tesh, manoor Zekariyas naay Yohans worwotse b́befere, Ik'i aap'o b́ maants b́ waa. ");
INSERT INTO bwo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Mansh Yohans, Yordanos foki gúúratse fa'a daats jamwotsatse gúúrefetst «It fints morrosh orowe eto it daatsish it fints morrosh naandrone err gupewere,» et fetstni b́daniyfo. ");
INSERT INTO bwo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Han b́wotwere nebiyo Isayas Yohans jangosh shin shin hank'o ett b́ guut'tsok'on Eshe han woruwotse hank'o etfere kuhiru asho k'aaroniye, «Doonzo werindone k'aniwere! B́ fokonowere kaatswere! ");
INSERT INTO bwo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Dats k'ool jamonowere manutsider s'entsewe! Guronat daaw jamonwere dashan t'ine! K'uur werindonwere kawowe! Kaam werindonwere manutsowee! ");
INSERT INTO bwo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ash jamonwere Ik'i kashiyo be'e!» ");
INSERT INTO bwo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Gupeyosh b́ maants waats ay ashosh Yohans hank'owa bí etfo «It merziyets dawnzi nananotso! Weyiru Ik'i fayotse itkeshtwok'o kone itsh keewi? ");
INSERT INTO bwo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Abraham nana'uwots noone err it nibotse it'o k'ayr, naandrone it ettsok'o kitsit fino finore. Ik'o shútsanotsitse Abrahamsh nana'o tuuzo b́falitwok'o itsh keewirwe. ");
INSERT INTO bwo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","And shakurtso mitwots shirotse k'ut'osh k'anutsere. Mansha sheeng shuu shuraw mit jamo k'ut'etwe tawotsowere juwetwe.» ");
INSERT INTO bwo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ash jamonwere «Beree eeg k'alwonowa?» ett Yohansi bo aati. ");
INSERT INTO bwo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Bíwere, «Git tah detstso iko deshawosh ime, mísh detstsonwere deshawosh kayiwee,» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","T'ilish kakufwotswere gupeyosh bíyok waat «Danifono! noowere eeg k'alwono?» ett bo aati. ");
INSERT INTO bwo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Bíwere, «Nemon azazetsoniyere bogeshde aatk'ayere,» b́ eti. ");
INSERT INTO bwo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kes'kes'fwots waat, «Noo eshe eeg k'aluwono?» bo eti. Bíwere «Ash gizo weeralo bi'r dek'k'ayere, konnor kooton s'aamik'ayree, it took damozo itsh boree,» bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Man dúr ash jamo Mesihiyo woo jangatni bokotfere bo tesh, Mansh Yonassh «Ashaan mesihiyo wotifa k'úwa?» etfets bo nibotse bo asaabi. ");
INSERT INTO bwo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohansmó jamwotssh hank'owa bí et, «Taa itn aatson gupetwe, ernmó k'osho taayere k'up'o weetwe, taa b́ c'aami tipi joko bitsosh dab boratse, bí S'ayin shayiri tawon itn gupetwe. ");
INSERT INTO bwo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Bí búts úratse maayo buuyotse s'ayintsosh k'orbiyo b́ kishats detsdek're, b́ s'ayintsiyakon maay s'ayino t'iwots gaas'etwee, buuyonmo tahra tawon mits k'ritwe.» ");
INSERT INTO bwo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mank'o ash ashosh k'osh k'osh werindon izfetst sheeng keew man bo waazots b́ betsfera b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Gelil datso k'eezfo Herodismó bí eshu máátsu Herodiyadin b́ dek'tsonat k'osh k'osh gond finwotsi b́ fintsotse bín b́fayi. ");
INSERT INTO bwo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herods b́ gondats gondo dabt Yohansi tipi moots kindsh b́k'ri. ");
INSERT INTO bwo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ash jamo b́ gupehakon Iyesus b́ gupeyi, bí Ik' k'onoke b́ befere daro k'esheeb́wtsi. ");
INSERT INTO bwo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","S'ayin shayironwere eerkundo araat bíatsats b́ oot'i. Manoor «Nee tshunts taash shune naayo neene, neen geneúwitwe» etiru k'aaro darotse b́weyi. ");
INSERT INTO bwo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Iyesus daniyo dek' b́tuwor, b́ nato shash natok'oyi b́tesh, ash jamosh Iyesus Yosef naayi bíarefo, manwere Yosef Eeli naayi, ");
INSERT INTO bwo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eeli Mati naayi, Mati Lewi naayi, Lewi Milki naayi, Milki Yona naayi, Yona Yosef naayi ");
INSERT INTO bwo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosef Matatiyu naayi, Matatiyu Amos' naayi, Amos' Nahom naayi, Nahom Eslim naayi, Eslim Nage naayi, ");
INSERT INTO bwo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nage Maa'at naayi, Maa'at Matatiyu naayi, Matatiyu Semeyi naayi, Smeyi Yosef naayi, Yosef Yoda naayi ");
INSERT INTO bwo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yodaw Yonan naayi, Yonanu Resa naayi, Resa Zerubabel naayi, Zerubabel Selatiyal naayi, Selatiyal Neri naayi ");
INSERT INTO bwo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Milki naayi, Milki Hady Naayi, Hady K'osam naayi, K'osam Elmodam naayi, Elmodem, Erm. naayi, ");
INSERT INTO bwo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erm. Yose' naayi, Yose' Elezer naayi, Eliezer Yoram naayi, Yoram Mat'at naayi, Mat'at Lewi naayi, ");
INSERT INTO bwo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lwi Simon naayi, Simon Yihud naayi, Yihud Yosef naayi, Yosef Yonan naayi, Yonan Eliyak'em naayi, ");
INSERT INTO bwo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyak'em Melya naayi, Melya Maniyan naayi, Mayinan Mat'at naayi, Mat'at Natan naayi, Natan Dawit naayi, ");
INSERT INTO bwo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawit Isey naayi, Isey Iyobed naayi, Iyobed Boez naayi, Boez Selemon naayi, Selemon Ne'ason naayi ");
INSERT INTO bwo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ne'ason Aminadab naayi, Aminadab Ram naayi, Ram Arniy naayi, Arniy Hes'eron naayi, Hes'eron Fares naayi, Fares Yihud naayi, Yihud Yak'ob naayi, ");
INSERT INTO bwo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yak'b Yisehak' naayi, Yishak' Abraham naayi, Abraham Taraá naayi, Taraá Nakor naayi, ");
INSERT INTO bwo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakor Serug naayi, Serug Reúú naayi, Reúú Feleg naayi, Feleg Eber naayi, Eber Shelah naayi, ");
INSERT INTO bwo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelah K'ayin naayi, K'aynu Arfaksd naayi, Arfaksd Sem naayi, Sem Noh naayi, Noh Lameh naayi ");
INSERT INTO bwo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameh Matusal naayi, Matusal Henok naayi, Henok Yared naayi, Yared Melal'el naayi, Melal'el K'ayenan naayi, ");
INSERT INTO bwo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","K'ayenan Henos naayi, Henos Set naayi, Set Adam naayi, Adam Ik'o naayiye eta boetfo. ");
INSERT INTO bwo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iyesus S'ayin shayiron s'eengutsat Yordanos fokotse aanat b́weyi, maniyere hakon S'ayin Shayiron jisheyat woruwo maants k'azbíami. ");
INSERT INTO bwo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Manoke hab́ aawosh diyablos bín b́fadfera b́ teshi, aawmanotsitse eegor b́ marawotse b́ s'uwi aawatse k'ak'b́wtsi. ");
INSERT INTO bwo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Diabloswere Iyesusi «Ik'o naay neena wotiyal aab shúts han mish wotowe err azazowe!» bíet. ");
INSERT INTO bwo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Iyesuswere «Asho mish mec'ron beeratse ett guut'ere» ett bísh bí aani. ");
INSERT INTO bwo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Maniyehakon diyabilos Iyesun dambaan tuuts beyokok kishdk't dats jik'atse beyiru naash jamwotsi iknun kitsb́k'ri. ");
INSERT INTO bwo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","«Mangts al jamannat mang jamon neesh imetwe, jaman taash imek b́wottsotse t shuntsosh imo falfe, ");
INSERT INTO bwo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mansh nee taash n sagadiyal jaman nik wotitwe,» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Iyesuswere, «N doonzi Izar Izewer s'uzsh sagadowe! B́ s'uznowere Ik'iwe, ett guut'ere» et bísh bí aani. ");
INSERT INTO bwo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Maniyehakon Diyablos Iyesusi Iyerusalem maants dek' bí'ami, Ik' maa tookats kede'́er b́ ned'itwok'o k'alt hank'o bísh bí et, «Arikon nee Ik'o naay neena wotiyal, aab hanatse dashan t'olar ood'e, ");
INSERT INTO bwo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","‹Neen bokotetwok'o b́melakiyo azazitwe, ");
INSERT INTO bwo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","N tufonowere shútso b́jod'awok'o, bokishon te'úde neen oriy dek'etúne.› ett guut'ere» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iyesuswere, «‹N Ik'o doonzone fadk'aye› et guut'ere,» ett bí aani. ");
INSERT INTO bwo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Diyblos Iyesusi fado bí ishiyehakon manorish bín k'azk'rat bíami. ");
INSERT INTO bwo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iyesuswere S'ayn shayiri angon s'eenwtsat Gelil maants k'az bí'aani, b́ shúútsi eenonwere b́ gúúratse fa'a dats jamwotsatse shiye b́wutsi. ");
INSERT INTO bwo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ayhudiwots Ik' k'oni mootse boon b́ danifoni, únetswotswere b́ daniy manatse tuutson bín bo údi. ");
INSERT INTO bwo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Maniyere il Iyesus b́ eents datsats Nazret maants bíami, b́ k'alfok'owere sanbati aawon ayhudiwots Ik' k'oni moots b́ kindi, nababosho b́tuwi, ");
INSERT INTO bwo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nebiyo Isayas mas'aafo bísh imeyi, mas'afmano b́ jargtsok'on, hank'o ett guut'etso beewoko daatsb́dek'i, ");
INSERT INTO bwo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Doonzo shayiri S'ayno ti atse b́faoni, Doo shishiyo t'owwotssh tshishiytwok'o taan woshere, Tipeetswots bo bishitwok'o, Dogwots bobek'etwok'o, kuhar t keewish er Kic'iyetswtswots bo kic'otse boon t kishitwok'o taan woshere, ");
INSERT INTO bwo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mank'o doonzo ash jamo bín b́kashitwo s'aati dúronowere t daniytwok'o taan woshere.» ");
INSERT INTO bwo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Iyesuswe mas'aafo k'oddekt ayhudiwots Ik' k'oni mootse wosheyirwosh imk'rat be b́wtsi, ayhudiwots Ik' k'oni mootse fa'a jamo b́maand aanat t'iwints dek't bín s'iilo dek't botuwi. ");
INSERT INTO bwo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Bíwere «Hamb! and nababere it shishts S'ayn mas'afatsi aap'o s'een wutsere» bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","B́ jangosh jamwotswere sheenga bo keewfo, b́ keewiru s'aaton s'eents keewmaanatse tuutson adt «Han Yosef naayiyoshna?» bo et. ");
INSERT INTO bwo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Iyesuswere boosh hank'o bí et, «Nee hakimiyono, aab n tooko kashiwe, etirwo jewron keewetso tiats it keewituwok'o danfee, mank'o ‹K'frnahomn k'alrne boere noshishts jamo, hanoke ndatsatse k'alwe› etetute tasha. ");
INSERT INTO bwo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Arikoniye itsh tkeewiri, nebiyiyo b́ dats ashuwotsoke mangrakee. ");
INSERT INTO bwo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","«K'ewere ariko itsh keewna, Nebiyo Eliyas dúr keez natonat shirt shashosh awusho bútso b́k'aztsotse dats jamatse k'ak'o kup'atni b́ teshi, Manoor Isra'el datsatse bo kenih k'irts mááts ayuwots fa'ano botesh. ");
INSERT INTO bwo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Eliyasmó, Sidon datson Serap'ta eteets galutse fa'a bkenih k'irts mááts iku s'uzoka wosheyi bako k'osho konokor wosheratse. ");
INSERT INTO bwo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mank'o nebiyiyo Elsa'a dúr ay een shod detstswots Isra'el datsatse fa'ano botesh, ernmó Soryi datstso N'imaniye okoon boyitse iko dab s'ayinatse.» ");
INSERT INTO bwo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ayhudiyots Ik' k'oni mootsno fa'awotsitse jamwots han boshishtsok'on ayidek' bofayi. ");
INSERT INTO bwo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tuutnwere Iyesusi geetsdek't kitoniyere ur kish bok'ri, gohots gfnide'e juk'rosh bokitu biageets gohi gúúrats dek'bokeshi. ");
INSERT INTO bwo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Bímó bodagotse beshat k'az bíami. ");
INSERT INTO bwo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Maniyere il, Iyesus Galil datsatse fa'a kitu K'frnahom maants bíam, manokno ash asho sanbati aawon b́ daniyfoni. ");
INSERT INTO bwo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","B́ keewiru keewonúwere alon s'eenk b́wottsotse jamwots b́ daniyatse tuutson ada bo adfo botesh. ");
INSERT INTO bwo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Manokno ayhudiyots Ik' k'oni mootse kim shayiron s'eents asho fa'e b́tesh, bíwere k'aari eenon hank'o etni b́ kuh. ");
INSERT INTO bwo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Nazrettso Iyesuso aage! Nee nooke eeg kis'e n detsi? Noon t'afiyosh wafi? Nee koni nwoto taa danfee, nee Ik'oko S'ayino neene.» ");
INSERT INTO bwo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iyesuswere kim shayirmansh, «S'k err bíatsotse keye!» ett b́ fay, Kim shayirmanwere ash jami shinatse ashman dikdek't eegor bín b́k'alrawon k'az b́keshi. ");
INSERT INTO bwo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Jamwots adt bo atsatseyosh, «Han aak'o aap'e? Kim shayironowere alonat angnon b́ azaziri, boowere bísh aleyat bo keshiri,» boatsatsewosh bo etfera botesh. ");
INSERT INTO bwo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Iyesus shútsonwere gúúrmanoki dats jamwotsatse shisheye b́wutsi. ");
INSERT INTO bwo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iyesuswere ayhudiyots Ik' k'oni mootse kesht Simon moo maants k'azbíami. Manokno Sim'on awu ay dek'at bi atso k'es't bí'ere shodat bk'eyir, mansh bin b́kashitwok'o Iyesusi bok'oni. ");
INSERT INTO bwo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iyesuswere bmandan t'int́ bganok need'dek't biatsi weshman b́ fakshitwok'o bí hadi, bi atsi k'es'manwere fakshb́k'r, manooro tuwat boon ibiyo dekbtwi. ");
INSERT INTO bwo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Aawu bkindor ash ashuwots ayi naari shodon boshirotse deshets shodets jamwotsi Iyesus maants dek' bowaa, bí were ik ikon boats kisho gedt b́ kashiyi. ");
INSERT INTO bwo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Foerawwotswere «Nee Ik'o naay neene!» et fetst kuhefetst ay ashuwotsi faksht bokeshi, bíwere Mesihiyo b́ woto dandek'rno bo tesh. Iyesusmó b́ jangosh eegoru bo keewawok'o fayatni b́bazi. ");
INSERT INTO bwo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Datso gatsb́wtstsok'on Iyesus manoke kesht ash aaloke dats baashok k'azbiam, ash ashuwotswere bín geyokna bo tesh, daats bodek'tsok'ono «Noon k'ay amk'aye» ett bok'oni. ");
INSERT INTO bwo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Bímó «Taa twoshe hansh b́ wottsotse k'osh kitwotsits amr Ik'i mengst doo shish keewo taan geyife,» bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Mansha Yhudn fa'a ayhudiyots Ik' k'oni maa jamwotsitse gúúrat b́ nabfoni. ");
INSERT INTO bwo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ik aaw Iyesus Genseret' aats k'ari gúratse need' dek't b́ befere ay ashuwots b́ maants t'int Ik'i aap'tso k'ebosh bo gifniyefere bo teshi. ");
INSERT INTO bwo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Bí aats k'ari gúrats t'iindek't need'iru jelb gitwotsi bek'b́k'ri, mus' detsirwotsmó jelbwotsitse kesht bo mus'i kambwotsi bo mashfera botesh. ");
INSERT INTO bwo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Iyesus jelbwotsitsi iku, Simoonk wottsuts b́ kindi. Simonshowere «Jelbani datsatse aats k'aromaants aab taash t'intswe» bí et. Maniye okoon jelbú'ats bedek't ash asho b́ daniyiri b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","B́ keewrwo b́ ishyakon Sim'onsh, «Jelbu ay dek't k'arts aats k'aromaants wokide'er neenat n tohuwotsn mus' detsosh juwore,» b́ et. ");
INSERT INTO bwo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sim'onwere «Danifono! t'ú jamo maawron gatsaat eegor deshatsone, nee ni'etihakonmó, hambe! mus'i kambo shap'etwone,» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Mus'i kambman bo shap'tsok'on kambo b́ gad'efetso weeralo ayts mus'o detsbodek'i. ");
INSERT INTO bwo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mansh k'osh jelbutse fa'a bo tohuwotsi kolon waar boosh geetso bo dabitwok'o bo s'eeǵ, boowere waat git jelbuwots limosh muk'i boborfetsosh mus'on s'eents bok'r. ");
INSERT INTO bwo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon P'et'ros man bek'b́k'rtsok'on Iyesus shinats tuk'umalgutsat, «Doonzono, Taa morretsk t wottsotse t maants t'ink'aye!» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Han bíettsonwere bínat bínton teshts b́ tohjamwots bo detsts mus'i aytsatse tuutson ayidek't adt boteshtsotsna. ");
INSERT INTO bwo_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Mank'o Sim'on tooh wottswots Zebdiwos nanawots Yak'obnat Yohansń adtni botesh. Iyesus Simonsh «Shenono shatk'aye, Haniyehakon ash detsetwo wotitune» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bowere jelbuwotsi aats gúúrats bot'intsi hakon jam keewo k'azk'rat Iyesus shuuts shoydek't botuwi. ");
INSERT INTO bwo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ik aaw Iyesus kit ikutse b́befere bíatso een shodon detsetso, eenshodonwere bí ats jamats keshutstso ash iko b́ maants b́ waa, Iyesusi b́ bek'ktsok'on b́ baron datsats gúp'gup'dek't t doonzo «Ni eekiyal taan s'ayintso falfne,» et bín b́ k'oni. ");
INSERT INTO bwo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iyesuswere b́ kisho jargdek' bín shuu'at «Eekere! s'ayine!» bí et. Ashmanwere manoor b́ een shodatse s'ayin b́wutsi. ");
INSERT INTO bwo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Manats dabt hank'o ett bí azazi «Keewan konshor nkewrawok'owa, ernmó niamtsok'on n tooko kahniwotssh kitswe, ash jamosh gaw b́wotitwok'owa n s'ayintsi jango Muse b́ azaztso woshoono t'intswe.» ");
INSERT INTO bwo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Iyesus shútso iki k'oshortsoniyere bogo shiye b́guuts, ay ashuwotswere b́keewo k'ebonat boshodotse kashosh geeyat bo kakuwefo. ");
INSERT INTO bwo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Bímó ash aalok k'ayamrni Ik'o b́ k'onfo. ");
INSERT INTO bwo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ik aaw Iyesus daniyoke b́befere ferisawi eteetswotsnat Muse nemo danifwotsn b́ganoke bedek'tni bo tesh, bo Gelilnat Yihud gál jamotse Iyerusalem kitotsnowere watswotsu fa'ano botesh. Iyesus shodetswotsi b́ kashiru doonzo ango bíntoni b́tesh. ");
INSERT INTO bwo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ash dúr iko es'oń kur dek'ts ash ashuwots Iyesusmaants dek't bowaa, Iyesus bítse b́ beyiru moots kindsh de'er b́shinats beezo geyatni bo tesh, ");
INSERT INTO bwo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ernmó asho bí'aytsatse tuutson durman moots kindsho bomaaw, mansh máá tookats dek' bokesh, máá tokono wogdek't máá maac'ots bí'es'onton Iyesus shinats orshdek't gedebok'ri. ");
INSERT INTO bwo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Iyesuswere bo aman amano b́bek'tsok'on durosh, «Ashono neena! n morro niatse sholbazere,» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nem danifuwotsnat ferisawino etefwotsn «Kone bíwo Ik'o c'ashirwani? Ash morro oorowe etosh falitwo Ik'oniye okoon k'osho kone fa'oni?» ett bo gitsotse bo gawfera botesh. ");
INSERT INTO bwo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iyesuswere bo bogawirman dank'rat boosh hank'o bíet, «It nibotse eegoshe hank'o it gawiri? ");
INSERT INTO bwo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","B́woteferemó ‹N morro neesh oorowe› etonat, ‹Tuur amee!› etotse aaw ketefa? ");
INSERT INTO bwo_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ernmó ash na'o datsatse morro oorowe etosh alo b́detstsok'o dano itsh geyife» ett ash durmansh, «Ashono neena tuuwe, ni es'o kur de'er n galomand amee!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Dúronwere manoor ash ashuwots shinatse tuut, bíats k'eedek't b́teshts es'o kurdek't, Ik'o údefere b́ galomand bí ami. ");
INSERT INTO bwo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Manoke fa'a ash jamwotswere ayidek't adfetst, shatoon «Hambets adits keewo bek'rone,» etfetst Ik'o bo údi. ");
INSERT INTO bwo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Maniyere il Iyesus manoke kesht bíamfere Lewi eteetso t'ilish ko'ifo t'ilish b́dek'foke b́befere bek'krat «T shuutso wowe» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi were jobk' ett jamó k'azk'rat b́ shuutso bíami. ");
INSERT INTO bwo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Maniye il Lewi b́mootse Iyesus mangosha ett een wotts móónat úshon k'aniyi b́k'ri, b́ k'anits móónat úshono t'ilish kakuf ayuwotsnat k'oshwotsu ay ash ashuwotsu datseyatni botesh. ");
INSERT INTO bwo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ferisawi eteefwotsnat bo jir wotts nem danifwots «T'ilish ko'ifwotsntonat morrotswotsnton maat b́ úshiri eegoshe?» ett Iyesus danifuwots aats bo mumund. ");
INSERT INTO bwo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iyesus hank'o et boosh bí'anyi, «Shodtswotssha bako jeenwotssh atetso geyiratse, ");
INSERT INTO bwo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Taa t wáá morretswots naandrone bo etetwok'o s'eegosha bako kááwwotsi s'egoshaliye.» ");
INSERT INTO bwo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ik ik ashuwots Iyesussh, «Yohansnat ferisawiwotsn bo danifwots ayoto s'oomefno, Ik'ono k'onfnere, n danifwots jam aawo máát bo'úshir eegoshe?» ett bín boaati. ");
INSERT INTO bwo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iyesuswere hank'o ett boosh bí aani, «Guuyo bonton b́befere guuy jishfwots bo s'oomo boosh geyitwe etatnya it gawiri? ");
INSERT INTO bwo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ernmó guuyo booke k'a'údek'et aawo weetwe, manoor s'oomitúne.» ");
INSERT INTO bwo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Manatse tuut Iyesus jewrdek' boosh ik keewo b́keewi, «Shemi handri but'o shemi nataats shipfo konwor aaliye, mank'o b́k'aliyalmó shemi handro gad'ni b́k'riti, but'i handronwere shemi natosh woteratse. ");
INSERT INTO bwo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mank'o weyni biri arwi natots weyni biri handro gas'fo aaliye, gas'eyalmó weyni biri handrman aruman t'up'inibk'riti, weyni birmanwere kud'ni b́gutsiti, arwonwere finats jinatse. ");
INSERT INTO bwo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mansh weyni handr biro arwi handrots gaas'o geyife, ");
INSERT INTO bwo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Weyni biri kats úshtso weyni biri beno úsho geeratse, ‹Ja'atso weyni biri katso k'anefe,› bí eteti.» ");
INSERT INTO bwo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sanbati aawon Iyesus taari taalon b́beshefere b́ danifwots sndyi motso k'ut'dek't bokishon shik'dek't moo dek' botuwi, ");
INSERT INTO bwo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ferisawino eteefwotsitse ik ikuwots b́danifwotssh, «Sanbati aawon k'alosh geyiraw keewo it k'alir eegoshe?» bo eti. ");
INSERT INTO bwo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Iyesuswere hank'o ett boosh bí aaniy, «Bínat bínton fa'a ashuwotsn bo k'ak'or Dawit b́k'altsok'o nababeratsteya? ");
INSERT INTO bwo_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kahniwotsiyere okoon konwor b́marawok'owa ett baziyetso, bí Ik'i moots kinddek't Ik'osh t'ints misho k'a'ú dek't b́ máá, bínton fa'uwotssho bí ími.» ");
INSERT INTO bwo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Manats dab́t Iyesus, «Ash na'o sanbatushor b doonziye,» bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sanbati aaw k'oshots Iyesus ayhudiyots Ik' k'oni moots kind dek't b́ danifera b́ tesh, manokno b́ kish dúr ash iko fa'e b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Muse nemo danifwotsnat ferisawino etefwotsen Iyesusi bín bos'aamit k'uur keewo bo geyefera botesh, «Sanbati aawon ashaan kashitwek'úna aab s'iilone» ett bín kot bodek'i. ");
INSERT INTO bwo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Iyesusmó bo gawirwo dank'rat kish durosh «Tuur taalots ned'de'e!» bí et. Duronwere tuut taalots need' b́dek'. ");
INSERT INTO bwo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Manór Iyesus ashuwotssh, «Aab́ itn aatuna, arikon aab sanbati aawots finore eteetso gond finemo doo fine? ash kash úd'emó ash kash oriyee,» bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Iyesus bín gúúr dek't beyiru ash jamwots maants b́s'ili hakon kish durosh «N kisho jargwe!» bíet. Bíwere b́kisho b́jargtsok'on kashutsat b́ kish k'oshokok'o jeen wotb́wtsi. ");
INSERT INTO bwo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Muse nemo daniyfwotsnat ferisawiwotsmó ayidek' nibok'únt, Iyesusi bo k'alitwok'o shiye bowtsi. ");
INSERT INTO bwo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ik aaw Iyesus Ik' k'onosh guri abaats kesh b́dek'i, manoknowere t'ú jamo Ik'omand k'onron b́ gatsi ");
INSERT INTO bwo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Datso b́gatstsok'ono b́ danifwotsi b́ maants b́ seeg, boyitsnowere tatse gitwotsi galdek't «Woshetswotsi.» ett boshútso b́ kishi, ");
INSERT INTO bwo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Boshútsonwere, P'et'rosi ett b́ s'eegetso Sm'onnat bíeshu Indriyasi, Yak'obnat Yohansn, Flip'osnat Bertelemyosi, ");
INSERT INTO bwo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiyosnat Tomasn, Ilfyos naay Yak'bnat «Okooretska» ett s'eegefo Sm'oni, ");
INSERT INTO bwo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yak'ob naay Yhudnat Iyesusi beshidek't imtso Ask'rottso Yhudne. ");
INSERT INTO bwo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iyesus bík woshetsnton guri abaatse oot't juwanots ned'b́dek', b́ danifwotsitse aywotswere manoke fa'ano botesh, anynwere b́ keewirwo k'eboshat boshodotse kasho geeyat wááts ay dek't ayts ash ashuwotswere fa'ano botesh. Bowere bowóóko Yhud datsatse, Iyerusalem kitotse, aatsk'ari ganoke fa'uwots T'irosnat Sidon kitwotsitsikno botesh. ");
INSERT INTO bwo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Kim shayiron detseyat kic'efetst teshts ash ashuwotswere waat kashefno. ");
INSERT INTO bwo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kashiyi angonwere bí atsotse kesht bo únetsi b́kashiyiruwotse kakuwets ash jamo Iyesus atsats bodosh bo geefoni. ");
INSERT INTO bwo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iyesus dambaan kááwdek't b́ danifwots maants s'iilfetst hank'o b́ et, «Ik'i mengstu itk bwottsotse, It t'owwots derek itne! ");
INSERT INTO bwo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","It and k'ak'irwots, ayts it mishetwotse derek itne! And epiruwots it, ayts it mis'etwotse derek itne, ");
INSERT INTO bwo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","T jangatse, ash na'o atse tuutson ash ashuwots iti bo shit'or, Bogalor, bo aatsniyononat it shútso bo t'afiyor derek itne! ");
INSERT INTO bwo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","«Darotse it daatsit k'awntso een b́wottsotse jaman itats b́ bodor derek itne! manór gene'on t'olar k'afore, shin shin bo nihotswor Ik'i ashuwotsats hank'o gond fina finat boteshi. ");
INSERT INTO bwo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«Gaaletswots itmó it beyi sheengosh wotitwo andon it datstsotse Indowe itsha! ");
INSERT INTO bwo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","And wortswots it, Ayits it k'ak'itwotse indowe itna It and mis'irwots, Ayits it shiyanituwonat it eepetwotse Indowe itnsha! ");
INSERT INTO bwo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ash ashuwots it jangosh sheengo bokeewor indowe itsha! Bonihotswor kootets nebiyiwotssh mank'o k'altniye boteshi.» ");
INSERT INTO bwo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«T keew k'ebirwotssh itshmó hank'o etirwe, it balangarwotsi shunere, iti shit'irwotssh sheeng keewo finore, ");
INSERT INTO bwo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Iti c'ashirwotsi deerwore, itn p'ek'irwotsish Ik'o k'onuwere, ");
INSERT INTO bwo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","N malal iko jabitwosh, dabr ikmandtso aani de'er ime, n shemi nat'alo dek'irwosh n kitonor dabde'er ime, ");
INSERT INTO bwo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Niyatse k'oniru jamosh ime, n detstso niatse dek'iru asho bí aanitwok'o aatk'aye. ");
INSERT INTO bwo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ashuwots itsh bok'alitwok'o itgeyirwo itwoor mank'o boosh k'alwore. ");
INSERT INTO bwo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Iti shunirwots mec'ro it shunal, deero it dek'et aawushe? Morretswotswor boon shunirwotsi shunfneree, ");
INSERT INTO bwo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Itsh sheeng fintswots mec'rosh itwere sheengo it finiyal eegoshe bogo daatso it faliti! morretswotswor mank'ó k'alfnosha, ");
INSERT INTO bwo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","‹Noosh aniyitune› etaat it gawiru ashuwotssh it gushiyal awuneya bogo it datsiti? Bogushitsman aani dek'osh morretswotswor morretswotssh gushifnee. ");
INSERT INTO bwo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Itmó it balangarwotsi shunere! sheeng keewonowere boosh finore, No gusho aniytune it erawon gushiwere, mank'o itk'liyal it k'awntso eena b́wotiti, jamoniyere damb bogts Ik'o nana'uwotsno wotitute, bí werigondetswotsnat úderaw gondwotsshor dowe. ");
INSERT INTO bwo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","It nih dartso maac' k'ewetsi b́ wottsok'o itwoor bíkok'o maac' k'eewtswotsi wotoore. ");
INSERT INTO bwo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Itats angsherawok'o konatsor angshk'ayere, itats angshratse, ash k'oshwotsi k'efk'ayere, itnowere k'eferatse, orowe erere, itwere orowe eto daatsitute, ");
INSERT INTO bwo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Imere, itshowere imetuwe, it tatsit tatsi k'ac'ots itsho tatsetwe, dab sheeng tatsi k'ac'otse mirde'er tuc'etso s'eenr kud' kud' ettso itsh imetwe.» ");
INSERT INTO bwo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Manats dabt Iyesus aridek't han boosh b́keewi, «Dogo dogo jishosh falitwá? Mank'o k'alitwe bíetalmó bo gitetswor desheyar gohots dihni bowtsiti. ");
INSERT INTO bwo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Daniru na'o bín daniyrwoniyere bowatse, ernmó daniru na'o sheengeshde'er danbdek'al bín danyrwok'o wotituwe. ");
INSERT INTO bwo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","N ááwotsi gindo nbe'aawo eegoshe n eshu aawitsi kimúwu n s'iliri? ");
INSERT INTO bwo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ando ni'ááwotse fa'a gindo nbe'aawo nieshush ‹Ti eshuwo, n aawitsi fiishani aab neesh kishuna› eto aawuk'oneya nfaliti? Nee git alberetsono, shin shino ni'aawitsi gindo kishuwe, maniyere il nieshu aawotse fa'a fiisho s'ayintsde'er s'iilo falitune.» ");
INSERT INTO bwo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Miti sheengo gond shuwo shuurake, ando mank'o miti gondo shwi sheengo shuurake. ");
INSERT INTO bwo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mit jamo b́shuwona b́ danefo, angitsotse belesiya eteef miti shuwo mec'eraka, mank'o angitsi atatse woyiniya eteef miti shuwo mec'eraka. ");
INSERT INTO bwo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ash sheengo b́ nibi s'aynotse sheeng keewo kishitwe, gond ashonwere b́ god nibotse gond keewo kishituwe. Ashoniye b́ maac'otse s'eentsoniye b́nonon b́ keewfoni.» ");
INSERT INTO bwo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Taa t keewirwono fineratstere, eshe eegoshe, ‹t doonzo! t doonzo! etaat taan it s'eegiri?› ");
INSERT INTO bwo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","T maants waar t aap'tso k'ew de'er finats jitsitwo koni bí artsok'o itsh keewna, ");
INSERT INTO bwo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","B́ gop'o dashan wokidek't isht b́ moo kup' s'alats need'idek't detsits ashoni bí ariye, di'onwere waat maaman b́ gifniy, ernmó kup'ts s'alats b́ detsetsotse giwsho falratse. ");
INSERT INTO bwo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ti aap'o k'ebt finats jitsrawonmó b́ moo dashan b́gop'irawo shawats agts asho arefee; di'o waat b́gifniytsok'on manoor dihb́wtsi, b́ dih dihonwe ayi dek't dhi een wotb́wtsi.» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iyesus jamhan ash ashosh keew b́ íshihakon K'frnahom maants bí ami. ");
INSERT INTO bwo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Manokno Rom datsatstso bali naash iko fa'e b́tesh, bíwere ayidek't b́shunf b́ guuts shodo bíats b́manzre k'iro b́beshi. ");
INSERT INTO bwo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Bali naashmanu Iyesus jango b́ shishtsok'on Ayhudi eenashwotssh «Oona itsha, Iyesus wáár taash t guutso b́ kashytwok'o amr taash k'onwere,» ett b́ wosh. ");
INSERT INTO bwo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bowere Iyesus maants amt, «Ashaansh han nk'alo bísh geyife, ");
INSERT INTO bwo_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Bí noo ash asho shunfee, Ayhudi Ik' k'oni moono noosh agree,» ett kup'idek't bok'oni. ");
INSERT INTO bwo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Mansh Iyesus bonton tohaat bí ami, b́ mooko bodosh bo etfere bali naashmanwere b́ jagwotsi hank'o ett Iyesusok b́ wosh, «Doonzono! Nee t moots nkinditwok'o bodk twoterawotse t moots wosh shambk'aye. ");
INSERT INTO bwo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Taawor ttokoon nmand wosh bodk taanaliye, Manoke bede'er ik nonu keewwe, t guutsonwere kashitwe. ");
INSERT INTO bwo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Taawor ttookon naashwotssh alek wotefetsat taayere dashwotsno t altswots kes' kes'fwotsi detsfe. Mank'o b́wottsotse ikosh ‹Amee!› ti etor ametuwe, k'oshosh ‹Wowe!› t etor weetuwe, t guutsosh ‹Hank'o k'aluwe!› ti etor k'alitwe.» ");
INSERT INTO bwo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iyesus han b́ shishtsok'on bí adi, b́ shutsatse weyiru ashuwots maantsan wongr ett, «Dab Isra'elitse hank'o bodts imnetiyo daatsratse» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Wosheetswere bali naasho moo maants aanat bowatsok'on b́ guutso kashat b́ befere daatsbodek'i. ");
INSERT INTO bwo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yatsok'on Iyesus Nayini eteets kit iku maants bí ami, b́ danifuwotsnat ayi asho b́ shutsats bínton towat boami ");
INSERT INTO bwo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Iyesus kitu fengshi ganok b́ bodtsok'on, ashuwots duuno kurdek't kitutse bokeshfera botesh, k'irts ashman b́ indsh ik s'uza b́tesh, b́ induwere kenih k'irts t'oow máátsi, kitutsnowere ay asho b shutsatse bo sha'iri. ");
INSERT INTO bwo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","doononwere bin b́ bek'tsok'on bish maac'o k'ewat «Epefne shenúne!» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Manye il b́ maants t'int she'o b́t'awiyi, she'ono kuriru ashuwots ned'bowuts, Iyesuswere «Nee jawetsono tuuwe etiruwe neesha!» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","K'irtsonwere jobk' ett tuut bedek't noon keewo dek' b́ tuu, maniyere hakon Iyesus indúsh «Hambe nnaayi,» ett imb́k'r. ");
INSERT INTO bwo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jametswotswere shatwtsat «Noyitse bek'ts eeno tuugutsere, Ik'o bí asho kashiyosh waare,» et fetst Ik'o bo údi. ");
INSERT INTO bwo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Iyesus shúútsonwere Yihudnat b́ gúrmanatse fa'a datsjamatse shiye b́wuts. ");
INSERT INTO bwo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yohans b́danif'uwots keew jamanots jango bísh bo keewi, bí were b́ danifwotsitse gitwotsi s'eegdek't, ");
INSERT INTO bwo_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","«Mesihiyo weetwe eteetso neenemó k'oshe nokoteti? err aatwere,» ett doonzo Iyesusok b́ wosh. ");
INSERT INTO bwo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bowere Iyesusok waat « ‹Weetwe eteetso neenemo? k'oshe nokoteti?› err aatwere ett gupfo Yohans niyok noon woshere,» bo et. ");
INSERT INTO bwo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Iyesus manoori sa'atmanitse ash ashuwotsi atsi weeshonat ay naari shodotse b́ kashiyi, kim shayirwotsnowere b́ kishi, ay aaw dogwotssho bo aawo b́ k'esh. ");
INSERT INTO bwo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Iyesus woshere watswotssh hank'owa bí et, «Aanar amr Yohanssh it bek'tsonat it shishtson keewwore, hambe dogwots bek'irunee, shoklirwotswere kawdek't sha'irune, een shodetswotsu s'aynirune, gidik'uwotswere shishirune, k'irtswotswere tuwirune, t'owwotssho doo shisho nabeyirwee. ");
INSERT INTO bwo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Aak'o gene'ona tiatse maac' k'ut'rawoni?» ");
INSERT INTO bwo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yohans woshtswots k'az boamihakon Iyesus Yohans jango ash ashosh hank'o et keewo dek'b́tu, «Eeg s'iile worwots oot'at it weyiri? Jongon hake bako giwiru elt s'iilisheya? ");
INSERT INTO bwo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Eeg bek'oshe keshat it weyiri? Tah sheeng tahiru asho s'ileya? Tah sheeng tahirwotsnat beyi sheeng beyirwotswo naash naashi mootsere bo fa'oni, ");
INSERT INTO bwo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Aab taash keewwore, eeg s'iiloshe it keshi? Nebiyo s'ilosheya? Ee, itsh keewirwe, dab nebiyiyonyere iki bogtso s'ilishe. ");
INSERT INTO bwo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Bíwere ‹Eshe! n shin shinatse beshar n weerindo k'aniytwo twosh na'o deyitwe,› ett guut'etsoniye. ");
INSERT INTO bwo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Máátsatse shuuts jamwotsitse Yohansiyere bogo konwor aaliye, Ik'i mengstotsnmó jamotse muk'o bíyere bogfe.» ");
INSERT INTO bwo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Han bo shishtsok'on ash jamo t'ilish ko'irwots dab bo'orerawo Yohans kishatse gupeyat boteshtsotse Ik'i fino arik b́wottsok'wo t'iwints bodek'i. ");
INSERT INTO bwo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ferisawiwotsnat Muse nemo danifwotsnomó Yohanis kishon guperatsone ett Ik'i shuntso k'efatniye botesh. ");
INSERT INTO bwo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Manats dabt Iyesus hank'owa bí'et, «Eshe and dúri s'oot'an egonton boon ariywta? Eege bo arik'úna? ");
INSERT INTO bwo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Gawiyi beyoke bedek't kaashirw nana'uwotsi arefne, boowere boatsatseyo s'eyeyat ‹Turaro itsh nofugi, itmó duuwatste, eepi jááwono nojáwere eefatste,› etirwotsiye. ");
INSERT INTO bwo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Gupfo Yohans b́woor misho b́marawonat weyniy bíron b́úyawon b́watsosh ‹Fo'erawoniye bí'atse fa'oni› it eti. ");
INSERT INTO bwo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ando ash na'o mafere úshfere b́watsosh, ‹S'iilere maac' geenzonat máshetsana, t'ilish ko'ifwotsnat morrets ashuwotssho kod'i ashe› it eti. ");
INSERT INTO bwo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Dan telefu arik b́ woto b nana'atsnee b be'efonye.» bíet. ");
INSERT INTO bwo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ferisawiwotsitse iko Iyesusi b́gale aaw misho b́metwok'o b́ s'eegi, Iyesuswere ferisawiya eteetsman gal amt mishimarats t'iin b́dek'i, ");
INSERT INTO bwo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kit manitse morr finon daneets mááts iku fa'a b́tesh, bíwere Iyesus fersawiya eteetsman gale mishimaratse b́beyirwok'o b shishtsok'on shituwo bin s'eentso albat'rosiya eteets shútson dozets blk'at'iyon s'eents shituwo dek'at bweyi. ");
INSERT INTO bwo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Iyesus shutsomantse b́ tufi ganoke need'dek' eepfetsat b́ tufo bi ac'uwon ok'iyfetsat b took s'iron bfiri, b́ tufuwotsno jobefetsat shitúwon bfuutiri. ");
INSERT INTO bwo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ferisawiya eteets waa misho moowe ett s'egtsman wotiruman b́ bek'tsok'on, «Ashaan nebiya wotink'ere bín shú'iru máátshan koni b wotonat aak'o morretsk bwoto danak'e b́teshi» ett b́ nibotse b́ gawi. ");
INSERT INTO bwo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iyesuswere, «Sim'ono! neesh tkeewit keew iko detsfe,» bíet. Bíwere, «Eek'uwa, danifono! abtaash keewwe!» bíet. ");
INSERT INTO bwo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Iyesuswere hank'o etfere keewo dek't b́ tuu, «Ash iko git ashuwotssh gizo gushitso fa'e b́ tesh, iko atse úts bal dinariyo, ando ikoatse balk'ats dinariyo b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Gitetswotswere bogushtso dasho bo maawere boatsi k'awntsman dasho k'ayk'rore bí et, eshe aab bogitetsitse boosh giz gushitsman bogshde'er shunetuwo aawi arefa neesha?» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sim'onwere, «Ay k'awntso b́ daywok'o orowe eteetso bogshde bín b́ shuneetwok'o arefee taasha,» ett bíaany. Iyesuswere «Aree n keewi,» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Maniye hakon Iyesus máátsu maants wongr ett aanat Sim'onsh hank'o bí'et «Máátsani bek'irwiya? Taa n moots t kindihakon nee dab tutuf mashi aatso doratsne, bimó ttufo biac'won mashat b took s'irone b firiri. ");
INSERT INTO bwo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nee taan jamo niator joberatsne, bimó n meyits t kindron t tufo jobo ned'iratsaniye, ");
INSERT INTO bwo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nee t tookats zeyito dab furatsne, bimó t tufwotsi shitwo futraniye. ");
INSERT INTO bwo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Manshe bi ayi dek'at b shuntsotsne b morro ayone bish orowe eteyi maniye neesh t keewi, b́ morro múkshdek't oorowe eteetsonmó b́shunwere múkshdek'tniye.» ");
INSERT INTO bwo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Maniye hakon Iyesus máátsmansh, «N morro neesh orowe eteere,» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bínton mishimarotse mafetst teshtswotsmó «Morronor orowe etetwuhan kone?» ett bonibotse gawo dek't botuu. ");
INSERT INTO bwo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Iyesusmó máátsmansh «N imnetiyo neen kashire, jeenon amee!» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Maniyere il Iyesus kitwotsnat gál gálotse Ik'i mengsti jango nabfere doo shishiyo keewfere b́beshir, tatse gitwotswere bíntoni botesh. ");
INSERT INTO bwo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Mankoó kim shayirwotsnat bo shodatsnowere kashts máátswots Iyesus shutsatse bo sha'efere botesh. Bowere fo'era shawatwots biatsotse keshtsu Megdelawi datstsu Mariyami eteetsu, ");
INSERT INTO bwo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Herodis mootse alat teshtso Kuz máátsunu, Yohanna, Sosnanat k'oshwots ayuwots fa'ano botesh, máánots Iyesusnat b́ danifwotssh bo gizona bofinefo. ");
INSERT INTO bwo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ay asho kitwotsitse keshit b́ maants waat ikok kakwe bowtstsok'on Iyesus hank'o ett jewrdek't b́ keew. ");
INSERT INTO bwo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Goshts iko shooko shookosh dek't b́keshi, b́ shokferowe maay shook ik iko weerindi gúrats fed'at net'eb́gutsi, kaf kafwtswere mec'dek' maabok'r, ");
INSERT INTO bwo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Shook k'oshonwere dats t'orats fed'b́gutsi, b́ bos'tsok'onowere daats shuuk' b́wottsotse bos'ts bos'man shuk'b́gutsi. ");
INSERT INTO bwo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","K'osh shookonwere angitsi dagots fed' b́wutsi, angits manwere bínton eent guk' dek' oryib́dek'i ");
INSERT INTO bwo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","K'osh shokonmó sheeng datsats fed'at bos' b́gutsi, b́ bos'manwere eent ik ik shiro bal shuwo b́shuwi.» Manats dabt Iyesus, «Shiy waazo detstso k'ewe!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","B́ danifwots Iyesussh, «Ariydek'at nkeewts keewhan biitso eega etee?» ett bo aati. ");
INSERT INTO bwo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Iyesuswere hank'o ett boosh bí aaniy «Ik'i mengsti jango dano itsh imeke, k'oshwotsshmó keew jamo jewrone keeweti, ernmó bo be'eftsr t'iwintsratsno, shisho shifetsr nibn bode'awok'oye.» ");
INSERT INTO bwo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jewuron keewets keewman bitsonúwere hank'oyiye, «Shooko Ik'i aap'oniye» ");
INSERT INTO bwo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Werind gúrats fed'ts shooko ariyetsman b́ kitsir Ik'i aap'o manórush k'ebirwotsi, ernmó bo amanar bokasherawok'o Diyablos waár Ik'i aap'tso bo nibotse k'a'udek'tsonye. ");
INSERT INTO bwo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Dats t'orats fed'ts shooko b́kitsirwo Ik'i aap'o boshishtsok'on gene'on dek'iru ashuwotsiye, bomó boamanit manórusha, s'ap'o bodeshawotse fadewo boats b́ waal manoor bíne bohaaliti. ");
INSERT INTO bwo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Angitsi dagotse fed'tswotsi artso b́kitsir Ik'i aap'o manorush k'ebiru ashuwotsi, ernmó datsanatsi beyosh shiyanonat gaalon, datsatsi sheeng beyo gú'de'er shuwlon boon orib́k'rti. ");
INSERT INTO bwo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Dats sheengats fed'ts shooko artsonmó b́ kitsirwots Ik'i aap'tso shisht nib sheengonat kááwon k'ebdek't kotdek'tswotsi, boowere bíaapts aap'atse kup'at shuu shuwirwotsiye. ");
INSERT INTO bwo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Manatsdabt Iyesus hank'owa bí et, «C'eesho c'eeshde oosho bí ats gup'shfo wee es'ishirots gedfo konwor aaliye, maniyere dab úratse moots kindiru jamwots b́ shááno bobek'etwok'o s'ogatsa b́gedfoni. ");
INSERT INTO bwo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","«Mank'owo aatsetso be'erani, aashtso daneeraniye orituwo aaliye. ");
INSERT INTO bwo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","«Eshe Ik'i aap'tso it k'ebor it atso korde'ere, detsts ashosh daabde'erni bísh imeti, deshawoshmó dab detsfe bíetirwnor bíatse k'a'uni dek'eti.» ");
INSERT INTO bwo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Iyesus indnat bí eshuwotsn b́ maants bowaa, ernmó ash aytsatse tuutson bín daatsratsno. ");
INSERT INTO bwo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mann, «Hambne! nindnat n eshuwotsn úratse need' dek't neen bek'o geefne.» ett ashuwots bísh bokeew. ");
INSERT INTO bwo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Iyesuswere «Ik'i aap'o k'eb́dek't finats jitsitu jamwots bona tindu ti eshuwotsiye.» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ikaw Iyesus b́ danifwotsnton jeelobuts kind dek't «Bak'ets kimone» bí et, boowere amoosh botuu. ");
INSERT INTO bwo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Aatsk'ari abaatse jookdek't bo kimfere Iyesus tokrb́gutsi, manoor kup' eguraho aats k'armanatse tuub́wts, atsonwere jelbuts s'enfere b́waare shatbowtsi. ");
INSERT INTO bwo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","B́ danifwotswere, «Age danifono! danifono! s'uuroone!» eton Iyesusi tuzbodek'i. Bíwere manoor tuut jongonat angnon giwu wutsts aatso b́ hadi, jongonat angi eenon giwuts aatso manoor need' bowutsi, manye il jamkeewo ayidek' s'ik etb́wutsi. ");
INSERT INTO bwo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Maniye il Iyesus b́ danifwotssh, «Aawne it amantsoni?» bí et. Boomó ayidek't adt shatt, boatsatsewo, «Jongonat angi eenon giwuts aatsonor ale bíaliri, boowere bíshe boaleyiri, ashaan kone bí?» bo et. ");
INSERT INTO bwo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Aats k'aro kimt Geliliye bak'etse fa'a Gergesenoni am bobodi, ");
INSERT INTO bwo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iyesus jelbutse dats b́ oot'tsok'on fo'erawo bíatsots s'eents ash iko kitotse kesht bín gonkb́dek'i, ashman araatson b́ beyihakon aydúro teshka, b́befonwere doow doowi beyoka bako mootsali, ");
INSERT INTO bwo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Iyesusi b́ bek'tsok'on b́ kuhi, Iyesus shinatsowere dats diht b́k'aaro eenshdek't, «Nee jamoniyere damb bogts Ik'o naay Iyesuso, ti atse eege ndetsi? oona neesha taan gondo bek'shk'aye,» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Man bí'etwere Iyesus kim shayirmansh asho atsotse b́keshetwok'o bí azaztsotsna. Maniye shinon kim shayironwere ashmanatse ayota b́ tuufo, muk'onat habliyon tifderni kotefo, ernmó habliyono b́k'ut'fo, muk'ono b́titsfoni. Fo'erawonwere bín joohde'er woruwotsa b́ damfo. ");
INSERT INTO bwo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iyesuswere «N shúútso kone?» ett bí aati, bíwere ay fo'erawwots bí'ats oot'dek't́ b́teshtsotse «T shúútso Legiyoniye» ett bíaaniy. ");
INSERT INTO bwo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Manoor fo'erawonwere «Oona neesha ayidek't dashan gop'ts gop'ots noon damik'aye» eton bín bok'oni. ");
INSERT INTO bwo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Gohi gúúratse jiniru guritsi s'eeno fa'e b́tesh, fo'erawotswere, «Guritswotsits nokindish noosh eekowe» ett Iyesusi bok'oni, bí were boosh «Kindwere» bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mann fo'erawwots ashmanitse kesht Guritswotsts bokindí, Guritswots gohatse t'olefere bo'ot', aats k'arots kindt limbowtsi. ");
INSERT INTO bwo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Gurits jinirwotswere wottsman bobek'tsok'on shatoon k'azbowos'i kit kitonat gál gáltse keewman shishiy. ");
INSERT INTO bwo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ash ashuwotswere wotts keewman s'ilosh bo maa mootse kesht Iyesus maants boweyi, fo'erawwots bíatsotse keshts ashonwere bíatso dandek't taho tahdek't Iyesus tufishirotse b́ befere bek't shatbowts. ");
INSERT INTO bwo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Áawon bek'tswotswere fo'erawwotsn detseyat teshts ashman awuk'on b́kashtsok'o bokeewi. ");
INSERT INTO bwo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Maniye il Gergesenon dats ash jamwots Iyesus bo datsatse k'aybíametwok'o bok'oni. Man bo etirwere ayi dek't shat t botehstsotsna, mansh Iyesus jlbots kínd dek't b́ waats datsomand aanat k'azbíami. ");
INSERT INTO bwo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Fo'erawo bíatsotse keshts ashman Iyesussh «Oona neesha n shuutso sha'ona,» ett b́k'on. Iyesusmó hank'o ett jami b́k'ri. ");
INSERT INTO bwo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«N galomand amr Ik'o neesh b́ k'alts jamo keewwe» ashmanwere Iyesus bísh b́k'alts keewi eenman kit jamotse keewfere bí ami. ");
INSERT INTO bwo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ash jamo bí b́kotirwotse Iyesus aanat b́waatsok'on jametso gene'ona bín bodek'i. ");
INSERT INTO bwo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Manoor Ayhudi Ik' k'oni maatse naash wottso Iya'irosi eteets asho b́waeyi, Iyesus tufi shirots diht, «Oona neesha t gal wowe,» ett b́k'oni. ");
INSERT INTO bwo_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Han bí'etirwe tatse git nat wottsu b́ na'a ik s'uzu shodat k'irosh biettsotsna. Iyesus bínton towat bíamfere b́shutsatse bín shoydek't amiru ash ay boatsatseya bo gifniyfera botesh. ");
INSERT INTO bwo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mááts iku tatse git nat jamo s'atso kud'at need'o b́k'aye ayi dek'at kic'iru fa'a btesh, b detsts gizo jamo atetswotssh im ishat boyitse konwor bin kashiyo falratse. ");
INSERT INTO bwo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Biwere Iyesus maants wáat b́shutsatse bíyok t'iinat b́ shemi jilo b t'awi, manoor b s'atsi kuud'o ned'b́wts. ");
INSERT INTO bwo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iyesuwere «Kone tiats bodtsoni?» ett bí aati. Jametswots «Noo niats boratsonee» boeti, P'et'roswere «Danifono, ash asho neen gifnit nshuutso b́ sha'efere bek'fetsatniya kone tiats bodi nietiri?» bíet. ");
INSERT INTO bwo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Iyesusmó «Ango ti atsotse b́keshtsok'o tdantsotse arikon ash iko tiats bodre,» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Máátsmanwere ááshar b oorerawok'o bdantsok'on k'ewefetsat Iyesus maants waat b́tufishirots b dih, maniye il eegosh bín bt'awitsok'onat manoor bkashtsok'o ash jami shinatse kish b́ keewi. ");
INSERT INTO bwo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Iyesuswere «T ni'e, n aman amano neen kashire, jamon amee!» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iyesus man keewoke b́ befere ash iko ayhudiyots Ik' k'oni maa naasho mootse kesht «N na'ú k'irgutseraniye, eshe danifo datsmec'ro shambik'aye!» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iyesusmó han shisht Iya'irossh, «Shenono shatk'aye, amanowe bako, n na'ú kashitwaniye,» bíet. ");
INSERT INTO bwo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Iyesus Iya'iros mook b́bodtsok'on P'et'rosiye, Yohansiye, Yak'obiye, na'ú nihnat indna boko k'osho konwor bínton gitsomaand b́ kindrawok'owa bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Manokno fa'a ash jamwots na'ú jangosh eepfetst, indowe indowe boetfera botesh. Iyesusmó, «Eepk'ayere, na'ú tokra btokri bako k'irratsaniye,» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Boomó na'ú bk'irtsok'o bo dantsotse bo jamets bíatsa bomis'i. ");
INSERT INTO bwo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Iyesus na'ú kisho dets dek't, «T ni'e, tuuwe!» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Bíwere b kasho bíatsots bí'aanere manoor jobk' etaat b tuwi, Iyesuswere «Bmetwo bísh imere!» ett b́ keewi. ");
INSERT INTO bwo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Na'ú nihonat indun ayidek't bo adi, bímó wotts jamo konshor bo kewrawok'owa ett boosh b́keewi. ");
INSERT INTO bwo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iyesus tatse git b́woshtswotsi b́maand s'eegdek't fo'erawwotsi kishosh, shod jam kashiy, angonat alon b́ imi. ");
INSERT INTO bwo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ik'i mengsti jango ash jamosh bo keewitwok'o shodetswotsno bo kashitwok'o boon b́ woshi. ");
INSERT INTO bwo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Hank'owa boosh bí et, «It werindosh wotitwo eegor deshdek' k'ayere, gumbonor b́wotiyal, k'arc'itonor, galonor, gizonor, woniyet tahonor dab daamk'ayere. ");
INSERT INTO bwo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ibo amr maa ikots it kindor gálmanitse keer it amfetsosh maa man mec'rotse teyere. ");
INSERT INTO bwo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Asha ashwots itn ibiyo bok'azetk wotiyalmó gálmani fakshr it amor it tufatsi k'undo tebk'rar ameree, manwere boats gaw wotitwe.» ");
INSERT INTO bwo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mansh wosheetsots maniye kesht doo shishyo daniyfetst shodetswotsi kashiyifere gál gálotse boguurefoni. ");
INSERT INTO bwo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ash ik iko «Gpfo Yohans k'irotse k'az tuure» ett bo keewirwotse Gelil dats k'eezfo Herodis Iyesus fints jamo b́ shishor daand b́wutsi. ");
INSERT INTO bwo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mank'o ik ikwots «Nebiyo Eliyas aanat waare,» bo etor k'atswotsmó «Shints nebiywotsitse iko k'irotse k'az tuure,» bo etiri. ");
INSERT INTO bwo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodiswe b́ kaaton «Taa Yohans tooko k'ut'rere, eshe, jaman k'alirwe ett keeweyirwo kone eshna?» bí etfo. Bín bek'ono b́ tewnfo. ");
INSERT INTO bwo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","B́woshefwots bowoshetsoke aani wáát bok'alts jamo Iyesussh bokeewi. Bíwere Betesayida eteets kitu ganoke fa'a jokats bo aali dek't bíami. ");
INSERT INTO bwo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ash ashonwre Iyesus beyoko áwok b́woto bo daniyakon b́shuutso shoy dek't botuw, bíwere boon dek't Ik'i mengsti jango boosh b́ daniyi, boshodatse kasho geeyat waats jamwotsno bo shodotse b́ kashi. ");
INSERT INTO bwo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Aawo ilosh bí'etfere, b́danif tatse gitwots Iyesus maants t'int «No beyirwokanwo woorwere, eshe ash ashuwotsi gúranatse fa'a kitwotsnat gat'eriwotsits amr mishonat k'eyokon gee bodek'etwok'o fakshk'rowe,» bo et. ");
INSERT INTO bwo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Iyesusmó «It it tookon bometwo boosh imere,» bí eti. Bowere «Noo nodetsiye úts mishunat git mus' mec'riye, man b́wottsotse no kewiyala bako jam ashaansh boratse,» bo eti. ");
INSERT INTO bwo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ash ashonwere úts kumk'oyi b́tesh. Iyesus b́ danifwotssh «Ash asho b'alk'ts b'alk'tson kayide'er bo bedek'etwoko woshwere» bíet. ");
INSERT INTO bwo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","B́ danifwotswere bí'ettsuk'o ash ashuwotsi bobetwok'o woshbok'ri. ");
INSERT INTO bwo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Maniyere il Iyesus úts mishwotsnat mus' gitwotsn k'a'udek't daromaants kááwdek't s'iilt Ik'o b́údi, tishde'er ash ashosh bokayitwok'o b́ danifwotssh b́ ími. ");
INSERT INTO bwo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Jametswots maat bowori, b́ danifwots ash mááre oorts mishi fed'o tatse git ooshi s'eeno bo k'a'úwi. ");
INSERT INTO bwo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ik aaw Iyesus bí'yal Ik'o b́ k'onfere b́ danirwots waat bínton be bodek', bíwere, «Ash asho taan koni etfno?» ett bíaat. ");
INSERT INTO bwo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bowere «Ik iko ‹Gupfo Yohansiye,› k'atswots ‹Eliyasiye,› etfne neesha, ‹Yoots nebiyiwotsitsi iko k'irotse tuure,› etirwotsu fa'ane,» ett bísh bo aaniyi. ");
INSERT INTO bwo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Itmó eshe, «Taan koni etfte?» et boon bí aati. P'et'roswere, «Nee Ik'i mesihiyo neene,» ett bísh bí aaniy. ");
INSERT INTO bwo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Iyesusere han konshor bokeewrawok'o kup'idek't b́ keewi. ");
INSERT INTO bwo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Manats dabt Iyesus b́ danifwotssh hank'owa bí'et, «Ash na'o gond bek'o ayide bí'ats b́bodo jinatse, eenashwotsnat kahniy naashwotsn, Muse nemo danifwotsoke gac'etwe, úd'etwe, b́wotiyalor keezl aawon k'irotse tuwitwe.» ");
INSERT INTO bwo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jametswotssh hank'wa bíet, «T shuuts waa geetso b́ beyal b́took keewo juk'rowe, aaw aawonowere b́ mask'aliyo kurde t shuutso sha'owa ");
INSERT INTO bwo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Taayere bogo b́ kasho shawsh geyitu jametswots t'ut'etúno, taasha err b́ kasho beshide'er imetwonmó ooridek'etwe. ");
INSERT INTO bwo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Asho datsatsi gaal jamo b́datsiyal, b́ kashunmó b́ t'afiyal eege bísh b́k'aliti? ");
INSERT INTO bwo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Taanat tdanits daniyi jangatse tuutson jitsitu jámo ash na'o b́mangonat b́ nih mangon, aani b́ melaki S'aynwots mangon b́ woor b́jangatse jitsitwe. ");
INSERT INTO bwo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Arikoniye itsh t keewiri, and hanoke fa'úwotsitse Ik'i megstu bo bek'fetsosh k'irrawwots fa'ane.» ");
INSERT INTO bwo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Iyesus han b́keewtsi shmt aawe hakon P'et'rosi, Yohansnat Yak'obn jishdek't Ik' k'onosh gur iko abaats keshb́dek'i. ");
INSERT INTO bwo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ik'o b́k'onfere bí'aro wone b́ wtsi, b́ tahonuwer nas' wotat b́ goli. ");
INSERT INTO bwo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mann! gawerawon git ashuwots waat bínton bokeweyir, boowere Musenat Elyasna bo teshi. ");
INSERT INTO bwo_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mangon be'eyat keewefetst bo teshtsonwere, Iyesus Iyerusalemitse gond bek'o bí'ats b́ bodetwok'onat b́ k'iritwok'ona b́teshi. ");
INSERT INTO bwo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Manór P'et'rosnat b́ tohwotsn tokron maawutsat k'egutserno boteshi, tokrotse bo tuwtsok'nmo Iyesus mangonat bínton teshts ash gitwotsn bo bek'i. ");
INSERT INTO bwo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ash gitwots Iyesusatse k'aleyat bo amtsok'on P'et'ros Iyesussh «Danifono, hanoke beyo noosh shenge, eshe iko neesh, iko Musesh, ikono Eliyassh, keez gofuwotsi áá de'one!» bí et, P'et'ros han bietoor b́ keewirwo danatse. ");
INSERT INTO bwo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","P'et'ros man keewoke b́befre daawno waat boon degbdek', dawnonwere boon degb́dek'tsok'on shat bowtsi. ");
INSERT INTO bwo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Dawnmanitsno, «T marat'tso t na'o haniye, bín k'ewere!» etiru k'ááro b́ waa. ");
INSERT INTO bwo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","K'armanwere b́ shisheyahakon Iyesus bíaali wotat b́ daatseyi, b́ danifwotswere bo bek'ts jamo konshor bo kewrawon s'ket be bowts. ");
INSERT INTO bwo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Yatsok'on Iyesusnat b́ danif keezwotsn guri abaatse bo oot'tsok'on ay asho Iyesusi amt gonkbodek'i. ");
INSERT INTO bwo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ash ash dagotse ash iko hank'o ett b́kuh! «Danifono! na'an taash iks'uz b́wottsotse taash n kashiytwok'o neen k'onre, ");
INSERT INTO bwo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Hambe! Kim shayiran gawerawo detsdek't b́ kuhirye, datsats dikdek't úmbo kishifetst b́ s'ik'iyriye, bí atsono gaawit gondo b́ bek'shiyakon b́fakshfoni. ");
INSERT INTO bwo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kim shayiran bo kishitwok'o n danifwotssh keewre b́tesh, ernmó falratsne.» ");
INSERT INTO bwo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iyesuswere hanko bí et «It amaneraw k'uurts s'oot'wotso! awrifetsone itnton t beeti? awrifetsoshe it keewo t k'amiti? aab n na'o hakan de'ewowe.» ");
INSERT INTO bwo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na'onwere Iyesus maants b́ t'intsok'on fo'erawo datsats dikdek't b́ s'ik'i, Iyesusmó kim shayirman hadat, na'onowere kashidek't b́ nihsh imb́k'ri. ");
INSERT INTO bwo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ash jamonwere Ik'i een ango bobek'tsotse bo adi. Jametsuwots Iyesus b́ k'alts keewmaanatse tuutson adoke bobefere b́ danifwotssh hank'o bíeti, ");
INSERT INTO bwo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Itsh tkeewiru keewan nibn de t'iwintsde'ere! Hambe, Ash Na'o ashuwotssh beshide imetwe.» ");
INSERT INTO bwo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Boomó keewman t'iwintsde'atsno, b́keewirmanwere boosh aashgutsatni b́tesh, bín aatoshowere shat bowtsi. ");
INSERT INTO bwo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","B́ danifwots «No únetsitse bogo kone?» ett moosho tuuz bok'ri. ");
INSERT INTO bwo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iyesusmó bo nibotse bo gawirwo dank'rat na'i marmat' iko dek' waat b́ ganok need'i b́k'ri, ");
INSERT INTO bwo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Bíwere «Na'i marmat'han taasha err dek'etwo taane b́ dek'iy, taan dek'ts jamonwere taan woshtsonye bo dek'iye. Ititse it jametswotsitse dashtso bí jamoniyere bogee b́ wotitye,» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Maniye hakon Yohans Iyesussh, «Danifono, ash iko n shútson fo'erawo b́ kishfere nobek'i, ernmó noonton b́woterawotse bazi nok'ri,» bíet. ");
INSERT INTO bwo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Iyesuswere «Iti k'eferaw jamo it maants b́wottsotse k'ayere, bazik'ayere!» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Iyesusi daromadan b́ keshet aawo t'infere b́ waatsok'on Iyerusalem maants amoosh k'ut'dek't b́ tuwi. ");
INSERT INTO bwo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Bíyere shin shino amet woshetawotsi woshb́k'ri, boowere jam keewo k'aniyosh Semaritse daatsets gal iku maants bo ami. ");
INSERT INTO bwo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ernmó bí mann beshar Iyerusalemi bí'ametuwok'o bo dantsotse gal manitsi ashuwots bín dek'o geratsno bo tesh. ");
INSERT INTO bwo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","B́danifuwots Yak'obnat Yohansn man bo bek'tsok'on, «Doonzono! darotse tawo ood'r ashaanotsi mits b́ bazetwok'o no k'alish eekineya?» bo et. ");
INSERT INTO bwo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Iyesusmó bo maants wongr ett aanat boon b́ hadi. It aaw naari shayirokik it wottsok'o danatste, ash na'o b́awa ash kash worya bako, t'afiyaliye. ");
INSERT INTO bwo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Manoknowere tuut k'osh gaalo maants k'az bo ami. ");
INSERT INTO bwo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Iyesusnat b́ danifwots weerindatse bo sha'efere ash iko Iyesussh «Taa ni'amiru jamok n shuutso shoyde'er amoosh geefe,» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iyesuswere «Waangwots gop'o detsfne, daritsi kafwotswere kúto detsfne, ashna'onmó dab b́ tooku bits b́ gedetwok wotts bewoku deshatse,» ett bísh bíaaniy. ");
INSERT INTO bwo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","K'osh ashosho, «T shuutso wowe» bí et. Ashmanmó «T doonzo! shino amr t nihi duh tdek'ish taash eekowe,» bi et. ");
INSERT INTO bwo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Iyesuswere «K'irtswotsi k'ayk'rowe, k'irts bokuwotsi duhde'enee, nemon amr Ik'i mengsti jango daniwe!» ett bí aaniyi. ");
INSERT INTO bwo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Maniye il k'osh ash iko «Doonzono, taa neenton sha'o geefe, wotowa bako shino amr t meyitsi ashuwotsi jamir t weetwok'o taash eekowe,» bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iyesuswere «Goshosh hordo kishon deshde'er shuutso maants s'iliru asho Ik'i mengstosh wotitkaliye,» et bíaanyi. ");
INSERT INTO bwo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Maniyere okoon doonzo, shabe git ashuwotsi galbdek'i, bí amoosh b́gawts kitonat beyok jamok shin shino bo ametuwok'o git gito woshdek't b́woshi. ");
INSERT INTO bwo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Hank'o boosh bíeti, «Hamb, kakwet mááyo aye, mááy kakuwi fintswotsmo kos'nee, mansh mááy katso doonz mááy kakwitwotsi mááyko'iyosh b́woshitwok'o k'onwere. ");
INSERT INTO bwo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Eshe ameree, hamb, mereerikok'o iti elahi dagots twoshiri, ");
INSERT INTO bwo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","It werindosh eegor deshdek'k'ayere, gizi borsonor, k'arc'itonor, c'amonor b́ wotiyal deshdek'o k'ayere, ashonton jam aateyoke weerindatse need'ar aawo ili k'ayere. ");
INSERT INTO bwo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","It kindts maa jamotse shin shino ‹Jeeno mansh wotowe,› erere, ");
INSERT INTO bwo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Jeen shunts asho maa manitse fa'e wotiyal it jeeno bísh bodetwe, maniyalbako it jeeno it maants k'ay aanitwe. ");
INSERT INTO bwo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Finiru ashosh damozo bísh geyife, mansha it kindts mootse itsh t'íntsetso mafetsr uyfetsr beewere, ik mootse keer k'osh moots gúúŕ k'ayere. ");
INSERT INTO bwo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Aaknor wotowa kitots it kindor ashuwots itn bo dek'or itsh bo t'intstso moore. ");
INSERT INTO bwo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Kit manitsi daatset shodetswotsnowere kashiwore, ash jamoosho were, ‹Ik'i mengstu it maantsan t'inraniye,› err keewwere. ");
INSERT INTO bwo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ernmó kit aawitsor it kindor ash ashuwots itn dek'o bok'azetka wotiyal kit man jebats keder boosh hank'o erere, ");
INSERT INTO bwo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Hambe, dab notufatse fa'a it kitutsi k'undo itsh tebk'rirwone, ernmó Ik'i mengsto it maants b́ t'intsok'o dan de'ere.› ");
INSERT INTO bwo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Angshi aawots kit maniyere Sedom kituats weet fayo ketefe etirwe itsha.» ");
INSERT INTO bwo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Manats dabt Iyesus hank'owo bíet, «Indowe neesha Korazine! indowe neena Betesayido! ititse finets aditswots, T'irositsnat Sidoniytse finere wotink'e manoke fa'a ashuwots shiyani taho tahde'er tuulats bede, naandrone etank'ne. ");
INSERT INTO bwo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Manshe angshi aawots itiyere T'irosnat Sidonats fayet fayo ketefee. ");
INSERT INTO bwo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Neewere K'frnahome, darots n borfetso dambaan tuwo geefneyá? Beree si'olits oot'etune.» ");
INSERT INTO bwo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Aaninwere Iyesus b́ danifwotssh, «Iti k'ebetwoniye taano k'ebetwe, itsh k'aztso taano k'azre, taan k'aztso taan woshtsoniye b́ k'aziri,» bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Shabe git wosheets b́danifwots boon woshetsoke aydek't gene'uwat bo aani, Iyesusokowere t'int́, «Doonzono! n shúútson dab Fo'erawwots noosh alernee» bo et. ");
INSERT INTO bwo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Iyesuswere boosh hank'owo bíet, «Shed'ano darotse guumok'o shap'eyat b́ fed'efere bek're, ");
INSERT INTO bwo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Eshe hamb! dawuzonat ok'olshon it net'etwok'o, balangari ang jamo it da'itwok'o itsh alo imre, itats gondo bets falitwo ik jago aaliye. ");
INSERT INTO bwo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ernomó it shútso darotsi mezgebíyats guut'etsosh gene'ore bako Fo'erawo itsh b́ aletsosh gene'úk'ayere.» ");
INSERT INTO bwo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Manór Iyesus S'ayn shayiron gene'uwat hank'o bí et, «Daronat datsonsh doonz wotts Nihono! keewhan s'ekwotsnat dantswotssh aatsat danawwotssh nkitstsotse neen údere, ee, Nihono! han k'alo n shuno wotere. ");
INSERT INTO bwo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«Jam keewo t nihoke taash imere, naayo koni b́woto nihoniyere okoon konwor dantso aaliye, mank'owa niho koni b́ woto naayo niye okoon wee naayo kitsosh b́ geyirw ashoniye okoon k'osho konwor danetwo aaliye.» ");
INSERT INTO bwo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Maniye okoon Iyesus b́ danifwots maants wongr ett aanat bo aalsh hank'o bí eti, «It it bek'irwan bek'irowots derekne. ");
INSERT INTO bwo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Arikon ay nebiyiwotsnat naashwotsn it bek'irwan bek'osh tewntni bo teshi, ernmó be'aatsno, it k'ebirwanor k'ebosh tewntniye botesh, ernmó shiyatsne.» ");
INSERT INTO bwo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ik aaw Muse nemo daniyf iko Iyesusok b́weyi, bín fadosh geeyat «Danifono! dúre dúri kasho daatsosh eeg k'alo taash geyfa?» ett bíaati. ");
INSERT INTO bwo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Iyesuswere «Nemotse guut'etso eebi? n nababor bítse aak'owe n t'iwintsi?» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ashmanwere «Nemonmo ‹Doonzo Izar Izewernehe n maac'i s'eenon, n kashok'o, ni ang s'eenon, n nib s'eenon, shune,› ando mank'owa k'osh asho n tokok'o wosh de'er shune» etfe bí et. ");
INSERT INTO bwo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iyesuswere «Arikon aniyirne, eshe nee man k'aluwe! dúre dúri kashone daatsitune» bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Muse nemo daniyfonmó b́ tooko kááw asho woshosh geyat́, «Wotowa eré t mashmó kone bí?» ett bíaati. ");
INSERT INTO bwo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iyesuswere hank'o ett bísh bíaaniy, «Ash iko Iyerusalemitse kesht Iyariko maants oot't bí'amfere weerindatse bik'fwots daatsdek't b́ taho bí'atse kishdek't, jot' isht k'irosh kasho b́ k'as'fere juuk'rat k'az boami. ");
INSERT INTO bwo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kahhini iko dingatoń werind mann bí'amfera b́ teshi, jot' dek't juuk'rets ashman b́ bek'tsok'on eegor bísh b́k'alrawon ashman nad't k'azbiami. ");
INSERT INTO bwo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mank'o Lewawiyo werindmann b́ beshefera b́tesh, bíwere ashman b́ bek'tsok'on eegor bísh b́ k'alrawon k'osh werindon beshat k'azbí'am. ");
INSERT INTO bwo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Semriya eteets dats ashonmó man weeron b́ beshefere ashman maants wáát, bín b́ bek'tsok'on bísh maac'o b́ k'ewi, ");
INSERT INTO bwo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","B́maand t'int zeyitonat weyiniwon dutsets biro b́ gaawmanats b́ kuut'i, tahonowere bíats s'as'dek't tipb́k'ri, maniye il b́ took dazats bezdek't ib ibuwots k'eef mook dek' bíami, manoknowere sheengshdek't b́ duguní. ");
INSERT INTO bwo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Yatsok'on git dinariwotsi kishdek't ibi k'ey maa man doonzsh imt ‹Ashaan sheengshde dugunowe, k'osh gizo nkishiyalowere ti aanor neesh dashetwe,› bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","«Eshe, keez ashaanotsitse, biik'tswotsn togeyat dihts ashmansh b́ mashi bísh wottso aawi arefa neesha?» ");
INSERT INTO bwo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Muse nemo daiyfonwere, «Bísh maac' k'ewat bín tep'tsmaniye,» ett bí'aaniy. Iyesuswere «Eshe amee, neewor mank'o k'alwe!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Iyesus b́ danifwotsnton weerindo amfetst gál ikuts bodb́wtsi, manokno Martay eteets mááts iku bgal s'eegbdek'i, ");
INSERT INTO bwo_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Biwere Mariyami eteets mishu detsfa btesh, Mariyami eteetsman Iyesus tufi shirots bedek'at b́ danirw dano bk'ebiri. ");
INSERT INTO bwo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martamó mish k'ac'on aydek't bmawufera btesh, mansh Iyesus maants t'iinat, «Doonzono! t mishhan fin jamo tiats k'azbk'rere bek'fetsat s'k niet eegishe? Oona neesha taash b dabitwok'o bish keewwe!» bi'eti. ");
INSERT INTO bwo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Doonzo Iyesusmó hank'o ett bish bí'aaniy, «Marta Martaye, nee ay keewone n kic'iri, ay keewonowere gondo nbek'iri, ");
INSERT INTO bwo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ernmó geytwoniye ik s'uzee, Mariyamwere k'ants keewo galdek'raniye, bínowere biyatse konwor k'a'udek'etwo aaliye.» ");
INSERT INTO bwo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ik aaw Iyesus beyok ikoke Ik'o b́ k'onfere b́tesh, Ik' k'ononowere b́ ishtsok'on b́ danifwotsitse iko, «Doonzono! Yohans b́ danifwotssh Ik' k'ono b́ danitsok'o neewor Ik'o k'ono noosh daniwe!» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Iyesuswere, «Ik'o itk'onor hank'o erere bí'et, ‹Darotse beyiruwo no Nihono! Nshútso S'aynee! N mengstu wowiye! ");
INSERT INTO bwo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Aaw aawon noosh nomeet misho ime! ");
INSERT INTO bwo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Noon dadtswotssh oorowe noettsok'o, No morro noosh orowa eree, Fadeyotsowere noon kindshk'aye› gondatse noon oriwe bakona.» ");
INSERT INTO bwo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Manats dabt Iyesus b́ danifwotssh hank'owa bí'eti, «Aab ititse b́ shunts tooh detstso fa'e erone, b́ toohman t'ú talititson b́ toohman galok amr, ‹T masho, oona neesha keez misho taash gushiwe, ");
INSERT INTO bwo_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","T mash ikoniye wokdatson weeron waat b́ eree t t'intsituu misho tt'ut'i!› bí etal ");
INSERT INTO bwo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Eshe, b́ mootse bede'er, ‹Oona neesha taan kic'ik'aye! fengesho is'k'reke, t nana'uwotswere taantoniye es'atse bok'eyiri, manshe tuur n geyiru misho neeash imosh falratse,› etetwá? ");
INSERT INTO bwo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","B́ mashi b́ wottsosh dab tuur imo b́k'azalor b́ kasho b́ k'uushirwosha err bísh geyits jamo tuurni b́ imetiye etirwe itsha. ");
INSERT INTO bwo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Manshe taawor itsh t keewirwo haniye, k'onwere itsh imetwe, maa fengesho k'ofore itsh k'eshetwe, ");
INSERT INTO bwo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","K'onitw jamo dek'etwe, geyirwonwere daatsitwe, fengesho k'ofirwosho k'eshetwe. ");
INSERT INTO bwo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ititsnmó nih wotefetst, b́ na'o tusho b́ k'onor shúts imetuwo kone? Mus'o b́ k'oniyal mus'i shegro dawnzo imetwá? ");
INSERT INTO bwo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Himó keetso b́ k'oniyal ok'olsho imetwa? ");
INSERT INTO bwo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","It gondwotsi wotefetsat it na'osh sheeng keewo imo it daniyakon, darotse fa'o itnihmó bíyoke k'onirwotssh S'ayin shayiro bogshde aak'owe imob́k'azeti!» ");
INSERT INTO bwo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ik aaw Iyesus noon keewo faliraw fo'erawo gidik' ash iko atsotse b́ kishfera b́ tesh, Fo'rawonwere b́ keshtsok'on gdik'o noon keewo dek't b́ tuwi, ash ashonwere keewhanatse tuutso ayi dek't bo adi. ");
INSERT INTO bwo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ik ikuwotsmó, «Fo'erawo b́kishiriye Fo'erawi naash wottso Beel Zebulnee,» bo eti. ");
INSERT INTO bwo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","K'oshwotswere bín fadbek'o geyat́ darotse milikit iko boosh b́ kitsitwok'o bo aati. ");
INSERT INTO bwo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Iyesusmó bo gitsotse bo gawirwo dank'rat boosh hank'o bíet, «Ik mengsto hake bak kayeyar bí'atsatsewo b́k'aleyetka wotiyal, mengstman t'afa b́t'afiti, mank'o ik maá asho bí atsatsewo b́ k'aleyal dihe b́dihiti. ");
INSERT INTO bwo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mansha shed'ano bí atsatseyo b́ k'aletka wotiyal b́ mengsto ak'ok'alrniya kup'ar need'o b́ faliti? Itiyere ‹Bíhe Fo'erawo b́kishiriye Beelzebulne,› etfte taasha. ");
INSERT INTO bwo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Taa bére, Fo'erawo t kishir Belzebulna wotiyal it nana'úwots bokishir konneya? Manshe it took nana'o dab itats angshitúne. ");
INSERT INTO bwo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Eshe Fo'erawo tkishir taa Ik'i angona wotiyalmó Ik'i mengstu itmaants bwatsok'o dande'ere. ");
INSERT INTO bwo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Ash kup' iko t'eesho deshde'er b́ moo b́ kotetka wotiyal b́ gizo sheengshde kotetwe, ");
INSERT INTO bwo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ernmó bíyere bog asho wáár bín da'abdek'al detsfe bí etts kes'i gino bíatse k'aa'úni b́dek'eti, b́ giz jamonowere bi' de'er kayini b́k'riti. ");
INSERT INTO bwo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«T maants woteraw jamó taana b́ k'efiti, tiyok kakuraw jamo bad'iye b́ bad'iyiri. ");
INSERT INTO bwo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Kim shayiro ashotse b́ keshor b́ k'ot'okoo geyoke aats aalok dats shuk' jamok b́ guriti, b́ k'ot'it beyoko b́ t'ut'almó ‹T keshts moots aanar amna› bíeteti. ");
INSERT INTO bwo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aanar b́ waáfere s'ayintsdek't k'aniyetso datsb́dek'eti. ");
INSERT INTO bwo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Maniyere il amr biyere gondwotsi k'osh Fo'eraw shawatwotsi de'er b́ weeti, bali biitse b́ beef mootse kind de b́ beeti, ash man il b́wotitwo shintsoniyere iki gonde b́ wotiti.» ");
INSERT INTO bwo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iyesus man keewoke b́befere mááts iku ash ash taalotse b́ k'aaro eenshdek'at «Neen shuwat s'atstsu deerekiye,» bi eti. ");
INSERT INTO bwo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Iyesusmó, «Deretswotsiyere Ik'i aap'tso k'ewde'er finats jitsitwotsiye,» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ay asho b́maand waat bo kakwetsok'on Iyesus hank'owa ett b́keewu, «S'oot'ahan gonde, milikit bek'e bogeyiri, ernmó nebiyo Yonaskoniye okoon k'osh milikito boosh imeratse. ");
INSERT INTO bwo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nebiyiyo Yonas Nenewe kititsi ashuwotssh milikit wotat b́ teshtsok'o mank'o ash na'o and duranatsi s'oot'osh milikit wotitwe. ");
INSERT INTO bwo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Muur Nugusu angshi aawots and duranatsi s'oot'wotsnton tuur boats angshitwane, bi Selemon dani telefo k'ebosh dats daaratse tuwat waarane, ernmó hambe, Selomoniyere bogo hanoke fa'ee. ");
INSERT INTO bwo_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mank'owoŕe Nenewe kiti ashuwots angshi aawots and duri s'oot'anotsnton tuur angshitwane, Nenewe ashuwots Yonas nabtso boshishtsok'on bo fints morrosh goynatt naandrone etrne, ernmó hambe, Yonasiyere bogo hanoke b́ fa'oni.» ");
INSERT INTO bwo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Manats dabt Iyesus hank'o bí eti, «C'eesho c'eeshde'er dats ashok gedfo, wee oosho bí'ats gúp'shfo konwor aaliye, maniyere dab ashuwotssh máá gitso maants bo kindór b́ shanetwok'o dambaan s'ogatsa bogedfoni. ");
INSERT INTO bwo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ni atsatsi c'eesho ni ááwoniye. Niááwo jeen b́wotiyal niats jamo sháánon s'eenke b́wotiti, ni ááwo shodk b́wotiyalmó ni ats jamo t'aluwotse b́wotiti. ");
INSERT INTO bwo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Manb́wottsosh eshe ni atse fa'a c'eesho t'alu b́woterawok'o niatso korde'e. ");
INSERT INTO bwo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Eshe ni ats jamo bíatse t'aluwo b́ deshawo sháánon s'eentso b́wotiyal, c'eesho ayider golor neesh b́shaanifok'o iki golr sháán wotitwe.» ");
INSERT INTO bwo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iyesus han b́ keewufere ferisawi wotsitse iko aawu misho moowe bí eti, Frisawiwo moots kindt aawu misho moosh mishimarasts t'inbdek'i. ");
INSERT INTO bwo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Iyesus misho b́maftsere shino kisho masho b́k'aztsosh ferisawimań bí adi. ");
INSERT INTO bwo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mansh doonzo Iyesus bísh hank'o bíeti, «It ferisawiwots brc'uk'onat saniy abo s'ayintsatniy it mashiri, it gitsonmó gondonat bík'on ititse s'eengutsi. ");
INSERT INTO bwo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","It dartsuwotso! úratstso azts Ik'o gitsitstsonmó azratsa? ");
INSERT INTO bwo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","It brc'k'onat it s'awotse fa'o t'owwotssh imere maniye hakon it keewu jamo s'ayino itsh wotituwe. ");
INSERT INTO bwo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«It ferisawiwotso indowe itsha! ik weeron ak'arshudona, c'ilatamikonat ay k'ac'n maay naruwotsatse tatslo kishirute, k'osh weerono ariko angshonat Ik'i shunonowere k'az it k'riri, ekeewi it k'alor hanowere k'azo itsh geyiratse b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«It ferisawi etetsanots indowe itna, Ayhudi Ik' k'oni mootse beyoki sheengats beyo shunfte, mankoo jebonat gawiyotse ashjamo itn jamo bíatituwok'o it geyiri. ");
INSERT INTO bwo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ash ashuwots bo danawo bíabatse boshaíru doowo it artsotse indowe itsha!» ");
INSERT INTO bwo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Muse nemo danifuwtsitse iko Iyesussh, «Danifono, han eto nonor c'ashrne etee!» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Iyesuswere hank'o bíet, «Indowe itsha, it nemo danifuwotssha! ashaats kurimango it kurfoni, itmó kurman dab it kishi jabon t'awiratste. ");
INSERT INTO bwo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","«It nihots bo úd'ts nebiyiwots doowo it sheengsh dek'at it doziruwotse, indowe itna! ");
INSERT INTO bwo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Eshe it nihots bo úd'ts nebiyiwotssh bo doowo it finiruwotse itwere bo gond fino tep'iruwotsnat gawuwots itne. ");
INSERT INTO bwo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Manatse tuutson Ik'i dan telefu hank'o etfane, ‹Nebiyiwotsnat woshetswotsi bo maants woshituwe, ik ikuwotsi úd'itúne, ortsuwotsno gondo bek'shitunee, ");
INSERT INTO bwo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Datso bí'azeron tuut kud'ts nebiywotś s'atso, and dúranatsi s'oot'anots angshon aatetúne.› ");
INSERT INTO bwo_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ariko itsh keewna, Abeelatse tuut wosh t'intseyiru t'arap'ezonat Ik' maa taalotse úd'etso Zekariyaskok b́ borfetso kud'ts s'atsosh and dúrantsi s'oot'anots aatetúne. ");
INSERT INTO bwo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«It nemo danifuwots indowe itsha! Dani fengesho bín k'eshet k'ulfiwo it kishatse detsfte, ernmó it it tookosh bíts kindratste, kind geyiruwotsno bo kindrawok'owa it baziri.» ");
INSERT INTO bwo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Iyesus manoke k'ay amoosh b́tuutsok'on nemo danifuwotsnat feriswiwotsn b́keewo k'efat ando ay aato t'intso dek't botuwi. ");
INSERT INTO bwo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Hań bo k'alirwe b́keewiru keewon bín detsosh geyatni boteshi. ");
INSERT INTO bwo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Manoor ay kumon tawet ash ashuwots kakuwe bowutsi, bo aytsatse tuwtsotson bo atsatsewo gifinefetst bo net'eyiri, Iyesus shini b́ danifuwotssh hank'o eto dek't b́tuu. «Ferisawiwots boot' shashatse etonmó bokok'o git alberetsi wotatse it aatso korde'er. ");
INSERT INTO bwo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ipets keewo wogerawo oreratse, aatsetsonúwere danerawon oreratse. ");
INSERT INTO bwo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Eshe t'aluwotse it keewts jamo shanatse shishetuwe, is'eets mootse shashkon it keewtso jebatse sháánon keewetuwe. ");
INSERT INTO bwo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Itsh tmashootssh hank'o etiruwe, meets mec'ro úd'oniyere oko k'osho eegor k'alosh falrawuwotsi shatk'ayere, ");
INSERT INTO bwo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ernmó koni shato itsh b́geyituwok'o itsh keewituwe, manuwere b́ úd'iyehakon gahanemits juwosh falituwo aldetstso Ik'oniye; ee, b́ s'uzi sharere etiruwe itsha! ");
INSERT INTO bwo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«Útś dimbitiwotsi tats santimosh kemefoshna? Boyitse ikunwor dab Ik'i shinatse batekiyaliye. ");
INSERT INTO bwo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Itkonmó it tooki s'ronuwor jamon dab tawekee, mansh shatk'ayere! it ay dibitiwwotsiye bogfte.» ");
INSERT INTO bwo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Manats dabt Iyesus hank'o bí eti, «B́ jitserawo ash shinatse tjangosh gawituwosh ando taawor Ik' melakiwots shinatse b́ jangosh gawituwe. ");
INSERT INTO bwo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ash shinatse taan halituwosh ando taawere Ik'i melaktiwots shinatse bín haalitwe. ");
INSERT INTO bwo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","«Ash Na'o c'ashetuwosh b́ morro bísh orowa etetuwe, S'ayin shayiro c'ashetuwońmó b́ morro bísh orowe eteeratse. ");
INSERT INTO bwo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Ash ashuwots itn Ik' k'oni maa moots bodamor, dats naashuwotsnat datsatse alts ashuwotsn shinats bo t'intsor ‹Eege no'aniytik'úna? Aawuk'o erniya k'úna nokewiti?› Err kic' k'ayere. ");
INSERT INTO bwo_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Keewosh iti geyituwo manoor S'ayin shayro itsh keewituwe.» ");
INSERT INTO bwo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ash ashi dagotse ash iko Iyesussh, «Danifono, nonih noosh jeshuwo b́ imts datso taash b́ kayish oona neesha, ti eshush keewwe» bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Iyesusmó, «Ashono neena, it dagotse angshituwo t wotituwok'onat resity t kayituwo kone taan naashiy?» ett bíaaniy. ");
INSERT INTO bwo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Manats dabt́ jametsuwotssh hank'o bíeti, «Ash kasho b́gizi ayonaliye, manshe it atso korde'er, jaalatsnowere it tooko korde're.» ");
INSERT INTO bwo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Maniye okoon Iyesus ariyetsan hank'o ett b́ keewu, «B́ taaro maayi ay bish b́datsits gaalets ash iko fa'e b́ teshi, ");
INSERT INTO bwo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Bíwere b́ nibotse, ‹Maay jaman bítś t gas'et́woko t deshawotse aak'owe k'una tk'aliti?› ett b́ shiyaniri. ");
INSERT INTO bwo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Hank'o bí et, ‹Hank'owa t k'aliti bí et tt'iwu jamo gaahde k'osh een eenuwotsi agetwe, manits t mayona et, tk'ac' jamo bíts kakudek'etuwe. ");
INSERT INTO bwo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Maniye okoon t tookosh, eshnee, ay natosh neesh bodetuwo ay gaalo fa'ee, eshe kashdefets hid'ee! moowe! úyee! genewuowee! etetuwe› bí et. ");
INSERT INTO bwo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ik'onmó ‹Nee dogono, hambets t'uwanitse n kasho niatsotse k'a'udek'etwe, eshe n kakuts gaal jaman konshe b́ wotiti?› bí et. ");
INSERT INTO bwo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","«B́ tookosh datsatse gaalo kakuwiruwo, Ik'i shinatse tugrets wottso hank'owe b́wotitiye.» ");
INSERT INTO bwo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Maniye hakon Iyesus b́ danifuwotssh hank'o bíeti, «Eshe it kashosh ‹Eege no meeti? Noatsats eege notahiti?› err it beyosh shiyan k'ayere etiruwe. ");
INSERT INTO bwo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mishoniyere kasho, tahoniyere atso bogfe. ");
INSERT INTO bwo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Aak' k'oruwotsi aab s'iilere! bo shohakno, k'ec'akno maay ko'iyet t'iwo wee maay ko'iyetwoko deshakno, b́wotefere, Ik'oni boosh manzir, Itiye kafuwotsiyere ayidek'at bogfte! ");
INSERT INTO bwo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Aab ititse shiyanat b́ beyi dúrats ik aawo dabdek'o falituwo kone? ");
INSERT INTO bwo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Eshe keewi muk'nannor dab k'alosh falrawuwotsi wotefetsat, eegishe k'osh keewosh it kic'iri? ");
INSERT INTO bwo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Shiratsi funduwotsi aak'on bo eniruwok'o aab s'iilere, bo finon mawratsno, jokeraatsno, b́wotefere Solomon dab́ b́ mang jamonton boyitsi ikuk'o sheengts taho taheratse. ");
INSERT INTO bwo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Eshe, Ik'o hambets be'eyar yats taawots juwetuwo shiratsi tootso hank'o sheengsh b́ takitk wotiyal it amanerwanotsó, itnere bogshde'er takiyalkeya! ");
INSERT INTO bwo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mansh ‹Eege nomeeti? Eege nousheti?› err shiyanar k'ic'iftee. ");
INSERT INTO bwo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Hanan datsoshere dastanatsi ash ashuwotswor kic'efno, itmó jaman itsh b́ geyituwok'owo daritstso it Nih danfee. ");
INSERT INTO bwo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Shin shino Ik'i mengsto geyore, jam keewanotsi itsh dabetuwe.» ");
INSERT INTO bwo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«It jir muk'ok'o wottsanotso shatk'ayere, it Nih darotstso mengsto itsh imoshe shunre. ");
INSERT INTO bwo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","It detsts jamo kemde'er t'owwotssh imere, narawu k'arc'ito k'anide'er it gizo ump'etso b́ borawok, k'inonuwere b́marawokonat b́ jamonor b́ s'uwurawokok Ik'i mengstots gerde'ere. ");
INSERT INTO bwo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","It nibo it gizi beyoke b́ wotiti.» ");
INSERT INTO bwo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Manats dabt Iyesus hank'o bí et, «K'awints edde'er finosh jam aawo k'an de'ere, it c'eeshonuwere aat'k wotowe. ");
INSERT INTO bwo_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mank'owon, bo doonz jiwi mooke b́waa kotiruwo guutsuwotsi arore, bo bo doonz danerawo waar maá fengesho b́ togor kaari k'eshosh k'an dek'kne. ");
INSERT INTO bwo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bo doonz gawerawo b́ woor, kup'dek't bokotfere b́daatsit guutsuwots aak'o deereknok'uwa? Arikone itsh t keewiry, bí k'awints edde'er boon mishimarats beezituwe, t'inrnwere boosh manzitwe. ");
INSERT INTO bwo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bodoonz talititson wee talititsoniye okoon b́ wafere botkrerawon kup'ar bín bokotfere b́ daatsitgutsuwots derekne. ");
INSERT INTO bwo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Andoor man dande'ere, moo doonz úmp'etso weet sa'ato b́ danink'e úmp'etso b́ moo iyde'er b́ kindituwok'o k'ayank'e b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mank'o Ash Na'o it gawuraw sa'ton it jalerawo, weetuwe, manshe itwor k'ande'er korere.» ");
INSERT INTO bwo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","P'et'rosuwere «Doonzono! Jewuron nkeewiruwan noalsheya n keewiri? Himo jamosheya?» ett Iyesusi bí at. ");
INSERT INTO bwo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Doonzo Iyesuswere hank'o et bí aaniy, «Eshe b́ maá ashuwotsi shengde'er b́ k'ezituwok'o b́ guutsuwotssh bo misho boosh eteets aawon boosh imetuwok'o b́ doonz b́ manzish naashiyets amanets s'ek guutso kone? ");
INSERT INTO bwo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","B́ doonz bíamtsoke bí'anefere bísh keewetsok'on b́ finefere b́ daatsituwo awuk'o deereke! ");
INSERT INTO bwo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ariko itsh keewiruwe, b́ doonz b́ dets jamatse altso woshde'er naashituwe. ");
INSERT INTO bwo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ernmó gutsman ‹T doonz kaari waratse, teshetwe› err b́ mafere, úyifets, mashefetsr guutsonat gonon jot'o de' b́tuwit. ");
INSERT INTO bwo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ernmó b́ doonz b́koraw aawonat b́gawraw sa'aton weetwe, b́ gutsmanowere ayider fayarr b́tooko kawlr b́ gowonoowere woterawwotsnton b́woshiti. ");
INSERT INTO bwo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«B́ doonz shunts keewo danfetst k'ande'awo, wee b́ doonz finowe bí ettso k'alraw guutso kup' togona b́ togeti. ");
INSERT INTO bwo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ernmó b́ doonz geyiru keewo daron, bíyats dowet keewo finar b́daatseyal bín fayet fayo ketituwe, ay bísh imetsatse ayo bí'atse geetuwe, ay adaro imets ashoke aye bí'atse geeti.» ");
INSERT INTO bwo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Manats dabt Iyesus hank'owa bí et «Hamb! taa datsats taawo dek'at waare, eshe, kaari taash desh b́gutsink'ere aak'owe t gene'uwiyank'oni! ");
INSERT INTO bwo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ernmó taa t gupet gond bek'i gupeyo detsfe, bíwere b́ s'uufetsosh kashde'atse. ");
INSERT INTO bwo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Taa datsats jeeno tdootsok'o arefa itsha? Taayere tdootso k'aleya bako jenaliye etfe itsha. ");
INSERT INTO bwo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Andon tuur ik mootse fa'a úts ashuwots k'aletune, Kezuwots gitetsuwotsats, gituwots kezetsuwotsats bo tuure fayetune. ");
INSERT INTO bwo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Niho naayo aats, naayonuwere nihoats, indu b́ ni'ats, ni'únuwere b indats, aawunuwere b́ naay maátsuats, naayo máátsunuwere bi awats, tuur bo eree bok'aleti.» ");
INSERT INTO bwo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Dabt Iyesus ash ashosh hank'owa bí et «Dawuno aawu kindo maantse itbek'tsok'owon ‹Hambe! hambets awusho butsishe bíetiri!› etetute, arikon butsetuwe. ");
INSERT INTO bwo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mank'o muur maantse jongo b́jongor, ‹Hambets aawo k'es'e b́ wotiti› etetute, arkon wotituwe. ");
INSERT INTO bwo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","It git alberetswotso dari maac'o s'ilat wotituwo danr keewitute, eshe and duranatse wotituwo eegishe it dariri?» ");
INSERT INTO bwo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Maniye hakon Iyesus hank'owa bíet, «Beree it eegishe it it tookon ari keewo dan dek'at angsho it k'azi? ");
INSERT INTO bwo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","N t'alato neen s'aamide angshi mook neen de bíamor weerindatse n t'alatonton ik wotosh kup'owe, maniyalbako bi niats angshituwots shinats getsde'er ametuwe, angshituwotsúwere tipetwotssh beshide'er imetuwe, tiptsmanuwere tipi moots kindshituwe. ");
INSERT INTO bwo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","K'awunts jamó im n ishfetso tip mootse kesho nfalrawok'owo neesh keewiruwe.» ");
INSERT INTO bwo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Manoor ashuwots Iyesusok waat, «Gelil ashuwots woosho bo t'intsfere P'ilat'os boon b́úd'i, bo s'atsonowere wooshoonton ekb́k'ri» ett bokeewu. ");
INSERT INTO bwo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Iyesuswere hank'o ett boosh bíaaniy, «Eshe, Gelil ashmanots keewi gond jamman bo ats b́bod bo Gelil ash jamotse bog morr fintsuwotsi bowottsosh arefa itsha? ");
INSERT INTO bwo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","‹Mank'oyiyaliye, naandre eto itk'azal itwor bokok'o t'afitute› etre itsha. ");
INSERT INTO bwo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Selihom gimbiwo bo ats girshat bíere k'irts tatse shmt ashuwots jango aak'owe itsh bíari? Bo Iyerusalemitse beyiru ash jamwotsiyere bogo morretsuwotsi boteshtsok'o arefa itsha? ");
INSERT INTO bwo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mank'oyiyaliye! naandre eto itk'azal itwoor bokok'owa it t'afiti.» ");
INSERT INTO bwo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Maniye hakon Iyesus jewurets keewan b́keewu, «Ash iko b́ woyini mituwots beyoke tokets belesi mitu fa'aniye btesh, belesiy mitmanatse shuwo daatsituwe ett amt datsraniyere b́ oori. ");
INSERT INTO bwo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Eshe mituwotsi kotiruwosh ‹Hamb, belesi mitanatse shuwo datsifta etaat keez nato ti anaani, ernmó eegor shuwo daatsratse, andowo k'ut'k'rowe! eegishe datso bi awaashiyiri?› bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mituwotsi kotiruwonuwere hank'o ett bíaaniy, ‹Doonzono! aab handransh k'ayk'rowe, b gúro goyde'er dats goofituwo b gúrats gedetuwe, ");
INSERT INTO bwo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Gawish shuwo bímal shengre, mank'o woto b́k'zal bin k'ut'k'rewe.› » ");
INSERT INTO bwo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Iyesus Ik'i aawots ayhudiwots Ik' k'oni maa ikotse b́daniyfera b́tesh, ");
INSERT INTO bwo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Manoknowere tatse shmt naton tuwat kim shayro b jiik'o b́k'urits mááts iku fa'a btesh, jik' k'uur b́wottsotse b́ jamon kááwu dek'ofalratsa. ");
INSERT INTO bwo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Iyesus bin b́ bek'tsok'on s'eegdek't, «Nee máátsane n shodotse kasherne!» bíet. ");
INSERT INTO bwo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","B́ kishonowere biats b́gedi, manoor kawudek'at ned'bgutsi, Ik'onowere b údi. ");
INSERT INTO bwo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Iyesus saambati aawon b́ kashitsotse Ik' k'oni maa naasho fayat ash ashosh, «Ik gawuyotse fin finet shrt aawwots fa'ane, aawanotsn waar kashowere, saambati aawonomó kasho woteratse» ett b́ keewi. ");
INSERT INTO bwo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Doonzo Iyesuswere hank'o ett bísh bíaaniy, «It tooko dambaan detsirwotso, ititse ik iko Ik'i aawon b́ minzi beero k'as'tse kishde'er, wee b́daazo tipotse bishde'er aats b́ úshetuwok damalkeya? ");
INSERT INTO bwo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Eshe, Abraham naar wotts máátsan tatse shmt nat s'eeno shed'anon tipeyat b kic'efere teshrane, bi bere, tipeyat bkic'iru shodanitse Ik'i aawon bítse biisho bish geyiratsa?» ");
INSERT INTO bwo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","B́ keewts keewannó Iyesus bín k'efiruwotsi jitsi b́k'r, ash ashonmó Iyesus b́ fints adits keewu jamon bo geneúwi. ");
INSERT INTO bwo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iyesus hank'owa bíet, «Ik'i mengstu eega biari erono? Himó awunton bin nutsiwuta? ");
INSERT INTO bwo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ash iko b́ taritalots b́ shookts snafic'i aawuniye bíari, bi enat mit wotbgutsi, kafuwotswere b jaabats bo kúto agbodek'í.» ");
INSERT INTO bwo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Iyesus aani hank'o biet, «Ik'i mengstu egontoniya t nutsiti? ");
INSERT INTO bwo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ik'i mengstu, mááts iku boot' jamo b́ shashfetso keez tatsi shel buudots baad'i bk'rts boot' shashituniye biari.» ");
INSERT INTO bwo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Maniye okoon Iyesus Iyerusalem maants amfetst kit kitonat gal galotse daniyfetstni b́ beshefo. ");
INSERT INTO bwo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Manoor ash iko, «Doonzono, kashit ashuwots muk'nowa?» ett bíaat. Iyesus hank'o ett boosh bíaaniy, ");
INSERT INTO bwo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Fengsh t'ebun beshosh kup'ore, fengesh mann kindosh geyiruwots aynee, ernmó kindo faleratsne etiruwe itsha. ");
INSERT INTO bwo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Moo doonz tuur fengesho is'etuwe, itwere úratse bede'er fengesho toofetsr ‹Doonzono! oona neesha noosh k'eshuwe!› eto de'e tuwitute, bíwere ‹Ewukik it wattsok'o danatse!› err itsh bíaniti. ");
INSERT INTO bwo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Manoor it, ‹Nenton towat marone, towat úshrone, no jebatsnowere danirne› it eteti. ");
INSERT INTO bwo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Bíwere aaniy ‹Aawoke it wottsok'o danatse, it gond finets jamanots ti atse wokoore!› bí eteti. ");
INSERT INTO bwo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Abrahami, Yisehak'i, Yak'obi, Nebiyi jamwotsi Ik'i mengstotse bek'etute, itmo úratse juweyar it oror eeponat gash k'asho itats bodetuwe. ");
INSERT INTO bwo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ay ashuwots aaw kindon aaw keshon, gaarnat muurn weetúne, Ik'i mengstotse mishi marats beetúne. ");
INSERT INTO bwo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mann shintswots shuuts shutstswotswere shintsi wotitune.» ");
INSERT INTO bwo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Manoor ferisawiyotsitse ik ikuwots Iyesus maants t'int «Herodis neen úd'osh b́geyiruwotse hanoke keer amee» bo et. ");
INSERT INTO bwo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ernmó Iyesus boosh hank'owa bíet, wangmansh «Amr ‹Hambetsonat yatson fo'erawo kishitwe, shodetswotsi kashitwe, keezl aawonowere t fino ishitwe› etfe err keewwere. ");
INSERT INTO bwo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Wotowa eree hambetsonat yatson, sharto t weerindo Iyerusalem maants amo taash geyife, nebiyiyo Iyerusalemiye okoon k'osh beyoke k'iro bísh geyiratse. ");
INSERT INTO bwo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Iyerusalem! Iyerusaleme! nee nebiyiwotsi úd'irune, n maants wosheets wosh na'úwotsi shútson togirwune, baaku b na'o b gop'shots bkakufok'o, taawere ambtsoto n nana'o kakwo t geyi! ernmó neenat niashwots k'azfone etrte. ");
INSERT INTO bwo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mansh it moo bashone b́ ooriti, arikone itsh tkeewirye, ‹Doonzo shútson wetuwo deereke› it etfetsosh b́ jamon taan be'atste.» ");
INSERT INTO bwo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sanbati aawots, Iyesus ferisawino eteefuwots naashowutsitsi iko gale aawu mish moosh b́kindi, ferisawiwotsuwere b́k'alituwo s'iilosha bo kotiri botesh. ");
INSERT INTO bwo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Manoor shodatse tuutson bíats jamo gaapwutsts ash iko Iyesus shinatse fa'e b́tesh. ");
INSERT INTO bwo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iyesuswere Muse nemo danifuwotsnat ferisawino etefuwotsnsh «Sanbati aawots kashiyo nemotse fa'a?» ett bíaat. ");
INSERT INTO bwo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Boomó eegor boanirawo s'k et bowuts, Iyesus shodts ashman detsdek't kashik'rat daami b́k'r. ");
INSERT INTO bwo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Maniye hakon Iyesus, «Ititse sanbati aawots b́ na'o wee b́ minz beero gop'ots b́ fed'iyal manoor kishrawo kone?» ett boon bíaati. ");
INSERT INTO bwo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bo moó egoer aaniyosh falratsno. ");
INSERT INTO bwo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Iyesus jiwosh s'eegets ash ashuwots mang beyoko desh dek'osh bo bi'efere b́ bek'i, mansh hank'o ariy dek't boosh b́ keewu, ");
INSERT INTO bwo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Asho neen jiwo b́ s'eegor beyoki mangok beek'aye, danerake neyere bogo mang asho jiwok s'eegetso beyosh falituwe, ");
INSERT INTO bwo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Eshe it únetsi s'eegts asho n maants wáár, ‹Beyokan ashaansh fakshuwe› bí eteti, manoor ayide'er jitsefetsr dashani bewokok ood'r nbeti. ");
INSERT INTO bwo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ernmó jiwok n s'eegeyor dashani beyok beewe, mann neen s'eegts asho nmand waar, ‹T mashono! dambanok waa beewe› bí eteet, manoor s'eegets jamwots shinatse mango daatsitune. ");
INSERT INTO bwo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","B́ tooko dambaan detsetu jamo dashan anituwe, b́ tooko dash detsetu jamonmó danmban tuwitwe.» ");
INSERT INTO bwo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Iyesus jiwu s'eegts ash mansh hank'owa bíet, «Aawu misho wee kooc' misho manzosh nietor bo táron gusho bo anituwok'owa err n jirwotsi, n eshuwotsi, n jaguwotsi, gaalets wotts n giyuwotsi s'egk'aye, ");
INSERT INTO bwo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ernmó jiwo maanzo n geyor t'owwotsi, bo atso k'ut'tswotsi, duruwotsi, dog wotts ashuwotsi s'ee. ");
INSERT INTO bwo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Hank'o nk'alitka wotiyal, bo neesh gush aaniyo bofalrawotse nee derek wotitune. Kááwwots k'irotse botuworowere Ik'o neesh aaniytuwe.» ");
INSERT INTO bwo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mishi maratse bedek't teshtswotsitse iko Iyesus keewutso shisht, «Ik'i mengstotse mishi marats beyo falituwo awuk'o deereke!» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Iyesusmo hank'owa bísh bíet, «Ash iko kooc'ish mishi eeno k'aniyik'rat, ay asho b́s'eegi, ");
INSERT INTO bwo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Jiwi sa'atonwere b́bodtsok'on, ‹Hamb, ún keewo k'anb́wutstsotse jiwo maants woore!› err b́keewish moonat úshon doonz b́ guutso s'eeget ashuwotsok b́ wosh. ");
INSERT INTO bwo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ernmó s'eegets ash asho ik ikon moonat úshok waá k'azosh weebo t'intso dek'btuu, iko ‹Datso tkeewtsotse amr s'iilo taash geyife, manshe woo t falawotse tiats irk'aye› bí et. ");
INSERT INTO bwo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","K'oshonwere ‹Úts s'ind minz beruwotsi t kewutsotse boon amr bogosh gosho fadbek'o taansh geyife, manshe woo t falwotse ti'ats irk'aye› bí et. ");
INSERT INTO bwo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","K'oshonwere ‹Máátso dek'at guuy twottsotse woo falratse› bí et. ");
INSERT INTO bwo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","B́ guutsonwere gál k'az aanat jamman b́ doonzsh b́keewu, moo doonzwere fayat b́ guutsosh ‹Káári kitomaand amr kititsi weeronat weeri kati kayuwotsats amr, t'owwotsi, bo atso k'ut'wotsi, ááwu dogwotsi, shokliru duruwotsi, s'eede'er wowe› bí et. ");
INSERT INTO bwo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Guutsonwere aani waat b́ doonzsh, ‹T doonzo! hambe, taash finowe ni etts jamo fink'rere, ernmó ash beyokon andoor senafa'e› bíet. ");
INSERT INTO bwo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mann moo doonz b́ guutsosh hank'o bíet, ‹Tmoo b́ s'eenish gat'ariyo maants amiru weerinduwotsnat weeri kayiwotsats amr k'oshuwotsi s'eede bowetuwok'o woshuwe! ");
INSERT INTO bwo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Bali shino s'egetsmanotsitse ikonuwor t moonat úsho nonots geeratsne!› etfe, etiruwe» itsha. ");
INSERT INTO bwo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ay asho Iyesusnton bo amfera botesh, bíwere bo maants wongr ett boosh hank'o bíet, ");
INSERT INTO bwo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«T maants weetu jamo bí indnat b́ nihn, b́ máátsunat b́ na'on, b́ mishnat b́ eshuwotsn, b́ took kashonor b́wotiyal taayere bogshde'er shunetk b́ wotiyal t danifo woto falratse. ");
INSERT INTO bwo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","B́ took mask'aliyo kurde'er t shuuts sha'erawo, t danifo woto falratse. ");
INSERT INTO bwo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ititse aab kone? B́ Gimbi maa agosh b́geyor finman bín b́finet gizo ambtso b́ geyituwok'o shino bede tanerawo iko fa'oni? ");
INSERT INTO bwo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Dashe ago de'er b́ damfere isho b́mawure moo aaisho b́mawor ag isho maawets maá man bek'tsuwots bíats miis'etúnee, ");
INSERT INTO bwo_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‹Hambe, ashaan maa ago dek' tuut, isho mawure› err bomis'eti. ");
INSERT INTO bwo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Tats kúm kes'tsuwotsi detsts naash iko hiy kúm kes'tsuwotsi dek't bíats weyiru k'osh naashonton kaarosh b́geyiyal shino bín kes' weyiruman kes'o b́falitwok'o danosh bede'rni b́ shiyeti. ");
INSERT INTO bwo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","B́ mawitka wotiyalmó bín kes'o weyiru naashmań wokoon b́ befere manosh wosh nana'uwotsi b́ maants woshar mano bí aatiti. ");
INSERT INTO bwo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mank'owa ititse b́detstso t jangosh ett k'azk'rerawo t danifo wotosh falratse.» ");
INSERT INTO bwo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Manats dabt Iyesus hank'owa bíet, «Beero sheeng, beronmó b́shaawo b́ t'ut'al aak'o k'alrniya shaawo b́ faliti? ");
INSERT INTO bwo_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Han naari beero goshi daatsosh wotowá dats goofiwosh b́ woterawotse manoor kishde'er juwni k'reti, shiy waaz detstso shiye!» ");
INSERT INTO bwo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","T'ilish koiruwotsnat morrets jamwotsn b́ daniyman shishosh Iyesusok waatni botesh. ");
INSERT INTO bwo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ferisawiwotsnat Muse nemo danifuwotsn man bek't «Hanuwo morretsúwotsi b́ t'itsiri, bontonu ikoke b́ meyiri» ett Iyesus ats bo mumundi. ");
INSERT INTO bwo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mansh Iyesus ariyets keewuman hank'o ett boosh b́ keewi. ");
INSERT INTO bwo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Ititse bal mereer detstso baluwotsitse ik mereero b́ shirotse b́t'afiyal bal bodosh ik shapo bodootse k'ay k'raŕ t'aftsman b́ datsfetso gee amawo kone? ");
INSERT INTO bwo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Daats b́dek'oro gene'úwefetsr b́mangrats kurde'er aani b́weti. ");
INSERT INTO bwo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","B́mook waa b́bodtsok'on b́ jaguwotsnat b́ giyuwotsn iknon s'ede'er ‹T mereer t'aftso daats t dek'tsotse geneúwere itwere geneúwore!› etetuwe. ");
INSERT INTO bwo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Naandre eto boosh geyiraw balosh ik shap ash shengwotsiyere naandre etetu moorrfints ash iko jangosh darotse gene'úwo wotituwe etiruwe.» ");
INSERT INTO bwo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Manats dabt Iyesus hank'owa bíet, «Tats ambari santimuwotsi detsts máátsu tats santim manotsitse iku b́shirotse bt'afiyal c'eesho c'eeshde'er, b́ moo fohde b́ shirotse t'afts santimu b́datsfetso kup'sh de geyiyalkneya? ");
INSERT INTO bwo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Datsbdek'tsok'on b shuntswotsnat b giyotsi ikn s'eede'er ‹T'afts t santimu dats t dek'tsosh geneúwere, gene'ore!› etee tuwaniye. ");
INSERT INTO bwo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Naandre etet́ moorrets ash iko jangosh darotse Ik'o melakiwotsoke mank'o geneúwo wotituwe etiruwe itsha.» ");
INSERT INTO bwo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Manats dabt Iyesus hank'owa bíet, «Ash iko git nanauwotsi detsfe b́tesh, ");
INSERT INTO bwo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Muk'efo b́ nihsh ‹Tniho, n gaalotse kayide'er t bano taash ime› bí et. Mann niho b́gaalo b́ nana' gituwotssh kayibk'r. ");
INSERT INTO bwo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Muk' aawoniye okoon muk'efo b́ gizo ko'idek't wok datso k'azbimi, dats manatsnowere b́ giz jamo dats mec'ron bad'i b́k'ri. ");
INSERT INTO bwo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","B́giz jamono ishb́bazihakon datsmanatse kup' wotts k'ak'o b́kindtsotse kic'ats dihbutsi. ");
INSERT INTO bwo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Mansh datsmanatsi ashuwotsitse ikok t'iin b́ de'e ashmanwere gúrits jinosh bín gedb́dek'i. ");
INSERT INTO bwo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Gúritswots bomeyiruwatse k'oro maar bín b́ maac'o s'entsdek'osh b́tewunfo b́teshi, ernmó manoor bish imetuwo aali. ");
INSERT INTO bwo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Manoor na'man dartsi b́ woto t'iwintsdek't hank'o bíet, ‹T nih gale keeweyat finiru guutsuwots misho boworfetsosh maarr booe're orefuwots ambtsno! taa eshe hanoke k'ak'one t k'iriri, ");
INSERT INTO bwo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tuur t nihok amŕ, tnih ababo, Ik'onat neen shinatse naandre, ");
INSERT INTO bwo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Haniye hakon n naayi err segeyosh boratse, ernmó guutsuwotsitsi ikok'o taash k'aluwe erna.› ");
INSERT INTO bwo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Mansh tuut niho maants bíami. B́nihuwere wokoon b́befere b́ naayi bek'b́k'ri, maac'o k'ewatnuwere b́maants b́wos'i matdek'tnuwere b́ joobi. ");
INSERT INTO bwo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Na'onuwere, ‹T nih ababo, Ik'onat nshinatse naandre, haniye hakon nnaayi eteyar segeyosh bodk taanaliye› bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","B́nihmó b́ guutsuwotsi s'eegdek't hank'o bíeti, ‹Káári amr jamotse k'ants taho de'ewaar bísh takuwere! b́ jabotso k'ubelo, b́ tufotso c'aamo gerere! ");
INSERT INTO bwo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","K'otsts minz úro de'ewar shuhere! móóne! gene'one! ");
INSERT INTO bwo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","T naayhań k'irtniye b́teshi, hamb́ and kashon fa'ee, t'aftniye b́teshi, daatsere› geneonowere dek'et bo tuwi. ");
INSERT INTO bwo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Manoor na'a eenfo tarots amtni b́tesh, aanat b́waafere mook b́t'intsok'on duubonat k'afi k'aro shish b́k'ri, ");
INSERT INTO bwo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","B́guutsuwotsitsi iko s'eegdek't Eebi b́naroni? Ett bíaati. ");
INSERT INTO bwo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","B́ guutsonuwere ‹Ni eshuye aanat b́ watsotsne, nnih jeenon b́ datstsosh k'otsts minz wúro bísh b́shuki› bí et. ");
INSERT INTO bwo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«Eshu eenonuwere ay dek't fayat, ‹Moots kindratse› bí eti. Mansh niho úratse kesht b́kindituwok'o b́ k'oni, ");
INSERT INTO bwo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","B́naymo nihosh hank'o ett bíaaniy, ‹Hamb ambts dúrosh neesh finere, ni'aalotse hank'o borawu shapi danaktane, ernmo taa ttohuwotsnton bín t geneúwituwok'o eyish buk'ul iko dab im danakne! ");
INSERT INTO bwo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","N na'anmó n gizo Woteraw máátsuwotsnton bad'ik'rat bíaanor k'otsts minzi úro bísh nshuki.› ");
INSERT INTO bwo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","B́ nihwere hank'wa bíet, ‹T naayo, neye úni aawo taantoniye n fa'oniye, t detsts jamoniye nike. ");
INSERT INTO bwo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nieshu hanmo k'irtni b́ teshi, and aaniy kashon b́ daatseyi, t'aft b́ teshtsotse, and daatsere, mansh ayide'er gene'o noosh geyife.› » ");
INSERT INTO bwo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ando aani Iyesus b́ danirwotssh hank'o bíeti, «Gaalets ash iko b́ mootse b́ detsts giz jamo bísh k'eezitu jints iko detsfe b́tesh. Ashuwots ‹N meyitsi jintsan n gizo bad'iye b́ badiyri› ett gaaltsmansh bo numi. ");
INSERT INTO bwo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Galetsmanwere jints man s'egiit ‹N jangosh t shishiruwan eebi b́naroni? Haniye okoon t mootse jints wotosh n falrawotse jinosh n dek'ts t gizonat k'ac'on taash aab t'ntsuwe› bíet. ");
INSERT INTO bwo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Jintsmanwere bí nibots hank'o ett b́ gawi, ‹aak'o t k'ale k'una k'aniti taasha? Goshosho ango deshatse, falratse, k'onoshowere taane b́ jiitsiti, ");
INSERT INTO bwo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Bete! taa t k'alituwo danfee, t jinf finanatse taan gishewor, bo moots taan bezit jaguwotsi kishde'na.› ");
INSERT INTO bwo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«Mann b́doonzatse giz gushts jamwotsi ik ikon s'egdekt, shintsosh ‹T doonzsh n dashetuwo gusho ambtse ni atse fa'oni?› ett bíaati. ");
INSERT INTO bwo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Bíwere ‹Bal kor zeyito gusho tiatse fa'e› bí et, jintsmanwere, ‹N faramtso wuliyo hambe kaari waa bede' balk'ats kora err guud'e› bíet. ");
INSERT INTO bwo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Gitlono s'eegdek't, ‹ni'atse fa'o gusho ambtse?› bí et. Bí were ‹Bal arw sndeye tiatse fa'oni› ett bíaaniy. Jints manuwere ‹Hambe nfaramats wuliyoni! habi gita err guud'e› bí et. ");
INSERT INTO bwo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","B́ doonzwere amaneraw jintsman s'eko bek't bín b́údi. Manuwere Ik'i ashuwotsiyere datsatsi ashuwots bo datsatsi beyosh s'ek bowotoniye b́kitsiri. ");
INSERT INTO bwo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","«Manshe datsanatsi gondon ko'iyets gizone jago kishde'ere etiruwe itsha, man it k'aliyale it gizo b́ s'uure kish basho it oror it jag manots dúre dúrosh bo beyiru mootse iten dek'etúne. ");
INSERT INTO bwo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Muk' keewwatse amanets asho een keewatsnowere amaneke b́wotiti, múk' keewatse amanerawonwere een keewatse amaneratse. ");
INSERT INTO bwo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Eshe datsnatsi gaalo k'eezosh amaneratste wotiyal arik wotts gaalatsnmo kone amanar itsh imeti? ");
INSERT INTO bwo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ando k'osh ash gizatse amaneratste wotiyalmó itsh wotituwo detso kone itsh imeti? ");
INSERT INTO bwo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Ash iko iknon git doonzwotssh keeweyo falratse, man b́wotiyalmo, iko shid'r ikoni b́shuneti, iko mangiyir iko gac'ituwe, mank'o Ik'onat gizonsh keeweyo falratste.» ");
INSERT INTO bwo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ferisawiya eteefuwots giz shunk bowottsotse, Iyesus keewutsman shisht bí keewo bogac'i. ");
INSERT INTO bwo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Bímó hank'wa boosh bíet, «It it tooko ash shinatse kááw it wottsok'owa it ariyri, Ik'onmó it nibitstso danfee, ash shinatse mang detsts araat be'eyiruwo, Ik'i shinatse shit'eke.» ");
INSERT INTO bwo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Iyesus b́ keewmaanats dabt hank'o bíet, Nemonat nebiyiwots mas'afwots Gupfo Yohansok b́borfetsosh keewefera botesh, maniye hakono keeweyiruwo Ik'i mengsti misiraci jange, ash jamonwere mengst manits kindosh kup'at b́ finiri. ");
INSERT INTO bwo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Wotowa eree, Muse nemotse dab k'op' iku b t'afoniyere daronat datson bo besho ketefe. ");
INSERT INTO bwo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«B́ máátsu fakshr k'osh maatsu dek'etuw jamo gobetsiye. mank'o b́ kenihatse faksheets maatsu dek'etuwo gobetsi bwotiti.» ");
INSERT INTO bwo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Manats dabt Iyesus hank'o etre, «Gizi shaawon keewets tahi biro tah dek'ts gaalets iko fa'e b́tesh, bíwere aaw aawon beyi sheengo b́befoni. ");
INSERT INTO bwo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Bíats jamó gaawu wottso Alazari eteetso t'oowo ando gaaletsman máá fengeshatse b́k'eefoni, ");
INSERT INTO bwo_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","T'owmanwere, gaaletsman mishi maratse fed'iru mishi fed'man moosh b́joolfo, kanwotswere waar b́ gawo bolep'efoni. ");
INSERT INTO bwo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«Maniyehako t'owman k'irb́wutsi, melakiwotswere Abraham ganok dek't boami, ando gaaletsman b́ k'irre dukeyi. ");
INSERT INTO bwo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Siolitsnowere b́ kic'efere, b́ tooko dambaan kááwdek't́ b́s'ilfere Abrahamnat b́ ganoke fa'o Alazari wokoon b́k'b́k'ri. ");
INSERT INTO bwo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","B́ k'áárono eenshdek't hank'owa bíet, ‹Niho Abrahamo! oona neesha! taash maac'o keewowe! taw lalwanitsne aydek'at tkic'iruwotsene b́ kishi jaabo aatsots gufde'er ti albero bíak'itwok'o Alazari tmaants woshdyiwe!› ");
INSERT INTO bwo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«Abrahammó hank'owa bísh bíet, ‹T naayo, nee datsatse n kashon n beets dúron ay sheeng beyo daatsat n gene'útsok'o gawude'e, Alazarmo gond bek'owotse b́teshi, manshe hanoke bí and b́ genee'úwor nemon n kic'iri. ");
INSERT INTO bwo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Jamanatsnmó itnat noon dagotse gohi eeno fa'ee, mansh nomande it maants, it maantse nomand kímo falituwo konuwor aaliye.› ");
INSERT INTO bwo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Galetsonwere hank'o bíet, Nihono, bere oona Alazari tnihi mook n woshituwok'o neen k'oniruwe, ");
INSERT INTO bwo_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Oke uts eshuwo detsfe, ando manots kic'anok kindosh bowarawok'o amr boosh keewwe. ");
INSERT INTO bwo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahammo ‹Musenat nebiyiwots mas'afwots boosh fa'ane, boon k'ewune› bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ash gaaletsmanuwere ‹Woteratse! niho Abrahamo, ik asho k'irotse tuur amr b́keewink'e goyinar nandrone etank'ne› bí et. ");
INSERT INTO bwo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abrahamuwere ‹Musenat nebiywots mas'fwots bo etiruwo k'ewatsno wotiyalmá ik asho k'irotse tuur b́keewiyalor amaneratsne› bí eti.» ");
INSERT INTO bwo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iyesus b́ danifuwotssh hank'owa bí et, «Ashuwotsi gandde'er moorrots dikit keewwots bo woo oreratse, ernmó morrots dikosh t'ug wotitu man wotk'ayna! ");
INSERT INTO bwo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Konwor wotowa asho, múk'nananotsitse dab iko gand de'er dikitwoniyere di'i shútso b́bimbats tifde aats k'arots bín juwk'rewo k'aniyank'e bísh. ");
INSERT INTO bwo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Eshe it tookish it atso korde'ere! ni eshu neen b́dadiyal fayowe! b́ t'afiyo danr naandre bí etal bísh orowe eree! ");
INSERT INTO bwo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ik aawon shawatoto neen b́ dadiyal err ik aaw manots n maants waar ‹T t'afitsosh goynere› bí etal bísh orowa eree.» ");
INSERT INTO bwo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","B́ woshtswots doonzo Iyesussh «Oona neesha imnetiyo noosh dabuwe» bo et. ");
INSERT INTO bwo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Doonzo Iyesuswere «Fuk'i aawi fetshuk'o imnetiyu it detsink'e fuk'i mitansh ‹Hanoke wad'ar aats k'arots kokewe!› it etink'ere itsh aleyank'e» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Manats dabt́ Iyesus hank'owa bí et, «Ititsi iko gosh goshfo wee mereer jinf guutso detstso, b́ guutso finoke bí aantsok'on guutsosh ‹Waa bede n kooc'misho moowe› etetuwa? ");
INSERT INTO bwo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Maniyere ‹Eree! t kooc'misho taash k'aniwe, maar t úyfetsosh tuumr taash finowe, maniyere okoon ando nee maar úshetune› etetuwoshna? ");
INSERT INTO bwo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Eshe, guutso bísh finowe eteetso ee ett b́ fontsotse b́ doonz bín b́ údituwok'o arefa itsha? ");
INSERT INTO bwo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Itwoor mank'o it finituwok'o itsh keewets jamo fin it k'rtsok'on, ‹K'awuntsalk guuts noone, no k'altsosh noon údo geyiratse› erere.» ");
INSERT INTO bwo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iyesus Iyerusalem maants bí amor Semarinat Gelil dagona b́ beshi. ");
INSERT INTO bwo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Gal ikuts b́ kindtsok'on, tats een shodetsuwots b́ maants waat wokoon need' boguts, ");
INSERT INTO bwo_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Bok'aronowere eenshdek't «Iyesuso, danifono, oona neesha noosh maac'o k'ewowe!» ett bokuhi. ");
INSERT INTO bwo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Iyesuswere boon s'iilt «Ameree! It atso kahniwotssh kitsuwere!» bí et. Bowere amoke bobefere bo een shodatse kashbowuts. ");
INSERT INTO bwo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Boyitsi iko bí een shodotse b́ kashtsok'owo b́ bek'tsok'on Ik'o udfere aanat b́waa. ");
INSERT INTO bwo_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Iyesusnowere údefetst́ b́tufi shirots b́dihi, bímo Semary dats asha b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Iyesuswere hank'owa bí et, «Een shodotse kashtsuwots tatsnosha boteshi? Eshe, tatswots aabno? ");
INSERT INTO bwo_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ik'o údosh aanat waatso k'osh jirani bako k'osho dab iko datseratsaá?» ");
INSERT INTO bwo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Maniye hakon Iyesus ash mansh, «Tuur amee, n imnetiyo neen kashire» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ferisawiwots Iyesussh, «Ik' mengstu awure b weti?» ett bo aati. Bíwere hank'o ett boosh bí aani, «Ik'o mengstu wáá woo ash ashuwots bo kotiruwok'onaliye, ");
INSERT INTO bwo_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Konwor ‹Hambiye, hanoki ye wee ekewokiye› etetkiyaliye, hamb Ik'o mengstu it dagotsiye.» ");
INSERT INTO bwo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Manats dabt Iyesus b́ danifuwotssh hank'o bíet, «Ash Na'o aawwotsitse dab iku bek'osh it mirac'it aawo weetuwe, ernmó be'atste. ");
INSERT INTO bwo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ashuwots ‹Hambe, Krstos hanoke b́ fa'oni! wee ekewoke b́ fa'oni!› etetúne, ernmó amk'ayere, boshutso shoy k'ayere. ");
INSERT INTO bwo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Guumo darotse b́ p'alk'or ik maants dats daaratse tuut k'osh dats daarats b́ golfok'o ash na'o b́ weet aawots mank'owe b́ wotiti, ");
INSERT INTO bwo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ernmó Ash na'o shino ayide gond bek'o tí ats bodo geyife, and dúri s'oot'wotsnowere gac'ewonat k'efeyo oritkaliye. ");
INSERT INTO bwo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noh dúr wottsi naaro taa Ash na'o t wooror mank'o b́ wotiti. ");
INSERT INTO bwo_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noh markabuts b́ kindfetso ash ashuwots mafetst, úshfetst, dek'fetst de'efetstni botesh, manoor t'afits atso waat jametsi k'ot'dek' t'afi b́k'ri. ");
INSERT INTO bwo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Mank'owa ando Lot' dúr b́ wottsi naaro wotituwe, manoor ashuwots maat bo ushfere, kemt bokeewefere, atkltiyo kokeftst moo bo agfera bo teshi. ");
INSERT INTO bwo_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ernmó Lot' Sedomitse b́ keshts aawots tawonat diniyon darotse butst jametswotsi t'afibk'ri. ");
INSERT INTO bwo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Taa Ash na'o t be'ewotso mank'o wotitwe. ");
INSERT INTO bwo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Manots b́ máá tokatse kesht beyiru asho b́meyitsi k'ac'dek'o oot' k'aya, gooshok amt fa'o b́gal aanar waak'aye. ");
INSERT INTO bwo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot' máátsu b wottsok'o gawude'ere! ");
INSERT INTO bwo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","B́ kashu oori dek'o geyiru jamo bin t'ut'etuwe, b́ kasho beshide imetu jamo wooriydek'etuwe. ");
INSERT INTO bwo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Manots t'ú git ashuwots ik es'atse k'eetúno, boyitse ikonowere dek'etuwe, ikonúwere oorituwe. ");
INSERT INTO bwo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mááts gitetswots ikoke ik di'i shútsatse tohar dio di'ituno, iku dek'etuwe, iku oorituwane.  ");
INSERT INTO bwo_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Git ashuwots tar ikotse goshfere, iko dek'etuwe, iko oorituwe.» ");
INSERT INTO bwo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","B́ danifuotswere Iyesussh, «Doonzono, ewuke dek' ameyiri» ett bo aati. Bíwere «Duuni beyoke k'orwotsuwere kakuwetúno» ett boosh bíaaniy. ");
INSERT INTO bwo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Maniye hakon, Iyesus bo tahrawon jam aawo Ik' k'ono boon b́ geyituwok'owo daniyosh aryidek't hank'o ett boosh b́ keewu, ");
INSERT INTO bwo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«Kit ikutse Ik' sharawo, ashono jitseraw naash iko fa'e b́teshi. ");
INSERT INTO bwo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kit manitse keniyal t'owu mááts ikunu bbefo, bi naashmanok waat ‹T balangaronton t detsts moosho taash angshwe!› bi etfoni. ");
INSERT INTO bwo_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Bíwere bish b́ k'oorrawon ayo b́ ja'a, ilmó hank'o ett bíasabi, ‹Dab Ik'o shato tk'azalor, ashono jitso t k'azalor, ");
INSERT INTO bwo_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","T'owu máátsan taan k'eezo bazaat taan b taahitsotse bish k'oorituwe, maniyalbako uni aawo anaanar taane b tahiyiti.› » ");
INSERT INTO bwo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Manats dabt Doonzo Iyesus hank'owa bíet, «Mor gond naashman keewtsman t'iwintsde'ere, ");
INSERT INTO bwo_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Eshe Ik'o, t'uwe aawo kuh dek't k'oniru bí ashuwotssh angshiyalkeyá? Batarnmó boosh b́ k'alitwo jaítúwáá? ");
INSERT INTO bwo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","B ja'arawon karr boosh k'oorituwe etiruwe. Ernmó taa Ash Na'o aanar t woor datsatse imnetiyo datsifak'una?» ");
INSERT INTO bwo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Manats dabt Iyesus Ik' shuntsok'on beyiruwots noone etfetst it'fetst koshuwotsi gac'iru ashuwotssh aryidek't man b́keewu. ");
INSERT INTO bwo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Git ashuwots Ik' k'onosh, Ik'i moo maants bo am. Iko ferisawiya eteyiruwo b́ wotor ikonmó t'ilish ko'ika b́tesh. ");
INSERT INTO bwo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","«Ferisawiya eteyiruman b́nibotse hank'o ett Ik'o b́ k'on, ‹Ik'ono! taa k'osh ashuwotskok'o bik'tsi, weral fintso, widetso wot tk'aztsosh neesh udo boree, bitsnor t'ilish ko'ifank'o wototk'aztsotse neen udere. ");
INSERT INTO bwo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Taa ik gawiyotse git aawo s'oomiruwe, t daatsiru jamotse tatslo kishdek'at imiruwe.› ");
INSERT INTO bwo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«T'ilish ko'ifmanmo wokoon need'dek't́, daromaand kááwdek' s'ilosh dab shatfetstni b́tesh, ernmó b́ kishon b́ gero k'is'fetst, ‹Ik'ono! taa morretsk tane taash maac'o k'ewowe!› bí etiri, ");
INSERT INTO bwo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ik'i shinatse kaawu wotat b́ gal antso eshe t'ilsh ko'ifmaniye bako ferisawiya eteyirumaniyaliye etiruwe itsha, b́ tooko damb detsiru jamoniye dash oot'etwe, b́ tooko dashan detsirwonmo dambaan keshetuwe.» ");
INSERT INTO bwo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ashuwots nana'o b́ shú'ituwok'o Iyesus maants dek't bowáá, b́ danif'uwots man bek't boon fayi. ");
INSERT INTO bwo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Iyesusmó nana'uwotsi b́ maants s'eegdek't hank'owa bíet, «Ik'i mengstu hanots k'owuwotssh b wottsotse nana'uwotsi k'ayere tmaants wonee, bazik'ayere. ");
INSERT INTO bwo_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Arikoniye itsh tkeewiri! Ik'i mengtu na'i marmat'ok'o wotar de'awoniye konuwor b́wotiyal bits kindratse.» ");
INSERT INTO bwo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ayhudi naashuwotsitse iko Iyesussh, «Danif doowono, dure dur kasho daatsosh eeg k'alo taash geyifa?» ett bíaatí. ");
INSERT INTO bwo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Iyesuswere «Eegoshe doowono taash nietiri? Ik' ikoniyere okoon doowo konuwor aaliye. ");
INSERT INTO bwo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nokotetwok'o bímts nemonuwotsi danfnee, boowere ‹Wido amk'aye, úd'k'aye, úmp'k'aye, kooton gawuk'aye, nindnat t nnihn mangiwe› etetsuwotsiye.» ");
INSERT INTO bwo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ashmanwere «Hanotsnma t naortson tuuzat kotdek're» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iyesus man b́shishtsok'on ashmansh, «Beree ik keew nk'alituw oor fa'ane, n detsts jamo kemde b́ gizo t'owwotssh ime, darotse kakuwets gaalo daatsitune, maniye hakono waar tshutsats sha'owe» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ashman ayidek't gaaletsko b́ teshtsotse, man b́ shishtsok'on ayidek't shiyanb́guts. ");
INSERT INTO bwo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iyesusere ashman b́shiyantsok'o bek'k'rat, hank'owo bíet, «Gaaletsosh Ik'i mengstots kindo aak'owe kic'ike! ");
INSERT INTO bwo_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Gaaletso Ik'i mengstots b́kindoniyere, kambulo mafi fúron b́ besho ketefe.» ");
INSERT INTO bwo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Man shishts ash jamo, «Hank'owon bere kone fal kashiti?» bo et. ");
INSERT INTO bwo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iyesusmó, «Ashoke maawets keewo Ik'oke faleke» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","P'et'rosuwere «Hamb́, noo no detsts jamo k'azk'rat n shuutso shoy dek' sha'erone» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Iyesuswere hank'o boosh bíet, «Arikon itsh keewiruwe, Ik'i mengst jangosh ett b́ moo wee b́ máátsú wee b́ eshuwotsi wee bí indnat b́ nihn k'azts asho, ");
INSERT INTO bwo_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","And datsanatse gitkishoniye bogo ay daatsituwe, weet datsatsnowere dure duri kasho daatsituwe.» ");
INSERT INTO bwo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iyesus b́ danif tatse gituwotsi b́ maants t'intsdek't hank'o bí et, «Hamb! Iyerusalem maants amishee, Ash na'o jangosh nebiyiwotsn keewets jamó manoke s'eenetwe. ");
INSERT INTO bwo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bín Ik' ash woterawwots kishats beshide imetuwe, boowere bí atso s'udetuno, bíno c'ashetuno, bín aatsniytune. ");
INSERT INTO bwo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bo jod'i hakon úd'ituno, ernmó keezl aawots k'iro da'er tuwituwe.» ");
INSERT INTO bwo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","B́ danifuwots keew jamanitse dab ikunor t'iwintsratsno, b́ keewiru keewwots biitso boosh ash bwutsitsosh eeg bíetiruwok'o danatsno. ");
INSERT INTO bwo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Iyesus Iyariko maants b́ t'intsok'on ááwu dog iko weri guratse bedek't b́ k'onir b́tesh. ");
INSERT INTO bwo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","B́ ganoke beshiru ay ashuwots k'aro b́ shishtsok'on «Eebi b́ naaroni?» ett bí at. ");
INSERT INTO bwo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ash ashuwotswere «Hambe! Nazrettso Iyesus han weerone beshoke b́ fa'oni» ett bokeewu. ");
INSERT INTO bwo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mann ááwu dogo, «Dawit naay Iyesuso! oona taash maac'o k'ewowe!» ett b́ kuh. ");
INSERT INTO bwo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Shin shino amiru ashuwots, «S'k eree!» ett bo fay. Bímo b́ k'aro iki bogshdek't, «Dawit naayo! oona neesha taan maruwe!» etfetst b́tesh. ");
INSERT INTO bwo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Mansh Iyesus need'dek't «T maants dowere» ett b́ keewu. Ááwu dogonwere b́waatsok'on, hank'o ett bíaat, ");
INSERT INTO bwo_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Neesh eeg tk'ale n geyi?» bí et. Ááwu dogonwere «Doonzono! bek'oshe tgeyiri» bíet. ");
INSERT INTO bwo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Iyesuswere «S'iile! n imnetiyo neen kashire» bíet. ");
INSERT INTO bwo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ááwu dogonwere manoor bek'o b́fal, Ik'onowere udefere Iyesus shuutso shoy dek't b́ tuu, ash jamonuwere man bobek'tsok'on Ik'o bo udi. ");
INSERT INTO bwo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iyesus Iyarikó kitots kindt man weeron beshat bí amí. ");
INSERT INTO bwo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Manoknowere t'ilsh ko'ifuwotsats naasho Zekiwosi eteef gaalets ash iko fa'e b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Bí Iyesus aawi b́ wottsok'o bek'osh b́ geefera b́ tesh, ernmó b́ need'o k'awun b́ wottsatse ashonwere ay b́wotsosh bek'o maaw b́ wuts. ");
INSERT INTO bwo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Iyesus man weeron b́beshirwotse Zekiwos bín bek'o geeyat ashuwots wos't fuk'i mit abaats keshb́dek'i. ");
INSERT INTO bwo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Iyesuswere manok am b́bodtsok'on dambaan kááwdek't s'iilt Zekiwossh, «Zekiwoso! hambets n mootse jino taash b́ geyiytuwotse káári mitatse ood'e» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zekiwoswere káári oot't, gene'úwefetst Iyesusi ibiyosh dek't bíami. ");
INSERT INTO bwo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Man bek'ts ash jamo «Ashaan morretso moots s'eegere ibo amt kidre!» ett Iyesus ats bo mumudi. ");
INSERT INTO bwo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zekiyosmó need'dek't doonzo Iyesussh hank'owobíet, «Doonzono! hambe, t detsts gaal jamotse b́ bado t'owwotssh imetuwe, dirshat ashaatse t dek'ts gizo b́beyalowere, awd kisho woshde'er aaniytuwe.» ");
INSERT INTO bwo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Iyesuswere hank'owa bíet, «Ashaan Abraham naar b́ wottsotse hambets kasho máánsh wotere, ");
INSERT INTO bwo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ash na'o b́ weyiye t'aftso geeyar kashiyoshe.» ");
INSERT INTO bwo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ashuwots man k'eboke bobefere Iyesus keewu iko ando jewrdek't b́keewi, bíwere Iyerusalem maants b́ karntsotse ash ashuwots Ik'i mengstu andon b́be'etwok'o boosh bíartsosha b́tesh. ");
INSERT INTO bwo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Mann Iyesus hank'wa bíet, «Nugus woti alo k'a'u de'k't aanar wosh wok datso amts naasho fa'e b́tesh, ");
INSERT INTO bwo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Bí amftsre shino b́ guutsuwotsitse tatswotsi s'eegdek't bo took tookosh ik ik minaniyo imt ‹Aanar twafetsosh gizan jahere› bí et. ");
INSERT INTO bwo_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","B́ dats ashuwotsmo bín boshit'fotse, ashaan noatsats b́ naasho geeratsone ett bí amiyakon wosh na'o bo wosh. ");
INSERT INTO bwo_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Ash man nugus wotat bíantsok'on boosh imets gizon jaakt awuk'o bo oorshtsok'o danosh, gizo imt bíamts b́ guutsuwotsi b́ s'eegiyi. ");
INSERT INTO bwo_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Shints guutso t'int, ‹Doonzono! n imts ik minaniyon hamb tats minaniyo oorshre› bí et. ");
INSERT INTO bwo_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","B́ doonzuwere ‹Nee sheeng guutsono! sheenge nfini, muk' keewatse amanek nwottsotse taamo neen tats kitatse alo neesh imre› bí et. ");
INSERT INTO bwo_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Gitl guutsonwre t'int ‹Doonzono! taash n imts minaniyo hambe, uts minaniyo oorshre› bí et. ");
INSERT INTO bwo_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Doonzonuwere hansh ‹Nenowere uts kitatse naashire› bí et. ");
INSERT INTO bwo_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«Keezlonwere t'int hank'o bíet, ‹T doonzo! taash n'ímts gizoniye hambe, but'ots k'undek'atniye ged t k'ri b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Man t k'aluwere nee ngeraw dek'etuwo, n shohawo kakuwituwo, maac' kup' n woto danat t shattsatsne› bíet. ");
INSERT INTO bwo_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","B́ doonzwere ‹Nee gond guutsono! n keewts keewann niats angshetuwe, taa t geerawo dek'etk twotonat tshohawo kakuwitk maac' kup' asho t woto danrnee, ");
INSERT INTO bwo_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Beree t gizo oot' daatsit bankiyo eegoshe gedo n k'azi? Taa aanar twoor b́ oot'onton dek'anek'e b́ teshi› bí et. ");
INSERT INTO bwo_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Maniyere hakon doonzman, manoke need'dek't teshtswotssh, ‹B́ minaniyo bíatse de'er tats minani detsts guutsosh imere› bí et. ");
INSERT INTO bwo_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bowere ‹Doonzono! bíyere tats minaniyo detsfe!› bo et. ");
INSERT INTO bwo_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Doonzonuwere ‹Detsts jamosh iki bogoshde dabetuwe, deshawoknmo dab b́ detstsonor bíatse k'a'udek'etwe etiruwe. ");
INSERT INTO bwo_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Boatsats t naasho geerawu t t'elatmanotsnomó hanok dewar tshinatse boon úd'uwere!› » bíet. ");
INSERT INTO bwo_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iyesus man jewuron b́keewihakon b́ weerindo Iyerusalem maants sha'efetst, b́ danifuwots shin shinatse bíamir b́tesh. ");
INSERT INTO bwo_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Iyesus Debrezeyit guro ganoke fa'u Bete Fagenat Betaniyi maants b́t'intsok'on, b́ danifwotsitse gituwotsi hank'o ett b́ wosh, ");
INSERT INTO bwo_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«It shinatse fa'a galuts ameree, manok it bodtsok'onowre konúwor bíats be b́ danawu daaz na'o tipotse daatsitute, bish de'er hanok de'ewoore. ");
INSERT INTO bwo_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Konuwor ‹Eegishe it bitsiri› err iti bíatiyale, ‹Doonzosh b́ geyitsotsne› err aaniwere.» ");
INSERT INTO bwo_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Woshetswotsuwere boame jam keewo arikon Iyesus ettsok'o wotat bi'ere bodaatsi. ");
INSERT INTO bwo_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Dazna'ono bobitsfere doonzwots «Eegishe it bitsiri?» boosh bo eti. ");
INSERT INTO bwo_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bowere «Doonzosh b́ geyitsotsne» bo et. ");
INSERT INTO bwo_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Dazna'onowere Iyesus maants dek't bowá, bo tahono daazna'o jik' abaats k'awudek't Iyesus b́betwok'o bo k'ali. ");
INSERT INTO bwo_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Iyesus bíamfere ashuwots boshemo weridats bo es'iri. ");
INSERT INTO bwo_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Iyesus Iyerusalem kitots bodosh b́t'infere Debrezeyit guratse dashan oot'oke b́befere, manoor b́ shutsats sha'iru ashjametswots bo bek'ts adits keewwotsatse tuwtson bogeneútsosh bo k'aro eensh dekt Ik'o udo dek't botwi. ");
INSERT INTO bwo_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Hank'owa bo etiri boteshi, «Doonzo shútson weetu naasho deereke! jeeno darotse, mango Ik'osh daaratse wotowa!» ");
INSERT INTO bwo_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ash dagotse teshts ferisawino eteef ik ikuwotsmo Iyesussh «Danifono! n danifuwotsi s'k bo eteetuwok'o woshuwe!» bo et. ");
INSERT INTO bwo_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Iyesuswere «Bo dab s'k boetalor shútsuwotswor kuhituno etiruwe itsha» ett bíaaniy. ");
INSERT INTO bwo_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iyesus Iyerusalem kito maants t'int, kitu b́ bek'tsok'on, bish bíepi. ");
INSERT INTO bwo_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Hank'owo bí et, «Nee n jeenosh geyit keewo hambets danfnee woterake! Andmó keewu han niawatse ashwutsere, ");
INSERT INTO bwo_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","N balangaruwots neen gúride kas'o kac'de neen gúrde'er bokic'it aawo weetuwe. ");
INSERT INTO bwo_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Neenat n gitsotse fa'a n na'uwotsi datsats dikde t'afituno, b́ gaherawon orituwo dab ik shútsonor bbeyoke neesh k'azeratse, han b́ wotituwere, Ik'o neen kashiwosh b́waats dúro n dartsoshe.» ");
INSERT INTO bwo_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Iyesus Ik' k'oni moots kindt, manoke jaakiru ashuwotsi gisho dek't b́tuwi, ");
INSERT INTO bwo_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Hank'owere boosh bíet, « ‹T moo Ik' k'oni mee b́ wotiti› ett guut'ere, itmó bik'tsuwotssh gemee it woshk'ri.» ");
INSERT INTO bwo_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Iyesus aaw aawon Ik' mootsna b́ danifo, kahni naashwots, Muse nemo danifuwots, ash jiishiru k'oshuwots bín ud'osha bogefo. ");
INSERT INTO bwo_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ernmó ash jamó Iyesusi k'ebosh geeyat bo nibo imk'rk boteshtsotse bín úd'osh geyiru jirwots eegor k'alosh falratsno. ");
INSERT INTO bwo_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ik aawu Iyesus Ik'i mootse daatseyat ash ashosh doo shishiyo b́ keewufere kahni naashwotsna, Muse nemo danifuwotsnat eenashuwotswere bíyok bo weyi, ");
INSERT INTO bwo_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Bowere «Aab noosh keewwe, keewanotsi kon alon nfiniruwok'ona?» ett bo aati. ");
INSERT INTO bwo_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Iyesuswere hank'wa boosh bíet, «Taawere ik keewu iti aatuna, eshe aab taash aaniwere, ");
INSERT INTO bwo_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohans gupo Ik'okike himó ashokike?» ");
INSERT INTO bwo_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bowere hank'o ett bo atsatseyo bo keewe, « ‹Ik'okike no› etala, ‹Beree eegishe bín amano it k'azi› etetuwe nosha, ");
INSERT INTO bwo_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","‹Ashokike› no etalmó ash jamo Yohansi nebiyi b́woto bo amantsotse shutsone noon bo togeti.» ");
INSERT INTO bwo_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mannsh «Aawokik b́ woto danatsone» ett bo aaniy. ");
INSERT INTO bwo_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Iyesuswere, «Beree taawor kon alon keewanotsi t finiruwok'o itsh keewuratse» bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Manats dabt Iyesus ariyetsan ash ashosh keewo dek't b́ tuu, ash iko weyini mito b́toki, goshtsuwotssh krayik'rat k'osh datso k'az bíami, bí anerawono ayo b́ja'i. ");
INSERT INTO bwo_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Woyiniyo b́shutsok'on weyiniman doonz b́ shuwotse b́bano bísh de'e b́weyish guuts iko goshtsuwotsok b́woshi, goshtsuwotsmo togdek't kishibashon faksh bok'ri. ");
INSERT INTO bwo_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mank'o ando k'osh guutso b́ woshere bínor tog boishí, ketidek't kishibashon damibok'ri. ");
INSERT INTO bwo_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ando aani keezl guutso b́woshere manowere togdek't gaawit kishdek't juubok'ri. ");
INSERT INTO bwo_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Maniye hakonowere weyiniyo doonz «Eshe awuk'o k'alutak'una? T shuntso t naayi woshona, daneraka bín mangiyo k'ayatsne,» bíet. ");
INSERT INTO bwo_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ernmó goshtsuwots bín bobek'tsok'on bo atsatsewo hank'o bo eti, Eshe naatetuwo haniye, woore úd'k'rone! b́ datso nok wotituwe! ");
INSERT INTO bwo_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mansh b́ naayi woyniyi maniyre úratse kish dek't boúd'i. Eshe and weyiniman doonz goshtsmanotsi awuk'o boon b́k'alituwok'o arefa itsha? ");
INSERT INTO bwo_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Weyni doonzo b́tokone b́ weti, goshtsuwotsnowere úd'nib́ishit, weyni mitmanowere k'osh goshtsuwotssh imk'rituwe. ashuwotswere man boshishtsok'on «Hanwo b́jamon wotk'aye» boeti. ");
INSERT INTO bwo_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iyesusmo bo maants s'iilfetst hank'o bí et, «Eshe, ‹Gmbi agfwots gac'ts shútso shúts kup'o shútswotsi tungúshatse kaatsde detsetwo wotb́gutsi› ett guut'etso eege b́kitsiri. ");
INSERT INTO bwo_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Shúts manats dihitu jamo tishitwe, shútsman bíats b́dihitu ashonmo t'ars'etwe.» ");
INSERT INTO bwo_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Muse nemo danifuwotsnat kahni naashwotsn ariyets keewuman boatsats b́ keewtsok'owo dank'rat manoor bín deshdek'osh geyatni botesh, ernmó ash asho shatbowtsi. ");
INSERT INTO bwo_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mansh Iyesusi ash aalts aawots detsosh kotbodek'i. Naasho alonat bíats angshetuwok'o betsit nooni dáro bíatse datsosha bogefoni, mansh ash sheeng araarr b́ keewiru keewo mec'it ashuwotsi woshbok'ri. ");
INSERT INTO bwo_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Keew mec'it ashuwots Iyesus maants t'int, hank'o ett bín boaati, «Danifono! nee n keewiruwonat n daniyruwon ar b́wottsok'o danfone, Ik'i weero arikone ndaniyiri bako konshor bogabogshratsne. ");
INSERT INTO bwo_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ab noosh keewwe! no nemok'on Rom nugúsosh ereer dasho wotitwamo woteratsa?» ");
INSERT INTO bwo_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Iyesusmó bo gondon bok'od'iruwok'o dank'rat boosh hank'o bí et, ");
INSERT INTO bwo_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Aab́ ambarmani taash kitsuwere, ambarmanats gedets aronat shútson konke?» Bowere «Rom nugúsoke» boeti. ");
INSERT INTO bwo_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Iyesuswere, «Eshe naashi naashoko naashi naashosh, Ik'oko Ik'osh imere» bíet. ");
INSERT INTO bwo_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bowere ash ash shinatse b́keewuts keewon bín detso falratsno, mansh boosh bíaniyor adt s'k etbowtsi. ");
INSERT INTO bwo_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","«K'irtsuwots tuuratsno» etef Seduk'awiyots Iyesusok t'int hank'o ett bo aati, ");
INSERT INTO bwo_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Danifonó! Muse hank'o ett noosh guut're, ‹Ash iko b́máátsu atse na'o b́ shurawo k'iron b́k'aleyal bí eshu máátsmani de'er bí eshush shaato shegrshwee.› ");
INSERT INTO bwo_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Shawat eshuwwots fa'ano boteshi, jametsuwotsitsi k'aabo máátso dek't na'o b́ shurawo k'irb́wutsi. ");
INSERT INTO bwo_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","B́ shutsonuwere máátsmani b́ dek'i. ");
INSERT INTO bwo_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Keezlonuwere bin b́dek'i, mank'oon shawat wotsuwere bin dek't na'o boshurawo k'irbowtsi. ");
INSERT INTO bwo_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Jametsuwotsiyere il máátsman k'irbwutsi. ");
INSERT INTO bwo_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Shawatetsuwots taron bin máátso bodek'tsotse eshe k'irtsuwots bo tuwots ááwushe ááwushe mááts b wotiti?» ");
INSERT INTO bwo_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iyesuswere hank'o ett boosh bíaaniy, «Datsatsi ashuwots máátso dek'etunó, de'etuno, ");
INSERT INTO bwo_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","k'irtsuwotsitse tuur, weet dúron beet ashuwotsmó, máátso de'atsno, de'eratsno. ");
INSERT INTO bwo_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ik'i melakiwotskok'o bowotituwotse k'irratsno, k'irotsno bo tutsotsnowere Ik'o nana'úwotsye. ");
INSERT INTO bwo_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","K'irtsuwots tuwi jangoshmo, Muse buush tawi jango b́keewu taarikiyotse, Doonzone ‹Abrahamko Izar Izewer, Isak'ko Izar Izeweri, Yok'obko Izar Izeweri› ett bín s'eegree. ");
INSERT INTO bwo_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Manshe Ik'oniye kashetswotsko Izar Izeweri bakro Izar Izewer k'irtsuwotskaliye, jametsuwots bísh kashon beetúne.» ");
INSERT INTO bwo_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Muse nem danifuwotsitse ik ikuots «Danifono! sheenge n keewi!» boet. ");
INSERT INTO bwo_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Maniyere hakon aawo shu'ude Iyesusi aatosh falituwo boyitse konwor aaliye. ");
INSERT INTO bwo_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Maniye hakon Iyesus hank'oa boosh bíet, «Aak'oneya Krstos Dawit naayiye boetiri? ");
INSERT INTO bwo_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Dawit b́ tookon duubi mas'aafotse, ‹Doonzo t doonzsh N t'alatuwotsi n tufi shirots neesh t gerfetsosh T k'ani aaromants beewe bíeti› etfe. ");
INSERT INTO bwo_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Eshe Dawit b́tookon doonza ett b́ s'eegiyakon bere Krstos Dawitsh aawuk'oneya b́ naay woto b́faliti?» ");
INSERT INTO bwo_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ash jamo b́ shishfere Iyesus b́ danifuwotssh hank'owa bíet, ");
INSERT INTO bwo_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Tahi geenz geenzo karde'er hake bako sha'o, gawuyotsno mangiyets jamo dek'o, Ik' k'oni mootse mangiyets jorwotsi, jiwoknowere mangts beyoko shunf Muse nem danifuwotsatse it atso kordere. ");
INSERT INTO bwo_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bowere be'ewosh bot'intsiru geenz wotts Ik' k'onats webdek't bokenih k'irts maatsuwotsi botes'iri, manshe iki gond keewe boon kotiri.» ");
INSERT INTO bwo_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iyesus dambaan kawdek't b́s'ilfere gaaletswots bo imiruo mebo ms'watiy dek'eyiru sat'nots bo gedfere bek' b́k'r. ");
INSERT INTO bwo_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Mank'o t'owu mááts iku, git santimu wotit gizo sat'nots b ged'fere bek' b́k'ri. ");
INSERT INTO bwo_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Hank'owere bíet, «Ariko itsh keewiruwe, t'owmáátsan jametsoniyere bogsh dek'at imranee. ");
INSERT INTO bwo_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bo boimye bogalotse oortsoniye, bimo t'owu wotefetsatniye eegor b ooride'awon b detsts jamo imranee.» ");
INSERT INTO bwo_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ash ik ikuwots, «Ik'i maa han awuk'owe b́sheengi? Gizi shaawo kishit mang shútsuwotsnat Ik'osh t'ints sheeng keewone baats b́wutsi» et fetst bo keeweyiri b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ernmó Iyesus «It bek'iru jaman shútso shútsats kororeyar b́oorawu dúro weetuwe, shúts jamanots ik aawu gaahitune.» ");
INSERT INTO bwo_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bowere «Danifono! man b́wotit awure? Hanuwere wotosh b́t'intsok'o eegi milktoneya nodaneti?» ett boaati. ");
INSERT INTO bwo_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Iyesus hank'o ett boosh bíaaniy, «It shelawok'o it atso korde'ere! ayuwots ‹Taa Krstos taane! hambe! bíaawo t'inre!› err t shutson weetune, bo shuutso sha'ak'ayere. ");
INSERT INTO bwo_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kes'i jangonat dimbiron it shishor tek' k'ayere, shinshino man b́woto geyife, ernmó b́s'uwo manoor woteratse.» ");
INSERT INTO bwo_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Manats dabt Iyesus hank'owa bíet, «Ash asho ashaashats, naasho naashats tuwitwee. ");
INSERT INTO bwo_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","B́ be beewoke kup' wotts dats shek'ewo, k'ak'onat maryi shodon wotituwe. Shatit keewuwotsnat mlikit een eenuwotsn darotse be'etúne. ");
INSERT INTO bwo_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ernmó jaman b́ woteftsere shino ash ashuwots itn detsetúno, gishitúno, ayhudi Ik' k'oni moonat tipi mootso beshide iti imetuno, t shútsi jangosho itn naash naashonat altswotsok de'e ametunee. ");
INSERT INTO bwo_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Hanuwere t shútsi jango gawosh itsh iki sheeng b́wutsiti. ");
INSERT INTO bwo_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mansh itats bodet s'amiyewor it aanit keewosh it kic'erawok'o shino t'iwints de'ere. ");
INSERT INTO bwo_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","It balangaruwotsitse konuwor falr k'efo b́ bayaw nononat dani telefo taa itsh imetuwe. ");
INSERT INTO bwo_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Iti ind nihuwtsnat it eshuwots, it jaguwotsnat it tohuwotswor bo oorerawo iti beshider imetune, itiste ik ikuwotsi úd'etuwe. ");
INSERT INTO bwo_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","T shútsi jangosh ash jami shinatse shit'eek wotitute. ");
INSERT INTO bwo_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ernmó it took s'iratse ik s'iru dab t'afratsane. ");
INSERT INTO bwo_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","It k'amon it kashu kashidek'etute» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Manats dabt Iyesus hank'owa bíet, «Iyerusalem t'alaton gúrde bobefre it bek'or b t'afo b́ bodtsok'o dande'ere, ");
INSERT INTO bwo_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Manoor Yihud datsatse fa'uwots guromants woc'no, kitutse fa'uwots biitse keeno, kituniyere úratse fa'uwots kitumand kind k'ayno. ");
INSERT INTO bwo_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","T'afan jangosh guut'etso shin bek'on keewetso b́ wotituwok'o hanweer wershikonat fayi dúrone. ");
INSERT INTO bwo_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Manots, na'i mac'uwotsnat s'aats ishiru na'i induwotssh indowe boosha! datsatse kic'i gondo wotituwe, ash manotsatse Ik'i fayo weetuwe. ");
INSERT INTO bwo_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Boyitsnowere ayuwots shik goradon úd'etuno, katsuwotsuwere kisho imr dats datsats dametuno, Ik'i ash woterawwots dúro b́ s'uufetsosh Iyerusalem Ik'i ash woterawwotsn net'etk wotitwaniye.» ");
INSERT INTO bwo_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Manats dabt Iyesus hank'o bíeti, «Aawonat aashitson, k'enuwotsatsnoor adits milikituwots be'etúno, datsatsnowere ash jamwots aats k'aronat b́ jongo tek'iyiru k'aratse tuutson sharr kic'ituno. ");
INSERT INTO bwo_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Datsats weet keewo kotoke ashuwots shatoon k'ewitúnee, manoor daritsi angwots shek'etúno, ");
INSERT INTO bwo_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Maniye hakon Ash na'o angi eenonat dawunots wotde'er b́waafere ashuwots bek'etúno. ");
INSERT INTO bwo_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Jamanots woto de'e botuwor it kashit aawo b́ bodtsotse dambaan kaaw de'er s'iilere.» ");
INSERT INTO bwo_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Manats dabt Iyesus jewurets keewuman boosh b́ keewu, «Belesi mitonat k'osh mituwotsi t'intsde s'iilere, ");
INSERT INTO bwo_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bo maaro ato de'e b́tuwo it bek'tsok'on k'aawo b́ t'intsok'o danfte. ");
INSERT INTO bwo_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mank'oon jaman woto de b́tuwo it bek'or Ik'i mengsto wosh b́karntsok'owo dande'ere. ");
INSERT INTO bwo_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","«Ariko itsh keewirwe, jaman b́ s'eenfetso and dúri s'oot'an besheratse. ");
INSERT INTO bwo_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Daronat datson beshitune, t keewonmo besheratse.» ");
INSERT INTO bwo_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Manats dabt Iyesus hank'o b́ et «Móónat úshi ayon, mashon, ay finon maawonat datsatsi beyosh kic'on it nibo ay b́ maawrawok'o it atso korde'ere! Maniye okoon aawuman kambok'o gawerawon iti deshdek'etwe. ");
INSERT INTO bwo_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Manots aawuman datsatse daatset ash jamwotsi gawerawo kambok'o deshdek'etwe. ");
INSERT INTO bwo_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mansh, weet gond keewu jamatse oorosh ango it daatsituwok'o aani Ash Na'o shinatse ned'osh it falituwok'o jam aawo Ik' k'onoke kup'ore.» ");
INSERT INTO bwo_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Iyesus aaw aawon Ik'i mootse b́ daniyfo, datso b́ ilor Debrezeyit gurats kede b́ k'eefoni. ");
INSERT INTO bwo_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ash jamo Iyesusi k'ebosh guuron Ik'i mootsere b́ maants bo amfoni. ");
INSERT INTO bwo_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Faziga eteets tush meyi bali ááwo mangiyef aawo t'inre b́tesh, ");
INSERT INTO bwo_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","K'eesi naashuwots naet Muse nemo danifuwots ash asho boshattsosh Iyesusi deshde boud'it malo ááshon bogeyiri botesh. ");
INSERT INTO bwo_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Manoor b́ woshtswots tatse gituwotsitse iko Kiriyot dats asho Yihud atsots Shed'ano kindbwuts. ");
INSERT INTO bwo_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Mansh Yihud kahniwotsnat Ik'i maa kotfuwotsi jishfok amt Iyesusi awuk'o k'alr boosh beshide b́ imetwok'o bonton b́ keeweyi. ");
INSERT INTO bwo_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bowere keewmansh gene'uwat gizo bísh imosh keewe bowuts. ");
INSERT INTO bwo_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Bo keewets wulimańnowere wotowe ett ash asho b́ danawo Iyesusi beshi de'er imosh k'anit aawo b́geyiri. ");
INSERT INTO bwo_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Maniye hakon fazigi mereero shukeet tush beno meyi Ik' aawo bod b́guuts. ");
INSERT INTO bwo_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Iyesus «Fazigi kooc' misho nometwok'o amr k'aniwere» ett P'et'rosnat Yohansn woshbk'r. ");
INSERT INTO bwo_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bowere «Fazigi kooc' misho aawoke no k'aniyetwok'owe n geyi?» ett bínboaati. ");
INSERT INTO bwo_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Bíwere boosh hankowa bíet, «Kituts it kindor aats kitef koro kuriru asho daatsitute, b́ shuutso shoyde b́ kindit moots ameree. ");
INSERT INTO bwo_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Moo doonzsh, noon danifo ‹T danifuwotsnton fazigi kooc' misho t metuwoko ibi kashef moo aawoke? etfe› erere bísha. ");
INSERT INTO bwo_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Bíwere dadirotse fa'a es'dek't k'aniyets maa gawuno itsh kitsituwe, manoke k'aniwere.» ");
INSERT INTO bwo_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","B́ danifuwots amt, jam keewo Iyesus ettsok'o wotat b́datseyi, fazigi baaliyo noowere manoke bok'aniyi. ");
INSERT INTO bwo_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kooc'misho b́ bodtsok'on Iyesus b́ woshtswotsnton mishi marats beeb́dek'i. ");
INSERT INTO bwo_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Hank'owa boosh biet, «Godbek'o tiats b́ bodftsere shino itnton fazigi koc'mishan moosh ayidek'atni t tewunfoni b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Keewan Ik'i mengstotse arik wotar bbe'efetsosh haniye hakon Fazigi koc'mishan b́ jamon maratse etiruwe itsha?» ");
INSERT INTO bwo_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Maniye hakoń Iyesus úshi wanc'o k'aau dek't Ik'o b́ údiyakon hank'o biet, «Nayere han kayde'ere, ");
INSERT INTO bwo_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","arikon itsh keewiruwe andon de'etuwr Ik'i mengstu bwafetsosh weyini shuwanatse daatsets usho uyatse.» ");
INSERT INTO bwo_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Iyesus manats dabt misho k'audek't Ik'o b́ údiyakon, b́ danifuwotssh «Nayere, han itsh imetuwo tmetsoniye, han taan gawosh woshde'ere» ett bí im. ");
INSERT INTO bwo_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mank'o koc'mishoniye okoon ushi wanc'o k'aaúdek't imt boosh hank'o bíet, «Ushe wanc'an it jangosh kud'itwo t s'atsoniye bíats ned'iyet handr taaroniye. ");
INSERT INTO bwo_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«Ernmo taan beshide imetu asho kisho hamb taanton mishi marotse. ");
INSERT INTO bwo_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ash Na'o b́ jangosh shin keewetsok'on k'irituwe, ernmó Ash Na'o beshide imetu ashmansh indowe bísha!» ");
INSERT INTO bwo_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bowere «Noyitse keewan k'alituwo kone?» ett boatsatsewo moosho dek'botu. ");
INSERT INTO bwo_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Manats dabt bo, «Nounetsitse bogo kone?» ett moosho dek't botuu. ");
INSERT INTO bwo_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Iyesusmó hank'o boosh bíeti, «Ik' ash woterawwots naashuwots ash ashaatse alo detsfne, dats keewtswotswere ashosh sheeng k'alfwotsi etetuwe, ");
INSERT INTO bwo_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Itmó bokok'o woto itsh geyiratse, maniyere ititse een wottso b́ beyal muk' wotowa, jishtsi wottso guutsok'o wotowe. ");
INSERT INTO bwo_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mishimarats bedek't meyiruwonat need'dek't manziruwotse awune enoni? Eena eteefoni mishi maratse bedek'tsoniyoshna? Taamó it dagotse guutsok'o taane. ");
INSERT INTO bwo_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","It taa gondo tbek'or jamon taanton kup'atniye it teshi. ");
INSERT INTO bwo_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mansh t nih taan b́ naashitsok'o taawere it naashituwe. ");
INSERT INTO bwo_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","T mengstotse mishi maratse bede'er meetute, úshetute, naashi jooratse bede Isra'el naar tatse gituwotsats angshitute.» ");
INSERT INTO bwo_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Manats dabt Iyesus hank'o bíet, «Smonoo! Smonoo! hmb, goshtso b́ sndeyi buyo as'de b́ galfook'o Shed'ano iti as'baze b́geyi. ");
INSERT INTO bwo_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ernmó ni imnetiyo b́ t'afrawok'o taa neesh Ik'o k'onituwe, ando aani ni anorowere nieshuwotsi kup'iwe.» ");
INSERT INTO bwo_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","P'et'roswere «Doonzono! tip wotowa, k'ir wotowa neenton amoosh k'ank taane!» bíet. ");
INSERT INTO bwo_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Iyesusmó aniydek't, «P'et'rosoo! hambets baako b́ k'adfetsere, ‹Neen danatse› err keezoto taan haalitune etfe» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Maniye hakon Iyesus b́ danifuwotssh, «Gizosh k'arc'ito, borso, c'amono it kishatse alo iti t woshor itsh shaptso fa'a b́teshi?» boosh bí et. Bowere «Eegor noosh shapts keewo aaliye» ett bísh boaaniy. ");
INSERT INTO bwo_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Iyesuswere boosh aaniy hank'owa biet, «Andmó gizo, borsono detstso, k'aau de'e, shiki gorado deshawonwere b́ taho kemr shiki gorado kewude'e ");
INSERT INTO bwo_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","T jangosh shin guut'ets jamo fin isho bgeyitsotse ‹Gondwotsnton taawere› etiruwo S'ayin mes'afotsi keewo ti atse wot b́ s'uwo geyife etre itsha.» ");
INSERT INTO bwo_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","B́ danifuwotswere «Doonzono! hamb git shiki goraduwots fa'ane!» bo eti. Bíwere «bodfne!» boosh bíet. ");
INSERT INTO bwo_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iyesus kitutse kesht b́ doyok'o Debrezeyit guromants bíami, b́ danifuwotsuwere bínton boam. ");
INSERT INTO bwo_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Manok bobodtsok'on Iyesus, «Fadeyots it kindrawok'o Ik'o k'onuwere» bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Maniyehakon shúts sha'ubetsok'o boatse wokdek't bíam, tuk'mal dek't hank'o ett Ik'o b́k'on, ");
INSERT INTO bwo_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Nihono! nshunka wotiyale tiats bodosh etiru kic'i wanc'an tiatse wokiwe, ernmó nee niettsok'owabako taa tiettsok'o wotk'aye.» ");
INSERT INTO bwo_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Manoor bin kupiit melakiyo darotse waat́ bíats be'e b́wutsi. ");
INSERT INTO bwo_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","B́ nibotsnowere ayidek't kic'efetst kup'idek't Ik'o b́k'oniri b́teshi, b́s'azonuwere s'atsok'o wotat datsatsa b́s'oriri b́tesh. ");
INSERT INTO bwo_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ik' b́ k'onirwoke tuut b́ danifuwotsok b́waa, ayi dek't boshiyantsatse tuutson nefat k'eewutsat bobefere wadatst boosh hank'o bíet, ");
INSERT INTO bwo_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","«Eegishe it k'eyiri? Maniyere fadeyots itkindrawok'o tuur Ik'o k'onuwere.» ");
INSERT INTO bwo_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iyesus man keewoke b́befere, ay ashuwots waa bokesh, boon jishiruwonuwere tatse gituwotsits wottso iko Yihudi b́tesh, Yhud bín jobosh b́ maants t'nb́dek'. ");
INSERT INTO bwo_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Iyesusmó «Age Yhudo! Ash Na'o jobon beshide imisheya?» ");
INSERT INTO bwo_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Iyesusnton teshts b́danifuwots keewuan b́ wottsok'o bobek'tsok'on «Doonzono! shiki goradon jod'onowa?» bo et. ");
INSERT INTO bwo_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Boyitsnowere iko kahni naasho guutso shiki goradon k'es'dek't b́k'ani waazo k'ut'b́k'r. ");
INSERT INTO bwo_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Iyesusmo «K'aye! hank'o keewo aani k'alk'aye!» bí et, Asho wazonowere shu'udek't kashi b́k'ri. ");
INSERT INTO bwo_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Maniye hakon Iyesus bin detsosh waats k'eesi naashuwotsi, Ik' maa kotfuwotsatsi altsuwotsnat ashitsi eenashuwotsnsh hank'o bí et «Taan wombedewok'o detsoshe shiki goradonat gumbo dek'atniya it weyiri? ");
INSERT INTO bwo_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Aawu aawon itnton Ik' mootse t daatsewor taan t teshor, andmo it aawonat t'aluwotse altsosho bo ááwe.» ");
INSERT INTO bwo_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Maniye hakon ash ashuwots Iyesusi detsdek't k'eesi naasho mook dek't bowaa, P'et'rosuwere wokoon b́shuutso b́ shi'iri. ");
INSERT INTO bwo_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ash ashuwots kas'otse tawo deshidek't ikoke bedek'tni botesh. P'et'oswere waat towat be b́dek'i. ");
INSERT INTO bwo_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","P'et'ros tawu ganok b́befere gon iku tawu shanatse bek'bk'ri, b́ maants t'iwintsdek' s'iilat «Hanwor Iyesusntoni b́teshi!» bi et. ");
INSERT INTO bwo_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","P'et'rosmó, «Nee ashune! taa bín danatse!» jamere bí et. ");
INSERT INTO bwo_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Muk'i tesht k'osh ash iko P'et'rosi bek't «Neewor boyitsi iko neene!» bí et. P'et'rosmó «Ashono neena! taanaliye!» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ik sa'atok'o tesht k'osh ash iko P'et'rossh «Ashaahan Gelil dats ash b́wottsotse arikon bíntoniye b́teshiye!» ett kup'idek't b́ keewi. ");
INSERT INTO bwo_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","P'et'rosmó, «Ashono neena! ni etiruman danatse!» bí et. Man keewoke b́befere manoor baako b́ k'adi. ");
INSERT INTO bwo_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Manoor doonzo Iyesus wongr ett P'et'rosi b́ s'iil, P'et'roswere «Hambets bako keezoto b́k'adfetsosh taan danatse er haalitune» ett doonzo Iyesus b́ keewutso gawubdek'i. ");
INSERT INTO bwo_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Urats kesht ayidek't bí eep. ");
INSERT INTO bwo_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Manoor Iyesusi detsdek't teshts ashuwots bíyats trgic'o kashfetst bín botogiri. ");
INSERT INTO bwo_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","B́ shitsonowere p'urifetst, «Kone neen togtsoni? Nebiyi nwotiyal aab dane?» boetfera botesh. ");
INSERT INTO bwo_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bíats ay keewo keewufets bín boc'ashiri botesh. ");
INSERT INTO bwo_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Gatsb́wutstsok'on dats naashuwots, kahni naashuwots, Muse nemo danifuwots ikok kakuwebogutsi, Iyesusnowere jebats dek'bowa. ");
INSERT INTO bwo_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Hank'o ett bísh bokeewu «Ab nee Krstos neena wotiyal noosh keewwe,» Biimo boosh hank'owa bíet, «Itsh t keewiyalo taan amaneratstere, ");
INSERT INTO bwo_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Iti tiatiyalo taash aniratsteree, ");
INSERT INTO bwo_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ernmó haniyehakon Ash na'o kup' Ik'o k'ani aaromand bedek'etuwe.» ");
INSERT INTO bwo_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jametswots Ik wotdek't «Eshe nee Ik'o naay neeneya?» et bo aati. ");
INSERT INTO bwo_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bowere «Eshe eeg gawe noosh b́ geyiti? Hamb b́ nonatse keshtso no notokon shishrone!» bo et. ");
INSERT INTO bwo_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Maniye hakon manoke kakuwedek't beyiru ash ashuwots dek' amt P'ilat'os shinats t'intsbok'ri, ");
INSERT INTO bwo_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Hank'o ettnwere bín s'aamiyo dek' botuwi, «Ashaan no ashuwotsi b́shelifere daatsrone, Rom nugúsoshowere ereero dasherawok'o bazife, ando ‹Taahe nuguso Krstos taane› ettniye b́ keewiri.» ");
INSERT INTO bwo_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","P'ilat'oswere «Ayhudiwots naasho neeneya?» ett Iyesusi bíaati. Iyesuswere «Nee niettsok'oyiye» bí eti. ");
INSERT INTO bwo_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Manoor P'ilat'os kahani naashuwotsnat ash ashosh «Ashaanatse eegor t'afiyo daatsratse» bí et. ");
INSERT INTO bwo_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Boomó «Ashaan Geliln b́detstso hanok b́borfetsosh, Yihud dats jamatse daniyfetst ash asho boatsatseyo bofayetuwok'o b́ woshiri» etfetst kup'shdek't bos'aamiyi. ");
INSERT INTO bwo_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","P'ilat'os Gelili eteets shútsman b́ shishtsok'on, «Ashaan Gelil dats asheya?» ett bíaat. ");
INSERT INTO bwo_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Iyesus b́ waa Herodis alts datsatse b́ waatsok'o b́ dantsok'on Herodisok damibk'ri, Herodisuwere manoor Iyerusalemitsa b́tesh. ");
INSERT INTO bwo_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodisuwere Iyesusi b́bek'tsok'on ayidek't gene'úb́guts, Iyesus jango b́shishtsotse bín bek'ono ayoto tewuntni b́teshi, mank'o Iyesus adits finuwotsno b́ finefere bek'oshor b́geefotsna. ");
INSERT INTO bwo_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Mansh Herodis Iyesusi ay keewo bíaat, Iyesusmó bísh eegor aaniratse. ");
INSERT INTO bwo_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kahni naashuwotsnat Muse nemo danifuwots manoke need'dek't kup'idek't bín bos'aamiri. ");
INSERT INTO bwo_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodis b́ jirwotsnton bíats trgic'o b́ kaash, tahi sheengonowere bíats takdek't P'ilat'osok aani dek't damib́k'r. ");
INSERT INTO bwo_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herodisnat P'ilat'osn maniye shin balngar teshtswots manots aawots jagebowutsi. ");
INSERT INTO bwo_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Maniye hakon P'ilat'os k'eesi naashuwotsi, ash jishfuwotsnat ashuwotsi dabdek't iknon b́ s'eegi, ");
INSERT INTO bwo_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Hank'owere boosh bí et, « ‹Ashuwotsi bo fayetuwok'o b́ tuuziri› etaat ashaan t maants dek'at it weyi, taawere hamb it shinatse aatat tiere it etts jam weeron ashaanatse ik t'afiyonor daatsratse. ");
INSERT INTO bwo_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Mank'owere Herodiswor bíatse b́ t'afitso ikonor b́ t'ut'tsotse nomand aani dek't doyik'rere, eshe ashaanatse k'irosh bín betsit keewo ikonor bíatse daatsratse. ");
INSERT INTO bwo_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Manshe garafarniye bín faksh t k'ritiye.» ");
INSERT INTO bwo_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Dúre dúron Fazigi bali aawots P'ilat'os tipitsi ashuwotsitse iko ashuwotssh b́ fakshfotsna. ");
INSERT INTO bwo_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mansh ash jamo «Ashaan no ááwatse ok t'afiwe! Berbannmo biishde fakshk'rowe noosha!» et fetst ik k'aaron bokuhi. ");
INSERT INTO bwo_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Berban kitutse dimbro tuuzt ashono ud't manatse tuutson tip moots tipek asha b́tesh. ");
INSERT INTO bwo_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","P'ilat'os Iyesusi bíshde faksho geyat́ aani ash ashuwotssh b́keewu. ");
INSERT INTO bwo_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ashuwotsmo «Bín jirk'rowe! jirk'rowe bína!» ett bokuhi. ");
INSERT INTO bwo_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","P'ilat'osuwere keezlo boosh hank'o bíet, «Ashaan b́ t'afitso b́jamon eebi? Taa k'irosh bín betsit keewo eegor bí atse datsratsere, manshe garafarni faksh tk'riti.» ");
INSERT INTO bwo_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Boomó bok'aaro eenshdek't «Jiir k'rowe bína!» ett bokuhi, ashuwotsnat k'eesi naashuwots k'aaro ayidek't enbgutsi. ");
INSERT INTO bwo_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Manatse tuutson bo aattso boosh k'aletuwok'o P'ilat'os angsh b́k'r. ");
INSERT INTO bwo_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Galotse asho beezo bazt ando asho úd't bíere tipt teshetso Berbani bo aattsok'on fakshb́k'ri, Iyesusnmo boshuntsok'on boosh beshidek't imb́k'r. ");
INSERT INTO bwo_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mann Iyesusi dek't boami, dek't boamfere K'erena eteets datsi ash wottso Simoni gat'ariyon kito maants b́kindfere dats bodek'i, bín detsdek't mask'aliyo Iyesusko kuridek't Iyesus shuutso shoyde b́shaituwok'o bo k'ali. ");
INSERT INTO bwo_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ay ashonwere Iyesus shutsats shoydektni boamir bítesh, bodagotsno bo gero jot'fetst eepiru maats maatsuwots fa'ano. ");
INSERT INTO bwo_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iyesusmó bomaand wongr ett hank'o boosh bíet, «It Iyerusalem dats máátsuwotso! it tokonat it na'osh efere bako taash eepk'ayere! ");
INSERT INTO bwo_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","‹Mahan wotts máátsuwots, shurawu maac'wotsnat s'aatsrawu s'atsuwots awuk'o derekno!› eteet aawwots weetúnee. ");
INSERT INTO bwo_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Manoor ash ashuwots gúrwotssh, ‹No abaats grshore!› guri teuwotsshowere ‹Noon atsuwore!› eto deebotuwiti. ");
INSERT INTO bwo_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Miti motsats hank'o keewu jaman k'aletka wotiyal eshe miti shuk'onmo awuk'owek'uwa k'aleti?» ");
INSERT INTO bwo_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mank'owere gond finets git ashuwotsi Iyesusnton úd'osh dek't boami. ");
INSERT INTO bwo_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Took k'ola wee K'araniyo eteef beyokok bobodtsokon manoke Iyesusi jitbok'ri, mank'o gond finets ash gitwotsi iko Iyesus giromaants iko b́ k'anomaants jitbok'ri. ");
INSERT INTO bwo_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Maniyehakon Iyesus, «T niho! bo k'aliruwo bodanawotse boosh orowa eree!» bíet. Kes' kes'fuwotsu Iyesus tahats it'o oorsht kaybodek'i. ");
INSERT INTO bwo_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ash ashonwere need'dek'tni bos'iliri botesh, Ayhudi naashuwots uwere «K'oshuwotsnoó worire and eshe bí Ik'i futtso Ik'o b́tokosh marat'bdek'tsoni wotiyal aab b́ tooko woriwe!» etfetst́ bíts bokaashi. ");
INSERT INTO bwo_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kes' kes'fuwotswere mank'o bíatsa bokashfera botesh, b́maand t'int bíro ayidek't shashtso boimi. ");
INSERT INTO bwo_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Bowor mank'o «Nee arikon ayhudiwotsko naasho nana wotiyal aab n tooko woride'e!» boetiri. ");
INSERT INTO bwo_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","«Ayhudiwotsko naasho haniye» ett guut'etso Iyesus jitetsi k'oyats gedbok'ri. ");
INSERT INTO bwo_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Iyesusnton jitets gond finetsuwotsitse iko, Iyesussh, «Nee mesihiyo nenoshna? Aab eshe n tokonat noon woriwe!» ett bín b́ c'ashfera b́tesh. ");
INSERT INTO bwo_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Boyitse ikonmó bín hank'o ettni b́fay, «Neewor bíki naari angshotse bedek'at Ik'o sharatsiya? ");
INSERT INTO bwo_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Noo nofints morratse tuutso noosh wotit fayo daatsrone, ashaanmó eegonor t'afiyo deshatse.» ");
INSERT INTO bwo_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Manats dabt Iyesussh, «Doonzono! n mengstots n woor taan batk'aye.» bíet. ");
INSERT INTO bwo_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Iyesuswere «Ariko neesh keewiruwe, hambets taanton genetotse daatsetune» bíet. ");
INSERT INTO bwo_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Man b́wotuwe aaw shrt sa'atok'ona b́tesh, manortson tuut jed'iy sa'ato b́borfetsosh datsjamatse t'alu wotb́gutsi. ");
INSERT INTO bwo_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Aawo t'aluwu b́wutsi, Ik'i meyitsi magarajo taalotse dek't tuut gaad'at gitoko kayb́gutsi. ");
INSERT INTO bwo_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iyesuswere b́k'aaro eenshdek't, «Nihono! hambiye! tkashu nkishats beshidek'at adaro imiruwe!» bí et, man bíettsok'on b́ kasho bíatsotse k'azb́kesh. ");
INSERT INTO bwo_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Manoke teshts bali naash wottso, wotts man b́bek'tsok'on «Arikon ashaan kááwe b́teshi!» ett Ik'o b́ mangiy. ");
INSERT INTO bwo_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Wotit keewo s'ilosh manoke kakuwedek't teshts ash jamo wotts keewuman bobek'tsok'on bo gero k'is'fere bo galomand k'azboaani. ");
INSERT INTO bwo_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Iyesusi karnon dants ash jamwotsnat Galil datsatse tuut b́shutsatse sha'efere waats máátswots wokoon need'dek't keewan bo s'iliri. ");
INSERT INTO bwo_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ayhudiwots kitt wotts Armatyasitse befo Yosefi eteef asho fa'e b́tesh, bíwere kaawonat ash sheenga b́tesh, ayhudiwotsitse moosh moshifuwotsitsi ikoni. ");
INSERT INTO bwo_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Wotowa ereo ayhudiwots shiyewonat t malots kindratse b́tesh, bí Ik'i mengsto kotiru asho b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ashman P'ilat'osok t'int Iyesus duuno bísh b́ imish bíaat. ");
INSERT INTO bwo_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Dunonowere orshdek't hariya eteef c'ic'i dek't wozets tahon k'odbok'ri, ash k'osho konuwor bíts b́ dukerawu s'alatse k'ewudek't k'aniyets doowots duukb́k'r, ");
INSERT INTO bwo_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Man b́k'aluwere kokowots kooc' Sanbatosh k'anoke beyefera b́tesh. ");
INSERT INTO bwo_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Geliln tuut Iyesus shuutso waats máátswots Yosefnton amt b́ doowo bo s'iili, duunono awuk'o k'aldek' duuktsok'oi bo s'iil. ");
INSERT INTO bwo_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bogalomandowere aanat duunosh wotit shak' shawu wotts k'memiyonat shituwo k'ani bok'r, bo nemok'on sanbati aawots kashdek't bojin. ");
INSERT INTO bwo_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mááts máátsuwots bok'anits shituwo dek't torbanotsi shints aawots (sanbat eenots) datsgatson dowomand boami, ");
INSERT INTO bwo_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Doowo ipets shútso dowatse okaan kukulwutsat b́befere bodaatsi. ");
INSERT INTO bwo_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","B́ gitsots bokindormo doonzo Iyesus duuno daatsratsno. ");
INSERT INTO bwo_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Keewuman jangatse bok'alituwo dart adoke bobefere aawok'o goliru tah tahdek'ts ash gituwots waa boganok need' boguts. ");
INSERT INTO bwo_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mááts máátsuwots ayidek't shatwtsat bo tooko dashan gup'ndek't bobefere ashuwots, «Eegishe kashetso k'irtsuwots dagotse it geyiri? Bosh boet. ");
INSERT INTO bwo_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Bíwo hanoke aaliye, tuure, Gelilin b́teshor itsh b́ keewutso gawude'ere, ");
INSERT INTO bwo_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‹Ashna'o morretsuwotssh beshide imewo, jitewonat keezl aawotsowere k'irotse tuwo bín geyife› etre b́teshi.» ");
INSERT INTO bwo_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mááts máátsuwotswere Iyesus keewuts keewo gawu bodek'i, ");
INSERT INTO bwo_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Doowoknowere aanat jaman tatse ikuwotsnat ortswotsnishowere bo keewu. ");
INSERT INTO bwo_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Hanowere b́ woshtswotssh keewtsuwots megdela eteets datstsu Mariyamna, Yohannat Yak'ob ind Mariyamna, mank'o mááts k'oshuwotsu fa'ano botesh. ");
INSERT INTO bwo_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Boomó keewman boosh gúmo bíartsosh boon amaneratsno. ");
INSERT INTO bwo_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ernmó P'et'ros tuwut doowo maantsan b́ wos'i, manok b́ bodiyakon túmt b́s'ilor duunats takets duuni taho hariyon wozets taho biyl b́ befere b́ bek', wotts keewu manatse tuutson adfetst b́ moo maants k'az bían. ");
INSERT INTO bwo_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Manots aawots Iyesus shuutso shaefwotsitse gitetsuwots Iyerusalematse tatse git kilometrok'o wokat fa'u Emahusi err s'eegef galomand bo amiri. ");
INSERT INTO bwo_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bowere wotts keewu jamman tuzt bo atsatsewo bo keeweyiri botesh. ");
INSERT INTO bwo_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Manowere bo keewor Iyesus b́ tookon bo maants t'int bonton sha'o dek't b́tuwi. ");
INSERT INTO bwo_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Eree bo aawon bek'fetst koni b́wottsok'o dano falratsno. ");
INSERT INTO bwo_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Bíwere, «Sha'efetsat it keeweyiru keewhan eeb naaroni?» boosh bí et. ");
INSERT INTO bwo_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Boyitsi iko K'elyop'i eteefo, «Daganitse Iyerusalemitse k'aleets keewuwotsi danawu ib asho n s'uzneya?» bísh bíet. ");
INSERT INTO bwo_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Iyesuswere «Eebi b́ naaroni?» bí et. Bowere hank'o ett bísh boaaniy, «Nazrettso Iyesus atsats bodts keewoni! bí Ik'onat ash jami shinatse keewonat finon kup' wotk Nebiye b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kahani naashuwotsnat noon jishiruwotsn k'irosh beshi dek't bo imi, bínowere bo jiti. ");
INSERT INTO bwo_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Noomo ‹Isra'eli fariytwotuwo bíne› etaat no jangirwo bíne b́teshi. Wotowa eree jam keewan b́ wotiyakon hamb keezl aawoniye. ");
INSERT INTO bwo_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Eree noyitse fa'a mááts máátsuwotsitse ik ikuwots noon adirne, bo hamets guur b́ doowo maants amtni botesh, ");
INSERT INTO bwo_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ernmó b́ duuno daatsratsno, ‹Iyesus beyar beetke!› etiru melakiwotsi bek'on no bek'iye ett aanat bowaa. ");
INSERT INTO bwo_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Noyitsnowere ik ikuwots b́ doowo maants amt mááts máátsuwots ettsok'o wotat bíere bodaatsi, Iyesusnmo be'aatsno.» ");
INSERT INTO bwo_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Iyesuswere hank'owa boosh bíet, «It t'iwintsrawanotsna et Nebiyiwots keewuts jamo it amaneraok'o it nibo shuutso maants getseyiruwanots! ");
INSERT INTO bwo_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Krstos gond bek' jamań de'er b́ mango maants kindo bín geyiyalkeya?» ");
INSERT INTO bwo_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Maniyere hakon Musena et Nebiyiwots mas'afatse dek' tuut S'ayin mas'aaf jamotse b́ jangosh keewetso kitsfetst boosh kish b́keewi. ");
INSERT INTO bwo_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bo boamiru galok bo t'intsok'on Iyesus beshar ametuwok'o bíari. ");
INSERT INTO bwo_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Boomó, «Datso ilere, aawunuwere iloshe bíetiri, mank'o b́wottsotse noonton hanok k'ewe» ett kup'idek't bín bok'on, mank'o b́wotere bowok k'eyosh bo moots b́kind. ");
INSERT INTO bwo_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Bonton mishimarts beeb́dek'i, misho k'a'údek't Ik'o b́ údiyakon tiitsdek't boosh b́imi. ");
INSERT INTO bwo_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Manoor bo aawo k'eshe b́uutsere Iyesusi b́ woto danbok'ri, bímo manoor boawatse ááshb́gutsi. ");
INSERT INTO bwo_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bowere boatsatsewosh «weerindatse no sha'efere noosh b́keeworonat S'ayn mas'aafwotsitse kitsfetst noosh b́ keewor no nibotse tawok'o biat'eferoshna b́teshi?» bo atsatsewosh boet. ");
INSERT INTO bwo_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bowere manoor tuut Iyerusalem maants aanat k'azboam, manokno b́ danif tatse ikuwotsi bonton fa'uwotsnton ikn kakuwedek't bo befere daatsbodek'i. ");
INSERT INTO bwo_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bowere «Doonzo Iyesus arikon k'azturee! Sm'onshowere be'ere!» boetiri. ");
INSERT INTO bwo_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","B́ daniru gitetsuwots bo tookon weerindatse wotts keewonat doonzo Iyesus misho b́ titsor aawok'o k'alt bodantsok'o bo keewi. ");
INSERT INTO bwo_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bowere han keewoke bo befere Iyesus b́ tookon botalots need'dek't, «Jeeno itsh wotowe!» bíet. ");
INSERT INTO bwo_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Boomó meyo bobek'tsok'o boosh bíarere tek'at shatoon s'eenbowtsi. ");
INSERT INTO bwo_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Iyesuswere hank'o boosh bíet, «Eegishe it tek'iri, eegishe it nibotse amano it k'aziri? ");
INSERT INTO bwo_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tkishuwotsnat ttufwotsn taan t wotk'o danere, taan shu'ar s'iilere, tiatse it s'iliruwok'o meyo meetsonat mak'tson deshatse.» ");
INSERT INTO bwo_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Hank'o ett b́ tufonat b́ kishon boosh b́ kits, ");
INSERT INTO bwo_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bowere gene'onat aydek't aa'doke bobeyruwotse andoru amanerafa'no bo teash. Iyesuswere «Meetuwo it detstso fa'a?» ett boon bíaat. ");
INSERT INTO bwo_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bowere mus'o mistetsu muk'na'ú bísh boim. ");
INSERT INTO bwo_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Bíwere k'aaú dek't bo shinatse b́maa. ");
INSERT INTO bwo_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Iyesuswere, «Itnton tteshor Musesh imets nemo, Nebiyiwotsnat t Duubi mas'afatse t jangosh guut'etso jamo s'eeno bin geyituwe etaat itsh tkeewutso haniye» bíet. ");
INSERT INTO bwo_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Maniye hakon s'ayin mas'aafwotsi t'iwintso bofalituwok'o bo nibo boosh k'eshb́k'r. ");
INSERT INTO bwo_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Hank'owo boosh bíet, «Krstos gondo b́bek'etuwok'owonat keezl aawotso Kirotse b́ tuwituwok'o shin guut'ere, ");
INSERT INTO bwo_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Mank'o b́ shútson naadre etonat morrosh orowe eton Iyerusalemiyere tuur dats jamatse ash jamosh b́ nabitwok'o guut'ere. ");
INSERT INTO bwo_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Itwoor jam keewansh gawu itne, ");
INSERT INTO bwo_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Hambe! taa t nih itsh imetuwe ett b́ jangitso itsh deyitwe, itwere dambe ango tahok'o tah itdek'fetsosh Iyerusalem kitutse betere.» ");
INSERT INTO bwo_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Maniye hakon Iyesus b́ danifuwotsi Iyerusalem kitutse kishdek't Betaniyi datsats b́ borfetso dek't bíam, manoknowere b́ kisho jargdek't boon b́deeri. ");
INSERT INTO bwo_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Boon deroke b́beyiruok'on boatse k'aleyat daromaand k'az b́tuu. ");
INSERT INTO bwo_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bowere bísh bosagadi, geneeúfetst Iyerusalem maants k'az boaani. ");
INSERT INTO bwo_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ik'onowere údefetst aawu aawon Ik'i mootse t'ut'uerakne boteshi.");
INSERT INTO bwo_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Shin shin aap'o fa'e b́tesh, aap'onwere Ik'oke b́ teshi, aap'manwere Ik'e b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Bí shin shin Ik'ontoni b́ taash. ");
INSERT INTO bwo_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Jam keewo bína bí azee, azeets jamotse ikonwor bí bíazrawo azeetso aaliye. ");
INSERT INTO bwo_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Bíyoknowere kasho fa'e b́ teshi, kashanwere ashuwotssh sháána b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Shááno t'aluwats c'eeshitwe, t'alwonu shááno da'aratse. ");
INSERT INTO bwo_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ik'oke wosheetso Yohanisi eteets ash iko fa'e b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","B́ gawts gawon jamo bíamanitwok'o bí shááni jangosh gaw wotat b́weyi. ");
INSERT INTO bwo_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Bíwere shááni jangoni gawosh b́ weyi bako bí b́tookon sháánaliye. ");
INSERT INTO bwo_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ash jamwotssh c'eshitwo ariko wottso shááno dats jamwats woke b́ fa'oni. ");
INSERT INTO bwo_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Bíwere datsanatse b́ teshi, datsanwere bí'azee bíne, datsanmó bín danatsane. ");
INSERT INTO bwo_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","B́ik wottswotsok waare, b́ jirwotsmó bín de'atsne. ");
INSERT INTO bwo_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Wotowabako b́ keewu dek'tswotsnat b́ shútson amants jamwots Ik'o nana'uwotsi bowotitwok'owe alo boosh b́mi. ");
INSERT INTO bwo_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bowere Ik'atse shuwekno bako ash naaratse, man etonwere meetsi shnunon wee nungshe mááts gonkewon shuweratsne. ");
INSERT INTO bwo_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Aap'onu meets wotere, s'aatonat arikono s'eent no dagotse beere, b́ nihoke waats ik s'uz na'o mangok'o wottso b́ mangonowere bek'rone. ");
INSERT INTO bwo_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohanswere «Ekeew taayere il weyirumań taayere shin fa'o b́teshtsotse taayere ayidek't bogfe etaat itsh tkeewtsoniye haniye,» ett kuhat b́keewi. ");
INSERT INTO bwo_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","B́ s'eenatse no noúnets s'aatats s'aato dek'rone, ");
INSERT INTO bwo_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nemo Muse weerone imeyi, s'aatonat aronmo Iyesus Krstos weerone b́ weyi. ");
INSERT INTO bwo_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","B́jamon Ik' bek'tso konwor aaliye, wotowa eree Ik'o niho sheetsotse fa'a ik s'uzo b́naayi, bíwere Ik'wottsoni noosh kish kitsiye. ");
INSERT INTO bwo_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ayhudi naashwots Iyersalemitsi kahniwotsnat Lewawino etefwotsn Yohansok woshat, «Kone nee?» ett boatiyor b́ imts gawo hank'oyiye. ");
INSERT INTO bwo_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Bí «Taa Krstos taanaliye» et b́ gawi bako gawo gawosh k'aze eraatse. ");
INSERT INTO bwo_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bowere «Beree nee kone? Eliyas neeneya?» ett bín boaati. Bíwere «Taanaliye» ett boosh bíaniyi. Bowere «Weetwe eteetso nebiyiwo neeneya?» bo et. Bíwere «bí taanaliye» bí eti. ");
INSERT INTO bwo_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Bowere «Beree konene? Noon woshetsuwotssh nokeewish n took jangosh aawk'owe nieteti?» bo eti. ");
INSERT INTO bwo_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Bíwere «Nebiywo Isayas b́ keewtsok'on Taa ‹Doonzo weero katsuwre› et fere worotse kuhiru asho k'aaro taane» bí eti. ");
INSERT INTO bwo_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ashuwotswere bo woshe ferisawiwotsi etefuwotsitsna botesh, ");
INSERT INTO bwo_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Beree, «Nee Krstosi wee Eliyasi wee weetwe eteets nebiyo woto nk'azihakon eegoshe n gupiri?» ett bínboaati. ");
INSERT INTO bwo_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohansuwere hank'o ett boosh bíaaniy, «Taa tgupirye aatsone, eree it it danawo it dagotse b́ ned'iriye. ");
INSERT INTO bwo_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Bí taayere ile b́ weetiye, taa b́ c'aami tipi joko bitsosh dab bodktanaliye.» ");
INSERT INTO bwo_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Man b́ wotwere Yohans b́ gupfoke Yordanos fokoniyere bak'etse Betani kitotsna b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Yatsok'on Yohans Iyesusi b́ maants b́waafere bek't hank'o bíet «Datsantsi morro k'aa'ubazetwo Ik'i mereero haniye! ");
INSERT INTO bwo_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","‹T shutsatse weyiru ekeew taayere shino b́ teshtsotse taayere ayidek't bogfe› ti ettsoniye haniye. ");
INSERT INTO bwo_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Taawor ttookish bín danaaktana b́tesh, ernmó Isra'el ashuwotssh b́ be'eyish taa aatson gupfere t weyi. ");
INSERT INTO bwo_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Manats dabt Yohans hank'o ett gawere S'ayin shayiro erkukundok'o darotse oot't biyats b́ k'ot'efre t bek'i. ");
INSERT INTO bwo_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Taawor bín danaktane, ernmó aatson tgupetwok'o taan woshtsoniye, ‹Shayiro ood'r bíats b́ beewor n bek'etwo S'ayin shayiron gupetwo bíne› ett taash keewi. ");
INSERT INTO bwo_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Tawor han bek're, bí Ik'o naayi b́wottsok'owo gawitwe.» ");
INSERT INTO bwo_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Yatsok'on Yohans b́ danif gitetswotsnton aani manoke need'dek'tni b́ tesh, ");
INSERT INTO bwo_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yohans Iyesus man weeron b́beshefere bek't, «Hambe! Ik'oko mereroni!» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yohans danif gitetswots Yohans man b́ keewfere shisht Iyesus shutsats shoydek't bo ami. ");
INSERT INTO bwo_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iyesus wongr et aanat s'ilbek't, «Eebi it geyiri?» bíet. Bowere, «Rebi! eewke n beefoni?» boet. (rebi etoni danifino eta.) ");
INSERT INTO bwo_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Bíwere, «Waa s'iilere» bí eti. Eshe amt aak b́byirwok'o bos'ili. Manots aawots bínton towat bojin, manwere aaw tatsi sa'atok'oyi b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yohans b́ keewts keewo shisht Iyesus shuuts amts b́ danif gitetswotsitse iko Simon P'et'ros eshu Indriyasi b́teshi. ");
INSERT INTO bwo_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Indriyas shin shino b́ eshu Sim'onok amt «Mesihiyo daatsdek'rone» bí et. (mesihiya eto Krstosi eta, wee fuuteka eta) ");
INSERT INTO bwo_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Maniye il Indriyas Sim'oni Iyesusok dek't b́weyi. Iyesuswere t'iwintsdek't s'iilt, «Nee Yona naay Simon neene, haniye hakonmo Keefi eteyar s'egetune» bíet. (Keefi etonmu: P'et'rosi wee shútsi s'ala etee). ");
INSERT INTO bwo_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Yatsok'on Iyesus Gelilmants amo b́gee, Flip'osi daatsdek't, «T shuutso shoy de wowe» bí eti. ");
INSERT INTO bwo_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Flip'os Indriyasnat P'et'rosnkok'o Bete Sayda eteets kitutsi asha b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip'os Natna'eli daatsdek't, «Muse nemi mas'afatse, nebiyiwots bek'i mas'afatse b́ jangosh bo guut'tso daatsdek'rone, bíwere Yosef naay Nazrettso Iyesusiye» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natnaelmó, «Nazretitse sheeng keewo b́jamon daatsewo falitwa k'úúna?» bí eti. Filp'osuwere «Waar s'iile!» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natnael b́ maants b́waafere bek't Iyesus «Hambe! gond fino bíatse datserawo ariko Isra'el ashoni!» ett b́jangosh b́keewi. ");
INSERT INTO bwo_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natnaeluwere «Aawokneya taan ndani?» bíet. Iyesuswere «Filip'os neenbs'egfetsere shino Belesi mitú shirotse n befere neen bek're» ett bísh bíaniyi. ");
INSERT INTO bwo_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Manoor Natna'el, «Danifono! nee Ik'o naay neene! nee Isra'el naasho neene!» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iyesusu hank'owa bíet, «Nee ni aman, ‹Belesi mitu shirotse n befere neen bek're› ti ettsosheya? Haniye bogts keewwotsi shinomaants bek'etune. ");
INSERT INTO bwo_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Arikoniye neesh tkeewiri, Daro b́k'eshere melkiwots ashna'o ats keer bo'ot'fere bek'etute.» ");
INSERT INTO bwo_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Keezl aawots Gelil datsatse fa'a K'aana eteef kittutse jiwo fa'e b́tesh, Iyesus induwere manokna btesh. ");
INSERT INTO bwo_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Mank'o Iyesusnat b́danifuwotswor jiwok s'egerno. ");
INSERT INTO bwo_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jiwumanatsnowere weyniwon dutsets biro b́s'utsok'on Iyesus ind Iyesussh, «Weyini bironiye boshirotse s'uure!» biet. ");
INSERT INTO bwo_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iyesuswere «Nee máátsune! eegishe t keewots n kindiri? Ti aawo borafa'ee» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Manoor b́ ind manoke fa'uwotssh, «Bí itsh b́ ettso k'alwere» bí eti. ");
INSERT INTO bwo_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Bonemok'on ayhudiwots bo s'ayinf niwa b́ teshtsotse shirt shútsi kunduwots manoke fa'ano, kunduwtsuwere bo ik ikets wee gito wee keez kor atso detso falitkno. ");
INSERT INTO bwo_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iyesus guutswotssh «Kundwotsits atso s'eentswere» bí et, boowere bo nonots b́ borfestsosh s'eentsbok'ri. ");
INSERT INTO bwo_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Maniye hakon Iyesus guutsuwotssh, «Ereer eshe and! jiwo doonzsh tepde'er imere» bí et, boowere dek'amt bísh boimi. ");
INSERT INTO bwo_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Jiwo doonz weyini biro maants wonets aatso b́ nonots b́gedtsok'on, ewuke b́waatsok'o danatse, ernmó aats kitts guutsuwots danfno, jiwo doonz, guuyo s'eegdek't hank'o bíet, ");
INSERT INTO bwo_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","«Ash na'i nemok'on ash jamo shin biri komo shin imr s'eegets asho b́ woriyakon il c'ic'o b́ t'intsfoni, nemon weyini biro sheengo andish b́ borfetso nbeezi.» ");
INSERT INTO bwo_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iyesus adits jam keewwotsitsi shints wotts han Gelil dats kitu K'anitse b́ fini, eshe mank'oon b́mango b kitsi, b́ danifwotswere bín boamani. ");
INSERT INTO bwo_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Maniye hakon b́ indnat b́ eshwotsnton, b́ danifuwotsnton K'frnahom maants b́o oot'i, ernmó manoke ay aawo teyatsno. ");
INSERT INTO bwo_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ayhudiwots fazigi baaliyo b́ bodtsotse Iyesus Iyerusalem maantsan bíami, ");
INSERT INTO bwo_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ik' mootse minzwotsi, mererwotsnat kurkund kemirwotsnat gizo wonirwotsi bedek't bokeewefero bokeemfero boon b́ daatsi. ");
INSERT INTO bwo_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Manoor joki k'ac'eyo dooz dekt ash jamwotsi, bo mereruwotsnat bo minzwotsnton Ik' móótse b́ kish, bogizo wonirwots giz mano b́ bad'iyi, bomarono b́ gup'shi. ");
INSERT INTO bwo_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kurkund kemiru ashuwotssho «Jaman okaan de'e ameree! t nih móó jaaki móó wosh k'ayere!» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Manoor b́ danifwots, «N maa jangosh okooro tawok'o taan mitsre» ett guut'etso gaw bodek'i. ");
INSERT INTO bwo_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Maniye hakon Ayhudi naash naashuwots Iyesusi, «Nee hank'o k'alosh alo n detstsok'osh n kitsit adits keewo eebi noosh n kitsiti?» boet. ");
INSERT INTO bwo_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Iyesuswere, «Ik' man gah k'rore taa keez aawotse aaniy aak'ritwe» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Bowere, «Ik' maan agosh habe shrt nato ishre, Eshe nee keez aawotse aanik'riti?» boeti. ");
INSERT INTO bwo_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Iyesusmó «Ik' maa» ett b́ keewtso bí atsi janga b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Manatse tuutson Iyesus k'irotse b́ tuutsok'on b́ danifwots man keewt b́teshtsok'o gawbodek', mann S'ayin mas'aafotse guut'etsonat Iyesus b́ keewts keewo bo amani. ");
INSERT INTO bwo_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ieyesus Fazig baliwor Iyerusalemitse b́bewor b́ finits adits keewwotsi bobek'tsotse ay ashuwots bin boamani. ");
INSERT INTO bwo_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Iyesusmó ash jamwotsi b́ dantsotse boon amaneratse, ");
INSERT INTO bwo_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Bí ash nibotse fa'a jamo b́ dantsosh ash jango konwor bísh b́ keewitwok'o geeraka. ");
INSERT INTO bwo_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nik'odimosi eteets ash iko fa'e b́tesh, bíewere ferisawino eteef́wts jirwotts Ayhudi naasha b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ashaan t'úwon Iyesusok waat, «Danifono, Ik'o bínton b́wotiyala bako nee n k'aliru adits keewanotsi k'alosh falituwo konuwor aaliye, manshe nee Ik'oke waats danifo nwottsok'o danfone» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Iyesuswere, «Arikon arikoniye itsh keewirwe, asho aani gitlo shuweratse wotiyal Ik'i mengsto bek'osh falratse» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nik'odimoswere, «Eshe, asho bí enashiyakon awuk'o k'alrniya b́ shuweti? Gitlo indumac'ots kindrniya shuweyo b́ falitik'úna?» eton bíaati. ");
INSERT INTO bwo_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iyesuswere hank'o ett bíaaniy, «Ariko, arikoniye neesh t keewiri, asho Shayronat aatson b́shuweyala bako Ik'i mengstots kindo falratse. ");
INSERT INTO bwo_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Meetsatse shuwetso meetse, Shayiron shuwetsonmo Shayire. ");
INSERT INTO bwo_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mansha ‹Gitlo shuwewo itsh geyife› neesh tiettsotse adk'aye. ");
INSERT INTO bwo_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Jongo b́shuntso mande b́jongefoni, b́ k'arono shishetwone, ernmó aawoke b́weyirwok'onat aawok bíamiruwok'o danatsne, mank'o shayirats shuwets jamo mank'oyiye.» ");
INSERT INTO bwo_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nik'odimosuwere, «Aawuk'oneya hank'o woto b́faliti?» ett bíaati. ");
INSERT INTO bwo_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iyesuswere hank'o ett bísh bíaniyi, «Nee Isra'elsh danifo wotefetsat han danafa'i? ");
INSERT INTO bwo_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ariko arikoniye neesh tietiry, nodantso keewirwone, no bek'tsonowere gawirwone, itmó no gawts gawo de'atste. ");
INSERT INTO bwo_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Datsatsi keewo itsh tkeewor amaneratste wotiyal daratsi keewo itsh t keewor aawk'oneya it amaniti? ");
INSERT INTO bwo_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Darotse oot'ts ash na'oniye okoon daromaand keshtso konwor aaliye. ");
INSERT INTO bwo_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","«Muse worwotse dawunzo dambaan k'aaúdek't b́ jittsok'o mank'o ashna'o dambaan tuuzde'er bín jiito geyife. ");
INSERT INTO bwo_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Han b́wotirwonwere bín amants jametswots dúre dúri beyo bo datsitwok'owe. ");
INSERT INTO bwo_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","«Bín amanit jametswots dúre dúri beyo b́ daatsituwok'owa bako b́ t'afrawok'o Ik'o datsu ayidek't b́shuntsotse ik s'uzo b́naayi b́ imi. ");
INSERT INTO bwo_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ik'o b́naayi datsats b́ wosh, datso b́naayn b́ kashitwok'owa bako datsuwats b́ angshishaliye. ");
INSERT INTO bwo_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","«Bín amantso ats angsheratse, bín amanerawonmó ik s'uz Ik' na'o shútson amano b́ k'aztsosh shinor bíats angshk'reke. ");
INSERT INTO bwo_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Angshonúwere haniye, shááno datsats waare, ashuwotsmó bo fino gond b́ wottsotse sháánoniyere t'aluwo boshuni. ");
INSERT INTO bwo_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Gond fin fints jamo shááno shunaka, b́ gond fino b́be'erawok'o sháánomand warake. ");
INSERT INTO bwo_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Arik wotts keewo finirúwonmó sháánomanda b́ waafo, shááno maants b́weyiruwere b́o fints keewo Ik'i alok'on b́ wottse sháánatse b́ be'etwok'owa.» ");
INSERT INTO bwo_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Maniye hakon Iyesus b́ danifwotsnton Yihud datsomand bíami, manoknowere gupfetst bonton muk'i b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Manoor Yohanswere aats ayi beyoke Salem ganoke Henoni eteets beyoke b́gupfera b́tesh, ashuwotswere waatni bo gupefo. ");
INSERT INTO bwo_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Manoor Yohans tiperafa'e b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Manoor Yohans danifuwotsnat ayhudi iko dagotse nemok'on s'ayini jango moosho tuu b́gutsi. ");
INSERT INTO bwo_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Yohans danifuwots Yohans maants t'int «Danifono! andi Yordanosiye bak'etse neenton teshtso, nee b́ jangosh n gawtso, hambe! bíwere gupe b́gupiri, ash jametsutswere b́ maants amirune» boeti. ");
INSERT INTO bwo_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohans hank'owa ett bíaaniy, «Ik'o bísh b́ imala bako konwor b́wotiyal asho eegor dek'o falratse, ");
INSERT INTO bwo_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‹B́ shin shinatsna taan wosheyi bako, taa Krstostanaliye› etaat tkeewtsok'osh it it tookonor gawu itne. ");
INSERT INTO bwo_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Guyu mootse detsts ashoniye guyee, ernmó guuyo mashiye guuyo ganoke ned'deniye bín b́k'ebetiye, b́ k'aaro shishono gene'úwitwe, manshe t gene'oniye haniye, bíwere and s'eengutserere. ");
INSERT INTO bwo_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Bí dambaan dambaan eto bísh geyife, taamo dashan dashan eto taash geyife.» ");
INSERT INTO bwo_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Dambe weetwo jametsoniyere boge, daatse wottso datsike, b́ keewirwonwere dastatsi keewe, darotse watso jamoniyere dambe. ");
INSERT INTO bwo_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Bí b́bek'tsonat b́ shishtsone b́gawitiye, errnmó b́ gawuts gawo dek'etwo aaliye. ");
INSERT INTO bwo_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","B́ gawts gawo dek'etwonmó Ik'o arik b́ wottsok'o daniytwe. ");
INSERT INTO bwo_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ik'o b́ S'ayin shayiro b́ imfo tatsde b́ woterawotse Ik'i woshtso Ik'i aap'o keewitwe. ");
INSERT INTO bwo_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ik'o niho b́ naayi shunfee, jam keewonowere b́ naaysh kishots imk'rere. ");
INSERT INTO bwo_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nayon amantso dúredúr kasho detsfe, naayo n amanerawonmó Ik'i fayo bíatse b́wotiti bako kasho daatsratse. ");
INSERT INTO bwo_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Manoor Iyesus Yohansiyere bogo ay ashuwotsi b́ danifwotsi b́ woshirwok'onat b́ gupirwok'o ferisawino etfwots shishbok'ri, ");
INSERT INTO bwo_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Wotowaere gupirwots b́ danifuwotsi bako bí b́tookon gufatse. ");
INSERT INTO bwo_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","B́ jango keewetso ferisawiwots boshishtsok'o danb́k'rtsok'on Iyesus Yhud datso k'azt Gelil maants aani k'az bíam. ");
INSERT INTO bwo_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Manokowere bíamor Semari weeron besho bín geyika b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mansh Ya'ak'ob b́naaysh Yosefsh b́ imts beyoku ganoke fa'u, Sikari ett s'egefu Semariy kituts b́weyi. ");
INSERT INTO bwo_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Manoknowere Yak'ob aats gop'o fa'e b́tesh, Iyesus werind sha'oke b́ mááwtsotse gop'man ganok beeb́dek'i, manoor gizewonwere shrt sa'atok'owi b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Manoor Semariy datsatsik wotts mááts iku aats kito gop'ok bweyi, Iyesuswere, «Úshet aatso taash ime!» bí eti ");
INSERT INTO bwo_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Manoor b́ danifwots mish keewosh kito maand amtnibofa'o. ");
INSERT INTO bwo_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Semari dats ash wotts ashmanwere Iyesussh, «Nee n naaro ayhudi wotefetsat aawk'oneya tnaaro Semari wottsush ‹Úshi aatso taash ime!› etaat niatiri?» bí et, man bíetwere ayhudiwots Samrawino etefwotsnton ik woto bodeshawotsna. ");
INSERT INTO bwo_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iyesuswere, «Ik'i imonat ‹Úshet aatso taash ime!› neesh etirwo koni b́wotstsok'o ndanink'e, bín k'oniyank'u neene bteshi, bíwere kash aatso neesh imank'e» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Biwere hank'o etaat biaaniyi, «Doonzono! neewo bín kitet k'ac'o deshatsnere, gop'onuwere ayi dashan woke, eshe kash aatso eewkneya n datsiti? ");
INSERT INTO bwo_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nee gop'an imtso nonih Yak'obiyere bogfiya? Bína ett b́ nana'on, b́ minzwotswere gop'anitse úshrnee.» ");
INSERT INTO bwo_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iyesus hank'o ettni bish bíaaniy, «Aatshan úshetu jamo ando aaniy shashwitwee, ");
INSERT INTO bwo_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Taa timet aatso úshetwonmo dúre dúrosh b́ jamon shashweratse, taa ti imet aatso dúre dúrosh kasho bítse t'up'et aatse b́ wotiti.» ");
INSERT INTO bwo_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Máátsmanwere, «Doonzono! haniye hakon aatso taan b́shashwirawok'o aaninwere kitosh hanok twarawok'o oona neesha man naari aatso taash ime!» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Iyesuswere, «Amr n kenihi s'eede aniwowe» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ashmanwere, «Keniho deshatse» etaat bíaaniy. Manoor Iyesus hank'owa bish bíet, «Keniho deshatse niettsoniye arikee, ");
INSERT INTO bwo_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Uts kenihwotsi detsfne b́teshi, and neenton fa'a ashonwere n kenihiyaliye, manshe ariko keewurne» bí eti. ");
INSERT INTO bwo_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Máátsmanwe hank'o bísh bíet, «Doonzono! nee nebiyiyo nwottsok'o andee t dani, ");
INSERT INTO bwo_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nonihots guranatsene Ik'o bok'ofoni, itmó ‹Ashuwots Ik'o k'ono boosh b́ geyitiye Iyerusalemitsne› etfte.» ");
INSERT INTO bwo_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Iyesuswere hank'wa bish bíet, «Nee ashune! Guranatse wee Iyerusalemitse Ik'o nihosh sagado it k'azet aawo b́ weetwok'oyish taan amanowe, ");
INSERT INTO bwo_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","It it daanawoshe it sagadiri, noomo kashet weero b́weet ayhudiwotsoke b́wottsotse no dants Ik'oshe nosagadiri. ");
INSERT INTO bwo_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ernmó arikon Ik'osh sagadirwots, Ik'o nihosh arikonat Shayirn bosagadit aawo weetwe, dab andoor waare, Ik'o nihonwere b́geyirwo hank'on bísh sagaditwotsiye. ");
INSERT INTO bwo_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ik'o shayire, bísh sagadirwotswere shayironat arikon sagado boosh geyife.» ");
INSERT INTO bwo_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Máátsmanwere «Krstosi eteetso Mesihiyo b́weetuwok'o danfee, bí b́ woor jam keewo noosh keewitwe» bi et. ");
INSERT INTO bwo_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Iyesuswere «Hamb! and neenton keeweyirwo taahe bíne» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Manoor b́ danifwots bo amtsoke aanat boweyi, Iyesus máátsunton b́ keeweyirwotse bo adi, wotowa bako, «Eege ngeyiri? Wee binton eegishe n keeweyiri?» ett bín attso konwor aali b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Maniye hakon máátsman b koro k'azk'rat́ kito maants amat́ ash ashosh hank'o bieti, ");
INSERT INTO bwo_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«T k'alts jamó taash keewts asho waar s'iilere! daneraka biye Krstosi wotifek'úna?» ");
INSERT INTO bwo_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ashuwotswere kitotse kesht Iyesus maants boami. ");
INSERT INTO bwo_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Manoor b́ danifwots Iyesussh, «Danifonó! ik jago mishok'o moowe» ett bok'oni. ");
INSERT INTO bwo_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Bimó, «It danawo taa t meyiru móó detsfe» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Mansh b́ danifwots, «Asho bísh misho dek'waatso fa'ak'úna?» bo eti. ");
INSERT INTO bwo_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Iyesuswere boosh hank'owo bí et, «Tiko mishoniye taan woshtso ettso k'alona ett b́ finono s'eentsone. ");
INSERT INTO bwo_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","It ‹Haniyak awd shasho orere, maniye hakone maay k'ees'o b́bodeti› etirutosha? Taamó ‹Aab kaaw de'er mááykatswots k'es'osh bobodtsok'o s'iilere› etirwe itsha. ");
INSERT INTO bwo_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","K'es'irwo bí angi k'awntso dek'etwe, dúre dúri bewosh wotit shuwo ko'itwe, mansha shokirwonat, k'es'irwonton tohar gene'uwitúne. ");
INSERT INTO bwo_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Hnk'o b́ wottsotse ‹Iko shoketwe, k'osho k'es'etwe› eteetso arikee. ");
INSERT INTO bwo_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Taawere it bíats it shamberawo it k'es'etwok'o itn woshere, k'oshwots finon bomaawi, itmo bomawtsatse shuwo it meyi.» ");
INSERT INTO bwo_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Máátsunwere «T k'alts jamo taash keewure» etaat b gawtsok'on kit manitsere ankat Samari dats ashuwots bín bo amani. ");
INSERT INTO bwo_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Samari datsatsi ashuwots Iyesusok bo waatsok'on bonton b́ beetuewk'o bok'oni, bíwere git aawo manoke b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bí aap'atse tuutsatse k'osh ankat ashonwere bín bo amani. ");
INSERT INTO bwo_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ashmanshowere «Hniye hakon bín no amanitiye nee noosh n keewtsoshaliye no notookon noshishtsonat arikon datsani kashitwo bín b́wottsok'o no dantsotsne.» boeti. ");
INSERT INTO bwo_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Iyesus Semariy datsatse git aawo b́ teshihakon Gelil datso maantsan bíami. ");
INSERT INTO bwo_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Bí b́ tookon «Nebiyiwo b́ took datsatse mangiyerakee» ett keewre b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Gelil maants b́bodtsok'onmó Gelil dats ashuwots mangon bín bodek'i, han b́wotwere Fazig baliwots Iyerusalem maants amt boteshor bi manoke b́ k'alts jamo bek't boteshtsotsná. ");
INSERT INTO bwo_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Maniye hakon Iyesus aatso weyini biro maants b́wonits datsu Gelil datsatse fa'a K'aan kitu maants aani aanat b́weyi, manoor K'frnahomn b́ na'o b́shirotse shodtso mengsti mootse naash iko fa'e b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Bíwere Iyesus Yihud datsatse Gelil datsats b́wowo shisht b́ maants bíam, K'frnahom maants ood'r ayidek't shodt k'irosh etirwo b́ na'o bísh b́kashiytwok'o Iyesusi b́k'oni. ");
INSERT INTO bwo_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iyesuswere «It adits keewonat milikito it bek'ala bako eegonor amaneratste!» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Naashmanúwere «Doonzono! t na'o b́ k'irftsre oona neesha kaari ood'e» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iyesuswere «N moo maants amee! n na'o kashon fa'e» bíet. Ashmanwere Iyesus aap'tso amanat b́ moo maants bíami. ");
INSERT INTO bwo_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Bíamfere b́guutswots weerindatse daatsdek't «N na'o kashwtsere» ett bísh keew bok'ri. ");
INSERT INTO bwo_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Bíwere b́ na'o b́ shamp'ts sa'ato boon bíaati. Bowere «Oots shawat sa'atatse atsik'es'o bínfakshb́k'riye» boet. ");
INSERT INTO bwo_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nihonwere, Iyesus «N na'o kashon fa'e» bíettso manoori sa'aton b́wottsok'owo danb́k'r, mansh manots aawon detst bínat b́maa ashon Iyesusi aman bok'ri. ");
INSERT INTO bwo_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Aditshan Iyesus Yhud datsatse Gelil datsomants waat b́k'alts gitloniye. ");
INSERT INTO bwo_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Maniye hakon ayhudiwots worowoti bali aaw b́ wottsotse Iyesus Iyerusalem maants bíami. ");
INSERT INTO bwo_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Iyerusalemn mererwots fengeshi ganoke, Ibrayist'i noonon Betezata eteets ikok kakts atso fa'e b́tesh, b́gúratsnowere bí tookatse ipdetsts boweeron besheefwots fa'ano botesh. ");
INSERT INTO bwo_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ayidek't ay shodetswots, aaw dogwots, duruwotsnat shoklirwots b́ beshiru werats k'edek'tni botesh. Ashmanots aatsman b́ giwoni bokotfo botesh, ");
INSERT INTO bwo_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Besh beshr Doonzo melakiyo aats kakots ood'r aatsman b́ giwshfoni, aats giwmaniye okoon shino aats kakmanits kindtso b́ shodts shodinar jamatse kashefe b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Manoknowere shaashe shimt nat jamosh shodts ash iko fa'e b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iyesus ashman manoke b́ k'eefere bek't ayduroniye shintson b́shodok'o dant, «Kasho geefi?» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Shodetsonuwere «Doonzono! aatso b́ giwtsok'on taan de'amr aats kakmanits gedet asho deshatse, taa amoosh tietor k'osh asho taayere shino oot'b́wtsiriye» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Iyesuswere «Tuuwe! ni es'o kurde'er amee!» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ashmanwere manoor kashb́gutsi, b́ es'onowere kurdek't bíami. Han b́wotwere sanbati aawone. ");
INSERT INTO bwo_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mansh Ayhudi naash naashuwots kashts ashmansh «Hambets sanbat b́wottsotse ni es'o nkuritwok'o neesh eekeratse» boet. ");
INSERT INTO bwo_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Bímó, «Taan kashits asho ‹nies'o kurde'e amee› ett taash keewre» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bowere, «Ni es'o kurde' amee neesh ettso kone bí?» ett bo aati. ");
INSERT INTO bwo_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ashmanmó ashasho bí aytsotsnat Iyesus manoke okaan t'iindek't b́teshtsotse bín kashitso koni b́wottsok'o danatse b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Maniye hakon Iyesus ashman Ik' mootse daatsdek't, «Hamb, and kasherne, haniye bog keewo niats b́borawok'o haniye hakon morro fink'aye» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ashmanwere amt bín kashitso Iyesusi b́wottsok'o ayhudiyi naashwotssh keewb́k'ri. ");
INSERT INTO bwo_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Keew man sanbati aawots b́ fintsotse Ayhudi naashwots Iyesusi gisho dek't botwi. ");
INSERT INTO bwo_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Iyesusmó «T nih andish b́borfetso fine b́finiri, taawere finirwe» ett boosh bíaaniy. ");
INSERT INTO bwo_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Man boshishtsosh Ayhudi naashuwots Iyesusi boúd'itwok'o iki boon tuzb́k'ri, man b́wotu bíye sanbato b́gaaktso s'uzsh b́ woterawo, «Ik'o t nihiye» eton b́ tooko Ik'onton b́nutsitsoshe. ");
INSERT INTO bwo_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iyesus hank'o ett boosh bíaaniy, «Arikon arkoniye itsh ti etiriye, Niho b́ finefere b́bek'tso finoniye okoon naayo b́took alon eegor fino falratse. Niho b́ k'alirwok'o naayonwere b́ k'aliri. ");
INSERT INTO bwo_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Niho naayo b́shuntsosh b́ finiru jamo bísh kitsitwe, itwere it aditwok'o haniye bog finonor bísh kitsitwe. ");
INSERT INTO bwo_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Niho k'irtsuwotsi b́ tuuzituwok'onat kashonowere boosh b́imetuwok'owa, naayonúwe mankowa b́ shunts ashosh kasho b́ imeti. ");
INSERT INTO bwo_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Niho konatsor angshratse, ernmó angsh jamo naayosh imk'rere. ");
INSERT INTO bwo_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Hanowere b́ k'alir ash jamwots niho bomangitwok'o, aaninwere naayo no bomangitwok'owa, naayo mangirawo, naayman woshts niho mangiratse. ");
INSERT INTO bwo_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Ariko aroniye itsh tietiri, t aap'tso k'ewur taan woshtsono amanitwo dúre dúri beyo detsfe, bíye k'irotse kashomand k'az b́ kimtsotse bíats angsheratse. ");
INSERT INTO bwo_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ariko arikoniye itsh keewirwe, k'irts ashuwots Ik'o naay k'aaro boshishet aawo fa'e, b́dúronúwere andee, bín shishetu jamwotswere kashon beetune. ");
INSERT INTO bwo_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Niho b́tookon kash t'uup'o b́wottsotse, b́naaywere kash t'uup'o b́wotitwok'o woshre. ");
INSERT INTO bwo_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ashna'a b́ wottsotsnowere angsho bíangshitwok'o alo bísh imre. ");
INSERT INTO bwo_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Keewan jangatse adk'ayere, dowootse fa'a jametswots b́ k'ááro boshishet aawo weetwe. ");
INSERT INTO bwo_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Sheeng fintswots dootse keewarr kashon beetune, gond fintswotsemó dowootse keer boere boats angshetwe. ");
INSERT INTO bwo_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«Taa t took alon eegor k'alo falratse, ernmó nihoke t shishtso angshitwe, taan woshtso b́ geyirwok'owa bako t geyirwok'o t angshrawotse t angsho kááwe. ");
INSERT INTO bwo_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Taa t took jangosh t gawitk wotiyal t gawts gawo arikaliye. ");
INSERT INTO bwo_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ernmó t jangosh gawitwo k'osho fa'e, bíwere t jangosh b́gawit gawo arik b́ wotitwok'o danfee. ");
INSERT INTO bwo_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Itiye Yohans maants wosho amtsuwotsi woshatniye it teshi, bíwere aro gawere. ");
INSERT INTO bwo_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Han tietiriye it kashitwok'owa bako taash ash gawo b́geyitsoshaliye. ");
INSERT INTO bwo_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohans aat'at c'eshts c'eshok'oyiye b́ teshi, it were muk' aawosh b́ sháánits sháánon gene'osh itgeyi. ");
INSERT INTO bwo_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ernmó taa Yohans gawtsoniyere bog gawo detsfe, t gawonúwere t nih tfinitwok'o taash b́'imts finoniye, t finit finmanwere niho taan b́wooshtsok'o t jango gawitwe. ");
INSERT INTO bwo_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Taan woshts Niho b́ tookon t jango gawere, itmó b́ k'aaro b́jamon shiyatste, bíaronowere b́ jamon be'atste. ");
INSERT INTO bwo_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Bí b́woshtso it amanerawotse b́ aap'o itnibots geratste. ");
INSERT INTO bwo_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","It S'ayin mas'aafwotsitse dúre dúri kasho it daatsitwok'o itsh bí'artsotse boon p'ec'at its'iliri, boowere t jangosh gawirwotsiye. ");
INSERT INTO bwo_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ernmó it kashu daatsosh t maants woo geratste. ");
INSERT INTO bwo_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Taa mango ashoke geeratse. ");
INSERT INTO bwo_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","It it nibotse Ik'o shunawwotsi it wottsok'o danfee. ");
INSERT INTO bwo_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Taa t nih shútson waare, itmó taan de'atste, ernmó k'osho b́took shútson b́waal b́ín dek'etute. ");
INSERT INTO bwo_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","It atsatseyosh mango geyirwots Ik' ikoke daatset mangonmó gerawwots, awuk'o k'alrniya amanosh it faliti? ");
INSERT INTO bwo_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Taa t nih shinatse itn t s'aamitwok'o ark'aya itsha, iti s'amitwo bín it jangirwo Museyiye. ");
INSERT INTO bwo_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Museyi amaneerte wotink'e bí tjango b́ guut'tsotse taanor amaniyank'te b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Bí b́ guut'tso amaneratste wotiyal t aap'o awuk'o k'alrniya it amaniti?» ");
INSERT INTO bwo_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Maniyereokon Iyesus Gelil aats k'aroniye bak'ets b́kimi, manwere T'ibriyados aats k'aroniye. ");
INSERT INTO bwo_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ay ashuwots Iyesus shodtswotsi kashit b́k'alts adits keewo bobek'tsosh b́shuutso shoy dek't bosha'i. ");
INSERT INTO bwo_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Iyesus guri abaats kesht manoke b́ danifwotsnton beeb́dek'i. ");
INSERT INTO bwo_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ayhudiwots fazigi baaliyo manoor t'intni b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Manoor Iyesus ay asho b́maants b́waafe dambaan kawdek't s'iilt Filp'ossh, «Jam ashaansh bodet misho eewkneya keewosh nofaliti?» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Iyesus man b́ keew Filip'osi fadbek'osha bako b́k'alitwok'o bí b́tookon danfee b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Flip'oswere «Botook tookosh mishi tiish tisho dab imosh git bal Dinariyon misho keewere boosh boratse» ett bíaaniy. ");
INSERT INTO bwo_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","B́ danifuwotsitse iko Sim'on P'et'ros eshu Indriyas hank'o bíet, ");
INSERT INTO bwo_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Uts geshi mishonat git mus' detsts na'a iko hanoke fa'e bíeti, ernmó han jam ashaansh awukoneya b́ bodeti?» ");
INSERT INTO bwo_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iyesuswere «Ashuwotsi beezwore» bíet. Manoke ay mooc'o fa'e b́tesh, ashuwotswere be bodek', botaawonúwere nungushi aano úts kumok'o bornke botesh. ");
INSERT INTO bwo_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Maniyere hakon Iyesus mishman k'a'udek't b́údiyakon beyiru ashuwotssh b́ kayi. Mank'o mus'uwotsi boosh b́ kayi, jametsuwots boosh b́ bodetuwok'owo bodaatsi. ");
INSERT INTO bwo_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Jametswots maat boworiyakon Iyesus b́ danifuwotssh, «Ik jago dats oorar bíawasherawk'o mishifed'o kakwere» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bowere ash ashuwots maat bo eree ortso útś geshi mishi tishuwots fed'o kakudek't tatse git mishimaron s'eentsbok'ri. ");
INSERT INTO bwo_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ashuwots Iyesus b́ fints aditsman bo bek'tsok'on, «Datsats weetwo nebiyiyo ariko haniye!» bo eti. ");
INSERT INTO bwo_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ashuwotsmó angnon de'amr bín nugús woshosh gawbok'rtsok'o dank'rat aani Iyesus bí'al guri abaats k'azbiami. ");
INSERT INTO bwo_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Datso b́ iltsok'on b́ danifuwots aats k'aro maants k'az bo'ot'. ");
INSERT INTO bwo_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jelbats kinddek't K'frnahom maants bo tuwi, manoori sa'atonuwere t'aluwtsere b́tesh, Iyesuswere book warafa'e b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Jong kup'o b́ jongefere b́ teshtsotse, aatsi k'aro giwu b́wutsi. ");
INSERT INTO bwo_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","B́ danifuwots wee útso wee shirt kilo metrok'o jelbu jook dek't boama'iyakon Iyesus aatsatse sha'efere jelbu maants b́ t'infere bek't shatboguts. ");
INSERT INTO bwo_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Bímó «Taane! shatk'ayere!» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bowere gene'uwat bí jelbuts b́kindituwok'o bo geyi, manorowere jelbu boamiru datsats ambodbwtsi. ");
INSERT INTO bwo_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Yatsok'on aats k'aroniyere bak'etse oorat teshts ashuwots, aats k'aratse jelbu ik s'uz b́teshtsok'onat manoknowere b́ danifuwots s'uz boamtsok'o, Iyesusmó bonton jelbuts b́ kindrawok'o bek'tni botesh. ");
INSERT INTO bwo_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Wotowa eree k'osh jelbuwots T'bryadositse tuut Iyesusi údon Ik' b́ k'ontsokonat ash asho mish bomaatsok boweyi. ");
INSERT INTO bwo_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ash ashuwots Iyesus wotowa b́ danifwots manoke bo aaltsok'o bo bek'tsok'on jelb manotsits kind dek't Iyesusi geyo K'frnahom maants boami. ");
INSERT INTO bwo_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Aats k'aronye bak'etse bín bodatstsok'on, «Danifono, hanok awure nweyi?» bo et. ");
INSERT INTO bwo_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iyesuswere hank'o ett boosh bíaaniy, «Arikon, arikoniye itsh ti'etiriye, it taan it geyirye misho maat it wortsosha bako adits keewo it bek'tsoshaliye. ");
INSERT INTO bwo_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","T'afit mishosh fink'ayere, maniyere Ik'o niho arikon daniyosh matabon b́ togts ash na'o b́ imet dúre dúri kash wotit mishosh finore.» ");
INSERT INTO bwo_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ash ashuwotsuwere «Beree, Ik'i fino finosh eeg k'ale geyiti nosha?» boeti. ");
INSERT INTO bwo_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Bíwere «Ik'i finoniyere Ik'o b́ woshtson amanee» ett boosh bíaaniy. ");
INSERT INTO bwo_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bowere bísh hank'owa boet, «Be'er neen noamanish adits keewo finitwiya? Eebi nfinitwo fa'oni? ");
INSERT INTO bwo_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","‹Bomeetuwok'o darotse misho boosh imre› ett guut'etsok'on, no nihots worwotse darotse oot'ts meno maarne.» ");
INSERT INTO bwo_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Manoor Iyesus hank'owa boosh bíeti, «Arikon arikoniye itsh tietiriye, darotse oot'ts misho itsh imtso Museyiyaliye, arik wotts misho darotse itsh imetwo t nihiye, ");
INSERT INTO bwo_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ik'i misho darotse ood'r datsansh kash imetwo bíne.» ");
INSERT INTO bwo_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Mansh ashuwots «Doonzono! man naari misho úni aawo noosh ime» bo eti. ");
INSERT INTO bwo_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Iyesuswere hank'o boosh bíet, «Kashi misho taane, tiyok weetuwo b́ jamon k'ak'eratse, taan amanitwo b́ jamon shashweratse, ");
INSERT INTO bwo_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Itiyere taan bek'rte ernmó taan amaneratste etirwe. ");
INSERT INTO bwo_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Niho taash b́ imetu jamo tiyok weetwe, tiyok wetwono b́ jamon taa úromaants gisheratse. ");
INSERT INTO bwo_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Taa darotse oot'at t waa taan woshtso bí ettso k'alosha bako t shuntso k'alishaliye. ");
INSERT INTO bwo_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Taan woshtso b́ shuntsonye taash b́ imts jamotse dab ikunor t t'afirawo dúris'uwi aawots k'irotse t tuzitwok'owe ");
INSERT INTO bwo_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ee! t nih b́ shuntsoniye naayo be'er bín amanitu jamo dúre dúri kasho b́ datsitwok'owe, taawere dúri s'uwi aawots k'irotse bín tuuzitwe.» ");
INSERT INTO bwo_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","«Darotse oot'tso misho taane» Iyesus bí ettsotse ayhudiwots bíatsats bo mumundi, ");
INSERT INTO bwo_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Hank'o bo eti «Han Yosef naay Iyesusi woshna? B́ nihnat b́ indn danefonoshna? Eshe and aawuk'oneya ‹Darotse oot're› bíetiri?» ");
INSERT INTO bwo_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iyesuswere hank'o ett boosh bíaaniy, «It ats atseyo mumundk'ayere, ");
INSERT INTO bwo_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Taan woshtso niho b́ getstsoniyere okoon t maants woo falituwo konwor aaliye, t maants wetwonowere dúri s'úwi aawots k'irotse tuuzitwe. ");
INSERT INTO bwo_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nebiywots mas'aafotse ‹Ash jametswots Ik'oke danetwotsi wotitune› ett guut'ere, manshe nihoke shisht dants jametso tiyok weetwe. ");
INSERT INTO bwo_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Man etonwere niho bek'ts asho fa'e etoshaliye, niho bek'tsoniye Ik'oke waatsos'uziye. ");
INSERT INTO bwo_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ariko arikoniye itsh ti etiriye, taan amants asho dúre dúri kasho detsfe. ");
INSERT INTO bwo_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Taaye kashi mish taane. ");
INSERT INTO bwo_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","It nihots worwotse meno bo meyi, ernmó k'ire bok'iri. ");
INSERT INTO bwo_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Darotse oot'ts misho haniye, eshe mishman meetwo b́jamon k'irratse. ");
INSERT INTO bwo_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Darotse oot'tso kasho imet mishoniye taane, mish man meetu jamo dúre dúroshe b́ beeti, daatsosh kash b́wotitwok'o taa t imetwo misho t meetsoniye.» ");
INSERT INTO bwo_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Manoor ayhudiwots «Ashaan b́ meetso nometwok'o aawk'o k'alde'eniya noosh imo b́faliti?» ett boatsatsewo bo mooshi. ");
INSERT INTO bwo_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Mansh Iyesus boosh hank'o bí eti, «Arikon, arikoniye itsh t keewiri Ash na'o meetso moo itk'azal, b́ s'atso úsho it k'azal kasho deshatste. ");
INSERT INTO bwo_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Tmeets meetuwonat ts'ats úshetu jamo dúre dúri kasho detsfe, taawere dúris'uwi aawots k'irotse bín tuuzitwe. ");
INSERT INTO bwo_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","T meetso ari mishe, t s'atsonwere ari úshe. ");
INSERT INTO bwo_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","T meets meetwonat s'aats úshetu jamo taantoniye b́ beetiye, taawere bíntoniye tbeetiye. ");
INSERT INTO bwo_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Beyar beetwo niho taan b́woshtsok'onat bí atse tuutson taawor beyar beetwo twottsok'on mank'o t meets meetu jamo ti'atse tuutso beyar beetwo wotitwe. ");
INSERT INTO bwo_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Eshe darotse oot'tso misho haniye, bíwere it nihots bo maatsi naaraliye, mishman maatswotsiye k'irrne, misháán metwotsiye dúre dúroshe bobeti.» ");
INSERT INTO bwo_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iyesus han b́ keewu K'frnahomitse ayhudi Ik' k'oni mootse b́ daniyore. ");
INSERT INTO bwo_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","B́danifuwotsitse ayuwotsi man boshishtsok'on, «Aap'an mange, kone fal k'ebeti?» bo et. ");
INSERT INTO bwo_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","B́danifwots keewan jango bo mumdtsok'o b́ gitsotse dandek't boosh hank'o bíeti, «Keewan itsh t'ugeya b́ wotiti? ");
INSERT INTO bwo_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ash na'o b́beyok aanar b́kesho it bek'or eege it eteti? ");
INSERT INTO bwo_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kasho imetwo Ik'i shayire, ash angonmó egoshoru woteratse, taa itsh t aap'tso shayire, manwere kashe, ");
INSERT INTO bwo_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ernmó ititsere amanerawu ik ikwots fa'ane,» Iyesuswere han b́ keewoniyere shinon bín amanerawwots konotsi bowottsok'onat bín beshide imetwo koni b́wottsok'o b́dantsotsne. ");
INSERT INTO bwo_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Manats dabt Iyesus «Ik'o nihoke alo bísh imeyala bako tiyok wóósh falitwo aaliye tiet manshe» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Hanatse tuutson b́ danifwotsitse aywots jiik'omand k'az bo aani, manortson Iyesus shuutso sha'o k'azbok'ri. ");
INSERT INTO bwo_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mansh, «Itwere aanar amo geefteya?» ett Iyesus b́ danifuwotssh bíaati. ");
INSERT INTO bwo_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Manoor S'im'on P'et'ros hank'o ett bíaani, «Doonzono! kon maantse noameti? Nee dúre dúri kashi aap'o detsfne. ");
INSERT INTO bwo_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nooyere amanerone, S'ayino Ik'o naayi nwottsok'o danrone.» ");
INSERT INTO bwo_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Iyesuswere, «Tatse gitetswotsi itn galdek'rosha? ernmó ititse iko Dabilosiye» boosh bí eti. ");
INSERT INTO bwo_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Manowere bíetir Simon naay Ask'rwot dats asho Yihud jangosha b tesh, Yihud b́ danif tatse gitwotsitse iko wotb́jinalor Iyesusi beshide imetwo bín b́wottsotsna. ");
INSERT INTO bwo_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Maniyere hakon Iyesus Gelil datsatse bíananefere b́teshi, Ayhdiwots bín úd'osh geeyat boteshtsotse Yhud datsatse anaanosh falatse b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Manoor Ayhdiyots daasiy baaliyo karnre b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Mansh b́ eshwots Iyesus maants t'int hank'o bo eti, «N danifwots n finiru fino bo bek'etwok'o hanoke tuur Yhud datso maants amee, ");
INSERT INTO bwo_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Sháánátse danewosh geyiru asho b́ fino aashde finerake, neewor keewu jametsanotsi n finoŕ n tooko datsush n kitso geyife.» ");
INSERT INTO bwo_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Han bokeewwere bíeshwotswor dab bín amanerak bowottsoshe. ");
INSERT INTO bwo_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Iyesuswere hank'o boosh bíet, «Tiaawo andoor borafa'ee, it aawonmó jamaawo itsh k'anke. ");
INSERT INTO bwo_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Datsu iti shit'osh falratsane, Taanmó b fino gond́ b wottsok'o tkeewirwosh taan b́shit'iri. ");
INSERT INTO bwo_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","It baaliyok ameree, taayere tiaawo andoor b́borafa'otse bali manok amatse.» ");
INSERT INTO bwo_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Bí mank'o ett Galilon k'az b́ oori. ");
INSERT INTO bwo_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ernmó bí eshuwots baaliyok k'az boamiyakon b́be'erawo ááshoń baaliyok bíamí. ");
INSERT INTO bwo_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Balimanatsnowere «Bí eewke?» etfetst ayhudiwots bín bogeyiri bo tesh. ");
INSERT INTO bwo_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ashuwots b́ jango shaashkona bo keeweyri b́ tesh, ik ikuwots «Bí ash shenge» bo etor, k'oshwotswere dabt «Woteratse bí ashuwotsi b́ dariyirye» bo etir b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Wotowa eree ayhudi naash naashwotsi bo shattsatse tuutso konwor b́ jango kish sháánon keewratse. ");
INSERT INTO bwo_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Baliyiman badatse Iyesus Ik móóts amt daniyo dek' b́twi. ");
INSERT INTO bwo_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ayhudiwotswere, «Ash han b́ danawo jaman ak'onya danosh b́ fali?» ett bo adir b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Mansh Iyesus hank'o ett boosh bíaani «T daniyoniye taan woshtsoke daatseka bako tiyokikaliye. ");
INSERT INTO bwo_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Taan woshtso b́ geyirwo k'alosh shuntso b́ beyal daniyeyiru danań Ik'oke daatsek wee taa t tookon tkeewirwo b́ woto danetwe. ");
INSERT INTO bwo_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","B́took keew keewirwo b́ took manga b́ geefoni, woshtso mango geyirwonmo bi arkeewke, kootonwere deshatse. ");
INSERT INTO bwo_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Muse nemo itsh imroshna? ititsnmó nemon sha'irwo konwor aaliye. It eegoshe taan úd'osh itgeyiri?» ");
INSERT INTO bwo_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ash ashonwere «Niyatsne fo'erawoniye fa'oni, neen úd'osh kone geyirwoni?» boet. ");
INSERT INTO bwo_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Iyesuswere hank'o ett boosh bíaaniy, «Taa ik fino finere, it jametswere fin man jangosh it adiri. ");
INSERT INTO bwo_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Muse gof damiy nemo itsh imre, nemanwere b́waa nih nihwotsokna bako Musewoknaliy, itmo Ik' aawon ashuwotsi gofo it damiri. ");
INSERT INTO bwo_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Eshe Muse weeron imets nemo tiitserawok'o ett sanbati aawon asho gofo damiyeyiri wotiyal, taa sanbati aawots ash ats jamo t kashitsosh eegishe taan it fayiri? ");
INSERT INTO bwo_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ariko angshwere bako ash aawo s'iilr k'uuride angshk'ayere.» ");
INSERT INTO bwo_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Iyerusalem ash ashuwotsitse ik ikwots hank'o bo et, «Úd'osh bogeyiru asho haniyoshna?» ");
INSERT INTO bwo_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hambe! biye shiratsne b́ keewiri, boowere bísh eegor eratsne, ashaan Krstosi b́ wottsok'o arikon naash naashwots danfnok'úna? ");
INSERT INTO bwo_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","B́wotiyalor ashaan ewkiko b́wottsok'o no danfone, Krstos b́woormo ewkik b́wottsok'o danetwo konwor aaliye. ");
INSERT INTO bwo_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mansh Iyesus Ik' mootse b́ danifere k'aro eensh dek't hank'o bíet, «Taan danfte, ewuke twatsok'onowere danfte, ernmó taa t took alon waratse, taan woshtso bí arkeewetske, itmó bín danatste. ");
INSERT INTO bwo_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Taayere biyoke twaatsonat bí taan b́woshtsotse taa bin danfee.» ");
INSERT INTO bwo_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Manoor bín detsosh geyatni botesh, ernmó bíaawo b́borafa'otse konwor bín deshatse. ");
INSERT INTO bwo_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","B́wotiyalor ash ashotse ayuwots bín boaani, hank'owere etrno «Krstos b́woormo ashaan b́k'alts aditswotsiyere bogeya b́ finiti?» ");
INSERT INTO bwo_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ash ashuwots Iyesus jango shashkon bokeewefere ferisawino eteefwots bo shishi, mansh kahniy naashwotsnat ferisawino eteefuwotsn Iyesusi detsiyosh Ik' maa kotfuwotssh bokeewi. ");
INSERT INTO bwo_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Manoor Iyesus hank'o bíet, «Itnton muk'i teshetwe, maniyere okoon taan woshtsok ametuwe, ");
INSERT INTO bwo_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","It taan geyitute, ernmó taan daatsratste, taa t beyok woo it falratste.» ");
INSERT INTO bwo_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Mansh ayhudiwots bo atsatsewosh hank'o bo et, «Bín nodaatsrawok'o ashaan ewkek'una bíameti? Daneraka Grik dats ashuwots dagots bad'ts ayhudiwotsok amr Ik' danawu ashuwotsi danishe k'úna? ");
INSERT INTO bwo_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‹Taan geyitute, ernmó daatsratste taa tbeyirwok wosh falatste› bíetor eeg etoshe?» ");
INSERT INTO bwo_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Baaliyi s'uwi aawu wotts een aawots Iyesus need'dek't b́ k'aaro eenshdek't hank'o bíet, «Aats shashutso fa'e wotiyal t maants waar úyee. ");
INSERT INTO bwo_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Taan amantso S'ayin mas'aafotse bíetiruwo kash ats t'uup'o b́ gitsotse t'uup'tuwe.» ");
INSERT INTO bwo_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Han bíetirwe bíń amanitwots bodek'et S'ayin shayiri jangosha b́tesh, Iyesus mango maants b́ keyafa'otse S'ayin shayiro imerafa'e b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mann ash ashi dagotse Ik ikwots keewman boshishtsok'on, «Weetwe eteets nebiyiwo arikon haniye» boet. ");
INSERT INTO bwo_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","K'oshwotswere «Han Krstosiye» bo eti. K'atswotsmó «Krstos b́weet Gelilneya? ");
INSERT INTO bwo_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Krstos b́shuwet Dawit narotsnat Dawit kitotse Betelihemitse b́ weetwok'o S'ayin mas'fotse guut'roshna?» bo et. ");
INSERT INTO bwo_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mann ash ashi dagotse b́ jangatse tuutson k'osh k'oshewo wotb́wutsi. ");
INSERT INTO bwo_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Boyitse ik ikwots bín detsosh geerno botesh, s'uznmó konwor bíndeshatse. ");
INSERT INTO bwo_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Maniye hakon kot kotfuwots kahni naashuwotsnat ferisawiwots maants aanat boami, boowere «Eegishe bín dek'woo it k'azi?» bo boeti. ");
INSERT INTO bwo_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Kes' kes'fwotswere, «Ashaan b́ keewiru keewi naaro konúwor keew danake» ett boaaniyi. ");
INSERT INTO bwo_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ferisawino eteefwotsmó hank'o boeti, «Itwere daarisheya? ");
INSERT INTO bwo_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Wotowabako naash naashotse wee ferisawino eteefwotsitse bín amantso fa'a? ");
INSERT INTO bwo_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Muse nemo danawu ash ashaan arikon c'asheke.» ");
INSERT INTO bwo_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Haniyre shin Iyesusok amt teshtsonat fersawiwotsitse iko wottso Nik'odimos, ");
INSERT INTO bwo_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«No nemok'on ash iko shin b́ keewo keewu b́de'e k'ewdek'fetsere aaninwere eeg b́k'altsok'owo danfitsere bí ats angshefá?» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bowere, «Nee were Gelil maantsknenya? nebiyiwo Gelilitse b́ tuurawok'o p'ec'ar shuu'de dane» bo et. ");
INSERT INTO bwo_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Maniye il jametso b́ gal gal k'az bíami. ");
INSERT INTO bwo_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Maniyeokoon Iyesus Debrezyit guro maants bíami. ");
INSERT INTO bwo_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Yaatśguurok'on Ik' moo maants aanat b́waa, ash jamonwere b́ maants bo weyi, bíwere bedek't boon b́ danifere b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nemo danifuwotsnat ferisawino eteefuwots widoke detsets máátsu dek' waat ash ashi dagots ned'ibok'iri. ");
INSERT INTO bwo_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Iyesusshowere hank'o boeti, «Danifino, hamb máátsani widoke detserane, ");
INSERT INTO bwo_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Hank'o máátsu shutson togeyar b k'iritwok'owa Muse no nemotse b́ beezi, nemo b jangosh aawk'owe nieteti?» ");
INSERT INTO bwo_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Man bo etirwe bíatse bín s'amiyosh betsit keewo bodaatsitwok'o geyatni botesh, Iyesusmo dashan túmt b́ jabon datsats guut'o dek' b́ tuwi. ");
INSERT INTO bwo_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Anani bo aatre dambaan jobk' et kawdek't, «Ititse morr deshawo shini shútso k'aaú de biats shawu'e!» boosh bíet. ");
INSERT INTO bwo_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Maniyere hak aaniy tuumt datsats b́ guut'i. ");
INSERT INTO bwo_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bowere man boshishtsok'on enaashatse dek't b́ tuutso jametswots ik ikon manoke k'az boami, mansh Iyesus taalotse need'at teshts máátsu s'uznton bíaal oorbgutsi. ");
INSERT INTO bwo_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Maniyere okoon Iyesus dambaan kawdek't, «Máátsune neena! neen s'aamirwots aabno? Niats angshitso konwor aalneya?» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Biwere «Doonzono! konwor aaliye» bi eti. Iyesuswere «Taawor niats angshratse, amee gitlo morro fink'aye» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Aaninwere Iyesus «Taa datsush sháán taane, tshuuts sha'itwo bí kashosh wotit shááano daatsitwe, t'alwotsnowere anaaneratse» ett boosh b́keewi. ");
INSERT INTO bwo_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ferisawno etfwots «Nee n took jangoshe n gawiriye, n gawonwere arikaliye» boet. ");
INSERT INTO bwo_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iyesuswere hank'o ett boosh bíaaniy, «Dab taa t took jangosha tkeewiri b́wotiyalor taa ewuke t waatsok'o, aawok timiruwok'o t dantsotse t gawts gawo arikee, itmó aawoke t waatsok'onat aawok tiamirwok'o danatste. ");
INSERT INTO bwo_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","It ash etok'one it angshiri, taamó konatsor angshratse. ");
INSERT INTO bwo_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Dab tiangshiyalor taan woshtso niho taanton b́ wottsotsnat taa tial tiangshrawotse tiangsho arikee, ");
INSERT INTO bwo_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Git ashuwots gawuts gawo arik b́ wottsok'o it nemotse guut'ere. ");
INSERT INTO bwo_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mansh taa tjangosh gawituwe, taan woshts Nihonuwere t jangosh gawituwe.» ");
INSERT INTO bwo_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Manoor bo «N nih ewuke b́fa'oni?» ett bo aati. Iyesuswere «Taan wotowa t nihi wotowa danatste, taan it danink'e t nihino danank'te b́teshi» ett boosh bíaani. ");
INSERT INTO bwo_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iyesus keewan b́ keewu Ik' mootse giz dek'eyiru sat'ni ganoke bedek't b́ daniyora. B́wotiyalor b́ gizewo b́ borafa'otse konuwor bín deshatse. ");
INSERT INTO bwo_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Anyinuwere Iyesus hank'o boosh bíet, «Taawere ametuwe, itwere taan geyitute, ernmó it morrontona it k'iriti bako taa tiamiruwok it wosh falratste.» ");
INSERT INTO bwo_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ayhudi naashuwotswere « ‹Taa tiametwok it woo falratste› bíetir b́ tooko úd'ishek'una?» boats atsewo boeti. ");
INSERT INTO bwo_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Manats dabt Iyesus hank'o boosh bíet, «It daashik itne, taa dambik taane, it datsanatsik itne taamó datsanatsik taanaliye, ");
INSERT INTO bwo_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Taa Bín twottsok'o amano it k'azal it morronton it k'iritwotse it morrontoniye it k'iriti tietiye manshe.» ");
INSERT INTO bwo_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bowere «Nee konene?» boet. Iyesuswere boosh hank'o bíet, «Shintson tuzdek'at itsh t keewtsok'on taane, ");
INSERT INTO bwo_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","It jangosh t keewitwonat tiangshitwo ay keewo detsfe, s'uznmó taan woshtso ari keewetske, taawor datsush t keewitwo bíyoke t shishtsoniye.» ");
INSERT INTO bwo_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Bí niho jango b́ keewtsok'o boosh galeratse b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mannsh Iyesus boosh hank'o bíeti, «Ash na'o dambaan tuuzde'er it jitor taa bín t wottsok'o danetute, mank'o niho taash b́danitso t keewirwok'oni bako tialmec'ron eegor t k'alrawok'o manoor t'iwintsitute. ");
INSERT INTO bwo_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Taan woshtso taantoniye, aaw aawon t k'aliruwo bín geneushit keew b́wottsotse ti'ali k'azk'reratsee.» ");
INSERT INTO bwo_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iyesus man b́keeutsok'on ay ashuwots bín boamani. ");
INSERT INTO bwo_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Iyesus bín amants ayhudiwotssh hankowa bíet, «It t aap'o korede bín it beyal arikon t danifuwotsi wotitute, ");
INSERT INTO bwo_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Aronowere danetute, aronuwere iti s'ayino kishitwe.» ");
INSERT INTO bwo_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Boomó «Noo Abraham naar noone, b́ jamon konshor guuts wot danaknone, eshe nee ‹Nas'o keshetute› noosh nietir aawuk'oneya?» bo et. ");
INSERT INTO bwo_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iyesuswere hank'o ett boosh bíaaniy, «Arikon arikoniye itsh tietiri, morr finiru jamo morri guutse, ");
INSERT INTO bwo_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Guutso jam aawosh mootse beerake, na'onmó jam aawosh mootse b́befoni. ");
INSERT INTO bwo_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mansh naayo nas'o iti b́ kishyal arikon nas'o wotitute. ");
INSERT INTO bwo_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abraham naar it wottsok'o taa danfee, ernmó t keewo it de'awotse taan úd'osh it geyiri. ");
INSERT INTO bwo_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Taa t nihoke t bek'tsoniye tkeewiri, itmó it nihoke it shishtsoniye it k'aliri.» ");
INSERT INTO bwo_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bowere «Nonih Abrahamiye» ett boaaniy. Iyesuswere boosh hank'o bíeti, «Abraham nana'uwotsi it wotink'ere Abraham finoniye it finyank'oni, ");
INSERT INTO bwo_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Taaamó Ik'oke t shishts arikoniye itsh tkeewi, itmó taan úd'oshe it geyiri, Abraham mank'o k'alratse. ");
INSERT INTO bwo_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Eshe it itfiniriye it nih finoniye.» Bowere «Widon shuwets dik'al noanaliye, ik nihe nodetsi bíwere Ik'oniye» bo et. ");
INSERT INTO bwo_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Iyesuswere hank'o boosh bíeti, «Ik'o it nihi b́wotink'ermó taan shunank'te b́ teshi, taa hanok t weyiye Ik'okne, taan woshtso bína bako taa ttookon waratse. ");
INSERT INTO bwo_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Eegoshe t keewo itsh gaalo bk'azi? T aap' shisho it maawutsoshe. ");
INSERT INTO bwo_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","It itnih Diyablos nana'uwots itne, it it shuniye it nih teuniruwo k'aloshe, bi shintson dek't b́tuutso kash úd'ke, arikeewo bíyoke bíaaltsotse arikeewonton b́ jamon gonkeyo deshatse, bí kootetskonat koot jami nih b́wottsotse koto b́keewor b́ tookotse kishdek'tni b́keewiri. ");
INSERT INTO bwo_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Taayere ariko tkeewirwosh taan amaneratste, ");
INSERT INTO bwo_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Aab ititse ‹Morretsk neene› etetuwo kone? Arika t keewiri wotiyal bere, eegoshe taan amano it k'azi? ");
INSERT INTO bwo_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ik'okik wottso Ik'i aap'e b́ shishfoni, eshe it Ik'i aap'o shisho it k'azir Ik'okik woto it k'aztsoshe.» ");
INSERT INTO bwo_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ayhudiwots, «Neehe Samrawinene, Fo'erawoniye niatse fa'ee no ettso ar woteratsáá?» boeti. ");
INSERT INTO bwo_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Iyesuswere hank'o et boosh bianiy, «Taa fo'erawo tiatse aaliye, ernmó t nihiye tmangiyiri, itmó taana it ketiyri. ");
INSERT INTO bwo_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wotowa bako taa t took mango geeratse, t mangi jangosh moshetwonat taash angishitwo k'osho fa'ee. ");
INSERT INTO bwo_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Arikon arikone itsh tietiriye, ti aap'o kor dek'etwoniye b́ jamon k'irratse.» ");
INSERT INTO bwo_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ayhudiwots hank'owa bísh boet, «Fo'erawo niatse b́beyiruwok'o and danrone, dab́ Abrahmwor k'irre, nebiyiwotswere k'irrne, nemon ‹T aap'o kordek'etwo b́jamon k'irratse› etfne, ");
INSERT INTO bwo_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Eshe nee no nih k'irtso Abrahamiyere bogfiya? nebiyiwots k'irrno, eshe nee n tooko koni woshishe?» ");
INSERT INTO bwo_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iyesus hank'o ett bíaaniy, «Taa t tooko t mangiyal t mango k'auntso deshatse taan mangiyituwo t nihiye, bíwere ‹No Ik'oniye› it etirwoni. ");
INSERT INTO bwo_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","B́ wotiyalor it bín danatste, taamo bín danfee, taa bín danatse tietalmó itkok'o kootetsoniye twoti, taamo bín danfee, b́ aap'onowere kordek'etuwe. ");
INSERT INTO bwo_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","It nih Abraham ti aawo b́ bek'etwosh gene'owere, bek'tnwere gene'uwere.» ");
INSERT INTO bwo_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Manoor ayhudiwots, «Nee dab balk'ats nato woterafa'ane, eshe aawk'oneya Abrahami bek're nietiri?» bo eti. ");
INSERT INTO bwo_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iyesuswere, «Arikon ariko itsh tietiriye, Abrahamiyere shin fa'e.» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Mansh ayhudiwots bin togosh shútso k'aa'u bodek'i, Iyesusmó bo aawatse ashwutsat Ik' mootse kesht biam. ");
INSERT INTO bwo_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iyesus werindon b́beshefere ááw dog wotat shuwetso b́ bek'i. ");
INSERT INTO bwo_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","B́danifwots Iyesussh, «Danifono! ashaan dog wotat b́shuwe kon morroneya? B́ took morroneyamo bín shuutswots morroneya?» ");
INSERT INTO bwo_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iyesuswere hank'o ett bíaaniy, «Ashaan ááwu dogo wotat b́ shuuwe b́ morron wee bínshutswots morratse tuutsonaliye, ernmó Ik'o fino bíatse b́ be'eyishee. ");
INSERT INTO bwo_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Taan woshtso fino aawon fino taash geyife, asho konwor fin b́ falraw t'úwo weetwe. ");
INSERT INTO bwo_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Datsuatse t beyor taa datsush bsháán taane.» ");
INSERT INTO bwo_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Man b́ keewiyakon datsats tuf ett s'údt b́ s'údon shaawo b́ baad'i, tok'mannowere dogo aawats futt, ");
INSERT INTO bwo_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","«Amr Selihom aats kakots mashowe» bí et. (Selihom «wosheka» eta.) Mann ashman amt mashdek't s'iilfere aanat b́weyi. ");
INSERT INTO bwo_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","B́ giyuwotsnat bali b́ k'onfere bín bek't teshts ashuwots, «Ashaan andi bede'e k'onfoniyosha?» boeti. ");
INSERT INTO bwo_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ik ikwots, «Ee, ún bííne!» bo et, «K'oshwotswere bína bíari bako bínaliye!» boet. Bímó «Taane únni!» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ash ashuwotswere «Beree, aak'altniya ni'aawwots bok'esheyi?» boeti. ");
INSERT INTO bwo_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Bíwere «Iyesusi eteef asho took'o bad'idek't tiááwats futt ‹Selihom maants amr mashowe› bíet, taawere amaat mashdek'at bek'o tfali» ett bíaaniy. ");
INSERT INTO bwo_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bowere, «Ash man and aawoke b́ fa'oni?» boet. Bíwere, «Aawoke b́ beyirwok'o danatse» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Maniyehak ash ashuwots doogteshts asho ferisawino etef wotsok dek't boami. ");
INSERT INTO bwo_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Iyesus took'o bad'idek't ashman ááwwots bok'eshetwok'o b́ k'altso sanbati aawotsa b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ferisawino etfwots, «Aawuk'oneya bek'o nfali!» ett ashman aani boaati. Bíwere «Tiááwwotsats t'ok'o b́ geere mashtdek', maniyere hako bek'o tfali» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Manoor ferisawino etefuwotsitse ik ikuwots, «Ashaan sanbato b́ mangirawotse Ik'okikaliye» bo et. K'atswotswere Beree, «Morretsk wotts asho adits keewanotsi awuk'o k'alrniya fino b́faliti?» bo et. Manatse tuutson bodagotse bo keewo k'osha k'oshewo b́woti. ");
INSERT INTO bwo_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mann ááw dog wotat teshts ashmansh, «Ni ááwo taash shanire nietiru ashman jango eege nieteti?» ett aaniy gitlo boaati. Bíwere «Nebiyiye!» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ashaan dog wotat b́ teshtsok'onat ilomo bí ááwo aawk'on b́ k'eshetsok'o b́indnat nihon s'eegdek't boatfetso ayhudi naashuwots amaneratsno b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Mann b́ nihonat indunsh, «Dog wotat shuwere it etts it na'o hanneya? Eshe and awuk'o k'altniya bek'o b́fali?» ett bonboaati. ");
INSERT INTO bwo_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","B́ nihnat indún hank'o ett boaaniy, «Ashaan no naayi b́wotonat dog wotat b́shuwewo danfone, ");
INSERT INTO bwo_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ernmó and awuk'on b́ bek'iruwok'onat bíááwwotsi kon bísh b́k'eshtsok'o danatsone, bín aatwere, bí ash een b́wottsotse bí b́ jangosh keewo falitwe.» ");
INSERT INTO bwo_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","B́ nihnat indn han boetuwere Iyesussh «Krstosiye» eteet asho b́beyal ayhudi naashuwots Ik' mootse kishosh ik wotdek't boteshtsotse boon boshattsosha b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Mansh bínshutswots, «Bihe ash eene, bín aatwere» boet. ");
INSERT INTO bwo_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Maantse tuutson ááw dog teshts ashman aaniy s'eegdek't, «Nee ariko keewr Ik'o mangiwe, ashaan morretsk b́woto no danfone» boet. ");
INSERT INTO bwo_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Aawu dog teshts ashmanwere, «Bi morretsk b́woto taa danatse, s'uz ik keewo danfee, manwere taa dogo tteshtsok'onat and bek'o tfaltsok'one» ett bíaaniy. ");
INSERT INTO bwo_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bowere, «Neesh ege b́ k'ali? Ni ááwonowere awuk'o k'altniya b́ kashiyi?» bo eti. ");
INSERT INTO bwo_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Biwere, «Shinowere keewere itmó k'ebo geratste, eshe eegoshe aani ando k'ebo it geyiri? It b́ danifwotsi woto geefteya?» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bowere hank'o ett bín boc'ashi, «Iyesus danifo neena, nohe Muse danifwots noone, ");
INSERT INTO bwo_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Musenton Ik'o b́keewetsok'o danfone, ashaahanmo ewukik b́wottsok'o danatsone.» ");
INSERT INTO bwo_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ashmanmo hank'o et boosh bíaaniy, «Ashaan awokik b́ woto it daro adike! ernmó tiaawwotsi shanitso bíne. ");
INSERT INTO bwo_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Morretswots keewo Ik'o b́ k'ewawok'o daneke, ernmó Ik'o mangifonat bshunts fino k'aliru asho b beyalr bín Ik'o shishfe. ");
INSERT INTO bwo_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Aawu dog wotat shuwets asho ááwo k'eshetso fa'ee etefere datsan bíazeron shish danerake. ");
INSERT INTO bwo_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ashaan Ik'okik woto b́k'zink'e eegor k'alosh falrawunk'e b́teshi.» ");
INSERT INTO bwo_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bowere, «N keew jamo morron s'enat shuwetsono! Nee noon daniysheya?» ett ayhudiwots Ik' k'oni mootse kishbok'ri. ");
INSERT INTO bwo_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ashman ayhudiwots Ik' k'oni mootse kish bok'rtsok'o Iyesus shish b́k'r, bin b́datstsok'onowere, «Ash na'on amanituwiya?» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Bíwere, «Doonzono! bín ti amanish kone bi?» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iyesus, «Bín bek'rne, and neenton keeweyirwonwere bíne» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Bíwere, «Doonzono! amanitwe» ett bísh b́sagadi. ");
INSERT INTO bwo_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iyesuswere, «Be'aawwots bobek'etwok'o, bek'irwotswere bodogetwok'o taa datsanats angshosh waaree» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Manoor Iyesus ganoke fa'a ferisawino eteefwots «Eshe noowere ááw dognona eteya?» boeti. ");
INSERT INTO bwo_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iyesuswere, «Aaw dog it wotink'e morro it ats woterawnk'e, andmo bek'irwone it etirwotse morretswotsi wotarr ooritute» bí eti. ");
INSERT INTO bwo_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Manatse tuut Iyesus hank'o bíeti, «Ariko arikone etirwe itsha, mererwots kúrots fengeshon kindraawo k'osh weeron kinditwo ump'etsonat wombedewotsne. ");
INSERT INTO bwo_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Fengeshon kinditwonmó mererwotsi jintsoniye. ");
INSERT INTO bwo_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Bíshe fengesh kotirwo k'eshitwe, mererwotswere b́ k'aaro shishetune, bi were b́ took mererwotsi boshutson s'eegetwe, jishde'ernwere ametuwee. ");
INSERT INTO bwo_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","B́took mereer jamwotsi b́ kishihakon bo shin shinatse sha'itwe, b́ mererwotswere b́ k'aaro bo dantsotse b́ shuutso shoydeniye bo sha'iti. ");
INSERT INTO bwo_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","K'osho k'aaronmó bodanawotse bíyatse oka bowos'eti bako b́jámon b́ shuutso amatsne.» ");
INSERT INTO bwo_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iyesuswere jewraan boosh b́keewi, bomo boosh b́keewetso t'iwintsratsno. ");
INSERT INTO bwo_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Mansh Iyesus ando aani hank'o boosh bíet, «Arikon arikoniye itsh ti etiriye taa mererwots fengesh taane, ");
INSERT INTO bwo_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Taayere shin waats jametswots úmp'etswotsnat bik'knee, mererwotsu bon shiyatsne. ");
INSERT INTO bwo_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Fengesho taane, tweeron kinditwo kashitwe, kinditwe, keshetwe, jinokono daatsitwe. ");
INSERT INTO bwo_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Úmp'etsonmo b́ weyiŕ úmp'isha, shukonat t'afiyon s'uzsha, taamo t waa boowere kasho daatsr s'eent s'eenk kasho bodetsetwok'owe. ");
INSERT INTO bwo_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Jints sheengo taane, jints sheengo b́ kasho b́ mererwotssha err beshide imetwe. ");
INSERT INTO bwo_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Btokk woteraw mereer jintso b́ jinish keeweka bako ari jints woterawonu lawuwo b́ waare b́bek'or mereruwotsi k'ak'rarni b́wos'eti, lawuwonwere mererwotsi bi'ide bad'ib́k'riti. ");
INSERT INTO bwo_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jintsman k'az b́wos'irwe keewek b́wottsonat mererwotssh kis'odeshawo b́wottsone. ");
INSERT INTO bwo_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Jints sheengo taane, taa t mererwotsi danfee, t mererwotswere taan danfnee. ");
INSERT INTO bwo_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Taa boon t daniru niho taan b́dantsok'o dani naaronat taawere niho t dantsi naaronee, taa t mererwotssh t kasho beshide imetwe. ");
INSERT INTO bwo_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mereer s'eenanitse woterawo k'oshuwotsitse wotts mererwotsi detsfe, bonowere jisho taash geyife, boowere t k'ááro shishetune, ikoki mereer s'eene bowotiti, jinirwonwere ike b́ wotiti. ");
INSERT INTO bwo_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","«Aani tdek'et kashú ti ímetwotse t nih taan shunfee. ");
INSERT INTO bwo_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Taa t kashu tshunon imetuwe bako tiatse konwor bin dek'etwo aaliye, t kashu imr aninuwe dek'osh alo detsfe, tzaziman tdek'were t nihoknee.» ");
INSERT INTO bwo_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","B́ keewtsmanatse tuutson ayhudiwots dagotse k'osh k'oshewo wotbwtsi. ");
INSERT INTO bwo_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Boyitsnowere ayuwots, «Bí bíatse fo'erawoniye fa'oni, geewtsere, eegishe bín itk'ebiri?» boeti. ");
INSERT INTO bwo_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","K'oshuwotsuwere, «B́keew keewan fo'erawo detsts ash nonotse keshetkaliye, fo'erawo bo ááwu dogwots aawo k'eshosh falituwa?» bo eti. ");
INSERT INTO bwo_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Iyerusalemitse Ik' maa nato bíhandrtsi worwoti bali aawo b́bodi, manoronwe joosha b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Iyesus Ik' mootse Solomon bí anaanef werindatsna bí ananefer b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Manoor ayhudiwots b́ ganok ko'edek't, «Awurish b́ borfetsone git nibon noon nja'iti? Nee Krsttosi n wotok'o danide noosh keewwe» boeti. ");
INSERT INTO bwo_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Iyesusu hank'o ett boosh bíaaniy, «Taa itsh keewre, itmó amaneratste, t nih shútson tfiniru fino t jangosh gawitwe. ");
INSERT INTO bwo_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Itmó t mererwotsitse woto itk'aztsosh amaneratste. ");
INSERT INTO bwo_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","T mererwots t k'aaro shishetune, taawere boon danfee, boowere t shuutso sha'itúne. ");
INSERT INTO bwo_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Taa dúre dúri kashone boosh imetwe, manshe b́jamon t'afratsne, t kishotse konwor boon kishdeatse. ");
INSERT INTO bwo_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Boon taash imtso t nih jamoniyere bogfe. Tnih kishotse boon bi'dek'o falitwo konwor aaliye. ");
INSERT INTO bwo_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Taana ett Aabn ik noone.» ");
INSERT INTO bwo_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ayhudiwotś manoor ando aani bín togosh shútso k'a'ubodek'i. ");
INSERT INTO bwo_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Iyesuswere, «T nihoke sheeng fin ayuwotsi itsh kitsre, eshe it taan it togir t fints hanotsitse aawsha etatniya?» bí eti. ");
INSERT INTO bwo_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bowere, «Noo neen notogir Ik'o nc'ashirwosha bako n fints sheeng finoshaliye, manwere nee ash wotefetsat́ n tooko Ik' n woshtsoshee» ett bísh boaaniyi. ");
INSERT INTO bwo_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iyesuswere hank'o boosh bíet, «It nemotse ‹Itiye ik'wots it nee, eteere› ett guut'etso aalneya? ");
INSERT INTO bwo_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Eshe S'ayin mas'aafo sharosh faleratse, boosh waats Ik'i aap'o S'ayin mas'afo Izar Izewerotsi ett s'eegere. ");
INSERT INTO bwo_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Eshe, Niho S'ayntst datso maantsan b́ doyitso ‹Ik' na'o taane› bí ettsosh eegoshe ‹Ik'o c'ashre› it etiri? ");
INSERT INTO bwo_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Taa t nih fino fineratse wotiyal taan amank'ayere. ");
INSERT INTO bwo_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","T nih finirwoni t finiri wotiyalmo taan dab́ amano it k'azalor t finiru finon amanore, hank'on niho taanton b́ wottsok'onat taawe nihonton twottsok'o shengshde danetute.» ");
INSERT INTO bwo_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bowere ando aani bín detsosh bogeyi, bímó bo kishotse kesht k'az bí'ami. ");
INSERT INTO bwo_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Iyesus ando aani Yordanos fokoniye kimt Yohanis bali b́ gupfok bíami, manoknowere b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ay ashuwots bíyok wáát́, «Yohanis adits fino egoŕ fineratse, ernmó Yohanis ashaan jango b́ keewts jamo aree b́ teshi» bo et. ");
INSERT INTO bwo_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Manoknowere ay ashuwots bín bo amani. ");
INSERT INTO bwo_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betanitse beyirwo Alazari eteets ash iko shoodtni b́ tesh, Bitaniya eteyru man Mariyamnat bmish Martan bo beyru galuni b tesh. ");
INSERT INTO bwo_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariyami etetsmanwere doonzo tufats shitwo futat b took s'iron firtsuni, shodirúwonu bi eshu Alazari b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mish gitwotswre, «Doonzono! n shunfo shoodwtsere» ett Iyesusok woshbok'ri. ");
INSERT INTO bwo_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Iyesusu man b́ shishtsok'on, «Shodan k'irosh betsitkaliye, s'uznmó Ik'osh mango b́ wotitwok'onat Ik' na'o bín b́ mangishe» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iyesus Martanat bmish Mariyamna bo eshu Alazarnowere, shuna b́ shunfo. ");
INSERT INTO bwo_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mansh Alazar shodo b́ shishiyakon b́beyrmanok git aawo k'az b́ jin. ");
INSERT INTO bwo_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Maniyakon b́ danifwotssh, «Woore Yhud datsats ando aanar amone» boeti. ");
INSERT INTO bwo_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","B́ danifwotsu, «Danifono! ayhudiwots karn aawotse shútson neen jot'oshe bogeyri bo teshi, eshe nee ando manmaantsan amooshe ngeyiri?» boet. ");
INSERT INTO bwo_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iyesus hanek'o ett boosh bí aani, «Ik aawotse tatse git sa'atosha? Aawon shairwo datsan shááno b́ bek'irwosh t'ugo bín dikratse. ");
INSERT INTO bwo_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ernmó t'úwon sha'irwo shááno b́gitsotse b́deshawosh t'ugo bíne b́dikiti.» ");
INSERT INTO bwo_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iyesus man boosh b́keewiyakon, «No mash Alazar tokrwtsere, taamo bín tokrotse tuzosh ametuwe» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","B́danifwotstswere, «Doonzono! tokratni b́fa'oni wotiyal bére shamp'itwe etee» boeti. ");
INSERT INTO bwo_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Iyesus man b́keewirwe Alazar K'iri jangosha b́ tesh, ernmó b́ tokeri jango b́keewirwok'owa boosh bíari, ");
INSERT INTO bwo_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Mansh Iyesus kitsdek't́ sháánon hank'o ett boosh b́ keewi, «Alazar k'irre, ");
INSERT INTO bwo_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","It it amanitwok'o taa manoke ti aalo itsh taan geneúshre, andmó b́ maants amone.» ");
INSERT INTO bwo_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Manoor Didimosi eteetso Tomas b́ danif k'oshwotswere, «Bínton no k'iritwok'o nowoor amone» boet. ");
INSERT INTO bwo_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Iyesus manok b́ bodtsok'on Alazari duketsi awd aawo b́ jiniyakon amt b́daatsi. ");
INSERT INTO bwo_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betaniya Iyerusalematse keez kilo metrok'oyi bwoki. ");
INSERT INTO bwo_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ayhudiyotsitse aywots Martanat Mariyamn boeshu b́ k'irtsosh boon kup'iyosh bowok waatni bo tesh. ");
INSERT INTO bwo_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta Iyesus woo b shishtsok'on bín dek'osh bweyi, Mariyammó mootsa btesh. ");
INSERT INTO bwo_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta Iyesussh, «Doonzono! nee hanoka nfa'oni wotink'e ti eshu k'irrawnk'e b́teshi, ");
INSERT INTO bwo_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ernmó andoru nk'onitu jamo Ik'o neesh b́imetwok'o danefe» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Iyesuswere «Ni eshu k'irotse aaniy tuwitwe» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martawere, «Dúr s'úwatse k'irtswots k'iro da'ar bo tuwor bíwere k'irotse b́ tuwitwok'o danfee» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iyesuswere, «K'ir tuwonat kashon taane, taan amantso b́k'iriyaloru kashone b́beeti, ");
INSERT INTO bwo_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kashon befetst taan amants jamo k'irratse, han amanitwiya?» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Bíwere, «Ee doonzono! nee datsats waatso Krstosi Ik' na'o nwottsok'o amanitwe» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta han bkeewiyakon b mishsh amaat «Danifo waat neene b́ s'eegiri» etaat shashkon b s'eegi. ");
INSERT INTO bwo_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariyam man b shishtsok'on kááron tuwat bíyok bíami. ");
INSERT INTO bwo_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Manoor Iyesus Marta bín bbek'ori b́beyirwoka bako galots kindrafa'e b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mariyami kup'iyosh waat́ mootse binton towat beyiru ayhudiwots Mariyam kaaron tuwat bkesho bek't Alazar doowo maants amr biepetwok'o boosh bíarere b shuutso bo tuwi. ");
INSERT INTO bwo_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariyam Iyesus beyirwok waat bín bbek'tsok'on b́ gubrats dihat, «Doonzono, nee hanoke fa'ane wotink'e ti eshu k'irrawk'ee b́ teshi» bi'eti. ");
INSERT INTO bwo_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Iyesuswere bínton waatswotswere boepfere b́bek'tsok'on b́ shayiri fayon shiyanat, ");
INSERT INTO bwo_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","«Aawoke bín it duuki?» bíet. Bowere, «Doonzono! waa s'iile» boet. ");
INSERT INTO bwo_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iyesuswere bí áác'uwo b́kuut'i. ");
INSERT INTO bwo_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mansh Ayhudiwots, «Aawk'o bín b́shunfok'o s'iilere» boet. ");
INSERT INTO bwo_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Boyitsi ik ikwotsmo, «Ááwdogo ááwo kashitsan, ashaan b́k'irrawok'o woshomawiyank'a b́teshi?» bo eti. ");
INSERT INTO bwo_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Iyesus ayidek't shiyanefere doowo maants bíami, dowonwere shútson ipeek shúts gop'a b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Iyesus, «Shútsman k'aa'úbayere» bí eti. K'irtso mish Martaá, «Doonzono b́ k'irihakon awd aawo wotere, and b́ sháák'o shok'etwe» biet. ");
INSERT INTO bwo_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Iyesuswere, «Niamaniyalee Ik'o mangone bek'etune eratstáá neesha?» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ashuwotswere shútso k'aaú bobazi, maniyere hakon Iyesus dambaan s'iilt, «Nihono! taan n shishtsosh mango neesh boree, ");
INSERT INTO bwo_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Jam aawonor taan nshishetwok'o danfee, ernmó han ti et, hanoke need'iru ashuwots taan nee nwoshtsok'o bo amanisha etaatniye» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iyesus man b́keeswihakon «Alazaroo! waa kee!» ett k'áári eenon b́keewi. ");
INSERT INTO bwo_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","K'irtso Alazarwere b́ kishwotsnat b́ tufwotsn duuni tahon bo t'at'etsok'on dowootse b́ keshi, b́shitsonwere tahon b́t'at'etsok'ona botesh, Iyesuswere, «Bín bish k'rore, amee!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mariyami ang kup'iyosh wáát teshts ayhudi wotsitse ayuwots b́k'altso bek't Iyesusn boamani. ");
INSERT INTO bwo_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ik ikwotsmo ferisawino eteefwotsok amt́ Iyesus b́ k'altso boosh bo keewi. ");
INSERT INTO bwo_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mansh kahni naashwotsnat ferisawino eteefwots moosh mooshirwotsi kakudek't hank'o boet, «Ashaan ay adits keewwotsi b́ finirwotse awuk'o nok'alink'e k'úna b́k'aniti? ");
INSERT INTO bwo_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","S'ker hank'on bín k'aynok'riyalo ashjamo bín amanitwe, Rom dats ashuwots wáár no beyokonat no ash jamo ishbazetune.» ");
INSERT INTO bwo_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ernmó boyitsi iko mandúr kahni naashwotsatsi k'aabo K'eyaf hank'owa bíet, «It eegor danatste, ");
INSERT INTO bwo_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ashjamo b́t'afoniyere ik asho ashjami shegro b́k'iro itsh b́k'anitwok'o b́jamon t'iwintsratsteya?» ");
INSERT INTO bwo_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Bí man b́ keew b́ took danonali b́tesh, mandúr bí kahni naash abaatsi k'aabo b́teshtsotsena, Iyesus ayhudi ashuwots shegro b́k'irtwok'o kitsosha bek'han b́keewi. ");
INSERT INTO bwo_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","B́k'iritwere ayhudiwots mec'rosh b́woterawo, bad'ts Ik'inana'úwotsnowere ikok kakwosha b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Mansh manots aawotstson Iyesusi bo'úd'itwok'o shiyebowts. ");
INSERT INTO bwo_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Maniyakon Iyesus ayhudiwots dagotse be'at anaaneratse b́tesh, ernmó manoke kesht worwi ganoke fa'a Efremi eteef kitu maants bíami, manokno b́danifwotsnton k'az b́ oori. ");
INSERT INTO bwo_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ayhudi Fazig baaliyo t'intnib́teshi, boyitsi ayuwotswere fazigi baliyiman b́bodfetso botoko s'ayintsosh gat'ariyon Iyerusalem maants bowáá. ");
INSERT INTO bwo_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bowere Ik' mootse need'dek't Iyesus b́wááfetso bokotfotse, «Eebi it asaabiri? Baliyoke areratsa itsha?» Ett boatsatsewo bo aatefrera botesh. ");
INSERT INTO bwo_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ando kahni naashwotsnat ferisawiwotsn Iyesusi detso bofalitwok'o b́beyoko dants asho b́ beyal boosh b́kitsitwok'o ashjamosh azazatni botesh. ");
INSERT INTO bwo_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ayhudi fazigi worwoti baaliy aawo bodosh shirt aawo b́ oortsok'on, Iyesus Bitaniy maants bíami, Bitaniyo Iyesus k'irotse b́tuuztso Alazar b́beef galuni bteshi. ");
INSERT INTO bwo_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Manoknowere kooc'misho bísh k'aniibok'ri, manoknowere finiru Martayi btesh, Alazarwe mishimarats t'intswotsitsi ikoni b́teshi. ");
INSERT INTO bwo_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Manoor Mariyam b́ gizo ayidek't shaaw wottso Nardosiya eteets mitatse dozets shituwo ik t'armusi bado wotitwo ik b́lk'at'iyo dek'amaat bín Iyesus tufo fuutbk'ri, b toks'ironowere firbbazi, maa manwere shitú sháák'on s'een b́gutsi. ");
INSERT INTO bwo_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","B́ danifwotsitsi iko Iyesusi beshide imetwo Keriyot datstso Yhud, ");
INSERT INTO bwo_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Shituwan keez bal dinriyosh kemde b́ gizman t'owwotssh imok'aze eegishe?» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Bí man b́ keewwere, t'owwotssh maac'o k'ewatni woterawo, bí úmp'ets b́wottsosha b́tesh, gizi k'arc'ito detsfo bí b́teshtsotse k'arc'itots gedets gizo dek'o danb́dek'tsosha b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Iyesus hank'owa bíet, «T duuket aawosh b k'anitsotse bine k'ayere. ");
INSERT INTO bwo_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","T'owwotsiye jam aawo itntoniye bofa'oni, taamó úni aawo itntoniyaliye t beeti.» ");
INSERT INTO bwo_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Manoor ayhudiwotsitse ayuwots Iyesus Bitanin b́ fa'ok'o dank'rat boweyi, bowaatsonwere Iyesus mec'rosh b́woterawon Iyesus k'irotse b́tuuztso Alazarnowere bek'osha b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kahni naashwotsmó Alazarnor úd'osh bo shiyeyi. ");
INSERT INTO bwo_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Bíyatse tuutson ayhudiwotsitse aywots amt Iyesusi bo amantsotsna. ");
INSERT INTO bwo_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Yatsok'on fazig baaliyosh waats ay ashuwots Iyesus Iyerusalem maants b́weetwok'o shishbok'ri. ");
INSERT INTO bwo_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mansh woli maaro detsdek't bín mangon dek'osh bokeshi, «Hosa'ana! doonzo shúútson wetwo Isra'el naasho deereke!» etfetst bokuhefere botesh. ");
INSERT INTO bwo_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iyesus daaz na'o daatsdek't bíats beeb́dek'i, man b́ wotwere, ");
INSERT INTO bwo_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Nee S'iyon ni'e, Iyerusaleme shatk'aye! Hambe! n naashoniye daaz na'ú ats keede'er weetwe» ett bek'on guut'etso b́ s'eenetwok'owe. ");
INSERT INTO bwo_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","B́ danifwotssh keewan bal boosh galeratse b́tesh, ernmó Iyesus b́mangiyakon keewan b́jangosh b́guut'etsok'onat bísho k'aletsok'o gawbodek'i. ");
INSERT INTO bwo_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Iyesus Alazari dowootse s'eegt k'irotse b́tuuzor bínton teshts jamwots Iyesus jango bogefera botesh. ");
INSERT INTO bwo_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ay ashuwots bínton gonkewosh bowowwere adits keewan b́finetsok'o shisht boteshtsosha. ");
INSERT INTO bwo_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Manoor Ferisawino eteetswots, «Eshe! dats jamatsi ash jamo b́shuutso tuure! noo eegor k'alo no maawtsok'o bek'irutosha?» Bo ats atsewosh boet. ");
INSERT INTO bwo_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Baalyi aawor Ik' k'onosh Iyerusalem maants amts ashuwotsitse, Grik datson watswots bítse fa'ano botesh. ");
INSERT INTO bwo_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bowere Gelil datsatse Betesayid galits ash wottso Flip'osok t'iindek't, «T doonzo! Iyesusi bek'o geefone» boeti. ");
INSERT INTO bwo_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip'oswere amt́ Indriyassh keew b́k'ri, Indriyasnat Filip'osn towat amt Iyesussh keew bok'ri. ");
INSERT INTO bwo_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Iyesuswere hank'o ett boosh b́keewi, «Hamb ashna'o b́mangit sa'ato bodre, ");
INSERT INTO bwo_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Arikon aroniye itsh tietiri, Sndeyi ááwu datsats fed'ar b k'iriyalabako biaaliye b ooriti, bk'iriyalmó ayo shuwitwane. ");
INSERT INTO bwo_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","B́kashu shuntso bin t'afitwe, datsanatse b́kashú shit'etwonmó dúre dúri beyosh gerdek'etwe. ");
INSERT INTO bwo_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Taash finosh geyirwo t shuutso wowe, taash fiintwonwere taa tbeyrwok beetwe, taash fiinitwonowere t nihi bímangitwee.» ");
INSERT INTO bwo_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Maniyak Iyesus hank'o bí et, «And eshe! t kashu kic'wtseraniyee, awk'oye ti'eteti eshna? Nihono! sa'atanatse taan fariwe erta? Man tierawok'o taa twaa kic'its gond bek'i sa'atanshee. ");
INSERT INTO bwo_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nihono! n shútso mangiwe.» Maniye il «Tshútso mangire, aaninwere mangitwe!» etts k'iro darotse b́weyi. ");
INSERT INTO bwo_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Manoke need'iru ashuwots man boshishtsok'on, «Guumee!» boet. K'atsetswotswere, «Melakiye kewtsoni!» bo eti. ");
INSERT INTO bwo_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Iyesusmó hank'o ett bíaaniy, «K'aaran b́weyiye itsha ettni bako taasha ettniyaliye, ");
INSERT INTO bwo_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Datsanats angshet andee, datsani keewts Shed'ano úromaants b́juwet andee, ");
INSERT INTO bwo_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Taawere datswatse dambaan dambaan taan k'aúwewor ashjamo t maants geetsitwe.» ");
INSERT INTO bwo_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iyesus han b́keewtsonwere ááw naari k'iron bk'iritwok'o kitsosha. ");
INSERT INTO bwo_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ashuwotswere «Nemotse guut'ere nodatstsok'osh ‹Krstos dúre dúeosh beetwe› etke, ‹eshe nee, ash na'o dambaan dambaan tuwitwe› nietiri aawk'oneya? Ash na'amanmo kone?» boeti. ");
INSERT INTO bwo_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Iyesus hank'o boosh bíet, «And muk'na'a gizeyosh shááno itnton fa'ee, t'aluwo itats b́borawok'o shááno itsh b́befere ananore, t'aluwots sha'efo aawok bíamirwok'owo danatse. ");
INSERT INTO bwo_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Shááno nana'uwotsi it wotitwok'o shááno itsh b́befere sháánman amanore,» Iyesus man b́keewiyakon amt boatse áásh b́wtsi. ");
INSERT INTO bwo_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Iyesus ay adits keewwotsi boshinatse b́ fiiniyaloru ayhudiwots bín amaneratsno. ");
INSERT INTO bwo_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Man b́wotirwere Nebiyiyo Isayasn, «Doonzono! no keewtso kone amani? Doonzo angonmó konshe b́be'eyi?» Ett b́keewtso b́s'eenishe. ");
INSERT INTO bwo_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Hanatse tuutso Isayas bíettsok'on amano maawrne. ");
INSERT INTO bwo_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Bo ááwoń be'efetsr Bonibotse t'iwintsr Boaanere boon b́kashirawok'o Ik'o bo ááwo deekb́k'rere, Bonibonowere dungik'rere.» ");
INSERT INTO bwo_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isasayas han bíetiye Iyesus mango b́bek'etsoshe, manshe han Iyesus jangoshe b́keewiri. ");
INSERT INTO bwo_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","B́wotefere Ayhudi naashwotsitse dab ayuwots Iyesusn amanerno, ernmó Ferisawino eteefwots Ik' k'oni mootse boon bokishrawok'o shatt b́ jango sháánon kish keewratsno. ");
INSERT INTO bwo_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Man bok'alwere Ik'oke daatset mangoniyere ashoke daatset mango boshuntsotsne. ");
INSERT INTO bwo_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Iyesuswere b́k'aáro eenshdek't hank'o etre, «Taan amantso t s'uzi b́ woterawo, taan woshtsonowere amanirwe, ");
INSERT INTO bwo_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Taan bek'irwonwere taan woshtso bek'irwe, ");
INSERT INTO bwo_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Taan amanit jamo t'aluwotse b́berawok'o taa sháán wotat datsats waare. ");
INSERT INTO bwo_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ti aap'tso k'ewde finats jitsrawats angshitwo taanaliye, taa t weyiye datsu kashiyisha bako datsats angshoshashaliye. ");
INSERT INTO bwo_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Taan geerawonat t aap'ono de'aw ashaats angshitwo fa'ee, taa t keewts aap'o dúri s'uwatse bíats angshitwe. ");
INSERT INTO bwo_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Taa t took alon keewratse, taa tietirwonat tkeewts tzaziyono taash imtso taan woshtso Aabiye. ");
INSERT INTO bwo_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Bí alonwere dúre dúri kasho b́wottsok'o danfee. Mansh taa tkeewirwo niho aab taash b́ keewtsoniye.» ");
INSERT INTO bwo_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Manoronú fazigi baaliyoniyre shina b́ tesh, Iyesus datsani k'ayr nihok bíamet aawo b́bodtsok'o danb́k'ri. Datsanatse fa'a b́jirwotsi shunk'ratni b́tesh, b́jamoonowere shunb́k'ri. ");
INSERT INTO bwo_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Iyesusnat b́danfwots kooc'misho bomefera boteshi, Simon naay Kiriyot dats asho Yihudmó Iyesusi beshide b́'imetwok'o Diyablos b́nibots gond keewo gedb́k'ri. ");
INSERT INTO bwo_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Niho al jamo bísh bí imtsok'onat Ik'oke kesht b́waatsok'o, Ik'o maantso aanar bíametwok'o Iyesus danfee b́teshi, ");
INSERT INTO bwo_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mansh mishimaratse k'aztuut b́shemo dats gedb́k'ri, bín firet taho k'aaúdek't b́gebats edb́dek'i. ");
INSERT INTO bwo_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Maniyere il tufmashi k'ac'ots aatso geddek't b́danifwots tufo masho dek'b́tu, b́ ed'ts tahmannowere botufo b́fir. ");
INSERT INTO bwo_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Iyesuswere Simon P'et'rosok b́waatsok'on Simon P'et'ros, «Doonzono! neene t tufo masheti?» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iyesuswere «Taa t k'alirwo nee and danatsne, aytsmo t'iwintsitune» bíet ");
INSERT INTO bwo_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","P'etroswere «Nee t tufo b́jamon mayatsne!» bí et. Iyesuswere «Taa n tufo masho tk'azal nee tiyoke bano deshatsne» ett bí aaniyi. ");
INSERT INTO bwo_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon P'et'roswere «Doonzono! mank'oyi wotiyal bére ttufmec'ro b́woterawo tkishonowere, ttookonowere maye!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iyesuswere «Bí aats mashtso b́ jamon s'ayin b́wottsotse b́ tuf mashoniye okoon k'osho geyiratse, itwere s'ayinwots itne, ernmó it únetsiyaliye» bí eti. ");
INSERT INTO bwo_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iyesus «It únets s'ayin itnaliye» bíet bín beshide imetwo koni b́wottsok'o b́ dantsosha b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Botufo b́ mashiyakon b́ taho tahdek't b́ beyok aanat beebdek'i, hank'owo boosh bíet, «Itsh eeg t k'altsok'o t'iwints dek'rteya? ");
INSERT INTO bwo_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","It ‹Danifonat doonoza› etfte taasha, taa danifonat doonzo twottsotse it ettso aree. ");
INSERT INTO bwo_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Eshe taa itsh doonznat iti danifo wotefetsat it tufo t mashihakon it it atsatsewosh it tufo masheyo geyitwe. ");
INSERT INTO bwo_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Taa itsh tk'altsok'o itwere it k'alitwok'o ariyosh wotitwo itsh beezree. ");
INSERT INTO bwo_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Aron arikone itsh keewirwe, guutso b́ doonzoniyere bowakee, wooshetsonwere bín woshtsoniyere bowakee. ");
INSERT INTO bwo_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Keewan dande finats it jitsink'ere derek itne. ");
INSERT INTO bwo_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Han tkeewir it únetsishaliye, taa t galdek'tswotsi danfee, ernmó ‹T mish máátso gondon tiatsats tuure› etiru S'ayin mas'aafotse beyiru aap'o b́s'eeno geyife. ");
INSERT INTO bwo_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Man b́wotoniyere shino itsh t keewiri, b́ s'eeniyakon taa Bín twottsok'o it amanishee. ");
INSERT INTO bwo_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Arikon aronee itsh t keewiri, taa t woshtso dek'etwoniye taan de'k'etwe, taano dek'etwo taan woshtsonowere dek'etwe.» ");
INSERT INTO bwo_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iyesus man bí etiyakon b́ shayiron kic'at «Aron, arikoniye itsh t etiri, ititsi iko taan beshide imetwe» et kishdek't b́keewi. ");
INSERT INTO bwo_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","B́ danifwots b́ keewirwan kon jango b́wottsok'o bodartsotse bo atsatsewo bos'ile. ");
INSERT INTO bwo_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Iyesus b́danifwotsitsi b́shnf iko Iyesus ganokt bedek'tni b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon P'et'ros kolat, «Konjango b́keewtsok'o aab aatwe» bí eti. ");
INSERT INTO bwo_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mann bí Iyesusok t'intsdek't «Doonzono! neen beshide imetwo kone?» ett bíaati. ");
INSERT INTO bwo_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Iyesuswere «Bíye mishan iton itde bísh ti'imetwoniye» bí eti. Man bí'ettsok'on misho iton itdek't Kiriyot ash wottso Simon naay Yihudsh b́ imi. ");
INSERT INTO bwo_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yihud imetsman b́dek'iyakon manoor Shed'no bíatsots s'een b́utsi, Iyesuswere Yihudsh, «K'alosh ngeyirwo káári k'alwe!» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Iyesus eegosh mank'o bíettsok'o mishimaratse beyirwotsitse konwor dantso aali b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yihud giz detsfo b́teshtsotse b́ danifwotsitsi ik ikwots Iyesus «Baliyosh noosh geyitwo keewowe wee t'owwotssh ime» bíettsok'owa boosh bíari. ");
INSERT INTO bwo_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yihdwere tiits imetsman b́dek'tsok'on manoor kesht k'az bíami. Manoronwere t'úwa b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yihud kesht bí amiyakon Iyesus hank'o bíeti, «And ash Na'o mangree, b́ yatse tuutsonowere Ik'o mangree, ");
INSERT INTO bwo_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ik'o b́jangatse tuutson b́mangtsotse Ik'onwere bín mangitwe, muk'i b́teyawoniye bín b́mangitye. ");
INSERT INTO bwo_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","T nanaúwotso! itnton tteshet ay gizeyoshaliye, itwere taan geyitute, Ayhudi naashwotssh ‹Taa tiametwok it woo falratste› ti ettsok'o, andoor itsh mank'o eteetwe. ");
INSERT INTO bwo_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","It atsatsewo it shuneetwok'o handr tzaziwo itsh imirwe, taa itn tshuntsok'o itwere it atsatsewo shunewere. ");
INSERT INTO bwo_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","It atsatsewo it shunetka wotiyal t danifwotsi it wottsok'o ash jamo danetwe.» ");
INSERT INTO bwo_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Maniyere il S'mon P'et'ros Iyesussh, «Doonzono! aawke niameti?» ett bíaati. Iyesuswere «taa tiametwok and taanton woo falratsne ilmó tshuutso woo falitune» ett bíaniyi ");
INSERT INTO bwo_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","P'et'roswere «Doonzono! eegoshe and nshuutso woo tmawiti? Taa t kasho dab neesha err beshide ímetwe» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Iyesuwere «Nee nkasho taasha err beshide imetwiya? Aron arikoniye neesh ti etiri, hambets baako b́ k'ad́ftsere shino keezoto taan haalitune» ett bíaaniy. ");
INSERT INTO bwo_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Manats dabt Iyesus hank'owa bíet, «Kic'k'ayere, Ik'on amanore, taanowere amanore, ");
INSERT INTO bwo_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tnih mootse ay beewoke fa'oni, mank'o wotob́k'azink'eremó it beetwoko k'aniyosh ametuwe erawnk'e b́teshi. ");
INSERT INTO bwo_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Amr beyoko itsh t k'aniyakon taa t beyirwoke itwere it beetwok'o aanar waar itn dek'etwe. ");
INSERT INTO bwo_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Taa ti amiru werindonoewere danfte.» ");
INSERT INTO bwo_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomaswere «Doonzono! aawok niamirwok'o danatsone, eshe, weerindo awuk'o k'alrniya dano nofaliti?» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iyesuswere hank'o et bísh bíaaniy, «Weronu aronu kashonu taane, t weerona bako konwor nihok bodetwo aaliye. ");
INSERT INTO bwo_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Taan danrte wotink'e tnihnowere danank'te b́teshi, hanyakomó bín danetute, bínowere bek'rte.» ");
INSERT INTO bwo_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip'oswere «Doonzono! niho noosh nkitsitka wotiyal noosh bodfe» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iyesuswere hank'o et bísh bíaaniy, «Filip'osoo! hank'o dúro itnton tbeyiru jamanitsneya taan itdari? taan bek'tsoniye nihono bek're, eshe, nee ‹niho noosh kitsuwe› nietir awuk'neya? ");
INSERT INTO bwo_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Taa nihots t beyirwok'o, nihonwere tiyits b́bewok'o amaneratsiya? itsh tkeewiru keewo ttookonaliye, ernmó fin jamo finirwo tgiyitse fa'o nihoniye, ");
INSERT INTO bwo_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Taa nihotse t beyirwok'o, nihonwere tiyitse b́fa'ok'owo amanore, mank'o woto b́ k'azalor tfinatse tuutson taan amanore. ");
INSERT INTO bwo_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Arikon aroniye itsh ti etiri, taan amanitwo taa tfiniru fino finitwe, dab haniyere bogo finitwe, taa nihok ametuwe. ");
INSERT INTO bwo_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Niho Nayoatse tuutson b́mangitwok'o t shútson itk'onitu jamo itsh k'alitwe. ");
INSERT INTO bwo_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Konnor wotowa t shútson it k'onit keewo taa k'alitwe. ");
INSERT INTO bwo_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Taan shunfte wotiyal t tzaziyo kotetuute, ");
INSERT INTO bwo_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Taa niho k'onitwe, bíwere dúre dúrosh itnton beetwo k'osho kup'shitwo itsh imetwe. ");
INSERT INTO bwo_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Hanwere S'ayin Shayir arikoniye, datsan bín b́dawonat b́be'awotse bín dek'o falratse, itmó bí itnton b́wottsotsnat it gitsotsnowere b́beyirwotse bín danfte. ");
INSERT INTO bwo_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«Indonat nih deshaw nana'uwotskok'o it aali k'ayk'reratse, aanar itmand weetwe. ");
INSERT INTO bwo_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Muk' gizewoniyakon datsu taan be'atsaa, itmó taan bek'etute, taa beyarr beetk twottsotse itwere beyar beetute beetute. ");
INSERT INTO bwo_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Taa nihots tbeyirwok'o itwere tiyitse it fa'ok'o, taawere ititse t fa'ok'owo manots aawots danetute. ");
INSERT INTO bwo_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«Taan shuntsoniye t tzaziyo dek'etwonat finats jitsitwoniyee, taan shuntsoneye t nihi shunfee, taawere bín shunfee, t tokonowere bísh kitsitwe.» ");
INSERT INTO bwo_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Kiriyot dats ash woterawo k'osho Yhud, «T doonzo! n tooko datsjamosh nkitsrawo noosh nkitsit aawk'oneya?» bí eti. ");
INSERT INTO bwo_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iyesuswere bísh hank'o ett bíaaniy, «Taan shuntso ti aap'tso kordek'etwee, tnihwere bín shunfee, noo bíyok wáár bínton towaar beetwone. ");
INSERT INTO bwo_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Taan shunawo t aap'o kóratse, and it k'ebiru aap'an taan woshtso nihoka bako tikaliye. ");
INSERT INTO bwo_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«And itnton befetsat keewan itsh keewre, ");
INSERT INTO bwo_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Niho t shútson b́woshitwo kup'shitwo S'ayin shayironmó jamkeewo itsh danitwe, taa itsh t keewts jamonowere t'iwints itdek'etwok'o woshitwe. ");
INSERT INTO bwo_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«Jeeno itok k'ayk'ritwe, t jeenonowere itsh imetwe, taa itsh t imet jenoniye datsan bimetwok'owiyaliye, kic' k'ayere, ando shatk'ayere. ");
INSERT INTO bwo_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‹Taa ametuwe, anarnwe itok weetwe› ti ettsok'o shishrte, t nih taayere b́bogtsotse taan it shunink'e nihok ti amor geneúwiyank'te b́teshi. ");
INSERT INTO bwo_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Han b́wotor it amanitwok'o, shino b́ woteftsere itsh keewre, ");
INSERT INTO bwo_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Datsani keewtso Shed'ano b́weyirwotse haniyere okoon itnton ay keeweratse. Bíye tiatse eegor alo deshatse, ");
INSERT INTO bwo_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ernmó taa niho t shuntsok'o datso b́danetwok'o taan bíazazts jamo s'eentsitwe, tuuwere hanoke amone. ");
INSERT INTO bwo_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Ariko weyini k'ombo taane, mitwotsi goshtso tnihiye, ");
INSERT INTO bwo_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ti atse fa'o shuu shuraw jabjamwotsi tnih k'ut'de juuk'ritwe, shuu shuwitu jaabo ayide b́shuwitwok'o k'anzde'er s'ayintsitwe. ");
INSERT INTO bwo_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Itwere itsh tiaap'ts aap'atse tuutson and s'ayinwots itne. ");
INSERT INTO bwo_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Taan beewere,, taawere itn beetwe, jaabo weyini k'ombats kup'ar beeratse wotiyal biyal shuu shuwo b́falrawok'owa itwoor taan beyo itk'azal shuu shuwo falratste. ");
INSERT INTO bwo_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Taa weyini k'ombo taane, itwere jaabwots itne, ti ats deshar beetwonat taawere bín t beetwoniye ay shuwo shuwitwee, eshe ti'aalo eegor k'alo falratste. ");
INSERT INTO bwo_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tiats deshar beerawo jaabwots uromaants juwere b́shuk'eti. Mank'o wottso jabwotsi kakude'er taawots juwere bomis'eti. ");
INSERT INTO bwo_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Taan itbeyink'e ti aap'tswotswere ititse bobeyink'ere itgeyiru jamo itk'onor daatsitute. ");
INSERT INTO bwo_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ay shuwo it shuwink'ere manatse tuutson t nih mangiyank'ee, itwere t danifwotsi it wottsok'o kitsiyank'te. ");
INSERT INTO bwo_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Niho taan b́shuntsok'o taawere itn shunre, manshe tshunon beewere,. ");
INSERT INTO bwo_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Taa t nih tzaziyo t kottsok'onat b́ shunon t beyirwok'o itwere ti tzaziyo it kotal t shunon beetute. ");
INSERT INTO bwo_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Jaman itsh tkeewiye tgeneeú'wo ititse wotar it geneúwo s'een b́wotishe. ");
INSERT INTO bwo_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","T tzaziyoniye taa iti t shuntsok'o itiwere it atsatseyo it shunetwok'owe. ");
INSERT INTO bwo_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Asho b́ kasho b́ mashots shegro beshide imoniyere bogts shuno deshatse. ");
INSERT INTO bwo_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Itwere ti imts tzaziyo it s'eentsiyal t mashots itne. ");
INSERT INTO bwo_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Guutso doonzo b́finirwo b́danawotse, haniyere hakon guutswotso eraatse, s'uznmó tnihoke tshishts jamo itsh tkitstsotse t mashotsi etreitsha, ");
INSERT INTO bwo_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Taana iti marat'dek'i bako it taan marat'de'atste, amr ay shuwo itshuwitwok'o, itshuwonwere beetk b́wotitwok'o itn tnaashiy. Manshe niho t shútson it k'onts jamo itsh imetwe. ");
INSERT INTO bwo_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Eshe taa itin tiazazir it atsatsewo it shunetwok'owe. ");
INSERT INTO bwo_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Datsan itn b́ shit'al itiyere shino taan b́shit'tsok'o dande'ere. ");
INSERT INTO bwo_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Datsank it wotink'ere datsan b́tokk wottswotsi shunak'e b́teshi. Ernmó datsank woto it k'aztsotsnat taa datsanatse iti marat' t dek'tsosh datsan itn shit'etwee. ");
INSERT INTO bwo_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Guutso doonzoniyre bowatse etaat itsh t keewtso gawwre, taan bogiishitka wotiyal itnowere gishitune, ti aap'o bokotink'e it aap'ono kotetune. ");
INSERT INTO bwo_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Taan woshtso bodanawotse t jangosh jaman itats k'alitunee. ");
INSERT INTO bwo_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Taa waat boosh keewratse wotink'e morro boats woteratse b́teshi, ernmó and bo morrosh weebo deshatsne. ");
INSERT INTO bwo_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Taan shit'irwo t nihnowere b́ shit'iri, ");
INSERT INTO bwo_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","K'osh ash fineraw fino bo dagotse fino tk'azink'ere morro boosh woteratse b́ teshi, andmó jaman bobek'iyakon taano t nihno shit'rne. ");
INSERT INTO bwo_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Hanwere b́ wottso ‹Ik jagalo taan shit'rne› ett nemotse guut'etso b́ s'eenetwok'owe. ");
INSERT INTO bwo_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Ernmó nihoke keshetwonat taawere nihoke itsh twoshitwo itn kup'itwo ari S'ayn shayiro b́ woor bí t jango gawitwe. ");
INSERT INTO bwo_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Itwere baltson tuwat taanton it teshtsotse gawitute. ");
INSERT INTO bwo_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Hambe, jaman itsh t keew it imnetiyatse it giwawok'owa etaatniye. ");
INSERT INTO bwo_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ayhudiyots Ik' k'oni mootse kishder iti gishitno, mank'o itn ud'itu jamwots dab́ Ik'osh bofinirwok'o boosh bí arit aawo weetwe. ");
INSERT INTO bwo_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Hanowere bok'alir nihono taano bodanawotsene. ");
INSERT INTO bwo_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Han itsh tkeewiriye bíaawo b́bodor itsh eeg tkeewtsok'o gaw itdekishe.» Jaman haniyere shin itsh keewo tk'aziye itnton t teshtsotsne. ");
INSERT INTO bwo_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«Andmó taan woshtsok amishee, b́wotiyalor ititse ‹Eewke niameti› err taan aatitwo aaliye. ");
INSERT INTO bwo_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Jaman itsh t keewtsotse it nibo shiyanon s'eenwtsere. ");
INSERT INTO bwo_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Taamó arikon aroniye itsh tietiriye, ti amo itsh k'anefe, taa amo t k'azal kup'shitwo itook waratse, taa tiamalmó bín itsh deyitwe. ");
INSERT INTO bwo_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Bí b́woor morri jangosh, kááw woti jango, angshi jangosho datsatsi ashuwotsi wok'asitwe. ");
INSERT INTO bwo_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Morri jango b́ kitsitiye taan amano bok'azirwoshe. ");
INSERT INTO bwo_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kááw woti jango kish b́ kitsitiye niho maants tiametwonat haniye haniyak taan bek'o it k'azetwoshe, ");
INSERT INTO bwo_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Angshi jango kish b́kitsit datsan keewtsoats angshetsoshe. ");
INSERT INTO bwo_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Itsh t keewitwo andoor ay keewo detsfe, ernmó and itatse b́mangiti, ");
INSERT INTO bwo_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Arik wotts Shayiro b́ woor ar jamo maants itn jishitwe. Bí b́ keewitwo b́ shishtsoni bako b́tokk woto b́ k'aztsotse bí shinomaants wotit keewo itsh keewitwe. ");
INSERT INTO bwo_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tik wottsotse de'er itsh b́keitwotse taan mangitwe. ");
INSERT INTO bwo_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nihok wotts jamo tikee, ‹Tik wottso de'er itsh keewitwe› ti et manshe. ");
INSERT INTO bwo_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Muk'i it teshiyakon taan be'atste, ando muk'i it teshiyakon taan bek'etute.» ");
INSERT INTO bwo_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","B́ danifwotsitse ik ikwots, «Han, ‹Muk'i b́ teshihakon taan be'atste, ando muk'i it teshihakon taan bek'etute, ando aani nihomaants ametuwe› b́ etiru keewo eebi?» ett boatsatseyo bo aateyi. ");
INSERT INTO bwo_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","«Eshe han ‹Muk'i b́teshihakon› bí etiru keewo eebi? B́ keewiru keewo danatsone» ett anansh dek't́ boaateyi. ");
INSERT INTO bwo_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iyesuswere bín aatosh bogeyirwok'o dank'rat hank'o boosh bíet, «It atsatseyo it aateyirwo, ‹Muk'i b́ teshiyakon taan be'atste, ando aani múk'ibteshiyakon taan bek'etute,› ti ettsosheya? ");
INSERT INTO bwo_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ariko aron itsh etirwe, it eepetutee, kuhitutee, datsanmó genee'uwitwee, it shiyanitute, ernmó it shiyano gene'o maants woneetwe. ");
INSERT INTO bwo_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Máátsu bshuwor b shambi aawo b́bodtsotse shiyanitwaniye, bshuwihakonmó datsats na'i marmat'o bshuwetsotse bgene'utsatse tuutson bali b kic'o gawratsaniye. ");
INSERT INTO bwo_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mank'o and it shiyanitute, ernmó taa aani iti bek'etwe, it mac'onwere gene'uitwe, it gene'uwere itatse dek'etwo aaliye. ");
INSERT INTO bwo_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«Manots aawots tiyoke eegor k'onratste, ariko arikon itsh etirwe niho tshútson it k'oniyal jam keewo itsh ímetwe. ");
INSERT INTO bwo_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Han b́ borfetsosh t shútson eegor ik keewo k'onrafa'atee, it k'oniyal itsh imetwe, mannowere it gene'uo s'een wotitwe. ");
INSERT INTO bwo_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Andish b́borfetso jewron itsh keewre, haniyako jewron itsh t keeweraw aawo weetwe, ernmó niho jangosh jam keewo kishde itsh keewitwe. ");
INSERT INTO bwo_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Manots aawots tshútson k'onitute, taawere ‹Niho it jangosh k'onitwe› eraatse. ");
INSERT INTO bwo_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Man eegoshe niho b́tookon iti b́shuntsoshe, nihonwere iti b́shunir taan it shuntsonat Ik'oke twatsok'o it amantsotsne. ");
INSERT INTO bwo_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nihoke keshat datsats waare, ando aaniy datsani k'ayr nihok ametuwe.» ");
INSERT INTO bwo_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","B́danifwotswere hank'owa boet, «Hamb! andee jewron b́woterawon shanone n keewi, ");
INSERT INTO bwo_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nee jamo n dantsok'onat nee konnwor neesh aato t'intso b́geyirawok'o and t'iwintsdek'roone, mansh Ik'oke keshat n waatsok'o amanirwone.» ");
INSERT INTO bwo_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iyesuswere boosh hank'o ett bíaaniy, «Andmó amanertya? ");
INSERT INTO bwo_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","It ik ikets it kaat kaaton bad'arr tiyali k'ayitk'rit sa'ato weetwe, b́ sa'atonwere andbodre, ernomó niho taanton b́wottsotse tiyaltanaliye. ");
INSERT INTO bwo_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Han itsh tkeewir tiats deshar jeeno it datsitwok'owa etaatniye, datsanatse it befetsosh gondbek'o itaatse'faee, ernmó shatk'ayere, taa datsani da'adek're.» ");
INSERT INTO bwo_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iyesus han b́ keewiyakon daromaants b́ tooko tuzdek't s'iilfetst hank'owa bíet, «Nihono! hamb, sa'ato bodre, n naay neen b́ mangiytwok'o n na'o mangiwe, ");
INSERT INTO bwo_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ni imts jamwotssh dúre dúri kasho b́ imetwok'o ash jamwotsatse alo n imtsoshe. ");
INSERT INTO bwo_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Dúre dúri kashonwere n s'uzi ari Ik'o Izar Izewernat n woshtso Iyesus Krstosi danoniye. ");
INSERT INTO bwo_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Taa taash n'imts fino s'eentsat datsanatse neen mangire. ");
INSERT INTO bwo_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nihono! datsan bíazeftsere niyoke t detsts mangon taan andoor niyoke mangiwe. ");
INSERT INTO bwo_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Datsanatse gaaldek'at taash n imts ashuwotssh koni nwotok'o kitsre, booye niknee boteshi, neehe boon taash imrne, boowere ni aap'o kotdek'rne, ");
INSERT INTO bwo_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Taash nímts jamo niyokik b́ wottsok'o bo and danrnee. ");
INSERT INTO bwo_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Taash nimts aap'wotsi boosh imre, boowere t keewre k'ebdek'rne, niyoke keshat twaatsok'onowere arikon danrnee, nee taan n woshtsok'onowere amanernee. ");
INSERT INTO bwo_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Taa tk'onir bo jangoshe, taash nimtsanots nik bowottsotse bo jangosh k'onirwe, datsush k'onratse. ");
INSERT INTO bwo_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tik wotts jamo nike, nik wottsonwere tikee, taawere boatse tuutson mangree. ");
INSERT INTO bwo_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Taa haniyakon datsanatse beeratse, bomó datsanatsikne. Taaye nmaants twooniyee, S'ayin nihono taash n'imtsanots nokok'o ik bowotishe taash n'imts nshúútson boon kore. ");
INSERT INTO bwo_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Taa bonton t teshor taash nimts n shúútson boon kotre, taahe boon kotre, mansh mas'aaf S'aynotsitsi aap'etso b́ s'eenetwok'o t'afi na'oniye oko konwor boyitse t'aftso aaliye. ");
INSERT INTO bwo_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","And taa n maants t wooniye, datsatse befetsat han boosh t keewir t gene'o boon s'een b́wotitwok'owe. ");
INSERT INTO bwo_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Taa ni aap'o boosh imre, taa datsanatsik wottk'ztsok'o boworu datsatsiknaliye, manshe datsan boon b́ shit'i. ");
INSERT INTO bwo_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Gondatse boon n k'otetwok'owa bako datsatse boon n dek'etwok'o neen k'onratse. ");
INSERT INTO bwo_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Taa datsatsik t woterawok'o boowere datsatsiknaliy. ");
INSERT INTO bwo_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Aron boon S'ayntswe, ni aap'onu aree. ");
INSERT INTO bwo_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nee taan datsan maants n woshtsok'o taa boon datsan maants woshere. ");
INSERT INTO bwo_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Bo arikon S'ayn bowotitwok'o taa bo jangosh t tooko S'ayin woshitwe. ");
INSERT INTO bwo_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Bo aap'o k'ebdek't taan amaniru jamwotssha tk'oniri bako, bos'uzsh k'onratse. ");
INSERT INTO bwo_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Taawere t k'onir jametswots ik bowotitwok'we, andoor nihono! nee tiitse nbeyok'o taawere niatse t fa'ok'o, boowere noon bobetwok'o, nee taan nwoshtsok'o datsan b́ amanitwok'owe. ");
INSERT INTO bwo_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Noo ik nowottsok'o boowere ik bowotitwok'o, taash n imts mango boosh imre. ");
INSERT INTO bwo_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Taa t k'onirwo taa boon neewere taan n wottsok'o boowere b́ jamon ik bowotitwok'owe. Mank'owere taan nwoshtsok'onat taan nshuntsok'on bonowere nshuntsok'o datso b́danishe. ");
INSERT INTO bwo_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Nihono! Datsan bíazeftsere taan nshuntsotse taash n'imts mango bobek'etwok'o taash n ímtsanotswere taa t beyoke taanton bo beyo shunfee. ");
INSERT INTO bwo_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","S'ayin nihono! datso neen danatse, taamó neen danfee, hanotswere taan nee n woshtsok'o danrnee. ");
INSERT INTO bwo_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Taan nshunts shuno booke b́betwok'o taawere boats twotitwok'o, boowere neen bodanetwok'o woshre, ando aani bodanetwok'o woshitwe.» ");
INSERT INTO bwo_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iyesus hank'o b́ etiyakon b́ danifwotsnton K'edron foki túroniye bak'ets bíami, manoke teshts miti bos'wots beyok b́ danifwotsnton bokind. ");
INSERT INTO bwo_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Iyesusnat b́ danifwotsn jam aawo manoke boko'efotse bín beshide imetwo Yhud manokman danfee b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Mansh Yihud, wotadrwotsitsi ik kaywotsi, mank'owere kahni naashwotsitsnat ferisawino eteefwotsitse wosheets kot kotfwotsitse k'atswotsi jishdek't manok b́weyi, boowere fanosiyonat c'eshon, gini k'ac'uwotsi detsdek'tni botesh. ");
INSERT INTO bwo_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iyesuswere bíats bodetu jamo dank'rat bomaand kesh waat, «Kone it geyirwoni?» bí eti. ");
INSERT INTO bwo_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bowere «Nazrettso Iyesusiye nogeyiri» boet. Bíwere «Bíye Taane» bí eti. Bín beshide imetwo Yhudwere bonton need'dek'tni b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Iyesuswere «Bíye taane» bí eree shuutso madand ginaat datsats dih bowts. ");
INSERT INTO bwo_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Iyesuswere, «Kone it geyiri» ett aani boon bíaati. Bowere «Nazrettso Iyesusiye nogeyiri» boet. ");
INSERT INTO bwo_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Bíwere «Taane itsh etre, eshe it geyrwo taana wotiyal hanotsi k'ayk'rowere, amnee» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Hanwere b́wot, «Nihono, taash ni'imts ashuwotsitse ikonor dab t'afiratsee» bí eteets aap'o b́ s'eenisha. ");
INSERT INTO bwo_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Smon P'et'rosu shiki gorado b́ detstsotse b́ shiko kaas' dekt kahanai naashwots guutso k'ani wazo k'ut'b́k'ri, guuts man shúútsonwere «Malkosi» b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Iyesusmó P'et'rossh, «N shiki gorado b́ batots anik'rowe, Niho taash bímts gondbek'i wanc'o úshalktaaneya?» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Maniyere il wotaderwotsnat boon alefon, Ayhdiwots koti kotfwots Iyesusi detsdek't tip bok'r. ");
INSERT INTO bwo_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Shinnwere Hana maants dek't bo am, Hanwere mandúri kahaniwots abaatsi naasho teshtso K'eyafsh bí abi b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","K'eyafwere «Ik asho ash jamwots jangosh b́ k'iro k'anef» ett Ayhudi naashwotssh iztsoni b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Smon P'et'rosnat b́ daniru k'oshnton Iyesus shuutso botuu, k'osh b́ daniru man kahniwotsatsi naashoke daneeka b́ tesh, b́ danif manwere Iyesusnton kahaniwots naasho múúlots b́ kindi, ");
INSERT INTO bwo_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","P'et'rosmó uratsere fengesh ganok need'dek'tni b́ tesh, kahaniwots naashoke daneets b́ danfman úromaants kesh waat fengesh kotiru baar na'ush keewt P'et'rosn kindsh b́k'r, ");
INSERT INTO bwo_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Fengsh kotiru baar naunu P'et'rossh, «Neewere ashaan danirwotsitsi iko neenosha?» biet. Bíwere taanaliye b́ eti. ");
INSERT INTO bwo_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Manoor datso ak' b́ wottsotse guutswotsnat zebi kotirwotsn itsintsiron tawo aat'idek't bokashiri. P'et'roswere bonton need'dek'tni tawa b́kashiri. ");
INSERT INTO bwo_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kahni naashi naasho Iyesusi b́ danifwotsnat b́daniyiru daniy jango bíaati. ");
INSERT INTO bwo_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Iyesuswere hank'o ett bísh bíaaniy, «Taaye ash jamosh sháánone t keewi, ayhudi jamwots Ik' k'onosh bokakwets mootse wotowa Ik' mootse aaw aawone tdaniyi, ááshon t keewtso ik keewo aaliye, ");
INSERT INTO bwo_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Eshe, eegoshe taan ni aatiri? Bosh t keewor shishtswotsi aatwe, taa t keewtso bo danfnee.» ");
INSERT INTO bwo_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Iyesus han b́ keewor manoke need'dek't teshtswotsitsi kotirwotsatse iko, «Kahniwots naashosh hank'oweya ni'aaniti?» ett bín b́ jabi. ");
INSERT INTO bwo_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Iyesuswere «Gondo aap're wotiyal gond keewo t keewtsk'o gawowe, t keewtso arika wotiyalmó taan eegoshe ntogiri?» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Maniyere il Hana, Iyesusi b́ tipetsok'on kahniwots naasho K'eyaf maants damib́k'r. ");
INSERT INTO bwo_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Manoor Simon P'et'ros need'dek't tawo b́kashfere b́ tesh, k'osh ashuwotswere «Nee ashman danifwotsitsi iko neenosha?» bo eti. Bíwere, «Taanaliye» jamere bíet. ");
INSERT INTO bwo_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","P'et'ros b́ waaz b́k'ut'ts ashosh jag wottso kahni naasho guutsuwotsitse iko, «Mit bos'wots beyoke bínton neen be'atsta?» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","P'et'rosu dab́t jamere bí eti, manoor baako b́k'adi. ");
INSERT INTO bwo_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Maniyere il Iyesusi K'eyaf mookere Romn waats dats k'eezirwo múúlok dek't boami, manoronu guura b́ tesh. ayhudiwots fazigi baaliwosh shukeet mereero bometwotse bo kimawok'o ett datsu k'eeziru múúlots kindatsno. ");
INSERT INTO bwo_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mansh P'ilat'os bo maantsan kesh waat, «Ashaanats it t'intsiru s'aamiyo eebi?» ett bíaati. ");
INSERT INTO bwo_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bowere «Ashaan gondo fineraka wotink'e neesh beshide imawk'one b́ teshi» ett bo aani. ");
INSERT INTO bwo_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","P'ilat'oswere «It it tookon de'amr it nemok'on angshwere» bíet. Ayhudiwotswere «No nemotse ash úd'o noosh baziyeke» boet ");
INSERT INTO bwo_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Manwere b́ wot Iyesus aawk'on b́ k'iritwok'o aap'ets aap'o b́ s'eenetwok'owe. ");
INSERT INTO bwo_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","P'ilat'oswere aanat b́ múúlots b́ kindi Iyesusno s'eegt «Nee Ayhudi naasho neeneya?» ett bí aati. ");
INSERT INTO bwo_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iyesus «Nee hań nietiŕ n tokoneyamó? t jango k'osh ashuwots neesh bokeewrneya?» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","P'ilat'oswere, «Taa ayhudi taaneya? Neen taash beshidek't imtswots n jirwotsnat kahni naashwotsnee, nee eebi nk'altsoni?» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iyesus «T mengstu datsanatskiyaliye, t mengstu datsanatsiki wotink'ere Ayhudi naashwots kishots t kindrawok'o ti ashuwots taash kes'ank'ne b́ teshi, t mengstunmó datsanatsikiyaliye» ett bíaaniy. ");
INSERT INTO bwo_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","P'ilat'oswere «Beree nee nugús neenere?» bí eti. Iyesuswere «Taa nugus t wottsok'o neenere etiri, taa t shuwewokonat datsanats twaa ari jango gawoshee, arik wotts jamo ti aap'o k'ebetwe» ett bíaaniy. ");
INSERT INTO bwo_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","P'ilat'oswere «Aro eebi?» ett bíaati. Maniyere il P'ilat'os ayhudiwots maants kesh waat hank'o bíet, «Taa bíatse ik naandunor daatsratse, ");
INSERT INTO bwo_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ernmó it doyok'on fazigi bali aawor tipetswotsitse iko worwot worwoton itsh biitsfe, mansh Ayhudi nugúso itsh t bitsish geefteya?» bí eti. ");
INSERT INTO bwo_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Boomó «Berebani noosh biishe bako haniyali!» ett bokúhi. Berbanmó wombedeya b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Maniyere il P'ilat'os Iyesusi dek'amt b́garfii. ");
INSERT INTO bwo_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kes'kes'fwotswere angitson k'odets akliliyo doozdek't Iyesus tookats gedbok'r, tahi bironowere takbokr. ");
INSERT INTO bwo_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","B́iyo waat bíats kashon, «Ayhudi nugusono! jeeno neesh wotowe!» bo etferab botesh, etonwere bín bojabi. ");
INSERT INTO bwo_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","P'ilat'os aaniy uromaants kishdek't, «Hamb bíatse eegor t'afiyo t daatsrawok'o it danetwok'owa, bíne ur itsh kish k'rona» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Mann Iyesusi angitsi akliliyo b́ tookats gúúpdek't tahi bironowere b́ tahtsok'on ur kesht b́waa, P'ilat'oswere «Hambe ashoni!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kahniy naashwotsnat kot kotfwotsn Iyesusi bobek'tsok'on, «Bín jirk'rowe! bín jirk'rowe!» ett bokuhi. P'ilat'osmó «T weron eegoru naando bíyatse daatsratse, it geyiyal it de'amr jirde'ere» bí eti. ");
INSERT INTO bwo_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ayhudiwotswere «Noo nemo detsfone, ashaan b́ tooko Ik'o naayi b́ woshtsotse no nemok'on k'ira b́k'iritiye» bo et. ");
INSERT INTO bwo_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Jam keewan b́ shishtsok'on P'ilat'os iki shat b́gutsi, ");
INSERT INTO bwo_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Múúlots kindt Iyesussh «Nee eewkneya nweyi?» ett bíaati. Iyesusmó eegor bísh aaniratse. ");
INSERT INTO bwo_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Manatse tuutson P'ilat'os «Taash keewratsneya? taa neen bitsosho wee jitosho alo t detstsok'o danatsiya?» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iyesuswere «Ik'oke alo neesh imeraratse wotink'e tiatse eegor alo deshatsne b́tesh, mansh eshe taan neesh beshidek' imtso iki bog morro bíats wotitwe» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","P'ilat's Iyesus keew keewan b́ shishtsok'on biishde fakshk'ro geyatni b́teshi, ayhudiwotsmó «Nee ashaan nfakshitka wotiyal Rom nugús jir neenaliye, b́ tookon nugús woshitu jamo nugúsosh b́ balangare!» etfets bokuhi. ");
INSERT INTO bwo_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","P'ilat'os man b́ shishtsok'on Iyesusi uromaants kishdek't «Shúts sháána» eteets beyoke angshi jorats be b́dek'i, beyokan Ibrayist'i noon keew keewon, «Gabata» eta eteefo. ");
INSERT INTO bwo_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Fazigi baaliyosh k'an dek'i aawa b́tesh, manoronwere shirt sa'atok'oyi, manoor P'ilat'os ayhudiwotssh «Hambe it nugúsoni!» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Boomó, «Bín t'afiwe! Bín t'afiwe! jirk'rowe!» ett bokuhi. P'ilat'oswere, «It nugúso jiirk'rotaa?» bíet. Kahni naashwotswere, «Rom dats nugúsoniyere okoon k'osh nugúso deshatsone!» ett bísh boaaniyi. ");
INSERT INTO bwo_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Manoor Iyesus b́ jitetwok'o P'ilat'os beshidek't b́ ími, boowere detsdek't boami. ");
INSERT INTO bwo_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Maniyere okoon Iyesus b́ mask'aliyo kurdek't «Took k'ola» eteef beyok kesht bíami, beyokan Ibrayist'i nonkeew keewon, «Golgota» eteefo, ");
INSERT INTO bwo_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Manoknowere bín jitbok'ri, Iyesusi dagots geddek't bínton k'osh git ashuwotsi gironat k'anomaants jitbok'ri. ");
INSERT INTO bwo_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","P'ilat'os, «Nazrettso Iyesus, Ayhudi nugúsa» etirwo guut'etso guut'dek't bí mask'aliy k'oyomand gedb́k'ri. ");
INSERT INTO bwo_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Iyesus b́ jitewoko kitok karn b́ teshtsotse, ayhudiwotsitse ayuwots guut'etsman bo nabab, guut'etsonwere b́ guut'e Ibrayist'iyon, Latiniyonat Grikiy noon keew keewok'ona b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ayhudi kahni naashwots p'ilat'ossh, «Nee ‹Ayhudi nugúsa› err guut'k'aye, ernmó, ‹Ashaan taaye ayhudiwots nugúso taane› etfe err guud'e» boeti. ");
INSERT INTO bwo_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","P'ilat'osmó, «T guut'tso guut're» ett bíaani. ");
INSERT INTO bwo_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kes'kes'fwots Iyesusi bojiti hakon b́ taho dek't, kes'f ikosh ik ik kayo b́ bodetwok'o awdoko kayibok'r. Ernmó b́ kito hank'owa bok'al, b́ kito shiperawo dambe dek't dash b́borfetso ikon wozeka b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Mansh kes'fwots, «It'o no sha'e bísh b́bodtso noyitse b́dek'o k'anefe bako gaat'k'ayone» bo eti. Man b́ wotwere, «T tahonee kaybodek'i, T kitatsowere it'o boshp'i» Etirwo S'ayin mas'afitstso b́ s'eenetwok'owa, kes' kes'fwotswere mank'o bok'al. ");
INSERT INTO bwo_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Iyesus mask'aliy ganoke b́ índnat b́ índmishn, K'elyop' máátsu Mariyamnat Megdelitsu mariyamwere need'dek'tni botesh, ");
INSERT INTO bwo_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Iyesus bí indnat b́ shunf b́danifo ikoke boned'efere b́ bek'tsok'on bí índsh, «Máátsune! mambe nnaayi!» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Maniyere il b́ danifmansh, «Mambiye ni indi» bí et. manoori sa'aton tuzt b́ danifman b́ galomand bin dek't bíami. ");
INSERT INTO bwo_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Maniyere il Iyesus and jam keewo s'een b́s'uutsok'owo dandek't S'ayn mas'fotse guut'ets Ik'i aap'o b́ s'eenetwok'o, «Shashuwere!» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Manoke biri k'ac'otse s'eent beyiru weyini shasho fa'ebtesh, mansh manoke fa'a ashuwots weyini bir shashman sponjiwok'ots gupt s'eentsdek't hisop'i mitats joddk't b́ nonats bot'intsi, ");
INSERT INTO bwo_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Iyesuswere biri shashman b́ nonots b́gedihakon «S'uuwtsere!» bí eti. B́tookonowere jilk' aydek't k'iri b́wtsi. ");
INSERT INTO bwo_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Maniyere il Ayhudi naashwots, jitets ashuwots shókó tishde'er, boduuno maskaliyatse bo orshitwok'o P'ilat'osi bok'oni, man bok'aluere eegoshe sanbati aawosh k'andek'o boosh b́geyitsotse, sanbatmanwere baaliyi een b́wottsosh, sanbati aawon boduuno mask'aliyats b́ beerawok'owa ettni. ");
INSERT INTO bwo_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Mansh kes'kes'fwots amt, Iyesusnton jiitsets ashuwotsi, shin iko shóko tiitst ando aani gitlo shóko botiitsi, ");
INSERT INTO bwo_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Iyesusok boamtsok'onmó, bí shino k'irt b́teshtsok'o bek't b́shóko tishatsno. ");
INSERT INTO bwo_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ernmó kes'kes'fwotsitse iko, b́ lalk'ats ginon kosh b́k'ri, manoor b́ lalk'otse s'atsonat aatson b́kesh. ");
INSERT INTO bwo_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Man bek'tso it it amanituk'owo b́ gawi, b́ gawonwere arika, b́ keewirwonwere arik b́wottsok'o bí danfee. ");
INSERT INTO bwo_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Han b́wotwere, «B́ mak'tsotse dab ikonwor tisheratsee» etiru S'ayin mas'afitsi aap'o b́s'eenetwok'owe. ");
INSERT INTO bwo_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ando k'osh S'ayin mas'aafi kayotse, «Bo koshtsmanee bek'etúnee» etfe. ");
INSERT INTO bwo_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ayhudi naashwotsi shatt ááshon Iyesus danifwotsitse teshtso Armatiyas datstso Yosef Iyesus duuno dek'osh P'ilat'osi b́k'on. P'ilat'oswere de'e bíet. Mansh Yosef amt duuno k'aa'úb́dek'. ");
INSERT INTO bwo_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Maniyere shin t'úwon Iyesusok waat teshtso Nik'odimoswere kerbewonat ekoos'on eekdek't s'aletso shaash kilok'o wotitwo dek't b́wyi. ");
INSERT INTO bwo_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ash gitetsmanots Iyesus duuno k'aaúdek't ayhudiwots duun naap'efok'on naap't shituwonton shemi shishon t'at'bok'ri. ");
INSERT INTO bwo_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Iyesus jiteyat b́ teshtsoke mit bos'wots bobeyoko fa'e b́tesh, miti beyiru manitse konnor bits duk danawu doowi handro fa'e b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Sanbati jangosh k'andek'osh ett ando dowonuwere karn b́teshtsotse Iyesus duuno manok gedbok'ri. ");
INSERT INTO bwo_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Torbanitsi shintso aawots, sanbata gudots, maar goyo b́ maat'fetse, Megdeli datstsu Mariyam Iyesus doowomants biami, manok b bodtsok'on doowo bin ipets shútso doowman fengeshatse k'aztuut b́ befere bek'b́k'ri. ");
INSERT INTO bwo_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mansh bi Simon P'et'rosnat Iyesus b́ shunf b́ danifok wos'fere amaat, «Doonzo dowootse kishdek'wutsernee, aawok bogedtsok'o danatsone» bieti. ");
INSERT INTO bwo_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Manorowere P'et'rosnat b́ danif ikmann kesht dowomand boami. ");
INSERT INTO bwo_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Gitetswotswere towatni bowos'iri, ernmó b́ danif k'oshman P'et'rosiyere bogo káárt wos'fere amt shino dowok b́bodi. ");
INSERT INTO bwo_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Dashan tuumt doowots b́s'iltsok'on duuni taho manoke b́befere b́bek'i, ernmó gitsomaand kindratse. ");
INSERT INTO bwo_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon P'et'roswere b́shuutso waat́ doowots b́ kindi, bíwere duuno bín t'at'ets taho manoke b́ befere b́ bek'i. ");
INSERT INTO bwo_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Iyesus tooko bín s'as'ets taho b́ duuni tahonton b́ woterawo bíaali k'oshoke k'odeyat b́ beyirwok'o bek'b́k'ri. ");
INSERT INTO bwo_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Maniyere il, shin shino waabodts b́ danifman doowi gitsots kindt bek't bíamani. ");
INSERT INTO bwo_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","«K'irtswotsitse tuwo geyife bísha» etts aap'o S'ayin mas'afotstso t'iwintsde'afa'no botesh. ");
INSERT INTO bwo_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Maniyere il b́ danif gitetsmanots aanat bogalomand boami. ");
INSERT INTO bwo_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Megdel dats ashu Mariyam eepfetsat, dowoniyere úratse ned'dek'atni b́tesh, eepfetsatnwere tuumdek'at doowots b́ s'iili. ");
INSERT INTO bwo_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Iyesus duuno b́ teshts beyoke nas' tah tahtdek'ts melaki gitetsuwotsi iko s'olotse iko k'oyoke bobefere bbek'i. ");
INSERT INTO bwo_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bowere Mariyamsh, «Nee máátsune! eegishe niepiri?» boeti. Biwere, «T doonzi dek'wutserne, eewk bogedtsok'onowere danatse» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Manowere etaat b shutsomand wongr biettsok'on Iyesus b́ need'efere bek'bk'ri, Iyesusi b́wottsok'onowere danatsane. ");
INSERT INTO bwo_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iyesus, «Máátsune neena eegoshe niepiri, kone ngeyirwoni?» bí eti. Bíwere manoki mitwotsitse finirwo bish bíartsotse, «Doonzono! nee bín dek'ri wotiyal, eewk ngedtsok'owo oona neesha taash keewwe, taa were k'aaúdek'etuwe» bieti. ");
INSERT INTO bwo_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iyesuswere, «Mariyame!» bí eti. Biwere b́maants wongr etaat Ibrayist'i noon keewu keewon, «Rebuni!» bí eti. Man etonwere, «Danifono!» etee. ");
INSERT INTO bwo_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iyesus, «Tiyats borr taan detsk'aye taahe andoor tnihok damb keyafa'e, ernmó tieshwotsok amr ‹Taahe ti nihnat it nihok, ti Ik'onat it Ik'ok damb bíyok keshetwe etfe› err boosh keewwe» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mann Megdel datstsu Mariyam b́ danifwotsok amaat «Doonzo bek're!» etaat bish eeg bíettsok'onowere boosh b keewi. ");
INSERT INTO bwo_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Manoori ik gawiymanitsi shints aaw sanbata gudots kooc' b́ danifwots ayhudi naashwotsi bo shattsotse, bo maa fengesho is'dek't́ moots kakwedek'tni botesh, maa fengesho is'etsok'on b́ befere Iyesus b́ danifwots kakwed'ek't bobeyiru moots b́ kindi, bo dagots need'dek't, «Jeeno itsh wotowe!» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Man ett b́ kishonat b́ lalk'on boosh b́ kits, b́ danifuwotswere doonzo bobek'tsok'on geneúbowutsi. ");
INSERT INTO bwo_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Maniyere il Iyesus aaniy, «Jeeno itsh wotowe! taan niho b́ woshtsok'o taawere iti woshitwe» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Man eton bo aats úff ett, «S'ayin shayiro de'ere, ");
INSERT INTO bwo_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ashuwots morrosh orowe it etal boosh bo morro orowa etetuwe, it ashuwots morro orowa eto it k'azal boosh orowa eteeratse» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Iyesus b́ danifwotsok b́ woor tatse gitetsuwotsitse iko, Didimosi eteefo Tomas bowoke aali b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Mansh b́ danif k'oshuwots Tomassh «Doonzone bek'rone» boet. Bímó «Mismaron koshets b́ kishuwotsi be'er tjabuwotsi msmaron koshets manotsits tgerawo, t kishonowere b́ lalk'i gaawots t gedala bako b́jamon amaneratse» bí eti. ");
INSERT INTO bwo_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Shimt aawoniyere hakon b́danfuwots aaniy mootsna botesh, Tomasuwere bontini b́tesh, maa fengesho is'etsok'on b́befere Iyesus waa bo dagotse need'dek't́, «Jeeno itsh wotowe!» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Maniyere il Tomassh, «N jaabo hakan doyir tkishwotsi s'iile, nkishonowere dewar t lalk'ots geere, amantso wotowe bako, amanerawo wotk'aye» bí et. ");
INSERT INTO bwo_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomaswere, «T doonzo! tiko Izar Izewero!» ett bísh bíaani. ");
INSERT INTO bwo_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Iyesuswere Tomassh, «Neyere taan nbek'tsosha taan niamaniye, taan bo be aawon taan amanituwots údeknee» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iyesus mas'afanitse guut't gederawo k'osh ay aditso b́ danifúwots shinatse finere, ");
INSERT INTO bwo_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ernmó Iyesus Krstos Ik'o naayi b́wottsok'owo it amanituwok'o, amanar b́shutson dúre dúri kasho it datsitwok'owa han b́ guut'iyi. ");
INSERT INTO bwo_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Haniyere okoon Iyesus T'bryados aats k'ari ganoke, b́ danifwotssh aaniy b́be'eyi, b́ be'ewwere hank'owa, ");
INSERT INTO bwo_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Sim'on P'et'rosi, Didimosi eteefo Tomasi, K'aan Galil datstso Natnaeli, Zebdiwos nana'wotsnat b́ danif gitetswots towatni botesh. ");
INSERT INTO bwo_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Sim'on P'et'ros, «Mus' detso amna» bíet. Bowere, «Nentoniye no ameti» boet. Kesh amt jelbots bokind, ernmó manots t'ú mus' iku dab deshatsno. ");
INSERT INTO bwo_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","B́gatstsok'on Iyesus aats k'ari gúúrats ned'b́wts, b́ danifwotsimó Iyesusi b́wottsok'o danatsno. ");
INSERT INTO bwo_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Iyesuswere, «Nana'otso! mus' iku detsfte?» bí eti. Bowere, «Ik biidu dab deshatsone» boeti. ");
INSERT INTO bwo_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Bíwere, «Mus'i kambo jelbu k'anomaants shau'ere daatsitute» bíet. Mansh kambo aats k'arots shap' bok'ri, mus'o ayo bodetstsatse tuutson kambo geetso maawbowtsi. ");
INSERT INTO bwo_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Manoor Iyesus b́shunf b́danfo P'et'rossh, «Bíye doonzoniye!» bíet. Sim'on P'et'ros, «Doonzoniyosha» eto b́shishtsok'on finosha ett b́ kito kisht b́teshtsotse manoor tahdek't aats k'arots t'oolat b́kindi. ");
INSERT INTO bwo_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","B́ danifwotsmó datsatse git bal indoniyere bowokerawotse mus'o bíns'ents mus'i kambo geetsfere jelbon boweyi. ");
INSERT INTO bwo_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Jelbotse bo oot'tsok'on bí abaatse mus'o detstso itsintsiri tawik'ak'onat misho bek'bok'ri. ");
INSERT INTO bwo_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Iyesuswere, «And it detsts mus'otse dewere» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Mansh Simon P'et'ros jelbots t'oolat kindon balebalk'atse keez mus'i een eenwots bítse bos'eents mus'i kambo datsomand b́getsi, mank'o mus'i ay b́ detsalor mus'i kambman gaad'eratse. ");
INSERT INTO bwo_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iyesus maniyere il, «Waa moore» bíet. Boúnets doonzo Iyesusi b́ wottsok'o dant boteshtsotse b́ danifwotsitse dab́ ikonwor, «Kone nee?» ett aatosh aawo shuuk'tso aali. ");
INSERT INTO bwo_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Mann Iyesus waat, mishonat mus'on k'aaúdek't b́ími. ");
INSERT INTO bwo_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iyesus k'irotse b́ tuwihakon b́ danifuwots bín bobek'irwan keezla b́tesh. ");
INSERT INTO bwo_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Guur misho bomeyihakon Iyesus Sim'on P'et'rossh, «Yona naay Sim'ono! hanots taan bo shunirwoniyere bogo taan shunfiy?» bíet. Bíwere «Ee, t doonzo! taa neen tshuntsok'o neewor danfnee» ett bísh bíaaniy. Iyesuswere «T mereer buk'ulwotsi maanzwe» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Aaniy gitlo «Yona naay Sim'ono! taan shunfiya» bíet. Bíwere «Ee t doonzo! neen tshutsok'o nee danfnee» bíet. Iyesuswere «T mereer nana'úwotsi kore» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Keezlonowere «Yona naay Sim'ono! taan shunfiya?» bíet. Keezlo «Taan shunfiya» bíetsosh P'et'ros shiyanwtsat «Doonozono! Nee úno danfnee, taa neen tshunok'onowere danfnee» bíet. Iyesuswere hank'o bísh bíet, «T mererwotsi jinee ");
INSERT INTO bwo_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Arikon, arikoniye, neesh ti etiry nee jawetson nbeyor ni edo n kishon edde'er nshuntsok niamfoni nteshi, ni enashormó nee n kishuwotsi njargre k'osh asho neesh bíediti, nshunawokowere neen debíameti.» ");
INSERT INTO bwo_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Han bíetuwere P'et'ros aawk'o k'iron Ik'o mangiyo bísh b́geyitwok'o kitsosha b́tesh, Maniyere il P'et'rossh «T shuutso shoydewowe!» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","P'et'ros wongr ett Iyesus b́ shunf danifo b́ shuutso b́ wafere b́ bek'i, b́ danif han kooc'mishor Iyesusok t'iindek't, «Doonzono, neen beshide imetwo kone?» ett aattsoni b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","P'et'ros bín bek't, «Doonzono! ashaanmó aawk'owe b́ wotiti?» ett Iyesusi bíaati. ");
INSERT INTO bwo_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Iyesuswere «T wafetsosh s'ker beewe tietal neen eege gedi? Neehe t shuutso shoydewowe!» bíet. ");
INSERT INTO bwo_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Manatse tuutson eshwots dagotse «B́ danifman k'irratse» etts keewo shisheb́wts. Ernmó Iyesus «T wafetsosh beewe tietal neen bíts eege gedi» eta bíetibako «K'irratse» eraatse. ");
INSERT INTO bwo_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Keewanots jangosh jamon gawtsonat keewanotsnowere guut'tso b́ danifo, b́ gawts gawonwere ar b́wottsok'o danfone. ");
INSERT INTO bwo_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iyesus b́ k'altswots k'osh ay keewwots fa'ano botesh. Taash bíartsok'owosh bí b́ fints keew jamwots ik ikon boguut'eyink'ere guut'ets mas'aafwotsi datso b́tookon kuro falrawnk'e b́tesh.");
INSERT INTO bwo_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1"," Shiimetso Tewofloso! T mas'aaf shintsotse Iyesus b́ fintsonat b́danits jamo guut're. T guut'uwe Iyesus b́ fino dek'b́tuwortsoon tuut ");
INSERT INTO bwo_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Daro maantsan b́ tuuts aawo b́ borfetso b́ fintsoniyee, daro maantsan b́ tuwwere gal b́ dek'ts woshetswotssh b́ tzaziyo shayiri S'ayini weeron b́ imihakoniye, ");
INSERT INTO bwo_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ay gond bek'o dek't bí etiyak beyar beetk b́ wottsok'o kitsit weeron ayoto boosh b́ be'eyi, hab aawosh boats be'eyat Ik'i mengst jango boosh b́daniyi. ");
INSERT INTO bwo_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Bonton beyat b́móór hank'o ett boon b́ azazi, «Taa itsh t keewtsok'o nihokere itsh imosh jangiyetso korde'ere bako Iyerusalemitse keshk'ayere, ");
INSERT INTO bwo_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohanis aatsone b́gupi, itmo muk' aawoniye okoon shayiri S'ayinon gupetute.» ");
INSERT INTO bwo_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Bowere ikoke ko'edek't bo befere, «Doonzono! n mengsto Isra'elsh aani n imet aawo andeya?» ett boaati. ");
INSERT INTO bwo_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iyesusu hank'o ett boosh bí aaniyi, «Niho b́ took alon bí etts aawonat dúron it danosh falatste. ");
INSERT INTO bwo_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ernmó shayiri S'ayino itats b́ oot'or ango daatsitute, manoor Iyerusalemn, Yhud dats jamatse, Semariyon, dats daar jamats b́ borfetso taash gawo wotitute.» ");
INSERT INTO bwo_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Hank'owere bí etiyakon bo bek'fere daro maantsan k'az b́ tuwi, dawunonuwere bín dek't bo awatsere ááts b́k'ri. ");
INSERT INTO bwo_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bíwere daro maantsan b́ tuufere, boowere t'iwints dek't daromandan bo s'iilfere nas' taho tah dek'ts git ashuwots bo ganokere need' dek't, ");
INSERT INTO bwo_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","«It Galil ashuwotso, eegishe need'dek'at daromatsan it s'iliri? Daro maantsan b́ dek'efere it bek'ts Iyesus haniye, daro maantsan b́ tuufere it bek'tsank'on aanar weetuwe» bo eti. ");
INSERT INTO bwo_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Maniyere hakon Debrezeyit gurats Iyerusalem maants k'azboaani, Debrezeyit guro Iyerusalematse sanbati aaw sha'ok'oyiye (ik kilometrok'oyiye). ");
INSERT INTO bwo_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Iyerusalemits waat bobeef mootse dambani k'aat'ots k'az bokeshi, boowere P'et'rosi, Yohansi, Yak'obi, Indriyasi, Filip'osi, Tomasi, Bert'elemiyosi, Matiwosi, Ilfyos naay Yak'obi, okooretso Simoonnat Yak'ob naay Yhudne. ");
INSERT INTO bwo_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Jametsanots úniaawo Ik' k'onosh ik nibona bokakuweefo, bontonuwere mááts ik ikuwotsnat Iyesus ind Mariyamn, mank'owere Iyesus eshuwots fa'ano botesh. ");
INSERT INTO bwo_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Manoor P'et'ros bale hiyo wotitu amants ashuwots taalotse need'dek't hank'o bíeti, ");
INSERT INTO bwo_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Ti eshuwotso, Iyesusi detsts ashuwotsi jishtso Yhud jangosh, shin shin shayiri S'ayino Dawit noonon b́ keewtso S'ayin mas'aafi aap' s'eeno geyituwe. ");
INSERT INTO bwo_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yhud noyitsi iko wotat finan noonton finosh taaweytniye b́teshi. ");
INSERT INTO bwo_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ernmó ashaan b́ gond finon b́ daatsts gizmann datso keew b́dek'i, b́ baron diht gúp'unat b́ taalon kap'eyat bí anzro k'az b́keshi. ");
INSERT INTO bwo_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Keewanuwere Iyerusalemitse fa'a jamwotssh b́ daneyi, mansh datsmanúwere bo nooni keewon ‹Akeldama› et s'egeyi, b́ bitsonuwere ‹S'ats datsa› etee. ");
INSERT INTO bwo_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","«Man b́ wottsonuwere dub mas'aafotse, ‹B́beyoko dats baash wotowe, Konuwor bíyats beek'aye, Aaninuwere b́ naashts naasho k'osh asho bíyatse de'ewutsowe› Ett guut't teshetsotsnee. ");
INSERT INTO bwo_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«Eshe Doonzo Iyesus nodagotse bí ananori noonton towat teshtswotsitse, ");
INSERT INTO bwo_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Mank'o Yohans guproon tuut doonzo Iyesus daromaants b́ tuufetsi aawosh noonton teshtswotsitse ash iko noonton k'irotse tuwi jango gawo b́ woto geyituwe.» ");
INSERT INTO bwo_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Maniyere hakon git ashuwotsi bo t'intsi, boowere Bersabasi wee Iyost'osi eteefo Yosefnat Matiyasna botesh. ");
INSERT INTO bwo_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Hank'o ettnuwere Ik'o bok'oni, «Ash jami nibo dants doonzono! Gitetsanotsitse nmarat'tso aawi b́ woto noosh kitsuwe, ");
INSERT INTO bwo_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Nok'onirwonwere Yhud b́ tookon k'az bíamori k'azb́k'rts wosheetsots finan de'er b́ shaato shegrshosh wotituwo noosh nkiitsishee.» ");
INSERT INTO bwo_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","It'onowere bo shap'i Matiyassh b́ keshi, Mansh bí tatse ik woshetswotsnton b́ taaweyi. ");
INSERT INTO bwo_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","P'ent'e k'ost'eyi baaliyi aawa eteetso b́ bodtsok'on bo jametsuwots ik wotdek't ikoke kakuwedek'tni botesh, ");
INSERT INTO bwo_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Gawerawo eegurahi kup'ok'o arts k'aaro darotse b́weyi, bítse bo beyiru moonowere s'een b́wutsi. ");
INSERT INTO bwo_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Taaw laluw artso boats bobe'eyi, kaye kayeyatnúwere bo ik ikotsats k'ot'bodek'i. ");
INSERT INTO bwo_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Jamwotswere shayiri S'ayinon bo s'eeni, Shayiri S'ayinon bo keewituwok'o boosh b́ imtsok'on k'osh k'osh noonon keewo dek't botuwi. ");
INSERT INTO bwo_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Dats jamatse beyir datsatse waatsuwots, Ik' k'onon kup'iru ayhudiwots Iyerusalemitsa bobeefo. ");
INSERT INTO bwo_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","K'áármano bo shishtsok'on ayi ashuwots bo ko'eyi, bo took took nononowere bokewufere bo shishtsotse bo'adi. ");
INSERT INTO bwo_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tek'at adtnuwere hank'o bo eti, «Hank'o keewiru jamanots Gelil dats ash nosha? ");
INSERT INTO bwo_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Eshe no nó took noonon keewo bokeewefere noshishir aawuk'oneya? ");
INSERT INTO bwo_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","No P'arteen, Miedn, Elamn, Mesp'et'omin, Yhdon, K'op'dok'n, P'ant'osn, Isiyon, ");
INSERT INTO bwo_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frgiyoon, P'nfiliyon, Gbs'n, K'eren ganoke fa'úwots Libiyi awurajuwotsitse beyiruwotsiye, Romitse waats ayhudiyotsnat ayhudiwots jiro maantso kindtsowots daatseyiruwone, ");
INSERT INTO bwo_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Mank'owere K'ert'esitsnat Araawi dats ashuwots daatsetune, Hamb jamanots Ik'o een fino nononon bo keewufere shishiruwonee!» ");
INSERT INTO bwo_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Mann jametswots adt bo keewituwo t'ut't iko ikosh «Keewan eebiye k'úna b́wotiti!» bo et. ");
INSERT INTO bwo_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","K'oshuwotsmó «Weyiniyon dutsets biri handro úsht mashwutsernee!» eton boon boaatsni. ");
INSERT INTO bwo_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Manoor P'et'ros tatse ikuwotsnton need'dek't b́ k'aaro eenshdek't ash ashosh hank'o ett b́ keewi, «It Yhud dats ashuwotsnat Iyerusalemn beyiru jametsuwotso, wotts keewan danosh tkeewo k'ewere, ");
INSERT INTO bwo_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Guuron keez sa'ato b́wottsotse it it aasabtsok'o ashaanots masheratsnee. ");
INSERT INTO bwo_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ernmó han b́wotiye Nebiyiyo Iyu'el hank'o et b́ keewuts keewo b́ s'eenishe, ");
INSERT INTO bwo_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‹Ik'oniye dúri s'uwi aawots hank'o wotituwe etre, T Shayiro ash jamats kut'ituwe, Bo nungushnana'onat mááts nana'uwotsn bek'on keewitunee. Bo jawetswotswere bek'o bek'etune. Bo eenashuwotswere gúmo gumetunee. ");
INSERT INTO bwo_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Mank'o, manoori aawumanotsitse T guuts nungushuwotsnat máátsuwots atsats T shayiro kut'ituwe, Bowere bek'on keewitunee. ");
INSERT INTO bwo_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Danbe darotse adits keewwotsi, Dashe datsatse adits milkituwotsi kitsituwe, S'atso, taawo, s'uwi s'aawiyonuwere be'etuwe. ");
INSERT INTO bwo_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Eenonat aditso Doonzo aawo b́waafetsere shino, Aawo t'aluwituwee, Aashitsunuwere s'atso arituwanee. ");
INSERT INTO bwo_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Doonzo shútso s'eegetu jamo kashituwe.› ");
INSERT INTO bwo_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Israe'el ashuwotso! aap'an k'ewude'ere, It it tookon it dantsok'on Nazrettso Iyesus koni b́wottsok'o Ik'o it dagotse b́weeron b́ k'alts een een finwotsi, aditsuwotsnat milikituwots arikon daneewtsernee. ");
INSERT INTO bwo_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Bíwor b́ tookon Ik'o shin shino b́ k'anitsok'onat b́dants finok'on itsh besheyat bí imeyi. It were morrgonduwots kishon jiteyar b́k'irituwok'o it woshi. ");
INSERT INTO bwo_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ik'onmó k'iri angotse farit k'irotse bín b́ tuuzi mansh k'iro bín deshde oriyo falrtsatse. ");
INSERT INTO bwo_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dawit b́ jangosh hank'o etfe, Doonzo úni aawo tshinatse bek'iruwe, T shek'erawok'owere bí t k'ani aaratse ");
INSERT INTO bwo_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Manshe tnibo geneeúwre, T nononwere geneeúwone s'eene, Mank'owere tmeetsonú kótón jangáár beetuwe. ");
INSERT INTO bwo_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","T kashunowere Si'olitse k'ayk'reratsnee, N S'ayinonowere dowootse o'or b́ oorituwok'o woshratsnee. ");
INSERT INTO bwo_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kashi weeronowere taash danirne. Taanton nwottsonowere t geneúwo s'een wotituwe.» ");
INSERT INTO bwo_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Eshuwotso! yoots nihiwotsitsi iko Dawit b́ k'irtsok'onat b́ duketsok'on, b́ dowonuwere andish b́ borfetso noganok b́ fa'ok'owo kishde itsh keewuna. ");
INSERT INTO bwo_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ernmó Dawit han b́ keewiye Nebiyo b́ teshtsotsnat Ik'o nnaarotse iko n naashi jorats beezituwe ett taaron jangit b́imts keewo b́ dantsotsne. ");
INSERT INTO bwo_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Manatse tuutson Mesiyo Siolitse b́ oorerawok'onat b́ meetsonuwere o'or b́ oorerawok'o shin shino k'irotse b́tuwi jango b́keewi. ");
INSERT INTO bwo_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Iyesusi Ik'o k'irotse tuuzre, no noúnetswor keewansh gaw noone. ");
INSERT INTO bwo_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ik'o k'ani aaromants beyosh danbaan b́tuwooronat jangiyets S'ayin shayiro Nihoke b́ dek'tsok'on it bek'iruhannat it shishiruwann kuut'b́k'ri. ");
INSERT INTO bwo_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Eshe dambaan daromantsan keshtso Dawiti b́ woterawotse Dawiti b́tookon hank'o ett keewre, ‹Doonzo t doonzsh N balangarwotsi ntufishirots tgerfetsosh T k'ani aaromants beewe› » etre. ");
INSERT INTO bwo_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Eshe it itjittso Iyesusi Ik'o Doozonat Mesiyo b́ woshtsok'owo Israe'el ash jamo arikon dan de'e!» ");
INSERT INTO bwo_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ashuwotswere man bo shishitsok'oon bonibotse ayidek' shiyanat P'et'rosnat k'osh woshetswotssh, «No eshuwotso! eshe and eege nok'aliti?» boeti. ");
INSERT INTO bwo_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","P'et'rosuwere hank'o boosh bíeti, «Naandrone erere, it morro itsh orowa eteyish it ik ikets Iyesus Krstos shútson gupewere, Ik'i imtso Shayiri S'ayinono dek'etute ");
INSERT INTO bwo_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","B́ jangiyets aap'onwere itnat it nanaúwotssh, no Doonz Izar Izewer b́ maantsan b́ s'eegetu wokoon beyiru jamwotsshe.» ");
INSERT INTO bwo_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","K'osh k'osh ay keew keewon gawefetst «K'uur s'oot'anats weet fayotse it tooko kashiwere!» ett boon b́ izi. ");
INSERT INTO bwo_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Boyitse ayuwots b́ aap'tso dek't bogupeyi, manots aawotsowere keez kumok'o wotitwots amantsuwotsats dabebowutsi. ");
INSERT INTO bwo_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bowere wosheetsots daniyo k'ebon, ikwotde beyonowere, Mishi maratse towaat moonat Ik'o k'ononowere bokup'efooni. ");
INSERT INTO bwo_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Manoor wosheetsots kishon ayo adits keewonat milikitwots bo fineyiruwatse tuutson jametsatse shato oot' b́wutsi. ");
INSERT INTO bwo_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Amants jamwots ikwotde'erni bobeefon boteshi, Bo detsts keewu jamononwere shira b́teshi. ");
INSERT INTO bwo_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bo taaronat bo detstso kemdek't b́ gizo jametsosh b́geytsok'on bokayifooni. ");
INSERT INTO bwo_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Aawu aawon Ik'i mootsnowere ik nibona bokakuweefo, bomaa mootsnowere misho tishfetsr geneeúwonat nib sheengona bomaafoni botesh. ");
INSERT INTO bwo_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Doonzonowere bo udefoni, ash jamonuwere boon mangiya b́mangifo, Ik'onuwere kashiru ashuwotsi aaw aawon boyits daba b́dabfo. ");
INSERT INTO bwo_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ik aawu P'et'rosnat Yohansn Ik' k'oneef sa'aton aawitsi jed'i sa'aton Ik'moots boami, ");
INSERT INTO bwo_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Manoknowere «Sheenga» err s'eegef fengesh iko fa'e b́tesh, b́shuwertson tuut dúr wottso ash iko ashaashwots aawu aawon de'ewaar manok ger bok'rofo, bí manoke bede'er Ik' moots kindiru ash ashaatse gizo b́ k'onfoni. ");
INSERT INTO bwo_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ash han P'et'rosnat Yohansn Ik'i moots bokindfere bek't ms'uwatiyo booke b́k'oni. ");
INSERT INTO bwo_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Bowere ashman t'iwintsdek't s'iilt boere P'et'ros «Nomaants s'iile!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Bíwere booke ik jago b́ daatsituwok'o bí arere boon t'iwintsdek't b́ s'iili. ");
INSERT INTO bwo_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","P'et'rosmó «Ambaaronat awntson deshatse, t detstsonmó neesh imetuwe, Nazrettso Iyesus Krstos shúútson tuur sha'owe!» bí et. ");
INSERT INTO bwo_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","B́ k'ani kishonowere detsdek't tuuz b́k'ri, Manoor b́ tufonat b́ mak'tsi gimbon kup'b́wutsi. ");
INSERT INTO bwo_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Jobk' ettnuwere need'b́dek'i, Sha'eferowere bonton Ik'i moots b́ kindi, shaawefetst t'oolefetstnuwere Ik'o udi. ");
INSERT INTO bwo_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ash jamonuwere sha'efetst Ik'onowere b́ udefere bobek'i. ");
INSERT INTO bwo_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","«Sheeng fengesha» ett s'eegef Ik'i maa fengeshi ganoke bedek't giz k'onfo bí b́ wottsok'o danbok'ri, Bíyatsno wotts keewatse tuutson ayidek't adt dok etbowtsi. ");
INSERT INTO bwo_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kashts ashman P'et'rosnat Yohansn atse k'aleratse ett detsdek't b́befere ash asho adt «Solomon ananefoka» eteef beyokoke bo maants wos'fere boami. ");
INSERT INTO bwo_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","P'et'rosuwere ashuwotsi b́ bek'tsok'on boosh hank'owa bíet, Israe'el ashuwotso! Keewanatse tuutson eegoshe it adiri? Noon eegoshe t'iwints dek'at its'iliri? Noo no took kup'on wee noo sheeng fino nofiintsatse tuutson ashaan b́ sha'ituwok'o no k'altsok'o arefa itsha? ");
INSERT INTO bwo_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","No nihotsko, Abrahamko, Yisahak'ko, Ya'ak'obko Izar Izewer b́ naayi Iyesusi mangire, ernmó it bín P'ilat'os shinatse beshidek'at it imi, P'ilat'osuwere dab bín fakshk'ro b́ geere geeratsone it eti. ");
INSERT INTO bwo_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","It S'ayinonat kááwu finetso geeratsone etaat kash údts iko itsh b́bitsetuwok'o it k'oni. ");
INSERT INTO bwo_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kash imts wottsonowere it úd'i, Ik'onmó k'irotse bín b́ tuuzi, keewansh noo gawu noone. ");
INSERT INTO bwo_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","It bek'iruwonat it dants ashaan kashat b́ kup'iye Iyesus shúútson daatsets imnetiyone, Iyesus shútson bí amantsatse tuutsonowere it únets shinatse s'een wotts jeeno daatsre. ");
INSERT INTO bwo_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Andoor ti eshuwotso! it woor iti jishiruwotskok'o daron it k'altsok'o danfee ");
INSERT INTO bwo_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ik'onmó shinshin b́ nebiyi jametswots noonon ‹Krstos gond bek'o daatso bín geyife› ett bíaap'ts aap'o hank'on b́s'eentsi. ");
INSERT INTO bwo_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Eshe it morro itatse b́ t'afitwok'o naandrone err Doonzo maantsan aanoore. ");
INSERT INTO bwo_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ik'oke it handrit dúro itsh wetuwee, Ik'o shin itsh b́ marat'tso Krstos Iyesusi itsh woshituwe. ");
INSERT INTO bwo_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Bí darotse b́ teshet Ik'o shin bík S'ayin nebiyiwots noonon b́ keewtsok'on dats jamo bí handrefetsoshee. ");
INSERT INTO bwo_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musewere hank'o etre, ‹Doonzo Izar Izewer taan b́ tuuztsok'on mank'o it eshuwotsitse Nebiyiyo itsh tuuzituwe, bí itsh b́ keewitu jamo k'ewere, ");
INSERT INTO bwo_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nebiyiman k'ewawu jamo ashotse k'aleyar b́ jamon t'afituwe.› ");
INSERT INTO bwo_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Manats dabt Samu'el dúrtson teshts nebiyi jamwots, dúran jango mank'o keewurne. ");
INSERT INTO bwo_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","It nebiyiwotsi naatetuwots itne, mank'o Ik'o Abrahamsh ‹ash jamwots nnaaron deretúne› ett nonihotsnton b́ kindts taaro naatetuwots itne. ");
INSERT INTO bwo_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Mansh Ik'o b́guutso b́ wosh shin shino itshee b́ teshi, man b́ k'aluwere it ik ikon it took gond weeratse aanar it eree iti b́deerishe.» ");
INSERT INTO bwo_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","P'et'rosnat Yohansn ash ashosh keewoke bobefere kahniwotsnat Ik'i maa kotfuwotsatsi naashosh aaninuwere Seduk'awiwots bomaants waat ");
INSERT INTO bwo_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Wosheets gitetsúwots Iyesus k'irotse b́ tuwo ash ashosh bodanitsonat k'irtsuwots k'irotse botwitwok'owo kish bokeewutsotse bofayi. ");
INSERT INTO bwo_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Mansh boon dets bodek'iyakon datso ilat b́teshtsotse yaatsish b́ borfetsosh tipimoots boteshetuwk'o bok'ali. ");
INSERT INTO bwo_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ernmó bokeewuts keewo k'ebts ashuwotsitse ayuwots amanerno, amants ashuwots taawonwere úts kumo maants dambaan b́ t'iini. ");
INSERT INTO bwo_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Yaats guurok'on Ayhudi naashuwotsnat eenashuwotsn, Muse nemo danifwotswere Iyerusalemits kakuwe bowutsi. ");
INSERT INTO bwo_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kahniwots naasho Hananat K'eyafn, Yohansnat Indriyasn, Kahni maa naashwotsatsi k'aabo jag jamwots fa'ano, ");
INSERT INTO bwo_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bowere wosheets gitetsuwotsi botaalotse need'idek't, «Han it k'al eegi angoneyamó kon shútsoneya?» ett boon boaati. ");
INSERT INTO bwo_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Manoor P'et'ros S'ayin shayiron s'eent hank'o ett boosh bíaaniy, «It ash ashaatse naashtswotsonat eenashwotso! ");
INSERT INTO bwo_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Noo hambets no aateyirwo ash dúr ikosh k'aleets sheeng keewonat awuk'on b́ kashtsok'oniyee. ");
INSERT INTO bwo_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ashaan kashat it shinatse b́ need'ir, it it jiire Ik'onmó k'irotse b́ tuuztso Nazrettso Iyesus Krstos shútson b́ wottsok'o it únetsnat Israe'el ash jamo dane. ");
INSERT INTO bwo_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","It gimbi agfwots gac'at it juuts shútso bí nee, ernmó bí gimbiman tungúshatse shútswotsi kaatsde detset shúts eeno wotere. ");
INSERT INTO bwo_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Mansha kasho bína bako k'oshon konnor aaliye, noo bín nokashish geyitso Ik'o ashuwotssh b́ imts shútso bíyere okoon dats jamatse konwor aaliye.» ");
INSERT INTO bwo_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","P'et'rosnat Yohansn aawshuk'on bokeewtsok'o moosh mooshiyruwots bos'iltsok'on danaawonat daneraw ash bowoto bo dantsotse bo'adi, Iyesusntonwere bo teshtsok'o danbodek'i. ");
INSERT INTO bwo_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kashts ashonwere bonton b́ned'efere bo bek'tsosh boatsats bokeewituwo bot'ut'i. ");
INSERT INTO bwo_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Mansha moosh mooshifwotsoke úromaants bokeshetwok'o azazat muk'i boteshiyakon hank'o ett boshiyeyi. ");
INSERT INTO bwo_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«Eshe ashaanotsatse eeg k'aluwono? Adits keewi enan bo kishon b́ fiinetsotse Iyerusalemitse beyiru jamwotsoke danere, mansh keewan haalo falatsonee. ");
INSERT INTO bwo_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ernmó ash jamoke ayefere bíamawok'o hanyahak Iyesus shúútso s'eer konshor bo keewurawok'o ‹it atso korde'ere› erone.» ");
INSERT INTO bwo_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Manihak s'eegdek't Iyesus shúútso s'eer b́ jamon bodanirawok' kup'idek't boon boazazi. ");
INSERT INTO bwo_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","P'et'rosnat Yohansnmó hank'o et boosh boaaniyi, «Ik'osh aleyoniyere itsh aleyo Ik'i shinatse wotituwaa? Aab it it tookonor angshwere. ");
INSERT INTO bwo_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nooyere nobek'tsonat noshishtson keewo fal k'ayatsone.» ");
INSERT INTO bwo_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ash ashuwotsatsi naashwotsnat moosh mooshifwots P'et'rosnat Yohansn awuk'on bo fayitwok'o weero t'ut't, ashuwots boshattsotse aaniy sheefat faksh bok'ri, man bok'aluwere ashuwots wotts keewumantse tuutso Ik'o bo udtsosha b́tesh. ");
INSERT INTO bwo_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Adits keewann kashts ashman bí idmeyo hab natoniyere bogka b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","P'et'rosnat Yohansn faksh k'rere bo toohuwotsok boaantsok'on kahniwotsatse naashuwotsnat eenashuwotsn boosh boetts jamo bokeewi. ");
INSERT INTO bwo_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bowre man boshishtsok'on, ik wotdek't bok'aaro eenshdek't Ik'o maants hank'o ett bokuhi, «Daro, datso, aatsk'aro, boyitse fa'a jamo aztso Doonz eenono! ");
INSERT INTO bwo_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","S'ayin shayiron n guutso no nihi Dawit noonon hank'o etaat keewtso neene, ‹Ik' ash woterawwots eegishe bo shashiri? Ashuwots eegishe gond finosh datsmec'ron bo k'úmiri? ");
INSERT INTO bwo_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Datsatsi naashwots matseedekt, Dats k'ezirwots ik wotdek't ko'edek't, Doonzonat b́ Mesihiyo ats bo tuwi.› ");
INSERT INTO bwo_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«Aron Hirodisnat P'ent'os datsatsi asho P'ilat'os Ik' ash woterawwotsnat Israe'el ashuwotsn kitots ko'edek't nfuuttso S'ayin guutso Iyesus ats botuwi, ");
INSERT INTO bwo_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Hank'o b́ wotiye nee shino niangonat ntook shunon n beezts fino s'eetsoshe, ");
INSERT INTO bwo_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Doonzono!, andoor bo sheefirwan s'iile, n guutsuwots bosharaniye aawo shu'ude n aap'o bokewituwok'o woshuwe, ");
INSERT INTO bwo_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","N guuts S'ayino Iyesus shútson shodtswots bo kashitwok'onat adits, een een keewwots bo wotitwok'o n kisho jargwe.» ");
INSERT INTO bwo_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ik' k'ono bo ishiyakon ko'edek't bo beyiruwok man shek'e b́wutsi, jamwotswere shayiri S'ayinon s'een bowutsi, Ik'i aap'onwre ááwu shuk'on keewo dek't botuwi. ");
INSERT INTO bwo_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Amants jamwots ik nibonat ik maac'on detsfno bo tesh, konuworu ash iko, «Haniye tikee» bí eteet keewo deshatse b́ tesh, bo dagotsere jam keewo bo jamets shira b́ teshi, ");
INSERT INTO bwo_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Woshetswotswere Doonzo Iyesus k'irotse tuwi jango angi eenona bogawefo, jametswotsatsno Ik' s'aati eeno fa'e b́tesh. ");
INSERT INTO bwo_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Datso wee moowo detsts jamwotswere kem dek't b́ gizman dek't boweyiruwotse boyitse konworu t'ut'tso aali b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Gizmano dek'wat woshetswotssh im bok'refoni. Bo ik iketssh boosh b́ geyitsok'owa kay bodek'foni. ");
INSERT INTO bwo_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","K'op'rsn shuwetso, Yosefi eteetso Lewawi iko fa'e b́ teshi, wosheetswotsu «Barnabasi» ett bo s'eegfoni, b́ bitsonuwere «Kup'shit na'a» etee. ");
INSERT INTO bwo_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Bíwere b́ datso kemt b́ gizo dek'wat woshetswotssh b́ imi. ");
INSERT INTO bwo_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Hnaniyi eteef asho b́ máátsu Sep'iri eteetsunton datso bokemi, ");
INSERT INTO bwo_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","B́ máátsunu b́ danfere dats kemeets gizotse k'atso oorik'rat k'atsonmó dek' waat woshetswotssh imb́k'ri, ");
INSERT INTO bwo_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","P'et'rosmó bísh hank'owa bí'et, «Hee Ananaiyo! S'ayin shayirats korr datso kemeets gizotse nooridek'etwok'o n nibots Shed'ano eegishe b́ kindi? ");
INSERT INTO bwo_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","N kemftsere shino datsman nikoshna b́ teshi? N kemiyakonor gizo nikoshna b́ teshi? Eshe, keewan eegoshe n nibots n gawi? N kootiye Ik'atsa bako ashaatsaliyee.» ");
INSERT INTO bwo_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Hananiyi b́ keewts keewuman b́ shishtsok'on diht b́ k'iri, keewuman shishts ash jamo ayidek't shatbowtsi. ");
INSERT INTO bwo_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Jawetswotsu b́ duuno k'oddek't dek'amt duukbok'ri. ");
INSERT INTO bwo_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Keez sa'atonire okoon Hananiyi máátsu b kenihats bodts keewo b danawo waa bkeshi. ");
INSERT INTO bwo_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","P'et'rosuwere «Aab taash keewwe it datso it keemts k'awuntso hank'one?» bish bíet. Biwere «Ee! Mank'o gizoshe?» bi'et. ");
INSERT INTO bwo_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Manoor P'et'ros, «Ik'i Shayiri S'ayino fadosh aawuk'oneya ik it woti? Hamb! nkenihi duukt aaniru ashuwots fengeshatsnee, Nenowere de'amr duuketunee» bí et. ");
INSERT INTO bwo_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Biwere manoor b́ tufishroots dihat k'irbwutsi, Jawetswotswere bokindtsok'on k'irgutsat b befere daatst dek'amt b kenih ganok duukbok'ri. ");
INSERT INTO bwo_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ik' mootsi ash ash jamona et keewan shishtsuwots ayidek shato wotb́wtsi. ");
INSERT INTO bwo_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Adits keewu ayuwotsnat milikituwotsn wosh etsúwots kishona bofinefo b́tesh, jametsuwotswere ik nibon wotde'er Selemon dada etefokna bokakuwefoni. ");
INSERT INTO bwo_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Bonton woterawo ikonuwor dab bonton wotosh ááwu shuuk'fo aali b́ tesh, b́ woteferor ash jamo boon mangya bo mangifoni. ");
INSERT INTO bwo_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Doonzono! amaniru máátsonat nungushwots botaawo ayidek't ayefera bíamfoni. ");
INSERT INTO bwo_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ash ashuwots shodets ayuwotsi weromantsana kishde'er es'onat she'ats bok'eezfoni, mank'o bok'alirwere P'et'ros man weeron b́beshoor b́ s'ilalo dab́ ik iketsuwotsats b́bodishee. ");
INSERT INTO bwo_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ash asho Iyerusalem gúúratse fa'a kitwotsitse shoodetsonat kim shayiron gondo bek'irwotsi de'erni bowaafo, jametswotswere kasha bokashefo. ");
INSERT INTO bwo_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kahni naashwotsatsi k'aabonat bínton teshts Seduk'awino eteefuwots jirwots bojamets okooron s'eent boatsats botuwi, ");
INSERT INTO bwo_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Woshetswotsi detsdek't tipimoots kindsh bok'ri. ");
INSERT INTO bwo_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Melakiwotsmó t'ú tipi maa fengesho k'eshdek't boon kishbok'ri, ");
INSERT INTO bwo_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Ameree! Ik'i mootse need'de'er kashi keewo detsts keewan ash jamosh keewwere!» boosh bíeti, ");
INSERT INTO bwo_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Woshetswotswere b́ tzaziyo dek't guuron Ik'i moowots kindek't daniyo dek't botuwi. Manoor Kahani naashwotsatsi k'aabonat bínton beyirwots wáát mooshiru jirwotsnat Ayhudi eenashts jamwots ikok ko'ebowutsi, ashuwots woshetsauwotsi de'er bowetuwok'o tipi moowo maantsan bowoshi. ");
INSERT INTO bwo_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Woshetswotswere tipi moo maantsan wáát woshtsuwotsi bítse daatsratsno, aanat waatnuwere, ");
INSERT INTO bwo_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Tipi maa fengsho kup'shdek't is'etsok'on, kotiruwotsuwere b́ fengshatse need'dek't bokotfere nodaatsi, tipi maa is'o nok'sheoromó eegoru bítse datsatsone» ett bokeewi. ");
INSERT INTO bwo_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ik'i moo kotirwotsi jishruwonat Kahanati naashuwots n han boshishor «Eebi keewan naaroni?» ett daand bowutsi. ");
INSERT INTO bwo_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Manoor ash iko wáát «Tipi moots it gedts ashuwots hamb́, Ik'i mootse need'dek'tniye ashuwotsi bodaniri» ett boosh b́ keewi. ");
INSERT INTO bwo_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Manoor Ik'i maa kotiruwotsi jishiruwonat bínton beyiru ashuwotsnton amt boon dek't boweyi, bodoowuwere angnon b́woteraniye dashdek'tniye, han bok'aliye ashuwots boon shútson bojod'awok'o shatniye. ");
INSERT INTO bwo_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Woshetswotsno dek'wat mooshiyruwots shinat bot'intsi, kahani naashonuwere hank'o ett boon bí aati, ");
INSERT INTO bwo_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Iyesus shútso s'eer it danirawok'o itn kup'shdek'at azazerone b́teshi, ernmó hamb, Iyerusalemi it daniruwon s'entsk'rerte, itmo ash man k'irotse no aatetuwok'o woshoshe itgeyri.» ");
INSERT INTO bwo_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","P'et'rosnat woheets k'oshuwotsn hank'o et boaaniyi, «Ashosh aleyoniyere Ik'osh aleyo noosh geyife, ");
INSERT INTO bwo_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","No nihotsko Izar Izewer it mitats jittdek'at it úd'tso Iyesusi k'irotse tuuz b́k'ri, ");
INSERT INTO bwo_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ik'o Israe'el ash ashosh naandre etonat bomorrosh oorowe eto b́ imetuwok'o Iyesusi jishiruwonat woritson woshdek't b́ k'ani aaromants mangon b́ beetuewk'o woshre, ");
INSERT INTO bwo_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Keewu man jangosh noo gawunone, Ik'o bísh aleets jamwotssh b́ imts S'ayin shayiro gawe.» ");
INSERT INTO bwo_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Moosh mooshiyruwots man bo shishtsok'on ayidek't fayat woshetswotsi úd'o bogeyi. ");
INSERT INTO bwo_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ernmó ash ashoke mangiyetsonat Muse nemo danik wottso Gemaliyali eteets ferisawi wotat moosh mooshif iko tuut woshetswotsi múk' gizewosh úromaantsan bo kishituwok'o boon bíazazi. ");
INSERT INTO bwo_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Manoor mooshiru jirwotssh hank'owa bíet, «Israe'el ashuwotso! Ashaanotsats it k'aliru keewosh it atso korde'ere. ");
INSERT INTO bwo_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Haniye shin Tewodasi eteets asho ‹Taahe ash een taane› ett tuure b́ teshi, awd balok'o ashonwere bínton ik woterne bo teshi, ernmó bín úd'niyek'reyi, b́ shuutso shairwotsuwere bad' bowutsi, bí'ettsonuwere shiro boraniyere b́ oori. ");
INSERT INTO bwo_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Maniyere hakon ash ashuwotsi taawets dúron Geliltso Yhud tuwut ay ashuwots b́shuutso bosha'itwok'o b́ woshi, bínowere úd'eyi, b́ shuuts sha'irwotswere bad'e bobad'i ");
INSERT INTO bwo_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Mansh and taa itsh tietirwo it ashaanotsoke wokar boon k'ay it k'rituwok'owe, asaabiyan wee finan ashoke waaka wotiyal t'afitkee. ");
INSERT INTO bwo_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ik'oke waaka wotiyalmó boon t'afiyosh falratste, Ikinuwor Ik'onton fayeye itsh wotitwe.» Bowere Gemalyal iztso bodek'i. ");
INSERT INTO bwo_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Maniyak woshetswotsi bo maants s'eegdek't bojot'iyi, Iyesus shútsonowere s'eer bokeewrawok'o azazat faksh bok'ri. ");
INSERT INTO bwo_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Woshetswotsmó Iyesus shútsi jangosh keteyo boosh b́geyitwok'o bodantsotse gene'úwefetst mooshi jeboke kesht boami, ");
INSERT INTO bwo_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Aawu aawon Ik'i moonat maa mootsnowere Mesihiyo Iyesus jango daniyonat doo shishi keewo ned'iratsno boteshi. ");
INSERT INTO bwo_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Múk'i boteshtsok'on, amantsuwots taawo ayefere bí amee Grik dats noon keewo keewiru ayhudiwots Yhud datsatse shuwets ayhudiwotsats mumundo dek't botuwi, bomumundiruwere aaw aawon bokenih k'irts maatsuwotssh kayiyeyiruwo batk'o bobatefosha b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Mansh tatse git wosheetsots amants jametsuwotsi kakuk'raat boosh hank'o boet, «Mish kayiyosha err Ik'o aap' daniyifino k'azo noosh geyiratse. ");
INSERT INTO bwo_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Eshe eshuwotso! bosheeng doyon udetswotsi, S'ayin shayironat danon s'eents shawat ashuwotsi ititse geyore, bonowere finanats naashiwonee. ");
INSERT INTO bwo_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Noomó Ik'o k'ononat Ik'o aap'o daniwosh kup'ituwonee.» ");
INSERT INTO bwo_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Bo ettsan jamwotsi b́ geneúshi, ashaanotsnowere galbodek'i, boowere imnetiyonat S'ayin shayiron s'eentso Ist'ifanosi, Filip'osi, P'rokorosi, Nik'arona, Timona, P'ermena Ayhudi imnetiyo dek't teshtso Ans'okiyi datsatstso Nik'olawosiye. ");
INSERT INTO bwo_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Hanotsi wosheetsots shinats need'i bok'ri, woshetswotsuere Ik'o bok'oniyakon bo kishonowere boats bogedi. ");
INSERT INTO bwo_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Hank'on Ik' aap'o gawunfere bíamtsotse, Iyerusalemitsi amantsuwots taawo ayidek't ayefere bíamtsotse Kahanatiwotsitsnowere ay wottswots bo amani. ");
INSERT INTO bwo_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ist'ifanos Ik' s'aatonat angon s'eent adits keewuwotsnat een een milikituwotsi ash ashuwots dagotse b́ k'aliri b́ teshi, ");
INSERT INTO bwo_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Manoor, «Nas' kishitu ayhudiyots Ik' k'oni maa» eteets ayhudiyots Ik' k'oni moowotse ashuwots K'erennat Iskndriyas ashuwots, Kilk'iyanat Isiyi datsatatse ik ik ashuwots tuut Ist'ifanosi k'efoon bo mooshfere boteshi. ");
INSERT INTO bwo_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ernmó Ist'ifanos bín b́ keewiru dani telefo S'ayin shayiro bísh b́ imk b́wotsotse bísh aaniyo falratsno botesh. ");
INSERT INTO bwo_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Manoor ashaan, «Muse nat Ik'ats c'ashi aap'o b́ keewfere shishrone» eteet ashuwotsi degon bí ats tuuz bok'ri. ");
INSERT INTO bwo_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mank'oon ash ashonat eenashuwotsn Muse nemo danifuwotsnowere bíyatsats tuuz bok'ri, Ist'ifanosokowere amt detsdek't moosh mooshiyiruwots shinats bín t'intsbok'ri. ");
INSERT INTO bwo_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bíyats kooton gaawit ash ik ikuwotsnowere dek'tboweyi, kooton gawituwotswere hank'o boeti, «Ashaan Ik'i mannat Muse nemo jamawa b́ c'ashfo. ");
INSERT INTO bwo_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Aaninuwere ‹Nazrettso Iyesus Ik'i man gaketuwe, Muse noosh b́ beshits teronowere woniyituwe› ett b́ keewufere shishrone.» ");
INSERT INTO bwo_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Manoor mooshi jebatse fa'a jamwots Ist'ifanosi t'iwintsdek't bos'ile b́ shiitso melaki shitsok'o araat boosh b́ be'eyi. ");
INSERT INTO bwo_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kahniwotsatsi naasho Ist'fanossh, «Eteets keewan arikeya?» eton bíaati. ");
INSERT INTO bwo_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ist'fanosuwere hank'o ett bísh bíaniyi, «Ti eeshuwotsnat tnihotso! aab taan k'ewere! Nonih Abraham Karan datsatse beyosh bíamfetsre shino shin Mesp'et'omiya eteets datsatse b́ befere Mangts Ik'o bísh be'eyat ");
INSERT INTO bwo_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‹N datsatse keer, n jagatse k'alyarr, taa neesh t kitsit datsats amee› bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Manoor Keledawiyots datsatse kesht Karani eteets datsats be b́wtsi, b́ nih b́k'irihakonowere Ik'o Karanitse kisht hambets it beyiru datsanats bín dek'et b́weyi. ");
INSERT INTO bwo_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Wotowabako dab tufi need'okok'o bodts rstiyo bísh imatse, b́wotefere datsani bínat bíyere il b́ naarosh rstiyo woshde'er b́imetuwok'o taarre b́teshi, bísh b́taaruwere Abraham na'o b́ detsfetsere shine. ");
INSERT INTO bwo_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","B́ naaronuwere ash datsatse gooshtsi wotar b́beetuwok'o datsmanatsnowere awd bal natosh guuts woshde'er was'o kayde'er boon bokewituwok'o bísh keewure b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Manats dabtnwere, ‹Guuts woshde'er b́ keewit ashuwotsats angshitwe, datsmanatse keer hanoke taan ik'itúne› ett Ik'o keewre. ");
INSERT INTO bwo_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Gof ami taaronowere bísh bími, mansha Abraham Yishak'i b́shuwor shimtl aawots gofo b́daamiyi, Mank'o b́ naayi Yisak'i gofo b́daamiyi. Yak'obuwere b́ jir tatse gitetsuwotsi gofo b́damyi. ");
INSERT INTO bwo_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Yak'ob nanaúwots bo eshuwi Yosefi okoort Gbs' datsatsere guutso b́ wotituwok'o bokemi, Ik'onmó bíntoniye b́ teshi, ");
INSERT INTO bwo_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Gond bek' jamotse bín b́ kishi, Gbs' naasho Fer'on shinatsere baatsonat danitelefo bísh bi'imi. Naashonuwere Gbs'nat b́ maa jamatse alituwo bín b́woshi. ");
INSERT INTO bwo_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Manór Gbs'nat Kene'an dats jamatse ayidek't ash kic'its k'ak'i eeno b́ woti, no nihuwotsuwere misho daatsosh falatsne. ");
INSERT INTO bwo_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ya'ak'obwere Gbs'itse mááyo b́ beyok'owo b́ shishtsok'on tuwreerosh nonihotsi manok b́ woshi. ");
INSERT INTO bwo_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Aani gitlo aanat Gbs'i bo amor Yosef b́ eshuotsesh b́ tooko b́ daneyi, jag bowotonúwere Fere'onokere b́ daneyi. ");
INSERT INTO bwo_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Maniye hakon Yosef b́ nihi, Yak'obnat b́ jag jamo b́mandan dek't b́weyi, bo bojametsuwre shabe úts ashno. ");
INSERT INTO bwo_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Mansh Yak'ob Gbs' maantsan bí ami, bínat no nihwotsn manoke bok'iri. ");
INSERT INTO bwo_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bomak'tsonowere Sekem maantsan dek'amt Abraham Sekemn Emor nan'úwotsoke b́ gizon b́keewts doowots dukeyi. ");
INSERT INTO bwo_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ik'o Abrahamsh taart b́ jangitso wotit aawo b́ t'inor Gbs'n beyiru ashuwots taawo ayefere bí ami. ");
INSERT INTO bwo_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Man b́ wotwere Yosefi danawo k'osh Nugúso Gbs'n b́ naashefetsoniye. ");
INSERT INTO bwo_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Handr naash manuwere no ashuwotsats gondo k'úmt no nihwotsats kic'iyo dek't bo tuwi, bo nana'i marmat'uwotsno bok'irituwok'o úratse kishde'er bo juwituwok'o, no nihuwotsi bokic'iyi. ");
INSERT INTO bwo_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Manór Muse b́ shuweyi, bíwere Ik'i shinatse na'i az sheenge b́teshi, keez shashonowre b́nihi meyitse b́ eeni, ");
INSERT INTO bwo_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Uratso juu k'irewor Fereon mááts naú k'audekat b́ naayik'o woshdek'at b ditsi. ");
INSERT INTO bwo_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musewwere Gbs' datsi dani teleef jamo danb́dek'i, b́ keewiru keewonat b́ finonowere kup' wotb́wtsi. ");
INSERT INTO bwo_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Muse hab nato b́ s'eentsok'on bí eshuwotsi Israe'el nana'úwotsi s'iilo b́ tuwi. ");
INSERT INTO bwo_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Bí eshuwotsitse ikonuwere Gbs' dats ash ikon t'uk'eyat was'o b́kashefere bek't bísh b́ gatsi, t'uk'eetsmanshowere weero weersht Gbs' dats asho togdek't b́úd'i. ");
INSERT INTO bwo_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ik'o b́ weeron boon b́ fakshiyituwok'o b́ jaguwots t'iwints bodek'etuwok'owa bísh araatni b́ tesh, bomó t'iwintsratsno. ");
INSERT INTO bwo_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Yaats guurok'onowere Israe'el ash gitetsuwots bo atsatseyo bo fayefere daatsdek't bonbaziyo geeyat ‹It ashuwtso! itwo eshu itnere, eegishe itfayeyiri?› bíet. ");
INSERT INTO bwo_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","B́ tooho togiru ashman Museyi okaan gifnit ‹Neenmó noon alituwonat noatse angshituwo kone nee wosh? ");
INSERT INTO bwo_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Oots Gbs' dats asho núd'tsok'o taanowere úd'osh geefiya?› bíet. ");
INSERT INTO bwo_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Muse man b́shishtsok'on Gbs'itse kesht Midiyam datsomants amt gooshtsi wotat b́beeyi, Manoke nungush nana'a gituwotsi b́shuwi. ");
INSERT INTO bwo_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Muse datsmanatse hab nato b́beshiyakon Debre Sin woruwotse aat'iru t'ugi atatsi tawi laluwotse melaki iko b́be'eyi. ");
INSERT INTO bwo_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Muse man b́bek'tsok'on bíadi, karndek't b́s'iilorowere hank'o etiru Doonzo k'aro b́shishi, ");
INSERT INTO bwo_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Taahe nnihotsko Izar Izewer taane, Abarhamko Izar Izewer, Yisahak'ko Izar Izewer, Yak'obko Izar Izewer taane,› Muse were shatoon k'ewub́wutsi, s'iloshowere aawo shu'atse. ");
INSERT INTO bwo_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Doonzonuwere hank'o b́ eti, ‹N ned'iruwok man S'ayin datso b́ wottsotse n tufitsi c'aamo kishuwe, ");
INSERT INTO bwo_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Gbs'itse fa'a ti ashuwots weralo gond bo bek'iruwok'o bek're, kic'at bo kuhirwono shishre, mansh boon kashiyosh oot're, andoor wowe! taa neen Gbs'its woshona.› ");
INSERT INTO bwo_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Israe'el ashuwotsu Musesh ‹Neen noats altsonat angshituwon woshtso kone?› Eton bín k'efatni botesh, wotowa boko t'ugi atatse bísh be'ets melakiyo jangon alituwonat nas' kishituwon woshdek't bomandan bín b́ woshi. ");
INSERT INTO bwo_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Gbs'nat Aats k'ar birokere aditsonat milikito finat bí ashuwotsi kish dek't hab natosh dats woruwtse jishtso Museyiye b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","‹Doonzo Izar Izewer taan b́ tiztsok'o mank'o it eshuwotsitse nebiyiyo itsh tuuzitwe› ett Isra'el ashuwots keewutso Museyiye b́teshi. ");
INSERT INTO bwo_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Woruwotse kakuwedek't teshts ashuwotsntonat Sin guri abaatse keewuts Ik'i melakiyonton animank'o no nihotsnton teshtso bíne. Ik'o keewuts kash imetu aap'o noosh beshitsonuwere un bíne Museyiye. ");
INSERT INTO bwo_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«No nihots bína bok'efibako bísh aleratsnee, Bonibotsnowere Gbs' maants aano bo gawi. ");
INSERT INTO bwo_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aronshowere ‹Noon Gbs'itse kishts Muse han eeg bíyats bodtsok'o no danawotse noshin shinatse sha'arr noon jishituwo Izar izewerotsi noosh doozwe› bo eti. ");
INSERT INTO bwo_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Manór manz aron dozets Ik'o doozdek't bísh wosho bo t'intsi, bokishi finonowere bogenee'úwi. ");
INSERT INTO bwo_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ik'onmó boatse k'aleniye b́wutsi. Daritsi k'eenwotssh bo ik'ituwok'o boon beshidek't bími. Manwere Nebiywotsn hank'o ett guut'etsok'one, ‹It Israe'el ashuwotso! Shúkeets gizonat woshon Hab nati s'eenosh woruwotse it t'ints tasheya? ");
INSERT INTO bwo_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Dek'at it amtso Molok gofonat Refani eteef k'enon it arits it ik'oniye b́ teshi, Bowere it kishon findek'at, It boosh it boosh sagadat it teshts ik'irwotsiye, Taawere Babloniye ok it gishetuwok'o woshituwe.› ");
INSERT INTO bwo_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«No nihots woruwotse gawi gofu detsfne b́ teshi, gofmanuwere Ik'o b́ keewutsok'onat b́ kitstsok'o bin fintso Museyiye b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ik'o boshinatse b́ gishts Ik' ash Woteraw ashuwots datso bo nator no nihots bodek'ts gofani Iyasunton manok bo kindshi, Dawit dúro b́ borfetsosh manoke b beyi. ");
INSERT INTO bwo_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawituwere Ik' shinatse baatso daatst Yak'ob Ik'o Izar Izewersh k'ewok wotit moo agosh Ik'o b́ k'oni. ");
INSERT INTO bwo_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ernmó Ik'í maa agtso Solomoniye. ");
INSERT INTO bwo_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«B́woteferor jam falts Ik'onmó ash kishon ageets moots beerake, manwere Nebiyon hank'o ett guut'etsoniye, ");
INSERT INTO bwo_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‹Daro t be jooroniye, Datsonuwere t tufi ned'oke, Eshe ááwu naari mee taash it agetuwoni?› ‹Bíyok t kashituwokonu awuk'one?› Etfe Doonzoni. ");
INSERT INTO bwo_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","‹Jaman taa t kishon t finkoshna?› Bíeti Ik'oni. ");
INSERT INTO bwo_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«It wed'etswotso it nibo is'etswotso! it k'el kúp'uwotso! it nihuwotskok'o jam aawo S'ayin shayiro it k'efiri. ");
INSERT INTO bwo_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nebíyiwotsitse it nihots bo gisherawo kone fa'oni? boowere kááw finetsman b́ weetuwok'o shin keewutswotsi boúd'i, It were and kááwu finetsan beshidek' imaat it úd'i. ");
INSERT INTO bwo_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","It Ik'i melakiwots weeron Muse nemo dek'at it teshi, ernmó kotde'atste.» ");
INSERT INTO bwo_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Mooshiru jirwots han boshishtsok'on nibo k'únbowutsi, Ist'ifanosi fayat bí'ats gasho bo shas'i. ");
INSERT INTO bwo_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ist'ifanosmó S'ayin shayiron s'eent daro maantsan kawudek't s'iilt, Ik'i mango darotse b́bek'i, Iyesus noowere Ik' k'ani aaromadan b́ need'efere b́ bek'i, ");
INSERT INTO bwo_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Eshe «Hambe, daro k'eshe b́ gwutsere ash na'o Ik'i k'ani aaro maantsan b́ need'efere t bek'iri» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Manoor bo k'aari eenon bo kuhi, bo waazono is'dekt ik wotdek't b́ maantsan bowos'i. ");
INSERT INTO bwo_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Kitotsno kishdek't shútson bo jot'i, gawuwotsuwre bo shemo dek'amt Sa'oli eteets jawets iko b́ kotetwok'o b́ tufi shirots ged bok'ri. ");
INSERT INTO bwo_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Shútson bín bo jot'fere, Ist'ifanos, «Doonzo Iyesuso! t kashu k'aaú de'e!» ett b́ k'oni. ");
INSERT INTO bwo_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tuk'umaldek't, «Doonzono! bo morran boats taawk'aye!» ett k'aari eenon kuhat man ettnuwere k'ir b́wutsi. ");
INSERT INTO bwo_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sawoluwe Ist'ifanosi úd'ewor bontoen ik wotatni b́ teshi, Ist'ifanos b́ k'irts aawots Iyerusalemn fa'a Ik' k'oni moowu ats gisheyewo tuu b́wutsi, woshetswotsiyere okoon amants jamwots Yhudnat Semariy awurajo maantsan bad' bowutsi. ");
INSERT INTO bwo_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ik ik shayirets ashuwots Ist'fanosi boduki, káári eenono kuhat bísh bo eepi. ");
INSERT INTO bwo_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sawolmó Ik'i moo t'afiyosh kaarefetstni b́teshi, mootsere moots kindt nungushuwotsnat mááts amantsuwotsn geetsdek' waat tipi moots b́ kindishiri. ");
INSERT INTO bwo_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bad'wutsts amantsuwotsuwere bo amts jamoke Ik'i aap'o bodanifo. ");
INSERT INTO bwo_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filp'osuwere Semariy kito maantsan amt ashuwotssh Mesihiyo jango b́ dani. ");
INSERT INTO bwo_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ashuwotswere Filip'os keewuts keewo bo shishor b́ finiru adits keewuwotsi bo bek'tsok'on ik nibon t'iwintsdek'tni bo k'ebiri. ");
INSERT INTO bwo_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kim Shayirotsuwere k'áári eenon kuhat ay ashuwotsitse bo keshfo, durwotsnat shoklirwotsn kasha bo kashefo. ");
INSERT INTO bwo_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Mansh kit manitse een gene'o b́ woti. ");
INSERT INTO bwo_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kit manitse Sm'oni eteets ash iko fa'e b́ teshi, ashman kitotse b́ danon finat Semari ashuwotsi aditniye b́ teshi, «Taa een ash taane!» ettni b́ keewfo. ");
INSERT INTO bwo_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ash jamo múk'onu eenonu «Ashaan ashi eene ett b́ s'egeyir Ik'i angone!» ett t'iwintsdk't bo k'ebfoni. ");
INSERT INTO bwo_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","T'iwintsdek't bo k'ebiruwere ay aawosh danon ashuwotsi adit b́ teshtsotsne. ");
INSERT INTO bwo_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ernmó Flip'os Ik'i mengisti jagonat Iyesus Krstos shútson b́ keewuts doo shishi keewo bo shishor nungushwotswere máátsuwotsuwere amanat bo gupeyi. ");
INSERT INTO bwo_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Smonuworu b́ oreraniyere amanat b́ gupere Filp'osntonu ik wotb́wtsi, b́ finiru adits keewwotsnat milikituwotsn bek't bíadfera b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Iyerusalemitse fa'a wosheetsots Semari ashuwots Ik'i aap'o bodek'tsok'o boshishtsok'on P'et'rosnat Yohanisn Semari datso maantsan bo woshi. ");
INSERT INTO bwo_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Semari ashuwots S'ayin shayiro bo daatsituwok'o P'et'rosnat Yohanisn amt boosh Ik'o bok'oni. ");
INSERT INTO bwo_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Semari ashuwots Doonzo Iyesus shútson bo gupeyi bako S'ayin shayiro konatsoru od'atse b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Mansh P'et'rosnat Yohansn bo kisho boats bo gedor ashuwots S'ayin shayiro bo dek'i. ");
INSERT INTO bwo_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Wosheetswotsu boats kisho bogedor S'ayin shayiro ashuwotssh b́ imestsok'o Simon b́ bek'tsok'on gizo dek'wat, ");
INSERT INTO bwo_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«Taa t kisho boats tgere ashuwots S'ayin shayiro bodek'etuwok'o alan taash imere» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","P'et'rosmó hank'o bíeti, «Ik'i imo gizon daatsosh n gawutsotse n gizo neenton t'afuwe! ");
INSERT INTO bwo_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","N nibo Ik'i shinatse kááwu woto b́ k'aztsotse nee keewanitse kayo wee bano deshatsne. ");
INSERT INTO bwo_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Eshe n gond finansh shiyanar naandre eree, daneraka n nibitsi gond finan orowa eteetwe wotiyal aab Ik'o k'onuwe. ");
INSERT INTO bwo_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Neehe s'aam okooron ns'eentsok'onat morron tipek n wotok'o taa bek'iruwe.» ");
INSERT INTO bwo_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sm'onuwere «It keewutsanitsere ik jago ti ats b́ borawok'o it it tookon taash Ik'o k'onuwere» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","P'et'rosnat Yohanisn bo gawiyakonat Doonzo aap'onwere bo keewiyakon Semari gal aywotsitse doo shishiyo nabfere Iyerusalem maantsan bo'ani. ");
INSERT INTO bwo_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Doonzo melakiyo Filip'ossh, «Tuur Iyerusalemiyere Gááz maants damiru weeron Muur maantsan amee» bí eti, weer manuwere woruwi weere b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Bíwere tuut bíami, manno, Itiyop'iyi dats naash iko Ik'o k'onosh Iyerusalem maants amt b́ tesh, ashaan Hndeki eteets Itiyop'iyi Nugúsúsh b dets jamatse bish fintsonat b gizatse altsoniye b́teshi, ");
INSERT INTO bwo_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Bí b́ datsomants bíaanefere seregelats bedek't nebiyiyo Isayas mas'afoni b́ nababefe b́tesh. ");
INSERT INTO bwo_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Manóóri sa'aton S'ayin shayiro Filip'osi «Seregel manok t'iinr bínton gonkeewe» bíet. ");
INSERT INTO bwo_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Mansh Filip'os bíyok wos'fere amt Itop'iyi dats ashman nebiyiyo Isayas mas'fo b́ nababefere shisht «N nababiruwo b́ biitso neesh galiruwa?» bí et. ");
INSERT INTO bwo_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Itiyop'iyi dats ashonwere «Taash biishde'er keewituwo aalo taash aawuk'oneya gaalo b́ faliti?» bíet. ");
INSERT INTO bwo_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Bí b́ nababiru mas'aafi beyokonuwere hani b́ tesh, «Bí shukosh jokeyiru mererok'oyiye b́ teshi, Mererna'o b́s'iro k'ut'ewor s'ik bí etfok'o, Bíwere keewosh b́nono aawu'atse. ");
INSERT INTO bwo_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bíhe keteree, kááwu angshonowere bísh imeratse, B́ kashu datsatse k'aaúbazetsotse B́ s'ooti jango kone fal keewiti?» ");
INSERT INTO bwo_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Naashmanuwere Filip'ossh, «Nebiyiyo han b́keewu kon jangoshe? B́ took jangoshemo wee k'oshi jange? Oona neesha aab taash keewwe» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filip'oswere S'ayin mas'afanatse tuut Iyesus jangosh dooshishiyo b́ nabi. ");
INSERT INTO bwo_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Boamferowere aats beyok bobodi, naashmanuwere «Hamb, hanoke aatso fa'ee, tguperawok'o taan bazitu keewo eebi?» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filip'oswere «N nibi s'eenon ni'amaniyal gupewo falfne» bí eti. Naashmanwere «Iyesus Krstos Ik'o naayi b́ wottsok'o amaniruwe» b́ eti. ");
INSERT INTO bwo_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Naashmanuwere seregelo b́ ned'iyetuwok'o bíazazi, Bogitetswere aatso maantsan oot't amt bo eree Filip'os Naasho b́ gupi. ");
INSERT INTO bwo_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Aatsotse bokeshiyakon Doonzoko S'ayin shayiro Filip'osi k'aaúbdek'i, janderbonuwere aani gitlo be'atse, b́woteferor geneúwefets b́weero sha'o dek't b́tuwi. ");
INSERT INTO bwo_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip'osmó Azat'ositsne b́ daatseyi, K'isariyi maantsowere b́ wafetsosh kit kitotse sha'at dooshishiyo b́ nabfoni b́teshi. ");
INSERT INTO bwo_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Manoor Sawuol doonzo danifuwotsi úd'osh naakefere kahaniyots naashok bíami. ");
INSERT INTO bwo_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Doonzo weerindion shairu ashuwotsi nungushwotsno máátsuwotsno b́ daatsor tifde Iyerusalem maants de'er woo bín faliyit debdabeyo guud'de Demask'oyitsi ayhudiwots Ik' k'oni moowwots sh bísh imetwok'o kahini naash naasho bí aati. ");
INSERT INTO bwo_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Amfetst Demask'o maants b́ t'intsok'on b́ gúúratse gawerawon darotse shááno gol b́wutsi. ");
INSERT INTO bwo_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Manoor datsats dihb́wutsi, «Sa'olo! Sa'olo! eegishe taan ngishiri?» etiru k'aaro b́shishi. ");
INSERT INTO bwo_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sa'oluwere «Doonzono! kone nee?» bí eti, bíwere «Taahe nee ngishiruwo Iyesus taane, bín kosheef birro n k'efiyale neeshe iki b́gonditi, ");
INSERT INTO bwo_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Eshe, and tuur kitots kiduwee, bíyoke k'alo neesh geyituwonowere manoke neesh keewetuwe» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sa'olnton amfetst teshts ashuwots k'aaro shishfetst konnor bobe'awotse bo keewituwo t'ut't s'ik ett need'bowutsi. ");
INSERT INTO bwo_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sa'oluwere b́ dihtsoke b́ tuwi, bí aawwotsi b́ k'eshormó bek'o falratse, mansh ashaashwots b́ kisho dets dek't jishfere Demask'o maants dek't boam. ");
INSERT INTO bwo_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Keez aawu s'eenosh eegor bek'o b́ falrawo, b́ marawo, b́ úyawo b́tesh. ");
INSERT INTO bwo_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Manoor Demask'on Hananiyi eteefo Iyesus danif iko fa'e b́tesh, doonzo bek'on «Hananiyo!» ett b́s'eegi bíwere «Hamb taane, doonzono!» bí et. ");
INSERT INTO bwo_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Doonzonu hank'o bíeti, «Tuur kááwi eteyiru werindu maants amee, manokno Yhud mootse Sa'oli eteetso T'erses asho gewowe, bíwere and Ik' k'onoke b́ fa'oni.» ");
INSERT INTO bwo_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Sa'oluwere bí ááwuwots aani bek'o bofalituwok'o Hanani eteets asho bíyok kindt b́ kisho bíyats b́ gedfere bek'on b́ bek'i. ");
INSERT INTO bwo_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Hananiyuwere hank'o ett bíaani, «Doonzono! ashaan Iyerusalemitse beyiru amantsuwotsats ay gond keewo b́fintsok'o ayuwotsoke shishre. ");
INSERT INTO bwo_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Manoknowere n shúts s'eegiru jamwotsi tiposh kahni naashuwotsoke alo dek're.» ");
INSERT INTO bwo_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Doonzonuwere Hananiysh hank'owa bíet, «Bí t shútso Ik' danawu ashuwots shinatse, naashuwots shinatsnat Isra'el ashuwotssh danituwoniye, bí t k'ac'i sheengo b́ wottsotse bíyok amee, ");
INSERT INTO bwo_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","T jangosh awuk'o gondbek'o b́dek'etuwok'owo kitsituwe bísha.» ");
INSERT INTO bwo_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Mann Ananiyi maa man maants amt b́ beyiru mootsowere b́ kindi, b́ kishonowere Sa'olaats geddek't, «Ti eshu Sa'olo! hanmand n wafere weratse ni ats be'etso Doonzo Iyesus aani bek'o n falituwok'onat S'ayin shayiron n s'enetuwok'o niyok taan woshere» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Manorowere k'ok'r arts keewo bí ááwatse fed'at bí eree bek'o b́fali, tuutnwere b́gupeyi. ");
INSERT INTO bwo_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Meetwo b́ meeyihakon kup'b́wutsi, Demask'on teshts Iyesus danifuwotsnton muk' aawwotssh manoke b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Manorowere Sa'ol Demask'on «Iyesus Ik'o naayiye» etfere ayhudiwots Ik' k'oni mootse daniyo b́ tuwi. ");
INSERT INTO bwo_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Shishts jamwotswere, «Ashaan Iyerusalemitse shútsan s'eegiru jamwotsi t'afifoniyosha? Hanok b́wowuwere boon tifde'er kahni naashuwotsok de'er amooshoshna?» ett bo'adi. ");
INSERT INTO bwo_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sa'olmó iki kup'efere bí ami, Iyesus mesihiyo b́wottsok'o keewut Demask'oyitse beyat teshts Ayhudiwots noono bo keewituwo b́t'ut'ifoni b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ay aawoniyere il ayhudiwots Sa'oli úd'osh boshiyeyi, ");
INSERT INTO bwo_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Bímo gondon bíats bo shiyetsman danb́k'iri, boowere bín úd'osh t'uwe aawo b́ keshf fengshuwotsi bo kotfoni. ");
INSERT INTO bwo_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ernmó t'úwon b́ danifuwots Sa'oli oshots geddek't gimbiyi múlotse maskotiyon oorsh bo k'ri. ");
INSERT INTO bwo_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sa'ol Iyerusalem maants bíamor manoke fa'a Iyesus danifuwotsnton eeho b́geyi, bomó bí Krstosi bí amantsok'o arik boosh arewo b́ k'aztsotse bojamets bín boshati. ");
INSERT INTO bwo_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Bernabasmó Sa'oli woshetswotsok b́ t'intsre weeratse b́befere doonzo bísh b́ be'etsok'onat bín noono b́ keewitsok'o, Iyesus Shútsonowere Demask'on ááwu shuuk'on b́ danitsok'o boosh b́ keewi. ");
INSERT INTO bwo_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Mansh Sa'ol bonton wotdek't Iyerusalemitse bíananefo. Doonzo shútsonowere ááwu shuk'on b́ danifoni. ");
INSERT INTO bwo_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Grik dats ash noonon keewuf ayhudiwotsnton keewefetstni b́ mooshfo, bomó bín úd'osh k'anwutskno botesh. ");
INSERT INTO bwo_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Eshuwots man dan bok'rtsok'on K'isariy maants k'az dek'boami, manoknowere Terses maants k'aybíametuwok'o bowoshi. ");
INSERT INTO bwo_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Yhuditse, Gelilitsnat Semaritse fa'a jam Ik'i moowu jeeno datsrane, kúp'onowere kup'eraniye, Doonzono! mangiyifetsat S'ayin shayirowere kup'efetsat taawon eenranee. ");
INSERT INTO bwo_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","P'et'ros dats datsatse gúúroke b́ befere Ldiyn beyiru amantsuwotsok bíami. ");
INSERT INTO bwo_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Manoknowere shmt nati s'eenosh es'atse k'eets Eniyi eteef duro daats b́de'k'i. ");
INSERT INTO bwo_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","P'et'rosuwere «Eniyo! Iyesus Krstos neen kashituwe, tuur níees'o ec'ee!» bí eti. Bíwere manoor k'az b́tuwi. ");
INSERT INTO bwo_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ldaanat Saronon beyiru jametsuwots bín bek't doonzo maants k'az boaani. ");
INSERT INTO bwo_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Iyop'e datsatse T'abiti eteefu amants iku fa'a b tesh, Griki noonon Doork'ayi eta, b́ biitsonwere t'it'a etee, biwere sheeng keewo k'alonat t'owwotssh úni aawu imf máátsi btesh, ");
INSERT INTO bwo_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Manoor bi shodat b k'iri, mashdek'tnuwere dadirotse danbani gaad'ots bin gedbok'ri. ");
INSERT INTO bwo_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ldi Iyop'esh karn bteshtsotse Iyop'eyitse fa'a Iyesus danifwots P'et'ros Lditse b́ fa'ok'owo shisht «Oona muk'i nteyawo noosh kaari waa boree» et git ashuwotsi bíyok woshbok'ri. ");
INSERT INTO bwo_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Mansh P'et'ros tuut wosheetsuwotsnton b́weyi, b́ bodtsook'onowere dambani maa gáádots dek't boami, bo kenih k'irts mááts jametso bín guurdek' need' dek't eepfetst Doork' bonton kashon b beyor bwozits faaruwotsnat tah tahuwotsi bísh bokitsiri botesh, ");
INSERT INTO bwo_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","P'et'ros jametsuwotsnor úratse kishk'raat tuk'maldek't Ik'o b́ k'oni, duuno maantsowere aandek't «T'abitee! tuwwe!» bíeti, biwere bi ááwwotsi wogdek'at P't'rosi b s'iili, tuuwatnu beebdek'i. ");
INSERT INTO bwo_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Bíwere b́ kisho jargt bin detsdek't b́ tuuzi, bo kenihi k'irts máátsuwotsnat k'osh máántsuwotsi s'eegdek't naú kashon bo shinats b́ t'intsi. ");
INSERT INTO bwo_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Keewanuwere Iyop'e dats jamatse b́ daneyi, ay ashuwotswere Doonzon boamani. ");
INSERT INTO bwo_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","P'et'ros Simo'oni eteets gook' shik'iru ikonton ay aawosh Iyop'en b́ beyi. ");
INSERT INTO bwo_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","K'isari datsatse befo K'orneliyosi eteets ash iko fa'e b́ teshi, bíwere Rom datsatsi kes'fuwots shirotse «It'aliy brgediya» eteyiruwotse bali naasha b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Bíwere b́ maa ash jamonton Ik'o shattsonat Ik'a b́ Ik'ifoni b́ teshi, ayhudiyotsi tugretsuwotsno b́ tep'foni, Ik'o mantso jam aawosh b́ k'onfoni. ");
INSERT INTO bwo_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ik aawu jed'i sa'atok'on melakiyo bíyok t'int «K'orneliyoso!» ett b́ s'egfere shants bek'on b́ bek'i. ");
INSERT INTO bwo_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","T'iwints dek't Ik'i melakiyo maants s'iilt tek'on «Doonzono! eebi b́ naaroni?» bí eti. Melakiyonu bísh hank'o bí eti, «Ik' n k'ononat t'owwotsi n tep'iruwok'o bín neen gawetuwo Ik'i shinats t'inre, ");
INSERT INTO bwo_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ando ashuwotsi Iyop'e maantsan woshar P'et'rosi eteyiruwo Smoni s'egiwe, ");
INSERT INTO bwo_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","And bíhe ats k'ari ganoke fa'a gook' shik'iruwo Smon meyitse ib wotatniye b́ beyri.» ");
INSERT INTO bwo_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Han keewts melakiyo bíatse k'aleyat bíamtsok'oon K'ornoliyos b́ mootse fiinefnef gitetsuwotsnat bíats t'ints wotaderwotsitse Ik' shatf iko s'eegdek't ");
INSERT INTO bwo_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Jam keewonowere boosh b́ keewiyakon Iyop'emaants boon b́woshi. ");
INSERT INTO bwo_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Yaats guurok'on bo amt kitok bot'iints shirt sa'atok'on P'et'ros b́ beef moo abaatse gaad'otse Ik'o b́ k'onfera b́keshi. ");
INSERT INTO bwo_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Manorowere P'et'ros k'ak'wutsat ik keewo moosh b́ geyi, aawu mishonu k'aniyeyirwok'o bek'on bí ats b́be'eyi. ");
INSERT INTO bwo_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","B́bek'ts bek'onuwere Daro k'esheb́wutsere awd kaaton detsdek'ets eents taho arts keewo datsats b́ oot'fera. ");
INSERT INTO bwo_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Man abatsnowere k'osh k'osh naari s'ootswots bogeroon geetseyiru azeetsuwotsnat darotse bidiru kafuwotsuwere tahmanitse fa'ano botesh. ");
INSERT INTO bwo_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Manoor «P'et'rosoo! Tuur Shuh de'er moowe!» etiru k'aaro b́shishi. ");
INSERT INTO bwo_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","P'et'rosmó «Doonzono! woteratse! Taa s'ayin woterawo wee kim keewo maa danaktane» bít. ");
INSERT INTO bwo_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ando aaninuwere «Ik'o s'ayin b́woshtso, kima eto neesh geyiratse» Etiru k'aaro aaniyi b́shishi. ");
INSERT INTO bwo_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Manuwere keezoto b́wotiyako tah arts keewuman manoor Daromaants k'aaúdek'eyi. ");
INSERT INTO bwo_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","P'et'ros bek'an biitso «Eegek'úna b́wotiti?» Etfetst b́ nibots b́ kic'efere K'ornoliwos woshts ashuwots aatt Sim'on moo daatsdek't b́fengeshats boned'fere botesh, ");
INSERT INTO bwo_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","S'eegtnurewe «P'et'rosi eteefo Sim'on ib wotat beyiruwo hanokneya b́fa'oni» ett bo aati. ");
INSERT INTO bwo_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","P'et'ros bek'i keewuman biitso gawoke b́befere S'ayin shayiro bísh hank'o bíeti, «Eshe keez ashuwots neen geefne, ");
INSERT INTO bwo_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tuur ood'e, boon woshtso taa twottsosh hake baka nieraawon bonton amee.» ");
INSERT INTO bwo_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","P'et'roswere oot't ashuwotsok amt, «Eshe, Itgeyiru asho taane, eegoshe itweyi?» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bowere «No noweyiye báli naasho K'ornelewosokne, bíhe Ayhudi ash ash jamwots bo mangiyiru Ik'i ash dooniye, neen b́ moots s'eegiyir n etetuwo b́ k'ebetuwok'o S'ayin melakiyo bísh kitst keewure» bo et. ");
INSERT INTO bwo_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","P't'rosu moots boon kindsht bí ibiyakon k'ondek'tnuwere b́ k'eezi. Yaatsok'onowere tuut bonton bíami, Iyop'en fa'a eshuwotsitse ik ikuwots bínton boami. ");
INSERT INTO bwo_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Gitl aawotso K'isari bo bodi, K'orneliyosu b́ jaguwotsnat bíats t'ints b́ tohuwotsi s'eegdek't P'et'rosi b́kotiri. ");
INSERT INTO bwo_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","P'et'ros moots b́ kindor K'orneliyos bíyok t'int b́ tufi shirots dihit bín b́ k'oni. ");
INSERT INTO bwo_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","P'et'rosmó «Tuuwe! Taa neenk'o ash taane!» ett b́ tizi. ");
INSERT INTO bwo_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Bínton keewefetst gitso maants b́ kindor ay ashuwots ko'edek't bo befere b́ daatsi. ");
INSERT INTO bwo_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Bosh hank'o b́ eti, «Ayhudi wotts ashosh k'osh ashonton ik wotonat b́moots kindo nemo b́ bazitsok'o itworu it tookon danfte, ernmó konuworu s'ayin woterawo wee kima ti erawok'o Ik'o taash kitsre. ");
INSERT INTO bwo_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Mansh taash woshewor ik k'efalo tweyi, eshe eegosh taan it s'eegtsok'owo danosh geefe.» ");
INSERT INTO bwo_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","K'orneliyosu hank'o bíeti, «Awd aawoniye shin ewaar jed'i sa'aton t mootse Ik'o tk'onfera t teshi, eshe, tgawraniye ik asho goliru taho tahedek't t shinats b́ need'i, ");
INSERT INTO bwo_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Hank'owere taash bí eti, ‹K'orneliyoso! Ik'o n k'ono shishre, t'owwotsi ntep'irwo gawure, ");
INSERT INTO bwo_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Eshe Iyop'e maants ashuwotsi woshar P'et'rosi eteyiruwo Sim'oni s'egiwe, bíwere ats k'ari ganoke fa'a gook' shiik'fo Simon mootse ibo wotatniye b́ beyiri,› ");
INSERT INTO bwo_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Mansh manoor wosheets ashuwotsi niyok twoshi, neewere n waatsotse sheenge nfini, eshe Ik'o nkeewituwok'o neesh keewuwe bietts jamo shishosh noúnets Ik'i shinatse hanok kaku weerone.» ");
INSERT INTO bwo_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","P'et'ros hank'o ett keewo dek't b́tuwi, «Arikon Ik'o asho ashaatse b́ bogabogshrawok'o t'iwintsdek'ree, ");
INSERT INTO bwo_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Aawoki dats asho b́wotiyalor Ik' sharr kááwu keewo b́ finitka wotiyal Ik'o bín k'ebetuwe. ");
INSERT INTO bwo_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ik'o aap'tso Isra'elsh b́wooshtsok'o daneke, Jami doonzo Iyesus Krstosn jeeno nabfere b́ waawere boshee. ");
INSERT INTO bwo_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yohans gupi jango nabo b́ tuutsortson Gelilitse tuut Yhud dats jamatse wotts keewo danfte. ");
INSERT INTO bwo_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","«Dabtnu Ik'o Nazrettso Iyesusi S'ayin shayiron b́ futtsok'onat angono b́ imtsok'o danfte, Ik'onuwere bínton b́ fa'otse bíwere sheeng keewo finefere Dabilosn detsets jamwots kashifere b́ gúúri. ");
INSERT INTO bwo_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«Yhud gat'eriyotsnat Iyerusalem kitotse b́ k'alts keewu jamosh no gawu noone, bomó bín mitats jitdek't boúd'i. ");
INSERT INTO bwo_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ernmó Ik'o keezl aawots k'irotse tizt b́ be'etuwok'o b́ woshi. ");
INSERT INTO bwo_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","B́ be'ewwere shin shnon Ik'on marat'ets gawwotssha bako ash jamoshaliye, bíwere k'irotse b́ tuwiyakon no bonton iknon maat úshats gawwots no nee, ");
INSERT INTO bwo_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Keewuhan ashuwotssh no shishituwok'o bíwere kashetswotsnat k'irtsuwotsats bíangshituwok'o Ik'oke naashiyetso b́ wottsok'o no gawituwok'o noon azazere. ");
INSERT INTO bwo_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Bín amanitu jamo b́ shútson morrosh oorowe eto b́ daatsituwok'o nebiyi jamwots bísh gawitune.» ");
INSERT INTO bwo_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","P'et'ros man b́ keewor b́ keewiruman shishts ash jametsuwotsats S'ayin shayiro b́ oot'i. ");
INSERT INTO bwo_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","P'et'rosnton waatsuwots gof amts ayhudiwotsitsi Krstiyaniwotsitse Ik'o Ik'i ash Woteraw ashuwotssh S'ayin shayiro b́ imtsok'o bo bek'tsok'on bo adi. ");
INSERT INTO bwo_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ik'i ash Woteraw ashuwotssh S'ayin shayiro imetsok'o dantsuwotswere handr noon keewon keewufetst Ik'o údon bomangifere bo shishtsotsna. Manoor P'et'ros ");
INSERT INTO bwo_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Ashaanots nokok'o S'ayin shayiro dek'reene, béré, bo aatson boguperawok'o kone baziti?» ett b́ keewi. ");
INSERT INTO bwo_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Mansh Iyesus Krstos shútson bogupetuwok'o bíazazi, Maniyere il P'et'ros bonton muk' aawwotssh b́teshetuwok'o bok'oni. ");
INSERT INTO bwo_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yhud datsatse fa'a woshetswotsnat eshuwwotsn Ik' ash woterawwots Ik' aap'o bo dek'tsok'o bo shishi. ");
INSERT INTO bwo_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","P'et'rosu Iyerusalem maantsan aanat b́keshor gof amo geyk b́ wotok'o amaniru ayhudiyots, ");
INSERT INTO bwo_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«Egish gof amaawu ashuwots meyts kindat bonton nmeyi?» ett bín bok'oori. ");
INSERT INTO bwo_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ernmó P'et'ros wotts jamo hank'o ett ik ikon keewo dek't b́tuwi. ");
INSERT INTO bwo_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Taa Iyop'e kitotse Ik' k'onatse tbeefere bek'o tbek'i, t bek'tsonúwere een magaraji arts keewo awd kaaton detsdek'ere darotse oot't tiyok b́ weyri, ");
INSERT INTO bwo_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Bínowere t'iwints t s'iile magaraji tahotse Gizuwotsnat dini s'otswotsn, datsatse getseyiruwotsnat daaratse bidiru kafuwotsi t bek'i, ");
INSERT INTO bwo_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","‹P'et'roso! tuur shuhuder moowe!› etiru k'aaro tshishi, ");
INSERT INTO bwo_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Taamó ‹Woteratse Doonzono!! s'ayin woterawo wee kim wotts keewo b́jamon tnonots ger danaak taane› tieti. ");
INSERT INTO bwo_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ernmó gitlo, ‹Ik'o s'ayin b́ woshtso nee kima eto neesh geyiratse› etiru k'aro darotse taash bíanere t shishi. ");
INSERT INTO bwo_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Hanwere keezoto b́ wotiyakon tah arts keewuman jamon daro maantsan t'op'e b́wutsi. ");
INSERT INTO bwo_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Manoor K'isariyon tiyok wosheets keez ashuwots taa t beyiru moowok waat bobodi. ");
INSERT INTO bwo_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Hake baka t eraniyere bonton t ametuwok'o S'ayin shayiro taash b́ keewi, eshu shirtanotsu taantoniye bo faoni b́ teshi, bonton iknon amatnuwere K'orneliyosi eteyiru asho moots no kindi. ");
INSERT INTO bwo_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Bíwere melakiyo b́ mootse b́ned'efere b́ bek'tsok'on ‹Iyop'e maantsan asho woshar P'et'rosi eteyiruwo Sm'oni s'eegiywe, ");
INSERT INTO bwo_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Bíwere neenat nmaa ash jamo b́ kashit aap'o itsh keewituwe› bíettsok'o noosh b́ keewi. ");
INSERT INTO bwo_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Taawere keewo dek'at t tuure S'ayin shayiro shini noats b́ ot'tsok'o boatso b́ oot'i. ");
INSERT INTO bwo_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Manoor ‹Yohanis aatson b́ gupi, itmó S'ayn Shayiron gupetute› ett Doonzo keewts aap'o gawtdek'i. ");
INSERT INTO bwo_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","No doonz Iyesus Krstosn no amanor Ik'o noosh b́ imts imo bosho b́ imtsotse, eshe Ik'o baziyosh falituwo taa kone!» ");
INSERT INTO bwo_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Bowere han boshishtsok'on bo keewituwo t'ut't s'k et bowutsi, «Eshe Ik'o, Ik' ashwoteraw ashuwots kashi handrosh boon betsitu naandre eti nibo boosh imre,» ett Ik'o bo udi. ");
INSERT INTO bwo_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ist'ifanosi k'is'dek't úd'etson tuwts gisheyi jagon bad'ts amantsuwots Fink'en tuut K'op'rosn Ans'okiyo b́ borfetso bo ami, bí aap'ono ayhudiyotssha bako k'oshuwotssh keewakno bo teshi. ");
INSERT INTO bwo_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Wotowa bako K'op'rosnat K'erenon waats amants ik ikuwots Ans'okiyo bo amor Girikiyotssh dab́ doonzo Iyesus doo shishiyo bo keewi. ");
INSERT INTO bwo_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Doonzonuwere boon bíangon b́ tep'fera b́ teshi, ay ashuwotsu amanat doonzo maantsan boaani. ");
INSERT INTO bwo_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Iyerusalemitse fa'a Ik' moow keewan b shishtsotse Barnabasi Ans'okiyo maantsan b woshi. ");
INSERT INTO bwo_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Bíwere amt Ik'o b́ s'aato ashuwotssh awuk'on b́ imtsok'o b́ bek'tsotse geneú b́wutsi, jamwotsu bo nib s'eenon kup'ar doonzo amanetsuwotsi wotar bo beetuewk'o bíizi. ");
INSERT INTO bwo_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bíwere S'ayn shayironat imnetiyon s'eenk ash sheeng b́ teshtsotse bo taawo ay wotts ashuwots doonzo maantsan boaani. ");
INSERT INTO bwo_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Maniye okoon Barnabas Sa'oli geyosh T'erses maantsan bíami. ");
INSERT INTO bwo_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Datsdek'tnuwe Ans'okiyo maantsan dek't b́weyi, gitetswotsuwere ik nati s'eenosh amants ashuwotsnton ik wotat ay ashuwotsi bo daniyi, amantsuwotsuwere tewurerosh Ans'okiyon, «Kirstiyaniwotsi» ett s'egeyi. ");
INSERT INTO bwo_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Manoor ik ik Nebiyinee ett s'eegeyiru danifuwots Iyerusalemn Ans'okiyo maantsan bo ami, ");
INSERT INTO bwo_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Boyitsnowere iko Agabosi eteetso tuut dats jamatse k'ak' eeno b́ wotituwok'o S'ayin shayiro b́tizre bek'on bek't b́ keewi, hanuwere b́ woti Rom naashuwots naasho K'elawudiyos dúrone b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Mansh Ans'okiyon beyiru amantsuwots Yihudon beyiru eshuwotssh bo took tookon bo faltsok'o c'oc'de'er boon tep'o damiyetuwok'o boeti. ");
INSERT INTO bwo_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Gizmano kishdek't Barnabasnat Sa'ol kishon Ik' máá eenashwotssh bowoshi. ");
INSERT INTO bwo_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Man dúr nuguso Herodis Ik'i maa ash ik ikuwotsi gisho dek' b́tuwi, ");
INSERT INTO bwo_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Yohans eshuwi Yak'obi shikon b́ úd'iyi. ");
INSERT INTO bwo_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Keewu manuwere ayhudiwotsi b́ geneeúshtsok'o b́bek'tsok'on P'et'rosi ando aani detsi b́k'ri, man b́wotuwere ayhudiwots tush meyi baaliyo bomangif aawwotsitsna b́tesh. ");
INSERT INTO bwo_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","P'et'rosi b́detsiyehakon tipi moots kindshb́k'ri, ayhudiwots Fazigi baaliyoniye hakon ash ashuwotsok b́ t'intsfetso kes' kes'fwots awd awdon bokotetuwok'o awd jirwotssh imb́k'ri. ");
INSERT INTO bwo_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Mann P'et'ros tipi mootse detseyatni b́ kotefoni, ernmó Ik'i moowu b́ jangosh Ik'o maants kup'idek'atni b k'onfoni. ");
INSERT INTO bwo_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Yaats guurok'on Herodis P't'rosi ash ashosh t'intso gawudek'tni b́tesh, t'úmanots P'et'ros Habliyion tipeyat kes' kes'f giti dagotsa b́k'eyiri b́tesh, k'osh wotaderwotsuwere wee maa fengeshoni bokotiri. ");
INSERT INTO bwo_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Manoor doonzo melkiyo bíats be'eyat, tipi moots c'eesho shaano gol b́wutsi, melakiwonwere P'etros lalk'o t'awit tuzt «Káári tuuwe!» bíeti, habiliyonu b́ kishotsere fed'b́gutsi. ");
INSERT INTO bwo_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Melakiyonu «Ntaho tahade'er! nc'amono gerde'e!» bí eti. P'et'rosuwere azazetsok'o b́ k'ali, melakiyonu «N nat'alo tahader tshuutso wowe!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","P'et'ros waat b́ shuutso b́tuwi, bek'a b́ bek'iri bísh bíari bako melakiyo b́ k'alts jamo ar areratse. ");
INSERT INTO bwo_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Iknonat gitl koteyiruwokere beshat kitootsan damiru biri is'ok bobodi. Is'onuwere asho b́ t'awirawo hank'on bíaal k'esheb́gutsere kesht ik weridon beshat k'az boami, b́ gawurawo melakiyo P't'rosatse k'aleyat bíami. ");
INSERT INTO bwo_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","P'et'rosu b́ atso dant, «Doonzo b́ melakiyo woshat Herodis kishotsnat Ayhudi ashuwots bo kotiru keewu jamotse taan b́ kashitsok'o and taa arikon danre!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Man dan b́k'rihakon ay ashuwots ikok kakuwedek't Ik'o bok'oniruwok Mariyam mook bíam, Mariyam manuwere Mark'osi eteetso Yohans indi btesh. ");
INSERT INTO bwo_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","P'et'ros manok bodt úriweertso fengesho b́k'oftsok'oon Rodayi eteets gon iku koni b́wottsok'o danosh fengeshomants bweyi. ");
INSERT INTO bwo_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","P'et'ros k'aar b́wottsok'o danbk'rtsok'on b gene'úwi aytsatse tuwtson fengesho b k'eshrawon wos'aat gitsomaand kindat «P'et'ros fengeshatse b́need'iri!» etaat b keewi. ");
INSERT INTO bwo_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bowere «Geeniya nwutsi!» bo eti. Bimó «Arikon bíne!» arikon bín bek're etaat bkeewi, boowere bere «Bín kotiru melakiye b́wotiti» boeti. ");
INSERT INTO bwo_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","P'et'rosmó maa fengsho k'ofo ned'iratse, boowere fengesho k'eshdek't bos'iloor bo'adi. ");
INSERT INTO bwo_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Bímó s'k boetetuwok'o b́kishon kitst doonzo awuk'o k'aldek't tipi mootse bín b́kishtsok'o boosh keewut «Keewan Yak'obnat oorts amantsuwotssho keewwere» bíet. Boatse k'aleyat k'osh beyok k'az bími. ");
INSERT INTO bwo_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","B́gatstsok'onowere kes' kes'fwots «P'et'rosats eege b́woti k'úna?» ett ayidek't kic'bowutsi. ");
INSERT INTO bwo_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodisuwere b́weeron P'et'rosi geyit b́t'ut'tsok'on fengesh kotiruwotsi b́ maramariyakon boon úd'etuwok'o bíazazi, maniyere hakon Herodis Yhud datsatse tuut K'isariyi maants amt manoke beeb́wutsi. ");
INSERT INTO bwo_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodis T'irosnat Sidon dats ashuwotsats ayidek't fayatni b́tesh, boowere ikwotdek't waat, Nugúsok karnts guutso Blast'osi bonton b́tep'ish k'ondek't eeki bodek'iyakon Nugúso manosh bo aati, man bok'aluwere bodatsuu misho bdaatsfo Nugúso datsatse b́ teshtsosha. ");
INSERT INTO bwo_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Detsets aawmanots Herodis b́ naashi taho kardek't naashi jorats be'dek't ash ashosh keewo b́keewi. ");
INSERT INTO bwo_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ash ashonwere «Hanuwo Izar Izewer k'aara bako ash k'aaraliye!» ett bokuhi. ");
INSERT INTO bwo_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herodis Ik'osh mango b́ imaawo b́ oortsotse manoor doonzo melakiyo togb́k'rere shipro gedt b́k'iri. ");
INSERT INTO bwo_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ik' aap'onmo aawu aawon eenfetst gawunfera bíamfo. ");
INSERT INTO bwo_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabasnat Sa'oln boamts fino isht Iyerusalemitsere Ans'oki datsomand k'azboaan, Mark'osi eteetso Yohansnowere bonton dek't boweyi. ");
INSERT INTO bwo_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ans'okitse fa'a Ik'i moowutse nebiyiwotsinat danifuwots fa'ano botesh, boowere, Bernabasi, aak'a eteetso Sm'onu, K'eren datsats asho Lukyosu, awdlo kayo keewutso Herodisnton towaat eentso Mnahenat Sa'olne fa'ane boteshi. ");
INSERT INTO bwo_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Bo doonzosh finefetst s'oomoke bobefere S'ayin shayiro «Taa boon t galts finosh Bernabasnat Sawln taash galuwere» bíet. ");
INSERT INTO bwo_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Bowere s'oomat Ik'o bo k'oniyakon bokishono boats gedt wosh bok'iri. ");
INSERT INTO bwo_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnabasnat Sawln S'ayin shayiron wosheyat Selewik'iyo maats boami. Manokno markabon K'op'ros maats boami. ");
INSERT INTO bwo_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Selamis kitots bo bodtsok'on ayhudiyots Ik' k'oni mootse Ik'i aap'o bodani, Yohanis Mark'oswere bonton wotat boosh bodabiri b́teshi. ");
INSERT INTO bwo_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Aatso gúrts K'op'ros datsu k'ut't p'afuyi bo bodtsok'on Baryesusi eteefo ayhudits ik'ets ash iko daats bodek'i, bímó kootets nebiyiya b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","B́befonuwere Sergyos P'awlosi eteets t'iwintsdek'ts dats k'eezfontoni b́tesh, dats k'eezfan Bernabasnat Sa'oln s'eegt Ik' aap'o k'ebo b́ geyi. ");
INSERT INTO bwo_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ernmó Griki noon keew keewon «Elimas» ett s'eegets ik'etso Beryesus dats k'eezfo bíamanerawok'o geeyat Bernabasnat Sa'oln b́ k'efi. ");
INSERT INTO bwo_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","P'awlosi eteetso Sa'olmó S'ayin shayiron s'eent ashman t'iwintsdek't s'iilt hank'owa bísh bíet, ");
INSERT INTO bwo_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«Nee Dabilos naayo! ar jami t'alatono! dirshonat gond jamon s'eentsono, kááwu wottso doonzo weerindo k'uuriyo k'azalk neeneya! ");
INSERT INTO bwo_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Andoor hambe! doonzo kisho neen togetuwee, doogonowere wotitune, muk' gizewosh aawu shaano be'atsnee.» Manoor bíaawwotsi bampulonat t'aluwo ipb́k'iri, b́ kisho deshde'er jishit asho b́ ganoke geyo dek'b́tuwi. ");
INSERT INTO bwo_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Dats k'ezfonuwere wotts jamo b́ bek'tsok'on bíamani, doonzo jangosho b́shishts danon bíadi. ");
INSERT INTO bwo_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Maniyere okoon P'awlosnt b́ tohuwotsn Markabats keshdek't P'afutse P'nflyo maantse daatseyiru P'erge maants boami, Mark'osi eteyiruwo Yohanismó boatse k'aleyat Iyerusalem maants aanat bíami. ");
INSERT INTO bwo_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Boomó P'ergeyiyere tuut P'isdyayitsi datsatse fa'a Ans'okiyo maats boami, sanbati aawon ayhudiyots Ik' k'oni moots kindt beebowutsi. ");
INSERT INTO bwo_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Muse nemonat Nebiyiwots mas'afwots nababeyakon Ayhudi Ik' k'oni maa naashuwots «T eshuwotso, ashuwotsi kup'it izo detsfte wotiyal keewwere» ett P'awlosots maants asho bo woshi. ");
INSERT INTO bwo_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Mansh P'awlos tuut ashosh kishon b́koli, hank'o ett b́keewi, «Isra'el ashuwotsnat Ik' shatiru Ik' ash woterawwotso! k'ewere! ");
INSERT INTO bwo_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israe'el ashaanotsko Izar Izewer yoots no nihotsi galre, Gbs'datsatse boteshor een ashuwotsi boon b́woshi, bí een angonowere datsmanatse boon b́kishi. ");
INSERT INTO bwo_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Hab́natonoshowere woruwotse boon b́ k'ami, ");
INSERT INTO bwo_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kan'an datsatse shawat nugúsuwotsi t'afit bodatso bíashwotssh b́naatiyi, ");
INSERT INTO bwo_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Jaman awd bale balk'ats naato b́ ishi, maniyakowere nebiyo Samu'el dúrosh b́ borfetso Mesafntiyotsi b́ imi. ");
INSERT INTO bwo_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","«Manats dabt nugúso boosh b́ naashituwok'o Ik'o bok'oni, Ik'onuwere Biniyam jir wottso K'is naayi Sa'oli hab natosh boosh b́ naashiyi. ");
INSERT INTO bwo_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Sa'olno naashatse b́ orshiyakon Dawiti b́ naashiyi, Ik'onu Dawit jangosh b́ gawor, ‹T shuntsok'o wottso, tshunono fintso, Isey naayi Dwiti daatsre› etre. ");
INSERT INTO bwo_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ashaan naarotse Ik'o b́ jangits keewok'on Isra'eli kashituwo Iyesusi boosh b́ tuuzi. ");
INSERT INTO bwo_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Iyesus b́ waraftse shinon Yohanis Israe'el ash jamosh naandrone err gupeyo nabre b́teshi. ");
INSERT INTO bwo_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yohanis b́ fino b́ ishtsok'on ‹Taa kone itsh tiari? Taahe Mesihiyo taanaliye, ernmó b́ c'aami tiponoru dab bitsosh tborawo t shutsatse k'osho weetuwe› bí etfoni. ");
INSERT INTO bwo_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«It Abraham naaratse shuwets eshuwwotsnat itwere Ik' shatiru Ik' ash woterawwotso! bín kashet wóóshan woshe noshee ");
INSERT INTO bwo_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Iyerusalemn beyiru ashuwotsnat boon jishiruwots Iyesus kashitso b́ wottsok'o danatsne, sanbati aawu aawon nababeyiru nebiyiwots mas'aafwotsi t'iwintso bok'aztsosh bíats boangshor bek'on keewetso b́s'eenetuwok'o woshrne. ");
INSERT INTO bwo_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","K'irosh bín betsit keewo eegoru bíatse datso bok'azaloru bín boosh b́ úd'ituwok'o P'ilat'osi bo k'oni. ");
INSERT INTO bwo_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","B́ jangosh guut'ets jamo b́s'eeniyakon jitatse orshdek't boduki, ");
INSERT INTO bwo_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ernmó Ik'o k'irotse bín b́tizi. ");
INSERT INTO bwo_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Geliltsere Iyerusalem maants bínton waatsuwotsshowere ay aawosh boats b́ be'eyi, boowere and ashuwots shinatse b́ gawwotsiye. ");
INSERT INTO bwo_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","No itsh detsdek' nowatso Ik'o nonihotssh jangit b́ ímts doo shishiyi keewoniye. ");
INSERT INTO bwo_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ik'o Iyesusi k'irotse b́tiztsotse b́jangitsano noosh bo nanaúwotssh finats jitsre, manuwere gitli Dubotse, ‹Nee tnay neene, taa neen hambets shuure,› ett guut'etsok'one. ");
INSERT INTO bwo_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","B́ o'awok'o Ik'o k'irotse b́ tiztsok'o daniyosh, ‹S'ayin amanets deero Dawitsh jangit imetso itsh imetuwe› ett keewure. ");
INSERT INTO bwo_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Dabt k'osh dubotse, ‹N Naayi S'ayino b́ ok'etwok'o woshatsne› bí eti ");
INSERT INTO bwo_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ernmó Dawit b́ dúr jamo b́ fino Ik'i shuntso b́s'eentsyakon k'irre, nihwotsntonuwere duukere, ok'ree. ");
INSERT INTO bwo_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ik'o k'irotse b́tiztsonmó oa'atse. ");
INSERT INTO bwo_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Eshe tí eshuwotso! Morrosh oorowe eto datsetuwo Iyesusn b́wottsok'owo itsh nabetsok'o dande'ere, ");
INSERT INTO bwo_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Bín amants jamo Muse weeron imets nemo nas'o kisho b́ falawu morr jamatse nas'o keshituwe. ");
INSERT INTO bwo_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mansh nebiyatiyotsn Ik'o hank'o ett b́ keewetso itats b́ borawok'o korde'ere, ");
INSERT INTO bwo_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‹It aatsnirwots s'iilere! adúwere! t'afuwere! Konuworu asho itsh b́ keewure It amanerawu fino itdúroon finitwe.› » ");
INSERT INTO bwo_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","P'awlosn at Barnabasn ayhudiyots Ik' k'oni mootse bokeshfere keewan weet sanbatots aani boosh bokewituwok'o ashuwotsi bok'oni. ");
INSERT INTO bwo_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ayhudi Ik' k'oni moots ko'etswots bad'bowutstsok'oon ay Ayhudi jirwotsnat Ayhudi imnetiyots kindt Ik' Ik'iru Ashuwots P'awlosnt Barnabasn shuutso botuwi, P'awlosnt Barnabasnowere ashuwotsi danit Ik'i s'aaton kup'ar bobetuwok'o boosh bogawiyi. ");
INSERT INTO bwo_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Weet sanbatono kitotse beyiru ashuwotsitse aywots, Ik'i aap'o shishosh ko'ebowutsi, ");
INSERT INTO bwo_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ayhudiyots ash ashuwots ay bowottsok'o bo bek'tsosh okooron s'een bowutsi, b́ keewono k'efefetst P'awlosi boc'ashi, ");
INSERT INTO bwo_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","P'awlosn at Barnabasnomó hank'o ett ááwu shuk'on bokeewi, «Ik' aap'o shini itsh keewo geyife, it de'atsone it etalomó dúre dúr kasho itsh b́ woterawok'o it tookats it angshtsotse hamb no Ik' ash woterawwots maants wongrer ametuwone. ");
INSERT INTO bwo_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Manowere nok'alitiye doonzo, ‹Kasho dats daarats b́borfetso n doowetuwok'o Ik' ash Woteraw ashuwotssh shááno neen woshre› ett b́ azaztsotsne.» ");
INSERT INTO bwo_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ik' ash woterawwots han boshishtsok'n geneú bowutsi doonzo aap'o bomangiyi, dúre dúr kashosh gaalets jamwotswrere boamani. ");
INSERT INTO bwo_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Doonzo aap'onuwere dats jamanats bad'b́wutsi. ");
INSERT INTO bwo_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ayhudi jishiruwotsmó ayhudi imnetiyo amaniru gaalets mááts máátsuwtsenat kititsi een een ashuwotsi gondon P'awlosnat Barnabasn gishetuwok'o bowoshi, bo datsatsnowere boon bokishi. ");
INSERT INTO bwo_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","P'awlosnat Barnabasn boats botufatsi k'undo tebazt Ik'oniyon maants boami. ");
INSERT INTO bwo_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","B́ danifuwosuwere gene'onat S'ayn shayiron bos'eeni. ");
INSERT INTO bwo_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ik'oniyonitse P'awlosnat Bernabasn towaat ayhudiwots Ik' k'oni moots bokindi, manoknowere ay ayhudiwotsnat Ik' ash Woteraw ayidek't ayts ashuwots bo amanefetsosh bodaniyi. ");
INSERT INTO bwo_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Amaneraw ayhudiwotsmó Ik'i ash woterawwotsi tuzit eshuwotsats shit'o b́weetwok'o bok'ali. ");
INSERT INTO bwo_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Mansh P'awlosnat Bernabasn doonzo keewo ááwu shuk'on keewfetst manoke ayi gizewos boteshi, doonzonwere milikitwotsnat adits keewwotsi bokishon bofinetwok'o alo boosh imt, b́ s'aati aap'o ariko b́wottsok'o b́kiitsfoni. ");
INSERT INTO bwo_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kitutse beyiruwotsmó, gitoko kayaat bado ayhudiwotsnton bado woshetswotsnton bowoti. ");
INSERT INTO bwo_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ik' ash woterawwotsna ayhudiwots bo naashuwotsnton wotdek't P'awlosnat Bernabasn kaarar shútson togosh bogeyi, ");
INSERT INTO bwo_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","P'awlosn at Bernabasn man bodantsok'on Lst'ranat Derbeyi eteef Lik'a'on kituwotsnat bogúúratse fa'a datsats giifat boami. ");
INSERT INTO bwo_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Manoknowere doo shishiyo bonabi. ");
INSERT INTO bwo_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lst'ra datsatse b́ tufo lasha'awutsts ash iko fa'e b́tesh, ashaan b́ shuweetson tuut dura b́teshtsotse b́ tufoon sha'a danaka, ");
INSERT INTO bwo_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ashaan P'awlos b́ keewor bedek'tni b́ k'ebiri b́ tesh, P'awlos ashman t'iwintsdek't s'iilt kashosh bín betsit imnetiyo b́ detso b́ bek'tsok'on, ");
INSERT INTO bwo_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","«Kaawde'er ntufoon need'owe!» ett k'aari eenon b́keewi, ashmanwere t'oolat tuut hake bak b́sha'i. ");
INSERT INTO bwo_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ashuwotswere P'awlos b́ k'altso bo bek'tsok'on, bok'aaro eenshdek't «Ik'uwots ash aron wotdek't nok oot'rnee!» ett Lik'aoni noon keewu keewon bokeewi. ");
INSERT INTO bwo_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bernabasshower «Dya» boeti. Keewu keewiruwo P'awlosi b́ teshtsotse bísh «Hermeniye» boeti. ");
INSERT INTO bwo_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Kitoniyere úratse fa'o diyako s'ayin máá kahniyo minzi wrwotsnat k'odets funduwotsnowere kiti fengesho maants dek'wat ash ashonton ikwotdek't P'awlosnat Bernabasnsh wosho t'intsosh b́geyi. ");
INSERT INTO bwo_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Wosheets, P'awlosnat Benabasn man boshishtsok'on shiyanon botaho bo gaat'i, ash asho maantsowere wos't kuhefets hank'o boeti, ");
INSERT INTO bwo_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«It ash ashuwots eegishe han itk'aliri? Nowoor itnk'o ash noone, Noo hanok nowaa it hank'o k'awuntsal keewu jamatse wokar daro, datso, aatsk'aronat bogitsotse daatseyiru jamo aztso Kashetso Izar Izewer maants it aanituwok'o sheeng keewo shishiyishee, ");
INSERT INTO bwo_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Beshts dúrowotsitse ash jamo botook weeron boametuwok'o Ik'o boon kazb́k'ri, ");
INSERT INTO bwo_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Wotowa bako bíaawuk'o sheengo Izar Izeweri b́ wottsok'o gaawit sheeng fino k'alo need'iratse, darotse awusho itsh bútsiree, maay kakuwi shashwotsi itsh b́ imi, Mishonat geneeúon itn b́woriyi.» ");
INSERT INTO bwo_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Wosheetsots mank'o dabt bokeewiyalor ash asho boosh wosho t'intso b́k'azetuwok'o bobazi ayidek' kic'oone. ");
INSERT INTO bwo_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ayhudiwotsmó Ans'okiyonat t Ik'oniyonn manok waat ash asho tuzdek't P'awlosi shútson botogetuwok'o bowoshi, k'irb́wutstsok'o bíarere geets dek't kitotse kishbok'ri. ");
INSERT INTO bwo_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ernmó b́danifuwots waat bín gúúrdek't boned'fere P'awlos tuut kitots b́kindi, yaats guurok'onowere Bernabasnton Derbe maants bíami. ");
INSERT INTO bwo_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","P'awlosnat Bernabasn Derbe datsatse doo shishiyo danit ay ashuwotsi amantsuwotsi bowoshiyakon Lst'ronat Ik'oniyonn beshat P'sdiyin fa'úts Ans'okits boami. ");
INSERT INTO bwo_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Dats jam manotsatsnowere amantsuwots boamantsats kup'bodek'etuwok'o boon kup'iyonat izosh «Ik'i mengstots kindosh ay gondo noosh geyife» etfetst boon bdaniyi. ");
INSERT INTO bwo_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ik' k'oni maa mootse eenash eenashuwotsnowere boosh bonaashi, s'omat Ik'o bok'oniyakonowere bín boamants doonzosh adaro imbok'ri. ");
INSERT INTO bwo_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","P'sdiyanowere beshat P'nfli maants boami, ");
INSERT INTO bwo_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","P'ergeyitsnowere Ik' aap'tso bodaniyakon At'aliyi maants boami, ");
INSERT INTO bwo_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Maniyere hakonowere bok'alts Ik'i s'aatosh adaro boosh ímeets Ans'okimaants markabon boami. ");
INSERT INTO bwo_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Manok bobodetsok'on amantsuwotsi ikok kakudek't Ik'o awuk'o k'alt bonton wotdek't b́fiints jamonat Ik'i ash woterawwotswor boamanituwok'o awuk'o k'alt fengesho boosh b́k'eshtsok'o bokeewi ");
INSERT INTO bwo_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Manoknowere amantsuwotsnton ay aawo boteshi. ");
INSERT INTO bwo_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ash ik ikuwots Yhuditsere Ans'oki maants amt «Musesh imets nemok'on gofo it amala bako kasho falratste» ett amantsuwotsi daniyo dek'botuwi. ");
INSERT INTO bwo_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","P'awlosnat Bernabasn manjangosh ash ashuwotsnton wed'eyat moosho bomooshi, Maniyere okoon P'awlosnat Bernabasn Ans'okitse fa'e k'osh muk' eshuwotsnton wotde'er Iyerusalemits amr b́jango woshetswotsnat eenashuwotsnsh bot'intsituwok'o woshi. ");
INSERT INTO bwo_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Mansh bo Ik'i moon wosheyat boami, Fink'enat Semaritse bobesheferowere Ik'i ashwoterawwots Ik'o maants boaano bokeewi, keewetsanuwere krstiyani jametsuwotsi b́geneúshi. ");
INSERT INTO bwo_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Iyerusalemits bobodtsok'on Ik'i moowunat woshetswotsn, eenashuwotswere boon bodek'i, wosheetsuwotswere Ik'o bonton wotdek't b́ fintso boosh bokeewi. ");
INSERT INTO bwo_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ernmó Ferisawino eteefuwots jirwotsits wotts ik ik amantsuwots tuut «Ik'i ash woterawwots gofo amr Muse nemo bokotetuwok'o k'alo geyife» boeti. ");
INSERT INTO bwo_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Woshetswotsnat eenashuwotsn keewan shuu'ar s'ilosh kakuwebodek'i, ");
INSERT INTO bwo_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ay moosho mosheyakonowere P'et'ros tuut boosh hank'o bíeti, «Eshuwwotso, Ik'i ash woterawwots taan Doo shishiyo k'ewur boamanituwok'o taan ititse galb́dek'tsok'o danfte. ");
INSERT INTO bwo_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ash nib dantso Izar Izewer, S'ayin shayiro noosh b́imtsok'o booshowere imtni b́ gawi. ");
INSERT INTO bwo_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Bonibo amanon b́ s'ayntstsosh noonat bodagotse eegoru k'osh k'osho woshratse. ");
INSERT INTO bwo_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Eshe, nonihotsi wotowa noo kuro nofalrawu k'ambariyo amantsuwots bimbats kuriyon and Ik'o eegishe itfadiri? ");
INSERT INTO bwo_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Noo nokashit bokok'o doonzo Iyesus s'aaton b́ woto amaniruwone.» ");
INSERT INTO bwo_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Manoor kakuwets ash jamo s'ik ett Bernabasnat P'awlosn boweeron Ik'o Ik' ash woterawwots dagotse b́ fints milikitonat adits keewu jamo bokeewure adt k'ebeyi. ");
INSERT INTO bwo_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Bo keewut boishiyak, Yak'ob hank'o ett bíaniyi «Ti eshuwotso! aab taan k'ewere! ");
INSERT INTO bwo_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ik'o b́ shútson s'eeget ik ikashuwotsi bo dagotse galdek'osh shinshino awuk'o k'alt Ik' ash woterawwotsi waa b́s'iiltsok'o Sim'on keewure. ");
INSERT INTO bwo_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Hasabiyantonuwerfe nebiywots keewuts keewo manee, hank'o ett guut'etsok'one, ");
INSERT INTO bwo_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‹Haniyehak aani weetuwe, Gahtso Dawit moo agetuwe, B́ gahts tiish tishonowere tizde'er aaniy need'ituwe. ");
INSERT INTO bwo_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Hanowere t k'alit oorts ashuwotsnat T shútson s'eegets Ik'i ash Woteraw jamwots Ik'o bogeytuwok'owee, ");
INSERT INTO bwo_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Yootstson jaman danitso Ik'o taa hank'o etiruwe,› ");
INSERT INTO bwo_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«Mansh tiaasabiyo Ik'omaants aanits Ik'i ash woterawwotsi nokic'irawok'owee. ");
INSERT INTO bwo_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Maniyere ‹Woterawu ik'uwotssh t'iintsotse kiimts woshi misho máák'ayere, widatse wokoore, shukeerawonat b́ s'atso b́kud'erawo guuk'at k'irts gizi meetso máák'ayere, s'atsonowere máák'ayere› err boosh guud'one. ");
INSERT INTO bwo_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Yootstson b́ tuutson Muse nemó sanbati aawu jamon ayhudiwots Ik' k'oni mootse nababefe b́teshi, Ik'i keewuts keewonowere kitt kitotse nabefee.» ");
INSERT INTO bwo_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Maniyere hakon woshetswotsnat eenashuwotsn Ik'i maa ash jamonton wotdek't kakuweetsmanotsitse k'ats ashuwotsi marat'dek't P'awlosnat Bernabasnton Ans'okimaants daamiwosh k'ut'bok'ri, Mansh eshuwotsitse jiishon shútsi sheengo detstswotsi Bersabasi eteetso Yhudnat Silasn marat'bodek'i. ");
INSERT INTO bwo_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Guut'ets woshi work'ato bokishon bo damiy, Wosh detsts work'atmanuwere hank'o etka b́tesh, «Noo woshetswotsnat eenash eenashuwots it eshuwots, Ans'okinat Soryon, Kilk'iyitsnowere beyiruwots Ik'i ashwoterawwots jirwotsi wottsuwotssh no eshuwotssh jamo itsh t'intsiruwone. ");
INSERT INTO bwo_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Noyitse ik ik ashuwots noo boon noazazerawon it maants waat itsh bokeewts keewon iti bokic'itsok'onat itn bodanditsok'o shishrone. ");
INSERT INTO bwo_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Mansh ikok ko'enowutsiyakon woshetuwotsi marat'de'er shuneets no eshuu eshuwwots Barenabasnat P'awlosn ton itmaants woshosh no shiyeyi. ");
INSERT INTO bwo_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Barnabasnat P'awlosn doonzo Iyesus Krstos jangosh bo kasho beshidek't imknee. ");
INSERT INTO bwo_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","No guut'tsonowere noonon dabr itsh bo keewituwok'o Yhudnat Silasn wosherone. ");
INSERT INTO bwo_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Itsh not'intsts geyit keewanotsiyere okoon k'osh mang kuro itats nokurirawok'oyish noo S'ayin shayironton sheeng b́wotere daatsrone. ");
INSERT INTO bwo_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Woteraw ik'osh t'intsetsotse kiimts misho maak'ayere, gúúk'at k'irts gizi meetsono maak'ayere, s'atsono maak'ayere, widatsnowere wokoore, jamkeewanotsatse it atso it kotal sheenge itk'aliti, jamon beewere.» ");
INSERT INTO bwo_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Wosheetswotswere deen bok'rere Ans'oki maants boami, amantsuwotsnowere kakudek't wosheets work'atman boosh imbok'ri. ");
INSERT INTO bwo_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Amantswotswere wosheets work'ato bonababor bitsi kúp'its woshmann ayidek' boon b́ geneúshi. ");
INSERT INTO bwo_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yhudnat Silasn nebiyiwotsi boteshtsotse eshu eshuwotsi ay Ik'i keewon izt boon bokup'shi. ");
INSERT INTO bwo_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Yhudnat Silasn muk' aawwotssh manoke boteshiyakon amants eeshuwwotsoke deneyat boon woshtsuwotsok aanat boami. ");
INSERT INTO bwo_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","P'awlosnat Bernabasnowere eshu k'osh ayuwotsnton wotdek' Doonzo keewuts keewo danifets nabfetst muk' aawosh Ans'okitse boteshi. ");
INSERT INTO bwo_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Muk' aawwotsiyere hakon P'awlos Bernabassh «Wowe anaanar haniyere shin doonzo keewts keewo boosh noshishits kit jamwotsitse fa'a eeshuwuwotsi s'iilone, awuk'o bowottsok'onowere danonee» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabasuwere Mark'osi eteetso Yohans bonton towaar bíamo b́ geyi. ");
INSERT INTO bwo_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","P'awlosmó ashman bonton bíametuwok'o eekeratse, eek b́k'aztsonuwere bí P'nfiliyitse boatse k'aleyat b́ oortsonat fino maantsowere bonton amo b́ k'aztsoshe. ");
INSERT INTO bwo_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Manatse tuutson P'awlosnat Bernabas dagotse mooshi eeno b́tuure k'ale bowutsi, mansh Bernabas Mark'osi detsdek't markabon K'op'ros maants k'azbíami. ");
INSERT INTO bwo_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","P'awlosmó Silasi marat'b́dek'i, eeshuwotswere P'awlosi doonzo s'aatosh adaro beshidek't boimiyakon k'azbími. ");
INSERT INTO bwo_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Bíwere Ik'i moowuwotsi kup'ifere Soriyonat Kilk'iyi weeron b́beshi. ");
INSERT INTO bwo_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","P'awlos Derbenat Lst'ra maants bíami, Lst'rn T'imotiwosi eteets amants jawets iko fa'e b́tesh, bínd ayhudiyi ash wotat amank krstiyani btesh, b́ nihmó Grik dats asha b́ tesh. ");
INSERT INTO bwo_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","T'imotiyos Lst'ronat Ik'oniyonitse fa'a eeshuwwotsokere sheeng shútso detsfe b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","P'awlos T'imotiyosi de'er amo b́getsotse manokere beyru ayhudiwotsatse tuutson gofo b́ ametuwok'o b́woshi, mank'o b́ k'aluwere bo T'imotiyos nih Giriki dats ash b́ woto bodantsotse bojangosha etniye. ");
INSERT INTO bwo_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","P'awlosnat Silasn kit kitotse beshefetst Iyerusalemn fa'a woshetswotsnat eenashuwotsn eteets nemo amantsuwotssh bodanifere b́teshi, finatsowere bojitsituwok'o boosh bogawifere bo teshi. ");
INSERT INTO bwo_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Mansh Ik' moowwots imnetiyon kup'bowutsi, botaawonúwere dabfere bí'amiri. ");
INSERT INTO bwo_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","P'awlosnat Silasn Isiyi datsatse Ik'i aap'o bokeewurawok'o S'ayn shayiro boosh b́ bazitsotse Frgyiyinat Gelatiyi daarok k'az bobeshi, ");
INSERT INTO bwo_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misiyi daarok bobodtsok'on Bitanimaants amoosh gawtni botesh, ernmó Iyesusko S'ayin shayro man maants boametuwok'o eekeratse. ");
INSERT INTO bwo_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Mansh Misya weeron beshat T'iroadi bo oot'iye. ");
INSERT INTO bwo_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Manoke t'ú Mek'edoni ash iko need'dek't «Mek'edoni maants kimr noon te'úwe!» ett bín b́ k'onfere bek'on b́bek'i. ");
INSERT INTO bwo_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","P'awlos bek'man b́bek'iyakon manoor Mek'edoni maants amoosh no geyi, Man b́wotuwere Mek'edoni ashuwotsshowere doo shishiyo nodaniyituwok'o Doonzo noon b́ s'eegtsok'o nodani. ");
INSERT INTO bwo_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","T'iroadiyere Markabats keshdek'at kááwon Samtrak'e maants noami, yaats guurok'on Nap'ule maants no ami. ");
INSERT INTO bwo_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Maniyere tuwat Filip'isyosits nobodi, Filip'isyus Mek'edonitse fa'a kit eenunat Rom dats ashuwots dets bodek'ts datsi b tesh, kitmanitsnowere muk' aawwotsi nobeshi. ");
INSERT INTO bwo_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sanbati aawotsowere Ik' k'onosh boko'efok kitoniyere úratse fa'a foki gúrok noo ami, manoke bedek'at ko'edek'ts máátsuwotssh Ik'i aap'o nodaniyi. ");
INSERT INTO bwo_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nokeewirman k'ebiru máátswotsitsere iku Tiyat'ros kitotse shuwetsu tahi biro jaakiru Lidiya eteets máátsu fa'a b teshi, biwere Ik' Ik'iru máátsiye b teshi, doonzo b nibo bish b́ k'eshtsotse P'awlos bíaap'iru b k'ebfere b teshi, ");
INSERT INTO bwo_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Binat b meyitsi fa'a ash jamwots bo gupeyakon, «Doonzo ti amantso arik b́woto itkitsitka wotiyal waar t moots beewere,» etaat kup'idek'at noon b k'oni. ");
INSERT INTO bwo_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ik aawu Ik' k'oneyiruwok noamfere shino maants wotit keewo keewit kim shayiro biyatse fa'a ik'ets Gon baarna'ú weerindatse noon b datsi, Gonmanuwere Ik'o oot'at b doonzotssh ay oot'o b datsifo b teshi. ");
INSERT INTO bwo_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Biwere noonat P'awlosn shuutso shoydek'at sha'at, «Ashaanots een Ik'o gutswotsiye! boowere kash weerindo itsh keewitúnee!» etaat b kuhefooni. ");
INSERT INTO bwo_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Hanoewre ay aawosh aani aani bk'alfoni, P'awlosmó nibok'úúnwutsat wongr et aanat kiimshayirman «Iyesus Krstos shútson biatsotse nkeshetuwok'o neen azazere!» bí eti. Kim sharonuwere manoor k'azb́keshi. ");
INSERT INTO bwo_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bin keezfwotswere b weeron bodatsit oot'o boatse k'ut'b́wtstsok'o bek'bok'rtsok'on P'awlosnat Silasn detsbodek'i, geetsferowere jebomaants dek'amt naashwots shinats t'intsbok'ri. ");
INSERT INTO bwo_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Rom dats naashuwotsokowere dek'wat hank'o boeti, «Ashaanots Ayhudi jírnee, no kitotsnowere dimbro botuziri, ");
INSERT INTO bwo_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Noo Rom dats ashuwots dek'o nofalrawu niwo noosh bodaniyiri.» ");
INSERT INTO bwo_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ashjamonwere ik wotdek't boats b́tuwi. Naash naashuwotsuwere P'awlosnat Silasn taho sholbazt gumbon botogetuwok'o boazazi. ");
INSERT INTO bwo_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ayidek't botogeyi hakon t'ip'moots kindsh bok'iri, tipi maa kotiruwonuwere k'up'ide boon b́kotetuwok'o azazk'reyi, ");
INSERT INTO bwo_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kotiruwo azazetsman b́dek'iyakon, tipi maaman gitsotsi kayuts boon kindsh b́k'ri, botufonowere gindonat gindi dagots detsidek't tipb́k'ri. ");
INSERT INTO bwo_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","T'ú Taali titso maantsowere P'awlosnat Silasn Ik' k'ononat dubon Ik'o údfetstni boteshi, tipeets k'oshuwotswere bóóna bok'ebiri botesh. ");
INSERT INTO bwo_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Gawerawonowere tipimaaman b́ned'oko b́gaahefetsosh een dats shek'eyo wotb́wtsi, fengesh jamwotswere k'eshebowutsi, tipetswotsi boon tipeets habiliyo ik ikon bish b́wutsi. ");
INSERT INTO bwo_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kotiruwonuwere b́tokrootse tuut tipimaa fengesuwots k'eshewutsat boere bek't tipetswots k'azbokeshtsok'o bísh bíarere b́ tooko úd'osh b́shiko kaas'b́dek'i, ");
INSERT INTO bwo_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ernmó P'awlos, «No no únetswor hanok noone! manshe ntokats gondofink'aye!» ett k'aar eenon b́kúhi. ");
INSERT INTO bwo_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Manoor kotiruwo c'eesho de'eweetuwok'o wosht gitsots b́kindi, k'eewufetst P'awlosnat Silasn tufi shirots b́baron gúp'nb́wútsi. ");
INSERT INTO bwo_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Úrats boon kishdekt «T Doonzotso! kashosh eegk'ale taan b́geyiyti?» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bowere «Doonzo Ieyesusn amanowe, kashituwune, nmeyitsi ashuwotswere kashitúne» boeti. ");
INSERT INTO bwo_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Doonzo aap'onowere bínat b́meyitse fa'a jamwotssh bokeewi. ");
INSERT INTO bwo_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","manoori sa'aton t'úwon tipimo kotiruwo dek'amt bogaawo bo atse b́mashi, manoor bínat b́maa ash jamwots bogúpeyi. ");
INSERT INTO bwo_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Maniyere hakon P'awlosnat Silasn b́mook dek'amt misho boosh b́t'intsi, Ik'onowere bí amantsosh b́meyitsi ashuwotsnton geneú b́wutsi. ");
INSERT INTO bwo_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","B́ gatstsok'onowere naash naashuwots «Ash manots faksheewunee» ett polisuwotsi bowoshi. ");
INSERT INTO bwo_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tipi maa kotfonuwere «It it faksheetuwok'o naash naashuwots asho bowoshtsotse eshe keer jeenon ameree» ett Silassh b́keewi. ");
INSERT INTO bwo_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","P'awlosmó «Rom datsi ashnowotefere nayiralon jebatse noon jot't tipimoots noon kindshrnee. Andowere tipi mootse ááshon nokeshetuwok'owe bok'aliri? Woteratse! bo botookon waar noon kishunee!» ett bíaani. ");
INSERT INTO bwo_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Poliswots keewuman naash naashuwotssh bokeewi, naah naashuwotswere P'awlosnat Silasn Rom dats ashuwotsi bowoto bodantsok'on shatbowtsi. ");
INSERT INTO bwo_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Mansh waat naandrone ett aatt tipimootse boon kishbok'ri, kitmanitsnowere boametuwok'o boon bok'oni. ");
INSERT INTO bwo_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","P'awlosnat Silasnowere tipi mootse kesht Lidiy moots bokindi, manoknowere eshu eshuwotsi daatsdek't boon kup'sht kitmanowere faksht k'azbo ami. ");
INSERT INTO bwo_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","P'awlosnat Silasn Anfip'olisnat Ap'olon weeron beshat Teselonk'e maants boami, manoknowere ayhudiwots Ik' k'oni moo fa'ee b́teshi. ");
INSERT INTO bwo_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","P'awlos maniyere shin b́ k'alfok'o ayhudiwots Ik' k'oni moots b́ kindi, keez gawuyiwoshowere b́k'ut'raawon S'ayin mas'aafotse ash ashosh kish kitsfetstni b́ danifo. ");
INSERT INTO bwo_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Krstos gond bek'o de'er k'irotse tuwo bín b́geyituwok'o kitsit danifetst «Taa itsh b́ jangosh doo tshishyiru Iyesus Krstosiye» bíetfera b́tesh. ");
INSERT INTO bwo_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Mann boyitse ik ikuwots b́ aap'o t'iwintsdek't P'awlosnat Silasnton ikbowoti, mank'owere Ik' Ik'iruwotswere aydek't ayts Ik'i ash woterawwots, kitutse daneets ay máátsuwots b́ aap'o t'iwintsdek't bínton ik bowoti. ");
INSERT INTO bwo_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ayhudiwotsmó okoort fay tizitu fin deshawwotsi weer weeratse kakudek't tuuz bok'ri. Kitutse fayo b́tuwitwok'o bo woshi, P'awlosnat Silasn kishde'er ash ashosh imosh Iyason moo guurbodeki. ");
INSERT INTO bwo_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ernmó boon bo t'ut'tsok'oon Iyasonnat amants ik ikuwotsi kitmanitsi naashuwotssh t'intsosh geetsfere dek't boami, hank'o etfetst bokuhiri boteshi, «Hanots datsjamo gaak rne ando hanok waarnee! ");
INSERT INTO bwo_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Iyasonwere boon dek't ibiree, ‹Iyesusi eteets k'osh nugúso fa'ee› ett Rom Naashi Naasho alo bok'efiri.» ");
INSERT INTO bwo_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ash ashonat kitutsi naash naashuwots man boshishtsok'on dimbr bowutsi ");
INSERT INTO bwo_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Iyasonnat k'oshuwotsn wusho s'eegiyit fakshbokri. ");
INSERT INTO bwo_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Eshu eshuwots P'awlosnat Silasn káári t'úwon Bery maants bo amtuwok'o bowoshi, Manok bo bodtsok'on ayhudiyots Ik' k'oni moots bokindi. ");
INSERT INTO bwo_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beriyan fa'a ayhudiyots Teselonk'en fa'wotsiyere bogo kááwu finek boteshtsotse b́ aap'o gene'úwi eenon bodek'i, b́ aap'o ar b́ wotok'o kitsosh aawu aawon S'ayn mas'afotsi bos'ilfoni. ");
INSERT INTO bwo_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Mansh boyitsere ayuwots boamani, ay Grik datsatsi gaaletswots máátswots ay Grik datsatsi nungushuwots boamani. ");
INSERT INTO bwo_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ernmó Teselok'en fa'a ayhudiyots P'awlos Beriyon Ik'i keewuts keewo b́ nabiruwok'o bodantsok'on manoor waat ashuwotsi gondon tizt bowaac'rituwok'o botizi. ");
INSERT INTO bwo_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Manoor eshu eshuwots káári P'awlos aats k'ari ganok b́ ametuwok'o bowoshi Silasnat T'imotiyosnmó manoke Beriyon bo oori. ");
INSERT INTO bwo_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","P'awlosi deents ashuwots Ateni bobetsi «Silasnat T'imotoyosn ja'araniye káári tiyok woonee» etiru P'awlos tzaziyo detsdek't Beriyo maants boaani. ");
INSERT INTO bwo_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","P'awlos Atenon wotdek't Silasnat T'imotiyosn b́ kotfere kitutsere dozets ik'uwots bos'entsok'o b́bek'tsotse ayidek't nibo b́k'uni. ");
INSERT INTO bwo_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Mansh ayhudiyots Ik' k'oni mootse ayhudiyotsnat Ik'osh Ik'iru ashuwotsnton jebatse aawu aawon b́ daatsiru ashuwotsnton b́mooshiri b́tehi. ");
INSERT INTO bwo_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Epikorosotsnat Istokotsi eteets bog danetuwots b́ maants waatni bomooshfoni. Ik ikuwots «Ooshiyiruwan eeg etee b́geyi?» bo etor, k'oshuwotsmó «Handr ik'uwots janga arefee b́ keewiri? boetiri, man boetiruwere P'awlos Iyesusnat k'irotse b́tuwi doo shishi keewi jango b́ danitsoshe. ");
INSERT INTO bwo_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Mansh P'awlosi detsdek't Ariyosfagosi eteets beyokoke kakuwets ash ashok dek'wat bísh hank'o boeti, Nee ndaniyiru handr danan eeg b́wottsok'o dano falituwonowáá? ");
INSERT INTO bwo_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ib wotts ik ik keewwotsi noosh shiyirnee, mansh keewanots eeg bowottsok'o dano geefone.» ");
INSERT INTO bwo_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Man etts Atenitse beyirwotsnat Atenitse beyiru úridatsi ash jamwots handr keewu keewonat k'eboke bogizeyo beshiyo boshunfotsne. ");
INSERT INTO bwo_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Manoor P'awlos Aryosfagosn kakweetswots shinatse need'dek't hank'o bíet, «Ateen ashuwotso! jam weeron ayidek'at ik'uwotsi shatiru itwottsok'o t'iwintsdek'at dandek're, ");
INSERT INTO bwo_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","It kitotse gúúrat ananat it Ik' it ik'irwoko t s'iile ‹Danerawo Izar Izeweri› ett guut'etsoko wosh biyatse t'intseyiru t'arap'ezo daatsre, eshe taa and itsh t keewir it danawo bín it ik'iruwo Izar Izewer jangoniye. ");
INSERT INTO bwo_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Bíye Datsonat datsatse fa'a jamo aztsoniyee, Daronat datsonsh doonze, bíye ash kishon ageets Ik'i moots beerake, ");
INSERT INTO bwo_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Kashonat kash jongon, k'osh keewwotsnowere ash jamosh imfo bí b́wottsotse bísh eegor shaprake, asho bín b́ tep'onowere bísh geyiratse. ");
INSERT INTO bwo_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Bíye ash naar jamone ik ashaatse azree, dats jamatsnowere bo beetuwok'o woshre, tiitsets duruwotsnat beyokuwotsnowere boosh b́ beezi. ");
INSERT INTO bwo_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Man b́ k'aluwere ashuwots doonzo geeyar daatso bofalituwok'owe, b́wotiyalor bí no ik iketsatse woka etaliye. ");
INSERT INTO bwo_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‹Kasho daatsir nogiwit, Noo beetuwere bíne,› Manuwere itk wotts jááwetswots ‹Noo noúnets b́ nana' noone› bo ettsok'onee. ");
INSERT INTO bwo_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Eshe noo b́ nana'a nowotiyakon ‹Ik'o ash danon, hasabiyon awntson wee ambaron wee shútson dozets aroniye bíari› err gawo noosh geyiratse. ");
INSERT INTO bwo_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Eshe ashuwots yoots dúr dáron bok'altso Ik'o kabiraniyere k'az beshere, andomó dats datsatse fa'a ash jamwots naandrone boetetuwok'o azazere, ");
INSERT INTO bwo_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Bí b́marat'ts asho weeron dats jamatse arikon b́angshit aawo beezdek're, hanowere jametsosh daniyidek't b́bek'sh b́marat'ts ashman k'irotse b́tuztsotsnee.» ");
INSERT INTO bwo_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","«K'irotse tuuwa» etiru aap'o boshishtsok'on ik ikuwots bín boaatsni, k'oshuwotsmó «Han jango k'osh aawots nkeewure k'ebetuwonee» boeti. ");
INSERT INTO bwo_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Maniyere hakon P'awlos kakuwets ashuwotsoke kesht k'az bíami, ");
INSERT INTO bwo_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ash ik ikuwotsmó bínton ik wotat boamani, amants ashuwotsitsnowere Aryosfagosn kakuwetsuwotsitso Diyonasyosi eteets ashonat Demarisi eteets mááts ikunu, k'oshuwotswere boyitse fa'ano. ");
INSERT INTO bwo_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Maniyere hakon P'awlos Atenitse tuut K'orontosi bíami, ");
INSERT INTO bwo_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Manoke P'ant'os datsatse shuwek wottso Ak'ili eteetso Ayhudi ash iko b́daatsi, Rom naashi naasho K'elawudiwos Ayhudi jamo Romitse bokeshetuwok'o azazat b́ teshtsotse Ak'il b́ máátsu P'rsk'lntoon It'aaliyitse manoora b́waa, mann P'awlos book amt bonton b́daneyi, ");
INSERT INTO bwo_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","B́fiino ari bokok'o dunkani shipo b́teshtsotse bonton towaat beedek'tn b́fiinefo. ");
INSERT INTO bwo_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sanbati aaw aawonowere ayhudiwots Ik' k'oni mootse datseyar mooyr ayhudiwotsnat Grik dats ashuwots keewman bo dek'etwok'o b́wooshfoni. ");
INSERT INTO bwo_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silasnat T'imotiwosn Mek'odonitse bowatsok'on P'awlos «Iyesusye Mesihyoniye» eton ayhudiwotssh kup'dek't gawefetst daniyoke bíaawu jamo b́beshifoni b́tesh. ");
INSERT INTO bwo_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ernmó bín k'efat boc'ashor b́ tahatsi k'úndo tebatt «Eshe itats angsheyal it took t'afiyonee! taan bítse aateratse, haniyak Ik' ash woterawwotsok k'ay ametuwe!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Mann boatse k'aleyat Titos Iyost'osi eteets asho mook k'azbiami, ashaan Ik'o Ik'if asha b́tesh, b́moonwere ayhudiwots Ik' k'oni mooniyere beshaatni b́tesh. ");
INSERT INTO bwo_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","K'ersp'osi eteefo ayhudiyots Ik' k'oni maa jishiruwo b́meytsi ash jamonton Doonzo bíamani, ay K'orontos ashuwotswere P'awlos b́ keewufere shisht amanat bogúpeyi. ");
INSERT INTO bwo_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Doonzonuwere t'ú bek'on P'awlossh hank'o bíeti, «Shatk'aye, keewwe, s'k etk'aye, ");
INSERT INTO bwo_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Taaye neentonye tfa'oni, kitanitsere ay asho tdetstsotse gondo niyats betsosh falituwo konuworu aaliye.» ");
INSERT INTO bwo_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Mansh P'awlos Ik' aap'o ashuwotssh danifere ik natonat badosh manoke b́teshi. ");
INSERT INTO bwo_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galiyos Akayiya datso altsi wotat b́ naashor ayhudiyots ik wotdek't P'awlosats botuwi, angshituwots shinatso bín dek'amt, ");
INSERT INTO bwo_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","«Ashaan Muse nemo b́ k'efts weratse ashuwots Ik'o bo ik'ituwok'o b́ woshiri!» boeti. ");
INSERT INTO bwo_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","P'awlos boosh aaniyosh k'andek't b́befere Galyos ayhudiwotssh hank'owa bíet, «It Ayhudi jirwotso! itats gondo wee weralo finere wotink'ere it t'intsts s'aamiyo k'amde tk'ebank'oni b́teshi, ");
INSERT INTO bwo_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ernmó aap'uwotsnat shúts jango it nemi jangosha it mooshiri wotiyal man it took kis'e, taa keewanotsats angshosh geeratse.» ");
INSERT INTO bwo_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Hank'o ett moosh mooshiruwoke boon b́kishi. ");
INSERT INTO bwo_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Manoor jamwots ayhudiyots Ik' k'oni maa jishiruwo Sostensn detsdek'et angishiruwots shinatse boojot'i, jaman b́wotefere Galyos kis'odeshatse. ");
INSERT INTO bwo_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","P'awlos eshuwotsnton ay aawosh K'orontosi b́teshiyakon jamiyere Soriyo maants bíami, P'irsk'lnat Ak'iln bíntoni boteshi, ernmó wosho b́detstsotse bíamoniyere shinon Knkiriya eteyiru datsatse b́tooko b́ s'ageyi. ");
INSERT INTO bwo_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Efesoni bobodtsok'ono P'rsk'lonat Ak'ilon manoke oori bok'ri, bímó Ayhudi Ik' k'oni moots kindt ayhudiyotssh keewo b́ keewufoni. ");
INSERT INTO bwo_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ay aawosh bonton b́teshetuwok'o bok'oniyalor eekeratse. ");
INSERT INTO bwo_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ernmó «Ik'o bí eteetka wotiyal k'oshoor itok aanarr weetuwe» etk'raat Efesonitsere markabots kinddek't k'azbíami. ");
INSERT INTO bwo_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","K'isarimaantsowere b́bodtsok'on maniyere Iyerusalem maants kesht Ik'i meyitsi ashuwotssh jamo b́ t'intsiyakon aanat Ans'okiyi maants k'az b́ oot'i. ");
INSERT INTO bwo_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Manoknowere muk'i b́teshi, maniyere hakon Gelatiynat Frgiy datsatse ikoke tuut ikok gúúrefetst amantsuwotsi b́ kup'iyi. ");
INSERT INTO bwo_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Iskndri datsatse shuwetso Ap'losi eteets Ayhudi asho Efesoni b́weyi, bí S'ayin mas'aafwotsi t'iwintsdek't dankoonat noon keewonowere sheengshdek't keewo falk asha b́tesh. ");
INSERT INTO bwo_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Doonzo weerindi jangonowere dandek't S'ayin shayronowere aat'k wotat Iyesus jangonowere kaatsdek' nabfetst b́danifoni, wotowa eree bí b́danfo Yohans gupo s'uzi b́tesh. ");
INSERT INTO bwo_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Bí ááwushuk'on ayhudiwots Ik' k'oni mootse keewo dek't b́tuwi, ernmó P'rsk'ilnat Ak'iln b́ keewiruwo boshishtsok'on bo gal dek'amt Ik'i weero baltsoniyere bogo kaatsdek bitsdek't bísh bokitsi. ");
INSERT INTO bwo_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ap'los Akayiyo maants amoosh b́gawtsok'oon eshuwots b́keewuman botep'i, Akayiyitse fa'a eshuwots bí sheengon de'er boibituwok'o work'atats guut'ets wosho woshbok'ri, manok b́bodtsok'oonowere Ik'i s'aaton amantsuwotsi wotosh bodtswotsi ayidek' b́ tep'i. ");
INSERT INTO bwo_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Iyesus Mesihiyo b́wotsok'o S'ain mas'afwotsitse Ik' aap'o biitsdek' keewut kup'ts mooshon ayhudiwotsi b́ da'afoni. ");
INSERT INTO bwo_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ap'los K'orontositse b́teshor P'awlos danbani datson beshat Efeson maants b́bodi, manokno muk' Krstaniyotsi daatsdek't ");
INSERT INTO bwo_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","«It amanor S'ayn shayiro dek'rteya b́teshi?» ett bíaati. Bowere «De'atsone, S'ayn shayiro b́beyonoru dab shish danaak noone» ett bo aani. ");
INSERT INTO bwo_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","P'awlosu «Eshe aawu naari gúpe it gúpetsoni?» bí eti. Bowere «Yohanis gúponiye» boeti. ");
INSERT INTO bwo_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","P'awloswere «Yohans guponiyere naandrone etosh k'aleke, ash ashosh b́keewutsonuwere ‹Taayere il wetuwonee amanore› etfetstni b́tesh, bíwere Iyesusiye» etreboosha. ");
INSERT INTO bwo_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Man boshishtsok'on Doonzo Iyesus shútson bogupeyi. ");
INSERT INTO bwo_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","P'awlosu b́ kisho boats b́gedor S'ayin shayiro boats b́ od'eehandr noon keewon bokeeweyi, bek'ono keewo dek'tbotuwi. ");
INSERT INTO bwo_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ash jamwotswere tatse gitne boteshi. ");
INSERT INTO bwo_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","P'awlos ayhudiyots Ik' k'oni mook amt keez shashok'owosh Ik' mengst jangosh mooshfetst ash ashuwotssh kish keewut ááwu shuk'ona b́ danifoni. ");
INSERT INTO bwo_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ik ikuwotsmó maac' kup'o wotat doonzo weerindo ashuwots shinatse c'ashfetst amaneratsone boettsosh boatse k'azb́woki, amantsuwots boaali T'iranosi eteef maa eenok dek'amt aawu aawon boon b́danifoni. ");
INSERT INTO bwo_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","P'awlos hank'o b́k'al git natok'osha, manoor Isiy datsatse beyiru ayhudiyotsnat Ik' ashwoterawwotsn doonzo aap'o shisho bofali. ");
INSERT INTO bwo_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ik'o ayidek't adits keewu wotts milikituwotsi P'awlos kishon b́finefoni. ");
INSERT INTO bwo_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Manatse tuutson P'awlos atsats bodts tahonat marabon dek'amt shodetsuwotsats bobetsor boshodotse bokashefoni, kim shayirwotswere boyitse bokeshfoni. ");
INSERT INTO bwo_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Fo'erawono ashaatse kishfetst ikoke tuut ikok guuriru Ayhudi ik ikuwots «P'awlos b́ nabiruwo doonzo Iyesus shútson it kesheetuwok'o iti azazerone» eton fo'erawo ashaatse kishosh bo etfoni. ");
INSERT INTO bwo_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ayhudiwots kahinwotsatsi naasho wottso Ask'ewu nana'a shawatuwotswere mank'owa bok'alfo. ");
INSERT INTO bwo_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ernmó kim shayiro «Iyesusi danfee! P'awlosnor danfee! Eshe it konots itne?» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Kim shayiro bíatse s'eents ash ikonwere t'oolat gúúk' dek'on boats b́kup'i, bonowere da'ab́dek'i, gaawutnuwere araatswtsaat meyitse giifat bokeshi. ");
INSERT INTO bwo_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Keewumanuwere Efesonitse beyiru ayhudiwotsnat Ik' ash woterawotsoke b́ shishetsotse jametso shatb́wtsi, Doonzo Iyesus shútsonowere ayi eenb́wutsi. ");
INSERT INTO bwo_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Amantsuwotsitse ayuwotsuwere bogond fino kish keewut naandrone err bowaafoni. ");
INSERT INTO bwo_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Atetswotswere bodaniyi mas'aafwotsi kakudek't ash ashi shinatse mitsbok'ri, mas'afmanoots k'awuntsonuwere taanere balk'ats kum ambari katso wotatni b́daatsiyi. ");
INSERT INTO bwo_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Mank'oon doonzo keewo ayidek't gawunfetst da'afera bí amfo b́teshi. ");
INSERT INTO bwo_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Jaman b́wotiyakon P'awlos Mek'edonitsnat Akayiyiweeron beshat Iyerusalem maants amoosh b́gitsoon gawuk'rat «Manok t bodiyakon Rom maants amo taash geyife» bíetí. ");
INSERT INTO bwo_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Mann Ik'i fino finiru ashuwotsitse gitetsuwotsi, T'imotiwosnat Erast'osn Mek'edoni maants woshat bí b́tookon Isiyi datsatse muk' aawosh b́teshi. ");
INSERT INTO bwo_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Manoor doonzo weeri jangosh Efesonitse dimbiro tuub́wtsi. ");
INSERT INTO bwo_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Dimet'rosi eteef ambaar wos'if iko Art'emisn ik' maa aro ambaron doozt ambaar wos'iyiruwotssh ay oot'o b́daatsifoni. ");
INSERT INTO bwo_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Mansh ashaan ambaar wos'iyiruwotsnat bo fini naari fin detsts k'osh ashuwtsi kakudek't boosh hank'o bí eti «It ashuwotso! Noo gaalo nodaatsir finan finat b́wottsok'o danfte, ");
INSERT INTO bwo_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","P'awlosan ‹Ash kishon dozets aranots Izar Izewerotsiyaliye› ett Efeson s'uzitse b́woterawo muk' datsuniyere okoon Isiyi dats jamatse awuk'o ayts ashonton keweek'rat bí amanitsok'o it it tookon bek'aat it shishtsoniye. ");
INSERT INTO bwo_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Eshe hank'on nofino b́ gac'ewoniye, manmec'ro b́woterawon Isiyotsnat dats jamatse ash jamo bin b́ ik'yiru een izar izewer Art'emis Ik'i moo dats baashon b́ ooroniye, bi een wotonwere b́wonewoniyee.» ");
INSERT INTO bwo_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ashuwotswere man boshishtsk'on fayat, «Efesontsu Art'emisiye eeniye!» etfetst bokuhi. ");
INSERT INTO bwo_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kitunuwere jamon shek'e bwutsi, ashuwotswere Mek'odoni datsatse shuwets P'awlosnton tohaat sha'iru b́ tooh gituwots Gayyosnat Arst'rokosn detsdek't geetsfere ash ashuwots bokoeyiruwok bowos'i. ");
INSERT INTO bwo_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","P'awloswere ashuwotsok amoosh geyatni b́tesh, b́ danifuwotsmó bíamawok'o bobazi. ");
INSERT INTO bwo_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Isiy datsatsi naashuwotsitswere b́shuntsuwotsitsi ik ikuwotsi P'awlosok asho woshat «Ashuwots ko'eyiruwok amr n be'erawok'owa» ett bok'oni. ");
INSERT INTO bwo_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ashuwots dagotse wac'ro b́teshtsotse aywots eegosh bokoetsok'o dab danatsno b́teshi, man jangosh iko ik keewo keewt b́kuheere k'oshonuwere k'osh keewo keewut b́kuhiri. ");
INSERT INTO bwo_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ik ik Ayhudi jirwots Iskndiri eteets asho ash dagotsere gifnidek't shinats bot'ntsi, ashuwotsitse ik ikuwots sheengshde'ere b́moshetuwok'o boizi, Iskendiruwere ashuwots s'k boetetuwok'o b́kishon kitst bín kishit keewosh k'anb́dek'i. ");
INSERT INTO bwo_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ernmó Iskendr Ayhudi b́wotok'o ash jamwots bodantsok'on «Efesontsu Art'emis eeniye!» et fetst git sa'atok'osh ik k'aaron bokuhi. ");
INSERT INTO bwo_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","B́s'uwatse kitutsi guut'f naash eeno, ash asho s'k boaayituwok'o wosht hank'o bíeti, «It Efeson ashuwotso! Efeson kitutse beyiruwots, eenu Art'emis ik' moonat darotse oot'ts bí'aro bokotetuwok'owo jametsuwotsoke daneke. ");
INSERT INTO bwo_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Han haalitwo konuwor bíaaltsotse s'k it eteetuwok'o, kááronowere gond keewo k'aloniyere it atso kor itdek'tuwok'o geyife. ");
INSERT INTO bwo_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ik'i moo c'ayawotsnat noko Izar Izeweri c'ayawu gond keewono keewuraw ashuwotsi hanok dek'at waartee. ");
INSERT INTO bwo_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Dimet'rosnat bínton fa'a k'is' k'is'fuwotsi s'aamiru asho b́beyalowere angsh imet aawwots fa'ane, naashuwotsuwere fa'ane, manoke mooynee. ");
INSERT INTO bwo_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","K'osho it geyiru keewo b́beyaalmó nemon k'oorosh beyiruwotsn s'iiletuwe. ");
INSERT INTO bwo_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Maniyere okoonmó hambets k'aleets keewo ‹Dimbiro tuuzre› err no s'aamirawok'owa shatituwe, ‹Baad'eyan eegatsneya b́tuwi› err noon aatewor no aaniyituwo deshatsone» ");
INSERT INTO bwo_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Manowere ett kakuwets ashuwots bobad'ituwok'o b́woshi. ");
INSERT INTO bwo_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Dimbro b́ neediyakon P'awlos amantsuwotsi ikok s'eegt izon boon b́kup'iyi, boon jamik'ratnuwere Mek'edoni eteets datso maantsan bíami. ");
INSERT INTO bwo_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","B́ beshiru datsmanotsatsno amantsuwotsi ay izon kup'ifere Grik datso maants bíami. ");
INSERT INTO bwo_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Manokno keez shasho b́ teshi, maniyere hakon markabon Soriy datso maats amoosh b́gawi, ayhudiyitsmó bín fayosh botutsok'o b́dantsotse Mek'edoni weeron anoosh k'ut'b́dek'i. ");
INSERT INTO bwo_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","P'irhus naay Sop'at'ros Beriyotse, Arst'rokosnat Sikondusn Teselonk'en, Gayyosn Derben, T'imotiwos, Tikik'osnat T'rofimosn Isiyon bínton tohaat boami. ");
INSERT INTO bwo_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Bowere shin shino amt T'iroadn noon bokoti. ");
INSERT INTO bwo_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Noomó tush meyet baalio b́ beshiyakon Filp'isyusitse Markabats keshat úúts aawon bo bobeyiruwok T'iro'adayits bodat bíyokere shawat aawo nobeshyi. ");
INSERT INTO bwo_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Torbanotsere shnts aawots misho tishde'er iknon moowosh nokakweyi, P'awlos yats gúrok'on bíametwootse ko'ets ashuwotssh b́ keewiri, b́ keewono talitiitso b́borfetso b́geezi. ");
INSERT INTO bwo_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","No no ko'ets dadratse ay c'eesho fa'e b́teshi. ");
INSERT INTO bwo_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ewut'ek'isi eteets jawets na'iko meskotiyatse beedek'tniye b́ teshi, P'awlos b́ keewo b́ geezitsotse jawetsman tokri eeno detsb́dek'i, tokro bín b́ datsotse keezl dadratsere dashan b́dihi, ashuwots bok'awere k'irt b́datseyi. ");
INSERT INTO bwo_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ernmó P'awlos oot't na'ats tuumt matdek't «And kashone b́ fa'oni bíeti, tek'k'ayere!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","P'awlos dadrats aani kesh waat misho tiitsdek't amantsuwotsnton b́meyi, datso b́gatsfetsosh ashuwotsnton keewefetst b́teshiyakon k'azbíami. ");
INSERT INTO bwo_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ashuwotswere kashts jawetso moots dek'boami, mannowere ayidek't kup'bowutsi. ");
INSERT INTO bwo_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","P'awlosi markabots kindshosh nogawutsatse noo shinat markabots Asosits noami, man nok'aluwere P'awlos Asosits b́borfetso b́ tufoon amoosh bí ettsosh hank'o no k'alituwok'o noon b́ azaztsotsne. ");
INSERT INTO bwo_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Bínton Asositse nogonkewor markabots bín kindshdek' milit'its maants towaat noami. ");
INSERT INTO bwo_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Yaats guurok'on manoke tuwat Kiyositse shinatse fa'a datsuwats markabon amnobodi, yaatsok'o Samos maants kimaat yaats guurok'on Milit'iyits amnobodi. ");
INSERT INTO bwo_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","P'awlos Isiyotse t teyawok'wa ett Efesoniyere beshat k'ay amo b́ geyi, man b́ k'aluwere P'ent'ek'ost'yi baaliyo Iyerusalemitse daatseyo gawut b́teshtsotsna b́tesh. ");
INSERT INTO bwo_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","P'awlos Milit'itsere Efeson maants asho woshat Ik'i maa eenashuwotsi b́ s'eegiyi, ");
INSERT INTO bwo_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Bíyok bowatsok'on boosh hank'o bíeti, «Isiyots tkindts aawotstson tuut jam aawo itnton awuk'o tbeetsok'o itwoor danfte, ");
INSERT INTO bwo_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ayhudiwots tiats bo malts k'od'atse tuutson gondbek'o tiats b́bodaloru ttooko dashan detsonat eeponee doonzo fino t finefoni. ");
INSERT INTO bwo_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Jebatsnowere it maa mootsnowere itsh tdaniyor itsh t'ak'amitu jamoni tkeewi bako eegoru itsh t shapitso aaliye. ");
INSERT INTO bwo_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ayhudiyotsi wotowa Ik' ash woterawwots naandrone err Ik'o maants bo aanituwok'o doonzo Iyesus Krstosi bo amanituwok'oye b́gawi. ");
INSERT INTO bwo_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Andoor bíyok tbodor tiyats bodetwo eeg b́wto t dartsotse s'ayn shayirosh aleyat Eyerusalem maats ti amoniye. ");
INSERT INTO bwo_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Wotowa eree kit kitotse tipewonat gond bek'on taan b́kotiruwok'o S'ayin shayiro taash keewure. ");
INSERT INTO bwo_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Doo shishi keewo Ik' s'aaton daniyosh doonzo Iyesusoke t k'aaútdek'ts fino tishink'ere t kashi jango k'awuntsots gerawunk'e, t kashoshowere kis'o deshawnk'e. ");
INSERT INTO bwo_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Andish b́borfetso it jamets dagotse ananat Ik'i mengsti jango t nabiri, haniyere okonomó ititsere konuworu t shiitso b́ jamon b́ be'awok'o danfee. ");
INSERT INTO bwo_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mansh ititsere ikdonzworu b́t'afiyal b́ s'atsotse taan aaterawok'o hambets aawon itsh danirwe. ");
INSERT INTO bwo_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ik'o bí'asabts jamo itsh keewuni tishi bako eegoru t oorits keewo aaliye. ");
INSERT INTO bwo_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","S'ayn shayiro jintswotsi woshdek't iti naashire, eshe it tokonat it jiniru gizi s'eeni jangosh it atso korde'ere, Ik'o b́ naay s'atson keewudeb́k'ts Ik'i moo korere. ");
INSERT INTO bwo_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Taa ti amiyakon gizi s'eenosh máác' k'ewerawo elahok'o maac' kup' wotts ashuwots bits bokindituwok'o danfee. ");
INSERT INTO bwo_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Mank'owore ash ik ikwots ititse tuur k'úúr daniyo daniyir ayi amantsuwotsi bomaants geetsitune. ");
INSERT INTO bwo_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Eshe it ik iketsi keez natosh t'úwonat aawon ti aac'uwo kuut'fetsat itn ti'iztsok'o gawufetsr itatso korde'ere. ");
INSERT INTO bwo_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Andoor iti kup'shr S'ayinwots dagotse rstiyo imosh falitu b́s'aati aap'onshowere adaro iti imre. ");
INSERT INTO bwo_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Taa kon ambaaronowere, awntsonowere wee taho tewunratse. ");
INSERT INTO bwo_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","T took kishon finefetsat ttooko wotowa ttohuwotsi t tep'fok'o it tookon danfte. ");
INSERT INTO bwo_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","‹Dek'iruwoniyere bogo imiruwo deereke› etiru doonzo Iyesus aap'tso gawufetsr, nokishon angmaawtswotsi tep'o noosh b́ geyituwok'o ay weerindon itsh kitsre.» ");
INSERT INTO bwo_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Maniyere hakon P'awlos jametsuwotsnton tuk'maldek't Ik'o b́k'oni. ");
INSERT INTO bwo_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Jametsuwots eept P'awlosi matdek't bojoobi. ");
INSERT INTO bwo_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Dabtnu aydek't shiyanatnuwere, «Haniyak tshitso be'atste» boosh bí'ettsatse tuutsone, Markabok b́ borfetsosho bín bodeni. ");
INSERT INTO bwo_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Boo'atse nok'aleyakon Markabats keshdek'at kawon K'osi eteets ats k'aron gúrts datsuk noami, yats gúúrok'on Rúdi eteets ats k'aron gúrts datsuk nobodi, manokno P'at'ray eteets kitots no'ami. ");
INSERT INTO bwo_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Manokno Fink'e datso maants amiru Markabu daatsat bíyats keshdek'at sha'osh notuwi. ");
INSERT INTO bwo_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","K'op'ros aats k'aron gúrts datsu nogiro maants k'azk'rat Sori datso maants amaat Tiros aats k'ari gúroki datsuk no'ami, markabunwere bkuro manok orsho bín geyfe bteshi. ");
INSERT INTO bwo_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Manokere amantsuwotsi geeyat nodatsiyakon bonton shawat aawosh manoke noteshi. Bowere S'ayn shayiron jisheyat P'awlossh «Iyerusalem maants amk'aye» ett bokeewi. ");
INSERT INTO bwo_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Manoke no ja'ats aawman b́ s'uwutsok'on boatse k'aleyat sha'o notuwi, jametsuwotsuwere bomááts máátsonat bonana'uwotsnton wotat kitoniyere nokeshfetso noon bodeni, aats k'ari gúrats tuk'maldek'at Ik'o no k'oniyakon nok'aleyi. ");
INSERT INTO bwo_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","No jamiyakon no markabots no nokindre bo bomoo maants k'az bo aani. ");
INSERT INTO bwo_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","T'rositse tuwat P'et'elemays maants nobodi, manokno amantsuwotsnton gonkeyat jamo no'ateyakon bonton ik aawo nojini. ");
INSERT INTO bwo_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Yaats guurok'on manokere keshat K'isariyo maants no'ami, bíyokno shawat Dak'oniyotsitsere ik wottso doo shishiyo nabiruwo Filp'os meyits kindat bínton nobeyi. ");
INSERT INTO bwo_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Bíwere bek'on keewo boosh imets awd baar nana'a mááts amawwotsi detsfe b́teshi. ");
INSERT INTO bwo_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ay aawosh manokere nobemanoor Agabosi eteets Nebiyo Yhud datsatse b́weyi. ");
INSERT INTO bwo_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nebiyanuwere nook t'int, P'awlos edo k'aaúdek't b́ took kishonat b́tufuwotsi tipt «S'ayin shayiro eedan doonzi Iyerusalemn fa'a ayhudiyots hank'o tifde'er Ik' ash woterawwotssh beshide'er imetune etfe» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Man noshishtsok'on noowere manoke fa'a ashuwotswere P'awlos Iyerusalem maants bíamawok'o nok'oni. ");
INSERT INTO bwo_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","P'awlosmó «Hank'o eepat eegishe tnibo shiyanon it tiitsiri? Taa doonzo Iyesus shúts jangosh Iyerusalemitse tipee mec'r b́woterawo k'irosh k'andek'ktaane» ett bíaani. ");
INSERT INTO bwo_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Bo izono de'atse bíere «Beree doonzo bíettsok'o wotowe» etaat k'aznok'iri. ");
INSERT INTO bwo_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Manokno muk' aawwotssh noteshiyakon nok'ac'o k'anidek'at Iyerusalem maants noami. ");
INSERT INTO bwo_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","K'isariyitse fa'a amants ik ikuwots noonton tohaat boweyi, boowere Mnason meyts nokashdek'etwok'o b́moo maants noon bojishi, ashaamanwere shini amantso K'op'ros datsatse shuweke b́teshi. ");
INSERT INTO bwo_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Iyerusalemits nobodtsok'on amantsuwots geneúwon noon bodek'i. ");
INSERT INTO bwo_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Yaats guurok'on P'awlos noonton Yak'obok bíami, Ik'i maa eenash jamwots manokna botesh. ");
INSERT INTO bwo_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","P'awlos jametsuwotsi jamo b́aatiyakon b́weeron Ik'o Ik' ashwoteraw ashuwotsitse b́k'alts jamo ik ikon b́ keewi. ");
INSERT INTO bwo_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Man boshishtsok'on jametsuwots doonzo boúdi, P'awlosshowere hank'o boeti, «Eshuwonoo! ay kumon taawetu amantsuwots ayhudiwotsitse bo beyiruwok'onat jametsuwotswor bo nemosh okooretsuwotsi bowottsok'o danfnee, ");
INSERT INTO bwo_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Nee Ik' ash Woteraw ashuwotsitse beyiru ayhudiyi jamwotssh ‹It nanaúwotsi gofo damik'ayere wee nemok'o fink'ayere› etaat daniyat Muse nemo b́ gahituwok'o nk'aliri ett keeweyirwo bo shishrne. ");
INSERT INTO bwo_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Eshe eeg k'ale b́ geyiyiti? n woono arikon shishrne, ");
INSERT INTO bwo_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Eshe no no'etetuwo k'aluwe, noyitse wosho detsts awd ashuwots fa'ane. ");
INSERT INTO bwo_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Boon de'amr bonton wotar ntooko s'ayintsuwe, botook s'iiro bos'agetuwok'o Ik' moosho imet mebi gizono nee boosh daye, hank'o n k'aliyal níats keewets jamo k'awuntsalk b́wottsok'onat neewere n tookon Muse nemosh alek nwottsok'o jametsuwots danetunee. ");
INSERT INTO bwo_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ik' ashwoterawwots jirwotsitse amantsuwotsmó Woteraw ik'osh b́ t'intsotse kiimts woshi misho maak'ayere, s'atsonowere maak'ayere, guuk'at k'irts gizi meetso maak'ayere, widats wokoore ett guutt'eets keewu detsts woshi work'ato guut'dek'at itsh wosherone.» ");
INSERT INTO bwo_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Maniyere hakon P'awlos ashuwotsi dek'amt yaats guurok'on b́tooko b́s'ayintsi, bos'ayinet aawwots awur bo s'uwitwok'onat ik ikuwots jangoshowere Ik'osh imet mabi gizo b́ dashet gizwo awur b́wottsok'o daniyosh Ik'i moots b́kindi. ");
INSERT INTO bwo_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Shawt aawu manu beshosh b́t'intsk'on Isiyon waats ayhudiyots P'awlosi Ik'i mootse bobek'tsosh ash jamo bíyats tizt bín bodetsi, ");
INSERT INTO bwo_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","«Israe'el ashuwotso! noosh gaatsowere! no ashonat no nemon, beyokanowere c'ashfetst dats datsatsi ash jamonowere daniruwo ashaaniye, hanuwere boratse ett Ik' ash woteraw ashuwotsi Ik' moots kindsht s'ayin beyokan k'imhsre!» ett bokuhi. ");
INSERT INTO bwo_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Hano boetuwere maniyere shin Efesonn shuwetso T'rofimos bínton kitotse bek't boteshtsoosh P'awlos bín Ik' moots dek't b́kindtsok'o boosh bíarernee. ");
INSERT INTO bwo_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kit jamunwere dimbir bwutsi, ash jamonuwere wos'fere ikwotdek't waat P'awlosi detsdek't geetsfere Ik'i mootse bokishi, Ik'i maa fengeshuwotswere iknun is'ebowutsi. ");
INSERT INTO bwo_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ashuwots P'awlosi úd'osh bogeetsok'on «Iyerusalem kitu bjamoon dimbir bwutsi» etiru wosho Rom datsatsi kes' naashok b́bodi. ");
INSERT INTO bwo_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Mansh bí kes'fuwotsnat bali naashuwotsi b́shuutsats jishdek't ashuwots maants kaari wos'fere bíami. Ashuwotswere kes'fuwotsnat boon jishiruwon bobek'tsok'on P'awlosi jot'o k'azbok'iri. ");
INSERT INTO bwo_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Jishiruwonuwere P'awlosok t'int detsdek't git habliyon b́tipetuwok'o bíazazi, maniyere hakon koni b́wottsok'onat eeg b́k'altsok'owo danosh geeyat bíaati. ");
INSERT INTO bwo_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ash ashonwere ik ikwots ik keewo boere k'oshuwotsuwere k'osh keewa boetfera botesh, azazirumanwere ash ash kuhatse tuutson ari keewo dano b́maawtsotse P'awlosi kes' kes'fuwots kot bokotiru gimbiyok de'er boametuwok'o bí azazi. ");
INSERT INTO bwo_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","P'awlos bíyats need'dek' dambaan kesheyirwok b́bodtsok'on ash jamo ayidek't b́faytsatse tuutson gondo biats betsosh bogeyiruwosh kes' kes'fuwots bín kurdek't k'azboami. ");
INSERT INTO bwo_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ash ashonwere «Bín úd'ewe» etfere b́shuutso bosha'i. ");
INSERT INTO bwo_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kes' kes'fuwots bo koti gimbiyok bín kindshosh bot'intsok'on P'awlos kes'iruwots abaatse alirwoh «Ik keewo neesh t keewituwok'o eekituneya taasha?» bí eti. Altsmanuwere «Grik dats noon keewu keewo danfiya? bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Eshe, and karnon fayo tizat awd kum kash úd'tswotsi woruwo maants dek't t'afts Gbs' asho nenalneya?» ");
INSERT INTO bwo_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","P'awloswere «Taa Kilk'iyitse fa'a daneek wotts T'erses kitutse shuwets Ayhudi ash taane, oona neesha ashuwotssh t keewituwok'o taash eekowe» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","B́ keewituwok'o b́ ektsok'on P'awlos bíyatsneedeyiruwats need'dek't ash ashuwots s'ik boetetuwok'o b́kali, ash asho s'ik boettsok'on Ibrayist'iyi noon keewon hank'o ett keewo dek'btuwi. ");
INSERT INTO bwo_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Ti eeshuwotsnat tnihotso! eshe and itsh tt'intsiru aani tdek'etuwo tiko k'ewere!» ");
INSERT INTO bwo_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ibrayist'i noon keewu keewon b́ keewufere boshishtsok'on iki s'k etbowtsi, P'awloswere b́keewiru keewo b́ need'irawo hank'o bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Taa Kilk'iyitse daatseyiru T'erses kitotse shuwets ayhudiwi taane, tieenmó Iyerusalem Kitmanitsne. Taan danifonuwere Gemalyailiye b́teshi, nih nihwots nemono shengshdek'at danre, hambets it k'aliruwank'o Ik'osh ookorona tfinefoni. ");
INSERT INTO bwo_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Krstni imneti shuuts sha'iryiru jamwotsi k'irosh borfetso t gishfoni, nungushuwotsnat máátsuwotsn tifde'er tipi moots bokindituwok'o twoshfoni. ");
INSERT INTO bwo_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Manuwere ar b́wottsok'o kahni naashonat eenashuwots taash gawitune. Eshe Demask'on fa'a ashaanotsi tifde'er Iyerusalem maants dewar boon Seziyosh taan falituwo Demask'on fa'a jirwotsoke guut'ets worek'ato tdek'iye boowokne. ");
INSERT INTO bwo_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Taa Demask'o maants amfetsat kituk tt'infere aawu taalon t gawuraniyere een shááno darotse t gúratse b́goli. ");
INSERT INTO bwo_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Manoor dattsats dihi twutsi, ‹Sawulo! Sawulo! eegishe taan ngishiri?› etiru k'aaro tshshi. ");
INSERT INTO bwo_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Taawere ‹Doonzono! kone nee?› t eti, bíwere ‹Taahe nee ngishiruwo Nazrettso Iyesus taane› bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Taanton beyiru ashuwotswere shaanmani bobek'i bako taan b́keewiyor b́k'aaro shiyatsne. ");
INSERT INTO bwo_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Taawere ‹Doonzono! eeg k'aluta!› t eti. Doonzonuwere ‹Tuur Demask'o maants amee, k'alo neen b́geyit keewu jamo manoke neesh keewetuwe› bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Shanman goltsatse tuutson bek'o tfalrawotse taanton teshts ashuwots tkisho detsdek't taan jishfere Demask'oyi bobetsi. ");
INSERT INTO bwo_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Manoke Hananiy eteef ash iko fa'e b́teshi, Demask'oyitse beyiru Ayhudi jamwotsoke udetso, Muse nemo kottsonat shayiri ashe b́teshi. ");
INSERT INTO bwo_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Bí waat t ganok need' dek't ‹Tieshu Sawulo! ni'aawo aani be'e!› taash bíeti, manorun tiaawo b́ bek'i, bínowere tbek'i. ");
INSERT INTO bwo_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Bíwere hank'o taash bíeti, ‹Nonihotsko Izar Izeweriye bíettso ndanetuwok'o kááwono be'er b́k'aronowere nshishetwok'o shin shino neen marat'ere, ");
INSERT INTO bwo_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Man b́k'aluwere bín bek'aat nshishtsotse ash jami shinatse bísh gawu nwotishe. ");
INSERT INTO bwo_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Eshe and eebi nkotiri? tuur b́shútso s'eer gúpeyowe, nmorratsnowere mashowe.› ");
INSERT INTO bwo_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Maniyerehakon Iyerusalem maants aanat Ik'i mootse Ik'o tk'onfere tgitsotse t'iwintson bek'o tbek'i. ");
INSERT INTO bwo_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Doonzonwere taash be'eyat ‹Nee t jangosh n imet gawo bode'awotse nja'arawo káári Iyerusalemitse kee› bí eti ");
INSERT INTO bwo_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Taawere hank'o tieti, ‹Doonzono! Ayhudi Ik' k'oni maa mootse neen amants jamwotsi t tiptsok'onat tjot'tsok'o bo botookon danfnee. ");
INSERT INTO bwo_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","N gawu teshtso Ist'ifanos úd'ewor taawere ttookon úd'iruwots ganok need'dek'at bonton keewumanats shiyeyatniye tteshi, botaahono tekotfere b́teshi,› ");
INSERT INTO bwo_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Doonzonuwere ‹Wokooke fa'a Ik' ash Woteraw ashuwotsok neen twoshitwotse tuur amee!› bí eti.» ");
INSERT INTO bwo_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Han b́ borfetsosh ash jamwots P'awlos keewiru keewo bok'ebfere boteshi, maniyre hakon bok'aaro eenshdek't, «Hank'o ashaan datsatse t'afuwe! hank'o ashaan kashon beyo bísh geyiratse!» ett bokuhi. ");
INSERT INTO bwo_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Bowere kuhefetst botaho shap'fetst shawono darots bobad'ri. ");
INSERT INTO bwo_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Altsonuwere man b́bek'tsok'on P'awlosi kes' kes'fuwots galots bokindshituwok'o bíazazi, ash ashonwere eegosh hank'o bíats bokúhiruwok'o danosh jod'fetsr aatetuwok'o bíazazi. ");
INSERT INTO bwo_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ernmó shaak'on tifde'er jot'osh bok'anefere P'awlos b́ganoke need'iru bali naashosh «Rom dats ash iko tafiyalo njot'etuwok'o neesh faletuwá?» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Bali naashonuwere han b́shishtsok'on alirwok amt «Eeg k'alishe? Ashaan Rom datsi ashe!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Mansh alirwo P'awlos maants t'int «Ab taash keewwe, nee Rom datsatsi ashneneya?» bíeti, bíwere «Ee taane» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Azazefonuwere «Rom dats ashok'o taaweyosh ay gize tkishi» bíet, P'awloswere «Taayere Rom dats asho woto tdaats shuweyonee» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Mansh bín aatosh k'andek't teshts ashuwots manoor bíyatse k'azbowoki, azazirwonuwere Rom dats asho habliyon b́tipo danb́k'rtsok'on shatb́wtsi. ");
INSERT INTO bwo_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Yaatsok'on azaziruwo, ayhudiwots P'awlosi bos'amitso arikon eegosh b́wottsok'o dano b́geyi, mansh kahni naashuwotsnat mooshiruwotsitsi jamwots bokakuweetuwok'o bí azazi, P'awlosnowere bits dek'amt boshinaats bí t'intsi. ");
INSERT INTO bwo_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","P'awlos moosheyiruwok kakuweetsuwotsi t'iwintsdek't s'iilt «Ti eshuwotso! hambetsish b́ borfetso jam aawo Ik'i shinatse sheeng beyon tbeetsok'o t nibon danfee» bí et. ");
INSERT INTO bwo_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","K'eesi naasho Hananiyimó P'awlos noono botogetuwok'o P'awlos ganoke need'iru ashuwotsi bíazazi. ");
INSERT INTO bwo_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Manoor P'awlos Hananiyish, «Nee nooron futets maa dir artsono! nenowere Ik'o togetuwee! nemok'on tjangosh angshosh beedek'atniya nemalon taan botogetuwok'o niazaziri?» ");
INSERT INTO bwo_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Manoke teshts ashuwots P'awlossh «Ik'i kahniwots naashoneya nc'shiri?» boeti. ");
INSERT INTO bwo_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","P'awloswere «Ti eshuwotso! kahaniwotsatsi naasho b́wottsok'o danatse b́teshi, manwere eegoshe ‹Ni ashaatsi naashatse gondo aap'k'aye› etiruwo guut'ere» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","P'awloswere manoke fa'a ashuwotsitse k'atsuwots Seduk'awiya etetsuwotsi k'atsuwotswere feresawi etefuwotsi bo wotok'o dant «Ti eshuwotso! taa feresawi etetswotsatse feresawi taane, hamb! and angsheyiruwo tt'iniye noosh jangit imets k'irotse tuwi jangoshe» ett b́ k'aaro eenshdek't mooshiruwots taalotse b́ keewi. ");
INSERT INTO bwo_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","P'awlos han b́ keewutsok'on feresawiyotsnat Seduk'awiya eteefuwots dagotse fayo tuut mooshiruwotsi gitok kay b́k'ri. ");
INSERT INTO bwo_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Seduk'awiya eteefuwots «K'irotse tuwo aaliye, melakiywotswere aalne shayironwere aaliye» boere feresawiyotsmó «Jamanots fa'ane» ettniye boamanefo. ");
INSERT INTO bwo_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Manoor dimbri eeno wotb́wtsi, ferisawi jirwotsitse ik ik nem danifuwots tuwut «Noo ashaanatse eegoru gond keewo daatsratsone, Shayro wee melakiyo bísh keewure b́wotiti, no eegoru danatsone?» ett bomooshi. ");
INSERT INTO bwo_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Fyonuwere kup'efere bíame ashuwots P'awlosn yec' yec'ay tiish ishitune ett shatt azaziruwo «Od'er P'awlosi ashuwots dagotse kishde'er woowere! kes'fuwots galots dek' boami!» et wotaderwotsi bíazazi. ");
INSERT INTO bwo_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Yatsok'ono t'úwun doonzo P'awlos ganok need'dek't «Shenono! Iyerusalemn taash n gawutsok'o, mannk'o Romits taash gawo neen geyituwe» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Datso b́ gatstsok'on ayhudiyots kakuweewutsat «P'awlosn noo úd'raniyere mááyo máárátsone, aatsono úyatsone» ett botaareyi. ");
INSERT INTO bwo_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Malaanats shiyeets ashuwots taawonwere haboniyere bogfno boteshi. ");
INSERT INTO bwo_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bowere kahni naashuwotsnat eenashuwotsok amt hank'o ett boosh bokeewi «P'awlosi nó úd'raniyere maayo nonots nogerawok'o kup'shdek'at taareerone, ");
INSERT INTO bwo_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Mansh it mooshiruwotsnton shiyede'er kúp'de'er bín it aatit keewok'o aride'er P'awlosi itsh bodewetuwok'o azaziruwo aatuwere, noowere hanok b́ boraftsere shinon úd'osh k'andek'rone.» ");
INSERT INTO bwo_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ernmó P'awlos mish naay mal man b́shishtsotse kes' kes'fuwots galots amkindt P'awlossh b́keewi. ");
INSERT INTO bwo_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","P'awloswere bali naashuwotsitse iko s'eegdek't «Na'an kes' azaziruwosh b́keewit keewo b́detstsotse bíyokde'er t'ine» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Bali naashonuwere na'aman azaziruwok dek' kindt «Tipetso P'awlos taan s'eegt na'an neesh b́keewit keewo b́detstsotse niyok t t'intsituwok'o taan b́k'oni» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Azaziruwonuwere na'o kisho detsdek't okaan dek'amt, «Taash nkeewituwo eebi?» ett bíaali bíaati. ");
INSERT INTO bwo_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Na'onuwere hank'o bíeti, «Ayhudiwots P'awlos keewo katsidek' k'ebiruwok'o araat yaats mooshiruwots shinaanats boosh nt'intsitwok'o neen aatosh ik wotwutserne. ");
INSERT INTO bwo_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ernmó boosh eekfne, bín noúd'raawo mááyo máratsone, aatsonowere úyatsone ett taarts haboniyere bogts ashuwots bín úd'osh aashdek'rne, and bo bokotir boosh nkeewituwo s'uziye.» ");
INSERT INTO bwo_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Azaziruwonuwere «Keewan taash n keewutsok'o konshor daniyik'aye» ett na'o deen b́k'ri. ");
INSERT INTO bwo_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Maniyere hakon kes' azazefman bali naashwotsitse gituwotsi s'eegdek't «Ilitsi keez sa'ato b́wottsok'on K'isari maants git bal kes'fuwotsnat shab farshetsuwotsi, git bal gin shap'fuwotsnowere k'aniwere, ");
INSERT INTO bwo_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","P'awlosshowere farsho it k'anire dats keewiruwok Filksok jeenon b́bodetuwok'o woshwore» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Hank'o etiru woshonowere work'atats guut' b́k'ri, ");
INSERT INTO bwo_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«K'elawudiyos Lusyosoke, mangts dats k'eezfo Flkissh! jeeno neesh wotowe! ");
INSERT INTO bwo_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ashaan ayhudiwots detsdek't úd'oshe boteshi, taamo Rom dats ash b́woto tdantsosh kes' kes'fuwotsnton bodat bín t wooriyi. ");
INSERT INTO bwo_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Eegatse tuutson bos'aamitsok'o danosh geeyat mooshiruwotsok t'intsree b́teshi. ");
INSERT INTO bwo_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Bos'amiwere bo nematse tuuts keewon b́wottsok'o tdaatsi, ernmó k'irosh wee tiposh bín betsit keewo aaliye. ");
INSERT INTO bwo_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ashaan údosh maletsok'o tshishtsok'on manoor níyok twoshi, s'amiruwotsuwere bíyatse bodetsts s'aamiyo nshinatse bot'intsituwok'o boosh keewure.» ");
INSERT INTO bwo_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Mansh kes'kes'iruwots boon azazetsok'o Pawlosi t'úwon dek'amt Antip'at'risok bobetsi. ");
INSERT INTO bwo_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Yatsok'on Farshetsuwots P'awlosn ton boametuwok'o wosht boowere k'es' kes'fuwots gálo maants k'azboaani. ");
INSERT INTO bwo_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Farshetsuwotsuwere K'isariyo bo bodtsok'on worek'atats guut'ets woshman dats k'eziruwosh imt P'awlosi b́shinats bot'intsi. ");
INSERT INTO bwo_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Dats k'ezirowonu worek'atats gút'ets woshman b́nababi hakon P'awlossh Aawoki dats ashnene? ett bíaati, Kilik'iy dats ash b́ woto b́ dantsok'on ");
INSERT INTO bwo_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","«Neen s'amiruwots boowor njango shishetuwe» bí eti. Herodis mengst moots b́ koteetuwok'owere bíazazi. ");
INSERT INTO bwo_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Úúts aawoniyere il kahni naasho Hanani eenash ikikuwotsnat T'ert'elusi eteef Nemo sheengshdek' dantsonton K'isari maants bíami, boowere dats k'eeziruwo Filiksok t'int P'awlosi bo s'aami, ");
INSERT INTO bwo_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","P'awlosi s'eegdek't t'intsetsok'on T'ert'elus hank'o eton s'aamiyo dek't b́tuwi. «Shiimetso Filikso! niyatse tuwtson ay jeeno daatsrone, n sheeng k'eezonowere noashosh sheeng wonewo daatsere, ");
INSERT INTO bwo_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ayidek'at mangtso Filikso n k'alts sheeng keewan jamoke jam weeron een údone nodek'iri. ");
INSERT INTO bwo_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Andmó t ja'irawo k'awunon neesh t keewit keewo n doon noon nk'ebetuwok'o neen k'oniruwe, ");
INSERT INTO bwo_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ashaan noosh gondshoodo wotwutsere, datsatse fa'a Ayhudi jamwotsats dimbiro b́tuuziri, noimnetiyatse k'aldek'ets naazrawiwotsi eteefwotsshowere boon jishirwooniye. ");
INSERT INTO bwo_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","8","Ik' moonowere kimshosh bíetfere bín nodetsi, bíyats not'intsts s'aami jaman ar b́ wottsok'o nee ntookon bín aatr dano falitune.» ik ik bitsuwotsitsere han boyits dabfno No nemok'on bíyats angsheyish gawurone b́teshi, Ernmó gin jishiruwo Lusyos waat angnon nookishotse fos'dek't bíami, bín s'aamirwotsu níyok boweetwok'o bíazazi ");
INSERT INTO bwo_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ayhudiyots «Jam keewan aree» Etfetst s'amiyosh ik wotbowtsi. ");
INSERT INTO bwo_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Dats k'eeziruwo Filiks b́kishon kolat P'awlos b́ keewitwok'owa bíeti, P'awlos hank'o ett bíaaniy. «Ay dúrosh datsan keewutso nwoto tdantsosh taan s'amiyets keewosh aani tdek'etuwok'o nshinaats tt'intsor ayidek'at geneeúwefetsatniye, ");
INSERT INTO bwo_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ik' k'onosh Iyerusalem maants ti'amron tatse git aawoniyere b́bowok'o nee ntookon danofalfnee, ");
INSERT INTO bwo_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ik'i mootse wotowa ayhudiwots Ik' k'oni mootse wee kitotse kontonuwor t mooshfere wee asho dimbirosh ttuuzfere taan daatsratsne, ");
INSERT INTO bwo_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","And tiats bot'intsts s'amiyosh gawo b́jamon neesh t'intsosh falratsne. ");
INSERT INTO bwo_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ernmó han neesh kish kitso shunfee, bo kooti dana bo etiru imnetiyi kayo no nihotsko Izar Izeweri Ik'irwe, Muse nemonat Nebiyiwots mas'aafotse guut'ets jamo amanirwe. ");
INSERT INTO bwo_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Bowere bojangirwok'o taawor kaawwotsnat morretsuwots k'irotse botuwitwok'o Ik'on jangirwe. ");
INSERT INTO bwo_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Mansha Ik'onat ash shinatse nib s'ayino tdetsetuk'o jamaawo kup'irwe. ");
INSERT INTO bwo_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Iyerusalemitsnowere tkeshiyak ay natuwots bobeshiyakon t jirwotssh tep'wotit gizonat Ik'osh imet mebi gizo dek'at tweyi. ");
INSERT INTO bwo_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ik'o mootsnowere taan daatstsuwots man tk'alfere, manoori gizeyonuwere s'ayini fino fin tk'rtsok'one, taantonuwere ay asho aaliye b́teshi, dimbironwere tuuratse. ");
INSERT INTO bwo_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ernmó Isiyon waats ayhudiwots manoke fa'ane boteshi, bo taan bos'aamit keewo detsfno wotiyal nshinaats t'inr keewune. ");
INSERT INTO bwo_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Haniyakonowere moosh mooshiyiruwots shinats tt'iinoor t t'afitso fa'ewotiyal t'ints ashaanots keewune. ");
INSERT INTO bwo_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Arikon bo taalotse need'dek'at ‹K'irtsuwots tuwo fa'e tiettsosh hambets angshosh it shinats t'inre› etaat een k'aaron keewure, haniyere okoon k'osho tk'alts keewo aaliye.» ");
INSERT INTO bwo_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Filiksmó Krstiyani imnetiyi jango sheengshdek't b́dantsotse «Kes' azazefo Lusyos b́waatsok'on itjangosh angshituwe» ett boon deenb́k'ri. ");
INSERT INTO bwo_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","P'awlosi kotiru bali naashoshowere «Ayide b́ kic'irawonat b́ jaguwotswere bish k'alo bogetso baziyerawon b́kotetuwok'wa» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Muk' aawwotsiyere hakon Filkis Dursili eteets b́mááts ayhudiyunton b́weyi, P'awlosnowere s'egiydek't Iyesus Krstos shútson amani jango b́keewufere b́shshi. ");
INSERT INTO bwo_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","P'awlos kááwu woti jangonat took kewdek'i jango weet angshonowere b́keewor Filiks shatt «And k'ayamee, taash b́k'anoor k'osh aawots neen s'eegituwe» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Filiks P'awlosoke gubo dek'osh jangitniye b́tesh, mansh ayoto P'awlosi s'eegiyir b́keewifoni. ");
INSERT INTO bwo_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Git natoniyere okoon P'ork'iyos Fist'os Filikis shegro b́beyok b́beeyi, Filiks ayhudiwotsi geneúshosh geeyat P'awlosi b́ tipetsok'on k'azb́k'ri. ");
INSERT INTO bwo_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fist'os bí alguro K'isariyotse kindt keez aawo b́ teshiyakon manokere Iyerusalm maants bíami ");
INSERT INTO bwo_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","3","Manoknowere kahni naashwotsnat ik ik een een Ayhudi jirwots Pawlosats bo s'aamiyo bot'intsi, «P'awlosi Iyerusalemi deewáár noosh sheeng keewo k'aluwe» ett bok'oni, han boettsonuwere P'awlosi weerindatse korde'er úd'osh bo geetsotsne. ");
INSERT INTO bwo_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fist'osmó «P'awlos K'isariyon tipi mootsne koteyiri, taawere kaari and aanar b́maants ametuwe, ");
INSERT INTO bwo_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","It naash naashuwotsuwere taanton K'isariyo maants amnee, P'awlos b́ fints gond fino b́beyal manoke s'amiwune» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fist'os shmt aawoniye wee tats aawoniye bowawu aawwotsi bonton b́ beshiyakon K'isariyo maants no ami, manok nobodtsok'on yaatsok'on naashi jorats bedek't P'awlosi bíyok de'er bot'inetuwok'o bíazazi. ");
INSERT INTO bwo_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","P'awlos b́ t'intsok'on Iyerusalemn waats ayhudiyots gúrdek't need'at gaawu deshaw ay een een s'amiyotsi bí'ats bot'intsi, ");
INSERT INTO bwo_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","P'awloswere «Taa ayhudiyots Nemats wotowa Ik' maats wee Rom nugúsats t fints gond fino aaliye» ett bí'atse bíaniyit keewo b́keewi. ");
INSERT INTO bwo_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fist'osmó ayhudiyotsi geneúsho geeyat P'awlosi «Iyerusalem maants amr han jangosh manoke tshinatse angsho dek'osh geefneya?» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","P'awlosmó hank'o ett bíaani, «Hambe! taa b́shinaatse mooshosh Rom nugúso angshi jori shinatse t need'iri, nee sheengsh dek'at ndantsok'on ayhudiyotsats t fints gond fino aaliye. ");
INSERT INTO bwo_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Morretso twotiyal wee k'irosh betsit fayo tiats betsit morro finere wotiyal woruna eraatse, ernmó bo s'amiyan k'awuntsalka wotiyalmó konuwor bosh taan beshide'er imo falratse, taa Rom nugúsosh taash s'iilewe etaat t'intsree.» ");
INSERT INTO bwo_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Manoor Fist'os bín izfwotsnton keewedek't «Romko nugúso taash s'iile etri wotiyal nugúsok ametunee» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Muk' aawwotsiyere hakon Nogúso Agrip'nat Bernik'e Fist'ossh «Dan jeenon waarne» etosh K'isari maants boweyi. ");
INSERT INTO bwo_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Manoknowere ay aawosh beyat boteshtsosh Fist'os P'awlos jango hank'o ett Nuguso Agrip'sh b́ keewi, «Filks tipk'rat k'az b́k'rts ash iko hanoke fa'e b́teshi, ");
INSERT INTO bwo_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Taa Iyerusalemitse tteshor kahni naashuwotsnat Ayhudi eenashuwotsn ashaan bos'amiye hakon bíats t angshituwok'o boaati. ");
INSERT INTO bwo_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Taamó ‹Ash iko bín s'amiruwots shinats t'inr bín bos'amirumansh b́keewude'aniyere s'amiyetsman beshide'er imo Rom datsatsi ashuwots neemaliye› etaat boosh tiaanyi. ");
INSERT INTO bwo_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Mansh ashaan s'amiruwots ko'eyat hanok bowatsok'on ja'araniyere yaatsok'on angshi jorats bedek'at P'awlosi t shinats bot'intsituwok'o ti azazi, ");
INSERT INTO bwo_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Bín s'aamirwots keewosh b́ganok need' bodek'tsok'on bí gond fino finere ett tgawtsok'o bín s'amiyosh betsit keew eegonoru bíats t'intsratsne. ");
INSERT INTO bwo_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ernmó bínton bomooshiru moosho bo haymanoti jangonat k'irt teshtso P'awlos ‹Kashetsiye› bí etiruwo Iyesus jange. ");
INSERT INTO bwo_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Taawere hannaari keewo s'ilosh taan b́kic'ire P'awlosi ‹Iyerusalem maants amr bíyoke keewan jango angsho daatso shunfiya?› tieti. ");
INSERT INTO bwo_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Bímó bí jango Rom nugúsoke bísh s'ileyish geeyat nugúsok taash s'iilewe bíettsosh manok tdaamifetsosh tipi moots b́teshetuwok'o tiazazi.» ");
INSERT INTO bwo_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agrip'were Fist'ossh «Taawor ashaan b́keewufere k'ebo geefe» bí eti. Fist'osuwere «Yaats bín k'ebetunee» bíet. ");
INSERT INTO bwo_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Mansh yatsok'on Agrip'nat Bernik'e bo naashi taho tahdek't een baatson wotdek't kes'iruwotsatse naashuwotsnat kit kitotsi een een ashuwotsn deneyat waat angshi maa eenots bokindi, maniyere hakon Fist'os P'awlosi b́ s'eegiyi. ");
INSERT INTO bwo_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Hank'owere bíeti, «Nugúso Agrip'o! Itwere noonton fa'a ash jametsuwotso! ayhudiwots ‹Ashaan haniyere hakon kashon beyo bísh geyiratse› ett kuhefetst Iyerusalemitse, hanoknowere ti angshituwok'o taan boaattso it bek'iru ashaaniye. ");
INSERT INTO bwo_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Taayere bíyatse k'irosh bín betsit gond fino daatsratse, bí Rom naashi naashosh ‹t jango taash s'iilewe› bíettsotse hanok woshosh t k'ut'i. ");
INSERT INTO bwo_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Wotowa eree b́jangosh t doonzsh tguut'etwo daneets keewo deshatse, mansha s'ileyakon tguut'etuwo tdaatsituwok'owa etaat it shinats bítsnor iki Nugúso Agrip'o! nshinaats t'intsree. ");
INSERT INTO bwo_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Tipetso danbaan dameeyor bí s'amiyets jango kits k'azo dartsi araatniye taash b́be'eyi.» ");
INSERT INTO bwo_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agrip' P'awlossh, «N took jangosh keewundek'etuok'o taaro neesh imere» bíet, Pawlosuwere b́kisho jargdek't hank'o ett keewut aani b́dek'i. ");
INSERT INTO bwo_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Nugúso Agrip'o! Ayhudiwots taan bos'aamits keewujamosh hambets nshinatse keewur aani tdek'or ayiniye t geneúwiri. ");
INSERT INTO bwo_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Bítsnowere nee ayhudiwots niwonat moosh jamo t'iwintsdek'at danfnee, mansh k'amoon taan nk'ebetuwok'o neen k'onirwe. ");
INSERT INTO bwo_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Na'ortson tuwat awuk'o t beetsok'owo ayhudiwots danfnee, shintson tuwat tiash ashi dagotsnat Iyerusalemitse t be beyo danfnee. ");
INSERT INTO bwo_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ando aani gawo bogeyiyal no haymanotiwotse kup'idek'at nonemo kotiru kayuwotsitse ferisawi wotat tbewok'owo shintson detst danfnee. ");
INSERT INTO bwo_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Andmó angshosh hanok tneed'ir Ik'o nonihotssh taart b́ imts b́ jangiitsoshee. ");
INSERT INTO bwo_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Jangiyetsanok bodosh no jir tatse gituwots Ik'o t'uwe aawo Ik'ifetstni bokotfo, Nugúsono! taawor ayhudiwotsn taan bos'aamits jangiyetsan jangatsne. ");
INSERT INTO bwo_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ik'o k'irtswotsi b́tuuzitwok'o eegoshe itoke amano maawek b́woti? ");
INSERT INTO bwo_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«Taa t tookish Nazrettso Iyesus shútso tfaltsok'on k'efo taash geyife etaat asaabefe b́teshi. ");
INSERT INTO bwo_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Iyerusalemitse tk'altsonúwere haniye b́teshi, kahni naashuwotsoke t dek'ts alon amantsuwotsitse ayuwots tipimoots bokindituwok'o k'alre, boon boúd'orowere úd'iruwotsnton ik wotere. ");
INSERT INTO bwo_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ayoto ayhudiwots Ik' k'oni mootse boon jod'r doonzo boc'ashetuwok'o woshfee, boon ayide fayarnuwere k'osh úratsi kituwotsokor kesh amaat boon giishefe. ");
INSERT INTO bwo_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Han jangosho kahni naash jamwotsoke alonat tzaziyo dek'at Demask'o maants tí amifere tteshi. ");
INSERT INTO bwo_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Nugúsono! weeratse t befere aawu taalon aawu sháánoniyere bogo sháánts shááno tbek'i, sháánanuwere tiyatso taanton sha'irwots gúúratso darotse sháániyi b́k'ri. ");
INSERT INTO bwo_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Noúnetswere datsats dih s'uwat nobefere ayhudiwots noon keewu keewon ‹Sawul! Sawulo! eegishe taan ngishiri? Shiki shashats nned'iyal neesh b́ gonditi!› etiru k'ááro tshishi. ");
INSERT INTO bwo_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Taawere ‹Doonzono! nee kone?› tieti, doozonuwere, taash hank'o bíeti, ‹Taa nee ngishiruwo Iyesus taane. ");
INSERT INTO bwo_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Andmó tuur n tufoon need'owe, taa neesh tbe'eyiye and taan nbek'tsannat shino maants neesh tbe'et keewosh gútsonat gawo nwotitsh tgetsotsne. ");
INSERT INTO bwo_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Israe'el ash ashuwotsnat bo maants neen twoshit Ik' danawu ashuwots kishotse neen farituwe. ");
INSERT INTO bwo_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Bo aawo n k'eshituwok'onat t'aluwotse shááno maants nkishituwok'o Shed'anosh keeweewotsno Ik'o maants ni aanituwok'o woshituwe, boowere taan bo amantsi jangon bo morrosh orowa eto daatsitune, galdek'etsuwotsnton ritstiyo kaydek'etune.› ");
INSERT INTO bwo_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Eshe nugúso Agrip'o! daaratse taash imets bek'osh k'aztso woteratse. ");
INSERT INTO bwo_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ernmó shino Demask'on fa'a ashuwotsi, maants dabat Iyerusalemnat Yhud dats jamatse, Ik' danawu ashuwotsi naandrone err Ik'o maants bo aanituwok'o tdaniyi, naandrone boettsok'ono kitsit fino bo finituwok'o boon tdani. ");
INSERT INTO bwo_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Han jangosh ayhudiyots Ik'i mootse t befere taan detsdek't úd'osh boeti. ");
INSERT INTO bwo_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Hambetsish b́borfetsosh Ik' tep'o tiyatse k'aleratse, manshe múk'osho enosho gawefetsat hanoke ned'iruwe, nebiyiwotsnat Musen shino hank'o wotituwe boetts keewo keewoniyere okoon k'osho eegoru keewuratse. ");
INSERT INTO bwo_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Bowere bokeewu ‹Mesihiyo gond bek'o dek'etuwe, k'irotse tuwonowere shintso wotar kashi sháánono Israe'el ashuwotsnat Ik'i ash woterawwotsnsh kitsituwe› ettniye.» ");
INSERT INTO bwo_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","P'awlos man keewoke b́befere Fist'os «P'awloso! ando geewutsernee, ay ndano neen geyomants betsk'rere!» ett kuhat b́keewi. ");
INSERT INTO bwo_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","P'awlosmó hank'o ett bíaniyi, «Ayidek' shiimetso Fist'oso! arikonat kaawu keewoni tkeewiri bako geeyaliye tgeyi. ");
INSERT INTO bwo_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","B́ shinatse keewan tkeewiru nugúso keewan danfee. Hanwere ashon k'alerawo b́wottsotse nugúso b́dantsok'owo danfee. ");
INSERT INTO bwo_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Nugúso Agrip'o! nebiyiwotsi amanirunosha? Ni'amaniruwok'o danfee.» ");
INSERT INTO bwo_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agrip'were P'awlossh, «Nee k'awun sa'atanitse taan krstiyani woshk'rishale» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","P'awloswere, «K'awun gizewotse wotowa geenz gizewotse n s'uzi b́woterawon hamnbets tkeewuts keewo shishts jamo t tipeyaniyere okoon taank'o bowotish Ik'o k'oniruwe!» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Haniyere hakon nugúso, altsonat Bernik'ewu bonton bedek't teshts ash jamwots k'az botuwi. ");
INSERT INTO bwo_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Manoke kesht boamferowe, «Ashaan k'irosh wee tipewosh bín betsituwo eegoru k'alratse» boeti. ");
INSERT INTO bwo_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agrip'were Fist'ossh, «Ashaan Rom nugúsoke tkeewo taash s'iilewe eto b́ k'azink'ere hank'on fakshk'ryank'e» bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","It'ali datso maants markabon no ametuwok'owa eteetsok'on P'awlosnat k'osh k'osh tipetswotsn Rom dats k'eeziru Awugst'osi eteetso kes' jishiruwots kayotse teshtso Yuliyosi eteets bali abaatsi naashosh boimi, ");
INSERT INTO bwo_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Isiyon aatsi k'ari gúratse markabi bíyok need'irwok amiru Adramit'yon markabats keeshdekat no sha'i, mek'odeni awurajotse fa'a Teselonk'e kitotsi asho Arst'rokoswere nontoniye b́teshi. ");
INSERT INTO bwo_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Yaatsok'on Sidoni amnobodi, Yulyus P'awlossh sheengo b́teshtsotse b́ shunfwotsok amt bísh geyit tep'o bish bok'alituwok'owa bí eti. ");
INSERT INTO bwo_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Manoke tuwatnwere jongo noshinaatse noats b́ jongiruwotse K'op'rositse aats k'aritsi datsu te'o woshdek'at markabatsi sha'o dek'atnotuwi. ");
INSERT INTO bwo_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kilk'iyanat P'infiliyo ganoke fa'a aats k'aro nokimiyakon Lik'iyon fa'ú Mura kitto nobodi. ");
INSERT INTO bwo_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Manoke bali abaatse altso It'aliyomants ametuwo Iskndr markabo daatsdek't bíats nokeshetuwok'o b́woshi. ");
INSERT INTO bwo_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ay aawo t'awaash dek'at sha'at ay gond bek'on K'enidos kitu ganok amnobodi, jongonwere shinomaants noamawok'o noon b́bazitsotse Selmona dats gúúri ganoke beshat k'ert'es aatson gúrets datsu naaydek'at noami. ");
INSERT INTO bwo_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ay gondbek'on gúr gúron nobeshiyakon Lasiy kitu ganoke daatseyiru, «Markabi need'ok sheengi» eteef beyokuk amnobodi. ");
INSERT INTO bwo_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","No weeratsnowere ay gizewo hank'on b́ís'uure s'oomi gizeyo b́beshtsotse manoor aats k'aratse sha'o ayidek' shatiko b́teshtsotse P'awlos ashuwotssh hank'o ett bo atso bokotetuwok'o b́woshi, ");
INSERT INTO bwo_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«It ashuwotso! haniyak nosha'it sha'o shatiyits keewo bítse b́beyok'o taash be'eyiruwe, Kuronat markaboon s'uzats b́woterawo ash kashatsor kup'ts t'afonat s'uwo bodetuwe.» ");
INSERT INTO bwo_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Bali abaatse altsonmó P'awlos izoniyere markabu azaziruwonat markabudoonz boetiruwoni b́ k'ebiri. ");
INSERT INTO bwo_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Markabwots need'okman jooshi kimoosh sheengo woto b́k'aztsotse ay ashuwots, «Shinomaants sha'arr faletkawotyal gaar weeron, muur aawukindomantsi fengesho maantse fa'o Fink'eyi eteefo K'ert'esitse markab ned'efok borr manoke joosho beshiwone» ett bo asaabiyo bot'intsi. ");
INSERT INTO bwo_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Muur maantse muk' jongu b jongefere bobek'tsok'on boasaabtsok'o boosh b́wottsok'o bíarere markab bín bojokiru bitsdek't aatsatse sha'o dek't botuwi, markabi ned'iruwoke tuut k'ert'es ganoke gúr gúron bobeshi. ");
INSERT INTO bwo_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ernmó muk'i boteshiyakon, «Gaar maantsi aawu keshon eegurahi jongo» kup'ts jongo aats k'aro bin gúrts datsuatse tuut aats k'aromaants bomaants b́weyi. ");
INSERT INTO bwo_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Markabonwere b́gifniyetsonat jongmansh b́maawutsotse s'k etaat jongon jokeyat noami. ");
INSERT INTO bwo_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","K'eda eteets aats k'aron gúrts datsu naaydek'at nosha'or ay gond bek'on Markabuko jelbo detsdekat nokishots geddek'o nofali. ");
INSERT INTO bwo_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Markab jookiruwots jelbu markabots geetsdek't bokishiyakon markabu gúridek't jokon bo s'aas'i, markabu Surtisi eteets shiyi datsu maants bdihirawok'o shatt sharo k'o'úbazt jongon jokefere boami. ");
INSERT INTO bwo_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Egúrahon were kup'efere bíamtsotse yatsok'on markabats kuryets k'ac'o ik ikon aats k'aromaants juwo dek'botuwi. ");
INSERT INTO bwo_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Keezl aawots markabi k'ac'o bokishon k'aaúdek't shap't bojuwi, ");
INSERT INTO bwo_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ay aawosh aawuno wotowa, k'eeno bo bee'awotse jongonwere kup'efere bíamtsotse haniyere hakon kashosh falatsonee ett maac'o k'ut'bodek'i. ");
INSERT INTO bwo_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ashuwots misho b́jamon bomarawo ay aawo boteshi, mansh P'awlos bodagots need'dek't hank'o bíeti, «It ashuwotso! taa tiettso shishat T'ersesn turatste wotink'ere awaashonat t'af jamann itats borawnk'ee b́teshi. ");
INSERT INTO bwo_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Andoor markabo s'uzi awaashiti bako ititse konatsor t'afo boratse, mansha shenuwotso shatk'ayere! etaat itn iziruwe. ");
INSERT INTO bwo_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Oots t'ú bík twottso bín t Ik'iruwo Izar Izewer b́woshts melakiyo t ganok need'de'k't ");
INSERT INTO bwo_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‹P'awloso! shatk'aye! Romko naashi naasho shinatse need'o neesh geyife! hambe neenton sha'iru jamo Ik'o neesha err k'irotse worituwe› ett taash keewure. ");
INSERT INTO bwo_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Manshe it ashuwotso shatk'ayere! Ik'o taash b́keewuts jaman b́jamon b́s'eentsituwok'o bín amaniruwe. ");
INSERT INTO bwo_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","B́woteferemó jongo noon aatson gúrts dats ikuk de'amr juuk'rituwe.» ");
INSERT INTO bwo_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Tatse aauwdl t'úwotse Adriyay aats k'ari taalotse jongon jod'efe noamfere taali titson markab jookiruwots datsomants bot'intsok'o boosh bíari. ");
INSERT INTO bwo_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Mansha aats k'ari woko bín indeef joko dek't boindere dashan b́woko habigit indok'o wotat b́datseyi, muk'i boteshiyakon ando boindere shiits indok'o dashan b́geenztsok'o bodaatsi. ");
INSERT INTO bwo_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Nomarkabo aats k'ari gúúratse fa'a shutsuwotsats b́gawerawok'o shatt markabi shutsomantse markab bín jookef awdwotsi aatsots oorsh bok'ri, maniyere hakon t'úwo beshar bíere aawo boosh b́weetuwok'o Ik' k'ono dek' botuwi. ");
INSERT INTO bwo_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Markabu jookiruwots markabutse kesht wos'o geeyat boteshtsotse markabu shinomaantse bín need'iyeyiru biro dashan juwiruwo araat markabutse fa'a jelbu aats k'aromaants bojuwi. ");
INSERT INTO bwo_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Manoor P'awlos bali naashonat kes' kes'fuwotssh «Markabu jokirwots markabatse giwuk'ayr bobeyala bako it faro falratste» bíti. ");
INSERT INTO bwo_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Mansh kes' kes'fuwots jelbu detsts joko k'ut'k'raat aatsats juubok'ri. ");
INSERT INTO bwo_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Datso gatsosh bíetfere jametsuwots misho bo meetuwok'o P'awlos k'ont boosh hank'o bíeti «Eegonor mook'zat koto dek' it tuwiyako hamb hambetson tatse awdl aawe. ");
INSERT INTO bwo_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Manshe maayo it nonots itgedetwok'oye iti tk'oniri. Mannowere faritute, it took s'iirotse ikunwor dats fed'eratsatsane.» ");
INSERT INTO bwo_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Man bietihakon misho k'aaúdek't jamishinaatse Ik'o b́údi, titsdek'tnuwere moo dek'b́tuwi. ");
INSERT INTO bwo_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Mann jametsuwots kup'at misho bomeyi. ");
INSERT INTO bwo_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Markabutse b́ jamon git baalona shabe shrt ashuwotsn fa'ane noteshi. ");
INSERT INTO bwo_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Jamwots máát boworiyakon Markabats kuriyets Sindeyo aatsi k'aro maats juwat bíyatsi kuro boketi. ");
INSERT INTO bwo_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","B́ gatstsok'on bobodoko danatsno botesh, wotowa bako shiyo bítse be'eyiru aatsi k'aro bo bek'i, boosh b́faleyal markabu b́ maants gifnir úratse kishosh bogawi. ");
INSERT INTO bwo_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Markabo bín bneed'iru bíro bítsdek't aats k'arots faksh bok'iri, manoor bín markabo jokeyiru jokono bítsbok'ri, man kaawats fa'a sharono jongo maants dambaan k'aaúdek't aatsi k'ari gúúro maants keshosh boami. ");
INSERT INTO bwo_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ernmó markabu kakuwets shiyats bgaawetsosh dashan gúp'n bwutsi, b́shino maantsno dashan k'ons'ewtsat giwo bk'azti, b́shuutso maantsnomó jongi gifniyatse tuwtson tisho b́tuwi. ");
INSERT INTO bwo_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Tipetswotsitsere ikonuworu wáákr b́keeyawok'o kes' kes'fwots úd'osh bogawi. ");
INSERT INTO bwo_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Baalats naashonmó P'awlosi oriyosh b́getsotse boetts man de'atse, dab waak faltso shini markabots aatsi k'aro maants t'olar datsats k'ayi bokeshetuwok'o bíazazi. ");
INSERT INTO bwo_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Oortsuwotsmó Markabi is'uwotsnat markabi tishats bede'er bokeshetuwok'o bíazazi, mank'oon jamwots jeenon datsats bo bodi. ");
INSERT INTO bwo_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","K'aznofariyakon biats nobodts aats gúrdek'ts datsu Maltayi eteefu b wottsok'o dan nok'ri. ");
INSERT INTO bwo_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Aatson gúrts datsmanatse beyiruwots adits shuno noosh bokitsi, manorowere awusho b́buye ak' b́wottsotse tawo aat'idek't noon s'eeg dek't boibii. ");
INSERT INTO bwo_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","P'awlos shooto kakudek't taawots b́gedfere, k'ees'manatse tuutson dawunz ik kesht b́kishats deshwutsat joor b́wutsi, ");
INSERT INTO bwo_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Malta dats ashuwots dawunzo P'awlos kishats joorat b́befre bek't «Arikon ashaan kash údk ashe! aats k'aratsi jongotse jeenon b́keshalor Izar Izewer angshotse oorat kashon beyo falratse» boeti. ");
INSERT INTO bwo_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","P'awlosmó dawunzo taawots tebdek' juuk'rat eegor gondo bín b́datsrawo b́oori. ");
INSERT INTO bwo_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ashuwotswere «Andemo andek'úna bíatso b́gaapiti, wee danerawon k'irr b́dihiti» ettni bokotfera botesh. Ernmó ayoto bokore bíats gondo eegoru bodo b́k'aye bobek'tsotse boaasabiyo wonidek't «Hanuwo Izar Izeweriye!» boeti. ");
INSERT INTO bwo_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Manok noteshts beyok man ganoke aats gúrts dats mani altso puplyus datso fa'e b́tesh, ashaan b́ meyits nondek't keez aawosh sheengshdek't noon b́ ibiyi. ");
INSERT INTO bwo_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Manoor puplyos nih atsik'es'onat ac'uwoo bín detsbde'e shoodtni b́k'eyiri b́tesh, P'awlos bíyok kindt Ik'o bísh b́k'oni, b́ kishonowere bíats geddek't kashiyib́k'ri. ");
INSERT INTO bwo_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Man b́wotiyakon aatson gúriyets datsmanatsi k'osh shodetsuwots waat bokashi. ");
INSERT INTO bwo_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ash ashuwotswere ime keewo noosh dek't boweyi, noon bomangitsok'onowere noosh bokitsi, markabon amoosh notuworowere noosh geyitu jamo markabats noosh bokuriyi. ");
INSERT INTO bwo_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Keez shashosh Maltan noteshiyakon joshman aats kaaron gúrts datsmanatse no beshitso Eskndriyaa markabats keshdek'at notuwi, merkabunu Diyosk'orosi eteetso Woteraw maat ik'wots milkito btookatse detsfe b́teshi. ");
INSERT INTO bwo_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Srakus kitamots no bodtsok'on manoke keez aawo nobeyi. ");
INSERT INTO bwo_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Mokno aats k'aaro gúúrat Regiyum kitu nobodi, manoke ik aawo nobeshiyakon muur jongo b́ jongtsosh gitl aawots putiyolus maants noami. ");
INSERT INTO bwo_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Eshumanotsnowere daatsat bonton shawat aawo nobeysh noon bok'oni, maniyere hakono Rom maants noami. ");
INSERT INTO bwo_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Romitse fa'a amantsuwots nojango boshishtsok'on Afiyos gawuyonat «Keez k'eewokuwotsi» eteefuwotsok b́borfetso noon dek'osh boweyi, P'awlos boon b́bek'tsok'on Ik'o udat kup'b́wutsi. ");
INSERT INTO bwo_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Romits nokindtsok'on P'awlosi kotet kes' kes'f iko imt bíyal b́ beetuewk'o wosheyi. ");
INSERT INTO bwo_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Keez aawoniyere okoon P'awlos Romitse fa'a ayhuditsi een een ashuwotsi b́ s'eegiyi, bokakuwetsok'ono hank'o bíeti, «Tieshuwotso! Israe'el ash ashonat nihwots nemats tk'altso egonuworu gond fino aaliye, wotowa bako Iyerusalemn tipeyat Rom ashuwotssh besheyat ti'imeyi. ");
INSERT INTO bwo_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Rom ashuwots taan boatiyakon k'irosh taan betsit weero datso bok'aztsotse hank'on taan fakshosh gawtniye boteshi. ");
INSERT INTO bwo_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ayhudiyotsmó taa hank'on tfakshewo bok'eftsotse Rom nugusoke taash s'iilewe eto geyik b́woti, b́wotiyaloru ti ashuwotsi ts'aamit keewo deshatseb́teshi. ");
INSERT INTO bwo_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","And itn ts'egiye itn bek'osh geeyat manowere itsh keewoshe, taa habiliyan ttipe Isra'elsh jangit imets keewi jangoshe.» ");
INSERT INTO bwo_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Bowere hank'o ett bísh boaani, «Yhud datsatse njangosh gúút'ets wosho noosh boratse, hanok waats ashuwotsitse konuworu ngondo keewtso aaliye. ");
INSERT INTO bwo_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Namaniru haymanotiyan b́ be beyoke ash ashuwots bok'efiruwok'o danfone, mansh níasabtso eeg b́wottsok'o shisho geefone.» ");
INSERT INTO bwo_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Aawo bísh bodetsiyakon aywotdek't b́ beyiru moo maants boweyi, bíwere guurtson kooc'ish b́borfetsosh Ik'i mengsti jangosh gawon bíasabiyo boosh kish b́ kitsi, boon amaniyoshowere Muse nemonat nebiyiwots mas'aafotse kitsfetst Iyesus jangosh boosh b́daniyi. ");
INSERT INTO bwo_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ik ikuwots b́aap'o boamani, k'oshuwotsmó amaneratsno. ");
INSERT INTO bwo_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Bowere boatsetseyo ik bowoterawon bok'aleyi. B́wotefere bok'aleyoniyere shino P'awlos b́keewo b́ ishoor hank'o ett b́keewi, «S'ayin shayiro Nebiyiwo Isayasn it nihotssh b́ keewtso arikee b́teshi! ");
INSERT INTO bwo_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","B́ keewts aap'o hankowa b́wotiti, ‹Ash ashaanotsok amrniye Shishonere shishetute, ernmó t'iwintsratste, Bek'onere bek'etute, ernmó nibn de'atste eree boosha, ");
INSERT INTO bwo_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ashaanots nibo kup'wtsere, Bowaazonuwere ipewutsere, boaawonuwere is'ewutsere, Hnk'o wotob́k'azink'ee, Bo aawon be'er, Bowaazon shide'er, Bonibonowere t'iwintsde'er Tmaants bo aanere, Taawere boon tkashyank'oni b́teshi.› » ");
INSERT INTO bwo_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","«Eshe Ik'i kashiyi wosho Ik'i ash woterawwotssh woshetsok'owo dande'ere, boowere eekar bín dek'etune. ");
INSERT INTO bwo_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","P'awlos han b́keewiyakon ayhudiwots k'up'shdek't mooshfere manoke kesht boami.» ");
INSERT INTO bwo_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","P'awlos b́kirayits mootse gitnati s'eeno b́beeyi, b́maants weyiru ashjamwotsno dek'fee b́teshi, ");
INSERT INTO bwo_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ik'i mengstonowere nabfetst doonzo Iyesus Krstos jango konuwor bín b́bazirawon ááwu shuk'on b́danifoni b́teshi.");
INSERT INTO bwo_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Iyesus Krstossh guuts wottso woshosh s'egetsoke, Ik'i doo shishiyo daniyosh marat'etso P'awlosoke wosheets wosho. ");
INSERT INTO bwo_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Doo shishiyanwere Ik'o nebiyiwots weeron S'ayn mas'aafotse shin shin jangiyets aap'oniye. ");
INSERT INTO bwo_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Doo shishiyonuwere Ik'i na'o b́ naaron Dawit naarotse b́shuweetsok'o kitsitkee, ");
INSERT INTO bwo_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Mank'owere no doonz Iyesus Krstos b́ S'ayin shayiron k'irotse b́tuwon Ik' na'a b́wottsok'o bíangi eenon b́daneyi. ");
INSERT INTO bwo_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Krstos shúúts jangosh Ik' ash Woteraw jamwots bo amanituwok'onat boaletwok'o woshosh b́ weeron wosh na'o wotosh noon betsit s'aato dek'rone. ");
INSERT INTO bwo_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Itwoor Iyesus Krstosk itwotituwok'o Ik'o b́ s'eegts jirwots taalots itne. ");
INSERT INTO bwo_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Eshe Romitse beyiru, Ik'o iti b́ shuntswotsnat b́jiro it wotituwok'o itn s'eegts jamwotso! Noo nih Ik'oknat nodoonz Iyesus Krstos s'aatonat jeenon itsh wotowe. ");
INSERT INTO bwo_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","It imneti shúútso dats jamats b́shishetsotse, jamoniyere shinon Iyesus Krstos weeron it únets jangosh Izar Izeweri údituwe. ");
INSERT INTO bwo_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Jam aawo Ik'o tk'onor itn t gawiruwok'o b́ naay jangosh keewiruwo doo shishiyo daniyosh t nib s'eenon bísh t finiruwu Ik'o taash tgaawoniye. ");
INSERT INTO bwo_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Ando dabr s'uwanatse itok wosh Ik' shuno b́ wotere t weerindo b́káátsituwok'o jam aawo Ik'o t k'oniri. ");
INSERT INTO bwo_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Imnetiyats it kup'ituwok'o itn woshituwo shayiri imo itsh betsosho, itn bek'osh tewuniruwe. ");
INSERT INTO bwo_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Man ti etiruwere taa it imnetiyon, itwere t imnetiyon no atsatsewo nokup'itwok'owe. ");
INSERT INTO bwo_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Ti eshuwotso! k'osh k'osh Ik' ash woterawwotsitse ay amantsuwotsi tdatstsok'o mank'o ititsnoru shuwo daatsosh geeyatniye tteshi, ernmó itok wosh ay aawo tk'anere andish b́borfetso taash k'ano b́k'aztsok'o it danetwok'o geefe. ");
INSERT INTO bwo_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Salat'antswotsi wotowa salat'anerawotsi wotowa dantsuwotsi wotowa danawu ashuwotsi daniyo fal k'ayaatse. ");
INSERT INTO bwo_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Eshe itsh Romn beyiruwotssh doo shishiyo daniyosh tewuniruwe. ");
INSERT INTO bwo_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Taa doo shishi aap'on jitseratse, doo shishi aap'o shino ayhudiyotssh, bíyats aanat Ik' ash woterawwotssh, Mank'o amants ash jamwotsi kashiyosh falit Ik'i angoniye. ");
INSERT INTO bwo_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kááwu wotituwo imnetiyon kasho daatsituwe ett guut'ere, Ik'i kááw woto doo shishyon b́be'etsotse b́ jamon asho kááw b́ wotit imnetiyone. ");
INSERT INTO bwo_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Ashuwots bogondon aro b́daneerawok'owe bok'aliri, Ik'onowere shato bo k'ztsotse bo gondi jangosh jametsats daaratse Ik' fayo be'etuwe. ");
INSERT INTO bwo_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Boon b́ sezituwere Ik' jango dano boosh b́ geyituwok'o Ik'o b́tookon b́kitsre dant boteshtsotsne. ");
INSERT INTO bwo_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Datso bíazetson tuut ashuwotssh be'erawo Ik'i doyo, manuwere dúre dúri bí angonat Izar Izeweri b́woton bí bíazts keewwots weeron sháánt b́be'eyirwonat t'iwintsosh ashuwots bot'afits t'afiyosh bo etetuwo deshatsne. ");
INSERT INTO bwo_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Bowere Ik'o dant bísh wotit mangonat údon imatsne, bohasabiyon woterawo bowoti t'iwintsraw bonibo t'alu b́wtsi, ");
INSERT INTO bwo_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","«Dantsuwots noone» ett dartsuwotsi bowoti. ");
INSERT INTO bwo_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Besherawu Ik'o mangiyoniyere beshit asho aro wotts ariyetso, Kafon, awd tuf detsts gizuwotsn, datsatse geetseyiru dins'otswots aron arit finetsuwotssh mango boími. ");
INSERT INTO bwo_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Mansh boatsatsewo botook atsats jitsit fino bok'alitwok'o Ik'o kimon s'eents bonib tewunosh keewetswotsi bowotitwok'o k'azb́k'iri. ");
INSERT INTO bwo_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Man b́wotuwere Ik' aro kooton bowonitsosh, aztso shegro azeetso boik'itsonat bísh guuts bowottsoshe, Ik'onmó dúre dúrosh údeke! Amen. ");
INSERT INTO bwo_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ashuwots man bok'altsotse Ik'o Woteraw wic'ets tewunosh beshidek't boon bí imi, bo mááts máátsuwots dab azeewon daneets gonkewo daneerawu gonkeyi naaron woni bok'ri. ");
INSERT INTO bwo_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Mank'o nungushuwotswere daneets gonkewo máátsuwotswotsnton wosho k'azt boatsatsewo bogúsiyon bomis'i, mansh nungushuwots nungushonton jitsits keewo bofini, bo sheeltsi jangosho boosh wotit fayo bomeetson bodek'i. ");
INSERT INTO bwo_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ashuwots Ik' dano geyo bok'aztsotse wic'ets keewo bo finituwok'o Ik'o Woteraw nibosh beshidek't imb́k'ri. ");
INSERT INTO bwo_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Mansha morron, gondon, jaalon, weerigondon, okooron, kashúd'on, shid'eyon, dirshon, gond tewunon s'eent, ando oonetswotsiye, ");
INSERT INTO bwo_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Ash shúúts t'afiyruwots, Ik'o shit'iruwots, ash ketiyiruwots, mishetswots, noona boguwotsi etiruwots, gond finosh malo geyiruwots, bonih indosh azazerawwots, ");
INSERT INTO bwo_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","T'iwintsde'awwots, keewetso gakiruwots, shuno deshawwots, maac'kup'uwotsiye. ");
INSERT INTO bwo_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","«Keewanotsi k'aliru jamwots k'ire boosh wotiti» etiru Ik'o nemo danfetstniye jaman bok'aliri, k'al mec'ro woterawon, man k'alirwotsnowere bokup'iri. ");
INSERT INTO bwo_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Nee k'osh ashaats angshirwono nee ntokish bíyats nwebitwo deshatsne, k'osh ashaats ni angshor n tookatse niangshiri, nee k'osh ashaats angshfetsat, n angshts ashman b́ k'alirwoniye nk'aliri. ");
INSERT INTO bwo_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Mank'o k'aliru ashuwotsats, Ik'o boosh wotituwo boosh b́ angshiruwok'o danfone. ");
INSERT INTO bwo_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Nee ashono! mank'o k'aliru ashuwotsats angishfetsat, bo bok'aliruwo nk'alor Ik' angishi shirotse nkeeshtsok'o neesh arefa? ");
INSERT INTO bwo_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Himo Ik'o b́ sheeng wotonat jam falk b́woto, noosh b́ k'amonwere bí ankattsono ngac'iri? Ik'o sheeng b́ woto noosh bíayiyi, neen n morrosh naandre eto maants jishosh b́wotok'o danatsneya? ");
INSERT INTO bwo_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Eshe nee n morrosh naandre eto nk'aztsotsnat maac'o kup' nwottsotse Ik'i fayonat ari angshon b́be'et aawots fayo niats bí ayituwok'owe nk'aliri. ");
INSERT INTO bwo_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Ik'o ik ikuwotssh bofinok'oye boosh b́ imeti. ");
INSERT INTO bwo_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Sheeng finats kup'de'er údonat mangon t'afrawu kashonowere geyiruwotssh Ik'o boosh dúre dúri kasho imetuwe. ");
INSERT INTO bwo_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Botooki keewo geyiruwotsi, ari keewosh azazerawwotsnat gondosh azazeyiru gonduowotsatsomó Ik'i fayonat kaak k'iro boats weetuwe. ");
INSERT INTO bwo_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Shin shino ayhudiwotsats maantsnowere Ik'i ash woterawwotsats gond finiru ash jamwotsats gond bek'onat kic'on weetuwe. ");
INSERT INTO bwo_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ernmó sheeng keewo kaliru ash jamats Ayhudi wotowa Ik'i ashwoterawwotsi wotowa údono mango jeeno boosh imetuwe. ");
INSERT INTO bwo_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Ik'oniye ashuwotsi boga bogshraake. ");
INSERT INTO bwo_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Nemo bodeshawo morr finiru jamwots nemo bot'ut'alor t'afitúne, nemonowere deshfetsr morr finiru jamwotsmó nemon bo ats angshetuwe. ");
INSERT INTO bwo_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Ik' shinatse kááwu wotituwots nemo shisht finats jitsiruwotsiye bako nemo shisht finats jitsrawotsiyaliye. ");
INSERT INTO bwo_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Nem deshaw Ik' ash woterawwots bo azeewon nemo bí azaziru keewo kalirune, man weeron nemo bot'ut'aloru botookk wotts azeeyi nemo bodetstsotse k'alosh boon b́geyituwo danfnee. ");
INSERT INTO bwo_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Bo keewanúwere nemi etiru jam keewo bo nibats b́ guut'ets b́ wotok'o kitsiruwe, aaninuere bonibo boats gawituwe, ikn ikno boon bonibo b́gac'iti, ikn iknonomó boon b́ tep'eti. ");
INSERT INTO bwo_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Han sháánon b́be'etwere, taa t nabiru doo shishi aap'ok'on Ik'o Iyesus Krstos weeron ashuwots ááshon bofints keewats b́ angshit aawotse. ");
INSERT INTO bwo_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Hamb, nee «Ayhudi taane» etirune, nematse nte'eyiri, Ik'k nwottsosho bogtaana etaat ni'it'iri. ");
INSERT INTO bwo_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Nee Ik' ettso danfnee, Muse nemo ndantsotse sheeng fino danfnee. ");
INSERT INTO bwo_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","«Nee dogwotsi jishiruwo taane, t'aluwotse faúwotssho sháán taane, ");
INSERT INTO bwo_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Danawwotssh dano kitsituwe, nanaúwotsno danituwe» níetiri, mank'o, «Muse nemon dano s'eenon detsfe» níetiri, ");
INSERT INTO bwo_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","K'oshuwotsi daniruwo nwotor bére ntooko eegishe daniyo nk'azi? úp'mk'ayere nietiri, nemon úmp'e n úmp'iri, ");
INSERT INTO bwo_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Wido amk'ayere etirune, nemo wide niamiri, nee Woteraw Ik'uwotsi wic'irune, bo Ik' k'oni moowwotsno fa'o nbiik'iri. ");
INSERT INTO bwo_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Nee Ik'i nemwotsne n'it'ri, ernmó b́nemman gakat Ik'o ngac'iri. ");
INSERT INTO bwo_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Manuwere, «It ayhudiwotsatse tuutson Ik'i shútso Ik' danawu ashuwotsoke c'ashetwe» ett guut'etsok'one. ");
INSERT INTO bwo_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Gof amo arikon neesh b́ sheenget nemo nkotaale, nemo n gaaketka wotiyalmó gof niamo gofo niamawok'owe b́taaweti. ");
INSERT INTO bwo_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Mansha gof amaaw Ik' ashwoterawwots jiro nemi tzaziyo b́kotetka wotiyal gofo am b́ k'azo gof bíamtsok'o tawetwoshna? ");
INSERT INTO bwo_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Nee guut'ets nemo detstsonat gof amtso wotar nemo ngakal b́ meetson gof amawo wotar nemo s'eentsiru Ik' ash woteraw jiro níyats angshituwe. ");
INSERT INTO bwo_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Eshe shúúts mec'ron Ayhudi wottso ari ayhudiyaliye, mank'owere úratse be'eyiru meetson gof amo ari gof amaliyee. ");
INSERT INTO bwo_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Ari Ayhudiwo b́gitsitse Ayhudi wottsoniye, ari gof amonwere Ik'i shayiron S'ayinon wotit nibotse gof amoniye bako nemon guut'etsok'on meetson gof amaliyee. Eshe hannaari asho údo b́dek'et Ik'okna bako ashoknaliye. ");
INSERT INTO bwo_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Beree ayhudiyots Ik' ashwoterawwotsiyere bok'an eegoneya? Gof amo ayhudiwotssh eebi b́ k'aliti? ");
INSERT INTO bwo_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Arikon Ayhudi woto ay weeron k'anefe, bog keewo Ik'o aap'o ayhudiyotssh adaro bíimtsoniye. ");
INSERT INTO bwo_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Eshe Ayhudiyotsitsere ik ikuwots amanek wotar daatseyo bok'azal, bo amanetsuwotsi wotbok'azo Ik'o amanek b́ woto ooritúwa? ");
INSERT INTO bwo_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","B́ jamon oriratse! «N aap'ts aap'atse tuutson arikeewetsoniye nwotiti, N mooshorowere angshon da'itune» Ett guut'etsok'on ash jamo kootetso b́ wotiyalor Ik'o arikeewetske. ");
INSERT INTO bwo_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Ernmó no morro Ik' kááwo b́ kitsitka wotiyal eshe eebi no'eteti? Ik'o nomorrosh noon b́seziyal kááwon angshratse eteya b́ wotiti? Hanoke t keewiruwo ashkok'one. ");
INSERT INTO bwo_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","B́ jamon woteratse! hank'o b́wotitkawotiyal Ik'o datsuwats aak'oneya b́ angshiti? ");
INSERT INTO bwo_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Ernmó kootetsi twoto Ik'o ar keewutsi b́woto kitsre, b́mangi ayono kitsitk b́ wotiyal, bere taa morretsok'o tiyats angshet eegoshe? ");
INSERT INTO bwo_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Ik ik ashuwots «Bére, Sheeng keewo b́weyish gond keewo eege nok'aliyala?» etaat tdaniruwok'o woshdek't taan bo s'aamiyir, mansh mank'owwotsats angshet angsho kááwe. ");
INSERT INTO bwo_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Bére no ayhudiyots Ik' ash woterawwotsyere k'anefone eteya? Mank'o woteratse! k'osh ash jamo Ayhudi wotowa Ik' ashwoterawwotsi wotowa morretsuwotsi bowottsok'o shin shin kitsre. ");
INSERT INTO bwo_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Hank'o ett guut'etsok'on, «Dab ikonúwor kááwu asho aaliye, ik doonzuwor aaliye, ");
INSERT INTO bwo_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Nibetsonuwere aaliye, Ik'onowere geyiruwo ikdonzwor aaliye. ");
INSERT INTO bwo_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Jametsuwotswere weeratse k'az keshrne, Ik wotdek't darwutserne. Doo fino finiruwo dab ikdoonzuwor aaliye. ");
INSERT INTO bwo_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Bogogo k'eshets dook'oyiye, bo alberonowere antelcerne, bonoon keewi shuwonwere dawnz marziyok'oyiye ");
INSERT INTO bwo_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Bonoonuwere c'ashonat s'aamon bín s'eenwtskee. ");
INSERT INTO bwo_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Botufo ash úd'osh káárke, ");
INSERT INTO bwo_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Boweeratse daatsetuwere t'afonat dash aanone. ");
INSERT INTO bwo_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Jeeni weeronowere danatsne, ");
INSERT INTO bwo_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Ik'onowere b́ jamon sharaatsne.» ");
INSERT INTO bwo_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Muse nemi tzaziyo b́ s'iilfo nemmaniyere dashe fa'úwotsi b́wottsok'o danfone, manatse tuutson ashuwots bíyats boweebituwo t'ut't s'k bo etiri, dats jamonuwere Ik'i angshi shirots wotitwe. ");
INSERT INTO bwo_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Mansha asho konuwor Ik'o shinatse, Muse nemo s'eentson Kasheratse, Nemman b́kitsir ash jamo morretsi b́wotoniye. ");
INSERT INTO bwo_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Andmó Ik'o ashuwotsi kááwu b́ woshit weero nemalon b́ woteraawok'o be'ere, manuwere Muse nemonat nebiyiwots mas'aafotse gawere. ");
INSERT INTO bwo_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Mansha eshe Ik'o b́ k'osh k'oshirawon Iyesus Krstosi amanon amaniru jamosh kááwu woto imetuwe. ");
INSERT INTO bwo_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Ash jamwots morro finernre, Ik'o boosh b́'imts mangonowere t'ut'rnee. ");
INSERT INTO bwo_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Mansh ashuwots Iyesus Krstos b́ k'alts kashiyi fino Ik'i s'aat mec'ron kááw wotitune. ");
INSERT INTO bwo_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Ik'o Iyesus Krstosi wosho woshdek't b́ t'ints bín amanitu jamwots b́ s'atson bomorrosh oorowe eto bodatsishee, Ik'o man b́k'al b́k'amoon morr shintso k'azoon ar wotts b́took kááwo kitsoshe. ");
INSERT INTO bwo_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","And dúranatse Ik'o b́ tookon kááwu b́woto b́kitsir Iyesusi amants jamwotsi kááwu woshoshe. ");
INSERT INTO bwo_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Haniyak bín noít'et keewo eebi fa'oni? Eegonor id'atsone! bín no id'awok'o woshitwonúwere eebi? Nemo no s'eenirwosheya? Woteratse, ernmó imneti nemone. ");
INSERT INTO bwo_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Mansh eshe Ik'i asho kááwu b́ woshit, asho nemi fino b́kaltsosh b́woterawo imnetiyon b́wottsok'o t'iwintsdek'etwone. ");
INSERT INTO bwo_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Himó Izar Izewer ayhudiwots s'uzshe Ik' b́woti? Izar Izewer Ik'i ash woterawwotsshor bokooshna? Arikon Izar Izewer Ik' ash woterawwotsshor boke. ");
INSERT INTO bwo_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Ik'o ike, ayhudiwotsi wotowa Ik' ash woterawwotsi bo amanere kááwu woshituwo bíne. ");
INSERT INTO bwo_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Bére, imnetiyatse tuutson nemo gaketuwone eteya? Iya'a, iki nemo kup'ide'erniye nodetsetiye. ");
INSERT INTO bwo_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Eshe meetson nonih wottso Abraham daatsre noetetuwo eebi? ");
INSERT INTO bwo_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Abraham kááwu b́wot finona wotink'ere, bín b́ it'et keewo daatsiyank'e b́teshi, ernmó Ik'i shinatse it'o falratse. ");
INSERT INTO bwo_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","S'ayin mas'aafo, «Abarham Ik'on amanere, bíamantsonwere kááwu b́wottsok'o wotatniye bísh b́taaweyi» etfe. ");
INSERT INTO bwo_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Finiru asho b́ daatsitwo bí angi k'awnts wottsoni bako bísh imet imoniyaliye. ");
INSERT INTO bwo_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Asho sheeng fino b́t'ut'alor dab́ morretswotsi Kashitwo Izar Izeweri bíamaniyal bíamantso kááw wotar bísh taawetwe. ");
INSERT INTO bwo_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Dawit b́kaaton Ik'o sheeng finalon kááw b́woshit asho awuk'o derek b́wottsok'o b́ kitsor hank'owe bíeti, ");
INSERT INTO bwo_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«Bo daro boosh oorowe eteetsuwotsnat Bomorro boosh ipk'reets ashuwots Derekne! ");
INSERT INTO bwo_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Doonzo b́morro bíats b́taawurawu asho Deereke!» ");
INSERT INTO bwo_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Bére, Dawit b́keewuts deeran gofdamiyetsuwots s'uzsheya? Himó gof damiyerawwotsshe? Gof daamiyerawtsshowere, «Abraham Ik'o bíamanere bíamantsman bísh kááwu wotat b́taaweyi» etrone. ");
INSERT INTO bwo_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Eshe Abrahamsh b́imnetiyo kááwu wotat bísh b́taawe awure? Gofo bíamftse shinemó gofo bíamiyake? Gofo bímfetsere shina bako gofo bíamiyakaliye. ");
INSERT INTO bwo_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Abraham gofo bíamfetsere shino b́imnetiyo kááwu wotat b́datsetsok'o kitsosh milikito bísh b́wotituwok'o gofo bí amiye, hanuwere ando gofo boamaawo amanitu jamwots kááwu wotar botaawetuwok'o boosh niho b́wotishe. ");
INSERT INTO bwo_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Mank'owere Abraham gof amtsuwotsshor nihe, gof amtsuwotssh niho b́wottsonuwere gof boamtso s'uzosh b́woterawo bí gofo bí amfetsere shino b́detsts imnetiyi shuutso sha'iruwotsshe. ");
INSERT INTO bwo_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Abrahamnat b́ naaro datsu b́naatetwok'o Ik'o b́ jangiyi imnetiyon b́daatsts kááwona bako nem kotonaliye. ");
INSERT INTO bwo_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Ik'o b́jangitsman naatetwots nemo s'eentsde'e kotet ashuwotsi wotiyalma imnetiyo k'awuntso deshatse, b́jangtsonwere k'awntsalke. ");
INSERT INTO bwo_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Nemo b́dowet Ik'i faye, ernmó nemo bíaalink'e morro berawuk'ee. ");
INSERT INTO bwo_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Mansh Ik'o b́jangitsman bodaats imnetiyona b́ tesh, Ik' jangitsanwere Abraham naar jamwotssh Ik'oki s'aaton imek b́woto arikee. Manúwere nemo shoydek't sha'iru ashuwots s'uzsh b́woterawo Abrahamkok'o amants jamwotsshe, mank'onowere Abraham noúnetssh nihe ");
INSERT INTO bwo_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Abraham jangosh, «Ay ashuwots niho neen woshre» ett guut'ere, bí k'irtsuwotsi tuuzituwonat aalo b́ fa'ok'o woshituwo Izar Izeweri bí amantsotsne. ");
INSERT INTO bwo_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Abrahamsh n naaro ayider ayituwe ett keewetsok'on ay ashi niho b́wotituwok'o bí amananat b́ jang eegoru jangosh wotit keewo bíalefere. ");
INSERT INTO bwo_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","B́ idmewo bal natok'o b́teshtsotse b́ meetso b́maawutsotse k'irts ashok'o b́wottsotse shuwo b́falrawonat Sarawwere mahanat gawertsu b́wottsotse shuwo b́falrawok'o b́danaloru b́ imnetiyon maawk woteratse. ");
INSERT INTO bwo_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","B́ imnetiyon kup' wotat Ik'osh manga b́ imi bako Ik'o bísh b́ jangitsatse aman k'azoon b́jamon hakebaka eraatse. ");
INSERT INTO bwo_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Ik'o b́jangitsonowere s'eentsitwo b́wotok'o b́ maac'i s'eenona bíamnefo b́teshi. ");
INSERT INTO bwo_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Mansha b́ amantso kááw wotat b́ taaweyi. ");
INSERT INTO bwo_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ernmó, «Kááwu wotat bísh taawere» ett guut't aap'etso Abraham s'uzsh b́woterawo ");
INSERT INTO bwo_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","noshorniye, nodoonz Iyesusi k'irotse tuuztso Izar Izeweri amaniruwotssh nooshor no amantso kááwu wotar b́taaweti. ");
INSERT INTO bwo_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Nodoonz Iyesuswere no morrosha ett k'irosh beshyat b́imeetsonat nonowere kááw woshosh k'irotse tutsoniye. ");
INSERT INTO bwo_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Eshe no kááw woto nodaats amanon b́ wottsotse no doonz Iyesus Krstosn Ik'onton jeeno detsfone. ");
INSERT INTO bwo_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","And kup'dek'at nodatseyiru s'aatok nokind bín amanon b́wottsotse Ik'o noosh b́jangits b́ mango kayitwotsi nowottsosh mann it'irwone. ");
INSERT INTO bwo_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Hanmec'ron b́woterawo gond bek'o k'amo noosh b́daatsitwok'o nodantsotse noo gond bek'on it'iruwone. ");
INSERT INTO bwo_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","K'amotsnowere fadeyar kup'o, kup'otsnowere jangiyetso daatsetwe. ");
INSERT INTO bwo_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Noosh imets S'ayin shayri weeron Ik'i shuno nonibotse b́ s'eentstsotse b́ jangitso noon jitsiratse. ");
INSERT INTO bwo_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Maawk wotat nobefere Ik'o bíetts aawon Krstos morretswotssha ett b́k'iri. ");
INSERT INTO bwo_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Kááw ash shegro wotar k'irit asho daatso ayide'er kic'ike, b́woteferor doo ash shegro kirosh daneraka daatso faletuwe. ");
INSERT INTO bwo_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ernmó noo morretswotsi wotat nofa'e noshegro Krstos k'irre, manuwere Ik'o noosh b́detsts shuno awuk'o een b́wottsoniye b́kitsiri. ");
INSERT INTO bwo_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","No kááwutso Iyesus Krstos s'atsona wotiyal ikibogshr Ik'i fayotse no kashit b́weerone. ");
INSERT INTO bwo_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Noo Ik'o balangarwotsi wotat nobefere b́naay k'iron Ik'onton no manerone, and Ik'onton nomaneyakon b́ naay kashi weeron iki bogo kashituwone. ");
INSERT INTO bwo_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Han mec'ronaliye, Ik'onton mano bín nodatstso nodoonz Iyesus Krstos weeron Ik'on ít'irwone. ");
INSERT INTO bwo_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Ik ashaatse tuutson morro datsuwats b́weyi, morratse tuutsonowere k'iro b́weyi, mank'owere ash jamo morro b́fintsotse ash jamats k'iro b́weyi, ");
INSERT INTO bwo_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Muse nemo b́ imftsere shin morro datsuwatse fa'e b́teshi, ernmó nemo bíaltsoke morro b́ tookon morrok'o taaweratse b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","B́ wotiyaloru Adamkok'o nematse beshat morro finerawotsworu dab bo'orerawo k'iro Adamatse tuut Muse ats b́ borfetso ash jamatse alo b́ daatsi, Adamwere shinomaants weetu Krstossh bí aroniye. ");
INSERT INTO bwo_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ernmó Ik'o b́ s'aati imo ash morronton nuutsaliye, ik ash morri jangon aywots bo k'irtsok'o mank'o Ik' s'aatonat ik asho Iyesus Krstos weeron daatsets s'aaton imetso ayuwotssh bogshdek't imere. ");
INSERT INTO bwo_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Mank'owere Ik'o beenon b́doots imo s'aati oot'o ash iko morro b́doots oot'ok'oyiyaliye. Ash iko morratse tuutson imetso angsho b́doyi, ay morratse tuutson imets imo kááwe wot b́dowi. ");
INSERT INTO bwo_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Ash iko morratse tuutson k'iro ash jamatse alo b́detsiyakon bére Ik'i ay s'aatonat beenon imetso s'aat bín kashitu ash jamwots Iyesus Krstos weeron kashon naashitune. ");
INSERT INTO bwo_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Eshe Adam iks'uzo morri fayi angsho ash jamats b́dootsok'o mank'o Krstos ikoko kashi fino ayuwotsi fayotse kishr kasho imetwe. ");
INSERT INTO bwo_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Ash iko aleyo b́k'aztsatse tuutson ayuwots morretswotsi bowottsok'o mank'o ash iko bíaletsatse tuutson ayuwots kááwitune. ");
INSERT INTO bwo_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Morro bíayitsotse nemo b́weyi, ernmó morro bíaytsok'on Ik'i s'aato iki bogsht bíayi. ");
INSERT INTO bwo_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Man b́wowwere k'iratse tuutson morro b́naashtsok'o mank'o ando aani nodoonz Iyesus Krstos weeron dúre dúri kasho b́ daatseyish Ik'i s'aato kasho imon naashituwe. ");
INSERT INTO bwo_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Eshe eebi noeteti? Ik' s'aato bí ayituwok'o morrats kup'ar beyonowa? ");
INSERT INTO bwo_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Woteratse! no k'iron galetsok'o morratse galetswotsi wotefetsr aawk'oneya morratse kup'ar nobeeti? ");
INSERT INTO bwo_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Krstos Iyesusnton ik wotosh gupets jamwots, b́ k'irono kaytswotsi wotosh, no guupetsok'o danatsteya? ");
INSERT INTO bwo_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Gupon bínton noduukeyor b́k'ironowere kaytsuwotsi woterone, mansh Krstos Niho mangon k'irotse b́ tuutsok'o noowere handr beyon beetuwone. ");
INSERT INTO bwo_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","B́ k'iron bínton ik nowottsok'o k'irotse b́tuwon bínton ik wotituwone. ");
INSERT INTO bwo_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","No ats morretso no atse b́tuwituwok'o morrosh guuts nowoto b́ oritwok'o no ats nato Krstosnton jitetsok'o danfone. ");
INSERT INTO bwo_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","K'irts asho morrosh kewewotse nas'o keshre. ");
INSERT INTO bwo_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Eshe Krstosnton nok'iriyakon bínton kashon nobetuwok'o amanituwone, ");
INSERT INTO bwo_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Krstos k'irotse b́tuutsi jangosh gitlo b́ k'irawok'onat k'ironuwere bíyatse alo b́deshawok'o danfone. ");
INSERT INTO bwo_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","K'iroone b́jamon iknoto morrosh k'irre, kashon b́beyonmó Ik'oshe b́beyiri. ");
INSERT INTO bwo_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Mank'o it k'iron k'alwok'o k'alewon morratse it k'aletsok'o Krstos Iyesus weeron Ik'osh kashon itbeyirwok'o taawwere. ");
INSERT INTO bwo_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Mansh morro it ats k'iritwatse alo b́detsetwok'onat it meets tewnosh keewetswotsi itn b́woshitwok'o eekk'ayere. ");
INSERT INTO bwo_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Mank'o it atsi kayuwotsi gondosh k'ac'o woshder morrosh kewik'ayere, ernmó k'irotse tuwat kashetswotsi it wottsok'o woshde'er it tooko Ik'osh t'intsuwere, it atsi kay jamwotsi kááwu finosh k'ac'o woshde'er Ik'osh kewiwere. ");
INSERT INTO bwo_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","And it beyir s'aatoniyere dasha bako nemoniyere dash wot b́k'aztsotse morro itn b́ keewo geyiratse. ");
INSERT INTO bwo_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Eshe eege no eteti? Nemoniyere dash nowoto b́ oorere s'aatoniyere dash wotar morro finone eteya? B́jamon woteratse! ");
INSERT INTO bwo_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Bísh alewosh guutswotsi wotosh it tooko bísh it t'iintsiruwosh, bísh it aleyirwosh b́guutsuwotsi it wottsok'o danatsteya? K'irosh morri guutswotsi wee kááwwotosh aleyi guutswots itne. ");
INSERT INTO bwo_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Itiye shin morrosh guutse it teshi, andmó itsh imets danosh it nibon itazazetsotse Ik'osh údo wotowe. ");
INSERT INTO bwo_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Morrosh guuts wototse nas'o keshat kááawu woti guutswotsi woterte. ");
INSERT INTO bwo_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Taa hank'o ashosh b́wotit noon keew keewon tkeewir ash azeyon maawuk it wottsatsne. Shin shin it atsi kay kayuwotsi bokiimish weeri gondonat nemalon beyosh guutswotsi woshdek'at it t'intstsok'o andoor itatsi kayuwots bo S'ayinetwok'o kááw wotosh guutswotsi woshde'er t'intswere. ");
INSERT INTO bwo_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Morrosh guutso itteshor kááwo fino finosh kic'erak itne b́teshi. ");
INSERT INTO bwo_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Bére, manoor eebi it daatsi? And iti b́ jitsiyiruwoniyere okoon eegor daatsatste, keewhan b́ s'uwo k'ire. ");
INSERT INTO bwo_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Andmó morri guuts wototse nas'o keshat Ik'o guutsuwotsi itwottsotse S'ayin woto daatsitute, weeronwere b́s'uwatse dúre dúri kashe. ");
INSERT INTO bwo_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Morrotse daatset k'awuntso k'ire, Ik'oke imet imonmó nodoonz Iyesus Krstosn daatset dúre dúri kashoniye. ");
INSERT INTO bwo_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Tieshuwotso! han danatsteya? Tkeewir nemo dants ashuwotsshe, nemo ashaatse alo b́ detset asho kashon b́befetso s'uziye. ");
INSERT INTO bwo_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Aab s'iilere mááts amts máátsu b́kenih kashon b́befetsosh bínton nemon tipekiye, bkenih b́k'iriyalmó btipets nemotse s'aynat keshraniye. ");
INSERT INTO bwo_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Mansh bkenih kashon b́befere k'osh kenihosh máátso bi amal widetsuniye bish eteti. Bkenih b́k'iryalmó bínton btipets nemotse nas'o keshetuwane, k'osh kenihosh máátso biamalor widetsuni eteeratse. ");
INSERT INTO bwo_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Ti eshuwotso! it keewonuwere hank'oyiye, it Krstos atsi kaywotsi it wottsotse k'iron k'alewok'o k'alewon nematse k'alerte, mansh Ik'i finon shuwo noshuwitwok'o k'osho k'irotse tuutsosh b́ jirwotsi woterte. ");
INSERT INTO bwo_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Meets shunon ananat noteshor nemon tuwiru morri tewuno k'irosh shuwo noshuwish noatsi kayutsitse finefe b́teshi. ");
INSERT INTO bwo_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Andmó noon tipdek' teshts nemo k'iron galetsok'o no'atse b́ galetsotse nemi tipotse keshrone, mansh haniyere oki bísh nofinit handr shayiri jishona bako shin guut'etsnat wotts nemi jishonaliye. ");
INSERT INTO bwo_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Eshe eebi no eteti? Nemo b́tookon morreya? woteratse! ernmó morro eeg b́ wotok'o nodanish woshtso nemoniye. Nemo «Tewunk'aye» eto b́k'azik'e tewuno eeg b́wotok'o danawuk'e b́teshi. ");
INSERT INTO bwo_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Morro nemoke waats tzaziyon gowo daatsdek't jam naari tewuno ti'atsotse b́tuwitwok'o b́woshi. Nemo bíalink'ermó morro k'irke. ");
INSERT INTO bwo_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Shinon nemo bí aalor taa kashone tbeefoni, nemi tzaziyo b́ watsok'onmó taa tk'irre morro kasho b́daatsi. ");
INSERT INTO bwo_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Kashosh imetso nemi tzaziyo tiats k'iro b́doy. ");
INSERT INTO bwo_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Morro nemi tzaziyo weeb woshdk't taan b́ ant'elci, tzaziyanatse tuutsonowere taan b́úd'i. ");
INSERT INTO bwo_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Mansh nemo S'ayine, tzaziyonuwere S'ayinona, k'ááwonat sheenge. ");
INSERT INTO bwo_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Bére sheeng wotts keewan tiats k'iro dek'waare eteya? Iya'a! ernmó morro, morr wotar b́be'etuwok'o sheeng keewatse tuutson k'iro tiats dek'b́weyi, mansha morro tzaziyatse tuutson iki bog morretso b́woti. ");
INSERT INTO bwo_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Nemo shayiri weero b́wottsok'o danfone. Taamó morri guutso wotosh kemeets meetsik taane. ");
INSERT INTO bwo_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Taa t k'aliruwo danatse, t shunts keewo k'alo k'azat tshit'ts keewo k'alirwe. ");
INSERT INTO bwo_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Eshe taa t k'alir tshunaaw keewoni wotiyal nemo sheeng b́wottsok'o gawituwe. ");
INSERT INTO bwo_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","K'alo tgeeraw keewo k'aliruwo tiatsotse fa'a morroni bako taanaliye. ");
INSERT INTO bwo_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Tigitsotse wee tmeets doyotse eegor sheeng keewo k'alosh falaatsetsee. ");
INSERT INTO bwo_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","K'alosh tgeyiru sheeng keewo k'alratse, ernmó tgeerawu gond keewoniye tk'aliri. ");
INSERT INTO bwo_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","K'alosh t geerawu gond keewoni tk'aliri wotiyal han k'aliruwo tgitsotse fa'o morroni bako taanaliye etee. ");
INSERT INTO bwo_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Eshe nemo finats b́jine bek'etuwe, sheeng keewo tgeefere gond keewo tik'altwok'o taan b́woshiri ");
INSERT INTO bwo_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Tgitsi atson Ik'i nemon geneúwituwe. ");
INSERT INTO bwo_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Wotowa eree nibots nemonton k'efefetst ti'atsotsi kayuwotsitse finiru morri nemosh tipetso taan woshiru k'osho azeewon taan jeep'iruwo ti atsi kayuwotsitse b́ beyok'o bek'iruwe. ");
INSERT INTO bwo_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Aawuk'o woteraw ash taane! k'iritu tiatsanowere kone taan kashiti? ");
INSERT INTO bwo_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","No doonz Iyesus Krstos weeron Ik'osh údo wotowe! Eshe taa tnibotse, Ik'i nemosh keewetso wotat t meets doyon morri nemosh keewetso wotere. ");
INSERT INTO bwo_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Mansh Iyesus Krstosn beeyruwots and boats angshetuwo deshatsno. ");
INSERT INTO bwo_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Iyesus Krstosn datsetuwo kash imetu S'ayn shayri nemo, morronat k'ir dowet nemotse nas'o taan kishre. ");
INSERT INTO bwo_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Ash doyo maawk b́ wottsatse tuutson nemo s'eentsosh b́ falawo Ik'o k'alre, b́took na'onowere morrets meets aron morri jangosh woshat b́ meetson morro angshon ok b́ bazi. ");
INSERT INTO bwo_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Man b́k'aluwere meets shunon b́ woterawo no'atsitsi Shayiri shuntsok'on ananiruwotsats noats nemi tzaziy ariko bí b́s'eentsitwok'owe. ");
INSERT INTO bwo_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Meets shunon beyiruwotsi meets keewo, Shayiri shunok'on beyiruwotsmó Shayiri keewe bogawiri. ");
INSERT INTO bwo_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Meets keewu gawo k'ire b́ doweti, Shayiri gawirúwok'on wotoonmó kashonat jeenone b́imeeti. ");
INSERT INTO bwo_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Meets keew gawo Ik'oke shit'eek b́wottstse Ik'i nemosh bíalerawotse, kewewono maawre, ");
INSERT INTO bwo_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Meets keewosh kéweyirwots Ik'o geneúsho falatsne. ");
INSERT INTO bwo_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Itmó Ik' S'ayn shayiro ititse beyiruwe wotiyal Shayiri shúnona bako meets shunon beeratste, Krstos Shayiro deshaw ashonúwere Krstos jiraliye. ");
INSERT INTO bwo_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Krstos itits b́ wotiyal it meetso morri jangon k'irk b́ wotiyaloru Ik'o itn b́ káátstsotse it shayiro beyar beetke. ");
INSERT INTO bwo_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Iyesusi k'irotse tizts Ik' Shayiro ititse b́beyal, Iyesus Krstosi k'irotse tiztso Izar Izewer it gitsitse beyiru shayiri weeron k'iritk wotts it meetsosh kasho imetuwe. ");
INSERT INTO bwo_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Eshe t eshuwotso! no kashosh kup'o noosh geyife, ernmó noo beyon meets shunok'on beyo noosh geyiratse. ");
INSERT INTO bwo_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Meets shunok'on it beyal k'iritute, ernmó S'ayn Shayiri angon it meets fino it úd'iyal kashon beetute. ");
INSERT INTO bwo_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Ik' Shayiron jisheyru jamwots Ik' nanaúwotsiye. ");
INSERT INTO bwo_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Mansh «Niho! no nihono!» etaat it s'eegirwo na'ok'o woti Shayiro it dek'i bako shatoon beyosh aani guuts woti Shayiro de'atste. ");
INSERT INTO bwo_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ik' Shayiro no Shayironton wotar Ik' nanaúwotsi nowottsok'o noosh gawituwe. ");
INSERT INTO bwo_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Eshe Ik' nanaúwotsi nowotiyakon bín naatetuwots noone, Krstosntonuwere naatetuwone, andowere Krstos gond bek'o kaytsuwotsi nowotiyal maniyere okoon b́ mango kayituwotsi wotituwone. ");
INSERT INTO bwo_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","And gond bek'an shinomaants noosh be'et mangonton b́ taatseyal eegonoru talosh b́ falawok'o woshde tawituwe. ");
INSERT INTO bwo_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Azets jamo Ik' nanaúwots be'ewo een tewunone b́kotiri. ");
INSERT INTO bwo_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Azets jamo k'awunts deshawosh kewewtsere, manwere b́ took shunon b́ woterawo jangde'er b́ kotetwok'o woshts Ik' shunone. ");
INSERT INTO bwo_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Jangiyetsonwere azeetso b́tookon t'afi guuts wototse nas'o kesht Ik'i nana'úwotsnton s'ayinonat mang kayituwo b́wotituwok'oyiye. ");
INSERT INTO bwo_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Azets jamó ik wotat hambetsish b́borfetso na'a it'i kic'on detseyat kash k'as'oke b́beyiruwok'o danfone. ");
INSERT INTO bwo_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Ernmó gúútoke fa'o azeetso s'uziyaliye, S'ayin shayir shintso imets dek'tsuwots noworu no atsi shegr wottso Ik'o nana'ok'o woto kotfetsat nogitsitsi atson gúútoke nofa'oni, ");
INSERT INTO bwo_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","No noworiye jangiyetsanne. Ernmó no no jangiru keewo be'etka wotiyal jangeet keewo b́woto oorituwe, be'eyiruwonere kone jangiti? ");
INSERT INTO bwo_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Nobe'aawu keewo nojangiyalmó k'amoon kotetuwone. ");
INSERT INTO bwo_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Mank'owere awuk'o Ik'o k'ono noon b́geiyitsok'o nodanaawotse S'ayin shayiro nomaawóko noon tep'etuwe, noonon kish keewo falerawo gúúton noosh Ik'o b́k'oniri. ");
INSERT INTO bwo_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Ash nibo shuu'at s'iliruwo Izar Izewer S'ayin shayiri asaabiyo eeg b́wottsok'o danfee, S'ayin shayiro amantsuwots jangosh Ik'o b́ k'onir Ik'i shuntsok'one. ");
INSERT INTO bwo_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Ik'o shuntswotsnat b́shuntsok'onowere s'eegets ashuwots Ik'o jam keewo sheengosh boosh b́k'alituwok'o danfone. ");
INSERT INTO bwo_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Shin b́dantsuwots b́ naayi araar b́ na'onúwere eshu ayuwotsitse k'aab b́wotituwok'o Ik'o shino wotituwe bíettsotsne. ");
INSERT INTO bwo_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Shino wotitune bíettsuwotsi b́s'eegi, b́s'eegtswotsnowere kááwu b́woshi, kááwu b́ woshtsuwotsnowere b́ mangiyi. ");
INSERT INTO bwo_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Eshe keewan jangosh eege noeteti? Ik'o noonton b́wotitka wotiyal kone noon k'efo faliti? ");
INSERT INTO bwo_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Ik'o b́ naay ik s'uzosh maac'o b́k'ewerawo noosha ett bíimiyakon b́ naaynton jamkeewo beenon aawuk'oneya noosh ímo b́k'azeti? ");
INSERT INTO bwo_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Ik'o galb'dek'tsuwotsi kone s'aamituwoni? Boon kááwwotsi woshituwo bíne. ");
INSERT INTO bwo_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Kone angshituwoni? Bí noshegro k'irre, k'irotse tuut Ik'o niho k'ani aaromants beedek'tso, nooshowere Ik'o k'onirwo Krstos Iyesusiye. ");
INSERT INTO bwo_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Krstos shunatse noon k'álo falituwo kone? Kic'eemó, gondbek'e? Gishee himó k'ak'e? Himó araats wote, t'up'ertawemó? Shike? ");
INSERT INTO bwo_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Hanwere «N jangosh aaw jamó noone úd'eyiri, Shukeyiru mereerwotskok'o taa weerone» Ett guut'etsok'one. ");
INSERT INTO bwo_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Eshe noon shuntson bín keew jamanotsida'adek'on da'atswotsiyere bogfone. ");
INSERT INTO bwo_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Mansh k'iro b́wotiyalor, kasho b́wotiyalor, melakiwotsi bowotiyalor, naashuwotsnor bowotiyal, andfa'o b́wotiyalor, shutsi weetuwo b́wotiyalor, kup'uwotsi bowotiyalor ");
INSERT INTO bwo_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","Danbaan tuuka wotiyalor, dashaanowere gop'awotiyalor, kon naaro wotowa azeetso wotiyal no doonz Iyesus Krstosn nodaatsts Ik'i shunotse noon k'álosh falituwo eegonwor biaalok'owo arikon dandek'roone. ");
INSERT INTO bwo_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Krstosn arikoniye t keewiri, kooratse, S'ayn shayiron t nibonúwere tkorawok'o taash gawirwe. ");
INSERT INTO bwo_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Een shiyanonat k'ut'eraw kic'on t nibotse fa'ee, ");
INSERT INTO bwo_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Meetson t jag wotts tjiruwotssha err taa Krstosatse k'aleyar Ik' c'asho tiyats b́bodink'e shunfee b́teshi. ");
INSERT INTO bwo_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Boye Israe'el ashuwotsiye, na'ok'o wotonat mangi wuliyo nemono b́imi, aron Ik'o bo ik'itywok'ono b́kitsi, b́ jangits keewo bíimi. ");
INSERT INTO bwo_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Amants nihwotswere bokne, Krstos meetson b́wáá bo naarotsne, bíye jamoniyere dambe. Bíwere dúre dúrosh deeretso Izar Izeweriye. Amen! ");
INSERT INTO bwo_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Wotowa eree Ik' aap'tso wonere etaliye, Israe'el naar jamwots ari Israe'el ashnaliye. ");
INSERT INTO bwo_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Mank'o Abraham naar jamo Abraham nanaúwotsiye etaliye. Ik'o Abrahamsh «N naaro b́ keshetiye Yisak'ne» bíettsoshe, ");
INSERT INTO bwo_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Mansh meetson shuwetswots Ik' nanaúwotsiyaliye, ernmó naaro wotar taawetuwots Ik'o Abrahamsh b́jangitsok'on shuwetswots s'uziye. ");
INSERT INTO bwo_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Hanuwere Ik'o b́jangits aap'otse «Hambets naton hank'o aawon weetuwe, Sara nungush na'o shuwitwane» etke b́teshi. ");
INSERT INTO bwo_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Man mec'ro b́ woterawo Rbk'aa naruwotssh niho wottsosh Yisak'sh nungush nana'a maatúwotsi b maac'ro, ");
INSERT INTO bwo_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Ik'i marat' marat'o finon b́woterawo b́s'eegon b́woto kitsosh git nan'úwots boshuwewonat gondonowere sheengonowere bok'aloniyere shino ");
INSERT INTO bwo_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Ik'o Rbk'ash «Eenfo múk'efosh keewek wotituwe» bí eti. ");
INSERT INTO bwo_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Manúwere «Yak'obi shunre Esawunmó shit're» ett guut'etsok'one. ");
INSERT INTO bwo_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Eshe eege noeteti? Ik'o boga bogshirwe eronowa? B́jamon mank'o woteratse! ");
INSERT INTO bwo_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Ik'oniye Musesh «Bísh doosh tgeyruwosh doowituwe, bísh maac' k'ewo tgeyiruwoshowere maac'o k'ewituwe» etre. ");
INSERT INTO bwo_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Eshe Ik'i marat'o b́daatset ash shunonat ash finon b́woterawo Ik' dowon b́wottsatsne. ");
INSERT INTO bwo_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Manatse tuutson S'ayin mas'aafotse Gbs' nugúsosh «Neen tiango kitsr tshútsonowere dats jamatse b́daneetuwok'o woshosh neen naashiyire» ett aap'etso guut'ere. ");
INSERT INTO bwo_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Mansh eshe Ik'o b́shuntsosh maac'o k'ewefe, b́shuntsonowere k'el kúp'etso woshituwe. ");
INSERT INTO bwo_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Eshe «Ik'i shunts keewo k'efosh konuwor falratse, béré bí ashuwots bo shuntso bo fintsosh eegishe boon b́ b́s'aamiyiri» err taan aato falfete. ");
INSERT INTO bwo_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Nee ashono! Ik'onton mooshosh eegoneya nfali? Shalon dozets k'ac'o bín dooztsosh «Eegishe hank'o kaldek'at taan ndoozi?» etosh falituwa? ");
INSERT INTO bwo_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Eshe shal wozirwo iknaari shali tok'ootse k'ac iko mangosh, k'oshonowere ketts finosh woshde wozosh alo deshatsá? ");
INSERT INTO bwo_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Ik'o b́fayo kitsosho bíangonowere bek'shosh geeyat t'afiyosh k'antsuwotsi fayi k'ac'uwotsi ayoto k'amare wotiyal eendani? ");
INSERT INTO bwo_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Han b́ k'aluwere shin mangosh b́k'anitso sheeng b́woto dek'ets k'ac'uwotssh b́mangi ayo kitsoshe. ");
INSERT INTO bwo_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Sheeng b́ woto dek'ets k'ac'uwotsnmó ayhudiwots mec'rotse b́woterawon Ik'i ash woterawwotsitsnowere noon s'eegree. ");
INSERT INTO bwo_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Hanwere nebiyiyo Hose'n hank'o eteetsok'one, «Tiash teyawuwotsne ‹Tiashuwotsi› err s'eegetuwe, Shuneerawu ashuwotsnowere ‹Shuneeka› err s'eegetuwe, ");
INSERT INTO bwo_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Itiye ‹Tiashuwots itnaaliye› eteets beyokoke ‹Beyat beets Ik'o nanaúwotsi› err boon s'eegetuwe.» ");
INSERT INTO bwo_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Isayasuwere Israe'el jangosh hank'o eton b́ k'ááro eenshdek'tine b́keewi, «Isra'el nanaúwots taawo aats k'aritsi shiyok'o dab bíayiyaloru boyitse kashituwots múk'nee. ");
INSERT INTO bwo_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Doonzo b́ ja'arawo kááronat s'eenon bí angsho imetwe.» ");
INSERT INTO bwo_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Mank'owere Isayas «Dari jirwotssh doonzo shooko noosh oriyo b́k'azink'ere Sedom kituk'o wotiyank'one b́teshi Gemor kitukok'o wotiyank'one b́teshi» ett shin shin keewure. ");
INSERT INTO bwo_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Eshe eege no keewiti? Kááwi weero sha'erawu Ik'i ash woterawwots kááw woto bodaatsi, kááwo wotonwere amanar daatsetuwoniye. ");
INSERT INTO bwo_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Ernmó kááw woto daatsit nemo shuuts sha'at teshts Isra'elots, nemo s'eentsosh bomawutsotse kááwok boratsne. ");
INSERT INTO bwo_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","«Eegoshe kááwok bodobok'azi?» eteyala bo kááw wottso daatsosh boge amanon b́woterawon finon b́wottsotsne, manshe t'ugwotsn bo k'is'eyi. ");
INSERT INTO bwo_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Manuwere «Hambe! ashuwotsi k'is'iru shútso S'iyonits beezree, Shútsanuwere ashuwotsi k'ic'de'er dikitu s'aloniye, Bín amanituwonmó jiitsratse» ett guut'etsok'one. ");
INSERT INTO bwo_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Ti eshuwotso! t maac'otse beyiru een tewunonat Ik'o maants t t'intsiru k'onon Israe'el ashuwots bokashituwok'owe. ");
INSERT INTO bwo_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Ari danon woto b́ k'aztsosha bako bo Ik'osh okooro bo detstsok'osh taa boosh gawituwe. ");
INSERT INTO bwo_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Ik'o ashuwotsi kááw b́ woshit weerindo bodartsotse bo took kááw weerona bosha'i bako Ik' kááw weeron sha'eratsnee. ");
INSERT INTO bwo_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Ash jamo imnetiyon kááwo b́ wotish nemi s'uwo Krstosiye. ");
INSERT INTO bwo_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Nem kotón daatset kááw woto Muse b́ guut'tso «Nemo fenats jitsiru jamo kashon beetuwe» etiruwoniye. ");
INSERT INTO bwo_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Ik'o ashuwotsi imnetiyon kááw b́ woshtsok'onomó hank'o ett guut'ere, «N nibon daro maants kone kesheti?» etk'aye, hanúwere Krstosi orshoshe, ");
INSERT INTO bwo_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Wee n nibon «Si'olits kone ot'eti?» etk'aye, hanúwere Krstosi k'irotse tizoshe. ");
INSERT INTO bwo_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Dabtnu hank'o ett guut'ere, «Ik' aap'tso n ganoke, dab nnononat n maac'otse,» keewanúwere no nokeewiiru imneti aap'oniye. ");
INSERT INTO bwo_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Iyesus doonz b́wotok'o nnonon ngawiyal, Ik'o k'irotse bín b́tiztsok'o n maac'on niamaniyal kashitune. ");
INSERT INTO bwo_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Asho b́ maac'on amanar kááwituwe, b́nonon b́ gawiyal kashituwe, ");
INSERT INTO bwo_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","S'ayn mas'aafotse guut'etsok'on, «Bín amants jamo jitseratse.» ");
INSERT INTO bwo_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Eshe ikosh doonz wottso jamosho doonz b́wottsosh ayhudiyonat ayhudiy woteraw dagotse eegoru k'osh k'osheyo aaliye, bín k'oniru jamosh b́s'aato ayide'er imetuwe, ");
INSERT INTO bwo_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","«Doonzo shúúts s'eegiru jamo kashituwe» eteere. ");
INSERT INTO bwo_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Ernmó bo amaneraniyere aawuk'oneya s'eegosh bofaliti? B́ jango booshiyaniyere aawuk'oneya bo amaniti? Nabirwo alonomó aawuk'oneya shishosh bo faliti? ");
INSERT INTO bwo_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Nabirwotsi wosheerawonomó aawuk'oneya nabosh bo faliti? Hanuwere, «Doo keewuman shishituwots wáá woo awuk'owe b́geneúshiti!» ett guut'etsok'one. ");
INSERT INTO bwo_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Ernmó Isayas, «Doonzono! no no aap'tso kone amani» ett b́ keewtsok'o, jamwots doo shishiy keewo de'atsne. ");
INSERT INTO bwo_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Eshe imnetiyo b́ daatset k'ebokne, k'ebetuwonúwere Ik'i aap'otsoniye. ");
INSERT INTO bwo_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Aab aatuna, eshe, b́ keewts keewo shiyatsno eteya? S'ayin mas'aafotse, «Bo k'aro dats jamats b́shiyeyi, Bo aap'ts aap'onuwere dats daarats b́ bodi» ett guut'etsok'on, arikon shishrne. ");
INSERT INTO bwo_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Israe'el ashuwots b́ aap'tso danatsno eteya? Han eterawok'o Muse shinon «Gac'ets ash ashon okoriyat itn tgoyni, T'iwitsrawu ash ashon itn tfayi» eteere. ");
INSERT INTO bwo_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Isayasuwere, «Taan geerawwotssh tdatseyi, ‹Ik'o aawoke?› ett Taan aatrawwotssh tbe'eyi,» ett ááwushúk'on keewure. ");
INSERT INTO bwo_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Israe'el ashuwotsshomó «Azazerawonat gond ashuwots tmaants boweetwok'o aawu jamo tkishuwotsi t jargi» etre. ");
INSERT INTO bwo_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Aab́ dab neen aatuna, Ik'o bí ashuwotsi juuwera? B́ jamon juweratse! taa ttookon Israe'el ash taane, Abraham naaro wotat Bíniyam jirots taane. ");
INSERT INTO bwo_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Ik'o shini b́ marat'ts ashuwotsi juweratse, S'ayn mas'aafo Eliyas jangosh eeg bíettsok'o gawatsteya? Dab Eliyas Israe'el ashuwotsi Ik' shinatse awuk'o ett b́ s'aamitsok'o danatsteya? ");
INSERT INTO bwo_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Manoor Eliyas «Doonzono! nebiyiwotsi úd'rne wosh t'intseyiru t'arap'ezono gaakrne, ts'uziye oori, taano úd'oshe bogeyiri» etre b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Ernmó Ik'o eega ettniya bísh bíaani? «Ba'ali eteets dozets ik'osh tuk'umalerawo shawat kúm ashuwotsi ttokish ooridek're» etre bísha. ");
INSERT INTO bwo_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","And dúranatse b́wotsiyal, s'aaton marat'ere ortsuwots muk' Israe'el ashuwots fa'ane. ");
INSERT INTO bwo_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Marat'onwere s'aaton b́ wotiyal finonaliye etee, finon b́ wotiyal, s'aato s'aat b́ woto orerere etee. ");
INSERT INTO bwo_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Eahe b́ k'awuntso eebi b́wotiti? Esra'el ashuwots bogetso datsatsno, marat'etswotsmó bo geyiruwo daatsrne, oortsuwotsmó bo maac'o bokup'i. ");
INSERT INTO bwo_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Hanuwere «Ik'o bo nibo b́ dúngiyi, mansh eshe hambetsish b́ borfetso bo ááwo be'atse, boowazonuwere shiyatse» ett guut'etsok'one. ");
INSERT INTO bwo_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Dawitwere, «Bomishi maronu detset kambo, dikit gop'o wotar boon kic'ituwe! bofiniru gond fino botokats boree! ");
INSERT INTO bwo_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Bo ááwo b́ be'awok'o t'aluwowe, bojik'o gond bek'on jam aawo k'urowe» etre. ");
INSERT INTO bwo_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Aab́ aani neen aatuna, ayhudiyots bodihi aani boturawok'o wotatniya? Mank'owaliye! ernmó ayhudiyots gondo bo fintsi jangosh Ayhudi woterawwots kasho bodaatsi, han b́wotiye ayhudiyots Ayhudi woterawwotsi bo ookoritwok'o woshoshe. ");
INSERT INTO bwo_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Ayhudiyots gond fino dats jamosh deero datsire, bodiho Ik' ash woterawotssh deero wotere, Ayhudi jamwots bookashink'ee deero awuk'o aye b́wotiyank'oni! ");
INSERT INTO bwo_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","And nokeewir itsh Ik' ash woterawwotsshe, Ik' ash woterawwotssh wosheetso twottsok'osh t finosh mango taash shiyeetuwe, ");
INSERT INTO bwo_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","T meets jag wotts ayhudiwotsi okooriyoshe, mank'onowere daneraka ik ikuwotsi kashiyo falituwe etee. ");
INSERT INTO bwo_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Ik'o boon b́ juwoor datsatsi ash k'oshuwots Ik'onton b́ manetka wotiyal Ik'o boon b́ dek'or eeg b́wotituwok'o arefa? Haniyere k'irotse tuwok'oyi etee! ");
INSERT INTO bwo_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Ik naari boot'otse shintsotsi kayo S'ayinka wotiyal boot' jamo S'ayinkee b́ wotiti, mank'o mit iko b́s'ap'o S'ayina wotiyal b́ jabwotswere S'ayine bowotiti. ");
INSERT INTO bwo_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Worfitsi woyra eteyiru mit jaabo wotts ayhudiyots k'ut'eyar bodihitka wotiyal it boditsi woyiriy mit jaabo wotts Ik' ash woterawwots bo shegro shááto shegrshr weyiri zeyito bítse b́keshiru s'ap'ootse keshiru gaalonat deeron kaytsuwotsi itwotiyakon, b́ jaabwotsats ít'k'ayere. ");
INSERT INTO bwo_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","It Ik' ash woterawotso jaabwotsats ít'k'ayere, it it'alomó it jaab mec'ro it wottsosh s'ap'oni itn kuriti bako it b́ s'ap'o kurirwotsi itwoterawok'o dande'ere. ");
INSERT INTO bwo_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Ernmó «Jabúwots tishat bodihi, taa bo beyok tikinditwok'o» etaatne b́ teshi. ");
INSERT INTO bwo_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","It ettso aree, ernmó bo k'ut'at bojuwe amano bok'aztsosh b́ wottsotse itwere k'up'at it ned'iye itamantsoshe, eshe, shata bako hit'o itn geyiratse. ");
INSERT INTO bwo_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Ik'o azeewon jaab wotts ayhudiyotssh maac'o k'ewo b́ k'aziyakon itsh maac'o k'eweratse. ");
INSERT INTO bwo_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Eshe Ik' doowonat Ik' shatiyon aab s'iilere, b́ shatiyonu b́kitsir dihitswotsats b́ wotor b́ doo wotonu b́ kitsir itshee, hanowere b́k'alir b́ dowon k'up'ar it betka wotiyalemó b́ doo itsh wotituwe, kup'o itk'azalomó itwere k'ut'eyarniye it dihiti. ");
INSERT INTO bwo_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Ayhudiyots bo amaniyal yoots bobeyok aanitune, Ik'o yoots bobeyok boon aaniyosh falituwe. ");
INSERT INTO bwo_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","It Ik' ash woterawwotsmó azeyon boditsi woyiri miti jaabo wotat teshtsuwots it beyokalo worfotsi woyiri mitats tokeyo it faliyakon hanots bo azeyon worfitsi woyiri miti jaabo wotts ayhudiyotsmó yoots bobeyok aanar tokeyo aawuk'oneya boosh b́ maaweeti! ");
INSERT INTO bwo_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Ti eshuwotso! «Danfone» err it'k'ayere itsh tkeewitwo ááshts keewo fa'ee, bíwrer Israe'el ashuwots k'azts woto b́ jamosh b́woterawo Ik' ash Woteraw jamwots s'eenon Ik'ok bowafetsoshe. ");
INSERT INTO bwo_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Eshe hank'on Israe'el asha ash jamwots kashitúne. Mansh hank'o ett guut'ere, «Kashituwo S'iyonn weetuwe, Yak'ob naar jamatse gondo wokiituwe, ");
INSERT INTO bwo_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Bomorro boosh t t'afiyor bonton tkindit taaro haniye.» ");
INSERT INTO bwo_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Israe'el ashuwots doo shishiyosh aap'etso dek'o bok'aztsotse, itjangosh it Ik' ash woterawotssh b́dooyish Ik'osh balangaro bowoti, bomarat'ewonmó nihiwots jangats tuutson Ik'o boon shunknee. ");
INSERT INTO bwo_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Ik'o noon marat'de'er b́ deero bí imiyakon b́ k'alts keewumansh b́gawtso woniratse. ");
INSERT INTO bwo_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","It Ik' ash woterawwots shin Ik'osh alerawwotsiye it teshi, andomó ayhudiyots aleyo bok'aztsotse it Ik' maac' k'ewo it datsi. ");
INSERT INTO bwo_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","It maac' k'ewo it daatstsok'on boowere maac' k'ewo bodatsituwok'o boowere and Ik'osh alerawwotsi woterne. ");
INSERT INTO bwo_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Ik'o b́ maac' k'ewo ash jamosh kitsosha ett ash jamwotsi ale k'azon is'k'reroshná. ");
INSERT INTO bwo_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Ik' gaalona, dani teleefonat danoonúwere awuk'o eene! bí angsho fal bíats boderake, b́ werindonu danerake. ");
INSERT INTO bwo_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","«Ik' hasabiyo danetuwo kone? Bísh iztsi wotituwonmó kone? ");
INSERT INTO bwo_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Ik'osh gushituwonat b́ gushitsono dek'etuwo kone?» ");
INSERT INTO bwo_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Jam keewo b́ daatse bíyokne, jam keewo bíne b́beeti, jam keewo bíshe b́ beeyeti, dúre dúron mango bísh wotowe! Amen! ");
INSERT INTO bwo_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Eshe eshuwotso! Ik'o genee'úshitwo, beyar beetwonat S'ayin wosho woshde'er it atso it t'intsitwok'o maarts Ik'o shútson itn k'onirwe. Manowere t'intso itn b́ geyitso ari Ik'osh finet finoniye. ");
INSERT INTO bwo_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Sheengonat genee'úshitwo kim deshawonowere Ik'o shuntso fadbek'o it falitwok'o it nibi gawirwon handraar, it beyo woneewa bako datsani ark'ayere. ");
INSERT INTO bwo_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Aaninuwere it ik ikets Ik'o itsh b́imts imnetiyok'on tooko dashan detson asaabore bako it angoniyere danb it tookosh bogotaane err asaabk'ayere ett taash imets s'aaton keewirwe. ");
INSERT INTO bwo_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","No ats ikatse ay kayuwots fa'ane, noatsi kay ik ikonuwere k'osh k'osh fino detsfe. ");
INSERT INTO bwo_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Mank'owere noo ayuwotsi wotat nobefere Krstosn ik ats noone, ik atsi kayuwotsi nowottsok'on noatsatsewo desheeknone. ");
INSERT INTO bwo_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Mansh Ik'o b́ s'aaton noosh b́ ímts k'osh k'osh naari deero finats jiitswone, noosh imetso Ik'o aap'ts keewa wotiyal no amantsok'on Ik' aap'tso keewwone. ");
INSERT INTO bwo_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Noosh imetso k'oshwotssh fina wotiyal kup'ar finone, noosh imetso daniya wotiyal sheengshde'er daniwone, ");
INSERT INTO bwo_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","noosh imetso iza wotiyal izwone, noosh imetso tuwdi dowawotiyal nib s'eenon imone, noosh imetso ashuwotsi k'eeza wotiyal kup'ar k'eezwone, noosh imetso mihretiya wotiyal hanowere gene'on k'aluwone. ");
INSERT INTO bwo_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Git alber deshaw ari shunewo t'ut'k'ayere, gond keewo shid'ere, sheeng keewi shuutso sha'ore. ");
INSERT INTO bwo_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","It ats atsewo eshuwwots shunon shunewere, it ats atsewosh mango imosh nohewere, ");
INSERT INTO bwo_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","mawuk'ayr, Shayron aat'iruwotsi wotoore, doonzosh keewewere. ");
INSERT INTO bwo_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Jangiyetson gene'owere, gond bek'o k'amoore, jam aawo Ik'o k'onwere. ");
INSERT INTO bwo_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Amants eshuwotsi bokic'or te'úwere, ibwotsno ibíewre. ");
INSERT INTO bwo_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Itn gishirwotsi deerwere, derwere bako c'ashk'ayere. ");
INSERT INTO bwo_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Geneúwirwotsnton gene'ore, epiruwotsnton efere. ");
INSERT INTO bwo_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","It ats atseyo ik hasabiyon ikwotar beewere, it tooko danbaan deshr bog taana eto k'ayr t'owwotsnton ik wotar beewere. It tookosh danfone etk'ayere. ");
INSERT INTO bwo_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Ash jami shinats sheeng wotts keewo k'aluwere bako, ashuwots itats gond keewo bok'aliyal, it aanide'er gondo boosh k'alk'ayere. ");
INSERT INTO bwo_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Itsh b́ faleyal ash jamonton jeenon beyosh it weeron it falitu jamo k'aluwere. ");
INSERT INTO bwo_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","T jirwotso! fayo Ik'osh k'ayere boko it it tookon weero oorshk'ayere, «Weer weershtwonat weer worshi gushono anituwo taane etfe Doozo Ik'oni» ett guut'ere. ");
INSERT INTO bwo_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Mansh weer worshoniyere n balangaro b́k'ak'iyal mazuwe, b́shashuwiyal shashuwo kishwe, hank'o n k'aliyal goyinar b́ jitsituwok'o woshitune. ");
INSERT INTO bwo_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Mansh gond keewo sheeng keewon da'úwere boko gond keewon da'ek'ayere. ");
INSERT INTO bwo_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Konuworu naash wottso b́ daatsit Ik' shunon b́ wottssotse and datsk'eziruwots bo naash Ik'on b́ wottsotse ash jamo naashwotssh alewo bísh geyife. ");
INSERT INTO bwo_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Mansh naashuwotsi k'efitu jamo Ik' aloniye b́k'efiri, aleraw jamonuwere sezi angsheyo b́ tookats dowetuwe. ");
INSERT INTO bwo_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Dats k'eziruwotsi shatet gond finirwotsi bako sheeng finiruwotsiyaliye, naashuwotsi shat k'azo geefneya? Bére sheeng fino finowe, booke údo daatsitune. ");
INSERT INTO bwo_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Naasho neesh sheengo b́ k'alituwok'o naashiyets Ik' guutsoniye, dats k'eeziruwo shiki gorado bí'ed hank'on woto b́k'aztsotse gond fintso nwotiyal dats k'eeziruwo share, bíwere gond finiruwotsi sezosh Ik' weer wershono kitsr Ik'osh finitune. ");
INSERT INTO bwo_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Mansh mengst naashuwotssh alewo itsh geyife, it aletwere Ik' fay mec'ro shatoon b́ woterawo it nibo itn b́ gac'ituwosh woto geyituwe. ");
INSERT INTO bwo_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Ereero it imiru manshe, naashuwots finan finosh botuu Ik'osh finoshe. ");
INSERT INTO bwo_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Eshe danbi naashuwotssh k'alo geyituwu jamo k'aluwere, ereero bísh wotituwosh ereero, t'ilisho bísh wotituwosh t'ilisho imere, shatetwono sharere, mango bísh wotituwosho mango imere. ");
INSERT INTO bwo_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Kon k'awuntsonúwor itatse beek'aye, itatse beeyet k'awuntsoniye itats atseyo shúnee mec'r wotowe, ash shunetuwo nemo finats jitsre. ");
INSERT INTO bwo_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","«Wido amk'aye, úd'́k'aye, úmp'k'aye, k'osh ashk wotts keewu jamo tewunk'aye» etiru tzaziyotsnat k'osh tzazi jamwots, «Asho ntookok'o woshde'er shune» etiru ik tzaziyotse ko'eyat bofa'oni. ");
INSERT INTO bwo_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Ash shuniru jamo b́ shuniru ash manats gond keewo k'alatse, mansh ash shuniruwo nem jamo finats jitsre etee. ");
INSERT INTO bwo_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Eshe tokrotse it tuwit sa'ato and b́bodtsok'o dande'ere, shini noamanortsoniyere bogo and no kashit aawo iki nomaants t'inre. ");
INSERT INTO bwo_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","T'úwonu beshe b́ beshiri, aawonu t'inree, eshe t'aluwotse fineyiru finon fink'ayone, sháánon bin finet kes'i tahono tahade'one. ");
INSERT INTO bwo_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Weral míshon, mashon, widonat máátsonat nungushi iko ikats keshon, fayonat okooron b́ woterawo aawu shanon beyiruwu ashuwotskok'o s'ayinon sha'owone. ");
INSERT INTO bwo_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Eshe Doonzo Iyesus Krstosi tahade'ere bako it meets shuni shashuwo kishosh gawuk'ayre. ");
INSERT INTO bwo_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Ititse b́ imnetiyon maawuk wotts asho b́ keewo de'ere bako b́ took asaabiyats moosho tuuzk'ayere. ");
INSERT INTO bwo_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Dab ash iko konnari keewo móósh faliyit imnetiyo detsetwe, b́ imnetiyon kup'eraw ashonmó worfi maay mec'ro meetuwe. ");
INSERT INTO bwo_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Mansh jam keew meyiru asho mááraw asho gac'k'aye, máárawonwere meet asho ats angshk'aye, Ik'o bínowere dek're. ");
INSERT INTO bwo_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Bére, ash k'oshi guutso ats angshiruwan nee kone? Bí b́ need'iyal wee b́ dihiyal b́ doonzo kis'e. Dab Ik'o bín need'iyo b́ falituwotse kup'ar need'ituwe. ");
INSERT INTO bwo_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Mank'o aawu iko aawu ikoniyere bogo mangfe et gawiruwo beyo falituwe, ando k'oshonu aawu jamwots mango taale bako aawwotsitse bogabogo aaliye ett asaabirwe. Eshe hanan arts keewwotsatse asho ik ikon b́nibots bíamantsok'o woshuwe. ");
INSERT INTO bwo_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Ik aawo k'osh aawoniyere bogshde'er mangiyituwo b́ beyal han b́ k'alirwe doonzo mangosha ettniye, jam naari mishono meyiruwo doonzo mangosha etniye b́meyiri, b́ meyiru mishosh Ik'o údituwe, jam naari mishono marawo doonzo mangosha err maratse, maa b́ k'aztsotsno Ik'o údituwe. ");
INSERT INTO bwo_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Noyitsere ikonuworu b́ kashon wotowa b́ k'iron b́tokkaliye. ");
INSERT INTO bwo_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Nobeyalo doonzosha nobeeti, no k'iriyalo doonzosha no k'iriti, eshe nobeyalo, nok'iriyalo doonzok noone, ");
INSERT INTO bwo_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Eshe Krstos k'irt k'irotse b́ tuu kashon betuwotsnat k'irtsuwotssh doonz wotoshe. ");
INSERT INTO bwo_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Bére, nee n eshuwats eegoshe n angshiri? Wee ni eshuwi eegishe n gac'iri? No únets Ik' angshi jori shinats ned'ituwone. ");
INSERT INTO bwo_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Manwere, «Taa kashon betuwo taane etfe Ik'oni, Ash jamo b́ gurbon tshinatse tuk'umalituwe, B́ alberon taa Ik' twottsok'o gawituwe» ett guut'ere. ");
INSERT INTO bwo_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Eshe notook tookon no took fini jangosh Ik' shinats t'inr aatetwone. ");
INSERT INTO bwo_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Eshe iko ikats angshk'aye, ernmó asho b́ eshuwsh weratse kambo wee t'úgo gedk'azosh no atso korde'one. ");
INSERT INTO bwo_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Ik keewo kiime err asaabiru ashosh keew man kima b́ wotiti bako kon naari keewonworu b́ tookon kim b́ woterawok'o taa doonzo Iyesusn t'iwintsdek' danre. ");
INSERT INTO bwo_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Nee n meyiru mishi jangon ni eshush t'ugo n wotiyal shúnonaliye nbeyiri, eshe Krstos bísh b́k'irts asho n meyiru mishi jangon b́ t'afitwok'o woshk'aye. ");
INSERT INTO bwo_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Eshe itoke sheeng keew wotts keewo k'oshuwots bok'efetuwok'o woshk'ayere. ");
INSERT INTO bwo_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Ik' mengsto S'ayin shayiron datsetsetk kááwe, jeenonat gene'ona bako, móónat úshi keewaliye. ");
INSERT INTO bwo_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Han jangosh Krstissh guuts wotts asho Ik'o geneúshituwe, ashoknowere údeek wotituwe. ");
INSERT INTO bwo_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Eshe jeenwoto bín datsetuwonat no ats atseyo bín nokup'it keewon sha'owone. ");
INSERT INTO bwo_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Mishi jangosh Ik' fino gakk'ayone. Mish jamo s'ayine, ernmó k'osh ashosh t'ug wotitu mish móó dáree. ");
INSERT INTO bwo_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Eshe ni eshúsh t'úg wotk'azosh meetso maak'azo, Weyinyon dútsets biro úsh k'azo, wee kon naari t'ug wotituwo fino fin k'azo sheenge b́ wotiti. ");
INSERT INTO bwo_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Eshe imnetiyan itnat Ik' dagots wotowe, err n amants keewo b́k'alor b́ maac'o bín b́gac'erawu asho údekee. ");
INSERT INTO bwo_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","B́ amaneraniyere meyiru ashonmó b́ k'aliruwo imnetiyatse tuutson wot b́ k'aztsosh bíyats angshetuwe, imnetiyon k'aleraw keewu jamo morre. ");
INSERT INTO bwo_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","No imnetiyon kúp wottswots, mawirwots kuro kurdek'o geyife bako no took mec'ro geneúshitu woto geyiratse, ");
INSERT INTO bwo_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","no took tookon k'osh asho b́ imnetiyon b́ kup'ituwok'o bín t'ak'amituwonat geneúshit keewo k'aluwone. ");
INSERT INTO bwo_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Krstos b́ tooko geneúshratse, dab «Ashuwots neen boc'ashts c'asho ti'ats b́ oot'i» etiru S'ayn mas'aafotse eteetso bí ats b́ bodi. ");
INSERT INTO bwo_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","S'ayin mas'aafotse nodatsituwots k'amonat kup'on, noosh jángo b́beetuwok'o shin guut'ets jamo dano noosh b́ wotituwok'o guut'ere. ");
INSERT INTO bwo_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","6","Ik níbon wotde'er ik noonon Ik'o nodoonz Iyesus Krstos nihi, bín it mangitwok'o, k'amikonat angi kúp'iko Ik'o Izar Izewer Krstos Iyesus shunok'on it atsatsewo ik níbetsuwotsi woto itsh ime. ");
INSERT INTO bwo_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Krstos Ik' mangosh itn b́ dek'tsok'o it jamets iko iko de'e. ");
INSERT INTO bwo_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Hanowere t keewor Ik'o shints nihuwotssh b́ jangitso b́ wotituwok'onat Ik'o arikeewets b́ wotonwere b́ danetuwok'o Krstos ayhudiyotssh guutso wotere etee. ");
INSERT INTO bwo_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Krstos ayhudiyots guutso b́ wottso k'osh jango Ik' ash woterawwots Ik'o b́ mhretiyosh bín bo údituwok'owe, hanuwere, «Eshe Ik' ash woterawwots dagotse neen udituwe, n shúútsosh dubon údo t'intsituwe» ett guut'etsok'one. ");
INSERT INTO bwo_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Aaninu «It Ik' ash woterawotso, Ik' ashuwotsnton gene'owere!» ett guut'ere. ");
INSERT INTO bwo_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Aaninuwere, «Ik' ash Woteraw jamwots! doonz údoore, Ash ash jamwotswere údoore!» ett guut'ere. ");
INSERT INTO bwo_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Ando Isiyas, «Iseyi naarotse shuwetuwo weetuwe, Ik' ash woterawwotssho jishituwo wotar tuwituwe, boowere bojangtso biyats woshdek'etune» etfe. ");
INSERT INTO bwo_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","It jangtso S'ayin shayiri angon eenfere b́ ametuwok'o jangetso Izar Izewer bín it amanetsosh gene'únat jeenon s'eenon itsh ime. ");
INSERT INTO bwo_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Ti eshuwotso! doo woton s'eentsuwotsi, danon gaaltsuwotsnat it ik iketsuwots k'osho izosh falituwotsi itwottsok'o danre. ");
INSERT INTO bwo_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Ik ik keewwotsi itsh gawiyosh geeyat woshan Ik'o taash b́ imts s'aatok'on ááwushuk'on itsh guut're. ");
INSERT INTO bwo_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Deeranuwere taash b́ime Ik'o doo shishi keewo Ik'i ashwoterawwotssh shishiyosh kahniyo wotat Krstos Iyesush finoshe, Mansh Ik' ashwoteraw ashuwotssh S'ayin shayiro S'ayintsonat Ik'onowere gene'úshit wosho wotáár bot'inetuwok'o finiruwone. ");
INSERT INTO bwo_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Manatse tuutson Krstos Iyesun Ik'osh fino tfaltsotse it'iruwee. ");
INSERT INTO bwo_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Ik'i ash woterawwots bo aletwok'o woshosh Krstos ti aap'onat finatse tuutson b́ fints keewo wotiyalabako k'osho aap'osh aawo shu'atse. ");
INSERT INTO bwo_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Hank'owere een adits milikit finuwotsn S'ayin shayiri angon Iyerusalemnat b gúúratse tuut Elwarik'oni b́ borfetso Krstos doo shishiyo danire. ");
INSERT INTO bwo_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Jam aawu t tewuno k'osh asho b́ agtsats dabr ago b́woterawo Krstos shutso b́ shiyerawu beyok jamok sheeng doo shishiyi keewuman daniye. ");
INSERT INTO bwo_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Hanu, «Haniyere shinon b́ jangosh eegoru keewerawu ashuwots bek'etune, b́ jangosh shiyawwots t'iwitsitunee» ett guut'etsok'one. ");
INSERT INTO bwo_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Manshowere itmaants twarawok'o ayoto taan baziyeree. ");
INSERT INTO bwo_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Andomó han gúúratsi fa'a datsuwotsatse t finit beeyokuwots bo beetsotse, hank'o ay dúrosh itn s'ilosh een tewuno tdetstsotse ");
INSERT INTO bwo_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Ispen maants t amor man weeron itn s'ilosh gawure. Muk' aawosh itnton gene'útsat tteshiyakon twerindo ttuwosh taan falit tep'o it k'alituwok'o jangere. ");
INSERT INTO bwo_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Andomó Ik' jirwots tep'et gizo deshde'er Iyerusalem maants ametuwe. ");
INSERT INTO bwo_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Hanuwere Mek'odoniyonat Ak'yiyi datsatse fa'a Ik' jirwots Iyerusalemn beyiru tugúretsuwotssh boon tep'et gizo woshosh boshunon bogawutsotsne. ");
INSERT INTO bwo_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Tep'anowere bo shunon imo boosh geyik b́wottsotsne, Ik' ash woterawots ayhudiyotsnton shayiri deero kayosh b́wotiyal boowere bomeets deeron ayhudiyotsi tep'o boosh geyife. ");
INSERT INTO bwo_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Eshe ko'iyets gizan Iyerusalem maants de'am boosh t imiyakon it weeron waar Ispen maants t ameti. ");
INSERT INTO bwo_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Itok twoor Krstos deero s'eenon itsh de'er tweetuwok'o danfee. ");
INSERT INTO bwo_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Tieshuwotso! t jangosh Ik'o maants k'onon tmaak'oriruwo taash itdabish nodoonz Iyesus Krstosnat S'ayin shayiri shunon iti k'oniruwe. ");
INSERT INTO bwo_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Ik'o taash it k'onituwere Yihud datsatsi fa'a amanerawu ashuwots kishotse farr Iyeresalemitse t detsts fiinonuwere Ik'i jirwotsoke dek'eyo b́daatsituwok'owe. ");
INSERT INTO bwo_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Han b́wotiyakon Ik'o bíetal geneúwon itok waarr itoke kashdek'o shunfee. ");
INSERT INTO bwo_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Jeeniko Izar Izewer it únetsnton wotowe! Amen. ");
INSERT INTO bwo_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Feben Knkriy kitotse Ik' moowosh finiru nomish amanetsu b wottsok'o it dano geefe. ");
INSERT INTO bwo_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Bi taanat k'osh ay ashuwotsi b tep'iruwotse amants ibuwotsi ibiyo boosh b́ wotituwok'o doonzo shútson de'er bish geyit keewo jamon bin it tep'etuwok'o oona itsh etiruwe. ");
INSERT INTO bwo_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Iyesus Krstos fino finiruwotsnton ik wottsuwots P'rsk'lnat Ak'ilnsh jamo keewwere, ");
INSERT INTO bwo_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","boowere t shegro k'iroshoru dab k'andek'kne boteshi, hann boon jam aawosh úditwe, t s'uzi b́ woterawo Ik' ashwoteraw krstani woto maants aants Ik' moowwotsworu it údirune. ");
INSERT INTO bwo_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Bo moots Ik' k'onosh kakuwets amantsuwotssh jamo t'intsuwere. Isiyi dats kayatse shini Krstosn amantsonat tshuntso Ep'enet'ossh jamo keewwere. ");
INSERT INTO bwo_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Itsh ayidek'at maawutsu Mariyamsh jamo t'intsuwere. ");
INSERT INTO bwo_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Taanton tipeyat teshts woshetswotsitsere daneets teshts ayhudiyots jaagúwots Andronik'osnat Yuniyassh jamo t'intsuwere, boowere taayere shine Krstosi bo amani. ");
INSERT INTO bwo_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Doonzon tshúntso Amp'ilyat'ossh jamo t'intsuwere, ");
INSERT INTO bwo_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Krstos finon noonton ik wottso Úrbanosnat tshúntso Ist'akussh jamo t'intsuwere. ");
INSERT INTO bwo_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Krstosk b́ wottsotse fadeyat bíere bísh gawetso Ap'elissh jamo t'intsuwere, Arst'obulos maa ash wottsuwotssh jamo t'intsuwere. ");
INSERT INTO bwo_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Ayhudiyotse t jago Herodiyonsh jamo t'intsuwere, Narsises maa ashuwotsitse Doonzon amantsuwotssh jamo t'intsuwere. ");
INSERT INTO bwo_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Doonzosh finon ayidek't maawirwotssh Trufaynnat Trufolsh jamo t'intsuwere. Doonzo finon ayidek'at mááwtsunat Krstosn ayidek'at tshunts Persissh jamo t'intsuwere. ");
INSERT INTO bwo_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Doonzosh finon ayidek't danetso Rufossh jamo t'intsuwere, taan b naayikok'o shunfu b́ indshowre jamo t'intswere. ");
INSERT INTO bwo_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Asnkritosnat Flegonsh, Hermesmsh, Patrobasmsh, Hermasmsh, bonton fa'a eshúwotssh jamo t'intsuwere. ");
INSERT INTO bwo_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Filologossh, Yulyash, Neryanat b́ mishsh jamo t'intsuwere, hank'o Olumpasnat bínton fa'a amantsuwots jamwotssh jamo t'intsuwere. ");
INSERT INTO bwo_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","S'ayin jobon it atsatseyo jobeyar jamo aatewere. Krstosk wotts Ik' maa jamwots jamo itsh t'intsirune. ");
INSERT INTO bwo_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Ti eshuwotso! it dek'ts dan man k'efituwotsi wotat it dagotse k'aleyon gond bek'o dowet ashuwotsatse it atso korde'ere, boatsere wokoore! ");
INSERT INTO bwo_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Hank'o ashuwots botookosha bako Krstosshaliye bo finiri. Bonono shaawshdek' dáshon garaamiwots nibo boant'elciri. ");
INSERT INTO bwo_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Doo shishi aap'osh aleets ash it wottso ash jamokere b́ danetsotse geneúk t wotwotiyaloru, sheeng keewosh dantswotsi, gond keewoshomó maac' kúp'uwotsi it wotitwok'o geefe. ");
INSERT INTO bwo_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Jeeniko Izar Izewer káári Shed'ano it tufi shirots tiitsetwe. No Doonz Iyesus Krstos s'aato itnton wotowe. ");
INSERT INTO bwo_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","T finonton ik wottso T'imotiwos jamo itsh t'intsiruwe, eshe ayhudiyotse t jag wotts Luk'iyosnat Iyason Sosip'at'roswere jamo t'intsirune. ");
INSERT INTO bwo_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Woshhan guut'tso taawe T'ert'iyos Doonzon jamo t'intsituwe. ");
INSERT INTO bwo_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Taanat hanokere fa'a jamo Ik' moowwotsi Ibiiruwo Gayiyos jamo t'intsiruwe, kitutsi gizo detsiruwo Erast'os, no eshú K'a'rt'os jamo itsh t'intsiruwe. ");
INSERT INTO bwo_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Taa tdaniru doo shishi keewan Iyesus Krstos jangosh beshiyeyiru woshonat yootstson aashat teshtso, andomó be'ets ari ááshts keewon Ik'onwere it imnetiyats it ned'ituwok'o iti woshosh falituwe. ");
INSERT INTO bwo_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Andomó arikan be'ere, dúre dúrts Ik'o tzaziyon jamwots amanar bo aletwok'o Nebiywots mas'aafi weeron ash jamwots bo danetuwok'o k'alere. ");
INSERT INTO bwo_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","B́ s'uzn dani teleefo detsts Ik'o Izar Izewersh, Iyesus Krstosn dúre dúron údo wotowe! Amen.");
INSERT INTO bwo_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Ik' shunon Iyesus Krstossh wosheets wotosh s'eegetso P'awlosnat no eshu Sostensokere. ");
INSERT INTO bwo_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","K'orontos kitotse fa'a Ik' moosh, biyitsnowere Iyesus Krstosn S'ayin wotts S'ayin bowotish s'eegetswotssh, mank'owero bo be beyoke, bonat nonsh Doonz wottso no Doonz Iyesus Krstos shúútso s'eegiru jamwotssh. ");
INSERT INTO bwo_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","No nihi Ik'onat Doonzo Iyesus Krstosokere s'aatonat jeenon itsh wotowe. ");
INSERT INTO bwo_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Iyesus Krtosnton s'aato itsh imetsosh it jangosh jam aawo Ik'o údituwe. ");
INSERT INTO bwo_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Jam keewon, noon keewon wotowa danon Krstosn gaalwutserte. ");
INSERT INTO bwo_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Krstos jangosh itsh t keewts gawo itokere kúp'ere. ");
INSERT INTO bwo_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Eshe no Doonz Iyesus Krstos be'ewo koton nobefere kon naari shayiri imo itsh shapratse, ");
INSERT INTO bwo_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","No doonz Iyesus Krstos aani woor eeg eeg deshawwotsi wotar nodatsetwok'o bí s'uwosh b́ borfetsosh kup'ar it beetuewk'o woshúwe. ");
INSERT INTO bwo_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","B́ naay no Doonz Iyesus Krstosnton ikwoto itdetsetuwok'o itn s'eegtso Ik'o amaneke. ");
INSERT INTO bwo_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Ti eshuwotso! «K'alewo it dagotse b́ berawok'o, it jamets shiyeyar ik níbonat ik s'iil s'iilon kup'ar beewere,» etaat no Doonz Iyesus Krstos shúútson itn k'oniruwe. ");
INSERT INTO bwo_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","T eshuwotso! it dagotse fayo b́ beyiruwok'o K'elo'e maa ashuwotsoke shishre. ");
INSERT INTO bwo_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Manuwere it itok tookon «Taa P'awlosk taane, taa Ap'losk taane, taa P'et'rosk taane, taa Krstosk taane» it etiri. ");
INSERT INTO bwo_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Bére Krstos kayera? P'awlos itsh jiitera? Himó it gupe P'awlos shútsoneya? ");
INSERT INTO bwo_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Taa K'ersp'osnat Gayyosiyere okoon ititsere konnoru t gufawotse Ik'o údituwe. ");
INSERT INTO bwo_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Eshe «Taan P'awlos shútson guuperte» err keewosh falituwo aaliye.  ");
INSERT INTO bwo_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Arikee, Ist'ifanos maa ashuwotsi gupre, maniyere okoon k'osho taa t gupts asho b́ bewok'o gawratse. ");
INSERT INTO bwo_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Krstos taan b́wosh doo shishi keewo t danituwok'owa bako t gupishaliye, Krstos jiito hank'on b́ oorerawok'o doo shishi keewan tdanir ashoke daatsets dani telfi noon keewok'onaliye. ");
INSERT INTO bwo_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","B́ jiti keewo t'afit ashuwotssh darok'owe b́ taaweti, noosh kashituwotsshomó Ik' angee. ");
INSERT INTO bwo_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","«Dani telefetswots dano t'afituwe, Dani telefetswots danono ok k'aaú bazetuwe» ett guut'ere. ");
INSERT INTO bwo_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Eshe dantso aawoke b́ fa'oni? Nem daniruwonu aawoke b́ fa'oni? Danosh geyiruwonu aawoke b́ fa'oni? Ik'o datsanatsi dani telefo eegoru bítse dandeshawok'o woshk'rerosha? ");
INSERT INTO bwo_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Datsnatsi ashuwots bo took danitelefon Ik'o danosh bo falawok'o Ik'o b́ danon boats is'k'rere, ernmó dárok'o taaweyiru no nodaniru doo shishiy keewon amanituwots bo kashituwok'o Ik' shún wotere. ");
INSERT INTO bwo_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Ayihudiyots adits keewo bek'oshe bo geefoni, Girik ashuwotswere danitelefe bogefoni. ");
INSERT INTO bwo_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Noomó Krstos noosh b́ jitetsok'oniye no daniri, Hanuwere ayhudiyotssh t'uge, Grik ashuwotssh dáree. ");
INSERT INTO bwo_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","S'eegetswotsshomó ayhudiyotssh wotowa Grik ashuwotssh, Krstos Ik' angonat Ik' danitelefe. ");
INSERT INTO bwo_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Ik' dára ett gaweyiru keewo ash danitelefoniyere bogfe, Ik'o maawa ett gaweyiru keewo ash kup'oniyere bogfe. ");
INSERT INTO bwo_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","T eshuwotso! Ik'o itn b́ s'eegor awuk'o ash it wottsok'o aab gawde'ere, ash gaawiruwok'on it dagotse aywots daanetsuwots wee kúp'uwots wee een een ashuwots aalne. ");
INSERT INTO bwo_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Ik'o dantelfetswotsi jitsiyosh datsanatse dartsok'o taawets ashuwotsi b́ marat'i, kúp'uwotsi jitsiyosh datsatse maawtsok'o taawetswotsi b́ marat'i, ");
INSERT INTO bwo_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Ik'o datsatsi ashuwotsoke fa'ane ett be'eyiru keewwotsi bo berawok'o woshosh datsanatse dash antsonat gac'ets k'awnts deshaw keewo b́ marat'i. ");
INSERT INTO bwo_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Hanowere b́k'al konwor asho Ik' shinatse b́ tooko dambaan b́deshawok'owe. ");
INSERT INTO bwo_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Itnomó Ik'o Iyesus Krstosnton ik woto it detsetwok'o b́ woshi, mansh Ik'o Iyesus Krstosn noko danitelefo bíne, noosh noko kááwo bíne, no s'ayinonat no bín nofaritwok'o b́ woshi. ");
INSERT INTO bwo_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Eshe mas'aafotse guut'etsok'on «It'etuwo b́ beyal Ik'on id'ee.» ");
INSERT INTO bwo_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Ti eshuwotso! taa itok twoor Ik' jango itsh t gawutso, keew falonat bog dan kitsonaliye. ");
INSERT INTO bwo_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Itnton t beyor Iyesus Krstosiyere oko dab jitats jiteyat b́ k'ironiyere k'osho eegoru tdanawok'osh k'ut'dek'atniye t teshi. ");
INSERT INTO bwo_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Eshe itnton t beyor maawk wotat shatonat ay k'eewone tteshi. ");
INSERT INTO bwo_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","T noon keewonat nabo ash danitelefonat noon keew shawshats b́ woterawo Ik' shayiri angaats tep'ekee b́teshi. ");
INSERT INTO bwo_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Hanowere tk'altso it imnetiyo ash danitelefats b́ woterawo ik' angaats te'ek b́ wotishee. ");
INSERT INTO bwo_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Ernmó bo shayiri beyon katsuwotssh dantelefi aap'o keewituwone, wotowa eree nokeewitwo datsanatsi danitelefon wee s'uwatse t'afosh wotit datsan k'eeziruwots danitelefoniyaliye. ");
INSERT INTO bwo_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","No no keewiruwonmó Ik'o yoots dúroniye shinon no mangosh b́ k'anitsonat aashat teshts Ik' danitelefoniye. ");
INSERT INTO bwo_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Datsni k'eziruwitsitsere danitelefo dantso konworu aaliye, danfno wotik'ee mang wotts Doonzo jirawuk'ne b́ tshi. ");
INSERT INTO bwo_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Wotowa eree mas'aafo, «Ash ááw be'awo, Ash waaz shiyawo, Ash nib gawawo, Ik'o b́ shúntswotssh k'anire» etfe. ");
INSERT INTO bwo_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Nooshmó Ik'o b́ shayiron aashts man kitsre, Ik' shayiro dashan wokts Ik'oke aashtsonoru b́ oreraniyere jam keewo p'ec'at b́ s'iili. ");
INSERT INTO bwo_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Ash iko jangosh b́ took shayironiyere okoon b́ gawiruwo dantso kone? mank'o Ik' shayironiyere okoon Ik' gawiruwo dantso konuworu aaliye. ");
INSERT INTO bwo_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Ik'oke noosh b́ imets keewo nodanish Ik' shayira bako datsanatsi shayiro de'atsone. ");
INSERT INTO bwo_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Eshe no shayiri keewo shayiron wotts ashuwotssh no danir ashokere daatsets danitelefon b́ woterawo Ik' shayirokere daatsets dantelefone. ");
INSERT INTO bwo_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Ik' shayiro deshaw meets ashonmó Ik' shayiroke imeyiru imo dek'osh falatse, bí im eenonuwere p'ec'ar b́s'ilet Ik' shayiron b́wottsotse t'iwints dek'osh falatse, hanuwere bísh darok'owe woshder b́ s'ileti. ");
INSERT INTO bwo_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Ik' shayir detsts jamonmó jam keewo p'ec'ar s'iilo falituwe, b́ took keewonomó konuwor p'ec'ar s'iilo falatse. ");
INSERT INTO bwo_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Hanu, «Doonzo gawiruwo kone danosh faliti? Bísh izosh falituwo kone?» Ett guut'etsok'one. Noomó Krstos nibo detsfone. ");
INSERT INTO bwo_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","T eshuwotso! taa iti t daniyor meets asho Krstosats kúp'eraw na'i marmat'ok'o it wottsok'ona bako shayiretswotsk'o it wottsoshaliye. ");
INSERT INTO bwo_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Kúp' mish moo máá falaaw na'i marmat'ok'o it wottsotse taa itsh t maanztso ezaa bako kúp' mishaliye, andoor b́ wotiyal kúp' mish moo falrafa'ate. ");
INSERT INTO bwo_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","It andoru meets ash itne, it ats atseyo it okoreyirwotsnat it mosheyirwotse meets ash itnosha? it finirwore k'osh ashok'owosha? ");
INSERT INTO bwo_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Iko «Taa P'awlosk taane» k'osho «Taa Ap'losk taane» bí etor datsanatsi ash itnosha? ");
INSERT INTO bwo_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","wotowa bako Ap'los kone? P'awlos kone? boowere it itk'alirwok'o k'alts guutsne, botook tookon bo finir Doo