﻿USE sofia;
DROP TABLE IF EXISTS sofia.bwc_vpl;
CREATE TABLE bwc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bwc_vpl WRITE;
INSERT INTO bwc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Mu emwakonkanine ifikolwe fyakwa Yesu Klistu, umwana wakwa Davidi, uwali mwana wakwa Abulahamu. ");
INSERT INTO bwc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abulahamu aafyele Isaaki na Isaaki aafyele Yakobo, na Yakobo aafyele Yuda nabamunina. ");
INSERT INTO bwc_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Kabili Yuda aafyele Paresi na Zara uwaku Tama na Faresi aafyele Esrom, kabili Esrom aafyele Ramu. ");
INSERT INTO bwc_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Kabili Ramu aafyele Aminadabu, Na Aminadabu aafyele Naashoni, na Naashoni aafyele Salumoni, ");
INSERT INTO bwc_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Na Salumoni aafyele Boazi muli Rahabu, na Boazi aafyele Obedi muli Ruti, na Obed aafyele Yesse, ");
INSERT INTO bwc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Na Yesse aafyele Davidi imfumu, kabili na Davidi imfumu aafyele Solomoni uwali mwana wamukasi wakwe uwaku Uriyasi. ");
INSERT INTO bwc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Kabili Solomoni aafyele Rehoboam, Rehoboam aafyele Abiya, na Abiya aafyele Asa, ");
INSERT INTO bwc_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","kabili Asa aafyele Yehoshafati, na Yehoshafati aafyele Yoramu, na Yoramu aafyele Usaya, ");
INSERT INTO bwc_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Kabili Usaya aafyele Yotamu, na Yotamu aafyele Ahazi, na Ahazi aafyele Hezekiya, ");
INSERT INTO bwc_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Kabili Hezekiya aafyele Manasse, kabili Manasse aafyele Amoni, kabili Amoni aafyele Yosiya, ");
INSERT INTO bwc_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Kabili Yosiya aafyele Yekoniya nabamunina, munsita bapiitilwe mu Babiloni. ");
INSERT INTO bwc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kabili panuma babapiita mu Babiloni, Yekoniya aafyele Shiyaliteli, na Shiyaliteli aafyele Zerubabele, ");
INSERT INTO bwc_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Kabili Zerubabele aafyele Abiudi, na Abiudi aafyele Eliakimu, na Eliakimu aafyele Azori, ");
INSERT INTO bwc_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Kabili Azori aafyele Zadoki, na Zadoki aafyele Akimu, na Akimu aafyele Eliyudi, ");
INSERT INTO bwc_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Kabili Eliyudi aafyele Eleyaza, na Eleyaza aafyele Matani, na Matani aafyele Yakobo, ");
INSERT INTO bwc_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Kabili Yakobo aafyele Yosefu muka Mariya, uwafyele Yesu uwitwa Klistu. ");
INSERT INTO bwc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Eikyo papitile inkulo ikumi nashine ukufuma pali Abulahamu ukufika pali Davidi, kabili ikumi nashine ukufuma pali Davidi ukufika mubusya mu Babiloni, kabili ikumi nashine ukufika mukufyalwa kwakwa Klistu. ");
INSERT INTO bwc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ifi efintu ukufyalwa kwakwa Yesu Klistu kwali. Nyina Mariya aimenwe kuli Yosefu, lelo ilyo tabalaupana asangilwe ukuti, ali nokukwata umwana ukupitila ku maka yakwa Mupasi Wamusilo. ");
INSERT INTO bwc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yosefu ali muntu uwalekita ifyalungama, eikyo talefwaya ukumukanina palwalala kabili aalepinga ukubwesya ubwimashi mubumfisolo. ");
INSERT INTO bwc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kilya aletontonkanya palifi, malaika wa Mfumu amonekele kuli ena mukiloto nokumweba ukuti, “Yosefu, wemwana wakwa Davidi, witiina ukuupa Mariya. Pantu umwana Mariya akakwata akafuma kuli Mupasi Wamusilo.” ");
INSERT INTO bwc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Akakwata umwana umwaume kabili ukamwinike ukuti, “Yesu pantu akapususya abantu bakwe kumembu syabo.” ");
INSERT INTO bwc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Fyonse ifi fyakitike pakuti fintu Imfumu yalandile ukupitila muli kasesema fifikilisye ukuti, ");
INSERT INTO bwc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nakisungu akemita nokukwata umwana umwaume kabili akenikwa Imanuele” (ikilepilibula ukuti, “Lesa ali nafwebo”). ");
INSERT INTO bwc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Eikyo lintu Yosefu asibwike, akitile fintu malaika wa Mfumu amukonkomesye eikyo aupile Mariya. ");
INSERT INTO bwc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Lelo tabakumenepo mpaka umwana afyalwa elo Yosefu amwinika ukuti Yesu. ");
INSERT INTO bwc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Lintu Yesu afyelwe mu musumba wa Betelehemu mu Yudeya, munsita Herodi ali imfumu, abamano ukufuma ku kabanga baisile ku Yerusalemu ");
INSERT INTO bwc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","nokwisaipwisya ukuti, “Alipi umwana afyelwe Imfumu yaba Yuda? Twakimona ulutanda lwakwe lintu lwakisa kukabanga, twaisa mukumusinsimuna.” ");
INSERT INTO bwc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Lintu imfumu Herodi yaumfwile ifi, yalisakamene kumofye nabantu bambi mu Yerusalemu. ");
INSERT INTO bwc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Yaitile basimapepo mukalamba bonse naba kafundisya bamafunde nokubepusya kuntu Klistu ali nokufyalilwa. ");
INSERT INTO bwc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bayaswike ukuti, “Mumusumba wa Betelehemu mu Yudeya. Pantu ifi efintu bakasesema baalemba ukuti, ");
INSERT INTO bwc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Iwe we Betelehemu mukyalo kya Yudeya, wilaimona ukukepesyapo pamisumba syamu Yudeya, Pantu muli webo mukafuma intungulusi ikatungulula abena Israeli.” ");
INSERT INTO bwc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Elo Herodi aitile abamano abafumine kukabanga mubumfisolo, ukuti afwailisye kuli bena insita ulutanda lwamoneke. ");
INSERT INTO bwc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Abatumine ku Betelehemu nokubeba ukuti, “Kabiyeni kafwayeni umwana bwino bwino, ngamwamusanga mungisibisye pakuti nanebo ndeyamusinsimuna.” ");
INSERT INTO bwc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Abamano abafumine kukabanga baumfwile fintu imfumu yabebele nokuya. Kabili nolutanda luntu bamwene kukabanga lwatampile ukubatangilila mpaka lwaiminina pankende apaali umwana. ");
INSERT INTO bwc_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Balitemenwe ngansi lintu bamwene ulutanda. ");
INSERT INTO bwc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Baingile muŋanda, kabili lintu bamwene umwana nanyina Mariya bafukeme pansi nokumusinsimuna. Bamuleetele ifyabupe baisile nafyo ifya golide, ububani na murrh. ");
INSERT INTO bwc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pamulandu balisokelwe mukiloto ukuti bekabwelulukila kuli Herodi, baile ku kyalo kyabo ukubomfya insila imbi. ");
INSERT INTO bwc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Panuma abamano baaya, malaika wa Mfumu amonekele kuli Yosefu mukiloto nokumweba ati, “Herodi alatampa ukufwaya umwana pakuti amwipaye. Eikyo ima piita umwana na nyina muye ku Egipiti, mukekale kulya kwine mpaka nkankwebe ukufumako.” ");
INSERT INTO bwc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yosefu aimine nokupiita umwana nanyina nokuya ku Egipiti ubusiku, ");
INSERT INTO bwc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","uko aikele mpaka Herodi afwa. Ifi fyali kufikilisya ifyo Imfumu yalandile ukupitila muli kasesema ukuti, “Naitile Umwana wandi ukufuma mu Egipiti.” ");
INSERT INTO bwc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Lintu Herodi ailwike ukuti abamano nabamuteya, alisakamene. Akonkomesye ukwipaya abana abaume mu Betelehemu nabapalamineko abakwete imyaka ibili nokuya pesamba, akitile ifi ukulingana nensita intu asambilile kubamano. ");
INSERT INTO bwc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Muli iyi nsila ifyalandile kasesema Yeremaya fyalifikilisye ukuti, ");
INSERT INTO bwc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ikiunda kyaumfwikile mu Ramah, ikiunda kyaulelosya mubukali. Rashele alelila abaana, nakana ukumutalalika pantu nabafwa.” ");
INSERT INTO bwc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Panuma Herodi afwa, malaika wa Mfumu amonekele kuli Yosefu mukiloto mu Egipiti ");
INSERT INTO bwc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","nokumweba ukuti, “Ima, piita umwana nanyina ubwelelemo ku Israeli pantu abaalefwaya ukwipaya umwana nabafwa.” ");
INSERT INTO bwc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Eikyo Yosefu aimine nokupiita umwana nanyina nokubwelela ku Israeli. ");
INSERT INTO bwc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Lelo lintu Yosefu aumfwile ukuti Akelausi napyana wisi Herodi pabufumu mu Yudeya, alitinine ukuyako. Kabili apo balimusokele mukiloto aile mukitungu kya mu Galili. ");
INSERT INTO bwc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Aileikala mu musumba wa Nasareti pakuti ifyalandile bakasesema fifikilisye ukuti, “Aketwa umwina Nasarene.” ");
INSERT INTO bwc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Muli silya nsiku Yohani Kabatisya aisile alesimikila mukiswebebe kyamu Yudeya. ");
INSERT INTO bwc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Alandile ukuti, “Lapileni, pantu Ubufumu bwa mumulu nabupalama!” ");
INSERT INTO bwc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohani emuntu Ezaya aalelandapo ukuti, “Isiwi lyaulebilikisya mukiswebebe lileti, ‘Pekanyeni insila ya Mfumu olololeni umwakupita!’ ” ");
INSERT INTO bwc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Insalu syakwa Yohani syapangilwe namasako yangamali, mumusana alekakamo umusipi wampapa kabili makanta nobuki efyakulya alelya. ");
INSERT INTO bwc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Abantu baisile kuli ena ukufuma ku Yerusalemu, ku fitungu fyonse ifyamu Yudeya naku kyalo kyapalamina no mulonga wa Yodani. ");
INSERT INTO bwc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Baleyebelela imembu syabo kabili alebabatisya mumulonga wa Yodani. ");
INSERT INTO bwc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Lintu Yohani amwene Abafalise naba Saduki abengi baleisa mukubatisiwa abebele ukuti, “Mwensoka mwe! Ninani amyebele ati kuti mwafyuka ukukandwa kuntu Lesa ali nokutuma? ");
INSERT INTO bwc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kiteni ifintu ifilelangisya ukuti mwalifuma kumembu syenu. ");
INSERT INTO bwc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kabili mwilatontonkanya ati, kuti mwafyuka ukukandwa mukulanda ati Abulahamu kikikolwe kyenu. Ndemyeba nati Lesa muli aya mabwe kuti afumyamo abaana bakwa Abulahamu! ");
INSERT INTO bwc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Isembe naliyipekanya ukuputula ifimuti kumisila, fyonse ifimuti ifisitwala fisabo ifisuma kufitema nokufiposa mumulilo. ");
INSERT INTO bwc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Namibatisya namensi mukulanga ukuti namulapila imembu syenu, lelo uwamaka ukunkila alinokwisa kabili nebo nsilingile nokupiita indyato syakwe. Akamibatisya na Mupasi Wamusilo elo nomulilo. ");
INSERT INTO bwc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ali nolupe lwakwelelako muminwe yakwe. Akafumya imisungu pamusolo. Akatutila Iŋano mubutala bwakwe. Imisungu akoca mumulilo ushishima.” ");
INSERT INTO bwc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yesu afumine ku Galili nokuya kumulonga wa Yodani mukubatisiwa kuli Yohani. ");
INSERT INTO bwc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Lelo Yohani alyesesye ukuti amukanye. Amwebele ukuti, “Niwebo ulingile ukumbatisya, nomba nikinsi waisila kuli nebo?” ");
INSERT INTO bwc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Lelo Yesu ayaswike ukuti, “Leka kibe ififine pali nomba. Pantu muli iyi nsila ninsi twafikilisya ubulungami bonse.” Elo Yohani asumina. ");
INSERT INTO bwc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Lintu Yesu abatisiwe, kilyafye afuma pamensi umulu waliswike, kabili amwene Umupasi wakwa Lesa uletentemuka nge nkunda waikala napali ena. ");
INSERT INTO bwc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nesiwi lyafumine mumulu ukuti, “Uyu mwana wandi untu natemwa kabili muli ena emombekelwa.” ");
INSERT INTO bwc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Elo Umupasi watungulwile Yesu mumatololo mukutunkwa kuli Kiwa. ");
INSERT INTO bwc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Panuma yakufunga insiku amakumi yane akasuba nobusiku, Yesu alyumfwile insala. ");
INSERT INTO bwc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kiwa aisile kuli Yesu nokumweba ukuti, “Ngoli Mwana wakwa Lesa, eba aya amabwe yasanguke umukate.” ");
INSERT INTO bwc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Lelo Yesu ayaswike ukuti, “Kyalembwa ukuti, ‘Tekumukate kweka umuntu engabela no mweo, lelo nikwisiwi lyonse ilifuma mukanwa kakwa Lesa.’” ");
INSERT INTO bwc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kabili Kiwa apiitile Yesu ku Yerusalemu mu musumba wamusilo, amuninike pamulu wamutenge we Tempele, ");
INSERT INTO bwc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","nokumweba ati, “Ngoli Mwana wakwa Lesa ipose pansi, pantu kyalembwa ukuti, “Lesa akeba bamalaika bakwe ukukubaka; bakakwimya muminwe yabo, pakuti wikaipuntula kumabwe.” ");
INSERT INTO bwc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu ayaswike ukuti, “Kyalilembwa nakabili ukuti, ‘Wilaesya Imfumu Lesa obe.’” ");
INSERT INTO bwc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kabili Kiwa atwele Yesu palupili ulutali nokumulangisya amabufumu yapesonde mubukalamba bwayako. ");
INSERT INTO bwc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nokumweba ati, “Fyonse ifi ndekupela ngawamfukamina nokunsinsimuna.” ");
INSERT INTO bwc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu amwaswike ukuti, “Kabiye uko, Kiwa! Kyalilembwa ukuti, ‘Ulesinsimuna Imfumu Lesa obe kabili ekafye eo ulepyungila.’” ");
INSERT INTO bwc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kiwa asile Yesu kabili nabamalaika baisile nokwisa mupyungila. ");
INSERT INTO bwc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Lintu Yesu aumfwile ukuti Yohani nabamwingisya mukifungo, aile ku Galili. ");
INSERT INTO bwc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Afumine mu Nasareti, aileikala mu Kapenamu, umusumba wakumbali ya mumana wa Galili mukyalo kya Zebuluni na Nafutali. ");
INSERT INTO bwc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ifi fyakitike mukufikilisya fintu kasesema Ezaya alandile ukuti, ");
INSERT INTO bwc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“We Zebuluni nawe Nafutali, mwefyalo fyabela mumbali ya Bemba, kwisilya lyamulonga wa Yodani. We Galili wa Bena fyalo! ");
INSERT INTO bwc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Abantu abaikala mumfimfi nabamona ulubuto ulukalamba. Abo abekala mukinsingwa kyamfwa ulubuuto nalubasanikila.” ");
INSERT INTO bwc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ukufuma pali ilya nsita, Yesu ayambile ukusimikila ukuti, “Lapileni, pantu Ubufumu bwamumulu nabupalama!” ");
INSERT INTO bwc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Lintu Yesu aleenda mumbali yamumana wa Galili, amwene bamunina babili Simoni (uwaleitwa Petelo) namunina Andereya baleteya amakonde pantu baali bashila. ");
INSERT INTO bwc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu abebele ati, “Nkonkeni nkamikita ukuba abashila babantu.” ");
INSERT INTO bwc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Palyapene basile amakonde nokuya nao. ");
INSERT INTO bwc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesu aendelelekofye ikyalinga nakabili amona Yakobo na Yohani abana bakwa Zebedee. Baali mubwato na wisi Zebedee balelunda amakonde. Yesu alibetile, ");
INSERT INTO bwc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","kabili palya pene basile ubwato na wisi nokuya nao. ");
INSERT INTO bwc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu aile mu Galili monse, mukufundisya muma sinagogi, ukusimikila Imbila Nsuma Pabufumu nokundapa amalwele yamisango misango. ");
INSERT INTO bwc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ilyasi lyapali ena lyasabankene munkyalo kya Silya kyonse, ikyakuti abantu balemuletela bonse abaali nabalwala, abalekyusiwa kumalwele yamisango misango, abaakwete ingulu, abakifulubi nababulebe nao aalibondepe bonse. ");
INSERT INTO bwc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ibumba lyalimukonkele ukufuma ku Galili namu Dekapolisi, ukufuma ku Yerusalemu, ku Yudeya nabusilya bwa Yodani. ");
INSERT INTO bwc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Lintu Yesu amwene ibumba ilikalamba aninine mumbali yalupili emo aile ikala. Abasambi bakwe balimukolongene, ");
INSERT INTO bwc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","kabili atampile ukubafundisya ukuti. ");
INSERT INTO bwc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Balipalwa abapiina mumupasi; pantu Ubufumu bwamumulu bwabo! ");
INSERT INTO bwc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Balipalwa abaloosya; pantu bakakoselesiwa. ");
INSERT INTO bwc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Balipalwa abamutembo; pantu bakapokelela fintu Lesa alaya! ");
INSERT INTO bwc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Balipalwa abansala nekilaka kyakukita ubulungami; pantu Lesa akalenga bakekute. ");
INSERT INTO bwc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Balipalwa abaluse, pantu nabo bakabelelwa uluse! ");
INSERT INTO bwc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Balipalwa abasanguluka imitima, pantu bakamona Lesa. ");
INSERT INTO bwc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Balipalwa abaapanga umutende; pantu baketwa abana bakwa Lesa! ");
INSERT INTO bwc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Balipalwa abo abapakasilwa pamulandu wabulungami, pantu Ubufumu bwamumulu bwabo! ");
INSERT INTO bwc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Muli abapalwa, abantu ngabamituka nokumipakasa nokumibepesya ubufi bwamisango misango pamulandu wandi. ");
INSERT INTO bwc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Beni abansansa kabili temweni pantu ikilambu kyenu ikikalamba kyasungilwa mumulu. Ifi efintu bakasesema abaliko kale bapakeswe. ");
INSERT INTO bwc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Muli mukele wa pano isonde. Nomba umukele ngawaonaika kuti walowesiwa kuli kinsi? Taukwata milimo nakabili, kuoposafye abantu baunyantapo. ");
INSERT INTO bwc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Muli lubuto lwa pano isonde. Umusumba uwakulwa palupili teti ufiswe. ");
INSERT INTO bwc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Takuli uwasya ilampi nokukupikapo ulweso, lelo babika apasansama pakuti ibusye bonse muŋanda. ");
INSERT INTO bwc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Lekeni ulubuto lwenu lusanike pa bantu, pakuti bamone ifintu ifisuma mukita nokulumbanya Wisinwe Mumulu. ");
INSERT INTO bwc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mwilatontonkanya ati naisa mukonaula Amafunde yakwa Mose nangu bakasesema, nsyaisa mukuyapwisya lelo naisa mukuyafikilisya. ");
INSERT INTO bwc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ndemyeba ikine kine nati, umulu nekyalo fikapita lelo ndemilaya nati takwakonaike ikilembo nangu kalitoni mu Mafunde mpaka fyonse fikafikilisye. ");
INSERT INTO bwc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Eikyo kansi onse uwatobapo limo pamafunde nangu lingakyepa syani, nokufundisya abantu bambi ukukita fimofine aketwa umunono Mubufumu bwa mumulu. Lubali lumbi nakabili onse uwasunga ifipope nokufundisya baambi ukukita fimofine, akaba umukalamba Mubufumu bwa mumulu. ");
INSERT INTO bwc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ndemyeba nati tamwakengile Mubufumu bwa mumulu ubulungami bwenu ngatabwakakile ubwaba Falise naba Kafundisya bamafunde. ");
INSERT INTO bwc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mwalyumfwa ukuti ifikolwe bafyebele ati, “Mwilaipaya kabili naonse uwaipayana afwile atwalwa mukupingulwa.” ");
INSERT INTO bwc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Lelo ndemyeba ukuti onse uwafulilwa munyina alingile ukumutwala mukupingulwa. Kabili onse uwatuka munyina akatwalwa kukilye, naonse uwaita munyina ukuti kiwelewele akaba mubwafya bwamulilo waku Gehena. ");
INSERT INTO bwc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Eikyo ngoli pakutula ikyabupe pakipailo kyakwa Lesa, elo waibusya ati munonko nakukwatila ikintu kumukosi, ");
INSERT INTO bwc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","sya ikyabupe kuntansi yakipailo, kabiye muleyawikisyanya elo wise uutule ikyabupe kuli Lesa. ");
INSERT INTO bwc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Umfwaneni bwangu bwangu nomuntu ukweteko imilandu lintu mukili muleya nankwe mukulubulula. Pantu kuti ayakutwala kuli kapingula, nao kapingula akutwala kuli kapokola kabili ukabikwa mukifungo. ");
INSERT INTO bwc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ndimukumyeba ikine kine nati, ukekala mulya mpaka ukalipe nolupiya lobe lonse ulwakulekelesya. ");
INSERT INTO bwc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Mwalyumfwa fintu kyalandilwe ukuti, “Mwilakita bukende.” ");
INSERT INTO bwc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Lelo ndimukumyeba ati, onse uwalolesya umwanakasi nolunkumbwa lubi ninsi nakita kale ubukende mumutima wakwe. ");
INSERT INTO bwc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Eikyo ilinso lyobe ilya kukulyo ngalyakulenga ukubembuka, lilobole nokuliposa! Kyawamisyapo ukulufya ikilundwa kimo ikya kumubili obe ukukila umubili obe onse ukuposwa ku Gehena. ");
INSERT INTO bwc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ukuboko kobe ukwa kukulyo Ngakwakulenga ukubembuka, kuputule nokukuposa! Kyawamisyapo ukulufya ikilundwa kimo ikyamubili obe ukukila umubili onse ukuposwa mu Gehena. ");
INSERT INTO bwc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Kyalilandwa nakabili ukuti, “Onse uwaleka umukasi wakwe afwile ukumupa ikipepela kyakupwilapo ikyupo.” ");
INSERT INTO bwc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Lelo ndemyeba ukuti uyo onse uwasya umukasi wakwe pamulandu uusili wabukende ninsi amulenga ukuba umukende. Kabili naonse uwaupa umwanakasi baleka nao ninsi akita ubukende. ");
INSERT INTO bwc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kabili mwalyumfwa ukuti ifikolwe bafyebele ati, ‘mwilalapa bufi lelo mulefikilisya fintu mwalaya ku Mfumu ukukita.’ ");
INSERT INTO bwc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Lelo ndemyeba ukuti, Mwiilalapa pakulaya, mwilalapa ku myulu pantu kipuna kya bufumu ikya kwa Lesa, ");
INSERT INTO bwc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","mwilalapa pesonde, pantu ekipuna kyamakasa yakwa Lesa, nangu pali Yerusalemu pantu musumba wa Mfumu nkalamba. ");
INSERT INTO bwc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mwilalapa napamutwe wenu pantu tekuti mupange umusisi nangu umo ukubuta nangu ukufita. ");
INSERT INTO bwc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mulelandefye ukuti, ‘Ee’ nangu ‘Awe’ ifintu fimbi fintu mulanda fifuma kumubifi.” ");
INSERT INTO bwc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mwalyumfwa fintu kyalandwa ukuti, ‘Ilinso pe linso, kabili iliino peliino.’ ");
INSERT INTO bwc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Lelo ndemyeba ukuti, mwilalandula umuntu ngamilufyanya. Umuntu ngakuuma ulupi kwitobo lyakukulyo leka akuume nakwitobo lya kukuso. ");
INSERT INTO bwc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kabili umuntu ngakutwala kukilye pakufwaya ukukupoka insalu yobe leka apiite ne koti lyobe. ");
INSERT INTO bwc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Umuntu ngakupatikisya ukuya nao umulundu umo, kabiye nao imilundu ibili (2 km). ");
INSERT INTO bwc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Umuntu ngakulomba ikintu mupele kabili ngalefwaya ukumwasima ikintu mwasime.” ");
INSERT INTO bwc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mwalyumfwa ati kyalandwa ukuti, ‘Muletemwa ababiyo, mulepata abalwani benu.’ ");
INSERT INTO bwc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Lelo ndemyeba ukuti temweni abalwani benu kabili mulepepela abamipakasa, ");
INSERT INTO bwc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","pakuti mube abaana bakwa Wisinwe mumulu. Pantu aleka akasuba kakwe ukubala pa bantu abaabi na pabasuma fimofine, kabili alokesya imfula pabalungami napababembu. ");
INSERT INTO bwc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nikinsi Lesa engamilambwila ngamwatemwafye abamitemwa? Pantu nabakasonkesya bamusonko nabo balakita ifyofine! ");
INSERT INTO bwc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kabili ngamuposyafye bakibusa benu busye ninsi namukitapo ubupusano? Nabenafyalo nabo balakita ifyofine! ");
INSERT INTO bwc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mube abapwililika ngafintu Wisinwe mumulu aba uwapwililika.” ");
INSERT INTO bwc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Kengeleni, mwilakita ubulungami pa menso ya bantu bambi pakuti bamimone, pantu ngamwakita ifyo tamwakapokelele kilambu kuli Wisinwe wa mumulu. ");
INSERT INTO bwc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Eikyo kansi ilyo mwapela ikintu kumubusu, mwilasabankanya ngafintu bamumbimunda bakita muma sinagogi na mumisebo. Bakita ifi pakuti abantu babalumbanye. Ndemyeba ukuti balipokelela kale ikilambu ikyakumanina. ");
INSERT INTO bwc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Lelo lintu mulepela, mwileka ukuboko kwenu ukwa kukuso kwisibe ifilekita ukuboko kwa kukulyo. ");
INSERT INTO bwc_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Pakuti ukupela kwenu kube ukwa munkama kabili na Wisinwe uumona munkama akamilambula.” ");
INSERT INTO bwc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Lintu mulepepa, mwilaba nga babumbimunda abatemwa ukwiminina mumisebo na muma Sinagogi, pakuti babamone kubantu. Ndemyeba nati balipokelela ikilambu kyabo mukukumanina. ");
INSERT INTO bwc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Lelo ilyo mulepepa, ingileni mukyumba kyenu mwisaleko ikiibi nokupepa kuli Wisinwe usimoneka. Kabili na Wisinwe umona ifyamunkama akamilambula. ");
INSERT INTO bwc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Kabili ngamulepepa mwilabomfya amasiwi ayengi ayabula ubuyo ngafintu Abena Fyalo bakita. Batontonkanya ukuti Lesa elo engomfwa amapepo. ");
INSERT INTO bwc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mwiba ngabena, pantu Wisinwe alisiba fintu mufwaya lintu tamulamulomba. ");
INSERT INTO bwc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ifi nomba efyo mufwile ukupepa: ‘Mwe Taata wesu uwamumulu, isina lyenu likindikwe, ");
INSERT INTO bwc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ubufumu bwenu bwise, ubufwayo bwenu bukitwe pesonde ngamumulu. ");
INSERT INTO bwc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tupeleni lelo ikyakulya kyesu ikya kila busiku. ");
INSERT INTO bwc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tweleleni fintu twalufyanya, ngafintu twelela abatulufyanya. ");
INSERT INTO bwc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mwitutwala mukwesiwa ukukalamba, lelo mututule kufyabipa.’ ");
INSERT INTO bwc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Pantu ngamuleelela bambi fintu bamilufyanya, na Wisinwe mumulu nao akamyelela. ");
INSERT INTO bwc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Lelo ngatamuleelela bambi, na Wisinwe takamyelele fintu mwalufyanya. ");
INSERT INTO bwc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Elo mulefunga, mwilaikala inkumbabulili ngafintu babumbimunda bakita. Balekelesya imimonekele yabo pakweba ati abantu bonse babamone ati balefunga. Ndemyeba ikinekine nati bena balipoka ikilambu kyabo kyonse. ");
INSERT INTO bwc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Lelo lintu mulefunga, mulesamba kumenso nokusuba amafuta mu mutwe, ");
INSERT INTO bwc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","pakuti abantu bambi belaisiba ukuti mulefunga. Kanofye Wisinwe eka usimoneka. Kabili Wisinwe uumona fintu mukita munkama akamilambula. ");
INSERT INTO bwc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mwilasungila ifyuma fyenu pesonde apo ubuswa nenkuutu fingonaula, kabili apo abaŋo bengengila no kwiba. ");
INSERT INTO bwc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Lelo Sungileni ifipao fyenu mumulu umo ubuswa nenkutu teti syonaule kabili nabaŋo teti bengile nokwiba. ");
INSERT INTO bwc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pantu umutima wenu ukaba ukwaba ifyuma fyenu. ");
INSERT INTO bwc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ilinso elampi lyamubili. Amenso yobe ngayatuntulu ninsi umubili obe onse uli mulubuuto. ");
INSERT INTO bwc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Lelo amenso yobe ngateyatuntulu, umubili obe ukaba mumfimfi. Ngakyakuti ulubuto muli webo nimfimfi, ninsi nimfimfi yakipesya mano! ");
INSERT INTO bwc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Takuli umuntu uwingaba umusya wabasikulu babili, kuti apatapo umo nokutemwapo umbi, kuti anakilapo umo nokufupulapo umbi. Tekuti upyungile fyonse pamo, Lesa nolupiya. ");
INSERT INTO bwc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Eikyo ndimukumyeba ukuti, mwilasakamana pabwikasi bwenu, fintu mukalya nafintu mukanwa, nangu pansalu syamubili wenu. Busye ubwikasi bwenu tabwakila ifyakulya? Kabili busye umubili tawakila insalu? ");
INSERT INTO bwc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Lolesyeni pafyoni fyamulwelele, ifisilima, tafisombola nangu ukusungila mumatala, lelo Wisinwe wamumulu alafiliisya! Busye tamwakindamapo ukukila ifyoni? ");
INSERT INTO bwc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ninani pali mwebo uwingalundapo insiku pamulandu wakusakamana? ");
INSERT INTO bwc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Nikinsi musakamanina pansalu? Lolesyeni pamaluba ya mumpanga fintu yakula, tayabomba nangu ukuipangila ifyakufwala. ");
INSERT INTO bwc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Lelo ndemyeba nati, Nemfumu Solomoni nobunonshi bwakwe bonse tatalile fwikwapo ngalimo pali aya maluba. ");
INSERT INTO bwc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ngakyakuti Lesa eufwika ifyani fyamumpanga, ifyakuti lelo epofili mailo fyaposwa mumulilo tekuti amifwike ukukishapo, mwe bantu bakitetekelo kinono? ");
INSERT INTO bwc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Eikyo mwilasakamana nokuipusya ukuti: ‘Busye nkalya insi? Busye nkanwa insi? Nangu busye nkafwala kinsi?’ ");
INSERT INTO bwc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pantu ifi, efyo abenafyalo bafwaya, lelo Wisinwe wamumulu alisiba ukuti mulakabila fyonse ifi fintu. ");
INSERT INTO bwc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Lelo intansi fwayeni Ubufumu bwamumulu Nobulungami bwabuko, kabili nafyonse ifi ifyasyala akamipeela. ");
INSERT INTO bwc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Eikyo mwilasakamikwa pabusiku bwa mailo, ubwamailo bukaisakamana ubwine. Kila busiku bwalikwata isakamiko lyabuko. ");
INSERT INTO bwc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mwilapingula abanenu, pakuti mwikapingulwa, ");
INSERT INTO bwc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","pantu insila mupingwilamo abanenu eyo mukamipingwilamo kabili nefipimo mubomfya efyo nemwe mukapiminwamo. ");
INSERT INTO bwc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nikinsi umwena akasanga mulinso lyakwa munonko lelo wafilwa ukumona umulando mulinso lyobe? ");
INSERT INTO bwc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kuti walanda syani kuli munonko ukuti, “Leka nkufumye akasanga mulinso,” ilyo webo taulemona umulando mulinso lyobe? ");
INSERT INTO bwc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Webumbimunda we! Mbale fumya umulando mulinso lyobe elintu walamona fintu wingafumya akasanga mulinso lyakwa munonko. ");
INSERT INTO bwc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Mwilapela ifyamusilo ku mbwa, kabili mwilaposela inkumba ubulungu bwenu ubwa mutengo, pantu kuti syena syabunyantaula nokumyalukila. ");
INSERT INTO bwc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Lomba kikapelwa kuli webo, fwaya walasanga, konkonsya kabili ikiibi kikeswilwa kuli webo. ");
INSERT INTO bwc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pantu onse uwalomba akapeelwa, na onse uwafwaya akasanga kabili nekiibi kikeswilwa ku ukakonkonsya. ");
INSERT INTO bwc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Busye palimwebo nani engapeela umwaana wakwe ilibwe ngamulomba umukate? ");
INSERT INTO bwc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nangu ukumupeela insoka ngamulomba isabi? ");
INSERT INTO bwc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ngakyakuti mwebo nangu muli babi, mwalisiba ukupeela abaana benu ifisuma. Nga Wisinwe wamumulu tekuti akisyepo ukupeela ifintu ifisuma kubamulomba! ");
INSERT INTO bwc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Eikyo mulifyonse, mulekitila bambi fintu mwingafwaya bamikitila, ubu ebupilibulo bwa mafunde na bakasesema.” ");
INSERT INTO bwc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ingilileni pamwinsi uunono. Pantu unono emwinsi lelo uwasalala ninsila iitwala kukonaulwa, kabili nabengi emo bengilila. ");
INSERT INTO bwc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Lelo umwinsi uutwala kumweo unono kabili walyafya nabausanga banono. ");
INSERT INTO bwc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Kengeleni kuli bakasesema babufi, besa kuli mwebo ngempaanga kunse, lelo mukati mimbulu iibi. ");
INSERT INTO bwc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mukabesibila kufisabo. Kumyunga takuseeka imyangasi, nangu amakunyu tayaseeka ku nkololo. ");
INSERT INTO bwc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ikimuti ikisuma kuseeka ifitwalo fisuma, lelo ikimuti ikiibi kuseka ifitwalo ifiibi. ");
INSERT INTO bwc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ikimuti ikisuma teti kitwale ifisabo ifiibi nangu ikimuti ikiibi ukutwala ifisabo ifisuma. ");
INSERT INTO bwc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kabili nekimuti kyonse ikisitwala ifisabo ifisuma kukitema nokukiposa mumulilo. ");
INSERT INTO bwc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Eikyo kansi mukabesibila kufisabo. ");
INSERT INTO bwc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Tebonse abangita ukuti, ‘We mfumu, we Mfumu’ abakengila Mubufumu bwamumulu kanofye abo abakita fintu Taata wamumulu afwaya ukuti bakite. ");
INSERT INTO bwc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pali bulya busiku abengi bakatiila kuli nebo ukuti, ‘We Mfumu, we Mfumu! Busye tatwalesesema mwisina lyobe, no kutamfya ingulu Mwisina lyobe, kabili nokukita ifisungusyo ifingi mwisina lyobe?’ ");
INSERT INTO bwc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Elo nkabeba ukuti, ‘Nsyamisiba. Fumeni apa, mwebantu ababifi mwe!’” ");
INSERT INTO bwc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Eikyo, onse umfwa aya masiwi yandi nokuyakita aaba ngo muntu uwamano uwaakulile iŋanda pelibwe. ");
INSERT INTO bwc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Imfula yalilokele, imilonga yaliiswile nomwela walipupile ku ŋanda lelo tayawile pantu yakulilwe pebwe. ");
INSERT INTO bwc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Lelo umfwa amasiwi yandi nokunayakita aaba ngekipumbu ikyakulile ŋanda pa musenga. ");
INSERT INTO bwc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Imfula yalilokele, imilonga yaliswile, umwela walipupile kuli ilya ŋanda nayo yaliwile. Kabili yawile bubi bubi!” ");
INSERT INTO bwc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Lintu Yesu apwisisye ukulanda ifi, ibumba lyalipapile pa mafundisyo yakwe. ");
INSERT INTO bwc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Talefundisya ngabakafundisya bamafunde, lelo alefundisya nga umo uwakwata amaka. ");
INSERT INTO bwc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Lintu Yesu atentemwike palupili, ibumba ilikalamba lyalimukonkele. ");
INSERT INTO bwc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Elo umuntu uwalekyusiwa nobulwele bwafibasi aisile mufukamina nokulanda ukuti, “Mwemfumu ngamulefwaya kuti mwangundapa.” ");
INSERT INTO bwc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu atambulwile ukuboko amwikata, nokumwasuka ukuti, “Ndefwaya, pola!” Palya pene alipolele kubulwele bwakwe. ");
INSERT INTO bwc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu amwebele ukuti, “Usininkisye ukuti tawebeleko umuntu nangu umo, lelo kailange kuli basimapepo, upela nelambo lintu Mose akonkomesye ngo bunte kuli bena.” ");
INSERT INTO bwc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Lintu Yesu aingile mu Kapenamu, umukalamba wabasilika alimukumenye nokumulomba ubwafwilisyo, ");
INSERT INTO bwc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","aebele ati, “Wemfumu umubomfi wandi nalala pabulo, taleyenda kabili nakyusiwa apakalamba.” ");
INSERT INTO bwc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu amwaswike ukuti, “Nalaya mundapa.” ");
INSERT INTO bwc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Lelo umukalamba wabasilika ayaswike ukuti, “Iyoo Mwemfumu, nsilingile ukuti mwise muŋanda yandi, lelo landenifye isiwi umubomfi wandi alapola. ");
INSERT INTO bwc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Pantu nanebo nalikwata abonakila, kabili nalikwata nabasilika abanakila. Ndeba umo ukuti, ‘Kabiye!’ Nao ayaa kabili naeba umbi ukuti, ‘Isa!’ Nao aisa, kabili ndeba umusya wandi ukuti, ‘kitefi!’ Nao akita.” ");
INSERT INTO bwc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Lintu Yesu aumfwile ifi alisungwike nokweba abamukonkele ukuti, “Ndemyeba ikine kine, nsyasangapo uwakitetekelo mu Israeli ngoyu. ");
INSERT INTO bwc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ndemyeba ukuti, abengi bakesa ukufuma kukabanga nakumasamba nokwikala pamo na Abulahamu, Isaaki na Yakobo pamutebeto Mubufumu bwamumulu. ");
INSERT INTO bwc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Lelo abana babufumu bakaposwa mumfimfi, ukukaba ukulila nokusumanya ameno.” ");
INSERT INTO bwc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesu aebele umukalamba wabasilika ukuti, “Kabiye, kyalaba ngafintu usumine.” Kabili nomubomfi wamusilika alipolele pali kalyakene kasita. ");
INSERT INTO bwc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Lintu Yesu aile muŋanda yakwa Petelo, amweene nyinafyala wakwa Petelo ali pabulo nalwala impepo. ");
INSERT INTO bwc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Amukwete kuminwe apopene nempepo yamuleka, aimine nokutampa ukubatangata. ");
INSERT INTO bwc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ikyungulo, abantu abengi abakwete ingulu babaletele kuli Yesu. Yesu atamfisye ingulu kwisiwi nokundapa bonse abali nabalwala. ");
INSERT INTO bwc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ifi fyakitike pakufikilisya ifyalandile kasesema Esaya ukuti, “Aundepe amalwele yesu nokutuposya.” ");
INSERT INTO bwc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nomba lintu Yesu amwene ibumba lyamukolongana aebele abasambi bakwe ukwabukila busilya bwamumana. ");
INSERT INTO bwc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kafundisya wamafunde aisile kuli ena nokumweba ukuti, “Mwekafundisya, ningipekanya ukuya nemwe konse kuntu muleya.” ");
INSERT INTO bwc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Kabili Yesu amwaswike ukuti, “Bamumbwe balikwata amendo, kabili nefyoni fyalikwata ifinsa lelo Umwana Wamuntu takwata apakusamina umutwe.” ");
INSERT INTO bwc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Naumbi uwali umusambi alandile kuli ena ukuti, “Wemfumu, leka mbale mbwelelemo ndeyasika taata.” ");
INSERT INTO bwc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Lelo Yesu amwaswike ukuti, “Nkonka, kabili leka abafwa basike abafwa banabo.” ");
INSERT INTO bwc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kabili nalintu Yesu apateme mubwato, abasambi bakwe balimukonkole. ");
INSERT INTO bwc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Apopene akashululu kaima pamumana namaputa yalapumaula kubwato, Yesu ena ninsi ali mutulo. ");
INSERT INTO bwc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Abasambi baile kuli Yesu mukumusibusya. Bamwebele ukuti, “Tupususwye we Mfumu, twalafwa!” ");
INSERT INTO bwc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu abaswike ukuti, “Kinsi muletiina, mwebakitetekelo ikinono!” Aimine nokukalipila umwela namaputa, kabili kwali icilenga. ");
INSERT INTO bwc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Abasambi balipapile, nokulanda ukuti, “Busye muntu wamusango syani uyu? Nomwela namaputa nafyo filemumfwila!” ");
INSERT INTO bwc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Lintu Yesu afikile busilya bwamumana, kukyalo kyabena Gadara, bamukumenye kubantu babili abafumine mumanda. Aba bantu balikwete ingulu kabili bali nabakalipa ikyakuti tapali abalepita kuli ilya nsila. ");
INSERT INTO bwc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Palyapene balapunda ukuti, “Nifinsi ulefwaya kuli fwebo, Wemwana wakwa Lesa? Busye waisa mukutukanda ilyo insita yapekanisiwa tailafika?” ");
INSERT INTO bwc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nomba akatalamukilafye kwali umukuni uwankumba uukalamba isyalelya. ");
INSERT INTO bwc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kabili ingulu syapapete Yesu ukuti, “Ngawalatutamfyamo, ututume mumukuni wankumba.” ");
INSERT INTO bwc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kabili Yesu asyebele ukuti, “Kabiyeni,” Syafumine nokuya mumukuni wankumba kabili nomukuni wa nkumba watentemukila mumukonko wayawila mumumana nokufwa. ");
INSERT INTO bwc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Abantu abalesunga inkumba, balibutwike, baile mumusumba, mukulondolola ilyasi lyonse nefyakitike kubantu abakwete ingulu. ");
INSERT INTO bwc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Bonse mumusumba baile mukukumanya Yesu, lintu bamumwene bamupapete ukuti afume mukyalo kyabo. ");
INSERT INTO bwc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu apatame mubwato nokubwelela busilya bwamumana kumusumba wakwe. ");
INSERT INTO bwc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Abantu bamo baletele kuli ena uwabulebe ninsi nalala pabutanda. Kabili lintu Yesu amwene ikitetekelo bakwete, aebele uwabulebe ukuti, “Sipa, wemwana wandi! Imembu syobe syaelelwa.” ");
INSERT INTO bwc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Pali ifi, bakafundisya bamafunde bayebele abene beka ukuti, “Uyu muntu alepontela Lesa!” ");
INSERT INTO bwc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Lelo Yesu ikyo alisibe amatontonkanyo yabo, abepwisye ukuti, “Nikinsi muletontonkanisisya ifyabubifi? ");
INSERT INTO bwc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Busye kinsi kyayangukapo pakulanda ati, ‘Imembu syobe syaelelwa’ nangu ukulanda ati, ‘Ima nokwenda’? ");
INSERT INTO bwc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Lelo nalamilangisya nomba ukuti Umwana wa Muntu alikwata amaka yakwelela imembu.” Eikyo aebele uwabulebe ukuti, “Ima, piita ubutanda bobe kabiye kuŋanda” ");
INSERT INTO bwc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kabili alimine nokuya kwakwe. ");
INSERT INTO bwc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Lintu abantu bamwene ifi, bakwetwe umwenso, kabili balumbenye Lesa pakupeela amaka kubantu. ");
INSERT INTO bwc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Lintu Yesu afumine kuli ilya nkende, amwene kasonkesya wamusonko, wesina lya Mateyo, naikala muntu alebombela. Amwebele ukuti, “Nkonka.” Mateyo aimine nokumukonka. ");
INSERT INTO bwc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kabili ilyo Yesu alelya muŋanda yakwa Mateyo, bakasonkesya bamusonko abengi nababembu baisile yamba ukulya na Yesu kumo nabasambi bakwe. ");
INSERT INTO bwc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Lintu Abafalise bamo bamwene ifi, baipwisye abasambi bakwe ukuti, “Kinsi Kafundisya wenu aliila pamo nabakasonkesya wamusonko elo nababembu bambi?” ");
INSERT INTO bwc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Lelo lintu Yesu abomfwile abaswike ukuti, “Abantu abatuntulu tabakabila shiŋanga kano abalwele. ");
INSERT INTO bwc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kabiyeni musambilile umwalola ifi, ‘Nkabila uluse, telambo.’ Pantu nsyaisa mukwita abalungami lelo nakonka ababembu.” ");
INSERT INTO bwc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Elo abasambi bakwa Yohani kabatisya baisile kuli Yesu nokumwipusya ati, “Nikinsi fwebo naba Falise tufungila, lelo abasambi bobe tabafunga?” ");
INSERT INTO bwc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu abaswike ukuti, “Busye insindisi syakwa sibwinga kuti syaba syani nobulanda ilyo sikili nasibwinga? Lelo insita ikafika ilyo sibwinga akapiitwa pali bena lyena bakalafunga ukulya. ");
INSERT INTO bwc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Takwaba uubika ikikamba ikipya pansalu yakale, pantu ikikamba kipya kuti kyalepula insalu nekipunda kyakulilako. ");
INSERT INTO bwc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nangu ukubika umwangasi uusilabila munyambi isikote, umusango inyambi kuti syapuuka, umwangasi wapongoloka nenyambi syaonaika. Lelo babika umwangasi munyambi isipya epakupususya fyonse fibili.” ");
INSERT INTO bwc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu palya akili alelanda ifi, kwaisile intungulusi yaba Yuda kuli ena, yamufukamina nokulanda ukuti, “Umwana wandi afwafye ililine, nomba twende umutambalikepo amaboko kabili alaba nomweo.” ");
INSERT INTO bwc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Eikyo Yesu aimine nokumukonka kabili nabasambi bakwe baile nao. ");
INSERT INTO bwc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Umwanakasi uwalekyusiwa nomukunko pamyaka ikumi limo naibili aisile kunuma yakwa Yesu, nokukumya kupela yansalu yakwe. ");
INSERT INTO bwc_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Aebele mumutima wakwe ukuti, “Nganakumyafye kunsalu yakwe ndepola.” ");
INSERT INTO bwc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu apilibwike nokumona, alandile ati, “Sipa wemwana wandi umwanakasi,” “Ikitetekelo kyobe kyakuposya.” Pali ilya ine nsita umwanakasi alipolele. ");
INSERT INTO bwc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu aingile muŋanda yantungulusi yaba Yuda. Lintu amwene abalelisya imitolilo nebumba lyabantu abalelolosya, ");
INSERT INTO bwc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","alandile ukuti, “Bonse fumineni panse! Uyu mukasyana tafwile alelefye!” Elo bonse bamuseka. ");
INSERT INTO bwc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Lelo lilyafye abantu bafuma panse, aingile ayamukwata pakuboko, kabili nao aima. ");
INSERT INTO bwc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ilyasi lyapali ifi lyasabankene muli ilya nkende yakyalo. ");
INSERT INTO bwc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu afumine kuli ilya kende, kabili kilya aleya, abaume babili impofu batampile ukumukonka. Bapundile ukuti, “Mwana Davidi, tubelele uluse!” ");
INSERT INTO bwc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Lintu Yesu aingile muŋanda, impofu syaisile kuli ena, kabili nao asipwisye ukuti, “Busye namusumina ati, kuti nakitefi?” Bayaswike ukuti, “Eee, Mwemfumu?” ");
INSERT INTO bwc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yesu aikete amenso yabo nokulanda ukuti, “Nakikitwe, ukulingana ne kitetekelo kyenu!” ");
INSERT INTO bwc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kabili namenso yabo yaliswike. Yesu abasokele ukuti, “Mwiebako nangu umo pali ifi!” ");
INSERT INTO bwc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Lelo bailesabankanya ilyasi pali Yesu muli ilya nkende yakyalo yonse. ");
INSERT INTO bwc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Lintu abaume babili baleya, baletele umuntu uusyalelanda kuli Yesu pantu alikwete ikibanda. ");
INSERT INTO bwc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kabili lintu ikibanda kyantafiwe muli ena, umuntu usyalelanda atampile ukulanda, kabili nabonse balisungwike. Bapundile ukuti, “Tatwatala monapo ifyaifi mu Israeli!” ");
INSERT INTO bwc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Lelo Abafalise balandile ukuti, “Mukalamba wafibanda eumupele amaka yakutamfya ifibanda.” ");
INSERT INTO bwc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kabili Yesu aile aletandala mumisumba yonse nemisi. Afundisye mumasinagogi, abilile Imbila Nsuma yabufumu, nokundapa abantu abalwele amalwele yamisango misango. ");
INSERT INTO bwc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Lintu amwene ibumba lyabantu aiketwe nobulanda, pantu baali nabasakamana, ababula uwakubafwa ngempaanga isyabula kacema. ");
INSERT INTO bwc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Aebele abasambi bakwe ukuti, “Ubusombosi bukalamba, lelo ababomfi banono. ");
INSERT INTO bwc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pepeni kuli Lesa wabusombosi ukuti atume ababomfi abengi mukusombola.” ");
INSERT INTO bwc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu aitile abasambi bakwe ikumi limo nababili nokubapa amaka yakutamfya umipasi yakowela nokundapa amalwele yamisango misango. ");
INSERT INTO bwc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aya emasina ya batumwa ikumi limo na babili, Simoni (uwaleitwa Petelo) na munyina Andereya, Yakobo na munyina Yohani bamwana Zebede, ");
INSERT INTO bwc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipi na Batolomeo, Tomasi na Mateyo kasonkesya wamusonko, Yakobo mwana Alufeya, na Tadeyasi, ");
INSERT INTO bwc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni umwina kenani, na Yudasi Isikalyoti uwafutwike Yesu. ");
INSERT INTO bwc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu atumine aba batumwa ikumi limo nababili nokubeba ukuti, “Mwilaya ku benafyalo na mumisumba ya bena Samaliya. ");
INSERT INTO bwc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Lelo muleya ku mpaanga isyaluba isya muŋanda yakwa Israeli. ");
INSERT INTO bwc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kabili mukalesimikila ukuti, ‘Ubufumu bwakwa Lesa buli mupepi!’ ");
INSERT INTO bwc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mukaleundapa abalwele, mukalebusya abafwa, mukaleundapa abafibasi, nokutamfya ifibanda. Mwapokelela ukwabula ukulipila, eikyo mukalepela ukwabula ukulipilisya. ");
INSERT INTO bwc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mwipiita ulupiya ululi lonse ulwa Siufele, golide nangu ulwa kyela mumifuko yenu, ");
INSERT INTO bwc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","mwipiita akacola nangu imikansu ibili, insapato nangu inkonto. Ababomfi bafwile bapelwa fintu balefwaya. ");
INSERT INTO bwc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Kabili onse umusumba nangu umusi untu mwayamo, fwayenimo umuntu uulingile, mukaleikala nao mpaka mukafume muli ilya nkende. ");
INSERT INTO bwc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ngamwaya paŋanda, mulelanda ukuti, ‘Umutende ube nemwe.’ ");
INSERT INTO bwc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Muli iyo ŋanda nga bamipokelela, lekeni umutende wenu ube paŋanda, lelo nga bakana ukumipokelela umutende wenu umibwelelele. ");
INSERT INTO bwc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kabili umo ngakana ukumipokelela nangu ukumfwa ku masiwi yenu, kunteni ulukungu kunkasa syenu nokufuma muli ulya musumba nangu iyo ŋanda. ");
INSERT INTO bwc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ndemyeba ikinsika ati pabusiku bwabupingusi, Lesa akalangapo uluse ulukulu ku bantu bamu Sodoma na Gomora ukukila uyo musumba. ");
INSERT INTO bwc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Moneni! Namituma nge mpaanga pakati ka mimbulu. Mukengele nge nsoka kabili mufuuke nge nkunda. ");
INSERT INTO bwc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mukengele ku bantu, pantu bakamikwata nokumitwala mufilye, kabili bakamilopola mu masinagogi. ");
INSERT INTO bwc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pamulandu wandi bakamitwala kubalasi nakuli basyamfumu, mukuba bakambone kuli beena, naku Benafyalo. ");
INSERT INTO bwc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Lelo ngabamikwata, mwikasakamana pafyo mukalanda nangu ifyo mukafilanda, lintu insita ikafika mukapelwa ifyakulanda. ");
INSERT INTO bwc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Pantu amasiwi mukalanda tayakabe yenu, yakafuma ku mupasi wakwa Wisinwe ukalalanda muli mwebo. ");
INSERT INTO bwc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Munina akepaisya munina, nawisi akakita fimofine kubana, nabaana nabo bakemina wisi nokumwipaisya. ");
INSERT INTO bwc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kabili mukapatwa kuli bonse pamulandu nesina lyandi. Lelo onse ukasipikisya ukufika kumpela akapusuka. ");
INSERT INTO bwc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ngabamipakasa mu musumba umo, butukileni muli umbi. Ndemyeba ukuti tamwakapwisye umulimo wenu mumisumba yonse iyamu Israeli ninsi Umwana Wamuntu aisa. ");
INSERT INTO bwc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Umusambi tekuti akile kafundisya, umubomfi teti akile imfumu yakwe. ");
INSERT INTO bwc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Umusambi kuti afika pakuba nga kafudisya nomubomfi nge mfumu. Ngakyakuti umutwe wa ŋanda baleewita ukuti Beleezebu, abamuŋanda bakabeta amasina ayabi ukukilapo! ");
INSERT INTO bwc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Mwilabatiina, pantu takuli ikyafimbwapo ikisyakasokoloke, nangu ikyafisama ikisyakesibikwe. ");
INSERT INTO bwc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ifyo ndemyeba mumfimfi mukafilande palubuto, nafyonse mwaumfwa mukumisonga imwe mukalefilanda pamulu wa ŋanda. ");
INSERT INTO bwc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kabili mwilatiina abepaya umubili lelo teti bepaye umweo, lelo muletiina uwingonaula fyonse umubili nomweo mu Gehena. ");
INSERT INTO bwc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Busye utupele tubili tatusitisiwa nolupiya lumo? Lelo tapali nangu kamo akengapona pansi ukwabula ubufwayo bwakwa Wisinwe. ");
INSERT INTO bwc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Imwe nemisisi yakumitwe yenu yalipendwa. ");
INSERT INTO bwc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Eikyo mwilatiina, pantu mwalikila utupele utwingi! ");
INSERT INTO bwc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Bonse abalanda palwalala ukuti baba nanebo, nanebo nkakita fimofine pamenso yakwa Taata mumulu. ");
INSERT INTO bwc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Lelo onse uwankana pamenso ya bantu, nkamukana pamenso yakwa Taata mumulu. ");
INSERT INTO bwc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Mwilatontonkanya ukuti naisa mukuleta umutende pesonde iyoo, nsyaisa mukuleta umutende lelo naleta ulupanga. ");
INSERT INTO bwc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Naisa mukupusanya umwana umwaume nawisi, umwana umwanakasi nanyina, umuko umwanakasi nanyina fyala, ");
INSERT INTO bwc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","kabili abalwani ba muntu, bakaba ba muŋanda yakwe. ");
INSERT INTO bwc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Onse uwatemwa wisi nanyina ukukila nebo tandingile, kabili naonse uwatemwa umwana wakwe umwaume no mwanakasi ukukila nebo tandingile. ");
INSERT INTO bwc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Onse usipiita umusalaba wakwe no kunkonka, talingile ukuba umusambi wandi. ");
INSERT INTO bwc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Onse uwasanga umweo wakwe akaulufya, kabili onse uwalufya umweo wakwe pamulandu wandi akausanga. ");
INSERT INTO bwc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Onse uwamipokelela ninsi apokelela nebo, kabili naonse uwampokelela ninsi apokelela uwantuma. ");
INSERT INTO bwc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Onse uwapokelela kasesema pamulandu wakuti ni kasesema, akapokelela ikilambu kyakwa kasesema, kabili naonse uwapokelela umuntu umulungami pamulandu wakuti mulungami, akapokelela ikilambu kya mulungami. ");
INSERT INTO bwc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kabili naonse uwapeela kamo pali utu twaike ulukombo lwamensi yatalala pamulandu wakuti kamusambi kandi, ndemyeba ikinekine nati akapokelapo ikilambu kyakwe.” ");
INSERT INTO bwc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Lintu Yesu apwiile ukulangilila abasambi bakwe ikumi limo nababili ifyakukonka, afumine kuli ilya nkende nokuya mukufundsiya nokusimikila mumisumba yamu Galili. ");
INSERT INTO bwc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nomba lintu Yohani Kabatisya mukifungo aumfwile pafintu fyonse Klistu aleekita, atumineko abasambi bakwe bamo kuli ena. ");
INSERT INTO bwc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Baipwisye Yesu ukuti, “Busye niwebo uuli nokwisa nangu tuloleleko umbi?” ");
INSERT INTO bwc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu ayaswike ukuti, “Kamwebeni Yohani fintu muleumfwa nafintu mulemona, ");
INSERT INTO bwc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","impofu silemona, ifilema fileyenda, abafibasi balepola, bankomya matwi baleumfwa, abafwa balebusiwa, kabili ne Mbila Nsuma ilebilwa kubabusu. ");
INSERT INTO bwc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Alipalwa uusiipununa pamulandu wandi!” ");
INSERT INTO bwc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Lintu abasambi bakwa Yohani baile, Yesu atampile ukulanda pali Yohani kwi bumba ukuti, “Lintu mwaile kuli Yohani mukiswebebe, kinsi mwaleenekela ukumona? Busye litete lilepunga kumwela? ");
INSERT INTO bwc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Busye kinsi mwaile mukumona? Busye muntu uwafwele insalu syabusaka? Iyoo abantu abafwala ifyo bekala ku kipango! ");
INSERT INTO bwc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Busye kinsi mwaile mukumona? Busye nikasesema? Ee, lelo ndemyeba ukuti, mwamwene uwakila pali kasesema. ");
INSERT INTO bwc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yohani emuntu amalembo yalandapo ukuti, ‘Moneni, nkatuma intumi yandi iyakuntangilila, iyakukupekanisisya insila.’ ");
INSERT INTO bwc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ndemyeba ukuti Yohani mukalamba ukukila bonse abaikalapo pakyalo. Lelo uwakepesya Mubufumu bwa mumulu mukalamba ukukila Yohani. ");
INSERT INTO bwc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ukufuma pansita yakwa Yohani Kabatisya ukufika nandakai Ubufumu bwamumulu bwaba bwakulwila, nababulwila pamaka ebabupoka. ");
INSERT INTO bwc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Pantu bakasesema bonse namafunde yalesesema ukufika pali Yohani, ");
INSERT INTO bwc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ngamulefwaya ukusumina imbila yabo, Yohani ni Eliya uo balandile ukuti ali nokwisa. ");
INSERT INTO bwc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Uuli namatwi omfwe! ");
INSERT INTO bwc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Nomba, busye nipii ningapasyanya ino nkulo? Ili nga baike abaleyangala pakisankano. Ibumba limo lilebilisya ilinankwe ukuti, ");
INSERT INTO bwc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Twalimilisisye inyimbo syapa bwinga, lelo tamwakindile! Twalimimbile cilolo, lelo tamwalilile!’ ");
INSERT INTO bwc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Pantu lintu Yohani aisile talelya nokunwa, kabili nabonse balandile ukuti, ‘Alikwata ikibanda!’ ");
INSERT INTO bwc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Lintu Umwana Wamuntu aisile aliliile nokunwa, kabili bonse balandile ukuti, ‘Moneni uyu muntu, alalisya, kabili alanwa, nikibusa wabakasonkesya bamusonko na babembu!’ Nomba ifikitwa fyamano yakwa Lesa filasinina ukuti wakisinka.” ");
INSERT INTO bwc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesu atampile ukwebaula imisumba umo akitile ifipesyamano ifingi, lelo abantu tabalapile. ");
INSERT INTO bwc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Walisyama, we Chorazini! Walisyama, we Betisaida! Ifisugusyo ifyakitwa muli webo fingakitwa mu Tare nangu Sidoni, abantu bamulya ngabalilapile akale mukufwala ifilanga nokuisuba imito! ");
INSERT INTO bwc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ndemyeba ukuti pabusiku bwa Bupingusi Lesa akalangapo uluse ulukalamba kubantu bamu Tare na Sidoni ukukila mwebo! ");
INSERT INTO bwc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kabili nawe Kapenamu! Busye walefwaya ukuisansabika ukufika mumulu? Ukaposwa ku Gehena! Ifisungusyo fyakitilwe muli webo fingakitwa mu Sodoma nandakai ngepoili! ");
INSERT INTO bwc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Eikyo ndemyeba ukuti Pabusiku bwa bupingusi Lesa akalangapo sodoma uluse ulukulu ukukila mwebo!” ");
INSERT INTO bwc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Pali iyoine nsita Yesu aebele ukuti, “Mwetaata, Imfumu ya mumulu napesonde! Namitotela pantu ifi fintu mwalififisa kubamano naku basambilila, mwafisokolola ku bana. ");
INSERT INTO bwc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ee, Mwetata ifi fyali bufwayo bwenu. ");
INSERT INTO bwc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tata alimpela ifintu fyonse. Kabili takwaba uwaisiba Umwana kanofye Wisi, kabili takwaba uwaisiba Wisi kanofye Umwana nabo bonse abo Umwana aasala ukusokolwela. ");
INSERT INTO bwc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Iseni kuli nebo, mwebacucutika, namweba fininwa nefisendo, nalamipeela ukutuusya. ");
INSERT INTO bwc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Piteeni ikoli lyandi, kabili nokusambilila kuli nebo, pantu ndiwamutembo kabili nalifuuka mu mutima, kabili mukasanga ukutuusya. ");
INSERT INTO bwc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Pantu ikoli lyandi talyayafya, nekisendo kyandi kyalyanguka.” ");
INSERT INTO bwc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yesu na basambi bakwe baaleyenda mwibala lya ŋano Pesabata. Abasambi bakwe bayambile ukusaba imisonso ya ŋano balalya pantu balyumfwile insala. ");
INSERT INTO bwc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Lelo lintu Abafalise bamwene ifi baebele Yesu ukuti, “Mona, abasambi bobe balekita ifyakanisiwa ukukita Pesabata!” ");
INSERT INTO bwc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu ayaswike ukuti, “Busye tamwabelenga fintu Davidi akiitile na bantu bakwe lintu baumfwile insala? ");
INSERT INTO bwc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Aingile muŋanda yakwa Lesa na bantu bakwe nokulya umukate wapelwe kuli Lesa, nanguline takyali nakisuminisiwa mumafunde bena ukulya, kanofye basimapepo ebaali nabasuminisiwa ukulya. ");
INSERT INTO bwc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nangu busye tamwabelenga mwifunde ukuti basimapepo bamwi Tempele abalebomba pe Sabata bakaana ukusunga ikyebo kya pabusiku bwe Sabata, lelo bali abakaele? ");
INSERT INTO bwc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ndemyeba ukuti pano pali uwakila pe Tempele. ");
INSERT INTO bwc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mwingesiba umwalola ukuti, ‘Ine mfwaya uluse telambo lyanama.’ Ngatamupeela abakaele imilandu, ");
INSERT INTO bwc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","pantu Umwana Wamuntu ni Mfumu ye Sabata.” ");
INSERT INTO bwc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu afumine kuli ilya nkende nokuya ingila mu sinagogi lyabo, ");
INSERT INTO bwc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","kabili kwali umuntu uwali nekisansa kyalemana. Baipwisye Yesu ukuti, “Busye kyalisuminisiwa ukundapa Pesebata?” Pakuti bamupele umulandu. ");
INSERT INTO bwc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu ayaswike ukuti, “Ngakyakuti umo pali mwebo nakwata Impaanga elo yawila mukikulo Pesabata, busye tekuti ailobole? ");
INSERT INTO bwc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Busye umuntu takindamapo ukukila Impaanga! Eikyo kyalisuminisiwa ukukita ikisuma pabusiku bwe Sabata.” ");
INSERT INTO bwc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Elo aebele umuntu ukuti, “Tambalika ukuboko kobe.” Umuntu atambalike ukuboko, kabili kwalipolele nga kumbi ukwasyala. ");
INSERT INTO bwc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Elo Abafalise bafuma baya mukumfwana ifya kwipaya Yesu. ");
INSERT INTO bwc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ikyo Yesu alisibe amapange yabo, alifumine kuli ilya nkende, kabili ne bumba ilikalamba lyalimukonkele nao alibondepe bonse. ");
INSERT INTO bwc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Alibasokele ukuti beyebako bambi pali ena. ");
INSERT INTO bwc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ifi fyali kufikilisya ifyalandile kasesema Ezaya ukuti, ");
INSERT INTO bwc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Uyu emubomfi wandi, uo nasala, uo natemwa, kabili uo mbekelwamo. Nkabika Umupasi wandi pali ena, kabili akasimikila ubupingusi kufyalo. ");
INSERT INTO bwc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Takalekita fikansa nangu ukupuunda, tapakabe uukomfwa isiwi lyakwe mumisebo. ");
INSERT INTO bwc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Takafunaule itete ilyafwantwa, nangu ukusimya ulukuni ululepya. Mpaka umulinganya ukakimfye, ");
INSERT INTO bwc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","kabili ifyalo fikabika isubilo muli ena.” ");
INSERT INTO bwc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Baletele kuli Yesu umuntu uwali impofu kabili talelelanda pantu alikwete ifibanda. Nao Yesu aundepe umuntu ayamba ukumona nokulanda. ");
INSERT INTO bwc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ibumba lyonse lyalipapile pali fintu Yesu akiitile. Baipwisye ukuti, “Busye kuti aba Mwana wakwa Davidi?” ");
INSERT INTO bwc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Lintu Abafalise bena baumfwile ifi bayaswike ukuti, “Atamfya ifibanda pamulandu umukalamba wafibanda Belezebu alamupeela amaka yakutamfya.” ");
INSERT INTO bwc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu alisibe fintu baletontonkanya eikyo abebele ukuti, “Ubufumu bonse ngabwayakanika nokwamba ukuilwisya teti bwiminine. Kabili nomusumba nangu ulupwa ulwayakanika mu mabumba nokwamba ukuilwisya lukonaika. ");
INSERT INTO bwc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kansi Satana ngakuti atamfya Satana ninsi aimina umwine eka. Nomba busye ubufumu bwakwe kuti bwaiminina syani? ");
INSERT INTO bwc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ngantamfya ingulu ukubomfya Belezebu. Kansi ngabana benu bena batamfisya mu maka yakwani? Abana benu ebakamipingula! ");
INSERT INTO bwc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Umupasi wakwa Lesa ngeumpa amaka yakutamfya ingulu ninsi Ubufumu bwakwa Lesa nabwisa palimwebo. ");
INSERT INTO bwc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Takuli umuntu uwingengilila umuntu uwamaka nokupiita ifyuma fyakwe, kano ayambilapo ukukaka umuntu uwamaka, elo engengila nokupiita ifyuma fyakwe. ");
INSERT INTO bwc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Onse usyaba nanebo ninsi mulwani, usingafwa ukukolonganika ninsi alasalanganya. ");
INSERT INTO bwc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kabili ndemyeba ukuti abantu kuti baelelwa imembu syonse nefyabubifi balaanda, lelo onse uwapontela Mupasi wamusilo takelelwe. ");
INSERT INTO bwc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nowalanda amasiwi yamusalalula pa Mwana Wamuntu kuti aelelwa, lelo uwapontela Mupasi Wamusilo takelelwe pali ndakai nomuyayaya. ");
INSERT INTO bwc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Pakukwata ikitwalo ikisuma kukwata ikimuti ikisuma, ngokwete ikimuti ikibi ukakwata ikitwalo ikibi. Ikimuti bakisibila kufitwalo kitwala. ");
INSERT INTO bwc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mwensonka mwe! Kuti mwalanda syani ifintu ifisuma mwe babifi? Pantu akanwa kalanda ifyaisula mumutima. ");
INSERT INTO bwc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Umuntu umusuma afumya ifintu ifisuma ifyamukipao kyakwe ikisuma, kabili nomubifi afumya ifintu ifibi ifyamukipao kyakwe ikibi. ");
INSERT INTO bwc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Lelo Ndimukumyeba ukuti, pabusiku bwa bupingusi umuntu onse akalubulula pesiwi lyonse ilyabula ubuyo aalandapo. ");
INSERT INTO bwc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Amasiwi yenu yakabomfesiwa mukumipingula, kukulanda ati muli bakaele nangu muli bamilandu.” ");
INSERT INTO bwc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Elo bakafundisya Bamafunde naba Falise bamo baeba Yesu ukuti, “Wekafundisya, Tulefwaya ukumona ikisibilo kuli webo.” ");
INSERT INTO bwc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Lelo Yesu abaswike ukuti, “Inkulo iyabubifi kabili iyabukende ilomba ikisibilo, lelo tapali ikisibilo ikikapelwa kuli yena ukukila ikisibilo kyakwa kasesema Yona. ");
INSERT INTO bwc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Filyafine Yona apwiile insiku sitatu, ubusiku nakasuba munda yakisabi, efintu no Mwana Wamuntu akapwa insiku sitatu, ubusiku nakasuba mu musili. ");
INSERT INTO bwc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Pabusiku bwa bupingusi abantu baku Ninive bakeminina nokumipa umulandu, pantu balilapile imembu syabo lintu baumfwile Yona alesimikila, nomba ndemyeba nati, pano pali umukalamba ukukila Yona! ");
INSERT INTO bwc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Pabusiku bwa bupingusi Namfumu waku Sheba akeminina nokumipa umulandu, pantu alyendele ukufuma kukyalo kyakwe ukwisa umfwa kumafundisyo ayamano ku mfumu Solomoni, kabili ndemyeba nati, pano pali umukalamba ukukila Solomoni! ");
INSERT INTO bwc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ilyo umupasi wakowela wafuma mumuntu, ulaya ulelulumba umwabula amensi mukufwaya umwakutuusya kabili taumusanga. ");
INSERT INTO bwc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Uyeba uwine weka ukuti, ‘Nalabwelela muŋanda yandi.’ Ilyo wabwelelamo nokusanga tamuli nangu kimo, namupyangwa, nabamubika bwino, umwabusaka. ");
INSERT INTO bwc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ulaya wayapiita imipasi simbi isili kinelubali isyabipisyapo ukuukila, nokwisa ikala mulya. Nomba imibeele yabumi bwaulya muntu, iya pakulekelesya yabipisyapo ukukila iyantansi. Ifi efikakitika kuli ino nkulo iyibifi.” ");
INSERT INTO bwc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Lintu Yesu aalelanda na bantu, nyina na bamunyina bakwa Yesu balifikile. Baiminine panse balefwaya ukuti balande nao. ");
INSERT INTO bwc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Umo pa bantu abaali kulya amwebele ukuti, “Banoko na bamunoko beminine panse balefwaya ukulanda nobe.” ");
INSERT INTO bwc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu amwaswike ukuti, “Busye bamayo nibani? Nangu bamuninane bandi nibani?” ");
INSERT INTO bwc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Elo asonta pabasambi bakwe nokulanda ukuti, “Moneni! Aba ebamayo nabamuninane! ");
INSERT INTO bwc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Onse uukita ubufwayo bwakwa Taata emuninane, enkansi yandi kabili emayo.” ");
INSERT INTO bwc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Bulyabwine busiku Yesu afumine muŋanda nokuya mumbali ya mumana eko aikele. ");
INSERT INTO bwc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ibumba ilikalamba lyalimukolongene ikyakuti apateme mubwato emo aikala, kabili nebumba lyonse lyaiminine kunshiko. ");
INSERT INTO bwc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Abebele ifintu ifingi mumilumbe ukuti, “Katanda wa mbuto aile mukutanda. ");
INSERT INTO bwc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nalintu atandile, imbuto simo syaponene mumbali yansila, kabili nefyoni fyaisilelya. ");
INSERT INTO bwc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Simbi syaponene pansakalabwe, apaali iloba ilinono, inseke syatampile ukumena bwangu bwangu pantu umusili tawaile saana pansi. ");
INSERT INTO bwc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lelo lintu akasuba katulile, fyonse fyalipile nokubonsa pantu tafyakwete imisila. ");
INSERT INTO bwc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Simbi syaponene mu myunga. Imyunga syalikulile nokwisa sitabilila. ");
INSERT INTO bwc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Lelo simbi syaponene mu musili uusuma, kabili syalikulile nokutwala ifisabo, imiku umwanda umo, simbi amakumi mutanda, nasimbi amakumi yatatu (30) ukukila isyabyelwe. ");
INSERT INTO bwc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Uukwete amatwi naomfwe!” ");
INSERT INTO bwc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Elo abasambi baisile kuli Yesu bamwipusya ukuti, “Nikinsi ulandila nabantu mumilumbe?” ");
INSERT INTO bwc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu abaswike ukuti, Pantu ukwisiba inkama ya bufumu bwa mumulu kwalipelwa kuli mwebo, lelo tekuli bena. ");
INSERT INTO bwc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pantu umuntu uwakwatapo fimo akapelelwapo nafimbi, pakweba ati akakwate ifingi ukukilapo, lelo umuntu usyakwata nangu kimo akapokwa na kanono kantu akwata. ");
INSERT INTO bwc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ifi efintu ndandila nabo mumilumbe, “Pakuti balolesye, lelo ukwabula ukumona kabili bomfwe lelo ukwabula ukwiluka. ");
INSERT INTO bwc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ubusesemo bwakwa kasesema Esaya bwalifikilisye kuli bena ukuti, “‘Mukomfwa lelo ukwabula ukwiluka, mukalolesya lelo ukwabula ukumona, ");
INSERT INTO bwc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","pantu imitima yaaba bantu tayakutulukwa, kabili na matwi yabo yalikoma. Kabili baalisala amenso yabo, Ngateifyo amenso yabo, ngayalamona, na matwi yabo ngayalomfwa, Ne mitima yabo ngaileluka kabili ngabalibwelela kuli nebo ukuti imbondape.’ ");
INSERT INTO bwc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Lelo yalipalwa amenso yenu pantu yalamona, namatwi yenu pantu yalomfwa. ");
INSERT INTO bwc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ndemyeba ukuti bakasesema abengi na bantu abalungami balefwaisya ukumona ifi, lelo tabafimwene, kabili balefwaisya ukumfwa ifi muleumfwa lelo tabafyumfwile. ");
INSERT INTO bwc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Umfweni nomba umulumbe wakwa katanda fintu ulepilibula. ");
INSERT INTO bwc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Umuntu ngaumfwa imbila yapa Bufumu ukwabula ukwiluka, aba ngembuto syaponene mumbali yansila. Umubiifi alesa nokwisa sompola ifyabyelwe mumitima wakwe. ");
INSERT INTO bwc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Imbuto syaponene pansakalabwe simininako, abantu abomfwa imbila kabili palya pene baipokelela ne nsansa, ");
INSERT INTO bwc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Lelo apo muli bena tamwaba misila. Basipikisyafye apalinga kabili lintu amafya no kupakaswa kwaisa pamulandu wambila balanenuka bwangu. ");
INSERT INTO bwc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Imbuto syaponene mumyunga simininako abo bonse abomfwa imbila, lelo amasakamiko yabwikasi buno nomukonkelelo wafyuma watosya imbila, kabili tabatwala fisabo. ");
INSERT INTO bwc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kabili nembuto syaponene mu musili uusuma simininako abo bonse abomfwa imbila nokwiluka, balatwala ifisabo, bamo imiku umwanda umo, bambi amakumi mutanda, kabili nabambi amakumi yatatu ukukila fintu babyele.” ");
INSERT INTO bwc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu abebele umulumbe naumbi ukuti, “Ubufumu bwa mumulu bwaba ngo muntu uwabyele imbuto isisuma mwibala lyakwe. ");
INSERT INTO bwc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Lelo lilya abantu bonse bali mutulo ubusiku, umulwani aisile byalamo kalolo muŋano nokuya. ");
INSERT INTO bwc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kilya imisonga yamena yapakula nokupakula, elo kalolo nayo yamoneka. ");
INSERT INTO bwc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ababomfi baulya muntu baisile kuli ena nokumweba ukuti, ‘Mwemfumu, busye tamwatandile imbuto isisuma mwibala? Nga kalolo aafumine pi?’ ");
INSERT INTO bwc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ayaswike ukuti, ‘Umulwani ewakitile ifi. Busye ulefwaya tuleyanukulamo kalolo?’ ");
INSERT INTO bwc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Abaswike ukuti, ‘Awe, pantu ilyo mulenukula kalolo kuti mwanukwila pamo neŋano. ");
INSERT INTO bwc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Lekeni iŋano na kalolo fikulile pamo mpaka pa busombosi. Nkeba abakalasombola ukunukulamo kalolo pakwamba, ukuikaka mufikuka nokuyokya, kabili nokulonganya iŋano ukubika mubutala.’ ” ");
INSERT INTO bwc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu abebele umulumbe naumbi ukuti, “Ubufumu bwamumulu bwaba ngo luseke lwa lubanga ulo umuntu apiitile nokuya byala mwibala lyakwe. ");
INSERT INTO bwc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Luseke ulunono panseke syonse, lelo ilyo lwakula, luba kimpunsa ikikalamba palifyonse mwibala. Kisanguka ikimuti, ikyakuti nefyoni fipanga ifinsa kumisambo yakiko.” ");
INSERT INTO bwc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kabili Yesu abeba naumbi umulumbe ukuti, “Ubufumu bwamumulu bwaba nge ntutumusi sintu namayo apiitile angandwila mufipimo fitatu ifyabunga mpaka umufuba onse watutumuka.” ");
INSERT INTO bwc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Fyonse ifi Yesu abomfesye imilumbe pakweba amabumba, taalandile ikintu nangu kimo ukwabula ukubomfya umulumbe. ");
INSERT INTO bwc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Akiitile ifi mukufikilisya fintu kasesema Ezaya alandile ukuti, “Nkabomfya imilumbe pakulanda nabo, nkabeba ifintu ifyafisama ukutula pabubumbo bwe sonde.” ");
INSERT INTO bwc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu afumine pa mabumba nokwingila muŋanda, abasambi bakwe baisile kuli ena nokumweba ati, “Twebe fintu umulumbe wakalolo mwibala ulepilibula.” ");
INSERT INTO bwc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu abasuka ukuti, “Umuntu uwabyele inseke isisuma Mwana Wamuntu. ");
INSERT INTO bwc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ibala lisonde, inseke isisuma bantu aba Mubufumu, kalolo bantu bamubifi, ");
INSERT INTO bwc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","kabili nomulwani uwatandilemo inseke ni Kiwa. Ubusombosi nimpela yankulo, kabili na babomfi babusombosi ni bamalaika. ");
INSERT INTO bwc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ngafilya kalolo alonganikwa nokokewa mumulilo, efintu kikaba na pampela yakyalo. ");
INSERT INTO bwc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Umwana Wamuntu akatuma bamalaika mukukolonganika abo bonse abalenga abantu ukubembuka nabo bonse abakita ifintu ifibi, ukubafumya Mubufumu bwakwe, ");
INSERT INTO bwc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","kabili bakabaposa mwilungu lyamulilo, umukaba ukulila nokusumanya ameno. ");
INSERT INTO bwc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Elo abalungami bakabengesime nga kasuba Mubufumu bwakwa Tata. Uukwete amatwi naomfwe! ");
INSERT INTO bwc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ubufumu bwa mumulu bwaba nge kipao kyafiswa mwibala kintu umuntu atutwila nokufimbapo, elo aya nasansamuka ngansi, asitisya nafyonse fintu aakwata ayasitamo lilya ibala. ");
INSERT INTO bwc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Nakabili Ubufumu bwa mumulu bwaba ngo muntu wamakwebo ulefwaya ubulungu ubwayemba. ");
INSERT INTO bwc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kilya asanga ubwayembesya ayasitisya fyonse fintu aakwata nokuyabusita. ");
INSERT INTO bwc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Kabili Ubufumu bwamumulu bwaba ngo bukonde ubwaposwa pamumana nokwipaya isabi lyamisango yonse. ");
INSERT INTO bwc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lintu isabi lyaisula mubukonde abashila babutintila kunshiko baikala balasala, ilisuma babika mukitunga, ilibi baliposa. ");
INSERT INTO bwc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Efintu kikaba pakupwa kwakyalo, bamalaika bakesapatula abantu ababifi ukubafumya kubalungami ");
INSERT INTO bwc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","nokuyabaposa mwilungu lyamulilo umo bakalila nokusumanya ameno yabo. ");
INSERT INTO bwc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Elo Yesu abepusya ukuti, “Busye Namwiluka ifintu fyonse ifi?” Nabo bamwasuka ukuti, “Ee”. ");
INSERT INTO bwc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kabili abebele ukuti, “Eikyo onse kafundisya Wefunde uwaba umusambi wa Mubufumu bwa mumulu ali ngomwine waŋanda uufumya ifipao fyakwe ifipya ne fyakale muntu afisungila.” ");
INSERT INTO bwc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Lintu Yesu apwisisye ukulanda iyi milumbe alifumine kuli ilya nkende ");
INSERT INTO bwc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","nokubwelulukila ku musumba wakwe. Aafundisye musinagogi nabonse abaumfwileko balisungwike. Baipwisye ukuti, “Busye nipii aafumya aya mano namaka yakukita ifisungusyo?” ");
INSERT INTO bwc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“Busye uyu temwana Kapopa wambao? Busye temwana Mariya? Busye Yakobo, Yosefu, Simoni na Yuda tebamunyina? ");
INSERT INTO bwc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Busye bankasi yakwe tatwikala nabo kuno? Nga nipi aafumya fyonse ifi fintu?” ");
INSERT INTO bwc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Eikyo balimukene. Lelo Yesu abebele ukuti, “kasesema kunkende syonse balamukindika ukufumyakofye mumusumba wakwe nakuli balupwa bakwe.” ");
INSERT INTO bwc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Eikyo takitileko ifisungusyo ifingi pantu tabakwete ikitetekelo. ");
INSERT INTO bwc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Pali ilya nsita Herodi imfumu yamu Galili, yaumfwile ululumbi pali Yesu. ");
INSERT INTO bwc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Yaebele bakilolo bakwe ukuti, “Ni Yohani Kabatisya eubukile kubafwa, ekintu akwatiile amaka yakukita ifisungusyo.” ");
INSERT INTO bwc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Pantu Herodi alikete Yohani, amukaka mu minyololo nokumubika mukifungo. Aakitile ifi pamulandu na Herodyasi muka munyina Filipi. ");
INSERT INTO bwc_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yohani aebele Herodi ukuti, “Takyasuminisiwa webo ukupa Herodyasi!” ");
INSERT INTO bwc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodi alefwaya ukwipaya Yohani lelo aletiina abantu, pantu bena balisumine Yohani ukuti ni kasesema. ");
INSERT INTO bwc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Lelo Pakusefya ubusiku bwa kufyalwa kwakwa Herodi, umwana wakwa Herodyasi umwanakasi alicindile ku ntansi ye bumba kabili alisekesye Herodi, ");
INSERT INTO bwc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ikyakuti alilapile ukumupela kyonse kintu engalomba. ");
INSERT INTO bwc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Lelo nyina ailemusonga, eikyo alandile ati, “Mpeni umutwe wakwa Yohani Kabatisya pansani!” ");
INSERT INTO bwc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Imfumu yalisakamene lelo pamulandu nomulapo yapangile pa menso ya bantu bonse yakonkomesye ukuti bamupele. ");
INSERT INTO bwc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yatumine abakuyaputula umutwe wakwa Yohani mukifungo. ");
INSERT INTO bwc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Baletele umutwe pa nsani bapela akakasyana, nako kayapeela nyina. ");
INSERT INTO bwc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Abasambi bakwa Yohani bapiitile ikitumbi bayasika elo bayaeba Yesu. ");
INSERT INTO bwc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Lintu Yesu aumfwile ifyakitike, afumine kulya nobwato nokuya kunkende yakwe eka. Lelo lintu ibumba lyaumfwile ifi, lyamukonkele ulwa pansi ukufuma mumisumba. ");
INSERT INTO bwc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Lintu Yesu afikile ku nshiko amwene ibumba ilikalamba, umutima wakwe waiswilemo inkumbu, kabili aundepe amalwele yonse. ");
INSERT INTO bwc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mukyungulo abasambi bakwe baisile kuli ena nokumweba ukuti, “Kuno tuli nikukiswebebe kabili nakasuba nakawa, eba abantu baye mumisi bayesita ifyakuti balye.” ");
INSERT INTO bwc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu nao abaswike ukuti, “Tabafwile ukuya, mwebobene bapeniko ifyakuti balye!” ");
INSERT INTO bwc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bayaswike ukuti, “Tukwetefye imikate isano nesabi libili.” ");
INSERT INTO bwc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu alandile ukuti, “Leteni kuli nebo.” ");
INSERT INTO bwc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Aebele amabumba ukwikala pafyani, elo abuula imikate isano ne sabi libili, alolesya mu mulu aapala ifyakulya. Aamokwele imikate isano apela abasambi, nabo abasambi bayakanya abantu. ");
INSERT INTO bwc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Abantu bonse balilile nokwikuta. Kabili nabasambi bapiitile ifitunga ifyaisula ifyakulya fyasyelepo. ");
INSERT INTO bwc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Impendwa yabaume abalile yali amakana yasano (5,000) ukwabula ukupendelako abanakasi, na baana. ");
INSERT INTO bwc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesu aebele abasambi bakwe ukupatama mubwato bamutangilile busilya bwa mumana, ilyo ena alesalanganya abantu. ");
INSERT INTO bwc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Panuma ya kusalanganya abantu, apilukile pa lupili mukupepa. Lintu ikyungulo kyafikile aali kulya kwine eka, ");
INSERT INTO bwc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","lelo pali iyi nsita ubwato bwali nabufika apatali, bwalesenkela namaputa pantu umwela walebusunka. ");
INSERT INTO bwc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kuli kakula Yesu aisile ku basambi, aleyenda pamumana. ");
INSERT INTO bwc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Lintu abasambi bamumwene aleyenda pamumana balitiinine ngansi, baebele ukuti, “Kiwa!” Kabili bapundile no mwenso. ");
INSERT INTO bwc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Lelo Yesu palyapene abeba ukuti, “Tekeni imitima, Ninebo mwitiina!” ");
INSERT INTO bwc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petelo epakulanda ukuti, “Wemfumu, nganiwebo ngeba ingise kuli webo ndeyenda pamensi.” ");
INSERT INTO bwc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu nao amwaswike ukuti, “Isa!” Petelo akokele mubwato nokwamba ukwenda pamensi aleya kuli Yesu. ");
INSERT INTO bwc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Lelo lintu amwene umwela alitinine, ayamba nokwibila mumensi. Alilile ukuti, “Mwe Mfumu, mpususyeni!” ");
INSERT INTO bwc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesu palyapene atambulwile ukuboko amukwata nokulanda ukuti, “We muntu wakitetekelo kinono! Kinsi wakitwisikila?” ");
INSERT INTO bwc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Lintu bapateme mubwato nomwela walala. ");
INSERT INTO bwc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Elo abaali mubwato basinsimwine Lesa ukuti, “Mukiine uli Mwana wakwa Lesa!” ");
INSERT INTO bwc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kabili lintu bayabwike umumana, baisile kukyalo kya Genesareti. ");
INSERT INTO bwc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Lintu abantu bakuli ilya nkende baisibe Yesu, balaisye bonse muli ilya nkende ukuleta bonse abaali nabalwala kuli Yesu. ");
INSERT INTO bwc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Balimupapatile ukuti, aleke abalwele bakumyekofye kumpela yansalu yakwe, kabili na bonse abakumisyeko balipolele. ");
INSERT INTO bwc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Elo Abafalise bamo naba Kafundisya bamafunde bafumine ku Yerusalemu baisa kuli Yesu nokumwipusya ukuti, ");
INSERT INTO bwc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nikinsi abasambi bobe baletobela intambi syafikolwe fyesu? Tabasamba ku minwe pakulya!” ");
INSERT INTO bwc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu abaswike ukuti, “Nemwe nikinsi mutobela ifipope fyakwa Lesa, pamulandu nentambi syenu? ");
INSERT INTO bwc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Pantu Lesa alandile ukuti, ‘Ulekindika wiso na noko,’ kabili ‘naonse uwalanda ifibi pali wisi nangu pali nyina, afwile ukwipaiwa.’ ");
INSERT INTO bwc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Lelo mwebo mulanda ukuti umuntu nganakwata fintu engafwilisya wisi nangu nyina, mulanda ukuti, ‘fyakwa Lesa,’ ");
INSERT INTO bwc_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","eikyo tafwile ukukindika wisi, pamulandu nentambi syenu mulenga imbila yakwa Lesa ibe iyafye. ");
INSERT INTO bwc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mweba bumbimunda! Ezaya alilungike lintu aseseme pali mwebo ukuti, ");
INSERT INTO bwc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Aba bantu bankindikafye pa kanwa, lelo imitima yabo yaba ukutali nanebo. ");
INSERT INTO bwc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bansinsimunafye apafye, namafunde yabo yabuntunse!’” ");
INSERT INTO bwc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu aitile abantu nokubeba ati, “Kutikeni nokwiluka! ");
INSERT INTO bwc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ifingila mukanwa kamuntu tafimulenga ukukowela lelo ififuma mukanwa kamuntu efimulenga ukukowela.” ");
INSERT INTO bwc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Elo abasambi baisile kuli ena nokumweba ukuti, “Busye namwisiba ukuti aba Falise nakibakalipa lintu bakyumfwa fintu mwakilanda?” ");
INSERT INTO bwc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu ayaswike ukuti, “Kyonse ikimuti kintu Taata mumulu tabyala, kikanukulwa. ");
INSERT INTO bwc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Balekeni, nintungulusi impofu, kabili impofu ngayatungulula impofu inankwe bonse kuwiila mucikulo.” ");
INSERT INTO bwc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petelo aebele ukuti, “Tulondolweleni umwalolola uyu mulumbe.” ");
INSERT INTO bwc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu abepwisye ukuti, “Busye nanomba tamwiluka? ");
INSERT INTO bwc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Busye tamumona ukuti kyonse ikingila mukanwa, kipita munda, elo kyafumina kunse ya mubili? ");
INSERT INTO bwc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Lelo ififuma mukanwa, fifuma mu mutima kabili ifi efilenga umuntu ukukowela. ");
INSERT INTO bwc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Pantu mumutima mufuma imilangwe iibi, ukwipaya, ubukende, ubulalelale, ubuŋo, bukambone bwa bufi, no musalula. ");
INSERT INTO bwc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ifi efikowesya umuntu, lelo ukulya ukwabula ukusamba kuminwe takukowesya umuntu.” ");
INSERT INTO bwc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kabili Yesu afumine kulya nokuya kufitungu fya Tare na Sidoni. ");
INSERT INTO bwc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Namayo waku Kenani uwaleikala muli ilya nkende aisile alebilisya ukuti, “We Mfumu, Mwana Davidi mbelela uluse! Umwana wandi umwanakasi alekyusiwa nekibanda.” ");
INSERT INTO bwc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Lelo Yesu tamwaswikepo isiwi nangu limo. Kabili abasambi baisile kuli Yesu no kumupapata ukuti, “Mwebeni aleya! Aletupangilafye ifyongo!” ");
INSERT INTO bwc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu ayaswike ukuti, “Natumwafye kumpaanga isyaluba isya muŋanda yakwa Israeli.” ");
INSERT INTO bwc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Lelo namayo apalamine mupepi, afukama pansi nokumupapata ukuti, “Ngafwilisyeni mwe Mfumu!” ");
INSERT INTO bwc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu ayaswike ukuti, “Tekintu ikyayana ukupiita umukate wabana ukuposela imbwa.” ");
INSERT INTO bwc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nao ayaswike ukuti, “Kisinka mwe Mfumu, lelo nembwa sine silalya ubufungau bupona kwitebulo lyakwa wisikulu.” ");
INSERT INTO bwc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesu epakumwasuka ukuti, “Uli namayo wakitetekelo ikikalamba! Kintu wakilafwaya kyalakitwa kuli webo.” Kabili pali ilya ine nsita, umwana wakwe alipolele. ");
INSERT INTO bwc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kabili Yesu afumine kulya nokuya kumumana wa Galili. Aapilukile mumbali yalupili nokuyaikala kulya. ");
INSERT INTO bwc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Amabumba ayakalamba yaisile kuli ena nokumuletela abantu aabali, abalema, impofu, ababulebe, bankomya matwi nabambi abantu abaali nabalwala, bababikile pankasa syakwa Yesu, nao alibondepe. ");
INSERT INTO bwc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Abantu balipapile ukumona bakibulu balelanda, abalema baleyenda, nempofu silemona kabili balumbenye Lesa wabena Israeli. ");
INSERT INTO bwc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu aitile abasambi bakwe abeba ukuti, “Nabomfwila inkumbu aba bantu, pantu baaba nanebo pansiku sitatu nomba apa tabakwete ifyakuti balye. Nsilefwaya ukubatuma baye ukwabula ukulya pantu kuti bapona ulushile pakuya.” ");
INSERT INTO bwc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Abasambi bamwipwisye ukuti, “Nipi twalasanga ifyakulisya ili ibumba muno mukiswebebe?” ");
INSERT INTO bwc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu abepwisye ukuti, “Mukwete imikate inga?” Nabo bamwaswike ukuti, “Tukwete imikate kinelubali nesabi ilyalinga.” ");
INSERT INTO bwc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu aebele ibumba ukwikala pansi. ");
INSERT INTO bwc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Elo apiita imikate kinelubali nesabi, atasya Lesa, amokola apela abasambi nabo bapeela abantu. ");
INSERT INTO bwc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bonse balilile nokwikuta fyasyalanapo. Abasambi bapiitile ifitunga kinelubali ifyaisula ifyakulya fyasyelepo. ");
INSERT INTO bwc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Impendwa yabaume abaalile ukwabula ukupendelako abanakasi nabana yali amakana yane. ");
INSERT INTO bwc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Panuma Yesu asalanganya abantu, apateme mubwato nokuya kukyalo kya Magadani. ");
INSERT INTO bwc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kabili Abafalise naba Saduki baisile kuli Yesu mukumwesya, eikyo bamwipwisye ukuti abalange ikisibilo ukufuma mumulu. ");
INSERT INTO bwc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Lelo Yesu abaswike ukuti, “Akasuba nga kawa, mulanda ukuti, ‘lelo kwalaba bwino, pantu umulu uli uwakasika.’ ");
INSERT INTO bwc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kabili ulukyelo mulanda ukuti, ‘yalaloka pantu umulu uli uwakasika kabili uwafiita.’ Mwalisiba ukwilula imimonekele ya mulu, lelo teti mwilule ifisibilo fya nsita! ");
INSERT INTO bwc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Inkulo iibifi kabili iyabukende ifwaya ikisibilo, lelo takuli ikisibilo ikikapelwa kuli yena ukukila pa kisibilo kyakwa Yona.” Eifyo Yesu alibasile nokuya. ");
INSERT INTO bwc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Lintu bayabukile busilya bwamumana, abasambi balilabile ukupiita umukate. ");
INSERT INTO bwc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu abebele ukuti, “Kengeleni ku ntutumusi syaba Falise naba Saduki.” ");
INSERT INTO bwc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bayambawile abene beka ukuti, “Aalandila ifi pamulandu tatupitile umukate.” ");
INSERT INTO bwc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Lelo Yesu aisibe fintu baleyambaula, alandile ukuti, “Mwebakitetekelo ikinono, kinsi muleyambawila pakukana kwata umukate? ");
INSERT INTO bwc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Busye tamwailuka nandakai? Busye tamwibusya imikate isano fintu yalisisye abantu amakana yasano? Busye mwaiswisye ifitunga finga, ifya fyakulya fyasyelepo? ");
INSERT INTO bwc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nga pamikate kinelubali iyo nalisisye abantu amakana yane? Busye mwaiswisye ifitunga finga, ifya fyakulya fyasyalepo? ");
INSERT INTO bwc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nikinsi mwakifililwa ukwiluka ukuti nsyakilalanda pa mukate? Kengeleni kuntutumusi syaba Falise naba Saduki.” ");
INSERT INTO bwc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Elo abasambi bailwike ukuti taalelanda pa ntutumusi sya mumikate, lelo nipamafundisyo yaba Falise naba Saduki. ");
INSERT INTO bwc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Lintu Yesu aisile mukitungu kya Kaesaliya Filipi, aipwisye abasambi bakwe ukuti, “Busye abantu balanda ukuti Umwana Wamuntu ninani?” ");
INSERT INTO bwc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bayaswike ukuti, “Bamo balanda ukuti ni Yohani Kabatisya, bambi balanda ati ni Eliya, elo bambi balanda ukuti ni Yeremaya nangu umo muli ba kasesema.” ");
INSERT INTO bwc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Elo Yesu abepwisye ukuti, “Ngamwebo mulanda ukuti ninebo nani?” ");
INSERT INTO bwc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Petelo ayaswike ukuti, “Niwebo Klistu, Umwana wakwa Lesa uwamweo.” ");
INSERT INTO bwc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu amwaswike ukuti, “Walipalwa we Simoni mwana Yohani, pantu tekumuntu iki kisinka kyasokolwelwa kuli webo, lelo ni Taata uwamumulu ewakupela ubusokololo. ");
INSERT INTO bwc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kabili nakweba ukuti niwebo Petelo, kabili napa ili libwe nkakulapo ulukuta lwandi nempongolo syamaka yamfwa tafyakalukinfye. ");
INSERT INTO bwc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nkakupa imfungulo syabufumu bwa mumulu, kyonse kintu wakaka pesonde, namumulu kikakakwa, kabili nakyonse kintu wakakula pesonde na mumulu kikakakulwa.” ");
INSERT INTO bwc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Elo Yesu asoka abasambi bakwe ukuti tabafwile ukwebako umuntu nangu umo ukuti ni Klistu. ");
INSERT INTO bwc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ukufuma pali ilya nsita Yesu ayambile ukweba abasambi bakwe ukuti, “Nkaya ku Yerusalemu mukukyula apakalamba ku bakalamba, kuli basimapepo bakindami nabakafundisya Bamafunde. Nkepaiwa, lelo panuma yansiku sitatu nkabusiwa kubafwa.” ");
INSERT INTO bwc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petelo apiitile Yesu pambali nokumukalipila ukuti, “Iyoo we Mfumu! Ifi tafyakamikitikile!” ");
INSERT INTO bwc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu apiilibwike nokweba Petelo ukuti, “Fuma kuli nebo Satana! Uli kyakumpumfyanya munsila yandi, pantu amatotonkanyo yobe yabuntunse tayalefuma kuli Lesa.” ");
INSERT INTO bwc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yesu aebele abasambi bakwe ukuti, “Onse ulefwaya ukuba umusambi wandi, aikane umwine, apiite umusalaba wakwe nonkunkonka. ");
INSERT INTO bwc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pantu onse upususya umweo wakwe akaulufya, lelo onse ulufya umweo wakwe pamulandu wandi akausanga. ");
INSERT INTO bwc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Busye umuntu finsi engakwatamo, nganonka isonde lyonse, lelo alufya umweo wakwe? Takuli kintu umuntu engapela ukukabusya nomweo. ");
INSERT INTO bwc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Pantu Umwana Wamuntu alinokwisa mubukata bwakwa Wisi naba Malaika bakwe, mukulambula umuntu ukulingana nefikitwa fyakwe. ");
INSERT INTO bwc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ndemyeba ikisinka ukuti bamo pano tabakafwe mpaka bakamona Umwana Wamuntu aleisa Mubufumu bwakwe.” ");
INSERT INTO bwc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Panuma yansiku mutanda Yesu apiitile Petelo, Yakobo namunyina Yohani pa lupili ulutali apo baileba beka. ");
INSERT INTO bwc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yesu ayalwike pamenso yabo. Pamenso yakwe pabengesime nga kasuba. Nensalu syakwe syasangwike isyabuta ngo lubuuto. ");
INSERT INTO bwc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kabili kwamonekele Mose na Eliya baleambaula na Yesu. ");
INSERT INTO bwc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petelo epakweba Yesu ukuti, “We Mfumu kuti kyawama twaikala pano. Ngaulefwaya nalakula imitanda itatu, umo uobe, umo uwakwa Mose naumbi uwakwa Eliya.” ");
INSERT INTO bwc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Lintu Petelo akili alelanda, awe inkumbi ilyabeka lyabakupa, kabili nesiwi lyafumine mumakumbi nokulanda ukuti, “Uyu Mwana wandi untu natemwa, eombekelwamo mumfwileni!” ");
INSERT INTO bwc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Lintu abasambi baumfwile isiwi, bawile pansi ubunkupeme kabili baiketwe nomwenso. ");
INSERT INTO bwc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Lelo Yesu aisile kuli bena nokubakumya, elo abeba ukuti, “Imeni, mwitiina!” ");
INSERT INTO bwc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Lintu bainwine amenso tabamwene nangu umo lelo Yesu ekafye. ");
INSERT INTO bwc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Lintu baletentemuka pa lupili, Yesu abakonkomesye ukuti, “Mwiyebako nangu umo ikimonwa, mpaka Umwana Wamuntu akabusiwe kubafwa.” ");
INSERT INTO bwc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kabili abasambi bamwipwisye ukuti, “Busye nikinsi bakafundisya bamafunde balandila ukuti Eliya afwile abalilapo ukwisa?” ");
INSERT INTO bwc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu nao abaswike ukuti, “Kisinka, Eliya ali nokwisapo bwangu kabili akesa mona ukuti ifintu fyonse fyabela muntu fifwile ukubela. ");
INSERT INTO bwc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Lelo ndemyeba ukuti Eliya alisa kale kabili na bantu tabamwisibe, bamukitile ukulingana nefyabasekesye. Efintu no Mwana Wamuntu bakamukyusya.” ");
INSERT INTO bwc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Elo abasambi bailwike ukuti alebeba pali Yohani Kabatisya. ");
INSERT INTO bwc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Lintu babwelele kwibumba, umuntu aisilefukamina Yesu nokumweba ukuti, ");
INSERT INTO bwc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“We Mfumu belela umwana wandi uluse! Pantu alapona ikifulubi kabili alakyula ububi. Ilingi alaponena mumensi na mumulilo. ");
INSERT INTO bwc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nakimuleta ku basambi bobe lelo tabakimundapa.” ");
INSERT INTO bwc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu ayaswike ukuti, “Mwenkulo iisyasumina, kabili iyaumalala imitima! Busye nkekala namwebo ukufika lisa? Busye nkasipikisya ukwikala namwebo ukufika lisa? Leteni akalumendo kuli nebo!” ");
INSERT INTO bwc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu akalipile ikibanda, nakyo kyafumine mukalumendo napali kalya kene kasita kapola. ");
INSERT INTO bwc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Elo abasambi baisile kuli Yesu bamwipusya kumbali ukuti, “Busye nikinsi fwebo twakifililwa ukutamfya ikibanda?” ");
INSERT INTO bwc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Abaswike ukuti, “Nipamulandu wa kitetekelo kyenu ikinono, ndemyeba ikisinka ukuti ngamwakwata ikitetekelo nga kaluseke ka lubanga, kuti mwalanda ku lupili ulu ukuti, ‘Fuma apa selela kulya!’ Nalo kuti lwasela. Tapali ifikasyupa kuli mwebo.” ");
INSERT INTO bwc_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Lelo ifi tafiyafye kano kwi pepo nokufunga. ");
INSERT INTO bwc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Lintu abasambi bakolongene bonse mu Galili, Yesu abebele ukuti, “Umwana Wamuntu alaba pakupelwa mumaboko ya bantu ");
INSERT INTO bwc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","bakamwipaya, lelo panuma ya nsiku sitatu akabusiwa kubafwa.” Kabili abasambi baiswilemo ubulanda. ");
INSERT INTO bwc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Lintu Yesu nabasambi bakwe baisile mu Kapenamu, bakasonkesya bamusonko wamwi tempele baisile ipusya Petelo ukuti, “Busye kafundisya wenu talipila umusonko wa mwi tempele?” ");
INSERT INTO bwc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petelo nao abaswike ukuti, “alalipila.” Kabili lintu Petelo aisile paŋanda, Yesu ewabalilepo ukumwipusya ukuti, “Simoni ngawebo uletipo syani? Nibani balipila umusonko ku mfumu syapano kyalo? Busye bana babo nangu bantu bambi?” ");
INSERT INTO bwc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petelo alandile ukuti, “bantu bambi” Yesu amwebele ukuti, “Ikilepilibula ukuti abana babo tabafwile ukulipila. ");
INSERT INTO bwc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Lelo tatulefwaya ukuleta ubwafya. Kabiye ku mumana uposepo indobani, isabi ulebalilapo ukuloba, wisule mukanwa ulesangamo ulupiya ulwalinga ukulipila umusonko wamwi tempele ulobe nolwandi. Ulupiite uleyabalipila umusonko wesu.” ");
INSERT INTO bwc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Pali ilya nsita abasambi baisile kuli Yesu mukumwipusya ukuti, “Busye ninani umukalamba mu bufumu bwa mumulu?” ");
INSERT INTO bwc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu aitile umwaike amwimika pakati kabo, ");
INSERT INTO bwc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","nokulanda ukuti, “Ndemyeba ikisinka ukuti ngatamupilibwike nokuba ngo mwana umunono tamwakengile mubufumu bwa mumulu. ");
INSERT INTO bwc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Onse uwaikefya ngo mwana umunono, mukalamba mu bufumu bwa mumulu. ");
INSERT INTO bwc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Onse uwapokelela umwana umunono ngoyu mwisina lyandi, ninsi apokelela nebo. ");
INSERT INTO bwc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Lelo onse uwalenga ukuti kamo pali utu twaike utwasumina muli nebo ukubembuka, kyamuwamina ukumukakila ilibwe lya kupelelako mu mukosi nokumuposa pali bemba washika. ");
INSERT INTO bwc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Akalanda pesonde pamulandu wafintu ifilenga abantu ukupunuka! Pantu ifi fintu fyalingile ukwisa, lelo akalanda ku muntu uwalenga fise! ");
INSERT INTO bwc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ukuboko kobe nangu ulukasa lobe ngalwakulenga ukubembuka, kuputuleko nokukuposa! Kyawamapo ukwingila ku mweo ukwabula ukuboko nangu ulukasa ukukila na maboko yabili nangu amakasa yabili nokuposwa mu mulilo wamuyayaya. ");
INSERT INTO bwc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ilinso lyobe ngalyakulenga ukubembuka, lilobole nokuliposa! Kyawamapo ukwingila ku mweo nelinso limo ukukila na menso yabili nokuposwa mu Gehena. ");
INSERT INTO bwc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Moneni ukuti tamusalwilepo nangu kamo pali utu twaike. Pantu ndemyeba ukuti bamalaika batuko mumulu, lyonse bamona ikinso kyakwa Taata mumulu. ");
INSERT INTO bwc_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Pantu Umwana Wamuntu aisile mukupususya abantu baluba. ");
INSERT INTO bwc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Busye mwebo muletipo syani? Umuntu ngalikwata impaanga umwanda umo elo paluba imo? Busye tekuti asye isili amakumi pabula napabula kulupili nokuyafwaya iilubile? ");
INSERT INTO bwc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ndemyeba ikine kine ngaisanga, ala kuti asansamukisya ngansi pali imo iyalubile ukukila pasili amakumi pabula napabula isisilubile. ");
INSERT INTO bwc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Efintu na Wisinwe wamumulu tafwayapo ukuti nangu kamo pali utu twaike ukuloba. ");
INSERT INTO bwc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Munonko ngakubifya, kabiye kuli ena uleyamweba ikilubo uko muli babili. Ngakumfwa ninsi mwawikisyanya na munonko. ");
INSERT INTO bwc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Lelo ngakana ukukumfwa, piitako umuntu umo nangu babili, pakuti ubwafya bonse busininkisiwe kuli bakambone babili nangu batatu. ");
INSERT INTO bwc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kabili ngakana ukubomfwa, londolwelako abakulukuta. Ngakana ukumfwa ku lukuta lyena ninsi lekafye abe kuli webo ngo mwina fyalo nangu kasonkesya wamusonko. ");
INSERT INTO bwc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ndemyeba ikinekine ukuti, kyonse kintu mwakaka pesonde na mumulu kikakakwa, kabili na kyonse kintu mwakakula pesonde na mumulu kikakakulwa. ");
INSERT INTO bwc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Kabili ndemyeba ukuti, ngakyakuti babili pali mwebo basuminisyanya pano isonde pali kintu balomba, Taata wamumulu akabakitila. ");
INSERT INTO bwc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pantu ponse apo babili nangu batatu bakolongana mwisina lyandi nanebo nkaba pakati kabo.” ");
INSERT INTO bwc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Petelo aisile kuli Yesu amwipusya ukuti, “We Mfumu busye miku inga ningelela munyinane uwandufyanya? Busye miku kinelubali?” ");
INSERT INTO bwc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu amwaswike ukuti, “Nsyakwebe ukuti imiku kinelubali lelo ndelanda ukuti,” “amakumi kinelubali, imiku Kinelubali, ");
INSERT INTO bwc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","eikyo ubufumu bwa mumulu bwaba nge mfumu iyalefwaya ukwisiba abasya bakwe fintu babomfesye ulupiya lwakwe. ");
INSERT INTO bwc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Lilya yatampa ukupitulukamo, bailetela umusya umo uwamukongwele ulupiya lwa golide amakana ikumi limo. ");
INSERT INTO bwc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Uyu musya takwete ifyakuti alipile, eikyo imfumu yapingwile ukumusitisya pamo nomukasi wakwe, abana bakwe pamo nafyonse fintu akwete pamulandu wakulipila imisya. ");
INSERT INTO bwc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Uyu musya afukeme ku mfumu nokupapata ukuti, ‘Ndoleleniko, nkamilipila fyonse!’ ");
INSERT INTO bwc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Imfumu yalimumfwilile uluse, eikyo yalimwelele imisya nokumuleka aya. ");
INSERT INTO bwc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Lelo uyu musya lilyafye afumapo, akumanya umusya mubiye uwamukongwele ulupiya lwa golide umwanda umo. Epakumukwata pamukosi alamweba ukuti, “Ndipila fintu wankongola!” ");
INSERT INTO bwc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Umusya mubiye afukeme nokumupapata ukuti, ‘Mpelako akasita, nkakulipila!’ ");
INSERT INTO bwc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Lelo alikene ukumumfwa, asukwa amuposa mukifungo mpaka akamulipile imisya. ");
INSERT INTO bwc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Lintu abasya babiye bamwene ifyakitike, balifulilwe kabili baile kumfumu bayayeba ifintu fyonse. ");
INSERT INTO bwc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Eikyo imfumu yaitile umusya nokumweba ati, ‘We musya umubi we!’ ‘Nalikwelele ulupiya wankongwele lonse pamulandu walimpapete ukuti nkwelele. ");
INSERT INTO bwc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Busye webo tekuti umfwile umubiyo uluse ngafintu nakubelele uluse.’ ");
INSERT INTO bwc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Imfumu yalifulilwe ngansi, ikyakuti yaposele uyu musya mukifungo umo bali nokumukyusya mpaka akalipile ulupiya lonse.” ");
INSERT INTO bwc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ifi efintu Taata wa mumulu akakita kuli onse, ngatamwelela bamunonko ukufuma pansi yamitima yenu.” ");
INSERT INTO bwc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Lintu Yesu apwisisye ukulanda aya masiwi, afumine mu Galili, aile kukyalo kya Yudeya busilya bwa mulonga wa Yodani. ");
INSERT INTO bwc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Amabumba ayakalamba yalimukonkele kabili alibondepe kulya kwine. ");
INSERT INTO bwc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Abafalise bamo baisile kuli Yesu bamwipusya ilipusyo lyakumwesya ukuti, “Busye kyalisuminisiwa umwaume ukuleka umukasi wakwe pamulandu uli onse?” ");
INSERT INTO bwc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu abaswike ukuti, “Busye tamwabelenga ukuti uwababumbile ukutula mukutendeka, abumbile umwaume no mwanakasi? ");
INSERT INTO bwc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kabili nokweba ati, ‘Pamulandu waiki umwaume akasya wisi nanyina nokuyasuntinkana pamo nomukasi wakwe, kabili aba babili bakaba umubili umo.’ ");
INSERT INTO bwc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nomba tabali babili lelo baba umo. Eikyo ikyabika Lesa pamo tapali umuntu uwingalekanya.” ");
INSERT INTO bwc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Abafalise bamwipwisye ukuti, “Busye kinsi Mose aebele umwaume ukulembela umukasi kalata yakupwilapo ikyupo nokumutamfya?” ");
INSERT INTO bwc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu abaswike ukuti, “Nipamulandu wakumalala kwa mitima Mose amisuminisye ukuleka abakasi benu, lelo mukutendeka takyali ngefi. ");
INSERT INTO bwc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kabili ndemyeba ukuti, onse uwaleka umukasi wakwe, pamulandu uusili wabulalelale, aupa naumbi ninsi akita ubukende.” ");
INSERT INTO bwc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Abasambi bakwe bamwebele ati, “Ifi ngefintu kyaba pamulume nomukasi wakwe, ninsi kyawamapo ukukana upa.” ");
INSERT INTO bwc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu abaswike ukuti, “Tebantu bonse abengasumina aya mafundisyo, lelo kanofye kuli abo kyapelwa. ");
INSERT INTO bwc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Pantu kwaliba imilandu iyingi iyo abaume teti bopile, bamo nipamulandu efintu bafyelwefye, bambi teti bope pamulandu abantu ebabalenga ukuba muli iyi nsila, kabili nabambi basalapofye ukuti teti bope pamulandu no bufumu bwa mumulu. Lekeni uwingapokelela ili fundisyo alipokelele.” ");
INSERT INTO bwc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Abantu baletele abana abanono kuli Yesu, ukuti abatambalikepo amaboko nokubapepela. Abasambi balibakalipile. ");
INSERT INTO bwc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Lelo Yesu alandile ukuti, “Lekeni abana abanono bese kuli nebo mwibakanya, pantu ubufumu bwa mumulu bwabo.” ");
INSERT INTO bwc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kabili abatambalikepo amaboko nokufuma kulya. ");
INSERT INTO bwc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Elo umuntu umo aisile kuli Yesu amwipusya ukuti, “We kafundisya, kisumansi ningakita pakukwata umweo wamuyaya?” ");
INSERT INTO bwc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Kabili Yesu amwebele ukuti, “Kinsi ikyo wangitila ati umusuma? Lesa fye eka emusuma. Ngolefwaya ukukwata umweo wamuyaya, ulekonka ifipope fyakwe.” ");
INSERT INTO bwc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Umulumendo aipwisye ukuti, “Busye nifisa?” Yesu amwaswike ukuti, “Wilaipaya, wilakita ubukende, wilaiba, wilabepesya abantu ubufi, ");
INSERT INTO bwc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ulekindika wiso na noko, kabili uletemwa umubiyo ngafitu waitemwa.” ");
INSERT INTO bwc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Umulumendo ayaswike ukuti, “Nalikonka ifipope fyonse ifi, busye nikinsi kimbi mfwile ukukita?” ");
INSERT INTO bwc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu amwaswike ukuti, “Ngaulefwaya ukuba uwapwililika, kabiye uyesitisya fyonse fintu wakwata! Upele ulupiya kubapina, lyena ukakwata ifyuma mumulu. Elo wise unkonke.” ");
INSERT INTO bwc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Lintu umulumendo aumfwile ifi, aile uwabulanda pantu ali nanonkesya. ");
INSERT INTO bwc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kabili Yesu aebele abasambi bakwe ukuti, “Ndemyeba ikinekine ukuti, kintu kyasupa uwafyuma ukwingila mu bufumu bwa mumulu. ");
INSERT INTO bwc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nakabili ndemyeba ukuti, kyayangukapo Ingamila ukupula mu linso lyansindano ukukila uwafyuma ukwingila mu bufumu bwakwa Lesa.” ");
INSERT INTO bwc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Lintu abasambi baumfwile aya masiwi balipapile umupwilapo. Baipwisye ukuti, “Nomba busye kansi ninani uwingapusuka?” ");
INSERT INTO bwc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Lelo Yesu abalolesye nokubasuka ukuti, “Ifi fintu fyayafya kubantu, lelo kuli Lesa fyonse fyalyanguka.” ");
INSERT INTO bwc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petelo ayaswike ukuti, “Mona fwebo twalisya ifintu fyonse nokukukonka. Busye nifinsi tukakwatamo?” ");
INSERT INTO bwc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu abebele ukuti, “Ndemyeba ikine kine ukuti, lintu Umwana Wamuntu akekala pakipuna kya bufumu ikyabukata Mukyalo kipya, namwebasambi bandi ikumi limo na babili, mukekala pafipuna fya bufumu mukupingula imikowa ikumi limo nasibili isya bena Israeli. ");
INSERT INTO bwc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kabili naonse uwasya amayanda, bamunyina, bankasi yakwe, bawisi, banyina, abana nangu amabala pamulandu wandi, akapelelwapo pali fyonse imiku umwanda umo kabili akakwata nomweo wamuyaya. ");
INSERT INTO bwc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Lelo abengi abantansi bakaba abanuma, kabili na bengi abanuma bakaba abantansi. ");
INSERT INTO bwc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Pantu ubufumu bwa mumulu bwaba ngo mwine wa ŋanda, uwafumine kumakya ukuyafwaya abakubomba mwibala lya myangasi. ");
INSERT INTO bwc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Panuma baumfwana nabankito ukubalipila ulupiya lwa busiku bumo, abatumine mwibala mukubomba. ");
INSERT INTO bwc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Munsita ya naini koloko ya luchelo amwene na bambi nabeminina ukwabula ifyakukita pa kisankano, ");
INSERT INTO bwc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","nabo abebele ukuti, ‘Kabiyeni mubombe mwibala lya myangasi, ndemilipila ulupiya ulwalinga.’ ");
INSERT INTO bwc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Efintu baile. Aya nakabili mu kasuba pakati elo namunsita ya fifitini koloko, ayakita fimofine. ");
INSERT INTO bwc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kilya akasuba kaba mukuwa muma seventini koloko asanga nabambi bemininefye. Abepusya ukuti, “Kinsi mwimininine pano akasuba konse ukwabula ukulakita nangu kimo?” ");
INSERT INTO bwc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nabo bamwaswike ukuti, ‘Nikyo tapali abakutwingisya inkito.’ Elo abeba ukuti, ‘Nemwe bene kabiyeni kabombeni mwibala lya myangasi.’ ");
INSERT INTO bwc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Lintu ikyungulo kyafikile, umwine we bala aebele kangalila wa bankito ukuti, ‘Ita abankito bonse ubalipe amalipilo yabo, wambile ku bakingila inuma, ulekelesye kuba kingila intansi.’ ");
INSERT INTO bwc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Lintu Abankito abayambile ukubomba pansita ya seventini koloko baisile, bafolele amalipilo yabusiku bumo. ");
INSERT INTO bwc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Lintu abaingile intansi baisile, baletontonkanya ati balefolapo amalipilo ayakulu pali bonse. Lelo bonse bafolele lumolwine. ");
INSERT INTO bwc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Lintu bapokele bayambile ukuilisyanya ku mwine we bala. ");
INSERT INTO bwc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Bamwebele ukuti, ‘Aba abanuma bakibombakofye insita imo. Lelo mwabalipa fimofine nafintu mwakitulipa. Twakilabomba mukasuba ninsi nakabala!’ ");
INSERT INTO bwc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Umwine we bala ayaswikepo umo pabankito ukuti, ‘Mune nsikufyengele, milipile amalipilo yabusiku bumo yantu twakyumfwana. ");
INSERT INTO bwc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Piita amalipilo yobe uleya! Nemwine ndefwaya ukulipila uyu uwanuma ngafintu nkulipile. ");
INSERT INTO bwc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Busye nsyakwata insambu sya kukita fintu ndimukufwaya no lupiya lwandi? Nangu waumfwa akalumwa pantu ndi wabupe?’” ");
INSERT INTO bwc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Eikyo abanuma bakaba abantasi, kabili na bantansi bakaba abanuma.” ");
INSERT INTO bwc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kabili lintu Yesu aleya ku Yerusalemu, apiitile abasambi bakwe ikumi limo na babili pambali kabili munsila abebele ukuti, ");
INSERT INTO bwc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Moneni, tulimukuya ku Yerusalemu uko Umwana Wamuntu alaya pelwa kuli basimapepo bakindami naba kafundisya bamafunde. Balaya mupingwila ukufwa. ");
INSERT INTO bwc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kabili bakamupela kubenafyalo abakamupunika, ukumulopola, kabili nokumutanika, lelo panuma yansiku sitatu akabusiwa ku bafwa.” ");
INSERT INTO bwc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Elo nyina wa bana bakwa Zebede aisile kuli Yesu nabana bakwe, nokufukama, amulomba ifintu fimo. ");
INSERT INTO bwc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kabili Yesu amwipwisye ukuti, “Nikinsi ulefwaya?” Nao alandile ukuti, “Suminisya abana bandi, mubufumu bobe umo akekale kukulyo kobe naumbi akekale kukuso kobe.” ");
INSERT INTO bwc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu ayaswike ukuti, “Tamwisibe kintu mulelomba. Busye kuti mwanwa ulukombo luntu nalanwa?” Nabo bamwaswike ukuti, “Ee kuti twanwa.” ");
INSERT INTO bwc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu abebele ukuti, “Ee mukanwa mulukombo lwandi, lelo ukwikala kukulyo kwandi nangu kukuso tenebo uwakusuminisya. Isi nkende syabo Taata apekanisisya.” ");
INSERT INTO bwc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Lintu abasambi ukumi limo abasyala baumfwile aya masiwi, balifulilwe bamunyina babili. ");
INSERT INTO bwc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesu abetile pamo bonse nokubeba ukuti, “Mwalisiba ukuti bansyamfumu ba benafyalo balikwata amaka pa bufumu bwabo, nentungulusi syabo silabomfya amaka syakwata pabantu. ");
INSERT INTO bwc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Lelo mwebo mwilakita nga bena. Umo pali mwebo ngalefwaya ukuba umukalamba, abe umubomfi wababiye, ");
INSERT INTO bwc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","nakabili umo ngalefwaya ukuba uwantansi, abe umusya wenu ");
INSERT INTO bwc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","kwati Mwana Wamuntu taisile ukuti bamupwingile lelo aisile mukupyunga nokupela umweo wakwe mukulubula abantu abengi.” ");
INSERT INTO bwc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Lintu balefuma ku Yeriko, ibumba ilikalamba lyalibakonkele. ");
INSERT INTO bwc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Abantu babili abaali impofu abaali nabekala mumbali yamusebo lintu baumfwile ukuti Yesu alepita babilisye ukuti, “We Mfumu Mwana Davidi! Tubelele uluse!” ");
INSERT INTO bwc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ibumba lyalibakalipile nokubeba ukuti bekale tondolo. Lelo bena bakonkenyepofye ukubilisya ukuti, “We Mfumu, Mwana Davidi tulangulukileko!” ");
INSERT INTO bwc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu aiminine nokubeta alabepusya ukuti, “Kinsi mulimukufwaya imikitile?” ");
INSERT INTO bwc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nabo bamwaswike ukuti, “We Mfumu, tulimukufwaya ukumona!” ");
INSERT INTO bwc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu abomfwilile inkumbu kabili abakwete mumenso, palyapene balimwene nokwamba ukumukonka. ");
INSERT INTO bwc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kabili lintu Yesu na basambi bakwe bapalamine ku Yerusalemu, baisile ku Betifage pa lupili lwa Miolife. Yesu atumine abasambi babili, ");
INSERT INTO bwc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nokubeba ukuti, “Kabiyeni mumusi uli kuntansi, kabili mwalaya sanga impunda naikakilwa pamo nakana, mukakule mundetele. ");
INSERT INTO bwc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ngakyakuti umo amipusya, mumwebe ukuti, ‘Imfumu ilefifwaya’ Nao alemileka mupiite impunda.” ");
INSERT INTO bwc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ifi fyakitike mukufikilisya fintu kasesema alandile ukuti, ");
INSERT INTO bwc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Eba umwana umwanakasi Ziyoni ukuti, ‘Mona Imfumu yobe ileisa kuli webo! Naifuka kabili ininine pali punda. Napa kana ka punda.’” ");
INSERT INTO bwc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Abasambi baile nokuyakita fintu Yesu abebele ukukita. ");
INSERT INTO bwc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Baletele impunda nakana, bayansikepo insalu panuma ya mpunda, elo Yesu apilukilapo. ");
INSERT INTO bwc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ibumba lyabantu abengi lyaambile ukwansika insalu syabo mumusebo, bambi nabo baleteta imisambo yafimuti baleyansika mumusebo. ");
INSERT INTO bwc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ibumba ilyali kuntansi yakwa Yesu nelyali kunuma lyayambile ukubilisya ukuti, “Lumbanyeni Mwana Davidi! Alipalwa uwisila mwisina lya Mfumu!” ");
INSERT INTO bwc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Lintu Yesu aingile mu Yerusalemu, mu musumba monse mwakabile nasee! Ku fyongo kabili baleipusyafye ukuti, “Nani uyu?” ");
INSERT INTO bwc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Abantu mwibumba bayaswike ukuti, “Ni Yesu kasesema uwafuma ku Nazareti mu Galili.” ");
INSERT INTO bwc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu aingile mumusolo wetempele nokwamba ukutamfya abantu bonse abalesitisya nokusita. Apilibwile amatebulo yabalekabusya ulupiya nefipuna fyabalesitisya inkunda. ");
INSERT INTO bwc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Abebele ukuti, “Kyalilembwa ukuti, ‘iŋanda yandi iketwa iŋanda yamapepo.’ Lelo mwebo mwaipanga umwakufisama abaŋo!” ");
INSERT INTO bwc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Impofu nabalema baisile kuli Yesu mwitempele, nao alibondepe. ");
INSERT INTO bwc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Lelo lintu basimapepo mukalamba naba kafundisya Bamafunde yakwa Mose bamwene ifisungusyo nokumfwa abaana balebilisya ukuti, “Hosanna kuli Mwana Davidi!” Balifulilwe. ");
INSERT INTO bwc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Baipwisye Yesu ukuti, “Busye naumfwa fintu aba bana balelanda?” Yesu nao abaswike ukuti, “Ee ningumfwa, busye tamwabelenga ilembo ililanda ukuti, ‘Kutunwa twabana naku bakwibele kwafumine amalumbo?’” ");
INSERT INTO bwc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kabili alibasile, afumine mu musumba aya ku Betani, uko ashikilwe ubusiku bonse. ");
INSERT INTO bwc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kumakya, lintu Yesu alebwelulukila ku musumba wa Yerusalemu, ali naumfwa insala. ");
INSERT INTO bwc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Amwene ikimuti kya mukunyu mumbali yamusebo, lelo lintu aileko ailesanga takuli nangu kimo kwalifye amabula. Eikyo alandile kukimuti ukuti, “Tawakatwalepo ifisabo nakabili!” Palyapene ikimuti kya mukunyu kyauma. ");
INSERT INTO bwc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Lintu abasambi bamwene ifi, balipapile ngansi. Baipwisye ukuti, “Busye umukunyu wauma syani apapene?” ");
INSERT INTO bwc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu abaswike ukuti, “Ndemyeba ukuti, nganamukwata ikitetekelo kabili tamutwisike, teifi fyeka nakita mwingakita lelo, kuti mwaeba nolu lupili ukuti, ‘Ima, ipose muli bemba’ nalo lukaiposa. ");
INSERT INTO bwc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nganamusumina, mukapokelela kyonse kintu mwalomba mwipepo.” ");
INSERT INTO bwc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu aile mumusolo we Tempele kabili lilya alefundisya, abakalamba na basimapepo mukalamba baisile mwipusya ukuti, “Ninsambunsi wakwata isyakukita ifi fintu? Ninani wakupela isi nsambu?” ");
INSERT INTO bwc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu abaswike ukuti, “Nalamipusya ilipusyo limo, kabili ngamwangasuka nalamyeba insambu nakwata isyakukita ifi fintu. ");
INSERT INTO bwc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Busye nipi insambu syakwa Yohani isyakubatisya syafumine, busye nikuli Lesa nangu niku bantu?” Bantampile ukwambaula abene beka ukuti, “Busye twalalanda syani? Ngatwayasuka ati, ‘Nikuli Lesa,’ aletweba ukuti, ‘Nikinsi tamwasuminine Yohani?’ ");
INSERT INTO bwc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Lelo ngatwalanda ukuti, ‘Niku bantu,’ Tuletina fintu abantu bengakita, pantu bonse balisininwe ukuti, Yohani ali ni kasesema.” ");
INSERT INTO bwc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Eikyo bayaswike Yesu ukuti, “Tatwisibe.” Nao abebeba ukuti, “Nandibo nsyamyebe kuntu mfumya insambu syakukita ifi fintu.” ");
INSERT INTO bwc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Busye muletipo syani? Kwali umuntu uwakwete abana abaume babili, aile kuwantansi amweba ukuti, ‘Wemwana kabiye uleyabomba mwibala lya myangasi lelo.’ ");
INSERT INTO bwc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Alandile ukuti nsileyako lelo panuma yansita apilibula imilangwe aya bomba. ");
INSERT INTO bwc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Elo Wisi aile kabili ku mwana umbi ayamweba fimofine. Ayaswike ukuti nalaya lelo taileko. ");
INSERT INTO bwc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Busye mwanansi wakitile ifyalefwaya wisi?” Bayaswike ukuti, “Uwantansi.” Eikyo ndemyeba ikinekine ukuti, bakasonkesya bamusonko naba kilende balemitangilila ukwingila mubufumu bwamumulu. ");
INSERT INTO bwc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Pantu Yohani Kabatisya aisile kuli mwebo mukumilanga insila yabulungami, tamwamusumine. Lelo bakasonkesya wamusonko nabakilende balimusumine. Kabili nalintu mwamwene ifi tamwalapile nokusumina. ");
INSERT INTO bwc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kutikeni kumulumbe naumbi, kwali umwine wakisonso uwalimine ibala lya myangasi, akulilileko ulubango, aimbile umwakufinina imyangasi kabili aakula no lupungu. Elo asonkesya ibala kubalimi nokuya mu kyalo kimbi. ");
INSERT INTO bwc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Lintu insita yakusombola yafikile, atumineko abasya bakwe ukuyapiita ifisabo fyakwe. ");
INSERT INTO bwc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Lelo abalesonkelamo bakwete aba abasya bakwe, baumapo umo, umbi bamwipaya kabili naumbi bamutoba amabwe. ");
INSERT INTO bwc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kabili atumineko abasya nabambi abengi ukukila abantansi, nakabili nabo babakitile fimofine. ");
INSERT INTO bwc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mukulekelesya umwine webala atumineko umwana wakwe, ukuti, ‘ikinekine uyu bakaya mukindika.’ ");
INSERT INTO bwc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Lelo lintu abalesonkela bamwene umwana balandile ukuti, ‘Iyi nimpyani, iseni tumwipaye! Nebala likaba lyesu.’ ");
INSERT INTO bwc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Eikyo bamukwete, bamuposa kunse yebala nokumwipaya. ");
INSERT INTO bwc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu abepwisye ukuti, “Busye ilyo umwine webala akesa, nikinsi akesa kita kuli aba bantu?” ");
INSERT INTO bwc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bayaswike ukuti, “Akesaipaya abo bantu ababifi, nokusonkesya ibala kubantu bambi abakalamupa ikyakaniko kyakwe pansita yabusombosi.” ");
INSERT INTO bwc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu abebele ukuti, “Busye tamwabelenga fintu ikyalembwa kilanda? ‘Ilibwe lintu bakakula basulile ngelyabula ubuyo elyaisileba ilikankala pali yonse. Uku kubomba kwakwa Lesa, kabili kipapusyo mu menso yesu!’ ");
INSERT INTO bwc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ndemyeba ukuti ubufumu bwakwa Lesa bukapokololwa kuli mwebo nokupelwa ku bantu abatwala ifisabo. ");
INSERT INTO bwc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“Umuntu onse untu ili libwe lyaponena akaputaulwa mutupimfya naonse uwaponena pali ili libwe akashonaulwa.” ");
INSERT INTO bwc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Lintu basimapepo bakindami naba Falise baumfwile imilumbe yakwa Yesu balisibe ukuti ebantu alelandapo, ");
INSERT INTO bwc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","eikyo bafwaile insila yakumwikatilamo. Lelo baletina ibumba, ilyasumine Yesu ukuti nikasesema. ");
INSERT INTO bwc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nakabili Yesu abebele mu milumbe ukuti, ");
INSERT INTO bwc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ubufumu bwa mumulu kuti bwapasyanisiwa ku mfumu iyapekanisisye umwana wakwe umwaume amatebeto ya bwinga. ");
INSERT INTO bwc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Yatumineko abasya bakwe ukuyaeba abalalikwe ukwisa kumatebeto, lelo balikene ukwisa. ");
INSERT INTO bwc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Elo yatuma abasya nabambi ukuti, ‘Kebeni abalalikwe ukuti, nimpekanya amatebeto nefintu fyonse nafipekanisiwa. Iseni kumatebeto ya bwinga!’ ");
INSERT INTO bwc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Lelo tabaposeleko amano bayangilwefye imilimo yabo, umo aya kwibala lyakwe, umbi aile kuntu alebombela amakwebo, ");
INSERT INTO bwc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","elo bambi bakwete abasya, baboma nokubepaya. ");
INSERT INTO bwc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Imfumu yalifulilwe. Yatumineko abasilika ukuyaipaya abo bantalamisoka nokokya umusumba wabo. ");
INSERT INTO bwc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Elo yaeba abasya ukuti, ‘Ubwinga nabupekanisiwa, lelo abantu abalalikwe balikene ukwisa. ");
INSERT INTO bwc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Eikyo kabiyeni mumisebo muleyalalika abantu bonse bantu mulesanga kumatebeto.’ ");
INSERT INTO bwc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Abasya baile mumisebo nokuya kolonganika bonse abantu basangilemo, ababi na basuma. Kabili muŋanda mwaiswile abantu. ");
INSERT INTO bwc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Lelo lintu imfumu yaisile mukomona abalalikwe, yasangilemo umo uusyafwele insalu syapa bwinga. ");
INSERT INTO bwc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Yamwipwisye ukuti, “Kibusa, busye wakingila syani muno ukwabula ukufwala insalu syapa bwinga?” Lelo takwete ifyakulanda. ");
INSERT INTO bwc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Elo imfumu yaebele abasya ukuti, ‘Mukakeni amaboko namolu mumupose panse mumfimfi. Umukaba ukulila nokusumanya ameno.’” ");
INSERT INTO bwc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Abalalikwa bengi lelo abasalwa banono.” ");
INSERT INTO bwc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Abafalise bakolongene balaumfwana fintu bengakofya Yesu. ");
INSERT INTO bwc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Batumine abasambi babo naba kwa Herodi ukuyalanda ukuti, “Wekafundisya twalisiba ukuti fintu ulanda fyakisinka, ufundisya ikine pabufwayo bwakwa Lesa pabantu, kabili tautiina muntu nangu umo, pantu tawaba nakapatulula. ");
INSERT INTO bwc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Twebe, busye webo uletipo syani? Busye tufwile ukulipila umusonko kuli Kesalo nangu iyoo?” ");
INSERT INTO bwc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Lelo apo Yesu alisibe imilangwe yabo iyabubifi abebele ukuti, “Imwe babumbimunda, kinsi mulengesesya. ");
INSERT INTO bwc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ndangeni ulupiya lwakulipa umusonko!” Bamuletele ulupiya lwamuseke, ");
INSERT INTO bwc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","elo abepusya ukuti, “Busye iki kinso nesina fyakwa nani?” ");
INSERT INTO bwc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bayaswike ukuti, “Fyakwa Kesalo.” Elo Yesu abeba ukuti, “Peleni kuli Kesalo ifyakwa Kesalo, kabili peleni kuli Lesa ifyakwa Lesa.” ");
INSERT INTO bwc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Balipapile lintu baumfwile aya masiwi, kabili bamusile nokuya. ");
INSERT INTO bwc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Bulya bwine busiku, Abasaduki abasumine ukuti takwakabe ukubuka kubafwa baisile ipusya Yesu ukuti, ");
INSERT INTO bwc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Wekafundisya, Mose atwebele ukuti umwaume uwaupa ngafwa ukwabula ukufyalapo abana, munina afwile aupa mukamfwilwa pakuti afyalileko munina abana. ");
INSERT INTO bwc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nomba kwaliko bamunina kinelubali abaleikala kuno. Uwantansi alyupile, kabili afwile ukwabula ukufyalapo abana eikyo umukasi wakwe asyele namunina. ");
INSERT INTO bwc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ikintu kimokine kyakitike kuwabubili, nakuwabutatu namukulekelesya kuli bonse kinelubali. ");
INSERT INTO bwc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Napampela umwanakasi nao afwa. ");
INSERT INTO bwc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nomba pakubuka kwabafwa, busye akaba mukasi wakwani apo bonse bamunina kinelubali balimupilepo?” ");
INSERT INTO bwc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu abaswike ukuti, “Mwaliluba! Pantu tamwaisiba ifyo amalembo yafundisya kabili tamwaisiba namaka yakwa Lesa. ");
INSERT INTO bwc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pakubuka kwabafwa, abantu tabakaleupa nangu ukupwa lelo bakaba nga bamalaika mumulu. ");
INSERT INTO bwc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Lelo pamulandu wakubuka kwabafwa, busye tamwabelenga fintu Lesa amyebele ukuti, ");
INSERT INTO bwc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ninebo Lesa wakwa Abulahamu, Isaaki na Yakobo.’ Ni Lesa wabamweo te Lesa wabafwa.” ");
INSERT INTO bwc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ibumba lyalipapile pakumfwa aya mafundisyo. ");
INSERT INTO bwc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Lintu Abafalise baumfwile ukuti Yesu atalalika Abasaduki, balikolongene pamo. ");
INSERT INTO bwc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Umo pali bena uwali ni kafundisya wamafunde aesesye Yesu mulipusyo ukuti, ");
INSERT INTO bwc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Wekafundisya, busye kipopensi ikikalamba mu Mafunde?” ");
INSERT INTO bwc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu amwaswike ukuti, “ ‘Uletemwa Imfumu Lesa obe, nomutima obe onse, nomweo obe onse kabili namano yobe yonse.’ ");
INSERT INTO bwc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iki ekipope kyantansi kabili ikikalamba. ");
INSERT INTO bwc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ikyabubili niki, ‘Uletemwa umubiyo ngafintu waitemwa.’ ");
INSERT INTO bwc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Amafunde yonse naba kasesema bashinta pali ifi fipope fibili.” ");
INSERT INTO bwc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ilyo Abafalise bakili nabakolongana Yesu abepwisye ukuti, ");
INSERT INTO bwc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Busye mwebo mutontonkanyapo syani pali Mesiya? Busye mulanda ukuti nimwana nani?” Bayaswike ukuti, “Nimwana Davidi.” ");
INSERT INTO bwc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu abepwisye ukuti, “Busye nikinsi Davidi, uwaletungululwa no Mupasi amwitile ukuti ‘Imfumu’? Pantu Davidi alandile ukuti, ");
INSERT INTO bwc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Imfumu yalandile ku Mfumu yandi ukuti, ikala kukulyo kwandi mpaka inkabike abalwani bobe pansi yamakasa yobe.’ ");
INSERT INTO bwc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Davidi ngamwitile ukuti ‘Imfumu,’ Busye kuti aba syani umwana wakwa Davidi?” ");
INSERT INTO bwc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tapaali uwamwaswike, kabili ukutula pali bulya busiku, tapali uwaipwisyepo Yesu amepusyo nayambi. ");
INSERT INTO bwc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Elo Yesu aeba amabumba na basambi bakwe ukuti, ");
INSERT INTO bwc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Abafalise na bakafundisya bamafunde bekala mukipuna kyakwa Mose. ");
INSERT INTO bwc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Eikyo muleumfwila nokukonka fyonse fintu balemyeba, lelo mwilakita fintu bakita, pantu bena tabakita fintu basimikila. ");
INSERT INTO bwc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bakaka ifipe ifyafinisya, babika pafipeya fyabantu, ifyo bena tabekatako nomunwe wabo pakwimya. ");
INSERT INTO bwc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ifintu fyonse fintu bakita, bakitila ukubamona kubantu. Bakaka utupande utwamalembo bafwala pampumi na kumaboko utwalepa. Elo namasenkebele yansalu syabo balayalefya! ");
INSERT INTO bwc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Batemwa inkende syamukinsi pamalila elo nefipuna ifyakindamisyapo mu masinagogi, ");
INSERT INTO bwc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","kabili batemwa ukulabaposya nomukinsi pafisankano, nokubeta ukuti ‘Bakafundisya’. ");
INSERT INTO bwc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Lelo mwebo mwilaitwa ukuti, ‘Kafundisya’ pantu mwakwatafye Kafundisya umo, kabili muli bamunina. ");
INSERT INTO bwc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kabili mwilaita uuli onse pano isonde ukuti, ‘Taata’, pantu mwakwatafye Wisinwe umo uwamumulu. ");
INSERT INTO bwc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mwilaitwa ukuti, ‘kafundisya’ pantu mwakwatafye kafundisya umo uuli ni Klistu. ");
INSERT INTO bwc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Umukalamba pali mwebo, afwile aba umubomfi wenu bonse. ");
INSERT INTO bwc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Pantu bonse abaisansabika bakakefesiwa, nabonse abaikefya bakasansamikwa. ");
INSERT INTO bwc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Akalanda kuli imwe bakafundisya bamafunde namwe Bafalise, mwebabumbimunda! Mwalisalila abantu pakuti beingila mu bufumu bwa mumulu. Mwe bene tamwingilamo elo mwalesya nabambi abalefwaya ukwingilamo. ");
INSERT INTO bwc_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Akalanda kuli imwe, bakafundisya bamafunde namwe Bafalise! Mwebabumbimunda! Muliila bamukamfwilwa ifyuma fyabo, kabili mwatemwa ukuilanga mukupepa amapepo ayatali. Ala Lesa akamikandisya ukukilapo! ");
INSERT INTO bwc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Akalanda kuli imwe Bakafundisya bamafunde namwe Bafalise! Mweba bumbimunda! Mwenda ba bemba nemilundu pakutifye munasyepo umo abe umusambi wenu. Kabili ngamwafikilisya mulenga umuntu abipisyapo ukukila pakwamba, awaminafye ukuya kumbo ngamwebo! ");
INSERT INTO bwc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Akalanda kuli mwentungulusi impofu mwe! Mulanda ukuti umuntu ngalapa pe Tempele ninsi tapali mulandu. Lelo ngalapa pali golide wamwi Tempele ninsi afwile afikilisya umulapo wakwe. ");
INSERT INTO bwc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mwempofu isipumbu mwe! Kinsi kyakindamapo pali golide ne Tempele ililenga golide ukuba iyamusilo? ");
INSERT INTO bwc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kabili mulanda ukuti, umuntu ngalapa pa kipailo temulandu, lelo umuntu ngalapa pafyabupe fili pakipailo ninsi mulandu. ");
INSERT INTO bwc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mwempofu mwe! Ikyakindamapo kinsi pabupe nangu ikipailo ikilenga ikyabupe ukuba ikya musilo? ");
INSERT INTO bwc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Eikyo onse uwalapa pakipailo ninsi alapa napali fyonse ifili pakipailo, ");
INSERT INTO bwc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kabili naonse uwalapa pe Tempele ninsi alapa pali lyena napali Lesa uwikalamo, ");
INSERT INTO bwc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","kabili naonse uwalapa pamyulu, ninsi alapa pakipuna kyakwa Lesa napa waikalapo. ");
INSERT INTO bwc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Akalanda kuli imwe bakafundisya Bamafunde namwe Bafalise! Mwe babumbimunda mwe! Mulapela Lesa ikyekumi napamisalufye iyakuwamya ifyakulya ifili nga Minti, dilli nakumuni, lelo mwalisula ukukonka amafundisyo ayakankala mu Mafunde yakwa Mose ayali ngo, umulinganya, uluse nekisinka. Ifi efintu mufwile ukulakita ukwabula ukusula ayantansi. ");
INSERT INTO bwc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mwentungulusi impofu mwe! Mususa akasisi akanono, lelo mumina ingamila! ");
INSERT INTO bwc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Akalanda kuli imwe bakafundisya Bamafunde namwe Bafalise! Mwe babumbimunda mwe! Musamfya inkombo nensani kunse, elo ninsi mukati mwaisulafye ubulili no bukakasi. ");
INSERT INTO bwc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mwe Bafalise impofu mwe! Mbale samfyeni mukati kalukombo, kabili nakunse nako kulewama! ");
INSERT INTO bwc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Akalanda kuli imwe bakafundisya Bamafunde namwe Bafalise! Mweba bumbimunda mwe! Mwaba nge manda bashingulako ulupemba, kunse simoneka isyayemba lelo mukati mwaisula amafupa yabafwa, nafimbi fyonse ifyakowela. ");
INSERT INTO bwc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Munsila imoine, kunse mumoneka abasuma kubantu bonse, lelo mukati kenu mwaisulamo bubumbimunda kabili ne membu. ");
INSERT INTO bwc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Akalanda kuli imwe bakafundisya Bamafunde namwe Bafalise! Mweba bumbimunda mwe! Mukulilila imanda syaba kasesema, nokuwaminisya imanda syabalungami, ");
INSERT INTO bwc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","kabili mulanda ukuti, twingaba nifwebo ngatatwakitile fintu ifikolwe fyesu fyakitile mukusumya umulopa waba kasesema. ");
INSERT INTO bwc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kansi mwaliisinina ukuti muli lupwa lwa fipondo fyaipeye bakasesema! ");
INSERT INTO bwc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kansi pitilisyeni, pwisyeni fintu ifikolwe fyenu fyatampile! ");
INSERT INTO bwc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Imwe mwensoka! Imwe mwebana bansoka! Kuti mwafyuka syani ukuya ku Gehena? ");
INSERT INTO bwc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Eikyo nalamitumina bakasesema, abaume bamano naba kafundisya, bamo mukabepaya, bambi mukabatanika, kabili bambi mukabalopola musinagogi nokubatamfya mu musumba nomusumba. ");
INSERT INTO bwc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kansi pali mwebo pakaponena umulopa onse uwabalungami, uwasumine pesonde ukufuma pamulopa wakaele uwakwa Abeli, ukufika pamulopa wakwa Sakariya mwana Belekiya, untu mwaipaile pakati ke Tempele nekipailo. ");
INSERT INTO bwc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ndemyeba ikinekine ukuti, fyonse ifi fikaponena pabantu baino nkulo! ");
INSERT INTO bwc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“We Yerusalemu, we Yerusalemu! Wipaya bakasesema, nokwipaya kumabwe intumi sintu Lesa aakutumine! Miku inga nalefwaya ukufukatila abana bobe ngafintu inkoko ifukatila utwana mumapindo, lelo tawansuminisye! ");
INSERT INTO bwc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mona iŋanda yobe ikaba umwabula nangu kimo. ");
INSERT INTO bwc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Pantu ndekweba ukuti, tawakatale mbonapo nakabili mpaka ukalande ukuti, ‘Alipalwa uwisila mwisina lya Mfumu.’” ");
INSERT INTO bwc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Panuma yaifyo Yesu afumine Mwitempele alaya, abasambi bakwe baisile kuli ena nokwisa musontelela ifikulwa fye tempele. ");
INSERT INTO bwc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu abepwisye ukuti, “Busye namumona ifintu fyonse ifi? Ndemyeba ukuti tapakasyale ilibwe nangu limo palibiye, yonse yakabongoloka.” ");
INSERT INTO bwc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Lintu Yesu ali naikala pa Lupili lwa Miolife, abasambi baisile kuli ena pambali. Bamwipwisye ukuti, “Busye nilisa ifi fyonse fikakitika, kabili kilangililonsi ikyakwisa kobe nekyampela yesonde.” ");
INSERT INTO bwc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu abaswike ukuti, “Kengeleni, pakuti umuntu nangu umo emibepe. ");
INSERT INTO bwc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Pantu abantu abengi bakesila mwisina lyandi, bakalaitunga ukuti ‘Ninebo Klistu!’ Kabili bakabepa abengi. ");
INSERT INTO bwc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mukomfwa inkondo nefintinya fyankondo, lelo mwikatiina. Fyonse ifi fintu fikakitika, lelo impela ninsi tailafika. ");
INSERT INTO bwc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ifyalo fikemina ifyalo fibiye, ubufumu bukemina ubufumu bubiye. Konse kukaba ifipowe na bamakumba mukende isyalekana lekana. ");
INSERT INTO bwc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Lelo ifi fikabafye ngobukali bwakwambilapo ubwapakupapa. ");
INSERT INTO bwc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Bakamipakasa no kumipaya, kabili mukapatwa kubantu mufyalo fyonse pamulandu wandi. ");
INSERT INTO bwc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Abantu abengi bakalufya ikitetekelo pali iyi nsita, bakalafutuka nokupata ababiye. ");
INSERT INTO bwc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Elo bakasesema babufi abengi bakamoneka nokubepa abantu abengi. ");
INSERT INTO bwc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Pamulandu wakufula kwabubifi, ukutemwa kukafubalila. ");
INSERT INTO bwc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Lelo abakasipikisya ukufika kumpela bakapusuka. ");
INSERT INTO bwc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kabili iyi Mbila Nsuma yapa bufumu ikasisimikilwa mwisonde lyonse ngobunte kufyalo fyonse, elo impela ikafika. ");
INSERT INTO bwc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Kansi lintu mukamona umupamba wabonausi untu kasesema Daniele alaandilepo nawiminina umwamusilo.” (Onse uulebelenga eluke, muntu ifi fyalola!) ");
INSERT INTO bwc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Abakaba mu Yudeya bakabutukila mumpili. ");
INSERT INTO bwc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Uukaba pamutenge wa ŋanda ekekila ukuyapiita ifili fyonse mu ŋanda. ");
INSERT INTO bwc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Uukaba mwibala, ekabwelelamo mukupiita insalu syakwe. ");
INSERT INTO bwc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Akalanda muli silya nsiku kuli banamayo abakaba pabukulu na kubakalaonsya! ");
INSERT INTO bwc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mulepepa ukuti fikakitika munsita yampepo, nangu pabusiku bwe Sabata! ");
INSERT INTO bwc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Pantu kukaba amakyusi yakipesya mano ayasyatala bako ukufuma kuntendekelo yesonde ukufika nandakai kabili ayasyakatale bako nakabili. ");
INSERT INTO bwc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Isyo nsiku singakana ukwipifiwa ngatapali uwapuswike, lelo pamulandu wa basalwa bakwe isyo nsiku syalipifiwa. ");
INSERT INTO bwc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Pali iyo nsita umuntu ngalanda ukuti, “Mona Klistu uyu pano nangu uyo apo” Mwikasumina. ");
INSERT INTO bwc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Pantu ba krisitu babufi na bakasesema babufi bakamonekela, bakalakita ifisibilo ifikalamba nefisungusyo pakuti bakabepe na basalwa ngafingakitika. ");
INSERT INTO bwc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Moneni! Namyebela limo ifi lintu insita tailaisa. ");
INSERT INTO bwc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Kansi, abantu ngabamyeba ukuti, ‘Uyo ali mukiswebebe, mwikayako!’ Kabili ngabalanda ukuti, ‘Uyu ali muŋanda!’ Mwikasumina. ");
INSERT INTO bwc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Pantu Umwana Wamuntu akesa ngakalumba akabyasya mumulu monse ukufuma kukabanga ukufika ku masamba. ");
INSERT INTO bwc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Amakubi yakolongana konse ukuli ikitumbi. ");
INSERT INTO bwc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Panumafye yamakyusi yaisyo nsiku, akasuba kakafiita no mwensi tawakabale, intanda sikapona mumulu, kabili nefyaikala mumulu fikasunkansiwa. ");
INSERT INTO bwc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Elo kukamoneka ikisibilo kya Mwana Wamuntu mumulu. Elo abantu bapano isonde bonse bakalosya, lintu bakamona Umwana Wamuntu aleisa pamakumbi yamumulu, namaka nobukata ubukalamba. ");
INSERT INTO bwc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Lintu impenga ilikalamba likalila, akatuma bamalaika bakwe ukuyakolonganika abasalwa bakwe ukufuma mutupinda tune utwapesonde, ukufuma kumpela iyamulu ukufika kumpela. ");
INSERT INTO bwc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nomba sambilileni ku kimuti kya mukunyu. Imisambo ngayaamba ukufumya ubuluba mulesiba ukuti amainsa yapalama. ");
INSERT INTO bwc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nalintu mukamona ifintu fyonse ifi, mukesibe ukuti insita yapalama, ilifye pamwinsi. ");
INSERT INTO bwc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ndemyeba ikikine ukuti, iyi nkulo tayakapite ninsi ifintu fyonse ifi fyakitika. ");
INSERT INTO bwc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Umulu nesonde fikapita lelo amasiwi yandi tayakapite. ");
INSERT INTO bwc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Lelo tapaba uwaisiba ubusiku nakasita, bamalaika ba mumulu tabaisiba kabili Nomwana Wamuntu wine taisiba, Tatafye eka ewaisiba. ");
INSERT INTO bwc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ngafintu kyali munsiku yakwa Noa, efintu kikaba nalintu Umwana Wamuntu akesa. ");
INSERT INTO bwc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Lintu ilyeshi talilaisa, abantu balelya nokunwa, baleupa nokupwa, mpaka pa busiku buntu Noa aingile mu bwato. ");
INSERT INTO bwc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tabaisibe nangu fimo ifyalekitika mpaka ilyeshi lyaisa balofya bonse. Efintu kikaba napakwisa kwa Mwana wa Muntu. ");
INSERT INTO bwc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Abaume babili bakaba mwibala, umo akapiitwa umubiye akasyala. ");
INSERT INTO bwc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Abanakasi babili bakalapela pelibwe, umo akapiitwa umbi akasyala. ");
INSERT INTO bwc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Eikyo kengeleni, pantu tamwisibe ubusiku Imfumu yenu ikesa. ");
INSERT INTO bwc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Lelo ilukeni ifi, umwine wa ŋanda ngaisiba insita intu umuŋo aleisilapo, teti alale kuti alalolelafye kabili tekuti aleke umuŋo amwingilile. ");
INSERT INTO bwc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Eikyo namwebo beni abaipekanya lyonse, pantu Umwana Wamuntu akesa pakasita kantu musyenekele. ");
INSERT INTO bwc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Busye umusya wakisinka kabili uwamano ninani? Nyuyo, sikulu wakwe abika ukwangalila ababomfi babiye, ukulabapela ifyakulya pansita iyayana. ");
INSERT INTO bwc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kikamuwamina uyo umubomfi, ilyo sikulu wakwe abwela ngamusanga alekita ifyofine. ");
INSERT INTO bwc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ndemyeba ikinekine ukuti, sikulu wakwe akabika uyu mubomfi bukangalila pamfintu fyakwe fyonse. ");
INSERT INTO bwc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Lelo umusya ngamubifi, kuti aayeba umwine mumutima wakwe ukuti sikulu wakwe takabwele bwangu, ");
INSERT INTO bwc_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kabili nokwamba ukuma ababomfi babiye, nokwamba ukulya nokunwina pamo nabakyakolwa. ");
INSERT INTO bwc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Sikulu wauyo musya akabweluluka ubusiku ubo umubomfi tenekele kabili napansita intu tesibe. ");
INSERT INTO bwc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Akaputaula umubomfi mutupimfya, kabili akamuposa kunkende akayakyulila pamo nababumbimunda. Ukukaba ukulila nokusumanya ameno. ");
INSERT INTO bwc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Pali ilya nsita Ubufumu bwa mumulu bukaba ngabanakisungu ikumi limo, abapiitile utulampi twabo ukuya mukukumanya sibwinga. ");
INSERT INTO bwc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Basano pali aba bali nimpelwamano, kabili nabasano bali bamano. ");
INSERT INTO bwc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Impelwamano syapiitile utulampi ukwabula ukupiita amafuta ayengi. ");
INSERT INTO bwc_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Abamano bena bapiitile amafuta ayengi mutusupa ayamutulampi twabo. ");
INSERT INTO bwc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Abakasyana bayambile ukusipula basukwa baponena mutulo pantu sibwinga alikokwele ukwisa. ");
INSERT INTO bwc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Pakati kabusiku baumfwile utumpundu ukuti, ‘Sibwinga uyu aisa! Iseni mumupokelele!’ ");
INSERT INTO bwc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Elo abakasyana bonse babuka bayasya utulampi twabo. ");
INSERT INTO bwc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Abakasyana impelwamano baebele abamano ukuti, ‘Tupeleniko amafuta yenu fwebo utulampi twesu twalasima.’ ");
INSERT INTO bwc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Abamano bayaswike ukuti, ‘Awee, tayatukumane mwebo nafwebo. Kabiyeni kubasitisya amafuta musiteko ayenu.’ ");
INSERT INTO bwc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Lelo lintu baleya mukusita amafuta, sibwinga nao afika. Banakisungu basano abaali nabaipekanya baingile nankwe muŋanda yabwinga nefiibi fyaisalika. ");
INSERT INTO bwc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Mukasitafye abakasyana impelwa mano nabo babweluluka balapunda ukuti, ‘We Mfumu, we Mfumu! Twiswileniko ikiibi!’ ");
INSERT INTO bwc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Lelo sibwinga abaswike ukuti, ‘ndemyeba ikinekine ukuti nsimisibe.’” ");
INSERT INTO bwc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Eikyo kengeleni, pantu tamwisibe ubusiku nakasita. ");
INSERT INTO bwc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Nakabili ubufumu bwa mumulu bukaba ngomuntu uleya pabulendo, uwaitile ababomfi bakwe abapela bukangalila pafyuma fyakwe. ");
INSERT INTO bwc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Apeela kila umo ukulingana napapelele amaka yakwe, umo amupela ulupiya lwa golide amakana yasano, umbi amupela ulupiya lwa golide amakana yabili, naumbi amupela ulupiya lwa golide ikana limo. Elo aima ubulendo aya. ");
INSERT INTO bwc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Umubomfi uwapokele ulupiya amakana yasano, apiitile ulu lupiya aya lubomfya, akwatilamo nalumbi amakana yasano. ");
INSERT INTO bwc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nowapokele ulupiya amakana yabili akwatilepo nalumbi amakana yabili. ");
INSERT INTO bwc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Lelo umubomfi uwapokele ulupiya umwanda umo, aileimba icikulo emuntu asika ulupiya lwakwa sikulu wakwe. ");
INSERT INTO bwc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Panuma yansita iitali sikulu wabo alibwelulwike. Alibetile alabepusya fintu babomfesye ulupiya. ");
INSERT INTO bwc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Umubomfi uwapokele ulupiya lusano ulwa golide, aisileletelapo nalumbi lusano nokulanda ukuti, ‘Moneni mwesikulu, mwampele ulupiya lusano ulwa golide, nanebo ninkwatilapo nalumbi lusano.’ ");
INSERT INTO bwc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Sikulu wakwe alandile ukuti, ‘Wabomba, wemubomfi umusuma kabili uwakisinka. Wali uwakisinka mukusugilila tunono tuntu nakupele, eikyo nalakupela ukwangalila ifintu ifingi. Isa usansamukile pamo na sikulu obe!’ ");
INSERT INTO bwc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Umusya uwapokele ulupiya lubili ulwa golide nao aisilelanda ukuti, ‘Mwe sikulu, mwampele ulupiya lubili ulwa golide, moneni ninkwatilapo nalumbi lubili.’ ");
INSERT INTO bwc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Sikulu wakwe alandile ukuti, ‘Wabomba, wemubomfi umusuma kabili uwakisinka. Wali uwakisinka mukusugilila ulupiya ulunono luntu nakupele, eikyo nalakupela ukwangalila ifintu ifingi. Isa usansamukile pamo na sikulu obe!’ ");
INSERT INTO bwc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Elo umubomfi uwapokele ulupiya lumo ulwa golide aisilelanda ukuti, ‘Mwe sikulu, nalisiba ukuti mwalisyupa, musombola muntu tamwalimine, mukolonganika ifisabo umo tamwatandile. ");
INSERT INTO bwc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Naletiina, eikyo nailesika ulupiya mumusili. Moneni ulupiya lwenu ulu.’ ");
INSERT INTO bwc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Sikulu wakwe amwaswike ukuti, ‘Wemubomfi umubi kabili umunaŋani we!’ Kansi waisibe ukuti nsombola muntu nsyalima nokuseepa umo nsyatanda? ");
INSERT INTO bwc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kilifye, nomba kansi ngawambikile kulya basungila ulupiya, pakuti nakwatamo ulwakumbikilapo. ");
INSERT INTO bwc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","‘Eikyo mupokeni ulupiya mupele umubomfi uukwete ulupiya ikumi limo. ");
INSERT INTO bwc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Pantu Onse uukwete akapelelwapo nafimbi, kabili akakwata ifingi ukukilapo, lelo onse uusikwete nangu kimo, akapokololwa nakanono kantu akwata. ");
INSERT INTO bwc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Uyu mubomfi uwabula ubuyo, muposeni kunse mumfimfi, umukaba ukulila nokusumanya ameno.’ ");
INSERT INTO bwc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Lintu Umwana Wamuntu akesa mubukata nabamalaika bakwe, akekala pakipuna kyakwe ikyabukata, ");
INSERT INTO bwc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","kabili nabantu mufyalo fyonse bakamukolongana. Elo akapatula abantu ngafintu kacema apatula impaanga ku mbusi. ");
INSERT INTO bwc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Akabika impaanga kukulyo kwakwe elo imbusi kukuso kwakwe. ");
INSERT INTO bwc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Elo Imfumu ikalanda ku bantu abakaba kukulyo ukuti, ‘Iseni, mwebapalwa kuli Tata! Iseni mupoke Ubufumu ubo mwali namuteyanisiwa ukutula kububumbo bwesonde. ");
INSERT INTO bwc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nali nensala mwalimpele ifyakulya, nali nekilaka mwalimpele ifyakunwa, nali umweni mwalimpokelele mumayanda yenu, ");
INSERT INTO bwc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nsyakwete ifyakufwala mwalimfwikile, nalilwele mwalinsakamene, nali mukifungo mwaisile mpempula.’ ");
INSERT INTO bwc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Abalungami bakamwasuka ukuti, ‘Mwe Mfumu nilisa twamimwene namumfwa insala twamipela ifyakulya, nangu namumfwa ikilaka twamipela ifyakunwa? ");
INSERT INTO bwc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nilisa twamimwene umweni twamipokelela mumayanda yesu, nangu ukwabula ukufwala twamifwika? ");
INSERT INTO bwc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nilisa twamimwene namulwala, nangu mukifungo twaisa mimpempula?’ ");
INSERT INTO bwc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Imfumu ikasuka ukuti, ‘Ndemyeba ikinekine ukuti, lyonse lintu mwayafwile munina umo mulifi uwamulupwa lwandi nangu munono syani, ninebo mwayafwile!’ ");
INSERT INTO bwc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Elo akeba abakukuso ukuti, ‘Fumeni kuli nebo, mwebatipwa! Kabiyeni mumulilo wamuyayaya uwapekanisiwa Kiwa naba malaika bakwe! ");
INSERT INTO bwc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nali nensala lelo tamwampele ifyakulya, nali nekilaka lelo tamwampele ifyakunwa, ");
INSERT INTO bwc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","nali umweni lelo tamwampokelele mumayanda yenu, nali ukwabula ukufwala lelo tamwampele ifyakufwala, nali nindwala kabili nali mukifungo lelo tamwansakamene.’ ");
INSERT INTO bwc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Nabo bakasuka ukuti, ‘Mwe Mfumu, nilisa twamimwene muli nensala, nelyo nekilaka, nangu umweni, nelyo ukwabula ukufwala, nangu namulwala, nangu mukifungo twakana ukumyafwa?’ ");
INSERT INTO bwc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Imfumu ikabasuka ukuti, ‘Ndemyeba ikinekine ukuti, lyonse lintu mwakene ukwafwa onse pabantu bandi, nangu abe umunono syani mwakene ukwafwa nebo.’ ");
INSERT INTO bwc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Elo bakaye mukakandwa umuyayaya, lelo abalungami bakaya kumweo wamuyayaya.” ");
INSERT INTO bwc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Lintu Yesu apwisisye ukulanda ifintu fyonse ifi, aebele abasambi bakwe ukuti, ");
INSERT INTO bwc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Namwisiba ukuti kwasyalafye insiku sibili, ninsi busiku nkulu bwe Pasaka. Kabili Umwana Wamuntu akapelwa muminwe yabalwani mukumutanika.” ");
INSERT INTO bwc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Basimapepo bakindami na bakalamba babantu bakolongene mukipango kyakwa simapepo mukalamba Keyafasi, ");
INSERT INTO bwc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","kabili baumfwene fintu bengakwata Yesu mubumfisolo no kumwipaya. ");
INSERT INTO bwc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Lelo baalandile ukuti, “Twikakita ifi pe Pasaka, abantu kuti baimya ifimfulunganya.” ");
INSERT INTO bwc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Lintu Yesu ali mu Betani muŋanda yakwa Simoni uwafibasi, ");
INSERT INTO bwc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","kwaisile namayo napiita amafuta mwibotolo ayanunkila ayamutengo ukalamba ngansi, aitulwila pa mutwe wakwa Yesu ninsi ali pakulya. ");
INSERT INTO bwc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Lelo lintu abasambi bakwe bamwene ifi balifulilwe batampa ukulailisyanya ukuti, “Busye bonausi bwa musango syani ubu? ");
INSERT INTO bwc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Pantu aya mafuta kuti yasitisiwa palupiya ulwingi sana nokupela abalanda!” ");
INSERT INTO bwc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Lelo Yesu pakwisiba fintu baletontonkanya abebele ukuti, “Kinsi mulekyusisya uyu mwanakasi? Nankitila ikintu ikisuma. ");
INSERT INTO bwc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pantu abalanda mukalaba nabo lyonse lelo tamwakaleba nanebo lyonse. ");
INSERT INTO bwc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Lintu akitulwila amafuta yanunkila pamubili wandi, akimpekanya mukusiikwa. ");
INSERT INTO bwc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ndemyeba ikisinka ukuti, konse kuntu Imbila Nsuma ikabilwa mwisonde lyonse, ifi fyakita uyu mwanakasi fikalalandwapo mukumwibukisya.” ");
INSERT INTO bwc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yuda Isikalyoti umo pabasambi ikumi limo na babili aile kuli basimapepo mukalamba ");
INSERT INTO bwc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","aya bepusya ukuti, “Busye mukampela finsi nganamiletela Yesu?” Nabo bamulipile ulupiya lwa siufele amakumi yatatu (30). ");
INSERT INTO bwc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ukufuma apo Yuda atampile ukufwaya akasita akasuma akakufutukilapo Yesu. ");
INSERT INTO bwc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pabusiku bwakwambilapo ubwakulyamo umukate uusyatutumuka abasambi baisile kuli Yesu mukumwipusya ukuti, “Busye nipi ulefwaya tukupekanisisye ukwakulila Ipasaka?” ");
INSERT INTO bwc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Alandile ukuti, “Kabiyeni mumusumba kumuntu umo, muleya mweba ukuti Kafundisya alanda ati, ‘Insita yandi naipalama! Ndimukufwaya ukwisalila Ipasaka muŋanda yobe na basambi bandi.’” ");
INSERT INTO bwc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kansi abasambi bakitiile umo Yesu abebele, bapekanya ne Pasaka. ");
INSERT INTO bwc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mukyungulo, Yesu na basambi bakwe ukumi limo nababili bakubeme petebulo. ");
INSERT INTO bwc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kabili ilyo balelya Yesu alandile ukuti, “Ndemyeba ikisinka ukuti, umo pali mwebo alemfutuka.” ");
INSERT INTO bwc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Abasambi baiketwe ubulanda batampa ukulamwipusya umo, umo ukuti, “Busye ninebo mwe Mfumu?” ");
INSERT INTO bwc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu abaswike ukuti, “Uo nalaingisisya nao pamo iminwe mumbale eulemfutuka. ");
INSERT INTO bwc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Umwana Wamuntu akafwa ngafintu amalembo yalanda, lelo akalanda ngansi kumuntu uulefutuka Umwana Wamuntu! Ngakyaliwemepo kuli uyo muntu ukukana fyalwa!” ");
INSERT INTO bwc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda, uwamufutwike aipwisye ukuti, “Busye ninebo mwe Kafundisya?” Yesu amwasuka ukuti, “Wemwine wailandila” ");
INSERT INTO bwc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ilyo balelya, Yesu abulile umukate, aupaala aumokola apela abasambi bakwe nokulanda ukuti, “Buleni mulye, uyu emubili wandi.” ");
INSERT INTO bwc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kabili abula nolukombo, atotela Lesa elo abapa ukuti, “Nwenimo bonse, ");
INSERT INTO bwc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","uyu mulopa wandi uwakipangano kipya uwalasumiina pabengi kukwelelwa kwa membu. ");
INSERT INTO bwc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ndemyeba ukuti nsyakanwepo ifyakufisabo fyamyangasi nakabili, mpaka bulya busiku nkanwa ifyakufisabo fya myangasi ifipya pamo namwebo mu bufumu bwakwa Tata.” ");
INSERT INTO bwc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Lintu baimbile ulwimbo balifumine baya kulupili lwa Miolife. ");
INSERT INTO bwc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesu aebele abasambi bakwe ukuti, “Buno bwine busiku bonse mulembutuka nokunsya, pantu amalembo yalanda ukuti, ‘Nkoma kacema no mukuni wa mpaanga ukasalangana.’ ");
INSERT INTO bwc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Lelo panuma nabusiwa kubafwa, nkamitangilila ku Galili.” ");
INSERT INTO bwc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petelo aebele Yesu ukuti, “Nebo nsyakamisye nangu bambi bakamisye!” ");
INSERT INTO bwc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu aebele Petelo ukuti, “Ndekweba ikisinka ukuti, buno bwine busiku ulenkana imiku itatu ukuti tawangisiba lintu mukolwe talalila.” ");
INSERT INTO bwc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Lelo Petelo ayaswike ukuti, “Nebo nsyakukane ngakufwa ndefwa nobe!” Nabonse abasambi balanda fimofine. ");
INSERT INTO bwc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu aile na basambi bakwe kunkende yaleitwa Getisemane, aebele abasambi bakwe ukuti, “Ikaleni pano, nebo naya kulya mukupepa.” ");
INSERT INTO bwc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yesu apiitilepo Petelo na bamwana Zebedee babili Yakobo na Yohani aya nabo. Elo asakamikwa kabili aba uwabulanda. ");
INSERT INTO bwc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Elo abeba ukuti, “Umutima wandi waisulamo ubulanda nicingafye imfwe. Ikaleni pano mulelola nanebo.” ");
INSERT INTO bwc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Aendelekofye ikyalinga awa pansi ubunkupeme alapepa ukuti, “Mwe Tata, nga nakyanguka lekeni ulu lukombo lumpite, lelo tekufwaya kwandi kano ukufwaya kwenu.” ");
INSERT INTO bwc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Elo abwelulwike asangile abasambi bakwe balimutulo, eikyo aebele Petelo ukuti, “Busye tekuti mulole nanebo pankoloko imo? ");
INSERT INTO bwc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Loleni no kupepa pakuti mwiwila mumatunko. Umupasi ulefwaya lelo umubili naunaka.” ");
INSERT INTO bwc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nakabili Yesu aile mukupepa ukuti, “Mwe Tata, ngakyakwebati ulu lukombo teti lufumepo mpaka ndunwe, ubufwayo bwenu nabukitwe.” ");
INSERT INTO bwc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nakabili abweluluka asanga nabalala. Amenso yabo yali nayafina kutulo. ");
INSERT INTO bwc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Abasile nakabili ayapepa ilya butatu, apepele ipepo limoline. ");
INSERT INTO bwc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Abwelulukile ku basambi bakwe no kubeba ukuti, “Busye mukili namulala muletusya? Moneni! Insita naifika iya Mwana Wamuntu ukuposwa mumaboko ya babembu. ");
INSERT INTO bwc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Imeni tuleya. Uulemfutuka uyo aleisa!” ");
INSERT INTO bwc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Lintu Yesu akili alelanda, Yuda umo pabasambi ikumi limo na babili nao afika. Aali nebumba ilikalamba ilyafumine kuli basimapepo bakindami na bakalamba ba bantu, abaali ne mipanga nenkoto. ");
INSERT INTO bwc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Uwamufutwike alipele ibumba ikisibilo ukuti, “Untu ndetomona emuntu mulefwaya. Mumukwate!” ");
INSERT INTO bwc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kabili Yuda aile kuli Yesu nokumweba ukuti, “Mwapoleni mwe Kafundisya,” nokumutomona. ");
INSERT INTO bwc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu epakumweba ukuti, “Ale kibusa kita fintu ukonkele!” Abantu abali na Yuda bapalama, bafokokela Yesu bamukwata. ");
INSERT INTO bwc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Umo pabali na Yesu asomwene umupanga akoma umusya wakwa simapepo mukalamba amuputula ukutwi. ");
INSERT INTO bwc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu amwebele ukuti, “Bwesesya umupanga mukitubo, onse uwanga nomupanga akafwa ku mupanga. ");
INSERT INTO bwc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Busye muletontonkanya ati teti ngebe Taata, kabili nao apapene kuti antumina ifiita fyaba mailaka ukukila ikumi limo na babili? ");
INSERT INTO bwc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Lelo, kuti yafikilisya syani amalembo ayalanda ukuti ifi fifwile fyakitikila muli iyi nsila?” ");
INSERT INTO bwc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Pali kalya kasita Yesu aebele ibumba ukuti, “Busye ndikipondo, pakuti mwise nemipanga ne nkonto mukundikata? Kila busiku naleikala mwi Tempele ndefundisya, tamwalendikata. ");
INSERT INTO bwc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Lelo ifi fyonse fyalakitika pakuti ifyalembelwe kuli bakasesema fifikilisye.” Elo abasambi bonse bamusya babutuka. ");
INSERT INTO bwc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Abo abakwete Yesu bamutwele kuli Kayafasi simapepo mukalamba, uko bakafundisya ba mafunde na bakalamba ba bantu baali nabakolongana. ");
INSERT INTO bwc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Lelo petelo alekonkamo akatalamukila mpaka afika na mumusolo wakwasimapepo mukalamba. Alingile nokwikala pamo na bamalonda amone ifyalakitika. ");
INSERT INTO bwc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Basimapepo bakindami na basikilye bonse balefwailisya ifyakubepesya Yesu pakuti bamwipaye. ");
INSERT INTO bwc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Lelo tabafisangile nangu abantu abengi baimine nokumubepesya ubufi. Kwaiminine abaume babili ");
INSERT INTO bwc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","nokulanda ukuti, “Uyu muntu alandile ati, ‘Nalikwata amaka yakubongolola itempele lyakwa Lesa nokulikula munsiku sitatu.’ ” ");
INSERT INTO bwc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Simapepo mukalamba aiminine nokweba Yesu ukuti, “Ngawebo taulelandapo?” Ngobu bunte aba bantu balekutunganya? ");
INSERT INTO bwc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Lelo Yesu aikelefye tondolo. Simapepo mukalamba amwebele ukuti, “Mwisina lyakwa Lesa uwamweo, lapafye nganiwebo Klistu Umwana wakwa Lesa.” ");
INSERT INTO bwc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu amwaswike ukuti, “Naulanda ukuti ninebo. Lelo ndimukumyeba mwebonse ukuti, ukufuma pali ino nsita mukamona Umwana wa Muntu naikala kukuboko kwakukulyo ukwa Wamaka, kabili aleisa pamakumbi ya mumulu!” ");
INSERT INTO bwc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Elo simapepo mukalamba alepwile insalu yakwe nokulanda ukuti, “Napontela Lesa! Nikinsi tulefwaila bakambone nabambi! Nomba mwayuumfwila imiponto yakwe! ");
INSERT INTO bwc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ngamwebo muletipo syani?” Bayaswike ukuti, “Nalinga ukufwa.” ");
INSERT INTO bwc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Bamufwisile amate pamenso no kumupuma, elo bambi balemuma amapi ");
INSERT INTO bwc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","nokulamweba ukuti, “Klistu, sesema kuli fwebo. Ninani wakuma!” ");
INSERT INTO bwc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nomba Petelo ali naikala panse pamusolo, umwanakasi umubomfi wakwa simapepo mukalamba aisile kuli ena nokulanda ukuti, “Nobe wine, wakiba na Yesu waku Galili.” ");
INSERT INTO bwc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Lelo alikene pamenso yabantu bonse ukuti, “Nsisibe fintu ulelandapo,” ");
INSERT INTO bwc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Elo afuma mumusolo aya pamwinsi, naumbi umubomfi amumona aeba abantu abaali nabeminina kulya ukuti, “Uyu Muntu akiba na Yesu waku Nazareti.” ");
INSERT INTO bwc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nakabili Petelo alikene ukuti, “Ndelapafye akalumba nsyamwisiba uyu muntu!” ");
INSERT INTO bwc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Panuma yakasitafye akalinga abantu abaali nabeminina kulya bapalamine kuli Petelo nokulanda ukuti, “Ikinekine nobe wine uli wamulibena, pantu nemilandile yobe ine yabena Galili.” ");
INSERT INTO bwc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Petelo ayambile ukuitipa nokulapa ukuti, “Ulya muntu nsyamwisiba!” Palyapene na mukolwe alila ");
INSERT INTO bwc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","kabili Petelo aibwisye fintu Yesu amwebele ukuti, “Lintu mukolwe talalila, ulenkana imiku itatu ukuti tawangisiba.” Elo afumina panse nokuya mukulila ngansi. ");
INSERT INTO bwc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ulukelo basimapepo bakindami bonse na bakalamba ba bantu balikumene baumfwana fintu bengepaya Yesu. ");
INSERT INTO bwc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Balimukakile bamupiita bamutwala ku mulashi Pilato. ");
INSERT INTO bwc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Lintu Yuda uwamufutwike amwene ukuti Yesu bamupingwila imfwa, alilangulwike pali fintu akitile. Abwesesyemo ulupiya lwa siufele amakumi yatatu kuli basimapepo bakindami nentungulusi, ");
INSERT INTO bwc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ukuti, “Nalibembwike, pantu nafutwike umuntu uwakaele!” Bamwaswike ukuti, “Uyo Mulandu obe!” ");
INSERT INTO bwc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yuda aposele ulupiya mwi Tempele nokuyaikulika. ");
INSERT INTO bwc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Basimapepo bakindami batolele ulupiya nokulanda ukuti, “Ulu lupiya lwamulopa, takyasuminisiwa mwifunde lyesu ukulubika mukipao kya mwi Tempele.” ");
INSERT INTO bwc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Eikyo baumfwene ukusitamo ibala lyakwa kabumba wa nongo, umwakulasika bamwisa. ");
INSERT INTO bwc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ekintu iyi nkende nandakayi itilwa ukuti “Ibala lya mulopa.” ");
INSERT INTO bwc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ifyalandilwe kuli kasesema Yeremia fyalifikilisye ukuti, “Bapiitile ulupiya lwa siufele amakumi yatatu emutengo untu abena Israeli bamusitisisyepo, ");
INSERT INTO bwc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","bailesitamo ibala lyakwa kabumba wa nongo ngafintu Imfumu yalandile.” ");
INSERT INTO bwc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu bamutwele kumulashi Pilato uwamwipwisye ukuti, “Busye uuli Mfumu yaba Yuda?” Yesu ayaswike ukuti, “Naulanda.” ");
INSERT INTO bwc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Lelo lintu basimapepo bakindami na bakalamba balemwebelela, tayaswikepo nangu kimo. ");
INSERT INTO bwc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilato amwipwisye ukuti, “Busye tauleumfwa ifintu fyonse ifi fintu balekwebelela?” ");
INSERT INTO bwc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Lelo Yesu alikene ukwasukapo isiwi nangu limo, iki kyalengele Pilato ukupapa. ");
INSERT INTO bwc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lyonse pe Pasaka, umulashi alebakakwilapo umufungwa umo untu abantu balefwaya. ");
INSERT INTO bwc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Pali iyi nsita kwali umufungwa umo uwali naisibikwa uwaleitwa ukuti Balaba. ");
INSERT INTO bwc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Lintu ibumba lyakolongene, Pilato abepwisye ukuti, “Busye ninani mulefwaya imikakwile pali Balaba na Yesu uwitwa Klistu?” ");
INSERT INTO bwc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato alisibe ukuti baaletele Yesu kuli ena pamulandu nomufimbila. ");
INSERT INTO bwc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Lintu Pilato ali naikala pakipuna kya bupingusi umukasi wakwe amutumine amasiwi ukuti, “Wikita nangu kimo pali uyo muntu wakaele, ninkyusiwa apakalamba mukiloto pamulandu noyo muntu.” ");
INSERT INTO bwc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Lelo basimapepo bakindami naba kalamba basongelekenye abantu ukuti balombe ukubakakwila Balaba elo Yesu ena bamwipaye. ");
INSERT INTO bwc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato aipwisye ibumba nakabili ukuti, “Busye pali aba babili, ninani mulimukufwaya imikakwile?” Bayaswike ukuti, “Balaba!” ");
INSERT INTO bwc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato abepwisye ukuti, “Busye nomba inkite syani kuli Yesu uwitwa Klistu?” Bonse bayaswike ukuti, “Mutanikeni!” ");
INSERT INTO bwc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Lelo Pilato abepwisye ukuti, “Mulandu nsi akitile?” Batampile ukubilisya nomba ukukilapo ukuti, “Mutanikeni” ");
INSERT INTO bwc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Lintu Pilato amwene ukuti tapali kintu engakita kuti ifimfulunganya fyaimafye, aabulile amensi, asamba kuminwe pamenso yabantu bonse nokulanda ukuti, “Nsiliimo muli iyi mfwa ya uyu muntu, mulandu wenufye!” ");
INSERT INTO bwc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ibumba lyonse lyayaswike ukuti, “Lekeni umulopa wakwe ube pali fwebo napabana besu!” ");
INSERT INTO bwc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilato abakakwilile Balaba, kabili panuma alopola Yesu abapele ukuti bayemutanika. ");
INSERT INTO bwc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Abasilika ba mulashi batwele Yesu mukipango, elo bakolonganika nempuka ya basilika yonse. ");
INSERT INTO bwc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Yesu bamufulile insalu syakwe nokumufwika umwingila wakasika. ");
INSERT INTO bwc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bapikwile iŋana yamyunga bamufwika kumutwe, nokumufumbatika itete kukulyo. Balemufukamina nokumupunya ukuti, “Mulopwe kanabesa wemfumu ya Bayuda!” ");
INSERT INTO bwc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Balemumfwisila amate, bamupoka itete balamuma ku mutwe. ");
INSERT INTO bwc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Lintu bapwisisye ukumupunika, bamufulile umukansu bamufwika insalu syakwe, Elo bamutwala mukumutanika. ");
INSERT INTO bwc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Lintu baleya, bakumenye umwaume uwalefuma ku Sirene isina lyakwe ni Simoni, kabili abasilika bamupatikisye ukupiita umusalaba wakwa Yesu. ");
INSERT INTO bwc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bafikile kunkende iyaleitwa Gologota, ikilepilibula ukuti, “Inkende ya Fipaanga”. ");
INSERT INTO bwc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bapele Yesu umwangasi wasankana nendusya ukuti anwe, lelo panuma abika palulimi, alikene ukunwa. ");
INSERT INTO bwc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Lintu bamutanike, balependula pakwakana insalu syakwe. ");
INSERT INTO bwc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nokwikala pansi balamulinda. ");
INSERT INTO bwc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pamulu wamutwe wakwe babikilepo akapampa apalembelwe umulandu untu bamwipailepo ukuti, “Uyu ni Yesu Imfumu ya Bayuda.” ");
INSERT INTO bwc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Batanikepo notupondo tubili kamo kukulyo nakambi kukuso. ");
INSERT INTO bwc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Abapita nsila balepukunya imitwe nokutuka Yesu insele, ");
INSERT INTO bwc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","balelanda ukuti, “Ewebo walelanda ati kuti wabongolola itempele nokulikula nakabili munsiku sitatu! Ngoli Mwana wakwa Lesa ipususye! Ikila pamusalaba!” ");
INSERT INTO bwc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mu musango umowine basimapepo bakindami na bakafundisya ba Mafunde na bakalamba ba bantu balemupunika ukuti, ");
INSERT INTO bwc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Alepususya bambi, lelo ena teti aipususye! Nga nimfumu yabena Israeli, akoke pamusalaba! Elintu twalamusumina! ");
INSERT INTO bwc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Aketekele muli Lesa, ale Lesa namupususye ngalimutemwa, pantu alelanda ati, ‘Ndimwana wakwa Lesa!’” ");
INSERT INTO bwc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Notupondo tubili utwatanikwe pamo nao twalemusalula. ");
INSERT INTO bwc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ukufuma lintu akasuba kafikile pamutwe pansita ya 12 koloko mukyalo monse mwafiitile nafititi, ukufika napansita ya 15 koloko. ");
INSERT INTO bwc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pansita ya 15 koloko Yesu alilile mwisiwi ilikalamba ukuti, “Eloi, Eloi, Lama sabakatani?” Ikilepilibula ukuti, “Lesa wandi, Lesa wandi, Nikinsi mwandekelesesya?” ");
INSERT INTO bwc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Lintu bamo pabaali nabeminina palya baumfwile ifi, balandile ukuti, “Aleita Eliya.” ");
INSERT INTO bwc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Palyapene, umo pali bena abutwike ayapiita umwepu atubika mu mwangansi wakantuka, autunga kwitete nokupa Yesu ukuti anwe. ");
INSERT INTO bwc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Lelo bambi balandile ukuti, “Tulolele, tumone Eliya ngalaisa mupususya!” ");
INSERT INTO bwc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kabili lintu Yesu apundile isiwi lyapamulu, awe aleka nomweo. ");
INSERT INTO bwc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Pali ilya nsita insalu baali nabatanika mwi Tempele yalepwike pabili ukufuma pamulu ukufika pansi. Isonde lyalitentele, amabwe yalilepawike, ");
INSERT INTO bwc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","imanda syaliswike, abantu bamusilo abengi abali nabafwa balibusiwe. ");
INSERT INTO bwc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bafumine mu manda, napanuma yakubuka kwakwa Yesu baile mumusumba wamusilo, nokuyamonekela kubantu abengi. ");
INSERT INTO bwc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Lintu umukalamba wabasilika nabasilika abalelinda Yesu baumfwile makumba nokumona ifintu fyonse ifyakitike, bakwetwe nomwenso nokulanda ukuti, “Mukisinka uyu muntu aali Mwana wakwa Lesa!” ");
INSERT INTO bwc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kwali banamayo abengi, abaletamba akatalamukila, bakonkele Yesu ukufuma ku Galili kukulamutangata. ");
INSERT INTO bwc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Pali bena pali Mariya Mangadelena, Mariya nyina wakwa Yakobo na Yosefu, nanyina wabana bakwa Zebedee. ");
INSERT INTO bwc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Lintu kyali ikyungulo, kwaisile umukankala ukufuma ku Alimateya isina lyakwe ni Yosefu, kabili nao ali musambi wakwa Yesu. ");
INSERT INTO bwc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Aile kuli Pilato mukulomba ikitumbi kyakwa Yesu. Pilato apele insambu ukuti bapele Yosefu ikitumbi. ");
INSERT INTO bwc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Eikyo Yosefu apiitile umubili wakwa Yesu aupomba munsalu iyipya, ");
INSERT INTO bwc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","aubika namumanda yakwe iipya intu afonkwele mwilibwe. Elo akunkulusisyapo ilibwe ilikalamba pamwinsi wamanda aya nokuya. ");
INSERT INTO bwc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariya Magadalena na Mariya mubiye bali nabekala kulyakwine apalungatene nemanda. ");
INSERT INTO bwc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ubusiku bwakonkelepo, panuma yabusiku bwakupekanya, basimapepo bakindami naba Falise baile kuli Pilato. ");
INSERT INTO bwc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Balandile ati, “Mwemfumu, natwibusya fintu ulya muntu wabufi alelanda lintu ali umumi ukuti, ‘Nkabuka nakabili panuma yansiku sitatu.’ ");
INSERT INTO bwc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Peleni abakulonda imanda yakwe bwino bwino mpanka nobusiku bwabutatu, pakuti abasambi bakwe bekeyamwiba elo bakaleyeba abantu ukuti nabuka kubafwa. Ubu bufi bwakulekesya bukabipapo ukukila ubwakwambilapo.” ");
INSERT INTO bwc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato abebele ukuti, “Piiteni abakulonda, musininkisye ukuti balonda bwino bwino imanda ngafintu mwisibe.” ");
INSERT INTO bwc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Efintu bailefenenkesyapo, basyapo nabasilika bakulonda. ");
INSERT INTO bwc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nomba panuma yabusiku bwe Sabata, kumakya pamulungu, Mariya Magadalena na Mariya mubiye baile mukumona imanda. ");
INSERT INTO bwc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kwapitile makumba, pantu malaika wa Mfumu alikile ukufuma kumulu. Ailulwilepo ilibwe pa manda aikala napalya pene. ");
INSERT INTO bwc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Imimonekele yakwe yali ngakalumba, nefyakufwala fyakwe fyali ifyabuta tuutu nge mfula yamabwe. ");
INSERT INTO bwc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Abalelonda bayambile ukututuma kumwenso, bawile pansi ngabafwile. ");
INSERT INTO bwc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Malaika aebele banamayo ukuti, “Mwitiina! Ningisiba mulimukufwaya Yesu untu batanike. ");
INSERT INTO bwc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Talimo Lesa namubusya kubafwa ngafintu alandile. Iseni mumone pantu bamulalike. ");
INSERT INTO bwc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kabiyeni mukwangufyanya, muleya eba abasambi bakwe ukuti, ‘Nabuka kubafwa, apa alimukuya ku Galili natangilako, ekuntu mukayamonana!’ Efintu nakisa mukumyeba.” ");
INSERT INTO bwc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Eikyo banamayo bafumine kumanda mukwangufyanya, nabesulamo nensansa uku nomwensomo, balebutukila mukweba abasambi bakwe. ");
INSERT INTO bwc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mukupumikisya Yesu abakumanya nokubeba ukuti, “Umutende ube nemwe,” Bapalamine kuli ena baikata ku makasa yakwe balamusinsimuna. ");
INSERT INTO bwc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Elo Yesu abebele ukuti, “Mwitiina, kabiyeni mwebe bamuninane ukuti baye ku Galili, ekuntu balaisa mbona.” ");
INSERT INTO bwc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Lintu banamayo baleya, abasilika bamo abalelonda babwelelemo kumusumba. Baileyeba basimapepo bakindami ifyakitike fyonse. ");
INSERT INTO bwc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Basimapepo bakindami bakolongene na bakalamba babantu balaumfwana fintu balakita. Bapele abasilika ulupiya ulwingi ");
INSERT INTO bwc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","nokubeba ukuti, “Mulelanda ati, ‘Abasambi bakwe bakisaiba umubili wakwe ubusiku lintu twakiba mutulo.’ ");
INSERT INTO bwc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kabili ngakyakweba ati Umulashi aumfwa ifi, mwikasakamana nelyo kimo tukesiba fintu tukamweba mpaka tukamifumye mubwafya.” ");
INSERT INTO bwc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Abasilika bapiitile ulupiya bakita nefyo babebele ukukita. Ukufika nalelo ili elyasi lyasabankana ku Bayuda. ");
INSERT INTO bwc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Abasambi ikumi limo na umo baile mu Galili palupili pantu Yesu abebele ukuya. ");
INSERT INTO bwc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Lintu bamumwene balimusinsimwine, nangu bambi balemutwisika. ");
INSERT INTO bwc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu apalamine kuli bena nokubeba ukuti, “Amaka yonse mumulu napano isonde nayapelwa kuli nebo. ");
INSERT INTO bwc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kabiyeni muleyalenga abantu bonse ukuba abasambi bandi, mulebabatisya mwisina lyakwa Tata, ilya Mwana, nelyakwa Mupasi wamusilo, ");
INSERT INTO bwc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","kabili mulebafundisya ukulakonka fyonse fintu namikonkomesye. Kabili nakulaba namwebo insita yonse, mpaka nakumpela yakyalo.”");
INSERT INTO bwc_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","Ninebo Paulo, Sailasi elo na Timote twamilembela mwelukuta lwamu Tesalonika mwebaba muli Lesa shifwe kabili Nemfumu Yesu Klistu. ");
INSERT INTO bwc_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","Ukusenaminwa elo nomutende fibe namwebo ukufuma kuli Tata elo Nemfumu Yesu Klistu. ");
INSERT INTO bwc_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","Mwebabwananyina, fwebo tulatotela Lesa lyonsefye pali mwebo, pantu ekilungeme kuli fwebo ukulakita, umusango wakitetekelo kyenu kilekula apakalamba kabili nekitemwiko mwakwatila kila umo naumo kileya kilekulilako. ");
INSERT INTO bwc_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","Eikyo fwebo tulaitakisya mukulanda kwesu pali mwebo, munkuta syakwa Lesa. Tutasya pafyo mwakonkanyapo ukusumina elo nokushipikisya lintu mwapita mumakyusi nangula ukupakaswa. ");
INSERT INTO bwc_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","Iki kyonse kilangililo kyakweba ati ubupingusi bwakwa Lesa bwamulinganya, pakweba ati mwaba abalinga kubufumu bwakwe buntu mukyulila. ");
INSERT INTO bwc_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","Ikyakine Lesa wamulinganya, akakyusya abobonse abamikyusya, ");
INSERT INTO bwc_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","akapwisya amakyusi yenu elyo namakyusi yesu yene. Akakita ifi, ilyo Imfumu Yesu ikamonekela ukufuma mumulu nabamalaika bakwe ababulamba. ");
INSERT INTO bwc_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","Akesa nolubingu lwamulilo ulwakwisa kanda abo bonse abasyaisiba Lesa kabili nabo bonse abashumfwila Imbila Nsuma ya Mfumu yesu Yesu. ");
INSERT INTO bwc_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","Bakakyula umuyayaya, kabili akabafumya namuceni kyakwe elyo namubukata bwabulamba bwakwe, ");
INSERT INTO bwc_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","Lintu akaba nabwela pali bulya busiku, abamusilo bakalamulumbanya, elo abamutetekela nabo bakamukindika, kabili namwebo mukaba nabena pantu mwalisumina amasiwi yabukambone bwesu. ");
INSERT INTO bwc_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","Eikyo lyonsefye tulamipepela, ukuti mube nemibeele yalinga kubwite buntu Lesa amitako. Pakuti kumaka yakwe engafikilisya ifisuma fyonse fintu mufwaya ukukita nokupwilikisya imilimo yenu yonse intu mubomba mukisumino, ");
INSERT INTO bwc_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","pakweba ati isina lya Mfumu Yesu likatamikwe muli mwebo, namwebo mukatamikwe muli ena, ukulingana nokusenaminwa kwakwa Lesa wesu elyo ne Mfumu yesu Yesu Klistu. ");
INSERT INTO bwc_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","Nomba, ukulolenkana nokwisa kwa Mfumu yesu Yesu Klistu kabili nokukumana kwesu kyapamo nankwe, tulemipapata mwe babwananyina ukuti, ");
INSERT INTO bwc_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","tamufwile ukutunsya imitima nangu ukusakamana pamabusesemo yamo, inkalata nelyo utusebo tumo, utulanda ati nifwebo twalandile ati ubusiku bwa mfumu nabwisa kale. ");
INSERT INTO bwc_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","Mwileka uuli onse amilufye munsila iili yonse, pantu bulya busiku tabwakese mpakafye abantu ngabayalukila Lesa kabili nomuntu mubifi akasokoloke, ");
INSERT INTO bwc_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","uupinkana kabili uunsansabika ukukila pali fyonse ifitwa tulesa nafyonse fintu abantu bapepa, pakuti akapiite apakwikala mwitempele lyakwa Lesa, nokulalamda ukuti ninebo Lesa. ");
INSERT INTO bwc_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","Busye tamwibusya ukuti ilyo nali namwebo nalimyebele ifi? ");
INSERT INTO bwc_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","Kabili nomba mwalisiba ikyalenga ukuti kwaliba ikyamwikatilila pakuti akaisikolole pansita iyalinga. ");
INSERT INTO bwc_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","Pantu amaka yankama yakwa mpulamafunde, kabili ikili ilabomba kabili fintu nandile ukuti fikakitika, tekuti fikitike kanofye Lesa afumyapo uulenga ifi fintu ukukitika. ");
INSERT INTO bwc_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","Kabili elo mpulamafunde akasokoloka, uo Imfumu Yesu ikakifya kumupu wakukanwa kakwe nokumonaula kubukata bwakwisa kwakwe. ");
INSERT INTO bwc_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","Ukwisa kwakwa mpulamafunde kukabafye nge mibombele yakwa Satana, akabomfya imisango yonse iyakulangilamo amaka yakwe ukupitila mufisibilo ne fipapwa ifi fikaba fyabufi. ");
INSERT INTO bwc_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","Kabili akabomfya nensila syonse isyo umubifi abepelamo abo abaleloba. Bakaloba pantu balikene ukutemwa ikisinka kabili nokupusuka. ");
INSERT INTO bwc_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","Pamulandu waifi Lesa alatuma amaka yakubafulunganya, mukubalenga basumine ifyabufi, ");
INSERT INTO bwc_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","pakuti bonse bakasekwe, pantu balikene ukusumina ikisinka lelo balebekelwa mububifi. ");
INSERT INTO bwc_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","Lelo lyonse tulatotela Lesa pamulandu wenu mwebatemwikwa ku Mfumu, pantu pakutampa Lesa amisalile ukuti mukabe abantansi ukupusuka, ukupitila mukusangululwa kwa Mupasi elo nokusumina mukisinka. ");
INSERT INTO bwc_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","Lesa amitile pamulandu wa Mbila Nsuma twamisimikile, pakuti mukwateko ubukata bwa mu Mfumu Yesu Klistu. ");
INSERT INTO bwc_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","Eikyo kansi mweba bwananyina beni abashipa nokwikatililila kuntambi twamishilile isyo twamifundile, ukupitila mumasiwi yantu twamyebelefye pakanwa, nayantu twamilembele munkalata. ");
INSERT INTO bwc_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","Imfumu yesu Yesu Klistu umwine, na Lesa Tata uwatutemenwe, nokutupela ikikoselesi kyamuyayaya, nokusumina ukusuma ukupitila mukusenaminwa, ");
INSERT INTO bwc_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","akoselesye imitima yenu nokumikosya pakweba ati mulebomba imilimo iisuma yonse nokulalanda ifisuma. ");
INSERT INTO bwc_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","Mukulekelesya, mwebamunyinane muletupepela ukuti amasiwi yakwa Lesa yatwalilile ukusabankana elo nokupokelelwa nomukinsi, ngefyo kyali pali mwebo. ");
INSERT INTO bwc_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","Kabili mulepepa nokutila twingapokololwa, kubalwani, elyo nabantu ababifi pantu tebonse abakwata ikitetekelo. ");
INSERT INTO bwc_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","Lelo Lesa wakisinka, akamikosya kabili nokumikingilila kububifi. ");
INSERT INTO bwc_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","Kabili twalisintilila mu Mfumu, ukuti mulakita, kabili mwakulakita fintu twamwebele. ");
INSERT INTO bwc_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","Imfumu naitungulule imitima syenu mukutemwa ukwakwa Lesa namukusupikisya kwakwa Klistu. ");
INSERT INTO bwc_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","Nomba tulemikonkomesya mweba bwananyina, mwisina lya Mfumu Yesu Klistu, ukuti talukeni kuli munyina uuli onse uuwikala mubunaŋani, kabili uushikala ukulingana namafundisyo mwapokelele ukufuma kuli fwebo. ");
INSERT INTO bwc_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","Pantu imwe mwebene mwalisiba fintu mufwile ukulatupasyanya, pantu tatwali banaŋani lintu twali namwebo, ");
INSERT INTO bwc_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","tatwalilepo umukate wamuntu uuli onse ukwabula ukulipa, lelo twalebombesya kabili twalebomba ubusiku nakasuba pakuti twiba ikisendo ku uli onse pali mwebo. ");
INSERT INTO bwc_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","Tepamulandu wakweba ati tatwakwata isyo nsambu, isyakuti muletutungilila, lelo nipamulandu wakumipela ikilangililo ikisuma ikyakulatupasyanya. ");
INSERT INTO bwc_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","Pantu nelyo twali namwebo, twalimipele iki ikipope ukuti, “Uwakana ukubomba nokulya elalya”. ");
INSERT INTO bwc_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","Pantu tulomfwa ukuti bamo pali mwebo banaŋani, tababomba inkito baikalilafye ulwambo. ");
INSERT INTO bwc_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","Nomba abantu bapalefyo tulabakonkomesya kumaka ya Mfumu Yesu Klistu ukuti balekita fintu bafwile ukulakita pakuti balepanga ubwikasi bwabo. ");
INSERT INTO bwc_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","Mweba bwananyina, mwilatendwa ukulakita ifisuma. ");
INSERT INTO bwc_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","Ngyakyakuti uuli onse akana ukukonka fintu twalanda muli iyi inkalata, mumwisibe bwino uyo muntu kabili mwilasangwa nao, pakuti abe nensoni. ");
INSERT INTO bwc_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","Mwilamumona ngo mulwani wenu, lelo mulemusoka ngamunonko. ");
INSERT INTO bwc_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","Nomba lekeni Imfumu yamutende iyine, imipe umutende munsita syonse kabili namusila yonse. Imfumu ibe namwebo bonse. ");
INSERT INTO bwc_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","Nebo ne Paulo nalemba aya amaposyo namaboko yandi. Ngekisibilo ku nkalata sintu nemba. ");
INSERT INTO bwc_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","Ukusenaminwa kwa Mfumu yesu Yesu Klistu kube namwebo bonse.");
INSERT INTO bwc_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","Ninebo Yakobo, umubomfi wakwa Lesa ne Mfumu Yesu Klistu namiposya mwemikowa ikumi limo nasibili isyasalangana ifyalo fyonse. ");
INSERT INTO bwc_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","Mwebabwananina mulekimona ngesyuko amakyusi ya misango misango ngayamisila, ");
INSERT INTO bwc_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","pantu mwalisiba ukuti ukwesiwa kwa kitetekelo kyenu kuleta ukusipikisya. ");
INSERT INTO bwc_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","Lekeni ukusipikisya kupwisye umulimo wakuko, pakweba ati muleba abakula, kabili abapwililika ukwabula ukubulisya akantu nangu kamo. ");
INSERT INTO bwc_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","Umo pali mwebo ngaabulisya amano, alombe kuli Lesa ukuti amupele. Lesa nao uupelesya nensansa kuli onse uwamulomba akamupela. ");
INSERT INTO bwc_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","Lelo pakulomba afwile aketekela ukwabula ukutwisika, pantu onse uutwisika aba nge bimbi lya pali bemba ili sunkanisiwa nokupitwa nomwela. ");
INSERT INTO bwc_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","7","Umuntu uutwisika eenekela ukupokelela ikintu ikili kyonse ku Mfumu. ");
INSERT INTO bwc_vpl VALUES ("JM1_8","089_1_8","JAS","1","8","8","Abafye uwabula ukusininkisya fintu ali nokukita, imilangwe yakwe yaluka alukafye. ");
INSERT INTO bwc_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","Uwabwananyina umupina afwile ukumfwa bwino palifintu Lesa amukindamika. ");
INSERT INTO bwc_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","Nomukankala nao afwile ukumfwa bwino pali fintu Lesa amupoka ubukindami, pantu akalukuta ngeluba lya kyani. ");
INSERT INTO bwc_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","Pantu akasuba katula akabalikisya, nekikabilila kilenga ikyani ukuma. Amaluba ya kyani yalalukuta nokuyemba kwapwa. Mu musango umo wine efintu nomukankala akonaulwa pansita apamfiwe namakwebo yakwe. ");
INSERT INTO bwc_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","Alisyuka umuntu uusipikisya mu mesyo. Pantu ngakimfya amakyusi akapokelela ikilambu kya mweo kintu Lesa alaya abantu abamutemwa. ");
INSERT INTO bwc_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","Ngamwatunkwa, peba nangu umo uufwile ukulanda ati, “Lesa antunka.” Pantu Lesa tekuti atunkwe ku mubifi kabili nao tekuti atunke uuli onse. ");
INSERT INTO bwc_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","Lelo umuntu atunkwa lintu ulunkumbwa lwakwe lwamongola no kumukwata. ");
INSERT INTO bwc_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","Elo ulunkumbwa ngalwaimita lufyala ulubembu, kabili no lubembu nga lwakula lufyala imfwa. ");
INSERT INTO bwc_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","Ala mwilabepwa mwe bwabananina! ");
INSERT INTO bwc_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","Ifyabupe fyonse ifisuma kabili ifyapwililika fifuma ku mulu. Fifuma kuli Tata uwabumba ifya mumulu ifipela ulubuuto. Uusyaluka ngekinsingwa kilesyunguluka. ");
INSERT INTO bwc_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","Lesa umwine ku kufwaya kwakwe ewatufyele kwi siwi lyakwe ilyakisinka pakuti tube abantansi pa fibumbwa fyakwe fyonse. ");
INSERT INTO bwc_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","Isibeni iki mwebabwananina abatemwikwa! Umuntu onse alingile ukuba uwayanguka ukumfwa, lelo uukokola ukulanda nokufulwa. ");
INSERT INTO bwc_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","Ukufulwa kwa muntu takuleta ubulungami buntu Lesa akabila. ");
INSERT INTO bwc_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","Talukeni ku fyakowela fyonse ne misango ibi yonse mukili nayo. Mulenakila Lesa nokupokelela amasiwi yakwe yantu abyala mu mitima yenu ayaba namaka yakumipususya. ");
INSERT INTO bwc_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","Mwilaibepa pakupelelafye mukumfwa amasiwi yakwa Lesa lelo mulekita nafintu yalemyeba. ");
INSERT INTO bwc_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","Onse umfwafye amasiwi lelo takita fintu yalanda, aba ngomuntu uwailolesya pamenso mwigilashi. ");
INSERT INTO bwc_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","Kabili lintu aimona aya, kabili palya pene ailaba fintu amoneka. ");
INSERT INTO bwc_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","Lelo onse uulolekesya mu Mafunde ayapwililika. Amafunde ayalenga umuntu ukuba umuntungwa, kabili atwalilila ukwabula ukuba komfwafye ulaba lelo kakita, akaba uwapalwa muli fyonse mumilimo yakwe yonse. ");
INSERT INTO bwc_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","Bonse abalanda ati nibakapepa, lelo tabasunga ululimi lwabo ninsi baibepafye abene nabukapepa bwabo buntu bwabula ubuyo. ");
INSERT INTO bwc_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","Bukapepa ubwalengama kabili ubusyakowela kuli Lesa nyubu, Kwafwa abana bansiwa naba mukamfwilwa muli fintu balekabila nokutalusya umuntu mukukowela kwisonde. ");
INSERT INTO bwc_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","Mwe babwananina, abasumina mu Mfumu yesu Yesu Klistu iyabukata, mwilaba nakapatulula. ");
INSERT INTO bwc_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","Ngakyakuti umukankala uufwele imbala minwe ya golide nefyakufwala ifyayemba aisa mu ŋanda muntu mulongene elo nomupina uwasapula nao aisamo. ");
INSERT INTO bwc_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","Ngamwapokelela bwino uufwele insalu isisuma mwamweba ukuti, “Ikala apa apaweme”, elo mwaeba umupina ukuti, “Webo keminine uko, nangu ati, soikale pansi mupepi nanebo,” ");
INSERT INTO bwc_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","Busye ninsi tekapatulula mwakita? Busye ninsi temano ayabi mwabomfya mukupingula? ");
INSERT INTO bwc_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","Ufweni mwebabwananina abatemwikwa bandi! Busye Lesa tasala aba bantu abo abantu pano sonde beta ukuti bapina ukuba abakankala mukitetekelo? Abasala ukupyana ubufumu buntu Lesa alaya abamutemwa. ");
INSERT INTO bwc_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","Lelo mwebo mwafupula abapina. Busye tebakankala abamifyengelesya no kumitatanisinsya mufilye? ");
INSERT INTO bwc_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","Busye tebasalula isina likindami ilyakwa Yesu lintu mwainikweko? ");
INSERT INTO bwc_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","Nga kyakuti ikine kine mulakita ifunde ilikalamba ilya mumalembo yamusilo ilyakuti, “Uletemwa umubiyo nga fintu waitemwa,” ninsi mulalungika. ");
INSERT INTO bwc_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","Lelo ngamulapatulula ninsi mulabembuka kabili namusangwa no mulandu wakutoba amafunde. ");
INSERT INTO bwc_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","Uyo onse usunga amafunde yakwa Lesa yonse elo atobapo limo, ninsi apanga umulandu wakutoba yonse. ");
INSERT INTO bwc_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","Pantu uwalandile ukuti, “Wilakita bukende,” ewalandile nokuti, “Wilaipaya.” Kansi ngataulekita bukende lelo uleipaya ninsi watoba amafunde. ");
INSERT INTO bwc_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","Imilandile yenu nemikitile yenu ileba nga bantu abalepingulwa ku mafunde ayalenga tube abantungwa. ");
INSERT INTO bwc_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","Pantu Lesa takomfwe luse pakupingula umuntu usyakwete uluse. Pantu uluse lwalikindama pabupingusi. ");
INSERT INTO bwc_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","Busye mwebabwananyina, bukumunsi bulimo umuntu ngalanda ukuti alikwata ikitetekelo nomba talebomba nangu kimo? Busye ikyo kitetekelo kuti kyamupususya? ");
INSERT INTO bwc_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","Nga kyakuti munyinenwe nangu nkansi yenu nasapula kabili takwete nefyakulya. ");
INSERT INTO bwc_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","Ngakyakuti umo pali mwebo alanda ukuti, “Mwende umutende, mulefwala mulekaba, mulelya muleikuta,” Lelo takitilepo nangu fimo pali fintu balekabila, busuma nsi bulimo? ");
INSERT INTO bwc_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","Mu musango umo wine, ikitetekelo kyekafye ukwabula ukubombapo nangu fimo kintu kyafwa. ");
INSERT INTO bwc_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","Nomba umo kuti alanda ukuti, “webo naukwata ikitetekelo, nanebo ndabomba imilimo iisuma.” Ndanga ikitetekelo kyobe ikyabula imilimo, nanebo nalakulanga ikitetekelo kyandi mu milimo yandi. ");
INSERT INTO bwc_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","Mwasumina ukuti kwabafye Lesa umo mpo. Kisuma! Nengulu sine nasyo syasumina ifyo fine kabili situtuma nomwenso. ");
INSERT INTO bwc_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","We kipumbu kya muntu we! Ulimukufwaya nkulange ukuti ikitetekelo kyabula imilimo iisuma kyafye? ");
INSERT INTO bwc_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","Busye kinsi kyalengele Aburahamu ikikolwe kyesu abe uwalungama pamenso yakwa Lesa? Nipamulandu nemilimo isuma akitile lintu atuulile umwana wakwe Isaaki ilambo pa kipailo. ");
INSERT INTO bwc_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","Mwamona ukuti ikitetekelo kyakwe nemilimo fyalebombela pamo, kabili nekitetekelo kyakwe kyapwililike kumilimo akitile. ");
INSERT INTO bwc_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","Kabili namalembo yafikilisye ayakuti, “Aburahamu asumine Lesa, kabili nekitetekelo kyakwe kyalengele Lesa ukumumona uwalungama pa kinso kyakwe.” Kabili Aburahamu aitilwe ukuti ni kibusa wakwa Lesa. ");
INSERT INTO bwc_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","Mwamona ukuti abantu betwa abalungama pali fintu bakita, te pakitetekelofye kyeka. ");
INSERT INTO bwc_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","Epamo pene naku mwanakasi Rahabu kilende. Lesa amumwene uwalungama pa kinso kyakwe pali fintu akitile. Apokelele inengu sya bena Israeli sibili, asyafwilisyako nokufyuka ukubomfya insila simbi. ");
INSERT INTO bwc_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","Nga filya umubili wamuntu ufwa umupasi wamuntu nga wafumamo, efintu nekitetekelo kiba ikyafwa ngatakilebomba milimo isuma. ");
INSERT INTO bwc_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","Mwebabwananyina mwileka abengi pali mwebo babe bakafundisya. Pantu mwalisiba ati fwebo fwe bakafundisya tukapingulwa ukukilapo. ");
INSERT INTO bwc_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","Pantu fwebonse tulapanga ifilubo. Nomba umuntu uusilufyanya muli fintu alanda ninsi alipwililika. Kabili ninsi aba muntu uwakwata amaka yakutungulula umubili wakwe onse. ");
INSERT INTO bwc_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","Tubika ikela mukanwa kakwa kabalwe pakuti alekita fintu tulefwaya. Ngatwakita ifi tulenga kabalwe ukuya konse kuntu tulefwaya. ");
INSERT INTO bwc_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","Tontonkanyeni pakyombo. Nangu kikule syani, nangu kipiitwe nekimwela ikyakosa syani, kipindulwilwafye kukakafi akanono nokuya konse kuntu kensya wakyombo alefwaya. ");
INSERT INTO bwc_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","Ululimi nalo efintu lwaba nangu lube kalundwa akanono akamubili, lulailumbanya ukuti lukita ifyakupapa. Tontonkanyeni fintu impanga iikalamba bayokyafye kuli kamulilo akanono. ");
INSERT INTO bwc_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","Ululimi nalo lwaba kwati mulilo. Pafilundwa fyamibili yesu, ululimi lwaba kwati kyalo ikyaisulamo ububi bonse, lusalanganya ububi mu mubili onse. Lutanda umulilo mu bumi bwesu bonse ubwa pano kyalo kabili lwena lufumya uyu mulilo kumbo. ");
INSERT INTO bwc_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","Umuntunse kuti ateeka imitundu yonse iya nama syampaanga, ifyoni, ifikulika nefyamuli bemba nakuba fyonse ifi tulafiteeka. ");
INSERT INTO bwc_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","Lelo tapali umuntunse uwingateeka ululimi. Ululimi talutuusya ku bubifi kabili lwaisulamo no busungu ubwipaya. ");
INSERT INTO bwc_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","Ku lulimi tulalumbanisisyako Imfumu na Tata, nakabili ku lulimi lumolwine tulatipwililako abantu banensu ababumbwa mukyata kyakwa Lesa. ");
INSERT INTO bwc_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","Ku kanwa kamo kene kufuma ukutipwila no kulumbanya, mwebabwananina ifi tefintu kifwile ukuba. ");
INSERT INTO bwc_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","Busye kuti amensi ayasuma na yakikelekese yafuma pa kilambe kimo? ");
INSERT INTO bwc_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","Mwebabwananina, busye umukunyu kuti watwala ifisabo fya miolife, nangu umwangasi ukutwala amakunyu? Ala tekuti ikilambe kya mensi ya kikelekese kifumye amensi ayasuma. ");
INSERT INTO bwc_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","Ninani pali mwebo uwamano kabili uwailuka? Uyo afwile ukulanga ukuti wamano kabili muntu wailuka mumikitile yakwe isuma mu fintu akita, mukuikefya nokuba uwamano mulifyonse fintu alekita. ");
INSERT INTO bwc_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","Lelo mu mitima yenu ngamwalikwata umufimbila ngansi no kuitemwa, lekeni ukuyumfwilapo nangu ukukana ikisinka. ");
INSERT INTO bwc_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","Amano yamusango uyo, tayafuma ku mulu, lelo ya pano isonde, teyabumupasi lelo yakwa kiwa. ");
INSERT INTO bwc_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","Pantu uko ukuli umufimbila nokuitemwa, ekuba nekimfulunganya ne misango yabubifi yonse. ");
INSERT INTO bwc_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","Lelo amano ayafuma kuli Lesa yena yaba ayasanguluka, yamutende, yamutembo no bufuke. Elo kabili yakwatisya uluse yakitafye ifisuma. Tayaba namunkisya kinani lelo yaiminina pakisinka. ");
INSERT INTO bwc_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","Ukuba uwalungama pa kinso kyakwa Lesa, efisabo abasopa umutende basombola lintu babyala mu mutende. ");
INSERT INTO bwc_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","Busye ifilenga mulesosa nokulapusana fifuma kwisa? Busye temukukonkelela ulunkumbwa ululwisikana muli mwebo? ");
INSERT INTO bwc_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","Mulafwaya ukukwata ifintu nomba tamukwata, ekyo mulepailapo na bantu. Mufimbila ukukwata nomba tamukwata, eco mupusanina no kulwa. Ekyo tamukwatila nipamusango tamulomba kuli Lesa. ");
INSERT INTO bwc_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","Ngamwalomba, tamupokelela pamusango mulomba na mapange ayabi. Mulomba ifintu fyakumisansamusya mwebene. ");
INSERT INTO bwc_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","Mwe bantu bafutatila Lesa mwe! Busye tamwaisiba ukuti ukuba bukibusa nesonde kuba ubulwani kuli Lesa? Kansi onse uwasala ukuba kibusa ne sonde aba mulwani wakwa Lesa. ");
INSERT INTO bwc_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","Mwilatontonkanya ukuti tefisinka ifyalembwa mu malembo ifilanda ukuti, “Lesa alitutemwisya ngansi kabili alatufwila ubukwa pamulandu no mupasi untu abika mulifwebo.” ");
INSERT INTO bwc_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","Lelo atupela ukusenaminwa ukukalamba. Ekintu amalembo yalandila ukuti, “Lesa acincintila abafilumba lelo abaikefya bena alabakwatila ikikuku.” ");
INSERT INTO bwc_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","Kansi mulenakila Lesa. Mule ansya Kiwa nao akamibutuka. ");
INSERT INTO bwc_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","Palamineni kuli Lesa nao akapalama kuli mwebo. Mwe babembu sambeni iminwe yenu! Sangululeni imitima yenu mweba myalu myalu. ");
INSERT INTO bwc_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","Beni nobulanda, lileni nokuloosya. Lekeni inseko syenu syaluke imisowa nensansa sibe ubulanda. ");
INSERT INTO bwc_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","Muleikefya pa kinso kya Mfumu, nayo ikamisansabika. ");
INSERT INTO bwc_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","Mwebabwananyina mwila ambana. Onse uwalanda ifibi pali munyina nokumupingula, ninsi alanda ifibi pa mafunde yakwa Lesa no kuyapingula. Kansi ngawapingula amafunde yakwa Lesa ninsi tauleyanakila iyoo lelo uleyapingulafye. ");
INSERT INTO bwc_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","Kwabafye umo kapela wamafunde kabili kapingula, uwingapususya nokulofya. Nomba busye niwebo nani uwakupingula umubiyo? ");
INSERT INTO bwc_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","Umfweni nomba mwebalanda ukuti, “Lelo nangu mailo, tukaya kuli uyu nangu kuli ulya musumba. Tukayapwako umwaka umo, tuyapanga amakwebo nokupanga ulupiya ulwingi.” ");
INSERT INTO bwc_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","Tamwaisiba fintu ubwa mailo bukaba. Tamwaisiba ngamukaba abomi. Mwebo mwabafye nga fube fube uumoneka pa kasitafye akanono, kabili mwaluba pantu ele. ");
INSERT INTO bwc_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","Fintu mulingile ukulalanda nifi, “Imfumu nga yafwaya tukaba abomi kabili tukakita ifi na filya.” ");
INSERT INTO bwc_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","Nomba mwebo muupanga ifilumba nokulayumfwa. Ukuyumfwa konse ukwamusango uyu kuntu kwabipa. ");
INSERT INTO bwc_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","Kansi umuntu onse uwaisiba ifisuma fintu afwile ukukita, nomba takita, ninsi lubembu kuli ena. ");
INSERT INTO bwc_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","Umfweni mwe bakankala, lileni ifilamba, mwangwilepo nemisowa pamusango na makyusi ayalamisila. ");
INSERT INTO bwc_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","Ifyuma fyenu nafibola, kabili nensalu syenu nasiliwa ku buswa. ");
INSERT INTO bwc_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","Golide na Silufele yenu nafikwata indalawa. Nesi ndalawa sikaba ekambone wakumisinina. Sikalya imibili yenu kwati mulilo. Mwebo namuitulikila ifyuma munsiku syakulekelesya. ");
INSERT INTO bwc_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","Moneni ifilambu mwafililwe ukupela ababomfi abalebomba mu mabala yenu filelilila palimwebo. Imisowa syabalesombola mu mabala yenu, nasifika mu matwi yakwa Lesa Wamaka yonse. ");
INSERT INTO bwc_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","Mubwikasi bwenu ubwa pano isonde mwaleposa ulupiya pa fyakuisansamusya mwebene mweka, nokuilemena. Namuinya mubusiku ubwakwipaiwa. ");
INSERT INTO bwc_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","Mupingwila abantu bakaele imilandu nokubepaya mulabepaya, nabo tabakanako nakalya. ");
INSERT INTO bwc_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","Mwebabwananyina muleteka imitima mpaka nalintu Imfumu ikabwela. Moneni fintu umulimi ateka umutima pakulolela, ifisabo ifisuma fikule fipye mwibala lyakwe. Ateka umutima nokulolela imfula yakubalilapo ne yakulekelesya. ");
INSERT INTO bwc_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","Nemwe bene muleteka imitima nokwiminina abakonsa ndi, pamusango ukwisa kwa Mfumu nakupalama. ");
INSERT INTO bwc_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","Mwebabwananyina, mwilaisosya pali fintu umubiyo akita, pakuti mwikapingulwa. Moneni Kapingula ali pa mwinsi. ");
INSERT INTO bwc_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","Mwebabwananyina, fisendeni ngekilangililo fintu bakasesema abalelandila mwisina lya Mfumu balekita, baleteka imitima munsita ya makyusi. ");
INSERT INTO bwc_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","Moneni, balya basipikisya mu makyusi ebo twita abasyuka. Mwalyumfwa ukusipikisya kwakwa Yobo nafintu Lesa amulambwile pakulekelesya pantu imfumu yafulisya uluse no kukuntikilwa. ");
INSERT INTO bwc_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","Nekyakilapo mwe bamunyinane mwilalapa mulapo pakulaya ikilayo. Mwilalapa mulu ne ikyalo, nangu ikintu kyonsefye. Lelo mwebo mulelandafye ngani “Ee” ati ee nga ni “Awe” ati awe, ngateifyo Lesa akamipingula. ");
INSERT INTO bwc_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","Busye umo pali mwebo ali mumafya? Napepe. Busye umo pali mwebo ali nensansa? Naembe inyimbo syakulumbanya Lesa. ");
INSERT INTO bwc_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","Busye umo pali mwebo nalwala? Naete abakalamba ba mulukuta bamupepelele nokumusuba amafuta mwisina lya Mfumu. ");
INSERT INTO bwc_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","Kabili nepempo lya mukitetekelo likalenga umulwele ukupola. Imfumu ikamundapa nokumubelela uluse ngalibembuka. ");
INSERT INTO bwc_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","Kansi Muleyebelela imembu kuli kila umo naumo nokulapepelana pakuti mulepola. Ipepo lya mulungami lilabomba na maka. ");
INSERT INTO bwc_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","Eliya alifye muntu ngafwebo. Apepele pamaka ukuti imfula iloka kabili nayo tayalokele pa myaka itatu nekipande. ");
INSERT INTO bwc_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","Nakabili apepele ukuti iloke nayo yalilokele nefisabo fyatwala pamusili. ");
INSERT INTO bwc_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","Mwebabwananyina, umo pali mwebo nga ayaluka, afuma na munsila yakisinka elo umbi amwalulula nakabili, isibeni iki. ");
INSERT INTO bwc_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","Umuntu onse uwayalulula umubembu ukufuma kumibele yakwe iyalubembu, akapususya ulya muntu kumfwa kabili akafimba pa membu isingi.");
ALTER TABLE bwc_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
