﻿USE sofia;
DROP TABLE IF EXISTS sofia.bvw_vpl;
CREATE TABLE bvw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bvw_vpl WRITE;
INSERT INTO bvw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Leya kweshcha shundǝ kǝ ɗar Yǝso kǝrǝsti hweya Fara. ");
INSERT INTO bvw_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nda i yarandǝ tapǝnaa Ishaya hi tǝ ndatwa: \"Ni thlǝn lǝ thlǝnda mban le na tahsandǝ mbanɗeku ɗi. ");
INSERT INTO bvw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ɓurata nifǝ le naka atfata hur loktara, le naka ndatwa tahsan mbanda lǝ Mwanda ɗi kǝ pupwenangnguni mbachikǝn'en hi.\" ");
INSERT INTO bvw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ɓak Yohanna nakna ɓasa hur loktarǝ tǝ ndatwa: \"Chikawuni kǝtǝrǝnhi kǝ sangfichǝ Baptisma kǝ kalang fichǝ ɓǝɓichitfechi'enhi.\" ");
INSERT INTO bvw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nat nofchi Yahudiya tǝ Urshelima ɗǝknda ɓǝɗ'en tǝrkǝndǝhi saǝn baptisma kanda a suhwaɗ Urdun. ");
INSERT INTO bvw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohanna njela'en pom ngelupa kǝnaǝn mumi'en tǝ poma, ɗǝsǝmtǝ'en mbecha tǝ ɗecha. ");
INSERT INTO bvw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ndakǝnwa yuna ɓata ɗiffitǝna le nak mwanchin mǝ njang chika sahǝt pahǝmchi'en sǝkwisi kǝ koppihi kǝ kwasayihiwa. ");
INSERT INTO bvw_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Saayi Baptisma kuni tǝ ama paɗ nakna sǝt ikǝn tǝ Chiɗchiɗ chit Shemeɗa. ");
INSERT INTO bvw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Hanmunchiniyu ɓak Yǝso thlata Nazarat a thlet hǝmǝt Galili. Yohanna saǝn baptisma a suhwaɗ Urdun. ");
INSERT INTO bvw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nak Yǝso cheta kisha hur ama chatkichuyu nakǝn in'afshi hi ɓak Shemeɗa Fara hai kǝ ɗar indi'en nda ngungwiɗnga. ");
INSERT INTO bvw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Sǝkkǝ nofchǝ ɓurata a afshi tǝ ndatwa: \"Sokǝn naka hwe'engna le yahti paɗ lela sǝkti mbǝnkǝnfa.\" ");
INSERT INTO bvw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Chatkichuyu pǝkkǝ Shemeɗa Farǝ ndǝ kǝ hur loktara. ");
INSERT INTO bvw_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Munɗǝ kumchit fwaɗa Sheɗanna kǝkaɗanda a hur loktara. Mǝla hur loktara tǝ ɗǝ hǝrǝmcha nak mala'ika Fara kǝssandǝsi. ");
INSERT INTO bvw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ɗiffitǝkǝn kǝsang fichǝ Yohanna, ɓak Yǝso kǝ hachahai Galili nakna ɓasǝ kweshcha shunda Fara. ");
INSERT INTO bvw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ndakǝnwa: \"Ɓeɗ hanmunchǝkǝn nduk. Fara yehsǝ cheɗanda kuni wa kutur nakǝn. Chikawuni kǝ tǝrǝnhi, fǝram kit kǝ kwescha shunda Fara.\" ");
INSERT INTO bvw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nak Yǝso ɓǝrtǝhi tǝ mi suhwaɗ Galili, nakǝn Siman tǝ Andarawus hwanman Siman kanda muh langtanganga kǝthlǝm fa tumchǝ naknda. ");
INSERT INTO bvw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ndang Yǝso kandǝwa: \"Kuramnji ni sandǝkuni kǝfa ɓat tǝ nofcha mbǝɗengna.\" ");
INSERT INTO bvw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Chatkichuyu malangndǝ tum tincha kurǝkǝndǝndǝ. ");
INSERT INTO bvw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nak Yǝso witǝ kǝ ɓan, nakǝn Yakubu hweeya Zabadi tǝ Yohanna hwanmankǝn a hur kommbawal, kanda tahsandǝ langtangchengnanda. ");
INSERT INTO bvw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Akǝn kanda malkǝndǝ shinnandǝhi, Zabadi hur kommbawal tǝ tahǝt fa torcheng nanda kurǝkǝndǝndi. ");
INSERT INTO bvw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ɓaknda Kafarnahum, ɓak farǝ yipta Yahudawecha, yimkǝ Yǝso ɓǝt humta Yahudawechihi, nakna sakanda kandǝhar. ");
INSERT INTO bvw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Shekɗa ng i'ndǝ kandǝ tǝ witǝ sakiniyu, nda nifǝ sǝkkǝsi, nga nda malndǝmcha thlahɓǝt Musa wa. ");
INSERT INTO bvw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nifǝsa hur ɓǝt humta Yahudawechikǝnhi tǝ ɓǝɓi Shemeɗa fa hwakǝn, ");
INSERT INTO bvw_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ndakǝnwa: \"Mǝ kǝmukǝ tǝ kani Yǝso lǝ Nazarat ta? Ɓaku kǝ tǝkangnǝ kanihiwa? A shini ndu wunnaku. Sokǝn naku Chiɗchiɗ le ɓaka mbǝɗa Fara.\" ");
INSERT INTO bvw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","\"Ɓokang Yǝso ɓǝɓi shemeɗkǝnhi ndaǝnwa ngasu ɓa, chukisha fat'en!\" ");
INSERT INTO bvw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ɓǝɓi shemeɗkǝn nakna saktanda mǝla hwata cheknakisha fat'en. ");
INSERT INTO bvw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Pǝɗang ǝnatkǝn nofchǝkǝnfa sahangndǝ ndani witǝ mǝ leya? Yuwa sakandaɗi tǝ sǝktǝsiwa? Ndangna ɓǝɓi shemeɗchǝkǝnwa kǝ chendakish paɗ sǝkkǝndǝndi. ");
INSERT INTO bvw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kusheng i sǝt Yǝso yu sǝkkǝficha a hachahai Galili nat. ");
INSERT INTO bvw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ɗiffitǝ chendengnanda kisha ɓǝt humta Yahudawechihi, pǝɗang Yǝso tǝ Yakubu tǝ Yohanna kǝ hura'a nda Siman tǝ Andarawus. ");
INSERT INTO bvw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nak thlaɓǝr Siman hahchin hafat kakǝnnda, chatkichuyu ɓwa'angnda Yǝso. ");
INSERT INTO bvw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ɗǝk Yǝso ɓǝsndi kǝskǝn har'en thlaǝn, chat kǝnkǝna ɗaɗi nakna sǝt tor ɗǝsǝmta. ");
INSERT INTO bvw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ɗiffitǝ hǝmta farǝhi ngomang ndǝ haacha tǝ fa ɓǝɓi luwurcha, ");
INSERT INTO bvw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nofchi hur hǝmǝtkǝn ngomkǝnda kish kǝ mi hura'a, ");
INSERT INTO bvw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kǝnang Yǝso hachǝkǝnaɗi tǝ fa ɓǝɓi luwurcha, paɗ malawutǝ fa ɓǝɓi luwurchǝkǝn kǝ shuwunndǝwa kǝthlǝm shinndǝndi. ");
INSERT INTO bvw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Thlaakǝna ɓingtǝ tung, mwee ɓǝt shumma kǝ ɓǝt nguɗuk ka hwanda. ");
INSERT INTO bvw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Siman tǝ tahǝt nofchǝkǝn naknda katndi. ");
INSERT INTO bvw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mbǝsangnda, ndangndǝwa: \"Chikawun mǝla kassa.\" ");
INSERT INTO bvw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ndang Yǝso kandǝwa: \"Tama hwanhǝmchi naka ɓan, kǝnni ɓasa pǝnniyu paɗ ndǝkǝn cheka ɓat tǝ nji.\" ");
INSERT INTO bvw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wu'yaǝn hachahai Galili nak na ɓasa ɓǝt humta Yahudawechihi nak na chandǝ ɓǝɓi luwurcha kish. ");
INSERT INTO bvw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ɓak nifǝ tǝ tarkwinda fa, kopkǝnhi nakna hwanandǝ tǝ ndatwa: \"Ma yehnǝsi kǝnitǝna ɗaɗi.\" ");
INSERT INTO bvw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Haɗaǝn Yǝso fa, tǝka'ǝn harfa, ndakǝnwa: \"Yehisi kǝnu ɗaɗi.\" ");
INSERT INTO bvw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Chat kichuyu yimkǝ tarkwiinkǝnhi kǝnkǝnaɗi. ");
INSERT INTO bvw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ndang Yǝso wa pǝɗu kǝ mbwa'ana nifǝwa, ");
INSERT INTO bvw_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","\"Mbwa'ana chikawunwa, pǝɗu ɗu cheɗan faɗǝ ku Pǝrist kǝ fǝrnǝ i la fǝrtǝ ficha ma kǝnafichǝ nifa ɗaɗi nda ǝnnǝnǝ sakandǝ Musa kuni har yu, kǝ sokka ǝnnat sǝndǝwa kinnaɗi.\" ");
INSERT INTO bvw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pǝɗakǝn nakna mbwa'anda nofcha nakna fanandǝ shuwunkǝnhi ka'ǝn, kǝthlǝm ndǝkǝn Yǝso mbǝla'utǝ kalǝfathi a thlet hwanhǝmchǝkǝnwa. Pǝndakǝn kǝ ɓǝt ngunduk, paɗ nak nofcha ɓata mbǝɗ'en chika tǝ teni. ");
INSERT INTO bvw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ɗiffitǝ hwanmunchǝkǝn ɗimek, ngǝrang Yǝso in kǝ Kafarnahum, sǝkkǝ nofchǝwa mǝlahuri. ");
INSERT INTO bvw_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ɓak nofchǝ oi, paɗ mwa'u ɓǝtsǝwa taa kǝ mikǝnnda, mǝlan paɗ nakna ɓasa pathla Fara kanda. ");
INSERT INTO bvw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nɗǝkǝn ɓat nofcha mɓǝɗ'en tǝ tǝraɗ, nofchǝ fwaɗa tǝrkǝndi. ");
INSERT INTO bvw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mbǝsundǝ ɓǝt kǝ thlǝmatkǝn ndukwa, kǝthlǝm yakat nofcha tǝrkǝndǝ tǝ ɗar kǝtǝnkǝn, pahangndǝhi fǝrkǝndǝnda hai kǝ mbanitǝ Yǝso a ɗar ɓǝt hunat'en. ");
INSERT INTO bvw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nak Yǝso fǝr kitchiɗengnandǝhi, ndangna le sakaɗiyuwa: \"Hweya kalu fichǝ ɓǝɓifechekuhi.\" ");
INSERT INTO bvw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Malɗǝmchi fǝrkǝ kit kǝ kussa Musa yu nak ɗǝɗassa mbǝnniyu naknda yarandǝhi hur hanndǝkikecheng nanda. ");
INSERT INTO bvw_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","\"Kǝthlǝm mi nat nifiya shundǝ kichuyu? Mbwitǝ i nguchik keeke kǝ ɓǝɗa Fara, wunla kalang ɓǝɓichitfata nifǝhi manga Faruwa?\" ");
INSERT INTO bvw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tangtang neɗ Yǝso hi hur shemeɗ'en i nannda yara, ndangna kandǝwa: \"Kǝthlǝm mi natuni yarǝ kichuyu hur hanndǝkikechengnuni? ");
INSERT INTO bvw_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Len nak pa'pa i? kǝ ndangna le sakaɗiyuwa kalufichi ɓǝɓifandekuhiwa ndu kǝndangnǝwa thla'u tǝru ɓǝt hunaɗeku kǝ wii nǝ witekuwa? ");
INSERT INTO bvw_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kǝthlǝm kǝsǝnuniwa alchita hweya nifǝsi kǝ kalǝn ɓǝɓifathi a hur kishi'iya, ndangna le sakaɗǝ tǝkǝnwa: ");
INSERT INTO bvw_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","\"Ndukiwa thla'u tǝru ɗǝngleku kǝ pǝɗana ɗaɗi kǝ hure'eku.\" ");
INSERT INTO bvw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Thlaakǝn tukwas tǝrkǝn ndǝnglǝ'en cheknakissha hur hurǝkǝn, ɓanitǝ chikawuni, shekndang indǝ kanda naknda mwanandǝ Fara, ndangndǝwa: \"Tamwuma nat ǝn kicheyawa.\" ");
INSERT INTO bvw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ngǝrkǝn chetakish paɗ kǝ mi hawurta, ɓak ngom nofcha ɓǝɗ'en, paɗ sakangnakandǝ har. ");
INSERT INTO bvw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nakna mbǝrtǝhi, nakǝn Lawi hweya Halfa ɗas ɓǝt thlǝt chamta, ndaǝnwa: \"Kurunji\" thlaakǝn kurukǝnndi. ");
INSERT INTO bvw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nak Yǝso sǝm'ǝna a hurhura'a Lawi tǝ fa thlǝt chamcha tǝ fa ɓǝɓichitfata, tǝ kimshechi'en kǝthlǝm nofchǝ ka'ǝn kurukǝndi. ");
INSERT INTO bvw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kǝ nat malɗǝmcha fa sakandǝ ndelwercha Musa ɗi fichile naka Farisiyawecha, Yǝso mǝla sǝm'ǝn tǝ fa ɓǝɓifecha, tǝ fa thlǝt chamcha, ndangnda kimshechi'enwa kǝthlǝm mi natna sǝm'ǝn tǝ fa thlǝt chamcha paɗ tǝ fa ɓǝɓifecha? ");
INSERT INTO bvw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kǝ sǝktǝ Yǝso kandǝ kichuyu, ndangna kandǝwa: \"Nofchi nak ngwalngwal hi, kǝmawu ǝn kandǝ tǝ lǝ fǝr hanɓǝɓaawa, fichile nak hahchin na kanndi. Ɓuwi kǝthlǝm kǝ i fichile fǝrkǝ kitwa, ɓaki kǝthlǝm fa ɓǝɓichitfata\". ");
INSERT INTO bvw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nakǝnya kimshecha Yohanna tǝ Farisiyawecha kanda cherǝ ama. Ɓak nofcha mbǝɗa Yǝso sahangndǝwa: \"Kǝthlǝm mi nat kimshecha Yohanna tǝ i Farisiyawecha cherǝ ama paɗ ichiwa kanda cherǝ amwa? ");
INSERT INTO bvw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ngǝmang Yǝso wa, tǝkǝnǝnat sǝmat pera nata thlǝmat shikechikǝn kǝnnda cherǝ ama? Ngu nat kichuwa, ma mwe sǝmat perǝkǝn tǝ kandǝwa. ");
INSERT INTO bvw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Hanmunchǝkǝna ɓata le nat ficha tǝrandǝ sǝmat perǝkǝna thlǝmannda farinǝyu nanda cherǝ ama. ");
INSERT INTO bvw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nifǝsi na ɓumandǝ yuwa njela'a tǝ ɗohǝt njelaawa kǝthlem ma shiɗ kichu na ɗohǝt njelǝkǝna thlahtaɗi ka'ǝn. ");
INSERT INTO bvw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nifǝsi na thlǝr yuwa am innabi kǝ hur ɗohǝt kupat wa, kǝthlǝm nan fǝlta ɗi paɗ nu kuɓat i hurkǝnyu tǝ kupatkǝn nat. Kǝthlǝm ɗǝkǝn naku thlǝr yuwa am innabi kǝ hur yuwa kupata. ");
INSERT INTO bvw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Farǝyipta nak Yǝso ɓǝrtǝhi tǝ hur hitǝ hwarma, nak kimshechi'ena ɓwerǝt hwarǝm kǝnna mi. ");
INSERT INTO bvw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ndang Farisiyawechǝwa: \"Nu, kǝthlǝm mi nannda sǝt i ngǝmawuchit kustǝkǝn kǝ sǝficha farǝ yipta?\" ");
INSERT INTO bvw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ngǝmaǝn kandǝwa: \"Tamwuni changngandǝwowa, i sǝt Dauda yahkǝn ɗǝsǝmta kǝthlǝm mitafi'en, kandang tǝ nofchi'en fichile naka thlǝmatkǝnwa? ");
INSERT INTO bvw_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Yim kǝna kǝtǝn mwanandǝ Fara a thlahɓǝɗi nat Abiyata kǝ kapat Pǝrist, chiikǝn njohmi tahsandǝ fichihi kǝthlǝm kapat Pǝrist le kamuchiksi kǝ chii nifǝ somǝnwa, kapat Pǝrist ndak kamkǝsi kǝ chi'ǝn. Paɗ fǝrangna fichile naka thlǝmatkǝn yu. ");
INSERT INTO bvw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","\"Ndang Yǝso kandǝwa, sǝk fichǝ Farǝyipta Yahudawecha kǝthlǝm nifa, su fichǝ nifa kǝthlǝm Farǝyiptǝwa.\" ");
INSERT INTO bvw_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kǝthlǝm ndǝkǝn, Hweya Nifǝ mǝlan naka Lǝmwanda nat tǝ i Farǝyipta.\" ");
INSERT INTO bvw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Farǝ le yimkǝ Yǝso ɓǝt humta Yahudawechihi, nakǝn nifa le sat har'enaɗi. ");
INSERT INTO bvw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nak nofcha kǝlandǝ ndu na Yǝso kǝnandaɗaɗi farǝ yipta kǝthlǝm kǝ mbǝsndǝ i nannda tǝramiyafa ");
INSERT INTO bvw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ndang Yǝso le sat har'ennaɗiyuwa: \"Thla'u thlaru mbanitǝ nofcha.\" ");
INSERT INTO bvw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sahang Yǝso kanda: \"Mǝ mbutǝ kustǝkǝn kǝsǝficha Farǝ Yipta? kafatwa ndu ɓǝɓichitfatwa, kǝ hǝrkang fichǝ shisshingtǝwa ndu kǝ ɓǝlang fichǝwa?\" ngaskǝndǝ shetǝta. ");
INSERT INTO bvw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kǝlang Yǝso kandǝ tǝ sǝɓ hur ka'ǝn kǝthlǝm kwaakwaachit hanndǝkikechengnanda. Ndaǝnwa: \"pupwanan harekuhi.\" Pupwanaǝn hi kǝnkǝnaɗi. ");
INSERT INTO bvw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Chek Farisiyawecha tǝ wesha kǝ ɓǝnda nofcha Hiridus kǝthlǝm kǝ tahsangndǝ mbayihi nannda ɓǝlandǝ Yǝso. ");
INSERT INTO bvw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Thlaakǝ Yǝso tǝ kimshechi'en kǝmi hawurta, kurǝkǝ nofchǝ ndǝ oi thlata Galili nat tǝ nofcha Yahudiya, ");
INSERT INTO bvw_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","sǝkkǝndǝ ichi nat nanna sǝtta, yakat nofchǝ ka'ǝn ɓaknda mbǝɗ'en, thlata Urshelima, Edom tǝ hachahai Urdun taa kǝ Taya tǝ Sidon. ");
INSERT INTO bvw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kǝthlǝm rahanda njekthlǝ-njekthlǝchitta nofchihar, ndangna kimshechi'enwa ɗama kǝlam han kommbawal har ǝrta, kǝthlǝm terǝ nofcha mǝninda tǝkaharfa. ");
INSERT INTO bvw_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kǝnannɗǝ nofcha ɗaɗi oi, nat fa hafecha nangnda ɓahtǝ nduk kǝthlǝm kǝ mbunangndǝharfa. ");
INSERT INTO bvw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Chika kwat nat ɓǝɓi shemechikǝn ndi chat kopkǝndǝhi kanda kukwara ndangndǝwa: \"Sokǝn naka hweya Fara.\" ");
INSERT INTO bvw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tiiɗaǝn thlǝmechengnanda kǝ mbwa'anda nifǝ ndu wunnakǝnwa. ");
INSERT INTO bvw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tǝrkǝna ɗargwiya akǝn fichile yahtǝn ɓaknda ɓǝsndi ");
INSERT INTO bvw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Taɗkǝn nofchǝ kum ngǝrǝnsǝ chap akǝn kandǝwa kimshechi'en fichile na nat tǝndi, ɓahnan la thlǝnkanda kǝ ɗǝnda ɓasa. ");
INSERT INTO bvw_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Paɗ nuni mbǝs alchit chandǝ ɓǝɓi luwurcha kish. ");
INSERT INTO bvw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Fichile taɗtǝn kum ngǝrǝnsǝ chap yu, Saminu (le ɗǝfandǝnwa Bitrus), ");
INSERT INTO bvw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakubu hweya Zabadi tǝ Yohanna hwanmankǝn (le ɗǝfandǝn paɗwa Buwanarjis sakǝtkǝnwa hwecha ɓok era\"), ");
INSERT INTO bvw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andarawus, tǝ Saminu, tǝ Filibus, tǝ Bartamalawus, tǝ Matiyu, tǝ Toma, tǝ Yakubu hweya Halfa, tǝ Taddawus, tǝ Saminu lǝ Kan'anata. ");
INSERT INTO bvw_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Tǝ Yahuda Iskariyoti le hi'yang Yǝso ɗi. ");
INSERT INTO bvw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Chat pǝɗak Yǝso huri, ngǝrkǝ nofcha ngomtǝ oi, mǝlan tǝ kimshechi'en ɓǝsundǝ har sǝm ndǝsǝmtǝwa. ");
INSERT INTO bvw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kǝ sǝktǝ nofchi'en ɗǝknda kǝsanda kǝthlǝm nofcha ndatwa: \"Tǝraa luwurcha.\" ");
INSERT INTO bvw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Malɗǝmchǝ fa sakandǝ ɗelwercha Musa ɗi, fichile ɓaka a Urshelima ndangndǝwa: \"Kutur luwurchǝ naka fi'en paɗ tǝ alchita kutur luwurcha la rǝktǝn luwurcha kish.\" ");
INSERT INTO bvw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ak Yǝso kanda, shuwunkǝn tǝ kanda hur sakǝtkǝn, ndakǝnwa tǝkǝni nat sheɗanna ɓǝla kǝtandǝ sheɗanna kish? ");
INSERT INTO bvw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ma shek kuturichithi chap, kuturichitkǝn ngu soktǝwa. ");
INSERT INTO bvw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kichu paɗ ma shek huraahi chap hurǝkǝn ngu thlarǝwa. ");
INSERT INTO bvw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sheɗan ma thla'aɗa fat'enfa kǝssakǝnhi ngu ɓǝla thlarǝwa kǝthlǝm ndukwat'en ɓaka. ");
INSERT INTO bvw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kitchitkǝn nifǝsina ɓǝla yimta hura'a lǝ alchit kǝ herka'ǝnwa, manga tǝ kǝnaǝn lǝ alchitkǝnhi kana mbǝla herkandǝwa. ");
INSERT INTO bvw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Kitchikǝn tǝni mbwa'anda kuni nat ɓǝɓifechi sǝt nofcha na ficha kalandakandǝhi tǝ chika wun njirfat sǝtnda, ");
INSERT INTO bvw_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Chika tǝ kichu le njirkǝ Chiɗchiɗ tǝ Shemeɗa ngu ficha kalandǝhiwa nakna nat kǝla ɓǝɓichitfat kǝ pware. ");
INSERT INTO bvw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Mbukǝ Yǝso kichu kǝthlǝm lǝ ndangndǝwa: \"Ɓǝɓi shemeɗ'ensi.\" ");
INSERT INTO bvw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ɓak mankǝn tǝ hwanmanchikǝn thlarkǝnda kish, thlǝnkǝndǝwa kǝɓan. ");
INSERT INTO bvw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yakat nofchi tauranghiyu shuwunkǝndǝ tǝ ndi ndangndǝwa, yatu tǝ hwanmanchiwa kanda katsa kish yehndǝ sa natsa. ");
INSERT INTO bvw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ngǝmaǝn kandǝwa: \"Wun yaa tǝ hwanmanchina?\" ");
INSERT INTO bvw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tǝɓǝrkǝnhi tǝ ɓǝɗa fichile ɗas ɗas yu ndangnakandǝwa: \"Nam kandǝya fichileya naka nda yaa tǝ hwanmanchina\" ");
INSERT INTO bvw_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nat le sǝk i yahtǝ Fara mǝlan na hwanyaa tǝ yaa. ");
INSERT INTO bvw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Paɗ tǝrkaakǝ Yǝso sakandaɗa mi kapat hawurta ngomkǝ nofchǝ ka'ǝn, tǝrkǝna hur kommbawal sokkǝnhi kǝ hurkǝn, nofchǝ oi a mi chicheng hawurkǝn. ");
INSERT INTO bvw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nakna sakandakandǝhara a hur sakǝtkǝn tǝ ndatwa. ");
INSERT INTO bvw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Sǝkama! chek lǝ huɗata kish ka hǝfta ");
INSERT INTO bvw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nakna weshǝ witǝkǝn, funǝ witǝkǝn hǝmkǝnda hai kǝ hur mbanda, ɓak hanɗishcha chathlanda. ");
INSERT INTO bvw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Funǝ witǝkǝn paɗ hǝhatkǝnnda ɗar fufurta ɓǝɗi nguchit furtǝsǝ ɗiichin, tifkǝnda kish leɗleɗ, kǝthlǝm ngafurtǝsa ɗarkǝn ɗiichinwa, ");
INSERT INTO bvw_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tǝkkǝ hwatfarǝhi, lifirkǝndaɗi kǝthlǝm nga thlorǝ'ensǝ ɗiichinwa, hwarkǝnaɗi. ");
INSERT INTO bvw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Paɗ funǝ hǝhatkǝnda hur ndahcha, mwankǝnda paɗ njekthlang ndahchiyu ɓǝla'utǝ sǝt hwechafuwa. ");
INSERT INTO bvw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Funǝ paɗ hǝhatkǝndahai kǝ hachahai ɗiichin mbulkǝn sǝkǝn hwechafa, funǝ kumchit mǝkkan, funǝ kumchit tehhweth, funǝ paɗ kumchit kum. ");
INSERT INTO bvw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ndak Yǝso wa: \"Le nat thlǝmat sǝktǝ'ensi kǝ sǝkkǝn.\" ");
INSERT INTO bvw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nak Yǝso ichitkǝn, fichile nduk tǝndǝ tǝ kimshechi'en kumngǝrǝnsǝ chap, sahahndǝ sakǝt shuniniyu. ");
INSERT INTO bvw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ndangnakandǝwa: \"kunang ngǝmaficha kunisi kǝ sǝnnuni i naka ɓuɓweeta hur mwanda Fara, fichile nguchika hurnuni, chikamǝ naki mbwa'anda kanda hur sakǝtkǝn. ");
INSERT INTO bvw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nanda kǝllathi kǝ kǝllathi chika kichu ngunda natwa, kǝ kandǝ thlǝmathi kǝ kat thlǝmathi chika kichu ngunda sǝktǝwa. Kǝthlǝm ma shiɗndǝ kichu nanda tǝɓǝrtǝhi ɓǝnda Fara kǝ kalang fichi ɓǝɓichitfechengnanda kandǝhi. ");
INSERT INTO bvw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ndangnakandǝwa, awi sǝnwuni sakǝt shuniniyuwa? Nakuni sǝn yakat sakchikǝnwa kǝnni? ");
INSERT INTO bvw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Lǝ huɗaɗiyu hiftǝ shunda Fara. ");
INSERT INTO bvw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Fichile hǝhatkahai kǝ hur mbandǝyu, kandang naka sakǝt fichile hǝftǝ fichǝ shuwunkǝna hanndǝkikechengnandǝyu, kǝ sǝktǝnda chat kichuyu ɓak sheɗanna thlandǝ kandǝhar. ");
INSERT INTO bvw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kichu paɗ hanwitǝ hǝftǝ ficha hur fufurtǝyu, kandang naka fichile sǝkkǝ shuwunkǝn thlǝkndǝ tǝ mbǝnfata. ");
INSERT INTO bvw_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","A nakǝn sutǝ thlora hanndǝkikechengnanduwa, nga alchindengnandǝsuwa, ma yimnda hur ɓahtǝ kǝthlǝm shuniniyu chikndǝ hansarǝhi. ");
INSERT INTO bvw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Funǝ paɗ kandang naka sakǝt fichile hǝhatka hur ndahchiyu, kandang sǝkkǝ shuwunkǝn, ");
INSERT INTO bvw_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","paɗ ǝnat kishita tǝ kǝnecha tǝ yah icha kishita, yimkǝndǝsi njaǝn shuwunkǝnna kanda suwa kweshchaǝnwa. ");
INSERT INTO bvw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Fichile hǝhtǝ ficha hur furtǝ ɗiichinyu kandang naka sakǝt fichile sǝkkǝ shuwunkǝn thlǝknda, sǝkndǝ torsi mbǝskǝndǝ chekǝtkǝn, funǝ kumchit mǝkkan, funǝ kumchit tehhweth, funǝ kumchitkum. ");
INSERT INTO bvw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ɗǝk Yǝso mban tǝ ndanda kanduwa: \"Mǝlapakaa la ɓak fichǝ tǝ tikesha huri kǝthlǝm kǝ supwang fichǝ tǝ i'naftǝwa, manga kichuwa kǝ ɗǝffichǝhi kǝka ɓǝt hunatwa? le ɓatunitǝkǝn kǝthlǝm kǝ ɗǝffuni kǝ ɓǝɗi la ɗǝftǝfichǝwa? ");
INSERT INTO bvw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ənsǝnaka ɓuɓweetǝ nguchit ficha chandakishwa, ǝnsa supta nguchit ficha kwallandandǝwa. ");
INSERT INTO bvw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Le nat thlǝmat sǝktǝensi kǝ sǝkkǝn!'' ");
INSERT INTO bvw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Paɗ ndangna kandǝwa, ɗǝffam i'ndǝsi, kǝ ɗar ǝnǝnǝ sǝktuniyu, somǝɗi kǝkaɗtusi, tǝ ndǝkǝn nat ficha kǝkaɗutǝsi. ");
INSERT INTO bvw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kǝthlǝm le natǝn'ensi, mǝlan nat ficha chekanda, le nguchitǝn'ensi paɗ chikale naka har'en na ficha thlandǝhar kǝ chekang ficha le natǝnsǝ'en. ");
INSERT INTO bvw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ndakǝn paɗwa: \"Mwanda Fara nakǝn nda nifǝ weshkǝ witǝ'enna hachahaya. ");
INSERT INTO bvw_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kǝ hunanhi kǝ thlaǝn tifkǝ witǝkǝnna kish, mwankǝn, sǝnutǝ ndu sǝkǝn kǝniwa. ");
INSERT INTO bvw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Furtǝ tǝ i'ndǝ'en la ɓǝlaakǝn mwanandǝ hwarma paɗ kǝ ɓulǝn, sǝn hwechafa. ");
INSERT INTO bvw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ma nihiɗi hwasaǝn tǝ chelta, kǝthlǝm shee thlahɓǝt nǝhatǝ'en.\" ");
INSERT INTO bvw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ndakǝn paɗwa, nakma kǝkaɗandǝ mwanda Farǝ tǝ mi? Manga kichuwa witǝ sakǝtmi natma kǝkaɗandǝfa? ");
INSERT INTO bvw_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nakǝn nda hwan musdad, le nak nguɗeh a hur ichi la hǝftǝficha hachahaya. ");
INSERT INTO bvw_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Chika tǝ kichu ma hǝffa ficha, nan mwanda kǝ mbǝranka tahǝt afchihi hur hitǝkǝnyu, njarkǝnhi ka'ǝn paɗ kana hanɗishcha sokta kaaftǝ'en. ");
INSERT INTO bvw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Tǝ sakǝt shuwunchǝ ka'ǝn mbutǝ Yǝso shunda Fara, kǝ sǝrǝt sǝndengnanda. ");
INSERT INTO bvw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mbwa'autǝ shunda kanda nga tǝ sakǝtkǝnwowa, paɗ mamǝlan ichitkǝn, la mbwa'angna kimshechi'en chikami. ");
INSERT INTO bvw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Farǝniyu sǝk farǝhufta, ndangna kimshechi'enwa: \"Chamǝn hawurkǝn kǝ mi chicheng le taatǝyu.\" ");
INSERT INTO bvw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Malkǝndǝ ngomnofchikǝn ɗiffi'in, pǝɗakndǝ tǝnda hur kommbawal ichitkǝn, paɗ kurǝkǝ tahchikǝn kanda. ");
INSERT INTO bvw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ndǝkǝn thlatǝ husomba tǝrǝnna ka'ǝn, nak rǝnnikǝna hǝhrandǝ kommbawal tǝkǝn, nak ama hasa hur kommbawal tǝkǝn nda nan nǝhata. ");
INSERT INTO bvw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yǝso paɗ mǝla hur kommbawal tǝkǝn a ɗar ɓǝt sokta mǝla saɓweni, nahnang kimshechi'en ndangndǝwa: \"Malɗǝm, nǝma tǝktǝhi, kǝmmuwowa?\" ");
INSERT INTO bvw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nahǝnkǝn, ɓokangna rǝnnikǝnhi, ndangna rah amkǝnwa: \"Thlarruhi! kǝ ngasnǝ kǝmma!\" Ndǝkǝn thlartǝ rǝnnikǝnhi shǝyyet. ");
INSERT INTO bvw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ndangna kimshchi'enwa: \"Kǝthlǝm mǝ lechituni kakǝchiuyu? Paa kǝnakǝnya ngafǝrkit engnunisǝwowa? ");
INSERT INTO bvw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Lechitndaɗǝ kaka'ǝn, ndangndandaniwa: \"Witǝ nifǝmǝkicheya, rǝnna'a tǝ ama kanda fǝra mwanda? ");
INSERT INTO bvw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kǝ chandǝndǝ suhwaɗa kǝ hachahai Garasinawecha. ");
INSERT INTO bvw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kǝ tǝrtǝ Yǝso haya hur kommbawal, thlaakǝ nifa le nak tǝ ɓǝɓi shemeɗa, mbǝt shok tǝ'en mbǝt thlohmurcha ɓakna mbǝɗa Yǝso. ");
INSERT INTO bvw_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nifǝkǝn kwatmurcha naka mbǝt shoktǝ'en, nifǝsi la mbǝllakkǝ kǝnnanduwa chika tǝ chalalochiwa. ");
INSERT INTO bvw_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kǝthlǝm kurɓafichǝ kǝnnandǝ harchi'en tǝ sarǝchi'en tǝ chalalocha, nat tǝkichu ɗǝɗahaǝn chalalo tǝkkǝnnaɗa sarǝ'en. Nga nifǝsi tǝ alchitafa la mbǝlakkǝ kǝssandǝhiwa ");
INSERT INTO bvw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nda fiɗikta tǝ fara la nakna kwat murchǝ tǝ ɗar shohlacha kǝnna nata tit ka'ǝn, paɗ kǝnna ɓursa ndǝ fat'enaɗi tǝ ngwicha. ");
INSERT INTO bvw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kǝ natǝn Yǝso langnga, paakǝnsi tǝ rahta ɗǝkna hǝmta mbanitǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Hwakǝn tǝ alchit tǝ kapat ɓurata ndakǝnwa: \"Mǝ natu sǝtsa nji, Yǝso hweya Fara le nak mwanchin? A humuɗi tǝ Fara, mǝ fǝrinǝ pwanchiuwa. ");
INSERT INTO bvw_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Mbukǝn kichu kǝthlǝm nda Yǝso wa: \"Chukisshafata nifiya sokǝn ɓǝɓi shemeɗa.\" ");
INSERT INTO bvw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ndǝkǝn sahandǝ Yǝso wa: \"Thlǝmmuwa kǝni?\" A ngǝmmanwa: \"Thlǝmnǝwa terchin, kǝthlǝm nakani oi.\" ");
INSERT INTO bvw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","A hwanaǝn Yǝso tǝ ndatwa: \"Mǝ rǝkinǝ kanda mbǝnniyuwa.\" ");
INSERT INTO bvw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kǝthlǝm mbǝnniyu kapat chaɓa katuchisi naka hǝrimtǝ nduk tǝ shohlata. ");
INSERT INTO bvw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ɓǝɓi shemechiyu hwanangnduwa: \"Kǝ malaǝn kanda kǝ yimnda hur katuchiyu.\" ");
INSERT INTO bvw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","A ngǝmmang na kandǝsi. Thlaakǝ ɓǝɓi shemechiyu chekndakish, yimkǝnnda hur katuchiyu, katuchiyu shee ndǝ aru kumchit chap (2,000), a rah kǝnda ka hǝhhatta hur hawurta, tǝkkǝndǝhi nat ahur ama. ");
INSERT INTO bvw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kǝ nat fa hǝrǝm katuchiyu kichu, rah kǝnda ka mbuta hǝmta, tǝ han hǝmchikǝn chek nofchakish ka nat i sǝkka. ");
INSERT INTO bvw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kǝ ɓatnda thlǝmmat Yǝso, nak ndǝ nifi nak soh tǝ ɓǝɓi shemecha fǝyu, ɗas tǝ njelecha fa mǝlla hur iɗi'en thlaakǝnnda lechik nda. ");
INSERT INTO bvw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Fichile sǝt fichi ǝnnat kǝnna hwaniteng na ndǝyu, ndǝkǝn chekandǝndǝ ɗwaachik kǝnna kanda, i kǝs kǝ lǝ ɓǝɓi shemeɗiyu tǝ katuchiyu. ");
INSERT INTO bvw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Thlaakǝ nofchikǝn hwanang ndǝ Yǝso kǝ mallǝn thlet hǝmteng nandǝ hi. ");
INSERT INTO bvw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kǝ nat Yǝso yimta kommbawal, nifi soh nak tǝ ɓǝɓi shemeɗi fiiyu hwanaǝn Yǝso wa nan ɗǝtkakǝn. ");
INSERT INTO bvw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nat tǝ kichu Yǝso ngǝmmawusuwa, ndaǝnwa ɗu huri kǝ mbǝɗa fahchuwa, kǝ mbwa'angna kanda witǝ pǝktat ichi sutǝ Lǝmwanda tǝ haɗi haɗandufa. ");
INSERT INTO bvw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Thlaakǝ nifiyu pǝɗakǝn ɗǝk na nata mbu i sandǝ ficha Dikafolis sakkǝtkǝn hǝmchǝ kum witǝ pǝktat i chi sandǝ Yǝso. Uf nofcha pǝɗang ǝnnatkǝn kandǝ fa. ");
INSERT INTO bvw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yim kǝ Yǝso hur kommbawal chaǝn kǝ mi chicheng le, ɓak nofchi oiya kǝtwurangndǝhi mǝllan paɗ mǝlla mi chicheng hawurkǝn. ");
INSERT INTO bvw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yunǝsǝ ǝrta naka kapat nifa a mbǝt humta Yahudawechihi, thlǝmkǝn wa Yayirus. Kǝ natǝn Yǝso himkǝnhi mbanitǝkǝn, ");
INSERT INTO bvw_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","nakna hwanandǝ ka'ǝn tǝ ndatwa: \"Hwe'engna le nak nguɗeh, kǝ nuhhweya mǝlla miya murta, nja hwanuta tama kǝ ɗǝnna tǝkaharfa kǝthlǝm kǝ kǝnkaɗi.\" ");
INSERT INTO bvw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Pǝɗak Yǝso tǝndi, kuwurkǝ nofchi kandǝ oi nangnda njekkathlǝndi. ");
INSERT INTO bvw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nuhnifǝssa mbǝnniyu hurak kum ngǝrǝnsǝ chap tǝ hafat thlǝrfwara fa. ");
INSERT INTO bvw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","A sheetǝ pwanchǝ oi a hara fafǝr hamɓǝɓecha, tuɓwaɗǝ i nak sǝ'en nat, chika tǝ kichu mbǝsutǝ sǝmmǝchitwa hafatkǝn nakǝn kǝmban kǝmban. ");
INSERT INTO bvw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kǝ sǝktǝn kussheng Yǝso, ɗǝkǝn tǝ ɗifitǝkǝn tǝ hur terǝ nofchiyu tǝka'ǝn hara njela'enfa. ");
INSERT INTO bvw_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nak na yarǝwa: \"Matǝkaɗi hara njela'enfa ni kǝndaɗi\" ");
INSERT INTO bvw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Chatkichuyu thlarkǝ thlǝrfwarkǝn hi, sǝkkǝnsa fat'enwa kinaɗi. ");
INSERT INTO bvw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Chatkichuyu sǝkkǝ Yǝso cheɗ alchǝta kishsha fat'en, tǝɓɓǝrkǝn hi hur terǝ nofcha ndakǝnwa: \"Wun tǝkang hara njele'engnǝ fa?\" ");
INSERT INTO bvw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ngǝmang kimshechi'en wa: \"Sa nat nofchǝ njekthlǝnjekthla, kanna ndatwa, wun tǝkukǝ harfa?\" ");
INSERT INTO bvw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kǝlak Yǝso hi kǝthlǝm kǝ nan ndu wun tǝkang harfa. ");
INSERT INTO bvw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nuhiyu kǝ sǝntǝn i sǝka fat'en lechikǝn, ɓakna mbǝsndi kopkǝnhi mbwaǝn nat kitchit i'sǝka. ");
INSERT INTO bvw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ndaǝnwa: \"Hwe'engna, fǝrkitchiɗeku kǝnuɗaɗi. Pǝɗu ngwalngwal, kinhafaɗekuɗi.\" ");
INSERT INTO bvw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mǝlla ɗar shunda chat ɓak funa mbǝɗa Yayirus kapat nifa ndangnduwa: \"Hwe'eku teppa miri! mǝ sǝk natu ɓahandǝ Malɗǝm paɗi?\" ");
INSERT INTO bvw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nattǝ kicchu Yǝso ɗufutǝ i'nda i nannda mbutuwa, ndangna kapat nifǝkǝnwa: \"Mǝlechinuwa, so kǝn fǝru kit ndak.\" ");
INSERT INTO bvw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Malautǝ, chikka wun kǝ kurǝn ndǝwa tǝrkǝn Bitrus tǝ Yakubu tǝ Yohanna hwamman Yakubu. ");
INSERT INTO bvw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kǝ saatǝnda hura'a Yayirus kapat nifa, nak Yǝso nofcha kanda tita funa hwata. ");
INSERT INTO bvw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yimkǝnna hurikǝn, ndangnakandǝwa: \"Kǝthlǝm mǝ natuni tita kǝ nuni nata hwata? Nuhhwaniya mǝruwa, tǝnakasaɓweni.\" ");
INSERT INTO bvw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nangnda masanda masǝ njirfata. Chaǝn nofchi kisha hurikǝn nat, akǝn shin hwankǝn tǝ mankǝn, tǝ kimshechi'en fichile naka thlǝmmatkǝn, yimkǝnnda mbǝɗi nat nuhhwaniyu. ");
INSERT INTO bvw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kǝskǝn har'en ndaǝnwa: \"Talita kumi.\" (sakǝtkǝnwa: \"Hannuhhweya, ndakiwa thla'u\"). ");
INSERT INTO bvw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Chat kichuyu thlaakǝ nuhhwaniyu nakna witahi. (hurat'en kumngǝrǝnsǝ chap). Nofchi naka mbǝnniyu pǝɗang ǝnatkǝnkandǝfa. ");
INSERT INTO bvw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kahang Yǝso thlǝmmachengnandǝ tǝ ndatwa mǝ sǝni nifǝ isǝkyawa, fǝramǝn ɗǝsǝmtǝ kǝ sǝmǝn. ");
INSERT INTO bvw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Malkǝ Yǝso mbǝnnihiyu ngǝraǝn inna hǝmtǝ'en, kimshechi'en paɗ kuwurkǝndǝndi. ");
INSERT INTO bvw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kǝ saatǝ farǝ yipta, tǝrkaakǝn sakandaɗa mbǝt humta Yahudawechihi. Nofchǝ oi naka kathlǝmmata, paɗ pǝɗang ǝnnatkǝn kandǝfa nakndandatwa: \"A'ai mbǝstǝ nifiya witǝ ichiya? witǝ sǝnmǝ fǝra ndǝ fichǝ kicheya? ɓatna nata sǝt ǝnat sheka i'nniya? ");
INSERT INTO bvw_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Leya nga mǝllan naka lǝ kukwat ichiyuwa, hweya Maryamu hwamman nda Yakubu, tǝ Yusufu, tǝ Yahuda, tǝ Siman? Hwamman chikǝn kǝ nishcha nga kandang ni thlǝmmat nǝm yawowa?\" Cherkǝndǝndǝfa. ");
INSERT INTO bvw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ndang Yǝso kandǝwa: \"Tapǝna'a ɓahutǝ mwanduwa manga himtǝ'en tǝ hur hwammanchikǝn, tǝ hur hura'enwa.\" ");
INSERT INTO bvw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yǝso mbǝla'u tǝ sǝt tor ǝnnat fǝr sheka i'nda mbǝnniyuwa, kǝnaǝnfunaɗi ɗimek hur fichile nak hahchin tǝ ɗǝffa hara kanda in. ");
INSERT INTO bvw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Pǝɗang ǝnatkǝnfa tǝ ɓah fǝr kitchǝɗengnanda. A wu'yaǝn han hǝmcha, nakna sakanda kandǝ har. ");
INSERT INTO bvw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Akǝn kimshechi'en kumngǝrǝnsǝ chap, thlinkǝn kanndǝ chap chap, a fǝraǝn alchita kanda i rǝk ɓǝɓi shemecha. ");
INSERT INTO bvw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ɓokang na kandǝwa makunna pǝɗata mǝtǝriɗuni ǝn inwa, chika ɗǝsǝmta, chika yokta, chika ɗǝngla, chika hanɗǝɓǝlta kǝ hur kwandangchengnuniwa, sǝssal ndak natuni tǝrta. ");
INSERT INTO bvw_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tǝ paɗ kǝ puni pahamcha, mǝ hummaɗuni njelaa chapwa. ");
INSERT INTO bvw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ndangna kandǝ paɗwa: \"Uf huri'i yimtunisi, kǝ sokkuni mbǝnniyu kǝ farinatuni thlata. ");
INSERT INTO bvw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Uf mbǝɗi cher tǝ ndǝ kuni paɗ kawundǝ thlǝmmata kuniwa, manuni pǝɗata, kǝ tǝppanguni tǝnnayiɗa sarǝchengnuni kǝthlǝm kǝ sokka ǝnnat sinnda ɗar inndengnanda.\" ");
INSERT INTO bvw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Pǝɗangda nataɓasanda nofchisi tǝ ndatwa kǝtǝrndǝhi kǝ malangndǝ ɓǝɓichitfechengnanda. ");
INSERT INTO bvw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","A chang ndǝ ɓǝɓi shemechakish oi, pa'angndǝ fiɗɗetafichile nak hahchin oi kǝnkǝnndaɗi. ");
INSERT INTO bvw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Hiridus kutura sǝkkǝn kusheng shuwun Yǝso kǝthlǝm fen thlǝmkǝnhi chika tǝteni funa ndatwa: \"Yohanna lǝsǝt Baptisma thla'a ndǝ ficha hur mǝmatcha, ndǝkǝn sǝk natǝn tǝ alchit sǝt ǝnnat fǝr sheka i'nda.\" ");
INSERT INTO bvw_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ndakfunuwa: \"Iliya tapǝna'a\" funǝ paɗ ndakndǝwa, \"Nda ǝrta hur tapǝnechi sohyu.\" ");
INSERT INTO bvw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kǝ sǝktǝ Hiridus shuwunkǝn, ndakǝnwa, Yohanna nǝyu, le thlendi i'ndǝ ennaɗi thlaaka hur mǝmatcha.\" ");
INSERT INTO bvw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kǝthlǝm Hiridus tǝ i'ndǝ'en mbukǝ tǝ ndatwa kǝ kǝssang fichǝ Yohanna, kǝ kǝnnang ficha kǝ ɗǝndǝ tǝnda pursuna. Sǝk Hiridus kichu kǝthlǝm Hirudiya, Nuh Filibus hwanmankǝn kahandǝn. ");
INSERT INTO bvw_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kǝthlǝm Yohanna lǝnakna mbwa'anda Hiridus wa, \"Ngǝmawu kus kǝ kahangnǝ nuh hwanyatuwa\". ");
INSERT INTO bvw_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Awi Hirudiya mǝlla kǝs kommbǝl Yohanna a hur hanɗǝkiketǝ'en, a yahkǝn kǝ ɓǝllaǝn. Nat tǝkichu mbǝsutǝ mbandǝwa, ");
INSERT INTO bvw_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kǝthlǝm Hiridus lechaɗa Yohanna, A shinwa mǝllan ka nifǝnakǝn, a shin tǝ ndatwa nakǝn chiɗchiɗ, lǝ ɗwachit paɗ, ndǝkǝn sǝk Hiridus kǝstǝn Yohanna har ndiichin, lǝ shekɗang i'nda ma mǝlla sǝk Yohanna mǝlla shundǝ tǝndi, nat tǝkichu lǝ nakna mbǝnandǝfa ma mǝlla sǝk shundǝ'en. ");
INSERT INTO bvw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","A mweshitkǝn ɓak Hirudiya mbǝs mbanda. A farǝ mbǝnfat thlahmbǝt ngǝtta Hiridus, akǝn pǝktat nofcha, funa ngomnati, funa hurfathlǝrhwata, tǝ pǝktat nofchi Galili. ");
INSERT INTO bvw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kǝ yimtǝ hweya Hirudiyasi kǝ nuhhweya, rǝmkǝn mbǝnang na Hiridus fa tǝ tahǝt romchi naksi. Ndang kutura nuhhwaniyuwa: \"Hwanitǝn i yahtu, ni furuta.\" ");
INSERT INTO bvw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Akǝn ichimi tǝ ndatwa, hwanitin i yahtu nifuruta chika mbuth kuturichiɗengna. ");
INSERT INTO bvw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Thlaakǝ nuhhwaniyu cheknakish kambǝs mankǝn mbwa'ǝn tǝ ndatwa: \"Mǝnati hwanada\" Ngǝmmang mankǝnwa i'nda Yohanna lǝ sǝt Baptisma. ");
INSERT INTO bvw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Chatkichuyu ngǝraǝn inna mbǝnda kutura tǝ wesha hwanan tǝ ndatwa, yahkǝsi nakǝn nakǝnya kǝ fǝrikǝnnǝ i'nda Yohanna lǝ sǝt Baptisma a hur tǝpɓi. ");
INSERT INTO bvw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Sǝɓkǝ hanndǝkiketa kuturaɗǝ ka'ǝn. Paɗ ngu mbǝlla cherǝfuwa kǝthlǝm teppa eɗtǝ ichimi mbanitǝ nofcha, kǝthlǝm ngu mbǝlla talandǝ i mbutǝnwa. ");
INSERT INTO bvw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chatkichuyu thlǝnkǝn yuna hur fapundǝ har ndaǝnwa, kǝ ɗa ɓattǝ i'nda Yohanna, pǝɗak nifiyu kǝ pursunatǝkǝn ɗǝkna thlandǝ i'nda Yohanna, ");
INSERT INTO bvw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ɓakǝn tǝ inkǝnna hur tǝpɓi fǝrangna nuhhwaniyu, thlǝk nuhhwaniyu fǝrangna mankǝn. ");
INSERT INTO bvw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kǝ sǝktǝ kimshecha Yohanna kichuyu, pǝɗaknda tǝr fatkǝn ɗǝknda thlohanda. ");
INSERT INTO bvw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kǝ ɓat fathlǝncha Yǝso ɗi ngomkǝndǝhi mbwa'ang ndǝ i sǝtndǝ uf, tǝ i sakandǝndaɗi. ");
INSERT INTO bvw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nak nofchǝ oiya ɓata funa pǝɗata, Yǝso tǝ fathlǝnchi'en mbǝsundǝ har sǝmɗǝsǝmtuwa. Ndǝkǝn ndandǝnna kanndǝwa tama katmbǝt har nguɗuk, kǝthlǝm kǝ yipuni. ");
INSERT INTO bvw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Pǝɗaknda hur kommbawal kǝ mbǝt nguɗuk ichitnanda. ");
INSERT INTO bvw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Awi neɗ nofchǝ kandǝ oi kanda pǝɗata, paɗ shinndǝ kanda, rahkǝnda tǝ sarǝcha a hur thlet hǝmchikǝn laknda mbǝɗi natnda ɗǝta. ");
INSERT INTO bvw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Cheta Yǝso kissha hur kommbawaltǝkǝn, nakǝn nofchǝ oi haɗangndǝfa, kǝthlǝm nakndǝ nda shohrecha le nguchit lǝ hǝrǝmtǝsi. A tǝrkaakǝn saka ichakandǝhar oi. ");
INSERT INTO bvw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nak mbǝta hulta ɓak kimshechi'ena mbǝsndi, ndangndǝwa: \"Mbǝɗi natǝmya nguɗuk nifǝsǝwa, tǝpaɗ mbǝta hulta. ");
INSERT INTO bvw_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ndandǝna nofchiyawa kǝpǝɗanda kǝ kahǝmcha tǝthlet hǝmchi ndukndukya kǝɗǝnda hi i nanndasǝmta.\" ");
INSERT INTO bvw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Paɗ ngǝmmang Yǝso tǝ ndatwa: \"Kunang fǝramǝn ɗǝsǝmta kanndǝ kǝ sǝmnda.\" Ndǝkǝn ndandǝndǝwa, kǝ ɗani hi njohma i dinari aruchap kǝ fǝrangani kandǝ kǝ chiindǝwa? ");
INSERT INTO bvw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ndangna kandǝwa, njohmǝ kurmi naksengnuni? ɗama kǝllamǝn ɗǝknda kǝllanda ndangndǝwa, njohmǝ ɗurman tǝ tinchǝ chap. ");
INSERT INTO bvw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ndang Yǝso kimshechi'enwa kǝ ndangnda nofchiyuwa kǝ sokndǝhi tǝnglǝng-tǝnglǝng kǝ ɗar nduhwelecha. ");
INSERT INTO bvw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","A sokkǝndǝhi tǝnglǝng-tǝnglǝng, funǝ kumchit kum, funǝ paɗ kumchit ɗurman. ");
INSERT INTO bvw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tǝrkǝn njohǝmchi ɗurmanyu tǝ tinchi chap yu, kǝlangna afshi saǝn usoko Fara, saka'ǝnhi fǝrang na kimsechi'en, kǝ sakangnda nofcha. Sǝkǝn kichu tǝ tinchikǝn paɗ. ");
INSERT INTO bvw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Uf nda sǝmkǝnnda ngalkǝnnda. ");
INSERT INTO bvw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ngomang kimshechi'en fishirchikǝn nihǝɗ inaftǝ kumngǝrǝnsǝ chap, ");
INSERT INTO bvw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Terǝ nofchi sǝmkǝ ɗǝsǝmkǝn, hishchǝ, sheendǝ aru kumchit kum ɗurman (5,000). ");
INSERT INTO bvw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Chatkichuyu ndang Yǝso kimsechi'en wa, kǝ yimnda hur kommbawal, kǝ landǝ cheta kǝ Betsaida, mǝlan paɗ kalkǝn terǝ nofchihiyu. ");
INSERT INTO bvw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ɗiffitǝ kalǝ nofchihi tǝrkǝna ɗar shohlata kǝthlǝm kǝ hwanǝn. ");
INSERT INTO bvw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Sǝk farǝ hufta, kommbawal tiyu a hur ɗiffiti hawurta, Yǝso paɗ mǝlla hachahai i'chitkǝn. ");
INSERT INTO bvw_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kǝ natin kimshechi'ena ɓahtǝhi tǝ koharǝkǝn, kǝthlǝm rǝnna'a ɓahandǝ kanda, keeke tǝ kukwara ɗekta katǝtɓǝta, mǝlla ɓata mbǝskandǝ tǝ wita ɗar hawurkǝn. Yarkǝnwa na lata mban. ");
INSERT INTO bvw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kǝ natndǝndi mǝlla wita ɗar ama, naknda muh hanhara naǝn kandǝhiwa ɗǝhanifa. ");
INSERT INTO bvw_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kǝthlǝm ufnda neɗndǝndi, lechiknda, chatkichuyu \"Shunaǝn kandǝ tǝ ndatwa ǝnsuwa, njeta, mǝ lechiɗuniwa.\" ");
INSERT INTO bvw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Mbǝnniyu yimkǝna kommbawal tǝ kanda, chatkichuyu thlarkǝ rǝnnikǝnhi. Shekɗang i'ndǝkandǝ ka'ǝn. ");
INSERT INTO bvw_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kǝthlǝm sunundǝ sakǝt sǝma'ǝn nofchi aru kumchit ɗurmanyu tǝ njohmǝwa, kǝthlǝm kwaakwaachit hanɗǝkikechengnanda. ");
INSERT INTO bvw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kǝ chandǝndǝ hawurkǝn kǝ kishitǝle, tǝrkǝnda haya a thlet hǝmǝt Jenisarat, kǝnangndǝ kommbawal tǝkǝnhi kǝmi chichengkǝn. ");
INSERT INTO bvw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kǝchet nda kisha hur kommbawal mbǝssang nofchuwa mǝllan. ");
INSERT INTO bvw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Rahkǝnda hur hǝmchikǝn, naknda ɓat tǝ fichile nak haachin a ɗar mbǝt hunechengnanda kǝ mbǝɗi sǝktǝndǝwa mǝlla mbǝnniyu. ");
INSERT INTO bvw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Nat mbǝɗi yimtǝn, thlet hwan hǝmchǝ tǝ hǝmcha, la naknda ɗǝt tǝ haachǝ kǝmbǝɗ'en paɗ tǝmi lumocha, a lanaknda hwananda kǝthlǝm kǝ tǝkangndǝ hara chika mi njela'enfa, nat le tǝkang harfa kǝnkǝnaɗi. ");
INSERT INTO bvw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisawecha tǝ malɗǝmcha fichile la sakang kussa ɗi ɓaka Urshelima, ngomkǝnda thlǝmat Yǝso. ");
INSERT INTO bvw_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","A mbǝssangndǝ tǝ ndatwa kimshechi'en kanda sǝmɗǝsǝmtǝ tǝ tǝkǝmharcha sapawundǝwa. ");
INSERT INTO bvw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Kǝthlǝm Farisawecha tǝ tahǝt Yahudawecha sǝmundǝ ɗǝsǝmtǝ kichu sapundǝ harwa, kǝthlǝm tor murta pǝktechengnanda nakǝn kichu. ");
INSERT INTO bvw_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ma ɓennda ɗa lumo, manga tǝ fanndǝ nda i mbutǝ tor murtengnandǝwa ngunda sǝmɗǝsǝmtǝwa. Tor murtengnandǝsi paɗ lela kuwur tǝnda, nda sap tǝpsat 'amcha, tǝ ɓicha, tǝ kuppecha tǝ kǝtǝn sǝm'ǝna.) ");
INSERT INTO bvw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kǝthlǝm ndǝkǝn sahang Farisawecha tǝ pǝktat malɗǝmcha fasakandǝ shuwun kussa Musaɗi: \"Kǝthlǝm mi kimsecheku yahundǝ kuwur tor murcha pǝktechengnaniwa, mashiɗ kǝnnanda sǝmɗǝsǝmta tǝ tǝkǝmharcha?\" ");
INSERT INTO bvw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","A ngǝmang Yǝso tǝ ndatwa: \"Kohat nofcha keekesi fǝrtǝ Ishaya sakǝtkǝn kǝ ɗarnuni, nda i yarandǝ ficha. Nofchiya a mi ɗeng nannda mwanita, paɗ hanɗǝkikechengnanda nakǝn langnga tǝ nji. ");
INSERT INTO bvw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Poffǝn lǝnannda mwanandǝ thlǝmna, kussi ti la natnda sakandaɗi, i nofchǝ ɗeng, ɗar ndatwa shunda Fara. ");
INSERT INTO bvw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Lamallanguni i ndat Faruwa kǝ suni, nakuni kuwur tor murta nofcha.\" ");
INSERT INTO bvw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ndangnakandǝwa: \"Awi nuni mbǝllamalandǝ kussi Fara kǝthlǝm kǝ kuruni tor murchengnuni! ");
INSERT INTO bvw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kǝthlǝm ndak Musa wa, 'fǝran mwanda suka tǝ yatu paɗ le erkǝ shinkǝn tǝ mankǝn keekesi kǝ ɓǝllang ficha.' ");
INSERT INTO bvw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Paɗ landakuniwa: ''Nat i nat shinchinuni tǝ manchinuni ɓǝsta mbǝɗa nifǝ soh sokkǝn nda korban\" (sakǝtkǝnwa fǝrraɗi Fara). ");
INSERT INTO bvw_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","kǝthlǝm ndǝkǝn mwawuni mallandǝ kǝ kǝssaǝn tora shinkǝnsi tǝ mankǝn wa. ");
INSERT INTO bvw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tǝkichu la natuni, cherǝ pathla Fara, tǝ pathlǝ kuwur tormurchengnuni, paɗ la nakuni ɗahhanda witǝ ichiniyu in. ");
INSERT INTO bvw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ngǝrkǝ Yǝso at nofcha mbǝɗ'en, ndangnakandǝwa kami thlǝmmat uffuni, paɗ kǝsununisi ndiichin. ");
INSERT INTO bvw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nga i lasǝmtǝ nifa hur na tǝkmandǝhiwa, i la cheka hur handǝkiketǝ la tǝkmang nifǝhi. ");
INSERT INTO bvw_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Uf le nat thlǝmmatsǝktǝ'ensi kǝ sǝkkǝn. ");
INSERT INTO bvw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kǝ saktǝnhi tǝ nofchi oiyu yimkǝnna huri, sahang kimsechi'en sakǝt i'sakandǝnaɗiyu. ");
INSERT INTO bvw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ndangnakandǝwa: \"Awi kunang paɗ sǝnwuni sakǝtkǝn tǝ ndatwa i sǝmtǝ nifa hur, ɓahwa tǝkmandǝhiwa. ");
INSERT INTO bvw_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kǝthlǝm nga la yimkǝnna hur hanɗǝkiketǝwa la yimkǝnna hur kǝhapangkaɗi. A hurra shuniya cheɗkǝ Yǝso wa i sǝka ɗǝsǝmta tǝkǝmtǝsa fi'enwa. ");
INSERT INTO bvw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ngǝr kǝnna ndatwa i lachekakissha hur hanɗǝkiketa nifa ndǝkǝn na tǝkmanghi. ");
INSERT INTO bvw_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kǝthlǝm a hur hanɗǝkiketa nifa la chetɓǝɓi'ichakish, ndanda ɓǝɓiyara, fǝllawichita, herketa, tǝ ɓǝlfata, ");
INSERT INTO bvw_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Katnishcha nofcha, sǝɓfata, lekta, sǝrǝhta, mwa'inda, ɓokta, tǝ ɓomchita. ");
INSERT INTO bvw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Uf ɓǝɓi'ichiniyu lǝ chekna hanɗǝkiketa, ndǝkǝn la tǝkmang nifǝhi. ");
INSERT INTO bvw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Mbǝnniyu malkǝ Yǝso Galilihi pǝɗakna thlet hǝmmǝt Taya tǝ Sidon. yimkǝnna hura'a yuna, a yahu kǝ sǝnfichiwa. Nat tǝ kichu ɓuɓwe'iuwa. ");
INSERT INTO bvw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Chatkichuyu nuhnifǝsi, tǝ hwe'ensi kǝ nuhhweya naktǝ ɓǝbi shemeɗafa, kǝ sǝktǝn kusheng Yǝso, ɓakna hǝmtǝhi mbanitǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nuhhiyu witǝ Helinawechǝ nakǝn, a thlet hǝmǝt Finikiya ngǝttǝfichǝndi, a hachahai Suriya. A hwanaǝn Yǝso wa kǝ kǝtaǝn ɓǝɓi luwurchaɗa fa hwe'en. ");
INSERT INTO bvw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ndang Yǝso wa: \"Suku kǝ ngal hwechǝ kwaɗǝn, kǝthlǝm kamusi kǝ tǝr fichǝ ɗǝsǝmta hwecha kǝ fǝrang ficha hǝɗechuwa.\" ");
INSERT INTO bvw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","A ngǝmang nuhiyu tǝ ndatwa: \"Ə, kichuyu malɗǝm, chikatǝ kichu hǝɗecha la sǝmkǝnndǝ fishirchikǝnti ka tebǝr lela hǝhatka haya miya hwecha. ");
INSERT INTO bvw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ndǝkǝn ndandǝ Yǝso wa: \"Kǝthlǝm shundeku, ɗuɗaɗi, ɓǝɓilura shekhi tǝ 'hwe'eku.\" ");
INSERT INTO bvw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ngǝrang nuhnifǝkǝn inna ɗi ɗǝkna mbǝssandǝ hwe'en ɗuk a mbǝthunata ɓǝɓi luriyu tepa keltǝndǝhi. ");
INSERT INTO bvw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Malkǝ Yǝso thlet hǝmǝt Tayahi, kuwurkǝn tǝ Sidon ɗǝkna hawur Galili. A mbanda kwirtǝ thlet Hǝmchǝ shee Kum. ");
INSERT INTO bvw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","A mbǝnniyu ɓang ndǝ ɓomma, le lakweekǝ shunda, a hwanangnda kǝthlǝm kǝ ɗǝfaǝn hara in. ");
INSERT INTO bvw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kaɓkǝ Yǝso ɓommiyu kǝkǝllar, mbahkǝnndaɗa thlǝmat nofchiyu kǝ mbǝɗi nguchit nifǝsi. Pakǝn hanharchi'enna hur thlǝmmecha nifiyu, chahkǝn yahta hanhar'en, tǝka'ǝn hara hanshunda nifǝkǝn fa. ");
INSERT INTO bvw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kǝlak na afshi kahkǝn yiptǝ langnga, ndakǝnwa: \"Iffata!\" sakǝtkǝnwa: \"Innuhi!\" ");
INSERT INTO bvw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kǝ mbutǝn kichu inkǝ thlǝmmecha nifǝkǝnhi, i kǝnnang hanshundǝ'en paɗ kwaskǝnhi, tǝr kaakǝn shundǝ ndiichin. ");
INSERT INTO bvw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ɓokang Yǝso kandǝwa mǝ mbwa'anda chika wunwa, nattǝ ɓoki ɓokandǝnnakanda nak mbukǝnna chekta. ");
INSERT INTO bvw_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Shekɗang i'ndǝ kandǝ ka'ǝn, ndakndǝwa shiitǝ ichindiichin oi! Sokkǝn ɓomchasǝkmbǝta, tippengcha kanda shunda\". ");
INSERT INTO bvw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","A hur hanmunchiniyu, nofchǝ oi paɗ ɓaka mbǝs Yǝso. A nakǝn ǝnsǝ nannda sǝmtǝwa, ak Yǝso kimshechi'en ndangna kandǝwa: ");
INSERT INTO bvw_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","\"Nofchiya haɗitǝfa, kǝthlǝm munkǝndǝ mǝkkan nakǝnya kanda thlǝmatna mwa'u ndǝsǝmtengnandǝsuwa, ");
INSERT INTO bvw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ma ɗeɗi nakǝnyawa kǝ pǝɗandaɗaɗi tǝ mita, na funa hǝhattǝhi mbacha. Kǝthlǝm funǝ ɓakndǝ langnga.\" ");
INSERT INTO bvw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ndǝkǝn ngǝmmandǝ kimshechi'enwa: \"Nakma mbǝs njohma aiya hurhweli'iya na sǝmma ǝn nofchi natya?\" ");
INSERT INTO bvw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Sahang Yǝso kimshechiken'enwa: \"njohmǝ kurmǝ naksengnuni?\" Ngǝmangndǝwa: \"Muɗ.\" ");
INSERT INTO bvw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ndangna nofchiyuwa kǝ sokndǝhi kǝ hachahaya. Ndǝkǝn hartǝn njohhomchi muɗ yu, saǝn usoko Fara, chichaǝnhi, fǝrangna kimshechi'en kǝ sakangnda nofchiyu, sǝk kimshechi'en kichuyu. ");
INSERT INTO bvw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tǝ paɗ tinchisǝ ɗimek. Yǝso saǝn usoko Fara, ndangna kimshechi'enwa leya paɗ sakamna kanda. ");
INSERT INTO bvw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Sǝmkǝnda ngalkǝndǝ nda i yahtǝnda. Ɗiffitǝkǝn ngomang kimshechi'en fishirchikǝn inaftǝ muɗ. ");
INSERT INTO bvw_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A farǝkǝn shee nifǝ aru kumchit fwaɗɗa (4,000). Paɗ ndang Yǝso kandǝwa pǝɗama. ");
INSERT INTO bvw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Chatkichuyu thlaakǝ Yǝso tǝ kimshechi'en yimkǝnda hur kommbawal pǝɗaknda thlet hǝmǝt Dalmanuta. ");
INSERT INTO bvw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ɓak Farisawecha tǝrkaakǝndǝ sahami Yǝso. Kǝthlǝm yahndǝssa kǝkaɗanda, sahangndǝ kǝ cheɗaǝn sakǝtkǝna kanda a hur afshi. ");
INSERT INTO bvw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kǝtkǝn yiptǝ langnga hur shemeɗ'en ndakǝnwa: \"Kǝthlǝm mǝ nat nofchi kishi'i nakǝnya katsakǝtkǝn? Kitchitkǝn ni mbwa'anda kuni sakǝtkǝnsi nat ficha fǝranda kishi'i nakǝnyawa.\" ");
INSERT INTO bvw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Thlaakǝn malkǝnkandǝhi, yimkǝnda hur kommbawal pǝɗakǝn kǝ chicheng le. ");
INSERT INTO bvw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","A nakǝn mbutandǝ kimshecha Yǝso kǝ tǝrndi njohmǝ in, njohmǝ ǝrtǝ ndak naka harengnanda hur kommbawal tǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ndang Yǝso kimshechǝkǝn'enwa: \"Ndǝfam ǝndisǝ ndiichin kǝ ndǝsǝcha Farisawecha tǝ i Hiridus nda mehnda.\" ");
INSERT INTO bvw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tǝrkaakǝndǝ shundǝ tǝndani tǝ ndatwa: \"Mbukǝn i'ya kǝthlǝm njohmǝsa harrengnǝmwa.\" ");
INSERT INTO bvw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Shin Yǝso i nat kimshechǝkǝna shunda ɗarkǝn, ndǝkǝn sahandǝn mǝ kandǝwa: \"Kǝthlǝm mǝ natu ni ndandandaniwa njohmǝ nguchiksa harengnuni?\" Awi paaya a sǝnwuniwowa? Tǝpaɗɗaa paaya a mbǝsawuniwowa? Paaya mwaakǝ hanndǝkikechengnuni kwaakwaawa? ");
INSERT INTO bvw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Hwanichengnunisi, nuwuni mbǝtwowa? Thlǝmmechengnunisi, sǝkwuni mbǝtwowa? Kuɗukwunniharwowa? ");
INSERT INTO bvw_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Fari chichandi njohmihi ɗurman chiitǝ nofchǝ aru kumchit ɗurman yu, inaftǝ kurmi ngomanduni fishirchikǝn tiiyu?\" Ngǝmang kimshechǝkǝn wa: \"I'naftǝ kumngǝrǝnsǝ chap.\" ");
INSERT INTO bvw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ngǝrkǝn ndanda kandǝwa njohmi muɗ chichandǝhi chiiti nofchǝ aru kumchit fwaɗɗa yu i'naftǝ kurmi ngomanduni fishirchikǝn?\" Ngǝmangndǝwa \"i'naftǝ muɗ.\" ");
INSERT INTO bvw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Paɗ sahaǝnmi kandǝwa: \"Kananat paaya a mbǝsawuniwowa?\" ");
INSERT INTO bvw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yǝso tǝ kimshechi'en ɓaknda Betsaida, ɓak nofchǝ tǝ nifǝ kǝ kukomta, hwanang nofchiyu kǝ tǝka'ǝn harfa. ");
INSERT INTO bvw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kǝskǝn haara kukomǝyu, chekǝntǝnda kish a hur thlet hǝmǝtkǝn. Chahkǝ Yǝso yahta hwanicha kukomǝyu sǝkkǝn harchi'enna hwanicha kukomǝyu, sahang Yǝso wa: \"Sa nat mbǝt wa?\" ");
INSERT INTO bvw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Kǝllakna afshi a ndakǝnwa: \"Nja nat nofcha nakndǝ nda afchǝ naka wiita.\" ");
INSERT INTO bvw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ngǝrkǝ Yǝso sǝt harchi'enna hwanicha kukomǝyu, nakǝnya kǝllak nifiyu ndiichin, ǝnkǝ hwanichi'en hi nakna nat chikamǝhi chiɗchiɗ. ");
INSERT INTO bvw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ndǝkǝn ndandǝ Yǝso wa: \"Ɗuɗaɗi kǝ huri, mǝ ngǝrina thlet hǝmǝɗiniyuwa.\" ");
INSERT INTO bvw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Thlaakǝ Yǝso tǝ kimshechi'en kǝ thlet hǝmcha hachahai Kaisariya Filibi. Nak nda wita ndǝkǝn sahandǝn kimshechi'enwa: \"La tǝrkǝ nofchuwa wunnaki?\" ");
INSERT INTO bvw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ngǝmang funǝ la ndakndǝwa: \"Sokǝn Yohanna lǝ sǝt Baptisma, funǝ la ndakndǝwa Iliya tapǝna'a, funǝ paɗ la nɗakndǝwa naku ǝrta hur tapǝnecha.\" ");
INSERT INTO bvw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ndǝkǝn sahandǝ Yǝso kimshechi'enwa kunang kǝni: \"La ndakuniwa wun naki?\" Bitrus Ngǝmanwa sokǝn naka Kǝrǝsti.\" ");
INSERT INTO bvw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ɓokang Yǝso kandǝ ndatwa: \"Mǝ mbwa'anda yunǝ ndu wun nakǝnwa.\" ");
INSERT INTO bvw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tǝrkaakǝ Yǝso sakandakandǝhar tǝ ndatwa: \"Hweya nifǝ nan ɓahtǝhi tǝ ichi somsomǝn, paɗ kǝ cher pǝktechǝndi tǝ pǝktat pǝristochicha, tǝfa sakandǝ ɗalwer tǝ kussa Musa ɗi. Nanda ɓǝllanda, ɗiffitǝ mundǝ mǝkkan nan thlata. ");
INSERT INTO bvw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mbwa'ǝn ichiniyu kimshechi'en a ɗwachitkǝn. Ɓak Bitrussa kahndi kǝ kǝlar ɓoka'ǝn kǝ ɗar mbuwitǝ'ichiniyu. ");
INSERT INTO bvw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tǝɓǝrkǝ Yǝso hi nakna kǝllandǝ kimshechi'en, ɓokangna Bitrus hi tǝ ndatwa: ''Mbahhu thlǝmatna Sheɗan, yareku nga i Farǝwa i nifa.\" ");
INSERT INTO bvw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Akǝn nofchǝ tǝ kimshechi'en, ndangna kandǝwa: \"Nifi yahkǝssa kuwurnji kǝ cherǝn i'ndǝ'en, kǝ tǝrǝn palitǝ'en kǝ kurǝn nji.\" ");
INSERT INTO bvw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kǝthlǝm chikawun yahkǝssa hǝrkandǝ shisshingtǝ'en nan shekɗanda, paɗ chǝkawun shekɗang shisshingtǝ'en kǝthlǝm njang tǝ kushengshundǝ mbǝnchin, nan hǝrkandi shisshingtǝ'en. ");
INSERT INTO bvw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mǝ naka mbǝs ǝnhara nifa ma mbǝssandǝ kisshita kǝ ɓahhǝn shisshingta. ");
INSERT INTO bvw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mǝnat nifa fǝrta kǝthlǝm shisshingtǝ'en? ");
INSERT INTO bvw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Chǝkawun la harandǝfat kǝthlǝm njang tǝ shundengna a kishi ɓahkitchiɗiya tǝ ɓǝɓichit faɗi nakǝnya, hweya nifa nan sǝk harǝfat'en paɗ ma ɓeɗa hur mwanda Shinkǝn tǝ mala'ikachǝ chiɗchiɗ. ");
INSERT INTO bvw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ndǝkǝn ngǝrtǝ Yǝso ndanda kandǝwa: \"kittǝkǝn nja mbwa'anda kuni, funǝsa a hurnuni mbǝɗya ngunda mǝrtǝwa sema neɗndǝ kuturichita Fara ɓeɗ tǝ alchita.\" ");
INSERT INTO bvw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ɗiffitǝ mundǝ tehheth, harkǝ Yǝso nda Bitrus tǝ Yakubu tǝ Yohanna, ɗǝkǝn tǝ kanda shohlatǝ lenak njang, nakndǝ ichitnanda mbǝnniyu. Naknda nata kǝllathi chat mbumbweɗkǝ fata Yǝso hi a mbanitǝnanda, ");
INSERT INTO bvw_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","sǝk njelechi'en hendǝɗa nakna kǝstǝfǝ nda hwatfara, nguchit nifa mbǝlla sapandǝ njelechi'en tǝ pachau kichuyu a hur kishi'iya. ");
INSERT INTO bvw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Chatkichuyu ɓak nda Iliya tǝ Musa, cheɗkǝndǝ faɗengnanda paɗ kanda shundǝ tǝ Yǝso. ");
INSERT INTO bvw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ndang Bitrussa Yǝso wa: \"Malɗǝm ɓaɗengnǝma mbǝdya ndiichinsi, tahsam kǝtǝnchǝ mǝkkan, ǝrtǝ iyuwa, ǝrtǝ i Musa, ǝrtǝ i Iliya.\" ");
INSERT INTO bvw_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Mbukǝn iniyu kǝthlǝm sǝnutǝ'i'natna mbutǝwa, kǝthlǝm a lechiɗnda. ");
INSERT INTO bvw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ɓak husomba'a haya kǝ ɗar inchengnanda ngǝlaǝn kanda, chek mburata kissha hur husombikǝn tǝ ndatwa: \"Ka hweengnǝniya leyahti kamǝn thlǝmmata.\" ");
INSERT INTO bvw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Chat kǝllakndǝhi chika tǝteni nundǝ nifǝ somǝnwa, se Yǝso ndak naka thlǝmat nanda. ");
INSERT INTO bvw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Naknda tǝrtahaya a shohlayiyu, ndang Yǝso kandǝwa: \"Mǝ mbwa'anduni nifǝ i'nattuniyawa, se fari thlaatǝ hweya nifa hur mǝmatcha.\" ");
INSERT INTO bvw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kǝskǝndǝ I'har mbwa'andǝnna kanda, paɗ naknda sahandǝ ndanichǝ tǝ ndatwa: \"Mǝ naka sakǝt thlata a hur mǝmatcha.\" ");
INSERT INTO bvw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Sahang ndǝ mi tǝ ndatwa: \"Kǝthlǝm mǝ ndat malɗǝmchǝ fa sakandǝ kus tǝkǝnnaɗi, Iliya na tǝrka thlata?\" ");
INSERT INTO bvw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ngǝrkǝ Yǝso sǝwa: \"Kittǝkǝn Iliya na tǝrka thlata kǝthlǝm kǝ tahsaǝn chikamǝhi. Chika tǝ kichu, kǝthlǝmmǝ ndat laulawatkǝnwa hweya nifa nan sat pwanchǝ ka'ǝn tǝ paɗ kǝ njirndǝndi? ");
INSERT INTO bvw_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Paɗ nja mbwa'anda kuni ndatwa, Iliya tepi ɓeɗi sa nofchǝ i'ngǝmtǝ hurengnanda nda i'natna a hur laulawatkǝn kǝ ɗar i'ndi'en. ");
INSERT INTO bvw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kǝnatnda ngǝrta mbǝɗa tahǝt kimshechi'en, nakndǝ nofchǝ oi, a taurangndǝ kandǝhi, paɗ funǝ malɗǝmcha fa sakandǝ kus tǝ tǝrɓanda Fara ɗi kanda halǝ'i'ndǝ tǝ kanda. ");
INSERT INTO bvw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kǝnat nofchiyu Yǝso, pǝɗang ǝn kandǝfa, rahkǝnda thlǝmatkǝn ndangndǝ ǝna. ");
INSERT INTO bvw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ndǝkǝn sahandǝ Yǝso kandǝwa: \"Mǝnatuni halǝ'i'ndǝ tǝ kandǝ kǝ ɗarkǝn?\" ");
INSERT INTO bvw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yuna hur nofchiiyu shuwunkǝn tǝ ndatwa: \"Malɗǝm ɓuɗi hwe'engna kǝthlǝm kǝ kǝnangɗi ɓǝɓi shemeɗɗa fat'en njandǝ shunda. ");
INSERT INTO bvw_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ma ɓeɗ ɓǝɓi shemeɗkǝnna fi'en la muhkǝnndǝhi kǝ hachahaya. Mi'enna hupta kǝna chi hanthlanchi'en, chat mbǝsku titiɗhi. Ndaɗi kimshecheku wa kǝ rǝkangndǝ ɓǝɓishemechikǝnna kish mbǝlla'undǝwa.\" ");
INSERT INTO bvw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ngǝmang Yǝso kandǝwa: \"Kunang nofchǝ fa ɓahfǝrkit! Kǝkwat natmanata ɓǝt ǝrtǝ tǝ kuni? Kǝ kwat natinata kǝrǝstǝ tǝkuni? Ɓamitǝn hwankǝn.\" ");
INSERT INTO bvw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ɓangndǝ hwaniyu. Kǝnat ɓǝɓi shemeɗiyu Yǝso, tǝpkǝn hwanihiyu hachahaya mǝla takarǝhi mi'enna hupta. ");
INSERT INTO bvw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","\"Ndǝkǝn sahandǝ Yǝso mi shin hwanniyuwa?\" Ɓǝt kǝnni kǝstǝ'i'ndiya?\" Ngǝmanwa: \"Thlata hwanchit'en. ");
INSERT INTO bvw_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kurɓandǝ nata muhnda hur am tǝ hwata tǝna mbǝlanda. Paɗ manu mbǝllata kǝsanna kanisi kǝ handukanifa.\" ");
INSERT INTO bvw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","\"Ndǝkǝn ndandǝ Yǝso wa kǝthlǝm mǝnatu ndatwa mani mbǝllata?\" Chikamǝ nan sǝtta kǝ mbǝɗa le fǝrkǝ kit.\" ");
INSERT INTO bvw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Chatkichuyu shin hwanniyuwa tǝkǝn ndakǝnwa, a firi kit, paɗ kǝsitǝnsi tǝ ɓah fǝr kitchiɗengna.\" ");
INSERT INTO bvw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kǝ nat Yǝso nofchǝkǝna chektǝ oi, kanda ɓat tǝ rahta, ɓokangna ɓǝɓi shemeɗkǝnhi tǝ ndatwa: \"Sokǝn ɓǝɓi shemeɗɗi njang sǝkɓǝt tǝ shunda hwaniya nja ndutuwa chukisha fat'en mǝ tamina ngǝr yimta fat'enwa.\" ");
INSERT INTO bvw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ɓǝɓi shemeɗɗiyu hwakǝn, tǝpkǝn hwanihiyu fat'enna saktatfa chekna kish. Nak hwanniyu ɗuk nda tǝ mǝrrǝn, nak nofcha hurrumta paɗ terchin ndangwa tǝ mǝrrǝn. ");
INSERT INTO bvw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kǝskǝ Yǝso hara hwanniyu kǝsaansi thlarkǝnhi kit. ");
INSERT INTO bvw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ɗiffitǝ ndǝkǝn, Yǝso tǝ kimshechi'en i'chitnanda a huri, sahang kimshechi'en miya a ɓuɓweeta: \"kǝthlǝmmi mbǝla'uchitani kǝtandǝ ɓǝɓi shemeɗɗiyu?\" ");
INSERT INTO bvw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ngǝmang Yǝso wa: \"Witǝkǝn ngu chetakish kichuwa se tǝ hwanda.\" ");
INSERT INTO bvw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Malkǝndǝ mbǝnnihiyu cheknda kish tǝ hurhuri Galili. kǝthlǝm yahu Yǝso kǝ sǝn nifǝ mbǝndi natǝnwa, ");
INSERT INTO bvw_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","nakna sakanda kimshechi'en har tǝ ndatwa: \"Na ficha fǝr hweya nifa kǝ harra attikrechikǝn, nanda mbǝllanda paɗ ɗiffitǝ mundǝ mǝkkan nan thlata hur mǝmatcha.\" ");
INSERT INTO bvw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nakǝn mbǝsawundǝ i'mbutǝnwa tǝ paɗ kanda lechit kǝ sahangndǝ i'natna yara. ");
INSERT INTO bvw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ɓak nda Kafarnahum sokkǝndǝhi a huri sahang Yǝso kimshechi'enwa: \"Mǝnatuni shunda ɗarkǝna mbandiyu?\" ");
INSERT INTO bvw_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mbǝla'undǝ fǝra ngǝmkǝnwa, kǝthlǝm a mbanda helndǝ i'ndǝ tǝ ndani ndatwa wun nak mwanchinna hurnanda. ");
INSERT INTO bvw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sokkǝnhi, akǝn kimshechi'en kumngǝrǝnsǝ chap yu, ndangnakandǝwa: \"Chikawun yahkǝsa nata mban kǝ naka ɗiffi paɗ kǝ saǝn fat'en kǝ mafata nofchǝ nat.\" ");
INSERT INTO bvw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tǝrkǝn hwe har, thlaraanhi hurɗifitǝnanda tǝrkǝnndǝ, ndangna kandǝwa: ");
INSERT INTO bvw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","\"Chikawun thlǝk hwe kicheya a hur thlǝmna thlǝtǝnji, paɗ chikawun thlǝknji, thlutǝnji ɗengwa thlǝkǝn tǝ Papati thlǝnkǝnji.\" ");
INSERT INTO bvw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ndang Yohanna Yǝso wa: \"Malɗǝm neɗani nifa rǝk ɓǝɓi luwurcha a hur thlǝmwa, ndangnganiwa kǝ malaǝn kǝthlǝm nga nakna hurnaniwa\" ");
INSERT INTO bvw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ndǝkǝn ndat Yǝso wa: \"Mǝ njaɗuniwa, nifǝsi na sǝt witǝ torǝniyu a hur thlǝmna mashiɗ kǝ tǝɓrǝnhi kǝ mbuǝn ɓǝɓi'icha i'ndengniwa.\" ");
INSERT INTO bvw_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Chikawun nguchika atikrechit tǝ kǝm mǝlan i'nǝm. ");
INSERT INTO bvw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kittǝkǝn nati mbwa'anda kuni, nat nifi fǝrang amsata kuni kǝthlǝm kunang 'i Kǝrǝsti nan thlǝt kǝnikǝn. ");
INSERT INTO bvw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Chikawun ɗǝfkǝ ǝrta hur hwanchi fǝrkǝ kit kǝ ɓǝɗengniya kǝ sǝn ɓǝɓichitfata, kweshaɗa nifiniyu kǝ wokang fichǝ fǝnhata ɓur kǝ muh fichǝnda hur hawurta. ");
INSERT INTO bvw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ma hareku la ɗǝfkǝsa sǝt ɓǝɓichitfata thlandinaɗaɗi. Kweskǝn kǝ yimna pwan nga harsǝ ǝrtǝwa mǝni muhsa hwata tǝ harchǝ hwaa. ");
INSERT INTO bvw_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Hwaɗi la lǝfuchik kǝ pwaree. ");
INSERT INTO bvw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ma sareku la ɗǝfkǝsa sǝt ɓǝɓichitfata, thlandǝnaɗi kweshkǝn kǝ yimna pwan nga sarǝsǝ ǝrtǝwa mǝni muhsa hwat tǝ sarǝchi hwaa. ");
INSERT INTO bvw_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Hwanɗi la lǝfuchik kǝ pwaree. ");
INSERT INTO bvw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma hwaniteku la ɗǝfkǝsa sǝt ɓǝɓichitfata, kǝtandǝnaɗi kweshkǝn kǝ yimna mwanda Farǝ tǝ hwanitǝ ǝrta mǝni muhsa hur hwat tǝ hwanichǝ hwaa. ");
INSERT INTO bvw_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mbǝɗi la mǝruchit hweecha, paɗ hwatkǝn tamwa liftǝwa. ");
INSERT INTO bvw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","\"Kǝthlǝm chikawun nak ficha kikeɗandǝ tǝ hwata. ");
INSERT INTO bvw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","\"Mannda ndiichin, paɗ ma tǝr mbǝndǝ'ennaɗi, naku mbǝlla ngǝranda kwarkǝn kǝ manndawa kǝni? Kǝnuni mbinchin tǝ ndani nda i nat mannda, paɗ kǝ sokuni yuyur tǝ ndani.\" ");
INSERT INTO bvw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yǝso malkǝn thlet hǝmǝɗkenhi pǝɗakna thlet hǝmǝɗ Yahudiya chaǝn suhwaɗ Yodan. Humkǝ nofchǝ oi kǝ thlǝmatkǝn, nakna nata sakanda nofchiharyu nda i la sǝtǝn kǝnding. ");
INSERT INTO bvw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ɓak Farisawecha mbǝsndi kǝthlǝm kǝ kikeɗangnda, sahangndǝ mi wa: \"Keekesi kǝ kal hishnifǝ nuhkǝnhiwa?\" ");
INSERT INTO bvw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ngǝmang Yǝso kandǝ tǝ sahmi paɗ ndatwa: \"Mǝ mbutǝ Musa a hur kus tǝkǝn kǝ ɗar sak reta?\" ");
INSERT INTO bvw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ngǝmang \"Musa fǝrandǝn mbanda hishnifa kǝ yaraǝn ɗelwera nuhkǝnsǝ kǝ fǝraǝn kǝ rǝkǝnndǝ.\" ");
INSERT INTO bvw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ndǝkǝn ndandǝ Yǝso kandǝwa: \"Yarangna kunisǝ kichuyu kǝthlǝm kwaakwaachit hanndǝkikechengnuni. ");
INSERT INTO bvw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Paɗ thlata tǝrkakǝn tinkǝ Farǝ kandǝ, nuhnifa tǝ hishnifa. ");
INSERT INTO bvw_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kǝthlǝm ndǝkǝn hishnifǝ nan malǝ shinkǝhi tǝ mankǝn kǝ nandǝ ǝrtǝ tǝ nuhkǝn. ");
INSERT INTO bvw_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Chapndǝyu hwimndǝhi kǝ ǝnǝrta. Nga nakndǝ chap paɗwa nakndǝ ǝrta. ");
INSERT INTO bvw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kǝthlǝm ndǝkǝn i'humandǝ Fara mǝ saka nifǝhiwa. ");
INSERT INTO bvw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kǝnatǝn i'chitkǝn tǝ kimshechi'enna huri sahangndǝ mi kǝ ɗar shuniniyu paɗ. ");
INSERT INTO bvw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ndangnakandǝwa: \"Chikawun cherkǝ nuhkǝn kahkǝn somǝn shiɗtǝ fǝlawichit tǝ ndi ");
INSERT INTO bvw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Paɗ ma cher nuhnifǝ sǝmaha kahkǝn yunǝ somǝn, shiɗtǝ fǝlawichita.\" ");
INSERT INTO bvw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Farǝ le ɓang parchǝ hwechengnanda Yǝso kǝthlǝm kǝ tǝka'ǝn harra kandǝfa kǝ fǝraǝn mbǝsǝnhara kanda. Nak kimshechi'enna njanda parchiyuwa mǝ ɓindǝ tǝ hwanchiyu mbanitǝkǝnwa. ");
INSERT INTO bvw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kǝnat Yǝso kichuyu, sǝɓkǝ hur'ennaɗi, ndangna kandǝwa: \"Malamǝn hwecha kǝ ɓanda mbǝndengna, mǝ njanduni kandǝwa, kǝthlǝm kuturichita Fara i'witǝ fichile nak nda kandang. ");
INSERT INTO bvw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kitchitkǝn nati mbwa'anda kuni chikawun thluchik mwanda Farǝ nda hweya, ngu yimtǝsǝwa.\" ");
INSERT INTO bvw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Mbǝnniyu harkǝn hwanchiyu sǝkǝn harcha inchengnanda fǝraǝn mbǝs'ǝna kandahar. ");
INSERT INTO bvw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yǝso tahǝskǝnfa na ɓǝɗata Urshelima, ɓak kimsha'a lǝ kǝnaa tǝ rahta, sǝkǝn kurumchihi ɓanitǝkǝn sahaǝnwa: \"Ka Malɗǝm, mǝ natisǝta kani ɓǝs shisshingtǝ le kǝ pware?\" ");
INSERT INTO bvw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Sahang Yǝso wa: \"Kǝthlǝm mǝ atunjiwa ka malɗǝm?\" \"Nifǝsǝ naka katkǝnwa se Farǝ ndak. ");
INSERT INTO bvw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kǝ ngǝmayi sahmiyeku a shinnǝ kuschikkǝnwa! Mǝ mbǝlǝnifatwa, mǝ sǝni fǝlawichitwa, mǝ herkinǝwa, mǝ thlerna ɗar yuna a ɗar lektǝwa, mǝ ndathlana nifafuwa, kǝ fǝrrangnǝ mwanda nda suk tǝ yatu.\" ");
INSERT INTO bvw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ndǝkǝn ndandǝnwa: \"Malɗǝm, a hǝrmi i'chiniharyu nat thlata hwanchiɗengna.\" ");
INSERT INTO bvw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Kǝlang Yǝso kimshi'iyu tǝ hwanitǝ mbǝnfata ndaǝnwa: \"Ən ǝrtǝ tahhuka, ɗu hi'yan i'chiɗǝ nakseku nat kǝ sakangnǝ hanndǝɓǝlkǝna fa ɓahcha, nu mbǝs hurmichita hur afshi, kanna ɓata kuwurnji.\" ");
INSERT INTO bvw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kǝ sǝktǝn shuninuyu, ɓǝɗakǝn tǝ sǝɓhura, kǝthlǝm lǝ kǝnaa nakǝn ka'ǝn. ");
INSERT INTO bvw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kǝlak Yǝso hi ndangna kimshechi'enwa: \"'Yang'yangnga fa hurumta kǝ yimka kuturichita Fara!\" ");
INSERT INTO bvw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Pǝndang ǝnna kimshechifiyu tǝ shuwunkǝn. Ndǝkǝn ngǝrtǝ Yǝso ndanda kandǝ paɗwa: \"Hwecha, yimta kuturichita Farǝ 'yang'yang. ");
INSERT INTO bvw_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nannat paapa'a fa ngelupa kǝ 'yimǝn tǝ kwat lipir mǝni hurumta kǝ yimka kuturichita Fara.\" ");
INSERT INTO bvw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kǝ sǝktǝ kimshechǝkǝn'en shuniniyu, pǝndang ǝn kandǝfǝ ka'ǝn sahkǝndǝwa: \"Ma nakǝn kichu wunhacha na hǝrǝkta hurkishi'iya?\" ");
INSERT INTO bvw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Kǝllang Yǝso kandǝ ndakǝnwa: \"Mbǝɗa nifa ngu nat paapaawa, mbǝɗa Fara chikamǝ nan nat paapaa.\" ");
INSERT INTO bvw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tǝrkaakǝ Bitrus ndandǝwa: \"Kanang melani i'chi hi nat kana kuwursa.\" ");
INSERT INTO bvw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ndǝkǝn ndat Yesowa: \"Kittǝkǝn nja mbwa'anda kuni, chǝkawun malkǝ huraahi, ndu hwanmanchǝkǝn kǝ hishcha tǝ nishcha, ndu shinkǝn ndu mankǝn, ndu hwechi'en, ndu pwatarcha kǝthlǝm njang tǝ ka kusheng shunda, ");
INSERT INTO bvw_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nan mbǝs ǝn arucha a kishi'i nakǝnya, hurecha, hwanmancha, parcha, hwecha tǝ pwatarcha tǝ pwenecha nan mbǝs shisshingta a hurrechi na ɓatyu, ");
INSERT INTO bvw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kǝthlǝm ndǝkǝn, terchin fichile naka mban nakǝnya naknda nata ɗiffi, fichile naka ɗiffi paɗ naknda nata mban.\" ");
INSERT INTO bvw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kanda pǝɗata Urshelima, Yǝso lak na mbanitǝnanda. Pǝɗang ǝnnatkǝn kimshechi'enfa, nofchi naka kuwur kanda ɗiffi paɗ lechiknda. Thlarkǝ Yǝso hi akǝn kimshechi'en kumngǝrǝnsǝ chapyu kǝ kǝlar, mbwa'angna kandǝ nat i' na mbǝsndi. ");
INSERT INTO bvw_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ndakǝnwa: \"Sǝkama, nakǝnya nǝma ndǝta Urshelima, kǝ mbǝndǝ nat ficha fǝr hweya nifa, kǝ harra pǝktat pǝristcha tǝ malɗǝmcha fa sakandǝ kus tǝkǝnnaɗi. Nanda thla kitasǝ i'mǝrtaɗi kǝ fǝrndǝndi kǝ harra punofcha. ");
INSERT INTO bvw_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nanda sa welǝm, chahangndǝ yahta fa, tǝppangnda, kǝ mbǝllangnda. Hur mundǝ mǝkkan nan thlata.\" ");
INSERT INTO bvw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nda Yakubu tǝ Yohanna hweecha Zabadi ɓaknda ɓǝsndi ndangndǝwa: \"Maldǝm, ǝnsǝ yahtanisa hwanuta kǝ sangnǝ kani.\" ");
INSERT INTO bvw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Sahaǝn kandǝwa: \"Mǝ yahtuni kǝ sayi kuni?\" ");
INSERT INTO bvw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ndangndǝwa: \"Fari natu yimta kuturichiɗeku hur afshi kǝ sokǝm rǝmma, ǝrta harsǝmteku ǝrtǝ paɗ a hishingteku.\" ");
INSERT INTO bvw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ndang Yǝso kandǝwa: \"Sǝnwuni i natuni hwandǝwa. Nuni mbǝla sat ɓahhi nati satyawa? Nuni mbǝla thlǝt baptisma ti nati thlǝtyawa?\" ");
INSERT INTO bvw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ngǝmangndǝwa: \"Aa nani mbǝlata.\" Ndang Yǝso kandǝwa: \"Nuni mbǝla sat ɓahi nati sata, kǝ thluni baptisma ti nati thlǝta. ");
INSERT INTO bvw_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Paɗ alchiɗengnǝsǝ nati ndatwa leya na sokta a harsǝmtengna ndu hǝshingtengnǝwa. Farǝ tahsaǝn ɓichiniyu kǝ i' fichile taɗtǝnhar.\" ");
INSERT INTO bvw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kǝ sǝktǝ tahǝt kimshechi'en kumyu shuniniyu sǝɓkǝ hurchengnandaɗi kǝ ɗar Yakubu tǝ Yohanna. ");
INSERT INTO bvw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ak Yǝso kandǝ nat, ndangna kandǝwa: \"Shinuniwa, fichile naka kuturcha a kishi'iya la sǝkndǝ tor tǝ alchindengnanda kǝ ɗar nofchengnanda, paɗ pǝktechǝkǝn la sǝkndǝ tor tǝ mwaɗengnanda kǝ ɗar nofchengnanda. ");
INSERT INTO bvw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ngu nat kichu a hurnuniwa. Paɗ le yahkǝsa nat mwanchin a hurnuni, kǝ sǝka mafata tahchǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tǝ paɗ le yahkǝssa nata mban, kǝ naka mafata nofchǝ nat. ");
INSERT INTO bvw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kǝthlǝm chika hweya nifa a ɓu kǝ sang fichǝ torwa, ɓakǝn kǝ saǝn tora nofcha, paɗ kǝ fǝrǝn shisshingtǝ'en kǝ thlǝn nofchandǝ oi.\" ");
INSERT INTO bvw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yǝso tǝ kimshechi'en saakǝnda Yeriko. Naknda malǝ Yerikohi tǝ nofchǝ oi, lǝ hwandǝsǝ paɗ kukomta thlǝmkǝnwa Bartimawus, hweya Timawus, ɗas a mi mbanda, ");
INSERT INTO bvw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kǝ sǝktǝ Bartimawus wa Yǝso Lǝnazarat naka mbǝrtǝhi, ndǝkǝn thla'andǝn mburata ndatwa: \"Yǝso hweya Dauda, kǝ handukǝfa.\" ");
INSERT INTO bvw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ɓokang nofchihi oiyu ndangndǝwa kǝ ngasǝn ɓa. Thlat tǝkichu i'naǝn mburathi ka'ǝn: \"Hweya Dauda kǝ handukifa!\" ");
INSERT INTO bvw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Sǝkkǝ Yǝso ndi thlarkǝn hi ndakǝnwa: \"Ndamǝnwa kǝ ɓaka mbǝɗya.\" Nofchiyu ndangnda kukomiyuwa: \"Kwallu hacha,\" \"Aɓu mǝla atsa.\" ");
INSERT INTO bvw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Chatkichuyu thlakǝ kukomiyu muhaǝn ndǝ suptǝ'enaɗi, ndǝkna mbǝs Yǝso. ");
INSERT INTO bvw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ndǝkǝn sahandǝ Yǝso miya: \"Mǝyahtusǝ kǝ sukǝ?\" Ndǝkǝn ngǝmandǝ kukomiyuwa: \"Malɗǝm, Yahkǝsi kǝ mbǝsi natmbǝta.\" ");
INSERT INTO bvw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ndang Yǝso wa: \"Ndu, fǝrkitchindeku kǝnuɗaɗi.\" Chatkichuyu inkǝ hwanichi'enhi kuwurkǝn Yǝso pǝɗaknda. ");
INSERT INTO bvw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kǝnatnda satǝ nduk kǝ Urshelima, a Betafaji, tǝ Betani, tǝ shohla Zaitun, thlinkǝ Yesu kimshechi'en chap, ");
INSERT INTO bvw_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ndangna kanduwa, yimmama thlet hǝmǝɗini taata mbanitǝnuniyu, nda yimtengnunisi nuni nat hwan kware kǝnda, le tamuchit ficha pǝrtǝsi. Kǝ kwasuni ɓunitǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Chika wun sahang mi kuni wa kǝthlǝm mi, natuni sǝt kichu? Ndangnguniwa shinnǝm naka yahta, paɗ nan ɓattǝkǝn nakǝnya. ");
INSERT INTO bvw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ndǝkǝn pǝndat kimshechi'en ndǝknda ɓǝssandǝ hwan kware tǝkǝnna miɓanga a kǝlarǝ mbanda, kwassang ndǝ hi. ");
INSERT INTO bvw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nofchi nak kitkita mbǝnniyu, ndangnda kanduwa: \"Kǝthlǝm mi natuni kwasǝ hwan kware ti ya? ");
INSERT INTO bvw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Mbwa'angnda kandǝ I ndandǝ Yǝso kandǝwa kǝ mbunda, malang nofchikǝnkanda pǝndakndǝtǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ɓangndǝ hwan kware tǝkǝna Yǝso supkǝndǝ njelenjengnanda ɗar hwan kware tǝkǝn pǝrkǝnsi. ");
INSERT INTO bvw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nofchǝ oi supkǝndǝ ndǝ supcheng nanda mbanda, funǝ paɗ thlithlahkǝndǝ swikangrechi har somkǝndǝhi. ");
INSERT INTO bvw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Fichile ɓan tǝ fichile naka ɗiffi naknda whata, funa kukwara tǝ ndatwa, Hosanna! ɓǝs'ǝnna har shok kǝ ndukwatkǝn kǝɓǝɗa lǝɓatta hur thlǝm Lǝmwanda. ");
INSERT INTO bvw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ɓǝs'ichisǝ har a ɗar ɓata kuturichita kakatnǝm Dauda! Mwanamǝn Fara le naka afshi ");
INSERT INTO bvw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yim kǝnna Urshelima, kǝ kapat hura'a Fara, kǝllaǝn chikami, Sǝk farǝhufta, chekna kish pǝɗak na Betani tǝ kimshechi'en kum ngǝrrǝnsǝ chap. ");
INSERT INTO bvw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ɓingǝtkǝn naknda malǝ Betanihi, nak mita fa Yǝso. ");
INSERT INTO bvw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Anakǝn affǝt shuɓwat tǝ swa'en kundummǝ kuɗkuɗ langnga, ndǝkǝn ndǝtǝn ka nata naǝnhiwa nan mbǝs hwecha ɓuratkǝn. Swechǝ ndaknaksi, kǝthlǝm sa'u farǝ ngǝttǝ'enwa. ");
INSERT INTO bvw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ndang Yǝso affǝtkǝnwa: \"Mǝ ngǝri nifa chi hwecheku paɗwa.\" A shik kimshechi'en i mbutǝn. ");
INSERT INTO bvw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ɓakndaɗi kǝ Urshelima, yim kǝ Yǝso kǝ kapat hura'a Fara, rǝkkǝn fa hita tǝ fa hi'yandǝ ichaɗa hur kapat hurikǝnna Fara, paɗ wuwelaǝn hanafcha fa hi'yandǝ Tattabaracha ndǝ tǝ fa mbumbwe hanndiɓǝlcha. ");
INSERT INTO bvw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Paɗ thlaraǝn chika wunhi naka sǝt tortǝ kapat huri kǝnna Fara nda mbǝt hi'yandǝ ichaɗi. ");
INSERT INTO bvw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ndangna kandǝwa: \"Ndak yaratkǝnwa, 'Hure'engna nak ficha atwa mbǝt hwanda a hǝmchǝnat, ɓakuni tǝɓrandǝhi kǝ mbǝt sokta harcha.\" ");
INSERT INTO bvw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kǝ sǝktǝ pǝktat pǝrischǝ tǝ malɗǝmcha i laulawatkǝn i sǝt Yǝso, kakndǝ mbayi natnda mbǝllanda. Sokkǝn lechanda kǝthlǝm nofchi humkǝyu pǝɗa'ǝnkandǝfǝ tǝ saktǝ'en. ");
INSERT INTO bvw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","A Farǝhuffǝɗiniyu chek Yǝso kisha hǝmǝtkǝn tǝ kimshechi'en. ");
INSERT INTO bvw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kanda mbǝrtǝhi a ɓingǝtkǝn tǝ thlǝmat affǝɗi mbutǝn ǝn kǝ ɗarkǝnyu, mbǝssang kimshechi'en affǝt shuɓwatkǝn hwerandǝ kǝ thlorǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Kuɗukkǝ Bitrus i mbutǝ Yǝso kǝ ɗar shuɓwaɗiyu a farǝle ndakǝnwa: \"Malɗǝm, kǝllu shuɓwandǝ sǝɓandundǝ tǝ hanngalǝ shunda hweraɗi paɗ miraɗi.\" ");
INSERT INTO bvw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ngǝmang Yǝso kimshechi'en wa: \"Nam tǝ fǝrkitta mbǝnda Fara. ");
INSERT INTO bvw_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ni mbwa'a kittǝkǝna kuni, chikawun ndannga shohlayiya wa, 'thla'u hǝmu hur hawuriyu, nan hǝmtǝsi. Paɗ waat kǝ fǝrnǝkit kǝna sǝtkichu, mǝninǝ tǝ hanɗǝkiketǝ chap chap wa. ");
INSERT INTO bvw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kǝthlǝm ndǝkǝn nja mbwa'anda kuni, chika mǝ katuni hur hwanda, ma firuni kitsi tepa mbishuni, nan sokta innuni. ");
INSERT INTO bvw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Paɗ ma thleruni hi kuna hwanda, ma yunǝ si natuni tǝnda a hurhanɗǝkiketa, kǝ kaluni ndǝhi, kǝ thlǝm shinnuni ti naka hur afshi nan kala ɓǝɓichitfechengnuni kunǝhi. ");
INSERT INTO bvw_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Paɗ ma kalawuni ɓǝɓichitfechengnanda kandǝhiwa, shinnuni hur afshi ngu kala ɓǝɓichitfechengnuni kunihiwa. ");
INSERT INTO bvw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ngǝrkǝ nda yimta Urshelima. Nak Yǝso wi'yandǝ kapat hura'a Farǝhi, pǝktat Pǝrischǝ tǝ pǝktat malɗǝmcha fichile la sakang kus tǝ tǝrmbandaɗi, tǝ fa ɓanita ɓaknda ɓǝɗ'en. ");
INSERT INTO bvw_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ndangndǝwa: \"Mbǝsku alchit sǝt ichinatya ayi? Wun fǝrukǝ mbanda kǝ sǝni kanda?\" ");
INSERT INTO bvw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ngǝmang Yǝso kandǝwa: \"Ni sahami kuni ǝrta, ma fǝrinduni ngǝmkǝn kani ɓwa'anda kuni ndu wun fǝrikǝ alchit ichi nati sǝtya. ");
INSERT INTO bvw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ɓwa'ami ɓǝskǝ Yohanna alchit sa Baptisma nofcha ayi mɓǝnda Farǝ wa, ndu ɓǝɗa nifa?\" ");
INSERT INTO bvw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tǝrkaakǝndǝ halǝi'nda tinnanda mǝnat ma ndata? Ma ngǝmandǝm wa ɓǝnda Fara, nan ndatwa mǝ sǝk fǝruchituni kitta Yohanna? ");
INSERT INTO bvw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Paɗ ma ɗendǝm wa ɓǝnda nifa kanda lechanda nofcha kǝthlǝm tǝrkǝ nofchuwa, Yohanna tapǝnaa nakǝn. ");
INSERT INTO bvw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ndǝkǝn ndandǝnda Yǝso wa: \"Sǝnwaniwa. \"Ndang Yǝso kandǝwa: \"Njang paɗ ngi mbwa'andakuni ndi tǝ witǝ alchit mǝ la sittǝ pǝktat torchiyawa.\" ");
INSERT INTO bvw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tǝrkaakǝ Yǝso shunandǝ kandǝ tǝ sakǝt shundǝ ndakǝnwa: \"Nifǝsǝ nat hitǝ inabi ensi, tauraǝn hi tǝ thlara, rekǝn mbǝt yimmandǝ hwanchi inabi tǝkǝnsi, a tinkǝn kǝtǝn pu hitǝkǝnhar. Fǝrang na funǝ fa huɗatkǝn, kana pǝɗata hachahai somǝn. ");
INSERT INTO bvw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Saakǝ farǝ ɗamhwanchi inabi tǝkǝn, thlǝnkǝn mafat'en har ǝrtǝ kǝ mbǝɗa fichile tǝr kǝ hitiyu, kǝthlǝm kǝ thlangndǝ hwanchi inabi chiyu a hitǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Fa tǝr hitǝkǝn kǝsagndǝ mafaɗiyu tǝpangnda, kalkǝndǝndǝhi pǝɗakǝn har chaa. ");
INSERT INTO bvw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ngǝrkǝ lǝ hitiyu thlǝnna mafata kandǝ somǝn, erkǝndǝndi tǝpangnda in, sangndǝ ǝnnat harǝ fata. ");
INSERT INTO bvw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ngǝrkǝna thlǝn yuna, leya paɗ mbǝllangnda. Nakǝn kichu tǝ yakat fichile thlǝntǝn, funǝ tǝ tǝpangnda kanda funǝ tǝ mbǝllangndǝ kanda. ");
INSERT INTO bvw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","A tahkǝn nifǝ ǝrta, hwan lelǝ mbǝntǝn fatkǝn ka'ǝn. A mweshitkǝn lǝ hitiyu thlǝnkǝn ndi kǝ mbǝɗengnanda tǝ yarǝwa kittǝkǝn nanda fǝra mwanda hwe'engna. ");
INSERT INTO bvw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Fichile tǝrkǝ hitiyu ndangndandaniwa, Ale na sokta lǝ hitǝkǝnya a ɓama ɓǝma ɓǝllanda, kǝ sok hitǝkǝna i'nǝm. ");
INSERT INTO bvw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kǝssangnda a ɓǝllangnda, muhangndi murrut kǝnaɗi kǝ ɗiffitǝ hitǝkǝn.\" ");
INSERT INTO bvw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Sahang Yǝso kandǝwa: \"Saǝnkunifǝwa mǝnat lǝ hitiyu sǝta? Ni mbwa'anda kuni-nan mbǝlandǝ fa hundechiniyu kǝ fǝraǝn hitikǝna funǝ somǝn. ");
INSERT INTO bvw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Tamwuni changngandǝ iya hur yarat shiwuncha Farǝwowa? Ngwiyi chertǝ fatinda sokka kukuwun tinda. ");
INSERT INTO bvw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ndǝsǝta Lǝmwandǝniyu, paɗ ǝnat pǝɗandǝ kǝmfa hwanichengnǝm. ");
INSERT INTO bvw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Pǝktat fatǝr mbanda yahkǝndǝsa kǝsandǝ Yǝso kǝthlǝm mbǝssandǝwa fǝrkǝn sakǝt ɓǝɓi fa huɗechiniyu kǝ ɗar inchengnanda. Anakǝn kanda lechanda nofchi oiyu, kǝthlǝm ndǝkǝn mallangnda pǝɗaknda. ");
INSERT INTO bvw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Farǝle, thlǝnkǝ pǝktechǝ funa hur Farisiyawecha tǝ nofcha Hiridus, kǝthlǝm kǝ mbǝsangndǝ chit'hansara Yǝso hi, a hur shiwunchi nat na mbuta ɓah nanda kǝsanda. ");
INSERT INTO bvw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Satengnanda, ndangndǝwa: \"Malɗǝm, shinani wa sokǝn lǝkitchita. Nofchǝ uf ǝrta mbǝɗeku yah i'ndekusǝwa. Lasakawu mbanda Fara ɗi a ɗar kitchita. Nakǝnya mbwa'ana kani keekesi kǝ kwanani chamta ɓǝɗa Kaisar kapat kutura Romacha ndu nga keekesuwa? ");
INSERT INTO bvw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Anakǝn a mbǝssa Yǝso sakta kohat nofchǝkǝn, ndangnakandǝwa: \"Kǝthlǝmmǝ natuni ndǝfi kantara mban? Ɓamitǝn hanndǝmbǝlta Romawecha kǝ ni.\" ");
INSERT INTO bvw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ndǝkǝn ɓandǝndǝ ǝrta, sahkǝnwa, mirshingngiya tǝ thlǝmmǝ ɗarkǝnya i wuni?\" Ndangndǝwa: \"I Kaisar.\" ");
INSERT INTO bvw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ndang Yǝso kandǝwa: \"Fǝramna Fara i naka i Fara paɗ fǝranguni Kaisar i naka i Kaisar.\" Pǝɗang ǝnatkǝn kandǝfǝ ka'ǝn tǝ ngǝmtǝ'en. ");
INSERT INTO bvw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ɓak Sadukiyawecha mbǝs Yǝso, pǝktat fa tǝrmbanda fichile ndakwa thlatǝsa ɗiffitǝ mǝrtaɗǝwa. Sahangndǝmi tǝ ndatwa: ");
INSERT INTO bvw_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","\"Malɗǝm, yarang Musa kus tiya kanisi ndatwa, ma mir hwanman nifǝ kǝ hishnifa, meltǝ nuhnifihi nga hwechi'ensuwa, hwanmankǝn kǝ hishnifa nan kǝna reta kǝ ngalaǝn hwecha hwanmankǝntisǝ mǝrkǝyu, kǝthlǝm kǝɗa thlǝm hwanmankǝna mban. ");
INSERT INTO bvw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Hwanmanchisi muɗ kǝ hishcha, hwalat'hwankǝn thlekǝn perra, mǝrkǝn malutǝ hwehiwa, ");
INSERT INTO bvw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Chapatǝkǝn tǝrkǝn nuhmuruɗiyu kǝ nuhkǝn, mǝlan paɗ mǝrkǝn malutǝ hwehiwa. Sokkǝn kichu tǝ mǝkkatǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nakna mban kichuyu tuɓwaǝn hwanmanchi muɗyu malundǝ hwehiwa. A mweshitmikǝn ɓak nuhiyu mǝrta. ");
INSERT INTO bvw_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kǝthlǝm ndǝkǝn mbwa'ana kani, a thlata mǝmatcha nakna nat kǝ nuh wuni? Kǝthlǝm ufndǝ muɗ reɗndǝ tǝndi.\" ");
INSERT INTO bvw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ndang Yǝso kandǝwa: \"Ndǝkǝn sǝk la suchituni keeke kǝthlǝm sǝnwuni yarat shunda Faruwa, Paɗ sǝnwuni alchita Farǝwa. ");
INSERT INTO bvw_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Thlahmbǝɗi nat mǝmatcha thlata, mwa'u hishcha ret nishchǝwa, nishchi paɗ mwa'u ficha fǝrkanda kanwa. Naknda soktǝ nda fathlǝncha Fara hur'afshi. ");
INSERT INTO bvw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ɗar pathlǝ thlata mǝmatcha, awi tamwuni changnganda a hur ɗelwercha Musa wowa, a hur kusheng shiwun hurhwelii kǝskǝ hwatyu? Ndatwa njang naka Fara Ibrahim, Ishaku tǝ paɗ i' Yakubu.\" ");
INSERT INTO bvw_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mǝlan nga Fara mǝmatchǝwa, i' fa shisshingcha. Shiɗɗuni i'nguchik Keeke.\" ");
INSERT INTO bvw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ərta hur malɗǝmcha fa sakandǝ kussa Musa ɗi, thlarkǝnhi mbǝnniyu nakna sǝkkanda halǝ'i'ndǝ tǝ ndani. Mbǝssaǝn tǝndatwa Yǝso firtǝ ngǝmtǝ ndiichin, sahkǝnwa: \"Yen kus tǝni cheka nat mwanchina hur kuschi ufya?\" ");
INSERT INTO bvw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ngǝmang Yǝso wa: \"Le nak mwanchin ndǝkǝn naka, Sǝkama, Kunang Israilawecha, Lǝmwanda Farengnǝm mǝlan ǝrta na Lǝmwandǝ ndak. ");
INSERT INTO bvw_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Waat kǝ mbǝnnǝfat Lǝmwanda Fareku tǝ hanndǝkiketǝku uf, tǝ shisshingteku uf, tǝ yareku uf tǝ paɗ alchiɗeku uf.' ");
INSERT INTO bvw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Chapatǝkǝn paɗ ndǝkǝn naka, 'Kǝ yahnǝ le nattuni nduknduk nda i'yahtu i'ndeku.' Nga kussi si mbǝrangnga fichilehiya tǝ mwandǝwa.\" ");
INSERT INTO bvw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ndǝkǝn ngǝrandǝ malɗǝmti la sakangnga ɗǝwa: \"Keeke mbuutu malɗǝm. Mbwi nǝ kittǝkǝn ndatwa Farǝ ǝrta yunǝsǝ paɗwa. ");
INSERT INTO bvw_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Paɗ ashini ndiichinsi kǝ yah fichindǝ tǝ hanɗǝkiketǝ uf tǝ mbǝssandengnǝ uf, tǝ alchit uf, tǝ paɗ kǝ yahnǝ fichile natuni nduknduk nda i yahtu i'ndeku. Ndǝkǝn nak ndiichin oi sheraɗa fǝr us'i'chi tǝ fǝr pofǝnti yahtǝ ficha hur kustǝkǝn.\" ");
INSERT INTO bvw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kǝ mbǝsandǝ Yǝso wa nifiniyu a mbǝssaɗǝ ngǝmtǝ'en tǝ ɗathla, ndaǝnwa: \"Nganaku lanngǝ tǝ kuturichitta Farǝwa. \"Ɗiffitǝ ndǝkǝn yunǝsǝ sǝk alchit hanndǝkiketǝ kǝ ngǝrǝn sahhami paɗwa. ");
INSERT INTO bvw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nak Yǝso sakandaɗa hur kapat hura'a Fara, sahkǝnwa: \"Tǝkǝni lanat malɗǝmcha fa sakandǝ kus Musaɗi ndatwa, \"kǝrǝsti hweya Dauda nakǝn? ");
INSERT INTO bvw_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kǝthlǝm Dauda tǝ i'ndi'en a hur Shemeɗ Chiɗchiɗ, ndakǝnwa: \"Lǝmwanda ndangna Lǝmwandengnǝwa, sokuhi tǝ harsǝmtengna, kǝ fari nati ndǝf atikrechǝuwa ka sarǝcheku.\" ");
INSERT INTO bvw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dauda tǝ i'ndi'en eɗtǝndǝwa Lǝmwanda, tǝ kǝnǝ natna sokta hwe'en?\" Kapat humtǝhi kathlǝmat tǝ mbǝndǝfa. ");
INSERT INTO bvw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","A sakandǝ'enaɗi ndakǝnwa: \"Mbǝramsa malɗǝmcha fa sakaɗǝ kus tǝ tǝrɓandaɗi, la yahkǝnda witǝ tǝ pǝktat njelecha, kǝthlǝm kǝ ndang fichi ǝnna kandǝ tǝmwanda lumocha. ");
INSERT INTO bvw_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Paɗ la mbǝnangfata kanda kǝ mbǝsndi mbǝtsokchi ndiichin a mbǝt humta Yahudawechihi, tǝ mbǝt rǝɓcha. ");
INSERT INTO bvw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kandang harǝfatsǝwa la naknda sǝmandǝ i'cha ndǝlat nishchi mǝrtǝ hishchengnanda, tǝ hwandǝ toltol a hur nofcha nda ka fa tǝrmbanda. Kǝthlǝm ndǝkǝn nanda sat ɓahtǝ ka'ǝn.\" ");
INSERT INTO bvw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sokkǝ Yǝso nduktǝ yokǝt ngom hanndǝmbǝlta a kapat hura'a Fara, nakna nata kǝlandǝ nofchi naka muh hanndǝmbǝltengnanda hur yokǝt fǝr poffǝn tǝkǝn. Hurrumchi oi muhkǝ hanndǝmbǝlchǝ ka'ǝn. ");
INSERT INTO bvw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","A ɓak nuhnifǝ lǝ ɓahta le mǝrtǝ sǝmahha, somkǝn mbuthl kopo chap kǝ hurkǝn, le sokka pene ǝrta. ");
INSERT INTO bvw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ak Yǝso kimshechi'en kǝ thlǝmatkǝn, ndangna kandǝwa: \"Kitchitkǝn nati mbwa'anda kuni, i'fǝrtǝ ndǝlat nuhhi mǝrtǝ sǝsmahya, mbǝranda i'chika wunhi uf. ");
INSERT INTO bvw_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kandang ufya fǝrkǝnda hur kǝnechengnanda, mǝllan paɗ a hur ɓahtǝ'en fǝrtǝn uf i'tahangsa nat'en.\" ");
INSERT INTO bvw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nak Yǝso malǝ kapat hura'a Farǝhi, ǝrta hur kimshechi'en ndakǝnwa: \"Malɗǝm, nu witǝ pǝktat ngwichiya tǝ pǝktat tinchiya.\" ");
INSERT INTO bvw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ndang Yǝso wa: \"Nga neɗnǝ pǝktat tinchiyawa? Nga yunǝsǝ natficha mala mbǝnniyu chika ǝrtǝwa paɗ ngwisǝ nat ficha mala ɗar shekkǝn nguchitficha wuwellandǝhiwa.\" ");
INSERT INTO bvw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Paɗ sokkǝnna ɗar shohla Zaitun le naka kǝllarǝ kapat hura'a Fara. Bitrus, Yakubu, Yohanna tǝ Andarawus ɓakndǝ i'chitnanda ɓuɓweeta sahangndǝwa: ");
INSERT INTO bvw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","\"Mbwa'andǝna kani, kwat nat i'chiya sǝta? Mǝnaka sakǝtkǝn na chetǝwa a shee farǝ sǝta i'chiniya?\" ");
INSERT INTO bvw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ngǝrkǝ Yǝso sǝwa, \"Ndǝffam i'ndǝsi mǝ shekɗa yunǝ kuniwa. ");
INSERT INTO bvw_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kǝthlǝm nofchǝ oi na ɓata hur thlǝmnǝ tǝ ndatwa, 'njang naka kǝrǝsti.' Nanda lǝm nofchǝ oi. ");
INSERT INTO bvw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Paɗ ma shikunǝ pathlǝ mbecha tǝ kusheng mbecha, mǝ lechiɗuniwa. Waat i'chiniyu nat kǝssǝn kichu, paɗ mweshitkǝn sa'u kwandǝnwa. ");
INSERT INTO bvw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Hǝmtǝ nan thla'anda hǝmtǝ fa, kuturichit paɗ nan thla'anda kuturichita fa. Na ficha sǝk hǝhǝrta hachahaifa mbechǝ somsomǝn a kisshita, tǝ paɗ na mita natsi. I'chininatyu tǝrka pwanchǝ kwaɗǝn, mwee funa ɓata. ");
INSERT INTO bvw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","\"Kǝ sokuni tǝ tahhasǝfa ma i'chiniyu tǝrka thlata. Nanda ndǝttǝkuni kǝ mbǝt sakmicha, paɗ nanda tǝppanda kuni a mbǝt humta Yahudawechahi, paɗ nuni thlara ɓanitǝ pǝktat nofcha tǝ kuturcha kǝthlǝm thlǝmna, paɗ nuni mbǝs mba mbwa'a kusheng shunda kandǝ kǝ ɗar i'ndengna. ");
INSERT INTO bvw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kǝthlǝm kusheng shundǝ mbinchin nat ficha tǝrka ɓassanda hǝmchǝ nat. ");
INSERT INTO bvw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ma harandǝ kuni ɗǝɗndǝ tǝ kuni mbǝt shunda, mǝ thla'i hur in'chengnuni kǝ ɗar i'natuni mbutǝwa. Mbwa'am i'mbwa'andǝ Fara kuni a mbǝnniyu, kǝthlǝm nga kunang na shundǝwa Chiɗchiɗ tǝ Shemeɗ ndak na shunda. ");
INSERT INTO bvw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Paɗ hwanmanda nan fǝr hwanmankǝn kǝ ɓǝlang ficha, Shindǝ paɗ nan fǝr hwe'en, paɗ hwecha nanda thla'anda parchinandǝ fa, kǝ ɗǝfndǝ kǝ tǝkang fichǝ kandǝhi. ");
INSERT INTO bvw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Paɗ chikawun nan cherǝ kuni kǝthlǝm thlǝmna. Paɗ le kǝrǝskǝ kǝ ndukwatkǝn nan hǝrǝkta. ");
INSERT INTO bvw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","\"Farǝkǝnaɓata ma mbishuni ǝnat tǝkǝmta le na ɓat tǝ pwancha a thlerhi mbǝɗi kamuchiksi, (Lǝ changngatkǝn kǝ sǝnǝn): \"Fichile naka Yahudiya kǝ rahnda shohlacha. ");
INSERT INTO bvw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Le naka afshi a ɗar kǝnnda mǝ tǝriɗahai kǝ yimka huriwa nan tǝr ǝnwa. ");
INSERT INTO bvw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Le naka hi mǝ ngǝriɗa huri wa nan tǝr ǝnat suptǝ'enwa. ");
INSERT INTO bvw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ai kǝmbǝɗa nishcha fichile tǝ hwechahur tǝ fichile tǝ hwecha hǝsǝr a hur munchiniyu. ");
INSERT INTO bvw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Hwanama mǝ si ichiniyu a hur mbitǝuwa. ");
INSERT INTO bvw_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","A thlah mbǝɗiniyu, na pwancha natsi le tamu chit ficha nata kǝ sǝt Farǝ kishita kǝ ɓukweya, paɗ ngu ficha ngǝrandǝwa kǝ ndukwatkǝn. ");
INSERT INTO bvw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Manga i'nakǝn tahha Lǝmwandǝ hanmunchikǝnhiwa nifǝsi na hǝrǝktǝwa, Paɗ kǝthlǝm tachikǝnharti taatǝn, ndǝkǝn sǝk tahandǝn hanmunchikǝnhi. ");
INSERT INTO bvw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mǝnda yuna kuniwa, \"Nama, a Kǝrǝstiya, ndu 'mǝlan taatiyu' mǝ fǝriɗuni kitsǝwa. ");
INSERT INTO bvw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kǝthlǝm fa lekchisi na chetakish wa kandang naka kǝrǝsti, tǝ tapǝnecha i'lekta, paɗ kǝnanda sǝt ǝnat pǝɗandǝ nifǝfa kǝthlǝm kǝ shekɗangndǝ nofcha, manan sǝta chika tachikǝnhara Fara. ");
INSERT INTO bvw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kǝ ndǝfuni i'ndǝsi, mbwa'aɗi chikama kuni leɗya. ");
INSERT INTO bvw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ɗiffitǝ Pwanchini hanmunchiniyu, hwatfarǝ nan yimta hulta, ndǝrra'a ngu fǝr ɗwachitwa, ");
INSERT INTO bvw_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Handǝrechǝ paɗ nanda nata hǝhatta haya afshi, alchita afshi nan hǝhǝrtǝfa. ");
INSERT INTO bvw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ɗif fitǝkǝn chikawun nannat hweya nifa ɓata hur hussomɓa tǝ kapat alchit tǝ mwanda. ");
INSERT INTO bvw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kana thlǝn fathlǝnchi'en kǝ ngommangndǝ tachikǝn'en chika aya hurkishita, thlata ndukwat kukunchi fwaɗa a kishita thlata ndukwat kishitǝ kǝ le. ");
INSERT INTO bvw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Nakǝnya sakam ǝna ɗar affǝt shuɓwata. Ma mbisshuni tirkeetǝ njarǝhi mǝla titita, kǝ sǝnunisǝwa fektǝ ndukhi. ");
INSERT INTO bvw_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kichu paɗ, ma neɗnduni ichiya sǝta kǝ sǝnunisǝwa ɓat'en ndukhi mǝla mi kǝnnda. ");
INSERT INTO bvw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kitchitkǝn nati ɓwa'anda kuni, naɗihi nakǝnya ngu mbǝrtǝhiwa, sema shiɗ i'chinatyu. ");
INSERT INTO bvw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Afshi tǝ kishita nanda thlǝrǝttaɗi, paɗ shundengnǝ ngu tamta thlǝrǝttaɗǝwa. ");
INSERT INTO bvw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Paɗ nifǝsǝ sǝnkǝ farǝkǝn ndu hanthlikǝn kurmi fari nat i'chiniyu sǝta, chika fathlǝnchikǝna hur afshi ndu hwankǝn tǝ'i'ndǝ'en. Shindǝ sǝnkǝ ndak. ");
INSERT INTO bvw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nakǝn sǝnwuni fari nat farǝkǝna ɓatwa, sokam tǝ tahhasǝfa. ");
INSERT INTO bvw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","\"Ɓata hweya nifa naknanat nda nifǝ na sǝt witǝ langnga, ma meltǝ huraahi, saka'ǝn tora mafechi'en, chika wun tǝ tor'en, ndangna lǝ pu mimbangkǝnharwa, kǝ ndǝfǝn i'ndǝsi kǝ fari natna ngǝrandǝ'in. ");
INSERT INTO bvw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chika kunang kǝ ndǝfuni i'ndǝsi, kǝthlǝm sǝnwuni fari nat lǝ hura'a ɓataɗǝwa, ndu farǝhufta, hurɗiffitǝ findǝkta, katǝt ɓǝta, mbahya ɓingta. ");
INSERT INTO bvw_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ma ɓeɗ kurukchuk mǝ ɓiɗa mbǝsandǝ kuni saɓweniwa. ");
INSERT INTO bvw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","I la ɓwa'aɗi kuni, la ɓwa'ayi chikawuni kǝ sokuni tǝ tahhasǝfa.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tahkǝ mundǝ chap kǝ safichǝ chohhǝmtala tǝ i'chi njohma le nguchit mehɗǝsafi'en. Le nak mwanchina hur pǝrischa tǝ malɗǝmcha fa sakandǝ kussa ɗi, naknda kat mba kǝsandǝ Yǝso ɓuɓweeta kǝthlem kǝ ɓǝlangnda. ");
INSERT INTO bvw_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kǝthlǝm lǝ ndakndǝwa: \"Ngǝma sǝt iya hur njohhǝmiyawa, mǝni nofcha thla'andǝhur'i'nda.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yǝso mǝla Betani hura'a Siman le nat tarkwindafi'en soh. Mǝla ɗar sǝm'ǝna, yimkǝ nuhnifǝsi tǝ kwescha kupat tahǝstǝfichi tǝ pundala, tǝ fiɗeta hurkǝn le nat satǝ'en mbinchinfa la atfichuwa nardi, la hiikǝfichǝ tǝ hanɗǝɓeltǝ oi, chaǝn kupaɗihiyu thlǝraǝn fiɗetkǝna Yǝso in. ");
INSERT INTO bvw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nofchi naka mbǝnniyu sǝɓkǝ hanɗǝkikecheng nandaɗi tǝ i sǝt nuhiyu, ndangndandaniwa: \"Kǝthlemmǝ natna sǝɓandǝ fiɗeɗiɗǝ lahiitǝfichǝ tǝ hanɗǝɓeltǝ oi kicheya? ");
INSERT INTO bvw_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Matǝ hi'yangfichaɗiya manaficha mbǝs hanɗǝɓelta i sherangnga aru kumchit kum mǝkkan, kǝ fǝrangficha fa ɓahcha.\" Ɓokangnda nuhihiyu ka'ǝn. ");
INSERT INTO bvw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ndak Yǝso wa: \"Malamǝn nuhhiniyu! Kǝthlemmǝ natuni ɗahandǝ'in? Shiɗtǝ'ǝn ndiichin. ");
INSERT INTO bvw_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Faɓahcha pware a hurnuni, nuni mbǝlla kǝsandakandǝsi chikakwat yahtuni. Paɗ nga njang tǝ kuni pwareewa. ");
INSERT INTO bvw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nuhhiya shiɗtǝ i natna mbǝla sita. Thlǝriɗǝ fiɗetafa a tah'saɗǝ faɗengnǝ kǝ fari natficha thlohita. ");
INSERT INTO bvw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kitchitkǝn mbwa'andi kuni, uf mbǝɗi nat nofcha ɓasǝ kusheng kashunda hur kishitǝ nat, nanda mbu i sǝt nuhhiya, kǝthlem kǝ kuɗukfichǝndi.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yahuda Iskaryoti ǝrta hur kimshecha Yǝso kumkǝngǝrǝnsǝ chap, ɗǝkna mbǝɗa Pǝktat Pǝristchǝkǝn kǝthlǝm kǝ hi'yangka ɗi. ");
INSERT INTO bvw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Sǝkkǝndǝ i yahtǝna sǝta naknda kwala, ndǝkǝn tahsaɗǝɗǝhiwa nani fǝrru hanɗǝɓǝlta. Mbǝnniyu ngagtǝ Yahuda kat mbayi natna hi'ya Yǝso kanda. ");
INSERT INTO bvw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Saakǝ tǝrka farǝ chi njohǝm chohhǝmtala le nguchit mehnɗǝsa fi'en, le lǝ thlet fichǝ ɓurat hanshohrata, ndang kimshechi'enwa: \"A ai yahtusi kǝ tahsukani mbǝt chi njohǝm chohhǝm talǝkǝnsi?\" ");
INSERT INTO bvw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","A thlǝnkǝn kimshechi'en chap ndagnna kaɗewa: \"Ɗama hur hǝmta, nuni kǝmtǝ tǝ nifǝ mǝla rǝf ɓǝt ama, kurunindi, ");
INSERT INTO bvw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","uf huri'i yimtǝn, ndangnguni lǝ hurikǝn wa: \"Ndak malɗǝm wa a ai kǝtǝn romchi natti chi njohhǝm chohhǝmtala kanang tǝ kimshechengna?' ");
INSERT INTO bvw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nan cheɗa kapat kǝnnda kuni afshi le taptǝficha kǝ tahsangficha. Mbǝnniyu natuni tahsǝ njohǝmkǝna kǝmsi.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kimshechiyu malkǝdǝ mbǝnnihiyu pǝɗaknda hur hǝmta, ɗǝknda mbisandǝ uf ichi sǝka nda i mbutǝ Yǝso. Tahsangndǝ chohhǝmtalǝkǝnhi. ");
INSERT INTO bvw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ɗiffitǝ hǝmta fara Yǝso tǝ kimshechi'en kum kǝngirǝnsǝ chap ɓaknda hurikǝn. ");
INSERT INTO bvw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kanda ɗar sǝm'ǝna, ndak Yǝso wa: \"Kitchitkǝn nati mbwa'anda kuni, ǝrta hurnuni nan hi'itaɗi, le natani sǝm'ǝn tǝndi.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kǝ sǝktǝ kimshechi'en kichu sǝɓkǝ hanɗekiketeng nandaɗi, tǝrƙaakǝnda sahandǝ ǝrtǝ ǝrta tǝ ndatwa: \"Njang wa?\" ");
INSERT INTO bvw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ngǝrkǝnsuwa, ǝrta hurnuni kumkǝngǝrǝnsi chap le natani sǝmta hur tǝɓi ǝrta. ");
INSERT INTO bvw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Andiya hweya nifǝ nan ɓǝɗata, nda i yarandǝfichǝ kushengkǝnhi nattǝ kichu, ai kǝ mbǝɗa nifi yahkǝsa fǝr hweya nifa! Kweshkǝna ngǝtufichǝndǝwa.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Naknda ɗar sǝm'ǝna, tǝrkǝn njohma saǝn usoko Fara, chichaǝnhi fǝrangna kimshechi'en, ndagna kandǝwa: \"Thlama; leya faɗegna.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ɗiffitǝkǝn tǝrkǝn tǝpsat ama, a sǝkǝn usoko, a fǝrangna kanda sakndǝ ufnda ");
INSERT INTO bvw_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","\"Leya fwarengna le thlerandiɗi kǝthlem nofchǝ oi.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","\"Tǝni mbwa'a kitchitkǝna kuni thlatǝ nakǝnya kǝ mban mwaawi sat ǝnwa magnga fari natisat yuwakǝnna hur mwanda Farǝ wa.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","In'kǝndǝ imsha, pǝɗaknda kish kǝ shohla Zaitun. ");
INSERT INTO bvw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kanda ɗar wita ndang Yǝso kandǝwa: \"Uffuni nuni rahta maluni nji i'chitna. Nda i yarandǝ fichǝ ndatwa, 'Ni ɓǝlandǝ la hǝrǝmta, shohrechikǝn nanda wuwelǝhi.' ");
INSERT INTO bvw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ɗǝk na mban tǝndandǝ wa ɗiffitǝ thlatengna tǝ shisshingta ni lata Galili mǝ kunang\". ");
INSERT INTO bvw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ndang Bitrussa Yǝso wa: \"Njang ngi malǝsǝhiwa chika rahkǝ tahchikǝn nat.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ndang Yǝso Bitrus wa: \"Kitchitkǝn nati mbu'uta fiɗǝkiya kǝ kukwara ɗektǝ chap nu kurɓadǝ halǝ indǝ mǝkkan tǝ ndat wa sǝnunǝ njiwa.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Chika tǝ kichu nak Bitrussa kurɓandǝ mbuta tǝ alchita ndatwa, chika tǝna ficha tǝkkandǝkǝmhi hwaa ngi tamta halǝ i'ndǝwa sǝnwisǝwowa!\" Natnda ndakndǝ kichu. ");
INSERT INTO bvw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ndǝkǝn saatǝnda mbiɗǝ la atfǝchiwa Getsemani. Ndangna kimshechi'en wa: \"Sokamhi mbiɗya, kǝ ɗi hwanda.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tǝrkǝn Bitrus, Yakubu tǝ Yohanna, tǝrkaakǝn sǝk ɓahtǝ ka'ǝn, mirfat'ennaɗi. ");
INSERT INTO bvw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ndangnakandǝwa: \"Shisshingtengna mǝlla nat pwanchǝ ka'ǝn. Thlaramhi mbiɗya kǝ nuni kǝlathi.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ɗǝkna mban nguɗeh hǝmkǝnhi hachaya nakna hwandǝ tǝ ndatwa: \"Ma mbandǝsi mǝ niɗi pwene ti naka ɓatyuwa.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ndakǝnwa: \"Papa, Papa, ǝnsǝ nak 'yang'yang nga mbǝɗekuwa. Tǝrran pwene tiɗaɗi fi'engnǝya. Chika tǝ kichu nga i yahti natu sǝtwa iu'wa. ");
INSERT INTO bvw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ndǝkǝn ngǝrandǝn ina thlemat kimshechi'en ɗǝkna mbǝsandǝ kanda sa ɓweni. Ndangna Bitrus wa: \"Bitrus, nanna sa ɓweni? Awi nguna mbǝlla soktǝ tolla a kǝlat chika i hanthliktǝ ǝrtǝwa? ");
INSERT INTO bvw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Sokam tǝ tahasǝfa kǝ nuni hwanda kǝthlǝm mǝhǝmiɗuni hur yah'ichǝwa. Paɗ tir shemeɗa nat tǝkichu fatkǝn tǝrruwa.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ngǝrkǝnna ngǝrrandǝ'in kǝthlǝm kǝ hwanin, nakna ngǝrrandǝ shuni shuwuntǝn soh. ");
INSERT INTO bvw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ngǝrkǝna ɓata thlemat nanda ɓakna mbǝsandǝ kanda saɓweni, kǝthlǝm uf nda nǝhǝɗ ɓweni hwanichengnandǝ ka'ǝn, ɓahkǝndǝ i nan nda mbwa'anda. ");
INSERT INTO bvw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ngǝrkǝna thlǝmatnanda i mǝkkatǝkǝn, ndangna kandǝwa: \"Paaya mwakuni saɓweni kǝnuni yipta? Shik kichu, shee farǝkǝn. A fir fichi hweeya nifa kǝ hara fa ɓǝɓichitfata. ");
INSERT INTO bvw_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Thla'ama, tama. nama, nifina hiiyandaɗaɗi mǝlanya!\" ");
INSERT INTO bvw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Chatkichuyu, kǝ nanna ngǝlandǝ mi'en, ɓak Yahuda ǝrta hur kumngǝrǝnsǝ chap tǝkǝn tǝ nofchǝ oi tǝ thlohcha tǝ sǝssalcha, pǝktat pǝristcha tǝ malɗǝmcha fa sakandǝ kusaɗi, tǝ pǝktechi thlenkǝ kanda. ");
INSERT INTO bvw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Kǝthlǝm nifi hi'yangngaɗiyu teppa mweshandǝ tǝ ndatwa: \"Le natti mbǝnfatkǝnyu mǝlan naka nifǝkǝn. Kǝ kǝsangnguni kǝ pǝɗuni tǝnda har.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kǝ saatǝn ɗǝkna mbǝs Yǝso ndaǝnwa: \"Lǝ hura'a.\" Nakna mbǝnfatkǝn tǝ kǝmmiya. ");
INSERT INTO bvw_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Chatkichuyu njo'angnda kǝsangnda. ");
INSERT INTO bvw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ərta hurnandǝ le nak kit, kǝtkǝn thlohtǝ'en chathlaǝn thlemata mafata kapat Pǝrist tǝkǝnnaɗi. ");
INSERT INTO bvw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ndang Yǝso kandǝwa, ɓakuni tǝ thlohcha tǝ sǝssalcha kǝthlem kǝ kǝsikuni nda tǝni hara? ");
INSERT INTO bvw_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Hanmunchikǝn kǝm nang tǝ kuni nja sakandaɗa hur kapat hura'a Fara, nattǝ kichu kǝsiwuniwa. Sǝk fichǝ kichuyu kǝthlǝm kǝ nǝhɗang fichǝ i mbutǝ laulawatkǝn. ");
INSERT INTO bvw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Mbǝnniyu ɓak kimshechi'ena cherǝndǝfa, rahkǝnda. ");
INSERT INTO bvw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Han kimshasi tǝ ɗǝ supta fa, kuwurkǝn ndi. Njo'angnda, ");
INSERT INTO bvw_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","mǝllan mallaǝn ɗǝ supkǝna kanda, rahkǝn tamkwal. ");
INSERT INTO bvw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mbǝnniyu Pǝɗak ndǝ tǝ Yǝso kǝ mbǝɗa kapat pǝrist. Nat pǝktat pǝristcha tǝ fambanicha tǝ malɗǝmcha fa sakandǝ kussa ɗi ngomkǝnda thlǝmmatkǝn. ");
INSERT INTO bvw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Bitrus nakan langnga nattǝkichu kuwurkǝnndi, kǝ hura'a kapat pǝrist tǝkǝn sokkǝnna thlemat fa pu hurikǝnhar nakna tǝk hwata. ");
INSERT INTO bvw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mbǝnniyu pǝktat pǝristcha tǝ pǝktat fasakmichǝ uf nda naknda kat sakǝt shuni nannda ɗǝftǝ kǝ ɗar Yǝso, kǝthlǝm kǝ mbǝsndǝ kǝ ɓǝlangnda, nattǝkichu mbǝsundǝ mbandǝwa. ");
INSERT INTO bvw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Paɗ nofchǝ oi shuwunkǝ lekta ɗar i'ndi'en paɗ ɓu miyengnandǝ ǝrtǝwa. ");
INSERT INTO bvw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ɗiffitǝkǝn paɗ thlaakǝ funǝ tǝ lektǝ kǝ ɗar i'ndi'en ndatwa: ");
INSERT INTO bvw_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","\"Shikanindi ndatwa, 'ni hokkandǝ kapat hura'a Farǝhi le tintǝ fichǝ tǝ harcha, paɗ hur mundǝ mǝkkan ni tinnanda kwarkǝn nga tǝ harchǝwa.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Chika tǝ kichu shundengnandǝ ɓu ǝrtǝwa. ");
INSERT INTO bvw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","A mbǝnniyu thlaakǝ kapat pǝrist thlarkǝnhi kit kǝ hurɗifitǝnanda sahaǝn mi Yǝso tǝ ndatwa: \"Nga ngǝmtekusǝwowa? A ɗar witǝ i'chi mbutǝ ficha i'ndekuyawowa?\" ");
INSERT INTO bvw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ngaskǝn ɓa ngǝrawusǝwa. Ngǝrkǝ kapat pǝrist tǝkǝnna sahandǝ paɗ: \"Sokǝn naka Kǝrǝsti, hweya Farǝwa?\" ");
INSERT INTO bvw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ndak Yǝso wa: \"Njang.\" \"Tǝpaɗ nuni nat hweya nifa ɗassa harsǝmta le nak mwanchin mǝla ɓatahaya hur afshi hur husomba'a.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ndǝkǝn thlǝthlahandǝ kapat pǝrist tǝkǝn njela'enaɗi, ndakǝnwa mǝnatma ngǝrkata mbǝɗ'en paɗi. ");
INSERT INTO bvw_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","\"Sǝkam witǝ njir faɗi sǝtǝn: \"Mǝ nattuni?\" Uf nda thlangndǝ kitahi tǝ ndatwa keekesi kǝ mǝrkaɗi. ");
INSERT INTO bvw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Chatkichuyu tǝrkaakǝ funa chaha yahtafa, kǝnangndǝ hwanichi'en, tǝtǝpangndǝfa, ndangndǝwa: \"Mbwa'ana kani wun tǝpkǝsa.\" Fa pu kapat hurikǝnhar mbwaltakǝnndi. ");
INSERT INTO bvw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Bitrus mǝllan ndassa hachahaya fǝlhura'a, ɓak nuhhwee ǝrta hur mafecha kapat pǝrist. ");
INSERT INTO bvw_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nakkǝn Bitrussa tǝk hwata, nakna kǝllandǝ ndakǝnwa: \"Sokǝnma, kunang nak tǝ Yǝso Lǝnazarattaɗiyu.\" \"Ndaǝnwa kunang nak tǝ Yǝso Lǝnazarattaɗiya. ");
INSERT INTO bvw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Paɗ halkǝn i'ndǝ ndakǝnwa: \"Njang sǝnwi i natu shunda ɗarkǝnwa. Paɗ mbǝssawiwa!\" Cheknakish kǝ mi mbanga. Chatkichuyu kukwarkǝ ɗekta. ");
INSERT INTO bvw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mafat nuhhwaniyu nakǝnndi, ngǝrkǝn ndanda fichile kitkitta mbǝnniyuwa: \"Nifiya mǝlla hur nanda.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ngǝrkǝna halǝ i'nda. Toppǝ kicha paɗ fichile kitkityu ndangnda Bitruswa: \"Kitchitkǝn sokǝn paɗ naku ǝrta hurnanda, kǝthlǝm sokǝn lǝ Galiliyawata.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nakna cherǝ i'ndi'en kǝnna nata at'i'chimi tǝ ndatwa: \"Sǝnwi nifi natuni shunda ɗarkǝnwa.\" ");
INSERT INTO bvw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Chatkichuyu kukwarkǝ ɗekta i chapatǝkǝn. Kuɗukkǝ Bitrus tǝ shuni mbwa'andǝ Yǝso ndatwa: \"Kǝ kukwara ɗǝktǝ chap nu kurɓandǝ halǝ i'ndǝ mǝkkan ndatwa sununǝ njiwa.\" Kǝ kuɗǝktǝn shuwunkǝn chat nakna tita. ");
INSERT INTO bvw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kǝnat ɓǝta wenda mbingtǝ tung, pǝktat pǝristchikǝn tǝ pǝktat fambanicha tǝ malɗǝmchǝ fa sakandǝ kussa Musa ɗi, tǝ pǝktat fasakmicha tahsangndǝ hi. Ɗǝkǝn kǝnandǝɗǝ Yǝso pǝɗakndǝ tǝnda mbaniti Bilatus. ");
INSERT INTO bvw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Sahang Bilatus mi Yǝso tǝ ndatwa: \"Sokǝn naka kutur Yahundawechǝwa?\" Ngǝmaǝn'en tǝ ndatwa: \"A mbwinǝ keeke.\" ");
INSERT INTO bvw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nak pǝktat pǝristchikǝnna nata muh hanharkǝn kǝ ɗar i'chǝ oi. ");
INSERT INTO bvw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ngǝrkǝ Bilatus sahami tǝ ndatwa: \"Nga ngǝmtǝsi natu ngǝrtǝsǝwowa? Nu yakat kohat shuwunchi nannda mbutǝ kǝ ɗar i'ndekuyu.\" ");
INSERT INTO bvw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yǝso paaya ngǝrausǝwa, pǝɗang ǝnnatkǝn Bilatus fa. ");
INSERT INTO bvw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ma shee farǝ chohhǝmtala Bilatus lakalkǝn nifǝhi ǝrta hur pursunacha le sahtǝnda. ");
INSERT INTO bvw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Hur fa thlahur in'chi pursunayu yunǝsǝ mbǝlkǝfata le la atfichǝwa Barnabas. ");
INSERT INTO bvw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ɓak ngom nofchǝ oi tǝrkaakǝndǝ hwanandǝ Bilatus kǝ saǝn kandǝ nda i'sǝntǝnhi tǝ sandǝ kanda. ");
INSERT INTO bvw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ndǝkǝn ngǝmmandǝn engnanda: \"Yahkunisi kǝ kallayi kutur Yahundawecha kuni hiwa?\" ");
INSERT INTO bvw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kǝthlem mbǝssaɗiwa tǝ nan'nda sǝrǝhndi, ndǝkǝn nat pǝktat pǝristchikǝna fǝrndi. ");
INSERT INTO bvw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pǝktat pǝristchikǝn chikangndǝ nofchikǝn, kweshkǝn kǝkalaǝn Barnabassa kandǝ hi. ");
INSERT INTO bvw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ngǝrkǝ Bilatussa ndanda kandǝwa: \"Mǝnati sandǝ nifi lǝ atuniwa kutur Yahundachiya?\" ");
INSERT INTO bvw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ngǝrkǝndǝ hwata tǝ ndatwa: \"Kukanhi!\" ");
INSERT INTO bvw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ndang Bilatussa kandǝwa: \"Kǝthlem mi? witǝ ɓǝɓifat mǝ sǝtǝn?\" Chika tǝ kichu thla'angndǝ mburat uf ndǝ tǝ alchita ndakndǝwa: \"Kukamǝn hi!\" ");
INSERT INTO bvw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Bilatus yahkǝnsa tǝra hur ngom nofchihiyu kalaǝn Barnabassa kandǝ hi. Ɗifitǝ tǝppi tǝpandǝ fathlǝrhwecha Yǝso fǝrangna kanda kǝ kukwangndǝhi. ");
INSERT INTO bvw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pǝɗak fathlǝrhwechǝ tǝndi kǝ huri kuturichita, kǝ hur huri kuturichita, akndǝ tahǝt fathlǝrhwatkǝn nat. ");
INSERT INTO bvw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pangndǝ njeli kuturichit ngah nda am fi mbillehsheta, tahǝskǝndǝ fwa'in ndahha pangnda in. ");
INSERT INTO bvw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tǝrkaakǝndǝ nda ǝnna: \"Mbwarǝ shisshingta kǝ mbǝɗeku kutur Yahundawecha!\" ");
INSERT INTO bvw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Naknda rǝrro'a ndǝffa'in tǝ sǝssala, naknda chahha yahta fa, tǝpaɗ naknda kopandǝhi wa tǝnnda fǝra mwanda. ");
INSERT INTO bvw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kǝ mweshandǝndǝ njirndi, kǝtangndǝ njeli'ihi fi'en ngah nda am fi mbillehshetyu pangndǝ ikǝn. Pǝɗakndǝ tǝndǝ kǝthlem kǝ ɗǝnda kukwandǝhi ɗar palita. ");
INSERT INTO bvw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kanda ɗar mbǝrtǝhi tǝ Yǝso mǝlla rǝf palitǝ'en, chat a nifiya lenat thlemkǝn wa Siman lǝ Sayirinta, shinnda Alekzanda tǝ Rufus, mǝla ɓata thlet hǝmta ɗǝfkǝndǝndi waat kǝtǝrǝn palita Yǝso. ");
INSERT INTO bvw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pǝɗakndǝ tǝ ndi kǝ mbǝɗi lǝ atfichǝwa Golgota (sakatkǝn wa mbǝt tǝɓ i'nda\"). ");
INSERT INTO bvw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","A mbǝnniyu fǝrrangndǝ am'innabi le kurtandǝndǝhi tǝ mur, cherkǝn sata. ");
INSERT INTO bvw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kukangndǝhi ɗar palita, sakangndǝ njela'en hi thlerǝnanda, naknda tata kǝthlem kǝ sǝnndǝ i'nat chikawuna mbǝsta. ");
INSERT INTO bvw_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kukangndǝhi tǝ hanthlǝktǝ hanherta i'ɓingta. ");
INSERT INTO bvw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","A yarandǝ ǝnat sǝnkǝn kǝ ɗarkǝn: \"Kutur Yahudawecha.\" ");
INSERT INTO bvw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mbǝnniyu kukangndǝ hi tǝ harchǝ chap, ǝrta harsǝmtǝ'en ǝrta hishingtǝ'en. ");
INSERT INTO bvw_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Leya ndǝkǝn na nǝhata laulawathi, ndakwa a thlǝkfichǝnda hur fa cherǝ thlǝn i mbutǝ kus.\" ");
INSERT INTO bvw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nat nofchi naka mbǝrtǝhi tǝ mbǝnniyu, naknda hǝhrandǝ i'nda kǝnnda shuwun ɓǝɓi icha ɗar Yǝso tǝ ndatwa: \"Yu! sokǝn ti ndakwa, nu hokandǝ kappat hura'a Farǝhi paɗ kǝ tinangna hur munchǝ mǝkkan, ");
INSERT INTO bvw_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","hǝrkandǝn i'ndeku hacha, kǝ tǝrnahaya ɗar pali'iya!\" ");
INSERT INTO bvw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kichu paɗ pǝktat pǝristcha tǝ malɗǝmcha fa sakandǝ kussa ɗi, lǝ naknda shuwun njirndi a thlerǝnanda, lǝ naknda ndatwa: \"Hǝrkaɗǝfuna: \"Ngu hǝrkandǝ i'ndi'enwa. ");
INSERT INTO bvw_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kǝ tǝr Kǝrǝsti haya kutur Isra'ilawecha, kǝ tǝrkahaya ɗar palikǝn chetchetya, tǝkichu natma nata kǝ fǝrǝmkita ɗarkǝn.\" Fichile kukandǝ fichikandǝ tǝndi i'erandǝfa. ");
INSERT INTO bvw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Hanthlǝktǝ kumkǝngǝrǝnsi chap i hur fara, ngǝlang hultǝ hachahaikǝn nat, kǝ hanthlǝktǝ mǝkan i farǝhufta. ");
INSERT INTO bvw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kǝ saatǝ hanthliktǝ mǝkan, tik Yǝso tǝ kapat mburata, ndakǝnwa: \"Eloi, Eloi, lama sabatani?\" sakǝtkǝn wa: \"Ai Fara, Ai Fara, mǝsǝk chertunji?\" ");
INSERT INTO bvw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Fichile thlarkǝ nduk tǝndi kǝsǝktǝndǝ kichu ndakndǝwa: \"Sǝkama mǝla at Iliya.\" ");
INSERT INTO bvw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Rahkǝ yuna hurnanda ɗǝkna tǝnnandǝ ǝn nda hussunnjela'a, tǝ am tamnda fakkǝna sǝssala, fǝrangna Yǝso kǝ san, ndakndǝwa, \"Pwa'ama, kǝnǝm ma na Iliya ɓata tǝrandahaya ɗar pali'i'ya.\" ");
INSERT INTO bvw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Chatkichu shuwunkǝ Yǝso tǝ kapat mburata, kanna kalǝ shisshingtǝ'enhi. ");
INSERT INTO bvw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kuwuri kǝntǝ ficha kapat hura'a Fara thlahkǝn hi chap, thlata ɗarkǝn kǝ kakǝn. ");
INSERT INTO bvw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kapat fathlǝehwechǝkǝn le nak kitta mbǝniyu a kǝlanda nakǝn mǝri'mǝrtǝn ndakǝnwa: \"Kitchitkǝn nifiya hweya Farǝ nakǝn!\" ");
INSERT INTO bvw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nishchǝsi thlarkǝ langnga naka nat kanda nishchǝkǝn nda Maryamu le ɓaka a Magdala, Maryamu man Yakubu le nak nguɗɗeh mǝ Yusufu, tǝ Salomi. ");
INSERT INTO bvw_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kandang kuwurkǝndǝ, naɗi natnda hachahai Galili, kwirndǝndǝ tǝpaɗ fǝrandǝ mwanda, tǝ yakat nishchi oiyu ɗǝfkǝndǝ kǝ Urshelimayu kanda mbǝnniyu. ");
INSERT INTO bvw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sǝk farǝ hufta, ɓakna soktǝ kǝ farǝ tahasǝfa kǝthlǝm ishkichitkǝn farǝ yipta Yahudawecha, ");
INSERT INTO bvw_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Nifǝsi lǝ atfichǝwa Yusufu ɓakna hǝmǝt Armatiya, nakǝn ǝrta hur fichile lǝ fǝrandǝ fichǝ mwanda, lenaka pu mwanda Fara, sǝkǝn alchit hanɗǝkiketa ndǝkna mbǝnda Bilatus, sahaǝn murǝt Yǝso. ");
INSERT INTO bvw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pǝɗang ǝnatkǝn Bilatus fa ndu a teppa mirri, thlǝnkǝn kǝ angfichile nak mwachina hur fathǝrhwechǝkǝn, sahaǝn miya: \"Tǝkit Yǝso teppa mirwa?\" ");
INSERT INTO bvw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kǝ sǝktǝn kichu miya kapat fathlǝrhwechǝkǝn tǝ ndatwa teppa mirri, fǝraǝn murǝt fatkǝnna Yusufu. ");
INSERT INTO bvw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Hiikǝ Yusufu njeli thlohmurta, tǝraǝn fata Yǝso haya, fwaɗaǝn tǝ njeli thlohmurundǝyu, ɗǝfkǝna hur kwata le retficha fa ngwiya. Pwatkǝn paplata ngǝlaǝn mi kwatkǝnsi. ");
INSERT INTO bvw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maryamu le ɓaka a Magdala tǝ Maryamu man Yusufu neɗndǝ mbǝɗi hunandǝ ficha. ");
INSERT INTO bvw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kǝ mbǝrkǝ farǝ yipta Yahundawechǝ hi, Maryamu le ɓaka a Magdala, tǝ Maryamu man Yakubu, tǝ Salomi, hiikǝndi fiɗeɗi nat satǝ'en mbinchinfa kǝthlem kǝ ɗǝnda pa'anda Yǝso fa. ");
INSERT INTO bvw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","A farǝ Lati ɓingtǝ tung, kǝnat fara cheta pǝɗaknda mi kwatkǝn. ");
INSERT INTO bvw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nangnda ndandandani chiuwa: \"Wun na pwatandǝ paplatkǝn engnǝmaɗa mi kwatkǝn?\" ");
INSERT INTO bvw_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kǝ thla'andǝndǝ i'nda nak ndǝ paplatkǝn a teppa pwatafichaɗi nakǝn mwanchin. ");
INSERT INTO bvw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kǝnannda yimta hur kwatkǝn, nakndǝ hwankimsha'a ɗas tǝ harsǝmta, tǝ heɗɗi njela'a pǝɗang ǝnatkǝn kandǝfa. ");
INSERT INTO bvw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ndangna kandǝwa mǝ pǝɗa ǝnkunifǝwa nuni kat Yǝso Lǝnazaratta, le kukkwandǝfichǝhi. A thle'i, mǝlansa mbǝnniyuwa, kǝlama mbǝɗi hunandǝficha. ");
INSERT INTO bvw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ɗama mbwa'amna kimshechi'en tǝ Bitrus, tǝndatwa nan lata Galili mǝ kandang, mbǝnniyu nuni nanndi nda i mbwa'a'ndǝnakuni.\" ");
INSERT INTO bvw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nishchǝkǝn paɗ shekɗa'indǝ kanda kandǝ saktatfa Cheknda kish tǝ rahta, a hurkwatkǝn fechengnanda rǝptǝfa shekɗa'indǝ kandǝ ka'ǝn. Mbwa'aundǝ ǝna nifuwa kǝthlǝm kanda lechita. ");
INSERT INTO bvw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kǝ thlattin tǝ shisshingta fa ɓingtǝ tung a farǝ Lati, tǝrkaakǝn ɓata mbǝs Maryamu le ɓaka a Magdala, nuhi rǝktǝ Yǝso lǝwurchǝ muɗa fet'en. ");
INSERT INTO bvw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mǝlan paɗ ɗǝkna mbwa'anda fichile natndǝ tǝ Yǝso soh kana mǝrta ɗǝkna mbǝssandǝkanda sǝɓ hura tǝ paɗ kanda tita. ");
INSERT INTO bvw_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kǝ sǝktǝndǝwa Yǝso mǝllan tǝ shisshingta fa, tǝpaɗ neɗtǝndi, cherkǝnda fǝrkitsi. ");
INSERT INTO bvw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ɗiffitǝ ndǝkǝn cheɗkǝn fat'enna mbǝnda funǝ chap hurnandǝ tǝ witǝ natsomǝn, kanda ɗar pǝɗata thlethǝmta. ");
INSERT INTO bvw_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nofchi chapyu ngǝrangndǝ'in ɓaknda mbwa'anda tahchikǝn, chika tǝkichu fǝrundǝ kitsi kǝ ɗar i mbutǝndǝwa. ");
INSERT INTO bvw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ɗiffitǝ ndǝkǝn ɓak Yǝso mbǝs kimshechi'en kumkǝngǝrǝnsǝ ǝrta shokndǝhi kanda sǝm ɗǝsǝmta, ɓokkangna kandǝhi kǝ ɗar ɓah fǝrkitchiɗeng nanda, tǝ kwaakwaachit hanɗǝkiketa, kǝthlem cherndǝ fǝrkitta ɗar fichile naknda a ɗiffitǝ thla'i'thlattǝn. ");
INSERT INTO bvw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ndangna kandǝwa ɗama hur kishitǝ nat kǝ ɓassuni kwescha shunda kǝ mbǝɗa nofchǝ nat. ");
INSERT INTO bvw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Uf nifi fǝrkǝkit sangfichǝ baptisma nan hǝrǝkta, paɗ le cherkǝ fǝrkit na ficha fǝra pwancha. ");
INSERT INTO bvw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na ficha nat sakǝt i'chiiya tǝ mbǝɗa fichile fǝrkǝkit: nanda chandǝ ɓǝɓi lǝwurchakissha hur thlemna, nanda shuwun yuwamichǝ somsomǝn, ");
INSERT INTO bvw_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nanda harǝ huthlǝnchahar tǝ paɗ chika witǝ ɓǝɓi i'natma sandǝ ngu tamta sa ǝnkanduwa; nanda sa harcha nofcha in fichile nak hahchin nanda kǝndaɗi.\" ");
INSERT INTO bvw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ɗiffitǝ shuni shunandǝ Lǝmwandǝ Yǝso kanda, tǝrrang ficha afshi, sokkǝnna har sǝmta Fara. ");
INSERT INTO bvw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pǝɗak kimshechikǝnna nata ɓasǝ kwashchǝ shunda Fara chika ayi, Lǝmwanda nakna kǝsanda kandǝsi. Tǝ mbǝɗa ǝnnat sheka inchi nannda sǝtyu cheɗkǝnwa kweshcha shuni nannda ɓassǝyu ɓakna mbǝɗa Fara.");
INSERT INTO bvw_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Hur tǝrka ɗelwer engna, le yarutisi sokǝn Tiyofalus, yaraɗi ichihi nat tǝrkaatǝ Yǝso sǝta tǝ fichile tǝrkaatǝn sakandaɗi, ");
INSERT INTO bvw_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kǝ fari tǝrtǝ fichinda afshi, ɗifitǝ fǝra kussa fathlǝnchi'en taɗtǝnhar tǝmbǝɗa Shemeɗ Chiɗchiɗ. ");
INSERT INTO bvw_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Hur mundǝ kumchit fwaɗa, ɗifitǝ ɓahtǝ'enhi tǝ mǝrtǝ'en, kurɓaɗǝ cheɗa fat'enna kanda a mbachǝ somsomǝn ndatwa tǝkit a thlee tǝ shisshingtafa, paɗ mbwa'aɗǝ pathlǝ mwanda Fara kanda. ");
INSERT INTO bvw_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Naɗi natǝn tǝ kandǝyu, ndangna kandǝwa: \"Mǝ malindǝ Urshelima hiwa, kǝ pundǝ kǝ nǝhhǝɗ ɗǝfshuni ɗǝftǝ shinkǝn hiiyu, nda i mbwa'andǝna kanda, ");
INSERT INTO bvw_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kǝthlǝm Yohanna sǝkǝn baptisma tǝ ama, a hanmunchǝ ɗimek nakficha sa baptisma kuni tǝ Shemeɗ Chiɗchiɗ.\" ");
INSERT INTO bvw_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Kǝnat Yǝso humtǝhi tǝ fathlǝncha, sahangndǝwa: \"Lǝmwanda, nakǝnya natu ngǝr fǝra kuturichit'ena Israila ɗǝwa?\" ");
INSERT INTO bvw_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ndangna kandǝwa: \"Nga innuni kǝ sǝnuni thlet hanmunchǝ tǝ hanthlǝkchǝkǝnwa, papa ndak nak tǝ alchitkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nuni mbǝs alchita ma ɓeɗ Shemeɗ kǝ ɗar inchengnuni. Nakuni nat kǝ shetachengna, kǝ nuni mbwa'a pathlengna nofcha a hur Urshelima tǝ hachahai Yahudiya nat tǝ Samariya tǝ sǝrǝt kishitǝ nat.\" ");
INSERT INTO bvw_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kǝ mbuutǝn kichu, kanda ɗar kǝlanda, tǝrangficha afshi kǝ hur husomba'a, ɓakna shekata hwanichengnanda mwa'unda ngǝr nanndǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kanda ɗar kǝlata afshi, mǝlan paɗ mǝla pǝɗata, ɓak nofchi chappa thlara thlǝmatnanda, tǝ njelechǝ heɗǝɗa. ");
INSERT INTO bvw_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ndangnda kandǝwa: \"Hishcha Galilicha, kǝthlǝmmǝ natuni kikit kǝnuni kǝlata afshi? Yǝso ti tǝrrandǝ ficha hurnuni kǝ afshiya, farǝyuna nan ngǝr ɓata nda i natuni pǝɗat'ena hur afshi.\" ");
INSERT INTO bvw_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Thlaakǝnda malkǝndǝ shohla Zaitunhi ngǝrangndǝ'ina Urshelima nakǝn nga langngǝwa, witǝ nduk ka mel ǝrta. ");
INSERT INTO bvw_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kǝ nannda sata hǝmǝtkǝn, tǝrkǝnda huri afshi kǝ mbǝɗi nanndǝ ɗǝndas. nda: Bitrus, Yohanna, Yakubu, Andarawus, Filibus, Toma, Bartalamawus tǝ Matiyu, Yakubu hweya Halfa tǝ Saminu lǝ mbat thlǝt inda punofcha ɗi tǝ Yahuza hweya Yakubu. ");
INSERT INTO bvw_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Humkǝndǝhi natyu tǝ yarǝ ǝrta, naknda nata hwandǝ kǝnding, tǝ Maryamu man Yǝso tǝ nischǝ terchin tǝ hwanmanchǝ Yǝso. ");
INSERT INTO bvw_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","A hanmunchiniyu, ngomkǝ fafǝrkithi aru tǝ kumchitchap kǝ mbǝt ǝrta, thlaakǝ Bitrus kit a hurnanda, ndakǝnwa: ");
INSERT INTO bvw_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","\"Hwanmanchina, sokkǝn waat kǝ nǝhɗangfichi ihi mbuutǝ shunda Farǝ soh tǝ mbǝɗa Shemeɗ Chiɗchiɗ ɓak tǝ miya Dauda kǝ ɗar Yahuda le hǝmka mbanna hur fichile kǝsang Yǝso. ");
INSERT INTO bvw_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kǝthlǝm nakna hurnǝm soh, paɗ fǝra fichi i natna sǝta hur toriya. ");
INSERT INTO bvw_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Yahuda, tǝkǝni ɓǝɓi tor'en hiitǝn mbǝtsi, hǝmkǝnhi tǝ inda, ɗathlkǝ hur'en ɓak hanheɗechi'ena haiya. ");
INSERT INTO bvw_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kusheng shiwun mǝrta Yahuda sǝkkǝ nofcha Urshelima nat, ak fichi mbǝtkǝnwa Akaldama tǝ miyengnanda, sakǝtkǝnwa mbǝt fwara.) ");
INSERT INTO bvw_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ɗǝk Bitrussa mban tǝ ndatwa: Nakna hur yaratkǝn kichuyu a hur Zabura, ndatwa: \"Nak huraa'ena nata kǝtǝn kuffi, mǝ soki nifa hurkǝnwa: paɗ mbǝt soktǝ'en a hur torkǝn kǝ tǝr yuna.\" ");
INSERT INTO bvw_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Kǝthlǝm ndǝkǝn sokkǝn waat kǝ taɗim yunihara a hur nofchi natǝm tǝ kandǝ nat farǝ natma witǝ tǝ Lǝmwandǝ Yǝso yu. ");
INSERT INTO bvw_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Thlata fari sandǝ Yohanna baptisma kǝ fari tǝrtǝndǝndi a hurnǝm kǝ afshi. Chikawun tǝrtǝ ficha, nan sokta sheta tǝkǝm kǝ ɗar thlata Yǝso a hur mǝmatcha. ");
INSERT INTO bvw_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Harkǝndǝ nofchi chap: Yusufu lela atfichǝwa Barsabas, lela atndǝ paɗwa Yustus tǝ Matiyas. ");
INSERT INTO bvw_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Hwankǝnda tǝ ndatwa: \"Ai Lǝmwanda, lǝ sǝn hanndǝkiketa chika wuni, cheɗɗu le taɗtuhara hur nofchi chapya. ");
INSERT INTO bvw_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Kǝ sokka lǝ thlǝnda hur torkǝn, kǝ tǝrǝn mbǝtsokta Yahuda le lengkǝhi pǝɗaka mbǝɗi ɓatǝn yu. ");
INSERT INTO bvw_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","'Yimkǝnda tata, sǝmkǝ Matiyas ɗǝfkǝfichinda hur fathlǝncha, humang fichi tǝ fichile kumngǝrǝnsǝ ertǝyu. ");
INSERT INTO bvw_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kǝ saatǝ farǝ pentekos, uf fa fǝrkit hwimndǝhi mbǝt ǝrta. ");
INSERT INTO bvw_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sutolluwa, sǝkkǝ fichi tit ǝna hur afshi nda kapat rǝnna'a nǝhɗaɗǝ huri'i nannda hurkǝn ɗǝɗas. ");
INSERT INTO bvw_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Cheɗkǝ ichi fechengnanda nda hanshuwun hwata, kanda saktǝhi, kanda ɗǝta ɗar inchengnanda. ");
INSERT INTO bvw_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nǝhɗang fichi kandǝ nat tǝ Shemeɗ Chiɗchiɗ, tǝrkaakǝndǝ shundǝ tǝ michǝ somsomǝn, ɗa i fǝrandǝ Shemeɗ shunda kanda. ");
INSERT INTO bvw_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","A thlahmbǝchiniyu, Yahudawechisi fa mwanandǝ Farǝ kaǝn, ɓaka a hachahaichǝ somsomǝn a hur kishita nak tǝ sokta a Urshelima. ");
INSERT INTO bvw_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kǝ sǝktǝndǝ iniyu, humkǝndǝhi ngomkǝnda mbǝt ǝrta kǝthlǝm a kwehǝr sokkǝnaɗi, chikawun mǝla sǝktǝ kanda shundǝ tǝ miyengnanda. ");
INSERT INTO bvw_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Pǝɗang ǝn kandǝfa paɗ shekɗang'indǝ kanda, ndakndǝwa: \"Awi fa shuni natya nga Galilawechiwowa?\" ");
INSERT INTO bvw_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Sǝk ǝnikǝni natma sǝk kanda shundǝ tǝ miya chikawuni? ");
INSERT INTO bvw_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","kǝmnangya, Fartiyawecha tǝ Madiyawecha, tǝ Elamawecha tǝ nofcha hachahai Mesofotamiya tǝ Yahudiya tǝ Kafadokiya tǝ i Fantus tǝ Asiya, ");
INSERT INTO bvw_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","tǝ Firijiya tǝ Bamfiliya tǝ Masar tǝ fichile nak nduknduk tǝ Sayirin a hachahai Libiya tǝ romchi ɓaka Roma. Yahudawecha tǝ fichile yimka tǝrmbandengnǝm. ");
INSERT INTO bvw_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Paɗ kǝmnang Kiritawecha tǝ Larabawecha, nat kǝmna sǝk kanda shundǝ tǝ miyengnǝm kǝ ɗar pǝktat ichi sǝt Fara.\" ");
INSERT INTO bvw_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Pǝɗang ǝn kandǝfǝ natnda kohǝrkǝ inchengnandaɗi, ɗakndǝwa: \"Mǝnaka sakǝt iya?\" ");
INSERT INTO bvw_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Chang funǝ mi kandǝhi ndatwa: \"Tǝ sandǝ am inabi ngalkǝndǝ ɓeng.\" ");
INSERT INTO bvw_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Thlaakǝ Bitrus kit tǝ tahǝt fathlǝnchi kumngǝrǝnsǝ'ǝrtǝyu, i'naǝn ɓurathi ɓassangna kandǝsi, ndakǝnwa: \"Hwanmanchina Yahudawecha tǝ fichile naktǝ sokta Urshelima nat sǝkamnji, paɗ kǝ ɗǝffuni i'nda i nati mbwa'anda kuni. ");
INSERT INTO bvw_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nofchiya nga tǝ tǝrang ǝna kandǝ nda i tǝrtuniwa, nakǝn mwee mbǝta ɓingtǝyawa: hanthlikkǝn hanhertǝ ndak. ");
INSERT INTO bvw_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","I natuniya ndǝkǝn mbutǝ tapǝnaa Yowel ndatwa: ");
INSERT INTO bvw_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","\"'Ndak Farǝ wa, a mweshit hanmunchikǝn ni thlǝr Shemeɗengna ɗar inda nofchi nat. Hwechengnuni kǝ nishchi tǝ hishcha nanda mbu icha le mbwa'andǝ Fara kanda. Kimshechengnuni nanda nat'ichi tamuchitnda nata, tuɓurnofchengnuni nanda sǝnnata. ");
INSERT INTO bvw_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","A hanmunchiniyu ni thlǝr shemeɗengna kǝ ɗar inda mafechengna hishchi tǝ nishchi nat, paɗ nanda mbu icha le mbwa'andǝ Fara kanda. ");
INSERT INTO bvw_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ni che ǝnat pǝɗandǝ nifǝfa a hur afshi, tǝ i na che sakǝt ǝnat pǝɗandǝ nofchǝfa a kishita, naknanat fwara tǝ hwata tǝ ǝnnda husomba'a. ");
INSERT INTO bvw_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Hwatfarǝ nan yimta hulta, ndǝra'a nan tǝɓǝrtǝhi ngah nda fwara, kana fari Lǝmwandiyu ɓata, kapat fari nak mwanchin. ");
INSERT INTO bvw_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Farini hachiyu, chikawun hwanka hur thlǝm Lǝmwanda nan hǝrǝkta. ");
INSERT INTO bvw_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Hwanmanchina, Israilawecha, sǝkam shuniya. Yǝso lǝ Nazaratta, nifi cheɗandǝ Fara kuni tǝ pǝktat torcha tǝ ǝnat pǝɗandǝ nifǝfa tǝ che ichi somsomǝn a hurnuni tǝ mbǝɗ'en, nda i sǝntuni tǝ indengnuni. ");
INSERT INTO bvw_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yǝso tiya, fǝrkǝ fichindi tepi tehishhi paɗ tǝ sǝnda Fara, kunang kukwang kǝ ɓǝllangnda tǝ mbǝɗa ɓǝɓi nofcha. ");
INSERT INTO bvw_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ɓak Fara thla'anda ɗifitǝ ɓohandǝ hanmurtǝɗa i'ndi'en, kǝthlǝm ngu sǝtta hanmurta kǝ kǝsǝnndǝharwa. ");
INSERT INTO bvw_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dauda kutura mbwitǝ ǝn kǝɗarkǝn ndatwa: \"A neɗi Lǝmwandǝ mǝla thlǝmmatnǝ kǝnding. Ngi hǝhǝrtǝfuwa, kǝthlǝm mǝla harsǝmtengna. ");
INSERT INTO bvw_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kǝthlǝm ndǝkǝn, hanndǝkiketengna sǝk mbǝndǝfa, hanshundengna in immish mbǝnfata. Tǝ paɗ thlarkǝ faɗengna ɗar ɗǝf'inda mbǝɗa Fara. ");
INSERT INTO bvw_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kǝthlǝm nguna malǝ faɗengna hur mǝmatchiwa, ndu kǝ mallangnǝ iuti nak Chiɗchiɗ kǝ yirakaɗa kwatwa. ");
INSERT INTO bvw_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Cheɗinǝ mba shisshingta. Nu nǝhɗitǝ tǝ mbǝnfata naku tǝnji kǝnding. ");
INSERT INTO bvw_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","\"Hwanamanchina, ni mbǝlla mbwa'anda kuni tǝ kitchitwa kakannǝm Dauda, ndatwa miri a thlohaficha, kwat'en mwakǝna thlǝmmatnǝm kǝ ɓukweya. ");
INSERT INTO bvw_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nakǝn kǝ tapǝnaa, paɗ a shinwa ɗǝffa Farǝ shundǝhi tǝ at'ichimi ndatwa kachit Dauda na sokta mbǝt sok kuturichit'en. ");
INSERT INTO bvw_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ɓak Dauda nathi kichuyu, paɗ a shuwun kǝ ɗar thlata Almasihu a hur mǝmatcha. Nakna ndatwa Farǝ ngu malǝnda hur mǝmatchuwa ndu kǝmalǝn fat'en kǝ yirakaɗa kwatwa. ");
INSERT INTO bvw_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Thlaa Farǝ Yǝso a hur mǝmatcha, kanang natani shetachǝ nakani. ");
INSERT INTO bvw_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nakǝn mwanaficha nakna harsǝmta Fara, Paɗ shinkǝn nda i ɗǝftǝn shundǝhi, fǝraǝn Shemeɗ Chiɗchiɗ kǝ thlǝrka ɗar inchengnǝm nda i sǝktuni paɗ natuni ɓukweya. ");
INSERT INTO bvw_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Nga Dauda tǝrka hur afshiwa, chika mǝlan ndakǝnwa: \"Lǝmwandǝ ndangnga Lǝmwandengnǝwa, soku harsǝmtengna, ");
INSERT INTO bvw_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Kani ɗǝf atikrechiwa ishangnǝkanda ka sarǝcheku.\" ");
INSERT INTO bvw_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","\"Kǝthlǝmndǝkǝn chikawuna hur Isra'ila kǝsǝnǝn tǝkitwa Yǝso ti kukwandunihiyu, ngǝra Fara Lǝmwanda tǝ Almasihu.\" ");
INSERT INTO bvw_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kǝ sǝktǝndǝ shuniniyu, thlǝhǝrkǝn kanda hanɗǝkiketa, ndangnda Bitrus tǝ tahǝt fathlǝnchikǝnwa: \"Hwanmancha, mǝnatani sǝta?\" ");
INSERT INTO bvw_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ndǝkǝn ndandǝ Bitrussa kandǝwa: \"Kǝ tǝrunihi kǝ sangfichǝ baptisma kuni a hur thlǝm Yǝso kǝrǝsti kǝthlǝm kǝ kallangfichi ɓǝɓichitfechengnuni kunihi, kanuni thlǝt Shemeɗ Chiɗchiɗ. ");
INSERT INTO bvw_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kǝthlǝm ɗǝfshunihiya innuni tǝ hwechengnuni, tǝ fichile nak langngǝ paɗ, chikawun at Lǝmwanda, Farengnǝm.\" ");
INSERT INTO bvw_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ɗǝk Bitrussa mban tǝ ɓassanda kandǝ kǝ tolta, nakna ndanda kandǝwa: \"Hǝrkamǝn fechengnuni hura sǝɓ kishi'iya.\" ");
INSERT INTO bvw_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Fichile fǝrkǝkit kǝ ɗar shunda Bitrus, sangfichǝ baptisma kanda. A farǝniyu chekkǝ nofchǝ kǝ ɗar fafǝrkit nduk aru kumchit mǝkkan. ");
INSERT INTO bvw_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ɓaknda ɗǝf inchengnanda sakini fathlǝnchiyu, lǝ humkǝndǝhi kǝnnda chi johma, paɗ kǝnnda hwanda. ");
INSERT INTO bvw_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kǝsang lechit chikawuni, sǝk fathlǝnchikǝn ǝnat pǝɗandǝ nofchifǝ tǝ sakchikǝn kaǝn. ");
INSERT INTO bvw_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nat fafǝrkit kanda mbǝt'ǝrta, chikamengnanda paɗ ǝrta. ");
INSERT INTO bvw_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Hi'yangndǝ ichiɗǝ naksengnandǝ nat, sakangndǝ handǝɓǝlkǝna chikawuni, nda i yahtǝn. ");
INSERT INTO bvw_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","I sǝkka wembǝta kanda ɗǝta kapat hura'a Farǝ tǝ ndani rǝmma, kǝnnda chi njohma a hurechengnanda, kǝnnda sǝm'ǝna mbǝt ǝrta tǝ mbǝndǝfa tǝ hanɗǝkiketǝ yuyur. ");
INSERT INTO bvw_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Kanda mwanandǝ Fara, nangnda mbǝs hamta mbǝɗa nofchinat. I sǝka wembǝta Lǝmwanda cheka fichile hǝrkandǝfich kanda. ");
INSERT INTO bvw_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Farǝle nda Bitrus tǝ Yohanna pǝɗata kapat hura'a Fara ka hwanda a farǝhuftǝ, hanthlǝkkǝn mǝkkan. ");
INSERT INTO bvw_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Bakndǝ tǝ nifǝ le ngǝttǝ fichǝ kǝ tǝraɗ kǝnding la ɓaknda ɗǝfndǝhi nduk kǝ mi ɓang kapat hura'a Fara lela atndǝwa chamare tǝ mimbangnga, kǝthlǝm kǝ hwanǝn fǝr poffǝnna harra fa yimta kapat hura'a Fara. ");
INSERT INTO bvw_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kǝnatǝn nda Bitrus tǝ Yohanna yimta kapat hura'a Fara, hwanaǝn fǝr poffǝn kanda ");
INSERT INTO bvw_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nda Bitrus tǝ Yohanna nak nda kǝllanda, ndak Bitrus wa: \"Kǝllan kani.\" ");
INSERT INTO bvw_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ngǝrkǝ hur'indǝ'en nat kǝfaɗengnanda, naǝnhiwa nan mbǝs'ǝna harengnanda. ");
INSERT INTO bvw_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ndak Bitrus wa: \"Hanɗǝɓǝltengnǝsǝwa, i'naksengna ndǝkǝn nati fǝrruta. A hur thlǝm Yǝso Almasihu Lǝnazartta, thla'u wi'iu.\" ");
INSERT INTO bvw_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kǝskǝ Bitrus harsǝmtǝ'en thla'a'ǝn. Chatkichuyu sarrǝchi'en tǝ sanglamchi'en sǝkndǝ alchita. ");
INSERT INTO bvw_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Thlaakǝn pǝrkǝna afshi thlarkǝnhi tǝrkaakǝn wita, yimkǝna kapat hura'a Farǝ tǝ kanda, mǝla wita mǝla pǝrta afshi, mǝla mwanandǝ Fara. ");
INSERT INTO bvw_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nat nofcha nakndǝndi mǝla wita mǝla mwanandǝ Fara. ");
INSERT INTO bvw_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Mbǝssangndǝwa mǝlanni lǝ sokka a chamare tǝ mimbang kapat hura'a Fara kǝnna hwafǝrpoffǝnyu. Pǝɗang ǝn kandǝfǝ kǝ ɗar i'ndi'en. ");
INSERT INTO bvw_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kǝskǝn Bitrus tǝ Yohanna har, ngomkǝ nofchǝ nat kǝ thlǝmatnandǝ tǝ rahta a hur kǝttǝn para Sulemanu, kǝthlǝm a pǝɗa'ǝnkandǝfa paɗ kwehǝr hur'inchennandaɗi. ");
INSERT INTO bvw_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kǝnat Bitrus kichu, kahaan hur'inda nofchǝ tǝ ndatwa: \"Israilawecha, mǝsǝk pǝɗandǝ'ǝnkunifǝ kǝ ɗar iya? Kǝthlǝmmǝ natuni kǝlandǝ kani nda tǝ alchiɗ'indengnani wiitǝ nifiya ndu kuwur Farengnani sǝk wiitǝ nifiiya? ");
INSERT INTO bvw_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Fara Ibrahim tǝ Ishaku tǝ Yakubu, Fara kakechinǝm nat, mǝlan mwanang mafat'en Yǝso, le chertuni paɗ fǝrtunindi a mbanitǝ Bilatus yu, chikama sokkǝnwa tirwa nan kalǝndǝhi. ");
INSERT INTO bvw_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Cherkuni le nak chiɗchiɗ lǝ kafata, hwankuni kǝ kallangfichi lǝ ɓǝlfata kunihi. ");
INSERT INTO bvw_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ɓǝlangnguni le nak tǝ mba shisshingta har, thla'ang Fara hur mǝmatcha, kanang shetacha ɗar kitchitkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","\"Tǝ mbǝɗa fǝrkit hur thlǝm Yǝso, kǝntǝ nifiɗiya, sǝntuni sohwa tǝraɗ. Kittǝkǝn fǝrkitchiɗi tǝmbǝɗa thlǝm Yǝso kǝnang nifiɗiya a hwanitengnuni nat. ");
INSERT INTO bvw_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Nakǝnya hwanmancha, mbǝssaɗiwa i sanduni Yǝso sǝkuni hur ɓahsǝnda, nda i sǝt fa hǝmɓanichengnuni. ");
INSERT INTO bvw_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tǝkichu nǝhɗandǝ Farǝ ɗǝfshundǝ'enhi tǝ miya tapǝnechǝ nat, ndatwa Kǝrǝsti nan sat ɓahta. ");
INSERT INTO bvw_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kǝthlǝm ndǝkǝn kǝ tǝrunihi kǝ tǝɓrunihi ɓǝɗa Fara, kǝthlǝm kǝ sapang fichǝ ɓǝɓichitfechengnuni ɗi, Lǝmwanda nannata cheka alchit hanɗǝkiketa kuni. ");
INSERT INTO bvw_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Paɗ nan thlǝn Kǝrǝsti ti taɗandǝnakunisi soh, mǝlan naka Yǝso. ");
INSERT INTO bvw_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Waat kǝ sokka hur afshi kǝ fari natficha mbumbweɗandǝ ichihi nat kǝ yuwachikǝn, nda i ɗǝftǝ Farǝ shiwunkǝnhi kǝsoh tǝ mbǝɗa tapǝnechi'en chiɗchiɗ. ");
INSERT INTO bvw_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ndak Musawa: \"Farǝ Lǝmwanda nan thla'a tapǝna'a kunisi a hur nofchengnuni, nda i thla'itǝn. Waat kǝ ɗǝffuni inda i nat mbwa'andǝna kuni nat.\" ");
INSERT INTO bvw_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nakna sokta chikawun kawuchik thlǝmmata tapǝni'iniyu na ficha sǝɓandaɗa hur nofcha. ");
INSERT INTO bvw_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Tapǝnechi mbukǝ ichi nat, thlata Samaila ka kǝs fichilesi ɓaka ɗifi, mbwindǝ ichi naka sǝt nat a hanmunchi nakǝnya. ");
INSERT INTO bvw_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kunang naka hwecha tapǝnechiniyu paɗ kuna hur ɗǝf shunini ɗǝfandǝ Fara kakechǝnǝmhiyu. Kǝthlǝm ndang Fara Ibrahim wa: \"Tǝ mbǝɗa kachitwa na nofcha kishita natta mbǝs ǝnhar. ");
INSERT INTO bvw_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kǝ thla'andǝ Farǝ mafat'en Yǝso, tǝrkaakǝn thlǝnndi kǝ mbǝɗengnuni Israilawecha, kǝthlǝm kǝ fǝraǝn mbǝs ǝnhara kuni tǝ mbǝɗa tǝɓrandǝ chikawuna hurnuni kǝ malaǝn ɓǝɓi ɗǝsǝchi'en.\" ");
INSERT INTO bvw_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pǝrischa tǝ la hǝmmbanita fa pu kappat hura'a Farǝ har tǝ Sadukiyawecha, ɓaknda mbǝsnda Bitrus tǝ Yohanna kanda hur shunandǝ nofcha. ");
INSERT INTO bvw_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Shiɓhurchengnandaɗi kǝthlǝm kanda sakanda nofchihar tǝ sǝnanda kandǝsǝwa mǝmatcha nanda thlatǝ tǝ shisshingchafa nda i thlaatǝ Yǝso. ");
INSERT INTO bvw_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kǝsangndǝ kanda, ɗǝkndǝ tǝ kanda kǝttǝn pursuna kǝ ishki, nakǝn tepa shiɗ farǝhufta. ");
INSERT INTO bvw_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Yakat fichile sǝkkǝ ɓassikǝn, fǝrkǝndǝkitsi. Nofchi fǝrkǝkittǝkǝn sheendǝ aru kumchitɗurman. ");
INSERT INTO bvw_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ɓingǝtkǝn, fa yarandǝ ichihi a kuturchitkǝn uf tǝ fa hǝmmbanita tǝ malɗǝmcha fa sakandǝ kussaɗi, ngomkǝndǝhi a Urshelima. ");
INSERT INTO bvw_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Tǝ Hanana kapat pǝrist tǝ Kayafa tǝ Yohanna tǝ Alekzanda, nat ta fichile naka hur ngitikta kapat pǝrist. ");
INSERT INTO bvw_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ɓakndǝ tǝ Bitrus tǝ Yohanna, thlarangndǝ kandǝhi kǝ hur ɗiffi, sahangndǝ kandǝwa: \"Tǝ alchitmi ndu tǝ thlǝm wuni sǝtuni ichiya?\" ");
INSERT INTO bvw_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Bitrus, nǝhǝɗkaɗǝ tǝ Shemeɗ Chiɗchiɗ, ndangnakandǝwa: \"Kuturcha tǝ pǝktat nofcha, ");
INSERT INTO bvw_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Sahangnguni mi kani ɓukweya kǝthlǝm kachiɗi sandani tǝraɗtiyawa tǝ mbayi kǝntǝna ɗiyawa? ");
INSERT INTO bvw_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Yahkisi kǝ sǝnuni nattuni tǝ Israilawecha, ndatwa tǝ thlǝm Yǝso Almasihu Lǝnazaratta, le kukwandunihi thla'andǝ Fara hur mǝmatcha, kǝntǝ nifiɗi ngwalngwal kita mbanitǝnuniya. ");
INSERT INTO bvw_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Mǝlan naka: \"Ngwiyi chertuni kunang fa tincha, ndǝkǝn sokka kukuwun tinda.\" ");
INSERT INTO bvw_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nifǝsi na mbǝssa kaɓi nifǝ chika ǝrtǝwa, kǝthlǝm thlǝmsa hur kishi'inatya fǝrandǝ ficha nifa le na mbǝssakaɓikǝmwa.\" ");
INSERT INTO bvw_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kǝ natndǝ alchit shunda nda Bitrus tǝ Yohanna, paɗ mbǝssangndǝwa nga fa sǝn'ǝnwa, paɗ fa ɓahcha, pǝɗang ǝn kandǝfa. Ɓeɗnda mbǝssandǝ paɗwa kǝsoh nakndǝ tǝ Yǝso. ");
INSERT INTO bvw_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kǝnannda nat nifi kǝnandǝndaɗaɗi kita hurnanda, ɓahkǝndǝ i nannda mbuta. ");
INSERT INTO bvw_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ndangnda nda Bitrus tǝ Yohanna wa kǝ chendakisha kǝttǝn yarangndǝ ichihi, kǝ yarangndǝ ichihi kǝ ndani. ");
INSERT INTO bvw_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ndakndǝwa: \"Nakma sandǝ nofchiya kǝni? Mbandǝsǝ namma ndatwa sundǝ ǝnat pǝɗandǝ nifǝfuwowa, kǝthlǝm chikawuni a Urshelima shinwa shiɗ fichǝ ǝn kichu. ");
INSERT INTO bvw_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kǝthlǝm kǝ njaam ɗǝttǝkǝna kanda mban, ɓokamna kanda, mǝ ngǝrinda shunandǝ nifa hur thlǝmmiyawa.\" ");
INSERT INTO bvw_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Akndǝ fathlǝnchikǝn, ɓokangnda kanda mǝ ngǝrinda shunandǝ nifǝ ndu kǝ sakangnda nifǝhar hur thlǝm Yǝso wa. ");
INSERT INTO bvw_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ngǝrang nda Bitrus tǝ Yohanna kandǝsǝwa: \"Keekesa mbanitǝ Fara kǝ sǝkani innuni kǝ cherani i Farǝwa, Kǝlamǝn kǝnuni. ");
INSERT INTO bvw_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kǝthlǝm kanang ngani malandǝ mbu i natani tǝ i sǝktaniwa.\" ");
INSERT INTO bvw_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ngǝrkǝndǝ chekandǝ ɓokanda kanda kalkǝndǝ kandǝhi, kǝthlǝm sǝnundǝ mbayi nannda fǝra ɓwenne kandǝwa kǝthlǝm nofcha. Kǝthlǝm chikawun mǝla mwanandǝ Fara kǝ ɗar i sǝka. ");
INSERT INTO bvw_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Nifi mbǝskǝ kǝndaɗaɗi tǝ mbanda ǝnat pǝɗandǝ nifǝfa, sheraɗa hurat kumchit fwaɗa tǝ ngǝtta. ");
INSERT INTO bvw_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kǝ kaltǝndǝ kandǝhi, nda Bitrus tǝ Yohanna pǝɗaknda mbǝs fahchinanda, mbwa'angndǝ i kandǝ mbutǝ pǝktat pǝristcha tǝ pǝktecha. ");
INSERT INTO bvw_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kandang paɗ kǝ sǝktǝndǝ kichu, thla'angndǝ ɓurechengnanda mbǝɗa Fara hurhwanda, ndakndǝwa: \"Lǝmwandǝ lǝ alchitnat, sokǝn sǝk hur afshi tǝ kishita tǝ hawurta tǝ ichi naka hurkǝn nat. ");
INSERT INTO bvw_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tǝ mbǝɗa Shemeɗ Chiɗchiɗ, tǝ miya kakannani Dauda, mafaɗeku ndatuwa: \"Kǝthlǝmmǝ sǝɓɓandǝ punofcha huraɗi? Kǝthlǝmmǝ nat nofcha kike kohat i'cha? ");
INSERT INTO bvw_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kuturcha kishita tehishndǝfa mbata, fa hǝmmbanita humandǝ inda kǝ ɗar Lǝmwanda tǝ Kǝrǝsti paɗ.\" ");
INSERT INTO bvw_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","\"Kittǝkǝn a hur hǝmǝɗiya Hiridus tǝ Buntus Bilatus humandǝ inda tǝ punofcha tǝ nofcha Isra'ilawecha kǝ sangndǝ ɓǝɓichitfatfa nat kǝ ɗar mafaɗeku Yǝso le taɗtuhar. ");
INSERT INTO bvw_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Humangndǝ inda kǝthlǝm kǝ sǝndǝ ichi taptu kǝ tahsangnǝhi tǝ alchiɗeku tǝ yahtekuwa nan sǝta. ");
INSERT INTO bvw_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nakǝnya Lǝmwanda, kǝlandǝn kah thlemmaɗengnanda kǝ Fǝrangnǝ mbaɓǝs shundeku mafecheku tǝ alchita. ");
INSERT INTO bvw_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Kǝlla tiɗɗangnǝ harekuhi i kǝndaɗi, kǝ sani ǝnat pǝɗandǝ nifǝfa tǝ sakchikǝn tǝ mbǝɗa thlǝm mafaɗeku chiɗchiɗ, Yǝso.\" ");
INSERT INTO bvw_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ɗifitǝ hwandengnanda, mbǝɗi humtǝndǝhi hǝhǝrkǝnfa, nǝhɗang fichi kandǝ tǝ Shemeɗ Chiɗchiɗ. Ɓǝskǝndǝ pathla Farǝ nga lecgitfuwa. ");
INSERT INTO bvw_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Sǝrǝt fichile fǝrkǝkit, humkǝndǝhi hanɗǝkiketǝ ǝrta tǝ yarǝ ǝrta. Ngusǝ ndakwa i naksǝ'enwa ikǝnwa, chikamǝ naksengnanda innandǝ nat. ");
INSERT INTO bvw_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Fathlǝnchǝkǝn fǝrkǝndǝ sheta tǝ thlata Yǝso Lǝmwanda hur mǝmatcha tǝ alchita, paɗ Kachita Farǝ kaǝn a ɗar nandǝ nat nda. ");
INSERT INTO bvw_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ngusa hurnandǝ ɓahkǝ ǝnwa, kǝthlǝm nat fa hurecha tǝ hicha hiyandaɗi ɓakndǝ tǝ hanɗǝɓǝlkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ɓakndǝ tǝ hanndǝɓǝlkǝn, fǝrangnda fathlǝnchǝkǝn, sakang ficha nofchinat chikawun keeke a i yahtǝn. ");
INSERT INTO bvw_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nifǝsi thlǝmkǝnwa Yusufu, lǝ Lawita kachitkǝn lǝ Kubrustǝ nakǝn, la at fathlǝnchǝkǝnwa Barnabas (sakitkǝnwa: \"Hwan cheka alchita hanɗǝkiketa\") ");
INSERT INTO bvw_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Hiyaǝn hitǝ'enaɗi, ɓakǝn tǝ hanndǝɓǝlkǝnna ɓanitǝ fathlǝnchikǝn. ");
INSERT INTO bvw_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nifǝsǝ thlǝmkǝnwa Hananiya tǝ nuhkǝn Safiratu, hi'yaǝn mbǝt enaɗi. ");
INSERT INTO bvw_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ɓuɓweekǝn hanɗǝɓǝlkǝn har tǝ sǝnda nuhkǝnsi, ɓakǝn tǝ tahhǝtkǝn ɗǝfkǝnhi mbanitǝ fathlǝncha. ");
INSERT INTO bvw_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ndǝkǝn ndat Bitrus wa: \"Sokǝn Hananiya, mǝsǝk malandu Sheɗan kǝ nǝhɗaǝn hanɗǝkiketeku kǝ lekangna Shemeɗsǝ Chiɗchiɗ, ɓuɓweetu hanɗǝɓǝltǝ harra hur hanɗǝɓǝl hiti hi'yanduɗi? ");
INSERT INTO bvw_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Thlateku kǝ ɗǝna hi'yandaɗaɗi, nga iuwowa? Ɗifitǝ hi'yaɗekuɗi, hanɗǝɓǝlkǝn nga iuwowa? Mǝsǝk ɗǝftu lekta hanndǝkiketeku? Nga nifǝ lekandusǝwa, Fara.\" ");
INSERT INTO bvw_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kǝ sǝktǝ Hananiya shuniniyu, hǝmkǝnhi mǝrkǝn. Nat fichile sǝkka kǝsang lechit kandǝ kaǝn. ");
INSERT INTO bvw_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ɓak kimshecha tǝranda kish, fwaɗangndǝ tǝ njeli thlohmurta pǝɗaknda thlohhanda. ");
INSERT INTO bvw_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ɗifitǝ nda hanthlǝkkǝn mǝkkan, yimkǝ nuhkǝnsi, sǝnutǝ i sǝkwa. ");
INSERT INTO bvw_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ndǝkǝn sahandǝ Bitrus wa: \"Ɓu'i'tǝn, hi'yangnguni hitiɗiyu kichawa?\" Ngǝmanwa: \"Aa, kichuyu.\" ");
INSERT INTO bvw_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ndǝkǝn ndandǝ Bitrus wa: \"Mǝsǝk humanduni mi kǝ kikeɗangnguni Shemeɗa Lǝmwandǝ kicheya? Suku kwarsara fichile pǝɗaka thlohhandǝ sǝmatu, kanda mikǝnnda, nanda tǝrruta kish paɗ.\" ");
INSERT INTO bvw_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Chatkichuyu, hǝmkǝnhi mǝrkǝn. Kǝ yimtǝ kimshechikǝnsi, mbǝssangndǝ kǝ murǝtkǝn, tǝrkǝndǝndi kitangnda kish pǝɗangnda thlohhanda thlǝmat sǝmaha. ");
INSERT INTO bvw_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kǝssang lechit kǝttǝn hwakǝn kaǝn nat ta fichile sǝkkǝ ichiniyu. ");
INSERT INTO bvw_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Shiɗ fichi ǝnat pǝɗandǝ nifǝfa tǝ sakchikǝn kaǝn a hur nofcha tǝ ɓǝɗa fathlǝncha. Nat fafǝrkit la ngomkǝndǝhi kǝttǝn para Sulemanu tǝ yarǝ ǝrta. ");
INSERT INTO bvw_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","A hur tahhǝt nofcha, ngusǝ cheɗkǝ nda nan yimta hurnandǝwa, chika kichu la fǝrang nofchǝ mwanda kanda. ");
INSERT INTO bvw_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nak fafǝrkitta chektǝ kaǝn kǝ ɓǝɗa Lǝmwanda, sheraɗa le soh, hishchǝ tǝ nishchǝ nat. ");
INSERT INTO bvw_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ala ɓakndǝ tǝ hacha mimbacha, funa mbǝt'hunecha funa ɗǝngǝlcha, kǝthlǝm ma Bitrusa mbǝrtǝhi, chika mirshingtǝ'en kǝɗǝn tǝ ɗar funa. ");
INSERT INTO bvw_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nofcha a thlet mbichi somsomǝn taurang Urshelima hiyu naknda ngomta, kanda ɓat tǝ hacha tǝ fichile nat ɓǝɓilǝwurcha ɓahandǝ kanda, kǝnang fichi kandaɗǝ natnda. ");
INSERT INTO bvw_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Thlaakǝ kapat pǝrist tǝ fichile naka thlǝmatkǝn, fa tǝrmbanda Sadukiyawecha, nakndǝ tǝ sǝrǝhtafǝ kaǝn. ");
INSERT INTO bvw_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kǝsangndǝ fathlǝnchikǝn, ɗǝkndǝ tǝ kanda pursuna. ");
INSERT INTO bvw_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Sokkǝn a fiɗɗikta, ɓak Mala'ika Lǝmwanda i'nandǝ mikǝtǝn pursunechikǝnhi, chaǝn kanda kish ndangna kandǝwa: ");
INSERT INTO bvw_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","\"Ɗama kapat hura'a Fara ɗuni thlarǝhi hurkǝn kǝ mbwa'angnguni nofcha pathlǝ yuwa shisshingta kanda.\" ");
INSERT INTO bvw_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kǝ sǝktǝndǝ kichu yimkǝnda kapat hura'a Fara ɓingta naknda sakandaɗi. Kapat pǝrist tǝ fichile naka thlǝmatkǝn chekndakish, akndǝ fa sakandǝ ichihi tǝ fa hǝmmbanita Isra'ilawecha, thlǝnkǝnda pursuna kǝ ɓafichi tǝ kanda. ");
INSERT INTO bvw_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kǝ ɗǝt fa pu pursuna tǝkǝn, mbǝsawundǝ kandǝsǝwa, ɓaknda ɗaɗi ndakndǝwa: ");
INSERT INTO bvw_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","\"Ɗǝkkani mbǝssandi pursuna tǝkǝna kuɓultǝ ndiichin, fa putǝhar kandǝsi a mikǝttǝnchikǝn, kǝ i'nandanihi mbǝssawani nifa hurkǝn chika ǝrtǝwa.\" ");
INSERT INTO bvw_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kǝ sǝktǝ kapat lǝ pu kapat hura'a Farǝ har kichu tǝ pǝktat pǝristchikǝn, kohǝrkǝ inchengnandaɗi, naknda sakandǝhi mǝna kuwurɗifitǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ɓakyuna ndanda kandǝwa: \"Nofchi somtuni pursunayu kanda hur kapat hura'a Fara kanda sakanda nofchihar.\" ");
INSERT INTO bvw_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Fa pu kǝttǝn hwakǝn har tǝ kapat nanda pǝɗaknda ɓat tǝ fathlǝnchikǝn, paɗ ngatǝalwa, kǝthlǝm pǝktechikǝn kanda lechita mǝmǝmuhanda kandǝfǝ tǝ ngwichǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Kǝ ɓatndǝ tǝkanda, thlarangndǝ kandǝhi a mbanitǝ fa sakandǝ ichihi. Nak kapat pǝristsa sahami kanda. ");
INSERT INTO bvw_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ndakǝnwa: \"Ɓokandǝmakuni, mǝ ngǝriɗuni sakanda nifihar a hur thlǝm nifiyawa, chika kichu nǝhɗaɗuni Urshelima ɗi tǝ saktengnuni kǝ ɗarkǝn, a yahkunisǝ nakǝnya kǝ tǝrranǝ hakke tǝ fwara nifiya kǝ ɓa ɗar inchengnani.\" ");
INSERT INTO bvw_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Bitrus tǝ tahǝt fathlǝnchikǝn ngǝmangndǝwa: \"Sokkǝn waat kǝ sani i mbutǝ Fara nga i mbutǝ nifuwa. ");
INSERT INTO bvw_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Fara kakechinǝm thla'ang Yǝso hur mǝmatcha, le mbǝlanduni tǝ mbanda kukwandǝhi ɗar palita. ");
INSERT INTO bvw_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mǝlan mwanandǝ Fara ɗǝfkǝnndǝ tǝ harsǝmtǝ'en, sangna lǝ hǝmmbanita paɗ lǝ thlǝt nofchaɗi. Sǝkǝn iniyu kǝthlǝm Isra'ilawecha kǝ mbǝsndǝ mba tǝrtǝhi kǝ kalangfichǝ ɓǝɓichitfechengnanda kandǝhi. ");
INSERT INTO bvw_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kanang shetacha kǝ ɗar ichini natyu, kichu paɗ tǝ Shemeɗ Chiɗchiɗ, fǝrandǝ Fara fichile la kuwurkǝ ichi la mbutǝn.\" ");
INSERT INTO bvw_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kǝ sǝktǝndǝ kichu, sǝɓkǝ hurchengnandaɗi kaǝn, yahkǝndǝsa ɓǝllandǝ kanda. ");
INSERT INTO bvw_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Yunǝsa mbǝnniyu lǝ Farisiyawata nat thlǝmkǝnwa Gamaliyel, lǝ ɓassǝ kus, le la fǝrandǝ nofchinat mwanda, thlaakǝn kit a hur fa sak'michikǝn ndakǝnwa chamǝn nofchikishya kwandǝn. ");
INSERT INTO bvw_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kanna ndanda kandǝwa: \"Hwanmanchina Isra'ilawecha, mbǝramsa i yahtunisa sandǝ nofchiya. ");
INSERT INTO bvw_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Hurechi mbǝrkǝhiyu, ɓak yunǝ kichu wa mǝlan Tuɗas, tǝrkǝn indǝ'en nda ǝnnakǝn, nifǝ aru fwaɗa ɗǝk kakǝn, ɓak ficha ɓǝllanda, fichile ɗǝk kakǝn nat wuwelkǝndǝhi. ");
INSERT INTO bvw_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ɗifitǝ mǝlan paɗ, fari nat ficha thlikandǝ nofcha, ɓak yuna wa mǝlan Yahuda lǝ Galilita, chikaǝn funa kuwurkǝndǝndǝ, mǝlan paɗ thlǝrǝtkǝnaɗi. Fa kuwurndǝ tǝkǝn wuwelkǝndǝhi. ");
INSERT INTO bvw_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Chikale nakǝnya, ni mbwa'andakuni, chamakisha mbanda nofchiya, ma i natnda sakta i nifa, ngu ndǝta mbahwa: ");
INSERT INTO bvw_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ma i Fara, nguni mbǝla sa'ǝnkandǝwa. Na ficha mbǝssandǝ kuni kuna mbat tǝ Fara.\" ");
INSERT INTO bvw_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ngǝmangndǝ shundǝ'en, akndǝ fathlǝnchikǝnna hurkǝn, tǝppangnda kanda. Ndangnda kandǝwa mǝ ngǝrǝnda shundǝ tǝ thlǝm Yǝso wa, kannda kalǝ kandǝhi. ");
INSERT INTO bvw_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Fathlǝnchikǝn malkǝndǝ mbanitǝ fa sakandǝ ichihi, kanda sǝt mbǝnfata a ɗar ndatwa shǝkndǝsi kǝ sandǝ ɓahta kǝthlǝm thlǝm Yǝso. ");
INSERT INTO bvw_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Chikayen wembǝta, ndu hur kapat hura'a Fara ndu huri, malaundǝ sakandaɗi tǝ fǝr kusheng shundǝ mbinchin kǝ ɗar Yǝso wa mǝlan naka Kǝrǝstiwa. ");
INSERT INTO bvw_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","A hanmunchiniyu nak fa fǝrkitta chektǝ oi, nak hurumtǝsǝ kaǝn. Yahudawecha fa shuwun Helenanchi naknda hurmanda Ibraniyawechǝfa, fa shundǝ tǝ mi Helenanchi, wa kǝlundǝsa nishchengnandǝ fichile mǝrtǝ hishchengnanda ka sak ichi kǝnding wa. ");
INSERT INTO bvw_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Fichile kumngǝrǝnsǝ chapyu akndǝ fa fǝrkit ndakndǝwa: \"Kamusǝ kimnang kǝ malaam ɓassǝ pathla Farǝ kǝ yimma pathlǝ ndǝsǝmtǝ wa. ");
INSERT INTO bvw_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kǝthlǝm ndǝkǝn, hwanmanchina, taɗam nofchihar muɗ a hurnuni, fichile la fǝrandǝ fichǝ mwanda kanda, paɗ nihiɗndaɗi tǝ Shemeɗa tǝ sǝnda, kǝ sǝmkanda ɗar toriya. ");
INSERT INTO bvw_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kǝmnang nakma nata ɗar hwanda tǝ sakandǝ shuwunkǝnaɗi.\" ");
INSERT INTO bvw_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","I mbutǝnda mbǝnangna nofchifǝ nat. Ndǝkǝn taɗtǝndǝ Istifanus, nifi nǝhiɗkǝ tǝ fǝrkit tǝ Shemeɗ Chiɗchiɗ tǝ Filibus tǝ Burokoras tǝ Nikanor tǝ Timan tǝ Barminas tǝ Nikolas lǝ Antakiyata le yimka tǝrmbanda Yahudawecha. ");
INSERT INTO bvw_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Fichileya ɓanndǝ tǝ kanda mbǝɗa fathlǝncha, hwankǝnda ɗǝffaǝn harra kanda in. ");
INSERT INTO bvw_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nak pathla Fara nata ɗǝta mban. Fa fǝrkit naknda chekta a Urshelima kaǝn, pǝristchǝ terchin fǝrkǝkit. ");
INSERT INTO bvw_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Istifanus, nifi nǝhǝɗkaɗǝ tǝ kafata tǝ alchita, shiɗtǝ pǝktat icha tǝ ǝnat sakchikǝn kaǝn a hur nofcha. ");
INSERT INTO bvw_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Funǝsi a mbǝt humta Yahudawechihi lela atfichiwa kǝttǝn hwanda fichile kaltǝfichihi, thla'angnda Istifanus fa tǝ halǝ'inda, Yahudawechǝ ɓaka Sayirin tǝ Alekzandariya tǝ funa hachahai Kilikiya tǝ Asiya. ");
INSERT INTO bvw_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nakǝn tǝ sǝnǝnafǝ fǝrandǝ Shemeɗ i shunda, ngusǝ mbǝlaakǝ thlarǝhi kǝ halǝn'indǝ tǝndǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Shipangndǝ yipta funa hur a ɓuɓweeta kǝ mbundǝ lektǝ kǝ ɗar Istifanus ndatwa: \"Shikanindi mǝla erǝ Musa tǝ Fara.\" ");
INSERT INTO bvw_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","I'nǝyu thla'andǝ hur'inda nofcha, tǝ fa hǝmmbanita, tǝ malɗǝmcha fa sakandǝ kussaɗi. Kǝsangndǝ Istifanus ɓakndǝ tǝnda mbanitǝ fa sakandǝ ichihi. ");
INSERT INTO bvw_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ɓakndǝ tǝ fa fǝr sheta tǝ lekta, ndakndǝwa: \"Nifiya kǝnding la nakna mbu sǝɓ'icha kǝ ɗar mbǝɗi chiɗchiɗya tǝ kuscha Musa, ");
INSERT INTO bvw_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kǝthlǝm shikanindi mǝla ndatwa Yǝso Lǝnazareta nan fǝffalandǝ mbǝnɗiɗiya, kǝ mbumbweɗaǝn ɗǝsǝchengnǝmhi le malandǝ Musa kǝmhi.\" ");
INSERT INTO bvw_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kǝ sǝktǝ nofchi nat sokkǝhi ɓǝt humkǝnhi, thlǝrangndǝ hwanichafa, nakndǝ chumwandǝ'en nda i Mala'ika ");
INSERT INTO bvw_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kapat pǝristǝkǝn, sahaǝn mi Istifanus wa: \"Ichi natnda chitsǝhi ɗarkǝnya kitwa?\" ");
INSERT INTO bvw_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ngǝmang Istifanus wa: \"Hwanmanchina tǝ shinchina, sǝkamnji. Farǝ lǝmwanda cheɗang fat'ena kakatnǝm Ibrahim a Mesofotamiya, kana ndǝta sokta a Haran. ");
INSERT INTO bvw_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ndaǝnwa: \"Chukisha hachahaiyeku tǝ parchǝwa kǝ yimna hachahaiyi nati cheɗuta. ");
INSERT INTO bvw_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Thlaakǝn malkǝn hachahaiya Kaldiyawechǝ hi kǝ hachahai Haran kǝ farǝ mǝrta shinkǝn. Kana Fara ɓattǝnda ɓǝɗi natunisǝ nakǝnya. ");
INSERT INTO bvw_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Fǝrawu Farǝ mbǝta mbǝnniyu kǝ ikǝn chika ishtǝ ǝrtǝwa, ndǝffaǝn shundǝhi tǝ ndatwa, kǝmban hachahaikǝn nat nan sokta'ikǝn tǝ kachitkǝn chika nguchik hwe'ensiyu. ");
INSERT INTO bvw_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ngǝrkǝ Farǝ shunandǝ ndatwa, na kachitwa ɗǝta sokta a hachahai somǝn kǝ mafecha, nanda sat ɓahtǝ kaǝn kǝ hurat aru fwaɗa. ");
INSERT INTO bvw_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nifǝra ɓahta hachahaiyi sang nofcheku kǝ mafechiyu, ndak Farǝwa, 'a mweshikǝn nanda chetakish kǝ ɓanda mwanita a mbǝɗya.' ");
INSERT INTO bvw_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","A hanmunchiniyu ɗǝffang Fara shunda Ibrahim hi i hesha. Ngǝtkǝ Ibrahim Ishaku, heshaǝn a mundǝ foɗfoɗa. Naknamban kichuyu, Ishaku heshaǝn Yakubu, Yakubu heshaǝn hwanchi'en kumngǝrǝnsi chap kakechinǝm. ");
INSERT INTO bvw_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","\"Kakechǝnǝm tǝkǝn naknda sǝrǝh Yusufu, hi'yang ndandǝ kǝ Masar anakǝn Farǝ tǝndi. ");
INSERT INTO bvw_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Thlǝkkǝnndaɗa hur ɓahta, fǝrang Farǝ mbǝs'ǝnhar tǝ sǝnda a mbanitǝ Fir'auna kutur Masarcha, fǝrang kuturkǝn mwanda a hachahai Masar uf paɗ fǝraǝn huraa'ena har. ");
INSERT INTO bvw_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ɓak mita yimta hachahai Masar tǝ Kan'ana, tǝ ɓahtǝ kaǝn sokkǝn kakechinǝm ɗǝsǝmtengnandǝsǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Sǝkkǝ Yakubu wa ɗǝsǝmtǝsa Masar, thlǝnkǝn hwechi'en kakechinǝm kǝ Masar kǝthlǝm kǝ ɗǝnda hi ndǝsǝmta paɗ tǝrka ɗǝɗengnanda. ");
INSERT INTO bvw_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Chapatǝ ɗǝɗengnanda, cheɗang Yusufu fata hwanmanchikǝn, paɗ cheɗang Yusufu hwanmanchikǝna Fir'auna. ");
INSERT INTO bvw_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Thlǝnkǝ Yusufu wa shinkǝn tǝ tahhǝt witǝnandǝ nat, nifǝ kumchitmuɗ ngǝrǝnsǝ ɗurman, kǝ ɓanda hai kǝ Masar. ");
INSERT INTO bvw_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Pǝɗak Yakubu kǝ Masar, mǝrkǝna mbǝnniyu nda i mǝrtǝ kakechinǝm. ");
INSERT INTO bvw_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kohkǝ fichǝ mǝmatchinanda kǝ Shekem ɗǝkficha thlohandǝ kanda a hur kwaɗi hiitǝ Ibrahim tǝ hanɗǝɓǝlta a hara hwecha Hamor a Shekem tǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Nak farǝ ɗǝf shunda Farǝ hi tǝ Ibrahim satǝ nduk, Yahudawechikǝna a Masar chekkǝndǝ kaǝn. ");
INSERT INTO bvw_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tǝrkǝ kutursǝ somǝn a Masar tǝkǝn le sǝnuchik ǝn kǝɗar Yusufu ");
INSERT INTO bvw_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kuturǝniyu a pupwiktǝ nofchengnǝmhi oi paɗ a fǝraɗǝ ɓahta parchinǝm, la ɗǝfkǝn kandǝ kǝ somangndǝ hanngwa'yarchengnandaɗi kǝthlǝm kǝ mǝmatnda. ");
INSERT INTO bvw_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","A thlahɓǝchiniyu ngǝttǝfichǝ Musa, hwee ndiichin a mbanitǝ Fara. Kǝskǝ parchikǝn ndǝhar ndǝraa mǝkkan a hurhura'a shinkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kǝ muhandǝndaɗi ɗǝk hweya Fira'una tǝrta saǝn nda hwe'en mwanaǝn. ");
INSERT INTO bvw_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Sakangfichǝ sǝnda Musahar i Masarawechi nat, paɗ alchit'ensi a hur torchǝ tǝ shunda. ");
INSERT INTO bvw_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","\"Saakǝn hurat kumchit fwaɗa, ndakǝnwa kemsǝ kǝɗa nat fahchikǝn Israilawecha. ");
INSERT INTO bvw_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","A farǝle nakǝn lǝ Masarta ɓahandǝ hwanmankǝn, thlǝkǝn hwanmankǝn ɓǝlaǝn hwan lǝ Masartiyu. ");
INSERT INTO bvw_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Naǝn Musa hiwa hwanmanchikǝn Israilawecha mbǝsandǝwa Farǝ naka sǝt tor tǝndi kǝ chaǝn kanda kissha hur ɓahta, a nakǝn ɓǝssawundǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Wenkǝɓǝta ngǝrkǝn chetakish, nakǝn hwanmanchikǝn Israilawechi chap kanda mbata, 'yahkǝnsa mbǝnandǝ kanda, ndakǝnwa: 'Hishcha' nakuni hwanmani mǝsǝk natuni mbata?'' ");
INSERT INTO bvw_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Lenaka fǝra ɓahta shekkǝnyu njingtaǝn Musa ɗi ndakǝnwa, 'Wun ɗǝfkǝsa kutura tǝ lǝ sakmi kǝ ɗarnani?' ");
INSERT INTO bvw_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","'Yahnǝsa ɓǝlitǝ nda i ɓǝlandu lǝ Masarti ɓǝraa'yuwa? ");
INSERT INTO bvw_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kǝsǝktǝ Musa kichu, rahkǝn malkǝn hachahaikǝnhi pǝɗakna hachahaya Midiyanacha sokkǝn kǝ romma ɓǝnniyu paɗ ngaǝlngǝn hweechi chap kǝ hishcha. ");
INSERT INTO bvw_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ɗifitǝ hurat kumchitfwaɗa, cheɗang mala'ika fat'ena Musa tǝ mbǝnda hanshuwun hwata, naka kǝsta ɗar hanafta a loktara nduk tǝ shohla Sina'i. ");
INSERT INTO bvw_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Kǝnat Musa i'niyu pǝɗangǝnfa mbǝnniyu. Ɓahkǝn nduk kǝthlǝm kǝnanhi ndiichin, sǝkkǝn ɓurata Lǝmwanda: ");
INSERT INTO bvw_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","'Njang naka Fara kakechuwa, Fara Ibrahim, Ishaku tǝ Yakubu.' Lechik Musa, nakna saktatfa tǝraǝn hwanitaɗi. ");
INSERT INTO bvw_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ndǝkǝn ndandǝ Lǝmwandǝwa, 'Mbasan pahǝmchekuhi, kǝthlǝm mbǝɗi thlartusiyu chiɗchiɗtǝ mbǝta. ");
INSERT INTO bvw_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","A neɗi ɓahta nofchengnǝhi a Masar. Shiki tiɗengnanda, Ɓakihaiya kǝthlǝm kǝthlǝ kandaɗi. Nakǝnya ɗu ni thlǝnsa kǝ ngǝrangnǝinna Masar ");
INSERT INTO bvw_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","\"Musati chertǝnda ndatwa: 'Wun ɗǝfkǝsa kutura tǝ lǝ sakmiya?' Mǝlan thlǝntǝ Farǝ nakǝnya kǝ naka kutura tǝ lǝ thlǝtkandaɗi tǝ mbǝɗa mala'ika cheɗang fat'en tǝ mbanda hwata ɗar hanafta. ");
INSERT INTO bvw_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nifiniyu chang kanda kish a Masar, ɗifitǝ sǝt ichi pǝɗang nofchifǝ kaǝn, paɗ tǝ i sǝtna a fi hawurta tǝ loktara, tǝrkǝ ndǝ hurat kumchit fwaɗa. ");
INSERT INTO bvw_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa tǝkǝn ndangna Israilawechǝ wa, 'Na Fara thla'a'ndǝ yuna hurnuni kǝ tapǝna'a nda njang.' ");
INSERT INTO bvw_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Nifikǝn nakna hurnuni fari ngomtunihi a loktarǝ tǝ kakechinǝm tǝ mala'ika ɓaka shunanda a shohla Sinaiyu tǝ shinchinǝm. Mbǝnniyu thlǝt Musa shuwun nathi kana ɓata fǝranda kǝm. ");
INSERT INTO bvw_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Kakechinǝm tǝkǝn cherkǝnda fǝra mwanda, kawundǝ thlǝmatwa. Cherkǝndǝndi a 'yahkǝndǝsa ngǝrandǝinna Masar. ");
INSERT INTO bvw_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ndangnda Haruna wa kǝ tahsaǝn ɗǝhhacha kandǝsi, fichile na nata mban. Kǝthlǝm sǝnwum i kǝskǝ Musa ti chang kǝma kishsha Masar wa. ");
INSERT INTO bvw_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tinkǝndǝ ɗǝhhata nda hwalata, thlangndǝ ɓurat ɗǝhǝrǝmcha ɗǝhhakǝn i mbǝnfata kǝ ɗar i tahǝstǝndǝ tǝ harchengnanda. ");
INSERT INTO bvw_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tǝɓrang Farǝ hǝsǝra kandǝfa malkǝn kandǝhi kǝnnda mwanandǝ handǝrecha afshi nda farengnanda, nda i natna hur yaratkǝna tapǝnecha, kunang Israilawecha, njang thlanduni ɓurat ɗǝhǝrǝmcha mwananduni ɗǝhhacha a loktarǝ hurat kumchitfwaɗa wa? ");
INSERT INTO bvw_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Harkuni kǝttǝn ɗǝhhachengnuni Molek tǝ ɗǝhha handǝra'a Refan, nakuni witǝ tǝ kanda, ɗǝhhachi tahǝstuni tǝ harcha kǝthlǝm kǝ mwanangnguni kanda, njang paɗ ni harandi kuni kǝ ɗifitǝ Babila. ");
INSERT INTO bvw_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Soh kakechinǝm tenti engnandǝsi a loktara, le cheɗkǝwa lanak Fara mbǝnniyu. Ndǝkǝn na tenti tǝ ndandǝ Fara Musa wa kǝ tahsǝn, tahǝskǝndǝ nda i ndandǝ Fara kanda. ");
INSERT INTO bvw_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ɗifitǝ hurecha, kakechinǝm ti thlǝk iniyu, ɓakndǝ tǝkǝna hachahayi fǝrandǝ Fara kanda, ɗifitǝ rǝki rǝktǝ Farǝ nofchi naka hachahaikǝn, fari nat Joshua kǝ lǝ hǝm mbanita. Tenti tiniyu nakna mbǝnniyu kǝ thlahmbǝɗi sǝt Dauda kuturichita. ");
INSERT INTO bvw_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dauda tǝkǝn mbishtǝ ɗwachita mbǝɗa Fara a hwankǝnwa nan tina hura'a Fara Yakubu si. ");
INSERT INTO bvw_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Sokkǝn Sulemanu tinang hurikǝnsi. ");
INSERT INTO bvw_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","A nakǝn Kapat Lǝmwanda sokwa hurǝ'i tintǝ nifǝ tǝ harwa, nda i ndat tapǝna'a, ");
INSERT INTO bvw_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","\"Hur afshi mbǝt soktengna, hachahaya mbǝt sǝt sarǝchengna, witǝ hurǝmǝ natuni tinitǝsi? Paɗaa witǝ mbǝt yipmi natuni tinitǝsi?\" ");
INSERT INTO bvw_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nga harchengnǝ tingkǝ ichi natyawowa? ");
INSERT INTO bvw_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Kunang fa kwaakwachit hur i'ncha, tǝ fa kwaakwachit hanɗǝkikecha, tǝ fa kwaakwachit thlǝmecha, kǝ nding kuna cherami Chiɗchiɗ tǝ Shemeɗ fa. Sǝk kakechinuni kichuyu a nakuni sǝtkichu kunang paɗ ");
INSERT INTO bvw_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","A hur tapǝnecha, wun fǝrawuchit kakechinuni ɓahta? Ɓǝlandǝ fichile mbukǝ ɓata lǝ kafatchiɗchiɗ. kunang paɗ fǝrkunindǝ a ɓǝllangnguni. ");
INSERT INTO bvw_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Thlǝkuni kuscha Fara cherkuni hǝrǝmtǝhar keeke. ");
INSERT INTO bvw_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kǝ sǝktǝndǝ kichu sǝɓkǝ hurchengnandanɗi, nangnda cha'andǝ hanthlanchengnandǝ kǝ ɗarkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","A nakǝn Istifanus a nihiɗaɗi tǝ Shemeɗ Chiɗchiɗ, kǝlakna hur afshi a nakǝn mwanda Fara, paɗ Yǝso kita harsǝmta Fara. ");
INSERT INTO bvw_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ndǝkǝn ndat Istifanus wa: \"Nama, a neɗi afshi inhi paɗ hweya nifa kita harsǝmta Fara.\" ");
INSERT INTO bvw_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Thlaakǝndǝ tǝ kapat kukwara, ngǝlangndǝ thlǝmechengnandǝ tǝ harchengnanda ngomangndafa. ");
INSERT INTO bvw_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Changnda kish kǝ hǝsǝr hura'a ndǝknda mumuhwandafa. Fichile mumuhwangfiyu malkǝndǝ ichengnanda mbǝnniyu hara kimshaa lela atfichiwa Shawulu. ");
INSERT INTO bvw_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Naknda mumuhwanda Istifanusafa, hwankǝn ndatwa: \"Lǝmwandǝ Yǝso, thlu shemeɗengna.\" ");
INSERT INTO bvw_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Hǝmkǝna ɗar weɗchi'en, i'naǝn ɓurathi kaǝn, ndakǝnwa: \"Lemwanda, mǝ thlikani ɓǝɓichitfechiya a ɗar inchengnandǝwa.\" Mbukǝn i'niyu, mǝrkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Huneɗ Shawulu ɗar ɓǝl Istifanus. A farǝniyu thlaakǝ kapat ɓahtǝ kǝ ɗar fa tǝrmbayi naka Urshelima. Wuwelkandǝhi kǝ thlet hǝmǝt Yahudiya tǝ Samariya, fa thlǝnchǝ ndak maltǝndǝsi. ");
INSERT INTO bvw_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Funǝ nofchisi fa mwandǝ Fara ndǝknda thlohandǝ Istifanus, tikndǝ kaǝn kǝ mǝrti'en. ");
INSERT INTO bvw_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","A nakǝn Shawulu ndǝkna mban tǝ fǝra ɓahta fa tǝrmbanda nda hishchǝ tǝ nishcha, la yimkǝn huraahura'a, mǝla somkanda pursuna. ");
INSERT INTO bvw_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Fichile wuwelandǝ fichi kandǝhiyu, pǝɗaknda thlet mbichǝ somsomǝn naknda ɓassǝ pathla Fara. ");
INSERT INTO bvw_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pǝɗak Filibus kǝ hurhuri Samariya ɗǝkna nata ɓassanda nofchisi kǝ ɗar Kǝrǝsti. ");
INSERT INTO bvw_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nofchi oi tǝ hanɗǝkiketǝ ǝrta sǝkkǝnda, nakndǝ ǝnat pǝɗadǝfaɗifǝ natna sǝta, naknda kathlǝmata i nat Filibussa mbuta. ");
INSERT INTO bvw_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ɓǝɓi shemechi naka chetakishyu naknda kukwara. Tǝraɗcha tǝ fichile sakkaɗi kanda kǝɗaɗi. ");
INSERT INTO bvw_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nak mbǝnfatsǝ kaǝn a hǝmǝɗiniyu. ");
INSERT INTO bvw_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nifǝsa mbǝnniyu thlǝmkǝnwa Saminu, lǝ sǝt tor kullata, lafǝraǝn ǝnat pǝɗandǝ Samariyawechafa, la tǝrkǝnwa kapat nifǝ nakǝn. ");
INSERT INTO bvw_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Chikawuni, hanhwe tǝ kapatnifa nat a fǝrandǝ hur'inda tǝ ndatwa: \"Nifiya alchita Fara la atfichǝwa kapat Mwanda.\" ");
INSERT INTO bvw_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","A fǝrangndǝ hur'indǝ kaǝn, kǝthlǝm a mwin tirǝɓ mǝla sǝt ǝnat pǝɗandǝ nofchifa tǝ ǝnat kullechi'en. ");
INSERT INTO bvw_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Paɗ kǝ ɓat nofchiyu fǝrkitta ɓassa Filibus kǝ ɗar kusheng shundǝ ɓinchin kǝ pathlǝ kuturichita Fara tǝ thlǝm Yǝso Kǝrǝsti, sangndǝ baptisma kanda, hischi tǝ nishchi nat. ");
INSERT INTO bvw_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Chika Saminu tǝ i'ndǝ'en a firtǝkit, saǝn baptisma nakna witǝ tǝ Filibus kalutǝndǝhiwa. Saminu nakna nat ichi natna sǝta i pǝɗandǝ nofchifa, mǝlan paɗ pǝɗang ǝnfa. ");
INSERT INTO bvw_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kǝ sǝktǝ fathlǝnchi Urshelimayuwa, Samariyawecha a thlǝɗndǝ pathla Fara, thlǝnangndǝ nda Bitrus tǝ Yohanna kanda. ");
INSERT INTO bvw_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Satengnanda, hwanangnda kaɗǝsi kǝthlǝm kǝ thlǝndǝ Shemeɗ Chiɗchiɗ. ");
INSERT INTO bvw_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kǝthlǝm Chiɗchiɗ tǝ Shemeɗkǝn tǝrwahai kǝ ɗar inda yunǝ kwandǝnwa, tǝ sang fichi baptisma kandǝ ndak a hur thlǝm Lǝmwandǝ Yǝso. ");
INSERT INTO bvw_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ndǝkǝn sandǝ Bitrus tǝ Yohanna harcha kanda in thlǝkndǝ Chiɗchiɗ tǝ Shemeɗa. ");
INSERT INTO bvw_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kǝnat Saminuwa tǝ ɓǝɗa ndǝfhara'inna fathlǝnchǝ la mbǝstǝ fichi Chiɗchiɗ tǝ Shemeɗa, fǝraǝn hanndǝɓǝlta kanda. ");
INSERT INTO bvw_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ndakǝnwa: \"Njang paɗ fǝramitǝn alchiɗiya, kǝthlǝm chikawun ndǝfandi hara'in kǝ thlǝn Chiɗchiɗ tǝ Shemeɗa.\" ");
INSERT INTO bvw_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ndǝkǝn ndandǝ Bitrus wa: \"Sokǝn tǝ hanndiɓǝlteku kǝ thlǝrtuninɗi, mbah sukǝnfǝwa nu mbǝs fǝrta Farǝ tǝ hanndiɓǝlta. ");
INSERT INTO bvw_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Sǝssa hur torchiyawa, kǝthlǝm hanndǝkiketeku nga keeke kǝ mbǝɗa Farǝ wa. ");
INSERT INTO bvw_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Tǝrruhi hur ɓǝɓi ndǝsǝcheku kǝ hwanangnǝ Lǝmwanda ma mbandǝsi kǝ kallukǝn ɓǝɓi yarekuhi. ");
INSERT INTO bvw_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kǝthlǝm kǝlayi sokǝn cheku nat ɗǝhɗǝh, paɗ naku chingching hur ɓǝɓifata.\" ");
INSERT INTO bvw_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ngǝmang Saminuwa: \"Hwanamitǝnsi kǝ mbǝɗa Lǝmwanda kǝthlǝm ichi mbutuni natya, mǝ ɓiɗa ɗar indengnǝwa.\" ");
INSERT INTO bvw_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Kǝ mbwa'andǝ Bitrus tǝ Yohanna kanda i natnda, ɓassangndǝ pathla Lǝmwanda kaɗǝsi le nak ɓinchin, naknda ngǝrangndǝ'ina Urshelima, ndǝkndǝ tǝ ɓassa a thlet hǝmchǝ somsomǝn, a hachahai Samariya oi. ");
INSERT INTO bvw_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ndang mala'ika Lǝmwanda Filibuswa: \"Thla'u ɗu tǝ kukuwun hishingteku kǝ tǝrnǝ mbayi thlaaka Urshelima kǝ Gaza yu, naka mba loktariyu.\" ");
INSERT INTO bvw_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Thlaakǝn pǝɗakǝn, kǝmkǝn tǝlǝ Itiyofiyata mbanda, kullaɓta, kapat nifa a hur kuturichita Kandis, kutur nishcha a Itiyofiyata, mǝlan na lǝ kǝs ndǝɓǝltǝhar. Ɓakna Urshelima kǝthlǝm kǝ mwanaǝn. ");
INSERT INTO bvw_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nakna ngǝrandǝ i'naɗi ɗassa hur ǝnat sokta a Pirish keeke'en, mǝla changngat ɗelwerra Ishaya tapǝna'a. ");
INSERT INTO bvw_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ndang Shemeɗa Filibuswa: \"Ɗuɗuk tǝ Pirish keeketiyu.\" ");
INSERT INTO bvw_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Rahkǝ Filibus kǝ thlǝmmatkǝn, nakna sǝk i nat nifiyu changngata a hur ɗelwerra Ishaya tapǝna'a. Sahang Filibus wa: \"Shinnǝ sakǝt i natu changngatyawa?\" ");
INSERT INTO bvw_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ngǝmang nifiyuwa, \"Naki sǝndǝwa kǝni manga nifi tausang engnǝwa?\" Ndǝkǝn ndandǝna Filibus wa kǝ tǝrǝnsi kǝ ɗa mbǝssndi kǝ sokndǝ rǝmma. ");
INSERT INTO bvw_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","I natna changngata a hur ɗelwertǝkǝn ndatwa: \"Kahkǝ fichindi nda shohrata kǝ mbǝt thletɓurata. Nda i lanat hwan Shohrat ɓa a hara lǝ hǝsta, nakǝn kichu chika miya i'nawuhiwa. ");
INSERT INTO bvw_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Njirkǝndǝndi paɗ njangndǝ kitchitkǝn. Wunna mbǝla mbu kachitkǝn? Kǝthlǝm thla fichǝ shisshingtǝenhi hur kishita.\" ");
INSERT INTO bvw_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ndǝkǝn ndandǝ kullaɓiyu Filibuswa: \"Wunnat tapǝni'iya shunda ɗarkǝn, kǝ ɗar'i'ndi'enwa ndu kǝ ɗar yunǝ somǝn?\" ");
INSERT INTO bvw_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tǝrkaakǝ Filibus shunda tǝrta mbǝɗi changngat nifiyu, nakna mbwa'a kweshcha kusheng shundǝ kǝ ɗar Yǝso. ");
INSERT INTO bvw_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Naknda ɗar wita hur mbanda saakǝnda mbǝɗi nat amsi, ndak nifiyuwa: \"A amya mǝna njat kǝ sikǝ fichi baptisma?\" ");
INSERT INTO bvw_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ndak Filibus wa, \"Ma firnǝkit tǝ hanɗǝkiketǝ ǝrta sukǝ ficha: \"Ngǝmang nifiyuwa Firikit Yǝso Almasihu hweya Farǝ nakǝn.\" ");
INSERT INTO bvw_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Chatkichuyu ndak nifiyuwa kǝ thlarang fichi Pirish keeketihiyu. Nda Filibus tǝ kullaɓiyu tǝrkǝnda haya, yimkǝnda hur ammiyu, sang Filibus baptisma. ");
INSERT INTO bvw_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kǝ natnda cheta hur amkǝn, tǝrang Shemeɗa Lǝmwanda Filibus. Kullaɓiyu ngǝrutǝ natndǝ paɗwa, kǝskǝn mbandǝ'en pǝɗakǝn tǝ mbǝnfata. ");
INSERT INTO bvw_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","A nak fichi Filibus a Azotus. Nakna ɓǝrtǝhi ɓasskǝn kusheng shundǝ mbinchinna thlet hǝmchini natta mbǝnniyu saakǝnna Kaisariya. ");
INSERT INTO bvw_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ɗǝk Shawulu mban tǝ fǝraa lechita fa tǝrmbanda Lǝmwandǝ kaǝn, ndatwa nan ɓǝllandǝ kanda, ɗǝkna ɓǝɗa kapat pǝrist. ");
INSERT INTO bvw_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Hwanaǝn kǝ yaraǝn ɗelwerchisi kǝ mbǝt humta Yahudawechihi a Dimaska, kǝthlǝm kǝ mbǝssǝn mba kǝsandǝ nofcha fa tǝrmbakǝn, hishchǝ tǝ nishchǝ nat kǝɗǝn tǝkanda Urshelima a kǝnda. ");
INSERT INTO bvw_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Mǝla pǝɗata, shee nduk tǝ Dimaska tǝkǝn chat kichuyu ɓak ɗwachita haya afshi tauraǝn Shawulu tǝkǝnhi. ");
INSERT INTO bvw_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Hǝmkǝnhi hachahaiya sǝkkǝn ɓurata ndatwa: \"Shawulu, Shawulu, kǝthlǝmǝ natu ɓahita?\" ");
INSERT INTO bvw_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Mǝlan paɗ ndakǝnwa: \"Wunnaku Lǝmwanda?\" Ndǝkǝn ɗandǝnwa: \"Njang Yǝso le natu fǝra ɓahtiyu. ");
INSERT INTO bvw_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Thla'u kǝ yimna hurhura'a, mbǝnniyu nanda mbu'u i natu sǝta.\" ");
INSERT INTO bvw_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nofchi nannda witǝ rǝmmǝyu, thlarkǝndǝhi kǝmma kanda shundǝsuwa, kanda sǝk ɓuratkǝn nakǝn kanda nat nifǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Thlaakǝ Shawulu a hachahaiya, i'naǝn hwanichi'enhi mbǝla'utǝ nat ǝnwa. Nofchi nannda witǝyu kǝskǝndǝ har'en, ndǝkndǝ tǝnda hurhuri Dimaska. ");
INSERT INTO bvw_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Mundǝ mǝkkan mǝla natmbǝtwa, paɗ sǝmutǝ'ǝnwa sutǝ amwa. ");
INSERT INTO bvw_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Lǝ tǝrɓandǝsa Dimaska lǝ atfichiwa Hananiya, ndang Lǝmwanda a hur ǝn nda sǝnnatǝwa: \"Hananiya.\" Ngǝmanwa: \"A njangya Lǝmwanda.\" ");
INSERT INTO bvw_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ndǝkǝn ndandǝ Lǝmwandǝwa: \"Thla'u kǝ ɗǝnna mbayi la atfichiwa Ndellengnga, kǝ sahnǝ hura'a Yahuda nifi ɓaka Tarsus la atfichiwa Shawuluyu. Nakǝn kicheya mǝla hur hwanda. ");
INSERT INTO bvw_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","A neɗɗa hur ǝn nda sǝnnatǝwa nifa ɓata la atfichiwa Hananiya, ma shee nansa harcha in kǝthlǝm kǝ ngǝrǝn nat mbǝta.\" ");
INSERT INTO bvw_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ngǝmang Hananiya wa: \"Lǝmwanda, a shiki nofchi oiya mbu ɓǝɓi icha ɗar nifinǝyu le sandǝn fa tǝrmbanda a Urshelima: ");
INSERT INTO bvw_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Paɗ pǝktat pǝristchiyu fǝrandǝ alchita kǝ kǝssaǝn chikawun naka at thlǝmwa.\" ");
INSERT INTO bvw_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ndǝkǝn ɗandǝ Lǝmwandǝwa. \"Ɗu, kǝthlǝm teɗindi kǝ sokka ǝnat torrengna, kǝ ɗǝn tǝ thlǝmna mbǝɗa punofcha tǝ kuturcha, paɗ tǝ Isra'ilawecha. ");
INSERT INTO bvw_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ni cheɗa witǝ ɓahhi natna satta kǝthlǝm thlǝmna.\" ");
INSERT INTO bvw_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Pǝɗak Hananiya, ndǝkna mbǝssandǝ Shawulu. Saǝn harcha in, ndakǝnwa: \"Hwan'yaa Shawulu, Lǝmwandǝ Yǝso cheɗukǝ fat'ena mbandǝyu thlinkǝnji kǝthlǝm kǝ ngǝrnǝ natmbǝta paɗ kǝ nǝhǝɗnǝ tǝ Shemeɗ Chiɗchiɗ.\" ");
INSERT INTO bvw_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Chat kichuyu ichi nda ɓwar tinda hǝhatkǝnda haya a hwanichi'en, ngǝrkǝna nata natmbǝta. Thlaakǝn sangfichi baptisma. ");
INSERT INTO bvw_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Sǝmkǝn ǝna ɓak alchit'enaɗi. Sokkǝ Shawulu hi a Dimaska, i hanmunchi ɗǝmek tǝ fa tǝrmbanda. ");
INSERT INTO bvw_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Chatkichuyu tǝrkaakǝn nata ɓasǝ Yǝso, a mbǝt humta Yahudawechihi ndatwa, mǝlan naka hweya Fara. ");
INSERT INTO bvw_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nat fichile sǝkkǝndi, pǝɗang ǝn kandǝfa, ɗakndǝwa, \"Awi nga nifiya wuwelang fa tǝrmbanda Yǝso ɗa a Urshelima wa? Ɓakna mbǝɗya kǝthlǝm kǝ kǝssaǝn kanda kǝ ɗǝn tǝ kanda kǝ mbǝɗa kapat pǝristchikǝn?\" ");
INSERT INTO bvw_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ɓassa Shawulu nakǝn kǝ chektǝ kǝ chektǝ tǝ alchita, paɗ shiwunchi'en kǝ ɗar Yǝso nakǝn tǝɓraɗǝ hur'i'nda Yahudawechihi naka Dimaska. ");
INSERT INTO bvw_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ɗifitǝ hanmunchi kaǝn, humang Yahudawechi miwa nanda mbǝllanda. ");
INSERT INTO bvw_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Kanda ngunguɗndi fiɗiktǝ tǝ farǝ nat, a mimbangnga kǝthlǝm kǝ ɓǝllangnda, a nakǝn kusheng shiwunkǝn himma thlǝmata Shawulu. ");
INSERT INTO bvw_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","A fiɗikta kimshechi'en hǝrkangndǝ tǝ tinkuɓata hur changlangta. ");
INSERT INTO bvw_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Kǝ saatǝ Shawulu Urshelima, sǝkǝn i natna sǝta kǝthlǝm kǝ kǝmndǝ tǝ fa tǝrmbanda, a nakǝn natnda kanda lechanda. Fǝrundǝ kitsuwa shiɗa lǝ tǝrmbandiwa. ");
INSERT INTO bvw_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ndǝkǝn kǝstǝ Barnabas har'en, ɓakǝn tǝnda mbǝɗa fathlǝncha, paɗ mbwa'angna kandǝ kǝmmi kǝmtǝ Shawulu tǝ Lǝmwanda, a mba Dimaska tǝ witǝ shuni shunandǝ Lǝmwanda. Ngǝrkǝn ndanda kandǝ paɗwa ɓesh Shawulu tǝ alchitafa a hur thlǝm Yǝso a Dimaska. ");
INSERT INTO bvw_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Sokkǝ Shawulu tǝ kanda, wu'yaǝn kandǝ nat nda hurkǝn tǝ ɗifitǝkǝn a Urshelima, nakna ɓassǝ tǝ alchitafa a hur thlǝm Lǝmwanda. ");
INSERT INTO bvw_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","A lanakna shundǝ tǝ Yahudawecha fa sǝk Helenanchi kǝna sǝt thlangǝtmi tǝ kanda, yahkǝndǝsi kǝ ɓǝsɗǝ mbanda mbah nanda ɓǝllangnda. ");
INSERT INTO bvw_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kǝɓat fahchikǝnna mbǝssandǝ kichu, tǝrkǝndǝndi kǝ Kaisariya, paɗ thlingkǝndǝndi kǝ Tarsus. ");
INSERT INTO bvw_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Sokkǝn fa tǝrmbayi a Yahudiya tǝ Galili tǝ Samariya yu, ɓeɗnda mbǝs yuyurchita, naknda ɗǝta mban tǝ torchengnanda tǝ alchitafa, kǝthlǝm fa tǝrmbakǝn naknda wita hur lechanda Lǝmwanda. Paɗ tǝ Shemeɗ Chiɗchiɗɗa kǝssanda kandǝsi naknda chekta. ");
INSERT INTO bvw_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Nak Bitrussa nata wiyandǝ mbichi somsomǝn a hurnanda, ɓakna mbǝs hwecha Fara a Lidda. ");
INSERT INTO bvw_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Mbǝnniyu ɓatna mbǝssandǝ nifi la atndǝwa Iniyas, ndukka mbǝthunat hurat foɗffoɗa sheɗ sarǝchi'enaɗi. ");
INSERT INTO bvw_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ndǝkǝn ndandǝ Bitrus wa: \"Iniyas, kǝnnu Yǝso Kǝrǝsti ɗi, thla'u tǝrru mbǝthunaɗeku.\" Chatkichuyu thlaakǝn. ");
INSERT INTO bvw_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Uf nofchi naktǝ sokta a Lidda, tǝ Sharon nakndǝ Iniyas mǝla witǝhi tǝɓǝrkǝndǝhi kǝ mbǝɗa Lǝmwanda. ");
INSERT INTO bvw_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Lǝ tǝrmbandǝsa Yoffa thlǝmkǝnwa Tabita le nat sakǝtkǝnwa Dokas. Kafat'ensi paɗ fǝrchin'ǝna. ");
INSERT INTO bvw_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","A hanmunchiniyu haɗkǝn, mǝrkǝn, fanang ficha ndǝknda ndǝfnda kǝttǝn afshi, kǝthlǝm kǝ thlohahnda. ");
INSERT INTO bvw_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lidda nakǝn nduk tǝ Yoffa. Sǝkkǝ fafǝrkit wa Bitrussa mbǝnniyu. Thlingkǝndǝ nofchi chap kǝ mbǝɗ'en ndatwa: \"Komkom weshu ɓana mbǝs kani nga tǝ kǝfatichitfuwa.\" ");
INSERT INTO bvw_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Thlaakǝ Bitrus pǝɗakndǝ tǝ fichile thlintǝnda. Kǝ saatǝn, ɗǝkndǝtǝnda hurǝ afshitǝkǝn. Kǝttǝnkǝn nihiɗaɗi tǝ ndǝlat nishchi fichile mǝrtǝ hishchengnanda, kanda tita paɗ cheɗangndǝ njelechi tǝ tahhǝt ichi 'yahmandǝ Dokas tǝkǝna kandǝsi, thlahɓǝndǝ natǝn tǝ kanda. ");
INSERT INTO bvw_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Chang Bitrus nofchakissha kǝttǝnkǝn uf, sǝkkǝn kurumchihi, hwankǝn. Kǝ tuɓwandǝn hwakǝn, tǝɓǝrkǝnhi fa murutkǝn ndakǝnwa: \"Tabita, thla'u.\" Chatkichuyu inaǝn hwanichihi, kǝ natǝn Bitrus, thlaakǝn ɗas. ");
INSERT INTO bvw_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kǝskǝ Bitrus har'en thla'aǝn. Ndǝkǝn atǝn ndǝlat nishchi mǝrtǝ hishchengnandǝyu, nat tǝ fafǝrkit, fǝraǝn Tabita tǝkǝnna kanda tǝ shisshingtafa. ");
INSERT INTO bvw_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kusheng shiwunkǝn fankǝnhi a Yoffa nat, paɗ nofchǝ terchin fǝrkǝkit kǝ mbǝɗa Lǝmwanda. ");
INSERT INTO bvw_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Sokkǝ Bitrus hi a Yoffa tǝkǝn hanmunchi kaǝn, hura'a Saminu lǝ tahhasǝ pomcha. ");
INSERT INTO bvw_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nifǝsa a Kaisariya thlǝmkǝnwa Karneliyus. Kapat nifa a mbǝt thlǝrhwata Italiyacha la atfichiwa: \"Hum'i'nda fa thlǝrhwecha Italiya.\" ");
INSERT INTO bvw_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Mǝlan lǝ tǝrmbanda Fara, paɗ lalechengna Fara, mǝlan tǝ nofchi'enna huraa'en. La fǝraǝn icha nofcha tǝ har chaa, paɗ la nakna hwanandǝ Farǝ noknok. ");
INSERT INTO bvw_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Farǝle tǝ farǝhufta hanthlǝkkǝn mǝkkan, nakǝn mala'ika Fara ndaa hursǝnnata mǝla ɓata mbǝsndi, ndaǝnwa: \"Karneliyus.\" ");
INSERT INTO bvw_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kǝllang Karneliyus tǝ lechitafa, ndakǝnwa: \"Mi, Lǝmwanda?\" Ndǝkǝn ndandǝ mala'ikawa: \"Hwandeku tǝ fǝr'ǝnneku shee'a mbǝɗa Fara, ǝnat kuɗuktǝhar a mbanitǝ Fara. ");
INSERT INTO bvw_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nakǝnya, thlǝnu nofchǝ kǝ Yoffa kǝ andǝ Saminu lelǝ atfichiwa Bitrus. ");
INSERT INTO bvw_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nakna sokta mbǝɗa Saminu lǝ tahhasǝ pomcha, le nat huraa'ena mi hawurta.\" ");
INSERT INTO bvw_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Kǝ pǝɗat mala'ika ti shunangyu, ak Karneliyus nofchihar chap a hur mafechi'en, fa sa tora huraa'en, tǝlǝ thlǝrhwata lela lechangnga Fara, hur fichile lǝ sang tor kǝnding. ");
INSERT INTO bvw_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Mbwa'aǝn chikama kanda, thlǝnkǝn kanda Yoffa. ");
INSERT INTO bvw_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ɓingǝtkǝn, nofchi thlǝntǝ Karneliyusyu ndukndǝhi kǝ hurhura'a, pǝɗak Bitrussa hurǝ afshi, ɗǝkna nata hwanda a hurfara. ");
INSERT INTO bvw_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nak mita fi'en, paɗ yahkǝnsa sǝm'ǝna, ficha nǝha'ǝna chat yimkǝnna hur ǝn nda sǝnnata. ");
INSERT INTO bvw_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nakǝn afshi inhi, ǝna ɓatahai nda kapat ɗǝ supta, firficha hai tǝ kukuwunchi'en fwaɗɗa. ");
INSERT INTO bvw_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","I sǝka ɗǝhǝrǝmta neesa hurkǝn, fa sarǝchǝsǝ fwaɗɗa, tǝ fa kah hurcha hachahaya tǝ ɗishcha. ");
INSERT INTO bvw_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Sǝkkǝn ɓurata ndanduwa: \"Thla'u, Bitrus: thliu ɓurata kǝ chiina.\" ");
INSERT INTO bvw_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ndǝkǝn ndat Bitruswa: \"Auwa Lǝmwanda, kǝthlǝm tamwi chi i nguchik chiɗchiɗ ndu ndǝɗuwowa.\" ");
INSERT INTO bvw_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ngǝrkǝn sǝk ɓuraɗiyu i chapatǝkǝn ndatwa: \"I tahsandǝ Farǝhi tamina ndatwa nga chiɗchiɗwa.\" ");
INSERT INTO bvw_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Kurɓang iniyu sǝt mǝkkan. Chat kichuyu kahang fichi ǝnatkǝnaɗi kǝ afshi. ");
INSERT INTO bvw_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nak Bitrussa hur ɓweechitfat kaǝn, kǝ ɗar i'ni nda sǝnnatiyuwa nakna sokta mi? Chat nofchi thlǝntǝ Karneliyusyu sheenda hura'a Saminu, thlerkǝndǝhi kikkita mimbangnga. ");
INSERT INTO bvw_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Akndǝfata sahkǝnda, nifi la atfichiwa Saminu Bitrusyu, ndu tǝrkǝna haya mbǝnniyu. ");
INSERT INTO bvw_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Kǝnat Bitrussa yarandǝ i'nihi nda sǝnnatiyu, ndang Shemeɗwa: \"Sǝku, ɓeɗ nofchǝ mǝkkan kanda katsa. ");
INSERT INTO bvw_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Thla'u, tǝruhaya, kǝ pǝɗuni tǝ kanda, mǝ ndǝrminǝwa kǝthlǝm njang thlǝngkǝ kanda.\" ");
INSERT INTO bvw_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ndǝkǝn tǝrtǝ Bitrussa hai kǝ mbǝɗa nofchiyu, ndakǝnwa: \"Njangya njang natuni kata. Kǝthlǝm mǝ ɓatuni?\" ");
INSERT INTO bvw_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ndǝkǝn ndatndǝwa: \"Karneliyus kapat nifa a Romacha thlǝngkǝkani. Kanifǝ nakǝn, paɗ lǝ mwana'ǝn Farǝ noknok, Yahudawechǝ nat la fǝrangndǝ mwanda. Chiɗchiɗ tǝ Mala'ikachǝ ndangwa, kǝ thlǝnukǝn fata kǝ ɗina huraa'en kǝthlǝm kǝ sǝkǝn i natu mbuta.\" ");
INSERT INTO bvw_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Sang Bitrus marapa kanda, ndangna kandǝwa kǝ hunandǝhi ke wenmbǝta. Ɓingǝtkǝn, thlaakǝn pǝɗakndǝ tǝ nochiyu, funǝ hwanmanchisa Yoffa ndǝfkǝndǝndi. ");
INSERT INTO bvw_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Saakǝnda Kaisariya ɓingǝtkǝn. Karneliyus mǝla pukanda, paɗ ngomandǝ hwanmanchikǝn tǝ shikechikǝn. ");
INSERT INTO bvw_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kǝnat Bitrussa yimta hurǝkǝn, sang Karnǝliyus marapa, himkǝna mbanitǝkǝn nakna mwananda. ");
INSERT INTO bvw_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Thla'ang Bitrus, ndaǝnwa: \"Thla'u, njangma nifǝnaki nda sokǝn.\" ");
INSERT INTO bvw_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Bitrussa ɗar shundǝ tǝndi yimkǝnda huri, ɗǝknda mbǝstǝ hwim nofchǝ oi. ");
INSERT INTO bvw_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ndangna kandǝwa: \"Kunang tǝ inchengnuni shinuniwa, keekesuwa lǝ Yahudawat kǝ sǝn shikechit ndu kǝ humndǝhi tǝ punofchǝwa. Farǝ cheɗikǝwa mǝ tǝrǝndi chikawun wa nga chiɗchiɗwowa. ");
INSERT INTO bvw_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ndǝkǝn sǝk ɓati kaɗi katfichinji a cherwifǝwa. Mbwa'amitǝn i sǝk thlǝnitunifata: ");
INSERT INTO bvw_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ndǝkǝn ngǝrtǝ Karneliyus sǝwa: \"Munǝ fwaɗɗa mbǝrkǝhiyu nja hwandǝ hure'engna, hanthlǝkkǝn mǝkkan i farǝhufta a hure'engna, ɓak nifa mbǝsnji tǝ furnjelechafa lela tǝrang hwanita, thlarkǝnhi mbanitina. ");
INSERT INTO bvw_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ndakǝnwa, Karneliyus, ngǝmma Farǝ hwaɗeku tǝ fǝr'ǝneku, shokka ǝnat kuɗukta mbǝɗa Fara. ");
INSERT INTO bvw_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kǝthlǝm ndǝkǝn, thlǝnu nifi nakǝnya kǝ Yoffa kǝ afichi Saminu lǝ atfichiwa Bitrusyu, tǝrkǝna haya a hura'a Saminu lǝ tahhasǝ pomcha, nduk tǝ mi hawurta.' ");
INSERT INTO bvw_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Chat kǝ thlǝnuti fata, a ndǝrmunǝwa ɓaku. Nakǝnya kanang naka mbǝɗya, nakani mbanitǝ Fara, kǝ sǝkani i fǝrrutǝ Lǝmwanda kǝ mbwa'angna kani.\" ");
INSERT INTO bvw_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ndǝkǝn tǝrkaatǝ Biturssa shunandǝ kandǝ tǝ ndatwa: \"Nakǝnya ɓǝsaɗi tǝ ndatwa Farǝ taɗuharwa. ");
INSERT INTO bvw_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","La thlǝkǝn fichile lalechanga, tǝ fichile la sǝk i nak keeke kǝ ɓǝɗa nofcha. ");
INSERT INTO bvw_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Shinuniwa shuniya thlǝnkǝ Fara mbǝɗa Isra'ilawecha, ficha ɓassa kashuwun yuyurchita kandǝsi tǝ mbǝɗa Yǝso kǝrǝsti. Le naka Lǝmwandǝ nat. ");
INSERT INTO bvw_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Shikuni i sǝka a hachahai Yahudiya nat, tǝrkata a hachahai Galili, ɗifitǝ ɓassǝ baptismati sǝt Yohanna. ");
INSERT INTO bvw_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Paɗ shinuni kusheng Yǝso Lǝnazaratta, witǝ i sǝt Farǝ kǝ ɗarkǝn fǝrandǝn Shemeɗ Chiɗchiɗ tǝ alchita. Ɗǝk Yǝso mban tǝ ka torcha, mǝla kǝnadǝ nofchandǝ nat fichile kǝsti Sheɗan har, kǝthlǝm Farǝ tǝndi. ");
INSERT INTO bvw_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Kanang na shetacha, kǝthlǝm neɗani ichi sǝttǝn nat a Yahudiya tǝ Urshelima. Ɓǝllangnda tǝ mba kukwandǝhi ɗar palita. ");
INSERT INTO bvw_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Thla'ang Farǝ tǝ shisshingtafa a farǝ mun mǝkkatǝkǝn. Malaǝn paɗ kǝ cheɗin fat'en. ");
INSERT INTO bvw_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Cheɗutǝ fat'en kǝ mbǝɗa nofchi natwa, paɗ kǝ mbǝɗa fichile taɗtǝ Farǝ har kǝ soh, kanang hacha, sǝmkǝ'ǝn tǝ sat'ǝn tǝndi ɗiffitǝ thlatǝ'ena kwata. ");
INSERT INTO bvw_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Fǝraǝn tora kani kǝ ɓasangani nofchisi chika tǝteni, paɗ kǝ cheɗani tǝ kitwa, Yǝso mǝlan taɗtǝ Fara lǝ thlakita chikawunsa hur fa shisshingtǝ tǝ mǝmatcha. ");
INSERT INTO bvw_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Mǝlan shiwuntǝ tapǝnecha inkǝn ndatwa: \"Chikawun fǝrkǝkit kǝ mbǝɗ'en, na ficha kala ɓǝɓifechi'enhi hur thlǝmkǝn.\" ");
INSERT INTO bvw_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nak Bitrusa hur shiwunchiniyu, ɓak Chiɗchiɗ tǝ Shemeɗa ɗar chikawun naka sǝk shiwunchi'en. ");
INSERT INTO bvw_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yahudawechǝ fa tǝrmbandǝ ɓaka Yoffa ndǝfkǝ Bitrus yu, pǝɗang ǝn kandǝfa, kǝthlǝm a thlǝr Farǝ Chiɗchiɗ tǝ Shemeɗ hi chika kǝ ɗar punofcha. ");
INSERT INTO bvw_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kǝthlǝm shikndǝ kandǝ kanda shundǝ tǝ michǝ somsomǝn, kanda mwanandǝ Fara. Ndǝkǝn sahtǝ Bitrus wa: ");
INSERT INTO bvw_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","\"Yunisi na njat kǝ sangfichi baptisma nofchiyawa, taɓkǝn kǝ thlǝndǝ Shemeɗ Chiɗchiɗ nda i thlǝtani?\" ");
INSERT INTO bvw_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ndǝkǝn ndatǝnwa kǝ sangfichi baptisma kanda a hur thlǝm Yǝso kǝrǝsti. Ɗiffitǝkǝn ndǝkǝn ndandǝnda Bitruswa kǝ chekaǝn munchi ɗimek kicha a thlǝmatnanda. ");
INSERT INTO bvw_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Fathlǝncha tǝ fa fǝrkitti naka Yahudiya, sǝkkǝndǝwa thlǝɗ punofchǝ pathla Fara. ");
INSERT INTO bvw_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kǝ ɗǝt Bitrussa Urshelima, thla'ang pǝktat Yahudawachǝfa, fichile fǝrkǝkit kǝ ɗar hesha, ndatwa: ");
INSERT INTO bvw_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","\"Yimku hura'a punofcha fichile heshuchika sǝmku ǝn tǝ kanda\" ");
INSERT INTO bvw_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Mbwa'ang Bitrussa kandǝ keeke nat i sǝka. ");
INSERT INTO bvw_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","\"Nja hǝmǝt Yoffa nja hwanda, naki'ǝn ndaa hur'sǝnnata, naki ǝna ɓata haya hur'afshi nda kapat ǝnat supta, firficha haya hur'afshi tǝ kukuwunchi'en fwaɗa, saakǝn nduk tǝnji. ");
INSERT INTO bvw_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Kǝ kǝlandi nduk a naki ɗǝhǝrǝmcha, tǝ hanthlucha hurhwela'a tǝ fa kah hura hachahaya tǝ ɗishcha. ");
INSERT INTO bvw_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Sǝkki ɓurata nditǝwa: \"Thla'u, Bitrus: ɓǝllu kǝ chiina.' ");
INSERT INTO bvw_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ndakiwa auwa Lǝmwanda, tamu kohat ǝnkichu ndu i nguchik ndiichina yimta hurmiyengnuwa. ");
INSERT INTO bvw_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ngǝmang ɓurata hur'afshi, shuwunkǝn i chapatǝkǝn, ndatwa: \"I sǝt Farǝ chiɗchiɗ kǝ ndǝnuwa ndǝɗuwowa.' ");
INSERT INTO bvw_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Kurɓang iniyu sǝt mǝkkan, kana ficha ngǝr kahanda hur'afshi. ");
INSERT INTO bvw_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Chatkichuyu ɓak nofchǝ mǝkkan kǝ huri'i natanisi, thlǝntǝ fichǝ kanda a Kaisariya kǝ mbǝɗengna. ");
INSERT INTO bvw_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ndak Shemeɗ Chiɗchiɗwa, kǝɗi tǝ kanda mǝtaɗiɗiharwa. Ɗǝfkǝ hwanmanchǝ nji tehhethl, yimkani hura'a nifikǝn. ");
INSERT INTO bvw_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mbwa'angna kani naɗi natǝn mala'ika kitta hura'en ndakǝnwa, 'Thlǝnu nofchǝ kǝ Yoffa kǝ afichi Saminu nat thlǝmkǝn paɗwa Bitrus: ");
INSERT INTO bvw_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Mǝlan na mbu shuni na fǝru hǝrǝkta, sokǝn tǝ nofchi hure'eku nat. ");
INSERT INTO bvw_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Kǝ tǝrkaati ka shunda, ɓak Chiɗchiɗ tǝ Shemeɗa hai kǝ ɗar inchengnandǝ nat nda i ɓatna hai kǝ ɗar inchengnani a tǝrkakǝn. ");
INSERT INTO bvw_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kuɗukki shunda Lǝmwanda nda i ndatǝnwa, 'Sǝk Yohanna baptisma tǝ ama, kunang nak ficha sa baptisma kuni tǝ Shemeɗ Chiɗchiɗ.' ");
INSERT INTO bvw_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Sokkǝn fǝrra Fara kandǝ keeke tǝ le sandǝn kǝm, fari fǝrtǝm kit kǝ mbǝɗa Lǝmwandǝ Yǝso Kǝrǝsti, wun njang na ndanda Farǝ wa nga kichuwa?\" ");
INSERT INTO bvw_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kǝ sǝktǝndǝ kichu ɓahkǝndǝ i natnda mbuta, mwanangndǝ Fara ndatwa: \"Awi chika punofchima i'na Farǝ mba tǝrtǝhi kandǝsi tǝ mbǝs shisshingta.\" ");
INSERT INTO bvw_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Fichile wuwelkǝhi kǝthlǝm pwanchi thlaakǝ kǝ ɗar Istifanusyu, pǝɗakndǝ kǝ hachahai Finikiya tǝ Sayifurus tǝ hǝmǝt Antakiya, naknda ɓassa shuwunkǝna Yahudawechisǝ ɗeng nga chika wunwa. ");
INSERT INTO bvw_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Funǝsa hurnanda Sayifuruscha, tǝ Sayirincha, kǝ saatǝnda Antakiya ɓassangnda punofchisi, naknda mbwa'a kweshcha kusheng shunda kandǝ kǝ ɗar Lǝmwandǝ Yǝso. ");
INSERT INTO bvw_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Hara Lǝmwandǝ tǝkanda, nofchǝ oi fǝrkǝ kit tǝɓǝrkǝndǝhi mbǝɗa Lǝmwanda. ");
INSERT INTO bvw_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Kusheng shuwun i sǝka, saakǝna thlǝmata fa tǝrmbanda a Urshelima, thlǝngkǝndǝ Barnabas kǝ Antakiya tǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Kǝ saatǝn paɗ a neɗtǝ kafaɗi sandǝ Farǝ kanda, sǝkǝn mbǝnfat kaǝn paɗ chekaǝn alchita kandǝ tǝ ndatwa, kǝ thlarndǝ tǝ alchitafa hur fǝrkit kǝ mbǝɗa Lǝmwanda tǝ hanndǝkikechengnandǝ nat. ");
INSERT INTO bvw_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Kǝthlǝm Barnabas kanifǝ nakǝn, nihǝɗaɗi tǝ Shemeɗ Chiɗchiɗ paɗ tǝfǝrkit. Chekkǝ nofchǝ oi kǝ mbǝɗa Lǝmwanda. ");
INSERT INTO bvw_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pǝɗak Barnabassa Tarsus kakat Shawulu. ");
INSERT INTO bvw_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kǝ mbǝssandǝn, ɓakǝn tǝnda Antakiya. Hurata, nda Barnabas tǝ Shawulu kanda kǝmtǝ kǝ mbǝt ngǝlhwanita, kanda sakanda nofchihar oi. A Antakiya tǝrkaatǝ ficha at fa tǝrmbachǝwa Kǝrǝstacha. ");
INSERT INTO bvw_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","A hanmunchiniyu funǝ tapǝnechǝsi ɓaka Antakiya thlata Urshelima. ");
INSERT INTO bvw_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ərta hurnanda thlǝmkǝnwa Agabus, thlaakǝn kit shuwunkǝn tǝ alchit Shemeɗa fa ndatwa, na mita natsǝ kaǝn hur kishitǝ nat, sǝk mitǝkǝna thlahmbǝt kuturichita Kalaudiyus. ");
INSERT INTO bvw_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ndǝkǝn tǝrtǝ fa tǝrmbandǝhurwa, chikawun nan fǝr ǝna keeke a alchit'en kǝthlǝm kǝ thlǝnang ficha hwanmanchi naka hachahai Yahudiya. ");
INSERT INTO bvw_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Sǝkndǝ kichu, thlǝnangnda pǝktechi mbǝnniyu tǝ hara Barnabas tǝ Shawulu. ");
INSERT INTO bvw_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nda mbǝt kicheeya, Hiridus kutura tǝrkaatǝn fǝrra ɓahta funǝ fafǝrkit a mbǝt ngǝlhwanita. ");
INSERT INTO bvw_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ɓǝllaǝn Yakubu hwanman Yohanna tǝ thlohta ");
INSERT INTO bvw_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kǝ natǝn ǝnatkǝn mbǝnaɗa Yahudawechǝ fa, thlaakǝn kǝssaǝn Bitrus paɗ, sǝk i'niyu a thlahmbǝt chohhǝm sǝmɗǝsǝmta le nguchit mehndǝsa fi'en. ");
INSERT INTO bvw_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kǝ kǝsandǝn muhkǝnnda pursuna, fǝrangna fathlǝrhwecha har, fathlǝrhwechǝ fwaɗa fwaɗa sakkǝn fwaɗa, tǝ yarǝwa ma mbir chohhǝmkǝnhi kana ɓattǝnda mbanitǝ nofcha. ");
INSERT INTO bvw_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kuɓlang fichǝ Bitrus kǝ hur pursuna, nak fangǝlhwanicha hwananǝndǝ Farǝ tǝkit kǝ ɗarkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","A fiɗikiniyu manat Hiridussa chandǝ Bitrussa kish, mǝla saɓweni a thlerǝ fa thlǝrhwechǝ chap. A kǝnandǝ tǝ chalaluchǝ chap. Fa thlǝrhwatkǝn kanda ɗar tor kiikit a mimbang pursuna. ");
INSERT INTO bvw_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Chatkichuyu, ɓak mala'ika Lǝmwanda thlarǝ nduktǝndi, yimkǝ ɗwachita hurkǝttǝnkǝn. Tǝkang mala'ika tǝkǝn harra Bitrus fa mumi thla'a'ǝn, ndaǝnwa: \"Thla'u leɗleɗ.\" Chalaluchi har'enyu kwaskǝndǝhi chuthla. ");
INSERT INTO bvw_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ndǝkǝn ndandǝ mala'ika tiiyuwa: \"Kǝnan ɗǝ kǝndeku kan ndiichin, kǝ panǝ pahǝmcheku.\" Sǝkǝn kichuyu. Ndang mala'ikawa: \"Suppu ndǝ supteku fa kǝ kuwurnǝnji.\" ");
INSERT INTO bvw_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Chekna kissha pursuna tǝkǝn nakna kuwur mala'ika tǝkǝn. Ichini natyu sǝnuwa kitwa, naǝnhiwa ǝnnda sǝnnata natna hurkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Kǝ pǝɗandǝnda fa pumbǝtkǝnhar i tǝrkakǝn tǝ'i chapatǝkǝn saakǝnda mimbangngi sǝtfichi tǝ tǝpassa lela chetfichi chat kǝ hurhura'a, inangna kandǝsǝ ichitkǝn. Chekndakish naknda wita hurmbakǝn, chatkichuyu mala'ika tǝkǝn malkǝnndǝhi. ");
INSERT INTO bvw_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kǝ ɓat Bitrussa ndǝ kǝ hur'indi'en, ndakǝnwa: \"Nakǝnya sǝntiwa tǝ kit Lǝmwandǝ thlǝngkǝ mala'ika'en, kǝ ɓa hǝrkǝta a hara Hiridus tǝ ɓǝɓi sakta Yahudawecha.\" ");
INSERT INTO bvw_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kǝ mbǝsandǝn kichu, pǝɗakna hura'a Maryamu, man Yohanna la atfichiwa Markus, mbǝɗi humtǝ nofchǝhi oi kanda hwanda. ");
INSERT INTO bvw_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kǝ fuɗandǝ Bitrus mimbangkǝn, ɓak hwanhura'a kish kǝ nuhhweya nat thlǝmkǝnwa Roda, kǝthlǝm kǝ nan ndu wuni. ");
INSERT INTO bvw_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kǝ mbǝssandǝn kǝ ɓurata Bitrus, ngǝraǝn'in kǝ huri inawutǝ mimbangkǝnhiwa, kǝthlǝm mbǝnfata, ndangna nofchiiyuwa: \"Bitrus kita mimbangnga.\" ");
INSERT INTO bvw_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ndangndǝwa: \"Tǝrru luwurcha!\" Mǝlan paɗ nakna nata ɗahanda kandǝ'in wa mǝlan. Ndǝkǝn ndatndǝwa: \"Nakna nat kǝ mala'ika'en.\" ");
INSERT INTO bvw_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Bitrus paɗ nakna nata fuɗandǝ mimbangngiyu. Kǝ inaandǝndǝ mimbangkǝnhi nakndǝ kǝ mǝlan, pǝɗang ǝn kandǝfa. ");
INSERT INTO bvw_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Mǝlan paɗ thla'aǝn hara kanda kǝ ngasndǝɓa, mbwa'angna kandǝ chayi chandǝ Lǝmwanda kissha pursuna. Ndakǝnwa: \"Kǝ mbwa'anguni Yakubu tǝ tahhǝt hwanmancha ichini sǝk natyu.\" Pǝɗakna mbǝt somǝn. ");
INSERT INTO bvw_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Wendambǝta, nga hwan thlahur'indi thlaaka hurɗifitǝ fa thlǝrhwechiyuwa kǝ ɗar i kǝskǝ Bitrus. ");
INSERT INTO bvw_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Kǝ kat Hiridus ndi mbǝssawuwa, nakna tawasǝ kitchitkǝnna mbǝɗa fa pukǝnhar. Fǝrkǝn mi tǝ ndatwa kǝ mbǝllangfichi kanda. Ɗiffitǝkǝn thlaakǝ Hiridus a Yahudiya pǝɗakna Kaisariya, sokkǝnna mbǝnniyu kǝ farǝyuna. ");
INSERT INTO bvw_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Nakǝnya shiɓhura Hiridussa ɗi tǝ nofcha Taya tǝ Sidon. Nak nofchini kichuyu ɓaknda mbǝɗ'en, ɗiffitǝ kahhandǝ hur'inda Bilastus le nak mwanchina hura'a kutura, kǝthlǝm kǝ mbǝsndǝ sok yuyurchita paɗ la mbǝskǝndǝ ndǝsǝmta a furta Hiridus tǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","A farǝle fari tahsandǝ fichihi kǝmtǝ tǝ kutura, pak Hiridus njeli kuturichit'en, sokkǝna mbǝt sok kuturichita shunaǝn nofcha. ");
INSERT INTO bvw_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nofchi humkǝyu hwaknda ndatwa: \"Leya nga ɓurata nifǝwa, ɓurata lura.\" ");
INSERT INTO bvw_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Chatkichuyu tǝpkǝ mala'ika Lǝmwandǝ Hiridus hi, kǝthlǝm fǝrautǝ mwanda Farǝ wa. Mbǝnniyu cha'ang hwacha Hiridus mǝrkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","A nak shunda Fara nata fandǝhi chika tǝteni, nakna ndǝta mban nak fa fǝrkitta chekta. ");
INSERT INTO bvw_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Kǝ tǝɓwandǝ nda Barnabas tǝ Shawulu i natnda sǝta a Urshelima, ngǝrangndǝ'in kǝ Antakiya, tahkǝndǝ Yohanna in la atfichiwa Markus. ");
INSERT INTO bvw_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","A kǝtǝn whayi a Antakiyayu Tapǝnechǝsi tǝ malɗǝmcha, Barnabas, Samiyon la atfichǝwa pukǝn, Lushiyus le ɓaka Sayirin, tǝ Manayen, le mwantǝnda mbǝt ǝrtǝ tǝ Hiridus kutura tǝ Shawulu. ");
INSERT INTO bvw_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Naknda mwananɗǝ Lǝmwanda tǝ kǝrkushimta, Ndak Shemeɗ Chiɗchiɗ wa: \"Ɗǝffaam Barnabas hi tǝ Shawulu kǝllar kǝthlem tori ati kanda.\" ");
INSERT INTO bvw_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ɗiffitǝ kǝrkushimta tǝ hwanda sangndǝ harcha kanda in ndangnda kandǝwa pǝɗama. ");
INSERT INTO bvw_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kandang paɗ kǝ thlǝntǝ Shemeɗ Chiɗchiɗ kanda, pǝɗaknda hai kǝ Salukiya, thlaakǝndǝ kǝ Sayifurus hur kommbawal. ");
INSERT INTO bvw_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Kǝ saatǝnda Salamis, ɓaskǝndǝ pathla Fara hur kǝtǝn humta Yahudawechǝhi. Yohanna mǝlan tǝkanda nakna kǝsanda kandǝsi. ");
INSERT INTO bvw_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kǝ wiyangndǝn hachahaikǝn nat ɓaknda Bafos, kǝmkǝndǝ tǝlǝ Yahudawata lǝ kulata, tapǝna'a lǝ lekta, thlemkǝnwa Bar Yoshuwa. ");
INSERT INTO bvw_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Le humandǝndǝ i'ndǝ tǝle kǝskǝ hachahaikǝn har, Sarjiyus Bulus, mǝlan ti naka lǝ sǝn'ǝnna. Ngomna tǝkǝn akǝn nda Barnabas tǝ Shawulu, kǝthlem yahsa sǝk pathla Fara. ");
INSERT INTO bvw_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Paɗ Alimas lǝ kulata (kǝthlem sakǝt thlemkǝn kichu tǝ miya Heliniyawecha), fǝrautǝ hum'inda kandǝwa, nakna katkǝ tǝpraǝn hur inda ngomnatǝkǝnhi a hur fǝrkitchiɗiniyu. ");
INSERT INTO bvw_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Nakǝn Shawulu la atfichǝ paɗwa Bulus, nihiɗ tǝ Shemeɗ Chiɗchiɗ, kǝlaǝn Alimas ndongnga kǝ hur hwanita. ");
INSERT INTO bvw_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Ndakǝnwa: \"Sokǝn hweya sheɗan, atikretǝ ichi nak ndiichin nat. Lǝ lektǝ naku paɗ lǝ shekɗaɗǝ nofcha. Nguna malandǝ tǝɓrandǝ kitchit mbanda Lǝmwandǝhiwowa? ");
INSERT INTO bvw_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nakǝnya haraa Lǝmwanda sǝt atikrechit tǝssa, paɗ nukukomta nguna mbǝlla nat hwatfarǝwa, kǝ hanthlikchi ɗemek: \"Chatkichuyu hussoɓa tǝ hulta ngǝlangndǝ hwanitǝ'en. Nakna tapta kǝna kat le na kǝssandǝsi. ");
INSERT INTO bvw_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kǝ nat ngomna tǝkǝn i sǝka fǝrkǝn kit, kǝthlem pǝɗa'ǝnatkǝnfǝ oi kǝ ɗar sakta Lǝmwanda. ");
INSERT INTO bvw_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nakǝnya Bulus tǝ shikechǝ witǝ'en, thlaakǝnda Bafos a hur kommbawal, pǝɗaknda Ferga chaa tǝ hachahai Famfiliya. Yohanna malkǝnkandǝhi ngǝraǝn inna Urshelima. ");
INSERT INTO bvw_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ɓǝrkǝɗǝhi kǝ ɓan thlata Ferga, pǝɗaknda Antakiya tǝ hachahai Bisindiya. Farǝ yipta Yahudawecha yimkǝnda kǝtǝn humta Yahudawechihi sokkǝndǝhi. ");
INSERT INTO bvw_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ɗiffitǝ changngata hur kus tǝ ɗelwercha tapǝnecha, fambanichikǝnna hur kǝtǝn humta Yahudawechikǝn, thlǝnangnda kanda ndatwa: \"Hwanmancha ma shundengnunisi lena kǝssanda nofchǝsi mbwa'ama.\" ");
INSERT INTO bvw_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Thlaakǝ Bulus kit thla'a'ǝn haraa kǝ ngas nofchǝ ɓa, ndakǝnwa: \"Kunang hwanmanchǝnǝ Isra'ilawecha, tǝ kunang ti lalechangnga Fara, kam thlǝmathi. ");
INSERT INTO bvw_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Fara nofcha Isra'ila, taɗkǝ kakechengnǝm teraǝn kandǝ oi. A thlahmbǝɗi natnda soktǝ nda romcha a hachahai Masar, paɗ tǝ kapat alchita chandǝn kandakish a hachahaikǝn. ");
INSERT INTO bvw_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kǝrǝskǝn kandǝ hurat kumchit fwaɗa a hur loktara. ");
INSERT INTO bvw_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ɗiffitǝ thlǝrtandǝ hachahaichaɗǝ muɗ hur Kan'ana, fǝraǝn hachahaikǝnna Isra'ilawecha kǝ sokka innanda. ");
INSERT INTO bvw_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Sǝk i'ya a hur hurat aru fwaɗa tǝ kumchit ɗurman. Ɗiffitǝ ndǝkǝn fǝraǝn fa sak miya kanda kǝ thlahɓǝt tapǝnaa Samaila. ");
INSERT INTO bvw_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Hwankǝndǝ kǝ fwaɗangfichǝ kutura kandǝsi, fǝrang Farǝ Shawulu kanda. Hweya Kish, kachit nda Bilyaminu, le sokkǝ kuturichit hurat kumchit fwaɗa. ");
INSERT INTO bvw_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kǝ kǝtandǝ Farǝ Shawuluhi, tha'a'ǝn Dauda kǝ sokka kuturreng nanda. Le fǝrtǝ Farǝ sheta kǝɗarkǝn ndatwa: \"A mbǝshi Dauda hweya Yessi, nifǝ lǝwitǝ hanɗǝkiketengna, le na sǝt i yahti nat.' ");
INSERT INTO bvw_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","\"Hur kachit nifǝniyu, ɓat Farǝ tǝ lena Thlǝt Isra'ilawechaɗi, Yǝso, nda i ɗǝftǝn shuwunkǝnhi. ");
INSERT INTO bvw_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ɓassa Yohanna nofchǝsǝ nat a Isra'ila kǝtǝrndǝhi, kǝ sangfichǝ baptisma kanda, kanna Yǝso ɓata. ");
INSERT INTO bvw_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kǝ nat Yohanna nduk tuɓandǝ tor'en, ndakǝnwa, lanaǝn kunihiwa wunnaki? Njang nga mǝllanwa. Auwa, yunaɓata ɗifitǝna, le sukuchitisi kǝ kwassayi sahǝtpahǝmchi'enhi.\" ");
INSERT INTO bvw_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","\"Hwanmancha, kachit Ibrahim, tǝ fichile hurnuni lalechangnga Fara, kǝ mbǝɗengnǝm thlǝntǝfichǝ kusheng shuwun hǝrǝkiya. ");
INSERT INTO bvw_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nofchi nak tǝ sokta hur Urshelima tǝ fambanichengnanda, mbǝssaundǝwa mǝllanwa, paɗ sunundǝwa mǝllan shuwuntǝ tapǝnecha ɗarkǝn, la changkandǝfichǝ pwaree a farǝ yipta Yahudawecha, nǝhɗangndǝ shuwunkǝnhi tǝ kiitati thlandǝndǝsi. ");
INSERT INTO bvw_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Chika mbǝssauchikndǝ tǝ chithansarǝhiyu, le kamkǝsi kǝ mǝrrǝn, chika tǝkichu hwanangndǝ Bilatus kǝ ɓǝllangficha. ");
INSERT INTO bvw_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kǝ nǝhɗandǝndǝ ichihi yaratfichǝ kǝ ɗarkǝn nat, tǝrangndahaya ɗar palita hunangnda hur kwata. ");
INSERT INTO bvw_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Thla'ang Fara hur mǝmatcha. ");
INSERT INTO bvw_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Munchǝ terchin mǝla cheɗafat'ena fichile ɓatndǝtǝndi, thlata Galili kǝ Urshelima, kandang naka shetachi'en nakǝnya kǝ mbǝɗa nofcha. ");
INSERT INTO bvw_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Paɗ kanang ɓangngani kweshcha shuniya kuni tǝndatwa, ɗǝfshuni ɗǝffandǝ Fara shinchinǝmhi. ");
INSERT INTO bvw_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Nǝhɗaɗǝngnǝm hi, kǝmnangti naka hwechengnanda, tǝ mbǝɗa thla'andǝ Yǝso a hur mǝmatcha. Nda i natna hur yaratkǝn, a hur chapatǝ Zabura ndatwa: \"Sokǝn naka hwe'engna, ɓukweya sokkǝ kǝ sukka.\" ");
INSERT INTO bvw_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Pathlǝ thla'ai thla'andǝna hur mǝmatcha, ndatwa: \"Ngu ngǝr mǝrtaɗi ndu kǝ ngǝrǝn yirata hurkwatwa.\" A i mbutǝnya, ni fǝrru chiɗchiɗchita tǝ kitchit mbǝs'ǝnharra Dauda. ");
INSERT INTO bvw_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Kǝthlem ndǝkǝn ngǝrkǝn ndat paɗa hur Zabura tǝllewa: \"Ngu malandǝ le nak chiɗchiɗ kǝ yiraka hur kwatwa.' ");
INSERT INTO bvw_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Kǝ mweshandǝ Dauda tori fǝrandǝ Fara, a thlahmbǝt tor'en mǝrkǝn, thlohhangficha, mbǝɗi thlohhandǝfichǝ shinchikǝn, yiraknaɗa hur kwata. ");
INSERT INTO bvw_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Le thla'andǝ Fara a yirruwa. ");
INSERT INTO bvw_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Kǝ sǝnnunisi hwanmancha, ndatwa tǝ mbǝɗa Yǝso natficha kalla ɓǝɓichitfechengnuni kunihi. ");
INSERT INTO bvw_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Chikawun fǝrkǝkit tǝ mbǝɗ'en mbishtǝ hǝrǝkta. Hur chikamǝnat le nguchittu hǝrǝktǝ tǝ kussa Musa. ");
INSERT INTO bvw_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kǝthlem ndǝkǝn ɗǝffam'indǝsi, mǝɓi i mbutǝ Fara hur ɗelwercha tapǝnecha kǝ mbǝssǝnkuniwa ndatwa: ");
INSERT INTO bvw_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","\"Namma, kunang fa njirfata, kǝ pǝɗang'ǝnkunifa, kǝ mǝrruni kǝthlem ni sǝt tora hanmunchengnuni, tori nguchittuni fǝrkitchitsi, chika mbwa'ang yuna kuni.\" ");
INSERT INTO bvw_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Kǝ chetnda Bulus tǝ Barnabassa kish, hwanang nofchǝkǝn kandǝ ndatwa, kǝ ngǝrnda ɓata mbwa'a ichiniyu kanda, a farǝ yipta Yahudawechi na ɓatyu. ");
INSERT INTO bvw_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ɗiffitǝ wuwela nofchǝ hi, Yahudawechǝ oi tǝ fichile fǝrkǝ inndǝ kaǝn, kǝtǝr mbanda yahudawecha, kuwurkǝndǝ Bulus tǝ Barnabas, shunang ndǝ kanda. Paɗ ndangnda kandǝwa, kǝ ɗǝndamban tǝ nata hur kafata Fara. ");
INSERT INTO bvw_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ngǝrkǝ farǝ yipta Yahudawecha sata, sokkǝn chikawuna hur hǝmǝtkǝn, hwimndǝhi kǝthlǝm kǝ sǝkndǝ pathla Fara. ");
INSERT INTO bvw_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Paɗ kǝ nat Yahudawechǝ nofchǝ oi, nǝhǝɗkǝ hanɗǝkikecheng nandaɗi tǝ sǝrǝhta, naknda halǝ'inda kǝ ɗar i'mbuttǝ Bulus, paɗ naknda njirndi. ");
INSERT INTO bvw_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Bulus tǝ Barnabas shuwunkǝndǝ tǝ alchita, ndatwa: \"Kunang kamkǝsi kǝ tǝrkaafichǝ ɓassa pathla Fara kunisi. Sokkǝn a cheruni, cheɗkuniwa, kamusi kǝ mbǝssuni shisshingtǝ lekǝ pwareewa, nakǝnya nani tǝɓǝrtǝhi kǝ mbǝɗa punofcha. ");
INSERT INTO bvw_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kǝthlem Lǝmwanda tepa ɗǝftǝkanisi ndakǝnwa: \"Ɗifikuni kǝnuni ɗwachita punofcha, kǝthlǝm kǝ sokǝnwa tǝ mbǝɗengnuni nat kishita hǝrǝkta.\" ");
INSERT INTO bvw_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kǝ sǝktǝ punofchǝkǝn kichu, sǝkndǝ mbǝnfat kaǝn, tǝpaɗ mwanangndǝ shunda Fara, fichile ɓaka soktǝwa nanda mbǝs shisshingta. Le kǝpwaree fǝrkǝndǝkit. ");
INSERT INTO bvw_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Fankǝ shunda Lǝmwandǝhi chikatǝteni a sǝrǝt hachahaikǝn nat. ");
INSERT INTO bvw_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Yahudawecha ɗǝknda chikandǝ nischa, fa lechanda Fara, paɗ fichile la nat ficha fǝraa mwanda kanda, tǝ pǝktat nofcha hǝmǝtkǝn. Tǝrkaakǝndǝ fǝraa pwancha nda Bulus tǝ Barnabas, tǝpaɗ rǝkkǝndǝ kanda a sǝrǝt thlet hǝmtengnanda. ");
INSERT INTO bvw_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tǝpangndǝ tǝnnayiɗa sarǝchengnanda, kǝ sokka sheta ɗar inchǝngnanda, pǝɗaknda hǝmǝt Ikoniya. ");
INSERT INTO bvw_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Sokkǝn fafǝrkit, nǝhhǝɗkǝndǝ tǝ mbǝnfat oi, paɗ nǝhhǝɗkǝndǝɗi tǝ Shemeɗ Chiɗchiɗ. ");
INSERT INTO bvw_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","A Ikoniya, Bulus tǝ Barnabas yimkǝnda mbǝt humta Yahudawechǝhi, ɓaskǝndǝ pathla Farǝ tǝ alchitafa, tǝrkǝ nofchǝhi oi, Yahudawechǝ tǝ punofchǝ nat fǝrkǝndǝkit. ");
INSERT INTO bvw_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Yahudawechi fǝruchikkit, kurtangndǝ hur i'nda punofchǝhi, sǝɓangndǝ hurɗifitǝnaɗaɗi kǝ ɗar hwanmanchinandǝ fafǝrkit. ");
INSERT INTO bvw_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Bulus tǝ Barnabas tǝrkǝndǝ hanmunchǝ oi a mbǝnniyu. Kanda ɓassǝ lechitfuwa kǝɗar Lǝmwanda, lefǝrkǝ sheta tǝ shuwun kafat'en, tǝ mba sǝt ǝnnat pǝɗandǝ nofchǝfa, tǝ sakchikǝn tǝ mbǝɗengnanda. ");
INSERT INTO bvw_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Nofchi naka hǝmmǝtkǝn sakkǝndǝhi, funa mbǝɗa Yahudawecha, nak funa mbǝɗa fathlǝnchǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Punofchǝ tǝ Yahudawechǝkǝn, tǝ fahǝm mbanichengnanda, tahsangndǝhi wa nanda fǝrra pwancha kanda, paɗ kǝ mumuhhwangnda kandǝfa. ");
INSERT INTO bvw_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kǝ sǝkkǝndǝ i naka sǝta, rahkǝnda thlet hǝmǝt Listira tǝ Darbe, a hachahai lkoniya, tǝ tahhǝt hǝmchǝ nak nduknduk, ");
INSERT INTO bvw_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","a mbǝnniyu ɗǝknda mban tǝ ɓassǝ kweshcha shiwunkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","A Listira nifǝsi nak ɗas kǝ tǝraɗ, tamwa sǝt tor tǝ sarǝchǝ'enwa, nakǝn kichuyu kǝ ngǝttǝ'en tamwa witǝuwa. ");
INSERT INTO bvw_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nakna sǝk ɓassa Bulus, nak Bulussa kǝlandǝ ndongnga, kǝnatǝn fǝrkit'en kemsi kǝ kǝnangfichaɗi. ");
INSERT INTO bvw_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","I'naǝn ɓurathi kaǝn ndakǝnwa: \"Thla'u thlarnǝhi kit kǝ ɗar sarǝcheku. \"Thlaakǝn tǝrkaakǝn wita. ");
INSERT INTO bvw_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kǝ nat nofchi oiyu i sǝt Bulus i'nangndǝ ɓurechǝhi, ndakndǝ tǝ mi Likoniyachitwa: \"Ɓeɗ luwurchahai kǝ mbǝɗengnǝm nda nofcha!\" ");
INSERT INTO bvw_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ɗǝffangndǝ Barnabas wa Zeyus, Bulus paɗ wa Hermes, kǝthlem mǝlan naka kapat lǝ shuwunkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Pǝrissa Zeyus ɗǝhhayu, le nak kapat kǝtǝn ɗǝhhakǝnna ɗifiti hǝmta, ɓakǝn tǝ lecha tǝ fitǝ icha, kǝ mimbang hǝmǝtkǝn, yahhǝnsa fǝr poffǝn'en ɓweet tǝ nofcha. ");
INSERT INTO bvw_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kǝ sǝktǝ fathlǝnchikǝn nda Barnabas tǝ Bulus i naka sǝta, thlǝthlahhangndǝ njelechengnandaɗi, rahkǝnda hur nofchiyu, thla'angndǝ ɓurata ndatwa: ");
INSERT INTO bvw_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","\"Nofcha mǝ sǝk natuni sǝt iya?\" Kanang nofchǝ nda kunang! Tǝ ɓangngani kweshcha kusheng shunda kuni, kǝthlem kǝ tǝɓrunihi, hurwitǝ ɓǝɓiɗǝsǝchiya kǝ mbǝnda Fara, le nak tǝ shisshingta, le sǝk afshi tǝ kishita, hawurta tǝ ichi nat naka hurchikǝn. ");
INSERT INTO bvw_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Hursoh ti mbǝrkǝhi, malaɗǝ nofchǝ nat kǝ wii nda mbachi yahtǝnda. ");
INSERT INTO bvw_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Chikka tǝ kichu malutǝ fat'en nga ǝ'nat sheta sǝwowa. Kǝthlǝm shiɗtǝ ǝnndiichin, tǝ mba fǝrra ercha kuni afshi tǝ fekchǝ ndiichin, ngalaǝn kuni tǝ ɗǝsǝmta, paɗ mǝlla fǝrra mbǝnfata kuni. ");
INSERT INTO bvw_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Nat tǝ shuwunchiniyu ɓehndǝhi, kan'nda njat fǝr poffǝnti yahtǝ nofchiyu fǝrta, kǝthlǝm kandang. ");
INSERT INTO bvw_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ndǝkǝn ɓat Yahudawecha a Antakiya tǝ Ikoniya, lǝmkǝndǝ nofchi ngomkǝhiyu, mumuhangnda Bulus fa, paɗ kahangnda kishsha hur hǝmǝtkǝn, naǝn kandǝhiwa miri. ");
INSERT INTO bvw_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kǝ ɓat fa fǝrkitta taurandǝhi, thlaakǝn paɗ ngǝraǝn i'nna hurhura'a. A ɓingǝtkǝn mǝlan tǝ Barnabas pǝɗaknda Darbe. ");
INSERT INTO bvw_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ɗiffitǝ ɓassǝ kwescha kusheng shiwunkǝn kǝ hǝmmǝtkǝn, mbǝskǝndǝ fichile fǝrkǝkit oi, ngǝrangndǝ'ina Listira tǝ Ikoniya paɗ tǝ Antakiya, ");
INSERT INTO bvw_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Mbǝnniyu sakandǝnda nofchǝhar tǝndatwa, kǝ sokndǝ tǝ alchitafa hur fǝrkit. Chekangnda kandǝ tǝ ndatwa, tǝ sat ɓahtǝ kaǝn natma mbǝs yimta kuturichita Fara. ");
INSERT INTO bvw_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Bulus tǝ Barnabas taɗangndǝ pǝktecha kandǝsi, a hur chikayen kǝtǝn hwanda, tǝmbǝɗa hwanandǝ Fara tǝ kǝrkushimta, fǝrkǝndǝ kanda hara Lǝmwanda, le fǝrtǝndǝ kitchitta mbǝɗ'en. ");
INSERT INTO bvw_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ɓǝrkǝndǝhi tǝ hur Bisidiya ɓaknda hur Famfiliya. ");
INSERT INTO bvw_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Kǝ ɓastǝndǝ shiwunkǝn hur hǝmǝt Ferga, pǝɗaknda hai kǝ Ataliya. ");
INSERT INTO bvw_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Mbǝnniyu yimkǝnda hur kommbawal ngǝrrangndǝ'ina Antakiya, mbǝɗi soh hwanandǝ fichǝ kafata Fara kandǝsi, kǝthlǝm kǝ hǝrmǝn kandǝhar hur tori tuɓandǝndǝ nakǝnya. ");
INSERT INTO bvw_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Kǝ saatǝnnda Antakiya, ngomangndǝ fa tǝr mbandakish, kǝ mbǝt ǝrta, nbwa'angnda kandǝ nat i sǝt Farǝ tǝ mbǝɗengnanda, paɗ tǝ mbayi i'nandǝn mikǝtǝn fǝrkitchithi kǝ mbǝɗa punofcha. ");
INSERT INTO bvw_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Sokkǝnnda mbǝnniyu hammunchǝ oi tǝ fatǝrmbanda. ");
INSERT INTO bvw_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ɓak funǝ nofcha a Yahudiya tǝ Antakiya, naknda sakanda fa tǝrmbandǝ har, ndatwa: \"Manga tǝ heshangfichǝkuni nda i mbutǝ ɗǝssǝta Musa wa, nguni mbǝs hǝrǝktǝwa.\" ");
INSERT INTO bvw_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Nga hwan halǝ'indǝ yimka thlerǝ nda Bulus tǝ Barnabas tǝ nofchiyuwa, harkǝ fichǝ nda Bulus tǝ Barnabas tǝ funǝ fa tǝrmbanda kǝ ɗǝnda Urshelima kǝ ɓǝɗa fathlǝncha tǝ pǝktecha, kǝthlǝm kǝ tausangndǝ shuninihiyu. ");
INSERT INTO bvw_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nofchǝ thlǝntǝfichǝyu, pǝɗangndǝ tǝ hurhuri Finikiya tǝ Samariya, naknda mbu tǝɓǝrta punofchihi kǝ mbǝɗa Fara, fǝrang ndǝ ɓǝnfata fa tǝrmbandǝ kaǝn. ");
INSERT INTO bvw_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kǝ sa'atǝnda Urshelima, fa tǝrmbanda tǝ fathlǝncha, tǝ pǝktecha sangndǝ marapa kanda, kandang paɗ mbukǝndǝ uf i sǝt Farǝ tǝ mbǝɗengnanda. ");
INSERT INTO bvw_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Funǝ fafǝrkitsi naka hur mbanda Farisiyawecha, thla'akǝnda ndankndǝwa: \"Sokkǝn waat kǝ heshangfichǝ punofcha, paɗ kǝ ɗǝffichǝ kanda kǝ kǝsndǝ kussa Musa har.\" ");
INSERT INTO bvw_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Fathlǝncha tǝ pǝktecha fa tǝrmbanda ngomkǝndǝhi, kǝthlem kǝ tausangndǝ shuninihiyu. ");
INSERT INTO bvw_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ɗiffitǝ shuni shiwuntǝnda ɗarkǝn kaǝn, thlaakǝ Bitrus kit ndangna kandǝwa: \"Hwanmancha shinuniwa thlata tǝrkakǝn, teɗ Farǝ nja hurnuni ndatwa, tǝmbǝɗengnǝ nat punofcha ɓǝs kusheng shunda kǝ fǝrndǝkitsi. ");
INSERT INTO bvw_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Fara le sǝnkǝ hanndǝkiketa cheɗkǝwa a thliiɗtǝ kanda tǝ mba fǝrra Chiɗchiɗ tǝ Shemeɗa kanda, nda i fǝrra ndǝnakani. ");
INSERT INTO bvw_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Paɗ cheɗutǝ sǝmsǝmchita thlerǝnanda tǝ kaniwa, kǝ sapaɗǝn hanɗǝkikechengnandaɗi tǝɓǝɗa fǝrkit. ");
INSERT INTO bvw_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kǝthlem ndǝkǝn, mǝsǝk natuni kikeɗandǝ Fara, tǝmbǝɗa ɗǝffa rǝfta kimshechi'ena ɓur, le nguchit shinchinǝm tǝkǝmna mbǝlla tǝrta? ");
INSERT INTO bvw_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Paɗ firǝm kitwa, nakma mbǝs hǝrǝktǝ tǝ mbǝɗa kafata Lǝmwandǝ Yǝso, nda i mbǝstǝnda.\" ");
INSERT INTO bvw_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Uf nofchi ngomkǝhi ngaskǝndǝ ɓa, naknda kathlǝmmata nda Barnabas tǝ Bulus, nak nda mbu alchiɗi fǝrandǝ Fara kanda, kǝ sǝndǝ ǝnat pǝɗandǝ nofchǝ fa, tǝ ǝnat sheka'inda a hur punofcha. ");
INSERT INTO bvw_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ɗiffitǝ mweshandǝ shundǝngnanda, ngǝrkǝ Yakubu si tǝ ndakǝnwa: \"Hwanmancha sǝkam nji. ");
INSERT INTO bvw_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Mbwa'a Siman Bitrussa kǝm laɗi lat Fara ɓata mbǝɗa punofcha, paɗ hertǝ funǝharra hurnanda kǝthlǝm thlǝmkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Leya ɓakna soktǝ keeke tǝ shunda tapǝnecha, nda i yarandǝ fichihi tǝndatwa, ");
INSERT INTO bvw_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","'Ɗiffitǝ ndǝkǝn ni ngǝr ɓata tǝpaɗ ni ngǝr tinandǝ hura'a Dauda le hǝmkǝhi. Kǝ ngǝri tinandǝ thlarǝ'enna kwarkǝn kǝnan kit. ");
INSERT INTO bvw_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Tahhǝt nofchi nat katnji, njang Lǝmwanda, nat tǝ punofchǝ la atfichǝ tǝ thlimna, ndat Lǝmwanda le sǝk i'chiya. ");
INSERT INTO bvw_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Sǝntǝ fichǝ kǝ soh. ");
INSERT INTO bvw_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","\"Kǝthlǝm ɗǝkǝn a kǝlandengna, kamusǝ kǝ thla'am hur'inda punofchi naka tǝɓǝrtǝhi kǝ ɓǝɗa Farǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Makǝ yarangma kandǝsi ndatwa, kǝ malangndǝ ɗǝsǝmta ɗǝhacha. Mǝsǝmindǝ chaɗnguwa, mǝsindǝ fǝllawichitwa, paɗ mǝ sǝmindǝ i ɓekrandǝfichǝ mɓurat'enwa. ");
INSERT INTO bvw_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kǝthlǝm hur soh, a thlet hǝmchǝ somsomǝn fa ɓassǝsi tǝ ɗelwercha Musa, paɗ la changngandǝ fichǝ kanda chika yen farǝ yipta Yahudawecha, a kǝtǝn hwacha ɓeshfichǝ kussa Musa, a hur chikayen hǝmta i hurechǝ terchin, tǝpaɗ la changangficha isǝka farǝ yipta Yahudawecha, a kǝtǝn humchengnanda. ");
INSERT INTO bvw_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Fathlenchǝkǝn tǝ pǝktecha, nat tǝ fa tǝrmbanda kǝllangndǝwa ndiichinsi, kǝ taɗɗǝ nofchihar a hurnanda, kǝ thlǝnndǝ kanda Antakiya tǝ Bulus tǝ Barnabas, fichile taɗtǝnda nda Sila tǝ Yahuda lela atfichǝndǝwa Barsaba. Kandangti naka fambanicha fafǝrkit. ");
INSERT INTO bvw_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Fǝrangndǝ yarat ɗelwera kanda, kǝ ɗangnda kanda le naka ndatwa: \"Kanang hwammanchǝnuni, Fathlǝncha tǝ fambanicha, kǝmbǝɗa hwammancha fichile naka punofcha, hur Antakiya tǝ Suriya tǝ Kilikiya, Ndat'ǝn kaǝn. ");
INSERT INTO bvw_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","A shikani wa nofchisi thlaaka hurnani, mbǝɗya thla'andǝ hur inchengnuni tǝ shuwuncha. Chika sokkǝn thlǝnwani kandǝwa, ");
INSERT INTO bvw_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Hwimanihi yaraɗanihi ndiɗchinsi kǝ taɗani nofchihara hurnani, kǝ thlǝnani kanda mbǝɗengnuni, tǝ kaa shikechǝnǝm Barnabas tǝ Bulus. ");
INSERT INTO bvw_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Nofchiya tepa fǝrndǝ shisshingchengnanda, kǝthlem thlǝm Lǝmwandengnǝm Yǝso Kǝrǝsti. ");
INSERT INTO bvw_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kǝthlem ndǝkǝn thlinnani Yahuda tǝ Silas, kandang tǝ inchengnanda nanda mbwa'a nda kuni tǝ miya, witǝ ǝn'ǝrta tǝ i natani yarata. ");
INSERT INTO bvw_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Keekesi mbǝɗa Shemeɗ Chiɗchiɗ, tǝ kanang neɗɗaniwa ndiɗchinsi, mǝ ɗǝfaɗani kapat lǝkta kuni'inwa kǝ sherangka ichi sokkǝ waatwa: ");
INSERT INTO bvw_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kǝ lenganguni ichihi thlithlandǝficha ɗǝhacha, tǝ i'sǝka thluwa ɗǝhǝrǝmtǝ mǝrkǝ nga fwarsafǝwa, tǝ i'sǝka thluwa ɗǝhǝrǝmi ɓekrandǝfichǝ ɓurat'en. Tǝpaɗ mǝ siɗuni fǝllawichitwa. Ma hirmuni ichini haryu, nuni sǝt ichǝ ndiichin. Kǝ sokuni ngwalngwal.\" ");
INSERT INTO bvw_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kǝ thlǝntǝfichǝkanda, pǝɗak ndǝ hai kǝ Antakiya, ngommangndǝ fa tǝrmbanda, fǝrangndǝ yarat ɗelwer tǝkǝna kanda. ");
INSERT INTO bvw_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Kǝ changngandǝnda sǝkndǝ mbǝnfata, kǝthlǝm alchiɗi chekandǝnda kanda. ");
INSERT INTO bvw_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yahuda tǝ Silas kandangti naka tapǝnechǝ paɗ, shunangndǝ kandǝ ka'ǝn, paɗ chekangndǝ alchita hwammancha, tǝ shiwunchǝ oi. ");
INSERT INTO bvw_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ɗiffitǝ hangmuncha mbǝnniyu, malkǝndǝ kandǝhi ngwalngwal, ngǝrandǝ'ina mbǝɗa fǝchile thlǝnkǝ kanda. ");
INSERT INTO bvw_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Kǝllang Silaswa keekesi, mǝllan kǝ sokka mbǝnniyu. ");
INSERT INTO bvw_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Bulus tǝ Barnabas tǝngkǝnda hur Antakiya, naknda sakandaɗi tǝ ɓassǝ shunda Lǝmwanda, tǝ nofchǝterchin paɗ. ");
INSERT INTO bvw_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ɗiffitǝ hanmuncha, Bulus ndangna Barnabas wa: \"ngǝramǝn'in ɗǝmma kǝlandǝ hwanmancha hur chikayen hǝmta mbichi ɓastǝm shunda Lǝmwanda, tǝpaɗ kǝnǝm ndu nakndǝ kǝni.\" ");
INSERT INTO bvw_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas yahkǝnsi kǝ pǝdandǝ ɓweet tǝ Yohanna, lǝ atfichǝwa Markus. ");
INSERT INTO bvw_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Bulus yaraǝnhi kamusuwa kǝ pǝɗandǝ tǝle saktǝndǝhi a hur Famfiliya, tǝpaɗ chertǝn ɗǝta mbet tortǝkandǝyuwa. ");
INSERT INTO bvw_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mbenniyu thla'akǝ ɓǝɓi somsommǝnchitta hanɗǝkiketa thlerǝnanda, kǝthlǝm ndǝkǝn sakkǝndǝhi tǝ ndani, Barnabas tǝrkǝn Markus, yimkǝnda kombawal pǝɗaknda Sayifurus. ");
INSERT INTO bvw_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Bulus taɗkǝn Silas, ɗiffitǝ fǝri fǝrtǝ hwanmanchǝ kanda, ƙǝ kafata Lǝmwanda pǝɗanda. ");
INSERT INTO bvw_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pǝɗak Bulus tǝhur hachahai Suriya tǝ Kilikiya, nakna cheka alchita kanda kǝtǝn hwachikǝn. ");
INSERT INTO bvw_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bulus ɓakǝn paɗ kǝ Darbe tǝ Listira. Lǝ fǝrkitsa mbǝnniyu, thlemkǝnwa Timoti, hweya nuhnifǝ lǝ Yahudawata shinkǝn lǝ Helenawata. ");
INSERT INTO bvw_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Fafǝrkitti naka Listira tǝ Ikoniya lanaknda hamndi. ");
INSERT INTO bvw_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Yahkǝ Bulus kǝ ɗǝf Timoti ndi, tǝrkǝnndi tǝ paɗ hesha'ǝn, kǝthlem Yahudawechi naka mbechiniyu nat nda shinndǝwa shinkǝn lǝ Helenawata. ");
INSERT INTO bvw_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Naknda ɗar pǝɗata wiikǝndǝ hǝmtǝ hǝmta, naknda mbwa'anda nofcha ichi yarandǝ fathlenchikǝnhi, tǝ pǝktecha fichile naka Urshelima, ndangnda fafǝrkitwa kǝ kuwurndǝ i yarandǝndǝhi. ");
INSERT INTO bvw_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Tǝkichu nofchǝ fatǝrmbanda, chekkǝndǝ tǝ alchita hur fǝrkit, chikayen para kanda tera. ");
INSERT INTO bvw_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Bulus tǝ nofchi'en wiyangndǝ sǝrǝt hachahai Firijiya tǝ Galatiya, kǝthlem Shemeɗ Chiɗchiɗ njanda kanda, mǝ ɓasindǝ pathla Fara hur Asiya wa. ");
INSERT INTO bvw_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kǝ ɓatndǝ kǝ sǝrǝt hachahai Misiya, yahkǝndǝ ɗǝt tǝhur hachahai Bitiniya, chikakichu paɗ Shemeɗa Yǝso ngǝmawa kandǝsǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Mbǝrkǝndǝhi tǝ kǝllari Misiya, pǝɗaknda hai kǝ Toruwas. ");
INSERT INTO bvw_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","A fiɗikkǝn ɓak ǝna ɓǝs Bulus ndaa hur sǝnata, nakǝn nifǝ lǝ Makidoniyata, kit nakna hwananda tǝ ndatwa: \"Aɓu Makidoniya kǝ kǝsangnakanisi.\" ");
INSERT INTO bvw_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kǝ nat Bulus i'ni nda sǝnnatǝyu, chatkichuyu kakkani mbanda Makidoniya, mweshangngani tǝndatwa Farǝ nakka atkǝm, kǝ ɓassaam kweshcha shunda kandǝsi. ");
INSERT INTO bvw_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Pǝɗakani hur kombawal, thlata Toruwas kǝ Samotiras, wendambǝt paɗ pǝɗakani Niyafolis. ");
INSERT INTO bvw_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Thlata mbǝnniyu paɗ ɗǝkani Filibi, le naka kapat hǝmta Makidoniya, nat Romawecha sǝt kutǝrichitkǝn. Shiɗani hanmunchǝ ɗǝmek a hur hǝmǝɗiniyu: ");
INSERT INTO bvw_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Farǝ yipta Yahudawecha, chekani kish kǝ mimbang hǝmǝtkǝn, ɗǝkani mi'ama, mbǝɗi natani yarǝwa na mbita natsi i hwanandǝ Fara, mbǝnniyu sokkanihi shunangngani nishchi ngomkǝhi. ");
INSERT INTO bvw_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ərta hur nishchi naka sǝkkani, thlemkǝnwa Lidiya, ɓakna hǝmǝt Tayatira, lǝ hiiyandi fi njelechaɗi, lǝ mwanandǝ Farǝ naken. I'nang Lǝmwandǝ hanɗǝkiketǝ'enhi, ɗǝfkǝn hur'i'nda i nat Bulussa mbuta. ");
INSERT INTO bvw_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kǝ sandǝfichǝ baptisma tǝ fichile naka huraa'en, hwanang Lidiya kani, tǝndatwa: \"Ɓaknasoktǝwa ngǝmaɗuniwa njang lǝ fǝrkit kǝmbǝnda Lǝmwanda, ɓam tama hure'engna kǝ sokkunihi.\" Tǝkichu kahandǝn hur i'ɗǝngnani. ");
INSERT INTO bvw_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Farǝle nakani pǝɗata mbǝt hwanda, kǝmkani tǝ mafat nuhhweya, lenat shemeɗ luwurchǝsa fi'en, la kulakǝn, tǝpaɗ la mbǝskǝn hanɗǝɓǝlta, kǝ fǝrangka nofchi naka thlǝmatkǝn, tǝ ɓǝɗa kulat'en. ");
INSERT INTO bvw_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nakna kuwur kani tǝ Bulus mǝlla hwata, ndatwa: \"Nofchiya mafecha Fara le sherkǝ tǝ mwanda, kanda ɓassa mba hǝrǝkta kunisi.\" ");
INSERT INTO bvw_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ɗǝknamban tǝ sǝt i'niyu i mundǝ tǝrchin. Tǝkichu sǝɓkǝ hanndǝkiketa Bulussa ɗǝ kaǝn, tǝɓǝrkǝnhi ndangna shemeɗiwa: \"Nja ɗǝfsǝ waat hur thlem Yǝso Kǝristi chukishsha fat'en.\" Chatkichuyu cheknakish. ");
INSERT INTO bvw_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kǝnat fa nuhwani natna hure'engnandǝyu, resh mba mbǝs ǝ'nengnandaɗi, kǝsangndǝ Bulus tǝ Sila, tǝpaɗ kahkǝndǝ kanda milumo, ndǝkndǝ tǝ kanda mbanitǝ fichile nak tǝ kuturichit hachahaikǝna har. ");
INSERT INTO bvw_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Kǝ ɗǝtndǝ tǝ kanda mbanitǝ fa sakmicha, ndakndǝwa: \"Nofchiya Yahudawecha, naknda kanda shekɗa i'ndǝ hǝmtengnani. ");
INSERT INTO bvw_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Kanda sakandǝ ɗǝssǝchaɗi kamuchǝksi, le kamuchiksi kanang Romawecha kǝ thlani.\" ");
INSERT INTO bvw_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ɓak terǝ nofcha humangndǝ miya kǝ ɗar walǝkanda, fa sak michikǝn thlethlahangndǝ njelecha nda Bulussa ɗi tǝ Sila, ndankndǝwa kǝ tǝpangficha kandǝ kaǝn. ");
INSERT INTO bvw_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ɗiffitǝ tǝpanda kandǝ kaǝn, somkǝndǝ kanda pursuna, ndangficha lǝ pu pursunatǝkǝn harwa, kǝ kǝlansakandǝ kaǝn, mǝninda hǝrǝkta. ");
INSERT INTO bvw_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kǝ thlǝtǝn shuwunkǝn, ɗǝkǝn tǝ kanda kakǝ hur kǝtǝn pursunatǝkǝn kǝnaǝn sarǝchengnanda thleri peh'afta. ");
INSERT INTO bvw_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","A ɗar fiɗikta, Bulus tǝ Sila kanda hwanda, tǝ in i'mish mwanandǝ Fara, tahǝt pursunachikǝn kanda kathlǝmmata kanda. ");
INSERT INTO bvw_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Su tollǝwa, sǝkkǝfichǝ kapat hǝhǝrta kisshitǝfa, njun kǝtǝn pursuna tǝkǝn hǝhǝrkǝnfa. chatkichuyu mikǝtǝn pursuna tǝkǝn inkǝndǝhi nat, tǝpaɗ uf challaluchi kǝnandǝfichǝ pursunachikǝnsi hǝhhatkǝndahaiya. ");
INSERT INTO bvw_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kǝ thlaatǝ lǝpu pursuna tǝkǝnhar, anakǝn in mikǝtǝnchǝkǝnhi nat. Yarkǝnwa reh pursunachikǝn, kǝtkǝn thlohtǝ'en, tǝna ɓǝllandǝfat'en. ");
INSERT INTO bvw_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Shuwunkǝ Bulus tǝ kapat ɓurat ndatwa: \"Mǝsanǝ mboro i'ndekufuwa, kana mbǝɗya nattani.\" ");
INSERT INTO bvw_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Lǝpu pursunatǝkǝnhar ndakǝnwa, kǝɓa fichǝ tǝ tikkesha, tǝpaɗ weshkǝna rahta hurkǝn, mǝla saktatfa tǝ lechita ɗǝkna hǝmta mbanitǝ Bulus tǝ Sila. ");
INSERT INTO bvw_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Mbǝnniyu chaǝn kanda kish ndangnakandǝwa: \"Famwanda, mǝnati sǝt kǝthlem kǝ mbǝsi hǝrǝkta?\" ");
INSERT INTO bvw_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ndangndǝwa: \"Fǝrukit kǝ ɓǝnda Lemwandǝ Yǝso, nu mbǝs hǝrǝkta tǝ chikawuna hur hure'eku.\" ");
INSERT INTO bvw_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Shunangndǝ pathla Lemwanda, nat tǝ fichile naka hur huraa'en. ");
INSERT INTO bvw_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Chika nakna fiɗiktiyu, lǝpu pursunatǝkǝnhar kileɗsa kanda tǝpaɗ sapaɗǝ ndindichengnandaɗi. Chatkichuyu mǝlan tǝ fichile naka hur hura'en sangfichǝ baptisma kanda. ");
INSERT INTO bvw_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ɓakǝn tǝ kanda hur huraa'en, tǝpaɗ saǝn ɗǝsǝmta kanda mban, mǝlan tǝ fichile naka hur huraa'en, naknda sǝt mbenfata kǝthlem firndǝkit kǝmbǝnda Fara. ");
INSERT INTO bvw_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Wenda mbǝta fa sak michikǝn thlǝnkǝndǝ hansǝsalchǝ ndatwa: \"Kǝ kalndǝ nofchihiyu!\" ");
INSERT INTO bvw_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Lǝpu pursunatǝkǝnhar ndangna Bulus wa: \"Ndak fa sak michikǝnwa, kǝ kalfichǝ kunihi nakǝnya, chamakis pǝɗam ngwalngwal.\" ");
INSERT INTO bvw_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ngǝrkǝ Bulussǝwa: \"Tǝpangnda kani a ɓaniti nofchǝ talyar, sahhawundǝ mikaniwa, a nakǝn kanang Romawecha, paɗ pǝkkǝndǝkani pursuna. Nakǝnnya yahkǝndǝ kalǝkanihi ɓuɓweta? Auwa! Kǝ ɓanda harandǝ kanikish tǝ i'ndengnanda.\" ");
INSERT INTO bvw_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Kǝ ɗǝt hansǝsalchiyu mbu i'niyu, nak fa samichikǝnna lechita, ɓaknda sǝndǝwa Bulus tǝ Sila Romawecha. ");
INSERT INTO bvw_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ɓaknda tǝrandakandǝhi. Kanda harandǝ kandakish, tǝpaɗ hwanangndǝkanda kǝmalndǝ hǝmǝtkǝnhi. ");
INSERT INTO bvw_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ɗiffitǝ cheta nda Bulus tǝ Sila kishsha pursuna, ngǝrangndǝ'ina hura'a Lidiya. Humkǝndǝhi mbǝnniyu tǝ fichile fǝrkǝkit mbwa'angndǝ shuwuncha kanda, paɗ ɓaknda soktǝ tǝ alchit hanɗǝkiketa. Pǝɗaknda. ");
INSERT INTO bvw_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Kuwurkǝndǝ tǝ Amfibolis tǝ Afolloniya, saakǝndǝ Tassalonika kǝ mbǝɗi nat kǝtǝn humta Yahudawecha. ");
INSERT INTO bvw_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Bulus yimkǝna thlǝmmatnanda nda i sǝntǝnhi, mbǝraɗ farǝ yiptǝhi mǝkkan mǝlla halǝ'i'ndǝ tǝ kanda a hur ɗelwercha Fara. ");
INSERT INTO bvw_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Nakna chekanda kanda, paɗ kǝna sǝnanda kandǝsi tǝ ndatwa, keekesi kǝ saa Kǝrǝsti pwene, paɗ kǝ thlaaka hur mǝmmatcha, ngǝrkǝn ndatwa. Yǝso ti nati mbwa'andakunniya, mǝllan naka Kǝrǝsti. ");
INSERT INTO bvw_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Paɗ funǝ Yahudawecha, kahhafichi hur'inchengnanda, hummangndǝ i'ndǝ tǝ Bulus tǝ Sila, kichupaɗ sǝt Helinawechǝ oi fa lechanda Fara, tǝ kichupaɗ sǝt pǝktat nischǝ oi fa mbutǝ kǝ sǝkficha. ");
INSERT INTO bvw_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Nak Yahudawechikǝna sǝrǝhta, ngommang ndǝ hwanchǝ rǝnnecha a lumo. Kǝ ngomtǝnnda, tǝrkaakǝndǝ thla'andǝ hur'i'nda a hur hǝmmǝtkǝn. Yimkǝnnda hurhura'a Yason nak nda kat Bulus tǝ Sila kǝthlǝm kǝ ɓandǝ tǝ kanda mbanitǝ nofcha. ");
INSERT INTO bvw_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Kǝ ɓǝssawuchitndǝ kanda, kahkǝndǝ Yason tǝ funǝ hwanmancha, ɗǝkndǝ tǝ kanda mbanitǝ fa sak miiya, nak nda hwatta kanda ndatwa: \"Nofchiya naka thlahur'i'nda chika ayi hurkisshita, ɓeɗnda mbǝɗya paɗ. ");
INSERT INTO bvw_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yason thliɗtǝ kanda, ufnda kǝllundǝssa kussa Kaisarwa, ndatwa yunǝ kutursi, thlǝmkǝnwa Yǝso.\" ");
INSERT INTO bvw_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Thlaakǝ hur'i'nda Nofcha tǝ fa sakmicha kǝ sǝktǝndǝ ichiniyu. ");
INSERT INTO bvw_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Kǝ thlǝɗ ndǝ hanɗǝɓǝl punofchǝhar a harra Yason tǝ tahǝt nofcha kalkǝndǝ kandǝhi kǝ pǝɗanda. ");
INSERT INTO bvw_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Chat kǝ sǝt fiɗikta, ɗǝfkǝ hwanmancha ndǝ Bulus tǝ Sila kǝ pǝɗanda Biriya. Kǝ saatǝnda mbǝnniyu yimkǝnnda kǝtǝn humta Yahudawechihi. ");
INSERT INTO bvw_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Yahudawechi naka ɓǝɗya pǝɗanda fichilehi naka Tasalonika tǝ hur'i'nda, kǝthlǝm thliɗndǝ shuwunkǝn tǝ harchǝ chap chap, lanaknda tausandǝ shunda Farǝ wembǝta kǝ nandǝ ndu i mbutǝ Bulusyu kit. ");
INSERT INTO bvw_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Oiya hur Yahudawechi fǝrkǝkit, Paɗ tǝ funǝ nishchǝ Helinawecha fichile naktǝ mwanda tǝ hishchǝ paɗ. ");
INSERT INTO bvw_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kǝ sǝktǝ Yahudawechi naka Tassalonikayu, tǝ ndatwa Bulussa ɓassǝ pathla Fara a Biritiya, ɗǝknda nata chikandǝ kanda kǝnnda thla'andǝ hur'i'nda nofcha. ");
INSERT INTO bvw_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Chatkichuyu ɗǝfkǝ fafǝrkit Bulus kǝ pǝɗaka mihawurta, nda Sila tǝ Timoti thlarkǝndǝhi mbǝnniyu. ");
INSERT INTO bvw_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Fichile ɗǝfkǝ Bulusyu saakǝndǝ tǝndi kǝ Atina. Naknda ngǝrandǝ'in thlǝkndǝ thlǝnda ɓǝɗa Bulus ndatwa, yehsi nda Sila tǝ Timoti kǝ ɗǝnda mbǝsndǝ leɗleɗ, pǝɗaknda. ");
INSERT INTO bvw_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Kǝ nat Bulussa pu kanda a Atina, sǝɓkǝ hanɗǝkiketǝ'enaɗi kaǝn, kǝ natǝn hǝmǝtkǝn nihiɗaɗi tǝ ɗǝhhacha. ");
INSERT INTO bvw_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","I sǝka para la nakna halǝ'i'nda kǝtǝn humta Yahudawechǝhi kandang tǝ funǝ Helinawecha fa lechanda Fara. Chika ɓǝɗi nat lumo fichile la ɓǝlaakǝ nata ɓǝnniyu. ");
INSERT INTO bvw_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Funǝsǝ paɗ Abikuriyawecha tǝ Sitokiyawecha fa mbǝr'ǝna halkǝndǝ'i'ndǝ tǝ ndi. Funengnanda ndakndǝwa: \"Mǝ yahtǝ lǝ ɗaakiya mbuta?\" Ndakfunǝwa: \"Nda lǝɓassǝ ɗǝhhacha nofcha.\" \"Mbukǝndǝ kichu kǝthlǝm Bulussa ɓassǝ Yǝso tǝ thlata mǝmatcha. ");
INSERT INTO bvw_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Tǝrkǝndǝndi ɗǝkndǝ tǝnda ɗar Arasa, ndakndǝwa: \"Ndu nu mbǝlla mbwa'andakani witǝ yuwa sakayiɗi natu sakandaɗiya? ");
INSERT INTO bvw_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kǝthlǝm ɓanǝ yuwa icha thlǝmechengnani, yahkanisi kǝ sǝnnani i naka sakchikǝn.\" ");
INSERT INTO bvw_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Nakǝnya nat Atinawecha tǝ romchi naka mbǝɗengnanda, ǝnsǝ lǝ sǝnndǝ kǝ sherangka mbu yuwa shuwuncha tǝ sǝk yuwa icha. ");
INSERT INTO bvw_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Thlaakǝ Bulus thlarkǝnhi hurɗifitǝ Arasacha, ndakǝnwa: \"Kunang nofchi Atinacha, a mbǝssaɗi wa kunang fa tǝr mbandǝ chika tǝ teni. ");
INSERT INTO bvw_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kǝthlǝm manja mbǝrtǝhi tǝ hǝmǝtkǝn, lanaki ichi natuni mwananda, a naki mbǝt fǝr pofǝn tǝ yarata ɗarkǝn ndatwa: \"Kǝthlǝm Fari sǝnuchit ficha. Lenatuni mwanandǝ sǝnuchituniyu, mǝllan nati mbwa'anda kuni. ");
INSERT INTO bvw_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Fara letinkǝ kisshita tǝ ichinaka hurkǝn uf, mǝllan naka Lǝmwanda afshi tǝ kisshita, shokwa kǝtǝn kapat hura'a Farǝ letintǝ nifǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Kichu paɗ ɓahwa kat nifǝ kǝ kǝssaansǝ tǝ harchǝ'enwa, ɓahwa yah ǝnwa, kǝthlǝm mǝllan tǝ i'ndi'en la fǝrang shisshingta nifa, tǝ yipta tǝ ichi natna yahtǝ nat. ");
INSERT INTO bvw_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Mǝllan paɗ tinkǝ yakat terǝ nofcha tǝ mbǝɗa nifǝ ǝrta, kǝthlǝm kǝ soknda hur kisshitǝ nat, tahsaǝn sǝrǝt naɗengnandǝhi, tǝ sǝrǝt hǝmchengnanda. ");
INSERT INTO bvw_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Sǝk Farǝ kichuyu kǝthlǝm kǝ kandǝndi, mbahya nanda taptǝ kǝ mbǝssangnda, chika sokkǝn nga nakǝn langngǝ tǝkǝmwa. ");
INSERT INTO bvw_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kǝthlǝm: \"Tǝ mbǝɗ'en natǝmhi, lanatma yipta, paɗ tǝ mbǝɗ'en mwaatǝmhi. Nda i mbutǝ funengnuni fa at imshi ndatwa: \"Kitchitkǝn, kǝmnang ma witǝkǝn nakǝm.' ");
INSERT INTO bvw_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","\"Nakǝn kǝmnang witǝ Fara, kamusi kǝ yarǝm tǝ ndatwa Farǝ nakǝn nda zinariya ndu azurfa ndu ngwiya, le tahhǝstǝ nifǝ tǝ ɗathlǝ'enwa. ");
INSERT INTO bvw_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","A hur soh tǝrra Farǝ chumwandǝ'enaɗi a ɗar tor ɓomchita. Nakǝnya mbwa'aɗa nofchǝ nat, chika tǝ tee'ǝn kǝtǝrndǝhi. ");
INSERT INTO bvw_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kǝthlǝm tahsaɗǝ farihi natna ɓata sa kiita kisshitǝsi, i kitchitkǝn tǝ mbǝɗa nofchi tahsaɗǝnhi, kǝthlǝm ndǝkǝn firtǝ kitchitkǝn kǝ mbǝɗa chika wunni, tǝ thla'a nda hur mǝmatcha.\" ");
INSERT INTO bvw_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kǝ sǝktǝndǝ shuwun thlata mǝmatcha, funengnanda njirkǝndǝndi, ndak funǝ paɗwa: \"Yahkani kǝ ngǝrani sǝk i natu mbuta kǝ ɗar shuniya paɗ.\" ");
INSERT INTO bvw_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","A mbǝnniyu saktǝ Bulushi tǝ kanda ɓǝɗakǝn. ");
INSERT INTO bvw_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Funengnanda ngǝrang ndǝ'ina mbǝɗa Bulus, fǝrkǝndǝ kit. A hurnanda Diyonisiyus, lǝ sakmicha, tǝ nuhnifa le nat thlǝmkǝnwa Damaris, tǝ funǝ paɗ fichile naka thlǝmatnanda. ");
INSERT INTO bvw_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ɗiffitǝ ndǝkǝn, malkǝ Bulus Atinahi pǝɗakna Korinti. ");
INSERT INTO bvw_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Kǝmkǝndǝ tǝ lǝ Yahudawata mbǝnniyu nat thlǝmkǝnwa Akila lǝ Fontusta. Le ɓak nakǝnya a Italiya, kandang tǝ nuhkǝn le nat thlǝmkǝnwa Biriskila, kǝthlǝm Kalaudiyus firtǝ kus ndatwa nat Yahudawecha kǝ malndǝ Romahi. Ɗǝk Bulussa mbǝskanda. ");
INSERT INTO bvw_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Nakǝn tor harengnandǝ ǝrtǝ tǝ nofchiyu, tor tahhasǝ tenti, sokkǝnna thlǝmatnanda naknda sǝt torra. ");
INSERT INTO bvw_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","I'sǝka farǝ yipta Yahudawecha, la yimkǝna kǝtǝn humta Yahudawecha, a la nangna kahandǝ hur'inda Yahudawechǝ tǝ punofcha. ");
INSERT INTO bvw_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Kǝ ɓaɗnda Sila tǝ Timoti a Makidoniya, ɓaknda mbǝs Bulus firtǝ fat'enna ɓassa, mǝlla cheɗanda Yahudawecha tǝ kitwa, Yǝso naka Kǝrǝsti. ");
INSERT INTO bvw_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Halangndǝ'i'nda nak nda i'erandǝfa, tǝppaǝn njelechi'ennaɗi ndangna kandǝwa: \"Hekke tǝ fwarchengnuni tǝ inchengnuni! njang cheɗikish. Thlata nakǝnya kǝ mban ɗǝki mbǝɗa punofcha.\" ");
INSERT INTO bvw_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Malkǝn mbǝnnihiyu pǝɗakna hura'a nifǝ lǝ atfichiwa Titiyus Yustus, lǝmwanandǝ Fara, huraa'en nduk tǝ mikǝtǝn humta Yahudawecha. ");
INSERT INTO bvw_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kirisbus, kappat nifa mbǝt humta Yahudawecha, fǝrkǝn kit kǝmbǝɗa Fara, kandang tǝ nofchi huraa'ennat. Korintiyawechi oi sǝkkǝ ɓassa Bulus, fǝrkǝndǝkit sanfichǝ baptisma kanda. ");
INSERT INTO bvw_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Farǝle fiɗikta, chenɗang Lǝmwanda Bulus hur'ǝn nda sǝnnatawa: \"Mǝlechinuwa, ɗumban tǝ ɓasseku paɗ mǝngasinǝ ɓaawa, ");
INSERT INTO bvw_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Kǝthlǝm njangtǝsa, paɗ nifǝsǝ na walǝsa kǝ sukǝn'ǝnwa, kǝthlǝm nofchengnǝsi oi hur hǝmmǝɗiya.\" ");
INSERT INTO bvw_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Sokkǝ Bulushi mbǝnniyu, hurat'ǝrta tǝ ndǝraa tehethl, mǝlla sakandǝ pathla Fara ɗi a hurnanda. ");
INSERT INTO bvw_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","A fari nat Galiyo sǝt kuturichita furǝt Akaya, thla'ang Yahudawechǝ Bulussafa, ɓakndǝtǝnda mbanitǝ fasakmiya. ");
INSERT INTO bvw_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ndakndǝwa: \"Nifiya mǝlla kahhandǝ hur'i'nda nofcha, kǝ mwanangndǝ Fari nguchik keeke tǝ kus.\" ");
INSERT INTO bvw_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Kǝ nat Bulus nduk kǝ shunǝn, ndǝkǝn ndandǝ Galiyo Yahudawechǝkǝnwa: \"Makǝthlǝm sǝt'ǝn nduɗuwa ndu kapat ɓǝɓi'ǝna, mani kathlǝmmatakuni. ");
INSERT INTO bvw_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nakǝn pathlǝ sahmi kǝ ɗar shuwuncha, tǝ thlǝmcha tǝ paɗ kus engnuni, kǝllamǝn kunang tǝ inchengnuni. Njang ngi mbǝlla thlandǝ shundǝhi kǝ ɗar witǝ ichiyawa.\" ");
INSERT INTO bvw_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Rǝkkǝn kanda kǝtǝn sakmikǝn. ");
INSERT INTO bvw_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Nat nda kǝsangndǝ Sostanus lǝhǝm mbanita a mbǝt humta Yahudawechǝhi, tǝppangnda a mbanitǝ fa sakmikǝn. Kǝmmawuchik'ǝn Galiyo kǝ ɗar i'sǝtnda ");
INSERT INTO bvw_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ɗiffitǝ ndǝkǝn sokkǝ Bulushi hanmunchǝ oi tǝfafǝrkit a mbǝnniyu, ndangna kandǝwa nan malǝkandǝhi, a yimkǝnna kommbawal, ɓǝɗakna Suriya kandang tǝ Biriskila tǝ Akila. Kǝ saatǝnda Kankiriya, hǝsaǝn hwasǝ indǝ'enaɗi, kǝthlǝm kǝ nǝhɗaǝn shunihi mbuɗtǝn. ");
INSERT INTO bvw_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Saakǝnda Afisa, malkǝn Biriskila tǝ Akila mbǝnniyu, mǝllan tǝ i'ndǝ'en yimkǝnna kǝtǝn humta Yahudawechihi, nakna tausandǝ shuwunkǝn tǝ Yahudawechikǝn. ");
INSERT INTO bvw_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Hwanangndǝwa kǝ sokka mbǝnniyu hanmunchǝ oi, cherkǝnfa. ");
INSERT INTO bvw_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Nakna pǝɗata ndangnakanduwa: \"Ni ngǝrandǝ'inna mbǝɗengnuni ma ngǝmma Fara.\" Yimkǝnna kommbawal pǝɗakna Afisa. ");
INSERT INTO bvw_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kǝ tǝrtǝnahaya a Kaisariya, pǝɗaknashi ɗǝkna nda'ǝnna fa tǝrmbanda, pǝɗatahai kǝ Antakiya. ");
INSERT INTO bvw_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ɗifitǝ munchi sǝtna mbǝnniyu, thlaakǝn wiyaan furǝt Galatiya tǝ Firijiya nakna kuwur hǝmtǝ hǝmta, kǝna cheka alchita fa tǝrmbandǝ nat. ");
INSERT INTO bvw_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Lǝ Yahudawatsi thlǝmkǝnwa Afolos ɓaka Afisa. Mǝllan lǝ Iskandariyatǝ nakǝn. Lǝ mbǝr shunda shintǝ'ǝnkaǝn, nat tǝ yarat shunda Fara. ");
INSERT INTO bvw_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Sakafǝchǝ pathlǝ mbanda Lǝmwandǝhar, paɗ nakǝn tǝ alchita fa hur Shemeɗa, la mbukǝn paɗ kǝ sakaan'ichaɗi kǝ ɗar Yǝso keeke, nat tǝ kichu baptisma Yohanna ndak sǝntǝn. ");
INSERT INTO bvw_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Tǝrkaakǝn shundǝ tǝ alchitafa, a kǝtǝn humta Yahudawecha, kǝ sǝktǝ nda Biriskila tǝ Akila ndi, tǝrkǝndǝnda huri, chekangndǝ mbwa'a pathla Farǝ kaǝn. ");
INSERT INTO bvw_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Kǝ yahtǝ Afollossa ɗǝta Akaya, chekang hwanmanchǝ alchita, paɗ yarangndǝ ɗelwera fa tǝr mbandǝsi kǝthlǝm kǝ thlǝndǝndi tǝ harchǝchap. Kǝ saatǝn, kǝssangna fichilesi fǝrkǝkit kaǝn, tǝ mbǝɗa kafata. ");
INSERT INTO bvw_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kǝthlǝm sheraɗa Yahudawecha tǝ alchit kaǝn, fǝraan harǝfata kanda mbanitǝ nofcha, la cheɗkǝnwa hur pathla Fara Yǝso naka Kǝrǝsti. ");
INSERT INTO bvw_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","A thlahmbǝɗi nat Afollossa korinti, Bulus wuyaǝn hur thlet hǝmǝtkǝn saakǝna Afisa, mbǝɗi mbǝsandǝn tahhǝt kimshechǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ndangna kandǝwa: \"A thlinduni Shemeɗ Chiɗchiɗ a thlahmbǝɗi fǝrtuni kitwa?\" Ndangndǝwa: \"Auwa, ɓahwani tamta sǝktǝwa Shemeɗsi Chiɗchiɗwa.\" ");
INSERT INTO bvw_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ndakǝnwa: \"Witǝ baptisama tǝmǝ sandǝfichǝkuni?\" Ndakndǝwa baptisma Yohanna.\" ");
INSERT INTO bvw_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ndak Buluswa: \"Yohanna sǝkǝn baptisma kǝchendǝnwa tǝrnifǝhi, nakna ndanda nofchuwa kǝ fǝrndǝ kit kǝ mbǝɗa le na ɓata ɗiffitǝkǝn, naka Yǝso.\" ");
INSERT INTO bvw_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kǝ sǝktǝndǝ kichu, sang fichǝ baptisma kanda a hur thlǝm Lǝmwanda Yǝso. ");
INSERT INTO bvw_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Kǝ ɗǝffandǝ Bulus hara kanda in, ɓak Shemeɗ Chiɗchiɗ kǝ ɗarnanda, naknda shundǝ tǝ hanshuwunchǝ somsomǝn, paɗ naknda mbu'icha. ");
INSERT INTO bvw_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ufnda nak ndǝ nifǝ kumngǝrǝnsi chap. ");
INSERT INTO bvw_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Yimkǝ Bulussa kǝtǝn humta Yahudawechihi nakna ɓassa lechitfuwa shee ndǝraa mǝkkan, mǝlla halǝ'i'ndǝ tǝ kanda, nakna kahhandǝ hur'inchengnanda kǝ ɗar mwanda Fara. ");
INSERT INTO bvw_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Paɗ funǝsa hurnanda tǝ kwaakwachit i'nda cherkǝnda fǝrkit, naknda njirandǝ mbanda Lǝmwananda mbanitǝ nofcha, kǝthlǝm kichu Bulus sakkǝnhi tǝkanda, pǝɗakǝn tǝ fa fǝrkit, nakna sakandaɗi i sǝkka wembǝta a makaranta Tiranus. ");
INSERT INTO bvw_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Hurat chap mǝlla sǝt kichu, tǝ kichu nat nofchi naka hǝmǝt Asiya shikndǝ pathla Lǝmwanda, Yahudawecha tǝ punofcha. ");
INSERT INTO bvw_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","A shiɗ Farǝ ǝnat sheka i'ndǝ oi tǝ mbǝɗa Bulus le tamuchit ficha nata. ");
INSERT INTO bvw_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Chika mayani'en ndu njelaa'en, le tǝkanghara fat'enfa, la ɗangficha hacha kǝ kǝnda hur hafaɗeng nanda, paɗ kǝ sakndǝhi tǝ ɓǝɓishemecha. ");
INSERT INTO bvw_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Funǝ Yahudawecha fichile la naka wiyandǝ hǝmǝtkǝn, la naknda rǝk ɓǝɓishemecha, la sǝkndǝ tor tǝ thlǝm Lǝmwandǝ Yǝso, a ɗar fichile nak tǝ ɓǝɓishemechikǝnafa la ndangndǝwa: \"A hur thlǝm Yǝso lela ɓastǝ Bulussa ɗarkǝn chamakish.\" ");
INSERT INTO bvw_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","A hurnanda hwechǝsi muɗ kǝ hishcha, naka i kapat pǝrist lǝ Yahudawata le nat thlǝmkǝnwa Sikeba, uf nda lasǝkndǝ kichu. ");
INSERT INTO bvw_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ngǝmang ɓǝɓishemeɗ kǝn kandǝwa: \"A shini Yǝso paɗ a shini Bulus, kunang paɗ kunang miicha?\" ");
INSERT INTO bvw_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nifi nak tǝ ɓǝɓishemeɗɗǝ fiyu pǝrkǝnna ɗarnanda, sherangna kandǝ tǝ alchita, cheknda kissha hurikǝn tǝ wesha tamkwal tamkwal paɗ ɓǝskǝndǝ ndindicha. ");
INSERT INTO bvw_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Fichile nak tǝ sokta a Afisa, Yahudawecha tǝ punofcha, kǝ sǝktǝndǝ i sǝkyu kǝsang lechit kandǝ nat, mwanang ndǝ thlǝm Lǝmwandǝ Yǝso. ");
INSERT INTO bvw_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Oi a hur yuwa fafǝrkit, ɓaknda nata mbu ɓǝɓi ɗǝssǝcheng nanda tallara. ");
INSERT INTO bvw_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Nofchǝ oi fa kulecha ɓakndǝ tǝ ɗelwercheng nanda, 'yangndaɗaɗi a mbanitǝ nofchǝ uf, kǝ sakandǝndǝ hanɗǝɓǝl ɗelwerchi ikkaɗi, mbǝssang ndǝwa a shee azurfa aru kumchit kum ɗurman (50,000). ");
INSERT INTO bvw_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Shunda Lǝmwanda nakna ɗǝta mban tǝ alchitafǝ kaǝn. ");
INSERT INTO bvw_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ɗiffitǝ ichini sǝknatyu, Bulus yarkǝnna hanɗǝkiketi'enwa niɗǝttǝ Makidoniya, tǝ Akaya ka cheta Urshelima, ndakǝnwa ma ɗiɗi mbǝnniyu waat kǝ ɗi hǝmmǝt Roma.\" ");
INSERT INTO bvw_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Thlǝnkǝn funǝ chap hur fa kǝssa torchǝsi, nda Timoti tǝ Arastus, kǝ Makidoniya, mǝllan thlarkǝnhi a hǝmmǝt Asiya tolla. ");
INSERT INTO bvw_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","A hanmunchiniyu thlakkǝ kapat thla hur'i'nda, kǝ ɗar pathlǝ fa tǝrmbanda Yǝso. ");
INSERT INTO bvw_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Thla hur'inkǝn ɓakǝn tǝ mbǝɗa lǝ ɓǝlta, le nat thlǝmkǝnwa Dimitiriyus, lelǝ sǝk tor tǝ hurita, kǝnna ɓǝl kǝtǝn ɗǝhhacha Artemis. Lanakna mbǝssa hanɗǝɓǝlta fa torharkǝnsǝ kaǝn. ");
INSERT INTO bvw_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","A ngomaǝn kandǝ nat tǝ fichile nat witǝ torhareng nandǝ ǝrta, ndakǝnwa: \"Nofcha, ashinuniwa tǝ tori engnaniya mbǝsti kǝnnecha. ");
INSERT INTO bvw_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Kuna nata kuna sǝkta nga Afisa ɗengwa nat tǝ Asiya, Bulus kahhaɗǝ hur'i'nda nofchǝ oi, paɗ tǝɓrandǝ nofchihi oi, tǝ ndatwa ɗǝhachi lǝ tintuni tǝ harcha nga Farǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Mbǝrramsi mborro ɓata naficha sǝɓandǝ thlǝm torengnǝmmaɗi. Ɗiffitǝ ndǝkǝn paɗ tǝ kǝttǝn nuhɗahata kapat alliya a Artemis, nan soktǝ nga ǝnwa, paɗ nan saktǝhi tǝ mwandǝ'en, mǝllan ti lamwanandǝ hǝmmǝt Asiya tǝ kishitǝ nat.\" ");
INSERT INTO bvw_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Kǝ sǝktǝndǝkichu sǝɓkǝ hurcheng nandaɗi, naknda hwat tǝ ndatwa: \"A shok kapat mwanda Artemis a Afisawecha!\" ");
INSERT INTO bvw_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Nǝhǝɗkǝ hǝmǝtkǝnaɗǝ tǝ sheka i'nda, rahkǝndǝ kǝ mbǝt terǝkǝn, kǝssangndǝ Gayus tǝ Aristarkus, shikechǝ wita Bulus a Makidoniya. ");
INSERT INTO bvw_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Yeh Bulus si kǝ yimka hur nofchǝkǝn, ngǝmauchik fa fǝrkit. ");
INSERT INTO bvw_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Kuturchǝsa Asiya naka shikechǝkǝn, thlǝnangndǝ shundǝ tǝ ndatwa, mǝ ɓahiɗa yimta hur nofchi oi yuwa. ");
INSERT INTO bvw_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Yakat nofchi ngomkǝhiyu, kanda hur sheka'i'nda, kǝthlǝm shekndǝhi, funǝ tǝ mbǝɗyu funǝ paɗ tǝ mbǝɗya, sokkǝn terchin fichile sǝnuchik i humang kandǝhi. ");
INSERT INTO bvw_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Funǝ Yahudawechǝsi pǝkkǝndǝ Alekzanda mban. Mǝlan paɗ thla'a'ǝn hara kǝthlǝm kǝ ngasfichǝ ɓa, mbah nan mbwa'anda kandǝ i sǝka. ");
INSERT INTO bvw_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kǝ mbǝssandǝndǝwa lǝ Yahudawat nakǝn, hanthlikchǝ chap ufndǝ kanda hwata, tǝ kapat ɓurata ndatwa: \"Kapat mwanda Artemis a shoka Afisawecha!\" ");
INSERT INTO bvw_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","A mweshitkǝn, lǝ yaratkǝnna hǝmǝtkǝn ngassaǝn nofchihiyu, ndakǝnwa: \"Kunang Afisawecha, wun sǝnuchikwa hǝmmǝt Afisa naka hǝrǝm kǝttǝn ɗǝhhacha kapat Artemis, tǝ kweshcha ngwiyi hǝmka haya afshi? ");
INSERT INTO bvw_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nda i natǝm ichiniyu, kamusi kǝ halǝm i'ndǝwa, kamkǝnsi kǝ ngassuni ɓa mǝ wesshiɗuniwa. ");
INSERT INTO bvw_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ɓakuni tǝ nofchiya ɓǝɗya, chika sokkǝn herkunda kǝtǝn ɗǝhhachengnǝm, ndu kǝ mbundǝ ɓǝɓi'ǝn kǝ ɗar nuhɗǝhhachengnǝmwa. ");
INSERT INTO bvw_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ma Dimitiriyus tǝ shikechǝkǝn tǝ fa sǝt torchi'en, ma ǝnsa thlerǝnandǝ tǝ yuna, a i'nafichǝ kǝtǝn sakmichǝhi, paɗ fa sakmikǝnsi ɗǝknda muh hanhara. ");
INSERT INTO bvw_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ma ǝnsǝ yahtunisa ɓattǝkǝn kǝ mban, ɗǝk ma mweshanda mbanitǝ pǝktecha. ");
INSERT INTO bvw_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kittǝkǝn kǝmna hur lechit ngǝm muhhanhar thlahur inni ɓukweya, kǝthlǝm ngǝma mbǝlla mbu i ɓaktǝ thlahuri'ndǝ kǝ ɗarnandǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Kǝ mbutǝn ichiniyu kalkǝn nofchǝkǝnhi. ");
INSERT INTO bvw_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kǝ tuɓwat thlahur'i'nda, Bulus akǝn fafǝrkit, chekaǝn alchita kanda hur hanɗǝkiketa, ɗǝkǝn ndandǝnakandǝwa sefarǝyuna, pǝɗakna hǝmmǝt Makidoniya. ");
INSERT INTO bvw_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Kǝ wiyandǝn thlet hǝmchikǝn, chekaǝn alchita fafǝrkit kaǝn, ɓakna hǝmmǝt Hellas. ");
INSERT INTO bvw_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Sǝkǝn ndǝraa mǝkkana mbǝnniyu, nakna harǝfa kǝ pǝɗaka Suriya a hur kombawal, nak Yahudawecha yaraa ɓǝɓi'ichafa. Ndǝkǝn yartǝnwa nan ngǝrandǝ in tǝ Makidoniya. ");
INSERT INTO bvw_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nofchi ɗǝfkǝ Bulus nda: Sufata hweya Farus lǝ Biriyata, tǝ Aristarkus tǝ Sakundus, Nofcha Tassalonika, tǝ Gayus nangna Darbe, tǝ Timoti, nat tǝ Tikikus tǝ Tarofimus, nofcha Asiya. ");
INSERT INTO bvw_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Fichile lak pǝɗata ɓan puukǝndǝ kani a Toruwas. ");
INSERT INTO bvw_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Kanang paɗ malkani Filibihi yimkani kommbawal, ɗiffitǝ chi njohmi nguchit mehndǝsa fi'en, hur mundǝ ɗurman ndǝkani mbǝskanda a Toruwas sokkani ɓǝnniyu mundǝ muɗ. ");
INSERT INTO bvw_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Tǝrka mundǝmuɗ ngomkani uf kǝthlǝm kǝ chichangani njohmǝhi. Thlaakǝ Bulus ɓassangna kandǝsi. Nakna harǝfǝ kǝthlǝm yehsa pǝɗata ɓingǝtkǝn, nakna ɓassǝ toltol taa kǝ ɗar fiɗikta. ");
INSERT INTO bvw_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","A kǝtǝni ngomtani a huri afshi tikkeshchisǝ oi. ");
INSERT INTO bvw_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Hwan kimshaasi thlǝmkǝnwa Aftikos sokkǝn ɗassa tinkummbata, kǝssang ɓweni kaǝn. Bulussa ɗar ɓassǝ toltol yimkǝna ɓweni kasat, hǝmkǝnnahaya mǝkkatǝ tǝrkǝtǝnkǝn, tǝrkǝ fichiɗǝ kǝ murǝtkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Tǝrkǝ Bulussa haya kǝ ɓǝɗi nat hwaniyu, ɓirkǝnhi ɗarkǝn tǝrkǝnnda kapahɓa ndakǝnwa: \"Mǝ thla'i hur'i'ɗengnuniwa mwe tǝ shisshingtafa. ");
INSERT INTO bvw_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ngǝrang Bulus inna huri afshi ɗǝkna chichandǝ njohmǝhi chiikǝn. Nakna shundǝ tǝkanda kǝ wenda ɓǝta kanapǝɗata. ");
INSERT INTO bvw_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Pǝɗakndǝ tǝ kimshi'iyu tǝ shisshingtafa nangnda kwalǝ kaǝn. ");
INSERT INTO bvw_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Kǝ natani sa'a'ndǝ kommbawal, yimkanisi kǝ Asus kǝthlǝm kǝ tǝrrani Bulussa mbǝnniyu nda i tahsandǝnhi, mǝllan yarkǝnwa tǝsar natna ɗǝta. ");
INSERT INTO bvw_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Kǝ ɓatna mbǝskani a Asus, tǝrkaninda hur kommbawal ɗǝkani kǝ Mitilin. ");
INSERT INTO bvw_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Thlaakani ɓǝnniyu ɓingǝtle a hur kommbawal ɓakani kǝllari Kiyos. Iskichitkǝn changani kǝ Samas ɗiffitǝ mundǝ ǝrtǝ paɗ saakani Miletus. ");
INSERT INTO bvw_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Tǝrkǝ Bulus hurwa ngu thlarǝhi Afisa wa, kǝthlǝm mǝ sǝɓɓaɗǝ han thlikchaɗa Asiya wa. Mǝlla weshi kǝ saaka Urshelima ma mbandǝsi a farǝ Pentikos. ");
INSERT INTO bvw_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","A Militus thlǝntǝ Bulus, kǝ Afisa kǝ ang fichǝ pǝktecha, mbǝt hwanda kǝ ɓanda mbǝsndi. ");
INSERT INTO bvw_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kǝ ɓatnda mbǝsndi ndangnakandǝwa: \"Kunang tǝ inchengnuni a shinuni witǝ soki sokti tǝkuni, i'sǝka para njang tǝ kuni, thlata fari ɗǝfti sarengnǝ kǝ Asiya. ");
INSERT INTO bvw_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nja sa tor Lǝmwanda tǝ amtita tǝ ɓahmwa'i'nda tǝ ɓahhi satti tǝmbǝɗa ɓǝɓi yarǝcha Yahudawecha. ");
INSERT INTO bvw_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","A malawi mbwa'a i'chakuni le na kǝssanda kunisǝwa, paɗ lanaki sakandakunihar a hur nofcha ɓuɓwetǝfǝwa, tǝ paɗ la yimkǝ huraa hura'a. ");
INSERT INTO bvw_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Kahhaɗi hur'i'nda Yahudawecha tǝ punofcha kǝ tǝrndǝhi mbanitǝ Fara, paɗ kǝ fǝrndǝ kit kǝ mbǝɗa Lǝmwaɗengnǝm Yǝso Kǝrǝsti. ");
INSERT INTO bvw_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Nakǝnya ɗǝki Urshelima tǝ ɓǝɗa alchita Shemeɗ Chiɗchiɗ. Paɗ sinwi'i'na kǝsnja mbǝnniyuwa, ");
INSERT INTO bvw_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","A nakǝn cheɗi Chiɗchiɗtǝ Shemeɗwa, i'sǝka hǝmta na pursunachita natsi, tǝ ɓahta le naka punji. ");
INSERT INTO bvw_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Chika tǝ kichu tǝrwi shisshintengnǝ nda ǝn ndiichinwa, ndu kapat ǝnkǝ fandengnǝwa, mani mbǝlla tuɓwandǝ tori fǝritǝ Lǝmwandǝ Yǝso, le naka ɓassǝ kweshcha kusheng shunda kǝ ɗar kafata Fara. ");
INSERT INTO bvw_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Nakǝnya a shiniwa ngusa hurnuni na ngǝrnatnjuwa, kunangti wiiyaandi kuni kǝni ɓassa kuturichita Fara kunisi. ");
INSERT INTO bvw_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Tǝpaɗ nja sǝnnanda kunisi ɓukweya, mwa'u fwara yunengnunisa ɗar indengnuwa, ");
INSERT INTO bvw_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kǝthlǝm a sǝkwi lǝklǝkchit mbwa'a yaara Farakuni natwa. ");
INSERT INTO bvw_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mbǝramsa inchengnuni, tǝpaɗ uf chaɓi ɗǝftǝ Chiɗchiɗchita Shemeɗ kuni, kǝnuni fa putǝhar kǝ ɗuni mban tǝ hǝrǝm nofcha, fa kuwur mbanda Fara, fichile mbǝssandǝna i'ndi'en tǝ mbǝɗa fwara hwe'en. ");
INSERT INTO bvw_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","A shini tǝ ndatwa ma pǝɗeɗi funǝ ɓǝɓi nofcha nanda yimta hurnuni, paɗ ngunda malandǝ chaɓǝkǝnwa. ");
INSERT INTO bvw_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Tǝpaɗ funa hurnuni nanda thlata kǝnnda shuwun lekta, kǝthlǝm kǝ kahangndǝ fa kuwur mbanda Fara kǝ thlǝmmantnanda. ");
INSERT INTO bvw_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kǝthlǝm ɗǝkǝn sokam tǝ tahhasǝffa, kǝ kuɗkuni, hurat mǝkkan fiɗiktǝsǝwa farǝsǝwa, mallawi mbwa'anda kuni natuni tǝ amtitwa. ");
INSERT INTO bvw_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Nakǝnya njang firi kuni ɓǝɗa Fara, paɗ tǝ shuwun kafat'en, le na mbǝlla tinandǝkuni, paɗ kǝ fǝrangka kuni i tahsandǝnhi nat tǝ fichile nakchiɗchiɗ. ");
INSERT INTO bvw_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","A yahwi zinariya ndu azurfa ndu njelecha yunǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kunang tǝ inchengnuni a shinuniwa a shiɗi tor tǝ harchi'engnǝya kǝthlǝm kǝ kwanayi indengnǝ i'yahtǝn tǝ fichile naka thlǝmmatna. ");
INSERT INTO bvw_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","A hur ichi nat cheɗaɗi sakǝtkǝnakuni tǝ ndatwa, sokkǝn waat kǝsuni tor kicheya kǝthlǝm kǝ kǝssangnguni fichilesi nguchik tǝ alchitafa, kǝnuni kuɗuk pathla Lǝmwandǝ Yǝso mǝllanti ndakwa: \"Fǝr'ǝnna pǝɗaɗa thlǝthi tǝ mbǝsta.'\" ");
INSERT INTO bvw_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Kǝ mweshandǝ Bulus mbutǝkichu, kopkǝnhi hwakǝn nat tǝ kandang. ");
INSERT INTO bvw_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Mǝrkǝndǝhi tit ufnda, hǝmmangndafa kǝskǝndǝndǝhar i saktǝhi. ");
INSERT INTO bvw_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Nakndǝ tǝ sǝɓhura, kǝthlǝm shuni ndandǝnakandǝwa ngundangǝrnatndǝwa, thlaakǝnda ɗǝfkǝndǝndi kǝmbǝt kommbawal. ");
INSERT INTO bvw_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Kǝ maltanikandǝhi, yimkani hur kommbawaltǝkǝn pǝɗakani kǝ Kos, wendambǝt paɗ ɗǝkani kǝ Rodes, thlaakani mbǝnniyu paɗ kǝ Fatara. ");
INSERT INTO bvw_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Kǝ mbǝstani kommbawalti na ɗǝtǝ furut Finikiya, yimkanisi pǝɗakani. ");
INSERT INTO bvw_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kǝ tǝrkaatani nat Sayifurus, malkanihi tǝ kukun hishingta, ɗǝkaniɓan tǝ pǝɗata hǝmmǝt Suriya. Tǝrkanihaya a Taya, kǝthlǝm a mbǝnniyu nat kommbawaltǝkǝnna harandǝ ichi'enna haya. ");
INSERT INTO bvw_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Kǝ mbǝstani fafǝrkit, sokkanihi mbǝnniyu mundǝmuɗ. Tǝ mbǝɗa shemeɗa ndangnda Buluswa mǝɗiɗa Urshelimawa. ");
INSERT INTO bvw_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Tǝ kichu kǝ saatǝ munchi natani thlata, kǝnkanihursǝ tǝ wita. Thlaakǝnndǝ ufnda tǝ nishcha tǝ hwecha ɗǝfkǝndǝ kani kǝ ɗǝffitǝ hǝmta, mbǝnniyu kopkanihi mi ama hwankani, ");
INSERT INTO bvw_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","kanani saktǝhi tǝkanda. Kanani yimta hur kommbawal, kandang paɗ ngǝrangndǝ'ina huri. ");
INSERT INTO bvw_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kǝ tuɓwandani witengnani a Taya, saakani kǝ Tolemayis, ndangani ǝnna fahchǝnani, sǝkani mundǝ ǝrta mbǝɗengnanda. ");
INSERT INTO bvw_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Wembǝtle thlaakani ɗǝkani kǝ Kaisariya, yimkani kǝ hura'a Filibus lǝ ɓassa, le nak ǝrta a hur fichile muɗ taatǝ fichǝharyu. ");
INSERT INTO bvw_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Hwechǝ'ensi fwaɗa kǝ hantarcha ngwanauchit fichǝkanda, lanaknda mbu'icha. ");
INSERT INTO bvw_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ɗiffitǝ sǝt hanmuncha mbǝnniyu, ɓak yunǝ lenaka tapǝna'a nat thlǝmkǝnwa Agabus nakna Yahudiya. ");
INSERT INTO bvw_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Kǝ ɓat Agabussa thlǝmmatnani, tǝrkǝn sahǝt kǝnhura Bulus. Ndǝkǝn kǝnandǝn harchi'en, tǝ sarǝchi'en ndakǝnwa: \"A i'ndat Chiɗchiɗ tǝ Shemeɗkǝnya, 'kichu Yahundawecha Urshelima, nanda kǝnandǝ lǝ sahǝt kǝnhuriya, paɗ kǝ fǝrndǝndi kǝ mbǝɗa punofcha.\" ");
INSERT INTO bvw_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kǝ sǝktani kichu, kanang tǝ nofchi naka mbǝnniyu, hwanangani Bulus mǝ ɗiɗa Urshelimawa. ");
INSERT INTO bvw_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ngǝmmang Bulus ndakǝnwa, \"Kǝthlǝmmi natuni sǝtkichu? Kǝthlǝmmi natuni tita kǝnuni sǝɓandǝ hanɗǝkiketengnaɗi? A tehshifa nga kǝnitǝ ɗengwama, ndu kǝ ɓǝllikǝficha a Urshelima kǝthlǝm thlǝm Lǝmwandǝ Yǝso.\" ");
INSERT INTO bvw_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Mbǝla'uchikani tǝɓrandǝ yarǝ'enhiyu, ngaskani ɓa, ndakaniwa: \"Suku sakta Lǝmwanda kǝ nǝhɗǝnhi.\" ");
INSERT INTO bvw_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ɗiffitǝ munchǝkǝn tahǝskanifa pǝɗakani Urshelima. ");
INSERT INTO bvw_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Funǝ fafǝrkitsa Kaisariya ɗǝfkǝ kani, ɗǝkndǝ tǝ kani mbǝɗa Manason lenatani tǝrtahaya mbǝt'en, nifǝkǝn lǝ Sayifurustǝ nakǝn, nakǝn ǝrta a hur fafǝrkitti tǝrkakǝnyu. ");
INSERT INTO bvw_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Kǝ ɓatani Urshelima, thlǝk fahchǝnanikani tǝ mbǝnfat kaǝn. ");
INSERT INTO bvw_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Wendambǝta pǝɗakani tǝ Bulus kǝ mbǝɗa Yakubu, pǝktecha fafǝrkit kanda mbǝnniyu. ");
INSERT INTO bvw_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ɗiffitǝ nda ichakanda, ndǝkǝn mbwa'andǝna kandǝ ǝrtǝ ǝrtǝ ichi sǝt Fara a hur punofcha, tǝ mbǝɗa tori sǝt Bulus. ");
INSERT INTO bvw_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Kǝ sǝktǝndǝ kichu, mwanangndǝ Fara. Ndangnda Buluswa, \"Neɗnǝwa hwanmanani, terǝ nofchǝ oi a hur Yahudawecha firndǝ kit, ufndǝ fa sǝrǝh kuwur kussa Musa naknda. ");
INSERT INTO bvw_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","A mbwa'a fichǝ kushengwa kandǝ ndatwa, sokǝn lasakagnga Yahudawechihar uf fichile naka hur punofcha wa muhang ndǝ kussa Musa ɗi. Paɗ la ndakuwa mǝ heshafichǝ hwechengnandǝwa, paɗ mǝ kurindǝ tormurteng nandǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Nakmasǝtwa kǝniya chu? Kǝthlǝm nanda sǝk kushsheng ɓaɗeku. ");
INSERT INTO bvw_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","I naksi su i ndutani kǝ sǝna. Nofchengnanisǝ fwaɗa, fichile ak ichimi. ");
INSERT INTO bvw_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Haru nofchiniyu kǝ ɗuni sapandǝ faɗengnuniɗi, kǝ kwanǝ i la kwantǝficha, kǝthlǝm kǝ hǝssang ndǝ kanda. Tǝ kichu nat ficha sǝndǝ tǝ ndatwa, i mbwa'andǝ ficha kanda nga kitchitsuwa, paɗ nakndanat nda sokǝn naka kuwur i mbutǝ kustǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Paɗ punofchi fǝrkǝkit, a thlinani ɗelwer tepi thlaɗanihi, mǝngǝmiɗunifa kǝ sǝmmuni i'thlandǝficha ɗǝhhachiwa, tǝ fǝllawichitta, tǝ chi i'ɓekrandǝfichǝ ɓurat'en, paɗ tǝ chi thlu tǝ fwar'en. ");
INSERT INTO bvw_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ɓingǝtkǝn Bulus tǝrkǝn nofchǝkǝn, sapangfichǝ kandaɗǝ ufnda. Yimkǝnnda kapat hura'a Fara, kǝthlǝm kǝ sǝnaǝn farǝ nǝhata saptengnandaɗi, a fari nat ficha fǝr poffǝn kǝthlǝm chikawuni. ");
INSERT INTO bvw_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Kǝ nat mundǝ muɗɗa yah nǝhata, Yahudawechi ɓaka hǝmǝt Asiya nakndǝ Bulus a kapat hura'a Fara. Ndǝkǝn chikandǝndǝ terǝ humkǝn ufnda, kǝssangnda. ");
INSERT INTO bvw_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Naknda hwata kannda ndatwa: \"Nofcha Isra'ila, kǝssamnakanisi! Le nifiya lasakaǝn ɓǝɓi'ichaɗi kǝ ɗar nofchengnǝm chika ayi, kǝnambwa'anda chika wuni, kǝ njirndǝ kussa Yahundawecha. Lashuwungkǝn ɓǝɓi'icha ɗar kapat hura'a Fara, paɗ latǝkmaǝn kweshcha mbǝɗihi chiɗchiɗya tǝ mbǝɗa ɓattǝ punofcha hurkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Kǝthlǝm soh neɗ ndǝ Tarofimus lǝ Afisawata, kanda mbǝt ǝrta a hur hǝmta, tǝrkǝndǝwa Bulus yima kapat hura'a Fara tǝ ndi. ");
INSERT INTO bvw_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Chatkichuyu shekɗang in'ndǝ hǝmta, ɓaknofchǝ tǝ rahtǝ ufnda, kǝssang ndǝ Bulus kahkǝndǝnda kish, a hur kapat hura'a Fara, chatkichuyu ngǝllang fichǝ mikǝtǝncha. ");
INSERT INTO bvw_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Kanda ɗar yarǝ ɓǝllanda, saakǝ kushengkǝna mbǝɗa kapat lǝthlǝrhwata, ndatwa kim Urshelimahi tǝ thla hur in'nda. ");
INSERT INTO bvw_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Chatkichuyu harkǝn fathlǝrhwecha tǝ pǝktat fathlǝrhwecha Roma, rahkǝnda hai kǝ mbǝɗi nat ngomnofchǝkǝn. Paɗ kǝ natndǝ fathlǝrhwechǝkǝn tǝ kapat nanda malang ndǝ tǝp Bulus. ");
INSERT INTO bvw_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ɓak kapatnandǝ nduk kǝssaǝn, ndakǝnwa kǝ kǝnnang ficha, tǝ chalalochǝ chap. Kanna sahtǝwa ndu wunnakǝn, tǝ i paɗ sǝttǝn. ");
INSERT INTO bvw_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Thlaakǝ terǝ nofchiyu naknda muh hanhara, ndakfunuwa kǝcha, nak funǝndatpaɗwa kǝcha. Kǝthlǝm yakat thlahur in'nda hullaɗa mbǝssandǝ ɗarshuwunkǝn, ndakǝnwa kǝ ɗafichǝ tǝnda hura'a fathlǝrhwecha. ");
INSERT INTO bvw_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Kǝ saatǝ Bulus kǝmi tǝrta, tǝrkǝ fathlǝrhwechǝkǝnndi kǝthlǝm thlahur'inda terǝ nofcha, ");
INSERT INTO bvw_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Yakat nofchǝ oi kuwurkǝkanda, kanda hwata tǝ ndatwa: \"Ɓǝllamǝn!\" ");
INSERT INTO bvw_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kǝ natndǝ nduk yimtǝ tǝ Bulus kǝ hura'a fathlǝrhwechǝkǝn, ndǝkǝn ndandǝna kapatnandǝwa: \"Ni mbǝlla shunutǝwa?\" Ngǝrkǝ kapatnandǝtǝkǝnsuwa: \"Awi la mbǝrku Helenanciwa? ");
INSERT INTO bvw_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Awi nga sokǝn naka Lǝmasarawatwa, naka a hurechi mbǝrkǝhi humang thlahur'indǝyuwa, kahkǝ nofchǝ aru kumchit kum fwaɗa fa ɓǝlfata kǝ loktarǝyuwa?\" ");
INSERT INTO bvw_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ndǝkǝn ngǝmmandǝ Buluswa: \"Ə, njang Lǝyahudawata naki a Tarsus, a hachahai Kilikiya. Njang ɓaki hǝmǝɗi sǝntǝficha, nja hwanuta malitǝn kǝ shunayi nofcha.\" ");
INSERT INTO bvw_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Kǝ fǝrandǝn mbanda, thlarkǝ Bulus kǝ mbǝt thlara, thla'anghara kǝmbǝɗa terǝ nofcha kǝthlǝm kǝ ngasndǝ ɓa. Kǝ ngastǝ ndǝ ɓa, shunaǝn kandǝ tǝ mi Aramayata, ndatwa: ");
INSERT INTO bvw_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","\"Hanmanchina tǝ shinchina sǝkamnji, kǝ mbwa'ayikuni isǝka kǝthlǝm kǝ cheɗayikuniwa suwuni'ǝnwa.\" ");
INSERT INTO bvw_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kǝ sǝktǝndǝndǝ shunaɗǝkandǝ tǝ mi Ibraniyanci, ngaskǝndǝ ɓa. Ndǝkǝn ndatǝnwa: ");
INSERT INTO bvw_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","\"Njang lǝ Yahudawat naki, ngǝtkǝfichinja Tarsus, a hachahai Kilikiya. Nat tǝkichu mwanki hǝmmǝɗiya, paɗ sakikǝfichǝ changkathar tǝ mbǝɗa Gamaniel, le sakikǝ ichǝhar uf kǝ ɗar sakta kakechengnǝm. Lǝ sǝrǝhki kuwur Fara, nda i uffuni lǝ sutuni a ɓukweya. ");
INSERT INTO bvw_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ɓahhaɗi fa kuwur mbanda Yǝso, paɗ lanaki ɓǝllandǝkanda, lanaki kǝnandǝ nofcha nda hishcha tǝ nishcha, la muhki kanda hur pursuna. ");
INSERT INTO bvw_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Kapat pǝrist tǝ pǝktat fasakmicha, tǝ fa hǝmmbanicha, na sheta kǝ ɗarna. Mbǝɗengnandǝ thlitti ɗelwer kǝ mbǝɗa fahchinǝm Yahudawecha, thlaaki pǝɗakǝ kǝ Dimaska, kǝ thlǝm kǝ hari fichile naka mbǝnniyu, kǝ ɓitǝkanda Urshelima a kǝnnda, ɓah nanda fǝraa pwane kanda. ");
INSERT INTO bvw_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","\"Nja ɗar pǝɗata, kǝ saati nduk tǝ Dimaska, kana hur fara sata, chatkichuyu ɓak ɗwachita afshi, finikǝn. ");
INSERT INTO bvw_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Hǝmkǝnhi kǝ hachahaya sǝkki ɓurata ɗitǝwa: 'Shawulu, Shawulu, i'mi natu fǝri pwancha?' ");
INSERT INTO bvw_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Njang paɗ ngǝmayiwa, sokǝn wuni, Lǝmwanda?' Ndǝkǝn ɗitǝnwa: \"Njang Yǝso Lǝnazaratta, le natu fǝra pwancha. ");
INSERT INTO bvw_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Paɗ fichǝle naka thlǝmmatna, neɗɗi ɗwaachikkǝn, nattǝkichu sukundǝ ɓurata lenaka shundǝ tǝ njiuwa. ");
INSERT INTO bvw_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ndakiwa, mǝnati sǝtta Lǝmwanda?\" Ndǝkǝn ɗitǝ Lǝmwanduwa, thla'u kǝ yimna Dimaska, a mbǝnniyu nat ficha mbu'u i tahsandǝ fichǝhi kǝ sǝnna. ");
INSERT INTO bvw_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kǝ hullandi nat mbǝta kǝthlǝm ɗwaachit hwaɗiyu, thlaakǝ fichile natani mbǝt ǝrtǝyu kǝskǝndǝ harengna, saaki kǝ Dimaska: ");
INSERT INTO bvw_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","\"Yunǝsi nat thlǝmkǝnwa Hananiya, la kuwur Farǝ nakǝn nda iyarandǝ kus hi, lela shunang Yahudawecha nat kǝ sǝkndǝndi fichile nak tǝ sokta mbǝnniyu. ");
INSERT INTO bvw_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ɓakna mbǝsnji, thlarkǝn nduk tǝ nji ndikǝnwa: \"Shawulu hwanya thlu natmbǝɗeku.\" Chatkichuyu naki nat mbǝta nakindi. ");
INSERT INTO bvw_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ndakǝnwa: \"Tǝɗ Fara kakechengnǝmsa kǝthlǝm kǝ sǝnnǝ sakti'en, kǝ nana lǝ kachita kǝ sǝknǝ shunda mi'en. ");
INSERT INTO bvw_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kǝthlǝm kǝ sǝnna lǝ sheta'en kǝ mbǝɗa nofchǝ nat kǝ ɗar i'natu, tǝ'i'sǝktu. ");
INSERT INTO bvw_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nakǝnya mǝnatu puta? thla'u, kǝ sukǝ fichǝ baptisma kǝthlǝm kǝ sapang fichǝ ɓǝɓifaɗekuɗi, tǝ mbǝɗa at thlǝmkǝn.\" ");
INSERT INTO bvw_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","\"Kǝ ngǝrandi'ina Urshelima, naki hwanda a kapat hura'a Fara, ɓak ǝn nda sǝnnata mbǝsnji. ");
INSERT INTO bvw_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Naki Lǝmwanda, nangna nditǝwa: \"Suleɗleɗ kǝ chenakisha Urshelima, kǝthlǝm ngunda thlǝt sheta e'ku kǝ ɗarnǝwa.\" ");
INSERT INTO bvw_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Njang paɗ ndakiwa: \"Lǝmwanda, kandang tǝ inchengnanda a shinnda i sǝka kǝtǝn humta Yahudawechǝhi, a kǝnnaɗi fichile fǝrkǝkit kǝmbǝɗeku, paɗ a tǝppaɗi kanda. ");
INSERT INTO bvw_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Kǝ thlǝrandǝ fichǝ fwara Istifanusa ɗi, lǝ sheta ti e'kuyu, njang ma njang kitta mbǝnniyu, nja kuwur i sǝt ficha, nja pu njelecha fichilehar ɓǝlangyu.\" ");
INSERT INTO bvw_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ndikǝnwa: \"Thla'u puɗu, ni thlǝnsa langna kǝ mbǝɗa punofcha.\" ");
INSERT INTO bvw_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Terǝ nofchǝkǝn naknda kathlǝmata Bulus, ɓakna mbu shuniniyu, mǝlla ɗar mbu'ichiniyu, thla'ang ndǝ hwata kanda ndatwa: \"Ɓǝllamǝn! Sakamǝn witǝ nifihiya tǝkishita, kamusi kǝ nan tǝ shisshingtǝwa!\" ");
INSERT INTO bvw_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Naknda hwata nak nda muhandǝ ɗǝsupchengnandaɗi, naknda thla'andǝ tǝnnata, ");
INSERT INTO bvw_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Kǝthlǝm ndǝkǝn Lǝmbanita fathlǝrhwata shuwunkǝn tǝ ndatwa, kǝ ɗa fichǝ tǝ Bulus kǝ mbǝɗi la soktǝ fathlǝrhwata, kǝthlǝm kǝ tǝpangnda kǝ sǝnndǝ isǝk nat nofcha hwanda kicheya. ");
INSERT INTO bvw_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Kǝ kǝnnandǝnda kǝthlǝm kǝ tǝppangnda, ndang Bulussa kapat lǝthlǝrhwatkǝnna Roma lenak kit nduktǝndi: \"Awi, hur kus keekesi kǝ sangnǝ ǝn ndu kǝ tǝpang ficha nifi naka hanhura'a Romawecha nga tǝ sang fichǝ kitasǝwowa?\" ");
INSERT INTO bvw_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Kǝ sǝktǝ kapat lǝthlǝrhwata Roma kichu, ɗǝkna mbǝs lǝmbanikǝn ndaǝnwa: \"Mǝnatu yarǝsǝta? Nifiya hwan Roma nakǝn.\" ");
INSERT INTO bvw_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ɓak kapat nanda mbǝs Bulus ndaǝnwa: \"Mbu'i'tǝn kit, sokǝn hwan hachahai Roma wa?\" Ndang Bulus, \"Ə.\" ");
INSERT INTO bvw_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ngǝmmang kapat lǝthlǝrhwatkǝnwa: \"njang tǝ hanɗǝɓǝltǝ oi mbǝsti nata hwanhǝmta. Ndang Buluswa: \"Njang ɗǝkǝn ngǝttǝfichǝ nji.\" ");
INSERT INTO bvw_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Fichile naka yarǝ tawasǝndi chatkichuyu mbahkǝndǝ ɗifi'in. Kapat lǝthlǝrhwatkǝn kǝsǝntǝnwa Bulus lǝ hwan hachahai Roma nakǝn lechǝkǝn, paɗ teppa kǝnnaɗa. ");
INSERT INTO bvw_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Kǝ wentǝ mbǝtta, ɓak kapat lǝthlǝrhwatakǝn yahkǝnsa sǝn kachit i sǝk ɓat Yahudawecha muhhanhar Bulus, ɓakna kwasandǝhi, mbukǝn tǝ kapat ɓurat ndatwa, i sǝka pǝrischa tǝ fasakmicha kǝ ngomndǝhi. Ɓakǝn tǝ Bulus kǝ thlarnka mbanitǝnanda. ");
INSERT INTO bvw_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Thlaakǝ Bulus nakna kǝlandǝ fa sakmichǝkǝn, ndakǝnwa: \"Kunang hwanmanchina, kǝ ɓukweeya a hur hanɗǝkiketengna mwa'u ǝn'sǝ ngweɗechin ndu ǝnat thlahur'i'ndǝ kǝ ɗar naɗengnǝhi a mbanitǝ Farawa.\" ");
INSERT INTO bvw_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Kǝ sǝktǝndǝ kichu, thlaakǝ Hananiya kapat pǝrist, ndǝfkǝn fichile nak nduk tǝ Bulus, kǝ tǝpndǝnda mi. ");
INSERT INTO bvw_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ndak Buluswa: \"Sokǝn kohat nifa! Sokǝn thlari pa'andǝ fichi fur kurrata, sokǝn ma na Fara tǝpsa! Sokkuhi kǝnna si kitasi kǝ ɗar sakandaɗa Musa, a landǝfku kǝ tǝpfichi nji, i nguchik keeke a hur sakakǝnnaɗi.\" ");
INSERT INTO bvw_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Fichile nak kikit mbǝnniyu ndangnda Buluswa: ''Kapat Pǝristsa Farǝ natu era?'' ");
INSERT INTO bvw_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ndak Buluswa: \"Hwanmanchina, a sǝnwiwa mǝllan naka kapat Pǝristwa. Kǝthlǝm a yeraɗficha a hur shunda Farǝ, ndatwa: \"Mǝ erinǝ lǝhǝm mbanita nofchǝwa.\" ");
INSERT INTO bvw_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Kǝ sǝntǝ Buluswa, funǝ Sadukiyawecha funǝ paɗ Farisawecha, thla'a'ǝn ɓurata hur fasakmicha, ndakǝnwa: \"Hwanmancha, njangma lǝ Farisiyawat naki, Hweya Farisiyawa. Andiya kǝthlǝm ɗifi inndǝ kǝ ɗar thlata mǝmatcha ndǝkǝn sǝk natuni sakimiya.\" ");
INSERT INTO bvw_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Kǝ mbuɗtǝn kichu, thlaakǝ halǝ'i'nda tinnda Farisiyawecha tǝ Sadukiyawecha, sakkǝ ngomnofchǝkǝnhi kurutkǝn chap. ");
INSERT INTO bvw_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ndak Sadukiyawechuwa, thlata mǝmatchǝsuwa, mala'ikachisǝwa, ndu Shemeɗa. Farisiyawecha kandang ngǝmmandǝwa neesi nat mǝkkanwa. ");
INSERT INTO bvw_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Thlaakǝ kapat sheka'inda naknda shundǝ kǝ afshi, funǝ malndǝmchǝ fa sakandǝ kussa Musaɗi, Farisiyawecha thlarkǝndǝhi kit, naknda halǝ'innda, ndakndǝwa: \"Kanang a mbǝssawani ɓǝɓi i'sǝt nifiyawa. Mbahya yunǝ Shemeɗa ndu mala'ika shunangnga.\" ");
INSERT INTO bvw_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kǝ thlaatǝ halǝ'inkǝn kaǝn, lechik kapat lǝ thlǝrhwatkǝn kǝthlǝm mǝni nda thlǝthlahhandǝ Bulus hi. Fǝrkǝn mi tǝndatwa, fathlǝrhwatkǝn kǝ tǝrndahaya kǝ thlǝndǝ Bulussa ɗǝ tǝ alchita, kǝ ɓandǝ tǝndǝ kǝ mbǝt sokta fa thlǝrhwata. ");
INSERT INTO bvw_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Sǝk fiɗikta thlarkǝ Lǝmwandǝ nduk tǝ Bulus, ndakǝnwa: \"Ɗu mban tǝ alchit hanɗǝkiketa, nda i fǝrtu sheta kǝ ɗarna a Urshelima, kichu paɗ kamkǝsi kǝ fǝrnǝ sheta ɗarna a Roma.\" ");
INSERT INTO bvw_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Wendambǝta, Yahudawecha tahǝskǝndǝfa kǝthlǝm kǝ ɓallangndǝ Bulus. Akndǝ ichǝmi tǝ ndatwa, ngunda sǝmtǝwa ngunda satwa, se ma ɓǝllandǝ Bulus. ");
INSERT INTO bvw_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Fichile sǝk ɓǝɓi tahasinifiyu, pǝɗanda nifǝhi kumchit fwaɗa. ");
INSERT INTO bvw_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ɗǝknda mbǝɗa pǝktat pǝristcha tǝ fa hǝmmbanita, ndakndǝwa: \"A eɗɗani kapat ichimi tǝ ndatwa, ngani sǝm'ǝnwa ngani sat'ǝnwa sema ɓǝllaɗani Bulus. ");
INSERT INTO bvw_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Kǝthlǝm kichu, nakǝnya kunang tǝ fasakmicha, hwanamǝn kapat lǝ thlǝrhwatkǝn, kǝ ɓaǝn Bulussa kuni, nda tǝ yahunisi kǝ ngǝruni sahamihar kaǝn, kanang paɗ tehshanifa kǝ ɓǝllangngani kana sata.\" ");
INSERT INTO bvw_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kǝ sǝktǝ hweya hwanman Bulus witǝ tahasifǝ nanda sita, ɗǝkna yimta mbǝt sokta fathlǝrhwatkǝn mbwa'angna Bulus. ");
INSERT INTO bvw_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Bulus akǝn yuna hur kapat fathlǝrhwata Roma, ndakǝnwa: \"Ɗu tǝ hwankimshi'iya mbanitǝ kapat fathlǝrhwata, shundǝsǝ yahtǝnsa mbwa'anda.\" ");
INSERT INTO bvw_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Kapat lǝthlǝrhwatkǝna Roma tǝrkǝn hankimshikǝn, ɗǝkǝn tǝnda mbǝɗa kapatnanda. Kapat lǝthlǝrhwatkǝnna Roma, ndakǝnwa: \"Bulus hwan pursunatiyu, aknji, hwanikǝnwa kǝ ɓitǝ hwankimshi'iya mbǝɗeku, kǝthlǝm ǝnsǝ natna mbu'uta.\" ");
INSERT INTO bvw_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kapat lǝthlǝrhwatkǝn kǝskǝn hara kimshikǝn, kahkǝnda kǝlar, sahaǝn miya ɓuɓweeta: \"Mǝnani yahtusa mbwi'itiyu?\" ");
INSERT INTO bvw_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ndang kimshikǝnwa: \"Pǝktecha Yahudawecha tahsandǝhi, nanda hwanuta kǝ ɗangnǝ Bulussa kanda mbanitǝ fasakmichǝ ishki, nda yahkǝndǝ kǝ ngǝrndǝ tausandǝ shuwunkǝn'enhi kaǝn. ");
INSERT INTO bvw_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Paɗ mǝ ngǝmmana kandǝsǝwa, kǝthlǝm pǝɗaɗa nifǝhi kumchit fwaɗa kanda ɗuwetndi kanda kat kǝ ɓǝllangnda, paɗ tepa eɗndǝ i'chimi ndatwa, ngunda sǝmtǝwa ngunda satwa sema ɓǝllanda. Nakǝnya a tehishndǝfa, ngǝmteku ndak nannda puta.\" ");
INSERT INTO bvw_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kahhang kapat Lǝthlǝrhwatkǝn thlǝmata hwankimshikǝn tǝ ndatwa: \"Mǝ mbwa'ana yunuwa mbu'i'nǝ shuniyawa.\" Kalkǝndǝhi kǝ pǝɗan. ");
INSERT INTO bvw_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Kapat lǝthlǝrhwatkǝn akǝn pǝktat fa thlǝrhwechǝkǝnna Roma chap, ndangnakandǝwa: \"Tahsamfa ɗukuni Kaisariya, hwanthlikǝn hanherta i'fiɗikta tǝ fa thlǝrhwechǝ kumchitkum chap, tǝ kumchit muɗ fa pǝrpirishcha, tǝ fa thlǝrhwat kumchitkum chap fa mbat tǝ pela.\" ");
INSERT INTO bvw_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Kǝ kuni pirshihar le nat Bulussa pǝrtǝsi, kǝ ɗunitǝnda mbǝɗa Ngomna Felis ngwalngwal. ");
INSERT INTO bvw_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Yarakǝn ɗelwer nda iya: ");
INSERT INTO bvw_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","\"Thlata Kalaudiyas Lisiyas, Kǝ mbǝɗa lǝ mwandǝ Ngomna Felis. Ndat ǝn oi. ");
INSERT INTO bvw_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Nifiya kǝsandǝ Yahudawecha, ndukndǝhi kǝ ɓǝllangnda, thlaaki leɗleɗ tǝ fathlǝrhwecha thlǝkindaɗi, kǝthlǝm a shikiwa mǝllan hwanhǝmǝt Roma nakǝn. ");
INSERT INTO bvw_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Yahkisǝ kǝ sǝki isǝtǝn nannda tǝramifa, ɗǝkitǝnda mbanitǝ fasakmichengnanda. ");
INSERT INTO bvw_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ɓaki mbǝssandǝwa naknda tǝramifa kǝɗar shuwun sakandengna nda ɗaɗi, kǝthlǝm i'sǝtǝn saawa ɗǝffandafǝ kǝ kǝnangnda ndu kǝ ɓǝllangndǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Kǝ mbu'i'tǝfichiwa ɓǝɓi ǝnsǝ natficha yarandǝfa, chatkichuyu thlǝnukindi. Ndǝkǝn ndandǝ fichile muhkǝ hanharkǝnwa, kǝ ɗǝnda mbuta mbanituwa i'nat ndǝ sǝtǝn ndǝɗuwayu.\" ");
INSERT INTO bvw_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Kǝthlǝm ndǝkǝn fa thlǝrhwatkǝn tǝrkǝndǝ Bulus, nda i mbwa'andǝ ficha kanda, ɗǝkndǝ tǝndi kǝ Antifatiris a fiɗikta. ");
INSERT INTO bvw_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ɓingngitkǝn malkǝndǝ fa thlǝrhwatkǝn fichile la pǝr kǝ pirishcha kǝ ɗǝnda mbantǝndi, kandang paɗ ngǝrangndǝ'inna mbǝtsoktengnanda. ");
INSERT INTO bvw_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Kǝ ɓat fathlǝrhwatkǝn, fichile la pǝr kǝ pirihcha saakǝnnda Kaisariya, fǝrangndǝ ɗelwera ngomna, malkǝndǝ Bulushi a hurhar'en. ");
INSERT INTO bvw_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Kǝ changkandǝ ngomna ɗelwertǝkǝn, sahaǝn mi Bulus ndu ɓakna hǝmmǝt mi? sǝkǝnwa ɓakna Kilikiya, ");
INSERT INTO bvw_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ndakǝnwa: \"Ni kathlǝmmata shundeku, a fari ɓatfichile muhkǝ hanharwa: \"Ndǝkǝn fǝrtǝ ngomna shunda kǝ ngǝllangficha, a huri kuturichita Hiridus le tintǝn. Kǝ puufichindǝhar. ");
INSERT INTO bvw_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ɗiffitǝ munndǝ ndurman kapat pǝrist Hananiya, ɓeɗ tǝ funǝ pǝktecha, Paɗ tǝ yunǝ lǝmbǝr shunda le nat thlǝmkǝnwa Tartulus. Kǝthlǝm kǝ muhndǝ hanhar Bulus a ɓanitǝ ngomna. ");
INSERT INTO bvw_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","A yimang fichi Bulussi, Tǝrkaakǝ Tartulus muh hanhar Bulussa ɓanitǝ ngomna Felis, ndakǝnwa: \"Nakǝn tǝ ɓǝɗa sǝndeku sandǝ fichi kachit nofchengnǝm, Paɗ kǝthlǝm lakǝllaku langnga, ndǝkǝn sǝk tahǝstǝ fichi ichi oi fichile sokka kachitta nofchengnǝm. ");
INSERT INTO bvw_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Nofchengnǝm chika ayi kanda su usoko nga sǝrtǝfuwa. ");
INSERT INTO bvw_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Paɗ kǝthlǝm mǝ sǝɓaɗi hanthlik chikǝn eku'ndǝwa, nja hwanuta hur kachiɗeku Kǝ kangnǝ thlǝmmata i nguɗǝh nattani ɓuta. ");
INSERT INTO bvw_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Mbǝssaɗani ndatwa nifiya lǝ ɓat tǝ thlahur'inda, lanakna ɓat tǝ thlahur'inda thlerǝ Yahudawecha, chika tǝteni a hur kishita, Paɗ mǝllan nalǝ mbanita i leki la atfichiwa Nazarawa. ");
INSERT INTO bvw_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Keɗ kǝ tǝkmaǝn kapat hura'a Fara ɗi, Paɗ a kǝssangngani. ");
INSERT INTO bvw_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Paɗ Lisiyas lǝ ɓanita, ɓakna thlǝtndaɗaɗi harengnani tǝ alchitta. ");
INSERT INTO bvw_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","A ɗiftǝ fa muhhanhar nifiya kǝ ɓanda ɓanituwa. Ma usanǝ mihar sokǝn tǝ i'ndeku, nu mbǝlla sǝnda mbǝɗ'en nat ichi nattani muh hanharkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Yahudawecha kwiyirndǝ ɗiffitǝkǝn kichu. Ngǝmangndǝwa, nak ǝnnatkǝn kichu. ");
INSERT INTO bvw_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Fǝrang ngomna mba shunda Bulus, ndǝkǝn ngǝmandǝ Bulus ndakǝnwa: \"Ni hǝrkandǝ indengna tǝ chiɗchiɗchit hanɗǝkiketa, kǝthlǝm shiniwa shiɗnǝ hurechǝ oi, sassa kiita nofchiya. ");
INSERT INTO bvw_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ma tausanǝhi nu mbǝssandǝ wa, mbǝrawa munndǝhi kumngǝrǝnsǝchapwa, Kǝ pǝɗati Urshelima ka hwanda. ");
INSERT INTO bvw_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Fa muh hanharnǝtiya tamunda mbǝssitǝ nja halǝ'i'ndǝ tǝ nifǝwa, ndu nja thla'andǝ hur'i'nda nofcha kapat hura'a Fara ndu a mbǝt humta Yahudawecha, ndu a hur hǝmǝtkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ichi nat'nda mbuta ɗar i'ndengnǝ nakǝnya ngunda mbǝlla fǝru sǝndǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ən ǝrtǝ ngǝmandi, ndǝkǝn naka nja kuwur Fara kakechengnǝm tǝ mbanda nofchi la kuwurkǝ Yǝso, la atfichiwa Nazarawa, lǝnaki fǝrkitta ɗar ichi uf yarandǝ fichihi nda i lasakandǝ Musaɗi paɗ tǝ laulawecha Tapǝnecha. ");
INSERT INTO bvw_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nja ɗǝf hanɗǝkiketa mbǝɗa Fara, nda i nat fichileya sǝta, ndatwa, naficha thla'andǝ mǝmatcha, fa kafata tǝ fa ɓah kafat nat. ");
INSERT INTO bvw_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ndǝkǝn sǝk pware lanati kweetǝhi a hanɗǝkiketengna, kǝ soki nga kweeɗechinna mbanitǝ Farǝ tǝ nofchǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Paɗ ɗiffitǝ hanhurechǝ nguɗeh, ɓakiɗi kǝ Urshelima kǝthlǝm kǝ fǝripoffǝn kǝ mbǝɗa nofchengnǝm, paɗ tǝ thlǝr icha. ");
INSERT INTO bvw_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Nja hur sǝt kichu, mbǝssikǝnda shepiɗi a hur kapat hura'a Fara, nga tǝ ngomnofchǝwa, ndu thla hur'i'ndǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Funǝ Yahudawechǝsi a hachahai Asiya fichile naka mbǝnniyu, kandang kamkǝsi kǝ ɓanda mbanituwa ka muh hanharna, ma shundengnandǝsi kǝ faɗengna. ");
INSERT INTO bvw_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Mangakichuwa malamǝn nofchiya kǝ mbundǝ i mbǝssitǝndǝsi a fari thlartihi mbanitǝ fa sakmicha. ");
INSERT INTO bvw_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Manga kǝ ɗar i'ǝrtǝ mbwa'andi kish tǝ alchita fari thlartihi mbanitǝnandǝ ndatwa: \"Lenaka ɗar thlaata mǝmatcha, sǝk nati mbanitǝnuni ɓukweya.\" ");
INSERT INTO bvw_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felis paɗ nakǝn tǝ sakǝt sinnda kǝ ɗar mbanda Yǝso, thlaraǝn kandǝhi, ndakǝnwa: \"Sema ɓeɗ Lisiyas lǝmbanitǝ kwaɗǝn kani thlandǝ kiita engnunihi. ");
INSERT INTO bvw_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ndǝkǝn fǝrtǝ Felis shundǝ kǝ mbǝɗa kapat lǝthlǝrhwata Roma, kǝnna pu Bulus har, Paɗ kǝ fǝraɗǝ pwene oi wa, kǝ njaɗa shikechǝkǝn kǝ ɓanda mbǝɗ'enwa, ndu kǝ kǝssangndǝsuwa. ");
INSERT INTO bvw_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ɗiffitǝ hanmunchikǝn ɓaknda Felis tǝ nuhkǝn Durusila, lǝ Yahudawata, a thlǝnkǝn kǝ ɓa fichi tǝ Bulus, a kaǝn thlǝmmata kǝ ɗar shuwun kitchita Yǝso Kǝrǝsti. ");
INSERT INTO bvw_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Tǝrkaakǝ Bulussa fǝr sakǝtkǝn kǝ ɗar kitchitta, tǝ pǝɗa yah ǝnat alchitta fat hi, tǝ farǝ ɓahhi naka ɓatyu. Sǝkkǝn kichu kǝsang lechit Felis, ndangna Buluswa: \"Nakǝnya ngǝran'in. Ma mbisshi mbanda ni atsa.\" ");
INSERT INTO bvw_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Mǝlla ɗǝf hanɗǝkiketǝsuwa na Bulussa fǝraa hanɗǝɓǝlta, ndǝkǝn sǝknat Felissa nata atndǝ noknok kǝna shundǝ tǝndi. ");
INSERT INTO bvw_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Paɗ a ɗiffitǝ hurat chap, sǝk Fokiyus Festus kǝ ngomna kǝ kwar Felis. kǝthlǝm Felis mǝlla kat chiɗchiɗachita fwara mbanitǝ Yahudawecha, ndǝkǝn sǝk maltǝn Bulussa pursuna. ");
INSERT INTO bvw_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Ɗiffiti munndǝ mǝkkan, saakǝ Festus kǝthlǝm kǝ kǝssǝn tor ngomnachita, thlaakǝna Kaisariya pǝɗakna Urshelima. ");
INSERT INTO bvw_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Pǝktat Pǝristcha tǝ fa hǝmmbanita Yahudawecha, ɗǝknda muh hanhar Bulussa mbǝɗ'en. ");
INSERT INTO bvw_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Hwanangnda, kǝ ngǝrang fichi Bulus kǝ Urshelima, kǝthlǝm a tahsandǝhi wa nanda ɓǝllanda mbanda. ");
INSERT INTO bvw_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ngǝmang Festus ndakǝnwa: Ndif fichi Bulus hi a Kaisariya, njang tǝ i'ndengna nja tǝrtǝhurwa ni ɗǝtta mbǝnniyu hanmunchiya. ");
INSERT INTO bvw_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ɗǝkǝn ndatǝn paɗwa kǝthlǝm kichu, pǝktechengnuni kǝ ɓandǝ tǝnji, ma nifiya ǝnsǝ sǝttǝn nga keekewa, Kǝ ɓanda muh hanharkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Mbǝrawa mundǝhi foɗfoɗǝ ndu kum a mbǝɗengnandǝwa, ndǝkǝn ngǝrandǝn'ina Kaisariya. Ɓingngitkǝn sokǝnna mbǝt soktǝ'en i'kiita, thlǝnkǝn kǝ ɓa fichi tǝ Bulussa mbanitǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Kǝ ɓat Bulus, Yahudawechi ɓaka Urshelima thlaakǝnda taurangndǝhi, naknda ɓattǝ muh hanharengnandǝ oi kǝɗarkǝn, naknda cheka fǝra pwanchǝ kaǝn, ichi mbutǝnda ngunda mbǝla mbu kakatitǝkǝnwa. ");
INSERT INTO bvw_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paɗ Bulus hǝrkaǝn fat'en ndakǝnwa: \"Njang sawi ɓǝɓi'ǝn sakta Yahudawechuwa, tǝ paɗ sawi ɓǝɓi'ǝn kapat hura'a Farǝwa, paɗ sawi ɓǝɓi'ǝn Kaisarwa chika nguɗehwa. ");
INSERT INTO bvw_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Yahkǝ Festussa tǝraandǝ hanɗǝkiketa Yahudawechǝhi, sahaǝn mi Buluswa: \"Ndunu ngǝmtǝfa kǝ ɗǝna Urshelima kǝ sukǝ fichi kiitasa mbanitǝna kǝ ɗar ichiniyu. ");
INSERT INTO bvw_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ndak Bulus wa: \"Njang kitta mbanitǝ kiita Kaisar, a mbǝɗya kamkǝsi kǝ sikǝ fichi kiitasi. Sawi ɓǝɓi'ǝn Yahudawechiwa, sokǝnma shinnǝ kichu kaǝn. ");
INSERT INTO bvw_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ma njang la sǝk i kamuchiksi, paɗ mashiɗi ɓǝɓi'i saaka kǝ ɓǝllikǝ ficha, ngi cherifa kǝ ɓǝllikǝ fichǝwa. Paɗ manga kitchitsǝ kǝ ɗar muhhanhari nat nda muhta ɗarnǝwa, Paɗ nga nifǝsi na mbǝlla fǝrnja mbǝndengnandǝwa. Nja hwanda kǝ thla'ang fichi muh hanharengna mbanitǝ Kaisar. ");
INSERT INTO bvw_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ɗiffitǝ yarandǝ icha nda Festus hi tǝ fa sakmichi'en, ngǝmkǝn ndakǝnwa: \"Makichu hwanu kǝ thla'ang fichǝ hanhareku kǝ mbǝnitǝ Kaisar paɗ natu pǝɗata.\" ");
INSERT INTO bvw_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ɗiffitǝ hanmunchǝ ɗimek, Agiriffa kutura tǝ Banis ɓaknda Kaisariya kǝthlǝm kǝ sangndǝ marapa Festus. ");
INSERT INTO bvw_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Nakǝn nanda sǝt hanmunchǝ oi a mbǝnniyu, ndǝkǝn ɓat Festus tǝ shuwun Bulus kǝ mbǝɗa kutura. Festus ndakǝnwa: \"Nifǝsi malitǝ Felis hi a pursuna. ");
INSERT INTO bvw_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Thlahmbǝɗi nati a Urshelima pǝktat Pǝrischa tǝ fa mbanicha Yahudawecha ɓikǝndǝ muh hanhar nifiya, hwanikǝnnda kǝ thlang fichi kiitasi. ");
INSERT INTO bvw_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Paɗ ndayi kandǝwa, kanang Romawecha sǝnwanihi tǝ sa kiita le sǝk ɓǝɓi'ǝnwa, sema ɓeɗndǝtǝndi kǝ mbǝɗa fa muh hanharkǝn hwanitǝ tǝ hwanita, paɗ sema fǝraa fichi mbanda kǝthlǝm kǝ hǝrkaǝn i'ndi'en kǝ ɗar muh hanhari sǝt ficha. ");
INSERT INTO bvw_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kǝthlǝm kichu, ɓak nda mbǝɗya rǝmmǝ tǝ ndi, a sǝɓawi hanthlikǝnnaɗǝwa, ɓingnetkǝn sokki mbǝt soksakmiya, ɗǝfki ke ɓafichǝ tǝ nifǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Kǝ thlaatǝ fa muh hanharkǝn, ɓundǝ tǝ muh hanharkǝn kǝ ɗar ɓǝɓi i nati yarǝ kǝ ɗarkǝnwa. ");
INSERT INTO bvw_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Nakǝn shuwunchengnandǝsi le fǝruchit ndǝ kitsi kǝ ɗar Bulus, kǝ ɗar tǝr mbandengnanda, tǝ yunǝ wa Yǝso le mǝrka, Paɗ le thlartǝ Bulus tǝ alchitwa mǝllan tǝ shisshingtafa. ");
INSERT INTO bvw_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Njang paɗ mbahki i nati tausandǝ ichihiya, sahayi Bulus ndu nan ngǝmtǝfa kǝ ɗǝka Urshelima kǝsang fichǝ kiitasi kǝ ɗar ichiniyu. ");
INSERT INTO bvw_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Paɗ kak Bulus kǝthlarang fichǝ shundǝ'enhi, Kaisar kapat kutura kǝ thlaǝn kiita enhi, fǝrkǝn shunda kǝnna ficha pundǝhar kǝ fari nati thlǝnnda kǝ ndang ficha Kaisar. ");
INSERT INTO bvw_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agiriffa kutura ndangna Festus wa: \"Njang ma ni ɓata kathlǝmmata nifiya tǝ i'ndengna.\" Festus ndakǝnwa: \"Nu sǝkndǝ ishki. ");
INSERT INTO bvw_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Wendambǝta Agiriffa tǝ Banis yimkǝndǝsi tǝ mwanda witǝ i kuturcha, ɓak ndǝ tǝ pǝktat fa mbecha tǝ pǝktecha hǝmǝtkǝn. Fǝrkǝ Festus shundǝ tǝndatwa kǝ yimang fichǝ Bulus kǝ kǝttǝn sakmiya. ");
INSERT INTO bvw_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ndǝkǝn ndat Festuswa: \"Agiriffa kutura, nattǝ nofchi natǝm tǝ kandǝ rǝmma, a nifi ɓitǝ nofcha Yahudawechǝ hanharkǝn kǝ Urshelima, tǝ mbǝɗya paɗ, Kanda hwattǝ ndatwa Kammusǝ kǝ malfichi ndi tǝ shissingtǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Paɗ njang nuwi i sǝttǝn le saaka i ɓǝllandǝwa. Nakǝn paɗ mǝllan tǝ i'ndi'en keɗ tǝ ndatwa kǝ ngǝrang fichi kita'enna mbanitǝ lǝ mwandǝ Kaisar, ndakiwa ni thlindǝ tǝndǝ mbǝɗ'en. ");
INSERT INTO bvw_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Paɗ nga kakati tǝ shundǝsi nati yaranda kutura Roma lǝ mwandǝsǝwa. Kǝthlǝm ndǝkǝn ɓaki tǝ ndi kǝ mbanitǝnuni, kapatkǝnna mbanitǝwa sokǝn Agiriffa kutura, kǝthlǝm ɗiffitǝ usamihar ndu ni mbǝs i nati yarata ɗarkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kǝthlǝm njang a na ndengna, mbomchita kǝ thlǝn fichi hwan pursuna, nga tǝ cheɗ fichi ɓǝɓi ichi sǝtǝnwa.\" ");
INSERT INTO bvw_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Ndang Agiriffa Bulus wa: \"Fǝrrufichi mbanda ke hǝrkangnǝ i'ndeku.\" Thla'ang Bulus hara, tǝrkaakǝn shunda ndakǝnwa, ");
INSERT INTO bvw_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","A shiɗi sa'a, naki hǝrkandǝ i'ndengnǝ ɓukweya a mbanitǝ Agiriffa kutura kǝ yakat shuwunchi mbutǝ Yahudawechǝ kǝ ɗarna. ");
INSERT INTO bvw_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Sokkǝn lǝ mbǝrtǝ naku sǝn ǝ'nat sǝtta Yahudawecha tǝ ichi lanatnda halǝ'i'nda ɗarkǝn. kǝthlǝm kichu nja hwanuta kǝ kikǝnnǝ thlǝmmata tǝ kǝrǝsta. ");
INSERT INTO bvw_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Nat Yahudawecha shinndǝ witǝ soki sokti njang kǝ hwankimsha'a, thlata tǝrkakǝnna hǝmtengna paɗ tǝ Urshelima taakǝ ɓukweeya. ");
INSERT INTO bvw_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Shinndǝ nji kǝ soh, paɗ ma yehndǝsi nanda mbǝlla fǝr sheta ndatwa, naki hur humihi sherkǝ tǝ kuwur kus a hur tǝr mbandengnǝm, sokki kǝlǝ Farisiyawata. ");
INSERT INTO bvw_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Nakǝnya njang kitta mbanitǝnuni kǝthlǝm kǝ sikǝ fichi kiitasi kǝthlǝm ɗiffi hanɗkiketengna kǝ ɗar nǝhhata ɗǝf shuni fǝrandǝ Fara kakechinǝm. ");
INSERT INTO bvw_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ɗǝfshuwunkǝn naka kachitnǝm kumngǝrǝnsǝ chap ɗǝfkǝndǝsi mbah nanda nat nǝhatǝ'en, paɗ nak nda kǝn hursi tǝ kuwur Fara nda fiɗiktǝ tǝ fara. Sokǝn kutura, kǝthlǝm ɗiffi hanɗǝkiketa ɗar nǝhata ɗǝfshuniniyu, sǝk nat Yahudawecha tǝrimifa! ");
INSERT INTO bvw_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Mǝ sǝka a naɗengnuni ɓahwanatwa na Fara thla'andǝ mǝmatchǝwa? ");
INSERT INTO bvw_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Njang tǝ i'ndengnǝ soh kǝllayi nda keeke kǝ si ichǝ oi, kǝnji shunda Yǝso lǝ Nazaratta kǝ ɗǝka mban. ");
INSERT INTO bvw_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","I sǝti hacha a Urshelima, a mbishi alchita mbǝɗa pǝktat pǝrist cha, kǝthlǝm kǝ kuɓlayi fa tǝr mbandǝ oi kǝ pursuna. Tǝ Paɗ fari nat ficha ɓǝlandǝ kanda nja kuwur ɗiffitǝnanda. ");
INSERT INTO bvw_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Lafǝrayi pwancha kanda mbǝt humta Yahudawechihi lǝɗǝfki kandǝ kǝ shuwunndǝ ɓǝɓishundǝ kǝ ɗar thlǝm Yǝso. Kǝthlǝm lanaki kǝs komlǝ tǝ kandǝ kaǝn, lǝ naki kuwur kandǝ kǝ funǝ hǝmchǝ somsomǝn kǝni sa pwanchǝ kanda. ");
INSERT INTO bvw_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Ficha hur sǝtkichu, farǝle nja pǝɗata Dimaska, tǝ yahta pǝktat pǝristcha tǝ yarat ɗelwerti fǝritǝnda. ");
INSERT INTO bvw_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","A hur hwatfara mbanda, Sokǝn kutura kǝ nanǝhi, neɗi ɗwachita le sherangnga ɗwachita hwatfara, finkǝnna afshi taurikǝnhi njang tǝ shikechi witengna. ");
INSERT INTO bvw_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Uffani hǝmkanihi hachahaya, Sǝkki ɓurata nditǝ tǝ mi Ibraniyanci, 'Shawulu, 'Shawulu, Kǝthlǝmmi natu fǝri pwancha? Nanna fǝra pwene i'ndeku tǝ sǝt atikrechit tǝ nji.' ");
INSERT INTO bvw_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ndakiwa, 'Wunnaku Lǝmwanda? \"Ndikǝ Lǝmwandǝwa, 'Njang Yǝso le natu fǝrapwancha. ");
INSERT INTO bvw_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Paɗ thla'u kǝ thlarnǝhi kit. Cheɗki fandengna mbǝɗeku kǝ ɗǝffisa kǝllasi tora, paɗ kǝ fǝrnǝ sheta kǝ ichi natu kǝ ɗarna, paɗ tǝ ichi nati cheɗutǝ kǝ mban. ");
INSERT INTO bvw_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ni hǝrkuta mbǝnda nofcheku tǝ punochǝ paɗ. Ni thlinsa mbǝɗa punofchǝkǝn, ");
INSERT INTO bvw_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Kǝthlǝm kǝ i'nangnǝ hwanichengnaɗǝhi, Kǝ tǝɓǝrndǝhi a hulta kǝ ɗwachitta, paɗ tǝ thlata alchita sheɗan kǝ alchita Fara, tǝ kichu nannda mbǝskaɓiɗi ɗar ɓǝɓichitfecha, tǝ mbǝs'ǝnhar nat tǝ fichile sokkǝ chiɗchiɗ kǝthlǝm a firndǝ kit kǝ mbǝɗengna. ");
INSERT INTO bvw_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Kǝthlǝm kichu, sokǝn Agiriffa kutura, a cherwi kǝ fǝrayi mwanda ǝnnda sǝnnatǝwa ɓaka haiya afshi kǝ mbǝɗengna. ");
INSERT INTO bvw_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Tǝrkaaki ɓasanda nofchisa Dimaska, kani sanda nofchǝsa Urshelima chika ayi a thlet hǝmmǝt Yahudawecha, sayi punofchǝsǝ paɗ, ndatwa kǝ tǝrɗǝhi kǝ tǝmǝrɗǝhi kǝ mbǝɗa Fara, kǝ sǝndǝ ichi nachetǝwa tirɗǝhi. ");
INSERT INTO bvw_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ndǝkǝn sǝk kǝssitǝ Yahudawecha a kapat hura'a Fara, naknda kat kǝ ɓǝllikǝnnda. ");
INSERT INTO bvw_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Paɗ kǝssikǝ Farǝsi kǝ nakǝnya, ndǝkǝn nati mbǝɗya kǝni fǝr sheta kǝ ɓǝɗa pǝktecha tǝ hwecha. Nga ǝnsomǝn nati mbutuwa, se i nat Tapǝnnecha tǝ Musa ndatndǝwa nan sǝta, ");
INSERT INTO bvw_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Keekesi Kǝrǝsti kǝ san pwane, kǝ sokka tǝrka thlata mǝmatcha, Kǝthlǝm kǝ ɓan tǝ ɗwachitta mbaɗa nofcha, Yahudawecha tǝ punofchǝ nat.\" ");
INSERT INTO bvw_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Bulussa ɗar hǝrkandǝ fat'en Festus thlaǝn ɓurat tǝ alchita ndakǝnwa: \"Bulus, luwurchǝ naka tǝrutǝwa! Yakat changngandeku tǝb'raɗǝ i'ndekuhi!\" ");
INSERT INTO bvw_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ndak Bulus paɗwa: \"Festus lǝmwanda, nga luwurchǝtǝrikǝwa. Kit nati mbuta a hur i'nda. ");
INSERT INTO bvw_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Paɗ kutura shintǝ ichi natya, lǝ naki shunandǝ lechitfǝwa. A shinisǝwa kileesa ichini natyu, kǝthlǝm nga ɓuɓweetǝ sǝt fichiwa. ");
INSERT INTO bvw_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Agiriffa kutura, a firnǝ kit tǝ Tapǝnnecha? A shiniwa firnǝ kit.\" ");
INSERT INTO bvw_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ndang Agiriffa Bulus wa: \"A hur hanthlikchi ɗimekya yahtusa lǝmnji kǝsi Kǝrǝsta?\" ");
INSERT INTO bvw_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Bulus paɗ ndakǝnwa: \"Chika hanthlikchǝ ɗimek, ndu njang ndu nga njangwa nja hwandǝ tǝ ndatwa kǝɗǝf Fara mǝniɗa sokǝn ɗengwa, nat tǝ fichile naka sǝknji ɓukweya, kǝnandǝ nda i'nati, nga nat tǝ chalalotiyawa.\" ");
INSERT INTO bvw_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Thlaakǝ kutura, kichu paɗ ngomna tǝ Banis tǝ fichile natndǝ ɗǝndassa mbǝt ǝrta. ");
INSERT INTO bvw_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Cheknda kishsha mbǝt kiita ndangnda ndaniwa: \"Nifiya sutǝ i'kamkǝsi kǝkuɓlang fichǝwa, ndu kǝ ɓǝlang fichǝwa.\" ");
INSERT INTO bvw_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ndang Agiriffa Festus wa: \"Ma nga i'nakǝn nifiya thla'a ɗǝ muh hanhar'enna ɓanitǝ Kaisar wa, ma kǝ kalfichǝndǝhi.\" ");
INSERT INTO bvw_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Kǝ tahsandǝ fichi kanihi hur kommbawal kǝ thlaani kǝ thlet hǝmmǝt Italiya, Ndekǝn fǝrtǝɗǝ Bulus tǝ funǝ hwanchǝ pursunacha a hara kapat lǝthlǝrhwata Roma le nat thlǝmkǝnwa Yuliyus, ǝrta hurfa thlǝrhwatkǝna Kaisar Augustus. ");
INSERT INTO bvw_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Yimkani kommbawal tǝ le i Adiramitiyum, le tahǝskǝ thlaata kǝ thlet hǝmchi naka kǝllarǝ Asiya, Tǝrkaakani wita. Aristarkus lǝ Tasalonikata i hachahai Makidoniya, mǝllan tǝkǝm. ");
INSERT INTO bvw_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ɓingǝtkǝn kana Sidon. Yuliyus chendaǝn kafata Bulus, kǝ ɗǝka nat shikechikǝn, kǝ kǝssangndǝsi. ");
INSERT INTO bvw_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Thlaakani mbǝɗya hur kommbawal nak rǝnna'a ɓahhandǝ kani. Kǝthlǝm ndǝkǝn ɗǝkani tǝ ɗiffitǝ tingring Sayifurus mbǝɗi nguchit rǝnnaa tǝ alchitsi. ");
INSERT INTO bvw_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ɗiffitǝ cheɗǝngnanikishsha hawurkǝn le nak nduk tǝ hachahai Kilikiya tǝ Famfiliya, Saakani Mira hachahai Likiya. ");
INSERT INTO bvw_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","A mbǝnniyu kapat lǝ thlǝrhwata Romawecha mbǝskǝn kommbawalla Alekzandariya lǝ ɗǝta hachahai Italiya, Sikǝnkani hurkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Sǝkani mundǝ tǝ muncha kweekani nata witǝ hǝɓakka, tǝ kweetǝ saatani nduk kǝ hǝmǝt Kinidus. Kǝ njandǝ rǝna'a kani ɗǝta mban, Kuwurkani tǝ kǝllar tǝ mbǝɗi nguchit rǝnnasi, tǝ ɗiffitǝ tingring Kirit nduk tǝ Salmoni. ");
INSERT INTO bvw_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Nakani kwee mbǝrandǝhi, kǝ mbǝɗi lǝ atfichiwa Kwescha mbǝt thlara kammbawalcha, nduk tǝ hǝmǝt Lasiya. ");
INSERT INTO bvw_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nakǝn sǝɓafichi hanthlikchaɗi oi, wikǝn paɗ sokkǝn tǝ mboro, kǝthlǝm a hanthlikchiniyu shiɗ hurat langnga har kǝ farǝ kǝr kwisshimta i farǝ ɓǝɓichitfata mbirhi. Tiɗɗang Bulus thlǝmmechengnanda. ");
INSERT INTO bvw_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Ndangna kandǝwa: \"Shisshingchengnuni kǝ sǝn tolla, Kǝllaɗi wiiya nannat tǝ mboro paɗ tǝ kuɓat ichi oi, nga kuɓat icha kommbawal ndengwa nat tǝ Shisshingchengnǝm.\" ");
INSERT INTO bvw_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Kapat lǝthǝrhwatkǝn ngǝmaǝn tǝ i mbutǝ Buluswa, Kǝthlǝm kichu kan thlǝmata shunda lǝ koharǝ kommbawaltǝkǝn paɗ tǝlǝ kommbawal tǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Nakǝn mbǝt ngomta kommbawalcha Lasiya su keeke kǝ sok kommbawalchi fekta mbǝɗyawa, nakǝn yakat funengnani ngǝmkǝndǝfa kǝ ɗaficha mban tǝ wita, Paɗ kǝ kweefichihi kǝ saa ficha Finiks manan sǝtta, kǝthlǝm kǝ sokɗǝ fekta mbǝnniyu. Finiks mbǝt humta kommbawalchihi a chicheng Kirit le naka kǝllaɗǝ kukuwun hishingta tǝ mbǝt hǝmfara, paɗ tǝ kukuwun harsǝmta tǝ mbǝt hǝmfara. ");
INSERT INTO bvw_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Tǝrkaakǝ rǝnnaa thlata tǝ kukkuwun harsǝmtǝ ngunngundeh, saǝn nofchifiyuwa nanda mbǝlla sǝt i naka handǝkikechengnanda, kahangndǝ tǝppasiɗǝ kǝskǝ kommbawal tǝkǝn har, kuwurkǝndǝ tǝ chicheng Kirit, nduk tǝ mi hawurta. ");
INSERT INTO bvw_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Su tolluwa ɓak kapat rǝnna'a tǝ kukuwun harsǝmta tǝ mbǝt chet fara, thlaakǝ rǝnnǝkǝna tingringta. ");
INSERT INTO bvw_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Kǝtǝptǝ rǝnnikǝn kommbawaltǝkǝn, hulangna kǝllaɗǝ rǝnnikǝn, ndǝkǝn malandani nak rǝnnikǝna pǝkkani. ");
INSERT INTO bvw_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Kuwurkani tǝ ɗiffitǝ hantingringta le nat thlǝmkǝnwa Kauda, mbǝɗi tahtǝ alchita rǝnnahi, kweekani kahhandǝ kommbawal tǝkǝn ka ɗǝfta mi chichengta. ");
INSERT INTO bvw_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ɗiffitǝ kahhandǝ hwan kommbawal tǝkǝn kǝ hur kapat kommbawaltǝkǝn, ɗathlkǝnda kǝnang ndǝhi kǝffa kapat kommbawaltǝkǝn kǝthlǝm mǝninda fǝffathlaɗi. Tǝrangndǝ kuwurta kommbawaltǝkǝnna haya mbah na rǝnna'a njek nda kǝllar kǝthlǝm mbǝlla'undǝ koharǝkǝnwa, sǝkndǝ kichu kǝthlǝm kanda lechita mǝniɗa muh kanda hansohhi Sirtis lela mǝhɗang ichi uf. ");
INSERT INTO bvw_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kǝthlǝm rǝnnikǝna ɓahandǝkandǝ kaǝn, ɓingǝtkǝn tǝrkaakǝndǝ harandǝ ichihaya hur kommbawaltǝkǝn, somkǝnnda hur ama. ");
INSERT INTO bvw_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","A farǝ mǝkkatǝkǝn kandang tǝ harchengnanda sommangndǝ ǝnat tor kommbawalchikǝnnaɗi. ");
INSERT INTO bvw_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kǝ sǝtani munchǝ oi nuwani farǝ tǝ hanndǝrechuwa, paɗ kapat ɗǝf er tǝ rǝnna'a nakna tǝppandakani, kǝtangani hanɗǝkiketakish tǝ ndatwa ngani hǝrǝktǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nakǝn mwinndǝhi sǝmunɗǝ ɗǝsǝmtǝwa, thlaakǝ Bulus kit a hurnanda, ndakǝnwa: \"Nofcha, mamashikuni shundengna, tǝndatwa mǝ thla'iɗuni a tingring Kiritwa, ma hǝmwuni hur mboro tǝ kuɓat'ichiyawa. ");
INSERT INTO bvw_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Nakǝnya nja kahhandǝ thlemaɗengnuni sam alchit fata, kǝthlǝm nga yunǝsǝ nasǝt mboro tǝ shisshingtǝ'ena hurnuniwa, kommbawaltǝkǝn natficha sǝt mboro tǝkǝn ndak. ");
INSERT INTO bvw_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kǝthlǝm a fiɗiki ɓǝraayu mala'ika Fara le nati kǝ'ikǝn nati mwananda, thlarkǝn nduk tǝ nji, ");
INSERT INTO bvw_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ndakǝnwa: \"Buluswa, mǝlechinuwa. Sokǝn waat kǝthlarna mbanitǝ kaisar. Andiya paɗ tǝmbǝnda kafata Fara nan hǝrkandǝ shikechǝ witeku.\" ");
INSERT INTO bvw_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Kǝthlǝm ndǝkǝn sam alchitafa kunang nofcha, kǝthlǝm firikit kǝ mbǝnda Farǝ tǝndatwa i'mbwi'itǝfichǝyu, nakna nat kichu. ");
INSERT INTO bvw_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Sokkǝn waat kǝ muhang rǝnnaa kǝmmaɗi kǝ ɗar hansohi tingring le.\" ");
INSERT INTO bvw_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","A fiɗik kumgǝrǝnsǝ fwaɗa tǝkǝn, nak nda njekkani a hawur Meditereniya. A ɗarfiɗikta fa koharǝ kummbawaltǝkǝn tǝrkǝndǝwa nakani nduk tǝ hachahaya. ");
INSERT INTO bvw_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Kikeɗangndǝ hwengngǝchitta amkǝn, mbǝssangndǝ a shee ishtǝ sarǝ aru tǝ kumchitchap. Ɗǝkkani mban kuɗeh ngǝrkǝnda kikeɗanda, mbǝskǝndǝ ishtǝ sarǝ kumchit hanherta. ");
INSERT INTO bvw_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Kǝthlǝm rahlechita mǝɗi kommbawal egnani kuk ngwichǝwa, kalkǝndǝ ǝnnat thlarandǝ kommbawaltǝkǝn hi fichile nak lǝklǝk fwaɗa, tǝ ɗǝffitǝ kommbawaltǝkǝn kǝthlǝm kǝ njaǝnwita. Hwankǝndǝ Fara kǝthlǝm kǝ wenmbǝt leɗleɗ. ");
INSERT INTO bvw_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Paɗ fa koharǝ kommbawaltǝkǝn kakndǝ mba hǝrǝkta. Tǝrangndǝ hwan kummbawaltǝkǝnna haya naknda sǝt ɗathla nda nanda tǝrandǝ tǝppasi hai lǝklǝkyu kǝ mbanitǝ kapat kommbawaltǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ndǝkǝn ndandǝ Bulussa kapat lǝthlǝrhwatkǝna Roma tǝ fathlǝrhwechǝkǝnwa: \"Ma thlaru nofchihiya hur kommbawaltiyawa, nga mbandǝsǝ natuni hǝrǝktǝwa.\" ");
INSERT INTO bvw_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Thlithlang fa thlǝrhwatkǝn sahǝt hwan kommbawal tǝkǝnaɗi kalkǝndǝhi kǝ pǝɗaka ɗar ama. ");
INSERT INTO bvw_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kǝ nat mbǝt nduk wenda, hwanang Bulus kandǝwa kǝ sǝmndǝ ɗǝsǝmta ndakǝnwa: \"Ɓukweya mundǝ kumngǝrǝnsǝ fwaɗa kuna puta, sǝmwuni ǝnwa. ");
INSERT INTO bvw_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Kǝthlǝm ndǝkǝn nja hwanandǝkuni kǝ sǝmmuni ɗǝsǝmta kǝthlem ngwalngwalchit faɗengnuni paɗ yunǝsa hurnuni na mɓah hwasǝ'en chika ǝrtǝwa.\" ");
INSERT INTO bvw_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Kǝ mbutǝn kichu, tǝrkǝn njohma saǝn usoko Fara a mbanitǝnanda chichaǝnhi tǝrkaakǝn chiita. ");
INSERT INTO bvw_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Natnda mbǝskǝndǝ alchit sǝmɗǝsǝmta. ");
INSERT INTO bvw_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Uffani hur kommbawaltǝkǝn nakani nifǝ aru kumkum chap tǝ kumchit muɗ ngǝrǝnsǝ tehethl (276). ");
INSERT INTO bvw_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kǝ sǝmtǝnda ngelnda, tahhandǝ lǝkta kommbawaltǝkǝnhi, naknda som alkama hur ama. ");
INSERT INTO bvw_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kǝ wentǝmbǝta, fa koharǝ kommbawaltǝkǝn mbǝsaundǝ furuɗi nanndǝwa, mbǝtsi nguɗuk tǝ hansohitǝsi. Tahaskǝndǝfa kǝ ɗǝndǝ tǝ kommbawaltǝkǝnna ɗar hansohikǝn manansǝta. ");
INSERT INTO bvw_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Thlithlang ndǝ sahǝt tǝppaskǝnaɗǝ malkǝnda hur ama. Chatkichu paɗyu nangnda kwasandǝ sahchǝkǝnhi a fa i latǝprang kommbawaltǝkǝnhi. Thla'angndǝ kuwurchi naka kommbawaltǝkǝn keeke tǝ mbayi natrǝnnaa njekanda mban ɗǝffanndǝ innda kǝlarǝ hawurkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Kǝ saatani mbǝtkǝmta ama, tǝpkǝ kommbawaltǝkǝn hansohita yimkǝ'innda kommbawaltǝkǝna hur hansohikǝn mbǝlla'utǝ hǝhǝrtǝfuwa. Tǝrkaakǝ kommbawaltǝkǝn fǝfathlǝɗi tǝ ɗiffi kǝthlǝm rahha'a. ");
INSERT INTO bvw_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Tahǝskǝ fathlǝrhwatkǝnfa kǝthlǝm kǝ ɓǝllangndǝ pursunechǝkǝn, mǝni yuneng nanda kun'ngoftǝ kǝ hǝrkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Nakǝn kapat lǝthlǝrhwatkǝnna Roma yehsa hǝrkandǝ Bulus, njangnakanda. Fǝrkǝn shundǝ tǝ alchita ndatwa: \"Nat fichile mbǝrkǝ ama kǝ pǝparnda hurkǝn kǝ chang ndǝ kǝ mi chicheng le.\" ");
INSERT INTO bvw_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Tahhǝt pursunachǝkǝn kǝ tǝrnda ɗar chichet afchǝkǝn ndu hur chichet kommbawaltǝkǝn. Tǝkichu chetndakish kǝ mi chichengkǝn ngwalngwal. ");
INSERT INTO bvw_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ɗiffitǝ hǝrǝktengnani, sǝkaniwa, awi thlǝm tingringǝyuwa Malta. ");
INSERT INTO bvw_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Nofchi mbǝnniyu cheɗangdǝkafata kani kaǝn. Thlǝkndǝ kani natani, njihangndǝ hwatakani kǝthlǝm ersi paɗ mbitǝsi. ");
INSERT INTO bvw_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Ngomkǝ Bulus afcha nakna sǝtta hwaɗiyu, chek hwithlnda kissha hur hwaɗiyu lenat yethaftǝ'en thlerthler, njo'aǝn hara Bulus. ");
INSERT INTO bvw_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Kǝ nat nofchi naka mbǝnniyu hwithlinkǝnna hǝhhǝrtǝfa hara Bulus wangarra, ndangnda ndaniwa: \"Kitchitkǝn nifiya lǝɓǝlfatanakǝn! Andiya, chikanakǝn hirikka hurhawurta, nattǝkichu alhaki enna kuwurndi nan mǝrta. ");
INSERT INTO bvw_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Bulus paɗ saktaǝn har'en muhaǝn hwithinkǝnna hur hwata, mbǝsutǝ ndinditwa. ");
INSERT INTO bvw_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Naǝn kandǝhiwa nan hǝthlta ndu kǝ hǝmǝnhi chat kǝ mǝrrǝn, sǝkndǝ tolla nunda saǝnwa, ngǝrkǝndǝ yarǝtǝ ndatwa mǝllan witǝ farǝ mǝ nakǝn. ");
INSERT INTO bvw_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","A mbǝɗǝ ndukya mbichisi i lǝ mbani tingringkǝn lǝ at fichiwa, Fubiliyus. Mǝllan thlǝk kani, fǝraǝn mbǝt munda kani ndiichin, kǝllakndǝsa kani, i'mundǝ mǝkkan. ");
INSERT INTO bvw_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Shin Fubiliyus nduk tǝ hafat kakǝnnda tǝ i ɗǝlǝhta. Yimkǝ Bulussa thlǝmatken hwanaǝnsi, ɗǝffaǝn hara in, kǝnkǝ nifǝkǝnaɗi. ");
INSERT INTO bvw_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Paɗ kǝ sǝkǝn kichu, nat tahǝt haacha fichile naka thlet tingringǝniyu naknda ɓata nak ficha kǝnandǝ kandaɗi. ");
INSERT INTO bvw_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Fǝrangndǝ poffǝna kani oi. Nakani thlata kommbawal tǝkǝn, ngomangndǝ icha kani lenatani yahta. ");
INSERT INTO bvw_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ɗiffitǝ ndǝraa mǝkkan, thlaakani a tingring Malta hur kommbawal Alekzandiriya le tumbang fekta tingringkǝn. Tahsa fichi mirshing mǝhɗat hwanmanchisi nda farǝcha. ");
INSERT INTO bvw_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Ɓakani Sirakus munkani mǝkkanna mbǝnniyu. ");
INSERT INTO bvw_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","A mbǝɗya paɗ pǝɗakani kǝ Rikiyum. Ɗiffitǝ mundǝ ǝrta, thlaakǝ rǝnnǝ kukuwun harsǝmta, Wendambǝt paɗ saakani Futiyoli. ");
INSERT INTO bvw_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","A mbǝnniyu kǝmkani tǝ hwanmancha fa fǝrkit, hwanangndǝ kani kǝ sani mundǝ muɗ tǝ kanda. Tǝ kichu saatani Roma. ");
INSERT INTO bvw_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kǝ sǝktǝ fa tǝrmbanda Roma kusengnani, ɓaknda sa marapa kani a lumo Affiyus, tǝ paɗ mbǝndi la ndat fichiwa mbǝt tǝrtahai Mǝkkan. Nak Bulus kanda saǝn usoko Fara, ngǝrkǝn mbǝs alchitafa. ");
INSERT INTO bvw_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Kǝ yimtani Roma ngǝmang ficha Bulus si kǝɗa sokta a huri haiya rǝmmǝ tǝ lǝ thlǝrwhaɗi naka pundǝhar. ");
INSERT INTO bvw_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ɗiffitǝ mundǝ mǝkkan, Bulus akǝn pǝktat Yahudawecha ngomkǝndǝhi ndǝkǝn ndandǝna kandǝwa: \"Kunang hwanmancha, chika nakǝn sawi ɓǝɓi'ǝn nofchengnǝmwa, ndu ɓǝɓi'ǝn i tǝrmbanda kakechengnǝm, nat tǝ kichu a kǝssi ficha a Urshelima fǝrkǝfichi nji kǝ Roma kǝkǝnnikǝnda. ");
INSERT INTO bvw_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Kandang paɗ kǝ usitǝndǝmihar, Yahkǝndǝsi kǝ kalndǝ njihi, kǝthlǝm mbǝsiwundǝ tǝ ɓǝɓi'ǝn le saaka ɓǝllitǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Paɗ cherkǝ Yahudawechi ngǝmtǝfa, ɓakna soktǝ waat kǝ tǝrayi muh hanharengna mbanitǝ Kaisar, chikanakǝn ngatǝni muh hanhar nofchengnǝmwa. ");
INSERT INTO bvw_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ndǝkǝn sǝk kati kǝ nikuni, paɗ kǝ yaraam ichihi tǝ kuni, kǝthlǝm le ndǝftǝ Isra'ilawechǝ hanndǝkiketa natnda pu'ɓat'en sǝk kǝnitificha tǝ chalalocha.\" ");
INSERT INTO bvw_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ndǝkǝn ndaɗǝɗǝwa: \"Kanang mbǝswani yarat ndelwer a thlet hǝmǝt Yahudiya kǝ ɗarwuwa, nga yunǝ hwanmananisi ɓak tǝ kushengwuwa ndu kǝ mbu'un ɓǝɓi shunda ɗarwuwa. ");
INSERT INTO bvw_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Paɗ yahkanisi kǝ sǝkani yareku amiyeku, kǝthlǝm i sǝntani, yuwa humǝhi i lekiyu chikawuni mǝla shuwun ɓǝɓi icha ɗarkǝn. ");
INSERT INTO bvw_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ɗǝfkǝndǝ fari natnda humtǝhi tǝ Bulus, ndǝkǝn ɓatnda mbǝt tǝrtǝ'enahaya, ɓakndǝ kaǝn. Thlata ɓingta kǝ farǝhufta mǝlla mwa'anda kanda tǝ sǝna kuturichita Fara kandǝsi, nakna kweetǝhi kǝ kahǝn kanda ɓǝɗa Yǝso tǝ mba sakanda Musaɗi tǝ ɗelwercha Tapǝnecha. ");
INSERT INTO bvw_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Funa ngǝmmangndǝ i mbutǝn, funa paɗ cherkǝndǝ fǝrkitsi. ");
INSERT INTO bvw_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Kǝthlǝm kichu halǝ'indǝsa thlerǝnanda. Naknda malǝ mbǝnnihiyu shunang Bulus kandǝ ǝrta ndatwa: \"Awi Shemeɗ Chiɗchiɗ mbwitǝ kit, Shunandǝn kakechinuni tǝ miya tapǝnaa Ishaya ndatwa: ");
INSERT INTO bvw_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"Ɗu mbǝnda nofchiya, kǝ ndangna kandǝwa, Sǝkta, nuni nata sǝkta, Paɗ nguni sǝndǝwa, Nat paɗ nuninatanata, nguni mbǝssandǝwa. ");
INSERT INTO bvw_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Kǝthlǝm hanndǝkiketa nofchiya shiɗ kwaakwaa, resh thlǝmechengnandaɗi, ngǝlangndǝ hwanichengnanda, kǝthlǝm mǝ nindǝ tǝ hwanichengnandǝwa kǝ sǝkndǝ paɗ tǝ thlǝmechengnanda, kǝ mbǝsangndǝ tǝ hanɗǝkikechengnanda, kǝ tǝɓǝrndǝhi mbǝɗengna kǝ kǝnayi kanda ɗi. ");
INSERT INTO bvw_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Paɗ, kǝ sǝnuniwa, Fara a thlintǝ kuseng hǝrǝkta kǝ mbǝnda punofcha. Kandang paɗ nanda kat thlǝmatsi. ");
INSERT INTO bvw_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Kǝ mbukǝn kichu, thlaakǝ Yahudawecha mbǝnniyu tǝ halǝ'indǝ kaǝn a hurɗiffitǝnanda. ");
INSERT INTO bvw_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Bulus sokǝna huriini natna kwandǝyu hurat chap mǝlla thlǝt fichile ɓaka mbǝɗ'en. ");
INSERT INTO bvw_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Nakǝn njawundǝ ɓasǝwa, nakna ɓasǝ kuturichita Fara, nakna sakandaɗi kǝ ɗar Lǝmwandǝ Yǝso Kǝrǝsti nga lechitsuwa.");
INSERT INTO bvw_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Yarat ɗelwertiya ɓakna mbǝɗengna njang Bulus, at Fara tǝ ngǝmtǝ'en kǝ naka lǝthlǝnda Yǝso Kǝrǝsti. Paɗ yaraki ɗelwertiya tǝ hwanmanǝm Sastanis. ");
INSERT INTO bvw_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Nakani yarat ɗelwertiya kǝ ɓǝɗa fa tǝrmbanda Fara hur Korinti, tǝ mbǝɗa fichile taɗtǝ fichihar a hur Yǝso Kǝrǝsti, atfichǝ kandǝ kǝnandǝ chiɗchiɗ, nat tǝ fichile chika ayi la ak thlǝm Lǝmwaɗengnǝm Yǝso kǝrǝsti, Lǝmwaɗengnanda tǝ inǝm: ");
INSERT INTO bvw_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Kafata tǝ yuyurchita mbǝɗa Shinnǝm Fara tǝ Lǝmwaɗengnǝm, Yǝso Kǝrǝsti kǝ mbǝɗengnuni. ");
INSERT INTO bvw_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Kǝnding la naki sandǝ Farǝ usoko kǝthlǝm kunang, kǝthlǝm kafaɗi Farǝ fǝrandǝna kuni tǝ mbǝɗa Kǝrǝsti Yǝso. ");
INSERT INTO bvw_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Chika tǝ mba yeni fǝraɗǝ hurmichita kuni a fat'en, hur shuwunchengnuni tǝ sǝn'ǝn paɗ nat, ");
INSERT INTO bvw_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","kǝthlǝm ɓeɗ ficha mbǝsandǝ sheta engnani kǝ ɗar Kǝrǝsti a hurnuni. ");
INSERT INTO bvw_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Kǝthlǝm ndǝkǝn ɓahwuni chika witǝ fǝr shemeɗ muwa, nda i natuni ɗǝf hwanita ɓata Lǝmwaɗengnǝm Yǝso Kǝrǝsti; ");
INSERT INTO bvw_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Le na kǝskunihar tǝ alchita kǝ mweshitkǝn, kǝthlǝm kǝ sokuni nga fa chithansarǝhiwa a farǝ ɓata Lǝmwaɗengnǝm Yǝso Kǝrǝsti. ");
INSERT INTO bvw_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Fara, lǝ nǝhɗandǝ ɗǝfshundǝhi mǝlan ak kuni kǝnuni ɓweet tǝ hwe'en Yǝso Kǝrǝsti Lǝmwandengnǝm. ");
INSERT INTO bvw_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Hwanaɗi kuni, hwanmancha, a hur thlǝm Lǝmwaɗengnǝm Yǝso Kǝrǝsti ndatwa: \"Natuni kǝ ngǝmuni tǝ ndani mǝni saktǝhi sa hurnuniwa, kǝ humangnguni inda kǝna yarengnuni ǝrta, hanndǝkikechengnuni paɗ ǝrta.\" ");
INSERT INTO bvw_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Hwanmanchina mbu'i nofchi hura'a Kuluwi yu, ndatwa mbatsa thlerǝnuni. ");
INSERT INTO bvw_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","I nati yarǝ ndatwa, chika wuna hurnuni mǝla mbu ǝn somǝn, ndatwa: \"Njang i Bulus, \"Yuna ndatwa, \"Njang i Afolos, \"Yunǝ paɗwa, \"Njang i Kefas, \"Yunǝwa\" Njang i Kǝrǝsti.\" ");
INSERT INTO bvw_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Awi a shek Kǝrǝsti hiwa? Ndu Bulus kukwandǝfichihi kǝthlǝm kunang? Ndu sang fichi baptisma kuni hur thlǝm Bulus? ");
INSERT INTO bvw_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Saɗi Farǝ usoko sawi baptisma yuna hurnuniwa, nda Kirisbus tǝ Gayus ndak sandi kanda, ");
INSERT INTO bvw_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Kǝthlǝm ndǝkǝn yunǝsǝ na ndatwa sangfichi baptisma hur Thlǝmnǝwa. ");
INSERT INTO bvw_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Kit a saɗi baptisma nofchi hura'a Istifanus. Ɗifitǝ ndǝkǝn kuɗukwi ndu saɗi baptisma yunǝ paɗwa. ");
INSERT INTO bvw_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Thlǝnu Kǝrǝsti njiwa kǝ si baptisma wa, paɗ kǝ ɓassi laulawata nga tǝ mbǝr sǝn'ǝna nifǝwa, kǝthlǝm mǝ sǝɓa fichi alchit palita Kǝrǝsti ɗǝwa. ");
INSERT INTO bvw_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Pathla palita ɓomchita mbǝɗa fichile naka mba thlǝrǝttaɗi, paɗ kǝ mbǝɗengnani kanang ti hǝrǝkka alchita Fara. ");
INSERT INTO bvw_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Kǝthlǝm yara fichǝhi ndatwa: \"Ni wuwelandǝ sǝn'ǝna lǝ sǝnda ɗi, kǝ sayi ɗathla lǝ ɗathlaɗi kǝ'ǝn pofǝn.\" ");
INSERT INTO bvw_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","A ai fa ɗathla? A ai fa sǝn'icha? A ai fa halǝ'inda kisshi'iya? A chawu Fara kishwa ɗathla kisshi'iya ɓomchitwowa? ");
INSERT INTO bvw_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Sokkǝn a hur ɗathla Fara, sǝnu kisshitǝ Farǝ tǝ mbanda ɗathlǝ'enwa, mbǝnangna Farǝ fa kǝ hǝrkaǝn fichile fǝrkǝkit, tǝ mbǝɗa ɓomchit ɓassǝ laulawatkǝn. ");
INSERT INTO bvw_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Keɗ Yahudawechǝ kǝ nandǝ sakǝtkǝn, Helenawecha naknda kat ɗathla, ");
INSERT INTO bvw_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","kanang kana ɓassǝ Kǝrǝsti kukwandǝ fichǝhi, i sokka ǝnat chithansarǝhi mbǝɗa Yahudawecha, ɓomchit paɗɗaa mbǝɗa punofcha, ");
INSERT INTO bvw_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","A nakǝn mbǝɗa fichile at Fara, ndu Yahudawecha ndu Helenawecha nat hwaa, Kǝrǝsti alchita Fara tǝ ɗathla Fara. ");
INSERT INTO bvw_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Kǝthlǝm i tǝrtǝ fichǝwa shiɗ Farǝ ɓomchita, sheraɗa ɗathla nifa, paɗ ɓah alchita Fara, sheraɗa alchita nifa. ");
INSERT INTO bvw_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Hwanmancha yaramǝn naɗengnunihi fari at fichi kuni. Nga terchǝnuni nak tǝ sǝn'ǝn witǝ i nifǝwa; nga terchin nak tǝ mwandǝwa, paɗ nga terchin ngǝttǝ fichǝ nda kuturchǝwa. ");
INSERT INTO bvw_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Farǝ taɗkǝn i har naka ɓomchita kish, kǝthlǝm kǝ harangfat fa ɗathla, taɗkǝ Farǝ i nak ɓukɓukka hur kisshita kǝ harangfat fa alchita. ");
INSERT INTO bvw_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Taɗkǝ Farǝ ǝnat kuɓanda fata tǝ i njirtǝ kisshita nat tǝ ichi nguchǝksi kǝthlǝm i la nat nofcha tǝrtǝwa ndiichin kǝ saǝn nga'ǝnwa. ");
INSERT INTO bvw_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Nat ichiniyu, sǝkǝn kǝthlǝm mǝ tǝri nifǝ tǝ hwasa'inwa ǝn nakǝn a mbanitǝ Farǝ wa. ");
INSERT INTO bvw_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Farǝ sǝka natuni hur Yǝso Kǝrǝsti, le sokka ɗathlengnǝmma mbǝɗa Fara, mǝllan sokka fǝrkit engnǝm, chiɗchiɗchita tǝ hǝrǝktengnǝm. ");
INSERT INTO bvw_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Kǝthlǝm ndǝkǝn nda i natna hur yaratkǝn: \"Chikawun na thla'a'ndǝ inda kǝ thla'angka hur Lǝmwanda.\" ");
INSERT INTO bvw_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Hwanmancha, ma ɓeɗi mbǝɗengnuni, ɓuwi kǝthlǝm kǝ mbwa'aikuni i naka ɓuɓweeta Fara, tǝ mbǝr shunda ndu tǝ sǝn'ǝnwa. ");
INSERT INTO bvw_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Kǝthlǝm tepi tirihur yahwisa sǝn'ǝn somǝn naki tǝ kuniwa, Yǝso Kǝrǝsti ndak, le kukwandǝfichǝhi. ");
INSERT INTO bvw_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Ɓaki mbǝɗengnuni hur ɓah alchita tǝ lechita, paɗ tǝ saktatfǝ kaǝn. ");
INSERT INTO bvw_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Lǝmfatsi ndu ɗathla hur shuɗengnǝ tǝ ɓassengnǝwa, tǝ cheɗndǝ alchita Shemeɗa, ");
INSERT INTO bvw_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Kǝthlǝm fǝrkitchiɗengnuni mǝniɗa ɗar sǝn'ǝna nofchǝwa, kǝ naka ɗar alchita Fara. ");
INSERT INTO bvw_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Chika tǝ kichu, la shuwunkani sǝn'ǝna kǝ mbǝɗa fichile mwanka hur fǝrkit, nga sǝn'ǝna kisshi'i nakǝnya ndu i kuturchi nakǝnya, fichile naka thlǝrǝttaɗǝwa. ");
INSERT INTO bvw_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","La nakani shuwun sǝn'ǝna Fara hur ɓuɓweetǝ yu, le naka hur ɓuɓweetǝ soh, sǝn'ǝni fǝrtǝ Farǝ soh kǝ tǝrka nathi kǝthlǝm mwaɗengnǝm. ");
INSERT INTO bvw_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Hur kuturchi nakǝnya ngusǝ mbǝsang sǝn'ǝniyawa, mamuwa mbǝsanda, ma kukwawundǝ Lǝmwandǝ le nak mwanchinwa. ");
INSERT INTO bvw_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Nda i nat yaratkǝna hur laulawatkǝn: \"I tahsandǝ Fara fichilesǝ la mbǝnkǝfatkǝn, tamu hwanita natwa, thlǝmatsǝ tamka sǝktǝwa, hanndǝkiketa nifǝsǝ tamka yarandǝhiwa.\" ");
INSERT INTO bvw_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Kanang cheɗandǝ Fara kani tǝ mbǝɗa Shemeɗ'en. Shemeɗ la kaǝn chikamǝnat, chikamǝ naka hwengngǝchit icha Fara. ");
INSERT INTO bvw_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Wuna hurnofcha sǝnkǝ yara nifa, manga Shemeɗi nifǝkǝn ti naka fi'enwa? Kichu paɗ nifǝsǝ sǝnkǝ yara Farǝ wa Shemeɗa Farǝ ndak. ");
INSERT INTO bvw_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Thluwani shemeɗa kisshitǝwa, Shemeɗi ɓaka mbǝɗa Fara thlǝtani, kǝthlǝm kǝ sǝnani ichi fǝrandǝ Fara kani pofǝn. ");
INSERT INTO bvw_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","La mbwa'angani ichiya kuni, nga tǝ shuwunchǝ le sakandǝ fichaɗi tǝ mbǝɗa sǝn'ǝna nifǝwa tǝ shuwunchi sakandǝ fichaɗi tǝ Shemeɗa, tǝ mbu i naka kitchita shemeɗa a hur shunda Shemeɗa. ");
INSERT INTO bvw_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Nifi nguchit Shemeɗa fi'en thlutǝ ichi ɓaka mbǝɗa Shemeɗa Farǝ wa, kǝthlǝm nakǝn kǝ ɓomchita mbǝɗ'en, paɗ ngu mbǝlla sǝn kandǝwa, kǝthlǝm tǝ mbǝɗa Shemeɗ la sǝntǝfichǝ kanda. ");
INSERT INTO bvw_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Nifi nat Shemeɗsa fi'en la sǝnkǝ ichǝ nat, mǝllan tǝ indi'en nifǝsǝ na kikeɗandǝwa. ");
INSERT INTO bvw_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","\"Wun sǝnkǝ yara Lǝmwanda har natna sakandǝhar?\" Kanang yarengnani i Kǝrǝsti. ");
INSERT INTO bvw_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Hwanmancha, ngi mbǝlla mbwa'a' ǝna kuni nda nofchi naktǝ shemeɗa fǝwa, nda nofchi naka kisshita, paɗ nda hangwa'yarcha hur tǝrmbanda Kǝrǝsti. ");
INSERT INTO bvw_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Yah fǝrandǝ kuni nga ɗǝsǝmtǝ kwaakwaawa, kǝthlǝm sǝkwunisa sǝm'ǝn kwaakwaa kwaɗǝnwa. Chika nakǝnya sǝkwunisǝwa, ");
INSERT INTO bvw_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Kǝthlǝm paaya mwakuni hur fata. Makuna sǝrǝh ndani paɗ thlangǝtmisa thlerǝnuni, nga mwakuni hur fatwowa? Ɗǝsǝchengnuni nga nda tǝ fatwa? ");
INSERT INTO bvw_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Kǝthlǝm ma ndeɗ yunǝwa, \"Njang i Bulus\", \"Ndak yunǝwa\", \"Njang i Afolos\", Nga tor fat natuni sǝtyuwa? ");
INSERT INTO bvw_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Wun naka Afolos? Wun naka Bulus? Nga mafechǝwa fichile fǝrtuni kit tǝ mbǝɗengnanda, nda i fǝrandǝ Lǝmwanda tora chikawun engnanda? ");
INSERT INTO bvw_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Njang hǝfkǝ hanwǝtǝkǝn, thlǝrkǝ Afolos amsǝ, paɗ Farǝ mwanangnga. ");
INSERT INTO bvw_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Kǝthlǝm ndǝkǝn, lǝ hǝfkǝn tǝ le thlǝrkǝ amsi nga naknda mi ǝnwa, Farǝ ndak mǝllanti la mwanangnga. ");
INSERT INTO bvw_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Lǝ hǝfkǝn tǝ lǝ thlǝr amkǝnsi nakndǝ ǝrta, chika wuna hurnanda nakficha kwanandǝ keeke tǝ tor'en. ");
INSERT INTO bvw_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Kǝthlǝm kanang shikechǝ fa torcha Fara, kunang hita Fara, tinda Fara. ");
INSERT INTO bvw_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Tǝ mbǝɗa kafaɗi fǝritǝ Fara, a ɗǝfi thlorǝ tindǝhi kǝ lǝ mbǝr tinda, ɓakyuna nata chekandǝ tinkǝn kǝ ɗarkǝn. Chikawuni kǝ sǝn hǝɓaakǝ tǝ witǝ tindǝ'en. ");
INSERT INTO bvw_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Kǝthlǝm nifǝsǝ na ɗǝf thlorǝ tinda kǝ pǝɗangka le hi ɗǝftǝ fichǝhiwa, le naka Yǝso Kǝrǝsti. ");
INSERT INTO bvw_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Nakǝnya ma tin yunǝ kǝ ɗar thlorǝ tinkǝn tǝ zinariya, ndu tǝ azurfa, ndu tǝ ngwichǝ ɗiichin, ndu tǝ afcha, ndu tǝ hwelaa, ndu tǝ kofcha, ");
INSERT INTO bvw_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","na tora chikawuna chetakish, kǝthlǝm fariniyu nan chetakissha ɗwaachitkǝn. Nak tora chikawuna chetakish tǝ hwata, hwatkǝn na kikeɗandǝ tora chikawuni. ");
INSERT INTO bvw_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Ma tini sǝtficha kǝ ɗar thlorǝ tinkǝn hiriki iwaɗǝwa, le tinka nan thlǝt kǝnikǝn. ");
INSERT INTO bvw_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Ma iɗ torkǝna ɗi, le tinka nan sat ɓahta, mǝllan tǝ indǝ'en nan hǝrǝkta nda nifi kuwurkǝ tǝ hur hwata. ");
INSERT INTO bvw_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Awi sǝnwuniwa kunang tǝ inchengnuni naka kapat hura'a Farǝwa, paɗ nak Shemeɗa Farǝ tǝ sokta a hur hanndǝkikechengnuniwowa? ");
INSERT INTO bvw_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Chikawun sǝɓang kapat hura'a Fara ɗi, na Fara sǝɓandaɗi; kǝthlǝm kapat hura'a Fara la nakǝn chiɗchiɗ, kunang naka kapat hura'a Farǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Mǝ lǝmiɗuni inchengnuniwa. Ma yunǝsa hurnuni la yarkǝwa ɗathlchin a hur kisshi'i nakǝnya, kǝ saǝn fat'en nda ɓoma, kǝthlǝm kǝ sǝka lǝ ɗathla. ");
INSERT INTO bvw_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Ɗathla kisshi'iya ɓomchita mbǝɗa Fara. Nda i natna hur yarat laulawatkǝn: \"La kǝsaǝn fichile nak ɗathlchin a hur ɗathlengnanda.\" ");
INSERT INTO bvw_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Tǝpaɗ: \"A shin Lǝmwandǝwa yara fa ɗathlǝ nga ǝnwa.\" ");
INSERT INTO bvw_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Kǝthlǝm ndǝkǝn mǝ hupa nifǝ hǝsǝr tǝ nifǝwa. Kǝthlǝm chikamǝ nat innuni, ");
INSERT INTO bvw_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","ndu Bulus, ndu Afolos, ndu Kefas, ndu kisshita, ndu shisshingta, ndu mǝrtaɗi, ndu ichi nakǝnya, ndu ichi naka mban, nat innuni. ");
INSERT INTO bvw_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Kunang paɗ i Kǝrǝsti, Kǝrǝsti paɗ i Fara. ");
INSERT INTO bvw_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Tǝkichu kemsi kǝ tǝruni kaniwa mafecha Kǝrǝsti, tǝ fichile ngǝmandǝ fichǝ kǝnandǝ tǝ ichi Farǝ naka ɓuɓweeta. ");
INSERT INTO bvw_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Sokkǝn waat nifi malandǝ fichǝ ichahar kemsi kǝ mbǝsang fichǝ tǝ kitchita fa. ");
INSERT INTO bvw_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","A mbǝɗengna, hanhwan'ǝna kǝ nda fichǝwa kunang na sakimiya ndu mbǝt sakmiya chikawun nifa. Kitchitkǝn, njang mangi sakamiya faɗengniwa. ");
INSERT INTO bvw_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","A shini hur indengniwa naki yalfar, chika kichu ngu soktǝwa chiwi hansarǝhiwa. Lǝmwandǝ na kikeɗita. ");
INSERT INTO bvw_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Kǝthlǝm ndǝkǝn mǝ thlaɗuni sakmihi kǝ ɗar yunǝ pofǝn sa'u hanmunchikǝn kwaɗǝnwa; pwa'ama kǝ farǝ nat Lǝmwanda ɓata. Mǝllan na chandǝ ichi kissha ɓuɓweeta kǝ ɗwachitkǝn, kǝ cheɗin yara hanɗǝkikecha. A farǝniyu chikawun nan thlǝt hamtǝ'ena mbǝɗa Fara. ");
INSERT INTO bvw_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Nakǝnya hwanmanchina, fǝrki sakǝt ichi natya kǝ faɗengnǝ tǝ Afolos kǝthlǝm kunang, kǝ sakuni ǝn tǝ mbǝɗengnani kǝ ɗar shuni ndatfichǝwa: \"Mǝ mbǝraɗuni ihi yarandǝ fichihi hur laulawatkǝnwa.\" Mǝ thla'a yunǝ inda hurnuni kǝ mbǝrangka lehi kǝ ɗar yunǝwa. ");
INSERT INTO bvw_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Wun sukǝ somǝnhi tǝ tahhǝt nofcha, mǝnakseku le thluchitu? Sokkǝnma tǝ thlǝna, mǝsǝk natu thla'a'ndǝ inda nda nga tǝ thlǝnǝwa? ");
INSERT INTO bvw_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Tepi mbǝshuni nat ichi yahtuni! Tepi shokuni kǝ hurrumcha! Tepi shokuni kuturcha nga tǝ kanangwa! Mayahtengna kǝ sokuni ka kǝ kuturcha, kǝthlǝm kanang ma kǝ sokani kuturichitkǝn tǝ kuni. ");
INSERT INTO bvw_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","A naɗengna cheɗ Fara a ɗwachitkǝnwa, kanang fathlǝncha njirandǝ fichǝ kaniɗi kǝ ndukwatkǝn chika mi, nda nofchi thlandǝ fichǝ sakmi mǝrtaɗa kandǝsi, sangfichi kani kǝ ǝnat nata kisshita, tǝ mala'ika cha nat tǝ nofcha. ");
INSERT INTO bvw_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Shokani kǝ ɓomcha Kǝrǝsti, kunang nakuni kǝ fa ɗathla hur Kǝrǝsti! Kanang fa kuɓanda fata, kunang nakuni kwaakwaa. Ficha natkuni tǝ kapatichita fa, kanang nga ǝnnakaniwa. ");
INSERT INTO bvw_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Paa kǝ nakǝnya, nakani hur mita tǝ kusshimta, thlǝthlah njelecha naka fechengnani, ficha tǝpanda kani paɗ hurechengnanisǝwa. ");
INSERT INTO bvw_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","La sani tor kaǝn tǝ harchengnani. Ma erndǝ kani, ndǝfangani mbǝs'ǝnhara kanda; ma fǝrandǝ pwancha kani, kǝrǝskani. ");
INSERT INTO bvw_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Ma sǝɓandǝ thlǝmchǝnaniɗi, la shunangani kandǝ tǝ kachita. Paaya sokkani nda chirǝfta kisshita, i nat chikawuna wuɗekta. ");
INSERT INTO bvw_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Nga yaraki iya kǝthlǝm kǝ harangfat kuniwa, kǝ tahsayi kuni nda hwanchi yahti. ");
INSERT INTO bvw_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Chikama sokkǝn fasakchengnunisǝ aru kumchitkum (10,000) a hur Kǝrǝsti, shinchǝnunisǝ terchinwa, kǝthlǝm njang naka shinnuni a hur Yǝso Kǝrǝsti tǝ mbǝɗa laulawata. ");
INSERT INTO bvw_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Kǝthlǝm ndǝkǝn nja hwanandǝ kuni kǝ sakuni nji. ");
INSERT INTO bvw_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Kǝthlǝm ndǝkǝn nja thlǝna Timoti kuni, hwe'engna le la mbǝntifatkǝn, le nak tǝ kachita a hur Lǝmwanda. Nan kuɗkanda kuni tǝ mbanda naɗengnǝhi a hur Yǝso Kǝrǝsti, nda i soktǝn keeke tǝ i sakandi ɗaɗi chika ayi hur chika yen mbǝt tǝrmbanda. ");
INSERT INTO bvw_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Funa thla'a'ndǝ inda nda ngi ɓata mbǝɗengnuniwa ");
INSERT INTO bvw_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Ma ngǝma Lǝmwanda ni ɓata mbǝɗengnuni chetchetya, kani tausandǝ alchiɗi mbǝstǝ fa thla'a'ndǝ iniyu kish tǝ shuwunchengnanda. ");
INSERT INTO bvw_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Kǝthlǝm kuturichita Fara nga pathla shundǝwa pathla alchita. ");
INSERT INTO bvw_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Mǝ yahtunisi? Kǝ ɓi mbǝɗengnuni tǝ kuɓwerǝwa, ndu hur mbǝnfata paɗ tǝ ngwallǝchit shemeɗa? ");
INSERT INTO bvw_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Shikiwa fǝlawichitsa hurnuni, witǝ le tamuchit ficha sǝta chika hur fa sǝt tor ɗǝhhacha, yuna sok fǝlawichit tǝ nuh shinkǝn. ");
INSERT INTO bvw_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Nakuni thla'a'ndǝ inda! Nga kwesh sǝtuni sǝɓhurwa? Chikawun sǝk iniyu kǝ chang ficha kissha hurnuni. ");
INSERT INTO bvw_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Chika sokkǝn njangsǝ tǝ iɗengna mbǝnniyuwa, njang tǝ kuni hur hanɗǝkiketa. Tepi sakaɗi miya nifi sǝk witǝ iniyu, nda njangsa mbǝnniyu. ");
INSERT INTO bvw_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Ma hwimunihi a hur thlǝm Lǝmwandǝ Yǝso njang tǝ kuni mbǝnniyu hur hanɗǝkiketa, paɗ alchita Lǝmwaɗengnǝm Yǝso mbǝnniyu, ");
INSERT INTO bvw_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","witǝ nifiniyu kǝ fǝranguni Sheɗan kǝthlǝm kǝ ɓǝllang ficha hur fata, mbah na shemeɗ'ena hǝrǝkta farǝ ɓata Lǝmwandǝ Yǝso. ");
INSERT INTO bvw_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Thla'a'ndǝ inchengnuni ndǝɗuwa. Sǝnwuniwa, mehndǝ nguɗehkicha la huppang humbat tahasǝ njohmǝ wowa? ");
INSERT INTO bvw_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Pa'amǝn ɗohhǝt mehniɗiyu fechengnuni, kǝ sokuni kǝ yuwa ɗokyeta le nguchit mehndǝsa fi'en, kǝthlǝm kittǝkǝn nakuni kichu. Kǝthlǝm teppa thlafichi ɓurat hwan shohraɗengnǝm i chohhǝm tala, mǝlan naka Kǝrǝsti. ");
INSERT INTO bvw_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Kǝthlǝm ndǝkǝn kǝsam chohhǝmtengnǝmhar nga tǝ ɗohhǝt mehndǝwa, mehǝn sǝɓfata tǝ ɓǝɓifata. Kǝla sǝm chohhǝmtengnǝm tǝ njohmi nguchit mehndǝsi, ndǝkǝn naka njohǝm kachita tǝ kitchita. ");
INSERT INTO bvw_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Yaraɗi kunisa hur thlǝn yarat ɗelwer engna ndatwa mǝlla humiɗunihi tǝ fǝlauchiwa. ");
INSERT INTO bvw_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Nga yarengnǝwa nofchi kisshi'iya naka fǝlauchiwa, tǝ fa yah'ichǝwa, tǝ fa ɗathlanda nofchifǝwa, tǝ fa sǝt tor ɗǝhhachǝwa. Kǝthlǝm ma nakǝn kichu sokkǝn waat kǝ chunikissha hur kisshita. ");
INSERT INTO bvw_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Yarayi kunisi mǝ sokiɗuni tǝ chikawun la at fichiwa hwanmanda lǝ tǝrmbanda, ma la sǝkǝn fǝlawichita, ndu lǝ yah'icha, ndu lǝ mwanandǝ ɗǝhhacha, ndu lǝ erǝfata, ndu lǝ sat icha, ndu hara. Chika sǝm'ǝn mǝ sǝmiɗuni tǝ witǝ nofchiniyuwa. ");
INSERT INTO bvw_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Mǝ kǝmikǝ tǝ sakamiya fichile nguchika hur tǝrmbanda? Nga fichile naka hur tǝrmbandǝ natuni sakamiya kandǝwa? ");
INSERT INTO bvw_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Farǝ na sakamiya fichile nguchika hur tǝrmbanda: \"Chamǝn ɓǝɓi nifa hurnuni.\" ");
INSERT INTO bvw_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Ma yunǝsa hurnuni naka thlangǝtmi tǝ shekkǝn, mǝ ɗiɗa muhhanharkǝna mbǝɗa fa ɓah fǝrkitwa, nga kweshkǝn kǝ mbǝɗa fa fǝrkitwowa? ");
INSERT INTO bvw_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Awi sǝnwuniwa fa fǝrkit na sakamiya kisshitǝwowa? Makunang na sakamiya kisshita, nguni mbǝla sakmi ichi top-topyawowa? ");
INSERT INTO bvw_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","A sǝnwuniwa kǝmnang na sakamiya Mala'ika chiwowa? Kana cheta ichi natma soktǝsa kisshi'iya! ");
INSERT INTO bvw_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Ma witǝ muhhanhar chini engnunisiyu, mǝsǝk la ɗǝtuni tǝkǝna mbanitǝ fichile nguchika miya ǝna mbanitǝ fa tǝrmbanda? ");
INSERT INTO bvw_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Mbuki iniyu kǝthlǝm kǝ harangfat kuni. Sokkǝnyawa yunǝsa hurnuni ǝrtǝ nak ɗathlchin na tahsandǝ thlerǝ fa fǝrkitaɗǝwa? ");
INSERT INTO bvw_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Paɗ mǝsǝka hwanmanda la ɗǝtna muhhanhar hwanmankǝn a mbanitǝ fa ɓah fǝrkit? ");
INSERT INTO bvw_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Muhhanhar ndani ti la muhtuniyu kǝttǝhi mbǝɗengnuni. Nga kweshkǝn kǝrǝstuni kǝ nuni ɓomchǝwowa? Mǝsǝk nguchituni kǝrǝstǝ kǝ ɗathlang ficha kuni fa? ");
INSERT INTO bvw_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Kunang tǝ inchengnuni kuna ɗathlanda ndanifa kuna puppuk ndanihi, ta hwanmanchǝnuni la sanduni ichiniyu kanda. ");
INSERT INTO bvw_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Awi sǝnwuniwa fa ɓah fǝrkit ngunda mbǝs yimta kutǝrichita Farǝwowa? Mǝ lǝmi fichi kuniwa, kǝthlǝm fa sǝɓtaɗaɗisi ndu fa sǝt torɗǝhhacha, ndu fa sǝt fǝlauwichita, ndu hishchǝ fa che fechengnanda, ndu hishchi fa mundǝ tǝ hishcha, ");
INSERT INTO bvw_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ndu harcha, ndu fa yahta, ndu fa sat'icha, ndu fa erǝfata, ndu fa ɗathlanda nofchǝfa na mbǝs mbǝta hur kuturichita Farǝwa. ");
INSERT INTO bvw_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Nak funengnuni kichuyu. Anakǝn sapa fichǝ kuniɗi, tahsafichǝ kuni, chafichǝ kuni kish a hur thlǝm Lǝmwandǝ Yǝso Kǝrǝsti, paɗ tǝ mbǝɗa Shemeɗa Farengnǝm. ");
INSERT INTO bvw_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","\"Chikamǝ ngǝmifichǝsi\", Paɗ nga chikamǝ na kǝsitisǝwa. \"Chikamǝ ngǝmifichǝsi\", Chika kichu ngi sokta mafata chikamǝwa. ");
INSERT INTO bvw_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","\"Ɗǝsǝmta kǝthlǝm hura, hur paɗ kǝthlǝm ɗǝsǝmta\" Farǝ nan thlǝrtandǝ kandaɗǝ hwaa. Sufichǝ fata kǝthlǝm kǝ i fǝlawichitwa, kǝ naka i Lǝmwanda, Lǝmwandǝ paɗɗaa i fata. ");
INSERT INTO bvw_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Thla'ang Farǝ Lǝmwanda hur mǝmatcha tǝ alchit'en, paɗ chika kǝm nan thla'a'ndǝ kǝm. ");
INSERT INTO bvw_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Awi sǝnwuniwa fechengnuni njarǝ fata Kǝrǝsti tǝ indǝ'enwowa? Kemsǝ hachiya kǝ hari njarǝ fata Kǝrǝsti kǝ humayi kandǝ tǝ ɓǝɓimanda? Ngu tamtasǝtwa! ");
INSERT INTO bvw_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Awi sǝnwuniwa nifi humangfat tǝ ɓǝɓimanda sokkǝndǝ fat ǝrtǝ tǝ ndǝwowa? Kǝthlǝm nda i nat yarat laulawatkǝn: \"Chapndǝyu naknda soktǝ kǝ fat ǝrta.\" ");
INSERT INTO bvw_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Le humang fat'enhi tǝ Lǝmwanda, sokkǝndǝ ǝrta hur shemeɗ tǝ ndi. ");
INSERT INTO bvw_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Rahamna fǝlawichithar! Tahhǝt ɓǝɓichitfechi nat la sǝt nifa nakna kisshitǝ fat'en, paɗ le sǝk ɓǝɓichitfat tǝ mbanda fǝlawichita sǝkǝn ɓǝɓichitfat kǝ fa fat'en. ");
INSERT INTO bvw_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Sǝnwuniwa fechengnuni kapat hura'a Fara le naktǝ Shemeɗ Chiɗchiɗ, naka a hanndǝkikechengnuni, le thlǝtuni ɓǝɗa Farǝ wowa? Nga nakuni tǝ alchit inchengnuniwa. ");
INSERT INTO bvw_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Hikkǝ fichǝ kuni 'yang'yang. Kǝthlǝm ndǝkǝn mwanamǝn Farǝ tǝ fechengnuni. ");
INSERT INTO bvw_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Nakǝnya kǝ ichi yaratuni ɗarkǝn, ndiichinsi hishnifǝ mǝ kahindǝ kanwa. ");
INSERT INTO bvw_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Kǝthlǝm rahhanda fǝlawichit har, chikawun hishnifǝ kǝnan tǝ nuhkǝnsi, paɗ chikawun nuhnifǝ kǝnan tǝ sǝmahsi. ");
INSERT INTO bvw_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Hishnifǝ kǝ fǝraǝn i kamkǝsa nuhkǝn i reta, nuhnifǝ paɗ kǝ fǝraǝn i kamkǝsa sǝmahha i reta. ");
INSERT INTO bvw_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Kǝthlǝm nuhnifǝ alchit'ensǝ kǝ fa fat'en ichitkǝnwa, sǝmah ndak. Kichu paɗ sǝmah alchit'ensǝ kǝ fa fat'en ichitkǝnwa, nuhkǝn ndak. ");
INSERT INTO bvw_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Mǝ njaɗuni ndaniwa, kǝnan tǝ ngǝmtengnuni hwaa, kǝ fari ɗǝftuni kǝthlǝm kǝna hur'inchengnuni hur hwanda kanuni ngǝr kǝmta, kǝthlǝm mǝ limi sheɗan kuni a ɗar ɓah kǝrǝstǝwa. ");
INSERT INTO bvw_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Mbuki iya i kamkǝsi yarandǝhi, nga waatwa. ");
INSERT INTO bvw_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Mamuwa nansǝta kǝna nofchǝ nat nda njang. Nakǝn chikawun hishnifa tǝ i fǝrandǝ Fara, leya tǝ witǝ i fǝrandǝn leyu paɗ tǝ witǝ ikǝn. ");
INSERT INTO bvw_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Kǝ mbǝɗa fichile kahuchikkan tǝ ndǝllat nishcha fichile mǝrtǝ hishchengnandǝyu, a kǝllaɗengna keekesi kǝ soknda kahundǝ kanwa nda i nati. ");
INSERT INTO bvw_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Ma ngunda mbǝla kǝs fechengnandǝ harwa, kǝ kahndǝ kan. Kweshkǝn kǝ kah nifǝ kan mǝni ita ɗi tǝ yahta. ");
INSERT INTO bvw_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Kǝ mbǝɗa fichile kahkǝ kan nja ndandakuniwa, nga njangwa Lǝmwanda, ndatwa: \"Nuhnifǝ mǝ sakindǝhi tǝ sǝmahwa.\" ");
INSERT INTO bvw_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Ma ɓeɗa saktǝhi tǝndi, kǝ sokǝn kichuyu kǝnretsǝwa, manga kichuuwa kǝ tahsangndǝ thlerǝnandaɗi tǝ sǝmahha. Hishnifǝ paɗ mǝ sakiɗǝhi tǝ nuhkǝnwa. ");
INSERT INTO bvw_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Kǝ mbǝɗa tahchikǝn paɗ ndakiwa: \"Nga Lǝmwandǝ mbukǝwa.\" Ma yunǝ hwanmandǝsi nat nuhkǝn kǝla ɓahfǝrkit, ngim nuhnifǝkǝn kǝ sokǝn tǝndi, mǝ cheriɗǝndǝwa. ");
INSERT INTO bvw_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Ma nuhnifǝsǝ nat sǝmah kǝ lǝ ɓahfǝrkit, ngim hisnifǝkǝn kǝ sokǝn tǝndi, mǝ cheriɗǝndǝwa. ");
INSERT INTO bvw_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Kǝthlǝm hishnifǝ lǝ ɓahfǝrkit, tahsafichǝ chiɗchiɗ tǝ mbǝɗa nuhkǝn, paɗ nuhnifǝ lǝ ɓahfǝrkit, tahsafichaɗi chiɗchiɗ tǝ mbǝɗa sǝmahha. Manga kichuwa, hwechengnuni naknda nat tǝ putafa, nda i natǝn nakǝnya, nakndǝ chiɗchiɗ. ");
INSERT INTO bvw_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Ma lǝ ɓahfǝrkittiyu yahkǝsa saktǝhi tǝ shetkǝn kǝnan kichu. A witǝ mbǝnniyu, hwanmandǝ kǝ nuhnifǝ ndu kǝ hishnifǝ nga waatsa sokkǝnwa. Kǝthlǝm Farǝ akǝn kǝm kǝ sok yuyurchit tǝ ndani. ");
INSERT INTO bvw_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Sokǝn nuhnifa, shinnǝ ndu mbahya sokǝn na hǝrkandǝ sǝmatuuwa? Sokǝn hishnifa, shinnǝ ndu mbahya sokǝn na hǝrkandǝ nuhwuwa? ");
INSERT INTO bvw_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Chika witǝmǝ natma hurkǝn, chikawun kǝ sokka mbǝɗi ɗǝftǝ Lǝmwandǝndǝsi a nat'enhi, kǝ i at Farǝ ndi. Ndǝkǝn naka mbutengna kǝ mbǝɗa fafǝrkit nat. ");
INSERT INTO bvw_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Wun taɓkǝ kǝ heshang ficha kǝ fari at fichǝndi? Mǝ sokiɗǝ kǝ lǝ ɓah heshiwa. Le heshuchika kǝ fari at fichǝndi, mǝ kiɗǝ heshiwa. ");
INSERT INTO bvw_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Hesha tǝ ɓah hesha nga ǝn nakndǝwa, kuwur kussa Farǝ ndak naka ka'ǝna. ");
INSERT INTO bvw_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Chikawun kǝ nan nda i natǝn kǝ fari at Fara ɗi. ");
INSERT INTO bvw_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Naku kǝ mafat kana ficha atsǝwa? Mǝ kǝmu ǝnwa. Manu ɓǝs alchit iɗeku, sǝku tor tǝ mbayiniyu. ");
INSERT INTO bvw_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Chikawun naka mafata kana Lǝmwanda atndi nakǝn kǝ nifi ɓǝske alchit iɗi'en a Lǝmwanda. Kichu paɗ le nguchika mafata kana ficha atndi nakǝn kǝ mafata Kǝrǝsti. ");
INSERT INTO bvw_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Hikkǝ fichǝ kuni 'yang'yang mǝ niɗuni mafecha nofchǝwa. ");
INSERT INTO bvw_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Kǝthlǝm ndǝkǝn hwanmancha, chika hur witǝ sokmǝ atfichǝ chikawuni, kǝ sokǝn kichu nda i at Farǝndi, kǝnan tǝ Farǝ'en. ");
INSERT INTO bvw_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Kǝ ɗar nishchi tamuchika kan, fǝriwu Lǝmwandǝ alchit shuɗe kǝ ɗarkǝnwa, paɗ naki fǝr i naka yarengna kǝ ɗar ndatwa njangti ngǝmitǝ fichǝsi a ɗar shisshetfata Lǝmwanda. ");
INSERT INTO bvw_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Ma yarengna, kǝthlǝm ɓahhi natma hurkǝn nakǝnya, keekesi kǝ soknifǝ ichitkǝn nda i natǝn. ");
INSERT INTO bvw_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","A kehnikanwa? Mǝ kǝnǝ saktǝhiwa. Ma kahunikanwa, mǝ kǝnǝ nuhnifǝwa. ");
INSERT INTO bvw_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Ma kehnikan sunǝ ɓǝɓichitfatwa, ma keh nuhhwekan sutǝ ɓǝɓichitfatwa. Fichile kahkǝkan nanda yimta ɓahtǝ somsomǝn a naɗihiya, njang tǝ yahhisǝ kǝnan paapa'a mbǝɗengnuni. ");
INSERT INTO bvw_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","I yarti hwanmancha, ndatwa hanmunchikǝn nguɗeh. Thlata nakǝnya kǝ mban fichile nat nishchengnandǝsi kǝ sokndǝ nda ngusengnandǝwa, ");
INSERT INTO bvw_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","Fa tita nda nga tǝnnda titwa, fichile naka mbǝnfata nda nga kanda mbǝnfatwa, fichile hikkǝ'ǝna kǝ nandǝ nda nga ichengnandǝ kǝ kǝsndǝharwa. ");
INSERT INTO bvw_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","Fichile naka sǝt tor tǝ ǝnat kisshita mǝ ɗǝfindǝ fatsǝwa. Kǝthlǝm kisshikǝn a naɗi nakǝnya, tǝ naka mbǝrtǝhi. ");
INSERT INTO bvw_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Yahkisi kǝnuni cha'a hur thlahur i'nda. Nifi kahhuchikkan nak yarǝ'ena ɗar torcha Lǝmwanda, i natna sǝta kǝ tǝraǝn hura Lǝmwandǝhi. ");
INSERT INTO bvw_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Le kahkǝkan nak yarǝ'ena nata ɗar ǝnat kisshita, mbayi natna sǝt kǝ tǝraǝn hura nuhkǝnhi. ");
INSERT INTO bvw_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","Paɗ shek hur'indǝ'enhi. Nuhnifǝ kahhuchikkan ndu nuhhweya nak yarǝ'ena ɗar torcha Lǝmwanda, la ɗǝfkǝn indǝ'en kaǝn kǝ mbǝɗa Lǝmwanda a hur fat tǝ shemeɗa. Nuhnifi kahkǝkan yarǝ'ena ɗar ǝnat kisshita, mbayi natna sǝt kǝ tǝraǝn hura sǝmahhi. ");
INSERT INTO bvw_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Naki mbu ichiya kǝthlǝm kǝ kǝsangka kunisi, ngauwa kǝ ɓweshikuniwa, kǝthlǝm soktengnuni kǝnaka mbandǝ ndiichin mǝ saki yarengnunihi hur mwanandǝ Lǝmwandǝwa. ");
INSERT INTO bvw_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Ma yaraa yunǝhiwa i natna sǝt kǝ ɗar nuhhwani ngwantǝn nga keekewa, a nakǝn hurrecha nuhhwankǝna mbǝrtǝhi paɗ a fat'en kemsǝ kǝ kahhǝnkan, kǝ sǝn kichu nda i yahtǝn. Nga tǝna sǝt ɓǝɓichitfatwa, kǝ kǝnangndǝ reta. ");
INSERT INTO bvw_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Nifi thlarkǝ kit kǝ ɗar yara hanndǝkiketǝ'en ndatwa ǝnatkǝn nga waatwa paɗ nan mbǝlla kǝs indǝ'enhar, paɗ tira hanndǝkiketǝ'enwa ngu kahhandǝ nuhhwaniyuwa, mǝlan ma shiɗtǝ i nak keeke. ");
INSERT INTO bvw_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Nifi kahhang nuhhwani ngwantǝn shiɗ keeke, paɗ nifi kahhauchik nuhhwani ngwantǝn shiɗtǝ i kamkǝsǝ kaǝn. ");
INSERT INTO bvw_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Nuhnifǝ nakna kǝnda kǝ mbǝɗa sǝmahha ma tana mweehi tǝ shishingta. Ma mir sǝmahha, cheɗa kissha sahta kǝ kahhǝn chikawun yahtǝn, sokkǝn waat kǝ na hishnifǝkǝna i Lǝmwanda. ");
INSERT INTO bvw_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","A thlandǝ shuɗengnǝhi, nan nat tǝ mbǝnfat kaǝn manan soktǝ ichitkǝn nda i natǝn. Paɗ la sikǝnfǝ Shemeɗa Farengnǝsi. ");
INSERT INTO bvw_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Nakǝnya pathlǝ ɗǝsǝmi fǝrandǝ ficha ɗǝhhacha: \"Shinǝmwa nattǝm sǝɗengnǝmsi.\" Sǝndǝ la ɓakǝn tǝ thla'inda, mbǝnfata la tinaǝn. ");
INSERT INTO bvw_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Ma tiryunǝwa shintǝ'ǝna, paaya sǝnu nda i kamkǝsi kǝ sǝnǝnwa. ");
INSERT INTO bvw_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Ma yuna mbǝnfat Fara, shin Farǝ ndi. ");
INSERT INTO bvw_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Pathlǝ sǝm ɗǝsǝmi fǝrandǝ ficha ɗǝhhacha: \"A shinǝmwa ɗǝhhata nga ǝnnakǝnna kisshitǝwa paɗ Farǝsǝ somǝnwa ǝrta.\" ");
INSERT INTO bvw_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Chika sokkǝnwa funisǝ la atfichǝwa farǝcha a Afshi ndu kisshita (nda i nat, \"farǝchǝsǝ\" ka'ǝn \"shinchǝsǝ\" paɗ kaǝn), ");
INSERT INTO bvw_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","Chika kichu a mbǝɗengnǝm Farǝ ǝrta, le naka Shinda, ichi natya ɓakna mbǝɗ'en, naɗengnǝmhi kǝthlǝm mǝlan. Lǝmwandǝsi ǝrta Yǝso Kǝrǝsti, tǝ mbǝɗ'en chet ichi kish natya, kǝmnang paɗ naɗengnǝmhi tǝ mbǝɗ'en. ");
INSERT INTO bvw_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Nga chikawun sǝnkǝ iyawa. Funǝ paaya sǝɗengnandǝhi tǝ tor ɗǝhhacha, la saǝn kandǝfǝwa ɗǝsǝmi la sǝmtǝnda nda i fǝrandǝficha ɗǝhhata. Kǝthlǝm ndǝkǝn nguchikndǝ kwaakwa'a hur hanndǝkiketa la tǝrkǝndǝwa shiɓndaɗaɗi. ");
INSERT INTO bvw_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Ɗǝsǝmtǝ ɗutǝkǝm nduk tǝ Farǝwa. Ma sǝmwumwa ngǝma tahtǝhiwa, ma shimǝm ngǝma chektǝwa. ");
INSERT INTO bvw_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Kǝ ɗǝfuni indǝsi, mbǝs thlǝt indengnuni mǝ sokiɗa ǝnat chit hansarǝhi mbǝɗa fichile nguchit alchiɗengnandǝsi. ");
INSERT INTO bvw_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Kǝthlǝm ma neɗ yunǝsa le nguchik kwaakwa'a hur fǝrkit, sokǝn tǝ sǝnka sa sǝm'ǝna kǝtǝn mwanandǝ ɗǝhhacha, fǝrauni alchit sǝm i tahsandǝ ficha ɗǝhhachǝwowa? ");
INSERT INTO bvw_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Kǝthlǝm ndǝkǝn hwanmani nguchik kwaakwa'a na sǝndeku sokta mba hǝmtǝ'enhi, le mǝrtǝ Kǝrǝsti ɗi kǝthlǝm mǝlan. ");
INSERT INTO bvw_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Ma shiɗnǝ ɓǝɓichitfat kǝ mbǝɗa hwanmanchiwa, tǝ mbǝnniyu paɗ ɗǝfau ndindita kandǝ kǝ ɗar ɓah kwaakwaa chiɗengnanda, tǝ sǝnǝ ɓǝɓichitfat kǝ mbǝɗa Kǝrǝsti. ");
INSERT INTO bvw_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Kǝthlǝm ndǝkǝn, ma sǝm'ǝn na ɗǝf hwanyaa kǝ yimka hur ɓǝɓichitfata, mwawi tamta chi thlu paɗwa, kǝthlǝm mǝ ɗǝffiɗǝ ndǝ kǝ hǝmǝnhiwa. ");
INSERT INTO bvw_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Njang mbǝs thlǝt indengnǝsǝwowa? Njang nga lǝthlǝndǝ nakiwowa? Anuwi Yǝso Lǝmwaɗengnǝmwowa? Kunang nga kǝni torengnǝ nakuni a hur Lǝmwandǝwowa? ");
INSERT INTO bvw_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Chika sokkǝnwa nga lǝthlǝndǝ naki mbǝɗa funiwa, kittǝkǝn mbǝɗengnuni njang lǝthlǝnda, kǝthlǝm kunang naka sheta tǝ tor lǝthlǝɗengna a hur Lǝmwanda. ");
INSERT INTO bvw_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Tǝ ndǝkǝn la chandǝ faɗengna kish a mbǝɗa fa tauwasǝnji. ");
INSERT INTO bvw_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Alchiɗengnanisǝ kǝ fǝranguni sǝm'ǝna kani tǝ satwowa? ");
INSERT INTO bvw_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Nga alchiɗengnanisǝ kǝ tǝrani kan kǝ wi'yani tǝ nishchengnani fafǝrkit nda i la sǝt tahhǝt fathlǝncha, tǝ hwanmancha Lǝmwanda tǝ Kefas yuwowa? ");
INSERT INTO bvw_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Nga njang tǝ Barnabas ndak sokkǝ waat kǝ sani tor sǝma'ǝn inchengnani kǝ nanihiwa? ");
INSERT INTO bvw_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Wun la sǝk tor thlǝrhwata kana sǝma'ǝn indǝ'en? Wun na pat affǝt inabi kǝ cherka chi hwanchikǝn? Wun na hǝrǝm chaɓa kǝ cherka sat yahkǝn? ");
INSERT INTO bvw_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Naki mbu ichiya ɗar yara nifǝwa? Ndu kustǝkǝn kichuwowa? ");
INSERT INTO bvw_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Yarang fichǝhi a hur kussa Musa ndatwa: \"Mǝ panǝ hwan sokroka latami mamǝla sǝt tora hurhitǝwa.\" Lat ndak la hǝrǝmtǝ Farǝwa? ");
INSERT INTO bvw_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Nga shuwunkǝn kǝthlǝm kǝmnangwowa? Aa kǝthlǝm kǝmnang yarandǝ ficha. Kǝthlǝm lǝ huɗata, nakna huɗat tǝ ɗǝffatsǝ nan mbǝs ǝna, le naka ɗǝktǝ paɗ nakna ɗǝktǝ tǝ yarǝ mbǝs'ǝna hur ɗǝsǝmi hitǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Ma hifani hanwitǝ shemeɗa Fara hur hanɗǝkikecheng'nuni, kapat ǝnwa ma mbishani icha mbǝɗengnuni? ");
INSERT INTO bvw_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Mana funa mbǝs mba sǝt kichu mbǝɗengnuni, sherawani kandǝ tǝ mba sǝt kichuwowa? Chika kichu suwani tor tǝ mbayiniyuwa, kǝriskani tǝ chikamǝ kǝthlǝm mǝ ɓiɗani tǝ i na njat tor laulawata Kǝrǝstiwa. ");
INSERT INTO bvw_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Sǝnwuniwa fichile la sǝk tora kapat hura'a Fara, la mbǝskǝndǝ ɗǝsǝmtengnanda kapat hura'a Farǝkǝnwowa? Fa sǝt tora bagadi la mbǝskǝndǝ ɗǝsǝmta hur ichi la fǝrtǝ fichi i fǝr pofǝnwowa? ");
INSERT INTO bvw_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Kichuyu paɗ mbutǝ Lǝmwanda ndatwa, fichile naka ɓassǝ laulawata kǝ thlǝndǝ ǝnat nathi engnandǝ tǝ mbǝɗa laulawatkǝn. ");
INSERT INTO bvw_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Njang tamwi sah ǝn kuni hur ichiniyuwa, paɗ nga naki yarat'iya tǝ ɗǝffatsǝwa kǝ sikǝ fichǝ kichuwa. Kweshkǝn kǝ mǝri, mǝni yuna nji wilwirtengna tǝ ndǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Chika kichu ma ɓesshi laulawatkǝn, ngi wilwirtǝwa, kǝthlǝm ɗǝfkǝ fichǝnji waat kǝ ɓassi. Ai engna ma ɓasswi laulawatkǝnwa. ");
INSERT INTO bvw_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Mamuwa la ɓasski a ɗar yahtengna mala kwanikǝ ficha. Sokkǝnwa nga ɗar yahtengnǝwa, tǝni sǝt i malitǝ fichǝhi. ");
INSERT INTO bvw_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Mǝnaka kǝnikǝn engna? Kǝnikǝn engna ndǝkǝn naka ɓasse laulawatkǝn, kǝ ɓassǝ pofǝn. Sǝwitor tǝ cheta mbǝɗengnǝ nat a hur ɓassǝkǝnwa. ");
INSERT INTO bvw_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Chikama sokkǝn naki kweɗeleng nga hara chikawunwa, saɗi faɗengna mafata nofchǝnat, kǝthlǝm kǝ mbǝsi nofchǝ oi. ");
INSERT INTO bvw_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Kǝ mbǝɗa Yahudawecha, naki nda lǝ Yahudawata, kǝthlǝm kǝ mbǝla'i kahhandǝ hur'incha Yahudawecha. Kǝ mbǝɗa fichile nat kussa alchiɗengnanda, naki nda le naka kakǝn paɗ (chikama sokkǝn njang tǝ indengna nga naki ka kustǝkǝnwa) kǝthlǝm kǝ kahhayi hur'incha fichile naka ka kus tǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","Fichile nguchika ka kus tǝkǝn sokki nda kandang (chika sokkǝn nga naki kisshitǝ kussa Farǝwa naki ka kussa Kǝrǝsti) kǝthlǝm kǝ kahhayi hur'inda fichile nguchika ka kus. ");
INSERT INTO bvw_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Kǝ mbǝɗa fichile nguchit alchitsi njang ma naki alchitsǝwa, kǝthlǝm kǝ kahhayi hur'incha fichile nguchit alchiɗengnandǝsi. Sokki kǝ ichinat kǝ mbǝɗa nofchǝ nat kǝthlǝm chika tǝ kǝni kǝ hǝrkayi funa. ");
INSERT INTO bvw_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","Sǝki ichini natyu kǝthlǝm kusheng shundǝ mbinchin, kǝthlǝm kǝ mbǝsi ǝnhar hur mbǝs'ichihar. ");
INSERT INTO bvw_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Sǝnwuniwa hur fa teri rahta, nat fa teri rahkǝn la kweekǝndǝhi kǝ pǝɗangnda ndanihi, ǝrtǝ ndak la thlǝk kǝnikǝnwowa? Yimamma rahkǝn kǝthlǝm kǝ mbǝsuni kǝnikǝn. ");
INSERT INTO bvw_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Nat fa yimta terriyiniyu, la fǝrangndǝ ɓahta fechengnandǝ chika tǝteni. La sǝkndǝ kichu kǝthlǝm kǝ mbǝsndǝ kǝnikǝn lena sǝɓtaɗi, kǝmnang paɗ la sǝkǝm inǝm kǝ mbǝsǝm kǝnikǝn le nguchika sǝɓtaɗǝ kǝpwaree. ");
INSERT INTO bvw_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","A rahwi pofǝn nda nga mbǝt ɗǝtsǝwowa, a tokwi fat nda lela tokkǝ rǝnnawa. ");
INSERT INTO bvw_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","Tǝ fǝrayi ɓahta faɗengna kǝ sayi mafata, kǝthlǝm ɗiffitǝ ɓassanda nofchǝsi njang tǝ indengna mǝ nji fichǝ mbǝs kǝnikǝnwa. ");
INSERT INTO bvw_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Yahkǝsi kǝ sǝnuni, hwanmancha, ndatwa kakechinǝm nat wikǝnda ka husomba'a, paɗ natndǝ ɗǝkndǝ tǝ hur hawurta. ");
INSERT INTO bvw_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","A ka husombi'iniyu tǝ hur hawurkǝn sandǝ fichǝ baptisma kandǝ uf kǝ kuwur Musa. ");
INSERT INTO bvw_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Natnda sǝmkǝndǝ ɗǝsǝmta shemeɗa. ");
INSERT INTO bvw_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","Natnda sakndǝ ama shemeɗa, kǝthlǝm sheɗndǝ ama a ngwiya shemeɗa le wiikǝ tǝ kanda. Ngwikǝn Kǝrǝsti nakǝn. ");
INSERT INTO bvw_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","Chika tǝ kichu, sǝku Farǝ mbǝnfat tǝ funǝ oi a hurnandǝwa, tǝkang fichǝ kandǝhi a loktara. ");
INSERT INTO bvw_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Sǝk ichininatyu kǝ naka sakchikǝna mbǝɗengnǝm, kǝthlǝm mǝɗi hanndǝkikechengnǝma ɗar ɓǝɓi ichǝ nda i sǝtndǝwa. ");
INSERT INTO bvw_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Mǝ sokiɗuni kǝ fa sǝt tor ɗǝhhachǝ nda i sǝt funengnandǝwa, nda i natna hur yarat laulawatkǝn ndatwa: \"Sokkǝ nofchikǝnhi kǝ sǝmndǝ kǝ sanda, thlaakǝnda naknda rǝɓta a hur sǝɓtaɗǝ i fǝlawichita.\" ");
INSERT INTO bvw_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Mǝ yimindǝma fǝlawichit nda i sǝt funengnandǝwa, ɓaka sǝt nifǝ aru kumchitkum chap tǝ aru kumchit mǝkkan (23,000) mǝrka farǝ ǝrta. ");
INSERT INTO bvw_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Ngǝma kikeɗandǝ Lǝmwandǝwa nda i sǝt funengnandǝwa, ɓak hwithlincha tǝkandǝ kandahi. ");
INSERT INTO bvw_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Mǝ hurmiɗǝm nda i sǝt funengnandǝwa, Mala'ika tǝ ɓǝlta tǝkaǝn kandahi. ");
INSERT INTO bvw_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Kǝskǝ ichini kandǝyu kǝ naka sakǝtkǝn, yarang fichǝ kandǝhi kǝthlǝm kǝ sǝka ǝnat kah thlǝmaɗengnǝm, kǝmnang ti ɓat ndukwat kisshikǝna mbǝskǝm. ");
INSERT INTO bvw_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Kǝthlǝm ndǝkǝn chikawun yarkǝwa nakǝn kit, kǝ mbǝrǝnsi mǝ hǝmiɗǝhiwa. ");
INSERT INTO bvw_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Kiketǝsi tamka mbǝskuni le mbǝsuchitǝn nifǝwa. Farǝ lǝ kachita, ngu tamta ngǝmtǝ kǝ kikeɗang fichǝ kuni tǝ i na sheranda allengnuniwa. Ma kikeɗa fichǝ kuni nan mbǝssa mba chetakissha kuni, kǝthlǝm kǝ mbǝla'uni kǝrǝskǝn. ");
INSERT INTO bvw_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Kǝthlǝm ndǝkǝn shikechina, rahamna tor ɗǝhhachihar. ");
INSERT INTO bvw_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Shuwunki tǝ kuni kunang fa hur'incha, kǝ yarangunihi kunang tǝ iɗengnuni i mbuti. ");
INSERT INTO bvw_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Kop i mbǝs'inhar le la sǝtǝm usoko kǝ ɗarkǝn, nga ndǝkǝn la ɗǝfkǝkǝm kǝnǝm ǝrta a hur fwara Kǝrǝstiwowa? Njohmi la chichaɗǝmhi nga ndǝkǝn la ɗǝfkǝkǝm kǝnǝm ǝrta a hur fwara Kǝrǝstiwowa? ");
INSERT INTO bvw_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Kǝthlǝm njohmiya ǝrta, kǝmnang ti nak terchin fat ǝrta, kǝthlǝm nattǝm njohmǝ ǝrtǝ la chiitǝm. ");
INSERT INTO bvw_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Kǝlamǝn Isra'ilawecha: Fichile la sǝmka hur i fǝrtǝ ficha, nga la humndǝhi tǝ ndani hur sǝm ichi fǝrandǝ ficha Fara a bagadi tǝ fǝr'ichǝwowa? ");
INSERT INTO bvw_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Mǝ nati yarǝ hachiyu? Ɗǝsǝmi fǝrandǝ ficha ɗǝhhacha naka ǝnwa, ndu ɗǝhhakǝn naka ǝna? ");
INSERT INTO bvw_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Auwa, yarengnaa i la fǝrtǝ fa sǝt tor ɗǝhhacha la fǝrangnda lǝwurcha nga Farǝwa. Yahwisǝ kǝ la nuni humtǝhi tǝ lǝwurchǝwa. ");
INSERT INTO bvw_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Nguni sat tǝ kop a Lǝmwandǝ kǝ suni paɗ tǝ i lǝwurchǝwa. Nguni sǝm'ǝna a mbǝt sǝmɗǝsǝmta Lǝmwanda kǝ sǝmuni paɗ a i lǝwurchǝwa. ");
INSERT INTO bvw_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Nǝma ɗǝf Lǝmwandǝ kǝ sǝrǝhtǝwa? Sheraɗǝm tǝ alchitwa? ");
INSERT INTO bvw_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","\"Nat icha ngǝmaficha kǝmsi\", Nga nat ichǝ na kǝsanda kǝmsǝwa. \"Nat icha ngǝmaficha kǝmsi.\" Nga nat ichǝ la tinangwa. ");
INSERT INTO bvw_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Mǝ si nifǝ ǝn ndiichin kǝ ɗar indǝ'en ɗengwa, kǝsǝn kǝ ɗar'inda funǝ paɗ. ");
INSERT INTO bvw_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Chi'u chikawitǝ thlumi, la hi'yandǝ fichaɗa mbǝt hi'yandǝ thluwaɗi, nga tǝ sahmi mbǝɗi ɓat thlukǝnwa, kǝthlǝm mǝni yarengnuni nata mbǝɗi chet thlukǝn. ");
INSERT INTO bvw_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Kǝthlǝm: \"Kisshitǝ i Lǝmwanda nat tǝ ichi naka hurkǝn.\" ");
INSERT INTO bvw_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Ma eɗ lǝ ɓah fǝrkit sa sǝm ɗǝsǝmta, ngǝmkufǝ ɗǝkuni, sǝmu i ɓandǝ ficha kuni nga tǝ sahmiwa, kǝthlǝm kǝna hur'indǝ ngwalngwal. ");
INSERT INTO bvw_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Ma ndu yunǝwa: \"Ɗǝsǝmiya i ɗǝhhata\", Mǝ sǝminǝwa, kǝthlǝm le mbukǝ paɗ kǝna hanndǝkiketǝ'en yuyur tǝ sokǝn. ");
INSERT INTO bvw_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Nga yarkiwa hur'iɗekuwa, ikǝn. Yunǝ nan ndatwa kǝthlǝmmǝ nat ficha nji i yahtǝ faɗengna, kǝthlǝm yuyurchit hanndǝkiketa yuna? ");
INSERT INTO bvw_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","Ma saɗi Farǝ usoko, kani sǝm ɗǝsǝmkǝn, kǝthlǝmmǝ nat ficha ishnji kǝ ɗar i sandǝ Farǝ usokosi? ");
INSERT INTO bvw_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Ndu tǝ sǝmna ndu tǝ sana, ndu chika witǝmǝ natu sǝta, su nat kǝthlǝm mwanandǝ thlǝm Fara. ");
INSERT INTO bvw_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Mǝ siɗuni kǝ ǝnat chit hansarǝhiwa, ndu Yahudawecha, ndu fichile nguchika Yahudawecha ndu nofcha Fara. ");
INSERT INTO bvw_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","Naki kweetǝhi kǝ tǝrayi hura nofchihi nat chika tǝteni. Nga tǝni kat i na mbǝnanda faɗengnǝfǝwa, paɗ i na mbǝnanda nofchǝfǝ oi, kǝthlǝm kǝ hǝrǝknda. ");
INSERT INTO bvw_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Sakamnji nda i nati sak Kǝrǝsti. ");
INSERT INTO bvw_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Nja hamkuni kǝthlǝm la kuɗukkuni nji chika hurmi, kishshuni ichi sakandǝ kuni har ɗichin nda i fǝrandi kuni. ");
INSERT INTO bvw_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Yah kisi kǝ sǝnuniwa le naka inn chikawun hishnifa Kǝrǝsti, le naka inn chikawun nuhnifa, hishnifa, le naka inn Kǝrǝsti Fara. ");
INSERT INTO bvw_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Chikawun hishnifǝ hwanka ndu tǝ mbu'ǝn icha Fara indǝ'ena supta, njirtǝ Kǝrǝsti le nak mwanchinna mbanitǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Chikawun nuhnifǝ hwanka, ndu tǝ mbu'ǝn icha Fara supwawutǝ i'ndǝwa, njirtǝ sǝmahha le nak mwanchinna mbanitǝkǝn, nakǝn keeke tǝ hǝsandǝ i'ndǝ'enaɗi. ");
INSERT INTO bvw_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Ma cher nuhnifǝ supwandǝ i'ndǝ'en, kǝ hǝsaǝn hwasǝ'enaɗi. Manakǝn harǝfatsi ma hǝsa nuhnifǝ hwasǝ'enaɗi ndu kǝ hǝsangkaɗǝ tukulmur, kǝ supwaǝn. ");
INSERT INTO bvw_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Kamusi hishnifǝ kǝ supwa'ǝn i'ndǝ'enwa, nakǝn kǝ mirshingta paɗ mwanda Fara. Nuhnifa paɗ mwanda hishnifa. ");
INSERT INTO bvw_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Kǝthlǝm a tǝrkakǝn hishnifa nga chekna fata nuhnifǝwa, nuhnifǝ cheka fata hishnifa. ");
INSERT INTO bvw_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","Su fichǝ hishnifǝ kǝthlǝm nuhnifǝwa, nuhnifǝ sǝt fichǝ kǝthlǝm hishnifa. ");
INSERT INTO bvw_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Kǝthlǝm ndǝkǝn sokkǝn waat nuhnifǝ kǝ kǝnǝn ɗankwali i'ndǝ'en, che sakǝtkǝna sǝmah nak mwanchin, paɗ kǝthlǝm mala'ikacha. ");
INSERT INTO bvw_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","Chika tǝkichu, a hur Lǝmwanda nuhnifǝ nga somǝnhi tǝ hishnifǝwa, hishnifǝ paɗ nga somǝnhi tǝ nuhnifǝwa. ");
INSERT INTO bvw_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Nda i nat nuhnifǝ chekna fata hishnifa, kichu paɗ nuhnifǝ ngǝtkǝ hishnifa. Ichi nat paɗ ɓaknda mbǝɗa Fara. ");
INSERT INTO bvw_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Yaramǝnhi tǝ inchengnuni, keekesi nuhnifǝ kǝ hwanaǝn Farǝ tǝ indǝ'en chaawa? ");
INSERT INTO bvw_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Sakkawu nathi kǝmharwa ma mel hishnifǝ hwasǝ'en njang, nga ǝnat harǝfata mbǝɗ'enwowa? ");
INSERT INTO bvw_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","Ma hwasa nuhnifǝ njang nga mwandǝ'enwa? Fǝrang fichǝ hwasǝ njang kichuyu kǝthlǝm kǝ ngǝlaǝn i'ndǝ'ensi. ");
INSERT INTO bvw_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","Ma yunǝsǝ nat halǝ'indǝ'ensi kǝ ɗar iniyu, kanang sǝnwani ɗǝsǝchǝ somǝnwa, nakǝn kichu mbǝɗa tahhǝt nofcha Fara. ");
INSERT INTO bvw_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Kǝ ichiya hamwi kuniwa, kǝthlǝm ma hwimunihi nga i katkǝnwa i sǝɓkǝn. ");
INSERT INTO bvw_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","A tǝrkakǝn, sǝkkiwa ma hwimunihi humta fa tǝrmbanda, a lanak saktǝhisa hurnuni. Ɓeɗi fǝrkita ɗar shuwunkǝn nguɗeh kicha. ");
INSERT INTO bvw_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Sokkǝn waat kǝ mbǝs fichǝ saktǝhi hurnuni, kǝthlǝm kǝ sǝnfichǝ fa kachita hurnuni. ");
INSERT INTO bvw_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","Ma hwimunihi nga jibi Lǝmwandǝ la sǝm tuniwa. ");
INSERT INTO bvw_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","Kǝthlǝm a chikǝn, chikawun la ɗǝkna mban tǝ sǝm ɗǝsǝmtǝ'en pu'utǝ nifǝwa. Yunǝ tǝ mita fa, yunǝ ngeli har tǝraɗa. ");
INSERT INTO bvw_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","Nga hurechengnunisǝ kǝ sǝmuni kǝ suni hurkǝnwowa? Tǝ njiruni fa tǝrmbanda Fara, paɗ kǝnuni ɓahhandǝ fichile nguchit ichengnandǝsi? Mǝnati mbwa'anda kuni? Kǝ hamikuni kǝ iniyuwa? Auwa ngi hamkuniwa. ");
INSERT INTO bvw_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","I fǝrandi kuniya thlǝki mbǝɗa Lǝmwanda ndatwa: Lǝmwandǝ Yǝso, a fiɗiki fǝrtǝ fichǝndi, tǝrkǝn njohma, ");
INSERT INTO bvw_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","ɗifitǝ sǝt usoko'en, chichaanhi ndakǝnwa: \"Faɗengnǝniya, fǝrtǝ fichǝ kǝthlǝm kunang. La sam kichu kǝthlǝm kuɗuktǝ tǝnji.\" ");
INSERT INTO bvw_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Mbandǝ ǝrtǝ paɗ, ɗifitǝ jibi tǝkǝn tǝrkǝn kop, ndakǝnwa: \"Koptiya i yuwa ɗǝf shundǝhi a hur fwarengna. Sam kichu nat kǝ farǝ natuni sata kǝthlǝm kuɗuktǝ tǝnji.\" ");
INSERT INTO bvw_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Chika kwat natuni chi njohmiya, paɗ natuni sata a koptiya, nuni mbu mǝrtaɗa Lǝmwanda kǝ fari natna ɓata. ");
INSERT INTO bvw_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Kǝthlǝm ndǝkǝn, nat le chiikǝ njohmiya, sheɗɗa hur kop ti Lǝmwandǝya nga hur chiɗchiɗchitwa, shiɗtǝ ɓǝɓichitfat kǝ fata tǝ fwara Lǝmwanda. ");
INSERT INTO bvw_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Chikawun kǝ kikeɗaǝn fat'en, kana chi njohhǝmkǝn paɗ kana sata koptǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Kǝthlǝm chikawun chiika a sheɗ paɗ ngatǝ mwanandǝ fatkǝna Lǝmwandǝwa, paɗ saɗǝ sakmiya fat'ensi, tǝ mbǝɗa chi'ini tǝ saɗini'enyu. ");
INSERT INTO bvw_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Ndǝkǝn sǝka nofchǝ oi a hurnuni alchiɗengnandǝsǝwa, funǝ haachinnda, paɗ terchina hurnuni a mirnda. ");
INSERT INTO bvw_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","Ma yaraɗǝm inchengnǝmhi poo, ngu ficha sakamiya kǝmwa. ");
INSERT INTO bvw_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","Ma Lǝmwandǝ sakang miyakǝm, na ficha eltandǝkǝm kǝthlǝm mǝ thlandǝ kita kǝmsǝ tǝ kisshitǝwa. ");
INSERT INTO bvw_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","Kǝthlǝm ndǝkǝn hwanmanchina, ma hwimunihi kǝthlǝm sǝm'ǝna, kǝ pu'uni ndani. ");
INSERT INTO bvw_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","Ma yunǝsǝ tǝ mitafa, kǝ sǝmǝn'ǝna huri, kǝthlǝm humtengnuni mǝ ɓandǝ thlet shunda kuniwa. Kǝ ɗar tahhǝt icha, ni mbwa'a mbachǝkǝna kuni ma ɓeɗi. ");
INSERT INTO bvw_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Nakǝnya paɗ hwanmancha, pathlǝ fǝr shemeɗ somsomǝn, yahwisǝ kǝnuni tǝ ɓahsǝndǝwa. ");
INSERT INTO bvw_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","Shinuniwa fari natuni nga fa tǝrmbandǝwa, limfichǝ kuni paɗ shekɗang fichǝ kuni kǝ fa kuwur ɗǝhhachi nguchit shishingchengnandǝsi. ");
INSERT INTO bvw_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Kǝthlǝm ndǝkǝn yahkǝsi kǝ sǝnuniwa nifǝsǝ na shunda hur Shemeɗa Fara na ndatwa: \"Yǝso nga'ǝn nakǝnwa\" paɗ nifǝsǝ na ndatwa: \"Yǝso Lǝmwandǝ nakǝn.\" Manga nakna hur Shemeɗ Chiɗchiɗ wa. ");
INSERT INTO bvw_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Nakǝnya fǝrtǝsǝ somǝn somǝn, Shemeɗ ǝrtǝ la fǝrkǝ kanda. ");
INSERT INTO bvw_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","Mbachǝsi somǝn somǝn i sǝt torcha, chika kichu Lǝmwandǝ ǝrta. ");
INSERT INTO bvw_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","Torchǝsi somǝn somǝn, chika kichu kǝmka Farǝ ǝrtǝ la fǝrkǝ tori nat chikawuna sǝta. ");
INSERT INTO bvw_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Chikawuni fǝra Farǝ mba ɓata Shemeɗa kǝthlǝm kǝ kǝsangka chikawunsi. ");
INSERT INTO bvw_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","Yuna fǝrang fichǝ Shemeɗ mbǝr shunda, tǝpaɗ yuna Shemeɗ shuwun sǝn'ǝna, natyu tǝ mbǝɗa Shemeɗ ǝrta. ");
INSERT INTO bvw_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","Yuna i fǝrkit tǝ mbǝɗa Shemeɗ ǝrta, yuna i kǝnandǝ nofcha ɗi tǝ mbǝɗa Shemeɗini ǝrtǝyu. ");
INSERT INTO bvw_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","Yuna fǝrangndǝ alchit sǝt ǝnat pǝɗandǝ nifǝfa, yunǝ i mbu icha Fara le na sǝt kǝmban, yuna i mbǝla sakandǝ shemeɗchǝhi, yuna i sǝn hanshuwunchǝ somǝn somǝn, yunǝ paɗ mbǝla sǝn i nat hanshuwunchi somsomǝnna mbuta. ");
INSERT INTO bvw_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","Ichini natyu tora Shemeɗ ǝrtǝ la sǝk kanda, le la sakangnga chikawun nda i yahtǝn. ");
INSERT INTO bvw_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Nda i nat fat ǝrta njarǝchi'en terchin, chikama sokkǝn njarǝchi'en terchin, nakndǝ kǝ fat ǝrta, nak Kǝrǝsti kichuyu. ");
INSERT INTO bvw_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Sangfichi baptisma kǝm nattǝm tǝ Shemeɗ ǝrta kǝ hur fat ǝrta, ndu Yahudawecha, punofcha, ndu mafecha, ndu fichile thlǝk inchengnandaɗi, nattǝm ɗǝfkǝ fichǝkǝm kǝsǝma hur Shemeɗ ǝrta. ");
INSERT INTO bvw_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Fatkǝn nga tahsang fichǝ tǝ njarǝ ǝrtǝwa, paɗ njarǝchǝkǝn terchin. ");
INSERT INTO bvw_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","Mana sara ndatwa: \"Njang nga har nakiwa, makichu nga naki fa fatwa.\" Mbutǝ kichu ngu ɗǝfndǝ kǝ sakndǝhi tǝ njarǝchikǝnna fatkǝnwa. ");
INSERT INTO bvw_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","Ma na thlǝmata ndatwa: \"Kǝthlǝm njang nga hwanitǝwa, makichu nga naki fa fatwa.\" Mbutǝ kichu ngu ɗǝfndǝ kǝ sakndǝhi tǝ njarǝchikǝnna fatkǝnwa. ");
INSERT INTO bvw_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","Ma fatkǝn nat kǝ hwanita, nakficha la sǝkmbǝt tǝ mi? Ma fatkǝn nat kǝ thlǝmata, nakficha la sa mbǝt tǝ mi? ");
INSERT INTO bvw_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","Kittǝkǝn Farǝ tahsang njarǝcha hur fata, chikayeni nda i yahtǝn kǝ nandǝsi. ");
INSERT INTO bvw_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","Ma nak fatkǝn nat kǝ njarǝchǝ ǝrta, nak fatkǝna natwa kǝni? ");
INSERT INTO bvw_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","Nda i natǝn, njarǝchǝ terchin chika kichu fat ǝrta. ");
INSERT INTO bvw_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","Hwanitǝ ngu ndanda harwa, \"Kǝmiwu'ǝntǝsǝwa.\" Ndu inda kǝ ndangka harchǝwa, \"Kǝmiwu'ǝntǝkuniwa.\" ");
INSERT INTO bvw_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","A mbandǝ somǝn, njarǝchi fafat la kǝlandǝ fichǝwa nda nga kwaakwa'a ndǝwa, kandang naka kechikǝn, ");
INSERT INTO bvw_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","Njarǝchi fafat la kǝlandǝ fichǝ nda nga ǝnnakndǝwa, kandang la mwanandani kaǝn. Njarǝchi kamuchiksi kǝ nafichiyu, la kǝlak fichasa kanda, ");
INSERT INTO bvw_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","njarǝchi'engnǝm nak ndiichinyu, nga ma safichǝ ǝn kandǝwa. Humang Farǝ njarǝcha fata, nda i ngǝrandǝn njarǝchi farawuchit fichi mwanda, sokkǝn tǝ mwanda fa. ");
INSERT INTO bvw_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","Sǝkǝn iniyu kǝthlǝm mǝni saktǝhisa hur fatwa, njarǝchikǝn kǝ la tǝrndǝwa nakndǝ nat keeke. ");
INSERT INTO bvw_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","Ma njarǝsǝ ǝrtǝ naka ɓahta, nat ndǝ nanda nata hur ɓahta, ma njarǝsǝ ǝrtǝ fǝrandǝ fichǝ mwanda, nat njarǝchikǝn kǝ mbǝnndǝ fata. ");
INSERT INTO bvw_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Nakǝnya kunang naka fata Kǝrǝsti, chikawun ǝrta hurnuni nakǝn kǝ njarǝchi'en. ");
INSERT INTO bvw_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","A kǝtǝn mwanandǝ Fara hertǝ nofchǝhar, saǝn funa tǝrkakǝn kǝ Fathlǝncha, chapatǝkǝn Tapǝnecha, mǝkkatǝkǝn fa sakaɗaɗi, funǝ fa sǝt ǝnat pǝɗandǝ nifǝfa, funǝ fa kǝnandǝ nofchaɗi, funǝ fa kǝsanda nofchǝsi, funǝ fa kǝlandǝ tora nofcha paɗ funǝ fa shundǝ tǝ hanshuwunchǝ somsomǝn. ");
INSERT INTO bvw_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","Nat fatǝrmbakǝn fathlǝnchǝwa? Nat fatǝrmbakǝn tapǝnechǝwa? Nat fatǝrmbakǝn fa sakandaɗaɗiwa? Nat fatǝrmbakǝn fa sǝt ǝnat pǝɗandǝ nofchǝfǝwa? ");
INSERT INTO bvw_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","Nat fatǝrmbakǝn fa mbǝs fǝr kǝnandǝ nofchandǝwa? Nat fatǝrmbakǝn fa shundǝ tǝ hanshuwunchǝ somsomǝnwa? Nat fatǝrmbakǝn fa mbu sakǝt i shuwuntǝ fichǝ tǝ hanshuwunchǝ somsomǝnwa? ");
INSERT INTO bvw_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","Paɗ kam fǝrtǝ somsomǝn tǝ rahta fichile nak ka mwanchin. Ni cheɗa mbanda kuni le sherkǝ nat tǝ ndata. ");
INSERT INTO bvw_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","Chikama la mbǝrki shundǝ tǝ hanshuwuncha nofcha tǝ i Mala'ikacha, nakǝn mbǝnfatsa faɗengniwa, sokki nda pupwandǝra lǝ la tik kaǝn, manga kichuwa nda thlǝmra. ");
INSERT INTO bvw_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","Chikama fǝrtengnǝsi i mbu'icha Fara paɗ la mbǝsayi ichi ɓuɓweeta tǝ sǝndǝ nat, ma fǝrkitchiɗengnǝsǝ kaǝn ni mbǝla mbasandǝ shohlachaɗi nga mbǝnfatsa faɗengniwa nga ǝn nakiwa. ");
INSERT INTO bvw_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","Chikama ni fǝra ichi naksengnǝ nata fa ɓahcha kǝ fǝri faɗengna kǝ 'yangfichaɗi manga mbǝnfatsa faɗengniwa, ǝnsǝ nati mbǝstisǝwa. ");
INSERT INTO bvw_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","Mbǝnfata kǝrǝstǝ'ensi, tǝ kafata, sǝrǝhtǝsa hur mbǝnfatwa, thla'andǝ'ensǝwa, mwa'indǝsǝwa. ");
INSERT INTO bvw_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","Mbǝnfata thla'indǝsǝwa, yah'indǝsa hur mbǝnfatwa, sǝɓhursǝ paapawa, kǝs'ǝnsahurwa. ");
INSERT INTO bvw_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","Mbǝnfata yahutǝ sǝɓfatwa, la mbǝnkǝnfat kǝ i sǝtficha ɗar kit. ");
INSERT INTO bvw_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","Mbǝnfat la nakǝn tǝ kǝrǝstafa kǝɗing chika hur witǝmi, la nakǝn tǝ fǝrkit hur chikamǝ nat, la ɗǝfkǝn hanndǝkiketa ichinat, la kǝrǝskǝn tǝ ichinat. ");
INSERT INTO bvw_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","Tamu mbǝnfata tuɓwatwa kǝparee. Mbu'ichi Farǝ na sǝt kǝmban nan thlǝrǝttaɗi, shundǝ tǝ hanshuwunchi somsomǝn nan shekata, sǝn'ǝna nan thlǝrǝttaɗi. ");
INSERT INTO bvw_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","Sǝn'ǝnengnǝm nǝhɗuhiwa. Mbu'ichi chandǝ Fara kish ngǝ mbǝɗengnǝm nǝhɗuhiwa. ");
INSERT INTO bvw_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","Ma ɓeɗ le nǝhhǝɗkǝhi, le nǝhɗuchikhi nan thlǝrǝttaɗi. ");
INSERT INTO bvw_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","Thlahmbǝɗi nati kǝ hweya, la shuwunkǝ nda hweya, la yarki nda hweya, la mbuki ichi kamkǝsi nda hweya. Kǝ sǝkti nifa, malayi hwanchita. ");
INSERT INTO bvw_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","Nakǝnya la nakǝm nda a hur shishing'ama, shummǝ shumma, farǝkǝn nakma nat hwanitǝ tǝ hwanita. Sǝn'ǝnengna nakǝnya nǝhɗuhiwa, a farǝkǝn na sǝɗengna nǝhhatǝhi nda i sǝntǝfichinji ndiichin. ");
INSERT INTO bvw_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","Nakǝnya, ichi mǝkkanya shokndǝ kichu, fǝrkit, ɗǝf hanndǝkiketǝsi, tǝ mbǝnfata. Le nak mwanchina hurnanda mbǝnfata. ");
INSERT INTO bvw_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","Kwe'yamhi kǝ kuni mbǝnfata, kǝ kuni fǝrta Shemeɗ Chiɗchiɗ, nda i yah mbu ichi naka yara Fara. ");
INSERT INTO bvw_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","Kǝthlǝm le la shuwunkǝ tǝ hanshundǝ somǝn, nga tǝ nofchǝ natna shundǝwa tǝ Fara, nifǝsǝ la sǝnkǝ i natna mbutǝwa, la mbukǝn icha ɓuɓweeta mbǝɗa alchita Shemeɗa. ");
INSERT INTO bvw_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","Le la mbukǝ ichi na yara Fara, na shunandǝ nofcha kǝ tinaǝn kanda, kǝ chekaǝn alchita kanda, kǝ saǝn sǝssi kanda. ");
INSERT INTO bvw_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","Le naka shundǝ tǝ hanshundǝ somǝn naka tinaɗǝ fat'en, paɗ le naka mbu'ichi na yara Fara tinaɗǝ fatǝrmbanda. ");
INSERT INTO bvw_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","Yahkisi natuni kǝ shununi tǝ hanshuwunchǝ somsomǝn, ɓureɗi yahtǝ kǝ mbu'uni ichi na yara Fara. Le la mbukǝ ichi na yara Fara, sheraɗa le la shuwunkǝ tǝ hanshuwunchǝ somsomǝn, ma mbwi yunǝ hanngalǝ i mbutǝn, kana tinandǝ fatǝrmbanda. ");
INSERT INTO bvw_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","Nakǝnya hwanmancha, ma ɓeɗi mbǝskuni nja shundǝ tǝ hanshuwuncha, mǝ natna chekanda kuni ma mbwa'awi hangngalǝ shuwunkǝna kuniwa, ndu sǝnda, ndu ichi na yara Fara, ndu sakandaɗi? ");
INSERT INTO bvw_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","Nakǝn kichu tǝ ichi nguchit shishingtǝsa fechengnanda, nda kǝla'a tǝ ǝnat pecha, ma chu ɓurechengnanda kish ɗiichinwa, wun na sǝn i nat ficha futa tǝ i nat ficha peta? ");
INSERT INTO bvw_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","Ma pyawu fichǝ kutmetǝ keeke tǝ i nat ficha sǝndǝwa, wun na sǝhatǝfǝ kǝ mbata? ");
INSERT INTO bvw_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","Nakǝn kichu mbǝɗengnuni, ma shununi tǝ hanshuni mbǝsauchit ficha, nakficha sǝn i mbutuniwa kǝni? Shuwunkuniyu mere pǝɗakna hur rǝnna'a. ");
INSERT INTO bvw_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","Michisi somsomǝna hur kisshita, chika yen miya tǝ sakǝtkǝnsi. ");
INSERT INTO bvw_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","Ma sǝnwi sakǝt mikǝnwa, naki nat kǝ roma mbǝɗa lǝ shuwunkǝn, lǝ shuwunkǝn paɗ nakǝn kǝ roma mbǝɗengna. ");
INSERT INTO bvw_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","Nakǝn kichu mbǝɗengnuni, nakuni tǝ ɓwechit hura a ɗar mbǝs fǝr Shemeɗchi somsomǝn, fǝram alchiɗengnuni kǝ suni tor tǝ fǝr Shemeɗǝ na tinandǝ fatǝrmbanda. ");
INSERT INTO bvw_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","Kǝthlǝm ndǝkǝn, chikawun na shundǝ tǝ hanshundǝ somsomǝn kǝ hwanǝn kǝ fǝrang fichǝ mba sǝn i mbutǝn. ");
INSERT INTO bvw_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","Kǝthlǝm ma hweni tǝ hanshundǝ somǝn, shemeɗengnǝ hwanka, paɗ yarengnǝ cheku tǝ ǝnwa. ");
INSERT INTO bvw_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","Mǝnati sǝta? Ni hwandǝ tǝ shemeɗengna, ni hwandǝ tǝ yarengnǝ paɗ. Ni ǝn'imshi tǝ shemeɗengna, ni i'ndǝ tǝ yarengnǝ paɗ. ");
INSERT INTO bvw_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","Manga kichuuwa, masa sǝt usoko tǝ shemeɗeku, tǝ kǝni le naka kuthlǝmata mbǝsauchik hanshuniniyu ndatwa: \"Kǝ sokǝn kichu wa kǝnǝ.\" Kǝ ɗar usoko tǝ natu sǝta, ma sǝnutǝ i natu mbutǝwa? ");
INSERT INTO bvw_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","Chika sokkǝnwa shiɗi usoko kaǝn, ǝnsǝ chekandǝna le nak nduk tǝsǝ le sǝnuchikwa. ");
INSERT INTO bvw_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","Saɗi Farǝ usoko sheraɗi kuni tǝ shundǝ tǝ hanshuwunchǝ somsomǝn. ");
INSERT INTO bvw_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","Chika kichu, a hur kǝtǝn hwanda kweshikǝn kǝ mbu'i ichi ɗurman tǝ hanndǝkiketengna kǝthlǝm kǝ sakayi funǝhar mǝni mbu ichi aru kumchitkum (10,000) tǝ hanshundǝ somsomǝn. ");
INSERT INTO bvw_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","Hwanmancha, malamǝn yarǝ'ichǝ nda hwecha. Kǝnuni hwecha a hur ɓǝɓichitfata, kǝnuni pǝktecha hur yarengnuni. ");
INSERT INTO bvw_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","A hur kus yara fichǝhiwa: \"Tǝ mbǝɗa nofcha fa hanshuwunchǝ somsomǝn paɗ tǝ miya romcha nati shundǝ tǝ nofchiya, chika tǝkichu ngunda kithlǝmatwa, ndat Lǝmwanda.\" ");
INSERT INTO bvw_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","Awi shundǝ tǝ hanshuwuncha nakndǝ kǝ sakǝtkǝn nga kǝ mbǝɗa fa fǝrkitwa kǝ mbǝɗa fa ɓahfǝrkit. Mbu yara Fara i fafǝrkit nga i fa ɓahfǝrkitwa. ");
INSERT INTO bvw_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","Kǝthlǝm ndǝkǝn ma hwim fatǝrmbandǝhi, kana chikawunna nata shundǝ tǝ hanshuwunchi somsomǝn, nakǝn funǝsǝ mbǝsaundǝ i nat ficha sǝtwa, ndu funǝ fa ɓahfǝrkit yimkǝsi, ngunda ndatwa nga nakuni hur'inchǝwa? ");
INSERT INTO bvw_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","Ma chikawuna mbu yari Farǝ na sǝtta, kana lǝ ɓahfǝrkit ndu yunǝ roma yimtǝsi le sǝnuchik i nat ficha sǝtta, ɓak shunda chikawuna tǝka harfa a kakǝn tǝrtǝhi. ");
INSERT INTO bvw_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","Naficha chaɗǝ ɓuɓwee ichi kissha hanɗǝkiketǝ'enyu, tǝ kichu hǝmkǝnhi mwanaǝn Fara ndakǝnwa: \"Kittǝkǝn Fara hurnuni.\" ");
INSERT INTO bvw_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","Mǝ natma mbuta hwanmancha? Ma hwimunihi yuna imshǝ'ensi i mwanandǝ Fara, yunǝ sakandaɗi, yunǝ mbu'icha, yunǝ shundǝ tǝ hanshundǝ somsomǝn, yuna fǝr hanngalǝ shunda. Sam ichǝnat kǝthlǝm tinandǝ fafǝrkit. ");
INSERT INTO bvw_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","Mana yuna shundǝ tǝ hanshundǝ somsomǝn, mǝ sheraɗa nifǝ chap ndu mǝkkanwa, kǝ sǝndǝ ɗeɗerra paɗ yunǝ kǝ fǝrǝn hanngalǝ shuwunkǝn. ");
INSERT INTO bvw_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","Manga yunǝsǝ na fǝr hanngalǝ shuwunkǝnwa, chikawun kǝ ngasǝn ɓa'a hur fatǝrmbakǝn, kǝ shunaǝn fat'en tǝ Fara. ");
INSERT INTO bvw_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","Tapǝnechǝ chap ndu mǝkkan kǝ shuwunnda, tahchikǝn kǝ kikeɗangndǝ hǝɓakkǝ i mbutǝnda. ");
INSERT INTO bvw_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","Ma yunǝsa mbǝnniyu ɗas ɓat sǝn'ichikǝna mbǝt'en, le naka shunda tǝrkakǝnyu kǝ ngasǝn ɓa. ");
INSERT INTO bvw_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","Natuni nuni mbǝla mbu ichi na yara Fara ǝrtǝ ǝrta, kǝthlǝm kǝ sak chikawuni paɗ kǝ mbǝs chikawun alchita, ");
INSERT INTO bvw_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","Tapǝnecha la mbǝllakǝndǝ hǝrǝm inchengnandǝ har. ");
INSERT INTO bvw_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","Fara nga Farǝ la shekɗandǝ i'ndǝwa, i yuyurchita. Nakǝn kichu mbǝɗa fatǝrmbaɗǝ chiɗchiɗ, ");
INSERT INTO bvw_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","kǝ ngas nishchǝ ɓa a hur kǝtǝn hwacha. Kǝthlǝm fǝrau fichǝ mbanda kandǝ kǝ shuwunndǝwa, kǝ kuwurndǝ ndak nda i mbutǝ kus. ");
INSERT INTO bvw_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","Ma ǝnsǝ yahtǝnda sahta, kǝ sahhangndǝ hishchǝngnanda huri. Kǝthlǝm ǝnat harǝfata kǝ shuwun nuhnifa a hur kǝtǝn hwanda. ");
INSERT INTO bvw_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","Tǝrkaakǝ shunda Fara ɓat tǝ mbǝɗengnuniwa, ndu kunang ndak sa'andǝn? ");
INSERT INTO bvw_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","Mala yarkǝ yunǝwa tapǝnaa nakǝn, ndu le mbǝskǝ fǝrta shemeɗa, kǝ sǝnǝnwa ichi nati yaranda kunisǝya mbuta Lǝmwanda. ");
INSERT INTO bvw_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","Ma cher yunǝ mbǝnnifiyu, mǝlan ma kǝ cherunindǝfa. ");
INSERT INTO bvw_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","Kǝthlǝm ndǝkǝn hwanmancha, namtǝ ɓweechit hur mbu ichi na yara Fara paɗ mǝ malaɗuni shundǝ tǝ hanshuwunchǝ somsomǝnwa. ");
INSERT INTO bvw_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","Kǝ suni chikama a mbayi kamkǝsi, paɗ a hur tahhasǝkǝn. ");
INSERT INTO bvw_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","Nakǝnya, hwanmancha, ni kuɗkanda kuni kwescha shuni ɓassandi kuniyu, le thlǝtuni thlartuni ɗarkǝn. ");
INSERT INTO bvw_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","Tǝ mbǝɗa kwescha shuwunkǝn hǝrǝktuni, ma kisshuni shunihar mbwa'andǝ kuni kwaakwaa. Manga kichuuwa fǝrkit engnuni mere. ");
INSERT INTO bvw_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","I kamkǝsi sǝnandi kunisi, ndǝkǝn naka i thlǝta, ndatwa: \"Kǝrǝsti mǝrkǝnaɗi kǝthlǝm ɓǝɓichitfechengnǝm, nda i natna hur yarat laulawata Farǝ le mbutǝn, ");
INSERT INTO bvw_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","ndatwa thloha ficha, farǝ mun mǝkkatǝkǝn thla'aficha, nda i natna hur yarat laulawatkǝn, ");
INSERT INTO bvw_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","cheɗaɗǝ fat'ena Kefas kana fichile kumngǝrǝnsǝ chapyu. ");
INSERT INTO bvw_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","Kana cheɗa fat'ena hwanmancha fichile sheranga aru ɗurman (500) a farǝ ǝrta, mweefunǝsi tǝ shisshingtafa, chikama sokkǝn funa mirnda. ");
INSERT INTO bvw_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","Kana cheɗa fat'ena Yakubu, tǝ tahhǝt fathlǝnchǝkǝn nat. ");
INSERT INTO bvw_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","A mweshitkǝn nat, cheɗikǝn fata, nda le ngǝttǝ ficha a fari kamuchiksǝ. ");
INSERT INTO bvw_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","Kǝthlǝm njang naka mweshitmiya fathlǝncha, kamuchiksǝ kǝ afichǝwa lǝthlǝnda, kǝthlǝm fǝraɗi ɓahta fa tǝrmbanda Fara. ");
INSERT INTO bvw_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","Tǝ mbǝɗa kafata Fara nati kǝ i natiya, kafat'en kǝ mbǝɗengna nga merewa. Shiɗi tor sheraɗi chikawuna hurnanda, chikama sokkǝn nga njangwa, kafaɗi Farǝ nak tǝ njiyu. ");
INSERT INTO bvw_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","Ndu njang ndu kaɗang, ɓasskani kichuyu, tǝ kichuyu paɗ fǝrtuni kit. ");
INSERT INTO bvw_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","Ma ficha ɓassǝ thlata Kǝrǝsti a hur mǝmatcha, mǝsǝk la ndat funengnuniwa thlata mǝmatchǝsǝwa? ");
INSERT INTO bvw_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","Ma nga thlata mǝmatchǝsǝwa, sokkǝn chika Kǝrǝsti thla'awu fichǝwa. ");
INSERT INTO bvw_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","Ma thlaawu fichǝ Kǝrǝstiwa, ɓassengnani pofǝn, fǝrkitchiɗengnuni pofǝn. ");
INSERT INTO bvw_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","Ma tana nakǝn kichu, shiɗani fa lekta Fara, kǝthlǝm shiɗani sheta kǝ ɗar Farǝwa thla'aɗǝ Kǝrǝsti hur mǝmatcha, le thla'awuchitǝn, ma tǝ kitwa thla'awu fichǝ mǝmatchǝwa. ");
INSERT INTO bvw_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","Kǝthlǝm ma thla'awu fichǝ mǝmatchǝwa, sokkǝn Kǝrǝsti ma thla'awu fichǝwa. ");
INSERT INTO bvw_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","Ma sokkǝn thla'awu fichǝ Kǝrǝstiwa, fǝrkitchiɗengnuni pofǝn paɗ paaya mwakuni hur ɓǝɓichitfechengnuni. ");
INSERT INTO bvw_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","Sokkǝn fichile fǝrkǝkitta hur Kǝrǝsti, kannda mǝrtaɗi thlǝrǝtkǝndaɗi. ");
INSERT INTO bvw_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","Ma ɗǝfǝm hanɗǝkiketengnǝm kǝ Kǝrǝsti kǝthlǝm naɗihiya ɗeng, sheraɗima chikawun kǝ ǝnat haɗandǝ nifǝfa. ");
INSERT INTO bvw_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","Kitchitkǝn thla'afichǝ Kǝrǝsti a hur mǝmatcha, mǝlan naka tǝrka thlata fichile mǝrkaɗi. ");
INSERT INTO bvw_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","Nakǝn ɓak murtǝ tǝ mbǝɗa nifa ǝrta, tǝ mbǝɗa nifǝ ǝrta paɗ ɓat thlata mǝmatcha. ");
INSERT INTO bvw_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","Nda i nat ficha mǝmattǝ kǝthlǝm Adamu, kichu paɗ kǝthlǝm Kǝrǝsti nat ficha thla'andǝ nofchǝ nat. ");
INSERT INTO bvw_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","Nak thlakǝna nata ndera chikawun tǝ witǝ ikǝn, Kǝrǝsti na nata tǝrkakǝn, kana fichile naka ikǝn a fari natna ngǝrandǝ'in. ");
INSERT INTO bvw_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","Kana mweshitmikǝna ɓata, fari natna fǝra kuturǝchita Fara Shinda, ɗifitǝ wuwwelandǝ fa kuturǝchitaɗi, nat tǝ kuturcha tǝ alchita. ");
INSERT INTO bvw_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","Waat nan sok kuturǝchita, kana ɗǝf atikrechikǝn kǝ ka sarǝchi'en. ");
INSERT INTO bvw_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","Hanmurtǝ naka mweshitmi atikretǝkǝn ti natna ɓǝllanda. ");
INSERT INTO bvw_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","\"Kǝthlǝm shiɗtǝ ichinat kǝ ka sarǝchi'en\" Ma ɗeɗfichǝwa: \"Shiɗtǝ ichinat kǝ ka sarǝchi'en\", cheɗakissha ɗwaachitkǝnwa nga nat tǝ Farǝ tǝ indǝ'enwa, le ɗǝfkǝ chikamǝnat kǝ ka Kǝrǝsti. ");
INSERT INTO bvw_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","Kǝ ngǝrandǝ Farǝ ichiniyu kǝ ka sarǝchi'en, hwankǝn paɗ sokkǝna ka Fara, kana Fara nata chikamǝ tǝ tǝmǝ nat. ");
INSERT INTO bvw_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","Manga thlata mǝmatchǝsǝwa, mǝnat nofchiya sǝta, fichile sandǝ fichǝ baptisma kanda kǝthlǝm mǝmatcha? Ma thla'awu fichǝ mǝmatchǝwa kǝpware, kǝthlǝmmǝ la sandǝ fichǝ baptisma nofchǝ kǝthlǝm kandang? ");
INSERT INTO bvw_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","Kǝthlǝmmǝ la natma ɗǝf inchengnǝma hur mboro chikayen hanthlǝkta? ");
INSERT INTO bvw_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","Wembǝta nja miya hanmurta! Yarkiyaa hwanmancha, kittǝkǝn la thla'ayi'indǝ kǝthlǝm kunang hur Yǝso Kǝrǝsti Lǝmwaɗengnǝm. ");
INSERT INTO bvw_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","Ma mbeɗi tǝ pǝktat hanthlucha a Afisa, kǝthlǝm yarengnǝ kǝ ɗar nifa, mǝ naka mbǝstengnǝhar? Mangu ficha thla'andǝ mǝmatchǝwa, \"Nga kwesh kǝ sǝmǝm kǝ sǝmwa nakǝn ishki nǝma mǝrta?\" ");
INSERT INTO bvw_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","Mǝ lǝmi fichǝ kuniwa: \"Soktǝ tǝ ɓǝɓinofcha la sǝɓaǝn ka hur'indaɗi.\" ");
INSERT INTO bvw_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","Ɓamaɗi kǝ hur'inchengnuni ndiichin, kǝ malanguni sǝt ɓǝɓichitfata. Kǝthlǝm funengnuni sǝnundǝ Farǝwa. Mbuki iniyu kǝthlǝm kǝ harangfat kuni. ");
INSERT INTO bvw_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","Paɗ funǝ nanda sahtǝ ndatwa: \"La thla'ang fichǝ mǝmatchǝwa kǝni? Tǝ witǝ fatmǝ natnda ɓata?\" ");
INSERT INTO bvw_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","Ɓoma! I hǝftu ngu tiftǝwa se ma mirwa. ");
INSERT INTO bvw_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","Ma hifna, nga cheta i hǝftu tǝ fatkǝn na tiftǝwa, hanwitǝkǝn ndak. Ndu i alkama ndu hanwitǝ ǝn somǝn. ");
INSERT INTO bvw_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","Farǝ la fǝrang fata hanwitǝkǝn nda i yahtǝn, paɗ chika witǝ hanwitǝmi la fǝraǝn fatkǝn'en. ");
INSERT INTO bvw_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","Nga nat thlu ǝrtǝwa, nofchǝ tǝ witǝ thlǝwengnanda ǝrta, ɗǝhǝrǝmchǝ tǝ witǝ innanda, ɗishchǝ tǝ witǝ innanda, tinchǝ paɗ tǝ witǝ innanda. ");
INSERT INTO bvw_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","Tinɗǝsi i afshi neɗsǝ paɗ i kisshita, mwanda i afshi somǝn, mwanda i kisshitǝ paɗ somǝn. ");
INSERT INTO bvw_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","Mwanda hwatfarǝ somǝn, i ndǝraa somǝn, i hanndǝrechǝ somǝn; kǝthlǝm yunǝ hanndǝraa somǝn mwandǝ'en tǝ le. ");
INSERT INTO bvw_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","Nakǝn kichu tǝ pathlǝ thlata mǝmatcha. I hǝftǝ ficha nan yirataɗi, i thla'andǝ ficha yirat'ensaɗǝwa. ");
INSERT INTO bvw_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","La hǝfkǝ ficha tǝ ɓah fǝr mwanda, thla'ang ficha hur mwanda. La hǝfkǝ ficha hur ɓah alchita, thla'ang ficha hur alchita. ");
INSERT INTO bvw_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","Hǝfkǝ ficha hur cheta fata, thla'ang ficha hur fata shemeɗa. Nakǝn fatsǝ i cheta fata, fatsǝ paɗ i shemeɗa. ");
INSERT INTO bvw_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","Nakǝn kichu hur yaratkǝn, \"Adamu tǝrka nifa sokka nifǝ tǝ shisshingtafa, ndukwalat Adamu shemeɗa lela fǝrkǝ shisshingta. ");
INSERT INTO bvw_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","Nga le naka i shemeɗ naka tǝrkakǝnwa, i punifǝchita, kana i shemeɗa. ");
INSERT INTO bvw_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","Tǝrka nifa chekna hur furta a hur kisshita, chapatǝ nifa ɓakna hur afshi ");
INSERT INTO bvw_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","Nda ini chet nifa hur furtuyu, nakǝn kichuyu tǝ fichile naka i furta. Nda i'ni nat leni hur afshiyu, kichu paɗ natna nata kǝ fichile naka i hur afshi. ");
INSERT INTO bvw_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","Nda i'ni tǝrtǝm mirshingta leni cheka hur furtuyu, kichu paɗ natma tǝr mirshingta le naka hur afshi. ");
INSERT INTO bvw_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","I nati mbwa'anda kuni, hwanmancha, ngusǝtta faɗengnǝm nda thlu tǝ fwara kǝ yimnda kuturǝchita Farǝwa. Kichu paɗ lǝ yirata ngu mbǝs ǝna a ratǝ le nguchika yiratwa. ");
INSERT INTO bvw_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","Kamthlǝmathi, ni mbwa'a ǝna kuni ɓuɓweeta. Ngǝma mǝrtǝ natǝmwa, natǝm naficha ɓuɓweɗandǝkǝmhi, ");
INSERT INTO bvw_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","Nda nakǝnya a tǝɓǝrta hwanitǝhi, a mweshitmi kutmeta. Naficha pyandǝ kutmeta, thla'ang fichǝ mǝmatcha tǝ faɗi nguchika yirata, kana ficha ɓuɓweɗandǝ kǝmhi. ");
INSERT INTO bvw_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","Kǝthlǝm faɗi na yirata waat kǝ ɓuɓweɗang fichǝhi tǝle nguchika yirata, lela mǝrkǝ paɗ kǝ ɓuɓweɗang fichǝ tǝle nguchika mǝrta. ");
INSERT INTO bvw_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","Le na yirata ma ɓuɓweɗa fichǝhi tǝle nguchika yirata, le na mǝrta kǝ ɓuɓweɗang fichǝ tǝle nguchika mǝrta, a mbǝnniyu nat i yarandǝ fichǝhi hur shunda Farǝ nan nǝhhatǝhi ndatwa: \"Mǝhɗafichǝ hanmurta, shera ficha al'en.\" ");
INSERT INTO bvw_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","\"Ai hanmurta, mbǝs'ǝnekuhara ayi? Ai hanmurta, alchiɗeku ayi?\" ");
INSERT INTO bvw_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","Alchita hanmurta ɓǝɓichitfata, kus naka alchita ɓǝɓichitfata. ");
INSERT INTO bvw_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","Usoko Fara le fǝrang mbǝs'ǝna kǝmhar tǝ mbǝɗa Lǝmwaɗengnǝm Yǝso Kǝrǝsti. ");
INSERT INTO bvw_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","Kǝthlǝm ndǝkǝn hwanmanchinǝ ti yahti, thlaramhi kit, mǝ fohha ǝnkuniɗiwa. Kǝnding kǝ fǝrunǝ fechengnuni nat kǝ tora Lǝmwanda, kǝthlǝm shinuniwa ɓahtengnunihi hur Lǝmwanda ngu nat pofǝnwa. ");
INSERT INTO bvw_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","Nakǝnya pathlǝ kǝsaanda fichilesǝ nak chiɗchiɗ, sam nda i ndaɗi mbǝt ngǝlhwanichi a Galatiyayu. ");
INSERT INTO bvw_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","A farǝ ladi, tǝrka chika yen mundǝ muɗ, chikawuni kǝla ɗǝfǝn hanndǝɓǝltǝhi kǝlar hur i la mbǝlaatǝn mbǝsta kǝ kǝsǝnhar, kǝthlǝm ma ɓeɗi mǝni hum'icha natsǝwa. ");
INSERT INTO bvw_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","Ma she'i ni thlǝn fichile hartunihar, ngǝmtuni tǝkanda, tǝ yarat ɗelwer kǝ ɗǝndǝ tǝ fǝrpofǝn engnuni kǝ Urshelima. ");
INSERT INTO bvw_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","Ma sokkǝnwa keekesi njang paɗ kǝ ɗi, natnda ɗǝfkǝɗǝnji. ");
INSERT INTO bvw_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","Ni ɓata mbǝɗengnuni ma ɗiɗi tǝ Makidoniya, kǝthlǝm yahkisi kǝ ɗi tǝ Makidoniya. ");
INSERT INTO bvw_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","Mbah kǝ si tolla mbǝɗengnuni, mbahya ma kǝ mbǝrayi fektǝhi mbǝnniyu, kǝthlǝm kǝ kǝsikunisi nat mbǝɗi nati ɗǝta. ");
INSERT INTO bvw_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","Nga yahtengna kǝnikuni nakǝnya kǝ mbǝrihi ndakwa, ɗǝfi hanndǝkiketǝsi kǝ muni tolla mbǝɗengnuni, ma ngǝma Lǝmwandǝ. ");
INSERT INTO bvw_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","Paɗ ni thlarǝhi a Afisa kǝ farǝ Pentekos, ");
INSERT INTO bvw_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","Kǝthlǝm i'ni fichǝ mikǝnndǝsǝ hauyang i tor nat tǝ mbǝs'ǝnsi chika sokkǝn atikrechisǝ kaǝn. ");
INSERT INTO bvw_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","Ma ɓeɗ Timoti, kǝ ngǝmangnguni kǝ kalǝn fathi hurnuni, kǝthlǝm mǝlan ma na sǝt tora Lǝmwandǝ nda i nati sǝtta. ");
INSERT INTO bvw_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","Mǝ cherinduni thlǝtndǝwa, kǝ kǝsangngunisa hur witǝ'en yuyur, kǝthlǝm kǝ ngǝraǝn i'na mbǝɗengna, nja kǝlata mba ɓat'en tǝ hwanmancha. ");
INSERT INTO bvw_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","Nakǝnya pathlǝ hwanmanǝm Afolos paɗ, hwanaɗi tǝ alchitafa kǝ ɗǝka mbǝɗengnuni tǝ tahhǝt hwanmancha, nakǝn nga yahtǝ'en kǝ ɗǝn nakǝnyawa. Nan ɗǝta ma mbish tǝ mbanda. ");
INSERT INTO bvw_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","Sokam tǝ tahhasǝfa, kǝ thlaruni kit tǝ alchita a hur fǝrkitengnuni, kǝnuni nda hishcha, kǝnuni tǝ alchitafa. ");
INSERT INTO bvw_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","I natuni sǝtnat kǝ suni hur mbǝnfata. ");
INSERT INTO bvw_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","Hwanmancha, shinuni nofchi hura'a Istifanus kanda tǝrkakǝ tǝrtǝhi a hur hachahai Akaya, paɗ firndǝ fechengnanda kǝ sangndǝ tora fichile nak chiɗchiɗ. ");
INSERT INTO bvw_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","Nja hwanandǝ kuni kǝ fǝranguni mwanda witǝ nofchiniyu, tǝ fichile naka shikechǝ torchengnani tǝ ɓahtengnani. ");
INSERT INTO bvw_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","Shiki mbǝndǝfǝ tǝ ɓata Istifanus, tǝ Fartunatus, tǝ Akaikus, le sokkǝ nda kunang ɓaka. ");
INSERT INTO bvw_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","Tǝrandǝ hurengnǝhi nat tǝ innuni. Witǝ nofchiniyu kǝla fǝranguni mwanda kanda. ");
INSERT INTO bvw_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","Fa tǝrmbayi Asiyayu kanda nda'icha kuni. Akila tǝ Biriskila tǝ fa tǝrmbayi la humkǝhi hure'engnandǝyu, kanda nda'icha kuni kaǝn hur thlǝm Lǝmwanda. ");
INSERT INTO bvw_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","Hwanmanchi natta mbǝnniyu kanda nda'ǝna kuni. Kǝ ndangnguni icha ndani tǝ chiɗchiɗ tǝ kǝsndanihar. ");
INSERT INTO bvw_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","Njang Bulus yarak ndat'ǝnaɗiya tǝ harengna. ");
INSERT INTO bvw_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","Ma yunǝsǝ nguchit mbǝnfat'ensi kǝ mbǝɗa Lǝmwanda, kǝnaka sǝɓkǝn. Lǝ Lǝmwada a ɓu. ");
INSERT INTO bvw_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","Kafata Lǝmwandǝ Yǝso kǝnan tǝ kuni. ");
INSERT INTO bvw_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","Malan mbǝnfaɗengna kǝnan tǝ kuni natuni hur Yǝso Kǝrǝsti. Kǝsokǝn kichu.");
ALTER TABLE bvw_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
