﻿USE sofia;
DROP TABLE IF EXISTS sofia.bvr_vpl;
CREATE TABLE bvr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bvr_vpl WRITE;
INSERT INTO bvr_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Mu-ngoyurra gun-guwarr Wangarr gu-jarlapuna gun-nardiya rrawa waykin rrapa wupa. ");
INSERT INTO bvr_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Gun-nardiya rrawa gala gun-nga rrawa gu-jirrarna. Wurra minypa an-munya a-mayana a-ji rrapa gu-gonyinyjinga bugula wupa gu-yunya. Wurra Wangarr nipa an-mawunga waykin gun-gata gu-bugula gu-guyinda a-rrigirrgarra rrapa minypa jaga a-ganana. ");
INSERT INTO bvr_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Lika Wangarr a-wena, a-yinanga, “Gu-naya barra gu-ji,” lika a na-murna gu-nayana gu-ji. ");
INSERT INTO bvr_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Rrapa nipa gu-nana gun-gata gun-molamola. Lika gu-ngorrkorndanga; gun-gujayanaya ngardapa, rrapa an-munya a-maya ngardapa. ");
INSERT INTO bvr_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Gun-gata gun-gujayanaya nipa Wangarr gu-ngurrjinga gun-nelangga ‘rrengarrenga,’ rrapa gun-gata an-munya a-maya nipa gu-ngurrjinga ‘ana-munya.’ Ganapiya. Gun-nardiya minypa yi-rrana gu-ni rrapa nuwurra guna-gepana, nipa ngorrngurra gun-nelangga minypa gun-ngardapa. ");
INSERT INTO bvr_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Lika Wangarr a-wena, a-yinagata, “Gojilapa gu-lirrjiya barra, yanma bugula gu-ngorrkorndiya barra ngardapa ngardapa.” ");
INSERT INTO bvr_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Gu-gurda ngacha minypa Wangarr gu-jarlapuna gojilapa minypa gu-lirrjiyana rrapa minypa bugula gu-ngorrkorndiyana. Minypa bugula gun-nerranga wupa gun-gata gu-lirrjiya gu-jirra, rrapa gun-nerranga waykin. Ganapiya, lika gu-yinagata gu-ji. ");
INSERT INTO bvr_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Rrapa mun-gata minypa gu-lirrjiya gu-jirra, nipa Wangarr mu-ngurrjinga mun-nelangga ‘dach.’ Ganapiya. Gun-nardiya minypa yi-rrana gu-ni rrapa nuwurra guna-gepana, nipa ngorrngurra gun-nelangga minypa abirri-jirrapa. ");
INSERT INTO bvr_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Lika Wangarr a-wena, a-yinagata, “Bugula gun-gata wupa mun-gata dach mu-jirrapa, nipa bugula barra gu-gakiya barra ngardapa, barra yanma jel gu-bengga yarlanga.” Ganapiya, lika gu-yinagata gu-ni. ");
INSERT INTO bvr_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Lika gun-gata jel nipa Wangarr gu-ngurrjinga gun-nelangga ‘rrawa,’ rrapa bugula gu-gakiyana ngardapa gun-nelangga ‘gun-bachirra.’ Rrapa nipa Wangarr gu-nana gun-gata gun-molamola. ");
INSERT INTO bvr_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Lika Wangarr a-wena, a-yinagata, “Mun-jarlarla m-bengga barra, rrawa mu-rrima barra minypa gorrngunya rrapa gun-jong balaja mu-rrimanga, minypa mipila mu-jirra mun-guyinda ngardapa ngardapa mu-rrimanga.” Ganapiya, lika gu-yinagata gu-ni, ");
INSERT INTO bvr_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","mun-jarlarla m-bena gorrngunya rrapa gun-jong balaja mu-rrimanga, minypa mipila mu-jirra mun-guyinda ngardapa ngardapa mu-rrimanga. Rrapa Wangarr mu-nana mun-gata mun-molamola. ");
INSERT INTO bvr_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ganapiya. Gun-nardiya minypa yi-rrana gu-ni rrapa nuwurra guna-gepana, nipa ngorrngurra gun-nelangga minypa abirri-jirrapa gun-ngardapa. ");
INSERT INTO bvr_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Lika Wangarr a-wena, a-yinagata, “Waykin mu-dach gun-gujayanaya gun-guyinda gu-jayanaya barra gu-ji, minypa ngardapa ngardapa gu-nega barra gun-gata rrengarrenga rrapa mola ana-munya, rrapa minypa burr-gurdagurdarra barra gu-workiya gu-yinpa barra bugula guna-warrcha barra rrapa gu-yinpa barra guy-bawa barra, rrapa minypa gu-yinpa barra jemberr gu-ni barra rrapa gu-yinpa barra warlirr gu-ni barra, rrapa minypa gu-yinmiyapa ngorrngurra gu-ni rrapa a-yinmiyapa ran.gu a-ji, gu-gurda ngacha. ");
INSERT INTO bvr_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Rrapa barrwa minypa gu-jel aburr-nirra aburr-naya barra aburr-ni.” Ganapiya, lika gu-yinagata gu-ni. ");
INSERT INTO bvr_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Gu-gurda ngacha minypa nipa Wangarr ana-nyala bijirriny-jarlapuna abirriny-jirrapa abirriny-jata wana abirriny-jayanayarra abirriny-jirra. Minypa jin-gata wana jin-babalapa nipa barra jina-darrja jina-workiya, rrengarrenga gu-ni barra gu-workiya, rrapa minypa an-gata marr a-yinaga wana nipa barra a-jayanaya a-ji a-workiya, ana-munya gu-ni barra gu-workiya. Rrapa jin-gata gata jin-guyinda burr-guta nipa Wangarr jiny-jarlapuna. ");
INSERT INTO bvr_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Lika jiny-jarrana a-garrana gun-gata gun-gujayanaya gun-guyinda yi-gata mu-dach, ngarripa gu-jel arr-nirra barra arr-naya arr-ni. ");
INSERT INTO bvr_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Rrapa minypa barra a-jayanaya jiny-jayanaya minypa rrengarrenga rrapa ana-munya, rrapa ngardapa ngardapa gu-nega barra gun-gata gun-gujayanaya rrapa mola gun-gata an-munya gu-maya gu-jirra. Lika Wangarr gu-nana gun-gata gun-molamola. ");
INSERT INTO bvr_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ganapiya. Gun-nardiya minypa yi-rrana gu-ni rrapa nuwurra guna-gepana, nipa ngorrngurra gun-nelangga minypa abirri-jirrapa abirri-jirrapa. ");
INSERT INTO bvr_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Lika Wangarr a-wena, a-yinagata, “Gu-bugula barra a-waywa jiny-yaywa jin-jaranga an-jaranga an-guwaywuya an-guyinda. Rrapa gu-jel waykin yi-gata mu-dach nipa burdacha an-guyinda burdacha jin-guyinda jin-digirrga a-rrigirrga barra a-workiya.” ");
INSERT INTO bvr_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Gu-gurda ngacha minypa Wangarr burr-jarlapuna aburr-gata wana aburr-bapala aburr-guyinda gu-bachirra minypa aburr-yurra aburr-workiya, rrapa mola an-jaranga an-gata an-guwaywuya an-guyinda gu-bugula a-yurra, rrapa burdacha burr-guta an-jaranga jin-jaranga nipa burr-jarlapuna. Lika Wangarr gu-nana gun-gata gun-molamola. ");
INSERT INTO bvr_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Lika burr-jalkakaja rrapa aburr-molamola burr-negarra, minypa a-yinanga burrwa, “Delipa nyibu-ma barra nyiburr-ni, nyiburr-jaranga nyiburr-ni barra nyiburr-bamba, garda gu-bugula minypa burr-guya nyiburr-jaranga nyiburr-ni barra. Rrapa burdacha aburr-guyinda abu-ma barra delipa, aburr-jaranga aburr-ni barra aburr-bamba gata gu-jel.” ");
INSERT INTO bvr_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ganapiya. Gun-nardiya minypa yi-rrana gu-ni rrapa nuwurra guna-gepana, nipa ngorrngurra gun-nelangga minypa murna arr-jirra arr-ngardapa. ");
INSERT INTO bvr_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Lika Wangarr a-wena, a-yinagata, “Gu-jel barra a-rrigirrga jin-digirrga jin-jaranga an-jaranga minyjak an-guyinda, minypa an-gumurna rrapa an-mugat wana rrapa an-delipa.” Lika gu-yinagata gu-ni. ");
INSERT INTO bvr_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Minypa nipa Wangarr burr-jarlapuna an-gata minyjak an-guyinda an-mugat gun-nardiya rrawa a-rrigirrgnga a-workiya, rrapa an-gumurna an-guyinda minyjak an-gata minypa ana-gugaliya a-ganyja a-workiya, rrapa mola jarrka, nguymbula an-nga burr-guta gu-jel a-rriknga a-rrigirrgnga a-workiya nipa Wangarr burr-jarlapuna ngardapa ngardapa. Lika nipa gu-nana gun-gata gun-molamola. ");
INSERT INTO bvr_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Lika nipiya Wangarr a-wena, a-yinanga, “Ngatipa barra arrbi-jarlapa gu-galiya yerrcha minypa ngatipa arri-mawunga. Birripa barra wana aburr-ni barra minypa ngatipa, rrapa wana aburr-ni barra nula gun-nardiya rrawa. Minypa jichicha an-guyinda gu-bugula a-yurra a-boya rrapa burdacha an-guyinda waykin a-boya, rrapa mola minyjak an-guyinda rrapa an-nga burr-guta gu-jel a-rriknga a-rrigirrgnga a-workiya birripa gu-galiya yerrcha wana aburr-ni barra nula.” ");
INSERT INTO bvr_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Lika Wangarr bijirriny-jarlapuna gu-galiya yerrcha. An-nurra jin-gama bijirriny-jarlapuna nipiya an-mawunga. ");
INSERT INTO bvr_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Lika nipiya Wangarr burr-jalkakaja rrapa aburr-molamola burr-negarra gu-galiya yerrcha. Minypa a-yinanga burrinyjula, “Delipa nyirrbu-ma barra nyiburr-ni, nyiburr-jaranga nyiburr-ni barra nyiburr-bamba, gun-nardiya rrawa minypa gu-ngana nyiburr-maya barra nyiburr-ni rrapa rrapa nyiburr-ninyapa barra. Minypa wana nyiburr-ni barra nula jichicha an-guyinda gu-bugula a-yurra a-boya, rrapa mola burdacha an-guyinda waykin a-boya, rrapa an-nga burr-guta an-guwaywuya an-guyinda gu-jel a-rriknga a-rrigirrgnga, ana-goyburrpa barra wana nyiburr-ni nula.” ");
INSERT INTO bvr_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","A-yinagata, “Minyja birriny-borrwa: Ngaypa ngu-barnjinga ana-gorrburrwa mun-jaranga gorrngunya rrapa gun-jong minypa mipila mu-jirra mu-rrimanga, mun-gata burr-guta gu-jong balaja mu-rrimanga, mu-gata ngacha ana-gorrburrwa balaja. ");
INSERT INTO bvr_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Rrapa minyjak an-guyinda gun-nardiya rrawa, rrapa burdacha an-guyinda waykin a-boya, rrapa jarrka, nguymbula, an-nga burr-guta gu-jel a-rriknga a-rrigirrgnga a-workiya, ana-nga an-gata an-guwaywuya an-guyinda, ngaypa ngu-barnjinga nuluwa balaja minypa gorrngunya mun-guyinda rrapa gun-jong mulu mu-jirra.” A-yinagata a-wena nipa Wangarr. Ganapiya, lika gu-yinagata gu-ni. ");
INSERT INTO bvr_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Rrapa Wangarr gu-nana gun-gata gun-bulapalawa nipa gu-jarlapuna minypa gun-narda gun-molamola warrpam. Ganapiya. Gun-nardiya minypa yi-rrana gu-ni rrapa nuwurra guna-gepana, nipa ngorrngurra gun-nelangga minypa arr-ngardapa arr-murna rrapa gun-ngardapa. ");
INSERT INTO bvr_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Gu-gurda ngacha minypa Wangarr gu-jarlapuna gun-nardiya rrawa waykin rrapa wupa, an-nga an-jaranga burr-guta a-rrigirrgnga a-workiya. ");
INSERT INTO bvr_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Minypa ngorrngurra gun-gata arr-ngardapa arr-murna rrapa gun-ngardapa, gun-nardiya wupa nipa Wangarr jama a-ji, gu-mungbuna. Lika ngorrngurra gun-gata nipa gun-nelangga minypa arr-ngardapa arr-murna rrapa abirri-jirrapa nipa Wangarr murna a-rrimiyana rrapa a-ngekarra a-ni. ");
INSERT INTO bvr_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Gun-narda nula nipa Wangarr gun-molamola gu-negarra gun-gata ngorrngurra nipa gun-nelangga minypa arr-ngardpa arr-murna rrapa abirri-jirrapa. Gun-nigipa, Wangarr gun-nika. Ngardawa gu-gatiya gu-ngorrngurra Wangarr murna a-rrimiyana nipa jama a-ji, gun-nardiya rrawa nipa gu-jarlapuna. ");
INSERT INTO bvr_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Rrapa gun-gata minypa Wangarr gu-jarlapuna gun-nardiya rrawa waykin rrapa wupa, gun-narda janguny minypa gun-gunaga. Gun-gata minypa Wangarr an-gata Ay-ninyarrapa Ay-workiya nipa gu-jarlapuna gun-nardiya rrawa waykin rrapa wupa — ");
INSERT INTO bvr_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","gun-gatiya minypa gala burdak mun-jarlarla m-beyarna gorrngunya rrapa gun-jong, ngardawa Wangarr gala burdak yorr guna-jerrmangarna, gu-bunggiyarna, rrapa gala burdak an-gugaliya a-ni rraka jama a-ji rrapa jel gu-bu, ");
INSERT INTO bvr_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","wurra jarra minypa guna-warrchinga guna-workiyana guna-gol gu-jel wenga rrapa minypa gu-gurragaja rrawa — ");
INSERT INTO bvr_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","gu-gatiya wenga gugu Wangarr an-gata Ay-ninyarrapa Ay-workiya nipa jel gu-rrimarra, a-jarlapuna an-gugaliya, lika ngoyurra a-jirra a-bipijinga barlmarrk wanngu gun-guni. Ganapiya, lika nipa an-gugaliya an-guwaywuya a-ni. ");
INSERT INTO bvr_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Rrapa Wangarr an-gata Ay-ninyarrapa Ay-workiya, nipa gu-garrana rrawa balaja gu-murna gun-gata wana gu-bapala gu-rrawa Yidan (Eden). Gatiya marnnga jina-beya jina-workiya nipa gu-garrana. Lika gu-gata gu-rrawa nipa a-barnjinga an-gugaliya nipa a-jarlapuna. ");
INSERT INTO bvr_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Rrapa nipiya Wangarr an-gata Ay-ninyarrapa Ay-workiya, nipa gu-jarlapuna gun-molamola gun-jong gun-guyinda, minypa gu-jel wenga mun-jarlarla m-bena, lika wana gu-ni gu-bamuna gun-bulapalawa gun-gata minypa balaja mu-rrimanga. Rrapa gojilapa gu-gata gu-rrawa gu-jinyja gun-jong mun-gata wanngu mun-gunega, rrapa mola gun-jong mun-gata marn.gi mun-gunega gun-gata nula minypa gun-ngiya gun-molamola rrapa gun-ngiya gun-nerra, gu-gurda ngacha. ");
INSERT INTO bvr_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Gun-gata rrawa Yidan man.garba gu-werrwerrjinga gu-yu rrapa gu-gurragaja gun-gata rrawa balaja gu-murna. Lika gu-gatiya wengga a-gomagorndiyana ana-mernda minypa abirri-jirrapa abirri-jirrapa. ");
INSERT INTO bvr_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","An-gata ana-mernda nipa gun-nelangga minypa gun-ngardapa nipiya an-nelangga Bichon (Pishon). Nipa a-gomarriya a-yurra rrawa gun-gata Abala (Havilah), gun-gatiya goldan gu-yurra, ");
INSERT INTO bvr_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","goldan gun-gata gun-molamola. Rrapa minypa mun-molamola mun-gungolkuja mu-yurra gatiya, mun-gata mun-molamola mun-gungolkuja nipa mun-nelangga Bteliyam (Bdellium). Rrapa minypa jandarra gun-molamola gun-guyinda gu-yurra, gun-gata jandarra nipa gun-nelangga anik (onyx). ");
INSERT INTO bvr_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","An-gata ana-mernda nipa gun-nelangga minypa abirri-jirrapa, nipiya an-nelangga Giyan (Gihon). Nipa a-gomarriya a-yurra rrawa gun-gata Guch (Cush). ");
INSERT INTO bvr_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Rrapa an-gata ana-mernda nipa gun-nelangga minypa abirri-jirrapa gun-ngardapa, nipiya an-nelangga Daygrich (Tigris). Nipa bugula gu-werrwerrjinga rrawa Achíriya (Assyria) gu-gapa. Rrapa an-gata ana-mernda nipa gun-nelangga minypa abirri-jirrpa abirri-jirrpa, nipiya an-nelangga Yubréytich (Euphrates). ");
INSERT INTO bvr_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Wangarr an-gata Ay-ninyarrapa Ay-workiya a-menga an-gata an-gugaliya, lika a-barnjinga gata rrawa balaja gu-murna wana gu-bapala gu-rrawa gun-gata Yidan, barra nipa an-gugaliya jama a-ji rrapa jaga a-gana rrawa. ");
INSERT INTO bvr_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Rrapa Wangarr an-gata Ay-ninyarrapa Ay-workiya, nipa a-wena nula an-gata an-gugaliya. Minypa a-yinanga nula, “Gun-jong gun-bulapalawa gun-guna rrawa balaja mu-rrimanga gun-mola nggula nginyipa ny-bay barra. ");
INSERT INTO bvr_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Wurpa lika ngika mun-guna gun-jong marn.gi mun-gunega gun-gata nula minypa gun-ngiya gun-molamola rrapa gun-ngiya gun-nerra. Mun-gunaga jarra gala barra ny-bay. Gala yapa ny-bardapa ny-juwun gun-gatiya gu-ngardapiya ngorrngurra.” ");
INSERT INTO bvr_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Gu-gata wenga Wangarr an-gata Ay-ninyarrapa Ay-workiya, nipa a-wena, a-yinanga, “Gun-narda gala gun-mola an-gugaliya ngardapa a-ni; jarra ngaypa ngu-jarlapa barra nula jin-gugunggaja jin-gata jin-molamola nuluwa.” ");
INSERT INTO bvr_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ngardawa nipa Wangarr gipa mu-ngoyurra jel gu-rrimarra, burr-jarlapuna minyjak an-guyinda burdacha an-guyinda an-jaranga jin-jaranga, lika burr-ganyja gurda nula an-gugaliya nipa a-yinmiya barra aburr-welangga burr-ngurrja ngardapa ngardapa. Rrapa nipa a-yinmiyana a-wena, aburr-welangga burr-ngurrjinga, aburr-gurda ngacha aburr-welangga aburr-yurra. ");
INSERT INTO bvr_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Minypa nipa an-gugaliya aburr-welangga burr-garrana minyjak an-guyinda minyjak jin-guyinda jin-gumurna rrapa an-mugat, rrapa burdacha an-guyinda an-gata waykin a-boya a-workiya nipa an-gugaliya aburr-welangga burr-garrana. Wurra gala yina gaya jin-gugunggaja nuluwa an-gugaliya. ");
INSERT INTO bvr_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Lika Wangarr an-gata Ay-ninyarrapa A-workiya, nipa a-gurrmurra an-gugaliya gu-ngorrngurra a-yu. Lika gun-gatiya gugu an-birlwerra an-ngardapa a-menga nula an-gugaliya, lika mola a-birlpana an-garla. ");
INSERT INTO bvr_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Rrapa an-birlwerra an-gata nipa Wangarr a-rrimarra rrapa gama jiny-jarlapuna. Lika jina-ganyja nula, a-wuna an-gugaliya. ");
INSERT INTO bvr_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","“Aya!” nipa an-gugaliya a-yinagata, “Jin-guna ngaypa ngu-jorla wenga ng-garla wenga nguna-bawuna, jina-bena. Jibu-ngurrja barra ‘jin-gugaliya’, ngardawa ana-gugaliya wenga.” ");
INSERT INTO bvr_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Gu-gurda ngacha minypa an-gugaliya bijirriny-bawuja a-workiya nyanyapa niya rrapa mampa niya, barra jiny-ma jin-nigipa jin-gumarrbipa niya, lika birrinyjipa abirriny-nyardpa abirrinyu-nirra abirriny-yorkiya. ");
INSERT INTO bvr_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ganapiya, wurra an-gata an-gugaliya rrapa jin-nigipa jin-gumarrbipa niya, birrinyjipa abirriny-nyarlanga abirrin-digirrgarra rrapa gala gun-ngiya rraka gona abirrinyu-nirrarna. ");
INSERT INTO bvr_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","An-gata minyjak an-guyinda jin-gata minyjak jin-guyinda nipa Wangarr an-gata Ay-ninyarrapa Ay-workiya burr-jarlapuna, nipa an-gata nguymbula an-guyolka. Nipa a-yinanga a-wena achila jin-gata jin-gugaliya, “Nipa Wangarr a-wena nggula, jimarna mun-nerranga mun-guna gun-jong mu-jirra m-boya gala barra balaja ny-bay, ya?” ");
INSERT INTO bvr_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Lika nipa jin-gugaliya jiny-yena nula nguymbula, “Gun-mola atila nyirri-bay barra mun-guna balaja mu-jirra m-boya gun-guna rrawa. ");
INSERT INTO bvr_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Wurra Wangarr a-wena, gala nyirri-yinmiya nyirri-bay mun-gata balaja mu-gata gu-jong gojilapa mu-jinyjarra. Gala nyirri-yinmiya nyirri-dima burr-guta. Gala yapa nyirri-juwun.” ");
INSERT INTO bvr_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Wurra nipa nguymbula a-yinagata achila jin-gugaliya, “Ngika. Gala nyirriny-yinmiya nyirriny-juwa. ");
INSERT INTO bvr_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Jarra Wangarr marn.gi gun-gata ana-gorrinyjipa nyirriny-bay mun-gata balaja mu-gata gu-jong mu-rrimanga, marn.gi nyirrinyu-ni barra minypa nipa Wangarr marn.gi a-nirra. Marn.gi nyirrinyu-ni barra gun-gata nula minypa gun-ngiya gun-molamola rrapa gun-ngiya gun-nerra.” ");
INSERT INTO bvr_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ganapiya, lika gun-gatiya jin-gugaliya mu-nana nipa gun-jong mun-molamola rrapa minypa balaja mun-molamola mu-rrimarra, rrapa minypa nipa gu-borrwurra mun-gata mun-molamola marn.gi mun-gunega, lika mun-narda balaja mu-menga, m-barra. Rrapa mun-nerranga a-wuna an-gumarrbipa ngacha an-gata wugupa achila, rrapa nipa m-barra. ");
INSERT INTO bvr_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Lika gatiya gugu marn.gi abirrinyu-ni gun-gata minypa birrinyjipa abirriny-nyarlanga abirrinyu-ni. Lika mbirriny-menga mula mu-jirra gun-jong mun-gata wagarrich, lika mbirrin-dana, abirriny-barrngumurra martun minypa. ");
INSERT INTO bvr_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Gun-gatiya yi-rrana gu-ni gu-nyiljinga, birrinyjipa abirriny-jaliyana Wangarr an-gata Ay-ninyarrapa Ay-workiya nipa ganggulkul gu-rrenyjinga a-bamuna gun-gata gun-molamola rrawa. Lika nipa an-gugaliya rrapa jin-nigipa jin-gumarrbipa niya, birrinyjipa gu-mugarla gu-guyinda gu-gatiya gu-rrawa abirriny-yilkakiyana nula Wangarr an-gata Ay-ninyarrapa Ay-workiya. Gala yapa bijirrinyu-nan. ");
INSERT INTO bvr_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Wurra nipa a-gonyjinga nula an-gugaliya. A-yinanga nula, “A-lay, yina ny-jaya?” ");
INSERT INTO bvr_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Nipa an-gugaliya a-yinanga, “Ngika. Wurra ng-galiyana nggula ganggulkul n-denyjinga gu-guna gun-molamola rrawa, lika ngaypa ng-gurkuja, ngardawa ngu-nyarlanga. Lika ngu-yilkakiyana.” ");
INSERT INTO bvr_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Nipa Wangarr a-yinagata nula an-gugaliya, “Ana-nga biy-ngurrjinga nginyipa ny-nyarlanga? Wurra balaja mu-gata gu-jong mu-rrimanga, mun-gatiya ngaypa ngu-wena nggula gala barra ny-bay, mun-narda nginyipa ny-barra, ya?” ");
INSERT INTO bvr_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","An-gugaliya a-yinagata, “Jin-guna jin-gugaliya nginyipa nguna-wuna jin-gubalpura apula, nipa nguna-wuna balaja mu-gata gun-jong mu-rrimanga, lika ngu-barra.” ");
INSERT INTO bvr_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Lika Wangarr an-gata Ay-ninyarrapa Ay-workiya a-wena achila jin-gata jin-gugaliya, “A-jay, gun-gata nginyipa ny-yinmiyana?” Nipa jin-gugaliya jiny-yinanga, “An-gata nguymbula nguna-yolkaja, lika ngu-barra.” ");
INSERT INTO bvr_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Lika Wangarr an-gata Ay-ninyarrapa Ay-workiya, nipa a-wena nula nguymbula. A-yinanga nula, “Ngardawa nginyipa ny-yinagata jama ny-ji ny-yolkaja, nipa burr-guya gun-nerra gu-ni barra nggula; aburr-werranga minyjak aburr-guyinda aburr-gata aburr-gumurna rrapa aburr-mugat, nipa marr gu-yinda gun-nerra gu-ni barra burrwa. Nginyipa ny-jochila gu-jel n-dika barra ny-yorkiya, rrapa burr-jel ny-baypa barra ny-yorkiya. ");
INSERT INTO bvr_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Rrapa gun-guna minypa ng-gurrma barra mun-bachirra mu-yu barra ana-gorrinyjula jin-guna jin-gugaliya rrapa nginyipa. Minypa nginyipa nyiburr-bureybureygu rrapa jin-guna aburr-yayawgu nyiburr-bacha barra nyiburr-ni. Nipa a-mapa barra nginyipa bama ny-jirra biy-bu barra, rrapa nipa rrepara a-jirra nginyipa ny-bay barra.” ");
INSERT INTO bvr_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Rrapa jin-gata jin-gugaliya nipa Wangarr a-yinanga a-wena achila, “Ngaypa burr-guya gun-derta ngu-nega barra nggula gun-gata minypa nginyipa delipa ny-ma barra ny-yorkiya; ny-yurkuricha barra ny-yorkiya, delipa ny-ma barra. Wurra nginyipa jal nyi-ni barra nula an-nginyipa an-gumarrbipa nggu, wurra nipa mu-ngoyurra a-ji barra nggula a-workiya.” ");
INSERT INTO bvr_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Rrapa an-gata an-gugaliya nipa Wangarr a-yinanga nula, “Ngardawa jin-nginyipa jin-gumarrbipa nggu manyjirda jiny-jirra ny-jaliyana achila rrapa ny-barra mun-gata balaja mu-gata gu-jong mu-rrimanga ngaypa ngu-wena nggula gala barra ny-bay, lika gun-guna jel gun-nerra gu-ni barra. Jama wana ny-ji barra ny-yorkiya balaja barra ny-bay; ");
INSERT INTO bvr_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","bornangguna jin-guyinda jiny-jirralmiya barra jiny-yorkiya – gu-lokula an-nga burr-guta an-darrartka – rrapa nginyipa ny-bay barra ny-yorkiya minypa gorrngunya mun-guyinda rrapa gu-jong mu-rrimanga. ");
INSERT INTO bvr_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ny-nyawarrcha barra nyi-ni ny-yorkiya, jama ny-ji barra ny-yorkiya balaja nula ny-bay, nuwurra ny-jeka barra jel nyi-ni barra. Ngaypa ngiy-jarlapuna nginyipa gu-jel wenga, ny-jurdiya nginyipa gu-jel nyi-guyinda rrapa ny-jeka barra jel nyi-ni barra.” ");
INSERT INTO bvr_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Lika nipa Arram (Adam) jin-nigipa jin-gumarrbipa niya jin-nelangga jiny-jarrana Yip (Eve), ngardawa nipa mampa burra gu-galiya yerrcha. ");
INSERT INTO bvr_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Lika Wangarr an-gata Ay-ninyarrapa Ay-workiya, nipa mu-jarlapuna burrinyjula minyjak an-maliyarra abirriny-barrngumurra. ");
INSERT INTO bvr_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Lika Wangarr an-gata Ay-ninyarrapa Ay-workiya, nipa a-wena, a-yinanga, “Minyja an-guna an-gugaliya nipa gugu minypa ngatipa arri-gunaga; nipa marn.gi gun-gata nula minypa gun-ngiya gun-molamola rrapa gun-ngiya gun-nerra. Wurra gala yapa mernda a-jirra a-garlmurda, mu-rrimarda, m-barda balaja mu-gata gu-jong mu-rrimanga wanngu mun-gunega. Gala yapa mu-nguy ay-ninyapa ay-workiya.” ");
INSERT INTO bvr_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Gu-gurda nula Wangarr an-gata Ay-ninyarrapa Ay-workiya, nipa a-jerrmarra an-gata an-gugaliya gu-gata gun-molamola gu-rrawa wenga, gun-gatiya wana gu-bapala gu-rrawa Yidan. A-jurnayerrnyjinga, jel minypa gu-bu barra a-ni a-workiya balaja nula, jel gun-gata minypa nipa an-gugaliya gu-jel wenga. ");
INSERT INTO bvr_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Lika nipa Wangarr burr-gurrmurra aburr-gubamana waykin aburr-guyinda, rrapa minypa barrang a-gurrmurra bol a-maya gu-jaywuja a-jirra yina gaya; gala barra ana-nga yi-gurrepa ana-boy nula mun-gata wanngu mun-gunega gun-jong. ");
INSERT INTO bvr_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Gun-guna janguny Wangarr gu-gurrmurra wengga. ");
INSERT INTO bvr_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","A-yinanga, “Ngaypa Bunggawa ana-gorrburrwa, Mu-ngoyurra Ng-guyinda. Ana-goyburrpa brichina (prisoner) nyiburr-ni gu-rrawa Yijipt (Egypt), ngaypa arr-rraykaja arr-menga, arr-gurrmurra. ");
INSERT INTO bvr_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Gala barra an-nerranga jin-nerranga wangarr jin-guyinda wangarr an-guyinda ny-marrngoypiya nula ny-yorkiya. ");
INSERT INTO bvr_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Gala barra jin-mawunga an-mawunga ny-jarlapa, ny-marrngoypiya nula. Aburr-werranga burdacha burr-guta waykin aburr-boya, rrapa minyjak yerrcha gu-jel aburr-boya rrapa gu-bugula aburr-boya ");
INSERT INTO bvr_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","gala barra ny-menama n-da burrwa, jama ny-ji burrwa. Ngika. Ngardawa gu-galiya yerrcha aburr-werranga aburr-gata aburr-werra apula aburr-nirra, birripa aburr-baparru ngaypa nguburr-burnda ngu-nirra. ");
INSERT INTO bvr_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Rrapa aburr-werranga aburr-nga aburr-gata aburr-jaranga jal aburr-nirra apula, minypa gun-ngaypa wengga gubu-borrwuja apula aburr-nirra, birripa jarra ngaypa nguburr-malapurda ngu-nirra. ");
INSERT INTO bvr_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Ngaypa ana-gorrburrwa Wangarr, ng-gunaga Ngu-ninyarrapa Ngu-workiya. Gala barra ngu-welangga borijipa nguna-ma. Wurra ny-yerranga minyja ngu-welangga borijipa ny-yenggapa, ngaypa gala ngu-yinmiya ngu-mola ngu-ni nggula. Wurra gu-gurda ngacha minypa werra nyi-negiyana. ");
INSERT INTO bvr_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Wolawola rrengarrenga gun-ngardapa nyiburr-ngeka barra nyiburr-workiya, ngunabu-borrwa barra. ");
INSERT INTO bvr_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Minypa jama nyiburr-ji barra nyiburr-workiya rrengarrenga abirri-jirrapa abirri-jirrapa abirri-jirrapa, ");
INSERT INTO bvr_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","lika gun-ngardapa gun-ngaypa nyiburr-ngeka barra ngunabu-borrwa barra ngaypa Wangarr Bunggawa ana-gorrburrwa. Gala barra jama nyiburr-ji – nginyipa, rrapa aburr-nginyipa walkurpa yerrcha, rrapa aburr-nginyipa aburr-mujama, jin-nginyipa yarraman burr-guta. An-nerra marlaga gun-nginyipa rrawa a-nirra gala barra jama nyiburr-ji. ");
INSERT INTO bvr_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ngardawa rrengarrenga abirri-jirrapa abirri-jirrapa abirri-jirrapa wupa ngu-jarlapuna nguparr, jel, bugula burr-guta. Rrapa nyiburr-guwaywuya arr-jarlapuna ngaypa Wangarr. Lika rrengarrenga gun-ngardapa ngu-ngekarra ngu-ni, rrapa ngu-wena ana-goyburrpa barra nyiburr-yinarda barra nyiburr-ngeka nyiburr-workiya rrapa ngunabu-borrwa barra nyiburr-ni. ");
INSERT INTO bvr_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Nyanyapa nggu mampa nggu yagurrma burrinyjula ni, gu-nginyipa gu-rrawa barra ny-mola nyi-ni ny-bamba jemberr gun-jaranga. Ngaypa ngu-weya ana-gorrburrwa ngu-nirra, ngaypa ng-gunaga Wangarr Ngu-ninyarrapa Ngu-workiya rrapa rrawa ng-gurrmurra ana-gorrburrwa. ");
INSERT INTO bvr_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Gala barra an-nerranga ny-bu a-juwa. ");
INSERT INTO bvr_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Gala barra an-nerranga jin-nika ny-ma marrambay. Rrapa meyelk, nginyipa gala barra ji-werranga an-nika n-dima. ");
INSERT INTO bvr_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Gala barra mun-ngumurda ny-ma. ");
INSERT INTO bvr_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Gala barra an-nginyipa an-borrmunga bima ny-nyurrja. ");
INSERT INTO bvr_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Gala barra an-nginyipa an-borrmunga mu-werrmbarra nyi-na. Jin-nigipa jin-gumarrbipa rrapa jin-mujama rrapa bulugi (bullock) rrapa yarrman gala barra mu-werrmbarra nyi-na. Jin-nigipa. An-nigipa an-mujama bawa. An-nigipa. Gun-nigipa bala, gerra burr-guta bawa. Gun-nigipa.” Gu-yinagata gu-yurra janguny Wangarr gu-gurrmurra wengga. ");
INSERT INTO bvr_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","An-ngardapa an-gugaliya an-nelengga Yilkána (Elkanah) nipa an-bapurrurr Yiprayim (Ephraim), nipa a-ni a-workiyana rrawa gun-delipa Rama (Ramah), mu-mirk m-bukula, Rrawa wana gun-gata Yiprayim, minypa gu-ngardapiya abirri-welangga rrawa rrapa baparrurr. ");
INSERT INTO bvr_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Yilkana bijirriny-malapuna a-ni abirriny-jirrapa gama yerrcha, Yana (Hannah) rrapa Bináyna. Nipa Bináyna bin-dimarra aburr-jaranga gu-ngarda yerrcha. Yana jin-nyagara; gala bin-dimangarna gu-ngarda yerrcha. ");
INSERT INTO bvr_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Jemberr gu-ni gu-workiyana Yilkána rrapa abirriny-yigipa gama yerrcha rrapa gu-ngarda yerrcha aburr-bona aburr-workiyana gun-gata rrawa Jaylow (Shiloh), gata barra aburr-marrngoypiya nula aburra-ni rrapa jin-garla abu-wu Wangarr. Abirri-gata junggay abirri-ni nipa Yilay (Eli) bijirri-bokamurra, Wopni (Hophni) rrapa Biniyach (Phinehas). Bitipa junggay jaga abirri-ganana Waykin A-nirra gun-nika rrawa. ");
INSERT INTO bvr_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Gun-gatiya Yilkána jiny-buna a-workiyana minyjak jin-guyinda rrapa jin-nerranga jin-garla Waykin A-nirra jin-nika, jin-nerranga jiny-bona burrwa Bináyna rrapa aburr-yigipa gu-ngarda yerrcha ngardapa ngardapa, ");
INSERT INTO bvr_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","wurra nipa Yana, marrban burr-guya Yilkána jal a-ni achila, wurra gala jin-garla jin-jaranga jiny-yucharna, ngardawa delipa jin-nyagara, ngardawa Waykin A-nirra gala burdak jiny-yurcharnapa delipa. ");
INSERT INTO bvr_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Rrapa Bináyna nipa jin-bachirra achila jin-guna Yana, minypa jiny-jonga jiny-yorkiyana rrapa delipa jinyu-negarra, ngardawa an-gata Waykin A-nirra gala jiny-yucharna Yana delipa. ");
INSERT INTO bvr_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Jemberr gu-ni, guy-yinagatiya guy-bamunapa guy-workiyana. Aburr-bona aburr-workiyana Wangarr gun-nika rrawa gun-gata, rrapa nipa Bináyna gun-bachirra jiny-yena achila jiny-yorkiyana Yana, lika gu-gata wenga Yana jin-duwujana rrapa gala balaja m-bangarna rrapa jin-garla jiny-bangarna gu-gatiya rrawa. ");
INSERT INTO bvr_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Wurra Yilkána a-wena achila, a-yinagata achila, “Yana a-jay, an-nga nula wargugu nyi-nirra rrapa n-duwuja rrapa gala balaja ny-yurlcha? Gun-nga ny-borrwuja? Ngika wargugu ni. Wurra marr ny-balcha barra rrapa ny-marrkapcha barra apula, wuriya delipa arr-nyagara.” ");
INSERT INTO bvr_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","Gun-ngardapa gu-ni, balaja rrapa bugula mbi-barra gun-gatiya rrawa Jaylow, lika Yana jiny-jarlmuna, jiny-bona, a-wengganana jinyu-ni Waykin A-nirra. Rrapa junggay nipa an-nelangga Yilay, nipa gata a-ni bala gu-ngana, ");
INSERT INTO bvr_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","wurra nipa Yana burr-guya wargugu jinyu-ni jina-bona, burr-rru wupa a-wengganana jinyu-ni Wangarr. ");
INSERT INTO bvr_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Gochila a-rrana, jiny-yinagata nula, “Bunggawa Waykin Nyi-nirra, yama nguna-na rrapa nguna-borrwa? Gala nyi-na apula mari, ya, rrapa nguna-borrwa ngaypa? Minyja nguna-wu barra an-nurra, ngaypa barra gochila ngiy-rra barra an-nginyipa, nipa jama a-jipa barra nggula a-workiya rrapa gala a-yinmiya mejimija mu-gornda.” ");
INSERT INTO bvr_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Jiny-yinagata, rrapa mu-nguy a-wengganana jinyu-ni Wangarr. Rrapa an-gata Yilay jinyu-nana a-ni ngana jiny-jirra, ");
INSERT INTO bvr_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","minypa jiny-yena jinyu-ni. Wurra nipa gala a-galiyarna achila. Lika gu-borrwurra, jimarna mu-nganicha jin-donga, ngardawa gala nipa marn.gi Yana ji-ngurrnga a-wengganana jinyu-ni Wangarr. ");
INSERT INTO bvr_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","Lika a-garlmuna, 77 Yilay a-wena achila, a-yinagata achila, “A-jay, nginyipa mu-nganicha n-dongga ya? Wurra bawa nganicha, barra ny-molamiya!” ");
INSERT INTO bvr_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Wurra Yana jiny-yena nula, jiny-yinagata, “Ngika a-la, an-jarral. Gala nganicha ngu-bangarna, wurra burr-guya wargugu ngu-nirra rrapa ngaypa ngu-ngurrnga burr-guya ngu-wengganana ngu-ni Waykin A-nirra. ");
INSERT INTO bvr_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Gala barra nguna-borrwa, jimarna ngaypa ngu-werra. Wurra jarra ngu-wengganana ngu-ni Wangarr, ngardawa ngaypa ng-garla ngu-werra ngu-nirra.” ");
INSERT INTO bvr_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Lika Yilay a-wena achila, a-yinagata, “Boy. Gun-mola nggula. Rrapa Wangarr Yichrayal (Israel) yerrcha an-birriya biy-wu barra gun-gata gun-nga nginyipa ny-yengganana.” ");
INSERT INTO bvr_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Nipa jin-gata, “Japurra ngapa ny-jirra, a-lay, an-jarral! Nginyipa mu-nguy ny-borrwapa barra ny-yorkiya minypa ngaypa ngu-mola.” Nipa jiny-yinagata jiny-yena nula, lika jiny-bona, balaja m-barra jinyu-ni rrapa jin-garla jiny-barra jinyu-ni, rrapa gala mola jin-nerra jin-digirrgarna, wurra jin-mola jin-digirrgarrapa. ");
INSERT INTO bvr_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Aburr-yu, guna-gepana, lika Yilkána rrapa aburr-yigipa gu-ngarda yerrcha rrapa abirriny-gumarrbipa aburr-garlmuna, aburr-marrngoypiyana nula Wangarr, lika gu-gata wenga gun-birripa rrawa aburr-jekarra, gun-gata rrawa Rama. Ganapiya, lika gun-gatiya Yilkána rrapa Yana abirriny-yu, rrapa Wangarr gu-borrwurra achila gun-gata Yana gipa mu-ngoyurra a-wengganana jinyu-ni. ");
INSERT INTO bvr_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Rrapa gu-gata wenga nipa yukuyuka a-menga rrapa a-bambungguna an-nurra, rrapa an-nelangga a-garrana Jemyul (Samuel). Ngardawa jiny-yinanga, “Ngaypa ngu-wengganana Waykin A-nirra rrapa nipa nguna-wuna an-guna an-delipa.” ");
INSERT INTO bvr_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Ganapiya, lika gu-bamuna, yi-gurrepa gu-ji gu-bona minypa Yilkána burr-ganyja a-workiyana aburr-yigipa gu-ngarda yerrcha rrapa abirriny-yigipa abirriny-gumarrbipa, minypa aburr-bona aburr-workiyana rrapa nipa a-wuna jin-garla an-gata Waykin A-nirra, rrapa minypa gun-gata gun-nga barrwa a-wuna a-workiyana gun-nigipa Waykin A-nirra gun-nika ngardawa gipa mu-ngoyurra gochila a-rrana. ");
INSERT INTO bvr_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Wurra gun-guniya Yana jiny-jekarra, gala jiny-boyarna, ngardawa jiny-yena nula Yilkána, “Nipa an-guna an-delipa waypa ngamangama gu-bawa barra ngaypa ng-ga barra, lika gata ngu-barnja barra Wangarr gun-nika bala. Gata barra nipa a-ni barra a-workiya.” ");
INSERT INTO bvr_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Yilkána a-yinagata achila, “Nginyipa borrwa gun-nga gun-molamola nggula. Bawa burdak, lika nuwurra ngamangama gu-bawa barra rrapa gun-burral nyi-nega barra nula Wangarr an-guna nginyipa gochila n-dana.” A-yinagata achila, lika Yana jinyu-ni rrawa, rrapa jaga jiny-janana nula an-delipa waypa nuwurra an-gata ngamangama gu-bawa barra. ");
INSERT INTO bvr_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Ganapiya, lika gu-gata wenga nipa ngamangama gu-bawuna, lika nipa jin-gata gugu a-ganyja jiny-bona, rrapa mola bulugi an-nurra an-delipa a-ganyja jiny-bona, rrapa mola mun-jaranga gandichawa, rrapa mola wany (wine) ji-ngardapa ji-maliyarra nenikut ji-guyinda mu-ganyja jiny-bona. Yi-gata a-ganyja Jemyul Wangarr gun-nika bala gun-gata rrawa Jaylow, nipa gata barra a-ni barra a-workiya, wurra marrban nipa an-delipa. ");
INSERT INTO bvr_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Ganapiya, lika bulugi an-gata awu-buna, rrapa delipa an-gata abu-ganyja gurda nula Yilay. ");
INSERT INTO bvr_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Jin-gata nipa jiny-yena nula Yilay, jiny-yinagata nula, “A-lay, an-jarral, nginyipa nguna-nacha nyi-nirra rrapa nguna-malawuja ya? Minyja ngaypa ng-gunaga nginyipa wola ny-mipila nguna-buna ngaypa ngu-wengganana ngu-ni Waykin A-nirra. ");
INSERT INTO bvr_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","An-guniya an-delipa ngaypa ngu-wengganana ngu-ni Wangarr, rrapa nipa nguna-wuna an-guniya an-delipa. ");
INSERT INTO bvr_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Lika gun-guniya gugu ngu-wu barra Wangarr. Minyja nipa a-ninyapa barra nipa Wangarr an-nika.” Jiny-yinagata jiny-yena, lika gatiya aburr-marrngoypiyana nula Wangarr. ");
INSERT INTO bvr_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Yana a-wengganana Wangarr, jiny-yinagata nula, “Ngaypa burr-guya ngu-marrkapchinga nula Wangarr, ngu-molamola ngu-nirra ngardawa nipa nyanma! Ngaypa ng-gurdachinga burrwa aburr-ngaypa aburr-bachirra apula! Ngu-worlworlchinga ngardawa Wangarr a-gunggajinga apula! ");
INSERT INTO bvr_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","Gala ana-nga an-molamola warrpam minypa nipa Waykin A-nirra. Gala ana-nga an-nerranga minypa nipa, gala ana-nga jaga a-ganana arrburrwa minypa an-ngayburrpa Wangarr. ");
INSERT INTO bvr_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","Ganapa wana nyiburr-negiya. Ganapa gun-bachirra buburr-wengga. Wurra nipa Wangarr marn.gi ana-gorrburrwa nyiburr-yinagatiya nyiburr-nirra rrapa a-yinmiya barra ana-gorrburrwa. ");
INSERT INTO bvr_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","An-gata mardakarrich mun-nigipa bunarra mu-rrumiya nula, wurra an-gata an-nyarlkuch nipa gugu an-derta a-nirra a-bamburda. ");
INSERT INTO bvr_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Aburr-gata aburr-nga balaja mbi-barra, aburr-durtchinga aburr-workiyana, birripa gugu balaja mu-marr jama aburr-jirra barra mbi-ma. Wurra aburr-gata aburr-werrmiyana aburr-workiyana, birripa gala aburr-yinmiya barrwa aburr-werrmiya. Rrapa jin-gata mu-ngoyurra jin-nyagara gipa burr-menga gu-ngarda yerrcha abirri-jirrapa abirri-jirrapa abirri-jirrapa an-ngardapa. Wurra jin-gata mu-ngoyurra bin-dimarra, aburr-yigipa gu-ngarda yerrcha gipa gugu gun-nyagara, rrapa nipa wargugu jinyu-nirra. ");
INSERT INTO bvr_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","Nipa an-gata Wangarr mardakarrich rrapa mola wanngu an-gunega. Nipa wupa nyanma gu-borrwuja rrapa an-gugaliya a-juwiya a-workiya, rrapa barrwa nipa wupa a-jarrkarraja. ");
INSERT INTO bvr_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","Nipa Wangarr an-nerranga an-gugaliya gerra an-nyagara a-nenga, rrapa an-nerranga an-gugaliya nipa Wangarr a-wucha a-workiya gerra gun-jaranga nula. Nipiya Wangarr an-gugaliya gun-nga nula an-delipa a-nenga a-workiya, rrapa gu-werranga wana a-nenga a-workiya. ");
INSERT INTO bvr_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","Aburr-gata aburr-nyagara gerra, birripa minypa wargugu aburr-nirra minypa gun-nerra gu-nirra burrwa gu-workiya. Wurra Wangarr a-gunggajinga burrwa a-workiya, gu-molamola burr-barnjinga a-workiya, aburr-nirra aburr-workiya wugupa burrwa bunggawa yerrcha. Ngardawa gun-guniya rrawa Wangarr gun-nika rrapa nipa gu-jarlapuna. ");
INSERT INTO bvr_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","Nipa jaga a-ganaja burrwa aburr-gata marr aburr-balcharra nula, wurra aburr-gata gala marr aburr-balcha nula, birripa an-munya gu-maya barra aburr-ni. Ngardawa an-gugaliya gala a-yinmiya nipa wupa nyanma an-molamola a-ninya. ");
INSERT INTO bvr_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","Wangarr burr-yika aburr-bachirra nula birripa aburr-juwa barra. Nipa minypa maykarran a-wengga barra burrwa. Nguburr-gurdiya warlaman gun-nardiya rrawa mirrka ngubu-barnja barra nula, nuwurra nipa a-yinmiya barra arrburrwa. Rrapa Wangarr an-nika nipa arr-wuna an-ngayburrpa Bunggawa, nipa rrapa wana an-babalapa a-ni barra.”. Jiny-yinagata jiny-yena Yana. ");
INSERT INTO bvr_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Ganapiya, lika Yilkána rrapa abirriny-yigipa abirriny-gumarrbipa nuya rrapa aburr-werranga aburr-yigipa gu-ngarda yerrcha aburr-jekarra Rama, wurra nipa Jemyul gata a-ni Jaylow. Nipa jama a-ji nula a-workiyana Waykin A-nirra, rrapa an-gata Yilay an-nigipa marn.gi an-gunega. ");
INSERT INTO bvr_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","Abirri-guna Yilay bijirri-bokamurra, bitipa abirri-werra, gala mola abirri-borrwujarna Wangarr. ");
INSERT INTO bvr_vpl VALUES ("S12_13","010_2_13","1SA","2","13","14","Gun-birripa gun-guwarr an-guna junggay an-guyinda, minypa wurra gama gorlk aburr-boya gurda aburr-workiya, minyjak jibi-yalpurda nula Waykin A-nirra, rrapa an-gata junggay an-nika an-mujama ana-boy nipa jin-gata jin-garla jiny-bongbongja jiny-ji, rrapa minypa murna a-jirra ana-guyinda gulinga ana-ga, rrapa ana-ngardapa ana-goma a-garra wupa japalana ana-guyinda, ganapiya. Gun-gata jin-nga nipa gulinga ana-guyinda jina-ga ana-warrcha, nipa jin-gata wupa junggay jin-nika jin-garla. Birripa junggay yerrcha aburr-yinagata jin-garla jibu-menga aburr-workiyana wolawola aburr-guna Yichrayal yerrcha yi-gata aburr-bona aburr-workiyana Jaylow. ");
INSERT INTO bvr_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","Wurra abirri-guna Yilay bijirri-bokamurra junggay yerrcha, mu-ngoyurra burlurla gala mu-rronggarnapa wurra an-bitipa an-mujama nipa ana-bona ana-workiyana, a-wena nula an-gata ana-nga mu-yalpuna, a-yinagata nula, “Ny-yu barra jin-garla an-guna junggay barra nipa gu-bol jiny-yalpa. Nipa gala jal a-ni jiny-bay bugula gu-guyinda jin-donga, wurra jin-jurrkurda jal a-nirra barra nipa gu-bol jiny-yalpa.” ");
INSERT INTO bvr_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","Rrapa minyja an-gugaliya a-yinanga a-wena, “Burdak bawa, burlurla mu-ngoyurra mu-rro barra, ngardawa mun-japurra Waykin A-nirra mun-nika, lika nuwurra jin-garla ny-ma jiny-yinmiyapa nginyipa jal nyi-ni,” wurra nipa a-yinagata, “Ngika! Gun-nardiya nguna-wupa! Wurra minyja gun-nyagara, ngaypa barra ngiy-gaypa.” ");
INSERT INTO bvr_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","Abirri-yinagata Yilay bijirri-yika walkurpa yerrcha werra abirri-negiyana nula abirri-workiyana Wangarr. Minypa gun-gata wurra gama gorlk jin-garla jibi-yalpuna nula aburr-workiyana, wurra bitipa abirri-gata gun-nerra gubirri-negarra abirri-workiyana. ");
INSERT INTO bvr_vpl VALUES ("S12_18","010_2_18","1SA","2","18","19","Gun-gatiya Jemyul jama a-ji nula a-workiyana Wangarr, nipa a-barrngumurra a-workiyana mun-japurra mirikal linan (linen) mbi-jarlapuna. Rrapa jemberr gu-ni gu-workiyana, Yilkána birripa aburr-bona gurda aburr-workiyana, balaja rrapa minyjak abu-wuna aburr-workiyana Wangarr, rrapa nipa Yana mirikal muna-ganyja nula jina-workiyana Jemyul mun-nika nipa mu-rracha nula. ");
INSERT INTO bvr_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Rrapa nipa Yilay a-japurrmayana burrinyjula a-workiyana Yilkána rrapa Yana, rrapa a-wena nula a-workiyana Yilkána, a-yinanga nula, “Wangarr biy-wu barra, gu-ngarda yerrcha barra jin-guna burr-ma nggula, minypa an-nginyipa walkur nginyipa ny-yuna Wangarr.” A-yinagata nula a-workiyana, lika aburr-jekarra aburr-workiyana rrawa. ");
INSERT INTO bvr_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Rrapa Wangarr a-gunggajinga achila Yana, nipa burr-menga nula Yilkána abirri-jirrapa rrapa an-ngardapa mu-wurra yerrcha rrapa abirriny-jirrapa mu-gama yerrcha. Rrapa Jemyul wana a-ni a-bamuna gatiya Wangarr gun-nika bala nipa jama a-ji a-workiyana. ");
INSERT INTO bvr_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","Yilay nipa gugu bama a-ngarlchinga rrapa a-nyarlchinga a-bamuna, rrapa nipa a-galiyana nipa bijirri-bokamunga abirri-yinmiyana burrwa Yichrayal aburr-bapurrurr, rrapa abirri-yinmiyana mu-gama yerrcha burrbu-menga, burrbu-malapuna aburr-yu aburr-gatiya gatiya jama aburr-ji aburr-workiyana bala gu-ngana Wangarr gun-nika gun-japurra. ");
INSERT INTO bvr_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","Rrapa nipa a-yinagata butula, “An-nga nula nyirri-yinagata nyirri-workiya? Ngardawa wurra gama gorlk nyirrbu-ngurrjinga rrapa janguny guna-jeknga, ngaypa ng-galiyarra ana-gotula gun-nerra jama nyirri-jirra burrwa nyirri-workiya. ");
INSERT INTO bvr_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","Wurra walkur yerrcha, gun-narda birri-bawa! Ngardawa gun-gata ng-galiyarra ngu-workiya Wangarr burr-yika nyirrbu-yopurda aburr-workiya gun-narda gun-nerra warrpam. ");
INSERT INTO bvr_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","Minyja an-gugaliya werra a-nega an-nerranga an-gugaliya, Wangarr barra a-gunggaja nula, wurra minyja ana-gugaliya werra a-nega Wangarr, ana-nga barra a-gunggaja nula an-gata an-gugaliya?” A-yinagata Yilay a-wena butula abirri-yigipa walkurpa yerrcha, wurra bitipa gala abirri-galiyarna nula, ngardawa Wangarr gu-borrwurra nipa barra bijirri-bu. ");
INSERT INTO bvr_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","Wurra nipa an-gata Jemyul wana a-ni a-bamuna, rrapa jal aburr-ni nula gu-galiya yerrcha rrapa Wangarr. ");
INSERT INTO bvr_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","Rrapa an-ngardapa an-gata Wangarr gun-nika janguny gu-ngurrjinga a-workiyana, nipa a-bena nula Yilay, a-yinagata nula, “Wangarr guna-jerrmarra nggula janguny minypa gun-guna: Nipa a-yinagata, ‘Ngaypa ngu-bena burrwa nyanyapa nggu jungurdapa nggu an-guyinda gun-gata rrawa Yijipt (Egypt) aburr-ni aburr-mujama burrwa Beruw (Pharoah) birripa. ");
INSERT INTO bvr_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","Minypa ana-goyburrpa Yichrayal yerrcha nyiburr-jaranga nyiburr-baparrurr, wurra ngaypa ngu-menga an-nginyipa mu-ngoyurra an-guyinda Eyran (Aaron) ana-goyburrpa baparrurr, nipa barra junggay a-ni apula a-workiya. Minypa nipa a-bona a-workiyana, gun-ngaypa belabila gu-guyinda minyjak jiny-yalpuna apula a-workiyana, rrapa mun-molamola mu-ngolkuja burr-guta mu-yalpuna apula, rrapa mun-japurra mirikal a-barrngumurra a-workiyana rrapa nguna-wengganana a-workiyana. Rrapa ngaypa ngu-wuna, nyanyapa nggu jungurdapa nggu an-guyinda jiny-barra a-workiyana jin-nerranga minyjak jin-gata birripa Yichrayal yerrcha ngunabu-wucha aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","Wurra ny-jurda nginyipa, an-nga nula jurrkjurrk nyi-nirra aburr-guna Yichrayal yerrcha ngunabu-wucha aburr-workiya ngaypa gipa ngu-barnjinga burrwa joborr? An-nga nula ny-yagurrmunga butula ny-yorkiya abirri-nginyipa walkur? Yama nyiburr-gurkujarna apula? Wurra burlurla jin-dimanga ana-goyburrpa ngunabu-gaypurda nyiburr-workiya jin-garla aburr-ngaypa gu-galiya yerrcha Yichrayal yerrcha ngunabu-wucha aburr-workiya.’ ");
INSERT INTO bvr_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","“Ganapiya, lika an-gatiya Ay-ninyarrapa Ay-workiya Wangarr Yichrayal yerrcha an-birriya, nipa a-weya nggula a-nirra, a-yinaga, ‘Ngaypa gochila ngubirri-dana nyanyapa nggu jungardapa nggu, ana-goyburrpa nyiburr-baparrurr nyiburr-ngaypa nyiburr-mujama barra nyiburr-ni nyiburr-workiya, minypa ana-goyburrpa nyiburr-barrnguma gurda rrapa nyiburr-bengga nyiburr-workiya ngaypa ngu-mibilapa. Wurra gun-guniya gugu ngaypa ng-gunaga Wangarr ngu-weya nggula ngu-nirra, ngaypa gala mola ngu-yinmiya. Wurra jarra aburr-gata aburr-nga marr aburr-balcharra apula, ngaypa barra ngu-mola ngu-ni barra burrwa. Wurra aburr-gata ngoyurra aburr-yerryerrmiya apula, ngaypa barra nguburr-dalaja barra. ");
INSERT INTO bvr_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","Minyja galiya: Gun-guna gugu guna-bamburda ngaypa barra ngiy-bu barra nginyipa, rrapa aburr-nginyipa aburr-baparrurr burr-guta nguburr-bu barra. Minypa gala ana-nga barra bama a-ngarlcha nginyipa ny-baparrurr, wurra ngika wupa. ");
INSERT INTO bvr_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","Nginyipa barra wargugu nyi-ni barra rrapa ny-yerra nyi-ni barra, ngardawa aburr-werranga Yichrayal yerrcha ngaypa ng-gunggaja barra burrwa rrapa gun-molamola nguburr-wu barra, wurra nginyipa ny-baparrurr gala barra ana-nga bama a-ngarlcha barra. ");
INSERT INTO bvr_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","Rrapa ana-nga ana-gotipa nyirri-baparrurr ngaypa gala ngu-bu wurra burdak jama a-ji apula, wurpa lika nipa burr-guya a-rruwuja barra rrapa wargugu a-ni, ngardawa aburr-gata ana-goyburrpa nyiburr-baparrurr gu-mari aburr-juwapa barra aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","“‘Minyjiya. Abirri-nginyipa walkurpa yerrcha Wopni rrapa Biniyach, bitipa gun-ngardapiya ngorrngurra abirri-juwa barra, barra nginyipa ny-borrwa gun-narda geka ngu-wena nggula gun-burral. ");
INSERT INTO bvr_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","Rrapa ngaypa ngu-jerrjerrjiya barra nula an-nerranga, nipa junggay a-ni barra apula rrapa gun-burral jama a-ji barra apula. Minypa gun-nga ngaypa jal ngu-ni nipa a-yirda barra jama a-ji. Rrapa ngaypa ngu-wu barra an-gata aburr-yigipa gu-galiya yerrcha, birripa barra gu-japurra aburr-barrnguma barra gurda aburr-workiya rrapa aburr-bengga barra aburr-workiya nipa ana-mibilapa bunggawa ngaypa ng-garrana. ");
INSERT INTO bvr_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","Rrapa an-gata ana-nga a-ni ana-gotipa nyirri-baparrurr, nipa barra a-ngiwija barra nula an-guna junggay ngaypa ngu-barnjinga, minypa a-ngiwija barra nula rrupiya o balaja o jama. Minypa a-yinda barra nula, “Japurra ngapa ny-jirra, a-lay! Ngaw minyja jama nguna-wu barra balaja ngu-bay!” ’” Ganapiya. Gun-narda wupa janguny gu-bena nula Yilay. ");
INSERT INTO bvr_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Rrapa an-gata Jemyul jama a-ji nula Wangarr, nipa ana-guna Yilay marn.gi a-negarra a-workiyana. Wurra gun-gatiya Wangarr gala burr-wucharna a-workiyarna janguny, rrapa gala ana-nga borrich gu-nacharna nula, wurra gun-nyagara. ");
INSERT INTO bvr_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Yilay nipa mipila a-jirra an-nerra a-ni, minypa gapula a-ni a-bamuna, rrapa nipa a-yunya a-workiyana gu-yigipa bala. ");
INSERT INTO bvr_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Wurra Jemyul gata a-yu a-workiyana wupa Wangarr gun-nika bala gun-japurra, gatiya gu-ji gu-workiyana Wangarr gun-nika minypa belabila gu-maya gata nipa wugupa burrwa yichrayal yerrcha a-jayanayana burrwa a-ji a-workiyana. Gun-ngardapa ngorrngurra gu-ni, ana-munya gu-ni, Jemyul gata gu-bala a-yu, rrapa lam (lamp) gun-gata gu-rronga gu-ji, minypa gu-rronga gu-ji gu-workiyana ana-munya gu-ni. ");
INSERT INTO bvr_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","Lika gu-gata wenga nipa Wangarr ana-nyala an-nelangga a-menga Jemyul, a-yinanga, “Jemyul! Jemyul!” Rrapa nipa Jemyul a-yinagata, “Oy? Ngaypa ng-gunaga.” ");
INSERT INTO bvr_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Lika nipa gugu a-yurtchinga, a-bena nula Yilay. A-wena nula, “Ngaypa ng-gunaga nginyipa ny-jonyjinga apula ya?” Wurra nipa a-wena nula, “Ngaypa gala ng-gonyjingarna nggula. Boy, gurrmiya.” ");
INSERT INTO bvr_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","Rrapa Wangarr mola a-gonyjinga nula, a-yinanga, “Jemyul! Jemyul!” Rrapa Jemyul a-garlmuna, a-bona, a-bena nula Yilay. A-yinagata, “Ngaypa ng-guna a-lay.” Wurra nipa Yilay a-wena, “A-lay, ngaypa gala ng-gonyjingarna nggula, wurra boy, mola gurrmiya.” ");
INSERT INTO bvr_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Gun-guniya nipa Jemyul gala burdak marn.gi a-ningarnapa nula Wangarr, minypa nipa Wangarr gala mu-ngoyurra a-weyarna nula Jemyul. ");
INSERT INTO bvr_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Ganapiya, lika Wangarr ana-jirrapa ana-ngardapa ana-goma gu-negarra a-gonyjinga nula Jemyul, rrapa Jemyul barrwa a-garlmuna, a-bona nula Yilay. A-yinagata nula, “Ngaypa ng-gunaga, ngardawa nginyipa ny-jonyjinga apula.” Lika Yilay gu-borrwurra nipa Wangarr a-gonyjinga nula a-ni. ");
INSERT INTO bvr_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Lika a-wena nula Jemyul, a-yinanga, “Boy, gurrmiya. Rrapa minyja nipa barrwa a-gonyja nggula, nginyipa barra ny-yinda ny-yengga nula, ‘Wengga apula, Bunggawa, ngardawa ngaypa ngu-mujama nggula ng-galiyarra ngu-nirra.’” Ganapiya, lika Jemyul a-jekarra, gu-maywapa a-yunya. ");
INSERT INTO bvr_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Rrapa Wangarr ana-bona, a-bena, a-jinyja. Lika a-gonyjinga nula minypa gipa mu-ngoyurra. “Jemyul! Jemyul!” Rrapa Jemyul a-wena, “Wengga apula, Bunggawa. Ngaypa ngu-mujama nggula ng-galiyarra nggula ngu-nirra.” ");
INSERT INTO bvr_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Lika Wangarr a-wena nula Jemyul, “Minyja galiya apula gun-guna. Yi-gurrepa gu-jirra gu-boya ngaypa barra gun-nerra jama ngu-ji burrwa Yichrayal yerrcha, minypa barrwa janguny gu-barrjeka barra, rrapa aburr-nga aburr-galiya gochila aburr-barrja barra burr-guya. ");
INSERT INTO bvr_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Minyjiya. Yi-gurrepa gu-jirra gu-boya ngaypa barra nguburr-bu barra Yilay aburr-baparrurr. Minypa ngaypa gipa mu-ngoyurra ngu-wena nula, ngu-yinarda barra nguburr-bu barra an-nigipa an-baparrurr an-guyinda rrapa ngu-mungba barra. ");
INSERT INTO bvr_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Minypa ngaypa ngu-wena nula ngaypa nguburr-bu barra ana-gurdiya burr-yika, rrapa gala barra aburr-yinmiya aburr-molamiya. Ngardawa nipa Yilay marn.gi butula abirri-yigipa walkurpa yerrcha bitipa ngu-werra ngunabirri-negarra, wurra gala nipa bijirri-jobujobungarna. ");
INSERT INTO bvr_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Gun-nardiya nula ngaypa gala ngu-yinmiya ngu-barrjejiga, wurra gun-guna ngu-wengga barra gun-burral. Gun-gatiya minyja aburr-werranga Yilay burr-yika minyjak jibi-yalpa apula o mun-nga ngunabu-wu, wurra gun-narda gala gu-yinmiya gun-molamola gu-nega burrwa. Ngardawa aburr-guna Yilay rrapa abirri-yigipa walkurpa yerrcha ngu-werra ngunabi-negarra.” Wangarr a-yinagata gu-ngurrjinga nula Jemyul. ");
INSERT INTO bvr_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Ganapiya, lika Jemyul gatiya a-yu, aa nuwurra guna-gepana. Lika a-garlmuna, mu-lapkujamurra ngana gu-jirra gun-gata bala Wangarr gun-nika. Wurra Jemyul a-gurkuja a-ni, rraka gala a-yinmiyarna a-weyarna nula Yilay gun-gata nipa borrich gu-nana a-ni. ");
INSERT INTO bvr_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","Wurra Yilay a-gonyjinga nula Jemyul, “Jemyul a-lay!” Rrapa nipa a-wena, “Ngaypa ng-gunaga a-lay.” ");
INSERT INTO bvr_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Lika Yilay a-wengganana, “Nipa a-yinmiyana a-wena nggula ana-munya? Wengga apula. Gala barra ny-yilkaka apula. Gala yapa Wangarr biy-bun nginyipa.” ");
INSERT INTO bvr_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Lika Jemyul a-wena nula gun-gata gun-nga nipa Wangarr gu-ngurrjinga nula a-ni, rrapa gala gun-nga gu-yilkakajarna nula. Rrapa nipa Yilay a-wena, “Ganapiya. An-nardiya Wangarr nipa barra jama a-ji gun-nga gun-molamola nula.” ");
INSERT INTO bvr_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Jemyul wana a-ni a-bamuna rrapa nipa Wangarr wugupa nula, minypa gun-nga Jemyul a-wena a-workiyana, barrwa gu-bena gun-burral. ");
INSERT INTO bvr_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Rrapa yichrayal yerrcha gun-gaba rrawa Den (Dan) yi-gata wenga Birchíba (Beersheba) birripa marn.gi aburr-ni nula Jemyul nipa an-mujama a-ni nula Wangarr. ");
INSERT INTO bvr_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Minypa gun-gata rrawa Jaylow nipa Wangarr mu-nguy a-bena nula a-workiyana Jemyul, rrapa a-wena nula a-workiyana gun-nigipa janguny. Rrapa nipa Jemyul gu-ngurrjinga burrwa a-workiyana, aburr-gurdiya gorlk, Yichrayl yerrcha aburr-galiyana nula aburr-workiyana janguny. ");
INSERT INTO bvr_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","Gun-gatiya aburr-gata Bulítiya aburr-guyinda an-dakal aburr-bena burrwa Yichrayal yerrcha, lika Yichrayal yerrcha aburr-garlmuna gun-nerranga rrawa gun-nelangga Yebaníja (Ebenezer), gu-gatiya wenga barra aburr-bacha aburr-ni. Rrapa Bulítiya yerrcha, birripa gata rrawa Yeypek (Aphek) aburr-gera mun-mardaguya mbi-rrana. ");
INSERT INTO bvr_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","Ganapiya, lika Bulítiya yerrcha yi-gurrepa aburr-negiyana burrwa Yichrayal yerrcha. Lika mardakarrich aburr-negiyana gu-gapa gu-guta, rrapa aburr-buchichiyana aburr-ni. Wurra Yichrayal yerrcha gala aburr-worlworlchingarna, ngardawa Bulítiya yerrcha mari burrbu-gaypuna. Birripa burrbu-buna, aburr-jaranga Yichrayal yerrcha aburr-juwuna, minypa 4,000 gu-galiya yerrcha. ");
INSERT INTO bvr_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","Lika gu-gata wenga aburr-werranga aburr-mola aburr-jekarra gurda rrawa Yebaníja, rrapa mu-murna yerrcha aburr-gata aburr-galiyana janguny. Lika aburr-wena, “An-nga nula nipa Wangarr arr-bawuna, aburr-gata Bulítiya yerrcha aburr-molamiyana rrapa ngayburrpa nguburr-nyagara, ya? Wurra yama nguburr-boy Jaylow, rrapa gu-gaba wenga ngubu-ga gurda Wangarr gun-nika gun-gata belabila gu-maya, gu-gata wenga nipa barra wugupa arrburrwa arr-jarlapa arr-ga aburr-gata nula aburr-bachirra?” ");
INSERT INTO bvr_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","Aburr-yinagata aburr-wena. Lika burrbu-jerrmarra rrapa gubu-ganyja gurda aburr-jekarra Jaylow wenga Wangarr gun-nika gun-gata belabila gu-maya gatiya nipa wugupa burrwa an-gatiya nipa burr-ganyja a-workiya waykin aburr-guyinda aburr-murrakal. Gu-gurda ngacha birripa Yichrayal yerrcha gubu-ganyja gurda aburr-bamuna, barra nipiya Wangarr burr-wu ganyjarr. Rrapa Yilay bijirri-bokamurra Wopni rrapa Biniyach, bitipa wugupa burrwa gubu-ganyja gurda aburr-bena. ");
INSERT INTO bvr_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","Ganapiya, lika gun-gatiya Wangarr gun-nika gu-bena burrwa rrawa Yichrayal yerrcha aburr-murrakal aburr-ni, lika gu-ngardapa aburr-negiyana aburr-gonyjinga, rrapa balaypalay aburr-galiyana burrwa aburr-gonyjinga aburr-ji. ");
INSERT INTO bvr_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","Rrapa aburr-gata Bulítiya aburr-guyinda burr-guta aburr-galiyana burrwa aburr-gonyjinga aburr-ji, lika aburr-wengganachichiyana aburr-ni, “An-nga nula aburr-guna Yibru yerrcha aburr-gonyjinga aburr-nirra?” Lika gu-gatiya wenga birripa gugu marn.gi aburr-ni Wangarr gun-nika gun-gata gu-bena burrwa Yichrayal yerrcha, minypa nipa wugupa burra. ");
INSERT INTO bvr_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","Lika Bulítiya yerrcha aburr-gurkuja. Aburr-yinanga, “An-birripa wangarr a-bena burrwa gun-birripa rrawa.” Rrapa mola aburr-yinagata, “Ya, gurrupurunga ngayburrpa? Gu-gurda ngacha gala mu-ngoyurra ngubu-barripangarna! ");
INSERT INTO bvr_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","Ya, gurrupurunga ngayburrpa? Ana-nga barra a-gunggaja arrburrwa ngayburrpa? Ngardawa aburr-guna aburr-birripa wangarr yerrcha burrbu-buna Yijipt aburr-guyinda yi-gapa gu-werrapa, minypa gun-jaranga gun-nerra gun-gujuwa gubi-jerrmarra burrwa, burr-buna. ");
INSERT INTO bvr_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","Wurra ngayburrpa derta nguburr-negiya barra nguburr-jinyja nguburr-burral nguburr-gurda Bulítiya yerrcha. Gala yapa nguburr-mujama nguburr-ni burrwa birripa, minypa birripa mu-ngoyurra aburr-mujama aburr-ni arrburrwa ngayburrpa. Wurra mardakarrich nguburr-negiya barra!” ");
INSERT INTO bvr_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","Ganapiya, lika Bulítiya yerrcha aburr-bona aburr-bachina burrwa Yichrayal yerrcha. Rrapa Yichrayal yerrcha gala gun-mola gu-nirrarna burrwa, wurra aburr-werranga aburr-juwuna rrapa aburr-werranga aburr-yurtchinga, gu-birripa rrawa aburr-bena. Ngardawa aburr-jaranga Yichrayal yerrcha aburr-juwuna, minypa 30,000 an-dakal an-guyinda. ");
INSERT INTO bvr_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","Rrapa Wangarr gun-nika gun-gata belabila gu-maya gatiya nipa wugupa burrwa Yichrayal yerrcha, wurra Bulítiya yerrcha burrbu-gaypuna Yichrayal yerrcha, rrapa Yilay bijirri-bokamurra Wopni rrapa Biniyach gatiya bitipa abirri-juwuna. ");
INSERT INTO bvr_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","An-ngardapa an-gugaliya Benyjamin an-baparrurr, gata awurr-bachina gu-gata wenga nipa a-yurtchinga a-ni, gu-maywapa ngorrngurra a-bena Jaylow. Nipa wupa an-murna mun-nigipa mirikal gipa mu-gorndanga rrapa jel ana-bama gu-gurrmurra, minypa nipa wargugu a-ni. ");
INSERT INTO bvr_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","Gun-gatiya nipa a-bena, an-gata Yilay a-ganana a-ni gata rrawa gu-gera, ngardawa nipa a-worijinga nula Wangarr gun-nika gun-gata birripa gubu-ganyja aburr-bona. Wurra an-gatiya an-gugaliya a-yurtchingapa a-ni, rrawa gojilapa a-wena burrwa, lika birripa gugu aburr-duwujana aburr-bona. ");
INSERT INTO bvr_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","Lika Yilay a-galiyana burrwa aburr-duwujana aburr-ni, lika nipa a-wena, “An-nga nula aburr-guna aburr-duwuja aburr-nirra?” Lika nipa an-gugaliya a-derichinga, lika ana-jarl, a-wena nula. ");
INSERT INTO bvr_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","Nipa Yilay jemberr gun-jaranga nula, minypa 98, rrapa nipa gapula a-ni. ");
INSERT INTO bvr_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","Rrapa nipa an-gata an-gugaliya a-yinagata nula, “Ngaypa gaba nyiburr-bachina nyiburr-ni geka nguna-yurtchinga nguna-ni.” Rrapa nipa Yilay a-wena nula, “Gu-yinmiya gu-bamburda?” ");
INSERT INTO bvr_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","Nipiya an-gata an-mujaruk a-wena nula, a-yinanga, “Yichrayal yerrcha aburr-yurtchinga aburr-ni burrwa aburr-guna Bulítiya yerrcha; gala yapa burrbu-burndarna. Wurra aburr-jaranga aburr-juwuna aburr-ngayburrpa gu-galiya yerrcha, rrapa nginyipa bijirri-bokamurra Wopni rrapa Biniyach, bitipa burr-guta abirri-juwuna. Rrapa Wangarr gun-nika gun-gata belabila gu-maya gatiya nipa wugupa arrburrwa a-jayanayana a-jinyja a-workiyana, wurra Bulítya aburr-guyinda arrbu-gaypuna gun-gata.” Ayinagata an-mujaruk gu-ngurrjinga. ");
INSERT INTO bvr_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","Wurra gun-gatiya gu-ngurrjinga Wangarr gun-nika gun-gata burrbu-gaypuna, lika Yilay gun-nika gun-gurrenyja gun-guni gatiya rrawa gu-gera nipa a-ninya, gu-gata wenga nipa a-bungguna rrapa mobula a-jirra a-wachina, lika a-juwuna. Ngardawa nipa an-gun.gun rrapa bama an-gungarlcha. Nipa junggay a-ni gun-jaranga jemberr, minypa 40. ");
INSERT INTO bvr_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","Rrapa Yilay an-nika an-walkurpa an-gata Biniyach gipa gun-nyagara gu-ni, jin-nigipa jin-gumarrbipa niya nipa jin-gata delipa a-rrimanga, ji-gochila a-ni yigurrepa a-bambungga barra. Nipa jin-guna gugu janguny jiny-jaliyana Wangarr gun-nika gun-gata belabila gu-maya gatiya nipa a-jayanayana a-jinyja burrwa a-workiyana Yichrayal yerrcha, wurra Bulítiya yerrcha burrbu-gaypuna, rrapa ji-gata an-nika gululapa acha rrapa an-gumarrbipa acha abirri-juwuna. Gun-narda nipa jiny-jaliyana, lika nipa gugu delipa a-bambungguna. ");
INSERT INTO bvr_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","Gun-gatiya nipa jin-guna yi-gurrepa jiny-juwuna jiny-bamuna, nipa jin-gata jin-mujama achila jiny-yena achila, “Gala barra ny-jurkuja, wurra an-nurra ny-menga.” Wurra nipa gala jiny-jaliyarna achila. ");
INSERT INTO bvr_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","Nipa jin-guna an-nelangga a-garrana Yikabat (Ichabod). Ngardawa jiny-yena, “Ganyjarr gu-bona arrburrwa Yichrayal yerrcha!” Jiny-yinagata jiny-yena, ngardawa Bulítiya yerrcha burrbu-gaypuna Wangarr gun-nika gun-gata belabila gu-maya gatiya nipa a-jayanayana a-jinyja burrwa a-workiyana, rrapa ngardawa gululapa acha rrapa an-gumarrbipa acha abirri-juwuna. ");
INSERT INTO bvr_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","Minypa nipa jiny-yena, “Ganyjarr gu-bona arrburrwa Yichrayal yerrcha, ngardawa Wangarr gun-nika gun-gata belabila gu-maya gatiya nipa a-jayanayana a-jinyja a-workiyana, wurra birripa arrbu-gaypuna.” ");
INSERT INTO bvr_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","Gun-gatiya waypa aburr-gata Bulítiya yerrcha burrbu-gaypuna Yichrayal yerrcha mun-gata jutkich mu-maya Wangarr mun-nika, lika mbi-ganyja Yebaníja wenga yi-gata gun-birripa rrawa Achol (Ashdod), ");
INSERT INTO bvr_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","Lika mbi-ganyja aburr-bamuna yi-gata wupa gu-bala wolawola an-mawunga a-jirra a-workiya an-birripa wangarr, an-gata an-nelangga Deygan (Dagon). Lika mbi-barnjinga mun-gata jutkich mu-maya gata nipa ana-gera. ");
INSERT INTO bvr_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","Ganapiya, lika aburr-gata Achol aburr-guyinda aburr-yu, guna-gepana, aburr-garlmuna, abi-nana an-gata Deygan an-ngana a-garriyana a-bungguna, a-yunya gatiya mu-gochila jutkich mu-maya Wangarr an-gata Ay-ninyarrapa Ay-workiya mun-nigipa. Lika an-gata Deygan abu-jarrkarrana, abu-garrana, a-jinyja gu-maywapa. ");
INSERT INTO bvr_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","Wurra minypa mola aburr-yu, guna-gepana, aburr-garlmuna, abi-nana Deygan mola an-ngana a-garriyana a-bungguna mu-gochila jutkich mu-maya Wangarr an-gata Ay-ninyarrapa Ay-workiya mun-nigipa. Minypa Deygan mernda a-jirra yerrjipa rrapa bama a-jirra ngardapa ngardapa aburr-yu gata gu-bala ngana gu-jirra, wurra burr-murrpa burr-rrepara wupa gata a-yunya mu-gochila mun-gata jutkich mu-maya. ");
INSERT INTO bvr_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","Gu-gurda nula minypa junggay yerrcha rrapa mola gu-galiya yerrcha Achol aburr-guyinda gala gubi-rrenyja gun-gata nipa Deygan a-bungguna gatiya bala ngana gu-jirra, Wurra aburr-jurrwurra aburr-workiya wolawola aburr-boya gurda aburr-workiya Deygan gun-nika rrawa. ");
INSERT INTO bvr_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","Lika nipa Ay-ninyarrapa Ay-workiya burr-buna aburr-gata Achol aburr-guyinda, rrapa burr-guya gun-nerra gu-ni burrwa. Minypa gun-guburlububurluja gun-gata moparn gu-maya wurpa lika gun-nerranga bin-dimarra gu-bona. ");
INSERT INTO bvr_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","Gun-narda birripa mu-wurra yerrcha Achol aburr-guyinda gubu-borrwurra gu-yinmiyana gun-nerra gu-ni burrwa, lika aburr-yinanga, “Wangarr an-gata Yichrayal yerrcha an-burriya, mun-guna mun-nigipa jutkich mu-maya gala nguburr-yinmiya ngubi-rrima nguburr-ni. Ngardawa nipa arr-burnda a-nirra ngayburrpa rrapa an-ngayburrpa wangarr Deygan.” ");
INSERT INTO bvr_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","Lika aburr-gatiya Bulítiya aburr-guyinda aburr-gonyjinga burrwa, aburr-birripa bunggawa yerrcha aburr-bona gurda, lika burrbu-wengganana, “A-lay, aburr-borrmunga, nguburr-yinmiya barra nula mun-guna Jutkich mu-maya? Ngardawa mun-nigipa ngubi-rrimanga nguburr-nirra wangarr mun-nika, wangarr an-gata Yichrayal yerrcha an-burriya. Gu-gurda nula nipa arr-burnda a-nirra.” Lika birripa bunggawa yerrcha aburr-yinanga, “Bubu-ga mola gun-ngayburrpa rrawa yi-gata Gat (Gath). Lika mbi-ganyja aburr-bona mun-gata jutkich mu-maya Wangarr mun-nika. ");
INSERT INTO bvr_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","Lika gun-gata waypa mbi-barnjinga gun-gata rrawa Gat, gu-gata wenga Ay-ninyarrapa Ay-workiya nipa burr-buna a-ni aburr-gata Gat aburr-guyinda, rrapa minypa gun-guwurrwurrja gu-jerrjinga burrwa. Minypa gapula yerrcha rrapa gu-ngarda yerrcha rrapa aburr-werranga burr-guta nipa burr-buna, gun-guburlububurluja minypa moparn gu-maya wurra gun-nerranga, gu-gurda ngacha bin-dimarra gu-bona. ");
INSERT INTO bvr_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","Birripa gugu mbi-ganyja aburr-bona mun-gata jutkich mu-maya Wangarr mun-nika, yi-gata barra mbi-barnja Yekran (Ekron),, mola Bulítiya yerrcha gun-burriya rrawa. Gun-gatiya waypa mbi-ganyja gurda aburr-bamuna mun-gata jutkich mu-maya Wangarr mun-nika yi-gata Yekran, lika wurra gama gorlk gu-gata burr-yika gu-rrawa aburr-gonyjinga, “Yoy, mbi-ganyja gurda aburr-bona mun-gata jutkich mu-maya! Murda wangarr mun-nika aburr-gata Yichrayal yerrcha an-burriya! Nipa arr-bun a-ningin!” ");
INSERT INTO bvr_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","Lika aburr-gonyjinga burrwa aburr-maywapa aburr-birripa bunggawa yerrcha aburr-gata Bulítiya aburr-guyinda. Lika aburr-yinanga burrwa, “Buburr-wengga burrwa, barra murda jutkich mu-maya mbi-ga aburr-yurtcha. Ngardawa wangarr mun-nika aburr-gata Yichrayal yerrcha an-burriya. Muy-jeka barra muy-boya gu-maywapa; gala yapa nguburr-gurdiya gorlk arr-bun.” Aburr-yinagata aburr-wena burrwa aburr-birripa bunggawa yerrcha, ngardawa birripa gu-galiya yerrcha aburr-gurkuja nula gun-gata gun-gujuwa, rrapa minypa aburr-wurrwurrjinga aburr-ji ngardawa Wangarr burr-buna a-ni. ");
INSERT INTO bvr_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","Minypa aburr-gata aburr-werranga gala aburr-juwiyarna, birripa jarra gubi-rrimarra gun-gata gun-guburlububurluja minypa moparn gu-maya wurra gun-nerranga. Birripa waykin aburr-gonyjinga, minypa ana-nga barra wanngu burr-nega. ");
INSERT INTO bvr_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","Mun-gata jutkich mu-maya Wangarr mun-nika an-gata Ay-ninyarrapa Ay-workiya, mun-narda waypa Bulítiya (Philistia) aburr-guyinda gun-burriya rrawa mu-yu ran.gu abirri-jirrapa abirri-jirrapa abirri-jirrapa an-ngardapa. ");
INSERT INTO bvr_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","Lika Bulítiya aburr-guyinda gu-galiya yerrcha aburr-gonyjinga burrwa aburr-birripa junggay yerrcha rrapa aburr-werranga aburr-gata aburr-wechawecha aburr-workiyana jarlakarr. Lika burrbu-wengganana, “A-lay, ngaypurrpa nyiburr-yinmiya barra mun-guna jutkich mu-maya an-gata Ay-ninyarrapa-Ay-workiya mun-nika? Wengga arrburrwa ngayburpa nyiburr-yinmiya barra nyibi-jerrma, mu-jeka barra gun-nigipa rrawa.” ");
INSERT INTO bvr_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","Birripa gubu-ngurrjinga burrwa, aburr-yinanga, “A-lay, minyja ana-goyburrpa nyibu-jerrma burrwa Yichrayel (Israel) yerrcha mun-guna jutkich mu-maya Wangarr mun-nika, wurra gala barra borijipa nyibi-jerrma. Wurra mun-nga burr-guta mun-molamola mun-gata nyibi-jerrma barra nula an-birripa Wangarr, mari minypa barra gun-molamola nyibi-nega ana-gorrburrwa. Gu-gurda ngacha minypa ana-goyburrpa nyiburr-molamiya barra rrapa marn.gi nyiburr-ni barra gun-gata gun-nga nula nipa an-gatiya nyirr-burnda a-nirra.” ");
INSERT INTO bvr_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","Birripa aburr-yinagata, “Mun-gata mun-nga ngayburrpa barra nyibi-jerrma nula?” “Minyja aburr-goyburrpa mu-ngoyurra aburr-jirra ana-gorrburrwa aburr-gata abirri-jirrapa abirri-jirrapa an-ngardapa nyirrbi-rrimanga rrapa birripa burr-guta gun-gata gun-gora nyirr-burnda gu-nirra. ");
INSERT INTO bvr_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","Ganapiya, lika nyibi-jarlapa barra nyibi-jerrma barra abirri-jirrapa abirri-jirrapa gun-ngardapa golden gun-guyinda moparn gu-maya arr-burlujarra arr-workiya, rrapa mola jocha jin-guyinda wana abirriny-jirrapa abirriny-jirrapa jin-ngardapa ji-gata ngacha minypa gun-goyburrpa rrawa gun-nerra gu-nenga jinyu-nirra. Ana-goyburrpa nyiburr-yirda barra nyiburr-delipa nyiburr-negiya barra nula wangarr an-gata Yichrayel yerrcha an-burriya, minyja rraka nipa nyirr-bawa barra ana-goyburrpa rrapa aburr-goyburrpa wangarr yerrcha rrapa gun-goyburrpa rrawa, minypa barra nyiburr-molamola nyiburr-ni barra. ");
INSERT INTO bvr_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","Minyjiya. Gala barra mun-goyburrpa mun-molma nyibu-jakabu nula minypa aburr-gata Yijipt (Egypt) aburr-guyinda rrapa an-birripa bunggawa an-gata an-birripa Berow (Pharoah). Birripa mun-molma mun-derta burrwa, wurra minypa Wangarr burr-buna a-workiyana, gun-nerra gun-jaranga gu-jerrmarra burrwa, lika burrbu-bawuna, Yichrayel yerrcha aburr-bona. ");
INSERT INTO bvr_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","“Ganapiya, lika buburr-boy, bubu-jarlapa gun-gururrgaka gun-geka. Lika burrbu-barripa abirriny-jirrapa bulugi mu-gama yerrcha delipa jibirrin-dimanga, abirriny-jata abirriny-babalapa minypa gala mu-ngoyurra jibirriny-jarlapungarna rraka gun-nga gubirrinyu-rurrgakajarna. Lika burrbu-bicha gun-gata gun-gururrgaka gun-geka barra gubirrinyu-rurrgaka. Rrapa burrbu-gaypa, jin-birrinyjipa delipa yerrcha burrbu-ga, burrbu-jolartcha wupa. ");
INSERT INTO bvr_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","Ganapiya, lika nyibu-ma mun-gata jutkich mu-maya wangarr mun-nika, an-gata Ay-ninyarrapa Ay-workiya mun-nigipa. Lika nyibu-gurrma gu-gochila gun-guna gun-gururrgaka. Rrapa mola mun-gata golden mun-guyinda nyibu-jarlapuna nula wangarr mun-nigipa, mun-narda nyibu-jolartcha wupa mun-nerranga mun-delipa jutkich mu-maya nyibu-jarlapuna. Lika nyibu-ga barra gurda, nyibu-gurrma barra mu-gera mun-gata jutkich mu-maya Yichrayel yerrcha an-birripa wangarr mun-nika. Lika bijirriny-jerrma abirriny-jata bulugi yerrinyjipa a-yinda barra abirriny-boy. ");
INSERT INTO bvr_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","Lika bubi-na buburr-ni minyja rraka gubirriny-bawa gun-ngayburrpa rrawa rrapa abirriny-boy Yichrayel yerrcha gun-birripa rrawa gun-gata Bechéymich (Beth-shemesh) gu-gapa gu-rrenyjiya. Lika ngayburrpa marn.gi nguburr-ni barra gun-guna gun-nerra gu-nirra arrburrwa ngardawa an-gata Ay-ninyarrapa Ay-workiya nipiya arr-burnda a-nirra. Wurra minyja gun-nyagara, lika marn.gi nguburr-ni barra gun-narda ngika minypa wangarr arr-burnda. Wurra gun-nyagara.” ");
INSERT INTO bvr_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","Ganapiya. Lika aburr-gata Bulítiya aburr-guyinda mu-wurra yerrcha aburr-yinagata jama aburr-ji, minypa aburr-birripa junggay yerrcha rrapa aburr-werranga aburr-gata aburr-wechawecha aburr-workiyana jarlakarr birripa aburr-wena burrwa. Burrbu-menga abirriny-jirrapa bulugi mu-gama yerrcha delipa burrbu-rrimanga. Lika burrbu-bichinga gun-gururrgaka barra gubirrinyu-rurrgaka, rrapa delipa burrbu-gaypuna, jibu jolartchinga wupa gu-ngarnama. ");
INSERT INTO bvr_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","Lika gu-gochila gun-gata gun-gururrka mbi-gurrmurra mun-gata jutkich mu-maya Wangarr mun-nika rrapa mola mun-gata mun-delipa jutkich mu-maya gipa gubu-jolartchinga golden gu-maya minypa moparn arr-burnda a-workiya rrapa mola jocha wana jin-guyinda. ");
INSERT INTO bvr_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","Yibirrich lika jin-gata bulugi jiny-jarlmunapa jiny-bona jechinawa gun-gata rrawa Bechéymich jin-ngoyurra. Minypa gu-jarlakarr jiny-bamuna, gala jinyu-lijiwarriyarna. Rrapa minypa waykin jin-duwujana jiny-bamuna. Rrapa minypa Bulítiya aburr-guyinda aburr-birripa mu-ngoyurra aburr-jirra burrwa, birripa burrbu-jurrjurrmurra abirriny-jata bulugi yerrcha aa gun-gata gugu burrbu-bawuna Bechéymich rrawa gubi-rrimarra, Yichrayal yerrcha gun-birriya. Ganapiya. ");
INSERT INTO bvr_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","Rrapa gu-galiya yerrcha aburr-gata Bechéymich aburr-guyinda, birripa gatiya balaja mbi-murlawurra aburr-ni, mu-ngoyurra aburr-lamajinga. Birripa gatiya waypa mbi-nana mun-gata jutkich mu-maya Wangarr mun-nika, birripa burr-guya aburr-worlworlcha. ");
INSERT INTO bvr_vpl VALUES ("S16_14","010_6_14","1SA","6","14","15","Gun-gata gun-gururrgaka guna-bamuna, gu-gurrema gu-gera gu-jinyja Jochuwa (Joshua) gun-nika rrawa, an-gata Bechéymich an-guyinda. Aburr-werranga aburr-gata Libay (Levi) yerrcha aburr-gatiya aburr-mujama nula Wangarr, birripa mbi-menga mun-gata jutkich mu-maya Wangarr mun-nika, rrapa mbi-gurrmurra waykin gun-gata gu-gurrema. Rrapa mun-gata mun-delipa jutkich mu-maya mbi-menga, mu-ngoyurra gubu-jorlartchinga gun-gata golden gun-guyinda minypa moparn rrapa jocha wana. Lika mbi-gurrmurra waykin gun-gata gu-gurrema. Lika aburr-werranga gu-galiya yerrcha aburr-gata gubi-rrumurra gun-gata gun-gururrgaka bol nula, lika burrbu-buna, abirriny-jata bulugi yerrcha, burrbu-yalpuna nuluwa Wangarr. Rrapa gun-gatiya gun-maywapa ngorrngurra aburr—jaranga aburr-gata Bechéymich aburr-guyinda gu-galiya yerrcha abu-wuna Wangarr jin-jaranga bulugi, minypa jibu-buna, jibi-yalpuna nula an-gatiya Ay-ninyarrapa Ay-workiya. ");
INSERT INTO bvr_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","Aburr-yinagata aburr-gata Bechéymich aburr-guyinda aburr-japurramayana nula Wangarr. Rrapa aburr-gata Bulítiya aburr-guyinda mu-ngoyurra aburr-jirra burrwa aburr-gatiya abirri-jirrapa abirri-jirrapa an-ngardapa, birripa gu-balay wenga burrbu-nana aburr-ji. Lika gun-maywapa ngorrngurra aburr-jekarra gun-birripa rrawa gun-gata Yekran. ");
INSERT INTO bvr_vpl VALUES ("S16_17","010_6_17","1SA","6","17","18","Gun-gata golden gun-guyinda abirri-jirrapa abirri-jirrapa gun-ngardapa moparn gu-maya, aburr-gata bunggawa yerrcha abu-wuna Wangarr barra mari gu-rruma burrwa, birripa werra aburr-negiyana. Rrapa golden gun-guyinda jocha gu-maya abu-wuna, gun-gata abirri-jirrapa abirri-jirrapa jin-ngardapa, ngardawa rrawa aburr-gata bunggawa yerrcha gubi-rrimarra abirri-jirrapa abirri-jirrapa gun-ngardapa – rrawa gun-gata gun-nelangga Achol (Ashdod), mola Gaja (Gaza), Atkalan (Ashkelon), Gat (Gath), rrapa Yekran. Rrapa gun-gata wana gun-gurrema Wangarr mun-nika jutkich mu-maya mbi-gurrmurrapa nipa gatiya Jochuwa gun-nika rrawa gu-jinyjarrapa, an-gata Bechémich an-guyinda. ");
INSERT INTO bvr_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","Wurra Wangarr an-gata Ay-ninyarrapa Ay-workiya nipa burr-buna, aburr-juwuna aburr-jaranga gu-galiya yerrcha mu-wurra yerrcha aburr-gata Bechémich aburr-guyinda, aburr-gatiya minypa mbi-lapkujamurra, mbi-nana wupa mun-gata jutkich mu-maya Wangarr mun-nika. Aburr-jaranga burr-buna aburr-gata, 70 gu-galiya yerrcha mu-wurra yerrcha. Rrapa wurra gama gorlk aburr-gata, birripa burr-guya wargugu abirr-ni ngardawa Wangarr a-yinagata burr-buna. ");
INSERT INTO bvr_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","Aburr-gonyjinga, aburr-yinanga, “Ya, gurrpuranga ngayburrpa! Gala ana-nga a-yinmiya a-jinyja nipa ana-gochila an-guna Wangarr an-ngardapiya Ay-ninyarrapa Ay-workiya! Mun-guna jutkich mu-maya mun-nigipa yina gaya barra ngubi-jerrma?” ");
INSERT INTO bvr_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","Wurra aburr-mujaruk burrbi-jerrmarra burrwa gu-galiya yerrcha Giriyat-Jarim (Kiriath Jearim) aburr-nirra. Minypa aburr-yinanga burrwa, “An-ngayburrpa Wangarr an-gatiya Ay-ninyarrapa Ay-workiya, mun-nigipa jutkich mu-maya Bulítiya yerrcha arrbu-gaypuna, wurra mun-guna gugu birripa mbi-gurdanyjinga gurda arrburrwa. Ngaw minyja nyiburr-bupiya gurda, nyibu-ma barra gu-goyburrpa rrawa mu-jinyja barra?” ");
INSERT INTO bvr_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","Ganapiya, lika Giriyat-Jarim (Kiriath-Jearim) aburr-guyinda gu-galiya yerrcha aburr-bona, mbi-menga mun-gata jutkich mu-maya Wangarr mun-nika an-gata Ay-ninyarrapa Ay-workiya. Lika mbi-ganyja gurda, gu-bala wupa mbi-gurrmurra Abínadap (Abinadab) gun-nika mu-mirk gu-jirra rrawa. Rrapa abu-menga an-nigipa an-walkurpa an-gata Yiliyíja (Eleazar) barra jaga a-gana mun-gata jutkich mu-maya Wangarr mun-nika. ");
INSERT INTO bvr_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","Ganapiya, lika mun-gata jutkich mu-maya Wangarr mun-nika gata mu-ni jemberr gun-jaranga, minypa murna arr-jirra rrepara arr-jirra, 20, gatiya. Rrapa warrpam gu-galiya yerrcha Yichrayel (Israel) aburr-guyinda wargugu aburr-ni, aburr-wechawecha nulu Wangarr an-gatiya Ay-ninyarrapa Ay-workiya. ");
INSERT INTO bvr_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","Lika Jemyul (Samuel) a-wena burrwa wurra gama gorlk Yichrayel yerrcha, “Minyja gun-burral nyiburr-ngukurdanyjiya nyiburr-nirra nuluwa Wangarr, lika bubu-yerrnyja an-guripa an-guyinda wangarr nyibi-rrimanga, jin-mawunga jin-guyinda burr-guta jin-gata Átoret (Ashtoreth). Buburr-wuya nuluwa an-gata Ay-ninyarrapa Ay-workiya, rrapa bubi-yagurrma nula buburr-workiya gun-nigipa jal. Lika nipa nyirr-jarlapa nyirr-ma aburr-gata aburr-bachirra, Bulítiya yerrcha.” ");
INSERT INTO bvr_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","Ganapiya, lika Yichrayel yerrcha burrbu-bawuna an-mawunga an-guyinda jin-mawunga jin-guyinda, Beyal (Baal) rrapa Atoret. Rrapa aburr-marrngoypiyana nula aburr-workiyana Ay-ninyarrapa Ay-workiya, nipa wupa ngardapa. ");
INSERT INTO bvr_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","Lika Jemyul a-wena burrwa, a-yinagata, “Ana-goyburrpa nyiburr-bulapalawa Yichrayel yerrcha buburr-bamgutuwuya gurda rrawa Michpa (Mizpah), rrapa an-gata Ay-ninyarrapa Ay-workiya ngu-wenggana barra ana-gorrburrwa. ");
INSERT INTO bvr_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","Lika gatiya waypa aburr-bamagutuwuyana gu-rrawa Michpa, bugula gubu-wembarra, gubu-jerrjerrjinga nula Wangarr. Balaja mbi-bawuna gun-ngardapa ngorrngurra, rrapa aburr-ngurrjiyana, aburr-yinanga, “Ngayburrpa werra nguburr-negiyana nulawa Wangarr an-gata Ay-ninyarrapa Ay-workiya.” Aburr-yinagata Yichrayel yerrcha aburr-ngukurdanyjiyana nuluwa Wangarr, mu-ngoyurra aburr-lijiwarriyana. Lika gatiya rrawa Michpa nipa Jemyul a-galiyana burrwa a-workiyana, nipiya a-yinmiya barra a-wengga. ");
INSERT INTO bvr_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","Gun-gata waypa aburr-gata bunggawa yerrcha Bulítiya (Philistia) aburr-guyinda aburr-galiyana Yichrayel yerrcha aburr-bamagutuwiyana gun-gata rrawa Michpa, birripa gubu-borrwurra jimarna an-dakal nula. Lika aburr-birripa an-dakal burrbu-ganyja gurda aburr-bamuna, aburr-bacha barra. Wurra gun-narda Yichrayel yerrcha gubu-borrwurra, burr-guya aburr-gurkuja burrwa. ");
INSERT INTO bvr_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","Aburr-wena nula Jemyul, aburr-yinanga, “Gala barra n-dericha! Wurra ny-jonyjapa barra nula Wangarr, barra nipa arr-jarlapa arr-ma aburr-gata Bulítiya yerrcha.” ");
INSERT INTO bvr_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","Lika Jemyul jiny-menga jin-delipa jip (sheep), lika jiny-buna, jiny-yalpuna nulawa Wangarr jin-nigipa. Minypa jin-dongapa, lak jiny-jayana. Burr-guya a-wengganana burrwa Yichrayel yerrcha barra nipiya an-gata Ay-ninyarrapa Ay-workiya a-gunggaja burrwa. Rrapa nipa a-galiyana nula. ");
INSERT INTO bvr_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","Gun-gatiya waypa Jemyul jiny-yalpuna a-ni jiny-gata jin-delipa jip, aburr-gata Bulítiya yerrcha an-dakal aburr-bena. Wurra Wangarr a-durrjinga burrwa burr-guya rrapa minypa bambulabulawa burr-negarra, yanma Yichrayel yerrcha aburr-molamiyana, Bulítya yerrcha aburr-nyagara. ");
INSERT INTO bvr_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","Yichrayel yerrcha burrbu-bitimarrapa burrbu-bunapa Michpa wenga aa Betkár (Beth-car). ");
INSERT INTO bvr_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","Rrapa Jemyul jandarra gu-menga, gu-garrana gojilapa abirri-gata abirri-jirrapa rrawa Michpa rrapa Jen (Shen). Gun-nelangga gu-garrana “Gun-guborrwa.” Minypa a-yinanga, “Wangarr a-gunggajingapa arrburrwa aa gun-guniya.” ");
INSERT INTO bvr_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","Gu-gurda ngacha minypa Yichrayel yerrcha aburr-molamiyana; Bulítiya yerrcha gun-nyagara. Rrapa gun-baykarda gu-ni gala mola Bulítiya yerrcha an-dakal aburr-boyarna gurda, wurra Wangarr a-gorlkakaja burrwa a-ni gun-gatiya Jemyul a-ninyarrapa. ");
INSERT INTO bvr_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","Rrapa rrawa gu-ji gu-bamuna mu-ngoyurra Bulítiya yerrcha burrbu-gaypuna Yichrayel yerrcha, gun-gata Yekron (Ekron) wenga rrapa Gat (Gath), wurra guna-jekarra burrwa Yichrayel yerrcha. Rrapa mola Yichrayel yerrcha gubu-menga gojilapa gu-ji rrawa burr-guta. Rrapa gun-nerranga: Magaya gu-ji burrwa gu-gapa gu-guta Yichrayel yerrcha rrapa aburr-werranga aburr-gata Ámorach (Amorite) yerrcha. ");
INSERT INTO bvr_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","Ganapiya, lika Jemyul a-ni burrwa a-workiyana Yichrayel yerrcha an-birripa a-galiyana burrwa a-workiyana nipa a-yinmiya barra a-wengga. A-yinagata a-ni burrwa a-workiyana nuwurra a-juwuna. ");
INSERT INTO bvr_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","Jemberr gu-ni gu-workiyana, a-gomarriyana a-workiyana, a-galiyana burrwa a-workiyana nipa a-yinmiya barra a-wengga, minypa gun-gata rrawa Betal (Bethel) rrapa Gilgal rrapa Michpa. ");
INSERT INTO bvr_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","Lika a-jekarra a-workiyana gun-nigipa rrawa Rama (Ramah). Gatiya burr-guta a-galiyana burrwa a-workiyana nipa a-yinmiya barra a-wengga. Rrapa mola gun-gurrema gu-jarlapuna belabila gu-maya, gatiya minypa jibu-yalpuna, abu-wuna aburr-workiyana Wangarr jin-nigipa, minypa jip waygaji bulugi. ");
INSERT INTO bvr_vpl VALUES ("IS9_6","024_9_6","ISA","9","6","6","An-delipa a-bambungguna arrburrwa. Wangarr an-gata ay-ninyarrapa ay-workiya an-nigipa walkurpa ana-jerrmarra arrburrwa. An-ngayburrpa bunggawa a-ni barra an-molamola. An-nelangga abu-ngurrja barra aburr-workiya An-gugunggaja An-molamola, Wangarr Burr-barlmarrk Jama A-jirra, An-ngayburrpa Nyanyapa Arrburrwa A-jirrapa A-workiya, An-ngayburrpa Mu-ngoyurra A-jirra arrburrwa, Mari An-nyagara Arr-jalkakaja A-workiya. ");
INSERT INTO bvr_vpl VALUES ("MC6_8","034_6_8","MIC","6","8","8","Alay, ny-jurnarra ny-jaliyarra ny-yorkiya, nyi-gugaliya, Wangarr gipa biy-gurdagurdarrana gun-nga gun-molamola. Ya? Nipa jal a-nirra nginyipa barra ny-yinmiya barra ny-yorkiya? Wurra nginyipa barra ny-yinda barra ny-yorkiya gun-molamola. Jal nyi-ni barra ny-yorkiya ny-junggaja barra burrwa. Delipa nyi-negiya barra ny-yorkiya, Wangarr ny-jurdajurdamunga ny-jamburda. ");
INSERT INTO bvr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Mu-guna mu-jurra aburr-welangga aburr-yurra Jesus Christ burr-yika aburr-bapurr, an-gatiya minypa Daybit (David) abirri-bapurr, Daybit an-gata nipa minypa Aybriyam (Abraham) abirri-bapurr, minypa aburr-ngardapa aburr-bapurr. ");
INSERT INTO bvr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Minypa Aybriyam nipa a-bokamurra Ayjek (Isaac), rrapa Ayjek nipa a-bokamurra Jeykap (Jacob), rrapa Jeykap nipa burr-bokamurra Juda (Judah) rrapa aburr-yigipa worlapa burra yerrcha, ");
INSERT INTO bvr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","rrapa Juda nipa bijirri-bokamurra Berech (Perez) rrapa Jara (Zerah), nipa jin-gata Deymar (Tamar) bijirri-menga nula. Rrapa Berech nipa a-bokamurra Yechran (Hezron), rrapa Yechran nipa a-bokamurra Ram, ");
INSERT INTO bvr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","rrapa Ram nipa a-bokamurra Amínadap (Amminadab), rrapa Amínadap nipa a-bokamurra Nachon (Nahshon), rrapa Nachon nipa a-bokamurra Jalman (Salmon), ");
INSERT INTO bvr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","rrapa Jalman nipa a-bokamurra Bowech (Boaz), jin-gata Reyep (Rehab) a-menga nula. Rrapa Bowech nipa a-bokamurra Abet (Obed), jin-gata Ruch (Ruth) a-menga nula. Rrapa Abet nipa a-bokamurra Jechi (Jesse), ");
INSERT INTO bvr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","rrapa Jechi nipa a-bokamurra Daybit an-gata nipa bunggawa a-ni. Rrapa Daybit nipa a-bokamurra Jolaman (Solomon), jin-gata mu-ngoyurra Yuráya (Uriah) jin-nika jinyu-ni nipa a-menga nula. ");
INSERT INTO bvr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Rrapa Jolaman nipa a-bokamurra Reyabówam (Rehoboam), rrapa Reyabówam nipa a-bokamurra Abáyja (Abijah), rrapa Abáyja nipa a-bokamurra Acha (Asa), ");
INSERT INTO bvr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","rrapa Acha nipa a-bokamurra Jiwóchipat (Jehoshaphat), rrapa Jiwóchipat nipa a-bokamurra Joram, rrapa Joram nipa a-bokamurra Ajáya (Uzziah), ");
INSERT INTO bvr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","rrapa Ajáya nipa a-bokamurra Jocham (Jotham), rrapa Jocham nipa a-bokamurra Ayach (Ahaz), rrapa Ayach nipa a-bokamurra Yechakáya (Hezekiah), ");
INSERT INTO bvr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","rrapa Yechakáya nipa a-bokamurra Manécha (Manasseh), rrapa Manécha nipa a-bokamurra Aymon (Amon), rrapa Aymon nipa a-bokamurra Jowcháya (Josiah). ");
INSERT INTO bvr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Rrapa minypa an-dakal Babalan (Babylon) aburr-guyinda aburr-bona gurda, burrbi-rrimarra aburr-workiyana Ju yerrcha, rrapa burrbu-ganyja gu-birripa gu-rrawa, gun-gatiya waypa nipa Jowcháya burr-bokamurra Jekonáya (Jechoniah) rrapa aburr-yigipa worlapa niya yerrcha. ");
INSERT INTO bvr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Rrapa nuwurra waypa gun-gata mari gu-wulebiyana, nipa Jekonáya a-bokamurra Jiyáltil (Shealtiel), rrapa Jiyáltil nipa a-bokamurra Jirábabal (Zerubbabel), ");
INSERT INTO bvr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","rrapa Jirábabal nipa a-bokamurra Abáyut (Abiud), rrapa Abáyut nipa a-bokamurra Yiláyakim (Eliakim), rrapa Yiláyakim nipa a-bokamurra Ayjor (Azor), ");
INSERT INTO bvr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","rrapa Ayjor nipa a-bokamurra Jeydok (Zadok), rrapa Jeydok nipa a-bokamurra Aykim (Achim), rrapa Aykim nipa a-bokamurra Yiláyut (Eliud), ");
INSERT INTO bvr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","rrapa Yiláyut nipa a-bokamurra Yiliyécha (Eleazar), rrapa Yiliyécha nipa a-bokamurra Metan (Matthan), rrapa Metan nipa a-bokamurra Jeykap (Jacob), ");
INSERT INTO bvr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","rrapa Jeykap nipa a-bokamurra Jochap (Joseph). An-gata Jochap nipa Meri (Mary) an-nika an-gumarrbipa acha, Meri nipa jin-gatiya a-menga Jesus, an-gatiya ngayburrpa ngubu-ngurrjinga nguburr-workiya Christ. ");
INSERT INTO bvr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ganapiya, wurra gun-gata Aybriyam a-ninya, rrapa gu-gata wenga Daybit a-ninya, aburr-jaranga aburr-goma aburr-negiyana murna aburr-wuchichiyana aburr-bona, minypa 14. Rrapa gun-gata Daybit a-ninya, rrapa gu-gata wenga Babalan aburr-bona, mola aburr-jaranga aburr-goma aburr-negiyana murna aburr-wuchichiyana aburr-bona, minypa 14. Rrapa gun-gata Babalan aburr-bona, rrapa gu-gata wenga Christ a-ninya, mola aburr-jaranga aburr-goma aburr-negiyana murna aburr-wuchichiyana aburr-bona, minypa 14. Gu-guyinarda ngacha. ");
INSERT INTO bvr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Gun-guna janguny Jesus Christ gun-nika minypa nipa a-yinmiyana a-bambungguna. Jin-nigipa mampa niya jin-gata Meri, nipa gipa mu-ngoyurra gochila abi-rrana Jochap. Wurra nipa gala jiny-manggarnapa burdak, nipa Meri gu-borrwurra, minypa nipa yokuyoka jinyu-durtchinga nipa wupa Mern An-mawunga nyanma. ");
INSERT INTO bvr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Rrapa Meri an-nigipa an-gumarrbipa ngacha an-gata Jochap, wuriya nipa jechinuwa a-nipa ay-workiyana, wurra nipa gala jal a-nirrarna mari gu-garra achila; wurra jarra nipa gu-borrwurra a-ni, nipa a-yinmiya barra jiny-bawa, wurpa lika minypa nipa jin-gata gala jiny-yinmiya mari gu-ma. ");
INSERT INTO bvr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wurra gun-gata waypa nipa gu-borrwurra a-ni, gu-gatiya wenga nipa gugu gu-nana borrich: Wangarr ana-jerrmarra waykin an-guyinda an-mujaruk a-bena nula, lika a-wena nula, a-yinanga, “Jochap, a-lay, ny-junarda nginyipa Daybit ny-bapurr, gala barra ny-jengama Meri jin-gata jin-nginyipa gochila gochila jin-gurra. Wurra nginyipa barra ny-ma. Wurra nipa yokuyoka jinyu-durtchinga, ngardawa nipa wupa Mern An-mawunga nyanma. ");
INSERT INTO bvr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nipa Meri a-ma barra an-nurra, rrapa nginyipa barra an-nelangga ny-jarra Jesus, ngardawa aburr-yigipa gu-galiya yerrcha nipa barra wanngu burr-nega gun-gata gun-nerra birripa gubi-rrimanga.” ");
INSERT INTO bvr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ganapiya, lika gu-yinagata gu-bona Jesus nipa a-bambungguna. Ngardawa Wangarr mu-ngoyurra a-wena, an-nigipa an-mujaruk ngunyuna an-guyinda gu-ngurrjinga, a-yinanga, ");
INSERT INTO bvr_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Minyja na, jin-ngamangama nipa jinyu-durtcha barra, gala ana-nga jiny-manggarnapa, rrapa yokuyoka a-ma barra, rrapa nipa an-nelangga abu-ngurrja barra Yimányuwal (Immanuel)” — an-gata an-nelangga minypa ngayburrpa nguburr-yinaga nguburr-weya nguburr-workiya, “Wangarr wugupa arrburrwa.” ");
INSERT INTO bvr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ganapiya, lika gun-gatiya Jochap a-garlmuna, lika nipa a-yinagata minypa Wangarr an-nika waykin an-guyinda an-mujaruk an-gata a-wena nula; nipa Jochap jiny-menga jin-nigipa gochila jin-gurra, ");
INSERT INTO bvr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","wurra gala gun-burral jiny-manggarna burdak, nuwurra waypa nipa an-nurra a-menga. Rrapa Jochap an-nelangga a-garrana Jesus. ");
INSERT INTO bvr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus a-bambungguna gatiya gu-delipa gu-rrawa Betliyam (Bethlehem), gun-gata wana gu-bapala gu-rrawa gun-nelangga Judíya (Judea), rrapa gun-gatiya waypa nipa a-bambungguna, an-gata Ayrat (Herod) bunggawa gu-gata a-yika gu-rrawa. Rrapa gun-baykarda ngika, lika aburr-werranga gu-galiya yerrcha aburr-gata gun-jaranga marn․gi aburr-ni, birripa aburr-bona gurda marnnga jina-burrbeya wenga, lika aburr-bena Jirúchalam (Jerusalem). Lika burrbu-wengganana aburr-bona, aburr-yinanga, ");
INSERT INTO bvr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Yina an-gaya nipa a-bambungguna bunggawa Ju yerrcha an-burriya? Ngardawa ngayburrpa nyibi-nana jin-gata jin-nigipa gata jiny-jayanayana, jina-warrchinga jina-bamuna yi-gata marnnga jina-burrbeya, lika ngayburrpa nyiburr-garlmuna gurda, barra nyiburr-marrngoypiya nula Bunggawa a-bambungguna.” ");
INSERT INTO bvr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Aburr-yinagata aburr-wena, rrapa gun-gata janguny nuwurra waypa an-gata Bunggawa Ayrat a-galiyana, lika nipa a-gurkuja, rrapa aburr-jaranga aburr-gata Jirúchalam aburr-nirra birripa burr-guta aburr-gurkuja. ");
INSERT INTO bvr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Lika nipa Ayrat burr-bamagutuwurra wana junggay yerrcha rrapa joborr marn․gi aburr-gunega Ju yerrcha aburr-burriya. Lika nipa burr-wengganana Christ nula minyja janguny gu-yu gun-an․gaya rrawa nipa barra a-bambungga. ");
INSERT INTO bvr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Lika birripa gubu-ngurrjinga nula, “Gun-gata gu-rrawa Betliyam a-bambungga barra, wana gu-bapala gu-rrawa Judíya. Minypa Wangarr an-nika an-mujaruk ngunyuna an-guyinda wola a-wukurrjinga gun-gata nula rrawa nipa janguny gu-yurra, gu-yinaga: ");
INSERT INTO bvr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Rrapa nginyipa ny-jurda rrawa Betliyam wana gu-bapala gu-rrawa Judíya, nginyipa gala n-delipa, jimarn jarra Judíya rrawa gu-jirra gu-boya gun-nerranga wana. Ngika. Wurra nginyipa ny-jurdiya rrawa Betliyam, an-gugaliya nginyipiya wenga nipa mu-ngoyurra a-ji barra rrapa jaga a-gana barra burrwa aburr-ngaypa gu-galiya yerrcha Yichrayal (Israel) aburr-guyinda.’” Aburr-yinagata aburr-gata wana junggay yerrcha rrapa joborr marn․gi aburr-gunega gubu-ngurrjinga nula Ayrat. ");
INSERT INTO bvr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Lika aburr-gata minypa marnnga jina-burrbeya wenga aburr-bona gurda Jirúchalam, nipa Ayrat yongun a-gonyjinga burrwa, birripa aburr-bona gurda nula. Lika nipa burr-wengganana yongun, gu-yinpa birripa jibi-nana jin-gata gata jiny-jayanayana. ");
INSERT INTO bvr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Rrapa gun-narda waypa nipa marn․gi a-ni, lika burr-jerrmarra rrawa Betliyam. Minypa nipa gu-jarlapuna a-wena, a-yinagata burrwa, “Buburr-boy, delipa buburr-wecha nula, nuwurra nyibu-barripa. Lika nyiburr-jeka barra gurda ngunyuna, rrapa marn․gi ngunabi-nega barra ngaypa burr-guta ngu-boy, ngu-marrngoypiya nula.” ");
INSERT INTO bvr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ganapiya, lika aburr-bona. Lika mola jibi-nana jin-gata gata mu-ngoyurra jibi-nana, mu-ngoyurra jiny-jayanayana jiny-ji gata marnnga jina-burrbeya jina-workiya; wurra nipa gugu jiny-juguyana burrwa jiny-bamuna, nuwurra jinyu-derichinga waykin delipa a-yurrapa. ");
INSERT INTO bvr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Gun-gatiya birripa jibi-nana jin-gata gata, lika burr-guya aburr-worlworlcharra. ");
INSERT INTO bvr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Lika aburr-barrngumurra wupa gu-bala, rrapa gun-gata waypa burrbi-nana delipa rrapa jin-nigipa mampa niya Meri, lika aburr-menama gubi-rrana nula rrapa aburr-marrngoypiyana nula. Lika gun-molamola gun-guyinda minypa gubu-ganyja gurda nula gun-nigipa, birripa gubu-menga, abu-wuna: minypa goldan (gold) rrapa mun-molamola mun-gungolkuja mun-gata mun-nelangga buréngkinyjen (frankincense), rrapa barrwa mun-gata mur (myrrh) mun-nelangga. ");
INSERT INTO bvr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ganapiya, lika gu-gata wenga birripa aburr-jekarra gun-birripa rrawa; wurpa lika gun-nerranga jarlakarr gubu-menga, ngardawa Wangarr burr-wuna borrich gubi-nana minypa gala aburr-yinmiya aburr-jeka nula Ayrat. ");
INSERT INTO bvr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Gun-gata waypa minypa birripa aburr-bona, lika nipa Jochap borrich gu-nana minypa Wangarr an-nika waykin an-guyinda an-mujaruk a-bena nula, a-wena nula, “Garlma! Bijirriny-ma an-guna delipa rrapa jin-nigipa mampa niya. Lika bubu-bawa gun-guna rrawa, buburr-boy yi-gata Yijipt (Egypt), gatiya barra nyiburr-ni nuwurra ngaypa ngu-wengga barra nggula. Ngardawa an-gata Ayrat, nipa ana-nyala ana-garlmurda, a-wechawechin nuluwa an-guna delipa barra a-bu.” ");
INSERT INTO bvr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Lika Jochap a-garlmuna, bijirriny-menga delipa rrapa mampa niya. Lika gun-gatiya ana-munya gu-ni, nipa bijirriny-janyja a-bamuna gata Yijipt. ");
INSERT INTO bvr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Lika nipa gatiya a-ni nuwurra Ayrat gun-nyagara gu-ni. Gu-gurdiya ngacha, nuwurra barra gu-yinda gu-ni minypa Wangarr mu-ngoyurra a-wena, an-nigipa an-mujaruk ngunyuna an-guyinda gu-ngurrjinga, a-yinanga, “Ngaypa ng-gonyjinga nula an-ngaypa Walkur, nipa Yijipt wenga ana-bona.” ");
INSERT INTO bvr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Wurra an-gata Ayrat, nuwurra waypa nipa gu-borrwurra minypa aburr-gata marnnga jina-burrbeya wenga aburr-boya gurda birripa abu-yolkaja, lika nipa burr-guya a-bachirramiyana. Lika a-wena burrwa aburr-yigipa aburr-mujama birripa barra aburr-boy, rrapa Betliyam rrawa gu-jirra gu-boya burrbu-bu barra aburr-boy, burrbu-wuleba barra gu-ngarda yerrcha wurra an-guyinda aburr-gata minypa gala abirri-jirrapa gun-ngardapa jemberr gu-nirrarna burrwa. Gun-gata nipa a-wena, minypa “gu-ngarda yerrcha wurra an-guyinda gala abirri-jirrapa gun-ngardapa jemberr gu-nirrarna burrwa,” ngardawa nipa gu-borrwurra gu-yinpa jin-gata gata birripa gu-gegapa jibi-nana jiny-jayanayana. Ngardawa aburr-gata marnnga jina-burrbeya wenga, birripa gipa mu-ngoyurra aburr-wena nula. ");
INSERT INTO bvr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ganapiya, lika Ayrat burr-yika aburr-mujama burrbu-buna aburr-bona gu-ngarda yerrcha wurra an-guyinda. Gu-gurdiya ngacha, ngardawa Wangarr mu-ngoyurra a-wena, an-nigipa an-mujaruk an-gata Jeramáya (Jeremiah) gu-ngurrjinga, a-yinanga, ");
INSERT INTO bvr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Gun-gata rrawa Rama (Ramah) birripa aburr-galiyarra burrwa burr-guya aburr-rruwuja. Minypa gun-maywapa jin-gata Reychel (Rachel) jin-duwujana burrwa aburr-yigipa gu-ngarda yerrcha rrapa gala jiny-jaliyarna burrwa aburr-werranga aburr-gata jimarna gubu-borrwurra gun-borrmunga aburr-weyarna achila, wurra jarra burr-borrwurra aburr-yigipa gu-ngarda yerrcha gun-nyagara gu-ni.” ");
INSERT INTO bvr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nuwurra waypa an-gata Ayrat a-juwuna, lika Wangarr an-nika waykin an-guyinda an-mujaruk a-bena nula Jochap gatiya gu-rrawa Yijipt (Egypt) nipa a-ninya. Minypa Jochap borrich gu-nana, an-gata waykin an-guyinda an-mujaruk a-wena nula, ");
INSERT INTO bvr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Garlma! Bijirriny-ma! Delipa rrapa jin-nigipa mampa niya bijirriny-ja barra ny-boy rrawa Yichrayal yerrcha gun-burriya. Ngardawa aburr-gata mu-ngoyurra jal aburr-ni an-guna delipa barra abu-bu, birripa gipa gun-nyagara gu-ni.” ");
INSERT INTO bvr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ganapiya, lika Jochap a-garlmuna, bijirriny-menga delipa rrapa mampa niya. Lika bijirriny-janyja a-bona, aburr-jekarra rrawa Yichrayal yerrcha gun-burriya. ");
INSERT INTO bvr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Wurra nuwurra waypa Jochap a-galiyana janguny, minypa Ayrat murna a-wuna an-nigipa walkur Akilich (Archelaus) rrapa nipa gugu bunggawa a-ni gun-gata wana gun-bapala rrawa Judíya, lika nipa Jochap a-gurkuja, jimarn jarra nipa a-boy barra yi-gata. Wurra Wangarr barrwa a-wuna Jochap, nipa borrich gu-nana, lika a-bona wana gun-bapala rrawa Galali (Galilee), ");
INSERT INTO bvr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","lika gatiya a-ni gu-delipa gu-rrawa Nejarach (Nazareth). Gu-gurdiya ngacha, nuwurra barra gu-yinda gu-ni minypa Wangarr an-nika an-mujaruk ngunyuna an-guyinda gipa mu-ngoyurra a-wena, a-yinanga, “Nipa birripa abu-ngurrja barra minypa nipa Nejarach an-guyinda.” ");
INSERT INTO bvr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Gun-gatiya lika Jon (John) an-gata bama burr-gurragaja a-workiya, nipa a-garlmuna, wana gu-bapala gu-rrawa Judíya (Judea) yi-gata gu-werrapa nipa a-wena burrwa a-workiyana, a-yinagata, ");
INSERT INTO bvr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Bubu-bawa gun-nerra. Buburr-ngukurdanyjiya nula Wangarr. Ngardawa yi-gurrepa gu-jirra gu-boya rum gun-gata waykin wenga.” ");
INSERT INTO bvr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon a-yinagata a-wena burrwa. Ngardawa Wangarr an-nika an-mujaruk an-gata Aycháya (Isaiah) nipa ana-nyala gipa mu-ngoyurra a-ngurrjinga an-guniya Jon, nipa Aycháya a-yinanga, “An-nerranga an-gata a-jabarrchinga a-jirra yi-gata gu-werrapa, nipa a-yinaga a-weya, ‘A-lay, nipa Bunggawa ana-boya! Jarlakarr nawanawa buburr-ni nula! Gun-jechinuwa bubi-nega nula!’” ");
INSERT INTO bvr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nipa Jon mirikal a-barrngumurra a-workiyana jin-murga gemul (camel) jibi-jarlapuna, wurpa lika burr-guya mun-derta; rrapa jin-maliyarra a-barrbichiyana a-workiyana. Rrapa nipa jiny-barra a-workiyana jin-gubatpatcha, rrapa woma gu-barra a-workiyana. ");
INSERT INTO bvr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Rrapa gu-galiya yerrcha aburr-bona gurda nula aburr-workiyana Jirúchalam (Jerusalem) wenga, rrapa barrwa gu-gata wenga rrawa gu-jirra gu-boya gun-gata wana gu-bapala gu-rrawa Judíya (Judea), rrapa gun-gata rrawa Jordan man․garba gu-werrwerrjinga gu-yurra gu-gatiya wenga burr-guta. ");
INSERT INTO bvr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Minypa birripa gubu-bawuna mu-ngoyurra gun-nerra jama aburr-ji, lika Jon bama burr-gurragaja gatiya man․garba gu-guyinda gun-nelangga Jordan. ");
INSERT INTO bvr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Gun-gata waypa Jon burr-nana Berachi (Pharisee) yerrcha rrapa Jejuchi (Sadducee) yerrcha aburr-bona gurda nula barra nipa bama burr-gurraga, wurra nipa a-yinanga burrwa, “Ana-goyburrpa nyiburr-gurda minypa an-gata jarn․gich an-guyinda. Wurra ana-nga a-wena ana-gorrburrwa ana-goyburrpa nyiburr-yurtchingapa, jimarna ana-goyburrpa wupa ngardapa wanngu nyiburr-negiya barra gun-gata mari guna-bamburda? Wurra gala nyiburr-yinmiya. ");
INSERT INTO bvr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Wurra ana-goyburrpa minypa gun-maywapa gun-jong gala mun-molamola balaja mu-rrima. Minypa gun-burral ana-goyburrpa yama nyiburr-yinda jama nyiburr-ji minypa gun-nerra nyibu-bawa? ");
INSERT INTO bvr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Wurra gala barra ana-goyburrpa ngardapa ana-gorrburra nyiburr-wengga, nyiburr-yinda, ‘Ngika. Wurra ngayburrpa jarra Aybriyam (Abraham) an-ngayburrpa nyanyapa arrburra.’ Wurra ngaypa jarra ngu-weya ana-gorrburrwa: Wangarr minyja nipa jal a-ni, nipa ganyjarr gu-rrimanga, gun-guna jandarra gun-jaranga gu-yurra nipa gu-jarlapa minypa Aybriyam burr-yika gu-ngarda yerrcha aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Wurra gun-gata gun-maywapa ngaypa ngu-wena ana-goyburrpa gun-jong, wurra an-gata minypa an-maywapa galamang an-gurrimapa, nipa gugu gu-jaywuja a-jirra gun-gata gun-jong burr-bama burr-rrepara barra gu-yartkujama. Minyjiya. Gun-jong gun-guyinda gun-gata gala mun-molamola balaja mu-rrima, nipa an-gata gu-yartkujama barra, rrapa gu-yerrnyja barra yi-gata gu-bol. ");
INSERT INTO bvr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ngaypa bama arr-gurragaja ngu-workiya ana-goyburrpa gu-bugula gu-guyinda, minypa gun-nerra nyibu-bawuna, wurra an-nerranga barrwa ana-boya, nipa wana, ngaypa ngu-delipa. Minypa ngaypa gala wana rraka ngu-yigipa ngu-mujama ngu-ni nula rrapa minypa jaga ng-gana nula ngu-workiya gun-nigipa nipa a-barrngumiya a-workiya rrepara a-jirra. Wurra ngaypa gala ngu-yinmiya; jarra ngaypa ngu-delipa. Wurra nipa jarra bama nyirr-gurraga barra ana-goyburrpa Mern An-mawunga, rrapa minypa gun-nerra gu-yalpa barra ana-gorrburrwa gu-bol gu-guyinda, gu-gurda ngacha. ");
INSERT INTO bvr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nipa ana-boya gipa nawanawa a-ni nipa barra arr-ngorrkornda a-boy, minypa gun-maywapa an-gugaliya mu-ngorrkorndanga a-workiya balaja, minypa mun-mola mun-guyinda ngardapa rrapa mun-nerra mun-guyinda ngardapa. Minypa ngayburrpa nguburr-yigipa nguburr-mola nguburr-guyinda, nipa arr-ga barra a-boy gu-yigipa gu-rrawa; wurra ngayburrpa nguburr-werranga nguburr-werra nguburr-guyinda, nipa arr-yerrnyja barra yi-gata gu-bol, gatiya barra nguburr-mungbiyapa barra nguburr-rro, rrapa gun-gata bol gala ana-nga gu-jupa.” ");
INSERT INTO bvr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Gun-gatiya lika Galali (Galilee) wenga Jesus ana-bona, a-bena nula Jon gata man․garba gu-werrwerrjinga gun-nelangga Jordan, barra nipa Jon ana-nyala bama a-gurraga Jesus. ");
INSERT INTO bvr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Wurra Jon jimarna a-jobujobungarna, nipa a-yinagata nula Jesus, “Ngaypa nginyipa barra bama nguna-gurraga, wurra an-nga nula ngaypa barra bama ngiy-gurraga?” ");
INSERT INTO bvr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Wurra Jesus a-yinanga, “Wuriya. Wurra ngarripa arr-yirda barra, ngardawa gipa Ngun-anya gu-borrwurra apula minypa gun-narda gun-molamola.” Nipa a-yinagata a-wena, lika Jon gu-yagurrmurra nula Jesus. ");
INSERT INTO bvr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Lika gun-gatiya Jon ana-nyala bama a-gurragaja Jesus, warrika Jesus ana-warrchinga gu-bugula wenga, lika waykin gu-lapkujamiyana, nipa lika Jon jinyu-nana minypa mukumul jina-bupiyana, jinyu-rakaja nula Jesus, wurra gun-burral Wangarr An-mawunga ana-jerrmiyana nula. ");
INSERT INTO bvr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Lika ana-manyjirda a-galiyana nula waykin wenga ana-wena, a-yinanga, “An-guna an-ngaypa Walkur ngaypa burr-guya jal ngu-nirra nula; ngaypa ngu-marrkapchinga nula.” ");
INSERT INTO bvr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Lika gu-gata wenga Mern An-mawunga ana-nyala a-ganyja a-bona Jesus gun-gata gu-werrapa, barra marrka walkwalk ana-nyala a-jurnajuchuwa a-ni gata, minypa nipa walkwalk jal a-ni jimarna barra Jesus werra a-negiya. ");
INSERT INTO bvr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Gun-gatiya minypa Jesus balaja m-bawuna ngorrngurra gun-jaranga minypa 40, lika nipa a-werrmiyana. ");
INSERT INTO bvr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Lika an-gata an-guwarga a-bena nula Jesus, lika a-yinanga nula, “Minyja nginyipa Wangarr biy-yika Walkur, gun-guna jandarra gun-guyinda yama ny-yengga nula barra nipa gu-ngukurdanyjiya rrapa rakaraka mu-ni ngguluwa?” ");
INSERT INTO bvr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Wurra Jesus a-yinanga, “Ngika. Jarra jurra mu-guyinda gu-yurra janguny, ‘An-gugaliya gala a-yinmiya m-balaja mu-guyinda wupa wanngu a-ni, wurra jarra gun-nga gun-bulawa wengga Wangarr a-weya a-workiya, gu-gurda ngacha wanngu gun-guni.’” ");
INSERT INTO bvr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Lika nipa walkwalk a-ganyja Jesus rrawa Jirúchalam, lika a-gurrmurra gata waykin gu-bala Nyanyapa arrku gun-nika gun-japurra rrawa, waykin gata a-ji. ");
INSERT INTO bvr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Lika a-yinagata nula, “Minyja nginyipa Wangarr biy-yika Walkur, marrka gortkurrcha. Ngardawa jurra mu-guyinda gu-yurra janguny, ‘Wangarr a-wengga barra burrwa aburr-yigipa waykin aburr-guyinda aburr-mujaruk birripa barra aburr-gunggaja nggula. Minypa murna aburr-jirra aburr-guyinda bubi-rrima barra aburr-ji, rraka nginyipa gala ny-yinmiya gu-jandarra biy-bu rrepara ny-jirra.’” A-yinagata walkwalk a-wena rrapa minypa Wangarr gun-nika wengga gu-ngukurdanyjinga, jimarna barra Jesus a-gortkurrcha rrapa a-juwa. ");
INSERT INTO bvr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Wurra nipa Jesus a-yinagata nula, “Ngika. Wurra janguny gun-ngardapiya gu-yinaga gu-yurra, ‘Nginyipa gala barra ny-jurnajuchuwa an-nginyipa an-ngardapiya nggula Wangarr.’” ");
INSERT INTO bvr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Gu-gatiya wenga nipa walkwalk a-ganyja Jesus waykin mu-mirk, lika nipa walkwalk ana-nyala a-gurdagurdarrana Jesus gu-nana gun-nardiya rrawa gun-jaranga gu-jirra gu-boya, minypa bunggawa yerrcha aburr-ngorrkorndiya aburr-nirra rrapa gun-nga gun-molamola gu-nirra burrwa ngardapa ngardapa. ");
INSERT INTO bvr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Lika walkwalk a-yinagata nula Jesus, “Barra ngaypa ngiy-wu rrawa gun-guniya, minyja nginyipa ny-menama n-da apula rrapa ny-marrngoypiya apula.” ");
INSERT INTO bvr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Wurra Jesus a-yinagata nula, “Nginyipa ny-jurda walkwalk, boy! Ngardawa jurra mu-guyinda gu-yurra Wangarr a-wena janguny, ‘Nginyipa barra ny-marrngoypiya nula an-nginyipa an-ngardapiya nggula Wangarr, rrapa jama ny-ji barra ny-yorkiya nuluwa nipa wupa an-ngardapa.’” ");
INSERT INTO bvr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Gu-gata wenga lika walkwalk a-bawuna Jesus, lika waykin aburr-guyinda aburr-mujaruk aburr-bona gurda, aburr-gunggajinga nula Jesus. ");
INSERT INTO bvr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Gu-gatiya wenga nuwurra waypa janguny gu-barrjekarra, Jesus a-galiyana minypa Jon abi-rrimarra, abu-bichinga, abu-barnjinga wupa. Lika nipa Jesus a-garlmuna, gu-bawuna gun-gata rrawa Jordan man․garba gu-werrwerrjingapa gu-yurra, lika a-jekarra wana gu-bapala rrawa Galali. ");
INSERT INTO bvr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Wurra nipa gala a-nirrarna gu-delipa gu-rrawa Nejarach (Nazareth), wurra barrwa a-gakiyana Jepyulan (Zebulun) aburr-bapurr rrapa Neptali (Naphtali) aburr-bapurr aburr-nirra, lika gatiya a-ni gu-rrarnba, rrawa gun-delipa gun-gata gun-nelangga Gapárniyam (Capernaum). ");
INSERT INTO bvr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Gatiya Jesus a-ni, minypa Aycháya (Isaiah) an-gata Wangarr an-nika an-mujaruk gipa mu-ngoyurra a-wena, a-yinagata, ");
INSERT INTO bvr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Gun-gata rrawa Jepyulan aburr-bapurr rrapa Neptali aburr-bapurr aburr-nirra, gun-gatiya man․garba gu-gapa gu-rrenyjiya rrawa rrapa gun-bachirra yi-gapa, gun-gata rrawa Galali (Galilee), minypa Jentayl (Gentile) yerrcha aburr-nirra — ");
INSERT INTO bvr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","gu-gurda burr-yika gu-rrawa minypa ana-munya aburr-ni, birripa gubi-nana bardayala gu-jayanayana gu-ji. Aburr-gatiya minypa gun-gujuwa gu-ji burrwa gu-workiyana, wurra gun-gujayanaya gugu gu-bena burrwa.” Gu-gurda ngacha janguny. ");
INSERT INTO bvr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Gu-gatiya wenga lika Jesus a-garlmuna, a-wena burrwa a-workiyana, a-yinagata, “Bubu-bawa gun-nerra, rrapa buburr-ngukurdanyjiya nula Wangarr. Ngardawa yi-gurrepa gu-jirra gu-boya rum gun-gata waykin wenga.” ");
INSERT INTO bvr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Gun-gatiya waypa Jesus a-bamuna gu-rrarnba gun-gata gu-rrawa Galali, nipa bijirri-nana gu-galiya yerrcha abirri-gulirrwirrka bitipa jichicha jama abirri-ji abirri-workiyana, an-ngardapa Jayman (Simon) an-gata birripa abu-ngurrjinga aburr-workiya Birta (Peter) an-nelangga, rrapa an-nigipa worlapa niya an-gata Andru (Andrew). Bitipa abirri-menga abirri-ni jichicha mulucha mu-guyinda. ");
INSERT INTO bvr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Lika nipa Jesus a-wena butula, “Guwa! Ngunabirri-jurrjurrma ngaypa, barra ajirri-gurdagurdarra ana-gotipa nyirri-yinmiya barra gu-galiya yerrcha nyirrbu-ma.” ");
INSERT INTO bvr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Warrika bitipa mbirri-bawuna mulucha, lika abirri-jurrjurrmurra Jesus. ");
INSERT INTO bvr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Aburr-bamuna balay ngika, lika nipa Jesus burr-nana aburr-werranga gu-galiya yerrcha, an-ngardapa an-gata Jeymch (James), rrapa an-nigipa worlapa niya Jon, rrapa an-bitipa nyanyapa buta an-gata Jebadi (Zebedee), minypa mu-michiyang aburr-ni, nawanawa aburr-ni mun-gata mulucha. Gatiya waypa Jesus bijirri-nana Jeymch rrapa Jon, lika nipa a-gonyjinga butula. ");
INSERT INTO bvr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Lika bitipa abirri-bawuna an-bitipa nyanyapa buta mu-michiyang a-ni, lika abirri-jurrjurrmurra Jesus. ");
INSERT INTO bvr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ganapiya, lika Jesus a-bona burrwa gun-gatiya rrawa gu-jirra gu-boya Galali. A-bamuna, gu-bala a-bena burrwa a-workiyana Ju (Jew) yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya. Minypa gatiya wupa rrapa mola yarlanga nipa janguny marn․gi burr-negarra a-workiyana, nipa janguny gun-molamola gu-ngurrjinga burrwa a-workiyana, minypa gun-nardiya gugu rum gun-gata waykin wenga. Rrapa nipa Jesus bin-dimarra gu-galiya yerrcha minypa gun-nerra gubi-rrimarra rrapa aburr-yorrpuna aburr-ni, lika birripa aburr-molamiyana. ");
INSERT INTO bvr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Rrapa janguny gu-barrjekarra nula, Jiriya (Syria) rrawa gu-jirra gu-boya aburr-galiyana nula, lika burrbu-ganyja gurda nula aburr-gurderda gu-galiya yerrcha. Minypa birripa gubi-rrimarra gu-derda gun-guyinda burr-guya gun-guwurkuricha burr-guta, rrapa minypa walkwalk abi-rrimarra, rrapa minypa murna gun-gurdericha gubu-menga aburr-workiyana, rrapa minypa aburr-nyarlkuch aburr-ni, gu-gata ngacha. Wurra Jesus bin-dimarra, aburr-molamiyana. ");
INSERT INTO bvr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Rrapa aburr-murra wurra gama gorlk abu-jurrjurrmurra aburr-workiyana, minypa Galali wenga, rrapa minypa gun-gata rrawa gu-jirra gu-boya arr-gulirrwirrka arr-murna gu-gatiya wenga, rrapa Jirúchalam wenga, rrapa Judíya wenga rrawa gu-jirra gu-boya, rrapa gu-gapa gu-rrenyjiya man․garba gu-werrwerrjinga gu-yurra rrawa Jordan gu-gatiya wenga burr-guta abu-jurrjurrmurra aburr-workiyana Jesus. ");
INSERT INTO bvr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Gun-gata waypa Jesus burr-nana wurra gama gorlk aburr-murra abu-jurrjurrmurra, lika a-garlmuna, gu-bulgapulga a-warrchinga, lika gatiya a-rakaja, rrapa aburr-yigipa jawina aburr-bona gurda, aburr-mulpiyana nula. ");
INSERT INTO bvr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Lika nipa marn․gi burr-negarra a-ni janguny, minypa gu-ngurrjinga a-ninya, a-yinanga burrwa: ");
INSERT INTO bvr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Aburr-gata minypa aburr-borrwiya aburr-werra, birripa jarra aburr-molamola aburr-nirra; ngardawa aburr-boy barra waykin. ");
INSERT INTO bvr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Rrapa aburr-gata minypa wargugu aburr-nirra, birripa jarra aburr-molamola aburr-nirra; ngardawa Ngun-anya burr-jalkaka barra aburr-ngurrnga. ");
INSERT INTO bvr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Rrapa aburr-gata minypa aburr-dor aburr-negiya aburr-workiya minypa marr aburr-balcharra nula Wangarr, birripa aburr-molamola aburr-nirra; ngardawa nipiya Ngun-anya burr-wu barra gun-nardiya rrawa birripa barra bunggawa aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Rrapa aburr-gata minypa burr-guya jal aburr-nirra jechinuwa aburr-ni barra, birripa aburr-molamola aburr-nirra; ngardawa Ngun-anya a-gunggaja barra burrwa, aburr-yirdiyapa barra jechinuwa aburr-nipa barra aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Rrapa aburr-gata minypa aburr-gunggajinga nula aburr-workiya an-gugaliya werra abi-nacha, birripa aburr-molamola aburr-nirra; ngardawa birripa aburr-yinagatiya, Ngun-anya a-gunggaja barra burrwa.");
INSERT INTO bvr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Rrapa aburr-gata minypa gala gun-nga gun-nerra gubi-rrima, wurra minypa bama aburr-jirra aburr-ngardapa, birripa aburr-molamola aburr-nirra; ngardawa abi-na barra Wangarr. ");
INSERT INTO bvr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Rrapa aburr-gata minypa magaya gubi-nenga aburr-workiya, birripa aburr-molamola aburr-nirra; ngardawa nipa Ngun-anya burr-ngurrja barra aburr-yigipa walkurpa yerrcha. ");
INSERT INTO bvr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Rrapa aburr-gata minypa ana-werranga ana-nyala mari gu-jarlapurda burrwa a-workiya minypa birripa aburr-guna jechinuwa aburr-nirra, birripa jarra aburr-molamola aburr-nirra; ngardawa birripa aburr-boy barra waykin. ");
INSERT INTO bvr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ana-goyburrpa nyiburr-gata minypa aburr-werranga gun-bachirra aburr-weya ana-gorrburrwa aburr-workiya, rrapa bima nyirrbu-ngurrjinga, rrapa mari gubu-garraja ana-gorrburrwa aburr-workiya ngardawa nyiburr-ngaypa; ana-goyburrpa jarra nyiburr-molamola nyiburr-nirra. ");
INSERT INTO bvr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Buburr-marrkapcha buburr-ni rrapa buburr-worlworlcha. Ngardawa nipa Wangarr gun-molamola gun-guyinda gu-rrimanga ana-gorrburrwa waykin, burraya nuwurra nyibu-ma barra. Minyja bubu-borrwa: aburr-gata mu-ngoyurra gubu-ngurrjinga aburr-workiyana Wangarr gun-nika janguny, birripa aburr-yinagatiya aburr-werranga aburr-nyala burrbu-buna aburr-workiyana. ");
INSERT INTO bvr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ana-goyburrpa minypa gun-maywapa ranginy jorlp gu-galiya yerrcha mbi-barnjinga, balaja mun-molamola mbi-nenga aburr-workiya. Wurra minyja jorlp mu-ngukurdanyjiya rrapa mun-nerra mu-ni, gala ana-nga a-yinmiya mu-jarlapa, barrwa mun-bachirra mu-ni. Wurra gipa gugu mun-nerra barra ngubi-yerrnyja rrapa borijipa ngubi-rrenyja. ");
INSERT INTO bvr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Rrapa gun-nerranga: Ana-goyburrpa minypa nyiburr-gujayanaya burrwa gu-guniya gu-rrawa. Minypa gun-maywapa ranginy gu-murnangana rrawa gun-gata gu-bulgapulga ana-munya gu-mirlkmirlkchinga gu-jirra rrapa gala gu-yinmiya gu-yilkakiya gu-yu. ");
INSERT INTO bvr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","“Minypa barrwa gun-maywapa ranginy lam (lamp) nguburr-birtarrmiya nguburr-workiya. Minypa gu-rrongga gu-jirra gala ngubi-yilkaka nguburr-workiya, minypa wupa ana-duram ana-guyinda o yina gaya, wurra jarra ngubu-wenyanga nguburr-workiya waykin, lika nguburr-nayarra nguburr-nirra. ");
INSERT INTO bvr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Minypa gun-burral ana-goyburrpa barra minypa nyiburr-jayanaya nyiburr-ni burrwa wurra gama gorlk, birripa barra nyirrbi-na ana-goyburrpa minypa gun-molamola jama nyiburr-jirra, rrapa gu-gata wenga minypa birripa aburr-marrkapcha barra nula Nyanyapa arrku waykin a-nirra. ");
INSERT INTO bvr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Gun-gata minypa ngaypa nguna-bona, gala barra nyibu-borrwa, jimarna ana-goyburrpa bama nyiburr-yinda ngaypa barra ngu-yerrnyja joborr gun-gata Wangarr a-wuna arrburrwa Mojich (Moses) rrapa mola gun-nigipa janguny Wangarr gun-nika aburr-yigipa aburr-mujaruk ngunyuna aburr-guyinda gubu-ngurrjinga aburr-workiyana. Wurra jarra ngaypa nguna-bona gun-burral ngu-nega barra gun-gata joborr rrapa janguny. ");
INSERT INTO bvr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Wurra bubu-borrwa: Gun-gata joborr gun-guyinda, marrban gun-nerranga gun-delipa, wurra gala gun-nga gun-gata gu-yinmiya gu-boy, nuwurra gun-nardiya rrawa gu-werrpiya barra waykin rrapa wupa. ");
INSERT INTO bvr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ganapiya, lika gun-gata joborr burr-guya gun-delipa gun-guyinda burr-guta, ana-nga an-gata gala gu-borrwa a-workiya, jarra aburr-werranga burr-jurnajuchuwuja birripa niya gala gubu-borrwa joborr, an-gata an-gugaliya nipa an-nelangga Nyanyapa arrku burr-guya an-delipa a-nega barra yi-gaba waykin nipa ana-murna. Wurra an-nerranga an-gata ana-nga gu-borrwuja a-bamburda rrapa marn․gi burr-nenga a-workiya aburr-werranga gun-gata joborr gun-guyinda, an-gata an-gugaliya nipa jarra an-nelangga wana a-ni barra yi-gaba waykin Ngun-anya ana-murna. ");
INSERT INTO bvr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Gu-gurda ngacha minypa ngu-weya ana-gorrburrwa: Minyja ana-goyburrpa gala gun-burral jechinuwa nyiburr-ni, rrapa ngika minypa Berachi (Pharisee) yerrcha rrapa joborr marn․gi aburr-gunega aburr-gata minypa aburr-yolkiya aburr-workiya, gun-gata minypa ana-goyburrpa gala nyiburr-yinmiya waykin nyiburr-boy rrapa Nyanyapa arrku ana-murna nyiburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ana-goyburrpa gipa nyiburr-galiyana nyiburr-workiyana joborr, ‘Gala barra an-gugaliya ny-bu, a-juwa; wurra minypa ana-nga ana-nyala an-gugaliya a-bu, nipa abu-ga barra aburr-bamba nula yi-gata an-gata jaga an-gugana joborr a-yinmiya barra a-wengga.’ ");
INSERT INTO bvr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Wurra ngaypa ngu-weya ana-gorrburrwa: An-gata ana-nga a-bachirramiya nula an-nigipa worlapa niya, nipa an-gata a-bachirramiyanapa abu-ga barra aburr-bamba nula yi-gata an-gata jaga an-gugana joborr a-yinmiya barra a-wengga. Rrapa an-gata ana-nga gun-bachirra a-wengga nula an-nigipa worlapa niya, nipa an-gata gun-bachirra a-wenapa abu-ga barra aburr-bamba ganychila (councillor) yerrcha aburr-nirra birripa aburr-yinmiya barra aburr-wengga. Rrapa an-gata ana-nga a-wengga nula an-nigipa worlapa niya, minypa a-yinda nula, ‘Nginyipa ny-yerra! Gu-bol n-do barra!,’ wurra nipa an-gata a-wenapa gu-bol a-rron. ");
INSERT INTO bvr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Ganapiya, lika ny-yinga ny-jata minypa ny-jarlmuna, jimarn barra ny-yu Wangarr mun-nga mun-nigipa minypa nginyipa ny-marrngoypiya nula nyi-nirra, wurra gatiya Wangarr gun-nika belabila gu-maya gu-jinyjarrapa minyja nginyipa ny-borrwa minypa an-nginyipa worlapa nggu an-nga nula mari gu-rrimanga nggula, ");
INSERT INTO bvr_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","burdak ny-bawa mun-gata nginyipa nyina-ganyja nula Wangarr, lika ny-boy, ny-yengga nula barra gun-nerra nyirri-nega ana-gotula; lika nuwurra jurdach nyina-jeka, lika Wangarr ny-yu mun-nigipa. ");
INSERT INTO bvr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ny-yinga ny-jata minyja ana-nga gu-rrima nggula mari, wurra nipa biy-ga a-bamba, jimarna barra biy-barnja joborr jaga an-gugana a-nirrapa, wurra gatiya nyirri-bamburda, nginyipa barra ny-yenggana minypa nginyipa ny-yinmiya barra jechinuwa nyi-nega gun-gata mari. Gala yapa biy-barnjin rrapa an-bachirra biy-jolartchin wupa. ");
INSERT INTO bvr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Wurra ngaypa ng-gunaga ngu-weya nggula ngu-nirra: Minyja birripa bubi-jolartcha, nginyipa gala ny-yinmiya ny-bengga, wurra nuwurra waypa rrupiya mun-murra ny-barripa lika ny-barnja. ");
INSERT INTO bvr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ana-goyburrpa gipa nyiburr-galiyana nyiburr-workiyana joborr, ‘Gala barra ana-werranga jin-nika ny-ma.’ ");
INSERT INTO bvr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Wurra ngaypa ngu-weya ana-gorrburrwa: An-gata ana-nga jinyu-na jin-gata gama jin-nigipa ngika rrapa jal a-ni barra marrambay abirriny-boy, gun-narda gun-maywapa jimarn jarra gipa abirriny-bona. ");
INSERT INTO bvr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Ganapiya, lika minyja nyi-munganaguwa mipila ny-jirra gun-nerra jama ny-jirra ny-yorkiya, wurra nyina-warrka, yerrnyja! Ngardawa gun-narda gun-mola nggula minypa mipila ny-jirra ny-nyardapa n-digirrga; gala yapa ny-jilirrwirrka mipila ny-jirra n-digirrga ny-bamba, barrwa minypa ny-burral ny-nyurrnga gu-bol n-do. ");
INSERT INTO bvr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Rrapa minyja nyi-munganaguwa murna ny-jirra gun-nerra jama ny-jirra ny-yorkiya, wurra gorndiya, yerrnyja! Ngardawa gun-narda gun-mola nggula minypa murna ny-jirra ny-nyardapa n-digirrga; gala yapa ny-jilirrwirrka murna ny-jirra n-digirrga ny-bamba, barrwa minypa ny-burral ny-nyurrnga gu-bol n-do. ");
INSERT INTO bvr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Birripa aburr-wena aburr-workiyana, janguny gu-barrjekarra, ‘An-gata ana-nga jiny-bawa jin-nigipa jin-gumarrbipa niya, nipa burdak jurra a-wukurrja barra achila minypa nipa jiny-bawa barra, lika jiny-yu barra mun-gata jurra mun-nigipa.’ ");
INSERT INTO bvr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Wurra jarra ngaypa ngu-weya ana-gorrburrwa: Minyja an-gugaliya jiny-bawa jin-nigipa jin-gumarrbipa niya gala jinyu-dawurrja rrapa ana-werranga jiny-ma, gun-narda minypa nipa an-gumarrbipa ngacha jin-nerra jinyu-nenga gun-maywapa minypa jimarn jarra jiny-yinagata jiny-yorkiya jinyu-dawurrjinga. Wurpa niya an-nerranga ana-nga barrwa jiny-ma jin-gata gama, gun-narda minypa birrinyjipa gun-nerra jama abirriny-jirra. ");
INSERT INTO bvr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Rrapa gun-nerranga ana-goyburrpa nyiburr-galiyana minypa birripa wola aburr-wena burrwa aburr-workiyana, ‘Gala barra borijipa Wangarr an-nelangga ny-ma. Wurra gun-nga nginyipa gochila n-dana ana-nga minypa Wangarr an-nelangga ny-menga, wurra nginyipa barra ny-yirda jama ny-ji.’ ");
INSERT INTO bvr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Wurra jarra ngaypa ngu-weya ana-gorrburrwa: Gala barra Wangarr an-nelangga ny-ma wolawola Wangarr rrapa an-gugaliya gochila n-dacha ny-yorkiya gun-nga. Rrapa mola: Gala barra ny-yirda rrawa gun-nelangga ny-ma, wuriya gun-gata waykin rrawa, waygaji gun-guna rrawa, waygaji rrawa Jirúchalam. Ngika. Ngardawa rrawa gun-japurra. Minypa Jirúchalam, nipa gun-gata Bunggawa Wana An-babalapa gun-nika rrawa; rrapa gun-nardiya rrawa, nipa Wangarr gu-jarlapuna; rrapa gun-gaba waykin rrawa, nipa a-nirrapa a-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Rrapa nginyipa bama ny-jirra burr-guta gala barra ny-yelangga ny-maya wolawola Wangarr rrapa an-gugaliya gochila n-dacha ny-yorkiya gun-nga. Ngardawa nginyipa gala ny-yinmiya mula ny-jirra ny-nyukurdanyjiya, mu-ngunyja, waygaji mu-ngarlcha. ");
INSERT INTO bvr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Wurra ny-yinda barra ny-yorkiya, ‘Ngaw,’ rrapa ‘Ngika,’ gurda wupa. Wurra jarra minyja an-nelangga ny-mangga ny-yorkiya wolawola Wangarr rrapa an-gugaliya gochila n-dacha ny-yorkiya gun-nga, gun-narda ngardawa an-gata jarra gun-nerra an-gurrimapa a-wena nggula. ");
INSERT INTO bvr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ana-goyburrpa gipa nyiburr-galiyana nyiburr-workiyana joborr, ‘Ana-nga an-gata werra a-nega an-gugaliya mipila a-jirra rrapa gapula a-nega, nipa an-gata rrapa aburr-yirdiya barra nula gapula abi-nega barra. Rrapa barrwa ana-nga werra a-nega an-gugaliya rrapa minypa gu-rruma nula rrirra, nipa rrapa a-yirdiya gubu-rruma barra nula rrirra.’ ");
INSERT INTO bvr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Wurra jarra ngaypa ngu-weya ana-gorrburrwa gun-guna: Ana-nga an-gata werra biy-nega, gala barra ny-borrwa nipa a-yinmiyana nggula. Ana-nga minypa nyi-munganaguwa japurra ny-jirra biy-bu, nginyipa ny-mola nyi-ni barra nula wuriya nipa barrwa biy-bun ny-yeyka japurra ny-jirra. ");
INSERT INTO bvr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Rrapa ana-nga minypa biy-ga a-bamba nula yi-gata an-gata jaga an-gugana joborr barra a-wengga nggula minypa nginyipa barra ny-yu an-gugaliya mun-nginyipa mun-gumirrka, wurra wuriya gun-gata, wurra nginyipa ny-yu barra mun-nginyipa molma mun-gunegiya mirikal burr-guta. ");
INSERT INTO bvr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Rrapa ana-nga biy-ma nginyipa barra ny-bamiya nula gorlk marr balay, wurra wuriya, wurra mola gun-baykarda ny-bamiya barra nula jarra. ");
INSERT INTO bvr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Rrapa minypa ana-nga a-ngiwija nggula gun-nga, wu nipa. Rrapa ana-nga jal a-nirra gun-nga nipa yarta gu-ma, wu nipa; gala barra n-dalaja. ");
INSERT INTO bvr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ana-goyburrpa gipa nyiburr-galiyana nyiburr-workiyana joborr, ‘Aburr-nginyipa jawina yerrcha, nginyipa ny-mola nyi-ni barra burrwa; rrapa aburr-gata aburr-bachirra ana-gorrburrwa, nginyipa ngoyurra ny-yerryerrmiya barra burrwa.’ ");
INSERT INTO bvr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Wurra jarra ngaypa ngu-weya ana-gorrburrwa: Aburr-gata aburr-bachirra nggula, nginyipa ny-mola nyi-ni barra burrwa, rrapa Nyanyapa arrku ny-yenggana barra burrwa aburr-gata minypa bampa bubi-nenga bubu-burnda aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Gu-gurda ngacha minypa ana-goyburrpa barra walkurpa nyiburr-ni nula Nyanyapa arrku waykin a-nirra. Ngardawa nipa jama a-jirra a-workiya nyanma marnnga guna-gepiya burrwa guna-workiya aburr-molamola aburr-guyinda rrapa aburr-gata aburr-werra gu-galiya yerrcha birripa burr-guta. Rrapa yorr gu-guyinda nipa burr-jalkakaja a-workiya aburr-jechinuwa aburr-guyinda rrapa aburr-gata minypa werra aburr-negiya aburr-workiya birripa burr-guta. ");
INSERT INTO bvr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Wurra ana-goyburrpa nyiburr-yinmiya nyibu-borrwuja, ya? Jimarna Wangarr biy-wu barra nginyipa minypa nginyipa jal nyi-nirra burrwa aburr-nginyipa aburr-gata jal aburr-nirra nggula, ya? Wurra gun-narda ngika, a-la! Wurra aburr-gata minypa nyirrbu-gaypurda aburr-workiya ana-goyburrpa, birripa burr-guta aburr-yinagatiya rrapa jal aburr-nirra burrwa gu-gapa gu-guta. ");
INSERT INTO bvr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Minypa gun-gata ana-goyburrpa nyiburr-mola nyiburr-nirra burrwa nyiburr-workiya aburr-borrmunga ana-gorrburrwa rrapa nyiburr-weya burrwa nyiburr-workiya gun-molamola, gun-narda minypa ana-goyburrpa wupa ngardapa ngika, wurra jarra aburr-jaranga aburr-yinagatiya aburr-workiya, aburr-gata burr-guta minypa gala marn․gi nula Wangarr. ");
INSERT INTO bvr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Wurra jarra ana-goyburrpa nyiburr-molamola buburr-ni warrpam, minypa an-goyburrpa Nyanyapa ana-gorrburra waykin a-nirra nipa warrpam an-molamola. ");
INSERT INTO bvr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Buburr-jarlapiya! Minypa gun-gata nginyipa jama ny-jirra ny-yorkiya Ngun-anya gun-nika, gala barra ny-borrwa jimarna gu-galiya yerrcha barra bubi-na rrapa gubu-borrwa, jimarna bama aburr-yindin nginyipa ny-molamola. Ngika. Wurra minyja ny-yirda ny-borrwa nginyipa jama ny-ji, gun-narda minypa Nyanyapa arrku waykin a-nirra gala a-yinmiya biy-wu gun-nginyipa, jimarna nginyipa jama ny-jirrarna nuluwa nipa. ");
INSERT INTO bvr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ganapiya, wurra ana-nga an-nyagara nginyipa ny-yucha ny-yorkiya, gala barra gu-galiya yerrcha ny-jurdagurdarriya burrwa nginyipa ny-yinmiya. Wurra aburr-gata minypa waykin aburr-molamola rrapa wupa aburr-werra, birripa jarra aburr-gurdagurdarriya burrwa aburr-workiya gu-gapa gu-guta. Minypa wupa gu-bala Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya, rrapa mola yarlanga, birripa burrbu-wucha aburr-workiya aburr-gata aburr-nyagara; wurpa lika aburr-yinagata aburr-workiya burrbu-wucha minypa barra aburr-werranga aburr-gata burrbu-ngurrja birripa, jimarn jarrapa bama aburr-yindin aburr-molamola. Wurra ganapiya, gun-narda wupa ngardapa guna-jeka barra burrwa, wurra nipa Nyanyapa arrku gala a-yinmiya barrwa gun-nga guna-gurdanyja burrwa. ");
INSERT INTO bvr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Wurra nginyipa ny-yinga ny-jata wolawola an-gugaliya ny-junggajinga nula ny-yorkiya, gala barra ana-nga ny-jurdagurdarriya nula, an-nginyipa an-gata gu-day ana-gotula burr-guta. ");
INSERT INTO bvr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Wurra jarra yongun nyi-nega barra, rrapa Nyanyapa arrku an-gata nipa wupa marn․gi nginyipa ny-yinmiya ny-yorkiya, nipa biy-wu barra gun-nginyipa minypa nginyipa jama ny-ji. ");
INSERT INTO bvr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Wurra minypa ana-goyburrpa nyibu-wengganacha nyiburr-workiya, gala barra nyiburr-yirda minypa aburr-gata waykin aburr-molamola rrapa wupa aburr-werra. Birripa minypa abu-wengganacha aburr-jirra aburr-workiya wupa gu-bala Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya, rrapa mola gomurnda gu-yurra jarlakarr. Wurra aburr-yinagata aburr-workiya abu-wengganacha, minypa birripa wupa aburr-murna aburr-molamola aburr-negiya; jal aburr-nirra gu-galiya yerrcha aburr-nyala barra burrbi-na rrapa burrbu-ngurrja, jimarn jarrapa bama aburr-yindin aburr-molamola. Wurra ganapiya, gun-narda wupa ngardapa guna-jeka barra burrwa birripa aburr-guna, wurra nipa Nyanyapa arrku gala a-yinmiya barrwa gun-nga guna-gurdanyja burrwa. ");
INSERT INTO bvr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Wurra nginyipa ny-yinga ny-jata wolawola ny-yengganacha ny-yorkiya, boy wupa gu-ngarnama rrapa jakaba ngana gu-jirra, barra ny-yenggana Nyanyapa arrku an-gata gala ana-nga a-na a-workiya. Rrapa Nyanyapa arrku an-gatiya nipa wupa marn․gi nginyipa ny-yinmiya ny-yorkiya, nipa burraya biy-wu barra gun-nginyipa minypa yongun ny-yengganana rrapa gala ny-borrwujarna jimarna gu-galiya yerrcha bubi-nacharna rrapa bubu-ngurrjingarna ny-molamola. ");
INSERT INTO bvr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Wurra minypa nginyipa wolawola ny-yengganacha ny-yorkiya, gala barra borijipa ny-yengga gun-nga gun-jaranga minypa aburr-gata gala marn․gi nula Wangarr. Birripa gubu-borrwuja jimarn jarra Wangarr a-galiyarra burrwa minypa gun-baykarda aburr-weya aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Gun-gata gala barra ny-yirda. Wurra nginyipa ny-yengganacha ny-yorkiya, nipa Nyanyapa arrku gipa mu-ngoyurra marn․gi a-ni gun-nga nginyipa jal nyi-nirra. ");
INSERT INTO bvr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Wurra ny-yinda barra ny-yenggana ny-yorkiya minypa gun-guna: ‘Anya, nginyipa ny-jarda waykin nyi-nirra arrburrwa, nginyipa ny-yelangga ngayburrpa barra bubu-ngurrja ny-molamola. ");
INSERT INTO bvr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Guwa, gun-nginyipa rum barra gu-jipa gu-workiya gun-guna rrawa. Gun-guniya gu-jel ngayburrpa barra nyiburr-yirda nyiburr-workiya minypa nginyipa jal nyi-nirra, gun-maywapa minypa aburr-yinagatiya aburr-workiya yi-garda waykin. ");
INSERT INTO bvr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gun-guniya nyirr-wu balaja mun-ngiya ngayburrpa jal nyiburr-nirra. ");
INSERT INTO bvr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Baywarra nega arrburrwa gun-gata minypa ngayburrpa werra nyiburr-negiyana nggula, gun-maywapa minypa ngayburrpa baywarra nyibi-nenga burrwa nyiburr-workiya aburr-werranga aburr-gata minypa werra nyirrbi-negarra ngayburrpa. ");
INSERT INTO bvr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Gala barra nyirr-ga yi-gata gun-derta gun-gorla nyibu-barripa; gala yapa nyiburr-lijiwarriyan. Wurra nyirr-jarlapa nyirr-ga an-gata gun-nerra an-gurrimapa jama a-jirra a-workiya.’ ");
INSERT INTO bvr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Nyiburr-yirda barra nyibu-wenggana nyiburr-workiya Nyanyapa arrku. Ngardawa nginyipa minyja baywarra nyi-nega burrwa aburr-werranga minypa gun-gata birripa werra bubi-negarra nginyipa, gun-narda minypa nipa Nyanyapa arrku waykin a-nirra baywarra gu-nega barra nggula gun-gata minypa nginyipa werra nyi-negiyana nula. ");
INSERT INTO bvr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Wurra minyja nginyipa gala ny-yinmiya baywarra nyi-nega burrwa aburr-werranga, gun-narda minypa Nyanyapa arrku gala a-yinmiya baywarra gu-nega nggula nginyipa. ");
INSERT INTO bvr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ny-yinga ny-jata minyja balaja ny-bawa Wangarr barra ny-yenggana, wurra gala barra ny-yirda minypa aburr-gata waykin aburr-molamola rrapa wupa aburr-werra. Birripa wolawola balaja mbi-bawuja aburr-workiya, birripa aburr-gurdagurdarrajiya aburr-workiya burrwa gu-galiya yerrcha minypa Wangarr abu-wengganacha. Minypa birripa yarlanga aburr-burral werra aburr-negiya aburr-workiya; gala aburr-gornagiya, rrapa gala aburr-buya mula aburr-jirra. Aburr-yinagata aburr-workiya minypa barra aburr-werranga burrbi-na rrapa burrbu-ngurrja, jimarn jarrapa bama aburr-yindin aburr-molamola minypa Wangarr burr-guya abu-wengganacha aburr-nirra. Wurra ganapiya, gun-narda wupa ngardapa guna-jeka barra burrwa, wurra nipa Nyanyapa arrku gala a-yinmiya barrwa gun-nga guna-gurdanyja burrwa. ");
INSERT INTO bvr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Wurra jarra ny-yinga ny-jata ny-bawuja ny-yorkiya balaja rrapa minypa ny-yengganacha, wurra nginyipa barra ny-jurragiya rrapa ny-buya mula ny-jirra, ");
INSERT INTO bvr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","barra gu-galiya yerrcha gala aburr-yinmiya bubi-na balaja ny-bawuna. Jarra Nyanyapa arrku an-gata gala ana-nga a-yinmiya a-na, nipa wupa biy-na barra, minypa nipa wupa marn․gi nginyipa ny-yinmiya ny-yorkiya, rrapa nipa biy-wu barra gun-nginyipa minypa nginyipa wargugu nyi-ni rrapa ny-yengganana yongun. ");
INSERT INTO bvr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Gala barra ny-jordaja ny-bamba, gun-guna rrawa nyi-nirra; gala yapa burnpa m-barda, waygaji burpur m-bun, o mun-ngumurda mbi-man gerra. ");
INSERT INTO bvr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Wurra jarra borrwa nginyipa ny-yinmiya barra gorlk ny-ma gun-gaba waykin jin-gata burnpa gala jiny-yinmiya m-bay, rrapa mun-gata burpur gala mu-yinmiya m-bu, rrapa an-ngumurda an-guyinda gala a-yinmiya bala gu-rruma rrapa mun-ngumurda mu-ma. ");
INSERT INTO bvr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ngardawa nginyipa minyja ny-borrwuja ny-yorkiya gu-gurdiya gu-yika gu-rrawa, gun-narda minypa gun-guniya nggula rrawa; wurra minyja ny-borrwuja gorlk gun-gaba waykin, rrawa gun-gatiya nggula. ");
INSERT INTO bvr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ngarripa mipila arr-jirra minypa gun-maywapa ranginy lam (lamp) gu-rrongga gu-jirra barra minypa wuparnana arr-burral arr-naya arr-ni. Minypa gun-burral nginyipa minyja ny-borrwuja ny-yorkiya gun-molamola gun-guyinda, gun-narda minypa gu-gujayanaya nyi-nirra rrapa wuparnana ny-nyurrnga nyi-nayarra nyi-nirra. ");
INSERT INTO bvr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Wurra minyja mipila ny-jirra nyi-nacha ny-yorkiya gun-nerra gun-guyinda, gun-narda minypa nginyipa an-munya ny-maya ny-jirra. Minypa gun-nginyipa nginyipa ny-borrwuja ny-yorkiya, minyja gun-gata gun-nerra, gun-narda minypa nginyipa nyi-nirra burr-guya ny-yerra an-munya nyi-nirra ny-yorkiya. ");
INSERT INTO bvr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Gala ana-nga a-yinmiya jama a-ji butula abirri-jirrapa bunggawa ngardapa ngardapa, minypa burr-bama burr-rrepara. Gala a-yinmiya. Jarra an-ngardapa bunggawa an-gata nipa an-mujama ngoyurra a-yerryerrmiya nula, rrapa an-nerranga nipa jal a-ni nula. Minypa an-molamola a-ni nula an-ngardapa, rrapa an-nerranga nipa a-dalaja a-ni. Gu-gurda ngacha minypa nginyipa gala ny-yinmiya gu-jirrapa jama ny-ji, minypa Wangarr gun-nika rrapa rrupiya nula. ");
INSERT INTO bvr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Gu-gurda nula ngaypa ngu-weya ana-gorrburrwa: Minyja ny-yinga ny-jata, gala barra ny-yorija ngguluwa nginyipa, minypa balaja nula mun-nga ny-bay rrapa bugula nula gun-nga ny-bay. Gala barra ny-yorija ngguluwa nginyipa ny-burral, minypa mirikal nula mun-nga ny-barrnguma. Wurra ngarripa arr-nirra, arr-gata an-nga nula? Wurra jimarna bama ny-yinaga balaja ay-banga arr-workiya mun-gata nula, ya? Rrapa ngarripa arr-burral, arr-gata an-nga nula? Wurra jimarna bama ny-yinaga mirikal ngarripa arr-barrngumiya arr-workiya mun-gata nula, ya? Wurra ngika, a-la! ");
INSERT INTO bvr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Wurra bubu-borrwa burdacha jin-guyinda waykin jiny-boya jiny-yorkiya: Minypa Nyanyapa arrku jaga a-ganaja achila a-workiya, wuriya nipa gala jinyu-lamaja jiny-yorkiya rrapa gala jiny-yinmiya mu-ma mun-murra balaja rrapa m-barnja wupa gu-bala. Wurra nipa Nyanyapa arrku waykin a-nirra jiny-yucha a-workiya balaja nipa m-banga. Wurra nginyipa yama ny-borrwa gun-gata minypa gu-galiya yerrcha nipa Wangarr jal a-nirra burrwa burr-guya, burdacha jarra marr a-yinaga jal a-nirra achila. Rrapa gun-gata minypa nipa jaga a-ganaja achila a-workiya burdacha, gun-narda minypa nipa jarra burr-guya jaga a-ganaja burrwa gu-galiya yerrcha rrapa nginyipa gala ny-yinmiya ny-yorija nggula minypa balaja rrapa gorlk rrapa gun-nga. ");
INSERT INTO bvr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wurra nginyipa jimarna bama ny-yinaga gun-baykarda nyi-ni barra minypa nginyipa ny-yorijinga ngguluwa ny-yorkiya, ya? Wurra gala ny-yinmiya. ");
INSERT INTO bvr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Rrapa an-nga nula ny-yorijinga mirikal? Wurra borrwa gorrngunya mun-guyinda mun-delipa mun-gata minypa mun-jawanyja m-burnda mu-workiya. Nipa mun-gata gala jama mu-ji mu-workiya, rrapa gala mirikal mu-jarlapa nuluwa, wurra Nyanyapa arrku nipa wupa mu-jarlapurda a-workiya mun-gata mun-molamola. ");
INSERT INTO bvr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Rrapa ngaypa ngu-weya ana-gorrburrwa: Mun-gata minypa mun-jawanyja m-burnda niya mu-workiya, ngayburrpa ngubi-nacha nguburr-workiya mun-molamola; jarra an-gugaliya a-barrngumiya a-workiya mirikal, mun-gata marr mu-yinaga mun-molamola mu-nirra nula. Minyjiya. An-gata Jolaman (Solomon) mu-ngoyurra bunggawa a-ni, nipa wuriya gorlk wana nula, wurra mun-nigipa burr-guta mirikal marr mu-yinanga mun-molamola; mun-gata mun-jawanyja m-burnda mu-workiya gorrngunya mun-guyinda, nipa jarra burr-guya mun-molamola. ");
INSERT INTO bvr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Wurpa lika gorrngunya mu-jirra mu-workiya rrapa barrwa gugu mu-werrpiya mu-workiya, mun-jangarrk aburr-birtarrmiya aburr-workiya, mu-rrongga. Gu-gurda ngacha. Wurra gun-gata minypa Wangarr mun-molamola mu-jarlapurda a-workiya gorrngunya mun-gata barrwa mu-werrpiya mu-workiya, gun-narda minypa nipa gala a-yinmiya a-bamapa nggula ny-jurda nyi-gugaliya mirikal, wurra jarra nipa biy-wupa barra a-workiya barra ny-barrnguma. Wurra yama marr ny-balcha nula? ");
INSERT INTO bvr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Gala barra gun-jaranga ny-borrwa. Gala barra ny-yengga minypa ‘Mun-nga ngubu-bay, a-lay? Waygaji gala mu-yu, ya?’ rrapa ‘Gun-nga ngubu-bay bugula, a-lay? Waygaji gala gu-ji, ya?’ rrapa ‘Mirikal mun-nga nguburr-barrnguma, a-lay? Waygaji gala mu-yu, ya?’ ");
INSERT INTO bvr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Wurra gu-gatiya ngacha birripa gubu-borrwuja aburr-workiya aburr-gata minypa gala marn․gi nula Wangarr. Wurra nipiya jarra Nyanyapa arrku waykin a-nirra marn․gi gu-gata ngacha gun-nga nginyipa jal nyi-nirra ny-yorkiya. ");
INSERT INTO bvr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Wurra nginyipa mu-ngoyurra ny-borrwa barra ny-yorkiya minypa nginyipa ny-yinmiya barra jama ny-ji Nyanyapa arrku gun-nika jal gun-guni rrapa ny-yinmiya barra jechinuwa nyi-ni nula, lika nipa biy-wu barra gu-gata ngacha minypa gun-nga nginyipa jal nyi-nirra. ");
INSERT INTO bvr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ganapiya, lika gala barra ny-yorija ana-barlpa nula. Nuwurra ana-barlpa barra nginyipa nyi-na rrapa ny-borrwa barra. Wurra gun-nga gun-derta geka ny-barripuna, gun-narda wupa ganapiya nggula barra nginyipa geka ny-borrwa. ");
INSERT INTO bvr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Gala barra gun-nerra ny-borrwa burrwa aburr-werranga, rrapa nipa Wangarr gala barra gun-nerra gu-borrwa nggula nginyipa. ");
INSERT INTO bvr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ngardawa aburr-werranga nginyipa ny-yinmiya ny-borrwuja burrwa ny-yorkiya rrapa burr-yopurda burr-guta, gu-gata ngacha minypa Wangarr biy-ngurrja barra nginyipa. Minypa nginyipa ny-yinmiya burrwa ny-yorkiya aburr-werranga, gu-gata ngacha minypa guna-jeka barra nggula. ");
INSERT INTO bvr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Wurra an-nga nula nginyipa nyi-nacha gun-delipa baluk gu-barrngumurra nula an-nginyipa worlapa nggu ana-mipila, wurra minypa gala ny-borrwiya gun-jong wana gun-bapala gu-barrngumurra ngguluwa ny-mipila? ");
INSERT INTO bvr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Wurra nginyipa ny-jata gun-jong wana gun-bapala gu-barrngumurra ngguluwa ny-mipila, an-nga nula an-nginyipa worlapa nggu nginyipa minypa ny-yeya nula, ‘Dericha, a-lay, ngaypa barra ngu-yerrnyja nggula baluk ny-mipila gu-barrngumurra.’ ");
INSERT INTO bvr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wurra gun-gata jarra minypa nginyipa waykin ny-molamola rrapa wupa ny-yerra. Wurra burdak gun-jong ny-mipila gu-barrngumurra ma, yerrnyja yarlanga, barra nginyipa ny-jana rrapa gun-mola gu-ni nggula nginyipa barra ny-yerrnyja nula an-nginyipa worlapa nggu baluk ana-mipila gu-barrngumurra. ");
INSERT INTO bvr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Rrapa gun-nerranga: Gun-nga gun-gata gun-japurra gun-guyinda, gala barra ny-yu an-gata gulukula; gala yapa a-ngukurdanyjiyan rrapa biy-barda. Rrapa gu-lawu an-guyinda minypa manimani abi-jarlapurda aburr-workiya, gala barra ny-yu bigibigi jin-guyinda; gala yapa borijipa a-rrenyjin. Ngardawa gulukula rrapa bigibigi gala marn․gi nula gun-gata gun-japurra gun-guyinda rrapa an-gata gu-lawu. ");
INSERT INTO bvr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Wenggana, rrapa nginyipa ny-ma barra. Wechawecha, rrapa nginyipa ny-barripa barra. Duldulja ngana gu-jirra, rrapa nipa gu-lapkujamiya barra nggula. ");
INSERT INTO bvr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ngardawa ana-nga minypa a-wengganacha a-workiya, an-gatiya gu-mangga a-workiya; rrapa ana-nga a-wechawecharra a-workiya, an-gatiya gu-barripurda a-workiya; rrapa ana-nga a-dulduljinga a-jirra ngana gu-jirra, an-gatiya gu-lapkujamiya barra nula. ");
INSERT INTO bvr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ana-goyburrpa wurra ny-yinga ny-jata gu-ngarda yerrcha burr-bokamurra, minyja an-nginyipa walkur biy-wenggana rakaraka, nginyipa gala ny-yinmiya ny-nyukurdanyjiya rrapa jandarra ny-yu. ");
INSERT INTO bvr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Rrapa minyja nipa biy-wenggana jichicha, nginyipa gala ny-yinmiya ny-yu nguymbula. ");
INSERT INTO bvr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Minypa ana-goyburrpa wuriya nyiburr-werra, wurra ana-goyburrpa marn․gi an-gungarda nyibu-wu gun-molamola gun-guyinda. Wurra Nyanyapa arrku waykin a-nirra, nipa warrpam an-molamola, rrapa aburr-gata aburr-yinmiyapa abu-wengganacha aburr-workiya, nipa burr-wu barra gun-molamola gun-guyinda. ");
INSERT INTO bvr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Nginyipa ny-yinda barra burrwa ny-yorkiya aburr-werranga minypa nginyipa jal nyi-nirra birripa barra aburr-yirda nggula nginyipa. Gu-gurda ngacha banda gu-jirra joborr gun-guyinda gun-gata Wangarr a-wuna arrburrwa Mojich, rrapa mola gun-gata Wangarr gun-nika aburr-yigipa aburr-mujaruk ngunyuna aburr-guyinda gubu-ngurrjinga aburr-workiyana. ");
INSERT INTO bvr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Boy, barrnguma yi-gata gu-rruwurdola ngana gu-jirra. Wurra minyja nginyipa ny-ma gun-gata wana jarlakarr nginyipa barra ny-barrnguma yi-gata wana ngana gu-jirra, gun-narda minypa nginyipa ny-bengga barra gun-gata gu-bol. Aburr-jaranga gu-galiya yerrcha gun-gata gubu-mangga aburr-workiya jarlakarr. ");
INSERT INTO bvr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Wurra minyja nginyipa ny-ma gun-delipa jarlakarr nginyipa barra ny-barrnguma yi-gata gu-rruwurdola ngana gu-jirra, gu-gurda ngacha minypa nginyipa ny-barripa barra wanngu gun-guni; wurpa lika gala aburr-jaranga gubu-barripa gun-gata. ");
INSERT INTO bvr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Buburr-jarlapiya burrwa aburr-gata aburr-guyolkiya aburr-guyinda aburr-mujaruk. Birripa aburr-beya ana-gorrburrwa aburr-workiya minypa waykin aburr-molamola, minypa jin-maywapa jin-gumurna jip; wurra wupa birripa aburr-bachirra minypa an-maywapa an-mugat gu-ngarl nula a-wechawecharra. ");
INSERT INTO bvr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Wurra ana-goyburrpa barra nyirrbu-malawa aburr-gata aburr-guyolkiya aburr-guyinda minypa birripa aburr-yinmiya aburr-workiya jama aburr-jirra. Minypa rrapa gun-maywapa ranginy ngayburrpa gala nguburr-yinmiya ngubu-ma gurnal ji-bornangguna ji-guyinda, rrapa gala nguburr-yinmiya ngubu-ma mun-gubocha gu-lokula ana-guyinda, wurra ngika. ");
INSERT INTO bvr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ngardawa gun-molamola gun-jong mun-gata mun-molamola balaja mu-rrimanga mu-workiya, wurra gun-jong gun-gata gu-gorlapurda rrapa gun-nerra gu-rrimanga, gu-gata ngacha gun-jong gala mu-rrima mun-molamola balaja; wurra mun-nerra wupa jarra. ");
INSERT INTO bvr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Gun-molamola gun-jong gala mun-nerra balaja mu-rrima mu-workiya, rrapa gun-jong gun-nerra gu-rrimanga gala mun-molamola mu-rrima. ");
INSERT INTO bvr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Rrapa gun-jong gun-gata gala mu-rrima mun-molamola balaja, burraya gubu-gornda barra rrapa gubu-wurrgaka barra gu-bol. ");
INSERT INTO bvr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ganapiya, lika ana-goyburrpa marn․gi nyiburr-ni barra burrwa aburr-gata aburr-guyolkiya aburr-guyinda aburr-mujaruk minypa aburr-guyinmiya ngacha, minypa birripa aburr-yinmiya aburr-workiya jama aburr-jirra. ");
INSERT INTO bvr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Aburr-jaranga gu-galiya yerrcha aburr-weya apula aburr-workiya, aburr-yinaga apula, ‘Bunggawa, nginyipa ny-jurda Bunggawa!’ Aburr-yinagata aburr-workiya, wurra gun-narda wupa ngika minypa waykin Ngun-anya ana-murna aburr-ni barra. Jarra aburr-nga aburr-gata minypa jama aburr-jirra aburr-workiya Ngun-anya jal a-nirra, birripa aburr-gatiya wupa Ngun-anya ana-murna aburr-ni barra. ");
INSERT INTO bvr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","“Nuwurra waypa jurdach guna-bamba, aburr-jaranga aburr-wengga barra apula, ‘Bunggawa, nginyipa ny-jarda Bunggawa, ngaw minyja ny-yengga, ngardawa nginyipa ny-yelangga ngayburrpa bubu-menga nyiburr-workiyana minypa nyiburr-wena nyiburr-workiyana Wangarr gun-nika; rrapa mola nginyipa ny-yelangga bubu-menga nyiburr-workiyana, walkwalk an-guyinda nyibi-yerrnyjinga burrwa nyiburr-workiyana; rrapa mola burr-ganyjarr jama nyiburr-ji nyiburr-workiyana nginyipa ny-yelangga.’ ");
INSERT INTO bvr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Aburr-yirda barra aburr-wengga apula, wurra ngaypa barra ngu-yinda ngu-wengga burrwa, ‘Ngaypa gala marn․gi ana-gorrburrwa. Buburr-boypa! Ana-goyburrpa nyiburr-gurda nyiburr-werra!’ ");
INSERT INTO bvr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ganapiya. Ana-nga an-gata a-galiyarra janguny ngaypa ngu-weya ngu-nirra, minyja nipa gu-borrwa a-bamba, an-gata an-gugaliya nipa minypa gun-maywapa ranginy minypa an-gata an-nerranga an-gugaliya jechinuwa gu-borrwurra, lika a-garlmuna, gu-jarlapuna nula gun-nigipa bala waykin gu-gurrema. ");
INSERT INTO bvr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Lika yorr gu-bungguna gu-ji, rrapa bugula wana gu-ni, guna-werrwerrjinga guna-bamuna, rrapa barlmarrk wana gu-bena rrapa gu-buna gun-gata bala, wurra gala gu-rrumungarna; ngardawa an-gugaliya gu-jarlapuna gu-gurrema gu-jinyja gun-derta gun-gorla. ");
INSERT INTO bvr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Wurra jarra ana-nga an-gata nipa a-galiyarra janguny ngaypa ngu-weya ngu-nirra, wurra minypa gala gu-borrwa a-bamba, an-gata an-gugaliya nipa minypa gun-maywapa ranginy minypa barrwa an-nerranga an-gugaliya gala jechinuwa gu-borrwujarna, wurra gun-nigipa bala nipa gu-jarlapuna nula ana-jaranga. ");
INSERT INTO bvr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Lika yorr gu-bungguna gu-ji, lika bugula wana gu-ni, guna-werrwerrjinga guna-bamuna, rrapa barlmarrk wana gu-bena rrapa gu-buna gun-gata bala, lika burr-guya gu-rrumurra, laka gu-ganyja.” ");
INSERT INTO bvr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ganapiya, lika Jesus gu-wulebana gun-gata janguny gun-guyinda, wurra aburr-gata wurra gama gorlk gochila aburr-barrjinga nula gun-gata nipa a-wena. ");
INSERT INTO bvr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ngardawa nipa wana an-babalapa a-wena burrwa a-ni, rrapa ngika minypa aburr-birripa aburr-gata joborr marn․gi burrbi-negarra aburr-workiyana. ");
INSERT INTO bvr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Gun-gatiya waypa Jesus ana-bupiyana gu-bulgapulga wenga, lika aburr-murra wurra gama gorlk abu-jurrjurrmurra. ");
INSERT INTO bvr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Rrapa an-ngardapa an-gugaliya an-gata burr-guya an-jeja a-ngolkuja minypa gun-guburlububurluja gu-rrimarra, nipa ana-bona, Jesus ana-gochila ana-menama gu-rrana nula, lika a-wena nula, “Bunggawa, nginyipa ganyjarr n-dimanga barra minyja nginyipa jal nyi-ni, gun-nerra ny-yerrnyja apula rrapa minypa wanngu nguna-nega.” ");
INSERT INTO bvr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Lika Jesus mernda a-jirra a-jerrjangardawiyana, a-rrimarra an-gata an-jeja a-ngolkuja minypa gun-guburlububurluja gu-rrimarra. A-yinanga nula, “Ngaw, ngaypa jal ngu-nirra. Ny-molamiyapa barra!” Lika warrika gun-gata gun-nerra gu-bona nula an-gata an-gugaliya. ");
INSERT INTO bvr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Lika Jesus burr-guya a-wena nula, “A-lay, galiya: Gala barra nguna-ngurrja ngaypa ngiy-jarlapuna. Wurra gun-narda gun-nginyipa wupa janguny yongun nyi-nega barra. Wurra jechinuwa boy junggay yerrcha aburr-nirra, birripa barra bubi-na rrapa minyjak nginyipa barra burr-wu nula Wangarr an-nigipa. Ngardawa gu-gurda ngacha Mojich (Moses) gu-gurrmurra gun-guwarr minypa barra wurra gama gorlk marn․gi aburr-ni nggula minypa gun-nerra gu-bona nggula.” ");
INSERT INTO bvr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Gu-gata wenga lika Jesus a-bena gun-gata rrawa Gapárniyam (Capernaum), lika an-gata burr-ganyja a-workiya Rowm (Rome) an-guyinda an-dakal, nipa ana-bona nula Jesus, lika a-ngiwija nula barra nipa Jesus a-gunggaja nula. ");
INSERT INTO bvr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","A-yinanga, “A-lay, Bunggawa, an-ngaypa an-mujama a-yorrpurda a-yurra an-gaba rrawa. Nipa a-nyarlchinga rrapa burr-guya a-wurkurichinga.” ");
INSERT INTO bvr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesus a-wena, “Aya. Wurra ngaypa ngu-boy barra ngu-rrima, a-molamiya barra.” ");
INSERT INTO bvr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Wurra bunggawa an-gata burr-ganyja a-workiya an-dakal, nipa a-yinagata, “Ngika, a-la, Bunggawa, wurra ngaypa gala ngu-molamola rraka nyina-boy apula gun-ngaypa rrawa. Wurra minyja nginyipa ny-yengga, an-ngaypa an-mujama a-molamiya barra. ");
INSERT INTO bvr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ngardawa ngaypa ngu-yinagatiya minypa nginyipa: Minypa an-nerranga mu-ngoyurra a-jirra apula, rrapa minypa ngaypa mu-ngoyurra ngu-jirra burrwa aburr-gata aburr-ngaypa an-dakal nguburr-ganyja ngu-workiya. Minypa an-ngardapa ngaypa ngu-weya nula ngu-workiya, ‘Boy!’ lika nipa a-boya a-workiya; rrapa an-nerranga ngaypa ngu-weya nula ngu-workiya, ‘Guwa!’ lika nipa ana-jarlabiya ana-workiya; rrapa an-ngaypa an-mujama ngaypa ngu-weya nula, ‘Yinda jama ji,’ lika nipa a-yinagata a-workiya jama a-jirra.” ");
INSERT INTO bvr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Gun-narda Jesus a-galiyana minypa an-gata Rowm an-guyinda a-wena, lika nipa Jesus gochila a-barrjinga nula minypa nipa an-gata gu-werranga gu-rrawa wenga burr-guya marr a-balcha nuluwa. Lika nipa a-wena burrwa wurra gama gorlk aburr-gata abu-jurrjurrmurrapa aburr-bamuna, a-yinagata burrwa, “Buburr-galiya apula; gun-guna gun-burral: Ngaypa gala ana-nga ngu-barripungarna an-gata Yichrayal (Israel) an-guyinda burr-guya marr a-balcharna minypa an-guna. ");
INSERT INTO bvr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Minyjiya. Aburr-jaranga aburr-gata aburr-boy barra gurda marnnga jina-burrbeya wenga, rrapa marnnga jiy-bunggiya jiy-workiya wenga, lika aburr-raka barra burrwa Aybriyam (Abraham) rrapa Ayjek (Isaac) rrapa Jeykap (Jacob), rrapa wugupa mbi-bay barra aburr-ni balaja Nyanyapa arrku ana-murna. ");
INSERT INTO bvr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Wurra aburr-werranga aburr-guna jimarna Nyanyapa arrku ana-murna aburr-nirrarna, nipa burr-yerrnyja barra yarlanga, birripa barra aburr-ni an-munya gu-maya gu-jirra, rrapa minypa aburr-rruwuja barra aburr-ni aburr-workiya rrapa rrirra gubu-bay.” ");
INSERT INTO bvr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Lika Jesus a-wena nula an-gata minypa an-dakal a-ganyja a-workiya, “Boy rrawa, rrapa gu-yirda barra gu-ni nggula minypa gun-gata nginyipa marr ny-balcha apula.” Jesus a-yinagata a-wena, rrapa gatiya gugu ana-gata an-nika an-mujama a-molamiyana. ");
INSERT INTO bvr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Gu-gata wenga Jesus a-bamuna, a-bena Birta gun-nika rrawa. Lika gatiya Birta jin-nika jaburpa niya jinyu-nana nipa jiny-yorrpuna jiny-yu, minypa jin-donga jiny-ji. ");
INSERT INTO bvr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Lika nipa Jesus jin-dimarra murna jiny-jirra, lika gu-derda gu-bona achila rrapa warrika nipa jiny-jarlmuna, lika balaja burr-wuna jiny-bona. ");
INSERT INTO bvr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lika nuwurra waypa marnnga jiny-bungguna rrapa ana-munya gu-ni gu-bamuna, gu-galiya yerrcha burrbu-ganyja gurda nula Jesus aburr-jaranga aburr-gata walkwalk abi-rrimarra. Lika Jesus a-garlmuna, gun-ngardapa a-wena, walkwalk a-yerrnyjinga burrwa a-bona. Rrapa aburr-werranga aburr-gurderda nipa bin-dimarra, aburr-molamiyana; gala ana-nga a-ngukiyarna. ");
INSERT INTO bvr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nipa Jesus a-yinagata jama a-ji. Ngardawa Wangarr an-nika an-mujaruk an-gata Aycháya nipa wola a-ngurrjinga Jesus, a-yinagata, “Nipa wupa gu-menga, gu-yerrnyjinga arrburrwa gu-derda nguburr-yorrpuna rrapa mola gun-gata minypa werra arr-negarra gu-ni.” ");
INSERT INTO bvr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Gatiya waypa Jesus burr-nana aburr-murra wurra gama gorlk aburr-mulpiyana nula, lika nipa a-wena burrwa aburr-yigipa jawina yerrcha wupa barra aburr-jurrwa gu-gapa gu-rrarnba nipa Jesus burr-guta. ");
INSERT INTO bvr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Wurra burdak an-ngardapa an-gugaliya an-gata joborr marn․gi an-gunega, nipa ana-bona nula Jesus, a-yinanga nula, “A-lay, Bunggawa, ngaypa barra ngiy-jurrjurrmapa barra ngu-workiya ay-yinda minypa yina gaya n-digirrga.” ");
INSERT INTO bvr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Wurra Jesus a-yinanga nula, “A-lay, nginyipa marn․gi an-gata gulukula an-mugat an-guyinda nipa gu-rrimanga rrawa gu-rralala a-yurra a-workiya, rrapa nginyipa marn․gi burdacha jin-guyinda gu-rrimanga nipa gu-gapulawuja jiny-yorkiya, wurra an-guna An-walkurpa An-gugaliya gala gu-rrima rrawa nipa a-yurra a-workiya.” ");
INSERT INTO bvr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Rrapa an-nerranga an-gugaliya an-gata a-jurrjurrmurra a-workiyana Jesus, nipa a-garlmuna, a-wena nula, “A-lay, Bunggawa, ngaw minyja burdak nguna-jerrma, ngu-jeka, an-ngaypa nyanyapa apa nyirri-ni, nuwurra nguna-bawa, ngu-jurnumba?” ");
INSERT INTO bvr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Wurra Jesus a-wena, “Nguna-jurrjurrma ngaypa. Wurra an-gugaliya a-juwiya a-workiya bawa burrwa aburr-werranga gala wanngu aburr-ni; birripa abu-jurnumba barra.” ");
INSERT INTO bvr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ganapiya, lika Jesus a-gortkurrchinga mu-michiyang aburr-yigipa jawina aburr-nirra, lika aburr-jurrwurra aburr-bamuna wugupa. ");
INSERT INTO bvr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Lika gatiya gugu gojilapa barlmarrk wana gu-bena burrwa, rrapa michiyang birripa mbi-borrwurra jimarna mu-guybun; wurra Jesus nipa a-yu. ");
INSERT INTO bvr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Lika aburr-yigipa jawina aburr-garlmuna, abu-jortkarra, “Bunggawa, a-lay, gunggaja arrburrwa! Gala yapa nguburr-guybun!” ");
INSERT INTO bvr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Wurra nipa a-yinanga burrwa, “Awa! Ana-goyburrpa marr nyiburr-balcharra, gun-narda gun-delipa wupa, ya?” Lika nipa a-garlmuna, gu-jobujobuna, lika gatiya gugu warrpam gu-ngochinga barlmarrk rrapa bartpa. ");
INSERT INTO bvr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Lika aburr-gata gu-galiya yerrcha gochila aburr-barrjinga. Lika aburr-wengganachichiyana aburr-ni. Minypa aburr-yinanga, “A-lay, an-guna an-guyinmiya ngacha? Minyja bartpa rrapa barlmarrk nipa gu-jobujoburda a-boya, gu-galiyarra nula, ngarla!” ");
INSERT INTO bvr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ganapiya, lika gun-gatiya waypa Jesus a-bena rrawa gu-gapa gu-rrarnba gun-nelangga Gerrara (Gadara), nipa a-bena butula abirri-jirrapa gu-galiya yerrcha walkwalk abirri-dimarra. Gu-gurrema gu-ngarnama yi-gata wupa abu-gurrmunga aburr-workiya an-gugaliya a-juwiya a-workiya, gu-gatiya wenga gu-ngarnama bitipa abirri-bena gurda nula Jesus. Minypa bitipa burr-guya abirri-bachirra, rrapa gala ana-nga gun-gata jarlakarr gu-ma a-workiya, wurra aburr-gurkuja butula. ");
INSERT INTO bvr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Gun-gatiya waypa bitipa abirri-bena nula Jesus, warrika abirri-gonyjinga, “Nginyipa ny-jurda Wangarr biy-yika Walkur, an-nga nula nginyipa nyina-bona arrburrwa? Yina ngarla nyirr-yerrnyja barra ngayburrpa gala burdak gun-balmapa gu-nirrarna, ya?” ");
INSERT INTO bvr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Rrapa balay ngika jin-murra bigibigi jin-gata jin-bulapalawa m-banga jiny-boya. ");
INSERT INTO bvr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Lika aburr-gata walkwalk yerrcha burr-guya aburr-wena nula Jesus, aburr-yinagata, “Minyja nginyipa nyirr-yerrnyja, ngaw minyja nyirr-jerrma yi-gata bigibigi jin-bulawa jiny-jirra?” ");
INSERT INTO bvr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Lika Jesus a-wena burrwa, “Buburr-boy.” Lika birripa aburr-bena gurda, burrbu-bawuna abirri-gata gu-galiya yerrcha, lika aburr-bona yi-gata bigibigi jiny-jirra. Lika jin-gata bigibigi jin-bulapalawa gu-bulgapulga gu-bukula jiny-bupiyana jiny-yurtchinga; jiny-yurtchingapa gu-bugula jiny-juybuna gu-bulgapulga gu-gera. ");
INSERT INTO bvr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Rrapa aburr-gata gu-galiya yerrcha jaga aburr-ganana aburr-workiyana jin-gata bigibigi jin-guyinda, birripa aburr-yurtchinga, gu-murna rrawa gubu-ngurrjinga burrwa burr-gurla gun-gata janguny, minypa bigibigi jiny-yinmiyana, rrapa abirri-gata gu-galiya yerrcha walkwalk abirri-dimarra gu-yinmiyana gu-ni butula. ");
INSERT INTO bvr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Lika aburr-murra wurra gama gorlk aburr-garlmuna, rrawa wenga aburr-bona, aburr-bena nula Jesus. Rrapa gun-gatiya waypa birripa abi-nana Jesus, lika aburr-ngiwija nula gun-birripa rrawa gun-gata wana gun-bapala nipa barra gu-bawa a-boy. ");
INSERT INTO bvr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Gun-gatiya lika Jesus a-gortkurrchinga mu-michiyang, lika a-jekarra gu-gapa gu-rrarnba gu-yigipa gu-rrawa. ");
INSERT INTO bvr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Lika warrika abu-ganyja gurda nula an-nyarlkuch an-gata mu-yigipa mu-garrung a-yu. Rrapa gun-gatiya waypa Jesus gu-nana burrwa minypa birripa burr-guya marr aburr-balcha nula aburr-ni, lika nipa a-wena nula an-nyarlkuch, “A-lay, walkur, ganapa gurkuja! Nginyipa werra nyi-negiyana ny-yorkiyana gipa gugu baywarra gu-ni nggula,” a-yinagata nula. ");
INSERT INTO bvr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wurra aburr-werranga aburr-gata joborr marn․gi aburr-gunega, birripa bama aburr-jirra wupa gubu-borrwurra aburr-ni, “An-guna an-gugaliya a-weya a-nirra, wana a-negiya a-nirra nula Wangarr, ngarla!” ");
INSERT INTO bvr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Wurra Jesus gu-nana burrwa gun-gata birripa gubu-borrwurra nula, lika nipa a-wena burrwa, “An-nga nula gun-nerra gun-guyinda ana-goyburrpa nyibu-borrwuja nyiburr-nirra wuparnana nyiburr-ngurrnga? ");
INSERT INTO bvr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Wurra gun-nga gun-guna jimarna ana-goyburrpa bama nyiburr-yinaga gun-derta apula rraka ngaypa ngu-yirda nula an-guna? Minyja ngu-yinda nula, ‘Nginyipa werra nyi-negiyana ny-yorkiyana gipa gugu baywarra gu-ni nggula,’ gu-gurda ngacha, ya, wurra minyja ngu-yinda nula, ‘Garlma, jarlabiya’? ");
INSERT INTO bvr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Wurra ngaypa arr-gurdagurdarra barra minypa an-guna An-walkurpa An-gugaliya ganyjarr gu-rrimanga gun-guniya rrawa nipa barra baywarra gu-nega ana-gorrburrwa gun-nerra nyibi-rrimarra.” Lika a-wena nula an-nyarlkuch, “Garlma, jinyja! Mun-nginyipa garrung ma, lika bamiya boy rrawa!” ");
INSERT INTO bvr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Lika nipa an-gata an-gugaliya a-garlmuna, lika garrung mu-menga, a-bamiyana a-bona rrawa. ");
INSERT INTO bvr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Rrapa gun-gatiya waypa aburr-jaranga aburr-gata abi-nana, lika gochila aburr-barrjinga, rrapa Wangarr abu-burrmaymbuna ngardawa minypa nipa burr-wuna gu-galiya yerrcha gu-gata ngacha ganyjarr. ");
INSERT INTO bvr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesus gu-bawuna gun-gata rrawa, lika a-bamuna, a-nana an-gugaliya an-nelangga Metiyu (Matthew) gatiya gu-birlapirla nipa a-ni a-workiyana rrapa jama a-ji. Nipa an-mujama nula gapman (government) rrupiya mu-menga nula a-workiyana, gu-galiya yerrcha burr-gaypuna. Wurra Jesus a-wena nula, “Guwa! Nguna-jurrjurrma.” Lika nipa Metiyu a-garlmuna, lika a-jurrjurrmurra Jesus. ");
INSERT INTO bvr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Gu-gata wenga Jesus rrapa aburr-yigipa jawina balaja mbi-barra aburr-ni gun-gata Metiyu gun-nika rrawa, rrapa aburr-werranga aburr-bona gurda, aburr-mulpiyana burrwa, wugupa mbi-barra aburr-ni. Minypa aburr-jaranga aburr-gata aburr-mujama nula gapman rrupiya mbi-menga nula aburr-workiyana, gu-galiya yerrcha burrbu-gaypuna, rrapa mola aburr-werranga aburr-gata aburr-werra burr-guta, birripa wugupa nula Jesus mbi-barra aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Rrapa gun-narda waypa Berachi (Pharisee) yerrcha aburr-gata gubi-nana, lika burrbu-wengganana aburr-ni Jesus burr-yika jawina, aburr-yinanga burrwa, “An-nga nula an-goyburrpa bunggawa wugupa burrwa aburr-guna mbi-banga aburr-nirra? Wurra aburr-guna birripa aburr-mujama nula gapman rrupiya mbi-mangga nula aburr-workiya minypa wurra gama gorlk burrbu-gaypurda, ngarla! Rrapa aburr-werranga aburr-guna birripa burr-guta aburr-werra!” ");
INSERT INTO bvr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Wurra gun-narda Jesus a-galiyana burrwa aburr-wena, lika nipa gu-ngurrjinga burrwa, “Gu-galiya yerrcha aburr-gata aburr-mola, birripa gala jal aburr-ni an-buburda barra bin-dima; wurra aburr-gata aburr-yorrpurda birripa wupa jarra. ");
INSERT INTO bvr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Buburr-boy, marn․gi buburr-ni gun-nga meyali gun-gata janguny mu-jurra gu-yurra, gu-yinaga, ‘Ngaypa jal ngu-nirra jimarna ana-goyburrpa burr-guya nyiburr-mola nyiburr-nirrarna burrwa gu-galiya yerrcha; wurra ngaypa gala jal ngu-ni gun-gata minypa minyjak jin-guyinda nyibu-burnda nyiburr-workiya rrapa nyibi-yalpurda apula.’ Minyja bubu-borrwa: ngaypa gala nguna-boyarna burrwa aburr-gata minypa jechinuwa aburr-nirra; wurra jarra ngaypa nguna-bona burrwa aburr-gata aburr-werra birripa barra gun-nerra gubu-bawa.” ");
INSERT INTO bvr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Lika Jon an-gata bama burr-gurragaja a-workiyana, nipa aburr-yigipa jawina aburr-bona gurda nula Jesus rrapa abu-wengganana, “A-lay, an-nga nula ngayburrpa nyiburr-guna rrapa Berachi yerrcha burr-guta wolawola balaja nyibu-bawuja nyiburr-workiya minypa gun-ngayburrpa gun-guwarr, wurra aburr-nginyipa jawina gala balaja mbi-bawa aburr-workiya?” Aburr-yinagata aburr-wena nula. ");
INSERT INTO bvr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Lika Jesus gu-ngurrjinga burrwa, a-yinanga, “Gun-narda ana-goyburrpa ngunabu-wengganana, wurra marrka bubu-borrwa gun-guna gun-maywapa ranginy barra marn․gi nyiburr-ni: Minypa an-ngardapa gochila a-rranapa nipa jiny-ma barra jin-nigipa gama, rrapa gatiya waypa aburr-yigipa jawina aburr-mulpiya nula balaja barra mbi-bay rrapa aburr-worlworlcha burrinyjula, birripa gala aburr-yinmiya wargugu aburr-ni; jarra nipa an-gata burdak wugupa burrwa. Wurra barrwa guna-bamburda aburr-werranga burrbu-gaypa barra, lika abu-ga barra aburr-boy. Gun-gatiya jarra minypa aburr-yigipa jawina balaja mbi-bawa barra. ");
INSERT INTO bvr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Rrapa minypa ana-goyburrpa nyibu-ngurrjinga apula gun-goyburrpa gun-guwarr, jarra ngaypa minypa nguna-ganyja ana-gorrburrwa gun-geka janguny. Rrapa gun-narda nula marrka bubu-borrwa gun-maywapa ranginy minypa gun-guna: Minyja mun-delipa mun-gata mirikal mun-maywa m-barrja rrapa ay-birlpa, wurra gala arr-yinmiya mu-geka mu-guyinda ay-birlpa mun-gata mun-maywa. Gala yapa jurdach ay-wepa rrapa mun-gata mun-geka mu-ngoyurra ay-barnjinga galapa mun-delipa mu-ningin m-bamun, rrapa mun-gata ay-birlpana mu-garlmapa wana mun-babalapa m-barrjin. ");
INSERT INTO bvr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Rrapa barrwa gun-maywapa minypa an-gugaliya an-gata wayin (wine) mu-jarlapurda a-workiya: Nipa mun-girra mu-mangga, lika ji-maliyarra ji-guyinda mu-jerrjerrjinga a-workiya yi-gata wupa, wurra nipa gala a-yinmiya jin-gata jin-maywa ji-guyinda mu-jerrjerrja, mu-ngoyurra jinyu-derichinga. Wurra mun-girra m-bongbongja rrapa wana mu-ni, galapa jin-gata jin-maliyarra jiny-birljin minypa mun-gata mun-girra m-boga mu-jingin rrapa jin-gata jin-maliyarra gun-nyagara gu-ningin. Wurra jarra mun-geka wayin mbi-jerrjerrjinga aburr-workiya ji-maliyarra ji-guyinda ji-geka, lika wayin mun-gata mun-molamola mu-ni barra rrapa jin-maliyarra jin-molamola jinyu-ni barra burr-guta.” ");
INSERT INTO bvr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Gun-gatiya Jesus a-wena a-ni, an-ngardapa an-gugaliya an-gata jaga a-ganaja a-workiya gun-gata bala Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya, nipa ana-bona, ana-menama gu-rrana nula Jesus, a-yinanga nula, “Jin-ngaypa walkur jin-guna waya gun-nyagara gu-ni, wurra guwa, arr-boy barra n-dima, barra nipa wanngu jinyu-ni.” ");
INSERT INTO bvr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Lika Jesus a-garlmuna, nipa rrapa aburr-yigipa jawina wugupa abu-jurrjurrmurra aburr-bamuna an-gata gun-nigipa rrawa. ");
INSERT INTO bvr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Wurra jin-ngardapa gama jin-gata jiny-jortchinga jiny-yorkiyana gun-gatiya nipa jiny-yorrpuna jiny-yu gun-bulawa jemberr minypa 12, nipa ana-jonama jina-bamuna nula Jesus, lika mirikal murna mu-jirra mu-rrimarra nula. ");
INSERT INTO bvr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ngardawa nipa bama jiny-yinanga, “Minyja ngaypa ngu-rrima nula mirikal barra ngaypa ng-gaypa barlmarrk, lika ngu-molamiya.” ");
INSERT INTO bvr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Gun-gatiya gugu Jesus a-ngukurdanyjiyana, jinyu-nana, lika a-wena achila, “Nginyipa ny-jurdiya, walkur, ganapa gurkuja. Wurra nginyipa ngardawa marr ny-balcha apula, lika nginyipa ny-molamiyana.” A-yinagata a-wena achila, ganapiya, lika jinyu-derichinga mu-ngoyurra jiny-jortchinga jiny-ji. ");
INSERT INTO bvr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ganapiya, lika nuwurra waypa Jesus a-bena an-gata jaga an-gugana gun-nika rrawa, nipa burr-nana wupa gu-bala aburr-japarndiyana aburr-ni, rrapa minypa wurra gama gorlk gu-ngardapa aburr-negiyana aburr-bamuna aburr-rruwujana. ");
INSERT INTO bvr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Lika nipa a-wena burrwa, “Buburr-bengga buburr-yurtcha! Jin-guna delipa gala jiny-juwiyarna, wurra nipa jarra jiny-yurra.” Lika birripa aburr-gurdachinga nula. ");
INSERT INTO bvr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Wurra gun-gata waypa nipa burr-yerrnyjinga, lika gu-gatiya wenga a-barrngumurra wupa gu-ngarnama nipa delipa jiny-juwuna jiny-yunya gatiya. Lika murna jiny-jirra jin-dimarra, lika nipa jiny-jarlmuna. ");
INSERT INTO bvr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Rrapa janguny gun-gata gu-barrjekarra gu-gata gu-rrawa gu-jirra gu-boya aburr-galiyana. ");
INSERT INTO bvr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Lika Jesus gu-bawuna a-bona gun-gata rrawa, lika a-bamuna, rrapa abirri-jirrapa gu-galiya yerrcha abirri-gapula mipila abirri-jirra bitipa abirri-garlmuna, abirri-jurrjurrmurra abirri-bamuna. Abirri-gonyjinga abirri-ni, “A-lay, gunggaja atila, a-lay, ny-junarda nipa Daybit (David) murna biy-wuna arrburrwa.” ");
INSERT INTO bvr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Rrapa nuwurra waypa Jesus a-bena rrawa rrapa a-barrngumurra wupa gu-bala, lika bitipa abirri-gata abirri-gapula abirri-barrngumurra rrapa abirri-bona gurda nula. Lika Jesus bijirri-wengganana, “Ana-gotipa marr nyirri-balcharra apula, ya, ngaypa barra ajirri-dima?” “Ngaw, Bunggawa!” bitipa abirri-yinagata. ");
INSERT INTO bvr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Lika Jesus bijirri-dimarra mipila abirri-jirra, lika a-wena, “Ganapiya. Gu-yirda barra gu-ni minypa ana-gotipa marr nyirri-balcharra apula.” ");
INSERT INTO bvr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Lika abirri-molamiyana, mun-barra gugu abirri-ganana. Lika Jesus burr-guya a-wena butula, a-yinagata, “Gun-narda gala barra nyirri-wengga burrwa wurra gama gorlk minypa geka ajirri-jarlapuna.” ");
INSERT INTO bvr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Wurra bitipa abirri-bona, gubirri-ngurrjinga abirri-bona, lika janguny gu-barrjekarra nula Jesus, lika aburr-galiyana gun-gata rrawa gu-jirra gu-boya. ");
INSERT INTO bvr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wurra gun-gatiya waypa bitipa abirri-bona, aburr-werranga gugu abu-ganyja gurda nula Jesus an-ngardapa an-nganamukmuk gala a-yinmiya a-wengga, ngardawa walkwalk a-rrimanga. ");
INSERT INTO bvr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Lika gatiya waypa walkwalk a-yerrnyjinga nula, nipa gugu an-gugaliya a-wena. Rrapa wurra gama gorlk aburr-gata gochila aburr-barrjinga, aburr-yinanga, “Gu-gurda ngacha ngayburrpa gala ngubi-nacharna nguburr-workiyarna nguburr-gunaga Yichrayal (Israel) nguburr-bapurr!” ");
INSERT INTO bvr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Wurra Berachi yerrcha aburr-gata aburr-bachirra nula Jesus, birripa aburr-wena, “Ngika, wurra an-gata minypa walkwalk yerrcha burr-ganyja a-workiya, nipa jarra a-wuna ganyjarr, an-guna burr-yerrnyjinga a-workiya walkwalk an-guyinda.” ");
INSERT INTO bvr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesus mu-nguy a-bamuna gun-gata rrawa gu-jirra gu-boya gu-delipa rrapa wana. Minypa bala gu-jirra gu-boya Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya, nipa gu-gata gu-bala a-barrngumurra, a-bena burrwa a-workiyana, rrapa janguny marn․gi burr-negarra a-ni. Nipa gu-ngurrjinga burrwa a-workiyana gun-molamola janguny, minypa gun-nardiya gugu rum gun-gata waykin wenga. Rrapa nipa bin-dimarra, aburr-molamiyana gu-galiya yerrcha gu-gata gu-derda birripa gubi-rrimarra, minypa ngoyurra gun-derta burr-guta. ");
INSERT INTO bvr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Rrapa gatiya waypa burr-nana aburr-murra wurra gama gorlk, nipa a-worijinga burrwa, ngardawa birripa aburr-werra aburr-ni minypa jin-maywapa jip jin-guyinda jin-gata gala ana-nga jaga a-gana achila a-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Minypa nipa a-wena burrwa aburr-yigipa jawina, a-yinanga burrwa, “Aburr-gata wurra gama gorlk, birripa minypa mun-maywapa balaja mun-murra mu-jinyjarra mun-mola, wurra aburr-yinpa gala aburr-jaranga aburr-mujama rraka mbi-ma. ");
INSERT INTO bvr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Wurra bubu-wenggana Bunggawa mu-gata nula balaja, barra nipa burr-jerrma aburr-mujama, birripa barra aburr-boy, mbi-ma nula mun-nigipa mun-gata gipa mu-molamiyana.” Jesus a-yinagata a-wena burrwa aburr-yigipa jawina, minypa gun-narda ngika balaja mu-ngurrjinga, wurra jarra gu-galiya yerrcha nuluwa Wangarr. ");
INSERT INTO bvr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesus a-gonyjinga burrwa aburr-yigipa gu-galiya yerrcha aburr-gata arr-jirrapa arr-murna rrapa abirri-jirrapa, minypa 12, lika nipa burr-wuna ganyjarr birripa barra abi-yerrnyja burrwa wurra gama gorlk walkwalk an-guyinda, rrapa mola burrbi-rrima, aburr-molamiya gu-gata gu-derda birripa gubi-rrimarra minypa ngoyurra gun-derta burr-guta. ");
INSERT INTO bvr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Minypa Jesus burr-yika aburr-mujama arr-jirrapa arr-murna rrapa abirri-jirrapa aburr-gunaga aburr-welangga: Minypa mu-ngoyurra a-jirra Jayman (Simon) an-gata an-nelangga abu-ngurrjinga aburr-workiya Birta (Peter), barrwa an-nigipa worlapa niya Andru (Andrew); rrapa mola Jeymch (James) rrapa an-nigipa worlapa niya Jon (John) abirri-gata Jebadi (Zebedee) bijirri-yika walkurpa yerrcha; ");
INSERT INTO bvr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","rrapa mola Bilip (Philip), Bartólamiyu (Bartholomew), Domach (Thomas), rrapa Metiyu (Matthew) an-gata an-mujama nula gapman rrupiya mu-mangga nula a-workiya, gu-galiya yerrcha burr-gaypurda; rrapa Jeymch an-gata Alpiyach (Alphaeus) an-nika walkur; rrapa mola Jerriyich (Thaddaeus), ");
INSERT INTO bvr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","rrapa Jayman an-gata burr-guya gu-borrwurra rrawa; rrapa Jurrach Yichkériyat (Judas Iscariot) an-gata jurdach aburr-bachirra murna burr-wuna Jesus. ");
INSERT INTO bvr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Aburr-gurdiya wupa Jesus burr-yika 12 gu-galiya yerrcha nipa burr-jerrmarra. Minypa nipa gu-jarlapuna a-wena burrwa, “Gala barra nyiburr-boy gun-gata rrawa Jentayl (Gentile) aburr-bapurr aburr-nirra o Jimériya (Samaria) rrawa gu-jirra gu-boya. ");
INSERT INTO bvr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Wurra Yichrayal (Israel) aburr-bapurr buburr-boy burrwa, aburr-gatiya minypa jin-maywapa jin-gumurna jip jinyu-lijiwarriyana. ");
INSERT INTO bvr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Buburr-boy, buburr-wengga burrwa gun-birripa rrawa gu-jirra gu-boya, buburr-yinda burrwa, ‘Gun-guniya gugu yi-gurrepa gu-jirra gu-boya rum gun-gata waykin wenga.’ ");
INSERT INTO bvr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Burrbi-rrima aburr-gurderdakurderda, rrapa burrbu-jarrkarra mu-ngoyurra aburr-juwuna. Burrbi-rrima aburr-gata aburr-jeja aburr-ngolkuja, minypa gun-guburlububurluja gubi-rrimanga, rrapa walkwalk an-guyinda bubi-yerrnyja burrwa wurra gama gorlk. Minypa ana-goyburrpa ganyjarr nyibu-menga burr-rrupiya ngika, buburr-yirda buburr-gunggaja burrwa wurra gama gorlk; gala barra rrupiya nyiburr-ngiwija burrwa. ");
INSERT INTO bvr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Rrapa mola gala barra rrupiya nyibu-barrba, nyibu-ga, minypa goldan rrapa jilpa (silver) rrapa mun-delipa mun-guyinda; wurra bubu-bawa. ");
INSERT INTO bvr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Gala barra nyibu-borrwa gun-gata minypa gu-baykarda nyiburr-boy barra. Gala barra burlupurr nyiburr-birringgiya rrapa nyibu-barrba gun-nga. Gala barra nyibu-ga mola mun-nerranga mun-gumirrka rrapa mola gun-nerranga nyiburr-barrngumiya nyiburr-workiya rrepara nyiburr-jirra, rrapa minypa gun-gugarlakarlaja gun-jong. Ngardawa an-mujama an-guyinda wurra gama gorlk barra abu-wu aburr-workiya mun-nga mun-gata nipa jal a-nirra. ");
INSERT INTO bvr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Minypa ana-goyburrpa nyiburr-bengga gun-gata gu-murna rrawa, gatiya nyiburr-wechawecha barra ana-nga an-mola gu-yigipa gu-rrawa barra nyiburr-ni, lika gatiya barra nyiburr-ni, nuwurra gun-gata gu-murna rrawa nyibu-bawa. ");
INSERT INTO bvr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Rrapa gun-gatiya waypa ana-goyburrpa nyiburr-bengga burrwa nyiburr-workiya gu-birripa gu-rrawa, gun-molamola buburr-wengga burrwa buburr-workiya minypa Wangarr barra wugupa burrwa. ");
INSERT INTO bvr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Barra minyja gu-galiya yerrcha gun-gata rrawa aburr-gonyja gurda ana-gorrburrwa, birripa aburr-yirdapa barra minypa ana-goyburrpa nyiburr-wena; aburr-molamola aburr-nipa barra aburr-workiya, gala barra minypa gun-nga gubu-borrwa aburr-ni. Wurra minyja gala aburr-gonyja gurda ana-gorrburrwa, ganapiya, gun-gata nyiburr-wena burrwa gun-molamola, gun-narda gu-ngukiya barra rrapa minypa guna-jeka barra ana-gorrburrwa. ");
INSERT INTO bvr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Rrapa minyja aburr-nga aburr-gata gala aburr-gonyja gurda ana-gorrburrwa rrapa gala aburr-galiya ana-gorrburrwa janguny, lika bubu-bawa gun-gata rrawa, rrapa rrawa gu-gera lika gatiya buburr-wepiya rrepara nyiburr-jirra baluk gu-gata gu-yika gu-rrawa. ");
INSERT INTO bvr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ngardawa ngaypa ngu-weya ana-gorrburrwa gun-burral: Jurdach guna-bamburda Wangarr barra burr-mari a-wengga, birripa gu-gata burr-yika gu-rrawa burr-guya gun-nerra gu-ni barra burrwa; aburr-gata mu-ngoyurra aburr-ni rrawa Jorram (Sodom) rrapa Gumóra (Gomorrah), birripa marr gu-yinda barra gun-nerra gu-ni burrwa! ");
INSERT INTO bvr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Buburr-galiya apula! Ngaypa arr-jerrma barra ana-goyburrpa minypa jin-maywapa jin-gumurna jip, wurpa lika ngaypa arr-jerrma barra minypa gun-maywapa ranginy rrawa an-muworduk a-rrigirrgnga a-workiya. Buburr-jarlapiya minypa gun-maywapa nguymbula a-jarlapiya a-boya a-workiya; wurra nyiburr-dor buburr-ni buburr-workiya minypa jin-maywapa mukumul jin-guyinda gala gun-nga gun-nerra gu-rrima jiny-yorkiya. ");
INSERT INTO bvr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Gu-galiya yerrcha buburr-jarlapiya burrwa. Ngardawa aburr-werranga aburr-gata aburr-bachirramiya barra ana-gorrburrwa, nyirrbi-rrima barra, nyirrbu-ga barra, nyirrbu-barnja barra Ju yerrcha ganychila (councillor) birripa aburr-yinmiya barra aburr-wengga. Rrapa gata gu-bala gu-jirra gu-boya Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya, birripa nyirrbu-jurrburaykujama barra ana-goyburrpa. ");
INSERT INTO bvr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ngardawa ana-goyburrpa nyiburr-ngaypa jawina, birripa barrwa nyirrbi-rrima barra, nyirrbu-ga barra, nyirrbu-barnja gapman an-guyinda a-yinmiya barra a-wengga an-mumurna an-guyinda burr-guta. Wurra jarra ana-goyburrpa barra ngaypa ngunabu-ngurrja barra burrwa aburr-gata bunggawa yerrcha. Gu-gurda ngacha minypa bunggawa an-guyinda rrapa mola Jentayl yerrcha aburr-galiya barra gun-guna gun-molamola janguny. ");
INSERT INTO bvr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Gatiya waypa birripa nyirrbu-ga aburr-bamba aburr-gata aburr-yinmiya barra aburr-wengga, gala barra nyibu-borrwa nyiburr-ni ana-goyburrpa nyiburr-yinmiya barra nyiburr-wengga. Wurra gatiya gugu Wangarr nyirr-wu barra gun-gata gun-nga ana-goyburrpa barra nyiburr-wengga. ");
INSERT INTO bvr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Minypa gun-gata ana-goyburrpa nyiburr-wengga barra ngardawa ana-goyburrpa wupa nyanma ngika, wurra Nyanyapa Arrku An-mawunga nipa wupa nyanma jarra. ");
INSERT INTO bvr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Rrapa gu-galiya yerrcha burrbi-rrima barra aburr-workiya aburr-birripa worlapa burra yerrcha, ngarla, rrapa burrbu-barnja barra aburr-workiya barra aburr-juwa. Rrapa nyanyapa burra yerrcha aburr-yirda barra burrwa aburr-birripa gu-ngarda yerrcha. Rrapa delipa yerrcha aburr-garlma barra, aburr-bachirramiya barra burrwa aburr-birripa nyanyapa burra yerrcha rrapa mampa burra yerrcha, lika burrbu-barnja barra aburr-workiya barra aburr-juwa. ");
INSERT INTO bvr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Rrapa aburr-jaranga gu-galiya yerrcha aburr-bachirramiya barra ana-gorrburrwa aburr-workiya ngardawa minypa ana-goyburrpa nyiburr-ngaypa. Wurra ny-yinga ny-jata minyja gala ny-jeka, wurra minypa ny-jinyjapa barra ny-yorkiya, nuwurra nginyipa jurdach wanngu nyi-ni barra. ");
INSERT INTO bvr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Minyja birripa werra nyirrbu-bu gu-ngardapa gu-rrawa, wurra buburr-lijiwarriya burrwa, buburr-boy gu-werranga gu-rrawa. Ngaypa ngu-weya ana-gorrburrwa gun-burral: Gun-gata ana-goyurra gugu gala barra nyibu-wuleba gun-goyburrpa jama gun-guna rrawa gu-jirra gu-boya Yichrayal, wurra ni-gugu an-guna An-walkurpa An-gugaliya ana-jeka barra. ");
INSERT INTO bvr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“An-gugaliya ana-nga an-gata marn․gi a-nirra a-bamburda, nipa gala a-yinmiya a-beyba an-nigipa marn․gi a-nenga a-workiya. Rrapa an-mujama an-guyinda nipa gala a-yinmiya a-beyba an-nigipa bunggawa. ");
INSERT INTO bvr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Wurra an-gugaliya minyja nipa a-ni minypa an-nigipa marn․gi a-nenga a-workiya rrapa minypa an-nigipa bunggawa a-nirra, an-gata an-gugaliya gala barra barrwa gun-nga nipa jal a-ni. Gu-gurda ngacha minypa ngaypa ng-gunaga mu-ngoyurra ngu-jirra ana-gorrburrwa birripa ngunabu-yopuna, jimarna bama aburr-yinanga ngaypa Biyíljabap (Beelzebub) an-gata gun-nerra an-gurrimapa; rrapa ana-goyburrpa nyiburr-gurda nyiburr-ngaypa gu-galiya yerrcha, birripa mu-nguy burr-guya gun-nerra aburr-wengga barra ana-gorrburrwa. ");
INSERT INTO bvr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Wurra ana-goyburrpa gala barra nyiburr-gurkuja burrwa gu-galiya yerrcha. Wurra gun-nga gun-gata gu-yilkakiya gu-yurra, burraya gu-garlma barra yarlanga gu-yu. Rrapa gun-nga gun-jaranga yongun gu-yurra, burraya aburr-jaranga marn․gi aburr-ni barra gun-gata. ");
INSERT INTO bvr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Gun-guniya ana-munya gu-nirra gun-nga gun-guna ngaypa ngu-weya ana-gorrburrwa ngu-nirra, nuwurra waypa rrengarrenga gu-ni, ana-goyburrpa barra nyibu-ngurrja burrwa wurra gama gorlk. Minypa gun-nga ana-goyburrpa nyiburr-galiyarra ngaypa yongun ngu-weya ana-gorrburrwa ngu-nirra, nuwurra jurdach ana-goyburrpa barra nyiburr-jabarrcha nyiburr-ji rrawa. ");
INSERT INTO bvr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Gala barra nyiburr-gurkuja burrwa aburr-gata minypa nyiburr-burral wupa nyirrbu-bun rrapa gala aburr-yinmiya nyiburr-ngurrnga nyirrbu-bu. Wurra jarra buburr-gurkuja nula nipa wupa an-ngardapa Wangarr an-gata ganyjarr gu-rrimanga an-gugaliya a-bu yi-gata gu-bol, minypa an-burral an-ngurrnga burr-guta. ");
INSERT INTO bvr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Minyja bubu-borrwa jin-delipa burdacha jin-guyinda ana-goyburrpa wolawola bayim nyiburr-nirra nyiburr-workiya. Minypa nyibu-barnjinga nyiburr-workiya mun-ngardapa wupa mun-delipa rrupiya rrapa nyibu-mangga nyiburr-workiya abirriny-jirrapa jin-gata burdacha. Wurra wuriya gala rrupiya wana achila jin-gata, wurra gala jin-ngardapa jiny-bungga jiny-yorkiya gu-jel, wurra minyja gun-narda Nyanyapa arrku gu-borrwurra achila. ");
INSERT INTO bvr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Rrapa ana-goyburrpa nipa Nyanyapa arrku marn․gi ana-gorrburrwa gun-bulapalawa, gun-gata burr-guta minypa mun-gata mejimija nyiburr-bama mu-yinmiyapa nyibi-rrimanga. Gu-gurda ngacha minypa nipa burr-guya nyirr-borrwuja a-workiya rrapa gurrurta gu-rrimanga ana-gorrburrwa. ");
INSERT INTO bvr_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ganapiya, lika gala barra nyiburr-gurkuja. Wurra minypa jin-gata jin-delipa burdacha nipa Nyanyapa arrku jal a-nirra achila, ana-goyburrpa jarra nipa burr-guya jal a-nirra ana-gorrburrwa. ");
INSERT INTO bvr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Minyja ana-nga gala a-jordajiya, wurra minypa a-wengga gatiya gu-galiya yerrcha aburr-galiyarra nula aburr-nirra minypa nipa an-gata an-ngaypa jawina, an-narda an-gugaliya ngaypa ngu-yirda barra ngu-ngurrja yi-gata waykin an-ngaypa Nyanyapa apa a-nirrapa. Minypa ngu-yinda barra, ‘An-guna an-ngaypa jawina.’ ");
INSERT INTO bvr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Wurra minyja ana-nga an-gata ngoyurra a-yerryerrmiya apula gatiya minypa gu-galiya yerrcha aburr-nirra, ngaypa barra ngoyurra ngu-yerryerrmiya nula an-gata an-gugaliya yi-gata waykin an-ngaypa Nyanyapa apa a-nirrapa. ");
INSERT INTO bvr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Gala barra nyibu-borrwa gun-gata ngaypa nguna-bona, jimarna magaya gun-guni nguna-ganyja gun-guna rrawa. Wurra gurda nula ngaypa gala nguna-boyarna. Jarra ngaypa nguna-bona, barrang minypa nguna-ganyja mari nula. ");
INSERT INTO bvr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ngaypa nguna-bona barra arr-ngorrkornda. Minypa walkurpa yerrcha aburr-bachirramiya barra burrwa nyanyapa burra yerrcha, rrapa aburr-jawapa burra yerrcha aburr-bachirramiya barra burrwa mampa burra yerrcha, rrapa jaburpa burra yerrcha aburr-bachirramiya barra burrwa jongok burrbi-nenga. ");
INSERT INTO bvr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Minypa an-gugaliya aburr-yigipa aburr-bachirra nula aburr-gatiya, ngarla, gu-yigipa gu-rrawa. ");
INSERT INTO bvr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ana-nga an-gata burr-guya jal a-nirra nula an-nigipa nyanyapa niya rrapa mampa niya, wurra jarra marr a-yinaga jal a-nirra apula ngaypa, an-gata an-gugaliya gala an-molamola rraka an-ngaypa jawina a-ni. Ana-nga an-gata burr-guya jal a-nirra nula an-nigipa an-walkurpa rrapa jin-nigipa jin-walkurpa, wurra jarra marr a-yinaga jal a-nirra apula ngaypa, an-gata an-gugaliya gala an-molamola rraka an-ngaypa jawina a-ni. ");
INSERT INTO bvr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ana-nga an-gata nguna-gengamanga a-nirra rrapa gala nguna-jurrjurrma, wurra minypa gu-borrwuja a-workiya gun-derta nipa gu-barripuna, an-gata an-gugaliya gala an-molamola rraka an-ngaypa jawina a-ni. ");
INSERT INTO bvr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ana-nga an-gata gala nguna-burdima, jimarna barra wanngu a-negiya, an-gata an-gugaliya jarra gun-nyagara gu-ni barra. Wurra ana-nga minyja aburr-werranga abu-bu, a-juwa minypa nipa an-ngaypa, an-gata an-gugaliya nipa jarra wanngu a-nipa barra a-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ana-nga an-gata ana-gonyja ana-gorrburrwa nyiburr-gurda nyiburr-ngaypa jawina, gun-narda minypa an-gata an-gugaliya ana-gonyjinga apula ngaypa; rrapa ana-nga ana-gonyjinga apula ngaypa, gun-narda minypa nipa ana-gonyjinga nula nipa nguna-jerrmarrapa. ");
INSERT INTO bvr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ana-nga an-gata ana-gonyja nula Wangarr an-nika an-mujaruk ngunyuna an-guyinda ngardawa gun-narda gu-borrwurra nula, an-gata an-gugaliya burraya Wangarr a-wu barra gun-molamola gun-nigipa gun-maywapa minypa an-gata an-nigipa an-mujaruk ngunyuna an-guyinda gu-ma barra. Rrapa ana-nga an-gata ana-gonyja nula an-gugaliya jechinuwa a-nirra a-workiya ngardawa gun-narda gu-borrwurra nula, an-gata an-gugaliya burraya Wangarr a-wu barra gun-molamola gun-nigipa gun-maywapa minypa an-gata an-jechinuwa gu-ma barra. ");
INSERT INTO bvr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Minyjiya. Nyiburr-guna nyiburr-ngaypa jawina ny-yinga ny-jata ny-yelangga n-delipa nyi-nirra, wurra minyja ana-werranga biy-wu bugula mern, waygaji gun-nga, ngardawa nipa gu-borrwurra nggula minypa nginyipa ny-nyaypa, an-gata an-gugaliya nipa Wangarr ana-nyala a-wu barra gun-molamola gun-nigipa minypa gun-gata nipa an-mola a-ni nggula.” ");
INSERT INTO bvr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ganapiya, lika gun-gatiya waypa Jesus gu-wulebana gun-gata nipa gu-jarlapuna a-wena burrwa aburr-yigipa jawina, lika gu-bawuna a-bona gun-gata rrawa. Lika ay-bamuna, gatiya rrawa gu-jirra gu-boya nipa marn․gi burr-negarra a-bona janguny, rrapa gelama gelama burr-barra a-ni. ");
INSERT INTO bvr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Rrapa Jon an-gata bama an-gugurraga gatiya wupa nipa brichina (prisoner) a-ni, nipa waypa a-galiyana minypa Christ a-yinmiyana jama a-ji a-workiyana, lika nipa bijirri-jerrmarra nula abirri-yigipa jawina abirri-mujaruk. ");
INSERT INTO bvr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Bitipa abirri-wena nula Jesus, “Ny-jurdiya nginyipa nyina-garlmuna arrburrwa nyi-gujerrjerrjiya, wurra waygaji an-nerranga barra nyiburr-gana nula nyiburr-ni, ya?” Abirri-yinagata. ");
INSERT INTO bvr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Lika Jesus a-wena butula, “Ana-gotipa birri-boy, birri-ngurrja nula Jon minypa geka nyirri-galiyana rrapa nyirri-nana. ");
INSERT INTO bvr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Minypa gapula aburr-ni barrwa gugu mipila aburr-jirra aburr-ganana, rrapa minypa aburr-burda aburr-guyinda aburr-rrigirrgnga gugu; rrapa aburr-jeja aburr-ngolkuja aburr-ji minypa gun-guburlububurluja gubi-rrimarra, gun-narda gugu gu-bona burrwa; rrapa minypa aburr-gerna aburr-guyinda barrwa aburr-galiyarra, rrapa mu-ngoyurra gun-nyagara gu-ni barrwa aburr-molamiyana, rrapa minypa aburr-welangga aburr-delipa aburr-galiyarra aburr-nirra gun-molamola janguny. Gu-gurda ngacha. ");
INSERT INTO bvr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Rrapa minyja ana-nga an-gata gala nguna-bawa, a-jeka, an-gata an-gugaliya Wangarr ana-nyala a-jalkakaja, nipa an-molamola a-nirra.” ");
INSERT INTO bvr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ganapiya, lika gun-gatiya waypa Jon bijirri-yika jawina burrbu-bawuna abirri-bona, Jesus a-garlmunapa Jon a-ngurrjinga a-ni burrwa wurra gama gorlk aburr-gata. A-yinanga burrwa, “Minypa ana-goyburrpa nyiburr-bona nula nyiburr-workiyana Jon gata gu-werrapa nipa a-ni, an-nga nula nyiburr-bona nula, ya? Wurra ana-goyburrpa jal nyiburr-ni jimarna barra nyibi-na an-gugaliya a-barrjejignga a-workiya minypa mun-maywapa gorrngunya gu-barlmarrk mu-jalanggakaja gu-workiya, ya? ");
INSERT INTO bvr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Wurra gun-narda ngika. Wurra an-nga nula nyiburr-bona nula? Wurra ana-goyburrpa jal nyiburr-ni jimarna barra nyibi-na an-gugaliya mun-molamola mun-guyinda mirikal a-barrngumiya a-workiya, ya? Wurra ngika gun-narda. Wurra aburr-gata mun-molamola aburr-barrngumiya aburr-workiya, birripa jarra bunggawa an-guyinda gun-nika rrawa aburr-nirra aburr-workiya, ngaja, ngarla, ngika minypa gu-werrapa. ");
INSERT INTO bvr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Wurra an-nga nula ana-goyburrpa nyiburr-bona nula Jon? Wurra ngardawa nipa Wangarr an-nika an-mujaruk, ya? Minyjiya, ngarla! Rrapa gun-narda wupa ngardapa ngika, wurra gun-guna ngu-weya ana-gorrburrwa gun-burral: ");
INSERT INTO bvr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jon an-nardiya mu-jurra a-ngurrjinga minypa Wangarr a-wena, a-yinanga, ‘Minyja na, an-ngaypa an-mujaruk mu-ngoyurra ngu-jerrma barra nggula nipa barra nawanawa a-ni nggula jarlakarr.’ ");
INSERT INTO bvr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Buburr-galiya apula gun-guna gun-burral: Gun-nardiya rrawa an-gugaliya a-ni a-workiyana, wurra an-gata gala ana-nga wana minypa Jon. Wurra wuriya. Wurra an-gata ana-nga gu-rrimanga apula janguny gun-guna ngaypa ngu-weya ana-gorrburrwa ngu-workiya, an-gata an-gugaliya marrban nipa an-nelangga an-delipa, wurra nipa jarra marr a-yinaga an-delipa, Jon nipa an-delipa. ");
INSERT INTO bvr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jon mu-namangarta aa gun-guniya burr-guta, aburr-werranga gala jal aburr-ni gun-gata waykin wenga rum. Rrapa aburr-bachirra aburr-guyinda aburr-garlmiya aburr-workiya, jimarn barra burrbu-gaypa Wangarr burr-yika gu-galiya yerrcha gun-gata minypa nipa burr-ganyjarr jama a-jirra burrwa a-nirra. ");
INSERT INTO bvr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ngardawa janguny gun-gata minypa wola gun-guwarr birripa gubu-ngurrjinga aburr-workiyana Wangarr gun-nika, rrapa joborr gun-gata minypa Wangarr a-wuna arrburrwa Mojich (Moses), gu-gata ngacha burr-gurdagurdarrana gu-yu wurra gama gorlk minypa an-gugaliya a-yinmiya barra Wangarr ana-murna a-ni. Gu-yinagata gu-workiyana, aa nuwurra Jon a-bena. ");
INSERT INTO bvr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Rrapa minyja ana-goyburrpa marr nyiburr-balcharra gun-birripa janguny, an-guna Jon nipiya Yiláyja (Elijah) an-gata birripa mu-ngoyurra abu-ngurrjinga minypa nipa ana-boy barra; wurra gipa gugu a-bena. ");
INSERT INTO bvr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ny-yinga ny-jata minyja gelama ny-jirra ny-jaliyana, borrwa ngaypa ngu-wena.” ");
INSERT INTO bvr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Lika nipa Jesus mu-nguy a-wena burrwa, a-yinagata, “Nyiburr-gurdiya gorlk ngu-yinmiya barra ngaypa arr-ngurrja, ya? Ana-goyburrpa minypa gun-nga gun-gata gun-maywapa? Wurra ana-goyburrpa minypa gun-maywapa gu-ngarda yerrcha aburr-dawurrjinga aburr-workiya gata wurra gama gorlk aburr-nirra aburr-workiya. Minypa birripa gu-ngarda yerrcha aburr-gonyjinga burrwa aburr-workiya gu-gapa gu-guta, aburr-yinagata, ");
INSERT INTO bvr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ngayburrpa nyiburr-japarndiyana, wurra ana-goyburrpa gala nyiburr-walagiyarna! Ngayburrpa nyiburr-rruwujana, wurra ana-goyburrpa gala nyiburr-malchingarna arrburrwa!’ ");
INSERT INTO bvr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Gu-gurdiya ngacha gun-maywapa, wurra gun-burral minypa Jon an-gata bama burr-gurragaja a-workiya rrapa mola an-guna An-walkurpa An-gugaliya. Minypa an-gata Jon nipa gala m-bay a-workiya rakaraka rrapa wayin (wine), rrapa gu-gurda nula ana-goyburrpa nyibu-yopurda nyiburr-workiya, nyiburr-yinaga, ‘Nipa walkwalk a-rrimanga.’ ");
INSERT INTO bvr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Rrapa minypa an-guna An-walkurpa An-gugaliya a-bena ana-gorrburrwa nipa jarra m-banga a-workiya, rrapa ana-goyburrpa nyibu-yopurda nyiburr-workiya nipa burr-guta. Minypa nyiburr-yinaga, ‘Minyja na, an-guna nipa mun-jaranga m-banga a-workiya balaja rrapa wayin; rrapa nipa a-malchinga burrwa aburr-gata aburr-mujama nula gapman rrupiya mbi-mangga nula aburr-workiya, gu-galiya yerrcha burrbu-gaypurda; rrapa aburr-werranga burr-guta aburr-werra nipa an-guna a-malchinga burrwa.’ Ana-goyburrpa nyiburr-yinagata nyiburr-workiya nyirrbu-yopurda Wangarr burr-yika jawina. Wurra gun-gata Wangarr gu-borrwurra rrapa jama a-jirra a-workiya, gu-galiya yerrcha aburr-gata wanngu aburr-nirra gugu, birripa jarra nyirrbu-gurdagurdarraja ana-goyburrpa minypa gun-gata gun-molamola gun-jechinuwa.” ");
INSERT INTO bvr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Lika Jesus a-garlmuna, burr-jonga aburr-werranga gu-galiya yerrcha aburr-gata, ngardawa birripa gala gun-nerra gubu-bawujingarna marrban gun-birripa rrawa nipa burr-barlmarrk jama a-ji a-workiyana. ");
INSERT INTO bvr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Nipa a-wena burrwa, “Awa! Nyiburr-gata rrawa Goréchin (Chorazin) rrapa Bachéyda (Bethsaida) nyiburr-nirra, yama nyiburr-ngukurdanyjiyarna? Wurra burraya burr-guya gun-nerra gu-ni barra ana-gorrburrwa. Wurra aburr-gata mu-ngoyurra aburr-ni rrawa Daya (Tyre) rrapa Jaydan (Sidon), minyja birripa gubi-nacharna gun-birripa rrawa Wangarr burr-barlmarrk jama a-jirrarna minypa gun-guniya nipa jama a-jirra gun-goyburrpa rrawa, birripa gun-nerra gubu-bawujarna aburr-jarl rrapa burr-guya aburr-ngukurdanyjiyarna nula Wangarr. ");
INSERT INTO bvr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Gun-guna ngu-weya ana-gorrburrwa gun-burral: Ana-goyburrpa nuwurra waypa barra nipa Wangarr burr-mari a-wengga, burr-guya gun-nerra gu-ni barra ana-gorrburrwa; aburr-gata mu-ngoyurra aburr-ni rrawa Daya rrapa Jaydan, birripa jarra marr gu-yinda barra gun-nerra gu-ni burrwa. ");
INSERT INTO bvr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Rrapa nyiburr-werranga nyiburr-gata Gapárniyam (Capernaum) nyiburr-nirra, ana-goyburrpa jimarna bama nyiburr-yinaga waykin nyirr-wenyaga barra nipa Wangarr, ya? Wurra nipa jarra nyirr-yerrnyja barra yi-gata gu-bol. Wurra aburr-gata mu-ngoyurra aburr-ni rrawa Jorram (Sodom), minyja birripa gubi-nacharna gun-birripa rrawa Wangarr burr-barlmarrk jama a-jirrarna minypa gun-guniya nipa jama a-jirra gun-goyburrpa rrawa, birripa aburr-ngukurdanyjiyarna rrapa gun-birripa rrawa mu-nguy gu-jirrarna. ");
INSERT INTO bvr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Gun-guna ngu-weya ana-gorrburrwa gun-burral: Ana-goyburrpa nuwurra waypa nipa Wangarr burr-mari a-wengga, burr-guya gun-nerra gu-ni barra ana-gorrburrwa; aburr-gata mu-ngoyurra aburr-ni rrawa Jorram, birripa jarra marr gu-yinda barra gun-nerra gu-ni barra burrwa.” ");
INSERT INTO bvr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Gatiya ji-maywapa marnnga Jesus a-wena, “Anya, ny-jurdiya Bunggawa nyi-nirra waykin rrapa wupa, ngaypa ngu-marrkapchinga nggula ngu-nirra, ngardawa gun-nginyipa janguny nginyipa ny-yilkakaja burrwa aburr-gata minypa marn․gi gun-jaranga rrapa aburr-borrwiya minypa birripa aburr-guralcha; wurra aburr-geka jarra nginyipa burr-gurdagurdarrana. ");
INSERT INTO bvr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ngardawa, Anya, nginyipa ny-borrwurra minypa gu-gurda ngacha gun-molamola gu-ni barra.” A-yinagata Jesus a-wena nula, a-marrkapchinga nula Wangarr. ");
INSERT INTO bvr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ganapiya, lika barrwa a-wena burrwa wurra gama gorlk, a-yinagata, “Ngun-anya nguna-wuna gun-bulapalawa. Gala ana-nga marn․gi nula an-guna An-walkurpa, wurra nipa wupa ngardapa Ngun-anya. Rrapa nipa Ngun-anya gala ana-nga marn․gi nula, wurra an-guna An-walkurpa rrapa barrwa ana-nga nipa a-borrwuja rrapa a-gurdagurdarraja. ");
INSERT INTO bvr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Nyiburr-gata nyiburr-maywapa minypa nyiburr-bamiya gun-gun․gun gun-guyinda rrapa nyiburr-werra nyiburr-nirra, buburr-boy gurda barra ngaypa arr-jalkaka, nyiburr-nyilja. ");
INSERT INTO bvr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Buburr-malcha apula ngaypa jama ngu-jirra, rrapa marn․gi buburr-nipa ngaypa nyanma. Gu-gurdiya ngacha minypa ana-goyburrpa nyiburr-ngurrnga nyiburr-nyilja barra. Ngardawa ngaypa ngu-ngurrnga ngu-dor, rrapa gala wana ngu-negiya ngu-workiya; ");
INSERT INTO bvr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","wurra minypa ngarripa wugupa jama arr-ji, gun-gata gun-mola gu-ni barra nggula minypa ngaypa gatiya barra wugupa nggula. ");
INSERT INTO bvr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Gun-gatiya lika Jarradi (Saturday) gu-ni, lika Jesus rrapa aburr-yigipa jawina marlgaway gu-jirrapa gatiya aburr-bamuna aburr-ni balaja mun-murra mu-jinyjarrapa minypa borichel, wurra mun-nerranga. Rrapa minypa Jesus burr-yika jawina aburr-werrmiyana balaja nula, lika mipila mu-jirra mun-gata mun-gubay birripa mbi-muluwurra, lika mbi-barra aburr-bamuna. ");
INSERT INTO bvr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Lika gun-gata waypa aburr-gata Berachi (Pharisee) yerrcha aburr-nyala burrbi-nana, lika birripa aburr-wena nula Jesus, “A-lay, aburr-gurda burr-na aburr-nginyipa jawina! Birripa gubu-rrumurra gun-ngayburrpa joborr! Wurra Jarradi gu-ni jimarn jarra gala jama aburr-jirrarna, wurpa niya balaja mbi-muluwujarna burr-guta.” ");
INSERT INTO bvr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Wurra Jesus a-yinanga burrwa, “Ana-goyburrpa gala mu-jurra nyibi-nacharna nyiburr-workiyarna, ya, minypa gun-gata janguny Daybit (David) gun-nika? Jarra ana-goyburrpa nyibi-nacha nyiburr-workiya, wurra gala meyali nyibu-borrwa. Minypa gun-gata wola Daybit rrapa aburr-yigipa gu-galiya yerrcha aburr-werrmiyana, ");
INSERT INTO bvr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","lika nipa a-bona, gu-bala a-barrngumurra Wangarr gun-nika gu-japurra, lika mu-menga mun-gata rakaraka mun-jimurdayan Wangarr mun-nika mbi-barnjinga nula aburr-workiya, mun-gata burr-guya mun-jimurdayan minypa aburr-gata wupa junggay yerrcha mbi-banga aburr-workiya. Wurra jarra an-gata Daybit mu-menga, lika nipa rrapa aburr-yigipa gu-galiya yerrcha mbi-barra aburr-ni. Gu-gurda ngacha. ");
INSERT INTO bvr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Rrapa barrwa junggay yerrcha gun-birripa janguny ana-goyburrpa gala mu-jurra nyibi-na nyiburr-workiya, ya? Jarra ana-goyburrpa nyibi-nacha nyiburr-workiya, wurra gala nyibu-borrwa meyali. Minypa Jarradi gu-nirra gu-workiya, junggay yerrcha aburr-gata Wangarr gun-nika bala aburr-nirra, birripa minypa Jarradi nula joborr gubu-rrumunga aburr-workiya minypa birripa jama aburr-jirra aburr-workiya wuriya Jarradi gu-nirra, gun-gata gun-japurra jimarna gala jama aburr-ji. Wurra gun-gata ngika minypa jimarn jarra birripa werra aburr-negiya aburr-ni, wurra gun-nyagara wupa. ");
INSERT INTO bvr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Rrapa ngaypa ngu-weya ana-gorrburrwa gun-burral: Ngaypa ng-gunaga wana ngu-bapala; gun-gata bala Wangarr gun-nika gun-narda marr gu-yinaga wana. ");
INSERT INTO bvr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Janguny mu-jurra gu-yurra minypa Wangarr a-wena, a-yinanga, ‘Ngaypa jal ngu-nirra jimarna ana-goyburrpa burr-guya nyiburr-mola nyiburr-nirrarna burrwa gu-galiya yerrcha, wurra ngaypa gala jal ngu-ni gun-gata minypa ana-goyburrpa ngunabu-wucha nyiburr-workiya minypa minyjak jin-guyinda nyibu-burnda nyiburr-workiya rrapa nyibi-yalpurda apula.’ Gu-yinagata gu-yurra janguny, rrapa gun-narda minyja ana-goyburrpa meyali nyibi-nachingarna, ana-goyburrpa gala nyiburr-yinmiyarna mari nyibu-garrajarna nyiburr-workiyarna burrwa gu-galiya yerrcha aburr-gata gala werra aburr-negiyarna. ");
INSERT INTO bvr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wurra an-guna An-walkurpa An-gugaliya nipa wana an-bapala Jarradi nula.” ");
INSERT INTO bvr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Gu-gatiya wenga Jesus mu-nguy ay-bamuna, a-barrngumurra gu-bala gun-gata Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Rrapa an-ngardapa an-gugaliya an-gata nipa murna a-jirra an-nerra. Rrapa gatiya aburr-werranga gu-galiya yerrcha aburr-ni, birripa jal aburr-ni mari gubu-garra barra nula Jesus. Gun-narda nula birripa lika aburr-garlmuna, abu-wengganana, “A-lay, gun-ngayburrpa joborr gu-yinmiya gu-yurra? Minyja Jarradi gu-nirra gu-workiya, gun-mola arrburrwa an-gugaliya ngubi-rrima barra a-molamiya, ya?” aburr-yinagata aburr-wena. ");
INSERT INTO bvr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Wurra Jesus a-yinanga a-wena burrwa, “Ny-jata ny-yinga minyja jip (sheep) n-dimanga, rrapa minypa Jarradi gu-ni jiny-bungga gu-rralala wuparnana, lika nginyipa ny-yinmiya barra? Wurra nginyipa n-dima barra, rrapa ny-jarrkarra, ngarla! ");
INSERT INTO bvr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Wurra jin-gata jip nipa Wangarr marr a-yinaga jal a-nirra achila; an-gugaliya jarra nipa Wangarr burr-guya jal a-nirra nula. Ganapiya, gun-mola arrburrwa an-gugaliya barra nguburr-gunggaja nula minypa Jarradi gu-nirra burr-guta.” ");
INSERT INTO bvr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Lika Jesus a-wena nula an-gata murna an-nerra, “Jerrjangardawiya ny-jata ny-yerra murna ny-jirra!” Lika nipa an-gugaliya a-jerrjangardawiyana murna a-jirra an-nerra, lika a-molamiyana gugu minypa an-gata an-nerranga murna a-jirra an-mola. ");
INSERT INTO bvr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Lika aburr-gata Berachi yerrcha aburr-bena yarlanga, lika aburr-bona, wengga gubu-buna aburr-ni minypa birripa abu-bu barra Jesus. ");
INSERT INTO bvr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Wurra gun-gata Jesus gu-nana burrwa minypa birripa jal aburr-ni abu-bu barra, lika gun-gata rrawa nipa gu-bawuna, lika a-bona. Rrapa aburr-jaranga wurra gama gorlk abu-jurrjurrmurra aburr-bamuna. Rrapa aburr-yorrpunapa nipa bin-dimarra, aburr-molamiyana, rrapa gala ana-nga a-ngukiyarna. ");
INSERT INTO bvr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Wurra nipa a-wena burrwa minypa birripa gala barra abu-ngurrja aburr-boy nipa ana-nga. ");
INSERT INTO bvr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jesus a-yinagata jama a-ji, ngardawa Wangarr mu-ngoyurra a-wena minypa an-gata Aycháya (Isaiah) gu-ngurrjinga Wangarr gun-nika, a-yinanga: ");
INSERT INTO bvr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“An-guna an-ngaypa an-mujama ngaypa ngu-jerrjerrjiyana nula; ngaypa jal ngu-nirra nula, ngu-japurramayana nula. Ngaypa ngu-jerrmiya barra nula ngaypa Ngu-mawunga, nipa Jentayl (Gentile) yerrcha gu-ngurrja barra burrwa minypa ngaypa jechinuwa nguburr-nega barra apula gu-gurdiya gu-rrawa. ");
INSERT INTO bvr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nipa gala barra ngarndarrk ngarndarrk aburr-negiya rrapa a-jabarrcha a-ji; gala barra wana a-negiya a-ni rrawa gu-jirra gu-boya, wurra gun-nyagara. ");
INSERT INTO bvr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Aburr-gata minypa gun-derta gubu-barripuna, nipa a-gunggaja barra burrwa, rrapa aburr-gata minypa gun-delipa marr aburr-balcharra aburr-nirra, nipa gala barra burr-dalaja rraka aburr-juwa. Ngika. Wurra nipa mu-nguy jama a-ji barra a-bamba, gu-mungba barra minypa rrawa gun-jechinuwa gu-ni barra. ");
INSERT INTO bvr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Lika gu-werranga gu-werranga gu-rrawa birripa marr aburr-balcha barra nula aburr-ni ngardawa nipiya an-nelangga.” ");
INSERT INTO bvr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Rrapa abu-ganyja gurda nula Jesus an-ngardapa an-gugaliya nipa an-gapula rrapa an-ngarlngarta; gala a-yinmiyarna a-weyarna a-workiyarna, wurra minypa nipa walkwalk a-rrimarra. Lika Jesus a-rrimarra an-gata, lika warrika nipa a-wena rrapa mun-barra a-ganana. ");
INSERT INTO bvr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Rrapa aburr-gata wurra gama gorlk gochila aburr-barrjinga gun-gata birripa gubi-nana minypa Jesus burr-barlmarrk jama a-ji. Aburr-wena, “An-guna waygaji Daybit murna a-wuna arrburrwa!” ");
INSERT INTO bvr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Wurra gun-narda birripa Berachi yerrcha aburr-galiyana, lika birripa wupa ngardapa aburr-wena, “Gun-narda ngika, a-la. Jarra wana an-babalapa walkwalk an-gata Biyíljabap (Beelzebub) nipiya nyanma ana-wuna ganyjarr, an-guna a-yerrnyjinga a-workiya walkwalk an-guyinda,” aburr-yinagata aburr-wena. ");
INSERT INTO bvr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Wurra Jesus gu-nana burrwa gun-gata birripa gubu-borrwurra, lika nipa a-wena burrwa, a-yinanga, “Gun-nga gun-gata rrawa wana, waygaji gun-delipa, minyja aburr-ngorrkorndiya rrapa aburr-bacha gu-gapa gu-guta, gun-narda minypa gun-gata rrawa gu-rrumiya barra gugu, gu-werrapa gu-ji barra. Rrapa aburr-nga aburr-gata aburr-yawyawga aburr-marmanyja aburr-barra, minyja birripa aburr-ngorrkorndiya, gun-narda minypa aburr-gata aburr-bapurr aburr-wulebiya barra. ");
INSERT INTO bvr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Rrapa an-gata walkwalk Jeytan (Satan) nipa a-yinagatiya. Minypa aburr-yigipa nipa burr-ganyja a-workiya minyja birripa aburr-ngorrkorndiyana rrapa aburr-bacha gu-gapa gu-guta, gun-narda minypa nipa walkwalk gala a-yinmiya mu-nguy a-ji. ");
INSERT INTO bvr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Wurra gun-gata minypa ngaypa ngu-yerrnyjinga ngu-workiya walkwalk an-guyinda, ana-goyburrpa nyiburr-wena, jimarna nyibu-borrwurra Biyíljabap nguna-wuna ganyjarr. Wurra gun-gata minypa aburr-goyburrpa jawina wolawola abi-yerrnyjinga aburr-workiya walkwalk, gun-narda gu-gaya wenga ganyjarr, ya? Wurra walkwalk gun-nika ngika. Wurra aburr-gata aburr-goyburrpa jawina yerrcha, birripa jarra yarlanga gubi-nenga minypa gun-gata ana-goyburrpa ngunabu-yopuna gun-narda gala gun-burral. ");
INSERT INTO bvr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Wurra Wangarr An-mawunga nipiya nyanma ngaypa ngu-yerrnyjinga ngu-workiya walkwalk an-guyinda, rrapa gun-narda minypa Wangarr gochila nyin-dana an-goyburrpa Bunggawa nipa an-guna gugu a-bena ana-gorrburrwa. ");
INSERT INTO bvr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Minyja bubu-borrwa meyali minypa gun-guna: Wana an-babalapa an-guyinda an-gugaliya gala ana-nga a-yinmiya gu-rruma gun-nigipa rrawa rrapa mun-ngumurda mu-ma nula, wurra minyja mu-ngoyurra a-bicha an-gata wana an-babalapa, gu-gatiya wenga lika mun-ngumurda mu-ma nula. ");
INSERT INTO bvr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ana-nga an-gata minyja gala an-mola apula, an-gata an-gugaliya nipa an-bachirra apula. Rrapa minyja ana-nga an-gata gala nguna-jurrjurrma rraka wugupa nyirrbu-ma nyirri-boy nuluwa Wangarr aburr-yigipa gu-galiya yerrcha, an-gata an-gugaliya nipa jarra minypa ganday burr-nenga ay-bamburda. ");
INSERT INTO bvr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ganapiya, wurra bubu-borrwa gun-guna: Wangarr nipa baywarra gu-nega barra burrwa gu-galiya yerrcha minypa gun-jaranga gun-nerra gun-guyinda birripa mu-ngoyurra jama aburr-ji rrapa gun-bachirra aburr-wena; wurra minyja ana-nga a-wengga rrapa an-nerra a-nega Mern An-mawunga, gu-gurda ngacha gun-nerra Wangarr gala a-yinmiya baywarra gu-nega nula an-gugaliya. ");
INSERT INTO bvr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Minyja ana-nga a-wengga rrapa an-nerra a-nega an-guna An-walkurpa An-gugaliya, gun-narda Wangarr baywarra gu-nega barra nula; wurra ana-nga a-wengga rrapa an-nerra a-nega Mern An-mawunga, an-gata an-gugaliya nipa Wangarr ana-nyala gala a-yinmiya baywarra gu-nega nula, minypa gun-guniya rrapa jurdach guna-bamburda burr-guta. ");
INSERT INTO bvr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Minypa gun-jong gun-gata balaja mu-rrimanga mu-workiya, minyja mun-molamola balaja mu-rrimanga, gun-narda minypa nipa gun-jong gun-molamola, wurra minyja gala balaja mun-molamola mu-rrima, gun-narda minypa nipa gun-jong gun-nerra. Minypa ngayburrpa marn․gi nula gun-jong gu-guyinmiya ngacha minypa mun-gata mu-guyinmiya ngacha balaja nipa mu-rrimanga mu-workiya. Wurra yama ana-goyburrpa ngu-molamola ngunabi-nega minypa ngaypa jama ngu-ji gun-molamola? ");
INSERT INTO bvr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Jarra ana-goyburrpa nyiburr-gurda minypa an-gata jarn․gich an-guyinda, ngarla! Minypa ana-goyburrpa gala nyiburr-yinmiya gun-molamola nyiburr-wengga; wurra nyiburr-werra. Ngardawa an-gugaliya gun-nga minypa wuparnana nipa an-ngurrnga gu-borrwuja a-workiya, gu-gata ngacha minypa nipa ngana a-jirra a-weya a-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Minypa an-gugaliya burr-jalkakaja a-workiya gu-galiya yerrcha minypa nipa an-ngurrnga gu-borrwuja a-workiya gun-molamola. Wurra an-gata minypa werra burr-nenga a-workiya, nipa ngardawa an-ngurrnga gu-borrwuja a-workiya gun-nerra. ");
INSERT INTO bvr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Buburr-galiya apula: Nuwurra waypa gu-balmapa gu-ji Wangarr barra burr-mari a-wengga, nipa a-wengga barra rrapa gu-galiya yerrcha aburr-ngurrjiya barra minypa birripa aburr-yinmiyana aburr-workiyana gun-nerra aburr-wena. ");
INSERT INTO bvr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ngardawa ny-yinga ny-jata nginyipa ny-yinmiya ny-yeya ny-yorkiya, gun-nardiya minypa nuwurra Wangarr a-wengga barra minypa nginyipa waygaji ny-molamola, waygaji ny-yerra.” ");
INSERT INTO bvr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Gu-gatiya wenga aburr-werranga aburr-gata joborr marn․gi aburr-gunega rrapa Berachi yerrcha, birripa aburr-wena nula Jesus, aburr-yinanga, “Bunggawa, ngayburrpa jal nyiburr-nirra bubi-na barra minypa nginyipa burr-ganyjarr jama ny-ji barra.” ");
INSERT INTO bvr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Wurra Jesus a-yinanga burrwa, “Ana-goyburrpa nyiburr-gurdiya gorlk burr-guya nyiburr-werra! Wangarr gala nyibu-borrwa nyiburr-workiya; jarra gun-guripa gun-guyinda nyibu-borrwuja nyiburr-workiya. Gu-gurda ngacha minypa ana-goyburrpa nyiburr-wena apula ganyjarr nula. Wurra Wangarr gala barra ganyjarr nyirr-gurdagurdarra ana-goyburrpa, wurpa lika gun-maywapa minypa gun-gata nipa jama a-ji nula Jona (Jonah) an-gata an-nigipa an-mujaruk. ");
INSERT INTO bvr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ngardawa minypa Jona a-ni abirri-jirrapa gun-ngardapa ngorrngurra gata wupa jichicha wana an-babalapa ana-gochila, nuwurra lika a-bena, gu-gurdiya ngacha minypa an-guna An-walkurpa An-gugaliya gu-jel wuparnana a-ni barra abirri-jirrapa gun-ngardapa ngorrngurra, nuwurra lika a-garlma barra. ");
INSERT INTO bvr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Minyja bubu-borrwa: Nuwurra waypa gun-balmapa gu-ji Wangarr barra burr-mari a-wengga, ana-goyburrpa nyiburr-jurnja barra. Ngardawa gatiya nipa burr-mari a-weya a-nirra, birripa Ninaba (Nineveh) aburr-guyinda gata aburr-ji barra rrapa yarlanga gubi-nega barra minypa ana-goyburrpa nyiburr-werra. Ngardawa birripa gun-nerra gubu-bawuna rrapa aburr-ngukurdanyjiyana, minypa birripa aburr-galiyana nula Jona nipiya Wangarr an-nika an-mujaruk a-wena burrwa. Wurra gun-burral ngaypa ng-gunaga wana; nipa Jona marr a-yinanga. Wurra wuriya. Wurra ana-goyburrpa gala marr nyiburr-balcha apula. ");
INSERT INTO bvr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Rrapa jin-gata wola bunggawa jinyu-ni gun-gata rrawa Jiba (Sheba), nipa nyanma burr-guta ana-goyburrpa nyiburr-jurnja barra gata minypa Wangarr burr-mari a-wengga. Ngardawa nipa gatiya jiny-ji barra rrapa yarlanga gu-nega barra minypa ana-goyburrpa nyiburr-werra. Ngardawa nipa jin-gata balay wenga jina-bona nula bunggawa an-gata an-nelangga Jolaman (Solomon), barra minypa nipa jiny-jaliya nula ngardawa nipa Jolaman gun-jaranga marn․gi a-ni. Wurra jarra gun-burral ngaypa ng-gunaga wana; nipa Jolaman marr a-yinanga. ");
INSERT INTO bvr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Minyja bubu-borrwa: Walkwalk an-gugaliya a-rrimanga, nipa wolawola ana-beya ana-workiya, lika a-bawuja a-boya, rrapa minypa gu-bugula gu-gorla ay-bamburda, a-wechawecharra ay-yinda barra a-ninya, wurra gala gun-molamola gu-barripa. ");
INSERT INTO bvr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ganapiya, lika ngardapa niya a-weya, a-yinaga a-workiya, ‘Ngaypa ngu-jeka barra gun-ngaypa rrawa.’ Lika ana-jeknga, gu-nacha, minypa nipa a-bawunapa an-gata an-gugaliya gala walkwalk a-rrima, wurra gipa gugu an-molamola. ");
INSERT INTO bvr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Lika gu-gata wenga nipa walkwalk a-boya a-workiya, rrapa minypa burr-mangga a-workiya aburr-werranga walkwalk yerrcha birripa burr-guya aburr-werra, nipa marr a-yinaga. Lika burr-ganyja gurda ay-ngunyuna aburr-gatiya minypa arr-ngardapa arr-murna rrapa abirri-jirrapa, minypa 7, lika wugupa aburr-barrngumiya nula ana-ngurrnga an-gata an-gugaliya. Lika aburr-nirra aburr-workiya gatiya, rrapa nipa an-gugaliya jarra mu-ngoyurra gun-nerra gu-ni nula, wurra barrwa gugu burr-guya gun-nerra gu-nirra nula. Rrapa gu-yirdiya barra gu-ni ana-gorrburrwa nyiburr-gurdiya gorlk burr-guya nyiburr-werra.” ");
INSERT INTO bvr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Gun-gatiya waypa Jesus a-wena burrwa a-ni wurra gama gorlk, jin-nigipa mampa niya rrapa aburr-yigipa worlapa niya yerrcha aburr-bona gurda, yarlanga aburr-jinyja, aburr-wena burrwa minypa birripa jal aburr-ni aburr-wengga barra nula Jesus. ");
INSERT INTO bvr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Lika an-ngardapa an-gugaliya a-wena nula Jesus, “A-lay, jin-nginyipa mampa nggu rrapa aburr-nginyipa worlapa nggu yerrcha birripa yarlanga aburr-jinyjarra; jal aburr-nirra aburr-wengga barra nggula.” ");
INSERT INTO bvr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Wurra Jesus a-yinanga nula, “Jin-ngay, aburr-ngay aburr-ngaypa worlapa apa yerrcha rrapa jin-ngaypa mampa apa?” ");
INSERT INTO bvr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Lika a-gurdagurdarrana an-gata an-gugaliya aburr-yigipa jawina yerrcha aburr-gata aburr-galiyana nula aburr-ni, lika a-yinagata nula, “Jarra aburr-gunaga aburr-ngaypa mampa ngapa yerrcha rrapa aburr-ngaypa worlapa ngapa yerrcha! ");
INSERT INTO bvr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Minyja borrwa: Aburr-nga aburr-gata jama aburr-jirra aburr-workiya minypa Ngun-anya waykin a-nirra jal a-nirra, aburr-gurda wupa minypa aburr-ngaypa worlapa apa yerrcha rrapa lamurrpa apa yerrcha rrapa jin-ngaypa mampa apa.” ");
INSERT INTO bvr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Gun-gata gun-maywapa ngorrngurra Jesus gu-bawuna a-bona rrawa, lika a-bona, bugula gu-rrarnba gatiya nipa a-rakaja. ");
INSERT INTO bvr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Rrapa wurra gama gorlk aburr-bamagutuwiyana nula gala aburr-ngardapa. Lika nipa a-gortkurrchinga mu-michiyang, lika a-rakaja mu-gochila, minypa aburr-gata wurra gama gorlk jiny-ji abirriny-ji, a-ji abirri-ji gu-rrarnba. ");
INSERT INTO bvr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Lika nipa meyali gu-murna a-wena burrwa a-ni, janguny gun-jaranga marn․gi burr-negarra a-ni. Minypa mu-ngoyurra gu-ngurrjinga burrwa minypa gun-guna: “An-ngardapa an-gugaliya a-lamajinga a-bona balaja nula, burraya mbi-ma. ");
INSERT INTO bvr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Minypa nipa mu-mulpuna, lika mipila mu-jirra mu-yerrnyjinga a-bona. Wurra mun-nerranga mun-gata m-bungguna gu-jarlakarr, lika burdacha jin-guyinda jina-bona, m-barra jinyu-ni, mu-wulebana. ");
INSERT INTO bvr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Rrapa mun-nerranga mun-gata mipila mu-jirra m-bungguna gu-mernarra gu-guyinda gatiya gun-delipa jel gu-yu. Lika gu-gata wenga gugu mun-jarlala m-bena, ngardawa gala jel wana gu-jirrarna. ");
INSERT INTO bvr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Wurra nuwurra waypa marnnga jina-bena, lika gugu mu-gorlapuna mun-gata mun-jarlala, ngardawa rrepara mu-jirra gala burr-guya wuparnana mu-ninya. ");
INSERT INTO bvr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Rrapa mun-nerranga mun-gata mipila mu-jirra m-bungguna ji-bornangguna ji-guyinda. Lika mun-jarlala m-bena, wurra jin-gata bornangguna wana jinyu-ni jiny-bamuna, jiny-jorlkakaja nula, rraka mun-gata nipa an-gugaliya a-lamajinga gala mu-yinmiyarna balaja mu-rrimangarna. ");
INSERT INTO bvr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Rrapa mun-nerranga mun-gata mipila mu-jirra m-bungguna mu-ji gu-molamola gu-jel. Lika gu-gata wenga mun-jarlala m-bena, lika wana mu-ni m-bamuna, balaja mu-rrimarra. Minypa mun-nerranga mun-bulapalawa mu-rrimarra, mun-nerranga marr mu-yinanga mun-jaranga, mun-nerranga marr mun-delipa. ");
INSERT INTO bvr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Gun-narda janguny, wurra ny-yinga ny-jata minyja gelama ny-jirra ny-jaliyana, borrwa ngaypa ngu-wena,” Jesus a-yinagata a-wena. ");
INSERT INTO bvr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Gu-gata wenga aburr-gata Jesus burr-yika jawina yerrcha aburr-bona gurda nula, lika abu-wengganana, “A-lay, an-nga nula wurra gama gorlk nginyipa ny-yeya burrwa ny-yorkiya meyali gu-murna?” ");
INSERT INTO bvr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Lika Jesus a-wena burrwa, “Ana-goyburrpa nipa Wangarr nyirr-menga barra marn․gi nyiburr-ni rrapa meyali nyibi-na gun-japurra gun-gata gun-nigipa rum waykin wenga. Wurra aburr-gata aburr-werranga birripa jarra nipa gala burr-gurdagurdarrajarna gu-gata ngacha. ");
INSERT INTO bvr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ngardawa ana-nga an-gata nipa minypa janguny gu-rrimanga Wangarr gun-nika, burraya Wangarr barrwa a-wu barra an-gata, lika nipa wana gu-rrima barra janguny. Wurra an-nerranga ana-nga nipa minypa gala Wangarr gun-nika janguny gu-rrima, burraya Wangarr a-garlmapa barra a-gaypa barra an-gata an-gugaliya gun-gata gun-delipa jimarn jarra nipa gu-rrimangarna a-nirrarna. ");
INSERT INTO bvr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Gu-gata ngacha minypa burr-meyali wupa ngaypa ngu-weya burrwa ngu-workiya aburr-gata wurra gama gorlk. Ngardawa birripa waykin gubi-nacha aburr-workiya, wurra gala wupa gubi-na. Minypa aburr-galiyarra aburr-workiya, wurpa lika gala burr-guya aburr-galiya; jarra gubu-morraja. ");
INSERT INTO bvr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Minypa Aycháya (Isaiah) mu-ngoyurra a-wena, aburr-gurdiya nipa burr-ngurrjinga, ngarla! Minypa nipa a-yinagata: ‘Ana-goyburrpa nyiburr-galiya barra nyiburr-workiya, wurra gala nyiburr-yinmiya marn․gi nyiburr-ni; nyibi-na barra nyiburr-workiya, wurra gala nyiburr-yinmiya nyibu-malawa.’ ");
INSERT INTO bvr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Minypa nipa Wangarr a-yinagata a-wena: ‘Ngardawa aburr-gurdiya gorlk birripa bama aburr-jirra aburr-werra. Minypa aburr-bongarramukchinga rrapa aburr-balamukchinga, gala yapa mun-barra aburr-gana rrapa gelama aburr-jirra aburr-galiya, gala yapa marn․gi aburr-ni rrapa aburr-ngukurdanyjiya apula rrapa ngaypa nguburr-jarlapa.’ ");
INSERT INTO bvr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Wurra ana-goyburrpa nyiburr-guna jarra mipila nyiburr-jirra Wangarr nyiburr-molamola nyirr-negarra, minypa ana-goyburrpa nyibi-nacha nyiburr-nirra; rrapa gelama nyiburr-jirra nyiburr-molamola nyirr-negarra, minypa nyiburr-galiyarra nyiburr-nirra. ");
INSERT INTO bvr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Minyjiya, ngarla! Aburr-jaranga aburr-gata mu-ngoyurra aburr-ni, minypa Wangarr burr-yika aburr-mujaruk ngunyuna aburr-guyinda rrapa aburr-werranga burr-guta Wangarr burr-yika gu-galiya yerrcha, birripa burr-guya jal aburr-ni, jimarn jarra gubi-nacharna gun-burral gu-beyarna burrwa gun-gata minypa ana-goyburrpa nyibi-nacha nyiburr-nirra rrapa nyiburr-galiyarra nyiburr-nirra, wurra gun-nyagara. ");
INSERT INTO bvr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Wurra buburr-galiya apula, rrapa marn․gi buburr-ni meyali gun-gata ngaypa ngu-wena an-gugaliya a-lamajinga a-bona balaja nula. ");
INSERT INTO bvr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wolawola an-gugaliya a-galiyarra a-workiya Wangarr gun-nika janguny, wurra gun-gata janguny nipa an-gugaliya gu-morraja, rrapa gu-gata wenga walkwalk an-gata Gun-nerra An-gurrimapa ana-yurtchingapa a-gaypurda an-gata an-gugaliya janguny gun-gata Wangarr a-wuna. Gu-gurda nula gun-burral minypa ngaypa ngu-wena mipila mu-jirra gu-jarlakarr m-bungguna, rrapa burdacha jin-guyinda m-barra jinyu-ni, mu-wulebana. ");
INSERT INTO bvr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Rrapa gun-gata ngaypa ngu-wena mipila mu-jirra m-bungguna gu-mernarra gu-guyinda gatiya gun-delipa jel gu-yu, wurra gun-burral minypa an-gugaliya a-galiyarra a-workiya Wangarr gun-nika janguny, lika warrika a-worlworlcharra rrapa marr a-balcharra. ");
INSERT INTO bvr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Wurra jarra minypa mun-gata mun-jarlala rrepara mu-jirra gala mu-yinmiyarna m-barrngumiyarna wuparnana, nipa an-gata an-gugaliya a-yinagatiya. Minypa marr a-balcharra a-boya gun-baykarda ngika, wurra a-bamburda, gun-derta gu-barripurda minypa mari gubu-garraja nula ngardawa gun-gata janguny nipa marr a-balcharra, lika gu-gata wenga gugu nipa gu-bawuja a-boya. ");
INSERT INTO bvr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Rrapa gun-gata ngaypa ngu-wena mipila mu-jirra m-bungguna ji-bornangguna ji-guyinda, wurra gun-burral minypa an-gugaliya a-galiyarra a-workiya Wangarr gun-nika janguny, wurra a-bamburda, gun-jaranga gu-borrwuja a-workiya gu-guna gu-yika gu-rrawa, rrapa minypa rrupiya rrapa gerra m-borrwuja, lika gu-gata wenga janguny gun-nyagara gugu gu-nirra nula an-gata an-gugaliya; jimarn jarra nipa jama a-jirrarna nula Wangarr, wurra gun-nyagara. ");
INSERT INTO bvr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Rrapa gun-gata ngaypa ngu-wena mipila mu-jirra m-bungguna gu-molamola gu-jel, wurra gun-burral minypa an-gugaliya a-galiyarra a-workiya Wangarr gun-nika janguny, lika gu-borrwuja a-bamburda rrapa jama a-jirra a-workiya Wangarr nipa nyanma. Minypa an-nerranga jama a-jirra wana gun-bapala, an-nerranga marr wana, an-nerranga marr gun-delipa.” ");
INSERT INTO bvr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Rrapa barrwa gun-nerranga meyali nipa Jesus a-wena burrwa, a-yinagata, “Rum gun-gata waykin wenga, gun-narda minypa gun-maywapa an-nerranga an-gugaliya a-lamajinga gun-nigipa rrawa. Minypa mu-yerrnyjinga a-bona mun-molamola mipila mu-jirra borichel. ");
INSERT INTO bvr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Wurra ana-munya gu-ni rrapa gu-yigipa gu-rrawa aburr-yu, lika an-gata an-gugaliya an-nigipa an-bachirra nula ana-bona, mipila mu-jirra mun-nerra a-lamajinga nula gu-maywapa; lika a-bona. ");
INSERT INTO bvr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Minypa mun-gata borichel m-bena m-bamuna rrapa balaja mu-rrimarra m-bamuna, wurra mun-nerra m-balagarrgurrjiyana. ");
INSERT INTO bvr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Lika an-gata rrawa an-gurrimapa, aburr-yigipa aburr-mujama aburr-bona gurda nula, aburr-yinanga nula, ‘A-lay, minyja nginyipa ny-yerrnyjinga ny-bona mun-molamola mipila mu-jirra, wurra gu-gaya wenga mun-gata mun-nerra m-balagarrgurrjiyana?’ ");
INSERT INTO bvr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Nipa a-yinanga burrwa, ‘Mun-narda an-bachirra jama a-ji, ngarla!’ “Lika aburr-yigipa aburr-mujama aburr-yinagata nula, ‘A-lay, jal nyi-nirra mun-gata mun-nerra ngayburrpa nyibu-wurrkaka barra rrapa nyibi-yerrnyja, ya?’ ");
INSERT INTO bvr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Wurra nipa a-yinagata burrwa, ‘Ngika. Gala yapa nyibu-wurrkakajin mun-gata burr-guta borichel. ");
INSERT INTO bvr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Wurra bubu-bawa. Mun-gata mun-nerra rrapa borichel wugupa barra wana mu-ni m-bamba, nuwurra borichel mu-molamiya. Lika ngaypa minypa ngu-wengga barra burrwa aburr-gata minypa borichel mbi-ma barra apula, ngu-yinda barra burrwa, “Mun-gata mun-nerra m-balagarrgurrjiyana ana-goyburrpa mu-ngoyurra bubu-wurrkaka, bubu-mulpa, bubu-bicha, burraya mu-rro barra. Rrapa mun-gata borichel mu-rrimanga bubu-gornda, lika bubu-ga, bubu-jolartcha apula gun-ngaypa rrawa.” ’” ");
INSERT INTO bvr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Rrapa barrwa gun-nerranga meyali Jesus a-wena burrwa gun-maywapa ranginy. A-yinagata, “Rum gun-gata waykin wenga, gun-narda minypa gun-maywapa an-gugaliya mu-menga minypa mipila mu-jirra mun-delipa mun-gata machart (mustard), lika a-lamajinga gun-nigipa rrawa. ");
INSERT INTO bvr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Minyja bubu-borrwa: Mun-gata mipila mu-jirra machart mun-delipa gun-nardiya rrawa; mun-nerranga marr mu-yinaga mun-delipa. Wurpa lika mun-jarlala m-beya m-bamburda, lika wana minypa gun-jong gu-beya gu-bamburda, lika aburr-jaranga burdacha aburr-guyinda aburr-boya gurda aburr-workiya, lika gubu-gapulawuja aburr-workiya ay-gatiya gu-birlapirla gu-guyinda. Gun-narda gun-maywapa, minypa gun-burral Wangarr burr-barlmarrk jama a-jirra burrwa aburr-yigipa gu-galiya yerrcha, rrapa minypa gu-yigipa gu-rrawa wana gugu gu-nirra gu-bamburda.” ");
INSERT INTO bvr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Rrapa barrwa gun-maywapa ranginy Jesus a-wena burrwa, a-yinagata, “Rum gun-gata waykin wenga, gun-narda minypa gun-maywapa gama jin-guyinda mu-mangga jiny-yorkiya mun-delipa mun-gurdurtcha barra gandichawa mu-rrima. Rrapa gu-gata wenga lika mun-jaranga mun-gata gandichawa minypa ana-ngardapa ana-duram mu-garlmiyapa mu-durtchinga m-bamburda mu-workiya.” ");
INSERT INTO bvr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus a-yinagata gun-jaranga a-wena burrwa a-workiyana meyali gu-murna. Minypa wurra gama gorlk nipa gala gun-nga gu-ngurrjingarna burrwa a-workiyarna, wurpa lika minypa burr-meyali a-wena burrwa. ");
INSERT INTO bvr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","A-yinagata a-workiyana minypa Wangarr mu-ngoyurra a-wena, an-nigipa an-mujaruk ngunyuna an-guyinda gu-ngurrjinga, a-yinanga, “Ngaypa burr-meyali ngu-wengga barra burrwa, ngu-ngurrja barra burrwa janguny gu-yilkakiyana gu-yu gu-workiyana. Minypa mu-ngoyurra Wangarr gu-jarlapuna gun-nardiya rrawa rrapa barrwa guna-bamuna, gun-gata minypa gun-guna janguny gu-yilkakiyana gu-yu gu-workiyana.” ");
INSERT INTO bvr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Gun-gatiya waypa Jesus burr-bawuna a-bona aburr-gata wurra gama gorlk rrapa a-barrngumurra wupa, lika aburr-yigipa jawina yerrcha aburr-bona gurda nula. Lika aburr-yinanga nula, “A-lay, wengga arrburrwa gun-nga meyali gun-gata geka ny-yena minypa mipila mu-jirra mu-yerrnyjinga a-bona, barrwa balaja mun-murra mu-jinyja, wurra mun-nerra m-balagarrgurrjiyana gatiya.” ");
INSERT INTO bvr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Lika nipa gu-ngurrjinga burrwa, a-yinanga, “Gun-gata ngaypa ngu-wena an-gugaliya a-lamajinga minypa mun-molamola mipila mu-jirra mu-yerrnyjinga a-bona, nipa an-gata minypa gun-burral an-guna An-walkurpa An-gugaliya. ");
INSERT INTO bvr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Rrapa gun-gata ngu-wena gatni (garden) nipa a-lamajinga, wurra gun-burral jarra gun-nardiya rrawa gu-jirra gu-boya. Rrapa mun-gata mun-molamola mipila mu-jirra, mun-narda minypa gun-burral Wangarr burr-yika walkurpa yerrcha. Rrapa mun-gata mun-nerra m-balagarrgurrjiyana m-bena m-bamuna, mun-narda minypa gun-burral aburr-yigipa walkurpa yerrcha an-gata Gun-nerra An-gurrimapa Walkwalk. ");
INSERT INTO bvr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Rrapa gun-gata ngaypa ngu-wena minypa an-bachirra gatiya a-lamajinga mun-nerra mun-guyinda, wurra gun-burral nipa an-gata walkwalk. Rrapa gun-gata ngu-wena birripa mbi-ma barra nula bunggawa mun-gata balaja mu-molamiyana, gun-narda minypa gun-burral gun-gata jurdach guna-bamburda. Rrapa aburr-gata aburr-mujama mbi-ma barra, birripa minypa gun-burral waykin aburr-guyinda aburr-mujaruk aburr-bupiya barra gurda. ");
INSERT INTO bvr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Rrapa gun-gata ngaypa ngu-wena minypa mun-nerra mun-guyinda mbi-ma barra, gu-bol mu-rro barra, gu-yirdiya barra gu-ni jurdach guna-bamburda. ");
INSERT INTO bvr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Minypa an-guna An-walkurpa An-gugaliya burr-jerrma barra aburr-yigipa waykin aburr-guyinda aburr-mujaruk, birripa aburr-boy barra aburr-yigipa gu-galiya yerrcha aburr-nirra, lika burrbi-rrima barra aburr-boy aburr-werranga aburr-gata aburr-balagarrgurrjiyana burrwa, aburr-gatiya minypa gun-guwarga gubi-rrimanga burrwa wurra gama gorlk, rrapa barrwa aburr-jaranga minypa gun-nerra jama aburr-jirra aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Burrbi-rrima barra aburr-boy, ganapiya, lika burrbi-yerrnyja barra gu-bol gu-rrongga gu-jirra gu-workiya, gatiya minypa burr-guya aburr-rruwuja barra rrapa rrirra gubu-bay. ");
INSERT INTO bvr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Lika gu-gata wenga Wangarr burr-yika gu-galiya yerrcha aburr-gatiya nipa burr-nacha minypa jechinuwa aburr-nirra nula aburr-workiya, birripa aburr-jayanaya barra aburr-ji gata Nyanyapa burra ana-murna. Minypa jin-maywapa ranginy marnnga jin-gata jina-darrjinga jina-workiya, gu-nguparr gu-gorlkakaja, barrwa jiny-beya. Ganapiya, wurra ny-yinga ny-jata minyja gelama ny-jirra ny-jaliyana, borrwa ngaypa ngu-wena. ");
INSERT INTO bvr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Rum gun-gata waykin wenga, gun-narda minypa gun-maywapa an-gugaliya a-bamuna, gun-molamola gu-barripuna, gun-gumarrkapcha gu-gata gu-yika gu-rrawa gu-yilkakiyana gu-yu gu-jel. Minypa nipa barrwa gu-yilkakaja gu-maywapa, lika a-worlworlchinga a-bamuna, a-bona, jalim a-ni gun-nga gun-jaranga nipa gu-rrimarra, lika ana-bona, bayim a-ni gun-gata rrawa. Minypa gun-burral an-gugaliya gu-bawa barra mu-ngoyurra gu-rrimarra, barra minypa Wangarr ana-murna a-ni. ");
INSERT INTO bvr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Rrapa barrwa gun-nerranga meyali gun-maywapa ranginy: Rum gun-gata waykin wenga, gun-narda minypa gun-maywapa an-gugaliya a-wechawecharra an-molamola gu-lawu an-guyinda. ");
INSERT INTO bvr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Rrapa minypa nipa a-barripuna an-ngardapa burr-guya an-molamola, minypa rrupiya wana nula. Lika nipa a-bona, jalim a-ni gun-nga burr-guta nipa gu-rrimarra, lika ana-bona, bayim a-ni an-gata gu-lawu. ");
INSERT INTO bvr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Rum gun-gata waykin wenga, gun-narda minypa mola barrwa gun-maywapa ranginy gu-galiya yerrcha mbi-rurrgakaja aburr-workiya mulucha rrapa jichicha an-guyinda an-nerranga an-nerranga a-gartchinga a-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lika nuwurra waypa gu-ngana a-maya, birripa mbi-rurrgakaja gurda ana-jaranga, lika abu-ngorrkorndanga aburr-boya jichicha. Minypa an-molamola an-guyinda abu-mangga aburr-workiya, abu-barnjinga ana-duram, wurra an-nerra an-guyinda abi-yerrnyjinga aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Gu-yirda barra minypa jurdach guna-bamburda. Minypa waykin aburr-guyinda aburr-mujaruk aburr-boy barra aburr-molamola gu-galiya yerrcha aburr-nirra, lika burrbi-rrima barra aburr-werra gu-galiya yerrcha aburr-balagarrgurrjiyana burrwa, ");
INSERT INTO bvr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","lika burrbu-ga barra, burrbi-yerrnyja barra gu-bol gu-rrongga gu-jirra gu-workiya, gatiya minypa burr-guya aburr-rruwuja barra rrapa rrirra gubu-bay.” ");
INSERT INTO bvr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Lika Jesus burr-wengganana aburr-gata, a-yinagata burrwa, “Geka ngu-wena ana-gorrburrwa ngu-ni gun-jaranga, wurra ana-goyburrpa gipa marn․gi nyiburr-ni, ya?” Birripa aburr-yinanga nula, “Ngaw.” ");
INSERT INTO bvr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Lika nipa a-yinagata burrwa, “Aburr-gata joborr marn․gi aburr-gunega, an-gatiya ana-nga marn․gi a-ni ngaypa ngu-weya ngu-workiya, nipa minypa an-gata bala an-gurrimapa. Minypa nipa muna-ganyja gurda yarlanga mun-molamola mun-guyinda, minypa mun-geka mun-maywa mun-nga minypa wurra gama gorlk jal aburr-nirra. Gu-gurda ngacha minypa joborr marn․gi an-gunega minyja nipa marn․gi a-ni gun-ngaypa janguny, nipa a-gunggaja barra burrwa a-workiya wurra gama gorlk, minypa gu-geka gu-maywa.” ");
INSERT INTO bvr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Gun-gatiya waypa Jesus gu-mungbuna nipa a-wena burrwa a-ni minypa meyali gu-murna, lika nipa gu-bawuna gun-gata rrawa, ");
INSERT INTO bvr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","lika a-jekarra gu-yigipa gu-rrawa. Lika a-bona, a-barrngumurra gu-bala Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya. Lika gatiya wenga nipa a-wena burrwa a-ni rrapa birripa minypa aburr-galiyana nula, lika gochila aburr-barrjinga nula. Minypa aburr-wengganachichiyana aburr-ni, aburr-yinanga, “An-guna yina gaya wenga marn․gi a-ni gun-guna gun-jaranga nipa a-weya a-workiya? Rrapa nipa burr-barlmarrk jama a-jirra a-workiya, gun-nga gun-gata ganyjarr? ");
INSERT INTO bvr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Minyja nipa an-walkurpa nula an-gata gapunda (carpenter), rrapa jin-nigipa mampa niya jin-gata Meri (Mary), rrapa aburr-yigipa worlapa niya yerrcha aburr-gata Jeymch (James), Jochap (Joseph), Jayman (Simon), rrapa Jurrach (Judas), ya? ");
INSERT INTO bvr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Rrapa jelapa niya yerrcha minyja birripa aburr-guniya. Minyjiya, ngarla, nipa ngunyuna an-guyinda. Wurra gu-gaya wenga nipa gu-menga gun-gata janguny?” ");
INSERT INTO bvr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Aburr-yinagata aburr-wena, lika birripa ngoyurra aburr-yerryerrmiyana nula Jesus. Wurra nipa a-yinanga a-wena burrwa, “Ana-nga an-gugaliya an-gata Wangarr an-nika an-mujaruk, nipa wurra gama gorlk marr abirriny-balcharra nula abirriny-yorkiya, wurpa lika gu-yigipiya gu-rrawa ngika, rrapa ngika aburr-yigipa aburr-bapurr.” ");
INSERT INTO bvr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nipa Jesus a-yinagata a-wena burrwa, rrapa gala ana-jaranga ana-goma gu-nengarna nipa burr-barlmarrk jama a-ji gun-gata rrawa, wurra birripa gala marr aburr-balcharrarna nula nipa. ");
INSERT INTO bvr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Lika bunggawa gu-gata a-yika gu-rrawa Galali (Galilee) an-gata an-nelangga Ayrat (Herod), nipa a-galiyana janguny gu-barrjekarra nula Jesus. ");
INSERT INTO bvr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Lika nipa Ayrat a-wena burrwa aburr-yigipa aburr-mujama, a-yinanga burrwa, “An-guna an-gugaliya nipiya an-gata Jon bama burr-gurragaja a-workiyana, a-juwuna, wurra minypa gun-gujuwa gu-beybana, ana-jekarra gugu. Gu-gurdiya ngacha minypa nipa an-guna burr-barlmarrk jama a-jirra a-workiya.” ");
INSERT INTO bvr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ayrat a-yinagata a-wena minypa nipa a-gurkuja. Ngardawa gipa mu-ngoyurra nipa a-wena burrwa aburr-yigipa aburr-mujama Jon abi-rrimarra, abu-bichinga, abu-jolartchinga wupa. Ngardawa jin-gata nyanma Yirórriyach (Herodias), jin-gatiya jin-gumarrbipa niya Bilip (Philip) an-gata Ayrat an-nika worlapa niya. ");
INSERT INTO bvr_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ngardawa Jon a-wena nula a-workiyana Ayrat, a-yinagata nula, “Gun-narda gala gun-mola nginyipa n-dimanga jin-guna Yirórriyach nipa Bilip jin-nika jin-gumarrbipa niya.” ");
INSERT INTO bvr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Gu-gurdiya nula nipa Ayrat jal a-ni a-bu barra Jon; wurra a-gurkuja burrwa wurra gama gorlk, ngardawa birripa abu-borrwurra Jon minypa nipa Wangarr an-nika an-mujaruk. ");
INSERT INTO bvr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Wurra gu-bamuna, lika janara gu-ji Ayrat gu-garrana. Minypa nipa gu-borrwurra a-ni gun-jaranga jemberr gu-ni nula minypa a-bambunggunapa, rrapa gun-narda nula nipa rrapa aburr-borrmunga nula gu-ngardapa aburr-negiyana, aburr-worlworlcha aburr-ni. Lika gatiya gugu Yirórriyach jin-nika mu-lopa acha jina-bona, jiny-yalagiyana burrwa. Lika nipa Ayrat burr-guya a-japurramayana achila, ");
INSERT INTO bvr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","lika burr-guya a-wena, gochila jin-dana minypa nipa jiny-yu barra gun-nga minypa nipa jiny-yengga barra. ");
INSERT INTO bvr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Lika jin-gata jin-nigipa mampa acha gu-weng ngana jiny-yuna, lika jina-bona, jiny-yena, “Nguna-wu an-ngartpelambila japalana ana-guyinda Jon bama a-jirra, an-gatiya bama burr-gurragaja a-workiya.” ");
INSERT INTO bvr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Lika an-gata bunggawa, nipa wargugu a-ni, wurra gala a-yinmiyarna gu-rrumungarna gun-gata nipa gochila jin-dana; wurra aburr-gata aburr-borrmunga nula gipa aburr-galiyana nula nipa burr-guya a-wena. Ganapiya, wurra nipa a-wena burrwa aburr-mujama barra birripa jibu-wu barra minypa nipa jiny-yena. ");
INSERT INTO bvr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Minypa nipa burr-jerrmarra, gatiya nipa Jon wupa a-ninya birripa abi-jaygorndanga, ");
INSERT INTO bvr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","bama a-jirra abu-menga, lika abu-ganyja gurda an-ngartpelambila japalana ana-guyinda. Lika jibu-wuna jin-gata jin-ngamangama, lika nipa ana-ganyja, jiny-yuna jin-nigipa mampa acha. ");
INSERT INTO bvr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Rrapa Jon burr-yika jawina aburr-bona gurda, abu-menga nipa a-juwuna, lika abu-ganyja, abu-jurnumbuna aburr-ni. Lika aburr-bona, aburr-wena nula Jesus minypa bapurr gu-yu. ");
INSERT INTO bvr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Gun-gatiya waypa Jesus a-galiyana Jon a-juwuna, lika nipa mu-michiyang a-gortkurrchinga, a-bona gu-werrapa, jimarn jarra ngardapa a-nirrarna rrapa a-wengganacharna Wangarr. Wurra rrawa gu-jirra gu-boya aburr-galiyana nipa ay-yinda a-bona, lika birripa aburr-gomarriyana aburr-bamuna gu-rrepara, mu-ngoyurra aburr-bena, ");
INSERT INTO bvr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","nipa nuwurra jurdach. Rrapa nipa waypa a-gortkurrchinga gu-rrarnba, nipa burr-nana wurra gama gorlk aburr-gata gala aburr-ngardapa, lika a-worijinga burrwa. Lika aburr-gurderdakurderda bin-dimarra burrwa a-bona. ");
INSERT INTO bvr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Lika nuwurra balngga gu-ni, lika Jesus burr-yika jawina yi-gurrepa aburr-negiyana nula, aburr-yinanga nula, “A-lay, gipa mu-ngoyurra balngga gu-ni, wurra ngayburrpa gu-werrapa nguburr-nirra. Ngaw minyja barra nginyipa burr-jerrma aburr-guna wurra gama gorlk, minypa birripa aburr-boy, rrawa gu-jirra gu-boya mbi-ma balaja mbi-bay?” ");
INSERT INTO bvr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Wurra Jesus a-yinanga burrwa, “Ngika barra aburr-boy. Wurra jarra ana-goyburrpa nyirrbu-wu barra mbi-bay.” ");
INSERT INTO bvr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Birripa aburr-yinagata, “Ngika, wurra mun-delipa nyibi-rrimanga, minypa rakaraka mun-delipa mun-guyinda arr-ngardapa arr-murna, minypa 5, rrapa abirri-jirrapa wupa an-delipa jichicha.” ");
INSERT INTO bvr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Wurra Jesus a-wena burrwa, “Bubu-ga gurda.” ");
INSERT INTO bvr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Lika nipa a-wena rrapa wurra gama gorlk aburr-rakaja. Lika nipa mu-menga mun-gata rakaraka arr-ngardapa arr-murna rrapa an-gata abirri-jirrapa jichicha, lika waykin a-ganana, a-japurramayana nula Wangarr. Ganapiya, lika rakaraka mu-rrumurra, lika burr-wuna aburr-yigipa jawina, birripa burrbu-wuna aburr-bona wurra gama gorlk, rrapa jichicha burr-guta. ");
INSERT INTO bvr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Minypa aburr-bulapalawa aburr-gata mbi-barra, aburr-durtchinga. Rrapa mun-nerranga mu-ngukiyana Jesus burr-yika jawina mbi-menga, wana burlupurr gu-guyinda mbi-jolartchinga, gu-ngana mu-mayana gun-gata minypa arr-jirrapa arr-murna rrapa abirri-jirrapa, minypa 12. ");
INSERT INTO bvr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Gun-narda janguny minypa aburr-gata wurra gama gorlk mbi-barra; wurpa lika mu-wurra yerrcha wupa aburr-gatiya 5,000. ");
INSERT INTO bvr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Gu-gatiya wenga Jesus a-wena burrwa aburr-yigipa jawina birripa mu-michiyang aburr-gortkurrchinga, mu-ngoyurra aburr-bona gu-gapa gu-rrarnba, minypa nipa burdak Jesus burr-jerrmarra a-ni wurra gama gorlk rrawa. ");
INSERT INTO bvr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Burr-jerrmarra a-bona, ganapiya, lika nipa a-warrchinga a-bamuna gu-bulgapulga gu-guyinda barra ngardapa a-ni rrapa a-wenggana. Ana-munya gu-ni, nipa gatiya ngardapa niya, ");
INSERT INTO bvr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","rrapa aburr-yigipa jawina gatiya gojilapa aburr-jurrwurra aburr-bamuna, rrapa michiyang gu-bartpa m-buna burrwa gu-ni, rrapa barlmarrk mirrka derta burr-negarra gu-ni. ");
INSERT INTO bvr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Gu-gatiya wenga gugu ngana guna-ngarlcha guna-bamuna Jesus ana-bona burrwa, gu-bugula gu-jonama ana-jarl ana-bamuna. ");
INSERT INTO bvr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wurra gun-gatiya waypa aburr-yigipa jawina abi-nana gu-bugula waykin ana-bamuna, birripa aburr-gurkuja aburr-ni burr-guya. Aburr-gonyjinga, aburr-yinanga, “Waw! An-gata walkwalk!” ");
INSERT INTO bvr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Wurra warrika waya nipa ana-wena burrwa, “Nyiburr-molamola buburr-ni. Ngaypa, ngarla! Ganapa buburr-gurkuja.” ");
INSERT INTO bvr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Wurra Birta a-yinanga nula, “Bunggawa, minyja ny-jurda nginyipa, wengga apula barra ngaypa gu-bugula waykin ngiy-bamba, ngu-bengga nggula.” ");
INSERT INTO bvr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesus a-yinagata nula, “Guwa.” Lika Birta a-gortkurrchinga, lika gu-bugula waykin a-jarlabiyana a-bona nula Jesus. ");
INSERT INTO bvr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Wurra gu-gata wenga nipa gu-borrwurra gun-gata barlmarrk wana gu-bena, lika a-gurkuja, rrapa a-guybunapa a-bamuna, a-gonyjinga, “Bunggawa! Gunggaja apula!” ");
INSERT INTO bvr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Warrika waya Jesus a-merndagarlmuna, a-rrimarra. A-yinagata nula, “Ny-junarda marr ny-balchinga apula, an-nga nula ny-jekarra?” ");
INSERT INTO bvr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Lika gatiya waypa abirri-gortkurrchinga mu-michiyang, nipa barlmarrk gu-derichinga. ");
INSERT INTO bvr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Lika aburr-gatiya mu-michiyang mu-gochila aburr-marrngoypiyana nula Jesus, minypa aburr-yinanga nula, “Gun-burral nginyipa Wangarr biy-yika Walkur.” ");
INSERT INTO bvr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ganapiya, lika gu-gata wenga birripa aburr-bena gu-gapa gu-rrarnba rrawa gun-gata gun-nelangga Ganécharat (Gennesaret). ");
INSERT INTO bvr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Rrapa gu-galiya yerrcha gu-gata burr-yika gu-rrawa, birripa waypa abu-malawurra Jesus, burrbi-jerrmarra rrawa gu-jirra gu-boya, burrbu-ganyja gurda nula aburr-gurderdakurderda yerrcha, ");
INSERT INTO bvr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","lika aburr-ngiwija nula minyja aburr-gurderdakurderda birripa mbi-rrima murna mu-jirra mun-nigipa mirikal. Ganapiya, lika aburr-yinmiyapa aburr-gata mbi-rrimarra, aburr-bulapalawa aburr-molamiyana. ");
INSERT INTO bvr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Gun-gatiya lika aburr-werranga aburr-gata Berachi (Pharisee) yerrcha rrapa joborr marn․gi aburr-gunega, birripa Jirúchalam (Jerusalem) wenga aburr-bona gurda nula Jesus. Lika abu-wengganana, ");
INSERT INTO bvr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“A-lay, an-nga nula aburr-nginyipa jawina gubu-rrumurra gun-ngayburrpa gun-guwarr aburr-ngayburrpa mu-ngoyurra aburr-guyinda arrbu-wuna? Wurra yama murna aburr-jirra aburr-wepiya aburr-workiya, lika nuwurra jurdach mbi-bay?” ");
INSERT INTO bvr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesus a-yinanga burrwa, “Wurra ana-goyburrpa, an-nga nula nyibu-borrwuja nyiburr-workiya gu-gata ngacha gun-guwarr, wurra minypa ana-goyburrpa nyibu-beybarda nyiburr-workiya joborr gun-gata Wangarr gu-barnjinga? ");
INSERT INTO bvr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Minypa an-gata nipa Wangarr a-wena, ‘Marr balcha burrinyjula nyanyapa nggu rrapa mampa nggu,’ rrapa barrwa a-yinagata a-wena, ‘Ana-nga minyja an-nerra a-nega nyanyapa niya, rrapa mampa niya jin-nerra jinyu-nega, an-gata an-gugaliya ana-goyburrpa barra nyibu-bu barra a-juwa.’ ");
INSERT INTO bvr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","A-yinagata nipa Wangarr a-wena, wurra ana-goyburrpa jarra nyiburr-weya nyiburr-workiya jimarna ana-nga an-gata gu-rrimanga gun-nga gun-gata barra bijirriny-borrwa nyanyapa niya rrapa mampa niya, wurra jarra gun-mola minyja nipa a-yinda a-wengga burrinyjula, ‘Ngika. Gun-guna gun-japurra; gipa mu-ngoyurra ngu-wuna Wangarr gun-nigipa.’ ");
INSERT INTO bvr_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Gu-gurda ngacha minypa ana-goyburrpa nyiburr-weya nyiburr-workiya, jimarna nyibu-borrwuja gun-mola nula an-gata an-gugaliya minypa nipa gala bijirriny-yu nyanyapa niya rrapa mampa niya. Wurra gun-narda minypa ana-goyburrpa nyibu-morrarna wengga gun-gata Wangarr gu-barnjinga, wurra gun-goyburrpa wupa gun-guwarr gun-guyinda jarra nyibu-borrwuja nyiburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Minyjiya! Ana-goyburrpa waykin nyiburr-molamola; wupa nyiburr-werra! Gun-gata wola an-gata Aycháya (Isaiah) a-wena Wangarr gun-nika, gun-narda gun-burral. Minypa nipa mu-ngoyurra nyirr-ngurrjinga ana-goyburrpa, nipa a-yinanga, ");
INSERT INTO bvr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Aburr-guna gu-galiya yerrcha ngana aburr-jirra wupa aburr-weya aburr-workiya, jimarna marr aburr-balcharra apula; wurra jarra wuparnana aburr-ngurrnga balaypalay aburr-nirra apula. ");
INSERT INTO bvr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Birripa borijipa aburr-japarndiya apula aburr-workiya. Ngardawa marn․gi aburr-negiya aburr-workiya ana-gugaliya gun-nika wupa joborr.’” ");
INSERT INTO bvr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Gu-gata wenga Jesus a-gonyjinga burrwa wurra gama gorlk yi-gurrepa aburr-negiyana nula, lika a-yinanga burrwa, “Buburr-galiya apula barra marn․gi nyiburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Gun-gata gun-nga gun-nerra an-gugaliya ana-ngana gu-barrngumiya gu-workiya minypa nipa balaja m-banga a-nirra, gun-narda gala gu-yinmiya an-nerra a-nega an-gata an-gugaliya nuluwa Wangarr. Ngika. Wurra jarra gun-gata minypa ana-ngana gu-beya gu-workiya, nipa a-weya a-workiya, gu-gurda ngacha minypa nipa werra a-negiya nula Wangarr.” ");
INSERT INTO bvr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Lika Jesus burr-yika jawina aburr-bona gurda nula, aburr-yinanga nula, “A-lay, nginyipa gipa ny-borrwurra, ya, minypa aburr-gata Berachi yerrcha gochila aburr-rronga nggula gun-gata nginyipa ny-yena?” ");
INSERT INTO bvr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Lika nipa Jesus a-wena burrwa gun-maywapa ranginy, a-yinanga, “Mun-nga mun-gata minypa Ngun-anya waykin a-nirra gala a-lamajingarna, wurra jarra ana-werranga nyanma, mu-gurda ngacha burraya Ngun-anya mu-wurrkaka barra. ");
INSERT INTO bvr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Gala barra nyirrbu-borrwa aburr-gata Berachi yerrcha. Birripa gala gubu-borrwa minypa birripa aburr-gapula, wurra bama aburr-yinaga aburr-gata jimarna barra jarlakarr burrbu-gurdagurdarra wurra gama gorlk. Wurra minyja an-gapula an-guyinda an-ngardapa murla mu-rrima nula an-nerranga, bitipa abirri-bamba barra, mu-gochila wugupa abirri-bungga.” ");
INSERT INTO bvr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nipa Birta a-wena, “A-lay, gun-gata nginyipa ny-yena burrwa Berachi yerrcha gun-maywapa ranginy, wengga arrburrwa gun-nga meyali.” ");
INSERT INTO bvr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesus a-yinagata burrwa, “Awa! Nyiburr-gurda burr-guta gala burr-guya marn․gi nyiburr-ni, ya? ");
INSERT INTO bvr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Wurra yama nyibu-borrwa mun-gata mun-nga minypa an-gugaliya m-banga a-workiya mun-narda m-boya mu-workiya ana-gochila, rrapa barrwa minypa yarlanga m-beya. ");
INSERT INTO bvr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Wurra gun-gata ana-ngana gu-beya gu-workiya minypa an-gugaliya a-weya a-workiya, gun-narda minypa nipa nyanma ana-ngurrnga, rrapa gu-gurdiya ngacha minypa an-gugaliya werra a-negiya a-workiya nuluwa Wangarr. ");
INSERT INTO bvr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ngardawa ana-ngurrnga wenga nipa an-gugaliya gu-borrwuja a-workiya gun-nerra. Gu-gatiya wenga minypa burr-burnda a-workiya, rrapa minypa jiny-mangga a-workiya ana-werranga jin-nika, rrapa gun-jaranga gu-gurda ngacha gun-nerra jama a-jirra a-workiya; rrapa minypa mun-ngumurda mu-mangga a-workiya, rrapa bima burr-ngurrjinga a-workiya, rrapa burr-yopurda a-workiya burr-guta. ");
INSERT INTO bvr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gu-gurdiya ngacha gu-werra an-gugaliya werra a-nenga gu-workiya; jarra gun-gata minypa an-gugaliya balaja m-banga gala mu-ngoyurra a-wepiyarna murna a-jirra, gu-gurda ngacha gala gu-yinmiya an-nerra a-nega an-gata an-gugaliya nuluwa Wangarr.” ");
INSERT INTO bvr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Gu-gata wenga Jesus gu-bawuna gun-gata rrawa, a-bona, gu-jarlakarr a-bamuna, a-bena gun-gata rrawa gu-jirra gu-boya gun-nelangga Daya (Tyre) rrapa Jaydan (Sidon). ");
INSERT INTO bvr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Lika gatiya jin-ngardapa gama jiny-bena nula Jesus, nipa jin-gata Geynan (Canaan) jin-guyinda. Lika jiny-jonyjinga nula, “Bunggawa, a-lay, gunggaja apula! Ny-jurda nipa Daybit (David) murna biy-wuna arrburrwa, gunggaja apula! Ngardawa jin-ngaypa delipa walkwalk a-rrimanga, nipa jiny-burnda a-workiya, nipa jin-nerra jinyu-nirra, burr-guya jin-nerra jinyu-nirra jiny-yorkiya.” ");
INSERT INTO bvr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nipa jiny-yinagata, wurra Jesus gala a-weyarna achila, wurra gun-nyagara. Lika Jesus burr-yika jawina birripa yi-gurrepa aburr-negiyana nula, aburr-ngiwija nula, “A-lay, japurra ngapa ny-jirra, ngaw minyja jin-gata ny-jerrma, jiny-jeka barra. Ngardawa ngurrpiny jiny-jonyjinga, arr-bitimanga jinyu-nirra.” ");
INSERT INTO bvr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesus a-yinanga, “Ngaw, Wangarr nguna-jerrmarra ana-gorrburrwa Yichrayal (Israel) nyiburr-bapurr nyiburr-gurdiya wupa. Minyja ana-goyburrpa minypa gun-maywapa ranginy jin-gumurna jip jinyu-lijiwarriyana.” ");
INSERT INTO bvr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Wurra jin-gata Geynan jin-guyinda jina-bona, ji-menama gu-rrana nula Jesus, jiny-yinagata nula, “Bunggawa, gunggaja apula!” ");
INSERT INTO bvr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Lika nipa gun-maywapa ranginy a-wena achila, a-yinanga, “Ngika. Wurra gu-gurda ngacha gala gu-yu, rraka gu-ngarda yerrcha mun-birripa balaja an-gugaliya burr-gaypa rrapa a-wu gulukula, ngaja.” Nipa a-yinagata Jesus a-wena achila, minypa meyali gu-murna. ");
INSERT INTO bvr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Rrapa nipa jiny-yinagatiya meyali gu-murna jiny-yena nula Jesus, “Ngaw, Bunggawa. Wurpa lika gulukula an-guyinda m-banga a-workiya mun-jinachina m-bunggiya mu-workiya, an-gurrimapa m-banga a-nirra.” ");
INSERT INTO bvr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Lika Jesus a-yinagata achila, “A-jay, ny-jurda nginyipa burr-guya marr ny-balcharra, ganapiya, gu-yirda barra gu-ni nggula minypa nginyipa nguna-wengganana.” A-yinagata achila, lika warrika gun-gatiya jin-nigipa delipa wanngu jinyu-ni. ");
INSERT INTO bvr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Gu-gatiya wenga Jesus gu-bawuna gun-gata rrawa abirri-jirra Daya rrapa Jaydan, lika a-bona, a-bamuna bugula gu-rrarnba gun-gata rrawa Galali. Lika a-bamuna, a-warrchinga gu-bulgapulga gu-guyinda, lika gatiya a-rakaja. ");
INSERT INTO bvr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Lika aburr-jaranga wurra gama gorlk aburr-bona gurda nula, burrbu-ganyja gurda nula aburr-gurderdakurderda yerrcha aburr-gata aburr-nyarlkuch, aburr-burda, aburr-gapula, aburr-ngarlngarta, rrapa aburr-werranga burr-guta aburr-jaranga burrbu-ganyja gurda, burrbu-barnjinga Jesus ana-rrepara, lika nipa wanngu burr-negarra a-ni. ");
INSERT INTO bvr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Aburr-gata wurra gama gorlk birripa gugu aburr-worlworlcha aburr-ni, wurpa lika gochila aburr-barrjinga birripa burrbi-nana, minypa an-ngarlngarta an-guyinda a-wena a-jarl, rrapa an-burda an-guyinda minypa yort gu-menga a-jarl, rrapa an-nyarlkuch an-guyinda minypa gu-rrenyjinga a-jarl, rrapa an-gapula an-guyinda a-ganana. Lika aburr-marrngoypiyana nula aburr-ni Wangarr an-gata Yichrayal aburr-bapurr an-burriya. ");
INSERT INTO bvr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Gu-gata wenga Jesus a-gonyjinga burrwa aburr-yigipa jawina aburr-bona gurda nula, lika a-yinanga burrwa, “Aburr-guna wurra gama gorlk ngaypa ngu-worijinga burrwa, ngardawa gipa gugu ngorrngurra abirri-jirrapa gun-ngardapa nguburr-ni, rrapa balaja mu-wulebiyana burrwa. Ngaypa gala jal ngu-ni nguburr-jerrma, aburr-boy gun-birripa rrawa balaypalay minypa aburr-werrmiyana. Gala yapa aburr-bamba, gojilapa murna aburr-derichin.” ");
INSERT INTO bvr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wurra birripa aburr-yigipa jawina aburr-yinanga nula, “A-lay, ngunyuna gu-werrapa gala yina gaya rraka balaja nyibu-ma burrwa aburr-guna aburr-jaranga wurra gama gorlk!” ");
INSERT INTO bvr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Lika Jesus burr-wengganana, “Rakaraka ana-goyburrpa mu-yinmiyapa nyibi-rrimanga?” Birripa aburr-yinagata, “Arr-ngardapa arr-murna rrapa abirri-jirrapa, minypa 7, rrapa barrwa nyibi-rrimanga an-delipa jichicha an-guyinda an-jaranga ngika.” ");
INSERT INTO bvr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Lika Jesus a-wena burrwa wurra gama gorlk, birripa aburr-rakaja gu-jel. ");
INSERT INTO bvr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Lika nipa mu-menga mun-gata rakaraka mun-delipa mun-guyinda minypa arr-ngardapa arr-murna rrapa abirri-jirrapa, rrapa an-gata jichicha a-menga, lika a-japurramayana nula Wangarr. Lika mu-rrumurra rakaraka rrapa jichicha, rrapa burr-wuna aburr-yigipa jawina. Lika birripa burrbu-wuna aburr-bona wurra gama gorlk ");
INSERT INTO bvr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","mbi-barra aburr-ni, aburr-durtchinga. Lika gu-gata wenga mun-nerranga mun-gata mu-ngukiyana Jesus burr-yika jawina mbi-menga, lika wana burlupurr gu-guyinda mbi-jolartchinga, gu-ngana mu-mayana gun-gata minypa arr-ngardapa arr-murna rrapa abirri-jirrapa. ");
INSERT INTO bvr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Gun-narda janguny minypa aburr-gata wurra gama gorlk mbi-barra balaja; wurpa lika mu-wurra yerrcha aburr-gatiya 4,000. ");
INSERT INTO bvr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ganapiya, lika gu-gata wenga Jesus a-garlmuna, burr-jerrmarra rrawa. Lika nipa a-gortkurrchinga mu-michiyang rrapa aburr-yigipa jawina burr-guta, lika aburr-bona gu-gapa gu-rrarnba rrawa gun-nelangga Magardan (Magadan). ");
INSERT INTO bvr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Aburr-werranga aburr-gata Berachi (Pharisee) yerrcha rrapa Jejuchi (Sadducee) yerrcha, birripa aburr-bona gurda nula Jesus, lika aburr-wena nula aburr-gata jimarna nipa barra burr-barlmarrk jama a-ji burrwa, jimarn jarra birripa jal aburr-ni barra abi-na rrapa marn․gi aburr-ni nula minypa Wangarr ana-jerrmarra. Wurra birripa jarra jal aburr-ni minypa nipa a-yinmiya barra a-yolkiya rrapa birripa barra mari gubu-garra nula. ");
INSERT INTO bvr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Wurra nipa a-yinanga burrwa, “Wolawola warrarra gu-maya gu-workiya minypa marnnga jiy-bunggiya jiy-bamburda jiy-workiya, ana-goyburrpa nyiburr-weya nyiburr-workiya, nyiburr-yinaga, ‘Ngulam barra gun-molamola gu-ni barra, ngardawa gun-guniya warrarra gu-nirra.’ ");
INSERT INTO bvr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Wurra wolawola ngana guna-ngarlcharra guna-bamburda minypa warrarra gu-maya, ana-goyburrpa nyiburr-weya nyiburr-workiya, ‘Geka barra yorr gu-bungga barra, ngardawa nguparr gun-jaranga gu-ni,’ nyiburr-yinagata nyiburr-workiya. Minypa ana-goyburrpa marn․gi minyja yorr gu-bungga barra rrapa minyja gun-nyagara, minypa ana-goyburrpa nyibi-nacha nyiburr-workiya nguparr rrapa marn․gi nyiburr-nirra. Wurra jarra ngaypa jama ngu-jirra ngu-workiya ana-goyburrpa gala meyali nyibu-malawa nyiburr-ni gu-yinmiya gu-nirra. ");
INSERT INTO bvr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nyiburr-gurdiya gorlk nyiburr-werra! Ana-goyburrpa jal nyiburr-nirra nyiburr-workiya nyibi-na barra Wangarr gun-nika ganyjarr, wurra nipa gala barra nyirr-gurdagurdarra ganyjarr, wurpa lika gun-maywapa minypa gun-gata nipa jama a-ji nula Jona (Jonah) mu-ngoyurra a-ni.” A-yinagata Jesus a-wena burrwa, lika burr-bawuna a-bona; ay-bamuna. ");
INSERT INTO bvr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesus rrapa aburr-yigipa jawina aburr-jurrwurra gu-gapa gu-rrarnba gun-gata bugula wana, wurra birripa aburr-bamapuna, gala rakaraka mbi-ganyjarna gurda. Gata waypa aburr-bena, ");
INSERT INTO bvr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","lika Jesus a-yinanga burrwa, “Buburr-jarlapiya nula mun-gata Berachi yerrcha rrapa Jejuchi yerrcha mun-burriya mun-gata minypa wolawola gandichawa rakaraka mu-nenga mu-workiya.” ");
INSERT INTO bvr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Gun-narda Jesus a-wena, wurra aburr-yigipa jawina aburr-wengganachichiyana gu-gapa gu-guta, minypa aburr-yinanga, “Gun-gata nipa a-wena, ngardawa rakaraka nguburr-bamapuna, ya?” ");
INSERT INTO bvr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesus gu-borrwurra birripa aburr-wena aburr-ni, lika a-yinagata burrwa, “Awa! Ana-goyburrpa gun-delipa wupa marr nyiburr-balcharra, ya? Wurra an-nga nula ana-goyburrpa nyiburr-weya nyiburr-nirra minypa rakaraka nyiburr-bamapuna? ");
INSERT INTO bvr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Wurra ana-goyburrpa nyiburr-gurda gala marn․gi, ya? Gun-gata minypa rakaraka arr-ngardapa arr-murna ngaypa ngu-rrumurra burrwa aburr-jaranga gu-galiya yerrcha minypa 5,000, gun-narda ana-goyburrpa gala nyibu-borrwa, ya, minypa mu-yinmiyapa mu-ngukiyana? Minyja bubu-borrwa: Ana-goyburrpa barrwa nyibu-menga, nyibi-jolartchinga, burlupurr gu-yinmiyapa gu-ngana mu-mayana? ");
INSERT INTO bvr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Rrapa mun-gata mun-nerranga, minypa rakaraka arr-ngardapa arr-murna rrapa abirri-jirrapa ngaypa ngu-rrumurra burrwa aburr-jaranga gu-galiya yerrcha minypa 4,000, mun-narda mu-yinmiyapa mu-ngukiyana? Barrwa ana-goyburrpa nyibu-menga, nyibu-jolartchinga, burlupurr gu-yinmiyapa gu-ngana mu-mayana, ya? ");
INSERT INTO bvr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Wurra yama nyibu-borrwungarna gun-gata ngaypa ngu-wena ana-gorrburrwa rakaraka ngika? Wurra buburr-jarlapiya nula gun-gata Berachi yerrcha rrapa Jejuchi yerrcha gun-burriya gun-gata minypa mun-maywapa wolawola gandichawa rakaraka mu-nenga mu-workiya.” ");
INSERT INTO bvr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Gu-gata wenga Jesus burr-yika jawina marn․gi aburr-ni, minypa gun-gata nipa a-wena burrwa a-ni ngika minypa mun-gata rakaraka mu-jarrkarraja mu-workiya, wurra jarra birripa barra aburr-jarlapiya nula janguny gun-gata minypa Berachi yerrcha rrapa Jejuchi yerrcha gubi-rrimanga. ");
INSERT INTO bvr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Gu-gata wenga Jesus rrapa aburr-yigipa jawina aburr-bena gun-gata rrawa gu-jirra gu-boya gu-murnangana rrawa Jecharíya Bilipay (Caesarea Philippi) guna-jinyjarra. Gatiya aburr-bamuna, Jesus burr-wengganana aburr-yigipa jawina, “An-guna An-walkurpa An-gugaliya wurra gama gorlk aburr-yinmiya abu-ngurrjinga aburr-workiya? Birripa bama aburr-yinaga ana-nga nipa?” ");
INSERT INTO bvr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Birripa Jesus burr-yika jawina aburr-yinanga nula, “Minyja aburr-werranga aburr-weya jimarna Jon an-gata bama burr-gurragaja a-workiyana; aburr-werranga aburr-weya jimarna Yiláyja (Elijah); rrapa aburr-werranga aburr-weya jimarna Jeramáya (Jeremiah) wurra waygaji an-nerranga an-gata an-mujaruk an-guyinda mu-ngoyurra gu-ngurrjinga a-workiyana Wangarr gun-nika.” ");
INSERT INTO bvr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nipa a-yinagata, “Aya. Wurra ana-goyburrpa ngu-ngiya ngunabu-ngurrjinga?” ");
INSERT INTO bvr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Lika Jayman Birta a-yinanga, “Ny-jurda nginyipa Christ, Wangarr biy-yika Walkur nipa biy-rrimanga a-nirra.” ");
INSERT INTO bvr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Lika Jesus a-yinagata, “Nginyipa ny-jurda Jayman, Jona biy-yika ny-yalkurpa, Wangarr nipa wugupa nggula. Minypa gun-gata ny-yena ngardawa an-gugaliya nyanma ngika, wurra jarra Ngun-anya waykin a-nirra nipa biy-gurdagurdarrana. ");
INSERT INTO bvr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Rrapa barrwa ngaypa ngu-wengga barra nggula minypa gun-guna: Nginyipa Birta ny-jurda ny-yelangga minypa jandarra gun-gata meyali, wurra ngaypa ng-gunaga minypa gun-maywapa gun-gurrema, minypa ngaypa nguburr-ma barra aburr-ngaypa gu-galiya yerrcha birripa barra gun-nardiya gugu gun-gujuwa gala gu-yinmiya gu-jinyja burrwa. ");
INSERT INTO bvr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Rrapa nginyipa ngaypa ngiy-wu barra minypa gi (key), nginyipa nyi-lapkujama barra, rrapa minypa Wangarr burr-yika gu-galiya yerrcha aburr-barrnguma rrapa nipa ana-murna aburr-nipa barra aburr-workiya. Rrapa gun-nga minypa nginyipa ny-jobujoba gun-guniya rrawa, gun-narda nipa Wangarr gu-jobujoba barra yi-gaba waykin; rrapa gun-nga minypa nginyipa ny-mola nula gun-guniya rrawa, gun-narda nipa Wangarr an-mola a-ni barra nula yi-gaba waykin.” ");
INSERT INTO bvr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Lika Jesus a-wena burrwa aburr-yigipa jawina birripa barra yongun gubi-nega gun-gata minypa nipa Christ. ");
INSERT INTO bvr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Gun-nardiya gugu Jesus yarlanga a-wena burrwa a-workiyana aburr-yigipa jawina minypa nipa a-boy barra Jirúchalam (Jerusalem) rrapa burr-guya gun-nerra gu-ni barra nula, rrapa minypa aburr-gata mu-murna yerrcha rrapa mola wana junggay yerrcha rrapa joborr marn․gi aburr-gunega birripa ngoyurra aburr-yerryerrmiya barra nula rrapa abu-bu barra a-juwa, rrapa minypa gu-gata wenga ngorrngurra abirri-jirrapa gun-ngardapa, lika nipa Wangarr ana-nyala a-jarrkarra barra rrapa wanngu a-nega. ");
INSERT INTO bvr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Wurra nipa Birta ana-nyala a-menga Jesus, lika a-ganyja balay ngika, lika burr-guya a-wena nula, “Bunggawa, a-lay, gun-narda ny-yena Wangarr barra gu-ngukurdanyja! Gala barra gu-yirda gu-ni nggula!” ");
INSERT INTO bvr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Wurra Jesus a-ngukurdanyjiyana, lika a-wena nula Birta, “Nguna-bawa! Ny-jurda nginyipa Jeytan (Satan) an-gata walkwalk! Nginyipa nyi-guwarga. Gun-gata ny-yena gun-narda ngika Wangarr nyanma, wurra ana-gugaliya nyanma.” ");
INSERT INTO bvr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Lika Jesus a-wena burrwa aburr-yigipa jawina, a-yinagata burrwa, “Ana-nga minyja nipa jal a-ni barra nguna-jurrjurrma, nipa an-gata gala barra nipa wupa a-borrwiya a-workiya, wurra jarra jama a-ji barra a-workiya gun-gata minypa ngaypa ngu-wu barra, rrapa mu-nguy nguna-jurrjurrmapa barra a-workiya marrban gun-derta gu-barripa. ");
INSERT INTO bvr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ngardawa ana-nga an-gata gala nguna-burdima, wurra minypa nipa jal a-nirra jimarna barra wanngu a-negiya, an-gata an-gugaliya jarra gun-nyagara gu-ni barra. Wurra ana-nga minyja aburr-werranga abu-bu, a-juwa minypa nipa an-ngaypa, an-gata an-gugaliya nipa jarra wanngu a-nipa barra a-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Minyja ana-nga an-gata an-gugaliya wana an-babalapa a-negiya gun-guna rrawa, wurra gala wanngu gun-gunega nipa gu-borrwa a-ni, nipa an-gata gala gun-nga gun-molamola guna-jeka barra nula minypa nipa jama a-ji a-workiyana, wurra gun-nyagara. Rrapa barrwa gala gun-nga rraka nipa an-gata gu-barnja jimarna barra wanngu a-negiya. ");
INSERT INTO bvr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ngardawa yi-gurrepa gu-jirra gu-bamburda an-guna An-walkurpa An-gugaliya ana-jeka barra burr-gujayanaya Nyanyapa niya gun-nika, rrapa minypa aburr-yigipa waykin aburr-guyinda aburr-mujaruk wugupa nula aburr-bupiya barra gurda. Lika nipa burr-wu barra wurra gama gorlk ngardapa ngardapa minypa birripa mu-ngoyurra jama aburr-ji. ");
INSERT INTO bvr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Buburr-galiya apula; gun-guna gun-burral: Nyiburr-werranga nyiburr-gurda gala barra mu-ngoyurra nyiburr-juwa, wurra burdak an-guna An-walkurpa An-gugaliya nyibi-na barra minypa Bunggawa ana-bamburda.” ");
INSERT INTO bvr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nuwurra waypa ngorrngurra abirri-jirrapa abirri-jirrapa abirri-jirrapa, lika Jesus burr-ganyja, mu-mirk waykin aburr-bona ngardapa burrwa Birta (Peter) rrapa Jeymch (James) rrapa Jon an-gata Jeymch an-nika worlapa niya. ");
INSERT INTO bvr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Gu-gata wenga abi-nana Jesus ngol gun-nerranga gu-rakaja nula, minypa bukula a-jirra japurra a-jirra minypa jin-maywapa marnnga jina-darrjinga jina-workiya, rrapa mun-nigipa mirikal mu-garlmunapa mun-gungarlcha mu-nayana mu-ji. ");
INSERT INTO bvr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Lika gu-gata wenga aburr-gata Jesus burr-yika jawina burrbi-nana gipa mu-ngoyurra abirri-guyinda Mojich (Moses) rrapa Yiláyja (Elijah) minypa bitipa wugupa nula Jesus aburr-wena aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Lika Birta a-garlmuna, a-wena nula Jesus, “A-lay, Bunggawa, minyja gun-narda gun-molamola minypa ngayburrpa nyiburr-guna wugupa ana-gorrburrwa. Minyja nginyipa jal nyi-ni, ngaypa birlapirla ng-gupa barra abirri-jirrapa gun-ngardapa: gun-ngardapa gun-nginyipa, rrapa gun-ngardapa Mojich gun-nika, rrapa gun-ngardapa Yiláyja gun-nika.” ");
INSERT INTO bvr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Wurra gun-narda Birta burdak a-wena a-ji, nguparr gun-gata gu-jayanayana gu-ji gu-garlmunapa bin-denyjinga, rrapa ana-manyjirda aburr-galiyana gu-nguparr wenga ana-wena burrwa, a-yinanga, “An-guna an-ngaypa Walkur ngaypa burr-guya jal ngu-nirra nula; ngaypa ngu-marrkapchinga nula. An-nardiya buburr-galiya nula!” ");
INSERT INTO bvr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Gun-narda waypa Jesus burr-yika jawina aburr-galiyana Wangarr manyjirda a-jirra a-wena burrwa, birripa burr-guya aburr-gurkuja aburr-ni, rrapa aburr-bungguna, bukula aburr-jirra gu-jel aburr-gurrmiyana aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Wurra Jesus ana-bona, bin-dimarra. A-yinanga burrwa, “Buburr-garlma. Ngika buburr-gurkuja.” ");
INSERT INTO bvr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Lika waykin aburr-ganana, wurra gala ana-nga abi-nacharna, wurra jarra nipa wupa Jesus. ");
INSERT INTO bvr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Lika gatiya waypa mu-mirk wenga aburr-bupiyana gurda aburr-bamuna, Jesus burr-guya a-wena burrwa aburr-bamuna, a-yinagata burrwa, “Gala barra aburr-werranga nyiburr-wengga burrwa ana-goyburrpa geka nyibi-nana, wurra nuwurra waypa barra an-guna An-walkurpa An-gugaliya a-juwa rrapa Ngun-anya a-jarrkarra.” ");
INSERT INTO bvr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Lika birripa abu-wengganana, “A-lay, gun-gata an-nga nula aburr-gata joborr marn․gi aburr-gunega aburr-weya aburr-workiya ni gugu Yiláyja ana-boy barra?” ");
INSERT INTO bvr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Lika nipa Jesus a-yinagata burrwa, “Ngaw. An-nerranga minypa Yiláyja ni-gugu ana-boya, rrapa gun-nga minypa mu-ngoyurra gun-nerra gu-ni nipa minypa gu-jarlapa barra barrwa gun-molamola gu-ji barra. ");
INSERT INTO bvr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Wurra jarra ngaypa ngu-weya ana-gorrburrwa nipa an-gata gipa ana-bona. Nipa ganyjarr gu-rrimarra gun-maywapa minypa Yiláyja, wurra gu-galiya yerrcha gala abu-malawujarna; jarra aburr-yinagata nula birripa aburr-yinmiyana jal aburr-ni. Rrapa gu-gurda ngacha minypa werra abu-bu barra an-guna An-walkurpa An-gugaliya.” ");
INSERT INTO bvr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jesus a-yinagata a-wena burrwa, lika aburr-gatiya aburr-yigipa jawina marn․gi aburr-ni minypa nipa a-ngurrjinga burrwa an-gata Jon bama burr-gurragaja a-workiyana. ");
INSERT INTO bvr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ganapiya, lika gun-gatiya waypa birripa aburr-bena burrwa gu-galiya yerrcha aburr-bamagutuwiyanapa, lika an-ngardapa an-gugaliya ana-bona, ana-menama gu-rrana nula Jesus, ");
INSERT INTO bvr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","minypa a-yinanga nula, “Bunggawa, gunggaja nula an-guna an-ngaypa delipa! Nipa minypa burr-guya gun-nerra gu-nirra nula gu-workiya, minypa an-jarrarderta a-nirra a-workiya. Minypa a-bamburdapa a-bunggiya a-workiya, minypa yi-gata wupa gu-bol gu-rrongga gu-jirra, rrapa minypa gu-bugula. ");
INSERT INTO bvr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Wurra ngaypa nguna-ganyja burrwa aburr-guna aburr-nginyipa jawina, wurra birripa gala aburr-yinmiyarna wanngu abi-nengarna.” ");
INSERT INTO bvr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Wurra Jesus a-wena burrwa aburr-gata, “Ana-goyburrpa nyiburr-gurdiya gorlk nyiburr-werra, ngarla! Wurra yama marr nyiburr-balcha nula Wangarr? Ngaypa gu-yinmiyapa ngaypa arr-ga barra rrapa marr ng-ga barra ana-gorrburrwa? Wurra bubu-ga gurda apula an-gata.” ");
INSERT INTO bvr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Lika Jesus burr-guya a-wena nula walkwalk an-gata delipa a-rrimarra, lika nipa a-bawuna, ana-bena, rrapa gatiya gugu nipa delipa a-molamiyana. ");
INSERT INTO bvr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Lika nuwurra waypa Jesus rrapa aburr-yigipa jawina ngardapa aburr-ni, birripa aburr-garlmuna, abu-wengganana, “A-lay, an-nga nula ngayburrpa nyiburr-barparpuna jimarn jarra walkwalk nyibi-yerrnyjingarna?” ");
INSERT INTO bvr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Lika nipa a-yinanga burrwa, “Minyja ana-goyburrpa gala burr-guya marr nyiburr-balcharna, ngarla. Wurra gun-guna ngu-weya ana-gorrburrwa gun-burral: Ny-yinga ny-jata minyja marr ny-balcha, wuriya gun-gata gun-delipa, minypa mun-maywapa mun-gata gun-jong machart (mustard) mipila mu-jirra mun-gata mun-delipa; wurra ngardawa nginyipa marr ny-balcharra, jal nyi-ni ny-yengga nula mun-guna mun-mirk, ny-yinda nula, ‘Garlma, boy gu-guna wenga yi-gata,’ rrapa minypa mun-mirk mu-yirdiya barra m-boy. Minypa gala barra gun-nga gun-derta gu-ni nggula.” ");
INSERT INTO bvr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Gun-gatiya waypa Jesus rrapa aburr-yigipa jawina gu-ngardapa aburr-negiyana aburr-ni, minypa gun-gata wana gun-bapala rrawa gun-nelangga Galali (Galilee), lika nipa a-yinanga a-wena burrwa, “A-lay, yi-gurrepa gu-jirra gu-boya an-guna An-walkurpa An-gugaliya abi-rrima barra, rrapa burrbu-wu barra ");
INSERT INTO bvr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","gu-galiya yerrcha abu-bu barra. Wurra gu-gata wenga ngorrngurra abirri-jirrapa gun-ngardapa, lika nipa Wangarr ana-nyala a-jarrkarra barra rrapa wanngu a-nega.” Jesus a-yinagata a-wena burrwa aburr-yigipa jawina, lika birripa burr-guya wargugu aburr-ni nula. ");
INSERT INTO bvr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Gu-gata wenga aburr-bena gun-gata rrawa gun-delipa gun-nelangga Gapárniyam (Capernaum). Rrapa aburr-werranga aburr-gata minypa rrupiya burrbu-gaypuna aburr-workiyana wurra gama gorlk gun-gata nula bala gun-japurra Wangarr gun-nika, birripa aburr-bona gurda nula Birta, lika abu-wengganana, “A-lay, an-narda an-goyburrpa bunggawa nipa rrupiya m-barnjinga a-workiya gun-gata nula bala gun-japurra, waygaji gun-nyagara, ya?” ");
INSERT INTO bvr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nipa Birta a-yinanga, “M-barnjinga, ngarla!” Lika gatiya waypa Birta a-barrngumurra gu-bala, Jesus mu-ngoyurra a-wena, a-yinanga nula, “Jayman, a-lay, gun-guna nginyipa ny-yinmiya ny-borrwuja? Bunggawa an-guyinda gun-guna rrawa, nipa aburr-nga mbi-barnjinga nula aburr-workiya rrupiya mun-nigipa minypa nipa dek (tax) wurley mu-nenga burrwa a-workiya? Waygaji aburr-gata aburr-yigipa walkurpa niya yerrcha, ya? Waygaji aburr-werranga, ya?” ");
INSERT INTO bvr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Birta a-yinanga nula, “Aburr-gata aburr-werranga.” “Minyjiya,” Jesus a-yinagata, “rrapa walkurpa niya yerrcha gala joborr gu-yu burrwa rraka rrupiya mbi-barnja minypa dek, wurra gun-nyagara. ");
INSERT INTO bvr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Wurra wuriya. Wurra ngarripa gala jal arr-ni mari ay-jarlapa burrwa aburr-gata minypa rrupiya mbi-mangga aburr-workiya gun-gata nula bala gun-japurra. Wurra boy bugula gu-rrarnba galang ny-yerrnyja barra, lika an-gata mu-ngoyurra jichicha nyi-rakawa barra, an-gata minypa ngana a-jirra nginyipa barra ny-barripa rrupiya, barra nginyipa ny-boy, dek ny-barnja barra, mun-gata minypa nginyipa barra burr-wu rrapa minypa ngaypa barra nguburr-wu gun-gata nula bala gun-japurra.” ");
INSERT INTO bvr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Gun-gatiya lika Jesus burr-yika jawina aburr-bona gurda nula, lika abu-wengganana, “A-lay, ngayburrpa nyiburr-guna ana-nga barra wana a-ni Wangarr ana-murna?” ");
INSERT INTO bvr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Aburr-yinagata aburr-wena, lika Jesus a-gonyjinga nula an-gungarda an-guyinda delipa, lika a-menga, a-garrana, gatiya a-jinyja Jesus burr-yika jawina aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Lika nipa Jesus a-yinanga, “Gun-guna ngu-weya ana-gorrburrwa gun-burral: Ana-goyburrpa gala nyiburr-yinmiya Wangarr ana-murna nyiburr-ni, wurra minyja nyiburr-ngukurdanyjiya rrapa nyiburr-ni minypa gu-ngarda yerrcha gala wana aburr-negiya aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ngardawa ana-nga an-gata wana an-bapala a-nirra Wangarr ana-murna, an-gata an-gugaliya ngardawa delipa a-negiya a-workiya rrapa a-nirra a-workiya minypa an-maywapa an-guna an-delipa. ");
INSERT INTO bvr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Rrapa ana-nga an-mola nula ana-gurda ngacha delipa ngardawa minypa ngaypa ngu-welangga, minypa ngaypa jal ngu-nirra nula delipa, an-gata an-gugaliya nipa ngardawa an-mola apula ngaypa. ");
INSERT INTO bvr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Wurra ana-guna ngacha delipa minypa marr a-balcharra apula, ana-nga an-nerranga a-yinmiyan rrapa nipa delipa a-lijiwarriyan, wurra jimarn jarra an-gata an-gugaliya mu-ngoyurra abu-bichingarna gu-jandarra wana gu-bapala, lika abi-yerrnyjingarna gu-bachirra gu-lupa gu-guyinda. Gu-gurda ngacha minypa nipa mari gu-manggarna marr gu-yinanga wana, wurra gun-gata minypa Wangarr ana-nyala a-bu barra minypa delipa a-warganyja, gun-narda jarra minypa burr-guya gun-nerra gu-ni barra nula an-gata an-gugaliya. ");
INSERT INTO bvr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Minypa wurra gama gorlk gun-nardiya rrawa burr-guya gun-nerra gu-ni barra burrwa, ngardawa gun-gulijiwarriya guy-bamburdapa. Gu-gata ngacha guy-bamburda, ngarla, wurra barrwa burr-guya gun-nerra gu-ni barra nula ana-gata ngacha an-gugaliya minypa gun-gulijiwarriya guna-ganyja ana-workiyana! ");
INSERT INTO bvr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Wurra minyja nginyipa murna ny-jirra waygaji rrepara ny-jirra gun-nerra jama ny-jirra ny-yorkiya, ny-jurda murna ny-jirra ny-nyardapa o rrepara ny-jirra ny-nyardapa gorndiya, yerrnyja. Ngardawa gun-mola nggula nginyipa ny-nyurrnga barra wanngu nyi-ni, wuriya murna ny-jirra waygaji rrepara ny-jirra ny-nyardapa. Gala yapa murna ny-jirra ny-jilirrwirrka rrapa rrepara ny-jirra ny-jilirrwirrka ny-bamba, barrwa minypa Wangarr biy-yerrnyjin yi-gata wupa gu-bol gu-rronggapa gu-jirra gu-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Rrapa minyja mipila ny-jirra gun-nerra jama ny-jirra ny-yorkiya, ny-junarda mipila ny-jirra ny-nyardapa nyina-warrka, yerrnyja. Ngardawa gun-mola nggula barra nginyipa ny-nyurrnga wanngu nyi-ni, wuriya mipila ny-jirra ny-nyardapa. Gala yapa mipila ny-jirra ny-jilirrwirrka ny-bamba, barrwa minypa Wangarr biy-yerrnyjin yi-gata wupa gu-bol gu-rronggapa gu-workiya, minypa Hell. ");
INSERT INTO bvr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Aburr-gurda ngacha gu-ngarda yerrcha gala barra ny-yerryerrmiya burrwa. Ngardawa ngaypa ng-gunaga ngu-weya ana-gorrburrwa ngu-nirra: Aburr-birripa waykin aburr-guyinda aburr-mujaruk ngardapa ngardapa burrbi-rrimanga jaga aburr-ganaja burrwa, birripa aburr-gata waykin Ngun-anya a-ninyarrapa. ");
INSERT INTO bvr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Minyja bubu-borrwa: An-gugaliya jin-bulapalawa jin-dimanga jip (sheep) minypa 100, wurra minyja jin-ngardapa jinyu-lijiwarriya, lika nipa a-yinmiya barra? Wurra nipa jiny-bawa barra jin-gata 99 jip, gata gu-bulgapulga jiny-ji barra, gorrngunya m-bay jiny-ji, wurra nipa a-garlma barra a-boy, a-wecha achila jin-gata jin-ngardapa jip jinyu-lijiwarriyana. ");
INSERT INTO bvr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Rrapa gun-guna ngu-weya ana-gorrburrwa gun-burral: Minyja nipa jiny-barripa jip jin-gata jinyu-lijiwarriyana, nipa burr-guya a-worlworlcha barra achila; jin-gata 99 jip gala jinyu-lijiwarriyarna nipa marr a-yinda a-worlworlcha barra achila nipa jin-gata. ");
INSERT INTO bvr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Gu-gurda ngacha minypa Nyanyapa arrku waykin a-nirra gala jal a-ni ana-gurda ngacha delipa barra a-lijiwarriya, wuriya an-ngardapa. ");
INSERT INTO bvr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“An-nginyipa minypa worlapa nggu, minyja nipa werra biy-nega, nginyipa boy, wengga nula minypa ngardapa ana-gota gurdagurdarra minypa nipa werra a-negiyana. Rrapa minyja nipa a-galiya nggula, gun-narda minypa nginyipa ny-nyukurdanyjinga, nipa gugu gu-mola a-nirra. ");
INSERT INTO bvr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Wurra minyja nipa gala a-galiya nggula, an-nerranga an-gugaliya ny-ma barra, waygaji an-ngardapa, waygaji abirri-jirrapa, lika wugupa buburr-boy nula an-gata, barra minypa janguny mu-jurra mu-weya mu-yurra, ‘minyja mari gu-ma, wurra ngardawa gu-galiya yerrcha waygaji abirri-jirrapa, waygaji abirri-jirrapa an-ngardapa abu-ngurrjinga, minypa gun-gata gun-ganawa burrwa janguny abu-ngurrjinga minypa abi-nana gun-nerra jama a-ji,’ gu-gurda ngacha. ");
INSERT INTO bvr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Wurra minyja nipa gala a-galiya burrwa, burr-wenggana Wangarr burr-yika gu-galiya yerrcha gatiya minypa aburr-bamagutuwiyana. Rrapa minyja birripa burr-guta nipa gala a-galiya burrwa, ganapiya, ana-goyburrpa barra nyibu-borrwa nula minypa nipa an-nerra warrpam, rrapa minypa gu-werranga gu-rrawa wenga gala Wangarr a-borrwa a-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ngardawa gun-guna ngu-weya ana-gorrburrwa gun-burral: Gun-nga minypa ana-goyburrpa nyibu-jobujoba gun-guniya rrawa, gun-narda nipa Wangarr gu-jobujoba barra yi-gaba waykin; wurra gun-nga minypa ana-goyburrpa nyiburr-mola nula gun-guniya rrawa, gun-narda nipa Wangarr an-mola a-ni barra nula yi-gaba waykin. ");
INSERT INTO bvr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Rrapa barrwa gun-guna ngu-wengga barra ana-gorrburrwa: Nyirri-yinga nyirri-gata, gu-nga nula minypa gu-ngardapa nyirri-borrwa rrapa nyirri-wenggana, nipa Ngun-anya waykin a-nirra a-yindiya barra jama a-ji ana-gotula. ");
INSERT INTO bvr_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ngardawa yina abirri-gaya abirri-bamagutuwiya abirri-workiya minypa abirri-jirrapa gu-galiya yerrcha, waygaji abirri-jirrapa an-ngardapa, minypa marr aburr-balcharra apula ngaypa ngu-welangga, ngaypa ng-gatiya wugupa burrwa.” ");
INSERT INTO bvr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Lika Birta yi-gurrepa a-negiyana nula Jesus, lika a-wengganana, “Bunggawa, a-lay, an-ngaypa minypa worlapa apa, minyja nipa mu-nguy werra nguna-nega a-workiya, ngaypa ngu-yinmiyapa ng-goma ngu-nega barra ngaypa baywarra ngu-nega barra nula, ya? Waygaji arr-ngardapa arr-murna rrapa abirri-jirrapa, ya?” ");
INSERT INTO bvr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Wurra Jesus a-yinanga, “Ngika arr-ngardapa arr-murna rrapa abirri-jirrapa! Wurra jarra mu-nguy ny-jaranga ny-joma nyi-negapa barra baywarra nyi-nega barra nula ny-yorkiya. ");
INSERT INTO bvr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ngardawa rum gun-gata waykin wenga, nipa minypa gun-guna meyali: An-ngardapa an-gata bunggawa, nipa gu-borrwurra a-birripiya barra burrwa aburr-yigipa aburr-mujama, minypa mu-yinmiyapa rrupiya birripa ngardapa ngardapa mbi-gurdanyja barra gurda nula barra minypa gu-lirrjiya burrwa. ");
INSERT INTO bvr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Rrapa gun-gatiya gugu abu-ganyja gurda nula bunggawa an-ngardapa an-gugaliya minypa rrupiya mun-gata nipa barra muna-gurdanyja nula bunggawa burr-guya mun-jaranga. ");
INSERT INTO bvr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Wurra nipa an-gata gala mun-jaranga mu-rrimangarna rraka muna-gurdanyjingarna nula bunggawa. Lika bunggawa a-wena minypa nipa jalim a-nega barra an-gata an-gugaliya, rrapa minypa gun-nigipa gorlk rrapa jin-nigipa jin-gumarrbipa niya rrapa aburr-yigipa gu-ngarda yerrcha burr-guta jalim burr-nega barra. Minypa mun-gata rrupiya barra muna-jeka nula nipa bunggawa, wurra birripa jarra minypa jama aburr-jipa barra aburr-workiya nuluwa an-gata an-nerranga gun-nardiya gugu ngika burr-rrupiya. ");
INSERT INTO bvr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Wurra nipa an-gata an-mujama ana-menama gu-rrana nula bunggawa, minypa a-ngiwija nula, ‘Bunggawa, japurra ngapa ny-jirra, a-lay! Burdak marr ga apula. Mun-gata rrupiya burraya ngaypa burr-gurla ngiy-wu barra.’ ");
INSERT INTO bvr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Gu-gatiya wenga bunggawa werra a-nana an-gata an-nigipa an-mujama, lika baywarra gu-negarra nula mun-gata rrupiya. Minypa a-jerrmarra, gala barra mun-nga muna-gurdanyja nula bunggawa, wurra gipa gugu gu-rorrchiyana. ");
INSERT INTO bvr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Wurra an-mujama nipa waypa yarlanga a-bena, a-nana an-nerranga an-gata an-mujama nipa an-guna gipa mu-ngoyurra a-wuna mun-delipa rrupiya gugu an-gata barra muna-gurdanyja nula. Lika nipa burr-guya a-rrimarra jawa a-jirra, rrapa burr-guya a-wena nula, ‘Nguna-wu mun-ngaypa rrupiya!’ ");
INSERT INTO bvr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Wurra nipa an-gata ana-menama gu-rrana nula rrapa a-ngiwija nula, ‘Burdak marr ga apula, a-lay. Burraya ngiy-wu barra.’ ");
INSERT INTO bvr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Wurra an-guna minypa bunggawa gipa baywarra gu-negarra nula, nipa jarra gala gu-yagurrmungarna nula an-gata an-nerranga an-gugaliya. Minypa a-menga, a-ganyja, wupa a-barnjinga nuwurra nipa muna-gurdanyja nula rrupiya. ");
INSERT INTO bvr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Wurra aburr-werranga aburr-gata aburr-mujama, gun-narda waypa birripa gubi-nana, burr-guya wargugu aburr-ni. Lika aburr-bona, gubu-ngurrjinga nula bunggawa gun-gata gu-yinmiyana gu-ni. ");
INSERT INTO bvr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Lika bunggawa a-gonyjinga nula an-gata an-mujama, lika a-yinanga nula, ‘Ny-jurda nginyipa ny-yerra warrpam! Gun-gatiya nginyipa ny-nyiwija apula nyi-ni, ngaypa baywarra ngu-negarra nggula mun-gata rrupiya wana jimarna nyina-gurdanyjingarna apula. ");
INSERT INTO bvr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Wurra yama nginyipa ny-junggajingarna nula an-borrmunga nggula minypa ngaypa ng-gunggajinga nggula nginyipa?’ ");
INSERT INTO bvr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Lika bunggawa a-bachirramiyana nula an-gata an-mujama. Minypa nipa a-wena, wupa abu-barnjinga nuwurra waypa barra nipa an-mujama muna-gurdanyja nula bunggawa mun-gata burr-gurla mun-nigipa rrupiya. ");
INSERT INTO bvr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Rrapa ana-goyburrpa, minyja ny-yinga ny-jata gala baywarra nyi-nega nula an-nginyipa worlapa nggu minypa burr-molma burr-burral, nginyipa rrapa ny-yirdiya barra Nguna-anya waykin a-nirra a-bachirramiya barra nggula.” ");
INSERT INTO bvr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Gun-gatiya waypa Jesus gu-mungbuna a-wena janguny, lika nipa gu-bawuna a-bona gun-gata rrawa Galali (Galilee), rrapa a-bona gun-gata wana gun-bapala rrawa Judíya (Judea), wurra gu-gapa gu-rrarnba man․garba Jordan, ");
INSERT INTO bvr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","rrapa gatiya aburr-jaranga wurra gama gorlk abu-jurrjurrmurra, rrapa nipa lika bin-dimarra aburr-gurderdakurderda aburr-guyinda. ");
INSERT INTO bvr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Rrapa aburr-werranga Berachi (Pharisee) yerrcha aburr-bona gurda nula Jesus, jimarn jarra barra nipa a-yolkiya a-wengga rrapa birripa barra mari gubu-garra nula. Gu-gurda ngacha minypa birripa abu-wengganana, aburr-yinanga nula, “A-lay, gun-mola, ya, minyja an-gugaliya jiny-bawa jin-nigipa jin-gumarrbipa niya minypa gun-gata ngardawa gun-nigipa wupa jal, ya?” ");
INSERT INTO bvr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Wurra Jesus a-yinanga burrwa, “Nyiburr-gurdiya gala nyibi-nacharna janguny mu-jurra gu-yurra, ya? Minypa wola baman gu-ni Wangarr ‘bijirriny-jarlapuna minypa an-nurra rrapa jin-gama,’ ");
INSERT INTO bvr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","rrapa a-yinanga a-wena, ‘Gu-gata nula an-gugaliya bijirriny-bawa barra nyanyapa niya rrapa mampa niya, jin-nigipa jin-gumarrbipa niya barra jiny-ma, lika birrinyjipa abirriny-nyardapa abirrinyu-ni barra.’ ");
INSERT INTO bvr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Gu-gurda ngacha minypa birrinyjipa gala barrwa ngardapa ngardapa abirrinyu-ni, wurra jarra gun-nardiya gugu abirriny-nyardapa. Lika ganapiya. Gala barra ana-nga bijirriny-nyorrkornda abirriny-jata; wurra jarra Wangarr bijirriny-mulpuna gu-ngardapa.” ");
INSERT INTO bvr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Lika birripa Berachi yerrcha aburr-yinagata, “Wurra an-nga nula nipa Mojich (Moses) gu-barnjinga gun-gata joborr, minypa an-gugaliya jiny-bawuja a-workiya jin-nigipa jin-gumarrbipa niya, nipa an-gugaliya mu-ngoyurra barra a-wukurrja achila jurra mu-guyinda minypa nipa jiny-bawa barra, lika nuwurra jurdach jiny-bawa?” ");
INSERT INTO bvr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Wurra Jesus a-wena burrwa, “Mojich gu-yagurrmurra ana-gorrburrwa barra minypa nyirrbu-bawa aburr-goyburrpa aburr-gumarrbipa ana-gorrburra, ngardawa mun-molma mun-derta ana-gorrburrwa. Wurra gu-gata ngacha gala mu-ngoyurra gu-yurrarna. ");
INSERT INTO bvr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Wurra gun-guna ngu-weya ana-gorrburrwa gun-burral: Jin-gata jin-gumarrbipa jin-guyinda minypa gala jiny-boy nula an-nerranga, wurra minyja an-nigipa an-gumarrbipa ngacha jiny-bawa rrapa jin-nerranga jiny-ma, gun-narda minypa birrinyjipa abirriny-jata gun-nerra jama abirriny-jirra.” ");
INSERT INTO bvr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Gun-gatiya lika Jesus burr-yika jawina aburr-yinanga nula, “Minyja gu-yirdiya gugu gu-nirra burrinyjula jin-gumarrbipa rrapa an-gumarrbipa, gun-mola jarra minyja an-gugaliya gala jiny-ma gama.” ");
INSERT INTO bvr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Lika Jesus a-yinagata burrwa, “Gun-narda ana-goyburrpa nyiburr-wena, jarra aburr-jaranga gu-galiya yerrcha gala aburr-yinmiya gubi-rrima janguny, wurra aburr-gata wupa minypa gu-gata ngacha ganyjarr gubi-rrimanga. ");
INSERT INTO bvr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Minypa an-nerranga an-gugaliya gala gama jal a-ni gun-gumalapa, ngardawa nipa a-bambunggapa a-yirdiyapa a-ni, gala jal a-ni gun-gurdawurrja; rrapa an-nerranga ngardawa gu-galiya yerrcha aburr-yinmiyana abu-gaypuna an-nurra, nipa a-yinagatiya; rrapa an-nerranga ngardawa gun-gumalapa nipa gu-bawuna, wurra minypa burr-guya jama a-ji barra nula Wangarr. Gun-narda janguny ana-nga minyja gun-mola nula, nipa a-yirdiya barra.” ");
INSERT INTO bvr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Gu-gatiya wenga aburr-werranga burrbu-ganyja gurda nula Jesus delipa delipa yerrcha barra minypa nipa bin-dima rrapa a-wenggana burrwa. Wurra aburr-yigipa jawina burrbu-jobujobuna aburr-gata. ");
INSERT INTO bvr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Wurra Jesus a-wena burrwa aburr-yigipa jawina, “Ganapa burrbu-jobujoba. Wurra burrbu-jerrma gurda apula aburr-gata delipa delipa yerrcha. Ngardawa Wangarr burr-barlmarrk jama a-jirra burrwa a-nirra aburr-yigipa gu-galiya yerrcha aburr-gatiya minypa aburr-gurda delipa delipa yerrcha.” ");
INSERT INTO bvr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ganapiya, lika nuwurra waypa bin-dimarra, lika mu-nguy ay-bamuna. ");
INSERT INTO bvr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","An-ngardapa an-gugaliya ana-bona nula Jesus, lika a-wengganana, “Bunggawa, a-lay, ngaypa gun-nga barra gun-molamola jama ngu-ji minypa wanngu ngu-nipa barra ngu-workiya Wangarr ana-murna?” ");
INSERT INTO bvr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesus a-yinanga nula, “An-nga nula nginyipa nguna-wengganana gun-gata nula gun-nga gun-molamola? Wurra an-gata Wangarr, nipa an-ngardapiya an-molamola. Wurra minyja nginyipa jal nyi-ni wanngu gun-guni ny-ma barra, borrwa gun-gata joborr gun-guyinda nipa gu-barnjinga.” ");
INSERT INTO bvr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Lika nipa an-gugaliya a-yinagata, “Gun-gata gu-guyinmiya ngacha joborr, a-lay?” Jesus a-yinagata, “Gala barra ny-bu, a-juwa, rrapa gala barra jin-ngumurda ny-ma ana-werranga jin-nika, rrapa gala barra mun-ngumurda ny-ma, rrapa gala barra an-nerranga jonama ny-nyurrja. ");
INSERT INTO bvr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Wurra jarra marr balcha burrinyjula nyanyapa nggu rrapa mampa nggu, rrapa jal ni nula an-gugaliya minypa gun-maywapa nginyipa ngardapa nggu jal nyi-nirra nggula.” ");
INSERT INTO bvr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Lika an-gatiya an-yawarriny a-yinagata, “Gu-gata ngacha joborr ngaypa gipa ngu-borrwujapa ngu-workiya. Wurra barrwa gun-nga barra ngu-yirda?” ");
INSERT INTO bvr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Lika Jesus a-wena nula, “Minyja nginyipa jal nyi-ni barra ny-molamola warrpam nyi-ni, boy, gun-nginyipa gorlk ma, burr-wu, rrapa rrupiya ma burrwa aburr-gata aburr-nyagara; burraya nginyipa gun-molamola ny-ma barra gun-gaba waykin. Wurra guwa, nguna-jurrjurrma.” ");
INSERT INTO bvr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Gun-narda waypa an-gata an-yawarriny a-galiyana, lika nipa wargugu a-ni, a-jekarra a-bamuna. Ngardawa nipa wana gun-jaranga gorlk gu-rrimarra. ");
INSERT INTO bvr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Lika Jesus a-wena burrwa aburr-yigipa jawina, a-yinanga burrwa, “Gun-guna ngu-weya ana-gorrburrwa gun-burral: Aburr-gata minypa gorlk gun-jaranga gubi-rrimanga, gun-gata minypa burr-guya gun-derta gu-nenga burrwa rraka aburr-galiya nula Wangarr rrapa nipa ana-murna aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Minyjiya. Minypa gun-maywapa ranginy niyal (needle) rralala a-maya a-jirra an-gata nganaparra gala a-yinmiya a-barrnguma, gu-gurda ngacha minypa gun-burral an-gugaliya gorlk gun-jaranga gu-rrimanga gala a-yinmiya a-galiya nula Wangarr rrapa nipa ana-murna a-ni.” ");
INSERT INTO bvr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Gun-narda waypa Jesus burr-yika jawina aburr-galiyana, gochila aburr-barrjinga. Aburr-yinagata nula, “A-lay, gun-derta gun-gorla janguny, ngarla! Wurra ana-nga barra wanngu a-ni?” ");
INSERT INTO bvr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Wurra Jesus burr-nana, a-yinagata burrwa, “Gorlk gun-jaranga nula gala a-yinmiya rraka wanngu a-ni, jarra gala gun-nga gun-derta nula Wangarr.” ");
INSERT INTO bvr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Lika Birta a-wena, “A-lay, ngayburrpa nyibu-bawuna gun-jaranga rrapa nyiburr-guna bubu-jurrjurrmunga. Ngayburrpa gun-nga nyibu-ma barra?” ");
INSERT INTO bvr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Lika Jesus a-yinagata burrwa, “Gun-guna ngu-weya ana-gorrburrwa gun-burral: Nuwurra waypa barra gun-guna rrawa gu-ngukurdanyjiya rrapa gun-geka gu-ni barra, minypa an-guna An-walkurpa An-gugaliya Bunggawa a-ni barra minypa burr-gujayanaya, wurra ana-goyburrpa nyiburr-gurda ngunabu-jurrjurrmurra, ana-goyburrpa nyiburr-gatiya. Minypa bunggawa an-guyinda gun-nika gun-gurrenyja gun-guni ana-goyburrpa nyiburr-ni barra, rrapa aburr-gata arr-jirrapa arr-murna rrapa abirri-jirrapa Yichrayal (Israel) aburr-bapurr, birripa barra aburr-jinyja gatiya ana-goyburrpa nyiburr-yinmiya barra nyiburr-wengga. ");
INSERT INTO bvr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Rrapa aburr-jaranga gu-galiya yerrcha, aburr-yinmiyapa aburr-gata minypa mu-ngoyurra gubu-bawuna gun-birripa rrawa, rrapa burrbu-bawuna minypa worlapa burra jelapa burra yerrcha rrapa nyanyapa burra mampa burra rrapa gu-ngarda yerrcha, minypa aburr-guna ngunabu-jurrjurrmurra ngaypa, aburr-gurdiya gu-galiya yerrcha ngardapa ngardapa burrbu-ma barra mola aburr-jaranga aburr-borrmunga rrapa mola gun-jaranga rrawa; rrapa wanngu gun-guni gubu-ma barra wanngu aburr-nipa barra aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Wurpa lika aburr-jaranga aburr-gata minypa mu-ngoyurra aburr-jirra, birripa barra jurdach aburr-ji; rrapa aburr-jaranga aburr-gata minypa jurdach aburr-jirra, birripa barra mu-ngoyurra aburr-ji. ");
INSERT INTO bvr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Yi-gaba waykin Wangarr burr-wu barra minypa mu-ngoyurra jama aburr-ji nula, minypa gun-guna gun-maywapa ranginy: An-gata rrawa walang a-garlmuna, ngana guna-ngarlcha a-bona, burr-menga aburr-mujama barra minypa jama aburr-ji gurnal nipa mu-garrana a-ni gu-yigipa gu-rrawa. ");
INSERT INTO bvr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Minypa nipa a-wena burrwa burraya burr-wu barra ngardapa ngardapa mun-ngardapa rrupiya mun-mama jilpa (silver) mu-maya minypa an-gugaliya mu-mangga a-workiya, jama a-jirra a-workiya gun-ngardapa ngorrngurra. Ganapiya, lika burr-jerrmarra gata mun-nigipa gurnal mu-jirra mu-nirra. ");
INSERT INTO bvr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Rrapa nuwurra waypa marnnga jina-warrchinga, nipa barrwa a-bona, burr-nana aburr-werranga gala jama gubi-rrimangarna wurra borijipa aburr-ninya gu-gandin gu-gera. ");
INSERT INTO bvr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Lika a-wena burrwa, ‘Ana-goyburrpa burr-guta buburr-boy, gun-nardiya geka barra jama nyiburr-ji mun-ngaypa gurnal mun-gaba mu-jirra mu-nirra gun-ngaypa rrawa. Burraya yi-rrana gu-ni barra, jechinuwa arr-wupa barra rrupiya, minypa jama nyiburr-ji apula.’ ");
INSERT INTO bvr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Lika aburr-bona aburr-ni. “Lika nuwurra waypa marnnga waykin jiny-ji minypa dina rrapa barrwa jiny-jakiyana minypa jarlawurr mula gu-jirra gu-jinyjarra jiny-jinyja, nipa ana-bona, barrwa aburr-werranga burr-menga. ");
INSERT INTO bvr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Lika balngga gu-ni gu-nyiljinga, barrwa ana-bona, burr-nana aburr-werranga borijipa aburr-ninyapa. Lika a-wena burrwa, ‘An-nga nula ana-goyburrpa borijipa nyiburr-nirra nyiburr-workiya?’ ");
INSERT INTO bvr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Birripa aburr-wena nula, ‘Ngardawa gala ana-nga jama nyirr-wucharna.’ “Lika nipa a-wena burrwa, ‘Ana-goyburrpa burr-guta buburr-boy, jama buburr-ji mun-ngaypa gurnal mun-gaba mu-jirra mu-nirra.’ ");
INSERT INTO bvr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Lika nuwurra waypa yi-rrana gu-ni, nipa rrawa walang a-wena nula jaga an-guganapa, ‘Gonyja burrwa aburr-mujama yerrcha, rrapa barra burr-wu mun-birripa rrupiya minypa jama aburr-ji. Minypa aburr-gata jama aburr-ji jurdach, birripa mu-ngoyurra mbi-ma barra; ny-yirda barra ny-boy burr-wu barra, nuwurra waypa jurdach aburr-gata mu-ngoyurra jama aburr-ji mbi-ma barra.’ ");
INSERT INTO bvr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ganapiya, lika aburr-gata minypa jurdach jama aburr-ji, birripa ngardapa ngardapa mbi-menga aburr-bona mun-ngardapa rrupiya mun-mama jilpa mu-maya. ");
INSERT INTO bvr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Lika aburr-gata minypa mu-ngoyurra jama aburr-ji, birripa aburr-bona gurda, jimarn jarra wana mbi-manggarna. Wurra mbi-menga mun-maywapa mun-gata mun-ngardapa rrupiya mun-mama jilpa mu-maya. ");
INSERT INTO bvr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Wurra minypa mun-gata birripa mbi-menga, birripa minypa aburr-yirrchinga nula. Lika abu-wengganana rrawa walang, ");
INSERT INTO bvr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","aburr-yinanga nula, ‘A-lay, aburr-guna nginyipa jurdach burr-menga, birripa jama aburr-ji gun-baykarda ngika; wurra jarra ngayburrpa gun-baykarda jama nyiburr-ji, ji-marnnga nyin-dana minypa ngulamgaba jiny-jamuna, yi-rrana gu-ni arrburrwa gugu. Wurra an-nga nula nyirr-mulpuna, gu-ngardapa nyirr-negarra, rrupiya nyirr-wuna ngardapa ngardapa mun-gatiya mun-maywapa? Wurra jimarn jarra ngayburrpa wana nyibu-manggarna.’ ");
INSERT INTO bvr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Wurra nipa a-wena nula an-ngardapa, ‘A-lay, japurra ngapa ny-jirra, wurra ngaypa gala ngiy-gaypungarna. Wurra minyja borrwa: Nginyipa mu-ngoyurra ny-yagurrmurra apula mun-gata nula rrupiya, minypa mun-ngardapa mun-mama jilpa mu-maya. ");
INSERT INTO bvr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ganapiya. Ga boy mun-nginyipa. Wurra gun-ngaypa jal ngaypa ngu-wuna an-guna minypa jurdach jama a-ji, nipa mu-menga mun-maywapa rrupiya minypa nginyipa ny-menga. ");
INSERT INTO bvr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Wurra waygaji nginyipa ny-borrwuja jimarna mun-ngaypa rrupiya ngaypa gala ngu-yinmiya minypa gun-ngaypa jal, ya? Wurra waygaji mu-werrmbarra nyi-nacha an-guna an-gugaliya minypa ngaypa ngu-mola nula, ya?’” ");
INSERT INTO bvr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Lika Jesus gu-mungbuna a-wena, a-yinagata, “Gu-gurda ngacha minypa gun-gata ngaypa ngu-wena, ‘Aburr-gata jurdach aburr-jirra, birripa barra mu-ngoyurra aburr-ji; rrapa aburr-gata mu-ngoyurra aburr-jirra, birripa barra jurdach aburr-ji.’” ");
INSERT INTO bvr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Gun-gatiya Jesus a-bamuna Jirúchalam (Jerusalem), nipa burr-ganyja aburr-yigipa wupa 12 gu-galiya yerrcha ngardapa, lika a-wena burrwa aburr-bamuna. ");
INSERT INTO bvr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Buburr-galiya apula: Ngayburrpa Jirúchalam nguburr-boya rrapa an-guna An-walkurpa An-gugaliya gatiya abi-rrimapa barra, burrbu-wu barra aburr-gata wana junggay yerrcha rrapa joborr marn․gi aburr-gunega. Rrapa birripa mari wana gubu-garra barra nula minypa nipa a-juwa barra. ");
INSERT INTO bvr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Lika burrbu-wu barra Jentayl (Gentile) yerrcha an-guna barra birripa abu-borrkpa rrapa abu-jurrburaykujama, rrapa minypa burr-jong abi-negapa barra abi-rra. Wurra gu-gata wenga ngorrngurra abirri-jirrapa gun-ngardapa, lika nipa Wangarr ana-nyala a-jarrkarra barra rrapa wanngu a-nega.” ");
INSERT INTO bvr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Gu-gata wenga jin-gata mampa buta Jebadi (Zebedee) bijirri-yika walkurpa yerrcha bijirri-ganyja gurda nula Jesus, lika ji-menama gu-rrana nula, a-wengganana minyja a-gunggaja achila. ");
INSERT INTO bvr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Lika Jesus jiny-yengganana, “A-jay, an-nga jal nyi-nirra?” Nipa jiny-yinanga, “A-lay, ngaw minyja nginyipa ny-yengga barra minypa nuwurra waypa bunggawa nyi-ni, abirri-guna abirri-ngaypa delipa yerrcha gatiya wugupa nggula bunggawa nyiburr-ni barra? Minypa nginyipa ny-jera abirri-ni barra ngguluwa nyi-munganaguwa rrapa ny-yeyka.” ");
INSERT INTO bvr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Wurra Jesus a-wena butula, “Ana-gotipa gala marn․gi gun-nga nyirri-ngiwijarra apula. Wurra ana-gotipa ganyjarr nyirri-dimanga, ya, minypa ngaypa ngu-rrimanga? Wurra ngaypa jarra ngu-rrimanga ganyjarr ngunabu-bu barra ngu-jortcha. Minypa gun-maywapa ranginy Ngun-anya nguna-wuna mun-guralba mun-gata mu-jerrjerrjinga mernda a-jirra ana-guyinda barra ngu-bay, wurra gun-burral minypa ngu-juwa barra. Wurra ana-gotipa gun-mola gu-gata ngacha nyirri-ma barra, ya?” Bitipa aburr-yinanga, “Ngaw, gun-mola atila nyirri-ma barra.” ");
INSERT INTO bvr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Lika Jesus a-wena butula, “Ngaw, ngarla, ana-gotipa minypa gun-maywapa nyirri-bay barra mun-gata mun-guralba mun-guyinda an-ngaypa mernda a-jirra ana-guyinda, wurra ngaypa gala ngu-yinmiya ngu-wengga rraka ana-gotipa ng-gera nyirri-ni apula ny-nyardapa ngu-munganaguwa rrapa ny-yerranga ngu-weyka. Wurra gu-gata ngacha gubirri-ma barra abirri-gata abirri-nga minypa nipa Ngun-anya gipa bijirri-borrwurra rrapa nawanawa a-ni butula.” ");
INSERT INTO bvr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aburr-werranga Jesus burr-yika jawina yerrcha aburr-gata murna arr-jirra arr-jirrapa, birripa aburr-galiyana gun-gata minypa worlapa niya bitipa wupa abirri-wengganana Jesus, lika birripa minypa aburr-bachirramiyana butula. ");
INSERT INTO bvr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Wurra Jesus a-gonyjinga burrwa, aburr-bona gurda nula, lika nipa a-wena burrwa a-ni. “Ana-goyburrpa marn․gi burrwa Jentayl bunggawa an-guyinda minypa birripa jama wana burrbu-wucha aburr-workiya. Ana-goyburrpa marn․gi burrwa aburr-gata minypa mu-ngoyurra aburr-jirra burrwa Jentayl yerrcha, minypa birripa wana aburr-negiya burrwa aburr-workiya aburr-birripa gu-galiya yerrcha. ");
INSERT INTO bvr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Wurra ana-goyburrpa gala barra nyiburr-yirda ana-gorrburrwa gu-gapa gu-guta. Wurra ana-goyburrpa jarra minyja ny-yinga ny-jata jal nyi-ni wana nyi-ni barra burrwa aburr-guna aburr-werranga, wurra jarra delipa nyi-negiya barra burrwa. ");
INSERT INTO bvr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Minyja jal nyi-ni mu-ngoyurra ny-ji barra burrwa, wurra burdak nyi-mujama nyi-ni barra burrwa ");
INSERT INTO bvr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","gun-maywapa minypa an-guna An-walkurpa An-gugaliya ana-bona ngika barra wurra gama gorlk aburr-mujama burr-nega, wurra jarra nipa barra an-mujama a-ni burrwa rrapa a-juwa barra minypa barra burr-ma gu-galiya yerrcha nuluwa Wangarr.” ");
INSERT INTO bvr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Gun-gata waypa Jesus rrapa aburr-yigipa jawina yerrcha gubu-bawuna aburr-garlmuna rrawa Jerikow (Jericho), aburr-jaranga gu-galiya yerrcha abu-jurrjurrmurra an-gata Jesus. ");
INSERT INTO bvr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Wurra gata gu-jarlakarr gu-rrarnba abirri-ninya abirri-jirrapa abirri-gapula. Rrapa gun-gatiya waypa bitipa gubirri-borrwurra nipa Jesus a-jarl a-bamuna, lika abirri-gonyjinga nula, “Bunggawa, a-lay, ny-junarda nipa Daybit murna biy-wuna arrburrwa, gunggaja atila, a-lay!” ");
INSERT INTO bvr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Abirri-yinagata abirri-gonyjinga nula Jesus, wurra gu-galiya yerrcha burrbu-jobujobuna rrapa aburr-wena butula barra gun-ngap gubirri-bawa. Wurra bitipa mu-nguy burr-guya abirri-gonyjinga, “Bunggawa, a-lay, ny-junarda nipa Daybit murna biy-wuna arrburrwa, gunggaja atila, a-lay!” ");
INSERT INTO bvr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Lika Jesus a-derichinga, a-gonyjinga butula. Lika yi-gurrepa abirri-ni, bijirri-wengganana, “A-lay, ana-gotipa jal nyirri-nirra ngaypa ngu-yinmiya barra ana-gotula?” ");
INSERT INTO bvr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bitipa abirri-wena, “Bunggawa, ngatipa jal nyirri-nirra nyirri-gana barra, ngarla!” ");
INSERT INTO bvr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Lika Jesus a-worijinga butula, lika mun-barra mu-rrimarra butula, lika gu-gata wenga gugu abirri-ganana. Ganapiya, lika abirri-jurrjurrmurra Jesus. ");
INSERT INTO bvr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Gun-gatiya Jesus rrapa aburr-yigipa jawina yerrcha aburr-bamuna gurda yi-gurrepa Jirúchalam (Jerusalem), birripa aburr-bena mu-mirk mun-gata mun-nelangga Alip (Olive) Mu-jirrapa rrapa gun-murna rrawa gun-gata gun-nelangga Betpey (Bethphage). Lika Jesus bijirri-jerrmarra abirri-yigipa jawina abirri-jirrapa, ");
INSERT INTO bvr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","minypa a-wena butula, “Birri-boy gun-gata rrawa mu-ngoyurra guna-jirra, gun-nardiya gugu nyirri-barripa barra dongki jiny-bandawiya jiny-jirra rrapa an-nigipa delipa wugupa achila. Lika ana-gotipa birri-yarlayarlawa burrinyjula, burrbu-ga gurda apula jin-babalapa rrapa an-nigipa delipa. ");
INSERT INTO bvr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Rrapa minyja ana-nga a-wengga ana-gotula, birri-wengga nula, ‘Bunggawa jal a-nirra burrinyjula abirriny-juna.’ Lika an-gatiya yibirrich bijirriny-jerrma barra gurda.” ");
INSERT INTO bvr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ganapiya, lika gu-yinagata gugu minypa barra gun-burral gu-ni minypa Wangarr an-nika an-mujaruk ngunyuna an-guyinda wola mu-ngoyurra a-wena, a-yinagata, ");
INSERT INTO bvr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Wengga burrwa aburr-gata rrawa Jayan (Zion) aburr-nirra, gu-gatiya burr-yika gu-ngarda yerrcha ny-yengga barra burrwa, ‘Bubi-na: An-gata an-goyburrpa Bunggawa ana-boya ana-gorrburrwa nipa an-dor, minypa dongki ana-jonama a-nirra ana-bamburda, dongki an-delipa an-gata burdak mampa niya jaga jiny-janaja nula.’” ");
INSERT INTO bvr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","A-yinagata a-wena Wangarr an-nika an-mujaruk wola mu-ngoyurra, rrapa gu-gurda ngacha minypa abirri-gata Jesus bijirri-yika jawina abirri-bona, abirri-yinagata minypa nipa Jesus a-wena butula. ");
INSERT INTO bvr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Minypa burrbu-ganyja gurda nula abirriny-jata dongki yerrcha jin-babalapa rrapa an-delipa. Lika mun-bitipa molma mun-gunegiya mirikal mbirri-gurrmurra abirriny-jonama, wurra jarra Jesus a-warrchinga, mu-rrenyjinga a-ni an-delipa dongki ana-jonama. ");
INSERT INTO bvr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Rrapa burr-guya aburr-jaranga gu-galiya yerrcha mbi-yarlanggaja nula aburr-bona gu-jarlakarr minypa mun-birripa molma mun-gunegiya mirikal, barra minypa abirriny-jata dongki mbirrin-denyja abirriny-bamba minypa Jesus ana-delipa ana-guyinda dongki ana-jonama a-ni a-bamuna; rrapa aburr-werranga gun-jong mula gu-jirra gubu-rrumurra rrapa gubi-yarlanggaja nula. ");
INSERT INTO bvr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Aburr-werranga aburr-bona mu-ngoyurra rrapa aburr-werranga aburr-bona gurda jurdach, aburr-gatiya wupa aburr-bulapalawa aburr-gonyjinga aburr-bamuna, “Japurra ngapa a-jirra! An-guna nipa Daybit murna a-wuna arrburrwa! Wangarr barra gun-molamola gu-nega barra nula an-guna nipa ana-jerrmarra! Rrapa waykin aburr-guyinda, birripa an-molamola abu-ngurrja barra Wangarr!” ");
INSERT INTO bvr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Aburr-yinagata aburr-gonyjinga aburr-bamuna, aburr-bena rrawa Jirúchalam. Rrapa gu-galiya yerrcha Jirúchalam aburr-nirra aburr-yurtchinga gurda aburr-yurtchinga, aburr-wengganachichiyana aburr-ni gu-gapa gu-guta, “A-lay, an-guna ana-nga?” ");
INSERT INTO bvr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Lika aburr-gata wugupa nula Jesus aburr-bamuna gurda, birripa aburr-wena burrwa, aburr-yinagata, “A-lay, an-guna Jesus. Nipa Wangarr an-nika an-mujaruk Nejarach (Nazareth) an-guyinda, gun-gata rrawa wana gu-bapala gu-rrawa Galali (Galilee).” ");
INSERT INTO bvr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Gu-gata wenga Jesus a-barrngumurra Wangarr gun-nika gu-japurra rrawa, lika nipa burr-yerrnyjinga aburr-gata minypa bayim aburr-ni rrapa jalim aburr-ni gatiya. Minypa aburr-werranga aburr-gatiya rrupiya mbi-ngukurdanyjinga aburr-workiyana burrwa wurra gama gorlk, nipa gu-yerrnyjinga burrwa a-ni rrupiya burr-guta. Rrapa aburr-werranga aburr-gata minypa mukumul jin-guyinda jalim aburr-ni, barrwa nipa minypa gu-yerrnyjinga burrwa gun-birripa gun-gurrenyja gun-guni. ");
INSERT INTO bvr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","A-yinanga a-wena burrwa, “Janguny mu-jurra gu-yurra minypa Wangarr a-wena, a-yinanga, ‘Gun-ngaypa bala gubu-ngurrja barra aburr-workiya wurra gama gorlk, aburr-yinda barra, “Gata gu-bala abu-wengganacha aburr-workiya Wangarr.” ’ Gu-yinagata gu-yurra janguny, wurra jarra ana-goyburrpa werra nyibi-nenga nula nyiburr-nirra gun-nigipa bala, ngunyuna gu-galiya yerrcha nyirrbu-gaypurda nyiburr-workiya, jalim nyiburr-nirra burrwa nyiburr-workiya.” A-yinagata Jesus a-wena, nipa burr-yerrnyjinga a-ni. ");
INSERT INTO bvr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ganapiya, wurra an-gapula an-guyinda rrapa an-burda an-guyinda aburr-bona gurda nula Jesus gata gu-bala Wangarr gun-nika, lika nipa wanngu burr-negarra. ");
INSERT INTO bvr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Wurra jarra aburr-gata wana junggay yerrcha rrapa barrwa joborr marn․gi aburr-gunega, birripa aburr-bachirramiyana nula Jesus minypa abi-nana nipa burr-barlmarrk jama a-ji, rrapa minypa gu-ngarda yerrcha gatiya gu-japurra rrawa aburr-gonyjinga aburr-ji, abu-burrmaymbuna minypa aburr-yinanga, “Japurra ngapa a-jirra! An-guna nipa Daybit murna a-wuna arrburrwa!” Gu-gurdiya nula aburr-gata wana junggay yerrcha aburr-bachirramiyana nula Jesus, ");
INSERT INTO bvr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","lika aburr-garlmuna, aburr-wena nula, “Ya? Ny-jaliyarra burrwa aburr-guna gu-ngarda yerrcha aburr-weya? Wurra yama burr-jobujoba?” Wurra Jesus a-yinanga burrwa, “Ngaw, gipa ng-galiyana. Wurra ana-goyburrpa gala nyibi-nacharna mu-jurra gu-yurra, ya? Minypa gu-yinaga gu-weya, ‘Bunggawa, nginyipa gun-guburrmaymba ny-jarlapuna nggula gun-molamola warrpam minypa yokuyoka rrapa gu-ngarda yerrcha birripa ngana aburr-jirra aburr-weya.’” ");
INSERT INTO bvr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ganapiya, lika Jesus burr-bawuna, Jirúchalam wenga a-bona Bechini (Bethany), minypa gatiya nipa a-ninya. ");
INSERT INTO bvr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Aburr-yu, guna-gepana, lika Jesus a-garlmuna, ana-jekarra ana-bamuna Jirúchalam. Wurra nipa a-werrmiyana balaja ngardawa gala m-bangarna. ");
INSERT INTO bvr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Lika gu-jarlakarr gu-rrarnba nipa mu-nana gun-jong mun-gata balaja mu-rrimanga mu-workiya mun-nelangga wagarrich. Lika nipa a-jarl a-bamuna, jimarn jarra balaja m-barripungarna, wurra gun-nyagara, wurra jarlawurr wupa gu-nana. Lika a-wena nula gun-gata gun-jong, “Ny-jurda nginyipa gala ny-yinmiya barrwa barra balaja n-dima!” Lika yibirrich gun-gata gun-jong gu-gorlapunapa. ");
INSERT INTO bvr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Rrapa gun-narda waypa Jesus burr-yika jawina gubi-nana, birripa gochila aburr-barrjinga. Lika abu-wengganana Jesus, “A-lay, gun-guna gun-jong gu-yinmiyana gu-gorlapuna yibirrich, ya?” ");
INSERT INTO bvr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Wurra Jesus a-yinanga burrwa, “Gun-guna ngu-weya ana-gorrburrwa gun-burral: Minyja nginyipa marr ny-balcha rrapa gala ny-jeka, nginyipa ny-yirda barra jama ny-ji, wurpa lika ngika minypa ngaypa ngu-wena nula gun-guna gun-jong gun-narda wupa ngardapa. Wurra minypa nginyipa marr ny-balcharra minyja nginyipa ny-yengga nula mun-guna mun-mirk, ‘Garlma! Boy, yerrnyjiya gu-bugula gu-bachirra!’ lika gu-yinardiya barra; Wangarr jama a-ji barra nggula rrapa mun-gata mun-mirk mu-yerrnyjiya barra gu-bugula gu-bachirra. ");
INSERT INTO bvr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Rrapa barrwa gun-nga burr-guta ny-yenggana Wangarr, gun-gatiya ny-ma barra minyja nginyipa marr ny-balcha.” ");
INSERT INTO bvr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesus mu-nguy ana-bamunapa a-bena nula gun-japurra rrawa, lika a-barrngumurra. Rrapa gatiya waypa wurra gama gorlk nipa marn․gi burr-negarra a-ni janguny, lika wana junggay yerrcha rrapa barrwa aburr-werranga mu-murna yerrcha, birripa aburr-bona gurda nula Jesus, lika abu-wengganana, “Ya? Ana-nga a-wena nggula gu-gurda ngacha jama ny-jirra?” ");
INSERT INTO bvr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesus a-yinanga burrwa, “Ngaypa burdak arr-wenggana barra gun-ngardapa ana-goyburrpa nyibu-ngurrja apula, nuwurra waypa jurdach ngaypa ngu-ngurrja barra ana-gorrburrwa ana-nga nguna-wuna ganyjarr ngaypa jama ngu-jirra. ");
INSERT INTO bvr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Wurra ana-nga a-wuna Jon gun-gata bama gun-gugurraga nipa bama burr-gurragaja a-workiyana? Nipa Wangarr, wurra waygaji an-gugaliya, ya?” Jesus a-yinagata a-wena burrwa, wurra birripa aburr-garlmunapa aburr-wengganachichiyana aburr-ni birripa wupa, minypa aburr-yinanga, “A-lay, ngayburrpa nguburr-yinmiya barra? Minyja gala yapa nguburr-yindin ‘Wangarr a-wuna bama gun-gugurraga nipa Jon;’ gala yapa nipa an-guna a-yindin arrburrwa, ‘An-nga nula rrapa ana-goyburrpa gala marr nyiburr-balcharna nula?’ ");
INSERT INTO bvr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Wurra gala barra nguburr-yinda, ‘An-gugaliya a-wuna bama gun-gugurraga gun-gata;’ gala yapa aburr-gata gu-galiya yerrcha aburr-bachirramiyan arrburrwa. Ngardawa birripa gubu-borrwurra, jimarna bama aburr-yinaga Jon a-wena a-workiyana Wangarr gun-nika.” ");
INSERT INTO bvr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Lika aburr-gata wana junggay yerrcha rrapa barrwa aburr-werranga mu-murna yerrcha, birripa aburr-yinagata nula Jesus, “Gala ngayburrpa marn․gi.” Lika Jesus a-wena burrwa, “Rrapa ngaypa gala ngu-yinmiya ngu-wengga ana-gorrburrwa ana-nga nipa a-wena ngaypa jama ngu-jirra. ");
INSERT INTO bvr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Marrka bubu-borrwa gun-guna, rrapa ana-goyburrpa barra nyibu-ngurrja apula. An-gugaliya a-ni, bijirri-dimarra abirri-jirrapa walkurpa niya yerrcha. Rrapa nipiya an-jirrpungapa a-wengganana an-murnangana, ‘Walkur, boy, geka barra jama ny-ji mun-ngayburrpa gurnal mu-jirra mu-nirra.’ ");
INSERT INTO bvr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Wurra an-walkurpa a-wena, ‘Ngika. Gala barra ngu-boy.’ A-yinagata, wurra nuwurra jurdach waypa nipa gu-borrwurra, lika a-bona, jama a-ji. ");
INSERT INTO bvr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Rrapa nyanyapa buta a-jekarra, barrwa an-delipa a-wengganana gun-maywapa. Lika nipa ana-delipa gu-yagurrmurra nula, ‘Ngaw, anya, ngu-boy barra,’ wurra jarra gala a-boyarna. ");
INSERT INTO bvr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Ganapiya gun-gata janguny. Wurra marrka ana-goyburrpa bubu-ngurrja apula: Ana-nga jama a-ji minypa nyanyapa niya a-wena nula?” Birripa aburr-wena, “Ana-murnangana.” Lika Jesus a-yinagata burrwa, “Gun-guna ngu-weya ana-gorrburrwa gun-burral: Aburr-gata aburr-mujama nula gapman rrupiya mbi-mangga nula aburr-workiya, gu-galiya yerrcha burrbu-gaypurda, rrapa ji-gata ngacha minypa gun-nerra jama jiny-jirra jiny-yorkiya marrambay gun-guji, aburr-gurdiya ngacha gu-galiya yerrcha minypa wuriya jama aburr-ji gun-nerra, wurra jarra gubu-bawuna rrapa aburr-ngukurdanyjiyana, birri-gugu aburr-boya, Wangarr ana-murna aburr-ni barra. ");
INSERT INTO bvr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ngardawa Jon an-gata bama burr-gurragaja a-workiyana, nipa nyirr-gurdagurdarrana ana-goyburrpa jarlakarr, jimarna ana-goyburrpa jechinuwa nyiburr-ningarna. Wurra ana-goyburrpa gala marr nyiburr-balchingarna nula. Wurra jarra aburr-gata aburr-mujama nula gapman rrupiya mbi-mangga nula aburr-workiya, gu-galiya yerrcha burrbu-gaypurda, rrapa ji-gata ngacha minypa gun-nerra jama jiny-jirra jiny-yorkiya marrambay gun-guji, aburr-gurdiya ngacha marr aburr-balcha nula Jon gun-nigipa janguny. Wurra jarra ana-goyburrpa wuriya nyirrbi-nana birripa aburr-yinagata, wurra ana-goyburrpa gala nyiburr-ngukurdanyjiyarna rrapa marr nyiburr-balchingarna nula an-gata. ");
INSERT INTO bvr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Buburr-galiya apula barrwa meyali gu-murna ngu-ngurrja barra ana-gorrburrwa. Minypa rrawa an-gurrimapa, ngarla, a-lamajinga nipa mun-gata gurnal mun-murra mu-jinyja. Lika nipa jandarra gu-gurrmurra, gu-ji gu-gomarriyana. Rrapa barrwa rralala gu-jarlapuna gu-jandarra gu-guyinda barra minypa mbi-birlkaka mun-gata gurnal rrapa gatiya mbi-ma mun-gata mun-girra. Rrapa barrwa nipa gu-jarlapuna gun-baykardakarda gu-jinyja minypa dawa (tower), barra minypa mbi-na aburr-ji gurnal, gala yapa mun-ngumurda m-boy burrwa. Ganapiya, lika burr-menga gu-galiya yerrcha barra rrawa aburr-ni rrapa jaga aburr-gana mun-gata gurnal. Lika nipa rrawa an-gurrimapa gu-bawuna a-bona balay nuwurra waypa gu-yinpa ana-jeka. ");
INSERT INTO bvr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Ganapiya, lika gu-bamuna, mun-gata gurnal mun-mola mu-ni barra birripa mbi-ma. Lika an-gata an-gurrimapa aburr-yigipa aburr-mujama burr-jerrmarra gurda burrwa aburr-guna jaga aburr-ganana mun-gata gurnal, jimarn jarra birripa aburr-guna mbi-ngorrkorndangarna aburr-nirrarna, lika mbi-jerrmangarna nula mun-nigipa nipa an-gata an-gurrimapa. ");
INSERT INTO bvr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Wurra aburr-guna jaga aburr-ganana gurnal, birripa burrbi-rrimarra aburr-gata aburr-mujama, lika an-ngardapa abu-jurrburaykujamurra, an-nerranga abu-buna, a-juwuna, rrapa barrwa an-nerranga gu-jandarra abu-buna. ");
INSERT INTO bvr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Wurra nipa an-gurrimapa barrwa aburr-jaranga burr-jerrmarra gurda aburr-yigipa aburr-mujama, wurra aburr-guna jaga aburr-ganana aburr-workiyana mun-gata gurnal, birripa burrbu-buna, laka burrbu-ganyja. ");
INSERT INTO bvr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Lika gu-gata wenga nipa an-gurrimapa ana-jerrmarra burrwa an-nigipa an-walkurpa. Minypa gu-borrwurra a-ni, a-yinagata, ‘Birripa marr aburr-balcha barra nula an-ngaypa walkur.’ ");
INSERT INTO bvr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Wurra aburr-guna jaga aburr-ganana mun-gata gurnal, birripa waypa abi-nana an-walkurpa a-bena, birripa wupa aburr-wengganachichiyana aburr-ni, ‘A-lay, an-guna, ngarla, burraya an-gurrimapa murna a-wu barra mun-nigipa mu-ni mun-guna gurnal mun-murra mu-jinyjarra! Wurra yama ngubu-bu barra mun-ngayburrpa mu-ni?’ ");
INSERT INTO bvr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Lika aburr-garlmuna, abi-rrimarra, abi-yerrnyjinga yarlanga, lika abu-buna, a-juwuna. ");
INSERT INTO bvr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Gun-narda janguny, wurra nuwurra waypa an-gurrimapa ana-jeka barra, nipa a-yinmiya barra burrwa aburr-guna jaga aburr-ganana mun-gata gurnal?” ");
INSERT INTO bvr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Birripa aburr-wena, “Nipa burr-bu barra, ngarla! Lika aburr-werranga burr-ma barra birripa jaga aburr-gana barra nula mun-gata gurnal, aburr-gata ngacha minypa abu-wu barra aburr-workiya.” ");
INSERT INTO bvr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Lika Jesus a-wena burrwa, “Wurra janguny mu-jurra gu-yurra ana-goyburrpa gala nyibi-nacharna, ya? Wurra gun-gata minypa gun-maywapa ranginy gu-yinaga gu-yurra, ‘Bala gubu-gupuna jandarra gu-maya, wurra gun-ngardapa jandarra gun-gata birripa aburr-ngoyurra gubi-yerrnyjinga. Wurra gun-narda barrwa Wangarr gu-menga, wana gun-babalapa gugu gu-jirra; jechinuwa gu-nenga gu-nirra rrawa. Gu-gurda ngacha minypa Wangarr jama a-ji, rrapa ngayburrpa ngubi-nacha minypa gun-gata burr-ganyjarr jama a-ji, ngarla!’ ");
INSERT INTO bvr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Wurra ngaypa ngu-weya ana-gorrburrwa Wangarr nyirr-gaypa barra gun-gata gun-nga minypa janguny ana-goyburrpa nyibi-rrimanga, wurra nipa burr-wu barra aburr-gata ngacha minypa burrbu-ma barra nula aburr-workiya gu-galiya yerrcha. ");
INSERT INTO bvr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","An-gata ana-nga minypa gu-guna gu-jandarra a-yerrnyja, a-bungga, an-gata an-gugaliya a-rrumurrmiya a-ni; wurpa lika an-gata minypa gun-guna jandarra gu-bunggapa a-rrenyja, nipa minypa an-ngukula a-nega.” ");
INSERT INTO bvr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Aburr-gata wana junggay yerrcha rrapa Berachi yerrcha, birripa waypa aburr-galiyana nula Jesus nipa gu-ngurrjinga burrwa gu-gata ngacha minypa meyali gu-murna janguny, birripa marn․gi minypa nipa burr-ngurrjinga a-ni birripa. ");
INSERT INTO bvr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Lika birripa jal aburr-ni jimarn jarra abi-rrimangarnapa, wurra minypa gu-galiya yerrcha aburr-gurkuja burrwa. Ngardawa gu-galiya yerrcha gubu-borrwurra nula minypa nipa Wangarr an-nika an-mujaruk. ");
INSERT INTO bvr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Lika Jesus barrwa a-wena burrwa meyali gu-murna, minypa a-yinanga, ");
INSERT INTO bvr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Gun-gata minypa Wangarr burr-yika gu-galiya yerrcha aburr-nirra nipa ana-murna, gun-narda minypa gun-guna gun-maywapa: An-gata an-ngardapa bunggawa, nipa janara gu-garrana a-ni, lika minypa barra balaja mbi-bay rrapa aburr-worlworlcha minypa an-nigipa an-walkurpa jiny-ma barra jin-nigipa jin-gumarrbipa niya. ");
INSERT INTO bvr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ganapiya, lika nipa burr-jerrmarra aburr-yigipa aburr-mujama barra burrbu-bamagutuwa wurra gama gorlk nipa mu-ngoyurra a-gonyjinga burrwa. Wurra birripa wurra gama gorlk aburr-jekarra; gala aburr-boyarna gurda. ");
INSERT INTO bvr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Lika barrwa aburr-werranga aburr-yigipa aburr-mujama burr-jerrmarra burrwa, minypa nipa a-wena, ‘Ngaypa gipa nawanawa ngu-ni, ganapiya. Wurra buburr-boy gurda, balaja ngubu-bay rrapa nguburr-worlworlcha barra minypa an-ngaypa walkur jiny-ma barra jin-nigipa jin-gumarrbipa niya. Gipa ngu-buna bulugi morrpiny ngacha jiny-nyarlkuch barra ngubu-bay.’ A-yinagata a-wena. ");
INSERT INTO bvr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Wurra aburr-gata minypa nipa bunggawa mu-ngoyurra a-gonyjinga burrwa, birripa gala aburr-galiyarrarna burrwa aburr-yigipa aburr-mujama. Minypa aburr-werranga burrbu-dalajinga, lika aburr-bona jama aburr-ji, minypa gu-gandin rrapa gu-birripa gu-rrawa; ");
INSERT INTO bvr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","rrapa minypa aburr-werranga burrbi-rrimarra, burrbu-buna, bunggawa burr-yika aburr-mujama aburr-juwuna. ");
INSERT INTO bvr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Gu-gata wenga an-gata bunggawa burr-guya a-bachirramiyana burrwa aburr-gata, lika an-dakal a-jerrmarra burrwa, burrbu-buna rrapa gubi-yalpuna burrwa gun-birripa rrawa. ");
INSERT INTO bvr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Lika nipa a-wena burrwa aburr-yigipa aburr-mujama, ‘Ngaypa gipa nawanawa ngu-ni barra balaja ngubu-bay rrapa nguburr-worlworlcha, minypa an-ngaypa walkur jiny-ma barra jin-nigipa jin-gumarrbipa niya. Wurra aburr-gata mu-ngoyurra ngaypa ng-gonyjinga burrwa, birripa gala aburr-molamola aburr-nirrarna apula rraka mbi-bangarna. ");
INSERT INTO bvr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Wurra buburr-boy, buburr-gonyja gurda burrwa aburr-yinmiyapa nyirrbi-na gu-jarlakarr aburr-rrigirrgnga. Barra birripa aburr-boy gurda ngunyuna, barra nguburr-worlworlcha rrapa balaja ngubu-bay.’ ");
INSERT INTO bvr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Lika aburr-gata aburr-mujama aburr-bona, burrbu-bamagutuwurra aburr-yinmiyapa birripa burrbi-nana gu-jarlakarr aburr-rrigirrgnga. Minypa aburr-molamola rrapa aburr-werra burr-guta burrbu-bamagutuwurra barra minypa gu-ngana aburr-maya gu-bala bunggawa gun-nika, minypa barra wugupa mbi-bay. ");
INSERT INTO bvr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Wurra nuwurra waypa bunggawa a-bena rrapa burr-nana aburr-gata gu-ngardapa aburr-negiyana nula gu-yigipa gu-rrawa, gatiya nipa a-nana an-ngardapa an-gugaliya gala a-barrbiyarna mun-mujanara mirikal. ");
INSERT INTO bvr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Lika bunggawa a-wena nula, ‘A-lay, ana-nga a-wena ngguluwa nyina-bona? Wurra mun-mujanara mirikal gala ny-barrbiyarna, ngarla!’ minypa nipa an-gata a-jurnjinga. ");
INSERT INTO bvr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Lika bunggawa a-wena burrwa aburr-yigipa aburr-mujama, a-yinagata, ‘An-guna bubu-bicha murna a-jirra rrapa rrepara a-jirra, lika bubi-yerrnyja yarlanga gatiya an-munya a-maya a-jirra, gatiya barra a-rruwuja a-ni a-workiya rrapa rrirra gu-bay.’” ");
INSERT INTO bvr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Lika Jesus janguny gu-mungbuna, a-yinagata a-wena, “Wangarr a-gonyjinga a-nirra burrwa aburr-bulapalawa gu-galiya yerrcha, wurra nipa aburr-jaranga ngika burr-ma barra; wurra jarra aburr-gurdowiya wupa burr-ma barra.” ");
INSERT INTO bvr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Gu-gata wenga aburr-gata Berachi (Pharisee) yerrcha aburr-bona, wengga gubu-buna aburr-ni birripa aburr-yinmiya barra mari gubu-garra nula Jesus, minypa abu-wenggana gun-nga rrapa nipa a-yinmiya barra a-yolkiya a-wengga. ");
INSERT INTO bvr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ganapiya, lika burrbi-jerrmarra gurda nula Jesus aburr-yinmiyapa jawina, minypa Berachi yerrcha burr-yika rrapa Ayrat (Herod) burr-yika jawina aburr-bena nula, abu-wengganana, “Bunggawa, a-lay, ngayburrpa marn․gi nggula minypa jechinuwa ny-yeya ny-yorkiya gun-burral, minypa nginyipa nyirr-gurdagurdarraja ny-yorkiya Wangarr gun-nika jarlakarr. Ngardawa nginyipa gala ana-nga ny-jurkuja nula wurpa niya an-gata an-nelangga wana, wurra jechinuwa ny-yeya ny-yorkiya gun-burral. ");
INSERT INTO bvr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Wurra ngaw minyja ny-yengga arrburrwa gun-nga nginyipa ny-borrwurra? Gun-ngayburrpa joborr gu-yinmiya gu-yurra? Gun-gata minypa bunggawa an-gata Rowm (Rome) a-nirra nipa rrupiya arr-gaypurda a-workiya minypa dek (tax), gun-narda gun-mola arrburrwa ngayburrpa nguburr-guna Yichrayal (Israel) nguburr-guyinda ngubu-wu, ya? Wurra gun-nyagara, ya?” ");
INSERT INTO bvr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Wurra Jesus nipa marn․gi birripa abu-yolkaja aburr-ni. Lika nipa a-yinanga burrwa, “Ana-goyburrpa nyiburr-gurda waykin nyiburr-molamola; wupa nyiburr-werra! Wurra an-nga nula ngunabu-yolkaja nyiburr-nirra, ya? ");
INSERT INTO bvr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Jarra ngunabu-gurdagurdarra mun-gata rrupiya minypa dek (tax) nyibu-barnjinga nyiburr-workiya.” Lika mu-gata ngacha rrupiya mun-mama an-ngardapa an-gata a-yurtchinga, mun-ngardapa mu-menga, muna-ganyja gurda nula Jesus. ");
INSERT INTO bvr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ganapiya, lika Jesus a-wena burrwa, “Mun-guna an-mawunga ana-nga? Rrapa an-guna an-nelangga ana-nga?” ");
INSERT INTO bvr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Birripa aburr-yinagata nula, “An-narda Jija (Caesar) an-gata Rowm a-nirra bunggawa.” Lika nipa a-yinagata burrwa, “Jija nipa bubu-wu mun-nigipa Jija mun-nika. Wurra ana-goyburrpa nyiburr-burral buburr-wuya nula Wangarr, ngardawa gu-galiya yerrcha aburr-yigipa.” ");
INSERT INTO bvr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Gun-gata waypa birripa aburr-galiyana, gochila aburr-barrjinga. Lika abu-bawuna; aburr-bona lika. ");
INSERT INTO bvr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Gun-gata gun-maywapa ngorrngurra aburr-werranga Jejuchi (Sadducee) yerrcha aburr-bona gurda nula Jesus, aburr-gata birripa aburr-weya aburr-workiya jimarna bama aburr-yinaga an-gugaliya a-juwiya a-workiya Wangarr gala a-yinmiya barrwa a-jarrkarra. Aburr-gurdiya Jejuchi yerrcha aburr-bona gurda, lika abu-wengganana Jesus, ");
INSERT INTO bvr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Bunggawa, a-lay, nipa Mojich (Moses) a-wukurrjinga arrburrwa gun-gata joborr, minyja an-gugaliya jin-nigipa jin-gumarrbipa niya jiny-bawa minypa a-juwa, wurra nipa jin-gata gala delipa a-mengarna, lika an-gata an-nigipa worlapa niya jiny-ma barra jin-gata gama barra delipa a-barripa butula an-bitipa an-murnangana gipa mu-ngoyurra a-juwuna. Gu-gurda ngacha. ");
INSERT INTO bvr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Wurra gun-guna rrawa mu-ngoyurra aburr-ni worlapa burra yerrcha birripa wupa arr-ngardapa arr-murna rrapa abirri-jirrapa, minypa 7, an-gata an-murnangana jin-gumarrbipa jin-dimarra, wurra a-juwuna, gala delipa a-rrimangarna. ");
INSERT INTO bvr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Lika minypa a-jurrjurrmurrapa jin-gata jiny-menga, wurra nipa a-yinagatiya. Rrapa barrwa a-guymurrapa a-yinagatiya. Rrapa aburr-werranga burr-guta worlapa niya yerrcha aburr-yinagatiya, minypa birripa wupa arr-ngardapa arr-murna rrapa abirri-jirrapa aburr-juwuna aburr-ni, wurra gala ana-nga delipa abi-rrimangarna. ");
INSERT INTO bvr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Lika gu-gata wenga rrapa jin-gata gama jiny-juwuna. ");
INSERT INTO bvr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Gun-narda janguny, wurra minyja Wangarr ngayburrpa arr-jarrkarra, lika jin-gata gama ana-nga jin-nika jin-gumarrbipa niya jinyu-ni barra, ya? Ngardawa gipa arr-ngardapa arr-murna rrapa abirri-jirrapa jibu-malapuna aburr-ni.” Aburr-yinagata aburr-gata Jejuchi yerrcha abu-wengganana Jesus, minypa birripa gubu-borrwurra, jimarna bama aburr-yinanga Wangarr gala a-jarrkarra an-gugaliya mu-ngoyurra a-juwuna. ");
INSERT INTO bvr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Wurra Jesus a-yinanga burrwa, “Ana-goyburrpa jarra nyiburr-yolkiya nyiburr-nirra! Ngardawa gala nyibi-nacharna meyali janguny mu-jurra gu-yurra, rrapa gala marn․gi ganyjarr gun-gata Wangarr gu-rrimanga. ");
INSERT INTO bvr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wurra aburr-gata Wangarr burr-jarrkarra barra wanngu aburr-ni, birripa minypa waykin aburr-guyinda gala barra abirriny-malapachichiya abirrinyu-ni. ");
INSERT INTO bvr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Wurra gun-gata minypa an-gugaliya a-juwiya a-workiya, gun-narda nula ngu-wengga barra ana-gorrburrwa minyja waygaji Wangarr a-jarrkarra, waygaji gun-nyagara. Wurra ana-goyburrpa gala nyibi-nacharna nyiburr-workiyarna mu-jurra gu-yurra, ya, gun-gata minypa Wangarr a-wena ana-gorrburrwa? ");
INSERT INTO bvr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Minypa nipa a-yinagata, ‘Ngaypa ng-guna Wangarr aburr-guna ngu-burriya: Aybriyam (Abraham) rrapa Ayjek (Isaac) rrapa Jeykap (Jacob).’ Nipa Wangarr a-yinagata a-wena wuriya aburr-gata minypa Aybriyam rrapa Ayjek rrapa Jeykap gipa mu-ngoyurra aburr-juwuna. Wurra yama ana-goyburrpa nyibu-borrwa? Minypa Wangarr nipa gala a-yinmiya an-birripa a-ni Wangarr minyja jimarna jarra gun-gata gun-nyagara gu-ni gun-gumungba. Ngika. Wurra jarra aburr-mola aburr-nirra Wangarr ana-murna.” ");
INSERT INTO bvr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Gun-narda wurra gama gorlk minypa aburr-galiyana, gochila aburr-barrjinga nula Jesus gun-nigipa janguny. ");
INSERT INTO bvr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Rrapa Berachi yerrcha gun-gata birripa aburr-galiyana minypa Jesus a-yinmiyana a-wena, rrapa minypa wengga burr-gaypuna aburr-gata Jejuchi yerrcha, lika birripa Berachi yerrcha wupa aburr-mulpiyana, ");
INSERT INTO bvr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","lika an-ngardapa an-birripa an-gata joborr marn․gi an-gunega, nipa a-wengganana Jesus, jimarna barra gu-janguny a-yolka minypa nipa Jesus a-yinmiya gu-ngurrja burrwa rrapa aburr-gatiya Berachi yerrcha mari gubu-garra nula. ");
INSERT INTO bvr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Minypa nipa an-gugaliya a-wena, “Bunggawa, a-lay, gun-ngiya joborr Wangarr gu-gurrmurra wana gun-babalapa, ya?” ");
INSERT INTO bvr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus lika a-wena nula, “‘An-goyburrpa an-ngardapiya ana-gorrburrwa Wangarr jal ni nula minypa burr-bama burr-molma burr-burral.’ ");
INSERT INTO bvr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Gun-nardiya joborr wana gun-babalapa mu-ngoyurra gu-jirra, ");
INSERT INTO bvr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","rrapa barrwa gun-nerranga gu-yinagatiya: ‘An-nginyipa an-borrmunga jal ni nula minypa nginyipa ngardapa nggu jal nyi-nirra nggula.’ ");
INSERT INTO bvr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Abirri-gurdiya abirri-jirrapa joborr nipa minypa banda gu-jirra gun-gata gun-jaranga joborr Mojich gu-barnjinga, rrapa gun-gata janguny burr-guta minypa Wangarr burr-yika aburr-mujaruk ngunyuna aburr-guyinda aburr-wena aburr-workiyana.” ");
INSERT INTO bvr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Gatiya waypa Berachi yerrcha aburr-mulpiyana nula, Jesus burr-wengganana, ");
INSERT INTO bvr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Gun-nga ana-goyburrpa nyibu-borrwuja Christ nula? Ana-nga murna a-wuna?” Birripa aburr-wena, “Nipa Daybit (David) murna a-wuna Christ.” ");
INSERT INTO bvr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nipa a-wena burrwa, “Minyja gun-narda gun-burral, gun-gata Mern An-mawunga wugupa nula Daybit, an-nga nula nipa a-ngurrjinga Christ Bunggawa? Minypa gun-gata nipa a-wena, ");
INSERT INTO bvr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Wangarr a-wena nula an-ngayburrpa Bunggawa, a-yinagata nula, “Burdak ngunyuna raka ngu-munganaguwa, nuwurra aburr-gata aburr-bachirra nggula ngaypa ay-gaba nguburr-nega barra nginyipa mu-ngoyurra ny-ji barra burrwa.” ’ ");
INSERT INTO bvr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Minyja Daybit a-yinagata a-wena a-workiyana rrapa bunggawa a-negarra Christ, gun-narda minypa nipiya Christ wana, jarra Daybit nyanma ngika.” ");
INSERT INTO bvr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jesus a-yinagata gu-ngurrjinga burrwa minypa aburr-gata aburr-jurnjinga. Rrapa gun-nardiya gugu gala ana-nga barrwa a-yinmiyarna a-wengganacharna gun-nga. ");
INSERT INTO bvr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Lika Jesus a-wena burrwa wurra gama gorlk rrapa aburr-yigipa jawina yerrcha burr-guta, minypa a-yinanga burrwa, ");
INSERT INTO bvr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Aburr-gata joborr marn․gi aburr-gunega rrapa Berachi (Pharisee) yerrcha, birripa jaga aburr-ganaja nula gun-gata Mojich (Moses) gu-barnjinga joborr, wurpa lika gala wupa aburr-ngurrnga gun-burral gubi-rrima gun-gata. ");
INSERT INTO bvr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Rrapa gu-gurda ngacha minypa ana-goyburrpa barra nyiburr-galiya burrwa nyiburr-workiya rrapa nyibu-borrwa burrwa gun-gata janguny birripa aburr-weya, wurra jama nyiburr-ji barra nyiburr-workiya ngika minypa birripa jama aburr-jirra. Ngardawa birripa gala jama aburr-ji minypa gun-gata joborr birripa gubu-ngurrjinga aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wurra jarra aburr-gugaliya nyanma birripa wupa joborr gun-derta gubi-nenga burrwa aburr-workiya wurra gama gorlk. Minypa gun-maywapa birripa gun-gun․gun gun-guyinda gubu-bichinga aburr-workiya, aburr-mobula gubu-gurrmunga burrwa aburr-workiya, wurra gala aburr-yinmiya mernda aburr-jirra aburr-jerrjangardawiya wurpa niya murna aburr-jirra aburr-yarlayarlawiya burr-guta, rraka aburr-gunggaja burrwa aburr-gata; wurra gun-nyagara. ");
INSERT INTO bvr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Birripa minypa aburr-yinmiya aburr-workiya, gun-gata ngardawa aburr-molamola aburr-negiya burrwa aburr-workiya wurra gama gorlk. Gu-gurda ngacha minypa wana abi-jarlapurda aburr-workiya an-gata minypa abu-garraja aburr-workiya aburr-bukula rrapa aburr-mernda, an-gata minypa nganybak a-maya, minypa joborr aburr-wukurrjinga gu-rrimangapa a-jirra. Minyja bubi-na, wana abi-jarlapurda aburr-workiya, rrapa barrwa mun-baykarda mbi-nenga aburr-workiya mun-gata murna mu-jirra mun-jaranga mun-birripa mun-gubarrbiya. Aburr-yinagata aburr-workiya aburr-gata joborr marn․gi aburr-gunega rrapa Berachi yerrcha, barra minypa gu-galiya yerrcha burrbi-na nganybak a-maya abu-garrana rrapa murna mun-baykarda aburr-barrngumurra, rrapa minypa gubu-borrwa burrwa birripa aburr-guna gubu-borrwuja joborr. ");
INSERT INTO bvr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Gun-birripa jal aburr-boya aburr-workiya, mu-ngoyurra aburr-rakaja minypa janara gu-jirra rrapa minypa wupa gu-bala Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Rrapa barrwa gun-birripa jal gu-galiya yerrcha aburr-nyala barra burrbu-burrmaymba aburr-boy rrapa bunggawa burrbi-nega wolawola birripa aburr-guna aburr-rrigirrgnga aburr-workiya gata gandin (canteen) gu-jirra gu-boya. ");
INSERT INTO bvr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Wurra ana-goyburrpa jarra, minyja ny-jata ny-yinga, wurra gala barra bunggawa bubi-nega, wurra worlapa nggu yerrcha rrapa minypa an-ngardapiya ana-gorrburrwa Bunggawa. ");
INSERT INTO bvr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Rrapa gala barra ana-nga nyibu-burrmaymba ‘Anya’, wurra jarra an-ngardapiya arrburrwa an-gatiya Nyanyapa arrku waykin a-nirra. ");
INSERT INTO bvr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Rrapa ny-yinga ny-jata, gala barra bubi-nega ny-birripa mu-ngoyurra ny-jirra burrwa, wurra jarra an-ngardapiya ana-gorrburrwa mu-ngoyurra a-jirra, nipa an-gata Christ. ");
INSERT INTO bvr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Wurra minyja ny-yinga ny-jata wana, nginyipa barra nyi-mujama nyi-ni burrwa aburr-werranga. ");
INSERT INTO bvr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ngardawa ana-nga an-gata wana a-negiya a-workiya, jarra Wangarr delipa a-nega barra an-gata an-gugaliya; rrapa ana-nga an-gata delipa a-negiya a-workiya, Wangarr nipa jarra wana a-nega barra. ");
INSERT INTO bvr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Awa! Nyiburr-gurda joborr marn․gi nyiburr-gunega rrapa Berachi (Pharisee) yerrcha, ana-goyburrpa burr-guya gun-nerra gu-ni barra ana-gorrburrwa! Ana-goyburrpa waykin nyiburr-molamola; wupa nyiburr-werra! Minypa gun-gata ana-goyburrpa gun-derta gun-gorla nyibi-nenga burrwa nyiburr-workiya wurra gama gorlk, gun-narda minypa gun-maywapa ranginy nyibi-jakaburda burrwa nyiburr-workiya ngana gu-jirra, rraka birripa gala aburr-yinmiya aburr-barrnguma rrapa aburr-ninya Wangarr ana-murna. Minypa ana-goyburrpa gala jal nyiburr-ni nyiburr-barrnguma, rrapa barrwa minypa nyiburr-gorlkakaja burrwa nyiburr-workiya aburr-werranga aburr-gata minypa jal aburr-nirra aburr-barrnguma. ");
INSERT INTO bvr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Awa! Nyiburr-gurda joborr marn․gi nyiburr-gunega rrapa Berachi yerrcha, ana-goyburrpa burr-guya gun-nerra gu-ni barra ana-gorrburrwa! Ana-goyburrpa waykin nyiburr-molamola; wupa nyiburr-werra! Balay nyiburr-boya nyiburr-workiya rrapa minypa gu-bachirra nyiburr-jurrwunga burr-guta, minyja rraka an-ngardapa an-gugaliya nyibu-ngukurdanyja ana-gorrburrwa gun-goyburrpa rum. Wurra minyja an-gugaliya a-yirda a-ngukurdanyjiya, gun-narda minypa ana-goyburrpa nyibu-yolkaja, nipa wugupa ana-gorrburrwa nyiburr-boy barra gu-bol. Wurpa lika minypa nipa ana-jirrapa ana-goma werra a-negiyana, minypa gun-gata mu-ngoyurra nipa gu-rrimarra, rrapa minypa jurdach gun-goyburrpa gu-rrimarra. Ngardawa ana-goyburrpa gala gun-burral wanngu gun-guni nyibi-rrimangarna. ");
INSERT INTO bvr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Awa! Ana-goyburrpa burr-guya gun-nerra gu-ni barra ana-gorrburrwa! Ana-goyburrpa minypa nyiburr-gapula; jarra ana-goyburrpa nyibu-borrwuja jimarna aburr-werranga ana-goyburrpa nyiburr-nyala nyirrbu-gurdagurdarraja nyiburr-workiya jarlakarr. Minypa ana-goyburrpa wupa nyanma nyiburr-weya nyiburr-workiya joborr, nyiburr-yinaga, ‘Ana-nga an-gata gochila a-rrana an-nerranga gun-nga, minypa burr-guya a-wena rrapa gun-nelangga gu-menga burr-guta gun-gata Wangarr gun-nika gun-japurra bala, wurra gun-narda ngika minypa jimarna gun-derta gu-nengarna gun-nigipa wengga. Wurra minyja gun-nelangga gu-ma goldan gu-maya gun-guyinda jarra, gun-nga gun-gata wupa gu-bala Wangarr gun-nika gun-japurra, gu-gurda ngacha minypa nipa gala a-yinmiya a-bamapa nula an-gata nipa gochila a-rranapa.’ ");
INSERT INTO bvr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ana-goyburrpa nyiburr-yinagata nyiburr-weya nyiburr-workiya minypa nyibu-ngorrkorndanga Wangarr gun-nika bala gun-japurra rrapa gun-gata goldan gu-maya gun-guyinda. Wurra jarra nyiburr-gapula rrapa nyiburr-gerna! Wurra bubu-borrwa: Gun-an․gaya wana? Minypa gun-gata goldan gu-maya gun-guyinda, waygaji gun-gata gun-japurra bala, ya? Wurra gun-gata bala gun-japurra jarra wana. Ngardawa gu-gatiya gu-bala gun-japurra gu-nenga gu-workiya gun-gata goldan gu-maya gun-guyinda, ngarla! ");
INSERT INTO bvr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Rrapa gun-nerranga gun-maywapa ranginy ana-goyburrpa nyiburr-weya nyiburr-workiya, nyiburr-yinaga, ‘Ana-nga an-gata gochila a-rrana an-nerranga gun-nga, minypa burr-guya a-wena rrapa gun-nelangga gu-menga burr-guta gun-gata belabila gu-maya gatiya minypa abu-wucha aburr-workiya Wangarr, wurra gun-narda ngika minypa jimarna gun-derta gu-nengarna gun-nigipa wengga. Wurra minyja an-nelangga a-ma minyjak an-gata abu-burnda nula Wangarr an-nika, gu-gurdiya ngacha gugu minypa nipa gala a-yinmiya a-bamapa nula an-gata nipa gochila a-rranapa.’ ");
INSERT INTO bvr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ana-goyburrpa joborr marn․gi nyiburr-gunega rrapa Berachi yerrcha nyiburr-yinagata nyiburr-weya nyiburr-workiya burrwa wurra gama gorlk, wurra ana-goyburrpa nyiburr-gapula, ngarla! Wurra gun-an․gaya wana? Minypa an-gata minyjak, waygaji gun-gata belabila gu-maya, ya? Wurra nipa gun-gata belabila gu-maya jarra wana. Ngardawa gu-gatiya gu-belabila an-japurra a-nenga gu-workiya an-gata minyjak, ngarla! ");
INSERT INTO bvr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Wurra ana-goyburrpa gala nyibu-borrwa, ya? Minypa an-gugaliya gun-nelangga gu-mangga a-workiya gun-gata belabila gu-maya, gun-narda minypa minyjak an-nelangga burr-guta a-mangga, ana-gata ngacha minypa abu-barnjinga aburr-workiya nuluwa Wangarr gatiya waykin gu-yigipa gu-belabila. ");
INSERT INTO bvr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Rrapa minypa an-gugaliya gun-nelangga gu-mangga a-workiya Wangarr gun-nika gun-japurra bala, gun-narda minypa Wangarr an-nelangga burr-guta a-mangga, an-gata ngardawa gun-nigipiya. ");
INSERT INTO bvr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Rrapa minypa an-gugaliya gun-nelangga gu-mangga a-workiya gun-gata waykin rrawa, gun-narda minypa rrawa waykin ngardapa ngika, wurra jarra Wangarr gun-nika gun-gurrenyja gun-guni gun-gatiya burr-guta, rrapa nipa an-gatiya ay-nirrapa ay-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Awa! Nyiburr-gurda joborr marn․gi nyiburr-gunega rrapa Berachi yerrcha, ana-goyburrpa burr-guya gun-nerra gu-ni barra ana-gorrburrwa! Ana-goyburrpa waykin nyiburr-molamola; wupa nyiburr-werra! Wurra wuriya gun-gata minypa gun-goyburrpa gun-guwarr ana-goyburrpa nyibu-ngorrkorndanga nyiburr-workiya rrapa nyibu-wucha nyiburr-workiya Wangarr mun-nigipa minypa balaja mun-gata nyibu-mangga nyiburr-workiya mun-ngiya mun-delipa burr-guta; wurra yama nyibu-borrwa wana gun-bapala gun-guyinda joborr minypa gun-guna? Minypa Wangarr nyiburr-jinyjapa barra nula nyiburr-workiya, rrapa wurra gama gorlk jechinuwa nyiburr-ni barra burrwa rrapa nyiburr-gunggaja barra burrwa nyiburr-workiya. Gu-gurda ngacha jimarna ana-goyburrpa nyibi-rrimangarna joborr rrapa gun-gata gun-delipa gun-guyinda burr-guta. ");
INSERT INTO bvr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ana-goyburrpa minypa nyiburr-gapula! Jarra ana-goyburrpa nyibu-borrwuja jimarna aburr-werranga ana-goyburrpa nyiburr-nyala nyirrbu-gurdagurdarraja nyiburr-workiya jarlakarr. Wurra minypa gun-maywapa ranginy ana-goyburrpa nyibu-banga nyiburr-workiya bugula, ana-goyburrpa nyibi-yerrnyjinga nyiburr-workiya gun-nerra gu-yurra minypa muya o gun-nga. Jarra gun-narda gun-delipa. Wurra nginyipa gala ny-borrwa, minypa nginyipa burr-gurla wurlk ny-janyja ny-yorkiya wana minypa yarraman. ");
INSERT INTO bvr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Awa! Nyiburr-gurda joborr marn․gi nyiburr-gunega rrapa Berachi yerrcha, ana-goyburrpa burr-guya gun-nerra gu-ni barra ana-gorrburrwa! Ana-goyburrpa waykin nyiburr-molamola; wupa nyiburr-werra! Ana-goyburrpa nyibu-borrwuja minypa burr-guya nyibu-weparda nyiburr-workiya japalana an-guyinda jonama a-jirra wupa, wurra nginyipa gala ny-borrwa minypa an-nginyipa japalana burr-balaja ana-gochila mun-gata minypa mun-ngumurda burr-gaypurda ny-yorkiya. ");
INSERT INTO bvr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ny-junarda Berachi, nginyipa minypa ny-japula nyi-guyinda, ngarla! Wurra minypa gun-gata gun-maywapa ranginy, yama nginyipa japalana gochila a-jirra ny-yepa? Lika gu-gata wenga jonama a-jirra burr-guta an-molamola a-ni barra. ");
INSERT INTO bvr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Awa! Nyiburr-gurda joborr marn․gi nyiburr-gunega rrapa Berachi yerrcha, ana-goyburrpa burr-guya gun-nerra gu-ni barra ana-gorrburrwa! Ana-goyburrpa waykin nyiburr-molamola; wupa nyiburr-werra! Ana-goyburrpa minypa gun-maywapa gun-gata gun-gurrema gun-guyinda wupa gu-ngarnama minypa an-gugaliya a-juwiya gatiya abu-barnjinga aburr-workiya. Minypa rrakal yarlanga gubu-ngimanga aburr-workiya, ngayburrpa ngubi-nacha jimarna gun-molamola, wurra jarra wupa a-yurra an-mama an-gulol. ");
INSERT INTO bvr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Gu-gurda ngacha minypa gu-galiya yerrcha nyirrbi-nacha aburr-workiya ana-goyburrpa, jimarna bama aburr-yinaga ana-goyburrpa jechinuwa nyiburr-nirra. Wurra jarra nginyipa wupa ngardapa ny-molamola nyi-negiya nyi-nirra; wurra wuparnana gun-nerra n-dimanga. ");
INSERT INTO bvr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Awa! Nyiburr-gurda joborr marn․gi nyiburr-gunega rrapa Berachi yerrcha, ana-goyburrpa burr-guya gun-nerra gu-ni barra ana-gorrburrwa! Ana-goyburrpa waykin nyiburr-molamola; wupa nyiburr-werra! Minypa ana-goyburrpa nyibi-jarlapurda nyiburr-workiya gun-gata gun-gurrema gun-guyinda wupa gu-ngarnama minypa gatiya nyirrbu-barnjinga nyiburr-workiya Wangarr burr-yika aburr-mujaruk aburr-juwuna. Rrapa gun-gata gun-gurrema gun-guyinda ana-goyburrpa gun-molamola nyibi-nenga nyiburr-workiya yarlanga minypa wupa an-marbat an-guyinda a-yurra, ana-goyburrpa nyibu-barnjinga mu-ngoyurra minypa jechinuwa a-ni a-workiyana. ");
INSERT INTO bvr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Minypa ana-goyburrpa ngardapa nyiburr-weya nyiburr-workiya, nyiburr-yinaga, ‘Minyja ngayburrpa mu-ngoyurra nguburr-ningarna wugupa burrwa aburr-ngayburrpa nyanyapa arrburra yerrcha, ngayburrpa gala nguburr-malchingarna burrwa aburr-gatiya minypa burrbu-buna Wangarr burr-yika aburr-mujaruk.’ Ana-goyburrpa nyiburr-yinagata nyiburr-weya nyiburr-workiya, ");
INSERT INTO bvr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","wurra gu-gurda ngacha minypa ana-goyburrpa nyiburr-ngurrjiya nyiburr-walkurpa burrwa aburr-gata aburr-bachirra, rrapa minypa ana-goyburrpa nyiburr-yinagatiya nyiburr-bachirra minypa nyanyapa ana-gorrburra yerrcha nyirrbu-mengapa nyiburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Awa! Ana-goyburrpa barra nyibu-mungba gun-gata nyanyapa ana-gorrburrwa yerrcha jama aburr-ji. ");
INSERT INTO bvr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Ana-goyburrpa minypa an-gata jarn․gich an-guyinda, minypa aburr-goyburrpa nyanyapa ana-gorrburrwa yerrcha jarn․gich nyanma. Minypa nuwurra waypa Wangarr burr-mari a-wengga, nipa nyirr-jerrma barra ana-goyburrpa gu-bol, rrapa ana-goyburrpa gala nyiburr-yinmiya nyiburr-lijiwarriya nula. ");
INSERT INTO bvr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ngardawa ngaypa nguburr-jerrma barra ana-gorrburrwa Wangarr burr-yika aburr-mujaruk ngunyuna aburr-guyinda, rrapa aburr-gata minypa gun-jaranga marn․gi aburr-ni, rrapa mola janguny marn․gi aburr-gunega, wurra aburr-gurda ngacha aburr-werranga ana-goyburrpa nyiburr-nyala nyirrbu-bu, rrapa aburr-werranga yi-gapa wupa burr-jong nyirrbi-nega nyirrbi-rra, rrapa aburr-werranga nyirrbu-jurrburaykujama gata wupa gu-bala gun-goyburrpa marn․gi nyiburr-negiya nyiburr-workiya. Rrapa minypa aburr-yurtcha aburr-ni gu-werranga rrawa, ana-goyburrpa nyirrbu-bitima rrapa mu-nguy bampa nyirrbi-nega nyirrbu-bu nyiburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Gu-gurda ngacha minypa ana-goyburrpa nyiburr-mornanga minypa mu-ngoyurra burrbu-buna aburr-workiyana, aburr-juwuna aburr-workiyana; minypa Aybul (Abel) a-juwuna an-gata gala gun-nga gun-nerra gu-rrimangarna, rrapa gu-gata wenga Jekaráya (Zachariah) nipa rrapa a-juwuna jurdach, an-gatiya Berakáya (Berachiah) an-nika an-walkurpa. Minyja bubu-borrwa: an-gata Jekaráya ana-goyburrpa Yichrayal (Israel) nyiburr-bapurr nyibu-buna gojilapa Wangarr gun-nika bala gun-japurra rrapa gun-nigipa belabila gu-maya gun-gata yarlanga gu-jirra. ");
INSERT INTO bvr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Gun-guna ngu-weya ana-gorrburrwa gun-burral: Warrpam gu-gata ngacha mari ana-goyburrpa nyibu-ma barra, ngarla! ");
INSERT INTO bvr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ya gurrupurunga rrawa Jirúchalam (Jerusalem)! Wurra an-nga nula ana-goyburrpa nyirrbu-burnda nyiburr-workiya Wangarr burr-yika aburr-mujaruk ngunyuna aburr-guyinda? An-nga nula gu-jandarra nyirrbu-burnda nyiburr-workiya nipa burr-jerrmanga ana-gorrburrwa? Wurra ngaypa jal ngu-ni jimarna mernda ngu-jirra ng-gorlkakajarna ana-gorrburrwa mari, minypa gun-maywapa ranginy jin-gata bawul (fowl) jiny-bamagutuwuja jiny-yorkiya jin-nigipa delipa jin-guyinda, lika ji-warmbarrk jiny-jolartchinga, gu-gurda ngacha. Wurra ana-goyburrpa gala jal nyiburr-nirrarna apula. ");
INSERT INTO bvr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ganapiya. Gun-goyburrpa rrawa gun-gata gu-jirra gu-boya Wangarr gu-bawuna; gu-werrapa gugu gu-ji barra. ");
INSERT INTO bvr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Minyjiya, ngarla! Ngaypa ngu-weya ana-gorrburrwa, ana-goyburrpa gala nyiburr-yinmiya barrwa ngunabi-na ngaypa nuwurra jurdach guna-bamburda ana-goyburrpa minypa nyiburr-yinda barra nyiburr-wengga, ‘Wangarr an-molamola a-nega barra an-guna nipa ana-jerrmarra!’” ");
INSERT INTO bvr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesus a-garlmuna, gu-bawuna a-bona gun-gata Wangarr gun-nika gun-japurra rrawa. Minypa nipa a-jarl a-bamuna, aburr-yigipa jawina yi-gurrepa aburr-negiyana nula rrapa abu-gurdagurdarrana minypa barra nipa gu-na gun-gata bala gu-jirra aburr-jirra gun-gata Wangarr gun-nika gun-japurra rrawa, jimarna gun-molamola. ");
INSERT INTO bvr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Wurra nipa a-yinanga burrwa, “Aya. Gun-narda nyibi-nacha nyiburr-nirra, ya? Wurra gun-guna ngu-weya ana-gorrburrwa gun-burral: Gun-gata bala rrapa jandarra gala gu-yinmiya mu-nguy gu-ji, wurra gu-jel gu-yu barra gu-ni ngardapa ngardapa.” ");
INSERT INTO bvr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Gu-gata wenga Jesus rrapa aburr-yigipa jawina aburr-bamuna, lika mu-mirk aburr-warrchinga mun-gata mun-nelangga Alip (Olive) Mu-jirrapa. Lika gatiya aburr-rakaja, gu-gatiya wenga gubi-nana gurda aburr-ni Wangarr gun-nika bala gun-japurra. Minypa Jesus burr-yika jawina yi-gurrepa aburr-negiyana nula, gata aburr-ni ngardapa. Lika birripa abu-wengganana, “A-lay, gun-ngiya ngayburrpa mu-ngoyurra nyibi-na barra marn․gi nyiburr-ni barra ngardawa yi-gurrepa gu-jirra gu-boya minypa nginyipa Bunggawa nyi-ni barra, gu-gata wenga minypa ny-mungba barra?” ");
INSERT INTO bvr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesus a-yinanga burrwa, “Buburr-jarlapiya. Gala yapa ana-werranga nyirr-yolkajin rrapa ana-goyburrpa nyiburr-lijiwarriyan. ");
INSERT INTO bvr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Wurra aburr-jaranga aburr-bengga barra, ngaypa ngu-welangga ngunabu-ma barra rrapa burrbu-yolka barra aburr-boy wurra gama gorlk. Minypa aburr-yinda barra, ‘Ngaypa ng-gunaga Christ!’ ");
INSERT INTO bvr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Rrapa minypa ana-goyburrpa nyiburr-galiya barra gun-guna rrawa minypa an-dakal a-beya a-workiya. Rrapa barrwa nyiburr-galiya barra janguny guna-jeka barra minypa an-dakal a-boya burrwa gu-werranga gu-werranga gu-rrawa. Wurra gala barra nyiburr-gurkuja. Wurra gu-yirdiya barra gu-bamba, wurra gala barra burdak gu-wulebiyapa. ");
INSERT INTO bvr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Minyjiya. Ngardawa gu-werranga gu-rrawa wenga aburr-garlma barra aburr-workiya, aburr-bachirramiya barra burrwa mola gu-werranga gu-rrawa; rrapa minypa bunggawa ana-guyinda a-garlma barra a-workiya, mari gu-garra barra nula an-nerranga bunggawa gu-werranga gu-rrawa. Rrapa gun-jaranga rrawa balaja mu-wulebiya barra, rrapa minypa rrawa gu-ngorrkiya barra. ");
INSERT INTO bvr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Gu-gata ngacha gu-yirda barra gu-ni minypa gu-garlmapa barra mu-nguy gun-nerra gu-ni barra gu-bamba. ");
INSERT INTO bvr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Minypa gun-gatiya gugu aburr-werranga aburr-bachirramiya barra ana-gorrburrwa rrapa nyirrbi-rrima barra, lika murna burrbu-wu barra aburr-werranga birripa barra bampa nyirrbi-nega nyirrbu-bu, nyiburr-juwa. Gu-werranga gu-werranga gu-rrawa aburr-bachirramiya barra ana-gorrburrwa aburr-workiya ngardawa minypa ana-goyburrpa nyiburr-ngaypa. ");
INSERT INTO bvr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Gun-gatiya gugu aburr-jaranga barra aburr-lijiwarriya, rrapa minypa an-borrmunga an-guyinda murna burrbu-wu barra aburr-workiya aburr-gata aburr-bachirra, rrapa ngoyurra aburr-yerryerrmiya barra burrwa gu-gapa gu-guta. ");
INSERT INTO bvr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Minypa an-jaranga an-guyolkiya an-guyinda an-mujaruk a-garlmapa barra burr-yolka aburr-jaranga wurra gama gorlk aburr-lijiwarriya barra. ");
INSERT INTO bvr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Rrapa gun-nerra gun-guyinda wana gu-ni barra gu-bamba gu-werranga gu-werranga gu-rrawa, yanma aburr-jaranga ngika gurrurta gubi-rrima burrwa gu-gapa gu-guta. ");
INSERT INTO bvr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Wurra ana-nga minyja gala a-jeka, wurra minypa a-jinyjapa barra a-workiya, nipa nuwurra jurdach wanngu a-ni barra. ");
INSERT INTO bvr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Rrapa gun-guna gun-molamola janguny Wangarr gun-nika rum, nipa gu-barrjeka barra gu-bamba, gun-nardiya rrawa gu-jirra gu-boya aburr-galiya barra marn․gi aburr-ni; lika gu-gata wenga gun-gumungba. ");
INSERT INTO bvr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Rrapa nuwurra waypa ana-goyburrpa nyibi-na An-nerra Warrpam gatiya nipa a-jinyja gun-japurra gu-rrawa, minypa Denyal (Daniel) an-gata Wangarr an-nika an-mujaruk mu-ngoyurra a-ngurrjinga — (ny-junarda nginyipa mun-narda jurra nyi-nacha nyi-nirra, marrka borrwa gun-gata gun-nga) — ");
INSERT INTO bvr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","wurra gun-gatiya barra aburr-gata Judíya (Judea) aburr-nirra marrka barra gubu-bawa gun-birripa rrawa, aburr-yurtcha barra mu-mirk mu-ngarnama. ");
INSERT INTO bvr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Minypa an-gugaliya yarlanga a-nirra gala a-yinmiya gu-bala a-barrnguma, gorlk gu-ma nula; ");
INSERT INTO bvr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","rrapa minypa an-gata jama a-jirra a-nirra balay marlgaway gala a-yinmiya a-jeka, mu-ma mun-nigipa molma mun-gunegiya mirikal. ");
INSERT INTO bvr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Gun-gatiya barra burr-guya gun-nerra gu-ni barra achila jin-morichiringa jin-guyinda rrapa ngamangama gu-jarlapurda jinyu-nirra delipa gun-nika. ");
INSERT INTO bvr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Wurra burdak mu-ngoyurra bubu-wenggana Wangarr; gala yapa gun-gata mern mu-yurtcha o minypa Jarradi (Saturday) gu-ni gala nyiburr-yinmiya. ");
INSERT INTO bvr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ngardawa gun-gatiya gu-ni barra, gu-garlmapa barra gun-nerra gu-ni barra warrpam, gu-gata ngacha minypa an-gugaliya gala mu-ngoyurra gu-nacharna a-workiyarna, minypa gu-gatiya wenga Wangarr gu-jarlapuna gun-nardiya rrawa rrapa gu-bamuna gun-guniya gugu, wurra gun-nyagara; rrapa minypa gala barrwa gu-yinmiya. ");
INSERT INTO bvr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Wurra Wangarr gipa mu-ngoyurra gu-borrwurra minypa nipa gun-balmbarra gu-nega barra gun-gata. Wurra minyja gala gun-balmbarra gu-nengarna, gala ana-nga barra a-molamiya. Wurra jarra aburr-yigipa nipa a-jerrjerrjiyanapa burrwa nipa burr-borrwurra birripa, lika a-garlmuna, gun-balmbarra gu-negarra. ");
INSERT INTO bvr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Gun-gatiya barra minyja ana-nga a-yinda a-wengga nggula, ‘Minyja na, an-guna Christ!’ rrapa minyja a-yinda, ‘Yi-gaba na! An-gaba!’ wurra nginyipa gala barra gun-narda marr ny-balcha nula. ");
INSERT INTO bvr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ngardawa aburr-gata ngacha aburr-bengga barra aburr-guyolkiya, minypa aburr-ngurrjiya barra Christ, rrapa minypa gun-nerranga janguny gubu-ga barra gurda. Minypa burr-barlmarrk jama aburr-ji barra wana, minyja barra burrbu-yolka Wangarr burr-yika gu-galiya yerrcha, barra minypa aburr-lijiwarriya. ");
INSERT INTO bvr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Wurra ana-goyburrpa bubu-borrwa ngardawa ngaypa gipa mu-ngoyurra ngu-ngurrjinga ana-gorrburrwa gun-gata. ");
INSERT INTO bvr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ganapiya, lika minyja birripa aburr-wengga, ‘Boy, na. Christ an-gaba gu-werrapa,’ wurra gala barra ny-boy gata. Rrapa minyja aburr-wengga, ‘Na. Nipa an-guna wupa gu-ngarnama,’ wurra gala barra marr ny-balcha burrwa gun-narda. Wurra aburr-yolkiya aburr-weya. ");
INSERT INTO bvr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Jarra an-guna An-walkurpa An-gugaliya nipa a-bengga barra minypa gun-maywapa maykarran a-mirlchinga a-workiya rrapa rrawa gu-nayarra gu-workiya gu-gaba wenga marnnga jina-burrbeya jina-workiya rrapa jiy-bunggiya jiy-workiya minypa. ");
INSERT INTO bvr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Wurra wuriya. Wurra an-gata a-juwuna a-ni, gatiya barra gu-ngardapa aburr-negiya an-gulol abu-numunga aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Wurra gun-gatiya barra gun-nerra gu-ni, lika gun-baykarda ngika, ‘lika marnnga jiny-jarlmapa barra an-munya jiny-maya, rrapa an-gata ran․gu gala a-yinmiya barrwa a-jayanaya a-ji. Rrapa waykin wenga jin-jaranga gata jiny-jarlmapa barra jiny-bunggapa jinyu-ni, rrapa wana aburr-bapala aburr-guyinda aburr-gaba waykin, nipa Wangarr burr-ngorrka barra.’ ");
INSERT INTO bvr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Lika wurra gama gorlk abi-na barra an-guna An-walkurpa An-gugaliya waykin, rrapa gubu-borrwa barra minypa gu-gubalmapa gu-nirra. Lika gu-werranga gu-werranga gu-rrawa aburr-rruwuja barra minypa abi-na barra an-guna An-walkurpa An-gugaliya ana-bupiya barra ana-bamba burr-barlmarrk rrapa burr-gujayanaya, an-guniya minypa gala mu-ngoyurra abu-malawujarna. ");
INSERT INTO bvr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Lika nipa barra burr-jerrma barra aburr-yigipa waykin aburr-guyinda aburr-mujaruk minypa an-gubipija ngorla a-maya burr-guya waykin a-wengga barra, lika aburr-boy, burrbu-bamagutuwa barra aburr-yigipa gu-galiya yerrcha nipa a-jerrjerrjiyana burrwa. Minypa yinda wenga barlmarrk guna-jeknga guna-workiya, yi-gaba ngunyuna rrapa yi-gaba ngunyuna burrbu-bamagutuwa barra. ");
INSERT INTO bvr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Bubu-borrwa gun-jong gun-guyinda barra marn․gi nyiburr-ni. Minypa ngayburrpa wolawola ngubi-nacha nguburr-workiya mun-gata mun-jawanyja m-burnda niya mun-gubocha rrapa wombajarr, ngayburrpa marn․gi nguburr-nirra gun-gata yi-gurrepa jemberr. ");
INSERT INTO bvr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Gun-narda minypa gun-maywapa minypa gun-guna gun-burral: Ana-goyburrpa nyibi-na barra gu-yirda barra gu-ni minypa geka ngaypa ngu-wena ana-gorrburrwa, rrapa marn․gi nyiburr-ni barra minypa yi-gurrepa gu-jirra gu-boya an-guna An-walkurpa An-gugaliya ana-jeka barra. ");
INSERT INTO bvr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Gun-guna ngu-weya ana-gorrburrwa gun-burral: Nyiburr-gurdiya ngacha gu-galiya yerrcha, nyiburr-werranga gala barra mu-ngoyurra nyiburr-juwa. Ngika. Wurra gun-gata ngaypa ngu-wena ana-gorrburrwa, gun-bulapalawa gun-gata ni-gugu gu-yirda barra gu-ni. ");
INSERT INTO bvr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Minyjiya. Gun-guniya rrawa gu-garlmapa barra gun-nyagara gu-ni barra, wurra gun-ngaypa wengga gu-jinyjapa barra gu-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Wurra gun-gata gu-yinpa barra an-guna An-walkurpa An-gugaliya ana-jeka, gala ana-nga marn․gi, minypa waykin aburr-guyinda aburr-mujaruk rrapa An-walkurpa minypa; wurra jarra Nyanyapa arrku waykin a-nirra nipa wupa marn․gi. ");
INSERT INTO bvr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Minyja bubu-borrwa: Minypa Nowa (Noah) mu-namangarta, gu-gata ngacha gu-ni barra minypa yi-gurrepa gu-jirra gu-boya nula an-guna An-walkurpa An-gugaliya ana-jeka barra. ");
INSERT INTO bvr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Minypa mu-ngoyurra gun-gata bugula wana gala gu-beyarna burrwa burdak, birripa minypa balaja mbi-barra, nganicha mbi-barra, rrapa gama aburr-wuchichiyana, nuwurra Nowa a-barrngumurra mu-michiyang. ");
INSERT INTO bvr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Minypa birripa gala marn․gi aburr-nirrarna gu-yinmiyana gu-bamuna nuwurra waypa bugula wana gu-ni gu-bamuna, burr-werrwerrmarra. Rrapa gu-yirdiya barra gu-ni minypa An-walkurpa An-gugaliya ana-jeka barra. ");
INSERT INTO bvr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Minypa gun-gata barra gu-ni, abirri-jirrapa gu-galiya yerrcha minypa jama abirri-ji barra abirri-ni balay marlgaway, wurra an-ngardapa a-ma barra rrapa an-ngardapa a-bawa barra. ");
INSERT INTO bvr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Rrapa abirriny-jirrapa mu-gamagama yerrcha mbirriny-yogaja barra abirrinyu-ni, wurra jin-ngardapa jiny-ma barra rrapa jin-ngardapa jiny-bawa barra. ");
INSERT INTO bvr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Ganapiya, lika gana ni. Ngardawa nginyipa gala marn․gi gu-yinpa barra an-nginyipa Bunggawa a-bengga. ");
INSERT INTO bvr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Wurra minypa gun-maywapa ranginy an-gata bala an-gurrimapa, minyja nipa marn․gi a-nirrarna an-gata an-ngumurda an-gugaliya ana-boga, nipa a-ganajarna a-nirrarna rraka gala nipa a-yinmiyarna gu-rrumungarna nula gun-nigipa bala. ");
INSERT INTO bvr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Gu-gurda ngacha minypa nginyipa nawanawa nyi-ni barra, ngardawa an-guna An-walkurpa An-gugaliya ana-goyburrpa gala marn․gi gu-yinpa barra nipa ana-jeka barra. ");
INSERT INTO bvr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Wurra bubu-borrwa gun-guna: An-gata ana-nga an-molamola an-mujama bama jechinuwa gu-borrwuja a-workiya, ana-gata ngacha an-gugaliya nipa an-nigipa bunggawa murna a-wuna gun-nigipa rrawa jaga a-gana barra nula, rrapa balaja burr-wu barra aburr-werranga aburr-gata bunggawa burr-yika aburr-mujama. ");
INSERT INTO bvr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Rrapa nuwurra waypa nipa bunggawa ana-jeka, minyja a-na nipa jama a-jirra, lika an-gata an-mujama gun-molamola gu-ni barra nula. ");
INSERT INTO bvr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Minyjiya, ngarla! Lika gu-gata wenga an-gata bunggawa murna a-wu barra warrpam gun-nigipa bunggawa gun-nika barra nipa an-mujama jaga a-gana nula. ");
INSERT INTO bvr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Wurra minyja nipa an-nerra an-mujama, nipa waygaji a-yinda gu-borrwa, ‘A-lay, an-ngaypa bunggawa a-bona gu-baykarda; gala a-yinmiya ana-jeka.’ ");
INSERT INTO bvr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Rrapa waygaji nipiya an-mujama a-garlmapa burr-bu aburr-gata aburr-werranga bunggawa burr-yika aburr-mujama, rrapa minypa balaja m-bay rrapa nganicha m-bay wugupa burrwa aburr-gata mu-nganicha aburr-babapabajinga aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Wurra minyja nipa a-yirda jama a-ji, gun-gatiya minypa nipa gala gu-borrwa a-ni gun-gatiya gugu an-nigipa bunggawa minypa ana-jeka barra, ");
INSERT INTO bvr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","a-gorndapa barra ngardapa ngardapa a-nega barra an-gata an-mujama. Barra nipa yi-gata a-boy burrwa aburr-gata waykin aburr-molamola rrapa wupa aburr-werra, rrapa gatiya wugupa burrwa nipa barra a-rruwuja a-ni a-workiya rrapa rrirra gu-bay. ");
INSERT INTO bvr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Gun-gata minypa an-guna An-walkurpa An-gugaliya ana-jeka barra, gun-narda gu-yinda barra gu-ni minypa gun-guna meyali gun-maywapa ranginy: Jin-gata jin-merduwa jin-guyinda arr-jirrapa arr-murna, minypa 10, birripa lam (lamp) gubu-menga, lika aburr-bona, abi-na barra an-gata gochila an-gurrimapa minypa jin-nigipa gama jiny-ma barra. ");
INSERT INTO bvr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Wurra aburr-werranga aburr-gatiya jin-merduwa jin-guyinda arr-ngardapa arr-murna, minypa 5, birripa aburr-gerna, rrapa aburr-gata aburr-werranga arr-ngardapa arr-murna, birripa bama aburr-jirra aburr-mola. ");
INSERT INTO bvr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Minypa aburr-gata aburr-gerna, birripa gubu-ganyja burrwa lam, wurra aburr-bamapuna, gala barrwa woyil (oil) lam an-nika abu-ganyjarna. ");
INSERT INTO bvr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Wurra aburr-gata bama aburr-jirra aburr-mola, birripa gubu-ganyja burrwa lam rrapa barrwa woyil m-bochula mu-guyinda. ");
INSERT INTO bvr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Jarra an-gata gochila an-gurrimapa gun-baykarda gu-ganyja, lika jin-gata jin-merduwa jin-guyinda jiny-balabun․gubuna jinyu-ni jiny-jiwa, jiny-bamunapa jiny-yu jinyu-ni. ");
INSERT INTO bvr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Gu-bamunapa gornborrk gu-ni gugu aburr-galiyana burrwa aburr-gonyjinga, ‘Bubi-na! An-guna gugu a-bena gochila an-gurrimapa! Guwa, barra murrpa nyibu-barnja nula!’ ");
INSERT INTO bvr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Rrapa aburr-gata jin-merduwa jin-guyinda yibirrich aburr-garlmuna, gun-birripa lam nawanawa gubi-negarra aburr-bona. ");
INSERT INTO bvr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Lika aburr-gata aburr-gerna, birripa burrbu-wengganana aburr-gata bama aburr-jirra aburr-mola, aburr-yinanga burrwa, ‘A-jay, yama nyirrbu-wu woyil? Wurra gun-ngayburrpa lam gu-jupiya gu-nirra.’ ");
INSERT INTO bvr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Wurra aburr-gata bama aburr-jirra aburr-mola aburr-yinanga burrwa, ‘Ngika! Gala an-jaranga nyibi-rrima rraka nyirrbu-wu. Gala yapa a-wulebiyan arrburrwa. Wurra buburr-boy, bubu-ma an-gata gu-gandin (canteen) jalim aburr-nirra aburr-workiya.’ ");
INSERT INTO bvr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Lika gun-gata waypa birripa aburr-bona, an-gata gochila an-gurrimapa a-bena, lika aburr-gata minypa mu-ngoyurra nawanawa aburr-ni, birripa murrpa gubu-barnjinga nula, lika aburr-barrngumurra wugupa barra aburr-worlworlcha rrapa balaja mbi-bay, lika gu-gubalmapa gu-ni minypa jin-nigipa gama nipa jiny-ma barra. Gu-gurda ngacha. Rrapa ngana gu-jirra gun-gata gu-jakabiyana. ");
INSERT INTO bvr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Wurra nuwurra waypa jurdach aburr-gata aburr-werranga mu-merdapmerduwa yerrcha aburr-jekarra gurda, aburr-gonyjinga, ‘Bunggawa, a-lay, yama nyi-lapkujama arrburrwa, ya?’ ");
INSERT INTO bvr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Wurra nipa a-wena burrwa, ‘Ngika! Ngaypa gala marn․gi ana-gorrburrwa.’” ");
INSERT INTO bvr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ganapiya, lika Jesus gu-mungbuna janguny minypa a-yinagata burrwa, “Nawanawa buburr-ni; ngardawa nginyipa gala marn․gi gu-yinmiyapa ngorrngurra rrapa jiny-yinmiyapa marnnga nipa Bunggawa ana-jeka barra. ");
INSERT INTO bvr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Gun-gata minypa an-guna An-walkurpa An-gugaliya ana-jeka barra, gun-narda gu-yinda barra gu-ni minypa gun-guna meyali gun-maywapa ranginy: An-ngardapa an-gugaliya a-ni, nipa a-gonyjinga burrwa aburr-yigipa aburr-mujama, lika a-wena burrwa rrapa murna burr-wuna minypa nipa a-boy barra balaypalay. ");
INSERT INTO bvr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Minypa an-ngardapa an-mujama nipa bunggawa murna a-wuna barra minypa mu-rrima a-ni rrapa jama a-ji rrupiya mun-gata wana mun-babalapa minypa 5,000, rrapa ana-werranga mu-menga minypa 2,000, rrapa barrwa ana-werranga mu-menga minypa 1,000. Minypa murna burr-wuna ngardapa ngardapa minypa ganyjarr gubi-rrimarra rrapa bama aburr-jirra minypa marn․gi. Ganapiya, lika nipa bunggawa a-bona. ");
INSERT INTO bvr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Wurra an-gata rrupiya wana mun-babalapa mu-menga minypa 5,000, warrika a-bonapa bayim a-ni rrapa jalim a-ni, nuwurra 10,000 muna-gurdanyjinga nula. ");
INSERT INTO bvr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Rrapa an-gata marr wana mu-menga minypa 2,000, nipa a-yinagatiya, minypa barrwa 4,000 muna-gurdanyjinga nula. ");
INSERT INTO bvr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Wurra barrwa an-gata mun-delipa mu-menga minypa 1,000, nipa a-bona, a-gapajinga, yi-gapa wupa mu-jurnumbuna mun-gata bunggawa mun-nika rrupiya. ");
INSERT INTO bvr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ganapiya, lika nuwurra gun-baykarda gu-ni, bunggawa ana-jekarra burrwa. Lika a-gonyjinga burrwa barra minypa a-birripiya minypa birripa aburr-yinmiyana jama aburr-ji rrapa mun-nigipa rrupiya barrwa mu-yinmiyapa mbi-menga nula. ");
INSERT INTO bvr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Lika an-gata an-mujama mu-ngoyurra mu-menga wana mun-babalapa, minypa 5,000, nipa muna-ganyja ana-bamuna 10,000. A-yinanga a-wena, ‘Bunggawa, a-lay, nginyipa murna nguna-wuna 5,000, wurra mun-guna barrwa nguna-ganyja nggula 10,000.’ ");
INSERT INTO bvr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“An-nigipa bunggawa a-wena nula, ‘Ganapiya, murna ny-maranga. Ny-molamola apula nyi-mujama gala n-dawurdawuja ny-yorkiya. Nginyipa ngardawa gun-mola jama ny-ji nyi-ni mun-gata nula mun-delipa ngaypa ngiy-wuna, wurra ngaypa gun-jaranga jama ngu-rrimanga nggula barra ngaypa murna ngiy-wu, jaga ny-jana. Guwa. Ngaypa ng-guna bunggawa, nginyipa wugupa apula arr-worlworlcha barra arr-ni.’ ");
INSERT INTO bvr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Lika an-gata an-mujama mu-ngoyurra mu-menga marr wana minypa 2,000, nipa muna-ganyja ana-bamuna 4,000. A-yinanga, ‘Bunggawa, a-lay, nginyipa murna nguna-wuna 2,000, wurra mun-guna barrwa nguna-ganyja nggula 4,000.’ ");
INSERT INTO bvr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“An-nigipa bunggawa a-wena nula, ‘Ganapiya, murna ny-maranga. Ny-molamola apula nyi-mujama gala n-dawurdawuja ny-yorkiya. Nginyipa ngardawa gun-mola jama ny-ji nyi-ni mun-gata nula mun-delipa ngaypa ngiy-wuna, wurra ngaypa barrwa murna ngiy-wu barra gun-jaranga. Guwa. Ngaypa ng-guna bunggawa, nginyipa wugupa apula arr-worlworlcha barra arr-ni.’ ");
INSERT INTO bvr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Lika an-gata an-mujama mu-ngoyurra mu-menga minypa 1,000, nipa ana-bona, a-yinanga, ‘Bunggawa, a-lay, ngaypa marn․gi nggula minypa nginyipa n-derta ny-jorla. Minypa nginyipa ny-mangga ny-yorkiya nginyipa gala ny-jurrma rrapa gala jama ny-ji. ");
INSERT INTO bvr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Wurra ngaypa ng-gurkuja nggula. Lika ngu-bona, mun-nginyipa rrupiya ngu-jurnumbuna, ngu-yilkakaja. Nya, mun-guna nggula mun-nginyipa murna nguna-wuna.’ ");
INSERT INTO bvr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Wurra an-nigipa bunggawa a-wena nula, ‘Ny-junarda nginyipa ny-yerra nyi-mujama, a-lay, minypa n-dawurdawujinga ny-yorkiya. Wurra nginyipa marn․gi apula, ya? Minypa ngaypa ngu-mangga ngu-workiya ngaypa gala ng-gurrma rrapa gala jama ngu-ji. ");
INSERT INTO bvr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Wurra mun-ngaypa rrupiya nginyipa bengk (bank) ny-jurrmungarna, barrwa ngaypa ngu-manggarna mun-jaranga minypa birripa jama aburr-jirra aburr-workiya rrapa mbi-gurdanyjinga.’ ");
INSERT INTO bvr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Lika a-wena burrwa aburr-werranga aburr-gata, a-yinanga burrwa, ‘An-guna bubu-murnamagaypa mun-gata rrupiya ngaypa ngu-wuna, rrapa bubu-wu an-gata minypa 10,000 mu-rrimanga. ");
INSERT INTO bvr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ngardawa ana-nga an-gata gu-rrimanga gun-nga rrapa jama a-jirra, burraya mola gu-ma barra, lika nipa wana gu-rrima barra. Wurra an-nerranga ana-nga nipa minypa gala gu-rrima, burraya abu-gaypa barra an-gata an-gugaliya gun-gata gun-delipa jimarn jarra nipa gu-rrimangarna a-nirrarna. ");
INSERT INTO bvr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ganapiya, lika an-guna an-nerra an-mujama murna bubi-rrima, bubi-yerrnyja yarlanga gata an-munya a-maya a-jirra a-workiya, gatiya barra a-rruwuja a-ni a-workiya rrapa rrirra gu-bay.’ ");
INSERT INTO bvr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“An-guna An-walkurpa An-gugaliya, nuwurra waypa nipiya Bunggawa a-bengga rrapa aburr-yigipa waykin aburr-guyinda aburr-mujaruk wugupa nula, nipa a-raka barra gata gun-nigipa bunggawa gun-nika gun-gurrenyja gun-guni. ");
INSERT INTO bvr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Rrapa gatiya wurra gama gorlk gu-werranga gu-werranga gu-rrawa wenga murrpa gubu-barnja barra nula aburr-ji a-yinmiya barra nipa Bunggawa a-wengga. Lika nipa barra burr-ngorrkornda barra, minypa gun-maywapa ranginy an-gata jip (sheep) jaga an-gugana burr-ngorrkorndanga a-workiya, jip ngardapa, rrapa nanikut (nanny goat) ngardapa. ");
INSERT INTO bvr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Gu-gata ngacha minypa barra Bunggawa burr-barnja barra aburr-gata minypa jechinuwa aburr-ni nula aburr-workiyana, nipa ana-munganaguwa aburr-ji barra; wurra aburr-gata aburr-werranga burr-barnja barra nipa ana-weyka aburr-ji barra. ");
INSERT INTO bvr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Lika gu-gata wenga nipa a-wengga barra burrwa aburr-gata ana-munganaguwa aburr-jirra, ‘Guwa! Ana-goyburrpa nyiburr-gurda minypa an-ngaypa Nyanyapa apa wugupa ana-gorrburrwa, ana-goyburrpa nyibu-ma barra gun-gata gun-molamola nipa nawanawa a-ni ana-gorrburrwa wola baman gu-ni gun-nardiya rrawa gu-jarlapuna. ");
INSERT INTO bvr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nyibu-ma barra ngardawa minypa ngaypa ngu-werrmiyana, nginyipa balaja nguna-wuna; rrapa minypa bugula ngu-jaygachinga, nginyipa nguna-wuna; ngaypa gu-werranga gu-rrawa wenga nguna-bona, nginyipa nyina-gonyjinga apula; ");
INSERT INTO bvr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ngaypa ngu-nyarlanga ngu-ni, nginyipa nguna-wuna mun-gubarrbiya; ngu-yorrpuna, nginyipa jaga ny-janana apula; brichina ngu-ni, nyina-bona, nguna-nana.’ ");
INSERT INTO bvr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Lika aburr-gatiya mu-ngoyurra jechinuwa aburr-ni nula, birripa aburr-yinda barra aburr-wengga nula, ‘Gun-gata gu-yinpa ngaypa ngiy-nana nginyipa ny-yerrmiyana rrapa balaja ngiy-wuna, a-lay, rrapa bugula ny-jaygachinga ngaypa ngiy-wuna? ");
INSERT INTO bvr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Gun-gata gu-yinpa ngaypa ngiy-nana nginyipa gu-werranga gu-rrawa wenga, rrapa ngaypa nguna-gonyjinga nggula, rrapa minypa nginyipa ny-nyarlanga nyi-ni ngaypa ngiy-wuna mun-gubarrbiya? ");
INSERT INTO bvr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Gun-gata gu-yinpa ngaypa ngiy-nana nginyipa ny-yorrpuna o brichina nyi-ni, rrapa ngaypa nguna-bona, ngiy-nana?’ ");
INSERT INTO bvr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Lika nipa Bunggawa a-wengga barra burrwa, a-yinda barra, ‘Ngika, wurra gun-guna ngu-weya ana-gorrburrwa gun-burral: Gun-gata minypa nginyipa ny-junggajinga nula an-ngaypa worlapa apa an-ngardapa an-guna an-nelangga an-delipa, gun-narda minypa ngaypa ny-junggajinga apula.’ ");
INSERT INTO bvr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Lika gu-gata wenga nipa Bunggawa a-wengga barra burrwa aburr-gata ana-weyka aburr-jirra, a-yinda barra burrwa, ‘Buburr-boypa! Nyiburr-gurda nyiburr-werra. An-ngaypa Nyanyapa apa ngoyurra a-yerryerrmiyana ana-gorrburrwa. Buburr-boypa gu-bol gu-rronggapa gu-jirra gu-workiya gun-gata minypa nipa Wangarr nawanawa a-ni burrwa an-gata walkwalk rrapa aburr-yigipa aburr-mujaruk, minypa aburr-rro barra gata. ");
INSERT INTO bvr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yi-gata buburr-boypa! Ngardawa minypa ngaypa ngu-werrmiyana, nginyipa gala balaja nguna-wucharna; bugula ngu-jaygachinga, nginyipa gala nguna-wucharna; ");
INSERT INTO bvr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","rrapa ngaypa gu-werranga gu-rrawa wenga nguna-bona, nginyipa gala ny-jonyjingarna apula; ngaypa ngu-nyarlanga ngu-ni, nginyipa gala nguna-wucharna mun-gubarrbiya; rrapa ngu-yorrpuna rrapa brichina ngu-ni, nginyipa gala nyina-boyarna apula.’ ");
INSERT INTO bvr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Lika aburr-gatiya aburr-yinda barra aburr-wengga nula, ‘Gun-gata gu-yinpa ngaypa ngiy-nana nginyipa balaja ny-yerrmiyana, rrapa bugula ny-jaygachinga, rrapa gu-werranga gu-rrawa wenga, rrapa minypa nginyipa ny-nyarlanga nyi-ni, rrapa ny-yorrpuna, rrapa brichina nyi-ni, rrapa ngaypa gala ng-gunggajingarna ngguluwa?’ ");
INSERT INTO bvr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Lika nipa Bunggawa a-wengga barra burrwa, a-yinda barra, ‘Ngika, wurra gun-guna ngu-weya ana-gorrburrwa gun-burral: Gun-gata minypa nginyipa gala ny-junggajingarna nula an-ngaypa worlapa apa an-ngardapa an-guna an-nelangga an-delipa, gun-narda minypa gala ngaypa ny-junggajingarna apula.’ ");
INSERT INTO bvr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ganapiya, lika aburr-gata aburr-werra birripa aburr-boypa barra gu-bol aburr-mungbiyapa barra. Wurra aburr-gata jechinuwa aburr-ni aburr-workiyana birripa aburr-boy barra wanngu aburr-nipa barra aburr-workiya.” ");
INSERT INTO bvr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Gun-gata Jesus gun-jaranga gu-ngurrjinga nipa gu-mungbuna, lika a-wena burrwa aburr-yigipa jawina, ");
INSERT INTO bvr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ana-goyburrpa marn․gi minypa ngorrngurra abirri-jirrapa gu-ni barra, lika janara gu-ji barra minypa wola waykin an-guyinda an-mujaruk burr-burndarna, wurra burr-beybana. Wurra gun-gata janara waypa gu-ji barra, birripa murna burrbu-wu barra an-guna An-walkurpa An-gugaliya barra burr-jong abi-nega abi-rra, a-balcha a-yu.” A-yinagata Jesus a-wena burrwa aburr-yigipa jawina. ");
INSERT INTO bvr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Lika gu-gata wenga wana junggay yerrcha rrapa aburr-werranga mu-murna yerrcha, birripa aburr-bamagutuwiyana gata junggay wana an-babalapa gun-nika rrawa, an-gata Gayapach (Caiaphas) an-nelangga. ");
INSERT INTO bvr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Lika wengga gubu-buna aburr-ni minypa aburr-yinmiya barra yongun abi-rrima Jesus rrapa abu-bu. ");
INSERT INTO bvr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Wurra birripa aburr-wena, “Ngayburrpa gala nguburr-yinmiya minypa janara gu-ji; gala yapa gu-galiya yerrcha aburr-yurtcha gurda aburr-yurtcha.” ");
INSERT INTO bvr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Gun-gatiya gugu Jesus a-bona Bechini (Bethany) a-ni, minypa balapala a-rrenyjinga Jayman (Simon) an-gata mu-ngoyurra an-jeja a-ji rrapa a-ngolkuja minypa gun-guburlububurluja gu-rrimarra. ");
INSERT INTO bvr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Rrapa gatiya waypa balaja mbi-barra aburr-ni, jin-ngardapa gama muna-ganyja jina-bamuna m-bochula mu-guyinda mun-gungimiya mun-molamola mun-gungolkuja rrupiya wana nula. Minypa mun-gata bochula burr-guta mun-molamola, minypa mbi-jarlapuna jandarra gun-molamola gun-gata gun-nelangga alabécha (alabaster). Lika jin-gata gama mu-jerrjerrjinga ana-jawurrga Jesus mun-gata mun-molamola mun-gungolkuja. ");
INSERT INTO bvr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Wurra gun-narda waypa Jesus burr-yika jawina gubi-nana, lika aburr-bachirramiyana. Aburr-wengganachichiyana birripa wupa, aburr-yinagata, “Jin-guna an-nga nula mu-yerpana mun-gata mun-molamola mun-gungolkuja? ");
INSERT INTO bvr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ngayburrpa jarra ngubu-ganyjarna, jalim nguburr-nirrarna, rrupiya wana ngubu-manggarna, gu-gata wenga minypa arrbu-wucharna aburr-werranga aburr-gata aburr-nyagara aburr-nirra, ngarla!” ");
INSERT INTO bvr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Wurra Jesus gu-borrwurra burrwa minypa gun-gata aburr-wena, lika nipa a-wena burrwa, a-yinanga, “Jin-narda an-nga nula nyiburr-weya achila? Wurra jarra nipa gun-molamola gun-narda minypa nguna-ngimarra rrapa ngu-molamola nguna-negarra. ");
INSERT INTO bvr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Wurra birripa gorlk aburr-nyagara wugupa nyiburr-nirra nyiburr-workiya; wurra jarra ngaypa ngu-boy barra. ");
INSERT INTO bvr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wurra minypa jin-guna mu-jerrjerrjinga mun-molamola mun-gungolkuja ngaypa ngu-burral, gun-narda minypa nawanawa nguna-negarra burraya ngunabu-jurnumba. ");
INSERT INTO bvr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Rrapa ngaypa ngu-weya ana-gorrburrwa gun-burral: Yina gaya barra gun-ngaypa janguny gubu-ngurrja barra aburr-workiya gun-nardiya rrawa gu-jirra gu-boya, gun-gata rrapa gu-barrjeka barra achila janguny minypa geka nipa nguna-ngimarra.” ");
INSERT INTO bvr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Lika an-ngardapa Jesus burr-yika 12 gu-galiya yerrcha an-gata an-nelangga Jurrach Yichkériyat (Judas Iscariot), nipa a-garlmuna, a-bona burrwa wana junggay yerrcha. ");
INSERT INTO bvr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Lika nipa a-wena burrwa, “Ana-goyburrpa nyiburr-gurda gun-nga ngunabu-wu barra minypa an-gata Jesus ngaypa murna arr-wu barra?” Lika birripa abu-wuna rrupiya mun-mama jilpa (silver) mu-maya minypa burr-murna burr-rrepara rrapa barrwa arr-jirrapa arr-murna, minypa 30. ");
INSERT INTO bvr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Lika gu-gatiya wenga nipa Jurrach gu-borrwurra a-ni yina gaya rrapa gu-yinpa barra Jesus abi-rrima. ");
INSERT INTO bvr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Gun-gatiya gugu waypa janara gu-ji, minypa damba mun-gun․gun mbi-bay barra, lika Jesus burr-yika jawina aburr-bona gurda nula, abu-wengganana, aburr-yinanga, “Bunggawa, a-lay, yina gaya jal nyi-nirra ngayburrpa barra nawanawa nyiburr-ni nggula mun-mujanara balaja rrapa an-mujanara jip (sheep)?” ");
INSERT INTO bvr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nipa a-yinanga burrwa, “Birri-boy nula yagatay an-gata gu-murnangana rrawa a-nirra. Birri-wengga nula, birri-yinda, ‘Bunggawa a-wena, “Gun-nardiya gugu gun-balma apula, wurra gun-nginyipa rrawa barra ngaypa rrapa aburr-ngaypa jawina gu-janara nyiburr-ni barra.” ’” ");
INSERT INTO bvr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ganapiya, lika Jesus bijirri-yika jawina abirri-bona, abirri-barripuna an-gata, lika nawanawa abirri-ni mun-gata mun-mujanara balaja. ");
INSERT INTO bvr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Lika nuwurra waypa balngga gu-ni, Jesus rrapa aburr-yigipa 12 gu-galiya yerrcha aburr-rakaja wugupa gatiya minypa balaja mbi-barnjinga. ");
INSERT INTO bvr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Lika minypa balaja mbi-barra aburr-ni, Jesus a-wena burrwa, “Buburr-galiya apula; gun-guna gun-burral: Ana-goyburrpa nyiburr-gurda ny-nyardapa gipa ny-jarlmuna, aburr-gata aburr-bachirra murna burr-wu barra ngaypa.” ");
INSERT INTO bvr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Lika aburr-yigipa jawina wargugu aburr-ni nula gun-gata nipa a-wena. Lika ngardapa ngardapa abu-wengganana aburr-bona, “Bunggawa, a-lay, ngaypa ngika, ya?” ");
INSERT INTO bvr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Lika nipa a-wena burrwa, “An-gata ngatipa wugupa damba ana-japalana ana-maywapa nyirri-gurragaja nyirri-ni, an-nardiya nguna-bawa barra rrapa minypa murna burr-wu barra ngaypa aburr-gata aburr-bachirra. ");
INSERT INTO bvr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Minyjiya. An-guna An-walkurpa An-gugaliya nipa a-juwa barra minypa mu-jurra gu-yurra Wangarr gun-nika janguny, wurra an-gugaliya an-gata minypa nguna-bawuna rrapa murna burr-wuna ngaypa aburr-gata aburr-bachirra, nipa jarra an-gata an-gugaliya gun-nerra warrpam gu-ni barra nula, jimarna gun-mola nula minyja nipa gala a-bambunggiyarna.” ");
INSERT INTO bvr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jesus a-yinagata a-wena, lika Jurrach (Judas) an-gata gipa mu-ngoyurra a-mulpiyana burrwa aburr-gata aburr-bachirra, nipa a-wengganana Jesus, “Bunggawa, a-lay, ngaypa ngika, ya?” Lika Jesus a-yinanga nula, “Ngaw, nginyipa ny-jurdiya.” ");
INSERT INTO bvr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Gun-gatiya minypa birripa mbi-barra aburr-ni, Jesus mu-menga damba, a-japurramayana nula Wangarr, lika mu-rrumurra, burr-wuna a-bona aburr-yigipa jawina. A-yinagata burrwa, “Bubu-ma, bubu-bay; mun-guna ngaypa ngu-burral.” ");
INSERT INTO bvr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Rrapa mernda a-jirra a-menga minypa burr-girra gurnal, lika a-japurramayana nula Wangarr, lika burr-wuna minypa a-yinagata burrwa, “Warrpam ana-goyburrpa bubu-bay; ");
INSERT INTO bvr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","mun-guna ngaypa ngu-maningan gun-burral gu-nenga mu-nirra rum. Ngaypa ngu-jortcha barra ana-gorrburrwa ana-goyburrpa nyiburr-gurda rrapa aburr-jaranga aburr-werranga burr-guta, nyanma Wangarr baywarra gu-nega barra ana-gorrburrwa werra nyiburr-negiyana. ");
INSERT INTO bvr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Gun-guna ngu-weya ana-gorrburrwa gun-burral: Mun-guna gurnal mun-girra gala barra barrwa ngu-bay, wurra nuwurra mun-geka ana-goyburrpa wugupa ngubu-bay barra Ngun-anya ana-murna,” Jesus a-yinagata a-wena. ");
INSERT INTO bvr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ganapiya, lika manakay aburr-japarndiyana nula Wangarr, lika aburr-garlmuna, mu-mirk aburr-bona mun-gata mun-nelangga Alip (Olive) Mu-jirrapa. ");
INSERT INTO bvr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Lika Jesus a-wena burrwa, “Gun-nardiya ana-munya barra nyiburr-gurda nyiburr-jaranga ngunabu-bawa nyiburr-yurtcha. Ngardawa minypa mu-jurra gu-yurra janguny, gu-yinaga gu-yurra, ‘An-gata jip (sheep) jaga a-ganaja a-workiya, nipa Wangarr ana-nyala a-bu barra, rrapa nipa jin-gata jip jiny-jarlmapa barra mun-ganday m-bu barra.’ Gu-yinagata gu-yurra janguny. ");
INSERT INTO bvr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Wurra nuwurra waypa barra ngu-molamiya, ngaypa lika mu-ngoyurra ngu-boy barra ana-gorrburrwa gun-gata Galali (Galilee).” ");
INSERT INTO bvr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Lika Birta (Peter) burr-guya a-wena nula Jesus, a-yinanga nula, “Waygaji aburr-guna bubu-bawa barra, wurra ngaypa gala ngu-yinmiya ngiy-bawa.” ");
INSERT INTO bvr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Wurra Jesus a-yinagata nula, “Gun-guna ngaypa jarra marn․gi ngardawa gun-burral: Gun-nardiya ana-munya barra gala barra bawul (fowl) ni-gugu jiny-yengga, wurra jarra nginyi-gugu ny-jirrapa ny-nyardapa ny-joma ny-jordajiya burrwa jimarna gala marn․gi apula, rrapa nipa nuwurra jurdach bawul jiny-yengga barra.” ");
INSERT INTO bvr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Wurra barrwa Birta a-wena, “Ngaypa gala barra ngiy-bawa wurra marrban ngunabu-bu minypa wugupa arr-juwa.” Rrapa Jesus burr-yika jawina aburr-yinagatiya aburr-wena gun-maywapa. ");
INSERT INTO bvr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Lika Jesus rrapa aburr-yigipa jawina aburr-bona, aburr-bena gun-gata rrawa gun-nelangga Gachémani (Gethsemane). Lika a-yinanga a-wena burrwa, “Ana-goyburrpa ngunyuna buburr-ni, wurra ngaypa barra yi-gaba ngu-boy, Nyanyapa arrku ngu-wenggana barra ngu-ni.” ");
INSERT INTO bvr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Lika burr-menga Birta rrapa abirri-gata Jebadi (Zebedee) bijirri-yika walkurpa yerrcha, lika burr-ganyja a-bona. Wurra nipa Jesus a-garlmunapa wargugu a-ni. ");
INSERT INTO bvr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Lika a-yinagata burrwa, “Ngaypa burr-guya wargugu ngu-nirra, ngarla! Wurra ana-goyburrpa ngunyuna buburr-gana buburr-ni balpura apula.” ");
INSERT INTO bvr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Lika nipa ay-bamuna balay ngika, lika ana-menama gu-rrana, bukula a-jirra a-gurrmiyana gu-jel, a-yinanga a-wengganana, “Anya, minyja gun-mola, gun-guna mari nguna-beyba. Wurra ngardawa gun-ngaypa jal ngika, wurra minyja nginyipa jal nyi-ni.” ");
INSERT INTO bvr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ganapiya, lika nipa ana-jekarra, burr-nana aburr-yigipa jawina aburr-yu. Lika a-wena nula Birta, “Awa! Ana-goyburrpa gala nyiburr-yinmiyarna nyiburr-ganajarna nyiburr-nirrarna balpura apula, ya? Wurra ngaypa gun-guna waya ngu-bona. ");
INSERT INTO bvr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Buburr-gana buburr-ni rrapa bubu-wenggana Wangarr, barra nipa a-gunggaja ana-gorrburrwa rrapa gala nyiburr-yinmiya nyiburr-lijiwarriya. Minypa ana-goyburrpa nyiburr-mola, wurra nyiburr-gata nyiburr-gugaliya nyiburr-nyarlkuch.” ");
INSERT INTO bvr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Lika Jesus ana-jirrapa ana-goma gu-negarra nipa a-bona, a-wengganana, “Anya, minyja gun-guna mari gala gu-yinmiya gu-boy wurpa minyja ngaypa ngu-ma, ganapiya, gu-yirda barra gu-ni minypa nginyipa jal nyi-ni.” ");
INSERT INTO bvr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Lika barrwa ana-jekarra, burr-nana aburr-yu minypa ngorrngurra burr-buna gu-ni. ");
INSERT INTO bvr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Lika barrwa burr-bawuna, a-bona, ana-jirrapa ana-ngardapa ana-goma gu-negarra a-wengganana a-ni gun-maywapa. ");
INSERT INTO bvr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Lika barrwa ana-jekarra, a-yinagata burrwa, “Awa! Nyiburr-gurda mu-nguy nyiburr-ngeknga rrapa nyiburr-yurra, ya? Ganapiya, wurra gun-nardiya gugu gun-balmapa gu-jirra gu-boya. Minyja burrbi-na, an-guna An-walkurpa An-gugaliya gugu abi-rrima barra burrbu-wu gu-galiya yerrcha aburr-gata aburr-werra. ");
INSERT INTO bvr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Buburr-garlma barra nguburr-boy. Bubi-na, an-guna nguna-bawuna nipa burr-ganyja gurda ana-bamburda barra ngunabi-rrima!” ");
INSERT INTO bvr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Gun-gatiya waypa Jesus a-yinagata a-wena burrwa a-ni, gugu Jurrach (Judas) a-bena, mu-ngoyurra Jesus an-nika jawina a-ni. Minypa aburr-jaranga burr-ganyja gurda an-gujarrcha abi-rrimarra rrapa gun-jong gubi-rrimarra, aburr-gata burrbi-jerrmarra gurda birripa aburr-gatiya wana junggay yerrcha rrapa aburr-werranga burr-guta mu-murna yerrcha. ");
INSERT INTO bvr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jurrach an-gata mu-ngoyurra a-bawuna Jesus, nipa ana-guguyana burrwa ana-bona, gipa mu-ngoyurra gu-jarlapuna a-wena burrwa, a-yinanga, “Ngaypa ngu-macha barra an-gugaliya, an-gatiya nyibi-rrima barra.” ");
INSERT INTO bvr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ganapiya. Minypa birripa aburr-bena, nipa Jurrach jechinuwa ana-jarl ana-bamuna nula Jesus, a-yinanga nula, “Ny-molamola nyi-ni barra, Bunggawa! Gala barra gun-nga ny-borrwa,” lika a-machinga. ");
INSERT INTO bvr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Lika Jesus a-yinanga nula, “Ny-borrmunga apula, ngarla! Wurra wuriya. Gala jipa ni yirda gun-gata nginyipa ny-borrwurrapa nyina-bona.” Lika birripa aburr-mulpiyanapa burr-guya abi-rrimarra. ");
INSERT INTO bvr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Wurra aburr-gata wugupa nula Jesus, ana-ngardapa barrang a-warrkarra, lika a-garlmunapa a-jarrchinga gelama a-jirra an-gata junggay wana an-babalapa an-nika an-mujama. ");
INSERT INTO bvr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Wurra Jesus a-wena burrwa aburr-yigipa jawina, “Jolartcha an-narda barrang. Wurra aburr-yinmiyapa aburr-jaranga abu-warrknga aburr-workiya barrang, birripa aburr-juwa barra ana-barrang ana-guyinda. ");
INSERT INTO bvr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wurra yama ny-borrwa gun-guna? Minyja ngaypa ngu-wenggana Nyanyapa apa, nipa yibirrich burr-jerrma gurda apula aburr-jaranga waykin aburr-guyinda aburr-mujaruk ngunabu-burdima, minypa mun-jaranga murndurn, minypa arr-jirrapa arr-murna rrapa abirri-jirrapa, minypa 12. ");
INSERT INTO bvr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Wurpa minyja gu-yirda gu-ni, gun-narda ngika minypa janguny mu-jurra gu-yurra mu-ngoyurra nguna-ngurrjinga, minypa Wangarr gu-borrwurra apula geka ngunabi-rrimarra.” ");
INSERT INTO bvr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Lika Jesus a-wena burrwa aburr-gata aburr-bachirra, “Nyiburr-gurda, ana-goyburrpa an-nga nula nyiburr-bona gurda barrang burr-guta rrapa gun-jong burr-guta barra ngunabi-rrima? Wurra ana-goyburrpa bama nyiburr-yinanga jimarna ngaypa ngu-bachirra, ya? Wurra ngaypa ngu-jaranga ng-goma ng-gatiya gu-japurra rrawa ngu-ninyarra, marn․gi marn․gi arr-nenga ngu-nirra ngu-workiya janguny, wurra gala ana-goyburrpa ngunabi-rrima. ");
INSERT INTO bvr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Wurra geka gu-yinanga gu-ni apula minypa Wangarr burr-yika aburr-mujaruk ngunyuna aburr-guyinda mu-ngoyurra aburr-wukurrjinga janguny.” Jesus a-yinagata a-wena burrwa aburr-gata aburr-bachirra nula, lika gu-gata wenga aburr-yigipa jawina abu-bawuna, aburr-yurtchinga aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Lika aburr-gata Jesus abi-rrimarrapa, birripa abu-ganyja nula Gayapach (Caiaphas) an-gata wana an-babalapa junggay. Rrapa gatiya gu-yigipa gu-rrawa aburr-gata joborr marn․gi aburr-gunega rrapa aburr-werranga burr-guta mu-murna yerrcha gipa aburr-bamagutuwiyana. ");
INSERT INTO bvr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Wurra Birta jurdach ana-jurrjurrmurra ana-bona, a-bena gun-gata junggay wana an-babalapa gun-nika rrawa, lika a-barrngumurra ngarnama gu-jirra gun-gata minypa jandarra gu-ji gu-gomarriyana, lika minypa yarlanga gu-bala a-rakaja wugupa burrwa aburr-gata jaga aburr-ganaja aburr-workiya gun-gata rrawa. Lika marr gu-ganyja gu-yinmiya barra gu-ni nula Jesus. ");
INSERT INTO bvr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Rrapa gata wupa gu-bala aburr-gata wana junggay yerrcha rrapa aburr-werranga burr-guta ganychila (councillor) yerrcha birripa jarrma gubu-menga nula aburr-ni Jesus, jimarna barra abirri-jirrapa abirri-ngurrja minypa gun-gata gun-ganawa butula janguny bitipa abirri-ngurrja, minypa gu-gurda ngacha burrwa joborr barra minypa mari gubu-garra nula rrapa abu-bu. ");
INSERT INTO bvr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Wurra aburr-yinmiyapa aburr-garlmuna rrapa jarrma gubu-menga nula, wurra minypa gun-birripa janguny ngardapa ngardapa. Wurra nuwurra waypa jurdach abirri-jirrapa abirri-garlmuna, gun-ganawa abirri-ngurrjinga. ");
INSERT INTO bvr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Minypa abirri-yinanga, “An-guna an-gugaliya a-wena, a-yinanga, ‘Ngaypa ngu-murna Wangarr gun-nika bala gun-japurra ngu-rruma, rrapa ngorrngurra abirri-jirrapa gun-ngardapa wupa barrwa ngu-jarlapa.’” ");
INSERT INTO bvr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Lika an-gata junggay wana an-babalapa a-garlmuna, a-yinanga nula Jesus, “Nginyipa gala gun-nga wengga n-dima rraka ny-yengga, ya? Wurra gun-gata gun-nga bitipa abirri-guna minypa birri-ngurrjinga?” ");
INSERT INTO bvr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nipa a-yinagata a-wena an-gata, wurra Jesus nipa bamawa a-ji. Barrwa lika junggay wana an-babalapa a-wena nula Jesus, a-yinagata nula, “Minypa Wangarr ana-ninyarra, wengga arrburrwa: Ny-jurda nginyipiya Nyi-gujerrjerrjiya, ya, Wangarr biy-yika Ny-yalkurpa?” ");
INSERT INTO bvr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Lika Jesus ana-nyala a-wena nula, “Ngaw. Minypa gun-nardiya nginyipa ny-yena. Wurra gun-guna ngaypa ngu-weya ana-gorrburrwa gun-burral: Nuwurra waypa barra gu-gubalmapa gu-ji, ana-goyburrpa nyibi-na barra an-guna An-walkurpa An-gugaliya ana-munganaguwa Wana An-babalapa ana-gera a-ninya barra, rrapa waykin wenga gu-nguparr minypa ana-jeka barra.” ");
INSERT INTO bvr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Gun-narda nipa junggay wana an-babalapa a-galiyana, lika mun-nigipiya mirikal mu-gorndanga a-ni minypa nipa gochila a-barrjinga. Lika a-yinagata, “Nipa an-guna a-wena, wana a-negiyana nula Wangarr, ngarla! Gala barrwa jal nguburr-ni ana-nga barra a-ngurrja arrburrwa an-guna! Wurra gun-nardiya gugu ana-goyburrpa nyiburr-galiyana nula nipa gun-nerra a-wena rrapa wana a-negiyana nula Wangarr. ");
INSERT INTO bvr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Wurra nyiburr-yinmiya nyibu-borrwuja nula nyiburr-nirra?” Birripa aburr-yinanga, “Nipa wupa a-barrbiyana werra a-negiyana. A-juwa barra.” ");
INSERT INTO bvr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Lika aburr-garlmuna, m-bordich abu-balkaja nipa Jesus japurra a-jirra, rrapa aburr-murna abu-buna ");
INSERT INTO bvr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","minypa aburr-yinanga nula, “Ny-jurda ny-borrwiya Christ, marrka ngurrja arrburrwa: Ana-nga biy-buna, ya?” ");
INSERT INTO bvr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Wurra Birta burdak yarlanga a-ninya, lika jin-mujama jina-bona, jiny-yena nula, “Awa, nginyipa ny-jurda burr-guta an-gata Jesus Galali an-guyinda wugupa nyiburr-rrigirrgnga nyiburr-workiya,” jiny-yinagata jiny-yena nula. ");
INSERT INTO bvr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Wurra nipa Birta a-jordajiyana, birripa aburr-galiyana nula. Minypa jonama a-gurkuja burrwa, gala yapa nipa burr-guta abi-rrimangarna. Minypa nipa a-wena, “A-jay, gun-nga ny-yeya ny-boya?” ");
INSERT INTO bvr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Lika a-jarl a-bamuna ngana gu-jirra gun-gata jandarra gu-ji gu-gomarriyana gun-gata rrawa. Rrapa barrwa jin-nerranga jin-mujama a-nana, lika jiny-yena burrwa aburr-gata aburr-ji aburr-ni, “A-lay, an-guna burr-guta a-jurrjurrmunga Jesus an-gata Nejarach (Nazareth) an-guyinda.” ");
INSERT INTO bvr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Wurra Birta barrwa a-jordajiyana, minypa burr-guya a-wena, a-yinagata, “Ngaypa gala marn․gi an-gata an-gugaliya!” ");
INSERT INTO bvr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Lika gun-baykarda ngika, lika aburr-gata aburr-jinyja aburr-gakiyana gurda nula minypa abu-wengganana, “A-lay, nginyipa gala ny-yinmiya ny-jordajiya, wurra ny-jurdiya ny-nyardapiya Jesus biy-yika jawina, ngarla! Ngardawa gun-nginyipa wengga minypa Galali aburr-guyinda aburr-weya aburr-workiya!” ");
INSERT INTO bvr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Lika Birta a-yinagata, “Ngaypa gun-burral ngu-weya ana-gorrburrwa. Gala ngu-yinmiya ngu-jordajiya; galapa Wangarr nguna-bun! Wurra nipa an-gata an-gugaliya ngaypa gala marn․gi nula.” Lika gu-gata wenga bawul gugu jiny-yena, ");
INSERT INTO bvr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","lika Birta gu-borrwurra nipa Jesus geka a-yinmiyana a-wena nula, minypa a-yinanga nula, “Gala barra bawul ni-gugu jiny-yengga, wurra jarra nginyi-gugu ny-jirrapa ny-nyardapa ny-joma ny-jordajiya burrwa jimarna gala marn․gi apula, rrapa nipa nuwurra jurdach bawul jiny-yengga barra.” Gun-narda Birta gu-borrwurra, lika nipa yarlanga a-bena, lika burr-guya a-rruwujana a-ni. ");
INSERT INTO bvr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ana-munyagaba, aburr-gata wana junggay yerrcha rrapa aburr-werranga burr-guta mu-murna yerrcha, birripa wengga gubu-buna aburr-ni aburr-yinmiya barra Jesus abu-bu. ");
INSERT INTO bvr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Lika abu-bichinga an-gubandawiya jirn (chain), lika abu-ganyja, abu-wuna Baylat (Pilate) an-gata Rowm wenga gapman an-guyinda bunggawa. ");
INSERT INTO bvr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Rrapa Jurrach an-gata mu-ngoyurra jawina a-ni nula Jesus wurra barrwa a-bawuna, a-mulpiyana burrwa aburr-gata aburr-bachirra, nipa gu-borrwurrapa gun-gata minypa birripa mari wana gubu-garrana nula Jesus barra minypa a-juwa, lika nipa Jurrach wargugu gu-ni nula minypa nipiya an-mornanga. Lika mun-gata rrupiya mun-mama jilpa (silver) mu-maya, minypa burr-murna burr-rrepara rrapa barrwa arr-jirrapa arr-murna, minypa 30 murna mun-gujuwa mun-gata abu-wuna, nipa mu-ganyja a-jekarra, mu-gurdanyjinga burrwa aburr-gata wana junggay yerrcha rrapa aburr-werranga burr-guta mu-murna yerrcha. ");
INSERT INTO bvr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Minypa nipa Jurrach a-yinanga burrwa, “Ngaypa werra ngu-negiyana, a-lay, gun-gata minypa ngaypa ngu-malchinga ana-gorrburrwa an-gata minypa a-juwa barra, gala werra a-negiyarna a-workiyarna.” Wurra birripa aburr-wena nula, “Marrban gun-gata. Gun-narda gun-nginyipa.” ");
INSERT INTO bvr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Lika Jurrach mu-yerrnyjinga mun-gata rrupiya mun-mama gatiya m-bungguna gu-japurra gu-bala. Lika a-garlmuna, a-bona, jawa a-jirra a-bichiyana nipa ana-murna, lika a-wolawoliyana a-yu, a-juwuna. ");
INSERT INTO bvr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Lika aburr-gata wana junggay yerrcha mbi-menga mun-gata rrupiya, wurra aburr-yinanga aburr-wena, “Mun-guna rrupiya murna mun-gujuwa minypa an-gugaliya a-juwa barra. Mu-gurda ngacha ngayburrpa gala nguburr-yinmiya ngubu-mulpa mun-gata rrupiya gu-galiya yerrcha mbi-barnjinga aburr-workiya nuluwa Wangarr.” ");
INSERT INTO bvr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Lika gubu-borrwurra aburr-yinmiya barra nula mun-gata rrupiya, lika aburr-bona, mbi-barnjinga barra gubu-ma rrawa gun-gata gu-werrapa gu-jirra gu-workiya, gun-gatiya minypa manyjaparna jibu-mangga aburr-workiya, japalana abi-jarlapurda aburr-workiya ji-gata ji-manyjaparna ji-guyinda. Gun-nardiya minypa mu-gatiya rrupiya birripa gubu-menga, gun-gata barra minypa jemitri (cemetery) gu-ji burrwa gu-werranga gu-rrawa wenga aburr-juwa, jarra minypa Ju yerrcha ngardapa. ");
INSERT INTO bvr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Rrapa gu-gurda nula, ngardawa mu-gata ngacha rrupiya birripa gubu-menga gun-gata rrawa, lika ngayburrpa ngubu-ngurrjinga nguburr-workiya gun-gata “Maningan Mu-yurra”, minypa gu-gata wenga rrapa gun-guniya gugu gu-ni burr-guta nguburr-yinagata ngubu-ngurrjinga nguburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Gu-gurda ngacha minypa Wangarr an-nika an-mujaruk an-gata Jeramáya (Jeremiah) mu-ngoyurra gu-ngurrjinga minypa Wangarr a-gurdagurdarrana. Minypa nipa Jeramáya a-wena, “Birripa mbi-menga mun-gata rrupiya mun-mama jilpa mu-maya minypa burr-murna burr-rrepara rrapa barrwa arr-jirrapa arr-murna, minypa 30, mu-gurda ngacha minypa aburr-gatiya Yichrayal (Israel) aburr-bapurr mbi-ngurrjinga murna mun-gujuwa nula an-gata. ");
INSERT INTO bvr_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Lika aburr-bona, mbi-barnjinga, gubu-menga gun-gata rrawa, gun-gatiya minypa manyjaparna jibu-mangga aburr-workiya, japalana abi-jarlapurda aburr-workiya ji-gata ji-manyjaparna ji-guyinda. Gu-gurda ngacha minypa gun-gata gubu-ma barra minypa jemitri gu-ji barra, minypa Wangarr a-wena apula barra aburr-yirda.” ");
INSERT INTO bvr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Gun-gatiya lika Jesus a-jinyja nipa ana-gochila an-gata bunggawa gapman an-guyinda. Lika nipa bunggawa a-garlmuna, a-wengganana Jesus minypa a-yinanga nula, “A-lay, aburr-gaba nginyipa bunggawa burrwa Ju yerrcha, ya?” Jesus a-yinanga nula, “Ngaw, minypa gun-narda nginyipa nyina-wena ngaypa ng-guna,” a-yinagata a-wena. ");
INSERT INTO bvr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Wurra gun-gatiya waypa aburr-gata wana junggay yerrcha rrapa aburr-werranga mu-murna yerrcha jarrma gubu-menga nula aburr-ni, nipa gala gun-nga a-weyarna. ");
INSERT INTO bvr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Lika Baylat (Pilate) an-gatiya gapman bunggawa, nipa a-yinagata nula Jesus, “A-lay, nginyipa gala ny-jaliya, ya, minypa bubu-yopurda aburr-nirra? Wurra yama ny-yengga?” ");
INSERT INTO bvr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Wurra Jesus gala barrwa a-weyarna burrwa. Rrapa gun-narda nula nipa Baylat gochila a-barrjinga nula. ");
INSERT INTO bvr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Wolawola gun-gata janara gu-ji gu-workiyana minypa Yichrayal yerrcha gubu-borrwuja aburr-workiya gun-gata minypa an-mujaruk waykin wenga burr-burndarna, wurra burr-beybana, gun-nardiya gu-ji gu-workiyana janara, gun-gatiya gugu an-gata gapman bunggawa gun-molamola gu-negarra nula a-workiyana an-ngardapa an-gugaliya mu-ngoyurra brichina (prisoner) a-ni, ana-nga minypa birripa wurra gama gorlk jal aburr-ni gu-wulebiya nula. ");
INSERT INTO bvr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Rrapa gun-gatiya gu-ni, an-ngardapa an-gugaliya brichina a-ni an-nelangga Barébach (Barabbas). Nipa wurra gama gorlk marn․gi nula an-gata minypa nipa an-bachirra. ");
INSERT INTO bvr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Lika nuwurra waypa wurra gama gorlk gu-ngardapa aburr-negiyana nula Baylat, nipa a-garlmuna, burr-wengganana, “Ana-nga ngaypa barra ngu-jerrma ana-gorrburrwa? Waygaji an-gata Barébach, ya? Wurra waygaji an-guna Jesus ana-goyburrpa nyibu-ngurrjinga nyiburr-workiya Christ, ya?” ");
INSERT INTO bvr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","A-yinagata a-wena burrwa wurra gama gorlk, ngardawa nipa marn․gi minypa aburr-gata Ju yerrcha bunggawa mu-werrmbarra abi-nana Jesus, rrapa minypa gu-gurda nula birripa abu-ganyja gurda lika abu-wuna. ");
INSERT INTO bvr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Gun-gatiya waypa Baylat gu-rrenyjinga a-ni gun-gata minypa bunggawa an-guyinda gu-rrenyjinga a-nirra a-workiya wolawola minypa burr-mari a-weya, wurra jin-gata Baylat jin-nika jin-gumarrbipa niya janguny guna-jerrmarra nula. Jiny-yinanga jiny-yena, “Bawa an-gata. Nipa gala gun-nerra jama a-jirrarna a-workiyarna. Wurra ngaypa wargugu ngu-ni nula minypa geka borrich ngu-nana nula.” Gu-gurda ngacha janguny nipa Baylat jin-nika guna-jerrmarra nula. ");
INSERT INTO bvr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Wurra wana junggay yerrcha rrapa aburr-werranga mu-murna yerrcha burrbu-jurnajuchuwuna wurra gama gorlk, barra minypa abu-wenggana Baylat barra Barébach gu-wulebiya nula mari rrapa Jesus a-juwa barra. ");
INSERT INTO bvr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Minypa Baylat a-yinagata burrwa, “Ngaypa ana-nga barra ngu-jerrma ana-gorrburrwa?” Wurra birripa aburr-yinagata, “An-gata Barébach!” ");
INSERT INTO bvr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Lika Baylat barrwa a-wena burrwa, “Wurra ngu-yinmiya barra nula Jesus an-guna ana-goyburrpa nyibu-ngurrjinga nyiburr-workiya Christ?” Wurra aburr-gata warrpam aburr-wena, “An-nardiya bupa! Burr-jong negapa rra!” ");
INSERT INTO bvr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Wurra nipa a-yinagata, “An-nga nula? Nipa a-yinmiyana jama a-ji gun-nerra, ya?” Wurra birripa burr-guya aburr-gonyjinga, “Burr-jong negapa rra!” ");
INSERT INTO bvr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Lika gun-gatiya waypa nipa gu-borrwurra minypa nipa gala a-yinmiyarna gu-ngukurdanyjingarna gun-gata mari, wurra jarra wurra gama gorlk aburr-yurtchinga gurda aburr-yurtchinga, lika nipa Baylat bugula gu-menga ana-japalana ana-guyinda, lika murna a-jirra a-wepiyana minypa birripa abi-nana aburr-ji. Minypa a-yinagata burrwa, “An-guna an-gugaliya mun-nigipa maningan gala barra nguna-balka ngu-murna, wurra mun-gata nula ana-goyburrpa barra mornanga nyiburr-ni.” ");
INSERT INTO bvr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Lika warrpam aburr-gata wurra gama gorlk aburr-wena, “Ngaw, ngayburrpa nyiburr-guna barra mari nyibu-ma mun-nigipa maningan — minyja ngayburrpa rrapa aburr-ngayburrpa gu-ngarda yerrcha burr-guta!” ");
INSERT INTO bvr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Aburr-yinagata aburr-wena, lika Baylat gu-lapkujamurra burrwa, lika ana-jerrmarra burrwa an-gata Barébach. Wurra Jesus nipa Baylat a-wena, aburr-yigipa an-dakal Baylat burr-yika abu-jurrburaykujamurra, lika abu-ganyja burr-jong barra abi-negapa abi-rra, abu-wenyaga. ");
INSERT INTO bvr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Lika Baylat burr-yika an-dakal abu-menga Jesus, abu-ganyja wupa gun-gata gu-bala gapman gun-nika, lika burrbu-bamagutuwurra, warrpam aburr-gata an-dakal aburr-mulpiyana rrapa Jesus gojilapa abi-negarra. ");
INSERT INTO bvr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Lika aburr-garlmunapa abu-borrkpuna aburr-ni. Minypa mun-nigipa mirikal mbi-yerrkujamurra nula, lika abu-jolartchinga mirikal maningan mu-maya mun-gata minypa bunggawa an-guyinda a-barrngumiya a-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Rrapa barrwa bornangguna jibi-jarlapuna nula bama a-jirra minypa gun-maywapa an-mumurna an-guyinda bunggawa gun-nika ana-bama gu-garraja a-workiya, wurpa jin-darrartka; lika Jesus ana-bama jibu-barnjinga nula. Rrapa barrwa jurdach gun-jong gubu-menga, abu-wuna ana-munganaguwa murna a-jirra, minypa birripa aburr-ngunyangunyjiyana gun-gata bunggawa gun-nika gun-jong. Lika aburr-menama gubi-rrana nula, abu-borrkpuna aburr-ni, minypa aburr-yinagata aburr-wena, “Awa! Ny-junarda ny-molamola, ya, ny-junardiya bunggawa Ju yerrcha ny-burriya?” ");
INSERT INTO bvr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Lika birripa m-bordich abu-balkaja rrapa abu-gaypuna gun-gata gun-jong, lika bama a-jirra abu-buna aburr-ni gu-gata. ");
INSERT INTO bvr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ganapiya gun-gata minypa abu-borrkpuna aburr-ni, lika mbi-yerrkujamurra nula mun-gata bunggawa an-guyinda mun-nika mirikal, lika barrwa mun-nigipa wupa Jesus mun-nika abu-jolartchinga. Lika abu-ganyja aburr-bena, gugu barra burr-jong abi-negapa abi-rra. ");
INSERT INTO bvr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Gun-gatiya waypa gu-murnangana rrawa gubu-bawuna aburr-bamuna, galamurrpa gubu-garrana an-gugaliya an-gata Jayríny (Cyrene) wenga, nipa an-nelangga Jayman (Simon). Wurra aburr-gata an-dakal abi-rrimarra Jayman barra nipa gun-gata a-bamiya gun-jong Jesus gun-nika birripa abu-wenyaga barra. ");
INSERT INTO bvr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ganapiya, lika aburr-bena rrawa gun-gata gun-nelangga Golgócha (Golgotha), gun-gata minypa ngayburrpa ngubu-ngurrjinga nguburr-workiya, nguburr-yinaga, “An-mama Bama A-jirra A-yurrapa.” ");
INSERT INTO bvr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Gatiya lika birripa jimarn jarra abu-wucharna Jesus wayin (wine) mu-ngoyurra mbi-barnjinga mun-gata mun-guralba mun-guyinda jirrkilja mun-gurrimiya, wurra minypa nipa a-ngamngamjinga, m-bawuna; gala m-bangarna. ");
INSERT INTO bvr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Gatiya waypa burr-jong abi-negarra abi-rrana, abu-wenyagarra, lika mbi-menga mun-nigipa mirikal, lika aburr-dawurrjinga aburr-ni mun-nga mun-gata ana-nga mu-ma barra. ");
INSERT INTO bvr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Lika aburr-ganana aburr-ni, jaga aburr-ganana nula; gala yapa ana-werranga ana-boga, a-man. ");
INSERT INTO bvr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Rrapa waykin gu-gata gu-jong m-balcha mu-yu jurra mun-gata gu-ngurrjinga mu-yu gun-nga mari. Minypa mu-yinanga, “AN-GUNA JESUS NIPA BUNGGAWA JU YERRCHA AN-BURRIYA.” ");
INSERT INTO bvr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Rrapa gatiya burr-jong burrbi-negarrapa burrbi-rrana abirri-jirrapa abirri-ngumurda wugupa nula Jesus gata aburr-balcha aburr-yu ngardapa ngardapa, an-ngardapa ana-munganaguwa rrapa an-nerranga ana-weyka. ");
INSERT INTO bvr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Aburr-jaranga gu-galiya yerrcha abu-beybeybana aburr-ji Jesus, minypa rreymarreyma aburr-ngorrkiyana rrapa gun-bachirra aburr-wena nula, ");
INSERT INTO bvr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Awa! Ny-jurdiya nginyipa jimarna barra n-duma gun-gata bala Wangarr gun-nika gun-japurra, rrapa minypa nuwurra ngorrngurra abirri-jirrapa gun-ngardapa wupa barrwa ny-jarlapa! Wurra yama ny-jarlapiya, jimarna Wangarr biy-yika Ny-yalkurpa? Marrka nyina-bupiyapa!” ");
INSERT INTO bvr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Rrapa wana junggay yerrcha, rrapa joborr marn․gi aburr-gunega, rrapa barrwa aburr-werranga mu-murna yerrcha, birripa aburr-yinagatiya rrapa abu-borrkpuna Jesus. ");
INSERT INTO bvr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Minypa aburr-yinanga, “An-guna wanngu burr-negarra aburr-werranga, wurra nipa gala a-yinmiya wanngu a-negiya an-nardiya, ya? Nipa Bunggawa arrburrwa ngayburrpa Yichrayal nguburr-bapurr, ya? Wurra yama gun-nardiya ana-bupiya gu-gata wenga gu-jong gu-guyinda barra ngayburrpa marr nguburr-balcha nula? ");
INSERT INTO bvr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nipa a-ngurrjiya marr a-balcharra nula Wangarr, wurra minyja nipa Wangarr jal a-ni nula, wanngu a-nega barra; ngardawa an-guna a-wena, ‘Ngaypa Ngu-walkurpa nula Wangarr.’” ");
INSERT INTO bvr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Rrapa abirri-gata abirri-jirrapa abirri-ngumurda abirri-guyinda abirri-balcha abirri-yu wugupa nula Jesus, bitipa abirri-yinagatiya rrapa abirri-borrkpuna. ");
INSERT INTO bvr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Gun-gatiya lika marnnga waykin jiny-ji minypa gojilapa nguburr-bama jiny-jirra jiny-yorkiya, wurra gun-gata rrawa gu-jirra gu-boya gu-garlmunapa an-munya gu-mayana nuwurra marnnga jiny-jakiyana minypa jarlawurr mula gu-jirra gu-jinyjarra jiny-jinyja. ");
INSERT INTO bvr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Gun-gatiya 3 o'clock gu-ni, lika Jesus waykin a-gonyjinga, minypa gun-birripa wengga a-yinanga, “Yilay, Yilay, lama jabaktáni?” minypa ngayburrpa nguburr-weya nguburr-workiya, “Ny-jurda ny-nyaypa Wangarr, ngaypa an-nga nula nguna-bawuna?” ");
INSERT INTO bvr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Gatiya gu-galiya yerrcha aburr-jinyja, aburr-galiyana nula a-gonyjinga, lika aburr-yinanga, “An-guna a-gonyjinga nula Yiláyja (Elijah), a-lay.” ");
INSERT INTO bvr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Lika an-ngardapa ana-yurtchinga, an-nyarlkuch an-guyinda a-menga ana-wargara, minypa gu-balanda sponge, lika a-gurragaja wayin (wine) mun-guralba mun-gata minypa biniga (vinegar), lika gu-jong gu-guyinda a-jarrkarrana, lika ngana a-wuna Jesus. ");
INSERT INTO bvr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Wurra aburr-werranga aburr-yinanga aburr-wena, “Burdak bawa! Marrka ngubi-na barra jimarn jarraka Yiláyja ana-boga, wanngu a-negan.” ");
INSERT INTO bvr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Barrwa Jesus waykin a-gonyjinga, lika nipa an-mawunga a-jerrmiyana nula Wangarr, ganapiya, a-juwuna. ");
INSERT INTO bvr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Rrapa wupa gu-bala Wangarr gun-nika gun-japurra mun-gata mirikal m-balcha mu-yu mu-garlmunapa mu-yerayeragujamiyana mu-yurtchingapa waykin wenga gu-jel. Rrapa jel gu-ngorrkiyana, rrapa gun-gurrema gun-guyinda gu-barrjinga. ");
INSERT INTO bvr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Rrapa gata minypa an-gugaliya abu-jurnumburda aburr-workiya gu-lapkujamiyana, rrapa aburr-jaranga Wangarr burr-yika gu-galiya yerrcha mu-ngoyurra aburr-juwuna nipa gu-yigipa gu-ganyjarr burr-jarrkarrana, ");
INSERT INTO bvr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","aburr-bena gurda. Lika nuwurra waypa Jesus wanngu a-ni, birripa aburr-barrngumurra gu-murnangana rrawa Jirúchalam (Jerusalem) gun-gata Wangarr gu-menga. Lika yarlanga aburr-negiyana burrwa aburr-bona. ");
INSERT INTO bvr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Rrapa bunggawa an-gata minypa an-dakal a-ganyja a-workiya, nipa rrapa aburr-gata wugupa nula jaga aburr-ganana nula Jesus, birripa waypa gubi-nana minypa rrawa gu-ngorrkiyana rrapa gun-nga burr-guta, lika aburr-gurkuja. Minypa gubu-borrwurra, aburr-wena aburr-ni, “Wurriya ngubu-buna? Jarra gun-burral an-guna Wangarr an-nika An-walkurpa!” ");
INSERT INTO bvr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Rrapa jin-jaranga gama jin-guyinda gata aburr-ji, gu-balay wenga wupa gubi-nana gurda aburr-ji, aburr-gatiya minypa mu-ngoyurra abu-jurrjurrmurra Jesus Galali wenga rrapa aburr-gunggajinga nula aburr-workiyana. ");
INSERT INTO bvr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Minypa jin-gata Meri Mektaliny (Mary Magdalene), rrapa barrwa jin-nerranga Meri jin-gata mampa buta Jeymch rrapa Jochap, rrapa barrwa jin-gata mampa buta Jebadi (Zebedee) bijirri-yika walkurpa yerrcha, aburr-gurdiya burr-guta jin-gata gama jin-guyinda gu-balay wenga wupa gubi-nana gurda aburr-ji Jesus a-juwuna. ");
INSERT INTO bvr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","An-ngardapa an-gugaliya gorlk gun-jaranga nula, Aramatíya (Arimathea) an-guyinda an-gata an-nelangga Jochap, nipa burr-guta Jesus an-nika jawina. Rrapa nuwurra waypa balngga gu-ni, ");
INSERT INTO bvr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","nipa ana-bona, a-bena nula Baylat, lika a-wengganana an-gata nula Jesus an-burral mu-ngoyurra a-juwuna. Lika nipa Baylat a-wena burrwa aburr-yigipa an-dakal barra birripa abu-wu. ");
INSERT INTO bvr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ganapiya, lika Jochap a-garlmuna, a-menga, a-ganyja, a-bichinga a-ni Jesus an-burral mu-geka mirikal linan (linen) mu-maya mun-gungarlcha. ");
INSERT INTO bvr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Lika a-barnjinga gata wupa gu-gurrema gu-ngarnama mu-ngoyurra a-gapajinga a-ni nula gun-nigipiya Jochap gun-nika, gun-gata minypa gun-geka gala mu-ngoyurra an-gugaliya abu-barnjingarna. Lika jandarra wana gun-bapala guna-gakaja, ngana gu-jirra gu-jakabuna, lika a-bona. ");
INSERT INTO bvr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Rrapa abirriny-jata Meri Mektaliny rrapa jin-gata jin-nerranga Meri, birrinyjipa gubirrinyu-nana gurda abirrinyu-ni. ");
INSERT INTO bvr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Lika guna-gepana Jarradi gu-ni, aburr-gata wana junggay yerrcha rrapa Berachi yerrcha, birripa aburr-bona gurda nula Baylat. ");
INSERT INTO bvr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Aburr-yinanga nula, “Bunggawa, a-lay, ngayburrpa nyibu-borrwuja an-gata an-guyolkiya, minypa nipa burdak a-ninya, a-ngurrjiyana, a-yinanga a-wena, ‘Ngorrngurra abirri-jirrapa gun-ngardapa gu-ni barra, ngaypa wanngu ngu-ni barra.’ ");
INSERT INTO bvr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Wurra ngaw minyja nginyipa ny-yengga barra aburr-nginyipa an-dakal derta gubi-nega gun-gata ngana gu-jirra nuwurra abirri-jirrapa gun-ngardapa ngorrngurra gu-ni, minypa nipa gala a-yinmiya a-garlma, wurra jarra gun-burral a-mungbiyanapa. Minypa gala yapa aburr-yigipa jawina abu-man, abu-ngurrjin burrwa wurra gama gorlk nipa mu-ngoyurra a-juwuna jimarna wanngu a-negiyana. Ngardawa gu-gurda ngacha jarrma gubu-man, gun-narda gun-nerra gun-gumungba; gun-gata jarra minypa mu-ngoyurra a-ngurrjiyana gochila gochila an-gurra nipiya, gun-narda marr gu-yinanga.” ");
INSERT INTO bvr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Lika Baylat a-wena burrwa, “Burrbu-ma mun-ngardapa mu-murndurn aburr-ngaypa an-dakal, buburr-boy, derta bubi-nega burr-guya gun-gata ngana gu-jirra gubi-jakabunapa.” ");
INSERT INTO bvr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ganapiya, lika aburr-bona, lika jandarra ngana gu-jirra gubi-jakabunapa derta gubi-negarra aburr-ni gu-gata galanyan gu-guyinda, minypa barra ana-nga gu-gakajin gun-gata jandarra, birripa barra marn․gi aburr-ni. Ganapiya, lika aburr-gata wana junggay yerrcha gubu-bawuna, wurra aburr-gata Baylat burr-yika an-dakal jaga aburr-ganana nula aburr-ni gun-gata jandarra. ");
INSERT INTO bvr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Gun-gata Jarradi (Saturday) gu-wulebiyana, lika nuwurra waypa Jandi (Sunday) ngana guna-ngarlcha, jin-gata Meri Mektaliny (Mary Magdalene) rrapa jin-gata jin-nerranga Meri, birrinyjipa abirriny-jarlmuna, abirriny-bona, gubirrinyu-nana gun-gata gun-gurrema mu-ngoyurra Jesus abu-jolartchingapa. ");
INSERT INTO bvr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Rrapa gun-gatiya gugu jel burr-guya gu-ngorrkiyana minypa Wangarr an-nika an-mujaruk waykin wenga ana-bupiyana, gu-gakaja gun-gata jandarra gubu-jakabunapa, lika a-rakaja, gu-rrenyjinga a-ni gun-gata. ");
INSERT INTO bvr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Minypa nipa a-jayanayana gun-maywapa minypa a-mirlchinga a-workiya, rrapa mun-nigipa mun-gubarrbiya burr-guya mu-ngarlcha mu-ji. ");
INSERT INTO bvr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Lika aburr-gata jaga aburr-ganana aburr-ni gun-gata jandarra, birripa burr-guya aburr-gurkuja nula an-gata, minypa aburr-wurrwurrjinga, aburr-bungguna gu-jel gun-maywapa minypa aburr-juwuna. ");
INSERT INTO bvr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Wurra abirriny-jata mu-gama yerrcha, nipa an-gata waykin an-guyinda an-mujaruk a-wena burrinyjula, “Gala barra nyirriny-jurkuja. Wurra ngaypa marn․gi ana-gorrinyjula nyirriny-yecharra nula Jesus burr-jong abi-nenga abi-rracha. ");
INSERT INTO bvr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wurra nipa gala a-ni an-guna. Wurra gipa a-molamiyana minypa nipa mu-ngoyurra a-ngurrjiyana ana-gorrburrwa. Minyja birriny-boy gurda, birrinyu-na yinda abu-barnjinga, wurra gun-nyagara; an-gapulga. ");
INSERT INTO bvr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Wurra yibirrich birriny-boy, birriny-yengga burrwa aburr-yigipa jawina. Birriny-yinda burrwa, ‘Nipa a-juwuna, gu-gata wenga wanngu a-ni, wurra gun-nardiya gugu nipa mu-ngoyurra a-bona ana-gorrburrwa gun-gata Galali (Galilee) gatiya barra nyibi-na.’ Ganapiya, gun-nardiya ngaypa ngu-wena ana-gorrinyjula.” ");
INSERT INTO bvr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Lika abirriny-jata abirriny-jurkuja, wurpa lika abirriny-marrkapchinga. Lika gun-gurrema gun-gata gubirriny-bawuna abirriny-yurtchinga barra abirriny-yengga burrwa Jesus burr-yika jawina. ");
INSERT INTO bvr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Abirriny-yurtchinga abirrinyu-ni, gugu Jesus a-bena burrinyjula, a-yinanga burrinyjula, “Nyirriny-molamola nyirrinyu-ni barra; gala barra gun-nga nyirriny-borrwa.” Lika abirriny-jakiyana gurda nula, rrepara a-jirra abirrin-dimarra rrapa abirriny-marrngoypiyana nula. ");
INSERT INTO bvr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Lika a-yinagata burrinyjula, “Gala barra nyirriny-jurkuja. Wurra birriny-boy, birriny-yengga burrwa aburr-ngaypa worlapa apa yerrcha barra aburr-boy Galali; gatiya barra ngunabi-na.” ");
INSERT INTO bvr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Gun-gatiya minypa birrinyjipa abirriny-bona, wurra aburr-werranga aburr-gata an-dakal, birripa aburr-jekarra gu-murnangana rrawa rrapa gubu-ngurrjinga burrwa aburr-gata wana junggay yerrcha gun-gata gu-yinmiyana gu-ni. ");
INSERT INTO bvr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Lika aburr-gata wana junggay yerrcha rrapa aburr-werranga mu-murna yerrcha burr-guta, birripa gu-ngardapa aburr-negiyana, wengga gubu-buna aburr-ni, ganapiya. Lika rrupiya wana burrbu-wuna aburr-gata an-dakal, rrapa minypa burr-nganagobagubuna barra gubu-jordaja janguny. ");
INSERT INTO bvr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Minypa aburr-yinanga burrwa, “Ana-goyburrpa barra nyiburr-yinda nyiburr-wengga burrwa nyiburr-boy, ‘Minypa ana-munya gu-ni, aburr-yigipa jawina Jesus burr-yika aburr-jorlchinga, abu-menga, abu-ganyja aburr-bona minypa ngayburrpa nyiburr-yu.’ Nyiburr-yirda barra nyiburr-wengga, ");
INSERT INTO bvr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","rrapa minyja gun-narda janguny gu-jeka nula Baylat (Pilate), wurra gala gun-nga rraka ana-goyburrpa nyibu-borrwa, jarra ngayburrpa gun-molamola nyibi-nega barra ana-gorrburrwa; gala barra mari nyibu-ma.” ");
INSERT INTO bvr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ganapiya, lika aburr-gata an-dakal mun-gata rrupiya mbi-menga, lika aburr-yinagata aburr-wena minypa aburr-gata wana junggay yerrcha rrapa mu-murna yerrcha gu-weng ngana burrbu-wuna. Minypa gu-gurda ngacha janguny Ju yerrcha aburr-galiyarra aburr-workiya, gu-barrjeknga gu-nirra gu-workiya. ");
INSERT INTO bvr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Gu-gata wenga Jesus burr-yika jawina aburr-gata minypa arr-jirrapa arr-murna rrapa an-ngardapa, minypa 11, birripa aburr-bona Galali gata gu-bulgapulga Jesus mu-ngoyurra gu-ngurrjinga burrwa. ");
INSERT INTO bvr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Lika gatiya nuwurra waypa abi-nana, birripa aburr-marrngoypiyana nula aburr-ni, wurra wuriya aburr-werranga gun-jaranga gubu-borrwurra. ");
INSERT INTO bvr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Lika Jesus yi-gurrepa a-negiyana burrwa, lika a-wena burrwa, “Ngun-anya nguna-wuna warrpam ganyjarr ngu-rrimanga, minypa yi-gaba waykin rrapa ay-ngunyuna gu-jel. ");
INSERT INTO bvr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ganapiya, lika buburr-boy, gu-werranga gu-werranga gu-rrawa burrbu-ma gu-galiya yerrcha barra jawina aburr-ni apula. Bama burrbu-gurraga nipa an-nelangga Nyanyapa arrku rrapa an-guna An-walkurpa rrapa Mern An-mawunga. ");
INSERT INTO bvr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Rrapa barrwa marn․gi burrbi-nega barra minypa gubu-borrwa gun-gabagata joborr gun-guyinda ngaypa ngu-ngurrjinga ana-gorrburrwa. Rrapa ngaypa barra wugupa ana-gorrburrwa nuwurra gu-gubalmapa.” ");
INSERT INTO bvr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Gun-gunaga gun-molamola janguny Jesus Christ gun-nika, nipa Wangarr an-nika An-walkurpa. ");
INSERT INTO bvr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Wola Wangarr an-nika an-mujaruk an-gata Aycháya (Isaiah) gun-guna a-wukurrjinga minypa Wangarr a-wena nula an-nigipa An-walkurpa, a-yinanga nula, “Minyja na, an-ngaypa an-mujaruk mu-ngoyurra ngu-jerrma barra nggula, nipa barra nawanawa a-ni nggula jarlakarr.” ");
INSERT INTO bvr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","A-yinagata, “Nipa a-jabarrchinga a-jirra yi-gata gu-werrapa, nipa a-yinaga a-weya, ‘A-lay, nipa Bunggawa ana-boya! Jarlakarr nawanawa buburr-ni nula! Gun-jechinuwa bubi-nega nula!’” ");
INSERT INTO bvr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","A-yinagata Aycháya a-wukurrjinga, rrapa gu-gurda ngacha minypa nuwurra Jon (John) a-bena, nipa Wangarr nyanma ana-jerrmarra an-mujaruk. Minypa gata gu-werrapa wurra gama gorlk aburr-bona nula nipa Jon a-wena burrwa a-ni rrapa bama burr-gurragaja. Minypa a-yinanga burrwa, “Gun-nerra bubu-bawa rrapa buburr-ngukurdanyjiya nula Wangarr, rrapa ngaypa bama arr-gurraga barra minypa nipa Wangarr rrapa baywarra gu-nega barra ana-gorrburrwa gun-nerra nyibi-rrimarra.” ");
INSERT INTO bvr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Aburr-jaranga aburr-bona gurda nula Jon, aburr-galiyana nula a-wena. Judíya (Judea) wenga aburr-bona gurda minypa rrawa wana gu-bapala gun-gata, rrapa rrawa gu-jirra gu-boya Jirúchalam (Jerusalem) gu-gata wenga aburr-bona gurda. Minypa birripa gubu-bawuna mu-ngoyurra gun-nerra jama aburr-ji, lika Jon bama burr-gurragaja gatiya man․garba gu-guyinda gun-nelangga Jordan. ");
INSERT INTO bvr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nipa Jon mirikal a-barrngumurra a-workiyana jin-murga gemul (camel) jibi-jarlapuna wurpa lika burr-guya mun-derta, rrapa jin-maliyarra a-barrbichiyana a-workiyana. Rrapa nipa jiny-barra a-workiyana jin-gubatpatcha, rrapa woma gu-barra a-workiyana. ");
INSERT INTO bvr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Rrapa wurra gama gorlk nipa gu-ngurrjinga burrwa, a-yinanga a-wena, “A-lay, an-nerranga barrwa ana-boya nipa wana, wurra ngaypa ng-gunaga ngu-delipa. Minypa ngaypa gala wana rraka ngu-yigipa ngu-mujama ngu-ni nula rrapa ng-gurduwuja rrapa minypa ngu-yerrkujama nula ngu-workiya gun-nigipa nipa a-barrngumiya a-workiya rrepara a-jirra. Wurra ngaypa gala ngu-yinmiya; jarra ngaypa ngu-delipa. ");
INSERT INTO bvr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Minyjiya. Ngaypa bama arr-gurragaja ngu-workiya gu-bugula gu-guyinda, wurra nipa bama nyirr-gurraga barra Mern An-mawunga.” ");
INSERT INTO bvr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Gun-gatiya gugu nipa Jesus ana-bona Nejarach (Nazareth) wenga wurra gun-nelangga wana gu-bapala Galali (Galilee). Lika nipa Jesus a-bena, lika Jon ana-nyala bama a-gurragaja man․garba gu-guyinda gun-gata Jordan. ");
INSERT INTO bvr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Lika gu-gata wenga Jesus ana-warrchinga rrapa minypa gu-nana waykin gu-lapkujamiyana rrapa Mern An-mawunga nipa minypa mukumul a-maya ana-bupiyana, a-bena nula. ");
INSERT INTO bvr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Lika ana-manyjirda a-galiyana, waykin wenga ana-wena nula, “Nginyipa ny-jurda ny-nyaypa Walkur ngaypa burr-guya jal ngu-nirra nggula; ngaypa ngu-marrkapchinga nggula.” ");
INSERT INTO bvr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Warrika Mern An-mawunga ana-nyala gu-werrapa a-ganyja Jesus, ");
INSERT INTO bvr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","gata a-ni ngorrngurra gun-jaranga minypa 40. Rrapa walkwalk an-bachirra an-gata Jeytan (Satan), nipa a-bena nula Jesus rrapa a-jurnajuchuwurra a-ni jimarna nipa barra werra a-negiya. Rrapa aburr-mugat burr-guta gata aburr-ni aburr-workiyana, wurra Wangarr burr-yika waykin aburr-guyinda aburr-mujaruk aburr-bona gurda, aburr-bena nula, Jesus aburr-gunggajinga nula. ");
INSERT INTO bvr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nuwurra waypa Jon abi-rrimarra rrapa wupa abu-barrbuna brichina (prisoner), lika Jesus a-jekarra Galali, gatiya minypa Wangarr gun-nika gun-molamola janguny gu-ngurrjinga a-bona, ");
INSERT INTO bvr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","a-yinanga a-wena, “Gun-balmapa gu-jirra gu-boya Wangarr gun-nika rum gu-bengga barra. Wurra gun-nerra nyibi-rrimanga bubu-bawa, buburr-ngukurdanyjiya rrapa marr buburr-balcha nula gun-nigipa gun-molamola janguny.” ");
INSERT INTO bvr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Gata Galali Jesus gu-rrarnba a-bamuna, lika bijirri-nana jichicha jama abirri-ji abirri-workiyana Jayman (Simon) rrapa an-nigipa worlapa niya Andru (Andrew), bitipa mulucha mu-guyinda abirri-menga abirri-ni. ");
INSERT INTO bvr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Lika Jesus a-gonyjinga butula, “Guwa! Ngunabirri-jurrjurrma ngaypa barra ajirri-gurdagurdarra ana-gotipa nyirri-yinmiya barra gu-galiya yerrcha nyirrbu-ma.” ");
INSERT INTO bvr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Warrika bitipa mbirri-bawuna mulucha, lika abirri-jurrjurrmurra Jesus. ");
INSERT INTO bvr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Lika Jesus a-garlmuna gun-baykarda ngika, lika bijirri-nana Jeymch (James) rrapa an-nigipa worlapa niya Jon abirri-gata nipa Jebadi (Zebedee) bijirri-bokamurra, birripa mu-michiyang aburr-ni, nawanawa aburr-ni mun-gata mulucha. ");
INSERT INTO bvr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Gata bijirri-nana Jeymch rrapa Jon a-gonyjingapa butula, lika bitipa an-bitipa nyanyapa buta rrapa aburr-yigipa aburr-mujama burr-guta burrbu-bawuna gata mu-michiyang aburr-ni, lika abirri-jurrjurrmurra Jesus. ");
INSERT INTO bvr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesus rrapa aburr-yigipa jawina aburr-bamuna, aburr-bena rrawa Gapárniyam (Capernaum). Lika Jarradi (Saturday) gu-ni, lika Jesus a-garlmuna, a-bona, gun-gata bala a-barrngumurra Ju (Jew) yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya. Lika wurra gama gorlk marn․gi burr-negarra a-ni janguny. ");
INSERT INTO bvr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Lika birripa gochila aburr-barrjinga nula, ngardawa nipa wana an-babalapa a-wena burrwa a-ni rrapa ngika minypa aburr-birripa joborr marn․gi burrbi-negarra aburr-workiyana. ");
INSERT INTO bvr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Rrapa an-ngardapa an-gugaliya gatiya gu-bala, nipa walkwalk a-rrimarra. ");
INSERT INTO bvr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Lika gatiya gugu a-gonyjinga burr-guya, “Awa! Ny-junarda nginyipa Jesus Nejarach nyi-guyinda! Wurra an-nga nula nyina-bona arrburrwa ngayburrpa? Wurra nyirr-bu barra, ya? Ngaypa marn․gi nggula nginyipa. Nginyipa Wangarr biy-yika, ngarla! Janguny nginyipa n-dimanga gun-nigipiya Wangarr gun-nika!” ");
INSERT INTO bvr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Lika Jesus ana-nyala a-jobujobuna an-gata walkwalk, “Ngarmbuwa! Nyina-bengga! Bawa an-garda!” ");
INSERT INTO bvr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Lika an-gata an-gugaliya walkwalk ana-nyala a-ngorrkuja a-ni, burr-guya a-gonyjinga, a-bawuna ana-bena. ");
INSERT INTO bvr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Lika wurra gama gorlk gochila aburr-barrjinga, rrapa minypa aburr-wengganachichiyana aburr-ni, “A-lay, gun-guna gun-nga? Wurra gun-geka janguny, minypa burr-ganyjarr, ngarla! Minyja an-guna a-weya a-boya, walkwalk an-guyinda gu-yagurrmunga nula, ngarla!” ");
INSERT INTO bvr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ganapiya, lika Jesus gun-nika janguny gu-barrjekarra gu-jarl, Galali aburr-guyinda aburr-galiyana nula rrawa gu-jirra gu-boya. ");
INSERT INTO bvr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Gun-gata waypa gubu-bawuna aburr-bona gun-gata bala Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya, lika Jesus a-bona wugupa butula Jeymch rrapa Jon, jechinuwa aburr-bona Jayman rrapa Andru gun-bitipa rrawa. ");
INSERT INTO bvr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Rrapa Jayman jin-nika jaburpa niya jin-gata jiny-yorrpuna jiny-yu minypa jin-donga jiny-ji, lika gatiya Jesus a-bena, warrika jibu-ngurrjinga nula. ");
INSERT INTO bvr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Lika a-bona, a-bena achila, mernda jiny-jirra jin-dimarra, jiny-jarrkarrana, gugu gu-bona achila gu-derda. Lika jiny-jarlmuna, balaja burr-wuna jiny-bona. ");
INSERT INTO bvr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Lika yi-rrana gu-ni, lika wurra gama gorlk burrbu-ganyja gurda nula Jesus aburr-gurderdakurderda rrapa walkwalk abi-rrimarra. ");
INSERT INTO bvr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Wurra gama gorlk aburr-jaranga aburr-gata gu-ngardapa aburr-negiyana, gun-gata bala ngana gu-jirra yarlanga aburr-ji. ");
INSERT INTO bvr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Lika Jesus bin-dimarra gu-derda gubi-rrimarra, rrapa walkwalk abi-rrimarra a-yerrnyjinga burrwa a-ni. Wurra minypa walkwalk yerrcha burr-nganagobagubuna, ngardawa birripa marn․gi nula nipa Wangarr an-nika An-walkurpa, wurra nipa gala jal a-nirrarna walkwalk ana-nyala a-ngurrja. ");
INSERT INTO bvr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ganapiya, lika aburr-yu. Wurra Jesus ana-munya a-garlmuna, rrawa gu-bawuna, ngardapa a-bona gu-werrapa, gata minypa a-wengganana a-ni. ");
INSERT INTO bvr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Wurra Jayman birripa aburr-garlmuna, aburr-wecha nula aburr-bona. ");
INSERT INTO bvr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Lika gu-gata wenga aburr-bena nula, lika aburr-wena nula, “A-lay, aburr-gaba aburr-jaranga aburr-wecharra nggula.” ");
INSERT INTO bvr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Wurra Jesus a-yinanga a-wena burrwa, “A-lay, yi-gaba nguburr-boy rrawa gu-jirra gu-boya aburr-gata burr-guta barra ngu-wengga burrwa. Gu-gurda nula nguna-bona, ngarla.” ");
INSERT INTO bvr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Lika gu-gata wenga aburr-gomarriyana aburr-yu gun-gatiya Galali rrawa gu-jirra gu-boya, rrapa Jesus gu-ngurrjinga burrwa a-workiyana janguny gata wupa gu-bala Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya, rrapa mola walkwalk a-yerrnyjinga burrwa a-bona. ");
INSERT INTO bvr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","An-ngardapa an-gugaliya an-gata an-jeja a-ngolkujarra minypa gun-guburlububurluja gu-rrimarra, nipa ana-bona nula Jesus, lika ana-menama gu-rrana nula, lika a-wengganana, “A-lay, nginyipa ganyjarr n-dimanga barra minyja nginyipa jal nyi-ni gun-nerra ny-yerrnyja apula.” ");
INSERT INTO bvr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Lika Jesus a-worijinga nula, lika mernda a-jirra a-garlmuna, a-rrimarra. A-yinanga, “Jal ngu-nirra. Ganapiya. Ny-molamola.” ");
INSERT INTO bvr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Lika an-gata an-gugaliya gun-nerra gu-bona nula, an-molamola gugu warrpam. ");
INSERT INTO bvr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Lika warrika Jesus burr-guya a-wena nula, lika a-jerrmarra. ");
INSERT INTO bvr_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Minypa a-yinagata nula, “A-lay, galiya apula. Gala barra nguna-ngurrja ngaypa ngiy-jarlapuna. Wurra gun-narda gun-nginyipa wupa janguny yongun nyi-nega barra. Wurra boy, gurdagurdarriya nula junggay an-guyinda, rrapa wu minyjak barra nipa a-yalpa nula Wangarr an-nigipa. Ngardawa gu-gurda ngacha joborr Mojich (Moses) gu-gurrmurra gun-guwarr minypa barra wurra gama gorlk marn․gi aburr-ni nggula minypa gun-nerra gu-bona nggula.” ");
INSERT INTO bvr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Wurra an-gata an-gugaliya a-bona, gu-ngurrjinga burrwa a-rrigirrgarra. Lika gu-gata wenga Jesus gala a-yinmiyarna a-beyarna rrawa, gala yapa burr-guya abu-marnja wurra gama gorlk; wurra jarra gu-werrapa a-ni. Wurra wuriya. Wurra gu-jaranga gu-rrawa wenga aburr-bona gurda nula aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Gu-gata wenga ngorrngurra gun-jaranga ngika, lika Jesus ana-jekarra Gapárniyam (Capernaum). Lika gun-gatiya waypa gubu-borrwurra wurra gama gorlk nipa ana-jekarra, ");
INSERT INTO bvr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","lika aburr-jaranga aburr-garlmuna gurda nula, wupa gu-bala aburr-barrngumurra aburr-yu, gu-ngana aburr-mayana rrapa yarlanga gala melek gu-jirrarna. Rrapa Jesus a-wena burrwa a-ni Wangarr gun-nika janguny. ");
INSERT INTO bvr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Barrwa abirri-jirrapa abirri-jirrapa gu-galiya yerrcha an-birripa an-borrmunga an-nyarlkuch abu-ganyja gurda nula Jesus, ");
INSERT INTO bvr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","wurra gala aburr-yinmiyarna aburr-barrngumiyarna, aburr-beyarna nula, wurra aburr-gata aburr-gorlkakaja aburr-ji ngana gu-jirra. Lika nipa an-gata an-nyarlkuch aburr-yigipa aburr-borrmunga abi-jarrkarrana, gu-bala waykin jonama gu-jirra gu-guyinda aburr-warrchinga. Lika bala gubu-lapkujamurra, lika abu-barnjinga, garrung mu-guyinda a-bupiyana a-bamuna, a-bena nula Jesus. ");
INSERT INTO bvr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Gun-gatiya waypa Jesus gu-nana burrwa minypa birripa burr-guya marr aburr-balcha nula aburr-ni, lika nipa a-wena nula an-nyarlkuch, “A-lay, walkur, nginyipa werra nyi-negiyana gipa gugu baywarra gu-ni nggula.” ");
INSERT INTO bvr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","A-yinagata nula, wurra aburr-werranga aburr-jinyja joborr marn․gi aburr-gunega, birripa bama aburr-jirra wupa gubu-borrwurra aburr-ni, ");
INSERT INTO bvr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“A-lay, an-guna an-nga nula nipa a-yinagata a-weya? Wurra nipiya an-gugaliya wana a-negiya nula Wangarr, ya? Wurra an-gugaliya werra a-negiya a-workiya gala ana-nga a-yinmiya a-rorrcha nula mari wurra Wangarr nipa wupa an-ngardapiya jarra.” Aburr-yinagata gubu-borrwurra nula aburr-ni wuparnana aburr-ngurrnga. ");
INSERT INTO bvr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Wurra nipa Jesus gu-nana burrwa gun-gata birripa gubu-borrwurra nula, lika nipa a-wena burrwa, “An-nga nula ana-goyburrpa nyiburr-yinagata nyibu-borrwuja apula nyiburr-nirra? ");
INSERT INTO bvr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wurra gun-nga gun-guna jimarna ana-goyburrpa bama nyiburr-yinaga gun-derta apula rraka ngaypa ngu-yirda nula an-guna, ya? Minyja ngu-yinda nula, ‘Nginyipa werra nyi-negiyana ny-yorkiyana gipa gugu baywarra gu-ni nggula,’ gu-gurda ngacha, ya, wurra minyja ngu-yinda nula, ‘Garlma, mun-nginyipa garrung ma, jarlabiya’? ");
INSERT INTO bvr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Wurra ngaypa arr-gurdagurdarra barra minypa an-guna An-walkurpa An-gugaliya ganyjarr gu-rrimanga gun-guniya rrawa nipa barra baywarra ngu-nega ana-gorrburrwa gun-nerra nyibi-rrimarra.” Lika a-wena nula an-nyarlkuch, ");
INSERT INTO bvr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“A-lay, galiya apula ngu-weya nggula: Garlma, jinyja! Mun-nginyipa garrung ma, lika bamiya boy rrawa!” ");
INSERT INTO bvr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Lika aburr-jaranga aburr-gata abi-nana an-nyarlkuch a-garlmuna, garrung mu-menga, lika a-bamiyana a-bona. Lika gochila aburr-barrjinga nula Jesus burr-barlmarrk jama a-ji. Lika Wangarr aburr-marrkapchinga nula aburr-ni, aburr-yinanga, “A-lay, gun-narda gala ngubi-nacharna nguburr-workiyarna, ngarla!” ");
INSERT INTO bvr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Lika Gapárniyam wenga Jesus ana-jekarra gu-rrarnba gun-gata Galali. Lika wurra gama gorlk aburr-bona gurda nula aburr-ni, lika marn․gi burr-negarra aburr-bamuna janguny. ");
INSERT INTO bvr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Lika gu-gata wenga Jesus a-nana an-gugaliya an-nelangga Libay (Levi), nipa an-walkurpa, an-jirrpungapa Alpiyach (Alphaeus). Nipa Libay gapman (government) jama a-ji a-workiyana minypa rrupiya mu-menga nula a-workiyana, gu-galiya yerrcha burr-gaypuna. Gatiya gu-birlapirla nipa Libay a-ni a-workiyana rrapa jama a-ji nipa Jesus ana-nyala a-nana, lika a-wena nula, “Guwa! Nguna-jurrjurrma.” Lika nipa Libay a-garlmuna, lika a-jurrjurrmurra Jesus. ");
INSERT INTO bvr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Gu-gata wenga Jesus balapala a-rrenyjinga Libay. Rrapa gun-gatiya waypa nipa Jesus rrapa aburr-yigipa jawina balaja mbi-barra aburr-ni, aburr-jaranga aburr-gata wugupa burrwa mbi-barra aburr-ni, aburr-gatiya minypa aburr-mujama nula gapman rrupiya mbi-mangga nula aburr-workiya, gu-galiya yerrcha burrbu-gaypurda, rrapa minypa aburr-werranga burr-guta aburr-gata aburr-werra birripa wugupa nula Jesus mbi-barra aburr-ni. Ngardawa aburr-jaranga abu-jurrjurrmurra aburr-workiyana. ");
INSERT INTO bvr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Lika aburr-gata joborr marn․gi aburr-gunega aburr-welangga Berachi (Pharisee), birripa waypa abi-nana Jesus gata wugupa mbi-barra aburr-ni aburr-gata aburr-werra rrapa aburr-gata aburr-mujama nula gapman, lika aburr-wena burrwa Jesus burr-yika jawina, aburr-yinanga burrwa, “An-nga nula nipa Jesus wugupa burrwa aburr-guna mbi-banga aburr-nirra? Wurra birripa jarra aburr-mujama nula gapman, rrupiya mbi-mangga nula aburr-workiya minypa wurra gama gorlk burrbu-gaypurda, ngarla! Rrapa aburr-werranga aburr-guna birripa burr-guta aburr-werra!” ");
INSERT INTO bvr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Lika Jesus a-galiyana burrwa, lika gun-maywapa ranginy a-wena burrwa. A-yinagata, “Gu-galiya yerrcha aburr-gata aburr-mola, birripa gala jal aburr-ni an-buburda barra bin-dima, wurra aburr-gata aburr-yorrpurda birripa wupa jarra. Gun-narda minypa ngaypa gala nguna-boyarna burrwa aburr-gata minypa jechinuwa aburr-nirra, wurra jarra ngaypa nguna-bona burrwa aburr-gata aburr-werra birripa barra gun-nerra gubu-bawa.” ");
INSERT INTO bvr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Gun-gatiya gun-nerranga gu-ni, Jon rrapa aburr-yigipa jawina rrapa mola aburr-gata Berachi yerrcha, birripa balaja mbi-bawuna aburr-ni, ngardawa gun-birripa gun-guwarr Yichrayal (Israel) aburr-bapurr gun-burriya, minypa wolawola balaja mbi-bawuna aburr-workiyana gun-guwenggana nula. Wurra aburr-werranga aburr-garlmuna, Jesus abu-wengganana. “A-lay, aburr-gurda Jon burr-yika rrapa mola Berachi yerrcha birripa balaja mbi-bawuna, wurra jarra aburr-nginyipa an-nga nula gala mbi-bawujarna?” ");
INSERT INTO bvr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Lika Jesus gu-ngurrjinga burrwa, a-yinanga, “Gun-narda ana-goyburrpa ngunabu-wengganana, wurra marrka bubu-borrwa gun-maywapa ranginy barra marn․gi nyiburr-ni: Minypa an-ngardapa gochila a-rranapa nipa jiny-ma barra jin-nigipa gama, rrapa gatiya waypa aburr-yigipa jawina aburr-mulpiya nula balaja barra mbi-bay rrapa aburr-worlworlcha burrinyjula, birripa gala aburr-yinmiya wargugu aburr-ni rrapa balaja mbi-bawa. Jarra nipa an-gata burdak wugupa burrwa. ");
INSERT INTO bvr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Wurra barrwa guna-bamburda aburr-werranga burrbu-gaypa barra lika abu-ga barra aburr-boy, gun-gatiya jarra minypa aburr-yigipa jawina balaja mbi-bawa barra. ");
INSERT INTO bvr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Rrapa minypa ana-goyburrpa nyibu-ngurrjinga apula gun-goyburrpa gun-guwarr, jarra ngaypa minypa nguna-ganyja ana-gorrburrwa gun-geka janguny. Rrapa gun-narda nula marrka bubu-borrwa gun-maywapa ranginy minypa gun-guna: Minyja mun-delipa mun-gata mirikal mun-maywa m-barrja rrapa ay-birlpa, wurra gala arr-yinmiya mu-geka mu-guyinda ay-birlpa mun-gata mun-maywa. Gala yapa jurdach ay-wepa rrapa mun-gata mun-geka mu-ngoyurra ay-barnjinga galapa mun-delipa mu-ningin m-bamun rrapa mun-gata ay-birlpana mu-garlmapa wana mun-babalapa m-barrjin. ");
INSERT INTO bvr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Rrapa barrwa gun-maywapa ranginy minypa an-gugaliya an-gata wayin (wine) mu-jarlapurda a-workiya: Nipa mun-girra mu-mangga, lika ji-maliyarra ji-guyinda mu-jerrjerrjinga a-workiya yi-gata wupa, wurra nipa gala a-yinmiya jin-gata jin-maywa ji-guyinda mu-jerrjerrja, mu-ngoyurra jinyu-derichinga. Wurra mun-girra m-bongbongja rrapa wana mu-ni, galapa jin-gata jin-maliyarra jiny-birljin minypa mun-gata mun-girra m-boga mu-jingin rrapa jin-gata jin-maliyarra gun-nyagara gu-ningin. Wurra jarra mun-geka wayin an-gugaliya mu-jerrjerrjinga a-workiya ji-maliyarra ji-guyinda ji-geka jarra.” ");
INSERT INTO bvr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Lika Jarradi (Saturday) gu-ni, Jesus rrapa aburr-yigipa jawina marlgaway gu-jirra aburr-bamuna. Lika aburr-yigipa jawina mipila mu-jirra mbi-muluwurra aburr-bamuna mun-gata mun-gubay, minypa mun-anngiya, borichel, wurra mun-nerranga. ");
INSERT INTO bvr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Lika Berachi yerrcha aburr-wena nula Jesus. “A-lay, aburr-gurda burr-na aburr-nginyipa jawina. Wurra an-nga nula gun-ngayburrpa joborr gubu-rrumunga aburr-nirra? Wurra geka Jarradi gu-ni ngayburrpa gala nguburr-yinmiya jama nguburr-ji, wurpa niya balaja ngubu-muluwa burr-guta!” ");
INSERT INTO bvr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Lika Jesus a-wena burrwa, “Wurra ana-goyburrpa gala mu-jurra nyibi-nacharna nyiburr-workiyarna, ya, gun-gata janguny Daybit (David) gun-nika? Jarra ana-goyburrpa nyibi-nacha nyiburr-workiya, wurra gala meyali nyibu-borrwa. Minypa gun-gatiya wola junggay wana an-babalapa a-ni an-nelangga Abáyata (Abiathar), nipa Daybit rrapa aburr-yigipa jawina aburr-werrmiyana aburr-ni balaja rrapa gala mun-nga mu-yurrarna burrwa rraka mbi-bangarna. Lika a-bona, gu-bala a-barrngumurra Wangarr gun-nika gu-japurra, lika rakaraka mun-gata mun-jimurdayan mu-menga, m-barra, rrapa burr-wuna, birripa aburr-gata aburr-yigipa jawina mbi-barra; wurra jarra junggay yerrcha wupa mbi-banga aburr-workiya mun-narda.” A-yinagata Jesus gu-ngurrjinga burrwa, ");
INSERT INTO bvr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","lika gu-mungbuna minypa nipa a-yinagata burrwa, “Gun-guwarr nipa Wangarr a-wena gun-narda Jarradi nguburr-ngeknga nguburr-workiya. Wurra gurda ngika Jarradi wana gun-bapala; wurra jarra Wangarr arr-borrwurra ngarripa arr-gugaliya. ");
INSERT INTO bvr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Wurra an-guna An-walkurpa An-gugaliya nipa wana an-bapala gurda nula rrawa rrapa Jarradi nula burr-guta.” ");
INSERT INTO bvr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Gun-nerranga gun-ni, Jesus a-bona, a-barrngumurra gun-gata gu-bala Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya. Rrapa an-ngardapa an-gugaliya gata wupa a-ni, nipa murna a-jirra an-nerra. ");
INSERT INTO bvr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wurra aburr-werranga gu-galiya yerrcha aburr-gata jal aburr-ni mari gubu-garra barra nula Jesus. Lika birripa abi-nana aburr-ni minypa gun-gata Jarradi (Saturday) gu-ni nipa minyja a-jarlapa an-gata murna an-nerra. Ngardawa gun-birripa joborr: Jarradi gu-ni gu-workiyana, gala jama aburr-jirrarna aburr-workiyarna. ");
INSERT INTO bvr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Wurra Jesus a-wena nula an-gata murna an-nerra, “A-lay, nyina-garlma.” ");
INSERT INTO bvr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Lika a-wena burrwa aburr-gata, “Ya? Jarradi nula gun-ngayburrpa joborr gu-yinmiya gu-yurra? Gun-molamola jama nguburr-ji barra, waygaji gun-nerra barra jama nguburr-ji; wanngu ngubi-nega barra, wurra waygaji ngubu-bu barra, ya?” Gurda a-wena burrwa, wurra birripa gala aburr-weyarna. ");
INSERT INTO bvr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Lika Jesus burr-nana a-gomarriyana a-yu, lika a-bachirramiyana burrwa, rrapa lika wargugu a-ni burrwa ngardawa mun-molma mun-derta burrwa. Lika a-wena nula an-gata an-gugaliya, “Jerrjangardawiya murna ny-jirra.” Lika nipa a-jerrjangardawiyana, lika a-molamiyana gugu murna a-jirra. ");
INSERT INTO bvr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Lika gu-gata wenga Berachi (Pharisee) yerrcha aburr-garlmuna, rrawa gubu-bawuna, aburr-garlmunapa jechinuwa aburr-bona, aburr-malchinga burrwa Ayrat (Herod) burr-yika jawina. Lika gu-ngardapa aburr-negiyana, wengga gubu-buna aburr-ni minypa birripa abu-bu barra Jesus. ");
INSERT INTO bvr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Gu-gata wenga Jesus rrapa aburr-yigipa jawina rrawa gubu-bawuna aburr-bona, lika yi-gata aburr-bona gu-rrarnba gun-gata Galali (Galilee), rrapa wurra gama gorlk aburr-jaranga aburr-gata Galali aburr-guyinda Jesus abu-jurrjurrmurra aburr-bamuna. Lika gu-gata wenga janguny gu-barrjekarra nula, aburr-bulapalawa aburr-galiyana nipa a-yinmiyana jama a-ji, lika gu-gata gu-rrawa wenga aburr-bona gurda: Judíya (Judea) wenga, Jirúchalam (Jerusalem) wenga, Yidumíya (Idumea) wenga, Jordan wenga rrawa gu-jirra gu-boya gu-gapa gu-rrarnba, rrapa gun-guna Daya (Tyre) rrapa Jaydan (Sidon) wenga aburr-bona gurda aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Lika Jesus a-wena burrwa aburr-yigipa jawina michiyang barra nawanawa mbi-nega nula, ngardawa aburr-bulapalawa wurra gama gorlk aburr-gatiya gala yapa burr-guya abu-marnja. ");
INSERT INTO bvr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ngardawa gipa mu-ngoyurra aburr-gurderda burr-jarlapuna aburr-jaranga, wurra mola gu-derdakurderda yerrcha burrbu-ngorrkorndanga, burrbu-borlayerrnyjinga minypa barra aburr-bamba, aburr-bengga nula barra birripa abi-rrima lika gu-derda gu-boy burrwa. ");
INSERT INTO bvr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Wurra aburr-werranga walkwalk abi-rrimarra rrapa abi-nana Jesus, lika aburr-menama gubi-rrana nula, lika aburr-gonyjinga, “Ny-jurda nginyipa Wangarr biy-yika Walkur.” ");
INSERT INTO bvr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Wurra Jesus burr-guya a-wena burrwa walkwalk yerrcha gala barra abu-ngurrja aburr-boy nipa ana-nga. ");
INSERT INTO bvr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Gu-gata wenga Jesus a-garlmuna, a-warrchinga a-jarl mu-mirk, rrapa aburr-gata jal a-ni burrwa a-gonyjinga burrwa, lika aburr-bona gurda nula. ");
INSERT INTO bvr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Lika Jesus a-jerrjerrjiyana burrwa 12 gu-galiya yerrcha barra burr-gurrma aburr-yigipa aburr-mujama, barra nipa wugupa aburr-rrigirrga aburr-workiya rrapa minypa burr-jerrma barra janguny gubu-ngurrja, ");
INSERT INTO bvr_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","rrapa minypa ganyjarr burr-wu, walkwalk abi-yerrnyja barra. ");
INSERT INTO bvr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Lika aburr-gata 12 gu-galiya yerrcha burr-menga aburr-guna aburr-welangga: An-gata Jayman (Simon) wurra nipa Jesus an-geka an-nelangga a-garrana Birta (Peter); ");
INSERT INTO bvr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","rrapa abirri-gata Jeymch (James) rrapa an-nigipa worlapa niya Jon (John) nipa an-gata Jebadi (Zebedee) bijirri-bokamurra, bitipa Jesus abirri-geka abirri-welangga bijirri-garrana Buwénajich (Boanerges), minypa ngayburrpa ngubu-ngurrjinga gu-jingarliya An-darrbaykarda; ");
INSERT INTO bvr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","rrapa mola aburr-gata Andru (Andrew), Bilip (Philip), Bartólamiyu (Bartholomew), Metiyu (Matthew), Domach (Thomas), rrapa Jeymch an-gata Alpiyach (Alphaeus) an-nika an-walkurpa, rrapa Jerriyich (Thaddaeus), rrapa Jayman an-gata Geynan (Canaan) an-guyinda, ");
INSERT INTO bvr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","rrapa Jurrach Yichkériyat (Judas Iscariot) an-gata jurdach aburr-bachirra murna burr-wuna Jesus. ");
INSERT INTO bvr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Lika Jesus rrapa aburr-yigipa jawina aburr-jekarra rrawa. Barrwa rrapa aburr-jaranga wurra gama gorlk aburr-bona gurda nula rraka nipa rrapa aburr-yigipa jawina gala aburr-yinmiyarna aburr-ngekngarna rrapa balaja mbi-bangarna, wurra gun-nyagara. ");
INSERT INTO bvr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Wurra Jesus mampa niya rrapa worlapa niya yerrcha gun-narda aburr-galiyana nula, lika aburr-bona gurda barra abu-ma. Aburr-yinanga, “Bamapama a-nirra.” ");
INSERT INTO bvr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Rrapa aburr-gata joborr marn․gi aburr-gunega Jirúchalam wenga aburr-bona gurda, birripa aburr-yinanga, “An-guna nipa walkwalk a-rrimanga wana an-babalapa an-gata an-nelangga Biyíljabap (Beelzebub). Minyjiya. Nipiya an-gatiya a-wuna ganyjarr, an-guna a-yerrnyjinga a-workiya walkwalk an-guyinda,” aburr-yinagata aburr-wena. ");
INSERT INTO bvr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Lika Jesus a-gonyjinga burrwa, aburr-bona gurda nula, lika meyali gu-murna a-wena burrwa a-ni. A-yinanga burrwa, “A-lay, walkwalk an-gata Jeytan (Satan) an-nelangga gala a-yinmiya nipa wupa ngardapa a-yerrnyjiya. Ngika. ");
INSERT INTO bvr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Minypa gun-gata gun-nga rrawa minyja aburr-ngorrkorndiya rrapa aburr-bacha gu-gapa gu-guta, gun-narda minypa gun-gata rrawa gu-rrumiya barra gugu, gu-werrapa gu-ji barra. ");
INSERT INTO bvr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Rrapa aburr-nga aburr-gata aburr-yawyawga aburr-marmanyja aburr-barra, minyja birripa aburr-ngorrkorndiya, gun-narda minypa aburr-gata aburr-bapurr aburr-wulebiya barra. ");
INSERT INTO bvr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Rrapa an-gata walkwalk Jeytan nipa a-yinagatiya. Minypa aburr-yigipa nipa burr-ganyja a-workiya, minyja birripa aburr-ngorrkorndiyana rrapa aburr-bacha gu-gapa gu-guta, gun-narda minypa nipa gala a-yinmiya mu-nguy a-ji; wurra gun-nyagara gu-ni barra. ");
INSERT INTO bvr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Wurra jarra minypa gun-maywapa ranginy wana an-babalapa an-guyinda an-gugaliya gala ana-nga a-yinmiya gu-rruma gun-nigipa rrawa rrapa mun-ngumurda mu-ma nula, wurra minyja mu-ngoyurra a-bicha an-gata wana an-babalapa, gu-gatiya wenga lika mun-ngumurda mu-ma nula. ");
INSERT INTO bvr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Buburr-galiya apula; gun-guna gun-burral. Minyja an-gugaliya gun-nga gun-nerra gu-rrimanga rrapa gun-nga gun-jaranga gun-nerra a-weya rrapa an-nerra a-nenga Wangarr, gun-narda nipa Wangarr baywarra gu-nega barra nula. ");
INSERT INTO bvr_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Wurra an-gata ana-nga a-wengga rrapa an-nerra a-nega Mern An-mawunga, an-gata an-gugaliya werra a-negiyanapa, ganapiya; Wangarr gala a-yinmiya a-gunggaja nula. Ngika. Wurra gu-jipa barra gu-workiya.” ");
INSERT INTO bvr_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesus a-yinagata a-wena, ngardawa aburr-gata abu-yopuna aburr-ni, aburr-yinagata, “An-guna walkwalk a-rrimanga.” ");
INSERT INTO bvr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Lika Jesus mampa niya rrapa worlapa niya yerrcha aburr-bona gurda, gata aburr-jinyja yarlanga gu-bala. Lika wengga gubi-jerrmarra nula barra ana-bengga burrwa yarlanga. ");
INSERT INTO bvr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lika wurra gama gorlk gatiya aburr-ni aburr-gomarriyana nula Jesus, birripa aburr-yinanga nula, “A-lay, jin-nginyipa mampa nggu rrapa aburr-nginyipa worlapa nggu yerrcha, birripa aburr-gata yarlanga aburr-jirra; jal aburr-nirra aburr-wengga barra nggula.” ");
INSERT INTO bvr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Wurra Jesus a-wena burrwa, “Jin-ngay, aburr-ngay aburr-ngaypa worlapa apa yerrcha rrapa jin-ngaypa mampa apa?” ");
INSERT INTO bvr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Lika burr-nana wurra gama gorlk aburr-ni aburr-gomarriyana nula, lika a-wena, “Jarra aburr-gunaga aburr-ngaypa mampa apa yerrcha rrapa aburr-ngaypa worlapa apa yerrcha! ");
INSERT INTO bvr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Minyja bubu-borrwa: Aburr-nga aburr-gata jama aburr-jirra minypa Wangarr jal a-nirra, aburr-gurda wupa minypa aburr-ngaypa worlapa apa yerrcha rrapa lamurrpa apa yerrcha rrapa jin-ngaypa mampa apa.” ");
INSERT INTO bvr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Gun-nerranga gu-ni, lika Jesus a-wena burrwa a-ni gata gu-rrarnba, rrapa wurra gama gorlk aburr-bona gurda nula aburr-ni gala aburr-ngardapa. Lika Jesus a-gortkurrchinga mu-michiyang, lika a-rakaja mu-gochila, rrapa aburr-gata wurra gama gorlk aburr-ji aburr-ni gu-rrarnba. ");
INSERT INTO bvr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Lika nipa meyali gu-murna a-wena burrwa a-ni, janguny gun-jaranga marn․gi burr-negarra a-ni. Minypa gun-ngardapa gun-gata a-yinanga burrwa, ");
INSERT INTO bvr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Buburr-galiya apula. An-ngardapa an-gugaliya a-lamajinga a-bona balaja nula burraya mbi-ma. ");
INSERT INTO bvr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Minypa nipa mu-mulpuna, lika mipila mu-jirra mu-yerrnyjinga a-bona. Wurra mun-nerranga mun-gata m-bungguna gu-jarlakarr, lika burdacha jin-guyinda jina-bona, m-barra jinyu-ni, mu-wulebana. ");
INSERT INTO bvr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Rrapa mun-nerranga mun-gata mipila mu-jirra m-bungguna gu-mernarra gu-guyinda gatiya gun-delipa jel gu-yurra, lika gu-gata wenga gugu mun-jarlala m-bena, ngardawa gala jel wana gu-jirrarna. ");
INSERT INTO bvr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Wurra nuwurra waypa marnnga jina-bena, lika gugu mu-gorlapuna mun-gata mun-jarlala, ngardawa rrepara mu-jirra gala burr-guya wuparnana mu-ninya. ");
INSERT INTO bvr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Rrapa mun-nerranga mun-gata mipila mu-jirra m-bungguna ji-bornangguna ji-guyinda. Lika mun-jarlala m-bena, wurra jin-gata bornangguna wana jinyu-ni jiny-bamuna, jiny-jorlkakaja nula, rraka mun-gata nipa an-gugaliya a-lamajinga gala mu-yinmiyarna balaja mu-rrimangarna. ");
INSERT INTO bvr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Rrapa mun-nerranga mun-gata mipila mu-jirra m-bungguna mu-ji gu-molamola jel gu-guyinda. Lika gu-gata wenga mun-jarlala m-bena, lika wana mu-ni m-bamuna, balaja mu-rrimarra. Minypa mun-nerranga marr mun-delipa mu-rrimarra, mun-nerranga marr mun-jaranga, mun-nerranga mun-bulapalawa. ");
INSERT INTO bvr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","“Gun-narda janguny, wurra ny-yinga ny-jata minyja gelama ny-jirra ny-jaliyana, borrwa ngaypa ngu-wena.” ");
INSERT INTO bvr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Lika nuwurra waypa nipa Jesus ngardapa a-ni, rrapa aburr-yigipa 12 gu-galiya yerrcha rrapa aburr-werranga burr-guta aburr-yigipa jawina aburr-bona gurda nula, lika birripa abu-wengganana gun-gata meyali gun-guyinda an-nga nula. ");
INSERT INTO bvr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Lika nipa a-yinagata burrwa, “Ana-goyburrpa, nipa Wangarr nyirr-menga barra meyali nyibi-na gun-japurra gun-gata gun-nigipa rum; wurra aburr-gata aburr-werranga, birripa aburr-galiyarra aburr-workiya gun-maywapa ranginy wupa. ");
INSERT INTO bvr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Wurra gubi-nacha aburr-workiya, wurra gala aburr-yinmiya gubu-malawa, rrapa aburr-galiyarra aburr-workiya, wurra gala aburr-yinmiya marn․gi aburr-ni rraka aburr-garlma, aburr-ngukurdanyjiya, rrapa minypa ngaypa baywarra ngu-nega burrwa gun-nerra gubi-rrimarra.’” ");
INSERT INTO bvr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Lika Jesus a-yinagata burrwa, “Wurra gun-gata gun-maywapa ranginy geka ngu-wena ana-gorrburrwa, gala nyibu-borrwa meyali, ya? Wurra lika meyali gun-nerranga ana-goyburrpa nyiburr-yinmiya barra marn․gi nyiburr-ni? ");
INSERT INTO bvr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Gun-gata ngaypa ngu-wena ana-gorrburrwa, gun-narda ngika mipila mu-jirra rrapa gatni (garden). Wurra aburr-gata ngaypa nguburr-ngurrjinga gu-galiya yerrcha minypa aburr-yinmiya aburr-workiya aburr-galiyarra Wangarr gun-nika janguny. ");
INSERT INTO bvr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Minypa aburr-gata aburr-werranga gu-galiya yerrcha, birripa minypa gun-gata ngu-wena mipila mu-jirra m-bungguna gu-jarlakarr, jel gun-gata gun-derta gun-gorla. Minypa gun-nga aburr-galiyarra aburr-workiya Wangarr gun-nika janguny, warrika walkwalk an-gata Jeytan (Satan) an-nelangga ana-yurtchingapa burr-gaypurda janguny gun-gata Wangarr burr-wuna. ");
INSERT INTO bvr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Rrapa aburr-werranga gu-galiya yerrcha birripa minypa gun-gata ngu-wena mipila mu-jirra m-bungguna gu-mernarra gu-guyinda. Minypa gun-nga aburr-galiyarra Wangarr gun-nika janguny, birripa marr aburr-balcharra rrapa aburr-worlworlcharra, ");
INSERT INTO bvr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","wurra gala burr-guya gubu-borrwa rraka aburr-jinyja. Wurra aburr-bamburda gun-baykarda ngika, lika gun-derta gubu-barripurda, minypa aburr-werranga aburr-nyala mari gubu-garraja burrwa ngardawa gun-gata janguny aburr-guna marr aburr-balcharra. Lika gu-gata wenga birripa aburr-guna aburr-jeknga aburr-bamburda, ngardawa gala burr-guya gubu-borrwa Wangarr gun-nika janguny. ");
INSERT INTO bvr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Rrapa aburr-werranga gu-galiya yerrcha birripa minypa gun-gata ngu-wena mipila mu-jirra m-bungguna ji-bornangguna ji-guyinda. Minypa aburr-galiyarra Wangarr gun-nika janguny, ");
INSERT INTO bvr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","wurra aburr-bamburda, gun-jaranga gubu-borrwuja aburr-workiya gu-gurdiya gu-yika gu-rrawa. Jal aburr-nirra rrupiya rrapa gerra rrapa gun-nerranga gun-nga burr-guya jal aburr-nirra, lika gu-gata wenga janguny gun-nyagara gugu gu-nirra burrwa aburr-gata gu-galiya yerrcha; jimarn jarra birripa jama aburr-jirrarna nula Wangarr, wurra gun-nyagara. ");
INSERT INTO bvr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wurra aburr-werranga gu-galiya yerrcha birripa minypa gun-gata ngu-wena mipila mu-jirra m-bungguna gu-molamola gu-jel. Minypa aburr-galiyarra Wangarr gun-nika janguny, lika burr-guya gubu-borrwuja nula, lika jama aburr-jirra nipa nyanma — an-nerranga minypa gun-delipa, rrapa an-nerranga minypa marr wana, rrapa an-nerranga minypa wana gun-bapala.” ");
INSERT INTO bvr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesus a-yinagata burrwa, “Minypa ngarripa arr-birtarrmiya arr-workiya minypa lam (lamp), wurra gala arr-yinmiya ay-yilkaka wupa ana-duram ana-guyinda o wupa mu-garrung. Ngika. Wurra ay-wenyanga arr-workiya barra arr-naya arr-ni. ");
INSERT INTO bvr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Minyja gun-nga gun-gata gu-yilkakiya gu-yurra, nipa barra nuwurra yarlanga gu-yu. Rrapa gun-nga gun-jaranga yongun gu-yurra, birripa aburr-jaranga barra marn․gi aburr-ni gun-gata. ");
INSERT INTO bvr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ny-yinga ny-jata minyja gelama ny-jirra ny-jaliyana, borrwa ngaypa ngu-wena.” ");
INSERT INTO bvr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Lika a-yinagata burrwa, “Minyja gun-gata nyiburr-galiyana apula barra burr-guya nyibu-borrwa. Minypa nginyipa ny-yinmiya ny-borrwa ny-yorkiya, gu-gata ngacha minypa guna-jeka barra nggula, wurpa lika wana gun-bapala. ");
INSERT INTO bvr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Minyja ana-nga an-gata gu-rrimanga nula janguny, burraya Wangarr wana gun-bapala a-wu barra. Wurra an-gata gala janguny gu-rrima nula, burraya Wangarr ana-garlmapa barra a-gaypa barra an-gata an-gugaliya gun-delipa gun-gata jimarn jarra nipa gu-rrimangarna a-nirrarna.” ");
INSERT INTO bvr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesus a-yinagata, “Wangarr gun-nika rum, gun-narda minypa gun-maywapa mipila mu-jirra an-gugaliya mu-mulpurda, a-lamajinga a-workiya balaja nula. Minypa mu-yerrnyjinga a-boya, ");
INSERT INTO bvr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","rrapa nuwurra waypa gu-yinmiyapa ngorrngurra, lika mun-jarlala m-beya mu-workiya, lika wana mu-nirra rrapa nipa an-gata an-gugaliya gala marn․gi mu-yinmiya m-bamburda. ");
INSERT INTO bvr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Wurra minypa nipa wupa m-beya mu-workiya gu-jel wenga, mu-ngoyurra mun-jarlala rrapa jurdach lika mun-burrolga mu-rrimanga. ");
INSERT INTO bvr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Lika mun-burral wana mu-nirra, lika mu-molamiya, warrika gugu an-gugaliya mu-mangga a-workiya ngardawa gipa mu-molamiyana.” ");
INSERT INTO bvr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesus a-yinagata, “Gun-gata Wangarr gun-nika rum, gun-narda minypa nguburr-yinmiya barra ngubu-ngurrja gun-maywapa ranginy? Wurra minypa gun-guna: ");
INSERT INTO bvr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Minypa mun-gata mipila mu-jirra gun-jong machart (mustard) mun-delipa gurdiya rrawa; mun-nerranga marr mu-yinaga mun-delipa. ");
INSERT INTO bvr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Wurra minypa an-gugaliya mu-mangga a-workiya rrapa a-lamajinga mun-gata mipila mu-jirra machart, nuwurra mun-jarlala m-beya m-bamburda, lika wana mu-nirra, lika nipa wana mun-babalapa; mun-nerranga marr mu-yinaga. Wurra minypa nipa gun-jong machart mernda mu-jirra wana mun-bapala, aburr-jaranga burdacha aburr-guyinda aburr-boya gurda aburr-workiya, lika gubu-gapulawuja aburr-workiya ay-gatiya gu-birlapirla gu-guyinda.” ");
INSERT INTO bvr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Rrapa barrwa gun-jaranga gun-maywapa ranginy Jesus a-wena burrwa a-ni gu-yinmiyapa barra aburr-galiya aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wurra gala a-yinmiyarna yarlanga gu-nengarna burrwa a-workiyarna. Ngika. Wurra gun-maywapa ranginy a-wena burrwa a-workiyana. Wurra minypa jurdach nipa rrapa aburr-yigipa jawina ngardapa aburr-ni, lika nipa yarlanga gu-negarra burrwa. ");
INSERT INTO bvr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Gun-gata gun-maywapa ngorrngurra balngga gu-ni, Jesus a-wena burrwa aburr-yigipa jawina, “A-lay, nguburr-boy, nguburr-jurrwa gu-gapa gu-rrarnba.” ");
INSERT INTO bvr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Lika aburr-yigipa jawina burrbu-bawuna wurra gama gorlk gata, lika aburr-warrchinga mu-michiyang wupa mu-ngoyurra Jesus a-warrchinga. Lika abu-ganyja aburr-bona wugupa, rrapa mun-nerranga michiyang gatiya wugupa. ");
INSERT INTO bvr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Gu-gata wenga barlmarrk gu-bena wana, rrapa bartpa gu-garlmunapa gu-barrngumurra wupa mu-michiyang, lika gu-ngana gu-mayana gu-bamuna. ");
INSERT INTO bvr_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Wurra nipa Jesus gapa jurdach ana-yu ana-bona mu-michiyang m-barra, bila (pillow) gu-rrenyjinga a-yu ana-bama. Lika aburr-yigipa jawina abu-jortkarra aburr-ni, aburr-wena nula, “Bunggawa, a-lay, gala ny-jurkuja ngayburrpa nguburr-guyba barra, ya?” ");
INSERT INTO bvr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Lika Jesus a-garlmuna, gu-jobujobuna barlmarrk, rrapa bartpa a-wena nula, “Gurrmiya!” Lika gun-gata gu-ngochingapa warrpam. ");
INSERT INTO bvr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Lika Jesus a-wena burrwa aburr-yigipa jawina, “An-nga nula nyiburr-gurkujarra? Wurra gala burdak marr nyiburr-balcharrarna, ya?” ");
INSERT INTO bvr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wurra birripa burr-guya gochila aburr-barrjinga. Lika aburr-wengganachichiyana aburr-ni, “A-lay, an-guna an-guyinmiya ngacha? Minyja barlmarrk rrapa bartpa gu-jobujoburda a-boya, gu-galiyarra nula, ngarla!” ");
INSERT INTO bvr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Lika Jesus rrapa aburr-yigipa jawina aburr-bena rrawa gu-gapa gu-rrarnba gun-nelangga Geracha (Gerasa). ");
INSERT INTO bvr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Lika gatiya waypa mu-michiyang wenga Jesus a-gortkurrchinga gu-rrarnba, an-ngardapa an-gugaliya a-bena nula, gata wupa wenga ana-bena gu-gurrema gu-ngarnama gatiya abu-gurrmunga aburr-workiya an-gugaliya a-juwiya a-workiya. Nipa an-gata an-gugaliya walkwalk a-rrimarra, ");
INSERT INTO bvr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","lika nipa gata a-ni a-workiyana gu-gurrema gu-ngarnama, rrapa an-gubandawiya jirn (chain) abu-bichingarna, wurra ngika. ");
INSERT INTO bvr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Minyjiya. Gipa mu-ngoyurra wurra jurdach abu-bichinga aburr-workiyana an-gubandawiya jirn, wurra nipa a-rrumurra a-workiyana an-gata an-gubandawiya, rrapa gala ana-nga a-yinmiyarna burda a-nengarna nipa an-gata. Ngika. ");
INSERT INTO bvr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Wurra jarra ana-munya rrapa ji-gurdarrja a-rrigirrgarra a-workiyana gata wuparnana gu-ngarnama gatiya morrpiny yerrcha burrbu-gurrmunga aburr-workiya; rrapa gu-bulgapulga a-rrigirrgarra a-workiyana, a-gonyjinga a-workiyana rrapa a-gorndiyana a-workiyana gu-jandarra. ");
INSERT INTO bvr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Lika nipa gu-gata a-nana Jesus balay wenga, lika ana-yurtchinga ana-ni, lika ana-menama gu-rrana nula Jesus. ");
INSERT INTO bvr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Lika Jesus ana-nyala a-wena nula, “Ny-jurda walkwalk nyina-bengga. Gu-garda wenga bawa an-gata an-gugaliya.” Lika nipa walkwalk a-gonyjinga burr-guya, “Jesus, ny-jurda Ny-yalkurpa nula Wangarr biy-yika an-gata wana an-babalapa, nginyipa an-nga nula nyina-bona apula? Wurra nipa an-gata ngardawa ana-ninyarra, gala barra nguna-bu.” ");
INSERT INTO bvr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Lika Jesus a-wena nula, “Ny-yinga ny-yelangga?” Nipa a-yinagata, “Ngaypa ngu-welangga ngunabu-ngurrjinga aburr-workiya ‘An-murra’, ngardawa ngayburrpa nyiburr-jaranga.” ");
INSERT INTO bvr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Barrwa rrapa walkwalk yerrcha aburr-ngiwija nula Jesus gala barra burr-jerrma gun-birripa rrawa. ");
INSERT INTO bvr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Rrapa bigibigi jin-gata jin-bulapalawa m-banga jiny-boya gun-gata balay ngika gu-bulgapulga. ");
INSERT INTO bvr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Lika aburr-gata walkwalk yerrcha aburr-ngiwija nula Jesus, aburr-yinagata, “A-lay, nyirr-jerrma achila jin-gata jin-murra bigibigi barra yi-gata nyiburr-yurtcha achila.” ");
INSERT INTO bvr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Lika Jesus gu-yagurrmurra burrwa, lika walkwalk yerrcha aburr-bena gurda, abu-bawuna an-gugaliya, lika aburr-bona yi-gata bigibigi jin-bulapalawa jiny-jirra. Lika jin-gata bigibigi 2,000 jin-murra gu-bulgapulga gu-bukula jiny-bupiyana jiny-yurtchinga; jiny-yurtchingapa gu-bugula jiny-juybuna gu-bulgapulga gu-gera. ");
INSERT INTO bvr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Rrapa aburr-gata gu-galiya yerrcha jaga aburr-ganana achila aburr-workiyana jin-gata bigibigi jin-guyinda, birripa aburr-yurtchinga, gun-gata janguny gubu-ngurrjinga burrwa aburr-bona gu-murna rrawa gun-gata rrapa minypa gu-werrapa gu-werrapa gu-jirra gu-boya burr-guta. Lika wurra gama gorlk aburr-garlmuna gurda barra gubi-na an-nga nula. ");
INSERT INTO bvr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Lika aburr-bena nula Jesus, lika abi-nana an-gata an-gugaliya walkwalk an-jaranga a-rrimarra nipa mirikal a-barrngumurra rrapa gatiya a-ni an-mola. Lika birripa aburr-gurkuja. ");
INSERT INTO bvr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Rrapa aburr-werranga gipa mu-ngoyurra gubi-nana, birripa lika gubu-ngurrjinga burrwa aburr-bona an-gata an-gugaliya a-yinmiyana a-molamiyana rrapa jiny-yinmiyana bigibigi jiny-juybuna. ");
INSERT INTO bvr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Lika wurra gama gorlk aburr-garlmuna, aburr-ngiwija nula Jesus gun-birripa rrawa gun-gata wana gun-bapala nipa barra gu-bawa a-boy. ");
INSERT INTO bvr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Lika gu-gata wenga Jesus a-warrchinga mu-michiyang, lika an-gata an-gugaliya walkwalk a-rrimarra nipa a-ngiwija nula Jesus minyja wugupa abirri-boy. ");
INSERT INTO bvr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Wurra Jesus gala gu-yagurrmungarna nula. Wurra a-yinanga nula, “Nginyipa ny-boy barra rrawa, rrapa minypa aburr-nginyipa aburr-borrmunga ny-yengga barra burrwa a-yinmiyana Wangarr jama a-ji nggula minypa nipa a-worijinga nggula.” ");
INSERT INTO bvr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ganapiya. Lika nipa an-gata an-gugaliya a-bona gun-gata rrawa gu-ji gu-bona arr-gulirrwirrka arr-murna, minypa 10, minypa a-wena burrwa a-bona Jesus a-yinmiyana a-gunggajinga nula. Lika gun-nardiya wurra gama gorlk burr-guya gubu-borrwurra aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Lika gatiya waypa Jesus ana-jekarra, a-bena gu-guna gu-rrenyjiya, lika aburr-jaranga wurra gama gorlk aburr-garlmuna gurda, aburr-bena nula gatiya gu-rrarnba. ");
INSERT INTO bvr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Rrapa an-ngardapa an-gugaliya an-gata jaga a-ganana gun-gata bala Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya, nipa ana-bona, nipiya an-nelangga Jayrach (Jairus). Lika gatiya waypa a-nana Jesus, lika a-bungguna nipa ana-rrepara rrapa minypa bukula a-jirra gu-jel a-yunya. ");
INSERT INTO bvr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Lika a-ngiwija nula Jesus, “A-lay, jin-ngaypa delipa gu-derda wana jiny-yorrpurda, yi-gurrepa jiny-juwa barra. Marliya, japurra ngapa ny-jirra. Guwa, arr-boy barra n-dima, barra nipa jiny-molamiya rrapa jin-digirrga.” ");
INSERT INTO bvr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Lika Jesus a-garlmuna nula, rrapa wurra gama gorlk aburr-jaranga gatiya wugupa aburr-bamuna, wurra minypa abu-marnjinga. ");
INSERT INTO bvr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Rrapa jin-ngardapa gama jin-gata jiny-jortchinga jiny-yorkiyana gun-gatiya nipa jiny-yorrpuna jiny-yu gun-bulawa jemberr minypa 12. ");
INSERT INTO bvr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Minypa jiny-bona, an-buburda jin-dimarra an-jaranga rrapa rrupiya mu-wulebana achila. Wurra jimarna jiny-molamiyarna, wurra jarra burr-guya jiny-yorrpuna jiny-yorkiyana. ");
INSERT INTO bvr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Lika jiny-jaliyana nula Jesus, lika jina-bona, wurra gama gorlk burr-ngorrkorndanga jina-bamuna, nipa ana-jonama jiny-bena, lika mirikal mu-rrimarra nula. ");
INSERT INTO bvr_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ngardawa nipa jin-ngurrnga jiny-yena, “Minyja ngaypa ngu-rrima nula mirikal barra ngaypa ng-gaypa barlmarrk, lika ngu-molamiya.” ");
INSERT INTO bvr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ganapiya, lika gun-gatiya nipa mu-rrimarrapa, warrika jinyu-derichinga mu-ngoyurra jiny-jortchinga jiny-ji jiny-yorkiyana. Lika wuparnana jiny-jaliyana jiny-molamiyana. ");
INSERT INTO bvr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Lika Jesus a-galiyana barlmarrk gu-bona nula, lika a-ngukurdanyjiyana gata gojilapa wurra gama gorlk aburr-jinyja. Lika a-yinanga burrwa, “Ana-nga mun-ngaypa mirikal mu-rrimarra?” ");
INSERT INTO bvr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wurra aburr-yigipa jawina aburr-yinanga, “Wurra gala burr-na wurra gama gorlk bubu-marnjinga, ya? Wurra an-nga nula ny-yena ana-nga mu-rrimarra nggula?” ");
INSERT INTO bvr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Wurra burdak lika burr-nana a-gomarriyana a-yu ngardawa ana-nga an-gata mu-rrimarra nula. ");
INSERT INTO bvr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wurra jin-gata gama ngardawa nipa marn․gi mu-rrimarra nula mun-gata mirikal rrapa minypa jiny-molamiyana, lika jina-bona nula Jesus, wurpa lika jiny-jurkuja jinyu-ni rrapa jiny-yurrwurrjinga. Lika ji-menama gu-rrana nula rrapa jiny-nyurrjiyana nula nipa jiny-yinmiyana. ");
INSERT INTO bvr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Lika nipa Jesus a-wena achila, “A-jay, walkur, ngardawa nginyipa marr ny-balcha apula lika nginyipa ny-molamiyana. Wurra gala barra ny-jurkuja. Wurra nginyipa ny-molamola gugu boy. Gun-narda gala ny-yinmiya barrwa ny-yorrpa.” ");
INSERT INTO bvr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Wurra gun-gatiya waypa Jesus a-wena achila a-ni, aburr-werranga aburr-bona gurda gu-gata wenga Jayrach gun-nika rrawa, an-gata jaga a-ganana a-workiyana bala gun-gata Ju yerrcha gun-burriya. Lika aburr-yinanga nula Jayrach, “Jin-nginyipa delipa gipa gugu jiny-juwuna; gala ny-yinmiya barrwa ny-yenggana an-guna bunggawa.” ");
INSERT INTO bvr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesus a-galiyana birripa aburr-wena nula Jayrach, wurra gala marr a-balcharna burrwa. Wurra a-wena nula Jayrach, “Gala barra ny-jurkuja. Wurra marr ny-balcha barra apula.” ");
INSERT INTO bvr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Lika burr-jerrmarra wurra gama gorlk aburr-bona rrawa. Wurra nipa burr-ganyja Birta (Peter) rrapa Jeymch (James) rrapa Jon an-gata Jeymch an-nika worlapa niya, aburr-gurdiya wupa; ");
INSERT INTO bvr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","lika Jayrach wugupa aburr-bona gun-gata gun-nigipa rrawa. Gata waypa aburr-bena, Jesus burr-nana gu-ngardapa aburr-negiyana aburr-bamuna rrapa burr-guya aburr-rruwujana aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Lika nipa a-barrngumurra wupa gu-bala. Lika a-yinanga burrwa, “An-nga nula gu-ngardapa nyiburr-negiyana nyiburr-bamuna rrapa nyiburr-rruwuja? Jin-guna delipa gala jiny-juwiyarna, wurra nipa jarra jiny-yurra.” ");
INSERT INTO bvr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wurra birripa aburr-garlmunapa aburr-gurdachinga nula, rrapa nipa burr-jerrmarra yarlanga. Wurra nipa burr-menga mampa acha rrapa nyanyapa acha rrapa aburr-yigipa Jesus burr-yika jawina abirri-jirrapa an-ngardapa, lika aburr-barrngumurra wupa gu-ngarnama nipa delipa jiny-juwuna, jiny-yunya gatiya. ");
INSERT INTO bvr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Lika nipa jin-dimarra mernda jiny-jirra, lika a-wena achila, minypa gun-birripa wengga a-yinanga, “Dalita gumay,” minypa ngayburrpa gu-jingarliya nguburr-weya, “A-jay, delipa, ngaypa ngu-weya nggula garlma!” ");
INSERT INTO bvr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Warrika jin-gata delipa jiny-jarlmuna, lika jin-digirrgarra, ngardawa gipa mu-ngoyurra wana jinyu-ni minypa jemberr 12 achila. Lika aburr-gata gochila aburr-barrjinga. ");
INSERT INTO bvr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Lika Jesus burr-guya a-wena burrwa gun-gata nipa jin-dimarra birripa barra yongun gubi-nega barra. Lika a-wena burrwa barra balaja jibu-wu. ");
INSERT INTO bvr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus gu-bawuna gun-gata rrawa, lika a-jekarra a-bona gu-yigipa gu-rrawa, rrapa aburr-yigipa jawina wugupa. ");
INSERT INTO bvr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Lika gun-gatiya Jarradi (Saturday) gu-ni, a-bona, a-barrngumurra gun-gata bala Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya. Lika gatiya marn․gi burr-negarra a-ni janguny wurra gama gorlk, minypa aburr-gata aburr-galiyana nula birripa gochila aburr-barrjinga. Lika aburr-wengganachichiyana aburr-bona, “An-guna yina gaya wenga gu-menga janguny?” birripa aburr-yinagata, “Gun-guna gun-nga janguny? Nipa burr-barlmarrk jama a-jirra a-workiya gun-nga gun-gata ganyjarr? ");
INSERT INTO bvr_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Wurra jarra ngayburrpa marn․gi nula nipa gapunda (carpenter). Minyja nipa mampa niya Meri (Mary), rrapa aburr-yigipa worlapa niya yerrcha aburr-gata Jeymch (James) rrapa Jochap (Joseph) rrapa Jurrach (Judas) rrapa Jayman (Simon), ya? Minyjiya, ngarla! Rrapa aburr-yigipa jelapa niya yerrcha aburr-guniya.” Birripa wurra gama gorlk aburr-yinagata aburr-wena rrapa gala marr aburr-balcharrarna nula Jesus gun-gata janguny nipa gu-rrimarra Wangarr gun-nika. ");
INSERT INTO bvr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Lika Jesus a-yinagata burrwa, “Ana-nga an-gugaliya an-gata Wangarr an-nika an-mujaruk, nipa wurra gama gorlk marr abirriny-balcharra nula abirriny-yorkiya, wurra aburr-yigipa aburr-borrmunga gata gu-yigipa gu-rrawa ngika.” ");
INSERT INTO bvr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ganapiya, wurra Jesus gala a-yinmiyarna burr-barlmarrk jama a-jirrarna gun-gata, wurra jarra aburr-gurderda bin-dimarra rrapa wanngu burr-negarra aburr-jaranga ngika. ");
INSERT INTO bvr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Wurra nipa gochila a-barrjinga burrwa aburr-gata ngardawa gala marr aburr-balcharrarna nula. Lika Jesus a-bona, rrawa gu-ji gu-bona janguny marn․gi burr-negarra a-bona wurra gama gorlk. ");
INSERT INTO bvr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Lika a-gonyjinga burrwa aburr-yigipa 12 gu-galiya yerrcha, lika aburr-mulpiyana nula aburr-bamuna. Lika a-wena burrwa barra burr-jerrma aburr-bulawa, minypa abirri-jirrapa aburr-maya barra wugupa abirri-boy abirri-ji. Rrapa nipa burr-wuna ganyjarr barra walkwalk abi-yerrnyja burrwa aburr-boy. ");
INSERT INTO bvr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Lika gu-jarlapuna a-wena burrwa gala barra gubu-ga gorlk, rrapa gala barra burlupurr aburr-birringgiya, rrapa gala barra mbi-ga balaja rrapa rrupiya. ");
INSERT INTO bvr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Wurra jarra aburr-barrnguma barra rrepara aburr-jirra, rrapa mun-nga mirikal mun-ngardapa wupa aburr-barrnguma barra. ");
INSERT INTO bvr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","A-yinagata a-wena burrwa, “Minyja nyiburr-yinmiya nyiburr-bengga burrwa gu-gata gu-rrawa, minyja ana-nga a-gonyja ana-gorrburrwa, lika gu-yigipa gu-rrawa barra nyiburr-ni, nuwurra nyibu-bawa gun-gata gu-murna rrawa. ");
INSERT INTO bvr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Wurra minyja yina gun-gaya rrawa gala aburr-gonyja ana-gorrburrwa rrapa gala aburr-galiya ana-gorrburrwa janguny, lika bubu-bawa gun-gata rrawa, rrapa gatiya rrawa gu-gera buburr-wepiya rrepara nyiburr-jirra baluk gu-gata gu-yika gu-rrawa. Barra gu-galiya yerrcha aburr-gata nyirrbi-na rrapa aburr-borrwiya minypa birripa aburr-yinmiyana werra aburr-negiyana gun-gata birripa gala aburr-galiyarna ana-gorrburrwa.” ");
INSERT INTO bvr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ganapiya, lika Jesus burr-yika jawina aburr-bona, wurra gama gorlk aburr-wena burrwa gun-nerra barra gubu-bawa rrapa aburr-ngurkurdanyjiya nula Wangarr. ");
INSERT INTO bvr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Rrapa Jesus burr-yika abi-yerrnyjinga burrwa an-jaranga walkwalk, rrapa aburr-gurderda burrbu-ngimarra mun-girra alip (olive) mu-guyinda rrapa minypa wanngu burrbi-negarra. ");
INSERT INTO bvr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Lika gun-gatiya rrawa Galali (Galilee) nipa an-gata bunggawa an-nelangga Ayrat (Herod), nipa a-galiyana nula a-workiyana Jesus, minypa janguny gu-barrjekarra nula. Minypa aburr-werranga gu-galiya yerrcha abu-ngurrjinga Jesus, aburr-yinanga, “An-guna an-gugaliya nipiya an-gata Jon bama burr-gurragaja a-workiyana, a-juwuna, wurra minypa gun-gujuwa gu-beybana, ana-jekarra gugu. Gu-gurdiya ngacha minypa nipa an-guna burr-barlmarrk jama a-jirra a-workiya.” ");
INSERT INTO bvr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Wurra aburr-werranga aburr-yinanga, “An-guna waygaji Yiláyja (Elijah).” Rrapa aburr-werranga aburr-yinanga, “An-guna Wangarr an-nika an-mujaruk minypa aburr-werranga aburr-gata wola gun-guwarr gubu-ngurrjinga aburr-workiyana Wangarr gun-nika.” ");
INSERT INTO bvr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Wurra Ayrat a-galiyana janguny gu-barrjekarra nula Jesus, nipa a-yinanga, “An-narda Jon ngaypa ngu-jaygorndanga, barrwa rrapa a-molamiyana, ngarla!” ");
INSERT INTO bvr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","A-yinagata nipa Ayrat a-wena, ngardawa gipa mu-ngoyurra nipa a-wena burrwa aburr-yigipa aburr-mujama, Jon abi-rrimarra, abu-bichinga, abu-jolartchinga wupa, ngardawa jin-gata nyanma Yirórriyach (Herodias), Bilip jin-nika jin-gumarrbipa niya nipa Ayrat jiny-menga, worlapa niya a-gaypuna. ");
INSERT INTO bvr_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ngardawa minypa Jon a-yinanga a-wena nula a-workiyana Ayrat, “Gun-narda gala gun-mola nginyipa n-dimanga jin-guna worlapa nggu jin-nika jin-gumarrbipa niya,” ");
INSERT INTO bvr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","gu-gurdiya nula nipa jin-gata Yirórriyach jiny-jarlmuna, jiny-bachirramiyana nula Jon, jimarna a-burndarna. ");
INSERT INTO bvr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Wurra Ayrat nipa jarra jaga a-ganana nula Jon ngardawa a-gurkuja nula, minypa gu-borrwurra nula nipa jechinuwa a-ni a-workiyana Wangarr an-nika jawina. Ngardawa wolawola Ayrat jal a-ni a-galiyana nula a-workiyana Jon, wuriya gu-gata wenga jurdach a-limurrmorriyana a-ni a-workiyana. ");
INSERT INTO bvr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Aburr-bamuna, lika gu-gata wenga Ayrat a-buna Jon minypa gu-guna ngacha: Minypa Ayrat gatiya janara gu-ji nula, minypa nipa gu-borrwurra gu-yinmiyapa jemberr gu-ni nula, lika a-gonyjinga burrwa aburr-yigipa jawina gata gu-yigipa gu-rrawa rrapa aburr-yigipa aburr-gata minypa an-dakal abu-ganyja aburr-workiyana, rrapa aburr-werranga burr-guta aburr-welangga wana gun-gata Galali aburr-guyinda. Lika birripa gu-ngardapa aburr-negiyana rrapa minypa balaja mbi-barra aburr-ni rrapa aburr-worlworlcha aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Rrapa gun-gatiya waypa Yirórriyach jin-nika jin-jawapa jina-bona, jiny-yalagiyana burrwa, nipa Ayrat rrapa aburr-gata wugupa nula birripa aburr-marrkapchinga achila. Lika Ayrat a-yinanga achila, “A-jay, wengga apula nginyipa gun-nga jal nyi-nirra barra ngaypa ngiy-wu.” ");
INSERT INTO bvr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","A-yinagata a-wena achila burr-guya, “Minyja ngaypa gochila ngiy-rrana gun-nga nginyipa ny-yengga apula barra ngaypa ngiy-wu. Minyja gun-guna rrawa ngaypa bunggawa ngu-nirra ngaypa ngu-ngorrkornda, ngiy-wu, minyja gun-nga ngaypa ngiy-wu.” ");
INSERT INTO bvr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Lika jin-gata gama jiny-bona, lika jiny-yena achila mampa acha. “Ngaypa an-nga nula ngu-wengga barra?” Wurra mampa acha jiny-yinanga, “Minyja bama a-jirra Jon an-gata bama burr-gurragaja a-workiyana.” ");
INSERT INTO bvr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Lika jechinuwa jiny-yurtchinga jin-gata jin-ngamangama, lika jiny-yena nula bunggawa, jiny-yinanga, “Ngaypa jal ngu-nirra nggula gun-narda geka barra bama a-jirra nguna-wu an-ngartpelambila japalana ana-guyinda nipa Jon an-gata wolawola bama burr-gurragaja a-workiyana.” ");
INSERT INTO bvr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Lika an-gata bunggawa burr-guya wargugu a-ni, ngardawa aburr-gata aburr-jaranga gu-galiya yerrcha aburr-galiyana nula nipa burr-guya a-wena, rrapa gala a-yinmiyarna gu-rrumungarna gun-gata nipa gochila jin-dana. ");
INSERT INTO bvr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Wurra gun-gata warrika lika a-jerrmarra an-nigipa an-mujama barra a-ma an-gata bama a-jirra Jon. Nipa an-mujama a-bona, a-barrngumurra wupa gata nipa Jon a-ninya, lika a-jaygorndanga, ");
INSERT INTO bvr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","bama a-jirra a-menga, lika ana-ganyja an-ngartpelambila japalana ana-guyinda, lika jiny-yuna jin-gata jin-ngamangama. Lika nipa ana-ganyja, jin-nigipa mampa acha jiny-yuna. ");
INSERT INTO bvr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wurra aburr-gata Jon burr-yika jawina aburr-galiyana nula birripa aburr-gata aburr-yinmiyana nula, lika aburr-bona gurda, abu-menga, abu-ganyja, abu-gurrmurra gata wuparnana gu-gurrema gu-ngarnama. Gu-gurda ngacha minypa Jon a-juwuna, rrapa gurda nula nuwurra waypa janguny gu-barrjekarra nula Jesus, Ayrat nipa gu-borrwurra jimarna bama a-yinanga nipa Jon a-molamiyana. Ngardawa nipa Ayrat gala marn․gi nula Jesus. ");
INSERT INTO bvr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nuwurra waypa Jesus burr-yika jawina aburr-jekarra gurda nula, lika aburr-wena nula birripa aburr-yinmiyana burr-barlmarrk jama aburr-ji rrapa minypa janguny gubu-ngurrjinga aburr-bona. ");
INSERT INTO bvr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Wurra aburr-jaranga gu-galiya yerrcha aburr-bona gurda aburr-ji, wurra Jesus rrapa aburr-yigipa jawina gala marnnga jiny-jirrarna burrwa rraka balaja mbi-bangarna. Lika nipa a-yinanga burrwa, “Guwa, nguburr-boy gu-werrapa barra ngardapa nguburr-ni rrapa ana-goyburrpa nyiburr-ngeka.” ");
INSERT INTO bvr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Lika mu-michiyang aburr-warrchinga birripa wupa barra aburr-boy, ngardapa aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Wurra aburr-jaranga wurra gama gorlk burrbi-nana birripa aburr-bona, wurra jarra burrbu-malawurra, lika gubu-bawuna rrawa, aburr-bona, gu-rrepara aburr-gomarriyana aburr-bamuna, aburr-bena birri-gugu, lika nuwurra jurdach Jesus rrapa aburr-yigipa jawina aburr-bena. ");
INSERT INTO bvr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Gun-gatiya Jesus a-bena, lika burr-nana wurra gama gorlk, lika a-worijinga burrwa a-ni ngardawa burr-nana birripa minypa jin-maywapa jip (sheep) jin-guyinda jin-gata gala ana-nga jaga a-gana achila a-workiya. Lika gu-gata wenga janguny marn․gi burr-negarra a-ni. ");
INSERT INTO bvr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Lika balngga gu-ni, lika Jesus burr-yika jawina aburr-garlmuna, aburr-wena nula. Aburr-yinanga, “A-lay, gun-guna yi-rrana gu-ni gugu, ngardawa gun-guna gu-werrapa nguburr-nirra, ngardawa aburr-guna gun-birripa rrawa balay. ");
INSERT INTO bvr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Wurra yama nginyipa burr-jerrma barra aburr-boy, rrawa gu-jirra gu-boya balaja mbi-ma barra mbi-bay?” ");
INSERT INTO bvr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","“Ngika. Wurra jarra ana-goyburrpa nyirrbu-wu barra mbi-bay,” Jesus a-yinagata a-wena. Birripa aburr-yinagata, “A-lay, rrupiya wana mun-gata minypa an-gugaliya mu-mangga a-workiya, jama a-jirra a-workiya ran․gu abirri-jirrapa abirri-jirrapa rrapa abirri-jirrapa abirri-jirrapa, mu-gurda ngacha ngayburrpa gala nyibi-rrima rraka nyibu-ga, rakaraka nyibu-ma burrwa aburr-guna aburr-jaranga.” ");
INSERT INTO bvr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Lika Jesus burr-wengganana, “Wurra mu-yinmiyapa rakaraka mun-guyinda nyibi-rrimanga? Buburr-boy, bubi-na.” Lika aburr-bona, mbi-nana, lika aburr-jekarra gurda, aburr-wena nula, “Minyja rakaraka mun-delipa mun-guyinda arr-ngardapa arr-murna, minypa 5, rrapa abirri-jirrapa wupa an-delipa jichicha.” ");
INSERT INTO bvr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesus lika a-wena burrwa aburr-yigipa jawina barra wurra gama gorlk aburr-ngorrkorndiya aburr-boy, gata aburr-raka, mu-molamola mu-gorrngunya aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Lika wurra gama gorlk gun-bama gubu-rrumurra aburr-ni, minypa 100 aburr-ni, rrapa minypa aburr-werranga 50 aburr-ni, rrapa aburr-werranga 50 aburr-ni, rrapa aburr-werranga 100 aburr-ni, gu-gurda ngacha. ");
INSERT INTO bvr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Lika Jesus mu-menga mun-gata rakaraka arr-ngardapa arr-murna rrapa an-gata abirri-jirrapa jichicha, lika waykin a-ganana, lika a-japurramayana nula Wangarr. Lika mu-rrumurra rakaraka, lika burr-wuna aburr-yigipa jawina barra burrbu-wu aburr-boy wurra gama gorlk, minypa burr-jichicha burr-guta burrbu-wuna aburr-bona. ");
INSERT INTO bvr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Lika aburr-bulapalawa aburr-gata wurra gama gorlk mbi-barra balaja, rrapa jichicha abu-barra, lika aburr-durtchinga. ");
INSERT INTO bvr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Rrapa mun-nerranga mbi-bawuna rakaraka rrapa jichicha Jesus burr-yika jawina mbi-menga, wana burlupurr gu-guyinda mbi-jolartchinga, gu-ngana mu-mayana gun-gata minypa arr-jirrapa arr-murna rrapa abirri-jirrapa, minypa 12. ");
INSERT INTO bvr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Gun-nardiya minypa janguny aburr-gata rakaraka mbi-barra aburr-ni wurra gama gorlk, wurpa lika mu-wurra yerrcha wupa 5,000. ");
INSERT INTO bvr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Gu-gatiya wenga Jesus a-wena burrwa aburr-yigipa jawina, birripa mu-michiyang aburr-gortkurrchinga, mu-ngoyurra aburr-bona gu-gapa gu-rrarnba gun-nelangga Bachéyda (Bethsaida), minypa nipa burdak Jesus burr-jerrmarra a-ni wurra gama gorlk rrawa. ");
INSERT INTO bvr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Burr-jerrmarra a-bona, ganapiya, lika nipa gu-bulgapulga gu-guyinda a-bona, rrapa minypa Nyanyapa arrku a-wengganana a-ni. ");
INSERT INTO bvr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Lika ana-munya gu-ni gu-bamuna, Jesus burr-yika jawina gochilawa aburr-bamuna mu-michiyang, wurra Jesus gatiya ngardapa a-ni jorrnyjurra. ");
INSERT INTO bvr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Lika nipa burr-nana barlmarrk mirrka derta burr-negarra gu-ni, minypa birripa aburr-garlajinga gun-nyagara, wurra barlmarrk wana gu-bena burrwa. Lika gu-gata wenga ngana guna-ngarlcha, lika Jesus a-bena burrwa gu-bugula gu-jonama ana-jarl ana-bamuna. Nipa jimarna barra burr-beyba ay-bamba, ");
INSERT INTO bvr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","wurra birripa abi-nana gu-bugula waykin ana-bamuna, jimarna bama aburr-yinanga walkwalk. Aburr-gonyjinga, “Waw!” ");
INSERT INTO bvr_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ngardawa aburr-bulawa abi-nana rrapa aburr-gurkuja. Wurra warrika waya nipa Jesus ana-wena burrwa. “Nyiburr-molamola buburr-ni. Ngaypa, ngarla! Ganapa buburr-gurkuja.” ");
INSERT INTO bvr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Lika nipa mu-michiyang a-warrchinga burrwa, lika barlmarrk gu-ngochinga. Wurra aburr-yigipa jawina burr-guya gochila aburr-barrjinga, ");
INSERT INTO bvr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ngardawa birripa gala gubu-borrwujarna nula burr-barlmarrk jama a-ji gun-gata nipa rakaraka burr-wuna aburr-bulapalawa; gala meyali gubi-nacharna. ");
INSERT INTO bvr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ganapiya, lika gu-gata wenga birripa aburr-bena gu-gapa gu-rrarnba rrawa gun-gata gun-nelangga Ganécharat (Gennesaret). Lika gatiya mbi-bandawurra, ");
INSERT INTO bvr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","mbi-bawuna michiyang, warrika wurra gama gorlk abi-nana, abu-malawurra Jesus. ");
INSERT INTO bvr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Lika aburr-yurtchinga, gun-gata rrawa gu-ji gu-bona gu-derdakurderda yerrcha burrbu-menga, garrung mu-guyinda burrbu-ganyja gurda nula yina gaya birripa aburr-galiyana nipa yina an-gaya. ");
INSERT INTO bvr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Rrapa Jesus ay-yinda a-bona rrawa gu-jirra gu-boya, birripa wurra gama gorlk burrbu-ganyja gurda nula gu-derda aburr-yorrpuna. Lika gatiya burrbu-barnjinga gun-gatiya rrawa burr-yika gu-ngardapa aburr-negiyana aburr-workiyana, lika aburr-ngiwija nula Jesus barra birripa aburr-gurderdakurderda mbi-rrima murna mu-jirra mun-nigipa mirikal minypa ganyjarr abu-gaypa, aburr-molamiya. Ganapiya, lika aburr-gata mbi-rrimarra aburr-bulapalawa aburr-molamiyana. ");
INSERT INTO bvr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Gu-gata wenga Berachi (Pharisee) yerrcha rrapa aburr-werranga aburr-gata joborr marn․gi aburr-gunega Jirúchalam (Jerusalem) wenga, birripa aburr-mulpiyana nula Jesus. ");
INSERT INTO bvr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Lika burrbi-nana Jesus burr-yika jawina balaja mbi-barra, gala murna aburr-jirra mu-ngoyurra aburr-wepiyarna minypa gun-birripa gun-guwarr Berachi yerrcha gun-burriya birripa aburr-weya aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Minypa Berachi yerrcha rrapa aburr-werranga Ju yerrcha burr-guta gubu-borrwuja aburr-workiya gun-birripa gun-guwarr, minypa gala balaja mbi-bay aburr-workiya wurra burdak murna aburr-jirra aburr-wepiya aburr-workiya gun-birripa gun-guwarr. ");
INSERT INTO bvr_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Rrapa minypa balaja burr-rrupiya mbi-mangga aburr-workiya, burdak mbi-weparda aburr-workiya, lika nuwurra jurdach mbi-banga. Rrapa gu-gurda ngacha mola gun-jaranga gubu-borrwuja aburr-workiya gun-birripa gun-guwarr, minypa aburr-yinmiya an-birripa japalana abu-weparda aburr-workiya rrapa gun-nga gun-nerranga aburr-yinmiya aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Lika aburr-gurdiya Berachi yerrcha rrapa joborr marn․gi aburr-gunega aburr-wena nula Jesus, “A-lay, yama aburr-nginyipa jawina gubu-borrwa gun-ngayburrpa gun-guwarr? Wurra birripa mbi-banga aburr-nirra, gala murna aburr-jirra mu-ngoyurra aburr-wepiyarna minypa gun-ngayburrpa gun-guwarr.” ");
INSERT INTO bvr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Wurra Jesus a-yinanga burrwa, “A-lay, gun-gata wola an-gata Aycháya (Isaiah) a-wena Wangarr gun-nika rrapa minypa nyirr-ngurrjinga ana-goyburrpa, gun-narda gun-burral. Ngardawa ana-goyburrpa waykin nyiburr-molamola; wupa nyiburr-werra. Minypa janguny mu-jurra gu-yurra, gu-yinaga, ‘Aburr-guna gu-galiya yerrcha ngana aburr-jirra wupa aburr-weya aburr-workiya jimarna marr aburr-balcharra apula, wurra jarra wuparnana aburr-ngurrnga balaypalay aburr-nirra apula. ");
INSERT INTO bvr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Birripa borijipa aburr-japarndiya apula aburr-workiya. Ngardawa marn․gi aburr-negiya aburr-workiya ana-gugaliya gun-nika wupa joborr.’ ");
INSERT INTO bvr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Gu-yinagata gu-yurra janguny nyirr-ngurrjinga ana-goyburrpa. Minypa Wangarr gun-nika joborr gun-guyinda ana-goyburrpa nyibu-beybana, wurra gun-goyburrpa gun-guwarr ana-gugaliya gun-nika wupa nyibu-borrwuja nyiburr-workiya, ngarla.” ");
INSERT INTO bvr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesus mu-nguy a-wena burrwa, a-yinagata, “Ana-goyburrpa jimarna jarra marn․gi nyiburr-nirrarna, wurra Wangarr gun-nika joborr gun-guyinda ngoyurra nyiburr-yerryerrmiyana nula, ngarla. Wurra gun-gata janguny ana-goyburrpa nyibi-rrimanga gun-goyburrpa wupa jarra. ");
INSERT INTO bvr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ngardawa Mojich (Moses) a-wena, a-yinanga, ‘Marr balcha burrinyjula nyanyapa nggu rrapa mampa nggu.’ Rrapa a-yinagata, ‘Ana-nga minyja an-nerra a-nega nyanyapa niya, rrapa mampa niya jin-nerra jinyu-nega, an-gata an-gugaliya ana-goyburrpa barra nyibu-bu, a-juwa.’ ");
INSERT INTO bvr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Wurra ana-goyburrpa marn․gi nyirrbi-nenga nyiburr-workiya wurra gama gorlk, jimarna nyibu-borrwuja ana-nga an-gata gu-rrimanga gun-nga gun-gata barra bijirriny-borrwa nyanyapa niya rrapa mampa niya, wurra minyja a-yinda burrinyjula, ‘Ngika. Jarra gun-guna gun-japurra; gipa mu-ngoyurra ngu-wuna Wangarr gun-nigipa,’ ");
INSERT INTO bvr_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","lika ana-goyburrpa nyiburr-yinaga jimarn jarra gun-gata gun-mola nula gala a-yinmiya a-gunggaja burrinyjula nyanyapa niya rrapa mampa niya. ");
INSERT INTO bvr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Wurra gun-gata ana-goyburrpa nyiburr-weya burrwa nyiburr-workiya wurra gama gorlk, gu-gata wenga birripa Wangarr gun-nika gubu-morraja wengga, jimarn jarra aburr-gunggaja burrwa nyanyapa burra rrapa mampa burra, wurra gun-nyagara. Ana-goyburrpa nyiburr-yinagata nyiburr-workiya gun-nerra jama nyiburr-jirra gu-gurdiya ngacha gun-jaranga.” ");
INSERT INTO bvr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Lika Jesus a-gonyjinga burrwa wurra gama gorlk aburr-mulpiyana nula. Lika a-yinanga burrwa, “Nyiburr-gurda marrka buburr-galiya apula rrapa marn․gi buburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Gala gun-nga an-gugaliya yarlanga gun-nerra gu-barrnguma nula ana-ngana nipa balaja m-banga a-nirra rrapa minypa an-nerra a-nega an-gata an-gugaliya nuluwa Wangarr. Ngika. Wurra jarra gun-gata minypa nipa an-gugaliya jama a-jirra a-workiya, gu-gurda ngacha minypa nipa werra a-negiya a-workiya nuluwa Wangarr.” ");
INSERT INTO bvr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Gu-gata wenga Jesus burr-bawuna wurra gama gorlk, lika a-bona, wupa a-barrngumurra gu-bala. Lika aburr-yigipa jawina abu-wengganana gun-gata meyali nipa a-wena. ");
INSERT INTO bvr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Lika nipa a-yinagata burrwa, “Awa. Nyiburr-gurda burr-guta gala burr-guya marn․gi nyiburr-ni, ya? Wurra yama nyibu-borrwa mun-gata mun-nga minypa an-gugaliya m-banga a-workiya? Minyja mun-narda gala mu-yinmiya an-gugaliya werra a-nega nuluwa Wangarr. ");
INSERT INTO bvr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ngardawa gala mu-yinmiya mu-yurtcha, ana-bama m-barrnguma, wurra m-boya mu-workiya ana-gochila, rrapa barrwa minypa yarlanga m-beya.” (Gun-narda Jesus a-wena, minypa mun-bulapalawa balaja mun-molamola mu-negarra arrkula.) ");
INSERT INTO bvr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Lika mu-nguy a-wena, a-yinagata, “Wurra gun-nerra an-gugaliya jama a-jirra a-workiya, gu-gurdiya ngacha minypa nipa werra a-negiya nuluwa Wangarr. ");
INSERT INTO bvr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ngardawa ana-ngurrnga wenga nipa an-gugaliya gu-borrwuja a-workiya gun-nerra, gu-gatiya wenga minypa jama a-jirra a-workiya marrambay gun-guji, rrapa minypa mun-ngumurda mu-mangga a-workiya, rrapa minypa burr-burnda a-workiya, ");
INSERT INTO bvr_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","rrapa minypa ana-werranga jin-nika jiny-mangga a-workiya, rrapa minypa gun-jaranga jal a-nirra a-workiya, rrapa minypa an-bachirra, rrapa minypa burr-yolkaja a-workiya, rrapa minypa gala gona a-ni, wurra jal a-nirra gu-gata ngacha gun-nerra, rrapa minypa mu-werrmbarra burr-nacha rrapa burr-yopurda, rrapa minypa wana a-negiya, rrapa minypa gun-molamola gu-morraja a-workiya. ");
INSERT INTO bvr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Gu-gurdiya ngacha gun-nerra an-gugaliya gu-rrimanga rrapa minypa werra a-negiya a-workiya nuluwa Wangarr.” ");
INSERT INTO bvr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Gu-gata wenga Jesus gu-bawuna rrawa, lika a-bona, a-bena gun-gata rrawa gu-jirra gu-boya Daya (Tyre). Lika a-barrngumurra wupa gu-bala, jimarna yongun a-nirrarna; wurra gala a-yinmiyarna, ngardawa wurra gama gorlk abu-malawurra, lika aburr-bena nula. ");
INSERT INTO bvr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Rrapa jin-ngardapa gama nipa jin-babalapa wurra jin-nigipa mu-lopa acha walkwalk a-rrimarra, nipa jin-babalapa jin-jaliyana nula Jesus, warrika jina-bona, lika ji-menama gu-rrana nula. ");
INSERT INTO bvr_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nipa jin-gata Ju ngika, wurra nipa Jayrapaníchiya (Syrophoenicia) jin-guyinda minypa gu-werranga gu-rrawa. Minypa Ju yerrcha gala jal aburr-nirrarna burrwa gu-werranga gu-rrawa, wurra burrbu-ngurrjinga aburr-workiyana gulukula yerrcha. Wurra nipa jin-gata jina-bona, jiny-nyiwija nula Jesus barra walkwalk a-yerrnyja achila mu-lopa acha. ");
INSERT INTO bvr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Wurra Jesus gun-maywapa ranginy a-wena achila, a-yinanga, “Burdak gu-ngarda yerrcha mbi-bay barra balaja mu-yinmiyapa birripa jal aburr-ni. Wurra gu-gata ngacha gala gu-yu rraka gu-ngarda yerrcha mun-birripa balaja an-gugaliya burr-gaypa rrapa a-wu gulukula, ngaja.” Nipa a-yinagata Jesus a-wena achila minypa meyali gu-murna. ");
INSERT INTO bvr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Rrapa nipa jiny-yinagatiya, meyali gu-murna jiny-yena nula Jesus, “Ngaw, Bunggawa. Wurpa lika gulukula an-guyinda m-banga a-workiya mun-jinachina m-bunggiya mu-workiya, gu-ngarda yerrcha mbi-banga aburr-nirra.” ");
INSERT INTO bvr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Lika nipa a-yinagata achila, “Ngardawa gurda gun-molamola ny-yena, lika nginyipa ny-boy rrawa, wurra gipa walkwalk jiny-bawuna jiny-nginyipa mu-lopa nggu.” ");
INSERT INTO bvr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Lika gu-gata wenga jiny-bona rrawa, lika jinyu-nana delipa gata gu-belabila gu-guyinda jiny-yunya, gipa walkwalk jiny-bawuna. ");
INSERT INTO bvr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Gu-gata wenga Jesus gu-bawuna rrawa Daya, lika a-bona, a-bena Jaydan (Sidon). Lika a-bamuna, lika gu-gata wenga a-gomarriyana, a-bena gun-gata rrawa Galali (Galilee), wurpa lika gun-gata rrawa gu-jirra gu-boya arr-gulirrwirrka arr-murna, minypa 10. ");
INSERT INTO bvr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Rrapa gatiya lika aburr-werranga abu-ganyja gurda nula Jesus an-ngardapa an-gata an-gerna rrapa an-ngarlngarta, lika aburr-ngiwija nula Jesus barra nipa a-rrima. ");
INSERT INTO bvr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Lika Jesus a-menga, ngardapa abirri-bona yi-gurrepa, wurra aburr-jaranga gata aburr-ni. Lika murna a-jirra a-barrngumurra ana-gelama, lika m-bochinga mun-bordich rrapa a-rrimarra ngarl a-jirra. ");
INSERT INTO bvr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Lika a-ganana waykin, gu-murna a-ngekarra, lika a-wena nula an-gata an-gugaliya minypa gun-birripa wengga a-yinanga, “Epata!” minypa ngayburrpa gu-jingarliya nguburr-yinaga nguburr-workiya, “Lapkujamiya!” ");
INSERT INTO bvr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Lika warrika an-gugaliya gelama a-jirra a-lapkujamiyana rrapa ngarl a-jirra a-derichinga, gun-derta gun-gorla a-wena. ");
INSERT INTO bvr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Lika Jesus a-wena burrwa wurra gama gorlk gala barra aburr-wengga burrwa aburr-werranga gun-gata nipa a-jarlapuna, wurra yongun gubi-nega barra. Wurra nipa a-yinagata a-wenapa, wurra birripa gubu-ngurrjingapa aburr-bona. ");
INSERT INTO bvr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wurra aburr-gata aburr-galiyanapa burr-guya gochila aburr-barrjinga. Aburr-yinanga, “An-guna burr-barlmarrk jama a-jirra, ya? Nipa ngardawa a-jarlapurda a-boya an-ngarlngarta rrapa an-gerna, ngaja, ngarla!” ");
INSERT INTO bvr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Lika gun-gatiya gun-nerranga gun-ni, mola wurra gama gorlk aburr-mulpiyana nula Jesus. Lika gun-gata balaja mu-wulebiyana burrwa, lika Jesus a-gonyjinga burrwa aburr-yigipa jawina aburr-bona gurda nula, lika a-yinanga burrwa, ");
INSERT INTO bvr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Aburr-guna wurra gama gorlk ngaypa ngu-worijinga burrwa ngardawa gipa gugu ngorrngurra abirri-jirrapa gun-ngardapa nguburr-ni rrapa balaja mu-wulebiyana burrwa. ");
INSERT INTO bvr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Minyja ngaypa nguburr-jerrma gun-birripa rrawa minypa aburr-werrmiyana, birripa aburr-bamba, gojilapa murna aburr-derichin, ngardawa aburr-werranga gu-baykarda aburr-bona gurda.” ");
INSERT INTO bvr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wurra Jesus burr-yika jawina aburr-wena nula, “Aya. Wurra balaja mun-an․gaya barra ngayburrpa arrbu-wu? Wurra ngayburrpa gu-werrapa nguburr-nirra.” ");
INSERT INTO bvr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Wurra Jesus a-yinagata, “Ana-goyburrpa mu-yinmiyapa rakaraka nyibi-rrimanga?” Birripa aburr-yinagata, “Minyja arr-ngardapa arr-murna rrapa abirri-jirrapa, minypa 7.” ");
INSERT INTO bvr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ganapiya, lika nipa Jesus a-wena burrwa wurra gama gorlk barra birripa gu-jel aburr-raka. Lika nipa mun-gata rakaraka mu-menga arr-ngardapa arr-murna rrapa abirri-jirrapa, lika a-japurramayana nula Wangarr. Lika mu-rrumurra mun-gata rakaraka, lika burr-wuna aburr-yigipa jawina barra birripa burrbu-wu aburr-boy. Ganapiya, lika birripa burrbu-wuna aburr-bona. ");
INSERT INTO bvr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Rrapa an-gata an-delipa jichicha abi-rrimarra an-jaranga ngika, Jesus a-japurramayana nula Wangarr, lika a-wena burrwa aburr-yigipa jawina barra jichicha burrbu-wu aburr-boy wurra gama gorlk. ");
INSERT INTO bvr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ganapiya, lika mbi-barra, aburr-durtchinga. Lika mun-nerranga mu-ngukiyana Jesus burr-yika jawina mbi-menga, wana burlupurr gu-guyinda mbi-jolartchinga, gu-ngana mu-mayana gun-gata minypa arr-ngardapa arr-murna rrapa abirri-jirrapa, minypa 7. ");
INSERT INTO bvr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Wurra minypa aburr-gata wurra gama gorlk mu-ngoyurra mbi-barra balaja rrapa jichicha abu-barra, aburr-gata mu-wurra yerrcha wupa birripa 4,000. ");
INSERT INTO bvr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Lika gu-gata wenga burr-jerrmarra wurra gama gorlk aburr-jekarra rrawa. Warrika nipa rrapa aburr-yigipa jawina mu-michiyang aburr-warrchinga, yi-gata aburr-bona Dalmanúcha (Dalmanutha) rrawa gu-jirra gu-boya. ");
INSERT INTO bvr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Lika gu-gata wenga Berachi (Pharisee) yerrcha aburr-bona gurda nula Jesus rrapa abu-jurnajuchuwuna, jimarna nipa barra a-yinmiya jama a-ji rrapa a-wengga rrapa minypa mari gubu-garra nula. Minypa aburr-wena nula yama nipa burr-barlmarrk jama a-ji barra birripa marn․gi aburr-ni nula jimarn jarrapa nipa Wangarr an-nika. ");
INSERT INTO bvr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Wurra nipa Jesus gu-murna a-ngekarra, lika a-wena burrwa, “Nyiburr-gurdiya gorlk gun-nardiya rrawa, an-nga nula ana-goyburrpa jal nyiburr-nirra nyibi-na barra Wangarr gun-nika ganyjarr? Wurra ngaypa ngu-weya ana-gorrburrwa nipa gala barra nyirr-gurdagurdarra ana-goyburrpa ganyjarr.” ");
INSERT INTO bvr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Gu-gata wenga nipa burr-bawuna a-bona, mu-michiyang a-warrchinga. Lika a-jurrwurra gu-gapa gu-rrenyjiya, aburr-yigipa jawina burr-guta. ");
INSERT INTO bvr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Wurra aburr-yigipa jawina aburr-bamapuna, gala rakaraka mbi-ganyjingarna gurda, wurra mun-ngardapiya wupa mbi-ganyja gurda mu-michiyang. ");
INSERT INTO bvr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Gun-gatiya aburr-bamuna gurda, lika Jesus a-wena burrwa, “Buburr-jarlapiya nula mun-gata Berachi yerrcha mun-burriya rrapa mola Ayrat (Herod) mun-nika mun-gata minypa gandichawa rakaraka mu-nenga mu-workiya.” ");
INSERT INTO bvr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Gun-narda Jesus a-wena, wurra aburr-yigipa jawina aburr-wengganachichiyana aburr-ni, aburr-yinanga, “Gun-narda nipa a-wena ngardawa rakaraka nguburr-bamapuna, ya?” ");
INSERT INTO bvr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nipa Jesus gu-borrwurra birripa aburr-wena aburr-ni, lika a-yinanga burrwa, “An-nga nula ana-goyburrpa nyiburr-weya rakaraka gun-nyagara? Wurra gala nyibu-borrwa, ya? Wurra nyiburr-gerna, ya? ");
INSERT INTO bvr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Minyja mipila nyiburr-jirra nyiburr-jirra, wurra gala nyiburr-yinmiya nyibi-na, ya? Gelama nyiburr-jirra nyiburr-jirra, wurra gala nyiburr-galiya, ya? Wurra yama nyibu-borrwa? ");
INSERT INTO bvr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Wurra mun-gata rakaraka arr-ngardapa arr-murna ngu-rrumurra burrwa aburr-gata mu-wurra yerrcha 5,000, mun-narda mu-yinmiyapa mu-ngukiyana?” Birripa aburr-yinanga nula, “Burlupurr wana gun-babalapa gu-ngana mu-mayana gun-gata minypa arr-jirrapa arr-murna rrapa abirri-jirrapa, minypa 12.” ");
INSERT INTO bvr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Rrapa mun-gata rakaraka arr-ngardapa arr-murna rrapa abirri-jirrapa ngu-rrumurra burrwa aburr-gata mu-wurra yerrcha 4,000, mu-yinmiyapa mu-ngukiyana?” Birripa aburr-yinagata, “Burlupurr wana gun-babalapa gu-ngana mu-mayana gun-gata minypa arr-ngardapa arr-murna rrapa abirri-jirrapa, minypa 7.” ");
INSERT INTO bvr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nipa a-yinagata burrwa, “Minyjiya, ngarla. Wurra gun-gata ana-goyburrpa gala nyibi-na meyali, ya?” ");
INSERT INTO bvr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Gu-gata wenga aburr-bena gu-gapa gu-rrarnba gun-nelangga Bachéyda (Bethsaida), rrapa gatiya gugu aburr-werranga gu-galiya yerrcha an-gapula abu-ganyja gurda, gala a-ganajarna. Lika aburr-ngiwija nula Jesus nipa barra a-rrima. ");
INSERT INTO bvr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Wurra Jesus a-menga an-gapula, mernda a-jirra a-rrimarra, a-ganyja, gubirri-bawuna gun-gata rrawa, yi-gata abirri-bona yarlanga. Gata lika Jesus m-bordich a-balkaja mipila a-jirra rrapa minypa a-rrimarra. Lika a-wena nula, “Gipa gun-nga nyi-nacha, ya?” ");
INSERT INTO bvr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Wurra nipa gu-nana, lika a-yinanga, “Ngaypa mu-wurra yerrcha nguburr-nacha, wurra minypa gun-jong aburr-rrigirrgnga.” ");
INSERT INTO bvr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Barrwa Jesus a-rrimarra mipila a-jirra, lika nipa burr-guya a-ganana, ganapiya, mun-molamola a-ganana. ");
INSERT INTO bvr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Lika nipa Jesus a-jerrmarra rrawa. Minypa a-yinagata nula, “Gala barra yi-gata ny-boy bala gu-jirra gu-boya, wurra gomarriya bamba, gun-nginyipa rrawa bengga.” ");
INSERT INTO bvr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Lika gu-gata wenga Jesus rrapa aburr-yigipa jawina yi-gata aburr-bona rrawa gu-jirra gu-boya gun-gata Jecharíya Bilipay (Caesarea Philippi). Gojilapa aburr-bamuna, nipa burr-wengganana, “A-lay, wurra gama gorlk birripa ngunabu-ngurrjinga aburr-workiya minypa ngaypa ngu-ngiya?” ");
INSERT INTO bvr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","“Minyja aburr-werranga bubu-ngurrjinga, jimarna bama aburr-yinaga nginyipa Jon bama burr-gurragaja a-workiyana, rrapa aburr-werranga bubu-ngurrjinga jimarna nginyipa Yiláyja (Elijah), rrapa aburr-werranga bubu-ngurrjinga jimarna aburr-mujaruk ngunyuna aburr-guyinda mu-ngoyurra gubu-ngurrjinga aburr-workiyana Wangarr gun-nika nginyipa ny-jatiya ny-nyardapa.” ");
INSERT INTO bvr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Aya. Wurra ana-goyburrpa ngu-ngiya ngunabu-ngurrjinga?” Wurra nipa Birta a-wena, “Ny-jurda nginyipa Christ nipa Wangarr gochila nyin-dana.” ");
INSERT INTO bvr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Lika Jesus a-wena burrwa, “Ngaw, ngarla. Wurra ana-goyburrpa gala barra ana-nga nyiburr-wengga nula ngaypa ngu-ngiya.” ");
INSERT INTO bvr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Lika gun-nardiya gugu Jesus a-wena burrwa a-workiyana aburr-yigipa jawina minypa nipiya An-walkurpa An-gugaliya burr-guya gun-nerra gu-ni barra nula, rrapa minypa aburr-gata mu-murna yerrcha rrapa mola junggay yerrcha rrapa joborr marn․gi aburr-gunega, birripa ngoyurra aburr-yerryerrmiya barra nula rrapa abu-bu barra a-juwa, rrapa minypa gu-gata wenga ngorrngurra abirri-jirrapa gun-ngardapa, lika a-molamiya barra. ");
INSERT INTO bvr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Gun-narda nipa Jesus a-wena yarlanga, wurra nipa Birta ana-nyala a-menga Jesus rrapa a-ganyja balay ngika, lika a-garlmuna, jimarna a-jobujobungarna Jesus gun-narda a-wena janguny. ");
INSERT INTO bvr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Wurra Jesus a-ngukurdanyjiyana, burr-nana aburr-yigipa jawina rrapa a-jobujobuna Birta. A-yinanga, “Nguna-bawa! Ny-jurda nginyipa an-gata walkwalk Jeytan (Satan)! Nginyipa nyi-guwarga. Gun-gata ny-yena, gun-narda ngika Wangarr nyanma; wurra ana-gugaliya nyanma.” ");
INSERT INTO bvr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Lika Jesus a-gonyjinga burrwa aburr-yigipa jawina rrapa mola wurra gama gorlk, lika birripa aburr-bona gurda nula, lika a-wena burrwa, a-yinanga, “Ana-nga minyja nipa jal a-ni barra nguna-jurrjurrma, nipa an-gata gala barra nipa wupa a-borrwiya a-workiya, wurra jarra jama a-ji barra a-workiya gun-gata minypa ngaypa ngu-wu barra, rrapa mu-nguy nguna-jurrjurrmapa barra a-workiya marrban gun-derta gu-barripa. ");
INSERT INTO bvr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ngardawa ana-nga an-gata gala nguna-burdima, jimarna barra wanngu a-negiya, an-gata an-gugaliya jarra gun-nyagara gu-ni barra. Wurra ana-nga minyja aburr-werranga abu-bu, a-juwa minypa nipa an-ngaypa rrapa gun-ngaypa janguny gu-rrimanga apula, an-gata an-gugaliya nipa jarra wanngu a-nipa barra a-workiya. ");
INSERT INTO bvr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Wurra ana-nga an-gata wana an-babalapa a-negiya gun-guna rrawa wurra gala wanngu gun-gunega nipa gu-borrwa a-ni, nipa an-gata gala gun-nga gun-molamola guna-jeka barra nula minypa nipa jama a-ji a-workiyana, wurra gun-nyagara. ");
INSERT INTO bvr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Rrapa barrwa gala gun-nga rraka nipa an-gata gu-barnja jimarna barra wanngu a-negiya. ");
INSERT INTO bvr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Wurra an-ngaypa jawina gala barra a-gurkuja burrwa wurra gama gorlk rrapa minypa gona a-ni apula ngaypa rrapa gun-ngaypa janguny. Ngika. Gala a-yinmiya. Wurra aburr-gurdiya gorlk jarra aburr-werra, minypa gala jal aburr-ni nula Wangarr. Wurra minyja ana-nga a-gurkuja burrwa birripa rrapa gona minypa barra a-ni apula ngaypa, an-gata an-gugaliya nuwurra waypa an-guna An-walkurpa An-gugaliya ana-jeka barra burr-gujayanaya Nyanyapa niya gun-nika, rrapa minypa aburr-gata waykin aburr-guyinda aburr-mujaruk wugupa nula aburr-bupiya barra gurda, nipa An-walkurpa gun-gatiya barra gala barra jal a-ni nula an-gata an-gugaliya.” ");
INSERT INTO bvr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Rrapa a-yinagata burrwa, “Gun-guna ngu-weya ana-gorrburrwa gun-burral: Nyiburr-werranga nyiburr-gurda gala barra mu-ngoyurra nyiburr-juwa, wurra burdak nyibi-na barra Wangarr gun-nika rum burr-barlmarrk gu-bengga barra gun-nardiya rrawa.” ");
INSERT INTO bvr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nuwurra waypa ngorrngurra abirri-jirrapa abirri-jirrapa abirri-jirrapa, lika Jesus burr-ganyja Birta (Peter) rrapa Jeymch (James) rrapa Jon, yi-gata mu-mirk waykin aburr-bona ngardapa burrwa. Gu-gata wenga abi-nana Jesus ngol gun-nerranga gu-rakaja nula, ");
INSERT INTO bvr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","rrapa minypa mun-nigipa mirikal mu-garlmunapa mun-gungarlcha mu-nayana mu-ji, wurra ngayburrpa gala mu-yinmiya mu-yirda mun-gungarlcha ngubi-nega. Ngika. ");
INSERT INTO bvr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Lika gu-gata wenga burrbi-nana gipa mu-ngoyurra abirri-guyinda Yiláyja (Elijah) rrapa Mojich (Moses) minypa bitipa wugupa nula Jesus aburr-wena aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Wurra aburr-gata abirri-jirrapa an-ngardapa Jesus burr-yika jawina burr-guya aburr-gurkuja; gala marn․gi aburr-yinmiya barra aburr-wengga. Lika Birta a-garlmuna, a-wena nula Jesus, “A-lay, Bunggawa, gun-narda gun-molamola minypa ngayburrpa nyiburr-guna wugupa ana-gorrburrwa. Ngaw minyja ngayburrpa barra ngunyuna nyibu-gupa ana-gorrburrwa birlapirla abirri-jirrapa gun-ngardapa, minypa gun-ngardapa gun-nginyipa rrapa gun-ngardapa Mojich gun-nika rrapa gun-ngardapa Yiláyja gun-nika?” a-yinagata nipa Birta a-wena. ");
INSERT INTO bvr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Lika gu-garlmunapa nguparr bin-denyjinga, rrapa ana-manyjirda aburr-galiyana gu-nguparr wenga Wangarr a-yinanga burrwa, “An-guna an-ngaypa Walkur ngaypa burr-guya jal ngu-nirra nula. An-nardiya buburr-galiya nula!” ");
INSERT INTO bvr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wurra birripa aburr-wechawecha aburr-ni, wurra gala barrwa ana-nga abi-nacharna, wurra jarra nipa wupa Jesus. ");
INSERT INTO bvr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Lika gatiya waypa mu-mirk wenga aburr-bupiyana gurda aburr-bamuna, Jesus burr-guya a-wena burrwa aburr-bamuna, minypa geka gubi-nana birripa gala barra gubu-ngurrja burrwa aburr-werranga wurra nuwurra waypa barra nipiya An-walkurpa An-gugaliya a-juwa rrapa barrwa a-molamiya. ");
INSERT INTO bvr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Lika birripa yongun gubi-negarra gun-gata gu-yinmiyana, wurra minypa birripa wupa aburr-wengganachichiyana aburr-ni, “A-lay, gun-gata an-nga nula nipa a-yinagata a-wena a-juwa barra rrapa barrwa a-molamiya?” ");
INSERT INTO bvr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Wurra birripa Jesus abu-wengganana, “A-lay, gun-gata an-nga nula aburr-gata joborr marn․gi aburr-gunega aburr-weya aburr-workiya ni-gugu Yiláyja ana-boy barra?” ");
INSERT INTO bvr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Lika nipa Jesus a-yinanga burrwa, “Ngaw. An-nerranga minypa Yiláyja ni-gugu ana-boya, rrapa gun-nga minypa mu-ngoyurra gun-nerra gu-ni, nipa minypa gu-jarlapurda barrwa barra gun-molamola gu-ji barra. Wurra nipa an-nga nula mu-jurra gu-yurra janguny, ya, gun-gata minypa an-guna An-walkurpa An-gugaliya ngoyurra aburr-yerryerrmiya barra nula rrapa gun-nerra gu-ni barra nula? Gurda an-nga nula janguny, ya? ");
INSERT INTO bvr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Wurra jarra ngaypa ngu-weya ana-gorrburrwa nipa an-gata gipa ana-bona. Nipa ganyjarr gu-rrimarra gun-maywapa minypa Yiláyja, wurra gu-galiya yerrcha aburr-yinagata nula birripa aburr-yinmiyana jal aburr-ni, minypa mu-jurra gu-yurra janguny mu-ngoyurra a-ngurrjinga.” ");
INSERT INTO bvr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ganapiya, lika gun-gatiya birripa aburr-bona gurda burrwa aburr-werranga Jesus burr-yika jawina, wurra burrbi-nana wurra gama gorlk gatiya, wurra minypa birripa joborr marn․gi aburr-gunega ngarndarrk ngarndarrk burrbi-negarra Jesus burr-yika jawina. ");
INSERT INTO bvr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Wurra gun-gatiya waypa wurra gama gorlk abi-nana Jesus, birripa burr-guya aburr-marrkapchinga nula. Lika aburr-yurtchinga, abi-rrimarra, ngardawa marrnguwa aburr-ni nula. ");
INSERT INTO bvr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Lika Jesus burr-wengganana aburr-yigipa jawina, a-yinanga burrwa, “Gun-nga nula ngarndarrk ngarndarrk nyiburr-negiyana nyiburr-ni ana-goyburrpa rrapa aburr-guna joborr marn․gi aburr-gunega?” ");
INSERT INTO bvr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Lika aburr-gata aburr-jinyja, an-ngardapa an-gugaliya a-wena, “Bunggawa, a-lay, ngaypa nguna-ganyja an-ngaypa an-walkurpa nginyipa nggula ngardawa nipa walkwalk a-rrimanga rrapa gala a-wengga a-workiya. ");
INSERT INTO bvr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Rrapa nipa wolawola a-burnda a-workiya, gu-jel a-yerrnyjinga, rrapa mun-bordich ana-ngana m-beya, rrapa rrirra gu-banga, rrapa an-jarrarderta a-nirrapa a-workiya. Wurra ngaypa nguburr-wengganana aburr-nginyipa jawina, jimarna barra birripa walkwalk abi-yerrnyja nula, wurra gala aburr-yinmiyarna.” ");
INSERT INTO bvr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Wurra Jesus a-wena burrwa aburr-gata, “Ana-goyburrpa nyiburr-gurdiya gorlk nyiburr-werra, ngarla! Wurra yama marr nyiburr-balcha nula Wangarr? Ngaypa gu-yinmiyapa ngaypa arr-ga barra rrapa marr ng-ga barra ana-gorrburrwa? Wurra bubu-ga gurda apula an-gata.” ");
INSERT INTO bvr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Lika birripa abu-ganyja gurda nula an-gata an-delipa. Lika gun-gatiya nipa walkwalk ana-nyala a-nana Jesus, lika warrika walkwalk a-buna an-gata delipa, lika nipa gatiya a-bungguna gu-jel rrapa a-jorrpiyana a-ni rrapa mun-bordich ana-ngana m-bena mu-yu. ");
INSERT INTO bvr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Lika Jesus a-yinanga nula an-jirrpungapa, “A-lay, an-guna gu-yinmiyapa walkwalk a-ni nula?” Nipa a-yinagata, “Minyja a-yinagata an-delipa a-ni; ");
INSERT INTO bvr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","a-burndapa a-bunggiya a-workiya gu-bol rrapa gu-bugula, jimarn jarra gun-nyagara gu-ni. Wurra minyja nginyipa nyjirri-borrwa rrapa ny-junggaja atila, minyja nginyipa ganyjarr n-dimanga.” ");
INSERT INTO bvr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“Ngaw. Wurra an-nga nula nginyipa ny-yinagata ny-yena ‘minyja nginyipa ganyjarr n-dimanga’? Wurra jarra minyja nginyipa marr ny-balcha, an-guna a-molamiya barra.” ");
INSERT INTO bvr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Wurra an-jirrpungapa a-garlmunapa a-gonyjinga, “Ngaw, ngaypa marr ngu-balcharra! Wurra gunggaja apula barra ngaypa burr-guya marr ngu-balcha!” ");
INSERT INTO bvr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Lika gu-gata wenga Jesus burr-nana wurra gama gorlk gu-ngardapa aburr-yurtchinga gurda. Lika nipa burr-guya a-wena nula walkwalk, “Ny-junarda ganapa an-narda nganagobaguba rrapa gerna nega! Ngaypa ngu-weya, ngarla, an-narda bawa, nyina-bengga! Gala barra mola ny-barrnguma nula an-narda!” ");
INSERT INTO bvr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Lika nipa walkwalk a-gonyjinga, a-garlmunapa a-bunapa, lika ana-bena. Lika an-gata delipa a-bunggunapa a-jorrpiyana a-ni, rrapa barrwa a-garlmunapa a-nyarlchinga. Lika aburr-jaranga wurra gama gorlk aburr-gata abi-nana, aburr-yinanga, “A-lay, an-narda a-juwuna!” ");
INSERT INTO bvr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Wurra Jesus a-garlmuna, mernda a-jirra a-menga, a-jarrkarrana, lika nipa delipa a-garlmuna. ");
INSERT INTO bvr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Lika nuwurra waypa Jesus rrapa aburr-yigipa jawina aburr-barrngumurra gu-bala ngardapa aburr-ni, lika abu-wengganana. “A-lay, an-nga nula ngayburrpa nyiburr-barparpuna, jimarn jarra walkwalk nyibi-yerrnyjingarna?” ");
INSERT INTO bvr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Lika nipa a-yinanga, “Minyja gun-ngardapa. Minypa Wangarr nyibu-wenggana, lika nuwurra an-gata walkwalk nyibi-yerrnyja.” ");
INSERT INTO bvr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Gu-gata wenga Jesus rrapa aburr-yigipa jawina gubu-bawuna gun-gata rrawa, aburr-bamuna, Galali (Galilee) yongun aburr-bamuna. Jesus gala jal a-nirrarna wurra gama gorlk barra gubu-borrwa nipa yina an-gaya, ");
INSERT INTO bvr_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ngardawa aburr-yigipa jawina nipa a-wena burrwa aburr-bamuna ngardapa. A-yinagata burrwa, “An-guna An-walkurpa An-gugaliya abi-rrima barra, rrapa burrbu-wu barra gu-galiya yerrcha abu-bu barra. Wurra gu-gata wenga ngorrngurra abirri-jirrapa gun-ngardapa lika a-molamiya barra.” ");
INSERT INTO bvr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Jesus a-yinagata a-wena burrwa, wurra gun-narda janguny gala gubi-rrimangarna. Wurra aburr-gurkuja rrapa gala aburr-yinmiyarna abu-wengganacharna gun-gata an-nga nula. ");
INSERT INTO bvr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Aburr-bamuna, gata Gapárniyam (Capernaum) aburr-bena rrawa. Lika nuwurra waypa gun-gata aburr-barrngumurra wupa gu-bala, lika Jesus a-wena burrwa aburr-yigipa jawina, “A-lay, an-nga ana-goyburrpa nyiburr-wena gurda nguburr-bamuna?” ");
INSERT INTO bvr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wurra birripa bamawa aburr-ni; gala aburr-weyarna. Ngardawa gipa aburr-bamuna gurda, aburr-wena aburr-ni birripa ana-nga wana a-ni. ");
INSERT INTO bvr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Lika Jesus a-rakaja, a-gonyjinga burrwa aburr-yigipa 12 gu-galiya yerrcha, lika a-wena burrwa a-ni. A-yinagata, “Minyja ana-nga barra wana a-ni, burdak mu-ngoyurra an-delipa a-ni, an-mujama burrwa aburr-jaranga.” ");
INSERT INTO bvr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","A-yinagata a-wena, lika an-gurrepara an-delipa a-menga, a-garrana gojilapa a-jinyja aburr-yigipa jawina gatiya. Lika ana-murna a-jarrkarrana, a-ngurrgujinga, lika a-yinagata burrwa, ");
INSERT INTO bvr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Minyja ana-nga an-mola nula ana-guna ngacha delipa ngardawa ngaypa ngu-welangga, minypa ngaypa jal ngu-nirra nula delipa, an-gata an-gugaliya nipa ngardawa an-mola apula ngaypa. Rrapa minyja ana-nga an-mola apula ngaypa, gun-narda minypa ngaypa ngardapa ngika, wurra nipa nguna-jerrmarrapa burr-guta an-mola atila.” ");
INSERT INTO bvr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Lika Jon a-wena nula Jesus, “Bunggawa, a-lay, ngayburrpa nyibi-nana an-ngardapa an-gugaliya walkwalk a-yerrnyjinga burrwa minypa nipa biy-menga nginyipa ny-yelangga, wurra ngayburrpa nyiburr-wena nula gala a-yinmiya a-yinarda, ngardawa nipa gala wugupa arrburrwa ngayburrpa nguburr-guna.” ");
INSERT INTO bvr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Wurra Jesus a-yinagata, “Gala barra an-gata nyibu-jobujoba. Wurra ana-nga minypa ngaypa ngu-welangga nguna-ngurrjinga rrapa burr-barlmarrk jama a-jirra, nipa gala a-yinmiya yibirrich ngu-werra nguna-ngurrja. ");
INSERT INTO bvr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Minyja ana-nga gala an-bachirra arrburrwa, nipa jarra an-gata a-gunggajinga arrburrwa. ");
INSERT INTO bvr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Gun-guna ngu-weya ana-gorrburrwa gun-burral: Ny-yinga ny-jata minyja ana-nga biy-wu bugula barra ny-bay ngardawa ngaypa ngu-welangga marr a-balcharra apula, rrapa minypa nipa gu-borrwurra nggula Christ biy-yika, an-gata an-gugaliya nipa Wangarr ana-nyala a-wu barra, ngarla, gun-molamola gu-ma barra gun-nigipa minypa gun-gata nipa an-mola a-ni nggula. ");
INSERT INTO bvr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Wurra ana-guna ngacha delipa minypa marr a-balcharra apula, ana-nga an-nerranga a-yinmiyan rrapa nipa delipa a-lijiwarriyan, wurra jimarn jarra an-gata an-gugaliya mu-ngoyurra abu-bichingarna gu-jandarra wana gu-bapala, lika abi-yerrnyjingarna gu-bachirra. Gu-gurda ngacha minypa nipa mari gu-manggarna marr gu-yinanga wana, wurra gun-gata minypa Wangarr ana-nyala a-bu barra minypa delipa a-warganyja, gun-narda jarra minypa burr-guya gun-nerra gu-ni barra nula an-gata an-gugaliya. ");
INSERT INTO bvr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“Rrapa nginyipa minyja murna ny-jirra nyi-guyinda gun-nerra jama ny-jirra ny-yorkiya, ny-junarda murna ny-jirra ny-nyardapa gorndiya barra ny-nyagara nyi-ni. Ngardawa gun-mola nggula barra nginyipa ny-nyurrnga wanngu nyi-ni wuriya murna ny-jirra ny-nyardapa. Gala yapa ny-bamba, wurpa niya murna ny-jirra ny-jilirrwirrka, wurra minypa yi-gata ny-boga gun-nelangga Hell, gatiya gu-bol gu-rronggapa gu-jirra gu-workiya rrapa gala ana-nga gu-jupa. ");
INSERT INTO bvr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","“Rrapa minyja rrepara ny-jirra gun-nerra jama ny-jirra ny-yorkiya, ny-junarda rrepara ny-jirra ny-nyardapa gorndiya barra ny-nyagara nyi-ni. Ngardawa gun-mola nggula barra nginyipa ny-nyurrnga wanngu nyi-ni, wuriya ny-burda. Gala yapa ny-bamba, wurpa niya rrepara ny-jirra ny-jilirrwirrka, wurra minypa Wangarr yi-gata biy-yerrnyjin gun-nelangga Hell. ");
INSERT INTO bvr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Rrapa minyja mipila ny-jirra gun-nerra jama ny-jirra ny-yorkiya, ny-junarda mipila ny-jirra nyina-warrka. Ngardawa gun-mola nggula barra nipa ana-murna nyi-ni Wangarr, wuriya mipila ny-jirra ny-nyardapa. Gala yapa mipila ny-jirra ny-jilirrwirrka ny-bamba, barrwa minypa Wangarr biy-yerrnyjin yi-gata gun-nelangga Hell, ");
INSERT INTO bvr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","gatiya ‘bonga ana-guyinda burr-bangapa, rrapa gu-bol gu-guyinda aburr-rronggapa aburr-jirra.’ ");
INSERT INTO bvr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Ngardawa Wangarr gun-nerra gun-guyinda gu-yalpa barra arrkula arr-gurdiya gorlk, minypa gun-maywapa ranginy junggay an-guyinda jin-garla jiny-yalpurda nula a-workiya Wangarr, wurra burdak mu-ngoyurra jorlp (salt) mu-gurrmunga a-workiya rrapa jin-molamola jinyu-nenga. ");
INSERT INTO bvr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Minyjiya. Jorlp mun-molamola. Wurra minyja jorlp mu-ngukurdanyjiya rrapa mun-nerra mu-ni, gala ny-yinmiya ny-jarlapa, barrwa mun-bachirra mu-ni. Wurra ana-goyburrpa nyiburr-yirda barra minypa jin-maywapa jin-gata jin-garla gipa jorlp mbi-gurrmurra; nyiburr-molamola buburr-ni rrapa minypa magaya bubi-nega ana-gorrburrwa buburr-workiya.” ");
INSERT INTO bvr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Gu-gata wenga Jesus a-garlmuna, a-bona gun-gata Judíya (Judea) rrapa gu-gapa gu-rrarnba man․garba gun-gata gun-nelangga Jordan. Rrapa mola wurra gama gorlk aburr-garlmuna gurda, gu-ngardapa aburr-negiyana nula, lika janguny marn․gi burr-negarra a-bona minypa wolawola marn․gi burr-negarra a-workiyana. ");
INSERT INTO bvr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Wurra Berachi (Pharisee) yerrcha aburr-bona gurda nula Jesus, lika aburr-ngunyangunyjiyana, jal aburr-ni barra abu-yolka. Minypa abu-wengganana, “A-lay, minyja gun-mola nula an-gugaliya jiny-bawa jin-nigipa jin-gumarrbipa niya, ya?” ");
INSERT INTO bvr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Wurra Jesus a-wena burrwa, a-yinanga, “Wurra Mojich (Moses) a-yinmiyana nyirr-wuna ana-goyburrpa joborr, ya?” ");
INSERT INTO bvr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Birripa aburr-yinagata, “Minyja Mojich a-wena gun-mola nula an-gugaliya jin-nigipa jin-gumarrbipa niya jiny-bawa, minypa mu-ngoyurra jurra mu-guyinda a-wukurrja barra achila, lika nuwurra jurdach jiny-bawa.” ");
INSERT INTO bvr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus a-yinagata burrwa, “Wurra gun-narda Mojich a-wukurrjinga ana-gorrburrwa ngardawa mun-molma mun-derta mun-gorla ana-gorrburrwa. ");
INSERT INTO bvr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Wurra gun-gatiya mu-ngoyurra Wangarr gu-jarlapuna gurdiya rrawa, ‘nipa bijirriny-jarlapuna an-nurra rrapa jin-gama’. ");
INSERT INTO bvr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Gu-gurda ngacha janguny rrapa gu-gurda nula ‘an-gugaliya bijirriny-bawa barra nyanyapa niya rrapa mampa niya, jin-nigipa jin-gumarrbipa niya barra jiny-ma, ");
INSERT INTO bvr_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","lika birrinyjipa abirriny-nyardapa abirrinyu-ni barra.’ Gu-gurda ngacha minypa birrinyjipa gala barrwa ngardapa ngardapa, wurra jarra gun-nardiya gugu abirriny-nyardapa. ");
INSERT INTO bvr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Lika ganapiya. Gala barra ana-nga bijirriny-nyorrkornda; wurra jarra Wangarr bijirriny-mulpuna gu-ngardapa.” ");
INSERT INTO bvr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nuwurra waypa Jesus rrapa aburr-yigipa jawina aburr-barrngumurra gu-bala, birripa abu-wengganana gun-gata janguny nipa a-wena. ");
INSERT INTO bvr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Lika nipa a-yinagata burrwa, “Minyja an-gugaliya jiny-bawa jin-nigipa jin-gumarrbipa rrapa jin-nerranga jiny-ma, gun-narda minypa birrinyjipa abirriny-jata gun-nerra jama abirriny-jirra, rrapa an-gata an-gugaliya nipa minypa werra jinyu-nengapa jin-gata mu-ngoyurra jiny-malapuna a-ni. ");
INSERT INTO bvr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Rrapa minyja jin-gugaliya a-bawa an-nigipa an-gumarrbipa rrapa an-nerranga a-ma, gun-narda minypa birrinyjipa abirriny-jata gun-nerra jama abirriny-jirra.” ");
INSERT INTO bvr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Gun-gatiya lika aburr-werranga rrapa delipa delipa yerrcha burrbu-ganyja gurda nula Jesus barra nipa bin-dima minypa burr-jalkaka; wurra aburr-yigipa jawina burrbu-jobujobuna aburr-gata. ");
INSERT INTO bvr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Wurra gun-narda Jesus gu-nana, lika nipa minypa gochila a-rronga rrapa a-yinanga burrwa aburr-yigipa jawina, “Burrbu-bawa gu-ngarda yerrcha barra aburr-boy gurda apula! Ganapa burrbu-jobujoba! Ngardawa Wangarr burr-barlmarrk jama a-jirra burrwa a-nirra aburr-yigipa gu-galiya yerrcha aburr-gatiya minypa aburr-gurda delipa delipa yerrcha. ");
INSERT INTO bvr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Gun-guna ngu-weya ana-gorrburrwa gun-burral: Gala ana-nga an-gugaliya Wangarr ana-murna a-ninya, wurra minyja a-ngukurdanyjiya rrapa a-ni minypa aburr-guna delipa delipa yerrcha.” ");
INSERT INTO bvr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Lika gu-ngarda yerrcha burr-menga, burr-ngurrgujinga rrapa bin-dimarra a-bona, aburr-molamola burr-negarra. ");
INSERT INTO bvr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Lika gun-gatiya Jesus a-garlmuna a-ji jimarna barra a-boy, wurra an-ngardapa an-gugaliya ana-yurtchinga, ana-menama gu-rrana nula, lika a-wengganana, “Bunggawa, a-lay, nginyipa ny-molamola marn․gi nyi-gunega, ngaypa ngu-yinmiya barra jama ngu-ji minypa wanngu ngu-nipa barra ngu-workiya Wangarr ana-murna?” ");
INSERT INTO bvr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Wurra Jesus a-wena, “An-nga nula nginyipa nguna-ngurrjinga ngaypa ngu-molamola? Minyja gala ana-nga an-molamola, wurra jarra nipa wupa Wangarr. ");
INSERT INTO bvr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Wurra nginyipa marn․gi joborr gun-guyinda: Minypa gala barra ny-bu, a-juwa, rrapa gala barra jin-ngumurda ny-ma ana-werranga jin-nika, rrapa gala barra mun-ngumurda ny-ma, rrapa gala barra an-nerranga bima ny-nyurrja, rrapa gala barra an-nerranga mun-nika ny-jaypa, wurra jarra marr balcha burrinyjula mampa nggu rrapa nyanyapa nggu.” ");
INSERT INTO bvr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nipa an-gugaliya a-yinagata, “A-lay, gipa mu-ngoyurra ngaypa ngu-balgurla ngu-ni, gu-gurda ngacha ng-galiyana rrapa ngu-borrwuja ngu-nirra.” ");
INSERT INTO bvr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Lika Jesus a-nana an-gata an-gugaliya rrapa a-marrkapchinga nula. A-yinagata nula, “A-lay, mola gun-ngardapa gun-gata nginyipa barra ny-yinda. Minyja boy, gun-nginyipa gorlk ma, burr-wu, rrapa rrupiya ma burrwa aburr-gata aburr-nyagara; burraya nginyipa gun-molamola ny-ma barra gun-gaba waykin. Wurra guwa, nguna-jurrjurrma.” ");
INSERT INTO bvr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Gun-narda a-galiyana, lika an-gata an-gugaliya garla a-darrjinga, lika wargugu a-ni a-jekarra a-bamuna. Ngardawa nipa wana gun-jaranga gorlk gu-rrimarra. ");
INSERT INTO bvr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Lika Jesus burr-nana a-gomarriyana a-yu aburr-yigipa jawina, lika a-yinagata burrwa, “A-lay, aburr-gata minypa gorlk gun-jaranga gubi-rrimanga, birripa burr-guya gun-derta burrwa rraka aburr-galiya nula Wangarr rrapa nipa ana-murna aburr-ni.” ");
INSERT INTO bvr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wurra aburr-yigipa jawina gochila aburr-barrjinga gun-gata Jesus a-wena burrwa, wurra barrwa a-wena burrwa, “A-lay, gu-ngarda yerrcha, nipa burr-guya gun-derta nyiburr-gurdiya gorlk barra Wangarr ana-murna nyiburr-ni! ");
INSERT INTO bvr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Minypa niyal (needle) rralala a-maya a-jirra an-gata nganaparra gala a-yinmiya a-barrnguma, gu-gurda ngacha minypa an-gugaliya gorlk gun-jaranga gu-rrimanga gala a-yinmiya a-galiya nula Wangarr rrapa nipa ana-murna a-ni.” ");
INSERT INTO bvr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Gun-gatiya lika aburr-yigipa jawina mu-nguy gochila aburr-barrjinga rrapa minypa aburr-wengganachichiyana aburr-bona, “A-lay, gun-derta gun-gorla janguny, ngarla! Wurra ana-nga barra wanngu a-ni?” ");
INSERT INTO bvr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus burr-nana, lika a-yinagata, “A-lay, wurra gama gorlk gala aburr-yinmiya, wurra jarra Wangarr gun-molamola nula; gala gun-nga gun-derta nula Wangarr.” ");
INSERT INTO bvr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Lika Birta a-garlmuna, a-wena nula. “A-lay, ngayburrpa nyibu-bawuna gun-jaranga rrapa nyiburr-guna bubu-jurrjurrmunga.” ");
INSERT INTO bvr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesus a-yinagata, “Gun-guna ngu-weya ana-gorrburrwa gun-burral: Ana-nga minypa gu-bawa gun-nigipa rrawa balaja gu-murna mu-rrimanga burr-guta, o minypa burr-bawa worlapa niya, jelapa niya, mampa niya, nyanyapa niya, rrapa gu-ngarda yerrcha burr-bawa minypa an-gata an-ngaypa rrapa gun-ngaypa janguny gu-ngurrjinga a-boya, ");
INSERT INTO bvr_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nipa an-gata an-gugaliya gun-guniya gu-ma barra mola rrawa gun-jaranga balaja mu-murna mu-rrimanga burr-guta, rrapa burr-ma barra worlapa niya yerrcha, jelapa niya yerrcha, mampa niya yerrcha, rrapa gu-ngarda yerrcha burr-ma barra minypa aburr-jaranga aburr-borrmunga; wurpa niya mari gu-bengga barra nula, aburr-werranga gubi-jarlapa barra. Wurra gun-gata jurdach guna-bamburda wanngu a-nipa barra a-workiya. ");
INSERT INTO bvr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","“Wurra aburr-jaranga aburr-gata minypa mu-ngoyurra aburr-jirra, birripa barra jurdach aburr-ji; rrapa aburr-gata minypa jurdach aburr-jirra, birripa barra mu-ngoyurra aburr-ji.” ");
INSERT INTO bvr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesus birripa gu-jarlakarr aburr-bamuna, aburr-warrcha aburr-bamuna Jirúchalam (Jerusalem). Nipa Jesus mu-ngoyurra a-bamuna burrwa, rrapa birripa jurdach aburr-bamuna gochila aburr-barrjinga ngardawa nipa Jirúchalam burr-ganyja. Rrapa aburr-gata aburr-werranga jurdach burrbu-jurrjurrmurra, birripa rrapa aburr-gurkuja aburr-ni ngardawa gubu-borrwurra Jirúchalam aburr-ni mari gubi-rrimarra nula Jesus. Barrwa Jesus aburr-yigipa 12 gu-galiya yerrcha burr-ganyja ngardapa aburr-ni, nipa lika a-wena burrwa a-ni gu-yinmiya barra gun-nerra gu-ni nula. ");
INSERT INTO bvr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Minypa a-yinanga burrwa, “Ngayburrpa Jirúchalam nguburr-boya, rrapa an-guna An-walkurpa An-gugaliya gatiya abi-rrimapa barra burrbu-wu barra aburr-gata wana junggay yerrcha rrapa joborr marn․gi aburr-gunega. Rrapa birripa mari wana gubu-garra barra nula minypa nipa a-juwa barra. Lika burrbu-wu barra Jentayl (Gentile) yerrcha an-guna. ");
INSERT INTO bvr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Lika gu-gata wenga birripa Jentayl yerrcha abu-borrkpa barra rrapa m-bordich abu-balka barra, rrapa abu-jurrburaykujama barra rrapa abu-bu barra a-juwa. Lika gu-gata wenga ngorrngurra abirri-jirrapa gun-ngardapa, lika a-molamiya barra.” ");
INSERT INTO bvr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Gatiya lika Jeymch (James) rrapa Jon abirri-gata nipa Jebadi (Zebedee) bijirri-bokamurra, bitipa abirri-garlmuna, abirri-wena nula Jesus. “A-lay, Bunggawa, ngatipa jal nyirri-nirra nginyipa barra ny-yinda minypa ngatipa birri-wenggana.” ");
INSERT INTO bvr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nipa a-yinagata butula, “An-nga jal nyirri-nirra barra ngu-yirda ana-gotula?” ");
INSERT INTO bvr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bitipa abirri-yinanga nula, “A-lay, ngaw minyja ny-yengga barra minypa nuwurra waypa bunggawa nyi-ni, ngatipa gatiya wugupa nggula bunggawa arri-ni barra? Minypa nginyipa ny-jera nyirri-ni barra ngguluwa, nyi-munganaguwa rrapa ny-yeyka.” ");
INSERT INTO bvr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Wurra Jesus a-yinagata butula, “Ana-gotipa gala marn․gi gun-nga ngunabirri-wengganacha. Wurra ana-gotipa ganyjarr nyirri-dimanga, ya, minypa ngaypa ngu-rrimanga? Wurra ngaypa jarra ngu-rrimanga ganyjarr ngunabu-bu barra ngu-jortcha. Minypa gun-maywapa ranginy Ngun-anya nguna-wuna mun-guralba mun-gata mu-jerrjerrjinga mernda a-jirra ana-guyinda barra ngu-bay. Rrapa mola minypa gun-maywapa bama nguna-gurragaja gun-gata minypa gun-gujuwa. Wurra ana-gotipa gun-mola gu-gata ngacha nyirri-ma barra, ya?” ");
INSERT INTO bvr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bitipa abirri-yinagata, “Ngaw, gun-mola atila nyirri-ma barra.” Lika Jesus a-yinagata, “Gun-burral ana-gotipa minypa gun-maywapa nyirri-bay barra mun-gata mun-guralba ngaypa ngu-bay barra, rrapa gun-burral Ngun-anya bama nyjirri-gurraga barra gun-gujuwa minypa ngaypa. ");
INSERT INTO bvr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Wurra ngaypa gala ngu-yinmiya ngu-wengga rraka ana-gotipa ng-gera nyirri-ni apula, ny-nyardapa ngu-munganaguwa rrapa ny-yerranga ngu-weyka. Wurra gu-gata ngacha gubirri-ma barra abirri-gata abirri-nga minypa nipa Ngun-anya bijirri-borrwurra rrapa nawanawa a-ni butula.” ");
INSERT INTO bvr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Aburr-werranga Jesus burr-yika jawina yerrcha aburr-gata arr-jirrapa arr-murna, birripa aburr-galiyana gun-gata minypa Jeymch rrapa Jon bitipa wupa abirri-wengganana Jesus, lika birripa minypa aburr-bachirramiyana butula. ");
INSERT INTO bvr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Wurra Jesus a-gonyjinga burrwa, aburr-bona gurda nula, lika nipa a-yinanga a-wena burrwa, “Ana-goyburrpa marn․gi burrwa Jentayl bunggawa an-guyinda, minypa birripa jama wana burrbu-wucha aburr-workiya. Ana-goyburrpa marn․gi burrwa aburr-gata minypa mu-ngoyurra aburr-jirra burrwa Jentayl yerrcha, minypa birripa wana aburr-negiya burrwa aburr-workiya aburr-birripa gu-galiya yerrcha. ");
INSERT INTO bvr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Wurra ana-goyburrpa gala barra nyiburr-yirda ana-gorrburrwa gu-gapa gu-guta. Wurra ana-goyburrpa jarra minyja ny-yinga ny-jata jal nyi-ni wana nyi-ni barra burrwa aburr-guna aburr-werranga, wurra jarra delipa nyi-negiya barra burrwa. ");
INSERT INTO bvr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Minyja jal nyi-ni mu-ngoyurra ny-ji barra burrwa, wurra burdak mu-ngoyurra nyi-mujama nyi-ni barra burrwa. ");
INSERT INTO bvr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ngardawa an-guna An-walkurpa An-gugaliya ana-bona ngika barra wurra gama gorlk aburr-mujama burr-nega, wurra jarra nipa barra an-mujama a-ni burrwa rrapa a-juwa barra minypa barra burr-ma barra gu-galiya yerrcha nuluwa Wangarr.” ");
INSERT INTO bvr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Aburr-bamuna, aburr-bena rrawa gun-nelangga Jerikow (Jericho). Gata lika Jesus rrapa aburr-yigipa jawina gubu-bawuna aburr-bona rrapa aburr-jaranga wurra gama gorlk burrbu-jurrjurrmurra, wurra an-ngardapa an-gugaliya an-gapula gatiya a-ninya gu-jarlakarr gu-rrarnba, nipa an-nelangga Bartaméyach (Bartimaeus), nipa an-walkurpa nula Diméyach (Timaeus) an-nika. ");
INSERT INTO bvr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Gun-gatiya nipa a-galiyana Jesus nipa Nejarach (Nazareth) an-guyinda ana-bamuna, lika nipa a-garlmunapa a-gonyjinga, “A-lay, Jesus, ny-jurnarda nipa Daybit (David) murna biy-wuna arrburrwa, gunggaja apula, a-lay!” ");
INSERT INTO bvr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wurra aburr-jaranga abu-jobujobuna an-gata rrapa aburr-wena nula barra nipa gun-ngap gu-bawa. Wurra nipa mu-nguy burr-guya a-gonyjinga, “A-lay, ny-junarda nipa Daybit murna biy-wuna arrburrwa, gunggaja apula, a-lay!” ");
INSERT INTO bvr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Lika Jesus a-galiyana nula, lika a-wena burrwa, “Buburr-gonyja nula an-gata.” Lika aburr-yinanga nula, “Garlma! Ngika wargugu ni nggula. An-gaba a-gonyjinga nggula a-nirra.” ");
INSERT INTO bvr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Lika nipa garrung mu-yerrnyjinga, burr-guya a-garlmunapa a-bena nula Jesus. ");
INSERT INTO bvr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Lika Jesus ana-nyala a-wengganana, “A-lay, nginyipa jal nyi-nirra ngaypa ngu-yinmiya barra nggula?” Wurra nipa an-gapula a-yinanga, “A-lay, Bunggawa, ngaypa jal ngu-nirra ng-gana barra.” ");
INSERT INTO bvr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Lika Jesus a-wena nula, “Boy. Wurra nginyipa ngardawa marr ny-balcha apula gipa ny-molamiyana.” A-yinagata Jesus a-wena nula, gugu nipa Bartaméyach a-ganana, lika a-jurrjurrmurra Jesus. ");
INSERT INTO bvr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Gun-gatiya Jesus rrapa aburr-yigipa jawina yerrcha aburr-bamuna gurda yi-gurrepa Jirúchalam (Jerusalem), birripa aburr-bena mu-mirk mun-gata mun-nelangga Alip (Olive) Mu-jirrapa rrapa gun-murna rrawa gu-jirra gun-gata Betpey (Bethphage) rrapa Bechini (Bethany). Lika Jesus bijirri-jerrmarra abirri-yigipa jawina abirri-jirrapa, ");
INSERT INTO bvr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","a-yinanga butula, “Birri-boy gun-gata rrawa mu-ngoyurra guna-jirra. Gun-nardiya gugu nyirri-barripa barra dongki (donkey) an-delipa a-bandawiya a-jirra, gala ana-nga a-warrchingarna a-workiyarna. Lika ana-gotipa birri-yarlayarlawa nula, lika birri-ga gurda ay-ngunyunaga. ");
INSERT INTO bvr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Rrapa minyja ana-nga nyjirri-wenggana an-nga nula nyirri-menga, wurra ana-gotipa birri-wengga nula, ‘Bunggawa jal a-nirra nula an-guna rrapa nuwurra ana-jerrma barra nggula.’” ");
INSERT INTO bvr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ganapiya. Lika abirri-bona, abirri-barripuna gu-jarlakarr a-jinyja, gu-bala ngana gu-jirra gu-guyinda a-bichiyana a-ji. Lika gatiya waypa bitipa mbirri-yarlayarlawurra nula abirri-ni murndurn, ");
INSERT INTO bvr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","aburr-werranga aburr-jinyja birripa burrbu-wengganana, “An-nga nula nyirri-yarlayarlawuja nula nyirri-nirra an-narda dongki?” ");
INSERT INTO bvr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wurra bitipa abirri-wena burrwa gun-gata geka nipa Jesus a-wenapa butula, lika aburr-gata gu-galiya yerrcha burrbu-bawuna. ");
INSERT INTO bvr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Lika bitipa an-gata dongki abirri-ganyja gurda nula Jesus, lika mun-bitipa molma mun-gunegiya mirikal ana-jonama dongki mbirri-gurrmurra, lika Jesus a-warrchinga. ");
INSERT INTO bvr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Rrapa aburr-jaranga wurra gama gorlk mbi-yarlanggaja nula aburr-bona gu-jarlakarr minypa mun-birripa molma mun-gunegiya mirikal, barra minypa an-gata dongki mu-rrenyja a-bamba rrapa nipa Jesus waykin ana-jonama. Rrapa aburr-werranga jarlawurr gubu-rrumurra, lika gubi-yarlanggaja nula. ");
INSERT INTO bvr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Aburr-gata minypa mu-ngoyurra aburr-bamuna rrapa aburr-werranga jurdach aburr-bamuna gurda, birripa aburr-gonyjinga aburr-bamuna, “Japurra ngapa a-jirra! Wangarr barra gun-molamola gu-nega barra nula an-guna nipa ana-jerrmarra! ");
INSERT INTO bvr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Gun-molamola nguburr-ni barra minypa wola a-wena nula an-ngayburrpa nyanyapa arrburra Daybit (David)! Rrapa waykin aburr-guyinda, birripa an-molamola abu-ngurrja barra Wangarr!” ");
INSERT INTO bvr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Aburr-bamuna, aburr-bena Jirúchalam. Lika Jesus a-bona, a-barrngumurra Wangarr gun-nika gun-japurra rrawa. Lika gu-nana a-bona, wurra warrika yi-rrana gu-ni, lika nipa rrapa aburr-yigipa jawina aburr-jekarra rrawa Bechini. ");
INSERT INTO bvr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Aburr-yu, guna-gepana, lika aburr-garlmuna, aburr-jekarra gurda Jirúchalam. Gojilapa aburr-bamuna gurda, lika Jesus a-werrmiyana balaja. ");
INSERT INTO bvr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Lika gu-balay wenga gu-nana gun-jong balaja mu-rrimanga mu-workiya mun-nelangga wagarrich, nipa birlapirla mu-rrimarra. Lika nipa a-jarl a-bamuna, jimarna barra balaja m-barripa, wurra mu-nana mun-nyagara, wurra jarlawurr wupa mu-ji, nuwurra jurdach balaja mu-rrima. ");
INSERT INTO bvr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Lika a-wena nula gun-gata gun-jong. “Ny-jurda gala ny-yinmiya barrwa balaja biy-rrima rraka an-gugaliya m-bay.” Jesus a-yinagata a-wena nula mun-gata gun-jong mun-nelangga wagarrich, rrapa aburr-yigipa jawina aburr-galiyana nula. ");
INSERT INTO bvr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Gu-gata wenga aburr-bamuna gurda, aburr-bena Jirúchalam. Lika Jesus a-bona, a-barrngumurra Wangarr gun-nika gu-japurra rrawa. Lika a-garlmunapa burr-yerrnyjinga a-ni aburr-gata minypa bayim aburr-ni rrapa jalim aburr-ni gatiya. Minypa aburr-werranga aburr-gatiya rrupiya mbi-ngukurdanyjinga aburr-workiyana burrwa wurra gama gorlk, nipa gu-yerrnyjinga burrwa gun-birripa belabila burr-rrupiya burr-guta. Rrapa aburr-werranga aburr-gata minypa mukumul jalim aburr-ni, barrwa nipa gu-yerrnyjinga burrwa gun-gata gun-birripa gun-gurrenyja gun-guni. ");
INSERT INTO bvr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Rrapa minypa aburr-werranga aburr-barrngumurra aburr-yu gun-gata rrawa gu-japurra aburr-bamiyana aburr-bona borijipa, wurra Jesus burr-jobujobuna. ");
INSERT INTO bvr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Rrapa nipa waypa marn․gi burr-negarra a-ni, nipa a-yinanga burrwa, “Ana-goyburrpa gala nyibu-borrwa, ya, jurra mu-guyinda gu-yurra janguny? Minyja gun-narda Wangarr a-wena, a-yinanga, ‘Gun-ngaypa bala gubu-ngurrja barra aburr-workiya wurra gama gorlk, aburr-yinda barra, “Gun-gata gu-bala aburr-jaranga aburr-bapurr abu-wengganacha aburr-workiya.” ’ Gu-yinagata gu-yurra janguny, wurra ana-goyburrpa werra nyibi-negarra nula gun-nigipa bala, ngunyuna gu-galiya yerrcha nyirrbu-gaypurda nyiburr-workiya, jalim nyiburr-nirra burrwa nyiburr-workiya.” ");
INSERT INTO bvr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Gun-narda nipa Jesus a-wena, birripa aburr-gata wana junggay yerrcha rrapa joborr marn․gi aburr-gunega aburr-galiyana, lika aburr-garlmunapa gubu-borrwurra aburr-ni aburr-yinmiya barra Jesus abu-bu. Ngardawa birripa aburr-gurkuja nula, ngardawa wurra gama gorlk aburr-marrkapchinga nula gun-nigipa janguny. ");
INSERT INTO bvr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Gun-gata lika yi-rrana gu-ni, Jesus rrapa aburr-yigipa jawina gubu-bawuna gun-gata gu-murnangana rrawa, lika aburr-bona barra aburr-yu. ");
INSERT INTO bvr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Lika nuwurra guna-gepana mola aburr-bamuna gurda, rrapa mbi-nana mun-gata gun-jong mun-nelangga wagarrich mu-garlmunapa mu-gorlapuna burr-bama burr-rrepara. ");
INSERT INTO bvr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Lika Birta gu-borrwurra, lika a-wena nula Jesus, “A-lay, Bunggawa, minyja gun-gata na, gun-jong yi-rrawa nginyipa ny-yeya nula nyi-nirra mu-garlmiyapa mu-gorlapurda, ngarla!” ");
INSERT INTO bvr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesus a-yinanga nula, “Marr balcha nula Wangarr. ");
INSERT INTO bvr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ngaypa gun-burral ngu-weya nggula: Minyja ana-nga a-wengga nula mun-guna mun-mirk rrapa a-yinda nula, ‘Garlma! Boy, yerrnyjiya gu-bugula gu-bachirra,’ rrapa minyja an-gata an-gugaliya gala a-barrjejiga, wurra burr-guya marr a-balcha, lika gu-yinardiya barra; Wangarr jama a-ji barra nula rrapa mun-gata mun-mirk mu-yerrnyjiya barra gu-bugula gu-bachirra. ");
INSERT INTO bvr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","“Gun-narda ngardawa gun-burral, lika ngaypa ngu-wengga barra ana-gorrburrwa gun-guna: minyja ana-goyburrpa gun-nga nyibu-wenggana Ngun-anya waykin a-nirra, marr buburr-balcha nula minypa gipa nipa nyirr-wuna, lika nyibu-ma barra. ");
INSERT INTO bvr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Wurra gun-gatiya minypa nyibu-wengganacha nyiburr-nirra rrapa an-gata an-gugaliya minyja a-yinmiyana werra biy-negarra, wurra nginyipa baywarra nega nula barra nipa Nyanyapa arrku rrapa baywarra gu-nega nggula nginyipa ny-yinmiyana werra nyi-negiyana nula.” ");
INSERT INTO bvr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Aburr-bamuna, barrwa aburr-bena Jirúchalam, lika aburr-barrngumurra Wangarr gun-nika gu-japurra rrawa. Lika gatiya Jesus a-bamuna, aburr-werranga aburr-bona gurda nula — aburr-gata wana junggay yerrcha rrapa joborr marn․gi aburr-gunega, rrapa barrwa aburr-werranga mu-murna yerrcha. ");
INSERT INTO bvr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Birripa aburr-yinanga nula, “Ana-nga a-wena nggula gu-gurda ngacha jama ny-jirra?” ");
INSERT INTO bvr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Wurra Jesus a-yinagata burrwa, “Ngaypa burdak arr-wenggana barra gun-ngardapa nyibu-ngurrja apula, nuwurra waypa jurdach ngaypa ngu-ngurrja barra ana-gorrburrwa ana-nga nguna-wuna ganyjarr ngaypa jama ngu-jirra. ");
INSERT INTO bvr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Marrka bubu-ngurrja apula, ana-nga a-wuna Jon gun-gata bama gun-gugurraga nipa bama burr-gurragaja a-workiyana? Nipa Wangarr wurra waygaji an-gugaliya, ya?” ");
INSERT INTO bvr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jesus a-yinagata a-wena burrwa, wurra birripa aburr-garlmunapa aburr-wengganachichiyana birripa wupa, minypa aburr-yinanga, “A-lay, ngayburrpa nguburr-yinmiya barra? Minyja gala yapa nguburr-yindin, ‘Wangarr a-wuna bama gun-gugurraga nipa Jon.’ Gala yapa nipa an-guna a-yindin arrburrwa, ‘An-nga nula rrapa ana-goyburrpa gala marr nyiburr-balcharna nula?’ ");
INSERT INTO bvr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Wurra gala barra nguburr-yinda, ‘An-gugaliya a-wuna bama gun-gugurraga gun-gata.’ Gala yapa aburr-gata gu-galiya yerrcha aburr-bachirramiyan arrburrwa. Ngardawa birripa gubu-borrwurra, jimarna bama aburr-yinaga Jon a-wena a-workiyana Wangarr gun-nika.” ");
INSERT INTO bvr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Lika aburr-gata wana junggay yerrcha rrapa joborr marn․gi aburr-gunega, rrapa barrwa aburr-werranga mu-murna yerrcha, birripa aburr-yinagata nula Jesus, “Gala ngayburrpa marn․gi.” Lika Jesus a-wena burrwa, “Rrapa ngaypa gala ngu-yinmiya ngu-wengga ana-gorrburrwa ana-nga nipa a-wena ngaypa jama ngu-jirra.” ");
INSERT INTO bvr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Gatiya lika Jesus a-garlmuna, meyali gu-murna a-wena burrwa a-ni. Minypa a-yinanga, “An-gugaliya, ngarla, a-lamajinga, nipa mun-gata gurnal mun-murra mu-jinyja. Lika nipa jandarra gu-gurrmurra, gu-ji gu-gomarriyana; rrapa rralala gu-jarlapuna gu-jandarra gu-guyinda, barra minypa mbi-birlkaka mun-gata gurnal rrapa gatiya mbi-ma mun-gata mun-girra. Rrapa barrwa nipa gu-jarlapuna gun-baykardakarda gu-jinyja minypa dawa (tower), barra minypa mbi-na aburr-ji gurnal, gala yapa mun-ngumurda m-boy burrwa. Ganapiya, lika burr-menga gu-galiya yerrcha barra rrawa aburr-ni rrapa jaga aburr-gana mun-gata gurnal. Lika nipa rrawa an-gurrimapa gu-bawuna a-bona balay, nuwurra waypa gu-yinpa ana-jeka. ");
INSERT INTO bvr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Ganapiya, lika gu-bamuna, mun-gata gurnal mun-mola mu-ni barra birripa mbi-ma. Lika an-gata an-gurrimapa an-nigipa an-mujama an-ngardapa ana-jerrmarra burrwa aburr-guna jaga aburr-ganana mun-gata gurnal, jimarn jarra birripa aburr-guna mbi-ngorrkorndangarna aburr-nirrarna, lika mbi-jerrmangarna nula mun-nigipa nipa an-gata an-gurrimapa. ");
INSERT INTO bvr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Wurra aburr-guna jaga aburr-ganana mun-gata gurnal, an-gata an-mujama birripa abi-rrimarra, abu-buna, lika abi-jerrmarra, a-jekarra a-bona, gala mun-nga gurnal mu-ganyjarna. ");
INSERT INTO bvr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Lika an-gata an-gurrimapa barrwa ana-jerrmarra an-nerranga an-nigipa an-mujama, wurra aburr-guna jaga aburr-ganana gurnal, birripa abu-buna bama a-jirra rrapa werra abi-negarra. ");
INSERT INTO bvr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","“Rrapa an-gurrimapa barrwa ana-jerrmarra, wurra birripa abu-buna, a-juwuna. Nipa an-gata aburr-jaranga nipa burr-jerrmarra gurda, wurra birripa aburr-guna burrbu-buna aburr-workiyana, aburr-werranga aburr-juwuna. ");
INSERT INTO bvr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Lika gun-gatiya nipa an-gurrimapa an-ngardapa a-rrimarra a-ni, an-nigipa an-walkurpa nipa an-gata an-gurrimapa burr-guya jal a-ni nula. Lika ana-jerrmarra an-nigipa an-walkurpa, minypa nipa gu-borrwurra a-ni, a-yinagata, ‘Birripa marr aburr-balcha barra nula an-ngaypa walkur.’ ");
INSERT INTO bvr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Wurra aburr-guna jaga aburr-ganana mun-gata gurnal, birripa wupa aburr-wengganachichiyana aburr-ni, ‘A-lay, an-guna, ngarla, burraya an-gurrimapa murna a-wu barra mun-nigipa mu-ni mun-guna gurnal mun-murra mu-jinyjarra! Wurra yama ngubu-bu barra mun-ngayburrpa mu-ni?’ ");
INSERT INTO bvr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Lika aburr-garlmunapa abi-rrimarra, abu-bunapa a-juwuna. Lika abu-menga, abi-yerrnyjinga gurnal mu-jirrapa yarlanga. ");
INSERT INTO bvr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ya? Ana-goyburrpa gun-nga nyibu-borrwuja nyiburr-nirra? An-gata an-gurrimapa nipa lika a-yinmiya barra? Wurra nipiya barra ana-boy, lika burr-bu barra aburr-guna jaga aburr-ganana aburr-workiyana mun-gata gurnal. Lika aburr-werranga burr-ma barra birripa jaga aburr-gana barra nula mun-nigipa gurnal mun-gata mun-murra mu-jinyjarra. ");
INSERT INTO bvr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Wurra janguny mu-jurra gu-yurra ana-goyburrpa gala nyibi-nacharna, ya, gun-gata minypa gun-maywapa ranginy gu-yinaga gu-yurra, ‘Bala gubu-gupuna jandarra gu-maya, wurra gun-ngardapa jandarra gun-gata birripa aburr-ngoyurra gubi-yerrnyjinga. Wurra gun-narda barrwa Wangarr gu-menga, wana gun-babalapa gugu gu-jirra; jechinuwa gu-nenga gu-nirra rrawa. ");
INSERT INTO bvr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Gu-gurda ngacha minypa Wangarr jama a-ji, rrapa ngayburrpa ngubi-nacha minypa gun-gata burr-ganyjarr jama a-ji, ngarla!’” ");
INSERT INTO bvr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jesus a-yinagata a-wena, rrapa aburr-gata wana junggay yerrcha rrapa joborr marn․gi aburr-gunega, rrapa aburr-werranga burr-guta mu-murna yerrcha, birripa aburr-galiyana rrapa marn․gi gun-gata meyali gu-murna nipa a-wena birripa burr-ngurrjinga a-ni. Lika aburr-garlmuna, gubu-borrwurra aburr-yinmiya barra abi-rrima. Wurra aburr-gurkuja aburr-ni burrwa wurra gama gorlk Jesus abu-jurrjurrmunga aburr-workiya. Lika abu-bawuna, lika aburr-bona. ");
INSERT INTO bvr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Barrwa rrapa aburr-yinmiyapa Berachi (Pharisee) yerrcha rrapa Ayrat (Herod) burr-yika jawina aburr-bona gurda nula Jesus, minypa aburr-gata wana junggay yerrcha rrapa joborr marn․gi aburr-gunega rrapa aburr-werranga burr-guta mu-murna yerrcha burrbi-jerrmarra gurda barra abu-yolka Jesus, jimarna barra nipa Jesus a-yinmiya a-yolkiya a-wengga rrapa birripa mari gubu-garra nula. ");
INSERT INTO bvr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Gata lika aburr-bena nula Jesus, lika aburr-wena nula, “Bunggawa, a-lay, ngayburrpa marn․gi nggula nginyipa gala ana-nga ny-jurkuja nula wurpa niya an-gata an-nelangga wana, wurra jechinuwa ny-yeya ny-yorkiya gun-burral minypa nyirr-gurdagurdarraja ny-yorkiya Wangarr gun-nika jarlakarr. Wurra marrka wengga arrburrwa gun-ngayburrpa joborr gu-yinmiya gu-yurra: Gun-gata minypa bunggawa an-gata Rowm (Rome) a-nirra nipa rrupiya arr-gaypurda a-workiya minypa dek (tax), gun-narda gun-mola arrburrwa ngubu-wu, ya? Waygaji gun-nyagara, ya? Yama nginyipa ny-yengga arrburrwa?” ");
INSERT INTO bvr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Wurra Jesus nipa marn․gi birripa abu-yolkaja aburr-ni. Lika nipa a-yinanga burrwa, “An-nga nula ana-goyburrpa ngunabu-yolkaja nyiburr-nirra? Wurra marrka bubu-ga gurda apula mun-gata rrupiya mun-mama barra ngaypa ngu-na.” ");
INSERT INTO bvr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Lika birripa mbi-ganyja gurda nula mun-gata rrupiya, lika nipa a-yinagata burrwa, “Mun-guna ana-nga an-mawunga? Rrapa an-guna an-nelangga ana-nga?” Birripa aburr-yinagata nula, “An-narda Jija (Caesar) an-gata Rowm a-nirra bunggawa.” ");
INSERT INTO bvr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nipa a-yinagata, “Jija nipa bubu-wu mun-nigipa Jija mun-nika. Wurra Wangarr ana-goyburrpa nyiburr-burral buburr-wuya nula ngardawa gu-galiya yerrcha aburr-yigipa.” Gun-narda Jesus a-wena, birripa aburr-gata gochila aburr-barrjinga ngardawa gun-molamola a-wena. ");
INSERT INTO bvr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Lika Jejuchi (Sadducee) yerrcha aburr-bona gurda nula Jesus, aburr-gata birripa aburr-weya aburr-workiya, jimarna bama aburr-yinaga an-gugaliya a-juwiya a-workiya Wangarr gala a-yinmiya barrwa a-jarrkarra. Aburr-gurdiya Jejuchi yerrcha aburr-bona gurda, lika abu-wengganana Jesus, ");
INSERT INTO bvr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Bunggawa, a-lay, nipa Mojich (Moses) a-wukurrjinga arrburrwa gun-gata joborr minyja an-gugaliya jin-nigipa jin-gumarrbipa niya jiny-bawa minypa a-juwa, wurra nipa jin-gata gala delipa a-manggarna, lika an-gata an-nigipa worlapa niya jiny-ma barra jin-gata gama barra delipa a-barripa butula an-bitipa an-murnangana gipa mu-ngoyurra a-juwuna. Gu-gurda ngacha. ");
INSERT INTO bvr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Wurra gun-guna rrawa mu-ngoyurra aburr-ni worlapa burra yerrcha birripa wupa arr-ngardapa arr-murna rrapa abirri-jirrapa, minypa 7, an-gata an-murnangana jin-gumarrbipa jin-dimarra, wurra nipa a-juwuna gala delipa a-rrimangarna. ");
INSERT INTO bvr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Lika a-jurrjurrmurrapa jin-gata jiny-menga, wurra nipa a-juwuna gala delipa a-rrimangarna, rrapa barrwa a-guymurrapa a-yinagatiya. ");
INSERT INTO bvr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Rrapa aburr-werranga burr-guta aburr-yinagatiya, minypa birripa wupa arr-ngardapa arr-murna rrapa abirri-jirrapa aburr-juwuna aburr-ni, wurra gala ana-nga delipa abi-rrimangarna. Lika gu-gata wenga rrapa nipa jin-gata gama jiny-juwuna. ");
INSERT INTO bvr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Gun-narda janguny, wurra minyja Wangarr ngayburrpa arr-jarrkarra, lika jin-gata gama ana-nga jin-nika jin-gumarrbipa jinyu-ni barra, ya? Ngardawa gipa arr-ngardapa arr-murna rrapa abirri-jirrapa jibu-malapuna aburr-ni.” Aburr-yinagata aburr-gata Jejuchi yerrcha abu-wengganana Jesus, minypa birripa gubu-borrwurra, jimarna bama aburr-yinanga Wangarr gala a-jarrkarra an-gugaliya mu-ngoyurra a-juwuna. ");
INSERT INTO bvr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Wurra Jesus a-yinanga burrwa, “Minyja ana-goyburrpa nyiburr-yolkiya nyiburr-nirra, ngarla! Ngardawa gala nyibi-nacharna meyali janguny mu-jurra gu-yurra rrapa gala marn․gi ganyjarr gun-gata Wangarr gu-rrimanga. ");
INSERT INTO bvr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wurra aburr-gata Wangarr burr-jarrkarra barra wanngu aburr-ni, birripa minypa waykin aburr-guyinda gala barra abirriny-malapachichiya abirrinyu-ni. ");
INSERT INTO bvr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wurra gun-gata nula minypa Wangarr burr-jarrkarraja a-workiya mu-ngoyurra aburr-juwuna — ana-goyburrpa gala mu-jurra nyibi-nacharna nyiburr-workiyarna, ya, Mojich gun-nika janguny gun-gata minypa gun-jong gu-rronga wurra nipa gala gu-rronggarna, rrapa minypa Wangarr a-wena nula Mojich? Jarra ana-goyburrpa nyibi-nacha nyiburr-workiya janguny, wurra gala meyali nyibu-borrwa. Minypa nipa a-yinanga nula Mojich, ‘Ngaypa ng-guna Wangarr aburr-guna ngu-burriya: Aybriyam (Abraham) rrapa Ayjek (Isaac) rrapa Jeykap (Jacob).’ Nipa a-yinagata a-wena wuriya aburr-gata minypa Aybriyam rrapa Ayjek rrapa Jeykap gipa mu-ngoyurra aburr-juwuna. ");
INSERT INTO bvr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wurra bubu-borrwa: Nipa Wangarr gala a-yinmiya an-birripa a-ni Wangarr minyja jimarn jarra gun-gata gun-nyagara gu-ni gun-gumungba. Ngika. Wurra jarra aburr-mola aburr-nirra Wangarr ana-murna. Minyjiya. Ana-goyburrpa nyiburr-yolkiyanapa nyiburr-ni lika.” ");
INSERT INTO bvr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Rrapa an-nerranga an-gata joborr marn․gi an-gunega, nipa gatiya a-galiyana burrwa birripa aburr-wena aburr-ni. Nipa an-gata a-nana Jesus nipa gun-molamola a-wena burrwa Jejuchi yerrcha, lika nipa ana-garlmuna, a-wena nula Jesus, “A-lay, Bunggawa, gun-ngiya joborr Wangarr gu-gurrmurra wana gun-babalapa, ya?” ");
INSERT INTO bvr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus a-yinagata, “Minyja gun-gunaga joborr wana gun-babalapa: Minypa wola Mojich a-yinagata a-wena, ‘A-lay, Yichrayal (Israel) aburr-bapurr,’ a-yinagata a-wena burrwa, ‘an-ngayburrpa an-ngardapiya arrburrwa Wangarr, nipa gun-burral an-ngardapiya arrburrwa. ");
INSERT INTO bvr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Jal ni nula an-goyburrpa an-ngardapiya ana-gorrburrwa Wangarr minypa burr-molma burr-burral, burr-bama burr-rrepara.’ ");
INSERT INTO bvr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Gun-nardiya joborr, rrapa barrwa gun-nerranga rrapa gun-gunaga gun-maywapa ranginy: ‘An-nginyipa an-borrmunga jal nyi-ni nula minypa nginyipa ngardapa nggu jal nyi-nirra nggula.’ Abirri-gurdiya abirri-jirrapa joborr, minypa gala gun-nga gun-nerranga wana gun-bapala.” ");
INSERT INTO bvr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Lika an-gata joborr marn․gi an-gunega a-yinagata, “Gun-narda ny-jarlapuna, a-lay, Bunggawa. Minyja gun-narda gun-burral ny-yena Wangarr nipiya an-ngardapiya rrapa gala ana-nga an-nerranga. ");
INSERT INTO bvr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Gun-gata minypa Wangarr ngayburrpa barra jal nguburr-ni nula burr-bama burr-burral, rrapa minypa an-ngayburrpa an-borrmunga jal nguburr-ni barra nula gun-maywapa minypa ngayburrpa wupa ngardapa ngardapa jal nguburr-nirra arrburrwa, gu-gurda ngacha wana. Wurra gun-gata minypa jin-garla ngubi-yalpurda nula nguburr-workiya Wangarr, gun-narda jarra marr gu-yinaga.” ");
INSERT INTO bvr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Gun-narda nipa Jesus gu-nana an-gata an-gugaliya gun-molamola a-wena, lika a-yinagata nula, “A-lay, ny-junarda nginyipa balay ngika nula Wangarr gun-nika rum.” Ganapiya, lika gun-nardiya gugu gala ana-nga barrwa a-yinmiyarna a-wengganacharna Jesus gun-nga. ");
INSERT INTO bvr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Gun-gatiya minypa Wangarr gun-nika gu-japurra gu-rrawa Jesus marn․gi burr-negarra a-ni janguny, nipa a-yinagata burrwa, “Ya? Aburr-gata marn․gi aburr-gunega, an-nga nula birripa Christ abu-ngurrjinga aburr-workiya rrapa gun-narda aburr-weya Wangarr ana-jerrma barra wanngu an-gunega an-gata nipa Daybit (David) murna a-wuna? ");
INSERT INTO bvr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Wurra jarra nipiya Daybit Mern An-mawunga wugupa nula wola a-wena, a-yinagata, ‘Wangarr a-wena nula an-ngayburrpa Bunggawa, a-yinagata nula, “Burdak ngunyuna raka ngu-munganaguwa, nuwurra aburr-gata aburr-bachirra nggula ngaypa ay-gaba nguburr-nega barra nginyipa mu-ngoyurra ny-ji barra burrwa.” ’ ");
INSERT INTO bvr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ganapiya, wurra minypa Daybit a-yinagata a-wena a-workiyana rrapa bunggawa a-negarra Christ, gun-narda minypa nipiya Christ wana, jarra Daybit nyanma ngika.” Lika aburr-gata aburr-jaranga wurra gama gorlk, birripa aburr-marrkapchinga aburr-ni, aburr-galiyana aburr-ni nula Jesus. ");
INSERT INTO bvr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Lika nipa a-yinagata burrwa, “Buburr-jarlapiya nula gun-nerra gun-gata minypa aburr-gata joborr marn․gi aburr-gunega gubi-rrimanga, aburr-gatiya minypa wana aburr-negiya aburr-workiya. Gun-birripa jal mirikal mun-baykardakarda aburr-barrngumiya aburr-workiya, rrapa gu-gandin aburr-boya burrwa aburr-workiya wurra gama gorlk aburr-nyala barra burrbi-na rrapa burrbu-burrmaymba. ");
INSERT INTO bvr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Rrapa barrwa gun-birripa jal aburr-boya aburr-workiya, mu-ngoyurra aburr-rakaja minypa wupa gu-bala Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya rrapa yina gun-gaya minypa janara gu-jirra gu-workiya. ");
INSERT INTO bvr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wurra jarra birripa aburr-gurda burrbu-yolkaja aburr-workiya aburr-gata miliyak yerrcha, rrapa minypa burrbu-gaypurda aburr-workiya gun-birripa bala. Minyjiya. Lika aburr-garlmiyapa Wangarr abu-wengganacha aburr-workiya gun-baykardakarda, minypa barra aburr-werranga burrbi-na rrapa gubu-borrwa, jimarna jarrapa bama aburr-yindin aburr-molamola. Wurra nuwurra jurdach birripa aburr-gurda mari wana gubu-ma barra minypa birripa waykin aburr-molamola rrapa wupa aburr-werra.” ");
INSERT INTO bvr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Lika gu-gata wenga Jesus a-rakaja, wurra gama gorlk burr-nana a-ni gun-gatiya aburr-bona gurda aburr-ji, rrupiya mbi-barnjinga aburr-bona minypa Wangarr mun-nika abu-wuna aburr-workiyana. Aburr-gata aburr-jaranga rrupiya mun-jaranga mbi-rrimarra, birripa wana mbi-barnjinga; ");
INSERT INTO bvr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","wurra jin-ngardapa jin-miliyak jina-bona rrupiya jin-nyagara, nipa mun-delipa m-barnjinga rrupiya minypa mun-mama mun-guyinda abirri-jirrapa burr-guya mun-delipa, warrpam mun-gata minypa mun-ngardapa jench (1 cent). ");
INSERT INTO bvr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Lika Jesus a-gonyjinga burrwa aburr-yigipa jawina aburr-garlmuna gurda nula, lika a-yinanga burrwa, “A-lay, gun-guna ngu-weya ana-gorrburrwa gun-burral: Jin-gaba jin-miliyak marrban rrupiya jin-nyagara, wurra nipa jarra m-barnjinga minypa wana; ");
INSERT INTO bvr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","wurra aburr-werranga aburr-jaranga mbi-barnjinga marr mu-yinanga. Minypa birripa mun-nerranga mu-ngukiyana rrapa mbi-ganyja rrawa, wurra jin-gata m-barnjingapa mu-wulebiyana, rrapa gala mun-nga rraka mu-ga, balaja burr-guta mu-ma, wurra jin-nyagara.” ");
INSERT INTO bvr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Gun-gatiya waypa Jesus gu-bawuna ana-bena gun-gata gun-japurra rrawa Wangarr gun-nika, wurra an-ngardapa an-nigipa jawina a-wena nula, “A-lay, Bunggawa, gun-gata na jandarra gun-molamola rrapa bala gun-molamola!” ");
INSERT INTO bvr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesus a-yinagata, “Aya. Nginyipa gun-narda nyi-nacha nyi-nirra, ya? Wurra gala gu-yinmiya mu-nguy gu-ji gun-gata bala rrapa jandarra, wurra gu-jel gu-yu barra gu-ni ngardapa ngardapa.” ");
INSERT INTO bvr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Gu-gata wenga Jesus rrapa aburr-yigipa jawina aburr-bamuna, lika mu-mirk aburr-warrchinga mun-gata mun-nelangga Alip (Olive) Mu-jirrapa, lika gatiya aburr-rakaja, gu-gatiya wenga gubi-nana gurda aburr-ni Wangarr gun-nika bala gun-japurra. Lika Birta (Peter) rrapa Jeymch (James) rrapa Jon rrapa Andru (Andrew), aburr-gurda wupa yongun abu-wengganana aburr-ni Jesus, ");
INSERT INTO bvr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“A-lay, gun-gata nginyipa ny-yena arrburrwa Wangarr gun-nika bala gun-gata jandarra gu-jel gu-yu barra gu-ni ngardapa ngardapa, gun-narda nipa gu-yinpa barra? Gun-ngiya ngayburrpa mu-ngoyurra nyibi-na barra marn․gi nyiburr-ni ngardawa yi-gurrepa gu-jirra gu-boya?” ");
INSERT INTO bvr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Lika Jesus a-garlmuna, a-wena burrwa, “Buburr-jarlapiya. Gala yapa ana-werranga nyirr-yolkajin rrapa ana-goyburrpa nyiburr-lijiwarriyan. ");
INSERT INTO bvr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Wurra aburr-jaranga aburr-bengga barra rrapa ngaypa ngu-welangga ngunabu-ma barra, minypa aburr-ngunyangunyjiya barra, aburr-yinda, ‘Ngaypa ng-gunaga Christ!’ rrapa minypa barra burrbu-yolka aburr-jaranga wurra gama gorlk. ");
INSERT INTO bvr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Rrapa gun-gata waypa ana-goyburrpa nyiburr-galiya minypa gun-guna rrawa an-dakal a-beya a-workiya, rrapa barrwa minypa janguny guna-jeka, ana-goyburrpa nyiburr-galiya minypa an-dakal a-boya burrwa gu-werranga gu-werranga gu-rrawa, wurra gala barra nyiburr-gurkuja. Wurra gu-yirdiya barra gu-bamba, wurra gala barra burdak gu-wulebiyapa. ");
INSERT INTO bvr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Minyjiya. Ngardawa gu-werranga gu-rrawa wenga aburr-garlma barra aburr-workiya, aburr-bachirramiya barra burrwa mola gu-werranga gu-rrawa, rrapa minypa bunggawa ana-guyinda a-garlma barra a-workiya, mari gu-garra barra nula an-nerranga bunggawa gu-werranga gu-rrawa. Rrapa rrawa gu-ngorrkiya barra gun-jaranga gu-jirra gu-boya gurdiya rrawa, rrapa minypa balaja mu-wulebiya barra gun-jaranga rrawa. Gu-gata ngacha gu-yirda barra gu-ni minypa gu-garlmapa barra mu-nguy gun-nerra gu-ni barra gu-bamba. ");
INSERT INTO bvr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Wurra buburr-jarlapiya. Ngardawa aburr-werranga aburr-bachirramiya barra ana-gorrburrwa, birripa nyirrbi-rrima barra nyirrbu-ga, burrbu-wu Ju yerrcha ganychila (councillor) birripa barra burr-mari aburr-wengga ana-gorrburrwa, rrapa gata gu-bala gu-jirra gu-boya Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya birripa nyirrbu-bu barra. Minyjiya. Rrapa nyirrbu-ga barra, aburr-gata gapman yerrcha bunggawa an-mumurna an-guyinda burr-guta birripa minypa aburr-galiya barra ana-gorrburrwa, aburr-yinmiya barra aburr-wengga ana-gorrburrwa minypa ana-goyburrpa nyiburr-ngaypa jawina; wurra jarra ana-goyburrpa barra ngaypa ngunabu-ngurrja burrwa. ");
INSERT INTO bvr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Wurra burdak ni-gugu gu-bulapalawa gu-rrawa aburr-galiya barra gun-ngaypa janguny gun-molamola, nuwurra waypa jurdach gu-wulebiyapa barra. ");
INSERT INTO bvr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Gun-gata minypa aburr-gata aburr-bachirramiya ana-gorrburrwa nyirrbi-rrima barra aburr-galiya ana-gorrburrwa rrapa burr-mari aburr-wengga ana-gorrburrwa, wurra mu-ngoyurra gala barra nyibu-borrwa nyiburr-ni ana-goyburrpa nyiburr-yinmiya barra nyiburr-wengga. Ngika. Wurra gun-gatiya ana-goyburrpa nyiburr-wengga, gun-gata janguny nipa Wangarr nyirr-wu barra. Minypa ana-goyburrpa nyanma ngika, wurra jarra Mern An-mawunga nipa nyanma. ");
INSERT INTO bvr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Rrapa gu-galiya yerrcha burrbi-rrima barra aburr-workiya aburr-birripa worlapa burra yerrcha, ngarla, rrapa burrbu-barnja barra aburr-workiya barra aburr-juwa. Rrapa nyanyapa burra yerrcha aburr-yirda barra burrwa aburr-birripa gu-ngarda yerrcha. Rrapa delipa yerrcha aburr-garlma barra, aburr-bachirramiya barra burrwa aburr-birripa nyanyapa burra yerrcha rrapa mampa burra yerrcha, lika burrbu-barnja barra aburr-workiya barra aburr-juwa. ");
INSERT INTO bvr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Rrapa aburr-jaranga gu-galiya yerrcha aburr-bachirramiya barra ana-gorrburrwa aburr-workiya ngardawa minypa ana-goyburrpa nyiburr-ngaypa. Wurra ny-yinga ny-jata minyja gala ny-jeka, wurra minypa ny-jinyjapa barra ny-yorkiya, nginyipa nuwurra jurdach wanngu nyi-ni barra. ");
INSERT INTO bvr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Wurra gun-gata waypa barra ana-goyburrpa nyibi-na An-nerra Warrpam gatiya nipa a-jinyja gun-japurra gu-bala Wangarr gun-nika — (ny-junarda nginyipa mun-narda jurra nyi-nacha nyi-nirra, marrka borrwa gun-gata gun-nga) — wurra gun-gatiya barra aburr-gata Judíya (Judea) aburr-nirra marrka barra gubu-bawa gun-birripa rrawa, aburr-yurtcha barra mu-mirk mu-ngarnama. ");
INSERT INTO bvr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Minypa an-gugaliya yarlanga a-nirra gala a-yinmiya gu-bala a-barrnguma, gorlk gu-ma nula; ");
INSERT INTO bvr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","rrapa minypa an-gata jama a-jirra a-nirra balay marlgaway gala a-yinmiya a-jeka, mu-ma mun-nigipa molma mun-gunegiya mirikal. ");
INSERT INTO bvr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Gun-gatiya barra burr-guya gun-nerra gu-ni barra achila jin-morichiringa jin-guyinda rrapa ngamangama gu-jarlapurda jinyu-nirra delipa gun-nika. ");
INSERT INTO bvr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Wurra burdak mu-ngoyurra bubu-wenggana Wangarr; gala yapa gun-gata mern mu-yurtcha. ");
INSERT INTO bvr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ngardawa gun-gatiya gu-ni barra, gu-garlmapa barra gun-nerra gu-ni barra warrpam gu-gata ngacha minypa an-gugaliya gala mu-ngoyurra gu-nacharna a-workiyarna, minypa gu-gatiya wenga Wangarr gu-jarlapuna gurdiya rrawa rrapa gu-bamuna gun-guniya gugu, wurra gun-nyagara, rrapa minypa gala barrwa gu-yinmiya. ");
INSERT INTO bvr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Wurra Wangarr gipa mu-ngoyurra gu-borrwurra minypa nipa gun-balmbarra gu-nega barra gun-gata. Wurra minyja gala gun-balmbarra gu-nengarna, gala ana-nga barra a-molamiya. Wurra jarra aburr-yigipa nipa a-jerrjerrjiyanapa burrwa, nipa burr-borrwurra birripa, lika a-garlmuna, gun-balmbarra gu-negarra. ");
INSERT INTO bvr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Gun-gatiya barra minyja ana-nga a-yinda a-wengga nggula, ‘Minyja na, an-guna Christ!’ rrapa minyja a-yinda, ‘Yi-gaba na! An-gaba!’ wurra nginyipa gala barra gun-narda marr ny-balcha nula. ");
INSERT INTO bvr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ngardawa aburr-gata ngacha aburr-bengga barra aburr-guyolkiya, minypa aburr-ngurrjiya barra Christ rrapa minypa gun-nerranga janguny gubu-ga barra gurda. Minypa burr-barlmarrk jama aburr-ji barra minyja barra burr-yolka Wangarr burr-yika gu-galiya yerrcha, barra minypa aburr-lijiwarriya. ");
INSERT INTO bvr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Wurra ana-goyburrpa buburr-jarlapiya, ngardawa ngaypa gipa mu-ngoyurra ngu-ngurrjinga ana-gorrburrwa gun-gata warrpam. ");
INSERT INTO bvr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Wurra gun-gatiya barra gun-nerra gu-ni, lika gu-gata wenga ‘marnnga jiny-jarlmapa barra an-munya jiny-maya, rrapa an-gata ran․gu gala a-yinmiya barrwa a-jayanaya a-ji. ");
INSERT INTO bvr_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Rrapa waykin wenga jin-jaranga gata jiny-jarlmapa barra jina-bunggapa jinyu-ni, rrapa wana aburr-bapala aburr-guyinda aburr-gaba waykin nipa Wangarr burr-ngorrka barra.’ ");
INSERT INTO bvr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Lika wurra gama gorlk abi-na barra an-guna An-walkurpa An-gugaliya gu-nguparr ana-bupiya barra ana-bamba burr-barlmarrk rrapa burr-gujayanaya. ");
INSERT INTO bvr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Lika nipa barra burr-jerrma barra aburr-yigipa waykin aburr-guyinda aburr-mujaruk gun-nardiya rrawa gu-jirra gu-boya, rrapa minypa burr-bamagutuwa barra aburr-yigipa gu-galiya yerrcha nipa a-jerrjerrjiyana burrwa. Minypa yinda wenga barlmarrk guna-jeknga gu-workiya, yi-gaba ngunyuna rrapa yi-gaba ngunyuna burr-bamagutuwa barra. ");
INSERT INTO bvr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Bubu-borrwa gun-jong barra marn․gi nyiburr-ni. Minypa ngayburrpa wolawola ngubi-nacha nguburr-workiya mun-gata mun-jawanyja m-burnda niya mun-gubocha rrapa wombajarr, rrapa marn․gi nguburr-nirra gun-gata yi-gurrepa jemberr. ");
INSERT INTO bvr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Gun-narda minypa gun-maywapa minypa gun-guna gun-burral: Ana-goyburrpa nyibi-na barra gu-yirda barra gu-ni minypa geka ngaypa ngu-wena ana-gorrburrwa, rrapa marn․gi nyiburr-ni barra minypa yi-gurrepa gu-jirra gu-boya an-guna An-walkurpa ana-jeka barra. ");
INSERT INTO bvr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Gun-guna ngu-weya ana-gorrburrwa gun-burral: Nyiburr-gurdiya ngacha gu-galiya yerrcha, nyiburr-werranga gala barra mu-ngoyurra nyiburr-juwa. Ngika. Wurra gun-gata ngaypa ngu-wena ana-gorrburrwa, gun-bulapalawa gun-gata ni-gugu gu-yirda barra gu-ni. ");
INSERT INTO bvr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Minyjiya. Gun-guniya rrawa gu-garlmapa barra gun-nyagara gu-ni barra, wurra gun-ngaypa wengga gu-jinyjapa barra gu-workiya. ");
INSERT INTO bvr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Wurra gun-gata gu-yinpa barra an-guna An-walkurpa An-gugaliya ana-jeka gala ana-nga marn․gi, minypa waykin aburr-guyinda aburr-mujaruk rrapa an-guna An-walkurpa burr-guta; wurra jarra Nyanyapa arrku waykin a-nirra nipa wupa marn․gi. ");
INSERT INTO bvr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Buburr-jarlapiya rrapa buburr-gana buburr-ni, ngardawa ana-goyburrpa gala marn․gi gu-yinpa barra gun-balmapa. ");
INSERT INTO bvr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Gun-gata minypa gun-maywapa wolawola an-gugaliya gu-bawuja a-workiya rrawa rrapa a-boya balay, wurra murna burr-wucha aburr-yigipa aburr-mujama. Minypa jama burr-wucha ngardapa ngardapa, rrapa an-ngardapa an-mujama nipa a-weya nula barra jaga a-gana gun-gata ngana gu-jirra. ");
INSERT INTO bvr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Gun-narda gun-maywapa minypa gun-burral ana-goyburrpa barra nyiburr-gana nyiburr-ni, ngardawa gala marn․gi gu-yinpa barra rrawa an-gurrimapa ana-jeka barra — waygaji balngga gu-ni barra, waygaji ana-munya gornborrk, waygaji ngana guna-ngarlcha, waygaji ngulamgaba. ");
INSERT INTO bvr_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Gala yapa ni-gugu yibirrich a-benggin rrapa nyirr-nan nyiburr-yungun. ");
INSERT INTO bvr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Gun-gata ngaypa ngu-wena ana-gorrburrwa rrapa minypa aburr-werranga burr-guta nyiburr-gurdiya gorlk ngaypa ngu-yinaga ngu-weya ana-gorrburrwa: ‘Buburr-gana buburr-ni!’” ");
INSERT INTO bvr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Gun-gatiya gugu yi-gurrepa janara gu-ji barra burrwa Ju yerrcha, minypa ngorrngurra abirri-jirrapa gu-ni barra burdak. Janara gun-gata minypa wolawola jip (sheep) an-geka an-nurra abu-burnda aburr-workiya, abu-banga aburr-workiya, rrapa damba mun-gun․gun mbi-banga aburr-workiya, gubu-borrwuja minypa wola waykin an-guyinda an-mujaruk burr-burndarna, wurra jarra burr-beybana, gu-gurda ngacha. Wurra gun-gata minypa janara yi-gurrepa gu-ji burrwa gu-bona, birripa wana junggay yerrcha rrapa joborr marn․gi aburr-gunega wengga gubu-buna aburr-ni Jesus barra yongun abi-rrima rrapa abu-bu. ");
INSERT INTO bvr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wurra aburr-yinagata, “A-lay, gun-guna gala nguburr-yinmiya gu-janara. Wurra burdak; gala yapa wurra gama gorlk aburr-yurtcha gurda aburr-yurtcha.” ");
INSERT INTO bvr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Wurra Jesus gatiya a-ni Bechini (Bethany), balapala a-rrenyjinga Jayman (Simon) an-gata mu-ngoyurra an-jeja a-ji minypa gun-guburlububurluja gu-rrimarra. Gata balaja mbi-barra aburr-ni, lika jin-ngardapa gama jina-bona, bochula (bottle) mu-guyinda muna-ganyja mun-gungimiya mun-molamola mun-gungolkuja mun-nelangga nart (nard). Mun-gata bochula mbi-jarlapuna jandarra gun-molamola gun-gata gun-nelangga alabécha (alabaster), rrapa mun-gata nart rrupiya wana nula gala mun-nga mun-nerranga mbi-balagarrgurrjarna. Lika nipa jin-gata mu-rrumurra mun-gata bochula, lika mun-gata mun-molamola mun-gungolkuja mu-jerrjerrjinga ana-jawurrga Jesus. ");
INSERT INTO bvr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Wurra gu-gata wenga aburr-werranga gu-galiya yerrcha aburr-gata aburr-bachirramiyana achila aburr-wengganachichiyana aburr-ni birripa wupa, minypa aburr-yinanga, “Jin-guna an-nga nula mu-yerpana mun-gata mun-molamola mun-gungolkuja? ");
INSERT INTO bvr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ngayburrpa jarra ngubu-ganyjarna, ngubu-barnjingarna burrwa, rrapa minypa rrupiya wana ngubu-manggarna mun-gata minypa an-gugaliya mu-mangga a-workiya, jama a-jirra a-workiya gun-ngardapa jemberr, ngarla. Lika gu-gata wenga aburr-nyagara arrbu-wucharna.” Aburr-yinagata aburr-wena, lika jibu-jonga aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Wurra Jesus a-wena burrwa, “Bubu-bawa! Jin-narda an-nga nula nyiburr-weya achila? Nipa gun-molamola gun-narda minypa nguna-ngimarra rrapa ngu-molamola nguna-negarra. ");
INSERT INTO bvr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Wurra birripa gorlk aburr-nyagara wugupa nyiburr-nirra nyiburr-workiya barra wolawola ana-goyburrpa nyiburr-gunggaja burrwa nyiburr-workiya; wurra jarra ngaypa ngu-boy barra. ");
INSERT INTO bvr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wurra jin-guna jiny-yinagata nguna-ngimarra minypa nipa ganyjarr gu-rrimarra. Minypa mu-jerrjerrjinga mun-molamola mun-gungolkuja ngaypa ngu-burral, nuwurra jurdach lika ngunabu-jurnumba. ");
INSERT INTO bvr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Gun-guna ngu-weya ana-gorrburrwa gun-burral: Yina gaya barra gun-ngaypa janguny gubu-ngurrja barra aburr-workiya gun-nardiya rrawa gu-jirra gu-boya, gun-gata rrapa gu-barrjeka barra achila janguny minypa geka nipa nguna-ngimarra.” ");
INSERT INTO bvr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Lika Jesus burr-yika 12 gu-galiya yerrcha wurra an-ngardapa an-gata an-nelangga Jurrach Yichkériyat (Judas Iscariot), nipa a-garlmuna, a-bona burrwa wana junggay yerrcha, minypa nipa burr-wu barra Jesus barra abi-rrima. ");
INSERT INTO bvr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Gu-gurda ngacha nipa a-wena burrwa, birripa aburr-japurramayana nula rrapa gochila gochila abi-rrana rrupiya barra abu-wu. Lika gu-gata wenga Jurrach gu-borrwurra a-ni yina gaya rrapa gu-yinpa barra Jesus abi-rrima. ");
INSERT INTO bvr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Gun-gatiya gugu waypa janara gu-ji, minypa damba mun-gun․gun mbi-barra aburr-workiyana Yichrayal (Israel) yerrcha rrapa an-geka jip abu-buna aburr-workiyana nuluwa Wangarr, gun-gata Jesus burr-yika jawina abu-wengganana, “A-lay, yina gaya jal nyi-nirra ngayburrpa barra nyiburr-boy, nawanawa nyiburr-ni nggula mun-mujanara balaja rrapa an-mujanara jip?” ");
INSERT INTO bvr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Lika Jesus bijirri-jerrmarra abirri-jirrapa abirri-yigipa jawina, a-yinagata butula, “Birri-boy gu-murnangana rrawa, lika an-ngardapa an-gugaliya gatiya barra galamurrpa nyibu-garra nipa bugula a-bamiya a-bamburda duram ana-guyinda; lika ana-gotipa nyirri-jurrjurrma barra nipa an-gata. ");
INSERT INTO bvr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Lika nyiburr-jarl barra nyiburr-bamba, a-barrnguma. Lika nyirri-wenggana barra an-gata bala an-gurrimapa, nyirri-yinda barra nula, ‘A-lay, an-gaba Bunggawa a-wena, a-yinagata, “Yina gun-gaya gun-ngaypa gun-ngarnama barra ngaypa rrapa aburr-ngaypa jawina wugupa nyibu-bay nyiburr-ni rrapa nyibu-borrwa wola arr-beybana?’” ");
INSERT INTO bvr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Lika nipa nyjirri-guybuka barra gun-ngarnama waykin gu-jirra gipa mu-ngoyurra gu-jarlapuna, belabila gun-nga burr-guta gu-jirra gu-boya barra ana-gotipa nawanawa nyirri-ni arrburrwa.” ");
INSERT INTO bvr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jesus a-yinagata a-wena butula, lika abirri-gata abirri-yigipa jawina abirri-bona gu-murnangana rrawa, lika gubirri-barripuna minypa nipa a-wena. Lika nawanawa abirri-ni mun-gata mun-mujanara balaja. ");
INSERT INTO bvr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Lika nuwurra yi-rrana gu-ni, Jesus rrapa aburr-yigipa jawina aburr-bona gurda. ");
INSERT INTO bvr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Lika gatiya waypa balaja mbi-barra aburr-ni, Jesus a-wena burrwa, a-yinagata, “Gun-guna ngu-weya ana-gorrburrwa gun-burral: Ana-goyburrpa nyiburr-gurda wugupa ngubu-banga nguburr-nirra, ny-nyardapa gipa ny-jarlmuna, aburr-gata aburr-bachirra murna burr-wu barra ngaypa.” ");
INSERT INTO bvr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Lika aburr-yigipa jawina wargugu aburr-ni nula gun-gata nipa a-wena. Lika ngardapa ngardapa abu-wengganana aburr-bona, “A-lay, ngaypa ngika, ya?” ");
INSERT INTO bvr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Lika Jesus a-wena, “Nyiburr-gurda wupa nyiburr-ngaypa 12 gu-galiya yerrcha, ny-jurdiya ny-nyardapa, wurra an-ngardapiya an-guna ngayburrpa wugupa damba ana-maywapa ana-japalana ay-gurragaja arr-nirra. ");
INSERT INTO bvr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Minyjiya. An-guna An-walkurpa An-gugaliya nipa a-juwa barra minypa mu-jurra gu-yurra Wangarr gun-nika janguny, wurra an-gugaliya an-gata minypa nguna-bawuna rrapa murna burr-wuna ngaypa aburr-gata aburr-bachirra, nipa jarra an-gata an-gugaliya gun-nerra warrpam gu-ni barra nula, jimarna gun-mola nula minyja nipa gala a-bambunggiyarna.” ");
INSERT INTO bvr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Gun-gatiya minypa birripa mbi-barra aburr-ni, Jesus mu-menga damba, a-japurramayana nula Wangarr, lika mu-rrumurra, burr-wuna a-bona aburr-yigipa jawina. A-yinagata burrwa, “Bubu-ma; mun-guna ngaypa ngu-burral.” ");
INSERT INTO bvr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Rrapa mernda a-jirra a-menga, minypa burr-girra gurnal, lika a-japurramayana nula Wangarr, lika burr-wuna aburr-yigipa jawina aburr-jaranga mbi-barra. ");
INSERT INTO bvr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesus a-yinagata burrwa, “Mun-guna ngaypa ngu-maningan gun-burral gu-nenga mu-nirra rum. Ngaypa ngu-jortcha barra ana-gorrburrwa ana-goyburrpa nyiburr-gurda rrapa aburr-jaranga aburr-werranga burr-guta. ");
INSERT INTO bvr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Gun-guna ngu-weya ana-gorrburrwa gun-burral: Mun-guna gurnal mun-girra gala barra barrwa ngu-bay, wurra nuwurra mun-geka ngu-bay barra Wangarr ana-murna.” ");
INSERT INTO bvr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ganapiya, lika manakay aburr-japarndiyana nula Wangarr, lika aburr-garlmuna, mu-mirk aburr-bona mun-nelangga Alip (Olive) Mu-jirrapa. ");
INSERT INTO bvr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Lika Jesus a-yinagata burrwa, “A-lay, nyiburr-gurda nyiburr-jaranga nyiburr-garlmapa ngunabu-bawa nyiburr-yurtcha. Ngardawa minypa mu-jurra gu-yurra janguny, gu-yinaga gu-yurra, ‘An-gata jip jaga a-ganaja a-workiya, nipa Wangarr ana-nyala a-bu barra, rrapa nipa jin-gata jip jiny-jarlmapa barra mun-ganday m-bu barra.’ ");
INSERT INTO bvr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Gu-yinagata gu-yurra janguny. Wurra nuwurra waypa barra ngu-molamiya, ngaypa lika mu-ngoyurra ngu-boy barra ana-gorrburrwa gun-gata Galali (Galilee).” ");
INSERT INTO bvr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Lika Birta (Peter) a-garlmuna, a-wena nula Jesus. “A-lay, ngaypa gala ngu-yinmiya ngiy-bawa, marrban aburr-werranga aburr-lijiwarriya.” ");
INSERT INTO bvr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Wurra Jesus a-yinagata nula Birta, “Gun-guna ngaypa jarra marn․gi ngardawa gun-burral: Geka barra, minyjiya, gun-nardiya ana-munya barra gala barra bawul (fowl) ni-gugu jiny-yengga, wurra jarra nginyi-gugu ny-jirrapa ny-nyardapa ny-joma ny-jordajiya burrwa jimarna gala marn․gi apula, rrapa nuwurra jurdach bawul jiny-yengga barra.” ");
INSERT INTO bvr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Wurra Birta a-yinagata a-wena burr-guya, “Ngaypa gala barra ngiy-bawa, wurra marrban ngunabu-bu minypa wugupa arr-juwa.” Rrapa aburr-werranga Jesus burr-yika jawina aburr-yinagatiya aburr-wena gun-maywapa. ");
INSERT INTO bvr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Birripa aburr-bamuna gurda rrawa gun-nelangga Gachémani (Gethsemane), lika Jesus a-yinagata burrwa aburr-yigipa jawina, “Ana-goyburrpa ngunyuna buburr-ni, wurra ngaypa barra yi-gaba ngu-boy, Ngun-anya ngu-wenggana barra.” ");
INSERT INTO bvr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Lika burr-menga Birta rrapa Jeymch rrapa Jon, lika burr-ganyja a-bona. Wurra nipa a-garlmunapa wargugu a-ni. ");
INSERT INTO bvr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","A-yinagata burrwa, “Ngaypa burr-guya wargugu ngu-nirra, ngarla! Wurra ana-goyburrpa buburr-gana buburr-ni ngunyuna.” ");
INSERT INTO bvr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Lika ay-garlmuna gun-baykarda ngika, lika a-yerrnyjiyana gu-jel, Wangarr a-wengganana a-ni barra nipa gun-gata mari a-beyba. ");
INSERT INTO bvr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","A-yinagata, “Anya, gala gun-nga gun-derta gun-gorla nggula, wurra gun-guna mari yerrnyja apula. Wurra ngardawa gun-ngaypa jal ngika, wurra minyja nginyipa jal nyi-ni.” ");
INSERT INTO bvr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ganapiya, lika nipa ana-jekarra, burr-nana aburr-yigipa jawina aburr-yu. Lika a-wena nula Birta, “A-lay, Jayman, ny-yunyarra? Nginyipa gala ny-yinmiya ny-jana, ya? Wurra ngaypa gun-guna waya ngu-bona.” ");
INSERT INTO bvr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Lika nipa a-yinagata burrwa, “Buburr-gana buburr-ni rrapa bubu-wenggana Wangarr barra nipa a-gunggaja ana-gorrburrwa rrapa gala nyiburr-yinmiya nyiburr-lijiwarriya. Minypa ana-goyburrpa nyiburr-mola, wurra nyiburr-gata nyiburr-gugaliya nyiburr-nyarlkuch.” ");
INSERT INTO bvr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Lika a-garlmuna, barrwa a-bona, Wangarr a-wengganana a-ni gun-maywapa. ");
INSERT INTO bvr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ana-jekarra, lika barrwa aburr-yigipa jawina burr-nana aburr-yu aburr-ni. Birripa gala aburr-yinmiyarna aburr-ganajarna aburr-nirrarna, wurra ngorrngurra burr-buna gu-ni, rrapa nipa burr-wengganana, aburr-jurnjinga. ");
INSERT INTO bvr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Barrwa ana-jekarra ana-jirrapa ana-ngardapa ana-goma, lika nipa a-yinagata burrwa, “Awa! Nyiburr-gurda mu-nguy nyiburr-yurra rrapa nyiburr-ngeknga nyiburr-yurra, ya? Ganapiya! Gun-nardiya gugu gun-balmapa gu-jirra. Minyja bubi-na, an-guna An-walkurpa An-gugaliya gugu abi-rrima barra burrbu-wu gu-galiya yerrcha aburr-gata aburr-werra. ");
INSERT INTO bvr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Buburr-garlma barra nguburr-boy. Bubi-na an-guna nguna-bawuna, nipa burr-ganyja gurda ana-bamburda barra ngunabi-rrima!” ");
INSERT INTO bvr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Gun-gatiya waypa Jesus a-yinagata a-wena burrwa a-ni, gugu Jurrach a-bena, mu-ngoyurra Jesus an-nika jawina a-ni. Minypa aburr-jaranga burr-ganyja gurda an-gujarrcha abi-rrimarra rrapa gun-jong gubi-rrimarra, aburr-gata burrbi-jerrmarra gurda birripa aburr-gatiya wana junggay yerrcha rrapa joborr marn․gi aburr-gunega rrapa aburr-werranga burr-guta mu-murna yerrcha. ");
INSERT INTO bvr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jurrach nipa an-gata mu-ngoyurra a-bawuna a-bona Jesus, nipiya a-guguyana burrwa ana-bona, gipa mu-ngoyurra a-wena burrwa, a-yinagata, “Ngaypa ngu-macha barra an-gugaliya, an-gatiya nyibi-rrima barra nyibu-ga nyiburr-boy.” ");
INSERT INTO bvr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Lika nipa Jurrach jechinuwa ana-bonapa a-bena nula Jesus. Lika a-yinanga, “A-lay, Bunggawa!” lika a-machinga. ");
INSERT INTO bvr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Lika aburr-gata Jurrach burr-ganyja gurda ana-bamuna, birripa burr-guya abi-rrimarra Jesus. ");
INSERT INTO bvr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Wurra aburr-gata wugupa nula Jesus aburr-jinyja, ana-ngardapa barrang a-warrkarra, lika a-garlmunapa a-jarrchinga gelama a-jirra an-gata junggay wana an-babalapa an-nika an-mujama. ");
INSERT INTO bvr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Lika Jesus a-garlmuna, a-wena burrwa. “Nyiburr-gurda ana-goyburrpa, an-nga nula nyiburr-bona gurda barrang burr-guta rrapa gun-jong burr-guta barra ngunabi-rrima? Wurra ana-goyburrpa bama nyiburr-yinanga jimarna ngaypa ngu-bachirra, ya? ");
INSERT INTO bvr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wurra ngaypa ngu-jaranga ng-goma ng-gatiya wugupa ana-gorrburrwa, Wangarr gun-nika gu-japurra rrawa marn․gi marn․gi arr-nenga ngu-nirra ngu-workiya janguny, wurra gala ana-goyburrpa ngunabi-rrima. Wurra jarra nipa gun-guniya gu-bena minypa janguny mu-jurra gu-yurra.” ");
INSERT INTO bvr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jesus a-yinagata a-wena burrwa aburr-gata aburr-bachirra nula, lika gu-gata wenga aburr-yigipa jawina abu-bawuna, aburr-yurtchinga aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","An-ngardapa an-yawarriny a-jurrjurrmurra a-bona Jesus, nipa an-nyagara mirikal, wurra mun-ngardapiya wupa a-barrngumurra. Nipa jimarn jarra abi-rrimangarna aburr-gata aburr-bachirra, ");
INSERT INTO bvr_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","wurra mun-gata mirikal a-garlmunapa m-bawuna burrwa, lika an-nyagara a-yurtchinga a-ni. ");
INSERT INTO bvr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Lika abu-ganyja Jesus gun-gata junggay wana an-babalapa gun-nika bala, gatiya birripa wana junggay yerrcha rrapa aburr-werranga mu-murna yerrcha rrapa mola joborr marn․gi aburr-gunega gu-ngardapa aburr-negiyana aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Wurra Birta jurdach ana-jurrjurrmurra ana-bona Jesus, lika gun-gata junggay wana an-babalapa gun-nika rrawa a-bena, lika aburr-gata junggay wana an-babalapa burr-yika aburr-mujama a-rakaja burrwa, lika a-ngarnbuna a-ni. ");
INSERT INTO bvr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Rrapa gata wupa gu-bala aburr-gata wana junggay yerrcha rrapa ganychila (councillor) yerrcha, birripa jimarna barra abirri-jirrapa abirri-ngurrja Jesus minypa gun-gata gun-ganawa butula janguny bitipa abirri-ngurrja, minypa gu-gurda ngacha burrwa joborr barra minypa mari gubu-garra nula rrapa abu-bu; wurra gala gun-nga gubu-barripungarna janguny. ");
INSERT INTO bvr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Minypa aburr-jaranga abu-ngurrjinga aburr-ni, wurra jarra gun-birripa janguny ngardapa ngardapa. ");
INSERT INTO bvr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Lika aburr-werranga aburr-garlmuna, abu-ngurrjinga Jesus, ");
INSERT INTO bvr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","aburr-yinanga, “Ngayburrpa nyiburr-galiyarra nula nipa a-yinagata, ‘Gun-guna bala Wangarr gun-nika ana-gugaliya gu-jarlapuna, ngaypa barra ngu-rruma, lika ngorrngurra abirri-jirrapa gun-ngardapa wupa ngaypa barra gun-nerranga ngu-jarlapa gala an-gugaliya gu-jarlapungarna.’” ");
INSERT INTO bvr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Aburr-yinagata abu-ngurrjinga, wurra gun-birripa rrapa janguny aburr-wena ngardapa ngardapa. ");
INSERT INTO bvr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Lika an-gata junggay wana an-babalapa a-garlmuna, gojilapa a-jinyja aburr-gata aburr-ni, lika a-yinagata nula Jesus, “Nginyipa gala gun-nga wengga n-dima rraka ny-yengga, ya? Wurra gun-gata gun-nga birripa aburr-guna minypa bubu-ngurrjinga aburr-nirra?” ");
INSERT INTO bvr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Wurra Jesus bamawa a-ji; gala gun-nga a-weyarna. Barrwa nipa junggay wana an-babalapa a-wengganana Jesus, “Ya? Ny-jurda nginyipa Christ, Ny-yalkurpa nula Wangarr biy-yika?” ");
INSERT INTO bvr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nipa Jesus a-yinagata, “Ngaw, ngaypiya. Rrapa ana-goyburrpa nyibi-na barra an-guna An-walkurpa An-gugaliya ana-munganaguwa Wana An-babalapa ana-gera a-ninya barra rrapa waykin wenga gu-nguparr minypa ana-jeka barra.” ");
INSERT INTO bvr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Gun-narda nipa junggay wana an-babalapa a-galiyana, lika mun-nigipiya mirikal mu-gorndanga a-ni minypa nipa gochila a-barrjinga. Lika a-yinagata, “Ganapiya. Gala barrwa jal nguburr-ni ana-nga barra a-ngurrja arrburrwa an-guna! ");
INSERT INTO bvr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Wurra ana-goyburrpa gipa nyiburr-galiyana nula nipa gun-nerra a-wena rrapa wana a-negiyana nula Wangarr. Wurra nyiburr-yinmiya ana-goyburrpa nyibu-borrwuja? Nguburr-yinmiya barra nula?” Birripa aburr-yinanga, “Nipa wupa a-barrbiyana, werra a-negiyana. A-juwa barra.” ");
INSERT INTO bvr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Aburr-werranga aburr-garlmuna, m-bordich abu-balkaja nipa Jesus, rrapa mipila a-jirra abu-bichinga, lika abu-buna rrapa aburr-wena nula, “Marrka ngurrja. Ana-nga biy-buna?” Birripa aburr-yinagata nula Jesus, lika aburr-gata junggay wana an-babalapa burr-yika aburr-mujama abu-menga, abu-buna aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Wurra Birta burdak yarlanga a-ninya, lika an-gata junggay wana an-babalapa jin-nika jin-mujama jiny-jarl jiny-bamuna, ");
INSERT INTO bvr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","a-nana Birta a-ngarnbuna a-ni. Lika galginy jinyu-derichinga a-nana jiny-bamuna, lika jiny-yena nula, “A-lay, nginyipa burr-guta an-gata Nejarach an-guyinda wugupa nyiburr-rrigirrgnga.” Jiny-yinagata nula. ");
INSERT INTO bvr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Wurra nipa Birta a-jordajiyana, a-yinanga, “A-jay, gun-nga ny-yeya ny-boya?” Lika a-garlmuna, a-jarl a-bamuna rrawa gu-gera. ");
INSERT INTO bvr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Gatiya lika jin-mujama a-nana nipa a-jinyja, lika jiny-jarlmuna, jiny-yena burrwa aburr-gata aburr-werranga, “An-narda an-ngardapa wugupa aburr-rrigirrgnga.” ");
INSERT INTO bvr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Wurra Birta barrwa a-jordajiyana. Lika gun-baykarda ngika, lika aburr-gata aburr-jinyja aburr-yinanga nula Birta, “A-lay, nginyipa gala ny-yinmiya ny-jordajiya. Wurra ny-jurdiya nginyipa burr-guta an-gata nyiburr-rrigirrgnga nyiburr-workiya, ngardawa nginyipa Galali nyi-guyinda, ngarla!” ");
INSERT INTO bvr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Wurra Birta a-yinagata, “Ngaypa gun-burral ngu-weya ana-gorrburrwa, gala ngu-yinmiya ngu-jordajiya; galapa Wangarr nguna-bun! Wurra nipa an-gata an-gugaliya ana-goyburrpa nyibu-ngurrjinga ngaypa gala marn․gi nula.” ");
INSERT INTO bvr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Lika gu-gata wenga bawul gugu ji-jirrapa ji-goma gu-negarra nipa jiny-yena, lika Birta gu-borrwurra nipa Jesus geka a-yinmiyana a-wena nula, minypa a-yinagata nula, “Gala barra bawul ni-gugu jiny-yengga, wurra jarra nginyi-gugu ny-jirrapa ny-nyardapa ny-joma ny-jordajiya burrwa, jimarna gala marn․gi apula, rrapa nuwurra jurdach bawul jiny-yengga barra.” Gu-gatiya wenga lika nipa Birta burr-guya a-rruwujana. ");
INSERT INTO bvr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ana-munyagaba aburr-gata wana junggay yerrcha rrapa mola mu-murna yerrcha rrapa joborr marn․gi aburr-gunega, ganychila (councillor) yerrcha aburr-gata aburr-bulapalawa, birripa wengga gubu-buna aburr-ni, ganapiya, lika gubi-yagurrmurra. Jesus lika abu-bichinga an-gubandawiya jirn (chain), lika abu-ganyja, abu-wuna Baylat (Pilate) an-gata Rowm wenga gapman an-guyinda bunggawa. ");
INSERT INTO bvr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Lika nipa Baylat a-garlmuna, a-wengganana Jesus, minypa a-yinanga nula, “A-lay, aburr-gaba nginyipa bunggawa burrwa Ju yerrcha, ya?” Nipa Jesus a-wena, “Ngaw. Gun-narda ny-yena gun-burral.” ");
INSERT INTO bvr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Wurra aburr-gata wana junggay yerrcha jonama abu-ngurrjingapa aburr-ni gun-jaranga nipa Jesus minypa mari gubu-garrana nula. ");
INSERT INTO bvr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Lika barrwa Baylat a-wengganana, “A-lay, yama ny-yengga? Wurra ny-jaliyarra burrwa nyi-nirra birripa gun-jaranga bubu-ngurrjinga aburr-nirra.” ");
INSERT INTO bvr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Wurra Jesus gala barrwa gun-nga a-weyarna, wurra bamawa a-jinyja. Lika Baylat gochila a-barrjinga nula. ");
INSERT INTO bvr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gun-gata janara gu-ji burrwa gu-workiyana Yichrayal (Israel) yerrcha, nipa an-gata Baylat gu-lapkujamurra burrwa a-workiyana, an-ngardapa brichina (prisoner) a-jerrmarra burrwa a-workiyana, ana-nga birripa jal aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Rrapa an-ngardapa an-gugaliya an-nelangga Burébach (Barabbas), nipa wugupa burrwa aburr-jaranga wupa aburr-ni brichina minypa gipa mu-ngoyurra aburr-garlmuna, gapman yerrcha burrbu-buna, jimarna barra gubu-ngukurdanyja. ");
INSERT INTO bvr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ganapiya, lika wurra gama gorlk aburr-garlmuna, abu-wengganana Baylat minypa nipa wolawola an-ngardapa a-jerrmarra burrwa a-workiyana. ");
INSERT INTO bvr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Lika Baylat a-garlmuna, a-wena burrwa, “Ana-goyburrpa jal nyiburr-nirra barra ngaypa arr-wu an-gaba ana-goyburrpa Ju yerrcha nyibu-ngurrjinga bunggawa, ya?” ");
INSERT INTO bvr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","A-yinagata burr-wengganana, ngardawa nipa marn․gi minypa aburr-gata wana junggay yerrcha mu-werrmbarra abi-nana Jesus, rrapa minypa gu-gurda nula birripa abu-ganyja gurda lika abu-wuna. ");
INSERT INTO bvr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Wurra aburr-gata wana junggay yerrcha burrbu-jurnajuchuwurra wurra gama gorlk barra Baylat aburr-ngiwija nula barra burr-wu an-gata Burébach. ");
INSERT INTO bvr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Baylat barrwa a-wena burrwa wurra gama gorlk, a-yinagata, “Wurra ngu-yinmiya barra nula an-gaba ana-goyburrpa Ju yerrcha nyibu-ngurrjinga nyiburr-workiya bunggawa?” ");
INSERT INTO bvr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wurra birripa abu-marawarrbuna, “An-narda bupa! Burr-jong nega rra!” ");
INSERT INTO bvr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Wurra nipa a-yinagata, “An-nga nula? Nipa a-yinmiyana jama a-ji gun-nerra?” Wurra birripa burr-guya aburr-gonyjinga, “Burr-jong negapa rra!” ");
INSERT INTO bvr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Lika nipa Baylat ngardawa jal a-ni aburr-gata wurra gama gorlk barra aburr-japurramaya nula, lika nipa gu-lapkujamurra burrwa, ana-jerrmarra burrwa an-gata Burébach. Lika aburr-yigipa an-dakal Baylat burr-yika, nipa burr-wuna Jesus barra abu-jurrburaykujama, abu-ga, burr-jong abi-nega abi-rra, abu-wenyaga. ");
INSERT INTO bvr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Lika aburr-gata an-dakal abu-menga Jesus, abu-ganyja wupa gun-gata gu-bala bunggawa gun-nika, lika aburr-gonyjinga burrwa, warrpam aburr-gata an-dakal aburr-mulpiyana gurda. ");
INSERT INTO bvr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Lika Jesus abu-barrbuna mirikal maningan mu-maya mun-gata minypa bunggawa an-guyinda a-barrngumiya a-workiya. Rrapa barrwa bornangguna jibi-jarlapuna nula bama a-jirra minypa gun-maywapa an-mumurna an-guyinda bunggawa gun-nika ana-bama gu-garraja a-workiya wurpa jin-darrartka, lika jibu-barnjinga nula ana-jawurrga. ");
INSERT INTO bvr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Rrapa abu-borrkpuna aburr-ni, minypa aburr-merndagarlmuna nula, aburr-yinanga nula, “Awa! Ny-junarda ny-molamola, ya, ny-junardiya Bunggawa Ju yerrcha ny-burriya?” ");
INSERT INTO bvr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Lika aburr-garlmuna, abu-buna bama a-jirra gu-jong gu-guyinda, rrapa m-bordich abu-balkaja; rrapa aburr-menama gubi-rrana nula, gu-wakal abu-buna jimarn jarra aburr-marrngoypiyarna nula. ");
INSERT INTO bvr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ganapiya gun-gata minypa abu-borrkpuna aburr-ni, lika mbi-yerrkujamurra nula mun-gata mirikal maningan mu-maya, lika mun-nigipa wupa Jesus mun-nika abu-jolartchinga. Lika abu-ganyja aburr-bena gugu barra burr-jong abi-negapa abi-rra. ");
INSERT INTO bvr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Gu-gata wenga aburr-bamuna gurda, abi-nana an-gugaliya an-nelangga Jayman (Simon), nipa an-gata an-jirrpungapa butula Alikchénda (Alexander) rrapa Rupach (Rufus). Nipa jimarn jarra bama a-yinanga yi-gata a-boyarna rrawa gu-jirra gu-boya, nipa gu-gata ana-garlmuna gu-mugarla wenga, wurra aburr-gata an-dakal abi-rrimarra Jayman barra nipa gun-gata a-bamiya gun-jong Jesus gun-nika. Nipa an-gata Jayman, nipa Jayríny (Cyrene) an-guyinda. ");
INSERT INTO bvr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Lika aburr-gata an-dakal, birripa abu-ganyja gurda aburr-bamuna nipa an-gata Jesus gun-gata rrawa gun-nelangga Golgócha (Golgotha), minypa ngayburrpa ngubu-ngurrjinga nguburr-workiya, nguburr-yinaga, “An-mama bama a-jirra a-yurrapa.” ");
INSERT INTO bvr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Gatiya lika birripa jimarn jarra abu-wucharna wayin (wine) mu-ngoyurra mbi-barnjinga jirrkilja mun-gurrimiya mun-nelangga mur (myrrh), wurra nipa Jesus gala mu-manggarna, m-bangarna. ");
INSERT INTO bvr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Lika burr-jong abi-negarra abi-rrana, lika mbi-menga mun-nigipa mirikal, lika aburr-dawurrjinga aburr-ni mun-nga mun-gata ana-nga mu-ma barra. ");
INSERT INTO bvr_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nipa gugu marnnga jina-darrjinga, ngulamgaba burr-jong abi-rrana, abu-garrana, ");
INSERT INTO bvr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","rrapa mun-gata jurra gatiya m-balcha mu-yu, minypa mu-yinagata, “AN-GUNA BUNGGAWA JU YERRCHA AN-BURRIYA.” ");
INSERT INTO bvr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Rrapa gatiya burr-jong burrbi-negarrapa burrbi-rrana abirri-jirrapa abirri-ngumurda, wugupa nula Jesus gata aburr-balcha aburr-yu ngardapa ngardapa, an-ngardapa ana-munganaguwa rrapa an-nerranga ana-weyka. ");
INSERT INTO bvr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Aburr-jaranga gu-galiya yerrcha abu-beybeybana aburr-ji Jesus, minypa rreymarreyma aburr-ngorrkiyana rrapa gun-bachirra aburr-wena nula, “Awa! Ny-jurdiya nginyipa jimarna barra n-duma gun-gata bala Wangarr gun-nika gun-japurra rrapa minypa nuwurra ngorrngurra abirri-jirrapa gun-ngardapa wupa mola ny-jarlapa! ");
INSERT INTO bvr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Wurra marrka nyina-bupiya gu-gata wenga gu-jong rrapa jarlapiya nginyipa wupa!” ");
INSERT INTO bvr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Rrapa aburr-gata wana junggay yerrcha rrapa joborr marn․gi aburr-gunega, birripa aburr-yinagatiya abu-borrkpuna aburr-ni Jesus. Minypa aburr-wena aburr-ni gu-gapa gu-guta, aburr-yinanga, “An-guna wanngu burr-negarra aburr-werranga, wurra nipa gala a-yinmiya wanngu a-negiya an-nardiya, ya? ");
INSERT INTO bvr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Marrka yama ngayburrpa ngubi-na an-guna Christ, nipa Bunggawa Yichrayal an-guyinda gun-guniya geka barra ana-bupiya gu-gata wenga gu-jong gu-guyinda, barra ngayburrpa marr nguburr-balcha nula.” Aburr-yinagata aburr-wena. Rrapa abirri-gata abirri-jirrapa abirri-balcha abirri-yu wugupa nula Jesus, bitipa abirri-yinagatiya rrapa abirri-borrkpuna. ");
INSERT INTO bvr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Gun-gatiya lika marnnga waykin jiny-ji minypa gojilapa nguburr-bama jiny-jirra jiny-yorkiya, wurra gun-gata rrawa gu-yurra gu-boya gu-garlmunapa, an-munya gu-mayana, nuwurra marnnga jiny-jakiyana minypa jarlawurr mula gu-jirra gu-jinyjarra jiny-jinyja. ");
INSERT INTO bvr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Gun-gatiya 3 o'clock gu-ni, lika Jesus waykin a-gonyjinga, minypa gun-birripa wengga a-yinanga, “Yiluway, Yiluway, lama jabaktáni?” minypa ngayburrpa nguburr-yinaga, “Ny-jurda ny-nyaypa Wangarr, ngaypa an-nga nula nguna-bawuna?” ");
INSERT INTO bvr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Gatiya gu-galiya yerrcha aburr-jinyja, aburr-galiyana nula a-gonyjinga, lika aburr-yinanga, “Aaa, marrka nguburr-galiya nula, nipa a-gonyjinga nula Yiláyja (Elijah)!” ");
INSERT INTO bvr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Lika an-ngardapa an-gugaliya ana-yurtchinga, a-menga an-nyarlkuch an-guyinda ana-wargara an-gata minypa gu-balanda sponge, lika a-gurragaja wayin (wine) mun-guralba mun-gata minypa biniga (vinegar), lika gu-jong gu-guyinda a-jarrkarrana, lika ngana a-wuna Jesus. Rrapa minypa a-yinanga burrwa aburr-gata, “Marrka burdak ngubi-na jimarn jarrapa Yiláyja ana-bupiyan, an-guna a-man gu-gata wenga gu-jong.” ");
INSERT INTO bvr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Barrwa Jesus burr-guya a-gonyjinga, lika a-juwuna. ");
INSERT INTO bvr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Rrapa wupa gu-bala Wangarr gun-nika gun-japurra, mun-gata mirikal m-balcha mu-yu mu-garlmunapa mu-yerayeragujamiyana mu-yurtchingapa waykin wenga gu-jel. ");
INSERT INTO bvr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Rrapa an-gata minypa an-dakal a-ganyja a-workiyana, nipa gatiya ana-gochila a-jinyja Jesus a-balcha a-yu. Rrapa nipa waypa a-galiyana Jesus a-gonyjinga rrapa a-nana a-yinmiyana a-juwuna, lika a-yinanga, “Gun-burral an-guna Wangarr an-nika An-walkurpa!” ");
INSERT INTO bvr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Rrapa mu-gama yerrcha gatiya gu-balay wenga gubi-nana gurda aburr-ji, jin-ngardapa jin-gata Meri Mektaliny (Mary Magdalene), rrapa jin-nerranga jin-gata Meri nipa mampa buta Jeymch (James) an-delipa rrapa Jochach (Joses) an-murnangana, rrapa barrwa jin-nerranga jin-gata jin-nelangga Jalómi (Salome), ");
INSERT INTO bvr_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","aburr-gurdiya minypa mu-ngoyurra abu-jurrjurrmurra aburr-workiyana Jesus rrapa aburr-gunggajinga nula aburr-workiyana, nipa gata a-rrigirrgarra a-workiyana Galali. Rrapa aburr-werranga mu-gama yerrcha burr-guta minypa mu-ngoyurra Jesus wugupa aburr-bona gurda Jirúchalam, birripa gata gu-balay wenga abi-nana gurda aburr-ji Jesus a-juwuna. ");
INSERT INTO bvr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Gu-gatiya wenga minypa marnnga jiy-bungguna jiy-bamuna, rrapa minypa nawanawa aburr-ni gun-gata minypa ngulam barra Jarradi gu-ni aburr-ngeka barra aburr-ni, ");
INSERT INTO bvr_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","lika Jochap (Joseph) an-gata Aramatíya (Arimathea) an-guyinda, nipa a-garlmuna, derta a-negiyana, lika a-jarl a-bamuna, a-wengganana Baylat an-gata nula Jesus an-burral mu-ngoyurra a-juwuna. Birripa Ju yerrcha ganychila, nipa Jochap an-ngardapa mu-ngoyurra a-jirra burrwa, nipa a-ganana a-ni Wangarr ana-jerrmarrapa gu-yinpa barra Bunggawa a-ni. ");
INSERT INTO bvr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Gun-gatiya Jochap a-wengganana Baylat, wurra Baylat gochila a-barrjinga gun-gata nipa a-galiyana Jesus gipa gugu a-juwuna. Lika nipa a-gonyjinga nula an-nigipa an-gata minypa an-dakal a-ganyja a-workiyana, jimarn jarrapa gun-burral gipa mu-ngoyurra Jesus a-juwuna. ");
INSERT INTO bvr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Gun-gatiya a-galiyana an-gata an-dakal a-ganyja a-workiyana a-wena nula gun-burral Jesus gipa mu-ngoyurra a-juwuna, lika Baylat a-wena nula Jochap barra a-ma. ");
INSERT INTO bvr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Lika gu-gata wenga Jochap muna-ganyja mirikal linan (linen) mu-maya mun-gungarlcha, lika a-menga, ana-ganyja ana-bupiyana, Jesus an-burral a-bichinga mirikal mu-guyinda, lika a-ganyja, a-gurrmurra gata wupa gu-ngarnama gu-gurrema gipa mu-ngoyurra aburr-gapajinga. Lika jandarra gubu-gakaja gurda, ngana gubu-jakabuna, ");
INSERT INTO bvr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","wurra Meri Mektaliny rrapa Meri mampa niya Jochach burrbi-nana abirriny-ji Jesus yina gaya abu-gurrmurra. ");
INSERT INTO bvr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Gun-gata lika nuwurra Jarradi (Saturday) gu-wulebiyana, lika aburr-gata Meri Mektaliny (Mary Magdalene) rrapa Meri mampa niya Jeymch (James) rrapa jin-gata Jalómi (Salome) burr-guta, birripa aburr-garlmuna, mbi-ganyja gurda aburr-bona mun-gata mun-gungimiya mun-molamola mun-gungolkuja barra nipa Jesus an-burral abu-ngima. ");
INSERT INTO bvr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Gun-gatiya minypa guna-gepana Jandi (Sunday), birripa aburr-jarl gurda aburr-bamuna gu-gurrema nipa Jesus abu-jolartchingapa. ");
INSERT INTO bvr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Wurra minypa aburr-wengganachichiyana aburr-ni, “A-jay, ana-nga barra gu-gaka arrburrwa jandarra gun-gata ngana gu-jirra gubu-jakabunapa?” ");
INSERT INTO bvr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Wurra lika aburr-ganana, gubi-nana gu-lapkujamiyana gu-ji minypa an-nerranga gipa gu-gakaja gun-gata wana gun-bapala jandarra. ");
INSERT INTO bvr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Lika aburr-barrngumurra wupa gu-ngarnama gu-gurrema, lika abi-nana an-yawarriny gatiya a-ninya arr-munganaguwa nipa mun-gungarlcha a-barrngumurra a-ni. Lika birripa aburr-gurkuja aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Wurra nipa a-yinanga burrwa, “Ganapa buburr-gurkuja. Wurra ana-goyburrpa Jesus nyibi-jenanga, Nejarach (Nazareth) an-guyinda an-gata nipa burr-jong abi-nenga abi-rracha. Wurra nipa gugu a-molamiyana; gala a-ni an-guna. Minyja bubi-na an-gapulga; ngunyuna abu-gurrmunga. ");
INSERT INTO bvr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Lika buburr-boy, buburr-wengga burrwa aburr-yigipa jawina nipa Birta burr-guta. Nipa Jesus mu-ngoyurra a-bona ana-gorrburrwa gun-gata Galali (Galilee). Gatiya barra nyibi-na minypa gipa mu-ngoyurra a-weya ana-gorrburrwa.” A-yinagata an-gata a-wena burrwa. ");
INSERT INTO bvr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Lika aburr-bena yarlanga, lika aburr-yurtchinga aburr-ni, gochila aburr-barrjinga rrapa aburr-wurrwurrjinga. Gala ana-nga aburr-weyarna nula, wurra burr-guya aburr-gurkuja. Gun-guna jurdach gu-yurra janguny, Mark 16:9-20, gala gu-yu mu-werranga mu-jurra mun-gata burr-guya mun-maywa mun-guwarr mun-guyinda. Waygaji ana-werranga a-wukurrjinga, Mark an-nyagara. ");
INSERT INTO bvr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Gun-gata nipa Jesus a-molamiyana Jandi ana-munyagaba, lika Meri Mektaliny mu-ngoyurra a-bena achila, jin-gata nipa walkwalk a-rrimarra arr-ngardapa arr-murna rrapa abirri-jirrapa gipa mu-ngoyurra nipa Jesus a-yerrnyjinga achila. ");
INSERT INTO bvr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Lika birripa aburr-gata Jesus abu-borrwurra aburr-ni rrapa aburr-rruwujana, nipa Meri Mektaliny jiny-bona, jiny-yena burrwa. ");
INSERT INTO bvr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Wurra birripa gun-gata aburr-galiyana achila nipa jiny-yena Jesus a-molamiyana rrapa nipa a-nana, wurra birripa gala marr aburr-balcharrarna achila. ");
INSERT INTO bvr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Gu-gata wenga nipa Jesus abirri-jirrapa a-bena butula gun-gata gu-jarlakarr abirri-bamuna gun-bitipa rrawa gu-mugarla gu-jirra. ");
INSERT INTO bvr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Lika abirri-jekarra gurda, abirri-wena burrwa aburr-gata aburr-werranga Jesus burr-yika, wurra birripa gala marr aburr-balcharrarna butula, gun-maywapa minypa jin-gata Meri Mektaliny gala marr aburr-balcharrarna achila. ");
INSERT INTO bvr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Gu-gata wenga Jesus a-bena burrwa aburr-yigipa jawina arr-gulirrwirrka arr-murna rrapa an-ngardapa, minypa 11 gu-galiya yerrcha. Gatiya mbi-barra aburr-ni balaja nipa a-bena burrwa, lika burr-jonga a-ni ngardawa mun-birripa mun-molma mun-derta mun-gorla burrwa, minypa gala marr aburr-balcharrarna burrwa aburr-gata mu-ngoyurra abi-nana nipa a-molamiyana. ");
INSERT INTO bvr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Lika nipa a-yinagata burrwa, “Buburr-boy, gun-ngaypa gun-molamola janguny bubu-ngurrja burrwa wurra gama gorlk gun-nardiya rrawa gu-jirra gu-boya. ");
INSERT INTO bvr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Minyja ana-nga an-gata marr a-balcha apula rrapa ngaypa ngu-welangga bama nyibu-gurraga, an-gata an-gugaliya wanngu a-nipa barra a-workiya. Wurra minyja ana-nga an-gata gala marr a-balcha apula, an-gata an-gugaliya barra barrwa guna-bamburda ngorrngurra ngaypa burr-mari ngu-wengga nula. ");
INSERT INTO bvr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aburr-gata aburr-nga marr aburr-balcha apula, birripa barra ganyjarr gubu-ma barra walkwalk abi-yerrnyja burrwa aburr-boy wurra gama gorlk, ngardawa ngaypa ngu-welangga wana ngu-babalapa; rrapa wengga gun-nerranga birripa gala marn․gi, wurra aburr-wengga barra. ");
INSERT INTO bvr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Rrapa minyja waygaji birripa nguymbula abi-rrima rrapa waygaji mun-nerra mun-gapa mbi-bay, wurra gala mu-yinmiya rrapa gala a-yinmiya burr-bu. Rrapa aburr-gurderda burrbi-rrima barra aburr-molamiya barra.” ");
INSERT INTO bvr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Gatiya waypa Bunggawa nipa Jesus a-wena burrwa a-ni, lika nipa Wangarr ana-nyala a-menga, a-ganyja waykin, lika gata nipa a-rakaja Wangarr ana-gera ana-munganaguwa. ");
INSERT INTO bvr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ganapiya, lika Jesus burr-yika jawina gun-nigipa janguny gubu-ngurrjinga aburr-bona balaypalay, rrapa nipiya Bunggawa wugupa burrwa gun-nigipa janguny gun-burral gu-negarra, minypa wurra gama gorlk burrbi-nana burr-barlmarrk jama aburr-ji. ");
INSERT INTO bvr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Aburr-jaranga gipa aburr-garlmuna, aburr-wukurrjinga janguny gun-gata minypa ngayburrpa gun-guniya jurdach nguburr-ninyarra gun-burral gu-bena arrburrwa Wangarr mu-ngoyurra gochila an-dana — ");
INSERT INTO bvr_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","gu-gata ngacha janguny minypa Jesus a-garlmunapa jama a-ji birripa aburr-gatiya gubi-nana rrapa gipa gubu-ngurrjinga arrburrwa aburr-workiyana. ");
INSERT INTO bvr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Wurra Jiyápalach (Theophilus), a-lay, japurra ngapa ny-jirra, ngaypa ng-gunaga ngardawa gipa gun-baykarda ngaypa marn․gi ngu-ni gun-guna janguny rrapa galginy ngu-derichinga, ngaypa ngu-borrwurra gun-molamola minyja ngaypa ngu-wukurrjinga nggula gun-nginyipa gun-guna janguny rrapa yarlanga ngu-nega, ");
INSERT INTO bvr_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","barra burr-guya marn․gi nyi-ni gun-gata janguny nginyipa gipa ny-jaliyana. ");
INSERT INTO bvr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Gun-gatiya Ayrat (Herod) nipa bunggawa a-ni gun-gata rrawa Judíya (Judea), an-ngardapa junggay an-gata an-nelangga Jekaráya (Zechariah), nipa junggay a-ni minypa aburr-gata wugupa junggay aburr-ni an-birripa mu-ngoyurra an-guyinda an-gata Abáyja (Abijah) jama a-ji gun-gata minypa nipa murna burr-wuna. Nipa Jekaráya rrapa jin-nigipa jin-gumarrbipa niya, birrinyjipa wugupa Aran (Aaron) abirriny-bapurr, nipa jin-gata jin-nelangga Yilíchabat (Elizabeth). ");
INSERT INTO bvr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Rrapa Wangarr gu-borrwurra burrinyjula a-ni minypa birrinyjipa abirriny-molamola, minypa burr-guya gubirriny-borrwurra nula abirrinyu-ni gun-nigipa wengga rrapa joborr gun-guyinda. ");
INSERT INTO bvr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Wurra birrinyjipa abirriny-jata gala an-delipa abirrin-dimangarna, wurra gun-nyagara. Ngardawa nipa Yilíchabat gala jiny-yinmiyarna a-manggarna, aa ganapiya, gipa gugu gapula abirrinyu-ni. ");
INSERT INTO bvr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Gun-gatiya nipa Jekaráya jama a-ji minypa nipa junggay a-ni gun-gata Wangarr gun-nika bala gun-japurra rrapa aburr-yigipa wugupa nula junggay, ");
INSERT INTO bvr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","birripa minypa aburr-ngunyangunyjiyana minypa wolawola aburr-ngunyangunyjiyana aburr-workiyana nipa Wangarr jama a-wu barra ana-nga. Rrapa gun-gatiya gugu nipa Wangarr a-menga Jekaráya, barra nipa Jekaráya a-boy wupa gun-japurra gu-bala Wangarr gun-nika, rrapa minypa nipa gatiya wupa mu-yalpa barra nula mun-molamola mun-gungolkuja barra gu-garlma gu-yu jolnga gun-molamola. ");
INSERT INTO bvr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Rrapa gun-gatiya nipa Jekaráya a-barrngumurra wupa gu-bala barra mu-yalpa nula Wangarr mun-nigipa mun-gata rrapa minypa gun-molamola gu-ngolkuja, aburr-jaranga wurra gama gorlk yarlanga aburr-ji rrapa abu-wengganana aburr-ni Nyanyapa arrku waykin a-nirra. ");
INSERT INTO bvr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Rrapa belabila gu-maya gun-gata wupa gu-jirra, gatiya minypa mbi-yalpurda aburr-workiya mun-gata mun-molamola mun-gungolkuja, gatiya gugu arr-munganaguwa gu-gera a-jinyja waykin an-guyinda an-mujaruk. ");
INSERT INTO bvr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jekaráya nipa gochila a-barrjinga gun-gata nipa a-nana an-gata waykin an-guyinda an-mujaruk, rrapa minypa burr-guya a-gurkuja. ");
INSERT INTO bvr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Wurra an-gata waykin an-guyinda an-mujaruk a-yinanga a-wena nula, “Gala barra ny-jurkuja, a-lay, Jekaráya. Wurra Wangarr a-galiyana ngguluwa nginyipa ny-yengganana, rrapa nipa Yilíchabat a-ma barra an-delipa an-nginyipa, rrapa nginyipa an-nelangga ny-jarra barra Jon (John). ");
INSERT INTO bvr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nginyipa minypa burr-guya ny-marrkapcha barra nula, rrapa aburr-marrkapcha barra aburr-jaranga gu-galiya yerrcha ngardawa nipa a-bambungguna. ");
INSERT INTO bvr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ngardawa Wangarr gu-borrwa barra nula minypa nipa wana. Nipa gala barra m-bay mun-gata gurnal mun-girra minypa wayin (wine) rrapa minypa mun-nerranga mun-bachirra mun-guyinda nganicha, wurra jarra an-gata delipa nipa Mern An-mawunga barra a-barrnguma nula nipa ji-gochila a-nirra. ");
INSERT INTO bvr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nipa burr-ngukurdanyja barra Yichrayal (Israel) burr-yika walkurpa niya yerrcha, aburr-jaranga marr aburr-balcha barra nula an-gata an-birripa an-ngardapiya burrwa Wangarr. ");
INSERT INTO bvr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nipa mu-ngoyurra a-boy barra nula Bunggawa, minypa nipa gu-ma barra ganyjarr gun-maywapa minypa Yiláyja (Elijah) gu-rrimarra. Nipa burr-ngukurdanyja barra, minypa jirrpungapa yerrcha barrwa jal aburr-ni barra burrwa walkurpa yerrcha, rrapa minypa aburr-gata aburr-bachirra nula Wangarr birripa barra aburr-ngukurdanyjiya rrapa gubu-borrwa barra gun-maywapa minypa aburr-werranga aburr-gata jechinuwa aburr-nirra. Minypa nginyipa ny-bokama barra delipa, nipa nawanawa burr-nega barra wurra gama gorlk nuluwa Bunggawa ana-boya, birripa barra nawanawa aburr-ni nula.” A-yinagata a-wena an-gata waykin an-guyinda an-mujaruk. ");
INSERT INTO bvr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Wurra nipa Jekaráya a-yinanga nula, “A-lay, gun-narda nginyipa ny-yena ngaypa ngu-yinmiya barra marn․gi ngu-ni ngardawa gun-burral? Wurra ngaypa rrapa jin-ngaypa jin-gumarrbipa ngapa wugupa gapula nyirrinyu-ni.” ");
INSERT INTO bvr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Wurra an-gata waykin an-guyinda an-mujaruk a-yinagata nula nipa Jekaráya, “A-lay, ngaypa ngu-welangga ng-gunaga Geybriyil (Gabriel). Ngaypa gata ngu-beya ngu-workiya nipa Wangarr a-nirra a-workiya minypa ngu-mujama ngu-nirra nula, rrapa nipa nguna-jerrmarra, ngaypa ngu-wena nggula gun-gata gun-molamola janguny delipa nula. ");
INSERT INTO bvr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Wurra gun-guniya gugu wengga gun-nyagara gu-ni barra nggula nuwurra waypa gun-gata gun-burral gu-ni barra, ngardawa nginyipa gala marr ny-balcharna apula gun-ngaypa janguny, wurra gun-nyagara. Wurra wuriya. Wurra gun-balmapa gu-ni barra, gun-gata gu-bengga barra gun-burral.” A-yinagata a-wena an-gata waykin an-guyinda an-mujaruk Geybriyil. ");
INSERT INTO bvr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Rrapa aburr-gata wurra gama gorlk aburr-ji yarlanga rrapa abu-malapuna aburr-ni Jekaráya, birripa gubu-borrwurra an-nga nula Jekaráya gun-baykarda a-ninya wupa Wangarr gun-nika bala gun-japurra. ");
INSERT INTO bvr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Rrapa nuwurra waypa nipa ana-bena yarlanga, nipa wengga gun-nyagara gu-ni nula, lika gubu-borrwurra nula minypa gata wupa nipa borrich gu-nana burrwa. Rrapa nipa murna a-jirra a-gurrmiyana burrwa ngardawa wengga gun-nyagara nula. ");
INSERT INTO bvr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Gun-gata gu-wulebana nipa Jekaráya gun-nigipa jama, lika nipa a-bona rrawa. ");
INSERT INTO bvr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Lika gu-gata wenga Jekaráya jin-nika jin-gumarrbipa niya jin-gata Yilíchabat, nipa jinyu-durtchinga yokuyoka rrapa gala jin-digirrgngarna, wurra jinyu-ni rrawa minypa ran․gu abirri-jirrapa abirri-jirrapa an-ngardapa. ");
INSERT INTO bvr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Minypa nipa jiny-yena, “Gun-guniya gugu barrwa Wangarr a-gunggajinga apula ngaypa. Minypa mu-ngoyurra ngaypa gala gu-ngarda yerrcha nguburr-manggarna rrapa gun-narda minypa ngaypa gona ngu-ni, wurra gun-guniya gugu wurra gama gorlk ngunabi-na barra ngaypa, marrban ng-gunaga ngaypa, wurra ngu-molamola.” ");
INSERT INTO bvr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Jin-gata Yilíchabat (Elizabeth) gipa jinyu-durtchinga abirri-jirrapa abirri-jirrapa abirri-jirrapa ran․gu, lika Wangarr a-jerrmarra an-gata an-maywapa waykin an-guyinda an-mujaruk Geybriyil yi-gata Galali (Galilee) gun-gata gun-delipa rrawa gun-nelangga Nejarach (Nazareth). ");
INSERT INTO bvr_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nipa a-bena achila jin-nerranga jin-gata jin-merduwa gala ana-nga jiny-manggarna, jin-gatiya ngardawa gochila gochila a-rrana nipa Jochap (Joseph) an-gata Daybit (David) an-bapurr. Nipa jin-gata jin-nelangga Meri (Mary). ");
INSERT INTO bvr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nipa Geybriyil ana-bona, a-wena achila nipa, “A-jay, ny-junardiya nipa Wangarr gun-molamola gu-borrwurra nggula rrapa nipa wugupa nggula.” ");
INSERT INTO bvr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Wurra Meri nipa burr-guya gochila jiny-barrjinga gun-gata nipa a-wena achila, rrapa nipa jiny-yechawecha gun-gata waygaji gun-nga nula. ");
INSERT INTO bvr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Wurra nipa a-yinagata achila, “A-jay, Meri, gala barra nginyipa ny-jurkuja, wurra Wangarr nipa burr-guya an-mola nggula. ");
INSERT INTO bvr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Minypa yokuyoka n-durtcha barra, rrapa ny-ma barra an-nurra nginyipa an-nelangga ny-jarra barra Jesus. ");
INSERT INTO bvr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nipa wana an-babalapa a-ni barra, rrapa wurra gama gorlk abu-ngurrja barra aburr-workiya nipa An-walkurpa Waykin A-nirra an-nika. Rrapa an-gatiya an-ngardapiya Wangarr a-gurrma barra nipa an-guna bunggawa a-ni barra minypa an-nigipa nyanyapa niya Daybit (David) bunggawa a-ni mu-ngoyurra. ");
INSERT INTO bvr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nipa an-guna ay-nipa barra ay-workiya Bunggawa burrwa Jeykap (Jacob) burr-yika gu-galiya yerrcha, aburr-gurdiya Yichrayal (Israel) aburr-bapurr. Minypa birripa aburr-nipa barra aburr-workiya nipiya ana-murna an-guniya wana an-babalapa gala ana-nga a-yinmiya a-gaka.” ");
INSERT INTO bvr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Wurra Meri jiny-yena nula an-gata waykin an-guyinda an-mujaruk, “Gun-gata gu-yinmiya barra, a-lay? Wurra ngaypa gala an-gumarrbipa ngu-rrima.” ");
INSERT INTO bvr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Wurra nipa waykin an-guyinda an-mujaruk a-wena achila, “Ngika. Wurra Mern An-mawunga a-bengga barra nggula rrapa Waykin A-nirra biy-gonyinyja barra gu-yigipa gu-ganyjarr, nyanma an-gata yokuyoka ny-ma barra nipa an-molamola warrpam, minypa wurra gama gorlk abu-ngurrja barra nipa Wangarr an-nika An-walkurpa. ");
INSERT INTO bvr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Minyja borrwa jin-gata Yilíchabat jin-borrmunga nggula jibu-ngurrjinga aburr-workiya nipa gala gu-ngarda yerrcha burr-manggarna, wurra jarra ran․gu abirri-jirrapa abirri-jirrapa abirri-jirrapa gu-ni nipa jin-narda jinyu-durtchinga yokuyoka, marrban jin-narda gapula. ");
INSERT INTO bvr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ngardawa Wangarr gala gun-nga gun-derta nula.” ");
INSERT INTO bvr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Lika Meri jiny-yena, “Ngaypa ng-gunaga ngu-mujama nula nipa an-gata Bunggawa Waykin A-nirra, rrapa minyja barra ngaypa ng-gunaga gun-gata minypa nginyipa ny-yena apula, ganapiya.” Lika nipa an-gata waykin an-guyinda an-mujaruk jiny-bawuna a-bona. ");
INSERT INTO bvr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Gu-gata wenga Meri jiny-jarlmunapa jiny-bonapa yibirrich wana gu-bapala gu-rrawa gun-nelangga Judíya rrapa gun-ngardapa rrawa bala gu-mulpiya gu-jirra yi-gatiya gu-bulgapulga gu-guyinda. ");
INSERT INTO bvr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Gatiya nipa jiny-bena Jekaráya gun-nika rrawa, lika jiny-jarlmuna, wupa jiny-barrngumurra gun-gata bala, lika jiny-yena achila nipa jin-gata Yilíchabat. ");
INSERT INTO bvr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Rrapa gun-gatiya waypa Yilíchabat jiny-jaliyana Meri jiny-yena achila, nipa an-gata yokuyoka ji-gochila ji-guyinda jiny-nyorrkaja a-ni. Lika an-gata Mern An-mawunga a-barrngumurra achila Yilíchabat ");
INSERT INTO bvr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","rrapa nipa waykin jiny-yena, jiny-yinanga, “Ngayburrpa mu-gama yerrcha, nginyipa ny-nyardapa nipa Wangarr biy-wuna ganyjarr gun-molamola, rrapa an-gata yokuyoka nginyipa ny-ma barra an-molamola warrpam. ");
INSERT INTO bvr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Wurra minypa Wangarr an-molamola apula, nipa biy-jerrmarra apula nginyipa ny-jurda mampa niya an-ngarripa Bunggawa. ");
INSERT INTO bvr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Minyjiya. Gun-guniya ngaypa ng-galiyana nginyipa ny-yena apula, an-gata yokuyoka wupa ngaypa gochila ngu-jirra nguna-ngorrkaja a-ni ngardawa nipa a-marrkapchinga a-ni. ");
INSERT INTO bvr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Rrapa nginyipa ny-jurda ny-marrkapchinga nyi-nirra, ngardawa marr ny-balcharra minypa gu-yirda barra minypa gun-gata nipa Wangarr a-wena nggula.” ");
INSERT INTO bvr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Rrapa Meri jiny-yena, “Ngaypa ng-guna ngu-ngurrnga wana an-babalapa ngu-nenga ngu-nirra an-gata Bunggawa, ");
INSERT INTO bvr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","rrapa ngu-marrkapchinga ngu-nirra nipiya nyanma Wangarr an-gatiya an-ngaypa Wanngu An-gunega. ");
INSERT INTO bvr_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ngardawa nipa nguna-borrwurra ngaypa ng-guna ngu-yigipa ngu-mujama nula wurra wuriya ngaypa ngu-delipa. Rrapa gu-gatiya wenga aburr-jaranga wurra gama gorlk rrapa barrwa aburr-nirra aburr-boya aburr-jirrawa birripa ngunabu-ngurrja barra aburr-ni ngaypa ngu-molamola. ");
INSERT INTO bvr_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ngardawa nipa an-gata Wana An-babalapa a-gunggajinga apula burr-barlmarrk, ngardawa nipa an-nelangga an-molamola warrpam. ");
INSERT INTO bvr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Wurra gama gorlk nipa a-gunggajinga burrwa a-workiya minypa mu-ngoyurra aburr-ni rrapa barrwa nguburr-gurdiya nguburr-nirra nguburr-boya, ana-nga minyja marr a-balcharra nula. ");
INSERT INTO bvr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nipa ana-ganyjarr burr-buna, mernda a-jirra ana-guyinda jama a-ji, ganday burr-negarra aburr-gata minypa gubu-borrwurra jimarna barra wana aburr-negiya birripa wupa. ");
INSERT INTO bvr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Rrapa aburr-gata wana aburr-bapala aburr-guyinda bunggawa aburr-ni aburr-workiyana, nipa burr-gakaja, birripa gugu gun-nyagara. Wurra aburr-gata aburr-nga aburr-delipa aburr-welangga, nipa a-gunggajinga burrwa, gugu aburr-welangga wana aburr-nirra. ");
INSERT INTO bvr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Rrapa aburr-gata aburr-werrmiyana, nipa gipa burr-wuna gun-molamola gun-guyinda. Wurra aburr-gata mu-ngoyurra gorlk wana gubi-rrimarra, nipa burr-yerrnyjinga mipila, aburr-nyagara aburr-bona. ");
INSERT INTO bvr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nipa gipa a-gunggajinga arrburrwa ngayburrpa nguburr-guna nguburr-yigipa nguburr-mujama nula, nguburr-gurdiya Yichrayal nguburr-bapurr. Ngardawa nipa gu-borrwurra minypa ngayburrpa nguburr-yigipa nipa barra an-mola a-ni arrburrwa. ");
INSERT INTO bvr_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Minypa nipa a-wena burrwa aburr-ngayburrpa nyanyapa arrburra yerrcha nipa an-mola ay-nipa barra ay-workiya nuluwa an-gata Aybriyam (Abraham) rrapa arrburrwa ngayburrpa nguburr-gurda nipa Aybriyam arr-bokamurra.” Jiny-yinagata Meri jiny-yena minypa jiny-marrkapchinga jinyu-ni. ");
INSERT INTO bvr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Rrapa Meri abirrinyu-ni gatiya wugupa achila Yilíchabat nuwurra abirri-jirrapa an-ngardapa an-jirderda, lika jina-jekarra gu-yigipa gu-rrawa. ");
INSERT INTO bvr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Gun-gatiya Yilíchabat a-menga yokuyoka, nipa an-gata an-nurra. ");
INSERT INTO bvr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Rrapa aburr-borrmunga achila gatiya rrawa aburr-galiyana achila nipa Wangarr burr-guya a-gunggajinga achila, lika aburr-gata wugupa achila aburr-worlworlcha aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Rrapa barrwa nipa yokuyoka minypa ngorrngurra arr-ngardapa arr-murna rrapa abirri-jirrapa gun-ngardapa gu-ni nula, birripa aburr-bona gurda aburr-ni barra nipa an-delipa majija abi-nega minypa gun-birripa gun-guwarr. Birripa jimarna gubu-borrwurra an-nelangga abu-garrajarna Jekaráya, jimarna nipa an-nelangga gu-ngardapa abirri-jirrarna nyanyapa niya. ");
INSERT INTO bvr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Wurra jin-nigipa mampa niya jiny-yinanga, “Ngika. Wurra nipa an-nelangga Jon.” ");
INSERT INTO bvr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Birripa aburr-yinanga, “A-jay, an-gata gala an-borrmunga an-nelangga a-yunya.” ");
INSERT INTO bvr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Lika aburr-murna aburr-gurrmiyana nula Jekaráya an-nga an-nelangga abu-wu barra. ");
INSERT INTO bvr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Lika nipa an-murna a-gurrmiyana burrwa birripa aburr-gata abu-wuna jurra, rrapa nipa a-wukurrjinga, “Nipa an-nelangga Jon.” Lika gun-gatiya birripa gatiya gochila aburr-barrjinga. ");
INSERT INTO bvr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Rrapa gatiya gugu Jekaráya nipa ngana a-derichinga, a-wena a-ni, a-ngurrjinga nipa Wangarr an-molamola. ");
INSERT INTO bvr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Rrapa aburr-gata aburr-jaranga wurra gama gorlk gochila aburr-barrjinga aburr-ni. Rrapa gun-gata janguny gu-barrjekarra, rrawa wana gu-bapala Judíya ");
INSERT INTO bvr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","birripa aburr-galiyana aburr-ni rrapa aburr-wengganachichiyana, “A-lay, an-guna yokuyoka an-guyinmiya ngacha, ngarla?” Aburr-yinagata aburr-wena, ngardawa yarlanga gu-yu burrwa minypa Wangarr nipa wugupa nula. ");
INSERT INTO bvr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Rrapa gun-gatiya gugu an-jirrpungapa an-gatiya Jekaráya, nipa Mern An-mawunga a-barrngumurra nula rrapa nipa gu-ngurrjinga Wangarr gun-nika janguny, a-yinanga, ");
INSERT INTO bvr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ngayburrpa barra ngubu-marrkapcha barra nula an-gata an-ngayburrpa an-ngardapiya arrburrwa Wangarr, ngayburrpa Yichrayal nguburr-bapurr. Ngardawa nipa ana-bona arrburrwa rrapa ngayburrpa nguburr-yigipa wurra gama gorlk nipa arr-jarlapuna arr-menga, mu-ngoyurra nguburr-lijiwarriyana. ");
INSERT INTO bvr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Minypa nipa a-gurrmurra arrburrwa an-ngayburrpa wana an-babalapa Wanngu An-gunega an-gatiya Daybit (David) an-bapurr, ");
INSERT INTO bvr_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","minypa janguny Wangarr burr-wuna arrburrwa aburr-yigipa aburr-mujaruk ngunyuna aburr-guyinda birripa mu-ngoyurra gun-guwarr abu-ngurrjinga aburr-workiyana. ");
INSERT INTO bvr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Minypa aburr-gata aburr-bachirra arrburrwa, rrapa minypa rreyma wupa aburr-jirra aburr-nirra arrburrwa, nipa an-ngayburrpa Wanngu An-gunega arr-jarlapa barra arr-ga ngayburrpa. ");
INSERT INTO bvr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Gu-gurda ngacha minypa barra a-gunggaja burrwa aburr-ngayburrpa nyanyapa arrburra yerrcha, minypa nipiya an-burral burrwa gochila bin-dana. ");
INSERT INTO bvr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Minypa nipa wupa an-nelangga an-burral, nipiya an-nelangga a-mayana minypa nipa gochila a-rrana an-ngayburrpa nyanyapa arrburra Aybriyam minypa nipa Wangarr barra wugupa arrburrwa ngayburrpa nguburr-gurdiya Aybriyam nguburr-yika gu-ngarda yerrcha. ");
INSERT INTO bvr_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Minypa aburr-gata aburr-bachirra arrburrwa ngayburrpa nguburr-gurdiya, nipa Wangarr a-gunggaja barra arrburrwa; ngayburrpa nguburr-molamiya barra, birripa aburr-nyagara. Rrapa minypa ngayburrpa nguburr-gurdiya jama nguburr-ji barra nula nguburr-ni, rrapa gala gun-nga barra ngubu-borrwa. ");
INSERT INTO bvr_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Minypa nguburr-yigipa wupa nguburr-nipa barra nguburr-workiya Wangarr nguburr-yika, rrapa jechinuwa nguburr-nipa barra nula. ");
INSERT INTO bvr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Rrapa nginyipa ny-jarda delipa, birripa bubu-ngurrja barra nginyipa nyi-mujaruk Waykin A-nirra biy-jerrmarra gurda. Minypa gun-nigipa janguny nginyipa ny-nyurrja barra ny-yorkiya. Ngardawa nginyipa mu-ngoyurra ny-boy barra nula an-gata Bunggawa, gatiya jarlakarr minypa nginyipa barra nawanawa nyi-ni nula, yibirrich nipa. ");
INSERT INTO bvr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nginyipa yarlanga nyi-nega barra burrwa Wangarr burr-yika gu-galiya yerrcha, minypa birripa marn․gi aburr-ni barra nipa wanngu burr-nenga minypa gun-gata nipa baywarra gu-nega barra burrwa birripa werra aburr-negiyana. ");
INSERT INTO bvr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Minypa an-ngayburrpa Wangarr burr-guya jal a-nirra arrburrwa rrapa a-gunggajinga arrburrwa a-workiya. Minypa nipa gun-molamola guna-jerrma barra arrburrwa waykin wenga minypa gun-gujayanaya gu-bengga barra arrburrwa. ");
INSERT INTO bvr_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Minypa warlaman wurra gama gorlk an-munya wupa aburr-nirra aburr-jirrawa rrapa aburr-gurkujarra aburr-nirra gun-gujuwa nula, nipa a-jayanaya barra burrwa a-ji. Rrapa minypa nipa arr-guybuka barra ngayburrpa gun-molamola jarlakarr minypa magaya gun-guni.” Ganapiya. Jekaráya a-yinagata a-wena, Mern An-mawunga wugupa nula. ");
INSERT INTO bvr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Rrapa nipa an-delipa wana a-ni a-bamuna rrapa marn․gi a-ni a-bamuna burr-guta. Minypa gu-werrapa a-ni nuwurra a-bena burrwa aburr-gata Yichrayal aburr-guyinda. ");
INSERT INTO bvr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Gun-gatiya minypa Jon a-bambungguna, gu-gatiya wenga an-gata bunggawa wana an-babalapa an-nelangga Agáchach (Augustus) nipa a-wena burrwa aburr-yigipa aburr-mujama minypa wurra gama gorlk gun-gata rrawa gu-jirra gu-boya birripa barra aburr-welangga aburr-gurrmiya, minypa nipa bunggawa a-birripiyana burrwa a-bona birripa aburr-yinmiyapa aburr-ni rrapa gun-ngiya gun-birripa rrawa ngardapa ngardapa. ");
INSERT INTO bvr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Gun-narda minypa gu-gegapa birripa aburr-welangga aburr-yinagata aburr-gurrmiyana. Rrapa gun-gatiya Agáchach an-nika jawina an-gata an-nelangga Gayríniyach (Quirinius), nipa jaga a-ganaja burrwa wurra gama gorlk gu-rrawa Jiriya (Syria). ");
INSERT INTO bvr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ganapiya, lika wurra gama gorlk minypa mu-ngoyurra ay-yinda aburr-gakiyana, wurra aburr-garlmuna, aburr-jekarra aburr-bona gun-birripa rrawa, gatiya minypa aburr-welangga aburr-gurrmiya barra. ");
INSERT INTO bvr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Rrapa an-gata Jochap (Joseph) nipa a-yinagatiya. Minypa nipa a-ni gun-delipa rrawa Nejarach (Nazareth) gun-gata wana gu-bapala gu-rrawa Galali (Galilee), wurra a-garlmuna, a-bona gun-gata wana gu-bapala gu-rrawa Judíya (Judea), wurra gun-delipa rrawa gun-gata Daybit (David) gun-nika nipa mu-ngoyurra a-ni gun-nelangga Betliyam (Bethlehem). Nipa Jochap gatiya a-bona ngardawa minypa nipiya Daybit an-bapurr gun-gatiya nula rrawa. ");
INSERT INTO bvr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Minypa nipa a-bona an-nelangga barra a-gurrmiya, rrapa jin-gata Meri wugupa nula jin-gatiya jin-nigipa gochila gochila jin-gurra, rrapa nipa jin-gata ji-gochila a-nirra yokuyoka. ");
INSERT INTO bvr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Gatiya birrinyjipa abirriny-bena rrawa Betliyam, gun-gatiya gugu nipa jin-gata a-ma barra yokuyoka. ");
INSERT INTO bvr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Lika gatiya a-menga nipa an-gata delipa an-murnangana an-nurra rrapa a-bichinga mu-mirikal mu-guyinda, lika mu-jarlapuna nuluwa, lika a-gurrmurra, gatiya a-yunya nipa bulugi (bullock) mun-nika mu-gorrngunya gata bulugi m-banga jiny-yorkiya. Ngardawa birrinyjipa abirriny-nyukiyana rrawa nula, jimarn jarra gu-bala gu-guyinda aburr-yurrarna, wurra bulugi gun-nika bala aburr-yu jarra. ");
INSERT INTO bvr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Rrapa gun-gata rrawa aburr-werranga aburr-ni marlgaway rrawa, minypa jip (sheep) jaga aburr-ganana achila ana-munya gu-ni. ");
INSERT INTO bvr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Rrapa an-ngardapa waykin an-guyinda an-mujaruk Wangarr an-nika a-bena burrwa aburr-gata, rrapa gatiya gugu gun-gujayanaya Wangarr gun-nika gu-jayanayarra burrwa, rrapa minypa birripa burr-guya aburr-gurkuja aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Lika nipa an-gata waykin an-guyinda an-mujaruk a-wena burrwa aburr-gata, “Ganapa buburr-gurkuja buburr-ni. Wurra gun-molamola janguny nguna-ganyja ana-gorrburrwa, gun-guworlworlcha ana-gorrburrwa gun-nardiya rrawa gu-jirra gu-boya. ");
INSERT INTO bvr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ngardawa gun-guniya gugu geka yokuyoka a-bambungguna gun-gata balay ngika rrawa Daybit gun-nika, an-gata yokuyoka nipa Wanngu An-gunega an-gatiya Wangarr mu-ngoyurra gochila nyin-dana Christ, minypa ana-goyburrpa nyiburr-gurdiya gorlk an-nardiya an-ngardapiya ana-gorrburrwa. ");
INSERT INTO bvr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Rrapa gun-guna minypa ana-goyburrpa marn․gi nyiburr-ni barra nula nipiya: Ana-goyburrpa nyibu-barripa barra an-gata yokuyoka a-bichiya a-yurra mu-mirikal mu-guyinda, rrapa minypa bulugi mun-nika gorrngunya nipa jin-babalapa mu-jarlapuna nula an-gatiya nipa a-yurra, minypa gata bulugi m-banga jiny-yorkiya gu-banggalat.” A-yinagata an-gata waykin an-guyinda an-mujaruk a-wena burrwa aburr-gata minypa jip jaga aburr-ganana aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ganapiya, lika gun-gatiya gugu aburr-jaranga aburr-werranga waykin aburr-guyinda wugupa nula an-gata waykin an-guyinda an-mujaruk, birripa an-nelangga an-molamola abi-negarra aburr-ni Wangarr. Minypa aburr-yinanga, ");
INSERT INTO bvr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Wangarr an-nelangga an-molamola abi-nega barra gun-gaba waykin nipa ay-ninyarrapa ay-workiya. Rrapa gun-nardiya gu-jel gun-molamola gu-ni barra burrwa gu-workiya birripa aburr-gata nipa a-jerrjerrjiyana burrwa.” ");
INSERT INTO bvr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Lika gu-gatiya wenga aburr-mujaruk burrbu-bawuna aburr-gata rrapa aburr-jekarra waykin. Wurra lika minypa aburr-gata jaga aburr-ganana achila aburr-ni jin-gata jip, birripa aburr-wengganachichiyana aburr-ni, “A-lay, marrka nguburr-boy barra rrawa Betliyam gun-gata Wangarr gu-ngurrjinga arrburrwa, barra marrka ngayburrpa ngubi-na geka gu-yinmiyana.” ");
INSERT INTO bvr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ganapiya, lika aburr-gata aburr-bena yibirrich. Lika burrbi-nana abirriny-jata Meri rrapa Jochap rrapa an-gata yokuyoka nipa gatiya bulugi mun-nika mu-gorrngunya a-yunya, birrinyjipa mbirriny-jarlapuna nula gatiya minypa bulugi m-banga jiny-yorkiya. ");
INSERT INTO bvr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Rrapa gata waypa abi-nana an-gata yokuyoka nipa a-yunya, lika aburr-garlmuna, aburr-bona, gubu-ngurrjinga aburr-bona gun-gata minypa an-mujaruk a-wena burrwa a-ni, an-guna yokuyoka a-ngurrjinga burrwa. ");
INSERT INTO bvr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Rrapa aburr-jaranga wurra gama gorlk aburr-gata minypa gun-gata janguny aburr-galiyana, jip jaga aburr-ganaja aburr-wena burrwa, aburr-gatiya wurra gama gorlk minypa gochila aburr-barrjinga. ");
INSERT INTO bvr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Wurra Meri ji-bama gu-ganyja jinyu-ni gun-gata gu-yinmiyana. ");
INSERT INTO bvr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Rrapa aburr-gata jaga aburr-ganana achila aburr-workiyana jin-gata jip, birripa aburr-garlmuna, aburr-jekarra gatiya jip jiny-jirra, wurra minypa aburr-marrkapchinga aburr-ni rrapa Wangarr an-nelangga an-molamola abi-negarra aburr-ni, ngardawa gun-gata birripa minypa aburr-galiyana janguny rrapa barrwa gubi-nana gun-burral minypa an-mujaruk a-wena burrwa. ");
INSERT INTO bvr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Gun-gatiya nipa Jesus a-bambungguna, nuwurra ngorrngurra arr-ngardapa arr-murna rrapa abirri-jirrapa gun-ngardapa gu-ni nula, lika majija abi-negarra rrapa minypa an-nelangga abu-garrana Jesus, minypa mu-ngoyurra waykin an-guyinda an-mujaruk a-garrana, nuwurra jurdach nipa ji-gochila a-ni. ");
INSERT INTO bvr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Rrapa nuwurra gun-balmapa gu-ni Meri rrapa Jochap barra gun-mola gubirrinyu-nega burrinyjula, minypa gun-birripa joborr Mojich (Moses) burr-wuna aburr-yinagatiya aburr-workiya, wolawola an-nurra a-bambunggiya a-workiya, lika birrinyjipa abirriny-jarlmuna, an-delipa abirriny-janyja gurda nula Wangarr, abirriny-yarrchinga gurda Jirúchalam (Jerusalem). ");
INSERT INTO bvr_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Minypa Wangarr gun-nika joborr mu-jurra gu-yurra, gu-yinaga, “An-murnangana an-guyinda an-nurra, nipa Wangarr an-nika ay-ni barra ay-workiya nuluwa Wangarr.”) ");
INSERT INTO bvr_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Gu-gurda nula Meri rrapa Jochap abirriny-bona gurda barra minyjak abirriny-yu Wangarr jin-nigipa, minypa joborr gu-yurra nipa gu-barnjinga, gu-yinaga, “abirriny-jirrapa mukumul waygaji abirriny-jirrapa delipa gu-lotok.” ");
INSERT INTO bvr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Rrapa gun-gatiya gugu an-ngardapa an-gugaliya a-ni rrawa Jirúchalam, nipa an-nelangga Jimiyan (Simeon). Nipa an-molamola an-gugaliya an-burral, minypa burr-guya marr a-balcha nula Wangarr, rrapa marr gu-ganyja gu-yinpa barra a-bengga An-gugunggaja an-gata Wangarr gochila gochila bin-dana aburr-guna Yichrayal (Israel) aburr-bapurr. Minypa nipa an-gatiya Jimiyan Mern An-mawunga wugupa nula, ");
INSERT INTO bvr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","rrapa nipa Mern An-mawunga a-wena nula nipa an-gata gala barra a-juwa mu-ngoyurra, wurra burdak a-na barra Wangarr an-nika an-gata an-burral arrburrwa An-gujerrjerrjiya. ");
INSERT INTO bvr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Gu-gurda ngacha minypa Jimiyan nipa Mern An-mawunga wugupa nula ana-bona, a-barrngumurra Wangarr gun-nika gu-japurra rrawa. Minypa gun-gatiya gugu Jesus mampa niya rrapa nyanyapa niya abirriny-janyja gurda barra abirriny-yirda minypa gun-birripa gun-guwarr. ");
INSERT INTO bvr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Lika nipa an-gata Jimiyan a-garlmuna, a-menga Jesus, lika a-ngurrgujinga rrapa minypa a-marrngoypiyana nula Wangarr. A-yinanga, ");
INSERT INTO bvr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Bunggawa ny-jarda waykin nyi-nirra, ngaypa ng-guna ngu-mujama nggula gun-guniya gugu ngu-mola ngaypa minypa ngu-juwa barra, nginyipa minypa ny-yena. ");
INSERT INTO bvr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ngardawa gipa mu-ngaypa m-barra ngu-nana an-guna nginyipa nyina-jerrmarra arrburrwa Wanngu An-gunega, ");
INSERT INTO bvr_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","minypa nginyipa nawanawa nyi-ni warlaman nyiburr-gurdiya gorlk ngayburrpa nyiburr-mibilapa. ");
INSERT INTO bvr_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Minypa nipa an-guna a-jayanaya barra burrwa aburr-gata Jentayl (Gentile) yerrcha, birripa aburr-bapurr barra marn․gi aburr-ni nggula, rrapa minypa arrbu-ngurrja barra ngayburrpa nyiburr-guna Yichrayal nyiburr-bapurr ngardawa nyiburr-molamola nyiburr-nginyipa wurra gama gorlk.” ");
INSERT INTO bvr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jimiyan a-yinagata a-wena, rrapa birrinyjipa Jesus mampa niya rrapa nyanyapa niya gochila abirriny-barrjinga gun-gata janguny gu-yinmiyana gu-ni nula. ");
INSERT INTO bvr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Lika nipa Jimiyan gu-wengga bijirriny-jalkakaja, rrapa mola a-yinagata achila Meri jin-gata Jesus mampa niya, “A-jay, an-guna yokuyoka, ngaja, barra Yichrayal yerrcha aburr-werranga aburr-lijiwarriya rrapa aburr-werranga nipa barra burr-jarlapa burr-ga. Nipa minypa arr-gurdagurdarra barra an-ngayburrpa Wangarr, wurpa lika aburr-jaranga ngoyurra aburr-yerryerrmiya barra nuluwa an-guna, ");
INSERT INTO bvr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","barra yarlanga gu-yu aburr-gata aburr-yinmiya ngardapa ngardapa birripa wupa aburr-ngurrnga gubu-borrwuja aburr-workiya. Rrapa minypa nginyipa burr-guta, a-jay, birripa mun-molma mbi-bu barra nggula.” A-yinagata nipa Jimiyan a-wena achila Meri. ");
INSERT INTO bvr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Rrapa jin-gata jin-ngardapa gama jin-nelangga Anna, nipa Achir jin-bapurr, Banuwal (Phanuel) jiny-bokamurra. Nipa jin-gata jin-mujaruk Wangarr gun-nika gu-ngurrjinga jiny-yorkiyana. Nipa jin-gata gipa gugu gapula jinyu-ni, minypa gun-guwarr jin-merduwa jiny-ji an-gumarrbipa ngacha jin-dimarra, rrapa gata abirriny-yu abirriny-bona jemberr burrinyjula abirri-jirrapa abirri-jirrapa abirri-jirrapa gun-ngardapa, ");
INSERT INTO bvr_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","lika nipa an-gata a-juwuna rrapa jin-gata gugu miliyak jinyu-ni. Gu-gatiya wenga gu-bamuna, gun-guniya gugu nipa jemberr gun-jaranga gu-ni achila minypa 84. Wurra jin-gata nipa Wangarr gun-nika gun-japurra rrawa jinyu-nipa jiny-yorkiyana ana-munya rrapa rrengarrenga; gala gu-bawujarna gun-gata rrawa, wurra gata jinyu-ni rrapa jiny-marrngoypiyana nula jiny-yorkiyana Wangarr, rrapa balaja mipila m-barra jiny-yorkiyana minypa burr-guya a-wengganana jinyu-ni jiny-yorkiyana, gu-gurda ngacha. ");
INSERT INTO bvr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nipa jin-gata jina-bonapa a-nana yokuyoka Jesus minypa Meri rrapa Jochap abirriny-janyja gurda, lika nipa jiny-japurramayana nula Wangarr, rrapa minypa jiny-nyukurdanyjiyana, delipa a-ngurrjinga jiny-bona burrwa aburr-yinmiyapa aburr-gata minypa marr gubu-ganyja gu-yinpa barra gun-molamola gu-ni barra burrwa Jirúchalam aburr-nirra. ");
INSERT INTO bvr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ganapiya, lika gun-gatiya Jochap rrapa Meri gubirriny-mungbuna minypa gun-birripa gun-guwarr Wangarr gu-gurrmurra burrwa Yichrayal yerrcha gun-gata nula minypa delipa a-bambunggiya a-workiya, lika delipa abirriny-janyja, abirriny-jekarra abirriny-bona Galali, minypa gun-birrinyjipa rrawa gun-gata Nejarach. ");
INSERT INTO bvr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Rrapa an-gata delipa, nipa wana rrapa an-molamola a-ni a-bamuna; gun-jechinuwa gu-borrwurra a-workiyana rrapa Wangarr nipa wugupa nula. ");
INSERT INTO bvr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jemberr gu-ni gu-workiyana, Jesus mampa niya rrapa nyanyapa niya abirriny-bona abirriny-yorkiyana Jirúchalam, janara gu-ji gu-workiyana gun-gata nula minypa wola Wangarr burr-beybana Yichrayal yerrcha, jimarn jarra burr-burndarna. ");
INSERT INTO bvr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Rrapa minypa Jesus nipa jemberr 12 gu-ni nula, birripa aburr-bona Jirúchalam. ");
INSERT INTO bvr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Rrapa nuwurra waypa janara gu-wulebiyana, lika wurra gama gorlk aburr-garlmuna, aburr-bona rrawa, wurra Jesus burdak a-ninya Jirúchalam. Wurra mampa niya rrapa nyanyapa niya birrinyjipa gala marn․gi nipa gapa a-ninya, ");
INSERT INTO bvr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","wurra bama abirriny-yinanga jimarna Jesus burr-guta aburr-bamuna, ngardawa aburr-gata aburr-jaranga wurra gama gorlk. Aburr-bamunapa gojilapa balngga gu-ni burrwa, lika birrinyjipa abirriny-yechawecha nula. Wurra nipa gala a-nirrarna gata aburr-yigipa aburr-borrmunga aburr-nirrapa; ");
INSERT INTO bvr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","gala abirriny-barripungarna. Lika gun-nerranga gu-ni, birrinyjipa abirriny-bona, abirriny-yechawecha barra nula abirrin-digirrga gata Jirúchalam. ");
INSERT INTO bvr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Rrapa barrwa gun-nerranga gu-ni, birrinyjipa abirriny-barripuna; nipa gata a-ni Wangarr gun-nika gun-japurra rrawa, gatiya minypa wugupa burrwa Ju yerrcha marn․gi aburr-gunega nipa a-galiyana burrwa a-ni rrapa burr-wengganana a-ni ");
INSERT INTO bvr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","rrapa barrwa gu-ngurrjinga burrwa. Rrapa aburr-gata aburr-galiyana nula, birripa aburr-bama gubu-borrwurra, aburr-wechawecha an-guna yinda marn․gi a-ni rrapa gun-jechinuwa a-weya a-nirra. ");
INSERT INTO bvr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Rrapa gun-gata waypa Meri rrapa Jochap abirrinyu-nana Jesus, birrinyjipa gochila abirriny-barrjinga nula minypa nipa rrapa aburr-gata marn․gi aburr-gunega wugupa aburr-wena aburr-ni. Lika mampa niya jiny-yena nula, “Ngalanga, ny-yinmiyana atila ngatipa? Wurra ngatipa birri-borrwurra nyirri-ni rrapa nyirri-wechawecha nggula.” ");
INSERT INTO bvr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Wurra Jesus a-yinanga burrinyjula, “An-nga nula nyirriny-yechawecharra apula? Wurra gala nyirriny-borrwa, ya, minypa ngaypa barra ngu-ninya Ngun-anya gun-nika gu-rrawa?” ");
INSERT INTO bvr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Wurra birrinyjipa gala gubirriny-malawujarna nula gun-gata nipa a-wena burrinyjula. ");
INSERT INTO bvr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ganapiya, lika nipa a-garlmuna burrinyjula, aburr-jekarra aburr-bona Nejarach. Lika birripa gatiya aburr-ni rrapa nipa gu-yagurrmurra burrinyjula a-ni a-workiyana, wurra nipa mampa niya mu-nguy ji-bama gu-ganyja Jesus nipa a-yinmiyana gata Jirúchalam. ");
INSERT INTO bvr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Rrapa Jesus mu-nguy marn․gi a-ni rrapa wana a-ni a-bamuna, rrapa minypa Wangarr nipa mu-nguy a-marrkapchinga nula a-ni, rrapa minypa wurra gama gorlk burr-guta aburr-marrkapchinga nula aburr-ni aburr-bamuna. ");
INSERT INTO bvr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Gu-bamuna, nuwurra waypa Daybíriyach Jija (Tiberius Caesar) gipa gun-jaranga jemberr nipa bunggawa wana an-bapala a-ni, minypa 15, gun-gata lika Wangarr gun-nika wengga gu-bena nula Jon (John) an-gata Jekaráya (Zechariah) an-nika an-walkurpa, nipa a-ninya gu-werrapa. Rrapa minypa Daybíriyach Jija burr-yika jawina ngardapa ngardapa jaga aburr-ganana aburr-ni rrawa gu-jirra gu-boya, birripa aburr-guna wupa aburr-welangga: minypa Bontiyach Baylat (Pontius Pilate), nipa jaga a-ganana gun-gata rrawa Judíya (Judea); rrapa Ayrat (Herod), nipa jaga a-ganana gun-gata rrawa Galali (Galilee); rrapa Ayrat an-nika worlapa niya an-gata Bilip (Philip), nipa jaga a-ganana gun-gata rrawa Yituréya (Ituraea) rrapa Durekanáytach (Trachonitis); rrapa Lichániyach (Lysanias), nipa jaga a-ganana rrawa Abiléni (Abilene). Aburr-gurdiya wupa bunggawa yerrcha jaga aburr-ganana gun-gata rrawa rrapa janguny gu-bena nula Jon gatiya nipa gu-werrapa a-ninya. Rrapa junggay wana abirri-babalapa Ju yerrcha burrbi-yika, abirri-gata Anach (Annas) mu-ngoyurra a-ni rrapa Gayapach (Caiaphas) jurdach junggay wana an-babalapa a-ni. ");
INSERT INTO bvr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Gun-gatiya Wangarr gun-nika wengga gu-bena nula Jon, lika nipa a-garlmuna, gu-ngurrjinga a-bona gun-gata rrawa gu-jirra gu-boya gata man․garba gu-werrwerrjinga gu-yurra gun-nelangga Jordan. Minypa nipa a-wena burrwa a-workiyana wurra gama gorlk, a-yinagata burrwa, “Gun-nerra bubu-bawa rrapa buburr-ngukurdanyjiya nula Wangarr, rrapa ngaypa bama arr-gurraga barra, minypa nipa Wangarr rrapa baywarra gu-nega barra ana-gorrburrwa gun-nerra nyibi-rrimarra.” ");
INSERT INTO bvr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jon a-yinagata a-wena rrapa jama a-ji a-workiyana minypa gun-gata Wangarr gun-nika janguny wola gun-guwarr Aycháya (Isaiah) a-wukurrjinga, gu-yinaga gu-yurra, “An-nerranga an-gata a-jabarrchinga a-jirra yi-gata gu-werrapa, nipa a-yinaga a-weya, ‘A-lay, nipa Bunggawa ana-boya! Jarlakarr nawanawa buburr-ni nula. Gun-jechinuwa bubi-nega nula. ");
INSERT INTO bvr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mun-mirk mu-guyinda mu-yawuchiya barra yi-gata mu-gochila mu-guyinda, rrawa barra gun-molamola gu-ni barra. Gun-melamirlamirnda gun-guyinda gu-ngukurdanyjiya barra gun-jechinuwa gu-ni, rrapa gun-guburlububurluja gun-guyinda gu-ngukurdanyjiya barra gun-jerdajirda gu-ni barra. ");
INSERT INTO bvr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nguburr-gurdiya gorlk gun-nardiya rrawa gu-jirra gu-boya, ngayburrpa ngubi-na barra minypa nipa Wangarr wanngu arr-nega barra.’” ");
INSERT INTO bvr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","A-yinagata Aycháya a-wukurrjinga wola rrapa gu-gurda ngacha minypa nipa Jon jurdach jama a-ji. Minypa aburr-jaranga wurra gama gorlk aburr-bona gurda nula nipa barra bama burr-gurraga, wurra nipa a-yinagata burrwa, “Ana-goyburrpa nyiburr-gurda minypa an-gata jarn․gich an-guyinda. Wurra ana-nga a-wena ana-gorrburrwa ana-goyburrpa nyiburr-yurtchingapa, jimarna ana-goyburrpa wupa ngardapa wanngu nyiburr-negiya barra gun-gata mari guna-bamburda? Wurra gala nyiburr-yinmiya. ");
INSERT INTO bvr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Jarra ana-goyburrpa minypa gun-maywapa gun-jong, wurra yama ana-goyburrpa nyibi-rrima minypa mun-molamola balaja? Minypa gun-burral ana-goyburrpa yama nyiburr-yinda jama nyiburr-ji minypa gun-nerra nyibu-bawa? Wurra gala barra ana-goyburrpa ngardapa ana-gorrburra nyiburr-wengga, nyiburr-yinda, ‘Ngika. Jarra ngayburrpa Aybriyam (Abraham) an-ngayburrpa nyanyapa arrburra.’ Gala barra nyiburr-wengga gu-gurda ngacha. Wurra ngaypa jarra ngu-weya ana-gorrburrwa, Wangarr minyja nipa jal a-ni, nipa ganyjarr gu-rrimanga gun-guna jandarra gun-jaranga gu-yurra nipa gu-jarlapa minypa Aybriyam burr-yika gu-ngarda yerrcha. ");
INSERT INTO bvr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Wurra gun-gata ngaypa ngu-wena ana-goyburrpa minypa gun-maywapa gun-jong, wurra an-gata minypa an-maywapa galamang an-gurrimapa, nipa gugu gu-jaywuja a-jirra gun-gata gun-jong, burr-bama burr-rrepara barra gu-yartkujama. Minyjiya. Gun-jong gun-guyinda gun-gata gala mun-molamola balaja mu-rrima, nipa an-gata gu-yartkujama barra a-ni, gu-yerrnyja barra yi-gata gu-bol gu-guyinda.” Nipa Jon a-yinagata a-wena burrwa, minypa gun-burral nipa Wangarr a-yinmiya barra burrwa aburr-gata minypa gala marr aburr-balcha nula, gu-gurda ngacha. ");
INSERT INTO bvr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Lika aburr-gata aburr-jaranga abu-wengganana aburr-ni Jon, “Lika ngayburrpa nyiburr-yinmiya barra, a-lay?” ");
INSERT INTO bvr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Lika nipa gu-ngurrjinga burrwa, “Ny-yinga ny-jata minyja n-dimanga abirri-jirrapa molma mun-gunegiya mirikal, wu mun-nerranga an-gata gala mu-rrima. Rrapa ny-yinga ny-jata minypa balaja n-dimanga, ny-yirda barra ny-yu mun-nerranga an-gata gala mu-rrima.” ");
INSERT INTO bvr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Rrapa Ju yerrcha aburr-gata jama aburr-jirra nula aburr-workiya gapman (government) minypa rrupiya mbi-mangga nula aburr-workiya, wurra gama gorlk burrbu-gaypurda, birripa aburr-gata burr-guta aburr-bona gurda nula Jon barra nipa bama burr-gurraga. Aburr-yinanga nula, “Bunggawa, a-lay, ngayburrpa rrapa nyiburr-yinmiya barra?” ");
INSERT INTO bvr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Lika nipa gu-ngurrjinga burrwa, “Ana-goyburrpa gala barra nyirrbu-gaypa wurra gama gorlk. Wurra burrbu-wenggana mun-gata mun-nga birripa mbi-rrimanga minypa gapman mun-nika, mun-narda wupa ganapiya.” ");
INSERT INTO bvr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Rrapa aburr-gata an-dakal an-guyinda, birripa burr-guta abu-wengganana Jon, aburr-yinanga, “Rrapa ngayburrpa? Ngayburrpa nyiburr-yinmiya barra, a-lay?” Nipa a-yinagata burrwa, “Gala barra nyirrbu-gaypa wurra gama gorlk minypa ana-goyburrpa nyiburr-bachirra burrwa rrapa minypa mari nyibu-garraja burrwa, jimarna barra burr-rrupiya gun-molamola gubi-nega burrwa. Gala barra nyiburr-yirda. Wurra jarra mun-goyburrpa wupa rrupiya nyibu-ma barra nyiburr-workiya, ganapiya, mun-nardiya wupa.” ");
INSERT INTO bvr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Minypa gun-gata birripa wurra gama gorlk gubu-borrwurra aburr-ni yi-gurrepa gu-nirra gu-bamburda Wangarr barra a-gunggaja burrwa, aburr-jaranga aburr-gata bama aburr-yinanga jimarn jarra Jon nipa Christ. ");
INSERT INTO bvr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Wurra Jon a-wena burrwa, “Ngika. Jarra ngaypa bama arr-gurragaja ngu-workiya ana-goyburrpa gu-bugula gu-guyinda, wurra jarra an-nerranga ana-boya nipa wana, ngaypa ngu-delipa. Minypa ngaypa gala wana rraka ngu-yigipa ngu-mujama ngu-ni nula rrapa minypa ngu-yerrkujama nula ngu-workiya gun-nigipa nipa a-barrngumiya a-workiya rrepara a-jirra. Wurra jarra nipa bama nyirr-gurraga barra Mern An-mawunga, rrapa minypa gun-nerra gu-yalpa barra ana-gorrburrwa gu-bol gu-guyinda, gu-gurda ngacha. ");
INSERT INTO bvr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nipa gipa nawanawa a-ni nipa barra arr-ngorrkornda a-boy, minypa gun-maywapa an-gugaliya mu-ngorrkorndanga a-workiya balaja minypa mun-mola mun-guyinda ngardapa rrapa mun-nerra mun-guyinda ngardapa. Minypa gun-burral ngayburrpa nguburr-werranga nguburr-mola nguburr-guyinda nipa arr-ga barra a-boy gu-yigipa gu-rrawa, wurra ngayburrpa nguburr-werranga nguburr-werra nguburr-guyinda nipa arr-yerrnyja barra yi-gata gu-bol, gatiya barra nguburr-mungbiyapa barra nguburr-rro rrapa gun-gata bol gala ana-nga gu-jupa.” ");
INSERT INTO bvr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon a-yinagata a-wena a-workiyana burr-guya, minypa gun-molamola janguny gu-ngurrjinga burrwa a-workiyana wurra gama gorlk. ");
INSERT INTO bvr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Rrapa nipa a-wena nula an-gata Ayrat (Herod) burr-guta, gapman an-guyinda an-gata jaga a-ganaja gun-gata rrawa. Minypa nipa Jon ana-nyala gelama gelama a-barra a-ni Ayrat, ngardawa nipa Ayrat jiny-menga an-nigipa worlapa niya jin-nika gama jin-gata Yirórriyach (Herodias). Rrapa minypa barrwa gun-jaranga gun-nerra gun-guyinda Ayrat jama a-ji a-workiyana, nipa Jon ana-nyala gelama gelama a-barra a-workiyana. ");
INSERT INTO bvr_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Wurra Ayrat a-garlmuna rrapa barrwa jama a-ji burr-guya gun-nerra, gun-gata minypa nipiya Ayrat ana-nyala a-rrimarra Jon rrapa a-barrbuna wupa minypa nipa brichina barra a-ni. ");
INSERT INTO bvr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wurra gun-gatiya mu-ngoyurra burdak Jon bama burr-gurragaja a-ni wurra gama gorlk, Jesus ana-bona rrapa nipa burr-guta Jon ana-nyala bama a-gurragaja. Rrapa gatiya waypa nipa Jesus a-wengganana a-ni, waykin gu-lapkujamiyana ");
INSERT INTO bvr_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","rrapa Mern An-mawunga ana-bupiyana nula minypa nipa mukumul a-maya. Rrapa ana-manyjirda a-galiyana waykin wenga Wangarr ana-wena nula nipa Jesus, “Nginyipa ny-jurda ny-nyaypa Walkur ngaypa burr-guya jal ngu-nirra nggula; ngaypa ngu-marrkapchinga nggula.” ");
INSERT INTO bvr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Gun-gatiya waypa Jesus a-garlmuna barra jama a-ji minypa nipa gu-rrimarra ganyjarr, nipa jemberr gu-ni nula burr-murna burr-rrepara rrapa barrwa arr-jirrapa arr-murna, minypa 30. Rrapa wurra gama gorlk gubu-borrwurra, jimarna Jochap a-bokamurra Jesus, burrbu-ngurrjinga Jesus burr-yika mu-ngoyurra aburr-guyinda minypa aburr-guna: ");
INSERT INTO bvr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Jochap nipa an-walkurpa Yeli (Heli) an-nika, Yeli nipa an-walkurpa Mechat (Matthat) an-nika, Mechat nipa an-walkurpa Libay (Levi) an-nika, Libay nipa an-walkurpa Melki (Melchi) an-nika, Melki nipa an-walkurpa Janay (Jannai) an-nika, Janay nipa an-walkurpa Jochap an-nika, ");
INSERT INTO bvr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jochap nipa an-walkurpa Metacháyach (Mattathias) an-nika, Metacháyach nipa an-walkurpa Aymoch (Amos) an-nika, Aymoch nipa an-walkurpa Neyam (Nahum) an-nika, Neyam nipa an-walkurpa Yechili (Esli) an-nika, Yechili nipa an-walkurpa Negay (Naggai) an-nika, ");
INSERT INTO bvr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Negay nipa an-walkurpa Meyach (Maath) an-nika, Meyach nipa an-walkurpa Metacháyach (Mattathias) an-nika, Metacháyach nipa an-walkurpa Jemeny (Semein) an-nika, Jemeny nipa an-walkurpa Jochak (Josech) an-nika, Jochak nipa an-walkurpa Jorra (Joda) an-nika, ");
INSERT INTO bvr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jorra nipa an-walkurpa Jowánan (Joanan) an-nika, Jowánan nipa an-walkurpa Recha (Rhesa) an-nika, Recha nipa an-walkurpa Jirábabal (Zerubbabel) an-nika, Jirábabal nipa an-walkurpa Jiyáltil (Shealtiel) an-nika, Jiyáltil nipa an-walkurpa Neri an-nika, ");
INSERT INTO bvr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri nipa an-walkurpa Melki an-nika, Melki nipa an-walkurpa Arri (Addi) an-nika, Arri nipa an-walkurpa Gocham (Cosam) an-nika, Gocham nipa an-walkurpa Almárram (Elmadam) an-nika, Almárram nipa an-walkurpa Yer (Er) an-nika, ");
INSERT INTO bvr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Yer nipa an-walkurpa Jochuwa (Joshua) an-nika, Jochuwa nipa an-walkurpa Yiliyícha (Eliezer) an-nika, Yiliyícha nipa an-walkurpa Jorim an-nika, Jorim nipa an-walkurpa Mechat (Matthat) an-nika, Mechat nipa an-walkurpa Libay an-nika, ");
INSERT INTO bvr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Libay nipa an-walkurpa Jimiyan (Simeon) an-nika, Jimiyan nipa an-walkurpa Juda (Judah) an-nika, Juda nipa an-walkurpa Jochap an-nika, Jochap nipa an-walkurpa Jonam an-nika, Jonam nipa an-walkurpa Yiláyakim (Eliakim) an-nika, ");
INSERT INTO bvr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Yiláyakim nipa an-walkurpa Meliya (Melea) an-nika, Meliya nipa an-walkurpa Mena an-nika, Mena nipa an-walkurpa Matécha (Mattatha) an-nika, Matécha nipa an-walkurpa Neytan (Nathan) an-nika, Neytan nipa an-walkurpa Daybit (David) an-nika, ");
INSERT INTO bvr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daybit nipa an-walkurpa Jechi (Jesse) an-nika, Jechi nipa an-walkurpa Abet (Obed) an-nika, Abet nipa an-walkurpa Bowech (Boaz) an-nika, Bowech nipa an-walkurpa Jalman (Salmon) an-nika, Jalman nipa an-walkurpa Nachon (Nahshon) an-nika, ");
INSERT INTO bvr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nachon nipa an-walkurpa Amínadap (Amminadab) an-nika, Amínadap nipa an-walkurpa Atmin (Admin) an-nika, Atmin nipa an-walkurpa Arni an-nika, Arni nipa an-walkurpa Yechran (Hezron) an-nika, Yechran nipa an-walkurpa Berech (Perez) an-nika, Berech nipa an-walkurpa Juda an-nika, ");
INSERT INTO bvr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda nipa an-walkurpa Jeykap (Jacob) an-nika, Jeykap nipa an-walkurpa Ayjek (Isaac) an-nika, Ayjek nipa an-walkurpa Aybriyam (Abraham) an-nika, Aybriyam nipa an-walkurpa Dera (Terah) an-nika, Dera nipa an-walkurpa Neyor (Nahor) an-nika, ");
INSERT INTO bvr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neyor nipa an-walkurpa Jeruk (Serug) an-nika, Jeruk nipa an-walkurpa Reyu (Reu) an-nika, Reyu nipa an-walkurpa Belek (Peleg) an-nika, Belek nipa an-walkurpa Yiber (Eber) an-nika, Yiber nipa an-walkurpa Jila (Shelah) an-nika, ");
INSERT INTO bvr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Jila nipa an-walkurpa Gaynan (Cainan) an-nika, Gaynan nipa an-walkurpa Apákchat (Arphaxad) an-nika, Apákchat nipa an-walkurpa Jem (Shem) an-nika, Jem nipa an-walkurpa Nowa (Noah) an-nika, Nowa nipa an-walkurpa Lemek (Lamech) an-nika, ");
INSERT INTO bvr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek nipa an-walkurpa Metúchala (Methuselah) an-nika, Metúchala nipa an-walkurpa Yinok (Enoch) an-nika, Yinok nipa an-walkurpa Jaret (Jared) an-nika, Jaret nipa an-walkurpa Makélalil (Mahalaleel) an-nika, Makélalil nipa an-walkurpa Gaynan an-nika, ");
INSERT INTO bvr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Gaynan nipa an-walkurpa Yinoch (Enos) an-nika, Yinoch nipa an-walkurpa Jet (Seth) an-nika, Jet nipa an-walkurpa Arram (Adam) an-nika, rrapa Arram nipa an-walkurpa Wangarr an-nika. Aburr-gurdiya wupa aburr-welangga Jesus burr-yika mu-ngoyurra aburr-guyinda. ");
INSERT INTO bvr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Rrapa gun-gata waypa Jesus ana-jekarra Jordan wenga, nipa Mern An-mawunga wugupa nula ay-ganyja ay-bamuna gu-werrapa, gatiya nipa a-rrigirrgarra ");
INSERT INTO bvr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ngorrngurra gun-jaranga nula minypa 40, rrapa walkwalk an-bachirra nipa ana-nyala a-jurnajuchuwurra a-ni Jesus, jimarna nipa barra werra a-negiya. Gun-gatiya Jesus gala balaja m-bangarna, lika gu-gata wenga gu-wulebiyana, lika nipa a-werrmiyana. ");
INSERT INTO bvr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Lika an-gata walkwalk a-garlmuna, a-yinanga a-wena nula Jesus, “Minyja nginyipa Wangarr biy-yika Walkur, gun-guna jandarra yama ny-yengga nula barra nipa gu-ngukurdanyjiya rrapa rakaraka mu-ni ngguluwa?” ");
INSERT INTO bvr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Wurra Jesus a-yinanga, “Ngika. Wurra jurra mu-guyinda gu-yurra janguny, ‘An-gugaliya gala a-yinmiya m-balaja mu-guyinda mu-gurda wupa wanngu a-ni. Ngika.’” ");
INSERT INTO bvr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ganapiya, lika walkwalk a-ganyja abirri-bamuna Jesus waykin mu-mirk mu-guyinda. Lika gun-gatiya gu-ngardapa a-gurdagurdarrana gun-nardiya rrawa gu-jirra gu-boya aburr-ngorrkorndiya aburr-nirra, ngardapa ngardapa bunggawa burrbi-rrimanga. ");
INSERT INTO bvr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Rrapa nipa walkwalk a-wena nula Jesus, a-yinagata, “Ngaypa barra ngiy-wu ganyjarr, nginyipa barra wana ny-babalapa nyi-ni gun-nardiya rrawa, rrapa gun-molamola gun-guyinda gu-guniya gu-yika gu-rrawa gun-nginyipa barra gu-ni warrpam. Ngardawa ngaypa ngu-menga rrapa ngaypa ngu-wu ana-nga minyja ngaypa jal ngu-ni nula. ");
INSERT INTO bvr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ganapiya, lika minyja nginyipa ny-marrngoypiya apula, gun-guna barra gun-nginyipa gu-ni.” A-yinagata nipa walkwalk a-wena. ");
INSERT INTO bvr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Wurra Jesus a-yinagata, “Ngika. Wurra jarra jurra mu-guyinda gu-yurra janguny, ‘Ana-goyburrpa barra nyiburr-marrngoypiya nula an-goyburrpa an-ngardapiya ana-gorrburrwa Wangarr, rrapa jama nyiburr-ji barra nyiburr-workiya nuluwa nipa wupa an-ngardapa.’” ");
INSERT INTO bvr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ganapiya, lika walkwalk a-ganyja Jesus gun-gata rrawa Jirúchalam (Jerusalem) rrapa a-barnjinga gata waykin Wangarr gun-nika bala gun-japurra. Lika a-wena nula, “Minyja nginyipa Wangarr biy-yika Walkur, marrka gortkurrcha. ");
INSERT INTO bvr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ngardawa jurra mu-guyinda gu-yurra janguny, ‘Wangarr a-wengga barra burrwa aburr-yigipa waykin aburr-guyinda aburr-mujaruk birripa barra jaga aburr-gana nggula,’ ");
INSERT INTO bvr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","rrapa mola minypa ‘Murna aburr-jirra aburr-guyinda bubi-rrima barra aburr-ji rraka nginyipa gala ny-yinmiya gu-jandarra biy-bu rrepara ny-jirra.’” A-yinagata walkwalk a-wena rrapa minypa Wangarr gun-nika wengga gu-ngukurdanyjinga, jimarna barra Jesus a-gortkurrcha rrapa a-juwa. ");
INSERT INTO bvr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Wurra nipa Jesus a-yinagata nula, “Ngika. Wurra janguny gu-yurra, gu-yinaga gu-weya, ‘Nginyipa gala barra ny-jurnajuchuwa an-nginyipa an-ngardapiya nggula Wangarr.’” ");
INSERT INTO bvr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ganapiya, lika gun-gatiya waypa gala barrwa gun-nga rraka nipa walkwalk mu-nguy a-jurnajuchuwa Jesus, lika nipa walkwalk a-bawuna Jesus, lika a-bona nuwurra waypa gu-yinpa barra gun-mola gu-ni barra nula. ");
INSERT INTO bvr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Rrapa Jesus a-jekarra a-bamuna rrawa Galali (Galilee), nipa burr-guya ganyjarr gu-rrimarra ngardawa Mern An-mawunga nipa nyanma. Rrapa janguny gu-barrjekarra nula gu-bona, rrawa gu-jirra gu-boya aburr-galiyana nula. ");
INSERT INTO bvr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Rrapa minypa nipa marn․gi burr-negarra a-workiyana janguny gata gu-bala gu-guyinda Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya, gu-gata wenga aburr-bulapalawa abu-ngurrjinga nipa Jesus an-molamola. ");
INSERT INTO bvr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Lika gu-gata wenga Jesus a-bena Nejarach (Nazareth), gun-nigipa rrawa gatiya nipa wana a-ni. Lika Jarradi gu-ni, nipa a-bona, gu-birripa gu-bala marn․gi aburr-negiya aburr-workiya nipa a-barrngumurra minypa nipa a-yinagata a-workiyana. Gatiya lika nipa a-garlmuna, a-jinyja, barra minypa mu-jurra mu-guyinda janguny gu-na rrapa a-wengga burrwa a-ji. ");
INSERT INTO bvr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Lika birripa abu-wuna jurra mun-gata minypa janguny gu-yurra Aycháya (Isaiah) wola gun-guwarr gu-ngurrjinga Wangarr gun-nika. Lika Jesus mu-lapkujamurra jurra mun-gata minypa mu-garlagulurrmiyana mu-yu, lika janguny gu-barripuna mu-gatiya mu-jurra mu-guyinda gu-yinagata, ");
INSERT INTO bvr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Mern An-mawunga nipa wugupa apula, ngardawa Wangarr nguna-menga aburr-gata aburr-welangga aburr-delipa ngaypa barra ngu-ngurrja burrwa ngu-boy gun-molamola janguny. Nipa nguna-jerrmarra janguny barra gu-barrjeka gu-boy, rrawa gu-jirra gu-boya barra aburr-galiya minypa Wangarr nipa wanngu burr-nenga a-nirra mu-ngoyurra ana-werranga burda burr-negarra, rrapa minypa aburr-gapula nipa burr-jarlapurda a-nirra barrwa barra gubi-na. Nipa nguna-jerrmarra ngaypa barra ng-gunggaja burrwa aburr-gata minypa gun-derta gubu-barripuna. ");
INSERT INTO bvr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nipa nguna-jerrmarra ngaypa barra ngu-ngurrja ngu-boy minypa gun-guniya gugu nipiya Wangarr a-gunggaja barra burrwa aburr-yigipa gu-galiya yerrcha.” ");
INSERT INTO bvr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Gu-gurda ngacha Jesus a-wena burrwa minypa wola gun-guwarr Aycháya gu-ngurrjinga. Lika mu-garlagulurrmurra mun-gata jurra rrapa a-wuna an-mujama an-gata, lika a-rakaja gatiya minypa an-mujanguny an-guyinda a-rakaja a-workiya rrapa a-weya. Rrapa aburr-gata wurra gama gorlk gu-bala aburr-ni, birripa mu-nguy abi-nana aburr-yu. ");
INSERT INTO bvr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Lika nipa a-wena burrwa, “Gun-narda janguny ana-goyburrpa nyiburr-galiyana geka ngaypa ngu-wena ana-gorrburrwa, gu-gatiya gugu gu-bena gun-burral.” ");
INSERT INTO bvr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jesus a-yinagata a-wena burrwa, lika aburr-marrkapchinga nula rrapa aburr-bama gubu-ganyja gun-gata gun-molamola janguny nipa a-wena burrwa. Wurpa lika gochila aburr-barrjinga rrapa minypa aburr-wengganachichiyana aburr-ni, “Wurra, a-lay, an-guna nipa Jochap an-nika an-walkurpa, ya?” ");
INSERT INTO bvr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nipa a-wena burrwa, “Ngaypa marn․gi ana-gorrburrwa burraya ana-goyburrpa nyiburr-yinda barra nyiburr-wengga apula minypa wolawola aburr-weya aburr-workiya, aburr-yinaga, ‘Nginyipa bin-dimanga ny-yorkiya rrapa wanngu burr-nenga ny-yorkiya, wurra yama wanngu nyi-negiya nginyipa?’ Rrapa nyiburr-yinda barra apula, ‘Gun-gata minypa nginyipa jama ny-jirra gata Gapárniyam, yinda jama ji ay-ngunyuna gun-nginyipa rrawa.’” ");
INSERT INTO bvr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nipa a-yinagata, “Gun-guna ngu-weya ana-gorrburrwa gun-burral: Wolawola an-mujaruk ngunyuna an-guyinda gu-ngurrjinga a-boya a-workiya Wangarr gun-nika janguny, nipa wurra gama gorlk aburr-galiyarra nula aburr-workiya, wurra ngika minypa gu-yigipa gu-rrawa. ");
INSERT INTO bvr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Minyja bubu-borrwa: gun-gapa mu-ngoyurra Yiláyja (Elijah) a-ninya, jin-gata jin-jaranga miliyak jin-guyinda jinyu-ni gun-gata rrawa Yichrayal (Israel). Wurra gun-gata minypa yorr gala gu-bunggiyarna gu-workiyarna, rarranyjarr gu-ji abirri-jirrapa gun-ngardapa rrapa barrwa goma gu-jirra, rrapa minypa balaja mun-guyinda mu-wulebiyana gun-gatiya rrawa gu-jirra gu-boya, ");
INSERT INTO bvr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","wurra gala jin-nga jin-gata miliyak jin-guyinda nipa Wangarr a-jerrmangarna achila an-gata Yiláyja barra nipa a-gunggaja achila, wurra gun-nyagara. Wurra gu-werranga gu-rrawa jin-miliyak, ngaja, ngarla, nipa Wangarr a-jerrmarra achila an-gata Yiláyja, minypa jin-gata rrawa jinyu-ni Jerapach (Zarephath), wana gu-bapala gu-rrawa gun-gata Jaydan (Sidon). ");
INSERT INTO bvr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Rrapa nuwurra waypa jurdach an-nerranga an-gata Wangarr an-nika an-mujaruk a-ninya, an-gata Yiláycha (Elisha), gu-galiya yerrcha Yichrayal aburr-nirra aburr-gata aburr-jaranga aburr-jeja aburr-ngolkujarra, minypa gun-guburlububurluja gubi-rrimarra. Wurra Wangarr gala wanngu burr-nengarna birripa, wurra an-jeja an-guyinda an-ngardapa wupa nipa wanngu a-negarra, an-gata an-nelangga Neyaman (Naaman), nipa gata an-guyinda Jiriya (Syria).” Jesus a-yinagata a-wena burrwa. ");
INSERT INTO bvr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Lika aburr-gata gu-bala aburr-ninya, birripa gugu aburr-bachirramiyana nula Jesus. Ngardawa birripa aburr-ngurrnga aburr-galiyana, minypa nipa burr-ngurrjinga birripa aburr-yinagatiya, gala marr aburr-balcharrarna. ");
INSERT INTO bvr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Lika birripa aburr-garlmuna, abi-rrimarrapa abu-ganyja yarlanga gun-gata mu-mirk mu-guyinda gu-jirra rrawa, jimarn jarra gu-gata wenga abi-yerrnyjingarna, a-bunggiyarna a-yurtchingarna mu-mirk m-bukula. ");
INSERT INTO bvr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Wurra Jesus burr-ngorrkorndanga ay-bamuna, burr-bawuna a-bona. ");
INSERT INTO bvr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Lika Jesus a-bona gun-nerranga rrawa gatiya wana gu-bapala gu-rrawa Galali, gun-gata Gapárniyam (Capernaum) gun-nelangga. Lika Jarradi gu-ni, nipa marn․gi burr-negarra a-ni janguny, ");
INSERT INTO bvr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","rrapa birripa gochila aburr-barrjinga nula nipa a-yinmiyana a-wena burrwa a-ni, ngardawa gun-nigipa janguny burr-ganyjarr gu-rrimarra. ");
INSERT INTO bvr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Rrapa gata wupa gu-bala Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya, an-ngardapa an-gugaliya an-gata nipa walkwalk a-rrimarra. Nipa burr-guya a-gonyjinga, ");
INSERT INTO bvr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Awa! Ny-jurda nginyipa Jesus, ny-jurdiya Nejarach nyi-guyinda! Wurra an-nga nula nyina-bona arrburrwa ngayburrpa? Wurra nyirr-bu barra, ya? Ngaypa marn․gi nggula nginyipa. Nginyipa Wangarr biy-yika, ngarla! Janguny nginyipa n-dimanga gun-nigipiya Wangarr gun-nika!” ");
INSERT INTO bvr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Wurra Jesus a-jobujobuna an-gata walkwalk, “Ngarmbuwa! Nyina-bengga! Bawa an-garda!” Lika gatiya gojilapa wurra gama gorlk aburr-jinyja, nipa walkwalk ana-nyala a-bembarrembarra an-gugaliya a-bungguna, lika nipa ana-bena, a-bawuna, lika an-gugaliya a-molamiyana. ");
INSERT INTO bvr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Rrapa aburr-gata wurra gama gorlk gochila aburr-barrjinga. Aburr-wengganachichiyana aburr-ni, “Gun-guna gun-nga janguny, a-lay? Wurra burr-ganyjarr rrapa burr-barlmarrk an-guna a-weya a-boya, walkwalk an-guyinda a-beya a-yurra, ngaja, ngarla!” ");
INSERT INTO bvr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Lika janguny gu-barrjekarra nula gu-bona, gun-gata rrawa gu-jirra gu-boya aburr-galiyana nula minypa gun-nigipa ganyjarr. ");
INSERT INTO bvr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Gatiya Jesus ana-bena yarlanga gu-gata gu-bala Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya, lika nipa a-bona Jayman (Simon) gun-nika rrawa. Lika gata a-bena minypa Jayman jin-nika jaburpa niya jiny-yorrpuna jiny-yu gatiya, minypa nipa burr-guya jin-donga jiny-ji. Lika birripa aburr-wena nula Jesus barra nipa jin-dima. ");
INSERT INTO bvr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Lika nipa a-bamuna, a-jinyja gata nipa jiny-yunyapa, lika gu-jobujobuna gun-gata gu-derda, lika gu-bona achila. Lika warrika nipa jiny-jarlmunapa burr-wuna jiny-bona balaja. ");
INSERT INTO bvr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ganapiya, lika yi-rrana gu-ni, lika wurra gama gorlk burrbu-ganyja gurda nula Jesus aburr-birripa aburr-borrmunga birripa gubi-rrimarra gun-jaranga gu-derda gun-guyinda. Lika nipa bin-dimarra, birripa aburr-molamiyana rrapa gala ana-nga a-ngukiyarna. ");
INSERT INTO bvr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Rrapa an-jaranga walkwalk ana-bena ana-yu, burr-bawuna aburr-gata wurra gama gorlk, nipa walkwalk an-guyinda a-gonyjinga a-ji, a-yinagata, “Ny-jurda nginyipa Wangarr biy-yika Walkur!” Wurra Jesus a-jobujobuna; nipa gala jal a-nirrarna walkwalk ana-nyala a-ngurrja, ngardawa gipa nipa walkwalk marn․gi nula nipa gochila an-gurra Wangarr arr-wuna Christ. ");
INSERT INTO bvr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nuwurra waypa guna-gepana guna-bona, Jesus gu-bawuna gun-gata rrawa rrapa a-bona gu-werrapa. Wurra gu-galiya yerrcha aburr-garlmuna, aburr-bona, aburr-wechawecha nula, lika abu-barripuna. Lika aburr-ngiwija nula nipa gala barra burr-bawa rrapa gun-nerranga rrawa a-boy. ");
INSERT INTO bvr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Wurra nipa a-wena burrwa, “Ngika. Wurra gun-nardiya rrawa gu-jirra gu-boya ngaypa barra gun-molamola janguny ngu-ngurrja burrwa ngu-boy, Wangarr gun-nika rum. Ngardawa gun-gata nula nipa nguna-jerrmarra.” ");
INSERT INTO bvr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ganapiya, lika a-bona, rrawa gu-jirra gu-boya nipa a-barrngumurra gu-bala Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya, rrapa a-wena burrwa a-bona Wangarr gun-nika janguny. ");
INSERT INTO bvr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nuwurra waypa Jesus gata a-jinyja gu-rrarnba gun-gata Ganécharat (Gennesaret) gochilawa ana-jola, aburr-jaranga wurra gama gorlk aburr-gakiyana nula aburr-bamuna, aburr-galiyana nula aburr-ni Wangarr gun-nika janguny nipa a-wena. ");
INSERT INTO bvr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Lika nipa mu-nana abirri-jirrapa michiyang jorrnyjurra mu-ji, aburr-gata jichicha abi-rrimarra aburr-workiyana gipa mu-ngoyurra aburr-gortkurrchinga, mulucha mun-birripa mbi-wepana aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Lika nipa Jesus a-gortkurrchinga mu-ngardapa mu-michiyang mun-gata Jayman (Simon) mun-nika. Lika a-wena nula Jayman, “Nginyipa barrwa nyina-gaka murda michiyang gu-bugula gu-guyinda barra mu-garlagaya mu-ji.” Lika nipa Jesus a-rakaja mu-michiyang mu-gochila gata gu-bugula mu-ji, rrapa a-wena burrwa a-ni wurra gama gorlk gata gu-rrarnba aburr-galiyana nula aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ganapiya, lika nuwurra nipa gu-wulebana janguny, lika a-wena nula Jayman, “A-lay, ngayburrpa yama nguburr-gakiya gu-lupa gu-guyinda bugula, gatiya barra nginyipa rrapa aburr-nginyipa jawina yerrcha aburr-guna mulucha nyibu-gurrma barra jichicha nyibi-rrima?” ");
INSERT INTO bvr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Wurra Jayman a-yinanga nula, “Ngika, a-la, Bunggawa! Wurra ngayburrpa nyibu-gurrmurra mulucha ana-munya gu-bamunapa guna-gepana, wurra gala jichicha nyibi-rrimangarna. Wurra ngardawa nginyipa ny-yena, lika ngayburrpa barra nguburr-yirda.” ");
INSERT INTO bvr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ganapiya, lika birripa aburr-garlmuna, mbi-gurrmurra mulucha, warrika jichicha an-murra abi-rrimarra aburr-ni rrapa mulucha mu-garlmunapa mu-gorndiyana m-bona. ");
INSERT INTO bvr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Lika birripa aburr-merndagarlmuna butula abirri-birripa jawina yerrcha mu-gata mu-werranga mu-michiyang abirri-ni, bitipa barra abirri-boy gurda ay-ngunyuna rrapa abirri-gunggaja burrwa. Lika bitipa abirri-garlmuna, abirri-garlajinga gurda abirri-bamuna, abirri-bena burrwa. Lika bitipa wugupa gu-ngana abu-menga abirri-jirrapa mu-michiyang mu-guyinda jimarn jarra mu-guybungarna. ");
INSERT INTO bvr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Gun-gata Jayman Birta gu-nana gu-yinmiyana, lika nipa ana-menama gu-rrana gatiya ana-gochila Jesus a-ninya. Minypa a-yinanga nula, “Nguna-bawa, a-lay, Bunggawa! Ngardawa ngaypa ng-guna ngu-werra!” ");
INSERT INTO bvr_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nipa a-yinagata a-wena, ngardawa nipa rrapa aburr-yigipa jawina aburr-gata mu-yigipa mu-michiyang gochila aburr-barrjinga nula Jesus minypa nipa a-wena rrapa birripa abi-rrimarra an-jaranga jichicha. ");
INSERT INTO bvr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Rrapa mu-gata mu-werranga mu-michiyang abirri-gata Jebadi (Zebedee) bijirri-yika walkurpa niya yerrcha Jeymch (James) rrapa Jon, bitipa abirri-yinagatiya rrapa gochila aburr-barrjinga. Wurra Jesus a-wena nula Jayman, “Gala barra ny-jurkuja; wurra gun-nardiya gugu nginyipa burr-ma barra apula ny-boy wurra gama gorlk.” ");
INSERT INTO bvr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ganapiya, lika birripa aburr-bamuna, mbi-rurrgakaja michiyang yi-gata jorrnyjurra. Lika mbi-bawuna mun-birripa michiyang rrapa mulucha, rrapa jichicha burr-guta abu-bawuna aburr-ni, lika Jesus abu-jurrjurrmurra aburr-bona. ");
INSERT INTO bvr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Gun-nerranga rrawa gun-gatiya Jesus a-ni, an-ngardapa an-gugaliya ana-bamuna, a-bena nula Jesus minypa nipa an-gata an-gugaliya burr-guya an-jeja a-ngolkuja, minypa gun-guburlububurluja gu-rrimarra. Gatiya waypa a-nana Jesus, lika ana-menama gu-rrana nula nipa ana-gochila, a-mobulurrmiyana bukula a-jirra gu-jel, minypa a-burrmaymbuna, “Bunggawa, nginyipa ganyjarr n-dimanga barra minyja nginyipa jal nyi-ni, gun-nerra ny-yerrnyja apula rrapa minypa wanngu nguna-nega.” ");
INSERT INTO bvr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Lika Jesus mernda a-jirra a-jerrjangardawiyana, a-rrimarra an-gata gun-guburlububurluja gu-rrimarra. A-yinanga nula, “Ngaw, ngaypa jal ngu-nirra. Ny-molamiyapa barra!” Lika warrika gun-gata gun-nerra gu-bona nula an-gata an-gugaliya. ");
INSERT INTO bvr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Lika Jesus burr-guya a-wena nula, “Gala barra nguna-ngurrja ngaypa ngiy-jarlapuna. Wurra gun-narda gun-nginyipa wupa janguny yongun nyi-nega barra. Wurra boy, gurdagurdarriya nula junggay an-guyinda, rrapa wu minyjak barra nipa a-yalpa nula Wangarr an-nigipa. Ngardawa gu-gurda ngacha joborr Mojich gu-gurrmurra gun-guwarr minypa barra wurra gama gorlk marn․gi aburr-ni nggula minypa gun-nerra gu-bona nggula.” ");
INSERT INTO bvr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Gun-gata nipa Jesus a-wenapa minypa “Gala barra nguna-ngurrja ngaypa ngiy-jarlapuna,” wurra mu-nguy janguny gu-barrjekarrapa nula gu-bona, rrapa aburr-jaranga wurra gama gorlk gu-ngardapa aburr-negiyana nula aburr-workiyana janguny barra aburr-galiya nula, rrapa nipa barra gun-nerra gu-yerrnyja burrwa. ");
INSERT INTO bvr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Wurra wolawola nipa ngardapa a-bona a-workiyana gu-werrapa, rrapa gatiya minypa a-wengganana a-ni Nyanyapa arrku waykin a-nirra. ");
INSERT INTO bvr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Gun-gatiya gun-ngardapa ngorrngurra gu-ni, Jesus a-ninya gu-bala gatiya minypa janguny a-wena burrwa a-ni. Rrapa aburr-werranga aburr-ni gatiya, birripa Berachi (Pharisee) yerrcha rrapa joborr marn․gi aburr-gunega, minypa gu-gata gu-rrawa wenga aburr-bona gurda: Galali (Galilee) wenga, rrapa Judíya (Judea) wenga rrawa gu-jirra gu-boya, rrapa Jirúchalam (Jerusalem) wenga. Rrapa Wangarr gun-nika ganyjarr wugupa nula Jesus, nipa wanngu burr-negarra a-bona gu-derdakurderda yerrcha. ");
INSERT INTO bvr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Rrapa gatiya gugu aburr-werranga gu-galiya yerrcha abu-ganyja gurda aburr-bamuna an-birripa an-borrmunga an-nyarlkuch, jimarna barra abu-ga wupa rrapa abu-barnja gatiya Jesus ana-gochila. ");
INSERT INTO bvr_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Wurra gala aburr-yinmiyarna, ngardawa wurra gama gorlk aburr-gorlkakaja aburr-ni. Lika an-gata an-nyarlkuch birripa abu-ganyja aburr-warrchinga waykin gu-bala, lika gubu-lapkujamurra bala bama gu-jirra gun-gata morliya gu-maya, lika minypa mu-yigipa mu-garrung a-yu abu-gurrmurra aburr-bamuna gojilapa wurra gama gorlk aburr-jinyjapa, lika gatiya a-yunya Jesus ana-rrepara. ");
INSERT INTO bvr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Rrapa gun-gatiya waypa Jesus gu-nana burrwa minypa birripa burr-guya marr aburr-balcha nula aburr-ni, lika nipa a-wena nula an-gata an-nyarlkuch, “A-lay, nginyipa werra nyi-negiyana gipa gugu baywarra gu-ni ngguluwa.” ");
INSERT INTO bvr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jesus a-yinagata a-wena. Wurra aburr-gata Berachi yerrcha rrapa joborr marn․gi aburr-gunega, birripa bama aburr-jirra wupa gubu-borrwurra aburr-ni, “An-guna ana-nga nipa an-gugaliya wana a-negiya a-nirra nula Wangarr? Wurra an-gugaliya werra a-negiya a-workiya gala ana-nga a-yinmiya a-rorrcha nula mari, wurra Wangarr nipa wupa an-ngardapiya jarra.” ");
INSERT INTO bvr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Birripa aburr-yinagata gubu-borrwurra nula Jesus. Wurra gun-narda nipa gu-nana burrwa birripa aburr-yinmiyana gubu-borrwurra, lika nipa a-wena burrwa, “An-nga nula ana-goyburrpa nyiburr-yinagata nyibu-borrwuja apula nyiburr-nirra wuparnana nyiburr-ngurrnga? ");
INSERT INTO bvr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Wurra gun-nga gun-guna jimarna ana-goyburrpa bama nyiburr-yinaga gun-derta apula rraka ngaypa ngu-yirda nula an-guna? Minyja ngu-yinda nula, ‘Nginyipa werra nyi-negiyana ny-yorkiyana gipa gugu baywarra gu-ni nggula,’ gu-gurda ngacha, ya, wurra minyja ngu-yinda nula, ‘Garlma, jarlabiya’? ");
INSERT INTO bvr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Wurra ngaypa arr-gurdagurdarra barra minypa an-guna An-walkurpa An-gugaliya ganyjarr gu-rrimanga gun-guniya rrawa nipa barra baywarra gu-nega ana-gorrburrwa gun-nerra nyibi-rrimarra.” Lika a-wena nula an-nyarlkuch, “A-lay, galiya apula ngu-weya nggula: Garlma, jinyja! Mun-nginyipa garrung ma, lika bamiya boy rrawa.” ");
INSERT INTO bvr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ganapiya, lika gu-gata wenga warrika birripa aburr-gata abi-nana nipa an-nyarlkuch a-garlmuna, mu-menga mun-nigipa garrung nipa mu-rrenyjinga a-yu a-workiyana, lika a-marrkapchinga nula a-bamuna Wangarr yi-gata rrawa. ");
INSERT INTO bvr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Lika aburr-bulapalawa aburr-gata gochila aburr-barrjinga nula rrapa Wangarr abu-ngurrjinga an-molamola. Wurpa lika burr-guya aburr-gurkuja, minypa aburr-yinanga, “A-lay, gun-narda geka ngubi-nana gala ngubi-nacharna nguburr-workiyarna!” ");
INSERT INTO bvr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Gu-gata wenga Jesus a-garlmuna, a-bena yarlanga. Lika nipa a-nana an-ngardapa an-gugaliya an-gata an-nelangga Libay, nipa an-mujama nula gapman rrupiya mu-menga nula a-workiyana, gu-galiya yerrcha burr-gaypuna. Gatiya gu-birlapirla nipa Libay a-ni a-workiyana rrapa jama a-ji nipa Jesus ana-nyala a-nana, lika a-wena nula, “Guwa. Nguna-jurrjurrma.” ");
INSERT INTO bvr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lika nipa Libay a-garlmunapa gu-bawuna gun-gata nipa jama a-ji a-workiyana, lika a-jurrjurrmurra Jesus. ");
INSERT INTO bvr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Gu-gata wenga nipa Libay gun-guworlworlcha gun-guyinda gu-jarlapuna minypa gata gu-yigipa gu-rrawa mbi-barnjinga mun-jaranga balaja Jesus birripa barra mbi-bay. Rrapa aburr-werranga aburr-gatiya wugupa nula Jesus mbi-barra aburr-ni, aburr-jaranga aburr-gata birripa aburr-mujama nula gapman rrupiya mbi-mangga nula aburr-workiya, wurra gama gorlk burrbu-gaypurda. ");
INSERT INTO bvr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Lika Berachi yerrcha aburr-gata rrapa aburr-birripa jawina yerrcha joborr marn․gi aburr-gunega, birripa abu-yopuna aburr-ni Jesus minypa nipa wugupa aburr-gata mbi-barra aburr-ni. Lika burrbu-wengganana aburr-yigipa jawina, “A-lay, an-nga nula ana-goyburrpa wugupa burrwa aburr-guna nyibu-banga nyiburr-nirra? Wurra aburr-guna birripa aburr-mujama nula gapman rrupiya mbi-mangga nula aburr-workiya, minypa wurra gama gorlk burrbu-gaypurda, ngarla! Rrapa aburr-werranga aburr-guna birripa burr-guta aburr-werra!” ");
INSERT INTO bvr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Wurra gun-narda Jesus a-galiyana burrwa, lika gun-maywapa ranginy a-wena burrwa. Minypa a-yinanga, “Gu-galiya yerrcha aburr-gata aburr-mola, birripa gala jal aburr-ni an-buburda barra bin-dima, wurra aburr-gata aburr-yorrpurda birripa wupa jarra. ");
INSERT INTO bvr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Rrapa gu-gurda ngacha minypa ngaypa gala nguna-boyarna burrwa aburr-gata minypa jechinuwa aburr-nirra; wurra jarra ngaypa nguna-bona burrwa aburr-gata aburr-werra birripa barra gun-nerra gubu-bawa.” ");
INSERT INTO bvr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Gu-gata wenga nuwurra aburr-werranga aburr-wena nula Jesus, “A-lay, an-gata Jon rrapa aburr-yigipa jawina, birripa wolawola balaja mbi-bawuja aburr-workiya, Wangarr abu-wengganacha aburr-nirra. Rrapa aburr-gata Berachi yerrcha rrapa aburr-birripa jawina, birripa aburr-yinagatiya balaja mbi-bawuja aburr-workiya. Wurra aburr-nginyipa jawina wuriya, wurra mu-nguy balaja mbi-banga aburr-workiya. Wurra gun-narda an-nga nula?” ");
INSERT INTO bvr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Lika Jesus a-wena burrwa, “Gun-narda ana-goyburrpa ngunabu-wengganana, wurra marrka bubu-borrwa gun-guna gun-maywapa ranginy barra marn․gi nyiburr-ni. Minypa an-ngardapa gochila a-rranapa nipa jiny-ma barra jin-nigipa gama, rrapa gatiya waypa aburr-yigipa jawina aburr-mulpiya nula balaja barra mbi-bay rrapa aburr-worlworlcha burrinyjula, birripa gala aburr-yinmiya wargugu aburr-ni rrapa balaja mbi-bawa; jarra nipa an-gata burdak wugupa burrwa. ");
INSERT INTO bvr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wurra barrwa guna-bamburda aburr-werranga burrbu-gaypa barra, lika abu-ga barra aburr-boy, gun-gatiya jarra minypa aburr-yigipa jawina balaja mbi-bawa barra.” ");
INSERT INTO bvr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Rrapa gun-gata nula minypa birripa Berachi yerrcha abu-wengganana, Jesus barrwa gun-maywapa ranginy a-wena burrwa, minypa a-yinagata, “Ngayburrpa gala nguburr-yinmiya ngubu-gornda mun-geka malarrka, mu-gata mu-geka barra ngubu-birlpa mun-maywa mun-guyinda mun-gugorndurndiya. Ngika. Gala yapa borijipa ngubu-gornda mun-gata mun-geka. Wurra mun-maywa mun-geka gala mun-maywapa rraka mu-geka mu-guyinda ngubu-birlpa mun-maywa.” Jesus a-yinagata gu-ngurrjinga burrwa gun-maywapa ranginy, minypa gun-burral gun-birripa gun-guwarr rrapa barrwa gun-geka janguny nipa guna-ganyja. ");
INSERT INTO bvr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Lika barrwa gun-maywapa ranginy a-wena burrwa meyali gu-ngardapiya, minypa a-yinagata burrwa, “Wayin (wine) mbi-jarlapurda aburr-workiya minypa gurnal mun-girra mbi-mangga aburr-workiya, mbi-jerrjerrjinga aburr-workiya wupa ji-maliyarra ji-guyinda. Wurra gala aburr-yinmiya mbi-jerrjerrja ji-maywa ji-guyinda jin-maliyarra mu-ngoyurra jinyu-derichinga. Ngika. Wurra minypa mun-girra m-bongbongja rrapa wana mu-ni m-bamba, gala yapa jin-gata jin-maliyarra jiny-birljin minypa mun-gata mun-girra m-boga mu-jingin rrapa jin-gata jin-maliyarra gun-nyagara gu-ningin. ");
INSERT INTO bvr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Wurra jarra mun-geka wayin mbi-jerrjerrjinga aburr-workiya ji-maliyarra ji-guyinda ji-geka. ");
INSERT INTO bvr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Wurra ana-nga a-ngamngamjinga mun-maywa wayin (wine), nipa gala jal a-ni mun-geka wayin, jarra nipa a-yinaga, ‘Mun-maywa mun-guyinda wayin, mu-gurda ngacha mun-molamola.’” ");
INSERT INTO bvr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Gu-bamuna, nuwurra Jarradi (Saturday) gu-ni, Jesus rrapa aburr-yigipa jawina aburr-bamuna marlgaway gu-jirrapa gatiya balaja mun-murra mu-jinyjarrapa, mun-anngiya, minypa borichel, wurpa lika mun-nerranga. Rrapa aburr-yigipa jawina minypa mbi-muluwurra aburr-bamuna, murna aburr-jirra aburr-guyinda mbi-wurrwurrguja mun-maliyarra barra m-boy rrapa mbi-bay aburr-bamba. ");
INSERT INTO bvr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Rrapa aburr-werranga aburr-gata Berachi (Pharisee) yerrcha aburr-wena nula Jesus, “A-lay, ana-goyburrpa an-nga nula gun-ngayburrpa joborr nyibu-rrumunga nyiburr-nirra? Wurra geka Jarradi gu-ni ngayburrpa gala nguburr-yinmiya jama nguburr-ji, wurpa niya balaja ngubu-muluwa burr-guta!” Aburr-yinagata aburr-gata Berachi yerrcha aburr-wena minypa gun-birripa wupa joborr gubu-borrwurra aburr-workiyana, wurpa lika gala gurrurta gubi-rrimangarna. ");
INSERT INTO bvr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Wurra Jesus a-yinanga burrwa, “Wurra ana-goyburrpa gala nyibu-borrwa, ya, wola gun-guwarr nipa Daybit (David) a-yinmiyana? Minypa nipa rrapa aburr-yigipa jawina gatiya wugupa nula, birripa aburr-werrmiyana aburr-ni balaja minypa gala mun-nga birripa mbi-bangarna. ");
INSERT INTO bvr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Lika nipa Daybit gu-bala a-barrngumurra Wangarr gun-nika gu-japurra, lika rakaraka mun-gata mun-jimurdayan nipa mu-menga, m-barra, rrapa burr-wuna, birripa aburr-gata aburr-yigipa jawina mbi-barra; wurra jarra junggay yerrcha wupa mbi-banga aburr-workiya mun-narda.” A-yinagata Jesus gu-ngurrjinga burrwa, ");
INSERT INTO bvr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","lika gu-mungbuna minypa nipa a-wena burrwa, “An-guna An-walkurpa An-gugaliya nipa wana an-bapala Jarradi nula.” ");
INSERT INTO bvr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Rrapa gun-nerranga gu-ni Jarradi, Jesus a-barrngumurra gu-bala Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya, lika nipa marn․gi burr-negarra a-ni janguny. Rrapa an-gata an-ngardapa an-gugaliya nipa murna a-jirra an-munganaguwa an-nerra. ");
INSERT INTO bvr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Wurra aburr-gata Berachi yerrcha rrapa joborr marn․gi aburr-gunega, birripa jal aburr-ni mari gubu-garra barra nula Jesus. Lika birripa abi-nana aburr-ni, minypa Jarradi gu-ni nipa minyja a-jarlapa an-gugaliya. Ngardawa gun-birripa joborr: Jarradi gu-ni gu-workiyana, gala jama aburr-jirrarna aburr-workiyarna. ");
INSERT INTO bvr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Wurra Jesus gu-malawurra burrwa birripa gubu-borrwurra aburr-ni, lika nipa a-wena nula murna an-nerra, “Guwa! Ay-ngunyuna jinyja!” Lika nipa an-gugaliya a-garlmuna, ana-jarl, a-jinyja Jesus ana-gochila. ");
INSERT INTO bvr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Lika Jesus a-wena burrwa aburr-gata, “Gun-guna ngaypa barra arr-wenggana: Jarradi nula gun-ngayburrpa joborr gu-yinmiya gu-yurra? Gun-molamola jama nguburr-ji barra, waygaji gun-nerra barra jama nguburr-ji; wanngu arrbi-nega barra, wurra waygaji arrbu-bu barra, ya? Gu-yinmiya gu-yurra arrburrwa joborr?” ");
INSERT INTO bvr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Lika Jesus burr-nana a-gomarriyana a-yu, lika a-wena nula an-gata an-gugaliya, “Jerrjangardawiya murna ny-jirra.” Lika nipa a-jerrjangardawiyana, lika a-molamiyana gugu murna a-jirra. ");
INSERT INTO bvr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Lika aburr-gata Berachi yerrcha burr-guya aburr-bachirramiyana nula Jesus minypa nipa gala gu-borrwujarna burrwa joborr gun-gata birripa minypa gun-derta gubi-negarra aburr-ni aburr-workiyana Jarradi nula. Gu-gurda ngacha. Lika wengga gubu-buna aburr-ni birripa aburr-yinmiya barra abu-bu. ");
INSERT INTO bvr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Gun-gatiya gun-nerranga gu-ni, lika Jesus a-bona gu-bulgapulga barra a-wenggana Nyanyapa arrku waykin a-nirra. Mu-nguy ana-munya a-wengganana a-ni, guna-gepana nula. ");
INSERT INTO bvr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ganapiya, lika nuwurra waypa gu-nayana gu-ji, Jesus a-gonyjinga burrwa aburr-yigipa jawina aburr-gata aburr-jaranga, lika birripa aburr-bona gurda nula. Lika nipa a-jerrjerrjiyana burrwa arr-jirrapa arr-murna rrapa abirri-jirrapa, minypa 12 gu-galiya yerrcha, rrapa burr-ngurrjinga birripa minypa aburr-yigipa aburr-mujama. ");
INSERT INTO bvr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Minypa aburr-gata 12 gu-galiya yerrcha Jesus burr-menga a-ni aburr-guna aburr-welangga: Jayman (Simon) an-gata Jesus barrwa an-nelangga a-garrana Birta (Peter), rrapa an-gata an-nigipa worlapa niya Andru (Andrew), rrapa mola Jeymch (James) rrapa Jon, rrapa mola Bilip (Philip), Bartólamiyu (Bartholomew), ");
INSERT INTO bvr_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Metiyu (Matthew), Domach (Thomas), rrapa Jeymch an-gata Alpiyach (Alphaeus) an-nika an-walkurpa, rrapa Jayman an-gata burr-guya gu-borrwurra rrawa, ");
INSERT INTO bvr_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","rrapa Jurrach (Judas) an-gata Jeymch an-nika an-walkurpa, rrapa Jurrach Yichkériyat (Judas Iscariot) an-gata jurdach aburr-bachirra murna burr-wuna Jesus. ");
INSERT INTO bvr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ganapiya, lika Jesus rrapa aburr-yigipa aburr-mujama gu-bulgapulga aburr-bupiyana gurda aburr-bamuna, gojilapa gu-bulgapulga gu-gera aburr-jinyja; rrapa aburr-werranga aburr-jaranga aburr-gata aburr-yigipa jawina rrapa mola aburr-jaranga wurra gama gorlk, birripa gatiya. Minypa Judíya (Judea) wenga rrawa gu-jirra gu-boya, rrapa Jirúchalam (Jerusalem) wenga, rrapa minypa gochilawa wenga gun-bachirra gu-burnda gu-yurra rrawa Daya (Tyre) rrapa Jaydan (Sidon) ");
INSERT INTO bvr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","birripa aburr-bona gurda barra aburr-galiya Jesus gun-nika janguny, rrapa minypa nipa bin-dima, wanngu aburr-ni. Minypa aburr-jaranga wurra gama gorlk walkwalk abi-rrimarra burr-buna a-workiyana, birripa aburr-molamiyana; walkwalk an-nyagara. ");
INSERT INTO bvr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Minypa aburr-gurdiya gorlk jal aburr-ni barra abi-rrima Jesus, ngardawa barlmarrk guna-beya guna-yurra minypa nipa burr-jarlapurda gu-nirra rrapa gala ana-nga a-ngukiyarna. ");
INSERT INTO bvr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Rrapa Jesus burr-nana aburr-yigipa jawina aburr-gata, lika nipa a-wena burrwa: “Nyiburr-werranga nyiburr-gurda minypa gorlk nyiburr-nyagara, ana-goyburrpa jarra nyiburr-molamola nyiburr-nirra; ngardawa nyiburr-nipa barra nyiburr-workiya Wangarr ana-murna. ");
INSERT INTO bvr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nyiburr-gurda gun-guniya rrawa balaja nyiburr-werrmiya nyiburr-nirra, ana-goyburrpa jarra nyiburr-molamola nyiburr-nirra; ngardawa Wangarr nyirr-wu barra rrapa gala barrwa gun-nga jal nyiburr-ni. Nyiburr-gurda nyiburr-rruwuja, ana-goyburrpa jarra nyiburr-molamola nyiburr-nirra; ngardawa gun-gapa guna-bamburda ana-goyburrpa barra nyiburr-gurdacha nyiburr-ni. ");
INSERT INTO bvr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ana-goyburrpa nyiburr-molamola nyiburr-nirra nyiburr-gata minypa gu-galiya yerrcha gala jal aburr-ni ana-gorrburrwa rrapa gala aburr-gonyja ana-gorrburrwa, wurra minypa gun-bachirra aburr-weya ana-gorrburrwa rrapa nyirrbu-yopurda aburr-workiya, jimarna bama aburr-yinaga ana-goyburrpa nyiburr-werra minypa marr nyiburr-balcharra nula an-guna An-walkurpa An-gugaliya. ");
INSERT INTO bvr_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Minyja birripa aburr-yirda ana-gorrburrwa, ana-goyburrpa buburr-gortkurrcha minypa nyiburr-worlworlchinga. Ngardawa nipa Wangarr gun-molamola gun-guyinda gu-rrimanga ana-gorrburrwa waykin, burraya nuwurra nyibu-ma barra. Ngardawa aburr-gata gala jal aburr-ni ana-gorrburrwa, aburr-birripa nyanyapa burra yerrcha aburr-yinagatiya gala jal aburr-nirrarna burrwa Wangarr burr-yika aburr-mujaruk ngunyuna aburr-guyinda gun-nigipa gubu-ngurrjinga aburr-workiyana wola gun-guwarr. ");
INSERT INTO bvr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Wurra nyiburr-werranga nyiburr-gurda, nipa gorlk wana ana-gorrburrwa, ya? Wurra gun-gata jurdach guna-bamburda burr-guya gun-nerra gu-ni barra ana-gorrburrwa! Ngardawa gun-guniya ana-goyburrpa gipa nyibi-rrimarra gun-goyburrpa; wurpa lika gun-narda gu-boy barra. ");
INSERT INTO bvr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Awa! Nyiburr-gurda mun-jaranga balaja nyibu-banga nyiburr-workiya, jurdach guna-bamburda ana-goyburrpa barra nyiburr-werrmiya nyiburr-ni minypa balaja gun-nyagara gu-ni barra ana-gorrburrwa. Awa! Nyiburr-gurda nyiburr-gurdachinga nyiburr-nirra, jurdach guna-bamburda ana-goyburrpa barra wargugu nyiburr-ni rrapa nyiburr-rruwuja. ");
INSERT INTO bvr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Awa! Ana-goyburrpa nyiburr-gurda aburr-werranga aburr-nyala nyiburr-molamola nyirrbi-nenga aburr-workiya, ya? Wurra jarra jurdach guna-bamburda burr-guya gun-nerra gu-ni barra ana-gorrburrwa, ngardawa gu-gatiya ngacha minypa aburr-birripa nyanyapa burra yerrcha aburr-molamola burrbi-negarra aburr-workiyana aburr-gata aburr-guyolkiya aburr-guyinda aburr-mujaruk. ");
INSERT INTO bvr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Wurra ana-goyburrpa nyiburr-gurda nyiburr-galiyarra apula nyiburr-nirra, ngaypa ngu-weya ana-gorrburrwa ngu-nirra minypa gun-guna: Aburr-gata minypa aburr-bachirra ana-gorrburrwa, wurra ana-goyburrpa barra gurrurta bubi-rrima burrwa; nyiburr-mola buburr-ni burrwa aburr-gata minypa gala jal aburr-ni ana-gorrburrwa. ");
INSERT INTO bvr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Aburr-gata minypa nyirrbu-warburda aburr-workiya ana-goyburrpa, wurra ana-goyburrpa barra nyibu-wenggana burrwa barra nipa Wangarr a-gunggaja burrwa. Rrapa aburr-gata minypa werra nyirrbi-nenga aburr-workiya ana-goyburrpa, wurra ana-goyburrpa barra nyibu-wenggana burrwa barra nipa Wangarr wugupa burrwa. ");
INSERT INTO bvr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ny-yinga ny-jata minyja ana-nga biy-bu ny-nyardapa ny-jera japurra ny-jirra, wurra nginyipa jarra ny-mola nyi-ni barra nula marrban barrwa biy-bun ny-yerranga japurra ny-jirra. Rrapa an-gata ana-nga biy-gaypa molma mun-gunegiya mirikal, wurra mun-nginyipa mun-gumirrka burr-guta gala barra ny-jopa nyi-ni nula. ");
INSERT INTO bvr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wu workiya an-gata ana-nga a-ngiwijinga nggula gun-nga; rrapa an-gata ana-nga biy-gaypurda a-workiya, gala barra ny-yengga nula minypa nipa muna-gurdanyja barra nggula. ");
INSERT INTO bvr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nginyipa barra ny-yinda burrwa ny-yorkiya aburr-werranga minypa nginyipa jal nyi-nirra birripa barra aburr-yirda nggula nginyipa. ");
INSERT INTO bvr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Wurra aburr-gata minypa jal aburr-nirra nggula, birripa minyja nginyipa jal nyi-ni burrwa, gun-narda nipa Wangarr gala barra gu-borrwa nggula jimarna nginyipa ny-molamola. Wurra ngika. Wurra aburr-jaranga aburr-gata werra aburr-negiya aburr-workiya, birripa aburr-yinagatiya gurrurta gubi-rrimanga burrwa aburr-borrmunga aburr-gata minypa jal aburr-nirra burrwa birripa. ");
INSERT INTO bvr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Rrapa aburr-gata minypa aburr-gunggajinga nggula aburr-workiya, birripa minyja nginyipa ny-junggaja burrwa, gun-narda nipa Wangarr gala barra gu-borrwa nggula jimarna nginyipa ny-molamola. Wurra ngika. Wurra aburr-jaranga aburr-gata werra aburr-negiya aburr-workiya, birripa aburr-yinagatiya aburr-gunggajinga burrwa aburr-borrmunga aburr-gata minypa aburr-gunggajinga burrwa birripa. ");
INSERT INTO bvr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Rrapa minyja nginyipa burr-wu ny-yorkiya minypa nginyipa ny-borrwuja burraya gubu-gurdanyja nggula, gun-narda Wangarr gala barra gu-borrwa nggula jimarna nginyipa ny-molamola; wurra ngika. Wurra aburr-jaranga aburr-gata werra aburr-negiya aburr-workiya, birripa burr-guta aburr-wuchichiya aburr-workiya minypa gubu-borrwuja burraya gubu-gurdanyja burrwa, rrapa ngika minypa gurrurta gubi-rrima. ");
INSERT INTO bvr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Wurra ana-goyburrpa jarra aburr-gata minypa aburr-bachirra ana-gorrburrwa, ana-goyburrpa barra gurrurta nyibi-rrima burrwa. Buburr-gunggaja burrwa rrapa burrbu-wu. Gala barra nyibu-borrwa jimarna birripa barra gubu-gurdanyja ana-gorrburrwa. Wurra jarra Wangarr nipa guna-gurdanyja barra ana-gorrburrwa wana gun-bapala, rrapa nipiya Waykin A-nirra ana-goyburrpa nyiburr-yigipa walkurpa yerrcha, minypa Wangarr nipa an-mola burrwa aburr-gata aburr-werra gu-galiya yerrcha gala aburr-japurramaya nula aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Aburr-werranga buburr-gunggaja burrwa buburr-workiya minypa Nyanyapa arrku waykin a-nirra nipa an-gugunggaja. ");
INSERT INTO bvr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Gala barra gun-nerra ny-borrwa burrwa aburr-werranga; gala yapa Wangarr gun-nerra gu-borrwa nggula nginyipa. Gala barra ny-borrwa burrwa nyi-ni aburr-werranga minypa Wangarr barra burr-bu; gala yapa nipa gu-borrwun nginyipa biy-bun. Baywarra nega burrwa aburr-gata aburr-werranga, rrapa nginyipa Wangarr baywarra gu-nega barra nggula. ");
INSERT INTO bvr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Burr-wu workiya barra rrapa Wangarr biy-wu nginyipa. Minypa gun-maywapa nipa barra mu-jolartcha nggula, gu-ngana mu-maya barra, lika a-daltalja barra rrapa mu-jurdicha barra barrwa barra mu-jolartcha nggula, nginyipa barra ny-ma gu-ngana mun-gumaya. Gu-gurda ngacha minypa Wangarr arr-wucha a-workiya; wurpa lika nginyipa ny-ma barra minypa gun-gata mu-ngoyurra nginyipa burr-wuna aburr-werranga.” Jesus a-yinagata a-wena burrwa wurra gama gorlk. ");
INSERT INTO bvr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Rrapa barrwa a-wena burrwa meyali gu-murna minypa gun-guna: “An-gapula an-guyinda gala a-yinmiya an-ngardapa murla mu-rrima nula an-nerranga; gala yapa wugupa abirri-bunggun mu-gochila. ");
INSERT INTO bvr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Rrapa an-gugaliya marn․gi a-nirra a-bamburda gala a-yinmiya nipa a-beyba an-nigipa marn․gi an-gunega, wurra ana-nga warrpam nipa marn․gi a-ni, nipa jarra minypa an-nigipa marn․gi an-gunega a-ni barra. ");
INSERT INTO bvr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Wurra an-nga nula nginyipa minypa nyi-nacha baluk gu-barrngumurra nula an-nginyipa worlapa nggu ana-mipila, wurra minypa gala ny-borrwiya gun-jong wana gun-bapala gu-barrngumurra ngguluwa ny-mipila? Wurra jimarn jarra bama ny-yinaga nipa wupa ngardapa gapula a-nirra, ya? ");
INSERT INTO bvr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","An-nga nula an-nginyipa worlapa nggu nginyipa minypa ny-yeya nula, ‘Dericha, a-lay, ngaypa barra ngu-yerrnyja nggula baluk ny-mipila gu-barrngumurra’? Wurra minypa nginyipa ny-yinagata ny-yeya nula ny-yorkiya wurra jarra gala marn․gi gun-jong wana gun-bapala gu-barrngumurra ngguluwa ny-mipila, nginyipa ny-jarda waykin ny-molamola rrapa wupa ny-yerra. Wurra burdak gun-jong ny-mipila gu-barrngumurra ma, yerrnyja yarlanga, barra nginyipa ny-jana rrapa gun-mola gu-ni nggula nginyipa barra ny-yerrnyja nula an-nginyipa worlapa nggu baluk ana-mipila gu-barrngumurra. ");
INSERT INTO bvr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Gun-molamola gun-jong gala gu-yinmiya mu-rrima mun-nerra balaja, rrapa gun-nerra gun-jong gala gu-yinmiya mu-rrima mun-molamola balaja. ");
INSERT INTO bvr_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Gu-gurda ngacha minypa ngayburrpa marn․gi nguburr-nirra nula gun-jong minyja gun-mola waygaji gun-nerra, minypa mu-guyinmiya ngacha balaja nipa mu-rrimanga. Minypa gala nguburr-yinmiya ngubu-ma mun-gubocha ji-bornangguna ji-guyinda, rrapa gala nguburr-yinmiya gurnal ngubu-ma gu-lokula ana-guyinda; wurra ngika. ");
INSERT INTO bvr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Gun-narda gun-maywapa ranginy, minypa gun-burral an-molamola an-guyinda an-gugaliya arr-jalkakaja a-workiya minypa nipa an-ngurrnga gun-molamola gu-borrwuja a-workiya; wurra an-nerra an-guyinda an-gugaliya nipa jarra werra arr-nenga a-workiya minypa nipa an-ngurrnga gun-nerra gu-borrwuja a-workiya. Ngardawa an-gugaliya gun-nga nipa an-ngurrnga gu-borrwuja, gun-gata minypa nipa ngana a-jirra a-weya a-workiya. ");
INSERT INTO bvr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“An-nga nula ana-goyburrpa bunggawa ngunabi-nenga nyiburr-workiya rrapa gala nyiburr-yinda minypa ngaypa ngu-weya ana-gorrburrwa ngu-workiya? ");
INSERT INTO bvr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Wurra an-gata ana-nga nguna-jurrjurrmunga ngaypa rrapa a-galiyarra apula janguny ngaypa ngu-weya, ngaypa arr-gurdagurdarra barra an-gata an-gugaliya an-guyinmiya ngacha. ");
INSERT INTO bvr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nipa an-gata minypa gun-maywapa ranginy an-gugaliya gu-jarlapuna bala. Minypa a-garrmurra a-bamuna, lika gatiya gu-jandarra nipa gu-gurrmurra gun-nigipa bala. Lika nuwurra waypa bugula guna-warrchinga, gu-buna bala, wurra gun-gata bala gala gu-rrumiyarna; ngardawa an-gata an-gugaliya gu-jarlapuna gun-derta gu-jinyjapa. ");
INSERT INTO bvr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Wurra an-nerranga an-gata ana-nga borijipa a-galiyarra apula a-workiya gun-ngaypa janguny rrapa gala a-yirda a-bamba minypa ngaypa ngu-wena, nipa minypa gun-maywapa ranginy bala gu-jarlapuna, wurpa lika minypa gu-jel gu-gurrmurra. Minypa nipa gala a-garrmungarna rrapa gu-barnjingarna gun-nigipa bala gata wupa; wurra waykin nipa gu-jarlapuna. Lika nuwurra waypa bugula guna-warrchinga, lika gun-gata bala gu-rrumurra; gu-darrdarrjinga gu-bunggunapa laka gu-gayana.” ");
INSERT INTO bvr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Gatiya Jesus gu-wulebana janguny nipa gu-ngurrjinga burrwa a-ni wurra gama gorlk, lika nipa ana-bupiyana ana-bamuna, yi-gata a-bona Gapárniyam (Capernaum). Gatiya waypa a-bena, ");
INSERT INTO bvr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","lika an-ngardapa an-gata Rowm an-guyinda minypa an-dakal a-ganyja a-workiya, nipa an-gata an-nigipa an-mujama burr-guya a-yorrpuna, jimarn jarra a-juwiyarna. Wurra an-gata minypa an-dakal a-ganyja a-workiya, nipa burr-guya jal a-ni nula an-nigipa an-mujama. ");
INSERT INTO bvr_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Minypa nipa a-galiyana janguny an-gata nula Jesus, lika nipa burr-jerrmarra nula Ju (Jew) mu-murna yerrcha, birripa barra abu-wenggana nipa barra ana-garlma rrapa wanngu a-nega an-nigipa an-mujama. ");
INSERT INTO bvr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Gu-gurda ngacha minypa birripa aburr-bena nula Jesus rrapa lika burr-guya aburr-ngiwija nula aburr-ni, aburr-yinanga nula, “Nipa an-gata Rowm an-guyinda minypa an-dakal a-ganyja a-workiya, nipa an-molamola. Ngaw minyja ny-junggaja nula? ");
INSERT INTO bvr_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Minypa nipa jal a-nirra arrburrwa nguburr-guna Yichrayal (Israel) nguburr-bapurr, rrapa minypa nipa a-wena, gubu-gupuna arrburrwa gun-ngayburrpa bala marn․gi nguburr-negiya nguburr-workiya gun-guna rrawa,” aburr-yinagata aburr-wena. ");
INSERT INTO bvr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Lika Jesus a-garlmuna burrwa, aburr-bamunapa aburr-bena rrawa yi-gurrepa an-gata Rowm an-guyinda a-ninyarrapa. Lika nipa burr-jerrmarra aburr-yigipa jawina ay-gata nula Jesus, barra birripa abu-ngurrja nipa an-gata minypa nipa a-yinanga, “Ganapiya, a-lay, Bunggawa. Nginyipa gala barra mu-nguy nyina-bamba minypa nginyipa nyina-boya ngaypa apula. Wurra ngaypa gala ngu-molamola rraka nginyipa nyina-boy apula gun-ngaypa rrawa. ");
INSERT INTO bvr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Gu-gurda nula ngaypa gala mu-ngoyurra ngu-boyarna nggula. Wurra jarra minyja nginyipa ny-yengga, an-ngaypa an-mujama a-molamiya barra. ");
INSERT INTO bvr_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ngardawa ngaypa ngu-yinagatiya minypa nginyipa; minypa an-nerranga mu-ngoyurra a-jirra apula, wurra ngaypa mu-ngoyurra ngu-jirra burrwa aburr-gata aburr-ngaypa an-dakal ngaypa nguburr-ganyja ngu-workiya. Rrapa minypa an-ngardapa ngaypa ngu-weya nula ngu-workiya, ‘Boy!’ lika nipa a-boya a-workiya; rrapa an-nerranga ngaypa ngu-weya nula, ‘Guwa!’ lika nipa ana-jarlabiya ana-workiya; rrapa an-ngaypa an-mujama ngaypa ngu-weya nula, ‘Yinda jama ji!’ lika nipa a-yinagata a-workiya jama a-jirra.” ");
INSERT INTO bvr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Gun-narda Jesus a-galiyana minypa an-gata Rowm an-guyinda a-wena, lika nipa Jesus gochila a-barrjinga nula minypa nipa an-gata gu-werranga gu-rrawa wenga burr-guya marr a-balcha nuluwa. Lika nipa a-ngukurdanyjiyana, a-wena burrwa wurra gama gorlk aburr-gata abu-jurrjurrmurrapa aburr-bamuna, a-yinanga burrwa, “Gun-guna ngaypa ngu-weya ana-gorrburrwa gun-burral: Gala mu-ngoyurra ngu-nacharna an-gugaliya burr-guya marr a-balcharna minypa an-guna; wuriya nipa an-guna gala Yichrayal an-bapurr.” ");
INSERT INTO bvr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Lika aburr-gata nipa Rowm an-guyinda burr-jerrmarra gurda, birripa aburr-jekarra aburr-bamuna, rrawa aburr-bena gugu abi-nana an-mujama gipa a-molamiyana. ");
INSERT INTO bvr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Rrapa nuwurra gun-baykarda ngika, lika Jesus a-garlmuna, a-bona rrawa gun-gata gun-nelangga Neyin (Nain), rrapa minypa aburr-yigipa jawina rrapa barrwa aburr-jaranga gu-galiya yerrcha wugupa nula aburr-bamuna aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Gu-gata wenga Jesus a-bena rrawa yi-gurrepa, lika gugu burr-nana aburr-bena gurda, abu-ganyja aburr-bamuna ay-gata jemitri (cemetery), minypa jin-nigipa mampa niya gipa mu-ngoyurra miliyak jinyu-ni, rrapa nipa an-guna gun-nyagara gu-ni nipa an-ngardapa achila mu-lopa acha, rrapa wurra gama gorlk gu-gatiya wenga rrawa wugupa achila aburr-bamuna. ");
INSERT INTO bvr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Gatiya gugu Jesus jinyu-nana, lika nipa a-worijinga achila. Lika a-wena achila, “Ganapa rruwuja.” ");
INSERT INTO bvr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Lika nipa a-bamuna, mu-rrimarra mun-gata gopin (coffin), lika aburr-gata mbi-ganyja aburr-bamuna gopin aburr-derichinga. Lika Jesus a-wena nula an-gata gun-nyagara gu-nipa, “A-lay, an-yawarriny, ngaypa ng-gunaga ngu-weya nggula ngu-nirra: Nginyipa nyina-garlma!” ");
INSERT INTO bvr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Lika gu-gata wenga nipa an-gata ana-garlmunapa a-wena a-ni. Lika Jesus gatiya jiny-yuna nipa mampa niya. ");
INSERT INTO bvr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Lika birripa aburr-gata burr-guya aburr-gurkuja rrapa an-molamola abu-ngurrjinga Wangarr. Minypa Jesus abu-ngurrjinga, aburr-yinanga, “An-guna nipa minypa wana an-bapala, ngaja, ngarla, Wangarr gun-nika janguny guna-ganyja arrburrwa!” Rrapa minypa barrwa aburr-yinagata, “Gun-guniya gugu Wangarr a-bena arrburrwa ngayburrpa nguburr-guna nguburr-yigipa gu-ngarda yerrcha.” ");
INSERT INTO bvr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Lika gu-gata wenga janguny gu-barrjekarra nula gu-bona, Judíya (Judea) rrawa gu-jirra gu-boya aburr-galiyana nula, rrapa barrwa gun-nerranga rrawa burr-guta. ");
INSERT INTO bvr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Rrapa Jon burr-yika jawina nuwurra waypa birripa aburr-wena nula minypa gun-gata Jesus a-yinmiyana jama a-ji, lika Jon a-gonyjinga butula abirri-jirrapa abirri-gata, ");
INSERT INTO bvr_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","lika bijirri-jerrmarra nula Jesus barra abirri-wenggana. Minypa bitipa abirri-yinda barra nula, “Ny-jurdiya nginyipa nyina-bona arrburrwa nyi-gujerrjerrjiya, wurra waygaji an-nerranga barra nyiburr-gana nula nyiburr-ni, ya?” ");
INSERT INTO bvr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Lika nuwurra waypa bitipa abirri-bena nula Jesus, bitipa abirri-yinagata abirri-wena nula, “A-lay, an-gata Jon bama burr-gurragaja a-workiya, nipa nyjirri-jerrmarra nggula barra birri-wenggana minyja nginyipa ny-jurda nyina-bona arrburrwa nyi-gujerrjerrjiya, wurra waygaji an-nerranga barra nyiburr-gana nula nyiburr-ni.” ");
INSERT INTO bvr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Gun-gatiya gugu Jesus wanngu burr-negarra a-bona aburr-jaranga aburr-gata minypa aburr-gurderdakurderda, rrapa aburr-werranga minypa burr-guya gun-gujuwa gubi-rrimarra, rrapa aburr-werranga minypa walkwalk abi-rrimarra. Rrapa gapula aburr-ni, nipa minypa burr-wuna ganyjarr mipila aburr-jirra aburr-ganana. ");
INSERT INTO bvr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Lika a-wena butula abirri-gata Jon bijirri-yika jawina, “Ana-gotipa birri-boy, birri-ngurrja nula Jon minypa geka nyirri-galiyana rrapa nyirri-nana. Minypa gapula aburr-ni barrwa gugu mipila aburr-jirra aburr-ganana, rrapa minypa aburr-burda aburr-guyinda aburr-rrigirrgnga gugu; rrapa aburr-jeja aburr-ngolkuja aburr-ji minypa gun-guburlububurluja gubi-rrimarra, gun-narda gugu gu-bona burrwa; rrapa minypa aburr-gerna aburr-guyinda barrwa aburr-galiyarra, rrapa minypa mu-ngoyurra gun-nyagara gu-ni barrwa aburr-molamiyana, rrapa minypa aburr-welangga aburr-delipa, birripa aburr-galiyarra aburr-nirra gun-molamola janguny. Gu-gurda ngacha. ");
INSERT INTO bvr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Rrapa minyja ana-nga an-gata gala nguna-bawa, a-jeka, an-gata an-gugaliya Wangarr ana-nyala a-jalkakaja, nipa an-molamola a-nirra.” ");
INSERT INTO bvr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nuwurra waypa Jon bijirri-yika jawina abirri-bona, lika Jesus a-garlmunapa Jon a-ngurrjinga burrwa a-ni wurra gama gorlk aburr-gata. A-yinanga burrwa, “Minypa ana-goyburrpa nyiburr-bona nula nyiburr-workiyana Jon gata gu-werrapa nipa a-ni, an-nga nula nyiburr-bona nula, ya? Wurra ana-goyburrpa jal nyiburr-ni jimarna barra nyibi-na an-gugaliya a-barrjejignga a-workiya minypa mun-maywapa gorrngunya gu-barlmarrk mu-jalanggakaja gu-workiya, ya? ");
INSERT INTO bvr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Wurra gun-narda ngika. Wurra an-nga nula nyiburr-bona nula? Wurra ana-goyburrpa jal nyiburr-ni jimarna barra nyibi-na an-gugaliya mun-molamola mun-guyinda mirikal a-barrngumiya a-workiya, ya? Wurra ngika gun-narda. Wurra aburr-gata mun-molamola aburr-barrngumiya aburr-workiya rrapa gun-jaranga gubi-rrimanga aburr-nirra aburr-workiya, birripa jarra bunggawa an-guyinda gun-nika rrawa aburr-nirra aburr-workiya, ngaja, ngarla; ngika minypa gu-werrapa. ");
INSERT INTO bvr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Wurra an-nga nula ana-goyburrpa nyiburr-bona nula Jon? Wurra ngardawa nipa Wangarr an-nika an-mujaruk, ya? Minyjiya, ngarla! Rrapa gun-narda wupa ngardapa ngika, wurra minypa ngaypa ngu-wengga barra ana-gorrburrwa gun-guna: ");
INSERT INTO bvr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jon an-nardiya mu-jurra a-ngurrjinga, minypa Wangarr a-wena, a-yinanga, ‘Minyja na, an-ngaypa an-mujaruk mu-ngoyurra ngu-jerrma barra nggula, nipa barra nawanawa a-ni nggula jarlakarr.’ ");
INSERT INTO bvr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Buburr-galiya apula; gun-guna gun-burral. Gun-nardiya rrawa an-gugaliya a-ni a-workiyana, wurra an-gata gala ana-nga wana minypa Jon. Wurra wuriya. Wurra an-gata ana-nga gu-rrimanga apula janguny gun-guna ngaypa ngu-weya ana-gorrburrwa ngu-workiya, an-gata an-gugaliya marrban nipa an-nelangga an-delipa, wurra nipa jarra marr a-yinanga an-delipa; Jon nipa an-delipa.” ");
INSERT INTO bvr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Aburr-jaranga wurra gama gorlk aburr-gata aburr-galiyana nula Jesus nipa a-yinagata a-wena, birripa lika gubi-yagurrmurra nula Wangarr gun-nigipa rum, aburr-gata burr-guta minypa aburr-mujama nula gapman rrupiya mbi-mangga nula aburr-workiya, wurra gama gorlk burrbu-gaypurda. Minypa aburr-yinmiyapa aburr-gata gipa mu-ngoyurra aburr-galiyana aburr-workiyana nuluwa Jon rrapa nipa bama burr-gurragaja, aburr-gurdiya birripa aburr-galiyana nula Jesus rrapa gubi-yagurrmurra nula Wangarr gun-nigipa rum. ");
INSERT INTO bvr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Wurra Berachi (Pharisee) yerrcha aburr-gata rrapa aburr-werranga aburr-gata joborr marn․gi aburr-gunega, birripa aburr-ngoyurra gubi-yerrnyjinga gun-gata Jesus a-wena, minypa gipa mu-ngoyurra aburr-ngoyurra gubi-yerrnyjinga Jon a-wena rrapa nipa gala bama burr-gurragajarna. ");
INSERT INTO bvr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Lika nipa Jesus mu-nguy a-wena, a-yinagata, “Nyiburr-gurdiya gorlk ngu-yinmiya barra ngaypa arr-ngurrja, ya? Ana-goyburrpa minypa gun-nga gun-gata gun-maywapa? ");
INSERT INTO bvr_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wurra ana-goyburrpa minypa gun-maywapa gu-ngarda yerrcha aburr-dawurrjinga aburr-workiya gata wurra gama gorlk aburr-nirra aburr-workiya. Minypa birripa gu-ngarda yerrcha aburr-gonyjinga burrwa aburr-workiya gu-gapa gu-guta, aburr-yinaga, ‘Ngayburrpa nyiburr-japarndiyana, wurra ana-goyburrpa gala nyiburr-walagiyarna! Ngayburrpa nyiburr-rruwujana, wurra ana-goyburrpa gala nyiburr-malchingarna arrburrwa!’ ");
INSERT INTO bvr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Gu-gurdiya ngacha gun-maywapa, wurra gun-burral minypa Jon an-gata bama burr-gugurragaja a-workiya rrapa mola an-guna An-walkurpa An-gugaliya. Minypa an-gata Jon nipa gala m-bay a-workiya rakaraka rrapa wayin (wine), rrapa gu-gurda nula ana-goyburrpa nyibu-yopurda nyiburr-workiya, nyiburr-yinaga, ‘Nipa walkwalk a-rrimanga.’ ");
INSERT INTO bvr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Rrapa minypa an-guna An-walkurpa An-gugaliya a-bena ana-gorrburrwa, nipa jarra m-banga a-workiya, wurra ana-goyburrpa nyibu-yopurda nyiburr-workiya nipa burr-guta. Minypa nyiburr-yinaga, ‘Minyja na, an-guna nipa mun-jaranga m-banga a-workiya balaja rrapa wayin; rrapa nipa a-malchinga burrwa aburr-gata aburr-mujama nula gapman rrupiya mbi-mangga nula aburr-workiya, gu-galiya yerrcha burrbu-gaypurda; rrapa aburr-werranga burr-guta aburr-werra nipa an-guna a-malchinga burrwa.’ Ana-goyburrpa nyiburr-yinagata nyiburr-weya nyiburr-workiya, nyibu-yopurda an-guna An-walkurpa An-gugaliya. ");
INSERT INTO bvr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Wurra gun-gata Wangarr gu-borrwurra rrapa jama a-jirra a-workiya, gun-narda aburr-yigipa gu-ngarda yerrcha birripa jarra nyirrbu-gurdagurdarraja aburr-nirra ana-goyburrpa minypa gun-gata gun-molamola gun-jechinuwa.” ");
INSERT INTO bvr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","An-ngardapa an-gata Berachi an-guyinda, nipa a-gonyjinga nula Jesus gu-yigipa gu-rrawa barra balaja mbi-bay. Lika Jesus a-bamuna, gu-yigipa gu-bala a-barrngumurra nula, lika a-rakaja burrwa gatiya minypa balaja mbi-banga aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Rrapa jin-ngardapa gama jin-gata nipa gun-nerra jama jiny-ji jiny-yorkiyana, wurra gun-gatiya waypa nipa gu-borrwurra Jesus m-barra a-ni an-gata Berachi an-guyinda gun-nika rrawa, lika nipa muna-ganyja mun-gungimiya mun-molamola mun-gungolkuja m-bochula mu-guyinda, mun-gata bochula mbi-jarlapuna jandarra gun-molamola gun-gata gun-nelangga alabécha (alabaster). ");
INSERT INTO bvr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nipa jina-bona, jin-duwujana jinyu-ni Jesus ana-rrepara, rrapa gun-nigipa rru a-gurragaja rrepara a-jirra, lika japarna a-negarra mu-yigipa mu-mejimija mu-guyinda, rrapa a-machinga rrepara a-jirra, rrapa ana-rrepara mu-jerrjerrjinga mun-gata mun-molamola mun-gungolkuja. ");
INSERT INTO bvr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Rrapa an-gata Berachi nipa waypa jinyu-nana Jesus rrepara a-jirra a-rrimarra jinyu-ni, lika nipa bama a-yinanga, “Minyja an-guna jimarna Wangarr an-nika an-mujaruk, nipa marn․gi a-nirrarna achila jin-guna ji-guyinmiya ngacha jin-gugaliya a-rrimanga jinyu-nirra, minypa nipa jin-guna gun-nerra jama jiny-jirra jiny-yorkiya.” ");
INSERT INTO bvr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Wurra Jesus a-yinanga nula, “Jayman, a-lay, ngaypa janguny ngu-rrimanga nggula.” “An-nga, a-lay, Bunggawa?” ");
INSERT INTO bvr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Lika nipa Jesus a-yinagata a-wena, “An-ngardapa an-gugaliya rrupiya bijirri-wuna ngardapa ngardapa abirri-jirrapa gu-galiya yerrcha, minypa gun-gapa guna-bamburda bitipa abirri-wu barra. Minypa an-ngardapa an-gugaliya nipa barra muna-gurdanyja nula rrupiya wana, minypa jilpa (silver) mun-guyinda 500, rrapa minypa an-nerranga an-gugaliya nipa barra muna-gurdanyja nula mun-delipa rrupiya, minypa jilpa mun-guyinda 50. ");
INSERT INTO bvr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wurra gu-yurtchingapa gu-bamuna, bitipa gala abirri-yinmiyarna abirri-wucharna, lika nipa baywarra gu-negarra butula mun-gata rrupiya nula. Wurra marrka ngurrja apula: abirri-gata nipa baywarra gu-negarra butula, ana-nga barra burr-guya jal a-ni barra nula?” ");
INSERT INTO bvr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nipa Jayman a-yinagata, “Minyja an-gata nipa baywarra gu-negarra nula mun-gata rrupiya wana, an-gatiya burr-guya jal a-ni barra nula, ya?” Jesus a-yinagata nula, “Nginyipa ny-jarlapuna; gurda ny-yena gun-burral.” ");
INSERT INTO bvr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Lika a-ngukurdanyjiyana achila a-bamuna jin-gata gama, rrapa barrwa a-wena nula Jayman, “Minyja na jin-guna. Ngaypa nguna-bona nggula gun-nginyipa rrawa, wurra nginyipa gala nguna-wucharna bugula rraka ngaypa ngu-wepiyarna rrepara ngu-jirra. Wurra jin-guna gama gu-rru gu-guyinda nguna-wepana rrepara ngu-jirra rrapa japarna nguna-negarra mu-yigipa mu-mejimija mu-guyinda. ");
INSERT INTO bvr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nginyipa gala nguna-machingarna ngaypa. Wurra jin-guna jin-gugaliya, ngaypa nguna-bonapa nipa gala jinyu-derichingarna wurra nipa nguna-machinga rrepara ngu-jirra. ");
INSERT INTO bvr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nginyipa gala mun-gungimiya nguna-ngimangarna bama ngu-jirra. Wurra nipa mu-jerrjerrjinga mun-molamola mun-gungolkuja ngaypa ngu-rrepara. ");
INSERT INTO bvr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Gu-gurda nula ngaypa ngu-weya nggula gun-burral: Nipa jin-guna Wangarr gipa baywarra gu-negarra achila gun-jaranga gun-nerra nipa mu-ngoyurra jama jiny-ji, rrapa gu-gurda nula nipa jin-guna burr-guya gurrurta gu-rrimanga — ngardawa Wangarr baywarra gu-negarra achila gun-jaranga. Wurra an-gata ana-nga Wangarr nipa gun-delipa wupa mari baywarra gu-negarra nula, an-gata an-gugaliya marr a-yinaga gurrurta gu-rrimanga jarra.” ");
INSERT INTO bvr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Lika nipa a-wena achila, “A-jay, gun-gata nginyipa werra nyi-negiyana gipa gugu baywarra gu-ni nggula.” ");
INSERT INTO bvr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Lika aburr-gata wugupa nula Jesus mbi-barra aburr-ni balaja, birripa wupa ngardapa aburr-wengganachichiyana aburr-ni, “An-guna ana-nga nipa gu-borrwuja jimarna nipa wupa baywarra gu-nega nula an-gugaliya werra a-negiyana a-workiyana?” ");
INSERT INTO bvr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Wurra Jesus a-yinanga achila jin-gata gama, “Ngardawa nginyipa marr ny-balcha apula, lika nginyipa wanngu nyi-ni. Ganapiya. Ny-molamola gugu boy.” ");
INSERT INTO bvr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ganapiya, lika gun-baykarda ngika, lika Jesus a-garlmuna, mu-nguy a-bamuna gun-gata rrawa gu-jirra gu-boya, gun-molamola janguny minypa gu-ngurrjinga burrwa a-bona — gun-molamola janguny minypa gun-nardiya gugu Wangarr gun-nika rum, gu-gurda ngacha. Minypa Jesus rrapa aburr-yigipa 12 gu-galiya yerrcha wugupa aburr-bamuna. ");
INSERT INTO bvr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Rrapa minypa mu-gama yerrcha mu-ngoyurra Jesus bin-dimarra, aburr-molamiyana, rrapa minypa walkwalk a-yerrnyjinga burrwa, birripa burr-guta Jesus wugupa aburr-bamuna: Minypa Meri jin-gata jibu-ngurrjinga aburr-workiya Mektaliny (Magdalene), jin-gata nipa a-rrimarra walkwalk arr-ngardapa arr-murna rrapa abirri-jirrapa, minypa 7, gugu jiny-bawuna, lika a-bona; ");
INSERT INTO bvr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","rrapa Jowána (Joanna) jin-gata an-gumarrbipa ngacha Jucha (Chuza), nipa an-mujama nula bunggawa an-gata Ayrat (Herod); rrapa jin-gata jin-nelangga Juchéna (Susanna), rrapa aburr-werranga burr-guta mu-gama yerrcha minypa Jesus wugupa aburr-bamuna aburr-workiyana rrapa balaja aburr-gunggajinga burrwa. ");
INSERT INTO bvr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Rrapa gun-gatiya waypa mu-nguy aburr-jaranga wurra gama gorlk aburr-bena nula Jesus minypa gu-werranga gu-werranga gu-rrawa wenga aburr-bona gurda aburr-ji, lika nipa Jesus gatiya a-wena burrwa a-ni meyali gu-murna minypa janguny gun-guna: ");
INSERT INTO bvr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“An-ngardapa an-gugaliya a-lamajinga a-bona balaja nula, burraya mbi-ma. Minypa nipa mu-mulpuna, lika mipila mu-jirra mu-yerrnyjinga a-bona. Wurra mun-nerranga mun-gata m-bungguna gu-jarlakarr, lika gu-galiya yerrcha aburr-bamuna, mbi-rrenyjinga aburr-ji, rrapa burdacha jin-guyinda jina-bona, m-barra jinyu-ni, mu-wulebana. ");
INSERT INTO bvr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Rrapa mun-nerranga mipila mu-jirra mun-guyinda m-bungguna gu-mernarra gu-guyinda, lika mun-jarlala m-bena, wurra nipa muna-benapa muna-bamuna rrapa gu-gata wenga mu-gorlapunapa, ngardawa bugula gun-nyagara gu-gularrlarrja m-bungguna mun-gata mipila mu-jirra. ");
INSERT INTO bvr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Rrapa mun-nerranga mipila mu-jirra m-bungguna gata ji-bornangguna ji-guyinda, lika mun-jarlala m-bena, lika wana abirri-ni abirri-bamuna wugupa, wurpa lika nipa jin-gata bornangguna jiny-jorlkakaja nula rraka mun-gata nipa an-gugaliya a-lamajinga gala mu-yinmiyarna balaja mu-rrimangarna. ");
INSERT INTO bvr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Rrapa mun-nerranga mun-gata mipila mu-jirra m-bungguna mu-ji gu-molamola gu-jel gu-guyinda, lika gu-gata wenga mun-jarlala m-bena, lika wana mu-ni m-bamuna, lika balaja mun-bulapalawa mu-rrimarra.” Jesus a-yinagata a-wena burrwa, lika barrwa a-gonyjinga, a-yinagata, “Ny-yinga ny-jata minyja gelama ny-jirra ny-jaliyana, borrwa ngaypa ngu-wena!” ");
INSERT INTO bvr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Rrapa nuwurra waypa Jesus burr-yika jawina abu-wengganana aburr-ni gun-gata nula janguny, minypa gun-nga meyali, ");
INSERT INTO bvr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","lika nipa a-wena burrwa a-ni, a-yinanga, “Ana-goyburrpa, ngarla, Wangarr nyirr-menga barra marn․gi nyiburr-ni rrapa meyali nyibi-na gun-japurra gun-gata gun-nigipa rum, wurra aburr-gata aburr-werranga birripa jarra burr-meyali wupa ngaypa ngu-weya burrwa ngu-workiya. ‘Birripa minypa gubi-nacha aburr-workiya, wurpa lika gala aburr-yinmiya gubu-malawa; rrapa aburr-galiyarra aburr-workiya, wurpa lika gala aburr-yinmiya marn․gi aburr-ni.’ ");
INSERT INTO bvr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Gun-gata ngaypa ngu-wena ana-gorrburrwa gun-maywapa ranginy, gun-narda ngika minypa mipila mu-jirra gatni (garden), wurra aburr-gata ngaypa nguburr-ngurrjinga wurra gama gorlk minypa aburr-yinmiya aburr-workiya aburr-galiyarra Wangarr gun-nika janguny. Minypa ngaypa ngu-wena mipila mu-jirra, wurra gun-burral Wangarr gun-nika janguny. ");
INSERT INTO bvr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Rrapa gun-gata ngaypa ngu-wena mun-nerranga mun-gata mipila mu-jirra m-bungguna gu-jarlakarr, wurra gun-burral minypa gu-galiya yerrcha aburr-galiyarra aburr-workiya Wangarr gun-nika janguny, wurpa lika gala gubu-borrwa aburr-ni rraka wanngu aburr-ni, wurra minypa an-gata walkwalk ana-yurtchingapa ana-workiya, burr-gaypurda janguny gun-gata Wangarr burr-wuna. ");
INSERT INTO bvr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Rrapa gun-gata ngaypa ngu-wena mun-nerranga mun-gata mipila mu-jirra m-bungguna gu-mernarra gu-guyinda, wurra gun-burral minypa gu-galiya yerrcha aburr-galiyarra aburr-workiya Wangarr gun-nika janguny, lika warrika marr aburr-balcharra aburr-workiya rrapa aburr-worlworlcharra. Wurra minypa mun-gata mun-jarlala rrepara mu-jirra gala mu-yinmiya m-barrnguma wupa gu-jel, ngardawa mernarra wupa, aburr-gata gu-galiya yerrcha aburr-yinagatiya. Minypa marr aburr-balcharra gun-baykarda ngika; wurra aburr-bamburda, gun-derta gubu-barripurda aburr-workiya, lika gu-gata wenga gubu-bawuja aburr-boya Wangarr gun-nika janguny. ");
INSERT INTO bvr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Rrapa gun-gata ngaypa ngu-wena mun-nerranga mun-gata mipila mu-jirra m-bungguna ji-bornangguna ji-guyinda, wurra gun-burral minypa gu-galiya yerrcha aburr-galiyarra aburr-workiya Wangarr gun-nika janguny, wurra aburr-bamburdapa gun-jaranga gubu-borrwuja aburr-workiya gu-guna gu-yika gu-rrawa — minypa mari, rrapa minypa gerra, rrapa minypa gun-nga birripa burr-guya jal aburr-nirra aburr-workiya. Lika gu-gata wenga janguny gun-nyagara gugu gu-nirra burrwa, jimarn jarra birripa jama aburr-jirrarna nula Wangarr; wurra gun-nyagara. ");
INSERT INTO bvr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Rrapa gun-gata ngaypa ngu-wena mun-nerranga mipila mu-jirra m-bungguna mu-ji gu-molamola gu-jel, wurra gun-burral minypa gu-galiya yerrcha aburr-galiyarra aburr-workiya Wangarr gun-nika janguny, rrapa gubu-borrwuja aburr-bamburda rrapa jechinuwa aburr-nirra aburr-workiya aburr-molamola. Minypa gala aburr-bamapa, wurra mu-nguy aburr-bamburdapa jama aburr-jirra aburr-workiya Wangarr nipa nyanma. ");
INSERT INTO bvr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“An-gugaliya ngana gu-wucha a-workiya lam, gala a-yinmiya gu-yilkaka wupa ana-duram ana-guyinda waygaji wupa mu-garrung. Ngika. Wurra jarra lam ngana gu-wucha, lika waykin gu-wenyagnga barra minypa aburr-nga aburr-boy gurda aburr-ji aburr-naya aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Ngardawa gun-nga gun-gata gu-yilkakiya gu-yurra, burraya yarlanga gu-yu barra; rrapa gun-nga gun-jaranga yongun gu-yurra, burraya aburr-jaranga gubi-na barra rrapa marn․gi aburr-ni barra gun-gata. ");
INSERT INTO bvr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Gun-narda nula bubu-borrwa buburr-ni minypa ana-goyburrpa nyiburr-yinmiya barra nyiburr-galiya janguny. Ngardawa ana-nga minyja nipa gu-rrima a-ni, burraya nipa gu-ma barra wana. Wurra minyja an-gata ana-nga gala gu-rrima a-ni, burraya Wangarr a-garlmapa barra a-gaypa barra an-gata an-gugaliya gun-gata gun-delipa jimarn jarra nipa gu-rrimangarna a-nirrarna.” ");
INSERT INTO bvr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Lika Jesus jin-nika mampa niya rrapa aburr-yigipa worlapa niya yerrcha aburr-bona gurda nula, wurra birripa gala aburr-yinmiyarna rraka aburr-beyarna nula, ngardawa aburr-jaranga wurra gama gorlk aburr-gorlkakaja burrwa aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Lika birripa aburr-wena nula Jesus, “A-lay, jin-nginyipa mampa nggu rrapa aburr-nginyipa worlapa nggu yerrcha aburr-gaba yarlanga aburr-jinyjarra. Birripa jal aburr-nirra aburr-wengga barra nggula.” ");
INSERT INTO bvr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Wurra nipa a-wena burrwa, “Aburr-gata aburr-nga minypa janguny aburr-galiyarra aburr-workiya Wangarr gun-nika rrapa aburr-yinagata aburr-workiya jama aburr-jirra, birripa aburr-gatiya wupa minypa jin-ngaypa mampa apa rrapa aburr-ngaypa worlapa apa yerrcha.” ");
INSERT INTO bvr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Gun-gata gun-nerranga gu-ni ngorrngurra, Jesus rrapa aburr-yigipa jawina mu-michiyang aburr-gortkurrchinga. Nipa a-wena burrwa, “Marrka nguburr-jurrwa nguburr-bamba gu-gapa gu-rrarnba.” Lika aburr-garlmuna, ");
INSERT INTO bvr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","aburr-jurrwurra aburr-bamuna, lika Jesus nipa ngorrngurra gu-bena nula, lika a-yunya. Aburr-bamuna, lika barlmarrk wana gu-bena burrwa, minypa mun-gata michiyang gu-bartpa m-buna m-bona, rrapa birripa bama aburr-yinanga aburr-guybuna aburr-bona. ");
INSERT INTO bvr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Lika Jesus burr-yika jawina aburr-garlmuna, abu-jortkarra, “Bunggawa, a-lay, ngayburrpa nguburr-guna nguburr-guyba barra!” Lika Jesus a-garlmuna, gu-jobujobuna, lika gatiya gugu warrpam gu-ngochinga gun-gata barlmarrk rrapa bartpa wana. ");
INSERT INTO bvr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Lika nipa a-wena burrwa aburr-yigipa jawina, “An-nga nula ana-goyburrpa nyiburr-gurkuja? Wurra jimarn jarra marr nyiburr-balchingarna?” Wurra birripa gochila aburr-barrjinga, aburr-gurkuja aburr-ni, rrapa aburr-wengganachichiyana aburr-ni, “A-lay, an-guna an-guyinmiya ngacha? Minyja barlmarrk rrapa bartpa nipa gu-jobujoburda a-boya, gu-galiyarra nula, ngarla!” ");
INSERT INTO bvr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ganapiya, lika gu-gata wenga aburr-bena rrawa gun-nelangga Geracha (Gerasa), gun-gata Galali (Galilee) bitipa abirri-jirra, wurra gu-gapa gu-rrarnba. ");
INSERT INTO bvr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Lika gun-gatiya waypa Jesus a-gortkurrchinga, an-ngardapa an-gugaliya gu-gatiya a-yika gu-rrawa a-bena nula, nipa walkwalk an-jaranga a-rrimarra. Minypa gipa gun-guwarr nipa gala mirikal a-barrngumiyarna a-workiyarna, rrapa gala rrawa a-yunyarrarna a-workiyarna, wurra a-yu a-workiyana gu-gurrema gu-ngarnama. ");
INSERT INTO bvr_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nipa gatiya waypa a-nana Jesus, lika a-gonyjinga burr-guya rrapa a-bungguna nipa ana-rrepara. Lika ngana waykin a-wena nula, a-yinanga, “Jesus, ny-jurda nginyipa Ny-yalkurpa nula Wangarr biy-yika an-gata wana an-babalapa, nginyipa an-nga nula nyina-bona apula, ya? Wurra ngaypa ngu-ngiwijarra nggula ngu-nirra gala barra nguna-bu, a-la!” ");
INSERT INTO bvr_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nipa an-bachirra an-guyinda walkwalk a-yinagata a-wena nula Jesus, ngardawa nipa Jesus a-wena nula barra nipa an-gata a-bawa a-yurtcha, minypa gipa gun-guwarr ngurrpiny a-ganyja a-workiyana rrapa a-buna. Minypa aburr-gata abu-bamanana aburr-ni aburr-workiyana, birripa minypa murna a-jirra rrepara a-jirra abu-bichinga aburr-workiyana an-gubandawiya jirn (chain), wurra nipa a-rrumurra a-workiyana, lika gu-werrapa a-ganyja nipa walkwalk ana-nyala. ");
INSERT INTO bvr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Lika Jesus a-wena nula, “Ny-yinga ny-yelangga?” Nipa a-yinagata, “Ngaypa ngu-welangga ngunabu-ngurrjinga aburr-workiya ‘An-murra.’” A-yinagata a-wena ngardawa nipa an-gugaliya walkwalk an-jaranga a-barrngumurra nula. ");
INSERT INTO bvr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Lika aburr-gatiya walkwalk yerrcha aburr-ngiwija nula Jesus minypa gala barra nipa burr-jerrma gu-birripa gu-rrawa yi-gata wupa wana gu-babalapa gu-rralala. ");
INSERT INTO bvr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Wurra gun-gata minypa jin-murra bigibigi gu-bulgapulga m-banga jiny-boya, aburr-gata walkwalk yerrcha aburr-ngiwija nula Jesus barra nipa burr-jerrma, yi-gata aburr-boy achila. Lika nipa gu-yagurrmurra burrwa. ");
INSERT INTO bvr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Lika walkwalk yerrcha aburr-bena gurda aburr-yu, abu-bawuna an-gata an-gugaliya, lika aburr-bona yi-gata bigibigi jiny-jirra. Lika jin-gata bigibigi jin-bulapalawa gu-bulgapulga gu-bukula jiny-bupiyana jiny-yurtchinga; jiny-yurtchingapa gu-bugula jiny-juybuna gu-bulgapulga gu-gera. ");
INSERT INTO bvr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aburr-gata gu-galiya yerrcha jaga aburr-ganana achila aburr-workiyana jin-gata bigibigi, birripa waypa gubi-nana gu-yinmiyana, lika aburr-yurtchinga, gubu-ngurrjinga burrwa aburr-bona gu-murna rrawa gun-gata rrapa minypa gu-werrapa gu-werrapa gu-jirra gu-boya burr-guta. ");
INSERT INTO bvr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Lika wurra gama gorlk aburr-garlmuna gurda barra gubi-na an-nga nula. Lika aburr-bena nula Jesus, gugu abi-nana an-gata an-gugaliya walkwalk an-jaranga a-rrimarra nipa mirikal a-barrngumurra rrapa gatiya an-mola a-ni Jesus ana-rrepara. Lika birripa aburr-gurkuja aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Rrapa aburr-werranga gipa mu-ngoyurra gubi-nana, birripa lika gubu-ngurrjinga burrwa aburr-bona an-gata an-gugaliya a-yinmiyana a-molamiyana. ");
INSERT INTO bvr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Lika gu-galiya yerrcha gata aburr-guyinda abu-wengganana Jesus barra nipa burr-bawa rrapa minypa a-boy gu-werranga gu-rrawa. Ngardawa birripa burr-guya aburr-gurkuja. Lika gu-gata wenga Jesus a-garlmuna, mu-michiyang a-gortkurrchinga, burr-bawuna a-bona. ");
INSERT INTO bvr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Rrapa an-gata an-gugaliya walkwalk a-rrimarra, nipa a-ngiwija nula Jesus minyja wugupa abirri-boy. Wurra Jesus a-jerrmarra minypa a-yinanga nula, ");
INSERT INTO bvr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Rrawa boy, wengga burrwa nipa Wangarr a-yinmiyana jama a-ji nggula.” Lika nipa an-gugaliya a-bona, ay-gata rrawa gu-jirra gu-boya a-wena burrwa a-bona minypa nipa Jesus a-yinmiyana jama a-ji nula. ");
INSERT INTO bvr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nuwurra waypa Jesus a-jekarra gu-gapa gu-rrarnba, lika wurra gama gorlk aburr-bena nula ngardawa gipa mu-ngoyurra birripa aburr-ganana nula aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Lika an-ngardapa an-gugaliya ana-bona, a-bena nula, nipa an-nelangga Jayrach (Jairus). Nipa an-gatiya jaga a-ganana a-workiyana gun-gata bala Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya. Minypa nipa ana-bonapa a-bungguna Jesus ana-rrepara, bukula a-jirra gu-jel a-yunya, lika a-ngiwija nula barra abirri-boy gun-nigipa rrawa Jayrach gun-nika. ");
INSERT INTO bvr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ngardawa nipa jin-ngardapiya nula jin-walkurpa minypa gu-derda wana jiny-yorrpuna, jimarna gun-nyagara gu-ni. Nipa jin-gata jin-ngamangama gipa minypa jemberr gu-ni achila arr-jirrapa arr-murna rrapa abirri-jirrapa, minypa 12. Ganapiya, lika nipa Jesus a-garlmuna nula, rrapa minypa aburr-jaranga wurra gama gorlk gatiya wugupa aburr-bamuna abu-marnjinga. ");
INSERT INTO bvr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Rrapa jin-ngardapa gama jin-gata jiny-jortchinga jiny-yorkiyana gun-gatiya nipa jiny-yorrpuna jiny-yu gun-bulawa jemberr minypa 12, rrapa gala ana-nga a-yinmiyarna wanngu jinyu-nengarna. ");
INSERT INTO bvr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nipa jin-gata Jesus ana-jonama jina-bamuna, jiny-bena, lika mirikal murna mu-jirra mu-rrimarra nula, gugu jinyu-derichingapa mu-ngoyurra jiny-jortchinga jiny-ji jiny-yorkiyana. ");
INSERT INTO bvr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Lika Jesus a-garlmuna, a-wena burrwa, “Ana-nga nguna-rrimarra?” Wurra birripa aburr-jaranga aburr-wena, “Ngayburrpa ngika.” Rrapa minypa Birta a-yinanga nula, “Bunggawa, a-lay, gala burr-na aburr-guna aburr-jaranga wurra gama gorlk bubu-marnjinga, ya?” ");
INSERT INTO bvr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nipa Jesus a-yinagata, “Ngika, wurra an-nerranga nguna-rrimarra, ngardawa ngaypa marn․gi barlmarrk gu-bona apula.” ");
INSERT INTO bvr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Lika jin-gata gama nipa waypa gu-borrwurra minypa Jesus marn․gi achila, lika nipa jiny-yurrwurrjinga jinyu-ni, jina-bonapa jiny-bungguna Jesus ana-gochila, bukula jiny-jirra gu-jel jiny-yunya. Lika jiny-nyurrjiyana nula minypa nipa a-rrimarra gun-gata an-nga nula rrapa jiny-yinmiyana jiny-molamiyana gugu. ");
INSERT INTO bvr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Lika Jesus a-wena achila, “A-jay, walkur, ngardawa nginyipa marr ny-balcha, lika nginyipa ny-molamiyana. Ganapiya. Ny-molamola gugu boy.” ");
INSERT INTO bvr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Gun-gatiya waypa Jesus a-wena achila a-ni, an-mujaruk ana-bona gu-gata wenga Jayrach gun-nika rrawa, lika a-wena nula, “A-lay, Jayrach, jin-nginyipa delipa gipa gugu gun-nyagara gu-ni. Ganapa wenggana an-guna bunggawa.” ");
INSERT INTO bvr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Wurra Jesus a-galiyana gun-gata nipa a-wena, lika a-garlmuna, a-wena nula Jayrach, “Gala barra ny-jurkuja. Wurra marr balcha apula barra nipa jiny-molamiya barra.” ");
INSERT INTO bvr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Lika gu-gata wenga aburr-bena rrawa. Lika Jesus a-wena burrwa aburr-werranga gala barra wupa aburr-barrnguma gun-gata gu-bala, wurra aburr-guna wupa barra aburr-boy gurda: Birta (Peter) rrapa Jon rrapa Jeymch (James), rrapa minypa mampa acha rrapa nyanyapa acha, ganapiya, aburr-gurdiya wupa. ");
INSERT INTO bvr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Rrapa aburr-gata wurra gama gorlk aburr-rruwujana rrapa aburr-buyana achila aburr-ji, birripa Jesus a-wena burrwa, “Ganapa buburr-rruwuja. Jin-guna gala jiny-juwiyarna, wurra nipa jarra jiny-yurra.” ");
INSERT INTO bvr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wurra birripa aburr-gurdachinga nula, ngardawa birripa gipa marn․gi nipa jin-gata gun-nyagara gu-ni. ");
INSERT INTO bvr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Wurra Jesus a-barrngumurra wupa gu-ngarnama, lika jin-dimarra murna jiny-jirra, lika waykin a-wena achila, a-yinanga, “Delipa, a-jay, garlma!” ");
INSERT INTO bvr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Lika nipa jin-gata gugu jin-mawunga jina-jekarrapa warrika jiny-jarlmuna. Lika nipa Jesus a-wena burrwa barra balaja jibu-wu. ");
INSERT INTO bvr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Rrapa mampa acha nyanyapa acha gochila abirriny-barrjinga abirrinyu-ni achila jin-gata, wurra nipa Jesus burr-guya a-wena burrinyjula gala barra gubirriny-nyurrja gun-gata minypa gu-yinmiyana gu-bamuna. ");
INSERT INTO bvr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesus a-gonyjinga burrwa aburr-yigipa 12 gu-galiya yerrcha, lika birripa yi-gurrepa aburr-negiyana nula. Lika nipa ganyjarr burr-wuna rrapa burr-gurrmurra birripa barra walkwalk an-guyinda abi-yerrnyja rrapa wanngu burrbi-nega aburr-boy wurra gama gorlk. ");
INSERT INTO bvr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Minypa nipa a-wena burrwa barra aburr-boy, gubu-ngurrja burrwa aburr-boy Wangarr gun-nika rum, rrapa minypa burrbi-rrima barra aburr-boy. ");
INSERT INTO bvr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Minypa Jesus a-yinagata burrwa, “Gala barra gun-nga nyibu-ga, minypa gun-gugarlakarlaja gun-jong rrapa burlupurr mun-gubirrnggiya rrapa balaja, rrupiya. Wurra ngika wupa. Wurra jarra mun-ngardapiya wupa mun-gubarrbiya nyiburr-barrnguma barra nyiburr-boy. ");
INSERT INTO bvr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Rrapa gun-gata gu-murna rrawa nyiburr-bengga, minyja ana-nga an-gata a-gonyja ana-gorrburrwa gu-yigipa gu-rrawa, gatiya barra nyiburr-ni gu-maywapa nuwurra waypa nyibu-bawa gun-gata gu-murna rrawa. ");
INSERT INTO bvr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Wurra minyja gala ana-nga a-gonyja ana-gorrburrwa gu-yigipa gu-rrawa, bubu-bawa gun-gata gu-murna rrawa rrapa gatiya rrawa gu-gera buburr-wepiya buburr-boy rrepara nyiburr-jirra baluk gu-gata gu-yika gu-rrawa. Barra birripa nyirrbi-na rrapa aburr-borrwiya minypa birripa aburr-yinmiyana werra aburr-negiyana gun-gata birripa gala aburr-gonyjingarna ana-gorrburrwa.” ");
INSERT INTO bvr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jesus a-yinagata gu-jarlapuna a-wena burrwa, lika aburr-yigipa 12 gu-galiya yerrcha aburr-bona, rrawa gu-jirra gu-boya gubu-ngurrjinga burrwa aburr-bona gun-molamola janguny, rrapa wurra gama gorlk burrbi-rrimarra, aburr-molamiyana. ");
INSERT INTO bvr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Rrapa nipa Ayrat (Herod) an-gata bunggawa a-ni gun-gata rrawa Galali (Galilee), nipa waypa a-galiyana aburr-gata Jesus burr-yika jawina aburr-yinmiyana jama aburr-ji, lika nipa an-gata bambulabulawa a-ni. Ngardawa aburr-werranga aburr-wena aburr-workiyana, abu-ngurrjinga Jesus jimarna nipa an-gata Jon bama burr-gurragaja a-workiyana, wurra minypa gun-gujuwa gu-beybana, ana-jekarra gugu; ");
INSERT INTO bvr_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","rrapa aburr-werranga aburr-wena aburr-workiyana, nipa abu-ngurrjinga Jesus jimarna Yiláyja (Elijah) a-bena; rrapa aburr-werranga abu-ngurrjinga jimarna aburr-mujaruk ngunyuna aburr-guyinda mu-ngoyurra gubu-ngurrjinga aburr-workiyana Wangarr gun-nika nipa an-ngardapa wanngu gugu a-ni, ana-jekarra. ");
INSERT INTO bvr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Minypa Ayrat a-yinanga burrwa, “Ngaypa gipa Jon ngu-jaygorndanga bama a-jirra, wurra an-guna ana-nga an-gugaliya, ya? Minypa janguny guna-jeknga nula guna-workiya, ngaypa ng-galiyarra ngu-workiya minypa nipa burr-barlmarrk jama a-jirra.” A-yinagata Ayrat a-wena, rrapa nipa lika gu-borrwurra a-ni minypa a-yinmiya barra a-na Jesus. ");
INSERT INTO bvr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Lika Jesus burr-yika aburr-mujama aburr-jekarra gurda, lika aburr-darrngurrjiyana nula janguny birripa aburr-yinmiyana jama aburr-ji. Lika nipa burr-ganyja a-bona ngardapa rrawa gun-gata gun-nelangga Bachéyda (Bethsaida). ");
INSERT INTO bvr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Wurra aburr-werranga aburr-gata wurra gama gorlk aburr-galiyana Jesus ay-yinda a-bona, lika abu-jurrjurrmurra. Rrapa nipa gugu a-gonyjinga burrwa, lika gu-ngurrjinga burrwa a-bona janguny Wangarr gun-nika rum rrapa bin-dimarra aburr-gata gu-derda gubi-rrimarra. ");
INSERT INTO bvr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lika nipa yi-rrana gu-ni, Jesus burr-yika 12 gu-galiya yerrcha aburr-garlmuna, aburr-wena nula, “A-lay, aburr-guna wurra gama gorlk, ngaw minyja barra nginyipa burr-jerrma minypa birripa aburr-boy, rrawa gu-jirra gu-boya mbi-ma balaja mbi-bay rrapa gun-ngarnama gubu-barripa barra aburr-yu. Ngardawa gun-guna rrawa gu-werrapa gu-jirra gu-workiya.” ");
INSERT INTO bvr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Wurra lika Jesus a-wena burrwa, “Ngika. Wurra jarra ana-goyburrpa nyirrbu-wu barra mbi-bay.” Birripa aburr-wena, “A-lay, ngayburrpa gala nyibi-rrima mun-jaranga balaja. Wurra rakaraka mun-delipa mun-guyinda nyibi-rrimanga arr-ngardapa arr-murna, minypa 5, mun-narda wupa, rrapa an-delipa jichicha abirri-jirrapa wupa nyibi-rrimanga. Wurra nginyipa bama ny-yinanga jimarna ngayburrpa barra rrupiya nyibu-ga, balaja nyibu-ma burrwa aburr-guna aburr-jaranga, ya?” ");
INSERT INTO bvr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Aburr-yinagata aburr-wena, ngardawa mu-wurra yerrcha aburr-gata burr-guya aburr-jaranga minypa 5,000. Wurra Jesus a-wena burrwa aburr-yigipa jawina, “Buburr-wengga burrwa aburr-guna gu-galiya yerrcha barra 50 aburr-negiya aburr-jiwa rrapa aburr-raka aburr-boy.” ");
INSERT INTO bvr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Lika Jesus burr-yika aburr-mujama aburr-yinagata aburr-wena burrwa aburr-bona. ");
INSERT INTO bvr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Lika Jesus mu-menga mun-gata rakaraka arr-ngardapa arr-murna rrapa an-gata abirri-jirrapa jichicha, lika waykin a-ganana, a-japurramayana nula Wangarr. Lika rakaraka mu-rrumurra rrapa jichicha, lika burr-wuna aburr-yigipa aburr-mujama, birripa burrbu-wuna aburr-bona wurra gama gorlk. ");
INSERT INTO bvr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Birripa aburr-bulapalawa mbi-barra aburr-ni, lika aburr-durtchinga. Rrapa mun-nerranga mbi-bawuna balaja rrapa jichicha Jesus burr-yika jawina mbi-menga, wana burlupurr gu-guyinda mbi-jolartchinga, gu-ngana mu-mayana gun-gata minypa arr-jirrapa arr-murna rrapa abirri-jirrapa, minypa 12. ");
INSERT INTO bvr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nuwurra gun-nerranga gu-ni, nipa Jesus ngardapa a-ni, a-wengganana a-ni Nyanyapa arrku waykin a-nirra, rrapa aburr-yigipa jawina gatiya yi-gurrepa aburr-ni nula. Lika Jesus burr-wengganana, “A-lay, wurra gama gorlk birripa ngunabu-ngurrjinga aburr-workiya minypa ngaypa ngu-ngiya?” ");
INSERT INTO bvr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Birripa Jesus burr-yika jawina gubu-ngurrjinga nula, “A-lay, aburr-werranga aburr-weya, jimarna bama aburr-yinaga nginyipa Jon bama burr-gurragaja a-workiyana; rrapa aburr-werranga aburr-weya jimarna nginyipa Yiláyja; rrapa aburr-werranga aburr-weya jimarna aburr-mujaruk ngunyuna aburr-guyinda mu-ngoyurra gubu-ngurrjinga aburr-workiyana Wangarr gun-nika nginyipa ny-jatiya wanngu gugu nyi-ni, nyina-jekarra.” ");
INSERT INTO bvr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Rrapa nipa a-yinagata, “Aya. Wurra ana-goyburrpa ngu-ngiya ngunabu-ngurrjinga?” Lika Birta (Peter) a-wena, “Ny-jurdiya nginyipa Christ nipa Wangarr gochila nyin-dana.” ");
INSERT INTO bvr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Wurra nipa Jesus a-wena burrwa burr-guya, “Gun-narda gala barra ngunabu-ngurrja burrwa wurra gama gorlk.” ");
INSERT INTO bvr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Rrapa barrwa aburr-yigipa jawina Jesus a-yinagata burrwa, “An-guna An-walkurpa An-gugaliya burr-guya gun-nerra gu-ni barra nula, rrapa minypa aburr-gata mu-murna yerrcha rrapa mola wana junggay yerrcha rrapa joborr marn․gi aburr-gunega birripa ngoyurra aburr-yerryerrmiya barra nula rrapa abu-bu barra a-juwa, rrapa minypa gu-gata wenga ngorrngurra abirri-jirrapa gun-ngardapa, lika nipa Ngun-anya ana-nyala a-jarrkarra barra rrapa wanngu a-nega.” ");
INSERT INTO bvr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Rrapa Jesus a-wena burrwa aburr-jaranga, “Ana-nga minyja nipa jal a-ni barra nguna-jurrjurrma, nipa an-gata gala barra nipa wupa a-borrwiya a-workiya, wurra jarra jama a-ji barra a-workiya gun-gata minypa ngaypa ngu-wu barra, rrapa mu-nguy nguna-jurrjurrmapa barra a-workiya marrban gun-derta gu-barripa. ");
INSERT INTO bvr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ngardawa ana-nga an-gata gala nguna-burdima, wurra minypa nipa jal a-nirra jimarna barra wanngu a-negiya, an-gata an-gugaliya jarra gun-nyagara gu-ni barra. Wurra ana-nga minyja aburr-werranga abu-bu, a-juwa minypa nipa an-ngaypa, an-gata an-gugaliya nipa jarra wanngu a-nipa barra a-workiya. ");
INSERT INTO bvr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Minyja ana-nga an-gata an-gugaliya wana an-babalapa a-negiya gun-nardiya rrawa wurra minypa gala wanngu gun-gunega nipa gu-borrwa a-ni, nipa an-gata gala gun-nga gun-molamola guna-jeka barra nula minypa nipa jama a-ji a-workiyana; wurra gun-nyagara. ");
INSERT INTO bvr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ngardawa ana-nga an-gata minyja a-gurkuja burrwa wurra gama gorlk rrapa gona minypa barra a-ni apula ngaypa rrapa gun-ngaypa janguny, an-gata an-gugaliya nuwurra waypa barra an-guna An-walkurpa An-gugaliya ana-jeka an-molamola warrpam minypa burr-gujayanaya Nyanyapa arrku gun-nika, rrapa minypa aburr-yigipa waykin aburr-guyinda aburr-mujaruk wugupa nula aburr-bupiya barra gurda, nipa An-walkurpa gun-gatiya barra gala barra jal a-ni nula an-gata an-gugaliya. ");
INSERT INTO bvr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Buburr-galiya apula; gun-guna gun-burral: Nyiburr-werranga nyiburr-gurda gala barra mu-ngoyurra nyiburr-juwa, wurra burdak nyibi-na barra Wangarr a-gurrmurrapa bunggawa a-ni barra.” ");
INSERT INTO bvr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nuwurra waypa ngorrngurra gu-yinmiyapa gu-ni, waygaji arr-ngardapa arr-murna rrapa abirri-jirrapa gun-ngardapa, lika Jesus burr-ganyja a-bona Birta rrapa Jon rrapa Jeymch (James); aburr-bona waykin mu-mirk, lika nipa Jesus gatiya a-wengganana a-ni Nyanyapa Arrku waykin a-nirra. ");
INSERT INTO bvr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Lika gun-gatiya waypa nipa a-wengganana a-ni, nipa bukula a-jirra a-ngukurdanyjiyana, rrapa mun-gata mirikal nipa a-barrngumurra a-ji mu-garlmunapa mu-ngarlcha rrapa mu-jayanayana mu-ji. ");
INSERT INTO bvr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Rrapa gatiya gugu abirri-jirrapa gu-galiya yerrcha gipa mu-ngoyurra abirri-guyinda Mojich (Moses) rrapa Yiláyja, bitipa abirri-bena nula Jesus, lika aburr-wena aburr-ji. ");
INSERT INTO bvr_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Minypa bitipa abirri-jayanayana abirri-bena, abirri-wena nula Jesus gun-gata nula minypa Wangarr gu-borrwurra rrapa a-wuna jama, nipa a-juwa barra gun-gata rrawa Jirúchalam (Jerusalem). ");
INSERT INTO bvr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Wurra Birta birripa ngorrngurra bun-dumurra gu-ni, lika gu-gatiya wenga gugu aburr-ganana, abi-nana Jesus a-jayanayana a-ji rrapa abirri-gata abirri-jirrapa gu-galiya yerrcha wugupa nula aburr-jinyja. ");
INSERT INTO bvr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Lika gun-gatiya waypa bitipa abirri-bawuna abirri-bona, lika nipa Birta a-wena nula Jesus. “A-lay, Bunggawa, gun-narda gun-molamola minypa ngayburrpa nyiburr-guna wugupa ana-gorrburrwa. Ngaw minyja ngayburrpa barra ngunyuna nyibi-jarlapa ana-gorrburrwa birlapirla abirri-jirrapa gun-ngardapa, minypa gun-ngardapa gun-nginyipa rrapa gun-ngardapa Mojich gun-nika rrapa gun-ngardapa Yiláyja gun-nika?” Birta a-yinagata a-wena, minypa nipa gala gu-borrwungarna nipa a-yinmiyana a-wena. ");
INSERT INTO bvr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Rrapa nipa burdak a-wena a-ni, nipa nguparr gu-bena gugu, bin-denyjinga. Rrapa Jesus burr-yika jawina aburr-gata aburr-gurkuja aburr-ni gun-gata nguparr bin-denyjinga. ");
INSERT INTO bvr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Gu-gata wenga lika birripa ana-manyjirda aburr-galiyana gu-gata gu-nguparr wenga Wangarr ana-wena, a-yinanga, “An-guna an-ngaypa Walkur ngaypa ngu-jerrjerrjiyana nula an-mujama; nipa wupa ngardapa buburr-galiya nula!” ");
INSERT INTO bvr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Lika ganapiya. Lika abi-nana nipa gugu Jesus ngardapa a-jinyja. Lika aburr-gata Jesus burr-yika jawina yongun gubi-negarra gun-gata birripa gubi-nana; gala ana-nga gubu-ngurrjingarna nula nuwurra waypa Jesus a-juwuna rrapa a-molamiyana. ");
INSERT INTO bvr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Gun-gata Jesus rrapa aburr-yigipa abirri-jirrapa an-ngardapa jawina mu-mirk waykin aburr-ni, lika nuwurra gun-nerranga gu-ni, birripa aburr-bupiyana gurda aburr-bamuna, lika aburr-murra wurra gama gorlk galamurrpa gubu-garrana. ");
INSERT INTO bvr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Lika an-ngardapa an-gugaliya an-gata a-gonyjinga nula Jesus, “Bunggawa, a-lay, an-guna na an-ngaypa walkur an-ngardapiya wupa ngu-rrimanga. ");
INSERT INTO bvr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nipa walkwalk a-burnda a-workiya, borijipa a-nirra, lika nipa a-gonyjinga a-workiya; rrapa nipa a-yerrnyjinga a-workiya gu-jel, lika mun-bordich ana-ngana m-beya. Ngurrpiny burr-guya a-burnda a-workiya minypa gala a-yinmiya a-bawa. ");
INSERT INTO bvr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Rrapa ngaypa ngu-ngiwija burrwa aburr-nginyipa jawina aburr-guna, jimarna barra birripa walkwalk abi-yerrnyjingarna nula, wurra gala aburr-yinmiyarna.” ");
INSERT INTO bvr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Lika Jesus a-wena burrwa aburr-gata, “Ya? Ana-goyburrpa nyiburr-gurdiya gorlk nyiburr-werra! Wurra yama marr nyiburr-balcha nula Wangarr? Ngaypa gu-yinmiyapa ngaypa arr-ga barra rrapa marr ng-ga barra ana-gorrburrwa?” Lika a-wena nula an-gata an-gugaliya, “Nyina-ga an-narda an-nginyipa walkur.” ");
INSERT INTO bvr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wurra nipa waypa ana-bona nula Jesus, nipa walkwalk a-buna, a-yerrnyjinga, nipa a-bungguna, a-jorrpiyana a-yu gu-jel. Wurra Jesus a-jobujobuna walkwalk an-gata rrapa wanngu a-negarra an-delipa, lika a-wuna an-nigipa nyanyapa niya. ");
INSERT INTO bvr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Lika birripa aburr-gata aburr-bulapalawa gochila aburr-barrjinga nula Wangarr minypa nipa wana an-babalapa. Gata waypa birripa burdak gubu-borrwurra aburr-ni nipa a-yinmiyana Jesus burr-barlmarrk jama a-ji a-workiyana, nipa Jesus a-garlmuna, a-wena burrwa aburr-yigipa jawina, ");
INSERT INTO bvr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","a-yinanga burrwa, “Buburr-galiya apula rrapa bubu-borrwa buburr-ni: An-guna An-walkurpa An-gugaliya abi-rrima barra rrapa burrbu-wu barra gu-galiya yerrcha abu-bu barra.” ");
INSERT INTO bvr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jesus a-yinagata a-wena burrwa aburr-yigipa jawina, wurra gun-narda janguny birripa gubu-morrarna; gala yarlanga gu-yurrarna burrwa rraka gubu-malawujarna. Rrapa minypa aburr-gurkuja gala aburr-yinmiyarna abu-wengganacharna gun-gata an-nga nula. ");
INSERT INTO bvr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Lika gu-gata wenga Jesus burr-yika aburr-mujama ngarndarrk ngarndarrk aburr-negiyana minypa birripa ana-nga barra wana a-ni. ");
INSERT INTO bvr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Wurra nipa Jesus gu-nana burrwa gun-gata birripa gubu-borrwurra aburr-ni, lika nipa gugu delipa a-menga, a-garrana, ana-gera a-jinyja. ");
INSERT INTO bvr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Lika a-yinanga a-wena burrwa, “Minyja ana-nga an-mola nula an-guna delipa ngardawa ngaypa ngu-welangga, minypa ngaypa jal ngu-nirra nula delipa, an-gata an-gugaliya nipa ngardawa an-mola apula ngaypa. Rrapa minyja ana-nga an-gata an-mola apula ngaypa, gun-narda minypa nipa an-mola nula nipa an-gata nguna-jerrmarrapa. Minyjiya. Rrapa ny-yinga ny-jata minyja nginyipa ny-yelangga n-delipa nyi-nirra, aburr-werranga aburr-welangga marr aburr-yinaga aburr-delipa, ny-jurda nginyipa ny-yelangga jarra wana ny-bapala.” ");
INSERT INTO bvr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Lika Jon a-wena nula Jesus, “Bunggawa, a-lay, ngayburrpa nyibi-nana an-ngardapa an-gugaliya walkwalk a-yerrnyjinga burrwa minypa nipa biy-menga nginyipa ny-yelangga. Wurra ngayburrpa nyibu-jobujobuna an-gata an-gugaliya, ngardawa nipa gala wugupa arrburrwa ngayburrpa nguburr-guna.” ");
INSERT INTO bvr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Wurra Jesus a-yinagata, “Ganapa bubu-jobujoba an-gata. Wurra minyja ana-nga gala an-bachirra ana-gorrburrwa, nipa jarra an-gata a-gunggajinga ana-gorrburrwa.” ");
INSERT INTO bvr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Gun-gata yi-gurrepa gu-ji gu-bona Wangarr nipa barra a-ga Jesus waykin, nipa Jesus gu-borrwurra a-ni, lika a-garlmuna Jirúchalam. ");
INSERT INTO bvr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Rrapa abirri-yigipa abirri-mujaruk nipa bijirri-jerrmarra, mu-ngoyurra abirri-bona nula gun-ngardapa rrawa gu-ji gu-gata wana gu-bapala gu-rrawa Jimériya (Samaria), gatiya nawanawa abirri-nirrarna nuluwa Jesus. ");
INSERT INTO bvr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Wurra birripa gu-galiya yerrcha aburr-gata gala jal aburr-nirrarna aburr-gonyjingarna nula Jesus, ngardawa birripa gubu-borrwurra nula nipa yi-gata barra a-bamba Jirúchalam. Minyja ana-goyburrpa marn․gi mun-bachirra burrwa Jimériya aburr-guyinda rrapa aburr-gata Jirúchalam aburr-nirra. ");
INSERT INTO bvr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Lika Jesus bijirri-yika abirri-mujama abirri-gatiya Jeymch rrapa Jon, bitipa waypa gun-narda gubirri-nana burrwa aburr-gata Jimériya aburr-guyinda, lika abirri-wena nula Jesus, “A-lay, Bunggawa, jal nyi-nirra ngatipa barra nyirri-wengga bol barra waykin wenga gu-bungga, burr-yalpa, laka burr-ga aburr-gata gu-galiya yerrcha, ya?” ");
INSERT INTO bvr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Wurra Jesus a-murrparriyana butula, bijirri-jonga. ");
INSERT INTO bvr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Lika nipa rrapa aburr-yigipa jawina mu-nguy aburr-bamuna gun-nerranga rrawa. ");
INSERT INTO bvr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Gatiya waypa birripa gu-jarlakarr aburr-bamuna, an-ngardapa an-gugaliya a-wena nula Jesus, “A-lay, ngaypa barra ngiy-jurrjurrmapa barra ngu-workiya ay-yinda yina gaya n-digirrga.” ");
INSERT INTO bvr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Wurra Jesus a-yinagata nula, “A-lay, nginyipa marn․gi an-gata gulukula an-mugat nipa gu-rrimanga rrawa gu-rralala a-yurra a-workiya, rrapa nginyipa marn․gi burdacha jin-guyinda gu-rrimanga nipa gu-gapulawuja jiny-yorkiya, wurra an-guna An-walkurpa An-gugaliya gala gu-rrima rrawa nipa a-yurra a-workiya.” ");
INSERT INTO bvr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Rrapa an-nerranga an-gugaliya nipa Jesus a-wena nula, “A-lay, guwa. Nguna-jurrjurrma.” Wurra nipa an-gugaliya a-yinanga, “A-lay, Bunggawa, ngaw minyja burdak nguna-jerrma, ngu-jeka, an-ngaypa nyanyapa apa nyirri-ni nuwurra waypa nguna-bawa, ngu-jurnumba?” ");
INSERT INTO bvr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Wurra Jesus a-yinagata, “An-gugaliya a-juwiya a-workiya bawa burrwa aburr-werranga gala wanngu aburr-ni birripa barra abu-jurnumba. Wurra nginyipa boy, wurra gama gorlk wengga burrwa boy minypa Wangarr a-gonyjinga burrwa gun-nigipa rum.” ");
INSERT INTO bvr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Rrapa an-nerranga a-wena nula Jesus, “Ngaypa ngiy-jurrjurrma barra, a-lay, Bunggawa. Wurra ngaw minyja burdak mu-ngoyurra ngaypa barra ngu-jeka gu-ngaypa gu-rrawa barra ‘Bobo’ ngu-nega burrwa?” ");
INSERT INTO bvr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Wurra Jesus a-wena nula gun-maywapa ranginy minypa gun-guna: “Minyja ana-nga a-garlmapa jel gu-bu a-bamba, jimarna barra gun-jechinuwa gu-jarlapa, wurra minyja a-jaywarriya rrapa mu-nguy gu-na a-bamba nipa minypa gu-gaya wenga ana-garlmuna, an-gata an-gugaliya gala an-molamola rraka Wangarr ana-murna a-ni.” ");
INSERT INTO bvr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Gu-gata wenga lika Jesus burr-menga barrwa 72 gu-galiya yerrcha, minypa burr-jerrma barra birri-gugu aburr-boy barra rrawa gu-jirra gu-boya nuwurra waypa jurdach nipa. Minypa abirri-jirrapa aburr-maya barra wugupa abirri-boy abirri-ji. ");
INSERT INTO bvr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Minypa Jesus a-wena burrwa a-bamuna, a-yinanga burrwa, “Wurra gama gorlk birripa minypa mun-maywapa balaja mun-murra mu-jinyjarra mun-mola, wurra aburr-yinpa gala aburr-jaranga aburr-mujama rraka mbi-ma. Wurra bubu-wenggana Bunggawa mu-gata nula balaja, barra nipa burr-jerrma aburr-mujama, birripa barra aburr-boy, mbi-ma nula mun-nigipa mun-gata gipa mu-molamiyana. ");
INSERT INTO bvr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Ganapiya, lika buburr-boy. Ngaypa minypa arr-jerrmanga ngu-nirra ana-goyburrpa minypa jip (sheep) jin-gumurna jin-guyinda; wurra buburr-jarlapiya nula an-gata an-mugat an-guyinda. ");
INSERT INTO bvr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Rrapa gala barra ana-goyburrpa nyibu-ga rrupiya rrapa gorlk rrapa barrwa gun-goyburrpa ana-goyburrpa nyiburr-barrngumiya nyiburr-workiya rrepara nyiburr-jirra. Rrapa minypa gu-jarlakarr nyiburr-bamba barra, ana-nga minypa gojilapa galamurrpa nyibu-garra, gala barra nyiburr-dericha rrapa nyiburr-wengga, wurra mu-nguy nyiburr-bampa barra. ");
INSERT INTO bvr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Rrapa nyirri-yinga nyirri-gata nuwurra waypa rrawa nyirri-bengga minypa ana-nga an-gata a-gonyja ana-gotula nipa ana-murna barra nyirri-ni, gatiya waypa gu-yigipa gu-bala nyirri-barrnguma, ana-gotipa nyirri-wengga barra burrwa minypa nyirri-yinda, ‘Wangarr wugupa ana-gorrburrwa barra minypa nyiburr-molamola nyiburr-ni nyiburr-workiya rrapa gala barra gun-nga nyibu-borrwa.’ ");
INSERT INTO bvr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Rrapa minyja ana-nga an-gata an-molamola an-gugaliya, nipa gu-rrima barra a-ni gun-gata gun-molamola ana-gotipa nyirri-wena nula; wurra minyja gun-nyagara, gun-gata gun-molamola gu-ngukiya barra rrapa minypa guna-jeka barra ana-gotula. ");
INSERT INTO bvr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Gata gu-maywapa gu-bala ana-goyburrpa nyiburr-ni barra nyiburr-workiya rrapa balaja nyibu-bay barra mun-nga mun-gata birripa mbi-rrimanga, nuwurra nyibu-bawa gun-gata rrawa. Minypa an-mujama an-guyinda nipa barra mu-ma a-workiya mun-nigipa minypa nipa jama a-ji, gu-gurda ngacha minypa birripa aburr-murna ana-goyburrpa nyiburr-ni barra rrapa balaja nyibu-bay minypa ana-goyburrpa nyiburr-ngaypa nyiburr-mujama. Gala barra nyiburr-gakiya nyiburr-workiya gu-werranga gu-bala. ");
INSERT INTO bvr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Minypa wolawola ana-goyburrpa nyiburr-bengga burrwa nyiburr-workiya gun-birripa rrawa, minyja birripa aburr-gonyja ana-gorrburrwa, lika mun-gata mun-nga mun-birripa birripa mbi-rrimanga ana-goyburrpa barra nyibu-bay, ");
INSERT INTO bvr_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","rrapa aburr-gurderda gatiya rrawa ana-goyburrpa barra wanngu nyirrbi-nega, rrapa nyiburr-yinda barra nyiburr-wengga burrwa, ‘Wangarr yi-gurrepa a-ni ana-gorrburrwa.’ ");
INSERT INTO bvr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Wurra gun-nerranga rrawa gala aburr-gonyja gurda ana-gorrburrwa, wurra minypa jarlakarr gu-yurra gu-bamburda gun-gata rrawa ana-goyburrpa barra nyiburr-bamba, nyiburr-wengga barra burrwa minypa nyiburr-yinda, ");
INSERT INTO bvr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Gun-guniya ngayburrpa nyirrbu-bawuja nyiburr-boya ana-goyburrpa. Rrapa gun-guna rrawa jel nyirr-balkaja ngayburrpa rrepara nyiburr-jirra ngayburrpa nyiburr-wepiya nyiburr-nirra minypa gun-maywapa ana-goyburrpa burr-guya nyiburr-werra. Wurra bubu-borrwa minypa geka Wangarr a-bena yi-gurrepa ana-gorrburrwa.’ Nyiburr-yirda barra nyiburr-wengga burrwa rrawa gun-gata gala aburr-gonyja ana-gorrburrwa. ");
INSERT INTO bvr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ngardawa ngaypa ngu-weya ana-gorrburrwa gun-burral: Jurdach guna-bamburda burr-guya gun-nerra gu-ni barra burrwa gu-gata burr-yika gu-rrawa, wurra minypa mu-ngoyurra aburr-ni rrawa Jorram (Sodom), birripa jarra marr gu-yinda barra gun-nerra gu-ni barra burrwa. ");
INSERT INTO bvr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Awa! Nyiburr-gata rrawa Goréchin (Chorazin) rrapa Bachéyda (Bethsaida) nyiburr-nirra, yama nyiburr-ngukurdanyjiyarna? Wurra burraya burr-guya gun-nerra gu-ni barra ana-gorrburrwa. Wurra aburr-gata mu-ngoyurra aburr-ni rrawa Daya (Tyre) rrapa Jaydan (Sidon), minyja birripa gubi-nacharna gun-birripa rrawa Wangarr burr-barlmarrk jama a-jirrarna minypa gun-guniya nipa jama a-jirra gun-goyburrpa rrawa, birripa gun-nerra gubu-bawujarna aburr-jarl rrapa burr-guya aburr-ngukurdanyjiyarna nula Wangarr. ");
INSERT INTO bvr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Wurra ana-goyburrpa nuwurra waypa barra nipa Wangarr burr-mari a-wengga, burr-guya gun-nerra gu-ni barra ana-gorrburrwa; aburr-gata mu-ngoyurra aburr-ni rrawa Daya rrapa Jaydan, birripa jarra marr gu-yinda barra gun-nerra gu-ni burrwa. ");
INSERT INTO bvr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Rrapa nyiburr-werranga nyiburr-gata Gapárniyam (Capernaum) nyiburr-nirra, ana-goyburrpa jimarna bama nyiburr-yinaga waykin nyirr-wenyaga barra nipa Wangarr, ya? Wurra nipa jarra nyirr-yerrnyja barra yi-gata wupa gu-bol.” Jesus a-yinagata a-wena rrapa burr-jonga aburr-gata gala marr aburr-balcharrarna nula. ");
INSERT INTO bvr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Rrapa barrwa nipa a-wena burrwa aburr-yigipa jawina, a-yinagata burrwa, “Ana-goyburrpa minyja ana-nga a-galiya ana-gorrburrwa, an-narda ngardawa a-galiyarra apula ngaypa. Rrapa minyja ana-nga ngoyurra a-yerryerrmiya ana-gorrburrwa, an-narda ngardawa ngoyurra a-yerryerrmiya apula ngaypa. Rrapa minyja ana-nga ngoyurra a-yerryerrmiya apula ngaypa, an-narda ngardawa ngoyurra a-yerryerrmiya nula nipa nguna-jerrmarrapa.” ");
INSERT INTO bvr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ganapiya, lika nuwurra waypa Jesus burr-yika 72 gu-galiya yerrcha aburr-bona, aburr-jekarra gurda, birripa aburr-worlworlcha aburr-ni. Minypa aburr-yinanga nula, “A-lay, Bunggawa, aburr-gata walkwalk yerrcha burr-guta aburr-galiyarra arrburrwa ngardawa minypa nginyipa ny-yelangga ngayburrpa bubu-mangga.” ");
INSERT INTO bvr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Lika nipa a-wena burrwa, “Ngaypa ngu-nana walkwalk an-gata Jeytan (Satan) an-nelangga, nipa a-bunggunapa waykin wenga minypa maykarran a-mirlchinga a-workiya warlwarl ngika. ");
INSERT INTO bvr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Minyja buburr-galiya: Ngaypa arr-wuna ana-goyburrpa nyibi-rrimanga ganyjarr minypa nguymbula an-guyinda nyibi-rrenyjinga rrapa maringgul ji-jurlpa jin-guyinda. Minypa gun-nga gun-gata ganyjarr an-gata An-bachirra gu-rrimanga, wurra ana-goyburrpa nyibu-rruma barra gun-gata ganyjarr rraka gala gu-yinmiya nyirr-bu. ");
INSERT INTO bvr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Wurra wuriya. Wurra gun-gata wupa nyanma gala barra nyiburr-worlworlcha nyiburr-workiya minypa walkwalk an-guyinda a-galiyarra ana-gorrburrwa; wurra jarra buburr-worlworlcha buburr-ni ngardawa minypa ana-goyburrpa nyiburr-welangga nyiburr-yurra waykin.” ");
INSERT INTO bvr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lika ji-gatiya ji-marnnga nipa Jesus gugu a-marrkapchinga a-ni ngardawa Mern An-mawunga nipa nyanma, rrapa minypa a-yinanga a-wena, “Anya, ny-jurdiya Bunggawa nyi-nirra waykin rrapa wupa, ngaypa ngu-marrkapchinga nggula ngu-nirra ngardawa gun-nginyipa janguny nginyipa ny-yilkakaja burrwa aburr-gata minypa marn․gi gun-jaranga rrapa aburr-borrwiya minypa birripa aburr-guralcha; wurra aburr-geka jarra nginyipa burr-gurdagurdarrana. Ngardawa, Anya, nginyipa ny-borrwurra minypa gu-gurda ngacha gun-molamola gu-ni barra.” A-yinagata Jesus a-wena nula, a-marrkapchinga nula Wangarr. ");
INSERT INTO bvr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ganapiya, lika barrwa a-wena burrwa wurra gama gorlk, a-yinagata, “Ngun-anya nguna-wuna gun-bulapalawa. Gala ana-nga marn․gi nula an-guna An-walkurpa wurra nipa wupa ngardapa Ngun-anya; rrapa nipa Ngun-anya gala ana-nga marn․gi nula wurra an-guna An-walkurpa rrapa barrwa ana-nga nipa a-borrwuja rrapa a-gurdagurdarraja.” ");
INSERT INTO bvr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Lika Jesus a-ngukurdanyjiyana, a-wena burrwa aburr-yigipa jawina ngardapa, “Ana-goyburrpa nyiburr-marrkapchinga nyiburr-nirra gun-gata minypa nyibi-nacha rrapa nyibi-rrimanga nyiburr-nirra. ");
INSERT INTO bvr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Minyja bubu-borrwa: Aburr-jaranga aburr-gata mu-ngoyurra aburr-ni, minypa Wangarr burr-yika aburr-mujaruk ngunyuna aburr-guyinda rrapa bunggawa yerrcha burr-guta, birripa jal aburr-ni jimarn jarra gubi-nacharna gun-burral gu-beyarna burrwa gun-gata minypa ana-goyburrpa nyibi-nacha nyiburr-nirra, wurra gun-nyagara. Rrapa jal aburr-ni jimarn jarra aburr-galiyarna gun-gata ana-goyburrpa nyiburr-galiyarra nyiburr-workiya, wurra gala aburr-yinmiyarna.” ");
INSERT INTO bvr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Rrapa an-ngardapa an-gugaliya an-gata joborr marn․gi an-gunega, nipa a-garlmuna, a-ngunyangunyjiyana nula Jesus. Minypa a-yinanga nula, “A-lay, Bunggawa, ngaypa ngu-yinmiya barra ngu-ma wanngu gun-guni?” ");
INSERT INTO bvr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Lika Jesus a-wena nula an-gata an-gugaliya, “Ya? Gun-ngarripa joborr mu-jurra gu-yinmiya gu-yurra? Marrka ngurrja apula.” ");
INSERT INTO bvr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Lika an-gata an-gugaliya gu-ngurrjinga nula, a-yinagata, “‘An-goyburrpa an-ngardapiya ana-gorrburrwa Wangarr jal buburr-ni nula minypa burr-molma burr-burral, burr-bama burr-rrepara; rrapa an-nginyipa an-borrmunga jal ni nula minypa nginyipa ngardapa nggu jal nyi-nirra nggula.’” ");
INSERT INTO bvr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Lika Jesus a-yinagata nula, “Nginyipa ny-jarlapuna ny-yena, a-lay. Minyja yirda jama ji barra nginyipa wanngu nyi-ni.” ");
INSERT INTO bvr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Wurra nipa an-gata an-gugaliya jal a-ni an-molamola a-negiya barra, lika nipa barrwa a-wengganana Jesus minypa a-yinagata nula, “Wurra nipa an-gata ana-nga minypa an-borrmunga apula?” ");
INSERT INTO bvr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Lika Jesus gu-ngurrjinga nula meyali gu-murna janguny minypa gun-guna: “An-ngardapa an-gugaliya Jirúchalam (Jerusalem) wenga ay-garlmuna, a-bona Jerikow (Jericho). Ana-bupiyana ana-bamuna, gojilapa aburr-bena nula aburr-gata aburr-ngumurda yerrcha. Lika abu-gaypuna aburr-ni mun-gata mun-ngiya nipa mu-ganyja a-bona, rrapa mun-nigipa mun-gubarrnguma burr-guta birripa abu-gaypuna. Lika abu-buna, abu-bawuna, gatiya a-yu barra a-juwa. Lika aburr-garlmuna, aburr-bona. ");
INSERT INTO bvr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Gu-gatiya wenga lika an-ngardapa junggay ana-bamuna gu-jarlakarr. Ganapiya, lika nipa a-nana an-gugaliya a-gorlapuna a-yu, wurra nipa a-garlmunapa gun-nerranga gu-menga a-jekarra rrapa a-beybana ay-bamuna, lika ay-bona. ");
INSERT INTO bvr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Rrapa gu-gata wenga an-nerranga an-gugaliya an-gata Libay (Levi) an-bapurr, nipa a-yinagatiya jama a-ji. Minypa nipa ana-bamuna, a-nana an-gugaliya a-yu, lika ay-bamunapa ay-bona. ");
INSERT INTO bvr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Wurra an-nerranga an-gugaliya ana-bamuna, nipa Jimériya (Samaria) an-guyinda. Ana-bamuna, lika a-nana an-gugaliya a-yu, lika nipa wargugu a-ni nula. ");
INSERT INTO bvr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Lika ana-bona nula, lika an-jeja a-gurragaja mun-girra mun-gata alip (olive) mu-guyinda rrapa mola wayin (wine), lika a-bichinga a-bona, ganapiya. Lika a-jarrkarrana, a-barnjinga jin-nigipa ji-dongki ji-guyinda, lika ana-ganyja ana-bona rrawa gun-gata gojilapa gu-jirra, lika gatiya nipa jaga a-ganana nula. ");
INSERT INTO bvr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Wurra gu-gatiya wenga minypa gun-nerranga ngorrngurra gu-ni, lika nipa a-garlmuna, mu-menga rrupiya abirri-jirrapa mun-mama jilpa (silver) mun-guyinda mu-yigipa m-burlupurr wenga, lika a-wuna an-gata bala an-gurrimapa, a-yinanga nula, ‘A-lay, an-guna an-gugaliya nginyipa jaga ny-jana barra nula rrapa minypa mun-nga barrwa rrupiya ny-barnja mun-nga nipa jal a-ni, rrapa nuwurra waypa ngaypa nguna-jeka barra, lika ngiy-wu barra.’ ");
INSERT INTO bvr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Ganapiya janguny, wurra aburr-gata ngaypa nguburr-ngurrjinga abirri-jirrapa an-ngardapa gu-galiya yerrcha gu-jarlakarr aburr-bamuna gurda, minyja ana-nga an-gata an-borrmunga a-ni nula aburr-bachirra abu-buna, ya?” ");
INSERT INTO bvr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nipa an-gata joborr marn․gi an-gunega a-yinagata, “Minyja an-gata an-gugaliya nipa a-gunggajinga nula.” Lika nipa Jesus ana-nyala a-wena nula, “Ganapiya, wurra nginyipa boy, yirda bamba minypa an-gata an-gugaliya a-gunggajinga nula an-nerranga.” ");
INSERT INTO bvr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Gu-gata wenga Jesus rrapa aburr-yigipa jawina aburr-garlmuna, aburr-bamuna, aburr-bena rrawa gun-gata minypa jin-ngardapa jin-gugaliya jin-gata jin-nelangga Marta (Martha) nipa jiny-jonyjinga nula Jesus gu-yigipa gu-rrawa. ");
INSERT INTO bvr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Gun-gatiya lika jin-nigipa jelapa ngacha jin-gata Meri (Mary) jin-nelangga, nipa jinyu-rakaja gatiya ana-rrepara Jesus a-ni, lika jiny-jaliyana nula jinyu-ni nipa a-wena. ");
INSERT INTO bvr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Wurra nipa jin-gata Marta gun-jaranga gu-borrwurra minypa gun-gata nipa balaja m-barnjinga burrwa Jesus rrapa aburr-yigipa jawina. Lika gu-gata wenga jina-garlmuna, jiny-yena nula, “A-lay, Bunggawa, gala ny-borrwa nyi-ni, ya? Wurra jin-guna jelapa ngapa gu-bawuna, ngaypa wupa ngardapa jama ngu-jirra ana-gorrburrwa? Yama ny-yengga achila barra jiny-junggaja apula?” ");
INSERT INTO bvr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Wurra Jesus a-wena achila, “A-jay, Marta, nginyipa gun-jaranga ny-yorijinga rrapa ny-borrwuja, ya? ");
INSERT INTO bvr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Wurra Meri gu-borrwuja gun-nardiya gun-molamola jarra; rrapa gun-gata gala ana-nga jiny-jaypa.” ");
INSERT INTO bvr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Gun-nerranga gu-ni, gata rrawa Jesus a-wengganana a-ni Wangarr ngardapa, lika nuwurra waypa gu-wulebana, lika aburr-yigipa jawina aburr-wena nula, “Bunggawa, a-lay, minypa an-gata Jon marn․gi burr-negarra aburr-yigipa jawina, wurra nginyipa yama marn․gi nyirr-nega ngayburrpa minypa nyiburr-yinmiya barra nyiburr-workiya nyibu-wenggana Wangarr?” ");
INSERT INTO bvr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Lika nipa a-wena burrwa, a-yinanga, “Wolawola ana-goyburrpa nyibu-wenggana barra nyiburr-workiya, nyiburr-yinda barra nyiburr-wengga: ‘Anya, nginyipa ny-yelangga ngayburrpa barra bubu-ngurrja ny-molamola. Guwa gun-nginyipa rum barra gu-jipa gu-workiya gun-guna rrawa. ");
INSERT INTO bvr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mu-nguy nyirr-wu balaja mun-ngiya ngayburrpa jal nyiburr-ni. ");
INSERT INTO bvr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Rrapa baywarra nega arrburrwa gun-gata minypa ngayburrpa werra nyiburr-negiyana nggula, minypa ngayburrpa rrapa baywarra nyibi-nenga burrwa nyiburr-workiya aburr-werranga aburr-gata minypa werra nyirrbi-negarra ngayburrpa. Gala barra nyirr-ga yi-gata gun-derta gun-gorla nyibu-barripa; gala yapa nyiburr-lijiwarriyan.’” ");
INSERT INTO bvr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Lika Jesus a-yinagata burrwa, “Minyja ny-yinga ny-jata minypa ana-munya gornborrk ny-jarlma, ny-boy nula an-nginyipa an-borrmunga rrapa ny-yinda nula, ‘Japurra ngapa ny-jirra, a-lay! Wurra nguna-wu abirri-jirrapa mun-ngardapa rakaraka rrapa nuwurra ngiy-wu barra. ");
INSERT INTO bvr_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ngardawa an-ngaypa an-borrmunga gun-guna waya ana-munya gu-ni a-bena apula balay wenga, wurra nipa balaja gala mun-nga ngu-rrima rraka ngu-barnja nula an-gata an-borrmunga apula.’ ");
INSERT INTO bvr_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Minyja nginyipa ny-yirda ny-yengga nula an-gata an-gugaliya, nipa a-yinmiya barra waygaji a-wengga nggula? Wurra waygaji wupa gu-bala wenga ana-wengga ana-yu, ‘Ngika. Wurra gala barra mu-nguy ny-yengga apula. Ngardawa ngana gu-jirra gipa ngu-jakabuna rrapa gu-ngarda yerrcha aburr-guna nyiburr-yurra nyiburr-boya. Wurra gala ngu-yinmiya ng-garlma, ngiy-wu.’ An-gata a-yirda barra waygaji a-wengga nggula. ");
INSERT INTO bvr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Wurra gun-guna ngu-weya ana-gorrburrwa gun-burral: Marrban gun-gata minypa nipa gala a-yinmiya biy-wu nginyipa ny-borrmunga nula, wurra jarra burraya a-garlma, biy-wu barra mun-nga nginyipa jal nyi-nirra rrapa minypa ngurrpiny ny-yengganacha nyi-nirra, gala gona nyi-ni. ");
INSERT INTO bvr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Gu-gurda ngacha minypa ngaypa ngu-weya ana-gorrburrwa minypa gun-guna: Wenggana, rrapa nginyipa ny-ma barra. Wechawecha, rrapa nginyipa ny-barripa barra. Duldulja ngana gu-jirra, rrapa nipa gu-lapkujamiya barra nggula. ");
INSERT INTO bvr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ngardawa ana-nga minypa a-wengganacha a-workiya, an-gatiya gu-mangga a-workiya; rrapa ana-nga a-wechawecharra a-workiya, an-gatiya gu-barripurda a-workiya; rrapa ana-nga a-dulduljinga a-jirra ngana gu-jirra, an-gatiya gu-lapkujamiya barra nula. ");
INSERT INTO bvr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ana-goyburrpa nyiburr-gurda wurra ny-yinga ny-jata nginyipa minypa nyanyapa niya, minyja an-nginyipa walkur biy-wenggana jichicha, nginyipa gala ny-yinmiya ny-yu nguymbula. ");
INSERT INTO bvr_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Rrapa minyja nipa biy-wenggana jin-giya nula, nginyipa gala ny-yinmiya ny-yu maringgul ji-jurlpa jin-bachirra gala jin-gubay. ");
INSERT INTO bvr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Minypa ana-goyburrpa nyiburr-gurda wuriya nyiburr-werra, wurra ana-goyburrpa jarra marn․gi gun-molamola gun-guyinda nyirrbu-wu aburr-goyburrpa gu-ngarda yerrcha. Wurra Nyanyapa arrku waykin a-nirra nipa jarra warrpam an-molamola, rrapa aburr-gata minypa abu-wenggana barra nipa burr-wu barra an-gata Mern An-mawunga.” ");
INSERT INTO bvr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Lika gu-gata wenga an-ngardapa an-gugaliya an-gata Jesus a-garlmuna, a-yerrnyjinga nula walkwalk an-gata an-ngarlngarta a-negarra a-ni. Lika an-gata minypa walkwalk ana-bawuna ana-bena, nipa an-gugaliya a-wena gugu. Lika aburr-gata wurra gama gorlk gochila aburr-barrjinga. ");
INSERT INTO bvr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Wurra aburr-werranga aburr-wena, “An-guna an-gugaliya nipa a-yerrnyjinga a-workiya walkwalk an-guyinda ngardawa nipa nyanma Biyíljabap (Beelzebub) an-gatiya wana an-babalapa walkwalk ana-wuna ganyjarr.” ");
INSERT INTO bvr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Rrapa aburr-werranga aburr-gata, birripa jal aburr-ni abu-yolka barra Jesus, minypa birripa abu-wengganana nipa barra burr-gurdagurdarra ganyjarr minypa nipiya Wangarr nyanma. Wurpa lika birripa gala jal aburr-nirrarna marr aburr-balchingarna nula. ");
INSERT INTO bvr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Wurra nipa jarra Jesus gu-malawurra burrwa aburr-gata aburr-jaranga gun-ngiya birripa gubu-borrwurra aburr-ni. Lika nipa a-wena burrwa, a-yinanga, “Gun-nga gun-gata rrawa, minyja aburr-ngorrkorndiya rrapa aburr-bacha gu-gapa gu-guta, gun-narda minypa gun-gata rrawa gu-rrumiya barra gugu gu-werrapa gu-ji barra. Rrapa aburr-nga aburr-gata aburr-yawyawga aburr-marmanyja aburr-barra, minyja birripa aburr-ngorrkorndiya, gun-narda minypa aburr-gata aburr-bapurr aburr-wulebiya barra. ");
INSERT INTO bvr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Rrapa an-gata walkwalk Jeytan an-nelangga nipa a-yinagatiya. Minypa aburr-yigipa nipa burr-ganyja a-workiya, minyja birripa aburr-ngorrkorndiyana rrapa aburr-bacha gu-gapa gu-guta, gun-narda minypa nipa gala a-yinmiya mu-nguy a-ji. Minypa ana-goyburrpa nyiburr-wena minypa ngaypa walkwalk ngu-yerrnyjinga ngu-workiya jimarn jarra Biyíljabap nguna-wuna ganyjarr. ");
INSERT INTO bvr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Wurra minyja gun-narda gun-burral, wurra gun-gata minypa aburr-goyburrpa jawina yerrcha wolawola abi-yerrnyjinga aburr-workiya walkwalk, gun-narda gu-gaya wenga ganyjarr, ya? Wurra walkwalk gun-nika ngika. Wurra aburr-gata aburr-goyburrpa jawina yerrcha, birripa jarra yarlanga gubi-nenga minypa gun-gata ana-goyburrpa ngunabu-yopuna gun-narda gala gun-burral. ");
INSERT INTO bvr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Wurra jarra Wangarr nipa nyanma ngaypa ngu-yerrnyjinga ngu-workiya walkwalk an-guyinda, rrapa gun-narda minypa Wangarr gochila nyin-dana Bunggawa nipa an-guna gugu a-bena ana-gorrburrwa. ");
INSERT INTO bvr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Minypa gun-maywapa ranginy an-gugaliya wolawola derta a-negiya a-workiya, garlpi mu-rrimanga a-nirra rrapa gun-nigipa rrawa gu-bamanacha a-nirra, minypa gun-molamola gu-jirra nula rrapa gala ana-nga a-yinmiya gu-rruma rrapa a-gaypa. ");
INSERT INTO bvr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Wurpa lika an-nerranga wana an-babalapa an-gugaliya minyja nipa ana-boy rrapa burda a-nega an-gata an-gugaliya, nipa a-gaypa barra mun-nigipa garlpi mun-gata nipa m-borrwurra a-ni jimarna mu-gata wanngu a-negiyarna a-nirrarna. Rrapa gun-gata barrwa gun-nga burr-guta nipa gu-rrimarra, wurra an-gata wana an-babalapa a-gaypa barra, lika burr-wu barra aburr-yigipa jawina yerrcha. ");
INSERT INTO bvr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ana-nga an-gata minyja gala an-mola apula, an-gata an-gugaliya nipa an-bachirra apula. Rrapa minyja ana-nga an-gata gala nguna-jurrjurrma rraka wugupa nyirrbu-ma nula nyirri-boy Wangarr aburr-yigipa gu-galiya yerrcha, an-gata an-gugaliya nipa minypa ganday burr-nenga ay-bamburda. ");
INSERT INTO bvr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Wurra bubu-borrwa gun-guna: Walkwalk an-gugaliya a-rrimanga, nipa wolawola ana-beya ana-workiya, lika a-bawuja a-boya rrapa minypa gu-bugula gu-gorla ay-bamburda, a-wechawecharra ay-yinda barra a-ninya, wurra gala gun-molamola gu-barripa. Ganapiya, lika ngardapa niya a-weya, a-yinaga a-workiya, ‘Ngaypa ngu-jeka barra gun-ngaypa rrawa.’ ");
INSERT INTO bvr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Lika ana-jeknga, gu-nacha, minypa nipa a-bawunapa an-gata an-gugaliya gala gun-nerra gu-rrima wurra gipa gugu an-molamola. ");
INSERT INTO bvr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Lika gu-gata wenga nipa walkwalk a-boya rrapa burr-mangga aburr-werranga walkwalk yerrcha birripa burr-guya aburr-werra, nipa marr a-yinaga. Lika burr-ganyja gurda ay-ngunyuna aburr-gatiya minypa arr-ngardapa arr-murna rrapa abirri-jirrapa, minypa 7, lika wugupa aburr-barrngumiya nula ana-ngurrnga an-gata an-gugaliya. Lika aburr-nirra aburr-workiya gatiya, rrapa nipa an-gugaliya jarra mu-ngoyurra gun-nerra gu-ni nula, wurra barrwa gugu burr-guya gun-nerra gu-nirra nula.” ");
INSERT INTO bvr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Gun-gata waypa Jesus a-wena, lika jin-ngardapa gama jiny-jarlmunapa burr-guya jiny-yena, jiny-yinanga nula, “A-lay, jin-gaba nipa biy-mengapa nipa jiny-marrkapchinga jinyu-nirra.” ");
INSERT INTO bvr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Wurra Jesus a-wena, a-yinanga, “Aburr-gata minypa Wangarr gun-nika janguny aburr-galiyarra nula aburr-workiya rrapa gubi-rrimanga aburr-bamburda, aburr-gatiya jarra aburr-marrkapchinga aburr-nirra.” ");
INSERT INTO bvr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Gun-gatiya waypa barrwa aburr-jaranga wurra gama gorlk aburr-bona gurda nula Jesus, lika nipa mu-nguy a-wena burrwa, a-yinagata, “Aburr-gurdiya gorlk aburr-werra! Birripa jal aburr-ni gubi-na barra Wangarr gun-nika ganyjarr, wurra nipa gala barra burr-gurdagurdarra ganyjarr wurpa lika gun-maywapa minypa gun-gata nipa jama a-ji nula Jona (Jonah) mu-ngoyurra a-ni. ");
INSERT INTO bvr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Minypa gu-galiya yerrcha aburr-gata Ninaba (Nineveh) aburr-ni, birripa abi-nana Jona minypa Wangarr a-yinmiyana burr-barlmarrk jama a-ji nula, rrapa gu-gurda ngacha minypa birripa aburr-gurdiya gorlk abi-na barra an-guna An-walkurpa An-gugaliya minypa Wangarr a-yirda barra burr-barlmarrk jama a-ji barra nula nipa. ");
INSERT INTO bvr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Rrapa nuwurra waypa gun-balmapa gu-ji minypa Wangarr burr-mari a-wengga barra, aburr-gurdiya gu-galiya yerrcha aburr-jurnja barra aburr-ni. Ngardawa gatiya nipa burr-mari a-wengga jin-gata wola bunggawa jinyu-ni rrawa gun-gata Jiba (Sheba), nipa gata jiny-ji barra Wangarr ana-gochila rrapa yarlanga gu-nega barra minypa birripa aburr-guna aburr-werra. Ngardawa wola gun-guwarr nipa jin-gata balay wenga jina-bona barra minypa nipa jiny-jaliya nula bunggawa an-gata an-nelangga Jolaman (Solomon), minypa nipa marn․gi gun-jaranga. Wurra jarra gun-burral ngaypa ng-guna wana, nipa Jolaman marr a-yinanga. Wurra aburr-gurdiya gorlk gala marr aburr-balcha apula. ");
INSERT INTO bvr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Rrapa aburr-gata mu-ngoyurra aburr-ni rrawa Ninaba, birripa nyanma burr-guta aburr-gurdiya gorlk aburr-jurnja barra aburr-ni gata minypa Wangarr burr-mari a-wengga barra burrwa. Ngardawa birripa aburr-gata Ninaba aburr-guyinda gatiya aburr-ji barra Wangarr ana-gochila rrapa yarlanga gubi-nega barra minypa aburr-gurdiya aburr-werra. Ngardawa birripa aburr-gata gun-nerra gubu-bawuna rrapa aburr-ngukurdanyjiyana minypa aburr-galiyana nula Jona nipiya Wangarr an-nika an-mujaruk a-wena burrwa. Wurra gun-burral ngaypa ng-guna wana, nipa Jona an-delipa! ");
INSERT INTO bvr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“An-gugaliya lam (lamp) a-birtarrmiya a-workiya, gu-rrongga gu-jirra, gala a-yinmiya gu-yilkaka, waygaji duram a-ngukurdanyja rrapa gu-gonyinyja. Ngika. Wurra jarra an-gugaliya a-birtarrmiya a-workiya, lam gu-rrongga gu-jirra, lika gu-wenyanga a-workiya, gu-balcharra gu-yurra waykin barra minypa aburr-nga aburr-boy gurda aburr-ji aburr-naya aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ngarripa mipila arr-jirra minypa gun-maywapa ranginy lam gu-rrongga gu-jirra barra minypa wuparnana arr-burral arr-naya arr-ni. Rrapa ny-yinga ny-jata minyja nginyipa mipila ny-jirra nyi-nacha ny-yorkiya gun-molamola gun-guyinda, gun-narda minypa gu-gujayanaya nyi-nirra. Wurra minyja mipila ny-jirra nyi-nacha ny-yorkiya gun-nerra, gun-narda minypa nginyipa an-munya ny-maya ny-jirra. ");
INSERT INTO bvr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gu-gurda nula nginyipa barra ny-jarlapiya minypa gun-ngiya nginyipa ny-borrwuja ny-yorkiya. Gala yapa gun-nerra ny-borrwurda rrapa ana-munya nyi-ningin. ");
INSERT INTO bvr_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ngardawa minyja wuparnana ny-burral nyi-nayarra nyi-nirra rrapa gala gun-ngiya n-dima rraka an-munya ny-maya ny-ji, gun-narda minypa nginyipa ny-jayanaya barra ny-yorkiya minypa gu-bardayala nyi-nirra.” ");
INSERT INTO bvr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Gun-gatiya waypa Jesus gu-mungbuna janguny, lika an-ngardapa Berachi (Pharisee) ana-nyala a-gonyjinga nula barra abirri-boy, gu-yigipa gu-rrawa balaja mbi-bay. Lika Jesus a-garlmuna nula, abirri-bamuna, gu-bala abirri-barrngumurra. Lika nipa Jesus a-rakaja, a-ninya. ");
INSERT INTO bvr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Wurra an-gata Berachi nipa gochila a-barrjinga a-nana Jesus balaja m-barra, gala nipa murna a-jirra a-wepiyarna. Ngardawa gun-birripa joborr Berachi yerrcha gun-burriya, murna aburr-jirra aburr-wepiya aburr-workiya, lika nuwurra jurdach balaja mbi-banga aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Wurra nipa Jesus a-yinanga a-wena nula, “Minyja borrwa minypa gun-maywapa ranginy ana-goyburrpa Berachi yerrcha burr-guya nyibu-weparda nyiburr-workiya japalana an-guyinda jonama a-jirra wupa, gochila a-jirra ngika. Minypa gun-burral nyiburr-gata ana-goyburrpa gala nyibu-borrwa nyiburr-workiya gun-gata minypa wuparnana nyiburr-ngurrnga ana-goyburrpa burr-guya nyiburr-werra rrapa nyiburr-ngumurda. ");
INSERT INTO bvr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nyiburr-gurda gerna yerrcha! Nipa jarra Wangarr arr-jarlapuna arr-burral, an-gatiya an-ngardapiya arr-jarlapuna wuparnana arr-ngurrnga burr-guta. ");
INSERT INTO bvr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Wurra mun-ngiya mun-gata ana-goyburrpa nyibi-rrimanga, burrbu-wu aburr-gata aburr-nyagara, barra minypa gun-nga burr-guta gun-mola gu-ni barra ana-gorrburrwa. ");
INSERT INTO bvr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Awa! Nyiburr-gurda Berachi yerrcha, nipa burr-guya gun-nerra gu-ni barra ana-gorrburrwa! Wuriya gun-gata minypa gun-goyburrpa gun-guwarr ana-goyburrpa nyibu-ngorrkorndanga nyiburr-workiya rrapa nyibu-wucha nyiburr-workiya Wangarr mun-nigipa minypa balaja mun-gata nyibu-mangga nyiburr-workiya mun-ngiya mun-delipa burr-guta. Wurra yama gurrurta nyibi-rrima nula Wangarr rrapa jechinuwa nyiburr-ni burrwa wurra gama gorlk? Gu-gurda ngacha jimarna ana-goyburrpa nyibi-rrimangarna joborr rrapa gun-gata gun-delipa gun-guyinda burr-guta. ");
INSERT INTO bvr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Awa! Nyiburr-gurda Berachi yerrcha, nipa burr-guya gun-nerra gu-ni barra ana-gorrburrwa minypa ana-goyburrpa wana nyiburr-negiya burrwa nyiburr-workiya wurra gama gorlk. Minypa gata gu-bala aburr-mulpiya aburr-workiya, ana-goyburrpa nyiburr-bamburda, nyirrbu-beybarda nyiburr-workiya, mu-ngoyurra nyiburr-rakaja burrwa. Rrapa minypa gun-nerranga, ana-goyburrpa jal nyiburr-nirra wurra gama gorlk barra nyirrbu-burrmaymba aburr-workiya ana-goyburrpa, minypa gata gu-gandin birripa aburr-nirra aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Awa! Burr-guya gun-nerra gu-ni barra ana-gorrburrwa! Nyiburr-gurda ana-goyburrpa minypa gun-maywapa ranginy an-gugaliya abu-jurnumburda aburr-workiya gu-jel rrapa gala burrbu-gurdagurdarra yina gaya abu-jurnumbuna, lika aburr-werranga aburr-bamburda, abi-rrenyjinga aburr-workiya rrapa gala marn․gi wuparnana an-gulol.” A-yinagata Jesus a-wena. ");
INSERT INTO bvr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wurra joborr marn․gi aburr-gunega aburr-gata wugupa nula Jesus mbi-barra aburr-ni, ana-ngardapa a-wena nula Jesus, “A-lay, Bunggawa, gun-narda nginyipa ny-yena minypa ngayburrpa burr-guta nginyipa nyirr-ngurrjinga nyiburr-werra.” ");
INSERT INTO bvr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Lika Jesus A-wena, “Ngaw. Nyiburr-gurda joborr marn․gi nyiburr-gunega, ana-goyburrpa burr-guta burr-guya gun-nerra gu-ni barra ana-gorrburrwa! Ngardawa wurra gama gorlk ana-goyburrpa joborr gun-derta gun-gorla nyibi-nenga burrwa nyiburr-workiya, minypa gun-maywapa ranginy gun-gun․gun gun-guyinda aburr-mobula nyibu-gurrmunga burrwa nyiburr-workiya, rrapa minypa ny-jata ny-yinga nginyipa gala ny-yinmiya mernda ny-jirra ny-jerrjangardawiya, wurpa niya murna ny-jirra ny-yarlayarlawiya burr-guta, rraka ny-junggaja burrwa. ");
INSERT INTO bvr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Burr-guya gun-nerra gu-ni barra ana-gorrburrwa! Minypa ana-goyburrpa nyibi-jarlapurda nyiburr-workiya gun-gata gun-gurrema gun-guyinda, wupa gu-ngarnama minypa gatiya nyirrbu-barnjinga nyiburr-workiya Wangarr burr-yika aburr-mujaruk aburr-gata minypa aburr-goyburrpa nyanyapa ana-gorrburra yerrcha burrbu-buna aburr-workiyana, aburr-juwuna. Wurpa lika ana-goyburrpa nyiburr-yinagatiya minypa nyanyapa ana-gorrburra yerrcha; gala janguny nyibu-borrwa burrwa nyiburr-workiya Wangarr burr-yika aburr-mujaruk. ");
INSERT INTO bvr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Minypa ana-goyburrpa marn․gi burrwa aburr-gata nyanyapa ana-gorrburra yerrcha, minypa birripa burrbu-buna aburr-workiyana Wangarr burr-yika aburr-mujaruk, wurra ana-goyburrpa nyibi-yagurrmunga burrwa nyiburr-nirra nyanyapa ana-gorrburra yerrcha gun-gata birripa jama aburr-ji. Minypa birripa burrbu-buna rrapa ana-goyburrpa minypa nyibu-mungburda nyiburr-nirra, nyibi-jarlapurda nyiburr-workiya barra nyirrbu-barnja. ");
INSERT INTO bvr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Minypa gu-gurda nula Wangarr ngardawa nipa marn․gi gun-bulapalawa nipa a-wena, a-yinanga, ‘Ngaypa nguburr-jerrma barra aburr-ngaypa aburr-mujaruk rrapa aburr-ngaypa aburr-mujama birripa barra aburr-bengga burrwa. Wurra birripa aburr-gata aburr-bachirramiya barra burrwa ngaypa nguburr-jerrma barra, aburr-werranga aburr-gurda aburr-juwa barra.’ ");
INSERT INTO bvr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Gu-gurda ngacha minypa nyiburr-gurdiya gorlk nyiburr-mornanga nyiburr-nirra gu-gata nula minypa wola gun-guwarr rrapa barrwa gun-guniya burr-guta ana-goyburrpa Yichrayal (Israel) nyiburr-bapurr nyirrbu-burnda nyiburr-workiya aburr-gata Wangarr burr-yika aburr-mujaruk, birripa aburr-juwiya aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Minypa nyiburr-gurdiya gorlk Wangarr nyirr-bu barra minypa ana-goyburrpa nyiburr-bapurr nyirrbu-buna nyiburr-workiyana aburr-gata minypa Aybul (Abel) wenga, rrapa barrwa an-gata Jekaráya nipa gojilapa a-juwuna gun-gata Wangarr gun-nika bala gun-japurra rrapa gun-nigipa belabila gu-maya gun-gata yarlanga gu-jirra. Minyjiya. Gu-gata nula gun-bulapalawa mari Wangarr nyirr-bu barra ana-goyburrpa nyiburr-gurdiya gorlk. ");
INSERT INTO bvr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Awa! Nyiburr-gurda joborr marn․gi nyiburr-gunega, nipa burr-guya gun-nerra gu-ni barra ana-gorrburrwa! Ngardawa minypa gi (key) an-gulapkujama an-gata minypa marn․gi nula, ana-goyburrpa nyibu-jordajinga nyibu-ganyja nyiburr-workiya. Minypa ana-goyburrpa gala jal nyiburr-ni rraka marn․gi nyiburr-ni, rrapa barrwa minypa wurra gama gorlk nyiburr-gorlkakaja burrwa nyiburr-workiya rraka birripa gala aburr-yinmiya marn․gi aburr-ni.” A-yinagata a-wena Jesus. ");
INSERT INTO bvr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Lika gu-gata wenga nipa a-garlmuna, gu-bawuna gun-gata rrawa, lika a-bona. Wurra aburr-gata joborr marn․gi aburr-gunega rrapa Berachi yerrcha, birripa aburr-garlmuna, aburr-bachirramiyana nula Jesus. Minypa ngoyurra aburr-yerryerrmiyana nula rrapa abu-yopuna, rrapa minypa wolawola janguny abu-wengganana aburr-workiyana, ");
INSERT INTO bvr_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","jimarna barra abu-yolka rrapa minypa mari gubu-garra nula. ");
INSERT INTO bvr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Gun-gatiya gugu wurra gama gorlk aburr-jaranga aburr-bamagutuwiyana rrapa aburr-gartkagartchinga aburr-ni. Wurra Jesus a-garlmunapa a-wena burrwa aburr-yigipa jawina mu-ngoyurra, a-yinanga burrwa, “Buburr-jarlapiya nula Berachi (Pharisee) yerrcha mun-burriya mun-gata minypa gandichawa rakaraka mu-nenga mu-workiya. Mun-narda mun-maywapa minypa gun-burral birripa Berachi yerrcha waykin aburr-molamola rrapa wupa aburr-werra rrapa minypa wana aburr-negiya aburr-workiya. Buburr-jarlapiya nula gu-gata ngacha gun-nerra. ");
INSERT INTO bvr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Wurra gun-nga gu-yilkakiya gu-yurra, burraya gu-garlma barra yarlanga gu-yu. Rrapa gun-nga gun-jaranga yongun gu-yurra, burraya aburr-jaranga marn․gi aburr-ni barra gun-gata. ");
INSERT INTO bvr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Minypa ana-goyburrpa gun-nga nyiburr-wena ana-munya, nuwurra waypa rrengarrenga gu-ni birripa wurra gama gorlk aburr-galiya barra. Rrapa minypa gun-nga ana-goyburrpa yongun nyiburr-wena, burraya nuwurra rrawa aburr-jabarrcha barra aburr-ji. ");
INSERT INTO bvr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Buburr-galiya apula, japurra ngapa nyiburr-jirra. Gala barra nyiburr-gurkuja burrwa aburr-gata minypa nyiburr-burral wupa nyirrbu-bun rrapa nyiburr-juwun wurra barrwa gala aburr-yinmiya jurdach. ");
INSERT INTO bvr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Wurra ngaypa arr-gurdagurdarra barra ana-nga barra nyiburr-gurkuja nula: Wangarr an-gata jarra ana-goyburrpa barra nyiburr-gurkuja nula. Ngardawa minyja nipa a-bu an-gugaliya, nipa ganyjarr gu-rrimanga yi-gata gu-bol minypa a-yerrnyja. Minyjiya. Nipa an-gata an-ngardapiya barra nyiburr-gurkuja nula. ");
INSERT INTO bvr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Wurra minyja bubu-borrwa jin-delipa burdacha jin-guyinda wolawola jalim jibi-nenga aburr-workiya: Minypa burrbu-wucha aburr-workiya abirriny-jirrapa abirriny-jirrapa jin-ngardapa burdacha, wurpa lika mbi-mangga aburr-workiya abirri-jirrapa wupa mun-delipa mun-guyinda rrupiya. Wurra wuriya nipa gala rrupiya wana achila, wurra Wangarr gala jin-ngardapa burdacha a-bamapa achila a-workiya. ");
INSERT INTO bvr_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Rrapa ana-goyburrpa nipa Wangarr marn․gi ana-gorrburrwa gun-bulapalawa gun-gata burr-guta minypa mun-gata mejimija nyiburr-bama mu-yinmiyapa nyibi-rrimanga. Gu-gatiya ngacha minypa nipa burr-guya jal a-nirra ana-gorrburrwa. Gala barra nyiburr-gurkuja. Wurra minypa jin-gata jin-delipa burdacha nipa Wangarr jal a-nirra achila, ana-goyburrpa jarra nipa burr-guya jal a-nirra ana-gorrburrwa. ");
INSERT INTO bvr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Gun-guna ngu-weya ana-gorrburrwa gun-burral: Minyja ana-nga gala a-jordajiya, wurra minypa a-wengga gatiya gu-galiya yerrcha aburr-galiyarra nula aburr-nirra minypa nipa an-gata an-ngaypa jawina, an-narda an-gugaliya nipa an-guna An-walkurpa An-gugaliya a-yirda barra a-ngurrja yi-gata waykin Wangarr burr-yika waykin aburr-guyinda aburr-mujaruk aburr-nirra. Minypa a-yinda barra, ‘An-guna an-ngaypa jawina.’ ");
INSERT INTO bvr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Wurra minyja ana-nga an-gata ngoyurra a-yerryerrmiya apula gatiya gu-galiya yerrcha aburr-nirra, an-gata an-gugaliya an-guna An-walkurpa An-gugaliya a-yirda barra ngoyurra a-yerryerrmiya barra nula yi-gata waykin Wangarr burr-yika waykin aburr-guyinda aburr-mujaruk aburr-nirra. ");
INSERT INTO bvr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Minyja ana-nga a-wengga rrapa an-nerra a-nega an-guna An-walkurpa An-gugaliya, gun-narda Wangarr baywarra gu-nega barra nula; wurra an-gata ana-nga minyja gun-nerra a-wengga rrapa an-nerra a-nega Mern An-mawunga, an-gata an-gugaliya Wangarr gala a-yinmiya baywarra gu-nega nula. ");
INSERT INTO bvr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Rrapa ana-goyburrpa nuwurra waypa birripa nyirrbi-rrima, nyirrbu-ga, nyirrbu-barnja aburr-gata Ju yerrcha mu-murna yerrcha aburr-yinmiya barra aburr-wengga, waygaji gapman an-guyinda bunggawa a-yinmiya barra a-wengga, wurra nginyipa gala barra ny-borrwa gun-gata ny-yinmiya barra ny-yengga. ");
INSERT INTO bvr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Wurra nipa an-gata Mern An-mawunga gatiya gugu marn․gi biy-nega barra nginyipa ny-yinmiya barra ny-yengga.” ");
INSERT INTO bvr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","An-ngardapa an-gugaliya an-gata a-wena nula Jesus, a-yinanga nula, “A-lay, nginyipa ny-jurda marn․gi nyi-gunega, wurra an-guna wengga nula an-ngaypa worlapa apa barra nyirri-ngorrkornda gun-gata an-ngatipa nyanyapa ata gu-bawuna atila.” ");
INSERT INTO bvr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Wurra Jesus a-yinanga nula, “A-lay, ana-nga a-wena gun-gata ngaypa barra gojilapa ngu-ji ana-gotula waygaji burr-mari ngu-wengga? Wurra ngika gun-gata.” ");
INSERT INTO bvr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Lika Jesus a-wena burrwa wurra gama gorlk. “A-jay, a-lay, buburr-jarlapiya. Gala barra gun-jaranga jal nyiburr-ni. Minyja bubu-borrwa: Gerra gun-gata ngika wanngu gun-gunega; gun-nyagara. Wurra marrban gun-gata gu-yinmiyapa an-gugaliya gu-rrimanga, wurra nipa gala a-yinmiya gu-gerra wanngu a-negiya.” ");
INSERT INTO bvr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Lika gun-guna Jesus gu-ngurrjinga burrwa meyali gun-maywapa ranginy. A-yinagata, “An-ngardapa a-ni an-gorlkpalawa nipa gun-nigipa rrawa balaja mun-murra mu-jinyja. ");
INSERT INTO bvr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Barrwa nipa ana-bama wupa gu-borrwurra a-ni, a-yinanga, ‘A-lay, mun-ngaypa balaja mun-murra nipa gala yina gaya ngu-barnja. Wurra ngu-yinmiya barra? ");
INSERT INTO bvr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Aa ganapiya, gipa ngu-borrwurra. Gun-ngaypa bala ngaypa balaja ngu-jolartchinga ngu-workiya ngaypa barra ngu-rruma rrapa gun-nerranga wana ng-gupa barra ngaypa barra ngu-barnja ngu-ji burr-balaja rrapa burr-gerra burr-guta. ");
INSERT INTO bvr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Barra murna ngu-rrimiya rrapa gala gun-nga barrwa ngu-borrwa. Wurra jarra minypa mun-jaranga mu-yu barra apula mu-workiya wupa, ngaypa minypa m-balaja rrapa mu-nganicha ngu-worlworlcha barra ngu-rrigirrga.’ A-yinagata an-gata an-gorlkpalawa nipa an-ngurrnga a-wena a-ni. ");
INSERT INTO bvr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Wurra Wangarr a-yinanga nula, ‘Ngika, a-la! Nginyipa ny-bongarrowa! Wurra gurdiya gugu ana-munya ny-juwa barra, ngarla, rrapa ana-werranga gu-ma barra gun-gata nginyipa ny-jordajinga ny-yorkiyana.’” A-yinagata Wangarr a-wena nula minypa Jesus gu-ngurrjinga janguny, a-ngurrjinga an-gata an-gorlkpalawa. ");
INSERT INTO bvr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Rrapa Jesus gu-mungbuna a-ni a-wena, a-yinagata, “Gu-yinagatiya gu-workiya burrwa aburr-gorlkpalawa aburr-gata gubu-jordajinga gubu-ganyja. Minypa Wangarr burr-nacha birripa aburr-yolkiya aburr-nirra; gala gun-burral wana aburr-bapala.” ");
INSERT INTO bvr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Lika Jesus a-wena burrwa aburr-yigipa jawina, “Ny-yinga ny-jata, gala barra ny-yorija ngguluwa nginyipa minypa balaja nula mun-nga ny-bay rrapa mirikal nula mun-nga ny-barrnguma. ");
INSERT INTO bvr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Wurra ngarripa arr-nirra, gun-gata ngika minypa balaja nula ngarripa ay-banga arr-workiya. Rrapa ngarripa arr-burral arr-gata ngika minypa mirikal nula ngarripa arr-barrngumiya arr-workiya. Wurra ngika gu-gurda ngacha! ");
INSERT INTO bvr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Wurra minyja bubu-borrwa burdacha jin-guyinda: Minypa Nyanyapa arrku jaga a-ganaja achila a-workiya wuriya nipa gala jinyu-lamaja jiny-yorkiya rrapa gala mu-ma jiny-yorkiya mun-murra balaja. Minypa nipa gala gu-rrima bala rraka wupa m-barnja, wurra jarra balaja mun-nigipa nipa Wangarr jiny-yucha a-workiya. Wurra gu-galiya yerrcha nipa Wangarr burr-guya jal a-nirra burrwa; burdacha jarra marr a-yinaga jal a-nirra achila. Rrapa gun-gata minypa nipa jaga a-ganaja achila a-workiya burdacha jin-guyinda, gun-narda minypa gu-galiya yerrcha jarra nipa burr-guya jaga a-ganaja burrwa, rraka nginyipa gala ny-yinmiya ny-yorija ngguluwa minypa balaja rrapa gorlk rrapa gun-nga. ");
INSERT INTO bvr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wurra ny-yinga ny-jata, nginyipa gala ny-yinmiya jimarna gun-baykarda nyi-ni barra minypa nginyipa ny-yorijinga ngguluwa. Wurra ngika. ");
INSERT INTO bvr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Rrapa minypa nginyipa gala ny-yinmiya ny-yirda gun-baykarda nyi-ni, wurra gun-gata an-nga nula gun-nga burr-guta nginyipa ny-yorijinga ny-yorkiya? ");
INSERT INTO bvr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Wurra borrwa gorrngunya mun-guyinda mun-delipa mun-gata minypa mun-jawanyja m-burnda mu-workiya: Minypa nipa mun-gata gala jama mu-ji mu-workiya rrapa gala mirikal mu-jarlapa nuluwa, wurra Nyanyapa arrku nipa wupa mu-jarlapurda a-workiya mun-gata mun-molamola. Rrapa ngaypa ngu-weya ana-gorrburrwa gun-guna gun-burral: Mun-gata minypa mun-jawanyja m-burnda niya mu-workiya ngayburrpa ngubi-nacha nguburr-workiya mun-molamola; jarra an-gugaliya a-barrngumiya a-workiya mirikal, mun-gata marr mu-yinaga mun-molamola mu-nirra nula. Minyjiya. An-gata Jolaman (Solomon) mu-ngoyurra bunggawa a-ni, wuriya nipa gorlk wana nula, wurra mun-nigipa burr-guta mirikal marr mu-yinanga mun-molamola; mun-gata mun-jawanyja m-burnda mu-workiya gorrngunya mun-guyinda, nipa jarra burr-guya mun-molamola. ");
INSERT INTO bvr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Wurpa lika gorrngunya mu-jirra mu-workiya rrapa barrwa gugu mu-werrpiya mu-workiya, mun-jangarrk aburr-birtarrmiya aburr-workiya, gu-gurda ngacha. Wurra gun-gata minypa Wangarr mun-molamola mu-jarlapurda a-workiya gorrngunya mun-gata barrwa mu-werrpiya mu-workiya, gun-narda minypa nipa gala a-yinmiya a-bamapa nggula ny-jurda nyi-gugaliya mirikal, wurra jarra biy-wupa a-workiya barra ny-barrnguma. Wurra yama marr nyiburr-balcha nula? ");
INSERT INTO bvr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Gala barra ny-yorija nggula. Ganapa borrwa balaja nula mun-nga ny-bay rrapa bugula nula gun-nga ny-bay. ");
INSERT INTO bvr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Wurra gu-gatiya ngacha birripa gubu-borrwuja aburr-workiya aburr-gata minypa gala marn․gi nula Wangarr. Wurra nipiya jarra Nyanyapa arrku waykin a-nirra marn․gi gu-gata ngacha gun-nga nginyipa jal nyi-nirra ny-yorkiya. ");
INSERT INTO bvr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Wurra nginyipa ny-borrwa barra ny-yorkiya minypa nginyipa ny-yinmiya barra jama ny-ji Nyanyapa arrku gun-nika jal gun-guni, lika nipa biy-wu barra gu-gata ngacha minypa gun-nga nginyipa jal nyi-nirra. ");
INSERT INTO bvr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Nyiburr-gurda nyiburr-ngaypa jawina, gala barra nyiburr-gurkuja wurra marrban ana-goyburrpa gala nyiburr-jaranga. Wurra nipa Ngun-anya jal a-nirra ana-goyburrpa nyiburr-nipa barra nyiburr-workiya nipa ana-murna. ");
INSERT INTO bvr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Wurra mun-gata mun-nginyipa gorlk ma, burr-wu, rrapa rrupiya ma burrwa aburr-gata gala mbi-rrima. Gu-gurda ngacha minypa Wangarr jal a-nirra. Rrapa minyja nginyipa ny-yirda burr-wu, gun-narda minypa nginyipa ny-ma barra gorlk gun-gaba waykin gala gu-yinmiya gu-wulebiya, minypa gata gala a-yinmiya an-ngumurda biy-gaypa rrapa burnpa m-bay. ");
INSERT INTO bvr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Wurra minyja nginyipa ny-borrwuja ny-yorkiya gu-gurdiya gu-yika gu-rrawa, gun-narda minypa gun-guniya nggula rrawa; wurra minyja ny-borrwuja gorlk gun-gaba waykin, rrawa gun-gatiya nggula. ");
INSERT INTO bvr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Nawanawa buburr-ni minypa gun-maywapa ranginy aburr-mujama marr gubu-ganyja nula an-birripa bunggawa ana-jeka barra gu-janara wenga. Minypa birripa mun-mujama mirikal aburr-barrngumurra, rrapa lam (lamp) aburr-birtarrmiyana, gu-rrongga gu-jirra. Lika gun-gata nipa ana-jeka barra rrapa ngana gu-jirra a-duldulja barra burrwa a-ji, warrika birripa gubu-lapkujama barra nula. ");
INSERT INTO bvr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Minyja gun-molamola gu-ni barra burrwa aburr-gata minypa an-birripa bunggawa burr-na nawanawa aburr-ni nula. Burr-guya aburr-marrkapcha barra aburr-ni. Minypa nipa bunggawa a-wengga barra burrwa barra aburr-raka, lika nipa mu-yerrkujama barra mun-gata mun-nigipa molma mun-gunegiya mirikal, lika balaja burr-wu barra a-boy. ");
INSERT INTO bvr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Minypa gun-gata nipa bunggawa burr-na barra nawanawa aburr-ni nula marrban ana-munya gornborrk, waygaji ngana guna-ngarlcha, lika gu-gatiya wenga birripa gun-molamola gu-ni barra burrwa minypa bunggawa nipa a-marrkapchinga burrwa. ");
INSERT INTO bvr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Wurra bubu-borrwa gun-guna gun-maywapa ranginy: An-gata bala an-gurrimapa minyja nipa marn․gi a-nirrarna nula an-gata an-ngumurda an-gugaliya ana-boga, nipa a-ganajarna a-nirrarna rraka gala nipa a-yinmiyarna gu-rrumungarna nula gun-nigipa bala. ");
INSERT INTO bvr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Gu-gata ngacha minypa nginyipa barra nawanawa nyi-ni. Ngardawa an-guna An-walkurpa An-gugaliya, ana-goyburrpa gala marn․gi gu-yinpa barra nipa ana-jeka.” ");
INSERT INTO bvr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Lika Birta a-wena, “A-lay, Bunggawa, gurda ngayburrpa nyiburr-gurda wupa ny-yena arrburrwa, waygaji nyiburr-gurdiya gorlk ny-yena arrburrwa, ya?” ");
INSERT INTO bvr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Wurra nipa a-yinanga gu-ngurrjinga nula, “An-gata ana-nga an-mujama an-nigipa bunggawa bama a-balcharra nula, minyja nipa bunggawa a-garlma gun-nerranga rrawa, an-gatiya an-gugaliya nipa bunggawa ana-nyala murna a-wu barra gun-nigipa rrawa, barra nipa jaga a-gana rrapa balaja burr-wu aburr-werranga aburr-gata bunggawa burr-yika aburr-mujama. ");
INSERT INTO bvr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Rrapa nuwurra waypa nipa bunggawa ana-jeka, minyja a-na nipa jama a-jirra, lika an-gata an-mujama gun-molamola gu-ni barra nula. ");
INSERT INTO bvr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Minyjiya, ngarla! Lika gu-gata wenga an-gata bunggawa murna a-wu barra warrpam gun-nigipa bunggawa gun-nika barra nipa an-mujama jaga a-gana nula. ");
INSERT INTO bvr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Wurra waygaji an-gata an-mujama a-yinda gu-borrwa, ‘A-lay, an-ngaypa bunggawa a-bona gu-baykarda; gala a-yinmiya ana-jeka.’ Lika waygaji an-mujama an-gata a-garlmapa burr-bu aburr-gata aburr-werranga aburr-mujama burr-wurrapa burr-gama bunggawa burr-yika, rrapa minypa balaja m-bay rrapa nganicha m-bay rrapa mu-nganicha a-rro. ");
INSERT INTO bvr_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Wurra minyja nipa a-yirda jama a-ji, gun-gatiya nipa gala gu-borrwa, gun-gatiya gugu an-nigipa bunggawa minypa ana-jeka barra, a-gorndapa barra ngardapa ngardapa a-nega barra an-gata an-mujama, barra nipa yi-gata a-boy burrwa aburr-gata aburr-werra. ");
INSERT INTO bvr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“An-mujama an-gata minypa marn․gi nipa an-nigipa bunggawa jal a-nirra, wurra minyja nipa gala nawanawa a-ni rrapa a-yirda jama a-ji, nipiya an-gata an-gugaliya an-nigipa bunggawa burr-guya barra a-jurrburaykujama. ");
INSERT INTO bvr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Wurra an-nerranga an-mujama an-gata minypa gala marn․gi gun-ngiya an-nigipa bunggawa jal a-nirra, minyja nipa an-gata werra a-negiya, an-nigipa bunggawa marr warlwarl barra a-jurrburaykujama. Minypa an-gata ana-nga Wangarr a-wuna gun-jaranga gun-nga, an-gata an-gugaliya Wangarr jal a-nirra barra nipa jama a-ji. Rrapa minypa barrwa an-gata ana-nga nipa Wangarr a-wuna burr-guya gun-jaranga, an-gatiya an-gugaliya Wangarr jal a-nirra barra nipa burr-guya jama a-ji. ");
INSERT INTO bvr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ngaypa nguna-bona minypa ngu-ngakurrma barra gun-guniya rrawa, rrapa burr-guya jal ngu-nirra jimarna gipa ngu-ngakurrmungarna, wurra gala burdak ngu-mungbungarnapa. ");
INSERT INTO bvr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ngun-anya minypa gun-maywapa bama nguna-gurraga barra gun-gujuwa, rrapa ngaypa wargugu ngu-nirra nuwurra ngu-mungba barra. ");
INSERT INTO bvr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Minyja bubu-borrwa: Gun-gata ngaypa nguna-ganyja ana-gorrburrwa ay-ngunyuna rrawa magaya gun-guni ngika; wurra jarra gun-gungorrkorndiya nguna-ganyja. ");
INSERT INTO bvr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Minypa gun-guniya gugu minypa burr-bapala burr-jawa aburr-ngorrkorndiya barra. Minypa abirri-jirrapa jin-ngardapa aburr-bachirramiya barra burrwa abirriny-jirrapa, rrapa abirriny-jirrapa abirriny-bachirramiya barra burrwa abirri-jirrapa jin-ngardapa. ");
INSERT INTO bvr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Minypa nyanyapa burra yerrcha aburr-bachirramiya barra burrwa walkurpa yerrcha, rrapa walkurpa yerrcha aburr-bachirramiya barra burrwa nyanyapa burra yerrcha; rrapa minypa mampa burra yerrcha aburr-bachirramiya barra burrwa aburr-jawapa burra yerrcha, rrapa aburr-jawapa burra yerrcha aburr-bachirramiya barra burrwa mampa burra yerrcha; rrapa minypa jaburpa burra yerrcha aburr-bachirramiya barra burrwa jongok burrbi-nenga, rrapa jongok burrbi-nenga aburr-bachirramiya barra burrwa jaburpa burra yerrcha.” ");
INSERT INTO bvr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Rrapa barrwa Jesus a-wena burrwa wurra gama gorlk minypa a-yinagata burrwa, “Wolawola ana-goyburrpa nyibi-nacha nyiburr-workiya wachparrk a-jinyjarra, lika nyiburr-garlmiyapa nyiburr-yinaga, ‘Yorr wana guna-bamburda; burraya gu-bungga,’ lika gu-garlmiyapa gu-bunggiya gu-workiya wana. ");
INSERT INTO bvr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Rrapa wolawola nyibi-nacha nyiburr-workiya manyjaparna jiny-jarlmiya, ana-goyburrpa nyiburr-yinaga nyiburr-workiya, ‘Gun-nardiya gugu mern mu-yurtcha barra,’ lika gu-garlmiyapa gu-yinagatiya gu-workiya. ");
INSERT INTO bvr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Gu-gurda ngacha ana-goyburrpa nyibi-nacha nyiburr-workiya gun-guna rrawa rrapa waykin rrapa marn․gi nyiburr-nirra nyiburr-workiya gun-nga yorr rrapa gun-nga warlirr. Wurra ana-goyburrpa yama nyibu-borrwa rrapa marn․gi nyiburr-ni ngaypa jama ngu-jirra ngu-workiya? Jarra ana-goyburrpa marn․gi, wurra gala nyibi-yagurrma. ");
INSERT INTO bvr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Marrka bubu-borrwa gun-ngiya gun-molamola barra ana-goyburrpa nyiburr-yirda. ");
INSERT INTO bvr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Minyja ana-nga gu-rrima nggula mari, wurra nipa biy-ga a-bamba jimarna barra biy-barnja nipa an-gata joborr jaga an-gugana a-yinmiya barra a-wengga, wurra gatiya nyirri-bamburda, nginyipa barra ny-yenggana minypa nginyipa ny-yinmiya barra jechinuwa nyi-nega gun-gata mari. Gala yapa nipa biy-barnjin rrapa minypa joborr jaga an-gugana a-wenggin rrapa an-bachirra biy-jolartchin wupa. ");
INSERT INTO bvr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Wurra ngaypa ng-guna ngu-weya nggula ngu-nirra: Minyja birripa bubu-jolartchin, nginyipa gala ny-yinmiya ny-bengga, wurra nuwurra waypa rrupiya mun-murra ny-barripa lika ny-barnja.” ");
INSERT INTO bvr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Gun-gatiya lika aburr-werranga aburr-gata gubu-ngurrjinga nula Jesus gun-gata minypa Galali (Galilee) aburr-guyinda aburr-juwuna, nipa gapman an-guyinda bunggawa an-gata Baylat (Pilate) a-wena, burrbu-buna gatiya minypa birripa minyjak jin-guyinda jibu-wurrgakaja aburr-ni nula Wangarr. ");
INSERT INTO bvr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Wurra Jesus a-wena burrwa aburr-gata minypa gubu-ngurrjinga nula gun-gata janguny, minypa a-yinanga burrwa, “Aya. Wurra aburr-gata aburr-yinagatiya aburr-juwuna, ana-goyburrpa nyibu-borrwuja burrwa jimarn jarraka birripa aburr-werra, aburr-werranga aburr-gata marr aburr-yinanga aburr-werra, ya? ");
INSERT INTO bvr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Wurra ngika gun-narda! Wurra ngaypa ng-gunaga ngu-weya ana-gorrburrwa ngu-nirra, minyja ana-goyburrpa gala nyibu-bawa gun-nerra rrapa nyiburr-ngukurdanyjiya, ana-goyburrpa minypa nyiburr-yindiya barra nyiburr-juwa. ");
INSERT INTO bvr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Rrapa gun-gata rrawa Jaylowm (Siloam) gu-murnangana gu-rrawa Jirúchalam (Jerusalem), aburr-gata aburr-jaranga gu-galiya yerrcha minypa 18, birripa aburr-juwuna aburr-ni gun-gata gun-baykardakarda bala gu-bunggunapa bin-denyjinga, gun-narda ana-goyburrpa nyibu-borrwuja jimarn jarraka birripiya aburr-werra, aburr-werranga aburr-gata marr aburr-yinanga aburr-werra, ya? ");
INSERT INTO bvr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Wurra gun-narda ngika! Wurra ngaypa ng-gunaga ngu-weya ana-gorrburrwa ngu-nirra, minyja ana-goyburrpa gala nyibu-bawa gun-nerra rrapa nyiburr-ngukurdanyjiya, ana-goyburrpa minypa nyiburr-yindiya barra nyiburr-juwa.” ");
INSERT INTO bvr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Lika Jesus gu-ngurrjinga burrwa meyali, a-yinanga, “An-ngardapa an-gugaliya nipa mu-rrimarra gurnal mun-murra mu-jinyja, wurpa lika gatiya wagarrich burr-guta mu-jinyja. Minypa nipa an-gugaliya ana-bona, mu-nana mun-gata wagarrich, wurra gala mun-nga balaja m-barripungarna. Gun-nyagara. ");
INSERT INTO bvr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Lika nipa a-wena nula an-mujama, ‘Minyja na. Gipa abirri-jirrapa gun-ngardapa jemberr ngaypa nguna-bona nguna-workiyana, ngu-wechawecha minyja ngu-barripungarna gun-gata gun-jong balaja mu-rrimangarna, wurra gala mun-nga ngu-barripungarna. Ganapiya! Barrgorndapa yerrnyja! Gala yapa borijipa mu-jingin rrapa mun-nerra mu-negarda mun-guna gurnal.’ ");
INSERT INTO bvr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Wurra nipa an-mujama a-wena, ‘Bawa, a-la, Bunggawa. Barrwa gun-ngardapa jemberr ngaypa ng-garrma barra rrapa ngukarda ngu-barnja barra bulugi mun-nika. ");
INSERT INTO bvr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Lika minyja balaja mu-rrima, gun-narda gun-molamola. Wurra minyja gun-nyagara, ay-barrgorndapa.’” ");
INSERT INTO bvr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Gun-gatiya Jarradi (Saturday) gu-ni, Jesus marn․gi burr-negarra a-ni janguny gatiya gu-bala Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Wurra jin-ngardapa gama jin-gata walkwalk a-rrimarra, nipa jiny-yorrpuna jiny-yu gipa gun-jaranga jemberr, minypa 18. Nipa jiny-jonamurrmiyana jiny-bona jiny-yorkiyana rrapa gala jin-jechinuwa jiny-boyarna jiny-yorkiyarna. ");
INSERT INTO bvr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Lika nipa Jesus jinyu-nana, lika a-gonyjinga achila nipa jina-bona, lika a-yinagata, “A-jay, ny-jurda nginyipa gun-gata gun-nerra gipa gu-bona nggula!” ");
INSERT INTO bvr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Lika jin-dimarrapa, rrapa gu-gata wenga warrika jiny-jarlmunapa jin-jechinuwa jinyu-ni rrapa Wangarr jiny-marrkapchinga nula. ");
INSERT INTO bvr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Wurra an-gata jaga a-ganana a-workiyana gun-gata bala Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya, nipa an-gata a-bachirramiyana nula Jesus ngardawa Jarradi gu-ni nipa jin-dimarra. Ngardawa nipa an-gata gu-borrwurra gun-birripa gun-guwarr minypa Jarradi gu-ni gun-japurra gala gun-nga jama aburr-ji aburr-workiya. Lika a-wena burrwa wurra gama gorlk, a-yinanga burrwa, “Gun-gata ngorrngurra abirri-jirrapa abirri-jirrapa abirri-jirrapa gu-nirra gu-workiya ngayburrpa barra jama nguburr-ji rrapa arrbi-rrima, wurra ngika minypa gun-guna Jarradi gu-nirra!” ");
INSERT INTO bvr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Wurra Jesus a-wena nula, “Ana-goyburrpa waykin nyiburr-molamola; wupa nyiburr-werra! Wurra gun-gata Jarradi gu-nirra gu-workiya, gala ny-yinga bijirrin-dalaja jin-nginyipa bulugi rrapa an-nginyipa dongki. Wurra ny-yarlayarlawuja burrinyjula ny-yorkiya, ngarla, barra bijirriny-ja rrapa bugula gubirriny-bay. ");
INSERT INTO bvr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Wurra jin-guna gama Aybriyam (Abraham) jin-bapurr, nipa ana-walkwalk rrapa gu-gurderda jiny-bichinga gu-ni gipa gun-jaranga jemberr, wurra ana-goyburrpa nyibu-borrwuja gun-guna Jarradi gu-ni jimarna gala arr-yinmiya jin-gurderda ay-rrima, ya?” ");
INSERT INTO bvr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","A-yinagata a-wena burrwa. Lika aburr-gata aburr-bachirra, birripa gona aburr-ni, wurra jarra aburr-gata wurra gama gorlk aburr-worlworlchinga gun-jaranga gun-gata gun-molamola nipa Jesus jama a-ji. ");
INSERT INTO bvr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Lika Jesus barrwa a-wena burrwa, a-yinagata, “Wangarr gun-nika rum, gun-narda minypa ngu-yinmiya barra ngu-ngurrja meyali gun-maywapa ranginy? ");
INSERT INTO bvr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wurra minypa gun-guna: Minypa an-gugaliya mu-menga minypa mipila mu-jirra mun-delipa mun-gata machart (mustard), lika a-lamajinga gun-nigipa rrawa. Lika minypa gu-gata wenga mun-jarlala m-bena m-bamuna, lika wana minypa gun-jong gu-bena gu-bamuna, lika nuwurra aburr-jaranga burdacha aburr-guyinda aburr-bona gurda; lika gubu-gapulawurra aburr-workiyana ay-gatiya gu-birlapirla gu-guyinda. Gun-narda meyali, minypa gun-burral Wangarr burr-barlmarrk jama a-jirra a-nirra burrwa aburr-yigipa gu-galiya yerrcha, rrapa minypa gu-yigipa gu-rrawa wana gugu gu-nirra gu-bamburda. ");
INSERT INTO bvr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","“Rrapa gun-nerranga gun-maywapa ranginy ngaypa barrwa gun-nga ngu-wengga barra? ");
INSERT INTO bvr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wurra minypa jin-gata gama jin-guyinda mu-mangga jiny-yorkiya mun-delipa mun-gurdurtcha, barra gandichawa mu-rrima, lika gu-gata wenga mun-gata mun-jaranga gandichawa minypa ana-ngardapa ana-duram mu-garlmiyapa mu-durtchinga m-bamburda mu-workiya.” ");
INSERT INTO bvr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesus a-garlmuna Jirúchalam (Jerusalem) an-ngoyurra, a-bamuna, gojilapa rrawa gu-jirra gu-boya wana rrapa gun-delipa nipa wurra gama gorlk marn․gi burr-negarra a-bamuna janguny. ");
INSERT INTO bvr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Rrapa an-ngardapa an-gugaliya a-wena nula, “A-lay, nguburr-gata nguburr-jaranga ngika barra wanngu nguburr-ni, ya?” Lika Jesus gu-ngurrjinga burrwa, ");
INSERT INTO bvr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Burr-guya bubu-borrwa ana-goyburrpa nyiburr-yinmiya barra nyiburr-boy, nyiburr-barrnguma minypa gu-rruwurdola ngana gu-jirra, ngardawa birripa jarra aburr-jaranga aburr-ngunyangunyjiya barra, wurra gala aburr-yinmiya. ");
INSERT INTO bvr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Lika nuwurra jurdach an-gata bala an-gurrimapa a-garlmapa barra ngana gu-jirra gu-jakaba barra, rrapa minyja ana-goyburrpa nyibu-borrwa minypa yarlanga nyiburr-jirra, nyiburr-garlma, ngana gu-jirra nyiburr-duldulja rrapa nyiburr-wengga, ‘Bunggawa, lapkujama arrburrwa, a-lay!’ “Wurra nipa a-yinda barra a-wengga ana-gorrburrwa, ‘Ngaypa gala marn․gi ana-gorrburrwa.’ ");
INSERT INTO bvr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Lika ana-goyburrpa nyiburr-yinda, ‘A-lay, ngayburrpa nyiburr-gatiya wugupa nggula balaja nyibu-barra nyiburr-ni, rrapa gu-ngayburrpa gu-rrawa nginyipa marn․gi nyirr-negarra ny-bamuna, ngarla!’ ");
INSERT INTO bvr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Wurra nipa barrwa a-yinda barra ana-gorrburrwa, ‘Ngaypa gala marn․gi ana-gorrburrwa. Buburr-boypa! Ana-goyburrpa nyiburr-gurda nyiburr-werra.’ ");
INSERT INTO bvr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Lika ana-goyburrpa minypa burr-guya nyiburr-rruwuja barra nyiburr-ni rrapa rrirra nyibu-bay, minypa nyirrbi-na barra Aybriyam (Abraham) rrapa Ayjek (Isaac) rrapa Jeykap (Jacob) rrapa Wangarr burr-yika aburr-mujaruk ngunyuna aburr-guyinda wola gubu-ngurrjinga aburr-workiyana gun-nigipa janguny, birripa aburr-gata waykin Wangarr ana-murna aburr-nirra, wurra minypa ana-goyburrpa nipa Wangarr gipa nyirr-yerrnyjinga mipila. ");
INSERT INTO bvr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Minypa wurra gama gorlk aburr-boy barra gurda jimarru, barra wenga, rrapa lunggurrma, jalachang wenga, lika aburr-raka barra rrapa wugupa balaja mbi-bay barra aburr-ni nipiya ana-murna Wangarr. ");
INSERT INTO bvr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Minyjiya. Aburr-werranga aburr-gata jurdach aburr-jirra, birripa barra mu-ngoyurra aburr-ji; rrapa aburr-werranga aburr-gata mu-ngoyurra aburr-jirra, birripa barra jurdach aburr-ji.” ");
INSERT INTO bvr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Gun-gatiya lika aburr-werranga Berachi (Pharisee) yerrcha aburr-bona gurda nula Jesus, aburr-wena nula, “Nginyipa gu-gurdiya wenga ny-boy barra gu-werranga, ngardawa Ayrat (Herod) an-gata gapman bunggawa gu-guna a-yika gu-rrawa nipa biy-bu barra.” ");
INSERT INTO bvr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Wurra Jesus gu-ngurrjinga burrwa, “Buburr-boy, buburr-wengga nula an-gatiya an-mugat, minypa wurra gama gorlk ngaypa jarra walkwalk ngu-yerrnyja barra burrwa ngu-boy rrapa minypa wanngu nguburr-nega barra, minypa geka barra rrapa ngulam barra rrapa barrwa gun-ngardapa ngorrngurra, lika gu-gata wenga ngaypa ngu-mungba barra gun-ngaypa jama. ");
INSERT INTO bvr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Wurra wuriya. Wurra gu-gurdiya wenga ngaypa mu-nguy ngu-bampa barra rrawa gu-jirra gu-boya, minypa geka barra rrapa ngulam barra rrapa minypa barrwa gun-ngardapa ngorrngurra nuwurra gu-gatiya barra ngu-bengga burrwa Jirúchalam. Ngardawa birripa aburr-gatiya wupa burrbu-burnda aburr-workiya Wangarr burr-yika aburr-mujaruk ngunyuna aburr-guyinda. Minyja ngaypa gatiya barra ngu-juwa; gun-nerranga rrawa ngaypa gala ngu-yinmiya. ");
INSERT INTO bvr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ya gurrupurunga rrawa Jirúchalam! Wurra an-nga nula ana-goyburrpa nyirrbu-burnda nyiburr-workiya Wangarr burr-yika aburr-mujaruk? An-nga nula gu-jandarra nyirrbu-burnda nyiburr-workiya nipa burr-jerrmanga ana-gorrburrwa? Wurra ngaypa jal ngu-ni jimarna mernda ngu-jirra ng-gorlkakajarna ana-gorrburrwa mari, minypa gun-maywapa ranginy jin-gata bawul (fowl) jin-guyinda burr-bamagutuwuja jiny-yorkiya jin-nigipa delipa jin-guyinda, lika ji-warmbarrk burr-jolartchinga, gu-gurda ngacha. Wurra ana-goyburrpa gala jal nyiburr-nirrarna apula. ");
INSERT INTO bvr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ganapiya. Gun-goyburrpa rrawa gun-gata gu-jirra gu-boya nipa Wangarr gu-bawuna; gu-werrapa gugu gu-ji barra. Minyjiya, ngarla! Ngaypa ngu-weya ana-gorrburrwa, ana-goyburrpa gala nyiburr-yinmiya barrwa ngunabi-na ngaypa nuwurra jurdach guna-bamburda ana-goyburrpa minypa nyiburr-yinda barra nyiburr-wengga, ‘Wangarr an-molmola a-nega barra an-guna nipa ana-jerrmarra!’” ");
INSERT INTO bvr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nuwurra waypa Jarradi (Saturday) gu-ni, Jesus a-bona balaja barra mbi-bay ana-ngardapa Berachi (Pharisee) gun-nika rrawa an-gata wana an-bapala. Rrapa minypa aburr-werranga aburr-gata burr-guya abi-nana aburr-ni nipa minypa Jesus a-yinmiya barra birripa minypa mari gubu-garra nula. ");
INSERT INTO bvr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Lika gatiya gugu an-ngardapa an-gugaliya ana-bona nula Jesus, nipa minypa rrarnba a-jirra rrapa mernda a-jirra a-burlujarra a-jirra. ");
INSERT INTO bvr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Lika Jesus a-wena burrwa aburr-gata minypa Berachi yerrcha rrapa joborr marn․gi aburr-gunega, a-yinanga burrwa, “Minyja bubu-borrwa: Gun-ngayburrpa joborr gu-yinmiya gu-yurra? Minypa Jarradi gu-nirra gu-workiya, nipa gun-mola arrburrwa barra wanngu arrbi-nega, wurra ngika, ya?” ");
INSERT INTO bvr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","A-yinagata a-wena burrwa, wurra birripa gala gun-nga aburr-weyarna. Lika Jesus a-rrimarra an-gata an-gugaliya, lika wanngu a-ni, lika a-jerrmarra rrawa. ");
INSERT INTO bvr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Lika a-wena burrwa aburr-gata, a-yinagata burrwa, “Minyja ny-yinga ny-jata an-nginyipa walkur, waygaji jin-nginyipa bulugi, minypa Jarradi gu-ni jiny-jarlma, jiny-bungga gu-rralala, wurra nginyipa ny-bawa barra, ya? Ngika. Wurra ny-mapa. Marrban Jarradi.” ");
INSERT INTO bvr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nipa a-yinagata a-wena burrwa, lika birripa aburr-jurnjinga, jimarna mari gubu-garrajarna nula minypa Jarradi gu-ni nipa a-jarlapuna an-gata an-gugaliya. ");
INSERT INTO bvr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Gun-gatiya lika Jesus burr-nana aburr-werranga aburr-gata wana aburr-negiyana aburr-ni minypa aburr-beybachichiyana, gu-molamola aburr-rakaja. Lika nipa gu-ngurrjinga burrwa gun-maywapa ranginy minypa gun-guna: ");
INSERT INTO bvr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Minyja ny-yinga ny-jata wolawola janara an-gurrimapa a-gonyja nggula, wurra gatiya nginyipa gala barra wana nyi-negiya. Gala barra burr-beyba ny-boy, gu-molamola nyi-raka. Ngika. Wurra an-gata janara an-gurrimapa gipa waygaji a-gonyjinga nula an-nerranga an-gata wana an-bapala. ");
INSERT INTO bvr_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Gala yapa minypa an-gatiya a-gonyjingapa ana-gotula nipa lika ana-jarl, a-yinda nggula, ‘Wu an-gunaga barra nipa a-raka,’ rrapa minypa nginyipa lika gona nyi-ni ny-jarl, gaba nyi-raka. ");
INSERT INTO bvr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Wurra minyja janara an-gurrimapa a-gonyja nggula, lika nginyipa nyina-boy, wurra gaba raka nuwurra jarra an-gata janara an-gurrimapa barra ana-jarl, a-yinda nggula, ‘Guwa, a-lay, japurra ngapa ny-jirra. Gun-guna nggula; ay-ngunyuna raka.’ Gu-gurda ngacha minypa aburr-gata aburr-ninyarra marr aburr-balcha barra nggula. ");
INSERT INTO bvr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ngardawa ana-nga an-gata wana a-negiya a-workiya, jarra Wangarr delipa a-nega barra an-gata an-gugaliya; rrapa ana-nga an-gata delipa a-negiya a-workiya, Wangarr nipa jarra wana a-nega barra.” ");
INSERT INTO bvr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Lika Jesus a-wena nula an-gata janara an-gurrimapa, a-yinanga nula, “Nginyipa wolawola ny-jonyjinga burrwa ny-yorkiya rrapa balaja burr-wucha, ganapa gonyja burrwa aburr-gata minypa aburr-nginyipa jawina yerrcha rrapa aburr-borrmunga nggula rrapa minypa gorlk wana mbi-rrimanga. Gala yapa minypa birripa aburr-yirdiya aburr-gonyja nggula gun-narda wupa gun-nginyipa rrapa gala barrwa gun-nga Wangarr biy-wu. ");
INSERT INTO bvr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Wurra aburr-werranga jarra nginyipa ny-jonyja barra burrwa rrapa balaja burr-wu, minypa aburr-gata gala mbi-rrima, rrapa minypa m-burdapuburda yerrcha rrapa aburr-nyarlkuch rrapa aburr-gapula. Aburr-gurdiya ngacha ny-jonyja barra burrwa ny-yorkiya, ");
INSERT INTO bvr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","lika gu-gatiya wenga nginyipa ny-nyilja barra rrapa ny-molamola nyi-ni barra. Ngardawa birripa aburr-gata gala aburr-yinmiya gubu-gurdanyja nggula, wurra Wangarr nipa jarra gun-molamola guna-gurdanyja barra nggula. Minypa jurdach guna-bamburda nipa barra burr-jarrkarra gu-galiya yerrcha mu-ngoyurra gu-molamola aburr-ni, nginyipa ny-jatiya wugupa burrwa ny-ma barra minypa nginyipa jama ny-ji.” ");
INSERT INTO bvr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Gatiya minypa Jesus wugupa balaja mbi-barra aburr-ni, an-ngardapa an-gugaliya an-gata minypa a-galiyana a-ni gun-gata nipa a-wena, nipa a-yinanga nula Jesus, “A-lay, burr-guya aburr-marrkapchinga aburr-gata aburr-nga minypa gu-janara aburr-ni barra gata Wangarr ana-murna!” ");
INSERT INTO bvr_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Wurra Jesus a-yinanga nula, “Galiya apula janguny. An-ngardapa an-gugaliya a-ni, nipa nawanawa a-ni, minypa balaja mun-jaranga m-barnja barra burrwa gipa mu-ngoyurra a-gonyjinga burrwa aburr-jaranga gu-galiya yerrcha. ");
INSERT INTO bvr_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ganapiya, lika an-nigipa an-mujama a-jerrmarra barra a-wengga burrwa a-boy rrapa minypa a-yinda burrwa, ‘Guwa! Buburr-boy gurda! Gipa mun-gaba balaja mun-jaranga mu-jirra!’ ");
INSERT INTO bvr_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Wurra birripa minypa aburr-garlmunapa ngardapa ngardapa aburr-wena minypa an-nga nula aburr-jekarra. Minypa mu-ngoyurra an-ngardapa a-wena, ‘Ngaypa ngu-menga rrawa, lika ngaypa barra ngu-boy, ngu-na. Wurra wengga nula an-gata an-nginyipa bunggawa barra baywarra gu-nega apula.’ ");
INSERT INTO bvr_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Rrapa minypa an-gata an-nerranga a-wena, ‘Ngaypa bulugi ngu-menga arr-jirrapa arr-murna, minypa 10, lika ngu-boy barra ngu-ngunyangunyjiya nipa jin-gata jiny-yinmiya barra jama jiny-ji. Wurra wengga nula an-gata an-nginyipa bunggawa barra baywarra gu-nega apula.’ ");
INSERT INTO bvr_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Rrapa an-nerranga a-wena, ‘Ngaypa gun-guna waya jin-ngaypa gochila jin-gurra ngu-menga rrapa gala ngu-yinmiya nguna-boy.’ Aburr-yinagata birripa aburr-wena. ");
INSERT INTO bvr_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Lika an-gata an-mujama a-jekarra a-bona, a-wena nula an-nigipa bunggawa. Lika an-gata bunggawa gochila a-rronga burrwa aburr-gata gala aburr-boyarna gurda. Lika a-wena nula an-gata an-nigipa an-mujama, ‘Yurtcha, burr-bamagutuwa boy aburr-gata aburr-nyagara gala mun-nga mbi-rrima, rrapa mola aburr-burdapuburda yerrcha rrapa aburr-gapula aburr-guyinda rrapa aburr-nyarlkuch aburr-guyinda. Minypa gun-guna rrawa gu-jirra gu-boya burr-bamagutuwa boy, minypa wana rrapa gun-delipa gu-jarlakarr aburr-nirra aburr-boya.’ ");
INSERT INTO bvr_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Lika an-gata an-mujama a-bona, burr-bamagutuwurra a-bona, gun-baykarda ngika gu-ganyja, lika ana-jekarra, a-wena nula, ‘Gipa ngu-bona, nguburr-bamagutuwurra, a-la, Bunggawa, minypa nginyipa ny-yena, wurra nipa burdak gala gu-ngana aburr-mayarnapa.’ ");
INSERT INTO bvr_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Lika bunggawa a-yinagata nula an-mujama, ‘Boy, aburr-gata gu-mugarla aburr-nirra aburr-boya burr-bamagutuwa rrapa burr-ga gurda ay-ngunyuna barra gun-guna gun-ngaypa rrawa gu-ngana aburr-maya. ");
INSERT INTO bvr_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ngardawa ngaypa ngu-weya ana-gorrburrwa gun-burral: Aburr-gata gu-galiya yerrcha mu-ngoyurra ng-gonyjinga burrwa, birripa gala aburr-yinmiya mun-ngaypa balaja mbi-bay.’” ");
INSERT INTO bvr_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ganapiya, lika gun-gatiya gugu Jesus gu-jarlakarr a-bamuna rrapa aburr-jaranga wurra gama gorlk wugupa nula. Aburr-bamuna, lika Jesus a-ngukurdanyjiyanapa a-wena burrwa, ");
INSERT INTO bvr_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ana-nga an-gata jal a-ni barra jawina a-ni apula, nipa gala a-yinmiya wurra minyja nipa burr-guya jal a-ni apula ngaypa, aburr-yigipa aburr-borrmunga jarra marr a-yinda jal a-ni burrwa, aburr-gata minypa nyanyapa niya rrapa mampa niya rrapa aburr-yigipa burr-bapala burr-jawa rrapa worlapa niya yerrcha. Minyjiya. Rrapa nipa ngardapa niya burr-guta marr a-yinda barra jal a-ni nula, wurra burr-guya jal a-ni barra apula ngaypa. ");
INSERT INTO bvr_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ngardawa an-gata ana-nga gala jama a-ji minypa ngaypa ngu-wu rrapa gala mu-nguy nguna-jurrjurrma, wurra minypa gu-borrwuja a-workiya gun-derta nipa gu-barripuna, an-gata an-gugaliya gala a-yinmiya an-ngaypa jawina a-ni. ");
INSERT INTO bvr_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Minypa gun-maywapa ana-nga an-gata minyja gu-borrwa minypa nipa gu-jarlapa wana gun-bapala bala, wurra burdak mu-ngoyurra nipa barra gu-borrwa minypa mu-yinpa rrupiya nipa mu-rrimanga nipa barra murna a-rrimiya bala. ");
INSERT INTO bvr_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Wurra minyja nipa gala a-yirda nawanawa a-ni, nipa a-garlmapa gu-jarlapa, wurra gala a-yinmiya murna a-rrimiya, ngardawa rrupiya mu-wulebiyan. Lika gu-galiya yerrcha gubi-na nipa a-yinmiyana gojilapa gu-bawuna, lika birripa aburr-gata aburr-gurdacha barra nula, ");
INSERT INTO bvr_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","aburr-yinda aburr-wengga, ‘An-gata an-gugaliya a-garlmunapa gu-rrana, wurra nipa gala gu-mungbungarna.’ ");
INSERT INTO bvr_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Rrapa minypa barrwa gun-maywapa ranginy bunggawa an-gata marr aburr-yinanga aburr-jaranga an-dakal burr-ganyja a-workiya minypa 10,000. Minyja nipa an-gata a-galiya minypa an-nerranga bunggawa ana-bamburda rrapa an-dakal ana-ganyja aburr-jaranga aburr-gata minypa 20,000, wurra an-gata bunggawa mu-ngoyurra ngu-ngurrjinga ana-gorrburrwa nipa a-yinmiya barra? Wurra nipa burdak gu-borrwa barra a-ni minyja nipiya waygaji wana an-babalapa barra nipa aburr-boy, aburr-bacha, wurra waygaji gun-nyagara. ");
INSERT INTO bvr_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Rrapa minyja nipa gala a-yinmiya, lika nipa barra burr-jerrma aburr-mujaruk an-gata bunggawa burdak nipa balay, birripa barra abu-wenggana minypa mun-nga an-birripa bunggawa a-wu nipa an-gata barra magaya gu-nega butula. Wurra minypa gun-delipa ngika gu-ngurrja burrwa. ");
INSERT INTO bvr_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Rrapa minypa gun-burral: Ny-yinga ny-jata, nginyipa gala ny-yinmiya ny-nyaypa jawina nyi-ni wurra minyja ny-bawa gun-bulapalawa gun-gata nginyipa n-dimanga. ");
INSERT INTO bvr_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Minyja bubu-borrwa: Jorlp (salt) mun-molamola. Wurra minyja jorlp mu-ngukurdanyjiya rrapa mun-nerra mu-ni, gala ana-nga a-yinmiya mu-jarlapa, barrwa mun-bachirra mu-ni. Wurra mun-nerra wupa warrpam. ");
INSERT INTO bvr_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Gala yina gaya barra ngubu-barnja, wurra ngubi-yerrnyja barra. “Ny-yinga ny-jata minyja gelama ny-jirra ny-jaliyana, borrwa ngaypa ngu-wena, rrapa minypa ny-jarlapiya ny-bamba.” ");
INSERT INTO bvr_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Gun-gatiya gun-nerranga gu-ni ngorrngurra, aburr-jaranga aburr-gata aburr-mujama nula gapman minypa rrupiya mbi-mangga nula aburr-workiya, gu-galiya yerrcha burrbu-gaypurda, rrapa aburr-werranga burr-guta aburr-werra, birripa aburr-bona gurda, aburr-galiyana aburr-ni nula Jesus. ");
INSERT INTO bvr_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Lika aburr-gata Berachi (Pharisee) yerrcha rrapa joborr marn․gi aburr-gunega, birripa aburr-garlmunapa lika Jesus abu-yopuna aburr-ni. Minypa aburr-yinanga burrwa gu-gapa gu-guta, “Wurra gu-galiya yerrcha wuriya aburr-werra an-guna a-gonyjinga burrwa, wugupa balaja mbi-banga!” ");
INSERT INTO bvr_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Wurra Jesus a-wena burrwa gun-maywapa ranginy minypa gun-guna: ");
INSERT INTO bvr_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Minyja ny-yinga ny-jata jin-bulapalawa n-dimanga jip (sheep), minypa 100, wurra minyja jin-ngardapa jinyu-lijiwarriya, lika nginyipa ny-yinmiya barra? Wurra bubu-borrwa an-gugaliya jin-bulapalawa jip jin-dimanga: Minyja jin-ngardapa jinyu-lijiwarriya, nipa jiny-bawa barra jin-gata 99 jip, gata jiny-ji, gorrngunya m-bay jiny-ji, wurra nipa a-garlmapa barra a-boy, a-wecha achila jin-gata jin-ngardapa jip jinyu-lijiwarriyana nuwurra jiny-barripa. ");
INSERT INTO bvr_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Rrapa minypa nipa jiny-barripa, a-worlworlcha barra. Minypa jiny-barnja barra ana-mobula, ");
INSERT INTO bvr_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","lika ana-bamiya barra ana-jeka rrawa. Lika a-gonyja barra burrwa aburr-gata aburr-borrmunga nula, minypa a-wengga barra burrwa, ‘Ngaypa ngu-worlworlchinga gipa ngaypa ngu-barripuna apula jip jinyu-lijiwarriyana. Buburr-boy gurda. Nguburr-worlworlcha barra nguburr-ni wugupa.’ ");
INSERT INTO bvr_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Rrapa gu-gurda ngacha minypa aburr-gata waykin aburr-guyinda aburr-worlworlchinga aburr-workiya nipa nula ana-nga an-ngardapa an-gugaliya gun-nerra gu-bawuna rrapa a-ngukurdanyjiyana nula Wangarr. Wurra aburr-jaranga gu-galiya yerrcha aburr-gata minypa aburr-borrwiya gala gun-nerra gubi-rrima rraka gubu-bawa, birripa jarra gun-gaba waykin marr aburr-yinaga aburr-worlworlchinga burrwa. ");
INSERT INTO bvr_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Rrapa barrwa bubu-borrwa minypa gun-guna gun-maywapa ranginy: Jin-ngardapa gama nipa mu-rrimanga jilpa (silver) mun-guyinda rrupiya minypa arr-jirrapa arr-murna, wurra minyja mun-ngardapa mu-lijiwarriya achila, lika nipa jiny-yinmiya barra? Wurra nipa minypa lam jiny-birtarrmiya barra, jinyu-rorrcha, jiny-yechawecha jiny-boy gu-bala nuwurra m-barripa. ");
INSERT INTO bvr_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Rrapa minypa nipa m-barripa, jiny-jonyja barra burrwa aburr-gata aburr-borrmunga achila barra aburr-boy gurda. Minypa nipa jiny-yengga barra burrwa, ‘Ngaypa ngu-worlworlchinga gipa ngaypa ngu-barripuna apula mun-gata jilpa mu-lijiwarriyana. Buburr-boy gurda. Nguburr-worlworlcha barra nguburr-ni wugupa.’ ");
INSERT INTO bvr_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Gu-gurda ngacha minypa Wangarr burr-yika waykin aburr-guyinda aburr-mujaruk aburr-worlworlchinga aburr-workiya nipa nula an-ngardapa an-gugaliya gun-nerra gu-bawuna rrapa a-ngukurdanyjiyana nula Wangarr.” ");
INSERT INTO bvr_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Barrwa rrapa Jesus a-wena gun-guna: “Minypa an-ngardapa an-gugaliya bijirri-dimarra abirri-jirrapa walkurpa yerrcha, ");
INSERT INTO bvr_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","wurra an-ngardapa jurdach an-guyinda ana-garlmuna, a-wena nula, ‘Anya, gun-guniya geka barra murna nguna-wu barra gun-ngaypa.’ Lika an-jirrpungapa gu-ngorrkorndanga butula abirri-gata abirri-yigipa walkurpa yerrcha. ");
INSERT INTO bvr_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Lika gu-gata wenga ngorrngurra gun-jaranga ngika, an-gata jurdach an-guyinda burr-wuna aburr-werranga gun-gata gun-nigipa an-nigipa nyanyapa niya murna a-wuna minypa gerra rrapa rrawa burr-guta, wurra minypa rrupiya wupa mu-menga. Lika gu-gata wenga a-garlmunapa muy-ganyja ay-bona balay gu-werranga gu-rrawa. Lika gatiya rrapa mu-yerpana a-bona mun-nigipa rrupiya; ");
INSERT INTO bvr_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","gala marr mu-rrimangarna. “Ganapiya, lika gu-gata wenga gun-nerra gu-ni gun-gata rrawa; gala yorr gu-bunggiyarna rrapa gala gu-jong balaja mu-rrimangarna. Lika balaja mu-wulebiyana m-bona gun-gata rrawa, rrapa nipa an-gata jurdach an-guyinda gala mun-nga m-bangarna a-nirrarna; wurra gun-nyagara. ");
INSERT INTO bvr_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Lika nipa a-mulpiyana nula an-ngardapa an-gugaliya gu-gata a-yika gu-rrawa nipa minypa jama a-wuna, a-balakaja, nipa a-bona, jaga a-ganana achila jin-nigipa bigibigi jin-guyinda ana-gata jin-nika. ");
INSERT INTO bvr_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Wurra nipa burdak balaja a-werrmiyana a-ni. Minypa nipa gu-borrwurra a-ni jimarn jarra nipa m-bangarna mun-gata mun-maliyarra mun-guyinda bigibigi m-banga jiny-yorkiya. Wurra gala mun-nga m-bangarna; gun-nyagara. ");
INSERT INTO bvr_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Gu-gata wenga lika nipa gu-borrwurra, lika an-ngurrnga a-wena a-ni, ‘An-ngaypa nyanyapa apa aburr-yigipa burr-rrupiya jama aburr-jirra nula aburr-workiya, birripa balaja mbi-banga aburr-workiya, wurra ngaypa ng-gunaga ngu-werrmiya ngu-nirra, ya? ");
INSERT INTO bvr_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Wurra ngaypa ng-garlmapa barra ngu-boy nula an-ngaypa nyanyapa apa, lika ngu-yinda ngu-wengga nula: Anya, ngaypa werra ngu-negiyana nula Wangarr rrapa werra ngu-negiyana nggula nginyipa. ");
INSERT INTO bvr_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ngaypa gugu gala ngu-yinmiya ngu-walkurpa ngu-ni nggula, wurra minyja nginyipa ny-yinmiya barra ny-borrwa, ngaypa ngu-mujama ngu-ni barra nggula.’ ");
INSERT INTO bvr_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Lika nipa a-garlmunapa ana-jekarra ana-bona nula nyanyapa niya. “Nipa burdak balay ana-jarl ana-bamuna rrawa, lika nipa nyanyapa niya a-nana rrapa wargugu a-ni nula. Lika a-yurtchinga, a-barlamachinga rrapa a-machinga. ");
INSERT INTO bvr_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Lika ana-walkurpa a-wena nula. ‘Anya, ngaypa werra ngu-negiyana nula Wangarr rrapa werra ngu-negiyana nggula nginyipa. Ngaypa gugu gala ngu-yinmiya ngu-walkurpa ngu-ni nggula.’ ");
INSERT INTO bvr_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Wurra nipa an-jirrpungapa a-gonyjinga burrwa aburr-yigipa aburr-mujama, a-yinanga burrwa, ‘Buburr-yurtcha, bubu-ga gurda mun-gata mun-molamola mirikal barra nyibu-jolartcha an-guna an-ngaypa walkur. Rrapa ring bubu-barnja nula ana-murna, rrapa rrepara a-jirra bubu-jolartcha arr-barrngumiya arr-workiya rrepara arr-jirra. ");
INSERT INTO bvr_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Lika buburr-boy, bubu-bu bulugi morrpiny ngacha jin-nyarlkuch barra ngubu-bay rrapa nguburr-worlworlcha. ");
INSERT INTO bvr_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ngardawa an-guna an-ngaypa walkur, nipa minypa gun-nyagara gu-ni, wurra gun-guniya gugu wanngu a-ni. Minypa nipa a-lijiwarriyana, wurra gipa gugu a-bena.’ Ganapiya, lika balaja wugupa mbi-barra minypa aburr-worlworlcha aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Wurra burdak an-murnangana gapa balay marlgaway jama a-ji. Lika gu-gata wenga ana-jekarra ana-bamuna, yi-gurrepa a-bena rrawa, a-galiyana burrwa manakay aburr-japarndiyana aburr-ni rrapa minypa aburr-walagiyana. ");
INSERT INTO bvr_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Lika gu-gata wenga nipa a-gonyjinga nula an-ngardapa an-mujama, lika ana-bona, lika a-yinanga nula, ‘Nyiburr-yinmiya nyiburr-nirra, ya?’ ");
INSERT INTO bvr_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Wurra an-gata an-mujama a-yinanga nula, ‘A-lay, an-nginyipa worlapa nggu ana-jekarra, ngarla! Rrapa an-nginyipa nyanyapa nggu bulugi jiny-buna nula jiny-nyarlkuch morrpiny ngacha, minypa an-nginyipa worlapa nggu ana-jekarra rrapa an-mola.’ ");
INSERT INTO bvr_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Wurra an-gata an-murnangana a-garlmunapa a-bachirramiyana. Gala a-yinmiyarna yi-gata gu-bala a-barrngumiyarna. Lika an-nigipa nyanyapa niya ana-bena, a-wena nula. ‘Yama nyina-barrnguma, a-lay?’ ");
INSERT INTO bvr_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","“Wurra nipa a-garlmunapa a-wena nula an-nigipa nyanyapa niya, ‘Minyja borrwa ni: Ngaypa gun-jaranga jemberr jama ngu-ji nggula minypa ng-galiyarra nggula ngu-workiya rrapa gala ng-gopiya nggula, wurra nipa gala gun-nga nginyipa nguna-wucharna ngaypa. Minypa gala nenikut (nanny goat) nguna-wucharna rraka aburr-borrmunga apula nyiburr-worlworlchingarna nyibu-bangarna. ");
INSERT INTO bvr_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Wurra an-garda an-nginyipa walkur, nipa minypa rrupiya a-bamburda, mu-wulebiya nula minypa gama jin-guyinda jiny-yucha, lika gu-gata wenga ana-jekarra an-nyagara. Lika nginyipa bulugi jin-nyarlkuch morrpiny ngacha ny-buna nula, ya?’ ");
INSERT INTO bvr_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Wurra an-jirrpungapa a-yinagata nula, ‘Walkur, a-lay, nginyipa wolawola ay-ngunyuna arr-nirra arr-workiya, rrapa gun-gata gun-nga ngaypa ngu-rrimanga gugu gun-nginyipa. ");
INSERT INTO bvr_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Wurra ngayburrpa jimarna nguburr-worlworlchingarna rrapa balaja ngubu-bangarna minypa an-nginyipa worlapa nggu gun-nyagara gu-ni, wurra an-guna gugu an-mola. Minypa nipa a-lijiwarriyana, wurra an-guna gugu a-bena.’” ");
INSERT INTO bvr_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus mu-nguy a-wena burrwa aburr-yigipa jawina minypa gun-guna janguny: “An-ngardapa an-gugaliya gorlk gun-jaranga nula, nipa an-gata an-nigipa an-mujama jaga a-ganana gun-nigipa rrawa. Wurra aburr-werranga abu-ngurrjinga nula bunggawa minypa an-gata an-nigipa an-mujama mun-nga mun-gata mu-yerpana nula a-ni. ");
INSERT INTO bvr_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Lika nipa bunggawa a-gonyjinga nula an-nigipa an-mujama, lika a-wena nula a-ni, ‘Gun-gata gun-nga ngaypa ng-galiyarra nggula minypa janguny aburr-weya, bubu-ngurrjinga, ngarla? Wurra mun-gata jurra nyina-ma nginyipa ny-yukurrjinga ny-yorkiya, minypa wurra gama gorlk aburr-nirra gu-ngaypa gu-rrawa mu-yinmiyapa birripa mbi-gurdanyja barra gurda apula rrapa mu-yinmiyapa gipa mbi-gurdanyjinga, barra minypa ngaypa marn․gi ngu-ni. Wurra ganapiya gugu, nginyipa gala ny-yinmiya jaga ny-jana apula gun-ngaypa rrawa, ngarla!’ ");
INSERT INTO bvr_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Lika an-gata an-mujama gu-borrwurra a-ni, nipa an-ngurrnga a-wena a-ni, ‘Ngaypa ngu-yinmiya barra, ya? Ngardawa an-ngaypa bunggawa gipa a-garlmunapa nguna-yerrnyjinga mipila a-nirra, gala barrwa ngu-yinmiya jaga ng-gana nula gun-nigipa rrawa. Wurra ngaypa gala ngu-derta rraka burr-rrupiya minypa jel ng-garrma ngu-workiya, rrapa ngaypa gala ngu-yinmiya ngu-ngiwija burrwa wurra gama gorlk minypa mu-yinmiyapa ngunabu-wu; gala yapa jonama ng-gurkujin. ");
INSERT INTO bvr_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aaa, gipa ngu-borrwurra! Minypa ngaypa ngu-yinda barra jama ngu-ji, rrapa minypa wurra gama gorlk aburr-gonyja gurda apula gu-birripa gu-rrawa wuriya bunggawa nguna-yerrnyjinga mipila.’ ");
INSERT INTO bvr_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Gu-gata wenga a-gonyjinga burrwa ngardapa ngardapa aburr-gata minypa burraya mbi-gurdanyja barra nula bunggawa. Minypa an-ngardapa a-wengganana, ‘A-lay, mun-gata mu-yinmiyapa nginyipa barra ny-jurdanyja nula bunggawa?’ ");
INSERT INTO bvr_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Nipa a-yinanga, ‘Burraya ngaypa ng-gurdanyja nula mun-girra alip (olive) mun-guyinda ana-duram ana-guyinda minypa 100.’ “Lika nipa an-mujama a-wena nula, ‘Ma. Warrika wukurrja mu-guna mu-jurra barra ny-jurdanyja nula minypa 50 wupa jarra.’ ");
INSERT INTO bvr_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Rrapa an-nerranga nipa an-gata an-mujama a-wengganana, ‘A-lay, mun-gata mu-yinmiyapa nginyipa ny-jurdanyja barra nula bunggawa?’ “Nipa a-yinanga, ‘Minyja borichel m-balachi mu-guyinda minypa 1,000.’ “Lika an-mujama a-wena nula, ‘Ma. Warrika wukurrja mu-guna mu-jurra barra ny-jurdanyja nula marr wana jarra minypa 800.’ A-yinagata an-mujama a-wena burrwa a-bona, mun-delipa mu-negarra burrwa a-bona rrapa minypa birripa aburr-marrkapchinga nula. ");
INSERT INTO bvr_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Gu-gata wenga nipa bunggawa ana-nyala gochila a-barrjinga, wurpa lika a-ngurrjinga an-gata an-mujama an-guralcha wuriya nipa an-guyolkiya. Ngardawa nipa an-mujama a-jarlapiyana a-bamuna. Ngardawa wurra gama gorlk gu-gurdiya burr-yika gu-rrawa birripa marn․gi aburr-jarlapiya aburr-workiya gu-guna gu-rrawa. Jarra wurra gama gorlk gu-bardayala burr-yika gun-gata nula birripa gala burr-guya marn․gi. ");
INSERT INTO bvr_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Wurra ngaypa ngu-weya ana-gorrburrwa, burrbu-ma jawina aburr-ni ana-gorrburrwa. Minypa ny-yinga ny-jata ny-yinmiya ny-yorkiya rrupiya rrapa gorlk gu-guna gu-yika gu-rrawa, wurra minypa gu-galiya yerrcha ny-junggaja barra burrwa ny-yorkiya barra minypa nuwurra waypa gu-boy, birripa aburr-gonyja barra gurda nggula yi-gaba waykin rrawa gu-jirrapa gu-workiya. ");
INSERT INTO bvr_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ana-nga an-gata an-molamola an-mujama minypa gun-ngiya gun-gata gun-delipa nipa jama a-jirra, ana-gata ngacha an-gugaliya gun-molamola jama a-jirra a-workiya gun-ngiya gun-gata wana burr-guta. Wurra ana-nga an-gata an-guyolkiya minypa gun-ngiya gun-gata gun-delipa nipa jama a-jirra, ana-gata ngacha an-gugaliya a-yolkiya a-workiya gun-ngiya gun-gata wana burr-guta nipa jama a-jirra. ");
INSERT INTO bvr_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ganapiya. Minyja nginyipa gala gun-mola jama ny-ji minypa rrupiya rrapa gorlk gu-guna gu-yika gu-rrawa, nipa Wangarr gala a-yinmiya bama a-balcha nggula rraka nginyipa jaga ny-jana nula gun-molamola gun-guyinda gala gu-boy. ");
INSERT INTO bvr_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Rrapa minyja nginyipa gala gun-mola jama ny-jirrarna ana-werranga gun-nika, gala ana-nga biy-wu gun-nginyipa wupa. ");
INSERT INTO bvr_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Gala ana-nga an-mujama a-ni butula abirri-jirrapa bunggawa ngardapa ngardapa minypa burr-bama burr-rrepara. Gala a-yinmiya. Jarra an-ngardapa bunggawa an-gata nipa an-mujama ngoyurra a-yerryerrmiya nula, rrapa an-nerranga nipa jal a-ni nula. Minypa an-molamola a-ni nula an-ngardapa, rrapa an-nerranga nipa a-dalaja a-ni. Gu-gurda ngacha minypa nginyipa gala ny-yinmiya gu-jirrapa jama ny-ji minypa Wangarr gun-nika rrapa rrupiya nula.” ");
INSERT INTO bvr_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Gun-narda waypa Berachi yerrcha aburr-galiyana Jesus a-wena, lika birripa ngoyurra aburr-yerryerrmiyana nula, ngardawa birripa rrupiya aburr-mipila. ");
INSERT INTO bvr_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Wurra Jesus a-yinanga a-wena burrwa, “Ana-goyburrpa nyiburr-gurdiya, ana-goyburrpa nyiburr-molamola nyiburr-negiya nyiburr-workiya yarlanga barra gu-galiya yerrcha nyirrbi-na, jimarn jarrapa bama aburr-yindin nyiburr-mola. Wurra jarra nipa Wangarr nyirr-nacha ana-goyburrpa minypa wupa nyiburr-ngurrnga nyiburr-werra. Minypa gun-gata gun-nga burr-guta an-gugaliya gu-borrwuja a-workiya jimarna gun-japurra, wurra jarra Wangarr ana-ngoyurra gu-yerrnyjinga a-workiya gu-gata ngacha. ");
INSERT INTO bvr_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Mojich gun-nika joborr rrapa gun-gata minypa Wangarr burr-yika aburr-mujaruk ngunyuna aburr-guyinda aburr-wukurrjinga aburr-workiyana, gu-gurda ngacha ana-gorrburrwa jarlakarr nuwurra Jon a-bena, an-gata bama burr-gurragaja a-workiyana. Lika gu-gatiya wenga gugu wurra gama gorlk aburr-galiyarra aburr-workiya gun-guna gun-molamola janguny Wangarr gun-nika rum, rrapa minypa gubu-borrwuja aburr-workiya jimarn jarra barra birripa wupa aburr-murna aburr-yinmiya gubi-rrima. ");
INSERT INTO bvr_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Wurpa lika joborr guy-jirrapa guy-workiya. Gun-nardiya rrawa waykin rrapa wupa nipa jarra gun-mola Wangarr jal a-ni gu-werrwerrma, wurra jarra joborr gun-guyinda marrban gun-gata gun-nga gun-delipa, wurra gala gu-yinmiya gu-werrpiya. ");
INSERT INTO bvr_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ana-nga minyja jiny-bawa jin-nigipa jin-gumarrbipa niya rrapa jin-nerranga jiny-ma, an-gata an-gugaliya gun-nerra minypa jama a-jirra. Rrapa an-nerranga minyja jiny-ma jin-gata an-gumarrbipa ngacha abirriny-bapawuchichiyana, nipa burr-guta gun-nerra jama a-jirra. ");
INSERT INTO bvr_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“An-ngardapa an-gugaliya a-ni a-workiyana gorlk gun-jaranga gu-rrimarra. Rrapa nipa a-barrngumurra a-workiyana mun-molamola mirikal, rrapa balaja mun-jaranga m-barra a-workiyana. ");
INSERT INTO bvr_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Rrapa gatiya abu-ganyja gurda aburr-workiyana, abu-barnjinga gun-nigipa rrawa yarlanga an-ngardapa an-gugaliya an-ngorrma, nipa an-nelangga Lejarach (Lazarus). Nipa an-jeja an-jaranga. ");
INSERT INTO bvr_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nipa m-barra a-workiyana mun-jinachina mun-guyinda an-gata an-gorlkpalawa mu-yerrnyjinga a-ji. Rrapa gulukula aburr-bona gurda aburr-workiyana, abu-bunyjinga an-jeja. ");
INSERT INTO bvr_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Gu-gata wenga an-gata an-ngorrma a-juwuna, lika waykin aburr-guyinda aburr-mujaruk aburr-bona gurda, abu-menga, abu-ganyja gatiya Aybriyam (Abraham) ana-murna, an-gata mu-ngoyurra a-ni rrapa marr a-balcha nula Wangarr. Rrapa an-gorlkpalawa rrapa a-juwunapa lika abu-jurnumbuna. ");
INSERT INTO bvr_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Lika gun-gata bol gu-rrongga gu-jirra gu-workiya gun-nelangga Aydich (Hades) nipa an-gorlkpalawa an-ngurrnga gatiya a-wurkurichinga a-ni. Lika a-ganana waykin, a-nana Aybriyam rrapa Lejarach wugupa nula gatiya balay abirri-ji gurda. ");
INSERT INTO bvr_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Lika a-gonyjinga nula Aybriyam, a-yinanga, ‘Aybriyam, a-lay, Anya, gunggaja apula! Lejarach nyina-jerrma barra bugula ana-murna guna-ga gun-jimern rrapa nguna-gurraga ngarl ngu-jirra. Ngardawa ngaypa ngu-jaygachinga, burr-guya ngu-wurkurichinga rrapa ngu-rrongga ngu-jirra gu-guna gu-bol.’ ");
INSERT INTO bvr_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Wurra Aybriyam a-yinanga nula, ‘A-lay, walkur, borrwa gun-gata nginyipa gipa gun-molamola gun-guyinda n-dimarra ny-yorkiyana, rrawa nyi-ni, wurra an-guna Lejarach nipa jarra gun-nerra gu-ni nula gu-workiyana. Wurra gun-guniya gugu nipa a-nyiljinga an-molamola rrapa nginyipa ny-jarda ny-yurkurichinga nyi-nirra. ");
INSERT INTO bvr_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Rrapa gun-narda wupa ngardapa ngika, wurra gojilapa nginyipa rrapa ngatipa gun-narda rralala wana gun-babalapa guy-jirrapa guy-workiya, minypa gala ana-nga gu-guna wenga a-jurrwa nggula yi-garda, rrapa gu-garda wenga gala ana-nga ana-jurrwa atila ngunyuna.’ ");
INSERT INTO bvr_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","“Wurra nipa a-yinagata, ‘Ganapiya, Anya. Wurra ngu-ngiwijarra nggula ngu-nirra ny-jerrma barra Lejarach, a-boy barra nyanyapa ngapa gun-nika rrawa barra ngana ngu-jirra nguna-ngurrja barra burrwa. Ngardawa aburr-gatiya worlapa ngapa yerrcha minypa arr-ngardapa arr-murna gala yapa aburr-boy gurda gun-guna gun-guwurkuricha rrawa.’ ");
INSERT INTO bvr_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Wurra Aybriyam a-yinagata, ‘Ngika. Jarra birripa burrbi-rrimanga aburr-birripa mu-ngoyurra aburr-guyinda, Mojich rrapa aburr-werranga burr-guta Wangarr burr-yika aburr-mujaruk. Yama aburr-galiya burrwa birripa?’ ");
INSERT INTO bvr_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Nipa a-yinagata, ‘Ngika, a-lay, Anya. Wurra minypa an-gugaliya mu-ngoyurra a-juwuna an-gatiya minyja a-jeka burrwa a-jarl, birripa aburr-galiya barra nula rrapa gun-nerra gubu-bawa.’ ");
INSERT INTO bvr_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Wurra Aybriyam a-yinagata, ‘Ngika. Wurra minyja birripa gala aburr-yinmiya aburr-galiya janguny gu-gata ngacha minypa Mojich a-wena rrapa aburr-werranga Wangarr burr-yika aburr-mujaruk aburr-wena, gun-narda minypa gala aburr-yinmiya birripa marr aburr-balcha, marrban mu-ngoyurra a-juwuna an-gata a-jeka, a-wengga burrwa.’” ");
INSERT INTO bvr_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesus a-wena burrwa aburr-yigipa jawina, a-yinanga burrwa, “Gun-gulijiwarriya gun-nardiya guy-bamburda, ngarla, wurra jurdach guna-bamburda burr-guya gun-nerra gu-ni barra nula ana-gata ngacha an-gugaliya minypa gun-gulijiwarriya guna-ganyja ana-workiyana! ");
INSERT INTO bvr_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wurra an-gata an-gugaliya jimarn jarra abu-bichingarna jawa a-jirra gu-jandarra rrapa abi-yerrnyjingarna gu-bachirra, barra nyanma gala a-yinmiyarna burr-warganyjarna aburr-guna delipa yerrcha. Ngardawa burr-guya gun-nerra gu-ni barra nula an-gugaliya minypa delipa yerrcha burr-warganyja a-workiyana. ");
INSERT INTO bvr_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Buburr-jarlapiya nyiburr-yinmiya ana-goyburrpa nyiburr-bamburda. Minyja an-borrmunga nggula gun-nerra jama a-ji, gelama gelama bay; rrapa minyja gun-nerra gu-bawa, baywarra nega nula gun-gata nipa mu-ngoyurra gu-rrimarra. ");
INSERT INTO bvr_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Minypa a-yinmiyapa ana-goma gu-nega nipa werra biy-nega rrapa a-yinmiyapa ana-goma gu-nega mola nipa ana-jeka, a-yinda nggula, ‘A-lay, baywarra nega apula ngardawa ngaypa ngu-werra,’ minyja a-yirda a-wengga nggula, nginyipa baywarra nyi-nega barra nula ny-yorkiya an-gata an-gugaliya.” ");
INSERT INTO bvr_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesus burr-yika aburr-mujama aburr-wena nula, “A-lay, Bunggawa, ganyjarr nyirr-wu barra ngayburrpa burr-guya marr nyiburr-balcha.” ");
INSERT INTO bvr_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Lika nipa Bunggawa a-wena burrwa, “Minyja ana-goyburrpa marr nyiburr-balcha, wuriya gun-gata gun-delipa minypa mun-maywapa mun-gata gun-jong machart (mustard) mipila mu-jirra mun-gata mun-delipa, wurra ngardawa nginyipa marr ny-balcharra, jal nyi-ni ny-yengga nula gun-guna gun-jong, ny-yinda, ‘Garlma, wurrkakiya! Boy, gu-bachirra garriya,’ lika nipa gu-galiya barra nggula.” Jesus a-yinagata a-wena burrwa, gu-ngurrjinga burrwa marr gun-gubalcha. ");
INSERT INTO bvr_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Lika mu-nguy Jesus a-wena burrwa, a-yinagata, “Ny-yinga ny-jata minyja an-mujama n-dima, minypa nipa jel a-garrmunga a-workiya, a-lamajinga a-workiya balaja nula, rrapa minypa jaga a-ganaja achila jip (sheep), wurra minypa ana-jeknga ana-workiya gu-jama wenga nginyipa ny-yinmiya nula ny-yorkiya? Waygaji ny-yinaga nula ny-yorkiya, ‘Nyina-garlma nyina-jarl, balaja bay!’ ");
INSERT INTO bvr_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Wurra gala ny-yinmiya ny-yirda. Wurra jarra ny-yinaga nula ny-yorkiya, ‘A-lay, mun-mola mirikal barrnguma barra balaja ny-yalpa rrapa nyina-ga barra ny-barnja apula. Rrapa marr ga jinyja waypa barra ngaypa ngu-durtcha, lika nuwurra jurdach nginyipa ny-bay.’ Ny-yinagata ny-yeya nula ny-yorkiya an-nginyipa an-mujama. ");
INSERT INTO bvr_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Minypa nginyipa gala ny-yinmiya ny-marrngoypiya nula minypa nipa a-galiyarra nggula a-workiya rrapa jama a-jirra. Ngika. Wurra gu-gata ngacha minypa jama gun-nigipa wupa an-mujama gun-nika. ");
INSERT INTO bvr_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Rrapa nginyipa ny-yinagatiya minypa an-gata an-mujama. Minypa gun-gata nipa Wangarr a-wena nggula rrapa nginyipa jama ny-ji, gun-gata gala barra nginyipa ny-borrwa jimarna Wangarr barra a-marrngoypiya nggula. Ngika. Wurra Wangarr a-wena nggula rrapa nginyipa jama ny-ji, gu-gurda ngacha minypa gun-nginyipa wupa jama.” ");
INSERT INTO bvr_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesus a-bamuna gu-jarlakarr Jirúchalam (Jerusalem) an-ngoyurra, minypa rrawa Jimériya (Samaria) rrapa Galali (Galilee), wurra gojilapa ay-bamuna. ");
INSERT INTO bvr_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Wurra gatiya gun-nerranga rrawa ay-bena ay-bamuna, gu-galiya yerrcha arr-jirrapa arr-murna, minypa 10, gatiya aburr-jinyja gurda, birripa minypa aburr-jeja aburr-ngolkuja, minypa gun-guburlububurluja gubi-rrimarra. ");
INSERT INTO bvr_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Lika aburr-gonyjinga nula, aburr-yinanga, “Jesus, a-lay, Bunggawa! Gunggaja arrburrwa!” ");
INSERT INTO bvr_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Lika Jesus a-mirrkwarriyana, burr-nana. Lika a-wena burrwa, “Buburr-boy barra junggay yerrcha nyirrbi-na jimarn jarraka ana-goyburrpa nyiburr-molamiyan.” Ganapiya, lika birripa aburr-bona, lika gatiya aburr-bamuna, gojilapa aburr-molamiyana. ");
INSERT INTO bvr_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Rrapa gun-gatiya waypa aburr-nayana aburr-molamiyana, an-ngardapiya wupa waykin a-wena, a-marrkapchinga nula Wangarr, ana-jekarra ana-jarl nula Jesus. ");
INSERT INTO bvr_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Lika a-bunggunapa nipa ana-rrepara rrapa minypa a-japurramayana nula. Wurra an-gata an-gugaliya nipa jarra Jimériya an-guyinda. ");
INSERT INTO bvr_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Wurra Jesus a-yinanga, “Arr-jirrapa arr-murna jarra aburr-molamiyana, wurra aburr-werranga yina aburr-gaya? ");
INSERT INTO bvr_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Wurra ana-ngardapa wupa ana-jekarra, ya, a-marrkapchinga nula Wangarr? Wurra nipa an-guna gu-werranga gu-rrawa wenga.” ");
INSERT INTO bvr_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Lika Jesus a-wena nula an-gata, a-yinagata, “Garlma, Boy. Ngardawa nginyipa marr ny-balcha, lika nginyipa ny-molamiyana.” ");
INSERT INTO bvr_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Aburr-werranga Berachi (Pharisee) yerrcha abu-wengganana Jesus minypa gu-yinpa barra an-gata Bunggawa a-ni Wangarr gochila bin-dana. Wurra Jesus a-yinanga burrwa, “Wangarr gun-nika rum gun-narda gu-beya, wurra ngika minypa gun-nga gun-gata yarlanga nyibi-nacha nyiburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Minyja gala ana-nga a-yinmiya a-yinda a-wengga, ‘A-lay, na, gun-guna!’ rrapa a-yinda, ‘Gun-gata!’ Wurra jarra gun-nardiya nyibi-rrimanga nyiburr-nirra.” ");
INSERT INTO bvr_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Lika Jesus a-wena burrwa aburr-yigipa jawina, mu-ngoyurra gu-ngurrjinga burrwa gu-yinmiya barra gu-ni. Minypa a-yinanga burrwa, “Gun-gata guna-boya, burraya ana-goyburrpa nyiburr-gana barra mipila jimarn jarra barra nyibi-na an-guna An-walkurpa An-gugaliya wurra gala nyiburr-yinmiya nyibi-na. ");
INSERT INTO bvr_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wurra aburr-werranga aburr-yinda barra ana-gorrburrwa, ‘An-gata ana-boya!’ rrapa ‘An-guna a-nirra!’ wurra gala barra nyiburr-galiya burrwa, wurra jarra aburr-yolkiya. ");
INSERT INTO bvr_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ngardawa an-guna An-walkurpa An-gugaliya nipa jarra ana-jeka barra gun-maywapa minypa an-gata maykarran a-mirlchinga a-workiya rrapa minypa rrawa gu-nayarra gu-workiya yi-gata ay-ngunyuna rrapa yi-gaba. ");
INSERT INTO bvr_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Wurra burdak mu-ngoyurra barra nipa an-guna An-walkurpa An-gugaliya burr-guya gun-nerra gu-ni barra nula, rrapa minypa aburr-gurdiya gorlk barra ngoyurra aburr-yerryerrmiya barra nula. ");
INSERT INTO bvr_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Gun-gata minypa yi-gurrepa gu-ni barra gu-bamba an-guna An-walkurpa An-gugaliya ana-jeka barra, gun-gata minypa gun-maywapa yi-gurrepa gu-ji gu-bona Nowa (Noah) a-barrngumurra mu-michiyang. ");
INSERT INTO bvr_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Minypa aburr-gata gu-galiya yerrcha balaja mbi-barra aburr-workiyana rrapa gama aburr-wuchichiyana burr-guta, wurpa lika gala abu-borrwujarna aburr-workiyarna Wangarr. Aburr-yinagata aburr-workiyana gu-guna gu-yika gu-rrawa gubu-borrwurra aburr-workiyana nuwurra waypa Nowa a-barrngumurra mu-michiyang. Lika gu-gatiya wenga yorr gu-bena, lika bugula wana gu-ni gu-bamuna, burr-werrwerrmarra. Gun-nardiya minypa gu-yinda barra. ");
INSERT INTO bvr_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Rrapa barrwa minypa gun-maywapa gun-gata Lot a-ni gu-galiya yerrcha aburr-yinagatiya, gala Wangarr abu-borrwujarna aburr-workiyarna, wurra minypa balaja rrapa wayin (wine) mbi-barra aburr-ni, rrapa minypa burrbu-wuna aburr-ni rrapa rrupiya mbi-menga aburr-ni, rrapa minypa rrawa gubi-jarlapuna burr-guta. ");
INSERT INTO bvr_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Wurra gun-gata waypa Lot gu-bawuna gun-gata rrawa Jorram (Sodom), gatiya gugu waykin wenga mun-jangarrk rrapa jorlpur (sulphur) gu-bunggunapa gu-ji, burr-buna gu-ni wurra gama gorlk. ");
INSERT INTO bvr_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Gu-yirda barra gu-ni minypa an-guna An-walkurpa An-gugaliya a-bengga barra. ");
INSERT INTO bvr_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Minypa gun-gata gun-balmapa gu-ni barra, an-gugaliya yarlanga a-nirra gala barra gu-bala a-barrnguma, gorlk gu-ma nula; rrapa minypa an-gata jama a-jirra a-nirra balay marlgaway gala barra ana-jeka jimarna gun-nga barra gu-ma, wurra ngika. ");
INSERT INTO bvr_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Minyja bubu-borrwa Lot jin-gumarrbipa niya gu-yinmiyana achila. Minypa jorlp (salt) jinyu-ni, jin-dimarra, ngardawa rrawa gu-borrwurra, jiny-mirrkwarriyana, gu-nana. ");
INSERT INTO bvr_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ana-nga an-gata a-gopiya a-workiya jimarna barra wanngu a-negiya, wurra a-juwa barra. Wurra an-gata ana-nga gala a-gopiya nipa marrban a-juwa, wurra gun-gata minypa wanngu a-negiya barra. ");
INSERT INTO bvr_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Buburr-galiya apula ngu-weya: Gun-gata minypa ana-munya gu-ni barra, abirri-jirrapa gu-galiya yerrcha gu-belabila abirri-yu barra, an-ngardapa a-ma barra rrapa an-nerranga a-bawa barra. ");
INSERT INTO bvr_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Rrapa gu-werranga gu-rrawa abirriny-jirrapa mu-gama yerrcha mbirriny-yogaja barra abirrinyu-ni, jin-ngardapa jiny-ma barra rrapa jin-nerranga jiny-bawa barra. Gu-yirda barra gu-ni minypa an-guna An-walkurpa An-gugaliya ana-jeka barra.” Jesus a-yinagata a-wena burrwa aburr-yigipa jawina. ");
INSERT INTO bvr_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Lika birripa aburr-yinagata, “Nipa yina gaya barra, ya, Bunggawa?” Nipa a-yinagata, “Ngika. Wurra an-gata a-juwuna a-ni, gatiya barra gu-ngardapa aburr-negiya an-gulol abu-numunga aburr-workiya.” ");
INSERT INTO bvr_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Lika Jesus a-wena burrwa aburr-yigipa jawina minypa birripa barra abu-wenggana aburr-workiya Wangarr rrapa gala barra aburr-dawurdawuja. Minypa meyali gu-ngurrjinga burrwa gun-maywapa ranginy, a-yinanga, ");
INSERT INTO bvr_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Gun-ngardapa rrawa a-ni a-workiyana joborr jaga an-gugana, wurpa lika nipa gala burr-borrwujarna a-workiyarna gu-galiya yerrcha rrapa Wangarr burr-guta, wurra a-dawurdawujingapa. ");
INSERT INTO bvr_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Rrapa gun-gatiya rrawa gatiya jin-ngardapa jin-miliyak jinyu-ni jiny-yorkiyana, nipa mu-nguy jina-bona jina-workiyana minypa a-wengganana an-gata joborr jaga an-gugana, ‘A-lay, ngaw minyja ny-junggaja apula gun-ngaypa gorlk gu-bona apula, minypa murnamurna ny-bu an-gata nguna-gaypuna.’ ");
INSERT INTO bvr_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Wurra an-gata joborr jaga an-gugana jinyu-dalajinga a-workiyana. “Wurra nipa mu-nguy jina-bona jina-ji, gorlk gu-borrwurra jinyu-ni. Lika nipa joborr jaga an-gugana an-ngurrnga a-wena a-ni, a-yinanga, ‘Marrban ngaypa gala nguburr-borrwa gu-galiya yerrcha rrapa Wangarr burr-guta, ");
INSERT INTO bvr_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","wurra jin-guna ng-gunggaja barra achila jarra, barra nguna-bawa. Gala yapa jina-boga jina-jingin, ngaypa ngu-rrumiyan.’” ");
INSERT INTO bvr_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Lika Jesus a-yinagata, “Bubu-borrwa an-gata joborr jaga an-gugana a-wena, minypa jurdach a-gunggajinga achila marrban nipiya gala an-ngurrnga an-gugunggaja. ");
INSERT INTO bvr_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","Jarra Wangarr gala a-yinmiya burr-dalaja aburr-yigipa gu-galiya yerrcha nipa burr-menga, aburr-gatiya minypa abu-wengganacha aburr-workiya ana-munya rrapa ji-gurdarrja. Wurra nipa a-gunggajapa barra burrwa; gala barra gun-baykarda gu-ga. Wurra nuwurra waypa an-guna An-walkurpa An-gugaliya ana-jeka barra gun-guna rrawa, nipa waygaji burr-barripa barra marr aburr-balcharra nula, waygaji gun-nyagara, ya?” ");
INSERT INTO bvr_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Rrapa aburr-werranga aburr-gata marr aburr-balcha burrwa aburr-ni birripa wupa ngardapa, jimarn jarra gubu-borrwurra jechinuwa aburr-ni nula Wangarr, rrapa minypa gala jal aburr-nirrarna burrwa wurra gama gorlk, wurra jarra bama aburr-yinanga jimarn jarra aburr-werra; aburr-gurda ngacha gu-galiya yerrcha Jesus a-wena burrwa a-ni, meyali gu-ngurrjinga gun-maywapa ranginy minypa gun-guna: ");
INSERT INTO bvr_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Abirri-jirrapa gu-galiya yerrcha ngardapa ngardapa abirri-warrchinga bala gun-japurra Wangarr gun-nika gatiya barra abirri-wenggana. An-ngardapa nipa Berachi (Pharisee), rrapa an-ngardapa nipa an-mujama nula gapman minypa rrupiya mu-menga nula a-workiyana, wurra gama gorlk burr-gaypuna. ");
INSERT INTO bvr_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Minypa nipa Berachi ngardapa a-wengganana a-ji, nipa a-yinanga, ‘Wangarr, ngaypa ngu-japurramayana nggula gun-gata nula minypa ngaypa ngika minypa an-nerranga an-gugaliya an-gata an-nerra. Ngaypa gala mun-ngumurda ngu-ma ngu-workiya, rrapa gala ana-werranga jin-nika gama ngu-ma ngu-workiya. Rrapa ngaypa ngika minypa an-gaba an-mujama gapman. ");
INSERT INTO bvr_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ngaypa jarra minypa Mandi (Monday) gu-nirra gu-workiya rrapa Jaychi (Thursday) gu-nirra burr-guta ngaypa balaja ngu-bawuja ngu-workiya, minypa gala ngu-borrwa ngu-ni mun-gata wurra jarra ngiy-wengganacha ngu-workiya. Rrapa mun-nga burr-guta mu-yinmiyapa ngaypa ngu-mangga ngu-workiya, ngu-ngorrkorndanga ngu-workiya minypa arr-jirrapa arr-murna, rrapa ngiy-wucha ngu-workiya mun-ngardapa mun-nginyipa rrapa mun-nerranga mun-ngaypa.’ A-yinagata a-wena an-gata Berachi, wurra minypa nipa wupa ngardapa an-molamola a-negiyana nula Wangarr. ");
INSERT INTO bvr_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Wurra an-gata an-mujama gapman an-nika, nipa jarra balay a-ji; gala waykin a-ganajarna. Minypa a-buyana a-ji mirrka a-jirra rrapa a-yinanga a-wena, ‘Wangarr, gunggaja apula! Ngaypa ngu-werra!’ ");
INSERT INTO bvr_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Gun-nardiya janguny, wurra buburr-galiya apula: An-gata an-mujama gapman an-nika a-jekarra a-bamuna gun-nigipa rrawa, nipa Wangarr a-nana nipa jechinuwa a-ni nula, wurra a-nana an-gata Berachi an-jechinuwa ngika. Gu-gurda ngacha minypa ana-nga an-gata wana a-negiya a-workiya, jarra Wangarr delipa a-nega barra an-gata an-gugaliya. Rrapa ana-nga an-gata delipa a-negiya a-workiya, Wangarr nipa jarra wana a-nega barra.’ ");
INSERT INTO bvr_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Gun-gatiya lika aburr-werranga rrapa yokuyoka burrbu-ganyja gurda nula Jesus barra nipa bin-dima minypa burr-jalkaka. Wurra Jesus burr-yika jawina burrbi-nana, lika burrbu-jobujobuna. ");
INSERT INTO bvr_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Wurra mola Jesus a-gonyjinga burrwa gu-ngarda yerrcha rrapa a-wena burrwa aburr-yigipa jawina, a-yinanga burrwa, “Burrbu-bawa delipa delipa yerrcha barra aburr-boy gurda apula! Ganapa burrbu-jobujoba! Ngardawa Wangarr burr-barlmarrk jama a-jirra burrwa aburr-yigipa gu-galiya yerrcha aburr-gatiya minypa aburr-gurda gu-ngarda yerrcha. ");
INSERT INTO bvr_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Gun-guna ngu-weya ana-gorrburrwa gun-burral: Gala ana-nga an-gugaliya Wangarr ana-murna a-ninya, wurra minyja a-ngukurdanyjiya rrapa a-ni minypa aburr-guna delipa delipa yerrcha.” ");
INSERT INTO bvr_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Rrapa Ju bunggawa an-gata a-wengganana Jesus, “A-lay, ny-jurda ny-molamola marn․gi nyi-gunega. Wurra ngaypa ngu-yinmiya barra jama ngu-ji minypa wanngu ngu-nipa barra ngu-workiya Wangarr ana-murna.” ");
INSERT INTO bvr_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesus a-yinanga nula, “A-lay, an-nga nula nginyipa nguna-ngurrjinga ngaypa ngu-molamola? Minyja gala ana-nga an-molamola, wurra jarra nipa wupa Wangarr. ");
INSERT INTO bvr_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wurra nginyipa marn․gi joborr gun-guyinda: Minypa gala barra jin-ngumurda ny-ma ana-werranga jin-nika, rrapa gala barra ny-bu, a-juwa, rrapa gala barra mun-ngumurda ny-ma, rrapa gala barra bima ny-nyurrja, wurra jarra marr ny-balcha barra burrinyjula nyanyapa nggu rrapa mampa nggu.” Jesus a-yinagata a-wena nula. ");
INSERT INTO bvr_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Lika nipa An-gugaliya a-yinagata a-wena, “A-lay, gipa mu-ngoyurra ngaypa ngu-balgurla ngu-ni gu-gurda ngacha ng-galiyana rrapa ngu-borrwuja ngu-nirra.” ");
INSERT INTO bvr_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Gun-narda nipa Jesus a-galiyana, lika a-wena nula an-gata, “A-lay, mola gun-ngardapa gun-gata nginyipa barra ny-yinda. Minyja boy, gun-nginyipa gorlk ma, burr-wu rrapa ma rrupiya burrwa aburr-gata aburr-nyagara; burraya nginyipa gun-molamola ny-ma barra gun-gaba waykin. Wurra guwa, nguna-jurrjurrma.” ");
INSERT INTO bvr_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Wurra nipa gun-narda a-galiyana, nipa garla a-darrjinga a-ni, ngardawa nipa gorlk gun-jaranga gu-rrimarra. ");
INSERT INTO bvr_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Gun-narda Jesus gu-nana nula, lika nipa a-yinagata, “Aburr-gata minypa gorlk gun-jaranga gubi-rrimanga, birripa burr-guya gun-derta burrwa rraka aburr-galiya nula Wangarr rrapa nipa ana-murna aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Minypa gun-maywapa ranginy niyal (needle) rralala a-maya a-jirra an-gata nganaparra gala a-yinmiya a-barrnguma, gu-gurda ngacha minypa an-gugaliya gorlk gun-jaranga gu-rrimanga gala a-yinmiya a-galiya nula Wangarr rrapa nipa ana-murna a-ni.” ");
INSERT INTO bvr_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Aburr-gata aburr-galiyana nula Jesus gun-narda nipa a-wena, birripa abu-wengganana, “A-lay, gun-narda gun-derta gun-gorla janguny, ngarla! Wurra ana-nga barra wanngu a-ni?” ");
INSERT INTO bvr_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Wurra nipa a-yinagata, “Gun-gata gun-nga gun-derta gun-gorla nula an-gugaliya, gun-narda ngika gun-derta gun-gorla nula Wangarr.” ");
INSERT INTO bvr_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Lika nipa Birta (Peter) a-wena, “A-lay, ngayburrpa nyibu-bawuna gun-jaranga rrapa nyiburr-guna bubu-jurrjurrmunga!” ");
INSERT INTO bvr_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Lika nipa Jesus a-yinagata burrwa, “Gun-guna ngu-weya ana-gorrburrwa gun-burral: Ana-nga minypa gu-bawa gun-nigipa rrawa, waygaji gala jiny-ma jin-nigipa gochila abi-rrana, waygaji burr-bawa worlapa niya yerrcha, waygaji nyanyapa niya rrapa mampa niya bijirriny-bawa, o gu-ngarda yerrcha burr-bawa minypa nipa gu-bitimanga a-nirra Wangarr gun-nika, ");
INSERT INTO bvr_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nipa an-gata an-gugaliya gun-guniya gu-ma barra mola gun-jaranga, rrapa gun-gata jurdach guna-bamburda wanngu a-nipa barra a-workiya.” ");
INSERT INTO bvr_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Gu-gata wenga Jesus burr-ganyja a-bamuna ngardapa aburr-yigipa 12 gu-galiya yerrcha, lika a-wena burrwa, “Buburr-galiya apula: Ngayburrpa Jirúchalam (Jerusalem) nguburr-boya, rrapa gun-nga gun-gata Wangarr burr-yika aburr-mujaruk ngunyuna aburr-guyinda aburr-wena, abu-ngurrjinga an-guna An-walkurpa An-gugaliya, gurda gun-burral gu-ni barra. ");
INSERT INTO bvr_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Minypa burrbu-wu barra Jentayl (Gentile) yerrcha an-guna, lika birripa abu-borrkpa barra rrapa gun-bachirra aburr-wengga barra nula rrapa m-bordich abu-balka barra. Abu-jurrburaykujama barra, lika abu-bu barra a-juwa. ");
INSERT INTO bvr_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Wurra nuwurra waypa ngorrngurra abirri-jirrapa gun-ngardapa gu-ni barra, nipa a-molamiya barra.” ");
INSERT INTO bvr_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jesus a-yinagata a-wena burrwa aburr-yigipa jawina, wurra gun-gata birripa gala marn․gi aburr-nirrarna. Wurra meyali gun-gata gu-yilkakiyana burrwa gu-ni rraka gala aburr-yinmiyarna gubu-malawujarna. ");
INSERT INTO bvr_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Gatiya Jesus ana-bamuna yi-gurrepa rrawa Jerikow (Jericho), gatiya an-gapula a-ni gu-jarlakarr gu-rrarnba minypa nipa a-ngiwija burrwa a-workiyana gu-galiya yerrcha mun-nga birripa abu-wucharna. ");
INSERT INTO bvr_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Wurra nipa a-galiyana gu-galiya yerrcha abu-beybeybana aburr-ji, lika burr-wengganana gun-narda gun-nga. ");
INSERT INTO bvr_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Birripa aburr-yinanga, “Jesus an-guna Nejarach (Nazareth) an-guyinda a-bamburda.” ");
INSERT INTO bvr_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Lika nipa a-gonyjinga, “A-lay, Jesus, ny-junarda nipa Daybit (David) murna biy-wuna arrburrwa, gunggaja apula, a-lay!” ");
INSERT INTO bvr_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wurra birripa aburr-gata mu-ngoyurra aburr-bamuna abu-jobujobuna rrapa aburr-wena nula barra gun-ngap gu-bawa. Wurra nipa mu-nguy burr-guya a-gonyjinga, “A-lay, Jesus, ny-junarda nipa Daybit murna biy-wuna arrburrwa, gunggaja apula, a-lay!” ");
INSERT INTO bvr_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Lika Jesus a-derichinga, a-wena burrwa barra an-gapula abu-ga gurda nula. Lika nipa yi-gurrepa a-ni, lika Jesus a-wena nula, ");
INSERT INTO bvr_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“A-lay, nginyipa jal nyi-nirra ngaypa ngu-yinmiya barra nggula?” “Bunggawa, ngaypa jal ngu-nirra ng-gana barra.” ");
INSERT INTO bvr_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Lika Jesus a-wena nula, “Gana. Ngardawa nginyipa marr ny-balcha, lika nginyipa ny-molamiyana.” ");
INSERT INTO bvr_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Lika gatiya gugu an-gapula a-ganana, lika a-marrkapchinga nula Wangarr minypa a-jurrjurrmurra a-bamuna Jesus. Rrapa aburr-gata wurra gama gorlk, gun-narda waypa gubi-nana gu-yinmiyana, lika birripa burr-guta aburr-marrkapchinga nula Wangarr. ");
INSERT INTO bvr_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Gu-gata wenga lika Jesus a-bena Jerikow (Jericho), lika ay-barrngumurra ay-bamuna. ");
INSERT INTO bvr_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Rrapa gatiya a-ni a-workiyana an-ngardapa an-gugaliya an-nelangga Jekíyach (Zacchaeus), nipa bunggawa burrwa aburr-gata aburr-mujama nula gapman rrupiya mbi-mangga nula aburr-workiya, wurra gama gorlk burrbu-gaypurda, rrapa nipiya Jekíyach gorlk gun-jaranga gu-rrimarra. ");
INSERT INTO bvr_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nipa jal a-ni a-nacharna an-an․gaya Jesus, wurra gu-galiya yerrcha aburr-gorlkakaja nula aburr-ji rraka gala a-yinmiyarna a-nacharna; ngardawa nipa an-balmbarra. ");
INSERT INTO bvr_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Lika mu-ngoyurra burr-beybana a-yurtchinga, lika a-warrchinga gu-jong gun-gata gun-nelangga jikamor (sycamore), barra waykin wenga a-na Jesus, ngardawa nipa ana-bamburda. ");
INSERT INTO bvr_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Gatiya waypa Jesus ana-bamuna, a-bena, lika a-ganana waykin, a-nana Jekíyach. Lika a-wena nula, “A-lay, nyina-bupiya nyina-jarl! Ngardawa gun-nginyipa rrawa ngaypa geka barra ngu-ninya barra.” ");
INSERT INTO bvr_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Lika Jekíyach ana-bupiyana ana-jarl, lika a-gonyjinga nula gu-yigipa gu-rrawa minypa nipa burr-guya a-marrkapchinga. ");
INSERT INTO bvr_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wurra gun-gata aburr-werranga gubi-nana, lika abu-yopuna aburr-ni Jesus, minypa aburr-yinanga, “A-lay, nipa a-bona, balapala a-rrenyjinga an-gata an-nerra an-gugaliya, ngarla!” ");
INSERT INTO bvr_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Wurra Jekíyach nipa a-garlmuna, a-wena nula Jesus, “Minyja nguna-na ng-guna, a-lay, Bunggawa. Gun-nga ngaypa ngu-rrimanga ngu-nirra, ngaypa ngu-ngorrkornda barra rrapa mun-nerranga nguburr-wu barra aburr-gata aburr-nyagara aburr-nirra. Rrapa ana-nga an-gata ng-gaypuna ngaypa barra ng-gurdanyja nula, wurpa mun-gata ng-gaypuna ngaypa ng-gurdanyja barra nula minypa abirri-jirrapa abirri-jirrapa.” ");
INSERT INTO bvr_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Lika Jesus a-wena nula aburr-werranga minypa aburr-galiyana, a-yinanga, “Geka gun-guniya wanngu gun-guni gugu gu-bena ana-guna gun-nika rrawa. Ngardawa nipiya an-guna Jekíyach burr-guta Aybriyam (Abraham) an-bapurr, minypa ngardapa buta marr abirri-balcharra. ");
INSERT INTO bvr_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ngardawa an-guna An-walkurpa An-gugaliya ana-bona, a-wechawecharra burrwa wanngu barra burr-nega aburr-gata aburr-lijiwarriyana.” ");
INSERT INTO bvr_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Gun-gata janguny gu-galiya yerrcha aburr-galiyana aburr-ni, lika Jesus mu-nguy a-wena, meyali gu-ngurrjinga burrwa a-ni gun-maywapa ranginy, ngardawa yi-gurrepa aburr-bena aburr-bamuna rrawa Jirúchalam (Jerusalem), rrapa birripa gubu-borrwurra jimarna jarra gun-guniya barra Wangarr gu-ngukurdanyja rrapa gun-molamola gu-nega. ");
INSERT INTO bvr_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Gu-gurda nula nipa marn․gi burr-negarra a-ni rrapa janguny gu-ngurrjinga burrwa minypa a-yinanga a-wena, “An-ngardapa an-gugaliya a-ni a-workiyana, nipa an-nelangga wana. Nipa a-garlmuna, nawanawa a-ni barra a-boy balay rrawa gatiya barra nipa minypa bunggawa a-ni, lika ana-jeka, rrawa gu-rrima a-ni. ");
INSERT INTO bvr_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Minypa nipa a-gonyjinga burrwa aburr-yigipa aburr-mujama arr-jirrapa arr-murna, lika nipa burr-wuna rrupiya goldan mu-maya, a-yinanga burrwa, ‘Mun-narda arr-wuna ana-goyburrpa barra jaga nyiburr-gana nuwurra ngaypa nguna-jeka. Minypa bayim nyiburr-ni barra rrapa jalim nyiburr-ni barra, minyja rraka wana nyibu-man apula.’ ");
INSERT INTO bvr_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Wurra gu-galiya yerrcha gun-gata rrawa birripa gala jal aburr-nirrarna nula an-gata. Wurra jurdach burrbi-jerrmarra aburr-mujaruk, aburr-wena nula an-nerranga an-gata wana an-babalapa, aburr-yinanga nula, ‘An-guna ngayburrpa gala jal nyiburr-ni nula bunggawa a-ni barra gun-ngayburrpa rrawa.’ ");
INSERT INTO bvr_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Wurra wuriya. Wurra nipa gugu bunggawa a-ni, lika ana-jekarra, a-bena. Lika a-gonyjinga burrwa aburr-yigipa aburr-mujama aburr-gata mu-ngoyurra rrupiya burr-wuna, minypa a-birripiyana mu-yinmiyapa barrwa mbi-menga nula. ");
INSERT INTO bvr_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“An-gata mu-ngoyurra ana-bona, nipa a-yinanga, ‘Bunggawa, mun-nginyipa rrupiya nginyipa nguna-wuna mun-ngardapa, ngaypa barrwa ngu-menga nggula minypa arr-jirrapa arr-murna.’ ");
INSERT INTO bvr_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Lika bunggawa a-wena nula, ‘Ganapiya. Murna ny-maranga. Ny-molamola apula nyi-mujama. Rrapa ngardawa gun-mola jama nyi-ni mun-gata nula mun-delipa ngaypa ngiy-wuna, ngaypa ngiy-gurrma barra nginyipa bunggawa nyi-ni barra rrawa gun-guna gu-jirra gu-boya arr-jirrapa arr-murna.’ ");
INSERT INTO bvr_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Lika an-nerranga an-gata ana-bona, a-yinanga nula, ‘Bunggawa, mun-nginyipa rrupiya nginyipa nguna-wuna mun-ngardapa, ngaypa barrwa ngu-menga nggula minypa arr-ngardapa arr-murna.’ ");
INSERT INTO bvr_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Lika bunggawa a-wena nula, ‘Ngaypa ngiy-gurrma barra nginyipa bunggawa nyi-ni barra rrawa gun-guna gu-jirra gu-boya arr-ngardapa arr-murna.’ ");
INSERT INTO bvr_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Rrapa mola an-nerranga ana-bona, a-yinanga nula, ‘Bunggawa, mun-guna mun-nginyipa mun-ngardapiya rrupiya ngaypa ngu-ngurrngbichinga, ngu-yilkakaja, mu-yunya nggula. ");
INSERT INTO bvr_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ngardawa ngaypa ng-gurkuja nggula ngardawa nginyipa n-derta ny-jorla. Minypa nginyipa ny-mangga ny-yorkiya nginyipa gala ny-jurrma rrapa gala jama ny-ji.’ ");
INSERT INTO bvr_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","“Lika bunggawa a-wena nula, ‘Minyjiya. Rrapa gu-gurda ngacha minypa ngaypa burr-mari ngu-wengga barra nggula. Ngardawa nginyipa marn․gi apula ngaypa ngu-derta ng-gorla, minypa ngaypa ngu-mangga ngu-workiya gala ng-gurrma rrapa gala jama ngu-ji. Wurra yama ny-jurrmungarna mun-ngaypa rrupiya bengk (bank) mu-guyinda minypa birripa jama aburr-jirrarna, mola mbi-manggarna apula, ngunabu-wucharna? Wurra ny-jurda nginyipa ny-yerra nyi-mujama, ngarla!’ ");
INSERT INTO bvr_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Lika nipa a-wena burrwa gu-galiya yerrcha aburr-gata aburr-jinyja, ‘A-lay, an-guna bubu-murnamagaypa mun-gata rrupiya ngaypa ngu-wuna rrapa bubu-wu an-gata arr-jirrapa arr-murna mu-rrimanga.’ ");
INSERT INTO bvr_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Aburr-yinanga, ‘Wurra Bunggawa, a-lay, gipa an-gata mu-rrimanga minypa arr-jirrapa arr-murna!’ ");
INSERT INTO bvr_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Wurra nipa a-yinagata, ‘Buburr-galiya apula; gun-guna gun-burral: Ana-nga an-gata gu-rrimanga gun-nga rrapa jama a-jirra, burraya mola gu-ma barra. Wurra an-nerranga ana-nga nipa minypa gala gu-rrima, burraya bunggawa a-gaypa barra an-gata an-gugaliya gun-gata gun-delipa jimarn jarra nipa gu-rrimangarna a-nirrarna. ");
INSERT INTO bvr_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ganapiya. Ngu-mungbuna. Wurra aburr-gata aburr-bachirra apula, aburr-gatiya minypa gala jal aburr-nirrarna apula bunggawa ngu-nirrarna, buburr-boy, burrbi-rrima, burrbu-ga gurda, burrbu-bu. Barra ngu-mibilapa aburr-juwa.’” ");
INSERT INTO bvr_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Gun-gata janguny Jesus a-wena a-ni, lika nipa mu-ngoyurra a-guguyana burrwa a-bona Jirúchalam. ");
INSERT INTO bvr_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Aburr-bamuna, aburr-bena mu-mirk mun-gata mun-nelangga Alip (Olive) Mu-jirrapa rrapa gun-murna rrawa gu-jirra gun-gata Betpey (Bethphage) rrapa Bechini (Bethany). Lika Jesus bijirri-jerrmarra gata abirri-yigipa jawina abirri-jirrapa, ");
INSERT INTO bvr_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","minypa gu-jarlapuna a-wena, a-yinanga butula, “Birri-boy gun-gata rrawa mu-ngoyurra guna-jinyjarra, gun-nardiya gugu nyirri-barripa barra dongki (donkey) an-delipa a-bandawiya a-jirra, gala ana-nga mu-ngoyurra a-warrchingarna a-workiyarna. Lika ana-gotipa birri-yarlayarlawa nula, lika birri-ga gurda ay-ngunyunaga. ");
INSERT INTO bvr_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Rrapa minyja ana-nga nyjirri-wenggana, a-yinda, ‘An-narda an-nga nula nyirri-yarlayarlawuja nula?’ wurra ana-gotipa nyirri-wengga barra nula, ‘Bunggawa jal a-nirra nula an-guna.’” ");
INSERT INTO bvr_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ganapiya. Lika abirri-bona, abirri-barripuna dongki an-gata minypa Jesus a-ngurrjinga. ");
INSERT INTO bvr_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Lika gata waypa bitipa mbirri-yarlayarlawurra abirri-ni murndurn, aburr-gata dongki aburr-gurrimapa aburr-garlmuna, burrbu-wengganana, “An-nga nula nyirri-yarlayarlawuja nula nyirri-nirra an-narda dongki?” ");
INSERT INTO bvr_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Wurra bitipa abirri-yinanga, “Bunggawa jal a-nirra.” ");
INSERT INTO bvr_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Lika bitipa an-gata dongki abirri-ganyja gurda nula Jesus. Lika mun-bitipa molma mun-gunegiya mirikal ana-jonama dongki mbirri-gurrmurra, lika abirri-gunggajinga nula Jesus, nipa a-warrchinga. ");
INSERT INTO bvr_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Lika gu-jarlakarr a-bamuna waykin dongki ana-jonama, rrapa wurra gama gorlk mun-birripa molma mun-gunegiya mirikal mbi-yarlanggaja nula aburr-bona gu-jarlakarr minypa an-gata dongki mu-rrenyjinga a-bamuna rrapa nipa Jesus waykin ana-jonama. ");
INSERT INTO bvr_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Lika yi-gurrepa aburr-bena aburr-bamuna jarlakarr gun-gata guy-yurra guy-bupiya guy-jarl mun-mirk Alip Mu-jirrapa, lika aburr-jaranga aburr-gata abu-jurrjurrmurra aburr-bamuna Jesus birripa aburr-marrkapchinga, aburr-gonyjinga, aburr-marrjerrmiyana nula Wangarr minypa gipa abi-nana nipa burr-barlmarrk jama a-ji a-workiyana. ");
INSERT INTO bvr_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Aburr-yinanga, “Japurra ngapa a-jirra! An-guna nipa Bunggawa Wangarr barra gun-molamola gu-nega nula, ngardawa nipiya Wangarr ana-jerrmarra! Rrapa yi-gaba waykin magaya gu-ji barra rrapa Wangarr abu-ngurrja barra an-molamola!” Aburr-yinagata Jesus burr-yika jawina yerrcha aburr-gata aburr-jaranga aburr-marrjerrmiyana nula aburr-bamuna Wangarr. ");
INSERT INTO bvr_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Wurra aburr-werranga aburr-gata Berachi (Pharisee) yerrcha, birripa jarra aburr-garlmunapa aburr-wena nula Jesus, “A-lay, Bunggawa, wengga burrwa aburr-guna aburr-nginyipa jawina barra aburr-nganangurtcha!” ");
INSERT INTO bvr_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Wurra Jesus a-yinanga a-wena burrwa aburr-gata Berachi yerrcha, “Ngika. Wurra minyja aburr-guna gu-galiya yerrcha nguburr-jobujoba, gun-guna jandarra gun-guyinda gu-yurra gu-nirra gu-gonyja barra gu-ni, ngarla!” ");
INSERT INTO bvr_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Lika gatiya waypa marr yi-gurrepa aburr-bena, Jesus gu-nana gun-gata gun-murnangana rrawa Jirúchalam, lika a-rruwujana burrwa gu-galiya yerrcha gu-gata burr-yika gu-rrawa. ");
INSERT INTO bvr_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Lika nipa a-wena, “Yama ana-goyburrpa burr-guta geka nyibu-borrwujarna gun-guna magaya gun-guni? Wurra jarra gala nyiburr-yinmiya nyibi-na! ");
INSERT INTO bvr_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Wurra gu-balmapa guna-boya guna-jirra minypa aburr-goyburrpa aburr-bachirra ana-gorrburrwa birripa aburr-gomarriya barra, lika derta aburr-negiya barra, lika nyirrbi-rrenyjapa aburr-bengga. ");
INSERT INTO bvr_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Lika rrawa gubu-rruma barra ana-gorrburrwa rrapa nyirrbu-bu barra. Minypa gun-gata jandarra gun-guyinda ana-goyburrpa nyibi-jarlapuna gun-guna rrawa, birripa gala barra gubu-bawa abirri-jirrapa gu-yu. Wurra gubu-rruma barra, laka gubu-ga, gun-jinachina gu-yu barra gu-ni. Gu-yirda barra gu-ni ana-gorrburrwa ngardawa gala nyibu-malawujarna Wangarr yi-gurrepa a-ni ana-gorrburrwa.” ");
INSERT INTO bvr_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Gu-gata wenga Jesus a-bona, a-barrngumurra Wangarr gun-nika gu-japurra rrawa. Lika a-garlmunapa burr-yerrnyjinga a-ni aburr-gata minypa jalim aburr-ni gatiya. ");
INSERT INTO bvr_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Minypa a-yinanga burrwa, “Janguny mu-jurra gu-yurra Wangarr a-wena, a-yinagata, ‘Gu-ngaypa gu-bala gu-galiya yerrcha ngunabu-wenggana barra aburr-workiya.’ Wurra jarra ana-goyburrpa werra nyibi-negarra nula Wangarr gun-nigipa bala minypa wurra gama gorlk ngunyuna nyirrbu-gaypurda nyiburr-workiya, jalim nyiburr-nirra burrwa nyiburr-workiya.” ");
INSERT INTO bvr_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Lika Jesus mu-nguy janguny marn․gi burr-negarra a-ni a-workiyana wurra gama gorlk gatiya Wangarr gun-nika gu-japurra rrawa. Wurra aburr-gata wana junggay yerrcha rrapa joborr marn․gi aburr-gunega rrapa barrwa ngoyurra aburr-jirra burrwa wurra gama gorlk, birripa jarra jal aburr-ni abu-bu barra. ");
INSERT INTO bvr_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Wurpa lika aburr-jurnjinga, ngardawa wurra gama gorlk gatiya burr-guya aburr-galiyana nula aburr-ni janguny nipa a-yinmiyana a-wena a-bamuna. ");
INSERT INTO bvr_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Gun-nerranga ngorrngurra gu-ni, Jesus marn․gi burr-negarra a-ni janguny gu-galiya yerrcha gatiya Wangarr gun-nika rrawa, rrapa aburr-gata wana junggay yerrcha rrapa joborr marn․gi aburr-gunega rrapa aburr-werranga burr-guta mu-murna yerrcha, birripa aburr-bona gurda nula, ");
INSERT INTO bvr_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","aburr-yinanga nula, “A-lay, wengga arrburrwa: Ana-nga a-wena nggula ny-yinagata ny-boya?” ");
INSERT INTO bvr_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Wurra Jesus a-wena burrwa, “Ngaypa rrapa arr-wenggana barra ana-goyburrpa. Marrka bubu-ngurrja apula: ");
INSERT INTO bvr_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ana-nga a-wuna Jon gun-gata bama gun-gugurraga nipa bama burr-gurragaja a-workiyana? Nipa Wangarr, wurra waygaji an-gugaliya, ya?” ");
INSERT INTO bvr_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jesus a-yinagata a-wena burrwa, wurra birripa aburr-garlmunapa aburr-wengganachichiyana birripa wupa, “A-lay, ngayburrpa nguburr-yinmiya barra? Minyja gala yapa nguburr-yindin, ‘Wangarr a-wuna bama gun-gugurraga nipa Jon;’ galapa nipa an-guna a-yindin arrburrwa, ‘An-nga nula rrapa ana-goyburrpa gala marr nyiburr-balcharna nula?’ ");
INSERT INTO bvr_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Wurra gala barra nguburr-yinda nguburr-wengga, ‘An-gugaliya a-wuna bama gun-gugurraga gun-gata;’ galapa aburr-guna gu-galiya yerrcha gu-jandarra arrbu-bun. Ngardawa birripa gubu-borrwurra jimarna bama aburr-yinaga Jon a-wena a-workiyana Wangarr nyanma.” ");
INSERT INTO bvr_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Lika aburr-gata wana junggay yerrcha rrapa joborr marn․gi aburr-gunega rrapa barrwa aburr-werranga mu-murna yerrcha, birripa aburr-yinagata nula Jesus, “Gala ngayburrpa marn․gi yina gaya gu-menga gun-gata bama gun-gugurraga.” ");
INSERT INTO bvr_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Lika Jesus a-wena burrwa, “Rrapa ngaypa gala ngu-yinmiya ngu-wengga ana-gorrburrwa ana-nga nipa a-wena, ngaypa jama ngu-jirra.” ");
INSERT INTO bvr_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Gatiya lika Jesus a-garlmuna, a-wena burrwa wurra gama gorlk meyali gu-murna janguny minypa gun-guna: “An-gugaliya, ngarla, gun-nigipa rrawa a-lamajinga, nipa mun-gata gurnal mun-murra mu-jinyja. Ganapiya, lika burr-menga gu-galiya yerrcha barra rrawa aburr-ni rrapa jaga aburr-gana mun-gata gurnal, lika nipa rrawa an-gurrimapa gu-bawuna a-bona balay, nuwurra waypa gu-yinpa ana-jeka. ");
INSERT INTO bvr_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“Ganapiya, lika gu-bamuna, mun-gata gurnal mu-molamiyana, lika mbi-ma barra. Lika an-gata an-gurrimapa an-nigipa an-mujama an-ngardapa ana-jerrmarra burrwa aburr-guna jaga aburr-ganana mun-gata gurnal, jimarn jarra bama a-yinanga birripa mbi-ngorrkorndangarna aburr-nirrarna, lika mbi-jerrmangarna nula mun-nigipa nipa an-gata an-gurrimapa. Wurra aburr-guna jaga aburr-ganana nula gurnal, an-gata an-mujama birripa abi-rrimarra, abu-buna, lika abi-jerrmarra, a-jekarra a-bona, gala mun-nga gurnal mu-ganyjarna. ");
INSERT INTO bvr_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Lika an-gata an-gurrimapa barrwa ana-jerrmarra an-nerranga an-nigipa an-mujama, wurra nipa burr-guta birripa abu-buna rrapa werra abi-negarra, lika abi-jerrmarra, a-jekarra a-bona, gala mun-nga mu-ganyjarna. ");
INSERT INTO bvr_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Rrapa barrwa ana-jerrmarra birripa abu-buna, abi-yerrnyjinga an-jeja. ");
INSERT INTO bvr_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Lika an-gurrimapa nipa an-ngurrnga a-wena a-ni, ‘Ngaypa ngu-yinmiya barra? Wurra ngaypa ngu-jerrma barra an-ngaypa walkur burr-guya jal ngu-nirra nula; birripa marr aburr-balcha barra nula nipa.’ ");
INSERT INTO bvr_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Wurra aburr-guna jaga aburr-ganana mun-gata gurnal, birripa waypa abi-nana an-walkurpa ana-bena, birripa wupa aburr-wengganachichiyana aburr-ni, ‘A-lay, an-guna, ngarla, burraya rrawa an-gurrimapa gu-bawa, nipa an-guna gu-ma barra rrapa mun-guna gurnal mun-murra mu-jinyjarra mun-nigipa mu-ni. Wurra yama ngubu-bu barra mun-ngayburrpa mu-ni?’ ");
INSERT INTO bvr_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Lika aburr-garlmunapa abi-rrimarra, abi-yerrnyjinga yarlanga gun-gata rrawa, lika abu-bunapa a-juwuna. “Ya? Ana-goyburrpa gun-nga nyibu-borrwuja nyiburr-nirra? An-gata an-gurrimapa nipa lika a-yinmiya barra burrwa aburr-gata? ");
INSERT INTO bvr_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Wurra nipiya barra ana-boy, burr-bu barra aburr-gata jaga aburr-ganana aburr-workiyana mun-gata gurnal. Lika aburr-werranga burr-ma barra birripa jaga aburr-gana barra nula mun-nigipa gurnal mun-murra mu-jinyjarra.” A-yinagata Jesus gu-ngurrjinga burrwa janguny. Wurra gun-narda waypa wurra gama gorlk aburr-galiyana nipa a-wena, birripa aburr-yinanga, “Burdak. Gala barra gu-yirda!” ");
INSERT INTO bvr_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Wurra nipa Jesus burr-nana, a-garlmunapa burr-wengganana, “Wurra janguny gun-gata mu-jurra gu-yurra gun-maywapa ranginy, ana-goyburrpa gun-nga nyibu-borrwuja meyali, ya? Gun-gata minypa gu-yinaga, ‘Bala gubu-gupuna jandarra gu-maya, wurra gun-ngardapa jandarra gun-gata birripa aburr-ngoyurra gubi-yerrnyjinga. Wurra gun-narda barrwa Wangarr gu-menga, wana gun-babalapa gugu gu-jirra; jechinuwa gu-nenga gu-nirra rrawa.’ ");
INSERT INTO bvr_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Minyja bubu-borrwa: Aburr-nga aburr-gata minypa gu-gata gu-jandarra burr-yerrnyja, aburr-bungga, aburr-gatiya gu-galiya yerrcha aburr-rrumurrmiya aburr-ni; wurpa lika an-gata minypa gun-gata jandarra gu-bunggapa a-rrenyja, nipa minypa an-ngukula a-nega.” ");
INSERT INTO bvr_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jesus a-yinagata a-wena, rrapa aburr-gata wana junggay yerrcha rrapa joborr marn․gi aburr-gunega, birripa aburr-galiyana rrapa marn․gi gun-gata meyali gu-murna nipa a-wena birripa burr-ngurrjinga a-ni. Lika aburr-garlmuna, bama aburr-yinanga, jimarn jarra gatiya gugu abi-rrimangarna Jesus, wurra aburr-gurkuja burrwa wurra gama gorlk aburr-gata abu-jurrjurrmurrapa aburr-workiyana. ");
INSERT INTO bvr_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Wurra abi-nana aburr-ni yina gaya julam gu-yurrarna barra abi-rrima. Rrapa minypa burr-rrupiya burrbu-menga aburr-werranga gu-galiya yerrcha birripa barra minypa Jesus abu-yolka, jimarn jarraka nipa a-yolkiyan a-wenggin rrapa gu-gata wenga minypa birripa wana Ju yerrcha abi-rrima, abu-ga, murna abu-wu an-gata gapman an-guyinda bunggawa gun-gata rrawa nipa a-yinmiya barra a-wengga. ");
INSERT INTO bvr_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ganapiya, lika aburr-gata rrupiya aburr-murna birripa aburr-bona gurda, abu-wengganana Jesus, “Bunggawa, a-lay, ngayburrpa marn․gi nggula nginyipa jechinuwa ny-yeya ny-yorkiya rrapa gala ana-nga ny-jurkuja nula wurpa niya an-gata an-nelangga wana. Ngayburrpa marn․gi nginyipa nyirr-gurdagurdarraja ny-yorkiya Wangarr gun-nika jarlakarr. ");
INSERT INTO bvr_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Wurra marrka wengga arrburrwa gun-ngayburrpa joborr gu-yinmiya gu-yurra: Gun-gata minypa bunggawa an-gata Rowm (Rome) a-nirra nipa rrupiya arr-gaypurda a-workiya minypa dek (tax), gun-narda gun-mola arrburrwa ngubu-wu, ya? Waygaji gun-nyagara, ya?” ");
INSERT INTO bvr_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Aburr-yinagata aburr-wena nula Jesus, wurra nipa gu-nana burrwa gun-gata minypa birripa abu-yolkaja aburr-ni. Lika nipa a-wena burrwa, ");
INSERT INTO bvr_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Marrka ngunabu-gurdagurdarra mun-gata rrupiya mun-mama jilpa (silver) mu-maya. Mun-guna ana-nga an-mawunga? Rrapa an-guna an-nelangga ana-nga?” Birripa aburr-yinagata, “An-narda Jija (Caesar) an-gata Rowm a-nirra bunggawa.” ");
INSERT INTO bvr_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Lika nipa a-yinagata burrwa, “Ganapiya. Jija nipa bubu-wu mun-nga mun-gata mun-nigipa Jija mun-nika. Wurra ana-goyburrpa nyiburr-burral buburr-wuya nula Wangarr, ngardawa gu-galiya yerrcha aburr-yigipa.” ");
INSERT INTO bvr_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ganapiya, wurra birripa gala aburr-yinmiyarna abu-yolkajarna Jesus nipa a-yinmiyana a-wena gatiya wurra gama gorlk aburr-galiyana nula aburr-ni. Ngardawa aburr-bachirra aburr-gata burr-guya aburr-jurnjinga, gubu-borrwurra aburr-ni nipa a-yinmiyana a-wena gun-gata gun-molamola. ");
INSERT INTO bvr_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Lika Jejuchi (Sadducee) yerrcha aburr-bona gurda nula Jesus, aburr-gata birripa aburr-weya aburr-workiya, jimarna bama aburr-yinaga an-gugaliya a-juwiya a-workiya Wangarr gala a-yinmiya barrwa a-jarrkarra. Aburr-gurdiya Jejuchi yerrcha aburr-bona gurda, lika abu-wengganana Jesus, ");
INSERT INTO bvr_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Bunggawa, a-lay, nipa Mojich (Moses) a-wukurrjinga arrburrwa gun-gata joborr, minyja an-gugaliya jin-nigipa jin-gumarrbipa niya jiny-bawa minypa a-juwa, wurra nipa jin-gata gala delipa a-manggarna, lika an-gata an-nigipa worlapa niya jiny-ma barra jin-gata gama barra delipa a-barripa butula an-bitipa an-murnangana gipa mu-ngoyurra a-juwuna. Gu-gurda ngacha. ");
INSERT INTO bvr_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Wurra gun-guna rrawa mu-ngoyurra aburr-ni worlapa burra yerrcha birripa wupa arr-ngardapa arr-murna rrapa abirri-jirrapa, minypa 7, an-gata an-murnangana jin-gumarrbipa jin-dimarra, wurra nipa a-juwuna gala delipa a-rrimangarna. ");
INSERT INTO bvr_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Lika minypa a-jurrjurrmurrapa jin-gata jiny-menga, ");
INSERT INTO bvr_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","rrapa barrwa a-guymurrapa rrapa aburr-werranga burr-guta worlapa niya yerrcha aburr-yinagatiya. Minypa birripa wupa arr-ngardapa arr-murna rrapa abirri-jirrapa aburr-juwuna aburr-ni, wurra gala ana-nga delipa abi-rrimangarna. ");
INSERT INTO bvr_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Lika gu-gata wenga rrapa nipa jin-gata gama jiny-juwuna. ");
INSERT INTO bvr_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Gun-narda janguny, wurra minyja Wangarr ngayburrpa arr-jarrkarra, lika jin-gata gama ana-nga jin-nika jin-gumarrbipa niya jinyu-ni barra, ya? Ngardawa gipa arr-ngardapa arr-murna rrapa abirri-jirrapa jibu-malapuna aburr-ni.” Aburr-yinagata aburr-gata Jejuchi yerrcha abu-wengganana Jesus, minypa birripa gubu-borrwurra, jimarna bama aburr-yinanga Wangarr gala a-jarrkarra an-gugaliya mu-ngoyurra a-juwuna. ");
INSERT INTO bvr_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Wurra Jesus a-yinanga burrwa, “Gu-gurdiya burr-yika gu-rrawa, birripa minypa gama aburr-wuchichiya aburr-workiya. ");
INSERT INTO bvr_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Wurra aburr-gata minypa Wangarr gu-borrwurra burrwa minypa birripa aburr-molamola barra nuwurra waypa aburr-juwa, nipa burr-jarrkarra rrapa wanngu burr-nega, gun-gatiya guna-bamburda birripa gala barra abirriny-malapachichiya abirrinyu-ni, ");
INSERT INTO bvr_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","rrapa minypa gala aburr-yinmiya mola aburr-juwa. Wurra jarra minypa waykin aburr-guyinda aburr-ni barra ngardawa Wangarr burr-yika walkurpa yerrcha nipa burr-jarrkarrana. ");
INSERT INTO bvr_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Wurra gun-gata nula minypa Wangarr burr-jarrkarraja a-workiya mu-ngoyurra aburr-juwuna, nipa Mojich burr-guta arr-gurdagurdarraja a-nirra minypa gun-narda gun-burral. Ngardawa gun-gata janguny minypa gun-jong gu-rronga wurra nipa gala gu-rronggarna, gu-gata gu-janguny Mojich a-ngurrjinga Wangarr, ‘nipiya Wangarr aburr-guna an-burriya: Aybriyam (Abraham) rrapa Ayjek (Isaac) rrapa Jeykap (Jacob).’ Nipa a-yinagata a-ngurrjinga Wangarr wuriya aburr-gata minypa Aybriyam rrapa Ayjek rrapa Jeykap gipa mu-ngoyurra aburr-juwuna. ");
INSERT INTO bvr_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Wurra bubu-borrwa: nipa Wangarr gala a-yinmiya an-birripa a-ni Wangarr minyja jimarn jarra gun-gata gun-nyagara gu-ni gun-gumungba. Ngika. Wurra jarra aburr-mola aburr-nirra Wangarr ana-murna.” Jesus a-yinagata gu-ngurrjinga burrwa Jejuchi yerrcha. ");
INSERT INTO bvr_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Rrapa minypa aburr-werranga joborr marn․gi aburr-gunega aburr-gata, birripa aburr-garlmunapa aburr-wena, “Gun-narda gun-molamola ny-yena, a-lay, Bunggawa!” ");
INSERT INTO bvr_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Rrapa gala ana-nga barrwa a-yinmiyarna a-wengganacharna gun-nga; wurra aburr-jurnjinga. ");
INSERT INTO bvr_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Lika Jesus a-wena burrwa, “Ya? An-nga nula Christ abu-ngurrjinga aburr-workiya rrapa gun-narda aburr-weya Wangarr ana-jerrma barra an-gujarlapa an-guga an-gata nipa Daybit (David) murna a-wuna? ");
INSERT INTO bvr_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Wurra jarra nipa Daybit a-wena mu-gatiya mu-jurra mu-guyinda minypa manakay aburr-wukurrjinga, minypa nipa a-yinagata, ‘Wangarr a-wena nula an-ngayburrpa Bunggawa, a-yinagata nula, “Burdak ngunyuna raka ngu-munganaguwa ");
INSERT INTO bvr_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nuwurra aburr-gata aburr-bachirra nggula ngaypa ay-gaba nguburr-nega barra nginyipa mu-ngoyurra ny-ji barra burrwa.’” ");
INSERT INTO bvr_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ganapiya, wurra minypa Daybit a-yinagata a-wena a-workiyana rrapa bunggawa a-negarra Christ, gun-narda minypa nipiya Christ wana, jarra Daybit nyanma ngika.” ");
INSERT INTO bvr_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Gatiya wurra gama gorlk aburr-galiyana aburr-ni nula Jesus nipa a-wena burrwa aburr-yigipa jawina yerrcha, a-yinanga burrwa, ");
INSERT INTO bvr_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Buburr-jarlapiya nula gun-nerra gun-gata minypa aburr-gata joborr marn․gi aburr-gunega gubi-rrimanga, aburr-gatiya minypa wana aburr-negiya aburr-workiya. Gun-birripa jal mirikal mun-baykardakarda aburr-barrngumiya aburr-workiya rrapa gu-gandin aburr-boya burrwa aburr-workiya, wurra gama gorlk aburr-nyala barra burrbi-na rrapa burrbu-burrmaymba. Rrapa barrwa gun-birripa jal aburr-boya aburr-workiya, mu-ngoyurra aburr-rakaja, minypa wupa gu-bala Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya, rrapa minypa yina gun-gaya janara gu-jirra gu-workiya. ");
INSERT INTO bvr_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Wurra jarra birripa aburr-gurda burrbu-yolkaja aburr-workiya aburr-gata miliyak yerrcha rrapa minypa burrbu-gaypurda aburr-workiya gun-birripa bala. Minyjiya. Lika aburr-garlmiyapa Wangarr abu-wengganacha aburr-workiya gun-baykardakarda minypa barra aburr-werranga burrbi-na rrapa gubu-borrwa, jimarna jarrapa bama aburr-yinda aburr-molamola. Wurra nuwurra jurdach birripa aburr-gurda mari wana gubu-ma barra minypa birripa waykin aburr-molamola rrapa wupa aburr-werra.” ");
INSERT INTO bvr_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Gu-gata wenga Jesus a-ganana, burr-nana gu-galiya yerrcha aburr-gata mun-jaranga rrupiya mbi-rrimanga, birripa minypa aburr-bona gurda aburr-ji Wangarr gun-nika gun-japurra rrawa, rrapa minypa rrupiya mbi-barnjinga aburr-bona wurra gama gorlk Wangarr mun-nika abu-wuna aburr-workiyana gatiya. ");
INSERT INTO bvr_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Rrapa barrwa jinyu-nana jin-ngardapa jin-miliyak rrupiya jin-nyagara nipa jina-bona, mun-delipa m-barnjinga rrupiya minypa mun-mama abirri-jirrapa burr-guya mun-delipa. ");
INSERT INTO bvr_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Lika Jesus a-yinanga burrwa aburr-yigipa jawina, “A-lay, gun-guna ngu-weya ana-gorrburrwa gun-burral: Jin-gaba jin-miliyak marrban rrupiya jin-nyagara, wurra nipa jarra m-barnjinga minypa wana, ");
INSERT INTO bvr_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","wurra aburr-werranga aburr-jaranga mbi-barnjinga marr mu-yinanga. Minypa birripa mun-nerranga mbi-ganyja aburr-jekarra rrawa, wurra jin-gata m-barnjingapa mu-wulebana rrapa gala mun-nga rraka mu-ga, balaja burr-guta mu-ma; wurra jin-nyagara.” ");
INSERT INTO bvr_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Aburr-werranga Jesus burr-yika jawina aburr-wengganachichiyana aburr-ni gun-gata nula gun-japurra rrawa Wangarr gun-nika. Minypa birripa gubi-nana burr-guya gun-molamola minypa gubu-gupuna jandarra gun-molamola, rrapa minypa barrwa gun-molamola gubi-negarra minypa gun-nga burr-guta gun-molamola gun-guyinda abu-wuna aburr-workiyana Wangarr. Wurra Jesus a-wena, ");
INSERT INTO bvr_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Gun-nardiya ana-goyburrpa nyibi-nacha nyiburr-nirra, gun-gata guna-bamburda gala gu-yinmiya gu-ji gun-gata bala rrapa jandarra, wurra gu-jel gu-yu barra gu-ni ngardapa ngardapa.” ");
INSERT INTO bvr_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Lika birripa abu-wengganana, “Bunggawa, a-lay, gun-narda nginyipa ny-yena, nipa gu-yinpa barra? Rrapa gun-ngiya ngayburrpa mu-ngoyurra nyibi-na barra marn․gi nyiburr-ni ngardawa yi-gurrepa gu-jirra gu-boya?” ");
INSERT INTO bvr_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Lika Jesus a-wena burrwa, “Buburr-jarlapiya. Gala yapa ana-werranga nyirr-yolkajin rrapa ana-goyburrpa nyiburr-lijiwarriyan. Wurra aburr-jaranga aburr-bengga barra rrapa ngaypa ngu-welangga ngunabu-ma barra minypa aburr-ngunyangunyjiya barra, aburr-yinda, ‘Ngaypa ng-gunaga Christ!’ rrapa ‘Gun-guniya gugu gun-balmapa!’ Wurra gala barra nyirrbu-jurrjurrma aburr-gata; wurra aburr-guyolkiya. ");
INSERT INTO bvr_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ana-goyburrpa nyiburr-galiya barra minypa an-dakal a-ni barra, rrapa minypa gu-galiya yerrcha gu-ngardapa aburr-negiya barra aburr-bacha barra nula bunggawa an-guyinda. Wurra gala barra nyiburr-gurkuja. Wurra gu-yirdiya barra gu-ni, wurra gala barra burdak gu-wulebiyapa.” ");
INSERT INTO bvr_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesus mu-nguy a-wena, a-yinagata, “Gu-werranga gu-rrawa wenga aburr-garlma barra gurda aburr-workiya minypa aburr-bachirramiya burrwa mola gu-werranga gu-rrawa. Rrapa minypa bunggawa a-nirra gun-jaranga rrawa nipa ana-garlma barra ana-workiya, mari gu-garra barra nula an-nerranga bunggawa gu-werranga gu-rrawa. ");
INSERT INTO bvr_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Rrapa gu-werranga gu-werranga rrawa gu-ngorrkiya barra rrapa gun-nerranga gu-rrumiya barra. Rrapa gun-jaranga rrawa balaja mu-wulebiya barra rrapa gun-gujuwa gu-yu barra burrwa. Rrapa gu-galiya yerrcha gubi-na barra belabebaga gun-gunega gun-gaba waykin, minypa gu-gurda ngacha burr-gurdagurdarra barra gu-yinmiya barra gu-bamba. ");
INSERT INTO bvr_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Gu-yirda barra gun-nerra gu-ni barra, wurra burdak mu-ngoyurra aburr-werranga nyirrbi-rrima barra ana-goyburrpa rrapa werra nyirrbu-bu barra. Minypa nyirrbu-ga barra gata barra nyirrbu-barnja gu-bala Ju yerrcha gun-burriya marn․gi aburr-negiya aburr-workiya, gatiya minypa birripa wana yerrcha aburr-yinmiya barra aburr-wengga. Rrapa minypa brichina nyirrbu-barnja barra, rrapa minypa nyirrbu-ga barra nyirrbu-barnja gapman an-guyinda bunggawa a-nirra. Gu-guyinarda ngacha gu-ni barra ana-gorrburrwa ngardawa ngaypa ngu-marr, minypa ana-goyburrpa nyiburr-ngaypa jawina; ");
INSERT INTO bvr_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","wurra jarra gun-gatiya gugu ana-goyburrpa barra ngaypa ngunabu-ngurrja barra burrwa. ");
INSERT INTO bvr_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Bubu-borrwa buburr-ni minypa gun-gata guna-bamburda birripa barra aburr-galiya ana-gorrburrwa rrapa aburr-yinmiya barra aburr-wengga, wurra ana-goyburrpa gala nyiburr-yinmiya mu-ngoyurra wargugu nyiburr-ni gun-nga nyiburr-wengga. Wurra gun-nyagara. ");
INSERT INTO bvr_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ngardawa ngaypa ng-gatiya wugupa ana-gorrburrwa gun-burrderta wengga arr-wu barra, rraka aburr-gata aburr-mari ana-gorrburrwa gala aburr-yinmiya mu-nguy wengga gubu-ngukurdanyja ana-gorrburrwa; jarra aburr-jurnja barra. ");
INSERT INTO bvr_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Aburr-goyburrpa nyanyapa nggu, mampa nggu, worlapa nggu rrapa jawina yerrcha rrapa aburr-werranga burr-guta aburr-borrmunga ana-gorrburrwa, aburr-gurdiya aburr-nyala barra nyirrbi-rrima, nyirrbu-ga barra nyirrbu-barnja ana-werranga a-yinmiya barra a-wengga, rrapa nyiburr-werranga nyiburr-juwa barra. ");
INSERT INTO bvr_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Minypa aburr-jaranga gu-galiya yerrcha aburr-bachirramiya barra ana-gorrburrwa aburr-workiya ngardawa minypa ana-goyburrpa nyiburr-ngaypa. ");
INSERT INTO bvr_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Wurra gala ny-yinmiya nginyipa ny-murna mu-lijiwarriya nggula, muy-mungbiyapa. ");
INSERT INTO bvr_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Wurra jarra gun-gata minypa ana-goyburrpa mu-nguy nyiburr-jinyjarrapa ana-goyburrpa minypa wanngu nyiburr-negiya barra. ");
INSERT INTO bvr_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Wurra nuwurra waypa barra ana-goyburrpa nyibi-na an-dakal a-ji barra a-gomarriya Jirúchalam (Jerusalem), ana-goyburrpa marn․gi nyiburr-ni barra gun-gata minypa yi-gurrepa gu-jirra gu-boya gun-nardiya barra gubu-rruma barra. ");
INSERT INTO bvr_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Rrapa gun-gata wana gun-bapala rrawa Judíya (Judea), birripa barra warrika gubu-bawa gun-birripa rrawa, wurra aburr-yurtcha barra mu-mirk mu-ngarnama. Rrapa aburr-gata gu-murnangana rrawa aburr-nirra, birripa warrika gubu-bawa barra. Rrapa aburr-gata gu-mugarla aburr-nirra gala barra aburr-boy gurda gu-murnangana rrawa. ");
INSERT INTO bvr_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ngardawa gun-gatiya gugu Wangarr burr-bu barra Jirúchalam aburr-nirra minypa janguny gu-yinagata gu-yurra gun-burral. ");
INSERT INTO bvr_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Gun-gatiya barra burr-guya gun-nerra gu-ni barra achila jin-morichiringa jin-guyinda rrapa ngamangama gu-jarlapurda jinyu-nirra delipa gun-nika. Ngardawa rrawa burr-guya wargugu gu-ni barra minypa Wangarr burr-bu barra. ");
INSERT INTO bvr_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Minypa aburr-werranga aburr-juwa barra. Minypa barrang ana-guyinda burrbu-bu barra, rrapa aburr-werranga burrbi-rrima barra, burrbu-ga barra brichina gu-werranga gu-werranga rrawa. Rrapa minypa Jentayl (Gentile) yerrcha, birripa barra gun-guna rrawa Jirúchalam gubu-jurrparrenyja barra aburr-ni nuwurra waypa barra gu-yinpa gu-wulebiya burrwa. ");
INSERT INTO bvr_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Gu-galiya yerrcha gubi-na barra minypa marnnga rrapa gata jiny-nyukurdanyjiya barra, rrapa ran․gu a-ngukurdanyjiya barra, rrapa gu-werranga gu-werranga gu-rrawa burr-guya wargugu aburr-ni barra minypa gu-bachirra bartpa wana gu-wulja barra gu-ji rrapa gala marn․gi aburr-yinmiya barra. ");
INSERT INTO bvr_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Minypa murna aburr-dericha barra minypa aburr-gurkuja barra gu-yinmiya barra gu-ni gun-nardiya rrawa, ngardawa wana aburr-bapala aburr-guyinda aburr-gaba waykin nipa Wangarr burr-ngorrka barra. ");
INSERT INTO bvr_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Lika wurra gama gorlk abi-na barra an-guna An-walkurpa An-gugaliya gu-nguparr ana-bupiya barra ana-bamba burr-barlmarrk rrapa burr-gujayanaya. ");
INSERT INTO bvr_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wurra nginyipa waypa barra nyi-na gu-gata ngacha gu-garlmapa barra, wurra garlma, jinyja rrapa waykin gana. Ngardawa gun-gatiya yi-gurrepa guna-boya Wangarr barra gu-mungba gun-gata minypa nipa wanngu biy-nenga a-nirra.” ");
INSERT INTO bvr_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Lika Jesus a-wena burrwa gun-maywapa ranginy minypa a-yinagata, “Bubu-borrwa gun-jong gun-guyinda minypa mun-gubocha, wombajarr, barrwa mun-nerranga mun-nga. ");
INSERT INTO bvr_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Minypa ana-goyburrpa nyibi-nacha nyiburr-workiya mun-jawanyja m-burnda niya, lika marn․gi nyiburr-nirra nyiburr-workiya gun-gata jemberr yi-gurrepa. ");
INSERT INTO bvr_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Gun-narda minypa gun-maywapa minypa gun-guna gun-burral: Ana-goyburrpa nyibi-na barra gu-yirda barra gu-ni minypa geka ngaypa ngu-wena ana-gorrburrwa, rrapa marn․gi nyiburr-ni barra minypa yi-gurrepa gu-jirra gu-boya ngaypa bunggawa ngu-ni barra minypa Wangarr nguna-gurrmurra. ");
INSERT INTO bvr_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Gun-guna ngu-weya ana-gorrburrwa gun-burral: Nyiburr-gurdiya ngacha gu-galiya yerrcha, nyiburr-werranga gala barra mu-ngoyurra nyiburr-juwa. Ngika. Wurra gun-gata ngaypa ngu-wena ana-gorrburrwa, gun-bulapalawa gun-gata ni-gugu gu-yirda barra gu-ni. ");
INSERT INTO bvr_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Minyjiya. Gun-guna rrawa gu-garlmapa barra gun-nyagara gu-ni barra, wurra gun-ngaypa wengga gu-jinyjapa barra gu-workiya. ");
INSERT INTO bvr_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Jarlapiya; gala yapa ny-jerna nyi-ningin minypa m-balaja mun-jaranga ny-banga ny-yorkiya rrapa mu-nganicha n-dongga ny-yorkiya rrapa gu-gurda gu-yika gu-rrawa ny-borrwuja ny-yorkiya. Wurra gun-gata guna-bamburda gala yapa gu-benggin, nginyipa gala nawanawa nyi-nirrarna. Minypa gun-maywapa ranginy an-gata an-gujechiya jichicha a-gartchinga a-workiya: Minypa jichicha ana-boya ana-workiya, nipa gala marn․gi ay-yinda a-bamburda, wurra a-gartchingapa a-juwiya. ");
INSERT INTO bvr_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ngardawa gun-gata mari gu-benggapa barra burrwa warrpam wurra gama gorlk gun-nardiya rrawa gu-jirra gu-boya. ");
INSERT INTO bvr_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Wurra gana ni mu-nguy rrapa wenggana Wangarr barra minypa nipa derta biy-nega, nginyipa nyi-lijiwarriya nula gu-gata ngacha mari guna-bamburda, rrapa minypa ny-jinyja barra ny-molamola nula an-guna An-walkurpa An-gugaliya gatiya nipa a-ninyarra.” Jesus a-yinagata gu-ngurrjinga burrwa aburr-yigipa jawina. ");
INSERT INTO bvr_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Rrapa gun-gatiya rrengarrenga gu-ni gu-workiyana, Jesus marn․gi burr-negarra a-ni a-workiyana janguny wurra gama gorlk gatiya gu-japurra rrawa. Rrapa balngga gu-ni gu-workiyana nipa gu-bawuna gun-gata rrawa, a-bona, gata a-ni mu-mirk mun-nelangga Alip (Olive) Mu-jirrapa. ");
INSERT INTO bvr_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Rrapa ngulamgaba wurra gama gorlk aburr-bona gurda aburr-workiyana Wangarr gun-nika gun-japurra rrawa barra janguny aburr-galiya nula aburr-ni minypa Jesus gu-ngurrjinga. ");
INSERT INTO bvr_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Gun-gatiya yi-gurrepa janara gu-ji burrwa gu-bona Ju yerrcha, minypa wolawola damba mun-gun․gun mbi-barra aburr-workiyana rrapa jip (sheep) an-geka an-nurra abu-buna, abu-barra, rrapa minypa gubu-borrwurra wola waykin an-guyinda an-mujaruk burr-burndarna, wurra jarra burr-beybana. Gu-gurda ngacha janara yi-gurrepa gu-ji burrwa gu-bona, ");
INSERT INTO bvr_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","rrapa aburr-gata wana junggay yerrcha rrapa joborr marn․gi aburr-gunega birripa gala aburr-yinmiyarna abi-rrimangarna Jesus, ngardawa aburr-gurkuja burrwa wurra gama gorlk aburr-bona gurda gu-janara gu-bama. Wurra wengga gubu-buna aburr-ni barra Jesus ngardapa abi-rrima, abu-bu, a-juwa. ");
INSERT INTO bvr_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Rrapa walkwalk an-gata Jeytan (Satan) an-nelangga, nipa ana-bona, a-barrngumurra ana-ngurrnga Jurrach Yichkériyat (Judas Iscariot) an-gata minypa Jesus burr-yika 12 gu-galiya yerrcha nipa an-nardiya an-ngardapa. ");
INSERT INTO bvr_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Lika nipa Jurrach a-garlmuna, a-bona burrwa aburr-gata wana junggay yerrcha rrapa barrwa aburr-gata burrbu-ganyja aburr-workiya an-dakal an-guyinda jaga a-ganaja a-workiya Wangarr gun-nika gun-japurra rrawa. Lika a-wena burrwa minypa nipa burr-wu barra Jesus barra abi-rrima. ");
INSERT INTO bvr_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Gun-narda waypa birripa aburr-galiyana nipa a-wena, lika aburr-marrkapchinga nula rrapa gochila abi-rrana rrupiya barra abu-wu. ");
INSERT INTO bvr_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Lika Jurrach gu-yagurrmurra burrwa, lika a-garlmunapa gu-borrwurra a-ni a-yinmiya barra minypa yina gaya barra Jesus ngardapa abi-rrima, gala gu-galiya yerrcha burrbi-na. ");
INSERT INTO bvr_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Gun-gata janara gu-ji minypa damba mun-gun․gun mbi-barra aburr-workiyana, gatiya gugu gun-balmapa gu-ji minypa an-geka jip abu-bu barra abu-bay. ");
INSERT INTO bvr_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Lika Jesus bijirri-jerrmarra Birta (Peter) rrapa Jon, a-yinagata butula, “Birri-boy, nawanawa birri-ni mun-mujanara balaja rrapa an-mujanara jip barra ngubu-bay nguburr-ni.” ");
INSERT INTO bvr_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bitipa abirri-yinagata, “Nginyipa jal nyi-nirra yina gaya barra ngatipa nawanawa nyirri-ni arrburrwa?” ");
INSERT INTO bvr_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","“Ngika. Wurra birri-bamba, nyirri-bengga barra gu-murnangana rrawa, lika an-ngardapa an-gugaliya gatiya barra galamurrpa nyibu-garra nipa bugula a-bamiya a-bamburda duram ana-guyinda; lika ana-gotipa nyirri-jurrjurrma barra nipa an-gata. Lika nyiburr-jarl barra nyiburr-bamba, a-barrnguma. ");
INSERT INTO bvr_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Lika ana-gotipa nyirri-wenggana barra an-gata bala an-gurrimapa, nyirri-yinda barra nula, ‘A-lay, an-gaba Bunggawa a-wena, a-yinagata, “Yina gun-gaya gun-ngaypa gun-ngarnama barra ngaypa rrapa aburr-ngaypa jawina wugupa nyibu-bay nyiburr-ni rrapa nyibu-borrwa wola arr-beybana?’” ");
INSERT INTO bvr_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Lika nipa nyjirri-guybuka barra gun-ngarnama waykin gu-jirra gipa mu-ngoyurra gu-jarlapuna, belabila gun-nga burr-guta gu-jirra gu-boya barra ana-gotipa nawanawa nyirri-ni.” ");
INSERT INTO bvr_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jesus a-yinagata a-wena butula, lika abirri-bona, lika gubirri-barripuna minypa nipa a-wena. Lika nawanawa abirri-ni mun-gata mun-mujanara balaja. ");
INSERT INTO bvr_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nuwurra waypa gun-balmapa gu-ji, Jesus a-rakaja gatiya balaja mu-jinyjapa, rrapa aburr-yigipa jawina gatiya wugupa nula. ");
INSERT INTO bvr_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Lika nipa a-yinanga burrwa, “Ngaypa burr-guya jal ngu-ni ngayurra-gugu wugupa ngubu-bay mun-guna gu-guna gu-janara nuwurra jurdach ngaypa ngu-juwa. ");
INSERT INTO bvr_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ngardawa gun-guna ngaypa ngu-weya ana-gorrburrwa gun-burral: Ngaypa gala barra mola ngu-bay mun-guna gu-guna gu-janara nuwurra waypa gun-burral gu-bengga barra minypa ngaypa bunggawa ngu-ni barra, Wangarr nguna-gurrmurra.” ");
INSERT INTO bvr_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jesus a-yinagata a-wena, lika mernda a-jirra a-menga minypa burr-girra gurnal, lika a-japurramayana nula Wangarr. Lika a-yinagata burrwa aburr-yigipa jawina, “Mun-guna bubu-ma, buburr-wuchichiya bubu-bay. ");
INSERT INTO bvr_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ngardawa gun-guna ngaypa ngu-weya ana-gorrburrwa gun-burral: Gun-guniya gugu ngaypa gala barra mola ngu-bay mun-guna gurnal mun-girra nuwurra waypa ngaypa bunggawa ngu-ni barra, Wangarr nguna-gurrmurra.” A-yinagata a-wena. ");
INSERT INTO bvr_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Lika mu-menga damba, a-japurramayana nula Wangarr, lika mu-rrumurra, burr-wuna a-bona minypa a-yinagata burrwa, “Mun-guna ngaypa ngu-burral minypa ngaypa ngu-juwa barra ana-goyburrpa nyiburr-marr. Nyiburr-yinda barra nyibu-bay nyiburr-workiya minypa ngaypa ngunabu-borrwa barra.” ");
INSERT INTO bvr_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Rrapa mernda a-jirra minypa burr-girra gurnal Jesus a-yinagata burr-wuna. Minypa birripa waypa balaja mbi-barra, nipa a-menga, lika a-yinanga burrwa, “An-guna mernda a-jirra an-maywapa minypa gun-burral gun-geka rum mu-ngaypa ngu-maningan gun-burral gu-nenga mu-nirra, minypa ngaypa ngu-jortcha barra ana-gorrburrwa. ");
INSERT INTO bvr_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Wurra bubi-na, an-ngardapa an-guna wugupa ngubu-banga nguburr-nirra nipa a-garlma barra aburr-gata aburr-bachirra murna burr-wu barra ngaypa, birripa ngunabu-bu barra. ");
INSERT INTO bvr_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Minyjiya. An-guna An-walkurpa An-gugaliya nipa a-juwa barra minypa Wangarr gu-borrwurra nula, wurra ana-gugaliya an-gata minypa nguna-bawuna rrapa murna burr-wuna ngaypa aburr-gata aburr-bachirra, nipa jarra an-gata an-gugaliya gun-nerra warrpam gu-ni barra nula.” ");
INSERT INTO bvr_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jesus a-yinagata a-wena burrwa, lika birripa aburr-garlmunapa aburr-wengganachichiyana aburr-ni, “Ana-ngay? Ana-ngay? Ana-nga, a-lay?” ");
INSERT INTO bvr_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Gu-gata wenga lika Jesus burr-yika 12 gu-galiya yerrcha aburr-gata ngarndarrk ngarndarrk aburr-negiyana aburr-ni, minypa birripa ana-nga an-ngardapa barra gubu-borrwa nula minypa nipa wana an-bapala. ");
INSERT INTO bvr_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Wurra Jesus a-wena burrwa, “Bunggawa an-guyinda gu-guna a-yika gu-rrawa, birripa wana aburr-negiya burrwa aburr-workiya aburr-yigipa gu-galiya yerrcha, rrapa jal aburr-nirra birripa barra burrbu-ngurrja jimarna aburr-mola. ");
INSERT INTO bvr_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Wurra ana-goyburrpa gala barra nyiburr-yirda. Wurra ny-yinga ny-jata wana ny-bapala, nginyipa barra delipa nyi-negiya burrwa. Rrapa minypa ny-yinga ny-jata mu-ngoyurra ny-jirra burrwa, nginyipa barra nyi-mujama nyi-ni barra burrwa. ");
INSERT INTO bvr_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Minyja bubu-borrwa: Ana-nga wana an-bapala? Waygaji an-gata minypa a-rakaja a-workiya rrapa balaja m-banga, wurra waygaji an-gata jama a-jirra nula rrapa balaja m-barnjinga a-workiya, ya? Wurra an-gata a-rakaja a-workiya, nipa wana. Wurra jarra ngaypiya ana-gorrburrwa minypa ngu-mujama. ");
INSERT INTO bvr_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ana-goyburrpa nyiburr-gurdiya nyiburr-ni apula nyiburr-workiyana minypa mari gu-ji apula gu-workiyana, ");
INSERT INTO bvr_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ngaypa arr-gurrma barra bunggawa nyiburr-ni barra, minypa gun-maywapa Ngun-anya nguna-gurrmurra, bunggawa ngu-ni barra. ");
INSERT INTO bvr_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Minypa nuwurra waypa barra Bunggawa ngu-ni, ana-goyburrpa barra gatiya wugupa apula gu-ngardapa nguburr-raka barra balaja ngubu-bay wugupa. Rrapa ana-goyburrpa ngardapa ngardapa nyiburr-ni barra bunggawa an-guyinda gun-nika gun-gurrenyja gun-guni, rrapa aburr-gata minypa Yichrayal (Israel) aburr-bapurr arr-jirrapa arr-murna rrapa abirri-jirrapa, minypa 12, birripa barra gatiya aburr-ji ana-goyburrpa nyiburr-yinmiya barra nyiburr-wengga. ");
INSERT INTO bvr_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Jayman (Simon), a-lay, galiya apula. Walkwalk an-gata Jeytan (Satan), nipa gipa a-ngiwija nula Wangarr minypa barra nyirr-ngorrkornda ana-goyburrpa. ");
INSERT INTO bvr_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Wurra, a-lay, ngaypa jarra ngu-wengganana nggula, gala yapa ny-bawa gun-gata minypa marr ny-balcharra apula. Rrapa ny-jurda nginyipa Birta (Peter), nuwurra waypa nyina-jeka apula, nginyipa barra derta burr-nega aburr-guna aburr-nginyipa worlapa nggu yerrcha.” ");
INSERT INTO bvr_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nipa Birta a-yinagata, “A-lay, Bunggawa, ngaypa ng-guna nawanawa ngu-ni gugu barra wugupa arr-barrnguma rrapa arr-juwa!” ");
INSERT INTO bvr_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Wurra Jesus a-yinagata, “Birta, a-lay, ngaypa jarra marn․gi: Geka barra ana-munya gala barra bawul (fowl) ni-gugu jiny-yengga, wurra jarra nginyi-gugu ny-jirrapa ny-nyardapa ny-joma ny-jordajiya burrwa jimarna gala marn․gi apula, rrapa nipa nuwurra jurdach bawul jiny-yengga barra.” ");
INSERT INTO bvr_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Gu-gata wenga Jesus burr-wengganana aburr-yigipa jawina, a-yinagata burrwa, “Gun-gata ngaypa arr-jerrmarra, nyiburr-bamuna rrupiya rrapa gorlk nyiburr-nyagara, wurra gun-nerranga jal nyiburr-ni, ya?” Birripa aburr-yinagata, “Gun-nyagara.” ");
INSERT INTO bvr_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Lika nipa a-wena burrwa, “Minyjiya. Wurra gun-guniya gugu ny-yinga ny-jata rrupiya rrapa gorlk n-dimanga, ny-ja barra. Rrapa ny-yinga ny-jata gala barrang n-dima, wurra mun-nginyipa molma mun-gunegiya mirikal ny-barnja barra minypa barrang ny-ma barra. ");
INSERT INTO bvr_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ngardawa ngaypa marn․gi gun-gata janguny gu-yurra nguna-ngurrjinga ngaypa, minypa gu-yinaga, ‘Burrbu-mulpuna nipa rrapa aburr-gata aburr-werra joborr gubu-rrumunga aburr-workiya.’ Rrapa gun-gata janguny gun-burral gu-ni barra minypa birripa aburr-yirda barra apula.” ");
INSERT INTO bvr_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Aburr-yigipa jawina aburr-yinagata, “Bunggawa, na an-guna, ngayburrpa nyibi-rrimanga abirri-jirrapa barrang!” Nipa a-yinagata, “Ganapiya.” ");
INSERT INTO bvr_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesus gu-bawuna gun-gata rrawa, lika yi-gata a-bona minypa wolawola a-bona a-workiyana mun-mirk mun-nelangga Alip (Olive) Mu-jirrapa. Rrapa aburr-yigipa jawina abu-jurrjurrmurra. ");
INSERT INTO bvr_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Lika gata waypa aburr-bena, Jesus a-wena burrwa, “Bubu-wenggana Wangarr barra nipa a-gunggaja ana-gorrburrwa rrapa gala nyiburr-yinmiya nyiburr-lijiwarriya.” ");
INSERT INTO bvr_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Lika ay-garlmuna gun-baykarda ngika, lika ana-menama gu-rrana, lika a-wengganana, a-yinanga, ");
INSERT INTO bvr_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Anya, minyja nginyipa gun-nga ny-borrwuja, gun-guna mari ma, yerrnyja apula. Wurra minyja gun-nga nginyipa jal nyi-nirra ny-yinmiya apula, wurra ngaypa gala gun-nga barrwa jal ngu-ni.” Jesus a-yinagata a-wengganana a-ni. ");
INSERT INTO bvr_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Rrapa an-ngardapa waykin an-guyinda an-mujaruk ana-bupiyana, a-bena nula rrapa derta a-negarra. ");
INSERT INTO bvr_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Lika nipa Jesus mola burr-guya a-wengganana Wangarr minypa nipa burr-guya wargugu a-ni. Lika gatiya gugu a-ngurrundabiyana burr-guya minypa maningan mu-jortchinga mu-workiya. ");
INSERT INTO bvr_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Gun-gatiya waypa a-wengganana rrapa gu-mungbuna, lika a-garlmuna, ana-jekarra, burr-nana aburr-yigipa jawina aburr-yu ngardawa minypa wargugu aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Lika nipa a-wena burrwa, “An-nga nula nyiburr-yurra? Wurra buburr-garlma, bubu-wenggana Wangarr barra nipa a-gunggaja ana-gorrburrwa rrapa gala nyiburr-yinmiya nyiburr-lijiwarriya.” ");
INSERT INTO bvr_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Gun-gatiya waypa Jesus a-wena a-ji, aburr-jaranga gu-galiya yerrcha aburr-bena burrwa, Jurrach (Judas) an-gatiya an-ngardapa Jesus an-nika jawina nipa gatiya burr-gurdagurdarrana ana-jarl. Minypa nipa jechinuwa ana-bamunapa a-bena nula Jesus, lika a-machinga. ");
INSERT INTO bvr_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Wurra Jesus a-wena, “Jurrach, gu-gurdiya ngacha nguna-machinga, ny-yirdiya barra burr-wu an-guna An-walkurpa An-gugaliya abi-rrima barra, ya?” ");
INSERT INTO bvr_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wurra aburr-yigipa jawina aburr-gata wugupa nula, birripa gubi-nana gu-yinmiya barra gu-ni, lika aburr-yinagata nula, “Bunggawa, ngayburrpa barra nyirrbu-bu, ya, ana-guna barrang ana-guyinda?” ");
INSERT INTO bvr_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Lika an-ngardapa jawina a-garlmunapa a-jarrchinga an-munganaguwa gelama a-jirra an-gata junggay wana an-babalapa an-nika an-mujama. ");
INSERT INTO bvr_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Wurra Jesus a-yinagata, “Bawa!” Lika gelama a-jirra a-rrimarrapa wanngu a-negarra. ");
INSERT INTO bvr_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Lika aburr-gata wana junggay yerrcha rrapa mola bunggawa an-guyinda jaga aburr-ganaja gun-japurra rrawa rrapa aburr-werranga aburr-gata mu-murna yerrcha abi-rrimarrapa, nipa Jesus a-garlmunapa a-wena burrwa, “Nyiburr-gurda, an-nga nula burr-barrang burr-jong burr-guta nyiburr-bona gurda? Wurra bama nyiburr-yinanga jimarna ngaypa ngu-bachirra, ya? ");
INSERT INTO bvr_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Wurra ngaypa ngu-jaranga ng-goma ng-gatiya wugupa ana-gorrburrwa gu-japurra rrawa nguburr-nirra nguburr-rrigirrgnga, wurra ana-goyburrpa gala ngunabi-rrima. Wurra ganapiya, gun-guniya gugu gu-gubalmapa ana-goyburrpa barra jama nyiburr-ji minypa nyiburr-gurdiya rrapa nipa an-gata walkwalk an-munya an-gurrimapa.” ");
INSERT INTO bvr_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Lika gu-gatiya wenga Jesus abi-rrimarra. Lika abu-ganyja aburr-bamuna, aburr-barrngumurra wupa gu-bala junggay wana an-babalapa gun-nika. Rrapa Birta burr-jurrjurrmurra gurda ana-bamuna marr barrparrwa. ");
INSERT INTO bvr_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Rrapa gatiya yarlanga gu-bol gu-rrirra aburr-werranga aburr-ngarnbuna aburr-ninya, lika Birta ana-bamuna, a-rakaja burrwa. ");
INSERT INTO bvr_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Lika gu-gata wenga jin-ngardapa jin-mujama a-nana Birta gu-bol gu-rrirra a-nayana. Lika galginy jinyu-derichinga a-nana, lika jiny-yena burrwa aburr-gata, “A-lay, an-guna burr-guta an-gata aburr-rrigirrgnga.” ");
INSERT INTO bvr_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Wurra Birta a-jordajiyana, minypa jonama a-gurkuja burrwa, a-yinagata, “A-jay, ngaypa gala marn․gi nula an-gata.” ");
INSERT INTO bvr_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Lika gun-baykarda ngika aburr-ni, lika an-ngardapa a-malawurra, lika a-wena nula, “A-lay, ny-jurda nginyipa burr-guta an-gata jawina nyi-nirra nula!” Wurra Birta a-wena, “Ngaypa ngika nyiburr-gurda ngunabi-nacha nyiburr-bamburda!” ");
INSERT INTO bvr_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mola marr gun-baykarda, lika an-nerranga burr-guya a-wena, “A-lay, an-guniya burr-guta an-gata aburr-rrigirrgnga aburr-workiya! Ngardawa minypa nipa an-guna Galali (Galilee) an-guyinda, ngarla!” ");
INSERT INTO bvr_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Wurra Birta a-yinagata, “A-lay, gun-nga ny-yeya ny-boya?” Wurra gun-narda nipa a-wena a-ji, gugu bawul jiny-yena. ");
INSERT INTO bvr_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Lika Jesus ana-ngukurdanyjiyana, jechinuwa a-nana Birta. Lika Birta gu-borrwurra gun-gata minypa nipa Bunggawa a-wena nula, minypa a-yinagata, “Geka barra ana-munya gala barra bawul ni-gugu jiny-yengga, wurra jarra nginyi-gugu ny-jirrapa ny-nyardapa ny-joma ny-jordajiya burrwa jimarna gala marn․gi apula, rrapa nipa nuwurra jurdach bawul jiny-yengga barra.” ");
INSERT INTO bvr_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Gun-narda Birta gu-borrwurra, lika nipa yarlanga a-bena, lika burr-guya a-rruwujana a-ni. ");
INSERT INTO bvr_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Aburr-gata Jesus abi-rrimarra aburr-ji, birripa aburr-garlmunapa abu-borrkpuna rrapa abu-buna aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Mipila a-jirra abu-bichinga, lika abu-buna rrapa aburr-wena nula, “Marrka ngurrja arrburrwa: Ana-nga biy-buna, ya?” ");
INSERT INTO bvr_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Rrapa mu-nguy aburr-bachirramiyana nula aburr-wena. ");
INSERT INTO bvr_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Gun-gata guna-gepana, lika mu-murna yerrcha gu-ngardapa aburr-negiyana birripa wana junggay yerrcha rrapa joborr marn․gi aburr-gunega burr-guta. Aburr-gurdiya ganychila (councillor) yerrcha, birripa aburr-wena aburr-birripa aburr-mujama abu-ganyja gurda burrwa Jesus. ");
INSERT INTO bvr_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Lika birripa ganychila yerrcha aburr-yinanga aburr-wena nula, “Minyja jimarn jarra nginyipa Christ, yama ny-nyurrjiya arrburrwa, a-lay?” Nipa a-wena, “Minyja ngaypa ngu-wengga ana-gorrburrwa, gala marr nyiburr-balcha apula. ");
INSERT INTO bvr_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Rrapa minyja ngaypa arr-wenggana, ana-goyburrpa gala nyiburr-yinmiya nyiburr-wengga. ");
INSERT INTO bvr_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Wurra gun-nardiya gugu an-guna An-walkurpa An-gugaliya a-ninya barra ana-gera ana-munganaguwa an-gata Wana An-babalapa Wangarr.” ");
INSERT INTO bvr_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Lika birripa warrpam aburr-wena, “Gun-narda nginyipa ny-yena, minypa ny-yalkurpa nula Wangarr biy-yika, ya?” Nipa a-yinagata, “Ana-goyburrpa nyiburr-wena, gun-nardiya.” ");
INSERT INTO bvr_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Birripa aburr-yinagata, “Gala barrwa jal nguburr-ni ana-nga barra a-ngurrja arrburrwa an-guna! Wurra gipa a-ngurrjiyanapa ganapiya.” ");
INSERT INTO bvr_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Lika gu-gata wenga aburr-gata warrpam aburr-garlmuna, Jesus abu-ganyja, abu-wuna Baylat (Pilate) an-gata Rowm (Rome) wenga gapman an-guyinda bunggawa. ");
INSERT INTO bvr_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Lika bima abu-ngurrjinga nula aburr-ni, aburr-yinanga, “An-guna ngayburrpa nyibi-nacha nipa gun-bachirra ngana burr-wucha aburr-ngayburrpa gu-galiya yerrcha. Minypa nipa a-weya burrwa a-workiya jimarna gala barra abu-wu Bunggawa Rowm a-nirra rrupiya dek (tax). Rrapa minypa a-ngurrjiya a-workiya jimarna nipiya Christ nipa Wangarr ana-jerrmarra arrburrwa bunggawa.” ");
INSERT INTO bvr_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Lika Baylat a-garlmuna, a-wengganana, “A-lay, aburr-gaba nginyipa bunggawa burrwa Ju yerrcha, ya?” Nipa Jesus a-yinanga, “Nginyipa ny-yena, gun-nardiya.” ");
INSERT INTO bvr_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Lika Baylat a-wena burrwa wana junggay yerrcha rrapa gu-galiya yerrcha aburr-gata aburr-galiyana aburr-jinyja, a-yinagata burrwa, “An-guna ngaypa ngu-nana nipa gala gun-nerra gu-rrima rraka mari ng-garra nula.” ");
INSERT INTO bvr_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Wurra birripa mu-nguy burr-guya aburr-wena, “Ngika. Wurra an-nardiya nipa minypa gu-yigipa gu-janguny gu-mari ngana burr-wucha a-boya gurdiya rrawa gu-jirra gu-boya Judíya (Judea). Minypa Galali wenga, lika an-guna gugu.” ");
INSERT INTO bvr_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Gun-gata waypa Baylat a-galiyana aburr-wena, lika burr-wengganana minyja Jesus nipa Galali (Galilee) an-guyinda. ");
INSERT INTO bvr_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Lika gun-narda waypa nipa gu-borrwurra minypa an-guna Jesus nipa Galali an-guyinda, lika nipa Baylat a-wena burrwa aburr-yigipa an-dakal, lika birripa abu-ganyja nula Ayrat (Herod), bunggawa an-gata gu-gata a-yika gu-rrawa Galali, ngardawa nipa Ayrat yarta ana-bona Jirúchalam (Jerusalem). ");
INSERT INTO bvr_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Rrapa gun-gatiya waypa Ayrat a-nana Jesus, nipa burr-guya marrnguwa a-ni ngardawa marr gu-ganyja gun-baykarda. Minypa janguny gu-barrjekarra nula a-galiyana a-workiyana, rrapa jal a-ni a-nacharna burr-barlmarrk jama a-jirrarna. ");
INSERT INTO bvr_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Lika a-wengganana Jesus gun-jaranga wengga, wurra Jesus gala nipa a-weyarna nula. ");
INSERT INTO bvr_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Rrapa aburr-gata wana junggay yerrcha rrapa joborr marn․gi aburr-gunega, birripa aburr-jinyja gatiya rrapa burr-guya aburr-wena, bima abu-ngurrjinga aburr-ni Jesus. ");
INSERT INTO bvr_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ganapiya, lika Ayrat rrapa aburr-yigipa an-dakal, birripa an-nerra abi-negarra abu-borrkpuna. Rrapa minypa abu-jolartchinga mirikal mun-gata wolawola bunggawa an-guyinda a-barrngumiya a-workiya, lika Ayrat a-wena burrwa, lika abu-ganyja aburr-jekarra nula Baylat. ");
INSERT INTO bvr_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Bitipa Baylat rrapa Ayrat mu-ngoyurra abirri-bachirramiyana butula abirri-workiyana gu-gapa gu-guta, wurra gun-gatiya gugu abirri-ngukurdanyjiyana, lika abirri-borrmunga abirri-negiyana. ");
INSERT INTO bvr_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Gu-gata wenga Baylat a-gonyjinga burrwa aburr-gata wana yerrcha junggay rrapa Ju yerrcha bunggawa rrapa gu-galiya yerrcha. ");
INSERT INTO bvr_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Lika a-wena burrwa, “Ana-goyburrpa nyibu-ganyja gurda an-guna rrapa nyibu-ngurrjinga jimarna gun-nerra ngana burr-wucha a-workiya wurra gama gorlk, wurra jarra ngaypa ng-galiyana nula, ana-goyburrpa nyiburr-jinyja, wurra ngu-nana gala gun-nerra gu-rrima wuriya gun-gata ana-goyburrpa bima nyibu-ngurrjinga. ");
INSERT INTO bvr_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Rrapa Ayrat, nipa burr-guta a-nana an-guna an-mola, ngardawa ana-gurdanyjinga, gala burr-mari a-weyarna nula. Minyja bubi-na, an-guna gala gun-nga gun-nerra jama a-jirrarna a-workiyarna rraka nipa a-juwa; wurra gun-nyagara. ");
INSERT INTO bvr_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Wurra ngaypa jarra ngu-wengga barra burrwa aburr-ngaypa an-dakal, birripa abu-jurrburaykujama barra, lika ngu-jerrma barra.” ");
INSERT INTO bvr_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Wurra warrpam aburr-gonyjinga, “Bupa an-narda! Wurra nyirr-wu an-gata Barébach (Barabbas)!” ");
INSERT INTO bvr_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Nipa an-gata Barébach wugupa burrwa aburr-gata aburr-werranga gipa mu-ngoyurra aburr-garlmunapa burrbu-buna gapman yerrcha, jimarna barra gubu-ngukurdanyja, wurra nipa gugu gatiya brichina a-ni.) ");
INSERT INTO bvr_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Baylat barrwa a-wena burrwa, ngardawa nipa jal a-ni Jesus a-jerrma barra. ");
INSERT INTO bvr_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Wurra birripa mu-nguy aburr-gonyjinga, “An-narda bupa! Burr-jong negapa rra!” ");
INSERT INTO bvr_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Lika Baylat ana-jirrapa ana-ngardapa ana-goma gu-negarra a-wena burrwa. Minypa a-yinagata, “Wurra an-nga nula? An-guna a-yinmiyana jama a-ji gun-nerra? Wurra ngaypa ngu-nana gala gun-nga gun-nerra gu-rrima rraka a-juwa. Jarra ngu-wengga barra burrwa aburr-ngaypa an-dakal birripa barra abu-jurrburaykujama barra, lika ngaypa ngu-jerrma barra.” ");
INSERT INTO bvr_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Wurra birripa burr-guya aburr-jabarrchinga barra minypa burr-jong a-negapa a-rra. Minypa mu-nguy aburr-yinagata aburr-jabarrchinga nuwurra Baylat gu-yagurrmurra burrwa. ");
INSERT INTO bvr_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","A-yinagata, “Ganapiya, ngardawa gun-goyburrpa jal rrapa wengga.” ");
INSERT INTO bvr_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Lika nipa ana-jerrmarra burrwa an-gata Barébach birripa jal aburr-ni nula, an-gatiya an-gubu an-bachirra nula gapman. Wurra Jesus nula Baylat a-wena burrwa aburr-yigipa an-dakal birripa barra abu-ga, burr-jong abi-negapa abi-rra, ngardawa birripa gu-galiya yerrcha gun-birripa jal. ");
INSERT INTO bvr_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ganapiya, lika Jesus abu-menga, lika aburr-bona. Aburr-bamuna, lika galamurrpa gubu-garrana an-ngardapa an-gata an-gugaliya an-nelangga Jayman (Simon), nipa Jayríny (Cyrene) an-guyinda. Nipa ana-bamuna gu-murnangana rrawa minypa gu-werranga rrawa wenga, wurra birripa abi-rrimarrapa gun-jong Jesus gun-nika murna abu-wuna, lika a-bamiyana a-bamuna jurdach. ");
INSERT INTO bvr_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Aburr-jaranga gu-galiya yerrcha, birripa abu-jurrjurrmurra Jesus, rrapa aburr-werranga mu-gama yerrcha aburr-rruwujana nula aburr-bamuna. Wurra nipa a-ngukurdanyjiyana, lika a-wena burrwa, ");
INSERT INTO bvr_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","“Nyiburr-gurda mu-gama yerrcha Jirúchalam nyiburr-guyinda, ganapa buburr-rruwuja apula. Wurra jarra buburr-rruwuja ana-gorrburrwa ana-goyburrpa rrapa aburr-goyburrpa gu-ngarda yerrcha. ");
INSERT INTO bvr_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ngardawa minypa yi-gurrepa gu-jirra gu-boya ana-goyburrpa Yichrayal nyiburr-bapurr burr-guya gun-nerra gu-ni barra ana-gorrburrwa rrapa minypa ana-goyburrpa nyiburr-wengga barra, nyiburr-yinda, ‘Ya? Mu-gama yerrcha aburr-gata gala delipa abi-rrima, gu-gurda nula birripa jarra aburr-worlworlchinga, aburr-gatiya minypa gala delipa ngamangama abu-wucharna aburr-workiyarna, ngaja, ngarla!’ Nyiburr-yirda barra nyiburr-wengga. ");
INSERT INTO bvr_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Minypa gun-gatiya gugu ngardawa gun-gata mari wana, ‘gu-galiya yerrcha aburr-wengga barra nula mun-mirk mun-guyinda, minypa aburr-yinda barra nula, “Nyin-denyja!”, rrapa aburr-yinda barra nula bulgapulga gun-guyinda, “Nyirr-gonyinyja!” ’ ");
INSERT INTO bvr_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ngardawa minypa gu-galiya yerrcha aburr-yinagatiya apula burr-jong ngunabi-nega barra ngunabi-rra gun-guna gun-jong gun-jurrkurda burdak, wurra nuwurra waypa barra gu-gorlapa birripa burr-guya barra aburr-bachirramiya.” ");
INSERT INTO bvr_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Rrapa abirri-jirrapa gu-galiya yerrcha abirri-gata mu-ngoyurra gun-nerra jama abirri-ji, bitipa burr-guta burrbu-ganyja gu-ngardapa barra burrbu-bu wugupa nula Jesus. ");
INSERT INTO bvr_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Lika gatiya waypa aburr-bena rrawa gun-gata gun-nelangga An-mama Bama A-jirra A-yurrapa, gatiya burr-jong abi-negarra abi-rrana Jesus, lika abu-jarrkarrana, a-balcha a-yu. Rrapa abirri-gata abirri-werra bitipa burr-guta burr-jong burrbu-negarra burrbi-rrana, lika burrbu-jarrkarrana ana-gera Jesus, an-ngardapa ana-munganaguwa rrapa an-nerranga ana-weyka. ");
INSERT INTO bvr_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Lika Jesus a-wena, “Anya, baywarra nega burrwa aburr-guna. Ngardawa birripa gala marn․gi aburr-yinmiya aburr-nirra.” Rrapa aburr-gata an-dakal, birripa mirikal mbi-menga Jesus mun-nika, lika aburr-dawurrjinga aburr-ni mun-nga mun-gata ana-nga mu-ma barra. ");
INSERT INTO bvr_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Rrapa gu-galiya yerrcha gata aburr-wordajarra aburr-jirra, rrapa minypa aburr-birripa mu-ngoyurra aburr-jirra ngoyurra aburr-yerryerrmiyana aburr-ni nula Jesus, minypa waykin aburr-wena, aburr-wengganachichiyana aburr-ni, nipa a-galiyana. Minypa aburr-yinagata, “An-guna wanngu burr-negarra aburr-werranga, ya? Wurra yama wanngu a-negiya an-narda? Minypa nipa a-ngurrjiyana Christ, ngaja, ngarla, an-gatiya Wangarr nyanma An-gujerrjerrjiya.” ");
INSERT INTO bvr_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Rrapa aburr-gata an-dakal, birripa aburr-yinagatiya abu-borrkpuna aburr-ni Jesus. Minypa yi-gurrepa aburr-negiyana nula, aburr-wena nula nipa yama ana-bupiyarna, m-bangarna wayin (wine) mun-guralba mun-gata birripa mbi-rrimarra minypa biniga (vinegar). ");
INSERT INTO bvr_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Aburr-yinagata, “Wanngu negiya nggula minyja nginyipa bunggawa Ju ny-burriya!” ");
INSERT INTO bvr_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Rrapa gatiya m-balcha mu-yu jurra, minypa mu-yinanga, “AN-GUNA BUNGGAWA JU AN-BURRIYA.” ");
INSERT INTO bvr_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Rrapa abirri-gata abirri-werra abirri-balcha abirri-yu, an-ngardapa gun-bachirra a-wena nula Jesus. Minypa a-yinanga nula, “Ny-jurda nginyipa Christ, ya? Wurra yama wanngu nyi-negiya rrapa ngatipa wanngu nyjirri-nega?” ");
INSERT INTO bvr_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Wurra an-gata ana-werranga a-jobujobuna, a-yinanga nula, “A-lay, yama ny-jurkuja nula Wangarr? Ngardawa nginyipa burr-guta mari ny-menga gun-ganawa, ");
INSERT INTO bvr_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","wurpa lika nginyipa ngaypa arr-werra minypa gun-nerra jama arr-ji. Wurra jarra an-guna nipa gala gun-nerra jama a-jirrarna.” ");
INSERT INTO bvr_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Lika a-wena nula Jesus, “A-lay, Jesus, nuwurra waypa barra bunggawa nyina-jeka, nguna-borrwa.” ");
INSERT INTO bvr_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Lika Jesus a-wena nula, “Gun-guna ngaypa ngu-weya nggula gun-burral: Gun-guniya gugu nginyipa barra wugupa apula waykin arr-ninya barra.” ");
INSERT INTO bvr_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Gun-gatiya gugu marnnga waykin jiny-ji minypa gojilapa nguburr-bama jiny-jirra jiny-yorkiya, wurra gun-gata rrawa gu-jirra gu-boya gu-garlmunapa an-munya gu-mayana nuwurra waypa marnnga jiny-jakiyana minypa jarlawurr mula gu-jirra jiny-jinyja, 3 o'clock balngga. ");
INSERT INTO bvr_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ngardawa marnnga an-munya jiny-mayana. Rrapa gata wupa gu-bala Wangarr gun-nika gun-japurra, mun-gata mirikal m-balcha mu-yu mu-yerayeragujamiyanapa abirri-jirrapa gugu. ");
INSERT INTO bvr_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Lika Jesus burr-guya a-gonyjinga, “Anya, ngaypa ngu-mawunga ngiy-wucha ngu-nirra nginyipa ny-murna!” Ganapiya. Gun-narda nipa a-wena, lika a-juwuna. ");
INSERT INTO bvr_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Rrapa an-gata an-dakal a-ganyja a-workiya, gatiya waypa nipa gu-nana gu-yinmiyana, lika nipa a-wena rrapa minypa Wangarr an-nelangga an-molamola a-negarra, a-yinagata, “An-gunaga an-gugaliya gun-burral an-jechinuwa!” ");
INSERT INTO bvr_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Rrapa aburr-gata gu-galiya yerrcha gu-ngardapa aburr-negiyana aburr-wordaja aburr-ji, birripa gubi-nana gu-yinmiyana, lika aburr-buyana aburr-ni mirrka aburr-jirra minypa wargugu aburr-ni aburr-bamuna, rrawa aburr-jekarra. ");
INSERT INTO bvr_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Rrapa Jesus burr-yika aburr-borrmunga aburr-gata minypa marn․gi aburr-ni nula, mu-gama yerrcha burr-guta aburr-gata mu-ngoyurra abu-jurrjurrmurra gurda minypa Galali wenga, birripa balay aburr-ji gurda, gubi-nana aburr-ji gu-yinmiyana. ");
INSERT INTO bvr_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Rrapa an-ngardapa an-gugaliya an-gata an-nelangga Jochap (Joseph), nipa Aramatíya (Arimathea) an-guyinda gun-gata wana gu-bapala gu-rrawa Judíya. Nipa an-molamola an-gugaliya. Minypa jechinuwa a-ni a-workiyana rrapa a-ganana a-ni Wangarr ana-jerrmarrapa gu-yinpa barra bunggawa a-ni. Aburr-gata Ju yerrcha ganychila (councillor) nipa rrapa an-nardiya an-ngardapa, wurra nipa gala gu-yagurrmungarna burrwa gun-gata minypa birripa aburr-yinmiyana nula Jesus. ");
INSERT INTO bvr_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ganapiya, lika nipa a-garlmuna, a-jarl a-bamuna, a-wengganana Baylat an-gata nula Jesus an-burral mu-ngoyurra a-juwuna. ");
INSERT INTO bvr_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Lika gu-gata wenga ana-bona, a-menga, ana-ganyja ana-bupiyana, a-bichinga mirikal mu-guyinda linan (linen) mu-maya mun-gungarlcha; lika a-ganyja, a-gurrmurra wupa gu-ngarnama gu-gurrema gu-guyinda gipa mu-ngoyurra aburr-gapajinga wurra gala ana-nga abu-barnjingarna aburr-workiyarna. ");
INSERT INTO bvr_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Gun-gata minypa balngga gu-ni Braydi (Friday) a-jolartchinga, rrapa marnnga jiy-bungguna jiy-bamuna, gun-gatiya gugu minypa barra Jarradi (Saturday) gu-ni barra. ");
INSERT INTO bvr_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Rrapa aburr-gata mu-gama yerrcha mu-ngoyurra abu-jurrjurrmurra gurda Jesus minypa Galali wenga ay-ngunyuna Jirúchalam, birripa aburr-bona wugupa nula Jochap rrapa gubi-nana gun-gata gun-gurrema minypa aburr-yinmiyana Jesus an-burral abu-gurrmurra wupa gu-ngarnama. ");
INSERT INTO bvr_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Lika aburr-jekarra rrawa. Lika nawanawa aburr-ni mun-gata mun-molamola mun-gungolkuja barra mbi-barnja nula ana-burral. Wurra burdak Jarradi gu-ni, aburr-ngekarra, minypa gun-birripa joborr gu-yinagatiya. ");
INSERT INTO bvr_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jandi (Sunday) gu-ni ana-munyagaba, aburr-gata mu-gama yerrcha aburr-jekarra gurda gu-gurrema Jesus an-burral abu-jolartchingapa. Birripa mbi-ganyja gurda mun-gata mun-molamola mun-gungolkuja minypa mu-ngoyurra nawanawa aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Lika gubi-nana gun-gata gun-gurrema ngana gu-jirra gu-lapkujamiyana gu-ji; mu-ngoyurra gubu-jakabuna jandarra wana gu-bapala gu-guyinda, wurra gu-gakiyana. ");
INSERT INTO bvr_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Lika aburr-barrngumurra, wurra gala abi-nacharna an-burral; wurra gun-nyagara. ");
INSERT INTO bvr_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Rrapa gun-gatiya waypa aburr-jawurrga aburr-wechawecha gu-yinmiyana, warrika abirri-jirrapa gatiya wugupa burrwa abirri-jinyja, mun-gujayanaya abirri-barrngumurra abirri-ji. ");
INSERT INTO bvr_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Lika birripa aburr-gurkuja, aburr-menama gubi-rrana, aburr-mobalurrmiyana bukula aburr-jirra gu-jel. Wurra abirri-gata gu-galiya yerrcha abirri-wena burrwa, “Ngunyuna an-gugaliya nyibu-jurnumburda nyiburr-workiya an-nga nula nyiburr-wechawecharra? Wurra an-guna wanngu a-ni. ");
INSERT INTO bvr_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nipa gala a-ni an-guna, wurra a-molamiyana. Bubu-borrwa gun-gata nipa mu-ngoyurra a-wena, nipa gatiya wugupa ana-gorrburrwa Galali (Galilee) nyiburr-ni. ");
INSERT INTO bvr_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Minypa a-yinagata, ‘An-walkurpa An-gugaliya birripa burrbu-wu barra aburr-gata aburr-werra birripa barra burr-jong abi-nega abi-rra. Rrapa nuwurra waypa barra ngorrngurra abirri-jirrapa gun-ngardapa gu-ni, nipa a-molamiya barra.’” ");
INSERT INTO bvr_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Abirri-yinagata abirri-wena burrwa abirri-gata minypa mun-gujayanaya abirri-barrngumurra abirri-ji, lika birripa mu-gama yerrcha gubu-borrwurra gun-gata Jesus a-yinmiyana a-wena burrwa mu-ngoyurra. ");
INSERT INTO bvr_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Lika gun-gurrema gubu-bawuna, aburr-jekarra aburr-jarl rrawa. Lika gun-gata gu-yinmiyana gu-ni birripa gubu-ngurrjinga burrwa Jesus burr-yika jawina aburr-gata arr-jirrapa arr-murna rrapa an-ngardapa, minypa 11, rrapa aburr-werranga Jesus burr-yika jawina yerrcha burr-guta birripa gubu-ngurrjinga burrwa. ");
INSERT INTO bvr_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Aburr-gata mu-gama yerrcha, minypa Meri Mektaliny rrapa Jowéna, rrapa Meri jin-gata Jeymch (James) mampa niya, rrapa aburr-werranga aburr-gata wugupa burrwa, aburr-gurdiya wupa gubu-ngurrjinga burrwa Jesus burr-yika aburr-mujama. ");
INSERT INTO bvr_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Wurra birripa gala marr aburr-balcharrarna burrwa, jimarn jarra bama aburr-yinanga aburr-guna mu-gama yerrcha burrbu-yolkaja aburr-ni. ");
INSERT INTO bvr_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Wurpa lika Birta a-garlmuna, a-yurtchinga a-ni gu-gurrema gatiya an-burral Jesus abu-gurrmurra. Lika a-gurduwuja, a-jawawiyana a-bona wupa, lika mu-nana mun-gata mirikal linan (linen) mu-maya mun-gungarlcha mun-narda wupa mu-yunya. Lika nipa ana-jawurrga a-wechawecha a-jekarra a-bamuna rrawa minypa gu-yinmiyana gu-ni. ");
INSERT INTO bvr_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Gun-gata gun-maywapa ngorrngurra gu-ni, abirri-jirrapa abirri-gata abirri-werranga Jesus bijirri-yika bitipa abirri-bamuna gu-jarlakarr Améyach (Emmaus) abirri-ngoyurra, gun-gata rrawa marr yi-gurrepa nula Jirúchalam (Jerusalem), minypa arr-jirrapa arr-murna rrapa gun-ngardapa ay-bitima gilámita (kilometre). ");
INSERT INTO bvr_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Rrapa abirri-wengganachichiyana abirri-bamuna minypa gu-yinmiyana gu-ni gun-gata. ");
INSERT INTO bvr_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Abirri-yinagata abirri-bamuna, lika warrika Jesus ana-bamuna, a-malchinga butula, lika wugupa aburr-bamuna. ");
INSERT INTO bvr_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Wurpa Wangarr bijirri-balagonyinyjinga rraka bitipa gala abirri-malawujarna nipiya. ");
INSERT INTO bvr_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Lika nipa bijirri-wengganana, “An-nga nyirri-yopurda nyirri-boya, nyirri-gurda nyirri-bamburda, a-lay?” Wurra abirri-derichinga, abirri-jinyja wargugu. ");
INSERT INTO bvr_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Lika abirri-gata an-ngardapa an-nelangga Gulíyapach (Cleopas) nipa a-yinagata, “A-lay, nginyipa ny-jurda ngardapa Jirúchalam nyi-nirra ny-bomang gala marn․gi gun-guna gu-yinmiyana gu-ni, ya?” ");
INSERT INTO bvr_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Lika nipa a-yinagata butula, “Gun-nga?” Bitipa abirri-yinagata, “Jesus nula, ngarla, an-gata Nejarach (Nazareth) an-guyinda! Nipa Wangarr an-nika an-mujaruk. Minypa Wangarr wugupa nula nipa burr-barlmarrk a-wena a-workiyana rrapa jama a-ji, rrapa wurra gama gorlk abi-nana nipa an-molamola. ");
INSERT INTO bvr_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wurra wana junggay yerrcha rrapa aburr-ngayburrpa ngoyurra aburr-jirra arrburrwa, birripa burrbu-wucha gapman yerrcha barra nipa a-juwa. Lika birripa burr-jong abi-nenga abi-rracha. ");
INSERT INTO bvr_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wurra ngayburrpa nyiburr-yigipa jawina nyibu-borrwurra, jimarna nipa barra wanngu arr-nega ngayburrpa Yichrayal (Israel) nguburr-bapurr minypa rrawa burr-guta. Wurra gun-guniya gugu abirri-jirrapa gun-ngardapa ngorrngurra gu-ni nipa an-gata a-juwiya. ");
INSERT INTO bvr_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Rrapa gun-narda wupa ngika. Wurra ngayburrpa gochila nyiburr-barrjinga ngardawa ana-munyagaba aburr-werranga aburr-ngayburrpa mu-gama yerrcha aburr-bona gun-gata gu-gurrema mu-ngoyurra abu-gurrmunga, ");
INSERT INTO bvr_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","wurra gala abu-barripungarna an-burral. Lika aburr-jekarra gurda arrburrwa, lika gubu-ngurrjinga arrburrwa gun-gata gubi-nana minypa abirri-jirrapa waykin abirri-guyinda abirri-mujaruk abirri-wena burrwa nipa an-gaba wanngu a-ni. ");
INSERT INTO bvr_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Rrapa aburr-gata aburr-werranga ngayburrpa nyanma, birripa aburr-bona gun-gata gu-gurrema minypa mu-ngoyurra abu-gurrmurra, rrapa gubi-nana gun-gata minypa gun-maywapa mu-gama yerrcha aburr-wena, wurra gala a