﻿USE sofia;
DROP TABLE IF EXISTS sofia.bvd_vpl;
CREATE TABLE bvd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bvd_vpl WRITE;
INSERT INTO bvd_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Na isufutaa sulia sa Disas na Kraes nia lea 'urii mai. Nia na waa 'e futa lao kwalafaa sa Defet na waa 'inito bae lao kwalafaa sa 'Abraham. ");
INSERT INTO bvd_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Na isufutaa nee, 'e safali 'ana sa 'Abraham. Sa 'Abraham nia kwalafia sa 'Aesak, sa 'Aesak ka kwalafia sa Diakab, sa Diakab ka kwalafia sa Diuda fai toolana ki. ");
INSERT INTO bvd_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Sa Diuda ka adea ni Tama ka kwalafia sa Beres fai sa Sira. Sa Beres ka kwalafia sa Hesron, sa Hesron ka kwalafia sa Ram. ");
INSERT INTO bvd_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Sa Ram ka kwalafia sa 'Aminadab, sa 'Aminadab ka kwalafia sa Naason, sa Naason ka kwalafia sa Salamon. ");
INSERT INTO bvd_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ma sa Salamon ka adea ni Reehab ka kwalafia sa Boas. Sa Boas ka adea ni Rut ka kwalafia sa 'Obet. Sa 'Obet ka kwalafia sa Deesii. ");
INSERT INTO bvd_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Sa Deesii ka kwalafia guu waa 'inito bae sa Defet. Sa Defet ka adea 'initai sa 'Iuraea 'e mae faasia, ka kwalafia gu sa Solomon. ");
INSERT INTO bvd_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sa Solomon ka kwalafia sa Rihoboam, sa Rihoboam ka kwalafia sa 'Abida, sa 'Abida ka kwalafia sa 'Asa. ");
INSERT INTO bvd_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Sa 'Asa ka kwalafia sa Diosafat, sa Diosafat ka kwalafia sa Dioram, sa Dioram ka kwalafia sa Iusaea. ");
INSERT INTO bvd_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Sa Iusaea ka Kwalafia sa Diotam, sa Diotam ka kwalafia sa 'Ehas, sa 'Ehas ka Kwalafia sa Hesikaea. ");
INSERT INTO bvd_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Sa Hesikaea ka kwalafia sa Manase, sa Manase ka kwalafia sa 'Emon, sa 'Emon ka kwalafia sa Diosaea. ");
INSERT INTO bvd_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Sa Diosaea ka kwalafia sa Diokonaea fai toolana ki. Sa Diokonaea, nia futa sui guu omea 'i Babilon dao ka laua toaa 'Israel ka ngali kera naa uri fera 'i Babilon. ");
INSERT INTO bvd_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","'I burina kera da ngalia toaa 'i 'Israel lea daka too naa 'i Babilon, sa Diokonaea kafi kwalafia sa Sialtiel. Ma sa Sialtiel ka kwalafia sa Serababel. ");
INSERT INTO bvd_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sa Serababel ka kwalafia sa 'Abiud, sa 'Abiud ka kwalafia sa 'Elaeakim, sa 'Elaeakim ka kwalafia sa 'Aso. ");
INSERT INTO bvd_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Sa 'Aso ka kwalafia sa Sadok, sa Sadok ka kwalafia sa 'Akim, sa 'Akim ka kwalafia sa 'Eliud. ");
INSERT INTO bvd_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Sa 'Eliud ka kwalafia sa 'Eliesa, sa 'Eliesa ka kwalafia sa Matan, sa Matan ka kwalafia sa Diakab. ");
INSERT INTO bvd_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Sa Diakab ka kwalafia gu sa Diosef arai ni Meri gaa sa Disas waa ne da 'ailia 'ana Kraes, na waa fifilia nia God. ");
INSERT INTO bvd_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","'Ita 'ana sa 'Abraham lea mai ka dao 'ana sa Defet na waa 'inito bae, nia too 'ana tii taafuli uni wane ma fai uni wane sarenga ki. Ka 'ita 'ana sa Defet waa 'inito nai lea mai ka dao 'ana kada omea 'i Babilon dao ka alasia fera 'i 'Israel ka lau kera uri 'i Babilon, ka too lau guu 'ana tii taafuli uni wane ma fai uni wane sarenga ki. Ma ka 'ita 'i seeri lea mai ka dao 'ana futa lana sa Disas na Kraes, nia ka too lau guu 'ana tii taafuli uni wane ma ta fai uni wane sarenga ki. ");
INSERT INTO bvd_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kada sa Disas Kraes nia futa na fuli lana mai 'e 'urii: Ni Meri gaa nia sa Disas, kera alufaafia sui naa fua sa Diosef. Ma si kada keerua nao daru si too kwaimani 'ua guu, ni Meri ka toomatafana naa nia kulua 'ana wele 'ana mamanaa Anoedoo Abu ");
INSERT INTO bvd_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ma sa Diosef na waa ne da alufaafi ni Meri fuana, nia ka manata uri sa ka lukasia ni Meri. Ma sui nia, nia waa ade lana 'o'olo, nia ka dooria uri sa kai lukasi aroaro gwana 'ani Meri uri ka nao si faa nonisusualaa lau nia wela keni. ");
INSERT INTO bvd_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ma sui ta, si kada sa Diosef 'e manata 'ua gwana sulia ili lana si doo nai, nia ka maleubole ka suana 'ensel God dao ka bae 'urii fuana, “Wala Diosef 'ae, 'oe waa nee 'ana kwalafaa sa Defet nee, nao 'osi mau lau 'ana ade lana ni Meri. Suli na mamanaa Anoedoo Abu 'ana ne adea nia ka kulua nee. ");
INSERT INTO bvd_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ni Meri tara nia kai kwalafia tii wela wane ne. Aia, 'oe tara 'oko faa sataa wela nai sa Disas, suli tara nia kai faamauria toaa nia ki faasia abulo ta'aa lae kera ki.” ");
INSERT INTO bvd_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Si doo nai ki sui guu daka fuli naa 'uri nai. Ma 'i seeri si baea nia God ne brofet nia ki God 'i nao da faarongo ai ka mamana naa, ne bae 'urii, ");
INSERT INTO bvd_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Totoo tii keni saari kai kulua kai kwalafia tii wela wane ne dai 'ailia 'ana sa 'Imanuel.” Toolangainia, “God nii fai kolu.” ");
INSERT INTO bvd_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Aia si kada sa Diosef 'e maleu ka ada, nia ka ili na 'ana suli si doo nai 'ensel nia God 'e faarongo nia ki ai. Nia ka adea naa ni Meri. ");
INSERT INTO bvd_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Sui boroi 'ana, keeru nao daru si tio kwaimani guu lelea ka dao fatai 'i burina naa ni Meri nia kwalafia fa wela wane nia nai ka sui naa. Sa Diosef ka 'ailia naa wela nai 'ana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Aia, 'i burina guu sa Disas nia futa lao maefera 'i Betlehem lao Diudia brofens, 'ana si kada sa Herod nia 'inito fuada, toa saitoma doo nai fasi bali tae lana sato daka dao lao maefera baita nai 'i Durusalem. ");
INSERT INTO bvd_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Kera daka ledi 'urii, “Nee wala, ma waa 'inito kera bae toaa nee Diu ki bae nia futa sui naa 'e nii fai? Kameli, meli too mai bali tae lana sato meli ka suana sui naa fa bubulu ne faatainia futa lana. Kameli ne kameli lea mai uri meli ka faabaitaa nia 'ameli.” ");
INSERT INTO bvd_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Si kada sa Herod 'e rongoa si baea nai, na manata lana ka isifufuli 'asia naa. Ma na toaa nai lao fera 'i Durusalem boroi na manata lada ka 'uri nai lau gu fai nia. ");
INSERT INTO bvd_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nia sa Herod ka 'ailia na mai waa baita ni foa ki fai waa toolangaidoo ki 'ana taki uri daka koni ma daka bae kwaimani fai nia, ma nia ka ledi fifii naa 'ani kera uri daka saea 'i fai gu ne da saea mai na Kraes totoo kai futa ai. ");
INSERT INTO bvd_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Toa baita nai daka faarongo nia daka 'urii, “Kera da saea mai na Kraes totoo kai futa lao maefera 'i Betlehem lao Diudia brofens. Suli si baea brofet 'e kedaa mai kada 'i nao 'e bae 'urii sulia, ");
INSERT INTO bvd_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘'O Betlehem ai nee lao brofens 'i Diudia 'ae, ni 'oe nao lau ta kula mala nia gwana matangana maefera gwaungai neki 'i Diuda ne, suli totoo tii waa 'inito nia kai sakatafa mai faasi 'oe uri 'inito lae fua toaa nau 'Israel.’” ");
INSERT INTO bvd_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Sui guu, sa Herod ka kwaiodui 'ua guu uri toa dao nai mai faasia bali tae lana sato, uri kera daka bae kwaimani agwa 'ada fai nia ma nia ka tala rongo 'isi guu faasi kera 'ana si kada ne kera safali suana mai fa bubulu nai ai. ");
INSERT INTO bvd_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","'Uri nai sui guu, nia ka odu kera daka lea naa uri 'i Betlehem. Nia ka bae 'urii fuada, “Lea kau, molu ka nani 'initoa mai uri wela nai. Lea molu dao tona naa molu ka faarongo nau mai, uri nau lau guu lea kau ku faabaita nia 'akua.” ");
INSERT INTO bvd_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Sa Herod nia bae 'uri nai fuada sui guu, kera daka lea naa. Si kada kera dao sulia taale, kera daka suana lau gwada fa bubulu bae kera safali suana mai bali tae lana sato. Ma ni kera daka ele 'asia naa si kada nai kera suana lau fa bubulu nai. Fa bubulu nai kera suana kau 'i mamangaa ka talai kera naa lelea daka dau guu 'ana si kula nai sa Disas nia nii ai. ");
INSERT INTO bvd_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kera daka ruu na kau lao luma nai seeri, ma daka suana naa wela nai fai gaa nia ni Meri 'i seeri. Kera daka booruru daka faa'initoaa naa wela nai, ma daka tasaa naa wai kera ki uri daka falea si falea kera ki fuana ne liu lada baita tasa. Kera falea gool, doo sasuna moko diana tasa ki ma na waiwai moko diana tasa ki fuana. ");
INSERT INTO bvd_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Sui si kada kera oli naa uri fera kera, kera daka lea na 'ada 'ana ta taala 'e'ete faasia tala bae kera lea kau ai, suli God nia faarongo kera lao maleubolee kera nao dasi oli uri dao lae lau siana sa Herod. ");
INSERT INTO bvd_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","'I burina naa waa nai ki da oli 'i fera kera, na 'ensel nia God ka faatai fuana sa Diosef lao maleubolea ka bae 'urii, “Diosef 'ae, 'oe tatae 'oko ngalia na wela nee fai nia gaa nia molu ka tafi 'amolu uri 'i 'Isib. Molu too mai 'i seeri lelea ka dao fatai 'ana si kada nau ku saea fuamolu uri oli lae mai. Suli sa Herod nia nani burina wela nee uri ka saungia 'ana.” ");
INSERT INTO bvd_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Sa Diosef nia tatae ka talaia ni Meri fai wela nia kera daka lea naa lao rodo 'ua guu uri maefera 'i 'Isib. ");
INSERT INTO bvd_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kera daka too mai 'i seeri lelea sa Herod ka mae naa, ma si doo nai ka fuli ka adea bae lana God ne brofet ki kedaa mai 'i nao ka mamana naa. Ne nia bae 'urii, “Nau ku 'ailia mai wela nau faasia 'i 'Isib.” ");
INSERT INTO bvd_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ma si kada sa Herod na waa 'inito bae 'e saitomana ne toa bae faasia bali tae lana sato da suke nia, nia ka rakesasu 'asia naa. 'I seeri nia ka saea daka koni omee naa uri daka saungi tiifau 'ana wela wane ki ne kera dafi futa lao maefera 'i Betlehem ma lao maefera nai ki kakalia sui guu. Nia ka falea si baea fifii fuada uri kera daka saungia tiifau 'ana wela wane neki too 'ana roo fa ngali ki ka oli toli mai sui guu, uri ka ladea si kada bae waa baki bali tae lana sato kera safa suana fa bubulu bae ai ka lea mai. ");
INSERT INTO bvd_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","'I seeri guu na toaa nai lao fera 'i Betlehem daka angisia naa wela kera nai ki da mae nai. Ma na angi laa nai ka dao toi naa doo bae brofet Dioromaea nia saea 'uana mai 'i nao. Bae nia 'urii, ");
INSERT INTO bvd_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Tii si lingee doo ne talo mai faasia 'i Ramaa, na gwela angiangia baite. Ni Reesel ne nia angisia naa wela nia ki. Nia 'e angi daka gwafe tona boroi ka 'afitai naa, suli bara wela nia tiifau da mae naa.” ");
INSERT INTO bvd_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ma 'i burina sa Herod 'e mae naa, na 'ensel nia God ka faatai lau fuana sa Diosef 'i lao maleubolee lao fera 'i 'Isib. ");
INSERT INTO bvd_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nia ka bae 'urii, “Diosef 'ae, tatae 'oko talaia ni Meri fai wela nia nee molu ka oli naa uri 'Israel. Toaa bae da sasi uria saungi lana wela nee, kera da mae naa.” ");
INSERT INTO bvd_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Sui sa Diosef tatae ka talaia ni Meri fai wela nia ma daka oli naa uri 'Israel. ");
INSERT INTO bvd_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ma sui, si kada sa Diosef 'e rongoa sa 'Akelas nia talana maa nia sa Herod ma ka 'inito fua bali lolofaa 'i Diudia, nia ka mau lau gwana 'ana too lae 'i seeri. Na 'ensel ka saea lau fuana 'i lao maleubolea uri daka tasa uri lao bali lolofaa 'i Galilii. ");
INSERT INTO bvd_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Si doo nai ne adea ma kera lea daka too mai 'i Naasaret lao bali lolofaa 'i Galilii. Si kada si ade laa nai nia fuli, si baea brofet ki da bae mai sulia 'i nao ka mamana naa. Ne bae 'urii, “Kera dai saea 'ana waa 'i Naasaret.” ");
INSERT INTO bvd_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Totoo 'ana si kada nai ki lelea ka tau naa, sa Dion waa ni faasiuabu nai nia ka dao na mai. Ma nia ka safalia toolangaidoo naa lao fera kwasi nai lao bali lolofaa 'i Diudia. Nia ka bae 'urii, ");
INSERT INTO bvd_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Molu bulasi manataa faasia abulo ta'aa laa kamolu ki, suli na 'initoaa God nia nii karangi kamolu naa.” ");
INSERT INTO bvd_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Sa Dion nai na bae brofet 'Aesaea 'e bae mai suli nia ka bae 'urii, “Totoo tii waa kai 'ai 'i lao fera kwasi. Ma nia kai bae 'urii, ‘Na Aofia kai dao mai! Molu 'olosia taale fuana!’” ");
INSERT INTO bvd_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Sa Dion, si ofi nia na ifuna kamel gwana, ma si kanifolo nia 'i salafana si 'unga buluka gwana. Si fanga ni 'ani lana nia fa siko ki gwana ma ka kuufia gwana wewedue kwasi. ");
INSERT INTO bvd_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Na toaa 'oro faasia 'i Durusalem da lea kau siana, ma toae ki lau guu fasia lao bali lolofaa nai 'i Diudia ma faasia maefere 'e'ete nai ki sui guu karangia kafo 'i Diodan da lea lau gu kau. ");
INSERT INTO bvd_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Toaa nai ki daka bae folaa ne kera lukasia abulo ta'aa laa kera ki, ma sa Dion ka faasiuabu kera naa lao kafo nai 'i Diodan. ");
INSERT INTO bvd_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ma si kada sa Dion 'e suana toa Faarisii ma toa Sadiusii 'oro nai da lea lau gu kau siana, nia ka bae 'urii fuada, “Kamolu na kalena baekwe 'i tolo neki mone! Kamolu nao molu si bulasi manataa guu. Tii ne saea molu ka sasi uri tafi lae faasia na kwakwaea nia God fuamolu, ne lea sa molu siuabu ma molu ka tala faasia? ");
INSERT INTO bvd_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Molu ilia si doo ne nia faatainia kamolu molu bulasi manataa faasia na abulo ta'aa laa kamolu ki taari! ");
INSERT INTO bvd_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Too 'amolu faasia manata lae 'urii 'i lao liomolu, ‘'O kameli nee toa meli futa 'ua gu mai lao kwalafaa sa 'Abraham ne. 'Afitai tara God nia ka kwae kameli!’ Ku saea 'o'olo gu fuamolu, nao si 'afitai guu fua God uri nia ka tafoa ta kwalafaa fua sa 'Abraham faasia maefau neki boroi 'ana! ");
INSERT INTO bvd_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","'I tari'ina nee, God nia kwaimaakwali sui naa 'ana kwakwaea. Nia ka mala na bae ta wane nia dau naa 'ana batau 'aena 'ai uri taba lana. Na 'ai neki sui guu nao dasi fungu 'ana ta fuaedoo diana, nia kai taba tiifau 'ani kera ma kai 'ui 'anida lao ere. ");
INSERT INTO bvd_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nau ku faasiuabu kamolu 'ana kafo uri faatai lana ne kamolu molu bulasi manataa naa. Ma tii waa ne nia kai dao mai buriku, nia fatai ne kai faasiuabu kamolu 'ana Anoedoo Abu ma 'ana ere. Na waa nai nia 'initoa ka talu nau, ma na luke lana sadol nia ki boroi 'ana nau nao kwasi tala'ana. ");
INSERT INTO bvd_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tasi doo lau, na waa nai nia ade akau sui naa uri sangita lana wane sui guu. Nia kai ade mala bae ta wane nia 'efoa 'e'eforana miga wiiti ki faasia tadidoe ki. Nia kai taingainia migadoe ki lao luma ni taingai laa nia, ma nia kai suungia tadidoe ki 'i lao era ne sasaru 'afitai ka mae.” ");
INSERT INTO bvd_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","'Ana si kada nai guu, sa Disas nia ka lea na mai faasia bali lolofaa 'i Galilii uri lea lae siana sa Dion suli kafo 'i Diodan uri sa Dion ka faasiuabu nia. ");
INSERT INTO bvd_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Sui, sa Dion nia ka manata kwaimangosi uri ili lana si doo nai 'ani nia ka bae 'ana 'urii, “Nia bobola fai nia sa 'oe ne 'oko faasiuabu nau. Ma sui 'oko lea lau 'amu mai siaku uri nau kwai faasiuabu 'oe nee!” ");
INSERT INTO bvd_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Sa Disas 'e luu nia ka bae 'urii, “Alu nia fuli 'ana 'urii nai. Nia diana fua koro ka fulia doo ki sui guu ka lea suli doori lana God.” Sa Dion ka ala na faafia. ");
INSERT INTO bvd_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ma 'ana si kada sa Disas nia siuabu sui ka tatae gu mai faasia lao kafo, 'i salo ka 'ifi na mai ma nia ka liotona naa Anoedoo Abu God 'e sifo mai ilingia ta fa bole ka dau na faafi nia. ");
INSERT INTO bvd_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma tii si lingeewane nai ka talo mai faasia 'i salo ka bae 'urii, “Nia naa ne 'Alakwa nau ne ku liosau 'ani nia. Na manata laku 'e ele 'asia naa suli nia.” ");
INSERT INTO bvd_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Sui na Anoedoo Abu ka talaia naa sa Disas uria lao fera kwasi nai uri Saetan ka ilitona. ");
INSERT INTO bvd_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ma sa Disas ka fiolo mae naa 'i burina nia abufanga mai suli faitaafuli fa dani ma faitaafuli fa rodo ki. ");
INSERT INTO bvd_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","'Uri nai, sa Saetan ka lea mai dao siana ka bae 'urii, “Lea sa 'oe na 'Alakwa nia God mamana, 'oko saea fasi fua maefau neki uri daka lia 'ana fange ki wala.” ");
INSERT INTO bvd_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Sa Disas 'e luu nia ka 'urii, “Na kekeda laa Abu nia saea sui naa, ‘Na wane, nao lau otona fange gwana ne nia mauri ai. Si baea neki sui guu God nia saea 'ana ne nia mauri ai.’” ");
INSERT INTO bvd_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sui sa Saetan ka talaia sa Disas ka lea lau uria na Beukaua nai 'i Durusalem. Nia ka faa uua sa Disas 'ana si kula fane tasa nai 'i langi. ");
INSERT INTO bvd_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ka bae 'urii fuana, “Lea sa 'oe na 'Alakwa nia God mamana, 'oko lofo toli fasi uri fubaa 'i saegano wala. Na kekeda laa Abu 'e saea sui naa ka 'urii, ‘Tara God nia kai odua mai 'ensel nia ki siamu ma kera dai sako 'oe ma na 'aemu 'afitai ka toea guu ta maefau.’” ");
INSERT INTO bvd_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Sa Disas 'e luu nia ka 'urii, “Na kekeda laa Abu nia saea sui naa ka bae lau guu 'urii, ‘Abu nao 'osi ilitona God 'oe.’” ");
INSERT INTO bvd_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sui sa Saetan ka talaia sa Disas ka lea lau uria gwauna fa uo fane nai 'i langi ka faatainia 'initoaa neki sui guu lao molaagali fai nia kwanga lada ki tiifau fuana sa Disas ka suai ki. ");
INSERT INTO bvd_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Sa Saetan ka bae 'urii, “Doo nau ki sui gu nai. Lea sa 'oe 'o booruru 'i maana 'aeku 'ana faabaita laku, nau kwai fale tiifau 'ana doo nai ki sui guu fuamu.” ");
INSERT INTO bvd_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Sa Disas 'e luu nia ka 'urii, “Wala Saetan 'ae, 'otolangai 'oe 'o lea 'amu faasi nau! Na kekeda laa Abu nia saea sui naa ka 'urii, ‘Molu faabaitaa God na Aofia kamolu ka sui naa, ma molu ka rao fuana taifili nia guu.’” ");
INSERT INTO bvd_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nia dao gu 'i seeri, sa Saetan ka lea na 'ana faasia sa Disas. Ma na 'ensel ki naa daka lea mai daka 'adomia sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Si kada sa Disas nia rongoa ne kera alua sa Dion ka nii na lao lookafo, nia ka oli kau uria bali lolofaa 'i Galilii. ");
INSERT INTO bvd_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nia ka 'idu ka too 'e'ete naa faasia maefera bae 'i Naasaret. Nia lea ka too naa 'i Kabaneam maefera nai 'e nii gwana 'i ninimana 'osi 'i Galilii. Na bali fera nai nia bali da fale fuana fiiwane sa Sebulun fai fiiwane sa Naftalii. ");
INSERT INTO bvd_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Si 'idu laa nai sa Disas 'idu kau uri seeri, nia lea sulia doo brofet 'Aesaea 'e kekeda 'uana mai sulia ne bae 'urii, ");
INSERT INTO bvd_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Na toaa lao bali fera kera fiiwane sa Sebulun fai fiiwane sa Naftalii ki ne da nii kwaimani lau gu fai nia 'osi 'i Galilii, ma na fera nai 'i bali suu lana sato 'ana kafo 'i Diodan, lao bali lolofaa nai toaa nao lau Diu ki da too ai; ");
INSERT INTO bvd_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","toaa nai kera da too lao rorodoa lae 'i seeri, kera da suana naa tii folaa laa baita. Ma na folaa laa nai nia kwalisitafa naa faafia toaa ne kera too lao rorodoa laa 'ana maea.” ");
INSERT INTO bvd_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Safali gu 'ana si kada nai, sa Disas ka faatalongai naa 'urii, “Molu bulasi manataa faasia abulo ta'aa laa kamolu ki, suli na 'initoaa God nia nii karangi kamolu naa!” ");
INSERT INTO bvd_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Si kada sa Disas nia 'iia kau 'osi nai 'i Galilii, nia ka suana roo waisaasina nai ki sa Saemon (ne da 'ailia lau gu 'ana sa Bita) fai nia sa 'Andru. Keerua daru dee 'adarua 'ana furai keerua lao 'osi nai, suli keerua na roo waa ni dee lae ki 'ua guu. ");
INSERT INTO bvd_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ma sa Disas ka bae 'urii fuadaru, “Muru lea mai buriku uri nau ku toolangainia dee lae siamuru uri dee lana wane fuaku.” ");
INSERT INTO bvd_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","'I seeri 'ua guu, keerua daru ka faasia na furai keerua ki ka tio naa, daru ka lea na 'adarua burina sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sui sa Disas fai keerua daka lea na kau nia ka suana ta roo waisaasina lau guu, sa Demes fai nia sa Dion keerua roo 'alakwa sa Sebedii ki. Keerua too gwadarua 'i seeri fai nia maa keeru sa Sebedii lao baru kera nai. Kera da taia 'ada furai kera nai ki 'uri nai sa Disas ka 'aili keerua na mai. ");
INSERT INTO bvd_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ma 'i seeri 'ua guu, keerua daru ka faasia na 'adarua baru fai nia maa keerua, daru ka lea na 'adarua burina sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Sa Disas nia ka lea naa 'ana maefera ki lao bali lolofaa nai 'i Galilii, ma ka toolangaidoo naa fua toae ki lao beu ni ofu kera toaa Diu ki. Ma nia ka falebaea naa sulia na faarongoa diana nee sulia 'initoaa God, ma ka guraa naa mataia 'e'ete ki sui gwana ne saungia wane ki. ");
INSERT INTO bvd_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Na faarongo lae suli nia ka talofia naa maefere ki sui guu lao bali lolofaa nai 'i Siria. Ma daka ngalia na mai toaa 'oro ne mataia 'e'ete ki sui gwana ne saungi kera ki siana. Na toaa ne da matai baita 'ana nonifiia, ma toaa ne anoedoo ta'aa ki fungulida, ma na toaa ne mataia 'ana uoro saungi kera ki, ma toaa ne 'aeda mae ki, kera daka lea na mai siana. Ma sa Disas ka gura kera tiifau. ");
INSERT INTO bvd_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ma na toaa 'oro 'asia naa lau guu faasia bali lolofaa 'i Galilii, faasia fera baita 'i Durusalem, faasia lao bali lolofaa nai 'i Diudia ma 'i Dikabolis, ma na toaa da lea ki mai faasia bali tae lana sato 'ana kafo 'i Diodan; kera daka lea naa burina sa Disas 'ana si kada nai. ");
INSERT INTO bvd_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Sa Disas nia suana konia baita nai, nia ka raa 'i gwauna fa labusua nai ka gooru 'i saegano. Na toa kwairooi nia ki kera daka koni kali nia, ");
INSERT INTO bvd_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ma nia ka safali toolangaidoo naa fuada. Nia ka bae na 'urii, ");
INSERT INTO bvd_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“'E diana tasa fua toaa ne da lio saitomana kera kwai 'atoi 'ana God, suli na 'initoaa God nia doo fua toaa nai. ");
INSERT INTO bvd_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","'E diana tasa fua toaa ne da liodila, suli God nia kai gwafe kera. ");
INSERT INTO bvd_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","'E diana tasa fua toaa ne da abulo tu'uu, suli God nia kai falea ano nee tiifau fuada. ");
INSERT INTO bvd_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","'E diana tasa fua toaa ne da fiolo mae ma daka maeli kuu uria 'o'oloe, suli God kai adea manata lada ka toli. ");
INSERT INTO bvd_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","'E diana tasa fua toaa ne da kwai'ofei, suli God nia kai 'ofe kera. ");
INSERT INTO bvd_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","'E diana tasa fua toaa ne lioda sasaolia, suli kera da kai suana God. ");
INSERT INTO bvd_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","'E diana tasa fua toaa ne da saungainia aroaroe matangana toae, suli God nia kai 'aili kera 'ana wela nia ki. ");
INSERT INTO bvd_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","'E diana tasa fua toaa ne wane susubutai kera faafia 'o'oloe, suli na 'initoaa God nia doo fua toaa nai.” ");
INSERT INTO bvd_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“'E diana tasa fuamolu si kada wane ki da susubutai kamolu ma daka bae ta'aa fuamolu, ma daka suke 'ana doo ta'aa 'oro faafi kamolu suli ne kamolu toa kwairooi nau. ");
INSERT INTO bvd_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ele molu ka noni sasala 'amolu, suli kwaiaraa kamolu 'i salo nia baita tasa. Na brofet ki 'ana kada 'i nao, toae ki susubutai kera lau gu mai 'uri nai.” ");
INSERT INTO bvd_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Sa Disas ka bae lau gu 'urii, “Kamolu molu mala 'ana tasi solo uri fale lana dianae fuana toae lao fera ne 'i ano. Ma sui ta, na solo lelea na mamasia lana 'e nao'ana naa faasia, nia 'afitai naa ka mamasia lau. Ma lea nia 'uri nai naa, nia 'afitai ka diana lau fua ili lana 'ana tasi doo lau. Nia doo gwana uri 'ui lae ai ma dali lana naa. ");
INSERT INTO bvd_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kamolu molu mala 'ana ta kwesu uri kwesu folaa lae fua toae lao fera ne 'i ano. Nia 'ana ta maefera baita ne nii gwauna tafa uo 'i langi, nia 'afitai ka agwa. ");
INSERT INTO bvd_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Na wane 'afitai ka faasaru kwesu ma sui ka saufinia gwana 'i farana ta tiu. Si kada nia faasarua kwesu sui, nia ngalia ka faagoorua 'i langi uri ka tala folaa fua toae ki sui guu lao lume. ");
INSERT INTO bvd_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Talafana lau guu ni kamolu nai. Molu alua kwesu kamolu ki daka tala folaa fua toae ki sui, uri kera daka liotoi 'ada doo diana neki molu ilia ma daka tangoa 'ada Maa kamolu God 'i salo. ");
INSERT INTO bvd_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nao molu si manata toi sa nau ku lea mai uri ku faasuia taki sa Mosis ma na toolangaidooa kera brofet ki. Nau kwasi lea mai uri faasui lada 'uri nai. Nau ku lea mai uri ku faafonosia doo neki da bae ki mai sulia uri ka fono. ");
INSERT INTO bvd_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Si doo mamane ku saea fuamolu nia 'urii, lelea na salo loo fai nia fera ne 'i saegano daka sui boroi 'ada, tasi baea tu'uu 'isi boroi 'ana lao taki sa Mosis nia 'afitai ka tatala lelea na doo neki sui guu nia bae sulia ki tara da kai fuli lelea tasi doo si ore guu. ");
INSERT INTO bvd_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Doo ne adea guu, tii ne nia 'oia si baea fifii tu'uu boroi 'ana lao taki ma ka talaia lau guu tai wane uri 'oi lana si baea nai, 'i lao 'initoaa God tara God nia mala siofaa wane nai. Aia, ma tii ne nia ade sulia si baea fifii nai ma ka talaia lau guu tai wane fua ade lae sulia, 'i lao 'initoaa God tara God nia kai faa'initoaa wane nai. ");
INSERT INTO bvd_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Aia nau ku faarongo kamolu, lelea sa na 'o'oloa kamolu nia ka nao si 'e'ete guu faasia na 'o'oloa kera toa toolangaidoo nee 'ana taki ma na Faarisii neki, nia 'afitai tasa fuamolu uri molu ka ruu lao 'initoaa God. ");
INSERT INTO bvd_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kamolu molu rongo sui naa si baea bae fuana kokoo kolu ki mai 'ana kada 'i nao bae nia 'urii, ‘Abu 'osi sauwane. Tii ne nia sauwane, tara kera da kai keto nia uri fale lana kwakwaea fuana.’ ");
INSERT INTO bvd_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Aia, ma 'i tari'ina si doo ku saea naa fuamolu nia 'urii; tii ne nia rakesasuia toolana, tara kera da kai keto nia uri fale lana kwakwaea fuana. Tii ne nia bae ta'aa fuana toolana ma ka saea, ‘'Oe doo gwauoea nee,’ tara da kai ngali nia lao koot baite 'ana fera nee. Ma nao tii ne nia bae ta'aa fuana toolana ma ka 'urii, ‘'Oe doo garo nee,’ nia naofia kwakwaea lao era bae sasaru ka lelea firi. ");
INSERT INTO bvd_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Doo ne adea guu, lea 'oe ngali mai afuafua 'oe ka dao 'i maana fuliera abu God, ma 'oko manata toi tasi doo ne 'oe ilia mai ka garo fua toolamu, ");
INSERT INTO bvd_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","'oko faasia afuafua 'oe nai 'i maana fuliera abu ka too fasi 'ana, oli 'oko 'olosia fasi 'amua si doo nai fai toolamu uri muru ka 'ado kwaimani lau. Sui fatai, 'oe oli mai 'ofi falea afuafua 'oe talea God. ");
INSERT INTO bvd_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Lea ta wane nia ngali 'oe naa fua lao koot, 'oe 'oko 'ali'ali uri 'olosi lana si doo nai nia ngali 'oe faafia uri ka 'o'olo. Ili 'uri nai 'ua guu 'ana si kada nao muru si dao 'ua lao koot. Suli lea nia ka fale 'oe naa 'i 'abana koot, tara koot nia kai falea naa kwakwaea ne 'oe kai ngalia, lea sui ka fale 'oe naa 'i 'abana toa da kai dau 'oe uri alu lamu lao lookafo. ");
INSERT INTO bvd_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Suli lea nia 'uri nai, nau ku sae mamana ai fuamolu, tara nia 'afitai tasa naa fua 'oko oli lau mai 'i maa faasia lao lookafo. Tara 'oko too na 'uri nai lelea 'oko falea guu si malefo 'isi dangalu 'ana kwakwaea 'oe. ");
INSERT INTO bvd_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Kamolu molu rongoa sui naa bae da saea mai fuana kokoo kolu ki kada 'i nao ma daka bae 'urii, ‘Abu 'osi kaubarea araie fai 'afee.’ ");
INSERT INTO bvd_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ma sui tari'ina si doo ku saea fuamolu nia 'urii, waa ne bubungia wela keni fai nia si lioewane ni garo lana lae, nia garoa sui naa 'i liona. ");
INSERT INTO bvd_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nia ne, lelea na maamu 'i bali aolo 'oe 'e talai 'oe uri lao abulo ta'aa lae, 'oko keoa 'oko 'ui boroi 'amu ai faasi 'oe. 'Ui lae 'ana si kula tu'uu gwana 'i nonimu 'uri nai, ade boroi nia taa diana gwana fuamu. Si doo ne ta'aa ka tasa fatai ne lea God nia 'ui tiifau 'ani 'oe 'i lao era saruladoa bae. ");
INSERT INTO bvd_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma lelea na 'aba aolo 'oe 'e talai 'oe uri lao abulo ta'aa lae, 'oko sigimuusia 'oko 'ui boroi 'amu ai faasi 'oe. 'Ui lae 'ana si kula tu'uu gwana 'i nonimu 'uri nai, ade boroi nia taa diana gwana fuamu. Si doo ne ta'aa ka tasa fatai ne lea God nia 'ui tiifau 'ani 'oe 'i lao era saruladoa bae. ");
INSERT INTO bvd_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Kamolu molu rongoa sui naa bae da saea mai fuana kokoo kolu ki kada 'i nao ma daka bae 'urii, ‘Lelea waa lukasia 'afe nia, waa nai ka faa kau beba ni kwailukasi lae fuana 'afe nia.’ ");
INSERT INTO bvd_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ma sui tari'ina, si doo nau ku saea fuamolu nia 'urii, nao 'osi lukasia lau 'afe 'oe. Na waa ne nia lukasia 'afe nia faafia 'atona gwana doe ma ka nao uri maana ne 'initai nia ooe fai ta waa 'e'ete, waa nai nia falea 'afe nia fua ooe lae. Ma na waa ne adea 'initai nai da lukasia naa, waa nai lau guu nia ooe naa. ");
INSERT INTO bvd_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ka 'uri nai lau guu, kamolu molu rongoa sui naa bae da saea mai fuana kokoo kolu ki 'ana kada 'i nao ma daka bae 'urii, ‘Lea 'oe alangai 'oko tofe naa 'ana satana God, nao lea 'osi 'oia naa alangaia 'oe nai.’ ");
INSERT INTO bvd_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma sui 'i tari'ina, si doo nau ku saea fuamolu nia 'urii, abu nao 'osi tofe 'ana ta doo lau. Nao 'osi tofe 'ana fera 'i salo, suli nia na doo ni goorua nia God 'ana 'inito lae. ");
INSERT INTO bvd_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma 'osi tofe 'ana fera ne 'i saegano, suli God nia 'inito fuai. Ma 'osi tofe 'ana satana maefera nee 'i Durusalem, suli nia na maefera baita nia Waa 'inito tasa nee. ");
INSERT INTO bvd_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma nao 'osi tofe 'ana gwaumu. Suli 'oe 'afitai 'oko tala'ana saungai lana tasi ifu kwakwaoa ma nao tasi ifu boboraa 'ana gwaumu. ");
INSERT INTO bvd_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Lea 'oe 'o alangai, 'oko bae gwamu 'urii, ‘Iuka, nau tara kwai ilia si doo nai.’ Ma lea nia nao guu, 'oko bae gwamu 'urii, ‘Nao, nau tara nao kwasi ilia guu.’ Ma lea 'oe saea lau tasi doo 'e'ete lau fai nia, si doo nai nia lea na mai faasia sa Saetan.” ");
INSERT INTO bvd_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Kamolu molu rongoa sui naa bae da saea mai fua kokoo kolu ki kada 'i nao ma daka bae 'urii, ‘Wane ne nia dikwea tii bali maa gwana, tii bali maa 'ani nia gwana daka dikwea. Ma na wane ne nia 'oia tii gwa lifo gwana 'ana wane, tii gwa lifo 'ani nia lau guu da kai 'oia.’ ");
INSERT INTO bvd_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ma sui 'i tari'ina, si doo nau ku saea fuamolu nia 'urii, nao 'osi sasi uri duu lana si doo ne ta wane ta'aa nia ilia ka ta'aa fuamu. Lea ta wane nia fidali 'oe 'ana bali aolo 'i babalimu, 'oko faolomainia fuana ka fidali 'oe lau guu 'i bali mauli. ");
INSERT INTO bvd_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ma lea ta wane nia ka ngali 'oe lao koot ma ka ngalia naa si maku tu'uu 'oe ni ofi lae salafamu, 'oko faolomainia fuana ka ngalia lau guu maku baita 'oe fuana. ");
INSERT INTO bvd_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Lea ta wane nia suumai 'oe fua ngali lana 'okodoo nia sulia ta tii si kada tala, 'oko ngalia 'okodoo nia 'oko lea lau kau sulia ta ruana kada tala. ");
INSERT INTO bvd_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Si doo ne wane nia gani 'oe uria, 'oko faa fuana. Wane ne nia dooria kai ngali fasi 'ana si doo 'i satamu sulia si kada tasi kada gwana, 'oko faa fuana ka ngali fasi 'ana, nao 'osi luia. ");
INSERT INTO bvd_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Kamolu molu rongoa sui naa bae da saea mai fua kokoo kolu ki kada 'i nao ma daka bae 'urii, ‘'O liosau 'ana wane 'i fera kamu, 'oko susubutainia malimae 'oe.’ ");
INSERT INTO bvd_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ma sui 'i tari'ina, si doo nau ku saea fuamolu nia 'urii, 'o liosau 'ana malimae 'oe ki ma 'oko foa fuana toaa ne da ade ta'aa ki fuamolu. ");
INSERT INTO bvd_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","'O ili 'uri nai uri 'oko usulia lau guu na Maa 'oe 'i salo. Suli nia 'e saungainia sato loo ka sato diana fuana toaa diane ki ma na toaa ta'ae ki ka bobola guu. Nia ka faa lau gu mai ute fua 'adomi lana toaa ade 'o'olo ki ma na toaa ade garo ki ka bobola guu. ");
INSERT INTO bvd_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Lea sae 'oe liosau gwamu 'ana wane ne nia liosau 'ani 'oe, tara God nia 'afitai ka kwaiarangai 'oe uria. Suli na toaa neki da kai konia malefo 'ana takisi, kera ne da too 'ana kwaini liosaua 'uri nai! ");
INSERT INTO bvd_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ma lea sae 'oe ade diana gwamu fuana otona toaa kwaimani 'oe ki, tara 'afitai 'oko 'e'ete guu. Suli na toaa neki nao dasi saitomana God, kera ne da ade 'uri nai! ");
INSERT INTO bvd_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Doo ne adea guu, molu ade diana ka 'uria guu na Maa kamolu 'i salo ne nia ade diana tiifau.” ");
INSERT INTO bvd_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Sa Disas nia ka bae 'urii, “Molu ka fiia, ade lea molu ka ilia gwamolu doo diane ki uri wane ka suamolu ma ka tango kamolu fai nia. Lelea kamolu ili 'uri nai, tara nia 'afitai naa molu ka ngalia lau ta kwaiaraa faasia Maa kamolu God 'i salo. ");
INSERT INTO bvd_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Doo ne adea guu, lea 'oe ilia si doo diane uri ka 'adomia toaa siofaa ki, nao 'osi faatalongainia lau uri daka tango 'oe gu fai nia. Nao 'osi ade mala 'ana doo ne toaa kwaisukei ki da ilia lao beu ni ofu lae ki ma sulia tala baite ki uri toae ka tangoda fai nia. Si doo mamane ku faarongo kamolu ai nia 'urii, God nia tara 'afitai ka kwaiarangai kera lau toaa nai da ade 'uri nai, suli na tango laa ne toae ki da ilia 'ani kera nia talafana naa kwaiaraa kera da ngalia sui naa. ");
INSERT INTO bvd_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Aia ma ni 'oe, si kada 'oe ilia si doo diane fua 'adomi lana ta wane siofaa, na toaa kwai karangi tasa 'oe ki boroi nao 'osi faarongo kera lau ai uri tango lamu lae fai nia. ");
INSERT INTO bvd_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","'O agwatainia fale kwai'adomia 'oe ki. 'I seeri, na Maa 'oe God waa ne suana doo diana nai ki 'oe ilia ka saufini gwana ki, nia kai kwaiarangai 'oe.” ");
INSERT INTO bvd_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Sa Disas ka bae 'urii, “Si kada 'oe foa, nao 'osi mala lau 'ana toaa kwaisukei ki. Ne si kada kera foa, kera daka dooria 'asia naa uu faatai lae lao beu ni ofu lae ki ma sulia taala baite ki uri toae ki daka suada fai nia ma daka faa'inito kera. Si doo mamane nau ku saea fuamolu nia 'urii, God nia tara 'afitai ka kwaiarangai kera lau toaa nai da ade 'uri nai, suli na faa'inito laa ne toae ki da ilia 'ani kera nia talafana kwaiaraa kera ne da ngali sui naa. ");
INSERT INTO bvd_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Si kada 'oe foa, lea 'oko too banitai 'amua 'ana kada lume tai 'oe 'oko fonoki suusi 'oe. 'O too 'i seeri 'oko foa agwa 'amua talea Maa 'oe God. 'I seeri na Maa 'oe nai, ne nia suana doo ki sui guu tara nia kai kwaiarangai 'oe. ");
INSERT INTO bvd_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Si kada 'oe foa, nao 'osi takomainia lau baee 'oro sui gwana mala 'ana ade laa ne toaa neki da ulafusia God da ilia ki. Ne kera foa 'ada ki ma daka takomainia baea 'oro mamana guu lao foa laa kera ki ma daka foa ka tau 'asia naa. Doo nai ki kera saea ki, kera boroi da ulafusia ki lau gwada. Kera manata lada 'ana saea sa foa tikwa laa kera nai ne tara nia adea God ka ilia doo ne kera gania ki. ");
INSERT INTO bvd_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nao 'osi ili mala 'ani kera, suli Maa 'oe God 'i salo nia saitomana sui na kau 'i nao na doo ne 'oe 'atoia sui fatai 'ofi gani nia uria. ");
INSERT INTO bvd_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Aia, si kada kamolu foa, molu ka foa 'urii, ‘Maa kameli 'i salo, Alu toae ki sui daka sae'inito 'ada 'ana satamu ne abu. ");
INSERT INTO bvd_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Lea mai 'oko 'inito naa 'ana doo ki sui guu. Alu toae ki sui guu daka ade 'ada sulia doori lamu lao fera ne 'i ano mala lau guu da ilia lao fera 'i salo. ");
INSERT INTO bvd_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Fale mai si fanga kameli uri tari'ina ka bobola fai nia. ");
INSERT INTO bvd_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","'Oko manata luke kameli faasia garo laa kameli ki, suli meli manata lukea lau guu toaa da ilia doo garo ki fuameli. ");
INSERT INTO bvd_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","'Osi lukasi kameli lau fua ilitooe ka linge kameli. Tafalangai kameli kau faasia 'abana waa ta'aa bae.’ ");
INSERT INTO bvd_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Lea 'oe manata lukea abulo ta'aa laa nia ta wane ilia fuamu, Maa 'oe 'i salo nia kai manata lukea lau guu abulo ta'aa laa 'oe ki. ");
INSERT INTO bvd_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma lea 'oe nao 'osi manata lukea gu abulo ta'aa laa nia ta wane ilia fuamu, Maa 'oe 'i salo boroi nia nao si manata lukea lau guu abulo ta'aa laa 'oe ki.” ");
INSERT INTO bvd_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Sa Disas ka bae lau gu 'urii, “Si kada 'oe abufanga, nao 'osi ade lau mala 'ana toaa kwaisukei ki, ne kera abufanga ma daka alubili mala 'ana toaa da too 'ana liodila lae. Kera da ili 'uri nai uri wane ka liotoi ma ka tango kera ne da abufanga. Si doo mamane nau ku saea fuamolu nia 'urii, God tara nia 'afitai ka kwaiarangai kera lau, suli na tango laa ne toae ki da ilia 'ani kera nai nia talafana kwaiaraa kera naa ne da ngalia sui naa. ");
INSERT INTO bvd_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Aia ma ni 'oe, si kada 'o abufanga, 'oko taufia maamu ka falu ma 'oko komua 'amua ifumu mala ne 'oe 'ita 'oko ilia 'ua guu, ");
INSERT INTO bvd_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","uri nao ta wane si lio saitomana lau ne 'oe abufanga. Taifilia guu Maa 'oe God 'i salo ne nia saitomana si doo diana ne 'oe ilia ka saufini gwana, ma nia ne kai kwaiarangai 'oe, sui boroi 'ana nao 'osi suana 'ana maamu.” ");
INSERT INTO bvd_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Sa Disas ka bae lau 'urii, “Nao 'osi taingainia ogogonia 'oe ki lao fera ne 'i ano kula ne 'aide kai saketoa doo ki ai, ma doo ki too ai da kai fura ma na wane ki daka 'oia mae ki ma daka belia doo ki ai. ");
INSERT INTO bvd_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","'O taingainia 'amua ogogonia 'oe ki lao fera 'i salo, kula ne 'aide nao si saketoa doo ki ai, ma na doo ki daka tio ai nao dasi fura, ma na wane ki ka nao dasi 'oia mae ki ma dasi belia doo ki ai. ");
INSERT INTO bvd_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Suli si kula ne 'oe taingainia ogogonia 'oe ai, nia ne tara na liomu 'e nii ai. ");
INSERT INTO bvd_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Na maana wane, nia na kwesu uri tala folaa lae fua noniwane. Lea na maamu ki da diana gwada, na kwesu nia God nia tala folaa fuana nonimu tiifau. ");
INSERT INTO bvd_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Aia ma lea na maamu ki da ta'aa, ni 'oe 'o too gwamu lao rorodoa lae suli maamu nia ta'aa. 'Oko fiia ade lea 'oko lukasia na kwesu nia God ma na mauria 'oe nia ka rorodoa ta'aa 'isi naa.” ");
INSERT INTO bvd_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Nia 'afitai tasa uri sae ta tii wane gwana ka rao fua roo wane baita 'e'ete ki sui. Lea nia liosau 'ana ta wane baita 'ana roo wane nai ki, tara nia kai lukasia ruana wane baita. Ma nao lea nia ka rao fuana ta tii wane baita 'ani keerua, tara nia kai lukasia ta ruana wane baita. Talafamolu lau gu nai, ne 'afitai molu ka rao sui gwamolu fua God ma fuana malefo.” ");
INSERT INTO bvd_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Nia 'uri nai, nau ku saea fuamolu, nao molu si manata sala sulia 'i fai ne si fanga ne molu kai 'ani ma si kafo ne molu kai kuufia kai lea mai faasia. Nao molu si manata sala sulia 'i fai ne tara si maku ne molu kai ofi ai kai lea mai faasia. Na mauria kamolu ki da 'initoa ka talua fange, ma na nonimolu ki ne da 'initoa ka talua si maku ni ofi lae. ");
INSERT INTO bvd_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","'O manata fasi 'amua sulia saaro loki 'i mamangaa. Kera nao dasi oofia guu tai ola ma ka nao dasi konia guu tai fanga ne maua uri lao tai luma ni alu fanga lae ki. Sui boroi 'ana, na Maa kamolu God 'i salo nia ka saare kera ki. Aia, ni kamolu naa ne God nia suamolu ka 'initoa talua saaro loki. ");
INSERT INTO bvd_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Na manata 'abarua lae sulia doo nai ki nia 'afitai ka adea ta wane 'amolu uri mauri lana ka lea tikwa lau. ");
INSERT INTO bvd_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Tee ne adea 'oko manata 'abarua 'asia naa sulia si maku uri ofi lae ai? 'O suana fasi 'amua na tae lana lalano taka diana loko ki lao gano. Kera nao dasi raoa ki guu, ma ka nao dasi tai maku ki guu fuada 'i tala'ada. ");
INSERT INTO bvd_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Sui boroi 'ana, nau ku faarongo kamolu, na kwanga lana takada ki 'e diana tasa ka talua maku kwanga baki waa 'inito bae sa Solomon kai ofi ki ai 'ana kada 'i nao. ");
INSERT INTO bvd_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","God nia suasuli diana 'uri nai 'ana lalano taka diana loko ki lao gano sui boroi 'ana mauri lada ki nao si tau guu. Loko da too 'i tari'ina sui 'i bobongi mai daka 'ui 'ani kera lao ere ka sarufi kera lau gwana. 'I seeri nia faatainia ne God nia kai suasuli diana 'ani kamolu ka tasa 'ani kera, suli ne God nia suamolu ka 'initoa talu kera fatai! Uri tee ne fiitooa 'oe 'ani nia ka tu'uu 'asia guu? ");
INSERT INTO bvd_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Doo ne adea guu, nao 'osi manata sala sulia doo nai ki ma 'oko 'urii, ‘Tee naa ne tara nau ku 'ani rowaa? Tee naa ne tara nau ku kuufia rowaa?’ Ma nao, ‘Tee naa ne tara nau ku ofi ai rowaa?’ ");
INSERT INTO bvd_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nao 'osi ade 'uri nai, suli na toaa ne kera nao lau toaa nia ki God, kera 'ana ne daka tola sulia doo nai ki. Ma ni 'oe ka nao lau, suli na Maa 'oe God 'i salo nia saitomana sui naa 'oe kwai 'atoi 'ana doo nai ki. ");
INSERT INTO bvd_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Si doo totolenao ne, 'oe nani 'amua burina 'initoaa nia God ma na 'o'oloa nia. 'Oe ade 'uri nai sui, tara nia 'ana ne kai falea mai doo ki sui guu ne 'oe kwai 'atoi ai lao mauria 'oe. ");
INSERT INTO bvd_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Doo ne adea guu, nao 'osi manata 'oroa sulia si doo ne 'oe kai kwai 'atoi ai 'afa dani ne nii 'ua kau. Alua si doo uri fa dani ne nii 'ua kau 'e too 'ana maasia fa dani nai 'ua guu. Nao 'osi 'abaa lau mai uri manata 'oroa lae lau sulia fai nia si doo 'i tari'ina ki. Suli fa dani ki sui guu da too sui naa 'ana si doo uri manata lae sulia ki ai.” ");
INSERT INTO bvd_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Sa Disas ka bae lau gu 'urii, “Nao 'osi keto ta'aa 'ana ta wane kau ade lea God ka keto 'oe faafia. ");
INSERT INTO bvd_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Suli na keto laa ne 'oe ketoa 'ana ta wane kau, nia lau gu ne God kai keto 'oe ai. Ma na taki tee ne 'oe ketoa ta wane kau sulia, taki nai lau gu ne God nia kai keto 'oe sulia. ");
INSERT INTO bvd_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nao 'osi roo gwamu 'ana sae lana toolamu faafia kasi garo laa tu'uu lao mauria nia ne mala gwana tasi lolo tu'uu 'asia guu ne nii lao maana, ma 'oko lio ekwa gwamu 'ana 'olosi lana na garo laa baita tasa ne nii lao mauria 'oe mala 'ana gaafana ta kada 'ai 'anafuli ne nii lao maamu! ");
INSERT INTO bvd_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ma 'i seeri 'oko bae 'amua 'urii fuana, ‘Alamatainia nau ku 'olosia kau si garo laa nai lao mauria 'oe waa nau.’ Aia ma sui ni 'oe, ka nao si 'oga 'oe guu uri 'olosi lana garo laa talingai neki lao mauria 'oe! ");
INSERT INTO bvd_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","'Oe waa suke 'urii! 'O 'olosia fasi 'amua garo laa neki lao mauria 'oe ne mala 'ana ta kada 'ai 'anafuli lao maamu uri mauria 'oe ka 'o'olo, sui fatai 'oe 'ofi 'olosia si garo laa lao mauria nia ta wane kau. ");
INSERT INTO bvd_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Nao 'osi falea doo abu ki fuana giri ki, ma ka nao 'osi 'ui 'ana si laungi 'oe 'i naofana boso ki, fasi ade lea kera daka dali saketoa gwada ma daka toriabulo fatai mai ma dafi 'ale 'oe uri ta'aa lae.” ");
INSERT INTO bvd_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Sa Disas ka bae lau gu 'urii, “'O gania God uri nia ka falea doo ne 'oe gania siana. 'O nani burina doo ne 'oe kwai 'atoi sia God uri 'oko dao toi. 'O kikidi kau uri nia ka 'ifi fuamu. ");
INSERT INTO bvd_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ade 'uri nai taari, suli toaa neki sui guu da gania God, kera da ngali doo neki da gani nia ki uria. Ma na toaa neki sui guu da nani burina doo ne kera kwai 'atoi ki ai sia God, kera da dao toi doo nai ki. Ma na toaa neki sui guu da kikidi, God nia 'ifi fuada. ");
INSERT INTO bvd_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Kamolu toaa neki sui guu molu too 'ana wele ki, tii 'amolu ne lea sae na wela 'oe nia gania fange siamu ma 'oko falea 'amua na maefau fuana? ");
INSERT INTO bvd_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma nao tii 'amolu ne lea sae na wela 'oe nia gania sakwari siamu ma 'oko falea 'amua na baekwa 'a'ale fuana? Si doo nai, 'oe 'afitai 'oko ilia 'ana wela 'oe! ");
INSERT INTO bvd_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Sui kamolu toaa abulo ta'aa nee boroi ne molu saitomana fale lana si doo diane ki fua wela kamolu ki. Aia, na Maa kamolu God 'i salo ne nia talu kamolu 'ana fale lana doo diane ki fua toaa ne da gani nia ki uria. ");
INSERT INTO bvd_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Aia, si doo diana ne 'oe dooria uri wane ki daka ilia fuamu, nia lau gu ne 'oko ilia fuana wane ki. Si baea nai naa ne dau faafia doo 'oro neki taki sa Mosis ma na bae lana brofet ki da bae sui gu mai sulia.” ");
INSERT INTO bvd_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Sa Disas ka bae lau gu 'urii, “'O ruu 'amua 'ana maesakaa susukafia nee, suli na maesakaa ma na taala reba nee nia lea uri lao maea totoo firi. Na 'ii lana tala reba nee nia walude 'asia naa ma na toaa 'oro 'asia naa daka 'iia naa. ");
INSERT INTO bvd_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Aia, na maesakaa ma na tala susukafia nee nia 'ana ne lea uri lao mauria firi ma na toaa neki kera dao toi kera nao dasi 'oro guu.” ");
INSERT INTO bvd_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Sa Disas ka bae lau gu 'urii, “Molu ka fiia na brofet kwaisukei ki da lea mai mala 'ana tai giri kwasi kwaisaungi ki, ne suana lada kau 'i sara kera na toaa diane ki mala 'ana sifsif diane ki. Ma sui ta, lao manata lada ki ne kera na giri kwasi ki 'o'olo guu uri saketo lamolu lae. ");
INSERT INTO bvd_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Na birangada ki ne tara kamolu molu kai lio saitomada ai lea sae kera toaa diane ki. Nia mala lau guu na fufuana 'ai ne wane nia kai lio saitomana 'ana 'ai lea sae nia na 'ai diane. Suli na wane nia 'afitai ka ngedaa fufuana greib faasia maa sarana ta 'oko bubulo. Ma nia 'afitai ka ngedaa fufuana fig faasia maa sarana ta 'ai bubulo gwana. ");
INSERT INTO bvd_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Na 'ai diane nia fungu lau guu 'ana fufuaedoo diane, ma na 'ai bubulo nia ka fungu lau guu 'ana fuaedoo bubulo. ");
INSERT INTO bvd_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Na 'ai diane 'afitai nia ka fungu 'ana fufuaedoo bubulo, ma na 'ai bubulo nia 'afitai ka fungu lau guu 'ana fuaedoo diane. ");
INSERT INTO bvd_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Na 'ai neki sui guu nao dasi fungu ki 'ana fuaedoo diane, tara da kai tabada sui guu 'i saegano, lea sui da kai 'ui sui guu 'anida lao ere. ");
INSERT INTO bvd_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aia nia 'uri nai, na birangana brofet neki ne tara kamolu molu kai lio saitomada ai lea sae kera na brofet diane ki mamana.” ");
INSERT INTO bvd_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Sa Disas ka bae lau gu 'urii, “Nao lau toaa neki sui guu da bae 'urii fuaku, ‘Aofia 'ae, Aofia,’ ne da kai ruu lao 'initoaa God. Na toaa ne da ilia lau 'ada doori lana Maa nau 'i salo ne da kai ruu lao 'initoaa nai. ");
INSERT INTO bvd_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Totoo nia dao 'afa dani 'ana keto lana toaa lao molaagali, na 'oro lana wane kera da kai bae 'urii fuaku, ‘Aofia 'ae, kameli toaa bae meli faarongo talo mai 'ana bae lana God 'ana satamu ne! Kameli toaa bae meli taria anoedoo ta'aa ki ma meli ka ilia doo kwaibalatana 'oro ki mai 'ana satamu ne!’ ");
INSERT INTO bvd_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ma sui boroi 'ana, nau tara kwai bae gwaku 'urii fuada, ‘Nau kwasi sasaitomamolu 'ua gu mai. Molu 'otolangai kamolu fasi nau, kamolu toaa ilidoo ta'aa nee!’ ");
INSERT INTO bvd_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Doo ne adea guu, na wane ne nia rongoa bae laku neki ma ka ade sulia, nia mala 'ana ta wane liona too ne nia tolea luma nia fafona fau lalifuu. ");
INSERT INTO bvd_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ne ta uta baita ka 'aru ma ta igwamela baita ka liu, ma ta koburu baita ka too, ma ka ngeotainia boroi luma nai ma nia ka ngilo ka too gwana suli ne da tolea fafona fau lalifuu. ");
INSERT INTO bvd_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Aia, ma na wane ne nia rongoa boroi bae laku neki ma ka nao si ade gu sulia, nia mala 'ana ta wane oewanea ne nia tolea gwana luma nia lao one kukusuu. ");
INSERT INTO bvd_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ne na uta baite nia 'aru, ma na igwamela baite nia liu, ma na koburu baite ka too, ma ka toea luma nai ma nia ka okosia ma ka lau tiifau ai.” ");
INSERT INTO bvd_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","'Ana si kada sa Disas nia toolangaidoo 'uri nai lelea ka sui naa, toaa nai ki da fafurongo nia daka kwele 'asia naa ");
INSERT INTO bvd_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","suli ne da lio saitomana sa Disas nia toolangaidoo 'ana rigitaa nia God. Ma nao nia si rongokwaisulii lau 'ana saitomadooa kera toaa toolangaidoo ki 'ana taki, ne da toolangaidoo gwada 'ana rigitaa kera ki tala'ada. ");
INSERT INTO bvd_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Si kada sa Disas nia koso na mai faasia gwauna si labusua nai, na konia baita nai daka lea na mai burina. ");
INSERT INTO bvd_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","'I seeri tii waa nai na furo 'ani nia ka lea mai ka booruru 'i maa 'aena sa Disas ka bae 'urii, “Aofia 'ae, lea sae 'oe ala gwamu faafia 'oko gura nau fasi wala.” ");
INSERT INTO bvd_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Sa Disas nia fale 'aba kau ka dau tona nonina sa wala nai ka bae 'urii, “Iuka, nau ku ala faafia. Alu nonimu nia diana 'ana.” 'Ana si kada nai 'ua guu, sa wala nai 'ali'ali nonina ka diana naa ma na furo nai ka sigi na faasi nia. ");
INSERT INTO bvd_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Sa Disas ka bae 'urii fuana, “Nao 'osi faarongoa ta wane 'ana si doo nai nau ku ilia fuamu nai. Si doo 'oe lea kau 'oko ilia fasi 'amua ne 'o faatainia nonimu siana wane ni foa nia God ma 'oko saea nia ka iro diana 'ana nonimu. Burina si doo nai sui 'oko falea na fale laa bae taki sa Mosis saea uri na wane ni foa ka lio faamamanea ma ka 'aitainia fuana toae ne nonimu nia diana mamana naa.” 'Uri nai sui sa Disas ka odua sa wala nai ka lea na 'ana. ");
INSERT INTO bvd_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Si kada sa Disas nia dao lao maefera 'i Kabaneam, ta tii waa baita nai lao omee kera fera 'i Rom nia lea mai ka dao siana sa Disas. Nia ka gania kwai'adomie siana sa Disas ");
INSERT INTO bvd_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ka bae 'urii, “Aofia 'ae, na wane ni rao nau nia nonina fii nia ka matai baita 'asia naa ka tio gwana mai luma kani.” ");
INSERT INTO bvd_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Sa Disas ka bae 'urii fuana, “Tara nau ku lea kau ku gura nia.” ");
INSERT INTO bvd_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Sa wala nai ka bae 'urii fuana sa Disas, “Wala Aofia 'ae, nau nao kwasi bobola fai nia sae ni 'oe waa baita 'urii lea mai 'oko ruu fatai 'i luma nau. 'O saea boroi 'amua mai tasi baea fuana wane ni rao nau uri faa 'akwaa lana. Lelea 'oe 'oko ade 'uri nai boroi 'amua tara nia ka 'akwaa gwana. ");
INSERT INTO bvd_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nau ku saitomana 'oe 'o tala'ana ili lana si doo nai, suli ni nau tala 'aku ku rao lau guu farana rigitaa kera waa baita nau ki. Ma ni nau lau guu, nau ku too 'ana rigitaa fuana wane ni firu ki ne nau ku lio suli kera ki. Suli lea si kada nau ku bae 'urii fua ta wane 'ani kera, ‘'Oe lea ilia fasi si doo 'urii,’ nia lea ka ilia naa. Ma nao lelea nau ku bae 'urii fua ta wane 'ani kera, ‘'Oe lea fasi mai seki,’ nia ka lea na mai 'afitai ka nao. Ma nao lea nau ku 'ai uri ta wane ni rao 'aku ma ku 'urii, ‘'Oe ilia fasi si doo 'urii,’ nia ka ilia naa 'afitai ka nao.” ");
INSERT INTO bvd_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Si kada sa Disas nia rongoa bae lana sa wala nai 'uri nai, nia ka kwele 'asia naa. Nia ka bae 'urii fuana konia nai da lea mai burina nai, “Ku faarongo mamana 'ani kamolu, lao fera 'i 'Israel, na kwaini manata mamana laa nao kwasi suai 'ua ai ne sa wala nee too ai nee. ");
INSERT INTO bvd_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nau ku faarongo kamolu, totoo boroi tara na toaa 'oro ne nao lau toaa Diu ki kera da kai lea mai fasi bali fera neki sui guu lao molaagali uri gooru kwaimani lae fai nia kokoo kolu ki mai sa 'Abraham, sa 'Aesak, ma sa Diakab 'ana fanga kwaimanie lao 'initoaa God. ");
INSERT INTO bvd_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ma 'ana si kada nai tara 'oro lana toaa Diu ki ne fulingana sae kera ne da kai too lao 'initoaa nai, God nia kai tari kera 'i sara uri lao kula 'ana rorodoa lae. Ma kera da kai too 'i seeri 'ana angia ma didilifoe.” ");
INSERT INTO bvd_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Sui sa Disas abulo ka bae 'urii fuana waa baita nai, “'Oe oli 'amu kau. Nau ku ilia naa si doo bae 'oe gani nau uria, suli ne 'oe 'o manata mamana 'ani nau kwai ilia fuamu.” 'Ana si kada sato nai 'ua guu na wane matai bae nia ka 'akwaa naa. ");
INSERT INTO bvd_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Aia, tii si kada sa Disas nia lea mai ka dao luma sa Bita, nia ka suana 'initai fungo sa Bita nia matai baita nonina ka balubalu 'asia naa ka too gwana. ");
INSERT INTO bvd_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Sa Disas nia ka dau tona 'abana 'initai nai ma 'asi kada nai 'ua guu nonina ka gwari 'ua guu. Nia 'akwaa 'uri nai nia tatae ka rao fanga naa fua sa Disas fai kera. ");
INSERT INTO bvd_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lelea kau nia dao 'i saulafi, toaa nai ki daka ngalia mai toaa 'oro ne anoedoo ta'aa ki nii ada ki kera daka ngalida mai siana sa Disas. Sa Disas nia ka bae ka taria anoedoo ta'aa nai ki faasida. Ma nia ka gura tiifau lau guu 'ana toaa da matai ki. ");
INSERT INTO bvd_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Si ade laa nai nia ka faamamanea naa si baea ne brofet 'Aesaea nia kedaa mai kada 'i nao, ne bae 'urii, “Nia ngalia naa mataia kolu ki, ma ka 'okoa naa makesoa kolu ki faasi kolu.” ");
INSERT INTO bvd_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Si kada sa Disas nia suana toaa 'oro nai da koni mai kali nia, nia ka bae 'urii fuana toa kwairooi nia ki, “Kolu toofolo fasi uri bali 'osi loko.” ");
INSERT INTO bvd_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","'I seeri, tii waa ni toolangaidoo nai 'ana taki ka lea mai ka dao siana sa Disas ka bae 'urii, “Waa ni toolangaidoo 'ae, nau ku dooria kwai lea naku fai 'oe uri mamalana kula boroi 'ana 'oe kai lea uria.” ");
INSERT INTO bvd_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Sa Disas nia rongoa bae lana sa wala nai, nia ka bae 'urii fuana, “Na giri kwasi ki da too 'ana foloa kera ki ni too lae ma na saaro ki 'i mamangaa daka too lau gu 'ana nui kera ki ni too lae. Nau 'Alakwa nia wane, nau nao 'aku ta beu ni too.” ");
INSERT INTO bvd_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ta wane 'ana toa kwairooi nia ki sa Disas ka bae lau gu 'urii, “Aofia 'ae, alu nau lea ku 'abarutainia fasi 'aku maa nau uri lelea nia mae nau ku saufini nia. Lea sui fatai nau kwafi oli mai uri ku lea naku fai 'oe.” ");
INSERT INTO bvd_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Sa Disas nia luua sa wala nai ka bae 'urii fuana, “'O lea na mai buriku, 'oko luka 'ana toaa nai ki nao dasi too 'ua 'ana maurie nai daka saufini kera na kau tala'ada.” ");
INSERT INTO bvd_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","'Uri nai sui, sa Disas ma na toa kwairooi nia ki daka tae lao baru nai daka lea naa. ");
INSERT INTO bvd_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ma si kada kera lea kau nao si tau 'asia guu, na koburu nai ka toe kera naa ma na nanafo baita 'asia naa ka kwaea naa baru nai fai kera ma 'i seeri na baru nai ka karangi kuruu naa. Aia, ma sa Disas ka maleu 'ana lao baru. ");
INSERT INTO bvd_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Na toa kwairooi nia ki sa Disas kera daka faa ada nia daka bae 'urii, “Wala Aofia 'ae! 'O faamauri kolu wala, ma kolu kai mae naa ne!” ");
INSERT INTO bvd_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nia ka bae 'urii fuada, “Nee rowaa, kamolu toaa ne fiitooa kamolu ki tu'uu 'asia guu, molu mau lau gu fai nia uri tee nee?” Nia bae 'uri nai fuada sui nia tatae ka ngatafia naa koburu ma na nanafo nai uri daru ka aroaro naa. 'Ana si kada nai 'ua guu, na koburu ma na nanafo nai daru ka enoeno naa. ");
INSERT INTO bvd_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Na toa kwairooi nia nai ki daka kwele 'asia naa. Ma daka bae 'urii, “Sa wala nee na kwaini wane tee nee rowane? Tee ne koburu ma na nanafo neki boroi ma daka ade gwada suli nia nee!” ");
INSERT INTO bvd_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Aia si kada sa Disas nia lea kau ka dao 'i bali 'osi loko 'ana maefera 'i Gadara, nia ka todaa roo wane nai ki na anoedoo ta'ae ki da burosi keerua. Keerua, daru too mai lao likwafau nai ki ni alu wane lae ki. Keerua daru susuala 'asia ki naa ma ka adea wane ki boroi nao dasi 'idu karangia naa kula nai keeru nii ai nai. ");
INSERT INTO bvd_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Si kada roo wane nai ki daru lio saitomana kau sa Disas, keerua daru ka akwa baita daru ka bae 'urii, “'Alakwa God 'ae, na tee ne 'oe dooria ili lana 'ani kameli nee? 'Oe alamia 'o lea na mai uri faanonifii lameli lae 'ana taue 'oto ne sui fatai kafi dao 'ana si kada bae 'ana nonifiie fuameli?” ");
INSERT INTO bvd_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aia na tii ferae boso ne kera da fanga karangi gwada 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","'I seeri na anoedoo ta'aa nai ki daka radi 'aena sa Disas daka bae 'urii, “Kameli dooria 'oko odu kameli 'amua uri lao boso loko ki.” ");
INSERT INTO bvd_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Sa Disas ka bae 'urii fuana anoedoo ta'aa nai ki, “Molu lea kau wala!” Anoedoo ta'aa nai ki da lea kau daka ruufia naa boso nai ki. 'I seeri na ferae boso nai tiifau da tafi kau daka 'asi kera toli sulia 'oba 'afitai nai uri lao 'osi nai. Ma kera daka kuu daka mae tiifau naa. ");
INSERT INTO bvd_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Na toaa nai ki da sangonia boso nai ki daka lae 'ali'ali naa uri lao maefera nai 'i seeri. Kera lae kau dao daka unu na sulia doo nai ki tiifau ma na doo nai 'e fuli 'ana roo wane nai ki anoedoo ta'ae ki burosi keeru mai nai. ");
INSERT INTO bvd_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","'I seeri, na toaa nai sui guu lao maefera nai daka lae tiifau mai uri suana lana sa Disas. Kera lae mai dao, daka odua naa sa Disas uri ka lea 'ana fasi bali fera kera nai. ");
INSERT INTO bvd_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Aia, sa Disas nia raa lao tii baru nai fai nia toa kwairooi nia ki kera daka toofolo lau gu mai 'ana 'osi Galilii oli mai daka dao naa 'ana maefera baita 'i Kabaneam si kula bae sa Disas nia too ai. ");
INSERT INTO bvd_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","'I seeri na wane ki daka ngalia mai tii waa nai nia tio funu naa lao ifitai nai lea mai daka dao fai nia siana sa Disas uri ka guraa. Si kada sa Disas nia lio saitomana faamamane laa kera toa nai, nia ka bae 'urii fuana sa wala nai da ngali nia mai nai, “Waa nau 'ae, nao 'osi manata sala guu. Nau ku manata lukea naa abulo ta'aa laa 'oe ki tiifau.” ");
INSERT INTO bvd_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","'Ana si kada nai 'ua guu, na toa toolangaidoo ki 'ana taki daka bae 'urii, “God taifili nia gu bae tala'ana manata luke lana abulo ta'aa lae ki. Ma sui, sa wala nee nia faabolatainia naa fai God nai!” ");
INSERT INTO bvd_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","'I seeri sa Disas nia ka bae fuana toa nai suli ne nia filoa gwana lioda ki, nia ka 'urii, “Kamolu, na manata lamolu nia garo ne molu ka manata ta'aa fuaku faafia si doo nai! ");
INSERT INTO bvd_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","“Si baea tee 'ana roo si baea 'urii ki ne nia walude 'asia guu uri sae lana fua sa wala nee? Bae lae 'urii fuana, ‘Nau ku manata lukea naa abulo ta'aa laa 'oe ki’, ma nao bae lae 'urii, ‘Tatae 'i langi 'o fali 'oko lea 'amua’? ");
INSERT INTO bvd_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Aia, uri kamolu molu ka lio saitomana ne nau 'Alakwa nia wane ku too 'ana rigitaa uri manata luke lana abulo ta'aa lae ki lao ano nee, nia ne.” Sa Disas oli ka bae na 'urii fuana sa wala nai 'afumae kwaea nai, “'O tatae 'i langi, 'oko ngalia ifitai 'oe 'oko lea 'amua fera kamu.” ");
INSERT INTO bvd_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ma sa wala nai 'e tatae 'i langi ka fali lae ka lea gwana 'i fera kera. ");
INSERT INTO bvd_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Si kada na konia nai da suana si doo nai fuli 'uri nai, kera daka kwele tasa ma daka mau. Ma kera daka tangoa God suli nia 'e faa mai rigitaa nia ka nii na 'ana toae. ");
INSERT INTO bvd_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Aia, sa Disas nia faasia 'i seeri nia lea gu kau nia ka liu siana tii waa nai satana sa Matiu, ne nia gooru gwana lao kasi babala tu'uu nai ni too lae ai uri koni lana malefo 'ana takis faasia toae ki. Sa Disas ka bae na 'urii fuana, “Lea na mai buriku.” Sa Matiu nia tatae gu ka lea na 'ana fai nia sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tii si kada 'i buri naa, sa Disas fai nia toa kwairooi nia ki kera lea kau daka fanga 'i luma nia sa Matiu. 'I seeri, tai toa 'oro ki lau guu 'ana koni lana malefo 'ana takis ma tai toaa abulo ta'aa 'oro ki lau guu kera daka fanga kwaimani sui guu fai nia sa Disas ma toa kwairooi nia ki. ");
INSERT INTO bvd_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ma si kada na Faarisii ki da suana sa Disas ma na toa kwairooi nia ki da fanga kwaimani fai toaa nai 'uri nai, kera daka bae 'urii fuana toa kwairooi nia ki, “Nia nao si too uri na waa toolangaidoo kamolu ka fanga kwaimani 'urii fai nia toaa abulo ta'aa nee.” ");
INSERT INTO bvd_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Sa Disas nia rongoa ne kera da bae 'uri nai, nia ka bae 'urii, “Toaa da too diana ki gwada nao dasi kwai 'atoi guu 'ana ta dokta. Toaa da matai ki lau 'ana ne da kwai 'atoi 'ana dokta. ");
INSERT INTO bvd_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Molu manata fasi sulia malutana si baea bae lao kekeda laa Abu bae nia 'urii, ‘Na kwai'ofei lae 'ana ne nau ku dooria 'asia naa ka talua afuafua kamolu ki.’ Nau nao kwasi lea mai uri 'ai lae uri toaa da 'o'olo. Na toaa abulo ta'aa ki lau 'ana ne nau ku lea mai uri 'ai lae uri kera uri daka bulasi manataa.” ");
INSERT INTO bvd_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Sui lau guu, toa kwairooi nia ki sa Dion waa faasiuabu bae da lea mai daka dao siana sa Disas daka bae 'urii, “Ni kameli ma na Faarisii ki lau guu meli kai abufanga ki. Ma sui 'utaa ne toa kwairooi 'oe ki ka nao dasi abufanga guu?” ");
INSERT INTO bvd_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Sa Disas nia luu kera ka bae 'urii, “Na wane kwaimani nia ki fungao 'afitai daka liodila 'ana si kada ne fungao nia too gwana siada. Sui boroi 'ana, tara nao si tau guu kera da kai talaia naa fungao faasia toa kwaimani nia ki. 'Ana si kada nai fatai ne kera da kai liodila ma da kai abufanga ai. Doo ne adea guu, nia 'afitai uri toa kwairooi nau ki daka abufanga 'ana si kada ne nau ku too 'ua gwaku siada.” ");
INSERT INTO bvd_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Sa Disas ka bae lau gu 'urii, “Nao si bobola uri daka ngalia si sii maku falu ma daka taia faafia si sufu laa 'ana si maku kwali. Lelea da ade 'uri nai ai, tara si kada kera taufia maku nai ma si maku falu nai ka lugu, tara sii maku falu nai kai muusia si maku kwali nai ma si sufu laa nai kai baita kai 'idu lau. ");
INSERT INTO bvd_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Na waen falu boroi nao si diana lau guu uri daka ongia lao kufidoo kwali. Lelea da ade 'uri nai, tara si kada na waen falu nai nia ngingisula nia kai bosea kufidoo nai. Si kada na kufidoo nai nia bose ma ka foga, na waen falu nai ka kisitai naa ma na kufidoo kwali nai daka 'ui na 'ada ai. Na waen falu daka ongia lau guu lao kufidoo falu uri na kufidoo nai ma na waen nai daru ka tio diana sui guu.” ");
INSERT INTO bvd_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Sa Disas nia bae 'ua gwana 'uri nai ki fuana toa kwairooi nia ki sa Dion, tii waa gwaungai nai fuana toaa Diu ki nia lea mai ka dao lau guu. Sa wala nai ka booruru maa 'aena sa Disas ka bae 'urii, “Na saari nau nia mae gwana 'i 'urii. Sui boroi 'ana, nau ku dooria 'oe lea mai 'oko alu 'aba faafi nia uri ka mauri 'ana.” ");
INSERT INTO bvd_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Sa Disas fai nia toa kwairooi nia ki kera daka lea na fai nia sa wala nai. ");
INSERT INTO bvd_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Si kada kera da lea kau 'uri nai, tii wela keni nai nia too mai lao 'o'ogangaa baita 'ana toimaa laa keni ki sulia tii taafuli fa ngali ma roo fa ngali sarenga ki, nia fali mai burina sa Disas ka samo toi tatagwarana maku tikwa nia sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Na wela keni nai nia manata 'urii, “Nau, saku samo toi tatagwarana boroi 'ana maku loko sa Disas, nau ku 'akwaa naa wala.” ");
INSERT INTO bvd_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Aia, si kada nia samo toi tatagwarana maku nai sa Disas, sa Disas nia toriabulo mai ka suana naa wela keni nai. Sa Disas ka bae 'urii fuana, “Saari nau 'ae, nao 'osi mau. 'Oe 'akwaa naa 'i nunufana manata mamana laa 'oe 'ani nau.” 'Ana si kada nai 'ua guu na 'o'ogangaa nia nai ka sui naa faasi nia. ");
INSERT INTO bvd_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Aia, si kada sa Disas fai nia toa kwairooi nia ki da ruu kau luma nia waa gwaungai nai, kera da suana toa nai ni ufi 'au lae nonina maee ma na toaa 'oro nai ki da koni mai daka too ni liodila laa 'ana maea nai 'i seeri ma daka angi alifii 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Sa Disas ka bae 'urii fuana toaa nai, “Kamolu toaa nee sui guu molu ruu fasi 'amolu 'i maa. Wela keni nee nao si mae gu ne. Nia maleu gwana.” Si kada toaa nai da rongo sa Disas nia bae 'uri nai, kera daka waela lau gwada 'ani nia. ");
INSERT INTO bvd_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Si kada sa Disas nia odua toaa nai 'i maa sui, nia oli ka ruu 'i luma ka rao uri 'abana wela keni nai. 'I seeri na wela keni nai ka sulatatae naa. ");
INSERT INTO bvd_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Burina si doo nai sa Disas ilia nai, na ununua sulia ka talofia naa bali lolofaa nai tiifau. ");
INSERT INTO bvd_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Aia, si kada sa Disas nia lea kau faasia luma nai, ta roo waa maada rodo nai ki daru ka lea lau gu kau burina. Keeru daru 'ai kau fuana sa Disas daru ka bae 'urii, “Wane na fuli sa Defet 'ae, 'o manatai kaaria mai!” ");
INSERT INTO bvd_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Sa Disas nia ruu ka nii na 'i luma ma na roo waa maarodo nai ki daru ka ruu lau gu kau 'i luma burina. Sa Disas ka ledi 'urii 'ani keerua, “Nee roo waa, kamuru muru manata mamana 'ani nau ne nau ku tala'ana gura lana maa muru ki?” Keerua daru luu nia daru ka bae 'urii, “Iuka Aofia, kaaria miri manata mamana ai.” ");
INSERT INTO bvd_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","'I seeri sa Disas ka samo toi maa daru ki ka bae 'urii, “Si doo nai nia fuli naa 'ani kamuru mala nai kamuru manata mamana ai nai.” ");
INSERT INTO bvd_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","'I seeri maa daru ki ka 'ifi daru ka lilio naa. Sui sa Disas ka lui fifii ai uri nao daru si faarongo lau ta wane 'ana si doo nai. ");
INSERT INTO bvd_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Sui, si kada keerua daru ruu kau 'i maa, keeru daru ka bae na 'adarua sulia sa Disas siana mamalana gwana wane ne keerua dao tona ki lao bali lolofaa nai. ");
INSERT INTO bvd_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Aia, si kada roo waa baki daru ruu kau 'i maa, tai wane ki daka ngali lau gu mai ta waa nai siana sa Disas. Na waa nai na anoedoo ta'ae 'e burosi nia ma na fakana ka 'ato. ");
INSERT INTO bvd_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Sa Disas ka taria anoedoo ta'aa nai faasia wane nai ma na waa nai ka bae lau gwana. Ma na toaa ne kera koni 'ana si kada nai, kera daka kwele 'asia naa ma daka bae 'urii, “Etana guu kolu suai si doo 'urii nai lao fera kolu nee 'i 'Israel ne rowaa!” ");
INSERT INTO bvd_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ma sui, na Faarisii ki daka bae buri 'ana sa Disas daka 'urii 'ada, “Na waa 'inito nia anoedoo ta'aa ki gwana loko ne falea rigitaa nee fuana sa wala nee uri tari lana anoedoo ta'aa neki nee.” ");
INSERT INTO bvd_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Si kada sa Disas nia liu 'ana maefera baita ki ma maefera tu'uu ki sui guu, nia toolangaidoo lao beu ni ofu laa ki. Nia ka faatalongainia si faarongoa diana nee sulia 'initoaa nia God. Nia ka guraa toaa na mataia 'e'ete kwailiu ki sui gwana saungi kera ki. ");
INSERT INTO bvd_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Sa Disas nia suana toaa nai ki nia ka manatai kera 'asia naa, suli ne da makeso ma ka nao dasi tala'ana 'adomi lada ki 'i tala 'ada. Kera da mala gwada na sifsif neki nao ta wane si sua gu sulida ki. ");
INSERT INTO bvd_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","'I seeri sa Disas ka bae 'urii fuana toa kwairooi nia ki, “Na toaa neki da mala 'ana ta fanga bae nia maua naa ma na wane fua koni lana ki ka nao dasi 'oro. ");
INSERT INTO bvd_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nia 'uri nai, molu gania God suli ne nia waa baita 'ana fanga nai, uri nia ka odua mai toaa ni koni doo ki fua lao raku nia.” ");
INSERT INTO bvd_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Sa Disas nia 'ailia akwala ma roo waa kwairooi nia ki uri daka lea mai siana uri nia ka falea mamanaa uri tari lana anoedoo ta'aa ki, ma uri gura lana mataia 'e'ete 'oro ki sui gwana 'i 'abada. ");
INSERT INTO bvd_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Na satada ki akwala ma roo 'aboosol nai ki ne: sa Saemon (ne da 'ailia lau guu 'ana sa Bita), fai toolana sa 'Andru, sa Demes ma sa Dion roo 'alakwa nia ki sa Sebedii. ");
INSERT INTO bvd_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Sa Filib, sa Baatolomiu, sa Toomas, sa Matiu waa fua koni lana malefo 'ana takisi, sa Demes 'alakwa nia sa 'Alfias, sa Tadeas, ");
INSERT INTO bvd_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","sa Saemon (waa 'ana toaa baki Diu bae da dooria tari lana toaa Rom faasia lao fera 'i 'Israel), ma sa Diudas 'Iskariot waa bae 'olea sa Disas fuana malimae. ");
INSERT INTO bvd_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Na akwala ma roo 'aboosol sarenga nai ki, sa Disas nia fale kera daka lea naa ma ka bae 'urii fuada, “Kamolu nao molu si lea siana toaa 'i sara ki ne kera nao lau Diu ki. Ma ka nao molu si lea lau guu 'ana maefera kera ki toaa Samaria. ");
INSERT INTO bvd_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Molu lea 'amolu siana toaa 'Israel ki ne da ilingia sifsif ne nia nao'ana naa. ");
INSERT INTO bvd_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Lea kau molu faatalongai fuada molu ka bae 'urii, ‘Na 'initoaa God nia nii karangi kamolu naa!’ ");
INSERT INTO bvd_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Molu lea molu ka guraa toaa matai ki ma molu ka taea toaa mae ki faasia maea. Molu guraa toaa ne furo nia saungi kera ki ma molu ka taria anoedoo ta'ae ki faasia wane. Suli ne God nia fale tatakwai gwana 'ana doo ki fuamolu, kamolu boroi molu ka fale tatakwai lau guu 'ana doo ki fua wane ki. ");
INSERT INTO bvd_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Na wane ne nia rao, tara kera da suasuli diana 'ani nia. Doo ne adea guu kamolu lea kau nao molu si manata sala lau uri sae sa molu ka dau fatai faafia tasi malefo fai kamolu. Nao molu si ngali wai, nao molu si ngali roo si maku, nao molu si ngali roo butu, ma ka nao molu si dau lau guu 'ana kubau. ");
INSERT INTO bvd_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Lea kau lea molu dao 'ana ta maefera baita ma nao 'ana ta maefera boroi, molu ka lio uria wane ne dooria kai talai kamolu uri luma nia. Si kada kamolu molu too 'i seeri siana, molu ka too ngado 'ana tii si kula lelea ka dao lau guu 'ana si kada molu faasia maefera nai molu ka lea lau. ");
INSERT INTO bvd_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Si kada kamolu molu dao 'i luma nai, molu ka bae 'urii fuana toaa 'i luma nai, ‘Ade dianaa nia God ma na aroaroa nia ka nii 'ana fai kamolu lao luma nee!’ ");
INSERT INTO bvd_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Lelea na wane nai nia wane ne dooria kai talai kamolu uri luma nia, na ade dianaa nai molu saea tara nia kai too fai kera. Ma lelea ka nao guu, na ade dianaa nai tara nia ka oli lau gwana fuamolu. ");
INSERT INTO bvd_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Aia, lea 'ana ta maefera kamolu molu dao ai, ma nao 'ana ta luma ne kamolu molu dao ai ma na toaa nai ka nao dasi talai kamolu guu 'i luma kera, ma daka ote kera guu 'ana rongo lana si baea nai molu bae sulia, molu ka lea faasia kula nai. Ma kada kamolu lea faasia, molu ka tafusia si lolo faasia 'aemolu ki 'i seeri uri ka mala 'u'uirodoe fuada ne God kai kwae kera, faafia ne kera ote kera 'ana rongo lana bae lana God. ");
INSERT INTO bvd_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Aia nau ku saea doo mamana fuamolu, totoo fa dani nai God kai falea kwakwaea fua toaa 'ana maefera ne 'i saegano, na kwakwaea ne nia kai faa fuana toaa nai ki kai baita tasa ka talua kwakwaea ne God kai faa fuana toaa abulo ta'aa baki lao roo maefera baki 'i Sodom fai nia 'i Gomora.” ");
INSERT INTO bvd_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Sa Disas ka bae lau 'urii, “Molu rongo fasi, nau ku fale kamolu na kau fua lao 'afitaie nai ma molu mala naa 'ana sifsif ki da lea matangana giri kwasi ki. Nia 'uri nai, molu lilio diana mala 'ana loi, ma molu ka ade marabibi lau guu mala 'ana bole. ");
INSERT INTO bvd_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Molu ka fiia waa ki, suli kera kai fale kamolu 'i 'abana toaa 'ana bae ofua ki uri kwae lamolu lao beu ni ofu laa kera ki. ");
INSERT INTO bvd_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kera kai ili uri nai 'amolu faafia ne molu kwairooi 'ani nau. Ma kada kera ili 'uri nai, molu ka faarongo 'ana faarongoa diana nee fua waa gwaungai ki ma waa 'inito ki ma fua toaa nao lau Diu ki. ");
INSERT INTO bvd_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kada kera karo kamolu, nao molu si manata 'a'abo sulia tee ne molu kai saea ma nao tara molu kai bae 'utaa sulia doo ki, sulia God 'ana ne kai falea fuamolu si doo ne molu kai saea 'ana si kada 'uri nai. ");
INSERT INTO bvd_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tara nao kamolu si bae lau taifili kamolu. Na Anoedoo Abu nia Maa kamolu 'i salo ne kai faabae kamolu. ");
INSERT INTO bvd_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Wane 'oro ki da kai falea toolada ki ne da manata mamana 'ani nau fua saumaeli lada, ma na wane 'oro ma ai 'oro ki da kai ade lau gu 'uri nai 'ana wela kera ki ne da manata mamana 'ani nau, ma na wela 'oro ki lau guu da kai ade 'uri nai 'ana maa kera ki fai gaa kera ki ne da manata mamana 'ani nau. ");
INSERT INTO bvd_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Toaa 'oro ki da kai susubutai kamolu, suli kamolu toaa nau. ");
INSERT INTO bvd_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Lea wane 'ana tii maefera kera ade ta'aa fuamolu, molu ka tafi, molu ka lea 'ali'ali 'amolu faasia maefera nai, ma molu ka lea lau 'amolu uria ta maefera 'e'ete. Nau ku saea fuamolu, tara maefera neki 'i 'Israel boroi nao molu si faasuia 'ua guu raoa kamolu ki ai, nau na 'Alakwa nia wane, ku dao na mai. ");
INSERT INTO bvd_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Aia, na waa ni rongo doo gwana, nia nao si baita talua waa ni toolangaidoo nia. Ma na waa ni rao nao si baita talua na waa 'inito nia. ");
INSERT INTO bvd_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nia bobola 'ua gu fai nia uri wane rongo doo ka usulia waa ni toolangaidoo nia, ma uri daka ilia lau gu si doo ne da ilia mai 'ana waa gwaungai 'ana waa ni rao nia. Nau waa gwaungai kamolu, lelea kera da 'aili nau naa 'ana sa Saetan waa gwaungai kera anoedoo ta'aa ki, ni kamolu toaa nau ki, tara kera da kai 'aili kamolu 'ana satae doo ta'aa ka tasa fatai.” ");
INSERT INTO bvd_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Sa Disas ka bae lau fuana toa kwairooi nia ki ka 'urii, “Nao molu si maungi kera, suli doo neki sui guu da saufinia ki tara God nia kai faatai folaa 'anida. Ma na doo agwa ki sui guu tara God nia kai bae folaa sulia. ");
INSERT INTO bvd_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ma si doo ne nau ku sae agwa ai fuamolu ki 'i lao rodo, molu ka sae folaa ai lao dani. Ma doo ne nau ku fuuarotainia fuamolu, molu kai bae folaa ai fuana wane ki sui. ");
INSERT INTO bvd_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ma nao molu si maungia waa neki da saungia nonidoo ma nao dasi saungia guu mangoedoo. Molu kai maungia lau 'amolu God, sulia nia ne bobola fai nia na saungi lana na mangoedoo ma na nonidoo lao era sasaru si mae. ");
INSERT INTO bvd_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ma na saaro tu'uu 'isi ki boroi, 'afitai fua tafa saaro 'ada ka 'asia 'i saegano lea na Maa kamolu 'i salo 'e nao si faolomainia guu. ");
INSERT INTO bvd_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Aia, ma kamolu boroi, na ifu 'ana gwaumolu ki, God nia saitoma tiifau gwai. ");
INSERT INTO bvd_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Doo ne adea guu, nao molu si mau suli God nia suamolu wane kamolu molu 'initoa 'i maana ka talua saaro tu'uu nai ki! ");
INSERT INTO bvd_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ma sa tii ne nia bae folaa naofana wane lao ano nee ne nia ta wane 'ana toaa nau ki, tara nau boroi kwai bae folaa lau gu suli nia siana Maa nau 'i salo. ");
INSERT INTO bvd_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma sa tii ne nia tofe nau 'i naofana wane lao ano nee, tara nau boroi kwai tofe nia lau guu siana Maa nau 'i salo.” ");
INSERT INTO bvd_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Sa Disas ka bae lau 'urii, “Nao kamolu si manata toi lau sae nau ku lea mai fai na aroraroe fuana fera ne 'i saegano. Nao nau kusi ngalia lau mai aroaroe. Nau ku lea mai uri sa tii ne nao si faamamane nau, nia kai firu fai nia na wane nau ki. ");
INSERT INTO bvd_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Toaa ki lao 'aebara nia wane gwana ne kera malimae nia ki. Suli wela wane asasa ki, kera kai firu fai nia maa kera ki. Ma na wela keni saari ki, kera kai firu fai nia gaa kera ki. Aia, na ai 'afe ki boroi, kera kai firu lau gu fai nia fungo keni kera ki. ");
INSERT INTO bvd_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ma sa tii gwana ne nia liosau 'ana maa nia, ma nao gaa nia ka talu nau, nia nao si tala'ana nia ka waa ni kwairooi nau. Ma sa tii gwana ne 'e liosau 'ana wela nia ki ka talu nau, nia nao si tala 'ana nia ka waa ni kwairooi nau. ");
INSERT INTO bvd_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nia 'afitai 'asia naa fua ta wane uri ka kwairooi mamana 'ani nau lea nia nao si noni maabe guu uri lea lae buriku sui boroi 'ana ta nonifiia ka dao tona, ma nao daka saungi nia ka mae 'ana 'airarafolo. ");
INSERT INTO bvd_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ma tii gwana ne nao si lea 'i buriku suli nia dooria ka ili 'ana suli doori lana 'i tala'ana, nia kai tala fasia mauria firi. Aia, ma tii gwana ne nao si ili suli dooria lana 'i tala'ana, ma ka noni maabe uri maeli lana lea lae 'i buriku, nia kai too 'ana mauria firi. ");
INSERT INTO bvd_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ma sa tii gwana ne nia talai kamolu 'i luma nia, nia talai nau lau guu 'i luma nia. Ma tii gwana ne talai nau 'i luma nia, nia talaia lau gu God ne fale nau mai 'i luma nia. ");
INSERT INTO bvd_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ma tii gwana ne nia talaia waa ne nia brofet 'i luma nia, nia kai ngalia lau gu kwaiaraa ne dai faa fua brofet ki. Ma tii gwana ne nia talaia waa ne nia 'o'olo 'i luma nia, nia kai ngalia lau gu kwaiaraa ne dai faa fua waa 'o'olo ki. ");
INSERT INTO bvd_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ma si doo mamana nau ku saea fuamolu 'e 'urii, tii gwana ne nia faa ta maekafo gwagwari boroi 'ana fua ta waa 'ana toaa ne kera toaa kwairooi nau ki, nia kai ngalia lau guu kwaiaraa uria, 'afitai ka nao.” ");
INSERT INTO bvd_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kada sa Disas 'e bae fuana akwala roo waa kwairooi nia ki sui, nia ka lea naa uri faatalongai lana si faarongoa diana nee ma toolangaidoo lae sulia, fuana toaa 'ana maefera kakalida ki lao bali lolofaa 'i Galilii. ");
INSERT INTO bvd_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","'Ana kada nai, sa Dion waa ni faasiuabu nia too 'i lao lookafo, nia ka rongo sulia raoa sa Disas Kraes nia ilia ki, ma sa Dion ka falea tai waa 'ana waa kwairooi nia ki daka lea siana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ma kera ka ledia, daka bae 'urii, “'Oe faarongo kameli mai. 'Uri nai ma 'oe naa ne na Kraes ne sa Dion saea kai dao mai, ma nao kameli kai maasia lau 'amelia ta waa lau?” ");
INSERT INTO bvd_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ma sa Disas 'e luu kera ka 'urii, “Kamolu oli 'amolu kau, molu ka faarongoa sa Dion 'ana doo ne kamolu rongoa ma molu ka suai ki nee. ");
INSERT INTO bvd_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Na toaa maarodo ki, kera da lilio lau. Ma toaa 'aeda mae ki, kera da fali lau. Ma toaa furo saketoda ki, nonida maafo lau. Ma toaa alinga boko ki, kera da rongo doo lau. Ma toaa kera mae ki naa boroi, kera da mauri lau. Ma na Faarongo laa Diana bae ne, nau ku bae na sulia fuana toaa neana ki. ");
INSERT INTO bvd_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","'E diana tasa fuana sa tii ne nao si manata ruarua suli nau.” ");
INSERT INTO bvd_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kada na waa kwairooi sa Dion ki kera oli naa, sa Disas ka bae sulia sa Dion fuana figua nai, ka 'urii, “'Ana si kada bae kamolu molu lea uria fafurongo lana sa Dion lao fera kwasi, nia kwaini wane tee bae molu suai 'ani nia? Nia wane manata ruarua mala gwana ta 'aba rade makubea ne gelogelo kwailiu lao 'ufu'ufu? Nia nao lau waa ta 'uri nai! ");
INSERT INTO bvd_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","'Uri nai, ma tee ne kamolu lea uri suai lae? Ta waa ne nia ofi 'ana maku ne foli lana baita? Nao! Sulia waa ne kera ofi 'uri nai ki, kera too 'ana beu waa 'inito ki. ");
INSERT INTO bvd_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kamolu faarongo nau mai. Tee ne kamolu lea kau uri suai lae? Ta brofet? Iuka! Nia ta brofet mamana lau guu! Ma nia talua fatai na brofet 'i nao ki sui guu. ");
INSERT INTO bvd_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Sa Dion naa bae kera kekeda sulia lao kekeda laa Abu 'ana kada God nia bae sulia na Kraes ka 'urii, ‘'O rongo fasi, nau kwai falea kau na wane ni ngali baea nau 'i nao 'amu, fasi uri nia kai ade akau 'ana wane ki fuamu.’ ");
INSERT INTO bvd_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Si doo mamana nau ku saea fuamolu nia 'urii, sa Dion wane faasiuabu bae nia 'initoa ka talua wane ki sui lao fera ne 'i ano. Ma sui ta, na wane mala nia gwana lao 'initoa God, nia 'initoa ka talua lau sa Dion. ");
INSERT INTO bvd_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Aia, na 'initoaa God na wane ta'aa ki da alasia ma daka sasi uri lau lana 'ita 'ua mai 'ana si kada sa Dion nia safalia faarongo 'ana si faarongoa diana nee lelea mai ka dao 'i tari'ina. ");
INSERT INTO bvd_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Na taki sa Mosis ki, ma na brofet ki sui guu lelea mai ka dao 'ana kada sa Dion, kera bae daka toolangaidoo sulia dao lana mai na Kraes. ");
INSERT INTO bvd_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kera saea sa 'Ilaeja na brofet kai oli lau mai 'i nao 'ana Kraes. Ma nia diana fuana kamolu ka faamamanea ne sa Dion talafana sa 'Ilaeja naa ne. ");
INSERT INTO bvd_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","'Oe waa ne 'o too 'ana alingamu, 'o rongo doo nai ki 'oko rongo diana ai.” ");
INSERT INTO bvd_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ma sa Disas ka bae lau 'urii fuada, “Nau kwai faabolatainia fuamolu na too lamolu toaa 'i tari'ina, kamolu ilingia na wela tu'uu ki ne kera koni 'i maana usie 'ana roo konie ki. Ma daka 'ai kwailiu fuada, ");
INSERT INTO bvd_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Kameli ufi 'au, ma kamolu ka nao si wae guu sulia. Ma kameli ka nguulia nguu 'ana maea ki fuamolu, ma ka nao molu si liodila guu.’ ");
INSERT INTO bvd_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kada sa Dion waa ni faasiuabu nia dao mai, nia abufanga, ma ka nao si kuufia ta waen, kera ka saea sae nia too 'ana anoedoo ta'aa. ");
INSERT INTO bvd_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Sui, si kada nau na 'Alakwa nia Wane ku dao mai ma ku fanga ma ku kuu kwaimani fai nia wane ki, kamolu molu ka bae lau guu 'urii, ‘Suana 'amolua na wane fanga baita ma ka kuu waen baita nee wala! Sa wala nee nia ruana kera gwana toaa ni koni malefo lae 'ana takisi ma tai toaa abulo ta'aa ki lau gu ne!’ Sui boroi 'ana, toaa ne kera ade sulia na liotooa God, kera faatainia ne God nia mamana.” ");
INSERT INTO bvd_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Burina sa Disas bae 'uri nai ka sui, nia ka safali bae talea naa maefera bae nia ilia mai doo kwaibalatana 'oro baki ai, sulia toaa 'ana maefera nai ki kera nao dasi bulasi manataa faasia abulo ta'aa laa kera ki. ");
INSERT INTO bvd_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Sa Disas ka bae 'urii, “Na ta'aa laa baita tasa fuamolu toaa nee 'ana maefera 'i Koresin. Ma kamolu toaa 'i Betsaeda ka 'uri nai lau guu. Sulia kamolu si faamamanea doo kwaibalatana 'oro baki nau ku ilia fuamolu. Nau lea saku ilia mai doo kwaibalatana nai ki 'i Taea fai nia 'i Saedon, na toaa nai ki kera daka toobili ma daka kakano 'ana fue, uri ka faatainia kera bulasi manataa faasia abulo ta'aa laa kera ki. ");
INSERT INTO bvd_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Doo mamane ne nau ku saea fuamolu, 'afa sato God kai kwaea toaa 'ana fera ne 'i saegano, na kwakwaea kamolu kai talua toaa 'i Taea fai Saedon ki. ");
INSERT INTO bvd_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Aia, kamolu na toaa 'i Kabaneam, kamolu kwaifii sae sa God kai tafo kamolu uria 'i langi. Sui ma, nia kai 'ui lau 'ana 'ani kamolu 'i lao kilu 'ana nonifiia. Sulia na doo kwaibalatana bae nau ku ilia 'i fera kamolu ki, lea saku ilia mai 'i Sodom, 'uri nai tara toaa 'i Sodom ki kera da bulasi manataa naa, ma God nao si faafunuia toaa kera ki. ");
INSERT INTO bvd_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nia ne, nau ku saea fuamolu, 'afa dani nai God kai kwaea toaa 'ana fera ne 'i saegano, na kwakwaea kamolu kai talua toaa 'i Sodom.” ");
INSERT INTO bvd_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","'Ana kada nai, sa Disas 'e foa ka bae 'urii, “Maa 'ae, 'oe 'o gwaungai 'ana doo ki sui guu 'i langi ma 'i saegano lau guu. Nau ku tango 'oe, sulia 'o faatainia 'initoaa 'oe fuana toaa ne kera uria wela tu'uu ki, ma 'oko saufinia doo neki faasia toaa kera tangoda sulia kera saitoma doo, ma kera ka lio filoa doo 'oro ki. ");
INSERT INTO bvd_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Iuka Maa 'ae, na doo nai ki nia 'uri nai naa sulia na kwaidooria 'oe 'uana mai 'i nao.” ");
INSERT INTO bvd_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ma sa Disas ka bae 'urii 'i naofana konia nai, “Maa nau nia alua doo ki sui guu 'i 'abaku. Ma nao ta wane lau si saitomaku guu, taifilia gu Maa nau ne nia saitomaku nau 'Alakwa nia. Ma ka nao ta wane lau si saitomana Maa nau, taifili nau 'Alakwa nia gu ne ku saitomana Maa nau. Ma taifilia guu toaa ne nau 'Alakwa nia ku fili kera uri ku faatainia Maa nau siada, kera gwana ne da saitomana Maa nau. ");
INSERT INTO bvd_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Na toolangaidooa ne toa toolangaidoo ki 'ana taki sa Mosis da falea fuamolu nia adea molu ka ngali kulua 'asia molu ka laeororo 'i farana. Molu lea mai siaku, uri nau kwai ngalia faasia kamolu. ");
INSERT INTO bvd_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Molu too farana si baea nau ki ma molu ka ngalia toolangaidooa nau ki fuamolu, suli ni nau birangaku 'e salasala ma ka walude, ma kamolu kai dao tona momola lae fua mangomolu. ");
INSERT INTO bvd_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sulia na kwaitalai laa nau fuamolu, nia walude fua lea lae sulia.” ");
INSERT INTO bvd_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","'Ana tii fa dani sabat nai, sa Disas fai nia toa kwairooi nia ki kera lea daka liu lao tii ola nai 'ana wiiti. Ma 'i seeri, na toa kwairooi nia ki kera daka fiolo 'asia naa ma daka falia fungidoe ki, ma daka dau 'ana 'ani lana kau. ");
INSERT INTO bvd_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ma 'i seeri tai wane 'ana Faarisii ki daka suada. Ma daka ngatafia sa Disas daka bae 'urii, “'Oe nao 'osi suai gwamu nee? Si doo ne toa kwairooi 'oe ki da ilia nee nia 'oia si baea nia taki bae nia luia nao dasi rao 'ana fa dani Sabat!” ");
INSERT INTO bvd_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Sa Disas 'e luu kera ka 'urii, “Kamolu alamia nao molu si teemainia gu Buka Abu sulia si doo bae sa Defet fai nia ruana nia ki da ilia kada 'i nao 'ana si kada bae kera da fiolo mae 'asia naa bae 'oto? ");
INSERT INTO bvd_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","'Ana si kada bae, sa Defet nia ruu lao raa'ai nia God ma na waa foa ni gwau ka ngalia mai beret bae da kai alu 'e'ete ki ai talea God ma ka fale fua sa Defet. Ma 'i seeri sa Defet nia ngalia beret bae ka tolingia fua nia fai nia ruana nia ki daka 'ania. Ma sui na beret nai, taifilia guu waa foa ki bae nia walude fuada uri 'ani lana. Sa Defet kera da ade 'uri nai, sui boroi 'ana kera nao dasi garo 'i naofana God.” ");
INSERT INTO bvd_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Sa Disas ka bae lau gu 'urii fuana Faarisii nai ki, “Ma alamia kamolu nao molu si teemainia gu lao Buka Abu sulia na waa ni foa ki ne kera da kai rao lao beukaua nia God 'afa dani Sabat ki sui gu 'oto? Kera waa ni foa ki da ade 'uri nai, sui boroi 'ana kera nao dasi garo gu 'i naofana God. ");
INSERT INTO bvd_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Aia ni nau ku sae mamana ai fuamolu, tii doo ne baita ka talua fatai na Beukaua nai God ne nii na 'i seki siamolu. ");
INSERT INTO bvd_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Na bae lana God nia bae 'urii, ‘Nau ku dooria 'asia naa uri molu ka faatainia kwai'ofeie fuana wane ki. Nao lau na afuafue ki ne nau ku dooria.’ Si baea nai lea sae kamolu molu saitoma diana 'ana si doo nai nia saea nai, kamolu 'afitai molu ka sae garo lana guu toa kwairooi nau neki ne kera nao dasi ilia guu tasi doo ne garo 'i naofana God nee. ");
INSERT INTO bvd_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Aia, ni nau 'Alakwa nia Wane, nau naa ne ku 'inito fua dani sabat.” ");
INSERT INTO bvd_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ma si kada sa Disas nia lea na kau faasia 'i seeri, nia lea kau ka ruu lao beu ni ofu laa kera. ");
INSERT INTO bvd_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ma tii waa nai 'abana mae nia nii lau gu lao beu ni ofu laa nai. Ma 'i seeri, tai wane ki daka ledia sa Disas daka 'urii, “Nee wala, ma nia mola gwana uri daka guraa ta wane ne nia matai 'ana fa dani Sabat?” Kera da ledi nia 'uri nai, uri sae nia ka saea tasi doo ne 'oia bae lana taki sulia sabat uri kera daka keto nia faafia. ");
INSERT INTO bvd_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","'I seeri, sa Disas nia luu kera lau guu ka 'urii, “Molu faarongo nau fasi. Lea sa 'oe ta wane, na sifsif 'oe nia 'asia lao kilu 'afa dani Sabat, 'oe 'oko ekwatainia ka tio gwana lao kilu nai? Nia 'afitai 'asia naa uri sae 'oko ade gwamu 'uri nai 'ana sifsif 'oe. ");
INSERT INTO bvd_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ma sui, na wane ne God nia suana ka 'initoa tasa talua na sifsif. Doo ne adea guu, nia nao si garo guu fuana ili lana si doo ne diana uri 'adomi lana wane 'afa dani Sabat.” ");
INSERT INTO bvd_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","'I seeri guu sa Disas ka bae na 'urii fuana wane 'abana mae nai, “'O tagaa kau 'abamu.” Na waa nai ka tagaa na 'abana. Ma 'ana si kada nai 'ua guu bali 'aba mae nai ka mauri lau gwana mala 'ana ruana bali 'aba nia nai 'e diana nai. ");
INSERT INTO bvd_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Na Faarisii ki da suai gu si doo nai, kera daka ruu na 'ada 'i maa fasi lao beu ni ofu laa nai. Ma kera lea daka bae ofu naa uri alu tii manataa lae uria saumaeli lana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Si kada sa Disas nia rongoa ne kera da alaofu sui naa uri saungi lana, nia ka lea na faasia si kula nai. Na toaa 'oro nai ki daka lea naa burina sa Disas, ma nia ka guraa toaa 'oro ne da matai ki 'ani kera ma kera daka 'akwaa tiifau. ");
INSERT INTO bvd_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Sa Disas nia ka bae kwailuii fuada uri kera nao dasi faarongoa lau ta wane 'ani nia sa tii nai. ");
INSERT INTO bvd_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Si kada si doo nai nia fuli 'uri nai, nia ka faamamanea naa si baea nia God ne brofet 'Aesaea nia saea 'uana mai kada 'i nao ka 'urii: ");
INSERT INTO bvd_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Suana fasi na wane rao nau nee. Nau ne ku filia uri ili lana raoa nau. Nau ku liosau 'ani nia ma ku ele suli nia ka tasa. Ma ni nau kwai falea Anoedoo Abu nau faafi nia, ma ni nia kai bae folaa sulia 'o'oloe fuana toaa nao lau Diu ki. ");
INSERT INTO bvd_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nia tara nao si firufiru ma si akwa rakesasu fua wane ki, ma ka 'afitai uri daka rongo bae baita lana matangana toae ki. ");
INSERT INTO bvd_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nia nao si lukatainia toaa neana ma toaa makeso ki. Nia kai ade 'uri nai lelea ka dao gu 'ana si kada nia kai faatainia 'o'oloa ne kai 'etengaa fere ki sui guu. ");
INSERT INTO bvd_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Sa wala nai ne toaa nao lau Diu ki kera da kai alua manata ngado laa kera 'ani nia.” ");
INSERT INTO bvd_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sui lau guu, tai wane kera daka ngalia mai tii wane nai siana sa Disas uri gura lana lau guu. Wane nai, anoedoo ta'ae nii 'ani nia 'e adea maana ka rodo ma fakana ka 'ato lau guu. Sa Disas guraa sa wala nai, ma nia ka lilio ma ka bae lau gwana. ");
INSERT INTO bvd_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Na konia nai da suai 'uri nai daka kwele 'asia naa ma daka ledi kera kwailiu 'urii, “Alamia sa wala nee nia na waa fifilia nia bae God gwana ne? Bae da saea mai totoo nia kai futa lao kwalafaa sa Defet?” ");
INSERT INTO bvd_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Si kada tai toa 'ana Faarisii ki da rongoa si doo nai, kera daka bae 'urii, “Sa wala nee nia taria na anoedoo ta'ae ki 'ana rigitaa nia sa Belsibul na akalo gwaungai kera bae akalo ki ne!” ");
INSERT INTO bvd_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Sa Disas nia saitomana gwana manata lada ki, nia ka bae 'urii fuada, “Lea na toaa 'ana tii fera guu, ma nao 'ana tii maefera baita guu, ma nao 'ana tii bara wela guu da toli ma daka firu 'i matangada tiidoe gwana, na tooa nai nia 'asia. ");
INSERT INTO bvd_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Na 'initoaa nia sa Saetan nia 'uri nai lau guu. Lea sa Saetan nia firu fai nia toaa nia lau gwana 'i tala'ana, tara na 'initoaa nia ka 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Aia, ma lea sae nau ku taria gwaku anoedoo ta'aa ki 'ana rigitaa nia sa Saetan, sui 'uri nai sa tii 'ana ne falea rigita lae fuana toaa kamolu ki ne daka taria anoedoo ta'aa ki? Sa Saetan ma nao sa tii? Doo ne faatainia guu ni kamolu molu garo nai! ");
INSERT INTO bvd_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","“Na rigitaa nia Anoedoo Abu God 'ana ne nau ku taria anoedoo ta'ae ki ai nee. 'I seeri nia faatainia naa ne 'initoaa nia God nia safali rao naa 'i matangamolu 'i tari'ina. ");
INSERT INTO bvd_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“'Afitai ta wane lea ka ruufia gwana luma nia ta ramo uri ngali lana doo diana nia ki faasi nia lea nao si kania guu 'abana ramo nai. Aia ma lea ta ramo na tetede lana ka talua lau tetedea nia ramo nai, nia saitomana ka kania gwana 'abana ramo nai lea sui nia lea ka ngalia gwana doo nia nai ki faasi nia. 'I seeri na wane ne nia taria anoedoo ta'aa nee 'urii, na tetedea nia 'e talua sa Saetan. ");
INSERT INTO bvd_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Tii ne nao si lea kwaimani fai nau, nia malimae 'ani nau. Ma tii ne nao si rao kwai'adomi fai nau, nia waa fua rao kwaisuusi lae fuaku. ");
INSERT INTO bvd_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Doo ne adea guu, nau ku saea fuamolu, abulo ta'aa lae ki sui guu ma si doo ta'aa neki sui guu wane kai saea ki, God saitomana kai manata lukea gwana. Tii ne nia saea tasi doo ta'aa fuaku nau 'Alakwa nia Wane, God saitomana kai manata lukea gwana. Ma sui ta, tii ne nia saea si baea ta'ae talea Anoedoo Abu, tara 'afitai God ka manata luke nia 'i lao molaagali ai nee, ma nao lao molaagali ai ne nii 'ua mai boroi.” ");
INSERT INTO bvd_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Sa Disas ka bae lau 'urii, “Na diana lana 'ai ne kera dao toi 'ana fufuaedoo ne nia fungu ai. Na 'ai diane ne nia ka fungu 'ana fufuaedoo diane ki. Ma na 'ai ta'ae, nia ka fungu lau guu 'ana fufuaedoo ta'ae ki. Na wane boroi nia 'uri nai lau guu. Sulia na doo diane ki lea mai faasia na wane diane ki, ma doo ta'aa ki ka lea lau gu mai faasia na wane ta'aa. ");
INSERT INTO bvd_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ma kamolu mala guu 'amolu kalena na baekwe 'i tolo ki! Ma 'afitai tasa kamolu ka saea ta doo ka diana, sulia na manata laa kamolu ki nia ta'ae. Tee ne nia too mai lao manata lana wane, nia ne 'e sakatafa mai nia ka saea. ");
INSERT INTO bvd_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Na wane ne diana, na bae lana boroi 'e diana lau guu. Ma na wane ne ta'aa, na bae lana boroi 'e ta'aa lau guu. ");
INSERT INTO bvd_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Nau ku saea fuamolu, 'afa sato ne God nia kai falea kwakwaea fua molaagali, wane ki tiifau naa kera da kai bae suli kera 'i maana God sulia na bae ata laa ne kera da ilia ki sui guu. ");
INSERT INTO bvd_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","'I seeri na bae lamu wane nia kai talai 'oe fua lao dianae, ma na bae lamu lau guu nia kai talai 'oe fua lao kwakwaee.” ");
INSERT INTO bvd_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Sui tai wane toolangaidoo ki 'ana taki ma tai Faarisii, kera lea mai siana sa Disas, kera ka bae 'urii fuana, “Waa toolangaidoo 'ae, kameli dooria 'asia naa 'oe 'o ilia fasi tasi doo kwaibalatana, uri ka faatainia mamanaa God ne fale 'oe mai.” ");
INSERT INTO bvd_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Sa Disas ka bae 'urii fuada, “Kamolu toaa nee 'i tari'ina kamolu na toaa ta'ae ma na toaa abu faamamane. Kamolu molu dooria gwamolu sua lana doo kwaibalatana ki faatai lana mamanaa God, ma sui boroi nia kai 'afitai fuamolu uria sua lana. Kamolu kai suai guu 'amolu na doo kwaibalatana bae nia fuli 'ana sa Dionaa brofet kada 'i nao. ");
INSERT INTO bvd_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sa Dionaa bae too lao rakena gwaasasu sulia olu maedani ma olu fa rodo ki. Aia, ma nau, na 'Alakwa nia Wane, nau kwai 'uri nai lau guu. Nau kwai too lao saegano sulia olu maedani ma olu fa rodo ki lau guu. ");
INSERT INTO bvd_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ma 'ana kada God kwaea toaa ki sui, na toaa 'i Ninifaa, kera kai tatae uri kera ka bae sulia na garoa kamolu ki. Kera ili 'uri nai, sulia kera da bulasi manataa faasia garoa kera ki kada sa Dionaa bae fuada. Ma tii waa talingai ka talua sa Dionaa nia nii na fai kamolu. Ma sui ka 'uri nai boroi, nao kamolu si bulasi manataa guu faasia na abulo ta'aa laa kamolu ki. ");
INSERT INTO bvd_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ma kada nai God kai kwaea toaa ki, na ai 'inito bae 'i Siba, nia kai tatae lau guu uri bae lae sulia na garoa kamolu. Na wela keni nee nia ilia 'uri nai, sulia nia lea mai faasia toaa nia ne tau 'asia naa uri rongo lana liotooa sa Solomon na waa 'inito. Ma tii wane talingai ka talua sa Solomon nia too gwana fai kamolu. Sui ka 'uri nai boroi 'ana, nao kamolu si dooria guu rongo lana.” ");
INSERT INTO bvd_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Sa Disas ka bae 'urii lau, “Kada kera taria anoedoo ta'aa nia ka lea faasia ta wane, nia ka kali lao fera kwasi, ma ka nani uria ta kula uri nia kai too lau ai. Ma lea nia nani ma ka nao naa, ");
INSERT INTO bvd_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nia kai manata 'urii, ‘Nau ku oli 'aku uria na wane bae nau ku too mai 'ani nia 'i nao sui ku lea mai faasia.’ 'Ana kada nia oli mai ka dao, nia ka liotoi wane bae nia tagisia ma ka 'olosia naa mauri lana tiifau. ");
INSERT INTO bvd_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kada nia liotoi ne nia 'uri nai, nia ka oli ma ka talaia lau mai ta fiu anoedoo ne ta'aa ka tasa talu nia, kera ka lea mai, ma kera ka too lau 'ana wane bae. 'Ana kada nai, na toolana wane bae 'e ta'aa kafi talua lau 'i nao. Ma nia ka 'uri nai lau guu fuamolu toaa abu faamamane neki 'i tari'ina.” ");
INSERT INTO bvd_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","'Ana kada sa Disas nia bae 'ua fuana toae ki, gaa nia fai nia toolana ki kera ka dao daka uu gwada 'i maa. Ma kera ka bae mai uri nia uri kera ka bae fai nia. ");
INSERT INTO bvd_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ma tii wane 'ana wane nai ki ka bae 'urii fuana sa Disas, “Gaa 'oe fai nia toolamu ki, kera dao daka uu gwada mai 'i maa, ma daka doori bae fai 'oe.” ");
INSERT INTO bvd_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Sa Disas luuda ka 'urii, “Nau ku saea fasi sa tii fai kera ne gaa nau ma na toolaku ki.” ");
INSERT INTO bvd_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","'Ana kada nai, sa Disas 'e susuia toa kwairooi nia ki, ma ka bae 'urii, “Molu liotoi fasi. Kera ne kera mala naa gaa nau ki ma toolaku ki ne. ");
INSERT INTO bvd_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sulia sa tii ne ilia kwaidooria nia Maa nau 'i salo, nia ne toolaku ki, fai nia waiwane nau ki, ma gaa nau ki.” ");
INSERT INTO bvd_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","'Ana tii fa dani nai gwana, sa Disas nia ruu 'i maa fasi lao luma nai da nii lao na, nia ka lea kau ka gooru 'i saegano uri toolangaidoo lae 'i ninimana 'osi bae. ");
INSERT INTO bvd_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ma na konia baita tasa nai daka koni kali nia. 'I seeri nia ka raa lao tii baru nai, ma na konia nai daka uu kau 'i sara sulia malitikwa nai. ");
INSERT INTO bvd_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nia ka bae fuana konia nai sulia doo 'oro 'ana tarifula lae ki, ka bae 'urii, “Tii wane nia lea ka afusia migana wiiti lao ola nia nai. ");
INSERT INTO bvd_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ma si kada nia afusia migana wiiti nai, tai miga wiiti daka 'asia sulia taala ni liu lao ole ma na saaro ki daka lofo mai daka 'ani tiifau gwada ai. ");
INSERT INTO bvd_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ma tai miga wiiti daka 'asia 'i otofana fau ki kula si saegano 'e rauraua gwana ai. Kera daka tae 'ali'ali gwada lao si saegano rauraua nai. ");
INSERT INTO bvd_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ma si kada na sato nia tae mai ka satofida kera daka kuku lau gu 'ada, suli lalida ki nao dasi sifo dasi lea tau guu. ");
INSERT INTO bvd_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tai miga wiiti ki lau daka 'asia 'i matangana migana lalano kwakware ki, ma si kada lalano nai ki da tae mai daka buru na faafia wiiti nai. ");
INSERT INTO bvd_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ma tai miga wiiti ki daka 'asia naa 'i lao si saegano diane, ne kera daka tae ma daka alua fange. Tai wiiti daka fungu 'ana tii talanga fuaedoo ki, tai doo daka fungu 'ana ono taafuli fuaedoo ki, ma tai doo lau daka fungu 'ana olu taafuli fuaedoo ki.” ");
INSERT INTO bvd_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ma sa Disas ka faasuia bae lana ka 'urii, “'Oe waa ne 'o too 'ana alingamu, 'o rongo doo nai ki 'oko rongo diana ai.” ");
INSERT INTO bvd_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Na toa kwairooi nia ki da lea mai siana daka ledi 'urii 'ani nia, “Nee wala? Tee ne adea lea 'oe bae fuana konia neki ma 'oko tarifula ki sui guu?” ");
INSERT INTO bvd_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Sa Disas nia luu kera ka bae 'urii, “Ni kamolu 'ana ne God nia faatainia sui naa malutana 'initoaa God fuamolu. Aia ma na toaa nee sui gwana ne kera nao lau toaa kwairooi nau ki, nau nao kwasi faatainia doo nai ki fuada. ");
INSERT INTO bvd_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tii ne saitomadooa nia tu'uu gwana 'ana malutana 'initoaa ne 'i salo, God tara nia kai faafonosia uri waa nai ka too lau 'ana saitomadooa baita tasa 'ana malutana 'initoaa ne 'i salo. Ma tii ne nia nao si dooria guu saitomadooa nai, kasi saitomadooa ne nia ka too boroi ai sulia 'initoaa ne 'i salo, God nia kai ngalia faasia wane nai. ");
INSERT INTO bvd_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Doo ne adea nau ku tarifula sulia doo ki fuada nia 'urii: Sui boroi 'ana kera daka liotoi doo ki, kera nao dasi lio saitomana guu. Ma sui boroi 'ana kera daka rongoa baea laku, kera nao dasi saitomana guu. ");
INSERT INTO bvd_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Si baea nia God ne brofet 'Aesaea nia saea mai 'ana kada 'i nao nia fuli mamana naa 'ana toaa nee, bae nia bae 'urii, ‘Kamolu tara molu ka fafurongoa boroi bae laku 'ana kada 'oro tara lelea nao molu si saitomana guu doo ne ku saea ki. Ma ni kamolu 'ana kada 'oro tara molu ka bubungia boroi doo neki ku ilida ki tara lelea nao molu si lio saitomana ki guu. ");
INSERT INTO bvd_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Suli na liomolu ki da sadi naa ma na alingamolu ki daka 'afitai naa uri rongo lana doo ki. Lea sae nao si 'uri nai, na maa molu ki ka folaa, ma na alingamolu ki daka 'ifi ma ni kamolu molu ka saitomana bae laku lao manata lamolu ma molu ka abulo mai tale nau, ma ni nau ku gura kamolu.’” ");
INSERT INTO bvd_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ma sa Disas ka bae lau 'urii, “Aia ni kamolu, na maa molu ki da diana tasa suli da lio saitomana na raoa ne nau ku ilia, ma na alingamolu ki daka diana tasa suli da rongo saitomana doo neki nau ku bae sulia ki. ");
INSERT INTO bvd_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Si doo mamane nau ku faarongo kamolu ai nia 'urii, na brofet 'oro ki ma na wane 'o'olo 'oro ki 'ana kada 'i nao, kera dooria 'asia naa suana lana doo neki kamolu suai ki tari'ina, ma sui ka nao kera dasi suai gu. Kera daka dooria 'asia naa rongo saitoma lana doo neki kamolu saitomana ki 'i tari'ina, ma sui ka nao kera dasi rongo saitomana guu. ");
INSERT INTO bvd_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Molu gwalinge fasi sulia si tarifulaa sulia waa bae nia afusia migana wiiti. ");
INSERT INTO bvd_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Si kada ne wane nia rongoa si faarongoa sulia 'initoaa God, ma ka nao si filoa, sa Saetan 'e lea mai ka laua lau gwana bae lana God faasia waa nai 'e rongoa. Si doo nai ka ilingia na miga wiiti baki da 'asida sulia taale lao ole, ma saaro ki kera ka 'anida. ");
INSERT INTO bvd_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ma na miga wiiti neki da 'asia 'i lao si saegano 'e faula, kera ilingia na waa ne rongoa bae lana God, ma ka ngalia 'ana ele lae. ");
INSERT INTO bvd_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Sui ma, bae lana God ka nao si lalifuu guu lao mauri lana. Nia ka faamamane guu sulia si kada tu'uu. Sui, kada ilitooe ma 'afitaie ki dao tona guu faafia ne nia faamamanea bae lana God, nia ka nao si faamamanea naa. ");
INSERT INTO bvd_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ma na waa ne nia ilingia miga wiiti neki kera 'asida 'i matangana 'oko kwakware ki. Nia rongoa na bae lana God, sui boroi ma nia ka manata sala 'ana sulia doo ki 'ana mauria nia, ma nia ka manata baita 'ana malefo. Ma doo nai ki, ka ilingia na 'oko kwakware ki da nuku faafia na bae lana God lao mauri lana. Nia nao si tatala guu lao mauri lana ka ilingia na wiiti ne nao si fungu guu 'ana ta fuaedoo. ");
INSERT INTO bvd_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma ta waa lau ne nia ilingia na miga wiiti neki da 'asida 'i lao si saegano diane. Nia rongoa bae lana God, ma ka malingainia, ma ka faatainia tooa 'o'olo ka ilingia wiiti neki da fungu 'ana fuaedoo ki. Tai wiiti ka fungu 'ana tii talange fungii doo, ma tai wiiti na ono akwala fungii doo, ma tai wiiti lau olu akwala fungii doo.” ");
INSERT INTO bvd_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Sa Disas ka saea lau tii tarifulaa fuada ka 'urii, “Na rao lana 'Initoaa God nia ilingia si kada tii wane nai nia afusia migana wiiti lao ola nia. ");
INSERT INTO bvd_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Lao rodo si kada wane ki sui da maleu 'ada, na malimae nia 'e lea mai ka afusia lau guu migana lalano ta'ae ki matangana miga doo diana nai ki, sui nia ka lea na 'ana faasia. ");
INSERT INTO bvd_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Aia, si kada na wiiti nai ki da tae mai lelea daka safali taka naa, kera daka suana migana lalano ta'aa nai ki da tae lau gu fai kera. ");
INSERT INTO bvd_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Na wane ni rao nia ki, kera daka lea mai dao siana daka ledi 'urii 'ani nia, ‘Nee waa baita kani, 'oe 'o fasia na miga doo diana ki bae. Ma sui 'utaa ne lalano kwasi ki daka tae lau gu fai kera loko?’ ");
INSERT INTO bvd_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nia 'e luu kera ka 'urii, ‘Na malimae naa na ilia si doo nai na!’ Na wane ni rao nia ki daka ledi 'urii, ‘'Oe dooria uri lea meli ka kwaia lalano ta'aa loko ki faasi kera?’ ");
INSERT INTO bvd_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nia ka 'urii, ‘Nao. Too 'ada ade lea molu ka kwaia lalano kwasi loko ki ma molu ka kwaia lau guu wiiti ki fai kera. ");
INSERT INTO bvd_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Alu kera tae kwaimani gwada 'uri nai lelea ka dao 'ana si kada ni koni doo lae. Tara dao 'ana si kada nai fatai nau kwafi saea fua toaa nau ki ni koni doo lae uri kera lea daka kwaia fasi 'ada na lalano kwasi ki 'i nao ma daka kania ifidoe ki sui ngali kau daka suungida naa lao ere. Ade 'uri nai sui fatai kera dafi falia wiiti ki ma dafi ngalida fua lao babala nau ni alu fanga lae.’” ");
INSERT INTO bvd_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sui sa Disas ka unu lau sulia tii si tarifula laa ka 'urii, “Na rao lana 'Initoaa God nia mala 'ana tii wane nai nia fasia migana doo nai da saea 'ana mastad lao ola nia. Doo nai migana tu'uu 'isi. ");
INSERT INTO bvd_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ma sui boroi 'ana miga doo nai ka tu'uu 'isi talua miga doo ki sui guu, si kada nia tae mai, nia ka tae mala 'ana ta 'ai ma ka baita lelea ka talua sui guu doo ki 'i lao ola nai. Ma si kada nia baita ka sarala, na saaro ki boroi kera lea mai daka saungainia nui kera ki 'i sarana.” ");
INSERT INTO bvd_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Sui sa Disas ka bae lau 'ana ta tarifulaa ka 'urii, “Na 'initoaa God nia ilingia na isi tu'uu fuana faabose lana kumu 'ana flaoa, ne ta wela keni nia ngalia, ka dolaa fai nia flaoa baita nai ma ka bose lelea ka 'ogaa sui naa kumu nai.” ");
INSERT INTO bvd_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sa Disas nia tarifula sui guu si kada nia bae sulia doo ki fuana konia nai. ");
INSERT INTO bvd_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nia ili 'uri nai uri ka faamamanea na bae lana God ne brofet nia kedaa ka 'urii, “Nau kwai bae 'ana tarifula lae ki fuana toae ki, ma kwai bae folaa sulia doo da tio agwa ki 'uana mai 'ita mai kada nau ku fulia molaagali ai.” ");
INSERT INTO bvd_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sui sa Disas ka faasia konia nai 'i seeri, nia lea ka ruu lao tii luma nai. 'I seeri na toa kwairooi nia ki da lea kau siana daka bae 'urii, “'O 'inifitaa fasi na malutana tarifulaa bae sulia lalano ta'aa bae lao ola bae fuameli wala.” ");
INSERT INTO bvd_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nia luuda ka bae 'urii, “Sa wala bae nia fasia na miga doo diana baki, nia toolangainia ni nau gwana bae, nau 'Alakwa nia wane. ");
INSERT INTO bvd_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ma na ola bae, nia naa ne fera ne 'i saegano. Na miga doo diana baki, nia naa ne toaa ne da nii lao 'initoaa God. Ma na lalano bae, nia naa ne toaa neki da roo sulia sa Saetan. ");
INSERT INTO bvd_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ma na malimae bae nia fasia lalano bae, nia naa ne sa Saetan. Ma kada ni koni dooa bae, nia naa ne 'isi lana fera ne 'i saegano. Na toaa ni koni doo bae, nia naa ne 'ensel ki. ");
INSERT INTO bvd_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kada bae wane ni rao ki da konia lalano uri daka suungia lao ere ai, nia naa ne 'ana 'isi lana fera ne 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nau kwai odua 'ensel ki, uri kera ka lafua toaa neki sui guu da ilia doo ta'aa ki, ma toaa ne kera talai garo 'ana toae ki faasia lao 'initoaa nau. ");
INSERT INTO bvd_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ma kera daka 'ui 'ani kera 'i lao ere, kula ne kera kai too ai 'ana angia ma didi didilifoe. ");
INSERT INTO bvd_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ma na toaa ne da ilia kwaidooria nia God daka too faatai tiifau lao 'initoaa maa kera God ka mala gu 'ana sato loo. 'Oe waa ne 'o too 'ana alingamu, 'o rongo doo nai ki 'oko rongo diana ai.” ");
INSERT INTO bvd_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Sa Disas ka bae lau 'urii, “Na 'initoaa God nia ilingia na ogogania nai da saufinia lao tii ola nai, ma tii waa nai ka dao toi. Si kada sa wala nai nia dao toi, nia ngalia ka saufinia lau gwana. Sui nia ka ele 'asia naa, ka lea ka faafoli tiifau 'ana 'okodoo nia tiifau, sui ka folia naa ola nai uri ka ngalia naa malefo baita nai. ");
INSERT INTO bvd_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Na 'initoaa God nia ilingia lau guu tii wane nai ni foli lae 'ana kekefe diane ki ne nia nani uri usi lana na kekefe diane ne liu lana baita tasa. ");
INSERT INTO bvd_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kada nia dao tona tii kekefe liu lana baita tasa nai, nia ka lea ka faafoli 'ana doo nia ki tiifau sui oli ka folia naa na kekefe diana tasa nai fuana. ");
INSERT INTO bvd_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Na 'initoaa God nia ilingia lau guu na furai da ala ai ma daka 'abaa mai fai sakwari 'e'ete ki sui gwana. ");
INSERT INTO bvd_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Si kada furai nai fungu 'ana sakwari, na toaa ne da dee ki daka 'abaa na mai 'i sara. Sui kera gooru daka konia naa sakwari diane ki fua lao kukudu ki ma daka 'ui naa 'ana sakwari ta'ae ki faasia. ");
INSERT INTO bvd_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Talafana lau guu 'ana 'isi lana fera ne 'i ano nai. Na 'ensel ki kera dai lea mai, ma dai sangitaa toaa ta'ae ki uri daka too 'e'ete faasia toaa diane ki. ");
INSERT INTO bvd_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Na toaa ta'ae ki, kera da kai 'ui 'anida lao ere si kula 'ana angie ma didi didilifoe.” ");
INSERT INTO bvd_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Sui sa Disas ka ledi kera ka bae 'urii, “Kamolu molu saitomana naa malutana doo nai ki?” Kera da olisi nia daka 'urii, “Iuka.” ");
INSERT INTO bvd_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Sa Disas ka bae lau 'urii fuada, “Na toa toolangaidoo neki 'ana taki ne kera da saitomana sui naa malutana taki ma sui daka saitomana lau guu malutana toolangaidooa 'ana 'initoaa God, kera da 'uria na wane gwaungai 'ana ta lume ne nia too 'ana doo diana 'oro lao luma nia. Ne nia saitomana ka tasaa sui gwana mai doo diana nia ki 'ana kada 'i nao ma na doo falu diana nia ki lau guu.” ");
INSERT INTO bvd_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Sa Disas nia bae 'ana tarifulaa nai ki lelea sui, nia ka faasia 'i seeri ka lea naa. ");
INSERT INTO bvd_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nia oli mai dao 'ana maefera nia bae 'i Naasaret, nia ka lea naa lao beu ni ofu laa kera nai uri ka toolangaidoo fuana toaa nai. Ma na toaa nai daka kwele 'asia naa, ma daka bae 'urii, “Na rigitaa sa tii ne adea nia ka toolangaidoo 'ana bae lana God 'urii fai nia ili lana doo kwaibalatana neki? ");
INSERT INTO bvd_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kolu saitomana gwakolu sa wala nee bae, nia na 'alakwa sa Diosef gwana ne, na waa ni saungai doo bae, ma gaa nia gu ne ni Meri. Na toolana ki ne sa Demes, sa Diosef, sa Saemon, ma sa Diudas. ");
INSERT INTO bvd_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ma na waiwane nia ki, kera too gwada fai kolu 'i seki. 'Urifita ne nia ka liotoo ka tasa 'asia naa 'urii?” ");
INSERT INTO bvd_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ma 'ana kada nai, kera daka susubutainia naa sa Disas. Sui sa Disas ka bae 'urii fuada, “Na brofet nia 'afitai fuana wanefuta nia ki fai nia na wane 'ana maefera nia ki, kera daka sae'inito 'ani nia.” ");
INSERT INTO bvd_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ma sa Disas ka nao si ilia guu tai doo kwaibalatana 'oro lao maefera nia, sulia na toaa nia ki da ote kera doori faamamane nia. ");
INSERT INTO bvd_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","'Ana tasi kada 'ana kada nai ki lau guu, sa Herod 'Antibas na waa gwaungai nai fua lolofaa 'i Galilii nia rongo sulia doo 'e fuli ki lao raoa nia sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nia ka bae 'urii fuana toaa da rao kwaimani fai kera ki, “Wane ne, nia alamia sa Dion waa faasiuabu bae 'oto ne nia mauri lau nee? Nia ne ka ilia lau na doo kwaibalatana neki nee!” ");
INSERT INTO bvd_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","'Ana kada sa Dion nia mauri 'ua, sa Herod ne adea ni Herodias na 'afe sa Filib toolana sa Herod lau gwana. Ma sa Dion ka ngatafia sa Herod ka 'urii, “Na taki God nao si ala faafia uri 'oki adea 'afe toolamu 'urii.” Nia ne sa Herod ka falea tai wane uri kera daka daua sa Dion, daka kania, ma daka alu nia lao lookafo. Sa Herod nia ade 'uri nai sulia doori lana ni Herodias. ");
INSERT INTO bvd_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","'Ana kada sa Dion too lao lookafo, sa Herod 'e dooria 'asia naa saungi lana, ma sui ka mau lau gwana 'ana toae ki, sulia kera faamamanea sa Dion nia ta waa 'ana brofet ki. ");
INSERT INTO bvd_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Sui 'ana tii fa dani, sa Herod ka saungainia tii fafangaa baita fuana manata toi lae fa dani nia futa ai. Lao fafangaa nai, na saari ni Herodias nia lea mai ka wae fuana sa Herod fai nia toa kwaimani nia ki uri daka bubungia 'ada. Kada sa Herod nia liotona saari nai wae, nia ka ele 'asia naa sulia. ");
INSERT INTO bvd_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ma nia 'e bae alangai 'afitai sui na mai fuana saari nai ka 'urii, “Nau kwai falea ta tee boroi 'ana ne 'oe gani nau uria.” ");
INSERT INTO bvd_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Aia, gaa nia saari nai 'e saea sui na mai fua saari nia ka 'urii, “'O gani, 'oko bae 'urii, ‘Nau ku dooria 'oko faa mai gwauna sa Dion waa faasiuabu bae fuaku 'ana kada nai 'ua guu. 'Oko alua mai fafona ta labenga.’” Ma na saari nia ka ili na sulia. ");
INSERT INTO bvd_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ma kada sa Herod 'e rongoa si doo nai, nia ka liodila tasa. Sui boroi ma nia ka ilia naa, sulia nia saea sui naa, ma toa kwaimani nia ki boroi daka rongoa sui naa. ");
INSERT INTO bvd_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ma nia ka odua wane ni rao nia ki daka lea naa lao lookafo daka sigimuusia na mai gwauna sa Dion waa faasiuabu bae. ");
INSERT INTO bvd_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ma daka ngalia na mai gwauna sa Dion daka alua mai lao labenge daka faa na fuana saari ni Herodias. Ma na saari nai ka ngalia dao ka faa na fua gaa nia. ");
INSERT INTO bvd_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kada na toa kwairooi sa Dion ki kera rongoa si doo nai, kera lea mai daka ngalia nonina lea daka saufinia naa lao kilu gwau. Sui, kera ka lea daka faarongoa sa Disas 'ana doo ne fuli nai. ");
INSERT INTO bvd_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","'Ana si kada sa Disas nia rongoa si doo nai fuli 'ana sa Dion nai, nia fai nia toa kwairooi nia ki da tae aroaro lao baru daka lea faasia 'i seeri uria tii si kula gwau nai taifili kera. Ma sui, na toaa 'oro nai ki daka rongo alinga ai ne sa Disas nia lea nai, kera daka faasia 'i seeri ma daka nani lau gu kau 'i burina. ");
INSERT INTO bvd_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sa Disas, si kada nia lea kau ka koso 'i bali loko, nia ka suana konia baita nai da nii na 'i seeri. Sa Disas nia ka manatai kera nia ka guraa naa toaa matai ki nii 'ani kera. ");
INSERT INTO bvd_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nia ade 'uri nai lelea kau dao 'i saulafi, na toa kwairooi nia ki daka lea mai dao siana daka bae 'urii, “Si kula nee nia gwau ka nao si too karangia guu tai maefera ma ka karangi kai rodo naa 'urii, 'oe odua konia nee da oli 'ua 'ada 'ana si kada nai uri kera lea daka foli fanga 'ada ki 'ana tai maefera.” ");
INSERT INTO bvd_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Sa Disas nia luu kera ka 'urii, “Doo sae kera daka lea fatai nao na. Kamolu ne molu sangoni kera.” ");
INSERT INTO bvd_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kera da luu nia daka 'urii, “Na lima kafa beret fai nia roo ka gwa sakwari gu ne nii siameli nee.” ");
INSERT INTO bvd_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Sa Disas ka bae 'urii fuada, “Molu ngalia mai doo nai ki seki.” ");
INSERT INTO bvd_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Sui nia ka saea fuana konia nai uri daka gooru ngado 'i saegano fafo kiras nai. Sa Disas nia ka rao uri lima kafa beret baki ma roo ka gwa sakwari baki, nia ka lio 'alaa 'i langi ka bae tangoa God. Nia ka nii tu'uu 'afa beret baki sui ka falea fuana toa kwairooi nia ki daka tolingia naa fuana toaa nai ki. ");
INSERT INTO bvd_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Na toaa nai ki tiifau daka fanga lelea daka abusu gwada fasi fanga nai. Sui na toa kwairooi nia ki kera daka konia naa oretana fanga nai fua lao tii taafuli kukudu ma roo kukudu sarenga ki lelea daka fungu sui guu. ");
INSERT INTO bvd_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Na konia nai da 'ani fanga nai, na wane ki gwana, kera 'ada lima tooni wane. Na keni ki ma na wela tu'uu ki, nao dasi idu gu 'ani kera. ");
INSERT INTO bvd_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ma 'i burina si doo nai, sa Disas nia ka odua toa kwairooi nia ki kera ka eta na 'i nao uria ta bali 'ana 'osi nai lao baru. Ma nia ka 'aruburi kau uri ka odua konia nai daka lea 'ada. ");
INSERT INTO bvd_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","'I burina konia nai da oli ki sui naa, nia taifili nia ka raa gwauna tii fa toloa nai uri ka foa 'ana 'i seeri. Ma 'afa saulafia nai nia ka too gwana taifili nia 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","'Ana tii si kada nai gwana, na baru bae fai nia toa kwairooi nia ki 'e lea ka nii tau naa faasia 'i sara, ma na nanafo ka kwaea naa sulia nia naofia koburu. ");
INSERT INTO bvd_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Lelea dao 'i 'uubongi karangi dani naa, sa Disas nia talau kau fafona kafo ka lea na kau siana toa kwairooi nia ki. ");
INSERT INTO bvd_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kada kera suana nia talau mai 'i fafona kafo, kera ka mau 'asia naa. Ma kera ka 'ai daka 'urii, “Toa nee 'ae, ma tii anoedoo loko!” Ma kera ka mau daka ararai guu. ");
INSERT INTO bvd_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","'I seeri sa Disas 'ali'ali ka bae 'urii kau fuada, “Nao molu si mau. Nau gwana ne.” ");
INSERT INTO bvd_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ma sa Bita 'e luua ka 'urii, “Aofia 'ae, lea 'oe mamana naa na, 'oko saea mai nau ku talau fafo kafo ku lea kau siamu.” ");
INSERT INTO bvd_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Sa Disas ka bae 'urii, “Lea mai.” 'I seeri sa Bita 'e koso faasia kaa baru nai ka talau fafona kafo ka safali lea na kau siana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ma sui kada nia liotoi koburu nai baita, nia ka mau lau gwana ka safali kuruu naa 'i lao kafo. Ma nia ka 'ai ka 'urii, “Aofia, faamauri nau!” ");
INSERT INTO bvd_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ma 'ali'ali guu sa Disas ka fale 'aba na kau uri nia, ka dau 'ana 'abana, ma ka bae 'urii, “Na fiitooa 'oe nia tu'uu 'asia naa. Ma uri tee ne 'oko manata sala 'ani nau?” ");
INSERT INTO bvd_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ma 'ana kada keeru raa naa 'i lao baru, na koburu ka aroaro naa. ");
INSERT INTO bvd_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","'Uri nai guu toa ne kera nii 'i lao baru, kera daka faa'inito nia daka 'urii, “'Oe naa ne 'Alakwa nia God mamana!” ");
INSERT INTO bvd_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kera daka toofolo lao 'osi lea kau daka koso 'ana tii maefera kera saea 'ana Genesaret. ");
INSERT INTO bvd_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma na toaa 'ana maefera nai ki, kera ka lio saitomana sa Disas. Ma kera ka faarongoa lau tai maefera ki 'ana sa Disas, uri toaa ki, kera daka talaia mai toaa matai kera ki siana. Ma kera ka ngalia na mai toaa matai 'oro siana. ");
INSERT INTO bvd_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ma toae ki daka ledia sa Disas uri ka faolomainia toaa kera ki ne da matai uri kera ka samo tona 'ada tatagwarana maku nia. Ma 'i seeri, toae ki sui gwana ne kera samo tona maku nia, kera daka 'akwaa naa. ");
INSERT INTO bvd_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sui tai Faarisii fai nia toa toolangaidoo ki 'ana taki, kera ka lea mai faasia 'i Durusalem siana sa Disas fua ledi lana. ");
INSERT INTO bvd_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Kera ka bae 'urii, “'Utaa ne toa kwairooi 'oe ki ka nao dasi taufia gu 'abada ki uri ka lea sulia birangaa ne kokoo kolu ki mai nao da toolangainia fuakolu?” ");
INSERT INTO bvd_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Sa Disas 'e luu kera ka 'urii, “Kamolu mone, 'utaa ne molu ka ili 'amolu sulia birangaa kamolu 'ana fera kamolu ma molu si ili sulia si baea fifii God? ");
INSERT INTO bvd_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God bae 'urii, ‘'O sae'inito 'ana maa 'oe fai gaa 'oe.’ Ma ‘Tii ne nia surafia maa nia ma nao gaa nia, kera dai saungia ka mae.’ ");
INSERT INTO bvd_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ma sui, kamolu ka toolangaidoo garo 'amolu 'urii, tii ne nia too 'ana tai doo ni 'adomi lana 'ana maa nia fai gaa nia, ma sui ka bae 'ana 'urii, ‘Nau kwai falea naku doo baki fua God.’ ");
INSERT INTO bvd_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kamolu ka saea sa nia diana gwana uri ka nao si 'adomia lau gaa nia fai maa nia sulia 'e alangainia sui na 'ana fua God. Ma lea nia 'uri nai, na toolangaidoo laa ne kamolu alua, nia ka faatu'uua naa bae lana God nai. ");
INSERT INTO bvd_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ma kamolu ka saea sa kamolu roo sulia God, ma nao nia si mamana gu. Si baea sa 'Aesaea nia saea suli kamolu 'e kwaea funua naa, kada nia bae ka 'urii, ");
INSERT INTO bvd_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Na toaa neki kera faabaita nau gwada 'ana bae lada, sui ma manata lada ka nii tau gwana faasi nau. ");
INSERT INTO bvd_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kera tako gwada 'ana foosilaku, sulia kera toolangaidoo 'ada sulia taki kera ki tala 'ada, ma daka saea 'ada sae taki God ki naa nai!’” ");
INSERT INTO bvd_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Sui sa Disas ka 'ailia mai konia nai siana, ka bae 'urii fuada, “Molu fafurongo molu ka saitoma diana fasi 'ana si doo 'urii. ");
INSERT INTO bvd_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nao lau ta doo ne wane 'ani 'i ngiduna ne nia 'e faasua nia. Nao! Si baea ta'aa ne lea mai fasi ngiduiwane lau 'ana ne nia faasuaa mauri lana wane.” ");
INSERT INTO bvd_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Sui na toa kwairooi sa Disas ki, kera ka lea mai siana, daka bae 'urii fuana, “Na doo bae 'o saea ki, na Faarisii ki da rongoa, na manata lada ka nao si diana sulia wala.” ");
INSERT INTO bvd_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Sui sa Disas nia luu kera ka bae 'urii, “God kai kwaifakutuna toolangaidooa ne nao si lea mai faasia nia, ma ka 'uria wane 'e kwaia doo ta'aa ne tae kwaimani fai doo fasi lana ki. ");
INSERT INTO bvd_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nao molu si manata lau suli Faarisii ki. Sulia kera toa da 'uria gwada na waa maarodo da talaia lau gwada waa maarodo ki na. Ma molu ka saitomana lau guu, lea ta waa maarodo 'e talaia lau guu ta waa maarodo, keerua kai 'asi keeru sui guu lao kilu.” ");
INSERT INTO bvd_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ma sa Bita ka bae 'urii fua sa Disas, “'O 'inifitaa fasi mai si tarifulaa bae 'oe saea sulia doo ne kai faasuaa wane 'i maana God.” ");
INSERT INTO bvd_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Sa Disas nia luua ka bae 'urii, “Kamolu toa kwairooi nau nee boroi nao molu si saitoma diana lau guu 'ana doo neki nee! ");
INSERT INTO bvd_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","'Utaa ne nao molu si saitomana gu doo neki? Iuka, na doo ne wane 'ani ka koso toli lao ruruuna nia kai lea lau gwana mai faasia lao nonina. ");
INSERT INTO bvd_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ma si baea ta'aa ne nia 'ita mai lao liona wane, nia lau 'ana ne kai faasuaa na mauri lana wane. ");
INSERT INTO bvd_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ma si manata laa ta'aa neki dai tae mai faasia lao liona wane ne 'urii: sauwanee, kaubaree, ooe, sukee, belie, fai ununua ta'ae. ");
INSERT INTO bvd_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Doo nai ki 'ana ne ilia waa ka sua 'i maana God. Ma na tau 'aba lae uri fanga lae lelea ta waa nao si ilia boroi, waa nai 'afitai ka sua guu 'i maana God.” ");
INSERT INTO bvd_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Sui sa Disas nia faasia 'i seeri, nia ka lea naa uria na bali lolofaa loo 'i Taea fai nia 'i Saedon. ");
INSERT INTO bvd_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ma tii wela keni ne nao lau Diu lao maefera 'i Keenan ka lea mai siana, ma ka 'ai 'urii, “Aofia 'ae, 'oe waa na futa 'ana kwalafaa sa Defet, 'o manatai nau mai! Na anoedoo ta'aa nia 'adosia saari nau ka nonifii 'asia naa.” ");
INSERT INTO bvd_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Sa Disas ka nao si luua guu 'ana tasi baea. Ma toa kwairooi nia ki kera daka lea mai siana sa Disas, daka bae 'urii, “Odua 'initai nee lea 'ana fasi nia alu ade lae gwana 'urii buri kolu wala!” ");
INSERT INTO bvd_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Sa Disas ka bae fuana wela keni nai ka 'urii, “Toaa Diu nee ne da ilingia sifsif da nao'ada ki naa, kera 'ana ne God nia fale nau mai siada.” ");
INSERT INTO bvd_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sui na wela keni nai ka lea mai, ma ka booruru naa 'ana 'i maa 'aena ka 'urii, “Wala Aofia, 'o 'adomi nau mai!” ");
INSERT INTO bvd_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Sa Disas 'e luua ka 'urii, “Nia nao si 'o'olo fua daka ngali lana fanga wele ki, ma daka 'ui 'ada ai fua giri ki.” ");
INSERT INTO bvd_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Na wela keni nai ka 'urii, “Iuka. Sui boroi ma giri ki lea doo daka 'ani gwada orongana fange ne 'asia fasi tebol waa da saareda ki.” ");
INSERT INTO bvd_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sui sa Disas 'e luu nia ka 'urii, “Wala wela keni nee 'ae, na faamamane lamu 'ani nau nia baita tasa! Nau ku falea naa doo ne 'oe gania fuamu.” 'Ana kada nai 'ua guu, saari nia ka 'akwaa naa. ");
INSERT INTO bvd_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kada sa Disas nia lea mai faasia bali nai, nia ka oli mai sulia taala nai 'e 'iia mai ninimana 'osi baita 'i Galilii. Ma nia ka raa gwauna tii labusua, ma ka gooru 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ma si kada nai, toaa 'oro 'asia naa daka koni mai siana. Ma kera daka ngalia lau guu mai toaa 'oro matai ki, tai wane 'aeda mae ma 'abada lau guu, tai wane maada ka rodo, ma tai wane fakada ka 'ato. Kera daka aluda ki 'i maa 'aena sa Disas, ma nia ka gurada, kera ka 'akwaa tiifau. ");
INSERT INTO bvd_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ma na toa nai ki ne kera koni mai daka suai doo nai ki kera daka kwele 'asia naa 'ana wane fakada 'ato ki, ma daka bae naa. Ma wane 'aeda mae ma 'abada mae ki daka diana naa. Ma toaa ne nao dasi fali diana ki, kera daka fali diana naa. Ma na wane ne maada rodo ki, kera daka lilio naa. Ma kera daka tangoa God ne 'i 'Israel, sulia kera suana doo nai ki. ");
INSERT INTO bvd_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sui sa Disas ka 'ailia mai na toa kwairooi nia ki siana, ka bae 'urii fuada, “Nau ku manatainia 'asia naa toaa neki, sulia kera too mai fai kolu ta olu fa dani ka sui naa, ma ka nao nada tasi fanga. Ma nau nao kusi dooria olitai lada uri fera kera ki 'ana kada kera fiolo 'urii, ade lea ta waa ada ka makeso maana ka lelea ma daka 'asia kera suli taale.” ");
INSERT INTO bvd_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Na toa kwairooi nia ki da olisi nia daka bae 'urii fuana, “Lao gano tau 'urii, kolu ka dao toi 'utaa na 'akolu 'ana tasi fanga ka bobola fai kera nee wala?” ");
INSERT INTO bvd_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ma sa Disas ka ledi kera ka 'urii, “Fita fa beret ki ne kamolu too ai?” Toa kwairooi nia ki da olisi nia daka bae 'urii, “Fiu fa doo ki guu, fai nia ta bara kaa sakwari tu'uu gwana.” ");
INSERT INTO bvd_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kada nai, sa Disas ka saea naa fua toae ki daka gooru 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Sui, nia ka ngalia fiu fa beret baki fai nia kaa sakwari baki, ka tangoa God faafia. Sui nia ka niia, ka falea naa fua toa kwairooi nia ki, kera ka tolingia naa fuana toaa nai ki. ");
INSERT INTO bvd_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ma toaa nai ki sui guu kera daka fanga lelea daka abusu naa. Burina fanga lae sui, na toa kwairooi ki kera daka taungia fiu kukudu baita ki 'ana orongana fanga ne ore. ");
INSERT INTO bvd_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Toaa ne kera 'ania fanga nai, kera faitoonii wane ki. Nao kera dasi idumia guu na keni ki fai nia wela tu'uu ki. ");
INSERT INTO bvd_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Aia, ma burina kera fanga ka sui naa, sa Disas kafi olitai kera uri 'i fera kera ki. Ma nia fai nia na toa kwairooi nia ki, kera ka koso kau daka raa lao baru, kera daka lea naa uria maefera satana 'i Magadan. ");
INSERT INTO bvd_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tai Faarisii ma tai Sadiusii kera da lea mai siana sa Disas uri daka ilitona 'ada, ma kera daka saea uri nia ka ilia tasi doo kwaibalatana uri ka faatai folaa ai ne God ne fale nia mai. ");
INSERT INTO bvd_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Sa Disas 'e luu kera ka bae 'urii fuada, “Kamolu, si kada molu suana lao salo nia 'a'abua 'i saulafi, molu ka saea faanoe kai sato diana. ");
INSERT INTO bvd_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Sui, si kada molu suana lao salo nia 'a'abua ma ka rorodoa 'i 'uubongi, molu ka saea fa sato nai tara ute kai 'aru. Kamolu molu saitomana 'asia naa mamalafooa nia doo nai ki lao mamangaa, ma sui, lio saitoma lana doo neki God ilia nee ne nao gu 'ani kamolu. ");
INSERT INTO bvd_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kamolu toaa ta'aa ma abu faamamane nee 'i tari'ina, molu dooria 'asia naa sua lana fafaataie. Sui ma nau gu ne 'afitai ku ilia guu ta doo kwaibalatana fuamolu. Si doo kwaibalatana bae nia fuli 'ana brofet Dionaa kada 'i nao, nia gu ne nau kwai ilia fuamolu.” Burina sa Disas sae si doo nai sui, nia ka lea naa 'ana faasi kera. ");
INSERT INTO bvd_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","'Ana kada sa Disas fai nia toa kwairooi nia ki kera toofolo uria na bali 'osi loko, na toa kwairooi nia ki nao dasi too 'ana ta beret, sulia kera manata buro 'ana ngali lana kau fai kera. ");
INSERT INTO bvd_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ma sa Disas ka bae 'urii fuada, “Molu ka fiia kwaini isi kera nee Faarisii ki fai nia Sadiusii ki.” ");
INSERT INTO bvd_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Si kada toa kwairooi nia ki da rongo si baea nai, daka bae na 'ada 'i safitada taifili kera, sulia kera kwaifiia 'ada sae sa Disas nia bae sulia beret mamane. Kera daka bae 'urii, “Alamia sa Disas nia bae 'uri nai, sulia ne nao kolu si ngali mai ta beret fai kolu 'oto ne?” ");
INSERT INTO bvd_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ma sa Disas nia saitomana gwana manata lana toa kwairooi nia ki, 'uri nai nia ka bae 'urii, “Na manata mamana laa kamolu 'e tu'uu 'asia guu, 'utaa ne molu ka bae 'asia naa suli beret nai? ");
INSERT INTO bvd_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kamolu doo nao molu si saitomaku 'ua gu nee? Ma kamolu manata buro na 'amolu 'ana lima fa beret baki nau ku saarea 'ana lima tooni wane baki, ma molu ka taungia kukudu 'oro baki ka fungu 'ana fanga bae ore ki 'oto nee? ");
INSERT INTO bvd_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Alamia molu manata buro lau guu 'ana fiu fa beret baki nau ku saarea 'ana faitooni wane baki fai nia kukudu 'oro baki molu taungia ka fungu 'ana fanga bae ore 'oto nee? ");
INSERT INTO bvd_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","'Utaa ne nao molu si saitomana tee ki ne nau ku bae ki sulia? Nao lau na beret ne nau ku bae sulia. Doo ne nau ku saea 'aku ne molu ka fiia si lio kera nee Faarisii ki fai nia Sadiusii ki, ne mala rao lana isi lao kumu 'ana beret.” ");
INSERT INTO bvd_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Burina nia bae 'uri nai sui, na toa kwairooi ki kera dafi saitomana tee ne sa Disas nia bae sulia. Nia bae lau 'ana sulia na toolangaidoo laa Faarisii ki fai nia Sadiusii ki. ");
INSERT INTO bvd_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kada sa Disas nia dao 'ana bali lolofaa 'i Sisaria Filibae, nia ka ledia naa toa kwairooi nia ki ka 'urii, “'Urii ma wane ki kera saea nau, 'Alakwa nia wane, nau sa tii nee?” ");
INSERT INTO bvd_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kera luu nia daka bae 'urii, “Tai wane kera saea 'oe sa Dion waa faasiuabu bae ne 'oe mauri lau nee, ma tai wane kera saea 'oe sa 'Ilaeja ne 'oe oli lau mai nee. Ma tai wane lau kera daka saea 'oe sa Dioromaea, ma nao ta waa 'ana brofet baki 'i nao ne.” ");
INSERT INTO bvd_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Sui sa Disas ka ledi kera lau ka 'urii, “Ma sui kamolu mone, molu saea nau sa tii nee?” ");
INSERT INTO bvd_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sa Saemon Bita 'e luu nia ka 'urii, “Ni 'oe na Kraes bae naa ne. 'Oe naa bae God fili 'oe uri faamauri lana toaa nia ki, ma ni 'oe naa ne 'Alakwa nia God mauri firi.” ");
INSERT INTO bvd_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Sa Disas ka bae na 'urii fuana, “'Oe sa Saemon 'alakwa nee sa Dion, 'e diana tasa fuamu. Suli nao lau wane gwana ne nia faatainia doo nai fuamu. Maa nau 'i salo ne nia faatainia fuamu nai. ");
INSERT INTO bvd_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nau ku saea fuamu, ni 'oe sa Bita, ma ni nau kwai fulia na konia manata mamana nau 'i fafona maefau nai, ma na rigita lana maea tara nia nao si bobola fai nia siitasa lae faafia. ");
INSERT INTO bvd_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nau kwai falea rigitaa fuamu mala 'ana ta kii fuana 'initoaa God. Uri ta tee ne 'oe luia lao ano nee, si doo nai, God boroi nia luia lau guu 'i salo. Ma ta tee ne 'oe faolomainia lao ano nee, si doo nai, God boroi nia faolomainia lau guu 'i salo.” ");
INSERT INTO bvd_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sui sa Disas ka bae tetede fua toa kwairooi nia ki uri kera ka nao dasi faarongoa lau ta wane ne nia na Kraes. ");
INSERT INTO bvd_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","'Ita 'i seeri ka lea naa, sa Disas nia safali ka bae folaa naa fua toa kwairooi nia ki. Nia ka bae 'urii, “Nau kwai lea naa uri Durusalem nai. Na toa gwaungai ki ma na waa baita ni foa ki, ma na toa toolangaidoo ki 'ana taki, totoo kau kera dai faafii nau ma dai saumaeli nau. Ma sui 'ana oluna fa dani nau ku mae, God kai tatae nau lau gwana faasia maea.” ");
INSERT INTO bvd_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ma sa Bita ka talaia kau, ka ngatafi nia ka 'urii, “Aofia 'ae, God ka liliua kau si doo nai faasi 'oe! Ma doo nai ka too 'ana fasi fuli lae fuamu!” ");
INSERT INTO bvd_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ma sa Disas 'e toriabulo ka bae 'urii fua sa Bita, “Saetan, 'o oli 'amu 'i buriku! 'Oe sasi uri suusilaku ne, sulia na manata lamu nai doo nia wane gwana nai, nao lau faasia God.” ");
INSERT INTO bvd_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sui sa Disas ka bae 'urii fuana toa kwairooi nia ki, “Lea ta waa nia dooria kai lea mai 'i buriku, nia ka manata buro naa 'ani nia 'i tala'ana, ka noni maabe naa fua liu lae lao fii lae ki, talafana 'airarafolo nia ne nia ngalia uri mae lae 'i fafona. ");
INSERT INTO bvd_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Waa ne dau ngasi 'ana faafia mauria nia, mauria nia kai funu, ma waa ne luka dangatai 'ana mauria nia fuaku, nia kai todaa mauria. ");
INSERT INTO bvd_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Lea waa ka too boroi 'ana doo 'oro lao fera ne 'i saegano, ma nia ka mae gwana, doo nai ki si falea gu ta dianaa fuana. Nao ta waa si tala 'ana foli lana mauria firi 'ana malefo. ");
INSERT INTO bvd_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nau ku saea doo neki 'urii sulia nau, na 'Alakwa nia wane, nau kwai dao mai fai nia 'ensel nau ki, fai nia 'initoaa Maa nau, ma nau kwai falea na kwaiara ma kwakwaea fua toaa ki sui guu faafia si doo neki sui guu kera ilia. ");
INSERT INTO bvd_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Doo mamane ku saea fuamolu 'e 'urii, tai wane 'amolu ne molu uu 'i seki molu kai mauri 'ua gwamolu kada nau 'Alakwa nia wane kwai dao mai fai nia 'initoaa nau.” ");
INSERT INTO bvd_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","'E dao 'ana onona fa dani 'i buri, sa Disas ka talaia sa Bita fai nia roo waisaasina baki, sa Demes fai nia sa Dion. Ma kera daka lea taifili kera fai nia uri 'i gwauna tii fa uo fane nai. ");
INSERT INTO bvd_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Dao 'i seeri, kera daka suana maana sa Disas 'e tatala naa. Ma na maana ka waasinasina 'asia naa ilingia sato loo, ma na maku nia ki lau guu ka kwakwaosarea 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ma na olu waa kwairooi nai ki, kera daka suana sa Mosis fai nia sa 'Ilaeja keeru bae 'adaru fai nia sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ma sa Bita ka bae 'urii kau fua sa Disas, “Aofia 'ae, nia diana 'asia naa ne kolu nii na 'i seki. Lea 'oe dooria, nau ku saungainia ta olu babala, ta doo fuamu, ta doo fua sa Mosis, ma ta doo fua sa 'Ilaeja.” ");
INSERT INTO bvd_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ma 'ana kada sa Bita nia bae 'ua gwana 'uri nai, si dasa kwakwaosarea 'asia naa dao ka koko na faafi kera, ma kera daka rongo tii si lingee baea nia talo mai faasia lao si dasa nai, ka 'urii, “Na wela liosaua nau ne. Nau ku ele 'asia naa suli nia. Kamolu ka rongo suli nia!” ");
INSERT INTO bvd_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ma kada ne toa kwairooi nia ki da rongoa si lingee baea nai, kera daka mau 'asia naa, ma kera daka tio na faafi maada 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ma sa Disas ka dao siada ka dau toda, ka bae 'urii, “Molu tatae 'amolu. Nao molu si mau.” ");
INSERT INTO bvd_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ma kada kera lio kau, nao dasi suana naa ta waa lau, taifilia gwana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ma si kada kera koso na mai fasi gwauna fa uo nai, sa Disas ka bae fifii fuada ka 'urii, “Nao molu si faarongoa ta waa 'ana doo nai ki kamolu suai nai. Too 'ana 'uri nai lelea ka dao fatai kada God kai tae nau, na 'Alakwa nia wane, faasia maea.” ");
INSERT INTO bvd_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Olu waa kwairooi nia ki daka ledi nia 'urii, “'Utaa ne waa toolangaidoo ki 'ana taki kera daka saea sa 'Ilaeja kai dao fasi mai nao sui fatai waa fifilia God kafi dao mai?” ");
INSERT INTO bvd_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Sa Disas 'e luu kera ka 'urii, “Nia mamana. Sa 'Ilaeja bae nia kai dao fasi mai nao uri ka saea fuana toae ki daka kwaimaakwalii. ");
INSERT INTO bvd_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Aia, nau ku saea fuamolu, sa 'Ilaeja nia dao sui naa. Ma sui toae ki ka nao dasi lio saitomana guu. Nia ne kera daka ilia gwada doo ta'aa ki 'ani nia sulia doori lada. Ma kera kai ili lau guu 'uri nai 'ani nau.” ");
INSERT INTO bvd_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","'Ana kada olu waa kwairooi nai ki kera rongo, kera dafi saitomana ne sa Disas bae gwana sulia sa Dion waa ni faasiuabu fuada. ");
INSERT INTO bvd_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Si kada sa Disas fai olu waa kwairooi nia nai ki kera koso mai daka dao naa siana konia baita nai 'aena uo nai, tii waa ka lea mai ka booruru 'i maa 'aena sa Disas. Waa nai ka bae 'urii, ");
INSERT INTO bvd_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Aofia 'ae, 'oe manatainia mai 'alakwa nau nee, suli na uoro ne saungia. Na mataia nee ilia nia ka oewanea, ma kada 'oro nia ka 'asi nia lao ere, ma lao kafo. ");
INSERT INTO bvd_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nau ku ngalia mai siana toa kwairooi 'oe ki, ma sui daka gura nia boroi nia nao si 'akwaa guu.” ");
INSERT INTO bvd_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Sa Disas ka bae 'urii fuada sui gwana, “'Oo, ni kamolu toaa abu faamamane ma toaa ade garo nee 'i tari'ina lau rowaa 'ae. Kamolu manata lamolu nia sadi 'asia naa wala! Nau ku too mai fai kamolu ka tau naa ma karangi kwai faasi kamolu naa. Fulingana sa molu ka faamamane nau naa ne, ma sui ka nao guu.” Sui nia ka bae 'urii fuana waa nai, “'O ngali mai wela 'oe 'i seki.” ");
INSERT INTO bvd_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ma sa Disas ka ngatafia anoedoo ta'aa nai ka lea naa fasi wela nai. Ma na wela nai ka 'akwaa 'ana kada nai 'ua guu. ");
INSERT INTO bvd_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Sui, kada kera taifili kera naa, na toa kwairooi sa Disas ki daka ledi nia, daka 'urii, “'Utaa ne ka 'afitai fuameli uri tari lana anoedoo ta'aa bae wala?” ");
INSERT INTO bvd_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Sa Disas luu kera ka bae 'urii, “Faamamane laa kamolu 'e nao si baita nai ka 'uri nai. Ma sui nau ku faarongo kamolu, lelea faamamane laa kamolu 'ana God ka tu'uu 'isi boroi 'ana mala 'ana migana mastad, kamolu tala'ana molu ilia gwamolu doo 'afitai tasa ki. Lea nia 'uri nai, fa uo loko boroi, kamolu ka 'idua gwamolu faasia fulina 'ana bae lamolu. Ma lelea kamolu faamamanea rigitaa God, nao ta doo kasi 'afitai fuamolu uri ili lana.” ");
INSERT INTO bvd_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ma kada toa kwairooi nia ki kera koni 'i Galilii, sa Disas ka bae 'urii fuada, “Nau, na 'Alakwa Nia Wane, kera kai fale nau 'i 'abana malimae nau ki, ");
INSERT INTO bvd_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","uri daka saumaeli nau. Ma sui 'ana oluna fa dani, God kai tatae nau lau gwana fasi maea.” Ma kada toa kwairooi ki da rongo sa Disas nia bae 'uri nai, kera daka liodila 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kada sa Disas fai nia toa kwairooi nia ki kera da dao 'i Kabaneam, na toa kera koni malefo 'ana takisi fuana beukaua God ki, kera lea mai siana sa Bita, daka 'urii fuana, “Nee wala, ma waa toolangaidoo kamolu nia folia lau guu takis nee 'ana beukaua God, ma nao, nao guu?” ");
INSERT INTO bvd_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ma sa Bita luu kera ka 'urii, “Iuka, nia folia lau guu ne.” Ma kada sa Bita 'e ruu mai luma, sa Disas 'e ledia 'ua guu 'i nao ka 'urii, “Saemon 'ae, 'oe 'o manata 'utaa? Toa ne da 'inito faafia fera ne 'i saegano lea doo wela kera ki daka folia takis, ma nao doo fua toaa 'e'ete ki 'ana?” ");
INSERT INTO bvd_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Sa Bita 'e luu nia ka 'urii, “Doo fua toaa 'e'ete ki lau gwana.” Ma sa Disas ka 'urii, “Nia 'uri nai, na wela kera ki nao dasi falea lau takisi nee. Nia ne, talafana lau gu ni nau nai, sulia nau bobola fai nia nao kwasi folia lau takisi nee 'ana beukaua Maa nau. ");
INSERT INTO bvd_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ma sui boroi 'ana ka 'uri nai, nao si diana uri kolu ka adea manata lada ka ta'aa fuakolu. 'Oe lea 'oko dee mai lao 'osi loko. 'Oko lio lao fakana fa sakwari ne 'oe eta deea totoonao uri 'oko suana malefo ne nii laona, ne nia bobola naa uri koro ka folia 'ana takisi koro ki fua tii fa ngali lalau. Ngalia malefo nai, 'oko faa fuada.” ");
INSERT INTO bvd_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","'Ana kada nai, na toa kwairooi sa Disas ki kera lea mai siana, daka ledi nia daka 'urii, “Nee wala, ma sa tii ne nia 'inito tasa lao 'initoaa God?” ");
INSERT INTO bvd_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","'I seeri sa Disas ka 'ailia mai tii kaa wela tu'uu nai siana ka saea fuana ka uu 'i seeri matangada sui guu. ");
INSERT INTO bvd_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Sa Disas ka bae 'urii, “Si doo mamane ku saea fuamolu nia 'urii, kamolu molu bulasi manataa ma molu ka faatu'uu kamolu 'i tala'amolu mala 'ana wela tu'uu ki taari molu ka bobola fai nia ruu lae lao 'initoaa God. ");
INSERT INTO bvd_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tii ne nia faatu'uu nia 'i tala'ana ka 'uria na wela tu'uu nee, nia taari nia 'initoa tasa lao 'initoaa God. ");
INSERT INTO bvd_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Tii ne nia gwalea ta wela tu'uu 'uri nee sulia ne wela nai nia faamamane nau, wane nai nia gwale nau lau guu. ");
INSERT INTO bvd_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Tii ne nia ilia tasi doo ne adea ta wela 'ana wela tu'uu neki da manata mamana 'ani nau ma wela nai ka lukasia manata mamana laa nia 'ani nau, nia diana fua daka kani kulua ta maefau baita tasa 'i luana ma lea daka kulufauna lao tofungana asi kwasi. ");
INSERT INTO bvd_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nia ta'aa ka tasa fua toaa nee lao fera ne 'i ano ne kera talaia toae ki uri lao abulo ta'aa lae. Na birangaa 'ana kwaitalai lae uri lao abulo ta'aa lae nia 'afitai ka nao lau, sui boroi 'ana ma nia ta'aa ka tasa fua wane ne nia talaia toae ki uri lao abulo ta'aa laa nai. ");
INSERT INTO bvd_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Lea sa ta bali 'aba 'amu ma nao sa ta bali 'ae 'amu nia talai 'oe uri lao abulo ta'aa lae, 'o sigimuusia 'oko 'ui 'amu ai. Nia diana ka tasa uri 'oko ruu lao maurie fai nia ta tii bali 'aba ma nao ta tii bali 'ae boroi 'ana. Nia ta'aa ka tasa ne lea sa na roo bali 'aba 'oe ki ma nao na roo bali 'ae 'oe ki daka tio lalau sui boroi 'ada ma daka 'ui nada 'ani 'oe fai kera lao era bae nia saru ka lelea firi. ");
INSERT INTO bvd_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ma lea sa ta bali maa 'amu nia ka talai 'oe uri lao abulo ta'aa lae, 'o keoa 'oko 'ui 'amu ai. Nia diana ka tasa uri 'oko ruu lao maurie fai nia tii bali maa boroi 'ana. Nia ta'aa ka tasa ne lea sa na roo bali maa 'oe ki daka tio lalau sui boroi 'ada ma daka 'ui nada 'ani 'oe fai kera lao era bae nia saru ka lelea firi.” ");
INSERT INTO bvd_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Ma sa Disas ka bae lau 'urii, “Nao molu si liofaafia gwamolu wela tu'uu neki, sulia na 'ensel kera ki da faarongoa Maa nau 'i salo 'ana doo ne kamolu ilia ki 'ani kera. ");
INSERT INTO bvd_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ma lelea ta waa nia too 'ana tii talangee sifsif, ma ta tii doo ada ka lea ka nao'ana, 'oe kwaifii sae tee ne waa nai kai ilia? Nia kai faasia sikwa taafuli sifsif ma sikwa sifsif ki daka too ni fanga laa 'ada gwau labusua ki, nia ka lea ka nani fasi 'ana uria tii sifsif ne nao'ana nai. ");
INSERT INTO bvd_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kada nia lelea kau ka dao tona, nia ka ele 'asia naa talua ele laa nia sulia sifsif baki kera too ngado ki gwada. ");
INSERT INTO bvd_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Talafana lau guu na Maa kamolu 'i salo nai, sulia nao nia si dooria sae ta kaa wela 'ana wela neki ka nao'ana.” ");
INSERT INTO bvd_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Sa Disas ka bae 'urii fuana na toa kwairooi nia ki, “Lea na toolamu ilia ta garoa fuamu, 'oko lea 'oko faarongoa nia ka 'olosia garoa nia 'i matangamuru taifili kamuru. Lea nia ka rongo sulia bae lamu, 'oko oli fainia muru ka too kwaimani lau gwamuru. ");
INSERT INTO bvd_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma lea nia ka nao si rongo sulia bae lamu, 'oko 'ailia mai ta tii wane ma nao ta roo wane lau fai 'oe, suli doo 'uri nai ki ta roo wane ma nao ta olu wane na mone daka faamamanea uri ka ngado. Na kekeda laa abu nia bae 'urii, ‘Ta roo wane ma nao ta olu wane na mone uri daka faamamanea na bae lana.’ ");
INSERT INTO bvd_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Lea nia nao si rongo gu sulia tee ne kera saea, 'oko talaia uri muru ka baelia 'i naofana konia nia God. Ma lea nia ka nao si rongo lau guu sulia bae lana konia nia God, 'oko liotona naa nia waa nao si saitomana 'ua guu God ma nao ta waa 'ana waa abulo ta'aa neki 'ana koni malefo lae ki 'ana takisi nia gafman. ");
INSERT INTO bvd_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Doo mamana nau ku saea fuamolu nia 'urii, si doo ne kamolu molu luia lao ano nee, God boroi nia luia lau guu 'i salo. Ma si doo ne kamolu molu faolomainia lao ano nee, God boroi nia faolomainia lau guu 'i salo. ");
INSERT INTO bvd_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Tasi doo lau guu nau ku saea fuamolu nia 'urii, lea ta roo wane 'ani kamolu lao ano nee daru gania God uri tasi doo ma daru ka kwai ala faafi ai, Maa nau 'i salo nia kai falea fuadaru 'afitai ka nao. ");
INSERT INTO bvd_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Suli 'i fai ne ta roo wane ma nao ta olu wane da manata mamana 'ani nau da koni kwaimani 'ana ta kula, nau kwai nii fai kera.” ");
INSERT INTO bvd_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Sa Bita nia lea mai ka ledi 'urii 'ana sa Disas, “Aofia 'ae, fita si kada ki fatai ne nau kwai manata lukea toolaku sulia? Lelea ka dao fatai 'ana fiu si kada ki?” ");
INSERT INTO bvd_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ma sa Disas 'e luu nia ka 'urii, “Nau ku saea fuamu, nao lau fiu si kada ki. Fiu taafuli si kada ma fiu si kada bae. ");
INSERT INTO bvd_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Doo ne adea guu 'initoaa God ka mala 'ana waa 'inito bae dooria kai 'olosia ngali langaa wane rao nia ki siana nai. ");
INSERT INTO bvd_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aia, etana wane rao ne nia dao mai nia ngali lalanga 'ana bobola fai nia molee malefo. ");
INSERT INTO bvd_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ma na wane rao nai ka nao si bobola naa fai nia duu lana ngali langaa nia, ma na waa 'inito nai ka saea naa kera dai faafoli 'ani nia, fai nia 'afe nia, ma wela nia ki, ma 'okona doo nia ki tiifau uri duu lana ngali langaa nia nai. ");
INSERT INTO bvd_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ma na wane rao nai ka lea mai ka booruru naa 'i maa 'aena waa 'inito nai, ma ka kwai amasi ka 'urii, ‘'Oe mamarato fasi 'amu fai nau, uri nau ku duua na malefo 'oe nai ki tiifau.’ ");
INSERT INTO bvd_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ma na waa 'inito nai ka manatainia 'asia naa ka manata luke nia na 'ana fai ngali langaa nia. Ma ka saea nao nia si duua boroi 'ana ka faolomainia ka lea na 'ana. ");
INSERT INTO bvd_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Aia, kada wane rao nai 'e ruu kau 'i maa, nia ka dao tona naa ta wane rao lau guu. Waa nai 'e ngali langa 'ana kaa seleni tu'uu 'asia guu siana. Nia ka daua sa wala nai ka safali 'ini na 'i luana, ka bae 'urii, ‘'O duua 'ua malefo nau baki 'oe ngali lalanga ai!’ ");
INSERT INTO bvd_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ma waa rao nai ka booruru, ka kwai amasi fuana ka 'urii, ‘'Oe mamarato fasi 'amu fai nau, uri ku duua malefo 'oe ki tiifau fuamu.’ ");
INSERT INTO bvd_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Sui boroi nia ka ote nia guu, ma ka ngali nia ka alu nia lao lookafo, uri ka too lelea nia ka duua guu ngali langaa nia. ");
INSERT INTO bvd_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ma kada tai wane rao kera suai si doo nai, kera daka kwaimanatai 'asia naa, daka lea siana waa 'inito bae daka faarongoa 'ana doo ki sui guu. ");
INSERT INTO bvd_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Na waa 'inito nai ka 'ailia mai waa rao bae 'i nao ka bae 'urii fuana, ‘'Oe na waa ade lamu ta'aa 'asia na 'ua nee! Nau ku manata lukea na ngali langaa 'oe ki tiifau, sulia 'oe 'o kwai amasi fuaku uri nau ku ilia fuamu. ");
INSERT INTO bvd_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Bobola fainia sa 'oko manatainia lau guu wane rao ne muru rao kwaimani nee, mala bae ku ilia lau guu fuamu.’ ");
INSERT INTO bvd_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ma na waa 'inito nai ka rakesasu 'asia naa, ma ka falea naa kwakwae lae fuana ka alu nia lao lookafo, uri ka too lelea nia ka duua guu malefo nai sui guu nia ngali lalanga ai.” ");
INSERT INTO bvd_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ma sa Disas ka faasuia si tarifulaa nai ka 'urii, “Talafana lau guu doo ne Maa nau 'i salo kai ilia 'ani kamolu nai, lea nao molu si manata lukea toolamolu ki.” ");
INSERT INTO bvd_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kada sa Disas bae mai lelea ka sui, nia ka lea na kau faasia bali lolofaa 'i Galilii, ka lea na kau lao bali lolofaa 'i Diudia, ka ulu folosia kafo 'i Diodan uri bali loko ai. ");
INSERT INTO bvd_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ma na toaa 'oro 'asia naa daka lea naa 'i burina, ma sa Disas ka guraa toaa 'oro 'ana bali nai ne da matai ki ma kera daka 'akwaa sui guu. ");
INSERT INTO bvd_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ma tai Faarisii daka lea lau gu mai uri na ilitoo lana gwada sa Disas. Ma daka ledia, daka 'urii, “Nia 'o'olo gwana 'ana taki sa Mosis uri waa ka lukasia 'afe nia fua mamalana gwana si doo ne nia dooria?” ");
INSERT INTO bvd_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Sa Disas luuda ka 'urii, “Nee rowaa, kamolu nao molu si teemainia guu lao kekeda laa Abu? Na kekeda laa Abu nia bae 'urii, ‘'Ana safali laa mai, God nia saungainia wela wane fai nia wela keni.’ ");
INSERT INTO bvd_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ma na kekeda laa Abu ka bae lau guu 'urii, ‘Fafona si doo nai, wane kai faasia maa nia fai gaa nia, ka 'ado fai nia 'afe nia, ma keeru ka tiidooa naa.’ ");
INSERT INTO bvd_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nao lau roo doo 'e'ete ki, na tiidoe naa. Doo ne adea guu, doo ne God nia kani faafia sui naa, nao ta waa si lukea lau.” ");
INSERT INTO bvd_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ma na Faarisii ki daka ledi nia lau daka bae 'urii, “Si baea fifii sa Mosis falea mai nia saea na wane saitomana ka lukasia gwana 'afe nia, lea nia kedaa leta fua lukasi lana 'afe nia ma ka fale sui naa 'i 'abana 'afe nia. Sui 'utaa ne 'oko saea doo nai abu?” ");
INSERT INTO bvd_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Sa Disas ka bae 'urii fuada, “Sa Mosis nia faolomainia fuamolu toaa Diu ki uri lukasi lana 'afe kamolu ki sulia manatamolu nia sadi 'asia naa. Sui ma 'i nao mai kada God nia saungainia wane fai keni, nao nia si 'uri nai. ");
INSERT INTO bvd_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ma nau ku saea fuamolu, lea ta wane 'e lukasia 'afe nia ma sui 'afe nia ka nao si kaubare guu ma wane nai ka adea lau ta keni 'e'ete, sa wala nai nia kaubarea naa.” ");
INSERT INTO bvd_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Burina sa Disas nia bae 'uri nai fuada tiifau, toa kwairooi nia ki daka bae 'urii fuana, “Ma lea nia 'afitai 'asia naa fua waa arai fai nia 'afe nia 'uri nai, nia diana fua kera daka too boroi 'ada fasi arai lae ma 'afe lae.” ");
INSERT INTO bvd_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ma sa Disas ka 'urii fuada, “Wane 'oro ki nao dasi saitoma diana 'ana si doo mamana nai sulia arai lae. Ma sui boroi bara wane guu ne God falea liotoo lae fuada uri kera daka filoa toolangaidoo laa nai. ");
INSERT INTO bvd_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nau ku saea si doo nai sulia tai wane nao dasi arai, sulia safali 'ana kada kera futa mai doo ki nao si 'o'olo lao nonida, nia ne ilia nao kera dasi bobola fai nia arai lae. Ma tai wane nao dasi arai sulia na wane ki gwana ne da saungai buri 'ana nonida ma ka nao kera dasi bobola fai nia arai lae. Ma tai wane nao kera dasi arai uri kera ka rao tii bali naa fua God. Ma na wane ne kera tala'ana kera ka arai, alu kera da lea 'ada sulia na toolangaidoo laa nee sulia arai lae.” ");
INSERT INTO bvd_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ma 'i burina si doo nai, tai wane daka ngalia mai wela tu'uu ki siana sa Disas, uri nia ka alu 'aba faafida, ma ka foa faafida. Ma na toa kwairooi nia ki daka ngatafida. ");
INSERT INTO bvd_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ma sa Disas ka bae 'urii fuada, “Molu faolomainia wela tu'uu neki da lea 'ada mai siaku, nao molu si luida lau. Suli na 'initoaa God na doo nia 'ana toaa ne da faatu'uu kera 'i tala'ada mala 'ana wela tu'uu.” ");
INSERT INTO bvd_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Sui sa Disas ka alu 'aba faafia wela tu'uu nai ki, ka faadiana kera. Sui, ka lea naa 'ana. ");
INSERT INTO bvd_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","'Ana tii si kada, tii waa daraa 'e lea mai siana sa Disas, ka ledi 'urii, “Wala waa toolangaidoo 'ae, tasi tee diana gu ne nau kwai ilia uri ku too 'ana mauria firi?” ");
INSERT INTO bvd_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Sa Disas ka bae 'urii fuana, “'Utaa ne 'oko ledi nau uria doo diane ki wala? Taifilia God gu ne diana. Lea 'oe dooria 'oko too 'ana mauria firi, 'oko ade sulia taki ki.” ");
INSERT INTO bvd_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ma sa wala nai ka ledia lau sa Disas ka 'urii, “Taki tee ki nai wala?” Sa Disas ka olisi nia ka 'urii, “'Osi sauwane, 'osi kaubare, 'osi belia si doo ta waa, ma 'osi suke faafia wane ki. ");
INSERT INTO bvd_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ma 'oko sae'inito 'ana maa 'oe fai gaa 'oe. 'Oko liosau 'ana ta wane kau ka ilingia lau guu ne 'oe liosau 'ani 'oe tala'amu.” ");
INSERT INTO bvd_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Sui sa wala nai ka bae 'urii fua sa Disas, “Doo ku ilia sui ki naa nai. Tee lau ne nao kwasi ilia 'ua?” ");
INSERT INTO bvd_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ma sa Disas 'e luu nia ka 'urii, “Lea 'oe dooria 'oko too 'o'olo tiifau, lea kau 'oko faafoli 'ana doo 'oe ki tiifau, ngalia malefo nai, 'oko falea fuana toaa neana ki, sui 'oko too na 'amu 'ana suadooa 'i salo. Sui fatai 'ofi lea mai buriku.” ");
INSERT INTO bvd_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ma kada wane daraa nai 'e rongoa doo nai ki, na manatana ka 'asia naa, ma nia ka lea na 'ana, sulia nia wane suadoo 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ma sa Disas ka bae 'urii fuana toa kwairooi nia ki, “Nau ku saea fuamolu, nia 'afitai tasa fua wane suadoo kera daka ruu 'i lao 'initoaa God. ");
INSERT INTO bvd_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ma nau ku saea lau guu fuamolu, nia 'afitai tasa fua kamel ka ruu sulia maekwadaa tu'uu 'aena 'ogile. Nia 'afitai ka tasa lau fua ta wane suadoo ka ruu lao 'initoaa God.” ");
INSERT INTO bvd_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Aia, ma kada toa kwairooi nia ki kera rongoa doo nai ki, kera daka kwele 'asia naa, daka bae 'urii, “Ma lea nia 'afitai lelea ka 'uri nai naa fua waa suadoo, sii sa tii naa ne tala'ana ka mauri nai rowaa?” ");
INSERT INTO bvd_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Sa Disas abulo ka lio kau fuana toa kwairooi nia ki ka bae 'urii, “Na wane 'ana ne nia 'afitai fua 'ana mauria firi, ma God nao nia si 'afitai guu fuana. Na doo ki sui guu nia walude gwana 'ana God.” ");
INSERT INTO bvd_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","'Ana kada nai, sa Bita ka ledia sa Disas ka 'urii, “Ma kameli mone 'utaa? Suli kameli meli faasia sui na mai suadooa kameli baki tiifau, ma meli ka lea na mai burimu. 'Uri nai tee ne God kai faa fuameli?” ");
INSERT INTO bvd_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ma sa Disas 'e luua fuada ka 'urii, “Ku faarongo 'isi 'ani kamolu, kada God kai saungai falu 'ana doo ki sui guu, nau, na 'Alakwa Nia Wane, kwai gooru 'ana fuligoorua ni 'inito laa nau uri didi lana toae ki sui. 'Ana kada nai, kamolu akwala ma roo waa kwairooi nau neki, molu kai gooru kwaimani fai nau 'ana didi lana akwala ma roo kwalafaa neki 'Israel. ");
INSERT INTO bvd_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aia, ma waa ne faasia luma nia, ma toolana ki, ma waiwane nia ki, ma maa nia fai nia gaa nia, ma wela nia ki, ma nao saegano nia, sulia nia lea 'i buriku, na waa nai nia kai todaa doo 'oro diana ka talua lau doo baki nia too ki ai 'i nao. Ma nia kai too lau guu 'ana mauria firi. ");
INSERT INTO bvd_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ma toaa 'oro ne kera 'inito 'i tari'ina, kera dai siofaa, ma toaa 'oro ne kera da siofaa 'i tari'ina, kera dai 'inito.” ");
INSERT INTO bvd_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Sa Disas ka bae lau 'urii fua toa kwairooi nia ki, “Na 'initoaa God nia ilingia tii waa baita nia lea 'i 'uubongi abu uri laefi lana wane ki uri rao lae lao ola nia. ");
INSERT INTO bvd_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nia alangai kai foli kera 'ana malefo ne bobola fai nia tii fa dani guu, sui ka odu kera daka lea naa uri rao lae 'ana ola nia. ");
INSERT INTO bvd_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Dao sikwana si kada sato 'i 'uubongi, nia ka lea lau guu, ka suana tai waa ne kera da uu tatakwai ki gwada maa usie, ka nao dasi ilia guu tasi doo. ");
INSERT INTO bvd_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ma nia ka bae 'urii fuada, ‘Molu lea mai molu rao 'ana ola nau, ma nau kwai foli kamolu 'ana malefo fua si raoa nai.’ ");
INSERT INTO bvd_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kera daka lea naa. “Dao tofungana sato, fai nia lao oluna kada sato, nia ka lea lau, ka ilia lau guu 'uri bae. ");
INSERT INTO bvd_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ma dao 'ana limana kada sato saulafi, nia ka lea ka dao tona tai waa lau guu ne kera uu tatakwai ki gwada maa usie. Ma nia ka ledi kera ka 'urii, ‘'Utaa ne molu ka uu tatakwai gwamolu 'i seki sulia fa sato laulau nee, ma nao molu si ilia guu tasi doo nee?’ ");
INSERT INTO bvd_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Kera olisi nia daka 'urii, ‘Tee nao ta waa si odu kameli guu uri rao lae.’ “Ma nia ka bae 'urii fuada, ‘Molu lea mai molu rao 'ana ola nau.’ ");
INSERT INTO bvd_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Dao kada sato 'e suu naa, waa nai 'ana ola nai ka bae 'urii fua waa ne nia alu ka lio sulia toa rao nai, ‘'Ailia mai toa rao bae 'oko foli kera naa. 'O safali folia fasi toa bae nau ku ngali 'isi mai 'ani kera, lelea 'oko 'isia 'ana toa bae da safali rao 'i nao.’ ");
INSERT INTO bvd_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Na toa bae da rao 'isi 'i saulafi naa kera dao mai, nia ka foli kera sui guu 'ana malefo ne bobola fai nia rao lae 'ana tii maedani nai. ");
INSERT INTO bvd_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ma kada toa bae nia safali ngali kera mai 'i nao kera dao, kera daka kwaifii 'ada sae sa nia kai foli kera ka taa 'idu lau. Sui ma kera sui guu daka ngali ka bobola sui guu 'ana malefo ne bobola fai tii maedani. ");
INSERT INTO bvd_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ma kada kera ngalia kera daka bae buri naa 'ana waa bae 'ana ola daka 'urii, ");
INSERT INTO bvd_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Na toa ne 'oe talaida mai 'isi nee, kera rao gwada sulia si kada sato kukuru, ma sui 'oko folida ka bobola lau guu fai kameli toa ne meli rao baita 'asia na mai sulia fa sato laulau nee, ma sato ka sato fifii 'asia naa 'ani kameli fai nia.’ ");
INSERT INTO bvd_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ma nia ka luua ta tii waa 'ani kera ka 'urii, ‘Wala 'ae, nau kwasi ili ta'aa gu fuamu. 'Oe bae 'o ala faafia mai rao lae uri si malefo bobola fai nia tii maedani. ");
INSERT INTO bvd_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ngalia kau fofolia 'oe, 'oko lea na 'amu. Nau 'ana ne ku dooria foli lana toa ne nau ku laefi kera 'i 'isi ka uria lau guu ne ku foli kamolu. ");
INSERT INTO bvd_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ma nau ku too 'ana rigitaa fuana ili lana tee ne nau ku dooria kwai ilia 'aku 'ana si malefo nau 'i tala 'aku. 'Utaa ne 'oko 'ugali nau, sulia ne nau ku faadiana 'ana toa loko?’” ");
INSERT INTO bvd_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ma sa Disas 'isia bae lana ka 'urii, “Doo ne adea guu, na toa da 'isi ki kera dai eta 'i nao, ma toa da eta 'i nao dai 'isi lau.” ");
INSERT INTO bvd_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Si kada sa Disas nia lea naa uria 'i Durusalem, nia ka talaia toa kwairooi nia ki ka bae fuada taifili kera ka 'urii, ");
INSERT INTO bvd_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Molu fafurongo fasi ku faarongo kamolu. Kolu lea na kau uria 'i Durusalem nai. Nau, 'Alakwa Nia Wane, tii waa kai fale nau 'i 'abana waa baita ni foa ki fai nia waa toolangaidoo ki 'ana taki, uri kera daka kwai ala faafi uri saungi laku. ");
INSERT INTO bvd_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ma kera dai fale nau 'i 'abana toa nao lau Diu ki, uri kera daka 'onionga 'ani nau ma daka kwae nau ma daka foto faafi nau ku mae 'ana 'airarafolo. Ma sui dao oluna fa dani, God kai tae nau lau gwana fasi maea.” ");
INSERT INTO bvd_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Burina doo nai ki, 'afe sa Sebedii fai nia roo 'alakwa nia ki, sa Demes fai nia sa Dion, kera daka dao mai uri bae lae fai nia sa Disas. 'Initai nai lea mai ka booruru 'i maa 'aena sa Disas ka ledi talana roo wela nia ki. ");
INSERT INTO bvd_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ma sa Disas ka ledia 'initai nai ka 'urii, “Tee ne 'o dooria?” Nia ka bae 'urii, “Nau ku dooria 'oko faolomainia roo 'alakwa nau neki, uri daru ka gooru kwaimani fai 'oe lao 'initoaa 'oe, ta waa 'i bali aolo 'amu, ma ta waa 'i bali mauli 'amu.” ");
INSERT INTO bvd_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","'Ana kada nai, sa Disas ka bae 'urii fuana roo waa nai ki, “Doo ne kamuru gania nai, kamuru nao si saitomana gu malutana. Kamuru tala 'ana gwamuru liu lae lao nonifiia ne nau kwailiu 'i laona?” Ma keeru ka bae 'urii, “Iuka, kaari miri tala'ana gwamiri.” ");
INSERT INTO bvd_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Sa Disas ka bae lau 'urii fuadaru, “Nia mamana, na nonifiia nai kai dao toomuru. Sui ta, si doo nai uri ta waa 'amuru ka gooru 'ana 'i bali aolo 'ani nau, ma ta waa 'i bali mauli 'ani nau mala ne muru dooria nai, nao lau nau ne kwai faa. Maa nau 'ana ne kai faa fuana tii kera ne nia filida fuai.” ");
INSERT INTO bvd_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kada na akwala waa kwairooi baki kera rongoa si doo nai, kera daka rakesasu naa 'ana roo waisaasina nai ki. ");
INSERT INTO bvd_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nia ne, sa Disas ka 'aili kera tiifau mai siana, ka bae 'urii, “Kamolu saitomana na waa 'inito kera neki toaa nao lau Diu ki, kera da 'inito ma daka suumainia toaa kera ki fua ili lana doori lada. ");
INSERT INTO bvd_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Sui ta, ni kamolu nao molu si ilia lau si doo nai 'i malutamolu. Lea ta waa 'amolu nia dooria ka kwaitalai fuamolu, nia na waa ni rao kamolu gwana. ");
INSERT INTO bvd_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma lea ta waa 'amolu nia dooria kai 'inito, waa nai nia waa ni rao tatakwai nia toae sui gwana. ");
INSERT INTO bvd_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nia mala lau guu ni nau, na 'Alakwa Nia Wane, ne nao kusi lea lau mai uri daka rao fuaku. Nau ku lea lau 'aku mai uri ku rao fuana toae ki sui guu, ma ku falea mauri laku uri oli lae mai fai nia toaa 'oro ki sui.” ");
INSERT INTO bvd_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ma kada sa Disas fai nia toa kwairooi nia ki da faasia maefera 'i Diorikoo, toaa 'oro 'asia naa daka lea 'i burida. ");
INSERT INTO bvd_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ma na roo waa maada rodo ki keeru gooru ninimana taale. Ma kada keeru rongo sa Disas lea mai sulia taala nai, keeru ka 'ai naa daru ka 'urii, “Aofia 'ae, 'oe waa 'ana kwalafaa sa Defet, 'o manatai kaari mai!” ");
INSERT INTO bvd_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ma konia baita nai daka ngatafi keerua daka 'urii, “Muru taaro 'amuru wala!” Sui boroi ma kada kera bae 'uri nai, keeru kafi 'a'ai baita tasa fatai 'urii, “Aofia 'ae, 'oe waa 'ana kwalafaa sa Defet, 'o manatai kaaria mai.” ");
INSERT INTO bvd_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ma kada sa Disas rongo keeru 'ai mai 'uri nai, nia ka uu ngado naa, ka 'aili keeru na mai, ka ledi keeru 'urii, “Tee ne kamuru dooria nau kwai ilia fuamuru?” ");
INSERT INTO bvd_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Keeru luu nia daru 'urii fuana, “Kaaria dooria 'oko 'ifingia maa miri uri kaari ka lilio.” ");
INSERT INTO bvd_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","'Uri nai, sa Disas ka manatai keerua ka dau tona maa daru. Ma si kada nai 'ua guu maa daru ka lilio naa daru ka lea naa fai sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Si kada sa Disas fai nia toa kwairooi nia ki kera da lea karangia na kau 'i Durusalem, kera dao fasi kau maefera 'i Betfeis, 'i gwauna uo 'i 'Olif. Dao kera too 'i seeri, sa Disas ka odua ta roo wane 'ana toa kwairooi nia ki uri daru ka lae kau 'i nao, ");
INSERT INTO bvd_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nia ka bae 'urii fuadaru, “Muru lea fasi kau 'i nao uri maefera loko. Tara kamuru lea kau dao ai muru kai suana tii dongki kera kania ka uu gwana fai nia kalena siana. Lea muru ka lukea, muru ka talaida mai siaku. ");
INSERT INTO bvd_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ma lea ta waa ledi kamuru, muru ka bae 'urii fuana, ‘Na Aofia ne dooria.’ 'Uri nai tara nia 'ali'ali ka faolomaida fuamuru.” ");
INSERT INTO bvd_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Si doo nai nia fuli uri ka faamamanea si baea bae brofet nia saea mai kada 'i nao ka 'urii, ");
INSERT INTO bvd_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Molu saea fua toaa 'i Durusalem molu ka bae 'urii, ‘Suana fasi, Na waa 'inito kamolu, 'e dao na siamolu. Nia faatu'uu nia, ka lea gwana mai fafona dongki. 'E lea mai fafona dongki kafi baita.’” ");
INSERT INTO bvd_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ma roo waa kwairooi nai ki daru ka ili na suli bae lana sa Disas daru ka eta na 'i nao. ");
INSERT INTO bvd_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Keeru ka talaia na mai dongki nai fai nia kalena. Dao kera daka samatainia naa maku kera ki 'i sulina kaledoo nai, sui sa Disas ka raa ka gooru na 'i fafona. ");
INSERT INTO bvd_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Na konia baita nai daka samatainia naa maku kera ki sulia taala nai, ma tai toaa daka sikilia mai sarana baibai daka samatainia naa sulia taale. ");
INSERT INTO bvd_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na figua baita nai kera eta 'i nao 'ana sa Disas, ma toaa da 'isi kau 'i burina, kera ka suungi daka bae 'urii, “Tango laa fuana wela nee 'ana kwalafaa sa Defet! Ma dianaa fuana sa wala nee ne nia lea mai fai nia rigitaa God! Tangoa God 'i langi!” ");
INSERT INTO bvd_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ma kada sa Disas nia dao lao fera 'i Durusalem, na fera nai ka ngalungalua baita, ma toaa nai daka ledi 'urii, “Nee rowaa, ma sa tii nee?” ");
INSERT INTO bvd_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ma toaa nai lao konia nai daka 'urii, “Sa Disas na brofet bae ne. Waa bae faasia maefera 'i Naasaret lao bali lolofaa 'i Galilii.” ");
INSERT INTO bvd_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kada sa Disas lea mai ka dao lao beukaua God, nia ka taria toaa ne kera usi 'ada 'i seeri ki. Ma nia ka kefusia na gwegwele ni usi laa kera ki toaa da tatala ki 'ana malefo, ma ka kefusia gwegwele ni gooru laa kera ki toaa da faafoli 'ana bole ki. ");
INSERT INTO bvd_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma sa Disas ka bae 'urii fua toaa nai ki, “Na bae lana God lao kekeda laa Abu nia bae 'urii, ‘Na Beu nau, na beu foa.’ Sui ma molu ka talana ka alu naa beu kera toaa ni beli ki.” ");
INSERT INTO bvd_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","'Ana kada nai, toaa maarodo, ma toaa 'aemae ki kera lea lau gu mai siana sa Disas lao Beukaua nai, ma nia ka gurada tiifau. ");
INSERT INTO bvd_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Aia, na waa baita ni foa ki, fai na waa toolangaidoo ki 'ana taki, kera da suana doo diana nai ki sa Disas nia ilia ma daka rongoa wela tu'uu nai ki da suungi daka saea, “Tango laa fua wela nee 'ana kwalafaa sa Defet!” 'I seeri, kera daka rakesasu 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ma na waa baita ni foa ki fai na waa toolangaidoo nai ki, kera daka bae 'urii fua sa Disas, “'Oe nao 'osi rongo gu doo ne wela neki da ilia nee?” Ma sa Disas ka luu kera ka 'urii, “Iuka, nau ku rongo gwaku na. Sui ma kamolu mone nao molu si teemainia guu doo bae kekeda laa Abu sae bae? Nia bae 'urii bae, ‘'Oe 'o toolangainia tango lae fua wela tu'uu ki ma wela neki da susu 'ua gwada uri kera daka tango 'oe 'ada.’” ");
INSERT INTO bvd_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","'Uri nai sui, sa Disas fai nia toa kwairooi nia ki, kera daka lea naa faasia 'i Durusalem, daka lea uri Betanii daka tio na mai seeri 'afa rodo nai. ");
INSERT INTO bvd_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Dao 'i 'uubongi naa, kada sa Disas fai nia toa kwairooi nia ki kera da oli na mai uria 'i Durusalem, sa Disas ka fiolo. ");
INSERT INTO bvd_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ma nia ka suana kau tii 'ai fig nai uu 'i ninimana taale nia ka fali kau 'i 'aena. Sui ma ka suai nao gu ta fuaedoo ai, otona gwana 'abana. Ma nia ka bae 'urii fuana 'ai fig nai, “'Ita tari'ina ka oli 'alaa 'osi fungu lau ata fuaedoo.” 'Ana si kada nai 'ua guu kera daka suana 'ai nai ka kuku naa. ");
INSERT INTO bvd_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kada toa kwairooi ki da suai doo nai, kera daka kwele 'asia naa, daka ledi 'urii, “Tee ne adea 'ai bae ka mae 'ali'ali gwana nee?” ");
INSERT INTO bvd_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ma sa Disas luuda ka 'urii, “Nau ku saea fuamolu, lea kamolu faamamane ma ka nao molu si manata ruarua, kamolu tala'ana molu ka ilia gwamolu si doo ne talua lau doo ne ku ilia 'ana 'ai fig ne. Lea molu saea fua fa uo ne, ‘'Oe 'idu 'amu kau lao asi fubae,’ tara nia ka ilia gwana. ");
INSERT INTO bvd_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Lea molu faamamanea God, nia kai ilia doo ne kamolu gania siana.” ");
INSERT INTO bvd_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Aia, si kada sa Disas nia ruu kau lao lalo baita bae 'ana beukaua God fua toolangaidoo lae fua toae ki, na waa baita ni foa ki ma tai toa gwaungai kera Diu ki lau guu, kera daka lea mai siana. Kera dao tona daka ledi nia 'urii, “Nee wala, 'oe too 'ana rigitaa tee ne 'oko ilia doo neki nee? Ma tii ne faa rigitaa nee fuamu?” ");
INSERT INTO bvd_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Sa Disas nia luu kera ka 'urii, “Iuka, nau ku ledi kamolu fasi uria tii si doo. Lea molu ka luua mai ka too fatai, nau tara kufi faarongo kamolu 'ana rigitaa ne nau ku too ai uri ili lana doo neki. ");
INSERT INTO bvd_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Iuka, kamolu saea fasi fuaku, na rigitaa ne sa Dion nia too ai fua faasiuabu lae, nia lea mai fasi 'i fai? 'E lea mai fasi God ma nao 'e lea mai fasi wane gwana?” Ma kera daka safali olisusuu 'i matangada kwailiu daka 'urii, “Tee ne kolu kai saea? Lea kolu luu nia ma kolu ka 'urii, ‘Nia lea mai fasi God,’ nia kai bae 'urii na, ‘Sui 'utaa ne nao molu si faamamanea sa Dion?’ ");
INSERT INTO bvd_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma lea kolu ka bae 'urii, ‘Nia lea mai fasi wane gwana,’ toaa neki daka rakesasui kolu na.” Kera da mau, sulia na toae ki kera faamamanea sa Dion nia na brofet. ");
INSERT INTO bvd_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","'Uri nai kera olisi nia daka 'urii gwada, “Kameli ulafusia sa tii ne falea rigita fua sa Dion ka faasiuabua toae ki.” Ma sa Disas ka bae 'urii fuada, “Iuka, lea nia 'uri nai, nao nau kusi saea lau guu fuamolu sa tii ne falea rigitaa ne fuaku nai.” ");
INSERT INTO bvd_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Sa Disas ka bae lau gu 'urii fuada, “Molu manata fasi sulia tii si ununua 'e 'urii. Tii waa nia too 'ana roo wela wane ki. Ma nia lea ka bae 'urii fuana wela 'i nao, ‘'Alakwa nau 'ae, lea 'oko rao fasi lao ola kolu bae 'i tari'ina.’ ");
INSERT INTO bvd_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Na wela nai 'e luua maa nia ka bae 'urii, ‘Nau tara nao kwasi lea guu.’ Ma sui nia ka talana manata lana ka lea lau gwana 'i ole. ");
INSERT INTO bvd_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Arai nai ka lea lau gu siana wela 'i buri, ka saea lau guu tii si baea bae fuana. Ma wela nai ka luu nia ka 'urii, ‘Diana 'asia naa, nau kwai lea.’ Ma sui, nia ka nao si lea guu. ");
INSERT INTO bvd_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“'Uri nai ma sa tii 'adaru ne ilia si doo bae maa keeru 'e dooria?” Ma kera da luu nia daka 'urii, “Na wela bae 'i nao.” Ma sa Disas ka bae 'urii fuada, “Si doo mamana ku saea fuamolu 'e 'urii, na toa ni koni lana malefo 'ana takis, ma wela keni olodola ki, kera dai ruu lao 'initoaa God 'i nao 'ani kamolu. ");
INSERT INTO bvd_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Suli sa Dion waa faasiuabu bae nia dao ka faatainia 'o'oloa nia God siamolu uri molu ka ade sulia, ma sui ka nao molu si faamamane nia guu. Ma sui, na toaa ta'aa baki 'ana koni lana malefo 'ana takis ma na 'aini wela keni olodola baki, kera 'ana daka faamamane nia. Burina molu suana doo nai ka sui naa boroi, kamolu nao molu si faamamanea guu sa Dion, ma ka nao molu si bulasi manataa guu.” ");
INSERT INTO bvd_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Sa Disas ka bae lau 'urii fuada, “Molu fafurongoa lau tii si tarifulaa 'e 'urii. Tii waa 'e fasia tii ola greib nai. Ma nia ka sakali kalia, ma ka 'elia tii kilu fua dali ngisi lana fuaedoe ki ai uri saungai lana waen, ka saungainia tii kaa beu ni folo lae siai. 'Uri nai sui, nia ka alua ola nia 'i 'abana toa kera rao 'i laona. 'Uri nai, nia ka lea na 'ana uria ta maefera tau. ");
INSERT INTO bvd_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ma kada na ola nai nia maua, nia ka odua waa rao nia ki daka lea mai siana toa ne kera lio sulia na ola nia, fasi uri kera ka faa mai ta bali 'ana doo ne kera falia ki sui naa. ");
INSERT INTO bvd_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Ma toa nai ki da lio sulia ola nai, kera daka daua waa rao baki, daka ka kwaea tai waa, ma ruana waa kera daka saungia ka mae naa, ma oluna waa kera ka 'uifauna. ");
INSERT INTO bvd_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sui nia ka falea lau tai waa rao 'oro ka talua lau 'i nao daka lea lau. Ma na toa ne kera lio sulia na ola nai, kera ka ili 'uri nai lau guu ada. ");
INSERT INTO bvd_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ma 'isi lana, nia ka falea naa tii fa wela 'autani nia fuada. Ma nia ka manata 'urii, ‘Kera kai sae'inito 'ana 'alakwa nau ne.’ ");
INSERT INTO bvd_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Sui 'ana kada ne toa nai ki kera suana wela nia, kera ka bae kwaimani naa fuada tala'ada daka 'urii, ‘Nia naa ne wela nia waa ne 'inito 'ana ola nee. Kolu saungia ka mae 'ana, uri kolu ka ngalia 'akolu na doo nia neki tiifau.’ ");
INSERT INTO bvd_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ma daka dau nia naa, ma kera ka 'ui 'ani nia 'i maa fasi lao ola nai, ma kera daka saungia ka mae naa. ");
INSERT INTO bvd_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“'Uri nai kada ne waa ne 'inito 'ana ola nai nia dao mai, tee ne nia kai ilia 'ana toa ne kera lio sulia ola nai?” ");
INSERT INTO bvd_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ma kera luu nia daka 'urii, “Nia kai saumaeli kera, ma kai falea lau ola nai fuana waa 'e'ete ki naa uri daka faa 'okodoo 'i satana 'ana koni dooa nai.” ");
INSERT INTO bvd_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ma sa Disas ka bae 'urii fuada, “Nia mamana kamolu teemainia na kekeda laa Abu bae nia bae 'urii, ‘Na fau bae waa saungai luma ki kera ote kera ai, nia naa ne fau 'initoe ni faangado lana lume. God ne ilia si doo nai, ma sua lana ka diana 'asia naa.’ ");
INSERT INTO bvd_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Doo ne adea guu nau ku saea fuamolu, na 'initoaa nia God kera da kai lafua faasi kamolu ma da kai falea 'ada fuana toaa da ade sulia ki bae lana God. ");
INSERT INTO bvd_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ma waa ne nia 'asia fafona fau nai, nia kai maga. Ma waa ne fau nai kai 'asia faafia, nia kai meme tiifau.” ");
INSERT INTO bvd_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ma kada ne waa baita ni foa ki ma Faarisii ki, kera rongoa tarifulaa nai, kera da lio saitomana sa Disas nia bae gwana suli kera. ");
INSERT INTO bvd_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nia ne adea kera ka dooria kera daka dau nia. Sui ma daka mau, sulia ne toaa 'oro ne kera koni 'ana kada nai, kera faamamanea sa Disas nia na brofet. ");
INSERT INTO bvd_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Sa Disas 'e bae lau 'ana tarifulaa ki fua toa gwaungai ki ka bae 'urii, ");
INSERT INTO bvd_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Na 'initoaa God nia ilingia tii waa 'inito 'e saungainia fafangaa 'ana arai lana 'alakwa nia. ");
INSERT INTO bvd_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nia odua toa ni rao nia ki daka lea uria toaa neki nia laefida mai fua fafangaa nai, uri daka lea na mai. Ma sui kera daka ote kera lea gu mai. ");
INSERT INTO bvd_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Sui na waa 'inito nai ka odua lau tai waa ni rao ka bae 'urii fuada, ‘Kamolu lea molu ka faarongoa toaa ne nau ku laefida ki, na fafangaa ne ku saungainia 'e kwaimaakwalii sui naa. Nau ku saungia sui naa buluka baita nau ki ma na buluka diana kafi baita nau ki, ma na doo ki tiifau daka kwaimaakwalii sui naa. Saea kera lea na mai 'ana fafangaa nau nee.’ ");
INSERT INTO bvd_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Sui boroi 'ana kera daka lea 'e'ete ki 'ada ma ka nao dasi ade guu sulia bae lana. Ta waa, nia lea rao 'ana lao ola nia, ma ta waa ka lea rao 'ana 'ana sitoa nia. ");
INSERT INTO bvd_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ma tai wane daka daua waa ni rao nai ki, daka kwaeda ma daka saumaeli kera naa. ");
INSERT INTO bvd_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Waa 'inito nai ka rakesasu 'asia naa, ma ka odua kau toa 'oro ni omee nia ki kera lea daka saungia naa waa nai ki da saungia waa ni rao nia ki. Ma daka suungia naa maefera kera toa nai 'ana ere. ");
INSERT INTO bvd_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Sui nia ka bae 'urii fua waa ni rao nia ki, ‘Na fafangaa nee 'e kwaimaakwalii sui naa, sui ma toaa bae ku laefida ki ne nao dasi tala'ana naa uri daka lea mai 'ana fafangaa nee. ");
INSERT INTO bvd_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Molu lea kau sulia taala baite ki, molu ka faarongoa tii gwana ne molu dao tona, kera daka lea mai 'ana fafangaa nee.’ ");
INSERT INTO bvd_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Na waa ni rao ki daka lea naa sulia taala baite ki. Ma daka konia na mai mamalana gwana wane ne kera dao toda ki, ne kera sui gwana toaa diane ma toaa ta'ae ki. Ma daka koni mai fua lao luma nai 'ana faalua nai lelea ka fungu 'alamaa guu. ");
INSERT INTO bvd_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Na waa 'inito nai nia lea mai ka dao naa ma ka iroa naa toaa nai kera dao ki mai. Si kada nia ade 'uri nai, nia ka suana tii waa nai nao si ofi gu mai 'ana maku nai fua faalua nai. ");
INSERT INTO bvd_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Na waa 'inito nai ka bae na 'urii fuana, ‘Nee wala, ma sa tii ne faolomai 'oe 'oko ruu mai seki ne 'oe nao 'osi ofi gu mai 'ana maku fua faalua nee 'urii?’ Sa wala nai ka ulafusia naa si doo kai saea. ");
INSERT INTO bvd_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Na waa 'inito nai ka bae na 'urii fua waa ni rao nia ki, ‘Lae molu karoa 'abana fai 'aena ki, lea sui ngalia kau molu ka 'ui 'ani nia lao rorodoa laa fubae 'i maa. Tara nia kai too 'i seeri lao angie ma na didilifoe.’” ");
INSERT INTO bvd_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sa Disas ka bae na 'urii, “God nia 'ailia mai toaa 'oro, ma sui ta bara waa gwana 'ani kera ne nia filida ki.” ");
INSERT INTO bvd_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Na Faarisii ki kera daka alu tii manataa naa uria kefusi lana sa Disas 'ana tasi doo ne nia saea. ");
INSERT INTO bvd_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ma daka falea toa kwairooi kera ki fai nia tai waa ne kera dooria kwalafaa sa Herod ka 'inito kera ka lea naa siana sa Disas. Kera daka bae 'urii, “Waa toolangaidoo 'ae, kameli saitomana doo 'oe saea ki, doo mamane ki sui naa. 'Oe toolangaidoo lau guu sulia mamanaa ma kwaidooria God 'ua guu fua wane. Ma 'oe 'osi 'ado guu fai ta waa 'ana ta tee ne kera manata sulia. Ma nao 'oe 'osi manata kwaifa'ogai guu 'ana manata lana wane. ");
INSERT INTO bvd_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Iuka, 'oe saea fasi mai fuameli! 'Uri nai na taki kia, nia luia na fale lana malefo 'ana takisi fuana waa gwaungai 'i Rom? 'Uri nai nia bobola fai nia kameli kai falea takis bae ma nao, 'e nao?” ");
INSERT INTO bvd_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ma sa Disas ka saitomana naa na kwai'olofia ta'aa kera, ma ka bae 'urii, “Kamolu toa kwaisukei neki, tee ne adea molu ka sasi uria kefusi laku? ");
INSERT INTO bvd_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Molu faatainia fasi na malefo ne kamolu kai folia 'ana takis na.” Ma kera ka ngalia mai tii fa seleni nai daka faatainia fuana. ");
INSERT INTO bvd_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ma nia ka ledi kera ka 'urii, “Na nunu sa tii ne, fai nia satana sa tii ne?” ");
INSERT INTO bvd_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kera luu nia daka bae 'urii, “Na nununa fai nia na satana waa 'inito 'i Rom na.” Ma sa Disas ka bae 'urii, “Si doo nia ki waa 'inito 'i Rom molu ka faa 'amolua fuana, ma si doo nia God ki molu ka faa 'amolua fua God.” ");
INSERT INTO bvd_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ma kada kera rongo naa si olisi baea laa nai ka diana 'uri nai, kera ka kwele 'asia naa, ma daka lea na 'ada faasi nia. ");
INSERT INTO bvd_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","'Afa dani nai lau guu, na waa Sadiusii ki kera da lea mai siana sa Disas. (Na Sadiusii ki kera saea waa mae naa nao kera kasi tatae lau faasia na maea.) ");
INSERT INTO bvd_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ma kera ka ledia sa Disas, daka bae 'urii, “Wala waa toolangaidoo, sa Mosis nia kedaa na taki fuaka ka bae 'urii, ‘Lea ta waa nia mae, ma na 'afe nia ka mauri 'ua, ma sui nao nia si too 'ana ta wela, na toolana ka adea lau gwa 'oru nai, uri keeru ka too 'ana ta wela uri ka ladofulina sa wala nai 'e mae.’ ");
INSERT INTO bvd_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tii bara waisaasina 'i seki 'ani kolu toaa Diu, kera too 'ana fiu waisaasina ki. Ma na ulunao 'e adea tii saari. Aia, ma 'ana kada keeru dasi too 'ua 'ana ta wela, waa nai ka mae naa 'ana. ");
INSERT INTO bvd_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Na ruana waa ka adea lau na wela keni nai. Aia, ma nao keeru si too 'ua guu 'ana ta wela, arai nai ka mae lau gwana. Oluna waa ka adea lau, ma ka mae lau guu. Nia ade 'uri nai lelea fiu waisaasina nai ki, kera mae ka sui guu. ");
INSERT INTO bvd_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Burina bara waisaasina nai kera mae tiifau, wela keni nai boroi ka mae lau guu. ");
INSERT INTO bvd_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Aia, ma wela keni nai nia 'afe mai 'ana fiu waisaasina nai ki sui guu. Lea 'uri nai, kada toae ki da tatae faasia maea, sa tii 'ana fiu waisaasina nai ne arai mamana nia 'initai nai?” ");
INSERT INTO bvd_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Sa Disas ka olisi kera ka 'urii, “Kamolu garo nai, sulia kamolu nao si saitomana kekeda laa Abu ki fai nia rigitaa God. ");
INSERT INTO bvd_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sulia, kada ne toaa mae ki kera kai tatae lau uri mauria, kera mala naa 'ada na 'ensel ki 'i salo ne nao dasi ade keni ma dasi arai naa. ");
INSERT INTO bvd_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Iuka, nau ku toolangaidoo siamolu sulia na tataea faasia maea. Nau ku saitomana kamolu teemai sulia doo bae God saea 'uana mai ka 'urii, ");
INSERT INTO bvd_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nau na God sa 'Abraham, ma God sa 'Aesak, ma God sa Diakab.’ Na toolangai lana 'urii, waa nai ki ne kera mae naa, God nia saea nia God kera 'ua, sulia kera mauri lau daka too kwaimani fai nia.” ");
INSERT INTO bvd_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ma 'ana kada ne toaa 'oro nai kera koni kalia sa Disas, kera rongoa si doo nai, kera daka kwele 'asia naa 'ana toolangaidoo laa nia. ");
INSERT INTO bvd_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","'Ana kada ne Faarisii ki kera rongoa sa Disas nia faataaroa Sadiusii ki 'ana olisi lada, kera daka koni na mai siana. ");
INSERT INTO bvd_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ma tii waa ada ne nia waa toolangaidoo 'ana taki ki, nia ka ili uria kefusi lana sa Disas ka ledi 'urii 'ani nia, ");
INSERT INTO bvd_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Wala waa toolangaidoo 'ae, si baea fifii tee gu ne baita ka talua si baea fifii ki sui guu.” ");
INSERT INTO bvd_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ma sa Disas 'e luua ka 'urii, “‘'O liosau 'ana Aofia na God 'oe, 'ana manata lamu tiifau, ma na mangomu tiifau, ma na liomu tiifau.’ ");
INSERT INTO bvd_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Si baea fifii 'i nao gu nai, ne nia baita tasa ka talua si baea fifii ki sui. ");
INSERT INTO bvd_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma ruana si baea fifii ne talua si baea fifii ki sui ne 'urii, ‘'O liosau 'ana ta wane kau ka mala lau guu ne 'oe liosau 'ani 'oe 'i tala'amu.’ ");
INSERT INTO bvd_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Si baea ki sui naa lao taki sa Mosis, ma lao toolangaidoo laa faasia brofet ki, roo si baea fifii kera uu sui naa 'i fafona nai.” ");
INSERT INTO bvd_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","'Ana kada tai Faarisii kera koni kalia sa Disas, nia ledi kera ka 'urii, ");
INSERT INTO bvd_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Na Kraes, waa ne God nia filia fua faamauri lana toae ki, kamolu saea sa nia futa 'ana sa tii nee?” Kera daka olisi 'urii 'ani nia, “Na Kraes totoo kai futa 'i fulina sa Defet.” ");
INSERT INTO bvd_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Sui sa Disas ka ledi kera lau, “Lea nia futa gwana 'i fulina sa Defet, sui 'utaa ne Anoedoo Abu 'e faabaea sa Defet ma nia ka bae 'urii, ");
INSERT INTO bvd_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘God nia bae 'urii fua Aofia nau: 'Oe too 'amu bali aolo aku 'ana gwaungai lae fai nau, lelea ka dao kada nau kwai alua malimae 'oe ki farana 'initoaa 'oe.’ ");
INSERT INTO bvd_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Sa Defet 'ana tala'ana ne saea na Kraes na ‘Aofia’ nia. Doo ne adea, na Kraes nao lau taifilia ta waa gwana 'i fulina sa Defet. Nia na Aofia sa Defet lau guu.” ");
INSERT INTO bvd_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma nao ta waa ada si bobola naa fai olisi lana 'ana tasi baea. Safali 'afa dani nai, kera daka mau na 'ada 'ana sa Disas ka nao dasi tala'ana naa ledi lana lau. ");
INSERT INTO bvd_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Sa Disas nia bae 'urii fua konia nai fai toa kwairooi nia ki, ");
INSERT INTO bvd_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Na waa toolangaidoo ki 'ana taki ma na Faarisii ki, kera da too 'ana rigitaa mala 'ana bae sa Mosis nia too ai fua toolangaidoo lae sulia taki. ");
INSERT INTO bvd_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nia 'uri nai, molu roo suli kera ma molu ka ili sulia doo neki sui guu da saea fuamolu. Ma sui boroi 'ana, kamolu nao molu si lea sulia abulo lada ki. Suli kera nao dasi ili gu suli doo neki kera da saea ki. ");
INSERT INTO bvd_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kera da konia mai baea fifii 'oro lau ne 'afitai tasa lau uri ili lae sulia fua toae ki ma ka mala naa ta 'okodoo ne kulu 'asia naa. Ma sui kera ka nao dasi noni maabe guu uri 'adomi lana toae ki 'ana ili lae suli baea fifii nai ki. ");
INSERT INTO bvd_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Si doo ki sui guu, kera da ilia gwada uri toae ki daka suada fai nia ma daka saea kera waa diane ki. Kera da saungainia kufidoo reba ki uri foodara lae ki ai, ma daka taia maku tatagwarana tikwa ki. ");
INSERT INTO bvd_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kera da doori gooru sui guu 'ana kula fua waa 'initoe ki 'ana kada fafangaa ki, ma 'ana kula fua waa baite lao beu ni ofu lae ki. ");
INSERT INTO bvd_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kera da dooria 'asia naa uri waa ki daka saea si baea ni faa'inito lada ki ai 'i maana usie ki. Kera daka dooria toae ki daka bae 'urii fuada, ‘Nee wala waa ni toolangaidoo nau!’ ");
INSERT INTO bvd_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Kamolu gu ne, nao molu si faolomainia fua waa ki uri daka bae 'urii fuamolu, ‘Waa ni toolangaidoo nau 'ae, nau ku ade sulia bae lamu,’ suli nau tii waa ni toolangaidoo kamolu nai naa ne. Kamolu sui guu nee, kamolu na bara waisaasina 'ana konia nee kera faamamane ki. ");
INSERT INTO bvd_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma nao molu si faa'initoaa ta waa ni toolangaidoo lae lao fera ne 'i saegano 'ana bae lae 'urii, ‘Maa kameli.’ Nia 'uri nai, suli kamolu molu ka faa'initoaa guu tii Maa kamolu ne nii 'i salo. ");
INSERT INTO bvd_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ma nao si diana fua ta waa gwana ka bae 'urii fuamolu, ‘Waa baita nau,’ suli tii waa baita gu ne molu too ai, ma nia naa ne nau na Kraes, na waa ne God fili nau uri faamauri lana toae ki sui. ");
INSERT INTO bvd_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Na waa ne baita fuamolu, nia na waa ni rao kamolu sui. ");
INSERT INTO bvd_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Waa ne faa'inito nia 'i tala'ana, God kai faasiofa nia. Ma tii gwana ne nia faasiofa nia 'i tala'ana, God kai faa'inito nia.” ");
INSERT INTO bvd_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Sa Disas ka bae 'urii, “Kai ta'aa ka tasa fuamolu waa toolangaidoo ki 'ana taki ma kamolu Faarisii ki lau guu, ni kamolu toa suke nee. Suli kamolu, molu fonoki suusia 'initoaa God fasi toae ki. Kamolu nao molu si ruu gu lao 'initoaa God, ma sui molu ka kwaisuusi lau guu fua toaa ne kera da sasi uri ruu lae 'ada 'i laona. ");
INSERT INTO bvd_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kai ta'aa ka tasa fuamolu waa toolangaidoo ki 'ana taki ma kamolu Faarisii ki lau guu, ni kamolu toa suke nee. Suli kamolu, molu angasi 'asia naa 'ana liufi lana faanoe sui gwana lao asi ma lao tolo, uri talai lana mai ta tii fa waa boroi 'ana uri sae nia ka ade suli taki sa Mosis. Ma sui, si kada waa nai ade gu suli si doo nai molu saea, kamolu molu kafi ade akau fatai 'ani nia uri lea kwaimani lae fai kamolu uri lao kwakwaea baita tasa lao ere. Ma na kwakwaea tara nia kai talu kamolu tiifau. ");
INSERT INTO bvd_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kai ta'aa ka tasa fuamolu, kamolu toaa maarodo ne molu talaia toae. Suli kamolu molu toolangaidoo fua toae molu 'urii, ‘Waa ne alangai ka tofe 'ana Beukaua loo lea nia ka 'oia boroi 'ana alangaia nia ka nao gu ta doo ai. Waa ne tofe lau 'ana 'ana gool loo lao Beukaua loo ne abu 'asia naa uri nia ka 'oia lau alangaia nai.’ ");
INSERT INTO bvd_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kamolu toa maaboko nee, molu oewanea 'asia naa. Doo ai tee 'ana roo doo nai ki ne nia 'initoa ka tasa 'ani keerua sui, na gool loo ma nao na Beukaua loo? Na Beukaua loo lau 'ana lo 'e adea na gool nai ka abu, suli na gool nai 'e nii lao beukaua abu. ");
INSERT INTO bvd_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kamolu molu ka saea lau guu, ‘Waa ne alangai ka tofe 'ana fuliera abu loo lea nia ka 'oia boroi 'ana alangaia nia, ka nao gu ta doo ai. Waa ne tofe lau 'ana 'ana doo ne dai afuafu ai lao fuliera abu loo ne abu 'asia naa uri nia ka 'oia lau alangaia nia.’ ");
INSERT INTO bvd_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kamolu toa nee na maa molu 'e boboko. Doo ai tee 'ana roo doo nai ki ne nia 'initoa ka tasa 'ani keerua sui, na fuliera abu loo ma nao na doo nai dai afuafu ai laona? Na fuliera abu loo lau 'ana lo 'e adea na doo nai da afuafu ai laona ka abu, suli 'e nii lao fuliera abu. ");
INSERT INTO bvd_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Doo ne adea guu, waa ne tofe 'ana fuliera abu loo, nia tofe ai fai doo loki sui guu 'i laona. ");
INSERT INTO bvd_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma waa ne tofe 'ana Beukaua loo, nia tofe lau guu 'ana God waa loo 'e nii lao beu loo. ");
INSERT INTO bvd_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma waa ne tofe 'ana fera 'i salo, nia tofe naa 'ana fulifulia God ma 'ana God waa ne nii 'i salo. ");
INSERT INTO bvd_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Tara kai ta'aa ka tasa fuamolu waa toolangaidoo ki 'ana taki ma kamolu Faarisii ki, kamolu toa suke nee. Kamolu molu fale diana 'asia naa 'ana tangafulu kamolu fua God 'ana doo tu'uu moko diana neki molu fasia ki uri alu lae fai fange ka moko diana. Ma sui, molu ka lio ekwa gwamolu 'ana baea talingai neki lao taki, ne na ade 'o'olo lae, ma na kwai'ofei lae, ma na mamana lae fua God. Molu ili fasi suli si baea talingai neki lao taki, ma ka nao molu si lio ekwa lau guu 'ana si baea tu'uu neki 'i laona. ");
INSERT INTO bvd_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kamolu toa ni kwaitalai ne maa molu 'e boboko. Kamolu molu mala gwamolu waa 'e kaua fa lango tu'uu fasi lao maekafo nia ma sui ka 'akaluaa 'ana kamel doo baita nee. Suli kamolu molu 'ini 'amolua fai ade lae suli si baea tu'uu ki lao taki, molu ka lio ekwa gwamolua 'ana baea talingai neki lao taki. ");
INSERT INTO bvd_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kai ta'aa ka tasa fuamolu toa ni toolangaidoo ki 'ana taki ma Faarisii ki, kamolu toa suke nee. Suli kamolu ade mala wane nia taufia gwana 'i sulina taedoo ni fanga lae ma 'i laona ka buu gwana 'ana bili ta'ae ki. Kamolu molu ngalia mamalana gwana si doo kera wane ki. Ma na birangaa nai ka 'inito na faafi kamolu. ");
INSERT INTO bvd_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kamolu na Faarisii maarodo neki, molu tagisia fasi 'amolua si doo 'i lao liomolu ki ka falu 'i nao sui fatai si doo 'i sara ki. 'I seeri na toae ki daka suana abulo lamolu 'i sara ne nia falu lau guu mala 'ana taedoo ni fanga ne falu sui guu 'i laona fai sulina. ");
INSERT INTO bvd_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kai ta'aa ka tasa fuamolu waa ni toolangaidoo ki 'ana taki ma kamolu na Faarisii ki lau guu, ni kamolu toa suke nee. Suli kamolu molu 'uria kilu gwau da rabu kwakwaoa ada ki ma sua lada kau 'i sara ka diana 'asia naa. Ma sui ta 'i laoda mai ne, 'e fungu 'ana 'okina waa mae ma doo faamamagu ki sui naa. ");
INSERT INTO bvd_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Talafana gu ni kamolu nai, suli kamolu molu ilia doo ki uri toae ki daka suamolu kau fai nia 'i sara ma daka saea kamolu waa 'o'olo ki. Ma sui ta, lao liomolu ki da fungu 'ana sukee ma na garo lae sui naa. ");
INSERT INTO bvd_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","“Kai ta'aa ka tasa fuamolu toa ni toolangaidoo ki 'ana taki, ma kamolu na Faarisii ki lau guu, ni kamolu toa suke nee. Suli kamolu molu saungainia ma molu ka laungia likwafau ki fua brofet baki fai nia toaa 'o'olo baki 'ana kada 'i nao. Ma kamolu molu ka bae lau gu 'urii, ‘Kameli lea sa meli ka too boroi mai si kada bae kokoo kameli ki da too ai, 'afitai gu meli ka 'ado fai kera 'ana saungi lana brofet ki.’ ");
INSERT INTO bvd_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Na bae lamolu nai molu saea kera na kokoo kamolu ki, nia faatai folaa ai ni kamolu toaa 'ana kwalafaa kera toaa nai da saumaelia brofet 'i nao ki. ");
INSERT INTO bvd_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nia 'uri nai, alu molu 'isia na 'amolua raoa bae kokoo kamolu ki da safalia mai 'ana kada 'i nao! ");
INSERT INTO bvd_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kamolu loi neki ma na kwalafaa nee baekwa 'a'ale ki! Tara molu ka tala 'utaa faasia kwakwaea 'ana ere ne naofi kamolu naa nee? Nia 'afitai naa! ");
INSERT INTO bvd_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Doo ne adea nau ku falea kau brofet ki ma wane liotoo ki ma toa fua toolangaidoo lae ki 'ana taki siamolu nai. Tai waa 'ani kera, tara kamolu molu kai saumaeli kera ma molu kai foto faafi kera ki 'ana 'airarafolo. Ta bali 'ada, tara kamolu molu kai kwae kera lao beu ni ofu laa kamolu ki ma molu ka nani burida 'ana maefere ki sui gwana. ");
INSERT INTO bvd_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nia 'uri nai, tara na mae lana toaa 'o'olo saungi lada nai sui guu lao molaagali kai tio faafi kamolu. Nia safali 'ua gu mai 'ana mae lana sa 'Ebol, lelea mai ka dao 'ana mae lana sa Sakaraea 'alakwa sa Barakaea, bae kamolu saungia ka mae 'i matangana Beukaua loo fai na fuliera abu loo ni afuafu lae. ");
INSERT INTO bvd_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nau ku faarongo mamana 'ani kamolu, God nia kai duua mae lana toaa nai sui guu fuamolu toaa ne abulo lamolu 'uri nai nee.” ");
INSERT INTO bvd_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Sa Disas 'e lio kau uri fera baita nai 'i Durusalem, nia ka bae 'urii, “'Oo toaa nee 'i Durusalem 'ae! Kamolu molu 'uifauna brofet baki God nia fale kera mai siamolu ma daka mae naa. 'Ana kada 'oro, nau ku dooria 'asia naa uri ku koni kamolu mai siaku uri ku kokofi kamolu mala 'ana ta karai keni ne kokofia kalena ki fara kukubana. Ma sui ka nao molu si dooria guu. ");
INSERT INTO bvd_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ma 'i tari'ina, God nia lea na faasia Beukaua kamolu nee. ");
INSERT INTO bvd_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nau ku faarongo 'isi 'ani kamolu, tara nao molu si suaku lau lelea ka dao 'ana si kada ne molu kai suungi ma molu ka bae 'urii suli nau, ‘'E diana tasa fua sa wala nee God fale nia mai nee!’” ");
INSERT INTO bvd_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Si kada sa Disas bae 'uri nai lelea ka sui naa, nia ka lea na kau fasi beukaua bae, na toa kwairooi nia ki kera tae mai daka bae 'urii fuana, “'O suana fasi 'amua na saungia neki 'ana beukaua nee wala! Sua lada diana 'asia naa!” ");
INSERT INTO bvd_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Sa Disas ka bae 'urii fuada, “Iuka. Kamolu suana saungaia neki sui gu nee? Bobongi Beukaua nee kai atoli tiifau lelea nao tasi aba fau boroi si tio guu fafo ruana si doo.” ");
INSERT INTO bvd_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Si kada sa Disas 'e gooru 'ana gwauna fa uo 'i 'Olif, na toa kwairooi nia ki da lea mai daka too kwaimani 'ada fai nia taifili kera. Ma kera daka ledia sa Disas daka 'urii, “'I anita ne doo nai ki 'oe saea fuameli nai ka fuli? Ma tee ki gu ne dai fuli uri ka faatainia si kada 'oe oli mai, fai nia si kada na fera ne 'i saegano kai sui naa?” ");
INSERT INTO bvd_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Sa Disas 'e luu kera ka 'urii, “Molu ka fiia, ade lea ta waa ka suke kamolu. ");
INSERT INTO bvd_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Suli waa 'oro dai dao mai 'ana sataku uri suke lamolu lae ma kera dai bae 'urii, ‘Nau na Kraes bae gu ne!’ Ma si kada kera da ili 'uri nai, na toaa 'oro ne kera da kai faamamanea suke laa kera nai. ");
INSERT INTO bvd_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ma ta doo lau guu, kamolu molu kai rongoa tabusu lana firue ki karangi kamolu, ma na ununua suli firue ki 'ana bali fera tau ki dai liu. Nia ka 'uri nai boroi 'ana, kamolu nao molu si mau lau 'ana doo nai ki. Doo da kai fuli ki naa nai, 'afitai ka nao lau. Ma sui boroi 'ana, na 'isi lana fera ne 'i saegano nia nao 'ua nai. ");
INSERT INTO bvd_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Totoo na fere ki kera da kai alasi kera kwailiu. Ma na uni fioloe ki da kai liu, ma na anuanu ki da kai 'igia 'ana bali fera 'e'ete ki sui. ");
INSERT INTO bvd_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Na doo nai ki na safali lana 'ua gwana 'afitaia ki nai, mala 'ana fiiwela lae si kada safali lana 'ua gwana kau ma baita lana ka nii 'ua mai. ");
INSERT INTO bvd_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Tasi doo ne kai fuli lau guu mai ne toaa 'ana maefera 'e'ete ki sui gwana lao fera ne 'i saegano dai susubutai kamolu, faafia ne kamolu toaa nau. Ma kera dai dau kamolu, ma dai fale kamolu 'i 'abana malimae kamolu ki uri kwae lamolu ma saumaeli lamolu naa. ");
INSERT INTO bvd_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ma toaa 'oro ne kera manata mamana 'ani nau, kera dai kakasa 'ana manata mamana laa kera. Ma toae ki kera dai malimae 'ani kera kwailiu. Ma kera dai falea toaa God ki 'i 'abana malimae ki. ");
INSERT INTO bvd_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ma 'ana si kada nai, na brofet 'oro ni suke lae dai dao mai, ma kera da kai sukea toaa 'oro ma daka talai 'e'ete na 'ani kera 'ana lea lae sulia toolangaidoo laa garo ki. ");
INSERT INTO bvd_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ma kera dai ilia doo garo 'oro tasa. Ma nunufana doo nai ki, na liosaua kera toaa 'oro nia kai gwagwari lau gwana. ");
INSERT INTO bvd_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ma sui boroi 'ana ka 'uri nai, lea sa tii ne nia ngado 'ana tooa nia fua God lelea ka dao 'isi lana doo nai ki, God kai faamauri nia. ");
INSERT INTO bvd_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ma si faarongoa diana nee suli 'initoaa God, kera dai faarongo talo ai lao fera ne 'i saegano sui gwana fua toae ki sui. Burina fatai si doo nai 'e fuli, nia kafi dao 'ana 'isi lana fera ne 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ma ni kamolu molu kai suana doo sua bae tara kera da kai faa uua lao lalo abu loo. Ma na doo nai ka faasuaa beu abu nia God, ma God ka lukasia naa beu nia. Doo nai brofet Daniel nia bae mai sulia 'ana kada 'i nao.” (Si baea fua tii ne nia teemai, nia 'urii: 'Oko saitoma diana 'ana malutana doo nai.) ");
INSERT INTO bvd_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Lelea molu suai naa doo nai 'e fuli, tii ne 'oe too lao bali lolofaa 'i Diudia 'oko tafi 'ali'ali naa uri agwa lae suli uo loki. ");
INSERT INTO bvd_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ma tii ne nii kau 'i maa 'ana luma nia, nia 'ali'ali ka tafi naa. Ma nao nia oli si ruu lau kau 'i luma, uri dora lae lau 'ana sasi lae fai ngali lana tasi doo ne nii mai luma. ");
INSERT INTO bvd_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma tii ne nia nii 'ua mai lao ola nia, nao nia si oli lau mai luma uri maku nia ki ade ka faadora nia. ");
INSERT INTO bvd_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Doo ki dai ta'aa ka tasa 'ana si kada nai fua keni faasusu ki ma ai da kulua ki, suli kera dao toi kai 'afitai tasa uri tafi 'ali'ali lae. ");
INSERT INTO bvd_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Molu foa uri ka nao molu si tafi lau 'ana si kada uni gwagwarie ma nao 'afa sato Sabat. ");
INSERT INTO bvd_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Suli na ta'aa laa nai kai talua ta'aa laa ki sui ne toaa lao fera ne 'i saegano da saitomana ki mai, 'ita kada God saungainia doo ki sui ma ka lea mai ka dao 'i tari'ina. Ma ka nao tasi ta'aa laa lau 'i buri ne kai 'uria lau si doo nai. ");
INSERT INTO bvd_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ma lea God nao si faa kurusia si kada nai 'ana ta'aa laa nai, nia kai 'afitai tasa uri ta waa kai mauri ai. Ma sui uri ka diana fua toaa ne God fili kera ki sui naa, nia kai faa kurusia gwana si kada nai. ");
INSERT INTO bvd_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Tasi doo lau guu 'ana si kada nai ki nii 'ua mai, lea ta waa bae 'urii fuamolu, ‘Lea molu suana 'amolua na Kraes bae gu ne nii agwa gwana 'i luma nee,’ ma nao ka bae 'urii, ‘Nia 'e nii gwana lao fera kwasi loko,’ kamolu nao molu si faamamanea. ");
INSERT INTO bvd_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Suli na Kraes susuke ma na brofet susuke ki kera da kai dao mai ma da kai ilia fafaataia talingai ki ma doo kwaibalatana ki. Ma kera dai bae 'urii, ‘Nau na Kraes bae naa ne,’ ma nao daka bae 'urii, ‘Nau ta brofet lau gu ne.’ 'Uri nai guu kera daka sasi naa uri talai garo lae 'ana toaa ne God fili kera ki sui naa, ma sui boroi ka 'afitai naa fuada. ");
INSERT INTO bvd_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kamolu rongo nai, doo nai ki nao dasi fuli 'ua mai ma sui boroi 'ana nau ku faarongo kamolu na kau 'ana taue, uri molu ka saitoma diana ai. ");
INSERT INTO bvd_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","27","“Si kada ni nau na 'Alakwa Nia Wane, kwai dao mai, toae ki sui guu kera dai suaku. Nia kai mala si kada kamolu suana kwakwange binabina 'i lofona salo loo ma ka folaa tiifau 'ita bali tae lana sato lea ka dao bali suu lana sato. Aia, lea tai waa kera da bae 'urii fuamolu, ‘Na Kraes bae 'e nii gwana lao fera kwasi loko,’ too 'amolu fasi lea lae 'i seeri. Ma lea tai waa daka bae 'urii fuamolu, ‘Na Kraes bae ne agwa gwana 'i seki nee,’ nao molu si faamamanea tasi baea 'uri nai ki. ");
INSERT INTO bvd_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Na oli laku mai 'afitai ka agwa fasi ta waa. Nia kai mala bae lea si kula na doo mae 'e nii ai, na 'asungaa ki daka koni faafia 'i seeri, 'afitai ka agwa. ");
INSERT INTO bvd_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“'I burina fatai kada ne nonifiia nai ki da sui, ‘God kai suusia sato fai nia madame, uri nao keeru si tala folaa lau. Ma God kai ilia bubulu ki kera kai 'asida faasia mamangaa. Ma God kai ilia na doo loki langi 'i mamangaa, kera kai lea garo fasi fulida.’ ");
INSERT INTO bvd_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“'Ana si kada nai guu, si mamalafooa nau Wela nia Wane, ka sakatafa faatai naa 'i lofona salo. Ma 'ana si kada nai lau guu, na toae ki tiifau lao fera ne 'i saegano kera dai angi, sulia da suaku nau ku dao mai fafona dasa loo 'i mamangaa, maku dao mai lao rigita lae fai nia kwanga laa baita. ");
INSERT INTO bvd_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ma na 'ensel ki kera kai ufia bungu kai angi baita uri koni lana toaa nau ki ne ku filida sui naa. 'Ana kada nai, nau kwai odua mai 'ensel nau ki, uri kera kai konia mai toaa nau ki tiifau faasia na fera neki tiifau lao fera ne 'i saegano.” ");
INSERT INTO bvd_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","'I seeri guu, sa Disas ka bae na sulia tii tarifulaa ka 'urii, “Molu manata fasi sulia na 'ai fig ki, kada lea molu suana sarana nia fufurua, tama si kada nia uni sato 'e karangi dao naa nai. ");
INSERT INTO bvd_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Talafana lau guu, kada kamolu suana nonifiia nai ki dao na mai, tama kamolu saitomana oli laku mai nia karangi naa nai. ");
INSERT INTO bvd_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ku faarongo 'isi 'ani kamolu, na unita wane nee 'i tari'ina kera dai mauri 'ua gwada doo nai ki ka fuli. ");
INSERT INTO bvd_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Na doo loki tiifau lao salo loo fai nia lao fera ne 'i saegano kera dai sui gwada. Sui ma bae laku nia 'afitai ka sui. ");
INSERT INTO bvd_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nao ta waa si saitomana fa sato ma nao si kada sato nau kwai dao ai. Na 'ensel ki ka nao dasi saitomana, ma ni nau, na 'Alakwa Nia Wane boroi, nao kwasi saitomana lau guu si kada nai. God na Maa taifili nia gu ne nia saitomana. ");
INSERT INTO bvd_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Si kada nau kwai oli mai nia kai mala lau guu si doo bae fuli lao fa sato bae sa Noa. ");
INSERT INTO bvd_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Si kada bae sui guu igwa baita bae ka dao naa, na toae ki kera fanga ni elea ma daka kuu gwaulilinge 'ada. Kera daka falekeni ma daka folikeni ki 'ada lelea ka dao guu 'afa sato bae sa Noa nia raa lao baru baita nia bae. ");
INSERT INTO bvd_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ma kera daka ulafusia gwada saea sa tasi doo kai fuli, ma daka ade 'uri nai lelea ka dao gu 'ana kada ne igwa baita bae dao ka lau kera naa. Talafana lau guu si doo kai fuli kada nau kwai oli mai nai. ");
INSERT INTO bvd_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","'Ana kada nai, lelea ta roo waa daru ka rao kwaimani boroi 'i lao tii ola, ta waa nau kwai ngalia, ta ruana waa kwai faasia ka too gwana. ");
INSERT INTO bvd_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ma lelea ta roo wela keni daru ka rao fanga kwaimani boroi 'ana tii si kula, ta wela keni nau kwai ngalia, ta ruana ai nau kwai faasia ka too gwana. ");
INSERT INTO bvd_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Too molu ka kwaimaakwalii ma molu ka lilio diana, sulia kamolu ulafusia fa sato tee ne nau, na 'Alakwa nia wane, nau kwai dao ai. ");
INSERT INTO bvd_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Molu ka manata toi si doo 'urii, lelea na wane 'ana lume 'e saitomana gwana si kada ne waa bebeli kai dao uri beli lae, nia kai lilio diana ma 'afitai ka ekwatainia waa nai ka belia 'okodoo nia 'i luma. ");
INSERT INTO bvd_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Doo ne adea guu, kamolu lau guu molu kwaimaakwali diana, sulia ni nau, 'Alakwa nia wane kwai dao mai 'ana si kada ne nao molu si fiia kwai dao ai.” ");
INSERT INTO bvd_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Kamolu nee, molu mala 'ana waa ni rao ne liotoo ma ka rao noni maabe. Na waa ni rao ne liotoo ma ka rao noni maabe, na waa baita nia kai alu nia uri lio lae suli toaa ni rao ki lao luma nia, uri ka sangoni kera 'ana si kada kera ni fanga lae ki. ");
INSERT INTO bvd_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Aia, ma lelea na waa baita nai 'e dao mai ma ka suana nia ka ilia naa doo nai ki, nia ka diana 'asia naa fuana. ");
INSERT INTO bvd_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nau ku faarongo mamana 'ani kamolu, na waa baita nai tara nia kai alu sa wala nai ka lio sulia doo nia ki tiifau. ");
INSERT INTO bvd_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Sui ma, lea sa nia ta waa ni rao ta'aa gwana, nia ka manata gwana 'urii, ‘Na waa baita nau, dao lana mai 'e tau 'ua.’ ");
INSERT INTO bvd_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","'I seeri nia ka safali kwae maana gwana toa ni rao nai ki ma ka lea ka kuu 'ana fai toa da kuu lilinge ki. ");
INSERT INTO bvd_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ma na waa baita nia nai ka dao naa 'afa dani sa wala nai 'e nao si fiia lau gwana ma ka nao si kwaimaakwali guu maasia. ");
INSERT INTO bvd_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Na waa baita nia nai kai falea kwakwaea ta'aa ka tasa fua sa wala nai, ma kai odu nia naa uri lea ka too fai nia toa kwaisukei ki ma kera dai too na 'ada 'ana angia ma didi didilifoe.” ");
INSERT INTO bvd_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Sa Disas ka bae lau 'urii, “'Ana si kada nai nau kwai dao mai, na 'initoaa God kai mala 'ana taafuli keni saarii da ngalia laet kera ki daka lea lao rodo maasia fungao falu, uri fanga kwaimani lae fai nia 'ana lumaa nia. ");
INSERT INTO bvd_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ta lima saarii daka liotoo, ma ta lima ai ka nao dasi liotoo. ");
INSERT INTO bvd_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Na saari nai ki nao dasi liotoo nai, kera da ngali naa laet kera ki, ma sui ta nao dasi ngali guu tasi gwai fai kera uri ongi lana lau laet ki si kada kera gwau. ");
INSERT INTO bvd_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ma saari liotoo nai ki 'ana ne kera da ngali gwai lao kwade doe ki uri ongi lana laet ki. ");
INSERT INTO bvd_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ma na fungao nai ka nao si dao 'ali'ali guu, ma na saari nai ki daka totoo maada ka mamaleua tiifau, kera daka maleu naa. ");
INSERT INTO bvd_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ma totoo lao tofungana rodo naa, waa ki daka 'aitainia naa dao lana fungao nai ma dafi bae 'urii, ‘Na fungao bae ne karangi dao naa nee! Molu lea na mai uri molu ka toda 'ani nia!’ ");
INSERT INTO bvd_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Na taafuli keni nai tiifau kera daka ada mai ma daka sulatatae naa uri rarau lana laet kera ki. ");
INSERT INTO bvd_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","'I seeri, na ai nai ki nao dasi liotoo nai daka bae na kau 'uri fua ai liotoo nai ki, ‘Rowane 'ae, kameli mone ta laet kameli baki da gwau naa. Molu faa fasi mai tasi gwai fuameli, uri meli ka ongia lao laet kameli ki.’ ");
INSERT INTO bvd_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Na ai liotoo nai ki da luuda daka 'urii, ‘'Ee nao, si gwai ne meli too ki ai nee 'e nao si tala 'akolu sui ne. Molu lea kau sia toaa da faafoli 'ana gwai ki, molu ka usi gwai na kau 'amolu.’ ");
INSERT INTO bvd_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ma si kada nai kera da lea gu uri foli gwai lae, na fungao nai ka dao naa. Ma na saari nai ki kera da ade akau nai, kera daka lea na fai nia 'ana fanga kwaimania nai 'ana lumaa nai. Sui na maa nai 'ana luma nai ka fonoki naa suusi kera. ");
INSERT INTO bvd_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“'Uri nai sui, na saari baki kera dora kau bae daka lea kau lelea daka dao lau guu. Ma daka 'urii, ‘Waa baite kani 'ae! 'O 'ifingia kau mae uri kameli ka ruu lau gu kau!’ ");
INSERT INTO bvd_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Sui ma fungao nai ka luuda ka bae na kau 'urii fuada, ‘Ku faarongo mamana 'ani kamolu, nau ku ulafusi kamolu.’” ");
INSERT INTO bvd_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Sa Disas ka bae 'urii, “Ade lana guu ne kamolu molu ka lilio diana ma molu ka fofolo diana nai, suli kamolu ulafusia fa sato nai ma nao si kada sato nai nau kwai dao ai.” ");
INSERT INTO bvd_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Sui sa Disas ka bae lau 'urii fua toa kwairooi nia ki, “Na 'initoaa God nia kai mala lau guu tii waa nai kai lea 'ana kai tau nai, ma ka 'ailia mai toa ni rao nia ki siana, ma ka alua si malefo nia ki 'abada uri daka ili raoa ai fuana. ");
INSERT INTO bvd_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ma nia ka falea lima tooni malefo ki fua ta tii waa. Ma ta waa, nia ka falea roo tooni malefo ki fuana. Ma ta waa lau, nia ka falea tii tooni malefo ki fuana. Fale laa nai ki nia fale, da lea lau gu suli si bobola laa ne nia suana waa nai ki da bobola fai nia daka rao 'ana si malefo nai ki ai. Nia ade 'uri nai sui, nia ka lea naa 'ana lea laa nia nai. ");
INSERT INTO bvd_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","'I seeri, na waa ne ngalia lima tooni malefo nai ki, nia ka rao naa 'ana malefo nai. Ma nia ka todaa lau mai ta lima tooni malefo faafia. ");
INSERT INTO bvd_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ma na waa nai 'e ngalia roo tooni malefo nai ki, nia ka rao lau guu. Ma nia ka todaa lau gu mai ta roo tooni malefo faafia si malefo nai da faa fuana ka rao ai. ");
INSERT INTO bvd_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Sui ma waa nai 'e ngali tii tooni malefo nai gu ne, nia lea kau ma ka 'eli faafia malefo nai lao kilu lao saegano, ma ka saufinia si malefo na waa baita nia ka tio gwana 'uri nai. ");
INSERT INTO bvd_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ma burina naa si kada 'e tau, na waa baita kera nai ka oli mai ka dao naa. Ma nia ka dooria naa sua lana malefo nia nai ki toa nai ki kera da rao mai ai. ");
INSERT INTO bvd_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","'I seeri, na waa nai 'e ngalia lima tooni malefo nai ki, ka dao na mai fai nia ta lima tooni malefo lau faafia, ma ka bae 'urii, ‘Arai baite 'ae, 'oe 'o falea lima tooni malefo ki fuaku. 'O suai fasi nee, nau ku todaa lau mai ta lima tooni malefo faafia.’ ");
INSERT INTO bvd_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ma na waa baita nai 'e luua ka 'urii, ‘Waa ni rao mamana diana nau. 'Oe 'o ilia si raoa nai ka diana 'asia naa. Nau ku alu 'oe naa uri 'oko lio lau suli doo 'oro ki, suli 'oe ili diana mai 'ana si raoa nao si 'oro ki boroi 'ana. Lea mai 'oko ele kwaimani 'amua fai nau.’ ");
INSERT INTO bvd_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ma na waa nai 'e ngalia roo tooni malefo nai ki ka dao lau gu mai. Ma nia ka bae 'urii, ‘Arai baite 'ae, 'oe 'o falea roo tooni malefo ki fuaku. 'O suai fasi nee, nau ku todaa lau mai ta roo tooni malefo faafia.’ ");
INSERT INTO bvd_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ma na waa baita nai 'e luua ka 'urii, ‘Waa ni rao mamana diana nau. 'Oe 'o ilia si raoa nai ka diana 'asia naa. Nau ku alu 'oe naa uri 'oko lio lau suli doo 'oro ki, suli 'oe ili diana mai 'ana si raoa nao si 'oro ki boroi 'ana. Lea mai 'oko ele kwaimani 'amua fai nau.’ ");
INSERT INTO bvd_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Sui, na waa nai 'e ngalia tii tooni malefo nai, ka dao na mai. Nia ka fofo naa ma ka bae na 'urii, ‘Waa baite 'ae, nau ku saitomana 'ua gu ne 'oe na waa susuala nao 'osi obi ata waa. Ta doo nao 'osi fasia boroi 'oe saitomana 'oko falia gwamu, ma ta fanga ne nao 'osi tala alu boroi, 'oe saitomana 'oko konia gwamu. ");
INSERT INTO bvd_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nia ne adea nau ku mau lau gwaku, ma ku lea kau ku saufinia gwaku malefo 'oe lao saegano. 'Oe suai nee, malefo 'oe bae ne tio gwana doo 'oe.’ ");
INSERT INTO bvd_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ma na waa baita nia nai 'e luua ka 'urii, ‘'Oe na waa rao lamu siofaa 'urii. 'Oe saea 'o saitomana sui naa ni nau waa ku falia ki gwaku fanga nao kusi fasia, ma ku koni doo gwaku lao rakui fanga 'ana alu doo lana ta waa 'e'ete lau gwana nai, nee? ");
INSERT INTO bvd_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Lea 'oe manata 'uri nai, tee ne adea nao 'osi alua 'amu mai seleni nau nai lao banga, uri si kada ku dao naa, nau ku oli fai malefo nau fai nia tai malefo lau kera todaa mai faafia?’ ");
INSERT INTO bvd_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Sui waa baita nai ka bae na kau 'urii fuana waa ni rao nia ki, ‘Molu ngali malefo loko fasi sa wala loko, molu ka faa 'amolu fua sa wala nee too 'ana taafuli tooni malefo neki. ");
INSERT INTO bvd_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Suli na toaa nee sui guu kera da todaa mai si doe, nau kwai fale 'ada kai 'oro lau, ma kera dai too lau 'ana doo 'oro ki. Ma tii gwana ne nia nao si todaa gu mai tasi doo, tasi doo ne nia ka too boroi ai, nau kwai lafua gwaku faasi nia. ");
INSERT INTO bvd_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma na waa ni rao ta'aa loko, kamolu ngali nia molu ka 'ui 'ani nia 'i maa lao rorodoa laa loko, si kula fua angie ma didi lifo lae lelea firi.’” ");
INSERT INTO bvd_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Sa Disas ka bae lau 'urii fuana toa kwairooi nia ki, “Si kada ni nau, na 'Alakwa Nia Wane, kwai dao fai nia 'initoaa nau ma 'aini 'ensel ki daka dao kwaimani mai fai nau, nau kwai gooru lao fuligoorua ni taloa nau. ");
INSERT INTO bvd_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ma toaa 'ana fere ki sui guu kera dai koni mai siaku. Ma nau kwai efaa bali toae ki dai too 'e'ete ki lau gwada, mala 'ana ta waa ni sua lae suli sifsif ki kada nia efaa sifsif ki daka too 'e'ete 'ada faasia nanigot ki. ");
INSERT INTO bvd_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ma nau kwai efaa bali 'ana toaa nai ma kera dai too 'e'ete lau gwada taifili kera 'i bali aolo 'ani nau mala 'ana sifsif nai ki kera efaa daka too 'e'ete ki. Ma ta bali 'ani kera daka mala 'ana nanigot nai ki, kera dai too 'e'ete lau gwada 'i bali mauli 'ani nau. ");
INSERT INTO bvd_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Si kada nau na Waa 'inito ku ili 'uri nai sui, nau kwai bae 'urii fua toaa nai 'i bali aolo 'ani nau, ‘Kamolu molu lea mai, suli ni kamolu toaa nee na Maa nau 'e ele suli kamolu. Molu ruu 'amolua mai lao 'Initoa nia, ne nia ade akau mai ai fuamolu 'ita 'ua kada nia saungainia fera ne 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Suli si kada bae ku fiolo mae, kamolu bae molu sangoni nau. Ma si kada bae ku maeli kuu, kamolu bae molu faa si kafo fuaku. Ma sui boroi 'ana nau na waa 'e'ete lau gwana bae ku dao mai siamolu, kamolu bae molu gwale nau molu saare nau 'i luma kamolu ki. ");
INSERT INTO bvd_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ma si kada bae ku siofaa uri si maku ni ofi, kamolu bae molu faaofi nau. Ma si kada bae ku matai, kamolu bae molu suasuli nau. Ma si kada bae ku too lao lookafo, kamolu bae lea mai molu ka maa toku.’ ");
INSERT INTO bvd_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Sui na toaa 'o'olo nai kera da luua daka 'urii, ‘Nee wala Aofia, ma anita nai kameli suamu 'oe fiolo mae ai ma meli ka sangoni 'oe nai? 'I anita nai 'oe maeli kuu ai, ma meli ka faa si kafo fuamu nai? ");
INSERT INTO bvd_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ma 'i anita nai 'oe na waa 'e'ete lau gwana 'o dao siameli ai, ma meli ka gwale 'oe meli ka saare 'oe 'i luma kameli ki, ma nao si kada tee nai 'oe siofaa uri si maku ai, ma meli ka faaofi 'oe nai? ");
INSERT INTO bvd_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ma si kada tee nai kameli suamu 'o matai ai, ma nao 'oko too lao lookafo ai, ma meli ka lea kau meli ka maa tomu nai?’ ");
INSERT INTO bvd_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ma nau kwai luu kera kwai 'urii, ‘Ku faarongo mamana 'ani kamolu, si kada kamolu ilia mai tasi doo 'uri nai fua ta waa mala nia boroi 'ana 'ana toa kwairooi nau ki, kamolu ilia na mai fuaku nai.’ ");
INSERT INTO bvd_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Sui nau kwai bae 'urii fuada na wane ne kera too 'i bali mauli aku, ‘Kamolu lea tau 'amolu kau faasi nau. God kai kwae kamolu. Ma kamolu kai lea lao na ere ne totoo firi, ne God nia ade akau ai fuana sa Saetan ma na 'ensel ta'aa nia ki. ");
INSERT INTO bvd_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sulia nau ku fiolo, ma kamolu si falea guu ta fanga fuaku. Ma kada nau ku maeli kuu, nao kamolu kasi falea guu ta kafo fuaku. ");
INSERT INTO bvd_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ma kada nau ku dao mai, kamolu kasi goni nau guu fuana luma kamolu ki. Ma kada ka nao 'akua tasi maku, nao kamolu si faaofi nau guu. Ma kada nau ku matai ma ku too 'i lao lookafo, nao kamolu si lio guu suli nau.’ ");
INSERT INTO bvd_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ma kera da luua daka 'urii, ‘Wala Aofia 'ae, kada tee ne kameli suamu 'oe fiolo mae ai, ma nao 'oko maeli kuu, ma nao ni 'oe na waa 'e'ete lau gwana 'o dao siameli, ma nao 'oko siofaa uri si maku ni ofi, ma nao 'oko matai, ma nao 'oko too lao lookafo, ma kameli ka nao meli si 'adomi 'oe guu?’ ");
INSERT INTO bvd_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ma nau kwai luu kera ma kwai bae 'urii, ‘Ku faarongo mamana 'ani kamolu. Tasi tee ne kamolu nao molu si ilia mai uri ka 'adomia ta waa malania 'ana toaa kwairooi nau ki, nia talafana naa kamolu nao si ilia fuaku.’ ");
INSERT INTO bvd_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“'Uri nai sui kera daka lea naa uri lao kwakwaea totoo firi, ma na toaa 'o'olo ki kera daka lea naa uri lao mauria firi.” ");
INSERT INTO bvd_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Si kada sa Disas nia toolangaidoo lelea ka sui naa, nia ka bae 'urii fuana toa kwairooi nia ki, ");
INSERT INTO bvd_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kamolu saitomana, na Fangatasae kai liu naa 'i faafone bae. Ma otofana si kada nai gu ne kera dai fale nau, na 'Alakwa Nia Wane, fua malimae nau ki, uri daka foto faafi nau naa 'ana 'airarafolo.” ");
INSERT INTO bvd_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ma 'ana si kada nai lau guu, na waa baita ni foa ki fai nia toa gwaungai Diu ki kera da ofu naa 'i beu nia sa Kaeafas na waa foa ni gwau. ");
INSERT INTO bvd_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ma kera dai 'olea naa si kada kera dai dau agwa 'ana sa Disas ai uri daka saungi nia naa. ");
INSERT INTO bvd_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ma kera daka alu tii manataa naa ma daka bae 'urii, “Nao kolu si dau nia lau lao fa dani neki 'ana fafangaa nee, ade lea konia nee daka firu lau gwada fai kolu.” ");
INSERT INTO bvd_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Si kada sa Disas fai nia toa kwairooi nia ki kera dao 'i Betanii ma daka too 'ada luma sa Saemon na waa nai furo saungi nia mai 'i nao, ");
INSERT INTO bvd_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","tii wela keni nai 'e lea mai ka dao siana. Ma na wela keni nai ka ngali mai tii bii gwai liu lana baita tasa nai lao kufidoo nai da 'ailia 'ana 'Alabasta. Ma wela keni nai ka 'iki 'ana gwai nai lao gwau sa Disas kada sa Disas kai fanga 'ua gwana. ");
INSERT INTO bvd_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ma si kada na toa kwairooi nia ki da suai, na rakeda ka sasu daka ledi 'ada 'urii, “Na wela keni nee 'e saketoa gwana gwai diana nee uri tee nee? ");
INSERT INTO bvd_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Na gwai nee lea sa daka faafoli ai, malefo baite ne dai ngali uri maana, uri daka faa malefo nai ka 'adomia toaa siofaa ki!” ");
INSERT INTO bvd_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Sa Disas 'e filoa gwana si doo nai kera bae sulia, ma nia ka bae 'urii fuada, “Tee ne adea molu ka bae 'uri nai suli wela keni ne, ma molu ka faa noni susuala nia nai? Si doo diana tasa ne nia ilia fuaku nee. ");
INSERT INTO bvd_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Na toaa siofaa neki kera da too gwada fai kamolu suli kudu. Aia, ma ni nau ne kwai too fai kamolu si tau naa. ");
INSERT INTO bvd_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Si kada nai wela keni nee nia 'ikia gwai nai faafi nau, nia ade akau na kau 'ani nau maasia fa dani nau ku mae ma kera daka alu nau naa lao kilu gwau nai. ");
INSERT INTO bvd_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nau ku faarongo mamana 'ani kamolu, 'i fai gwana lao fera ne 'i saegano ne kera dai faataloa si Faarongoa Diana nee ai, si doo ne wela keni nee ilia nai kera dai unu lau gu sulia ai, uri daka manata tona wela keni nee.” ");
INSERT INTO bvd_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Buri si doo nai, tii waa 'ana akwala ma roo waa kwairooi baki sa Disas ne satana sa Diudas 'Iskariot, ka lea naa siana waa baita ni foa ki. ");
INSERT INTO bvd_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ma sa Diudas ka ledi 'urii 'ani kera, “Lea sa nau ku faafoli 'ana sa Disas fuamolu nai, ta fita doo ne molu kai faa fuaku?” Ma kera daka idumia mai olu taafuli fa seleni, ngali mai daka faa na fuana. ");
INSERT INTO bvd_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Safali gu 'i seeri, sa Diudas ka lilio naa uri si kada tee ne bobola fai nia uri lea nia 'olea ma nia ka alu mamana naa 'ana sa Disas 'i 'abada. ");
INSERT INTO bvd_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Aia, 'afa dani totoonao guu 'ana fafangaa loko da 'ailia 'ana Fafangaa 'ana Beret nao Isi ai, na toa kwairooi sa Disas ki da lea mai siana, daka ledi 'urii 'ani nia, “'I fai ne 'oe dooria meli kai ade akau 'ana fange ki ai uri 'oko fanga 'ana Fangatasae nee?” ");
INSERT INTO bvd_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ma sa Disas ka bae 'urii fuada, “Molu lea kau siana tii waa nai nii lao fera baita loo molu ka bae 'urii fuana, ‘Waa toolangaidoo kameli 'e bae 'urii, Si kada nau 'e dao karangi naa nai. Toa kwairooi nau ki fai nau meli kai fanga kwaimani 'ameli 'ana Fangatasae nee 'i luma kamu.’” ");
INSERT INTO bvd_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","'I seeri, na toa kwairooi ki kera daka lea naa, ma daka bae na 'uri bae sa Disas nia saea kau fuada. Kera daka ade akau naa 'ana fanga kera ki uri ka maasia naa Fangatasae nai. ");
INSERT INTO bvd_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Dao 'i saulafi, sa Disas ka too naa 'i seeri 'ana fanga kwaimania nai fai nia akwala ma roo waa kwairooi nia ki. ");
INSERT INTO bvd_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ma si kada kera fanga naa, sa Disas ka bae 'urii fuada, “Ku faarongo mamana 'ani kamolu, tii waa 'ani kamolu nia kai fale nau naa 'i 'abana malimae ki.” ");
INSERT INTO bvd_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Si kada na toa kwairooi ki da rongo si baea nai, kera daka liodila tasa. Ma kera tiifau daka safali ledia naa sa Disas. Ta waa 'e ledi nia sui ta waa lau guu, ma daka 'urii naa, “Nee wala Aofia, ma tii gu nai? Nau mone 'e nao!” Ma kera sui guu daka bae 'uri nai fuana. ");
INSERT INTO bvd_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Sui sa Disas ka 'urii, “Ta waa 'ani kamolu ne kai kurumainia si beret nia lao titiu nee fai nau, nia gwana ne waa nai kai fale nau fua malimae ki nai. ");
INSERT INTO bvd_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nau, na 'Alakwa Nia Wane, nau kwai mae guu mala doo bae na kekeda laa Abu 'e saea sui na mai 'i nao. Ma sui ta, nia kai ta'aa ka tasa fua waa ne kai fale nau 'i 'abana malimae ki. Nia diana lea sae waa nai ka nao si futa 'ua guu, suli na kwakwaea ne kai dao tona 'e ta'aa ka tasa.” ");
INSERT INTO bvd_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","'Ana si kada nai guu, sa Diudas waa nai gu kai falea sa Disas fua malimae ki, nia ka bae na 'urii, “Waa toolangaidoo 'ae, ma ade sae nau gwana nai?” Ma sa Disas ka bae 'urii fuana, “'Oe 'ana tala'amu nai 'o tala saea nai.” ");
INSERT INTO bvd_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Si kada kera dau fanga 'ada 'uri nai, sa Disas 'e rao uri beret nai 'e dau ai ka tangoa God, sui ka niia ka falea fua toa kwairooi nia ki, sui ka bae 'urii, “Molu ngali molu ka 'ani, na noniku naa ne.” ");
INSERT INTO bvd_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Sui nia 'e ngali na titiu waen nai ka dau ai ka tangoa God, sui ka falea fuada ka bae 'urii, “Kamolu tiifau, molu kuufia. ");
INSERT INTO bvd_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Na 'abuku naa ne 'ana alangaia falu nee, si 'abu ne kai igwa uri God ka manata lukea abulo ta'aa laa kera toaa 'oro ki sui. ");
INSERT INTO bvd_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ku faarongo kamolu, nau tara kwasi kuufia lau waen nee lelea ka dao fatai 'afa dani nau ku kuufia na waen falu fai kamolu lao 'initoaa nia Maa nau.” ");
INSERT INTO bvd_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","'I seeri kera daka nguulia tii fa nguu lelea ka sui naa, kera daka lea na kau uri fa uo nai kera saea 'ana 'Olif. ");
INSERT INTO bvd_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sa Disas ka bae lau gu 'urii fuada, “Lao fa rodo ne 'i tari'ina, si doo ne kera dai ilia 'ani nau kai tagalangai kamolu molu kai tafi tiifau faasi nau. Suli bae lana God lao kekeda laa Abu 'e saea sui na mai ka 'urii, ‘Nau kwai kwaea waa ni folo kera sifsif ki, ma sifsif nia ki dai tagalo tiifau.’ ");
INSERT INTO bvd_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Sui boroi 'ana si doo nai kai fuli, 'i burina nau ku tatae fasi maea, nau kwai tasa lea kwai too maasi kamolu 'i Galilii.” ");
INSERT INTO bvd_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ma sa Bita 'e luua sa Disas ka bae 'urii, “Nau gu ne 'afitai ku tafi gu faasi 'oe, lelea sae toa nee daka tafi tiifau boroi faasi 'oe!” ");
INSERT INTO bvd_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ma sa Disas ka bae 'urii fua sa Bita, “Nau ku faarongo mamana 'ani 'oe, ni 'oe gu ne 'oki tofe nau saea nao 'osi saitomaku 'ana olu si kada fatai sui karai kafi 'ai 'i 'ofaidani lao fa rodo ne 'i tari'ina.” ");
INSERT INTO bvd_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ma sa Bita 'e luu nia ka 'urii, “Nau lelea sae ku mae boroi fai 'oe, 'afitai 'asia naa ku tofe 'oe guu!” Ma ni kera toa kwairooi ki daka bae sui gwada 'uri nai. ");
INSERT INTO bvd_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sui sa Disas ka lea fai nia toa kwairooi nia ki uri si kula nai da saea 'i Getsamani, ma nia ka bae 'urii fuada, “Molu gooru 'amolu 'i seki maasi nau, si kada nau ku lea kwai foa 'aku 'i lobaa.” ");
INSERT INTO bvd_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nia ka talaia sa Bita fai nia roo 'alakwa sa Sebedii ki daka lea fai nia. Ma nia ka safali liodila baita ma manata lana ka isifufuli 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ma nia ka bae 'urii fuada, “Nau ku liodila baita 'asia naa ma kwai maelia guu. Molu too 'amolu 'i seki, molu ka lilio diana lau gu fai nau.” ");
INSERT INTO bvd_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nia taa 'idu tu'uu gu kau faasi kera 'uri nai, nia ka booruru naa lelea maana ka too toi gu saegano. Nia ka foa 'urii, “Maa 'ae, lelea sae nia ka walude gwana, 'oko liliua kau 'amu fii laa nee faasi nau. Sui ta, suli doori lamu 'ana, nao lau suli doori laku.” ");
INSERT INTO bvd_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sui sa Disas 'e oli mai 'e dao sia olu waa kwairooi nia baki, ka suada kera maleu naa. Nia ka bae 'urii fua sa Bita, “Wala Bita, 'utaa ne nao molu si taa ada mone 'amolu fai nau suli ta tii si kada kukuru boroi 'ana? ");
INSERT INTO bvd_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Molu ada fasi molu ka lilio diana 'ana foa lae, uri ilitooe ka nao si siitasa faafi kamolu. Suli na manata lamolu 'e dooria gwana doo diane ki, ma sui ta nonimolu ne makeso 'asia naa.” ");
INSERT INTO bvd_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Sa Disas 'e faasi kera 'ana ruana si kada ka lea ka foa lau. Nia foa ka bae 'urii, “Maa 'ae, lelea sae nao si walude naa uri liliu lana fii laa nee faasi nau ma nau kwailiu na 'i laona, alamatainia ka fuli 'ana suli doori lamu.” ");
INSERT INTO bvd_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Si kada nia oli mai ka dao lau gu sia olu waa kwairooi nia baki, nia ka suada kera da maleu gwada suli maada mamaleua ka ta'aa 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","'Uri nai, sa Disas ka faasi kera ka lea ka foa lau gwana 'ana oluna si kada. Nia foa ka saea lau gu tii si doo bae. ");
INSERT INTO bvd_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sui nia ka oli lau gu mai sia toa kwairooi nia baki. Nia ka bae 'urii fuada, “Kamolu molu maleu molu ka momola 'ua gwamolu nee? Molu suai fasi nee, nia karangi dao gu asi kada bae nai, bae kera dai fale nau, 'Alakwa Nia Wane, 'i 'abana toaa abulo ta'aa ki. ");
INSERT INTO bvd_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Molu tatae kolu ka lea 'akolu. Waa bae uri fale laku fua malimae ki ne dao naa nee.” ");
INSERT INTO bvd_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Si kada sa Disas 'e bae 'ua gwana 'uri nai, sa Diudas nia waa bae gwana 'ana akwala roo waa kwairooi baki sa Disas, ka dao naa. Sa Diudas nia dao fai toa 'oro nai kera dau raunga sui gu mai uri firu lae. Na toaa nai, na waa baita ni foa ki fai nia toa gwaungai ki ne fale kera daka lea mai fai sa Diudas. ");
INSERT INTO bvd_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aia, sa Diudas nia faarongoa sui na mai toaa nai 'ana si mamalafooa ne kera dai lio uria 'ana waa ne da lea mai uri nia. Nia bae 'urii mai fuada, “Lea waa nai nau ku nonoia tama, nia waa nai kamolu dooria naa nai.” ");
INSERT INTO bvd_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","'Uri nai, sa Diudas 'ali'ali ka lea na kau sia sa Disas dao ka bae na 'urii fuana, “Aroaroe kau fuamu waa toolangaidoo!” Sui nia ka nonoia naa sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ma sa Disas ka bae 'urii fuana, “Wala, ili 'ali'ali naa 'ana doo ne 'oe lea mai uria.” 'Uri nai guu, toa nai kera fali mai daka ngiria naa sa Disas ma daka dau nia naa. ");
INSERT INTO bvd_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ma 'i seeri tii waa nai 'ana waa kwairooi sa Disas ki 'e aoa 'ila ni firu nia nai ka kwaea naa 'ana waa ni rao nia waa foa ni gwau. Ma ka kwae muusia naa bali alinga aolo nia sa wala nai. ");
INSERT INTO bvd_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ma sa Disas ka bae 'urii fuana, “Oli fai 'ila ni firu 'oe 'oko alu tio 'ana fulina, suli waa neki sui gu da firu 'ana 'ila ni firu, dai mae lau guu 'ana 'ila ni firu. ");
INSERT INTO bvd_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","'Oe manata toi 'amu sae nia 'afitai fuaku uri gani lana Maa nau, uri faa lana mai 'ensel ki ne dai 'oro ka talua na taafuli omee ma roo omee sarenga ki 'oto ne? ");
INSERT INTO bvd_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ma sui ta, lea sae nau ku 'ai uri 'ensel ki uri daka 'adomi nau 'uri nai, tara si baea bae lao Kekeda laa Abu suli na Kraes ne nia kai nonifii, tara ka fuli 'ana 'utaa?” ");
INSERT INTO bvd_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Si kada nai sa Disas ka bae na 'urii fuana konia nai, “Nee rowaa, kamolu kwaifii sae sa nau ta waa ku talai garo 'ana toae uri taga lae 'ana fere 'oto ne? Nia ne molu ka dao mai uri nau fai 'ile ni firu ma kile ki uri dau laku? Fa sato ki sui guu, nau ku gooru ku toolangaidoo gwaku mai fuamolu ka tau naa lao lalo 'ana Beukaua loko, ma sui ka nao molu si dau nau gu mai. ");
INSERT INTO bvd_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ma sui ta, doo neki sui guu da fuli na 'uri, uri si baea bae na Kekeda laa Abu ki fai nia na brofet kada 'i nao ki da saea mai ka fuli naa ne.” 'I seeri guu na toa kwairooi sa Disas ki da lukasi nia daka tafi tiifau na faasi nia. ");
INSERT INTO bvd_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Toa nai da daua kau sa Disas daka talai nia naa uri beu sa Kaeafas waa foa ni gwau. Ma na toa toolangaidoo ki 'ana taki fai tai toa gwaungai ki lau guu, kera da ofu kwaimani naa 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Sa Bita nia ka safa 'isi tau gwana kau 'i buri lelea kau ka dao lau guu lao lalo nai noni beu waa foa ni gwau. Nia ka too 'ana siana waa ni folo lae ki uri ka suai 'ana tee ne kera dai ilia 'ana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ma na waa baita ni foa ki, fai na ofuofua nai 'ana waa baite ki sui naa kera daka alu tii manataa sui naa. Ne kera daka nani naa uri tasi baea ni maeli lana uri daka suke ai faafia sa Disas ma daka saungi nia ka mae naa. ");
INSERT INTO bvd_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Toa 'oro ki daka lea mai daka suke, ma sui ka nao dasi dao toi guu tasi baea mala nai kera dooria. Totoo 'i buri naa, na roo waa suke nai ki daru ka bae 'urii, ");
INSERT INTO bvd_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Sa wala nee, na waa 'urii gwana nee ma sui si doo nia saea ka 'asia naa bae nia 'urii, ‘Nau tala'ana ku okosia beukaua God sui ku saungainia lau gwaku lao olu fa dani ki guu.’” ");
INSERT INTO bvd_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","'I seeri, na waa foa ni gwau 'e tatae uu ka bae na 'urii fua sa Disas, “Nee, 'oe nao 'osi saea gu tasi doo 'ana luu lana baea 'oro nai ki da saea suli 'oe nai?” ");
INSERT INTO bvd_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","'Uri nai boroi, sa Disas ka nao si bae guu. Na waa foa ni gwau nai ka bae lau 'urii fuana, “Nau ku saea fuamu, 'oe tofe fasi 'ana God mauri nee, ne si doo ne 'oe kai saea mai fuameli 'e mamana tiifau: Faarongo kameli fasi, na Kraes bae na 'Alakwa nia God, nia naa ne ni 'oe ma nao?” ");
INSERT INTO bvd_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Sa Disas ka bae 'urii fuana, “Iuka, nia naa nai 'oe saea nai. Ma sui ta, ku faarongo kamolu tiifau, kamolu totoo molu kai suaku 'Alakwa Nia Wane, kwai gooru 'ana 'inito lae 'i bali aolo nia God 'ana rigitaa, ma nau kwai dao mai lao dasa loo 'i lofona salo.” ");
INSERT INTO bvd_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","'I seeri guu na waa foa ni gwau nai rakena 'e ngengeela, 'e liu ka tala karia gwana maku tikwa nia nai, ma ka bae na 'urii, “Tee lau ne kolu maasia ta waa uri ka saea lau suli sa wala nee sae uri kolu kafi faamamane? Kolu tala rongo sui naa nai ne nia faabolatainia fai God nai! ");
INSERT INTO bvd_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kamolu manata 'utaa?” Kera da luu nia daka 'urii, “Si doo uri nia ka maelia naa ne.” ");
INSERT INTO bvd_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","'I seeri kera daka ngisufi nia naa usi maana, ma daka kwae nia naa. Ma tai waa daka fidali nia naa, daka bae na 'urii, ");
INSERT INTO bvd_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Nee Kraes, saea fasi mai tii nai fidali 'oe kau nai?” ");
INSERT INTO bvd_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Si kada sa Bita nia gooru 'ana lao lalo nai, tii wela keni nai 'ana keni rao nai ki 'i seeri 'e lea mai ka bae 'urii fuana, “'Oo! Ma doo ni 'oe ta waa lau gu 'ana waa baki da too mai fai sa Disas waa loko 'i Galilii ta nee na!” ");
INSERT INTO bvd_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Sa Bita nia ka tofe ni maea 'i maada sui gwana ka 'urii, “Nau ku ulafusia doo ne 'oe bae sulia nai wala.” ");
INSERT INTO bvd_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sui, si kada sa Bita 'e lea kau ka nii karangia naa maesakaa nai ni ruu lae ai, ta ruana wela keni rao nai ka suana lau guu. Saari nai ka bae 'urii fua toaa da nii seeri ki, “Sa wala nee, doo nia ta waa lau guu 'ana waa baki da too kwaimani mai fai sa Disas waa loko 'i Naasaret nee na!” ");
INSERT INTO bvd_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Sa Bita ka tofe lau gu 'i seeri ka bae 'urii, “Nau dodoloa mai 'ana doo abu ki ku saitomana sa wala nai.” ");
INSERT INTO bvd_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nao si tau gwana 'i burina nia bae 'uri nai, na toaa ne da uu ki 'i seeri kera lea mai daka bae lau gu 'urii fua sa Bita, “Doo mamane naa ta nee na. Doo 'oe ta waa lau guu 'ana waa baki 'ua nee. Tee bae lamu rongo toi lae 'uri kera lau gu nee. Bae lamu 'ua gu ne faatai folaa ai!” ");
INSERT INTO bvd_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","'I seeri sa Bita nia ka tala agi nia 'ana ka 'urii, “Lea nau ku suke gwaku, alu God kwae nau 'ana faafia. Suli na waa nee waa ku ulafusia ne!” Si kada nai 'ua guu, karai ka 'ai naa 'i 'ofaidani. ");
INSERT INTO bvd_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","'I seeri sa Bita ka manata toi naa si baea sa Disas 'e saea 'ua mai fuana ma ka bae 'urii, “'Oe tara 'o tofe faafi nau lao fa rodo 'i tari'ina 'ana olu si kada sui fatai karai kafi 'ai 'ofaidani.” Si kada sa Bita 'e manata toi si doo nai, nia 'e ruu kau 'i maa ka angi baita ka igigele guu. ");
INSERT INTO bvd_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Lao 'uubongi maakafukafua 'ua guu, na waa baita ni foa nai ki tiifau fai nia toa gwaungai ki, kera da alakwaifaafi sui naa uri saumaeli lana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kera daka kani nia sui daka talaia naa sia sa Baelat waa nai lio suli bali lolofaa nai. ");
INSERT INTO bvd_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Si kada sa Diudas, waa nai 'e falea sa Disas 'i 'abana malimae ki, nia suai kera alu fua mae lana naa sa Disas, nia ka manata oli lau. Ma nia ka olitainia lau gwana olu finita seleni baki fua waa baita ni foa ki ma toa gwaungai ki. Ma ka bae 'urii fuada, ");
INSERT INTO bvd_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Nau gu ne ku abulo ta'aa naa, suli tee ne ku falea gwaku waa 'o'olo nee fua malimae ki uri daka saungi nia.” Kera luu nia daka bae 'urii, “Bali nai, 'oe naa ne 'abarua ai. Kameli doo meli si bae lau gwameli sulia nai.” ");
INSERT INTO bvd_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ma sa Diudas ka 'ui gwana kau 'ana malefo nai ki lao beukaua loo, sui ka lea na 'ana. 'I seeri, nia lea kau ka tala lio nia ka mae naa. ");
INSERT INTO bvd_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ma na waa baita ni foa ki daka gweea seleni nai ki sui daka bae 'urii, “Malefo nee nia abu 'ana taki kolu uri alu lae lao wai malefo nee 'ana beukaua nee. Suli na malefo nee, na malefo dai sauwane uria ne.” ");
INSERT INTO bvd_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kera daka alaofu naa uri daka ngali malefo nai daka folia 'ana tii si gano siana tii waa ni saungai sosoben lae 'ana saegano. Si gano nai, kera daka alu naa uri kula ni saufini wane lae fua toaa 'i sara ki ne nao lau toaa Diu ki. ");
INSERT INTO bvd_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Si doo nai gu ne adea daka 'ailia satana si gano nai lelea mai ka dao tari'ina 'i Ano 'Abu. ");
INSERT INTO bvd_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","'I seeri guu, si doo bae brofet Dioromaea 'e bae 'uabaa na mai sulia 'ana kada 'i nao ka fuli naa. Bae nia bae 'urii, “Kera da ngalia olu taafuli fa seleni ki, na malefo nai toaa 'Israel da kwaa ai uri foli lana 'ana wane, ");
INSERT INTO bvd_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","kera daka folia 'ana si gano siana waa ni saungai sosoben lae 'ana saegano, uri ka lea suli si doo God nia saea fuaku.” ");
INSERT INTO bvd_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Aia ma sa Disas, nia ka uu gwana 'i maana sa Baelat waa nai lio suli bali lolofaa nai. Ma sa wala nai ka ledi 'urii naa 'ana sa Disas, “Nee wala, ma ni 'oe naa ne waa 'inito kera toaa nee Diu?” Sa Disas 'e luu nia ka 'urii, “Iuka, nia naa nai 'oe saea nai.” ");
INSERT INTO bvd_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Si kada na waa baita ni foa nai ki ma na toa gwaungai nai ki da saea sa Disas nia garo naa, nia nao si olisi kera guu. ");
INSERT INTO bvd_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","'I seeri sa Baelat ka bae 'urii fuana, “'Oe nao si rongo guu doo 'oro ne da saea 'oe garo ai nee?” ");
INSERT INTO bvd_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ma sui boroi, sa Disas ka nao si olisia guu ta tii si doo ai. 'Uri nai sa Baelat ka kwele 'asia naa 'ani nia. ");
INSERT INTO bvd_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Aia, tii si birangaa sa Baelat kai ilia walude 'ana si kada 'ana Fangatasae ne 'ifingi lana ta waa Diu ne toae dooria uri ka ruu 'ana 'i maa fasi lao lookafo. ");
INSERT INTO bvd_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","'Ana si kada nai, tii waa toaa nai ki sui da saitomana da alu ka nii lao lookafo. Satana waa nai sa Baarabas. ");
INSERT INTO bvd_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Doo ne adea guu, si kada nai konia nai 'e koni mai, sa Baelat ka ledi kera. Nia ka 'urii, “Waa tee 'ani keerua ne kamolu dooria nau kwai lukea mai fuamolu, sa Baarabas, ma nao sa Disas ne kera 'ailia 'ana Kraes?” ");
INSERT INTO bvd_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nia bae 'uri nai, suli 'e saitomana gwana na waa gwaungai ki da talaia mai sa Disas siana suli manata lada ta'aa sia sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Si kada sa Baelat 'e gooru naa 'ana kula ni gooru lae uri kwae lana kwautoe ki, 'afe nia 'e falebaea mai ka dao siana ka 'urii, “Nao 'osi ili tasi doo 'ana sa wala nena, suli nau ku dao toi tii 'afitai laa baita 'i tari'ina burina maleubole laa ku maleubolea suli nia.” ");
INSERT INTO bvd_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ma sui, waa baita ni foa ki ma toa gwaungai ki kera daka bae alingana 'ada konia nai uri daka saea sa Baarabas ka too 'ana nao dasi saungi nia lau. Sa Disas 'ana ne da saea uri daka saumaeli nia boroi 'ada. ");
INSERT INTO bvd_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ma sa Baelat ka ledia lau konia nai ka 'urii, “Sa tii 'ana roo waa neki ne kamolu dooria nau kwai lukea mai fuamolu?” Kera daka bae 'urii fuana, “Sa Baarabas!” ");
INSERT INTO bvd_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Sa Baelat ka bae 'urii, “Ma tee ne nau kwai ilia 'ana sa Disas, ne kera saea 'ana Kraes?” Kera tiifau naa daka bae 'urii, “'O foto faafia 'ana 'airarafolo.” ");
INSERT INTO bvd_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Sa Baelat ka bae lau 'urii, “Tee ne nia ilia ka garo, uri nau ku ade 'uri nai 'ani nia?” Ma sui, kera daka 'ai baita 'ada kau daka 'urii, “'O foto faafia 'ana 'airarafolo wala.” ");
INSERT INTO bvd_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ma si kada sa Baelat 'e suai ne nia bae boroi ka nao si liu naa ma na firu lae boroi ka safali naa, nia ngali kafo ka taufia 'abana 'i maana konia nai sui gwana ka bae 'urii, “Nau ku taufia 'abaku uri ka faatainia ne mae lana sa wala nee nao si tio faafi nau nai. Ni kamolu naa nai nia tio kau faafi kamolu.” ");
INSERT INTO bvd_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Na konia nai sui guu kera luu nia daka 'urii, “Alu mae lana too 'ana faafi kameli fai wela kameli ki mai buri.” ");
INSERT INTO bvd_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","'I seeri, sa Baelat ka saea daka 'ifingia naa sa Baarabas fuada. Aia ma sa Disas, sa Baelat ka saea daka kwaea fasi 'ada, sui sa Baelat ka falea naa sa Disas fuada uri daka foto faafia 'ana 'airarafolo. ");
INSERT INTO bvd_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","'I seeri toa ni omee sa Baelat ki daka talaia na kau sa Disas lao beu sa Baelat, ma na omee nai tiifau ka koni kali sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ma kera daka lukea maku nia ki sui daka faa ruufi nia 'ana maku baita 'a'abua nai. ");
INSERT INTO bvd_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Sui kera daka 'e'erea na 'e'ere 'oko konala nai sui ngali daka felengainia naa 'i gwauna. Kera daka falea saga 'ai nai nia ka dau ai 'ana 'aba aolo nia uri sua lana ka mala ta waa 'inito, sui kera daka booruru 'i naofana. Ma kera daka 'onionga 'ani nia, daka bae 'urii, “Ele 'asia naa fuamu, 'oe waa 'inito kera toaa Diu!” ");
INSERT INTO bvd_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kera daka ngisufi nia, sui daka lafua si 'ai bae fasi lao 'abana daka kwae ai lao gwauna. ");
INSERT INTO bvd_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Si kada kera 'onionga 'ani nia 'uri nai sui, kera daka lukea lau gwada maku bae faasi nia. Sui kera daka faa ruufi nia lau gwada 'ana maku nia ki. 'I seeri kera daka talaia na kau uri foto lae faafi nia 'ana 'airarafolo. ");
INSERT INTO bvd_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Si kada kera lea na kau 'uri nai, kera daka dao tona tii waa nai fasi fera 'i Saerin, ne satana sa Saemon. Ma kera daka suumainia naa fua sa Saemon uri ka tamaa 'airarafolo nai sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kera lea kau daka dao naa 'ana si kula nai satana 'i Golgota. (Toolangai lana, “Si kula nia gwa lelete”). ");
INSERT INTO bvd_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kera dao 'i seeri daka faa waen nai da dolalia fai ta doo 'afae nai fua sa Disas uri ka kuufia. Ma sa Disas 'e mea toi sui ka ote nia kuufia guu. ");
INSERT INTO bvd_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Si kada kera foto faafia sa Disas 'ana 'airarafolo ka sui naa, kera daka saso 'ana tii doo mala dais nai uri daka tolingia maku nia ki fuada kwailiu. ");
INSERT INTO bvd_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ma kera daka gooru gwada 'i seeri 'ana folo lae kali sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Si doo nai da saea kera da saungi sa Disas faafia, da kedaa sui daka alu 'i langi gwauna 'airarafolo nai otofana gwau sa Disas. Si kekeda laa nai 'e bae 'urii, “Sa Disas naa ne, na Waa 'inito bae toaa Diu.” ");
INSERT INTO bvd_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ta roo waa beli ki, kera da foto faafi keerua 'ana 'airarafolo ki daka nii kwaimani lau guu fai 'airarafolo sa Disas. Ta doo 'i bali aolo, ma ta ruana doo 'i bali mauli. ");
INSERT INTO bvd_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Toaa ne da liu 'i seeri ki da bae malawelaa sa Disas, da tatainia gwauda ki daka 'urii, ");
INSERT INTO bvd_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“'Oe waa bae 'o saea 'oe kai okosia beukaua loo sui 'oko saungainia lau gwamu suli olu fa dani ki gu nai, aia ma 'o faamauri 'oe fasi tala'amu! Lea 'oe 'Alakwa God mamana guu, 'oko koso mai fasi 'airarafolo nena!” ");
INSERT INTO bvd_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Na waa baita ni foa ki, na waa toolangaidoo ki 'ana taki ma na toa gwaungai ki kera boroi da ili 'uri nai sui gwada 'ani nia. ");
INSERT INTO bvd_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ma daka bae 'urii, “Nia waa bae faamauria toaa 'e'ete 'oro bae nai, ma sui tee ne adea ka nao si faamauri nia 'i tala'ana nai? Nia waa 'inito kera bae toaa Diu ki nai! Aia, alu nia koso fasi mai saegano fasi 'airarafolo loko uri kolu ka manata mamana 'ani nia! ");
INSERT INTO bvd_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nia waa bae saea nia fiitona God nai. Aia lea God doori nia, alu God faamauri nia fasi 'ana si kada nai! Suli nia waa bae kai bae 'urii na, ‘Nau naa ne 'Alakwa nia God!’” ");
INSERT INTO bvd_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Na roo waa abulo ta'aa nai ki da foto faafi keerua lau guu 'ana 'airarafolo ki 'i seeri fai sa Disas nai, keerua boroi daru ka saea lau guu si baea ta'aa 'oro ki fuana sa Disas 'uri nai. ");
INSERT INTO bvd_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Rodo ka rodo faafia faano nai tiifau 'ita 'i tofungana sato ka lea sulia olu kada sato ki. ");
INSERT INTO bvd_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Dao 'ana oluna kada sato, sa Disas 'e 'ai baita ka bae 'urii, “'Ilae, 'Ilae, lema sabaktani.” Nia toolangainia, “God nau 'ae, God nau 'ae, tee ne adea 'oko ekwatai nau naa?” ");
INSERT INTO bvd_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Si kada tai waa 'ana waa nai ki da uu 'i seeri da rongo, kera daka bae 'urii, “Nia 'ai uri sa 'Ilaeja nai.” ");
INSERT INTO bvd_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ta tii waa ada 'e lae kau asi kada nai 'ua guu ka ngali mai doo mala si lumulumu nai. Nia ka kurumainia lao waen lifoo nai sui ka usufia gwauna saga 'ai nai ka faa 'alaa kau ai uri sa Disas ka notofia. ");
INSERT INTO bvd_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Toa nai sui gwana daka bae 'urii fua sa wala nai, “Too 'ana, nao 'osi ade lau 'uri nai 'ani nia. Alu kolu lio 'akolu fuana, ade lea sa 'Ilaeja ka dao uri faamauri lana.” ");
INSERT INTO bvd_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ma sa Disas ka 'ai baita lau, sui guu mangona ka liu naa. ");
INSERT INTO bvd_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","'Ana si kada nai 'ua guu, na maku baita bae taru folosia tofungana beukaua loko, 'e kari 'ana roo bali maku ki, 'ita mai 'i gwauna lelea mai ka sui 'i 'aena. Na anuanu ka 'igi, ma na fau ki ka maga. ");
INSERT INTO bvd_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Na likwafau ni alu wane ki daka 'ifi, ma toaa 'oro nia God ki ne kera mae 'ua naa daka mauri daka tatae lau. ");
INSERT INTO bvd_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ma kera daka ruu 'i maa fasi lao likwafau kera ki, ma burina sa Disas 'e tatae fasi maea ka sui naa, kera daka dao lao maefera baita abu loo 'i Durusalem daka liu faatai ma toaa 'oro ki daka suada. ");
INSERT INTO bvd_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Si kada tii waa ni omee nai 'e gwaungai 'ana tii talangee wane ni firu lae nai, fai nia toa ni firu lae ki lau guu ne kera too ni folo laa 'i seeri kera da suana anuanu nai ma daka suana doo 'oro nai ki da fuli nai, kera daka mau 'asia naa. Ma kera daka 'ai baita daka bae 'urii, “Nia mamana 'asia naa, nia 'Alakwa God naa bae!” ");
INSERT INTO bvd_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Na wela keni 'oro ki da nii seeri, ne kera gooru tau kau daka bubu gwada kau. Kera ai da lea kwaimani ki mai fai sa Disas 'ita mai Galilii ka lea mai uri ili lana si raoe ki 'adomi nia. ");
INSERT INTO bvd_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ta ai 'ada ne ni Meri ai fasi maefera 'i Magdala, ni Meri ai bae gaa sa Demes fai nia sa Diosef, na 'initai 'afe sa Sebedii fai tai ai lau. ");
INSERT INTO bvd_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Si kada faanoe karangi rodo naa, tii waa suadoo nai fasi maefera 'i 'Arimatea 'e lea mai ka dao. Waa nai satana sa Diosef, ta waa lau guu 'ana toaa kwairooi sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nia lea ka ledia sa Baelat uri ka tagi suli noni sa Disas. Sa Baelat ka saea naa fua toa nia ki kera lea daka faa na fuana. ");
INSERT INTO bvd_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Sa Diosef 'e ngalia noni sa Disas lea ka 'afua 'ana 'aba maku kwakwaoa falu nai, ");
INSERT INTO bvd_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","sui nia ngali ka alua naa lao likwafau falu nia nai da garua lao ilifau nai. Nia 'e taraa mai 'aba fau baita nai ka fonokia 'ana maana likwafau baita nai, sui ka lea na 'ana faasia. ");
INSERT INTO bvd_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ni Meri ai bae fasi 'i Magdala ma ta ruana Meri bae lau, keerua daru ka gooru gwadaru 'i maana likwafau nai. ");
INSERT INTO bvd_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Fa dani 'i burina, ne fa dani Sabat naa, na waa baita ni foa ki, fai Faarisii ki kera lea daka dao sia sa Baelat. ");
INSERT INTO bvd_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ma kera daka bae 'urii fuana, “Waa baite kani 'ae, kameli meli manata toi si kada bae sa wala bae mauri 'ua, doo nia na waa ni suke bae 'ua guu, nia bae ka 'urii, ‘Burina olu fa dani, nau kwai tatae fasi maea!’ ");
INSERT INTO bvd_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Doo ne adea guu, 'o saea fasi fua toa 'oe ki uri kera daka folo diana kali likwafau loko lelea ka dao guu 'ana oluna fa dani. Lelea nao, tara toa kwairooi nia ki sa wala bae kera dai ngali agwa 'ana nonina ma dai saufinia. Sui kera dai sukea toae ki dai saea sa Disas nia tatae naa fasi maea. Ma lea kera ili si doo nai, nia kai ta'aa ka talua fatai suke laa nai sa wala nai ilia mai 'ana toae ki 'i nao.” ");
INSERT INTO bvd_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ma sa Baelat ka 'urii fuada, “Aia lea nia 'uri nai, kamolu 'ua guu molu kai talaia kau bali 'ana omee nau nee, molu ka folo diana 'ua guu kalia likwafau nai, 'ana tasi ade laa ne molu saitomana molu kai ilia nia ka lau.” ");
INSERT INTO bvd_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nia 'uri nai guu, kera lea daka folo diana naa kali likwafau nai uri ka lau. Kera daka alua naa tii si mamalafooa ni lio lae uria lea ta waa ka 'idua, 'ana sabi 'ana likwafau nai. Ma kera daka alua waa ni folo lae ki daka folo lau guu kalia. ");
INSERT INTO bvd_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","'I burina naa fa dani Sabat, 'i 'uubongi maakafukafua 'afa sato totoonao 'ana wiiki, ni Meri ai bae fasi Magdala, ma ta Meri ai bae lau guu, keerua daru ka lea naa uri maatoi lae likwafau bae. ");
INSERT INTO bvd_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","'I seeri tii anuanu nai ka 'igi baita 'asia naa, suli tii 'ensel God nia koso mai fasi 'i salo. Ma nia ka lea kau ka 'idua naa reba fau bae fasi maana likwafau bae ma ka gooru 'ana 'i fafona. ");
INSERT INTO bvd_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","'Ensel nai sua lana 'e mala kwesu lana kwakwange ma na maku nia ki sua lada ka kwakwaosarea. ");
INSERT INTO bvd_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Na waa baki ni folo lae, kera da suana daka mau 'asia naa 'ani nia daka lelebe daka mala naa waa mae ki. ");
INSERT INTO bvd_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Na 'ensel nai ka bae 'urii fua roo ai baki, “Nao muru si mau lau. Nau ku saitomana kamuru muru nanisia sa Disas waa bae kera da foto faafi nia 'ana 'airarafolo ne. ");
INSERT INTO bvd_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nia nao si nii naa 'i seki. Nia 'e tatae naa fasi maea, doo bae nia saea 'ua gu fuamolu. Muru lea mai muru suana kula bae nia tio ai. ");
INSERT INTO bvd_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Aia, kamuru muru lea 'ali'ali naa, muru ka faarongoa toa kwairooi nia ki. Muru bae 'urii fuada, ‘Sa Disas nia tatae naa fasi maea ma ka lea ka maasi kamolu naa 'i Galilii. 'I seeri naa ne molu kai suana ai.’ Nau ku faarongo kamuru sui naa nai, muru ka manata toi si doo nai.” ");
INSERT INTO bvd_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","'Uri nai guu, roo ai nai ki daru ka oli 'ali'ali na mai fasi likwafau nai. Keerua daru ka mau 'asia naa ma sui boroi 'ana, keerua daru ka ele 'asia naa lau guu. Keerua daru ka lae 'ali'ali naa uri faarongo lana toa kwairooi nai ki sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Keerua daru tona lau gwadarua, sa Disas 'e dao todaru ka bae na kau 'urii fuadaru, “Sato diana kau roo ai!” Ma keerua daru tola mai suli nia daru ka ngiria na 'aena ki ma daru ka faabaita nia naa. ");
INSERT INTO bvd_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","'I seeri sa Disas ka bae 'urii fuadaru, “Nao muru si mau lau. Muru lea muru ka faarongoa naa toolaku ki, uri kera daka lea na kau uri Galilii. 'I seeri naa ne kera dai suaku ai.” ");
INSERT INTO bvd_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Si kada nai roo ai nai ki daru oli mai ma daru ka nii na suli taale, tai waa 'ana toa ni folo nai ki kera daka lea naa uri lao maefera baita nai 'i Durusalem. Kera da dao 'i seeri daka faarongoa naa waa baita ni foa ki ma waa gwaungai ki 'ana doo nai ki sui guu kera da suai kau. ");
INSERT INTO bvd_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Si kada na waa baita ni foa ki fai toa gwaungai ki da bae ofu ma daka kwai ala faafi naa fua si doo nai, kera daka falea tii si malefo baita fuana toa fofolo nai ki. ");
INSERT INTO bvd_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Kada toa baite nai ki da falea malefo nai fua waa da folo ki, kera daka bae 'urii, “Lea kau molu ka faarongoa toae ki sui guu molu ka 'urii, ‘Na toa kwairooi baki sa Disas kera da lea mai daka ngali agwa 'ana nonina lao rodo kada meli maleu.’” ");
INSERT INTO bvd_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Toa gwaungai nai ki, kera daka bae lau guu 'urii fua toa folo bae, “Lea sa Baelat nia ka rongo boroi si doo nai, ni kameli naa ne meli kai 'olosia kau siana. Nao molu si 'oga lau ai, sulia kameli naa ne meli kai 'olosia kau, uri ka nao manata lana si ta'aa lau siamolu.” ");
INSERT INTO bvd_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Na toa ni folo nai da ngali malefo nai, kera daka ilia naa si doo nai waa baita nai ki saea fuada nai. Ma na ununua nai ka talo 'i matangana toaa Diu ki lelea mai ka dao gu 'i tari'ina. ");
INSERT INTO bvd_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","'I seeri na akwala ma tii waa sarenga ni kwairooi baki sa Disas ki kera daka lea naa uri tii fa uo 'i Galilii, si kula nai sa Disas 'e saea sui na mai fuada uri daka lea uria. ");
INSERT INTO bvd_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Si kada kera suana sa Disas, kera daka faabaita nia naa. Sui boroi 'ana, tai waa ki 'ani kera daka manata ruarua gwada suli nia. ");
INSERT INTO bvd_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","'Uri nai sa Disas ka lea karangi mai siada ka bae 'urii, “God nia fale tiifau naa 'ana rigitaa 'i salo ki ma rigitaa lao fera ne 'i saegano ki fuaku. ");
INSERT INTO bvd_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nia 'uri nai, kamolu molu lea siana 'aebara ki sui guu lao molaagali molu ka talai kera mai uri daka kwairooi 'ada 'ani nau. Molu faasiuabu kera 'ana satana Maa, ma na Wela, ma na Anoedoo Abu. ");
INSERT INTO bvd_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma molu ka toolangaidoo siada uri kera daka ade suli doo baki sui guu nau ku toolangainia siamolu. Ma ni nau kwai nii kwaimani fai kamolu 'ana si kada ki sui guu lelea ka dao 'ana sui lana fera ne 'i saegano.” ");
INSERT INTO bvd_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Na Faarongoa Diana nee sulia sa Disas Kraes na 'Alakwa God, na safali lana mai 'e 'urii: ");
INSERT INTO bvd_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nia safali mai mala bae sa 'Aesaea na brofet nia kedaa mai si baea God 'e saea fua Kraes ma ka bae 'urii, “Nau kwai odua kau waa ni ngali baea nau kai lea kau 'i nao 'ani 'oe, uri nia dao ka ade akau 'ana toae ki fuamu. ");
INSERT INTO bvd_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tii waa nia 'ai laona fera kwasi fuana toae ki. Nia ka bae 'urii, ‘Na Aofia nia kai dao mai! Molu 'olosia taale ki fuana!’” ");
INSERT INTO bvd_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","'Uri nai guu, sa Dion nia ka dao naa laona fera kwasi nai. Nia 'e ofi gwana 'ana maku da saungainia 'ana ifuna kamel, ka kania gwana straf 'ana 'ungana buluka, ka 'ania gwana siko ki ma na wewedua kwasi ki. Ma nia ka faasiuabua toae ki, ka bae 'urii fuada, “Molu bulasi manataa, molu ka siuabu uria God ka manata lukea abulo ta'aa laa kamolu ki.” Ma toaa 'oro 'asia naa daka lea mai uri rongo lana bae lana sa Dion. Toaa nai ki kera lea mai faasia bali lolofaa 'i Diudia, ma faasia maefera baita 'i Durusalem. Kera ka faarongo folaa 'ana abulo ta'aa laa kera ki, ma nia ka faasiuabu kera lao kafo 'i Diodan. ");
INSERT INTO bvd_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma sa Dion ka bae lau gu 'urii fuana toaa nai ki, “Tii waa nia kai dao mai buriku, ne nia 'e tetede tasa ka talu nau fatai, ma nau boroi ka nao kwasi bobola fainia uri ku 'agwaoro ku lukea sadol nia. ");
INSERT INTO bvd_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Tasi doo lau guu, nau ku faasiuabu kamolu gwaku 'ana kafo, ma sui waa nai mone nia kai faasiuabu kamolu 'ana Anoedoo Abu 'ua guu.” ");
INSERT INTO bvd_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nao si tau lau guu buri doo nai ki, sa Disas 'e too mai 'i Naasaret lao bali lolofaa 'i Galilii lea mai ka dao naa. Ma sa Dion ka faasiuabu nia naa lao kafo nai 'i Diodan. ");
INSERT INTO bvd_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ma si kada sa Disas nia tatae mai fasi lao kafo, nia lio 'alaa ka suana salo loo nia 'ifi. Ma na Anoedoo Abu ka koso mai mala 'ana fa bole ka dau na faafi sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma tii si lingee doo 'e talo mai fasi 'i salo ka bae 'urii, “'Oe 'alakwa nau naa ne 'oe tii fa wela 'autania nau ne ku liosau 'ani 'oe. Manata laku 'e ele 'asia naa suli 'oe.” ");
INSERT INTO bvd_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ma 'ali'ali 'ua guu buri sa Disas nia siuabu, na Anoedoo Abu ka talai naa sa Disas uri lao fera kwasi nai. ");
INSERT INTO bvd_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ma nia ka too 'i seeri suli faitaafuli fa dani, ma sa Saetan ka ilitona. Na doo kwasi da too 'ana fai'ae ki, kera ni lau guu 'i seeri, ma sui boroi 'ana 'ensel ki kera lea mai daka 'adomi nia. ");
INSERT INTO bvd_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","'I burina kera daua naa sa Dion uri alu lana laona lookafo, sa Disas ka oli na mai lao bali lolofaa nai 'i Galilii, ma nia ka faarongo talo naa sulia na faarongoa diana God. ");
INSERT INTO bvd_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ma nia ka bae 'urii, “Nia dao naa 'ana si kada bae kera bae mai sulia ne. 'Initoaa God 'e nii karangi na siana toae ki. Molu bulasi manataa fasi abulo ta'aa laa kamolu ki, molu ka faamamanea na faarongoa diana nee.” ");
INSERT INTO bvd_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kada sa Disas 'e 'iia 'osi 'i Galilii, nia ka suana sa Saemon fainia toolana sa 'Andru. Keerua roo waa ni dee lae ki. Keeru daru dee 'adarua 'ana furai keeru laona 'osi nai. ");
INSERT INTO bvd_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ma sa Disas ka bae 'urii fuadaru, “Muru lea mai fai nau uri nau ku toolangainia dee lae siamuru, uri muru ka deea mai wane ki fuaku.” ");
INSERT INTO bvd_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ma kada nai 'ua guu, keeru ka faasia furai keeru nai ka tio na 'i seeri, daru ka lea na 'adaru fainia. ");
INSERT INTO bvd_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Sui, sa Disas nia taa lea tu'uu lau gu kau, ka suana lau guu sa Demes fainia sa Dion, roo 'alakwa sa Sebedii ki. Keeru too gwadaru laona kaa baru nai, ma daru ka roo 'adaru 'ana kaura lana furai keerua. ");
INSERT INTO bvd_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ma si kada sa Disas 'e suadaru, nia ka 'aili keeru lau guu. Keeru daru ka faasia maa keeru sa Sebedii lao gwa baru nai fainia na toa ni rao ki, ma ni keeru daru ka lea na 'adaru fai sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Sa Disas fainia waa kwairooi nia ki, kera dao 'ana maefera 'i Kabaneam. Ma dao 'afa dani Sabati nai, sa Disas nia ka lea naa laona beu ni ofu laa nai, ka toolangaidoo naa fua toaa 'oro 'i seeri ki. ");
INSERT INTO bvd_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Si kada kera rongoa doo nai ki nia bae sulia lelea ka sui, kera daka kwele 'asia naa 'ana toolangaidoo laa nia, suli kera da saitomana sa Disas nia toolangaidoo fainia rigitaa God. Nao si 'uria lau toa saitoma doo kera ki 'ana taki sa Mosis, ne da toolangaidoo gwada fainia saitoma doo lana wane ma rigitaa kera 'i tala 'ada. ");
INSERT INTO bvd_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ma si kada nai, tii waa nai anoedoo ta'aa burosia, 'e nii lau gu lao beu ni ofu laa nai. Ma waa nai ka akwa baita ka bae 'urii, ");
INSERT INTO bvd_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Disas 'ae! 'Oe na waa 'i Naasaret! Tee ne 'oi ilia 'ameli nee wala? Alamia 'oe dooria naa faafunui lameli lae 'oto nee! Nau ku saitomamu gwaku, 'oe na Waa Abu God ne!” ");
INSERT INTO bvd_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Sa Disas ka ngatafia na anoedoo ta'aa nai ka 'urii, “'Oe taaro 'amu wala, 'o ruu mai maa fasi sa wala nena!” ");
INSERT INTO bvd_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ma na anoedoo ta'aa nai ka ilia sa wala nai ka akwa baita, ka lelebe baita, sui na anoedoo ta'aa nai ka lea na fasi sa wala nai. ");
INSERT INTO bvd_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ma toaa nai da koni 'i seeri ki, daka kwele 'asia naa, daka ledi kera kwailiu daka 'urii, “Rowane 'ae, ma tee naa ne 'urii? Ma toolangaidoo laa falu 'ana nee! Sa wala nee nia bae fainia rigitaa totoo 'ana! Tee ne nia odua anoedoo ta'aa ki, ma daka roo gu suli bae lana nee!” ");
INSERT INTO bvd_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","'I seeri guu, 'ali'ali faarongo lae suli sa Disas ka talo naa laona bali lolofaa nai 'i Galilii. ");
INSERT INTO bvd_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Si kada sa Disas fainia sa Demes ma sa Dion, kera faasia beu ni ofu laa nai, kera daka lea 'i luma kera sa Saemon fainia sa 'Andru. ");
INSERT INTO bvd_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kada sa Disas 'e dao naa 'i luma nai, kera daka faarongo nia, ne 'initai fungo sa Saemon nia 'e matai 'ana 'a'ako lae, ka tio gwana 'i luma. ");
INSERT INTO bvd_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Sa Disas lea ka dao siana 'initai nai ka dau 'i 'abana, ka tataea. Ma na 'a'ako laa nai ka sui na faasia, ma 'initai nai lea ka rao fanga na 'ana fuada. ");
INSERT INTO bvd_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ma dao kada sato 'e suu naa 'i saulafia 'afa dani nai, 'ana sui lana fa dani sabat, toaa nai ki daka ngalia mai toaa 'oro da matai ki, ma toaa 'oro anoedoo ta'aa ki ruufida ki ma daka lea na mai siana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ma toaa nai 'ana maefera nai daka koni tiifau na mai maana luma nai. ");
INSERT INTO bvd_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ma sa Disas ka guraa toaa 'oro matai nai fasi mataia 'e'ete 'oro kera ki sui gwana. Ma nia ka taria lau guu anoedoo ta'aa 'oro. Sui nia ka saea fua anoedoo ta'aa nai ki nao dasi bae lau, suli kera saitomana sui naa ne nia 'Alakwa nia God. ");
INSERT INTO bvd_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sa Disas nia ada 'ua lao 'uubongi rorodoa, ka faasia luma nai nia too ai ka lea naa uria tii si kula banitai nai, ka foa 'ana 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ma sa Saemon fainia waa kwaimani nia ki kera daka nani na uri nia. ");
INSERT INTO bvd_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ma kada kera dao tona naa, kera daka bae 'urii fuana, “Toae ki sui gwana da nanisi 'oe ne wala.” ");
INSERT INTO bvd_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Sa Disas 'e luu kera ka bae 'ana 'urii, “Kolu lea 'akolu lau uri tai maefera 'e'ete 'ana bali karangi loko ki gwana, uri nau ku toolangaidoo lau, suli si raoa ne nau ku lea mai uri ili lana.” ");
INSERT INTO bvd_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","'Uri nai, sa Disas ka lea 'ana maefera ki sui gwana laona bali lolofaa 'i Galilii, ma ka faatalongainia bae lana God laona beu ni ofu laa kera ki, ma ka taria anoedoo ta'aa ki faasia toae ki. ");
INSERT INTO bvd_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","'Uri nai, tii waa furoa nai lau guu ka lea mai siana sa Disas ka booruru 'i 'aena, ka amasia ka 'urii, “Lea sa 'oe ala gwamu faafia, 'oko gura nau fasi uri ku 'akwaa 'aku.” ");
INSERT INTO bvd_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Sa Disas 'e manatainia 'asia naa sa wala nai, ka fale 'aba kau ka dau tona ka bae 'urii, “Nau ku ala gwaku faafia. Nau ku faa 'akwaa 'oe uri nonimu ka falu 'ana!” ");
INSERT INTO bvd_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","'Ana si kada nai 'ua guu, furo bae ka sigi na faasia ma nonina ka maafo tiifau naa. ");
INSERT INTO bvd_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Sa Disas ka bae fifii fua sa wala nai ka 'urii, ");
INSERT INTO bvd_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Nao 'osi faarongoa 'ua ta waa 'ana si doo nai ku ilia fuamu nai. Si doo 'oe ilia 'amu ne, lea kau 'oko faatainia nonimu siana waa ni foa uri ka iroa, ma 'oko faa afuafua ni koo lana talea God fuamu 'i 'abada, 'uri bae taki sa Mosis saea mai fua ili lana. 'I seeri, na waa ni foa ki daka faamamanea ne nonimu 'e maafo naa.” Sa Disas ka odua sa wala nai ka lea 'ua guu 'asi kada nai. ");
INSERT INTO bvd_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ma sui, si kada sa wala nai 'e lea kau, nia ka ununu na 'ana suli si doo nai fuli 'ani nia siana toae ki sui gwana. Ma si ununua nai sa wala nai ka adea toaa 'oro 'asia naa daka lea mai sia sa Disas ma ka kwaisuusi 'ani nia si ruu gu kau lao maefere nai ki. 'Uri nai, nia ka too ki gwana kau 'i sara ma toae ki daka lea gwada kau siana ki. ");
INSERT INTO bvd_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ma 'i burina ta bara fa dani 'e sui, sa Disas ka oli lau mai uria 'i Kabaneam. Ma kera daka faarongolado ai saea nia too gwana 'i luma nai nia 'ita dao kai too ki ai 'ana maefera nai. ");
INSERT INTO bvd_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","'Uri nai, toaa 'oro nai ki kera daka koni lau gu mai siana sa Disas, daka koni lelea lao luma nai ka fungu naa ma 'i maa boroi ka fungu naa lau guu. Ma sa Disas ka faarongo kera naa 'ana bae lana God. ");
INSERT INTO bvd_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ma si kada nai lau guu, ta fai waa nai ki daka ngalia mai tii waa 'afumae kwaea nai daka dao lau gu fainia. ");
INSERT INTO bvd_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kera daka ilitoi ngali lana kau sa wala nai siana sa Disas ka 'afitai, suli konia baita nai kwaisuusi fuada. 'Uri nai guu, kera lea daka raa 'i fafo lume fainia sa wala nai. Kera daka tafangia tii malekwadaa baita 'i fafona luma nai daka kosolangainia kau fainia doo nai nia tio fafona nai, ka koso kau uri saegano siana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ma si kada sa Disas nia lio filoa faamamane laa kera, nia ka bae 'urii fua waa 'afumae kwaea nai, “Wala 'alakwa nau, nau ku manata lukea abulo ta'aa laa 'oe ki.” ");
INSERT INTO bvd_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ma si kada nai lau guu, tai waa ni toolangaidoo ki 'ana taki, kera da nii lau guu 'i seeri. Ma kera daka manata 'urii, ");
INSERT INTO bvd_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Si doo 'e abu 'asia naa ne sa wala nee saea nai. Na wane gwana 'uri nia, 'e 'afitai ka faorana manata luke lana abulo ta'aa lae ki. God taifilia gu ne kai manata lukea abulo ta'aa lae ki. Nia faabolatainia naa fai God nai!” ");
INSERT INTO bvd_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ma sui, sa Disas ka saitomana 'ali'ali 'ua guu 'ana manata lada nai, nia ka bae 'urii fuada, “'E nao si diana fua kamolu ka manata ta'aa 'uri nai suli si doo nai. ");
INSERT INTO bvd_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Tee gu ne walude gwana fua sae lana fua sa wala nee? Bae lae 'urii fuana, ‘Abulo ta'aa laa 'oe ki nau ku manata lukea naa,’ ma nao bae lae 'urii fuana, ‘Tatae 'oko ngalia ifitai 'oe, 'oko fali 'oko lea 'amua?’ ");
INSERT INTO bvd_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nau kwai guraa sa wala nee uri ka faatainia siamolu ne nau 'Alakwa nia Wane, ku too 'ana rigitaa fua manata luke lana abulo ta'aa lae ki seki lao ano nee.” 'Uri nai guu nia ka bae na 'urii fua sa wala nai 'afumae kwaea nai, ");
INSERT INTO bvd_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nau ku saea fuamu, 'o tatae 'oko ngalia ifitai 'oe, 'oko lea 'amu 'i luma kamu.” ");
INSERT INTO bvd_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ma sa wala nai ka tatae, 'ali'ali ka ngalia ifitai nia, daka suana sui gwada nia lea na 'ana. Ma kera daka kwele 'asia naa, daka sae'inito 'ana God, ma daka bae 'urii, “Doo nao kolu si suai ki 'ua mai ne rowaa!” ");
INSERT INTO bvd_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Sa Disas ka oli lau ninimana 'osi bae 'i Galilii. Ma toaa 'oro nai ki daka koni lau gu mai siana, ma nia ka safali toolangaidoo siada. ");
INSERT INTO bvd_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ma si kada nia 'iia kau ninimana 'osi nai, nia ka suana sa Lifae, na 'alakwa sa 'Alfias. Sa Lifae, nia too 'ana 'i seeri lao si beu tu'uu ni foli takisi laa nai, suli nia rao 'i seeri. Ma sa Disas ka bae 'urii fuana, “'O lea mai buriku.” Ma sa Lifae ka tatae, ma ka lea na 'ana fainia. ");
INSERT INTO bvd_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ma si kada sa Disas fainia toa kwairooi nia ki da fanga 'i luma sa Lifae, toaa ni koni lana malefo 'ana takisi ki fainia tai toaa abulo ta'aa 'oro ki lau guu, kera da fanga kwaimani 'i seeri fainia. Toaa 'e'ete 'oro ne da kwairooi naa fainia sa Disas 'ana si kada nai. ");
INSERT INTO bvd_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tai Faarisii ki ni toolangaidoo lae 'ana taki sa Mosis, kera daka suana naa sa Disas nia fanga kwaimani fainia toa abulo ta'aa nai ki fainia toa ni koni lana malefo 'ana takisi ki. 'Uri nai guu, Faarisii ki daka bae 'urii fua toa kwairooi sa Disas ki, “Nia nao si too fua nia ka fanga kwaimani fainia toaa da abulo ta'aa 'urii ki ne.” ");
INSERT INTO bvd_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ma kada sa Disas nia rongoa si doo nai, nia ka bae 'urii fuada, “Waa ne too diana gwana doo nao si kwai 'atoi guu 'ana waa ni kwai gurai lae ne. Waa ne matai ne nia kwai 'atoi 'ana waa ni kwai gurai lae uri ka gura nia. Nau nao kwasi lea lau mai uri toaa da 'o'olo naa ne. Toaa abulo ta'aa ki lau 'ana ne nau ku lea mai uri kera.” ");
INSERT INTO bvd_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","'Ana tii si kada, tai toa kwairooi sa Dion waa ni faasiuabu fainia toa kwairooi Faarisii ki, kera da too ni abufanga laa 'ada. Ma tai waa daka lea mai daka bae 'urii fua sa Disas, “Toa kwairooi sa Dion ki fainia toa kwairooi Faarisii ki, kera da abufanga 'ada. Nia nao si too fua toa kwairooi 'oe ki ka nao dasi abufanga gu 'urii.” ");
INSERT INTO bvd_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ma sa Disas ka luu kera ka 'urii, “Nia nao si walude fua ruana nia ki fungao daka abufanga gwada 'ana si kada ne nia 'e too kwaimani gwana fai kera 'ana lumae, ma kera daka too ni ele lae 'ada fainia. ");
INSERT INTO bvd_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Sui ta, nia kai dao 'ana tii fa sato ne totoo kera kai talaia naa fungao nai faasia ruana nia nai ki ai. Ma 'ana si kada nai kera kai talaia fungao faasi kera ai ne kera kai abufanga. Doo ne adea guu, nia nao si bobola fainia toa kwairooi nau ki kera daka abufanga kada ne nau ku too 'ua gwaku fai kera nee.” ");
INSERT INTO bvd_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Sui sa Disas ka bae lau 'urii, “Wane ki 'afitai daka ngalia siina maku falu uri tai lana faafia si malesufua 'ana maku kwali naa. Lelea kera ade 'uri nai, tara si kada kera taufia sii maku falu nai ma ka lugu, nia kai lafu lau gwana fasi malesufua nai. Aia, ma si malesufua nai kai reba ka talua lau fua 'i nao. ");
INSERT INTO bvd_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ka 'uri nai lau guu, wane ki 'afitai daka ongia waen falu fua laona kufidoo kwali. Lelea kera ade 'uri nai, tara si kada na waen falu nai 'e bila ma ka ngingisula mai, nia kai fogea kufidoo kwali nai. Ma na waen nai ka kistai ma na kufidoo nai boroi ka ta'aa naa. Doo ne adea guu, na waen falu daka ongia lau guu laona kufidoo falu.” ");
INSERT INTO bvd_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","'Ana tii fa dani Sabat, sa Disas fainia toa kwairooi nia ki, kera lea suli taala nai 'e liu laona ola wiiti nai. Kada kera liu laona ola nai, toa kwairooi nia ki kera daka falia fungi wiiti ki daka dau 'ana 'ani lana kau. ");
INSERT INTO bvd_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ma na Faarisii ki daka liotoi, ma daka bae 'urii fua sa Disas, “Nee wala, ma tee ne adea toa 'oe nee daka ilia si doo 'e abu 'afa dani Sabat nee? Kamolu 'oia naa taki sa Mosis ne, molu ka falia wiiti nee 'ana Sabat nee!” ");
INSERT INTO bvd_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ma sa Disas ka luu kera ka 'urii, “Kamolu teemainia Buka Abu, molu ka liotoi gwamolu si doo bae sa Defet nia ilia otofana si kada sa 'Abiata nia foa ni gwau. Sa Defet fainia toa bae kera lea kwaimani bae, kera fiolo 'asia naa, ka nao naa tasi fanga 'ada. Ma nia ka ruu lao beu God, ma waa foa ni gwau bae ka faa mai beret bae abutai lana talea God fuana. Ma sa Defet fainia toa nia nai ki liu daka 'ania. Na taki kolu 'e saea fua taifilia gu waa ni foa ki ne nia mola fua daka 'ania beret nai. Ma sui boroi ka nao kolu si liotoi gu laona Buka Abu ne God nia ka 'abe kera faafia si doo nai.” ");
INSERT INTO bvd_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sui sa Disas ka bae lau gu 'urii fuana Faarisii ki, “God nia faa mai fa dani ni momola lae uri ka 'adomia wane. Ka nao nia si faa lau mai fa dani nai uri kulufi lana wane ka laeororo 'i farana. ");
INSERT INTO bvd_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Suli ni nau 'Alakwa nia Wane, nau ku too 'ana rigitaa fua sae lana doo ni ili lana 'ana Sabat.” ");
INSERT INTO bvd_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tii si kada lau guu, sa Disas nia lea kau lao beu ni ofu laa nai, ma tii waa 'abana mae ka nii lau gu 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Faarisii ki kera daka nii lau gu 'i seeri, ma kera daka folo gwada uria ade lea sa Disas ka guraa sa wala nai 'afa dani Sabat nai. Lelea sa Disas nia ili 'uri nai naa, kera daka bae lao maana fai 'oi lana taki God sulia fa dani Sabat. ");
INSERT INTO bvd_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ma sa Disas ka bae 'urii fua waa 'abana mae nai, “Tatae, lea mai 'oko uu 'i seeki maana toaa nee tiifau.” ");
INSERT INTO bvd_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sui sa Disas ka ledia Faarisii ki ka 'urii, “Tee ne taki kolu 'e faolomainia fua kolu ka ilia 'afa dani Sabat? Fua ili lana doo diane ki, ma nao ili lana doo ta'aa ki? Fua faamauri lana wane, ma nao saumaeli lana wane?” Ma sui kera ka nao dasi saea guu tasi doo. ");
INSERT INTO bvd_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Sa Disas ka lio rakesasu fuada kwailiu ma manata lana ka 'asia siada, suli lioda 'e sadi ka nao dasi manatainia guu waa 'abana mae nai. Sui, nia ka bae 'urii fua sa wala nai, “Tagaa kau 'abamu.” Ma nia ka tagaa 'abana, ma 'i seeri na 'abana ka diana lau gwana. ");
INSERT INTO bvd_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","'Uri nai guu Faarisii ki kera daka ruu kau 'i maa, ma daka bae ofu na fainia toa sa Herod ki, ma kera daka manata naa uri tasi ade laa tee ne kera kai ilia uri saumaeli lana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Sa Disas fainia toa kwairooi nia ki, kera faasia konia nai, daka lea na kau uria maana 'osi 'i Galilii. Ma na toaa 'oro nai ki daka lea lau guu 'i burida. Toaa nai da lea ki mai fasi bali lolofaa 'i Galilii fainia 'i Diudia ma 'Idumea, ma bali lolofaa 'i tae lana sato 'ana bali loo mai 'ana kafo 'i Diodan. Ma ta bali kera daka lea mai fasi maefera baita 'i Durusalem. Ta bali lau guu daka lea mai fasi maefere ki karangia fakali 'i Taea fainia maefera baita 'i Saedon. Na toaa 'oro nai, da lea mai siana sa Disas, suli kera da rongoa mai doo baita 'oro ne nia ilia ki. ");
INSERT INTO bvd_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Na konia nai ka baita 'asia naa, lelea sa Disas ka saea naa fuana toa kwairooi nia ki uri daka ade akau 'ana ta kaa baru fuana, uri konia nai ka nao si bebesi nia 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nia 'e guraa sui na mai toaa 'oro ki. Doo ne adea guu, toaa 'oro matai nai daka suumai kera mai siana uri daka samo toi nonina uri kera daka 'akwaa. ");
INSERT INTO bvd_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ma toaa ne anoedoo ta'aa ki burosi kera ki, lelea kera suana boroi kau sa Disas, kera daka 'asi kera daka booruru na 'i saegano 'i maana, daka 'ai na kau 'urii fuana, “'Oe naa ne 'Alakwa nia God!” ");
INSERT INTO bvd_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Sui boroi, sa Disas nia ka luia anoedoo ta'aa nai ki, nao kera dasi faarongoa lau ta waa suli nia. ");
INSERT INTO bvd_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Sui, sa Disas ka raa gwauna fa uo nai, ka 'ailia kau toa nai fua rao lae fainia. Kera daka lea na kau siana, ");
INSERT INTO bvd_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","nia ka filia naa akwala ma roo waa nai ki. Nia ka 'aili kera naa 'ana 'aboosol ki. Ma nia ka bae 'urii fuada, “Nau ku fili kamolu uri molu ka too kwaimani fai nau, ma nau ku odu kamolu fua toolangai lana bae lana God fua toae ki. ");
INSERT INTO bvd_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma ni kamolu, molu kai too 'ana rigitaa fua tari lana anoedoo ta'aa ki.” ");
INSERT INTO bvd_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Iuka, na satana akwala ma roo waa nai ki nia filida ne: sa Saemon (sa Disas faasatanaa 'ana sa Bita), ");
INSERT INTO bvd_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","sa Demes fainia sa Dion roo 'alakwa sa Sebedii ki (ne sa Disas nia 'aili keeru 'ana “Boneges ki” toolangainia waa da 'ali'ali uri rakesasue mala kwakwange ki). ");
INSERT INTO bvd_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Sa 'Andru, sa Filib, sa Baatolomiu, sa Matiu, sa Toomas, sa Demes 'alakwa sa 'Alfias, sa Tadeas, sa Saemon (ta waa 'ana toaa Diu bae kera dooria tari lana toaa 'i Rom fasi 'Israel). ");
INSERT INTO bvd_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ma sa Diudas 'Iskariot waa bae lelea kau ka 'olamae lana sa Disas fua malimae. ");
INSERT INTO bvd_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Sui, sa Disas oli mai ka dao lau guu laona luma bae nia kai dao walude ki ai bae. Ma toaa nai ki daka koni ka 'oro lau gu mai, lelea sa Disas fainia toa kwairooi nia ki ka nao dasi too na 'ana tasi kada fua fanga lae boroi. ");
INSERT INTO bvd_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ma kada toolana ki da rongo nia 'uri nai, kera daka lea kau siana uri oli lae mai fainia uri 'i fera, suli kera rongoa da bae 'urii suli nia, “Nia oewanea 'asia naa wala.” ");
INSERT INTO bvd_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ma tai waa toolangaidoo 'ana taki sa Mosis ne da lea mai fasi 'i Durusalem daka bae 'urii, “Sa Disas nia taria gwana anoedoo ta'aa ki 'ana rigitaa Saetan, na anoedoo gwaungai kera anoedoo ta'aa ki ne.” ");
INSERT INTO bvd_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","'Uri nai, sa Disas ka 'ailia mai toae ki ka bae 'urii fuada 'ana tarifula lae, “Sa Saetan nia 'afitai ka taria lau anoedoo ta'aa ki fasi waa nia ki tala'ana. ");
INSERT INTO bvd_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nia talafana bae, lea toaa lao ta tii maefera baita gwana kera alasi kera daka firu lau gwada 'i tala 'ada, maefera nai kai tagabola 'afitai ka too lau. ");
INSERT INTO bvd_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma lelea ta bara waiwelana da firu lau gwada 'i tala'ada, bara waiwelana nai kai tagabola 'afitai ka too lau. ");
INSERT INTO bvd_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Talafana guu doo ne kai fuli fua sa Saetan nai, lelea nia taria anoedoo ta'aa ki. Na tooa nia kai 'asia ma rigitaa nia kai sui.” ");
INSERT INTO bvd_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Sui, sa Disas ka bae lau guu suli tii tarifulaa, ka 'urii, “Waa ne lea kau ka ruufia beu nia fa ramo ma ka daua, ka kani faafi nia sui ka ngalia 'okodoo nia ki tiifau faasi nia, nia ne 'e tetede ka talua fa ramo nai. Suli, lelea nia nao si tetede guu, nia 'afitai ka ilia si doo nai 'ana waa ramo nai. Talafana lau gu doo ne fuli 'ana tari lana anoedoo ta'aa ki nai. Waa ne taria anoedoo ta'aa ki, nia ne rigitaa ka talua sa Saetan. ");
INSERT INTO bvd_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Si doo mamana nau ku saea fuamolu 'e 'urii, na abulo ta'aa lae ki ma bae ta'aa lae ki sui gwana talea God ne wane 'e ilia, God kai manata lukea gwana. ");
INSERT INTO bvd_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Aia, ma bae ta'aa lae talea Anoedoo Abu gu ne God nia 'afitai ka manata lukea, suli nia ne si abulo ta'aa laa ne totoo si sui.” ");
INSERT INTO bvd_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Sa Disas nia bae 'uri nai, suli na waa toolangaidoo ki 'ana taki, kera saea naa nia 'e too 'ana anoedoo ta'ae. ");
INSERT INTO bvd_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ma 'i burina doo nai ki, gaa nia fai toolana sa Disas ki, kera daka dao naa. Ma daka uu gwada kau 'i maa, daka kwaiodui kau uri sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na toaa 'oro 'asia naa ne kera koni kalia sa Disas. Ma kera daka bae kau 'uri fuana, “Gaa 'oe fai toolamu ki kera da nii maa. Kera da nani uri 'oe.” ");
INSERT INTO bvd_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Sa Disas 'e ledi kera ka 'urii, “Tii kera ne gaa mamana nau ki fai toolaku ki mamana?” ");
INSERT INTO bvd_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","'I seeri nia ka lio kau uri toaa 'oro nai da koni kali nia ka bae 'urii, “Gaa mamana nau ki fai toolaku ki mamana gu ne! ");
INSERT INTO bvd_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Suli, tii gwana ne nia ilia doori lana God, nia 'ana ne toolaku, ma waiwane nau, ma gaa nau.” ");
INSERT INTO bvd_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","'Ana tii si kada lau gu sa Disas nia toolangaidoo 'i ninimana 'osi 'i Galilii, ma toaa 'oro nai ki daka koni lau gu mai siana. Nia ka raa ka gooru mai laona kaa baru nai sui daka 'idu tu'uu kau ai 'i matakwa, ma na konia nai kera daka uu kau 'i sara. ");
INSERT INTO bvd_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ma sa Disas ka toolangainia doo 'oro ki 'ana tarifulaa ki fuada ma ka bae 'urii, ");
INSERT INTO bvd_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Molu fafurongo fasi! Totoo ta tii waa nia lea ka afusia migana wiiti laona ola nia. ");
INSERT INTO bvd_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ma si kada nia afusia migana wiiti nai, tai miga doo daka 'asi kera naa suli taale lao ole. Ma na saaro ki kera daka lofo mai daka 'ani tiifau 'anida. ");
INSERT INTO bvd_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma tai miga doo daka 'asida lao si kula 'e faula, ne si saegano 'e nao si ububua guu. Ma kera daka bulao 'ali'ali gwada, suli si saegano nai 'e nao si ububua. ");
INSERT INTO bvd_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ma kada sato 'e tae mai ka satofia wiiti ne tagwasu ki, kera daka kuku lau gwada, suli lalida nao si koso si lea tau guu. ");
INSERT INTO bvd_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ma tai miga doo lau kera daka 'asida 'i matangana lalano kwakware ki, ma lalano nai ki daka nuku na 'ada faafida, ma kera ka nao dasi fungu naa. ");
INSERT INTO bvd_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Aia ma tai miga doo lau, kera daka 'asida laona si saegano diane. Ma kera daka bulao daka tae diana, ma daka fungu diana. Tai doo, kera daka fungu 'ana olu taafuli fungidoo ki, ma tai doo daka fungu 'ana ono taafuli fungidoo ki, ma tai doo lau kera daka fungu 'ana tii talanga fungidoo ki fatai.” ");
INSERT INTO bvd_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ma 'ana 'isi lana ununua nai sa Disas ka bae 'urii, “'Oe waa ne 'o too gu 'amu 'ana alingamu uri rongo lana doo ki, 'o rongo doo nai ki 'oko rongo diana ai.” ");
INSERT INTO bvd_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Si kada sa Disas nia safa too 'ana taifilia fasi konia bae, na akwala ma roo waa kwairooi nia baki fainia toaa nai da too kwaimani ki lau gu fainia, da lea mai daka dao siana. Ma kera daka ledia uri nia ka faarongo folaa 'ana malutana tarifulaa baki siada. ");
INSERT INTO bvd_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ma nia 'e luu kera ka bae 'urii, “'Ana kada 'i nao, God nao si faatai folaa gu mai 'ana 'inito laa tee ne nia kai ilia fua toaa nia ki. Ma sui 'i tari'ina, nia ka faatai folaa naa 'ana doo nai ki siamolu. Ma sui boroi 'ana, na toaa neki sui gwana 'i sara nia nao si ade gu 'uri nai fuada. Na toaa neki sui gwana 'i sara, nau kwai bae gwaku 'ana tarifulaa ki fuada, ");
INSERT INTO bvd_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","uri ‘Kera daka lilio, ma daka lilio boroi, 'afitai kera daka liotoi guu si doo ne God nia ilia fuada. Ma kera daka gwalinge, ma daka gwalinge boroi, 'afitai kera daka filoa guu si doo ne God 'e faarongo kera ai. Suli ade lea kera liotoi, ma daka filoa, ma daka bulasi mai talea God, ma nia ka manata lukea abulo ta'aa laa kera ki.’” ");
INSERT INTO bvd_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","'Uri nai sa Disas ka ledi 'urii ada, “Kamolu, nao molu si filoa guu malutana tarifulaa nee nai? Lelea nao molu si filoa guu malutana tarifulaa nee 'urii, ma nia 'afitai uri molu ka filoa malutana tarifulaa ki nai! ");
INSERT INTO bvd_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Na waa bae nia afusia miga doo baki lao ole, nia talafana waa ni afusi lana bae lana God naa bae. ");
INSERT INTO bvd_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ma na toaa neki kera da rongoa bae lana God, kera mala 'ada si kada miga doo ni fasi lana ki da 'asida suli taale lao ole. Suli si kada kera da rongoa 'ua gu si baea nai, sa Saetan nia lea mai ka laua lau gwana bae lana God faasi kera. ");
INSERT INTO bvd_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ma ta bali toaa lau guu kera daka mala gwada si kada tai miga wiiti da 'asida laona si kula 'e faula. Si kada kera da rongoa bae lana God, kera 'ali'ali daka ngalia, ma daka noni sasala 'asia na sulia. ");
INSERT INTO bvd_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ma sui ta, bae lana God 'e nao si lea koso guu laona mauri lada. Nia ne fiitooa kera ki ka mauri gwana sulia si kada kukuru. Ma si kada kera dao toi 'afitaie ma nonifiie ki faafia si faarongoa diana nai, kera 'ali'ali daka luka na 'ada 'ana bae lana God. ");
INSERT INTO bvd_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ma ta bali 'ana toae lau guu, kera daka mala 'ada si kada miga wiiti ki da 'asida 'i matangana lalano kwakware ki. Kera da rongoa guu bae lana God, ");
INSERT INTO bvd_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ma sui manata lada ka 'abarua 'ana sulia doo ki lao tooa kera ki ma suli malefo. Ma doo nai ki ka mala 'ana lalano kwakware ki ne da buru faafia bae lana God lao mangoda ma ka nao dasi tatala guu, ma daka ulu'atoa gwada. ");
INSERT INTO bvd_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma ta bali 'ana toae lau guu kera daka mala 'ana si kada miga wiiti ki da 'asida laona si saegano diane. Kera da rongoa bae lana God daka roo na sulia, ma kera daka faatainia tooa 'o'olo, daka mala 'ana si kada wiiti nia fungu diana. Ne tai wiiti 'ani kera daka fungu 'ana olu taafuli fungidoo ki, ma tai doo, ono taafuli fungidoo ki, ma tai doo lau, tii talanga fungidoo ki.” ");
INSERT INTO bvd_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","'Uri nai guu sa Disas ka bae lau 'urii fuada, “Na laet, lea kera dao fainia, 'afitai daka saufinia lau farana ta kufidoo ma nao farana ifitai. Kera dai faagoorungainia ka tio folaa naa fulina 'i langi. ");
INSERT INTO bvd_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Doo ne adea guu, doo neki da tio saufini ki totoo dai tio folaa, ma doo tio agwa ki totoo dai tio faatai. ");
INSERT INTO bvd_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","'Oe waa ne 'o too 'ana alingamu uri rongo lana doo ki, 'o rongo doo nai ki 'oko rongo diana ai.” ");
INSERT INTO bvd_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ma sa Disas ka bae lau 'urii fuada, “Molu ka manata diana suli doo ne molu rongoa ki. God kai fale tatakwai 'ana liotoo lae fuamolu, lelea kamolu roo sulia na doo neki nau ku toolangainida siamolu. ");
INSERT INTO bvd_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Waa ne dao toi sui naa tasi folaa laa tu'uu suli 'initoaa God, God kai lado gwauna lau fuana. Aia, ma waa ne nao si roo sulia na doo neki nau ku toolangainida siana, sui boroi 'ana ta kasi folaa laa tu'uu suli 'initoaa God ne nia too ai, God kai olitainia gwana faasia.” ");
INSERT INTO bvd_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sa Disas ka bae lau gu 'urii fuada, “Na 'initoaa God nia rao mala migana doo ni fasi lana ki ne tii waa 'e afusia lao ola nia. ");
INSERT INTO bvd_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Si kada burina nia afusia ka sui, nia maleu ki 'ana 'afa rodo ki ma lelea dani mai nia lea ka liliu lau gwana. Nia ka nao si filoa lau gwana malutana na migana doo nai ki da bulao daka tae mai 'utaa. Ma sui boroi 'ana kera daka tala tae gwada 'i tala'ada. ");
INSERT INTO bvd_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Na saegano 'ana ne falea mauria fua migana doo nai ki lelea daka baita, ma daka fungu 'ana fungidoo ki. Na 'initodoe ki kera safali tae fasi mai 'i nao, sui guu na 'abada ki. Sui guu, na takadoe ki daka olongai. Sui guu, daka fufuala naa. Ma ka lea na 'uri nai suli, lelea daka maua. ");
INSERT INTO bvd_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ma si kada fungina doo nai ki kera maua guu, sa wala nai 'ali'ali lea ka sikilia naa fungidoe ki, suli 'e dao naa 'ana si kada da maua fua daka falia ki.” ");
INSERT INTO bvd_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sa Disas ka bae lau gu 'urii, “Tii si doo kolu kai saea 'e rao lau guu mala rao lana 'initoaa God, ma nao tii si tarifulaa uri kolu ka faabolatainia lau guu sulia rao lana 'initoaa God, nau kwai unu kau sulia. ");
INSERT INTO bvd_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nia 'e rao 'ana mala migana mastad. Migana mastad 'e tu'uu 'isi ka talua migana doo ni fasi lana ki ne waa ki fasia lao saegano. ");
INSERT INTO bvd_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Sui boroi 'ana, kada kera da fasia miga doo nai, nia ka tae lelea ka alua 'ai baita ne talua sui guu doo neki da fasia ka tae ki lao ole. Ma na sarana ki daka baita, daka bobola fainia lea doo saaro 'i mamangaa ki boroi daka saungainia gwada na 'oikakada kera ki gwauna.” ");
INSERT INTO bvd_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Sa Disas ka bae fuana toaa nai 'ana tarifulaa 'oro ki 'uri nai lau guu 'ana sae lana doo neki bobola fainia kera daka saitomana ki. ");
INSERT INTO bvd_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ma nia ka bae sui gu fuada 'ana tarifulaa ki. Ma sui, si kada nia fai toa kwairooi nia ki da too 'ada taifili kera, nia ka bae folaa gwana sulia doo nai ki fuada tasi doo si ore naa. ");
INSERT INTO bvd_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nia saulafia naa 'ana fa dani nai, sa Disas nia ka bae 'urii fuana toa kwairooi nia ki, “Kolu toofolo 'akolu uria bali 'osi lobae.” ");
INSERT INTO bvd_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kera daka faasia na konia nai 'i seeri, ma daka lea na fainia sa Disas lao baru nai. Tai baru ki lau guu da dau gwada 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ma na koburu baita nai ka tatae, na nanafo ka magara fua lao baru nai, ma karangi kai kuruu naa. ");
INSERT INTO bvd_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ma sa Disas, nia tio ka boogwau 'ana bilo nai ka maleu gwana 'i burina kau baru nai. Ma na toa kwairooi nia ki daka faa adaa, ma kera daka bae 'urii, “Aofia 'ae, 'oe doo nao si 'oga 'oe gu 'ua nee wala. Kolu karangi mae ne!” ");
INSERT INTO bvd_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ma sa Disas ka tatae, ma ka ngatafia na koburu nai ka 'urii, “'O enoeno 'amu!” Ma nia ka bae lau gu 'urii fuana nanafo nai, “'O enoeno 'amu!” 'Uri nai guu, na koburu nai ka enoeno naa, ma ka folaa naa fua lao 'osi nai. ");
INSERT INTO bvd_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ma nia ka bae 'urii fuana toa kwairooi nia ki, “Tee ne adea molu ka mau? Nau ku liotoi na fiitooa kamolu 'ani nau 'e tu'uu gwana.” ");
INSERT INTO bvd_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ma kera daka mau ka ta'aa naa, ma daka ledi kera kwailiu daka 'urii, “Waa tee naa nee rowane? Tee na koburu fainia nanafo nee boroi ma daka ade gwada sulia bae lana!” ");
INSERT INTO bvd_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Sa Disas fainia toa kwairooi nia ki, da toofolo 'ana 'osi 'i Galilii, daka dao 'ana bali 'osi 'ana lolofaa 'i Gerasa. ");
INSERT INTO bvd_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ma si kada sa Disas nia koso fasi baru, tii waa nai anoedoo ta'aa 'e burosia ma ka too mai lao likwafau ni alu wane mae lae ki ka lea mai siana. ");
INSERT INTO bvd_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Waa nai, 'e too gwana lao likwafau nai ki, ka nao ta waa ne bobola fainia ka kani nia 'ana ta seni ngasi boroi. ");
INSERT INTO bvd_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","'Ana kada 'oro, kera da kani faafia boroi 'abana fainia 'aena ki 'ana seni ngasi ki, nia ka muusida gwana. Ma ka muusia gwana seni da kania 'ana 'aena ki. Ma ka nao ta waa si bobola na fai dau lana. ");
INSERT INTO bvd_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ma nia ka dau gwana 'ana liu lae matangana likwafau ni alu wane mae nai ki ma 'obaraoa nai ki, ma ka dau gwana 'ana furi maala lae 'ana nonina 'i tala'ana ma kokoo tikwa lae uri rodo ma dani. ");
INSERT INTO bvd_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ma si kada nia dao tau gwana mai ka suana mai sa Disas, nia lae 'ali'ali mai dao ka booruru naa 'i maa 'aena. ");
INSERT INTO bvd_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ma sa Disas ka bae 'urii fuana, “'Oe anoedoo ta'aa nee, 'o lea 'amu fasi sa wala nee.” Nia ka kokoo baita ka bae 'urii, “Disas, 'Alakwa nia God ne baita 'ana doo ki sui. Tee ne 'oe doori ilia 'ani nau? Nau ku amasi 'oe 'ana satana God, nao 'osi falea lau kwakwaea fuaku!” ");
INSERT INTO bvd_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sui sa Disas ka ledia ka 'urii, “Satamu sa tii?” Ma nia luua ka 'urii, “Sa Omea baita, suli meli 'oro 'asia naa.” ");
INSERT INTO bvd_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma na anoedoo ta'aa nai ka radi kali sa Disas fua nao si odu nia lau fasi bali lolofaa nai. ");
INSERT INTO bvd_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ma na ferae boso fualangaa nai da fanga gwada babarana 'obaraoa nai 'i seeri 'ana si kada nai lau guu. ");
INSERT INTO bvd_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ma na anoedoo ta'aa nai ki, daka radi kali sa Disas daka 'urii, “'O odu kameli 'amu uri lao boso loko ki.” ");
INSERT INTO bvd_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ma sa Disas ka faolomainida, ma na anoedoo ta'aa nai ki daka lea 'i maa fasi waa nai, ma daka lea laona talae boso nai sui guu. Ma na ferae boso nai, na roo tooni boso ki fatai, kera daka lae 'ali'ali naa suli 'obaraoa nai daka lofo lao 'osi nai, ma daka kuu daka mae naa. ");
INSERT INTO bvd_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Toaa ne da sangonia boso nai ki, kera daka lae 'ali'ali naa uri fera ma lao si bali lolofaa nai sui gwana uri faarongo lae 'ana si doo nai. Ma na toaa 'oro nai ki daka lea na mai uri suai lae doo nai 'e fuli nai. ");
INSERT INTO bvd_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ma si kada kera dao daka suana sa Disas, kera daka suana lau gu waa bae anoedoo ta'aa 'oro baki da burosia mai 'e nii gwana 'i seeri, ma ka manataa ka ofi naa. Ma na toaa nai daka mau lau gwada, ma daka kwele 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ma na toaa ne kera suana si doo nai 'e fuli mai, kera daka unu sulia waa nai anoedoo ta'aa burosia mai nai fua toaa nai ki. Ma kera daka unu lau gu sulia si doo ne fuli 'ana boso nai ki. ");
INSERT INTO bvd_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ma burina, toaa nai daka odua sa Disas uri ka lea 'ana fasi bali lolofaa nai. ");
INSERT INTO bvd_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ma kada sa Disas nia raa naa laona baru, na waa bae anoedoo ta'aa baki da burosia bae, ka radi kali naa sa Disas uri ka lea na 'ana fainia. ");
INSERT INTO bvd_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ma sui sa Disas ka nao si faolomainia, ma ka bae 'ana 'urii fuana, “'Oe oli siana toaa 'oe 'i fera kamu, 'oko faarongo kera tiifau 'ana si doo diana neki God nia ilia mai fuamu, ne nia 'e faatainia na kwai'ofeia baita nia fuamu.” ");
INSERT INTO bvd_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ma sa wala nai ka oli 'i fera kera, ka faarongoa toae ki sui gwana 'ana bali lolofaa nai 'i Dikabolis 'ana doo baita nai sa Disas ilia fuana. Ma na toaa nai ki daka kwele 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sa Disas nia toofolo uria ta bali 'osi lau. Ma si kada nia dao 'ana bali nai, toaa 'oro nai daka koni na mai kali nia. ");
INSERT INTO bvd_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ma tii waa ne dao lau guu laona konia nai, satana sa Daeras. Sa Daeras, nia na waa gwaungai 'ana beu ni ofu laa kera 'i seeri. Ma si kada 'e dao ka suana sa Disas, nia ka booruru 'i maana 'aena, ");
INSERT INTO bvd_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ka amasia ka bae 'urii, “Kaa saari nau 'e nao si diana naa ka tio na uri mae lana. 'Oe lea fasi mai, 'oko alu 'aba faafia, uri ka 'akwaa ma ka mauri 'ana.” ");
INSERT INTO bvd_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Sa Disas ka lea na fainia. Ma na konia baita nai kera daka lea lau gu 'i burina, ma daka 'oro daka kwaisangirii guu. ");
INSERT INTO bvd_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ma 'uri nai, tii 'initai nai 'abusure saungi nia mai suli tii taafuli fa ngali ma roo fa ngali sarenga ki ka sui naa, ka nii lau guu 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nia 'e nonifii 'asia naa ma ka faafunuia sui na mai malefo nia ki fua waa kwai gurai 'oro, ma sui too lana ka nao si diana guu, ma doo nai ka ta'aa ka tetede na faafi nia. ");
INSERT INTO bvd_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ma si kada nia rongoa da bae suli sa Disas, nia ka kali mai 'i burina lao 'oroa nai, ka samo toi si kula 'ana maku tikwa nia nai. ");
INSERT INTO bvd_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Manata lana wela keni nai 'e 'urii, “Nau saku samo toi boroi 'aku maku nia loko, nau ku 'akwaa naa ne.” ");
INSERT INTO bvd_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ma si kada nia samo toi maku sa Disas, 'ali'ali 'ua guu na 'abusura nai ka lalanga naa. Ma nia ka toomatafana mataia nia 'e sui naa. ");
INSERT INTO bvd_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ma si kada nai 'ua guu, sa Disas ka toomatafana lau guu tetedea nia fua guraa lana mataia ki 'e lea kau faasi nia. Ma nia ka abulo ka ledi 'urii matangana konia nai, “Tii bae samo tona kau maku nau?” ");
INSERT INTO bvd_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Na toa kwairooi nia ki da luu nia daka 'urii, “Tee 'oe liotoi gwamu toaa 'oro ne da beresi 'oe nee! Doo 'o ledi boroi suli waa ne samotomu ma 'afitai 'oko dao tona naa ne!” ");
INSERT INTO bvd_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Sui boroi sa Disas ka lio kwailiu gwana uri sua lana tii bae dau tona kau. ");
INSERT INTO bvd_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Aia, ma wela keni bae nia 'e saitomana si doo bae fuli 'ani nia, ma nia ka mau lau gwana ma ka fali lelebe mai ka booruru naa 'i maa 'aena sa Disas. Ma nia ka faarongoa naa 'ana si doo nai nia ilia nai. ");
INSERT INTO bvd_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ma sa Disas ka bae 'urii fuana, “Wela keni nee 'ae, ni 'oe 'o 'akwaa naa nai, suli na faamamane laa 'oe. Manata lamu ka enoeno 'ana, oli 'oko lea 'amu. Ma 'oko 'akwaa naa ka oli 'alaa fasi mataia 'oe nee.” ");
INSERT INTO bvd_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ma kada sa Disas nia bae 'ua gwana 'uri nai, tai waa da too mai luma sa Daeras, daka dao lau gu mai, ma kera daka bae 'urii fua sa Daeras, “Saari 'oe nia mae na mai. Nao 'osi faa 'abaruaa gwamu waa ni toolangaidoo.” ");
INSERT INTO bvd_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ma sa Disas ka faia si baea nai toa nai da saea, nia ka bae 'ana 'urii fua sa Daeras, “Nao 'osi mau lau. 'O faamamane nau 'amu.” ");
INSERT INTO bvd_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ma sa Disas ka talaia guu taifilia sa Bita, sa Demes, ma sa Dion daka lea fainia. Ma ka nao si faolomainia ta waa lau kau uri lea lae fainia. ");
INSERT INTO bvd_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Si kada kera dao 'i luma sa Daeras, sa Disas ka rongoa gwela angiangia ma na alifeo laa baita tasa nai. ");
INSERT INTO bvd_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ma nia ka ruu kau, ka bae 'urii fuada, “Tee ne adea molu angi molu ka isisigwau na 'urii? Wela nee nao si mae lau ne, nia 'e maleu gwana ne.” ");
INSERT INTO bvd_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ma kera daka waela 'ada 'ana sa Disas. Sui sa Disas ka odua toaa nai tiifau daka lea na 'i maa, ma nia ka talaia kau maa nia fai gaa nia wela keni nai, ma na toa kwairooi nia ki daka lea kwaimani lau gu kau fainia 'i luma, kula wela keni nai 'e nii ai. ");
INSERT INTO bvd_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ma nia ka rao 'uri 'abana wela keni nai, ma ka bae 'urii fuana, “Talita kom!” Toolangai lana 'urii, “Kaa saari nee 'ae, ku saea fuamu, 'o tatae 'i langi!” ");
INSERT INTO bvd_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ma 'ana si kada nai 'ua guu kaa wela keni nai ka tatae ka uu, ma ka fali na kau. Na wela keni nai 'e baita ka dao naa 'ana tii taafuli fa ngali ma roo fa ngali sarenga ki. Ma toaa nai ki daka kwele 'asia naa 'ana doo nai. ");
INSERT INTO bvd_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ma sui, sa Disas ka lui fifii ai, uri nao kera dasi faarongoa lau ta waa 'ana si doo nai. Sui, sa Disas ka saea naa kera daka faa 'ana tasi fanga ka 'ani. ");
INSERT INTO bvd_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Sa Disas fainia toa kwairooi nia ki kera faasia 'i seeri, daka lea lau uri maefera nia bae 'ua guu 'i Naasaret. ");
INSERT INTO bvd_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kera too lelea ka dao naa 'afa dani Sabat, nia ka safali toolangaidoo naa laona beu ni ofu laa kera nai. Ma toaa 'oro nai da fafurongo nia, kera daka kwele 'asia naa 'ani nia. Ma daka ledi 'urii, “Rigitaa sa tii faa fatai 'ana fua sa wala nee ne nia toolangaidoo ai ma ka ilia 'ana doo kwaibalatana neki nee? ");
INSERT INTO bvd_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Sa wala nee, waa bae kolu saitoma diana gwakolu 'ani nia ne. Tee sa nia kaa waa bae ni saungai luma gwana nee! Gaa nia gu ne ni Meri nee. Ma nia toolana sa Demes, ma sa Diosef, ma sa Diudas, ma sa Saemon gwana ne. Waiwane nia ki gu ne kolu too kwaimani gwakolu 'i seki nee!” Si manata laa nai 'e adea kera daka ote kera manata fifii gu 'ani nia. ");
INSERT INTO bvd_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ma sa Disas ka bae 'urii fuada, “Na waa ne brofet, toaa 'ana maefera 'e'ete neki da sae'inito 'ani nia lelea ka sui, taifilia toaa 'ana maefera nia tala'ana gu ne 'afitai daka manata fifii gu 'ani nia.” ");
INSERT INTO bvd_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ma ka nao si bobola na fua sa Disas uri ka ilia lau tai doo kwaibalatana 'oro 'i seeri. Si doo nia ilia gwana ne nia alu 'aba faafia ta bara waa 'ana toaa da matai ki ma nia ka faa 'akwaa kera. ");
INSERT INTO bvd_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ma nia ka kwele 'asia naa 'ani kera ne nao dasi manata faamamane. 'Uri nai sa Disas nia ka lea 'ana maefera ki kakalia 'i seeri, ma ka toolangaidoo fuana wane ki. ");
INSERT INTO bvd_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nia ka 'ai uria na akwala ma roo wane 'ana waa kwairooi nia ki siana, ma nia ka falea naa rigitaa fuada uri tari lana na anoedoo ta'aa ki, ma ka odu kera tiifau daka lea too roo waa. ");
INSERT INTO bvd_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ma sa Disas ka bae fifii fuada ka 'urii, “Nao kamolu si ngalia ta doo fai kamolu 'ana leaa nee, taifilia fa kubau guu ne molu kai dau ai. Ma ka nao molu si ngali fanga lau, ma ta wai, ma ta malefo. ");
INSERT INTO bvd_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Molu ka ruufia na sadol ki, sui ta nao molu si ngali roo si maku lau. ");
INSERT INTO bvd_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ma lea ta waa nia talai kamolu 'i luma nia, molu ka too fainia lelea ka dao 'ana kada kamolu faasia luma nai. ");
INSERT INTO bvd_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma lea kamolu dao 'ana ta maefera, ma na toaa 'i seeri ka nao dasi talai kamolu 'i fera, ma kera dasi dooria guu rongo lamolu, molu ka lea 'amolu faasida. Ma molu ka usua lolo 'ana saegano fasi 'aemolu uri 'u'uirodo lae fuada ne God kai kwae kera, suli kera ote kera 'ana rongo lana bae lana God.” ");
INSERT INTO bvd_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ma kera daka lea, ma daka faatalongainia naa faarongoa diana nee fuana toae ki uri daka bulasi manataa. ");
INSERT INTO bvd_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ma kera daka taria naa anoedoo ta'aa 'oro ki, ma daka gwaia naa toaa matai 'oro ki 'ana gwai 'ana gura lada. ");
INSERT INTO bvd_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Iuka, sa Herod na waa 'inito, nia 'e rongoa ununua 'oro sulia sa Disas ne nia toolangaidoo ma ka guraa toaa 'oro. Ma sa Disas, satana ka talo lao maefera nai ki sui guu. Ma toae ki daka saea, “'Oo sa Dion waa ni faasiuabu bae loko nia tatae lau fasi maea, ma ka ilia naa doo kwaibalatana 'oro ki!” ");
INSERT INTO bvd_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ma tai toaa ki daka bae lau gu 'urii, “Sa 'Ilaeja naa loko!” Ma tai toaa ki lau kera daka bae 'ada 'urii, “Nia ta brofet loko, mala brofet baki mai nao!” ");
INSERT INTO bvd_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Si kada sa Herod nia rongoa doo nai ki toae ki da saea sulia sa Disas, nia ka bae 'urii, “Sa Dion waa bae ku siki muusia sui na gwauna, nia 'ua ne tatae lau faasia maea nai!” ");
INSERT INTO bvd_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Sa Herod nia adea lau gwana ni Herodias, na baraa nia, na 'afe sa Filib. Ma sa Dion ka bae 'urii fua sa Herod, “Na taki God nia luia 'oe 'osi adea 'afe toolamu.” 'Uri nai, ni Herodias liona ka ta'aa 'asia naa fua sa Dion, ka dooria saungi lana lae, sui boroi ma ka 'afitai, suli sa Herod nia saitomana sa Dion nia na waa 'o'olo, ma waa abu. Ma sa Herod nia ka maungia lau gwana sa Dion, ma ka suasuli nia ka too gwana. Sulia sa Herod tala'ana 'ua gu ne nia odua waa ki 'i nao, uri dau lana sa Dion ma kera daka alu nia ka too 'ana laona lookafo fasi ni Herodias. Sa Herod, nia doori fafurongoa bae lana sa Dion, ma sui ka manata ruarua lau gwana. ");
INSERT INTO bvd_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","'Uri nai guu, ni Herodias ka dao tona naa tii si kada diana nia fua saungi lana sa Dion. 'Ana fa dani ni futa nia sa Herod nia ka saungainia fafangaa fuana toa baita nia ki 'ana omee, ma toa gwaungai ki ne kera too 'i laona bali lolofaa 'i Galilii. ");
INSERT INTO bvd_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ma kada ne, saari ni Herodias nia ruu mai ma ka wae, sa Herod fainia na toaa nia ki ne kera fanga kwaimani, kera daka ele 'asia naa sulia. Ma sa Herod ka bae 'urii fuana saari nai, “Tasi tee gwana ne 'oe gani nau uria lao 'initoaa nee, nau kwai falea fuamu.” ");
INSERT INTO bvd_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma nia ka bae alangai ka bae 'urii, “Tasi tee ne 'oe 'o gania siaku, sui boroi 'ana lea sa ta bali 'ana 'initoaa nee, nau kwai falea fuamu.” ");
INSERT INTO bvd_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ma na saari nai ka ruu kau 'i maa ka lea naa siana gaa nia, ka ledia ka 'urii, “Ta tee ne 'oe dooria nau kwai gania?” Ma gaa nia ka luua ka 'urii, “'O gania mai gwauna sa Dion waa ni faasiuabu bae.” ");
INSERT INTO bvd_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ma na saari nai ka oli 'ali'ali siana sa Herod, ma ka gani ka 'urii, “Nau ku dooria 'oe falea mai na gwauna sa Dion waa ni faasiuabu fuaku 'i fafona ta reba doo 'asi kada nai 'ua guu.” ");
INSERT INTO bvd_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ma sa Herod liona ka dila 'asia naa sulia si doo nai. Sui boroi 'ana, suli na bae alangaia nia ilia naa 'i maana toae, nia 'afitai ka luia naa faasia. ");
INSERT INTO bvd_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ma nia ka odua tii waa ni fofolo fua ngali lana mai gwauna sa Dion. Ma na waa nai ka lea 'i laona lookafo, ma ka sigimuusia naa luana sa Dion, ");
INSERT INTO bvd_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ka ngalia mai gwauna 'i fafona reba doo tiutiua, ka falea naa fuana saari nai. Ma nia ka ngali ka falea naa fuana gaa nia. ");
INSERT INTO bvd_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ma kada ne waa kwairooi sa Dion ki kera rongoa si doo nai, kera lea mai daka ngalia naa nonina, lea daka saufinia naa. ");
INSERT INTO bvd_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Na 'aboosol ki kera daka oli na mai, ma daka koni tiifau mai siana sa Disas, ma kera daka faarongoa 'ana doo neki kera ilia ki mai, ma doo neki kera toolangaidoo sulia ki mai. ");
INSERT INTO bvd_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Sa Disas fainia toa kwairooi nia ki, kera daka 'abarua 'asia naa, suli toaa 'oro nai ki kera dao ma daka oli naa uri kula nai kera too ai. Ma sa Disas fainia toa kwairooi nia ki, ka nao dasi too naa 'ana ta kada fua fanga lae boroi. Ma sa Disas ka bae 'urii fuada, “Molu lea mai kolu lea 'akolu uria tasi kula banitai, uri kolu ka momola fasi 'akolu.” ");
INSERT INTO bvd_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ma kera daka lea naa taifili kera 'ana baru uria si kula aroaro nai. ");
INSERT INTO bvd_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ka 'uri nai boroi 'ana, na toaa 'oro ki faasia na maefere ki tiifau kera ka lio saitomada gwada, ma daka fita naa 'i nao 'ani kera, ma daka eta dao 'ada 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ma kada sa Disas nia koso faasia na baru, nia ka liotoi na konia baita nai, ma nia ka manatai kera 'asia naa, suli kera ilingia naa sifsif ki ne nao ta waa ni sua lae sulida. Ma nia ka toolangainia naa si doo 'e 'oro siada. ");
INSERT INTO bvd_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ma si kada na sato nia tio folo naa, waa kwairooi nia ki kera daka lea mai siana, ma daka bae 'urii, “Kula nee nao ta waa si too gu ai ne, ma sato boroi ka tio folo naa. ");
INSERT INTO bvd_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","'Oe odua toaa nee kera lea daka foli fanga 'ada 'ana maefera loko ki.” ");
INSERT INTO bvd_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Boroi ma nia luu kera ka 'urii, “Kamolu gu ne molu kai fale 'ada tasi fanga.” Ma kera daka ledi 'urii 'ani nia, “'Uri nai ma 'oe 'o dooria kameli kai falea mai malefo 'oro ki fuana foli lana beret uri kai bobola fainia saare lana figue nee?” ");
INSERT INTO bvd_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ma sa Disas ka ledi kera ka bae 'urii, “Ta fita fa beret ne kamolu too ai? Lea kau molu suai fasi.” Ma kada kera da suai sui, kera daka bae 'urii, “Na lima fa beret fai roo gwa sakwari ki gu ne.” ");
INSERT INTO bvd_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","'Uri nai sa Disas ka saea fuana waa kwairooi nia ki uri kera ka saea fuana toae ki daka gooru 'i saegano 'ana 'aebara ki 'i fafona gras mamarakwaa nai. ");
INSERT INTO bvd_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ma kera ka gooru 'i saegano 'ana talangee wane ki ma tai 'aebara na lima akwala ki. ");
INSERT INTO bvd_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ma sa Disas ka ngalia na lima fa beret nai ki ma roo gwa sakwari nai ki, ma ka lio 'alaa uria 'i langi, ma ka tangoa God. Ma nia ka niia fa beret nai ki, ma ka falea fuana waa kwairooi nia ki, fasi uri kera ka tolingia fuana toaa nai. Ma nia ka tolingia lau guu na roo gwa sakwari nai ki fuada. ");
INSERT INTO bvd_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ma na toaa 'oro nai ki kera daka fanga, ma daka abusu tiifau naa. ");
INSERT INTO bvd_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","'Uri guu, na toa kwairooi nia ki kera daka konia naa orengana beret ma na sakwari nai ki, ma kera daka faafungua tii taafuli kukudu ma roo kukudu sarenga ki. ");
INSERT INTO bvd_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na lima tooni wane ki ne kera fanga. ");
INSERT INTO bvd_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ma 'i burina si doo nai, sa Disas nia ka odua toa kwairooi nia ki kera daka eta na 'i nao uria ta bali 'ana 'osi nai laona baru uria maefera 'i Betsaeda. Ma nia ka 'aruburi uri ka olitainia konia nai ma ka alualu 'ani kera. ");
INSERT INTO bvd_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ma 'i burina nia alualu 'ani kera ka sui, nia ka lea naa 'i gwauna tii fa uo nai uri ka foa 'ana. ");
INSERT INTO bvd_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ma 'i saulafi rodo naa, na baru bae lea ka nii naa laona tofungana gwa 'osi bae, ma sa Disas ka too 'ua gwana kau taifilia 'i sara. ");
INSERT INTO bvd_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ma nia ka liotoi na toa kwairooi nia ki, kera ulafu 'asia naa 'ana faluta lae, suli kera naofia naa koburu. Ma 'ana si kada rodo 'i 'uubongi, sa Disas ka talau fafona kafo ka lea na kau siada. Si kada nia lea kau karangi kai talu kera naa, ");
INSERT INTO bvd_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","kera daka suana nia talau kau fafona kafo, kera daka saea nia ta akalo. Ma kera daka akwa baita, ");
INSERT INTO bvd_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","suli kera da mau 'asia naa si kada kera liotoi nia talau kau fafona kafo. Ma sa Disas nia 'e 'ali'ali ma ka bae kau fuada ka 'urii, “Nau gwana ne! Nao molu si mau lau.” ");
INSERT INTO bvd_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","'Uri nai guu, nia ka raa 'i laona baru fai kera, ma na koburu ka aroaro naa. Ma kera daka kwele 'asia naa, ");
INSERT INTO bvd_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","suli nao kera dasi saitomana filo lana rigitaa sa Disas nia too ai fua saare lana lima tooni wane baki 'ana lima fa beret ki guu. Suli manata lada 'e sadi ka nao dasi filoa doo ne kera liotoi. ");
INSERT INTO bvd_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kera da toofolo 'ana 'osi nai, daka koso 'ana bali fera 'i Genesaret, ma kera daka gwalua na baru 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ma si kada kera faasia na baru, na toaa 'i seeri ki, kera 'ali'ali daka lio saitomana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ma na toae ki kera daka fita lao matangana bali fera nai, ma kera daka ngalia mai na toaa matai ki 'i fafona gwegele ki uri kula ki ne kera rongoa sa Disas nia kai nii ki ai. ");
INSERT INTO bvd_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ma maefere ki tiifau ne sa Disas nia lea uria, na toae ki kera da ngalia mai na toaa matai ki uria lao usie ki, ma kera daka ledia sa Disas uri wane matai ki kera daka samo tona tatagwarana maku tikwa nia. Ma na toaa neki tiifau kera samo tona, kera daka 'akwaa. ");
INSERT INTO bvd_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Na Faarisii ki ma tai waa toolangaidoo 'ana taki ki, kera da lea mai faasia 'i Durusalem, ma daka koni kalia sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ma kera daka liotoi tai waa 'ana waa kwairooi nia ki nao dasi taufia guu 'abada 'i nao, sui fatai kera dafi fanga. Nao kera dasi taufia gu 'abada 'uria ne birangaa ne Faarisii ki kera da saea fuana toaa Diu ki kera kai ili sulia. ");
INSERT INTO bvd_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Aia, na Diu ki ma na Faarisii ki lau guu, kera ili suli birangaa ne kokoo kera ki mai 'i nao da toolangaidoo mai sulia. Nia 'afitai kera daka fanga 'ua lea nao kera dasi taufia 'abada sulia birangaa ni tau 'aba lae. ");
INSERT INTO bvd_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ma kada kera oli mai fasi maa usie ki, kera 'afitai daka fanga 'ua lea kera nao dasi tau 'aba 'ua suli birangaa kera ki. Kera daka ade suli birangaa 'oro kera ki 'uri nai 'ana taufi lana kwade doo ni fanga ki, ma na tini ki, ma na tiu ki. ");
INSERT INTO bvd_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","'Uri nai, na Faarisii ki ma na toa toolangaidoo ki 'ana taki, kera daka ledia sa Disas daka 'urii, “'Urifita ne waa kwairooi 'oe ki ka nao dasi roo gu suli na toolangaidoo laa ne kokoo kera ki 'i nao da alua mai fuaka, ma ka nao dasi tau 'aba guu sui dafi fanga?” ");
INSERT INTO bvd_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ma nia 'e luu kera ka bae 'urii, “Sa 'Aesaea nia bae mamana kada bae nia bae suli kamolu. Kamolu na toaa susuke nee, mala bae nia kedaa ka 'urii, ‘God nia saea, na toaa nee, kera faabaita nau gwada 'ana bae lada, ma sui manatada ka nii tau 'ana faasi nau. ");
INSERT INTO bvd_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kera tako foosilaku gwada, suli kera da toolangaidoo 'ada suli taki kera ki tala'ada!’ ");
INSERT INTO bvd_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Kamolu molu lukasia si baea fifii God ki daka too 'ada, molu ka roo 'amolu suli toolangaidoo laa wane gwana.” ");
INSERT INTO bvd_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ma sa Disas ka bae lau gu 'urii fuada, “Kamolu saitoma diana 'asia naa 'ana bulasi garo lae 'ana si bae fifii God ki, uri molu ka roo 'amolu suli birangaa kamolu ki mai. ");
INSERT INTO bvd_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Suli sa Mosis nia bae ka 'urii bae, ‘'O faa'initoaa maa 'oe, fai gaa 'oe.’ Ma ‘Waa ne surafia maa nia ma nao gaa nia, daka saungia ka mae 'ana.’ ");
INSERT INTO bvd_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ma sui, kamolu ka toolangaidoo garo 'amolu 'urii, molu ka saea lelea waa ka too boroi 'ana si doo uri ka 'adomia 'ana maa nia fai gaa nia, lelea nia bae 'ana 'urii sulia, ‘Si doo nee, nau kwai faa naku fua God.’ ");
INSERT INTO bvd_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kamolu ka saea 'amolu 'e diana gwana fua nia ka nao si 'adomia lau maa nia fai gaa nia, suli 'e alangai kai faa lau 'ana fua God. ");
INSERT INTO bvd_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Si ade laa nai kamolu ilia nai, kamolu molu tafoa 'amolu birangaa kamolu mai, aia bae lana God, molu ka taga na 'amolu ai. Ma molu ka ilia lau guu tai doo ta'aa 'oro uri nai ki.” ");
INSERT INTO bvd_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sui lau guu, sa Disas ka 'ailia mai konia nai siana ka bae 'urii fuada, “Molu fafurongo nau mai, molu ka saitomana fasi. ");
INSERT INTO bvd_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Si doo ne 'ita kau 'i sara ma wane ka 'ani ka lea kau fua lao ruruuna, nia 'afitai ka faasuaa wane. Si doo ne 'ita mai lao liona wane lau 'ana ne kai faasua nia.” ");
INSERT INTO bvd_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ma si kada sa Disas 'e faasia konia nai, ka ruu kau 'i luma nai, na toa kwairooi nia ki kera daka ledia uri nia ka 'inifitaa malutana si baea nai fuada. ");
INSERT INTO bvd_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ma nia ka bae 'urii fuada, “Nee rowaa, kamolu nao molu si saitomana gu malutana si doo nai? Tee molu suai gwamolu nai, si doo ne wane 'ani ka lea kau fua lao ruruuna 'e 'afitai ka faasua nia 'i maana God, ");
INSERT INTO bvd_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","suli fange 'e nao si lea uri lao liona wane. Nia 'e lea lau 'ana fua lao rakena wane, sui oli ka lea lau gwana 'i sara fasi lao noniwane.” Kada sa Disas bae 'uri nai, si baea nai ka toolangainia, fange sui gwana na doo abu fua 'ani lana. ");
INSERT INTO bvd_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Sui sa Disas ka bae lau 'urii, “Si doo ne wane 'e ilia ka ta'aa ma ka saea ka garo, nia ne kai faasua nia. ");
INSERT INTO bvd_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Suli si manata laa ta'ae ki kera tatae mai fasi lao liona wane, ma nia ka ooe, nia ka beli, ka sauwane, nia ka ooe, ");
INSERT INTO bvd_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nia ka ogalolomi, ka susuala, ka suke, ka nao si noni susuala fai ooe lae, ka 'uga, ka naunau, ka suke faafia wane ki, ma nia ka oewanea. ");
INSERT INTO bvd_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Doo 'oro ta'aa 'uri nai ki ne da lea mai fasi lao liona wane, ma daka faasuaa wane.” ");
INSERT INTO bvd_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sui guu, sa Disas ka lea naa faasia na kula nai, ma ka lea uria na bali fera 'i Taea. Ma nia ka ruu 'i laona tii luma, suli nao nia si dooria ta wane kai saitomana ne nia too 'i seeri, sui boroi 'ana nia 'afitai fua nia ka agwa. ");
INSERT INTO bvd_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ma tii wela keni ka rongoa ne sa Disas nia dao, ma nia ka lea 'ali'ali mai, ka booruru 'i maa 'aena sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ma wela keni nai, nia na ai 'i sara lau gwana faasia bali lolofaa 'i Fonisia laona maefera 'i Siria, ma nia nao lau wela keni Diu, ma na saari nia na anoedoo ta'aa nia burosia. 'Uri nai, nia ka amasia sa Disas uri kai taria na anoedoo ta'aa nai faasia na saari nia. ");
INSERT INTO bvd_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ma sa Disas ka bae sulia na Diu ki ne kera mala 'ana wele ki ka 'urii, “Kameli, meli sangonia fasi 'ameli wele ki 'i nao ne. Suli nia 'e nao si diana uri meli ka 'ui 'ameli 'ana fanga kera wele ki fua giri ki.” ");
INSERT INTO bvd_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma na wela keni nai nia luua ka 'urii, “Aofia 'ae, na giri ki boroi, lea orongana si fanga wele ki 'asia kera saitomana daka 'ani gwada.” ");
INSERT INTO bvd_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Sui sa Disas ka bae 'urii fuana, “'Oe oli 'amu 'i fera kamu. Na anoedoo ta'aa bae, nia lea naa faasia na saari 'oe. Suli si luu laa nai nia faatainia 'oe 'o faamamane.” ");
INSERT INTO bvd_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ma nia ka oli 'i fera, ma ka liotoi na saari nia bae 'e maleu gwana 'i laona ifitai. Ma na anoedoo ta'aa bae ka lea mamana naa faasia. ");
INSERT INTO bvd_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sui sa Disas nia ka faasia naa bali lolofaa 'i Taea, ka lea kau ka liu 'i Saedon, ma bali toaa 'i Dikabolis, ma ka koso naa kau fafona na 'osi 'i Galilii. ");
INSERT INTO bvd_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ma wane ki 'i seeri, kera ka ngalia mai tii wane ne alingana boko ma na fakana ka 'ato siana sa Disas, ma kera ka amasia sa Disas fasi uri nia kai alua na 'abana 'i fafona na wane nai. ");
INSERT INTO bvd_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ma sa Disas ka talai nia na kau fasi konia nai, ma daru ka lea uria tii si kula taifili keerua, ma nia ka kusu 'ana kakauna lao alingana sa wala nai. Ma ka ngisufia kakauna, sui ka kanoa 'ana meana sa wala nai. ");
INSERT INTO bvd_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sui, nia ka lio 'alaa kau 'i langi, ka 'asimango baita, ka bae 'urii fuana, “'Efata!” Toolangainia, “'Ifi naa!” ");
INSERT INTO bvd_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ma 'ana si kada nai, na fakana ka alube, nia ka safali bae folaa naa. ");
INSERT INTO bvd_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","'Uri nai, sa Disas ka luia kera nao dasi faarongoa lau 'ana toae ki. Sui boroi 'ana nia ka lui fifii ai, kera daka unu lado na 'ada suli sa Disas ne nia guraa na waa nai ka lea naa 'ana. ");
INSERT INTO bvd_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ma na toaa neki kera rongoa, daka kwele 'asia naa, ma kera daka bae 'urii, “Rowane 'ae! Sa wala nee ilia doo neki ka diana 'asia naa wala! Tee waa bae alingana boko boroi nia 'ifingia alingana ka rongo doo naa ma ka 'ifingia ngiduna ka bae naa nee!” ");
INSERT INTO bvd_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nao si tau guu 'i burina doo nai ki, tii konia baita ka koni mai. Ma kada nai nao naa ta fanga 'ada, sa Disas ka saea mai waa kwairooi nia ki, ma ka bae 'urii, ");
INSERT INTO bvd_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nau ku manatainia lau gwaku toaa nee, suli kera da too mai fai nau olu fa dani ki ka sui naa, ma ka nao na 'ada tasi fanga. ");
INSERT INTO bvd_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ma lea kera fiolo gwada 'urii, ma nau ku olitai kera 'i fera, kera ka 'asi kera suli taale ne, suli ta bali 'ada na fera kera ki 'e nii tau.” ");
INSERT INTO bvd_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ma na toa kwairooi nia ki kera daka ledi 'urii, “'I fai ne kolu kai dao toi ta fanga ai uri ka bobola fainia saare lana toaa 'oro 'urii lao fera kwasi nee, si kula nao gu tai fera ai nee?” ");
INSERT INTO bvd_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ma sa Disas ka ledi kera ka 'urii, “Fita fa beret ne kamolu too ai?” Ma kera luu nia daka 'urii, “Fiu fa beret ki.” ");
INSERT INTO bvd_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ma sa Disas ka saea fua figue nai kera daka gooru 'ada 'i saegano. 'Uri nai guu, nia ka ngalia na fiu fa beret baki, ka tangoa God faafia, sui ka niia ka faa fua waa kwairooi nia ki, kera daka tolingia naa fua figua nai. ");
INSERT INTO bvd_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ma kera daka too lau guu 'ana bara gwa sakwari tu'uu. Ma sa Disas nia ka falea lau guu tango laa fua God, sui ka saea fua waa kwairooi nia ki daka tolingia naa fua toaa nai. ");
INSERT INTO bvd_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ma kera daka fanga lelea daka abusu tiifau. Ma 'i burina, na toa kwairooi nia ki kera daka konia naa orongana fanga ne nia ore fua lao fiu kukudu ki lelea ka fungu. ");
INSERT INTO bvd_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ma na konia nai, nia bobola fainia ta faitooni wane ki. Sui sa Disas ka olitai kera naa uri fera kera ki. ");
INSERT INTO bvd_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Sui nia fainia toa kwairooi nia ki, kera 'ali'ali daka raa naa laona gwa baru nai, ma daka lea naa uria na bali lolofaa 'i Dalamanuta. ");
INSERT INTO bvd_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ma tai Faarisii ki da lea mai, daka olisusuu fai sa Disas, ma daka doori ilitona. Nia ne kera daka saea nia ka ilia fasi ta doo kwaibalatana, uri ka faatainia ne God falea mamanaa fuana. ");
INSERT INTO bvd_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","'Uri nai sa Disas nia ka mango baita, ma ka bae 'urii, “Tee ne adea na uni wane abu faamamane nee ka doori suana lae ta doo kwaibalatana rowane? Si doo mamana ku saea fuamolu 'e 'urii, nau 'afitai ku faatainia guu ta doo kwaibalatana fuada.” ");
INSERT INTO bvd_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ma nia ka faasida, ka raa lau gwana 'i laona gwa baru nai, ma ka faafolo naa uri ta bali 'osi. ");
INSERT INTO bvd_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kada kera nii naa laona 'osi, na toa kwairooi nia ki kera daka manata buro mai 'ana ngali lana mai tai fa beret lau. Tii fa beret guu ne nii siada laona baru. ");
INSERT INTO bvd_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ma sa Disas ka kwaifamanatai ka 'urii, “Molu fii kamolu fasi ade lea molu ka too 'ana isi nee Faarisii ki ma sa Herod da too ai nee.” ");
INSERT INTO bvd_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ma kera daka bae 'i malutada kwailiu daka 'urii, “Alamia nao kolu si ngali mai tai fa beret lau 'oto ne nia ka sae si doo nai.” ");
INSERT INTO bvd_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ma kada sa Disas nia saitomana ne kera ulafusia ne nia bae 'ana suli na toolangaidoo ta'aa laa kera Faarisii ki ma sa Herod, nia ka bae 'urii fuada, “'Urifita ne kamolu ka bae 'amolu suli ne nao kamolu si ngali mai tai fa beret lau? Kamolu nao molu si filoa 'ua guu si doo nai nau ku saea fuamolu nai? Manatamolu fofonola 'ua nee? ");
INSERT INTO bvd_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kamolu nee molu gwalinge boroi molu si rongo filoa guu, ma molu ka lilio boroi molu si lio filoa guu si doo 'oro ne nau ku ilia ki mai. ");
INSERT INTO bvd_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Si kada bae nau ku niia lima fa beret baki fua lima tooni wane bae, fita kukudu ki bae kamolu konia orongana fanga bae ore fuai lelea ka fungu bae?” Kera da luua daka 'urii, “Tii taafuli doo ma roo doo sarenga ki bae.” ");
INSERT INTO bvd_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Sa Disas ka ledi lau gu 'urii, “Ma sui si kada bae nau ku niia fiu fa beret baki fua faitooni wane baki mone, fita kukudu ki 'ana bae kamolu konia orongana fanga fua laona lelea ka fungu?” Kera daka luua lau guu, daka 'urii, “Na fiu doo ki.” ");
INSERT INTO bvd_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nia ka ledi lau 'urii, “Sui tee ne adea ka nao molu si filoa guu si doo nai nau ku bae sulia nai?” ");
INSERT INTO bvd_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kera da lea kau da dao 'i Betsaeda, tai toaa ki daka talaia mai tii waa nai maana rodo, daka ledia sa Disas uri nia ka dau tona. ");
INSERT INTO bvd_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ma sa Disas ka dau 'i 'abana waa nai ka talaia kau 'uri sara fasi lao maefera nai. Sa Disas ka ngisufia maana waa nai sui, nia ka dau faafia maana sa wala nai, ka leditona ka 'urii, “'Oe liotoi ta doo?” ");
INSERT INTO bvd_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","'Uri nai guu, sa wala nai ka lio 'alaa ka bae 'urii, “Nau ku suana wane ki, sua lada mala 'ai ki ma daka fali daka lea ki.” ");
INSERT INTO bvd_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","'Uri nai sa Disas ka alu lau 'abana faafia maana sa wala nai. Ma sa wala nai ka lilio mamana naa, ma ka lio saitomana naa doo ki tiifau. ");
INSERT INTO bvd_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ma sa Disas ka odu nia na kau 'i luma nia, ma ka bae 'urii fuana, “Too 'amu nao 'osi lea 'ua kau lao fera loko na.” ");
INSERT INTO bvd_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sa Disas fainia toa kwairooi nia ki, kera da lea naa uri maefera nai ki karangia maefera 'i Sisaria Filibae. Si kada kera da dao suli taale, nia ka ledia toa kwairooi nia ki ka 'urii, “Nee, toae ki kera sae nau 'ana sa tii?” ");
INSERT INTO bvd_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ma kera luu nia daka 'urii, “Tai waa kera saea sa 'oe sa Dion waa ni faasiuabu bae gwana ne 'oe mauri lau gwamu nee. Ma tai waa daka saea sa 'oe sa 'Ilaeja ne 'oe oli lau mai nee. Ma tai waa lau guu kera daka saea lau 'ada sae 'oe ta waa 'ana brofet baki 'i nao gwana ne.” ");
INSERT INTO bvd_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ma sa Disas ka ledi lau ka 'urii, “Ma sui kamolu mone, molu saea sa nau sa tii nee?” Sa Bita 'e luu nia ka 'urii, “'Oe na Kraes bae naa ne.” ");
INSERT INTO bvd_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ma sa Disas ka luia nao kera dasi faarongoa lau ta waa suli nia. ");
INSERT INTO bvd_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sui sa Disas nia safali toolangaidoo fuada ka saea naa, “Ni nia 'Alakwa Nia Wane, kai liu laona nonifii laa 'oro ki. Ma na ulunao ki, ma na waa baita ni foa ki, ma toa toolangaidoo ki 'ana taki, kera ne dai falea nonifii lae fuana ma daka saumaeli nia. Sui boroi 'ana dao 'ana oluna fa dani, nia kai tatae lau gwana fasi maea.” ");
INSERT INTO bvd_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Si kada nia bae folaa suli si doo nai ki 'uri nai, sa Bita ka talaia daru ka lea kau 'ana si kula taifili keerua, nia ka ngatafia naa sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ma si kada nai sa Disas nia abulo 'e lio kau uri toa kwairooi nia ki, ka ngatafia naa sa Bita ka bae 'urii, “Saetan, 'otolangai 'oe 'i buriku wala. 'Oe nao 'osi too guu 'ana manata lana God. Manata lana wane gwana ne 'oe too ai.” ");
INSERT INTO bvd_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","'Uri nai sui guu nia ka 'ailia mai konia nai fainia toa kwairooi nia ki siana, ka bae 'urii fuada sui guu, “Lea ta waa nia dooria kai lea mai 'i buriku, nia ka manata buro naa 'ani nia 'i tala'ana, ka noni maabe naa fua liu lae laona fii lae ki, talafana 'airarafolo nia ne ngalia uri mae lae 'i fafona. ");
INSERT INTO bvd_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ma waa ne dau ngasi 'ana faafia mauria nia, mauria nia kai funu, ma waa ne luka dangatai 'ana mauria nia fuaku fai na Faarongoa Diana nau nee, nia kai todaa mauria firi. ");
INSERT INTO bvd_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Lea waa ka too boroi 'ana doo 'oro laona fera ne 'i saegano, ma nia ka mae gwana, doo nai ki si falea gu ta dianaa fuana. ");
INSERT INTO bvd_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nao ta waa si tala 'ana foli lana mauria firi 'ana malefo. ");
INSERT INTO bvd_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ma lea ta waa nia noni susuala 'ani nau fainia bae laku 'i seki lao fera ne 'i saegano, ni nau 'Alakwa nia Wane kwai noni susuala lau gu 'ani nia 'ana kada ku dao mai fainia rara laa Maa nau fai nau, ma fainia talae 'ensel abu nia.” ");
INSERT INTO bvd_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","'Uri nai guu, sa Disas ka bae lau ka 'urii, “Nau ku saea naa fuamolu, tai wane 'amolu 'i seeki lau guu, kera nao dasi mae lelea kera kai liotoi God kai 'inito faafia toaa nia ki 'ana rigitaa.” ");
INSERT INTO bvd_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","'I burina ono fa dani ki sui, sa Disas ka talaia sa Bita, sa Demes, ma sa Dion, ma kera daka raa uria gwauna tii fa uo fane nai, ma kera daka too taifili kera 'i seeri. Ma 'ana kada kera lio kau, kera daka liotoi sa Disas nia tatala, ");
INSERT INTO bvd_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ma na maku nia ka kwakwaosarea guu. Ma ka kwakwaoa ka talua naa ta maku kwakwaoa ne ta waa laona fera ne 'i saegano nia taufi diana ai. ");
INSERT INTO bvd_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma na olu waa kwairooi nai ki kera daka liotoi sa 'Ilaeja fai sa Mosis, sakatafa folaa mai siada, ma keerua daru ka bae fainia sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ma sa Bita ka bae 'urii fuana sa Disas, “Wala Waa ni toolangaidoo 'ae, nia diana 'asia naa fua kolu ka too 'akolu 'i seeki. Alu kameli saungainia fasi olu babale ki, ta doo fuamu, ta doo fua sa Mosis, ma ta doo fua sa 'Ilaeja.” ");
INSERT INTO bvd_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Sa Bita nia bae 'uri nai, suli nia nao si saitomana naa ta doo ne nia kai saea, suli kera da mau 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ma tii gwa dasa ka sifo ka koko na faafi kera. Ma tii lingee doo ka talo mai faasia laona gwa dasa nai ma ka bae 'urii, “Na 'alakwa muutaia nau ne nau ku liosau 'asia naa 'ani nia ne. Molu fafurongo uri nia!” ");
INSERT INTO bvd_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ma kera daka lio 'ali'ali kali kera, ma ka nao dasi liotoi naa ta waa fai kera, taifilia guu sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Si kada kera sifo na mai faasia fa uo nai, sa Disas ka luia nao dasi faarongo ai ka 'urii, “Nao molu si faarongoa lau ta wane 'ana doo nai molu suai nai. Too 'ana lelea ka dao guu 'ana si kada ne nau, na 'Alakwa nia Wane, kwai tatae faasia maea.” ");
INSERT INTO bvd_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ma kera daka ade suli bae lana nai, ma kera daka bae 'i malutada kwailiu, ma daka 'urii, “Si manatae doo 'utaa ne nia saea nai toa nee, ‘Nau kwai tatae faasia maea?’” ");
INSERT INTO bvd_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma kera daka ledi nia, daka 'urii, “'Urifita ne toa toolangaidoo 'ana taki kera daka saea sa 'Ilaeja ne kai eta dao fasi mai?” ");
INSERT INTO bvd_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ma sa Disas 'e luu kera ka 'urii, “Doo mamane na, sa 'Ilaeja ne eta dao mai nao, uri nia ka ade akau 'ana doo ki sui. Ma sui tee ne adea na kekeda laa Abu ka saea ka 'urii, na 'Alakwa Nia Wane nia kai nonifii tasa ma kera da kai susubutainia? ");
INSERT INTO bvd_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nau ku faarongo kamolu, sa 'Ilaeja nia dao sui naa, ma toae ki kera da ilia naa doo 'oro ta'aa neki kera dooria ili lana 'ani nia, 'uri ne kekeda laa Abu nia bae mai sulia.” ");
INSERT INTO bvd_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ma si kada kera dao siana tai toa kwairooi nai ki lau guu, kera daka liotoi konia baita nai da koni kali kera naa. Ma tai waa toolangaidoo ki 'ana taki kera daka olisusuu fai kera. ");
INSERT INTO bvd_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ma si kada ne toaa nai sui guu kera suana sa Disas, kera daka kwele 'asia naa, ma daka fita kau daka talai ni noni sasala laa mai 'ani nia. ");
INSERT INTO bvd_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ma sa Disas ka ledia waa kwairooi nia ki ka 'urii, “Tee ne molu olisusuu fai kera faafia?” ");
INSERT INTO bvd_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ma ta tii waa lao figua nai, nia luua ka 'urii, “Waa toolangaidoo 'ae, nau ku ngali mai kaa 'alakwa nau siamu ne. Na anoedoo ta'aa nia burosia, ma ka nao si bae naa. ");
INSERT INTO bvd_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ma kada na anoedoo ta'aa nai 'e dao 'ani nia, nia ka namutainia gu 'i saegano. Ma na fakana ka ngingisula nia ka didi lifo, ma nonina ka gaga'ai tiifau naa. Ma nau ku gania toa kwairooi 'oe ki uri kera daka taria na anoedoo ta'aa nee faasia sui boroi nia ka 'afitai gwana fuada.” ");
INSERT INTO bvd_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ma sa Disas ka bae 'urii, “Kamolu toaa abu faamamane nee, nau ku noni'ela naa 'ana abu faamamane laa kamolu nee wala. Nau ku too ka tau na mai fai kamolu, bobola fainia sae kamolu molu ka faamamane nau naa. Ngali mai wela na siaku.” ");
INSERT INTO bvd_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ma kera daka ngalia kau wela nai siana sa Disas. Ma kada na anoedoo ta'aa nai 'e suana sa Disas, nia ka 'ui 'ana wela nai 'i saegano ka lautai naa, ma fakana ka ngingisula tiifau naa. ");
INSERT INTO bvd_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ma sa Disas ka ledia maa nia wela nai ka 'urii, “Fita si kada ne doo nee ade 'urii sui na mai 'ana wela nee wala?” Ma nia ka luua ka 'urii, “Doo nee safali ade 'urii 'ua gu mai 'ani nia kada 'e tu'uu. ");
INSERT INTO bvd_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Si kada 'oro nia 'ui 'ani nia laona ere ma laona kafo ma nia sae kai mae ki naa. Ma lea 'oe bobola gwamu fai ili lana, 'oko manatai kaari mai 'oko 'adomi kaari fasi.” ");
INSERT INTO bvd_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ma sa Disas ka bae 'urii, “Nia nao lau ne lea nau ku bobola fainia ne. Kaa 'urii, si doo ki sui guu kai walude gwana fua sa tii ne nia manata mamana 'ani nau.” ");
INSERT INTO bvd_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ma 'uri nai guu maa nia wela nai ka bae baita ka 'urii, “Nau ku faamamane 'oe! 'Adomi nau mai, uri faamamana laa nau ka rigita!” ");
INSERT INTO bvd_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ma si kada sa Disas 'e suana na konia nai kera fita mai uri 'i seeri, nia ka bae 'urii fuana anoedoo ta'aa nai, “'Oe na anoedoo ta'aa nee 'o guutaa alingana wela nee, ma 'oko faafaka'atoa fakana wela nee, nau ku odu 'oe, 'o ruu mai maa. Nao oli 'osi 'adosia lau wela nee!” ");
INSERT INTO bvd_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ma na anoedoo ta'aa nai ka lebetainia naa wela nai ma nia ka mamanuarai, ma ka ruu na mai maa faasia. Ma na wela nai na sua lana ka mala sae nia mae naa. Ma toaa 'oro nai ki daka bae 'urii, “Nia mae naa ne.” ");
INSERT INTO bvd_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Sui boroi, sa Disas ka dau 'ana 'abana wela nai ka taea, ma nia ka tatae naa. ");
INSERT INTO bvd_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ma si kada sa Disas nia ruu kau 'i luma, toa kwairooi nia ki kera daka ledi nia kada kera too 'ada taifili kera daka 'urii, “'Utaa bae ka 'afitai fuameli uri tari lana anoedoo ta'aa bae wala?” ");
INSERT INTO bvd_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ma sa Disas 'e luu kera ka 'urii, “Na foa lae guu taifilia ne bobola fainia tari lana anoedoo ta'aa ki 'uri bae.” ");
INSERT INTO bvd_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Si kada nai, sa Disas fai toa kwairooi nia ki kera faasia 'i seeri daka tasa naa uri bali lolofaa 'i Galilii. Ma sa Disas ka nao si dooria ne ta waa kai saitomana kula ne kera too 'ana, ");
INSERT INTO bvd_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","suli nia toolangaidoo 'ana siana toa kwairooi nia ki. Nia ka 'urii, “Nau, na 'Alakwa nia Wane, kera kai fale nau fuana malimae nau ki, ma kera kai saumaeli nau. Ma 'ana oluna fa dani, nau kwai tatae lau faasia maea.” ");
INSERT INTO bvd_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Sui boroi waa kwairooi sa Disas ki ka nao dasi saitomana guu doo nai nia saea, ma kera daka mau lau gwada 'ana ledi lana. ");
INSERT INTO bvd_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kera lea mai daka dao naa 'ana maefere 'i Kabaneam. Si kada kera da dao 'i luma, sa Disas ka ledia toa kwairooi nia ki ka 'urii, “Na tee bae kamolu olisusuu mai faafia suli taale?” ");
INSERT INTO bvd_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Sui kera nao dasi bae guu, suli kera olisusuu mai faafia sa tii ada ne kai gwaungai fuada. ");
INSERT INTO bvd_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ma sa Disas ka gooru 'i saegano, ka 'aili kera mai na akwala ma roo waa kwairooi nia baki siana, ma ka bae 'urii, “Lea sa tii ne gwaungai, nia ka alu nia 'i 'isi dangalu naa, ma ka waa ni rao gwana fua toae ki sui naa.” ");
INSERT INTO bvd_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sui sa Disas ka talaia mai tii kaa wela, ka faa uua 'i matangada. Nia ka ofea mai wela nai, ka bae 'urii fuada, ");
INSERT INTO bvd_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Lea sa tii ne gonia ta wela tu'uu 'urii 'ana sataku, nia goni nau lau guu. Ma lea sa tii ne nia goni nau, nao nia si goni nau gwana taifili nau, nia gonia lau guu God ne fale nau mai.” ");
INSERT INTO bvd_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Sa Dion nia bae 'urii fua sa Disas, “Wala waa toolangaidoo 'ae, kameli meli suana tii waa nia taria na anoedoo ta'aa ki 'ana satamu. 'Uri nai meli ka luia nia nao si ilia lau, suli nia nao lau ta waa fai kolu.” ");
INSERT INTO bvd_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ma sa Disas ka bae 'urii, “Nao molu si luia lau, suli waa ne ilia si doo kwaibalatana 'ana sataku, nia nao si ili gu tasi doo ne ta'aa fuaku. ");
INSERT INTO bvd_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Wane ne nao si malimae 'ani kolu, nia na wane kolu. ");
INSERT INTO bvd_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Si doo mamana ku saea fuamolu ne 'urii, lea ta waa 'e faa si kafo fuamolu, suli kamolu na waa nau ki, nia kai ngalia kwaiaraa nia uria 'afitai ka nao. ");
INSERT INTO bvd_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Tii ne nia ilia tasi doo ne adea ta wela 'ana wela tu'uu neki da manata mamana 'ani nau ma wela nai ka lukasia manata mamana laa nia 'ani nau, nia diana fua daka kani kulua ta maefau baita tasa 'i luana wane nai lea daka kulufauna laona asi kwasi. ");
INSERT INTO bvd_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Lea sa ta bali 'aba 'amu nia talai 'oe uri abulo ta'aa lae, 'o sigimuusia 'amu. Nia diana tasa uri 'oko ruu laona maurie fainia ta tii bali 'aba boroi 'ana. Nia ka ta'aa tasa ne lea sa na roo bali 'aba 'oe ki daka tio lalau sui boroi 'ada ma daka 'ui nada 'ani 'oe fainida laona era bae nia saru lelea si mae. ");
INSERT INTO bvd_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ma lea sa ta bali 'ae 'amu nia talai 'oe uri abulo ta'aa lae, 'o sigimuusia 'amu. Nia diana tasa uri 'oko fali tii bali 'ae boroi ma 'oko ruu laona 'initoaa nia God. Nia ta'aa ka tasa ne lea sa 'oko fali roo bali 'ae boroi 'amu ma daka 'ui nada 'ani 'oe laona era bae. ");
INSERT INTO bvd_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma lea sa ta bali maa 'amu nia talai 'oe uri abulo ta'aa lae, 'o keoa 'amu. Nia diana tasa uri 'oko lio tii bali maa boroi 'amu ma 'oko ruu laona 'initoaa nia God. Nia ta'aa tasa ne lea sa 'oko lio roo bali maa boroi 'amu ma daka 'ua nada 'ani 'oe laona era bae. ");
INSERT INTO bvd_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Si kula nai, na wawaa neki da nii ai 'afitai daka mae ma na era nai lau guu nia saru ai lelea si mae. ");
INSERT INTO bvd_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Na toae ki sui guu tara da kiki asi kera 'ana ere mala 'ana kiki asi lana fange. ");
INSERT INTO bvd_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Na asi nia doo diane boroi 'ana, lelea na mamasia lana nia sui na faasia, nia 'afitai tasa lau daka ilia ta doo ai uri nia ka mamasia lau. “Doo ne adea guu, molu kikiasina manata lana toae ki uri daka ele mala lau guu 'ana asi ne nia falea mamasia lae fua laona fange. Molu ka too kwaimani diana lau guu 'ana aroaroe 'i matangamolu kwailiu.” ");
INSERT INTO bvd_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Sui, sa Disas ka faasia 'i Kabaneam ka lea na kau uri bali lolofaa 'i Diudia ma ka ulufolo na kau 'ana kafo 'i Diodan. Konia baki daka lea lau gu mai siana, ma nia ka toolangaidoo na fuada, mala nia 'ita ka ilia na mai. ");
INSERT INTO bvd_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tai Faarisii ki kera lea mai siana sa Disas daka ilitona uri daka faagaro nia 'ada, ma kera daka ledi 'urii, “Nee wala, na taki sa Mosis nia faolomainia gwana fua wane ka lukasia 'afe nia?” ");
INSERT INTO bvd_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ma sa Disas 'e luu kera ka 'urii, “Si baea fifii tee bae sa Mosis nia saea fuamolu suli si doo nai?” ");
INSERT INTO bvd_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ma kera daka bae 'urii, “Sa Mosis nia faolomainia wane uri ka kedaa 'aba beba ni kwailukasi lae, sui kafi lukasia 'afe nia kafi odua kafi lea naa.” ");
INSERT INTO bvd_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ma sa Disas ka bae 'urii, “Sa Mosis nia kedaa na taki nai fuamolu suli na manata lamolu 'e sadi. ");
INSERT INTO bvd_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Sui ma, 'ana safali laa mai kada God nia saungainia doo ki sui guu, ‘Nia saungainia wane fai keni.’ ");
INSERT INTO bvd_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Uri si doo nai guu, wane ka faasia maa nia fainia gaa nia, ka rarau fainia 'afe nia, ");
INSERT INTO bvd_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ma keeru roo doo ki daru ka tii doo naa.’ Keeru ka nao lau ta roo doo 'e'ete, na tii doo guu. ");
INSERT INTO bvd_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Doo ne adea guu, si doo ne God nia kani faafia ka sui naa, nao ta waa si lukea naa.” ");
INSERT INTO bvd_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ma kada sa Disas fainia toa kwairooi nia ki kera oli kau dao 'i luma, kera daka ledia uri malutana si doo nai. ");
INSERT INTO bvd_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ma nia 'e luu kera ka 'urii, “Ta waa boroi 'ana ne nia lukasia 'afe nia, ma ka adea lau 'ana ta 'initai 'e'ete, nia ooe naa faafia 'afe nia nai. ");
INSERT INTO bvd_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma ka 'uri nai lau guu, lea ta 'initai nia lukasia arai nia, ma ka 'afe lau 'ana ta waa 'e'ete, nia ooe naa faafia arai nia.” ");
INSERT INTO bvd_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Toae ki kera ngalia mai kaala wela tu'uu ki siana sa Disas, uri nia ka dau toda ma ka faadianaa fuada. Sui ma toa kwairooi nia ki kera daka ngatafi kera. ");
INSERT INTO bvd_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ma kada sa Disas nia liotoi si doo nai, nia rakena ka sasu ka bae 'urii fuada, “Molu faolomainia kaala wela tu'uu ki da lea mai siaku, nao molu si suusi kera lau. Suli sa tii ne nia faamamane mala 'ana wela tu'uu ki, nia ne bobola fainia 'initoaa God. ");
INSERT INTO bvd_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Si doo mamana ku saea fuamolu 'e 'urii, lea ta waa nao si faamamane mala kaa wela tu'uu, nia 'afitai 'asia naa nia ka ruu laona 'initoaa God.” ");
INSERT INTO bvd_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ma sa Disas ka 'olia wela tu'uu nai ki, ma ka alu 'abana faafi kera ka faadiana kera. ");
INSERT INTO bvd_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Si kada sa Disas nia safali lea gu kau uri ka lea naa, tii waa 'e fita mai ka booruru naa 'i maa 'aena. Sa wala nai ka ledia sa Disas ka 'urii, “Waa toolangaidoo diana 'ae, si tee gu ne nau kwai ilia uri nau ku too 'ana mauria firi?” ");
INSERT INTO bvd_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ma sa Disas luua ka 'urii, “'Oe 'utaa ne 'oko sae nau waa diane? God taifilia naa ne nia diana, nao naa ta waa lau. ");
INSERT INTO bvd_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","'Oe saitomana gwamu si baea fifii baki bae, nee? Si bae fifii ki bae 'urii, ‘Nao 'osi sauwane, nao 'osi ooe, nao 'osi beli, nao 'osi suke faafi ta wane, nao 'osi sukea ta waa, ma 'oko sae'inito 'ana maa 'oe fai gaa 'oe.’” ");
INSERT INTO bvd_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ma sa wala nai ka bae 'urii, “Waa toolangaidoo 'ae, 'ita 'ua mai 'ana kada ku tu'uu, nau ku roo mai suli taki nai ki tiifau.” ");
INSERT INTO bvd_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","'Uri nai guu, sa Disas ka lio 'uri nia 'ana liosaue, ka bae 'urii fuana, “Tii si doo gu ne nao 'ua. 'Oe lea kau, 'oko faafoli 'ana 'okona doo 'oe ki tiifau, sui 'oko ngalia malefo nai 'oko falea fua toaa siofaa ki. Aia, ma ni 'oe 'oko too 'amu 'ana totodaa 'i salo. Sui guu, 'oko lea na mai buriku.” ");
INSERT INTO bvd_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ma si kada sa wala nai nia rongoa doo nai ki 'uri nai, nia maana ka 'asia. Ma nia ka lea na 'ana kau fai manata 'asia lae, suli nia waa totodaa nia baita 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sui sa Disas ka lio kau 'uri toa kwairooi nia ki, ka bae 'urii, “Nia 'afitai 'asia naa fua waa todadoo baita ki kera daka ruu laona 'initoaa God.” ");
INSERT INTO bvd_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ma toa kwairooi nia ki kera daka kwele 'asia naa 'ana si baea nai ki. Sui sa Disas ka bae 'ana 'urii fuada, “Wela nau ki, nia 'afitai 'asia naa uri ruu lae laona 'initoaa God. ");
INSERT INTO bvd_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nia 'afitai 'asia naa uri ta kamel ka ruu 'ae 'ogile. Nia 'e 'afitai ka talua lau uri ta waa todadoo ka ruu laona 'initoaa God.” ");
INSERT INTO bvd_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","'Uri nai toa kwairooi nia ki kera daka kwele 'asia naa, suli kera manata toi saea sa na todadoo lae dianaa 'e lea mai faasia God. Ma kera daka ledi kwailiu 'ani kera, kera daka 'urii, “'Uri nai tama doo nia 'afitai 'asia naa fua ta waa ka dao toi mauria firi nai rowane?” ");
INSERT INTO bvd_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ma sa Disas ka bubungi kera ka bae 'urii, “Wane 'ana ne nia 'afitai fuana uri dao toi lae mauria firi, God nia nao. God, nao tasi doo si 'afitai guu fuana.” ");
INSERT INTO bvd_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ma sa Bita ka bae 'urii fuana, “Kameli meli faasia mai doo ki sui naa uri meli ka lea 'i burimu!” ");
INSERT INTO bvd_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ma sa Disas 'e luua ka 'urii, “Iuka, nau ku saea fuamolu, lea ta waa ne faasia na luma nia, ma nao toolana ki, ma nao waiwane nia ki, ma nao maa nia, ma nao gaa nia, ma nao wela nia ki, ma nao gano nia ki, fuaku ma fua Faarongoa Diana nee, ");
INSERT INTO bvd_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nia kai too 'ana doo nai ki ka talua ka tasa lau. Lao fa sato 'i tari'ina, nia kai too 'ana lume, ma toolana ki, ma waiwane nia ki, ma gaa nia ki, ma wele nia ki, ma gano nia ki, ma fai nonifiia ki lau guu. Ma 'ana si kada ne nia 'ua, nia kai too 'ana mauria firi. ");
INSERT INTO bvd_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Sui ta, toaa ne kera nii 'i nao ki, kera kai 'isi, ma toaa ne kera 'isi ki, kera kai nii 'i nao.” ");
INSERT INTO bvd_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Sa Disas nia eta 'i nao 'ana toa kwairooi nia ki, kera daka lea naa uri Durusalem. Ma toa kwairooi nia ki kera daka kwele 'asia naa, ma toaa nai da lea lau guu 'i burida, kera daka mau 'asia naa. Ma sa Disas ka talaia na akwala ma roo waa kwairooi nia ki kera daka 'idu tau fasi konia nai, sui nia ka faarongo kera 'ana si doo ki ne kai fuli fuana. ");
INSERT INTO bvd_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ma nia ka bae 'urii, “Molu fafurongo fasi, suli kolu lea 'alaa na uri 'i Durusalem nai! Ma kera dai 'olemaelaku naa, nau 'Alakwa nia Wane, uri daka fale nau fua waa baita ni foa ki ma waa toolangaidoo ki 'ana taki. Ma kera dai sae garo laku uri saungi laku, ma dai fale nau naa fuana toaa nao lau Diu ki. ");
INSERT INTO bvd_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ma na toaa nai ki kera dai 'onionga 'ani nau, ma dai ngisufi nau, ma dai kwae nau, ma dai saumaeli nau naa. Ma sui 'ana oluna fa dani, nau kwai tatae lau gwaku fasi maea.” ");
INSERT INTO bvd_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sui, sa Demes fai sa Dion, roo 'alakwa sa Sebedii ki keerua daru ka lea mai siana sa Disas, daru ka bae 'urii fuana, “Wala waa toolangaidoo 'ae, tii si doo ne kaaria dooria miri ka gania siamu uri 'oko faa fuamiri.” ");
INSERT INTO bvd_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ma sa Disas ka ledi 'urii 'ani keerua, “Tee ne kamuru dooria nau kwai faa fuamuru?” ");
INSERT INTO bvd_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ma keerua daru luua daru ka 'urii, “Kaaria dooria miri kai gooru 'ana 'inito kwaimani lae fai 'oe lao 'initoaa 'oe, ta waa 'i bali aolo 'oe ta waa 'i bali mauli 'oe.” ");
INSERT INTO bvd_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ma sui sa Disas ka bae 'urii fuadaru, “Na doo ne kamuru gania siaku nai, kamuru nao muru si filoa guu. Kamuru bobola boroi fai liu lae lao nonifii laa ne nau kwailiu 'i liona?” ");
INSERT INTO bvd_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ma keerua daru luua daru ka 'urii, “Kaaria bobola gwaari fainia.” Ma sa Disas ka bae 'urii fuadaru, “Iuka nia mamana, kamuru kai liu lau gu lao nonifii laa ne nau kwailiu 'i laona. ");
INSERT INTO bvd_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Sui ta, na fili lana ta waa uri ka gooru fai nau 'i bali aolo nau, ma nao 'i bali mauli nau gu ne, nao lau ni nau ne kwai ilia. Si kula nai ki da too 'ua gu maasia toa ne da 'olofaorada mai fuai.” ");
INSERT INTO bvd_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ma si kada na akwala waa kwairooi nia nai ki kera rongoa si doo nai, kera daka rakesasu 'ana sa Demes fai sa Dion. ");
INSERT INTO bvd_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ma sa Disas nia ka koni kera ka bae 'urii fuada, “Kamolu saitomana na waa gwaungai ki ne kera gwaungai fua toaa nao lau Diu ki, kera da too 'ana rigitaa ma daka suumainia 'asia naa toae fua ili lana doori lada ki. ");
INSERT INTO bvd_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Sui ma, ni kamolu gu ne nao molu si ili lau 'uri nai 'i matangamolu. Lea ta waa 'amolu nia dooria kai baita fuamolu, waa nai nia waa ni rao kamolu gwana. ");
INSERT INTO bvd_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma lea sa tii 'amolu nia dooria kai 'inito, nia na waa ni rao tatakwai lae gwana fuamolu tiifau. ");
INSERT INTO bvd_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Suli nau, na 'Alakwa nia Wane, nau nao kusi lea mai uri toae ka rao fuaku. Nau ku lea lau 'aku mai uri ku rao fua toae ki sui gwana, ma ku falea mauria nau fua faamauri lana toaa 'oro.” ");
INSERT INTO bvd_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Sui, sa Disas fai toa kwairooi nia ki kera da lea mai daka dao 'ana maefere 'i Diorikoo. Ma si kada kera da faasia Diorikoo fai konia baita nai, kera dao tona tii waa maarodo nai satana sa Baatimias ('alakwa sa Timias) ne gooru gwana suli tala nai uri gani doo lae sia toae. ");
INSERT INTO bvd_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ma si kada nia rongo sulia sa Disas na waa bae fasi Naasaret nai, nia ka 'ai na kau 'urii, “Disas, 'oe waa nena fulina Defet, 'o manatai nau mai!” ");
INSERT INTO bvd_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ma toaa nai ki daka ngatafi nia, daka saea nia ka taaro 'ana. Sui boroi ma nia kafi 'ai baita tasa fatai ma ka 'urii, “Waa nena fulina sa Defet, 'o manatai nau mai!” ");
INSERT INTO bvd_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ma sa Disas ka uu ngado na 'i seeri ka bae 'urii, “Molu 'ailia nia lea mai.” Ma kera daka 'ailia mai sa Baatimias daka 'urii, “Manatamu ka ele 'ana. 'Oko tatae mai. Nia 'aili 'oe uri 'oko lea siana.” ");
INSERT INTO bvd_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","'Uri nai guu nia ka luka 'ana maku baita nia nai ka tio naa, ka sulatatae 'i langi ka lea na siana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ma sa Disas ka ledia ka 'urii, “Tee ne 'oe dooria nau kwai ilia fuamu wala?” Ma na waa maarodo nai ka 'urii, “'Oe waa toolangaidoo, nau ku dooria maaku ka 'ifi ku lilio.” ");
INSERT INTO bvd_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ma sa Disas ka bae 'urii fuana, “Oli 'oko lea 'amua, na faamamane laa 'oe 'e ilia maamu ka lilio naa.” Ma 'ali'ali 'ua guu maana sa wala nai ka lilio naa. Ma nia ka lea naa fai sa Disas fai kera suli taala nai. ");
INSERT INTO bvd_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Si kada sa Disas fai toa kwairooi nia ki kera da dao karangia fera baite 'i Durusalem, kera dao 'ana fera 'i Betfeis ma 'i Betanii, gwauna fa uo kera saea 'ana 'i 'Olif. 'Uri nai guu, nia ka odua ta roo waa 'ana waa kwairooi nia ki, keerua daru ka eta na 'i nao. ");
INSERT INTO bvd_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ma nia ka bae 'urii fuadaru, “Muru lea kau 'ana maefera loko, na muru naofia kau na. Kada muru dao kau 'i seeri, tara muru kai liotoi tii dongki kera kania ka uu gwana 'i seeri ne nao si ngali 'ua gu ta waa. 'Uri nai muru ka lukea muru ka talaia mai uri seeki. ");
INSERT INTO bvd_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Lea ta waa nia ledi kamuru ka 'urii, ‘'Utaa ne muru ka lukea dongki nee?’ Muru ka bae 'urii fuana, ‘Na Aofia nia dooria uri ka lea ai, sui ka olitai 'ali'ali lau guu mai ai.’” ");
INSERT INTO bvd_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ma keeru daru ka lea, ma daru ka liotoi tii kaa dongki kera kania ka uu gwana ninimana taale 'i maana tii luma. Ma kada keerua lukea naa, ");
INSERT INTO bvd_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","tai waa da uu 'i seeri ki daka ledi keerua daka 'urii, “Tee ne kamuru lukea dongki nee uria?” ");
INSERT INTO bvd_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ma keeru daru ka luu kera ilingia bae sa Disas nia saea mai fuadaru, ma kera daka faolomainia na fuadaru. ");
INSERT INTO bvd_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ma keeru daru ka talaia mai na dongki nai siana sa Disas, ma daru ka ngalia maku keerua ki daru ka regwataa 'i fafona, ma sa Disas ka raa ka gooru faafia. ");
INSERT INTO bvd_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Na toaa 'oro nai ki kera daka samatainia maku tikwa kera ki lau guu sulia taale, ma bali 'ana toaa kera daka sikilia mai uluna baibai ki, ma daka samatainia naa suli taale. Kera da ilia si doo nai uri faabaita lana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ma toaa nai sui guu da lea fainia, ta bali daka eta 'i nao, ma ta bali daka 'isi kau, kera daka suungi daka bae 'urii, “Tangoa God! Ma dianaa fuana sa wala nee ne nia lea mai fainia rigitaa God! ");
INSERT INTO bvd_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ma dianaa fuana 'initoaa nia sa wala ne kai dao mai, ne mala 'initoaa bae kokoo kolu sa Defet! Tangoa God 'i salo liu!” ");
INSERT INTO bvd_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Sa Disas nia ruu laona fera 'i Durusalem, ka lea naa uri laona Beukaua God. 'Uri nai, nia ka lio kwailiu, ma ka liotoi doo ki tiifau. Sui boroi ma faanoe kai rodo naa, nia ka tasa lau gwana uri maefera 'i Betanii fainia akwala ma roo waa kwairooi nia ki. ");
INSERT INTO bvd_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tio dani kera oli mai fasi Betanii, sa Disas ka fiolo. ");
INSERT INTO bvd_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ma nia lio kau, ma ka liotoi tii 'ai ululua nai kera 'ailia 'ana fig. Nia ka lea karangia kau uri ka liotoi ta fuaedoo 'i gwauna. Ma sui, kada nia dao 'i 'aena, nia ka liotoi gwana otona 'abana nao gu fuaedoo, suli kada na fig ki da ulu'atoa. ");
INSERT INTO bvd_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ma sa Disas ka bae 'urii fua fig nai, “Ta waa si 'ani lau ta fuaedoo faasi 'oe ka oli 'alaa!” Ma toa kwairooi nia ki kera ka rongoa si doo nai. ");
INSERT INTO bvd_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Si kada kera dao naa 'i Durusalem, sa Disas ka ruu na laona Beukaua God. 'Uri nai, nia ka taria naa toaa sui guu ne kera foli ma daka faafoli 'ana doo ni afuafu lae ki. Ma nia ka kefusia gwegele kera ki toaa nai ki da tatala 'ana malefo ki. Ma nia ka kefusia lau guu doo ni goorua kera ki toaa ne kera foli 'ana fao ki. ");
INSERT INTO bvd_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma nia ka luia nao ta waa si ngalia mai ta doo uri faafoli lae ai fua laona Beukaua God. ");
INSERT INTO bvd_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ma nia ka toolangaidoo fua toae ki ka bae 'urii, “God nia saea laona kekeda laa Abu ka 'urii, ‘Na beu nau, kera saea 'ana beu ni foa lae fua toaa ki sui lao fera ne 'i saegano.’ Ma sui molu ka bulasia molu ka alua 'amolu 'ana kula ni too kera toaa bebeli ki.” ");
INSERT INTO bvd_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na waa baita ni foa ki fainia waa toolangaidoo ki 'ana taki, kera rongoa si doo nai daka safali nani naa uri tasi doo dai ilia uri saumaeli lana sa Disas. Ma sui daka mau lau gwada 'ani nia, suli na konia nai kera da kwele 'asia naa 'ana toolangaidoo laa nia. ");
INSERT INTO bvd_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nia saulafia naa, sa Disas fai toa kwairooi nia ki, kera daka oli lau gwada faasia 'i Durusalem. ");
INSERT INTO bvd_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tio dani 'uubongi kera oli lau gu kau suli taale, kera daka liotoi fig bae 'e kuku ka 'ako naa, safali gu mai lao kutuna ka raa mai. ");
INSERT INTO bvd_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ma sa Bita ka manata toi naa si baea bae sa Disas nia saea fua 'ai nai, ma ka bae 'urii fuana sa Disas, “Waa toolangaidoo 'ae, liotoi fasi fig bae 'oe 'o agia ne nia mae naa!” ");
INSERT INTO bvd_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ma sa Disas nia luua ka 'urii, “Molu manata mamana 'ana God. ");
INSERT INTO bvd_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Si doo mamana ku saea fuamolu 'e 'urii, lea kamolu molu bae 'urii fua fa uo loko, ‘'Oe 'idu kau 'oko 'asi 'oe na kau lao asi bue,’ molu ka manata mamana ma ka nao molu si manata sala lao liomolu, si doo nai kai fuli. God kai ilia gwana fuamolu. ");
INSERT INTO bvd_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Doo ne adea guu nau ku saea fuamolu nai, kada molu foa, ma molu ka gani uri tasi doo, molu ka manata mamana mala 'ana sae kamolu ngalia naa, ma God kai falea gwana doo ne kamolu gani uria. ");
INSERT INTO bvd_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Iuka, kada kamolu foa, molu ka manata lukea ta'aa laa kera waa ki fuamolu, 'uri ne Maa kamolu 'i salo nia manata lukea lau guu abulo ta'aa laa kamolu ki.” ");
INSERT INTO bvd_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Sa Disas fai waa kwairooi nia ki, kera oli mai daka dao lau gu 'i Durusalem. Ma si kada sa Disas 'e ruu lao Beukaua God, na waa baita ni foa ki, ma waa toolangaidoo ki 'ana taki, ma waa gwaungai ki, kera daka lea mai siana. ");
INSERT INTO bvd_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ma daka ledi 'urii 'ani nia, “Nee wala, na rigitaa tee ne 'oe too ai ma 'oko ilia doo neki? Ma sa tii ne faa rigitaa nee fuamu uri ili lana doo neki?” ");
INSERT INTO bvd_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Sa Disas 'e luu kera ka 'urii, “Iuka, nau boroi ku ledi kamolu lau gu uri tii si doo. Lea kamolu luu nau, nau kufi faarongo kamolu 'ana rigitaa ne nau ku too ai fua ili lana doo neki. ");
INSERT INTO bvd_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Aia, kamolu saea fasi fuaku, na rigitaa ne sa Dion nia too ai uri faasiuabu lae nia lea mai fasi God, ma nao nia lea mai fasi wane gwana?” ");
INSERT INTO bvd_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ma kera daka bae suli si doo nai matangada uri dao lae toi si doo dau saea, ma daka 'urii, “Tee ne kolu kai saea? Lea sa kolu olisi nia ma kolu ka bae 'urii, ‘Faasia God,’ nia kai bae 'urii na, ‘'Utaa ne molu si faamamanea sa Dion?’ ");
INSERT INTO bvd_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma lea kolu bae lau guu 'urii, ‘Nia lea gwana mai faasia wane 'ana fera ne 'i saegano.’” Kera daka mau lau gwada 'ana toaa ki, suli na toaa nai sui guu kera da saitomana sa Dion nia na brofet mamana. ");
INSERT INTO bvd_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nia ne, kera luua sa Disas ma daka bae 'urii, “Kameli ulafusia!” Ma sa Disas ka bae 'urii fuada, “Nau boroi nao kwasi faarongo kamolu lau guu 'ana rigitaa nee nau ku ilia 'ana doo neki.” ");
INSERT INTO bvd_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sui, sa Disas ka safali bae fua toa gwaungai kera toaa Diu 'ana tarifulaa ki. Ma nia ka bae 'urii, “Tii waa nia fasia ola greib nia lelea ka sui naa. Nia ka 'uia sulufau kalia, ka 'elia tii fauongi ni dali ngisi lana greib ki 'i laona fua ngilo lana waen, ma ka saungainia tii labu ni folo lae 'ana ola nia nai. Sui nia ka alu ola nai 'i 'abana tai waa uri daka suasulia ne kera da kwai ala faafi uri fale lana bali fanga nia waa naisata 'ana ole kada 'e maua. Nia ade 'uri nai sui, nia ka lea naa 'ana fera tau. ");
INSERT INTO bvd_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Totoo 'e dao si kada ola greib nai 'e maua, nia ka falea tii waa ni rao 'ana ka lea mai sia toa bae lao raoa nia, uri ka ngali kau bali fanga naisata 'ani nia waa 'ana doo. ");
INSERT INTO bvd_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ma si kada waa nai dao, toa nai daka daua daka karoa. Ma kera daka kwae nia, sui daka olitainia ka oli tatakwai gwana. ");
INSERT INTO bvd_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Sui, na waa nai 'ana ola ka odua lau gu mai ta waa lau. Toa bae liu daka diu gwauna sa wala nai ma daka ilia naa doo 'oro faa noni susuala 'ani nia. ");
INSERT INTO bvd_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Waa nai 'ana ola ka odua mai ta waa lau guu. Ma toa bae kera daka saungia sa wala nai ka mae naa. Waa nai 'ana ola, nia odua lau mai waa 'oro nia ni rao ki ma sui, toa bae daka kwaeta'aa 'ana ta bali ada, ma tai doo kera saungida daka mae naa. ");
INSERT INTO bvd_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ade 'uri nai lelea tii fa waa 'isi naa ka too fua odu lana mai. Na waa 'isi nai 'e too, nia na 'alakwa nia waa 'ana ola nai 'ua guu. Ma nia ka liosau 'asia naa 'ana 'alakwa nia nai. Sui boroi 'ana, nia ka odua na mai, ma ka manata 'urii, ‘Wela nau nee 'ua gu taari kera daka sae'inito 'ani nia.’ ");
INSERT INTO bvd_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ma sui boroi 'ana, toa bae kera daka bae 'ada fuada kwailiu daka 'urii, ‘Na wela bae kai ngali fulingana gu maa nia ne! Lea mai kolu saungia ka mae 'ana, uri kolu ka ngali 'akolu doo neki maa nia kai faa fuana nee!’ ");
INSERT INTO bvd_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ma kera daka saungia wela nai ka mae, ma daka ngalia doo mae naa daka 'ui ai sara fasi laona ola nai.” ");
INSERT INTO bvd_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","'I seeri sa Disas ka ledia toa gwaungai bae ka 'urii, “Tee ne na waa 'inito nai 'ana ola nia kai ilia 'ana toa nai? Nia kai lea mai kai saumaelia toa nai da ala faafia sua lae suli ola nai, sui nia ka alua lau ola nai 'i 'abana toaa 'e'ete ki naa, uri daka sua lau sulia fuana. ");
INSERT INTO bvd_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Talafana lau gu si doo bae molu teemai sulia lao buka abu nai, bae 'e bae 'urii, ‘Si fau bae toa ni saungai luma ki da 'ui gwada ai, nia 'ana ne si fau 'initoa ni faangasi lana fatai lume. ");
INSERT INTO bvd_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","God ne ilia si doo nai ka 'uri nai, ma kolu ka suai ka diana 'asia naa.’” ");
INSERT INTO bvd_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","'I seeri guu, na toa gwaungai nai toaa Diu ki, kera daka nani naa uri tasi ade laa uri daka daua sa Disas, suli kera da filoa naa sa Disas 'e falea si tarifula laa nai suli kera. Ma sui, kera daka mau lau gwada 'ana konia nai, daka faasi nia daka lea na 'ada. ");
INSERT INTO bvd_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Totoo lau guu toa gwaungai nai ki daka odua mai tai Faarisii fainia tai waa 'ana toaa sa Herod ki, daka lea mai daka ledia naa sa Disas uri kefusi lana 'ana tasi doo nia kai saea. ");
INSERT INTO bvd_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Iuka. Kera daka dao na siana, ma daka bae 'urii, “Waa toolangaidoo 'ae, kameli saitomana si doo ne 'oe saea ki, si doo mamana ki sui guu. 'Oe 'o toolangaidoo fua toae ki 'ana mamanaa God ka lea 'ua gu suli doori lana. Ma ka nao 'osi 'ado guu fainia ta waa, 'ana manata laa 'i tala'ana. Ma ka nao 'osi mamaura guu 'ana manata lana ta waa 'inito boroi 'ana. Aia, 'oe faarongo kameli fasi. Nia 'o'olo gwana 'ana taki God, uri meli ka folia takis nee fua waa 'inito nee 'ana fera 'i Rom, ma nao 'utaa? Nia 'o'olo gwana fua kameli ka faa, ma nao 'e nao?” ");
INSERT INTO bvd_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ma sui, sa Disas ka filoa gwana sukea kera nai, nia olisi kera ka 'urii, “Tee ne adea molu ka sasi uri kefusi laku? Ngali fasi mai tafa seleni ku suai fasi.” ");
INSERT INTO bvd_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ma kera daka ngalia mai tii fa seleni fuana, nia ka ledi kera ka 'urii, “Nunu sa tii ne nii 'afa seleni nee, ma satana sa tii ne nii ai nee?” Kera luua, daka 'urii, “Waa 'inito nee fera 'i Rom na.” ");
INSERT INTO bvd_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Sa Disas ka bae 'urii, “Lea kau, si doo naisata 'ana waa 'inito 'i Rom ki molu faa 'amolu fua waa 'inito 'i Rom, si doo naisata 'ana God molu ka faa 'amolu fua God.” Ma kera daka kwele 'asia naa 'ani nia. ");
INSERT INTO bvd_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sui, toa Sadiusii ki daka lea lau gu mai siana sa Disas. Na Sadiusii ki da saea lelea wane 'e mae naa 'afitai sae totoo nia ka tatae lau faasia maea. ");
INSERT INTO bvd_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ma kera daka ledia sa Disas daka bae 'urii, “Waa toolangaidoo 'ae, sa Mosis kedaa na taki fuakolu ka bae mai 'urii bae, ‘Lelea waa 'e mae fasi 'afe nia, ma ka nao si welaa guu, na toolana 'ua guu waa nai ka adea lau 'initai nai uri ka kwalafia ta wela ka talana sa wala nai 'e mae.’ ");
INSERT INTO bvd_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Aia, totoo tii bara waisaasina nai kera 'ada fiu waa ki fatai. Na waa 'i nao 'e adea tii wela keni nai, sui ka nao si welaa guu, nia ka mae gwana. ");
INSERT INTO bvd_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","'Uri nai, waa 'i burina ka adea lau wela keni nai, ma ka nao si welaa lau guu, nia ka mae lau gwana. Oluna waa ka 'uri nai lau guu. ");
INSERT INTO bvd_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ma ka lea na 'uri nai suli fiu waisaasina nai ki kera mae lelea ka sui guu ka nao ta waa ada si welaa guu. Ma burina kera da mae tiifau naa, wela keni nai ka mae lau guu. ");
INSERT INTO bvd_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ma sui 'uri nai, totoo 'e dao 'afa dani God 'e tataea toaa da mae ki fasi maea, na 'initai nai na 'afe sa tii guu nai 'ana bara waisaasina nai. Kera sui gu bae da adea wela keni nai!” ");
INSERT INTO bvd_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ma sa Disas 'e luu kera ka 'urii, “Kamolu molu ulafusia malutana Kekeda laa abu ki fainia tetedea God nai molu ka manata garo suli si doo nai ka 'uri nai. ");
INSERT INTO bvd_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Suli, si kada waa ki da tatae naa fasi maea, kera da 'uria na 'ada 'ensel loki 'i salo nai, ne nao dasi arai ma dasi 'afe naa. ");
INSERT INTO bvd_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Iuka, nau ku toolangaidoo fuamolu suli tatae laa fasi maea. Nau ku saitomana kamolu teemainia naa si baea bae sa Mosis 'e saea suli na era bae saru 'ana kaa 'ai tu'uu bae. Si kada bae, God 'e bae 'urii fua sa Mosis, ‘Nau naa ne God ne sa 'Abraham 'e foosia, ma God ne sa 'Aesak 'e foosia, ma God ne sa Diakab 'e foosia.’ ");
INSERT INTO bvd_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Toolangai lana si baea nai 'e 'urii, toa nai ki kera mae naa, sui boroi God 'e faatainia kera da foosi nia 'ua gwada, ma daka kwaimani 'ua gwada fainia. Kamolu manata lamolu 'e garo suli si doo nai!” ");
INSERT INTO bvd_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ma tii waa ni toolangaidoo lae 'ana taki sa Mosis, 'e lea mai ka fafurongoa olisusuu laa nai fai sa Disas. Nia 'e rongoa sa Disas 'e olisi diana 'ana si ledi laa nai Sadiusii ki da ledi nia ai, nia ka ledi 'urii 'ana sa Disas, “Si baea fifii tee gu ne 'inito ka talua sui naa si baea fifii ki lao taki sa Mosis?” ");
INSERT INTO bvd_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Sa Disas 'e olisi nia ka bae 'urii, “Si baea fifii ne 'inito ka talua sui naa si baea fifii ki ne 'urii, ‘Toaa Diu ki, molu rongo fasi! God na Aofia kia nee, nia taifili nia gu ne God. ");
INSERT INTO bvd_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","'O liosau 'ana God na Aofia kia 'ana liomu tiifau, ma 'ana mangomu tiifau, ma 'ana manata lamu tiifau, ma 'ana tetedea 'oe tiifau. ");
INSERT INTO bvd_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","'O liosau 'ana ta wane kau ka mala lau guu ne 'oe liosau 'ani 'oe tala'amu.’ Nao tasi baea fifii si 'initoa si talua roo si baea fifii nai ki.” ");
INSERT INTO bvd_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ma waa ni toolangaidoo nai 'ana taki sa Mosis ka bae 'urii fua sa Disas, “Waa ni toolangaidoo 'ae, 'oe olisi diana 'asia naa 'ana si ledi laa nai. Doo mamane naa nai 'oe saea God nee taifilia naa ne nia God ma ka nao naa ta God 'e'ete lau. ");
INSERT INTO bvd_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ma waa ka liosau 'ana God 'ana mangona tiifau, ma 'ana liona tiifau, ma 'ana tetede lana tiifau. 'Oko saea, waa ka liosau 'ana waa ki mala ne nia 'e liosau 'ani nia 'i tala'ana, ma si doo nai ka 'initoa ka talua faledoo lae ki sui naa ma afuafu lae ki sui naa fua God.” ");
INSERT INTO bvd_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Sa Disas 'e lio saitomana filodoo laa sa wala nai nia ka bae 'urii fuana, “'Oe nii karangia naa 'initoaa God nai.” Ma safali 'i seeri ka lea naa, nao ta waa si bobola lau fainia ka ledia sa Disas 'ana ta ledi laa lau. ");
INSERT INTO bvd_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Si kada sa Disas 'e toolangaidoo laona Beukaua God, nia ka ledi 'urii, “Tee ne adea waa ni toolangaidoo ki 'ana taki sa Mosis daka saea na Kraes nee nia na waa 'e futa gwana lao kwalafaa sa Defet? ");
INSERT INTO bvd_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Na Anoedoo Abu bae nia faabaea sa Defet ka bae 'urii, ‘God nia bae 'urii fua Aofia nau: 'O gooru ngado 'amu 'i bali aolo nau 'ana 'initoae, lelea ka dao si kada nau kwai ilia malimae 'oe ki 'oko 'inito faafi kera.’ ");
INSERT INTO bvd_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Sa Defet 'e tala 'ailia Kraes 'ana ‘Aofia’ nia. Doo ne adea guu, na Kraes nia nao lau otona gwana waa 'e futa gwana kau 'i buri lao kwalafaa sa Defet. Nia na Aofia sa Defet lau guu.” Na konia baita nai, kera daka ele 'asia naa si kada kera fafurongoa bae lana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ma si kada sa Disas toolangaidoo, nia ka bae 'urii, “Molu ka fiia toa ni toolangaidoo neki suli taki sa Mosis. Na liu kwailiu lae fainia maku kwanga diana tikwa neki maa usie ki, kera da ilia ka diana 'asia naa uri waa ki daka tango kera fainia. ");
INSERT INTO bvd_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ma lelea doo, si kada 'ana fafangaa ki ma lao beu ni ofu lae ki kera daka dooria 'ua guu gooru lae 'ana kula ni goorua kera waa 'inito ki. ");
INSERT INTO bvd_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ni kera 'ua gu ne toaa ni beli lana luma kera ai 'oru ki. Ma sui, kera daka foa 'ana foa laa tikwa ki 'asia naa uri waa ki ka tango kera fainia. Kera toaa 'uri nai ki ne God kai falea kwakwaea ne ta'aa 'isi lau fuada.” ");
INSERT INTO bvd_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sa Disas nia gooru karangia na kufidoo ni alu malefo lae, laona Beukaua God. Nia ka bubungia kada toae ki da falea malefo kera ki fua koni lana fua beukaua nai. Ma ka suana toaa 'oro suadoo da falea malefo baita ki. ");
INSERT INTO bvd_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sui lelea, nia ka suana tii gwa 'oru siofaa nai nia lea mai ka falea naa roo kaa miga malefo tu'uu nai ki. ");
INSERT INTO bvd_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ma 'uri nai, sa Disas ka 'ailia mai toa kwairooi nia ki siana, ka bae 'urii fuada, “Si doo mamana ku saea fuamolu 'e 'urii, gwa 'oru malania nee 'ana ne nia falea malefo ne baita ka talua malefo neki toaa neki sui guu da faa ki. ");
INSERT INTO bvd_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Suli toaa neki kera suadoo ki nee, kera fale gwada si orongadoe 'ana suadooa kera ki ne. Aia, gwa 'oru malania nee, nia fale tiifau naa 'ana malefo ne nia too ai, fua lao kufidoo loko ni faledoo.” ");
INSERT INTO bvd_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Si kada sa Disas 'e ruu 'i maa ka lea na kau fasi Beukaua bae, tii waa 'ana toa kwairooi nia ki ka bae 'urii fuana, “Waa ni toolangaidoo 'ae, 'o suana fasi 'amu gaafana fau baita neki fainia saungaia diana neki 'ana Beukaua nee wala!” ");
INSERT INTO bvd_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ma sa Disas ka luua ka 'urii, “Aia, 'oe suana beu baita saungai lana neki 'ana Beukaua nee nai? Totoo tii si kada nii 'ua kau, na talae fau neki sui guu dai atoli daka tagabola lelea ka sui, tasi fau boroi si gooru guu fafona ruana si doo 'ani kera.” ");
INSERT INTO bvd_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Aia, si kada sa Disas 'e gooru 'ana gwauna fa uo 'i 'Olif 'i bali loko lau guu 'ana Beukaua nai, sa Bita, sa Demes, sa Dion, ma sa 'Andru kera daka ledi aroaro 'ani nia daka 'urii, ");
INSERT INTO bvd_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“'O faarongo kameli fasi wala. 'I angita gu ne doo nai ki 'oe saea nai kai fuli ai? Ma na tee gu ne lelea meli suai 'e fuli ma kameli ka saitomana si kada nia naa doo nai ki uri ka fuli ai?” ");
INSERT INTO bvd_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ma sa Disas ka bae 'urii fuada, “Molu ka fiia ade lea ta waa ka suke kamolu ma ka talai garo 'ani kamolu. ");
INSERT INTO bvd_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Suli tee, na waa 'oro ne kera kai dao mai 'ana sataku ma kera dai bae 'urii, ‘Nau na Kraes bae naa ne!’ 'Uri nai guu ma kera daka talai garo naa 'ana toaa 'oro nai. ");
INSERT INTO bvd_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tasi doo lau, si kada kamolu rongo na omee ki da firu, ma nao molu ka rongo ununua 'oro sulia na omee nai ki, nao molu si mau lau. Na doo 'uri nai ki 'afitai ka nao lau, kera kai dao gu mai. Ma sui boroi 'ana, ade sae 'oko kwaifii 'amu sae sa sui lana doo ki naa nai. Nao 'ua nai. ");
INSERT INTO bvd_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Totoo bobongi ta fera 'e tatae ka firu gwana fainia ta ruana fera, ma ta waa 'inito fainia toaa nia da tatae lea daka alasia gwada ta ruana waa 'inito fainia toaa nia. Na anuanu lau guu kai liu 'ana bali fera 'e'ete ki sui, ma na uni fioloa ki kai liu 'ana kula 'oro. Fuli lana doo nai ki 'e mala gwana ta keni faafuta si kada nia kafi safali fiiwela guu. ");
INSERT INTO bvd_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Molu ka folo diana lau guu, suli kera kai fale kamolu fua lao 'abana toa rao 'i fera ki. Toae ki kera kai dau kamolu, daka ngali kamolu naa fua kwae lamolu. Kera kai nangasi kamolu 'i lao beu ni ofu lae ki, suli kamolu faamamane nau. Ma kera kai talai kamolu kau 'i maana waa 'inito ki fua didi lamolu lae. Ma 'i seeri kamolu kai faarongo kera 'ani nau. ");
INSERT INTO bvd_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ma ni kamolu molu kai bae fasi 'amolua sulia na Faarongoa Diana nee fua toae ki sui lao fera ne 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Si kada tee gwana kera dau kamolu, ma daka talai kamolu uri didi lamolu lae, nao molu si manata isifufuli lau suli si doo ne molu kai saea. Si baea ne Anoedoo Abu nia falea fuamolu 'ana si kada nai, nia naa ne molu kai saea. Suli na Anoedoo Abu 'ana ne kai bae, nao lau ni kamolu. ");
INSERT INTO bvd_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Totoo kau na waa ki dai falea gwada toolada ki fua saungi lada, ma na waa ni maa lae ki, kera dai ili 'uri nai lau guu 'ana wela kera ki. Ma na wele ki, kera dai ade faasia bae lana maa kera ki fainia gaa kera ki. Ma kera kai falea maa fai gaa kera ki fua saumaeli lada. ");
INSERT INTO bvd_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Toae ki sui gwana kera kai susubutai kamolu suli ne kamolu toaa nau. Ma sui boroi 'ana ka 'uri nai, waa ne faamamane nau ka ngado lelea ka dao 'ana sui lana doo nai ki sui guu, God kai faamauri nia. ");
INSERT INTO bvd_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Totoo lelea molu ka suana naa na doo sua bae kera dao daka faa uua naa laona lalo abu nee kula nao si bobola na uri ka uu ai, ma God ka lukasia naa beu nia.” ('Oe waa ni teemai lae 'oko filo diana 'ana doo nai.) “Ma lelea nia 'uri nai naa, toaa nee lao bali lolofaa nee 'i Diudia molu ka tafi na uri fa toloa ki. ");
INSERT INTO bvd_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ma 'ana si kada nai, tii ne 'oe 'o too mai 'i fafo lume, 'oko tafi namu. Nao 'osi dora lau 'ana sasi lae fai ruu lae mai luma kamu uri koni lana 'okodoo 'oe ki. ");
INSERT INTO bvd_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ma tii ne 'oe nii 'ua mai lao ole 'ana si kada nai, 'oko tafi na 'amu. Lelea maku baita 'oe ka nii boroi kau 'i luma kamu, nao 'osi oli lau mai uria, ka faadora 'oe. ");
INSERT INTO bvd_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ma si kada nai nia kai ta'aa 'isi fuada ai kulua ki fai ai faasusu ki, suli kai 'a'atola fuada uri tafi 'ali'ali lae. ");
INSERT INTO bvd_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Molu foa uri God ka nao si faolomainia uri fuli lae lau guu otofana si kada 'ana ute ma ka gwagwari'olaa. ");
INSERT INTO bvd_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Suli na 'afitaia nai kai ta'aa 'isi ka talua lau 'afitaia ki sui ne wane lao fera ne 'i saegano da saitomana ki, 'ita mai si kada God saungainia molaagali ka dao 'i tari'ina. Ma 'ita 'i tari'ina ka lea 'alaa naa, ta 'afitaia boroi nao si 'uria naa. ");
INSERT INTO bvd_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Lelea sae God ka nao si 'oikukuru 'ana si kada 'afitai nai, 'afitai ta waa ka mauri lau. Ma sui, uri nunufana gwana toaa fifilia nia ki, nia kai 'oikukuru 'ana si kada 'afitai nai. ");
INSERT INTO bvd_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Iuka, lea ta waa bae 'urii fuamolu, ‘Lea mai suana 'amolu, na Kraes bae gu ne,’ ma nao ka bae 'urii, ‘Lea molu suana 'amolu, nia nii 'i lobaa,’ nao molu si faamamanea. ");
INSERT INTO bvd_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Suli na brofet suke ki kera kai dao mai, ma kera kai ilia fafaataia ki ma doo ni kwele lae ki ai, uri sae lelea walude gwana ma kera daka talai garo 'ada 'ana toaa fifilia nia God, ma sui ka 'afitai. ");
INSERT INTO bvd_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Molu ka folo diana! Nau ku faarongo kamolu na kau 'ana doo ki 'ana taue nai. ");
INSERT INTO bvd_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ma si kada ne 'afitaia nai 'e sui, ‘God kai koko faafia maana sato fainia madama loo, ma keeru ka nao si tala folaa. ");
INSERT INTO bvd_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ma God kai taga 'ana bubulu loki, ma kera da kai 'asi kera fasi mamangaa. Ma nia kai tagabola 'ana doo loki lao salo, ma kera da kai tio garo fasi fulida ki.’ ");
INSERT INTO bvd_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Nia dao fatai 'i seeri, toae ki dafi suaku nau na 'Alakwa nia Wane, kufi dao faatai mai fainia rigitaa ma na rara laa baita tasa 'i fafona barobaro loo. ");
INSERT INTO bvd_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma nau kwai falea 'aini 'ensel nau fua laona fera ne 'i saegano tiifau, fua koni lana mai toaa fifilia nia ki God.” ");
INSERT INTO bvd_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Sa Disas ka saea tii si baea 'ana tarifula lae ka 'urii, “Molu manata fasi suli na 'ai nee na fig. Na fig, lelea kamolu suana nia 'e fufurua naa, kamolu saitomana uni sato nia karangi dao naa. ");
INSERT INTO bvd_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Talafana lau guu, lelea kamolu suana 'afitaia ta'aa 'isi 'oro nai ki kera dao naa, kamolu saitomana dao laku mai nia karangi naa. ");
INSERT INTO bvd_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Si doo mamana ku saea fuamolu 'e 'urii, uni wane nee 'i tari'ina kera dai mauri 'ua gwada, si doo nai ki sui gu ka fuli. ");
INSERT INTO bvd_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Salo loo fainia saegano nee totoo dai sui gwada. Aia, ma si baea ku saea ki 'afitai daka sui kaaroa naa. ");
INSERT INTO bvd_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nao ta waa si saitomana fa sato ma si kada ne nau kwai dao ai. Na 'ensel 'i salo ki nao dasi saitomana, ma ni nau 'Alakwa nia Wane boroi, nao kusi saitomana lau guu. God na Maa taifili nia gu ne saitomana. ");
INSERT INTO bvd_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Molu folo diana ma molu ka kwaimaasi, suli kamolu ulafusia si kada tee ne nia kai dao. ");
INSERT INTO bvd_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Na dao laku mai nia kai mala tii waa kada 'e faasia luma nia ka lea 'ana fera tau. Ma nia ka alua 'okona doo nia 'i 'abana waa ni rao nia ki. Nia tolingia si raoe ki fuada sui guu. Sui nia ka saea fua waa ni sua lae suli maesakaa, uri ka folo diana. ");
INSERT INTO bvd_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Doo ne adea guu, molu fiia, suli kamolu nao si saitomana si kada tee ne waa 'ana luma kai dao. Nia kai dao mai 'i saulafi nee, ma nao lao tofungana rodo nee, ma nao 'i 'ofaidani nee, ma nao 'i 'uubongi dani folaa naa. ");
INSERT INTO bvd_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ma lelea sae kamolu tona boroi nia ka dao 'ali'ali naa, tii maleu lae ne nao molu si ilia ade nia ka dao tomolu fainia. ");
INSERT INTO bvd_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Si doo ku saea fuamolu, ma fua toae ki sui gwana naa ne 'urii: Molu folo!” ");
INSERT INTO bvd_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Roo fa sato naa ne tio, sui ka dao 'ana Fangatasae, ma na Fafangaa ni 'ani lana beret nao isi ai. Ma na waa baita ni foa ki, fainia waa toolangaidoo ki 'ana taki, kera daka alu tii manataa sui naa, fua dau agwa lae 'ana sa Disas ma saungi lana uri ka mae naa. ");
INSERT INTO bvd_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Sui, kera daka bae 'urii, “Nao kolu si dau nia lau noni Fafangaa nee, ade lea toaa nee daka firu lau gwada fai kolu.” ");
INSERT INTO bvd_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Si kada sa Disas 'e nii 'i Betanii, ma ka fanga 'ana luma kera sa Saemon, waa nai furo 'e saungia 'i nao sui sa Disas ka guraa, tii wela keni nai ka lea mai ka dao. Na wela keni nai 'e ngali mai tii bii waiwai moko diana nai 'ana kafona naad taifilia naa ma liu lana ka baita tasa, ma ka nii mai lao kufi 'alabasta iriroa diana nai. Dao nia ka 'ifingia bii waiwai nai, ka kistainia naa waiwai moko diana nai lao gwauna sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","'I seeri, bali 'ana toaa ne da suai si doo nai, daka bae rakesasu daka 'urii fuada kwailiu, “Nia saketoa gwana waiwai moko diana loko nai rowaa! ");
INSERT INTO bvd_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Doo lea sae nia faafoli ai ma ka ngali malefo baita 'asia naa uri maana loko. Lea 'uri nai mone, nia ka falea malefo nai fua 'adomi lana toaa siofaa ki na.” Ma kera daka ngatafia naa wela keni nai. ");
INSERT INTO bvd_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Sa Disas ka bae 'urii fuada, “Alu too 'ana nia ilia 'ana na! Nao molu si bae tona lau 'uri nai. Si doo diane ne nia ilia na fuaku nee. ");
INSERT INTO bvd_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Na toaa siofaa ki da too siamolu ka lelea firi gwana. Ma lelea tasi kada boroi molu doori 'adomi lada, molu ka ilia gwamolu. Ma ni nau, tara ku too fai kamolu si tau guu. ");
INSERT INTO bvd_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ni wala nee, si doo nia bobola fainia ka ilia fuaku naa ne nia ilia sui naa nai. Nia kistainia waiwai moko diana nee 'i noniku uri ka ade akau na 'ana noniku maasia alu laku lao kilu gwau ne, uri lelea ku mae boroi nia ilia sui na 'ani nau. ");
INSERT INTO bvd_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Si doo mamana ku saea fuamolu 'e 'urii, 'ana si kula ki sui gwana ne kera dai bae sulia na Faarongoa Diana nee ai lao fera ne 'i saegano, si doo ne ni wala nee ilia fuaku kera dai bae lau guu sulia 'i seeri, uri manata toi lae.” ");
INSERT INTO bvd_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Sui sa Diudas 'Iskariot, na waa bae 'ana akwala ma roo waa ni kwairooi baki sa Disas, ka lea naa siana waa baita ni foa ki. Ma nia ka bae na 'urii fuada, “Nau kwai falea sa Disas fuamolu.” ");
INSERT INTO bvd_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ma kera daka ele 'asia naa suli doo nai nia saea, ma daka alangai naa uri faa lana si malefo fuana uri si doo nai. Ma sa Diudas ka safali nani naa uri tasi kada diana fua nia ka falea sa Disas fuada. ");
INSERT INTO bvd_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","'Afa dani totoonao 'ana Fafangaa bae ni 'ani lana beret nao isi ai, ma otofana lau guu si kada bae fua saungi lana kale sifsif bae 'ana Fangatasae, toa kwairooi baki sa Disas daka ledi nia. Ma daka 'urii, “'I fai ne 'oe dooria kameli lea meli kai kwaimaakwali 'ana doo ki ai uri 'oko fanga 'ana Fangatasae ne ai?” ");
INSERT INTO bvd_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Sa Disas ka bae 'urii fua ta roo waa ada, “Muru lea fasi kau 'i nao lao fera loko 'i Durusalem. Tara muru dao tona tii waa nia ngalia tii kufidoo fungu 'ana kafo. Kada kamuru dao tona 'uri nai, muru ka lea na 'i burina ");
INSERT INTO bvd_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","uri luma ne nia dao ka ruu 'i laona. Muru ka bae na 'urii fua waa nai 'ana luma, ‘Na waa toolangaidoo 'e ledi mai uri kadaluma tee bae nia fainia waa kwairooi nia ki dai fanga ai 'ana 'ani lana Fangatasae.’ ");
INSERT INTO bvd_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ma tara waa nai kai faatainia tii kadaluma 'i langi, kula doo ki sui naa nii ai. 'Uri nai guu, muru ka raodoo na fuakolu 'i seeri.” ");
INSERT INTO bvd_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Na roo waa kwairooi nai ki daru ka lea naa lao fera 'i Durusalem. Ma keeru daru ka liotoi doo ki fuli ka 'uria 'ua gu doo nai sa Disas saea ki kau fuadaru. Ma keeru ka raodoo na fuada maasia Fangatasae. ");
INSERT INTO bvd_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ma 'i saulafi gu mai, sa Disas ka dao na mai fainia akwala ma roo waa sarenga ni kwairooi nia ki. ");
INSERT INTO bvd_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ma si kada kera dau 'ana fanga lae 'ada, sa Disas ka bae na 'urii, “Si doo mamana ku saea fuamolu 'e 'urii, tii waa 'amolu nia kai fale nau 'i 'abana malimae ki. Waa nai 'e fanga kwaimani gwana fai nau 'i seki.” ");
INSERT INTO bvd_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ma 'uri nai guu toa kwairooi nai sa Disas ki daka safali liodila naa, ma daka ledi too tii waa naa 'ana sa Disas daka 'urii, “Ade sae nau gwana 'oto nai wala?” ");
INSERT INTO bvd_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Sa Disas 'e luu kera ka 'urii, “Ta waa 'amolu akwala ma roo waa sarenga ni kwairooi nau neki naa nai, ma nia waa nai 'e kurumainia lau guu si beret nia laona kufidoo ni fanga nee fai nau 'i seki nai. ");
INSERT INTO bvd_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ma ni nau 'Alakwa nia Wane, nau kwai mae naa uri si baea bae suli nau lao kekeda laa Abu ka mamana naa. Ma sui ta, na waa nai kai fale nau, 'Alakwa nia Wane, 'i 'abana malimae gu ne kai ta'aa ka tasa fuana! Ma lelea sae waa nai ka nao si futa 'ua gu mai mone, ka diana.” ");
INSERT INTO bvd_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ma si kada nai kera fanga naa, sa Disas ka samo mai uri fa beret nai ka tangoa God, sui ka niia naa. 'Uri nai sui nia ka faa kau fua toa kwairooi nia ki, ka bae 'urii, “Ngalia molu ka 'ania. Noniku naa ne.” ");
INSERT INTO bvd_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Sui lau guu, nia ka samo mai uri mae waen ni kuufi lana nai ka tangoa God, sui ka faa kau fuada. Ma kera sui guu daka kuu ai. ");
INSERT INTO bvd_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nia ka bae 'urii, “Na 'abuku naa ne, ne igwa fua toaa 'oro ki sui, ma ka igwa uri faangasi lana alangaia God. ");
INSERT INTO bvd_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ku faarongo mamana 'ani kamolu, 'ita 'i tari'ina ka oli 'alaa, tara nau kusi kuufia lau waen nee lelea ka dao naa 'afa dani nau kwai kuufia lau lao 'initoaa God.” ");
INSERT INTO bvd_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kera daka nguulia tii fa nguu 'i seeri lelea ka sui, kera daka lea naa uri fa uo bae 'i 'Olif. ");
INSERT INTO bvd_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sa Disas 'e bae lau gu fuada ka 'urii, “Kamolu tara molu kai tafi faasi nau ka sui guu. Suli na kekeda laa Abu 'e saea sui naa ka 'urii, ‘Nau kwai kwaea waa ni sua lae suli sifsif ki, ma sifsif ki kera kai tagala kwailiu.’ ");
INSERT INTO bvd_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Sui boroi 'ana ka 'uri nai, 'i burina nau kwai tatae fasi maea, nau kwai lea 'i nao kwai maasi kamolu 'i Galilii.” ");
INSERT INTO bvd_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ma sa Bita 'e luu nia ka 'urii, “Lelea toa nee daka tafi tiifau boroi 'ada faasi 'oe, nau gu ne 'afitai 'asia naa ku tafi faasi 'oe!” ");
INSERT INTO bvd_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ma sa Disas ka bae 'urii fuana, “Nau ku saea fuamu waa nau. Lao fa rodo ne 'i tari'ina 'ua gu ne, ni 'oe tara 'oko tofe nau 'ana olu si kada fatai, sui karai ruana kafi 'ai.” ");
INSERT INTO bvd_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ma sa Bita ka bae susuala ka 'urii, “Nau lelea daka saumaeli nau boroi fai 'oe, 'afitai nau ku tofe 'oe wala!” Ma ni kera daka saea sui guu tii si doo nai. ");
INSERT INTO bvd_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","'Uri nai sui, sa Disas fainia toa kwairooi nia ki, daka lea naa uri tii si kula satana 'i Getsamani. Dao 'i seeri, sa Disas ka bae 'urii fuada, “Kamolu too 'amolu 'i seki. Nau kwai foa 'akua nai.” ");
INSERT INTO bvd_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Sui nia ka talaia sa Bita, sa Demes, ma sa Dion daka lea fainia. Ma na liodila lae fainia isifufuli lae baita 'asia naa ka toli na faafi nia. ");
INSERT INTO bvd_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ma nia ka bae 'urii fuada, “Nau, na liodila lae fainia isifufuli laa baita 'asia naa 'e toli faafi nau. Kamolu too 'i seki, molu ka folo.” ");
INSERT INTO bvd_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nia lea kau nao si tau 'asia gu faasi kera, ka booruru na 'i saegano. Nia ka foa naa uri sae lea 'e walude gwana, nia ka nao si liu lau laona fii laa baita nai. ");
INSERT INTO bvd_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ma nia ka foa ka bae 'urii, “Maa 'ae, 'oe nao tasi doo si 'afitai fuamu. 'Idua 'amu fii laa nee faasi nau wala, uri nao kusi liu lau 'i laona. Sui boroi 'ana, doo ki ka fuli 'ana suli doori lamu. Nao lau suli doori laku.” ");
INSERT INTO bvd_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Sui nia oli mai 'e dao siana olu waa kwairooi nia baki, kera daka maleu 'ada. Ma nia ka bae 'urii fua sa Bita, “Saemon 'ae, 'utaa ne 'oko maleu gwamu wala? Bobola fainia sae ta tii si kada rodo tu'uu boroi 'oko folo mone 'amu ai.” ");
INSERT INTO bvd_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Sui nia ka bae 'urii fuada, “Kamolu folo 'ana foa lae, uri ka nao molu si 'asi kamolu lau laona ilitooe. Na mangoewane 'e dooria gwana si doo diane, ma sui ta noniwane ne makeso 'asia naa.” ");
INSERT INTO bvd_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","'Uri nai sui, nia ka faasi kera, lea ka foa lau gwana, ka saea lau guu tii si baea bae. ");
INSERT INTO bvd_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sui nia oli mai ka dao lau gu siada. Ma kera daka maleu 'ua gwada, suli maada ki mamaleua 'asia naa. Kera daka ulafusia naa sae lana ta doo fuana. ");
INSERT INTO bvd_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Oluna si kada nia oli mai ka dao lau gu siada, nia ka bae 'urii fuada, “Kamolu too molu ka maleu na 'amolua 'ua nee? Nia bobola na nai. Si kada bae dao gu nai. Suai fasi, nau 'Alakwa nia Wane, kera fale nau naa 'i 'abana toa ta'aa ki nai. ");
INSERT INTO bvd_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Molu tatae kolu lea naa. Waa bae fua fale laku 'i 'abana malimae ki ne dao naa nee!” ");
INSERT INTO bvd_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Si kada sa Disas kai bae gwana 'uri nai, sa Diudas, waa bae gwana 'ana akwala ma roo waa kwairooi nia ki, ka dao na mai fainia toa 'oro nai. Na waa baita ni foa ki, waa toolangaidoo ki, ma waa gwaungai ki ne fale kera daka lea mai. Ma toa nai daka dao sui gu mai fainia 'ile ki ma kile ni firu ki 'abada. ");
INSERT INTO bvd_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ma sa Diudas, waa nai kai fale sa Disas fuada, ka faarongo kera sui na mai 'ana si mamalafooa ni lio lae uria, ka bae mai 'urii fuada, “Lelea waa molu suai nau ku nonoia, waa nai kamolu dooria naa nai. Kada molu suai 'uri nai, molu ka dau nia molu ka talaia naa.” ");
INSERT INTO bvd_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Aia, kada kera dao guu, sa Diudas ka fali kau sia sa Disas ka bae na 'urii, “Nee Waa Toolangaidoo!” Ma ka nonoia naa. ");
INSERT INTO bvd_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Toa bae daka daua na sa Disas, ma daka karo nia naa. ");
INSERT INTO bvd_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ma si kada nai guu, tii waa 'ana waa da uu karangi 'i seeri ki, 'e lafua 'ila nia ka kwaea naa 'ana waa 'e rao fua waa foa ni gwau, ka siki muusia guu alingana sa wala nai. ");
INSERT INTO bvd_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sa Disas ka ledi 'urii 'ana toa bae, “Nee rowaa, nau ta waa ku talai garo 'ana toae fua taga lae 'ana fera nee 'oto ne? Nia ne molu ka lae mai uri dau laku 'urii fainia 'ile ki ma kile ni firu ki nee? ");
INSERT INTO bvd_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nau tee bae saku toolangaidoo mai fuamolu ka tau naa lao Beukaua loko, ma sui ka nao molu si dau nau guu. Ma sui ta, si doo ne kamolu ilia nee nia fuli 'ana 'urii, uri si baea bae lao kekeda laa Abu ka mamana.” ");
INSERT INTO bvd_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","'Uri nai guu, toa kwairooi nia bae tiifau kera daka tafi na faasi nia. ");
INSERT INTO bvd_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ma tii fa waa kafi daraa nai 'e kwairooi mai 'ana sa Disas 'e nii lau gu 'i seeri, ka ofi gwana 'ana si maku folo. Aia, si kada kera daua guu sa Disas 'uri nai, ");
INSERT INTO bvd_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","sa wala nai tona 'e tafi guu si maku nia ka luke, nia ka tafi dadara na 'ana faasia. ");
INSERT INTO bvd_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kera ka talaia naa sa Disas uri beu nia waa foa ni gwau. Ma waa baita ni foa ki, toa gwaungai ki fainia toa toolangaidoo ki 'ana taki, kera daka koni sui na 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ma sa Bita nia 'isi tau kau 'i buri lelea kau ka ruu lau guu laona lalo nai 'ana beu nai waa foa ni gwau. Nia gwagwari ka sara 'ana noni era nai 'i seeri fainia toa da fofolo ki. ");
INSERT INTO bvd_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na waa baita ni foa nai ki fai na gwaungaia ki tiifau naa, kera daka sasi naa uri dao lae tona tasi doo ne sa Disas ilia ka garo uri kera daka saumaeli nia na faafia, ma sui ka nao guu. ");
INSERT INTO bvd_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ma toa 'oro kera daka ilitoi suke lae faafia sa Disas, ma sui doo da saea ki ka nao si tio guu 'ana tii tio laa. ");
INSERT INTO bvd_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sui tai waa kera tatae lau guu, daka tako 'ana si ununua nai daka bae 'urii, ");
INSERT INTO bvd_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Kameli, si doo meli rongo nia tala saea 'e 'urii, ‘Nau kwai okosia Beukaua nee wane gwana saungainia nee, sui nau kwai saungainia ta Beukaua lau guu, ne nao lau doo wane gwana saungainia, lao ta olu fa sato gwana.’” ");
INSERT INTO bvd_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ma sui kera boroi, si tala baea nai da tatae mai fainia ka 'oroa lau guu ka nao si alu lau guu tii si doo. ");
INSERT INTO bvd_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ma na waa foa ni gwau nai tatae ka uu naa 'i maana konia nai ka ledia sa Disas ka 'urii, “Nee wala, 'oe nao 'osi too gu 'ana tasi doo ni sae lana suli doo nai ki da saea suli 'oe nai?” ");
INSERT INTO bvd_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ma sui sa Disas ka taaro gwana, ka nao si luua guu. Na waa foa ni gwau nai ka ledia lau ka 'urii, “Nee wala, 'oe nee na Kraes bae 'Alakwa nia God naa nee?” ");
INSERT INTO bvd_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Sa Disas 'e luu nia ka bae 'urii, “Iuka, nau naa ne. Ma ni 'oe nee tara 'oe suaku, 'Alakwa nia Wane, si kada nau kwai gooru 'i bali aolo nia God ne rigita tasa, uri 'inito lae, ma si kada nau kwai dao mai lao tofungana dasa loo ki mamangaa.” ");
INSERT INTO bvd_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Na waa foa ni gwau nai, rakena ngengeela liu ka karia gwana maku tikwa bae nia ofi ai. Nia ka bae na 'urii, “Tee lau ne kolu sasi fai talai lana mai waa ki uri bae lae lau suli sa wala nee? ");
INSERT INTO bvd_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Tee kamolu rongo gwamolu nia tala faabolatainia fai God nai! Kamolu manata 'utaa?” Ma kera sui guu konia nai daka saea nia garo naa, ma ka bobola na fainia daka saungia ka mae naa. ");
INSERT INTO bvd_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ma tai waa 'ada daka safalia naa ngisufi lana sa Disas. Kera daka karo suusia maana ma daka fidali nia naa. Ma daka bae na 'urii fuana, “'O bae ni brofet laa fasi mai fuameli!” Ma toa ni fofolo nai daka talaia kau daka dau na 'ana kwae lana. ");
INSERT INTO bvd_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Si kada sa Bita 'e nii gwana lao lalo fuu 'i saegano, ta tii saari 'ana saari nai ki da rao lao luma waa foa ni gwau ka liu kau siana. ");
INSERT INTO bvd_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ma si kada 'e suana sa Bita 'e sara 'ana noni ere, nia ka bubu ngasi 'ani nia ka bae 'urii, “'Oe waa bae 'o kwairooi lau gu mai fai sa Disas waa loko 'i Naasaret nee!” ");
INSERT INTO bvd_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ma sa Bita ka tofe ka bae 'urii, “Nau ku ulafusia waa nai. Dodoloa guu ku saitomana doo ne 'oe bae sulia nai.” Nia bae 'uri nai sui, nia ka ruu kau ka 'iia naa tafaa nai 'ana maesakaa nai lea na uri maa. ");
INSERT INTO bvd_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ma si kada na saari bae 'e suana lau gu 'i seeri, nia ka bae 'urii fua toa da uu 'i seeri ki, “Sa wala nee ta waa lau gu 'ada ne!” ");
INSERT INTO bvd_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ma sa Bita ruana ka tofe lau guu 'i seeri. Ma nao si tau lau gu, toa nai da uu karangi lau gu 'i seeri daka bae 'urii fua sa Bita, “Nia mamana 'asia naa, 'oe ta waa lau gu 'ada ne! Tee 'oe waa fasi bali lolofaa loo 'i Galilii lau gu nee.” ");
INSERT INTO bvd_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Sui sa Bita ka tofe ni maea ka 'urii, “Nau dodoloa mai 'ana God ku suke kamolu ne! Nau ku ulafusia waa ne molu kai bae sulia nee!” ");
INSERT INTO bvd_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Si kada nai 'ua guu, karai ruana ka 'ai naa. Ma sa Bita ka manata toi si baea bae sa Disas 'e saea mai fuana ka 'urii bae, “Tara 'oe 'amu olu fa tofe laku sui fatai karai ruana kafi 'ai.” Ma si kada sa Bita 'e manata toi si doo nai, nia ka angi lelea ka igigele guu. ");
INSERT INTO bvd_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","'I 'uubongi maakafukafua, na gwaungaia baki tiifau, 'ana waa baita ni foa ki, waa gwaungai ki, ma waa ni toolangaidoo ki 'ana taki, kera daka alu tii manataa sui naa suli si doo dai ilia 'ana sa Disas. Sa Disas, kera da karoa sui daka talaia na kau uri fale lana 'i 'abana sa Baelat. ");
INSERT INTO bvd_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Sa Baelat ka ledi na 'urii 'ani nia, “Nee wala, 'oe naa ne waa 'inito kera toaa nee Diu?” Sa Disas 'e luu nia ka 'urii, “Iuka, ma nia naa na 'oe saea nai.” ");
INSERT INTO bvd_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na waa baita ni foa ki daka saea naa sa Disas nia fulia mai si garo laa 'oro. ");
INSERT INTO bvd_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ma sa Baelat ka ledia lau ka 'urii, “Nee wala, 'oe tara tee ne 'oko saea suli doo 'oro nai ki da saea 'oe ilia ka garo nai?” ");
INSERT INTO bvd_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Sa Disas ka nao si bae guu, ma sa Baelat ka kwele lau gwana. ");
INSERT INTO bvd_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Aia, si doo lea toae gania sa Baelat ma nia kai ilia walude otofana kada 'ana Fangatasae nai ne, luke lana ta waa 'ana waa da too lao lookafo ki. ");
INSERT INTO bvd_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tii waa nai satana sa Baarabas ne nii lao lookafo otofana si kada nai. Waa nai nia waa sauwane suli 'e nii lao omee nai kera da firu uri taga lae 'ana 'initoaa 'i Rom. ");
INSERT INTO bvd_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","'Uri nai na konia baita nai daka ledia naa sa Baelat uri ka lukea mai ta tii waa fasi lao lookafo uri ka lea suli si birangaa nai. ");
INSERT INTO bvd_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ma sa Baelat ka ledi kera ka 'urii, “Aia, kamolu dooria nau ku lukea kau waa 'inito nee toaa Diu ki fuamolu nai?” ");
INSERT INTO bvd_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sa Baelat nia bae 'uri nai suli 'e saitomana gwana kera waa baita ni foa ki da talaia mai sa Disas siana, suli manata lada ta'aa fua sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ma sui boroi 'ana, waa baita ni foa ki kera daka bae alingana naa toaa nai, uri daka ledia sa Baelat uri luke lana mai sa Baarabas fuada. ");
INSERT INTO bvd_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ma sa Baelat ka ledi 'urii lau 'ana figua nai, “Sui ma tee 'ana ne nau kwai ilia 'ana waa ne kamolu saea 'ana waa 'inito Diu ki nee?” ");
INSERT INTO bvd_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ma kera daka 'ai daka 'urii, “Foto faafi nia 'ana 'airarafolo!” ");
INSERT INTO bvd_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Sa Baelat ka ledi kera lau ka 'urii, “Tee ne nia ilia ka garo?” Ma kera daka 'ai baita tasa lau, daka 'urii, “Foto faafi nia 'ana 'airarafolo!” ");
INSERT INTO bvd_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ma sa Baelat ka lukea naa sa Baarabas fuada, suli 'e dooria kai faaelea manata lana toaa nai. Sui, sa Baelat ka falea naa sa Disas uri daka nangasia, ma uri daka foto faafi nia naa 'ana 'airarafolo. ");
INSERT INTO bvd_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Na toa ni omee ki kera daka talaia na kau sa Disas laona lalo nai 'ana luma baita sa Baelat, ma kera daka karumainia mai toa ni omee nai ki tiifau. ");
INSERT INTO bvd_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kera daka faa ruufia naa sa Disas 'ana maku gogosala tikwa nai, sui daka 'e'erea tii 'eeregwaua 'ana 'oko kwakware daka alu 'i gwauna. ");
INSERT INTO bvd_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sui kera daka 'onionga 'ada 'ani nia daka saea kera faabaita nia daka bae 'ada 'urii, “Ele 'asia naa fuamu, 'oe waa 'inito kera toaa Diu!” ");
INSERT INTO bvd_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sui daka kidia gwauna 'ana si 'ai, daka ngisufi nia, daka booruru 'i maa 'aena daka 'onionga 'ada 'ani nia daka saea kera faa'inito nia. ");
INSERT INTO bvd_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Si kada kera da saso gwada 'ani nia 'uri nai lelea ka sui naa, kera daka tangasua lau gwada maku gogosala tikwa bae faasi nia. Sui daka faa ruufia lau gwada 'ana maku nia ki 'ua guu. 'Uri nai sui, kera daka talaia naa uri foto lae faafi nia 'ana 'airarafolo. ");
INSERT INTO bvd_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ma si kada kera da lea kau suli taale, kera daka dao tona tii waa nai satana sa Saemon fasi maefera 'i Saerin. Sa Saemon nia maa sa 'Aleksanda fai sa Rufus. Sa Saemon 'e too mai 'ana ta kula ka lea mai uri Durusalem ka liu lau gwana siada 'i seeri. Ma na toa ni omee nai ki daka suumainia naa uri nia ka ngali 'airarafolo sa Disas faasi nia. ");
INSERT INTO bvd_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kera daka talaia na kau sa Disas uri tii si kula satana 'i Golgota, toolangai lana, “Kula 'ana Lelete.” ");
INSERT INTO bvd_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ma kera daka faa waen nai da dolaa fai suluna doo nai satana na “Miira,” fua faagwari lana fii lae, ma sui sa Disas ka nao si kuufia guu. ");
INSERT INTO bvd_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Sui kera daka foto na faafi nia 'ana 'airarafolo. Ma kera daka tolingia maku nia ki fuada kwailiu. Ma kera daka saso 'ana tii doo mala dais nai uri daka tolingia maku nia ki fuada kwailiu. ");
INSERT INTO bvd_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Dao 'ana sikwana kada sato 'i 'uubongi, kera daka foto na faafi nia 'ana 'airarafolo. ");
INSERT INTO bvd_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ma kera daka kedaa tii si kekeda laa daka alu 'i gwauna 'airarafolo nai uri ka faatainia doo ne kera da keto nia fainia. Si kekeda laa nai ka bae 'urii, “Sa wala nee nia na waa 'inito kera toaa Diu.” ");
INSERT INTO bvd_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ma kera daka foto faafia roo waa da beli ki 'ana ta roo 'airarafolo ki 'i seeri fainia sa Disas. Ta 'airarafolo ne ta waa taru ai ka nii bali aolo, ta doo bali mauli. ");
INSERT INTO bvd_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ma na toaa da liu ki suli taala nai, kera da suana doo nai daka tataigwau ma daka saea doo ta'aa ki fua sa Disas, ma daka bae 'urii, “Wala 'ae! 'Oe bae 'o saea okosi lana Beukaua loko, ma sui 'oko saungainia gwamu suli olu fa sato ki bae! ");
INSERT INTO bvd_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","'O faamauri 'oe fasi tala'amu wala! 'Oe koso, 'amu fasi 'airarafolo nai!” ");
INSERT INTO bvd_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ma na waa baita ni foa ki fainia waa toolangaidoo ki 'ana taki, kera daka saea lau guu tii si doo nai. Ma kera daka bae 'onionga 'ada 'ana sa Disas, daka bae 'ada 'urii fuada kwailiu, “Toaa 'e'ete ki gwana bae nia faamauri kera ki, sui ma faamauri lana 'i tala'ana, nia nao si bobola gu fai ili lana! ");
INSERT INTO bvd_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Aia, alu nia Kraes, na Waa 'inito kera toaa Diu, nia koso 'ana faasia 'airarafolo loko uri kolu ka faamamane nia!” Ma roo waa baki da foto faafi keerua lau guu 'ana 'airarafolo ki fai sa Disas, daru ka saea lau gu doo ta'aa 'oro ki fua sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Na rorodoa lae ka dau na faafia fera nai tiifau, 'ita lao tofungana sato lelea ka dao lao oluna kada sato 'i saulafi naa. ");
INSERT INTO bvd_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Dao lao oluna kada sato 'i saulafi naa, sa Disas nia ka 'ai baita ka bae 'urii, “Eloi, Eloi, lama sabaktani?” Toolangainia, “God nau 'ae, God nau 'ae, 'utaa ne 'oko lukasi nau naa?” ");
INSERT INTO bvd_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Si kada toaa da uu 'i seeri ki da rongo nia bae 'uri nai, kera daka bae 'ada 'urii, “'O, nia 'ai uri sa 'Ilaeja nai!” ");
INSERT INTO bvd_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","'Uri nai guu, tii waa 'ada ka lae kau ka taufia mai tii sii doo lumulumua nai laona waen lifoo nai, sui ka alua gwauna saga 'ai nai ka faa kau uri maa ngiduna sa Disas uri nia ka notofia. Sui waa nai ka bae 'urii, “Kolu lio 'akolu fuana, alamia tara sa 'Ilaeja kai lea mai uri tangasu lana 'i saegano fasi 'airarafolo loko 'oto loko!” ");
INSERT INTO bvd_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Sui, sa Disas ka 'ai baita naa, sui na mangona ka liu naa. ");
INSERT INTO bvd_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ma na maku baita bae kera daurangainia ka suusia kau kada kula abu nai laona Beukaua bae, nia ka kari 'ita mai gwauna 'i langi lelea mai ka dao gu 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma tii waa baita ni omee nia ka uu gwana 'i seeri karangia 'airarafolo nai sa Disas nii ai. Si kada nia rongoa 'ai lana nai sa Disas, ma ka bubungia kwai mae laa nai nia mae ai, nia ka bae 'urii, “'E mamana 'asia naa, sa wala nee, nia 'Alakwa God mamana naa ne!” ");
INSERT INTO bvd_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Na bara wela keni bae daka uu tau gwada kau 'i seeri, daka bubungia gwada kau doo nai ki da fuli nai. Tai ai 'ani kera naa ne, ni Meri ai fasi maefera 'i Magdala, ni Meri gaa sa Diosis fainia sa Demes waa kafi baita bae gwana, ma ni Salome. ");
INSERT INTO bvd_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Bara wela keni nai da lea kwaimani lau gu mai fai sa Disas, 'ita mai Galilii ka lea mai, ma daka 'abaru mai 'ana sa Disas. Ma tai wela keni 'oro lau guu ne kera lea kwaimani mai fainia uri Durusalem, daka nii lau gu 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Dao naa 'i saulafi, sa Diosef waa nai fasi maefera 'i 'Arimatea, nia ka lea mai ka dao. Sa Diosef nia ta waa gwaungai lau guu 'ana toaa ne da too 'ana tii si manatae doo uri kwaimaakwali lae maasia 'initoaa God. Nia ka lea noniraa kau siana sa Baelat ka gani nia uri nonina sa Disas, suli fa dani nai fa dani 'ana ade akau lae maasia Sabat. ");
INSERT INTO bvd_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ma si kada nia faarongoa sa Baelat ne sa Disas 'e mae naa, sa Baelat ka kwele lau gwana. 'Uri nai, nia ka 'ailia mai waa baita ni omee nai, ka ledia uri ka dao toi diana ai lea sa Disas nia mae mamana naa. ");
INSERT INTO bvd_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ma si kada sa Baelat 'e rongo 'isi ai siana waa baita ni omee nai, ne sa Disas 'e mae mamana naa, nia ka faolomainia sa Diosef uri ka ngalia nonina sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","'Uri nai, sa Diosef ka folia tai maku kwakwaoa ki sui ka lafua mai nonina sa Disas 'i saegano, ka 'afua naa 'ana maku nai ki, sui nia ngali ka alua naa laona likwafau baita garu lana nai. Sui sa Diosef ka gelua mai reba fau baita nai ka bilakia naa 'ana likwafau nai. ");
INSERT INTO bvd_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ma ni Meri ai nai fasi Magdala fainia ruana Meri nai gaa sa Diosis, keerua daru ka suai gwadarua si kula nai kera da saufinia sa Disas ai. ");
INSERT INTO bvd_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","'I burina naa Sabat, ni Meri ai nai fasi Magdala, ni Meri nai gaa sa Demes ma ni Salome, kera lea daka folia naa doo moko diana ki fua alu lana faafia nonina sa Disas. ");
INSERT INTO bvd_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Aia, 'i 'uubongi maakafukafua 'afa sato totoonao 'ana wiiki si kada na sato 'e nao si tae 'ua mai, kera daka lea naa uri maana likwafau ni alu wane bae. ");
INSERT INTO bvd_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Si kada kera lea kau, kera daka ledi kera kwailiu daka bae 'urii, “Tii naa ne tara ka 'idua reba fau bae fasi maana likwafau loko nee?” ");
INSERT INTO bvd_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ma sui, si kada kera dao daka lilio 'alaa kau, kera daka suana reba fau talingai bae da gelua ka tio 'e'ete na kau fasi maana likwafau bae. ");
INSERT INTO bvd_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ma si kada kera da ruu kau lao likwafau baita nai, kera daka suana tii waa kafi baita nai 'e ruufia maku kwakwaoa nai, ma ka gooru gwana 'i bali aolo lao likwafau nai. Ma kera daka mau 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma nia ka bae 'urii, “Nao molu si mau lau. Nau ku saitomana kamolu molu nani gwamolu uri sa Disas waa bae 'i Naasaret, bae kera foto faafi nia 'ana 'airarafolo na. Nia 'e tatae naa faasia maea, ka nao si nii na 'i seeki bae! Molu suai 'amolu si kula bae kera alu nia ka tio gu ai ne! ");
INSERT INTO bvd_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Molu lea naa sia sa Bita fai toa kwairooi nia baki, molu ka bae 'urii fuada, ‘Sa Disas nia lea na kau 'i nao uri ka maakwali kamolu 'i Galilii. Tara kamolu kai suana 'i seeri, 'uri bae nia saea mai fuamolu bae.’” ");
INSERT INTO bvd_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ma na bara wela keni nai da tona daka lelebe daka ruu na 'i maa, ma daka tafi na fasi likwafau ni alu wane nai. Kera ka nao dasi faarongoa lau ta waa, suli da mau 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Si kada nai sa Disas 'e tatae fasi maea, 'i 'uubongi maakafukafua 'afa sato totoonao bae 'ana wiiki, ni Meri nai fasi Magdala 'ana ne sa Disas safali dao faatai mai ma nia ka suana. Ni Meri nai fasi Magdala, sa Disas 'e taria mai fiu anoedoo ta'aa ki faasi nia 'i nao. ");
INSERT INTO bvd_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ma ni Meri nai lea ka dao siana toa kwairooi baki sa Disas 'ana si kada nai kera da too 'ua gwada 'ana liodila lae 'i burina ma angisi lana sa Disas. Ma ni Meri lea ka faarongo kera. ");
INSERT INTO bvd_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ma si kada nai, kera daka rongo sulia sa Disas 'e tatae naa faasi maea ma ni Meri ka suana sui na mai. Sui boroi 'ana, kera nao dasi faamamanea guu. ");
INSERT INTO bvd_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Sui, 'i burina lau guu, sa Disas ka dao faatai mai sia ta roo waa 'ana toa kwairooi nia baki daru ka suana lau guu. Ma keerua daru ka lio lalafusi nia 'ana si kada keerua daru lea kau suli tala nai ma daru ka dao tona. ");
INSERT INTO bvd_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Roo waa nai ki keerua oli mai dao daru ka faarongo ai siana toa kwairooi nai ki tiifau. Sui boroi 'ana kera nao dasi faamamanea guu. ");
INSERT INTO bvd_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Sui, 'i burina lau guu, sa Disas ka dao faatai mai siana akwala ma tii waa sarenga kwairooi nia ki, kada kera fanga 'ada. Ma nia ka ngatafi kera faafia abu faamamane laa kera nai, nia ilia ma manata lada ka sadi, ma ka nao dasi faamamanea bae lana toaa baki da suana mai burina nia tatae naa faasia maea. ");
INSERT INTO bvd_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ma nia ka bae 'urii fuada, “Molu lea 'ana kule ki sui guu lao fera ne 'i saegano molu ka faarongo talo 'ana Faarongoa Diana nee fua toae neki sui guu. ");
INSERT INTO bvd_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ma tii boroi 'ana ne nia 'e faamamanea ma ka siuabu, God kai faamauri nia. Ma tii boroi 'ana nia nao si faamamanea na Faarongoa Diana nai, God kai falea kwakwaea fuana. ");
INSERT INTO bvd_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ma na toaa ne kera faamamanea na Faarongoa Diana nai, kera da kai fulia doo kwaibalatana 'urii ki: Kera da kai taria anoedoo ta'aa ki 'ana sataku, ma ni kera da kai bae 'ana baea falu ki. ");
INSERT INTO bvd_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ma kera da tala'ana da kai rao gwada uri baekwa 'a'ale ki, ma si kada kera kuufia boroi doo bubulo ki, nia si bulo maeli kera guu. Kera dai alua 'abada faafia toaa matai ki, ma kera daka 'akwaa.” ");
INSERT INTO bvd_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Si kada sa Disas na Aofia nia bae fai kera lelea ka sui nia raa ka lea naa uri fera 'i salo, ma ka gooru naa 'i bali aolo nia God 'ana 'initoaa. ");
INSERT INTO bvd_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Sui guu, toa kwairooi nia baki kera lea daka faarongo tatalo naa 'ana Faarongoa Diana bae 'ana kula ki sui gwana. Ma na Aofia ka rao na fai kera, ma ka faatainia naa mamana lana bae lana 'ana kada doo kwaibalatana ki fuli. ");
INSERT INTO bvd_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","'O Tiofilas 'ae, na waa 'oro ki da kedaa sui na mai ununua sulia doo neki sui guu sa Disas nia ilida ki mai 'i malutameli. ");
INSERT INTO bvd_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kera da kekeda sulia doo nai ki da rongo faasia waa da tala soi mai doo nai ki kada kera fuli, toa nai ki da tala rongo mai doo ki, kera unu sulia doo nai ki fuameli. ");
INSERT INTO bvd_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nia ne adea ku faarongo 'oe kau Tiofilas, 'oe waa 'inito kani. Nau ku manata toi 'e diana, fua nau 'i tala 'aku ku kekeda lau guu sulia doo nai ki fuamu. Nau ku doori alu aoloa kau 'ana ununua nee fuamu, sulia nau tala 'aku ku filo diana ai. Doo ne adea ku filo diana ai, sulia nau ku fafurongo diana mai sulia ununua nai, 'ita 'ana safali lana lelea mai ka dao 'ana sui lana. ");
INSERT INTO bvd_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nau ku kekeda sulia doo nai ki fuamu, uri 'oko tala saitomana 'amu mamana lana doo nai ki sui guu kera toolangainia mai siamu. ");
INSERT INTO bvd_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","'Ana kada sa Herod nia 'inito fua bali lolofaa 'i Diudia, tii waa ni foa ne satana sa Sakaraea nia too lau guu 'ana kada nai. Sa Sakaraea nia waa ni foa fulingana arai ni foa ne satana sa 'Abida. Na 'afe sa Sakaraea, ni 'Elisabeti, nia wela keni lau guu fasi kwalafaa sa 'Aaron, arai ni foa ni gwau bae toolana sa Mosis. ");
INSERT INTO bvd_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Na roo maakwaina nai ki, keeru abulo 'o'olo 'i maana God, sulia nao daru si ilia tasi doo si garo 'ana ade lae sulia taki Aofia ki ma si baea fifii nia ki tiifau. ");
INSERT INTO bvd_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Sui ta, ni 'Elisabeti ne nia 'aba'ato ma keeru ka nao daru si welaa guu. Ma ka ta'aa ka fafonaa lau, keeru sui guu daru waro naa. ");
INSERT INTO bvd_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Totoo tii fa dani, arai sa Sakaraea, nia kai rao 'ana fua God lao Beukaua bae, sulia nia na waa ni foa. Nia fai waa ni foa neki da rao kwaimani ki, si kada nai si kada kera naa fua rao lae 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kera da rao gu kau 'uri nai, daka nenee naa mala 'ana ne 'ita daka ilia na mai lao foaa kera ki, fua dao lae tona sa tii ada ne kai ruu kau lao kadabeu lalo 'i lao Beukaua nai. Kada da ili 'uri nai guu, na nenee laa nai ka 'asia naa faafia arai sa Sakaraea uri nia ka ruu kau lao kadabeu lalo nai, uri suungi lana doo moko diana ki 'i laona. ");
INSERT INTO bvd_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Si kada ne nia roo 'ana suungi lana doo moko diana nai, na konia baita ne kera koni kau 'i maa, daka too 'ana foa laa. ");
INSERT INTO bvd_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ma 'ana si kada nai guu, na 'ensel nia God ka sakatafa faatai mai ka uu gu 'ana 'i bali aolo 'ana fuliere nai ni suungi lana doo moko diana ki ai. ");
INSERT INTO bvd_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kada sa Sakaraea, 'e suana 'ensel nai, nia 'e tona baita ka mau 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Sui boroi 'ana, na 'ensel nai ka bae 'urii fuana, “Sakaraea, nao 'osi mau lau! God nia rongoa naa foa laa 'oe. 'Afe 'oe ni 'Elisabeti nia kai kulua kai kwalafia tii wela wane. 'Oe 'oko 'ailia wela nai, satana sa Dion. ");
INSERT INTO bvd_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kada wela nai 'e futa, ni 'oe 'oi ele 'oki noni sasala tasa, ma toaa 'oro kera kai ele lau guu suli nia, ");
INSERT INTO bvd_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","sulia na wela nai nia na wela 'initoa nia God. Wela nai kai abu 'ana kuufi lana waen, ma nao ta kafo ne kai faa gwaulilinge nia. Ma kada nia nao si futa 'ua boroi mai, na Anoedoo Abu ka funguli nia 'ua guu. ");
INSERT INTO bvd_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nia naa ne kai olitainia mai toaa 'oro 'i 'Israel uri oli lae mai talea God kera. ");
INSERT INTO bvd_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ma nia naa ne kai dao mai 'i nao sui fatai Aofia kafi dao mai. Ma nia kai ili raoa lao mamanaa bae brofet 'Ilaeja nia totoo ai 'i nao. Nia kai bulasia manata lana waa ni maa lae ki fua kera oli daka liosau lau 'ana wela kera ki. Ma fua nia ka bulasia manata lana toaa ade faasia ki fua kera oli daka fafurongoa lau si baea manata faasia toaa abulo 'o'olo ki. Ma fua nia ka ade akau 'ana toaa ne kera kai kwaimaakwali maasia dao lana mai Aofia.” ");
INSERT INTO bvd_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sa Sakaraea, nia ka bae 'urii fua na 'ensel nai, “Nau ku ulafusia 'asia naa sae uri si doo nai lelea ka mamana wala, sulia nau ku waro naa, ma na 'afe nau boroi, nia waro naa!” ");
INSERT INTO bvd_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Na 'ensel nai, 'e luu nia ka bae 'urii, “Wala 'ae, nau sa Gebrel naa ne, nau waa 'ita ku too na fai God ne. Ma nia naa ne odu nau mai fua faarongo lamu asi faarongoa diana nee. ");
INSERT INTO bvd_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ma lea 'oe 'osi faamamanea guu na doo neki ku faarongo 'oe ai nee, ne totoo dai fuli na mone asi kada ne da gwalua fuai, tama fakamu nia kai 'ato nai. Ka nao 'osi bae tafa guu lelea ka dao naa asi kada doo neki kai fuli ai.” ");
INSERT INTO bvd_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Toaa nai ki daka maasia gu 'ada sa Sakaraea, ma daka too lelea kera ka kwaikolai naa 'ana doo ne adea nia too mai ka tau 'asia naa lao Beukaua loko. ");
INSERT INTO bvd_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kada nia ruu mai maa ka lea mai ka dao siada, na fakana 'e 'ato ka nao si bae tafa naa fuada. Ma kera ka manata toi 'ada sae sa nia 'e suana mai ta faataia lao kadabeu lalo loko, ne ka adea nia nao si bae tafa naa, ma toka kwaikaru ka faatai 'aba ki na 'ana fuada. ");
INSERT INTO bvd_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Aia, nia ka dao naa asi kada fua nia fai toa ne kera rao kwaimani ki lao Beukaua bae fua kera ka faasuia raoe ai, nia ka oli na kau 'i luma kera. ");
INSERT INTO bvd_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","'I burina si doo nai 'e fuli, nia fai 'afe nia ni 'Elisabeti keeru ka too lelea guu, 'afe nia ka safali kulua naa. Ma ni 'Elisabeti ka too banitai gu 'ana 'i luma keerua sulia lima madama ki. ");
INSERT INTO bvd_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ma too nia ka bae 'urii, “Si doo God nia ilia fuaku sulia nia manata toku ne. Ne nia 'e taga 'ana noni susuala laa baita bae nau ku too mai laona 'i maana konia nau, bae nau ku 'aba'ato!” ");
INSERT INTO bvd_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Aia, kera too kau lea ka dao naa 'ana onona madama ni 'Elisabeti nia 'e kulua sulia, God ka odua 'ensel Gebrel ka lea lau gu mai uri kasi maefera nai 'i Naasaret, ne nii lao bali lolofaa 'i Galilii. ");
INSERT INTO bvd_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Sa Gebrel nia ngalia mai si faarongoa fua tii wela keni saarii da ala'ato 'ani nia 'i seeri ne kera alufaafia fua tii waa da 'ailia 'ana sa Diosef. Sa Diosef nia futa 'ana kwalafaa sa Defet na waa 'inito bae. Na wela keni saari nai satana ni Meri. ");
INSERT INTO bvd_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Na 'ensel nai 'e dao ka bae 'urii fuana, “Sato diana kau fuamu wala, God nia 'ofe 'oe ma ka nii fai 'oe!” ");
INSERT INTO bvd_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kada ni Meri 'e rongoa na 'ensel 'e bae 'uri nai, nia manata lana ka tona ka nanisia naa malutana si baea nai. ");
INSERT INTO bvd_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Na 'ensel ka bae 'urii fuana, “Meri 'ae, nao 'osi mau lau, sulia God nia 'ofe 'oe. ");
INSERT INTO bvd_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ni 'oe, 'oki kulua 'oko kwalafia tii wela wane. 'Oko 'ailia satana wela nai 'ana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Wela nai nia kai 'inito, ne kera kai saea nia 'alakwa God na gwautasaliu. Ma God kai faa'inito nia mala koko nia sa Defet. ");
INSERT INTO bvd_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Na wela nee kai 'inito ladoa totoo si sui fua toaa Diu, kwalafaa sa Diakab!” ");
INSERT INTO bvd_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ni Meri nia ka bae 'urii fuana 'ensel nai, “Nau na wela keni saarii sakwadoloa nee, si doo ne 'oe saea nai, tara nau ku kulua 'utaa gu 'aku 'ana wele nai?” ");
INSERT INTO bvd_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Na 'ensel 'e olisi nia, ka bae lau 'urii, “Na Anoedoo Abu 'ana ne nia kai sifoli 'oe, ma na rigita lana God ne 'inito tasa, nia 'ana ne kai nunufi 'oe. Doo nai ne adea ma kera kai 'ailia wela abu nee 'ana 'Alakwa God. ");
INSERT INTO bvd_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","'O liotoi fasi too lamu ni 'Elisabeti bae da saea nia 'aba'ato, ma ka waro naa ka 'afitai naa fua kwala wela lae. Nia loko 'e iana naa 'ana wela wane ka ladea naa onona madame nia nai. ");
INSERT INTO bvd_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Si doo nai 'e fuli gu 'ana uri ka faatainia ne dodolofia tasi doo ka 'afitai kaaroa 'ana God fua ili lana.” ");
INSERT INTO bvd_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ni Meri ka bae na 'urii, “Ni nau na wela keni rao nia God naa ne. Alu doo nai ki 'oe faarongo nau ai ki sui guu, da fuli nada 'ani nau ilingia ne 'oe saea nai.” Kada ni Meri nia bae 'uri nai sui guu, na 'ensel nai ka lea na 'ana faasi nia. ");
INSERT INTO bvd_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","'Ana kada nai burina ni Meri nia rongo sulia si faarongoa nai 'e sui, nia tatae, 'ali'ali ka lea naa uri tii kasi maefera nai lao tolo nai ki 'ana bali lolofaa 'i Diudia. ");
INSERT INTO bvd_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kada nia lea kau ka dao 'i maefera nai, nia ka ruu 'i luma kera sa Sakaraea, ka bae diana kau tale ni 'Elisabeti. ");
INSERT INTO bvd_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ma si kada ni 'Elisabeti nia rongoa fatai na bae lana ni Meri, na wela nai ni 'Elisabeti 'e kulua ai nai, 'e tona ka agara 'ua guu lao rakena. Ma na Anoedoo Abu ka fungulia naa ni 'Elisabeti, ");
INSERT INTO bvd_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ma nia ka bae baita ka bae na 'urii, “'Oo Meri wela keni nee 'ae, diana tasa 'asia naa fuamu ka talua keni na fere ki sui, ma ka diana 'asia naa lau guu fuana wela nee 'oe kulua ai ruruumu. ");
INSERT INTO bvd_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Si doo 'e baita tasa ka nao kusi bobola fainia, ne ni 'oe na gaa nia Aofia nau 'o lea mai 'oko tala dao toku gu 'urii! ");
INSERT INTO bvd_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Suli nau, si kada bae ku rongoa kau lingemu 'o bae mai tale nau, na wela nee 'i ruruuku boroi 'e ele ka 'igi baita guu. ");
INSERT INTO bvd_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","'E diana tasa fuamu wela keni nee, sulia ni 'oe 'o faamamanea si baea God totoo kai fuli mala ne kera faarongo 'oe ai.” ");
INSERT INTO bvd_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ni Meri ka bae lau 'urii, “'I lao mauria nau tiifau, nau ku sili sulia God, ");
INSERT INTO bvd_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ma 'i lao mangoku sui naa, nau ku ele suli God nia faamauri nau. ");
INSERT INTO bvd_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nia 'e manata toku ai ni rao nia, boroi 'ana nau gwa ai mala nia gwana. Suai fasi nai, 'ita 'i tari'ina ka oli 'alaa, toae ki sui da kai saea nau ai 'e diana tasa 'asia naa fuaku, ");
INSERT INTO bvd_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","suli God nia ilia doo talingai ki fuaku 'ana rigitaa nia. Na satana 'e abu. ");
INSERT INTO bvd_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nia 'e 'ofea toae ki sui guu ne kera sae'inito 'ani nia, ta unitae wane nao si ore. ");
INSERT INTO bvd_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","'I lao ilidooa nia ki, nia 'e faatainia tetedea nia ka tagalangainia toaa ne kera manata naunau ki. ");
INSERT INTO bvd_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nia 'e faakosoa mai waa 'inito ni maungi lada ki 'i saegano faasi 'initoaa kera ki, ma ka tafoa mai waa mala kera ki 'i langi daka 'inito. ");
INSERT INTO bvd_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nia 'e sangonia toaa fiolo mae ki 'ana doo diana ki, ka olitainia kau toaa suadoo ki daka oli gu 'ada fai otona sae 'aba ki. ");
INSERT INTO bvd_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Nia 'e 'adomi kolu mai toaa 'Israel ki ne kolu toaa ni rao nia, sulia 'e manata toi alangaia nia fua kokoo kia ki mai 'i nao, 'uri bae nia saea kai faatainia kwai'ofeia nia fua sa 'Abraham fai kwalafaa nia ki ka lelea firi.” ");
INSERT INTO bvd_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Aia, ni Meri nia too kwaimani fai ni 'Elisabeti sulia bobola fainia ta olu madama lau sui nia kafi oli na 'i fera kera. ");
INSERT INTO bvd_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ni 'Elisabeti nia too kau lelea ka dao 'ana si kada nia naa fua faafuta lae, nia ka faafutaa na wela wane. ");
INSERT INTO bvd_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Toaafuta ma toaa kwaimani nia ki daka ele 'asia naa kada kera rongoa doo diana nai God 'e ilia fuana. ");
INSERT INTO bvd_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kada wela nai 'e dao naa 'ana kwaluna maedani nia, kera daka lea na mai uri daka 'iri'unga 'ani nia sulia doo na taki kera toaa Diuda ki saea, ma kera daka dooria faasata lana 'ana satana maa nia sa Sakaraea. ");
INSERT INTO bvd_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ma sui, gaa nia ka nao si ala faafia, ka bae 'ana 'urii fuada, “Nao molu si 'aili nia lau 'ana satana maa nia, nao! Molu 'aili nia 'amolu 'ana sa Dion!” ");
INSERT INTO bvd_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Toaa nai ki tiifau kera luu nia daka 'urii, “Nee wala, nao ta waa 'ana kwalafaa kamuru dasi 'aili nia 'ua gu mai 'ana satae doo nai!” ");
INSERT INTO bvd_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","'I seeri kera ka kwaikaru 'ana 'abada fua maa nia wela nai, arai sa Sakaraea, kera ka leditona uri satae doo ne nia dooria daka 'ailia 'ana wela nai. ");
INSERT INTO bvd_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Guu nia kwaikaru fuada, ka gani kera uri daka faa kau ta reba doo ni kekeda lae 'i fafona uri nia ka kekeda ai. Kada nia kekeda, nia ka faarongo 'urii, “Na wela nee, satana sa Dion.” Toaa nai ki tiifau kera daka kwele 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ma asi kada nai guu, na faka sa Sakaraea 'e alube nia ka bae tafa naa. Nia ka tangoa na 'ana God. ");
INSERT INTO bvd_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ma na toaa nai ki tiifau kera koni mai 'i seeri, kera da kwele daka mae 'ada. Ma 'i seeri na faarongo lae sulia doo nai ki ka talofia maefera nai ki tiifau lao tolo 'i seeri, 'ana bali lolofaa 'i Diudia sui guu. ");
INSERT INTO bvd_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ma na toae ki sui guu ne da rongoa doo nai ki, kera ka manata sulida daka bae 'urii, “Na wela nee mone bobongi nia baita, nia nao lau ta waa mamala wela ne rowaa!” Kera bae 'uri nai, sulia kera saitomana na tetedea God 'e nii fai nia. ");
INSERT INTO bvd_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Na Anoedoo Abu ka faabaea sa Sakaraea maa sa Dion, nia ka silia God ka bae 'urii, ");
INSERT INTO bvd_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Kolu tangoa God na Aofia kolu nee toaa Diu ki kolu foosia. Nia 'e lea mai fua 'adomi laka toaa nia ki, ma ka faamauri kia. ");
INSERT INTO bvd_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nia 'e falea mai waa tetede ni kwai faamauri kia, ne futa mai 'ana kwalafaa waa 'inito kia sa Defet, na waa rao nia God, ");
INSERT INTO bvd_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","'uri bae nia bae 'ana brofet abu nia ki 'i nao ka alangainia sui na mai. ");
INSERT INTO bvd_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nia 'e alangai uri kai faamauri kia faasia malimae kia ki, ma kai tafalangai kia faasia toaa neki manata lada ta'aa fuaka. ");
INSERT INTO bvd_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nia 'e alangai fua kokoo kia ki mai 'i nao, nia kai faatainia kwai'ofeia nia fuaka, ma kai manata toi na alangaia abu nia fai kera. ");
INSERT INTO bvd_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Na alangaia abu nia fua kokoo kia sa 'Abraham 'ana kada 'i nao, ne nia kai lafutai kia faasia 'abana malimae kia ki, ");
INSERT INTO bvd_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","fasi uri kolu ka rao fuana ma kolu si mau lau 'ana malimae kolu ki, ");
INSERT INTO bvd_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ma uri kolu ka too 'o'olo na 'akolu 'i maana ka lelea firi.” ");
INSERT INTO bvd_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sa Sakaraea nia oli ka bae 'urii fua 'alakwa nia sa Dion, “Ni 'oe na wela nau, toae ki dai 'aili 'oe 'ana brofet nia God ne 'inito ka talua doo ki sui. 'Oe 'o eta dao mai 'i nao 'ana Aofia nee, fasi uri 'oko faarongoa toae ki kera ka ade akau 'ana too lada maasi nia. ");
INSERT INTO bvd_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ni 'oe 'oko faarongoa toaa nia ki, ne God kera nee kai faamauri kera kada nia manata lukea ade garoa kera ki. ");
INSERT INTO bvd_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","God ne 'inito ka tasa nia kwai'ofei tasa. Ma fafona kwai'ofeia nia, nia kai faa mai na Waa Kwai Faamauri. Na waa nai, dao lana mai kai mala 'ana sato loo nia afuraga mai 'aena salo ka tala faafi kia, ");
INSERT INTO bvd_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","uri ka faa folaalia manata lana toaa kera too lao rorodoa lae 'ana maee. Ma ka kwesu folaa tala 'ae kolu uri fali lae lao aroaroa 'ana too kwaimani lae fai God.” ");
INSERT INTO bvd_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Sa Dion na wela nai, nia ka baita ka lea 'alaa, ma na manata lana ka rafo. Kada nia baita naa, nia ka too gu 'ana lao fera kwasi, lelea ka dao 'ana kada nia fua saka faatai lae ai 'i maana toaa nia 'Israel. ");
INSERT INTO bvd_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Aia, 'i burina na sa Dion 'e futa nao si tau guu, na waa gwaungai nai 'ana 'initoaa baita 'i Rom ne satana sa Ogastas, nia alua tii si baea fifii fua toae ki sui guu lao 'initoaa nia. Si baea fifii nai 'e saea toae ki sui guu kera kai oli uri maefera 'i 'aena fera kera ki fua keda sata lae ai. ");
INSERT INTO bvd_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ma na keda sata lae nai gu ne etana guu keda sata lae kera 'i otofana kada sa Kuirinias nia 'inito fua Siria brofens. ");
INSERT INTO bvd_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","'I seeri guu, toae ki tiifau kera ka lea naa fua keda sata lae 'i 'aena fera kera ki 'ua guu. ");
INSERT INTO bvd_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Aia, ma sa Diosef nia lau guu 'e lea kau faasi maefera 'i Naasaret lao bali lolofaa 'i Galilii, ka lea na kau uri bali lolofaa 'i Diudia. Nia lea kau uri 'i Betlehem, na maefera sa Defet na waa 'inito kera. Nia 'e lea kau 'i seeri sulia nia na waa 'e too 'i fuli sa Defet. ");
INSERT INTO bvd_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Sa Diosef nia lea kau fua keda sata kwaimani lae fai ni Meri, na wela keni nai kera alufaafia fuana, ma ka kulua naa 'ana wela 'ana kada nai. ");
INSERT INTO bvd_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ma asi kada keeru dao daru ka too guu 'i Betlehem, ni Meri ka fiiwela naa uri faafuta lae. ");
INSERT INTO bvd_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ma kada nia faafutaa na ulunao nia nai sui, nia ka 'afua naa 'ana maku ki, sui ka egwalaa wela tio 'ana lao kwade doo buluka ki ni fanga, sulia 'e nao naa tasi kula ni too lau 'ana ta luma lao maefera nai ne tala'ana keeru ka foli talana fua too lae ai asi kada nai. ");
INSERT INTO bvd_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ma na toa ne da suasulia sifsif ki, kera too karangia gu 'ada maefera nai. Kera too dai sua 'ada sulia sifsif kera ki 'i lao fa rodo nai. ");
INSERT INTO bvd_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ma 'i seeri tii 'ensel nia God ka sakatafa faatai mai kera ka suana, ma na kwesu talingai nia ka rara na faafi kera ma daka mau 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ma na 'ensel nai ka bae 'urii fuada, “Nao molu si mau, sulia ni nau ku ngalia mai si faarongoa diana fua molu 'i tari'ina. Si faarongoa nee kai faaelea manata lana toae ki sui guu. ");
INSERT INTO bvd_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lao fa sato ne 'i tari'ina, na Waa Kwai faamauri kamolu nia futa naa lao maefera nee sa Defet. Nia na Kraes, na Aofia. ");
INSERT INTO bvd_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ma na fafaataia nia fua molu ka lio saitomana, nia 'urii: Kamolu kai suana tii wela kafi futa ne kera 'afua 'ana maku ki, ma nia kai tio 'ana lao kwade doo buluka ki ni fanga.” ");
INSERT INTO bvd_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aia kera tona boroi daka suana naa molee 'ensel faasia 'i salo ki, ne da koni na fai 'ensel bae, ma daka tangoa God daka dau nada 'ana bae lae 'urii, ");
INSERT INTO bvd_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Tangoa tasa God ne nii talua doo ki sui! Ma na aroaroe ka nii 'ana fai toaa ne God nia ele sulia kera, lao fera ne 'i saegano.” ");
INSERT INTO bvd_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Too buri 'ensel nai ki da oli naa uri 'i salo, na waa nai ki ni sua lae sulia sifsif ki daka bae 'ada 'urii, “Rowane 'ae, ma lea kolu dao fasi lao fera loko 'i Betlehem, uri kolu ka suana fasi doo ne fuli mai 'i tari'ina, ma God ka faarongo kolu ai nee.” ");
INSERT INTO bvd_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aia, kera daka lea 'ali'ali naa. Da lea kau dao daka suana naa ni Meri fai sa Diosef, ma wela bibiu nai ne tio 'ana lao kwade doo buluka ki ni fanga. ");
INSERT INTO bvd_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ma kada kera dao daka suana sui, kera lea daka unu na sulia si baea baki 'ensel 'e faarongo kera mai ai sulia wela bae. ");
INSERT INTO bvd_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ma na toaa nai kera rongoa ununua nai ki sui guu, daka kwele 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ma ni Meri ka safa manata tu'uu na 'ana sulia doo nai ki, ka taingainia ka tio gu 'ana lao manata lana. ");
INSERT INTO bvd_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","'I seeri, na waa nai ki ni suasulia sifsif ki daka oli naa. Kera daka tangoa God faafi doo nai ki sui guu da rongoa ki nai, sulia da suai doo nai ki da fuli ka lea 'o'olo guu sulia doo ne da rongo 'ensel nia saea mai. ");
INSERT INTO bvd_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Dao kwaluna fa dani wela nai, kera ka 'iri'unga 'ani nia, ma daru ka faasata nia naa 'ana sa Disas. Na satae doo nai, na 'ensel nia faarongoa sui na mai 'ani Meri 'ana kada nia nao si kulua 'ua. ");
INSERT INTO bvd_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Sa Diosef fai ni Meri keeru too lelea keeru ka faasuia naa si kada keeru fua faafaalu lae burina kwala wela lae, ilingia doo ne taki sa Mosis saea fua ili lana. 'I seeri, keeru daru ngalia wele daru ka lea 'alaa na uri Durusalem fua faa lana wela nai fuana God, ");
INSERT INTO bvd_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ilingia bae na kekeda lae lao taki nia God nia saea ma ka bae 'urii, “Na doo wane neki da kwalafi maa faalu ai, kera kai efaa ka too 'e'ete naa fua God.” ");
INSERT INTO bvd_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Keeru ka lea lau gu 'i seeri uri fale lana falee ni faafaalu lae fua God, ne kera kai falea roo fa fao ki, ma nao roo fa bole ki fua ka lea sulia doo ne taki nia God 'e saea uri fale lana. ");
INSERT INTO bvd_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ma 'ana kada nai, tii waa satana sa Simion nia too lau guu 'i Durusalem. Nia waa birangana 'e diana, ma ka foosia firi God, ma ka too kwaimaakwali gu 'ana uri sua lana kada ne God kai faamauria toaa nia 'Israel ki. Na Anoedoo Abu nia ka nii fai sa Simion, ");
INSERT INTO bvd_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ma ka faatai fuana, ne nia kai mauri gu 'ana lelea nia ka tala suana guu Kraes bae 'ana maana 'i tala'ana. ");
INSERT INTO bvd_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ma na Anoedoo Abu ka talaia sa Simion ka lea uri lao Beukaua loko. 'E lea kau 'e dao ka suana naa sa Diosef fai ni Meri ne daru ngalia mai sa Disas uri ilidoo lae 'ani nia lao Beukaua mala 'ana doo ne taki ki saea. ");
INSERT INTO bvd_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","'Uri nai guu, sa Simion ka ngalia wele ka 'olia naa 'i ruruuna, ka tangoa God ka bae 'urii, ");
INSERT INTO bvd_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“God 'ae. Doo bae 'oe alangainia fuaku nia mamana naa. Tari'ina lea sae 'oko faolomai nau boroi 'amu uri ku lea naku lao aroaroa 'oe, nia ka diana gu 'ana. ");
INSERT INTO bvd_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Na waa bae 'oe alangainia kai lea mai uri faamauri lana toae ki sui, nia ne dao naa ma nau ku tala suana naa 'ana maaku. ");
INSERT INTO bvd_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Sa wala nee, ni 'oe 'o ade akau sui na mai 'ani nia 'i maana toaa ki sui daka suana naa. ");
INSERT INTO bvd_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ma nia kai faatai 'oe sia toaa nao lau Diu ki ka mala 'ana kwesu saru folaa diana, ma nia kai falea 'initoae fua meli toaa 'oe 'Israel.” ");
INSERT INTO bvd_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kada na maa nia fai gaa nia wela nai, daru fafurongo sulia doo nai ki sa Simioni 'e saea sulia wela keerua lelea ka sui, keeru daru ka kwele 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sui sa Simion ka saea lau guu si baea diana ki fuadaru. Nia ka bae 'urii fua ni Meri, na gaa nia wele, “Na wela nee, God nia filia 'ua gu mai uri nia ka mala 'ana fafaataia fua toaa 'oro 'i 'Israel. Uri tii ne nia faamamanea wela nee, mauri lana kai diana tasa, ma tii ne nao si faamamane nia, mauri lana kai ta'aa 'asia naa. Ma na wela nee naa ne kai faatainia God sia toaa ki sui gu 'ana, sui boroi 'ana ma 'oro lana wane ma keni kera kai susubutainia. ");
INSERT INTO bvd_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ma kera kai ade 'uri nai 'ani nia, uri ka faatai folaa 'ana si lio agwa kera wane ma keni. Ni 'oe na gaa nia wela nee, liodilae baite kai dao tomu. Liodilae nai kai mala ta 'ile ne 'ala ne kai toe 'oe, ma kai fii 'oe ka ufi 'oe guu.” ");
INSERT INTO bvd_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tii gwa ai 'oru satana ni 'Ana, 'e nii lau guu nonina Beukaua loko otofana si kada nai. Ni 'Ana, nia na brofet keni ne too mai ka tau naa, ka waro naa. Ni nia saari sa Fanuel, na waa 'ana fiiwane sa 'Asa. Ni 'Ana 'e 'afe ka too kwaimani fai arai nia sulia fiu fa ngali ki sui arai nia ka mae lau gu 'ana, ");
INSERT INTO bvd_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","nia ka 'oru ka too lelea ka dao naa 'ana kwalu taafuli fa ngali ma fai fa ngali sarenga ki. Ma nia ka nanai gu 'ana lao Beukaua loko 'ana abufanga lae ma foa lae sulia fa sato ma fa rodo. ");
INSERT INTO bvd_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nia 'e lea kau ka todaa lau guu sa Diosef fai ni Meri lao Beukaua nai. Nia ka falea tango laa nia talea God ma ka faarongo talo sulia wela nai siana toae ki sui guu ne da maakwalia si kada God kai faamauria toaa 'i Durusalem. ");
INSERT INTO bvd_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kada sa Diosef fai ni Meri daru faasui tiifau naa 'ana ilidooe ki sulia taki nia ki God, keeru daru ka oli na mai uri bali lolofaa 'i Galilii uria lao maefera keeru 'i Naasaret. ");
INSERT INTO bvd_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ma na 'alakwa keeru nia ka baita 'alaa naa, ka rigita naa, ka too 'ana liotooe, ma na dianaa God ka nii na fai nia. ");
INSERT INTO bvd_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","'Afa ngali ki sui guu, maa nia fai gaa nia sa Disas, daru kai lea 'ana Fangatasae bae kai liu 'i Durusalem. ");
INSERT INTO bvd_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kada sa Disas nia baita ka dao naa 'ana taafuli fa ngali ma roo fa ngali sarenga ki, nia fai keeru da lea kwaimani sui guu 'ana maoma nai, 'uria ne 'ita kera ka ilia naa. ");
INSERT INTO bvd_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kera lea kau daka totoo mai 'ana ade dooa nai lelea 'i burina ade dooe 'e toli ka sui naa, sa Diosef fai ni Meri na maa nia fai gaa nia sa Disas, daru ka oli na mai fera. Aia, ma sa Disas loko nia 'e too 'ua gu 'ana mai 'i Durusalem. Ni keeru nao daru si saitomana lau gu 'adaru loko nia too 'ua gu 'ana mai. ");
INSERT INTO bvd_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Daru kwaifii 'adaru sae sa nia oli na mai fai na figue ne da oli ki mai. Keeru ka oli mai sulia fa sato lalau loko lelea ka dao naa 'i saulafi, daru kafi nanisi nia. 'I seeri daru ka ledia naa ote toaafuta ki ma toaa kwaimani keeru ki. ");
INSERT INTO bvd_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ma sui boroi 'ana nia ka nao si nii gu fai kera. Guu keeru daru ka oli lau uri Durusalem fua nani lae mai uri nia 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Lea burina olu fa sato 'e sui naa, keeru dafi dao tona lao Beukaua bae, kada nia gooru 'ana 'i matangana toaa saitoma doo ni toolangaidoo ki. Nia too kai fafurongo kera 'ana ma too kai ledi kera ki 'ana. ");
INSERT INTO bvd_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Na toaa ne kera waa kwairooi nia ki, kera da kwele 'asia naa 'ana filodooe nia ma 'ana olisi lae nia ki 'ana ledi laa kera ki. ");
INSERT INTO bvd_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ma kada sa Diosef fai ni Meri daru suana 'uri nai, keeru boroi daru ka kwele 'asia naa 'ani nia. 'I seeri, gaa nia ka bae 'urii fuana, “'Alakwa nau 'ae, doo 'o ilia na 'amu 'ani kaaria uri tee nai? Ni kaaria maa 'oe fai nau mone miri nani mai uri 'oe, miri ka kwaifii naa sae sa ta doo ta'aa nia fuli naa 'ani 'oe wala!” ");
INSERT INTO bvd_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","'I seeri sa Disas 'e luu keeru ka bae 'urii, “Kamuru dau na 'amuru 'ana nani lae uri nau lao faano nee sui gu 'ana uri tee nee? Kamuru saitomana gu 'amuru bae nau kwai too 'aku lao beu nia Maa nau!” ");
INSERT INTO bvd_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kada nia bae 'uri nai, keeru ka ulafusia lau gu 'adaru si manata lae ne nia fuutoi ka bae 'uri nai fuadaru. ");
INSERT INTO bvd_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","'I seeri sa Disas ka oli kwaimani na fai keeru uri lao maefera kera 'i Naasaret. Ma dao kera too kwaimani, nia ka ade gu 'ana sulia bae ladaru. Ma na gaa nia ka taingainia na 'ana si baee nai ki sui guu nia saeda ki nai lao manata lana. ");
INSERT INTO bvd_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Sa Disas ka baita 'alaa naa 'ana noni, ma 'ana liotooe, ma na God fai wane ka ele 'asia naa sulia nia. ");
INSERT INTO bvd_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Si baea nia God 'e dao sia sa Dion 'alakwa sa Sakaraea lao fera kwasi loko. 'Ana kada nai, sa Taebirias nia gwaungai 'ana fera baita 'i Rom tiifau ka dao naa 'ana taafuli fa ngali ma lima fa ngali sarenga nia ki. Aia, ma sa Bontias Baelat nia ka 'inito fua bali lolofaa 'i Diudia, sa Herod ka 'inito fua bali lolofaa 'i Galilii, sa Filib toolana sa Herod lau guu, ka 'inito fua roo brofens neki 'Iturea fai Trakonaetis, sa Lisanias ka 'inito fua 'Abilini brofens. Aia, ma sa 'Anas fai sa Kaeafas daru ka foa ni gwau fua fera 'i Durusalem. ");
INSERT INTO bvd_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ma 'i seeri, sa Dion ka liufia lao bali fera nai tiifau ninimana kafo 'i Diodan, ka faarongoa toae ki ka 'urii, “Kamolu molu ka bulasi manataa tiifau faasia abulo ta'aa laa kamolu ki uri daka faasiuabu kamolu uri God ka manata luke kamolu faasia abulo ta'aa laa kamolu ki.” ");
INSERT INTO bvd_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","'I seeri guu, si baee ne sa 'Aesaea na waa brofet, 'e kekeda ka saea mai 'i nao, ka mamana naa, ne nia bae 'urii, “Tii waa, nia 'ai fua toae ki lao fera kwasi ka bae 'urii, ‘Molu kwaia taale fua Aofia kai dao mai! Molu 'olosi diana 'ana taale nai maasi nia! ");
INSERT INTO bvd_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Molu anomia kula kilukilue ki, molu ka 'eli neneba 'ana kula 'obarusua ki ma labusue ki fai gwa tolo ki. Molu ka 'olosia taale 'e'eo ki, molu ka saungai dodoloa 'ana kula kwarua ki. ");
INSERT INTO bvd_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na toae ki tiifau kera dai suana God nia 'e faamauri kera.’” ");
INSERT INTO bvd_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Sa Dion ka bae 'urii fuana toaa 'oro ne da lea ki mai siana uri daka siuabu ki 'ada, “Kamolu na birangamolu 'e ilingia birangana baekwa 'i tolo ka sui naa! Sa tii gu 'ana ne saea fuamolu, sae sa lea nao molu si luka boroi 'ana abulo ta'aa laa kamolu ki lea molu siuabu naa molu ka tala gu 'amolu faasia kwakwaea nee God 'e 'ita ka alua ka tio naa? ");
INSERT INTO bvd_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kaa nia diana, kamolu lea kau molu ka too 'ana tooe ne nia faatainia kamolu abulo ka sui naa faasia abulo ta'aa lae kamolu ki! Ka nao molu si manata lau 'urii, ‘Kameli nee na toaa 'ana kwalafaa sa 'Abraham 'ua gu ne! Nia 'afitai fua God ka kwae kameli!’ Tasi doo lau guu nau ku faarongo diana 'ani kamolu ai 'e 'urii, lea sae God 'e dooria kai ngalia tai maefau 'ana maefau nee 'i seki fua saungai lada 'ana kwalafaa falu sa 'Abraham, nia nao si 'afitai guu fuana uri ili lana! ");
INSERT INTO bvd_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","'Ana kada nai boroi 'ana nai, God nia kwaimaakwalii sui naa fua fale lana kwakwaee nai, mala 'ana ta waa bae nia dau 'ana batau ka kwaimaakwalii sui naa uri taba lana 'ai. Ma 'ai neki sui guu kera nao dasi fungu nia kai tabada 'i saegano.” ");
INSERT INTO bvd_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","'Uri nai guu na konia nai ki daka ledi sa Dion daka 'urii, “Nee wala, ma tee ne meli kai ilia uri ka faatainia ne kameli abulo ka sui naa faasia abulo ta'aa lae kameli ki?” ");
INSERT INTO bvd_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nia luuda ka bae 'urii, “Lea 'oe too 'ana roo si ofi, 'oko falea ruana kula fua ai siofaa ne nao gu 'ana tasi ofi. Ma lea 'oe too asi fange, 'oko faa 'ana ai ne fiolo mae gu 'ana.” ");
INSERT INTO bvd_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","'I seeri, na toaa nai da kai konia malefo 'ana takis ki, kera da lea lau gu mai uri sa Dion ka faasiuabu kera, dao daka ledi 'urii 'ani nia, “Wala waa ni toolangaidoo 'ae, ma kameli mone? Tee ne meli kai ilia uri ka faatainia ne kameli meli lukasia naa abulo ta'aa laa kameli ki?” ");
INSERT INTO bvd_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Sa Dion nia luuda lau guu ka bae 'urii, “Lea kau molu ka konia gu 'amolu malefo 'o'olo nee 'ua guu 'ana takis. Nao molu si gani si 'idu lau 'i fafona.” ");
INSERT INTO bvd_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sui lau guu tai toaa ni omee ki ne kera lea lau gu mai uri siuabu lae, dao daka ledia lau guu sa Dion daka 'urii, “Ma kameli mone? Tee ne kameli kai ilia uri ka faatainia ne meli luka naa 'ana abulo ta'aa laa kameli ki?” Sa Dion 'e luu kera ka bae 'urii, “Lea kau nao molu si sasi naunau lau 'ana ngali lana si doo ta waa, ka nao molu si suke gu 'amolu faafi waa ki uri ngali lana si doo kera ki. Manatamolu ka toli 'ana fai si fofolia kamolu ki.” ");
INSERT INTO bvd_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na toaa nai ki sui guu kera da maasia gu 'ada dao lana mai na Kraes nai kai dao mai uri faamauri lana toaa nia ki. 'Uri nai kera ka manata 'urii, “Alamia sa Dion na Kraes bae na 'oto nee?” ");
INSERT INTO bvd_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","'Uri nai guu sa Dion ka bae na 'urii fuada, “Nau nee, na kafo gu 'ana ne nau ku faasiuabu kamolu ai; ma na waa ne nia kai dao mai buriku nee nia 'inito tasa ka talu nau fatai ma na butu nia ki boroi, nau kusi alamia guu luke lada fasi 'aena. Ni nia waa nai ne kai faasiuabu kamolu 'ana Anoedoo Abu ma 'ana ere. ");
INSERT INTO bvd_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ma nia kai dao mai fua sangita lana toae ki tiifau, mala waa ni sangitadoo ne kai sangitaa saena wiiti fasi 'e'eforana doe 'i fafona kwaitao ni sangitadooa nia. Ma ka konia migana dooe ka taingai 'e'ete ai lao beu ni taingai fanga laa nia, sui ma kafi ngalia 'e'eforana doe fua suungi lana lao ere ne saru ka totoo firi si mae.” ");
INSERT INTO bvd_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Sa Dion ka faarongoa konia nai ki 'ana si baea ni kwaiarei 'oro ki uri kera ka abulo faasia si birangaa kera ki, ma ka faarongo kera naa 'ana si faarongoa diana nee. ");
INSERT INTO bvd_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nia ka ngatafia sa Herod waa ne 'inito fua brofens nai, sulia nia sa Herod 'e adea lau gu 'ana baraa nia ni Herodias na 'afe nia sa Filib, na toolana lau gu 'ana. Ma sa Herod nia ka ilia tai doo ta'aa 'oro ki lau. ");
INSERT INTO bvd_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ma ka fafonaa lau doo neki nia ilia ka ta'aa, nia saea fua toa ni rao nia ki kera daka alua sa Dion lao lookafo. ");
INSERT INTO bvd_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","'Ana kada bae sa Dion nao si nii 'ua lao lookafo, nia faasiuabua toaa 'oro, ma ka faasiuabua lau guu sa Disas. Kada sa Disas nia lea mai, ma sa Dion ka faasiuabu nia, sa Disas ka foa. Kada nia foa 'uri nai, salo ka 'ifi, ");
INSERT INTO bvd_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ma na Anoedoo Abu nia ka koso mai faafi nia mala 'ana tafa bole. Ma tii si lingee baea ka talo mai faasia 'i langi ka 'urii, “'Oe 'alakwa nau naa ne 'oe tii fa wela 'autania nau ne ku liosau 'ani 'oe. Manata laku 'e ele 'asia naa sulia 'oe.” ");
INSERT INTO bvd_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kada sa Disas nia safalia raoa nia, nia 'e baita mai ka dao naa 'ana olu akwala fa ngali fono ki. Ma toae ki sui gu 'ana kera ka manata 'ada sae sa nia na 'alakwa sa Diosef gu 'ana. Ma sui sa Diosef nia na 'alakwa sa Hilae 'ana ne. ");
INSERT INTO bvd_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Sa Hilae 'alakwa sa Matat, sa Matat 'alakwa sa Lifae, sa Lifae 'alakwa sa Melkae, sa Melkae 'alakwa sa Danae, sa Danae 'alakwa sa Diosef. ");
INSERT INTO bvd_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Sa Diosef 'alakwa sa Matataeas, sa Matataeas 'alakwa sa 'Emos, sa 'Emos 'alakwa sa Neham, sa Neham 'alakwa sa 'Eslae, sa 'Eslae 'alakwa sa Nagai. ");
INSERT INTO bvd_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Sa Nagai 'alakwa sa Meata, sa Meata 'alakwa sa Matataeas, sa Matataeas 'alakwa sa Semein, sa Semein 'alakwa sa Diosek, sa Diosek 'alakwa sa Dioda. ");
INSERT INTO bvd_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Sa Dioda 'alakwa sa Dioanan, sa Dioanan 'alakwa sa Risa, sa Risa 'alakwa sa Serababel, sa Serababel 'alakwa sa Sialtiel, sa Sialtiel 'alakwa sa Nirae. ");
INSERT INTO bvd_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Sa Nirae 'alakwa sa Melkae, sa Melkae 'alakwa sa 'Adae, sa 'Adae 'alakwa sa Kosam, sa Kosam 'alakwa sa 'Elmadam, sa 'Elmadam 'alakwa sa 'Ere. ");
INSERT INTO bvd_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Sa 'Ere 'alakwa sa Diosua, sa Diosua 'alakwa sa 'Eliesa, sa 'Eliesa 'alakwa sa Diorim, sa Diorim 'alakwa sa Matat, sa Matat 'alakwa sa Lifae. ");
INSERT INTO bvd_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Sa Lifae 'alakwa sa Simion, sa Simion 'alakwa sa Diuda, sa Diuda 'alakwa sa Diosef, sa Diosef 'alakwa sa Dionam, sa Dionam 'alakwa sa 'Elaeakim. ");
INSERT INTO bvd_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Sa 'Elaeakim 'alakwa sa Milia, sa Milia 'alakwa sa Mena, sa Mena 'alakwa sa Matata, sa Matata 'alakwa sa Neetan, sa Neetan wela sa Defet waa 'inito bae 'Israel. ");
INSERT INTO bvd_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Sa Defet 'alakwa sa Deesii, sa Deesii 'alakwa sa 'Obet, sa 'Obet 'alakwa sa Boas, sa Boas 'alakwa sa Salamon, sa Salamon 'alakwa sa Naason. ");
INSERT INTO bvd_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Sa Naason 'alakwa sa 'Aminadab, sa 'Aminadab 'alakwa sa 'Adamin, sa 'Adamin 'alakwa sa 'Arani, sa 'Arani 'alakwa sa Hesron, sa Hesron 'alakwa sa Beres, sa Beres 'alakwa sa Diuda. ");
INSERT INTO bvd_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Sa Diuda 'alakwa sa Diakab, sa Diakab 'alakwa sa 'Aesak, sa 'Aesak 'alakwa sa 'Abraham, sa 'Abraham 'alakwa sa Tira, sa Tira 'alakwa sa Naho. ");
INSERT INTO bvd_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Sa Naho 'alakwa sa Sirag, sa Sirag 'alakwa sa Riu, sa Riu 'alakwa sa Beleg, sa Beleg 'alakwa sa 'Eba, sa 'Eba 'alakwa sa Sela. ");
INSERT INTO bvd_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sa Sela 'alakwa sa Keenan, sa Keenan 'alakwa sa 'Afaksad, sa 'Afaksad 'alakwa sa Sem, sa Sem 'alakwa sa Noa, sa Noa 'alakwa sa Lameki. ");
INSERT INTO bvd_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Sa Lameki 'alakwa sa Metusalaa, sa Metusalaa 'alakwa sa 'Enok, sa 'Enok 'alakwa sa Dioret, sa Dioret 'alakwa sa Mahelalel, sa Mahelalel 'alakwa sa Keenan. ");
INSERT INTO bvd_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Sa Keenan 'alakwa sa 'Enos, sa 'Enos 'alakwa sa Seti, sa Seti 'alakwa sa 'Adam, sa 'Adam 'alakwa nia God. ");
INSERT INTO bvd_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Sa Disas, kada nia faasia kafo 'i Diodan burina 'e siuabu ka sui, nia fungu 'ana Anoedoo Abu. Ma Anoedoo Abu ka talai nia 'i lao fera kwasi. ");
INSERT INTO bvd_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Saetan ka ilitona 'i seeri sulia faitaafuli fa dani ki. Ma sa Disas ka nao si 'ani tasi fanga sulia fa dani nai ki, ma ka fiolo mae. ");
INSERT INTO bvd_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ma Saetan ka bae 'urii fuana, “Lea sae ni 'oe na 'Alakwa mamana nia God, 'oko saea maefau nee nia lia 'ana tafa beret ni 'ani lana.” ");
INSERT INTO bvd_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Sa Disas 'e olisi nia ka bae 'urii, “Na Kekeda laa Abu nia bae 'urii, ‘Na wane nia 'afitai ka mauri 'ana otona fange gwana.’” ");
INSERT INTO bvd_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sui Saetan 'e talaia daru ka raa 'i gwauna gwa toloa 'e fane 'asia naa. Too 'i seeri asi kada kukuru nai, Saetan ka faatainia kwalu 'initoaa 'e'ete neki tiifau lao molaagali fua sa Disas, ");
INSERT INTO bvd_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ka bae 'urii fuana, “Nau mone lea ku dooria, nau kwai falea gu 'aku 'okona 'initoaa neki fai kwanga lada tiifau fuamu. Ma tii gu 'ana ne nau ku dooria kwai faa doo neki 'i 'abana, nau kwai ilia gu 'aku, sulia kera na doo nau ki naa da faa fuaku. ");
INSERT INTO bvd_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ma lelea sae 'oe 'o booruru 'i saegano ma 'oko faabaita nau naa 'i seki, 'okona doo neki, doo 'oe ki sui naa nau kwai fale tiifau nai fuamu.” ");
INSERT INTO bvd_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Sa Disas 'e olisi nia ka bae 'urii, “Na kekeda laa Abu nia bae 'urii, ‘Ni kamolu, molu ka faabaitaa na Aofia na God kamolu. Ni nia taifili nia guu molu ka faabaita nia ma molu ade doo fuana.’” ");
INSERT INTO bvd_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sui, Saetan ka talai sa Disas ka lea uri maefera baita loo 'i Durusalem, lea dao daru ka uu 'i langi gwauna fatai duu 'ana Beukaua loo, nia ka bae 'urii fua sa Disas, “Lea sa nia mamana ni 'oe na 'Alakwa nia God, 'oko too 'i seki 'oko lofo uri fubaa dao 'i saegano, ");
INSERT INTO bvd_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","sulia na Kekeda laa Abu nia bae 'urii, ‘God nia kai saea fua 'ensel nia ki uri daka suasulia 'oe, ");
INSERT INTO bvd_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ma kera da kai sako 'oe gwada, uri 'aemu ka nao si too toi ta maefau.’” ");
INSERT INTO bvd_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Sa Disas 'e olisi nia ka bae 'urii, “Na kekeda laa Abu nia bae 'urii, ‘'Oe nao 'osi ilitona na God 'oe!’” ");
INSERT INTO bvd_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Saetan 'e ilitona sa Disas 'ana doo nai ki sui, dao seeri nia ka lea na 'ana faasia sa Disas maasi tasi kada lau. ");
INSERT INTO bvd_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Dao seeri, sa Disas ka oli mai lao tetedee Anoedoo Abu uri bali lolofaa 'i Galilii. Ma faarongo lae sulia nia, ka talofia sui gu 'ana lao lolofaa nai. ");
INSERT INTO bvd_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nia 'e toolangaidoo 'i lao beu ni ofu lae kera ki, ma na toae ki sui guu daka sae diana 'asia na 'ani nia. ");
INSERT INTO bvd_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nia lea mai ka dao naa lao maefera bae 'i Naasaret, kula bae nia too ai lelea ka baita. Ma 'ana tii fa dani sabati, nia ka lea kau 'ana ofu kwaimani lae uri foa lae 'i lao beu ni ofu lae kera 'i seeri, mala 'ana doo ne 'ita nia ka ilia naa. Aia, 'ana kada 'ana ofufua nai, nia tatae ka uu uri teemai lana kekeda laa abu. ");
INSERT INTO bvd_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kera daka ngalia mai buka bae brofet 'Aesaea 'e kedaa, daka faa fuana uri ka teemainia. Nia ngalia ka fuea naa, ka fue toi si kula nai sa 'Aesaea nia kedaa si baea 'urii ki ai, ");
INSERT INTO bvd_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Na Anoedoo nia God 'e dau na faafi nau sulia 'e fili nau, uri ku faarongo 'ana si Faarongoa Diane nee fua toaa da siofaa ki. Ma nia ka fale nau mai uri ku faarongo 'ana alube lae fua toaa da kani ki, ma too sakwadoloa lae fua toaa da mala siofaa ada ki, ma lilio folaa lae fua toaa ne maada rodo ki, ");
INSERT INTO bvd_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ma uri faarongo lae, ne si kada nia Aofia uri faamauri lana toaa nia ki, nia 'e dao na ai.” ");
INSERT INTO bvd_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Sa Disas 'e teemainia si baea nai ki sui, nia ka fonoa buka nai oli ka faa lau gu 'ana fua waa ne suasulia doo ki 'i lao beu ni ofu lae kera nai. Disas oli ka gooru ngado naa uri toolangaidoo lae. 'I seeri guu, na toaa nai ki sui gu 'ana lao beu ni ofu lae nai daka bubu tetee sui gu 'ada 'ani nia. ");
INSERT INTO bvd_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nia ka bae na 'urii fuada, “Doo ne da kekeda mai sulia nee, nia ne fuli naa 'i tari'ina kada nai gu 'ana nau ku teemai kau sulia molu ka rongo nai.” ");
INSERT INTO bvd_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","'I seeri, na konia nai tiifau kera ka sae diana 'asia naa 'ani nia, ma daka kwele lau gu 'ada 'ana doo diana nai ki sui guu nia bae sulia fuada, ma sui daka bae 'ada 'urii, “Nia na 'alakwa bae sa Diosef gu 'ana ne, ma sui nia saea sa nia fatai ne da kekeda mai sulia nia nee!” ");
INSERT INTO bvd_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Sa Disas ka bae lau 'urii fuada, “Nau ku saitomana gu 'aku, si baea 'urii na kamolu manata toi sae lana fuaku, ‘'Oo, ma 'oe waa kwai gurai bae naa ne, aia ma 'oe gura 'oe fasi tala 'amu!’ Tasi baea kamolu manata toi lau gu uri sae lana fuaku 'e 'urii, ‘Doo kwaibalatana 'oro ne kameli rongo kau 'oe 'o ilia ki mai lao maefera loko 'i Kabaneam. Aia, ma 'oe ilida fasi 'i seki lao maefera 'oe nee 'ua guu!’” ");
INSERT INTO bvd_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Sui sa Disas ka bae lau 'urii fuada, “Nau ku faarongo kamolu 'o'olo guu, na brofet doo na toaa nia ki 'ua guu 'i fera kera 'afitai manata lada ka ele gu sulia nia ne! ");
INSERT INTO bvd_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nau ku faarongo mamana guu 'ani kamolu. 'Ana kada sui toli kada bae brofet 'Ilaeja 'e rao 'ua lao fera nee 'Israel, na uni sato baita nia liu sulia olu fa ngali fai ono madame baki, ma uni fioloa ni maeli lana bae 'e liutainia fera neki tiifau. 'Ana kada nai, 'oro lana wela keni 'oru da too gu 'ada lao fera nee 'Israel. ");
INSERT INTO bvd_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ma sui God ka nao si odua guu sa 'Ilaeja fua ka lea uri ta luma 'ana luma kera ki. Ma gwa keni 'oru nia too na mai 'ana 'i Sarefata bali loo mai Saedon ka nao lau ai Diu bae God 'e odua sa 'Ilaeja lea ka dao luma nia. ");
INSERT INTO bvd_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ta ununua lau sulia kada sui toli nia 'urii, 'ana kada 'i nao kada brofet 'Ilaesa nia rao 'ua lao fera nee 'Israel, 'oro lana toaa furo saungi kera ki da too gu 'ada lao fera nee, ma sui sa 'Ilaesa ka nao si guraa guu ta waa ma nao ta ai ada. Sa Neemani na waa bali fera 'i Siria ma nao lau waa Diu 'ana bali fera 'i Siria, nia 'ana bae sa 'Ilaesa 'e gura nia.” ");
INSERT INTO bvd_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Aia, na figue bae da ofu lao beu ni ofufue bae, da rongoa doo nai ki, na rakeda ka ngengeela naa, sulia da rongoa sa Disas 'e unu sulia ne God nia 'adomia 'ana toaa nao lau toaa Diu ki, ma ni kera toaa 'Israel 'ua guu ka nao. ");
INSERT INTO bvd_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","'I seeri guu, kera daka taria na sa Disas fasi lao maefera nai. Daka tobi nia daka tari nia naa uri gwau 'o'oiro nai fera nai nii gwauna, uri daka dau nia daka 'ui 'ani nia 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ma sui nia 'e kwai dolali kwailiu gu 'ana fai 'oroe nai ka nao 'ana gu 'ana 'i matangada ka dila 'ani nia ka lea gu 'ana faasi kera. ");
INSERT INTO bvd_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sa Disas ka lea naa uri Kabaneam na maefera 'e nii lao bali lolofaa 'i Galilii. Ma nia ka toolangaidoo fua konia nai 'i seeri 'ana fa dani Sabati lau guu. ");
INSERT INTO bvd_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ma na konia nai ka kwele 'asia naa 'ana toolangaidoo lana, sulia nia 'e bae 'ana tetedee nia God. ");
INSERT INTO bvd_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ma tii waa ne anoedoo ta'aa burosi nia 'e nii lau gu fai kera lao konia nai lao beu ni ofu laa nai. Ma sa wala nai ka dau 'ana kokoo baita lae ma ka bae 'urii, ");
INSERT INTO bvd_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Disas 'ae, 'oe waa nena 'i Naasaret, nau ku saitomana gu 'aku 'oe na Waa Abu nia God na! Sui 'oe tee ne 'o doori ili lana 'ani kameli? 'Oe alamia 'o lea na mai fua tauwela lameli 'oto ne?” ");
INSERT INTO bvd_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Sa Disas ka ngatafia anoedoo ta'aa nai, ka bae 'urii, “'Oe 'o taaro 'amu, ma 'oko lea 'amu faasi sa wala nena!” Guu na anoedoo ta'aa nai ka ilia sa wala nai ka 'asia naa 'i saegano, sui ka lea na faasia. Na figue nai sui guu daka suai gu 'ada, ma sa wala nai ka nao si maala guu. ");
INSERT INTO bvd_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Na toaa ne kera koni 'i seeri nai daka kwele, daka ledi kera ki nada 'urii, “'Ee, ma nia bae 'utaa na 'ana bae wala? Ma tee na anoedoo ta'aa baki boroi ma nia saea kera lea 'ada fasi waa ki, ma daka tafi nada!” ");
INSERT INTO bvd_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ma 'uri nai guu, na ununua sulia sa Disas ka talofia naa maefera nai ki sui gu 'ana kalia 'i Kabaneam. ");
INSERT INTO bvd_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","'Uri nai sui, sa Disas ka lea lau gu 'ana faasia na beu ni ofu laa nai, ka lea na kau luma sa Saemon. Nia dao 'i luma, ka suana 'initai fungo sa Saemon nia matai baita 'ana 'a'ako lae. Ma kera daka saea fua sa Disas uri ka guraa. ");
INSERT INTO bvd_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Sa Disas nia ka ala faafia ledi laa kera, ka lea ka uu naa 'i ninimana ifitai ne 'initai nai 'e tio ai, ka bae susuala fua 'a'ako lae nai uri ka lea 'ana faasi 'initai nai. 'I seeri guu, 'initai nai, nonina ka gwagwari naa ka 'akwaa naa. Nia too diana 'uri nai guu, nia ka rao fanga fuada sui naa sa Disas fai kera. ");
INSERT INTO bvd_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Sui lau guu, 'i saulafi naa kada sato nia suu naa, toaa ki sui gu 'ana 'i seeri daka ngalia na mai mamalana gu 'ana wane ma keni ne mamalana gu 'ana mataia 'e saungi kera ki siana sa Disas. Nia ka fale 'aba faafida, ma ka gura kera tiifau. ");
INSERT INTO bvd_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","'Ana kada nai, wane ma keni 'oro mamana gu ne anoedoo ta'aa ki da tafi faasi kera ma daka bae 'urii, “Ni 'oe naa ne 'Alakwa mamana nia God!” Sui sa Disas ka luia anoedoo ta'aa nai ki nao kera dasi bae, sulia kera saitomana naa ne nia na Kraes. ");
INSERT INTO bvd_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","'I 'uubongi abu 'ua guu, sa Disas 'e faasia maefera baite nai 'i Kabaneam, ka lea naa uri tii si kula agwa 'i seeri, uri ka too aroaro 'ana ai taifili nia. Sui boroi ma konia bae daka nani lau kau 'ada burina lelea daka dao tona lau guu, ma daka saea fuana uri nao si lea lau faasi kera. ");
INSERT INTO bvd_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Sa Disas ka bae 'urii fuada, “God nia fale nau mai uri faarongo lae 'ana si faarongoa diana sulia 'initoaa nia God. Nia ne adea ma nau kwai lea naa uri faarongo lae ai fua toae ki lao bali toaa 'e'ete loko ki lau guu. Raoa nai ne God nia fale nau ku lea mai uri ili lana nee.” ");
INSERT INTO bvd_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Disas ka liu naa 'ana maefere ki sui gu 'ana lao fera kera toaa Diu 'ana faarongo talo lae 'ana si faarongoa diana ma ka bae 'i lao beu ni ofu laa kera ki. ");
INSERT INTO bvd_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tii fa dani, sa Disas nia uu 'i ninimana 'osi baita 'i Galilii ka toolangaidoo, toaa 'oro mamana guu da koni kali nia uri rongo lana bae lana God daka kwaisangirii guu. ");
INSERT INTO bvd_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nia ka lio kau ka suana roo baru nai ki waa ni dee lae ki da faasida gu 'ada 'i maana malitikwa nai kada da taufia ada furai kera ki. ");
INSERT INTO bvd_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ma sa Disas ka lea kau ka raa 'i lao baru sa Saemon, ka saea fuana ka usungai tu'uu kau ai uri matakwa. Sui sa Disas ka gooru mai 'i lao baru nai, ka toolangaidoo naa fua konia nai. ");
INSERT INTO bvd_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ma kada nia toolangaidoo fua konia nai lelea ka sui naa, nia ka bae 'urii fua sa Saemon fai tai waa lau lao baru nai, “Molu usungainia kau baru nee ka lea tau kau uri lao matakwa koso loko, sui molu ka dingalua naa furai kamolu ki uri alasi lana sakwari ki.” ");
INSERT INTO bvd_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sui sa Saemon olisi nia ka bae 'urii fuana, “'Oo waa ni toolangaidoo 'ae, kameli mone, meli ilitoi mai dee lae sulia fa rodo lalau bae sui kau, ta kaa sakwari boroi dodoloa meli ka deea guu. Sui boroi 'ana, nau kwai dingalua furai sulia ne 'oe saea naa.” ");
INSERT INTO bvd_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ma kada kera dingalua kau furai nai ki, kera daka alasia sakwari 'e 'oro mamana guu, lelea furai ki boroi ka sali muu naa. ");
INSERT INTO bvd_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kera ka karumainia na mai toa kwaimani kera ni dee lae ki 'i lao ta baru lau guu lao 'osi nai, uri kera ka lea mai uri kwai'adomi lae 'ana kwai lana sakwari nai ki fai kera. Toa kwaimani nai ki dao kera ka kwai'adomi naa 'ana koni lana sakwari nai ki fua lao roo baru nai ki lelea daka karangi kuruu naa. ");
INSERT INTO bvd_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ma kada sa Saemon Bita 'e suai si doo nai 'e fuli, nia ka booruru 'i maa 'aena sa Disas, ka bae na 'urii, “'O Aofia 'ae, lea tau 'amu kau faasi nau, sulia nau waa ku abulo ta'aa.” ");
INSERT INTO bvd_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Sa Saemon fai toa kwaimani nia ki, daka kwele 'asia naa 'ana sakwari 'oro ne kera deea nai. ");
INSERT INTO bvd_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ma sa Demes fai sa Dion, roo 'alakwa sa Sebedii ki ne daru lea kwaimani fai sa Saemon, keeru lau guu daru kwele lau gu 'ana doo nai. Ma sa Disas ka bae 'urii fua sa Saemon, “Nao 'osi mau lau Saemon. 'Ita 'i tari'ina ka oli 'alaa, 'oe 'oi deea lau na 'amu wane fua faamamane lana God, nao lau sakwari 'urii.” ");
INSERT INTO bvd_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ma 'ana si kada kera lea kau daka dao 'i sara, kera faasia iole nai sulia one fai 'okona doe ki tiifau ka tio nada 'i seeri, daka lea nada fai sa Disas. ");
INSERT INTO bvd_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tii fa dani, kada sa Disas 'e nii 'ana lao tii maefera baita 'ana bali fera nai, tii waa na furo 'e saungia, ne too 'i seeri 'e suana sa Disas. Nia ka lea mai dao ka booruru ka tio na fafo maana 'i saegano 'ae sa Disas, ka bae kwai amasi fuana ka 'urii, “'Oo Aofia 'ae, lea sae 'o ala gu 'amu faafia, nau ku dooria 'asia naa 'oko gura nau uri noniku ka falu 'ana.” ");
INSERT INTO bvd_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","'I seeri, sa Disas 'e fale 'aba kau ka dau tona nonina, ka bae 'urii, “Diana 'asia naa, nau ku ala faafia. Alu nonimu 'e falu 'ana.” Ma tona nia lio boroi ka suai furo bae 'e sui naa fasi nonina 'i seeri 'ua guu. ");
INSERT INTO bvd_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","'Uri nai sui, sa Disas ka saea fua waa nai uri ka oli na 'ana ma ka bae 'urii fuana, “'Oe oli kau, na faarongo lana ta waa 'ana doo neki, 'e nao 'osi ilia 'ua. Na faatai lana 'ana nonimu sia waa ni foa, uri ka lio filoa ne 'oe 'akwaa naa, nia 'ana ne 'o lea kau 'oko ilia. Ma 'oko falea afuafua bae taki nia sa Mosis saea, uri toae ka faamamanea ne 'oe 'akwaa ma nonimu ka falu naa.” ");
INSERT INTO bvd_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ma sui boroi 'ana sa Disas ka luia faarongo talo lae 'ana doo nai ki, na ununue sulia nia 'e talofia sui naa kula 'oro nai ki. Ma toaa 'oro ki kera ka lea na mai fua fafurongo lana toolangaidooa nia ki, ma fua nia ka guraa mataie kera ki. ");
INSERT INTO bvd_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Sa Disas nia kai lea walude faasi kera uri si kada kula gwau ki, uri ka aroaro fuana, nia ka foa ki 'ana ai. ");
INSERT INTO bvd_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tii fa dani lau guu, sa Disas 'e toolangaidoo 'ana fua konia nai 'ana tii si kula nai. Kada nia toolangaidoo 'ana 'uri nai, na Faarisii ki fai na waa toolangaidoo lae 'ana taki sa Mosis, kera da gooru kwaimani lau guu fai konia nai 'i seeri. Kera da lea mai fasi maefera ki sui gu 'ana lao bali lolofaa 'i Galilii fai bali lolofaa 'i Diudia, ma faasia lau guu na maefera baita loo 'i Durusalem. Ma 'ana kada nai, na mamanaa God ka sifo faafia sa Disas fua gura lana toaa matai ki. ");
INSERT INTO bvd_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Lio boroi, waa nai ki daka tamaa mai tii waa bae 'afumae kwaea 'ana gwegwele daka dao na fai nia. Kera ka sasi kalia ruu lae fai nia 'ana mae uri beu, uri daka egwalaa 'i 'aena sa Disas fua gura lana, ka 'afitai. ");
INSERT INTO bvd_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Sulia na 'oroa nai 'e kwaisuusi ma kera ka dao toi ka 'afitai uri ruu lae kau fainia 'ana mae, kera ka oli daka raa fai nia uri fafo beu. Ma daka sufungia fafo beu nai daka faakosolangainia fai gwegwele da ngali nia mai ai ka koso mai ka too naa 'i saegano sia sa Disas. ");
INSERT INTO bvd_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ma kada nia 'e suana faamamana laa nai kera too ai, nia ka bae 'urii fua waa 'aena mae nai, “Wala, nau ku manata lukea naa ade garoa 'oe ki.” ");
INSERT INTO bvd_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","'I seeri, na waa toolangaidoo baki fai Faarisii baki, kera suai daka 'ugalia naa sa Disas daka bae 'urii, “Nee wala, ma nia sa tii fatai nee uri ka ili si doo nai? Nia faabolatainia naa fai God nai! Doo 'e abu wane gwana 'uri nia si ilia nai! God taifilia naa ne nia tala'ana manata luke lana ade garoa ki 'uri nai!” ");
INSERT INTO bvd_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Sa Disas 'e filoa gu 'ana doo ne kera da bae sulia. Nia ka ledi kera ka 'urii, “Nee? Uri tee ne molu ka leditoi si doo bae nau ku ilia kau bae?” ");
INSERT INTO bvd_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Guu nia ka bae 'urii fuada, “Nau lea ku bae gu 'aku 'urii fua sa wala nee, ‘Nau ku manata lukea naa ade garoa 'oe ki,’ tara 'afitai molu ka lio balafana guu ne nau ku too 'ana rigitae fua manata luke lana ade garoa ki sui. Ma lea nau ku bae 'urii fuana ‘'O tatae 'i langi, 'oko tala fali 'oko lea naa,’ taari molu lio balafana.” ");
INSERT INTO bvd_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Guu nia ka bae na 'urii fua waa 'aena mae nai, “Uri molu ka lio filoa ni nau 'Alakwa nia Wane, ku too 'ana rigitae fua manata luke lana abulo ta'aa lae ki, nau ku saea fuamu, 'o tatae 'i langi 'oko ngalia ifitai 'oe nee 'oko oli 'amu fera kamu.” ");
INSERT INTO bvd_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ma tona 'i seeri, na konia nai da lio boroi waa bae 'e tatae ka uu naa, sui ka ngalia ifitai bae nia tio mai fafona ka lea na 'ana 'i fera, ma ka tangoa na 'ana God. ");
INSERT INTO bvd_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ma na konia nai tiifau kera daka kwele 'asia naa daka mau ma daka tangoa God. Ma daka bae 'urii, “Doo ni kwele lae ki nai ne kolu suai na mai tari'ina nee rowane.” ");
INSERT INTO bvd_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Burina si doo nai, sa Disas ka lea na kau 'ana ta bali 'e'ete fasi seeri, guu ka suana tii waa ni koni lana malefo 'ana takisi, ne satana sa Lifae, kada nia gooru kai rao 'ana lao kasi beu ni takisi lae 'i seeri. Sa Disas ka bae 'urii fuana, “'O lea mai buriku.” ");
INSERT INTO bvd_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Sa Lifae 'e tatae 'i seeri, ka faasia doo nia ki tiifau ka tio naa, ka lea na 'ana fai sa Disas. ");
INSERT INTO bvd_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Da lea kau da dao 'i luma kera sa Lifae, nia ka rao 'ana tii fanga lae baita fua sa Disas. Toaa 'oro ni koni lana malefo 'ana takisi ma tai toaa 'oro ni ilidoo garo ki lau guu, da fanga kwaimani fai sa Disas 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","'Uri nai guu, na Faarisii ki fai Waa toolangaidoo 'ana taki ki daka 'uga naa. Ma daka bae 'urii fua waa kwairooi nia sa Disas ki, “Nia nao si bobola uria 'oko fanga kwaimani 'amu fai toaa ni koni lana malefo 'ana takisi nee ma toaa abulo ta'aa 'e'ete neki lau guu 'urii.” ");
INSERT INTO bvd_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Sa Disas nia luu kera ka bae 'urii, “Toaa da too diana ki gu 'ada, nao dasi kwai 'atoi guu 'ana waa ni kwai gurai lae. Toaa matai ki 'ana ne da kwai 'atoi 'ana waa ni kwai gurai lae. ");
INSERT INTO bvd_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nau ku lea lau 'aku mai uria 'aili lana toaa abulo ta'aa ki uria daka lukasia abulo ta'aa laa kera ki ne, nao lau toaa da 'o'olo ki gu 'ada.” ");
INSERT INTO bvd_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tai waa da bae 'urii fua sa Disas, “'Ana kada 'oro ki, toaa kwairooi nia sa Dion ki kera da foa daka abufanga, ma toaa kwairooi kera Faarisii ki boroi da ade lau gu 'uri nai. Sui 'utaa ne toaa kwairooi 'oe ki daka fanga gu 'ada ma lea ka nao dasi ili gu 'uri nai?” ");
INSERT INTO bvd_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Sa Disas 'e luu kera ka bae 'urii, “Toaa ne da too ni elea 'ada fai fungao noni fanga kwaimania 'ana lumae, nia nao si bobola fua molu ka suumai kera fua abufanga lae kada ne fungao too kwaimani 'ua gu 'ana fai kera. ");
INSERT INTO bvd_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Si kada uri talai lana kau fungao fasi toa kwaimani nia ki doo kai dao mai na. 'Ana kada nai fatai ne toa kwaimani nia ki dai liodila 'i burina ai ma dafi abufanga. Doo ne adea ma ka nao si bobola gu fua toaa kwairooi nau ki daka abufanga 'ua nai. Suli tee ne nau ku too kwaimani 'ua gu 'aku fai kera nee.” ");
INSERT INTO bvd_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Sa Disas nia bae 'uri nai sui ka falea lau tii si baea ni tarifula lae fuada ka bae 'urii, “Doo nai talafana bae sae 'oe 'iria si 'aba maku falu ngalia 'oko taia lau maana si 'aba maku kwali nai. Lea 'oe ade 'uri nai, tara 'oe 'o saketoa lau gu 'amu maku falu nai, ma si kula falu nai 'o taia boroi maa si maku kwali ka nao si kwaialami lau guu. ");
INSERT INTO bvd_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Na waen falu boroi nao si diana lau guu uri daka ongia lao kufidoo kwali. Lea da ade 'uri nai, tara si kada na waen falu nai nia ngingisula nia kai bosea kufidoo nai. Si kada na kufidoo nai nia bose ma ka foga, na waen falu nai ka kisitai naa ma na kufidoo kwali nai daka 'ui nada ai. ");
INSERT INTO bvd_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Na waen falu daka ongia lau guu lao kufidoo falu uri na kufidoo nai ma na waen nai daru ka tio diana sui guu. ");
INSERT INTO bvd_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Waa ne kuufia waen kwali nee ka too na sulia, 'afitai ka dooria lau kuufi lana waen falu nee, suli 'e manata 'urii, ‘Na waen totoonao nee 'ana ne kuufi lana mamasia ka tasa.’” ");
INSERT INTO bvd_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","'Ana tii fa dani 'ana Sabati, sa Disas fai toa kwairooi nia ki, kera lea kau daka liu folo lao olee wiiti nai. Ma tai waa 'ana waa kwairooi nia ki daka falia kau tai fufungi doo 'ana fungina wiiti nai lao ole. Kera daka dau 'ana dalodalofi lana fungidoe ki lao lofo 'abada ki, ma daka dau 'ana 'ani lana kau sulia taale. ");
INSERT INTO bvd_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ma 'i seeri na Faarisii ki daka suai naa, daka bae na 'urii, “Doo nai kamolu ilia nai, nia 'oia naa taki bae sa Mosis alua mai nai! Tee kamolu rao naa nai, molu ka falia fufungina wiiti nai ki, doo bae 'e abu uri ili lana 'afa dani Sabati!” ");
INSERT INTO bvd_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Sa Disas luu kera ka bae 'urii, “Kamolu molu teemainia buka abu molu ka saitomana gu 'amolu ununua bae sulia sa Defet fai kera, fa dani bae kera lea kau lelea daka fiolo mae bae. ");
INSERT INTO bvd_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Bae nia ruu 'i lao raa'ai bae God ma ka gania waa ni foa uri beret abu bae. Ma waa ni foa ka faa mai beret bae fua sa Defet, doo bae abutai lana talea God. Ma sa Defet ngalia ka tolingia gu 'ana fuada daka 'ani naa, doo bae abu 'asia naa fua ta waa tatakwai 'oko 'ania, ma otona guu waa ni foa ne nia mola uri 'ani lana! Ma sui God ka nao si keto nia gu uria bae!” ");
INSERT INTO bvd_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Sa Disas ka bae lau 'urii, “Nau, na 'Alakwa nia Wane, nau naa ne ku 'inito 'ana Sabati uri ili lana doe ai.” ");
INSERT INTO bvd_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","'Ana tafa dani Sabati lau guu, sa Disas nia lea kau lao beu ni ofu lae ka toolangaidoo fuana konia 'i seeri. Ma tii waa bali 'aba aolo nia mae, ka nii lau gu matangana konia nai. ");
INSERT INTO bvd_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ma tai waa toolangaidoo 'ana taki ki ma Faarisii ki lau guu kera nii lao konia nai. Ma too daka bubungia naa sa Disas, uri lea nia guraa naa waa nai 'afa dani Sabati, kera daka kwaali nia na faafia. ");
INSERT INTO bvd_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ma sui sa Disas 'e saitomana gu 'ana manata lada. 'Uri nai, nia ka bae 'urii fua waa 'abana mae nai, “Tatae 'amua 'i langi, lea mai 'oko uu 'i see maana konia nee.” Ma waa nai ka tatae 'i langi ka lea ka uu na 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Sa Disas ka bae lau 'urii fua Faarisii ki fai waa toolangaidoo 'ana taki ki, “Nau ku ledi tomolu fasi. Tee gu ne taki kia 'e faolomainia kolu ka ilia 'afa dani Sabati? Nia faolomai kolu uri fuli lana dianaa, ma nao fua fuli lana ta'aa lae? Ma nao nia faolomai kolu uri faamauri lana wane, ma nao fua saumaeli lana?” ");
INSERT INTO bvd_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Sa Disas nia bae 'uri nai sui ka bubungi kera kwailiu sui guu. Sui ka abulo ka bae na 'urii fua waa 'abana mae nai, “Tagaa kau 'abamu.” Nia tagaa kau 'abana 'uri nai guu, 'abana ka diana naa. ");
INSERT INTO bvd_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kada na toa nai da suai 'uri nai guu, rakeda sasu ka ta'aa naa. Daka safali bae ofu naa sulia tasi doo tee ne dai adea 'ana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","'Ana tasi kada lau guu 'ana kada nai ki, sa Disas nia lea ka raa gwauna uo nai ki 'i langi ka foa 'ana 'i seeri. Ma nia ka foa sulia fa rodo lalau nai lelea faanoe ka dani. ");
INSERT INTO bvd_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Dani 'uubongi, nia ka 'ailia waa kwairooi nia ki ma ka fili kera naa. Nia fili kera 'ada akwala ma roo waa sarenga ki, ma ka 'ailida 'ana 'aboosol ki. ");
INSERT INTO bvd_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Na satada ne: sa Saemon bae sa Disas 'aili nia lau guu 'ana sa Bita, ma sa 'Andru toolana sa Saemon, sa Demes, sa Dion, sa Filib, sa Baatolomiu, ");
INSERT INTO bvd_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","sa Matiu, sa Toomas, sa Demes 'alakwa sa 'Alfias, sa Saemon waa 'ana toa bae da doori tari lana toaa Rom fasi 'Israel bae, ");
INSERT INTO bvd_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","sa Diudas 'alakwa sa Demes, ma sa Diudas 'Iskariot na waa labulili bae. ");
INSERT INTO bvd_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Sa Disas ka koso na mai fai waa kwairooi nia ki fasi gwauna uo nai. Kera 'ada akwala ma roo waa sarenga. Kera koso mai dao lao otefoloa nai daka dao tona ta bali ada lau guu ne da nii lao konia baita nai da lea mai burina. Nia ka uu na 'i seeri lao otefolo nai. Toaa 'oro ne da koni nai, kera lea ki mai fasi kula 'e'ete 'oro ki sui gu 'ana, mala bali lolofaa 'i Diudia, fai maefera baita loo 'i Durusalem. Ma bali ada ka lea tau ki mai fasi fera tau loki sulia asi loo 'alaa 'i Taea fai 'i Saedon. ");
INSERT INTO bvd_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Kera lea mai da fafurongoa bae lana sa Disas, ma fua nia ka guraa mataia kera ki. Toaa ne anoedoo ta'aa ki faagaro kera, da lea lau gu mai uri nia ka 'adomi kera. ");
INSERT INTO bvd_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ma na konia nai sui guu daka sasi uri dau lae tona noni sa Disas, sulia na tetedea nai 'e lea mai faasi nia ka gura kera sui guu. ");
INSERT INTO bvd_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Kada sa Disas 'e abulo ka lio kau uri waa kwairooi nia ki, nia ka bae 'urii, “'E diana tasa fuamolu toaa ne molu siofaa, sulia 'initoaa God na doo kamolu. ");
INSERT INTO bvd_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","'E diana tasa fuamolu toaa ne molu fiolo mae tari'ina, sulia kamolu kai fanga abusu. 'E diana tasa fuamolu toaa ne molu angi 'i tari'ina, sulia kamolu kai waela molu ka igigele guu. ");
INSERT INTO bvd_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","'E diana tasa fuamolu kada kera suamolu ka ta'aa daka susubutai kamolu, daka bae kwakwala fuamolu, ma daka faa ta'aalia satamolu molu roo suli nau na 'Alakwa nia Wane. ");
INSERT INTO bvd_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ele, noni sasala molu ka wae sasaka kada da ili 'uri nai ki 'amolu, sulia kwaiaraa kamolu ne nii fera loo 'i salo 'e baita tasa. Toaa ne da ili 'uri nai 'amolu, na kokoo kera ki kada 'i nao da ili 'uri nai lau gu mai 'ana toaa brofet ki. ");
INSERT INTO bvd_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Aia, ma toaa ne molu suadoo baita 'asia naa 'i tari'ina, kwaimanatai sulia nia kai ta'aa fuamolu. Kaa suadooa ne faadianaa manatamolu ne molu ngalia sui na 'amolu nai. ");
INSERT INTO bvd_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Toaa ne molu fanga abusu ki na 'amolu 'i tari'ina, kai ta'aa 'asia naa fuamolu sulia kamolu kai fiolo mae. Toaa ne molu waela'idi ki 'amolu 'i tari'ina, kai ta'aa 'asia naa fuamolu, sulia kamolu kai angi baita. ");
INSERT INTO bvd_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ta'aa ka tasa fuamolu kada ne toaa ki da tango kamolu, sulia na brofet suke baki 'i nao da tango kera lau gu mai 'uri nai.” ");
INSERT INTO bvd_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Sa Disas nia toolangaidoo ka bae lau gu 'urii, “Aia ma ni nau, na bae laku fua molu toaa ne molu fafurongoa bae laku nai 'e 'urii guu. Molu liosau 'ana toaa ne da susubutai kamolu ma na malimae kamolu ki, molu ka ilia doo diana ki fuada. ");
INSERT INTO bvd_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Molu gania God ka 'oilaketainia toaa ne da saketo kamolu ma daka agi kamolu uri mae lae ki. ");
INSERT INTO bvd_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Lea waa 'e fidalia babalimu, 'oko bulasia ruana bali 'oko faolomainia uri nia ka fidalia lau guu. Lea ta waa 'e ngalia na 'ana si maku baite 'oe ni ofi, 'oko faolomainia lau guu si maku tu'uu 'oe 'i fara fuana. ");
INSERT INTO bvd_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tii gu 'ana ne gani 'oe uri si doe, 'oko faa fuana, nao 'osi luia doe ki. Ma nao 'osi gani nia lau uri ka oli fainia fuamu. ");
INSERT INTO bvd_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Doo ne 'oe dooria waa ki daka ilia fuamu, nia lau gu ne 'oe ilia fuada. ");
INSERT INTO bvd_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Lea kamolu molu liosau gwamolu 'ana toaa kwaimani kamolu ki, nia 'afitai fua molu ka ngalia ta kwaiaraa uri maana. Sulia na toaa abulo ta'aa neki boroi nee, ili lada ki naa ne 'uri nai. Da liosau gu 'ada 'ana toaa kwaimani kera ki. ");
INSERT INTO bvd_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma lea kamolu ka nao molu si 'e'ete guu faasi kera, ne molu liosau gu 'amolu 'ana toaa kwaimani kamolu ki, nia 'afitai fua molu ka ngalia ta kwaiaraa uri maana. Sulia na toaa abulo ta'aa neki boroi nee, ili lada ki naa ne 'uri nai. ");
INSERT INTO bvd_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma lea kamolu molu faa gu 'amolu 'ana toaa ne molu manata ngado 'ani kera dai faa lau gu mai 'amolu, nia 'afitai fua kamolu ka ngalia ta kwaiaraa uri maana. Sulia na toaa abulo ta'aa neki boroi nee, ili lada ki naa ne 'uri nai. Da faa gu 'ada 'ana toaa ne da manata ngado 'ani kera dai faa lau gu mai ada. ");
INSERT INTO bvd_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Aia ma ni kamolu, molu ka liosau 'ana malimae kamolu ki, molu ka ade diana fuada. Molu ka faa 'ana toae ki, nao lau sulia ne molu manata ngado 'ani kera dai faa lau gu mai 'amolu. Lea kamolu ade 'uri nai, kamolu kai ngalia kwaiaraa baita uri maana. Ma molu kai usulia mamana guu God, ne nia baita ka talua doo ki sui. Suli God nia waa ade diana fua toae ki sui, ka lea boroi 'ana ta waa ne nao si sae diana lana guu doo neki God 'e ilia ki fuana. ");
INSERT INTO bvd_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kamolu ka 'ofea waa ki ka ilingia ne God nia 'ofe kamolu. ");
INSERT INTO bvd_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Kamolu nao molu si ketoa ta waa kau, uri God lau guu ka nao si keto kamolu. Ma ka nao molu si alua ta kwakwaea faafi ta waa kau, uri God lau guu ka nao si alua ta kwakwaea fuamolu. Molu manata lukea waa ki, uri God lau guu ka manata luke kamolu. ");
INSERT INTO bvd_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Molu ka fale 'ana waa ki, suli God lau guu nia fale diana 'amolu. God kai tolingi diana tasa 'ani kamolu 'ana doo diane ki, ma kamolu kai taungia 'ana wai kamolu ki lelea ka sata guu, ka fungu 'alamaa ka 'asia guu 'i sara. Lea kamolu molu fale diana 'ana waa ki, God lau guu nia kai faledoo diana fuamolu.” ");
INSERT INTO bvd_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Sa Disas nia ka saea lau gu tii si baea ni tarifula lae fuada ka bae 'urii, “Nia 'afitai fua ta waa maana rodo ka talaia lau gu ta waa maana rodo. Lea nia ade 'uri nai tara keeru sui guu kai 'asi keeru 'i lao kilu. ");
INSERT INTO bvd_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Aia, na waa kwairooi lae gu 'ana, nia nao si talua waa ni toolangaidooa nia. Sui ta, lea waa ni kwairooi 'e filoa sui naa doo neki da tooa ki siana, nia ka usulia lau gu 'ana waa ni toolangaidooa nia. ");
INSERT INTO bvd_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“'Oe, na abulo ta'aa laa talingai 'e nii gu 'ana lao mauria 'oe, ma sui 'oko ngatafia 'amu waa ne nia ilia gu 'ana kasi abulo ta'aa laa tu'uu. Talafana bae sae 'oe 'o sasi 'amu fai kau lana si lolo tu'uu 'asia guu fasi lao maana toolamu nai, mani 'oe 'oko too 'amua fai gaafana si tofi 'ai talingai nai lao maamu 'osi bae gu sulia. Ade laa 'uri nai ka nao. ");
INSERT INTO bvd_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nao 'osi bae gu 'amu 'urii fua toolamu, ‘'Oe too 'amu fasi ili lana doo garo ki wala.’ Ma sui 'oe 'oko dau gu 'amu 'ana ili lana doo garo baita ki 'asia naa, ka nao si 'oga 'oe guu. 'Oe waa suke 'ua nee. 'O lea 'oko 'olosia fasi 'amu abulo ta'aa lae talingai 'oe nai ki, sui 'o too aoloa fatai ta 'ofi 'olosia kasi abulo ta'aa lae tu'uu toolamu.” ");
INSERT INTO bvd_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Sa Disas ka saea lau gu tii si baea ni tarifula lae fuada ka bae 'urii, “Na 'ai ni 'anie nia 'afitai ka fungu 'ana fuaedoo bubulo. Ma na 'ai bubulo boroi nia 'afitai ka fungu 'ana fuaedoo diana. ");
INSERT INTO bvd_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","'Ai ne diana ma nao ta 'ai ne bubulo boroi, na fuana naa ne kolu kai filoa ai. Na 'oko kwakware ma ka kwasi neki, kera 'afitai fua ta waa ka ngedaa lau ta fuaedoo diana faasida. ");
INSERT INTO bvd_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Talafana lau guu, na waa diana ka ilia lau gu doo diana ki ne tae mai fasi dianae lao liona, ma na waa ta'aa ka ilia lau gu doo ta'aa ki fasi ta'aa lae ne 'ita mai lao liona. Si doo ne fungulia mai lao lioewane, nia naa ne waa kai sae tafa ai.” ");
INSERT INTO bvd_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Sa Disas ka bae lau 'urii fuada, “Kamolu, si kada molu bae tale nau molu ka bae 'ua gu 'urii, ‘'O Aofia 'ae,’ ma sui dodolofia guu molu ka ade sulia doo ne ku saea ki fua molu! ");
INSERT INTO bvd_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tii gu 'ana ne lea mai siaku uri fafurongo lana doo ne ku saea, ma ka ade sulia bae laku, si doo kui faabolatainia sulia 'e tio. ");
INSERT INTO bvd_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nia 'e 'uria ta waa bae saungai luma, ma ka 'elia luma nai ka boongai fafona fau lalifuu nai. Bae ute dao ka 'arungi toi, ma kafo igwa ka liu toi ma sui boroi 'ana luma nai ka ngilo ka too gu 'ana, sulia kera saungai diana ai ka tio ngado fafona fau lalifuu. ");
INSERT INTO bvd_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tii gu 'ana ne nia fafurongoa bae laku, ma ka nao si ade gu sulia, nia talafana waa ne saungai luma gwana fafona one, ma ka nao si boongai lalifuu. Ma kada kafo nia igwa ka liu 'ana luma nai, nia ka ifu ma ka okosi tiifau.” ");
INSERT INTO bvd_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Burina sa Disas nia falebaea fua konia nai sui, nia lea ka dao lao maefera baita 'i Kabaneam. ");
INSERT INTO bvd_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Aia, tii waa baita ni omee kera toaa Rom ki 'i seeri, nia too 'ana tii gwa waa ni rao, ma nia ka liosau 'asia naa 'ana gwa waa ni rao nia nai. Ma sui gwa waa ni rao nai ka matai baita karangi kai mae naa. ");
INSERT INTO bvd_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kada waa baita ni omee nai 'e rongo alinga 'ana dao lana kau sa Disas, nia ka odua mai waa baita kera toaa Diuda ki, ka saea kera lea mai daka faarongoa sa Disas uri lea ka guraa gwa waa ni rao nia nai. ");
INSERT INTO bvd_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kera lae mai da dao tona sa Disas, daka bae kwai amasi fuana, daka 'urii, “Sa wala nee, nia bobola naa uri 'oko guraa gwa waa ni rao nia. ");
INSERT INTO bvd_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Sulia nia waa 'e liosau 'ani kameli toaa Diu ki ne, ma ka saungainia lau guu beu ni ofu laa kameli nee.” ");
INSERT INTO bvd_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Sa Disas ka lea na kau fai kera. Lelea kau 'e dao karangia naa luma nia waa baita nai, daka suana sa wala nai odua lau mai tai waa kwaimani 'ana, uri toda lana sa Disas sulia taale. Waa nai ki daka faarongoa sa Disas 'ana bae lana waa baita nai, ne nia 'urii, “Wala arai 'ae, nao 'osi ulafu boroi 'amu 'ana lea lae mai. Sulia nau kusi faorana guu sae 'oko lea mai 'oko ruu 'i luma kani. ");
INSERT INTO bvd_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ma nau boroi kusi bobola lau guu fai lea lae mai uri todalamu. 'O saea boroi 'amua mai si baea fua gwa waa ni rao nau nee, uri nia ka 'akwaa 'ana. ");
INSERT INTO bvd_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nau ku saitomana 'uri nai, sulia nia 'uri nau lau guu, ne lea waa baita nau odu nau uri ili lana doe, nau ku ilia naa. Ma ni nau boroi ku 'inito lau gu faafia waa ni rao ki, ne dau ilia lau guu si doo kui saea fuada uri ili lana. Lea nau ku bae 'urii fua ta waa ada, ‘'Oe lae ilia fasi doo 'urii,’ nia lea ka ilia naa. Ma nao lea ku bae 'urii fua ta waa lau, ‘Lae fasi mai see,’ nia ka lea na mai. Ma nao sae lea ku bae 'urii fua gwa waa ni rao nau nee, ‘'Oe lae ilia fasi doo 'urii,’ nia ka ilia naa, 'afitai ka nao lau.” ");
INSERT INTO bvd_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kada sa Disas nia rongoa si baea nai sa wala nai saea, nia ka kwele lau gu 'ana ai. Sui nia abulo ka lio fua konia baita nai da lea mai burina, ka bae 'urii fuada, “Ku faarongo kamolu, na kwai fiitooa ne sa wala ne too ai nee, doo dodolofia ta waa boroi lao fera nee 'i 'Israel ku suai 'ua 'ani nia ne!” ");
INSERT INTO bvd_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aia, toa bae da laefia mai sa Disas uria gura lana gwa waa ni rao bae, da oli kau dao 'i luma daka suana gwa waa nai nia 'akwaa naa. ");
INSERT INTO bvd_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nao si tau 'asia guu 'i burina si doo nai, sa Disas nia ka lea naa uria maefera baita nai 'i Nein. Na waa kwairooi nia ki fai tii leaa baita daka lea lau gu kau fai nia. ");
INSERT INTO bvd_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kada nia lea kau ka dao maa maesakaa 'ana maefera baita nai, nia lio kau ka suana toaa nai da ngalia mai tii waa mae nai daka ruu na mai fainia uri maa. Na waa mae nai, nia tii fa wela wane saimamana nia guu gwa 'oruai nai 'i seeri. Ma toaa 'oro ki ne da too lao maefera baita nai daka lea kwaimani sui mai fai 'initai 'oru nai ma daka ngalia mai 'alakwa nia ne mae nai. ");
INSERT INTO bvd_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kada na Aofia 'e suana gwa 'oru nai, nia ka manatainia 'asia naa, ka bae 'urii fuana, “Nao 'osi angi lau.” ");
INSERT INTO bvd_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kada nia bae 'uri nai, nia fali kau ka dau tona naa gwegele nai fai waa mae nai. Ma na toa nai da ngali mai sa wala nai daka uu ngado fasi 'ada 'i seeri ma sa Disas ka bae 'urii talea waa nai, “'Oe waa daraa nee, nau ku saea fuamu, 'o tatae 'amua!” ");
INSERT INTO bvd_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ma waa mae nai sulatatae ka gooru ka bae 'ua guu 'i seeri. Ma sa Disas ka odua ka lea na kau sia gaa nia. ");
INSERT INTO bvd_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ma toaa nai ki sui guu da suai doo nai fuli, daka kwele 'asia naa ma daka mau lau gu 'ada. Ma daka bae 'urii 'ana faabaita lana God, “Tii brofet talingaia ne tatae naa fasi matangameli nee rowaa! Ma God naa ne lea mai ka 'adomi kolu toaa nia nee!” ");
INSERT INTO bvd_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ma ununue sulia sa Disas, ka talofia sui naa lao bali lolofaa 'i Diudia fai maefera kakalia ki lau guu. ");
INSERT INTO bvd_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Na waa kwairooi sa Dion ki da unu sulia ilidoo lana sa Disas ki siana sa Dion. 'Uri nai sa Dion ka 'ailia mai ta roo waa 'ani kera siana. ");
INSERT INTO bvd_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Nia ka odua roo waa nai ki daru ka lea naa sia sa Disas na Aofia, uri daru ka leditona daru ka bae 'urii, “Nia sae 'oe naa 'oto ne Kraes bae meli maasia mai dao lamu, ma nao waa nai nii 'ua mai uri meli ka maasia 'ameli?” ");
INSERT INTO bvd_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Aia, kada roo waa nai ki lea kau daru ka dao naa siana sa Disas, keeru daru ka bae 'urii, “Sa Dion Waa ni Faasiuabu ne odu kaaria mai uri miri ka ledi tomu 'urii, ‘Nia sae 'oe naa 'oto ne Kraes bae meli maasia mai dao lamu, ma nao waa nai nii 'ua mai, uri meli ka maasia 'ameli?’” ");
INSERT INTO bvd_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","'Ana kada nai roo waa nai ki dao ai sia sa Disas, sa Disas guraa mataia 'e'ete 'oro ki sui gu 'ana faasia toaa 'oro ki ma ka taria lau guu anoedoo ta'aa ki faasia toaa 'oro ai. Nia ka 'ifingia lau gu maana waa maarodo ki daka lilio 'ana si kada nai. ");
INSERT INTO bvd_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","'Uri nai guu, sa Disas ka bae 'urii fuadaru, “Muru oli 'amuru kau lea dao, muru ka faarongoa sa Dion 'ana doo neki sui guu kamuru tala rongoa ma muru ka tala suai gu kau nee. Kamuru, muru tala suai gu ne toaa maarodo ki kera lilio lau, ma toaa 'aemae ki kera ka fali lau, ma toaa furoa ki kera ka diana lau, ma toaa alinga boko ki alingada ka 'ifi lau nee. Ma toaa mae ki boroi kera daka mauri lau gu 'ada, ma toaa siofaa ki kera ka rongoa naa si faarongoa diana nee ku bae sulia. ");
INSERT INTO bvd_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","'E diana tasa fuana toaa neki nao dasi ote kera 'ani nau faafia doo neki ku ilia nee.” ");
INSERT INTO bvd_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","'I burina roo waa kwairooi sa Dion ki daru oli naa, sa Disas ka bae na sulia sa Dion fua konia nai ka ledi 'urii 'ani kera, “Kada bae kamolu lea kau molu ka fafurongoa bae lana sa Dion lao fera kwasi loko, tee bae kamolu lea kau uri suai lae? Kamolu lea kau uri suai lae nia waa fiitooa nia 'igi'igi gu 'ana mala ta 'aba rade bae koburu saulia ka gelo kwailiu bae, ma nao 'utaa? Nia nao lau ta waa manata lana 'uri nai bae! ");
INSERT INTO bvd_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ma nao kamolu suana nia ta waa fua ofi lae 'ana si maku kwanga ki ne liu lada maadiua ki bae, ma nao 'utaa? Nia nao lau gu ta waa 'uri nai bae. Na waa suadoo ki 'ana ne dai ofi asi maku 'uri nai ki, ma dai too lao beu diana tasa neki 'ua guu fua waa 'inito ki! ");
INSERT INTO bvd_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ma lea nia nao lau waa 'uri nai, tee 'ana bae molu lea kau uri suai lae? Ma nao nia na brofet 'oto? Iuka, tee mone! Nia na brofet mamane 'ua gu bae! Ma nia ka 'initoa ka talua lau brofet baki sui gu mai 'i nao. ");
INSERT INTO bvd_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tee sa Dion naa bae da kekeda mai sulia lao kekeda laa Abu ki, bae God nia bae 'urii suli nia, ‘Suai fasi, nau kwai falea kau na waa ni faarongo nau kai eta dao kau 'i nao 'ani 'oe, uria ka ade akau 'ana tooe maasi 'oe.’” ");
INSERT INTO bvd_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Sui sa Disas ka bae lau 'urii fuada, “Ku faarongo kamolu, sa Dion nia 'initoa ka talua sui naa toaa ne da futa lao molaagali. Sui boroi 'ana, ta waa mala nia boroi 'ana ne God 'inito 'ani nia, waa nai kai 'initoa ka talua lau sa Dion.” ");
INSERT INTO bvd_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Aia, na toaa 'oro nai ki sui guu da fafurongoa bae lana sa Disas nai, ka lea boroi 'ana waa ni koni lana malefo 'ana takisi ki, kera saitomana ne taala nia God taifilia gu ne 'o'olo ma ka mamana. Ma kera daka lukasia abulo ta'aa laa kera ki ma sa Dion ka faasiuabu kera sui guu. ");
INSERT INTO bvd_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ma Faarisii ki fai waa ni toolangaidoo lae 'ana taki ki, daka ote kera guu lea sulia taala nai 'ana luka lae 'ana abulo ta'aa laa kera ki uri sa Dion ka faasiuabu kera. ");
INSERT INTO bvd_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Sa Disas ka bae lau 'urii fuada, “Kamolu saitomana doo ne kwai faabolatai kamolu toaa abu faamamane nee 'i tari'ina fainia? Kamolu molu mala 'ana kaala wela tu'uu ");
INSERT INTO bvd_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","da gooru 'i maana usie ma ta bali ada ka bae 'urii kau fua ruana ta bali, ‘Kamolu nee, meli ka ufi 'au boroi uri elee fuamolu, molu ka ote kamolu ni wae guu! Ma sui meli ka sili'aeweo ki boroi 'ana liodila lae fua molu, ka nao molu si doori liodila guu!’ ");
INSERT INTO bvd_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nia 'uri nai, kada sa Dion Waa ni Faasiuabu lae 'e dao mai ka ili raoa, nia ka abufanga, ka abu si kuufia waen. Aia 'i seeri, kamolu ka saea nia waa 'e too 'ana anoedoo ta'aa. ");
INSERT INTO bvd_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Aia, ma sui kada nau 'Alakwa Nia Wane, ku dao mai nao kusi abufanga ma kusi abu guu 'ana kuufi lana waen. 'I seeri, kamolu ka bae 'amolu 'urii, ‘Suana fasi 'amolu waa fangaoe ma kuuoe loko wala! Nia na ruana kera toaa neki ni koni malefo lae 'ana takis fai toaa ilidoo garo neki naa loko!’ ");
INSERT INTO bvd_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sui boroi 'ana ta, toaa ne da roo lau 'ada sulia manataa lae nia God ne da faatainia nia mamana.” ");
INSERT INTO bvd_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tii waa 'ana Faarisii ki satana sa Saemon nia kwailaefi mai uri sa Disas lea ka fanga 'i luma kera. Sa Disas lea kau dao 'i luma nai, nia gooru ka gege kau daka fanga naa. ");
INSERT INTO bvd_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Aia, da fanga gu 'ada 'uri nai lio boroi, tii wela keni too lau gu 'ana maefera nai ka dao lau gu kau. Wela keni nai 'e rongo alinga 'ana sa Disas kai lea kau uri fanga lae 'i luma nia Faarisii nai. 'Uri nai, ni wala nai ka ngalia mai tii bii waiwai fungu 'alamaa nai moko lana diana 'asia naa, ka lea mai fainia ka dao. ");
INSERT INTO bvd_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nia ruu mai luma lea ka uu 'i buri sa Disas karangia 'aena. Nia ka angi 'i seeri, na kafona maana ka gwinifia naa 'aena sa Disas. Ma nia liu ka usua naa kafona maana fasi 'aena sa Disas 'ana ifuna 'i tala'ana. Nia ka nonoia lau guu 'aena sa Disas ki, ma ka kistainia naa waiwai moko diana nai fua fafo 'aena ki, ka gwaia ki nai. ");
INSERT INTO bvd_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kada Faarisii ne 'ailia kau sa Disas uri fanga lae luma kera 'e suai, nia ka manata 'urii, “Sa wala nee, lea sae nia ta brofet mamana nee, doo nia ka filoa gu 'ana kwaini ai 'urii ne. Na wela keni abulo lana ta'aa 'asia naa ne too kai dau tona nonina nee, ma sui ka nao si filoa guu!” ");
INSERT INTO bvd_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sui ma sa Disas ka luua na 'ana sa Saemon ma ka bae 'urii, “Nau ku dooria sae lana tii si doo fuamu, 'oe sa Saemon.” Sa Saemon ka 'urii, “Tee ne 'oe dooria sae lana fuaku wala waa ni toolangaidoo?” ");
INSERT INTO bvd_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Sa Disas ka bae na 'urii fuana, “Totoo ta, roo waa nai ki lea daru ka ngali langa 'ana malefo ki sia tii waa ni falelanga laa nai. Ta waa ka ngali langa 'ana lima talangia ki, aia ma ta ruana waa ka ngali langa 'ana lima akwala ki guu. ");
INSERT INTO bvd_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Totoo lelea, keeru sui guu daru si bobola naa fai duu lana malefo kera nai ki. 'I seeri, na waa bae falelanga 'ana malefo baki fuadaru ka manatai keeru na 'ana ka saea tio boroi 'ana duu lana ki. 'Uri nai, tii guu 'ana roo waa nai ki ne bobola fainia kai liosau baita ka tasa 'ana waa ni falelanga laa nai, ka talu keeru sui?” ");
INSERT INTO bvd_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sa Saemon 'e luua ka bae 'urii, “Na waa bae ngali langaa nia baita ka talu keeru sui naa na, ma sui waa ni falelangaa bae ka manata luke nia gu 'ana.” Ma sa Disas ka 'urii, “Tee mone, 'oe saea ka too naa nai wala.” ");
INSERT INTO bvd_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Sui, sa Disas abulo ka lio kau uri wela keni bae ka bae lau gu 'urii fua sa Saemon, “'Oe suana wela keni nee. Kada ne ku dao mai lao luma 'oe nee, 'oe nao 'osi faa gu tasi kafo uri taufi lana 'aeku ai. Aia ma ni wala nee, nia ne taufia na 'ana 'aeku 'ana si kafo 'i maana, ma ka usua na 'ana 'aeku 'ana ifuna 'i tala'ana. ");
INSERT INTO bvd_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","'Oe nao 'osi nonoi nau guu 'ana iagori lae suli nau ne ku dao mai luma kamu. Aia ma ni wala nee, 'ita bae nau ku dao mai nia nonoia 'aeku ka nao si luka 'ua mone 'ana ai nai. ");
INSERT INTO bvd_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ma 'oe nao 'osi kanoa gu gwauku 'ana ta waiwai. Aia, ma ni wala nee nia gwaia na 'ana 'aeku ki 'ana waiwai moko diana nee. ");
INSERT INTO bvd_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nia 'uri nai nau ku faarongo 'oe, na abulo ta'aa laa 'oro neki wela keni nee nia ilia ki mai, God 'e manata lukea naa faasi nia, ma ka adea nia ka suaku ka diana 'asia naa. Ma sui ta, waa ne nau ku manata lukea faasia si abulo ta'aa laa tu'uu gu 'ana, nia suaku si diana 'asia guu.” ");
INSERT INTO bvd_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Sui sa Disas ka bae na 'urii fua wela keni nai, “Nau ku manata lukea abulo ta'aa laa 'oe ki.” ");
INSERT INTO bvd_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kada nai, toaa nai da fanga kwaimani lau gu fai sa Disas daka rakesasui nia naa, daka bae 'urii 'i matangada kwailiu, “Ma sa wala nee sa tii 'ana nee? Ma tee abulo ta'aa lae ki boroi nia ka manata lukea gu 'ana nee!” ");
INSERT INTO bvd_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sa Disas ka bae 'urii lau fua wela keni nai, “Manatamu ka enoeno 'ana, oli 'oko lea 'amua. God nia faamauri 'oe naa, sulia 'oe faamamane nau.” ");
INSERT INTO bvd_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","'I burina ki lau guu, sa Disas ka lea naa uri maefera baita ki ma maefera tu'uu ki sui gu 'ana uri faarongo lae 'ana faarongoa diana sulia 'initoaa God. Ma na akwala ma roo waa sarenga nia baki daka lea kwaimani lau gu fai nia. ");
INSERT INTO bvd_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Na wela keni baki sa Disas taria anoedoo ta'aa ki faasi kera ma tai ai bae nia guraa tai mataia 'e'ete ki lau faasi kera, da lea kwaimani lau gu fai nia. Ai nai ki ne: ni Meri faasia maefera 'i Magdala bae sa Disas taria fiu anoedoo ta'aa baki faasia, ");
INSERT INTO bvd_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ni Dioana, 'afe sa Kusa waa baita kera bae toaa da rao lao beu sa Herod waa 'inito, ni Susana, ma tai ai 'oro lau gu 'uri nai. Wela keni nai ki da falea si malefo faasia suadooa kera ki tala'ada, fua ka 'adomia sa Disas fai waa kwairooi nia ki. ");
INSERT INTO bvd_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kada toaa da lea ki mai fasi maefera baita nai ki sui gu 'ana da koni sia sa Disas, nia ka unu sulia tii si tarifulaa ka 'urii, ");
INSERT INTO bvd_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Totoo tii waa nai lea ka fasia naa ola wiiti nia. Kada nia afutaa migana wiiti nia ki, tai miga doo ka 'asia lao taale ni liu lae lao ole. 'Uri nai, waa ki liu daka dalia gu 'ada, ma tai doo ai na saaro lolofo ki 'i mamangaa koso mai daka 'ani lau gu 'ada. ");
INSERT INTO bvd_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Aia, tai miga doo daka 'asia gu 'ada lao si saegano 'e faula, daka bulao mai daka tae guu sulia si kada kukuru, sui 'ali'ali daka kuku lau gu 'ada, sulia si saegano nai 'e lalangafikoa. ");
INSERT INTO bvd_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ma tai miga doo daka 'asia gu 'ada matangana lalano kwakware ki, ma lalano nai ka buru na 'ana ki faafida. ");
INSERT INTO bvd_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma sui, tai miga doo lau daka 'asia fafona si saegano diane, ma daka tae diana daka fungu naa 'ana fuaedoo 'oro ki.” Sa Disas 'e faasuia si ununua nai 'i seeri, ka bae 'urii, “'Oe waa ne 'o too 'ana alingamu uri rongo lana doo ki, 'o rongo doo nai ki 'oko rongo diana ai.” ");
INSERT INTO bvd_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Aia, waa kwairooi sa Disas ki da ledi nia uri ka 'inifitaa malutana si tarifulaa nai fuada. ");
INSERT INTO bvd_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nia luu kera ka bae 'urii, “Kada 'i nao God nao si faatai folaa 'ua 'ana dongana 'initoaa nia fua toaa 'i nao. Ma sui 'i tari'ina God nia faatai folaa naa 'ana dongana 'initoaa nai fuamolu waa kwairooi nau ki. Ma toaa neki sui gu 'ana, na tarifulaa neki naa ne kwai unu sulia fuada kada kwai falebaea sulia dongana 'initoaa nai. Uria kera ka bubungia boroi doo neki da fuli ki ka nao dasi liofiloda guu, ma daka fafurongo boroi nao dasi rongo filoa guu si doo ne God ilia ki nee.” ");
INSERT INTO bvd_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Sa Disas ka bae lau 'urii, “Na malutana tarifulaa bae nia 'urii bae: Na migana wiiti ni fasi lana baki, kera talafana si baea nia God. ");
INSERT INTO bvd_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ma miga doo baki da 'asida lao taala ni liua lao ole, kera talafana toae ki kada kera rongoa si baea nia God, ma sui Saetan lea mai ka taga lau gu 'ana ai fasi lao manata lada uri ka nao dasi faamamanea lau God ade ka faamauri kera. ");
INSERT INTO bvd_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ma na migana wiiti bae da 'asia lao si saegano 'e faula, kera talafana toae ki kada kera rongoa si baea nia God, ma kera 'ali'ali daka ala faafia daka ele nada sulia ma sui ka nao si lalisusu 'ua guu lao mauria kera ki. Ma kera ka faamamanea guu sulia si kada kukuru. Ma si kada kera dao toi 'afitaia ki faafia, kera daka luka lau gu 'ada ai. ");
INSERT INTO bvd_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Na miga doo baki da 'asia 'i matangana lalano kwakware baki, kera talafana toae ki kada da rongoa si baea nia God, sui da oli kau na manata lada ka isifufuli lau gu 'ana sulia doo 'e'ete 'oro lao molaagali, mala 'ana malefo ma elelea sala. Ma doo nai ki ka adea mauria kera ki ka nao si rafo uri fungu lae 'ana ta fuaedoo fua God. ");
INSERT INTO bvd_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Aia, na miga doo baki da 'asia lao si saegano diana, kera talafana toae ki kada kera rongoa si baea nia God, ma daka dau ngasi faafia fai manata dianaa ma manata mamanaa lao lioda. Ma daka noni maabe daka susuu ta'aa na fainia lelea daka dao toi guu dianaa 'oro ka tasa 'i gwauna.” ");
INSERT INTO bvd_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Sa Disas ka bae lau 'urii, “Doo nao toae ki si ilia ne faasaru lana kwesu ma sui lea daka agwaa 'ada fara ta tiu ma nao fara ifitai. Doo dai ilia 'ada ne faasaru lana kwesu sui daka urungaa ka uu 'i langi, uri ka saru folaa fua toaa da ruu ki mai luma daka suai. ");
INSERT INTO bvd_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Nau ku bae 'uri nai sulia totoo tafa dani, doo tio saufini neki dai alu faatai ai, ma doo agwa neki dai too folaa fua toae ki daka suai. ");
INSERT INTO bvd_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Nia 'uri nai, kamolu molu ka fafurongo diana 'ua guu uria si baea nee sulia 'initoaa God, sulia waa ne susuu ka dau fafo 'ana ta kaa kula tu'uu boroi 'ana si baea mamana neki ku faarongo kamolu ai, God kai faa 'ana ka 'idu lau 'i fafona. Ma waa ne nao si dau fafo guu 'ana ta kula ai, ta kaa saitomadooa ne nia kwaifii 'ana sae sa nia too boroi ai, God kai tagalangainia lau gu 'ana faasia.” ");
INSERT INTO bvd_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","'Ana kada nai guu, gaa nia fai saasina sa Disas ki daka dao na mai. Kera daka doori bae fai nia, sui ma ka 'afitai fuada uri lea karangi lana mai, sulia toaa 'oro 'asia naa da koni kalia sa Disas 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ma tii waa lao konia nai ka bae 'urii fuana, “Gaa 'oe fai saasimu ki loko da dao daka nii gu 'ada mai maa, ma daka doori bae fai 'oe.” ");
INSERT INTO bvd_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Sa Disas abulo ka bae 'urii fua konia nai tiifau, “Toaa ne kera rongoa si baea nia God ma daka ade sulia, kera 'ana ne gaa nau ki ma toolaku ki.” ");
INSERT INTO bvd_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tii si kada, sa Disas fai waa kwairooi nia ki da tae lao tii baru nai nia ka bae 'urii fuada, “Kolu toofolo naa uri bali 'osi loko nai.” Nia bae 'uri nai sui, kera ka lea na kau. ");
INSERT INTO bvd_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ma kera lea kau 'uri nai lelea guu sa Disas 'asi nia tio ka maleu na 'ana. Kada nia maleu 'ana, tii mae taba'elo nai ka tae lao 'osi talingai nai ma koburu ka too naa. Ma baru kera nai ka fungu 'ana kafo lelea karangi kera da kai kuruu naa. ");
INSERT INTO bvd_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","'I seeri, waa kwairooi nia ki lea daka faa ada nia daka bae 'urii, “Arai nee 'ae, ma kolu kai funu naa ne wala!” Sui sa Disas nia tatae ka ngatafia koburu nai fai nanafo nai, ma kera daka ade na suli nia ma 'i seeri lao 'osi nai ka aroaro naa. ");
INSERT INTO bvd_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sui sa Disas liu ka ledia waa kwairooi nia ki ka bae 'urii fuada, “Nee rowaa, ma tee ne adea ka nao molu si faamamane nau 'amolu?” Ma kera daka kwele daka mau 'asia naa, ma daka bae 'urii, “Toa nee 'ae, ma waa ai tee nee? Tee koburu ma nanafo nee boroi daka ade nada sulia bae lana nee!” ");
INSERT INTO bvd_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sui sa Disas fai waa kwairooi nia ki daka faafolo lau kau daka dao naa 'ana bali fera nai 'i Gerasa, ne too ai daka liofolo lau gu kau uri Galilii 'ana bali 'osi loko 'ana 'osi nai. ");
INSERT INTO bvd_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kada sa Disas dao ka koso 'i sara, nia ka todaa naa tii waa fasi maefera nai 'i seeri, ne anoedoo ta'aa ki da burosi nia ka tau na mai, ma nia ka too dadara ki gu 'ana. Ma waa nai ka nao si tio guu 'i fera, ka tio ki gu 'ana lao faaluma ni alu wane ki. ");
INSERT INTO bvd_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","'Ana kada 'oro, toaa nia ki da daua daka kania 'abana fai 'aena ki daka alua waa ka lio suli nia. Ma sui boroi 'ana, nia ka muusia gu 'ana seni ma 'oko ngasi neki da kani nia ai. Ma anoedoo ta'aa nai ka laetainia ka liufia gu 'ana lao fera kwasi ki. Aia, kada nia suana sa Disas 'e dao mai 'uri nai, nia ka kokoo baita, ka 'asi nia ka booruru naa 'i saegano maa 'aena sa Disas, ka bae 'urii, “'Oo Disas, 'oe 'alakwa nia God ne 'initoa ka tasa. Tee naa ne 'oi ilia 'ani nau nee? Nau ku ledi 'oe, nao 'osi falea 'ua nonifiia baite fuaku.” Sa Disas ka bae 'urii fuana, “'Oe na anoedoo ta'aa nee, 'otolangai 'oe lea 'amu fasi sa wala nee.” ");
INSERT INTO bvd_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Sa Disas ka ledi 'urii 'ani nia, “Satamu sa tii nee?” Nia luua ka bae 'urii, “Sataku sa omee baite.” Nia bae 'uri nai, sulia waa nai nia too 'ana anoedoo ta'aa 'oro 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Na anoedoo ta'aa nai ki daka ledia sa Disas uri ka nao si odu kera lau fua lao kilu liu 'ana kwakwaea. ");
INSERT INTO bvd_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ma kada nai lau guu, tii ferae boso nai kai 'eli gu 'ana sulia si raofaia nai. 'I seeri, anoedoo ta'aa nai ki, kera daka ledia naa sa Disas uri nia ka odu kera 'ana fua lao boso nai ki. Sa Disas ka kwaifaolomai fuada. ");
INSERT INTO bvd_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Na anoedoo ta'aa baki da lea gu kau fasi sa wala bae, daka ruufia naa ferae boso bae tiifau. Aia, na ferae boso bae tiifau kera tii fa gwasule laa daka liutoli tiifau sulia 'oba 'afitai bae daka lofo tiifau lao 'osi koso fubae, daka kuu daka mae tiifau. ");
INSERT INTO bvd_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Toaa ni sangoni boso nai ki daka suai doo nai fuli 'uri nai, kera tiifau daka tafi naa uri lao maefera baite nai. Lea kau dao daka faarongo talo naa sulia doo nai fua toae ki lao maefera nai ma 'ana kasi maefera tu'uu ki kalia 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Toaa nai ki da rongoa si doo nai, kera ka lea na mai uri kula nai si doo nai fuli kau ai fua lio 'isi lae ai. Ma kada da lea mai dao seeri sia sa Disas, daka suana waa nai anoedoo ta'aa nai ki lea faasi nia nai, 'e manata naa ka ofi ka gooru ngado too kai fafurongoa 'ana sa Disas ma kera daka mau lau gu 'ada. ");
INSERT INTO bvd_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ma toaa ne da tala suana mai sa wala nai nia too 'ana anoedoo ta'aa ki ma daka tala suana sa Disas taria anoedoo ta'aa nai ki faasi nia, kera unu sulia fuli lana doo nai ki siana toaa ne da koni mai 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Sui guu, toaa nai ki sui gu 'ana bali lolofaa nai Gerasa daka odua naa sa Disas uri ka lea 'ana fasi seeri, sulia da mau 'asia naa 'ana doo nai 'e fuli nai. Sa Disas ka raa lao baru daka oli lau gu 'ada uri bali loko 'ana 'osi. ");
INSERT INTO bvd_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kada nai kera tatae dau lea naa, waa nai na anoedoo ta'aa ki lea na faasia nai, nia lea mai ka radi na kalia sa Disas uri ka lea na 'ana fai nia. Sui ma sa Disas ka faaolitai nia ka bae 'urii fuana, ");
INSERT INTO bvd_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“'Oe oli 'amu sia toaa 'oe fera kamu. Lea kau dao 'oko faarongo kera 'ana doo talingai ne God nia ilia fuamu nai.” Sa wala nai ka oli naa 'i fera kera, ka lea kau dao ka ununu na sulia doo nai ki sa Disas ilia fuana nai. ");
INSERT INTO bvd_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kada sa Disas oli mai ka dao 'i bali 'osi nee, konia baita bae daka maasi nia ma daka ele 'asia naa uri sua lana ne nia dao mai. ");
INSERT INTO bvd_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tii waa baita ni sua lae sulia beu ni ofu laa kera toaa Diu ki seeri, ne satana sa Daeras, nia lea mai ka dao sia sa Disas. Nia dao ka booruru maa 'aena sa Disas, ka bae fifii naa fuana sa Disas uri ka lea fainia 'i luma kera, ");
INSERT INTO bvd_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","sulia tii kafa wela keni saimamana nia nai 'e matai baita 'asia naa ka tio naa uri mae lana. Wela keni nai 'e baita ka dao guu 'ana taafuli fa ngali ma roo fa ngali sarenga ki. Ma kada sa Disas tatae ka lea kau fai nia, toaa 'oro nai sui gu 'ana daka kwalengai kera lau gu kau fai nia. ");
INSERT INTO bvd_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Aia 'i seeri lau guu, tii wela keni na 'abusure saungi nia mai sulia taafuli fa ngali ma roo fa ngali sarenga ki, 'e nii lau gu lao konia nai. Na wela keni nai 'e tauwelaa sui na mai suadooa nia ki tiifau fua waa ni gura mataia ki, sui boroi nao mataia nai si sui guu faasi nia. ");
INSERT INTO bvd_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","'Afa dani nai, wela keni nai 'e fali mai burina sa Disas ka samo toi kau tatagwarana maku sa Disas. 'Uri nai, na 'abu nai 'ana 'abusure nai ka lalanga naa faasi nia asi kada nai 'ua guu. ");
INSERT INTO bvd_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Sa Disas ka ledi 'urii, “Tii 'amolu bae dau toku kau bae?” Toaa nai ki sui gu 'ana daka saea kera nao. Sa Bita ka bae 'urii fua sa Disas, “Wala arai, na konia baita nee gu 'ana ne beresi 'oe nai!” ");
INSERT INTO bvd_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Sui boroi sa Disas ka bae 'urii, “Nao, waa bae dau toku kau, nau ku saitomana ku guraa na kau wane 'ana mamanaa nau bae.” ");
INSERT INTO bvd_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kada wela keni bae 'e saitomana naa ne sa Disas 'e filoa gu 'ana doo ne fuli 'ani nia, nia ka mau 'asia naa ka lelebe mai ka dao na siana sa Disas ka booruru naa maa 'aena. Ma kada konia nai da bubu tetee 'ani nia, nia ka faarongo naa 'i maada sui guu 'ana doo ne adea nia ka samo toi kau tatagwarana maku sa Disas. Ma ka faarongo kera lau guu ne nia samo tona maku sa Disas ma nia ka 'akwaa 'ali'ali 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ma sa Disas ka bae 'urii fua wela keni nai, “'Oe wela keni nee, God nia faa 'akwaa 'oe naa, sulia 'oe faamamana nau. Oli 'oko lea 'amu, nao 'osi manata 'oroa lau.” ");
INSERT INTO bvd_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kada sa Disas kai bae gu 'ana 'uri nai, waa 'e too mai luma sa Daeras ka lae mai uri nia ka dao naa. Waa nai ka bae 'urii fua sa Daeras, “Saari 'oe bae, nia nao'ana na mai. 'Oe nao 'osi faa 'abaruaa lau waa ni toolangaidoo.” ");
INSERT INTO bvd_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Sa Disas 'e rongo alinga 'ana faarongo laa nai, ka bae 'urii fua sa Daeras, “Nao 'osi mau, 'o faamamane nau 'amu tari'ina saari 'oe nia kai 'akwaa na.” ");
INSERT INTO bvd_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kada sa Disas fai kera da lea kau daka dao naa maa luma kera sa Daeras, sa Disas ka luia kera sui guu daka too 'ada 'i maa, nia fai sa Bita, sa Dion, sa Demes, fainia maa nia fai gaa nia wela keni nai gu 'ana daka ruu kau 'i luma. ");
INSERT INTO bvd_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Toaa nai sui guu da angi baita daka isisigwau guu asi kada nai. Sa Disas ka bae 'urii fuada, “Nao molu si angi lau 'urii, sulia wela keni nee nia nao si mae, nia maleu gu 'ana ne!” ");
INSERT INTO bvd_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kera da rongo si doo nai sa Disas saea, daka waelsi nia 'ada sulia da saitomana 'e mamana 'ua guu ne wela keni nai 'e mae naa. ");
INSERT INTO bvd_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sa Disas 'e fali kau ka rao uri 'abana wela keni fuu ka 'ai naa, ka bae 'urii, “'Oe wela keni nee, 'o tatae 'amua!” ");
INSERT INTO bvd_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","'I seeri, wela keni nai mangona ka alatafa lau, ka tatae ka gooru naa. Sa Disas ka saea fuada lea daka fale tasi fanga nia ka 'ani. ");
INSERT INTO bvd_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Na maa nia fai gaa nia wela keni nai, daru suai si doo nai daru ka kwele daru ka mae. Sui, sa Disas ka luia nao dasi unu sulia doo nai ki sia ta waa. ");
INSERT INTO bvd_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Sa Disas nia 'ailia mai tii akwala ma roo 'aboosol nia ki siana, ka falea tetedea fai 'initoaa fuada uri siitasa lae 'ana anoedoo ta'ae ki ma mataie ki. ");
INSERT INTO bvd_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nia ka fale kera uria faatalongai lana 'initoaa God, ma uria gura lana toaa matai. ");
INSERT INTO bvd_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ma nia ka bae 'urii fuada, “Nao molu si lada fainia ngali lana doo 'oro 'ana leaa nee. Nao molu si dau 'abarua 'ana tafa kubau, ma ka nao molu si tarufia wai. Nao molu si lada fai ngali fanga lae ma ngali malefo lae. Ka nao molu si manata 'abarua 'ana ngali lana roo si maku ni ofi lae. ");
INSERT INTO bvd_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Lea molu lea kau dao 'ana maefere ma daka gwale kamolu kau 'i luma, molu ka too ngado 'amolu 'ana luma nai, lelea ka dao lau gu 'ana kada kamolu uri lea lae kau 'ana ta maefera lau. ");
INSERT INTO bvd_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Aia, ma lea molu dao 'ana maefere ma daka sualangai kamolu, molu ka lea 'amolu faasia maefera nai. Kada molu lea na kau, molu ka tafusia lolona saegano 'ana maefera nai faasia 'aemolu, sui molu ka lea na 'amolu. Si ade laa nai nia na fafaataia fuana toaa nai, ne kera nao dasi too lau 'ana ta fofo laa uri ka suusi kera faasia na kwakwaea God fuada maana ne kera noni'ela 'ana rongo lana bae lana.” ");
INSERT INTO bvd_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Akwala ma roo waa nai ki da tatae daka lea naa, ma da liu daka faatalongainia naa si faarongoa diana sulia God 'ana maefera nai ki sui gu 'ana, ma daka guraa naa toaa matai ki. ");
INSERT INTO bvd_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Aia, sa 'Antibas Herod waa ne 'inito fua bali lolofaa 'i Galilii, 'e rongoa faarongoa ki sulia doo 'oro ne sa Disas ilida ki lao lolofaa nai lelea ma nia ka manata 'oroa 'asia naa sulia. Nia 'e rongoa da unu sulia saea sa Dion waa ni faasiuabu bae 'e mae naa ne mauri lau ma ka ilidoo ki nai. ");
INSERT INTO bvd_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Tai toaa daka saea sa 'Ilaeja brofet bae 'ana kada 'i nao 'ua ne mauri lau ka ilia doo nai ki. Tai toaa lau daka saea sa nia ta waa lau gwana 'ana brofet baki 'ua 'i nao ne mauri lau ma ka ilia doo nai ki. ");
INSERT INTO bvd_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Sa Herod ka bae 'urii, “Sa Dion nai tee bae ku saea daka siki muusia luana daka ngalia na kau gwauna! Ma sui sa tii lau 'ana ne ilia doo nai ki ma toaa nee daka unu sulia nee?” 'Uri nai guu, sa Herod ka sasi naa uri ka suana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aia, kada na akwala ma roo 'aboosol nia baki da oli mai daka dao naa, kera daka ununu siana sa Disas sulia raoa ne kera lea daka ilia ki mai. Ma sa Disas ka talai kera fasi 'oroa ne da koni seeri, daka lea na kau taifili kera uri lao maefera nai 'i Betsaeda. ");
INSERT INTO bvd_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Sui boroi 'ana, 'oroa nai da rongo alinga ai ne sa Disas 'e nii seeri, kera daka lea kau 'i burina daka dao lau gu kau. Sa Disas ka ele gu 'ana sulia dao lada kau, ma ka bae na fuada sulia 'initoaa nia God, ma nia ka guraa lau guu toaa matai ki. ");
INSERT INTO bvd_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lelea kau 'e dao 'i saulafi kada sato karangi suu naa, na akwala ma roo 'aboosol baki da lea mai siana dao daka bae 'urii, “'Oe odua konia nee da oli na 'ada uri daka nani fanga 'ada ma daka dao toi ta si kula ni maleu lae. Kolu too gu 'akolu 'ana kula gwau, kula nao ta waa si too gu ai ne!” ");
INSERT INTO bvd_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Sa Disas ka bae 'urii fuada, “Kaa nao, kamolu gu ne molu lea kau molu ka sangoni kera.” Ni kera da olisi nia daka bae 'urii, “Kameli, na lima fa beret fai roo kaa sakwari gu ne meli too ai. Lelea meli lea kau meli ka foli fanga lau fuada taari! Lelea nao, doo 'uri nai gu 'ana 'afitai ka bobola fainia konia baita nee.” ");
INSERT INTO bvd_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Konia nee 'oro ka dao 'ana lima tooni wane. Sa Disas ka bae 'urii fua waa kwairooi nia ki, “Lea kau molu ka saea fuada kera daka gooru 'i saegano ma daka koni too lima akwala ki.” ");
INSERT INTO bvd_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Waa kwairooi nia ki kera lea daka ilia na si doo nai nia sae nai, ma toaa nai ki tiifau daka gooru na 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Sui sa Disas 'e dau 'ana lima fa beret nai ki fai roo kaa sakwari nai ki lao lofo 'abana, ka lio 'alaa uri salo ka bae tangoa God. Nia ka niia naa fa beret baki ma kaa sakwari baki, sui ka falea naa 'i 'abana waa kwairooi nia ki, daka tolingia naa fua konia nai. ");
INSERT INTO bvd_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ma na konia nai daka fanga lelea daka abusu tiifau, ma bali 'ana fanga ka tio. Waa kwairooi sa Disas ki, daka konia fanga ne ore ki daka taungia 'ana tii taafuli kukudu ma roo kukudu sarenga ki. ");
INSERT INTO bvd_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tii si kada sa Disas foa 'ana taifilia ma waa kwairooi nia ki lea mai daka dao siana, nia ka ledi 'urii 'ani kera, “Nee wala, kamolu rongoa toaa neki da saea nau sa tii nee?” ");
INSERT INTO bvd_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kera luu nia daka bae 'urii, “Tai waa da saea ni 'oe sa Dion Waa ni Faasiuabu laa bae ne 'o oli lau mai nee. Ma tai toaa daka saea lau 'ada ni 'oe sa 'Ilaeja 'ana ne 'o oli lau mai nee. Ma tai toaa ki lau daka saea ni 'oe ta waa lau gu 'ana brofet baki mai nao ne 'oe mauri lau gwamu nee.” ");
INSERT INTO bvd_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Sui sa Disas ka ledi lau 'urii 'ani kera, “Ma sui kamolu mone, molu saea nau sa tii nee?” Sa Bita 'e luua ka bae gu 'urii, “'Oe na Kraes bae gu ne wala, na waa fifilia bae God 'ua guu!” ");
INSERT INTO bvd_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sa Disas nia ka bae fifii 'ana waa kwairooi nia ki ka luia nao kera dasi faarongo 'ua ai sia ta waa. ");
INSERT INTO bvd_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nia ka bae 'urii fuada, “Nau, na 'Alakwa nia Wane, kwailiu lao fii laa baita 'oro. Na waa baita gwaungai neki ma waa baita ni foa neki, ma waa toolangaidoo neki 'ana taki ki, kera dai susubutai nau ma dai saumaeli nau. Nau kwai mae, sui lao oluna fa dani burina ku mae, God kai tafo nau lau gu 'ana faasia maea.” ");
INSERT INTO bvd_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Sa Disas ka bae lau 'urii fuada sui guu, “Lea ta waa nia dooria kai lea mai 'i buriku, nia ka manata buro naa 'ani nia 'i tala'ana, ka noni maabe naa fua liu lae lao fii lae ki 'afa sato ki sui guu, talafana 'airarafolo nia ne ngalia uria mae lae 'i fafona. ");
INSERT INTO bvd_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Waa ne dau ngasi faafia mauria nia, mauria nia kai nao'ana. Ma waa ne luka tiifau mai 'ana mauria nia fuaku, mauria nia kai tio tari. ");
INSERT INTO bvd_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ta waa ka totoo boroi 'ana diana lana molaagali nee tiifau, lea nia 'i tala'ana 'e funu, dodoloa nia ka firi lau 'ana ta tii si doo ai. ");
INSERT INTO bvd_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ma waa ne noni susuala 'ani nau ma ka noni susuala 'ana si baea nau ki, nau na 'Alakwa nia Wane, kwai noni susuala lau gu 'ani nia kada ku dao mai fainia rara laa Maa nau fai nau, ma fainia talae 'ensel abu nia. ");
INSERT INTO bvd_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Aia nau ku faarongo mamana guu 'ani kamolu, bali 'amolu toaa ne molu uu 'i seki nee, tara molu kai mauri 'ua gu 'amolu molu ka suana naa God kai 'inito 'ana toaa nia ki.” ");
INSERT INTO bvd_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Bobola fainia kwaluna fa dani guu burina sa Disas bae sulia doo baki, nia ka talaia naa sa Bita, sa Dion, ma sa Demes, kera daka raa uri foa lae gwauna uo nai 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Aia, kada sa Disas nia foa 'ana 'i seeri, na maana ka tatala, ma na maku nia ki ka kwakwaosiererea ma ka waasinasina 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ma tona boroi kera suana roo waa baki, sa Mosis fai sa 'Ilaeja dao daru ka bae kwaimani naa fainia sa Disas. ");
INSERT INTO bvd_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Keeru daru sakatafa mai fainia rara laa nai daru ka bae na sulia lea lana faasia molaagali ne kai ali'afu Durusalem. ");
INSERT INTO bvd_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Aia, sa Bita fai roo waa baki da uu kwaimani fai nia, maada mamaleua ka legwesi kera daka maleu naa. Kada kera ada naa, kera daka suana sa Disas nia waasinasina 'asia naa, ma nia ka suana gu 'ana roo waa baki daru uu kwaimani fainia. ");
INSERT INTO bvd_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kada nai roo waa nai ki daru safali lea naa fasi sa Disas, sa Bita ka bae 'urii fua sa Disas, “Wala arai 'ae, nia diana 'asia naa ne kolu nii na 'i see. Kameli kai tolea olu babale ki seki ne, babala fuamu, babala fua sa Mosis, ma oluna doo fua sa 'Ilaeja.” (Sa Bita, nia tona ka bae ata gu 'ana nai.) ");
INSERT INTO bvd_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kada sa Bita bae gwana 'uri nai, na dasa dao ka koko na faafi kera. Na olu waa kwairooi nai ki daka mau lau gwada kada dasa nai koko faafida. ");
INSERT INTO bvd_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma kera ka rongoa tii si lingeewane ka talo mai 'i lao dasa nai ka bae 'urii, “Sa Wala nena 'Alakwa nau na, na Waa fifilia nau 'ua guu. Kamolu too molu ka rongo sulia bae lana!” ");
INSERT INTO bvd_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","'I burina si lingeewane nai bae mai 'uri nai, kera lio kau daka suana sa Disas 'e uu na taifilia. Sui kera daka taarongainia si doo nai ki da suai nai, ka nao dasi faarongoa lau ta waa ai 'ana kada nai. ");
INSERT INTO bvd_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","'Afa dani 'i burina guu si doo nai fuli, sa Disas fainia olu waa kwairooi nia ki daka koso na mai fasi gwauna uo nai kula nai sa Disas tatala ai. Ma toaa 'oro nai lea mai daka dao siana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ma tii waa faasia lao konia nai ka 'ai ka bae mai 'urii, “Waa ni faa toolamai 'ae, nau ku dooria 'oko taria anoedoo ta'aa nee fasi 'alakwa nau nee, sulia nia tii fa 'alakwa 'autania nau nai naa ne. ");
INSERT INTO bvd_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Na anoedoo ta'aa nee lea kada nia olofia wela nee, nia ka 'asi nia 'i saegano ka 'oto'otorai talingai ka ararai baita ma fakana ka ngingisula tiifau. Ma doo nai ka tauwela nia 'asia naa, ma kada 'e ade 'uri nai 'ani nia, 'e 'afitai ka sui 'ali'ali faasi nia. ");
INSERT INTO bvd_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nau ku leditona mai waa kwairooi 'oe ki uria daka taria anoedoo ta'aa nee faasi nia ma sui ka nao dasi ilia guu.” ");
INSERT INTO bvd_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Sa Disas ka bae 'urii, “Kamolu toaa nee, kamolu abu faamamane ma kamolu toaa ta'ae. Nau kwai too fai kamolu ka nao si tau kamolu na 'ana ne. Sae bobola fainia dao 'uri nai, molu ka faamamane nau naa nai, ma sui ka nao. Talaia mai 'alakwa 'oe seki!” ");
INSERT INTO bvd_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kada wela nai kai lea 'ua gu 'ana mai sia sa Disas, na anoedoo ta'aa nai dao ka olofia lau guu. Ma nia ka 'asia naa 'i saegano, ka lebelebe naa. Sa Disas ka ngatafia anoedoo ta'aa nai, ma nia ka sigi faasia wela nai. Nia ka too diana naa, sa Disas ka odua ka oli na kau sia maa nia. ");
INSERT INTO bvd_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ma konia nai daka kwele 'asia naa 'ana tetedea baita nia God. Kada konia nai da kwele 'ua gu 'ada 'ana doo nai ki sui guu sa Disas ilida, nia abulo ka bae lau 'urii fuana waa kwairooi nia ki, ");
INSERT INTO bvd_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nao kamolu si manata buro 'ana doo neki ku saea ki fuamolu nee. Nau 'Alakwa nia Wane, totoo dai fale nau 'i 'abana malimae nau ki.” ");
INSERT INTO bvd_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ma sui boroi 'ana sa Disas ka bae 'uri nai, waa kwairooi nia ki da ulafusia 'ua gu 'ada si doo ne nia bae kekerofana nai. God 'e saufinia faasi kera, ma kera daka mau lau gu 'ada 'ana ledi lana sa Disas uria si manataa nai. ");
INSERT INTO bvd_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Waa kwairooi sa Disas ki totoo lea daka olisusuu 'i matangada faafia tii ada ne kai baita fuada sui. ");
INSERT INTO bvd_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Sui ma sa Disas 'e saitomana gu 'ana doo ne nii lao manata lada, nia ka 'ailia mai tii kaa wela tu'uu nai ka lea mai, nia ka faa uua 'i matangada, ");
INSERT INTO bvd_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","sui ka bae 'urii fuada, “Lelea 'oe gwalea mai kaa wela tu'uu 'urii sulia ne 'oe faamamane nau, 'oe gwale nau lau guu. Ma lelea 'oe gwale nau, 'oe gwalea lau guu God waa ne fale nau mai. Lelea 'oe faatu'uu 'oe 'i tala'amu 'i matangamolu tiifau, tama 'oe ne 'o baita fuamolu tiifau.” ");
INSERT INTO bvd_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Sa Dion ka bae 'urii, “Wala arai 'ae, kameli suana tii waa nia taria lau guu anoedoo ta'aa ki 'ana mamanaa 'oe, ma meli ka luia nao si ilia, sulia nia nao lau waa 'ani kameli toa ne meli lea 'i burimu nee.” ");
INSERT INTO bvd_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Sa Disas ka bae 'urii fuada, “Nao molu si luia, sulia waa nao si susubutai kamolu, nia waa fai kamolu.” ");
INSERT INTO bvd_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nia dao naa 'ana kada sa Disas karangi kai oli naa uri salo. 'I seeri, nia ka manata fifii naa uri lea lae uri maefera baita 'i Durusalem. ");
INSERT INTO bvd_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ma nia ka odua tai waa daka lea uri dao lae 'ana maefere ki 'i nao uri ade akau lae 'ana doo ki sui nia kafi dao kau. Kera lea kau daka dao naa 'ana tii maefera nai toaa Samaria ki. ");
INSERT INTO bvd_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Sui ma toaa nai daka luia nao nia si dao siada, sulia nia waa Diu ma ka lea 'ana uria 'i Durusalem. ");
INSERT INTO bvd_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ma kada roo waa kwairooi nai sa Disas ki, sa Demes fai sa Dion, daru suana toaa nai da luia fera kera ki 'uri nai, keeru ka bae 'urii fuana sa Disas, “Wala Aofia, kaari dooria miri kai gania God uri ka faa fakana mai ta era uri ka sarufia toaa nee daka funu 'ada, ma nao 'utaa?” ");
INSERT INTO bvd_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ma sui sa Disas abulo ka ngatafi keerua faafia. ");
INSERT INTO bvd_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Sui kera daka lea nada uri ta maefera lau. ");
INSERT INTO bvd_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kada kera lea naa sulia taale, tii waa ka bae 'urii fuana sa Disas, “Nau kwai lea naku fai 'oe uria 'i fai boroi 'ana 'oe kai lea uria.” ");
INSERT INTO bvd_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Sa Disas ka bae 'urii fuana, “Nia nao si walude ne wala! Na giri kwasi ki da too 'ana kilu ni tio kera ki, ma saaro ki kera too lau guu 'ana 'oikakada ni tio kera ki. Sui ma nau 'Alakwa nia Wane, ne nao gu 'aku ta kula ni too.” ");
INSERT INTO bvd_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Sui sa Disas ka bae lau 'urii fuana ta ruana waa, “'Oe lea mai buriku.” Ma waa nai ka bae 'ana 'urii, “Wala Aofia 'ae, too 'amu nau lea kwai saufinia fasi maa nau kada 'e mae, sui fatai oli mai kufi lea naku 'i burimu.” ");
INSERT INTO bvd_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Sa Disas 'e luua ka bae 'urii, “Lukasia toaa da mae ki da tala saufini kera na kau 'i tala 'ada wala. 'Oe, 'oko lea naa uria faatalongai lana 'initoaa God.” ");
INSERT INTO bvd_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Aia, ta waa lau ka bae 'urii fuana sa Disas, “Wala Aofia 'ae, nau kui lea naku burimu ne. Sui ta, 'oe maasi nau oli ku alualu fasi 'aku 'ana toaa nau 'i fera.” ");
INSERT INTO bvd_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Sa Disas ka bae 'urii fuana, “Waa ne dooria kai lea 'i buriku ma sui ka manata oliburi lau gu 'ana uri doo nia ki, nia nao si faorana God kai 'inito fuana.” ");
INSERT INTO bvd_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Aia, 'i burina gu 'ana doo nai ki sui, Aofia ka filia lau ta fiu akwala ma roo waa sarenga ki, ka odu kera daka lea kau 'ana too roo waa 'i nao 'ani nia 'ana maefere ki sui guu, ne nia dooria kai dao ki ai. ");
INSERT INTO bvd_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ma nia ka bae 'urii fuada, “Toaa bobola fainia daka faamamanea God ki da 'oro mamana guu daka kwaimaasi gu 'ada mala 'ana ta raku suka sui naa uria fori lana, sui ma toaa fuana talai lada mai siana God ka nao si 'oro guu. Nia 'uri nai, kamolu gania God waa 'inito 'ana raoa nee, uria nia ka odua mai toaa ni rao ki uria daka konia mai doo ne kwaimaasi naa lao raku nia. ");
INSERT INTO bvd_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Aia, molu lea naa nai. Nau ku fale kamolu, molu ka lea naa matangana toaa 'oro ne birangada ta'aa 'ana saketodooe. Ma kamolu ka mala naa kale sifsif da liu matangana giri kwasi 'ani doo ki, sulia kera kai dooria saketo lamolu. ");
INSERT INTO bvd_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nao kamolu si ngalia tasi malefo, ma nao wai, ma nao butu ki. Kamolu lea 'initoa kau nao molu si dora 'ana bae lae fai waa molu dao toda ki sulia taale. ");
INSERT INTO bvd_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ta luma tee ne kamolu dao molu ka too ai, molu ka bae 'urii fua toaa 'i luma nai, ‘Aroaroa God ka too 'ana fai kamolu toaa 'i luma nee.’ ");
INSERT INTO bvd_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Lea ta waa fua aroaroa nai 'e nii seeri, aroaroa nai kai too 'ani nia. Ma lea ka nao guu, aroaroa nai kai oli lau gu 'ana siamolu. ");
INSERT INTO bvd_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kamolu ka too ngado 'amolu 'i lao luma nai molu too ai, nao kamolu si liu kwailiu. Lea da faa si fanga ma nao si kafo fuamolu 'i seeri, molu ka 'ania fanga nai, ma molu ka kuufia kafo nai, sulia na waa ni rao lae, nia 'o'olo gu 'ana uri kwaiarangai lana. ");
INSERT INTO bvd_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ma kada kamolu dao 'ana maefere ma daka gwale kamolu kau uri fera, ta fanga tee ne da faa fuamolu, molu 'ania gu 'amolu. ");
INSERT INTO bvd_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Molu ka guraa toaa matai ki lao maefera nai, ma molu ka bae 'urii fuada, ‘'Initoaa God 'e nii karangi kamolu naa.’ ");
INSERT INTO bvd_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ma lea kamolu dao 'ana maefere ma nao dasi gwale kamolu gu uri fera, molu ka 'iia taale ki ne liu lao fera nai, molu ka bae 'urii, ");
INSERT INTO bvd_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Si saegano 'ana maefera kamolu nee boroi ne dora 'ana 'ae meli, meli tagarangainia na kau fuamolu uri ka faatainia God kai kwae kamolu sulia molu ote kamolu rongoa si baea nia. Sui boroi, molu ka manata toi, 'initoaa God 'e nii karangi kamolu naa.’ ");
INSERT INTO bvd_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nau ku faarongo kamolu, totoo 'e dao 'afa dani God kai kwaea toaa lao molaagali, nia kai kwaea toaa 'ana maefera nai ka talua fatai kwakwaea nia fua toaa 'ana maefera abulo ta'aa bae 'i Sodom!” ");
INSERT INTO bvd_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Sa Disas ka bae 'urii, “Kai ta'aa ka tasa fuamolu toaa 'ana maefera neki 'i Koresin fai 'i Betsaeda, sulia nao molu si faamamanea doo kwaibalatana 'oro baki ku ilia mai siamolu. Doo baki lea sae nau ku ilida mai siana toaa ne kera nao lau Diu ki 'ana maefera abulo ta'aa loki 'i Taea fai Saedon, 'uri nai toaa 'ana fera nai ki daka kwaimanatai tasa daka ruufia mumui maku bilia ki, ma daka kakano 'ana fue 'ana faatai lana kera kwaimanatai ma daka lukasia abulo ta'aa laa kera ki nai. ");
INSERT INTO bvd_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ma sui ka nao molu si ili 'urii, lea nia dao 'afa dani God kai kwaea molaagali, nia kai kwae kamolu kai ta'aa 'isi fatai talua kwakwaea nia fua toaa 'ana bali fera nai ki 'i Taea fai Saedon. ");
INSERT INTO bvd_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aia, kamolu toaa nee 'i Kabaneam molu manata ngado 'amolu sae God kai tafo kamolu kai alu kamolu 'i langi. Sui ma nia kai 'uitoli na 'ani kamolu lao kilu liu fubae 'ana nonifiie.” ");
INSERT INTO bvd_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sui sa Disas ka bae 'urii fuana waa kwairooi nia ki, “Waa ne rongo sulia bae lamolu, nia rongo sulia bae laku. Ma waa ne nao si ala faafi kamolu, nia nao ala faafi nau. Ma waa ne nao si ala faafi nau, nia nao si ala faafia God waa ne odu nau ku lea mai.” ");
INSERT INTO bvd_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nia bae 'uri nai sui, fiu akwala ma roo waa sarenga baki daka lea naa. Lelea kada kera oli mai da dao naa, kera daka ele 'asia naa, daka bae 'urii, “Wala Aofia 'ae, kameli suana anoedoo ta'aa ki boroi da roo sulia bae lameli kada meli tari kera 'ana suukwaia 'oe!” ");
INSERT INTO bvd_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Sa Disas luu kera ka 'urii, “Nau ku suana kau tetedea Saetan 'e 'asia mai faasi nia 'i lofona salo loo ka mala 'ana kwakwange binamaaru. ");
INSERT INTO bvd_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Molu rongo fasi ku faarongo kamolu. Nau ku faa na kau suukwaia nau fuamolu nai, uri molu ka uri boroi faafia doo 'a'ale ki mala baekwe ki fai fafari ki, kera ka nao si bobola guu fainia daka saungi kamolu. Ma lea kamolu kai uri boroi faafia tetedea Saetan tiifau naa ne malimae 'ani kamolu, nia ka nao si bobola guu fainia ka saungi kamolu. ");
INSERT INTO bvd_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tasi doo lau 'e 'urii, kamolu nao molu si ele lau sulia gu 'ana anoedoo ta'aa ki da ade sulia bae lamolu. Kaa molu ele lau 'amolu sulia ne satamolu ki God 'e kedaa ka nii naa lao fera 'i salo.” ");
INSERT INTO bvd_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","'Ana kada nai gu 'ana, Anoedoo Abu 'e faaelea sa Disas, sa Disas ka bae 'urii, “Maa 'ae, 'oe 'o 'inito fua salo loo ma molaagali nee. Nau ku tango 'oe sulia 'oe saufinia doo neki faasia toaa filo ma toaa saitoma doo ki, sui ma 'oko faatainida 'amu sia toaa mala wela tu'uu ki. Iuka Maa 'ae, si doo nai 'e fuli ka lea 'ua guu sulia manata lamu 'uabaa na mai.” ");
INSERT INTO bvd_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Sui sa Disas ka bae 'urii, “Maa nau 'e faa doo ki sui naa 'i 'abaku. Taifilia Maa nau gu ne filo nau 'Alakwa nia, ta wane lau ka nao. Ma nau 'Alakwa nia ni nau taifili nau gu ne ku filoa Maa nau ni nia. Ma tii gu 'ana ne nau kwai faatainia maa nau siana, nia 'ana ne kai filoa maa nau.” ");
INSERT INTO bvd_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Sui sa Disas abulo ka lio fuana waa kwairooi nia ki taifilida ka bae 'urii fuada, “'E diana tasa fuamolu suli molu suana doo fualangaa neki tari'ina. ");
INSERT INTO bvd_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ku faarongo kamolu, na brofet 'oro ma waa 'inito 'oro 'ana kada 'i nao ki, kera dooria 'asia na mai sua lana doo ne kamolu suai 'i tari'ina, sui ma ka 'afitai fuada. Ma kera daka dooria 'asia na mai rongo lana doo ne kamolu rongoa 'i tari'ina, sui ma ka 'afitai fuada.” ");
INSERT INTO bvd_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Totoo tii waa ni toolangaidoo 'ana taki ki ka lea mai ka dao naa siana sa Disas uri ka ilitona 'ana, ka ledi 'urii 'ana sa Disas, “Waa ni toolangaidoo 'ae, tee gu ne nau kwai ilia wala, uri ku too 'aku 'ana mauria firi?” ");
INSERT INTO bvd_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Sa Disas 'e luu nia ka bae 'urii, “Tee bae kekeda laa Abu ki saea? Tee ne 'oe saitomana 'ana doo ne kera bae sulia?” ");
INSERT INTO bvd_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Na waa nai luu nia ka bae 'urii, “'O liosau 'ana God 'oe 'i lao liomu tiifau, ma 'i lao mangomu tiifau, ma fai tetedea 'oe tiifau, ma 'i lao manatamu tiifau. Ma 'oko liosau 'ana ta wane kau ka mala lau guu ne 'oe liosau 'ani 'oe 'i tala'amu.” ");
INSERT INTO bvd_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ma sa Disas ka bae lau 'urii, “'Oe luua si ledi laa nai ka too naa nai. 'Oko ili gu 'uri nai, uri 'oko mauri.” ");
INSERT INTO bvd_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Sui ma waa ni toolangaidoo nai, ka naunau 'ana fai 'o'oloa nia 'i tala'ana, ka ledi 'urii lau 'ana sa Disas, “Nee wala, ma lea 'uri nai sa tii gu ne ta wane kau, uri nau ku liosau 'aku 'ani nia?” ");
INSERT INTO bvd_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Sa Disas 'e filoa ne toaa Diu ki da mamagutainia toaa Samaria. 'I seeri nia luua waa nai ka 'urii, “Totoo ta tii waa 'i Durusalem koso ka lea toli naa uria maefera 'i Diorikoo. Ma waa beli ki daka sakalia sa wala nai sulia taale daka kwae nia ka sali mae ka tio na 'i seeri, ma daka lau tiifau 'ana 'okodoo nia lea si maku 'i salafana boroi si tio naa, sui tafi daka lea nada. ");
INSERT INTO bvd_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Otafana kada si doo nai fuli, tii waa ni foa ka koso toli lau gu kau sulia tii taala nai. Kada nia lea kau ka suana sa wala nai 'e tio 'i seeri sulia taale, nia ka kali ka liu tau 'ana faasia, tasa ka lea lau gu 'ana. ");
INSERT INTO bvd_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tii waa 'ana waa dai rao kwai'adomi fai waa ni foa ki ka 'uri nai lau guu. Kada nia lea kau ka liu lau gu 'i seeri ka suana sa wala nai, nia boroi ka kali ka liu tau lau gu 'ana faasia, ka lea lau gu 'ana. ");
INSERT INTO bvd_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Aia, totoo na waa fasi 'i Samaria ta bali 'e'ete lau na 'ana ne lea lau gu kau sulia taala nai. Ma kada nia lea kau ka suana sa wala nai, nia ka manatainia 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nia ka lea kau siana, ka taufia maala nia ki ka kikia gwai ma waen faafida, sui ka 'afuda. Sui nia ka kwaua sa wala nai uri fafona dongki nia, ka ngalia ka lea na fainia. Lea kau ka faasi nia 'ana tii luma ni foli lae talana uri tio lae ai ma ka suasuli nia 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Da tio dani, nia ka lafua roo miga malefo bobola fainia foli lana roo fa dani ki, ka faa fuana waa ne suasulia luma nai, ka bae 'urii, ‘'Oe suasulia sa wala nee. Ma lea 'oe faafunua tasi malefo 'i satamu uri 'adomi lana, kada nau ku oli mai kui liu, nau kui duu tiifau ai fuamu.’” ");
INSERT INTO bvd_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sa Disas ka bae lau 'urii fuana waa ni toolangaidoo bae, “'Ana olu waa nai ki, waa tee ne 'oe manata toi nia ilia si doo ne faatainia nia toolana sa wala nai da saungia ma daka belia 'okodoo nia ki?” ");
INSERT INTO bvd_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ma waa ni toolangaidoo nai 'ana taki ki ka 'urii, “Waa nai manatainia nai na.” Sa Disas olisi nia ka 'urii, “'Oe lea kau 'oko ili 'uri nai fua waa ki.” ");
INSERT INTO bvd_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kada sa Disas fai waa kwairooi nia ki da lea naa uri Durusalem, kera daka dao fasi 'ana tii maefera nai, ma tii wela keni nai satana ni Maata ka gwale kera kau uria 'i luma nia. ");
INSERT INTO bvd_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ma ni Meri toolana ni Maata, ka gooru karangia sa Disas na Aofia ka fafurongoa na 'ana toolangaidooa nia. ");
INSERT INTO bvd_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Aia, ma ni Maata, manata lana ka 'abarua naa 'ana raodooa 'i luma ki tiifau, ne nia ilia gu 'ana taifili nia. Ma nia ka lea mai siana sa Disas, ka bae 'urii fuana, “Wala Aofia, doo 'oe suai ka nao si 'oga 'oe guu ne nau ku ilia gu 'aku raoa neki sui guu taifili nau, ma toolaku nee ka faasi nau nao si 'adomi nau gu 'urii? 'O saea fuana nia lea mai ka 'adomi nau!” ");
INSERT INTO bvd_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Aia, na Aofia 'e luua ka 'urii, “'Oo Maata 'ae, 'oe 'abaru 'asia naa 'ana manata lae sulia doo 'oro ne. ");
INSERT INTO bvd_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tii si doo gu ne 'initoa ka tasa nee. Si doo diana nai ne ni Meri 'e filia nee, ne 'afitai ta waa ka ngalia lau faasi nia.” ");
INSERT INTO bvd_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","'Ana tii fa dani, sa Disas nia foa 'ana tii si kula. Kada nia 'isia foa laa nia, tii waa 'ana waa kwairooi nia ki dao ka bae na 'urii fuana, “Wala Aofia 'ae, 'oe toolangainia fasi foa lae siameli wala, mala bae sa Dion toolangainia mai foa lae sia waa kwairooi nia ki.” ");
INSERT INTO bvd_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Sa Disas ka bae 'urii fuada, “Kada kamolu foa, molu ka bae 'urii, ‘Maa kameli 'ae, alu toaa ki sui faa'initoaa 'ada satamu ne abu. Lea mai 'oko 'inito 'ana mauria kera toaa ki sui. ");
INSERT INTO bvd_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","'Oko falea mai fuameli si fanga bobola fai kameli 'afa sato ki sui guu. ");
INSERT INTO bvd_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","'Oko manata lukea abulo ta'aa laa kameli ki, sulia meli manata lukea abulo ta'aa laa kera toaa ilidoo ta'aa fuameli. Nao 'osi ekwatai kameli fua ilitooa ka linge kameli.’” ");
INSERT INTO bvd_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Sui sa Disas ka unu sulia tii si ununua 'ana tarifulaa 'urii fuana waa kwairooi nia ki, “Sae 'uri nai ta, ta waa 'amolu lea ka dao siana waa kwaimani nia 'i luma kera lao tofungana rodo. Ma nia ka bae 'urii fuana, ‘Waa nau 'ae, 'oe faa fasi mai ta olu fa beret fuaku, ");
INSERT INTO bvd_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","sulia tii waa kwaimani nau lau guu ne too tau mai 'e dao siaku, ma sui ka nao kusi too 'ana tasi fanga uri faa lae fuana.’ ");
INSERT INTO bvd_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ma sui lea sae waa kwaimani nia nai 'i luma ka bae mai 'urii, ‘Nao 'osi faanonifii nau lau! Kameli fonokia sui na mae, ma wela nau ki boroi da maleu sui naa. Nia 'afitai naa uri nau ku tatae ku faa lau ta doo fuamu.’ ");
INSERT INTO bvd_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ku faarongo kamolu, sui boroi 'ana nunufana bali 'ana kwaimania keerua, nia ka 'afitai naa fua sa wala nai ka faa lau ta doo fuana. Bali nunufana 'ana ne nia radi kalia ka nao si lukasia naa, ne adea lelea ruana nia nai ka tatae lau uri faa lana doo nai ki sui guu nia dooria nai. ");
INSERT INTO bvd_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nia ne nau ku faarongo kamolu, molu gania God uri lelea molu ka ngalia doo ne kamolu gania siana. Molu ka nanisia doo ne molu dooria siana God uri lelea molu ka dao toi. Molu ka kikidi 'ana maa nia God uri lelea nia ka 'ifingia fuamolu. ");
INSERT INTO bvd_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sulia nia 'urii, toaa ki sui guu ne kera gania God, kera ngalia doo da gania. Ma toaa ki sui guu ne kera nanisia doo ne kera dooria siana God, kera dao toi. Ma toaa ki sui guu ne kera kikidi 'ana maa nia God, nia 'ifingia fuada. ");
INSERT INTO bvd_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Aia, tii 'amolu waa ni maa lae ki ne lea 'alakwa 'oe gani 'oe uria sakwari doo diana nai, ma oli 'oko faa 'amu baekwa 'a'ale fuana? ");
INSERT INTO bvd_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ma nao lea nia gani 'oe uria farake karai doo diana nai, ma oli 'oko faa 'amu fafari fuana? 'Oe 'afitai 'oko ili uri nai fuana 'alakwa 'oe, nee? ");
INSERT INTO bvd_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kamolu toaa abulo ta'aa nee boroi ne molu saitomana faa lana doo diana ki fuana wela kamolu ki. Ma tagi 'ana Maa kamolu 'i salo, ai nia 'o'olo kafi talu kamolu fatai 'ana faa lana mai Anoedoo Abu fuana toaa ne kera gani nia uria!” ");
INSERT INTO bvd_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","'Ana tii si kada, sa Disas taria tii anoedoo ta'aa faasia tii waa fakana 'ato. Ma kada anoedoo ta'aa nai 'e lea faasi nia, waa nai ka bae lau gu 'ana. Ma toaa 'oro nai da koni 'i seeri daka kwele. ");
INSERT INTO bvd_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma sui tai waa 'ani kera daka bae 'ada 'urii, “Sa Disas nia taria gu 'ana anoedoo ta'aa ki 'ana tetedea nia Saetan, na anoedoo ta'aa gwaungai kera anoedoo ta'aa ki.” ");
INSERT INTO bvd_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ma ta bali 'ani kera daka doori ilitona 'ada sa Disas uri ka faatainia fasi tasi doo kwaibalatana uri ka faatainia lea nia lea mamana mai fai tetedea God. ");
INSERT INTO bvd_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ma sa Disas 'e filoa gu 'ana manata lada, nia ka bae 'urii fuada, “Maefera baita 'ana 'initoaa ne toli ma toaa 'i laona ki daka firu lau gu 'ada fai kera 'i tala'ada, 'initoaa 'e okosi naa na. Ma bara waiwelana ne toli ma toaa 'i laona ki daka firu lau gu 'ada fai kera 'i tala 'ada, bara waiwelana 'e okosi naa na. ");
INSERT INTO bvd_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ma lea 'initoaa nia Saetan 'e toli ma toaa 'i laona ki daka firu lau gu 'ada fai kera 'i tala 'ada, 'initoaa nia 'e okosi naa nai. Nau ku faarongo kamolu 'ana doo nai ki, sulia kamolu saea nau ku taria anoedoo ta'aa ki 'ana tetedea nia Saetan. ");
INSERT INTO bvd_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Aia, kamolu saea naa nau ku taria anoedoo ta'aa ki 'ana tetedea Saetan. Sui 'uri nai, ma tetedea tii 'ana ne waa kwairooi kamolu ki da taria anoedoo ta'aa ki ai? Tetedea Saetan lau guu, ma nao sa tii? Lea nao lau 'ana tetedea Saetan ne kera ilia ai, tama doo ne kamolu sae nau ai nia garo nai. ");
INSERT INTO bvd_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Na tetedea God lau 'ana ne nau ku taria anoedoo ta'aa ki ai. Lea nia 'uri nai tama doo, nia faatainia 'initoaa God 'e nii karangi kamolu naa nai.” ");
INSERT INTO bvd_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Sui sa Disas ka unu lau sulia ta tii si tarifulaa ka 'urii, “Kada ta waa ramo nia dau 'ana raunga ni omee nia ki ma ka folo diana 'ana suusia beu nia, 'afitai 'asia naa ta waa ka tala'ana ka belia 'okona doo nia ki. ");
INSERT INTO bvd_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ma sui boroi 'ana, lea ta waa ramo ka talu nia lau 'e firu fai nia ma ka siitasa faafi nia, waa ramo ka tasa nai kai laua gu 'ana raunga ni omee ne waa ramo nai 'e fiitoi ki. Ma waa ramo ka tasa nai kai tolingia gu 'ana 'okodoo waa ramo nai ki tiifau fuana ruana nia ki fainia. ");
INSERT INTO bvd_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Waa ne nao si lea gu mai buriku, waa nai nia malimae nau. Ma waa ne nao si kwai'adomi aku 'ana koni lana mai toae ki sia God, nia waa ni tagalangai lada faasia God.” ");
INSERT INTO bvd_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Sa Disas ka bae lau 'urii, “Kada kera taria anoedoo ta'aa ka lea faasia waa, nia kai kali gwana lao fera kwasi, ka nani gwana uria tasi kula kai too ai. Ma lea nia nani lelea ka nao si dao toi guu tasi kula, nia kai manata 'urii, ‘Nau ku oli 'aku uria waa bae ku too mai 'ani nia 'i nao sui kufi lea mai bae.’ ");
INSERT INTO bvd_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nia oli mai dao, ka suana waa bae tagisi nia ka 'olosia mauri lana tiifau sui ka too gu 'ana. ");
INSERT INTO bvd_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kada nia suana 'uri nai, nia oli kau ka talaia lau mai ta fiu anoedoo ne ta'aa ka talu nia fatai, kera ka lea mai dao daka too 'ana waa bae. Ma kada nai guu, na too lana waa nai 'e ta'aa ka talua fatai 'i nao mai.” ");
INSERT INTO bvd_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kada sa Disas nia bae sulia doo nai ki fuada sui, tii wela keni lao konia nai ka 'ai baita ka 'urii, “'E diana tasa fuana ai ne kwalafi 'oe ma ka faasusufi 'oe mai.” ");
INSERT INTO bvd_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sui ma sa Disas luua ka bae 'urii, “Kaa nao. 'E diana tasa fuana toaa ne da rongoa si baea God ma daka ade sulia.” ");
INSERT INTO bvd_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ma kada ne toaa 'oro nai da koni kalia sa Disas, nia ka bae 'urii fuada, “Kamolu toaa abu faamamane nee 'i tari'ina, birangamolu ta'aa. Kamolu dooria molu ka suana ta fafaataia 'ana faatai lana tetedea God, sui boroi ma God 'afitai ka faatainia lau ta fafaataia 'e'ete fuamolu. Tii fafaataia ne kamolu kai suai naa ne fafaataia bae sulia sa Dionaa brofet bae kada 'i nao. ");
INSERT INTO bvd_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sa Dionaa, nia na fafaataia God fuana toa 'i Ninifaa ne God fale nia mai fua daka suana. Nau 'Alakwa nia Wane, nau na fafaataia nia God fuamolu toaa nee 'i tari'ina, ne God fale nau mai uri molu ka suaku. ");
INSERT INTO bvd_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Na ai 'inito kera bae fera 'i Siba kai tatae kwaimani fai kamolu toaa abu faamamane nee 'i tari'ina, 'afa dani God kai kwaea fera nee 'i saegano, ma nia kai faatainia ne ade lamolu 'e garo. Sulia, nia too tau 'asia na mai 'ana ta bali molaagali, sui boroi ka lea gu 'ana mai uri fafurongo lana liotooa sa Solomon. Ma sui ni nau, na waa ne ku 'initoa ka talua fatai sa Solomon ne ku too gu 'aku fai kamolu 'i tari'ina, ma sui boroi nao molu si rongo gu suli nau. ");
INSERT INTO bvd_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Na toaa 'i Ninifaa boroi ka 'uri nai lau guu, kera dai tatae kwaimani fai kamolu toaa nee, 'ana fa dani God kai kwaea fera nee 'i saegano, ma dai faatainia ne ade lamolu 'e garo. Sulia kera da lukasi tiifau 'ana abulo ta'aa laa kera ki, kada kera rongoa sa Dionaa 'e bae laalaa fuada. Ma sui ni nau, na waa ne ku 'initoa ka talua fatai sa Dionaa ne ku too gu 'aku fai kamolu 'i tari'ina, ma sui boroi nao molu si bulasi manataa guu.” ");
INSERT INTO bvd_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Sa Disas ka bae lau 'urii, “Nao ta waa si faasarua kwesu sui ma ka saufinia gu 'ana, ma nao ka agwaa gu 'ana farana ta kwade doo. Doo ne nia ilia 'ana ne, nia ngalia ka alua 'ana kula ni alu lana kwesu ki ai, uria kada waa ki da ruu mai luma daka suana folaa lae. ");
INSERT INTO bvd_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lea nao 'osi suana folaa lae nee tama, maamu ne ta'aa ma 'oko too gwamu lao rorodoa lae. Sulia lea maamu 'e diana, 'oe 'o nii na lao folaa laa nee, sulia na maamu naa ne kai ngalia mai folaa laa nai fua lao nonimu. ");
INSERT INTO bvd_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Molu ka fii kamolu, ade lea molu ka lukasia folaa laa nau ne fuamolu ma mauria kamolu ki ka rorodoa lau gu 'ana. ");
INSERT INTO bvd_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Lea nonimolu fungu 'ana folaa lae ma tasi kula boroi si rorodoa naa, doo tara nia folaa diana gu na. Ma nia ka mala gu kwesu ne falea rara laa diana fuamolu.” ");
INSERT INTO bvd_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kada sa Disas 'e falebaea lelea ka sui, tii waa 'ana Faarisii ki lea mai ka odu nia uri fanga lae 'i luma kera. Sa Disas ka lea kau fainia dao daka fanga kwaimani naa. ");
INSERT INTO bvd_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tii doo Faarisii nai 'e kwele 'asia na ai ne, sa Disas nao si taufia gu 'abana sui fatai kera dafi fanga. ");
INSERT INTO bvd_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ma sa Disas na Aofia ka bae 'urii fuana, “Kamolu Faarisii ki, molu 'abarua 'asia naa 'ana taufi lana gu 'amolu 'okisulina kwade belete ni fanga ki ma banikeni ni kuu lae ki. Ma 'i lao mauria kamolu ki ne daka fungu gu 'ada 'ana ogalulumi lae ma garoe ki sui gu 'ana. ");
INSERT INTO bvd_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kamolu oewanea 'asia naa ne! God nia saungainia doo ki, ka alua bali 'okisulina doo ki ka too, ma bali 'i laona doo ki ka too lau guu. ");
INSERT INTO bvd_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Aia, molu falea naa 'okodoo 'i lao belete ma banikeni ki fua toaa siofaa, uri 'okona doo kamolu ki tiifau ka falu 'i maana God. ");
INSERT INTO bvd_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kai ta'aa ka tasa fuamolu Faarisii ki, sulia kamolu 'ini 'asia naa sulia fale lana tangafulu 'ana kaala migana doo tu'uu ki boroi 'ana fuana God 'ana fanga kamolu, ma sui ka nao si 'oga kamolu guu uri ade 'o'olo lae fua waa ki, ma uri liosau lae 'ana God. Nia bobola fainia molu ka ilia doo nai ki ma molu ka falea lau guu tangafulu kamolu ki fua God. ");
INSERT INTO bvd_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kai ta'aa ka tasa fuamolu Faarisii ki, sulia kamolu dooria 'asia naa gooru lae 'ana kula ni goorua kera waa baita ki, lao beu ni ofu laa kamolu ki uri toae ka faa'inito kamolu. Ma molu ka dooria 'asia naa toae ka faa'inito kamolu kada molu dao maana usie ki. ");
INSERT INTO bvd_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kai ta'aa ka tasa fuamolu Faarisii ki. Kamolu, molu 'uria kwainaia ki bae da tio agwa ma toae ki daka fali gu 'ada ai ka nao dasi saitomana guu wawaa ki nii 'i laona.” ");
INSERT INTO bvd_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tii waa ni toolangaidoo 'ana taki ki ka bae 'urii, “Wala waa ni toolangaidoo 'ae, si doo ne 'oe saea nai, 'oe tauwela kameli 'oko faa noni susuala kameli naa nai.” ");
INSERT INTO bvd_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ma sa Disas ka bae 'urii, “Kai ta'aa 'asia naa fuamolu toa ni toolangaidoo lae 'ana taki ki, sulia kamolu saungainia taki 'afitai 'oro ki 'asia naa fuana toae ki, ma ka 'afitai 'asia naa fuada uri ade lae sulia ki, ma kamolu ka nao molu si taa 'adomi kera guu. ");
INSERT INTO bvd_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kai ta'aa ka tasa fuamolu, sulia kamolu saungainia kwainaia kera brofet ki sua lada ka kwanga 'asia naa, doo bae kokoo kamolu ki gu 'ana da saungida. ");
INSERT INTO bvd_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ade lamolu nai 'e faatainia kamolu 'ado lau gu fai kokoo kamolu ki 'ana garoa ne kera ilida, sulia kokoo kamolu ki daka saungia brofet ki, kamolu ka saungainia kwainaia kera ki. ");
INSERT INTO bvd_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ma uri maana si doo nai, si baea manataa God nia saea 'e 'urii, ‘Nau kwai falea kau brofet ki ma 'aboosol ki siada, ne kera kai faanonifiia bali ada ma daka saumaeli kera.’ ");
INSERT INTO bvd_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Uri maana si doo nai, God kai duua mae lana brofet nia ki sui guu ne kera mae 'ita 'ua mai 'ana safali lana molaagali. Nia kai duua fuamolu toaa nee 'i tari'ina. ");
INSERT INTO bvd_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nia kai duu mae lana toaa nia nai, 'ita 'ana mae lana sa 'Ebol lelea mai ka dao 'ana mae lana sa Sakaraea bae kera saungia matangana fuliere ni kooe fai kula abu bae 'i lao kadabeu lalo. Iuka doo mamane ne ku saea fuamolu nee, God kai duu mae fuana toaa nee 'i tari'ina. ");
INSERT INTO bvd_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kai ta'aa ka tasa fuamolu toa toolangaidoo lae 'ana taki ki, sulia kamolu molu fai faafia si baea mamana nia God faasia toae. Kamolu 'i tala'amolu nao molu si filia gu mai si baea nai, ma toaa ne da dooria saitoma lana boroi molu ka suusi kera lau gu faasia.” ");
INSERT INTO bvd_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ma kada sa Disas kai faasi kera guu, waa toolangaidoo 'ana taki ki fai Faarisii ki, daka safali ngenge nia naa, daka ledia naa uri doo 'oro. ");
INSERT INTO bvd_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ma daka sasi naa uria suke lana uri sae lelea nia ka saea ta doo garo 'ana uri daka dau nia faafia. ");
INSERT INTO bvd_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","'Ana si kada nai, tii konia talingai 'asia naa bobola fainia ta bara tooni wane ne kera koni mai lelea daka kwaisangirii guu, da ofu mai uri fafurongo lana sa Disas. Nia safali bae fasi 'urii fua waa kwairooi nia ki, “Molu ka fiia manatae waa ta'aa kera nee Faarisii ki, ne kera toa kwaisukei mamana guu. ");
INSERT INTO bvd_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Na doo neki waa ki agwaa, totoo God kai alu faatai ai tasi doo si ore guu. Ma doo neki waa ki saufinia ade toae ka saitomana, God kai alu faatai ai fua toae ki sui daka saitomana tasi doo nao si ore guu. ");
INSERT INTO bvd_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ma doo neki sui guu kamolu sae agwa ai lao rodo, toae ki sui dai rongo folaa ai lao sato. Ma doo neki sui guu kamolu fuuarotainia ki 'i lumalalo, kera dai sae folaa ai fuana toae ki sui guu.” ");
INSERT INTO bvd_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Sa Disas ka bae lau 'urii, “Nau ku faarongo kamolu waa kwaimani nau ki, nao molu si maungia waa ne kai saumaeli kamolu gwana 'ana noniidoo, ma sui ka nao si saumaelia guu mangomolu. ");
INSERT INTO bvd_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Aia, ma nau ku faatainia fuamolu, waa nee mone uri molu ka maungia ne God. Sulia nia ne kai saumaeli kamolu 'ana noni, ma ka too lau guu 'ana tetedea fuana 'ui lae 'ana mangomolu lao kula 'ana nonifii lae. Iuka, ku faarongo kamolu lau, God taifilia guu ne molu ka maungia. ");
INSERT INTO bvd_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Fa didiki neki kera tu'uu 'asia guu, lea lima fa doo boroi daka folia guu 'ana roo kaa miga malefo tu'uu 'isi ki. Sui boroi 'ana, ta tii fa doo ada boroi, God 'afitai ka manata buro ai. ");
INSERT INTO bvd_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na ifuna gwaumolu ki boroi, God saitoma tiifau gwana ai. Doo ne adea ka nao molu si mau lau nai, sulia God nia manata fifii 'ani 'oe wane ka talua didiki 'oro ki.” ");
INSERT INTO bvd_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Sui sa Disas ka bae lau 'urii, “Nau ku faarongo kamolu lau guu, toaa ne da faarongo folaa 'ani nau 'i maana waa 'ana molaagali ne kera waa kwairooi nau ki, ni nau 'Alakwa nia Wane, kwai faarongo folaa lau guu 'ani kera 'i maana 'ensel God ki. ");
INSERT INTO bvd_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Aia, ma waa ne tofe nau 'i maana waa 'ana molaagali, nau kwai tofe nia lau guu 'i maana 'ensel God ki. ");
INSERT INTO bvd_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Toaa ne da bae ta'aa fuaku 'Alakwa nia Wane, God kai manata luke kera gu 'ana. Sui ma, toaa ne da bae ta'aa fua raoa nia Anoedoo Abu ne 'afitai naa God ka manata luke kera. ");
INSERT INTO bvd_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Aia, kada kera ngali kamolu uria didi lamolu lae lao beu ni ofu lae ki ma 'i maana waa baita kera ki, nao molu si manata 'a'abo lau sulia doo ne molu kai saea, ma nao olisi laa 'utaa ne molu kai ilia ada. ");
INSERT INTO bvd_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sulia 'ana si kada 'uri nai, Anoedoo Abu ne kai toolamai kamolu 'ana doo ne molu kai saea ki.” ");
INSERT INTO bvd_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tii waa lao konia nai ka bae 'urii fuana sa Disas, “Wala waa ni toolangaidoo 'ae, 'oe saea fua sao'aku uri ka tolingia suadooa ne maa kaaria faasia fuamiri.” ");
INSERT INTO bvd_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ma sa Disas 'e luua ka 'urii, “Wala nee 'ae, ma doo sa tii faolomainia fuaku uri ili lana nai, uri ku saea ta doo sulia ma nao ku tolingia doo nai ki 'i matangamuru?” ");
INSERT INTO bvd_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nia ka bae 'urii fuada tiifau, “Molu ka fiia doori dooa ma ogalulumi lae 'ana doo ki, sulia na mauria mamana waa, nia nao lau malefo ma suadooa nia ki.” ");
INSERT INTO bvd_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Sa Disas ka unu sulia tii si tarifulaa fuada ka 'urii, “Tii waa suadoo 'e too 'ana tii si gano diana, ma ka fasidoo 'i laona, ma ka falia diana lana aludooa 'oro nia ki 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nia too ka manata 'ana sulia nia 'i tala'ana ka 'urii, ‘Nia sae tee lau ne nau kwai ilia ro? Nau kusi too naa 'ana ta kula ne gwau lau fua taingai lana doo nau ki ai. ");
INSERT INTO bvd_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","'Oo iuka, nau kwai okosia babala nau nee, sui ku saungainia babala taa baita lau. Lea sui, nau kwai konia mai fuana aludooa nau ki ma tai doo diana 'aku ki lau uri alu lana 'i laona. ");
INSERT INTO bvd_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Sui fatai ta nau kufi bae na 'aku 'urii fuaku 'i tala'aku nai: 'Oilakea baita fuamu nai wala! 'Oe too na 'ana doo diana 'oro baki 'o dooria 'asia naa mai sulia fa ngali 'e 'oro nai. 'O too aroaro na 'amua! 'Oko too ni fanga laa ma kuu diana laa 'amua, 'oko ilia na 'amua doo baki 'oe dooria ki fua faaele lamu.’ ");
INSERT INTO bvd_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ma sui, God ka bae 'urii fuana, ‘'Oe waa oewanea ne! Fa rodo nee 'i tari'ina gu ne 'oi mae 'i laona. Ma ni 'oe nao 'osi saitomana tii ne kai ngalia 'okona doo ne 'o taingainia mai fuamu 'i tala'amu.’” ");
INSERT INTO bvd_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Sa Disas ka faasuia toolangaidoo laa nai ka bae 'urii, “Too lana guu waa ne kai konia gu 'ana suadooa 'ana molaagali fuana 'i tala'ana nai, ma ka siofaa gwana 'ana doo God ki.” ");
INSERT INTO bvd_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Sa Disas ka bae lau 'urii fuana waa kwairooi nia ki, “Nau ku faarongo kamolu, nao molu si manata sala sulia tee ne molu kai 'ani, ma tee ne molu kai ofi ai. ");
INSERT INTO bvd_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sulia na mauri lana wane nia 'initoa ka talua fange, ma na nonina wane nia 'initoa ka talua si maku ni ofi. ");
INSERT INTO bvd_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Manata fasi sulia saaro ki, kera nao dasi nonifii guu 'ana rao lae 'ana ole ma koni lana fange, ka nao dasi tole babala guu uri alu fanga lae, ma God gu 'ana ka saare kera. God kai saare kamolu 'afitai ka nao, sulia lao manata lana, kamolu molu 'initoa ka talua saaro ki. ");
INSERT INTO bvd_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Sui boroi 'ana molu ka manata sala sulia mauria kamolu ki, nia 'afitai ka faatikwaa guu mauri lamolu. ");
INSERT INTO bvd_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ma suli ne kamolu nao molu si tala'ana guu ili lana tasi doo uri ka faatikwaa mauri lamolu ki, nao molu si manata sala guu sulia doo nai ki sui gwana. ");
INSERT INTO bvd_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Manata fasi sulia kaala lalano neki dai tae ki nee, kera nao dasi rao guu, ma nao kera dasi saungai maku guu. Ma sui boroi nau ku faarongo kamolu, maku baki Solomon na waa 'inito boroi kwanga lada sui naa, nao si dao gu faafia kwanga lana takana lalano neki. ");
INSERT INTO bvd_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kamolu na fiitooa kamolu 'e tu'uu 'asia gu wala. God kai falea si maku ni ofi lae fuamolu, 'afitai ka nao. Sulia na lalano nai ki lao gano gu 'ana boroi doo da mauri 'i tari'ina, sui bobongi daka kuku lau gu 'ada boroi God faaofi diana 'ani kera nai. ");
INSERT INTO bvd_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Nao molu si manata sala lau sulia tee ne molu kai 'ani, ma tee ne molu kai kuufia. ");
INSERT INTO bvd_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Toaa ne da ulafusia God 'ana daka nani burina doo nai ki. Kamolu, God Maa kamolu 'e saitomana gu 'ana kamolu 'atoia doo nai ki. ");
INSERT INTO bvd_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Si doo ne uri molu kai ilia 'amolu ne manata lae sulia 'initoaa nia God, ma nia kai falea mai doo neki sui guu molu kwai 'atoi ki ai fuamolu.” ");
INSERT INTO bvd_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Sui sa Disas ka bae lau 'urii, “Kamolu toa nau, sui boroi 'ana molu ka mala kale sifsif ki, nao molu si mau. Sulia God Maa kamolu, 'e manata ele 'asia naa uri faa lana 'initoaa nia fuamolu. ");
INSERT INTO bvd_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Molu foli 'ana 'okona doo kamolu ki, molu ka ngalia malefo nai molu ka faa fuana toaa siofaa ki. Molu ili 'uri nai, uri molu ka too 'ana wai ni todadooa ki ne totoo si fura fai suadooa lao fera 'i salo ne totoo si oli kukuru, ma kula ne waa beli ki 'afitai uria dao lae ai, ma 'aide nao si saketoa doo ki ai. ");
INSERT INTO bvd_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sulia na kula ne 'oe alua suadooa 'oe ai, kula nai lau gu ne lao tofungana liomu naa 'e nii ai. ");
INSERT INTO bvd_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Molu kwaimaakwali naa maasia raoe. Kani ngasi 'ana maku kamolu ki, ma molu ka faasarua kwesu kamolu ki ka saru naa, ");
INSERT INTO bvd_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","mala 'ana waa da kwaimaakwalii maasia waa baita kera ne lea 'ana fafangaa 'ana faalue ma ka oli mai kai dao naa. Kada nia dao ka kidikidi mai, kera 'ali'ali daka 'ifingia na mae fuana. ");
INSERT INTO bvd_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ma toa ni rao nai ki waa baita kera nia dao ka toda kera da ada gu 'ada kada nia dao, kai diana tasa 'asia naa fuada. Nau ku faarongo 'o'olo gu 'ani kamolu, waa baita kera nai kai kani ngasi 'ana maku nia uri raoe, sui nia kai saea fuada sui guu daka gooru kwaimani fainia, uri nia ka sangoni kera. ");
INSERT INTO bvd_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Toa nai ki lea sa waa baita kera ka dao boroi 'ana mai lao tofungana rodo, ma nao 'i 'ofaidani, ma kai suada kera ada gu 'ada, kai diana tasa 'asia naa fuada! ");
INSERT INTO bvd_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Si doo molu ka manata toi 'e 'urii, na waa 'ana luma lea nia saitomana gu 'ana si kada waa beli kai dao uri beli lae ma nia ka kwaimaakwali diana, waa beli nai 'afitai ka ruufia luma nia. ");
INSERT INTO bvd_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Talafana lau gu ni kamolu nai, molu kwaimaakwali diana maasi nau, na 'Alakwa nia Wane. Nau kwai dao mai kada kamolu nao si fiia kwai dao ai.” ");
INSERT INTO bvd_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Sa Bita ka bae 'urii, “Wala Aofia 'ae. Na tarifulaa nai 'oe bae sulia nai, doo fuameli gu 'ana nee, ma nao doo fuana toae ki sui gu 'ana?” ");
INSERT INTO bvd_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Na Aofia 'e luua ka 'urii, “Kamolu, molu 'uria waa ni rao ne liotoo ma ade lana ka 'o'olo. Ma waa baita nia ka alu nia ka lio sulia toaa ni rao ki, ma ka alu nia fua sangoni lada 'ana kada kera ni fanga lae ki. ");
INSERT INTO bvd_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kada waa baita nai 'e oli mai ka dao siana 'i luma nia, ma ka suana nia ili diana 'ana doo nai ki, kai diana tasa 'asia naa fuana! ");
INSERT INTO bvd_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ma nau ku faarongo mamana guu 'ani kamolu, lea nia 'uri nai, waa baita nai kai alua nia kai lio sulia 'okona doo nia ki tiifau naa. ");
INSERT INTO bvd_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Aia, ma sui lea waa ni rao nai ka manata 'ana 'urii, ‘Waa baita nau, dao lana mai tau 'ua,’ ma ka safali kwae maana 'ana toaa ni rao ma wela keni ni rao nai ki, ma ka too ni fanga laa 'ana ma kuufi lana 'ana kafo lilinge ki lelea gwauna ka oewanea guu, nia kai ta'aa 'asia naa fuana. ");
INSERT INTO bvd_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Na waa baita nia kai dao 'afa sato nia nao si fiia ai, ma si kada nia nao si saitomana. Ma na waa baita nai, kai falea kwakwaea baita fuana, ka alu nia naa 'ana kula fua toaa abu faamamane ki. ");
INSERT INTO bvd_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Na waa ni rao ne saitomana gu 'ana doo ne waa baita nia dooria kai ilia, ma sui ka nao si ade akau ma nao si ilia guu doo nai, kera kai falea kwakwaea baita fuana. ");
INSERT INTO bvd_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Aia, na waa ni rao ne ilia si doo ni kwae lana faafia ma sui ka nao si saitomana lau gwana si doo ne waa baita nia 'e dooria, waa nai kera da kai kwae sarafaia gwada 'ani nia. “Waa ne God 'e faa doo baite ki fuana, God nia dooria waa nai ka faa lau guu si doo ne baita. Ma waa ne God 'e faa doo 'oro ka tasa ki lau fuana, God nia dooria waa nai ka faa lau guu doo ne 'oro ka tasa ki lau.” ");
INSERT INTO bvd_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Sa Disas ka bae lau 'urii, “Nau ku lea mai uri suungi lana molaagali, ma ku dooria era nai ka saru naa 'i tari'ina! ");
INSERT INTO bvd_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nau kwailiu 'i lao 'afitaia baita 'asia naa ne kai mala bae sa kera faasiuabu nau. Ma nau kwai manata fii 'asia naa sulia lelea nia ka sui gu faasi nau! ");
INSERT INTO bvd_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kamolu kwaifii 'amolu sae nau ku lea mai uri fale lana aroaroe gu 'ana lao molaagali nee? Nao ne! Nau ku lea mai uri toli lae ka toli 'i matangana toae. ");
INSERT INTO bvd_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","'Ita 'i tari'ina ka oli 'alaa, ta lima ai daka too 'ana tii luma, kera dai tolingi kera kwailiu, olu ai ta bali, ta roo ai ta bali. ");
INSERT INTO bvd_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Kera kai toli kwailiu 'i matangada, na maa ki dai toli faasia 'alakwa kera ki, ma darae ki faasia maa kera ki. Gaa ki dai toli faasia saari kera ki, saarii ki faasia gaa kera ki. 'Initai baita ki dai toli faasia keni fungao kera ki, ma keni fungao ki faasia fungo ni keni kera ki.” ");
INSERT INTO bvd_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Sa Disas nia bae lau fua konia baita nai ka 'urii, “Kamolu, lea molu suana dasa 'e raa mai faasia bali suu lana sato ka dau, 'ali'ali molu ka saitomana 'ua guu ne ute kai 'aru, ma ka 'aru mamana naa. ");
INSERT INTO bvd_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma lea molu suana lau gu koburu 'e dao mai fasi bali fuu, molu ka saitomana lau guu na uni sato kai dao ma faanoe kai 'ako'ako, ma ka 'ako'ako mamana naa. ");
INSERT INTO bvd_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kamolu toaa suke nee, molu saitomana 'amolu liofilo lana doo 'uri nai ki lofona salo loo ma fafona molaagali nee, ma sui molu ka ulafusia 'amolu liofilo lana doo neki God ilia lao si kada 'i tari'ina.” ");
INSERT INTO bvd_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Sa Disas nia bae ka 'urii lau, “'Utaa ne ka nao molu si filia 'amolu ili lana doo 'o'olo ki? ");
INSERT INTO bvd_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Lea ta waa 'e ngali 'oe uri didi lamu lao kwauto, sui fatai muru kafi dao lao kwautoe, 'oe 'oko 'olosia doo ki 'i matangamuru. Sulia lea nao 'osi ilia si doo nai ma muru ka dao naa lao kwautoe, nia kai fale 'oe 'i 'abana waa ni kwae lana kwauto, ma waa ni kwae lana kwauto kai fale 'oe naa 'abana waa ni alu lamu lao lookafo. ");
INSERT INTO bvd_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ma 'oe 'oko too na 'amu laona lookafo lelea 'oko falea guu si malefo 'isi ne tio.” ");
INSERT INTO bvd_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","'Ana kada nai lau guu, tai waa 'i seeri da faarongoa sa Disas ne sa Baelat nia saumaelia tai toaa faasia bali lolofaa 'i Galilii, kada kera foosia 'ada God. ");
INSERT INTO bvd_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ma sa Disas ka 'urii, “Ma uri tee gu nai? Sulia kera abulo ta'aa ka talu kera sui naa toaa 'i Galilii ne daka saungi kera nai, ma nao 'utaa? ");
INSERT INTO bvd_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nao! Aia ma nau ku faarongo kamolu, lea kamolu nao si luka guu 'ana abulo ta'aa lae, kamolu tiifau molu kai maelia. ");
INSERT INTO bvd_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Molu ka manata toi lau guu na akwala ma kwalu waa baki na luma baita bae 'asia faafida lao maefera 'i Saelom daka mae tiifau. Kamolu manata toi sae maana kera da garo baita ka talua toaa 'ana fera 'i Durusalem sui naa ne adea doo bae ka fuli 'ani kera bae? ");
INSERT INTO bvd_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nao! Aia nau ku faarongo kamolu, lea kamolu nao si luka guu 'ana abulo ta'aa lae, kamolu tiifau molu kai maelia.” ");
INSERT INTO bvd_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Sa Disas ka bae lau 'urii fuada 'ana tarifulae, “Totoo tii waa nai ka fasia tii 'ai da 'ailia 'ana fig 'i lao ola greib nia. Sui totoo lea ka dao naa 'ana kada nia kai fungu, nia ka lea na mai uria sua lana fuaedoo ki gwauna, ma sui ka nao si suana guu ta fuaedoo ai. ");
INSERT INTO bvd_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nia ka bae 'urii fuana waa ni rao lao ola nia, ‘'Oe suai nee, olu fa ngali ne ku maasia mai fig nee sulia uri sae ka fungu, ma sui ka nao kusi suai guu ta fuaedoo 'i gwauna. Lea 'oko tabaa ka 'asia 'ana 'i saegano. Nao si diana fua nia ka uu gu 'ana fua taulangai lana saegano nee 'urii!’ ");
INSERT INTO bvd_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Sui ma waa ni rao nai 'e luua ka bae 'urii, ‘Waa baita kani 'ae, 'oe alamatainia 'ai ne ka too fasi 'ana sulia tii fa ngali nee lau. Nau kwai 'eli kakaloa kakalia, ma kwai konia tatafu ki fua 'aena, uri saegano nee ka wawarasia fuai. ");
INSERT INTO bvd_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ma lea 'ai nee ka fungu 'afa ngali loo mai, nia ka diana 'asia naa. Ma lea ka nao guu, 'oko tabaa boroi na 'amua.’” ");
INSERT INTO bvd_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","'Ana tii fa dani Sabati, sa Disas nia toolangaidoo 'i lao tii beu ni ofu lae nai. ");
INSERT INTO bvd_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ma tii wela keni 'e nii 'i seeri na anoedoo ta'aa 'e 'adosia. Nia sulina ka buu ka matai mai sulia taafuli fa ngali ma kwalu fa ngali sarenga ki sui naa, ka nao si tala'ana nia ka uu 'o'olo lau. ");
INSERT INTO bvd_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Aia, kada sa Disas suana, nia ka 'ailia mai siana ka bae 'urii fuana, “'Oe 'akwaa 'amua faasia mataia nee wala.” ");
INSERT INTO bvd_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nia ka alu kau 'abana fafona welakani nai, ma 'ana si kada nai 'ua guu wela keni nai ka tatae ka sagaa naa sulina ka bae tangoa God. ");
INSERT INTO bvd_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ma kada waa gwaungai 'ana beu ni ofu laa nai 'e suana sa Disas 'e ilia si doo nai fuana wela keni nai 'afa dani Sabati, nia rakena ka sasu 'asia naa, ka bae 'urii fuana toaa nai ki, “Ono fa dani gu bae kamolu too ai uri ili lana raoa kamolu ki, ma uri molu ka lea mai daka gura kamolu ai. Nao lau 'afa dani Sabati 'urii!” ");
INSERT INTO bvd_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Disas na Aofia ka luua ka bae 'urii, “Kamolu toaa ni suke nee! Kamolu, molu rao ki gu 'amolu 'afa dani sabati 'ana kada molu kai lukea buluka ma dongki kamolu ki uri talai lada 'afa dani sabati uri kula kafo ni ai. ");
INSERT INTO bvd_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Aia ma wela keni nee, nia ta ai 'ana kwalafaa kokoo kia sa 'Abraham lau guu ne, sui ma Saetan ka kani 'urii mai faafia sulia taafuli fa ngali ma kwalu fa ngali sarenga ki. Nia diana naa ne nau ku guraa 'urii boroi 'ana 'afa dani sabati.” ");
INSERT INTO bvd_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kada sa Disas bae 'uri nai, na toa nai da malimae 'ana sa Disas daka 'ide baita. Ma na toaa nai ki daka ele lau gu 'ada sulia doo kwaibalatana nai ki sa Disas nia ilida. ");
INSERT INTO bvd_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","'I seeri sa Disas ka bae lau ka 'urii, “Kamolu kwaifii sae 'initoaa God doo na tee nee? Kamolu saitomana doo ne kwai faabolatainia 'initoaa God fainia? ");
INSERT INTO bvd_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tee nia 'uria miga doo tu'uu nai gwana 'ana doo ne da 'ailia 'ana mastad, ne tii waa nai 'e ngalia ka fasia lao ola nia. Sui ma nia ka tae lelea ka alua 'ai. Ma lelea saaro ki boroi lea mai daka saungainia naa nui kera ki ni too fafo sarana ki.” ");
INSERT INTO bvd_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Sa Disas ka bae lau 'urii, “Kamolu saitomana ta doo lau ne nau kwai faabolatainia 'initoaa God fainia? ");
INSERT INTO bvd_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tee nia 'uria lau guu kasi isi tu'uu nai gu 'ana, tii wela keni nai 'e ngalia ma ka dolaa fai flaoa 'oro, sui too lelea ma isi nai ka raa ka 'ogaa sui naa lao kumu nai 'ana flaoa ma ka bose baita mamana naa.” ");
INSERT INTO bvd_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tii si kada, sa Disas 'e lea ni toolangaidoo laa 'ana maefera baita ki fai maefera tu'uu ki sui gu 'ana ma ka lea ladoa naa uria 'i Durusalem. ");
INSERT INTO bvd_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ma tii waa ka ledia ka 'urii, “Wala arai 'ae. 'Uri nai ta bara waa gu 'ana ne God kai faamauri kera?” Sa Disas luua ka 'urii, ");
INSERT INTO bvd_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nau ku faarongo kamolu, molu ka susuu ta'aa, uri molu ka ruu 'ana maa ne susu ne lea uria fera 'i salo. Sulia toaa 'oro kera sasi uria ruu lae, sui ma nia ka 'afitai 'asia naa fuada sulia na maa nai kai fono suusida. ");
INSERT INTO bvd_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kada waa baita 'ana beu 'ana fera 'i salo 'e tatae, ma ka fonokia naa mae, kamolu kai uu 'i maa molu kai kikidi mai buri mae molu kai bae 'urii, ‘Waa baita kani 'ae, 'ifi kau uri kameli.’ Sui boroi 'ana ma nia kai olisi kamolu kai bae 'urii, ‘Nau nao kusi saitomamolu, ka nao kusi saitomana kula ne molu too mai ai.’ ");
INSERT INTO bvd_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Sui kamolu kai bae 'urii fuana, ‘Kameli bae meli fanga kwaimani lau gu mai fai 'oe, ma meli ka kuu kwaimani lau guu mai fai 'oe. 'Oe 'o toolangaidoo lau gu mai 'i lao toaa kameli ki bae!’ ");
INSERT INTO bvd_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Sui boroi 'ana ma nia ka bae 'urii, ‘Kamolu toaa nee fua ilidoo garo lae, 'otolangai kamolu, molu lea tau 'amolu kau faasi nau.’ ");
INSERT INTO bvd_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Ma 'i seeri kamolu kai liodila baita ma molu kai angi molu kai 'aladidilifo 'ana faatai lana rakesasua kamolu, kada molu suana fatai sa 'Abraham, sa 'Aesak, sa Diakab, ma 'aini brofet baki sui guu da too naa 'i lao 'initoaa nia God, ma sui ni kamolu daka 'ui 'ani kamolu 'i sara! ");
INSERT INTO bvd_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Aia ma toae ki kera kai dao mai faasia tae lana sato, suu lana sato, faasia gwauna faanoe, ma faasia 'aena faanoe. Ma kera daka koni 'ana fanga kwaimania nai 'i lao 'initoaa nia God. ");
INSERT INTO bvd_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Sulia toaa da 'isiburi ki dai liu 'i nao, ma toaa da liu 'i nao ki dai 'isiburi.” ");
INSERT INTO bvd_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","'Ana kada nai, tai Faarisii da lea mai siana sa Disas daka bae 'urii fuana, “'Oe tafi 'amu fasi seki, sulia sa Herod na waa gwaungai nee nia dooria kai saungi 'oe naa ne!” ");
INSERT INTO bvd_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ma sa Disas ka bae 'urii, “Lea kau molu ka faarongoa giri kwasi nai. Molu saea fuana nau ku bae 'urii fuana, ‘Suai fasi nee, 'i tari'ina fainia 'i bobongi gu 'ana ne nau kwai ilia 'akua raoa nau 'ana tari lana anoedoo ta'aa ki ma gura lana toaa matai ki. Ma 'i fulee 'ana oluna fa dani lau gu 'ana ne nau kwai faasuia raoa nau ki ai. ");
INSERT INTO bvd_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Sui boroi 'ana, nau ku tasa kwailiu na mone 'akua uria 'i Durusalem 'i tari'ina, fai 'i bobongi, ma 'afa dani loo ki burina ki lau guu. Sulia na brofet doo 'afitai daka saungia lau mai 'ana ta kula 'e'ete ne. 'I Durusalem na mone 'ana ne kera kai saungi nia ai.’” ");
INSERT INTO bvd_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Sa Disas ka bae lau 'urii, “'Oo toaa nee 'i Durusalem 'ae! Kamolu naa bae molu 'uifauna brofet baki God eresi kera mai siamolu ki, ma molu ka saumaelida naa. 'Ana kada 'oro nau ku dooria 'asia naa sae molu ka lea mai siaku uri ku ofi kamolu, mala 'ana ta karai ne ofia kalena ki farana kukubana, ma sui molu ka ote kamolu guu. ");
INSERT INTO bvd_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ma sui 'i tari'ina, God kai lukasi kamolu naa. Nau ku faarongo kamolu, 'afitai molu ka suaku lau lelea ka dao naa kada kamolu kai bae na 'urii, ‘'E diana tasa fuamu waa ne God fale 'oe mai 'oko dao nee!’” ");
INSERT INTO bvd_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","'Ana tii fa dani Sabati, kada sa Disas 'e lea kau ka fanga 'ana luma tii waa baita 'ana Faarisii ki, waa ki da bubu tu'uu suli nia uria sua lana lea nia ka ilia tasi doo ni bae too lana fainia. ");
INSERT INTO bvd_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Aia, tii waa roo 'abana ki fai roo 'aena ki da ubu baita 'asia naa, 'e lea mai siana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ma sa Disas ka ledia Faarisii ki fai waa ni toolangaidoo lae 'ana taki ki ka 'urii, “Nia sae taki kia 'e faolomainia kolu kai guraa gu 'akolu waa matai 'ana Sabati, ma nao nia luia?” ");
INSERT INTO bvd_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ma sui ka nao kera dasi luu nia guu. Sa Disas ka dau tona waa matai nai ma nia ka 'akwaa lau gu 'ana, sui ka odua ka oli na 'ana. ");
INSERT INTO bvd_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sui sa Disas ka ledia lau toa baita nai ka 'urii, “Aia, lea sae 'oe ta waa 'alakwa 'oe ma nao ta buluka 'amu, nia 'asia lao kilu 'afa dani Sabati, 'oe lae 'oko 'abaa gu 'amu ai?” ");
INSERT INTO bvd_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ka nao ta waa ada si bobola fainia ka olisi nia gu 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Aia, sa Disas ka suana toaa ne kera kwaiodui kau uri kera 'ana fafangaa nai kera dao naa, ma daka filia sui guu kula ni gooru lae fuana waa 'initoe ki. Ma nia ka falea tii si tarifulaa 'urii fuada, ");
INSERT INTO bvd_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kada ta waa nia kwaiodui kau uri 'oe 'oko lea mai 'ana fafangaa 'i luma nia, dao nao 'osi gooru fasi 'amu 'ana kula ni gooru lae fuana waa 'initoe ki. Sulia ade lea nia ka kwaiodui kau ma ta waa ne 'initoa ka talu 'oe fatai ka dao mai 'isi, ");
INSERT INTO bvd_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ma waa ne kwaiodui kau fuamuru ka bae 'urii fuamu, ‘'Oe 'idu 'amu fasi seki, uri sa wala nee ka gooru ai.’ Lea 'uri nai, 'oe 'oko 'ide 'asia naa nai, sulia kera 'idu 'oe 'oko gooru naa 'i saegano kula fuana oena wane ki gu 'ana. ");
INSERT INTO bvd_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Aia, ma lea kera kwaiodui kau uri 'oe, dao 'oko gooru gu 'amu 'i saegano, uria lea kada waa ne kwaiodui kau nia dao suai kafi bae 'urii fuamu, ‘Wala waa nau, 'oe 'idu mai 'oko gooru diana 'i langi.’ 'Uri nai guu, ma nia ka sae'inito na 'ani 'oe 'i maana konia nai sui guu 'ana fanga kwaimania nai. ");
INSERT INTO bvd_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sulia waa ne faa'inito nia 'i tala'ana, God kai faatu'uu nia, ma waa ne faatu'uu nia 'i tala'ana, God kai faa'inito nia.” ");
INSERT INTO bvd_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Sa Disas ka bae lau 'urii fuana waa ne saungainia fafangaa nai, “Kada 'oe 'o saungainia ta fafangaa, nao 'osi kwaiodui uria toaa kwaimani 'oe ki ma toolamu ki gu 'ana, ma nao sae waa suadoo neki molu too kwaimani ki gu 'amolu. Ade lea kera daka ade doo ma daka kwaiodui lau gu mai uri 'oe, ma daka duu langa lau gu 'ada fuamu 'ana doo baki 'oe ilida ki mai fuada. ");
INSERT INTO bvd_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Aia, lea 'oe 'o saungainia fafangaa, 'oko kwaiodui 'amu uria toaa siofaa ki, toaa 'aeda ma 'abada ta'aa ki, ma toaa maarodo ki. ");
INSERT INTO bvd_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ma lea 'oe ade 'uri nai, nia ka diana 'asia naa fuamu, sulia toaa nai ki kera nao si tala'ana naa duu langa lae 'ana ta doo fuamu. Ni 'oe, kada God kai tataea toaa 'o'olo ki faasia maea, 'ana kada nai fatai nia kafi duu langa fuamu.” ");
INSERT INTO bvd_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ma 'ana kada nai, tii waa 'ana toa ne kera too 'ana fafangaa, nia rongoa tee ne sa Disas nia saea, nia ka bae 'urii, “'E diana tasa fuana toaa ne kera kai fanga 'ana fafangaa 'i lao 'initoaa nia God.” ");
INSERT INTO bvd_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ma sa Disas ka bae 'urii, “Tii waa 'e saungainia fafangaa baita 'ana tii si kada, ma ka kwaiodui uria toaa 'oro daka lea mai 'ana fafangaa nai. ");
INSERT INTO bvd_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ma kada kera raodoo ka sui naa ma doo ki tiifau ka kwaimaakwalii naa, nia ka odua waa ni rao nia ka lea naa uria talai lana mai toaa ne nia kwaiodui kau uri kera daka lea mai. Uri nia ka bae 'urii fuada, ‘Kamolu lea na mai nai, sulia doo ki kwaimaakwalii sui naa.’ ");
INSERT INTO bvd_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ma sui kera safali daka fofo naa, daka saea kera 'abarua sui gu 'ada 'ana si doo kwaifa'ogai kera ki ma nao dasi lea gu mai. Ta waa 'e bae 'urii, ‘Nau kufi usia guu tii si gano, ma ku dooria lea kui iroa fasi. Kwaimantai 'asia naa, kusi lea gu kau.’ ");
INSERT INTO bvd_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ma ruana waa ka bae 'urii, ‘Nau kufi usia gu 'aku taafuli buluka nau, ma ku dooria lea kui ilitoda fasi 'ana raoe. Kwaimantai 'asia naa, kusi lea gu kau.’ ");
INSERT INTO bvd_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Oluna waa ka bae 'urii, ‘Nau kufi arai guu, ka 'afitai 'asia naa fuaku uri lea lae kau. Kwaimantai 'asia naa, kusi lea gu kau.’ ");
INSERT INTO bvd_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Kada waa ni rao 'e oli mai dao ka faarongoa waa baita nia 'ana doo nai ki, waa baita nia ka rakesasu 'asia naa, ka bae 'urii fuana waa ni rao nia, ‘'Oe 'ali'ali 'oko lea lau sulia tala baita ki fai kasi taala tu'uu ki, 'oko talaia mai toaa siofaa ki, toaa 'aemae ki ma toaa 'aba mae ki, toaa nonida mae ki, ma toaa maarodo ki.’ ");
INSERT INTO bvd_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kada waa ni rao nai 'e oli mai ka dao naa, nia ka bae 'urii fuana waa baita nia, ‘Waa baita kani 'ae, doo bae 'oe saea ki fuaku, nau ku ilida sui naa, sui boroi 'ana ma kula ni gooru laa neki 'ana fafangaa 'oe nee da gwau 'ua ki gu 'ada.’ ");
INSERT INTO bvd_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Waa baita nai ka bae lau 'urii, ‘'Oe lea lau sulia taala baita baki fai taala tu'uu ki, 'oko radi 'aena lau mai tai toaa ne nii 'ua, uri luma nau nee ka fungu guu. ");
INSERT INTO bvd_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ku faarongo 'oe, nia 'afitai 'asia naa fua ta waa 'ana waa baki nau ku kwaiodui kau uri kera 'i nao ka fanga 'ana fafangaa nau nee.’” ");
INSERT INTO bvd_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tii si kada, konia baita nai da lea kwaimani fai sa Disas ma nia abulo ka bae 'urii fuada, ");
INSERT INTO bvd_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Lea waa dooria kai sule buriku ma sui ka nao si liosau 'ani nau si talua gu maa nia, ma gaa nia, ma 'afe nia, ma wela nia ki, ma toolana ki, ma waiwane nia ki, ma ni nia 'i tala'ana boroi, nia 'afitai 'asia naa fua nia ka waa kwairooi nau. ");
INSERT INTO bvd_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Waa ne nao si ala guu faafia liu lae lao 'afitaia ki ma maeli lana sule lae 'i buriku, nia 'afitai 'asia naa fua nia ka waa kwairooi nau. ");
INSERT INTO bvd_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Sulia ni kamolu sui guu, lea waa 'amolu dooria saungai lana ta luma ne baita, nia ka gooru ngado ka manata fasi sulia fita si malefo ne kai bobola fainia faasui lana luma nai ai. ");
INSERT INTO bvd_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Lea nia nao si ili 'uri nai ma 'i burina gwana nia saungainia boongado lana luma nai ma malefo ka sui lau gwana, ma toae ki daka suana nao nia si bobola naa fai faasui lana, kera daka 'oitona ma daka bae buri 'urii suli nia, ");
INSERT INTO bvd_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Soi 'akolu sa wala nee 'e safalia gu faauu lana luma nee lea sui ka nao si bobola naa fai faasui lana!’ ");
INSERT INTO bvd_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ma waa 'inito ki boroi, lea ta waa 'inito kai tae kau fai tii taafuli tooni waa ni omee nia ki uri firu lae fai ta waa 'inito 'ana ta fera, nia kai gooru ngado ka manata fasi. Sulia ade lea omee nia nai 'ana tii taafuli tooni wane ka nao si bobola fai firu lae fai omee nia waa 'inito 'e too 'ana roo taafuli tooni wane ki. ");
INSERT INTO bvd_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ma lea nia ka nao si bobola guu, nia ka odua ta waa 'ana ka lae uri ka gani uria aroaroe 'i matangadaru, 'ana kada kera nii tau 'ua mai. ");
INSERT INTO bvd_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Talafamolu lau gu nai, molu manata diana fasi 'amolu sulia 'afitaia neki sui guu kamolu kai liu 'i laona kada kamolu sule buriku, sulia waa ne nao si lukasia doo nia ki tiifau 'i burina uri sule lae buriku, nia 'afitai 'asia naa fua nia ka waa kwairooi nau.” ");
INSERT INTO bvd_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sa Disas ka bae lau 'urii, “Na solo na doo diane. Ma sui boroi 'ana, lea mamasia lana 'e nao'ana na faasia, 'afitai naa 'oko ilia ka mamasia lau. ");
INSERT INTO bvd_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","'E nao si diana naa fuana ili lana 'ana tasi doo lau. 'E nao si diana naa fua lao saegano ma fua bai lana fai ta doo lau. 'E bobola gu 'ana fai daka 'ui nada ai. 'Oe waa ne 'o too 'ana alingamu uri rongo lana doo ki, 'o rongo doo nai ki 'oko rongo diana ai.” ");
INSERT INTO bvd_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","'Ana tii si kada, waa ni koni lana malefo 'ana takisi ki ma tai toaa abulo ta'aa lau, kera koni mai sia sa Disas uri fafurongo lana. ");
INSERT INTO bvd_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","'I seeri, na Faarisii ki fai waa ni toolangaidoo 'ana taki ki, daka safali 'uga naa daka 'urii, “Sa wala nee gonia mai 'aini toaa abulo ta'aa nee ka fanga kwaimani na 'ana fai kera, 'o 'e nao si 'o'olo fua ili lana!” ");
INSERT INTO bvd_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","'Uri nai, sa Disas ka unu sulia tii si tarifulaa fuada ka 'urii, ");
INSERT INTO bvd_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Lea ta waa too 'ana tii talanga sifsif, ma ta tii doo ka nao'ana, nia kai faasia sikwa taafuli ma sikwa doo neki da too ki, daka too ni fanga laa 'ada 'i seeri, ma nia ka lea ka nani naa burina tii doo ne nao'ana nai lelea ka dao tona guu. ");
INSERT INTO bvd_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ma si kada nia dao tona, nia ka ele 'asia naa ka tamaa, ");
INSERT INTO bvd_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ka oli na mai fainia. Lea mai 'e dao, ka 'ailia mai toaa da too kwai karangi 'ani nia ki ma ruana nia ki, daka koni na mai nia ka bae 'urii fuada, ‘Nau ku ele 'asia naa, sulia ku dao tona naa sifsif nau bae nao'ana. Nia ne kamolu ka ele kwaimani 'amolu fai nau!’” ");
INSERT INTO bvd_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ma sa Disas ka bae lau 'urii, “Nau ku faarongo kamolu, na ele laa ne fuli lao fera 'i salo faafia ta tii waa abulo ta'aa boroi lea nia luka 'ana abulo ta'aa laa nia ki ma ka abulo talea God, nia 'e baita tasa ka talua lau ele lae sulia sikwa akwala ma sikwa waa neki da 'o'olo ki.” ");
INSERT INTO bvd_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Sa Disas ka bae lau 'ana ta tarifulaa ka 'urii, “Lea ta wela keni nia too 'ana tii taafuli seleni ma ta tii fa doo ka nao'ana. Nia kai faasarua kwesu ma kai salofia luma nia, uri nanisi tiifau lae ai uri fa seleni nai lelea nia ka suai guu. ");
INSERT INTO bvd_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ma si kada nia suai naa, nia ka 'ailia toaa kwaimani nia ki, ma toaa kera too kwaimani ki ka bae 'urii fuada, ‘Nau ku ele 'asia naa sulia ku suai naa fa seleni nau bae 'e nao'ana. Nia ne kamolu ka ele kwaimani 'amolu fai nau!’” ");
INSERT INTO bvd_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Sa Disas ka bae lau gu 'urii, “Nau ku faarongo kamolu, talafana lau guu si doo God fai 'ensel nia ki lao fera 'i salo da ilia nai. Kera da ele 'asia naa faafia lea ta tii waa abulo ta'aa boroi 'e luka 'ana garoa nia ki ma ka abulo talea God.” ");
INSERT INTO bvd_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Sa Disas ka bae lau guu 'ana ta tarifulaa ka 'urii, “Tii waa nai fai roo 'alakwa nia ki kera too 'ada. ");
INSERT INTO bvd_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Totoo, waa nai 'i buri ka bae 'urii fuana maa keeru, ‘Maa 'ae, 'o faa na mai kula 'i sataku 'ana suadooa kolu fuaku.’ 'Uri nai, waa nai ka tolingia naa suadooa kera ka faa naa kula 'e naisata ki 'ana roo 'alakwa nia ki fuadaru. ");
INSERT INTO bvd_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Aia, 'i burina ta bara fa dani sui, waa bae 'i buri ka koni tiifau 'ana bali suadooa 'i satana, ka ngalia ka lea na 'ana bali fera tau. Nia lea kau dao seeri ka taulangai tiifau 'ana malefo nia ki 'ana tooa ni oewanea lae. ");
INSERT INTO bvd_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ma kada nia 'e taulangainia malefo nia lelea ka sui atafu naa, na uni fioloa talingai 'asia naa ka liu lao bali nai ma nia ka nao si too naa 'ana tasi doo lau. ");
INSERT INTO bvd_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nia ka lea uri ledi raoa lae siana tii waa 'ana fera nai, ma waa nai ka faa tii si raoa bilia fuana uri sua lae sulia boso nia ki. ");
INSERT INTO bvd_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ma nia ka dooria naa 'ani lana duaa boso ki, sulia nao ta waa si faa naa tasi fanga fuana. ");
INSERT INTO bvd_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Sui totoo tii si kada manata lana 'i tala'ana ka oli ka manata 'urii, ‘Na toaa ni rao nia maa nau da 'oro, ma sui boroi 'ana kera fanga diana daka abusu ka sui guu. Ma nau ne ku fiolo kui mae naa nee! ");
INSERT INTO bvd_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kaa diana ku oli 'aku siana maa nau. Ku lea kau dao siana ku bae 'urii naku fuana: 'O maa 'ae, nau ku ade garo 'asia naa 'i maana God, ma 'i maamu lau guu. ");
INSERT INTO bvd_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nau nao kusi tala'ana naa 'oko saea lau nau 'alakwa 'oe. 'O suaku na 'amu mala waa ni rao 'oe gu 'ana.’ ");
INSERT INTO bvd_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nia ka sulatatae 'i seeri, ka oli na mai siana maa nia. “Kada nia dao tau 'ua mai fasi 'i fera, maa nia 'e lio kau ka suana naa, ka manatainia 'asia naa 'alakwa nia. Ma nia ka lae 'ali'ali kau dao ka 'obia 'alakwa nia, ka nonoia naa. ");
INSERT INTO bvd_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ma sui 'alakwa nia ka bae 'urii fuana, ‘'O maa 'ae, nau ku ade garo 'asia naa 'i maana God ma 'i maamu lau guu. Nau nao kusi tala'ana naa 'oko saea lau nau 'alakwa 'oe.’ ");
INSERT INTO bvd_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Sui boroi 'ana maa nia ka 'ai naa uria na toaa ni rao nia ki ka 'urii, ‘Molu 'ali'ali kau lae molu ngalia mai na maku tikwa liu lana talingaia bae molu ka faa ruufi nia ai. Molu ka alua fa kokome ki 'abana fai butu ki 'aena. ");
INSERT INTO bvd_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Lea sui, lae molu ka saungia buluka kafi baita diana bae uri kolu ka fanga kwaimani kolu ka ele 'akolua. ");
INSERT INTO bvd_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sulia 'alakwa nau nee, nia mala bae sae nia mae naa ma sui ka mauri lau ne. Ka nao'ana naa ma sui kolu ka suana lau.’ 'Uri nai guu, kera ka safalia naa ele lae ma fanga kwaimania nai. ");
INSERT INTO bvd_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“'Ana kada nai, waa ulunao nia bae 'e nii 'ua mai lao ole ka nao oli mai si dao 'ua. Ma kada nia oli mai ka dao karangia guu lume, nia ka rongoa naa angi lana 'au 'ana wae lae nonina fafangaa nai. ");
INSERT INTO bvd_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nia ka 'ailia kau tii waa 'ana toaa ni rao nai ki, ka ledia uri tee ne kera waelia 'au ai. ");
INSERT INTO bvd_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Waa nai luua ka bae 'urii, ‘Na saasimu bae loko oli mai ka dao naa 'i fera, ma maa 'oe ka saungia naa buluka kafi baita diana bae, sulia nia suana saasimu 'e mauri gu 'ana oli mai ka dao lau.’ ");
INSERT INTO bvd_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ma sui, ulunao nai rakena ka sasu 'asia naa, ka ote nia naa 'ana ruu lae mai luma. Maa nia ka ruu mai 'i maa, ka radi kalia naa uri ruu lae mai luma. ");
INSERT INTO bvd_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nia ka luua maa nia ka bae 'urii, ‘'Oe suai fasi 'amu nee, nau ku rao mai fuamu mala ta gwa waa ni rao 'oe gu 'ana sulia fa ngali 'oro neki ma ku roo mai sulia bae lamu. Ma sui ka nao 'osi faa guu ta kaa nanigot boroi 'ana fuaku, uri nau fai toaa kwaimani nau ki meli ka fanga kwaimani ma meli ka ele 'ameli ai! ");
INSERT INTO bvd_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ma sui, na 'alakwa 'oe nee doo ne taulangainia sui naa suadooa 'oe fuana wela keni olodola ki, kada nia oli mai ka dao 'i fera, 'oe 'oko saungia fatai buluka kafi baita diana bae fuana!’ ");
INSERT INTO bvd_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Maa nia ka luua ka 'urii, ‘'Alakwa nau 'ae, 'oe naa ne too ngado siaku 'i fera, ma doo nau neki tiifau doo 'oe ki gu 'ana ne. ");
INSERT INTO bvd_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Aia, ma saasimu si doo 'e bobola naa fai ili lana fuana loko meli ilia 'ana ele lae sulia dao lana mai. Sulia nia mala bae sae nia 'e mae naa ma sui ka mauri lau. Ma nia ka nao'ana naa, sui ma kolu ka suana lau.’” ");
INSERT INTO bvd_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Sa Disas 'e unu sulia tii si tarifulaa fuana waa kwairooi nia ki ka bae 'urii, “Totoo tii waa suadoo nai ka too 'ana waa ni suasuli lana suadooa nia. Ma sui tai waa ki daka faarongo nia saea sa wala nai 'e rao ta'aa ka kaubarea gu 'ana suadooa nia ki waa suadoo nai. ");
INSERT INTO bvd_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Aia, 'uri nai waa suadoo nai ka 'ailia mai waa ni rao nia nai ka ledi 'urii 'ani nia, ‘Nee wala, ma nau ku rongoa waa ki da unutai 'oe siaku sulia tee guu? Lae kau ngali mai buka 'oe sulia fita si malefo 'aku bae 'oe suasulia, sulia 'oe nao 'osi baita 'ana suadooa nau.’ ");
INSERT INTO bvd_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Na waa ni rao ta'aa nai ka manata 'urii, ‘Na waa baita nau kai faasui nau naa fasi rao lae nai. Nia 'uri nai ma nau tari'ina ku ade 'utaa ro, uri ku dao toi lau tasi raoa falu? Nau kusi tetede naa fua 'eli kakaloa lae, ma nau ku noni susuala lau guu 'ana gani lana doo ki sui gu 'ana siana waa ki. ");
INSERT INTO bvd_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","'Oo iuka, nau ku manata toi naa si doo kui ilia fua waa ki kada lea waa baita nau faasui nau fasi raoe, uri lea doo waa ki daka 'aili nau 'i luma kera ki.’ ");
INSERT INTO bvd_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“'I seeri, nia ka 'ailia na mai toaa da ngali langa 'ana malefo waa baita ki siana, ka ledi 'urii 'ana etana waa, ‘Fita doo bae 'oe ngali langa ai 'ana malefo nia waa baita siaku bae?’ ");
INSERT INTO bvd_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nia luua ka 'urii, ‘Tii talanga bii waiwai bae.’ Na waa ni rao kaubare doo nai ka bae 'urii fuana, ‘Na 'aba beba sulia ngali langaa 'oe ne, ngalia kau 'oko gooru ngado 'ali'ali 'oko kedaa na 'amua lima taafuli bii doo guu.’ ");
INSERT INTO bvd_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Sui nia ka ledia lau guu ruana waa ka 'urii, ‘Ma 'oe mone, lae 'ali'ali doo ne 'oe ngali langa ai?’ Nia luua ka 'urii, ‘Tii talanga wai flaoa bae.’ Nia ka bae lau gu 'urii fuana, ‘Na 'aba beba sulia ngali langaa 'oe ne, ngalia kau 'oko gooru ngado 'ali'ali 'oko kedaa na 'amua kwalu taafuli wai doo guu.’ ");
INSERT INTO bvd_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","'Uri nai guu, na waa baita nai ka tangoa na 'ana waa ni rao kaubare doo nai uria saitomadooa ne nia too ai nai. Sulia toaa 'ana molaagali ki da saitoma doo ka talua lau gu 'ana toaa 'ana kwesu folae. ");
INSERT INTO bvd_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Nau ku faarongo kamolu, molu faa kau suadooa kamolu ki fuana 'adomi lana toaa maadao ki. Uria lea kada malefo kamolu nia sui naa, God ka talai kamolu uri lao fera 'i salo. ");
INSERT INTO bvd_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Waa ne mamana 'ana sua lae sulia kaa suadooa tu'uu, suadooa baite boroi nia kai mamana lau guu 'ana sua lae sulia. Ma waa ne nao si mamana 'ana sua lae sulia kaa suadooa tu'uu, suadooa baite boroi nia nao si mamana lau guu 'ana sua lae sulia. ");
INSERT INTO bvd_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Talafana lau guu si doo nai, lea nao kamolu si sua diana sulia suadooa 'ana molaagali, suadooa mamana nee boroi 'afitai kamolu ka sua diana lau guu sulia. ");
INSERT INTO bvd_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ma lea nao kamolu si rao diana 'ana si doo nia waa 'e'ete, si doo fuamolu 'i tala'amolu boroi God nao si faa lau gu fuamolu. ");
INSERT INTO bvd_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Tii waa ni rao guu nia 'afitai ka rao fuana roo waa baita 'e'ete ki sui 'ana tii si kada. Lea nia ade 'uri nai, nia kai liosau 'ana ta waa baita, ma ta ruana waa baita nia ka malimae na 'ani nia. Ta waa baita nia ka rao diana fuana, ma ta ruana waa baita nia ka faiburi na 'ani nia. Talafana lau gu ni kamolu nai, nia 'afitai uri kamolu ka rao fuana God, ma molu ka rao lau guu fuana malefo 'ana tii si kada.” ");
INSERT INTO bvd_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Aia, kada Faarisii ki da rongoa si doo nai, kera daka 'oniongaa 'ada sa Disas, sulia kera da suana malefo ka diana 'asia naa lao maada. ");
INSERT INTO bvd_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Sa Disas ka bae 'urii fuada, “Kamolu nee molu ilia gu 'amolu doo diana neki uri toae ka suamolu ma daka tango kamolu fainia. Sui ma God 'e saitomana gu 'ana liomolu. Sulia doo ne wane faa'initoaa 'ana, God nia mamagutainia.” ");
INSERT INTO bvd_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Sa Disas ka bae lau 'urii, “Na taki sa Mosis fai kekeda laa brofet ki, da kwaitalai 'ana toae lelea mai ka labu gu 'ana dao lana sa Dion waa ni faasiuabu. Safali 'i seeri ka lea na mai, si faarongoa diana sulia 'initoaa God naa ne da bae sulia, ma toaa 'oro ki daka ele talingai sui gu 'ada sulia uri ruu lae mai 'i lao 'initoaa nai. ");
INSERT INTO bvd_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Aia, na salo loo fai saegano nee boroi da taa walude gu 'ada uri sui lae, ma taki sa Mosis, 'afitai tasa naa tasi orongadoo tu'uu boroi 'i laona totoo ka sui. ");
INSERT INTO bvd_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Waa ne lukasia 'afe nia ma ka adea lau ta ai 'e'ete, nia kaubarea araie ma 'afee. Ma waa ne adea 'initai ne arai nia lukasia, nia 'e kaubarea araie ma 'afee.” ");
INSERT INTO bvd_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Sa Disas ka unu lau sulia tii si ununua ka 'urii, “Totoo tii waa suadoo tasa nai 'e ofi sui gu 'ana maku waa 'initoe ki ne sua lada diana 'asia naa, ma ka 'ania sui guu fanga diana ki sulia kudu, nia ka too 'ana. ");
INSERT INTO bvd_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ta ruana waa, satana sa Lasaros, na waa siofaa ka ulafu 'asia naa ma ka kakamoa ta'aa 'isi. Nia kai tio ki gwana 'aena maesakae noni luma nia waa suadoo nai. ");
INSERT INTO bvd_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ma sa Lasaros ka dooria gu 'ana 'ani lana orongana fange ne kai 'asia ki faasia tefolo ni fanga nia waa suadoo nai, ma na giri ki na 'ana dai dau 'ana meeli lana saru nia ki. ");
INSERT INTO bvd_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Aia, too 'uri nai lelea sa Lasaros ka mae naa, na 'ensel ki lea mai daka ngalia na kau sia sa 'Abraham lao fera 'i salo. Ma 'i seeri, waa suadoo nai ka mae lau guu, kera daka saufinia naa. ");
INSERT INTO bvd_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ma nia, ka lea ka too na 'ana kula kera toaa mae ki 'i lao fii lae ma liodilaa baita. 'E too 'i seeri 'e lio 'alaa kau, ka suana naa sa 'Abraham 'e nii tau 'asia na mai, ma ka suana sa Lasaros 'e too kwaimani na 'ana fainia. ");
INSERT INTO bvd_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ma nia 'ai kau fua sa 'Abraham ka 'urii, ‘'Oi kokoo nau 'Abraham 'ae, 'o manatai nau 'amu mai. Odua sa Lasaros lae fasi mai ka kutungainia boroi 'ana maa fa kakau lao si kafo, ka alu ka 'udufia meaku uri ka taa gwagwaria mone 'ana. Nau ku nonifii ta'aa 'asia naa lao era nee!’ ");
INSERT INTO bvd_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Sui ma sa 'Abraham ka bae 'urii fuana, ‘'Alakwa nau 'ae, 'o manata toi fasi 'amu tooa 'oe 'ana kada bae sui naa, 'oe too 'ana doo diana 'oro ki 'asia naa bae. Ma sa Lasaros, 'ana kada bae sui naa, nia too ta'aa gu 'ana. Sui ma 'i tari'ina, nia too na 'ana elea 'i seki nai, ma ni 'oe 'oko too na 'amu 'ana liodilaa ma nonifiia. ");
INSERT INTO bvd_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ka fafonaa lau doo nai ki, God 'e alua sui naa tii kilu liu baita ka tasa ladoa 'i matangakolu ka suusi kolu naa, ka 'afitai 'asia naa uri falifolo lae kau 'i sena siamu, ma nao falifolo lae mai 'i seki siamiri.’ ");
INSERT INTO bvd_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ma waa suadoo nai ka luua kau ka 'urii, ‘Kokoo 'ae, nau ku amasi 'oe naa. Odua sa Lasaros lea kau luma kera maa nau, ");
INSERT INTO bvd_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","uri dao ka kwaifamanatai 'ana lima waa toolaku ki 'i fera, uri nao dasi lea lau mai 'i seki lao nonifiia nee.’ ");
INSERT INTO bvd_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ma sui sa 'Abraham nia luua ka bae 'urii, ‘Kera too gu 'ada 'ana kekeda laa baki sui guu sa Mosis fai brofet ki siada 'i fera. Alu kera ade 'ada sulia doo baki da saea ki.’ ");
INSERT INTO bvd_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ma nia ka bae 'urii, ‘Kokoo 'Abraham 'ae, 'e nao. Ni kera, lea sae ta waa ne mauri 'ua gu kau fasi maea 'e dao siada taari, ka adea kera daka luka 'ana abulo ta'aa laa kera ki.’ ");
INSERT INTO bvd_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Sa 'Abraham ka bae lau 'urii fuana, ‘Lea kera nao dasi ade gu sulia kekeda laa sa Mosis fai brofet ki, ta waa ka tatae boroi kau faasia maea ka faarongo kera boroi, kera 'afitai guu daka faamamane nia.’” ");
INSERT INTO bvd_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Sa Disas ka bae 'urii fuana waa kwairooi nia ki, “Doo neki da kai talaia wane uri abulo ta'aa lae, kera lea na mai uri wane 'afitai ka nao lau. Sui boroi 'ana ta, tara nia kai ta'aa kai tasa fua tii ne nia talaia wane uri abulo ta'aa lae! ");
INSERT INTO bvd_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nia diana lea sa daka kani kulua ta maefau baita tasa 'i luana ma lea daka kulufauna lao asi kwasi, fasi ade lea nia ka talaia ta wane 'ana wane malania nau neki uri lukasi lana manata mamana laa nia 'ani nau. ");
INSERT INTO bvd_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Molu ka fiia! “Lea na toolamu nia garo, 'oko ngatafia. Lea nia luka 'ana garo laa nia nai, 'oko manata luke nia. ");
INSERT INTO bvd_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Aia, ma lea nia ka ilia tasi doo ka garo fuamu 'ana fiu si kada ki lao fa sato ma ka lea sui gu mai siamu 'ana si kada nai ki ma ka bae 'urii, ‘Nau ku bulasi manataa naa faasia garo laa nau ku ilia fuamu,’ 'oko manata luke nia lau guu 'ana fiu si kada nai ki.” ");
INSERT INTO bvd_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","'I seeri na 'aboosol ki daka bae 'urii fuana Aofia, “Kameli dooria 'oko ilia manata mamana laa kameli ka baita ka 'idu lau!” ");
INSERT INTO bvd_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Sa Disas ka bae 'urii, “Lea sae manata mamana laa 'oe nia tu'uu boroi 'ana mala 'ana ta miga mastad tu'uu 'isi, lea sae 'oe bae 'urii fua ta 'ai baita boroi 'ana 'uri loko, ‘'O kwaikutu 'amu fai lalimu ki sui guu fasi seki, 'oko lea kau fubaa lao asi.’ Tara nia kai ade gwana sulia bae lamu nai. ");
INSERT INTO bvd_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Kamolu, lea sae ta wane 'amolu too 'ana ta wane ni rao ma nia lea ka anobataa mai ola 'oe, ma nao ka lio mai sulia sifsif 'oe ki, sui ka oli mai ka dao 'i fera. Si kada nai nia rao ka lede nia 'asia naa sui oli mai ka dao 'i luma nai, tee ne 'oe kai saea fasi 'i nao fuana uri ili lana? Na fanga lae ne lea doo 'oe 'ali'ali 'oko 'aili nia fasi 'amu 'i nao uri nia ka ilia? ");
INSERT INTO bvd_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nao! 'Oe bae lau 'amu 'urii fuana, ‘Lea kau 'o naare fanga fasi fuaku sui lea 'oko ofi falu sui 'oko ngali mai fanga nau ki uri ku fanga aku. Burina 'oe ilia doo nai ki sui fatai, 'oe 'ofi fanga ma 'ofi kuu 'amu.’ ");
INSERT INTO bvd_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tee ne adea na waa baita nai ka nao si tangoa gu wane ni rao nia? Suli na wane ni rao nai nia ilia gwana si raoa ne da odu nia 'ua gu uria ma ka nao si ilia gu tasi doo ne 'idu lau kau 'i fafona. ");
INSERT INTO bvd_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Talafamolu lau gu nai. Si kada molu ilia 'aini raoa nee sui guu God nia odu kamolu uria lelea ka sui naa, molu ka bae gwamolu 'urii, ‘Kameli nao guu tai wane 'initoa suli kameli toaa uri ili lana gwana si raoa neki God nia odu kameli ki uria.’” ");
INSERT INTO bvd_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Si kada sa Disas nia lea uria 'i Durusalem, nia lea ka liu matangana bali lolofaa 'i Samaria fai lolofaa 'i Galilii. ");
INSERT INTO bvd_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Si kada nia dao 'ana tii maefera nai, tii akwala waa furo saungi kera ki daka lea mai siana dao daka uu tau gwada mai, ");
INSERT INTO bvd_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","daka 'a'ai mai daka 'urii, “Disas waa baita 'ae, 'o manatai kameli mai!” ");
INSERT INTO bvd_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Si kada sa Disas nia suada kau, nia ka bae 'urii fuada, “Lea kau molu ka faatainia nonimolu siana waa ni foa God ki, uri daka faamamanea ne nonimolu ki maafo ma ka falu naa.” Ma si kada kera lea na kau 'uri nai, na furo nai ka sigi naa faasi kera tiifau. ");
INSERT INTO bvd_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sui ta tii wane 'ani kera nia suana nonina nai dodoloa diana naa, nia ka oli mai ka akwa baita 'ana tango lana God. ");
INSERT INTO bvd_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ma nia ka 'asi nia ka tio fafo maana lao saegano 'i maa 'aena sa Disas ka tango nia. Nia wane 'i Samaria lau gwana, nao lau wane Diu. ");
INSERT INTO bvd_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Sui sa Disas ka bae 'urii, “Kamolu tii akwala fono bae nau ku gura kamolu. Ma ta sikwa waa lau da nii fai? ");
INSERT INTO bvd_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nau nao kwasi suana ta wane 'ani kera si oli na mai uri tango lana God. Taifilia wane Samaria nee lau gwana ne nia oli mai ka tangoa God nee!” ");
INSERT INTO bvd_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Sa Disas ka bae 'urii fuana, “Tatae, oli 'oko lea 'amua. God nia gura 'oe naa suli 'oe manata mamana.” ");
INSERT INTO bvd_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Si kada Faarisii ki da ledia sa Disas uria si kada tee God kai 'inito fua toaa nia ki ai, nia luu kera ka 'urii, “Si kada God nia kai 'inito fua toaa nia ki, nao gu tai fafaataia uri ka faatai gu uri molu ka lio filoa ai. ");
INSERT INTO bvd_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma ta waa boroi nao si bae gu 'urii, ‘Liotoi 'amolu 'initoaa bae God gu ne!’ Ma nao ka 'urii, ‘Nia gu loko!’ Sulia 'initoaa God 'e nii gu 'ana 'i matangamolu.” ");
INSERT INTO bvd_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sui sa Disas ka bae 'urii fuana waa kwairooi nia ki, “Si kada nau kui oli mai, kamolu molu kai dooria sua lana fa dani nau, 'Alakwa nia Wane, ma sui boroi nia kai 'afitai fuamolu uri suai lae. ");
INSERT INTO bvd_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ma toae ki kera kai bae 'urii fuamolu, ‘Liotoi fasi, Kraes bae gu loko 'e nii lobaa!’ Ma nao daka 'urii, ‘Liotoi fasi, nia ne nii gu 'ana nee!’ Kera daka ade boroi 'ada 'uri nai, kamolu nao molu si roo suli kera uria nani kwailiu lae. ");
INSERT INTO bvd_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sulia dao laku mai, 'Alakwa nia Wane, 'afitai ka agwa kaaroa lau ma kai mala 'ana kwakwange binamaaru ma folaa lana ka 'etea lofona mamangaa loo, ma toae ki daka suai sui gu 'ada. ");
INSERT INTO bvd_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ma sui ta, 'i nao sui fatai doo nai kafi fuli, nau kwai nonifii fasi, ma toaa nee 'i tari'ina kera dai susubutai nau fasi 'ada. ");
INSERT INTO bvd_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Si kada nau kui oli mai ai, nia kai 'uria lau guu si kada bae sa Noa. ");
INSERT INTO bvd_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Si kada bae sa Noa, na toae ki sui gu 'ana kera roo 'ada 'ana fanga lae ma kuu lae, 'afee ma araie lelea ka dao guu 'afa dani sa Noa 'e raa lao faka bae, ma kafo bae ka fungu ka olo faafi kera daka funu tiifau. ");
INSERT INTO bvd_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nia kai 'uria lau guu si kada bae sa Lot. Si kada bae sa Lot, na toae ki sui gu 'ana kera roo lau guu 'ana fanga lae ma kuu lae, daka folia doo ki ma daka foli 'ana doo kera ki, daka fasi doo, daka saungai ma daka tole luma. ");
INSERT INTO bvd_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ma sui, fa dani sa Lot 'e faasia fera 'i Sodom, na era bae fai erafau 'a'ako bae ka 'asia faasia 'i langi ka sarufi kera daka funu tiifau. ");
INSERT INTO bvd_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Talafana lau guu si doo kai fuli 'afa dani nau kui oli mai kui dao faatai ai nai. ");
INSERT INTO bvd_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ma 'afa dani nai si doo nai ki fuli, waa ne too mai 'i maa, nao si oli lau mai luma uri ngali lana 'okodoo nia. Ma waa ne nii mai maa ole, nao si oli lau mai fera uri 'okodoo nia. ");
INSERT INTO bvd_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Manata toi fasi doo bae fuli 'ana 'afe bae sa Lot. ");
INSERT INTO bvd_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Waa ne sasi ngangata uri dau ngasi lae 'ana mauria nia lao molaagali, nia kai mae. Aia, ma waa ne lukatainia kau mauria nia lao molaagali, nia kai mauri. ");
INSERT INTO bvd_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nau ku faarongo kamolu, 'afa rodo nai nau kui dao ai, lea ta roo waa keeru tio 'ana tii ifitai, ta waa nau kui ngalia, ta ruana waa ka ore naa. ");
INSERT INTO bvd_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Ma lea ta roo wela keni keeru ka raodoo kwaimani, ta ai nau kui ngalia, ta ai ka ore naa.” ");
INSERT INTO bvd_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ma 'i seeri, waa kwairooi sa Disas ki daka ledia daka 'urii, “Wala Aofia 'ae, doo nai ki lea doo daka fuli gu 'i fai nai?” Sa Disas luu kera ka 'urii, “Dao laku mai nia 'afitai ka agwa fasi toae ki sui. Nia kai mala gu doo mae ne lea tio 'afitai ka agwa. Sulia, lea na 'asungaa ki da koni 'ana kule tama doo mae ne nii seeri.” ");
INSERT INTO bvd_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Sa Disas nia unu sulia tii tarifulaa fuana waa kwairooi nia ki, uri ka faatainia siada kera ka foa firi ma nao dasi lukasia. ");
INSERT INTO bvd_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nia ka bae 'urii, “Totoo tii si kada waa nai fua kwae lana kwautoa ki ka too 'ana lao maefera baita nai. Nia ka nao si faabaitaa gu God, ma ka nao si sae'inito guu 'ana ta waa 'ana molaagali. ");
INSERT INTO bvd_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ma tii gwa ai 'oru 'i lao maefera baita nai, ka 'aekwale nia mai sulia kudu uri radi'ae lana lae ma ka bae 'urii fuana, ‘Nau ku dooria 'oko 'olosia doo nau ki ne malimae nau 'e kaubarea.’ ");
INSERT INTO bvd_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tasi kada tau ne gwa 'oru nai too kai ili 'uri nai sulia, ma sui boroi waa nai ka nao si ala gu faafia ili lana si doo nai. Sui boroi 'ana lelea kau waa nai ka manata lau 'urii 'i tala'ana, ‘Nau, sui boroi 'ana nao kusi faabaitaa God fai kusi sae'inito 'ana waa 'ana molaagali, ");
INSERT INTO bvd_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nau kui 'olosia fasi kwautoa nee fua gwa ai 'oru nee wala, sulia nia 'aekwale nau 'asia na mai sulia kudu ne!’” ");
INSERT INTO bvd_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Aia, sa Disas na Aofia ka bae 'urii, “Molu rongo fasi 'amolu si doo nai waa ni kwae lana kwautoa nai saea nai, boroi 'ana nia waa ade lana ta'aa gu 'ana. ");
INSERT INTO bvd_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Waa nai ka noni'ela boroi lelea oli ka kwaea guu kwautoa nai fuana gwa ai 'oru nai, sulia nia nao si luka 'ana radi lae kalia. Aia ma God, nia kai ilia guu si doo ne toaa fifilia nia ki da angisia siana 'afa sato ma fa rodo, 'afitai ka nao. God 'afitai ka dora lau mai uria ili lana si doo ne 'o'olo fuada! ");
INSERT INTO bvd_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nau ku faarongo kamolu, God kai 'ali'ali 'ua guu uri ili lana si doo ne 'o'olo fuada. Ma sui ta, kada nau 'Alakwa nia Wane, kwai oli mai kwai dao lau lao molaagali, alamia nau kwai suana toaa 'oro ki kera kai faamamane nau, ma nao ka nao guu?” ");
INSERT INTO bvd_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Sa Disas ka unu lau sulia si tarifulaa 'urii fuana toaa da fiitoda ki tala'ada ma daka sae 'o'olo lada 'i tala'ada ma daka mamagutainia toae ki. Nia ka 'urii, ");
INSERT INTO bvd_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Totoo, tii roo waa nai ki daru ka lea 'adarua uri foa lae 'i lao Beukaua loo. Ta waa na Faarisii, ma ta ruana waa nia waa fua koni lana malefo 'ana takisi. ");
INSERT INTO bvd_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Aia, na Faarisii nai nia lea kau dao uu ka foa 'ana taifilia ka bae 'urii, ‘God 'ae, nau ku tango 'oe nau waa nao kusi mala 'ana tai waa ne, ne da beli daka ooe ma daka ilia doo ta'aa 'oro ki, ma daka kaubarea 'afee ma araie. Nau nao kusi mala 'ana waa ta'aa loko ni koni lana malefo 'ana takisi. ");
INSERT INTO bvd_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nau waa ku abufanga 'ana roo fa dani lao fa wiiki ki sui gu ne, ma ku falea tangafulu nau fuamu ta kada si nao guu.’ ");
INSERT INTO bvd_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Aia, ma waa ni koni lana malefo 'ana takisi nai, nia dao ka uu tau gu 'ana kau ka nao si lio 'alaa gu uri salo ka noni susuala ka gwautoli gu 'ana. Ma nia ka faatainia na oli kukuru laa nia, 'e fida 'i maa ruruuna ka bae 'urii, ‘God 'ae, manatai nau mai waa ku abulo ta'aa 'urii!’” ");
INSERT INTO bvd_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Sui, sa Disas ka bae na 'urii, “Nau ku faarongo kamolu, waa abulo ta'aa nai 'ana ne God 'olosi nia ma koso ka lea na mai 'ana 'i luma kera, ma Faarisii nai ka nao guu. Sulia waa ne tafo nia tala'ana 'i langi God kai kosolangainia saegano, ma waa ne kosolangainia tala'ana 'i saegano, God kai tafo nia 'i langi.” ");
INSERT INTO bvd_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tai toaa ki da ngalia mai kaala wela tu'uu ki siana sa Disas, uri ka samo toda ma ka falea dianaa fuada. Sui ma kada waa kwairooi nia ki kera suada, daka ngatafi kera. ");
INSERT INTO bvd_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ma sui boroi 'ana sa Disas 'e 'ailia mai kaala wela nai ki siana, ka bae 'urii fuana waa kwairooi nia ki, “Alu kaala wela tu'uu neki kera da lea 'ada mai siaku, nao kamolu si suusi kera lau. Sulia 'initoaa God doo nia 'ana waa ne manata mamana 'ani nau ilingia wela tu'uu ki. ");
INSERT INTO bvd_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nau ku faarongo kamolu, waa ne nao si faamamane nau mala wela tu'uu, nia 'afitai 'asia naa God ka 'inito 'ana mauria nia.” ");
INSERT INTO bvd_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tii waa gwaungai 'ana Diu ki, nia ledia sa Disas ka bae 'urii, “Waa diana ni toolangaidoo 'ae, si tee diana gu ne nau kui ilia uria ku too 'aku 'ana mauria firi?” ");
INSERT INTO bvd_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Sa Disas luua ka 'urii, “Tee ne adea 'oko saea nau waa diana? Taifilia God naa ne diana, nao lau ta waa. ");
INSERT INTO bvd_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","'Oe 'o saitomana gu 'amu si baea fifii nia God bae nia 'urii, ‘Nao 'osi sauwane, ka nao 'osi kaubarea araie ma 'afee, ka nao 'osi beli, ka nao 'osi suke faafi ta waa, ma 'oko sae'inito 'ana maa 'oe fai gaa 'oe.’” ");
INSERT INTO bvd_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Waa nai luua ka bae 'urii, “Nau, 'ita 'ua mai 'ana kada ku tu'uu, nau ku ade mai sulia taki nai ki tiifau lelea ka dao 'i tari'ina.” ");
INSERT INTO bvd_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ma kada sa Disas rongoa nia ka bae 'urii fuana, “'Uri nai, tii si doo ne nao 'osi ilia 'ua. 'O lea kau 'oko foli 'ana 'okodoo 'oe ki tiifau, sui 'oko ngalia malefo ne 'oe todaa ai 'oko falea fuana toaa siofaa ki uri 'oko too 'amu 'ana suadooa lao fera 'i salo. Sui 'oko lea na mai buriku.” ");
INSERT INTO bvd_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kada waa nai 'e rongoa si baea nai, na liona ka kii 'asia naa, sulia nia waa suadoo baita. ");
INSERT INTO bvd_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ma kada sa Disas suana waa nai liona kii, nia ka bae 'urii, “Nia 'afitai tasa fuana waa suadoo baita ki daka ruu lao 'initoaa God. ");
INSERT INTO bvd_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nia 'afitai tasa fuana waa suadoo ka ruu lao 'initoaa God. 'E 'afitai ka talua lau lea sae kamel ka sasi uri ruu lae 'ana malesufua maana 'ogile.” ");
INSERT INTO bvd_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Toaa nai da rongoa si baea nai, daka 'urii, “Nia 'afitai naa nai, uri ta waa ka todaa mauria firi!” ");
INSERT INTO bvd_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ma sui sa Disas luu kera ka 'urii, “Doo ne 'afitai tasa naa fuana waa 'ana molaagali ka ilia, nia walude gu 'ana fua God ka ilia.” ");
INSERT INTO bvd_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ma sa Bita ka bae 'urii fuana sa Disas, “Kameli, meli lukasia naa suadooa kameli ki tiifau uri meli ka lea na 'ameli burimu!” ");
INSERT INTO bvd_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Sa Disas ka bae 'urii, “Iuka. Nau ku faarongo kamolu, waa ne lukasia luma nia, ma 'afe nia, ma toaa nia, ma maa nia ma gaa nia, ma wela nia ki, 'aengana 'initoaa God, ");
INSERT INTO bvd_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","waa nai kai too 'ana doo 'oro diana lau kada nia too lao molaagali nee, ma 'ana mauria firi 'i lao tooa falu ne nii 'ua mai.” ");
INSERT INTO bvd_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ma kada sa Disas nia lea fainia waa kwairooi nia ki taifili kera, nia ka bae 'urii fuada, “Kolu lea kau 'i Durusalem uri kera ka ilia si doo baki na brofet kada 'i nao ki da kedaa mai suli nau, na 'Alakwa nia Wane, ka fuli naa nai. ");
INSERT INTO bvd_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bae, kera kai fale nau 'i 'abana toaa nao lau Diu ki, uri kera ka 'onionga 'ani nau, daka bae ta'aa fuaku, ma daka faa 'ide nau, ma daka ngisufi nau. Ma daka kwae nau, ma daka saumaeli nau naa. ");
INSERT INTO bvd_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ma lao oluna fa sato, nau kui mauri lau.” ");
INSERT INTO bvd_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ka 'uri nai boroi, waa kwairooi ki nao kera dasi filoa guu doo nai sa Disas saea fuada nai, sulia manata lada 'e sadi ka nao dasi saitomana. ");
INSERT INTO bvd_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Si kada sa Disas lea kau ka dao karangia maefera 'i Diorikoo, tii waa maana rodo nai 'e gooru 'i ninimana taala nai uria gani doo lae 'ana toae ki. ");
INSERT INTO bvd_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ma 'ana kada nai guu nia ka rongoa konia nai 'e liu, nia ka ledi kau 'urii, “Na tee ne 'uri nai?” ");
INSERT INTO bvd_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kera luua daka bae 'urii, “Sa Disas waa bae fasi maefera 'i Naasaret ne tasa ka liu naa nee.” ");
INSERT INTO bvd_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ma waa maarodo nai ka 'ai na kau 'urii, “Wala Disas, 'oe waa bae fuli sa Defet naa na, 'o manatai nau mai!” ");
INSERT INTO bvd_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","'I seeri toaa nai da eta mai nao daka ngatafia naa uri nia ka too aroaro 'ana. Ma sui boroi nia fua kafi kokoo baita fatai nai, ma ka bae 'urii, “'Oe waa bae fuli sa Defet naa na, 'o manata toi nau mai!” ");
INSERT INTO bvd_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ma sa Disas ka uu ngado 'i seeri ka saea fuada lea daka talaia mai siana. Kada nia lea mai ka dao karangi naa, sa Disas ka ledi 'urii 'ani nia, ");
INSERT INTO bvd_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nee, tee ne 'oe dooria nau kui ilia fuamu?” Ma waa maarodo nai ka bae 'urii, “Aofia 'ae, nau ku dooria maaku ka 'ifi uri ku lilio ne.” ");
INSERT INTO bvd_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Sa Disas ka bae 'urii fuana, “'Oe lilio 'amu wala, sulia ne 'oe faamamane nau.” ");
INSERT INTO bvd_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tona 'i seeri, sa wala nai maana ka 'ifi ka lilio naa. Ma nia ka lea kwaimani naa fainia sa Disas, ka tangoa naa God. Ma konia nai boroi daka tangoa lau guu God kada kera suana doo nai fuli. ");
INSERT INTO bvd_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Sa Disas nia dao lao maefera 'i Diorikoo, ma kai tasa lau gu 'ana. ");
INSERT INTO bvd_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ma tii waa satana sa Sakias ta waa baita lau guu 'ana toa ni koni lana malefo 'ana takisi 'e nii seeri, ne nia ta waa suadoo lau guu. ");
INSERT INTO bvd_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nia 'e dooria ka suana 'ana sa Disas, ma sui ka 'afitai sulia nia waa kukuru 'asia naa ma konia baita nai ka suusi nia. ");
INSERT INTO bvd_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ma nia ka lae 'ali'ali naa 'i nao 'ana konia nai, lae ka raa sulia 'ai nai da 'ailia 'ana Sikamoo, uria ka suana 'ana sa Disas sulia nia kai liu kau sulia taala nai. ");
INSERT INTO bvd_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kada sa Disas lea kau ka liu seeri, nia lio 'alaa kau ka suana sa Sakias, ka bae 'urii fuana, “Wala Sakias, koso 'ali'ali mai, sulia 'i tari'ina nau kwai dao 'i luma kamu.” ");
INSERT INTO bvd_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sa Sakias ka ele 'asia naa, ka koso 'ali'ali na mai. Nia ka talaia sa Disas ka lea naa uria 'i luma kera. ");
INSERT INTO bvd_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Na toaa nai tiifau da suana si doo nai, daka bae buri 'ani nia daka 'urii, “Sa Disas lea naa uria too kwaimani lae fainia waa abulo ta'aa bae nai rowaa.” ");
INSERT INTO bvd_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Aia, sa Sakias nia tatae ka bae 'urii fuana sa Disas na Aofia, “Aofia 'ae, nau gu ne kwai falea naku ta bali 'ana suadooa nau fuana toaa siofaa ki. Ma lea sae nau ku kwaalia waa ki daka faledoo 'aku ka talua naa kula kai dao ai, nau kwai duua doo kera ki ka dao 'ana fai fa 'idu laa 'i fafona liu lana si doo kera ki.” ");
INSERT INTO bvd_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ma sa Disas ka bae 'urii fuana, “'I tari'ina naa ne God kai faamauria toaa 'oe nee 'i luma 'oe, sulia kera da faamamanea God mala bae kokoo kia sa 'Abraham nia ilia kada 'i nao. ");
INSERT INTO bvd_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nau, na 'Alakwa nia Wane, ku lea mai uria nani lae uria ma faamauri lana toaa ne kera nao'ada.” ");
INSERT INTO bvd_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Na konia baita nai da rongoa sui naa doo neki sa Disas bae mai sulia. 'I seeri nia ka unu sulia tii si tarifulaa 'ana kada kera dao karangia naa 'i Durusalem. Nia unu sulia si tarifulaa nai uria ka 'olosia si manata laa kera too ai, ne kera kwaifii 'ada sae sa 'initoaa nia God kai sakatafa faatai gu 'ana 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","'Uri nai, nia ka bae 'urii fuada, “Totoo tii waa 'initoa ka lea uria fera tau nai uria daka falea mai 'initoae fuana ma nia oli mai ka 'inito fua fera nia. ");
INSERT INTO bvd_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ma sui fatai nia kafi lea, nia 'ailia mai tii akwala waa daka lea mai siana. Nia ka falea malefo ki fuada ka bae 'urii, ‘Molu ka rao 'ana malefo neki, uri molu ka todaa lau gu mai tai malefo faafida molu ka rao 'amolu 'uri nai lelea nau oli mai ku dao.’ ");
INSERT INTO bvd_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ma sui toa nia waa 'inito nai, daka rakesasu 'ani nia, daka odua tii waa ka lea 'i burina uri faarongo lana ai, ma daka saea kera da ote kera 'ana waa nai kai 'inito fuada. ");
INSERT INTO bvd_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Aia, ka 'uri nai boroi 'ana, waa 'inito nai kera falea na mai 'initoaa fuana nia ka oli na mai uri 'inito lae fuada. Kada nia oli mai ka dao, nia ka kwaiodui naa uria toa bae nia falea malefo ki fuada uri rao lae ai uri ka lio filoa ta fita si malefo ki lau ne kera todaa 'i maana malefo baki nia faa fuada. ");
INSERT INTO bvd_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Na waa rao totolenao 'e lea mai dao ka bae 'urii, ‘Waa baita kani 'ae, nau ku rao 'ana malefo bae 'oe faa fuaku, ta tii taafuli malefo ne ku todaa lau mai gwauna.’ ");
INSERT INTO bvd_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Waa 'inito nai ka bae 'urii fuana, ‘'Oe na waa 'o rao diana nai. Ma fafona ne 'oe mamana 'ana ili lana si doo tu'uu, nau kwai alu 'oe 'oko lio naa sulia taafuli maefere ki nai.’ ");
INSERT INTO bvd_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ruana waa ni rao ka lea lau gu mai dao ka bae 'urii fuana waa 'inito, ‘Waa baita kani, nau ku rao 'ana malefo bae 'oe faa fuaku, ta lima malefo ne ku todaa lau mai maana.’ ");
INSERT INTO bvd_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Waa 'inito nai ka bae 'urii fuana, ‘'Oe, nau kwai alu 'oe 'oko lio naa sulia lima maefere ki nai.’ ");
INSERT INTO bvd_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Sui, oluna waa ni rao ka lea lau gu mai dao ka bae 'urii, ‘Waa baita kani, malefo 'oe bae 'o faa fuaku ne tio diana gu 'ana doo 'oe, bae nau ku 'afulalo ai 'ana 'aba maku ma ku sua diana mai sulia ka tio gu 'ana. ");
INSERT INTO bvd_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Doo ne adea, sulia ku mau lau gu 'aku 'ani 'oe waa susuala. Ne 'oe 'o ilingia waa ne ngalia si doo ne ta waa lau gu 'ana 'e alua, ma ka konia si fanga ne ta waa lau gu 'ana 'e rao talana.’ ");
INSERT INTO bvd_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Waa 'inito nai ka bae 'urii fuana, ‘Waa rao ta'aa ne ni 'oe. Nau kwai falea kwakwaea 'oe faafia si doo ne 'oe 'ua guu tala saea 'amu nai. 'Oe 'o saea ni nau waa susuala, ma 'oko saea ni nau waa ku ngalia si doo ne ta waa lau gu 'ana 'e alua, ma si fanga ne ta waa lau gu 'ana 'e rao talana. ");
INSERT INTO bvd_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nee wala, 'utaa ne kada 'oe manata 'uri nai ma nao 'osi ngalia malefo nau nai 'osi alua 'amu lao banga, uria lelea dao kada nau ku oli mai dao ma nau ku too 'ana tai malefo sarenga 'i maana?’ ");
INSERT INTO bvd_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","'Uri maana si ade laa nai, waa 'inito nai ka bae na 'urii fuana waa nai ki da uu 'i seeri, ‘Molu ngalia malefo loko faasi nia, molu ka faa 'amolu fuana waa loko kau 'e too 'ana taafuli malefo loko ki.’ ");
INSERT INTO bvd_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kera ka bae 'urii, ‘Waa baita kani 'ae, ma sui nia loko 'e too naa 'ana taafuli malefo ki.’ ");
INSERT INTO bvd_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nia ka bae 'urii, ‘Nau ku faarongo kamolu, waa ne rao noni maabe ka too 'ana doe, kera kai fale fafonaa lau si doo ne nia too ai fuana. Ma waa noni'ela ne nao si too 'ana tasi doo, lea sae ta doo diana ne nia ka too boroi ai, kera kai ngalia faasi nia. ");
INSERT INTO bvd_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aia, si doo fuana toa malimae nau baki bae kera ote kera 'ani nau uri 'inito lae fuada, kamolu talaida mai seki molu ka saungida nau ku tala lio mae lada guu.’” ");
INSERT INTO bvd_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Burina sa Disas bae 'uri nai ka sui, nia ka eta na 'i nao 'ani kera uria 'i Durusalem. ");
INSERT INTO bvd_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ma kada nia dao karangia si maetoaa 'i Betfeis fainia 'i Betanii karangia kafa uo nai 'i 'Olif, nia ka odua ta roo waa 'ana waa ni kwairooi nia ki uria daka lea kau 'i nao. Nia ka bae 'urii fuadaru, ");
INSERT INTO bvd_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Kamuru lae fasi kau 'i nao 'ana maefera loko. Kada kamuru dao maa taale ai, kamuru kai suana tii dongki ne kera kania ka uu gu 'ana 'i seeri, ne nao si ngalia 'ua gu mai ta waa 'i fafona. Muru lukea 'oko faasia sui, muru ka talaia mai 'i seeki. ");
INSERT INTO bvd_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ma lea ta waa ka ledi kamuru ma ka 'urii, ‘Tee ne muru lukea dongki nee uria?’ Muru ka bae 'urii fuana, ‘Na Aofia ne dooria.’” ");
INSERT INTO bvd_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Aia, roo waa nai ki daru ka lea naa, ma keeru ka suana doo ki da fuli ka lea gu sulia doo nai ki sa Disas saea kau fuadaru. ");
INSERT INTO bvd_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kada keeru lukea guu dongki nai, na toaa nai dongki kera nai daka ledi keerua daka bae 'urii, “Tee ne kamuru lukea kale dongki nee uria?” ");
INSERT INTO bvd_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Keerua daru ka bae 'urii, “Na Aofia ne dooria.” ");
INSERT INTO bvd_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Sui keeru ka talaia na mai siana sa Disas. Dao keerua ka alua maku keerua ki fafona dongki nai, sui daru ka tatae nia ka gooru naa 'i fafona. ");
INSERT INTO bvd_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ma kada sa Disas nia lea kau 'ana dongki nai, toae ki daka samatainia maku kera ki sulia taale, nia talau ka lea na 'i fafona. ");
INSERT INTO bvd_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ma kada nia dao karangia 'i Durusalem 'ana kula ne taala nai koso toli kau uria fa uo 'i 'Olif, na konia baita nai 'ana toaa kwairooi nia ki kera safali daka suungi naa 'ana tango lana God fuana doo kwaibalatana neki kera suana nia ilia ki mai. ");
INSERT INTO bvd_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ma daka bae na 'urii, “'E diana tasa fuana Waa 'inito ne God 'ua guu tala fale nia mai nee! Na aroaroa 'i malutaka fainia God. Kolu ka bae tangoa 'akolu God kolu loo, ne nia 'e talua doo ki sui!” ");
INSERT INTO bvd_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ma tai Faarisii daka nii lau guu 'i seeri, kera ka bae 'urii fuana sa Disas, “Waa toolangaidoo 'ae, saea fuana waa kwairooi 'oe nena ki, kera taaro 'ada wala.” ");
INSERT INTO bvd_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ma sa Disas 'e luu kera ka 'urii, “Nau ku saea fuamolu, lea sa kera taaro 'ada, na fau neki gu ne kera dai suungi 'ana tango lana God.” ");
INSERT INTO bvd_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kada sa Disas nia dao karangia naa 'i Durusalem, nia lio kau 'e suana maefere baita loo, angia ka durufi nia naa, sulia liona 'e dila fuana toaa loo 'i lao fera loo. ");
INSERT INTO bvd_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Nia ka bae lau guu ka 'urii, “Kamolu nee, lea sae molu ka lio filoa mone 'amolu 'i tari'ina, si doo ne kai talaia waa uri lelea ka too 'ana aroaroe, ka diana ne. Ma sui ka nao, ne kamolu maa molu rorodoa ka nao molu si suai naa nee. ");
INSERT INTO bvd_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Si kada ne karangi kai dao na mai nee, si kada naa fuana malimae kamolu ki uri dao kera ka alasia naa fera nee ne, ma kera kai suusi kamolu 'afitai molu ka ruu na 'i maa. ");
INSERT INTO bvd_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ma kera kai taga 'ana fera kamolu ma toaa 'i laona ki tiifau. Kai tagabola ta tii si fau boroi si too naa fafona ruana si doo 'ana fera kamolu nee. Kera kai saketoa toaa kamolu ki, sulia kamolu ulafusia 'amolu dao lana mai God siamolu fuana faamauri lamolu.” ");
INSERT INTO bvd_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kada sa Disas nia ruu kau lao Beukaua bae, nia ka taria toaa kera usi ki laona. ");
INSERT INTO bvd_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ma nia ka bae 'urii fuada, “Si baea God ne kera kedaa 'uana mai lao buka abu, nia bae 'urii, ‘Na beu nau nee, na beu ni ofu ne.’ Ma sui kamolu ka rokisia oli molu ka alua 'amolu 'ana beu kera toaa ni beli ki.” ");
INSERT INTO bvd_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ma 'afa dani ki sui gu 'ana, sa Disas nia toolangaidoo 'i lao Beukaua nai. Ma toa baita ni foa ki, ma toa toolangaidoo 'ana taki ki, ma tai toa gwaungai ki lau fuana toaa Diu ki, daka sasi uria saungi lana sa Disas ka mae 'ana. ");
INSERT INTO bvd_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ma sui ka 'afitai uri ili lana tasi doo 'ani nia, sulia toae ki da roo 'ani nia sulia fa dani ki sui guu 'ana uria fafurongo lana toolangaidoo laa nia. ");
INSERT INTO bvd_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tii fa dani, sa Disas nia toolangaidoo fua toae ki 'i lao Beukaua bae, ma nia ka faarongo kera 'ana si faarongoa diana bae. Na waa baita ni foa ki, ma toa toolangaidoo 'ana taki ki, ma tai toa gwaungai ki lau guu, kera da lea mai siana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ma daka ledi 'urii 'ani nia, “'Oe na suukwaia tee ne 'o too ai ma 'oko ilia doo neki nee wala? Sa tii gu ne faa suukwaia nai fuamu?” ");
INSERT INTO bvd_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nia luu kera ka bae 'urii, “Aia, nau ku ledi kamolu fasi uria tii si doo. ");
INSERT INTO bvd_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Kamolu saea fasi mai, na rigitaa bae sa Dion too ai uri faasiuabu lae nia lea mai fasi God, ma nao fasi wane gwana?” ");
INSERT INTO bvd_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kera oli da ledi kera kwailiu 'i tala'ada daka 'urii, “Toa nee 'ae, tee gu ne tara kolu kai saea fuana nai? Lea sa kolu luu nia kolu ka saea, ‘'E lea mai faasia God,’ nia ka 'urii nai, ‘Sui tee ne adea nao molu si faamamanea sa Dion?’ ");
INSERT INTO bvd_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma lea sae kolu ka luu nia ma kolu ka 'urii 'akolu, ‘Nia lea gu 'ana mai faasia wane 'ana molaagali bae,’ ma tara toaa neki ne kera kai 'uifau kolu uri saumaeli lakolu naa, suli kera da faamamanea sa Dion na brofet lau gu bae.” ");
INSERT INTO bvd_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","'Uri nai guu, kera luua sa Disas daka saea nada kera ulafusia tii ne suukwaia nai lea mai faasia. ");
INSERT INTO bvd_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ma Disas ka bae na 'ana 'urii fuada, “Nau boroi tara nao kusi faarongo kamolu lau guu, tii ne falea suukwaia ne ku too ai ma ku ilidoo ki ai nee.” ");
INSERT INTO bvd_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Sui, sa Disas ka unu sulia tii si tarifulaa lau fuada ka 'urii, “Totoo tii si kada, tii waa nai ka fasia ola greib nia nai sui ka alua 'i 'abana waa ki daka suasulia. Nia ka lea 'ana maefera 'e nii tau mai. Nia kai too mai seeri ka tau sui fatai oli mai kafi dao. ");
INSERT INTO bvd_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nia too mai lelea dao guu 'ana kada ola nai 'e maua ai, nia ka odua na mai tii waa ni rao nia ka lea na mai uria ngali lana tai fuae greib 'ana doo nia nai ki lao ola nia. Ma sui kada waa ni rao nai 'e dao gu lao ola nai, na toa ni rao nai ki da suasulia ola nai daka saungi nia naa lelea sui daka olitainia ka oli tatakwai naa siana waa baita nia nai. ");
INSERT INTO bvd_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Waa baita nai ka odua lau gu mai ta ruana waa ni rao. Sui boroi 'ana toa ni rao nai ki da suasulia ola nai, daka saungia lau guu, ma daka faa 'ide nia, sui daka olitainia ka oli tatakwai lau guu. ");
INSERT INTO bvd_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","'I seeri, waa baita nai ka odua lau gu mai oluna waa ni rao nia. Ma sui boroi 'ana toa nai ki daka saumaala 'ani nia, sui daka tari nia naa uri sara fasi lao ola nai. ");
INSERT INTO bvd_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Na waa baita nai ka manata na 'urii, ‘Nia sae tee ne kui ilia lau rowaa? 'O ma nau 'ua ne kui odua naa 'alakwa nau 'ua guu, na wela liosaua nau nee uria nia guu ka tala lea ka dao. Nia 'uri nai naa 'oto taari kera ka manata 'initoa 'ani nia?’ ");
INSERT INTO bvd_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kada toa ni rao bae da suasulia ola bae kera suana gu ta, da bae fatai 'urii fuada kwailiu na, ‘Na 'alakwa nia sa wala bae mone ne. Wela nee naa bae bobongi maa nia kai faa ola nee kai tio 'i 'abana. Kolu saungia 'e mae 'ana wala, uri kolu ka ngalia 'akolu ola nee fua kolu!’ ");
INSERT INTO bvd_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Seeri, kera liu guu daka taria naa wela bae lelea daka saungia ka mae na kau 'i sara fasi lao ola bae.” Sa Disas ka ledi gu 'urii 'ani kera, ");
INSERT INTO bvd_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Tee nai waa baita nai 'ana ola nai kai ilia 'ana toa nai? Kada nia oli mai ka dao, nia kai saungi tiifau 'ani kera, sui ka faa ola nai kai tio na 'ana 'i 'abana toa 'e'ete ki lau.” Kada toaa nai ki da rongoa bae lana nai sa Disas, kera daka 'urii naa, “Si doo nai 'e too 'ana fasi fuli lae!” ");
INSERT INTO bvd_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Sui sa Disas 'e bubu tetee ada ka bae 'urii, “Lea si doo nai 'e nao si fuli, sui ma tee 'ana ne toolangai lana si baea bae lao kekeda laa Abu bae nia 'urii, ‘Na maefau ne waa saungai luma ki da noni'ela 'ada ai, nia 'ana ne maefau 'initoe talua maefau ki sui guu, uria boongi lana lume.’ ");
INSERT INTO bvd_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Waa ne 'asi nia fafona maefau nai, waa nai kai maga ka baringisi guu. Ma waa ne maefau nai kai 'asia faafia, maefau nai kai too meme nia.” ");
INSERT INTO bvd_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kada nia bae 'urii nai guu, waa baita ni foa lae ki fainia waa toolangaidoo lae 'ana taki ki, daka lio saitomana naa ne sa Disas kai bae gwana suli kera. Kera ka dooria naa dau lana sa Disas 'i seeri, sui ma daka mau lau gu 'ada 'ana toaa nai. ");
INSERT INTO bvd_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Toa gwaungai ki daka bubu na sulia sa Disas uria sae lelea daka daua. Ma daka folia naa waa ki uri uuarongai lana ma ledi lana lae uri suke lana ki uri lelea sae nia ka saea tasi doo ni dau lana faafia uri kera ka fale nia kau 'i 'abana waa 'inito 'i Rom ne lio sulia bali lolofaa nai. ");
INSERT INTO bvd_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kera ka bae 'urii fuana sa Disas, “Wala waa toolangaidoo 'ae, kameli saitomana ni 'oe naa ne 'o toolangaidoo 'oko saea sui guu doo mamane ki. Ma ni 'oe naa ne nao 'osi 'ado guu fainia waa ki 'ana ta tii bali gwana 'ana manata lada ki. 'Oe, na toolangaidoo laa 'oe lea 'o'olo 'ua guu sulia mamanaa ma kwaidooria God fuana toae ki sui. ");
INSERT INTO bvd_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","“Aia, 'oe saea fasi mai fuameli, nia 'o'olo gu 'ana fua kameli ka fale takisi fuana 'initoaa nee 'i Rom, ma nao 'e garo?” ");
INSERT INTO bvd_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ma sa Disas ka lio filoa gu 'ana sukea kera nai, nia ka bae 'urii, ");
INSERT INTO bvd_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Faatainia fasi mai tafa seleni 'ana doo nai molu too ai fuaku ku suai fasi.” Kera ka ngalia na mai tii fa seleni fuana, sui nia ka ledi 'urii 'ani kera, “Aia, nununa sa tii ne nii 'afa seleni nee? Fai, satana sa tii ne nii ai nee?” Kera luu nia daka 'urii, “Nununa waa baita loko 'i Rom naa na.” ");
INSERT INTO bvd_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ma sa Disas ka bae 'urii fuada, “Nia 'uri nai, kamolu ngali si doo ne naisata 'ana waa baita 'i Rom molu ka faa 'amolu fuana, ma si doo God ki ngali molu ka faa 'amolu fuana God.” ");
INSERT INTO bvd_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","'Uri nai guu ka 'afitai naa fuada uri dao toi lae tasi doo ne kera kai dau nia faafia 'i maana konia nai. Ma kera ka kwele 'asia naa 'ana si baea nai ki sa Disas olisi kera ki ai, daka taaro dasi bae. ");
INSERT INTO bvd_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sui lau guu, tai Sadiusii ki kera daka lea lau gu mai siana sa Disas. Kera Sadiusii ki nao dasi faamamanea waa ne mae naa, kai tatae lau faasia maea. Kera ledia sa Disas daka bae 'urii, ");
INSERT INTO bvd_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Wala waa toolangaidoo 'ae, sa Mosis si baea nia kedaa mai fuameli 'e bae 'urii, ‘Lea waa 'e mae faasia 'afe nia sui ma keeru ka nao si welaa guu, ta wane 'ana toolana ki ka adea 'initai 'oru nai, uri ka saarea tai wela uri ka didi fulina toolana nai 'e mae.’ ");
INSERT INTO bvd_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Aia, ma tii bara waisaasina ne kera 'ada fiu waa ki, kera totoo gu 'i see. Na waa 'i nao 'e adea tii wela keni nai ka nao si welaa guu, nia ka mae. ");
INSERT INTO bvd_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","“Saasina, waa 'i burina ka adea naa gwa 'oru nai, ma sui ka nao daru si welaa guu sa wala nai ka mae lau guu faasia wela keni nai. ");
INSERT INTO bvd_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Sui saasina lau guu, oluna waa naa ka 'uri nai lau guu, ka mae lau guu. Ka alu gu 'ana tii si doo nai ka lea na suli kera lelea fiu waisaasina nai ki daka mamae ka sui guu faasia wela keni nai ka nao dasi welaa sui guu. ");
INSERT INTO bvd_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Burina fiu waisaasina nai ki da mae tiifau naa, wela keni nai boroi nia ka mae naa. ");
INSERT INTO bvd_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ma sui sae nia 'uri nai, lelea 'e dao 'afa dani bae God kai tataea toaa mae ki tiifau faasia maea, na 'initai nai nia 'afe waa tee gu 'ana bara waisaasina bae nai? Sulia kera fiu waisaasina nai ki sui guu bae da adea wela keni nai.” ");
INSERT INTO bvd_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Sa Disas ka luu kera ka bae 'urii, “'I tari'ina ki 'ana ne wela wane ki ma wela keni ki da arai ma daka 'afe ki ai nee. ");
INSERT INTO bvd_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ma si kada ne nii 'ua mai, na toaa ne kera mae ma sui daka tatae lau faasia maea, kera 'afitai daka arai ma daka 'afe lau, ");
INSERT INTO bvd_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","suli da mala nada 'ensel nia ki God ne nao dasi mae naa. Kera na wela nia ki God naa, suli God nia tatae kera faasia maea. ");
INSERT INTO bvd_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Aia, ma si malutaa nee sulia toaa da mae ki naa totoo dai mauri lau, nia doo mamane ne. Tee sa Mosis boroi nia faatainia lau guu mamana lana si doo nai bae, kada nia bae ka fuutoi era meakwesu bae 'e suai sulia kaa 'ai tu'uu bae. Nia 'e bae 'urii sulia God bae, ‘God nia sa 'Abraham, ma God nia sa 'Aesak, ma God nia sa Diakab.’ ");
INSERT INTO bvd_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Na toolangai lana 'e 'urii nai: Tai toaa ne da mae ki naa da foosia gwada God, suli kera da mauri naa fai God.” ");
INSERT INTO bvd_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ma tai waa 'ana toa toolangaidoo 'ana taki ki daka bae 'urii, “Waa toolangaidoo 'ae, luu laa nai 'oe luua 'ana si baea nai nia diana 'asia naa nai.” ");
INSERT INTO bvd_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma sui 'e 'uri nai guu, kera ka mau tiifau ta waa ada si leditona kaaroa naa. ");
INSERT INTO bvd_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Sui sa Disas ka ledi 'ana 'urii 'ani kera, “Kamolu saitomana nia bobola gu 'ana fua daka saea na Kraes nee nia futa gu 'ana mai 'isi 'ana kwalafaa sa Defet? ");
INSERT INTO bvd_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Sulia sa Defet, nia tala bae 'ana 'urii lao Sam ki, ‘God nia bae 'urii fua Aofia nau: 'Oe gooru kwaimani 'amu fai nau 'i bali aolo nau, ");
INSERT INTO bvd_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","'oko too 'amu 'uri nai lelea nau ku alua malimae 'oe ki daka too guu farana 'initoaa 'oe.’ ");
INSERT INTO bvd_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Sa Defet nia saea Kraes nee na Aofia nia ne. Ma lea 'uri nai tama na Kraes nee ka futa boroi 'ana mai 'isi 'ana kwalafaa sa Defet, nia na Aofia sa Defet lau gu 'ana ne.” ");
INSERT INTO bvd_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kada toaa nai ki da fafurongo gwada, sa Disas ka bae 'urii fua waa kwairooi nia ki, ");
INSERT INTO bvd_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Molu ka fiia birangaa kera nee toa toolangaidoo nee 'ana taki, ne kera dooria 'asia naa ofi lae 'ana maku liu lana baita ki uri suai lae. Ma daka dooria 'asia naa sae toae ki daka sae'inito 'ani kera 'i maana usie ki. Ma daka dooria 'asia naa gooru lae 'ana kula ni goorua kera waa 'initoe ki 'ua guu lao beu ni ofu lae ki, ma noni fafangae ki. ");
INSERT INTO bvd_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ma sui kera ne daka bebelia 'okona doo gwa 'oru siofaa neki ka atafu naa. Kera daka suke ni abu lae gu 'ada 'ana foa tikwa lae ki. Kera toa nee, na kwakwaea kera kai ta'aa 'isi kai talua kwakwaea toae ki sui guu!” ");
INSERT INTO bvd_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Sa Disas 'e too 'ana ka suana toaa 'oro suadoo nai da lea mai daka fale malefo naa fuana Beukaua loo, ma too daka dangalua na kau falea kera ki fua lao kufidoo nai ni ngali malefo lae. ");
INSERT INTO bvd_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ma nia ka lio kau ka suana naa 'initai 'oru siofaa nai 'e lea mai dao ka faa kau roo kaa miga malefo tu'uu 'isi nai ki. ");
INSERT INTO bvd_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ma sa Disas ka bae 'urii, “Nau ku faarongo mamana 'ani kamolu, na falea nee gwa 'oru siofaa nee nia faa, nia ne baita ka talua sui guu falea neki toaa suadoo nee da faa. ");
INSERT INTO bvd_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sulia toaa suadoo nee, malefo baita ki 'asia naa ne kera too ai ma sui daka faa gu 'ada si kula tu'uu ai. Aia, ma gwa 'oruai siofaa nee, taingaia nia sui naa ne nia faa tiifau nai nee.” ");
INSERT INTO bvd_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sui lau guu, tai waa 'ana waa kwairooi nia sa Disas ki too kera kai tangoa 'ada Beukaua loo, loo kera saungainia 'ana fau diane ki 'asia naa ma daka lalaungia 'ana falea da faa ki mai fua God lelea sua lana ka diana 'asia naa, sa Disas ka faarongo kera. Ka bae 'urii, ");
INSERT INTO bvd_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Si kada ne kai dao mai, maefau diana neki sui guu kamolu suai nee, kera kai atoli tiifau lelea nao ta tii si maefau boroi si tio guu fafona ruana tasi doo!” ");
INSERT INTO bvd_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ma kera daka ledi nia, daka 'urii, “Waa toolangaidoo 'ae, 'i anita gu ne doo nai ki kai fuli nai? Ma fafaataia tee gu ne kai faatainia si kada doo nai ki sui guu dai fuli ai?” ");
INSERT INTO bvd_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Sa Disas ka 'urii, “Molu ka fiia ade ta waa ka talai garo 'ani kamolu. Sulia toaa 'oro kera kai dao mai ne kera kai saea kera 'ana Kraes, ma kera kai bae 'urii, ‘Nau Kraes bae naa ne!’ Ma kera kai bae lau gu 'urii fuamolu, ‘Si kada bae God nia 'olea naa ne dao nai nee!’ Nao molu si ade sulia doo nai ki kera saea. ");
INSERT INTO bvd_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kamolu nao molu si mau lau kada lea molu rongo sulia firua baite ki matangana fera baite ki ma firua baite ki matangana toae fai gwaungaia 'ana fera kera ki, sulia doo nai ki ne kai fuli fasi 'i nao. Sui boroi 'ana doo nai ki daka fuli, na sui lana molaagali 'e nao si dao 'ua ai nai.” ");
INSERT INTO bvd_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ma sa Disas ka faarongoa waa kwairooi nia ki ka 'urii, “Na fera baite ki ma 'initoaa baite ki kera kai alasi kera kwailiu 'ana firue. ");
INSERT INTO bvd_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Na anuanu baite ki lau guu kai 'igia fera ki, na uni fioloa baite ki kai dao mai, ma na unimataia baita tasa ki kai liu 'ana fera ki tiifau. Na doo baita 'e'ete ni maungi lana ki kai fuli, ma na fafaataia baite ki dai suai 'ana mamangaa loo. ");
INSERT INTO bvd_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ma sui fatai ma doo nai ki dafi fuli, kera kai dau kamolu daka ilimatai kamolu. Kera kai talai kamolu fua lao beu ni ofu ki ma naofana toa gwaungai ki uri didi lamolu lae ma alu lamolu 'i lao lookafo, sulia ne molu roo 'ani nau. ");
INSERT INTO bvd_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Si kada ne kera ade 'uri nai 'amolu, nia ka falea naa si kada diane fuamolu uria bae lae sulia si Faarongoa Diana nee siada. ");
INSERT INTO bvd_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ma kamolu si manata 'abarua lau uria ta tee ne molu luu kera ai. ");
INSERT INTO bvd_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Sulia nau kwai fale tiifau naa fuamolu na baea 'ana liotooa, ma nao ta malimae 'amolu ne kai bae suli kamolu, ma nao dasi suusia naa doo neki kamolu saea ki. ");
INSERT INTO bvd_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Na maa kamolu ki, ma gaa kamolu ki, ma na toolamolu ki, ma na wanefuta kamolu ki, ma na ruana kamolu ki, kera kai fale kamolu fuana toaa gwaungai ki. Ma tai waa 'amolu ki kera kai saungida. ");
INSERT INTO bvd_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Na toaa ki tiifau kera kai sualangai kamolu faafi nau. ");
INSERT INTO bvd_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ka 'uri nai boroi 'ana, 'afitai ta tii si ifu tu'uu boroi 'ana gwaumolu si nao 'ana. ");
INSERT INTO bvd_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Molu ka uu ngasi 'ana faamamane laa kamolu ki, ma molu ka mauri firi.” ");
INSERT INTO bvd_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ma sa Disas ka bae lau 'urii fuada, “Kada kamolu suai na waa ni omee ki, kera ala kalia 'i Durusalem, molu ka saitomana kera kai tagalangainia na toaa baita ne. ");
INSERT INTO bvd_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ma 'ana kada nai, waa ne kera too 'i Diudia ki, kera kai tafi tiifau uria gwauna fa uo ki. Ma waa ne kera too mai lao maefera baita ne, kera kai tafi faasia. Ma na waa ne kera too ki mai sara nao kera si oli lau mai uri lao maefera baita ne. ");
INSERT INTO bvd_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sulia kada naa 'ana kwakwaea ne, fasi uri na tee ki bae kera kekeda sulia 'i lao kekeda laa Abu kai dao mamana na mai. ");
INSERT INTO bvd_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","'Ana kada nai, kai ta'aa 'asia naa fuana wela keni ki ne kera iana, ma na wela keni ne kera faa susufia kaa wela tu'uu ki, sulia ne nia 'afitai fuada uri kera kai tafi. Ma na liodila lae baita lau guu kai toea waa 'ana maefera nee, sulia God kai kwaea na toaa 'i seeri ki. ");
INSERT INTO bvd_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Tai waa ada kera dai saungida 'ana 'ile ni firu. Ma tai waa ada kera dai dau da, ma kera kai kani faafida, ma daka ngali kera uria fera 'e'ete ki. Ma na toaa nao lau Diu ki dai saketoa fera baita nee 'i Durusalem lelea ka dao guu 'ana 'isi lana si kada kera toaa nai nao lau Diu ki. ");
INSERT INTO bvd_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Doo 'e'ete ki kai fuli 'ana sato, ma 'ana madame, ma 'ana bubulu ki. Ma na waa 'ana maefera baita ki sui 'i lao molaagali, kera kai fiitala, ma kera kai mau 'ana kuruu lana ma sulatatae lana asi. ");
INSERT INTO bvd_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ma na waa ki kera kai maetabuamarakwa sulia kera mau ka tasa, kada kera maasia na dao lana mai doo nai ki faafia molaagali nee tiifau. Sulia doo lao mamangaa ki, kera kai lea garo. ");
INSERT INTO bvd_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","'Uri nai fatai, nau, na 'Alakwa nia Wane, nau kufi dao faatai mai nai. Nau kwai dao mai fainia na tetedea baita, ma na folaa lae baita 'i lao dase ki. ");
INSERT INTO bvd_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ma kada na doo nai ki nia safali kai fuli, molu ka uu ma molu ka lio 'alaa, sulia kada God kai faamauri kamolu, nia dao karangi naa mai.” ");
INSERT INTO bvd_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Sui sa Disas ka bae sulia na tarifulaa nee fuada ka 'urii, “Molu ka manata fasi sulia 'ai ne kera saea 'ana fig fainia tai 'ai ki lau. ");
INSERT INTO bvd_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kada kamolu suai na sarana nia fufurua, molu ka saitomana naa, kada fuana uni sato nia karangi naa. ");
INSERT INTO bvd_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ka 'uri nai lau guu, kada kamolu suai doo nai ki nia fuli, molu ka saitomana naa ne kada fuana God kai gwaungai, nia dao karangi naa. ");
INSERT INTO bvd_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ku faarongo kamolu, doo nai ki tiifau kai dao mai sui fatai waa ne kera mauri 'i tari'ina ki, kera kafi mae. ");
INSERT INTO bvd_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Na mamangaa loo ma na molaagali ne kera kai sui, sui ma na bae laku totoo nao si sui. ");
INSERT INTO bvd_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Molu ka lilio diana. Nao kamolu si adea fafangaa baita ki, ma na kuu lilinge lae ki, ma manata 'abarua lae ki 'ana mauria nee lao molaagali. Lea kamolu ili 'uri nai, fa dani nai ka dao kai faatona kamolu ilingia ta 'aukwai. ");
INSERT INTO bvd_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sulia fa dani nai kai dao mai faafia na toae ki tiifau 'i lao molaagali nee. ");
INSERT INTO bvd_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Molu ka lilio diana, ma molu ka foa 'ana kada ki sui guu, fasi uri molu ka too 'ana tetedea 'ana mauria fua 'i lao doo nai ki ne kai fuli. Ma fasi uri kamolu si 'ide lau kada kamolu kai uu 'i maaku, na 'Alakwa nia Wane.” ");
INSERT INTO bvd_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","'Ana fa dani ki sui guu, sa Disas nia toolangaidoo fua toaa ki lao Beukaua loo. Ma 'i saulafia ki nia ka lea uria gwauna fa uo 'i 'Olif. ");
INSERT INTO bvd_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ma 'i 'uubongi maakafukafua ki, toaa 'oro ki dai lea mai lao Beukaua loo uri rongo lana bae lana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na Fangatasae, ne toaa Diu ki da 'ania beret ne nao ta isi ai, nia dao karangi naa nai. ");
INSERT INTO bvd_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","'Uri nai, waa baita ni foa ki, ma waa toolangaidoo 'ana taki ki, daka manata naa uria sau agwa lae 'ana sa Disas, sulia kera maungia lau gu 'ada toae ki. ");
INSERT INTO bvd_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ma Saetan ka ruufia naa manata lana sa Diudas 'Iskariot, ta waa 'ana akwala ma roo waa kwairooi bae sa Disas ki. ");
INSERT INTO bvd_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Seeri, sa Diudas ka lea naa siana waa baita ni foa ki, ma toa gwaungai ki 'ana waa neki kera lio sulia Beukaua loo, ma ka saea na fuada nia kai 'adomi kera uri dau lana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ma kera ka ele 'asia naa daka fale malefo naa fuana. ");
INSERT INTO bvd_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Sa Diudas ka kwai ala faafi fai kera, sui nia ka safali lio naa uria tasi kada ne gwau uri ka falea sa Disas 'i 'abada. ");
INSERT INTO bvd_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","'I seeri guu, ka dao naa 'afa dani 'ana fafangaa loko toaa Diu ki da 'ania beret ne nao ta isi ai. Ma fa sato nai lau gu ne da saungia na wela sifsif nai ai 'ana ade akau lae fua Fangatasae. ");
INSERT INTO bvd_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Sa Disas ka odua naa sa Bita fainia sa Dion ka bae 'urii fuadaru, “Muru lea kau 'i nao muru ka ade akau naa 'ana doo ki maasi kameli, uri kolu ka fanga 'ana Fangatasae.” ");
INSERT INTO bvd_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Keeru ka ledi 'urii 'ana sa Disas, “'I fai gu ne 'oe dooria kaari kai ade akau 'ana doo nai ki ai?” ");
INSERT INTO bvd_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Sa Disas olisi keeru ka bae 'urii, “Kada muru dao kau lao maefera baita loko, kamuru kai dao tona tii waa 'e tamaa kufidoo ni ngali kafo lae gwau'abana. Sa wala nai naa ne muru kai lea 'i burina uria luma ne nia lea ka ruu 'i laona. ");
INSERT INTO bvd_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Muru ka bae 'urii fuana waa ne luma nia nai, ‘Na waa toolangaidoo nia ledi 'urii mai 'ani 'oe: Kadaluma fai ne nau fai waa kwairooi nau ki meli kai 'ania Fangatasae ai?’ ");
INSERT INTO bvd_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ma waa nai kai faatainia kadaluma 'i langi, kula ne nia ade akau sui na ai, ma muru kai ade akau 'ana fanga ki 'i seeri.” ");
INSERT INTO bvd_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","'Uri nai, keeru ka lea naa, ma keeru ka dao tona doo ki tiifau ilingia naa doo bae sa Disas nia saea fuadaru. Ma keeru ka ade akau naa 'ana fanga 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nia dao naa 'ana kada fuana 'ani lana na Fafangaa 'ana Tasalae, ma sa Disas fainia 'aboosol nia ki, daka too naa 'ana kula ni fanga lae. ");
INSERT INTO bvd_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ma nia ka bae 'urii fuada, “Nau ku dooria 'asia naa 'ani lana Fangatasae nee fai kamolu, sui fatai nau kufi nonifii 'akua. ");
INSERT INTO bvd_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ma nau ku saea fua molu, nia 'afitai nau ku 'ania lau Fangatasae nee fai kamolu, lelea ka dao guu kada nia mamana 'i lao 'initoaa God.” ");
INSERT INTO bvd_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Sui sa Disas ka ngalia na titiu, ma ka tangoa God. Sui nia ka bae 'urii fuada, “Molu ka ngalia, ma molu ka 'ado kwaimani ai 'i sabitamolu. ");
INSERT INTO bvd_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nau ku saea fuamolu, 'ita 'i tari'ina ka oli 'alaa, nau kusi kuufia lau na waen nee, lelea ka dao guu lao 'initoaa God.” ");
INSERT INTO bvd_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Sui sa Disas ka ngalia na beret, ma ka tangoa God, sui nia ka niia, ma ka falea fuada. Ma ka bae 'urii, “Na noniku naa ne nau ku falea fuamolu nee. Molu 'ania ka lelea firi 'ana manata too laku lae.” ");
INSERT INTO bvd_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","'I burina kera fanga 'uri nai sui, nia ngalia lau guu titiui waen nai, ka bae 'urii, “Na 'abuku naa ne, ne nia igwa uri kamolu. Nia naa ne faangasia na alangaia falu. ");
INSERT INTO bvd_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Liotoi fasi! Na waa ne kai fale nau fuana malimae nau ki, nia too gu 'ana fai kamolu 'i seki lao fanga laa nee. ");
INSERT INTO bvd_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Sulia ni nau, na 'Alakwa nia Wane, nau kwai mae ilingia ne God nia dooria fuaku. Sui boroi nia kai ta'aa 'asia naa fuana waa ne nia fale nau fuana malimae nau ki!” ");
INSERT INTO bvd_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ma daka safali ledi kwailiu naa 'ani kera ki 'i matangada uria sa tii ada ne kai ilia si doo nai. ");
INSERT INTO bvd_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ma na waa kwairooi nia ki daka olisusuu 'i matangada kwailiu uri sa tii ada ne nia kai 'inito fuada sui gu 'ana. ");
INSERT INTO bvd_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ma sa Disas ka bae 'urii fuada, “Kamolu saitomana na waa 'inito kera ki toaa nao lau Diu ki da too 'ana rigitae ma daka suumainia 'asia naa toaa kera ki fua ili lana doori lada ki. Ma daka dooria wane ki daka sae kera 'ana wane gwaungai ki. ");
INSERT INTO bvd_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Sui ma ni kamolu gu ne nao molu si ilia lau si doo nai 'i matangamolu. Waa ne baita fuamolu ka abulo tu'uu, ma waa ne kwaitalai fuamolu na waa ni rao kamolu gwana. ");
INSERT INTO bvd_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","'Uri nai, waa tee gu ne nia 'initoa? Waa ne gooru daka ngali fanga mai fuana, ma nao waa ne rao fanga ma ka ngali fanga mai? Na waa ne gooru daka ngali fanga mai fuana ne nia 'initoa. Sui boroi 'ana, nau ku faarongo kamolu, nau waa ne ku nii matangamolu, nau na waa ni rao kamolu. ");
INSERT INTO bvd_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Kamolu molu too kwaimani mai fai nau 'ana si kada 'ana ilitooa nau ki tiifau. ");
INSERT INTO bvd_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Lea na Maa nau nia faa tiifau naa 'ana 'initoae fuaku, nau boroi kwai faa lau guu 'initoae fuamolu, ");
INSERT INTO bvd_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","uri molu ka fanga ma molu ka kuu kwaimani 'amolu fai nau lao 'initoaa nau. Kamolu molu kai gooru kwaimani 'ana 'inito lae fai nau, ma molu kai 'inito fua taafuli fiiwane ma roo fiiwane sarenga neki 'Israel.” ");
INSERT INTO bvd_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Sui sa Disas ka bae 'urii fuana sa Bita, “Saemon Bita wala! 'Oe waa kwairooi. God nia faolomainia naa Saetan, fasi uri kai ili uria kai tagalongai kamolu tiifau faasi nau, ilingia waa ne nia rao 'i lao ole fuana 'egwe lana miga doo diana ki faasia na tadidoo ta'ae ki. ");
INSERT INTO bvd_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ka 'uri nai boroi 'ana wala Saemon, nau ku foa fuamu, fasi uri ne nao 'oe 'osi olifaiburi lau 'ana fiitooa 'oe. Ma 'ana kada 'oe manata oli lau mai uri nau, 'oko faangasia toaa kwairooi nau.” ");
INSERT INTO bvd_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ma sa Bita nia luua ka 'urii, “Aofia 'ae, nau ku kwaimaakwalii sui guu 'akua uri lea lae fai 'oe 'i lao lookafo ma fuana maea lae fai 'oe!” ");
INSERT INTO bvd_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ma sa Disas nia luua ka 'urii, “Bita wala, nau ku faarongo 'oe, 'i tari'ina lao fa rodo nee, 'i nao 'ana karai kai angi, 'oko tofe nau olu si kada 'oko saea 'oe ulafusia nau.” ");
INSERT INTO bvd_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sui sa Disas ka ledi 'urii 'ana waa kwairooi nia ki, “'Uri nai ma kada bae nau ku fale kamolu kau, ma nao kamolu kasi too 'ana ta malefo, ma nao ta wai, ma nao ta tae butu, 'urii bae kamolu oli kukuru 'ana ta doo bae?” Ma kera luua daka 'urii, “Nao guu.” ");
INSERT INTO bvd_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ma sa Disas ka bae 'urii, “Sui boroi 'ana tari'ina, lea sa tii ne nia too 'ana ta malefo ma nao ta wai, nia ka ngalia na mone 'ana. Ma sa tii ne nao kasi too 'ana ta 'ile ni firu, nia ka foli 'ana maku baita nia, ma ka folia ta 'ile 'ana. ");
INSERT INTO bvd_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nau ku saea doo neki fuamolu, sulia na kekeda laa Abu bae nia bae suli nau 'urii, ‘Kera koni nia fainia waa ta'aa ki.’ Doo nai kai fuli naa fuaku, sulia na kekeda laa ki sui guu suli nau kai fuli mamana naa.” ");
INSERT INTO bvd_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ma na waa kwairooi nia ki daka bae 'urii, “Aofia wala, suai fasi, kolu too naa 'ana roo 'ile ni firu ki 'i see ne!” Ma nia 'e luu kera ka 'urii, “Nia diana naa. Alu tio na 'ana bae lae suli doo nai.” ");
INSERT INTO bvd_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Sa Disas fainia na waa kwairooi nia ki, kera faasia naa toaa baita nai, ma daka lea naa uria fa uo kera 'ailia 'ana 'Olif, ilingia ne 'ita daka ilia mai. ");
INSERT INTO bvd_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ma kada kera dao 'ana si kula nai, nia ka bae 'urii fuada, “Molu ka foa, ade lea na ilitooe ki ka linge kamolu.” ");
INSERT INTO bvd_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Sui sa Disas nia ka 'idu tu'uu gu 'ana kau faasi kera ka bobola fainia 'ui lae 'ana si fau ka dao ai, nia ka booruru 'i saegano ka foa. ");
INSERT INTO bvd_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nia ka bae 'urii, “Maa 'ae, lelea doori lamu naa ne, 'oko lafua 'amu nonifiie ne faasia nau. Sui boroi 'ana, nao lau na kwaidooria nau, boroi ma sulia kwaidooria 'oe lau 'ana.” ");
INSERT INTO bvd_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ma tii 'ensel faasia 'i langi nia dao mai, ma ka faarakea naa. ");
INSERT INTO bvd_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ma liona ka fii 'asia naa, nia ka foa tetede lau. Ma na 'i'ide ne 'i nonina 'u'udu ka 'asia 'i saegano ka mala ta gwigwise 'abu. ");
INSERT INTO bvd_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ma kada nia tatae faasia na foa lae, nia ka oli siana na waa kwairooi nia ki. Kera maleu 'ada, sulia kera makeso tasa sulia kera liodila. ");
INSERT INTO bvd_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ma sa Disas ka bae 'urii fuada, “'Urifita ne kamolu ka maleu rowane? Molu tatae, ma molu ka foa, ade lea na ilitooe ki ka linge kamolu.” ");
INSERT INTO bvd_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kada manga sa Disas nia bae 'ua gu 'ana fai kera, tii figue baita daka dao na mai. Ma tii waa 'ana waa kwairooi nia baki, ne satana sa Diudas, nia ne talaida mai. Ma nia ka dao mai siana sa Disas, ma ka nonoia naa. ");
INSERT INTO bvd_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Sui boroi 'ana sa Disas ka bae 'urii fuana, “Wala Diudas 'ae, 'oe fale nau, na 'Alakwa nia Wane, fuana malimae nau ki 'ana nonoi laku?” ");
INSERT INTO bvd_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ma kada na waa kwairooi ki kera too fainia sa Disas, daka suai doo nai, daka bae 'urii, “Wala Aofia! Alu kameli kumuli kera 'ana 'ile ni firue kameli ki, ma nao 'utaa?” ");
INSERT INTO bvd_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ma tii waa ada, ka kwaea tii waa ni rao nia waa foa ni gwau, ma ka kwae muusia naa na bali alinga aolo nia. ");
INSERT INTO bvd_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Guu sa Disas ka bae 'urii, “Too na 'ana!” Ma nia ka samo tona alingana waa nai, ma ka guraa naa alingana. ");
INSERT INTO bvd_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sui sa Disas ka bae fuana waa baita ni foa ki, ma waa neki kera folo suusia Beukaua loo, ma tai waa baite ki lau guu ne kera lea mai uri dau lana, nia ka 'urii, “'Uri nai ma, nau ta waa garo nao nee, uri kamolu ka dau raunga mai uri nau? ");
INSERT INTO bvd_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nau ku too guu 'akua siamolu 'i lao Beukaua loo sulia fa dani 'oro ki, sui boroi nao kamolu si sasi guu uria dau laku. Sui boroi 'ana si kada kamolu naa ne, uri kamolu ka rao naa 'ana tetedea Saetan, na waa ne 'inito 'ana rorodoe.” ");
INSERT INTO bvd_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sui daka daua naa sa Disas, ma daka talaia naa 'i lao luma nia waa foa ni gwau. Ma sa Bita ka 'isi tau lau gu 'ana kau 'i buri. ");
INSERT INTO bvd_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ma kera 'ukunia tii era 'i tofungana kula ni too lae 'i lao labu 'ana luma nai, ma sa Bita ka gooru lau guu fainia toaa ne kera too kakalia na ere nai. ");
INSERT INTO bvd_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ma kada tii wela keni saari ni rao nai nia suana sa Bita ne gooru seeri karangia era nai, nia ka lio filoa 'ua guu ka bae 'urii, “Na waa nee nia too lau guu mai fainia sa Disas ne!” ");
INSERT INTO bvd_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Sui boroi sa Bita ka tofe ka 'urii, “Wala wela keni nee wala, nau kusi saitomana na waa nai!” ");
INSERT INTO bvd_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ma nao si tau lau guu 'i burina, tii waa ka suana sa Bita ka bae lau guu 'urii, “'Oe ta waa lau guu ada ne!” Sui boroi sa Bita nia luua ka 'urii, “Wala 'ae, nau nao wala.” ");
INSERT INTO bvd_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ma nao si tau lau guu 'i burina, tii waa lau ka bae tetede ka 'urii, “Nia mamana. Na waa ne nia too lau guu fainia sa Disas, sulia nia lau guu na waa faasia 'i Galilii ne!” ");
INSERT INTO bvd_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Sui boroi sa Bita nia luua ka 'urii, “See wala nee, nau ku ulafusia doo na 'oe bae sulia nai wala!” Ma kada nia bae gu 'ana 'uri nai, na karai ka 'ai naa. ");
INSERT INTO bvd_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ma na Aofia ka abulo, ka lio 'o'olo na kau fuana sa Bita. Ma sa Bita ka manata naa tona baea bae na Aofia nia saea fuana bae 'urii, “'I nao sui fatai karai kafi 'ai, 'oe 'oko olu fa tofe laku 'oko saea 'o lalafusi nau.” ");
INSERT INTO bvd_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ma sa Bita ka ruu na kau 'i maa, ma ka angi baita lea ka igigele guu, sulia liona 'e dila 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ma na waa ni firu ki ne kera folo kalia sa Disas, kera ka 'onionga 'ani nia, ma daka nangasia. ");
INSERT INTO bvd_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ma daka kani bokotaa na maana, ma daka ledia daka 'urii, “'Oe saea fasi sa tii ne fidali 'oe nai?” ");
INSERT INTO bvd_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ma daka saea baea ta'aa 'oro ki lau guu fuana. ");
INSERT INTO bvd_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ma uri 'uubongi kada nia dani naa, na toa gwaungai kera toaa Diu ki, ma na waa baita ni foa ki, ma na waa toolangaidoo 'ana taki ki, kera ka bae ofu naa, ma daka talaia naa sa Disas siada. ");
INSERT INTO bvd_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ma daka bae 'urii fuana, “'Oe faarongo kameli fasi wala. Nia sae 'oe naa ne Kraes bae 'oi dao na mai fua faamauri lameli lae nee, ma nao ni 'oe nao?” Nia 'e luu kera ka bae 'urii, “Lea sae ku faarongo kamolu boroi ai, 'afitai molu ka faamamane nau gu ne. ");
INSERT INTO bvd_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ma lea nau ku ledi kamolu uria tii si doo, nia 'afitai molu ka luua ne. ");
INSERT INTO bvd_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Sui boroi nia 'ita 'i tari'ina ka oli 'alaa, nau, na 'Alakwa nia Wane, nau kwai too 'i bali 'aba aolo nia God 'ana tetede tasa, ma nau kui 'inito fainia.” ");
INSERT INTO bvd_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ma kera tiifau guu daka ledia daka 'urii, “'Uri nai ma 'oe naa ne 'Alakwa nia God?” Ma nia luu kera ka 'urii, “Iuka, nia naa nai kamolu tala saea nai.” ");
INSERT INTO bvd_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ma daka bae 'urii, “Nao kolu si dooria naa tasi baea uri kolu ka faamamane nia lau. Sulia kolu tala rongo naa nai, nia tala saea nia 'Alakwa God!” ");
INSERT INTO bvd_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ma na konia nai sui naa, kera tatae daka talaia naa sa Disas siana sa Baelat fuana keto lana. ");
INSERT INTO bvd_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ma daka safali naa fua feengi lana lae 'ana doo garo ki, ma daka bae 'urii, “Kameli, meli dao tona sa wala nee nia bae alingana toaa kameli ki ka saea fuada nao dasi fale naa malefo 'ana takisi lae fua waa baita 'i Rom, ma nia ka saea sae nia naa ne na Kraes na waa ni taloa bae.” ");
INSERT INTO bvd_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ma sa Baelat ka ledia ka bae 'urii, “'Urii ma ni 'oe na waa 'inito kera bae toaa Diu ki naa ne?” Ma sa Disas ka luua 'urii “Nia naa ne 'oe saea nai.” ");
INSERT INTO bvd_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Sui sa Baelat ka bae 'urii fuana na waa baita ni foa ki, ma fua figua nai guu, “Nau kusi dao tona guu tasi doo ne garo 'ana sa wala nee uri daka saungia faafia.” ");
INSERT INTO bvd_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ma daka bae tetede na mai daka 'urii, “Sui boroi 'ana lao bali lolofaa 'i Diudia, sa wala nee nia saketoa naa toae 'ana toolangaidoo laa nia. Nia safali 'ua mai 'i Galilii lelea mai ka dao naa 'i seeki lau guu.” ");
INSERT INTO bvd_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ma kada sa Baelat nia rongoa doo nai, nia ka ledi kera ka 'urii, “'Uri nai ma sa wala nee nia lea mai faasia 'i Galilii nee?” ");
INSERT INTO bvd_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ma kada nia saitomana ne sa Disas nia lea mai faasia na kula ne sa Herod nia 'inito, nia ka fale kau sa Disas siana sa Herod. Sulia sa Herod nia nii lau guu 'i Durusalem 'ana kada nai. ");
INSERT INTO bvd_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ma kada sa Herod nia suana sa Disas, nia ka ele 'asia naa, sulia nia rongoa na baee ki suli nia, ma ka kwaimaasi ka tau naa uri sua lana. Ma nia ka dooria naa sua lana sa Disas uri ili lana ta doo kwaibalatana. ");
INSERT INTO bvd_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Sa Herod nia ledia doo 'oro ki 'ani nia, boroi ma sa Disas nao si luua guu 'ana ta si doo. ");
INSERT INTO bvd_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ma na waa baita ni foa ki, ma na waa toolangaidoo 'ana taki ki, kera uu lau guu 'i seeri, ma daka bae tetede naa uri feengi lana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ma sa Herod fainia na waa ni omee nia ki, daka 'onionga 'ada 'ana sa Disas, ma daka bae ta'aa fuana. Ma daka faa ruufia 'ana tii maku tikwa diana, ma daka oli lau fainia siana sa Baelat. ");
INSERT INTO bvd_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ma nia 'ita 'ana fa dani nai, sa Herod ma sa Baelat keeru daru ka ofu kwaimani naa. 'I nao keerua na roo malimae ki. ");
INSERT INTO bvd_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Sa Baelat ka konia naa waa baita ni foa ki, ma waa gwaungai ki, ma na toae ki. ");
INSERT INTO bvd_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ma ka bae 'urii fuada, “Kamolu falea naa mai na waa ne siaku, molu ka saea sae nia talai garo 'ana toae ki faasia na ade lae sulia gwaungaia 'i Rom. Ma sui, nau ku ledia 'i maa molu, ma nao nau kusi dao guu tona tasi garoa 'ani nia mala ne kamolu feengi nia ai. ");
INSERT INTO bvd_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ma sa Herod boroi si dao guu tona tasi garo laa 'ani nia. Nia ne ka olitainia lau gu 'ana mai nee. Nia nao si ilia guu ta garoa uri ka maelia. ");
INSERT INTO bvd_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nia ne, nau ku falea guu 'akua kau uri kera ka kwae nia, sui ku lukatainia ka lea na 'ana.” ");
INSERT INTO bvd_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","'Ana Fafangaa 'ana Tasalae, sa Baelat lea doo kai lukea tii waa faasia 'i lao lookafo fuana toaa Diu ki, sulia birangaa kera ne 'uri nai naa. ");
INSERT INTO bvd_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Sui boroi 'ana kera sui naa da 'ai daka 'urii, “Molu saumaeli sa wala na! Molu ka lukea 'amolu mai sa Baarabas fuameli!” ");
INSERT INTO bvd_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Sa Baarabas kera alua lao na lookafo, sulia nia safalia na omee baita 'i lao maefera baita nai, ma nia na waa sauwane 'ua guu. ");
INSERT INTO bvd_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Sa Baelat nia dooria kai lukea sa Disas, ma nia ka ledia lau kau na figua nai. ");
INSERT INTO bvd_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Sui boroi 'ana daka dau 'ada 'ana 'ai lae 'urii, “Molu saungia ka mae! Molu ka foto faafia 'ana 'airarafolo!” ");
INSERT INTO bvd_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ma sa Baelat ka bae 'urii lau fuada 'ana oluna si kada, “Sui boroi 'ana, ma garoa tee ne nia ilia? Nau nao kusi dao toi guu ta doo ne nia ilia garo uri ka maelia. Nia ne nau ku falea kau uri kera kai kwae nia gu 'ada, sui daka lukea lau gu 'ada.” ");
INSERT INTO bvd_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Sui boroi 'ana ma kera daka dau naa 'ana akwa lae ma daka suumainia naa uri foto faafi lana 'ana 'airarafolo. Ma na suungia nai ka linge nia naa. ");
INSERT INTO bvd_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ma sa Baelat ka falea na kwakwaea ne kera susuu uria sulia gani laa kera. ");
INSERT INTO bvd_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ma nia ka lukea naa sa Baarabas na waa bae kera dooria, na waa bae kera alua 'i lao lookafo faafia safali lana omee, ma sauwanee. Sui sa Baelat ka falea sa Disas fuada, sulia kwaidooria kera. ");
INSERT INTO bvd_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ma na waa ni omee ki, daka talaia sa Disas daka lea na kau fainia. Ma kada kera lea kau, daka dao tona tii waa 'i sara ne satana sa Saemon, faasia maefera baita 'i Saerin. Nia ruu mai lao labu 'i Durusalem faasia tii kula mai 'i maa. Ma daka alua naa 'airarafolo 'i gwauna 'abana, ma daka suumainia uri nia ka ngalia 'i burina sa Disas. ");
INSERT INTO bvd_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ma tii figua baita daka lea 'i burina. Ma tai wela keni 'i lao figua nai kera angisi nia daka isisigwau. ");
INSERT INTO bvd_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Sa Disas nia abulo fuada ka bae 'urii, “Wela keni neki 'i Durusalem 'ae! Nao kamolu si angisi nau lau. Molu kai angisi kamolu tala 'amolu, fai wela kamolu ki. ");
INSERT INTO bvd_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sulia nia kai dao 'ana fa dani ne toae ki kera kai bae 'urii, ‘'E diana tasa fuana wela keni 'aba'ato ki, ma wela keni nao dasi kwala wela ki, ma nao dasi faasusu ki!’ ");
INSERT INTO bvd_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ma kada nai na toae ki kera kai bae 'urii fuana fa uo ki, ‘Molu toli mai faafi kameli.’ Ma daka bae 'urii fuana toloa ki, ‘Molu atoli mai faafi kameli.’ ");
INSERT INTO bvd_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Sulia lelea kera dai ili 'uri nai aku, na waa ne nau ku 'o'olo, kera kai ilia doo ne nia ta'aa ka tasa 'amolu toaa ne kamolu too 'ana ta'aa lae ki.” ");
INSERT INTO bvd_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ma daka ngalia lau guu roo waa beli ki, fuana saungi ladaru fainia sa Disas. ");
INSERT INTO bvd_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ma kada kera dao 'ana kula ne kera saea 'ana “Gwau Lelete,” daka foto faafia sa Disas 'ana na 'airarafolo. Ma na roo waa beli baki, daka foto faafi keeru lau guu 'ana roo 'airarafolo ki, tii waa 'ana bali aolo nia sa Disas, ma ta waa 'ana bali mauli 'ana. ");
INSERT INTO bvd_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ma sa Disas ka bae 'urii, “Maa, 'oe manata luke kera, sulia kera da ulafusia gu 'ada doo ne kera ilia.” Ma na waa ni omee ki kera daka saso 'ana tii doo mala dais nai uri daka tolingia maku nia ki fuada kwailiu. ");
INSERT INTO bvd_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Na toaa ne kera uu 'i seeri ki daka dau gu 'ada 'ana bubu lae, ma na waa gwaungai kera toaa Diu ki daka dau 'ana 'onionga lae 'ani nia daka bae 'urii, “Nia bae faamauria naa toaa 'e'ete ki. Lea sae nia na Kraes ne God 'e filia mai, ni ka faamauria nia fasi tala'ana.” ");
INSERT INTO bvd_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ma na waa ni omee ki, daka 'onionga lau guu 'ani nia, daka lea kau siana, ma daka falea waen lifoo fuana. ");
INSERT INTO bvd_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ma daka bae 'urii, “Lea 'oe na waa 'inito toaa Diu ki, 'oko faamauri 'oe tala 'amu!” ");
INSERT INTO bvd_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ma daka kedaa naa si baea 'urii 'i gwauna 'airarafolo nia, “Ni nia naa ne na waa 'inito kera toaa Diu ki.” ");
INSERT INTO bvd_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ma ta waa 'ana roo waa baki da foto faafi keeru fai sa Disas, liu 'e bae kwakwala ka bae 'urii, “'Oe naa bae 'o saea sa 'oe na Kraes. Aia, ma 'o faamauri kolu fasi.” ");
INSERT INTO bvd_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ma sui ruana waa bae ka ngatafia ka 'urii, “Nee wala, 'oe 'osi maungia guu kwakwaea God nee? Kolu bobola guu, sulia kera falea guu tii kwakwaea fua kolu. ");
INSERT INTO bvd_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ma sui ni koro nee, na kwakwaea ne nia 'o'olo naa ne, sulia koro ngalia naa uria doo ta'aa neki koro ilia ki. Aia, ma ni nia nao si ilia guu ta doo garo.” ");
INSERT INTO bvd_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ma nia ka bae 'urii fuana sa Disas, “Disas 'ae, 'o manatai nau, kada 'oe oli mai 'ana 'initoaa 'oe.” ");
INSERT INTO bvd_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ma sa Disas ka bae 'urii fuana, “Nau ku saea na doo mamane fuamu, 'i tari'ina gu ne 'oe too na fai nau 'i salo.” ");
INSERT INTO bvd_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nia 'ita 'i tofungana sato, na sato ka rorodoa, ma bali fera nai tiifau ka rodo, lelea ka dao 'ana oluna kada sato saulafia. ");
INSERT INTO bvd_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ma na maku baita ne nia suusia na kula abu 'i lao na Beukaua loo ka kari 'ana roo bali doo ki. ");
INSERT INTO bvd_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ma sa Disas nia ka 'ai baita ka 'urii, “Maa 'ae, nau ku falea na kau na mangoku fuamu.” Nia 'e bae 'uri nai sui guu, ka mae naa. ");
INSERT INTO bvd_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ma na waa baita 'ana omee nia suai doo nai, nia ka tangoa God ka 'urii, “Nia mamana, nia na waa 'o'olo ne!” ");
INSERT INTO bvd_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ma kada na waa nai ki kera koni, ma kera ka bubungia, kera suai mae lana sa Disas ka sui, kera tiifau daka oli naa 'ada 'i fera kera ki. Ma daka fidalia maa ruruuda fuana faatai lana na liodila lae kera ki. ");
INSERT INTO bvd_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ma na toae ki tiifau ne kera saitomana sa Disas, fainia na wela keni ne kera lea 'i burina faasia 'i Galilii ki, kera uu tau guu 'ada, ma daka suai gu 'ada doo nai ki tiifau. ");
INSERT INTO bvd_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ma tii waa faasia maefera 'i 'Arimatea 'i lao bali lolofaa 'i Diudia, ne satana sa Diosef, nia too lau guu 'i seeri. Ma nia na waa 'o'olo, ma na waa diane, ma nia ka kwaimaasi lau guu uri sua lana God kai 'inito faafia toaa nia ki. Ma sui boroi 'ana nia ta waa 'ana toaa gwaungai kera Diu ki, nia nao si ala guu faafia doo ne kera saea, ma daka ilia 'ana sa Disas ki. ");
INSERT INTO bvd_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nia ka lea siana sa Baelat, ma ka gani nia uria na nonina sa Disas. ");
INSERT INTO bvd_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ma nia ka lafua naa nonina sa Disas, ma ka 'afua naa 'ana maku kwakwaoe. Ma nia ka alua 'i lao tii likwafau falu ni aluwanee ne kera 'elia 'i lao fau baita nai. ");
INSERT INTO bvd_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ma fa dani nai na Faraedee. Fa sato fuana ade akau lae maasia Sabati fa dani 'ana momola lae, nia karangi safali naa. ");
INSERT INTO bvd_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Na wela keni ne kera lea mai burina sa Disas faasia 'i Galilii ki, kera lea lau guu fainia sa Diosef. Ma daka suai naa likwafau nai, ma daka suai naa alu lana sa Disas 'i laona. ");
INSERT INTO bvd_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Sui daka oli na mai 'i fera, ma daka ade akau 'ana waiwai ki, ma na doo moko diana ki fuana kano lana 'ana nonina sa Disas. Sui boroi 'ana fa dani 'ana Sabati, daka momola naa, mala na taki nia saea. ");
INSERT INTO bvd_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Aia, 'ana Sandee 'i 'uubongia maakafukafua, na bara wela keni bae kera ngalia waiwai moko diana nai ki da ade akau ki mai ai daka lea naa uri maana likwafau bae. ");
INSERT INTO bvd_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Lea kau dao daka suai kwainaia bae nia 'ifi naa, sulia na reba fau bae nao si suusia naa maana kwainaia nai. ");
INSERT INTO bvd_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ma kera ka ruu na kau, sui boroi ka nao dasi suai naa nonina sa Disas na Aofia. ");
INSERT INTO bvd_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ma kada kera manata 'ua gu 'ada sulia si doo nai, roo 'ensel ne kera ruufia na maku waasinasina tasa nai ki, keeru ka sakatafa mai daru ka uu naa siada. ");
INSERT INTO bvd_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Na wela keni nai ki daka mau 'asia naa daka gwautoli nada 'i saegano. Sui boroi 'ana roo waa nai ki, keeru ka bae 'urii fuada, “Nee rowaa, 'utaa ne molu ka lea lau mai uri nani lae uria waa mauri gwana 'i seki kula fua waa mae ki 'ana? ");
INSERT INTO bvd_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nia nao si nii na 'i seki ne, sulia nia 'e mauri lau gu 'ana. Kamolu manata toi fasi, si doo bae nia faarongo ai siamolu tiifau 'ana kada bae nia too 'ua fai kamolu 'i Galilii. Nia bae 'urii bae, ");
INSERT INTO bvd_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Kera kai fale nau, 'Alakwa nia Wane, fuana toaa ta'aa ki, ma kera kai foto faafi nau 'ana 'airarafolo, sui dao oluna maedani, nau kui tatae lau gu 'aku faasi maea.’” ");
INSERT INTO bvd_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Sui guu bara wela keni nai daka manata toi naa si bae nia baki. ");
INSERT INTO bvd_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Guu kera daka oli naa faasia kwainaia bae, ma lea daka faarongoa naa akwala ma tii waa kwairooi nia ki, ma tai waa lau ne kera dao toda. ");
INSERT INTO bvd_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Na ai neki da lea kau daka faarongoa 'aboosol nia ki, ne ni Meri faasia 'i Magdala, keni Dioana, ni Meri gaa sa Demes, ma tai ai lau. ");
INSERT INTO bvd_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ma sui boroi 'ana, na 'aboosol ki ka nao dasi faamamanea guu bae lana wela keni nai ki. Suli da manata toi 'ada sae sa wela keni nai ki da bae ata gwada. ");
INSERT INTO bvd_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Sui boroi 'ana sa Bita nia tatae, ma ka lae 'ali'ali naa uria maana likwafau. Ma nia ka ororo kau, ma ka suai gu 'ana maku kwakwaoa baki tio gu 'ada 'i seeri. Sui nia ka oli, ma ka kwele 'asia naa 'ana doo ne fuli nai. ");
INSERT INTO bvd_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","'Ana fa dani nai, ta roo waa 'ana waa kwairooi sa Disas ki, keeru lea uria na toaa 'i 'Imeas. Nia bobola fainia taafuli kada taale ma tii kada taale sarenga faasia 'i Durusalem. ");
INSERT INTO bvd_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ma keeru ka bae 'adarua sulia doo nai ki sui guu ne fuli. ");
INSERT INTO bvd_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ma kada keeru bae 'adarua, sa Disas nia lea karangi keeru mai, ma ka lea lau guu fai keeru. ");
INSERT INTO bvd_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Keeru ka suai guu 'adarua, boroi ma God nao si faolomainia fuadaru uri keeru ka lio saitomana. ");
INSERT INTO bvd_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ma sa Disas ka bae 'urii fuadaru, “Tee ne kamuru bae mai sulia kada ne kamuru lea mai nai?” Ma keerua daru ka uu aroaro, ma na manata ladaru ka kii. ");
INSERT INTO bvd_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ma tii waa 'adarua ne satana sa Kleopas, nia ka bae 'urii, “Nau ku manata toi alamia 'oe guu ne 'o too boroi 'i Durusalem, ma 'oko ulafusia gu 'amu na doo neki fuli lao fa dani nai ki mai.” ");
INSERT INTO bvd_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ma sa Disas nia ledi kera ka 'urii, “Doo 'uri tee ki gu nai rowaa?” Ma keeru olisi nia, daru ka 'urii, “Doo nai ki ne kera ilia 'ana sa Disas, waa bae 'i Naasaret. Na waa nai, nia na brofet, na waa fuana bae lae na 'ana sulia bae lana God, sulia God ma na wane kera saitomana na bae lana 'e mamana, ma na rao lana ka baita 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Na waa baita ni foa kameli ki, ma na waa kwaitalaia ki, kera fale nia kau fua saungi lana, ma daka foto faafia 'ana 'airarafolo. ");
INSERT INTO bvd_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ma kameli ka manata 'amelia sulia sae nia naa ne kai lukea toaa 'i 'Israel ki. Ma tari'ina na oluna fa dani naa 'i burina doo nai ki fuli ne. ");
INSERT INTO bvd_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ma kameli meli ka kwele 'asia naa, sulia tai wela keni 'ana figua kameli, da lea daka dao mai 'ana likwafau bae. ");
INSERT INTO bvd_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ma sui ka nao dasi suana gu nonina. Ma daka oli mai, daka saea ne kera suana 'ensel ki faarongo kera ne nia mauri lau. ");
INSERT INTO bvd_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ma tai waa lau guu 'ana figua kameli, kera da lea lau guu maana likwafau nai, ma daka dao tona nia mamana naa, mala bae wela keni nai ki kera saea. Sui boroi ka nao dasi suai naa nonina sa Disas.” ");
INSERT INTO bvd_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ma sa Disas ka bae 'urii fuadaru, “Kamuru oewanea 'asia naa! Ma na manatamuru ka nao si 'ali'ali uri faamamane lana doo bae na brofet ki kera saea 'ua mai 'i nao. ");
INSERT INTO bvd_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Na Kraes bae, nia kai nonifii fasi sui fatai nia kafi ruu lao 'initoaa nia.” ");
INSERT INTO bvd_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ma sa Disas ka toolangaidoo fua keeru 'ana doo bae kera saea sulia na Kraes 'i lao kekeda laa Abu ki. Nia safali 'ana kekeda laa sa Mosis ki ka lea 'ana kekeda laa brofet ki. ");
INSERT INTO bvd_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ma kada kera dao karangia naa toaa ne kera lea uria, sa Disas ka ili mala sae nia kai faasi keeru naa 'i seeri ka tasa na 'ana. ");
INSERT INTO bvd_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ma keeru ka luia, daru ka bae 'urii, “'Oe too fasi 'amu mai fai kaari, sulia nia saulafia naa ne, ma faanoe boroi kai rodo naa.” Ma nia ka lea naa fai keerua. ");
INSERT INTO bvd_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kada nia gooru naa fai keeru uri fanga lae, nia ka ngalia fa beret, ka tangoa God, sui ka niia ka falea fuadaru. ");
INSERT INTO bvd_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kada keeru suai doo nai, God ka faolomainia keeru kafi lio saitomana naa, ma nia ka nao 'ana naa faasi keeru. ");
INSERT INTO bvd_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ma keeru ka bae fuadaru kwailiu, daru ka 'urii, “Se! Kada bae nia bae fai koro mai sulia taale, ma ka toolangaidoo fua koro 'ana kekeda laa Abu ki, koro ele tasa bae.” ");
INSERT INTO bvd_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ma 'ana si kada nai 'ua guu, keeru sulatatae, daru ka oli lau gu 'adaru uri 'i Durusalem. Ma keeru ka dao tona akwala ma tii waa kwairooi baki ne kera koni guu 'ada, fainia tai waa lau. ");
INSERT INTO bvd_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ma waa ki lao figua nai daka faarongo keeru 'urii, “Na Aofia nia mauri lau, mamana naa! Nia dao faatai fuana sa Saemon!” ");
INSERT INTO bvd_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ma keeru ka bae sulia na doo bae fuli sulia taale, ma sulia na kada keeru lio saitomana kada nia niia fa beret bae. ");
INSERT INTO bvd_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kada roo waa nai ki keeru bae gu 'adarua fuadaru 'ua, sa Disas nia ka sakatafa ka uu naa 'i sabitada, ma ka bae 'urii fuada, “Na aroaroe kai too fai kamolu.” ");
INSERT INTO bvd_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ma daka tona, ma daka mau 'asia naa, sulia kera kwaifii sae kera suai ta anoedoo. ");
INSERT INTO bvd_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ma sa Disas ka bae 'urii, “Tee ne molu mau ai? Nao molu si manata 'oroa! ");
INSERT INTO bvd_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nau gu 'ana ne. Molu suai fasi roo 'aba nau neki fai roo 'ae nau neki. Molu samo tona fasi mai noniku nee uri molu ka saitomana, sulia na anoedoe nao si too 'ana 'oki fainia mariko, mala ne kamolu suai nau ku too ai nee.” ");
INSERT INTO bvd_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Burina ne nia saea doo nai ki ka sui, nia ka faatainia naa fulina nila baki 'ana roo 'aba nia ki ma roo 'ae nia ki fuada. ");
INSERT INTO bvd_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ma kera daka ele 'asia naa fainia 'ana kwele lae. Sui boroi 'ana, kera ka manata ruarua guu 'ada, sulia nao kera dasi saitoma diana 'ua ai. Ma sa Disas ka bae lau 'urii fuada, “Molu falea fasi mai tasi fanga fuaku.” ");
INSERT INTO bvd_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ma daka falea tii gwa sakwari fuana. ");
INSERT INTO bvd_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ma nia ngalia ka 'ania naa 'i naofada. ");
INSERT INTO bvd_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sui nia ka bae lau 'urii fuada, “Doo neki nau ku saea mai fuamolu, kada ne nau ku too 'ua mai fai kamolu. Doo nai ki sui guu kera kedaa suli nau lao taki sa Mosis ma lao kekeda laa brofet ki, ma lao Sam ki, kera mamana naa.” ");
INSERT INTO bvd_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Sui sa Disas ka 'ifingia manata lada uri kera ka saitomana kekeda laa Abu ki. ");
INSERT INTO bvd_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nia ka bae 'urii fuada, “Kera kekeda mai suli nau, na Kraes, ne nau kwai nonifii, ma sui lao oluna fa dani, nau kwai tatae lau faasia maea. ");
INSERT INTO bvd_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ma 'ita 'i Durusalem lelea ka dao lao fere ki tiifau, kamolu kai bae sulia na lukasi lana abulo ta'aa lae fai na manata luke lae 'ana sataku. ");
INSERT INTO bvd_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ma kamolu naa ne molu ka faarongo 'ana doo nai ki. ");
INSERT INTO bvd_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ma nau tala 'aku, nau kwai falea Anoedoo Abu fuamolu ne Maa nau 'ita ka alangainia na mai. Ma molu ka kwaimaasi 'i Durusalem, lelea na tetedea faasia 'i langi kai koso mai faafi kamolu.” ");
INSERT INTO bvd_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sui nia ka talaida naa faasia 'i lao maefera baita nai, lelea daka dao 'ana maefere 'i Betanii, ma nia ka tafoa naa 'abana 'i langi, ka faadiana kera naa. ");
INSERT INTO bvd_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ma kada nia faadiana kera 'ua gu 'ana, nia ka faasi kera, ka tae naa uria 'i langi. ");
INSERT INTO bvd_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ma kera daka faa'initoaa, sui daka oli na 'ada uri Durusalem fainia na ele laa baita. ");
INSERT INTO bvd_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ma 'ana kada 'oro ki kera daka too gu 'ada 'i lao Beukaua loo fuana tango lana God. ");
INSERT INTO bvd_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","'Ana sasafali laa 'ua mai, si Baea nia 'ita ka too naa, ma si Baea ka too kwaimani naa fai God, ma si Baea nia God. ");
INSERT INTO bvd_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nia 'e too kwaimani naa fai God 'ana sasafali laa 'ua mai. ");
INSERT INTO bvd_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ma na doo neki sui guu God nia saungainia, si Baea ne ilia ka fuli. Nao tasi doo 'ana doo neki God nia saungainia sui guu, ne si Baea nia 'e ore fasi fuli lana. ");
INSERT INTO bvd_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Na maurie 'ita mai 'ani nia. Ma na mauria nai nia na kwesu ne tala folaa tala doo God ki fuana wane 'ana fera ne 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ma na kwesu nai ka tala folaa fua lao rorodoa lae, ma sui na rorodoa lae ka nao si liofilo nia gu mai. ");
INSERT INTO bvd_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","God nia odua mai tii waa nai ka lea mai, ma waa nai satana sa Dion na waa ni faasiuabu. ");
INSERT INTO bvd_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Sa Dion nia lea mai uri faarongo lae sulia kwesu nai, uri toae ki sui guu daka rongoa ma daka manata mamana. ");
INSERT INTO bvd_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Sa Dion 'i tala'ana nia nao lau na kwesu nai. Nia na waa 'e lea lau 'ana mai uri faarongo tatalo lae sulia kwesu nai. ");
INSERT INTO bvd_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Na kwesu mamana nai mone, nia ne 'e dao na mai 'isi lao fera ne 'i saegano, uri ka tala folaa fua toae ki sui guu. ");
INSERT INTO bvd_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ma sa wala nai si Baea 'e lea mai ka nii na lao fera ne 'i saegano. Nia ne fulia fera ne 'i saegano suli manata lana God. Ma sui boroi 'ana, wane lao fera ne 'i saegano ki nao kera dasi liofilo nia guu. ");
INSERT INTO bvd_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nia ka dao mai siana toaa nia ki, ma sui boroi 'ana toaa nia ki nao kera dasi ala faafi nia guu. ");
INSERT INTO bvd_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ma sui ka 'uri nai boroi 'ana, toaa ki sui gwana ne kera da ala faafi nia, ma daka manata mamana 'ani nia, nia 'e faolomai kera sui guu uri daka maa 'ana God. 'I seeri, kera sui guu na wela God ki naa. ");
INSERT INTO bvd_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Na futa laa nai kera futa 'ana God nai, God 'ana ne nia ilia ka fulia 'ani kera. Nia nao lau doo sulia lioewane 'ana fera ne 'i saegano, ma ka nao lau na futa lae 'ana gaa fai maa 'ana fera ne 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Si Baea, nia 'e liaewane ka too 'i matangakolu. Kameli meli ka suana naa dianaa nia. Ma na dianaa nia nai, na dianaa nia taifili nia naa tii fa 'Alakwa nia naa God. Nia ka faatainia ade dianaa nia fai mamana laa nia tiifau fuakolu. ");
INSERT INTO bvd_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Sa Dion waa ni faasiuabu nia bae mamana sulia si Baea, ma nia ka bae 'urii, “Na waa bae nau ku faarongo tatalo gu mai suli nia ne. Bae nau ku bae 'urii, ‘Tii waa kai dao mai buriku ne 'initoa tasa ka talu nau, suli nia 'e too 'uabaa na mai sui fatai nau kufi futa.’” ");
INSERT INTO bvd_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nia faatainia dianaa baita tasa nia fuakolu, suli nia 'ofe kolu ma ka falea doo diane ki tiifau naa fuakolu sui guu ka lelea firi. ");
INSERT INTO bvd_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Suli God nia falea mai na taki ka lea mai fuakolu 'i 'aba sa Mosis, aia ma na ade dianaa nia fai mamanaa nia ka lea 'ana mai fuakolu 'i 'aba sa Disas Kraes. ");
INSERT INTO bvd_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nao ta waa si suana 'ua God. Taifilia guu fa 'Alakwa 'autania God ne nia God 'ua guu, ma ka too kwaimani 'ua guu fai God, nia ne faatainia God fuakolu. ");
INSERT INTO bvd_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Na toa gwaungai kera toaa Diu ki 'i Durusalem da odua mai waa ni foa ki fai waa ni rao kwai'adomi lae fua waa ni foa ki, uri kera daka ledia sa Dion. Ma daka 'urii, “Nee wala, ma 'oe tii gu nee?” ");
INSERT INTO bvd_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ma sa Dion ka nao si agwaa lau faasi kera. Nia 'e bae folaa fuada ka 'urii, “Nau nee nao lau na Kraes bae ne.” ");
INSERT INTO bvd_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ma kera daka ledia lau daka 'urii, “Sui 'uri nai, ma 'oe sa tii mone 'ana nee? 'Oe sa 'Ilaeja nee, ma nao 'oe sa tii nee?” Nia 'e luu kera ka 'urii, “Sa 'Ilaeja boroi ka nao lau guu.” Ma kera daka ledi lau gu 'urii, “Ma nao 'oe naa 'oto ne brofet bae meli maasia mai?” Sa Dion 'e luu kera ka 'urii, “Brofet nai boroi ka nao lau guu.” ");
INSERT INTO bvd_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ma kera daka ledi 'isi na 'ani nia daka 'urii, “Nee wala, ma sui 'uri nai 'oe sa tii mone 'ana nee? 'O faarongo kameli fasi, uri meli ka faarongoa toaa ne da odu kameli mai. Tee ne 'oe saea suli 'oe fuameli?” ");
INSERT INTO bvd_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Sa Dion 'e luu kera 'ana si baea brofet 'Aesaea nia kedaa mai kada 'i nao ka 'urii, “Nau na lingena wane ne 'ai fuana toae laona fera kwasi ma ka bae 'urii, ‘Na Aofia 'e karangi dao naa! Molu 'olosia taale ki fuana.’” ");
INSERT INTO bvd_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","'I seeri toa nai da lea mai faasia na Faarisii ki daka ledia lau daka 'urii, ");
INSERT INTO bvd_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Lea 'oe nao lau na Kraes, ma ka nao lau sa 'Ilaeja, ma nao sa ta brofet mai 'i nao boroi ka nao lau guu, 'utaa ne 'oko faasiuabua 'amu toae ki?” ");
INSERT INTO bvd_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Sa Dion 'e luu kera ka 'urii, “Nau ku faasiuabua toae ki 'ana kafo gwana. Tii waa ne nia nii gwana 'i matangamolu, ma sui ka nao molu si saitomana guu. ");
INSERT INTO bvd_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Waa nai 'e dao gwana mai buriku, ma sui boroi 'ana, ni nau na luke lana sadol nia ki 'i 'aena boroi nao kusi bobola guu fai ili lana.” ");
INSERT INTO bvd_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Na doo nai ki tiifau da fuli 'ana maefera 'i Betanii ne nii bali kafo loko 'ana tae lana sato 'ana kafo 'i Diodan, kula nai sa Dion nia faasiuabua toae ki ai. ");
INSERT INTO bvd_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","'Afa dani 'i burina guu, sa Dion ka suana kau sa Disas 'e lea na mai siana. Sa Dion ka bae 'urii fua toaa nai, “Molu suana fasi loko, na waa bae nia talafana kale sifsif God gu loko, uri ngali lana abulo ta'aa laa kera toae ki sui guu lao fera ne 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nia waa bae nau ku bae gu mai suli nia loko, bae nau ku bae 'urii, ‘Tii waa kai dao mai buriku. Waa nai 'e 'initoa tasa ka talu nau, suli nia too 'uabaa na mai sui fatai nau kufi futa.’ ");
INSERT INTO bvd_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","'I nao, nau kwasi saitomana lau gwaku ne sa wala nai naa ne Kraes bae. Ma sui boroi 'ana, nau ku lea mai ku faasiuabua naa toae ki 'ana kafo uri toaa nee 'Israel daka saitomana ne sa wala nai nia naa ne Kraes bae.” ");
INSERT INTO bvd_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Sa Dion ka bae lau 'urii, “Nau ku suana naa kada Anoedoo Abu 'e sifo mai mala tafa bole fasi lao salo ma ka dau faafi nia. ");
INSERT INTO bvd_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","'I nao, nau doo kwasi saitomana lau gwaku nai, sui ma God waa ne fale nau ku lea mai uri faasiuabu lae 'ana kafo, nia ka bae 'urii fuaku, ‘Waa ne 'oe suana Anoedoo Abu nia sifo mai ka dau faafi nia nai, nia waa bae uri faasiuabu lae 'ana Anoedoo Abu naa nai.’” ");
INSERT INTO bvd_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ma sa Dion ka bae na 'urii, “Nau ku suana si doo nai 'e fuli naa. Doo ne adea guu ma nau ku faarongo kamolu naa nai. Sa wala nee naa ne 'Alakwa nia God.” ");
INSERT INTO bvd_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","'Afa dani burina lau guu, sa Dion nia uu lau gu 'i seeri 'ana tii si kula nai fainia ta roo waa 'ana toa kwairooi nia ki. ");
INSERT INTO bvd_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Si kada nia suana sa Disas 'e liu kau siada 'i seeri, nia ka bae 'urii, “Suana fasi loko, na waa bae nia talafana kale Sifsif nia God gu loko!” ");
INSERT INTO bvd_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Si kada roo waa kwairooi nai ki da rongo nia bae 'uri nai, keerua sui guu daru ka lea na 'adarua 'i burina sa Disas. ");
INSERT INTO bvd_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Sa Disas nia abulo 'e lio kau, ka suana keerua daru lea na mai burina. Ma nia ka ledi keerua ka 'urii, “Nee roo waa, tee ne muru dooria?” Ma keerua daru ka bae 'urii, “Wala Rabae,” (Rabae toolangainia, waa toolangaidoo), “'Oe doo 'o too gwamu fai nee?” ");
INSERT INTO bvd_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ma nia ka luu keerua ka bae 'urii, “Muru lea mai muru ka tala suai 'amuru.” Keerua daru ka lea na burina, ma daru ka suai naa kula nai nia too ai. Ma keerua daru ka too mai fainia suli fa sato nai. Ma ka dao na kau bobola fainia faina kada sato 'i saulafi. ");
INSERT INTO bvd_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ruana waa 'ana roo waa kwairooi nai ki daru rongo doo nai sa Dion saea suli sa Disas, ma daru ka lea fai sa Disas nai, nia ne sa 'Andru toolana sa Saemon Bita. ");
INSERT INTO bvd_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","'Uri nai guu, si doo sa 'Andru safali ilia gu 'i nao ne nia nani uri dao lae tona na toolana nai sa Saemon Bita, ma faarongo lana lae 'urii, “Kaaria miri dao tona naa Mesaea (toolangainia, Kraes) bae wala. Na waa bae God filia uri 'adomi lana toae ki sui.” ");
INSERT INTO bvd_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","'I seeri, sa 'Andru ka talaia na mai sa Saemon sia sa Disas. Sa Disas 'e bubu tetee 'ana sa Saemon sui ka bae 'urii, “'Oe sa Saemon nee, ne satana maa 'oe sa Dion lau guu, 'ita tari'ina ka oli 'alaa, kera da kai 'aili 'oe naa 'ana sa Kiifas.” Kiifas, na ruana sata da 'ailia 'ana sa Bita ma ka toolangainia, “Fau”. ");
INSERT INTO bvd_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Sui 'afa dani burina lau guu, sa Disas ka manata toi naa lea lae uri bali lolofaa 'i Galilii. Nia dao tona sa Filib, ka bae 'urii fuana, “'O lea mai buriku.” ");
INSERT INTO bvd_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Aia, sa Filib nia waa lau gu mai fasi Betsaeda maefera nai sa 'Andru fai sa Bita. ");
INSERT INTO bvd_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Sa Filib nia dao tona sa Nataniel, ka bae 'urii fua sa Nataniel, “Kameli dao tona naa waa bae sa Mosis kekeda mai suli nia laona taki ma brofet ki lau guu daka kekeda mai suli nia 'ana kada 'i nao. Nia na 'alakwa sa Diosef bae 'i Naasaret gwana bae.” ");
INSERT INTO bvd_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ma sa Nataniel ka bae 'urii, “Fera bae dodolofia ka bobola fainia tasi doo diana ka lea na mai faasia nai!” Ma sa Filib 'e luu nia ka bae 'urii, “Aia lea mai tala suai 'amua.” ");
INSERT INTO bvd_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Si kada sa Disas nia suana sa Nataniel 'e lea gu mai siana, sa Disas ka bae na 'urii, “Sa wala nee nia waa Diu mamana naa ne, ne nao lau ta suke laa 'ani nia!” ");
INSERT INTO bvd_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Sa Nataniel 'e luu nia ka 'urii, “'Oe saitoma 'urifita 'ani nau?” Ma sa Disas 'e luu nia ka bae 'urii fuana, “Nataniel 'ae, nau ku suamu gwaku bae kada bae 'oe nii 'aena fig loko bae, sui fatai sa Filib kafi 'aili 'oe mai.” ");
INSERT INTO bvd_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Si kada sa Nataniel 'e rongo si doo nai, nia ka bae 'urii, “Waa toolangaidoo 'ae, nia mamana, 'oe 'Alakwa God naa ne! 'Oe na waa 'inito kameli toaa Diu naa ne!” ");
INSERT INTO bvd_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Sa Disas ka bae 'urii fuana, “'Oe faamamane nau gwamu suli nau ku saea ku suamu 'aena fig loko 'oto nai? Ku faarongo 'isi 'ani 'oe, si doo baita tasa ki talua fatai si doo nai ne 'okoi suai.” ");
INSERT INTO bvd_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Sui sa Disas ka bae lau 'urii fuada, “Ku faarongo 'isi 'ani kamolu, kamolu kai suana salo nia 'ifi, ma molu kai suana lau guu na 'ensel God ki kera da kai raa 'alaa, ma da kai koso toli mai faafi nau, na 'Alakwa nia Wane.” ");
INSERT INTO bvd_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","'Ana ruana fa dani 'i burina sa Disas 'ailia roo waa baki uri lea lae fai nia, tii faalua ka liu naa 'ana maefera nai 'i Kena lao bali lolofaa 'i Galilii. Na gaa nia sa Disas 'e dao ka nii 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Kera daka kwaiodui kau uri sa Disas fai toa kwairooi nia ki kera dao daka nii lau gu 'i seeri 'aena faalua nai. ");
INSERT INTO bvd_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ma si kada na waen nai da kuufia 'aena faalua nai 'e sui, gaa nia sa Disas ka bae 'urii fuana, “Na waen bae 'e sui, ma ka nao dasi too naa 'ana ta waen lau!” ");
INSERT INTO bvd_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ma sa Disas ka bae 'urii fua gaa nia, “Gaa 'ae, si kada nau 'e nao si dao 'ua ai. Nao 'osi odu nau 'ua uri ili lana tasi doo.” ");
INSERT INTO bvd_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","'Uri nai, gaa nia ka bae na 'urii fua toa ni rao nai ki, “Molu ilia gwamolu si doo ne nia kai saea fuamolu.” ");
INSERT INTO bvd_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Aia, na ono kufidoo baita ni ngali kafo lae ki ne da saungainia 'ana fau da nii 'i seeri 'ana si kada nai. Na kufidoo nai ki na kufidoo ni ngali kafo lae ki uri tau 'aba lae sulia birangaa kera Diu ki. Baita lana kufidoo nai ki, tii kufidoo bobola fainia daka ongia 75 lita, ma nao 115 lita 'ana kafo 'i laona. ");
INSERT INTO bvd_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Sui, sa Disas ka bae 'urii fua toaa ni rao nai ki, “Molu ongia fasi mai kufidoo neki 'ana kafo.” Kera lea daka ongia mai kufidoo nai ki lelea daka fungu 'alamaa guu. ");
INSERT INTO bvd_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Sui sa Disas ka bae lau 'urii fuada, “Molu ongia tasi kafo 'ana kafo nai, ngali kau molu ka faa fua waa ne baita 'ana raoa neki 'ana fafangaa nee.” Kera ngali daka faa na fuana. ");
INSERT INTO bvd_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ma si kada waa baita nai 'ana rao lae ki 'e kuu toi kafo nai 'e tatala sui naa 'ana waen nai, nia ka ulafusia lau gwana 'i fai ne kera ngali mai waen nai faasia. Ma sui toaa ni rao nai da ongia mai kafo nai daka saitomana gwada. 'I seeri, na waa baita nai ka 'ailia na mai fungao falu nai ");
INSERT INTO bvd_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ka bae 'urii fuana, “Nee wala, ma 'oe 'ua ne 'o onia 'amua mai waen diana tasa nee lelea 'ofi ngali gu mai nee! Waa ki sui guu, na waen diane ne da safali faa fasi 'i nao! Na waen lifoo ki gwana ne lea doo daka alua ka tio fasi 'ana uri 'isi, kada ne toae ki da kuufia waen diane lelea ka sui naa. Ma ni 'oe, na waen diana tasa nee 'oko onia 'amua mai uri 'isi 'urii!” ");
INSERT INTO bvd_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Etana gu si doo kwaibalatana ne sa Disas nia ilia 'i Kena lao lolofaa 'i Galilii nai, ne faatainia rigitaa baita tasa ne nia too ai fua toa kwairooi nia ki ma kera daka manata mamana naa 'ani nia. ");
INSERT INTO bvd_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Sui guu, sa Disas fai gaa nia ma toolana ki ma toa kwairooi nia ki, kera daka lea naa uri maefera 'i Kabaneam. Ma kera lea daka too 'i seeri suli ta bara fa dani. ");
INSERT INTO bvd_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Si kada 'e dao karangia naa Fangatasae toaa Diu ki, sa Disas ka lea naa 'i Durusalem. ");
INSERT INTO bvd_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ma nia ka suana toaa nai da usi 'ana 'okona doo ni afuafu lae ki ai laona Beukaua bae. Kera da foli 'ana buluka ki, ma sifsif ki, ma na bole ki. Ma nia ka suana toaa nai kera tatala 'ana malefo ki, kera daka too gwada sia gwegwela kera nai ki ni usi lae. ");
INSERT INTO bvd_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","'Uri nai, nia ka neelia tii neeli baita ni kwai nangasi lae ai, sui ka taria naa 'aini buluka nai ki, ma sifsif nai ki, ma doo nai ki tiifau faasia lao Beukaua bae. Ma nia ka kefusia naa gwegwela kera ki toaa ni tatala lae 'ana malefo ki, ma liu ka taga naa 'ana malefo kera ki. ");
INSERT INTO bvd_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nia ka kwaetaria naa toaa ne kera foli 'ana bole ki. Ma nia ka bae na 'urii, “'Otolangai kamolu molu ngalia kau 'okona doo nee 'i maa! Nao molu si rokisia Beu nia Maa nau 'ana beu ni usie!” ");
INSERT INTO bvd_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","'I seeri na toa kwairooi nia ki daka manata toi si baea nai lao kekeda laa abu nai 'e bae 'urii, “God 'ae, na liosaua nau fuana Beu 'oe, 'e 'a'ako mala 'ana ta era laona lioku.” ");
INSERT INTO bvd_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Sui na toa gwaungai Diu ki kera daka ledia sa Disas daka 'urii, “Nee wala, sa tii gu ne falea rigitaa fuamu uri ili lana doo neki nee? Lea God ne falea rigitaa nee fuamu, 'oko ilia fasi tasi doo kwaibalatana uri meli ka suai ma meli ka faamamane 'oe fainia!” ");
INSERT INTO bvd_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Sa Disas 'e luu kera ka 'urii, “Lea molu ka okosia boroi Beukaua nee, nau kwai saungainia lau gwaku lao olu fa sato guu.” ");
INSERT INTO bvd_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ma kera daka ledi nia lau daka 'urii, “'Oe waa 'o bobola boroi fai saungai lana beukaua nee lao olu fa sato ki nee? Na beu nee mone, na faitaafuli fa ngali ma ono fa ngali sarenga ki fatai ne da saungainia mai sulia!” ");
INSERT INTO bvd_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ma sui ta, na Beukaua nai sa Disas nia bae sulia nai, na nonina 'i tala'ana lau 'ana nai. ");
INSERT INTO bvd_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Toa kwairooi sa Disas ki kera totoo lea ka dao 'ana si kada bae God 'e tataea sa Disas faasia maea naa, kera dafi manata toi si doo nai nia saea, ma kera dafi faamamanea na Kekeda laa Abu ki fainia si baea nai ki sa Disas saea nai. ");
INSERT INTO bvd_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ma si kada nai sa Disas nia too 'i Durusalem 'ana Fangatasae nai, toaa 'oro da manata mamana 'ani nia suli da suai fafaataia kwaibalatana nai ki nia fulia. ");
INSERT INTO bvd_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Sui ma, sa Disas nao si faamamane kera guu, suli nia saitomana gwana lioda ki. ");
INSERT INTO bvd_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nia saitomana sui naa liona wane, ka nao si bobola naa uri sae ta waa ka faarongo nia fatai 'ana tasi doo sulia. ");
INSERT INTO bvd_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Aia tii si kada, tii waa gwaungai toaa Diu ki, nia lea mai siana sa Disas. Na waa nai satana sa Nikodimas, ma nia ta waa 'ana Faarisii ki lau guu. Nia lea mai dao siana sa Disas lao rodo ka bae 'urii fuana, “Waa toolangaidoo 'ae, kameli meli saitomana 'oe naa ne waa toolangaidoo ne God fale 'oe mai. Ma na doo kwaibalatana neki 'oe fulia ki, nia 'afitai fua ta waa tatakwai gwana ne God nao si nii gu fainia ka ilia ki.” ");
INSERT INTO bvd_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Sa Disas 'e luu nia ka bae 'urii, “Ku faarongo 'isi 'ani 'oe, tii ne nia nao si futa faalu, nia 'afitai ka too lao 'initoaa God.” ");
INSERT INTO bvd_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ma sa Nikodimas ka ledia sa Disas ka bae 'urii, “Nee wala, ma lea na waa baite ka rafo naa, tara nia ka futa faalu lau 'utaa nai? Wane 'afitai 'asia naa sae oli ka ruu lau lao ruruuna gaa nia ma ka futa faalu lau mai!” ");
INSERT INTO bvd_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Sa Disas ka bae 'urii fuana, “Ku faarongo 'isi 'ani 'oe, nia 'afitai 'asia naa fua waa ka ruu lao 'initoaa nia God, lelea waa nao si futa faalu guu 'ana kafo ma 'ana Anoedoo Abu. ");
INSERT INTO bvd_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Waa ne wane 'ana fera ne 'i saegano 'e kwalafia, nia na waa 'ana fera ne 'i saegano gwana. Ma na waa ne Anoedoo Abu nia God 'e falea mauria falu fuana, nia ne waa 'ana fera 'i salo. ");
INSERT INTO bvd_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nao 'osi kwele lau gwamu suli si doo nai nau ku saea ma ku bae 'urii fuamu nai, ‘Molu futa faalu lau’. ");
INSERT INTO bvd_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Na rao lana Anoedoo Abu 'e mala 'ana rao lana koburu. Na koburu nia liu 'ana suli doori lana, ma 'oko rongo gwamu kuruu lana. Sui boroi 'ana, 'oe 'afitai 'oko suana kula nia too ai ma kula nia lea uria. Talafana lau guu rao lana Anoedoo Abu 'ana mauria nia wane nai. Sui boroi 'ana nia ka talana mauria wane, 'oe 'afitai 'oko suana ili laa ne nia ilia ai.” ");
INSERT INTO bvd_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Sa Nikodimas ka ledia lau ka bae 'urii, “Wala 'ae, si doo nai tara ka fuli 'utaa gu nai?” ");
INSERT INTO bvd_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Sa Disas 'e luu nia ka 'urii, “'Oe na waa ni toolangaidoo lae fua toaa nee 'Israel naa ne, ma sui ka nao 'osi filoa gu si doo nai! ");
INSERT INTO bvd_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ku faarongo 'isi 'ani 'oe, kameli si doo ne meli tala suai mai ma meli ka tala saitomana naa, nia ne meli saea ma meli ka bae 'ana faamamane lana fuamolu nee, ma sui ka nao molu si doori faamamanea guu. ");
INSERT INTO bvd_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Na doo da fuli ki lao fera ne 'i saegano gwana nai ku bae sulia fuamolu nai, ma sui ka nao molu si doori faamamanea guu. Nia 'uri nai, lea nau ku faarongo kamolu 'ana dongana fera 'i salo, tara nia 'afitai 'asia naa fuamolu uri molu ka doori faamamanea. ");
INSERT INTO bvd_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nao ta waa 'e raa si too gu mai 'i salo uri nia ka faarongo kamolu lau guu 'ana dongana fera 'i salo. Ni nau 'Alakwa nia Wane, taifili nau gu ne ku sifo mai fasi 'i salo. ");
INSERT INTO bvd_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“'Ana kada 'i nao, sa Mosis nia saungainia tii loi 'ana bras ka daurangainia 'i langi gwauna bae'ai lao fera kwasi. Talafana lau guu si doo totoo kai fuli 'ani nau nai. Tara kera da kai daurangai nau 'Alakwa nia Wane 'i langi, ");
INSERT INTO bvd_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","uri tii gwana ne nia manata mamana 'ani nau, nia ka too 'ana mauria firi. ");
INSERT INTO bvd_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","God nia liosau 'asia naa 'ana wane laona fera ne 'i saegano, nia ka falea mai tii fa 'Alakwa 'autania nia uri tii gwana ne manata mamana 'ani nia, nia ka nao si funu. Nia 'e too naa 'ana mauria firi. ");
INSERT INTO bvd_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God, nia nao si falea mai 'Alakwa nia uri laona fera ne 'i saegano uri kwae lana wane laona fera ne 'i saegano. God nia fale nia lau 'ana mai uri ka faamauri kera. ");
INSERT INTO bvd_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Waa ne manata mamana 'ana 'Alakwa nia God, God 'afitai ka fale kwakwaea fuana. Aia ma waa ne nao si manata mamana 'ana 'Alakwa God, waa nai 'ana ne maasia naa kwakwaea God fuana, suli nia nao si manata mamana 'ana tii fa 'Alakwa 'autania nia God. ");
INSERT INTO bvd_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Doo ne adea ma God ka falea kwakwaea, nia 'urii ne. Na kwesu 'e dao naa lao fera ne 'i saegano, ma sui wane ka dooria 'ana rorodoa lae ma ka ote nia 'ana kwesu nai suli na abulo lana wane 'e ta'aa. ");
INSERT INTO bvd_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Suli waa ne nia ilia doo garo ki, nia ne ote nia lea mai siana kwesu, ade lea kwesu ka faatai folaa 'ana garoa nia ki. ");
INSERT INTO bvd_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Aia ma waa ne nia ilia doo 'o'olo ki, nia 'ana ne lea mai siana kwesu, uri kwesu ka faatai folaa 'ana ade lana ne lea sulia doori lana God.” ");
INSERT INTO bvd_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","'I burina gwana si doo nai, sa Disas fainia toa kwairooi nia ki kera daka lea naa uri bali lolofaa 'i Diudia. Ma kera daka too 'i seeri daka faasiuabua naa toae ki. ");
INSERT INTO bvd_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Aia 'ana si kada nai, sa Dion 'e faasiuabua toae ki 'ana maefera nai 'i 'Aenon karangia 'i Saalim, kula kafo nia 'oro ai. Ma toaa nai kera daka dao mai siana sa Dion ka lelea gwana uri nia ka faasiuabu kera. ");
INSERT INTO bvd_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Si kada kera nao dasi alua 'ua sa Dion laona lookafo nai. ");
INSERT INTO bvd_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ma 'ana si kada nai, tai waa 'ana toa kwairooi sa Dion ki, kera daka olisusuu fainia tii waa 'ana toa Diu ki sulia birangaa kera Diu ki 'ana faafaalu lae 'ana kafo. ");
INSERT INTO bvd_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","'Uri nai, waa kwairooi sa Dion ki kera daka lea siana sa Dion ma daka bae 'urii, “Waa ni toolangaidoo 'ae, 'oe saitomana waa bae nia uu fai 'oe bali lobae 'ana kafo 'i Diodan ma 'oko faarongoa toae ki suli nia? Kada nai, nia faasiuabua naa toae ki nai, ma 'oro lana toaa bae sui naa daka lea tiifau na kau siana!” ");
INSERT INTO bvd_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ma sa Dion 'e luu kera ka 'urii, “Na wane, si doo God faa gwana fuana ne nia too ai. ");
INSERT INTO bvd_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kamolu sui guu molu rongo nau ku saea sui naa bae, nau nao lau na Kraes bae, na waa fifilia bae God ne. Nau na waa ku lae mai 'i nao 'ani nia uri ku faarongo tatalo 'ani nia 'ana ne. ");
INSERT INTO bvd_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Na Kraes bae, nia mala 'ana ta fungao 'ua guu waa ne nia arai ka too 'ana keni. Ma ni nau ku mala 'ana waa kwaimani nia fungao nai, ne ku noni sasala 'ana si kada ku rongoa ne fungao nia dao naa fua arai laa nia. Ma ni nau ku ele 'asia naa 'i tari'ina si kada ku suana toaa 'oro ki da lea naa burina sa Disas. ");
INSERT INTO bvd_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Alu talo lana satana Kraes ka baita ka lea naa, ma na talo lana sataku ka oli tu'uu na mai. ");
INSERT INTO bvd_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Iuka, na Kraes nia lea mai faasia 'i salo ma ka 'inito tasa, suli na waa ne nia lea mai faasia 'i salo, nia 'initoa ka tasa 'ana waa ki sui guu. Sa Dion waa ni faasiuabu na waa lao fera ne 'i saegano gwana, ma nia ka bae lau guu sulia si doo ki lao fera ne 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Na Kraes, nia bae sulia si doo ne nia tala suai ki mai ma ka tala rongo ki mai 'i salo. Ma sui boroi 'ana, nao ta waa si dooria guu faamamane lana doo ne nia saea ki. ");
INSERT INTO bvd_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ma tii gwana ne nia faamamanea si doo ne na Kraes 'e saea ki, na waa nai nia faatainia God 'e bae mamana. ");
INSERT INTO bvd_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ma na Kraes nai ne God fale nia mai faasia 'i salo, ma nia ka faatalongainia na baea mamane sulia God, suli God nia fale dangatai mai 'ana Anoedoo Abu nia fua Kraes. ");
INSERT INTO bvd_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ma God na Maa ka liosau 'asia naa 'ana 'Alakwa nia nai, ma ka alu nia ka gwaungai faafia doo nia ki tiifau. ");
INSERT INTO bvd_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tii gwana ne manata mamana 'ana 'Alakwa nia God, na mauria God 'e nii 'ana waa nai. Ma tii gwana ne nia nao si ade suli 'Alakwa nia God, waa nai 'afitai ka dao toi mauri firi. Na rakesasua God 'ana ne dau faafia waa nai.” ");
INSERT INTO bvd_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Na Faarisii ki da rongo alinga ai saea sa Disas nia faasiuabua ma ka talaia toaa 'oro 'asia naa ka talua lau toaa kwairooi sa Dion ki. ");
INSERT INTO bvd_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ma sui sa Disas, nia nao lau ne faasiuabua toae ki, na toa kwairooi nia ki 'ana ne da ilia si raoa nai. ");
INSERT INTO bvd_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Si kada sa Disas 'e saitomana kera da manata 'uri nai fuana, nia fai toa kwairooi nia ki kera daka faasia bali lolofaa nai 'i Diudia daka oli lau uri lao bali lolofaa 'i Galilii. ");
INSERT INTO bvd_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Si kada kera da lea naa uri Galilii, kera tasa daka liu kau lao bali lolofaa 'i Samaria. ");
INSERT INTO bvd_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ma kera daka dao 'ana maefera nai satana 'i Saekaa laona bali lolofaa nai 'i Samaria. Saekaa 'e nii gwana 'i ninimana si gano sa Diakab nia faa 'ua na mai fua 'alakwa nia sa Diosef. ");
INSERT INTO bvd_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ma na kilukafo nai sa Diakab 'elia ka nii lau guu 'i seeri. Sa Disas nia lea kau lelea ka lede nia 'asia naa, nia ka gooru naa ninimana kilukafo nai. Ma si kada nai, ka dao naa bobola fainia lao tofungana sato. ");
INSERT INTO bvd_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","'I seeri tii wela keni Samaria nai ka dao maa kilukafo nai uri ufi kafo lae 'ana. Sa Disas ka gani kafo siana ka bae 'urii, “Ongia fasi mai tasi kafo nau ku kuu fasi wala.” ");
INSERT INTO bvd_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Nia bae 'uri nai suli toa kwairooi nia ki, kera da lea kau uri foli fanga lae daka nii 'ua mai lao maefera nai 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ma na wela keni nai 'e luua sa Disas ka 'urii, “'Oi, 'oe na waa Diu nee, 'utaa ne 'oko gani kafo siaku nau ai Samaria?” Nia bae 'uri nai, suli toaa Diu ki da mamagutainia 'asia naa toaa Samaria. ");
INSERT INTO bvd_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ma sa Disas ka luu nia ka 'urii, “'Oe sa 'o saitomana mone na fale laa nia God, ma sa 'oko saitomaku mone nau waa ne ku gani kafo siamu nee, doo 'oe gani nau ne wala, uri nau ku falea kafo 'ana mauria fuamu.” ");
INSERT INTO bvd_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Na wela keni nai ka bae 'urii fuana, “Nee wala, ma 'oe nao 'osi too guu 'ana ta kufidoo ni ongi kafo lae, ma na kilukafo loko lau guu 'e sifo 'asia naa. Kafo 'ana mauria nai tara 'oe 'oko ngali gwamu mai fasi fai? ");
INSERT INTO bvd_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","'Oe 'o manata toi ni 'oe 'oto ne 'o 'initoa ka talua kokoo kameli sa Diakab waa ne falea kilukafo nee fuameli? Ni nia fai 'alakwa nia ki, ma na manusaarea nia ki tiifau naa ne da kuu mai 'ana kilukafo nee 'i nao.” ");
INSERT INTO bvd_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ma sa Disas ka bae 'urii, “Waa ne nia kuufia kafo nee 'oe ufia nee, nia kai maeli kuu lau gwana. ");
INSERT INTO bvd_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Aia ma waa ne nia kuufia na kafo ne nau kwai falea fuana, nia 'afitai ka maeli kuu lau. Suli na kafo nai ku falea fuana kai alua na busu 'ana mauria firi, ne fulafula mai 'i laona mauria nia waa nai.” ");
INSERT INTO bvd_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ma na wela keni nai ka bae 'urii, “Waa baita kani 'ae, 'o faa mai kafo nai fuaku uri nao kwasi maeli kuu naa ma kwasi lea lau mai uri ngali kafo lae 'i seki.” ");
INSERT INTO bvd_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Sa Disas ka bae 'urii fuana, “Lea kau 'oko odua mai arai 'oe muru ka lea mai seki.” ");
INSERT INTO bvd_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ma na wela keni nai ka bae 'urii, “Nau nao kwasi too 'ana ta arai.” Sa Disas ka bae 'urii, “Doo mamane na 'oe saea nao 'amua ta arai. ");
INSERT INTO bvd_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Suli ni 'oe, na lima waa ne 'o too sui na mai 'aeda. Na waa ne 'oe too 'i 'aena boroi kada nai, nia nao lau arai 'oe. Doo nai 'oe saea fuaku nia mamana.” ");
INSERT INTO bvd_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ma na wela keni nai ka luua ka 'urii, “Waa baita kani 'ae, nau kwafi saitomana guu ne 'oe na brofet nai. ");
INSERT INTO bvd_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Na kokoo kameli ki toaa 'i Samaria, kera da foosia mai God 'i gwauna fa uo nee 'ana kada 'i nao. Ma sui kamolu toaa Diu ki, molu ka saea sa kula fua foosi lana God 'ana ai ne 'i Durusalem.” ");
INSERT INTO bvd_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ma sa Disas ka bae 'urii fuana, “Wela keni nee 'ae, 'o faamamanea 'amua si doo ne nau ku saea nee, 'ana si kada ne kolu kai dao ai, toae ki kera da kai foosia God na Maa 'ana kule ki sui gwana, nao lau otona gwana 'i gwauna fa uo nee ma nao sae 'i Durusalem. ");
INSERT INTO bvd_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kamolu toaa 'i Samaria molu ulafusia lau gwamolua God ne molu foosia. Aia ma ni kameli toaa Diu ki meli saitomana God kameli ne meli foosia. Suli na taala ne God 'e kwaia uri faamauri lana toae ki sui guu ai, nia lea kau faasi kameli toaa Diu. ");
INSERT INTO bvd_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Aia, tii si kada ne karangi kai dao mai, ma ka safali dao naa nee! Si kada nai ne, toaa ne da foosi mamana 'ana God, na Anoedoo nia kai talai kera 'ana foosi lana God na Maa 'ana lea laa ne mamana. Na kwaini toaa 'uri nai ne God na Maa 'e dooria uri daka foosi nia. ");
INSERT INTO bvd_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God, nia na Anoedoo ma na toaa ne da foosi nia, na Anoedoo ka talai kera na mone 'ana foosi lana God ma daka ilia na mone sulia lea laa ne mamana.” ");
INSERT INTO bvd_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ma na wela keni nai ka bae 'urii fuana, “Nau ku saitomana gwaku ne na Waa Fifilia God ne da 'ailia lau guu 'ana Kraes, nia kai dao mai. Ma si kada nia dao, nia ne kai faarongo kia 'ana doo ki sui guu.” ");
INSERT INTO bvd_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Sa Disas 'e luua ka 'urii, “Tee nau waa nai naa nee, ne kwai bae gwaku fai 'oe nee.” ");
INSERT INTO bvd_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","'Ana si kada nai guu toa kwairooi nia sa Disas ki oli mai daka dao naa. Ma kera daka kwele lau gwada ne nia bae fai wela keni nai. Sui boroi 'ana nao ta waa ada si 'urii guu, “Tee bae 'o dooria siana?” Ma nao sae kera daka ledi 'urii, “'Utaa bae 'oko bae fai ai bae?” ");
INSERT INTO bvd_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","'Uri nai, na wela keni bae ka faasia kufidoo ni ongi kafo nai ka tio gwana 'i seeri, nia ka oli na uri lao maefera baita nai. Lea kau dao, ka bae 'urii fuana toaa nai, ");
INSERT INTO bvd_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Rowane 'ae, molu lea mai molu suana fasi na waa loko nia faarongo nau 'ana doo ku ilia ki tasi doo si tio naa loko! Alamia nia na Waa Filia bae God naa 'oto loko?” ");
INSERT INTO bvd_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ma kera daka lea na mai siana sa Disas fasi lao maefera nai. ");
INSERT INTO bvd_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Otofana si kada nai gwana, na toa kwairooi nia sa Disas ki daka bae 'urii fuana, “Waa ni toolangaidoo 'ae, 'o 'ani fasi tasi fanga wala!” ");
INSERT INTO bvd_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ma sa Disas 'e luu kera ka 'urii, “Nau ku too 'ana fanga nau ni 'ani lana ne kamolu molu ulafusia gwamolua.” ");
INSERT INTO bvd_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Na toa kwairooi nia ki kera daka ledi kera kwailiu daka 'urii 'ada, “Alamia ta waa ngali fanga mai fuana 'oto ne?” ");
INSERT INTO bvd_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ma sa Disas ka bae 'urii fuada, “Na talafana si fanga nau ni 'ani lana naa ne ili lae sulia doori lana God ne fale nau mai, ma faasui lana si raoa ne nia odu nau mai uria. ");
INSERT INTO bvd_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Aia, si tarifulaa kamolu 'ana bae nia 'urii, ‘Fai madama ki fatai nii 'ua sui kafi dao 'ana si kada raku 'e maua ai fua koni doo lae.’ Nau mone ku faarongo kamolu, molu aoa maa molu molu ka suai fasi nee. Na raku 'e maua ka kwaimaasi naa nee. Tee talafana fange maua naa ne toaa neki da lea na mai nee. ");
INSERT INTO bvd_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Tii ne nia falia naa fungina doo ne maua ki naa nee fua lao mauria firi, God kai falea fofolia nia. Nia 'uri nai, na waa fasidoo fai waa koni doo, keerua sui guu daru kai ele kwaimani. ");
INSERT INTO bvd_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Si doo mamane bae na tarifulaa bae nia bae 'urii sulia, ‘Ta waa, na raoa nia fua fasidoo lae naa, ma ta waa lau gwana, na raoa nia fua koni doo lae naa, 'ana fali lana fungidoo ki kada kera maua naa.’ ");
INSERT INTO bvd_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nau ku fale kamolu kau uri lea molu ka falia naa fungidoo maua ki laona ola ne kamolu nao molu si fasia gu mai nai. Suli tai waa lau gwana ne kera da fasia mai, ma ni kamolu molu ka koni doo 'i gwauna si rao nonifii laa kera ki mai.” ");
INSERT INTO bvd_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","'I seeri, toaa 'oro laona bali lolofaa nai 'i Samaria, kera daka manata mamana naa 'ana sa Disas, maana si baea nai wela keni nai 'e saea ka 'urii, “Nia faarongo nau 'ana doo ku ilia ki mai tasi doo si tio naa!” ");
INSERT INTO bvd_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ma si kada kera da dao siana sa Disas, kera daka radi kali nia uri ka too fasi 'ana fai kera. Ma sa Disas ka too lau 'i seeri suli roo fa dani. ");
INSERT INTO bvd_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Toaa 'oro ki lau daka manata mamana 'ana sa Disas suli da rongoa doo nia bae ki sulia. ");
INSERT INTO bvd_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ma kera daka bae 'urii fua wela keni nai, “Kameli meli manata mamana naa 'ana sa wala nee, sui ta nao lau otona gwana fafona si doo bae 'oe saea fuameli. Meli manata mamana lau gu 'ani nia, fafona ne kameli meli tala rongo guu bae lana, ma meli ka tala saitomana guu nia na Waa Kwai faamauri fua toae ki sui guu lao fera ne 'i saegano.” ");
INSERT INTO bvd_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Burina sa Disas fainia toa kwairooi nia ki kera too 'ana maefera nai suli roo fa dani ki sui, kera daka lea naa uri lao bali lolofaa 'i Galilii. ");
INSERT INTO bvd_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Sa Disas 'i tala'ana 'e bae mai 'urii fuada, “Na brofet, na toaa nia 'ua guu 'i fera nia nao kera dasi sae'inito gu 'ani nia.” ");
INSERT INTO bvd_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ma sui boroi 'ana si kada sa Disas 'e oli mai ka dao naa 'i Galilii, na toaa nai 'i Galilii daka ele 'asia naa suli nia, suli kera da lea daka too mai 'ana Fangatasaa bae 'i Durusalem ma daka suana sui na mai doo nai ki sa Disas ilia ki mai 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Sa Disas oli ka dao lau guu 'ana maefera bae 'i Kena lao bali lolofaa 'i Galilii, kula bae nia rokitainia kafo bae ai oli ka alu waen. Ma tii waa 'inito fasi maefera 'i Kabaneam, na 'alakwa nia ka matai baita 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ma si kada waa nai 'e rongo sa Disas nia too mai Diudia ma oli mai ka dao naa 'i Galilii, nia ka lea mai ka dao siana. Ma nia ka radi 'aena sa Disas uri ka lea fainia uri 'i Kabaneam, uri ka guraa 'alakwa nia nai 'e matai ma karangi kai mae naa. ");
INSERT INTO bvd_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Si ili laa nai gu ne adea ma sa Disas ka bae 'urii fuana, “Kamolu nee, molu 'ii uria lea sae molu ka suai fatai doo kwaibalatana ki ne molu kafi manata mamana 'ani nau nee.” ");
INSERT INTO bvd_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Si kada sa Disas 'e bae 'uri nai, sa wala nai ka bae 'ana 'urii fua sa Disas, “Waa baita kani 'ae, 'o lea na mai, ade lea 'alakwa nau ka mae.” ");
INSERT INTO bvd_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Sui sa Disas ka bae 'urii fuana, “Oli 'amua kau, 'alakwa 'oe nia 'akwaa naa na.” Ma sa wala nai ka faamamanea bae lana sa Disas, ma nia ka lea naa. ");
INSERT INTO bvd_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Si kada nia oli kau ka dao suli taale, nia ka dao tona waa ni rao nia ki, ne kera da lae mai burina uri faarongo lana, ma kera daka bae 'urii, “Arai nee 'ae, na 'alakwa 'oe nia mauri naa!” ");
INSERT INTO bvd_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ma na waa 'inito nai ka ledi 'urii 'ani kera, “Kada sato tee ne 'alakwa nau nia 'akwaa ai?” Kera luu nia daka bae 'urii, “Na 'a'ako laa bae nia sui gu faasi nia 'i rooki 'ana etana kada sato oli uri saulafi.” ");
INSERT INTO bvd_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ma na maa nia wela nai ka saitomana naa si kada sato nai lau gu ne sa Disas nia bae mai 'urii fuana ai, “Na 'alakwa 'oe mauri gwana.” Ma na waa baita nai fai toaa nia ki sui guu 'i luma nia daka manata mamana 'ana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Burina sa Disas 'e oli mai fasi bali lolofaa 'i Diudia ka dao lao bali lolofaa 'i Galilii, ruana si doo kwaibalatana ne nia ilia gu nai. ");
INSERT INTO bvd_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","'I burina si doo nai sui, tii fafangaa kera toaa Diu ki ka liu lau guu, ma sa Disas ka lea lau guu 'uri Durusalem. ");
INSERT INTO bvd_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Aia, tii maematakwa baita kera da saungainia 'e nii gwana karangia maesakaa nai sifsif ki 'i seeri lao maefera baita 'i Durusalem. Aia 'ana baea toaa Diu, maematakwa nai satana 'i Betsaeda. Na lima kada tafasusu tikwa ki lau guu ne kera da tolea ka nii 'i ninimana maematakwa nai. ");
INSERT INTO bvd_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Aia, ma toaa 'oro mamana guu ne kera da too 'ana mataia 'e'ete 'oro ki sui gwana ne kera nii lao tafasusu nai ki: Toaa nai ki kera toaa maada rodo ki, toaa 'abada mae ki ma toaa 'aeda mae ki. ");
INSERT INTO bvd_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ta tii waa 'ani kera 'i seeri, nia 'e ta'aa mai suli olu taafuli fa ngali ma kwalu fa ngali sarenga ki. ");
INSERT INTO bvd_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Sa Disas 'e suana waa nai 'e too gwana 'i seeri, nia ka saitomana sa wala nai nia matai mai ka tau 'asia naa. Sa Disas ka ledia sa wala nai ka 'urii, “Nee wala, 'oe 'o doori 'akwaa?” ");
INSERT INTO bvd_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ma sa wala nai 'e matai nai ka luua sa Disas ka 'urii, “Waa baite kani 'ae, nau gu ne nao kwasi too naa 'ana ta waa uri ka ngali nau kau uri lao matakwa fuu 'ana si kada 'e gitogito ki. 'Ana si kada ki sui guu ne nau ku sasi fai lea lae uri lao matakwa fuu, ade 'uri nai ta waa ka liu lau gwana suusi nau ka koso 'ana lao kafo, ma nau ka nao guu.” ");
INSERT INTO bvd_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Sa Disas ka bae 'urii, “Tatae mai 'oko ngalia ifitai 'oe ni tio, fali 'oko lea 'amua.” ");
INSERT INTO bvd_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ma 'ana si kada nai 'ua guu, sa wala nai ka 'akwaa naa, ka tatae ka ngalia ifitai nia ka lea na 'ana. Aia fa dani Sabat gwana nai si doo nai fuli ai. ");
INSERT INTO bvd_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Doo ne adea guu, toa gwaungai Diu ki, kera daka bae 'urii naa fua waa nai sa Disas guraa nai, “Nee wala, fa dani sabat doo bae abu dasi ili tasi raoa ai ne 'i tari'ina, ma sui 'oko ngali gwamu ifitai 'oe nee ai!” ");
INSERT INTO bvd_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Sa wala nai ka bae 'ana 'urii fuada, “Tii waa ne gura nau ma ka saea nau ku ngalia ifitai nau ma ku fali ku lea na 'aku.” ");
INSERT INTO bvd_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Kera daka ledia lau daka 'urii, “Waa nai sa tii nai, ne saea 'oko ilia si doo nai?” ");
INSERT INTO bvd_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ma sa wala nai ka ulafusia lau gwana tii nai gura nia nai, suli sa Disas boroi 'e lea kwai dolali na 'ana lao konia nai. ");
INSERT INTO bvd_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Totoo si kada 'i buri naa, sa Disas kafi dao tona waa nai lao Beukaua bae ma ka bae 'urii fuana, “'O fafurongo diana fasi ku faarongo 'oe, kada nee 'oe too diana naa nai. Nao 'osi ili lau tasi doo garo, ade lea tasi doo ta'aa ka tasa fatai kafi dao tomu.” ");
INSERT INTO bvd_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Sa wala nai 'e lea gu kau fasi lao Beukaua nai, liu ka faarongoa toa gwaungai Diu ki ne sa Disas gwana ne gura nia nai. ");
INSERT INTO bvd_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Maana nai sa Disas 'e ilia si doo nai 'afa dani Sabat, toa gwaungai kera Diu ki daka malimae naa 'ana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ma sa Disas ka bae 'urii fuada, “Nau ku rao lau guu 'afa dani ki sui guu mala 'ana Maa nau.” ");
INSERT INTO bvd_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Aia, ma si baea nai ki da adea toa gwaungai Diu ki daka manata fifii naa uri saumaeli lana sa Disas, suli da saea nia 'oia si baea fifii suli Sabat. Ta ruana si doo, nia saea nia maa 'ana God ma ka faabolatainia fai God. ");
INSERT INTO bvd_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ma sa Disas 'e luu kera ka 'urii, “Ku faarongo mamana 'ani kamolu. Nau, na 'Alakwa God, 'afitai ku ilia tasi doo 'i tala'aku. Si doo ne nau ku suana Maa nau 'e ilia, nia lau gu ne nau ku ilia. Suli 'e 'urii, tasi tee gwana ne Maa nau 'e ilia, nau ku ilia lau guu. ");
INSERT INTO bvd_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Suli Maa nau nia liosau 'ani nau, ka faatainia doo neki sui guu siaku ne nia ilia ki. Ma nia kai faatainia lau guu siaku na raoa ne baita ka talua fatai doo neki nee. Ma ni kamolu molu kai kwele tasa 'ana doo baita nai ki nau kwai ilia ki. ");
INSERT INTO bvd_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ni nau na 'Alakwa, nau kwai tataea toaa mae ki fasi maea ma kwai falea mauria fuada, mala lau guu ne Maa nau 'e tataea toaa mae ki ma ka faamauri kera. Ma ni nau kwai falea mauria fua tii gwana ne nau ku doori faa lae fuana. ");
INSERT INTO bvd_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tasi doo lau guu, Maa nau nia nao si fale kwakwaea fua ta waa, suli nia fale sui naa rigitaa nai fuaku nau 'Alakwa nia, uri nau ku kwaea toaa ki sui. ");
INSERT INTO bvd_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Uri toae ki sui guu daka faa'inito nau fai Maa nau ka bobola guu. Waa ne nao si faa'inito nau, nia nao si faa'initoaa lau gu Maa nau ne fale nau mai. ");
INSERT INTO bvd_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ku faarongo mamana 'ani kamolu. Waa ne nia rongo suli bae laku, ma ka manata mamana 'ana God ne fale nau mai, nia ne too 'ana mauria firi. Waa nai tara nao si liu lao kwakwaea, nao. Nia 'e tala fasi lao maea, ka dao laona mauria firi. ");
INSERT INTO bvd_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ku faarongo mamana 'ani kamolu, 'ana si kada kolu kai dao ai, ne safali na 'i tari'ina, na waa mae naa boroi nia kai rongoa lingeku, na 'Alakwa God. Ma toaa ne kera da rongoa lingeku, kera da kai mauri. ");
INSERT INTO bvd_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Na maa nau, nia na gwaufutona mauria. Nia ka falea naa rigitaa fuaku uri nau lau guu na gwaufutona mauria, sulia nau na 'Alakwa nia. ");
INSERT INTO bvd_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ma na Maa nau ka falea naa rigitaa fuaku, uri nau ku falea kwakwaea fua wane, suli nau na 'Alakwa nia Wane. ");
INSERT INTO bvd_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ade molu ka kwele 'ana si doo nai, suli si kada kolu kai dao ai, na toaa mae ki sui guu ne da tio naa lao kilu kera ki boroi, kera da kai rongoa lingeku ");
INSERT INTO bvd_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ma da kai ruu 'i maa fasi lao kilu ki. Toaa ne kera ilia mai doo diane ki, kera da kai tatae daka lea uri lao maurie, ma toaa ne kera ilia mai doo ta'ae ki, kera da kai tatae daka lea uri lao kwakwaea. ");
INSERT INTO bvd_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nau 'afitai ku ili tasi doo suli lioku tala'aku. Nau ku falea kwakwaea ki suli doo ku rongo Maa nau saea uri ku ilia. Nia ne adea na kwakwaea ne nau ku falea ki ka lea 'o'olo, suli nau ku lea suli liona Maa nau waa ne fale nau mai, ma ka nao lau suli lioku 'i tala'aku. ");
INSERT INTO bvd_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Lea sae nau gwana taifili nau ne ku saea si doo nai suli nau, 'uri nai bae laku ka nao si 'initoa guu. ");
INSERT INTO bvd_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Sui ma ta ruana waa ne bae suli nau 'e too lau guu. Ma nau ku saitoma diana ai, na doo ne nia saea na doo mamane sui naa. ");
INSERT INTO bvd_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Aia, ni kamolu molu fale kau toa kamolu ki daka lea kau siana sa Dion bae, ma nia ka faarongo kamolu 'ana doo mamana baki suli nau. ");
INSERT INTO bvd_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nau ku fuutona sa Dion nao lau duungana nau ku nani uri ta waa 'ana fera ne 'i saegano uri ka babasi nau. Nau ku saea lau 'aku 'uri nai uri kamolu ka manata mamana ma God ka faamauri kamolu. ");
INSERT INTO bvd_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ma sa Dion nia 'e mala 'ana tafa kwesu ne kwesu folaa, ma kamolu molu ka ele suli si doo nia saea 'ana si kada kukuru. ");
INSERT INTO bvd_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ni nau ku too 'ana doo talingai ki lau uri waa ka suai ka manata mamana 'ani nau. Doo nai ki kera talingaia ka talua fatai si baea sa Dion saea: Doo nai naa ne raoa nee Maa nau fale nau mai uri ili lana, ne nau ku ilia naa nee lelea ku faasuia guu. Nia ne faatainia Maa nau 'e fale nau ku lea mai. ");
INSERT INTO bvd_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Maa nau waa ne fale nau mai, nia 'e faamamane nau. Kamolu nao molu si rongo 'ua lingena, ka nao molu si suana 'ua maana, ");
INSERT INTO bvd_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ka nao molu si dau 'ua faafia bae lana lao mauria kamolu ki, suli nao molu si faamamane nau 'ua waa ne nia fale nau mai. ");
INSERT INTO bvd_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kamolu mone molu teemai molu ka nani muusia naa lao kekeda laa Abu ki, suli molu kwaifii 'amolua sae ade lae 'uri nai ne kamolu kai dao toi mauria God ai. Na kekeda laa Abu nai ki da saea doo mamane suli nau. ");
INSERT INTO bvd_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ma sui kamolu ka nao molu si dooria guu lea lae mai siaku uri nau ku faa maurie fuamolu. ");
INSERT INTO bvd_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nau nao kwasi dooria guu uri sae ta waa 'ana fera ne 'i saegano ka tango nau. ");
INSERT INTO bvd_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ma nau ku saitomamolu gwaku, ne kamolu nao molu si liosau guu 'ana God lao mauria kamolu ki. ");
INSERT INTO bvd_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nau ku lea mai, Maa nau ne fale nau mai fai rigitaa nia. Sui ma kamolu ka nao molu si ele gu suli nau. Aia, ma si kada ta waa gwana 'ani kamolu nia dao mai fai rigitaa nia tala'ana, kamolu molu ka ele 'amolua suli nia. ");
INSERT INTO bvd_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","'Uri nai, nia 'afitai uri molu ka manata mamana 'ani nau nai, suli kamolu dooria 'amolua tango laa ne lea mai faasia wane 'ana fera ne 'i saegano, ma ka nao molu si dooria guu ili lana doo diane ki uri God ka tango kamolu fainia. ");
INSERT INTO bvd_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nao molu si manata toi lau sae sa nau waa fua keto lamolu lae gwana 'i naofana Maa nau. Sa Mosis 'ana ne keto kamolu. Nia waa bae kedaa na taki ne kamolu faamamanea. ");
INSERT INTO bvd_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Lea kamolu faamamanea si doo na taki sa Mosis 'e saea, tama nia bobola fai molu ka faamamane nau lau guu nai, suli nia 'e kekeda mai suli nau. ");
INSERT INTO bvd_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Aia, ma lea kamolu nao molu si faamamanea guu taki sa Mosis suli nau, nia 'afitai 'asia naa molu ka faamamanea si doo ne nau ku saea fuamolu.” ");
INSERT INTO bvd_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Si kada 'i burina lau guu si doo nai, sa Disas ka faafolo na kau uri bali lobae tau 'ana 'osi Galilii ne da faasatanaa lau guu 'ana 'osi Taebirias. ");
INSERT INTO bvd_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ma tii konia baita nai ka lea lau gu 'i burina, suli kera da suana mai doo kwaibalatana ne nia fulia ki kada nia guraa mai toaa matai ki. ");
INSERT INTO bvd_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Dao bali loko nia ka raa gwauna kasi labusua nai 'i seeri ka gooru 'i saegano fai toa kwairooi nia ki. ");
INSERT INTO bvd_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na fafangaa 'ana Fangatasae toaa Diu ki 'e kwai karangi naa 'ana si kada nai. ");
INSERT INTO bvd_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Sa Disas 'e lio kau ka suana konia baita nai da lea na mai siana. Nia ka bae 'urii fua sa Filib, “Nee wala, tara kolu ka foli fanga 'i fai uri kolu ka sangonia 'ana toaa nee?” ");
INSERT INTO bvd_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nia 'e bae 'uri nai uri ka ilitona gwana sa Filib, suli 'e saitomana gwana si doo kai ilia. ");
INSERT INTO bvd_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ma sa Filib 'e luua ka 'urii, “Lea sa ta roo talanga malefo boroi kolu ka foli fanga ai, ka nao si bobola gu fai kera ne wala!” ");
INSERT INTO bvd_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Sa 'Andru ta waa 'ana toa kwairooi nai ki lau guu, ne nia toolana sa Saemon Bita, nia ka bae kau 'urii, ");
INSERT INTO bvd_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Tii kaa wela wane 'i seki mone, lima kafa beret tu'uu ki fainia roo kaa sakwari tu'uu ki gu ne nia too ai. Ma sui ta, doo 'uri nai ka bobola fainia konia baita nee nai?” ");
INSERT INTO bvd_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Sa Disas ka 'urii, “Molu saea fasi fua konia nee da gooru ngado 'i saegano.” Si kula nai lao kiras sui gwana nai, ma 'uri nai guu toaa wane nai daka gooru na 'i saegano. Kera da 'oro ka bobola fainia lima tooni wane. ");
INSERT INTO bvd_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Sui sa Disas ka dau 'ana kafa beret nai ki ka tangoa God, sui ka tolingida naa fua toaa nai kera da gooru 'i seeri. Nia ka ili lau gu 'uri nai 'ana kaa sakwari nai ki. Ma kera tiifau, daka fanga lelea daka tala abusu 'ada. ");
INSERT INTO bvd_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Si kada kera da abusu naa, nia ka bae 'urii fua toa kwairooi nia ki, “Molu konia si fanga nai ki da ore nai, uri nao kolu si saketoa lau fange.” ");
INSERT INTO bvd_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ma kera daka koni tiifau ai uri lao kukudu ki, lelea tii taafuli kukudu ma roo kukudu sarenga ki ka fungu 'ana fange faasia lima kafa beret baki gwana. ");
INSERT INTO bvd_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ma si kada toaa nai da suai doo kwaibalatana nai sa Disas nia ilia, kera daka bae 'urii, “Na brofet bae kai dao mai lao fera ne 'i saegano naa ne, nia mamana naa ne!” ");
INSERT INTO bvd_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Sa Disas 'e saitomana naa nai kera da kai suumainia gwada 'i seeri uri nia ka 'inito fuada, nia ka lea na faasi kera uri ka too 'ana tai nia suli walo nai lau gu 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Si kada 'e dao na 'i saulafi, na toa kwairooi sa Disas ki kera daka koso naa uri fafo 'osi bae. ");
INSERT INTO bvd_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kera daka tae laona kaa baru nai daka lea na kau uri Kabaneam 'i bali 'osi lobae, ma faanoe ka rodo na faafi kera. Ma sa Disas ka nao si dao guu uri ka lea kwaimani fai kera. ");
INSERT INTO bvd_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tii koburu baita nai ka too ma nanafo ka tae naa. ");
INSERT INTO bvd_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kada kera da faluta kau lelea ka dao bobola fainia lima kilomita ma nao ta ono kilomita naa, kera lio kau daka suana sa Disas nia talau ka lea gwana mai lao 'osi nai. Ma ka lea karangia na mai kaa baru nai fai kera. Ma kera daka mau daka lelebe naa. ");
INSERT INTO bvd_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Sui boroi sa Disas ka bae kau 'urii fuada, “Nao molu si mau lau, tee nau gwana ne!” ");
INSERT INTO bvd_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","'Uri nai fatai, kera dafi faolomainia kafi raa kau siada lao baru. Tona boroi, kera daka olo lau gwada 'ana maefera nai kera lea kau uria nai. ");
INSERT INTO bvd_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Aia da too 'e dani naa, na konia baita bae da faasi kera mai 'i bali 'osi loko bae, daka nani naa uri sa Disas 'i seeri kula bae nia falea tango lae talea God fua fanga bae ma ka sangoni kera ai bae. Ma kera daka lio saitomana mai tii baru gu ne too mai seeri ka lea mai rooki. Ma daka lio saitomana mai ne sa Disas nao si lea gu mai fai toa kwairooi nia ki lao baru nai. Suli toa kwairooi ki taifili kera gwana bae da lea mai. 'I seeri, tai baru faasia bali 'osi nai 'i Taebirias daka lea lau gu mai uri kula nai sa Disas 'e nii ai nai. ");
INSERT INTO bvd_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","'Uri nai guu, kada na konia nai nao dasi suana naa sa Disas ma toa kwairooi nia ki 'i bali loko, kera tae daka lea lau gu mai lao baru nai ki, uri seeri Kabaneam uri nani lae uri sa Disas. ");
INSERT INTO bvd_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ma si kada kera dao tona 'i bali 'osi nai, kera daka ledi 'urii 'ani nia, “Waa ni toolangaidoo 'ae, 'oe dao gwamu seki anita?” ");
INSERT INTO bvd_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ma sa Disas 'e luu kera ka 'urii, “Ku faarongo mamana 'ani kamolu, kamolu molu nani gwamolu buriku suli molu 'ani beret baki ma molu ka abusu ne. Nao lau suli ne molu lio filoa doo kwaibalatana baki nau ku ilia ki. ");
INSERT INTO bvd_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Molu rao ulafu lae gwamolu uri fanga ne kai funu gwana nee ka nao. Molu rao uri fanga nai ne mauria firi nii ai, ne nau na 'Alakwa nia Wane, kwai falea fuamolu. God na Maa 'e faatai folaa 'ania, nia naa ne fale nau mai.” ");
INSERT INTO bvd_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Sui kera daka ledi 'urii 'ani nia, “Nee wala, tara kameli meli ka ade 'utaa ne uri meli ka ilia na raoa nai God nia dooria?” ");
INSERT INTO bvd_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ma sa Disas 'e luu kera ka 'urii, “Na raoa nai God nia dooria nai gu ne, manata mamana lae 'ana waa ne nia falea mai.” ");
INSERT INTO bvd_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ma kera daka ledi lau gu 'urii 'ani nia, “Tara na doo kwaibalatana tee gu ne 'oe kai fulia, uri kameli suai ma meli ka manata mamana 'ani 'oe? Tee ne tara 'oe kai ilia? ");
INSERT INTO bvd_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Kameli toaa bae kokoo kameli ki da 'ania na mai beret bae fasi salo ‘Mana’ 'ana kada bae kera nii lao fera kwasi bae ne. Kera kekeda daka bae mai 'urii sulia bae, ‘Sa Mosis nia falea na beret faasia 'i salo fuada kera daka 'ania.’” ");
INSERT INTO bvd_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ma sa Disas ka bae 'urii, “Ku faarongo mamana 'ani kamolu, nao lau sa Mosis ne falea na beret faasia 'i salo fuamolu nai. Na Maa nau lau 'ana ne falea na beret mamana faasia 'i salo fuamolu. ");
INSERT INTO bvd_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Na beret mamana ne God nia falea mai, nia 'ana ne sa wala ne koso mai fasi salo ka falea mauria fuana toae ki sui guu lao fera ne 'i saegano nee.” ");
INSERT INTO bvd_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ma kera daka bae 'urii fuana, “Waa baita kani 'ae, 'oe sangoni kameli na 'amua 'ana beret nai 'ita 'i tari'ina ka oli 'alaa naa.” ");
INSERT INTO bvd_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Sui sa Disas ka bae 'urii, “Ni nau na beret ni mauria. Tii gwana ne lea mai siaku, nia 'afitai ka fiolo lau. Ma tii gwana ne manata mamana 'ani nau, nia 'afitai ka maeli kuu lau. ");
INSERT INTO bvd_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ma sui ta 'uri bae ku saea sui na fuamolu, kamolu suaku boroi 'amolu nao molu si manata mamana gu 'ani nau. ");
INSERT INTO bvd_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Toaa neki sui guu na Maa nau 'e fale kera mai fuaku, kera da kai lea sui gu mai siaku. Ma sa tii gwana ne nia lea mai siaku, nau 'afitai ku noni'ela 'ani nia. ");
INSERT INTO bvd_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Suli nau nao kwasi koso mai fasi salo uri ili lae suli doori laku 'i tala 'aku. Nau ku lea lau 'aku mai uri ili lae suli doori lana waa ne fale nau mai. ");
INSERT INTO bvd_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ma si doo ne nia dooria fuaku naa ne, uri nau ku dau faafia toaa ne nia fale kera fuaku lelea ka sui ta waa si funu guu, ma uri ku tatae kera fasi maea 'afa sato 'isi. ");
INSERT INTO bvd_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Suli na doori lana Maa nau, nia ne uri sa tii gwana ne nia lio saitomaku ma ka manata mamana 'ani nau, waa nai kai too 'ana mauria firi. Ma nau kwai tataea waa nai fasi maea 'afa sato 'isi.” ");
INSERT INTO bvd_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Na toaa Diu ki da rongoa bae laa nai kera daka 'ugali nia, suli sa Disas 'e bae 'urii, “Nau naa ne beret nai 'e koso mai fasi salo nai.” ");
INSERT INTO bvd_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ma kera daka bae 'urii 'i matangada kwailiu, “Sa wala nee, sa Disas na 'alakwa bae sa Diosef gwana ne. Tee waa kolu saitomana gwakolu maa nia fai gaa nia nee. Ma 'utaa ne nia ka saea lau na 'ana sae nia koso mai fasi salo 'urii?” ");
INSERT INTO bvd_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ma sa Disas 'e luu kera ka 'urii, “Nao molu si 'uga lau. ");
INSERT INTO bvd_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Na wane, lea Maa nau waa ne fale nau mai 'e talaia mai siaku taari nia lea mai siaku, lea nao, 'afitai ka lea gu mai siaku. Ma nau kwai tataea waa nai fasi maea 'afa sato 'isi. ");
INSERT INTO bvd_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Na kekeda laa kera brofet ki 'e bae 'urii, ‘God nia toolangaidoo fua toae ki sui guu.’ Ma sa tii gwana ne God na Maa 'e toolangaidoo fuana ma nia ka ade suli bae lana God na Maa, nia ne kai lea mai siaku. ");
INSERT INTO bvd_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nao ta waa si suana 'ua God na Maa. Taifilia guu waa ne God fale nia mai nee gu ne suana. ");
INSERT INTO bvd_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ku faarongo mamana 'ani kamolu, sa tii gwana ne nia manata mamana 'ani nau, nia kai too 'ana mauria firi. ");
INSERT INTO bvd_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ni nau na beret ni mauria. ");
INSERT INTO bvd_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Na kokoo kamolu ki kada 'i nao kera da 'ania beret bae da 'ailia 'ana ‘Mana’ laona fera kwasi, sui kera daka mae gwada. ");
INSERT INTO bvd_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Na beret ne koso mai fasi salo lau 'ana ne, sa tii gwana ne nia 'ania, 'afitai nia ka mae lau. ");
INSERT INTO bvd_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nau naa ne beret ni mauria nee 'e koso mai fasi salo. Lea ta waa nia 'ania beret nee, waa nai kai mauri ka lelea firi. Ma na beret nai naa ne fasioku, ne nau kwai falea uri toae ki sui lao fera ne 'i saegano daka mauri nunufana.” ");
INSERT INTO bvd_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","'I seeri guu toaa Diu ki kera daka safali olisusuu naa 'i matangada kwailiu, ma daka bae 'urii, “Sa wala nee kai fale 'utaa 'ana fasiona fuakolu uri 'ani lana nee?” ");
INSERT INTO bvd_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ma sa Disas ka bae 'urii fuada, “Ku faarongo mamana 'ani kamolu, lea nao molu si 'ani guu fasioku, nau 'Alakwa nia Wane, ma ka nao molu si kuufia guu 'abuku, 'afitai molu ka too 'ana maurie. ");
INSERT INTO bvd_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Sa tii gwana ne nia 'ania fasioku, ma ka kuufia 'abuku, nia kai too 'ana mauria firi, ma nau kwai tatae nia fasi maea 'afa sato 'isi. ");
INSERT INTO bvd_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Suli fasioku naa ne fanga mamane ni 'ani lana, ma na 'abuku naa ne kafo mamane ni kuufi lana. ");
INSERT INTO bvd_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Sa tii gwana ne nia 'ania fasioku, ma ka kuufia 'abuku, waa nai nia lado 'ani nau, ma nau ku lado 'ani nia. ");
INSERT INTO bvd_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Waa ne sangoni nia 'i tala'ana 'ani nau, waa nai kai mauri 'i nunufaku ne ku mauri. Suli nau ku mauri nunufana Maa nau God waa ne fale nau mai nia waa 'ana mauria. ");
INSERT INTO bvd_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nau na beret ne ku koso mai fasi salo naa ne. Tii gwana ne 'ani nau na beret nai, nia kai mauri ka totoo firi. Na kokoo kamolu ki kera da 'ania na beret bae da 'ailia 'ana mana sui daka mae gwada.” ");
INSERT INTO bvd_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Sa Disas 'e saea doo nai ki 'ana si kada nia toolangaidoo laona beu ni ofu laa 'i Kabaneam. ");
INSERT INTO bvd_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Na 'oro lana toa kwairooi nia ki ne kera da rongo doo nai sa Disas 'e bae sulia nai, kera daka bae 'urii, “Si doo 'e 'afitai 'asia naa ne sa wala nee toolangaidoo sulia nee rowaa. Si doo 'afitai ta waa ka ala na faafia nai!” ");
INSERT INTO bvd_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Suli sa Disas 'e saitomana gwana ne toa kwairooi nia ki kera bae buri 'ani nia faafia si doo nai, nia ka ledi 'urii 'ani kera, “Nee, na bae laa nai adea manata lamolu ka ta'aa, ma nao 'utaa? ");
INSERT INTO bvd_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ma sui lea sa ni nau na 'Alakwa nia Wane oli ku raa lau gwaku uri si kula bae nau ku too mai ai nao, nia ka 'utaa? ");
INSERT INTO bvd_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Na Anoedoo Abu ne nia falea maurie. Ma na tetedea wane 'ana fera ne 'i saegano nia nao si tala'ana ili lana si doo nai. Ma na baea nai ki nau ku saea fuamolu nai ne ilia molu ka too 'ana Anoedoo Abu ne falea maurie. ");
INSERT INTO bvd_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ma sui ka 'uri nai boroi 'ana, tai waa 'ani kamolu nao dasi manata mamana gu 'ani nau.” Nia 'uri nai, suli si kada sa Disas safali rao 'ua boroi mai fai kera, nia 'e saitomana sui naa toaa ne totoo boroi nao dasi manata mamana guu 'ani nia, ma waa ne totoo boroi kai fale nia guu fuana malimae ki. ");
INSERT INTO bvd_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ma nia ka bae lau gu 'urii fuada, “Doo nai gu bae adea nau ku saea fuamolu 'afitai ta waa ka lea gwana mai tala'ana siaku lea Maa nau nao si faawaludea guu fua waa nai.” ");
INSERT INTO bvd_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Safali gu 'i seeri toa 'oro ki 'ana toaa kwairooi nia ki ne kera da lukasi nia ma ka nao dasi lea kwaimani na fai nia. ");
INSERT INTO bvd_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Sa Disas ka ledia naa akwala ma roo waa kwairooi nia baki ka 'urii, “Nee, kamolu lau guu molu doori oli na 'amolu faasi nau?” ");
INSERT INTO bvd_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ma sa Saemon Bita 'e luua ka 'urii, “Wala Aofia, lea meli oli meli ka lea lau sia sa tii nai? 'Oe naa ne 'o too 'ana si baea ki 'ana mauria firi. ");
INSERT INTO bvd_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kameli faamamanea ma meli ka saitomana ni 'oe naa ne Waa Abu ne God fale 'oe mai.” ");
INSERT INTO bvd_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ma sa Disas ka bae 'urii, “Nau ku fili kamolu akwala ma roo waa sarenga ki. Ma sui boroi 'ana, tara ta tii waa 'ani kamolu nia kai mala gwana anoedoo ta'ae.” ");
INSERT INTO bvd_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Si kada sa Disas 'e bae 'uri nai, nia 'e saitomana gwana waa nai gu ne sa Diudas 'alakwa sa Saemon 'Iskariot. Sa Diudas, sui boroi 'ana nia ta waa lau guu 'ana akwala ma roo waa ni kwairooi nia baki, nia kai falea sa Disas 'i 'abana malimae ki. ");
INSERT INTO bvd_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Burina naa doo nai ki, sa Disas ka liu kwailiu 'ana maefera 'i Galilii ki. Nia nao si dooria 'ua lea lae uri 'i Diudia, suli toa gwaungai Diu ki kera doori saumaeli lana 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ma tii fafangaa Diu ki ne kera saea 'ana “Fafangaa 'ana Babale ki” nia ka kwai karangi naa 'ana si kada nai. ");
INSERT INTO bvd_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Aia, na toolana sa Disas ki kera da lea mai siana daka bae 'urii fuana, “'O lea uri bali lolofaa 'i Diudia, uri 'oko faatainia lau tai doo kwaibalatana, uri toa kwairooi 'oe ki kera daka suai. ");
INSERT INTO bvd_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Suli lea waa nia dooria toae ki daka rongoa satana, nia 'afitai ka ili saufini gwana 'ana doo ki 'urii. Lea 'oko ili folaa 'ana doo neki 'oe ilia nee lao maana toae ki sui, uri daka liosaitomamu fainia.” ");
INSERT INTO bvd_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Toolana ki da bae 'uri nai fuana, suli kera boroi nao dasi manata mamana lau gu 'ani nia. ");
INSERT INTO bvd_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ma sa Disas ka bae 'urii fuada, “Nao si dao 'ua 'ana si kada nau uri lea lae. Ni kamolu 'ana ne lea mamalana si kada boroi molu ka lea gwamolu ai. ");
INSERT INTO bvd_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Toaa nee 'ana fera ne 'i saegano kera nao dasi susubutai kamolu. Sui ma ni nau, kera da susubutai nau ne, maana ne nau ku sae folaa ai fuada ne kera da ilia si doo 'e ta'aa. ");
INSERT INTO bvd_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Molu lea 'amolua kau 'ana fafangaa loko. Nau tara ku too 'ua gwaku kau, suli 'e nao si dao 'ua 'ana si kada nau uri lea lae.” ");
INSERT INTO bvd_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nia bae 'uri nai sui, nia ka too 'ua gwana kau 'ana bali lolofaa nai 'i Galilii. ");
INSERT INTO bvd_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Sa Disas 'e too lelea burina toolana ki da lea ka sui naa, nia ka lea lau gwana kau burida 'i 'isi 'ana fafangaa nai. Nia lea boroi kau, nao nia si lea faatai lau kau. 'E agwatainia lau gwana lea lana kau. ");
INSERT INTO bvd_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ma 'i nonina fafangaa nai, na toa gwaungai Diu ki kera daka nani na uri nia matangana konia nai. Ma daka kwailedii daka bae na 'urii, “Sa wala bae nii fai?” ");
INSERT INTO bvd_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ma toaa lao konia nai ki daka bae fuuaro na suli nia matangada kwailiu. Tai waa ki daka bae suli nia daka 'urii, “Sa wala bae waa ade diana bae.” Ma tai waa ki lau daka 'urii, “Waa nai 'e sukea toaa 'oro 'asia naa daka lea suli sukea nia nai.” ");
INSERT INTO bvd_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Sui boroi 'ana kera daka manata 'uri nai ki, ta waa 'ana toaa nai ki si bae tafa guu suli manata lana nai suli sa Disas, suli da mau lau gwada 'ana toa gwaungai nai Diu ki. ");
INSERT INTO bvd_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na fafangaa nai 'e liu ka dao naa 'ana faina fa dani, sa Disas kafi ruu kau lao Beukaua bae ma kafi safali toolangaidoo. ");
INSERT INTO bvd_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ma toa gwaungai nai ki kera daka kwele 'asia naa 'ana toolangaidoo laa nia. Ma daka 'urii, “Sa wala nee nao si too gu mai lao ta sukulu, ma sui ka saitomana doo neki sui guu!” ");
INSERT INTO bvd_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Sa Disas 'e rongo kera bae 'uri nai, nia 'e luu kera ka bae 'urii, “Toolangaidoo laa nau nee nao lau doo nau tala'aku ne. Doo 'e lea mai fasi God waa ne fale nau mai ne. ");
INSERT INTO bvd_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tii gwana ne nia dooria ili lae suli doori lana God, nia kai lio filoa lea na toolangaidoo laa nau 'e lea mai faasia God, ma nao doo suli manata laku 'i tala'aku gwana. ");
INSERT INTO bvd_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Lea waa 'e bae gwana suli si doo suli manata lana ki tala'ana tama nia dooria gwana fua toae daka tango nia fainia nai. Aia, ma waa ne dooria toae ki daka tangoa 'ada waa ne fale nia mai, nia 'ana ne waa 'ana mamana lae, ne nia nao si suke.” ");
INSERT INTO bvd_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Sui sa Disas ka bae lau 'urii, “Sa Mosis 'e falea sui naa taki fuamolu, ma sui nao ta waa 'amolu si ade gu sulia taki nai. Ma sui kamolu doori saumaeli nau gwamolu uri tee?” ");
INSERT INTO bvd_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ma toaa nai lao konia nai daka bae 'urii, “Na anoedoo ta'ae ne burosi 'oe nee wala! Sa tii gwana ne dooria kai saumaeli 'oe nee?” ");
INSERT INTO bvd_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Sa Disas ka luu kera ka 'urii, “Nau, si kada ku ilia gwaku tii si doo kwaibalatana nai gwana 'afa sato sabat, sui kamolu molu ka kwele 'asia naa 'ana si doo nai. ");
INSERT INTO bvd_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ma sui, molu 'iri'unga 'ana wela wane ki, lea 'afa dani sabat boroi molu ka ilia gwamolu si doo nai ai, ");
INSERT INTO bvd_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","suli sa Mosis nia falea mai taki nai fuamolu. (Sui, nao lau sa Mosis ne safalia mai. Kokoo kamolu ki lau 'ana ne da safalia mai.) Ma lea nia mola gwana fua molu ka 'iri'unga 'ana wela wane ki 'afa dani Sabat, 'utaa ne molu ka rakesasui nau faafi gura lana waa bae 'afa dani Sabat bae? ");
INSERT INTO bvd_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nao molu si ketoa lau wane sulia si doo 'i sara ki gwana 'ani nia. Molu keto 'o'olo 'ani nia.” ");
INSERT INTO bvd_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Si kada nai, tai toaa 'ana toaa nai 'i Durusalem kera da ledi daka 'urii, “Sa wala nee gwana bae toa gwaungai nee kera dooria daka saumaeli nia bae! ");
INSERT INTO bvd_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tee nia gu ne bae gwana fua konia nee ma daka suana sui gwada nee! Ma sui toa gwaungai nee kera nao dasi saea gu ta doo fuana! 'Uri nee toa baita nee da saitomana ne sa wala nee na Kraes bae naa nee, ma nao 'e nao guu? ");
INSERT INTO bvd_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ma na Kraes bae doo lea nia dao mai ma 'afitai ta waa ka saitomana fera ne nia lea mai faasia bae. Ma sa wala nee, kolu saitomana gwakolu maefera ne nia lea mai faasia.” ");
INSERT INTO bvd_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Si kada nai, sa Disas 'e toolangaidoo 'ua gwana lao Beukaua bae nai, ma nia ka 'ai baita ka 'urii, “Tee mone, kamolu molu saitomaku ma molu ka saitomana kula ne ku lea mai faasia? Ma sui ta, nau nao kwasi lea mai seki suli manata laku 'i tala'aku ne! Na waa ne nia fale nau mai, nia 'e bae mamana. Kamolu nao molu si saitomana gu waa nai. ");
INSERT INTO bvd_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ni nau 'ana ne ku saitomana waa nai, suli nau na waa faasi nia ma nia ka fale nau ku lea mai.” ");
INSERT INTO bvd_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","'Uri nai guu, na toa gwaungai nai ki daka dooria daka dau nia naa, ma sui ka 'afitai, suli 'e nao 'ua si kada nia uri kera daka ili 'uri nai 'ani nia. ");
INSERT INTO bvd_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ma ka 'uri nai boroi 'ana, toaa 'oro lao konia nai kera manata mamana 'ani nia. Kera daka bae 'urii suli nia, “Na Kraes, nia ka dao boroi mai, na doo kwaibalatana ne nia kai ilia ki 'afitai ka talua lau kau doo neki sa wala nee ilia ki mai.” ");
INSERT INTO bvd_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Na Faarisii ki fainia waa baita ni foa ki kera da rongo doo nai ki toaa nai ki da fuuarotainia ki suli sa Disas. Ma kera daka odua na kau waa ni fofolo ki 'ana Beukaua nai uri daka dau nia naa. ");
INSERT INTO bvd_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ma sa Disas ka bae 'urii, “Nau ku too kwaimani fai kamolu suli si kada kukuru gwana sui nau kwai oli lau gwaku siana waa ne fale nau mai. ");
INSERT INTO bvd_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kamolu kai nanisi nau ma sui kai 'afitai uri molu ka dao toku, suli 'e 'afitai molu ka dao 'ana kula ne nau kwai too ai.” ");
INSERT INTO bvd_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ma na toa gwaungai nai ki Diu kera daka bae 'i matangada kwailiu daka 'urii, “'I fai gwana ne sa wala nee kai lea uria ma ka saea kolu 'afitai kolu ka suana naa nee? Ma nao nia kai lea uri maefera neki toaa Grik ki, ne tai waa 'akolu kera nii ki lau gu mai ai, uri ka toolangaidoo fuada 'oto? ");
INSERT INTO bvd_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ma nia ka saea lau guu kolu kai nanisi nia ma sui 'afitai kolu ka suana lau, suli kolu si bobola fainia dao lae 'ana kula ne nia kai too ai. Aia, ma tee ne malutana si baea nai nia saea nai?” ");
INSERT INTO bvd_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Aia, 'afa dani 'isi naa ne fa dani baita tasa 'ana fafangaa nai, sa Disas nia uu ka bae baita fua konia nai. Nia ka bae 'urii, “Sa tii gwana ne nia maeli kuu, nia ka lea mai siaku uri ka kuu 'ana. ");
INSERT INTO bvd_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ma sa tii gwana ne nia manata mamana 'ani nau, nia kai mala doo bae kekeda laa Abu nia bae 'urii sulia, ‘Na kafo mauri kai igwa mai fasi lao mauri lana.’” ");
INSERT INTO bvd_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Si baea nai sa Disas 'e saea, nia bae gwana suli Anoedoo Abu ne kai lea mai fua lao tooa kera toaa ne da manata mamana 'ana sa Disas. Si kada nai sa Disas saea si bae nai, God nao si falea 'ua mai na Anoedoo Abu fua toaa da manata mamana ki, suli sa Disas nao si raa 'alaa 'ua uri lao 'initoaa nia. ");
INSERT INTO bvd_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tai toaa 'ana konia nai kera da rongo bae lana nai sa Disas, kera daka bae na 'urii, “Sa wala nee na brofet bae kolu maasia naa ne!” ");
INSERT INTO bvd_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ma tai waa lau daka 'urii, “Na Kraes bae naa ne!” Ma sui tai waa daka bae 'ada 'urii, “Na Kraes bae doo nao si lea lau mai fasi bali lolofaa 'i Galilii 'urii bae! ");
INSERT INTO bvd_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Sulia na kekeda laa Abu nia saea na Kraes doo kai futa lau 'ana mai 'ana kwalafaa sa Defet waa ni taloe ma lao maefera sa Defet 'i Betlehem 'ua gu bae.” ");
INSERT INTO bvd_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Toaa nai sui guu, bae lada nao si tio guu 'ana tii si doo suli sa Disas. ");
INSERT INTO bvd_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ta bali 'ana toaa nai, kera daka dooria naa daka daua sa Disas, ma sui boroi ta waa si ili gu tasi doo 'ani nia. ");
INSERT INTO bvd_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Na toa fofolo baki ka nao dasi daua guu sa Disas, daka oli nada siana waa baita ni foa ki ma Faarisii ki. Dao, na waa baita ni foa ki ma Faarisii ki, kera daka ledi 'urii, “'Utaa ne ka nao molu si daua gu mai sa wala bae?” ");
INSERT INTO bvd_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Kera da luu kera daka 'urii, “Sa wala loko, nao ta waa bae lana si 'uri nia.” ");
INSERT INTO bvd_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Na Faarisii ki daka bae 'urii fuada, “Kamolu alamia molu faamamanea lau gwamolu na suke laa nia loko 'oto mone ne? ");
INSERT INTO bvd_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kamolu suana ta waa 'ana toa gwaungai ki, ma nao ta waa 'ana Faarisii ki ne faamamanea sa wala loko? 'E nao guu! ");
INSERT INTO bvd_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Na konia neki da ulafusia gwada taki sa Mosis, kera gwana ne da faamamane nia. God nia kai kwae kera faafia si doo nai!” ");
INSERT INTO bvd_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Aia, 'i seeri sa Nikodimas na waa Faarisii bae lea ka dao siana sa Disas 'i nao, nia ka bae 'urii fua Faarisii nai ki, ");
INSERT INTO bvd_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Na taki kolu 'e saea kolu ka fafurongo diana fasi 'ana bae lana wane 'i nao, uri kolu ka saitoma diana 'ana garo laa nia sui fatai kolu kafi ngali nia mai uri fale lana kwakwaea fuana.” ");
INSERT INTO bvd_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ma kera daka bae 'urii fua sa Nikodimas, “Lea 'uri nai, ma 'oe 'ua ne waa fasi bali lolofaa 'i Galilii lau guu? 'O teemainia fasi kekeda laa Abu, uri 'oko tala suai guu, ne na brofet nia 'afitai ka lea mai fasi Galilii!” ");
INSERT INTO bvd_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Na toaa nai ki tiifau kera daka oli naa uri luma kera ki. ");
INSERT INTO bvd_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Sa Disas ka lea 'alaa naa uri gwauna fa uo bae 'i 'Olif. ");
INSERT INTO bvd_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Too tio dani 'i 'uubongi maakafukafua, nia oli mai ka dao lau guu lao Beukaua bae. Ma na konia baita bae daka koni na kali nia. Ma nia ka gooru 'i saegano, ka toolangaidoo na fuada. ");
INSERT INTO bvd_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","'Uri nai, toa ni toolangaidoo ki 'ana taki, ma na Faarisii ki daka talaia na mai tii ai nai kera daua mai fai ooe lae. Kera da saea fua ai nai ka uu 'i maana konia nai, ");
INSERT INTO bvd_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","sui kera daka bae 'urii fua sa Disas, “Wala waa ni toolangaidoo, na wela keni nee kameli daua mai fafo ooe lae ne. ");
INSERT INTO bvd_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Aia, ma na taki sa Mosis nia saea na ai ade 'urii, kera daka 'uifauna ka mae naa. Ma tee ne 'oe saea suli ni wala nee?” ");
INSERT INTO bvd_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kera saea si doo nai uri daka ilitona gwada sa Disas, uri sae daka dao toi tasi doo nia ilia ka garo ma daka keto nia faafia. Ma sui, sa Disas ka gooru ka ooro uri saegano, ma ka kekeda 'ana lao saegano 'ana kakauna. ");
INSERT INTO bvd_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ma kera daka ledi nia gwada lelea nia ka tatae, ma nia ka bae 'urii fuada, “Alu waa 'amolua ne nao ta abulo ta'aa laa 'ani nia, 'e 'uia fasi wela keni nee 'ana maefau totoonao.” ");
INSERT INTO bvd_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Sa Disas 'e bae 'uri nai sui, nia oli ka ooro kau ka kekeda lau gwana lao saegano nai. ");
INSERT INTO bvd_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kera da rongo si baea nai, daka lea too tii waa na faasi nia, safali fasi 'ana waa 'i nao ki ka lea naa. Ma daka lelea faasi sa Disas lea taifili nia naa ka nii seeri fai wela keni nai ne uu gwana. ");
INSERT INTO bvd_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Sa Disas 'e sagaa sulina ka ledi 'urii 'ana wela keni nai, “Nee wala wela keni nee, toa bae kera nii na fai? Nao ta waa ada si keto 'oe gu nai, nee?” ");
INSERT INTO bvd_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ma wela keni nai ka 'urii, “'E nao gu ne waa baita kani.” Ma sa Disas ka bae 'urii fuana, “Nau boroi, nao kwasi fale gu ta kwae laa fuamu. 'O lea kau, safali tari'ina ka oli 'alaa, nao 'osi ilia lau garo laa nai.” ");
INSERT INTO bvd_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Sa Disas 'e bae lau fuana toaa nai ka 'urii, “Nau naa ne mala 'ana kwesu fua toaa lao fera ne 'i saegano. Tii ne nia lea buriku, nia 'afitai ka galo. Na kwesu 'ana mauria lau 'ana ne waa nai kai too ai.” ");
INSERT INTO bvd_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ma Faarisii ki daka bae 'urii fuana, “Si doo 'oe gwana tala saea suli 'oe nai. Nia 'uri nai, bae lamu nai suli 'oe, 'e nao si mamana guu uri ta waa ka faamamanea.” ");
INSERT INTO bvd_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Sa Disas ka bae 'urii, “Si baea nai, nau tai nau boroi 'ana ku saea suli nau, nau ku bae mamana, suli ku saitomana sui gwaku si kula ne ku lea mai faasia, ma si kula ne kwai lea kau uria. Kamolu 'ana ne nao molu si saitomana si kula ne ku lea mai faasia, ma si kula ne kwai lea kau uria. ");
INSERT INTO bvd_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kamolu, molu sae garo lana waa ki suli manata lae wane 'ana fera ne 'i saegano ki gwana. Nau nao kwasi sae garo lana ta waa 'uri nai. ");
INSERT INTO bvd_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Sui boroi 'ana lea sae nau ku sae garo lana ta waa, nau ku ilia suli manata lae wane 'o'olo. Suli nau nao kwasi sae garo lana ta waa suli manata laku tala'aku. Nau ku uu kwaimani sui guu fai Maa nau waa ne fale nau mai. ");
INSERT INTO bvd_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Na taki kamolu bae 'ua gu ne saea, lea si doo ne ta roo waa da ala sui gu faafia, si doo da faamamanea naa nai. ");
INSERT INTO bvd_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nau ku bae suli nau 'i tala'aku, sui ruana waa ne bae suli nau ne Maa nau waa ne fale nau mai.” ");
INSERT INTO bvd_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Sui, kera daka ledia sa Disas daka 'urii, “Nee wala, maa 'oe nai nii fai?” Ma sa Disas ka luu kera ka 'urii, “Kamolu nao molu si saitomaku guu, ma na Maa nau boroi ka nao molu si saitomana guu. Lea sa molu ka saitomaku, kamolu molu ka saitomana lau gu Maa nau.” ");
INSERT INTO bvd_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Sa Disas 'e saea doo nai ki kada nia toolangaidoo lao Beukaua bae, 'ana bali beu nai kera kai ngali mai fale laa kera ki ma da kai aluda ai. Si kada nai, nao ta waa si daua guu sa Disas, suli nao si dao 'ua 'ana si kada nia. ");
INSERT INTO bvd_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Sa Disas ka bae lau 'urii fuada, “Nau kwai lea naa, ma ni kamolu molu kai nanisi nau. Ma ni kamolu molu kai mae gwamolu fainia abulo ta'aa laa kamolu ki ne God nao si manata lukea guu. Kula ne nau kwai lea uria, kamolu 'afitai molu ka lea uria.” ");
INSERT INTO bvd_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ma na toa gwaungai nai Diu ki daka manata 'urii, “Sa wala nee bae 'urii bae, ‘Kula ne nau kwai lea uria, kamolu 'afitai molu ka lea uria. Alamia sa wala nee kai saungi nia tala'ana 'oto ne ka bae 'urii nee?’” ");
INSERT INTO bvd_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Sa Disas 'e luu kera ka bae 'urii, “Kamolu toaa fasi fera ne 'i saegano; nau waa fasi fera loo 'i langi ne. Kamolu toaa fasi fera ne 'i saegano; ma nau ne nao lau waa fasi fera ne 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nau ku saea na mai fuamolu ne kamolu kai mae gwamolu fainia abulo ta'aa laa kamolu ki ma God nao si manatalukeda guu. Lea kamolu rongo doo nai ki ku saea suli ‘Nau Naa Ne’, ma sui ka nao molu si manata mamana gu 'ani nau, tara kamolu kai mae mamana naa fainia abulo ta'aa laa kamolu ki.” ");
INSERT INTO bvd_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Sui kera ledia daka 'urii, “'Uri nai ma 'oe sa tii nee wala?” Ma sa Disas 'e luu kera ka bae 'urii, “Ni nau, nia naa bae ku faarongo kamolu ai 'ita kada ku safali toolangaidoo fuamolu lelea mai ka dao 'i tari'ina. ");
INSERT INTO bvd_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nau ku too 'ana doo 'oro 'asia naa ni sae lana suli kamolu ne kai faatainia molu garo. Si doo ne waa ne fale nau mai 'e saea fuaku uri sae lana lau gwana ne nau kwai saea fuamolu toaa lao fera ne 'i saegano. Nia waa 'ana mamana lae.” ");
INSERT INTO bvd_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ma kera daka ulafusia lau gwada ne nia too kai bae gwana fuada suli Maa nia 'i salo. ");
INSERT INTO bvd_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Maana ne kera da ulafusi nia, sa Disas ka bae 'urii fuada, “Totoo si kada kamolu kwau nau naa 'i langi, nau 'Alakwa nia Wane, ta molu kafi saitomaku ‘Nau Naa Ne’. 'Ana si kada nai fatai ne kamolu kai lio filoa lau guu ne nau kwasi ili tasi doo suli manata laku tala'aku, ma si doo ne Maa nau toolangainia siaku, nia lau gwana ne ku saea ki fuamolu. ");
INSERT INTO bvd_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na Maa nau ne nia fale nau mai, nia nii fai nau 'ana kada ki sui. Nia 'afitai ka ekwatai nau, suli nau ku ilia doori lana ka lelea firi.” ");
INSERT INTO bvd_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ma toaa 'oro daka manata mamana 'ana sa Disas, 'ana si kada nai gwana nia kai bae fuada nai. ");
INSERT INTO bvd_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Sui sa Disas ka bae 'urii fua toaa Diu nai ki da manata mamana 'ani nia, “Lea kamolu ade suli toolangaidoo laa nau, kamolu toa kwairooi mamana nau ki. ");
INSERT INTO bvd_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ma lea nia 'uri nai, kamolu kai saitomana doo mamane ki suli God, ma doo mamana nai ki suli God kai faasakwadola kamolu.” ");
INSERT INTO bvd_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Kera da luua sa Disas daka 'urii 'ada, “Kameli toaa 'ana kwalafaa sa 'Abraham nao meli si rao mala slef 'ua mai fua ta waa, 'uri 'oko saea fua meli, meli ka sakwadoloa 'ameli!” ");
INSERT INTO bvd_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Sa Disas ka bae lau 'urii fuada, “Ku faarongo mamana 'ani kamolu. Toaa neki sui guu kera da abulo ta'aa ka lelea gwana, kera ne da rao mala 'ana slef ki fua abulo ta'aa lae ma ka nao dasi sakwadoloa guu. ");
INSERT INTO bvd_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Na slef nia nao lau na 'alakwa nia waa 'ua guu, ma nia ka too gwana fai wane suli si kada kukuru. Ma na 'alakwa nia wane 'ana ne nia futa 'ua gu 'ana waa nai ma ka too kwaimani fainia ka lelea firi naa. ");
INSERT INTO bvd_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Doo ne adea guu, lea na 'Alakwa nia God 'ua guu 'e faasakwadola kamolu, kamolu molu ka sakwadoloa mamana naa. ");
INSERT INTO bvd_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nau ku saitomana ne kamolu toaa 'ana kwalafaa sa 'Abraham. Ma sui boroi 'ana molu ka dooria gwamolu saumaeli laku, suli nao molu si taingainia bae laku siamolu. ");
INSERT INTO bvd_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nau ku faarongo kamolu 'ana doo ku rongo ki sia Maa nau, ma ni kamolu molu ka ilia lau guu si doo molu rongoa ki sia maa kamolu.” ");
INSERT INTO bvd_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Kera da luua sa Disas daka 'urii, “Maa kameli naa ne sa 'Abraham!” Sa Disas ka 'urii fuada, “Lea kamolu kwalafaa sa 'Abraham mamana, aia molu ilia lau guu doo nia ilia ki mai. ");
INSERT INTO bvd_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ma sui ni kamolu nee, nau ku saea doo mamane ki faasia God fuamolu, sui molu ka dooria 'amolua saungi laku faafia. Sa 'Abraham nia nao si ilia mai si doo nai. ");
INSERT INTO bvd_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kamolu nee molu ilia naa si doo ne maa kamolu nia ilia ki ne.” Kera daka bae 'urii fuana, “Taifilia maa kameli nai naa ne God. Kameli nao lau wela ta waa 'e'ete lau gwana.” ");
INSERT INTO bvd_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Sa Disas 'e luu kera ka bae 'urii, “Lea God nia maa kamolu mamana, kamolu molu ka liosau 'ani nau waa ne God fale nau mai, suli nia ne fale nau mai ku nii seki. Nau nao kusi lea mai suli doori laku tala'aku. God ne fale nau mai. ");
INSERT INTO bvd_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kamolu saitomana doo ne adea molu ka rongo boroi bae laku ma ka nao molu si saitomana guu? Kamolu ne nao molu si dooria guu rongo lana doo ku saea. ");
INSERT INTO bvd_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Aia, ma kamolu nee, na maa kamolu ne sa Saetan. Nia ne adea molu ka doori ili lana lau guu doo nia ilia ki. Sa Saetan nia na waa fua sauwane lae naa, suli nia 'ita ka ilia 'uana mai. Ma nia 'afitai ka too 'ana ta mamana laa. Si kada nia sukea wane, nia waa ade lana 'uri nai naa, suli nia waa fua sukee naa, ma na maa nia sukee sui naa. ");
INSERT INTO bvd_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Sui boroi 'ana, kamolu nao molu si dooria guu faamamane laku, suli nau ku faarongo kamolu 'ana doo mamane ki. ");
INSERT INTO bvd_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ta waa 'amolu faatainia fasi si abulo ta'aa laa ne nau ku ilia, uri kolu ka suai! Tee nao gu nai! Aia, ma sui 'utaa ne kamolu nao molu si faamamane nau kada nau ku saea doo mamana ki fuamolu? ");
INSERT INTO bvd_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Na wane, lea nia waa God, nia ka rongo suli doo God nia saea. Ma kamolu nee, kamolu nao lau toaa God ne, nia ne adea ka nao molu si rongo suli doo nia saea.” ");
INSERT INTO bvd_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Sui, kera daka bae 'urii fua sa Disas, “Doo mamane bae kameli saea suli 'oe, ne 'oe waa Samaria ma 'oko too 'ana anoedoo ta'ae.” ");
INSERT INTO bvd_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Sa Disas 'e luu kera ka bae 'urii, “Nau nao kwasi too 'ana ta anoedoo ta'aa. Nau waa ku sae'inito 'ana Maa nau ne, ma ni kamolu 'ana ne nao molu si sae'inito gu 'ani nau. ");
INSERT INTO bvd_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nau nao kwasi sasi ngangata guu uri tafo laku 'i langi tala'aku. Maa nau lau 'ana ne dooria daka tafo nau 'i langi, suli nia waa ni sae lana doo ne too suli si doo ki sui. ");
INSERT INTO bvd_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ku faarongo mamana 'ani kamolu, tii ne nia ade sulia bae laku, nia 'afitai ka mae.” ");
INSERT INTO bvd_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Sui kera luua sa Disas daka bae 'urii, “Kameli meli saitomana 'oe 'o too 'ana anoedoo ta'ae ne! Suli kokoo kani sa 'Abraham fainia brofet ki sui guu kera da mae naa. Ma sui 'oe 'oko saea lau 'amua lea waa ade sulia bae lamu, waa nai 'afitai ka mae! ");
INSERT INTO bvd_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Na kokoo kani sa 'Abraham waa 'initoe boroi 'e mae, ma na brofet talingai baki boroi da mae lau guu. 'Oe ne 'o 'initoa ka talua kokoo 'initoa kani sa 'Abraham ma nao? 'Oe waa ta waa si rongo 'oe gu ne 'urii nee!” ");
INSERT INTO bvd_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Sa Disas ka luu kera ka 'urii, “Lea sa nau gwana ku susuu fai tafo laku 'i langi tala'aku, ma doo ku sasi gwaku fainia fua mange. Ma sui Maa nau waa ne kamolu saea nia God kamolu, nia 'ana ne tala tafo nau 'i langi. ");
INSERT INTO bvd_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kamolu nao molu si filoa Maa nau, nau 'ana ne ku filo nia. Lea sae nau ku tofe ne nao kwasi filo nia, 'uri nai tama nau ku suke lau guu mala 'ani kamolu nai. Sui ma nau ku filo nia ma ku ade suli bae lana. ");
INSERT INTO bvd_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Na kokoo kamolu sa 'Abraham nia ele 'asia na mai 'ana manata lae suli sua laku kada ku dao mai, nia suai sui na mai fa sato nai 'ana taue ma ka ele 'asia naa sulia.” ");
INSERT INTO bvd_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ma kera daka bae lau 'urii fuana, “Ni 'oe nee, lima taafuli fa ngali ki boroi 'osi too 'ua gu sulia nee, ma sui 'oko saea fatai sa 'o suana mai sa 'Abraham nai!” ");
INSERT INTO bvd_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Sa Disas 'e luu kera ka bae 'urii, “Nau ku faarongo mamana 'ani kamolu. ‘Nau Naa Ne’, sui fatai sa 'Abraham ka futa nau ku too naa.” ");
INSERT INTO bvd_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Si kada nai guu, kera daka gweefau na mai uri 'uimaeli lana, maana nia saea si doo nai. Ma sui, nia ka agwa faasi kera, ka lea na fasi lao Beukaua nai. ");
INSERT INTO bvd_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Si kada sa Disas 'e lea kau suli taale, nia ka suana tii waa nai maana rodo gaa nia ka kwalafia na mai fainia. ");
INSERT INTO bvd_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ma na toa kwairooi sa Disas ki daka ledi 'urii 'ana sa Disas, “Nee wala waa toolangaidoo, ma abulo ta'aa laa nia tii ne adea sa wala nee maana ka rodo ma gaa nia ka kwalafia 'ua gu mai fainia nee? Na abulo ta'aa laa nia 'i tala'ana, ma nao na abulo ta'aa lana maa nia fai gaa nia?” ");
INSERT INTO bvd_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Sa Disas 'e luu kera ka 'urii, “Na maarodo laa nia nee sa wala nee, nia nao lau fafona tasi abulo ta'aa laa 'ana 'i tala'ana, ma nao maa nia fai gaa nia ne. Nia doo lau 'ana uri ka faatainia tetedea God uri molu ka suai ne. ");
INSERT INTO bvd_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kolu lea kolu ilia naa raoa ne waa ne fale nau mai 'e saea fuaku nai, kada faanoe dani 'ua. Faanoe karangi rodo naa nai, ma lea nia rodo naa, 'afitai ta waa ka rao lau. ");
INSERT INTO bvd_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Si kada ne nau ku nii lao fera ne 'i saegano, nau naa ne kwesu fua toaa ki sui lao fera ne 'i saegano.” ");
INSERT INTO bvd_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Sa Disas nia bae 'uri nai sui, nia ka ngisu kau lao saegano sui ka gagia gegeo nai fainia ngisuna uri ka mamagoa, sui nia ka kanoa 'ana maana sa wala nai. ");
INSERT INTO bvd_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Sui nia sa Disas ka bae 'urii fuana sa wala nai, “'Oe lea kau 'oko taufia maamu lao matakwa loko 'i Saelom.” (Satae doo nai toolangainia, “Da odu nia kau.”) Ma sa wala nai 'e lea kau 'e taufia maana sui nia 'e oli mai, nia ka lilio naa. ");
INSERT INTO bvd_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ma na toaa nia ki, ma na toaa ne kera suana nia gani doo gwana fuana ki 'i nao, kera daka ledi 'urii 'ani kera kwailiu, “Nia sae waa bae kai gooru ma kai gani doo gwana fuana ki bae, nia gwana nee?” ");
INSERT INTO bvd_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tai toaa kera daka 'urii, “Ni nia naa ne.” Ma tai toaa lau daka bae 'ada 'urii, “Nao lau nia ne, sua lana gwana 'uria sa wala bae nee.” Ma sa wala nai tala'ana ka bae 'urii, “Nau naa ne.” ");
INSERT INTO bvd_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ma kera daka ledia, “Nee wala, na maamu 'e 'ifi 'utaa gwana?” ");
INSERT INTO bvd_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nia 'e luu kera ka 'urii, “Na waa nai satana sa Disas ne gagia mamago sui ka kanoa 'ana maaku. Ma ka saea nau ku lea ku taufia maaku lao matakwa loko 'i Saelom. 'Uri nai nau ku lea, ma si kada ku taufia guu maaku 'uri nai, maaku ka 'ifi naa.” ");
INSERT INTO bvd_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ma kera daka ledi 'urii lau 'ani nia, “Na waa nai ka nii na 'i fai?” Ma nia 'e luu kera ka 'urii, “Nau ku ulafusia naa.” ");
INSERT INTO bvd_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Sui, kera daka talaia naa sa wala nai siana Faarisii ki. ");
INSERT INTO bvd_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Fa dani Sabat nai sa Disas gagia si mamago nai ka guraa 'ana maana sa wala nai ai. ");
INSERT INTO bvd_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ma na Faarisii ki daka ledia lau sa wala nai daka 'urii, “Nia ade 'utaa gu 'ana maamu ne ka 'ifi naa nee?” Ma nia ka bae 'urii fuada, “Sa Disas nia kanoa maaku 'ana mamago nai, sui nau lea ku taufia maaku. 'Uri nai guu maaku ka 'ifi naa.” ");
INSERT INTO bvd_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ma tai waa 'ana Faarisii nai ki daka bae 'urii, “Na waa nai 'e ilia si doo nai, nia nao lau waa God fale nia mai nai, suli nia 'oia si baea fifii ne saea nia abu dasi rao 'ana Sabat nai.” Ma sui tai waa 'ani kera daka bae 'ada 'urii, “Ma lea sae nia ta waa abulo ta'aa gwana 'afitai ka ilia si doo kwaibalatana baita 'uri nai!” Ma 'i seeri manata lada ka nao si alu tii doo. ");
INSERT INTO bvd_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Faarisii da ade 'uri nai lelea oli daka ledia lau sa wala nai maana 'ifi naa nai, daka 'urii, “'Oe naa nai sa wala nai 'ifingia maamu nai. Aia, tee gu ne 'oe saea suli nia?” Ma nia ka 'urii, “Sa wala nai gu ne, nia na brofet lau guu.” ");
INSERT INTO bvd_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ma na toa gwaungai nai Diu ki, daka ote kera guu 'ana faamamane lana ne sa wala nai maana 'e rodo mai 'i nao. Ma kera daka saea fua maa nia fainia gaa nia sa wala nai uri daru ka lea mai siada. ");
INSERT INTO bvd_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ma kera daka ledi 'urii 'ani keerua, “Nee wala, na wela nee na wela kamurua mamana nee? Kamurua muru saea wela nee futa boroi mai maana ka rodo 'ua guu, ma sui tee ne adea maana ka 'ifi lau gwana nee?” ");
INSERT INTO bvd_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ma na maa nia fainia gaa nia, keerua luu kera daru ka 'urii, “Kaaria saitomana nia na wela kaaria naa ne. Miri ka saitomana lau guu ne nia futa boroi mai maana ka rodo 'ua guu. ");
INSERT INTO bvd_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ma sui ta, tee ne adea maana ka 'ifi naa nee, kaaria boroi miri ulafusia lau gwamiri ne. Kamolu molu leditona fasi kau, suli nia waa baite naa ne. Nia bobola fai ka bae 'ana suli nia 'i tala'ana!” ");
INSERT INTO bvd_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Na maa nia fai gaa nia keerua bae 'uri nai sulia daru mau lau gwadaru 'ana toa gwaungai nai Diu ki. Suli kera saea ka talo naa, lea ta waa 'e saea sa Disas nia na Kraes, waa nai kera daka luia nao si ruu laona beu ni ofu laa kera nai. ");
INSERT INTO bvd_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nia ne adea maa nia fainia gaa nia daru ka bae gwadaru 'urii, “Nia waa baite naa ne, molu tala leditona 'amolua kau!” ");
INSERT INTO bvd_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Sui kera daka 'ailia lau mai sa wala nai maana rodo mai 'i nao nai, daka bae 'urii fuana, “'O tofe fasi 'i maana God uri meli ka saea 'o bae mamana. Kameli meli saitomana sa wala na waa abulo ta'aa gwana na.” ");
INSERT INTO bvd_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ma sa wala nai 'e lilio naa nai 'e luu kera ka 'urii, “Nau nao kwasi saitomana lau gwaku ne nia ta waa diana ma nao ta waa ta'aa gwana. Tii si doo ku saitomana naa ne maaku 'e rodo mai 'i nao, ma sui 'i tari'ina na maaku ka 'ifi naa nee.” ");
INSERT INTO bvd_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kera daka ledi 'urii lau 'ani nia, “Nee wala, nia 'ifingi 'utaa gu 'ana maamu?” ");
INSERT INTO bvd_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ma sa wala nai 'e luu kera ka 'urii, “Nau ku saea sui na fuamolu bae, ma sui kamolu ka nao molu si doori rongo guu. Tee gwana ne molu doori rongo lau uria? Ma nao kamolu dooria uri kamolu toa kwairooi nia ki lau gu nee?” ");
INSERT INTO bvd_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kera daka bae ta'aa fuana daka 'urii, “'Oe 'ana ne waa kwairooi nia wala. Kameli toa kwairooi sa Mosis ki lau 'ana ne. ");
INSERT INTO bvd_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Suli sa Mosis 'ana ne meli saitomana God bae mai fainia. Ma kaa waa 'uri nee, na maefera ne nia lea boroi mai faasia, kameli ulafusia!” ");
INSERT INTO bvd_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ma sa wala nai 'e luu kera ka 'urii, “Nau ku kwele 'asia naa ne molu saea kamolu ulafusia fera ne sa wala nee lea mai faasia. Ma sui nia naa ne 'ifingia maaku ka 'ifi nee. ");
INSERT INTO bvd_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kolu sui guu kolu saitomana God nia 'afitai ka rongoa gani laa ne ta waa abulo ta'aa gwana gania siana. Waa God ki ne kera ilia doori lana God, kera 'ana ne God nia kai rongo kera. ");
INSERT INTO bvd_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nao ta waa si rongo 'ua mai ta waa ne 'ifingia maana ta waa ne maana rodo ma gaa nia ka kwalafia 'ua gu mai fainia. ");
INSERT INTO bvd_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Sa wala nee waa God na mone 'ana fale nia mai ne, suli lea God nao si fale nia mai, nia 'afitai ka ilia si doo nai.” ");
INSERT INTO bvd_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ma kera daka rakesasu 'asia naa, ma daka bae 'urii fuana, “Ni 'oe 'o futa 'ua gu mai laona abulo ta'aa lae bae. Tee gwana ne sae 'oe dooria 'oko toolangainia siameli nee?” Ma kera daka tari nia naa fasi laona beu ni ofu laa kera nai. ");
INSERT INTO bvd_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Sa Disas 'e rongo ne kera da ili 'uri nai 'ana sa wala nai. Si kada sa Disas 'e dao tona sa wala nai sa Disas ka bae 'urii, “Ni 'oe 'o manata mamana naa 'ana 'Alakwa nia Wane?” ");
INSERT INTO bvd_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ma sa wala nai 'e luua ka 'urii, “Nee waa baita kani 'ae, na waa nai sa tii gu nai? Ma 'oe faarongo nau uri nau ku manata mamana 'akua 'ani nia!” ");
INSERT INTO bvd_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ma sa Disas ka bae 'urii fuana, “'Oe suana naa ne, ma tee nia naa ne 'oe bae gwamu fainia nee.” ");
INSERT INTO bvd_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ma sa wala nai ka 'urii, “Aofia 'ae, nau ku manata mamana naa 'ani 'oe.” Sa wala nai ka booruru 'i 'aena sa Disas ka faabaitaa naa. ");
INSERT INTO bvd_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Sa Disas ka bae 'urii, “Nau ku lea mai lao fera ne 'i saegano uri tolidoo lae ne. Tee uri toaa ne da maa bobono 'ana doo God ki, nau kwai 'ifingia maada ka 'ifi. Aia ma toaa ne da bae naunau saea kera filoa gwada doo God ki, kera da kai maa bobono daka too gwada.” ");
INSERT INTO bvd_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ma tai waa 'ana Faarisii nai ki da gooru fainia sa Disas 'i seeri, kera rongo sa Disas nia saea si doo nai kera daka ledi 'urii 'ani nia, “'Oe 'o manata toi 'amua ni kameli lau gu ne maa meli rodo nai?” ");
INSERT INTO bvd_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ma sa Disas 'e luu kera ka 'urii, “Lea sa kamolu abulo ta'aa boroi ma fafona ne molu maa bobono gwamolu 'ana doo ki, kamolu ka nao molu si garo guu. Kamolu molu saea molu lio saitomana gwamolu, nia ne God nia kai kwae kamolu faafia.” ");
INSERT INTO bvd_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Sa Disas ka bae lau 'urii, “Doo mamane ku saea fuamolu ne, na waa ne nao si ruu mai 'ana mae 'o'olo 'ana sakali sifsif ki, ma ka raa gwana mai 'ana ta kula 'e'ete 'ana sakali nai, nia na waa bebeli. ");
INSERT INTO bvd_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ma na waa ne nia ruu mai 'ana mae 'o'olo 'ana baa, nia ne waa mamane ni sua lae suli sifsif ki. ");
INSERT INTO bvd_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Na waa ni sua lae sulia maesakaa 'ana sakali, nia kai 'ifingia maesakae fua waa ni sua lae sulia sifsif. 'I seeri, na waa nai ni sua lae suli sifsif ki, nia kafi ruu mai siada. Ma na sifsif nai ki daka rongo saitomana lingena. Nia ka 'ai satana sifsif nia nai ki si kada 'e talai kera kau 'i maa. ");
INSERT INTO bvd_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ma si kada nia 'e talaia kau sifsif nia ki 'i maa, nia 'e liu 'i nao 'ani kera ma ni kera daka lea na 'i burina suli da rongo saitomana lingena. ");
INSERT INTO bvd_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ma ni kera tara 'afitai daka lea buri waa 'e'ete. Si doo ne kera kai ilia 'ada ne tafi lae fasi waa 'e'ete, suli kera nao dasi rongo saitomana lingena.” ");
INSERT INTO bvd_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Sa Disas 'e bae 'ana tarifula laa nee fuada, ma sui boroi kera nao dasi saitomana guu malingai lana. ");
INSERT INTO bvd_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nia ne adea sa Disas ka bae lau 'urii, “Doo mamane ku saea fuamolu ne, nau naa ne talafana mae 'ana sakali sifsif ki. ");
INSERT INTO bvd_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Toaa neki sui guu da eta dao mai 'i nao 'ani nau, kera na waa bebeli ki ma na waa ni laudoo lae ki gwana, sui boroi 'ana na sifsif ki kera nao dasi rongo gu suli toaa nai. ");
INSERT INTO bvd_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nau naa ne talafana mae 'ana sakali sifsif ki uri ruu lae ai. Tii gwana ne nia ruu mai 'ani nau, nau kwai faamauri nia. Nia kai ruu mai 'i lalo ma kai oli kau 'i maa, ma nia kai dao tona si fange fuana. ");
INSERT INTO bvd_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Na waa bebeli, nia lea gwana mai uri beli lae ma uri sauwane lae ma faafunui lana doo ki. Nau 'ana ne ku lea mai uri molu ka too 'ana maurie ali'afu 'i nunufaku. ");
INSERT INTO bvd_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nau naa ne talafana waa diana ni sua lae sulia sifsif ki. Ne nia suasulia sifsif nia ki ma ka noni maabe uri mae lae suusi kera. ");
INSERT INTO bvd_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ma na waa ne da foli nia lau gwada uri sua lae sulia sifsif tai waa ki, nia nao lau waa 'e gwaungai 'ana sifsif nai ki. 'Uri nai, lea si kada nia suana giri kwasi ki da lea mai, nia tara ka lukasia sifsif ki ma ka tafi lau gwana. Ma na giri kwasi ki lea mai daka saungia sifsif ki, ma daka tagalangai kera kwailiu. ");
INSERT INTO bvd_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Na waa nai ka tafi naa, suli nia rao gwana uri si malefo da foli nia ai ma ka nao si 'abarua guu 'ana sifsif nai ki. ");
INSERT INTO bvd_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nau naa ne talafana waa diane ni sua lae sulia sifsif ki. Toaa nau ki ne kera talafana sifsif nau ki, nau ku saitomada ma kera daka saitomaku, ");
INSERT INTO bvd_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ka mala lau gu ne Maa nau nia saitomaku, ma nau ku saitomana Maa nau. Ma nau ku falea naa mauria nau fua sifsif nai ki. ");
INSERT INTO bvd_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ma 'aku tai sifsif ki lau guu, ne kera nao dasi nii 'ua lao sakali nee. Nau kwaitalai kera lau gu mai. Kera lau guu da kai rongo saitomana lingeku, ma nau kwai too guu 'ana tii ferae sifsif ne kera too kwaimani lao tii baa, ma daka too guu 'ana tii waa ni sua lae suli kera, ne ni nau naa. ");
INSERT INTO bvd_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Na Maa nau 'e liosau 'ani nau, suli nau ku noni maabe uri mae lae uri sui ku mauri lau gwaku. ");
INSERT INTO bvd_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nao ta waa si saumaeli nau, suli nau 'ana ne ku tala faolomainia mangoku ka liu sulia manata laku. Nau ku too 'ana rigitaa uri mae lae ma tatae lae fasi maea. Si baea fifii nai, na Maa nau ne saea fuaku uri ku ili sulia.” ");
INSERT INTO bvd_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ma si kada nai, toa Diu ki kera nao dasi alua lau guu tii si manata laa suli doo nai ki sa Disas saea. ");
INSERT INTO bvd_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","'Oro lada daka bae 'urii, “Sa wala nee oewanea ma ka too 'ana anoedoo ta'ae. Nao molu si roo suli nia!” ");
INSERT INTO bvd_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ma sui tai waa daka bae 'urii, “Na waa 'e too 'ana anoedoo ta'ae, 'afitai nia ka bae 'uri nee sa wala nee ilia! Ma na waa ne too 'ana anoedoo ta'ae, 'afitai nia ka guraa waa maarodo ki 'uri ne sa wala nee ilia!” ");
INSERT INTO bvd_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Otofana si kada gwagwari'olaa nai, na toa Diu ki kera da koni mai 'i Durusalem 'ana Fafangaa 'ana Faa Abu lana lau Beukaua nai. ");
INSERT INTO bvd_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Sa Disas 'e nii lau guu laona Beukaua nai, ma si kada nai nia 'e kali gwana lao bali tafasusu nai sa Solomon. ");
INSERT INTO bvd_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Aia, si kada toaa nai ki da suana, kera daka koni na mai kali nia ma daka ledi 'urii 'ani nia, “Kameli meli maasi 'oe mai ka tau naa nai. 'Oe faarongo folaa na 'ani kameli! Nia sae 'oe naa ne na Kraes bae nee, ma nao 'e nao lau ni 'oe?” ");
INSERT INTO bvd_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Sa Disas 'e luu kera ka 'urii, “Nau ku saea sui na mai fuamolu bae, ma sui boroi ka nao molu si doori faamamane nau guu. Na raoa neki nau ku ilia ki nee, na Maa nau ne saea fuaku uri ili lana ki, ma na raoa neki ne faatainia ni nau waa tee nee. ");
INSERT INTO bvd_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ma sui ka 'uri nai boroi 'ana, kamolu nao molu si doori faamamanea guu, suli kamolu nao lau sifsif nau ki. ");
INSERT INTO bvd_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Na sifsif nau ki, kera ne da rongo saitomana lingeku ma nau ku saitomada, ma kera daka lea 'i buriku. ");
INSERT INTO bvd_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nau ku falea mauria firi fuada, ma kera 'afitai daka funu. Nau ku dau faafi kera, ma 'afitai ta waa ka lau kera faasi nau. ");
INSERT INTO bvd_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Na Maa nau waa ne fale kera fuaku, na rigitaa nia 'e talua doo ki sui guu. Nia 'e dau faafi kera, ma ka 'afitai ta waa ka lau kera faasi nia. ");
INSERT INTO bvd_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Kaaria Maa nau fai nau, kaaria tiidoe guu.” ");
INSERT INTO bvd_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Si kada nai lau guu, na toaa nai daka koni fau na mai uri 'uifau lana sa Disas uri saumaeli lana. ");
INSERT INTO bvd_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ma sa Disas ka ledi 'urii 'ani kera, “Na raoa diana 'oro nai ki Maa nau saea nau ku ilia ki mai, kamolu suai sui naa nai. Si raoa tee guu 'ana raoa nai ki ne kamolu doori saumaeli laku faafia?” ");
INSERT INTO bvd_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ma kera luua daka 'urii, “Kameli nao meli si doori 'uifau lamu guu fafo raoa diana nai ki. Kameli kai 'uifaumu lau 'ameli faafia ne 'oe bae ta'aa suli God ne. Suli ni 'oe na wane gwana, ma 'oko saea 'oe God!” ");
INSERT INTO bvd_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Sa Disas 'e luu kera lau ka 'urii, “Si baea nia God da kedaa mai ka nii lao taki kamolu 'e bae 'urii, ‘Nau ku saea sui naa, ni kamolu na god ki.’ ");
INSERT INTO bvd_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","God nia saea toaa nai nia falea bae lana fuada, kera na god ki, aia ma si baea nai ka abu ka nii lao taki ne 'afitai daka 'oia lau. ");
INSERT INTO bvd_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ma lea si baea nai 'e 'o'olo ma ka abu, tama nau waa ne God fili nau mai ma ka fale nau mai fua lao fera ne 'i saegano, na bae laku nia 'o'olo ma ka abu lau guu. Sui 'utaa ne molu ka saea nau ku bae ta'aa suli God, si kada ku saea nau na 'Alakwa nia God? ");
INSERT INTO bvd_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Lea nao nau kwasi ilia na raoa neki Maa nau dooria kwai ilia, kamolu tara 'afitai molu ka manata mamana gu 'ani nau. ");
INSERT INTO bvd_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Sui ma nau ne ku ilia naa raoa ne Maa nau ilia lau guu. Nia 'uri, molu faamamanea mone 'amolua doo kwaibalatana neki nau ku ilia, lea nao molu si faamamanea boroi doo neki ku saea fuamolu. Ade 'uri nai ne uri molu ka saitoma diana 'ana si malutaa ne Maa nau 'e nii 'ani nau ma nau ku nii 'ana Maa nau.” ");
INSERT INTO bvd_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","'I seeri, kera daka dooria dau lana lau gu sa Disas, ma sui nia ka agwa 'ana faasi kera. ");
INSERT INTO bvd_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Sui sa Disas oli kau ka ulu lau gwana 'ana kafo 'i Diodan uri bali loko, nia ka lea na kau uri kula bae sa Dion nia faasiuabua mai toae ki ai 'i nao. Nia ka too fasi 'ana 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ma toaa 'oro nai ki daka lea mai daka dao siana sa Disas. Kera da bae lau gwada fuada ki tala'ada daka 'urii, “Sui boroi 'ana sa Dion ka nao si ilia gu mai ta doo kwaibalatana, si doo ne nia saea ki mai suli sa wala nee, nia mamana sui guu.” ");
INSERT INTO bvd_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ma toaa 'oro 'i seeri ki daka manata mamana 'ana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Tii waa satana sa Lasaros nia matai. Nia waa 'i Betanii, na maefera keerua lau guu roo waisaasina baki ni Meri fai ni Maata. ");
INSERT INTO bvd_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ni Meri ai nai bae 'e kistainia waiwai moko diana bae fua 'aena sa Disas na Aofia, ma ka kanoa 'ana ifuna 'i tala'ana. ");
INSERT INTO bvd_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Na mataia nai adea roo waisaasina nai ki keerua daru ka falebaea kau uri sa Disas daru ka 'urii, “Aofia 'ae, na waa kwaimani diana 'oe bae ne nia matai.” ");
INSERT INTO bvd_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Si kada sa Disas rongo si faarongoa nai, nia ka bae 'urii fuana toa kwairooi nia ki, “Na mataia nee ka saungi nia boroi 'ana tara nao si maelia gu ne. Tee nia doo gwana uri daka tafoa satana God faafia nee, ma 'uri daka lio saitomana rigitaa nau 'Alakwa nia God.” ");
INSERT INTO bvd_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Sa Disas nia liosau 'ana sa Lasaros fai roo waiwane nia ki ni Maata fai ni Meri. ");
INSERT INTO bvd_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Sui ta si kada nia rongo nai sa Lasaros nia matai, nia ka too lau kau 'ana kula nai nia nii ai suli roo fa dani. ");
INSERT INTO bvd_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Sui nia ka bae 'urii fuana toa kwairooi nia ki, “Kolu oli lau uria 'i Diudia.” ");
INSERT INTO bvd_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ma sui toa kwairooi nia ki kera luua daka 'urii, “Waa toolangaidoo 'ae, nia nao si tau 'ua gu nai burina bae toaa Diu ki kera doori 'uifau lamu uri saumaeli lamu. Ma 'oe doori oli lau guu 'i seeri uri tee?” ");
INSERT INTO bvd_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ma sa Disas ka bae 'urii, “Wala 'ae fa sato 'e tau ka dao fatai 'ana taafuli kada sato ma roo kada sato sarenga ki. Lea waa 'e liu lao dani, nia 'afitai ka lakwadora, suli faanoe folaa gwana lao fera ne 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Si kada lea nia 'e galo lao rodo lau 'ana ne nia kai lakwadora, suli nia nao si too 'ana ta kwesu.” ");
INSERT INTO bvd_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nia bae 'uri nai sui, nia ka bae lau 'urii, “Na waa kwaimani kolu sa Lasaros nia maleu naa. Sui boroi 'ana nau tara lea kwai faa ada nia.” ");
INSERT INTO bvd_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Na toa kwairooi nia ki kera luua daka 'urii, “Aofia 'ae, lea sae nia maleu gwana, 'oo ma nia kai 'akwaa lau gwana.” ");
INSERT INTO bvd_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Sa Disas talafana nia saea sa Lasaros nia mae naa nai, ma sui kera daka kwaifii gwada sae nia maleu mamana gwana. ");
INSERT INTO bvd_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","'I seeri, sa Disas ka faarongo folaa na ai fuada ka 'urii, “Sa Lasaros nia mae naa bae. ");
INSERT INTO bvd_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Sui boroi 'ana uri ka diana fuamolu, nau ku manata ele gwaku ne nau nao kwasi too boroi fainia, uri kamolu ka manata mamana 'ani nau. Aia, kolu lea na siana nai.” ");
INSERT INTO bvd_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Sa Toomas (ne kera 'ailia lau guu 'ana 'Iu) ka bae 'urii fuada kera toa kwairooi ki, “Kolu lea 'akolu fainia waa toolangaidoo, uri kolu ka mae lau gu fainia!” ");
INSERT INTO bvd_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Sa Disas 'e dao ka rongo kera saea sa Lasaros 'e mae daka alua lao likwafau ka tio suli fai fa dani ki sui naa. ");
INSERT INTO bvd_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Na maefera 'i Betanii 'e nao si tau guu fasi Durusalem. Bobola gu fainia ta olu fa kilomita gwana uri lea lae kau uria. ");
INSERT INTO bvd_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nia 'uri nai, na toaa 'oro fasi Durusalem kera daka lea kau uri gwafe lana ni Maata fai ni Meri 'ana si kada nai waiwane keerua nia mae nai. ");
INSERT INTO bvd_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Si kada ni Maata 'e rongo sa Disas nia dao na mai, nia ka lae na kau uri toda lae 'ani nia maa taale. Ma ni Meri ka too gwana kau 'i luma. ");
INSERT INTO bvd_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ni Maata ka bae na 'urii fua sa Disas, “'Oo Aofia 'ae, lea sae 'o too gwamu 'i seki fera, na waiwane nau sa ka mae gu nao. ");
INSERT INTO bvd_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Sui boroi 'ana, nau ku saitomana sa 'i tari'ina boroi 'ana, God kai falea gwana ta tee ne 'oe kai gania siana.” ");
INSERT INTO bvd_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ma sa Disas ka bae 'urii fuana, “Na waiwane 'oe, nia kai tatae lau gwana fasi maea.” ");
INSERT INTO bvd_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ma ni Maata ka bae 'urii fua sa Disas, “Iuka, nau ku saitomana gwaku ne nia kai tatae lau gwana fasi maea 'afa dani 'isi si kada 'ana tatae laa fasi maea.” ");
INSERT INTO bvd_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ma sa Disas ka bae 'urii fuana, “Nau naa ne tatae laa fasi maea ma na maurie. Tii gwana ne nia manata mamana 'ani nau nia kai mauri lau gwana, sui boroi 'ana nia ka mae naa. ");
INSERT INTO bvd_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ma tii gwana ne nia mauri 'ua gwana ma ka manata mamana 'ani nau, nia 'afitai ka mae. 'Oe 'o faamamanea si doo nai?” ");
INSERT INTO bvd_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ma ni wala nai 'e luua ka 'urii, “Tee mone Aofia. Nau ku faamamanea ni 'oe na Kraes bae naa ne. Ni 'oe na 'Alakwa God bae da saea nia kai lea mai uri lao fera ne 'i saegano naa ne!” ");
INSERT INTO bvd_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ni Maata 'e bae 'uri nai sui, nia ka oli na mai dao ka 'ailia toolana ni Meri ka lea kau siana uri ka faarongo tu'uu 'ani nia. Nia ka bae 'urii fuana, “Na waa toolangaidoo 'e dao naa, ma nia ledi uri 'oe.” ");
INSERT INTO bvd_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Si kada ni Meri 'e rongo si doo nai, nia ka tatae ka lea 'ali'ali na kau siana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Sa Disas nia nao si dao si sakatafa 'ua mai lao si maefera nai, suli 'e nii 'ua gwana mai 'ana si kula bae ni Maata 'e toda nia ai. ");
INSERT INTO bvd_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Toaa nai ki da lea mai daka nii luma sia ni Meri uri gwafe lana, kera suana nia 'ali'ali tatae ka ruu kau 'i maa. Si kada kera suana 'uri nai, kera daka ruu lau gu kau uri maa 'i burina. Kera kwaifii sa nia 'e lea uri maana likwafau bae uri ka angi 'ana 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Si kada ni Meri 'e dao naa 'ana kula bae sa Disas nii 'ua mai ai, nia ka suana naa. Nia ka booruru 'i maa 'aena sa Disas, ma ka bae 'urii, “Aofia 'ae, lea sa 'oe too gwamu 'i seki fera, na waiwane nau saka mae gu 'urii nao.” ");
INSERT INTO bvd_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Sa Disas 'e suana ni Meri nia angi, ma ka suana toaa nai da lea mai fainia da angi sui gwada, nia liona ka dila 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ma nia ka ledi kera ka 'urii, “Kamolu alu nia 'i fai?” Kera daka luu nia daka 'urii, “Aofia 'ae, lea mai 'urii, uri 'oko tala suana.” ");
INSERT INTO bvd_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Sa Disas ka angi. ");
INSERT INTO bvd_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Toaa nai Diu kera daka bae 'ada fuada kwailiu daka 'urii, “Kamolu suana nai, na liosaua nia fua sa Lasaros 'e baita 'asia naa nai!” ");
INSERT INTO bvd_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ma tai toaa daka bae 'urii, “Nia guraa mai toaa maada rodo ki. Ma sui 'utaa ne nia nao si luia sa Lasaros fasi mae lae?” ");
INSERT INTO bvd_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Sa Disas liona ka dila 'asia naa ma nia ka lea naa uri maana likwafau nai. Na likwafau nai, na likwafau baita da 'elia ka tio naa, ma ka too 'ana aba fau ni bilaki lae suusia maana. ");
INSERT INTO bvd_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ma sa Disas ka bae 'urii fuada, “Molu 'idua fasi kau fau loko fasi maa likwafau loko!” Ni Maata waiwane nia sa wala nai 'e mae 'e luua sa Disas ka 'urii, “Aofia 'ae, nia doo 'e tio na mai lao likwafau nee suli fai fa dani ki ne. Tara dao 'uri nai nia moko naa na wala!” ");
INSERT INTO bvd_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ma sa Disas ka bae 'urii fuana, “'Oe nao si rongo gu bae nau ku saea sui na fuamu, bae lea 'o manata mamana 'ani nau tara 'oko suana dianaa God?” ");
INSERT INTO bvd_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","'I seeri kera daka 'idua fau nai ka too 'e'ete na kau. Sui sa Disas 'e lio 'alaa 'i langi ka foa ka bae 'urii, “Maa 'ae, nau ku tango 'oe suli si doo ne ku gania siamu, 'oe 'o rongo naa. ");
INSERT INTO bvd_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nau ku saitomana sui naa ne 'oe rongo nau 'ana si kada ki sui guu. Sui ta nau ku bae 'uri nai fuamu 'i tari'ina, uri toaa ne da uu 'i seki nee daka faamamanea ne 'oe fale nau mai.” ");
INSERT INTO bvd_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nia bae 'uri nai sui, nia ka 'ai baita ka 'urii, “Lasaros, 'o ruu mai maa!” ");
INSERT INTO bvd_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ma nia waa mae nai ka ruu gwana mai 'i maa, fai maku nai ki da kani faafia 'ana 'abana ki ma 'aena ki, ma maku nai ki da 'afu suusia maana ki ai. Ma sa Disas ka bae 'urii fuada, “Molu lukea maku naki faasi nia sui molu ka luka 'ani nia ka lea 'ana.” ");
INSERT INTO bvd_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Maana gu si doo nai sa Disas ilia nai, toaa 'oro Diu ki kera daka lea mai sia ni Meri ma daka suai ma daka manata mamana naa 'ana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ma sui boroi 'ana, bali 'ani kera daka lea na siana Faarisii ki, ma daka faarongo kera naa 'ana doo neki sa Disas nia ilia ki mai. ");
INSERT INTO bvd_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Sui, na Faarisii ki fai waa baita ni foa ki daka bae ofu lelea daka alu tii si manata laa naa fai toaa ulu nao ki sui guu, kera daka bae 'urii, “Tee gu ne kolu kai ilia 'ana sa wala nee? Suli doo kwaibalatana 'oro naa ne nia ilia mai. ");
INSERT INTO bvd_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ma lea kolu lio ekwa gwakolu 'ana sa wala nee, nia ka ili gwana 'urii lelea toaa nee sui guu ne kera kai faamamane nia. Ma tara na toa gwaungai 'i Rom ki, kera da kai rakesasui kolu fainia. Ma lelea kera rakesasui kolu naa, tara kera da kai taga 'ana Beukaua nee, ma da kai faafunuia fera kia nee ne!” ");
INSERT INTO bvd_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","'I seeri ta waa 'ani kera lau guu ne satana sa Kaeafas na waa foa ni gwau kera 'ana si kada nai nia ka bae 'urii, “Kamolu 'ua ne molu ulafusidoo 'asia guu! ");
INSERT INTO bvd_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Bobola fainia sa molu ka saitomana sui naa, ne tii kaa waa gwana lea ka mae boroi 'ana ka diana gwana ne, 'uri ka nao dasi faafunui tiifau lau 'ana fera nee.” ");
INSERT INTO bvd_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Si baea nai sa Kaeafas nia saea nai, ka nao lau si baea suli manata lana 'i tala'ana gwana. Suli nia na waa foa ni gwau 'ana si kada nai, nia ne God ka faatainia si manata laa nai 'i liona. Si baea nai totoo kai mamana suli si doo ne kai fuli 'ana sa Disas, ne nia kai mae uri 'adomi lana toaa Diu ki. ");
INSERT INTO bvd_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ka nao lau fua otona gwana toaa Diu ki. Nia mae fua toaa God ki sui gwana ne kera tagabola sui gwada 'ana kula 'e'ete ki kwailiu uri kera daka tiidooa. ");
INSERT INTO bvd_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Safali 'uri nai 'afa dani nai sa Kaeafas 'e saea si baea nai, kera daka 'olea naa sa Disas uri lelea daka saungi nia. ");
INSERT INTO bvd_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Fafona si ade laa nai da ilia na 'ani nia, sa Disas ka nao si liu faatai naa 'ana bali lolofaa nai 'i Diudia. Nia fai toa kwairooi nia ki daka lea daka too nada 'ana maefera nai satana 'Ifrem, ne nii karangia naa bali fera kwasi baita nai. ");
INSERT INTO bvd_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Aia, nia dao karangia naa si kada bae 'ana Fangatasae bae toaa Diu ki nai. Ma toaa 'oro daka lea na kau 'i Durusalem 'aena fafangaa nai uri faafaalu lae maasia fafangaa nai. ");
INSERT INTO bvd_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ma kera daka nani gwada uri sa Disas. Si kada kera da uu ki laona lalo nai 'ana beukaua nai, kera daka ledi kera kwailiu ki gwada 'urii, “Nee, kamolu manata 'utaa? Sa wala bae 'e nii boroi nonina fafangaa nee, ma nao 'e nao guu?” ");
INSERT INTO bvd_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Sui ka nao dasi saitoma diana boroi ai, na waa baita ni foa ki fainia Faarisii ki, kera da faarongoa sui naa toae ki ma daka bae na 'urii, “Lea ta waa 'e saitomana si kula ne sa Disas nii ai, nia ka faarongo kameli uri meli ka dau nia naa.” ");
INSERT INTO bvd_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Dao 'ana ono fa dani sui guu na fafangaa 'ana Fangatasae ka liu, sa Disas fainia toa kwairooi nia ki daka oli lau gwada uri Betanii, na maefera bae sa Disas nia tataea sa Lasaros ai faasi maea. ");
INSERT INTO bvd_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kera daka rao fanga 'i seeri fua sa Disas. Sa Lasaros ka nii fai toaa nai da 'aili kera mai uri fanga kwaimani laa nai fainia sa Disas, ma ni Maata ka rao fanga fuada. ");
INSERT INTO bvd_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ma ni Meri ka ngali mai tii bii waiwai moko diana nai ma liu lana ka baita 'asia naa. Nia lea mai ka kistainia naa fafo 'aena sa Disas uri faa'inito lana ai. Sui ni Meri liu ka usua 'ae sa Disas 'ana ifuna 'i tala'ana. Ma si kada nai, na momokona waiwai nai ka moko ka 'etengaa guu lao luma nai. ");
INSERT INTO bvd_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ma sui sa Diudas 'Iskariot, na waa 'ana toa kwairooi baki sa Disas bae nia falea sa Disas fua malimae ki, nia ka nao si ala faafi si doo nai nia ka bae na kau 'urii, ");
INSERT INTO bvd_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Tee ne adea 'oe nao 'osi foli 'amua 'ana waiwai nee uri ta malefo uri fale lana fua toaa siofaa ki nee? Na bii waiwai nai liu lana 'e mala gu fofolia nia tii waa ni rao lao tii fa ngali laulau.” ");
INSERT INTO bvd_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Sa Diudas 'e nao si saea lau si doo nai suli ne nia manata 'abarua 'ana toaa siofaa ki. Nia 'e saea lau 'ana suli nia ta waa bebeli lau guu, ne nia kai lio suli wai malefo kera. Ma si kada 'oro, nia 'e belia gwana malefo nai fuana tala'ana. ");
INSERT INTO bvd_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","'I seeri sa Disas ka bae 'urii, “Nao 'osi bae tona lau 'uri nai! Na waiwai nee si doo ni wala nee 'e taingainia na mai uria ne, uri ka 'ikia 'i noniku fa dani ku mae daka alu nau naa. ");
INSERT INTO bvd_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Na toaa siofaa nee kera da too siamolu ka lelea firi gwana. Sui ta, ni nau ne nao kwasi too si tau guu fai kamolu.” ");
INSERT INTO bvd_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Toaa 'oro 'ana Diu ki si kada kera rongo ne sa Disas 'e nii gwana 'i Betanii, kera daka lea na mai seeri. Nao lau otona gwana uri ne kera da doori sua lana sa Disas. Kera lea mai uri sua lana lau guu sa Lasaros waa bae sa Disas tatae nia fasi maea. ");
INSERT INTO bvd_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ma 'i seeri guu na waa baita ni foa ki daka doori saumaelia lau guu sa Lasaros, ");
INSERT INTO bvd_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","suli toaa Diu nai ki si kada kera suana sa Lasaros nia tatae faasia maea, 'oro lada daka lukasia waa baita ni foa nai ki daka manata mamana lau na 'ada 'ana sa Disas. ");
INSERT INTO bvd_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tio 'e dani, na konia nai da lea ki mai 'ana Fangatasae nai, daka rongo sa Disas nia lea na mai uri Durusalem. ");
INSERT INTO bvd_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kera lea daka ngalia mai ulu ulu nai 'ana sarana doo mala niu, daka suungi daka lea na mai uri toda lana sa Disas ma daka bae 'urii, “Tangoa God ka tasa! 'E diana tasa fua waa ne God fale nia ka lea mai 'ana satana nee! 'E diana tasa fuana, nia na Waa 'inito fua 'Israel!” ");
INSERT INTO bvd_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Sa Disas ka raa ka gooru naa fafona dongki kafi baita nai. Si ade laa nai ka fulingainia naa si baea lao kekeda laa Abu ne bae 'urii, ");
INSERT INTO bvd_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kamolu toaa 'i Durusalem, nao molu si mau lau! Suana fasi nee, na waa 'inito kamolu ne gooru fafona dongki kafi baita nee ka lea na mai nee.” ");
INSERT INTO bvd_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Si kada nai toa kwairooi sa Disas ki da suana si doo nai fuli nai, kera nao dasi saitomana 'ua. Totoo lea 'i buri naa kada sa Disas nia tatae fasi maea ka oli naa uri salo, kera dafi filoa ne si kekeda laa Abu baki da bae gwada mai suli sa Disas ma suli si doo nai da ilia mai 'ani nia nai. ");
INSERT INTO bvd_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Na toaa 'oro bae da koni fai sa Disas si kada bae nia 'ai uri sa Lasaros fasi lao likwafau bae ma ka tatae nia fasi maea, kera dau 'ua gwada 'ana faarongo tatalo lae suli si doo nai ki fua toae ki sui gwana. ");
INSERT INTO bvd_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nia ne adea toaa 'oro nai ki daka lea mai uri toda lana sa Disas nai. Toaa 'oro, kera da lea mai uri toda lana sa Disas, suli kera da rongo ne sa Disas nia ilia mai si doo kwaibalatana nai 'ana sa Lasaros. ");
INSERT INTO bvd_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","'Uri nai guu, na Faarisii ki daka bae 'urii 'i matangada kwailiu, “Kamolu suai nai, kolu ilitoi boroi ka nao naa nai! Tee molu liotoi konia nee sui naa ne kera 'ado fai sa wala nee nee!” ");
INSERT INTO bvd_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Aia si kada nai, tai waa faasia 'i Gris mai, kera lea kwaimani lau gu kau uri foa lae lao Fangatasaa nai 'i Durusalem. ");
INSERT INTO bvd_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Kera lea daka dao siana sa Filib, waa nai faasia 'i Betsaeda 'ana bali lolofaa 'i Galilii, daka bae 'urii fuana, “Waa baita kani 'ae, kameli dooria meli ka suana 'amelia sa Disas ne.” ");
INSERT INTO bvd_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Seeri sa Filib nia lea ka faarongoa sa 'Andru, sui keerua sa 'Andru lea daru ka faarongoa naa sa Disas. ");
INSERT INTO bvd_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Sa Disas 'e luu keerua ka 'urii, “Si kada nau na 'Alakwa nia Wane, nia dao naa uri God ka faatai folaa 'ana 'initoaa nau. ");
INSERT INTO bvd_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Si doo mamane ku saea fuamolu ne, na miga doo ni fasi lana, lelea nia nao si 'asia laona saegano ma ka nao si mae guu, nia 'afitai ka bulao guu 'ana tai doo lau. Lea nia 'asia lao saegano ma ka mae taari, nia ka bulao 'ana doo 'oro ki. ");
INSERT INTO bvd_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Talafana lau guu nai, lea waa 'e onia 'ana mauria nia uri ka lau 'ana, na mauria nia kai funu gwana. Aia ma lea waa 'e nao si onia guu mauria nia lao fera ne 'i saegano, waa nai kai too 'ana mauria firi. ");
INSERT INTO bvd_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tii gwana ne dooria kai rao fuaku, nia ka lea mai buriku, uri nia waa ni rao nau nai ka too lau guu 'ana si kula ne ku too ai. Na Maa nau, nia kai falea kwaiaraa fua waa ne rao fuaku. ");
INSERT INTO bvd_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Si kada nai, manata laku nia isifufuli naa. Ma nau ku ulafusia naa, tara ku bae 'urii 'oto, ‘Maa 'ae, 'o lau nau 'amua kau faasia si kada sato nee 'ana nonifiia.’ Nao, nau 'afitai ku foa 'uri nai suli si doo bae nau ku lea na mai uria ne uri nonifii lae nee. ");
INSERT INTO bvd_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Maa 'ae, 'o tafoa 'amua satamu 'i langi!” Sui tii si lingee doo nai ka talo mai faasia 'i salo ka bae 'urii, “Nau ku tafoa naa sataku 'i langi, ma tara nau ruana kwai ilia lau.” ");
INSERT INTO bvd_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Na konia nai kera da uu 'i seeri, kera rongo si lingee doo nai daka saea 'ana kukurue. Ma sui bali ada ka bae 'urii, “Na 'ensel nai 'e bae mai fuana nai!” ");
INSERT INTO bvd_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Sui sa Disas ka bae 'urii fuada, “Uri diana lae ka dao tomolu, nia nai si lingee doo nai ka bae mai nai, nao lau fuaku. ");
INSERT INTO bvd_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Si kada nai naa si kada fua God ka falea na kwakwaea fua toae ki lao fera ne 'i saegano nai. Si kada nai naa si kada fua God kai taria naa sa Saetan, na waa gwaungai bae lao fera ne 'i saegano nai. ");
INSERT INTO bvd_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ma ni nau si kada kera da kai tafo nau 'i langi fasi fafo saegano, nau kwai 'idua mai toae ki sui guu siaku.” ");
INSERT INTO bvd_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Sa Disas nia saea si baea nai uri ka faatainia kwai mae laa bae 'ana 'airarafolo bae nia totoo kai mae ai. ");
INSERT INTO bvd_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Na waa lao konia nai ki daka bae 'urii, “Kameli meli rongo na taki 'e saea, na Kraes doo 'afitai lau ka mae ne. Sui 'utaa nai 'oko saea kera da kai tafoa na 'Alakwa nia Wane 'i salafana 'airarafolo 'i langi nai? Ma na 'Alakwa nia Wane nai sa tii gu nai?” ");
INSERT INTO bvd_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Sa Disas ka bae 'urii fuada, “Nau naa ne talafana kwesu ne saru folaa. Si kada kukuru 'asia gu ne kwesu nai kai too siamolu. Molu lea naa suli kwesu nai si kada nia too 'ua, ma si kada na rodo si rodo 'ua faafi kamolu. Sulia waa ne galo lao maerodo, nia 'afitai ka saitomana si kula ne nia lea uria. ");
INSERT INTO bvd_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Molu manata mamana naa 'ana kwesu nee si kada 'e too 'ua fai kamolu, uri molu ka too mala toaa nia kwesu.” Sa Disas 'e saea doo nai ki lelea sui, nia ka lea na faasi kera ka lea ka too agwa na 'ana. ");
INSERT INTO bvd_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Sui boroi 'ana sa Disas ka ilia doo kwaibalatana 'oro ki ma toaa Diu ki daka suai, kera nao dasi manata mamana guu 'ani nia. ");
INSERT INTO bvd_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Si doo nai ka tio na 'uri nai, uri ka faamamanea si baea sa 'Aesaea na brofet nia kedaa sui na mai 'i nao, ne bae 'urii, “Aofia 'ae, kera nao dasi faamamanea guu si baea ne meli faarongo mai ai siada, ma ka nao dasi lio saitomana guu tetedea 'oe ne 'o faatainia mai fuada.” ");
INSERT INTO bvd_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Sa 'Aesaea na brofet 'e bae mai sulia si doo ne adea kera daka nao dasi faamamanea doo neki nee. ");
INSERT INTO bvd_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Laona kekeda laa Abu God 'e 'urii, “Nau ku koko fone maada ka nao dasi suana si doo ne ku ilia fuada ki, ma ku faasadia lioda ka nao dasi saitomana. Ku ili 'uri nai 'ada uri kera daka nao dasi bulasi manataa lau mai tale nau uri ku faamauri kera.” ");
INSERT INTO bvd_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Sa 'Aesaea 'e bae 'uri nai, suli nia lio mai ka suana sui naa 'initoaa sa Disas, ma ka bae na mai sulia. ");
INSERT INTO bvd_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Sui boroi 'ana toaa Diu ki nao dasi manata mamana, 'oro lana wane 'ana waa gwaungai kera ki da manata mamana 'ani nia. Sui ta nao dasi faarongo gwai fua ta waa na, suli da mau lau gwada 'ana Faarisii ki, ade lea daka alu kera 'i maa fasi lao beu ni ofu laa kera. ");
INSERT INTO bvd_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kera toa gwaungai ki toa da dooria 'asia naa uri toae daka tango kera ma daka saea doo diane ki suli kera. Si tango laa ne lea mai fasi God, kera nao dasi manata fifii gu ai. ");
INSERT INTO bvd_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Sui sa Disas 'e 'ai baita ka bae 'urii, “Lea waa nia manata mamana 'ani nau, nia manata mamana lau guu 'ana God waa ne fale nau mai, nao lau 'ani nau taifili nau gwana. ");
INSERT INTO bvd_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ma lea waa 'e suaku, nia ka suana lau guu waa ne fale nau mai. ");
INSERT INTO bvd_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nau ku lea mai malutana toaa nee laona fera ne 'i saegano mala 'ana kwesu ne tala folaa fuada lao maerodo, uri toaa ne kera manata mamana 'ani nau, kera ka nao dasi too gwada lao rorodoa lae. ");
INSERT INTO bvd_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Na waa ne rongo bae laku ka nao si ade gu sulia, nau nao kwasi kwae nia, suli nau nao kwasi lea mai lao fera ne 'i saegano uri alu lana gwana wane lao kwakwaea. Nau ku lea lau 'aku mai uri faamauri lana. ");
INSERT INTO bvd_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Waa ne nia ote nia 'ani nau, ma ka nao si doori ili suli toolangaidoo laa nau, na doo uri alu lana waa nai lao kwakwaea 'e tio naa. Si baea nai guu nau ku toolangainia nai ne kai alua waa nai lao kwakwaea 'afa dani 'isi. ");
INSERT INTO bvd_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Doo ne adea guu, nau nao kwasi bae gu suli tasi doo suli manata laku tala'aku. Na Maa nau 'ana waa ne fale nau mai ne falea si baea fifii kwai saea, fainia si sae laa kwai saea ai. ");
INSERT INTO bvd_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nau ku saitomana si baea fifii nai kai talaia wane uri ka dao toi mauria firi. Doo ne adea guu, tasi tee ne nau ku saea, nau ku saea gwaku si doo Maa nau 'e saea fuaku uri ku faatalongainia.” ");
INSERT INTO bvd_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Si kada nai guu sui na Fangatasae ka liu naa, sa Disas 'e saitomana si kada nia 'e dao naa uri faasi lana fera ne 'i saegano ma oli lae naa sia Maa nia. Nia 'e liosau mai 'ana toa nia nai lao fera ne 'i saegano ka dao na 'uri nai, ma nia ka liosau 'ana toa nia lelea ka dao 'ana mae lana. ");
INSERT INTO bvd_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","'I seeri, sa Disas fainia toa kwairooi nia ki, daka fanga kwaimani naa 'i saulafi, ma sa Saetan ka alua naa si lio uri fale lana sa Disas 'i 'abana malimae ki lao liona sa Diudas 'alakwa sa Saemon 'Iskariot. ");
INSERT INTO bvd_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Sa Disas nia saitomana ne Maa nia 'e falea sui naa rigitaa ki 'i 'abana uri 'inito lae 'ana si doo ki sui. Ma nia ka saitomana ne God 'e fale nia mai, ma nia kai oli na kau sia God. ");
INSERT INTO bvd_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","'I seeri sa Disas ka tatae 'i langi fasi fanga lae, ka tangasua maku baita nai nia ruufia. Sui nia ka ngalia taolo nai ka karofolo ai 'i salafana. ");
INSERT INTO bvd_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Sui nia ka kistainia kafo lao 'aitao baita nai, nia ka taufia naa 'aena toa kwairooi nia ki, sui ka ngalia taolo nai salafana ka usua lau guu 'ana 'aeda ki. ");
INSERT INTO bvd_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ma si kada nia sa kai taufia guu 'aena sa Saemon Bita, sa Bita ka bae 'urii fuana, “Nee wala Aofia, 'oe tara 'oko taufia lau gu 'aeku nee?” ");
INSERT INTO bvd_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ma sa Disas ka luua ka 'urii, “Si kada nai, 'oe ulafusia 'ua gwamu si doo ne nau ku ilia 'ani 'oe ne. Ma sui boroi 'ana, 'oe totoo kau 'okoi saitomana malutana.” ");
INSERT INTO bvd_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Sa Bita ka bae 'urii, “Nau ku ote nau 'oko taufia 'aeku!” Ma sa Disas 'e luua ka 'urii, “Lea nau nao kwasi taufia 'aemu, ni 'oe nao lau waa kwairooi nau.” ");
INSERT INTO bvd_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Sa Bita 'e luua ka 'urii, “'Ee nao Aofia, 'o taufia lau guu gwauku fai 'abaku.” ");
INSERT INTO bvd_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Sa Disas ka bae 'urii, “Waa ne taunoni sui naa, 'aena gwana ne nia kai taufia, suli nonina 'e falu gwana. Kamolu molu falu gwamolua, ma sui ta nao lau kamolu sui ne molu falu.” ");
INSERT INTO bvd_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Sa Disas 'e saea kera da falu si sui guu, suli nia saitomana sui naa waa ne kai fale nia 'i 'abana malimae ki. ");
INSERT INTO bvd_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Si kada sa Disas nia taufia 'aeda ki lelea ka sui naa, nia ka ruufia lau gwana maku nia. Sui nia oli ka gooru lau gwana fai kera. Nia ka ledi kera ka 'urii, “Nee, kamolu saitomana malutana si doo nai ku ilia fuamolu nai? ");
INSERT INTO bvd_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Si doo nai toolangai lana 'e 'urii: Kamolu ne molu saea nau na waa ni toolangaidoo kamolu ma na Aofia kamolu, nia 'o'olo gwana nai. Nau na waa ni toolangaidoo kamolu ma na Aofia kamolu naa ne. ");
INSERT INTO bvd_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ma sui ta, nau na waa ni toolangaidoo kamolu ma na Aofia kamolu boroi nai ku taufia gwaku 'aemolu ki nai. Doo ne adea guu, 'i matangamolu nee, kamolu molu ka taufia 'aena toolamolu, ma toolamolu ki daka taufia lau gu 'aemolu. ");
INSERT INTO bvd_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nau ku ilia si doo nai uri kamolu suai molu ka ilia lau guu, 'uri nai ku ilia nai. ");
INSERT INTO bvd_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ku faarongo mamana 'ani kamolu, na waa ni rao 'e nao si 'initoa si talua waa baita ne nia rao fuana. Ma na waa ne da odua gwada uri lae kau ka faarongo, 'e nao si 'initoa si talua waa baita ne odu nia kau. ");
INSERT INTO bvd_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kamolu molu saitomana naa doo neki ku toolangainia siamolu nai. Aia, lea kamolu molu lea kau molu ka ilia naa, tara kamolu kai ele tasa. ");
INSERT INTO bvd_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Nau nao kwasi saea lau ni kamolu sui guu. Nau ku saitomana gwaku toa ne ku fili kera sui naa. Aia, ma waa ne kai 'ole nau boroi, nia kai ilia naa uri si baea bae lao kekeda laa abu ka mamana naa, bae nia bae 'urii, ‘Na waa ne miri fanga kwaimani gwaaria, nia naa ne malimae 'ani nau.’ ");
INSERT INTO bvd_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nau ku faarongo kamolu naa 'ana si doo nai 'ana taue 'ua guu, uri lea si doo nai ka dao boroi mai, kamolu ka faamamanea naa ne ‘Nau Naa Ne’. ");
INSERT INTO bvd_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Si doo mamane ku saea fuamolu ne, tii gwana ne nia gwalea waa nau ku falea mai, waa nai nia gwale nau lau guu. Ma tii gwana ne gwale nau, nia gwalea lau guu waa ne nia fale nau mai.” ");
INSERT INTO bvd_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Burina sa Disas nia saea si doo nai, na manata lana ka isifufuli, nia ka bae folaa siada ka 'urii, “Ku faarongo mamana 'ani kamolu. Tii waa 'ani kamolu nia 'olemaelaku naa.” ");
INSERT INTO bvd_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Si kada nai na toa kwairooi ki kera daka bubungi kera kwailiu, suli kera nao dasi saitomana lau gwada sa tii ne sa Disas nia fuutona nai. ");
INSERT INTO bvd_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Si kada nai, ta waa 'ana toa kwairooi nia ki, waa bae nia liosau 'ani nia, 'e gooru karangia kau sa Disas. ");
INSERT INTO bvd_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ma sa Saemon Bita ka kwaikaru kau fua sa wala nai, uri sa wala nai ka ledia kau sa Disas uri tii 'ani kera nai nia fuutoi nai. ");
INSERT INTO bvd_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Na waa kwairooi bae sa Disas liosau 'ani nia bae ka fuuaro kau fua sa Disas ka 'urii, “Nee wala Aofia, ma sa tii gu nai 'oe bae 'oko fuutoi nai?” ");
INSERT INTO bvd_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Sa Disas 'e luu nia ka 'urii, “Na waa nai ne tara nau kwai felengainia si beret nee lao titiu 'ana sulu fuu sui kwai faa fuana ka 'ani. Waa ne 'o suana tara ku ilia si doo nai 'ani nia, nia waa nai naa nai.” 'I seeri guu, sa Disas ka felengainia naa si beret nai laona titiu sulu nai, sui ka faa kau fua sa Diudas 'alakwa nai sa Saemon 'Iskariot. ");
INSERT INTO bvd_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Sa Diudas 'e 'ani si beret nai sui, sa Saetan ka ruufi nia naa. Ma sa Disas ka bae 'urii fuana, “'O ili 'ali'ali naa 'ana si doo bae 'o manata toi 'okoi ilia bae.” ");
INSERT INTO bvd_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Sui ka nao ta waa 'ana toa kwairooi nai ki da fanga kwaimani nai si filoa guu si doo ne adea nia ka bae 'uri nai fua sa Diudas. ");
INSERT INTO bvd_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tai waa 'ani kera daka kwaifii 'ada sae sa Disas 'e saea si doo nai fua sa Diudas uri lea ka foli lau mai tai fanga fuada fua fanga kwaimania nai, suli sa Diudas ne lio suli wai malefo kera. Kera daka manata toi lea nao, alamia sa Disas 'e dooria uri sa Diudas ka faa kau tasi malefo fua 'adomi lana toaa siofaa ki ne ka bae 'uri nai fuana nai. ");
INSERT INTO bvd_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Burina 'ua guu sa Diudas 'e 'ani si beret nai, nia 'ali'ali ka ruu na kau 'i maa. Ma 'i seeri faanoe ka rodo naa. ");
INSERT INTO bvd_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Si kada sa Diudas nia lea naa, sa Disas ka bae 'urii, “Si kada bae uri faa'inito laku nau 'Alakwa nia Wane, nia ne dao naa nee. Ma si doo ne kai fuli 'ani nau nia kai faa'initoaa lau guu God. ");
INSERT INTO bvd_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Lea si doo ne kai fuli 'ani nau 'e faa'initoaa God, 'i seeri God boroi nia kai faa'inito nau lau guu 'ana si doo ne nia kai ilia. Ma God nia kai faa'inito 'ali'ali gwana 'ani nau, nao si tau lau. ");
INSERT INTO bvd_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Wela nau ki 'ae, nau kwai too fai kamolu si tau naa sui molu ka nanisi nau. Nau kwai faarongo kamolu lau guu 'ana si doo bae ku faarongoa mai 'ana toa gwaungai kera toaa Diu ki bae nau ku 'urii, ‘Kamolu 'afitai molu ka lea fai nau kula ne nau ku lea uria’ ");
INSERT INTO bvd_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Si baea fifii falu nau ne ku falea fuamolu nia 'urii: Molu liosau 'ani kamolu kwailiu ka 'uria lau guu ne nau ku liosau 'ani kamolu. ");
INSERT INTO bvd_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Lelea kamolu molu liosau 'uri nai 'ani kamolu kwailiu, toae ki sui guu kera da kai lio saitomana ne kamolu na toa kwairooi nau.” ");
INSERT INTO bvd_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sui sa Saemon Bita 'e ledia sa Disas ka 'urii, “Wala Aofia 'ae, 'i fai ne tara 'oe kai lea uria nai?” Sa Disas 'e luua ka 'urii, “Si kula ne nau kwai lea uria, kamolu 'afitai molu ka lea gu uria fai nau. Sui boroi 'ana tara tafa dani, kamolu kai lea lau gu kau buriku.” ");
INSERT INTO bvd_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Sui sa Bita ka ledi lau 'urii, “Wala Aofia 'ae, tee ne adea ka 'afitai fuameli uri lea kwaimani lae na fai 'oe? Nau ta waa ku maasia gwaku mae lae fuamu ne wala.” ");
INSERT INTO bvd_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Sa Disas 'e luu nia ka bae 'urii, “Nee wala, 'oe bobola boroi fai mae lae fuaku nee? Si doo mamane ku saea mone fuamu 'e 'urii, 'oe tara 'o tofe nau 'ana olu si kada fatai sui karai kafi 'ai 'i 'ofaidani.” ");
INSERT INTO bvd_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Sa Disas ka bae 'urii fua toa kwairooi nia ki, “Kamolu nao molu si manata isifufuli lau. Molu manata mamana 'ana God, ma molu ka manata mamana 'ani nau. ");
INSERT INTO bvd_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Si kadaluma 'oro mamana gu ne nii 'ana luma nia Maa nau. Lea sae si doo nai ka nao si mamana guu, nau 'afitai ku saea fuamolu. Nau kwai lea uri seeri, uri ku ade akau 'ana si kula fuamolu. ");
INSERT INTO bvd_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ma si kada nau kwai lea kwai ade akau 'ana si kula fuamolu lelea ka sui, nau kwai oli lau gu mai uri ku talai kamolu lea molu ka too kwaimani fai nau, uri molu ka too lau gu fai nau 'ana si kula ne ku too ai. ");
INSERT INTO bvd_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kamolu molu saitomana naa tala ne lea uri si kula ne nau ku lea uria nai.” ");
INSERT INTO bvd_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ma sa Toomas ka bae 'urii, “Wala Aofia 'ae, kameli nao meli si saitomana gu kula ne 'oe 'o lea uria. Tara meli ka ili 'utaa uri meli ka saitomana taale?” ");
INSERT INTO bvd_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ma sa Disas 'e luua ka 'urii, “Nau naa ne taale uri saitoma lana doo mamane ki suli God, ma uri dao lae laona maurie. 'Afitai 'asia naa ta waa ka lea 'e'ete lau 'ana faasi nau ma sae nia ka dao tona maa nau God. ");
INSERT INTO bvd_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Lea sae kamolu molu saitomaku 'ua gu mai bae doo molu saitomana lau guu Maa nau bae. Aia, 'ita 'i tari'ina ka oli 'alaa, kamolu molu saitomana na Maa nau nai, ma molu ka suana naa.” ");
INSERT INTO bvd_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ma sa Filib ka bae 'urii, “Wala Aofia 'ae, kameli tii si doo meli dooria naa ne 'oe faatainia fasi Maa 'oe fuameli uri meli ka suana guu.” ");
INSERT INTO bvd_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ma sa Disas 'e luua ka 'urii, “Filib 'ae, nau ku too mai fai kamolu ka tau naa wala, ma sui 'oe nao 'osi saitomaku 'ua gu nee? Ma sa tii gwana ne nia suaku, nia suana naa Maa nau nai. Nia nao si bobola naa uri 'oko saea nau ku faatainia lau na Maa nau fuamolu! ");
INSERT INTO bvd_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","'Oe 'o faamamanea naa ne nau ku nii 'ana Maa nau, ma na Maa nau ka nii na 'ani nau bae, ma nao 'e nao guu? Baea neki nau ku saea fuamolu ki, nao lau na bae laku 'i tala'aku ki ne. Na Maa nau ne nii 'ani nau, nia 'ana ne 'arutoku uri ili lana raoa nia ki. ");
INSERT INTO bvd_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Molu faamamanea 'amolu bae laku ne nau ku saea, nau ku nii 'ana Maa nau, ma na Maa nau ka nii 'ani nau; ma lea nao, molu ka faamamanea mone 'amolua na doo kwaibalatana neki nau ku ilida ki nee. ");
INSERT INTO bvd_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ku faarongo mamana 'ani kamolu, tii gwana ne nia manata mamana 'ani nau, nia kai ilia lau guu na raoa neki nau ku ilida ki nee, ma kai ilia tai doo kwaibalatana ne baita ka talua lau doo neki ku ilida ki nee, suli ne nau kwai lea naa siana Maa nau. ");
INSERT INTO bvd_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nau kwai ilia ta tee gwana ne kamolu gani nau uria suli kamolu toa nau ki naa. Uri 'i seeri nau na 'Alakwa, ku tafoa satana Maa nau 'i langi. ");
INSERT INTO bvd_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kamolu toa nau ki naa ne, ta tee gwana ne kamolu gani nau uria, nau kwai ilia fuamolu.” ");
INSERT INTO bvd_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Sa Disas ka bae lau gu 'urii, “Lea molu liosau 'ani nau, kamolu kai ade gu suli si baea fifii nau 'afitai ka nao. ");
INSERT INTO bvd_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ma nau kwai gania Maa nau, ma nia kai falea mai ta waa mala lau guu ni nau, ne nia Waa Kwai'adomi ne kai too kwaimani fai kamolu ka lelea firi naa. ");
INSERT INTO bvd_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ni nia na Anoedoo Abu ni faatai lana doo mamane ki sulia God. Aia, ma na toaa ne nao kera dasi manata mamana ki, kera nao dasi ala faafi nia, suli kera nao dasi suana ma ka nao dasi filo nia guu. Kamolu lau 'ana ne molu filo nia suli nia 'e nii fai kamolu ma totoo nia kai too laona mauria kamolu ki. ");
INSERT INTO bvd_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nau kwai lea naa, sui boroi 'ana nau 'afitai ku faasi kamolu ma molu ka too ni inomae laa gwamolu. Nau kwai dao lau gwaku siamolu. ");
INSERT INTO bvd_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tara nao si tau guu sui toaa ne kera nao dasi manata mamana ki kera nao dasi suaku naa. Sui boroi 'ana, ni kamolu, molu kai suaku lau gwamolu. Ni kamolu molu kai mauri, suli nau ku mauri. ");
INSERT INTO bvd_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ma si kada nai nau kwai mauri lau gwaku ai, kamolu kai lio saitomana ne nau ku nii na 'ana Maa nau, ma ni kamolu molu ka nii na 'ani nau, ma ni nau ku nii na 'ani kamolu. ");
INSERT INTO bvd_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Tii gwana ne nia too 'ana si baea fifii nau ki ma ka ade sulia, waa nai 'ana ne nia liosau 'ani nau. Ma waa ne liosau 'ani nau, Maa nau kai liosau lau gu 'ani nia, ma nau boroi kwai liosau lau gu 'ana waa nai ma kwai faatai nau 'i tala'aku fua waa nai uri ka saitoma diana 'ani nau.” ");
INSERT INTO bvd_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Sa Diudas (nao lau sa 'Iskariot) ka ledia ka 'urii, “Aofia 'ae, 'utaa ne kameli 'ana 'oe 'oko faatai 'oe 'i tala'amu fuameli, ma toaa abu faamamane neki ka nao?” ");
INSERT INTO bvd_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Sa Disas 'e luua ka 'urii, “Lea waa 'e liosau 'ani nau, nia ka ade lau gu suli doo ku toolangainia ki. Maa nau boroi ka liosau lau gu 'ana waa nai. Nia ka lea na mai siana waa nai, ma kaaria sui guu miri ka too na 'aaria fai waa nai. ");
INSERT INTO bvd_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ma tii ne nia nao si liosau 'ani nau, nia 'afitai ka ade suli doo ku toolangainia ki. Doo neki kamolu rongo nau ku toolangainia siamolu nao lau doo nau ki tala'aku ne, doo nia ki lau 'ana Maa nau waa ne fale nau mai ne. ");
INSERT INTO bvd_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Na doo neki sui guu, nau ku saea na kau fuamolu si kada ku too 'ua gwaku fai kamolu. ");
INSERT INTO bvd_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ma sui, na Waa kwai'adomi naa ne kai dao lau mai. Na waa nai, nia na Anoedoo Abu ne Maa nau kai falea mai fuamolu nunufana gani laa nau, uri nia ka toolangainia doo ki sui guu siamolu, ma ka olitainia mai doo baki sui guu nau ku toolangainia fuamolu uri molu ka manata toi lau. ");
INSERT INTO bvd_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nau ku alua aroaroe ka too na siamolu. Na aroaroa nau nai ku falea fuamolu nai. Nau nao kwasi fale mala 'ana fale laa ne wane 'ana fera ne 'i saegano kai fale. Doo ne adea guu, nao molu si manata isifufuli nai, ma ka nao molu si mau lau. ");
INSERT INTO bvd_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kamolu rongo sui naa bae nau ku saea kwai lea faasi kamolu ma sui kwai oli lau gu mai siamolu. Lea sa molu liosau 'ani nau, kamolu molu ka ele gwamolu suli lea laku nee siana Maa nau, suli nia ne 'inito ka talu nau. ");
INSERT INTO bvd_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nau ku faarongo kamolu naa 'ana doo neki 'ana taue sui fatai dafi fuli, uri si kada doo nai ki da fuli, kamolu molu ka faamamanea. ");
INSERT INTO bvd_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nau tara ku bae fai kamolu ka nao si tau guu, suli sa Saetan waa ne 'inito 'ana toaa 'ana fera ne 'i saegano nia lea na mai. Nia nao si 'inito fuaku. ");
INSERT INTO bvd_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Sui ta, nia diana fua toaa nee lao fera ne 'i saegano kera daka saitomana 'ada ne nau ku liosau 'ana Maa nau ma nau ku ili mamana 'ana si doo ne Maa nau 'e saea fuaku kwai ilia. “Aia, molu lea mai kolu lea na 'akolu.” ");
INSERT INTO bvd_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Sa Disas ka bae lau gu 'urii fua toa kwairooi nia ki, “Nau naa ne talafana na 'inito 'oko mamane. Na Maa nau ka talafana waa ne nia suasuli 'ana ola greib nia. ");
INSERT INTO bvd_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nia ka sikilia saradoo neki 'ani nau ne nao dasi fungu guu. Aia, na saradoo neki da fungu ki, nia 'e tagisida ka folaa uri dafi fungu diana fatai. ");
INSERT INTO bvd_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ma ni kamolu nee, na baea neki nau ku toolangainia siamolu ne da tagisi kamolu molu ka folaa naa. ");
INSERT INTO bvd_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Molu lado 'ani nau, uri nau ku lado 'ani kamolu. Na saradoo ne nao si lado 'ana 'inito 'oko, nia 'afitai ka fungu 'i tala'ana. Nia 'e lado 'ana 'inito 'oko nai taari. Talafana gu ni kamolu nai. Lea kamolu nao molu si lado 'ani nau, kamolu 'i tala'amolu 'afitai molu ka ili tasi doo diana. ");
INSERT INTO bvd_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nau naa ne talafana 'inito 'oko nai 'ana greib, ma kamolu talafana saradoe ki. Lea waa lado 'ani nau ma nau ku lado 'ani nia, waa nai ka fungu 'ana doo diana 'oro. Lea 'oe nao 'osi lado 'ani nau, 'afitai 'oko ilia guu tasi doo diana. ");
INSERT INTO bvd_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Lea ta waa nao si lado 'ani nau, nia mala gwana ta saradoo ne kera sikilia daka 'ui ai tio ka 'ako naa. Na saradoo 'uri nai ki ne kera ngalida lea daka 'ui 'ani kera lao ere ka sarufida naa. ");
INSERT INTO bvd_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Lea kamolu lado 'ani nau ma na bae laku ka tio ngado lao manata lamolu, ta tee gwana ne kamolu dooria ma molu ka gania God uria, nia kai faa fuamolu. ");
INSERT INTO bvd_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Na doo diana neki kamolu ilia ki ne adea toae ki daka faa'initoaa Maa nau, ma ka faatainia fuada ne kamolu toa kwairooi nau ki. ");
INSERT INTO bvd_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nau ku liosau naa 'ani kamolu mala ne Maa nau nia liosau 'ani nau. Molu too ngado lao liosaua nau. ");
INSERT INTO bvd_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Lea kamolu ade suli si baea fifii nau ki, nia faatainia kamolu molu ngado lao liosaua nau, mala lau guu ne nau ku ade suli si baea fifii Maa nau ki suli ku ngado lao liosaua nia. ");
INSERT INTO bvd_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nau ku saea si doo nai siamolu uri molu ka ele lau guu mala 'ani nau, ma uri molu ka too 'ana ele laa ne laulau. ");
INSERT INTO bvd_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Si baea fifii nau fuamolu nia 'urii: Molu liosau 'ani kamolu kwailiu ka mala lau guu ne nau ku liosau 'ani kamolu. ");
INSERT INTO bvd_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Na kwai liosaua ne waa 'e ilia fua ruana nia ma ka mae 'i fulingana, nia ne nao ta liosaua boroi si 'uria. ");
INSERT INTO bvd_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Lea kamolu molu ilia si doo ne ku saea uri molu ka ilia, nia faatainia ni kamolu ruana nau ki naa. ");
INSERT INTO bvd_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nau nao kwasi 'aili kamolu naa 'ana toa ni rao nau ki gwana, suli na waa ni rao gwana 'e nao si saitomana guu doo neki waa baita nia 'e ilia ki. Nau ku 'aili kamolu lau 'aku 'ana ruana nau ki naa ne, suli nau ku faarongo kamolu naa 'ana doo neki sui guu nau ku rongo mai sia Maa nau. ");
INSERT INTO bvd_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Tasi doo lau, nao lau kamolu bae molu fili nau. Nau lau 'ana bae ku fili kamolu, uri molu ka mala 'ua guu ta 'ai ne fungu diana 'ana fuaedoo ne tio ladoa. 'I seeri guu, nunufana kamolu molu gani 'ana sataku, Maa nau nia kai falea guu ta tee gwana ne kamolu gani nia uria. ");
INSERT INTO bvd_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Si baea fifii nau naa ne 'urii: Molu liosau 'ani kamolu kwailiu. ");
INSERT INTO bvd_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Lea toaa nee 'ana fera ne 'i saegano da susubutai kamolu, molu ka manata toi ni nau ne kera susubutai nau fasi mai 'i nao. ");
INSERT INTO bvd_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Lea sa kamolu toaa 'ana fera ne 'i saegano mone, ni kera toaa 'ana fera ne 'i saegano da kai liosau lau gu 'ani kamolu suli kamolu na doo kera ki 'ua guu. Ma sui nau ku fili kamolu sui naa, uri molu ka 'e'ete naa fasi toaa 'ana fera ne 'i saegano. Doo ne adea guu kera daka susubutai kamolu nai. ");
INSERT INTO bvd_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Molu manata toi fasi si baea baki nau ku saea mai fuamolu. Nau ku 'urii bae, ‘Na waa ni rao lae ki, kera nao dasi 'initoa talua waa baita ne kera da rao fuana.’ Ma lea toaa 'ana fera ne 'i saegano da susubutai nau naa waa ne ku baita fuamolu, tara kamolu toaa ni rao nau ki boroi kera da kai susubutai kamolu lau guu. Lea kera da ade mone mai suli bae laku, tara kamolu boroi kera da kai ade lau gu suli bae lamolu. ");
INSERT INTO bvd_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Toaa nee 'ana fera ne 'i saegano kera da kai susubutai kamolu, suli kamolu toaa nau ma suli kera nao dasi saitomana God waa ne fale nau mai. ");
INSERT INTO bvd_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Lea sa nau nao kwasi dao mai lao fera ne 'i saegano ma ka nao kwasi faarongo kera 'ua gu mone, kera ka nao dasi lio filoa guu abulo ta'aa laa kera ki. Ma sui tari'ina, kera 'afitai daka fofo naa 'ana tasi doo lau suusi kera, suli nau ku dao naa ma ku faarongo kera ka sui naa. ");
INSERT INTO bvd_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tii gwana ne susubutai nau, nia susubutainia lau gu Maa nau. ");
INSERT INTO bvd_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nau ku ilia mai doo ki matangada. Doo nai ki 'afitai ta waa lau ka bobola fai ili lana ki. Lea sa nau ka nao kwasi ilia 'ua gu mai doo nai ki mone, kera ka nao dasi lio filoa guu abulo ta'aa laa kera ki. Ma sui tari'ina, kera da suai gwada doo kwaibalatana nai ki nau ku ilida ki mai. Ma sui boroi 'ana kera daka susubutainia gwada Maa nau fai nau. ");
INSERT INTO bvd_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Sui ta si ade laa ne kera ilia nee, kera da ilia naa uri si baea bae mai laona Taki ka mamana ne, bae 'e 'urii, ‘Kera da susubutai nau gwada fua mange.’ ");
INSERT INTO bvd_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nau kwai odua mai Waa Ni Kwai'adomi siamolu. Nia na Anoedoo Abu ni faatai lana doo mamane ki suli God. Nau kwai odua mai siamolu faasia maa nau. Si kada nia 'e dao naa, nia kai saea doo mamane ki suli nau fuamolu. ");
INSERT INTO bvd_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kamolu lau gu ne molu kai saea doo mamane ki suli nau, suli kamolu molu too kwaimani mai fai nau 'ita mai 'ana safali lana raoa nau nee.” ");
INSERT INTO bvd_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Sa Disas nia bae lau ka 'urii, “Nau ku faarongo kamolu 'ana doo neki uri ka nao molu si lea 'e'ete lau. ");
INSERT INTO bvd_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Totoo kera da kai alu kamolu 'i sara fasi lao beu ni ofu lae. Mamana nai, si kada ne lea mai, lea ta waa 'e saungi kamolu molu mae boroi, nia ka saea gwana nia ilia si raoa nai fua God. ");
INSERT INTO bvd_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Kera da kai ilia doo nai ki 'ani kamolu, suli kera nao dasi saitomana Maa nau, ma nao ni nau boroi. ");
INSERT INTO bvd_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ka 'uri nai boroi 'ana, nau ku faarongo kamolu na kau 'ana si doo nai, uri si kada nia ka dao boroi mai, kamolu molu ka manata toi naa ne nau ku saea sui na kau fuamolu.” Sa Disas ka bae lau 'urii, “Nau nao kwasi saea mai doo neki fuamolu 'i nao, suli nau ku too 'ua gwaku fai kamolu. ");
INSERT INTO bvd_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Sui tari'ina, nau kwai oli naa sia waa bae fale nau ku lea mai. Nau kwai oli naa ne, sui boroi nao ta waa 'amolu si ledi gu 'urii 'ani nau, ‘Nee wala, 'oe lea na fai nee?’ ");
INSERT INTO bvd_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Tari'ina, kamolu molu rongo doo nai ki nau ku faarongo kamolu ai na liomolu ka dila naa. ");
INSERT INTO bvd_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Sui boroi 'ana, nau ku faarongo mamana 'ani kamolu, didiana lana si doe fuamolu ne nau kwai lea nee. Suli lea nau nao kwasi lea, na Waa Kwai'adomi nia 'afitai ka lea mai siamolu. Lea nau ku lea taari nau ku odu nia ka lea mai siamolu. ");
INSERT INTO bvd_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Si kada nia dao naa, nia kai faatai folaa 'ana garo laa kera toaa 'ana fera ne 'i saegano suli abulo ta'aa lae, ma 'o'oloe, ma suli kwakwaea ne God kai falea mai. ");
INSERT INTO bvd_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","'Ana bali 'ana abulo ta'aa lae, kera da garo suli kera nao dasi manata mamana 'ani nau. ");
INSERT INTO bvd_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","'Ana bali 'ana 'o'oloe, kera da garo suli nau kwai oli sia Maa nau ma tara kamolu molu si suaku naa. ");
INSERT INTO bvd_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","'Ana bali 'ana kwakwaea ne God kai falea mai, kera da garo suli God nia falea sui naa kwakwaea fua sa Saetan waa ne 'inito faafia toaa lao fera ne 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nau ku too 'ana doo 'oro 'asia naa ni sae lana 'ua fuamolu ne nao molu si tala'ana naa ngali lana lau. ");
INSERT INTO bvd_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Sui ta, si kada na Anoedoo Abu waa ne kai toolangaidoo siamolu suli doo mamane ki nia dao naa, nia kai talai kamolu suli doo mamane ki sui guu. Nia kai bae gwana suli si doo nia rongoa God saea ki fuana, nao lau si doo nia ki tala'ana. Ma nia kai bae suli si doo neki nao dasi fuli ki 'ua. ");
INSERT INTO bvd_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ma nia kai ilia toae ki da kai faa'inito nau, suli nia kai ngalia bae laku kai faarongo kamolu ai. ");
INSERT INTO bvd_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Si doo neki sui guu da naisata 'ana Maa nau, si doo nau ki sui guu. Nia ne adea nau ku saea na Anoedoo Abu kai ngalia bae laku ma kai faarongo kamolu ai.” ");
INSERT INTO bvd_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Sa Disas ka bae lau 'urii, “Si kada kukuru gwana sui ka nao molu si suaku naa, sui burina si kada kukuru gwana, molu ka suaku lau gwamolu.” ");
INSERT INTO bvd_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","'Uri nai tai waa 'ana toa kwairooi nia ki daka ledi kera kwailiu, daka 'urii, “Na tee nai toolangai lana si baea nai nia saea nai, ‘Si kada kukuru gwana sui ka nao molu si suaku naa, sui burina si kada kukuru gwana, molu ka suaku lau gwamolu,’ ma ka saea lau guu, ‘Suli nau kwai lea naa sia Maa nau’?” ");
INSERT INTO bvd_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ma toa kwairooi nia ki kera ledi kera kwailiu lau daka 'urii, “Tee nai nia toolangainia 'ana si baea nai, ‘Si kada kukuru gwana’? Doo nai nia bae sulia kolu ulafusia nai.” ");
INSERT INTO bvd_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Sui sa Disas 'e filoa kera dooria ledi lana nai, nia ka 'urii fuada, “Kamolu manata suli si doo bae nau ku saea 'oto nai, bae nau ku 'urii, ‘Si kada kukuru gwana sui ka nao molu si suaku naa, sui burina si kada kukuru gwana, molu ka suaku lau gwamolu’? ");
INSERT INTO bvd_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nau ku faarongo mamana 'ani kamolu, ni kamolu molu kai angi baita 'asia naa, ma na toaa 'ana fera ne 'i saegano kera da kai ele. Kamolu molu kai liodila, ma sui ta na liodilaa kamolu nai kai rokitai uri ele lae. ");
INSERT INTO bvd_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Na keni saare wela 'e nonifii 'asia naa suli 'e dao naa 'ana si kada ni saare wela. Ma sui ta, si kada wela nia 'e futa sui naa, nia ka manata buro lau gwana 'ana nonifiia bae, suli nia ele 'asia naa ne wele 'e futa ka sui naa lao fera ne 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Talafana lau guu ni kamolu nai. Kamolu molu liodila 'i tari'ina, ma sui ta nau kwai suamolu lau gwaku ma kamolu molu kai ele. Na ele laa kamolu nai 'afitai naa ta waa ka ngalia lau faasi kamolu. ");
INSERT INTO bvd_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Tara dao 'ana si kada nai, kamolu boroi nao molu si gani nau naa uri tasi doo lau. Nau ku faarongo mamana 'ani kamolu, ta tee ne kamolu gania sia Maa nau suli ni kamolu toa kwairooi nau ki, nia kai falea fuamolu. ");
INSERT INTO bvd_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Lelea mai ka dao 'i tari'ina nai, kamolu 'i tala'amolu nao molu si gania 'ua mai tasi doo sia Maa nau 'i nunufana sataku. Molu tala gania 'amolu Maa nau, uri nia ka fale 'amolu ma manata lamolu ka ele mamana 'ana!” ");
INSERT INTO bvd_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Sa Disas ka bae lau 'urii, “Nau ku bae mai 'ana tarifulae ki kada ku saea mai doo neki fuamolu. Aia, ma si kada ne lea mai nau tara nao kwasi bae lau 'ana tarifulae ki 'uri nai, kaa kwai bae naa suli Maa nau fuamolu 'ana baea 'o'olo gwana. ");
INSERT INTO bvd_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Dao 'ana si kada nai, kamolu naa molu kai tala gania 'amolua God suli kamolu toa kwairooi nau ki. Ku saea fuamolu, tara nau nao kwasi gania naa doo ki fuamolu. ");
INSERT INTO bvd_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Nia kai tio na 'uri nai, suli Maa nau 'ana tala'ana ne nia liosau 'ani kamolu suli molu liosau 'ani nau ma molu ka faamamanea ne Maa nau 'e fale nau mai. ");
INSERT INTO bvd_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nau ku too mai sia Maa nau ne ku lea mai lao fera ne 'i saegano. Tari'ina, nau kwai faasia naa fera ne 'i saegano ma kwai oli naa siana Maa nau nai.” ");
INSERT INTO bvd_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","'I seeri na toa kwairooi nia ki daka bae 'urii fuana, “Ma 'oe 'o bae folaa naa wala, ma ka nao 'osi bae naa 'ana tarifulae ki. ");
INSERT INTO bvd_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Tari'ina gu ne kameli meli kafi liotoi ne 'oe 'o saitomana doo ki sui guu, ma ka nao si bobola gu uri ta waa lau ka ledi 'oe, suli 'oe filoa gwamu doo ne nii lao manata lana waa ki. Doo ne adea meli ka faamamanea God nia fale 'oe mai nai.” ");
INSERT INTO bvd_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ma sa Disas ka bae 'urii fuada, “Kamolu molu kafi manata faamamane gu nai! ");
INSERT INTO bvd_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Sui tii si doo ne ku faarongo kamolu lau ai. Si kada ne lea mai, ne safali dao naa nee, kamolu kai tagalo tiifau faasi nau. Tara kamolu kai tafi faasi nau uri fera kamolu ki nunufana si doo ne kera da kai ilia 'ani nau. Sui boroi 'ana, nau nao kwasi too gu taifili nau, suli Maa nau ne nii fai nau. ");
INSERT INTO bvd_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nau ku saea doo neki siamolu, uri molu ka too 'ana aroaroe lao kwaimania kamolu fai nau. Kamolu kai dao tona 'afitaie lao fera ne 'i saegano. Sui boroi 'ana, nao manata lamolu si ta'aa lau. Nau ku siitasa naa faafia fera ne 'i saegano.” ");
INSERT INTO bvd_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Si kada sa Disas nia bae 'uri nai ka sui, nia ka lio 'alaa 'i langi ka 'urii, “Maa 'ae, nia dao naa 'ana si kada bae uri 'oko faa'inito nau 'Alakwa 'oe nai, uri nau ku faa'inito 'oe lau guu. ");
INSERT INTO bvd_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Suli 'oe 'o falea sui naa rigitaa faafia toae ki sui guu fuaku uri nau ku falea mauria firi fua toa nee sui guu 'oe faleda mai fuaku nee. ");
INSERT INTO bvd_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na mauria firi nai naa ne: Kera da filo 'oe ni 'oe tii God mamana nai naa, ma daka filo nau Disas Kraes, waa ne 'oe fale nau mai. ");
INSERT INTO bvd_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nau ku tafoa naa satamu 'i langi lao fera ne 'i saegano ma ku faasuia naa na raoa bae 'oe fale nau mai uri ili lana. ");
INSERT INTO bvd_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Maa 'ae, faa'inito nau naa 'i tari'ina uri ka mala lau guu bae 'oe faa'inito nau kwaimani ai fai 'oe 'i nao sui fatai 'ofi saungainia molaagali. ");
INSERT INTO bvd_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nau ku bae folaa mai suli 'oe fua toa bae 'oe lafuda mai faasia fera ne 'i saegano ma 'oko faleda fuaku. Ni kera na toa 'oe ki naa bae, bae 'oe faleda mai fuaku ma kera daka ade na suli bae lamu. ");
INSERT INTO bvd_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","'I tari'ina kera saitomana naa ne doo neki sui guu nau ku too ai, na doo 'oe ki sui gu 'o faleda fuaku. ");
INSERT INTO bvd_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Doo baki 'oe saea ki fuaku, nau ku saea fuada ka sui ki naa, ma kera daka faamamanea naa. Kera da saitomana ka ngasi naa, ne 'oe fale nau ku lea mai faasi 'oe. Ma kera daka faamamanea naa ni 'oe 'o fale nau mai. ");
INSERT INTO bvd_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nau ku foa fuada. Nao kusi foa lau fua toaa nee 'ana fera ne 'i saegano sui gwana nai. Nau ku foa lau gu 'akua fua toa nee 'oe faleda sui ki naa fuaku nai, suli kera toa 'oe naa. ");
INSERT INTO bvd_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Na toa nau neki sui guu kera toa 'oe ki gwana, ma toa 'oe neki sui guu, kera toa nau ki gwana. Na toae ki da tafoa naa sataku 'i langi nunufana abulo lana toa nau nee. ");
INSERT INTO bvd_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nau tara kwai faasia fera ne 'i saegano, ma sui ta ni kera ne da nii 'ua lao fera ne 'i saegano. 'Oo Maa Abu nau 'ae, 'oko sua diana 'amua suli kera 'ana rigitaa 'oe ne 'o falea fuaku uri kera daka alu tiidooe naa, mala lau guu ne koro alu tiidoe. ");
INSERT INTO bvd_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Si kada nai nau ku too mai fai kera nai, nau ku sua mai suli kera 'ana rigitaa bae 'oe faa fuaku. Nau ku sua mai suli kera lelea tii waa gu ne nia kai funu naa, uri si baea bae na Kekeda laa Abu saea mai 'i nao ka mamana. ");
INSERT INTO bvd_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nau kwai oli na kau siamu nai, ma sui boroi 'ana nau ku bae suli doo nai ki fuada si kada ku nii 'ua kau lao fera ne 'i saegano. Ku faarongo kera 'ana doo nai ki uri manata lada ka ele 'ana ele laa nau ne ali'afu. ");
INSERT INTO bvd_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nau ku toolangainia naa bae lamu siada, sui ma toaa 'ana fera ne 'i saegano ki daka susubutai kera, suli toa nau nee kera nao lau toa 'ana fera ne 'i saegano ki naa. Kera 'uri nau lau guu, ne nau nao lau waa 'ana fera ne 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nau kusi gani 'oe lau uri 'oko ngalida 'amua kau fasi lao fera ne 'i saegano nai. Ku gani 'oe lau 'akua uri 'oko suasuli diana 'ani kera faasia Waa Ta'aa bae. ");
INSERT INTO bvd_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ni kera nao lau toa 'ana fera ne 'i saegano ki naa ne, mala lau guu ni nau ne nao lau waa 'ana fera ne 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Na bae lamu naa ne doo mamane. Alu na baea mamana 'oe nai 'e talai kera uri daka too 'e'ete na fuamu. ");
INSERT INTO bvd_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nau ku fale kera uri lea daka toolangaidoo lau guu siana toae ki mala ne 'oe fale nau mai lao fera ne 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nau ku alu nau 'i tala'aku ku too na uri 'adomi lada, uri kera lau guu daka too nada fuamu. ");
INSERT INTO bvd_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Aia, nau nao kusi foa gwaku fua toa nee taifili kera gwana. Nau ku foa lau guu fua toaa ne totoo da kai manata mamana lau gu 'ani nau, si kada kera rongo faarongo laa nee fasi toa nee. ");
INSERT INTO bvd_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ma nau ku foa lau guu uri kera daka alu tiidoe guu, mala lau guu ne 'oe ma ni nau koro tiidoe naa. 'Oko 'adomi kera uri daka alu tiidoe naa fai koro, uri toaa lao fera ne 'i saegano daka faamamanea ne 'oe fale nau mai. ");
INSERT INTO bvd_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nau ku faa'inito kera 'uri lau guu ne 'oe faa'inito nau, uri kera daka alu tiidoe naa, mala lau guu ne koro alu gu tiidoe naa. ");
INSERT INTO bvd_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Si baea nai 'e toolangainia: Nau ku nii 'ani kera, ma 'oe 'oko nii 'ani nau. 'Oko 'adomi kera uri kera da alu tiidoe ka ali'afu guu, uri toaa 'ana fera ne 'i saegano daka saitomana ne 'oe 'o fale nau mai ma 'oko liosau 'ana toa nee ka mala lau guu ne 'oe 'o liosau 'ani nau. ");
INSERT INTO bvd_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Maa 'ae, nau ku dooria toa ne 'oe faleda fuaku nee, daka too kwaimani lau gu fai nau 'ana kula ne nau ku too ai, uri daka suana 'ada ne 'oe faa'inito nau. 'Oe 'o faa'inito nau suli 'oe liosau 'ani nau sui fatai 'ofi saungainia molaagali. ");
INSERT INTO bvd_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Maa 'ae, 'oe waa ade 'o'olo tiifau. Toaa nee 'ana fera ne 'i saegano ka nao dasi filo 'oe boroi, nau ne ku filo 'oe. Ma na toa nau nee lau gu kera saitomana ne 'oe 'o fale nau mai. ");
INSERT INTO bvd_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nau ku faarongo kera sui naa suli 'oe. Ma tara nau kwai faarongo kera 'ua gwaku kau suli 'oe, uri na liosaua ne 'oe ilia fuaku ka nii 'ani kera ma uri nau ku nii 'ani kera.” ");
INSERT INTO bvd_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Si kada sa Disas nia bae 'uri nai ki lelea ka sui, nia ka lea na kau fai toa kwairooi nia ki. Ma kera daka ulufolo na kau 'ana kasi dede nai satana 'i Kidron. Ma daka lea na kau uri lao ububui 'ai nai 'i bali loko 'ana dede nai. ");
INSERT INTO bvd_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ma sa Diudas, na waa nai 'e 'ole mae lana naa sa Disas nai, nia ka saitomana sui naa si kula nai. Suli si kada 'oro sa Disas fai kera toa kwairooi nia ki da kai lea walude ki gwada 'i seeri. ");
INSERT INTO bvd_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","'Uri nai, sa Diudas 'e talaia waa nai ki 'ana omee fera 'i Rom fai tai waa ni folo lae ki ne waa baita ni foa ki ma Faarisii ki da odu kera mai, nia ka lea na mai fai kera uri lao ububui 'ai nai. Kera toa ne da lea mai nai, kera dau raunga mai ma daka kwesu daka lea na mai. ");
INSERT INTO bvd_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Sa Disas 'e saitomana sui naa si doo nai kera da kai ilia 'ani nia, nia ka fali kau ka ledi 'urii 'ani kera, “Tii ne molu nani uri nia?” ");
INSERT INTO bvd_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Kera da luu nia daka 'urii, “Meli nani mai uri sa Disas waa bae 'i Naasaret ne.” Sa Disas ka bae 'urii, “Tee nau naa nee.” Aia, sa Diudas na waa ne talai kera kau siana sa Disas nai, nia ka uu lau gu 'i seeri fai kera. ");
INSERT INTO bvd_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Si kada nai sa Disas ka bae 'urii, “Tee nau naa nee,” na toa nai tona da dudu faiburi kau daka 'asi kera gu 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Sui sa Disas ruana ka ledi lau gu 'urii, “Tii ne molu nani uri nia nee?” Kera daka bae lau gu 'urii, “Meli nani mai uri sa Disas waa bae 'i Naasaret.” ");
INSERT INTO bvd_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Sa Disas ka bae 'urii fuada, “Tee nau naa nee, bae ku saea sui na fuamolu. Doo ne nau naa ne molu nani mai uri nau, aia, molu saea fua toa nee da lea 'ada fasi see.” ");
INSERT INTO bvd_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Sa Disas nia bae 'uri nai uri si baea nia saea sui na mai suli kera ka mamana, ne nia bae mai 'urii, “Maa 'ae, toa bae 'oe faleda mai fuaku kera lau sui gwada, nao ta waa 'ani kera si funu guu.” ");
INSERT INTO bvd_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ma sa Saemon Bita nia too 'ana tii 'ila nai ni firu. Nia ka aoa 'ila nai ka kwae na kau ai, ma ka kwae muusia naa bali alingana aolo nia waa rao nai na waa foa ni gwau. Na waa rao nai satana sa Malakas. ");
INSERT INTO bvd_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Sa Disas ka bae 'urii fua sa Bita, “Oli fai 'ila na 'oko alu 'amua 'i fulina! Nee wala, ma nonifiia nee Maa nau 'ua guu nia dooria kwailiu 'i laona nee, nau 'afitai ku lea 'e'ete lau faasia!” ");
INSERT INTO bvd_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Na toa ni folo nai ma toa ni omee nai ki, fainia toa gwaungai ki kera daka daua naa sa Disas 'i seeri. Ma kera daka kani faafi roo 'aba nia ki ");
INSERT INTO bvd_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","sui daka talai nia na kau sia arai sa 'Anas, na fungo sa Kaeafas. Sa Kaeafas, nia na waa foa ni gwau 'afa ngali nai. ");
INSERT INTO bvd_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Sa Kaeafas, nia ne saea mai si baea fua toa gwaungai kera Diu ki ma ka 'urii, “Nia diana gwana fua ta tii waa gwana ka mae uri toaa 'oro nee daka mauri.” ");
INSERT INTO bvd_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Sa Saemon Bita fainia ta tii waa kwairooi sa Disas lau guu, daru lea na buri sa Disas ne da talaia daka lea naa. Ma ruana waa kwairooi nai, ka lea kwaimani fai sa Disas fai kera lelea kau ka dao guu lao lalo nai maa beu waa foa ni gwau, suli waa foa ni gwau nai 'e saitoma diana 'ana waa kwairooi nai. ");
INSERT INTO bvd_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Aia, ma sa Bita ka uu gwana kau 'i maa. Na waa kwairooi nai na waa foa ni gwau 'e saitomana nai, nia oli ka ruu mai 'i maa ka bae fai wela keni nai 'e lio suli mae. Sui, nia ka talaia sa Bita daru ruu sui na kau lao lalo nai. ");
INSERT INTO bvd_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Si kada sa Bita 'e ruu kau 'ana mae nai, na wela keni nai ka bae 'urii fuana, “'Oe alamia ta waa lau gu 'ana toa kwairooi nia waa loko da talai mai loko 'oto ne!” Sa Bita 'e luua ka bae 'urii, “Nao, nau nao!” ");
INSERT INTO bvd_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Si kada nai faanoe gwagwari'olaa, ma na waa baita nai ki fainia toa ni rao baki daka 'ukunia era nai ma kera daka uu kalia daka sara 'ada. Sa Bita nia uu kwaimani fai kera ka sara lau gu noni era nai. ");
INSERT INTO bvd_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na waa foa ni gwau nai ka ledifetoa naa sa Disas suli toa kwairooi nia ki ma suli toolangaidoo laa nia. ");
INSERT INTO bvd_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Sa Disas ka luu 'urii 'ani nia, “Si kada ki sui guu, nau ku toolangaidoo gwaku lao beu ni ofu laa kamolu ki, ma lao beukaua loko kula loko toaa Diu ki sui naa da kai koni kwaimani ai. Nau nao kwasi agwatainia gu bae laku suli doo neki. ");
INSERT INTO bvd_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Uri tee ne 'oko ledi 'urii 'ani nau? 'Oe leditona fasi kau toaa naki da rongo mai doo nai ki nau ku bae mai sulia. Kera da saitomana gwada doo nai ki nau ku saea mai fuada na, 'afitai ka nao.” ");
INSERT INTO bvd_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Si kada sa Disas bae gu 'uri nai, ta waa 'ana waa gwaungai nai ki 'i seeri karangi nia ka fidali nia naa, ka bae 'urii, “Nee wala, 'oe olisi lamu gwana 'ana waa foa ni gwau nai?” ");
INSERT INTO bvd_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Sa Disas 'e luu nia ka 'urii, “Lea nau ku saea tasi doo ne garo, 'oko faarongo nau. Ma lea nau ku saea gwaku doo mamane ki, ma 'oe fidali nau uri tee nai?” ");
INSERT INTO bvd_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Sa 'Anas 'e ledi sa Disas 'uri nai sui, nia ka odua sa Disas ka lea naa sia sa Kaeafas, na waa foa ni gwau nai. 'Abana sa Disas ki, kera kani 'ua gwada faafida. ");
INSERT INTO bvd_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Si kada sa Bita nia uu ka sara 'ana, kera daka ledi 'urii 'ani nia, “'Oe ta waa lau gu 'ana waa kwairooi baki sa wala loko nee?” Ma sa Bita ka tofe ka bae 'urii, “Nau nao!” ");
INSERT INTO bvd_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ma tii waa 'ana waa rao nia waa foa ni gwau ka nii lau guu 'i seeri. Sa wala nai, nia wanefuta nia waa ni rao bae sa Bita 'e kwae muusia kau alingana. Sa wala nai ka bae 'urii, “Tee mone! Nau ku suamu na mai fai sa wala loko lao ububui 'olif bae kada bae kera dau nia bae!” ");
INSERT INTO bvd_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Sa Bita ka tofe lau guu. Ma si kada nai 'ua guu na karai ka 'ai naa. ");
INSERT INTO bvd_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Sui kera daka talaia na kau sa Disas fasi beu sa Kaeafas, daka lea na kau fainia uri beu sa Baelat, na waa baita bae gafman Rom 'e alua ka lio suli bali lolofaa nai. Si kada nai, nia dao naa 'i 'uubongi maakafukafua. Na toa gwaungai nai Diu daka uu gwada kau 'i maa, suli da mau ade lea da ruu kau lao beu nia waa baita nai nia nao lau waa Diu nai ma kera daka faasua kera 'i maana God. Kera dooria daka abu ada maasia 'ani lana Fangatasae nai. ");
INSERT INTO bvd_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","'Uri nai, sa Baelat ka ruu kau siada 'i maa, ka ledi 'urii 'ani kera, “Tee ne sa wala nee ilia ka garo ma molu ka dau nia mai faafia?” ");
INSERT INTO bvd_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kera luua daka bae 'urii, “Lea sa wala nee nao si ilia guu tai doo garo, kameli 'afitai meli ka talaia mai siamu 'urii ne.” ");
INSERT INTO bvd_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Sa Baelat ka bae 'urii fuada, “Lea nia 'uri nai tama, molu talaia kau uri molu ka fale na kau kwakwaea fuana fara taki kamolu nai.” Kera daka bae 'urii, “Ma sui kameli ne nao meli si too 'ana rigitaa uri fale lana kwakwaea uri saumaeli lana ta wane nee.” ");
INSERT INTO bvd_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Si doo nai 'e fuli uri si baea sa Disas nia saea sui na mai sulia kwai mae laa nai nia kai mae ai nai ka fuli. ");
INSERT INTO bvd_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","'I seeri sa Baelat ka oli ka ruu lau 'i beu, ma nia ka 'ailia mai sa Disas siana ka ledia naa. Ka 'urii, “Nee wala, ma 'oe naa ne waa 'inito kera toaa Diu?” ");
INSERT INTO bvd_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ma sa Disas ka ledia kau ka 'urii, “Nee? 'Oe gwana tala'amu ne 'o manata toi si doo nai 'oko ledia nai, ma nao tai waa lau gwana ne da faarongo 'oe suli nau ma 'oko saea nai?” ");
INSERT INTO bvd_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ma sa Baelat ka bae lau 'urii, “Nau nao lau ta waa Diu ne uri 'oko ledi 'uri nai 'ani nau! Toaa 'oe fai waa baita ni foa ki 'ua gu ne kera da talai 'oe mai siaku nee. Tee ne 'oe ilia mai ka garo?” ");
INSERT INTO bvd_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ma sa Disas 'e luua ka 'urii, “Na 'initoaa nau nia nao lau 'initoaa 'e lea mai fasi fera ne 'i saegano ne. Lea sae nia lea mai fasi fera ne 'i saegano mone, doo toaa ni rao nau ki kera da firu mai suusi nau ma toaa nee Diu 'afitai daka karo nau gu bae.” ");
INSERT INTO bvd_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ma sa Baelat ka ledia ka 'urii, “'Uri nai tama 'oe na waa 'inito ne! Nee?” Ma sa Disas 'e luua ka 'urii, “Doo mamane ne 'oe sae nau na waa 'inito nai. Nia mamana nai, si doo ne ku lea mai lao fera ne 'i saegano uria ma ku futa mai uria, nia naa ne uri faarongo mamana lae sulia si baea mamana nai. Toae ki sui guu ne kera nii 'ana bali nia doo mamana nai, kera da fafurongoa si doo ku saea daka ade sulia.” ");
INSERT INTO bvd_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Sui sa Baelat ka ledia lau ka 'urii, “Nee wala, tee gu ne mamana lae?” Ma sa Baelat nia ledi 'uri nai sui nia ka oli lau 'i maa siana toaa Diu bae. Nia ka bae 'urii fuada, “Nau nao kusi dao toi guu tasi garo laa 'ana sa wala nee. ");
INSERT INTO bvd_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ma sui boroi 'ana ta, si birangaa kamolu naa ne uri nau ku saea daka lukea kau ta waa fuamolu fasi lao lookafo otofana Fangatasae nee. Nia 'uri nai, waa 'inito nee toaa Diu ne molu dooria daka lukea kau fuamolu?” ");
INSERT INTO bvd_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ma kera daka 'ai baita tasa daka bae 'urii, “Nao! Sa wala nai ka nao! Lukea 'amua mai sa Baarabas fuameli!” Sa Baarabas kera alu nia lao lookafo faafia nia ta waa 'ana toaa da sasi uri taga lae 'ana gafman. ");
INSERT INTO bvd_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","'Uri nai guu sa Baelat ka falea naa sa Disas fua toaa ni omee nai ki ma ka saea kera daka nangasia naa sa Disas. ");
INSERT INTO bvd_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kera daka 'e'erea tii 'eeregwaua 'ana 'oko konala nai sui daka silifainia naa 'i gwauna sa Disas. Sui kera daka faa ruufi nia naa 'ana maku gogosala nai mala 'ana waa 'inito. ");
INSERT INTO bvd_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Sui kera daka fali kau siana daka bae 'urii, “Diana tasa kau fuamu, 'oe waa 'inito kera toaa Diu!” Sui, kera daka fidali nia usi maana. ");
INSERT INTO bvd_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Sa Baelat ka tii fa ruu laa lau kau 'i maa ka bae 'uri fua toaa nai Diu, “Nau ku talaia mai sa wala nee fuamolu nai, uri molu ka saitomana ne nau nao kusi dao toi guu tasi doo ne nia ilia ka garo.” ");
INSERT INTO bvd_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Si kada sa Disas 'e ruu mai 'i maa, nia 'e ruufia na mai maku gogosala bae fua waa 'inito ki ma na doo ni 'eeregwaua konala bae lau gu 'i gwauna. Sa Baelat ka bae 'urii fua konia nai, “Molu suana nai, sa wala bae gu ne!” ");
INSERT INTO bvd_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Aia na waa baita ni foa nai ki, ma na waa ni folo lae nai ki kalia Beukaua bae, si kada kera suana, kera daka 'ai baita daka bae 'urii, “Saungi sa wala na ka mae 'ana! Foto faafi nia 'ana 'airarafolo!” Sa Baelat ka bae 'urii, “Molu talai nia kau molu ka tala foto 'amolua faafi nia 'ana 'airarafolo. Ni nau gu ne nao kusi dao toi guu tasi doo ne nia ilia ka garo.” ");
INSERT INTO bvd_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Na toaa nai Diu kera daka bae 'urii fua sa Baelat, “Sa wala na 'e saea nia 'Alakwa God. Si doo taki kameli 'e luia nao ta waa gwana si saea naa nai. Nia waa uri mae lae naa na, suli nia saea si doo nai.” ");
INSERT INTO bvd_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Si kada sa Baelat nia rongo kera da bae 'uri nai, nia kafi mau kafi 'idu lau. ");
INSERT INTO bvd_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Sui nia oli ka ruu lau 'i beu ka ledia sa Disas ka 'urii, “Nee wala, doo 'oe waa fasi fai nee?” Sa Disas ka nao si saea gu tasi doo. ");
INSERT INTO bvd_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","'Uri nai sa Baelat ka ledi 'urii lau 'ani nia, “Nee, 'oe nao 'osi dooria guu bae lae fa nau? 'Oe nao 'osi saitomana guu, ne nau naa ne ku too 'ana tetedee uri ku saea daka foto faafi 'oe 'ana 'airarafolo, ma nao daka lukasi 'oe 'oko mauri 'amua?” ");
INSERT INTO bvd_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Sa Disas 'e luua ka bae 'urii, “Na tetedea nai, lea God nao si faa fuamu uri sae lana doe suli nau, 'oe 'afitai 'oko too ai. Doo ne adea guu, waa ne fale nau 'i 'abamu, nia fulia si abulo ta'aa laa baita 'asia naa.” ");
INSERT INTO bvd_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Safali 'i seeri, sa Baelat ka sasi lau gwana uri dao lae toi tasi ade laa uri nia ka saea daka lukea lau gwada sa Disas. Sui ma Toaa Diu ki, kera daka 'ai baita kau daka 'urii, “Lea 'o lukea sa wala na ka lea lau gwana, tama 'oe nao lau ruana nia waa 'inito loko 'i Rom nai. Suli lea ta waa 'e saea nia tala'ana 'e 'inito, nia waa 'e nao si kwaimani na fai waa 'inito 'i Rom nai.” ");
INSERT INTO bvd_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Si kada sa Baelat nia rongo si doo nai sui, nia ka talaia na mai sa Disas uri 'i maa. Sui sa Baelat ka gooru naa 'ana si kula nai fua gooru lae ai uri fale lana si baea 'isi suli doo ki. Si kula nai kera da 'ailia 'ana “Fau dedema”, aia 'ana bae laa kera toaa Diu, na “Gabata”. ");
INSERT INTO bvd_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ma fa dani nai, nia fa dani 'ana ade akau lae maasia fa wiiki bae Fangatasae kai liu ai. Nia ka dao karangia naa tofungana sato 'ana si kada nai. Sa Baelat ka bae na 'urii fua toaa Diu nai, “Na waa 'inito kamolu bae ne!” ");
INSERT INTO bvd_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Na toaa Diu nai ki daka kokoo baita 'ada daka bae 'urii, “Ngali kau molu foto faafia ka mae 'ana, 'ana 'airarafolo wala!” Sa Baelat ka ledi kera lau ka 'urii, “Nee, nia mamana kamolu dooria uri nau ku foto na faafia waa 'inito kamolu nee 'ana 'airarafolo nai?” 'I seeri na waa baita ni foa ki da luu nia daka bae 'urii, “Tii waa 'inito ne kameli too na ai ne waa 'inito 'i Rom. Nao lau ta waa 'inito 'e'ete lau!” ");
INSERT INTO bvd_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Lelea mai 'e dao gu 'i seeri, sa Baelat ka fale na kau sa Disas fuana toa ni omee nai ki uri foto lae faafi nia 'ana 'airarafolo. 'I seeri, na toa ni omee nai ki daka talaia na kau sa Disas. ");
INSERT INTO bvd_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Sa Disas ka ngalia 'airarafolo nia ni mae lae 'i fafona ka lea naa uri si kula nai 'i gwai lelete. Ma kera daka 'ailia kula nai “'I Golgota” 'ana baea toaa Diu. ");
INSERT INTO bvd_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ma 'i seeri kera daka foto na faafia sa Disas 'ana 'airarafolo. Ma kera daka foto faafia ta roo waa lau gu fainia, ta waa ka nii bali aolo ma ta waa ka nii bali mauli nia. Sa Disas ka nii 'i lalo 'ana roo waa nai ki. ");
INSERT INTO bvd_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Sa Baelat ka kedaa mai tii si baea nai sui kera daka ngali mai daka alu ngasi ai 'i gwauna 'airarafolo nai sa Disas nii ai. Si baea nai 'e 'urii, “Sa Disas waa 'i Naasaret, na waa 'inito kera toaa Diu.” ");
INSERT INTO bvd_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Waa 'oro ki 'ana toaa Diu kera da idumia si baea nai, suli si kula nai da foto faafia sa Disas 'ana 'airarafolo ai 'e nii karangia gwana fera baita 'i Durusalem. Ma kera daka kedaa lau gu si baea nai 'ana baea kera toaa Diu, baea kera toaa 'i Rom, ma fainia baea kera toaa Grik. ");
INSERT INTO bvd_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Na waa baita ni foa ki kera nao dasi ele suli si bae laa nai, ma kera lea daka saea fua sa Baelat. Kera daka bae 'urii, “'O kekeda nao 'osi saea lau ‘Na waa 'inito kera toaa Diu ki!’ Kaa 'o saea 'amua, ‘Ni nia lau gwana tala'ana bae saea, nia waa 'inito kera toaa Diu ki.’” ");
INSERT INTO bvd_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Sui sa Baelat 'e luu kera ka bae 'urii, “Si baea ne nau ku kedaa sui naa, tama nau ku kedaa sui naa nai, ade ta waa ka talana lau.” ");
INSERT INTO bvd_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Si kada toa ni omee nai ki da foto faafia sa Disas 'ana 'airarafolo, kera da ngalia maku nia ki daka tolingia 'ana fai si doo ki uri ka bobola fai kera fai waa ki. Na maku nia nai 'i fara gwana ne tio. Maku nai, kera saungainia ka tikwa ma ka nao gu ta tailado laa ai 'ita mai gwauna ka dao 'aena. ");
INSERT INTO bvd_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Na waa ni omee nai ki daka bae 'urii matangada kwailiu, “Nao kolu si kari saketoa lau maku nee. Kolu ilia fasi tasi saso laa mala dais uria. Lelea waa siitasa, waa nai ka ngali 'ana.” Si doo nai 'e fuli uri si baea lao kekeda laa abu ka mamana bae nia 'urii, “Kera tolingia naa maku nau ki fuada, ma kera daka saso mala dais uri maku baita nau 'i fafo.” Si doo toa ni omee nai da ilia nai. ");
INSERT INTO bvd_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Gaa nia sa Disas fai toolana gaa sa Disas, ma ni Meri 'afe sa Klopas, fai ni Meri ai bae 'i Magdala, kera da uu gwada 'aena 'airarafolo nai sa Disas mae ai. ");
INSERT INTO bvd_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Sa Disas nia suana kau gaa nia 'i seeri, ma na waa kwairooi bae sa Disas nia liosau 'ani nia boroi ka uu karangi lau gu 'i seeri. Sa Disas ka bae 'urii fua gaa nia, “Gaa 'ae, na 'alakwa 'oe bae ne.” ");
INSERT INTO bvd_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Sui, nia ka bae lau gu 'urii fua waa kwairooi nai, “Na gaa 'oe bae ne.” Safali 'i seeri na waa kwairooi nai 'e talaia gaa sa Disas ka too 'i luma kera ka suasuli nia naa. ");
INSERT INTO bvd_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Burina doo nai ki lau guu, sa Disas 'e saitomana sui naa ne raoa nia ki sui naa, ma uri si doo Kekeda laa Abu saea ka fuli, nia ka bae 'urii, “Nau ku maeli kuu.” ");
INSERT INTO bvd_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na waen lifoo nai, kera da ongia lao kufidoe ka fungu ka uu gwana 'i seeri. Kera daka ngalia si doo nai mala lumulumu daka kurumainia kau lao waen nai sui daka alua gwauna saga 'ai nai da saea 'ana “Iisob,” sui kera daka falea kau uri maa ngiduna sa Disas. ");
INSERT INTO bvd_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Si kada sa Disas nia kuufia ka sui, nia ka bae 'urii, “Nia sui naa nai!” Nia bae 'uri nai sui guu, nia ka gwautoli na mangona ka liu naa. ");
INSERT INTO bvd_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Fa dani nai fa dani ni ade akau lae naa, sui tio dani guu fa dani 'ana sabat naa. Fa sabat nai boroi, nia fa sabat 'initoa kera lau guu. Kera toaa Diu nai lea daka gania naa sa Baelat uri kera lea daka 'oia 'aena sa Disas fai roo waa baki uri daka mae 'ali'ali, ma daka tangasu kera naa fasi 'airarafolo baki, suli kera ote kera 'ana waa mae ki daka tio gwada 'ana 'airarafolo nai ki 'ana sabat. ");
INSERT INTO bvd_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","'Uri nai guu toa ni omee nai ki kera lea daka safali 'oia naa 'aena ta waa 'ana roo waa baki da foto faafi keerua 'ana 'airarafolo ki fai sa Disas bae. ");
INSERT INTO bvd_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ma sui, si kada kera dao naa siana 'airarafolo bae sa Disas nii ai, kera daka suana nia mae naa. 'Uri nai, kera daka nao dasi 'oia guu 'aena sa Disas. ");
INSERT INTO bvd_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Si doo tii waa 'ani kera nia 'e ilia lau 'ana ne nia liu fai sua nai ka labu ai 'i gagarona sa Disas. Ma na 'abu fainia kafo daru igwa mai faasia. ");
INSERT INTO bvd_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nau waa ne ku tala suai na doo nai ki ne ku unu sulia nee. Nau ku unu sulia siamolu uri kamolu sui guu molu ka manata mamana lau guu. Doo nai nau ku saea nai nia mamana, ma nau ku saitomana ne nau ku bae mamana. ");
INSERT INTO bvd_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Doo nai ki da fuli 'uri nai uri si doo na kekeda laa Abu 'e saea mai ka mamana, bae nia bae 'urii, “Ta tii si 'oki boroi 'ani nia nao si moo'oi guu.” ");
INSERT INTO bvd_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ma ta bali kekeda laa Abu lau guu ka 'urii, “Waa ki da kai bubungia waa ne kera labua 'ana sue ka ruu lao nonina.” ");
INSERT INTO bvd_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Burina nia mae naa, sa Diosef waa nai faasia 'i 'Arimatea nia lea mai ka gania sa Baelat uri ka ngali kau nonina sa Disas. Sa Diosef, nia ta waa lau guu 'ana waa kwairooi sa Disas ki, sui ma nia ka agwa gwana mai, suli 'e mau lau gwana 'ana waa gwaungai kera Diu ki. 'Uri nai guu, sa Baelat ka faolomainia naa. Sa Diosef lea ka ngalia naa. ");
INSERT INTO bvd_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Sa Nikodimas waa bae nia lea mai siana sa Disas lao fa rodo bae, nia lau gu ne lea kwaimani kau fai sa Diosef. Ma nia sa Nikodimas, ka ngali mai bobola fainia 30 kilo 'ana doo moko diana ki 'asia naa uri alu lae fai nonina waa mae. Satana doo moko diana nai ki ne “Mira,” fai “'Alos.” ");
INSERT INTO bvd_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Roo waa nai ki, keerua daru ngalia nonina sa Disas ma daru ka 'afua naa 'ana 'aba maku kwakwaoa diana ki fainia doo moko diana baki. Keerua daru ili 'uri nai suli si birangaa Diu ki 'ana ade akau lae 'ana waa mae ki sui fatai dafi saufini kera. ");
INSERT INTO bvd_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Si kula bae kera da foto faafia sa Disas ai bae 'e nii ninimana tii ola 'ai. Ma tii likwafau falu ni alu wane lae ne kera nao dasi alu 'uabaa gu mai ta waa ai ka nii gwana lao ola 'ai nai. ");
INSERT INTO bvd_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Fa dani nai, fa dani Diu ki 'ana ade akau lae maasia Sabat nai. 'Uri nai keerua daru ka saufinia naa sa Disas 'i seeri lao likwafau falu nai, suli 'e nii karangi gwana. ");
INSERT INTO bvd_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","'I 'uubongi maakafufua lao rorodoe 'ua gwana 'afa sato totoonao 'ana wiiki, ni Meri bae faasia 'i Magdala nia ka lea naa uri maana likwafau ni alu wane bae. Nia dao ka suana fau bae da fonokia 'ana maana likwafau bae, nia abuli ka tio 'e'ete na kau. ");
INSERT INTO bvd_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","'I seeri, ni wala nai ka lae 'ali'ali ka oli lau mai fera siana sa Saemon Bita fainia na waa kwairooi bae sa Disas liosau 'ani nia bae. Ni wala nai ka bae 'urii fua roo waa ki, “Wala roo waa 'ae, na wane ki gu ne da ngalia naa nonina Aofia kia bae faasi lao likwafau bae, ma kolu ka ulafusia naa si kula da alu nia ai!” ");
INSERT INTO bvd_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","'Uri nai guu, sa Bita fainia na waa kwairooi bae daru ka tatae daru ka lea naa uri maa likwafau bae. ");
INSERT INTO bvd_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ma keerua sui guu daru ka lae 'ali'ali naa, lelea na waa kwairooi nai ka talua sa Bita lea kau ka dao na 'i nao maana likwafau nai. ");
INSERT INTO bvd_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nia 'agwaoro kau ka bubungia 'abala maku kwakwaoa baki sui guu da tio gwada, sui boroi nia nao si ruu gu kau lao likwafau nai. ");
INSERT INTO bvd_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Sui, sa Saemon Bita bae nia 'isi mai, nia lelea mai ka dao naa. Sa Bita ka tasa kau ka ruu na lao likwafau nai. Nia ka suai naa 'abala maku kwakwaoa baki. ");
INSERT INTO bvd_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Nia ka suai lau guu si 'aba maku bae kera da karoa 'ana gwauna sa Disas. Si 'aba maku nai 'e lukuma ka tio 'e'ete lau gwana taifilia faasia 'abala maku kwakwaoa baki. ");
INSERT INTO bvd_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Dao 'i seeri guu na waa kwairooi bae nia dao maana likwafau 'i nao, nia ka ruu na kau. Nia ka suai doo nai ki ma nia ka faamamanea naa. ");
INSERT INTO bvd_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ka 'uri nai boroi 'ana, keerua nao daru si filoa 'ua gwadaru bae na kekeda laa Abu 'e saea sa Disas totoo kai tatae guu faasia maea. ");
INSERT INTO bvd_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","'Uri nai sui guu, roo waa kwairooi nai ki daru ka oli na mai luma keerua ki. ");
INSERT INTO bvd_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ma ni Meri ka uu 'ua 'i maana likwafau, ma ka angi guu 'ana. Ma 'ana si kada nia angi 'ana, nia 'agwaoro ka lio kau laona likwafau nai. ");
INSERT INTO bvd_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ma nia ka suana roo 'ensel nai ki keerua ruufia maku kwakwaoa ki ma daru ka gooru gwadaru 'ana si kula nai da egwalaa sa Disas ka tio ai 'i nao. Ta 'ensel ka gooru kula bae gwau sa Disas tio ai bae, ta doo 'ana kula bae 'aena ki tio ai. ");
INSERT INTO bvd_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Keerua daru ledia ni Meri daru ka 'urii, “Nee, tee ne 'o angisia?” Ni Meri 'e luu keerua ka 'urii, “Na Aofia nau bae ne kera ngalia kau nonina faasia 'i seki, ma nau ku ulafusia naa kula da alu nia ai.” ");
INSERT INTO bvd_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nia 'e bae 'uri nai sui nia abulo 'e lio kau, ka suana sa Disas 'e uu gwana 'i seeri. Sui boroi 'ana nia ka ulafusi lau gwana ne nia sa Disas. ");
INSERT INTO bvd_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Sa Disas ka ledia ka 'urii, “Wela keni 'ae, 'utaa ne 'oko angi gwamu 'urii? Ma tii ne 'oe nani uri nia?” Ni Meri ka kwaifii 'ana sae sa waa nai gwana ne lio suli ola 'ai nai 'i seeri. Nia ka 'urii fuana, “Waa baita kani 'ae, lea sa 'oe gwana ne 'o ngalia kau nonina Aofia nau, nau ku dooria 'oko faarongo nau 'ana kula ne 'oe alua ai, uri nau lea ku ngali 'akua.” ");
INSERT INTO bvd_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Sui, sa Disas ka bae 'urii fuana, “Meri 'ae!” Ni Meri toriabulo 'e lio kau ka lio saitomana naa. Nia ka bae na 'urii fuana, “'Oi na Raboni bae!” “Raboni” toolangai lana na “Waa ni toolangaidoo” 'ana baea kera toaa Diu. ");
INSERT INTO bvd_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ma sa Disas ka bae 'urii fuana, “Nao 'osi dau fifini faafi nau 'urii, suli nau nao kwasi oli kwasi dao 'ua sia Maa nau ne. 'O oli kau dao siana toolaku ki, 'oko faarongo kera ne nau kwai oli naa siana Maa nau ne nia na Maa kera lau guu. Nia na God nau, ma na God kera lau guu.” ");
INSERT INTO bvd_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Sui guu ni Meri nai faasia 'i Magdala ka oli naa. Nia ka faarongoa naa waa kwairooi ki ne nia suana naa na Aofia. Ma nia ka faarongo kera lau guu 'ana doo nai ki sa Disas nia saea mai fuana nai. ");
INSERT INTO bvd_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","'I saulafi naa 'ana tii fa sato totoonao bae gwana 'ana wiiki, na toa kwairooi baki kera da too kwaimani 'ada laona tii beu nai. Na maa nai ki 'ana beu nai boroi kera da fonokida daka alu loko ki ai, suli kera da mau 'ana toa gwaungai Diu ki. Ma sa Disas nia ka sakatafa faatai gwana 'i matangada. Ma ka bae 'urii, “Na aroaroe ka too na fai kamolu.” ");
INSERT INTO bvd_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nia bae 'uri nai sui, nia ka faatainia naa 'abana ki fai na gagarona fuada. Na toa kwairooi ki kera daka ele 'asia naa 'ana si kada nai kera da suana Aofia. ");
INSERT INTO bvd_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Sa Disas ka bae lau 'urii fuada, “Na aroaroe ka too na fai kamolu. Nau kwai fale kamolu molu kai lea, mala lau guu ne Maa nau nia fale nau mai.” ");
INSERT INTO bvd_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Sa Disas nia ufi mango faafi kera ma ka bae 'urii, “Molu ngalia Anoedoo Abu. ");
INSERT INTO bvd_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Lea kamolu molu manata lukea abulo ta'aa laa ta waa, waa nai God boroi nia manata lukea lau guu abulo ta'aa laa nia ki. Ma waa ne kamolu nao molu si manata lukea abulo ta'aa laa nia ki, God boroi nao si manata luke nia lau guu.” ");
INSERT INTO bvd_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Aia sa Toomas ne kera 'ailia lau guu 'ana “'Iu” ta waa lau guu 'ana toa kwairooi baki sa Disas, nia nao si too 'ana si kada nai sa Disas dao siada nai. ");
INSERT INTO bvd_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ma 'aini toa kwairooi nai ki kera daka faarongo nia daka bae 'urii, “Wala 'ae, kameli meli suana mai na Aofia!” Nia ka bae 'ana 'urii fuada, “Lea nau ku tala suana guu fuli nila baki lao 'abana taari ku faamamanea. Fai, lea nau ku tala alu gu kakauku fuli nila baki ma ku dau toi guu 'i gagarona bae taari ku faamamanea. Lea nao, 'afitai guu nau ku faamamanea si doo nai.” ");
INSERT INTO bvd_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","'Ana fiuna fa dani 'i burina lau guu, na toa kwairooi baki kera da too fiku lau guu laona luma bae. Fua nai, sa Toomas 'e nii lau gu fai kera 'i seeri. Kera daka sabia lau gu mae ki. Sui sa Disas ka sakatafa folaa lau gu mai 'i matangada, ka bae lau gu 'urii, “Aroaroe ka too na fai kamolu.” ");
INSERT INTO bvd_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Sui sa Disas ka bae 'urii fua sa Toomas, “Toomas 'ae, 'oe alua fasi kakaumu 'i seki lao 'abaku. 'O suana fasi 'abaku neki. Faa mai 'abamu 'oko silifainia fasi 'i seki gagaroku fulina mae maala bae. 'O manata mamana naa, nao 'osi manata ruarua lau!” ");
INSERT INTO bvd_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ma sa Toomas 'e luua ka 'urii, “'Oe na Aofia nau, ma God nau!” ");
INSERT INTO bvd_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ma sa Disas ka bae 'urii fuana, “'Oe 'o suaku gwamu nai 'oko manata mamana nai. 'E diana tasa fua toaa ne nao dasi suaku boroi ma kera daka manata mamana 'ani nau.” ");
INSERT INTO bvd_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Sa Disas nia ilia doo kwaibalatana 'oro ki lau ne toa kwairooi nia ki da suai, ne nao kusi kekeda gu sulia lao buka ne. ");
INSERT INTO bvd_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ma sui boroi 'ana, doo neki nau ku kekeda sulida nee, nau ku kekeda sulida uri ka adea molu ka manata mamana 'ana sa Disas na Kraes, na 'Alakwa nia God. Ma si kada kamolu molu manata mamana 'uri nai, kamolu molu ka too 'ana mauria firi nunufana satana. ");
INSERT INTO bvd_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tii si kada lau gu kau 'i buri, sa Disas nia saka faatai lau fua toa kwairooi nia ki 'i ninimana 'osi 'i Galilii. Na fuli lana 'e 'urii: ");
INSERT INTO bvd_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Toa ne kera da fiku kwaimani 'ana si kada nai ne, Sa Saemon Bita, sa Toomas ne kera 'ailia 'ana 'Iu, sa Nataniel nia waa faasia 'i Kena 'ana bali lolofaa 'i Galilii, na roo 'alakwa sa Sebedii ki, ma ta roo waa kwairooi lau. ");
INSERT INTO bvd_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Sa Saemon Bita nia bae 'urii fuana toa nai, “Nau lea ku dee 'akua nai.” Ma kera daka bae 'urii, “Kameli boroi meli doori lea lau guu fai 'oe.” Kera lea daka taelia naa gwa baru nai. Sui boroi 'ana fa rodo nai kera da dee lelea ka nao dasi deea gu ta sakwari. ");
INSERT INTO bvd_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","'I 'uubongi abu naa, sa Disas nia ka uu kau 'i sara ninimana 'osi nai. Ma sui toa kwairooi nia ki daka nao dasi lio saitomana lau gwada. ");
INSERT INTO bvd_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Sui sa Disas ka bae kau fuada ka 'urii, “Nee wala ruana fai kera, kamolu molu deea boroi ta sakwari?” Kera da luu nia daka 'urii, “'E nao gu ne!” ");
INSERT INTO bvd_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ma nia ka bae 'urii, “Molu dangalua furai 'i bali aolo 'ani kamolu. Tara kamolu kai deea sakwari ki na.” Si kada kera da ili gu suli si doo nai, na furai nai ka fungu naa 'ana sakwari 'oro mamana guu lelea kera nao dasi bobola na fai 'aba lana furai nai uri lao baru. ");
INSERT INTO bvd_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Sui na waa kwairooi bae sa Disas liosau 'ani nia, ka bae 'urii fua sa Bita, “Na Aofia kia bae loko wala!” Si kada sa Saemon Bita nia rongo gu nai nia saea, “Na Aofia kia bae loko,” nia lae ka ruufia na maku baita nia (suli nia lukea ka alu gwana kada nia rao 'ana) ka lofo na lao matakwe ka 'arango naa uri 'i sara. ");
INSERT INTO bvd_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Na toa kwairooi ki kera daka lea na kau 'i burina uri 'i sara 'ana baru nai. Ma kera daka taraa na mai furai nai fai sakwari 'oro ne lelea ka fungu gu ai uri sara, suli kera da nii karangia naa 'i sara nai, bobola gwana fainia ta tii talanga fa fale'ae laa kau. ");
INSERT INTO bvd_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Si kada kera koso na 'i sara, kera daka suana era nai 'e saru ka neneola naa fainia sakwari ki ma tai beret ki lau guu. ");
INSERT INTO bvd_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Sa Disas ka bae 'urii fuada, “Molu ngali mai tai sakwari 'ana doo na molu deea ki nai.” ");
INSERT INTO bvd_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Sa Saemon Bita 'e lea kau lao baru nai ka taraa na mai furai nai uri 'i sara. Na furai nai 'e fungu 'ana sakwari baita 'oro, 153 'ana sakwari, sui boroi na furai nai ka nao si muu guu. ");
INSERT INTO bvd_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Sa Disas ka bae 'urii fuada, “Lea mai, molu fanga 'amolua.” Tii ledi lae 'urii 'ani nia, “'Oe sa tii ne wala?” Gu ne nao ta waa 'ani kera si ilia guu, suli da saitomana gwada ne nia Waa Baita kera sa Disas gwana nai. ");
INSERT INTO bvd_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Sa Disas lea mai ka ngali kau beret ka faa fua toa kwairooi nia ki. Sui ka ili lau gu 'uri nai 'ana sakwari ki. ");
INSERT INTO bvd_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Oluna si kada sa Disas nia saka faatai naa fua toa kwairooi nia ki naa nai, burina bae nia tatae faasia maea. ");
INSERT INTO bvd_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Si kada kera fanga ka sui naa, sa Disas ka bae 'urii fua sa Saemon Bita, “'Oe sa Saemon 'alakwa nee sa Dion, 'oe 'o liosau mamana 'ani nau ka talua liosaua kera toa nee fuaku?” Sa Bita ka bae 'urii, “Tee mone Aofia. 'Oe 'o saitomana gwamu ne nau ku liosau 'ani 'oe.” Sa Disas ka bae 'urii fuana, “'O suasulia kale sifsif nau ki.” ");
INSERT INTO bvd_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Sa Disas ruana ka bae lau gu 'urii, “'Oe sa Saemon 'alakwa nee sa Dion, 'oe 'o liosau mamana 'ani nau?” Sa Bita 'e luua ka 'urii, “Tee mone Aofia. 'Oe 'o saitomana gwamu ne nau ku liosau 'ani 'oe.” Sa Disas ka bae 'urii fuana, “'O lio sulia na sifsif nau ki.” ");
INSERT INTO bvd_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Sa Disas oluna ka bae lau gu 'urii, “'Oe sa Saemon 'alakwa nee sa Dion, 'oe 'o liosau mamana 'ani nau?” Sa Bita manata lana ka 'asia naa, suli sa Disas oluna 'e ledi nia naa ka 'urii, “'Oe 'o liosau mamana 'ani nau?” Ma sa Bita ka bae 'urii fuana, “Wala Aofia, 'oe naa ne 'o saitomana doo ki sui guu, ma 'oko saitomana ne nau ku liosau 'ani 'oe.” Sa Disas ka bae 'urii fuana, “'O lio sulia sifsif nau ki. ");
INSERT INTO bvd_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Doo mamane nau ku saea fuamu 'e 'urii, kada ne 'oe 'ofi baita mai 'oe 'o tala ofi 'amua tala 'amu, ma 'oko tala lea 'amua tala 'amu 'ana kula ne 'o doori lea uria. Ma sui, lelea 'oe 'o waro naa, 'oe 'oko fale 'aba na kau uri daka dau 'abamu. Ma ta waa 'e'ete naa ne kai kania maku 'oe salafamu, ma ka talai 'oe kau uri kula ne nao 'osi doori lea gu uria.” ");
INSERT INTO bvd_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Sa Disas 'e saea si doo nai uri ka faatainia kwai maea ne sa Bita totoo kai mae ai. Ma nia kai tafoa satana God. Sui sa Disas ka bae 'urii fua sa Bita, “'O lea mai buriku.” ");
INSERT INTO bvd_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Sa Bita toriabulo 'e lio kau, nia ka suana waa kwairooi bae sa Disas liosau 'ani nia 'e lea na kau buri daru. Sa wala nai bae gooru karangia sa Disas 'ana kada bae kera fanga 'isi bae ma ka ledi 'urii 'ana sa Disas bae, “Wala Aofia 'ae, sa tii ne kai 'ole 'oe ma kai fale 'oe fuana malimae ki nai?” ");
INSERT INTO bvd_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Doo nai ne adea sa Bita 'e suana guu waa kwairooi nai ma ka ledi 'urii 'ana sa Disas, “Wala Aofia 'ae, ma sa wala nee mone 'utaa?” ");
INSERT INTO bvd_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Sa Disas 'e luua ka 'urii, “Lea sa nau ku dooria boroi sa wala nee ka mauri gwana lelea nau oli mai ku dao, nia nao lau doo 'oe uri 'oko bae 'amua sulia.” 'O lea 'amua mai buriku. ");
INSERT INTO bvd_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Fafona si baea nai guu, kera daka unutainia naa saea na waa kwairooi nai nao nia si mae guu. Ma sui, sa Disas nao si saea lau sae sa wala nai nia tara nao si mae lau bae. Nia bae lau 'ana 'urii bae, “Lea sa nau ku dooria boroi sa wala ne ka mauri gwana lelea nau oli mai ku dao, nia nao lau doo 'oe uri 'oko bae 'amua sulia.” ");
INSERT INTO bvd_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Na waa kwairooi bae ne kekeda nee, nia waa bae nia suai mai doo nai ki ma ka kekeda sulia nee. Kolu kolu saitomana nia bae mamana 'ana doo neki nia saea sulia sa Disas. ");
INSERT INTO bvd_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Tai doo 'oro ne sa Disas nia ilia ki lau guu, lea sa nau ku kekeda sulida ka sui guu, nau ku manata toi na molaagali nee tiifau boroi ka tu'uu nao si bobola fainia buka nai ki sui guu daka tio ai. ");
INSERT INTO bvd_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","'O, Tiofilas 'ae! Lao buka totoonao nau bae, nau ku kekeda sulia doo baki sui guu sa Disas nia ilida ki ma ka toolangainida ki. ");
INSERT INTO bvd_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Lelea mai ka dao guu 'afa sato bae God ngalia sa Disas uri salo. Sa Disas 'e oli uri salo burina bae nia falea si baea fifii ki 'ana rigitaa Anoedoo Abu fua 'aboosol nia baki bae nia fili kera. ");
INSERT INTO bvd_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Sa Disas nia 'e faatainia lau 'i tala'ana fua 'aboosol nai ki. Ma nia ka ilia si doo 'oro ki lau ne faatainia ne nia mauri lau gwana. Nia ka dao faatai ki lau gu siada 'ana si kada 'oro ki laona faitaafuli fa dani ki, ma nia ka bae sulia 'initoaa God fuada. ");
INSERT INTO bvd_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nia falea tii si baea fifii fua 'aboosol ki 'ana tii si kada nia fanga kwaimani fai kera. Nia ka bae 'urii, “Nao molu si faasia ua 'i Durusalem. Molu too fasi 'amolua maasia na fale laa bae Maa nau alangainia mai bae. Alangaia nai bae molu rongo nau ku bae mai sulia ki bae. Nia 'urii bae, ");
INSERT INTO bvd_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","‘Sa Dion nia faasiuabua mai toae ki 'ana kafo. Ma sui tara nao si tau guu 'i burina, God kai faasiuabu kamolu 'ana Anoedoo Abu.’” ");
INSERT INTO bvd_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Si kada nai na 'aboosol ki da koni kwaimani lau fainia sa Disas, kera da ledi nia. Ma daka bae 'urii, “Nee wala Aofia, tara 'oe taga naa 'ana 'initoaa nee 'i Rom uri 'oko falea naa 'initoaa nee fuameli toaa 'Israel 'oto nai?” ");
INSERT INTO bvd_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ma sa Disas ka luuda ka 'urii, “Nao lau doo kamolu uri molu ka saitomana 'amolu ne fa dani nai ma si kada nai fua doo nai ki dai fuli ai. Maa nau taifilia 'ana ne 'inito uri sae lana si kada fua doo nai ki dai fuli ai. ");
INSERT INTO bvd_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Aia ma ni kamolu molu kai too 'ana rigitaa 'i burina ne Anoedoo Abu kai sifoli kamolu. Ma kamolu molu kai bae suli nau fua toae ki sui guu 'i seki Durusalem, fainia 'i Diudia fai Samaria, ma ka lea na uri nai lelea ka faasuia kula ki sui guu laona molaagali.” ");
INSERT INTO bvd_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nia 'e bae 'uri nai fuada sui guu, God ka ngali nia naa 'i langi. Ma si kada kera bubu gwada kau suli nia, nia ka liu na laona dasa nai ka saufini nia ka nao dasi suana naa. ");
INSERT INTO bvd_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kera da sasi ngangata daka bubu 'alaa gwada 'uri nai uri sua lana tona boroi, tii roo waa nai ki daru ofi mai 'ana maku kwakwaosarea nai ki dao daru ka uu na siada. ");
INSERT INTO bvd_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Keerua ledi kera daru ka 'urii, “Kamolu toaa nee 'i Galilii, tee ne molu uu 'i seki ma molu ka bubungia na 'amolua lofona salo loo uria? Sa Disas waa nai molu suana God ngali nia ka lea naa faasi kamolu uri salo nai, nia kai oli lau gu mai. Kada nia oli mai, tara kamolu kai suana lau guu dao lana mai mala nai molu suana lea lana kau nai uri salo.” ");
INSERT INTO bvd_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","'Uri nai sui, na 'aboosol ki daka oli na mai faasia gwauna uo nai 'i 'Olif uri 'i Durusalem. Too lao fera 'i Durusalem ka lea uri gwauna fa uo nai, na kada taala nia bobola fainia tii kilomita. ");
INSERT INTO bvd_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Si kada kera dao naa 'i Durusalem, kera daka raa kau lao kadaluma nai kera too ai 'i langi. Na satana toaa nai ki ne: sa Bita, sa Dion, sa Demes, sa 'Andru, sa Filib, sa Toomas, sa Baatolomiu, sa Matiu, sa Demes 'alakwa sa 'Alfias, sa Saemon waa 'ana toa bae kera dooria taga lae 'ana 'initoaa 'i Rom faasi kera 'i 'Israel, ma sa Diudas 'alakwa sa Demes. ");
INSERT INTO bvd_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kera da koni kwaimani daka too 'ana tii si manata lae wane 'i seeri ma daka too 'ana foa lae. Kera fai ai ki lau guu. Ni Meri gaa nia sa Disas fai waa buri sa Disas ki. ");
INSERT INTO bvd_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nao si tau guu 'i burina si kada nai, toaa manata mamana ki da 'oro ka dao naa bobola fainia talangee wane ma roo akwala sarenga ki. 'I seeri sa Bita 'e uu ka bae fuada sui guu. ");
INSERT INTO bvd_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Nia ka bae 'urii “Toafuta kera 'ae, si baea bae lao Kekeda laa Abu bae na Anoedoo Abu 'e faabaea sa Defet ka saea 'ua naa sulia sa Diudas nia mamana naa nai. Sa Diudas naa bae talaia toa bae lea mai daka daua sa Disas. ");
INSERT INTO bvd_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Sa Diudas nia ta waa naa 'ani kolu bae 'ana faatalongai lana faarongoa diana nee.” ");
INSERT INTO bvd_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Sa Diudas bae nia ngalia si malefo uri maana si garoa bae nia ilia fua sa Disas. Nia ka ngalia si malefo bae ka usia naa 'ana tii si gano. Ma si gano nai gu bae nia mae ka tio tikwa rakena ka lua naa 'i laona bae. ");
INSERT INTO bvd_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Si doo nai, si doo toaa nee 'i Durusalem sui naa da rongo naa nai. Nia ne adea daka 'ailia si gano nai 'ana bae laa kera 'ana “'Akeldama.” Toolangai lana “Gano 'ana si 'Abu.”) ");
INSERT INTO bvd_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Sa Bita ka bae lau gu 'urii, “Si baea bae lao kekeda laa Abu 'ana buka Sam lau guu nia mamana naa 'i tari'ina. Nia bae 'urii bae, ‘Alu luma nia sa wala nai gwau 'ana, ka nao ta waa si too lau ai.’ Ma ta kekeda laa lau guu ka bae 'urii, ‘Alu ta waa talana lau 'ana kwaitalai lae.’ ");
INSERT INTO bvd_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Nia diana uri ta waa ka rao kwaimani lau fai kolu 'ana faatalongai lana tatae lana sa Disas faasia maea. Nia 'uri nai, nia diana uri kolu ka filia 'ua gu ta waa 'ana toa baki da too kwaimani mai fai kolu si kada bae Aofia kolu sa Disas nia too 'ua fai kolu 'ita mai 'ana si kada sa Dion nia faasiuabua toae ki lelea mai ka dao gu 'afa sato bae God ngali nia naa faasi kolu uri salo.” ");
INSERT INTO bvd_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","'I seeri kera daka filia naa ta roo waa, sa Diosef waa nai da 'ailia lau guu 'ana sa Baasabas ma tai kada daka 'ailia lau guu 'ana sa Diastas. Fai ta ruana waa sa Mataeas. ");
INSERT INTO bvd_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","'Uri nai guu kera daka foa na 'urii, “Aofia 'ae, 'oe naa ne 'o saitomana manata lana wane ki sui guu. Aia, 'o faatainia mai fua meli 'i tari'ina sa tii 'ana roo waa neki ne 'oe filia ");
INSERT INTO bvd_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","uri ka rao kwaimani fai 'aboosol ki 'ana raoa nee talana sa Diudas bae nia mae ka lea naa uri fulina 'ua guu.” ");
INSERT INTO bvd_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kera da foa 'uri nai sui daka ilia doo mala 'ini dais lae uri ka faatainia tii 'ana roo waa nai ki na dais nai kai 'asia bali nia. Ma si ade laa nai ka faatainia naa sa Mataeas nia kai rao fai akwala 'aboosol ma tii 'aboosol sarenga baki. ");
INSERT INTO bvd_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","'E dao guu 'afa dani Bentikos, na toaa manata mamana bae daka koni kwaimani naa 'ana tii si kula nai lao fera 'i Durusalem. ");
INSERT INTO bvd_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tona boroi, kera daka rongo naa kuruu lana doo nai 'e mala ta mae koburu talingai ne ufiufi ka koso na mai fasi lao salo loo ka sifolia naa luma nai kera nii laona ka 'etengaa naa. ");
INSERT INTO bvd_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ma kera daka suana doo nai ki mala meakwesu ki da tagala daka sifo daka dau naa lao gwauda ki sui guu lao luma nai ta waa si ore. ");
INSERT INTO bvd_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ma na Anoedoo Abu ka olofi kera tiifau naa, ma kera daka safali bae naa 'ana baea lana toaa 'e'ete ki naa fasi bae lada ki 'ua guu, suli na Anoedoo Abu 'e faabae kera. ");
INSERT INTO bvd_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","'Afa dani nai, na toaa Diu ni faabaita lana God da lea mai daka nii sui naa 'i seeri Durusalem. Kera da lea ki mai fasi bali molaagali 'e'ete ki sui naa. ");
INSERT INTO bvd_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Si kada konia nai da rongo kuruu lana doo nai, kera daka koni tiifau mai daka kwele 'asia naa, suli da rongo toa manata mamana nai ki da bae naa 'ana bae lada ki sui gwana. ");
INSERT INTO bvd_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ma toaa nai ki daka bae na 'urii fuada kwailiu, “Na toa nee da bae naa 'ana bae lakolu baki ne! Ma sui kera toa bae fasi Galilii sui gwana ne! ");
INSERT INTO bvd_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ma kera da ade 'utaa ne kolu ka rongo kera daka bae lau nada 'ana bae laa kolu baki nee? ");
INSERT INTO bvd_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nee rowaa, kamolu toaa nee; 'i Baatia, ma Midia, ma 'Elam, ma Mesobotemia, ma Diudia, ma Kabadosia, ma Bontas, ma 'Eisia, ");
INSERT INTO bvd_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ma Frigia, ma Bamfilia, ma 'Isib, ma Libia karangia fera 'i Saerin, ma ta bali 'akolu ne kamolu lea mai fasi 'i Rom. (Kamolu toaa Diu ki 'ua guu fai toaa ne lea mai molu ka too naa suli birangaa toaa Diu ki.) ");
INSERT INTO bvd_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ma kolu toaa ne kolu lea mai fasi auaua 'i Krit, ma fasi fera 'i 'Arabia. Na toa nee da bae 'ana bae lakolu ki 'ua guu daka faatalongainia doo ni kwele lae ki ai ne God nia ilida ki mai, kolu ka tala rongo filoa gu ne!” ");
INSERT INTO bvd_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ma kera daka kwele 'asia naa daka ulafusia doo dai saea. Kera daka ledi kera kwailiu daka 'urii, “Rowane 'ae, ma tee naa ne 'urii?” ");
INSERT INTO bvd_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Tai waa kera daka 'onionga ai daka bae 'ada 'urii, “Kera da kuu baita 'asia naa 'ana waen ma gwauda ka rorodoa ne!” ");
INSERT INTO bvd_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Sui sa Bita 'e uu kwaimani fai akwala ma tii 'aboosol sarenga baki ka bae baita fua konia nai ka 'urii, “Kamolu toaa nau Diu ma toaa nee lao fera 'i Durusalem tiifau, molu fafurongo fasi. Nau ku faarongo kamolu uri nao molu si kwaikolai lau 'ana doo ne fuli nee. ");
INSERT INTO bvd_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Toa nee nao kera dasi kuu guu ma ka nao dasi oewanea guu mala doo ne kamolu manata toi. Si kada nai 'i 'uubongi 'ana sikwana kada sato 'ua gwana ne. ");
INSERT INTO bvd_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Na doo bae brofet Dioel 'e bae mai sulia 'ana kada 'i nao, nia ne fuli naa nee. Nia bae 'urii bae, ");
INSERT INTO bvd_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘God 'e bae 'urii, 'Afa dani 'isi ki, nau kwai fale dangatai 'ana Anoedoo Abu nau fua toae ki sui gwana. Na 'alakwa kamolu ki, fai saari kamolu ki, kera dai faatalongainia bae laku. Ma na toa dafi baita kamolu ki kera dai suana fafaataia ki, ma na toa waro kamolu ki kera dai maleubolea na maleubolee ki. ");
INSERT INTO bvd_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","'Ana si kada nai, nau kwai falea lau guu na Anoedoo Abu nau fua toaa ni rao nau ki, wane ki fai keni ki sui guu, uri kera lau guu daka faatalongainia bae laku. ");
INSERT INTO bvd_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ma ni nau kwai ilia doo ni kwele lae ki ai laona kwalimangaa loo, ma nau kwai faatainia faataia ki lao fera ne 'i saegano. Ma nau kwai faatainia si 'abu ma na ere ma na gwelasasu baita lao fera ne 'i saegano. ");
INSERT INTO bvd_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Na sato loo nia kai rorodoa, ma na madame nia kai 'a'abua, lelea sui fatai fa dani nia Aofia 'ana unidianaa nia kafi dao mai. ");
INSERT INTO bvd_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ma na waa ne nia 'ai fuana Aofia uri ka suufi nia, Aofia kai faamauri nia.’” ");
INSERT INTO bvd_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Sa Bita nia ka bae lau 'urii, “Kamolu toaa nee 'Israel, molu fafurongo fasi ku faarongo kamolu! Sa Disas waa bae faasia 'i Naasaret, nia naa bae God fale nia mai. Bae God faatai folaa mai ai 'ana doo kwaibalatana baki ni kwele lae ki ai bae sa Disas nia ilida 'ana rigitaa God, ma kamolu molu ka saitomana gwamolu da fuli naa 'i matangamolu. ");
INSERT INTO bvd_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","God nia saitomana sui naa ma ka 'olofaorana sui naa uri totoo boroi kera dai falea guu sa Disas 'i 'abamolu. Na toaa nao lau Diu ki daka 'ado kwaimani fai kamolu molu ka saungia ka mae naa, bae molu foto faafi nia 'ana 'airarafolo. ");
INSERT INTO bvd_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Sui ka 'uri bae boroi 'ana, God ka tatae nia lau gwana fasi maea ma ka lafu nia lau gwana fasi lao nonifiia ma na maea, suli maea 'e 'afitai ka dau faafi sa Disas. ");
INSERT INTO bvd_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","'Ana kada 'i nao mai, sa Defet nia bae 'urii sulia Disas, ‘Nau ku suana mai God nia nii fai nau 'i bali aolo nau 'ana kada ki sui guu, ma ka adea nau 'afitai ku maungia lau ta doo. ");
INSERT INTO bvd_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Uri maana si doo nai, mangoku 'e ele 'asia naa ma na ngiduku ka naru suli 'oe 'ana kada ki sui. Noniku lau guu kai too 'ana manata ngadoe, ");
INSERT INTO bvd_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","suli 'oe 'afitai 'oko lukasi nau fua lao maea, ma nao sae 'oko faolomai nau Waa Abu 'oe ku dura gwaku lao kilu. ");
INSERT INTO bvd_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","'Oe 'o faatainia sui naa tala 'ana mauria fuaku. 'Oe tara 'o funguli nau 'ana ele lae uri ku ele 'i naofamu.’” ");
INSERT INTO bvd_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Sa Bita ka bae lau 'urii, “Toolaku ki 'ae, nau ku faarongo folaa 'ani kamolu na kokoo kia sa Defet nia mae gwana, kera daka alu nia ma na likwafau da alu nia ai boroi 'e nii gwana siakolu seki 'i tari'ina. ");
INSERT INTO bvd_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","'Uri nai tama sa Defet nao si bae lau sulia nia tala 'ana nai kada nia saea si doo nai. Sa Defet nia na brofet, ma nia ka saitomana gwana na alangaia God fuana, ne God saea nia kai alua ta waa 'ana kwalafaa sa Defet uri 'inito lae 'i fulina. ");
INSERT INTO bvd_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Sa Defet ka suana sui na mai doo ne God kai ilia, ma sa Defet ka bae sulia na Kraes nia kai tatae faasia maea, ma God ka nao si lukasi nia fua laona kilu ma nonina ka nao si dura. ");
INSERT INTO bvd_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Disas nee gu ne God tataea faasia maea, ma kameli sui guu meli ka suana naa ma meli ka bae na sulia nee. ");
INSERT INTO bvd_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","God nia faa'initoaa sa Disas ka 'inito fainia, ma ka falea na Anoedoo Abu fuana 'uri bae nia alangainia bae. Ma 'i seeri, sa Disas ka fale dangatai na mai 'ana Anoedoo Abu ne kamolu molu rongoa ma molu ka suai naa 'i tari'ina nee. ");
INSERT INTO bvd_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Sulia nao lau sa Defet ne tatae uria salo. Aia ma sa Defet ka bae lau gu 'urii, ‘God nia bae 'urii fua Aofia nau: 'Oe too 'amu bali aolo aku, 'ana 'inito lae fai nau, ");
INSERT INTO bvd_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","maasia si kada nau kwai alu 'oe 'oko 'inito faafia malimae 'oe ki.’ ");
INSERT INTO bvd_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Doo nai gu ne adea nau ku dooria kamolu sui guu toaa 'Israel molu ka saitoma diana 'ana si doo 'urii: Sa Disas waa ne nau ku bae sulia nee, bae kamolu foto faafia 'ana 'airarafolo, nia ne God faa'inito nia ma nia na Aofia ma na Kraes!” ");
INSERT INTO bvd_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ma si kada kera rongo si doo nai na mangoda ka fuu, ma daka bae 'urii fua sa Bita fai na 'aboosol ki, “Toafuta ki 'ae, tee naa ne tara meli ka ilia uri God ka manata luke kameli nai?” ");
INSERT INTO bvd_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Sa Bita luu kera ka 'urii, “Kamolu sui guu, molu bulasi manataa faasia abulo ta'aa laa kamolu ki uri meli ka faasiuabu kamolu. Molu ka manata mamana 'ana sa Disas Kraes uri God ka manata lukea abulo ta'aa laa kamolu ki, ma ka falea na Anoedoo Abu nia fuamolu. ");
INSERT INTO bvd_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Na alangaia bae 'ana Anoedoo Abu doo fuamolu fai wela kamolu ki lau gu bae, fainia doo lau guu fua toaa ne kera too tau ki mai, ne God kia kai 'aili kera lau gu mai.” ");
INSERT INTO bvd_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Sa Bita nia ka saea lau tai si baea 'oro 'ana bae fifii lae ki fuada ka 'urii, “Molu ka sua diana suli kamolu faasia kwakwaea ne toaa ta'aa nee da naofia!” ");
INSERT INTO bvd_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","'I seeri na toaa nai kera da faamamanea na bae lana sa Bita, kera daka siuabu naa. Ma 'afa dani nai, bobola fainia na olu tooni wane ne kera ruu lau mai fai konia nai 'ana toaa manata mamana ki. ");
INSERT INTO bvd_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ma 'afa dani ki sui guu, kera daka noni maabe naa uri fafurongo lana toolangaidoo lana 'aboosol ki. Ma kera daka ade kwaimani 'ana doo ki sui guu ma daka fanga kwaimani ma daka foa kwaimani ki naa. ");
INSERT INTO bvd_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ma na 'aboosol ki daka ilia doo kwaibalatana 'oro ki ma doo 'oro ni kwele lae ki ai, ma na toae ki sui guu daka kwele 'asia naa. ");
INSERT INTO bvd_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ma na toaa manata mamana ki kera daka too kwaimani ma daka sasi diana 'ana si doo ki sui guu matangada kwailiu. ");
INSERT INTO bvd_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ma toaa ne kera faafoli 'ana si gano kera ki ma tai si doo diana 'ada ki, kera daka tolingia malefo kera ngali ki fuada kwailiu ka bobola fainia kwai 'atoia kera ki. ");
INSERT INTO bvd_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ma kera daka koni 'afa dani ki sui guu laona Beukaua nai. Ma kera daka fanga kwaimani 'i luma kera ki 'ana ele lae ma enoenoe laona mauri lada. ");
INSERT INTO bvd_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ma kera daka tangoa God, ma na toae ki sui guu 'i Durusalem daka ele lau gu fai kera. Ma 'afa dani ki sui guu na Aofia ka faamauria tai toaa ki lau ma daka ruu mai fai toaa manata mamana nai. ");
INSERT INTO bvd_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","'Ana tii fa dani 'ana oluna si kada sato 'i saulafi, sa Bita fainia sa Dion keerua daru lea na kau uri foa lae lao Beukaua bae 'ana si kada kera ni foa lae. ");
INSERT INTO bvd_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ma tii waa, na 'aebara nia dai ngali nia kau 'afa dani ki sui guu daka faagoorungainia 'i 'aena maesakaa nai da 'ailia 'ana “Maesakaa Kwanga”, nai dai ruu kau ai uri lao labu 'ana Beukaua nai. Na waa nai, waa 'aena mae 'ua gu mai si kada nia futa. Nia kai gooru ki 'i seeri uri gani doo lae siana toae ki sui gwana ne kera ruu kau 'ana maesakaa nai. ");
INSERT INTO bvd_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ma si kada sa wala nai 'e suana sa Bita fai sa Dion daru kai ruu gu kau, nia ka gani keerua naa uri tafa seleni 'ana siadaru. ");
INSERT INTO bvd_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Sa Bita ka bubungi nia naa, ma sa Dion boroi ka 'uri nai lau guu. Ma sa Bita ka bae 'urii fuana, “Sua miri fasi nee.” ");
INSERT INTO bvd_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Waa nai 'e lio uri keerua, ka manata ngado naa sa daru dai faa 'ana tasi doo. ");
INSERT INTO bvd_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ma sa Bita ka bae 'urii fuana, “Nau nao kwasi too 'ana malefo. Si doo ne nau ku too ai, nia 'ana ne kwai falea fuamu. Nau ku saea fuamu 'ana rigitaa sa Disas Kraes na waa bae 'i Naasaret, 'o tatae 'i langi 'oko fali.” ");
INSERT INTO bvd_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Sa Bita ka dau 'i 'aba aolo nia, ka tataea naa. Ma 'ali'ali 'asi kada nai ua guu, 'aena sa wala nai ka tetede ");
INSERT INTO bvd_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ma nia ka lofo 'alaa, ma ka uu naa 'ana roo 'ae nia ki, ka safali fali na kau. Nia ka ruu na kau fai keerua uri laona labu 'ana Beukaua bae. Ma nia ka fali naa, ka lofo 'alaa ka tangoa na God. ");
INSERT INTO bvd_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Na konia nai daka suana sa wala nai si kada nia fali ma ka tangoa naa God, ");
INSERT INTO bvd_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","kera daka lio saitomana naa. Ne nia waa nai gwana kai gooru firi 'i 'aena maesakaa nai da 'ailia 'ana “Maesakaa kwanga” nai 'ana Beukaua bae, ma kai gani doo firi nai. Ma kera daka kwele 'asia naa 'ana si doo nai 'e fuli 'ana sa wala nai. ");
INSERT INTO bvd_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Si kada sa wala nai 'e dau 'abe'abe 'ua gwana 'ana sa Bita fai sa Dion, konia nai sui guu daka kwele 'asia naa ma daka lae tiifau mai siada lao bali tafasusu nai da 'ailia 'ana “Tafasusu sa Solomon.” ");
INSERT INTO bvd_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Si kada sa Bita 'e suai kera da ade 'uri nai, nia ka bae 'urii fuada, “Kamolu toaa nee 'i 'Israel, tee ne adea molu ka kwele baita 'asia naa 'ana si doo nai? Kamolu molu bubungi kaaria na molu mala bae sae tetedea kaaria 'ana tala 'aaria, ma nao sae nunufana abulo 'o'olo laa kaaria fua God tala 'aaria ne miri guraa sa wala nee ai! ");
INSERT INTO bvd_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","God ne sa 'Abraham, ma sa 'Aesak, ma sa Diakab, ma God ne kokoo kia ki sui naa da foosia, nia ne tala tafoa 'ana satana waa ni rao nia sa Disas 'i tari'ina nee. Kamolu bae molu tala noni'ela 'amolua 'ana sa Disas 'i naofana sa Baelat si kada bae sae nia kai lukea mai sa Disas, ma sui molu ka falea 'amolua sa Disas uri daka saumaeli nia 'ada. ");
INSERT INTO bvd_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kamolu molu noni'ela 'amolua 'ana sa Disas na waa abu ma waa 'o'olo bae, ma sui molu ka radu 'aena 'amolua sa Baelat uri ka lukea mai na waa sauwane bae mone fuamolu. ");
INSERT INTO bvd_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ni kamolu molu saungia naa sa Disas bae, na waa ne nia gwaufutona maurie naa. Sui God ka tatae nia naa faasia maea, ma kaaria miri ka suai naa mamana lana si doo nai. ");
INSERT INTO bvd_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Sa wala nee 'aena 'e diana naa nee, kamolu molu suana molu ka lio saitomana gwamolu ne. Nia 'e faamamanea tetedea sa Disas ne adea nia ka tetede naa nee. Na rigitaa sa Disas fai na manata mamana lae 'ani nia ne adea sa wala nee ka 'akwaa tiifau naa molu ka suana naa nee. ");
INSERT INTO bvd_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Iuka nia mamana toafuta nau, nau ku saitomana na ulafusidoo lae ne nia adea molu ka ilia si doo nai 'ana sa Disas, ma toa gwaungai kamolu ki boroi kera daka ili lau gu 'uri nai 'ani nia. ");
INSERT INTO bvd_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ma sui ta, God nia saea sui na mai 'i nao 'ana brofet ki ne totoo boroi na Kraes nia kai nonifii. Ma si baea nai God saea mai, na fuli lana naa bae. ");
INSERT INTO bvd_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nia 'uri nai, kamolu molu bulasi manataa naa faasia abulo ta'aa laa kamolu ki molu ka abulo talea God, uri nia ka manata lukea abulo ta'aa laa kamolu ki, ma ka falea mai elea fuamolu ne 'ita mai fasi God. ");
INSERT INTO bvd_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ma uri nia ka falea mai sa Disas na Kraes fuamolu. ");
INSERT INTO bvd_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nia kai too mai 'i salo lelea ka dao guu 'ana si kada God 'e faa faalua doo ki sui, mala bae nia saea 'uana mai 'ana brofet abu nia ki. ");
INSERT INTO bvd_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Suli sa Mosis 'e bae mai 'urii sulia, ‘God kolu nia kai tafoa tii brofet 'uri nau lau guu fuamolu. Tara nia ta waa 'ani kamolu 'ua guu toaa Diu. Molu ka ade suli si doo nia saea fuamolu. ");
INSERT INTO bvd_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tii ne nao si ade suli si doo nia saea, waa nai God kai faia 'i sara faasia matangana toaa nia ki uri ka funu naa.’ ");
INSERT INTO bvd_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","'Ita mai 'ana sa Samuel, ma ka lea mai 'ana brofet baki sui guu da faarongo talo 'ana bae lana God, kera da faatalongainia sui guu si doo ne fuli naa lao fa sato 'i tari'ina ki. ");
INSERT INTO bvd_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Na alangaia God bae na brofet ki da bae mai sulia 'ana kada 'i nao, na doo fuamolu lau guu, ma molu ka 'ado lau guu 'ana doo God alangainia ki fua kokoo kamolu ki. 'Uri bae nia 'e bae mai 'urii fua sa 'Abraham, ‘Na wela ne kai futa mai 'ana kwalafaa 'oe, nia kai faadianaa nau fua toae ki sui guu lao molaagali.’ ");
INSERT INTO bvd_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nia ne, si kada God nia filia mai sa Disas waa ni rao nia ka lea mai siamolu, nia fale nia fasi mai siamolu nao uri ka falea dianaa fuamolu, si kada kamolu bulasi manataa faasia abulo ta'aa laa kamolu ki.” ");
INSERT INTO bvd_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Si kada sa Bita fai sa Dion daru bae 'ua gwadaru fua toaa nai, na waa ni foa ki ma na toa da fofolo kalia Beukaua nai fai na Sadiusii ki lau guu daka dao na siada. ");
INSERT INTO bvd_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Toa gwaungai nai manata lada ka ta'aa 'asia naa 'ana 'aboosol nai ki, suli keerua daru toolangaidoo fua konia nai ma daru ka faatalongai sulia sa Disas nia tatae naa fasi maea. Ma na tatae lana sa Disas faasia maea nia faatainia ne wane ki sui gwana dai tatae faasia maea. ");
INSERT INTO bvd_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kera daka daua naa sa Bita fai sa Dion, ma daka alu keerua naa laona lookafo daru ka tio na seeri uri 'uubongi, suli nia saulafi rodo naa. ");
INSERT INTO bvd_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ka 'uri nai boroi 'ana, na toaa 'oro nai kera da rongoa baea nai keerua daru bae sulia, kera daka manata mamana naa. Ma na toa da manata mamana 'ana si kada nai gwana nia dao bobola fainia lima tooni wane naa. ");
INSERT INTO bvd_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Sui tio 'e dani 'i burina guu, na waa gwaungai ki ma na waa toolangaidoo ki 'ana taki da koni daka bae ofu naa lao fera 'i Durusalem. ");
INSERT INTO bvd_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Na ofu laa nai, sa 'Anas waa foa ni gwau ma sa Kaeafas ma sa Dion, ma sa 'Aleksanda fainia tai toa ki lau 'ana 'aebara nia waa foa ni gwau ne da nii laona. ");
INSERT INTO bvd_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ma kera daka 'ailia mai sa Bita fainia sa Dion uri bae lae 'i naofada tiifau, ma daka safali ledi keerua naa. Daka 'urii, “Nee wala, mamanaa tee ne muru guraa sa wala bae ai, ma sa tii ne falea rigitaa fuamuru uri ili lana si doo nai?” ");
INSERT INTO bvd_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","'I seeri na Anoedoo Abu ka burosia naa sa Bita ma ka faabae nia ka bae na 'urii fuada, “Ku faarongo kamolu toa 'inito ma toa gwaungai nee. ");
INSERT INTO bvd_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Kamolu molu ledi kaaria uri miri ka unu sulia si doo diana bae miri ilia fua waa 'aena mae bae, ma rigitaa tee bae adea nia ka diana naa bae ne. ");
INSERT INTO bvd_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Aia, kaaria miri dooria kamolu ma na toaa nee 'i 'Israel sui naa molu ka saitomana ne: Na rigitaa 'ana satana sa Disas Kraes waa bae 'i Naasaret bae kamolu saungia ka mae 'ana 'airarafolo ma sui God ka tataea lau fasi maea, nia ne faa 'akwaa sa wala nee ka 'akwaa, ne molu ka suana ka uu naa 'i naofamolu nee. ");
INSERT INTO bvd_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Sa Disas, nia bae na kekeda laa Abu 'e bae suli nia ka 'urii, ‘Fau bae toa kamolu ki ni saungai luma lae da 'ui gwada ai ne, ma sui nia fatai ne fau 'initoa tasa nai uri faangado lana lume.’ ");
INSERT INTO bvd_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Taifili nia naa ne bobola fainia faamauri lana toae ki sui, nao naa ta waa lau lao fera ne 'i saegano uri kolu ka mauri nunufana.” ");
INSERT INTO bvd_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","'I seeri toa gwaungai nai ki daka kwele 'asia naa 'ana sa Bita fai sa Dion, suli keerua nao daru si s