﻿USE sofia;
DROP TABLE IF EXISTS sofia.bus_vpl;
CREATE TABLE bus_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bus_vpl WRITE;
INSERT INTO bus_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","À káaku Luda musu kↄ̃n tↄↄtɛo kɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Guu da pãmɛ à kɛkɛnaro, gusiaa bé à da ísiaala, ben Luda Ninii e yàa paa í pìla. ");
INSERT INTO bus_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ben Luda bè: Guu pu! Ben guu pù. ");
INSERT INTO bus_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","À è gupuraa pì maa, ben à gupuraa kɛ̃̀kↄ̃a kↄ̃n gusiaao. ");
INSERT INTO bus_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","À tↄ́ kpà gupuraanɛ fãantɛ̃, gusiaa sↄ̃ gwãavĩ. Guu sì guu dↄ̀, à gurↄ káakun gwe. ");
INSERT INTO bus_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ben Luda bè: Bàtuma gↄ̃ kú ínↄ dagura lɛ à í pìnↄ kɛ̃kↄ̃a. ");
INSERT INTO bus_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ben à bàtuma kɛ̀ lɛ, à í kɛ̀ kú bàtuma gĩzĩ kɛ̃̀kↄ̃a kↄ̃n í kɛ̀ kú à musuo. ");
INSERT INTO bus_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ben à tↄ́ kpà bàtuma pìnɛ ludambɛ. Guu sì guu dↄ̀, à gurↄ plaadeen gwe. ");
INSERT INTO bus_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ben Luda bè: Í kɛ̀ kú gĩzĩ kakↄ̃a gu dↄ̃nkↄ̃n, gukori bↄ. Ben à kɛ̀ lɛ. ");
INSERT INTO bus_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","À tↄ́ kpà gukori pìnɛ tↄↄtɛ, ben à tↄ́ kpà í kɛ̀ kàkↄ̃aanɛ ísiaa. Ben à è à kɛ̀ maa. ");
INSERT INTO bus_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ben Luda bè: Lánↄ bↄɛ tↄↄtɛ kↄ̃n sɛ̃̀ wɛ́ɛdeenↄ kↄ̃n lí nɛ́deenↄ, baade kↄ̃n a boriio. Ben à kɛ̀ lɛ, ");
INSERT INTO bus_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","lánↄ bↄ̀ɛ tↄↄtɛ kↄ̃n sɛ̃̀ wɛ́ɛdeenↄ kↄ̃n lí nɛ́deenↄ, baade kↄ̃n a boriio. Ben Ludaa è à kɛ̀ maa. ");
INSERT INTO bus_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Guu sì guu dↄ̀, à gurↄ aagↄ̃deen gwe. ");
INSERT INTO bus_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ben Luda bè: Pↄ́ gupurinↄ gↄ̃ kú musu aↄ̃gↄ̃ fãantɛ̃ kɛ̃ɛkↄ̃a kↄ̃n gwãavĩo, aↄ̃gↄ̃ wɛ̃̀ sèedanↄ kↄ̃n gurↄↄnↄ kↄ̃n wɛ̃̀nↄ ↄdↄańnɛ. ");
INSERT INTO bus_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Aↄ̃gↄ̃ dɛ pↄ́ gupurinↄ ũ musu lɛ wàgↄ̃ anduna puu. Ben à kɛ̀ lɛ. ");
INSERT INTO bus_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","À pↄ́ gupuri ìsinↄ kɛ̀ mɛ̀n plaa, à kɛ̀ gbãaa ègↄ̃ kí blee fãantɛ̃, à kɛ̀ busɛ ègↄ̃ kí blee gwãavĩ. À sↄsↄnɛnↄ kɛ̀ dↄ. ");
INSERT INTO bus_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","À ń pɛ́pɛ musu lɛ aↄ̃gↄ̃ anduna puu ");
INSERT INTO bus_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","aↄ̃gↄ̃ kí blee fãantɛ̃ kↄ̃n gwãavĩo, aↄ̃gↄ̃ gupura kɛ̃ɛkↄ̃a kↄ̃n gusiaao. Ben à è à kɛ̀ maa. ");
INSERT INTO bus_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Guu sì guu dↄ̀, à gurↄ siigↄ̃deen gwe. ");
INSERT INTO bus_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ben Luda bè: Pↄ́ wɛ̃̀ndideenↄ í pa yɛ́lɛlɛ, bãanↄ dagula musu aↄ̃gↄ̃ vĩaa bàtumaa. ");
INSERT INTO bus_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ben à pↄ́ wɛ̃̀ndidee kɛ̀ aↄ̃è lili o í guunↄ kɛ̀ kↄ̃n kpↄ̀ gbɛ̃̀ntɛ̃nↄ píngi, baade kↄ̃n a boriio. À bãanↄ kɛ̀ píngi dↄ, baade kↄ̃n a boriio. Ben à è à kɛ̀ maa. ");
INSERT INTO bus_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","À aubarika dàńgu à bè, aↄ̃gↄ̃ nɛ́ ii aↄ̃gↄ̃ kↄ̃ↄ, kpↄ̀nↄ ísiaa pa, bãanↄ kↄ̃ tↄↄtɛ. ");
INSERT INTO bus_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Guu sì guu dↄ̀, à gurↄ sↄↄrodeen gwe. ");
INSERT INTO bus_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ben Luda bè: Pↄ́ wɛ̃̀ndideenↄ bↄɛ tↄↄtɛa, pↄ́kãdeenↄ kↄ̃n pↄ́taa'onkusɛanↄ kↄ̃n nↄ̀bↄsɛ̃tɛnↄ, baade kↄ̃n a boriio. Ben à kɛ̀ lɛ. ");
INSERT INTO bus_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Luda nↄ̀bↄsɛ̃tɛnↄ kɛ̀ baade kↄ̃n a boriio. À pↄ́kãdeenↄ kɛ̀ baade kↄ̃n a boriio. À pↄ́taa'onkusɛanↄ kɛ̀ baade kↄ̃n a boriio. Ben à è à kɛ̀ maa. ");
INSERT INTO bus_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ben Luda bè: Wà gbɛ̃ntee kɛ wa taka ũ, aↄ̃gↄ̃ dɛ wa bà, aↄ̃gↄ̃ kí blee kpↄ̀nↄa kↄ̃n bãanↄ kↄ̃n pↄ́kãdeenↄ kↄ̃n nↄ̀bↄsɛ̃tɛnↄ kↄ̃n pↄ́taa'onkusɛanↄ píngi. ");
INSERT INTO bus_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ben Luda gbɛ̃ntee kɛ̀ a zĩnda taka ũ. À zĩnda takan à ń kɛ́ à ũ. À ń kɛ́ gↄ̃gbɛ̃ kↄ̃n nↄgbɛ̃o. ");
INSERT INTO bus_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","À aubarika dàńgu à bèńnɛ: Àgↄ̃ nɛ́ ii àgↄ̃ kↄ̃ↄ à anduna pa àgↄ̃ gbãaa bleea. Àgↄ̃ kí blee kpↄ̀nↄa kↄ̃n bãanↄ kↄ̃n pↄ́ wɛ̃̀ndidee kɛ̀ aↄ̃è táa o tↄↄtɛanↄ píngi. ");
INSERT INTO bus_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ben Luda bè: Ma pↄ́ wɛ́ɛdee kɛ̀ kú tↄↄtɛanↄ kpàawa a pↄ́blee ũ píngi kↄ̃n lí nɛ́deenↄ píngi. ");
INSERT INTO bus_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ma sɛ̃̀nↄ kↄ̃n lánↄ kpà pↄ́ wɛ̃̀ndideenↄa píngi ń pↄ́blee ũ, nↄ̀bↄnↄ kↄ̃n bãanↄ kↄ̃n pↄ́taa'onkusɛanↄ píngi. Ben à kɛ̀ lɛ. ");
INSERT INTO bus_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Luda pↄ́ kɛ̀ à kɛ̀nↄ è píngi, à kɛ̀ maa wásawasa. Guu sì guu dↄ̀, à gurↄ swɛɛdodeen gwe. ");
INSERT INTO bus_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Lɛn Luda musu kↄ̃n tↄↄtɛo kɛ̀ lɛ kↄ̃n ń pↄ́nↄ píngi. ");
INSERT INTO bus_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ai à gurↄ swɛɛplaadee zĩ gↄ̃ ká, à zĩi kɛ̀ èe kɛɛ pì yã̀a. À gurↄ swɛɛplaadee pìn à kámma bò kↄ̃n zĩi kɛ̀ à kɛ̀nↄ píngi. ");
INSERT INTO bus_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ben à aubarika dà gurↄ swɛɛplaadee pìn à dìɛ a pↄ́ ũ, kɛ̀ zĩ beeen à kámma bò kↄ̃n zĩi kɛ̀ à kɛ̀nↄ píngi yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Musu kↄ̃n tↄↄtɛo naana yãn yɛ̀. Gurↄↄ kɛ̀ Dii Luda tↄↄtɛ kↄ̃n musuo kɛ̀, ");
INSERT INTO bus_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","bura pↄ́kee e bↄɛ tↄↄtɛa kↄ̀ro, baa sɛ̃̀, zaakɛ Dii Ludaa e tó lou màro, bensↄ̃ gbɛ̃kee kuu à tↄↄtɛ zĩi kɛro. ");
INSERT INTO bus_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Sukaa bé è kpá andunala, ben è mↄdↄ pisi tↄↄtɛa píngi. ");
INSERT INTO bus_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Dii Luda gↄ̃gbɛ̃ í kàsa kↄ̃n bùsutio, ben à ĩa wɛ̃̀ndidee vù à yĩn, ben gↄ̃gbɛ̃ pì gↄ̃̀ gbɛ̃ bɛ̃ɛ ũ. ");
INSERT INTO bus_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Dii Luda swadako dìɛ ↄfãntɛ̃bↄɛ kpa kɛ̀ wè be Ɛdɛni, ben à gↄ̃gbɛ̃ kɛ̀ à kɛ̀ pì dà gwe. ");
INSERT INTO bus_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Dii Luda tò lí bori píngi bↄ̀ɛ tↄↄtɛa. Lí pìnↄↄ maa, bensↄ̃ ń bɛ blena nna. Lí wɛ̃̀ndide kú dàko pì gura. Lí kɛ̀ è dↄ̃na maa kↄ̃n à zaaao ińnɛ kú gwe dↄ. ");
INSERT INTO bus_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Swaa kú Ɛdɛni ègↄ̃ mↄdↄ pisi dàko pìa. Bↄna gwe à ↄnɛ kɛ̀ siigↄ̃. ");
INSERT INTO bus_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","À káaku tↄ́n Pisↄ̃, àmbe à liga Avila bùsuzi píngi. Vura kú bùsu pì guu, ");
INSERT INTO bus_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","vura pì maa. Gbɛ̀ bɛ̀ɛdeenↄↄ kú gwe dↄ. ");
INSERT INTO bus_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Swaa pì ↄnɛ plaade tↄ́n Giↄ̃, à liga Kusu bùsuzi píngi. ");
INSERT INTO bus_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","À ↄnɛ aagↄ̃de tↄ́n Tigiri, à dↄ̀rↄ tà Asiria bùsu ↄfãntɛ̃bↄɛ kpa. Swaa pì ↄnɛ siigↄ̃de tↄ́n Yuflati. ");
INSERT INTO bus_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Dii Luda gↄ̃gbɛ̃ pì dìɛ Ɛdɛni dàko pì guu lɛ àgↄ̃ à zĩi kɛ àgↄ̃ gwaa. ");
INSERT INTO bus_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ben à yã dìɛnɛ à bè: Nɛ́ fↄ̃ ǹ dàko pì lí píngi bɛɛ ble, ");
INSERT INTO bus_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","mↄde ǹton lí kɛ̀ è dↄ̃na maa kↄ̃n à zaaao ińnɛ bɛɛ blero. Tó ń blè, n gamɛ. ");
INSERT INTO bus_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Dii Luda bè: Gↄ̃gbɛ̃ kuuna adoo maaro. Mɛ́ dↄnlɛri kɛnɛ à gbɛ̃ndoo ũ. ");
INSERT INTO bus_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ben Dii Luda bùsu kↄ̀ à nↄ̀bↄnↄ kɛ̀o píngi kↄ̃n bãanↄ píngi, ben à mↄ̀ńyo gↄ̃gbɛ̃ pì kiia lɛ à e dian eé tↄ́ kpáńnɛ nà. Tↄ́ kɛ̀ gↄ̃gbɛ̃ pì kpà pↄ́ wɛ̃̀ndidee pìnↄnɛ píngi gↄ̃̀ ń tↄ́ ũ. ");
INSERT INTO bus_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Gↄ̃gbɛ̃ pì tↄ́ kpà pↄ́kãdeenↄnɛ píngi kↄ̃n bãanↄ kↄ̃n nↄ̀bↄsɛ̃tɛnↄ píngi, mↄde èe dↄnlɛri e ń tɛ́ a gbɛ̃ndoo ũro. ");
INSERT INTO bus_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ben Dii Luda i ìsi dà gↄ̃gbɛ̃ pìla. Kɛ̀ èe ii oo, ben à à gbã̀ntɛ̃wa mɛ̀n doo bↄ̀, ben à à mɛ̀baasi tàta a gbɛ̀n. ");
INSERT INTO bus_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ben à gↄ̃gbɛ̃ gbã̀ntɛ̃wa kɛ̀ à bↄ̀ pì lìɛ nↄgbɛ̃ ũ, ben à gàao à kiia. ");
INSERT INTO bus_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ben gↄ̃gbɛ̃ pì bè: Kɛ̀ki wá bↄ̀ ma wá guumɛ, à mɛ̀ sↄ̃ bↄ̀ ma mɛ̀ guumɛ. Weé à sísi nↄgbɛ̃, kɛ̀ Luda à bↄ̀ gↄ̃gbɛ̃ guu yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Beee yãnzin gↄ̃gbɛ̃ è a de kↄ̃n a dao tó, aↄ̃è nakↄ̃a kↄ̃n a naↄ̃o wà gↄ̃ mɛ̀ doo ũ. ");
INSERT INTO bus_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Gↄ̃gbɛ̃ kↄ̃n a naↄ̃o kú bũu ń plaa ń píngi, wí sↄ̃ è ń kũro. ");
INSERT INTO bus_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Mlɛ̃̀ bé à mↄnafiki vĩ dɛ pↄ́ kɛ̀ Dii Ludaa kɛ̀nↄla píngi, ben à nↄgbɛ̃ là à bè: Luda bè àton dàko pì lí ke bɛɛ blenloo? ");
INSERT INTO bus_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ben nↄgbɛ̃ wè mlɛ̃̀ pìla à bè: Wé fↄ̃ wà dàko pì líbɛɛ ble, ");
INSERT INTO bus_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","mↄde lí kɛ̀ kú dàko pì gura súusu, Luda bè wàton à bɛɛ blero wàton ↄ kɛa sero, lɛ wàton garo yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ben mlɛ̃̀ bènɛ: É ga sero! ");
INSERT INTO bus_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Zaakɛ Ludaa dↄ̃ kɛ̀ tó á blè, a wɛ́ɛ é kɛ̃ é gↄ̃ lán a bà, égↄ̃ à maaa dↄ̃ kↄ̃n à zaaao. ");
INSERT INTO bus_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Kɛ̀ nↄgbɛ̃ è lí pì bɛɛ maa, bensↄ̃ à blena égↄ̃ nna eé tó gbɛ̃ wɛ́ɛ kɛ̃, ben à à bɛɛ wò à blè. À kpà a zãa sↄ̃, ben à blè. ");
INSERT INTO bus_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Aↄ̃ plaa ń píngi wɛ́ɛ kɛ̃̀, ben aↄ̃ↄ dↄ̃̀ sa kɛ̀ aↄ̃ↄ kú bũu. Ben aↄ̃ gooda lá nàbi wà nàńzi. ");
INSERT INTO bus_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Kɛ̀ gↄ̃gbɛ̃ kↄ̃n a naↄ̃o Dii Luda kĩi mà èe táa oo dàko pì guu uusiɛ, ben aↄ̃ ùtɛnɛ dàko pì lán. ");
INSERT INTO bus_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ben Dii Luda lɛ́ zù gↄ̃gbɛ̃zi à bè: Ń kú mámɛ? ");
INSERT INTO bus_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","À wèàla à bè: Kɛ̀ ma n kĩi mà, ben vĩa ma kũ kɛ̀ má kú bũu yãnzi, ben ma utɛ. ");
INSERT INTO bus_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ben Dii Luda à là à bè: Dé bé à ònnɛ ń kú bũuu? Lí kɛ̀ ma ginnɛ ǹ à bɛɛ ble, ń blèn yↄ́? ");
INSERT INTO bus_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","À wèàla à bè: Nↄgbɛ̃ kɛ̀ ń kpàma àgↄ̃ kúmao bé à lí pì bɛɛ kpàma má blè. ");
INSERT INTO bus_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ben Dii Luda nↄgbɛ̃ là à bè: Bↄ́yãnzi ń kɛ̀ lɛzi? À wèàla à bè: Mlɛ̃̀ bé à ma kɛkɛ, ben má blè. ");
INSERT INTO bus_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ben Dii Luda bè mlɛ̃̀nɛ: Kɛ̀ ń kɛ̀ lɛ, nɛ́gↄ̃ dɛ láari pↄ́ ũ pↄ́kãdeenↄ kↄ̃n nↄ̀bↄsɛ̃tɛnↄ tɛ́ píngi, n gbɛɛɛn nɛ́gↄ̃ gáɛɛ, bùsutin nɛ́gↄ̃ blee ai n wɛ̃̀ndi lɛ́n. ");
INSERT INTO bus_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mɛ́ íbɛtɛ da mpi kↄ̃n nↄgbɛ̃o dagura, n bori kↄ̃n à boriio dagura. À borii é n mì wí, nɛ́ à gbátoge kɛ̃nna. ");
INSERT INTO bus_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ben à bè nↄgbɛ̃nɛ: Mɛ́ n nↄ̀sina wãwãa kaarannɛ, nɛ́gↄ̃ nɛ́ ii wãwãao. N zã nii égↄ̃ kúmmamɛ, eégↄ̃ gbãa vĩ n musu. ");
INSERT INTO bus_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ben à bè gↄ̃gbɛ̃nɛ: Lán n n naↄ̃ yã mà nà, lí kɛ̀ ma ginnɛ ǹ à bɛɛ blee ń blè, tↄↄtɛ gↄ̃̀ láari pↄ́ ũ n yãnzi, ↄsi kↄ̃n ↄsiion nɛ́gↄ̃ pↄ́blee en ai n wɛ̃̀ndi lɛ́n. ");
INSERT INTO bus_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Eé lɛ̀nↄ kↄ̃n lá ũkãdeenↄ bↄɛnnɛ, gbasa ǹ bura pↄ́nↄ ble. ");
INSERT INTO bus_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ísimmagaakpana guun nɛ́ pↄ́blee en ai ǹ liara ǹ gɛ̃ bùsu guu, zaakɛ gwen ma n bↄn. Bùsutin n ũ, nɛ́ liara ǹ gↄ̃ bùsuti pì ũmɛ. ");
INSERT INTO bus_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adamu tↄ́ kpà a naↄ̃nɛ Awau, zaakɛ gbɛ̃ píngi dazimɛ. ");
INSERT INTO bus_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Dii Luda báa uta kɛ̀ Adamunɛ kↄ̃n à naↄ̃o, ben à dàńnɛ. ");
INSERT INTO bus_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ben à bè: Gbɛ̃ntee à maa kↄ̃n à zaaao dↄ̃̀ sa, à gↄ̃̀ lán wa bà. Wé gínɛ à lí wɛ̃̀ndide bɛɛ wo à ble, lɛ àtongↄ̃ kuu gurↄ píngiro yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ben Dii Luda pɛ̀a à à bↄ̀ Ɛdɛni dàko pì guu. Ben Adamu gàa à tↄↄtɛ kɛ̀ Luda à bↄ̀n zĩi kɛ. ");
INSERT INTO bus_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Kɛ̀ Dii Luda pɛ̀a, ben à kɛrubunↄ kàɛ Ɛdɛni dàko ↄfãntɛ̃bↄɛ kpa, lɛ aↄ̃gↄ̃ lí wɛ̃̀ndide zɛ́ dãkpaa kↄ̃n fɛ̃ɛdaa kɛ̀ èe tɛ́ kɛɛ èe liɛliɛɛo. ");
INSERT INTO bus_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu a naↄ̃ Awau dↄ̃̀ nↄgbɛ̃ ũ, ben à nↄ̀ sì à Kaini ì. Ben à bè: Ma gↄ̃gbɛ̃ ì kↄ̃n Dii gbãaao. ");
INSERT INTO bus_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ben à à dãaro Abila ì dↄ. Abila kɛ̀ sãdãri ũ, Kaini sↄ̃ kɛ̀ búbari ũ. ");
INSERT INTO bus_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Zĩkea Kaini mↄ̀ kↄ̃n a bura pↄ́nↄo gbaa ũ Diinɛ. ");
INSERT INTO bus_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abila sↄ̃ mↄ̀ kↄ̃n a sãnɛ káaku mɛ̀kpanao. Abila yã kà Diinɛ, ben à à gbaa sì. ");
INSERT INTO bus_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Kaini sↄ̃ yã e ká Diinɛro, ben èe à gba síro. Ben Kaini pↄ fɛ̃̀ maamaa à uu yàkↄ̃tɛ. ");
INSERT INTO bus_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ben Dii bè Kaininɛ: Bↄ́yãnzi n pↄ fɛ̃̀zi? À kɛ̀ dia n uu yàkↄ̃tɛɛ? ");
INSERT INTO bus_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Tó n yã maaa kɛ̀, mɛ́ n síroo? Tó nɛ́ɛ yã maaa kɛ sↄ̃ro, durun naɛnnɛ n kpɛɛlɛ. N nii e à dɛɛ, séde ǹ zĩ̀ blea. ");
INSERT INTO bus_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ben Kaini bè a dãaro Abilanɛ: Wà gá sɛ̃̀n. Kɛ̀ aↄ̃ kà gwe, ben à fɛ̀ɛ a dãarozi à à dɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Dii Kaini là à bè: Mán n dãaro Abila kún? À wèàla à bè: Má dↄ̃ro. Ma dãaro dãkparin ma ũↄ́? ");
INSERT INTO bus_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ben Dii bè: Bↄ ń kɛ̀? N dãaro aru e lɛ́ zuumazi zaa tↄↄtɛ. ");
INSERT INTO bus_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Tia sa nɛ́gↄ̃ láari pↄ́ ũmɛ, nɛ́gↄ̃ zã̀ kↄ̃n tↄↄtɛ kɛ̀ n dãaro aru mì n ↄzĩo. ");
INSERT INTO bus_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Tó n bú bà, tↄↄtɛ é àre kɛnnɛro. Nɛ́gↄ̃ sↄ̃ki kpákpaa ǹgↄ̃ likↄ̃aa zↄ̃ↄ anduna guu. ");
INSERT INTO bus_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ben Kaini bè Diinɛ: Ĩadamma beee gbãa dɛmala, mɛ́ fↄ̃ro. ");
INSERT INTO bus_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Nɛ́ɛ pɛɛma tↄↄtɛ kɛ̀a gbã̀amɛ sa. Mɛ́ kɛ̃kↄ̃anyo sa. Mɛ́gↄ̃ sↄ̃ki kpákpaa màgↄ̃ likↄ̃aa zↄ̃ↄ anduna guu, gbɛ̃ kɛ̀ kpàkũmao é ma dɛ. ");
INSERT INTO bus_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ben Dii bènɛ: Lɛnlo! Tó gbɛ̃ n dɛ, weé gɛ̃ɛ bonnɛ gɛ̃̀n swɛɛplaamɛ. Ben Dii wɛ̃zã ke kɛ̀ Kainia, lɛ gbɛ̃ kɛ̀ kpàkũo tón à dɛro yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ben Kaini dà zɛ́n à kɛ̃̀ Diia. À gàa à vɛ̃̀ɛ Nↄdu bùsun Ɛdɛni ↄfãntɛ̃bↄɛ kpa. ");
INSERT INTO bus_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaini dàɛ kↄ̃n a naↄ̃o, ben à nↄ̀ sì à Ɛnↄku ì. À gbɛra Kaini wɛ́tɛ kàɛ, ben à a nɛ́ pì tↄ́ kpà wɛ́tɛ pìnɛ. ");
INSERT INTO bus_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ɛnↄku Irada ì, Irada Mɛuyaɛli ì, Mɛuyaɛli Mɛtusaɛli ì, Mɛtusaɛli Lamɛki ì. ");
INSERT INTO bus_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamɛki nↄↄ sɛ̀ mɛ̀n plaa, à doo tↄ́n Ada, à doo sↄ̃ Zila. ");
INSERT INTO bus_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada Yabala ì. Àmbe pↄ́dãri kɛ̀ aↄ̃ègↄ̃ kú bisakutaa guunↄ dezi káaku ũ. ");
INSERT INTO bus_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","À dãaro tↄ́n Yubala. Àmbe mↄrↄlɛrinↄ kↄ̃n kurepɛrinↄ dezi káaku ũ. ");
INSERT INTO bus_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila sↄ̃ bé à Tubala Kaini ì. Sian à ũ. È pↄ́ píngi pi kↄ̃n mↄ̀sio kↄ̃n mↄ̀gotɛ̃o. À dãre tↄ́n Naama. ");
INSERT INTO bus_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ben Lamɛki bè a naↄ̃ↄnↄnɛ: Ada kↄ̃n Zilao, à ma yã ma, ma naↄ̃nↄ, à swã kpá ma yãzi. Gbɛ̃ke ma kɛ̃nna, ben ma à dɛ̀, gↄ̃kparɛ pì ma lɛmɛ, ben ma à kàatɛ. ");
INSERT INTO bus_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Tó weé Kaini gɛ̃ɛ bonɛ gɛ̃̀n swɛɛplaa, mamↄma Lamɛki ma pↄ́ sↄ̃, gɛ̃̀n baaagↄ̃ akuri awɛɛswɛɛplaamɛ. ");
INSERT INTO bus_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu dàɛ kↄ̃n a naↄ̃o dↄ, ben à nɛ́gↄ̃gbɛ̃ ì. À tↄ́ kpànɛ Sɛti à bè, Luda a gba nɛ́ pãnde Abila kɛ̀ Kaini dɛ̀ gɛ̃ɛ ũmɛ. ");
INSERT INTO bus_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sɛti sↄ̃ nɛ́gↄ̃gbɛ̃ ì, ben à tↄ́ kpànɛ Ɛnↄsu. Zaa zĩ beeean wà nà Dii sísinaa. ");
INSERT INTO bus_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adamu boriinↄ yãn yɛ̀. Gurↄↄ kɛ̀ Luda gbɛ̃nteenↄ kɛ̀, à ń kɛ́ lán a bàmɛ. ");
INSERT INTO bus_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","À ń kɛ́ gↄ̃gbɛ̃ kↄ̃n nↄgbɛ̃o, ben à aubarika dàńgu. À tↄ́ kpàńnɛ gbɛ̃ntee. ");
INSERT INTO bus_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamu wɛ̃̀ baswɛɛdo akuridee guun à nɛ́ ì a taka ũ à bↄ̀kↄ̃bao, ben à tↄ́ kpànɛ Sɛti. ");
INSERT INTO bus_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sɛti ina gbɛra à kɛ̀ wɛ̃̀ wàa siigↄ̃ à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄo. ");
INSERT INTO bus_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Kɛ̀ à kà wɛ̃̀ wàa siigↄ̃ kpɛ́ baswɛɛdo akuri, ben à gà. ");
INSERT INTO bus_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sɛti wɛ̃̀ basↄↄro asↄↄrodee guun à Ɛnↄsu ì. ");
INSERT INTO bus_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","À gbɛra à kɛ̀ wɛ̃̀ wàa siigↄ̃ awɛɛswɛɛplaa à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄo. ");
INSERT INTO bus_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Kɛ̀ à kà wɛ̃̀ wàa siigↄ̃ kpɛ́ basↄↄro akuri awɛɛplaa, ben à gà. ");
INSERT INTO bus_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ɛnↄsu wɛ̃̀ basiigↄ̃ akuridee guun à Kenana ì. ");
INSERT INTO bus_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","À gbɛra à kɛ̀ wɛ̃̀ wàa siigↄ̃ kↄ̃n gɛ̃roo à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄo. ");
INSERT INTO bus_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Kɛ̀ à kà wɛ̃̀ wàa siigↄ̃ kpɛ́ basↄↄro asↄↄro, ben à gà. ");
INSERT INTO bus_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenana wɛ̃̀ baaagↄ̃ akuridee guun à Malalɛli ì. ");
INSERT INTO bus_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","À gbɛra à kɛ̀ wɛ̃̀ wàa siigↄ̃ kpɛ́ baplaa à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄo. ");
INSERT INTO bus_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kɛ̀ à kà wɛ̃̀ wàa siigↄ̃ kpɛ́ basↄↄro akuri, ben à gà. ");
INSERT INTO bus_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Malalɛli wɛ̃̀ baaagↄ̃ asↄↄrodee guun à Yarɛdi ì. ");
INSERT INTO bus_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","À gbɛra à kɛ̀ wɛ̃̀ wàa siigↄ̃ kↄ̃n baaakurio à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄo. ");
INSERT INTO bus_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Kɛ̀ à kà wɛ̃̀ wàa siigↄ̃ kpɛ́ basↄↄro sↄↄrosai, ben à gà. ");
INSERT INTO bus_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yarɛdi wɛ̃̀ basↄraagↄ̃ awɛɛplaadee guun à Ɛnↄku ì. ");
INSERT INTO bus_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","À gbɛra à kɛ̀ wɛ̃̀ wàa siigↄ̃ à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄo. ");
INSERT INTO bus_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Kɛ̀ à kà wɛ̃̀ wàa siigↄ̃ kpɛ́ basↄraagↄ̃ awɛɛplaa, ben à gà. ");
INSERT INTO bus_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ɛnↄku wɛ̃̀ baaagↄ̃ asↄↄrodee guun à Mɛtusela ì. ");
INSERT INTO bus_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","À gbɛra à táa ò kↄ̃n Ludao ai wɛ̃̀ wàa do kpɛ́ basↄↄro à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄo. ");
INSERT INTO bus_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","À kà wɛ̃̀ wàa do kpɛ́ basↄraagↄ̃ asↄↄro. ");
INSERT INTO bus_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","À táa ò kↄ̃n Ludao, ben wà kòrazi, kɛ̀ Luda à sɛ̀ bↄna anduna guu yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mɛtusela wɛ̃̀ bakɛ̃ndo awɛɛswɛɛplaadee guun à Lamɛki ì. ");
INSERT INTO bus_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","À gbɛra à kɛ̀ wɛ̃̀ wàa aagↄ̃ kpɛ́ bakɛ̃ndo awɛɛplaa à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄo. ");
INSERT INTO bus_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Kɛ̀ à kà wɛ̃̀ wàa siigↄ̃ kpɛ́ basↄraagↄ̃ akuri dosai, ben à gà. ");
INSERT INTO bus_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamɛki kɛ̀ wɛ̃̀ bakɛ̃ndo awɛɛplaa, ben à nɛ́gↄ̃gbɛ̃ ì. ");
INSERT INTO bus_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","À tↄ́ kpànɛ Nuu à bè: Gbɛ̃ beee bé eé wa làakari kpáɛwe zĩ gbãaa kɛ̀ wée kɛ yãnzi. Wée zĩ gbãaa pì kɛɛ Dii láarikɛna tↄↄtɛnɛ yãnzimɛ. ");
INSERT INTO bus_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nuu ina gbɛra Lamɛki kɛ̀ wɛ̃̀ wàa aagↄ̃ sↄↄrosai à nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄo. ");
INSERT INTO bus_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Kɛ̀ à kà wɛ̃̀ wàa aagↄ̃ kpɛ́ basↄraagↄ̃ akuri awɛɛswɛɛplaa, ben à gà. ");
INSERT INTO bus_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Kɛ̀ Nuu kà wɛ̃̀ wàa plaa kpɛ́ basↄↄro, à Sɛmu kↄ̃n Hamuo kↄ̃n Yafɛtio ì. ");
INSERT INTO bus_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Kɛ gbɛ̃nteenↄ nà parikũnaa aↄ̃ↄe daagula aↄ̃ↄe nɛ́nↄgbɛ̃nↄ ii, ");
INSERT INTO bus_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ben Luda nɛ́nↄↄ è gbɛ̃ntee nɛ́nↄgbɛ̃ pìnↄↄ maa, ben aↄ̃ↄe ń sɛɛ ń pↄyezia. ");
INSERT INTO bus_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ben Dii bè: Ma Ninii égↄ̃ kú gbɛ̃nteenↄ guu gurↄ píngiro, zaakɛ mɛ̀baadeemɛ. À gurↄↄnↄ égↄ̃ wɛ̃̀ baswɛɛdo. ");
INSERT INTO bus_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Gbɛ̃ gbã̀anↄↄ kú anduna guu gurↄ beeea kↄ̃n gurↄ beee gbɛraao dↄ, gurↄↄ kɛ̀ Luda nɛ́ pìnↄ gbɛ̃ntee nɛ́nↄgbɛ̃nↄ dↄ̃̀ nↄgbɛ̃nↄ ũ, ben aↄ̃ nɛ́nↄ ìńyo. Aↄ̃ nɛ́ pìnↄn gↄ̃sagbãaa kɛ̀ aↄ̃ tↄ́ bↄ̀ zaa káakunↄ ũ. ");
INSERT INTO bus_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Dii è kɛ̀ gbɛ̃nteenↄ yã zaa kɛna bíta anduna guu. Gurↄ píngi yã zaa laasuun aↄ̃ègↄ̃ lɛɛ ado, ");
INSERT INTO bus_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ben à nↄ̀sɛ yàka gbɛ̃ntee kɛ̀ à kɛ̀ tↄↄtɛa yã musu. À laasuu pãnde lɛ̀, ");
INSERT INTO bus_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ben à bè: Mɛ́ gbɛ̃ntee kɛ̀ má kɛ̀ tↄↄtɛa waa, gbɛ̃nteenↄ kↄ̃n nↄ̀bↄnↄ kↄ̃n pↄ́taa'onkusɛanↄ kↄ̃n bãanↄo, zaakɛ ma nↄ̀sɛ yàka ń kɛna yã musu. ");
INSERT INTO bus_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Mↄde Nuu Dii pↄnnaa è. ");
INSERT INTO bus_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nuu boriinↄ yãn yɛ̀. Nuu nɛ́ gbɛ̃ maaamɛ. Kɛ̀ à kuu, à mɛ̀n doo bé à taari vĩro, à táa ò kↄ̃n Ludao. ");
INSERT INTO bus_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuu nɛ́gↄ̃gbɛ̃nↄ ì gↄ̃ↄn aagↄ̃, Sɛmu kↄ̃n Hamuo kↄ̃n Yafɛtio. ");
INSERT INTO bus_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ludaa è anduna gbɛ̃nↄ yàka ń píngi, taarikɛna anduna pà. ");
INSERT INTO bus_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Kɛ̀ Luda anduna gwà, à è à yàka, zaakɛ gbɛ̃ sãnda píngi kɛ̃̀ ń zɛ́a. ");
INSERT INTO bus_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ben Luda bè Nuunɛ: Mɛ́ gbɛ̃ sãnda píngi kaatɛ, zaakɛ aↄ̃ yãnzin taarikɛna dà andunalazi. Mɛ́ ń kaatɛ lɛdo kↄ̃n andunaomɛ. ");
INSERT INTO bus_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ǹ góro'itɛ kɛkɛ kↄ̃n lí lɛ̀ɛtɛgɛo ǹ kpɛ́nɛnↄ kɛ à guu ǹ kↄntaa kɛa à guu kↄ̃n à kpɛɛo. ");
INSERT INTO bus_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Nɛ́ góro pì kɛ lán kɛ̀ bà. À gbã̀aa gã̀sãsuu wàa do kpɛ́ basↄↄro, à yàasa gã̀sãsuu baplaa akuri, à lezĩ sↄ̃ gã̀sãsuu baaakuri. ");
INSERT INTO bus_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ǹ góro pì musu pápa, gbasa ǹ guforoo tótó à dagura gwe gã̀sãsuu doodo zaa à musu kpa. Ǹ gbà da góro pì kpado ǹ góro pì kɛ didikↄ̃ana lɛo aagↄ̃. ");
INSERT INTO bus_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Mapi sↄ̃ mɛ́ tó í da andunala lɛ mà pↄ́ wɛ̃̀ndidee kɛ̀ aↄ̃è wesa bonↄ kaatɛ ń píngi. Pↄ́ kɛ̀ aↄ̃ↄ kú anduna guunↄ é gaga píngi. ");
INSERT INTO bus_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mↄde ma bà égↄ̃ kúnyo. Nɛ́ gɛ̃ góro pì guu kↄ̃n n nɛ́gↄ̃gbɛ̃nↄ kↄ̃n n naↄ̃o kↄ̃n n nɛ́nↄ naↄ̃ↄnↄo. ");
INSERT INTO bus_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Nɛ́ pↄ́ wɛ̃̀ndide píngi sɛ́ ǹ gɛ̃ńyo mɛ̀n plaplaa lɛ aↄ̃égↄ̃ kú wɛ̃̀ndio. ");
INSERT INTO bus_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Bã boriinↄ kↄ̃n nↄ̀bↄ boriinↄ kↄ̃n pↄ́taa'onkusɛa boriinↄ píngi aↄ̃é mↄ́ n kiia mɛ̀n plaplaa lɛ wàgↄ̃ kuu. ");
INSERT INTO bus_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ǹ pↄ́blee kɛ̀ wè ble píngi sɛ́ɛ ǹ kakↄ̃a a kũsãɛ ũ, apinↄ kↄ̃n pↄ́ pìnↄ. ");
INSERT INTO bus_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ben Nuu kɛ̀ lɛ à yã kɛ̀ Ludaa ònɛ kɛ̀ píngi. ");
INSERT INTO bus_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ben Dii bè Nuunɛ: Ǹ gɛ̃ góro guu kↄ̃n n bɛdeenↄ, zaakɛ ḿbe ma n e yãnnadee ũ tↄ̃ↄrigbɛ̃nↄ tɛ́. ");
INSERT INTO bus_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ǹ nↄ̀bↄ kɛ̀ dɛ sa'opↄ ũunↄ sɛ́ ǹ gɛ̃ńyo da kↄ̃n à kyào mɛ̀n swɛɛplaplaa, ǹ nↄ̀bↄ kɛ̀ wè sa ooroonↄ sɛ́ mɛ̀n plaplaa da kↄ̃n à kyào. ");
INSERT INTO bus_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ǹ bãanↄ sɛ́ ǹ gɛ̃ńyo dↄ da kↄ̃n à kyào mɛ̀n swɛɛplaplaa lɛ ń boriinↄ gↄ̃ kú anduna gu píngia. ");
INSERT INTO bus_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Zaakɛ gurↄ swɛɛplaaa gbɛra mɛ́ tó lou ma tↄↄtɛa ai gurↄ baplaa fãantɛ̃ kↄ̃n gwãavĩo, lɛ mà pↄ́ wɛ̃̀ndidee kɛ̀ má kɛ̀nↄ waa tↄↄtɛa píngi. ");
INSERT INTO bus_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nuu yã kɛ̀ Dii ònɛ kɛ̀ píngi. ");
INSERT INTO bus_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Gurↄↄ kɛ̀ í dà andunala, Nuu kuu wɛ̃̀ wàa aagↄ̃mɛ. ");
INSERT INTO bus_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","À gɛ̃̀ góro'itɛ guu kↄ̃n a nɛ́nↄ kↄ̃n a naↄ̃o kↄ̃n a nɛ́nↄ naↄ̃ↄnↄo lɛ aↄ̃ bↄ í pì yãn. ");
INSERT INTO bus_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ben nↄ̀bↄ kɛ̀ dɛ sa'opↄ ũunↄ kↄ̃n nↄ̀bↄ kɛ̀ wè saa ooroonↄ kↄ̃n bãanↄ kↄ̃n pↄ́taa'onkusɛanↄ ");
INSERT INTO bus_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","mↄ̀ Nuu kiia góro guu mɛ̀n plaplaa da kↄ̃n à kyào lán Ludaa ònɛ nà. ");
INSERT INTO bus_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Gurↄ swɛɛplaaa gbɛra í daa pì dà andunala. ");
INSERT INTO bus_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nuu wɛ̃̀ wàa aagↄ̃dee guu à mↄ plaade gurↄ gɛ̃ro awɛɛplaadee zĩ, ben í kɛ̀ kú tↄↄtɛ gĩzĩnↄ pũ̀tã píngi, ben ludambɛ fòonↄ fↄ̃̀. ");
INSERT INTO bus_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Lou mà ai gurↄ baplaa fãantɛ̃ kↄ̃n gwãavĩo. ");
INSERT INTO bus_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Zĩ beeean Nuu gɛ̃̀ góro guu kↄ̃n a nɛ́nↄ Sɛmu kↄ̃n Hamuo kↄ̃n Yafɛtio kↄ̃n api naↄ̃o kↄ̃n a nɛ́nↄ naↄ̃ↄnↄ gↄ̃ↄn aagↄ̃, ");
INSERT INTO bus_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","kↄ̃n nↄ̀bↄsɛ̃tɛnↄ píngi ń boriia kↄ̃n pↄ́kãdeenↄ píngi ń boriia kↄ̃n pↄ́taa'onkusɛanↄ píngi ń boriia kↄ̃n pↄ́ vĩananↄ píngi ń boriia, bãanↄ kↄ̃n pↄ́ dɛ̀bɛdeenↄ píngi. ");
INSERT INTO bus_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Pↄ́ kɛ̀ aↄ̃è wesaa bonↄ mↄ̀ Nuu kiia góro guu bori kↄ̃n boriio mɛ̀n plaplaa. ");
INSERT INTO bus_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Pↄ́ wɛ̃̀ndideenↄ bori píngi gɛ̃̀ da kↄ̃n à kyào lán Ludaa dìɛnɛ nà. Ben Dii gbà tàtańlɛ. ");
INSERT INTO bus_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Lou mà ai gurↄ baplaa. Kɛ̀ í e kaara, ben à góro pì sɛ̀ tↄↄtɛla. ");
INSERT INTO bus_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Í fɛ̀ɛ à kàara maamaa à dà tↄↄtɛla, ben góro pì fù íla. ");
INSERT INTO bus_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Í kàara à dà tↄↄtɛla láe à dà kpii lezĩ kɛ̀ kú anduna guunↄla míↄmiↄ. ");
INSERT INTO bus_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Í fɛ̀ɛ à dà kpiii pìnↄla ai gã̀sãsuu gɛ̃ro. ");
INSERT INTO bus_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Pↄ́ wɛ̃̀ndidee kɛ̀ aↄ̃è táa o tↄↄtɛanↄ gàga píngi, bãanↄ kↄ̃n pↄ́kãdeenↄ kↄ̃n nↄ̀bↄsɛ̃tɛnↄ kↄ̃n pↄ́taa'onkusɛanↄ kↄ̃n gbɛ̃nteenↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Pↄ́ kɛ̀ aↄ̃è wesaa boo kɛ̀ aↄ̃ↄ kú sĩ̀sĩaanↄ gàga píngi. ");
INSERT INTO bus_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Luda pↄ́ wɛ̃̀ndidee kɛ̀ aↄ̃ↄ kú sĩ̀sĩaanↄ kàatɛ píngi. À gbɛ̃nteenↄ kↄ̃n nↄ̀bↄnↄ kↄ̃n pↄ́taa'onkusɛanↄ kↄ̃n bãanↄ kàatɛ anduna guu. Nuu bé à bↄ̀ ado kↄ̃n pↄ́ kɛ̀ aↄ̃ↄ kúo góro guunↄ. ");
INSERT INTO bus_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ben í gↄ̃̀ da andunala ai gurↄ baswɛɛplaa akuri. ");
INSERT INTO bus_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Nuu kↄ̃n nↄ̀bↄsɛ̃tɛnↄ kↄ̃n pↄ́kãdee kɛ̀ aↄ̃ↄ kúo góro guunↄ píngi yã dↄ̀ Ludan. Kɛ̀ à ĩa gbàrɛ tↄↄtɛa, ben í nà babanaa. ");
INSERT INTO bus_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Í kɛ̀ kú tↄↄtɛ gĩzĩnↄ kↄ̃n ludambɛ fòonↄ tàta, ben lou kɛ̃̀. ");
INSERT INTO bus_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Í pì e babaa busɛbusɛ èe lagoo ai gurↄ baswɛɛplaa akuri. ");
INSERT INTO bus_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","À mↄ swɛɛplaade gurↄ gɛ̃ro awɛɛplaadee zĩ góro pì dì kpiii kɛ̀ wè be Ararataa. ");
INSERT INTO bus_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Í pì e lagoo ai mↄ kuridee guu. Mↄ kuridee pì gurↄ káaku zĩ kpiiinↄ mìsↄ̃ntɛ̃nↄ bↄ̀bↄ. ");
INSERT INTO bus_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Gurↄ baplaa gbɛra Nuu góro windo kɛ̀ à bↄ̀ yãa wɛ̃̀, ");
INSERT INTO bus_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ben à bã kãnkãna gbàrɛ. Èe vĩaa èe gaa èe suu ai í bàba tↄↄtɛa. ");
INSERT INTO bus_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","À pↄ̃tɛ̃ɛ gbàrɛ dↄ lɛ à e à dↄ̃ tó í làgo tↄↄtɛa. ");
INSERT INTO bus_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Kɛ̀ pↄ̃tɛ̃ɛ e zↄ̃kii ero, ben a lìara à sù Nuu kiia góro guu, zaakɛ í da andunala píngimɛ. Nuu ↄↄ bↄ̀ à kũ̀ à gɛ̃̀o góro guu. ");
INSERT INTO bus_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","À kámma bò ai gurↄ swɛɛplaa, ben à ɛ̀ara à pↄ̃tɛ̃ɛ gbàrɛ dↄ. ");
INSERT INTO bus_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Pↄ̃tɛ̃ɛ pì lìara à sù à kiia uusiɛ à kù lá kàso à kpá a lɛ́zĩ. Ben Nuu dↄ̃ kɛ í làgo tↄↄtɛa. ");
INSERT INTO bus_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","À kámma bò gurↄ swɛɛplaa dↄ, ben à ɛ̀ara à pↄ̃tɛ̃ɛ pì gbàrɛ, èe liara à sù à kiia dↄro. ");
INSERT INTO bus_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nuu wɛ̃̀ wàa aagↄ̃ awɛɛdodee guu à mↄ káaku gurↄ káaku zĩ, í bàba tↄↄtɛa, ben à góro pì musu gò. Kɛ̀ à guu gwà, à è í yã̀a tↄↄtɛa. ");
INSERT INTO bus_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","À mↄ plaade gurↄ baaasↄↄro awɛɛplaadee zĩ í bàba tↄↄtɛa. ");
INSERT INTO bus_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ben Luda yã ò Nuunɛ à bè: ");
INSERT INTO bus_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Ǹ bↄ góro guu kↄ̃n n naↄ̃o kↄ̃n n nɛ́gↄ̃gbɛ̃nↄ kↄ̃n ń naↄ̃ↄnↄo. ");
INSERT INTO bus_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ǹ pↄ́ wɛ̃̀ndidee kɛ̀ aↄ̃ↄ kúnyonↄ bↄɛ píngi, bãanↄ kↄ̃n nↄ̀bↄnↄ kↄ̃n pↄ́taa'onkusɛanↄ píngi, lɛ aↄ̃ fãakↄ̃a tↄↄtɛa aↄ̃gↄ̃ nɛ́ ii aↄ̃gↄ̃ kaara anduna guu. ");
INSERT INTO bus_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ben Nuu bↄ̀ kↄ̃n a nɛ́nↄ kↄ̃n a naↄ̃o kↄ̃n a nɛ́ pìnↄ naↄ̃ↄnↄo. ");
INSERT INTO bus_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Nↄ̀bↄnↄ píngi kↄ̃n pↄ́taa'onkusɛanↄ píngi kↄ̃n bãanↄ píngi kↄ̃n pↄ́ kɛ̀ aↄ̃è táa o tↄↄtɛanↄ píngi bↄ̀ɛ góro guu bori kↄ̃n boriio. ");
INSERT INTO bus_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ben Nuu Dii gbãgbãkii bò. À nↄ̀bↄ kↄ̃n bãa kɛ̀ wè saa oonↄ kũ̀, ben à sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ òa. ");
INSERT INTO bus_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Kɛ̀ Dii à gũu mà, à kɛ̀nɛ nna, ben à laasuu lɛ̀ à bè: Mɛ́ ɛara mà láari zĩ tↄↄtɛa gbɛ̃ntee yãnzi dↄro, zaakɛ gbɛ̃ntee laasuu ègↄ̃ zaa zaa à ↄ̀wazikɛgurↄmɛ. Mɛ́ ɛara mà pↄ́ wɛ̃̀ndideenↄ kaatɛ lán má kɛ̀ nà dↄro. ");
INSERT INTO bus_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ai anduna gá àgↄ̃ kuuo pↄ́tↄ̃na kↄ̃n pↄ́kɛkɛnao, ĩa kↄ̃n guwãaao, buusiɛ kↄ̃n kwɛɛo, fãantɛ̃ kↄ̃n gwãavĩo, aↄ̃ ke é yãaro. ");
INSERT INTO bus_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ben Luda aubarika dà Nuun kↄ̃n à nɛ́nↄ à bèńnɛ: Àgↄ̃ nɛ́ ii àgↄ̃ kaara à anduna pa. ");
INSERT INTO bus_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Nↄ̀bↄnↄ kↄ̃n bãanↄ kↄ̃n pↄ́taa'onkusɛanↄ kↄ̃n kpↄ̀nↄ égↄ̃ a vĩa vĩ píngi. Ma ń náare a ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Pↄ́ kɛ̀ aↄ̃è táa oonↄ píngi égↄ̃ dɛ a pↄ́blee ũ. Ma ń kpáawa píngi lán ma blɛɛ kɛ̀ è bↄɛ tↄↄtɛanↄ kpàawa nà yã. ");
INSERT INTO bus_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Mↄde àton nↄ̀bↄ kɛ̀ wèe à kòto kpáro sóro, zaakɛ à arun à wɛ̃̀ndi ũ. ");
INSERT INTO bus_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Mɛ́ a aru kɛ̀ dɛ a wɛ̃̀ndi ũu gɛ̃ɛ boare. Tó nↄ̀bↄ gbɛ̃ dɛ̀ ke tó gbɛ̃ a gbɛ̃daaa dɛ̀, mɛ́ à aru gɛ̃ɛ bonɛ. Mɛ́ gɛ̃ɛ bo gbɛ̃ kɛ̀ à a gbɛ̃daaa dɛ̀a. ");
INSERT INTO bus_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Tó gbɛ̃ a gbɛ̃daaa dɛ̀, weé à dɛ, zaakɛ ma gbɛ̃ntee kɛ̀ ma taka ũmɛ. ");
INSERT INTO bus_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Àgↄ̃ nɛ́ ii àgↄ̃ kaara, à da andunala àgↄ̃ kↄ̃ↄ. ");
INSERT INTO bus_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Luda bè Nuunɛ kↄ̃n à nɛ́nↄ dↄ: ");
INSERT INTO bus_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Ma bà égↄ̃ kúao kↄ̃n a boriinↄ ");
INSERT INTO bus_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","kↄ̃n pↄ́ wɛ̃̀ndidee kɛ̀ aↄ̃ↄ kúao kɛ̀ aↄ̃ bↄ̀ góro guunↄ píngi, bãanↄ kↄ̃n pↄ́kãdeenↄ kↄ̃n nↄ̀bↄsɛ̃tɛnↄ kↄ̃n pↄ́ kɛ̀ aↄ̃ↄ kú tↄↄtɛanↄ píngi. ");
INSERT INTO bus_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ma bà égↄ̃ kúao. Mɛ́ í da andunala mà pↄ́ wɛ̃̀ndideenↄ kaatɛ píngi dↄro. Í é da andunala à à kaatɛ dↄro. ");
INSERT INTO bus_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ben Luda ɛ̀ara à bè: Ma bà égↄ̃ kúao kↄ̃n pↄ́ wɛ̃̀ndidee kɛ̀ aↄ̃ↄ kúaonↄ ai gurↄ píngimɛ. À sèedan yɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Mɛ́ ludambɛfɛ̃ɛdaa bↄ loua ma bà kuuna kↄ̃n andunao sèeda ũ. ");
INSERT INTO bus_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Tó má tò lou sìsi ludambɛfɛ̃ɛdaa bↄ̀a, ");
INSERT INTO bus_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","lán ma bà kúao nà kↄ̃n pↄ́ wɛ̃̀ndide bori píngio, à yã é dↄmagumɛ. Mɛ́ tó í da andunala à pↄ́ wɛ̃̀ndidee kaatɛ píngi dↄro. ");
INSERT INTO bus_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Tó ma ludambɛfɛ̃ɛdaa è loua, ma bà kuuna kↄ̃n pↄ́ wɛ̃̀ndide bori píngio ai gurↄ píngi yã é dↄmagumɛ. ");
INSERT INTO bus_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ben Luda bè Nuunɛ: Ma bà kuuna kↄ̃n pↄ́ wɛ̃̀ndidee kɛ̀ aↄ̃ↄ kú anduna guu píngio sèedan gwe. ");
INSERT INTO bus_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nuu nɛ́ kɛ̀ aↄ̃ bↄ̀ɛ góro guunↄ tↄ́n yɛ̀: Sɛmu, Hamu, Yafɛti. Hamun Kanaa de ũ. ");
INSERT INTO bus_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nuu nɛ́nↄn gwe gↄ̃ↄn aagↄ̃. Aↄ̃ boriinↄ bé wà dàgula anduna guu píngi. ");
INSERT INTO bus_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuu nɛ́ búbarimɛ, ben à geepi líkpɛ bà. ");
INSERT INTO bus_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Kɛ̀ à geepiwɛ̃ɛ mì à kã̀, ben à daɛna bũu a kpɛ́n. ");
INSERT INTO bus_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kɛ̀ Kanaa de Hamu a de bũukɛɛ è, à bↄ̀ à gàa à ò Sɛmunɛ kↄ̃n Yafɛtio. ");
INSERT INTO bus_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ben Sɛmu kↄ̃n Yafɛtio utadaa sɛ̀ aↄ̃ kà ń gã̀n ń plaa aↄ̃ táa ò kↄ̃n kpɛɛo. Ń aɛ dↄna gu pãndea lɛ aↄ̃ton ń de bũukɛɛ ero yãnzi, aↄ̃ gàa wà kù ń de bũukɛɛla. ");
INSERT INTO bus_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Kɛ̀ wɛ̃ɛ kɛ̃̀ Nuua à fɛ̀ɛ, à mà lán a nɛ́ zãa kɛ̀are nà, ");
INSERT INTO bus_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ben à bè: Kanaa égↄ̃ láari pↄ́ ũmɛ, àmbe égↄ̃ a gbɛ̃nↄ zↄ̀ zãa ũ. ");
INSERT INTO bus_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ben à bè: Aubarikadeen Dii, Sɛmu Luda ũ, Kanaanↄ égↄ̃ dɛ Sɛmunↄ zↄ̀nↄ ũ. ");
INSERT INTO bus_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Luda kaarana kɛ Yafɛtinɛ, Yafɛtinↄ ń baka e Sɛmunↄ aubarika guu, Kanaanↄ égↄ̃ dɛ Yafɛtinↄ zↄ̀nↄ ũ. ");
INSERT INTO bus_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Í dana andunalaa gbɛra Nuu kɛ̀ wɛ̃̀ wàa do kpɛ́ baswɛɛplaa akuri. ");
INSERT INTO bus_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","À kɛ̀ wɛ̃̀ wàa siigↄ̃ kpɛ́ baswɛɛplaa akuri, ben à gà. ");
INSERT INTO bus_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nuu nɛ́gↄ̃gbɛ̃nↄ Sɛmu kↄ̃n Hamuo kↄ̃n Yafɛtio kↄ̃n ń nɛ́gↄ̃gbɛ̃ kɛ̀ aↄ̃ ì í dana andunalaa gbɛraanↄ yãn yɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafɛti nɛ́gↄ̃gbɛ̃nↄ tↄ́n yɛ̀: Goma, Magↄgu, Midia, Girisi, Tubala, Mɛsɛki kↄ̃n Tirasao. ");
INSERT INTO bus_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Goma nɛ́gↄ̃gbɛ̃nↄ tↄ́n yɛ̀: Asakɛnaza, Rifa, Tↄgama. ");
INSERT INTO bus_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Girisi nɛ́gↄ̃gbɛ̃nↄ tↄ́n yɛ̀: Ɛlisa, Tasisi, Sipiru, Rodanimu. ");
INSERT INTO bus_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Borii pìnↄ bé wà dàgula ísia gɛɛzi, aↄ̃ kↄ̃ kpàatɛtɛ bùsu kↄ̃n bùsuo bori kↄ̃n boriio danɛdanɛ, baade kↄ̃n a boriyão. ");
INSERT INTO bus_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hamu nɛ́gↄ̃gbɛ̃nↄ tↄ́n yɛ̀: Etiopia, Igipiti, Libia kↄ̃n Kanaao. ");
INSERT INTO bus_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Etiopia nɛ́gↄ̃gbɛ̃nↄ tↄ́n yɛ̀: Sɛba, Avila, Sabata, Raama kↄ̃n Sabatɛkao. Raama nɛ́gↄ̃gbɛ̃nↄn Seba kↄ̃n Dedão ũ. ");
INSERT INTO bus_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Nimlↄdu nɛ́ Etiopia boriimɛ dↄ. Àmbe anduna gbãabitade tↄ́de káaku ũ. ");
INSERT INTO bus_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Tofe sàmɛ Dii aɛzĩ. À yã bé à tò wè be: Lán Nimlↄdu dɛ tofe sà ũ Dii aɛzĩ nà. ");
INSERT INTO bus_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Babilↄnia bùsu kɛ̀ à kí blèa káaku wɛ́tɛdaan Babɛli kↄ̃n Ɛrɛkio kↄ̃n Akadao kↄ̃n Kalanɛo ũ. ");
INSERT INTO bus_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Bↄna gwe à gàa Asiria bùsun, ben à Ninɛva kàɛ kↄ̃n Reobo'io kↄ̃n Kalao ");
INSERT INTO bus_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","kↄ̃n Rɛsɛ̃ kɛ̀ kú Ninɛva dagura kↄ̃n Kalao. Ninɛvan wɛ́tɛda ìsi ũ. ");
INSERT INTO bus_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Igipiti boriinↄn yɛ̀: Ludunↄ, Anamunↄ, Lɛabanↄ, Nafatunↄ, ");
INSERT INTO bus_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patarusinↄ, Kasalunↄ kↄ̃n Kɛrɛtinↄ kɛ̀ Filisitininↄ bↄ̀ ń guunↄo. ");
INSERT INTO bus_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaa daudu Sidↄ̃ boriinↄn yɛ̀: Itinↄ, ");
INSERT INTO bus_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yebusinↄ, Amↄrinↄ, Gigasinↄ, ");
INSERT INTO bus_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Ivinↄ, Akinↄ, Sininↄ, ");
INSERT INTO bus_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Avadanↄ, Zɛmarinↄ kↄ̃n Amatanↄo. Kanaa pìnↄ dàgula zãamɛ. ");
INSERT INTO bus_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Aↄ̃ bùsu lɛ́zɛkiin yɛ̀. Bↄna zaa Sidↄ̃ gana Gera kɛ̀ kú Gaza saɛ ai Sↄdↄmu kↄ̃n Gↄmↄrao kↄ̃n Adamao kↄ̃n Zeboimu kɛ̀ kú Lasa saɛo. ");
INSERT INTO bus_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hamu nɛ́gↄ̃gbɛ̃nↄn gwe bori kↄ̃n boriio bùsu kↄ̃n bùsuo danɛdanɛ, baade kↄ̃n a boriyão. ");
INSERT INTO bus_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yafɛti dãaro Sɛmu borii kɛ̀ dↄ. Àmbe Eberunↄ dezi káaku ũ. ");
INSERT INTO bus_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sɛmu nɛ́gↄ̃gbɛ̃nↄ tↄ́n yɛ̀: Elamu, Asiria, Apasada, Ludu kↄ̃n Aramuo. ");
INSERT INTO bus_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aramu nɛ́gↄ̃gbɛ̃nↄ tↄ́n yɛ̀: Uzu, Hulu, Geta kↄ̃n Mɛsɛkio. ");
INSERT INTO bus_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Apasada bé à Sela ì, ben Sela Eberu ì. ");
INSERT INTO bus_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberu nɛ́gↄ̃gbɛ̃nↄ ì gↄ̃ↄn plaa. À doo tↄ́n Pɛlɛgi, zaakɛ à gurↄↄn wà kɛ̃̀kↄ̃a anduna guu. À dãaro tↄ́n Yↄkↄtã. ");
INSERT INTO bus_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yↄkↄtã nɛ́gↄ̃gbɛ̃nↄ tↄ́n yɛ̀: Alamↄdada, Sɛlɛfi, Azamavɛ, Yera, ");
INSERT INTO bus_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoramu, Uzala, Dikala, ");
INSERT INTO bus_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obala, Abimaɛli, Seba, ");
INSERT INTO bus_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofi, Avila kↄ̃n Yobabuo. Yↄkↄtã nɛ́gↄ̃gbɛ̃nↄn gwe píngi. ");
INSERT INTO bus_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Bↄna Mɛsa gana Sefa kↄ̃n kpiii kɛ̀ kú ↄfãntɛ̃bↄɛ kpaanↄ, àmbe ń bùsu ũ. ");
INSERT INTO bus_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Sɛmu nɛ́gↄ̃gbɛ̃nↄn gwe píngi bori kↄ̃n boriio bùsu kↄ̃n bùsuo danɛdanɛ, baade kↄ̃n a boriyão. ");
INSERT INTO bus_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Nuu nɛ́gↄ̃gbɛ̃nↄ boriinↄn gwe danɛdanɛ bùsu kↄ̃n bùsuo. Aↄ̃ kiian anduna bori píngi bↄ̀n aↄ̃ dàgula í dana andunalaa gbɛra. ");
INSERT INTO bus_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Anduna píngi guu boriyã mɛ̀n doomɛ, yã dↄ̃nkↄ̃n wè o. ");
INSERT INTO bus_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Lán gbɛ̃nↄↄ e sↄ̃ki kpákpaa ↄfãntɛ̃bↄɛ kpa nà, kɛ̀ aↄ̃ kà Babilↄnia bùsu gusararaan, ben aↄ̃ vɛ̃̀ɛ gwe. ");
INSERT INTO bus_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Aↄ̃ bèkↄ̃nɛ: Wà gá wà kúnku bↄ wà kpáta maamaa. Kúnkun ń gbɛ̀ ũ, kↄntaan ń siminti ũ. ");
INSERT INTO bus_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ben aↄ̃ bè: Wà wɛ́tɛdaa káɛ wà kpɛ́didikↄ̃ana bo à mìsↄ̃ntɛ̃ zↄ̃ ludambɛɛa. Wà wa zĩnda tↄ́ bↄ lɛ wàtongↄ̃ fãakↄ̃ana doodo anduna guuro yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ben Dii pìta à wɛ́tɛdaa pì gwà kↄ̃n kpɛ́ lezĩ kɛ̀ gbɛ̃nteenↄ bòo. ");
INSERT INTO bus_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ben à bè: Aↄ̃ píngi ń borii dↄ̃nkↄ̃mɛ, yã dↄ̃nkↄ̃n aↄ̃è o, ben yã kɛ̀ aↄ̃ↄe bↄↄon yɛ̀ↄ́? Yã kɛ̀ aↄ̃ à laasuu lɛ̀ tia sa aↄ̃é kɛmɛ, pↄ́ke é kpáńnɛ à kɛna guu dↄro. ");
INSERT INTO bus_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Wà pita wà gá gwe wà ń yã yãkↄ̃tɛńnɛ lɛ aↄ̃ton kↄ̃ yã ma dↄro. ");
INSERT INTO bus_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ben Dii ń fãakↄ̃a gwe doodo anduna guu píngi, ben aↄ̃ ń wɛ́tɛda kaɛna tò. ");
INSERT INTO bus_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Beee yãnzin wà tↄ́ kpà wɛ́tɛ pìnɛ Babɛli, zaakɛ gwen Dii tò anduna bori píngi yã bↄ̀n. Zaa gwemɛ à ń fãakↄ̃a anduna guu píngi. ");
INSERT INTO bus_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sɛmu boriinↄ yãn yɛ̀. Sɛmu wɛ̃̀ basↄↄrodee guun à Apasada ì ídana andunalaa gbɛra wɛ̃̀ plaa. ");
INSERT INTO bus_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","À gbɛra à kɛ̀ wɛ̃̀ wàa plaa kpɛ́ basↄↄro a nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄo. ");
INSERT INTO bus_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Apasada wɛ̃̀ baaakuri asↄↄrodee guun à Sela ì. ");
INSERT INTO bus_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","À gbɛra à kɛ̀ wɛ̃̀ wàa plaa kↄ̃n aagↄ̃ↄo a nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄo. ");
INSERT INTO bus_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela wɛ̃̀ baaakuridee guun à Eberu ì. ");
INSERT INTO bus_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","À gbɛra à kɛ̀ wɛ̃̀ wàa plaa kↄ̃n aagↄ̃ↄo a nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄo. ");
INSERT INTO bus_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eberu wɛ̃̀ baaakuri awɛɛsiigↄ̃dee guun à Pɛlɛgi ì. ");
INSERT INTO bus_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","À gbɛra à kɛ̀ wɛ̃̀ wàa plaa kↄ̃n baaakurio a nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄo. ");
INSERT INTO bus_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pɛlɛgi wɛ̃̀ baaakuridee guun à Rɛu ì. ");
INSERT INTO bus_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","À gbɛra à kɛ̀ wɛ̃̀ wàa do akuri dosai a nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄo. ");
INSERT INTO bus_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rɛu wɛ̃̀ baaakuri awɛɛplaadee guun à Serugu ì. ");
INSERT INTO bus_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","À gbɛra à kɛ̀ wɛ̃̀ wàa do awɛɛswɛɛplaa a nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄo. ");
INSERT INTO bus_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugu wɛ̃̀ baaakuridee guun à Nao ì. ");
INSERT INTO bus_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","À gbɛra à kɛ̀ wɛ̃̀ wàa do a nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄo. ");
INSERT INTO bus_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nao wɛ̃̀ baaakuri dosaidee guun à Tera ì. ");
INSERT INTO bus_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","À gbɛra à kɛ̀ wɛ̃̀ baswɛɛdo dosai a nɛ́ pãndenↄ ì dↄ gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄo. ");
INSERT INTO bus_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera kɛ̀ wɛ̃̀ baaagↄ̃ akuri, ben à Abramu kↄ̃n Nao kↄ̃n Aranao ì. ");
INSERT INTO bus_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tera boriinↄ yãn yɛ̀. Tera Abramu kↄ̃n Nao kↄ̃n Aranao ì, ben Arana Lutu ì. ");
INSERT INTO bus_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Arana gà a de Tera wáa zaa Urumɛ Kaladia bùsun, guu kɛ̀ wà à ìn. ");
INSERT INTO bus_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abramu kↄ̃n Nao nↄↄ sɛ̀. Abramu naↄ̃ tↄ́n Sarai, Nao naↄ̃ sↄ̃ tↄ́n Milika, Arana nɛ́. Arana pì bé à Isika ì dↄ. ");
INSERT INTO bus_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai sↄ̃ pãaamɛ, èe nɛ́ iro. ");
INSERT INTO bus_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ben Tera a nɛ́ Abramu kↄ̃n a dio Lutuo kↄ̃n Abramu naↄ̃ Saraio sɛ̀ bↄna Uru, Kaladia bùsun, aↄ̃ↄe gaa Kanaa bùsun. Kɛ̀ aↄ̃ kà Arana, aↄ̃ vɛ̃̀ɛ gwe. ");
INSERT INTO bus_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera wɛ̃̀ wàa do asↄↄrodee guun à gà zaa Arana. ");
INSERT INTO bus_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Dii bè Abramunɛ: Ǹ bↄ n bùsun n danɛnↄ tɛ́ n de bɛ, ǹ tá bùsu kɛ̀ mɛ́ ↄdↄannɛɛn. ");
INSERT INTO bus_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Mɛ́ tó n borii kɛ pari, mɛ́ aubarika dangu mà n tↄ́ bↄ, n kiian weégae aubarika en. ");
INSERT INTO bus_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mɛ́ aubarika da gbɛ̃ kɛ̀ aↄ̃é sa maaa onnɛɛnↄn, mɛ́ gbɛ̃ kɛ̀ aↄ̃é sa zaaa onnɛɛnↄ ká. Anduna bori píngi é aubarika e n gãzĩ. ");
INSERT INTO bus_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ben Abramu dà zɛ́n lán Dii ònɛ nà. Lutu gàao. À wɛ̃̀ basiigↄ̃ sↄↄrosaidee guun à bↄ̀ Arana ");
INSERT INTO bus_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","kↄ̃n a naↄ̃ Saraio kↄ̃n a vĩ̀i nɛ́ Lutuo kↄ̃n ń auziki kɛ̀ aↄ̃ↄ vĩinↄ kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ sɛ̀ gweenↄ. Lɛn aↄ̃ bↄ̀ Arana lɛ aↄ̃ dà Kanaa zɛ́n. Kɛ̀ aↄ̃ kà gwe, ");
INSERT INTO bus_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ben aↄ̃ bↄ̀ɛ bùsu pìn ai aↄ̃ kà Mↄre gbíi lí kiia Sɛkɛmu. Kanaanↄↄ kú bùsu pìn gurↄ beeea. ");
INSERT INTO bus_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ben Dii bↄ̀ à mↄ̀ Abramuzi à bè: Mɛ́ bùsu kɛ̀kii kpá n boriinↄamɛ. Ben à Dii gbãgbãkii bò gwe. ");
INSERT INTO bus_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Kɛ̀ à fɛ̀ɛ gwe, à mì pɛ̀ kpiii kɛ̀ kú Bɛtɛli ↄfãntɛ̃bↄɛ kpaanↄa, ben à bùra kàɛ gwe, Bɛtɛli kú ↄfãntɛ̃gɛ̃kpɛn kpa, Ai kú ↄfãntɛ̃bↄɛ kpa. À Dii gbãgbãkii bò gwe dↄ, ben à à sìsi. ");
INSERT INTO bus_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ben à dà zɛ́n dↄ à mì pɛ̀ Nɛgɛvia. ");
INSERT INTO bus_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kɛ̀ dekaa kà bùsu pìn, ben Abramu gàa gurↄ plaaa kɛ Igipiti, zaakɛ dekaa pì gɛ̃̀ ↄla. ");
INSERT INTO bus_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Kɛ̀ à kà kĩi kↄ̃n Igipitio, à bè a naↄ̃nɛ: Má dↄ̃ nↄ maan n ũ. ");
INSERT INTO bus_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Tó Igipitinↄ n e, aↄ̃é be ma naↄ̃n n ũ, aↄ̃é ma dɛ aↄ̃é n tó. ");
INSERT INTO bus_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ǹ beńnɛ ma dãremɛ n ũ lɛ wà ma sí ↄplaplaa n yãnzi. Lán nɛ́ ma mì sí nàn gwe. ");
INSERT INTO bus_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Kɛ̀ aↄ̃ kà Igipiti, Igipitinↄↄ è nↄgbɛ̃ pì maaa gɛ̃̀. ");
INSERT INTO bus_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Kɛ̀ Igipiti kí Fili'auna ìbanↄ à è, aↄ̃ à maaa gↄ̃̀gↄ̃nɛ, ben wà à sɛ̀ wà gɛ̃̀o Fili'aunanɛ a bɛ. ");
INSERT INTO bus_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ben à Abramu gwà maamaa à yãnzi, à sãanↄ kpàa kↄ̃n zùnↄ kↄ̃n zaakinↄ kↄ̃n gↄ̃gbɛ̃ zĩkɛrinↄ kↄ̃n nↄgbɛ̃ zĩkɛrinↄ kↄ̃n lakuminↄo. ");
INSERT INTO bus_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ben Dii gyã pãsĩnↄ kà Fili'aunan kↄ̃n a bɛdeenↄ Abramu naↄ̃ pì yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ben Fili'auna Abramu sìsi à bènɛ: Bↄ́ yã ń kɛ̀mɛ gwee? Bↄ́yãnzi nɛ́ɛ omɛ kɛ̀ n naↄ̃nloo? ");
INSERT INTO bus_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","À kɛ̀ dia n bè n dãremɛ, ben ma à sɛ̀ nↄↄ ũu? N naↄ̃n yɛ̀! Ǹ n pↄ́ sɛ́ ǹ táo. ");
INSERT INTO bus_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Fili'auna yã ò a gbɛ̃nↄnɛ Abramu yã musu, ben aↄ̃ gàa wà zɛ̀nɛ kↄ̃n a naↄ̃o kↄ̃n a auzikinↄ píngi. ");
INSERT INTO bus_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ben Abramu bↄ̀ Igipiti à sù Nɛgɛvi kↄ̃n a naↄ̃o kↄ̃n a auzikinↄ píngi kↄ̃n Lutuo. ");
INSERT INTO bus_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abramu nɛ́ auzikideemɛ, à pↄ́kãdeenↄ vĩ pari kↄ̃n kondogio kↄ̃n vurao. ");
INSERT INTO bus_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Bↄna Nɛgɛvi à sↄ̃ki kpàkpa ai à gàa à kào Bɛtɛli, guu kɛ̀ à bùra kàɛn káaku Bɛtɛli dagura kↄ̃n Aio, ");
INSERT INTO bus_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","guu kɛ̀ à sa'okii bòn yã. Ben à Dii sìsi gwe. ");
INSERT INTO bus_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lutu ègↄ̃ tɛ́ kↄ̃n Abramuo lɛdo. À sãanↄ kↄ̃n zùnↄ kↄ̃n bisakutaanↄ vĩ se. ");
INSERT INTO bus_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Aↄ̃ pↄ́kãdeenↄↄ pari, guu pì sɛ̃̀ e mↄ́ḿma ń píngiro. Beee yãnzin aↄ̃é fↄ̃ wàgↄ̃ kú gu dↄ̃nkↄ̃a lɛdo dↄro. ");
INSERT INTO bus_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ben lɛokpakↄ̃a gɛ̃̀ Abramu pↄ́dãrinↄ kↄ̃n Lutu pↄ́dãrinↄ dagura. Zĩ beeea sↄ̃ Kanaanↄ kↄ̃n Pɛrizinↄↄ kú bùsu pìn. ");
INSERT INTO bus_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ben Abramu bè Lutunɛ: À maa lɛokpakↄ̃a gↄ̃ kú wa daguraro, ke ma pↄ́dãrinↄ kↄ̃n n pↄ́dãrinↄ dagura, zaakɛ danɛnↄn wa ũ. ");
INSERT INTO bus_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ǹ bùsu gwa da n aɛ píngi. Wà kɛ̃kↄ̃a. Tó n gaa ↄzɛzi, mɛ́ gá ↄplazi. Tó n gaa ↄplazimɛ sↄ̃, mɛ́ gá ↄzɛzi. ");
INSERT INTO bus_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Kɛ Lutu guu gwà, à è Yoda guzurɛ píngi mↄdↄ vĩ maamaa. Ai Dii gↄ̃ gá Sↄdↄmu kↄ̃n Gↄmↄrao kaatɛ, guzurɛ pì dɛ lán Dii swadako bà, lán Igipiti bùsu bà, ai à gàa pɛ́ Zoaa. ");
INSERT INTO bus_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ben Lutu Yoda guzurɛ sɛ̀ píngi. Aↄ̃ kɛ̃̀kↄ̃a, ben Lutu dà zɛ́n à tà ↄfãntɛ̃bↄɛ kpa. ");
INSERT INTO bus_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abramu gↄ̃̀ Kanaa bùsun, Lutu sↄ̃ↄ kú Yoda guzurɛ wɛ́tɛnↄ dagura. À bùra kàɛ Sↄdↄmu saɛ. ");
INSERT INTO bus_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sↄdↄmudeenↄ sↄ̃ↄ zaa, durunkɛri sànↄn ń ũ Dii aɛzĩ. ");
INSERT INTO bus_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lutu tana gbɛra Dii bè Abramunɛ: Guu kɛ̀ ń zɛ́n ǹ wɛ́ɛ sɛ́ ǹ gu'igbãro kↄ̃n sↄↄmɛtɛo kↄ̃n ↄfãntɛ̃bↄɛo kↄ̃n ↄfãntɛ̃gɛ̃kpɛn-o gwa. ");
INSERT INTO bus_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Tↄↄtɛ kɛ̀ ń è píngi, má kpàmma, eégↄ̃ dɛ mpi kↄ̃n n boriinↄ pↄ́ ũ ai gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Mɛ́ tó n boriinↄ kɛ pari lán bùsu'ãatɛ̃ bà. Tó gbɛ̃ke é fↄ̃ à bùsu'ãatɛ̃ naro, ɛ̃ndɛ̃ eé fↄ̃ à n boriinↄ naro. ");
INSERT INTO bus_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ǹ fɛɛ ǹ liga bùsu pìzi ǹ à gbã̀a kↄ̃n à yàasao gwa, zaakɛ má kpàmmamɛ. ");
INSERT INTO bus_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abramu fɛ̀ɛ à gàa à vɛ̃̀ɛ Mamare gbíi lí kɛ̀ kú Ɛblↄnunↄ saɛ, ben à Dii gbãgbãkii bò gwe. ");
INSERT INTO bus_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Zĩkea Babilↄnia bùsu kí Amarafɛli kↄ̃n Ɛlasa bùsu kí Ariↄkio kↄ̃n Elamu bùsu kí Kɛdↄlaomao kↄ̃n Goyimu bùsu kí Tidalao ");
INSERT INTO bus_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","e zĩ̀ kaa kↄ̃n Sↄdↄmu kí Bɛrao kↄ̃n Gↄmↄra kí Bisao kↄ̃n Adama kí Sinabuo kↄ̃n Zeboimu kí Sɛmɛbao kↄ̃n Bɛla kɛ̀ wè be tia Zoa kínao. ");
INSERT INTO bus_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Kí gↄ̃ↄn sↄↄroo pìnↄ kↄ̃ kàkↄ̃a ń píngi Sidimu guzurɛn. Àmbe sɛ̀bɛ wisidee ũ tia. ");
INSERT INTO bus_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Wɛ̃̀ kuri awɛɛplaaa dagura aↄ̃ègↄ̃ tángba kpaa Kɛdↄlaomaa. À wɛ̃̀ kuri awɛɛ'aagↄ̃dee guun aↄ̃ gì bↄnɛzi. ");
INSERT INTO bus_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","À wɛ̃̀ gɛ̃ro dosaidee guun Kɛdↄlaoma kↄ̃n kína kɛ̀ aↄ̃ↄ kúonↄ mↄ̀ wà zĩ̀ blè Rɛfaimunↄa zaa Asɛtɛro Kanaimu, aↄ̃ zĩ̀ blè Zuzinↄa zaa Hamu, aↄ̃ zĩ̀ blè Ɛminↄa zaa Save Kiriataimu, ");
INSERT INTO bus_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","aↄ̃ zĩ̀ blè Orinↄa ń kpiii kɛ̀ wè be Seia ai à gàa pɛ́ Ɛli Parana gbáaa. ");
INSERT INTO bus_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ben aↄ̃ lìara wà sù Ɛmisipa. Àmbe wè be tia Kadɛsi. Aↄ̃ zĩ̀ blè Amalɛki bùsua píngi kↄ̃n Amↄri borii kɛ̀ aↄ̃ↄ kú Azazↄ̃tamanↄa dↄ. ");
INSERT INTO bus_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ben Sↄdↄmu kína kↄ̃n Gↄmↄra kínao kↄ̃n Adama kínao kↄ̃n Zeboimu kínao kↄ̃n Bɛla kɛ̀ wè be tia Zoa kínao fɛ̀ɛ wà gàa wà zĩ̀ káńyo Sidimu guzurɛn. ");
INSERT INTO bus_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Aↄ̃ↄe zĩ̀ kaa kↄ̃n Elamu bùsu kínao kↄ̃n Goyimu bùsu kínao kↄ̃n Babilↄnia bùsu kínao kↄ̃n Ɛlasa bùsu kínao. Kí gↄ̃ↄn siigↄ̃ↄ pìnↄↄ e zĩ̀ kaa kↄ̃n kí gↄ̃ↄn sↄↄroonↄ. ");
INSERT INTO bus_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Sidimu guzurɛ kↄntaa wɛ̀ɛ vĩ pari. Kɛ̀ Sↄdↄmu kína kↄ̃n Gↄmↄra kínao e bàa lɛɛ, ben aↄ̃ sì à guu, ben ń gbɛ̃ kpaaanↄ bàa lɛ̀ wà gàa gusĩsĩdeen. ");
INSERT INTO bus_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Zĩ̀blerinↄ Sↄdↄmu kↄ̃n Gↄmↄrao auzikinↄ kↄ̃n ń pↄ́bleenↄ sɛ̀ɛ píngi aↄ̃ tào. ");
INSERT INTO bus_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Gurↄↄ mↄ̀a Abramu vĩ̀i nɛ́ Lutu kú Sↄdↄmu, ben aↄ̃ à kũ̀ wà tào kↄ̃n à auzikinↄ. ");
INSERT INTO bus_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ben gbɛ̃ kɛ̀ bↄ̀ ń ↄzĩ gàa à ò Eberu bori Abramunɛ zaa Mamare gbíi línↄ saɛ. Mamare kↄ̃n a dãaronↄ Ɛsɛkↄlu kↄ̃n Anɛo nɛ́ Amↄri boriinↄmɛ, aↄ̃ↄ dɛ kↄ̃ gbɛ̃ ũ kↄ̃n Abramuo. ");
INSERT INTO bus_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Kɛ̀ Abramu mà wà a danɛ kũ̀ wà tào, ben à a bɛ zĩ̀karinↄ sɛ̀ɛ gↄ̃ↄn wàa do kpɛ́ baswɛɛdo plaasai à pɛ̀ɛ kína pìnↄzi, ben à ń lé Dani. ");
INSERT INTO bus_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ben à a gbɛ̃nↄ kpàatɛtɛ, ben aↄ̃ sì ń tɛ́ gwãavĩ. Aↄ̃ zĩ̀ blèḿma aↄ̃ pɛ̀ḿma ai Oba, Damasiku gu'igbãroo kpa. ");
INSERT INTO bus_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","À lìara à sù kↄ̃n auziki pìnↄ píngi kↄ̃n a vĩ̀i nɛ́ Lutuo kↄ̃n à auzikinↄ. À sù kↄ̃n nↄgbɛ̃nↄo kↄ̃n gbɛ̃ pãndenↄ dↄ. ");
INSERT INTO bus_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Kɛ̀ Abramu zĩ̀ blè Kɛdↄlaomaa kↄ̃n kína kɛ̀ aↄ̃ↄ kúonↄ èe suu, ben Sↄdↄmu kí bↄ̀ à dààlɛ Save Guzurɛ kɛ̀ wè be tia Kí Guzurɛn. ");
INSERT INTO bus_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ben Salɛmu kí Mɛlɛkizɛdɛki mↄ̀ kↄ̃n burɛdio kↄ̃n geepiwɛ̃ɛo. Àpi nɛ́ Luda Musude gbã̀gbãrimɛ. ");
INSERT INTO bus_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ben à sa maaa ò Abramunɛ à bè: Luda Musude musu kↄ̃n tↄↄtɛo Kɛ̀ri aubarika da Abramun. ");
INSERT INTO bus_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Aubarikadeen Luda Musude kɛ̀ à n ibɛɛnↄ nànnɛ n ↄzĩ ũ. Ben Abramu auziki kɛ̀ èe suunↄ píngi kuridee kpàa. ");
INSERT INTO bus_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sↄdↄmu kína bè Abramunɛ: Ǹ ma gbɛ̃nↄ kpáma ǹgↄ̃ auziki kũna n pↄ́ ũ. ");
INSERT INTO bus_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ben Abramu bènɛ: Má sì kↄ̃n Dii Luda Musude musu kↄ̃n tↄↄtɛo Kɛ̀rio, ");
INSERT INTO bus_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","mɛ́ n pↄ́ke sɛ́ro, baa kyateyĩba, lɛ ǹton be n ma kɛ auzikidee ũro yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Mɛ́ pↄ́ke sɛ́ro, sé pↄ́blee kɛ̀ ma gbɛ̃nↄↄ blè baasiro. Mↄde Anɛ kↄ̃n Ɛsɛkↄluo kↄ̃n Mamare kɛ̀ aↄ̃ gàamaonↄ, ǹ tó aↄ̃ ń baka sɛ́. ");
INSERT INTO bus_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Beee gbɛra Dii yã ò Abramunɛ wɛ́ɛgupu'ena guu à bè: Abramu! Ǹton vĩa kɛro. Mámbe n sɛngbango ũ, n asaia égↄ̃ bíta maamaa. ");
INSERT INTO bus_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ben Abramu bè: Dii Luda, bↄ́n nɛ́ ma gbaa? Má nɛ́ vĩro. Damasiku gbɛ̃ Ɛliɛza bé égↄ̃ dɛ ma bɛ túbibleri ũ. ");
INSERT INTO bus_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Kɛ̀ nɛ́ɛ ma gba nɛ́ro, ma bɛ zĩkɛri pì bé égↄ̃ dɛ ma túbibleri ũ. ");
INSERT INTO bus_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ben Dii bènɛ: Àmbe eégↄ̃ dɛ n túbibleri ũro. Nɛ́ kɛ̀ eé bↄ n plɛ̀n bé eégↄ̃ dɛ n túbibleri ũ. ");
INSERT INTO bus_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ben à bↄ̀o bàazi à bè: Ǹ musu gwa ǹ sↄsↄnɛnↄ naro, tó nɛ́ fↄ̃. Lɛmɛ n boriinↄ égↄ̃ dɛ lɛ. ");
INSERT INTO bus_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","À Dii náanɛ kɛ̀, ben Dii tò yã bↄ̀o nna a náanɛ kɛ̀ à kɛ̀ yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","À bènɛ dↄ: Diin ma ũ, mámbe ma n bↄ Uru, Kaladia bùsun, lɛ mà bùsu kɛ̀kii kpámma yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ben Abramu bè: Dii Luda, dian mɛ́gↄ̃ dↄ̃ kɛ̀ eégↄ̃ dɛ ma pↄ́ ũu? ");
INSERT INTO bus_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","À wèàla à bè: Ǹ zùnunu wɛ̃̀ aagↄ̃ↄ sɛ́ kↄ̃n blè wɛ̃̀ aagↄ̃ↄo kↄ̃n sãkaro wɛ̃̀ aagↄ̃ↄo kↄ̃n pↄ̃tɛ̃ɛtɛ̃ngoo kↄ̃n lukulukuo. ");
INSERT INTO bus_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ben à pↄ́ pìnↄ sɛ̀ à mↄ̀o píngi à pàrapara à gògokↄ̃a, ben à kàɛ à ń aɛ dↄ̀dↄkↄ̃a, mↄde èe bãanↄ parapararo. ");
INSERT INTO bus_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Kɛ̀ yeberekunↄ mↄ̀ wà zↄ̃̀zↄ̃ nↄ̀bↄ pìnↄa, ben Abramu pɛ̀ḿma. ");
INSERT INTO bus_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Kɛ̀ ↄfãntɛ̃ e gɛ̃ɛ kpɛ́n, i bíta Abramu kũ̀, ben gusia bíta vĩadee dààla. ");
INSERT INTO bus_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ben Dii bènɛ: Ǹgↄ̃ dↄ̃ kɛ̀ n boriinↄ égↄ̃ nibↄ blee bùsu kɛ̀ dɛ ń pↄ́ ũroo guu, aↄ̃égↄ̃ zↄ̀ blee gwe, weégↄ̃ wɛ́ɛ tãaḿma ai wɛ̃̀ wàa plaa. ");
INSERT INTO bus_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Mↄde mɛ́ ĩa kɛ borii kɛ̀ aↄ̃ↄe zↄ̀ bleeńnɛnↄa, n boriinↄ é bↄɛ kↄ̃n auziki bítao. ");
INSERT INTO bus_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Mmↄn sↄ̃, nɛ́gↄ̃ aafiamɛ ai ǹ gá zi kũo gbasa ǹ ká n dezinↄla wà n vĩi. ");
INSERT INTO bus_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","N nasionↄ bé weé liara wà su kɛ̀, zaakɛ Amↄrinↄ durun e papa kↄ̀ro. ");
INSERT INTO bus_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Kɛ̀ ↄfãntɛ̃ gɛ̃̀ kpɛ́n, guu sì, ben Abramu è kĩi kɛ̀ èe tɛ́sukpɛ bↄↄ kↄ̃n sɛ̃̀tɛo e gɛ̃ɛ nↄ̀bↄ kɛ̀ à pàrapara pìnↄ dagura. ");
INSERT INTO bus_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Zĩ beeean Dii bè a bà égↄ̃ kú kↄ̃n Abramuo à bè: Mɛ́ bùsu kɛ̀kii kpá n boriinↄa zaa Igipiti gulɛzɛki swaa ai swadaa kɛ̀ wè be Yuflati, ");
INSERT INTO bus_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","bùsu kɛ̀ Keninↄↄ kún kↄ̃n Kenizinↄ kↄ̃n Kadamↄnunↄ ");
INSERT INTO bus_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","kↄ̃n Itinↄ kↄ̃n Pɛrizinↄ kↄ̃n Rɛfaimunↄ ");
INSERT INTO bus_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","kↄ̃n Amↄrinↄ kↄ̃n Kanaanↄ kↄ̃n Gigasinↄ kↄ̃n Yebusinↄo. ");
INSERT INTO bus_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abramu naↄ̃ Sarai e nɛ́ iro. À nↄgbɛ̃ zĩkɛri vĩ Igipiti gbɛ̃ ũ kɛ̀ wè benɛ Agyara. ");
INSERT INTO bus_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ben Sarai bè Abramunɛ: Lán Dii ma kɛ pãaa ũ nà, ǹ daɛ kↄ̃n ma zĩkɛrio. Má sì kɛ̀ mɛ́ nɛ́nↄ e à gãzĩ. Ben Abramu Sarai yã mà. ");
INSERT INTO bus_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Abramu wɛ̃̀ kuri kɛna Kanaa bùsun gbɛran Sarai a zↄ̀ Agyara kpàa nↄↄ ũ. ");
INSERT INTO bus_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abramu dàɛo, ben à nↄ̀ sì. Kɛ̀ à è á nↄ̀sina, à dↄkɛ̀ a diio. ");
INSERT INTO bus_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ben Sarai bè Abramunɛ: Taari kɛ̀ wà kɛ̀mɛɛ gↄ̃̀ n yã ũmɛ. Ma a zↄ̀ kpàmma. Kɛ̀ à è á nↄ̀sina, ben ègↄ̃ dↄkɛɛmao. Mpi kↄ̃n mapio, Dii bé eé yã gↄ̃gↄ̃we. ");
INSERT INTO bus_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ben Abramu wèàla à bè: N zↄ̀ kuu n pↄ́ ũmɛ. Ǹ kɛnɛ lán ń yezi nà. Kɛ̀ Sarai ĩa dàa, ben à bàa lɛ̀nɛ. ");
INSERT INTO bus_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Dii Malaika à è íbↄkiizi gbáan, bia pì kú Suru zɛ́ saɛmɛ. ");
INSERT INTO bus_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ben à à là à bè: Sarai zĩkɛri Agyara, n bↄ mámɛ? Nɛ́ɛ gaa mámɛ? Ben à wèàla à bè: Mɛ́ɛ bàa lɛɛ ma dii Sarainɛmɛ. ");
INSERT INTO bus_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ben Dii Malaika bènɛ: Ǹ ɛara ǹ tá n dii pì kiia ǹgↄ̃ mì siɛɛnɛ. ");
INSERT INTO bus_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Mɛ́ n borii kaara aↄ̃gↄ̃ pari, weé fↄ̃ wà ń lɛ́ dↄ̃ro. ");
INSERT INTO bus_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ń nↄ̀sina, nɛ́ nɛ́ i gↄ̃gbɛ̃ ũ, nɛ́ tↄ́ kpánɛ Sumaila, zaakɛ Dii n yã mà n wɛ́ɛtãmma guu. ");
INSERT INTO bus_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Eégↄ̃ dɛ lán zaakisɛ̃tɛ bà, eé íbɛtɛ kpá kↄ̃n gbɛ̃ píngio, gbɛ̃ píngi é íbɛtɛ kpáo se. Eégↄ̃ kú kↄ̃ yãn kↄ̃n a gbɛ̃nↄro. ");
INSERT INTO bus_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ben Agyara bè: Ma wɛ́ɛ sì Luda kɛ̀ è ma elɛ. Ben à tↄ́ kpà Dii kɛ̀ yã ònɛnɛ Ludakɛema'ee. ");
INSERT INTO bus_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","À yã bé à tò wà tↄ́ kpà lↄ̀gↄ pìnɛ Ludabɛ̃ɛkɛema'ee lↄ̀gↄ. À kú Kadɛsi kↄ̃n Bɛrɛdio daguramɛ. ");
INSERT INTO bus_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Agyara nɛ́gↄ̃gbɛ̃ ì kↄ̃n Abramuo, ben Abramu tↄ́ kpànɛ Sumaila. ");
INSERT INTO bus_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Gurↄↄ kɛ̀ Agyara Sumaila ì, Abramu wɛ̃̀ basiigↄ̃ awɛɛswɛɛdomɛ. ");
INSERT INTO bus_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Kɛ̀ Abramu kà wɛ̃̀ basↄↄro dosai, Dii bↄ̀ à mↄ̀zi à bè: Luda Gbãabitaden ma ũ. Ǹ táa omao ǹgↄ̃ kuu taari sai. ");
INSERT INTO bus_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ma bà kuunanyo égↄ̃ gaa, mɛ́ n borii kaarannɛ maamaa. ");
INSERT INTO bus_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abramu dàɛ a puua Luda aɛ, ben Luda bènɛ: ");
INSERT INTO bus_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Lán ma bà kúnyo nà, nɛ́ gↄ̃ bori pariinↄ dezi ũ. ");
INSERT INTO bus_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Weégae bennɛ Abramu dↄro, sé Ibraĩ, zaakɛ mɛ́ n kɛ bori pariinↄ dezi ũ. ");
INSERT INTO bus_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Mɛ́ tó n bori kɛ pari, boriinↄ kↄ̃n kínanↄ é bↄ n kiia. ");
INSERT INTO bus_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ma bà égↄ̃ kúnyo kↄ̃n n boriinↄ ai gurↄ píngi. Mɛ́gↄ̃ dɛ n Luda ũ kↄ̃n n boriinↄ n gbɛra. ");
INSERT INTO bus_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Mɛ́ Kanaa bùsu kɛ̀ ń kú à guu nibↄ ũ kpámma píngi kↄ̃n n boriinↄ n gbɛra, lɛ aↄ̃gↄ̃ vĩ gurↄ píngi, mɛ́gↄ̃ dɛ ń Luda ũ. ");
INSERT INTO bus_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Luda ɛ̀ara à bè Ibraĩnɛ: Mpi kↄ̃n n boriinↄ, àgↄ̃ ma bà kuunaao yã kũna ai a boriia. ");
INSERT INTO bus_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ma bà kuunaao yã kɛ̀ égↄ̃ kũnan yɛ̀, mpi kↄ̃n n boriinↄ. Séde a gↄ̃gbɛ̃ píngi bã̀ngu kɛ. ");
INSERT INTO bus_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","À bã̀ngu kɛ ma bà kuunaao sèeda ũ. ");
INSERT INTO bus_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Séde n bori nɛ́gↄ̃gbɛ̃nↄ bã̀ngu kɛ ń gurↄ sↄraagↄ̃dee zĩ ai ń boriia, nɛ́ kɛ̀ wà ń í n bɛɛnↄ kↄ̃n zↄ̀ kɛ̀ wà ń lú bori pãndenↄanↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Wà à ì n bɛn yoo kesↄ̃ wà lù zↄ̀ ũn yoo, sé à bã̀ngu kɛ. Beee égↄ̃ dɛ ma bà kuunaao gurↄ píngi sèeda ũ a mɛ̀a. ");
INSERT INTO bus_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Weé gɛfↄↄdee bↄ a gbɛ̃nↄ tɛ́, zaakɛ gbɛ̃ kɛ̀ èe bã̀ngu kɛro yã kɛ̀ má dìɛare kũnaro. ");
INSERT INTO bus_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ben Luda ɛ̀ara à bè Ibraĩnɛ: Ǹton be n naↄ̃nɛ Sarai dↄro, ǹgae benɛ Sara sa. ");
INSERT INTO bus_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mɛ́ aubarika dan mà tó à nɛ́ i gↄ̃gbɛ̃ ũ, eé gↄ̃ boriinↄ dazi ũ, bùsu kínanↄ é bↄ à kiia. ");
INSERT INTO bus_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ben Ibraĩ dàɛ a puua Luda aɛ à yáa dↄ̀ à bè a nↄ̀sɛ guu: Gbɛ̃ kɛ̀ kà wɛ̃̀ basↄↄroo é nɛ́ iↄ́? Lán Sara kà wɛ̃̀ basiigↄ̃ akuri nà, eé nɛ́ iↄ́? ");
INSERT INTO bus_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ben à ɛ̀ara à bè Ludanɛ: Ǹ sùu kɛ ǹ Sumaila gwa. ");
INSERT INTO bus_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Luda bè: Yãpura n naↄ̃ Sara é nɛ́ i gↄ̃gbɛ̃ ũ, nɛ́ tↄ́ kpánɛ Isaaku. Ma bà égↄ̃ kúo kↄ̃n à boriinↄ ai gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Sumaila yã musu, ma n yã mà. Mɛ́ aubarika dan, eé nɛ́ i à kaara maamaa. Eé nɛ́gↄ̃gbɛ̃nↄ i gↄ̃ↄn kuri awɛɛplaa, aↄ̃é gↄ̃ kínanↄ ũ, à borii é kɛ pari. ");
INSERT INTO bus_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Baa kↄ̃n beeeo ma bà kuunanyo é gↄ̃ Isaakuamɛ. Zii mↄndaa'i Sara é à i. ");
INSERT INTO bus_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Kɛ̀ Luda yã ò Ibraĩnɛ à yã̀a, ben à à tò à tà musu. ");
INSERT INTO bus_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ben Ibraĩ a nɛ́ Sumaila sɛ̀ kↄ̃n a bɛ gↄ̃gbɛ̃ kɛ̀ wà ń í a bɛɛnↄ kↄ̃n zↄ̀ kɛ̀ wà ń lúnↄ ń píngi, ben à bã̀ngu kɛ̀ńnɛ zĩ beeea gↄ̃ↄ lán Ludaa ònɛ nà. ");
INSERT INTO bus_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ibraĩ kà wɛ̃̀ basↄↄro dosai, gbasa à bã̀ngu kɛ̀, ");
INSERT INTO bus_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","à nɛ́ Sumaila sↄ̃ wɛ̃̀ kuri awɛɛ'aagↄ̃. ");
INSERT INTO bus_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Gurↄ dↄ̃nkↄ̃ pì zĩ Ibraĩ bã̀ngu kɛ̀ kↄ̃n a nɛ́ Sumailao ");
INSERT INTO bus_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","kↄ̃n a bɛ gↄ̃gbɛ̃ kɛ̀ wà ń í a bɛɛnↄ kↄ̃n zↄ̀ kɛ̀ wà ń lú bori pãndeanↄ ń píngi. Aↄ̃ bã̀ngu kɛ̀ gurↄ dↄ̃nkↄ̃ zĩmɛ. ");
INSERT INTO bus_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Dii bↄ̀ à mↄ̀ Ibraĩzi Mamare gbíi línↄ saɛ. Ibraĩ vɛ̃ɛna a bisakuta kpɛɛlɛ fãantɛ̃. ");
INSERT INTO bus_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Kɛ̀ à wɛ́ɛ sɛ̀ musu, à gↄ̃ↄn aagↄ̃ↄ è zɛna. Kɛ̀ à ń é lɛ, ben à fɛ̀ɛ kpɛɛlɛa kↄ̃n bào à gàa à dàńlɛ à dàɛńnɛ a puua ");
INSERT INTO bus_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","à bè: Dii, tó ma n pↄnnaa è, ǹton gɛ̃ mamↄma n zↄ̀blerilaro. ");
INSERT INTO bus_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Mɛ́ mↄ́are ío à gbá pípi à kámma bo lí gbáru kɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Lán a bↄɛ ma bɛɛ kpa nà, mɛ́ mↄ́are pↄ́bleeo féte lɛ à gbãaa e, gbasa à da zɛ́n. Ben aↄ̃ bè: Tↄ̀, ǹ kɛ lán ń ò nà. ");
INSERT INTO bus_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ben à gàa Sara kiia kutaan à bè: Ǹ flawa kↄ zaka lɛ́ aagↄ̃ ǹ burɛdi kɛ kpakpaa. ");
INSERT INTO bus_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ben à bàa lɛ̀ à gɛ̃̀ a zùnↄ tɛ́ à zùnɛ bↄ̀rↄ maaa kũ̀ à kpà a zĩkɛria, ben zĩkɛri pì gàa à kɛ̀kɛ kpakpaa. ");
INSERT INTO bus_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ben Ibraĩ zwifãani kↄ̃n zwi'ipuo kↄ̃n zù kɛ̀ wà kɛ̀kɛ pìo sɛ̀ à gàa à dìɛńnɛ. Gurↄↄ kɛ̀ aↄ̃ↄe pↄ́ blee, àpi zɛ ń saɛ lí gbáru gwe. ");
INSERT INTO bus_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ben aↄ̃ à là wà bè: N naↄ̃ Sara kú mámɛ? À bè: À kú kutaan gwe. ");
INSERT INTO bus_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ben Dii bè: Mɛ́ ɛara mà mↄ́ n kiia zii mↄndaa'i, n naↄ̃ Sara é nɛ́ i gↄ̃gbɛ̃ ũ. Sara kú à kpɛɛ kuta kpɛɛlɛ èe maa. ");
INSERT INTO bus_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ibraĩ kↄ̃n Sarao zi kũ̀, Sara è nↄgbɛ̃nↄ pↄ́ kɛ dↄro. Ben Sara yáa dↄ̀ à bè a swɛ̃̀ guu: ");
INSERT INTO bus_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ma zi kũ̀, ben ma dii zi kũ̀ dↄ. Mɛ́ pↄnna yã pì dↄ̃ dↄↄ́? ");
INSERT INTO bus_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ben Dii Ibraĩ là à bè: À kɛ̀ dia Sara yáa dↄ̀? À bè amↄ kɛ̀ a zi kũ̀ é fↄ̃ à nɛ́ i dↄↄ́? ");
INSERT INTO bus_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Yãke ègↄ̃ zĩ'ũmɛro. Zii mↄndaa'i tó à gurↄↄ kà, mɛ́ mↄ́ n kiia, gbasa Sara nɛ́ i gↄ̃gbɛ̃ ũ. ");
INSERT INTO bus_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ben Sara lɛ́ sɛ̀ à bè ée yáa dↄro, zaakɛ vĩa à kũ̀. Ben Dii bè: É'e, n yáa dↄ̀. ");
INSERT INTO bus_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Kɛ̀ gbɛ̃ pìnↄ fɛ̀ɛ, Ibraĩ gàa à zɛńnɛ, ben aↄ̃ Sↄdↄmu kpaa gwà. ");
INSERT INTO bus_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ben Dii bè: Mɛ́ yã kɛ̀ má yezi mà kɛɛ utɛ Ibraĩnɛro. ");
INSERT INTO bus_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","À boriinↄ égↄ̃ bíta aↄ̃égↄ̃ gbãa vĩ. Anduna bori píngi é aubarika e à gãzĩmɛ. ");
INSERT INTO bus_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Zaakɛ ma à sɛ̀ lɛ à o a nɛ́nↄnɛ kↄ̃n a boriinↄ a gbɛra aↄ̃gↄ̃ ma yã kũna aↄ̃ yã maa zɛ́dee kɛ, lɛ mà yã kɛ̀ ma à lɛ́ gbɛ̃̀nɛ kɛnɛ. ");
INSERT INTO bus_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ben Dii ɛ̀ara à bè: Yã kɛ̀ wèe oo Sↄdↄmu kↄ̃n Gↄmↄrao musu pari, ń durun gɛ̃̀ ↄla. ");
INSERT INTO bus_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Mɛ́ gá gwe sa mà gwa, tó yã kɛ̀ aↄ̃ↄe kɛɛ zaa lán má mà nà. Tó aↄ̃ↄ dɛ lɛ sↄ̃ro, mɛ́ dↄ̃. ");
INSERT INTO bus_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Kɛ̀ ń gↄ̃ↄn plaaa pìnↄ dà zɛ́n aↄ̃ↄe gaa Sↄdↄmu, ben Dii gↄ̃̀ kↄ̃n Ibraĩo gwe. ");
INSERT INTO bus_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ben Ibraĩ sↄ̃̀zi à bè: Nɛ́ gbɛ̃ maaanↄ wara lɛdo kↄ̃n gbɛ̃ zaaanↄn yↄ́? ");
INSERT INTO bus_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Tó gbɛ̃ maaanↄↄ kú wɛ́tɛ pì guu aↄ̃ kà gↄ̃ↄn baplaa akuri, nɛ́ ń waran yↄ́? Nɛ́ sùu kɛ wɛ́tɛ pìo gbɛ̃ maa gↄ̃ↄn baplaa akuri pìnↄ yãnziroo? ");
INSERT INTO bus_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ǹ sùu kɛ! Ǹton kɛ lɛro. Ǹton gbɛ̃ maaanↄ dɛdɛ lɛdo kↄ̃n gbɛ̃ zaaanↄro, zaakɛ aↄ̃ↄ dↄ̃nkↄ̃ro. Ǹ sùu kɛ! Ǹton kɛ lɛro. Mmↄn kɛ̀ ń dɛ anduna píngi yãkpaɛkɛri ũ, nɛ́ yã kɛ a zɛ́aroo? ");
INSERT INTO bus_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ben Dii bè: Tó ma gbɛ̃ maaanↄ è Sↄdↄmu gↄ̃ↄn baplaa akuri, mɛ́ sùu kɛ wɛ́tɛ pìo ń yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ben Ibraĩ ɛ̀ara à bè dↄ: Mamↄma kɛ̀ má dɛ bùsuti kↄ̃n túbuo ũ, ǹ gaafaa kɛmɛ mà yã onnɛ, Dii. ");
INSERT INTO bus_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Tó gↄ̃ↄn sↄↄroo kɛ̃̀sã gↄ̃ↄn baplaa akuri pì guu, gↄ̃ↄn sↄↄroo pìnↄ yãnzi nɛ́ wɛ́tɛ pì kaatɛↄ́? Ben Dii bè: Tó ma gbɛ̃ maaanↄ è gↄ̃ↄn baplaa asↄↄro, mɛ́ wɛ́tɛ pì kaatɛro. ");
INSERT INTO bus_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ben Ibraĩ kpɛ́ èe yã oonɛ à bè: Tó gbɛ̃ maaanↄ kà baplaa sↄ̃ nɛ́? Ben Dii bè: Mɛ́ yãke kɛro gↄ̃ↄn baplaaa pìnↄ yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ben à bè: Dii, n yã nna! Ǹton pↄ fɛ̃ro, má yezi mà yã o dↄ. Tó gbɛ̃ maaanↄ kà baaakuri sↄ̃ nɛ́? À wèàla à bè: Tó ma gbɛ̃ maaanↄ è aↄ̃ kà gↄ̃ↄn baaakuri, mɛ́ yãke kɛro. ");
INSERT INTO bus_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ben à bè: Ǹ gaafaa kɛmɛ dↄ Dii, mà yã onnɛ. Tó gbɛ̃ maaanↄ kà gↄ̃ↄn baroo sↄ̃ nɛ́? À wèàla à bè: Mɛ́ wɛ́tɛ pì kaatɛro gↄ̃ↄn baroo pìnↄ yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ben à bè: Dii, ǹton pↄ fɛ̃ro, yã kɛ̀kii baasi mɛ́ yã o dↄro. Tó gbɛ̃ maaanↄ kà gↄ̃ↄn kuri sↄ̃ nɛ́? À wèàla à bè: Mɛ́ wɛ́tɛ pì kaatɛro gↄ̃ↄn kuri pìnↄ yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Kɛ̀ Dii yã ò Ibraĩnɛ à yã̀a, à gɛ̃̀ zɛ́la, ben Ibraĩ ɛ̀ara à tà bɛ. ");
INSERT INTO bus_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Kɛ̀ malaika gↄ̃ↄn plaaa pìnↄ kà Sↄdↄmu uusiɛ, Lutu vɛ̃ɛna Sↄdↄmu bĩi kpɛɛlɛ. Kɛ̀ à ń é, à fɛ̀ɛ à gàa à dàńlɛ à kùɛńnɛ à dàɛ a puua ");
INSERT INTO bus_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","à bè: Ma diinↄ, a yã nna! À mↄ́ à gá pita mamↄma a zↄ̀bleri bɛ. À zú o à i kɛ̀, zia kↄngↄ idɛ'idɛ é da zɛ́n. Aↄ̃ bè: Auo, wé i gãalɛmɛ. ");
INSERT INTO bus_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Lutu nàkↄ̃rɛḿma maamaa, ben aↄ̃ gɛ̃̀ à kpɛ́n. À ń yàari kɛ̀ maamaa à masa kɛ̀ńnɛ, ben aↄ̃ↄ sò. ");
INSERT INTO bus_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ai aↄ̃gↄ̃ gá daɛ, Sↄdↄmudeenↄ lìga Lutu kpɛ́zi. Wɛ́tɛ pì gↄ̃gbɛ̃nↄ kàkↄ̃a gwe mámmam, gↄ̃kparɛnↄ kↄ̃n gbɛ̃nsinↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Aↄ̃ lɛ́ zù Lutuzi wà bè: Gↄ̃gbɛ̃ kɛ̀ aↄ̃ pìta n bɛ uusiɛanↄↄ kú máa? Ǹ bↄɛńyowe, wà pãpãa kɛńyo. ");
INSERT INTO bus_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lutu bↄ̀ à zɛ̀ kpɛɛlɛ ń kiia, à gbà tàta kpɛɛo ");
INSERT INTO bus_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","à bè: O'o ma gbɛ̃nↄ, àton yã zaaa kɛro. ");
INSERT INTO bus_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Má nɛ́nↄgbɛ̃nↄ vĩ gↄ̃ↄn plaa kɛ̀ aↄ̃ↄ gↄ̃gbɛ̃ dↄ̃ro, mɛ́ ń bↄɛare. Lán á yezi nà à kɛńyo, mↄde àton yãke kɛ gↄ̃gbɛ̃ kɛ̀kiinↄnɛro, zaakɛ aↄ̃ pìta ma bɛmɛ. ");
INSERT INTO bus_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Aↄ̃ bènɛ: Ǹ guwe gwe! Ben aↄ̃ bè dↄ: Gbɛ̃ kɛ̀ nɛ́ gbɛ̃ zĩ̀tↄmɛ, ben à yezi à kɛ wa yãkpaɛkɛri ũ. Wé yã zaaa kɛnnɛ dɛ ń pↄ́la. Ben aↄ̃ kùsia gbãaao, aↄ̃ↄe mↄↄ kpɛ́ gbà gboro. ");
INSERT INTO bus_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ben gↄ̃ↄn plaaa pìnↄ ↄ bↄ̀ wà Lutu kũ̀ aↄ̃ gɛ̃̀o kpɛ́n, ben aↄ̃ zɛ́ tàta. ");
INSERT INTO bus_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Aↄ̃ↄ tò vĩ̀a gbɛ̃ kɛ̀ aↄ̃ↄ kú kpɛɛlɛnↄ kũ̀ ń píngi nɛ́ féte gbɛ̃nsi, ben aↄ̃ↄe kpɛ́ gbà wɛtɛɛ ai aↄ̃ kpàsa. ");
INSERT INTO bus_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Gↄ̃ↄn plaaa pìnↄ bè Lutunɛ: Dé ń vĩ kɛ̀ dↄↄ? Nɛ́gↄ̃gbɛ̃nↄ, nɛ́nↄgbɛ̃nↄ, n nɛ́ anzurenↄ kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ dɛ n gbɛ̃ ũunↄ wɛ́tɛ guu ń píngi. Ǹ bↄɛńyo, ");
INSERT INTO bus_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","zaakɛ wa mↄ wà gura kɛ̀ kaatɛmɛ. Yã zaaa kɛ̀ wèe oo wɛ́tɛ pì deenↄ musu gɛ̃̀ Dii swãn, ben à wa zĩ wà wɛ́tɛ pì kaatɛ. ");
INSERT INTO bus_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lutu bↄ̀ à gàa à ò a nɛ́nↄ anzurenↄnɛ à bè: À fɛɛ wà bↄɛ, zaakɛ Dii é wɛ́tɛ kɛ̀ pì kaatɛ tiamɛ. Ben aↄ̃ↄe daa èe fàadi boomɛ. ");
INSERT INTO bus_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Kɛ̀ guu dↄ̀ malaika pìnↄ nàkↄ̃rɛ Lutua wà bè: Ǹ fɛɛ ǹ n naↄ̃ kↄ̃n n nɛ́nↄgbɛ̃ gↄ̃ↄn plaaa kɛ̀nↄ sɛ́ɛ ǹ bↄɛńyo kɛ̀, lɛ ǹton ga wɛ́tɛ pì kaatɛna guuro yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Kɛ̀ Lutu e seka kɛɛ, Dii à wɛ̃nda bò, ben gↄ̃ↄn plaaa pìnↄ à kũ̀ a ↄↄa kↄ̃n à naↄ̃o kↄ̃n à nɛ́nↄgbɛ̃ gↄ̃ↄn plaaanↄ, aↄ̃ bↄ̀ɛńyo wɛ́tɛ kpɛɛ. ");
INSERT INTO bus_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Kɛ̀ aↄ̃ bↄ̀ɛńyo lɛ, ben malaika pìnↄ doke bè Lutunɛ: Ǹ bàa lɛ́ ǹ n zĩnda mì sí. Ǹton kpɛɛ gwaro. Ǹton zɛ guzurɛ pì guuro. Ǹ bàa lɛ́ ǹ mì pɛ́ kpiiinↄa lɛ ǹton garo yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ben à bèńnɛ: Auo ma dii! N yã nna! ");
INSERT INTO bus_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mamↄma n zↄ̀bleri ma n pↄnnaa è, n gbɛ̃kɛɛ kɛ̀mɛ maamaa, n ma mì sì. Mↄde mɛ́ fↄ̃ mà bàa lɛ́ mà kpiii pìnↄ kii lero. Ai màgↄ̃ gá ká gwe, kaatɛna pì é ma le mà ga. ");
INSERT INTO bus_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ǹ lakutu ke gwa kãaa. Lán à kĩi nà, mɛ́ fↄ̃ mà bàa lɛ́ mà gá gwe. Lakutu nɛ́ngomɛ sↄ̃. Ǹ tó mà bàa sí mà tá gwe, mɛ́gↄ̃ aafia. Asa à nɛ́ngoroo? ");
INSERT INTO bus_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ben à bènɛ: Ma n gba zɛ́, mɛ́ lakutu kɛ̀ nɛ́ɛ oo pì kaatɛro. ");
INSERT INTO bus_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ǹ bàa lɛ́ ǹ tá gwe kpakpaa, zaakɛ mɛ́ yãke kɛ gĩaro ai ǹ gá káo gwe. Beee yãnzin wà tↄ́ kpà lakutu pìnɛ Zoa. ");
INSERT INTO bus_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Kɛ̀ Lutu Zoa lè, ↄfãntɛ̃ e fɛɛɛ, ");
INSERT INTO bus_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","ben Dii tò tɛ́ kↄ̃n ↄfãntɛ̃gbↄ̃o bↄ̀ musu à kà Sↄdↄmu kↄ̃n Gↄmↄraola. ");
INSERT INTO bus_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","À wɛ́tɛ pìnↄ kàatɛ kↄ̃n gbɛ̃nↄ kↄ̃n guzurɛ pìo kↄ̃n línↄ kↄ̃n sɛ̃̀nↄ píngi. ");
INSERT INTO bus_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Kɛ̀ Lutu naↄ̃ a kpɛɛ gwà, ben à lì à gↄ̃̀ zɛna wisi gbɛ̀ ũ. ");
INSERT INTO bus_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Kɛ̀ guu dↄ̀, Ibraĩ fɛ̀ɛ kↄngↄ idɛ'idɛ, à gàa guu kɛ̀ à kún yã kↄ̃n Diio pìn. ");
INSERT INTO bus_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Kɛ̀ à Sↄdↄmu kↄ̃n Gↄmↄrao kpaa gwà kↄ̃n guzurɛ pìo píngi, à è tɛ́sukpɛ e fɛɛɛ tↄↄtɛ lán mↄ̀datɛ tɛ́sukpɛ bà. ");
INSERT INTO bus_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Lɛmɛ kɛ̀ Luda guzurɛ kɛ̀ Lutu kún wɛ́tɛnↄ kàatɛ lɛ, Ibraĩ yã dↄ̀n, ben à Lutu bↄ̀ wɛ́tɛ kɛ̀ à kàatɛ pìnↄ guu. ");
INSERT INTO bus_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Kɛ̀ Lutu bↄ̀ Zoa, à gàa à vɛ̃̀ɛ kpiiinↄ tɛ́ kↄ̃n a nɛ́nↄgbɛ̃ gↄ̃ↄn plaaanↄ, kɛ̀ à kuuna Zoa vĩa vĩ yãnzi. Ben à gↄ̃̀ kú gbɛ̀wɛɛn kↄ̃n a nɛ́nↄgbɛ̃ pìnↄ. ");
INSERT INTO bus_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ben Yↄ̃ↄ bè Bãanɛ: Wa de zi kũ̀, ben gↄ̃gbɛ̃ kee kú bùsun à daɛwao lán wè kɛ nàro. ");
INSERT INTO bus_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ǹ mↄ́ wà wɛ̃ɛ kákanɛ wé daɛo, lɛ wàgↄ̃ wa borii e à gãzĩ. ");
INSERT INTO bus_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Gwãavĩ beeea aↄ̃ wɛ̃ɛ kàkanɛ, ben Yↄ̃ↄ gàa à dàɛo. Lutu e dↄ̃ gurↄↄ kɛ̀ à dàɛao ke gurↄↄ kɛ̀ à fɛ̀ɛro. ");
INSERT INTO bus_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kɛ̀ guu dↄ̀ Yↄ̃ↄ bè Bãanɛ: Ma daɛ kↄ̃n ma deo gĩa. Wà wɛ̃ɛ kákanɛ uusiɛa dↄ, nɛ́ gá ǹ daɛo, lɛ wàgↄ̃ wa borii ee à gãzĩ. ");
INSERT INTO bus_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Gwãavĩ beeea dↄ aↄ̃ wɛ̃ɛ kàkanɛ, ben Bãa gàa à dàɛo. Lutu e dↄ̃ gurↄↄ kɛ̀ à dàɛao ke gurↄↄ kɛ̀ à fɛ̀ɛro. ");
INSERT INTO bus_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Lɛmɛ Lutu nɛ́nↄgbɛ̃ gↄ̃ↄn plaaa pìnↄↄ kɛ̀ lɛ wà nↄ̀ sìo. ");
INSERT INTO bus_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Yↄ̃ↄ nɛ́ ì gↄ̃gbɛ̃ ũ, ben à tↄ́ kpànɛ Mↄabu. Àmbe Mↄabu borii kɛ̀ aↄ̃ↄ kuu ai gbã̀anↄ dezi káaku ũ. ");
INSERT INTO bus_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Bãa nɛ́ ì gↄ̃gbɛ̃ ũ se, ben à tↄ́ kpànɛ Bɛnami. Àmbe Amↄni borii kɛ̀ aↄ̃ↄ kuu ai gbã̀anↄ dezi káaku ũ. ");
INSERT INTO bus_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ben Ibraĩ fɛ̀ɛ gwe à gàa Nɛgɛvi bùsun Kadɛsi kↄ̃n Suruo dagura. Kɛ̀ à gàa à vɛ̃̀ɛ Gera, ");
INSERT INTO bus_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","à bè a naↄ̃ Sara nɛ́ a dãremɛ, ben Gera kí Abimɛlɛki gbɛ̃ zĩ̀ à à sɛ̀ à sùo. ");
INSERT INTO bus_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ben Luda bↄ̀ à mↄ̀ Abimɛlɛkizi nanaa guu gwãavĩ à bènɛ: Nɛ́ ga nↄↄ kɛ̀ ń sɛ̀ pì yãnzi, zaakɛ nↄzãreemɛ. ");
INSERT INTO bus_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","À mↄ̀ à lè Abimɛlɛki e daɛo kↄ̀ro, ben à bè: Dii, nɛ́ borii kɛ̀ aↄ̃ↄe yãke kɛroonↄ dɛdɛn yↄ́? ");
INSERT INTO bus_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Àmbe à bèmɛ a dãrenloo? Nↄgbɛ̃ pì sↄ̃ bè a dãgↄ̃mɛ. Ma yã kɛ̀ a zɛ́amɛ, má taari vĩro. ");
INSERT INTO bus_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ben Luda bènɛ nanaa pì guu: Eè, má dↄ̃ kɛ̀ n yã kɛ̀ a zɛ́amɛ. Beee yãnzi ma kpannɛ ǹton durun kɛmɛro, mɛ́ɛ we n ↄ kɛ̀ nↄgbɛ̃ pìaro. ");
INSERT INTO bus_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Tia sa, à gↄ̃gbɛ̃ pì nↄↄ kpáa, zaakɛ annabimɛ. Eé adua kɛnnɛ lɛ ǹ gↄ̃ aafia. Tó nɛ́ɛ à nↄↄ pì kpáa sↄ̃ro, ǹgↄ̃ dↄ̃ kɛ̀ n gamɛ, mpi kↄ̃n n gbɛ̃nↄ a píngi. ");
INSERT INTO bus_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ben Abimɛlɛki fɛ̀ɛ kↄngↄ idɛ'idɛ, à a gbɛ̃nↄ sìsi à yã pì tↄ̃kɛ̃̀ńnɛ ń píngi, ben vĩa ń kũ maamaa. ");
INSERT INTO bus_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ben Abimɛlɛki Ibraĩ sìsi à bènɛ: Bↄ́yãnzi ń kɛ̀we lɛzi? Bↄ́ taarin má kɛ̀nnɛ gbasa ń tò ma gↄ̃ durundee ũ kↄ̃n ma bùsuo? N yã kɛ̀ dɛ wà kɛroo kɛ̀mɛ. ");
INSERT INTO bus_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Bↄ́ laasuu ń lɛ̀ gbasa n yã pì kɛ̀? ");
INSERT INTO bus_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ibraĩ wèàla à bè: Mɛ́ɛ daa yã gbɛ̃kee Luda vĩa vĩ bùsu kɛ̀kii guuro, weé ma dɛ ma naↄ̃ yãnzimɛ. ");
INSERT INTO bus_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Beee gbɛra nↄgbɛ̃ pì nɛ́ ma dãremɛ yãpura. Wa de dↄ̃nkↄ̃mɛ, baade kↄ̃n a dao, ben à gↄ̃̀ ma nↄↄ ũ. ");
INSERT INTO bus_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Kɛ̀ Luda ma bↄ ma de bɛ yã, mɛ́ɛ likↄ̃aa zↄ̃ↄ, ben ma bè ma nↄↄ pìnɛ guu kɛ̀ wé gán píngi, à gbɛ̃kɛɛ kɛmɛ àgae be a dãgↄ̃n ma ũ. ");
INSERT INTO bus_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ben Abimɛlɛki mↄ̀ kↄ̃n sãanↄ kↄ̃n zùnↄ kↄ̃n gↄ̃gbɛ̃ zĩkɛrinↄ kↄ̃n nↄgbɛ̃ zĩkɛrinↄ à kpà Ibraĩa, ben à à naↄ̃ sↄ̀kpanɛ. ");
INSERT INTO bus_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ben Abimɛlɛki bè: Ma bùsun yɛ̀, ǹ vɛ̃ɛ guu kɛ̀ ń yezin. ");
INSERT INTO bus_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ben à bè Saranɛ: Ma kondogi ↄↄ bↄrↄ doo kpà n dãgↄ̃a agbaakpabↄ ũ, lɛ gbɛ̃ kɛ̀ aↄ̃ↄ kúnyonↄ dↄ̃ ń píngi kɛ̀ nɛ́ɛ taari kɛro. ");
INSERT INTO bus_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ben Ibraĩ wɛ́ɛ kɛ̀ Ludaa, ben Luda Abimɛlɛki gbà aafia kↄ̃n à naↄ̃o kↄ̃n à nↄ yìgisainↄ, lɛ aↄ̃ nɛ́ i, ");
INSERT INTO bus_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","zaakɛ Dii tò Abimɛlɛki bɛ nↄgbɛ̃nↄ pãa kũ̀ yã Ibraĩ naↄ̃ yã musu. ");
INSERT INTO bus_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Dii aubarika dà Saragu lán à ò nà, à kɛ̀nɛ lán à lɛ́ gbɛ̃̀nɛ nà. ");
INSERT INTO bus_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ben à nↄ̀ sì à nɛ́ ì kↄ̃n Ibraĩo gↄ̃gbɛ̃ ũ à zikũ guu gurↄↄ kɛ̀ Luda dìɛnɛa. ");
INSERT INTO bus_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ibraĩ tↄ́ kpà nɛ́ pìnɛ Isaaku. ");
INSERT INTO bus_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","À bã̀ngu kɛ̀nɛ à gurↄ sↄraagↄ̃dee zĩ lán Ludaa dìɛnɛ nà. ");
INSERT INTO bus_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","À kà wɛ̃̀ basↄↄro a nɛ́ pì igurↄ. ");
INSERT INTO bus_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ben Sara bè: Luda yáadↄziyã kɛ̀mɛ, gbɛ̃ kɛ̀ mà píngi é yáa dↄmao. ");
INSERT INTO bus_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","À bè dↄ: Weé we wà be Ibraĩnɛ yã mɛ́ gↄ̃ nɛ́dandee ũↄ́? Àɛ ma nɛ́gↄ̃gbɛ̃ ìo a zikũ guu. ");
INSERT INTO bus_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Kɛ̀ nɛ́ pì bíta kũ̀ à kɛ̃̀ yↄ̃a, ben Ibraĩ à kɛ̃na yↄ̃a pↄnnaa kɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sara è nɛ́ kɛ̀ Igipiti nↄgbɛ̃ Agyara ì kↄ̃n Ibraĩo ègↄ̃ Isaaku yáa dↄↄmɛ, ");
INSERT INTO bus_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ben à bè Ibraĩnɛ: Ǹ pɛ́ zↄ̀ pìa kↄ̃n a nɛ́o, zaakɛ zↄ̀ nɛ́ pì é túbi ble kↄ̃n ma nɛ́ Isaakuoro. ");
INSERT INTO bus_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Yã pì Ibraĩ pↄↄ yàka maamaa, zaakɛ à nɛ́mɛ, ");
INSERT INTO bus_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","ben Luda bènɛ: Ǹton tó n nↄ̀sɛ yaka n nɛ́ kↄ̃n n nↄgbɛ̃ zĩkɛri pìo yã musuro. Yã kɛ̀ Sara e oonnɛ píngi ǹ ma, zaakɛ Isaaku boriinↄn weégae beńnɛ n boriinↄ ũ. ");
INSERT INTO bus_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Mɛ́ tó zↄ̀ nɛ́ pì borii kɛ se, zaakɛ n nɛ́mɛ. ");
INSERT INTO bus_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ben Ibraĩ fɛ̀ɛ kↄngↄ idɛ'idɛ, à pↄ́blee sɛ̀ kↄ̃n í tùuo à kpà Agyaraa. À dìnɛ, ben à à nɛ́ kpàa dↄ. À à gbàrɛ, ben à gàa èe likↄ̃aa zↄ̃ↄ Bɛsɛba gbáan. ");
INSERT INTO bus_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Kɛ̀ í yã̀aḿma, à gↄ̃kparɛ pì tò lí gbáru, ");
INSERT INTO bus_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ben à gàa à vɛ̃̀ɛ aɛ kàzulɛɛki zã̀ lɛ́n, zaakɛ à bè á yezi à a nɛ́ gana ero. Kɛ̀ à gàa à vɛ̃̀ɛ kãa lɛ, ben à nà ↄ́ↄdↄnaa. ");
INSERT INTO bus_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Luda gↄ̃kparɛ pì ↄ́ↄ dↄↄ mà, ben Luda Malaika lɛ́ zù Agyarazi zaa musu à bè: Bↄ́ bé à n lee Agyara? Ǹton vĩa kɛro, zaakɛ Luda nɛ́ pì ↄ́ↄ dↄↄ mà guu kɛ̀ à kún. ");
INSERT INTO bus_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ǹ fɛɛ ǹ n nɛ́ pì sɛ́ ǹ à kũ a ↄↄa, zaakɛ mɛ́ tó à gↄ̃ bori ìsi ũ. ");
INSERT INTO bus_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Luda nↄgbɛ̃ pì wɛ́ɛ kɛ̃̀nɛ, ben à lↄ̀gↄ è. À gàa à í tↄ̀ a tùu pa, ben à mↄ̀ à kpà a nɛ́ pìa à mì. ");
INSERT INTO bus_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ludaa kú kↄ̃n nɛ́ pìo ai à ìsi kũ̀. Ègↄ̃ kú gbáan, ben à gↄ̃̀ tofekari ũ. ");
INSERT INTO bus_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Gurↄↄ kɛ̀ à kú Parani gbáa pì guun à da Igipiti bùsu nↄↄ sɛ̀nɛ. ");
INSERT INTO bus_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Gurↄ beeea Abimɛlɛki kↄ̃n a zĩ̀kpɛɛnↄ gbɛ̃nsi Fikↄluo gàa Ibraĩ kiia aↄ̃ bènɛ: Ludaa kúnyo yã kɛ̀ nɛ́ɛ kɛɛ guu píngi. ");
INSERT INTO bus_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ǹ la damɛ kɛ̀ gↄ̃ↄ ǹ sí kↄ̃n Ludao kɛ̀ nɛ́ bↄ ma kpɛɛro ke ma nɛ́nↄ ke ma boriinↄ. Lán ma gbɛ̃kɛɛ kɛ̀nnɛ nà, ǹ kɛmɛ lɛ kↄ̃n bùsu kɛ̀ ń kú à guu gbɛ̃ zĩ̀tↄ ũuo. ");
INSERT INTO bus_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ben Ibraĩ bènɛ: Ma la dànnɛ. ");
INSERT INTO bus_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ben Ibraĩ lↄ̀gↄ kɛ̀ Abimɛlɛki gbɛ̃nↄ sìa yã sɛ̀ɛ à sìnnɛ. ");
INSERT INTO bus_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimɛlɛki bè: Má gbɛ̃ kɛ̀ aↄ̃ yã beee kɛ̀nↄ dↄ̃ro, nɛ́ɛ omɛ yãro, gbã̀an má mà. ");
INSERT INTO bus_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ben Ibraĩ sãanↄ kↄ̃n zùnↄ kũ̀ à kpà Abimɛlɛkia, ben aↄ̃ lɛdolɛ kɛ̀ kↄ̃o. ");
INSERT INTO bus_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ben Ibraĩ sãnunu mɛ̀n swɛɛplaaanↄ bↄ̀ à kàɛ ńdona. ");
INSERT INTO bus_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimɛlɛki à là à bè: Sã mɛ̀n swɛɛplaaa kɛ̀ n ń káɛ ńdona pìnↄ yã dɛ diamɛ? ");
INSERT INTO bus_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ben à wèàla à bè: Ǹ sã mɛ̀n swɛɛplaaa pìnↄ sí sèeda ũ kɛ̀ mámbe ma lↄ̀gↄ pì yↄ̃̀. ");
INSERT INTO bus_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Beee yãnzi wà tↄ́ kpà guu pìnɛ Bɛsɛba, zaakɛ gwen aↄ̃ la dànkↄ̃nɛ. ");
INSERT INTO bus_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Lɛn aↄ̃ lɛdolɛ kɛ̀ Bɛsɛba lɛ, ben Abimɛlɛki kↄ̃n a zĩ̀kpɛɛnↄ gbɛ̃nsi Fikↄluo lìara wà tà Filisitininↄ bùsun. ");
INSERT INTO bus_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ibraĩ sãma lí tↄ̃̀ Bɛsɛba, ben à Dii Luda Gurↄpingide sìsi gwe. ");
INSERT INTO bus_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ben à gurↄplaa kɛ̀ Filisitininↄ bùsu pì guu. ");
INSERT INTO bus_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Beee gbɛra Luda Ibraĩ yↄ̃̀ à gwà à bènɛ: Ibraĩ! Ben à wèàla à bè: Maɛ kɛ̀! ");
INSERT INTO bus_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ben Luda bènɛ: Ǹ n nɛ́ mɛ̀n doo kɛ̀ ń yezi Isaaku sɛ́ ǹ gáo Mↄria bùsun, ǹ sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ oo kpiii kɛ̀ mɛ́ onnɛɛa. ");
INSERT INTO bus_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kɛ̀ à fɛ̀ɛ kↄngↄ idɛ'idɛ, à gàari yì a zaakinɛ, ben à a zĩkɛrinↄ sɛ̀ gↄ̃ↄn plaa kↄ̃n a nɛ́ Isaaku pìo. À sa'oyaka pàra, ben à dà zɛ́n, èe gaa guu kɛ̀ Ludaa ònɛn. ");
INSERT INTO bus_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","À gurↄ aagↄ̃dee zĩ kɛ̀ à wɛ́ɛ sɛ̀, à guu pì è kãa. ");
INSERT INTO bus_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ben à bè a zĩkɛri pìnↄnɛ: À gↄ̃ kↄ̃n zaakio kɛ̀. Mapi kↄ̃n gↄ̃kparɛ kɛ̀o wé gá aɛ wà dↄnzi kɛ Ludanɛ, wé liara wà su wà a le kɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ibraĩ sa'oyaka sɛ̀ à dì a nɛ́ pìnɛ, ben à tɛ́ kũna kↄ̃n fɛ̃ɛo, aↄ̃ↄe gaa lɛdo. ");
INSERT INTO bus_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ben Isaaku yã ò a denɛ à bè: Baa! À wèàla à bè: Bↄ́mɛɛ nɛ́? Ben à bènɛ: Wá tɛ́ kũna kↄ̃n yàkao, sãnɛ bↄ̀rↄ kɛ̀ wé ká tɛ́n à tɛ́ kũ kú mámɛ? ");
INSERT INTO bus_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ben Ibraĩ bè: Ma nɛ́, Luda bé eé sa'osã kpá. Ben aↄ̃ↄ tɛ́kↄ̃zi wèe gaa. ");
INSERT INTO bus_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Kɛ̀ aↄ̃ kà guu kɛ̀ Ludaa ònɛn, à sa'okii bò gwe à yàka kpàkpaàla, ben à a nɛ́ pì yì à dà yàka pìla sa'okii musu. ");
INSERT INTO bus_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Kɛ̀ à fɛ̃ɛ sɛ̀ à ↄ bↄ̀ lɛ à a nɛ́ pì kòto kpá, ");
INSERT INTO bus_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ben Dii Malaika lɛ́ zùzi zaa musu à bè: Ibraĩ! Ibraĩ! À wèàla à bè: Maɛ kɛ̀! ");
INSERT INTO bus_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ben à bè: Ǹton ↄ na nɛ́ pìaro ǹton yãke kɛnɛro. Má dↄ̃ sa kɛ̀ ń ma vĩa vĩ, nɛ́ɛ gímɛ kↄ̃n n nɛ́ mɛ̀n doooro. ");
INSERT INTO bus_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ibraĩ wɛ́ɛ sɛ̀, ben à sãkaro è líwakaa kà à kobazi. Ben à gàa à à kũ̀ à sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ òo a nɛ́ gɛ̃ɛ ũ. ");
INSERT INTO bus_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ben à tↄ́ kpà guu pìnɛ Diiékpa, ben wègↄ̃ oo ai kↄ̃n a gbã̀ao wè be: Dii é kpá a kpiii musu. ");
INSERT INTO bus_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Dii Malaika ɛ̀ara à lɛ́ zù Ibraĩzi zaa musu dↄ ");
INSERT INTO bus_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","à bè: Mamↄma Dii má sì kↄ̃n ma kuunao ma bè, lán n yã pì kɛ̀ nà, nɛ́ɛ gí kↄ̃n n nɛ́ mɛ̀n doooro, ");
INSERT INTO bus_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","mɛ́ aubarika dangu mà n borii kaarannɛ lán sↄsↄnɛnↄ bà, aↄ̃égↄ̃ pari lán ísialɛ bùsu'ãatɛ̃ bà. N boriinↄ égↄ̃ gbãa vĩ n ibɛɛnↄa. ");
INSERT INTO bus_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Mɛ́ aubarika da anduna bori píngin n borii gãzĩ, kɛ̀ n ma yã mà yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Kɛ̀ Ibraĩ lìara à sù a zĩkɛrinↄ kiia, aↄ̃ fɛ̀ɛ wà tà Bɛsɛba, ben à gurↄplaa kɛ̀ gwe. ");
INSERT INTO bus_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Beee gbɛra wà ò Ibraĩnɛ wà bè: N vĩ̀i Nao naↄ̃ Milika nɛ́gↄ̃gbɛ̃nↄ ì. ");
INSERT INTO bus_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","À daudu tↄ́n Uzu. À dãaronↄ tↄ́n yɛ̀: Buzu, Aramu de Kɛmuɛli, ");
INSERT INTO bus_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kɛsɛdi, Azo, Pilidasa, Yidilafa kↄ̃n Bɛtuɛlio. ");
INSERT INTO bus_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bɛtuɛli pì bé à Rɛbɛka ì. Nɛ́gↄ̃gbɛ̃ gↄ̃ↄn sↄraagↄ̃ↄ kɛ̀ Milika ì kↄ̃n Ibraĩ vĩ̀i Naon gwe. ");
INSERT INTO bus_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","À nↄ yìgisai Ruma nɛ́nↄ tↄ́n yɛ̀: Teba, Gaamu, Tasa kↄ̃n Maakao. ");
INSERT INTO bus_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara kɛ̀ wɛ̃̀ baswɛɛdo awɛɛswɛɛplaa, ");
INSERT INTO bus_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","gbasa à gà zaa Kiriataba kɛ̀ wè be tia Ɛblↄnu, Kanaa bùsun. Ben Ibraĩ à sósobi kɛ̀ à ↄ́ↄ dↄ̀ à gana yã musu. ");
INSERT INTO bus_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Kɛ̀ à gù a naↄ̃ gɛ̀ kiia, à gàa à bè Iti boriinↄnɛ: ");
INSERT INTO bus_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Nibↄ kↄ̃n gbɛ̃ zĩ̀tↄon ma ũ a tɛ́. À tↄↄtɛ yáma gɛ̀vĩikii ũ mà gɛ̀ vĩin. ");
INSERT INTO bus_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ben Iti boriinↄ bènɛ: ");
INSERT INTO bus_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Maree, ǹ wa yã ma. Luda gbɛ̃ aubarikadeen n ũ wa tɛ́. Ǹ n gɛ̀ vĩi gbɛ̀wɛɛ kɛ̀ kɛ̀nnɛ maaa guu. Wa gbɛ̃ke é n tɛ̃ gbɛ̀wɛɛ kɛ̀ nɛ́ n gɛ̀ vĩi à guuro. ");
INSERT INTO bus_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ben Ibraĩ fɛ̀ɛ à kùɛ bùsu pì deenↄnɛ ");
INSERT INTO bus_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","à bèńnɛ: À ma yã ma, tó a we mà a gɛ̀ vĩi kɛ̀. À wɛ́ɛ kɛmɛ Zoa nɛ́ Ɛflↄnua ");
INSERT INTO bus_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","à Makpɛla gbɛ̀wɛɛ kɛ̀ kú à bú lɛ́zi yá ma à ↄↄa, eé gↄ̃ ma gɛ̀vĩikii ũ a bùsun. ");
INSERT INTO bus_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ɛflↄnu vɛ̃ɛna ń tɛ́ a wɛ́tɛ bĩilɛn gwe, ben à ò Ibraĩnɛ Itinↄ wáa ń píngi à bè: ");
INSERT INTO bus_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Auo mare, ǹ ma yã ma. Ma n gba buraa pì kↄ̃n gbɛ̀wɛɛ kɛ̀ kú gweeo. Ma n gba ma gbɛ̃nↄ wáa. Ma n gbamɛ, lɛ ǹ n gɛ̀ vĩin. ");
INSERT INTO bus_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ibraĩ kùɛ bùsu pì deenↄnɛ, ");
INSERT INTO bus_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ben à bè Ɛflↄnunɛ ń píngi wáa: Ǹ swã kpá ǹ ma yã ma. Mɛ́ buraa pì fĩa bonnɛ. Ǹ ma ↄↄ sí, mɛ́ ma gɛ̀ vĩin. ");
INSERT INTO bus_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ben Ɛflↄnu bènɛ: ");
INSERT INTO bus_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Maree, ǹ ma yã ma. Tↄↄtɛ kɛ̀ à ↄↄ kà kondogi wàa plaamɛ, bↄ́n beee ũ wa dagura? Ǹ n gɛ̀ vĩin. ");
INSERT INTO bus_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ibraĩ à yã mà, ben à kondogi kɛ̀ à ò yↄ̃̀nɛ gbɛ̃nↄ wáa laatarinↄ zakaa. ");
INSERT INTO bus_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Lɛmɛ Ɛflↄnu bú kɛ̀ kú Makpɛla, Mamare saɛ, gↄ̃̀ Ibraĩ pↄ́ ũ lɛ kↄ̃n gbɛ̀wɛɛ kɛ̀ kú gweeo kↄ̃n lí kɛ̀ kú gweenↄ zaa bú pì lɛ́zi píngi. ");
INSERT INTO bus_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","À gↄ̃̀ Ibraĩ pↄ́ ũ Iti kɛ̀ aↄ̃ mↄ̀ wɛ́tɛ bĩilɛanↄ píngi wáa. ");
INSERT INTO bus_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Beee gbɛra Ibraĩ a naↄ̃ vĩ̀i Makpɛla bura gbɛ̀wɛɛ pì guu Mamare kɛ̀ wè be tia Ɛblↄnu saɛ, Kanaa bùsun. ");
INSERT INTO bus_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Lɛn bú kↄ̃n gbɛ̀wɛɛ kɛ̀ dɛ Itinↄ pↄ́ ũ yãao gↄ̃̀ Ibraĩnɛ gɛ̀vĩikii ũ lɛ. ");
INSERT INTO bus_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ibraĩ zi kũ̀ à gurↄↄnↄ kà zã̀, ben Dii aubarika dàn yã píngi guu. ");
INSERT INTO bus_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ben à ò a zↄ̀blerinↄ gbɛ̃nsi kɛ̀ dɛ a pↄ́ píngi yãgↄ̃gↄ̃ri ũunɛ à bè: Ǹ ↄ sↄtↄ ma gbáda gbáru, ");
INSERT INTO bus_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","mɛ́ tó ǹ sí kↄ̃n Dii musu kↄ̃n tↄↄtɛo Luda tↄ́o kɛ̀ nɛ́ Kanaa kɛ̀ má kú ń tɛ́nↄ nↄↄ sɛ́ ma nɛ́nɛro. ");
INSERT INTO bus_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ǹ gá ma bɛ bùsun ma danɛnↄ guu, ǹ nↄↄ sɛ́ ma nɛ́nɛ gwe. ");
INSERT INTO bus_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ben à zↄ̀bleri pì à là à bè: Tó nↄgbɛ̃ pì e we à tɛ̀mazi à sùmao bùsu kɛ̀kiin sↄ̃ro nɛ́? Mɛ́ gá kↄ̃n n nɛ́o bùsu kɛ̀ n bↄnn yↄ́? ");
INSERT INTO bus_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ibraĩ bènɛ: Ǹ làakari kɛ! Ǹton gá kↄ̃n ma nɛ́o gwero. ");
INSERT INTO bus_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Dii Luda Musude ma bↄ ma de bɛ ma danɛnↄ bùsun, ben à yã òmɛ à la dà à bè é bùsu kɛ̀kii kpá ma boriinↄamɛ. Àmbe eé a Malaika zĩ à dↄnnɛ aɛ. Gwen nɛ́ nↄↄ sɛ́n ma nɛ́nɛ. ");
INSERT INTO bus_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Tó nↄgbɛ̃ pì e we à tɛ̀nziro, n bↄ ladana kɛ̀ ń la dàmɛɛ kɛ̀ guu. Ǹton gá gwe kↄ̃n ma nɛ́oro fá! ");
INSERT INTO bus_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ben à zↄ̀bleri pì a ↄↄ sↄ̀tↄ a dii gbáda gbáru, à la dànɛ yã pì musu. ");
INSERT INTO bus_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Zↄ̀bleri pì a dii lakuminↄ sɛ̀ mɛ̀n kuri kↄ̃n a dii auziki bori píngio, ben à fɛ̀ɛ à gàa Nao bɛ wɛ́tɛ zaa Siria Mɛsↄpↄtamia bùsun. ");
INSERT INTO bus_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Kɛ̀ à kà gwe, à tò lakuminↄ kámma bò lↄ̀gↄ saɛ wɛ́tɛ kpɛɛ. Kɛ̀ uusiɛ kɛ̀, gurↄↄ kɛ̀ nↄgbɛ̃nↄ è bↄɛ í tↄ́, ");
INSERT INTO bus_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","ben à adua kɛ̀ à bè: Dii, ma dii Ibraĩ Luda, ǹ gbɛ̃kɛɛ kɛ ma diinɛ ǹ tó ma tá kɛ nna uusiɛa. ");
INSERT INTO bus_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ǹ gwa, má zɛna lↄ̀gↄ saɛ. Tó wɛ́tɛ nↄkparɛnↄ bↄ̀ɛ í tↄ́, ");
INSERT INTO bus_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","nↄkparɛ kɛ̀ má ònɛ à a loo pita à í tↄ́mɛ mà mi, tó à bèmɛ mà mi, ben à kpà ma lakuminↄa dↄ, ɛ̃ndɛ̃ mɛ́ dↄ̃ kɛ̀ n gbɛ̃kɛɛ kɛ̀ ma diinɛ, nↄgbɛ̃ kɛ̀ ń dìɛ n zↄ̀bleri Isaaku pↄ́ ũun gwe. ");
INSERT INTO bus_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Èe yã pì o à yã̀aro, ben Bɛtuɛli nɛ́ Rɛbɛka bↄ̀ kↄ̃n looo dina a gã̀n. Bɛtuɛli nɛ́ Ibraĩ vĩ̀i Nao nɛ́ kɛ̀ à ì kↄ̃n a naↄ̃ Milikaomɛ. ");
INSERT INTO bus_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Nɛ́ pì maa bensↄ̃ à lɛzimɛ, gↄ̃gbɛ̃ kee e daɛo zikiro. À mↄ̀ lↄ̀gↄzi, à í tↄ̀ à a loo pà, ben à lìara èe taa. ");
INSERT INTO bus_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ben zↄ̀bleri pì bàa lɛ̀ à gàa à zɛ́ zↄ̃̀nɛ à bè: Ǹ ma gba í mà mi, baa féte. ");
INSERT INTO bus_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Nↄgbɛ̃ pì bè: Ǹ mi Baa! Ben à a loo pìta gↄ̃ↄ à í kpàa à mì. ");
INSERT INTO bus_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Kɛ̀ à í kpàa à mì à yã̀a, à bè: Mɛ́ tↄ́ n lakuminↄnɛ dↄ, aↄ̃ mi ai aↄ̃ kã. ");
INSERT INTO bus_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ben à a lo'i kà pↄ́nↄ ímibↄn gↄ̃ↄ, à lìara à bàa lɛ̀ à gàa à í tↄ́ lↄ̀gↄn, ben à í tↄ̀ lakuminↄnɛ píngi. ");
INSERT INTO bus_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Gↄ̃gbɛ̃ pì zɛna èe à gwaa tíii, lɛ à e à dↄ̃ tó Dii é tó a tá kɛ nna, ke eé kɛ nnaro. ");
INSERT INTO bus_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kɛ̀ lakuminↄ í mì aↄ̃ yã̀a, ben gↄ̃gbɛ̃ pì vura tãnga maaa dà nↄↄ pìnɛ a yĩa, à vura zãa dànɛ mɛ̀n plaa. Tãnga pì tìisi kà giramu sↄↄro, zãa pìnↄ sↄ̃ giramu basↄsↄↄro. ");
INSERT INTO bus_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ben à à là à bè: Ǹ omɛ, dé nɛ́n n ũu? Wé ikii e n de bɛↄ́? ");
INSERT INTO bus_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ben à wèàla à bè: Bɛtuɛli nɛ́n ma ũ, Milika kↄ̃n Nao dio. ");
INSERT INTO bus_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Sɛ̃̀ kↄ̃n tàgaao din wa bɛ, ben ikii kuu dↄ. ");
INSERT INTO bus_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ben gↄ̃gbɛ̃ pì kùɛ à dↄnzi kɛ̀ Diinɛ à bè: ");
INSERT INTO bus_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Dii ma dii Ibraĩ Luda aubarika vĩ kɛ̀ èe gí gbɛ̃kɛ kↄ̃n náanɛo yã kɛnɛro yãnzi. Mapi sↄ̃, Dii dↄ̀mɛ aɛ ma dii danɛnↄ bɛ. ");
INSERT INTO bus_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ben nↄkparɛ pì bàa lɛ̀ à gàa à yã pì tↄ̃kɛ̃̀ a bɛdeenↄnɛ. ");
INSERT INTO bus_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rɛbɛka pì dãgↄ̃ vĩ kɛ̀ wè benɛ Labã. À bↄ̀ wɛ́tɛ kpɛɛ kↄ̃n bào à gàa à gↄ̃gbɛ̃ pì lè lↄ̀gↄ lɛ́a, ");
INSERT INTO bus_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","zaakɛ à è a dãre tãnga kↄ̃n zãao dana, ben à yã kɛ̀ gↄ̃gbɛ̃ pì ònɛ mà. Kɛ̀ à gàa à à lè kↄ̃n lakuminↄ lↄ̀gↄ lɛ́a, ");
INSERT INTO bus_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","à bè: Ǹ mↄ́ mmↄn kɛ̀ Dii aubarika dàngu! À kɛ̀ dia ń zɛna wɛ́tɛ kpɛɛ? Ma kpɛ́ kɛ̀kɛnnɛ kↄ̃n lakuminↄ bàdↄkiio. ");
INSERT INTO bus_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Gↄ̃gbɛ̃ pì gɛ̃̀ ua, ben Labã lakuminↄ asoo pòro à sɛ̃̀la kori kↄ̃n tàgaao kpàḿma à í kpà gↄ̃gbɛ̃ pìa à a gbá pípio kↄ̃n à gbɛ̃nↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Wà pↄ́blee dìɛnɛ, ben à bè: Mɛ́ pↄ́ ble gĩaro ai mà yã kɛ̀ ma mↄo o. Ben Labã bè: Ǹ o. ");
INSERT INTO bus_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ben à bè: Ibraĩ zↄ̀blerin ma ũ. ");
INSERT INTO bus_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Dii aubarika kɛ̀ ma diinɛ maamaa, ben à gↄ̃̀ auzikidee ũ. À à gbà sãanↄ kↄ̃n zùnↄ kↄ̃n kondogio kↄ̃n vurao kↄ̃n gↄ̃gbɛ̃ zĩkɛrinↄ kↄ̃n nↄgbɛ̃ zĩkɛrinↄ kↄ̃n lakuminↄ kↄ̃n zaakinↄ. ");
INSERT INTO bus_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ma dii pì naↄ̃ Sara nɛ́ ì gↄ̃gbɛ̃ ũ a zikũ guu, ben ma dii pↄ́ kɛ̀ à vĩi kpà nɛ́ pìa píngi. ");
INSERT INTO bus_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ma dii tò ma la dà, zaakɛ à bè màton Kanaa kɛ̀ à kú ń tɛ́nↄ nↄↄ sɛ́ a nɛ́nɛro. ");
INSERT INTO bus_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","À bè mà gá a de bɛ a borii guu mà nↄↄ sɛ́ a nɛ́nɛ gwe. ");
INSERT INTO bus_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ben ma a dii là ma bè, tó nↄgbɛ̃ pì e we à tɛ́mazi sↄ̃ro nɛ́? ");
INSERT INTO bus_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","À wèmala à bè, Dii kɛ̀ a táa òo bé eé a Malaika zĩ à gá zɛmɛ, lɛ ma tá kɛ nna, mɛ́ nↄↄ sɛ́ a nɛ́nɛ a de bɛ danɛnↄ tɛ́. ");
INSERT INTO bus_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","À bè tó ma gaa a borii kiia, tó wèe wero, mɛ́ bↄ ladana kɛ̀ má la dàaree guu. ");
INSERT INTO bus_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Kɛ̀ ma ka lↄ̀gↄ kiia gbã̀a ma bè: Dii, ma dii Ibraĩ Luda, tó n we, ǹ tó ma tá kɛ nna. ");
INSERT INTO bus_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Má kú lↄ̀gↄ lɛ́a. Nↄkparɛ kɛ̀ mↄ̀ í tↄ́, ben ma bènɛ à ma gba í féte mà mi, ");
INSERT INTO bus_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","tó à bè mà mi, ben à tↄ̀ ma lakuminↄnɛ dↄ, mɛ́ dↄ̃ kɛ̀ nↄkparɛ kɛ̀ ń dìɛ à kɛ ma dii nɛ́ pↄ́ ũun gwe. ");
INSERT INTO bus_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ai màgↄ̃ yã pì o ma nↄ̀sɛ guu mà yãa, ben Rɛbɛka bↄ̀ kↄ̃n looo dina a gã̀n à mↄ̀ lↄ̀gↄ lɛ́a à í tↄ̀. Ben ma bènɛ à ma gba í mà mi. ");
INSERT INTO bus_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","À a loo pìta gↄ̃ↄ, à bè mà mi, é kpá ma lakuminↄa dↄ. Kɛ̀ má mì, ben à kpà ma lakuminↄa. ");
INSERT INTO bus_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ben ma à là, dé nɛ́n à ũu? À bè Bɛtuɛli nɛ́n a ũ, Milika kↄ̃n Nao dio. Ben ma tãnga dànɛ a yĩa, ma zãa dànɛ a ↄↄnↄa. ");
INSERT INTO bus_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ben ma kuɛ ma dↄnzi kɛ̀ Dii ma dii Ibraĩ Ludanɛ ma sáabu kpàa, zaakɛ à dↄ̀mɛ aɛ zɛ́ maaa guu, lɛ mà a dii vĩ̀i dio sɛ́ à nɛ́nɛ. ");
INSERT INTO bus_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Tia sa tó é we à gbɛ̃kɛ kↄ̃n náanɛo yã kɛ ma diinɛ, à omɛ. Tó ée we sↄ̃ro, à omɛ, mɛ́ gá gu pãndea. ");
INSERT INTO bus_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Labã kↄ̃n Bɛtuɛlio wèàla wà bè: Yã pì bↄ̀ Dii kiiamɛ, wá yãke ona vĩro, à maaa ke à zaaa. ");
INSERT INTO bus_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rɛbɛkan yɛ̀, ǹ à sɛ́ ǹ táo, à gↄ̃ n dii nɛ́ naↄ̃ ũ lán Dii ò nà. ");
INSERT INTO bus_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Kɛ̀ Ibraĩ zↄ̀bleri pì ń yã mà, à dàɛ tↄↄtɛ Diinɛ. ");
INSERT INTO bus_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ben à zãblebↄ kɛ̀ wà kɛ̀ kↄ̃n kondogio kↄ̃n vurao kↄ̃n pↄ́kãsãanↄ bↄ̀ɛ à kpà Rɛbɛkaa. À à vĩ̀i kↄ̃n à dao gbà pↄ́ ↄↄdeenↄ dↄ. ");
INSERT INTO bus_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ben àpi kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ kúonↄ pↄ́ blè aↄ̃ í mì, ben aↄ̃ ì gwe. Kɛ̀ aↄ̃ fɛ̀ɛ kↄngↄ à bè: À ma gbarɛ mà tá ma diizi. ");
INSERT INTO bus_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Nↄↄ vĩ̀i kↄ̃n à dao bè: Ǹ tó nɛ́ pì gↄ̃wao baa gurↄ kuri, é gbasa à tá. ");
INSERT INTO bus_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ben gↄ̃gbɛ̃ pì bèńnɛ: Lán Dii ma tá kɛ̀ nna nà lán kɛ̀ bà, àton ma dãdã dↄro. À ma gbarɛ mà tá ma dii kiia. ");
INSERT INTO bus_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ben aↄ̃ bè: Wà nɛ́ pì sísi wà à la. ");
INSERT INTO bus_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ben wà Rɛbɛka sìsi wà à là wà bè: Nɛ́ tá kↄ̃n gbɛ̃ pìoↄ́? Ben Rɛbɛka bè: Mɛ́ táo. ");
INSERT INTO bus_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ben aↄ̃ Rɛbɛka gbàrɛ kↄ̃n gwàri kɛ̀ à à gwà zaa à nɛ́ngo zĩo, aↄ̃ↄe taa kↄ̃n Ibraĩ zↄ̀blerio kↄ̃n à gbɛ̃nↄ. ");
INSERT INTO bus_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Aↄ̃ sa maaa ò Rɛbɛkanɛ wà bè: Nɛ́, ǹ gↄ̃ gbɛ̃ pariinↄ dazi ũ, n boriinↄ gↄ̃ gbãa vĩ ń zangurinↄa. ");
INSERT INTO bus_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ben Rɛbɛka fɛ̀ɛ kↄ̃n a nↄgbɛ̃ zĩkɛrinↄ, aↄ̃ dì lakuminↄ kpɛɛ aↄ̃ↄ tɛ́ gↄ̃gbɛ̃ pìzi, ben à tàńyo. ");
INSERT INTO bus_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","À mↄ̀ à lè Isaaku sù kↄ̃n lↄ̀gↄ kɛ̀ wè be Ludabɛ̃ɛkɛema'eeo à vɛ̃̀ɛ Nɛgɛvi bùsun. ");
INSERT INTO bus_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","À bↄ̀ à gàa à laasuu lɛ́ sɛ̃̀n uusiɛ, ben kɛ̀ à wɛ́ɛ sɛ̀, à è lakuminↄↄ e mↄↄ. ");
INSERT INTO bus_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rɛbɛka wɛ́ɛ sɛ̀ à Isaaku è se, ben à pìta a lakumi kpɛɛ kpakpaa ");
INSERT INTO bus_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","à zↄ̀bleri pì là à bè: Dén gↄ̃gbɛ̃ kɛ̀ èe táa oo sɛ̃̀n èe mↄↄ dawalɛ kãaa ũu? Ben zↄ̀bleri pì wèàla à bè: Ma diimɛ. Ben Rɛbɛka a pↄ́dangãn sɛ̀ à kù a uua. ");
INSERT INTO bus_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Kɛ̀ aↄ̃ kà Isaaku kiia, zↄ̀bleri yã kɛ̀ à kɛ̀ tↄ̃kɛ̃̀nɛ píngi. ");
INSERT INTO bus_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaaku gɛ̃̀ kↄ̃n Rɛbɛkao a da Sara bisakutaan, ben à à sɛ̀ à gↄ̃̀ à nↄↄ ũ. À ye nↄↄ pìzi, ben à làakari kpaɛna a da gaa gbɛra. ");
INSERT INTO bus_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ibraĩ nↄ pãnde sɛ̀ dↄ à tↄ́n Kɛtura. ");
INSERT INTO bus_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Nɛ́ kɛ̀ à ìonↄ tↄ́n yɛ̀: Zimara, Yↄkↄsã, Mɛdã, Midiã, Isibaki, Sua. ");
INSERT INTO bus_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yↄkↄsã bé à Seba kↄ̃n Dedão ì. Dedã boriinↄn Asunↄ kↄ̃n Lɛtusinↄ kↄ̃n Lɛuminↄ ũ. ");
INSERT INTO bus_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiã nɛ́gↄ̃gbɛ̃nↄ tↄ́n yɛ̀: Efa, Ɛfa, Anↄku, Abida, Ɛlɛda. Aↄ̃ píngi Kɛtura boriinↄmɛ. ");
INSERT INTO bus_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibraĩ a auziki kpà Isaakua píngi, ");
INSERT INTO bus_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ben à gba dà a nↄ yìgisai nɛ́nↄnɛ à ń gbáɛ ↄfãntɛ̃bↄɛ kpa lɛ à kpɛ́ à ga, lɛ aↄ̃tongↄ̃ kú kↄ̃n Isaakuoro yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ibraĩ kɛ̀ wɛ̃̀ bakɛ̃ndo sↄↄrosai, ");
INSERT INTO bus_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ben à gà. À zi kũ̀ kótokoto, gbasa à kà a gbɛ̃nↄla gɛ̀wãa. ");
INSERT INTO bus_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","À nɛ́nↄ Isaaku kↄ̃n Sumailao à vĩ̀i Makpɛla gbɛ̀wɛɛ guu, Mamare ↄfãntɛ̃bↄɛ kpa, buraa kɛ̀ dɛ Iti bori Zoa nɛ́ Ɛflↄnu pↄ́ ũ yã ");
INSERT INTO bus_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","kɛ̀ Ibraĩ pì lù Itinↄa. Gwen wà à vĩ̀in kↄ̃n a naↄ̃ Sarao. ");
INSERT INTO bus_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ibraĩ gana gbɛra Luda aubarika dà à nɛ́ Isaakun. À vɛ̃ɛna Ludabɛ̃ɛkɛema'ee lↄ̀gↄ saɛ. ");
INSERT INTO bus_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ibraĩ nɛ́ Sumaila boriinↄ yãn yɛ̀. Sara zĩkɛri Agyara, Igipiti nↄgbɛ̃ bé à nɛ́ pì ìo. ");
INSERT INTO bus_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Sumaila nɛ́gↄ̃gbɛ̃nↄ tↄ́n yɛ̀ lán wà ń í nà. À daudu tↄ́n Nɛbayo. À dãaronↄ tↄ́n yɛ̀: Keda, Adabɛli, Mibisamu, ");
INSERT INTO bus_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misima, Duma, Masa, ");
INSERT INTO bus_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Adada, Tema, Yetu, Nafisi kↄ̃n Kedemao. ");
INSERT INTO bus_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Sumaila nɛ́gↄ̃gbɛ̃nↄ tↄ́n gwe. Aↄ̃ baade a tↄ́ kpà a lakutu ke a bùranɛ. Aↄ̃mbe à bori kuri awɛɛplaaanↄ kínanↄ ũ. ");
INSERT INTO bus_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Sumaila kɛ̀ wɛ̃̀ baswɛɛdo akuri awɛɛswɛɛplaa, ben à gà à kà a gbɛ̃nↄla gɛ̀wãa. ");
INSERT INTO bus_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","À boriinↄ vɛ̃̀ɛ zaa Avila ai à gàa pɛ́ Surua, Igipiti ↄfãntɛ̃bↄɛ kpa gana Asiria bùsu kpa. Aↄ̃è kↄ̃ tɛ́ kpákpa kↄ̃n Ibraĩ bori kpaaanↄro. ");
INSERT INTO bus_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ibraĩ nɛ́ Isaaku boriinↄ yãn yɛ̀. Ibraĩ Isaaku ì. ");
INSERT INTO bus_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Kɛ̀ Isaaku kà wɛ̃̀ baplaa, ben à Labã dãre Rɛbɛka sɛ̀. Àmbe Siria bùsu gbɛ̃ Bɛtuɛli kɛ̀ bↄ̀ Mɛsↄpↄtamia bùsun nɛ́ ũ. ");
INSERT INTO bus_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaaku wɛ́ɛ kɛ̀ Diia a naↄ̃nɛ, zaakɛ pãaamɛ, ben Dii à adua sì, à naↄ̃ pì nↄ̀ sì. ");
INSERT INTO bus_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Sìkanↄↄ e ↄsi kaa à gbɛɛɛn, ben à bè: Bↄ́yãnzi yã beee taka ma lezi? Ben à gàa à Dii là. ");
INSERT INTO bus_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Dii bènɛ: Bori mɛ̀n plaaa kú n nɛ́'isↄn, gↄ̃ↄn plaaa kɛ̀ aↄ̃ↄ kú n gbɛɛɛn pìnↄ é kɛ̃kↄ̃a. Bori mɛ̀n doo gbãaa égↄ̃ dɛ a doola, à kɛ̀ bↄ̀ káaku égↄ̃ zↄ̀ nɛ́ ũ zãanɛ. ");
INSERT INTO bus_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Kɛ̀ à nɛ́'igurↄↄ kà, ben à sìkanↄ ì gↄ̃gbɛ̃nↄ ũ. ");
INSERT INTO bus_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Kɛ̀ gbɛ̃ káaku e bↄↄ, à bↄ̀ tɛ̃ɛ zónzon. À mɛ̀kã vĩ lán uta kãdee bà, ben wà tↄ́ kpànɛ Isau. ");
INSERT INTO bus_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Beee gbɛra kɛ̀ nɛ́ plaadee e bↄↄ, à dↄ̀ Isau gbátogea, ben wà tↄ́ kpànɛ Yakubu. Isaaku wɛ̃̀ baaagↄ̃dee guun à nɛ́ pìnↄ ì. ");
INSERT INTO bus_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Nɛ́ pìnↄ bíta kũ̀. Isau kɛ̀ tofekari gbãaa kɛ̀ è kɛ̃ sɛ̃̀tɛaroo ũ. Yakubu sↄ̃ bɛgwarimɛ. ");
INSERT INTO bus_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaaku ye Isauzi kɛ̀ à nↄ̀bↄ lóu vĩ yãnzi. Rɛbɛka sↄ̃ↄ ye Yakubuzi. ");
INSERT INTO bus_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Zĩkea Yakubu e dò kukuu, ben Isau sù kↄ̃n sɛ̃̀tɛo nↄaa e à dɛɛ. ");
INSERT INTO bus_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ben à bè Yakubunɛ: N yã nna! Ǹ tó mà dò tɛ̃a beee ble, zaakɛ nↄaa e ma dɛɛmɛ. Beee yãnzi wà tↄ́ kpà Isaunɛ Ɛdↄmu. ");
INSERT INTO bus_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakubu bè: Ǹ n daudukɛzɛ kpáma gĩa. ");
INSERT INTO bus_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ben Isau bè: Má kú gaa lɛ́zĩ, bↄ́n ma daudukɛzɛ é kɛmɛɛ? ");
INSERT INTO bus_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ben Yakubu bènɛ: Ǹ lù sɛ́mɛ gĩa. Ben à lù sɛ̀nɛ à a daudukɛzɛ kpàa. ");
INSERT INTO bus_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ben Yakubu burɛdi kpàa kↄ̃n bládo pìo. À blè à í mì, ben à fɛ̀ɛ à bↄ̀. Lɛmɛ Isau kɛ̀ lɛ, à a daudukɛzɛ dìɛ pã. ");
INSERT INTO bus_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Dekaa kà bùsu pìn à káakupↄ kɛ̀ kà Ibraĩ gurↄↄ baasi, ben Isaaku fɛ̀ɛ à gàa Filisitininↄ kí Abimɛlɛki kiia Gera. ");
INSERT INTO bus_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ben Dii bↄ̀ à mↄ̀zi à bè: Ǹton tá Igipitiro, ǹ vɛ̃ɛ guu kɛ̀ mɛ́ onnɛɛn. ");
INSERT INTO bus_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ǹgↄ̃ kú bùsu kɛ̀kiin gĩa, mɛ́gↄ̃ kúnyo mà aubarika kɛnnɛ. Mɛ́ bùsu kɛ̀kii kpámma píngi kↄ̃n n boriinↄ, mɛ́ lù kɛ̀ má sɛ̀ n denɛ papannɛ. ");
INSERT INTO bus_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Mɛ́ n borii kaara lán sↄsↄnɛnↄ bà, mɛ́ bùsu kɛ̀kii kpáḿma píngi. Borii kɛ̀ aↄ̃ↄ kú tↄↄtɛnↄ é aubarika e n borii gãzĩ ń píngi ");
INSERT INTO bus_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","kɛ̀ Ibraĩ ma yã mà yãnzi. À ma ↄdↄkii gwà, ben à yã kɛ̀ má dìɛnↄ kũna kↄ̃n ma yãdannɛnanↄ kↄ̃n ma dokayãnↄ. ");
INSERT INTO bus_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ben Isaaku gↄ̃̀ Gera. ");
INSERT INTO bus_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Kɛ̀ wɛ́tɛ pì deenↄↄ e à laa à naↄ̃ yã musu, à bè a dãremɛ. Èe vĩa kɛɛ, zaakɛ èe daa tó à bè a naↄ̃mɛ, weé a dɛ nↄↄ pì yãnzi, zaakɛ nↄↄ pì nɛ́ nↄ maaamɛ. ");
INSERT INTO bus_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Kɛ̀ a gurↄplaa kɛ̀ gwe, Filisitininↄ kí Abimɛlɛki wɛ́ɛ kpàɛ windo guu, ben à è Isaaku e bↄ̃̀nda gaa kↄ̃n a naↄ̃o. ");
INSERT INTO bus_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ben à Isaaku sìsi à bè: Ase n naↄ̃mɛɛ! À kɛ̀ dia n bè n dãremɛ? À wèàla à bè: Mɛ́ɛ kpákpaa weé ma dɛ à yãnzimɛ. ");
INSERT INTO bus_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimɛlɛki bè: Bↄ́ yã ń kɛ̀we lɛɛ? Féte bé à gↄ̃̀ kɛ̀ wa gbɛ̃ke é daɛ kↄ̃n n nↄↄ pìo, lɛ ǹ wa da taarin. ");
INSERT INTO bus_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ben Abimɛlɛki gbɛ̃nↄ swã sùkãńnɛ píngi à bè: Gbɛ̃ kɛ̀ ↄ kɛ̀ gↄ̃gbɛ̃ pìa kↄ̃n à naↄ̃o, weé à dɛ. ");
INSERT INTO bus_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaaku pↄ́ tↄ̃̀ bùsu pìn, ben à pↄ́ è wɛ̃̀ beeea lɛo basↄↄro, kɛ̀ Dii aubarika dàn yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","À kàara, à auziki e kaara ai à kɛ̀ auzikide bíta ũ. ");
INSERT INTO bus_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","À sãanↄ kↄ̃n zùnↄ vĩ pari kↄ̃n zↄ̀nↄ, ben Filisitininↄ zàn. ");
INSERT INTO bus_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ben aↄ̃ lↄ̀gↄ kɛ̀ à de Ibraĩ gbɛ̃nↄ yↄ̃̀ a gurↄↄanↄ tàta bùsuo píngi. ");
INSERT INTO bus_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ben Abimɛlɛki bè Isaakunɛ: Ǹ fɛɛ wa kiia, zaakɛ ń gbãaa dɛwala maamaa. ");
INSERT INTO bus_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ben Isaaku bↄ̀ gwe à bùra kàɛ Gera guzurɛn, ben à gurↄplaa kɛ̀ gwe. ");
INSERT INTO bus_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Lↄ̀gↄ kɛ̀ wà yↄ̃̀ à de Ibraĩ gurↄↄa ben Filisitininↄↄ tàta à de gaa gbɛraanↄn à ɛ̀ara à bↄ̀bↄ à tↄ́ dↄ̃nkↄ̃ kɛ̀ a de kpàńnɛ yãanↄ kpàńnɛ dↄ. ");
INSERT INTO bus_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isaaku zↄ̀blerinↄ lↄ̀gↄ pãnde yↄ̃̀ guzurɛ pìn, ben aↄ̃ bↄ̀ í maaaa. ");
INSERT INTO bus_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ben Gera pↄ́dãrinↄ swèe kɛ̀ kↄ̃n Isaaku pↄ́dãrinↄ wà bè: Wa ímɛ. Ben à tↄ́ kpà lↄ̀gↄ pìnɛ Swèe, kɛ̀ aↄ̃ swèe kɛ̀o yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Aↄ̃ lↄ̀gↄ pãnde yↄ̃̀, ben wà swèe kɛ̀ lↄ̀gↄ pì yã musu dↄ, ben à tↄ́ kpànɛ Íbɛtɛ. ");
INSERT INTO bus_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","À bↄ̀ gwe, ben à lↄ̀gↄ pãnde yↄ̃̀ dↄ, aↄ̃ↄe swèe kɛ à yã musu dↄro. Ben à tↄ́ kpànɛ Mɛ̀porokii, zaakɛ à bè: Dii tò wa mɛ̀ pòro, wé dagula sa. ");
INSERT INTO bus_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Beee gbɛra à gàa Bɛsɛba. ");
INSERT INTO bus_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Dii bↄ̀ à mↄ̀zi gwãavĩ beeea à bè: Mámbe n de Ibraĩ Luda ũ, ǹton vĩa kɛro, zaakɛ má kúnyo. Mɛ́ aubarika kɛnnɛ mà n borii kaara ma zↄ̀bleri Ibraĩ yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Gwen à sa'okii bòn à Dii sìsi. Ben à bùra kàɛ gwe à gbɛ̃nↄↄ e lↄ̀gↄ yↄ̃ↄ. ");
INSERT INTO bus_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ben Abimɛlɛki bↄ̀ Gera à mↄ̀ Isaaku kiia kↄ̃n a kpàasi Auzao kↄ̃n a zĩ̀kpɛɛnↄ gbɛ̃nsi Fikↄluo. ");
INSERT INTO bus_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaaku ń lá à bè: Kɛ̀ a zamagu a pɛma a bɛ, à kɛ̀ dia a mↄ ma kiia? ");
INSERT INTO bus_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Aↄ̃ wèàla wà bè: Wá è Dii kúnyo, ben wa bè à maa wà lɛdolɛ kɛ wà lù sɛ́kↄ̃nɛ à yã musu ");
INSERT INTO bus_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","kɛ̀ nɛ́ yã zaa ke kɛwero, zaakɛ wée wɛ́ɛ tãmmaro. Yã maaan wá kɛ̀nnɛ wa n gbarɛ aafia, ben Dii aubarika kɛ̀nnɛ. ");
INSERT INTO bus_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ben Isaaku ń yàari kɛ̀, aↄ̃ pↄ́ blè aↄ̃ í mì. ");
INSERT INTO bus_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kɛ̀ aↄ̃ fɛ̀ɛ kↄngↄ, aↄ̃ lù sɛ̀kↄ̃nɛ, ben Isaaku zɛ̀ńnɛ, aↄ̃ bↄ̀ à kiia aafia. ");
INSERT INTO bus_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Zĩ beeea Isaaku gbɛ̃nↄ mↄ̀ wà lↄ̀gↄ kɛ̀ aↄ̃ↄ yↄ̃̀ yã ònɛ wà bè: Wa í è. ");
INSERT INTO bus_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ben à tↄ́ kpànɛ Sɛba. Beee yãnzin wè wɛ́tɛ pì sísi Bɛsɛba ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Kɛ̀ Isau kà wɛ̃̀ baplaa, à Iti nↄↄ sɛ̀ mɛ̀n plaa, Beri nɛ́ Yudi kↄ̃n Ɛlↄni nɛ́ Basɛmao. ");
INSERT INTO bus_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Isaaku kↄ̃n Rɛbɛkao nↄ̀sɛ ègↄ̃ yakana ń yãnzimɛ. ");
INSERT INTO bus_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaaku zi kũ̀ à wɛ́ɛ gbãa dↄro, èe guu ee maaro. Ben à a daudu sìsi à bè: Nɛ́! Ben à wèàla à bè: Maɛ kɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaaku bè: Ma zi kũ̀ má a gagurↄↄ dↄ̃ro. ");
INSERT INTO bus_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ǹ n sá sɛ́ kↄ̃n n gbàrao ǹ gá ǹ nↄ̀bↄsɛ̃tɛ wɛtɛmɛ. ");
INSERT INTO bus_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ǹ ma pↄyezi dò kuku ǹ mↄ́omɛ mà ble, mɛ́ sa'olɛ kɛnnɛ lɛ mà kpɛ́ mà ga. ");
INSERT INTO bus_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rɛbɛka yã kɛ̀ Isaaku ò Isaunɛ pì mà. Kɛ̀ Isau fɛ̀ɛ à gàa tofe ká, ");
INSERT INTO bus_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ben à gàa à ò Yakubunɛ à bè: Má mà n de yã ò n vĩ̀inɛ à bè ");
INSERT INTO bus_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","à gá à nↄ̀bↄ dɛare à a pↄyezi dò kukuoare à ble, é sa'olɛ kɛnɛ kↄ̃n Dii tↄ́o lɛ á kpɛ́ à ga. ");
INSERT INTO bus_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ben Rɛbɛka ɛ̀ara à bènɛ: Ǹ ma yã ma ǹ yã kɛ̀ má dànnɛɛ kɛ. ");
INSERT INTO bus_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ǹ gá blè kpàsa guu ǹ blènɛ maaa kũ mɛ̀n plaa ǹ suo. Mɛ́ n de pↄyezi dò kukunɛ, ");
INSERT INTO bus_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","nɛ́ gáonɛ à ble, eé sa'olɛ kɛnnɛ lɛ à kpɛ́ à ga. ");
INSERT INTO bus_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ben Yakubu bè a danɛ: Ma vĩ̀i mɛ̀kã vĩ, ben ma mɛ̀ pↄ́rↄpↄrↄ. ");
INSERT INTO bus_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Tó ma de ↄ kɛ̀ma, tó à ma dↄ̃, eé be mɛ́ɛ a kɛɛ pãpãmɛ, eé lɛ́ kɛmɛ sa'olɛ gɛ̃ɛ ũ. ");
INSERT INTO bus_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ben à da bènɛ: Luda tó lɛ́kɛnannɛɛ pì gↄ̃mɛ. Ǹ ma yã ma dé! Ǹ gá ǹ dɛ ǹ suomɛ. ");
INSERT INTO bus_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ben Yakubu gàa à blè pìnↄ dɛ̀ à sùo a danɛ, ben à à de pↄyezi dò kùkunɛ. ");
INSERT INTO bus_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ben à a daudu pↄ́kãsã maaa kɛ̀ kú a kpɛ́ guunↄ sɛ̀ à dà a nɛ́ sabideenɛ. ");
INSERT INTO bus_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","À blènɛ báa pìnↄ fĩ̀fĩ à ↄↄnↄa kↄ̃n à waa pↄ́rↄpↄrↄo. ");
INSERT INTO bus_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ben à dò kↄ̃n burɛdi kɛ̀ à kɛ̀o kpàa. ");
INSERT INTO bus_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakubu gàa a de kiia à bè: Baa! Ben à de bè: Maɛ kɛ̀! Ma nɛ́ kpareemɛ? ");
INSERT INTO bus_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakubu wèàla à bè: Mámbe Isau n daudu. Lán ń òmɛ nà, má kɛ̀ lɛ. Ǹ fɛɛ ǹ vɛ̃ɛ ǹ ma ↄzĩi ble lɛ ǹ sa'olɛ kɛmɛ. ");
INSERT INTO bus_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ben Isaaku bè a nɛ́nɛ: O'o! Ń è kↄ̀ↄ́? À wèàla à bè: Dii n Luda bé à ma tá kɛ̀ nna. ");
INSERT INTO bus_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ben Isaaku bènɛ: Ǹ sↄ̃mazi mà ↄ kɛmma lɛ mà dↄ̃ tó ma nɛ́ Isaumɛ yãpura. ");
INSERT INTO bus_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakubu sↄ̃̀ a dezi, ben à ↄ kɛ̀a à bè: Kòto kɛ̀kii nɛ́ Yakubu kòtomɛ, ↄↄ kɛ̀kii sↄ̃ Isau ↄↄmɛ. ");
INSERT INTO bus_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ben èe à dↄ̃ro, kɛ̀ à ↄↄnↄ kã vĩ lán Isau pↄ́ bà yãnzi. À yezi à sa'olɛ kɛnɛ, ");
INSERT INTO bus_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ben à à là gĩa: Ma nɛ́ Isaun n ũ yãpuraↄ́? À wèàla à bè: Mámbee! ");
INSERT INTO bus_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ben à bè: Ǹ pↄ́ kpáma mà n ↄzĩi ble, mɛ́ sa'olɛ kɛnnɛ. Kɛ̀ à dìɛnɛ, ben à blè. À mↄ̀nɛ kↄ̃n wɛ̃ɛo, à mì dↄ. ");
INSERT INTO bus_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ben à de pì bènɛ: Ǹ sↄ̃mazi ǹ lɛ́ pɛ́ma. ");
INSERT INTO bus_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ben à sↄ̃̀zi à lɛ́ pɛ̀a. Kɛ̀ Isaaku à pↄ́kãsãanↄ gũu mà, ben à sa'olɛ kɛ̀nɛ à bè: Ma nɛ́ gũu dɛ lán buraa kɛ̀ Dii aubarika dàn bà. ");
INSERT INTO bus_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Luda n gba mↄdↄ bↄna musu, à n gba tↄↄtɛ maaa. Blɛwɛɛ kↄ̃n geepiwɛ̃ɛo égↄ̃ dinzi. ");
INSERT INTO bus_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Gbɛ̃nↄ é zↄ̀ blennɛ, boriinↄ é kúɛ n aɛ, nɛ́gↄ̃ dɛ n gbɛ̃nↄ dii ũ, n da nɛ́nↄ é kúɛnnɛ. Luda é lɛ́ kɛ gbɛ̃ kɛ̀ aↄ̃ lɛ́ kɛ̀nnɛɛnↄnɛ, eé aubarika da gbɛ̃ kɛ̀ aↄ̃ sa maaa ònnɛɛnↄn. ");
INSERT INTO bus_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Kɛ̀ Isaaku sa'olɛ kɛ̀ Yakubunɛ à yã̀a, ben Yakubu gù à kiia. Kɛ̀ à vĩ̀i sù kↄ̃n tofekao gↄ̃ↄ, ");
INSERT INTO bus_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ben à pↄ́blee kɛ̀ a denɛ dↄ à gàaonɛ, ben à bènɛ: Baa! Ǹ fɛɛ ǹ ma ↄzĩi ble ǹ sa'olɛ kɛmɛ. ");
INSERT INTO bus_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ben à de à là à bè: Ḿbe dé ũu? À wèàla à bè: Mámbe n daudu Isau. ");
INSERT INTO bus_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Yã pì Isaaku swɛ̃̀ zↄ̃̀ èe lugalugaa à bè: Dé bé à nↄ̀bↄ dɛ̀ à mↄ̀omɛ yã ai ǹgↄ̃ gá su má sò? Ma sa'olɛ kɛ̀nɛ kↄ̀, àmbe eé aubarika e. ");
INSERT INTO bus_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Kɛ̀ Isau a de yã pì mà, à pũ̀tã à ↄ́ gbãaa dↄ̀ à kɛ̀ wɛ̃nda, ben à bè: Baa! Ǹ sa'olɛ kɛmɛ dↄ. ");
INSERT INTO bus_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ben à bè: N dãaro mↄ̀ kↄ̃n ↄ̃ndↄ̃ↄo à n sa'olɛ sì kↄ̀. ");
INSERT INTO bus_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ben Isau bè: À tↄ́n Yakuburoo? À ma kɛkɛ à kɛ̀ gɛ̃̀n plaan gwe sa. À ma daudukɛzɛ sìma yã, ben à ma sa'olɛ sìma tia dↄ. Mɛ́ sa'olɛ e dↄroↄ́? ");
INSERT INTO bus_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaaku wèàla à bè: Ma à dìɛ n dii ũ, ma à danɛnↄ kɛ̀ à zↄ̀blerinↄ ũ ń píngi, ma blɛwɛɛ kↄ̃n geepiwɛ̃ɛo kpàa. Bↄ́n mɛ́ e mà kɛnnɛ dↄↄ? ");
INSERT INTO bus_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Isau bè a denɛ: Baa, sa'olɛ beeen ń vĩ adoↄ́? Ǹ sa'olɛ pãnde kɛmɛ dↄ Baa. Ben Isau wii gbãaa lɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ben à de wèàla à bè: Tↄↄtɛ kɛ̀ nɛ́gↄ̃ kún égↄ̃ maaro, mↄdↄ é bↄnnɛ zaa musuro. ");
INSERT INTO bus_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Nɛ́gↄ̃ fɛ̃ɛda kũna, nɛ́ zↄ̀ ble n dãaronɛ. Lɛmɛ dↄ n làakari é gↄ̃ kpaɛnaro, nɛ́ à gbóngo gonla. ");
INSERT INTO bus_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Isau íbɛtɛ sɛ̀ kↄ̃n Yakubuo sa'olɛ kɛ̀ à de kɛ̀nɛ yãnzi, ben à bè a nↄ̀sɛ guu: Ma de gaa zã̀ro, gbasa mɛ́ ma dãaro dɛ. ");
INSERT INTO bus_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Wà yã kɛ̀ Isau ò kↄↄmↄtↄ kɛ̀ Rɛbɛkanɛ, ben à Yakubu sìsi à bè: Isau yezi à gɛ̃ɛ bomma à n dɛ. ");
INSERT INTO bus_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ǹ ma yã ma sa. Ǹ fɛɛ ǹ baalɛ ǹ gá ma dãgↄ̃ Labã bɛ zaa Arana ");
INSERT INTO bus_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ǹgↄ̃ kúo gwe gĩa ai n vĩ̀i pì pↄfɛ̃ kpáɛ. ");
INSERT INTO bus_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Tó à nↄ̀sɛ kpàɛ, tó yã kɛ̀ ń kɛ̀nɛ sã̀n, mɛ́ gbɛ̃ zĩ wà n gbɛ̀ sɛ́. Má yezi mà kora a gↄ̃ↄn plaaanↄzi píngi gurↄ doro. ");
INSERT INTO bus_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ben Rɛbɛka bè Isaakunɛ: Iti nↄgbɛ̃nↄ nii bↄ̀magu. Tó Yakubu Iti nↄↄ sɛ̀ bùsu kɛ̀kiin lán Isau nↄgbɛ̃ beeenↄ bà, ma kuuna égↄ̃ nnamɛ dↄro. ");
INSERT INTO bus_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ben Isaaku Yakubu sìsi à sa'olɛ kɛ̀nɛ à yã dànɛ à bè: Ǹton nↄↄ sɛ́ Kanaa nↄgbɛ̃nↄ tɛ́ro. ");
INSERT INTO bus_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ǹ fɛɛ ǹ gá Mɛsↄpↄtamia bùsun n da de Bɛtuɛli bɛ, ǹ nↄↄ sɛ́ gwe n desɛ̃ Labã nɛ́nↄ tɛ́. ");
INSERT INTO bus_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Luda Gbãapingide aubarika dangu à tó ǹ nɛ́ i maamaa, aↄ̃gↄ̃ kaara lɛ ǹ gↄ̃ boriinↄ dezi ũ. ");
INSERT INTO bus_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Luda aubarika kɛ̀ à dà Ibraĩn dangu kↄ̃n n boriinↄ, lɛ bùsu kɛ̀ nɛ́ɛ nibↄ bleen gↄ̃nnɛ, bùsu kɛ̀ à kpà Ibraĩa. ");
INSERT INTO bus_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ben Isaaku Yakubu gbàrɛ à gá Labã kiia Mɛsↄpↄtamia bùsun. Labã nɛ́ Siria bùsu gbɛ̃ Bɛtuɛli nɛ́mɛ, Yakubu kↄ̃n Isauo desɛ̃mɛ. ");
INSERT INTO bus_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Isau mà Isaaku sa'olɛ kɛ̀ Yakubunɛ à à gbàrɛ Mɛsↄpↄtamia lɛ à nↄↄ sɛ́ gwe. Kɛ̀ à sa'olɛ pì kɛ̀nɛ, à bè àton nↄↄ sɛ́ Kanaa nↄgbɛ̃nↄ tɛ́ro. ");
INSERT INTO bus_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","À tàasi kɛ̀ kɛ̀ Yakubu a de kↄ̃n a dao yã mà à dà Mɛsↄpↄtamia zɛ́n. ");
INSERT INTO bus_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ben à dↄ̃̀ sa kɛ a de pↄↄ nna kↄ̃n Kanaa bùsu nↄgbɛ̃nↄro. ");
INSERT INTO bus_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ben à gàa Ibraĩ nɛ́ Sumaila kiia à à nɛ́ Maala sɛ̀ à nà a nↄ káakunↄa. Maala nɛ́ Nɛbayo dãremɛ. ");
INSERT INTO bus_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakubu bↄ̀ Bɛɛsɛba à dà Arana zɛ́n. ");
INSERT INTO bus_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Kɛ̀ à kà gukea, à yezi à i gwe kɛ̀ ↄfãntɛ̃ gɛ̃̀ kpɛ́n yãnzi. Ben à gbɛ̀ sɛ̀ guu pìn a mìdibↄ ũ à dàɛ gwe. ");
INSERT INTO bus_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ben à nanaa ò à gára è pɛɛna tↄↄtɛ ai à gàa à zↄ̃̀ ludambɛɛa, Luda malaikanↄↄ e didiia aↄ̃ↄe pitaa. ");
INSERT INTO bus_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","À Dii è zɛnaala à bè: Mámbe Dii n dezi Ibraĩ kↄ̃n n de Isaakuo Luda ũ. Mɛ́ bùsu kɛ̀ ń daɛa kɛ̀ki kpámma, mpi kↄ̃n n boriinↄ. ");
INSERT INTO bus_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","N boriinↄ égↄ̃ pari lán bùsuti bà, aↄ̃é dagula ↄfãntɛ̃bↄɛ kpa kↄ̃n ↄfãntɛ̃gɛ̃kpɛn-o kↄ̃n gu'igbãrooo kↄ̃n sↄↄmɛtɛo. Anduna bori píngi é aubarika e mpi kↄ̃n n boriio gãzĩ. ");
INSERT INTO bus_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mɛ́gↄ̃ kúnyo, mɛ́gↄ̃ n dãkpaa guu kɛ̀ nɛ́ɛ gaan píngi, mɛ́ ɛara mà sunyo bùsu kɛ̀kiin, zaakɛ mɛ́ n tónlo mɛ́ yã kɛ̀ má ònnɛɛ kɛ. ");
INSERT INTO bus_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Kɛ̀ Yakubu vù kↄ̃n iio à bè: Dii kú gura kɛ̀, ben mɛ́ɛ dↄ̃ro! ");
INSERT INTO bus_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Vĩa à kũ̀ à bè: Guu kɛ̀ ma kã fɛ̀ɛ. Luda bɛɛmɛ, ludambɛ zɛ́mɛ. ");
INSERT INTO bus_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yakubu fɛ̀ɛ kↄngↄ à gbɛ̀ kɛ̀ à kɛ̀ mìdibↄ ũu pì sɛ̀ à pɛ̀ɛ dↄngupↄ ũ, ben à nↄ́si kùa. ");
INSERT INTO bus_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ben à tↄ́ kpà guu pìnɛ Bɛtɛli, mↄde wɛ́tɛ kɛ̀ wà kàɛ gwe tↄ́ káakun Luzu. ");
INSERT INTO bus_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yakubu lù sɛ̀ Diinɛ à bè: Tó ń kúmao, tó nɛ́ ma dãkpa ma wɛ́tɛ kɛ̀kii gana guu, tó nɛ́ ma gba pↄ́blee kↄ̃n pↄ́kãsãanↄ ");
INSERT INTO bus_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ai ma gaa ma su ma de bɛ aafia, nɛ́gↄ̃ dɛ ma Luda ũ, ");
INSERT INTO bus_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","gbɛ̀ kɛ̀ má pɛ̀ɛ dↄngupↄ ũu pì é gↄ̃ n gbãgbãkii ũ, pↄ́ kɛ̀ n ma gba píngi, mɛ́ à kuridee kpámma. ");
INSERT INTO bus_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakubu ɛ̀ara à dà zɛ́n à gàa ↄfãntɛ̃bↄɛkpadeenↄ bùsun. ");
INSERT INTO bus_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Kɛ̀ à kà gwe, à lↄ̀gↄ è sɛ̃̀n sã kpàsa lɛo aagↄ̃ kaɛna à saɛ, zaakɛ lↄ̀gↄ pì ín wè kpáḿma. Gbɛ̀ bíta tatana lↄ̀gↄ pìlɛ. ");
INSERT INTO bus_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Tó kpàsa pìnↄ kàkↄ̃a gwe píngi, ben wè gbɛ̀ pì go lↄ̀gↄ pìlɛ wà í kpáḿma, ben wè ɛara wà gbɛ̀ pì tataàlɛ a gbɛ̀n. ");
INSERT INTO bus_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ben Yakubu sãdãrinↄ là à bè: Gbɛ̃nↄ, a bↄ mámɛ? Aↄ̃ wèàla wà bè: Wa bↄ Aranamɛ. ");
INSERT INTO bus_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ben à ń lá à bè: Á Nao dio Labã dↄ̃ↄ́? Aↄ̃ wèàla wà bè: Wá à dↄ̃. ");
INSERT INTO bus_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ben à ń lá à bè: À aafiaↄ́? Aↄ̃ bè: À aafia. Ǹ à nɛ́ Rasɛli gwa, èe mↄↄ kↄ̃n sãanↄ kãaa. ");
INSERT INTO bus_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ben Yakubu bè: Ɔfãntɛ̃ kpɛ́ gbãa, sãanↄ tágurↄↄ e ká kↄ̀ro. À í kpáḿma à gá ń dã. ");
INSERT INTO bus_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ben aↄ̃ bè: Wé fↄ̃ro. Tó èe kɛ sã kpàsanↄ kàkↄ̃a píngi baasiro, wè gbɛ̀ go lↄ̀gↄ pìlɛ wà í kpáḿmaro. ");
INSERT INTO bus_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Kɛ̀ èe yã oońnɛ lɛ, Rasɛli mↄ̀ kↄ̃n a de sãanↄ, zaakɛ sãdãrin à ũ. ");
INSERT INTO bus_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Kɛ̀ Yakubu a desɛ̃ Labã nɛ́nↄgbɛ̃ Rasɛli è kↄ̃n à de sãanↄ, à sↄ̃̀ lↄ̀gↄzi à gbɛ̀ gò lↄ̀gↄ pìlɛ, ben à í kpà a desɛ̃ sãanↄa. ");
INSERT INTO bus_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ben à lɛ́ pɛ̀ Rasɛlia à pↄnna ↄ́ↄ dↄ̀. ");
INSERT INTO bus_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ben à ònɛ kɛ̀ à de danɛ Rɛbɛka nɛ́n a ũ. Ben Rasɛli bàalɛ à gàa à ò a denɛ. ");
INSERT INTO bus_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Kɛ̀ Labã a dãre nɛ́ Yakubu baaru mà, à bàalɛ à gàa daàlɛ. Kɛ̀ à kà, ben à kùsia à lɛ́ pɛ̀a à tào a bɛ. Ben Yakubu yã kɛ̀ kɛ̀nↄ ònɛ píngi. ");
INSERT INTO bus_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ben Labã bènɛ: Ma arumɛ n ũ yãpura. Yakubu kɛ̀ Labã bɛ mↄ do, ");
INSERT INTO bus_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ben Labã bènɛ: Kɛ̀ ń dɛ ma danɛ ũ yãnzin nɛ́ zĩi kɛmɛ pãↄ́? Dia mɛ́ fĩa bonnɛ nà ǹ omɛ. ");
INSERT INTO bus_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labã sↄ̃ nɛ́nↄgbɛ̃nↄ vĩ gↄ̃ↄn plaa. Yↄ̃ↄ tↄ́n Lea, Bãa sↄ̃ Rasɛli. ");
INSERT INTO bus_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea wɛ́ɛ busana, Rasɛli sↄ̃ↄ nↄkparɛ maaamɛ, ben à kakana maa. ");
INSERT INTO bus_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakubu ye Rasɛlizi, ben à bè Labãnɛ: Mɛ́ zĩi kɛnnɛ wɛ̃̀ swɛɛplaa n nɛ́ bãade Rasɛli yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labã bè: À sã̀ↄ mà à kpámma dɛ mà à kpá gbɛ̃ pãndeala. Ǹgↄ̃ kú ma bɛ kɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ben Yakubu zĩi kɛ̀nɛ wɛ̃̀ swɛɛplaa Rasɛli yãnzi, ase à kɛ̀nɛ lán gurↄ plaaa bàmɛ kɛ̀ à yezi yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ben à bè Labãnɛ: Kɛ̀ ma zĩ gurↄↄ pàpa, ǹ ma nↄↄ kpáma mà sɛ́. ");
INSERT INTO bus_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ben Labã gwedeenↄ kàkↄ̃a ń píngi à nↄsɛpↄblee kɛ̀ńnɛ. ");
INSERT INTO bus_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Kɛ̀ uusiɛ kɛ̀, ben à a nɛ́ Lea sɛ̀ à kpàa, ben Yakubu dàɛo. ");
INSERT INTO bus_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labã a nↄgbɛ̃ zĩkɛri Zilipa kpà Leaa zĩkɛri ũ. ");
INSERT INTO bus_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kɛ̀ guu dↄ̀ Yakubu è Leamɛ, ben à bè Labãnɛ: Bↄ́yãnzi ń kɛ̀mɛ lɛɛ? Rasɛli yãnzin ma zĩi kɛ̀nnɛziroo? Bↄ́ bé à tò n ma kɛkɛ? ");
INSERT INTO bus_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labã bè: Wa kiia wè Bãa kpá gↄ̃ↄa Yↄ̃ↄ ãro. ");
INSERT INTO bus_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ǹ azuma doo kɛ kↄ̃n gbɛ̃ beeeo gĩa, mɛ́ à gbɛ̃ndoo kpámma zĩi kɛ̀ nɛ́ ɛara ǹ kɛmɛ wɛ̃̀ swɛɛplaa pãnde pↄ́ ũ. ");
INSERT INTO bus_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakubu wèzi à azuma doo pì kɛ̀ kↄ̃n Leao, ben Labã a nɛ́ Rasɛli kpàa nↄↄ ũ. ");
INSERT INTO bus_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labã a nↄgbɛ̃ zĩkɛri Bila kpà Rasɛlia zĩkɛri ũ. ");
INSERT INTO bus_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakubu dàɛ kↄ̃n Rasɛlio sↄ̃, ben à yezi dɛ Leala. Ben à ɛ̀ara à zĩi kɛ̀ Labãnɛ ai wɛ̃̀ swɛɛplaa dↄ. ");
INSERT INTO bus_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Dii è Yakubu ye Leaziro, ben à à kɛ̀ nɛ́dandee ũ, Rasɛli sↄ̃ pãaamɛ. ");
INSERT INTO bus_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea nↄ̀ sì à nɛ́ ì gↄ̃gbɛ̃ ũ, ben à tↄ́ kpànɛ Rubɛni, zaakɛ à bè: Dii ma nawɛ̃akɛna gwà. Ma zã égↄ̃ yemazi sa. ");
INSERT INTO bus_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Kɛ̀ à nↄ̀ sì dↄ, à nɛ́ ì gↄ̃gbɛ̃ ũ, ben à bè: Dii mà ma zã yemaziro, ben à ɛ̀ara à nɛ́ kɛ̀kii kpàma dↄ. Ben à tↄ́ kpànɛ Simɛↄ. ");
INSERT INTO bus_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Kɛ̀ à ɛ̀ara à nↄ̀ sì dↄ, à nɛ́ ì gↄ̃gbɛ̃ ũ à bè: Kɛ̀kii sa ma zã é ma diɛkii ero, zaakɛ ma nɛ́gↄ̃gbɛ̃ ìo mɛ̀n aagↄ̃. Ben à tↄ́ kpànɛ Levi. ");
INSERT INTO bus_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","À ɛ̀ara à nↄ̀ sì dↄ à nɛ́ ì gↄ̃gbɛ̃ ũ à bè: Kɛ̀kii sa ma Dii sáabu kpà, ben à tↄ́ kpànɛ Yuda. Ben à nɛ́'ii zɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Kɛ̀ Rasɛli è ée nɛ́ ii kↄ̃n Yakubuoro, à gↄ̃aanↄ kpà kↄ̃n a vĩ̀io. Ben à bè Yakubunɛ: Ǹ nↄ̀ dↄmagu. Tó mɛ́ɛ e sↄ̃ro, mɛ́ gamɛ. ");
INSERT INTO bus_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakubu pↄ fɛ̃̀zi à bè: Mámbe Luda ũ kɛ̀ n tɛ̃ nɛ́ↄ́? ");
INSERT INTO bus_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ben Rasɛli bè: Ma zĩkɛri Bilan yɛ̀. Ǹ gá io à nɛ́nↄ imɛ, mɛ́ borii e se à gãzĩ. ");
INSERT INTO bus_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ben à a zĩkɛri Bila kpàa nↄↄ ũ. Yakubu dàɛo, ");
INSERT INTO bus_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ben à nↄ̀ sì à nɛ́ ì gↄ̃gbɛ̃ ũ. ");
INSERT INTO bus_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ben Rasɛli bè: Ludaa tò yã bↄ̀mao nna à ma yã mà, à ma gba nɛ́gↄ̃gbɛ̃. Ben à tↄ́ kpànɛ Dani. ");
INSERT INTO bus_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rasɛli zĩkɛri pì ɛ̀ara à nↄ̀ sì à nɛ́ ì gↄ̃gbɛ̃ ũ dↄ, ");
INSERT INTO bus_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ben Rasɛli bè: Ma ↄsi ìsi kà kↄ̃n ma vĩ̀io ma ↄsii nɛ̀. Ben à tↄ́ kpànɛ Nafatali. ");
INSERT INTO bus_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Kɛ̀ Lea è a nɛ́'ii zɛ̀, ben à a zĩkɛri Zilipa kpà Yakubua nↄↄ ũ dↄ. ");
INSERT INTO bus_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ben Lea zĩkɛri pì nɛ́ ì gↄ̃gbɛ̃ ũ kↄ̃n Yakubuo. ");
INSERT INTO bus_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ben Lea bè: Mìnnaamɛ. Ben à tↄ́ kpànɛ Gada. ");
INSERT INTO bus_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ben Lea zĩkɛri pì nɛ́ ì gↄ̃gbɛ̃ ũ dↄ kↄ̃n Yakubuo. ");
INSERT INTO bus_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ben Lea bè: Ma pↄↄ kɛ̀ nna, zaakɛ nↄgbɛ̃nↄ é be pↄnnadeen ma ũ. Ben à tↄ́ kpànɛ Asa. ");
INSERT INTO bus_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Rubɛni bↄ̀ ésekɛ̃gurↄ à yenzi ɛ̃zɛ̃ è sɛ̃̀n, ben à bòbo à sùo a da Leanɛ. Ben Rasɛli bènɛ: Ǹ n nɛ́ yenzi ɛ̃zɛ̃ pì dãmɛ. ");
INSERT INTO bus_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lea bènɛ: Kɛ̀ n ma gↄ̃ↄ sìma, beee e mↄ́mmaro, ben ń yezi ǹ ma nɛ́ yenzi ɛ̃zɛ̃ sí dↄↄ́? Rasɛli bè: Tó ń kpàma, ḿbe nɛ́ io gbã̀a. ");
INSERT INTO bus_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Kɛ̀ Yakubu e suu kↄ̃n buraao uusiɛ, Lea bↄ̀ à gàa à dààlɛ à bè: Mámbe mɛ́ inyo gbã̀a, zaakɛ ma n sɛ̃kã ma nɛ́ yenzi ɛ̃zɛ̃ yãnzimɛ. Ben à ìo gwãavĩ beeea. ");
INSERT INTO bus_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Luda Lea wɛ́ɛkɛɛ sì, ben à nↄ̀ sì à Sãani ì kↄ̃n Yakubuo. ");
INSERT INTO bus_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ben Lea bè: Luda láada kpàma, kɛ̀ ma a zĩkɛri kpà ma zãa yãnzi. Ben à tↄ́ kpànɛ Isaka. ");
INSERT INTO bus_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea ɛ̀ara à nↄ̀ sì dↄ à Tori ì, ");
INSERT INTO bus_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ben à bè: Luda gba maaa dàmɛ. Kɛ̀kii sa ma zã é ma kpe da, zaakɛ ma nɛ́gↄ̃gbɛ̃nↄ ìo mɛ̀n swɛɛdo. Ben à tↄ́ kpànɛ Zɛbuluni. ");
INSERT INTO bus_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Zãazãa à nɛ́nↄgbɛ̃ ì, ben à tↄ́ kpànɛ Dina. ");
INSERT INTO bus_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ben Rasɛli yã dↄ̀ Ludan à à wɛ́ɛkɛɛ sì, ben à kɛ̀ nɛ́dandee ũ. ");
INSERT INTO bus_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","À nↄ̀ sì à nɛ́gↄ̃gbɛ̃ ì, ben à bè: Luda wí bↄ̀mɛ. ");
INSERT INTO bus_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ben à tↄ́ kpànɛ Yusufu à bè: Dii ɛara à nɛ́gↄ̃gbɛ̃ pãnde kaaramɛ dↄ. ");
INSERT INTO bus_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Kɛ̀ Rasɛli Yusufu ì, Yakubu bè Labãnɛ: Ǹ ma gbarɛ mà tá ma bɛ bùsun. ");
INSERT INTO bus_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ma zĩi kɛ̀nnɛ ma nↄↄnↄ kↄ̃n ma nɛ́nↄ yãnzi. Ǹ ń kpáma mà tá, zaakɛ ń dↄ̃ lán ma zĩi kɛ̀nnɛ nà. ");
INSERT INTO bus_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ben Labã bènɛ: Tó ma n pↄnnaa è, ǹ gↄ̃mao kɛ̀. Ma màso kɛ̀ má è Dii aubarika kɛ̀mɛ n yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ǹ n asaiapↄ omɛ, mɛ́ kpámma. ");
INSERT INTO bus_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakubu bènɛ: Ń dↄ̃ lán ma zĩi kɛ̀nnɛ nà. Ń dↄ̃ lán n pↄ́kãdeenↄ kɛ̀ ma ↄzĩ nà, ");
INSERT INTO bus_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","zaakɛ à féte kɛ̀ ń vĩ zaalɛ mɛ́ɛ mↄ́roo kàara maamaa. Dii aubarika dàngu guu kɛ̀ ma gaan n bɛ píngi. Bↄrɛn mɛ́ ma zĩnda bɛ zĩi kɛ sↄ̃ↄ? ");
INSERT INTO bus_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labã à là à bè: Bↄ́n mɛ́ fĩa boonnɛɛ? Yakubu wèàla à bè: Ǹton pↄ́ke kpámaro, mↄde ǹ yã kɛ̀ kɛmɛ, mɛ́gↄ̃ n pↄ́nↄ dãannɛ. ");
INSERT INTO bus_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ǹ tó mà gɛ̃ n pↄ́nↄ tɛ́ gbã̀a mà sã bakebakenↄ kↄ̃n à togetogenↄ plɛplɛ ma asaiapↄ ũ kↄ̃n sãnɛ bↄ̀rↄ siaanↄ kↄ̃n blè bakebakenↄ kↄ̃n à togetogenↄo. ");
INSERT INTO bus_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Tó n ma asaiapↄ gwà gana gurↄ aɛzĩ, nɛ́ dↄ̃ tó má yãpuraa vĩ. Blè kɛ̀ kuu bakebakero ben à togetogero, ke sãnɛ bↄ̀rↄ kɛ̀ siaro, ɛ̃ndɛ̃ ma kpãi òmɛ. ");
INSERT INTO bus_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labã bè: Tↄ̀! Àgↄ̃ dɛ lán ń ò nà. ");
INSERT INTO bus_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Zĩ beeea Labã à blèkofĩi bakebakenↄ sɛ̀ kↄ̃n à wɛ̃zãdeenↄ kↄ̃n blèda togetogenↄ kↄ̃n à bakebakenↄ, aↄ̃ pↄ́ kɛ̀ aↄ̃ↄ puraa vĩinↄ píngi kↄ̃n sãnɛ bↄ̀rↄ siaanↄ píngi, à ń ná a nɛ́gↄ̃gbɛ̃nↄnɛ ń ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ben à kpã̀ngu dà ń dagura kↄ̃n Yakubuo lán gurↄ aagↄ̃ tá bà, ben Yakubu e Labã pↄ́ kpaaanↄ dãa. ");
INSERT INTO bus_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yakubu lí bori aagↄ̃ gã̀ búsunↄ zↄ̃̀zↄ̃ à ń wɛ̃zã kpàkpa à ń wɛ̃zã kɛ̀ púu. ");
INSERT INTO bus_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ben à lí kɛ̀ à ń wɛ̃zã kpàkpa pìnↄ pɛ̀ɛpɛɛ pↄ́nↄ gbãngo ímikiia, pↄ́ kɛ̀ aↄ̃ↄe mↄↄ í minↄ wɛ́ɛn, zaakɛ gwen aↄ̃è kpákpa on. ");
INSERT INTO bus_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Tó aↄ̃ kpákpa ò lí pìnↄ saɛ, ben aↄ̃ègↄ̃ nɛ́ wɛ̃zãdeenↄ ii kↄ̃n à togetogenↄ kↄ̃n à bakebakenↄo. ");
INSERT INTO bus_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakubu è pↄ́nɛ pìnↄ plɛplɛ adona è à wɛ̃zãdeenↄ kↄ̃n à siaanↄ ká Labã pↄ́nↄ guu. Lɛmɛ à a zĩnda kpàsa bↄ̀ lɛ, èe ká Labã pↄ́nↄ guuro. ");
INSERT INTO bus_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Tó pↄ́bori maaanↄ fɛ̀ɛ kↄ̃n kpákpa'onao, Yakubu è lí pìnↄ pɛ́ɛpɛɛɛ pↄ́nↄ aɛzĩ ímikiia, lɛ aↄ̃ kpákpa o ń saɛ. ");
INSERT INTO bus_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Tó pↄ́ ginanↄmɛ sↄ̃, è lí pɛ́ɛpɛɛńnɛro. Lɛn pↄ́ ginanↄ gↄ̃̀ Labã pↄ́ ũ lɛ, ben pↄ́bori maaanↄ gↄ̃̀ Yakubu pↄ́ ũ. ");
INSERT INTO bus_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ben Yakubu auziki ègↄ̃ kaara maamaa à pↄ́nↄ pari kũ̀ kↄ̃n nↄgbɛ̃ zĩkɛrinↄ kↄ̃n gↄ̃gbɛ̃ zĩkɛrinↄ kↄ̃n lakuminↄ kↄ̃n zaakinↄo. ");
INSERT INTO bus_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakubu yã kɛ̀ Labã nɛ́nↄↄ e oo mà kɛ̀ aↄ̃ bè: Yakubu wa de pↄ́nↄ sìa píngi. Wa de auziki guun à kaarana èn. ");
INSERT INTO bus_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakubu dↄ̃̀ Labã wɛ́ɛa, kɛ̀ a yã kú à nↄ̀sɛ guu lán yãa bà dↄro. ");
INSERT INTO bus_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ben Dii bènɛ: Ǹ ɛara ǹ tá n dezi bùsun n danɛnↄ bɛ, mɛ́gↄ̃ kúnyo. ");
INSERT INTO bus_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ben Yakubu Rasɛli kↄ̃n Leao sìsi aↄ̃ mↄ́ a pↄ́nↄ kiia sɛ̃̀n. ");
INSERT INTO bus_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","À bèńnɛ: Má dↄ̃̀ a de wɛ́ɛa kɛ̀ ma yã kú à nↄ̀sɛn lán yãa bà dↄro. Baa kↄ̃n beeeo ma de Ludaa kúmao. ");
INSERT INTO bus_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Á dↄ̃ a zĩndanɛ kɛ̀ ma zĩi kɛ̀ a denɛ ma gbãa lɛ́mmɛ. ");
INSERT INTO bus_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","A de ↄ̃ndↄ̃ↄ kɛ̀mɛ à ma láada lìɛ gɛ̃̀n kuri, ben Ludaa e tó à yãke kɛ̀mɛro. ");
INSERT INTO bus_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Tó à bè sã bakebakenↄn ma baka ũ, sãanↄ ègↄ̃ nɛ́ bakebakenↄ ii. Tó à bè à wɛ̃zãdeenↄ bé wà ma baka ũ, sãanↄ ègↄ̃ nɛ́ wɛ̃zãdeenↄ ii. ");
INSERT INTO bus_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Luda a de sãanↄ sìa à kpàma. ");
INSERT INTO bus_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Gurↄↄ kɛ̀ blènↄↄ e kpákpa oo, ma nanaa ò, ben nanaa guu má è blèkofĩi kɛ̀ aↄ̃ↄe kpákpa oonↄ nɛ́ blè wɛ̃zãdeenↄmɛ kↄ̃n à bakebakenↄ kↄ̃n à togetogenↄo. ");
INSERT INTO bus_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ben Luda Malaika bèmɛ nanaa pì guu: Yakubu! Ben ma weàla ma bè: Maɛ kɛ̀! ");
INSERT INTO bus_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","À bè: Ǹ wɛ́ɛ sɛ́ ǹ gwa. Blèkofĩi kɛ̀ aↄ̃ↄe kpákpa oonↄ píngi blè wɛ̃zãdeenↄmɛ kↄ̃n à bakebakenↄ kↄ̃n à togetogenↄo, zaakɛ ma yã kɛ̀ Labã kɛ̀nnɛɛ è píngi. ");
INSERT INTO bus_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Mámbe Luda kɛ̀ bↄ̀ à mↄ̀nzi Bɛtɛli ũ, guu kɛ̀ n gbɛ̀ pɛ̀ɛn n nↄ́si kùa n lù sɛ̀ma. Tia sa ǹ fɛɛ ǹ bↄ bùsu kɛ̀n ǹ tá n bɛ bùsun. ");
INSERT INTO bus_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ben Rasɛli kↄ̃n Leao bènɛ: Wá túbi vĩ wa de bɛ dↄↄ́? ");
INSERT INTO bus_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Èe wa diɛɛ gbɛ̃ zĩ̀tↄnↄ ũnloo? A wa yamma, ben à à ↄↄ blè píngi. ");
INSERT INTO bus_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Auziki kɛ̀ Ludaa sì wa dea gↄ̃̀ wa pↄ́ ũ píngimɛ kↄ̃n wa nɛ́nↄ. Ǹ yã kɛ̀ Ludaa ònnɛɛ kɛ píngi sa. ");
INSERT INTO bus_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ben Yakubu fɛ̀ɛ à a nɛ́nↄ kↄ̃n a nↄↄnↄ dì lakuminↄ kpɛɛ. ");
INSERT INTO bus_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","À a pↄ́kãdeenↄ kↄ̃n auziki kɛ̀ à è Mɛsↄpↄtamianↄ sɛ̀ɛ píngi, ben à dà zɛ́n èe taa a de kiia Kanaa bùsun. ");
INSERT INTO bus_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Kɛ̀ Labã gàa a sãanↄ kã kɛ̃ɛ, ben Rasɛli à tãanↄ sɛ̀ kpãi à kpɛɛ. ");
INSERT INTO bus_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakubu sↄ̃ ↄ̃ndↄ̃ↄ kɛ̀ Siria bori Labãnɛ èe lɛ́ zaaro. ");
INSERT INTO bus_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","À fɛ̀ɛ à bàalɛ kↄ̃n a pↄ́nↄ píngi à bikũ̀ Yuflatia, ben à mì pɛ̀ Giliada gusĩsĩdeea. ");
INSERT INTO bus_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","À gurↄ aagↄ̃dee zĩ wà bè Labãnɛ Yakubu bàalɛ. ");
INSERT INTO bus_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","À a gbɛ̃nↄ kàkↄ̃a, ben à pɛ̀ɛzi. À táa ò gurↄ swɛɛplaa, ben à à lè Giliada gusĩsĩdeen. ");
INSERT INTO bus_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ben Luda bↄ̀ à mↄ̀zi gwãavĩ nanaa guu à bènɛ: Ǹ làakari kɛ yã kɛ̀ nɛ́ o Yakubunɛzi à maaa ke à zaaa. ");
INSERT INTO bus_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labã Yakubu bùra lè pɛɛna Giliada gusĩsĩdeen, ben à bùra kàɛ gwe kↄ̃n a gbɛ̃nↄo se. ");
INSERT INTO bus_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ben Labã gàa à bè Yakubunɛ: Bↄ́yãnzi n ↄ̃ndↄ̃ↄ kɛ̀mɛ n ma nɛ́nↄ sɛ̀ɛ n tańyo lán zĩ̀zↄnↄ bà? ");
INSERT INTO bus_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Bↄ́yãnzi n ↄ̃ndↄ̃ↄ kɛ̀mɛ n wurɛ kpãi nɛ́ɛ lɛ́ zamaro, lɛ ma gaa zɛnnɛ kↄ̃n pↄnnakɛnao kↄ̃n lɛ̀sinao kↄ̃n gã̀gão kↄ̃n mↄrↄo. ");
INSERT INTO bus_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Nɛ́ɛ tó ma lɛ́ zà ma nɛ́nↄ kↄ̃n ma dionↄaro. N yↄ̃nkↄyã kɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ma gbãaa kà mà yã zaaa kɛare, ben n de Luda yã òmɛ gwãavĩ à bè mà làakari kɛ yã kɛ̀ mɛ́ onnɛɛzi à maaa ke à zaaa. ");
INSERT INTO bus_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nɛ́ɛ taa sa, kɛ̀ nɛ́ɛ n de bɛ bɛgɛ kɛɛ yãnzi. À kɛ̀ dia n ma tãanↄ sɛ̀ kpãii? ");
INSERT INTO bus_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakubu wèàla à bè: Ma vĩa kɛ̀ mɛ́ɛ daa nɛ́ n nɛ́nↄ símamɛ. ");
INSERT INTO bus_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Gbɛ̃ kɛ̀ n n tãanↄ è à kiia, wà à dɛ. Ǹ ma pↄ́nↄ gwagwa wa gbɛ̃nↄ wáa. Tó n n pↄ́ è, ǹ sɛ́. Yakubu sↄ̃ↄ dↄ̃ kɛ̀ Rasɛli Labã pↄ́ sɛ̀ kpãiro. ");
INSERT INTO bus_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labã gɛ̃̀ Yakubu bisa kutaan à gɛ̃̀ Lea kutaan à gɛ̃̀ nↄgbɛ̃ zĩkɛri gↄ̃ↄn plaaa pìnↄ kutaan èe pↄ́ke ero. Kɛ̀ à bↄ̀ Lea kutaan, à gɛ̃̀ Rasɛli kutaan. ");
INSERT INTO bus_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rasɛli tãa pìnↄ sɛ̀ à ùtɛ lakumi gàari guumɛ, ben à vɛ̃̀ɛa. Labã à kuta guu gwàgwa píngi, èe pↄ́ke ero. ");
INSERT INTO bus_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rasɛli bè a denɛ: Baa, ǹton pↄ fɛ̃maziro, zaakɛ mɛ́ɛ e mà fɛɛro kɛ̀ má ↄ kũna yãnzi. Lɛmɛ Labã a tãanↄ wɛ̀tɛ lɛ èe ero. ");
INSERT INTO bus_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ben Yakubu pↄ fɛ̃̀ à lɛ́fↄtↄↄ kà Labãzi à bè: Bↄ́ dàn má kɛ̀? Bↄ durunn má kɛ̀ ben n pɛɛmazi wãawãa lán kɛ̀ bà? ");
INSERT INTO bus_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Kɛ̀ n ma pↄ́nↄ gwàgwa píngi, n n bɛ pↄ́nↄ è gweↄ́? Ǹ bↄo gupuraaa ma gbɛ̃nↄ kↄ̃n n gbɛ̃nↄ wáa, aↄ̃ yã nnaa kpá gbɛ̃ kɛ̀ a yã nnaaa. ");
INSERT INTO bus_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ma kɛ n bɛ wɛ̃̀ baro. N sãanↄ kↄ̃n n blènↄ e nↄ̀ bↄɛro, mɛ́ɛ n sãa ke sóro. ");
INSERT INTO bus_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Mɛ́ɛ sunnɛ kↄ̃n pↄ́ kɛ̀ nↄ̀bↄ pãsĩnↄ kũ̀ keoro, mɛɛ̀ à fĩa bonnɛ ma zĩndamɛ. Nɛɛ̀ pↄ́ kɛ̀ wà à kpãi ò gwãavĩ ke fãantɛ̃ fĩa lama. ");
INSERT INTO bus_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ɔfãntɛ̃ è ma lɛ fãantɛ̃, ĩa è ma dɛ gwãavĩ, mɛɛ̀ itɛ̃ kɛ. ");
INSERT INTO bus_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Lɛn ma kɛ n bɛ lɛ ai wɛ̃̀ baro. Wɛ̃̀ gɛ̃ro dosai ma zĩi kɛ̀nnɛ n nɛ́nↄgbɛ̃ gↄ̃ↄn plaaanↄ yãnzi. Ma wɛ̃̀ swɛɛdoo kɛ̀ n kpàsa yã musu. N ma láada lìɛ gɛ̃̀n kuri. ");
INSERT INTO bus_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Tó èe kɛ ma dezi Ibraĩ Luda kɛ̀ ma de Isaaku à vĩa vĩi zɛ̀mao baasiro, lɛ n ma gbarɛ ↄkori. Luda zĩi kɛ̀ má kɛ̀ kↄ̃n nawɛ̃ao è, ben à kpã̀kɛ̃nzi gĩa gwãavĩ. ");
INSERT INTO bus_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ben Labã wè Yakubula: Nↄgbɛ̃ kɛ̀kiinↄ sↄ̃ ma nɛ́nↄmɛ. Nɛ́ kɛ̀kiinↄ sↄ̃ ma dionↄmɛ. Pↄ́kãdee kɛ̀kiinↄ sↄ̃ ma pↄ́kãdeenↄmɛ. Pↄ́ kɛ̀ ń è kɛ̀ píngi ma pↄ́mɛ. Bↄ́n mɛ́ kɛ ma nɛ́nↄgbɛ̃nↄ kↄ̃n nɛ́ kɛ̀ aↄ̃ↄ ìnↄnɛ gbã̀a? ");
INSERT INTO bus_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ǹ tó wà lɛdolɛ kɛ àgↄ̃ dɛ sèeda ũ wa dagura. ");
INSERT INTO bus_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ben Yakubu gbɛ̀ sɛ̀ à pɛ̀ɛ yã pì dↄngupↄ ũ. ");
INSERT INTO bus_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","À bè a gbɛ̃nↄnɛ aↄ̃ gbɛ̀nↄ sɛ́ɛ, ben aↄ̃ↄ sɛ̀ɛ aↄ̃ↄ dìdikↄ̃a, ben aↄ̃ pↄ́ blè à saɛ. ");
INSERT INTO bus_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Ben Labã tↄ́ kpà gbɛ̀didikↄ̃ana pìnɛ Yega Saaduta. Yakubu tↄ́ kpànɛ Galɛɛdi. ");
INSERT INTO bus_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labã bè: Gbɛ̀didikↄ̃ana kɛ̀kiin sèeda ũ wa dagura gbã̀a. Bee yãnzi wà tↄ́ kpànɛ Galɛɛdi. ");
INSERT INTO bus_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Wè be dↄ Mizipa, zaakɛ Labã bè: Dii wa dãkpa wa kɛ̃kↄ̃ana gbɛra lɛ wàton zakↄ̃nlo yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Tó n ĩa dà ma nɛ́nↄgbɛ̃nↄa ke tó n nↄ pãndenↄ sɛ̀ dↄ, baa tó wá kú kↄ̃ kiiaro, ǹgↄ̃ dↄ̃ sãnsãn kɛ̀ Ludan wa yã pì sèedadee ũ. ");
INSERT INTO bus_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ben Labã bènɛ dↄ: Ǹ gbɛ̀didikↄ̃ana kɛ̀kii gwa kↄ̃n gbɛ̀ kɛ̀ má pɛ̀ɛ wa dagurao. ");
INSERT INTO bus_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Eégↄ̃ dɛ sèeda ũ kɛ̀ mɛ́ vĩàla mà mↄ́ mà à zaaa kɛnnɛro, mpi sↄ̃ nɛ́ vĩàla ǹ mↄ́ ǹ à zaaa kɛmɛro. ");
INSERT INTO bus_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ibraĩ kↄ̃n Naoo kↄ̃n ń deo Ludan wa yãkpaɛkɛri ũ. Ben Yakubu sì kↄ̃n Luda kɛ̀ a de Isaaku à vĩa vĩ tↄ́o. ");
INSERT INTO bus_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","À saa ò gusĩsĩdeen gwe, ben à a gbɛ̃nↄ sìsi aↄ̃ pↄ́ ble. Kɛ̀ aↄ̃ pↄ́ blè, ben aↄ̃ ì gwe. ");
INSERT INTO bus_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Labã fɛ̀ɛ kↄngↄ idɛ'idɛ, à lɛ́ zà a dionↄa kↄ̃n a nɛ́nↄ à sa maaa òńnɛ, ben à lìara à tà a bɛ. ");
INSERT INTO bus_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakubu dà zɛ́n, ben Luda malaikanↄ dààlɛ. ");
INSERT INTO bus_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Kɛ̀ à ń é, à bè: Luda bùran kɛ̀. Ben à tↄ́ kpà guu pìnɛ Manaimu. ");
INSERT INTO bus_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","À zĩ̀rinↄ zĩ̀ a aɛ a vĩ̀i Isaua Sei bùsu kɛ̀ wè be dↄ Ɛdↄmu bùsun. ");
INSERT INTO bus_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","À bè a zĩ̀rinↄnɛ: À gá à o ma dii Isaunɛ à zↄ̀bleri Yakubu gurↄ plaa kɛ̀ Labã bɛ èe suu sa. ");
INSERT INTO bus_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","À onɛ má zùnↄ vĩ kↄ̃n zaakinↄ kↄ̃n sãanↄ kↄ̃n blènↄ kↄ̃n gↄ̃gbɛ̃ zĩkɛrinↄ kↄ̃n nↄgbɛ̃ zĩkɛrinↄo. Mámbe ma a zĩ à onɛ lɛ ma à pↄnnaa e. ");
INSERT INTO bus_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kɛ̀ zĩ̀rinↄ ɛ̀ara wà sù Yakubu kiia, aↄ̃ bè: Wa gaa n vĩ̀i kiia, èe mↄ́ à danlɛ kↄ̃n gↄ̃ↄn wàa plaaanↄ. ");
INSERT INTO bus_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Vĩa Yakubu kũ̀ èe bídi kɛɛ maamaa, ben à gbɛ̃ kɛ̀ aↄ̃ kúonↄ kpàatɛ lɛo plaa kↄ̃n sãanↄ kↄ̃n blènↄ kↄ̃n zùnↄ kↄ̃n lakuminↄo à bè: ");
INSERT INTO bus_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Tó Isau mↄ̀ à sì à lɛo dooa, à lɛo doo kɛ̀ gↄ̃̀ é bↄ. ");
INSERT INTO bus_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ben à adua kɛ̀ à bè: Dii, ma dezi Ibraĩ kↄ̃n ma de Isaakuo Luda, ń òmɛ mà su ma bùsun ma danɛnↄ kiia, nɛ́ aubarika damagu. ");
INSERT INTO bus_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","N gbɛ̃kɛɛ kↄ̃n náanɛ yão kɛ̀mɛ maamaa ma bɛ̀ɛ e káro. Gurↄↄ kɛ̀ ma bikũ Yodaa, gò bé à na ma ↄzĩ ado. Tia sa ma su kↄ̃n auziki lɛo plaaa kɛ̀nↄ. ");
INSERT INTO bus_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ma wɛ́ɛ kɛ̀mma ǹ ma sí ma vĩ̀ia, zaakɛ mɛ́ɛ vĩa kɛɛnɛ kɛ̀ eé sí wa tɛ́ à nↄgbɛ̃nↄ kↄ̃n nɛ́nↄ dɛdɛ yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Mpi sↄ̃, n bè nɛ́ aubarika damagu nɛ́ ma borii kaara lán ísialɛa bùsu'ãatɛ̃ bà weé fↄ̃ wà ń naroro ń pari yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Gwen Yakubu ìn. Pↄ́ kɛ̀ à plɛ̀plɛ à a vĩ̀i gbaanↄn yɛ̀: ");
INSERT INTO bus_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Blèda mɛ̀n wàa do, à kofĩi mɛ̀n baro, sãda mɛ̀n wàa do, à karo mɛ̀n baro, ");
INSERT INTO bus_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","lakumida mɛ̀n baaakuri kↄ̃n ń nɛ́ bↄ̀rↄnↄ, zùda mɛ̀n baplaa, à sware mɛ̀n kuri, zaakida mɛ̀n baro, à kyà mɛ̀n kuri. ");
INSERT INTO bus_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","À ń ná a zↄ̀blerinↄnɛ ń ↄzĩ bori kↄ̃n boriio, ben à bèńnɛ: Àgↄ̃ tɛ́ ma aɛ à kpàngu da a dagura gã̀ kↄ̃n gã̀o. ");
INSERT INTO bus_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","À bè gbɛ̃ káakunɛ: Tó ma vĩ̀i dànlɛ à n la à bè: Démɛ n dii ũu? Nɛ́ɛ gaa mámɛ? Dé bé à pↄ́ kɛ̀ nɛ́ɛ dãa kɛ̀nↄ vĩi? ");
INSERT INTO bus_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ǹ onɛ à zↄ̀bleri Yakubu pↄ́mɛ, pↄ́ kɛ̀ à a dii gbà à kpã̀sãnɛnↄn gwe, àpi e suu kpɛɛ. ");
INSERT INTO bus_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","À yã dↄ̃nkↄ̃ pì ò gbɛ̃ plaadeenɛ kↄ̃n gbɛ̃ aagↄ̃deeo kↄ̃n pↄ́dãrinↄ ń píngi à bè: Tó a da Isaulɛ, à onɛ lɛ. ");
INSERT INTO bus_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","À onɛ à zↄ̀bleri Yakubu e suu kpɛɛ. Zaakɛ à laasuu lɛ̀ à bè: Mɛ́ à làakari kpáɛ kↄ̃n pↄ́ kɛ̀ má kpà aɛ kɛ̀nↄ, wé wɛ́ɛ sikↄ̃lɛ. Eé gí gbãakɛ kpámazi saↄ́? ");
INSERT INTO bus_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Gbaa pìnↄ dↄ̀nɛ aɛ, ben à gↄ̃̀ bùran gwãavĩ mↄ̀a à ì gwe. ");
INSERT INTO bus_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","À fɛ̀ɛ gwãavĩ à a nↄ mɛ̀n plaaanↄ sɛ̀ɛ kↄ̃n a nↄgbɛ̃ zĩkɛri gↄ̃ↄn plaaanↄ kↄ̃n a nɛ́gↄ̃gbɛ̃ gↄ̃ↄn kuri awɛɛdoonↄ, ben à bikũ̀ńyo Yaboku íbikũkiia. ");
INSERT INTO bus_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Kɛ̀ à bikũ̀ńyo, ben à pↄ́ kɛ̀ à vĩinↄ sɛ̀ɛ à bikũ̀o píngi. ");
INSERT INTO bus_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yakubu gↄ̃̀ ado, ben gↄ̃gbɛ̃ ke mↄ̀ èe ↄsi kaao ai guu kà dↄna. ");
INSERT INTO bus_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Kɛ̀ gↄ̃gbɛ̃ pì è é fↄ̃ à à nɛ́ro, à à lɛ̀ a gisipɛkↄ̃rɛkiia, ben à gisi bↄ̀kũn ↄsikana pì guu. ");
INSERT INTO bus_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Gↄ̃gbɛ̃ pì bè: Ǹ ma gbarɛ, zaakɛ guu e dↄↄ. Ben Yakubu bènɛ: Tó èe kɛ ǹ aubarika damagu baasiro, mɛ́ n gbarɛro. ");
INSERT INTO bus_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Gↄ̃gbɛ̃ pì à là à bè: N tↄ́n diaa? À wèàla à bè: Ma tↄ́n Yakubu. ");
INSERT INTO bus_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ben à bè: Weé bennɛ Yakubu dↄro, séde Isaraili, zaakɛ n ↄsi kà kↄ̃n Ludao kↄ̃n gbɛ̃nteenↄ, ben n ↄsii nɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakubu bènɛ: Ǹ n tↄ́ omɛ se. A wèàla à bè: Bↄ́yãnzi nɛ́ɛ ma tↄ́ gbekaazi? Ben à aubarika dàn gwe. ");
INSERT INTO bus_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakubu tↄ́ kpà guu pìnɛ Pɛniɛli, zaakɛ à bè: Wa wɛ́ɛ sìkↄ̃lɛ kↄ̃n Ludao, ben mɛ́ɛ garo. ");
INSERT INTO bus_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","À bↄ̀ Pɛniɛli ↄfãntɛ̃bↄɛna, èe tↄ̃ↄtɛɛ a gisi yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Bee yãnzi ai gbã̀a Isarailinↄ è nↄ̀bↄ túgisi sóro, kɛ̀ Luda Yakubu lɛ̀ à túgisia yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Kɛ̀ Yakubu wɛ́ɛ sɛ̀, à è Isau e mↄↄ kↄ̃n gↄ̃ↄn wàa plaaanↄ. À a nɛ́nↄ kpàatɛtɛ Leanɛ kↄ̃n Rasɛlio kↄ̃n nↄgbɛ̃ zĩkɛri mɛ̀n plaaanↄ. ");
INSERT INTO bus_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ben à nↄgbɛ̃ zĩkɛri pìnↄ gbàrɛ aↄ̃ dↄ aɛ kↄ̃n ń nɛ́nↄ. Beee gbɛra Lea kↄ̃n a nɛ́nↄ, ben Rasɛli kↄ̃n Yusufuo tɛ́ ń kpɛɛ. ");
INSERT INTO bus_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","À dↄ̀ńnɛ aɛ à kùɛ tↄↄtɛ gɛ̃̀n swɛɛplaa ai à gàa à kào a vĩ̀i pì kiia. ");
INSERT INTO bus_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ben Isau bàalɛ à mↄ̀ à dààlɛ à mlɛ̃̀a, à ↄↄ dà à gã̀n à lɛ́ pɛ̀a, ben aↄ̃ ↄ́ↄ dↄ̀. ");
INSERT INTO bus_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Isau wɛ́ɛ sɛ̀ à nↄgbɛ̃nↄ è kↄ̃n nɛ́nↄ, ben à bè: Dénↄ bé wà kúnyo kɛ̀? Yakubu wèàla à bè: Nɛ́ kɛ̀ Luda ma gbaanↄmɛ. ");
INSERT INTO bus_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ben nↄgbɛ̃ zĩkɛri pìnↄ sↄ̃̀ńzi kↄ̃n ń nɛ́nↄ aↄ̃ kùɛ. ");
INSERT INTO bus_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ben Lea kↄ̃n a nɛ́nↄ sↄ̃̀ńzi dↄ aↄ̃ kùɛ. Beee gbɛra Yusufu kↄ̃n Rasɛlio sↄ̃̀ńzi aↄ̃ kùɛ. ");
INSERT INTO bus_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Isau bè: Pↄ́ kɛ̀ ma dańlɛ kɛ̀nↄↄ dɛ diamɛ? Yakubu wèàla à bè: Lɛ ma n pↄnnaa e yãnzimɛ. ");
INSERT INTO bus_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Isau bè: Ma gbɛ̃, ma pↄ́nↄ mↄ̀ma, ǹgↄ̃ n pↄ́nↄ kũna. ");
INSERT INTO bus_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ben Yakubu bè: Auo! N yã nna! Tó ma n pↄnnaa è, ǹ ma gba sí, zaakɛ wa wɛ́ɛsikↄ̃lɛna kɛ̀mɛ lán wɛ́ɛsikↄ̃lɛna kↄ̃n Ludao bàmɛ, ben n gbãakɛ kpàmazi. ");
INSERT INTO bus_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ǹ gbaa kɛ̀ ma mↄonnɛɛ sí, zaakɛ Luda aubarika dàmagu, pↄ́kee e kɛ̃sãmaro. Lɛmɛ à nàkↄ̃rɛa lɛ, ben à sì. ");
INSERT INTO bus_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ben Isau bè: Wà da zɛ́n wà tá. Mɛ́ gányo. ");
INSERT INTO bus_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ben à wèàla à bè: Ma dii, ń dↄ̃ kɛ̀ nɛ́nↄ gbãa vĩro, ben má sãa kↄ̃n zùnɛ bↄ̀rↄnↄ vĩ. Tó wa tá gbãaa ò gurↄ do, pↄ́kãdeenↄ é gaga píngimɛ. ");
INSERT INTO bus_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ǹ dↄmɛ aɛ ma dii, mↄma n zↄ̀bleri mɛ́gↄ̃ tɛ́ pↄ́nↄ kpɛɛ kↄ̃n nɛ́nↄ busɛbusɛ ai mà mↄ́ mà n le Sei. ");
INSERT INTO bus_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Isau bè: Mɛ́ ma gbɛ̃kenↄ tónyo. Yakubu bè: À kɛ̀ dɛa nɛ́ kɛ lɛ dↄↄ? Ǹ tó mà n pↄnnaa e dii. ");
INSERT INTO bus_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Zĩ beeean Isau dà Sei zɛ́n. ");
INSERT INTO bus_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ben Yakubu gàa Suko. À bɛɛ bò gwe, ben à lá kutaanↄ dↄ̀ pↄ́nↄnɛ. Bee yãnzi wà tↄ́ kpà guu pìnɛ Suko. ");
INSERT INTO bus_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Kɛ̀ Yakubu sù kↄ̃n Mɛsↄpↄtamiao, à kà wɛ́tɛ kɛ̀ wè be Sɛkɛmu, Kanaa bùsun aafia, ben à bùra kàɛ wɛ́tɛ pì saɛ. ");
INSERT INTO bus_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","À a bùrakaɛkii lù Sɛkɛmu de Amↄ nɛ́nↄa kondogi basↄↄro. ");
INSERT INTO bus_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Gwen à sa'okii bòn, à tↄ́ kpànɛ Luda Isarailinↄ Luda. ");
INSERT INTO bus_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Lea nɛ́nↄgbɛ̃ Dina kɛ̀ à ì kↄ̃n Yakubuo bↄ̀ à wɛ́ɛ kpáɛ bùsu pì nↄgbɛ̃nↄzi. ");
INSERT INTO bus_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Kɛ̀ bùsu pì kí Amↄ nɛ́ Sɛkɛmu, Ivi borii à è, à à sɛ̀ gbãaao, ben à dàɛo. ");
INSERT INTO bus_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","À pↄↄ dↄ nↄkparɛ pìa à yezi, ben à yã nnannaa ònɛ. ");
INSERT INTO bus_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ben Sɛkɛmu bè a denɛ: Ǹ nɛ́nↄkparɛ beee wɛtɛmɛ mà sɛ́. ");
INSERT INTO bus_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Kɛ̀ Yakubu mà wà a nɛ́nↄgbɛ̃ kpɛ bↄ̀, à nɛ́nↄↄ kú sɛ̃̀n kↄ̃n à pↄ́kãdeenↄ, ben à yĩ̀tɛ ai aↄ̃ sù. ");
INSERT INTO bus_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ben Sɛkɛmu de Amↄ gàa à Yakubu le à yã pì onɛ. ");
INSERT INTO bus_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Kɛ̀ Yakubu nɛ́nↄ bↄ̀ sɛ̃̀n wà sù, ben aↄ̃ yã pì mà gↄ̃ↄ. Aↄ̃ nↄ̀sɛ yàka aↄ̃ pↄ fɛ̃̀ maamaa, kɛ̀ Sɛkɛmu wíyã kɛ̀ Isarailinↄnɛ yãnzi, à dàɛ kↄ̃n Yakubu nɛ́nↄgbɛ̃o à yã kɛ̀ dɛ wà kɛroo kɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ben Amↄ bèńnɛ: Ma nɛ́ Sɛkɛmu pↄↄ dↄ a nɛ́nↄgbɛ̃a. A yã nna. À à kpáa nↄↄ ũ. ");
INSERT INTO bus_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Wà lɛdolɛ kɛ wàgↄ̃ wa nɛ́nↄgbɛ̃nↄ kpãsãakↄ̃a. ");
INSERT INTO bus_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Àgↄ̃ kúwao, wa bùsu kuu a pↄ́ ũmɛ. À vɛ̃ɛn àgↄ̃ laa taan àgↄ̃ tↄↄtɛ vĩ. ");
INSERT INTO bus_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ben Sɛkɛmu ò Dina de kↄ̃n à dãgↄ̃nↄnɛ à bè: À tó mà a pↄnnaa e. Pↄ́ kɛ̀ a be mà kpáawa mɛ́ kpá. ");
INSERT INTO bus_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","À anzureblebↄ lɛ́ damɛ bíta kↄ̃n gbaanↄ paripari. Pↄ́ kɛ̀ á ò mɛ́ kpá. À nɛ́nↄkparɛ pì kpáma nↄↄ ũ. ");
INSERT INTO bus_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ben Yakubu nɛ́nↄ wè Sɛkɛmu kↄ̃n à de Amↄola kↄ̃n mↄnafikio kɛ̀ Sɛkɛmu ń dãre kpɛ bↄ̀ yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Aↄ̃ bèńnɛ: Wé fↄ̃ wà beee kɛro, wé fↄ̃ wà wa dãre kpá gɛfↄↄdeearo, zaakɛ wíyãmɛ wa kiia. ");
INSERT INTO bus_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Wé we a yãziro, séto à gↄ̃ lán wapinↄ bà a gↄ̃gbɛ̃nↄ bã̀ngu kɛ ń píngi. ");
INSERT INTO bus_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Tó a bã̀ngu kɛ̀, wé wa nɛ́nↄ kpãsãawa wé a nɛ́nↄ sɛ́ nↄↄ ũ. Wégↄ̃ kúao, wé gↄ̃ bori dↄ̃nkↄ̃nↄ ũ. ");
INSERT INTO bus_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mↄde tó ée we wa yãziro, tó ée bã̀ngu kɛro, wé wa dãre sɛ́ wà táomɛ. ");
INSERT INTO bus_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Yã pì kɛ̀ Amↄ kↄ̃n a nɛ́ Sɛkɛmuonɛ nna. ");
INSERT INTO bus_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Gↄ̃kparɛ pì yã pì gↄ̃̀gↄ̃ kpakpaa kɛ̀ Yakubu nɛ́nↄgbɛ̃ yã kànɛ yãnzi. À bɛ̀ɛ vĩ dɛńla a de bɛdeenↄ tɛ́. ");
INSERT INTO bus_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Amↄ kↄ̃n a nɛ́ Sɛkɛmuo gàa ń wɛ́tɛ bĩilɛa, ben aↄ̃ yã ò kↄ̃n wɛ́tɛdeenↄ wà bè: ");
INSERT INTO bus_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Gbɛ̃ pìnↄ yãke vĩwaoro. Wà tó aↄ̃gↄ̃ kú wa bùsun aↄ̃gↄ̃ laa taa, zaakɛ bùsu pì yàasa eé mↄ́wa. Wé ń nɛ́nↄgbɛ̃nↄ sɛ́ wé wa nɛ́nↄ kpáḿma. ");
INSERT INTO bus_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Gbɛ̃ pìnↄ sↄ̃ é we wàgↄ̃ kúwao lɛ wà gↄ̃ bori dↄ̃nkↄ̃ ũro, séto èe kɛ wa gↄ̃gbɛ̃ píngi bã̀ngu kɛ̀ lán ń bà baasiro. ");
INSERT INTO bus_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Aↄ̃ pↄ́kãdeenↄ kↄ̃n ń auzikinↄ kↄ̃n ń zùnↄ píngi é gↄ̃ wa pↄ́ ũroo? Wà weńnɛ lɛ aↄ̃gↄ̃ kúwao. ");
INSERT INTO bus_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Wɛ́tɛ pì deenↄ Amↄ kↄ̃n a nɛ́ Sɛkɛmuo yã mà, ben aↄ̃ gↄ̃gbɛ̃nↄ bã̀ngu kɛ̀ ń píngi. ");
INSERT INTO bus_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","À gurↄ aagↄ̃dee zĩ, kɛ̀ aↄ̃ↄ kú kↄ̃n wãwãao aↄ̃ↄ kú kↄ̃n yãke laasuuoro, Yakubu nɛ́ gↄ̃ↄn plaaanↄ Simɛↄ kↄ̃n Levio, Dina vĩ̀inↄ, aↄ̃ baade a fɛ̃ɛdaa sɛ̀ aↄ̃ sì wɛ́tɛ aↄ̃ gↄ̃gbɛ̃nↄ dɛ̀dɛ ń píngi. ");
INSERT INTO bus_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Aↄ̃ Amↄ kↄ̃n a nɛ́ Sɛkɛmuo dɛ̀dɛ, ben aↄ̃ Dina sɛ̀ aↄ̃ bↄ̀o Sɛkɛmu kpɛ́n aↄ̃ tào. ");
INSERT INTO bus_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Wɛ́tɛdeenↄ dɛdɛna gbɛra Yakubu nɛ́nↄ mↄ̀ wà wɛ́tɛ pↄ́nↄ nàkↄ̃a kɛ̀ wà wí dà ń dãrea yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Aↄ̃ ń sãanↄ kↄ̃n ń blènↄ sɛ̀ɛ kↄ̃n ń zùnↄ kↄ̃n ń zaakinↄ, pↄ́ kɛ̀ aↄ̃ↄ kú wɛ́tɛ guunↄ kↄ̃n pↄ́ kɛ̀ aↄ̃ↄ kú ń buraanↄ píngi. ");
INSERT INTO bus_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Aↄ̃ ń auzikinↄ sɛ̀ɛ píngi kↄ̃n ń nɛ́nↄ kↄ̃n ń nↄgbɛ̃nↄ kↄ̃n pↄ́ kɛ̀ kú ń bɛɛnↄ píngi. ");
INSERT INTO bus_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ben Yakubu bè Simɛↄnɛ kↄ̃n Levio: A sumɛ yã zaaao. Kanaanↄ kↄ̃n Pɛrizinↄ kↄ̃n bùsu kɛ̀kii bori pãndenↄ égↄ̃ ye ma kãziro. Lán wá pariro nà, tó aↄ̃ lìgawazi, tó aↄ̃ sìwagu, aↄ̃é ma dɛ kↄ̃n ma boriinↄo píngimɛ. ");
INSERT INTO bus_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ben aↄ̃ wèàla wà bè: Kɛ̀ à wa dãre dìɛ kaarua ũ, beee maan gweↄ́? ");
INSERT INTO bus_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Luda bè Yakubunɛ: Ǹ fɛɛ ǹ tá Bɛtɛli ǹ vɛ̃ɛ gwe. Ǹ ma gbãgbãkii bo gwe, zaakɛ ma bↄ ma mↄnzi gwe gurↄↄ kɛ̀ nɛ́ɛ bàa lɛɛ n vĩ̀inɛ. ");
INSERT INTO bus_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ben Yakubu bè a bɛdeenↄnɛ kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ kúonↄ ń píngi: À bori zĩ̀tↄnↄ tãa kɛ̀ á vĩinↄ kwɛ́ɛ à zú o à a pↄ́kãsãanↄ lendee kpá. ");
INSERT INTO bus_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Wé fɛɛ wà tá Bɛtɛli. Mɛ́ Luda gbãgbãkii bo gwe, zaakɛ à dↄ̀malɛ ma nawɛ̃akɛgurↄ, ègↄ̃ kúmao guu kɛ̀ ma gaan píngi. ");
INSERT INTO bus_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ben aↄ̃ bori zĩ̀tↄnↄ tãa kɛ̀ aↄ̃ↄ vĩinↄ kpàa kↄ̃n swãi kɛ̀ aↄ̃ↄ dananↄ, ben à pↄ́ pìnↄ vĩ̀i gbíi lí gbáru Sɛkɛmu saɛ. ");
INSERT INTO bus_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Kɛ̀ Yakubu kↄ̃n a nɛ́nↄ dà zɛ́n, Ludaa tò vĩa wɛ́tɛ kɛ̀ kú ń saɛnↄ deenↄ kũ̀ maamaa, ben aↄ̃ gbɛ̃kee e pɛ́ɛńziro. ");
INSERT INTO bus_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ben Yakubu kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ kúonↄ ń píngi kà Luzu kɛ̀ wè be tia Bɛtɛli, Kanaa bùsun. ");
INSERT INTO bus_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","À sa'okii bò gwe, ben à tↄ́ kpà guu pìnɛ Bɛtɛli Luda, zaakɛ gwen Luda bↄ̀ à mↄ̀zin gurↄↄ kɛ̀ èe bàa sii a vĩ̀inɛ. ");
INSERT INTO bus_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Debora kɛ̀ dɛ Rɛbɛka gwàri ũ yãa gà gwe, ben wà à vĩ̀i gbíi lí gbáru Bɛtɛli saɛ. Ben wà tↄ́ kpànɛ Ɔ́ↄdↄlizi. ");
INSERT INTO bus_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Luda bↄ̀ à mↄ̀ Yakubuzi dↄ à suna kↄ̃n Mɛsↄpↄtamiao gbɛra, à aubarika dàn ");
INSERT INTO bus_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","à bè: N tↄ́n Yakubu, mↄde weé bennɛ Yakubu dↄro, sé Isaraili. Lɛmɛ à tↄ́ kpànɛ Isaraili lɛ. ");
INSERT INTO bus_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Luda bènɛ dↄ: Luda Gbãapingiden ma ũ. Àgↄ̃ nɛ́ ii àgↄ̃ kaara. Borii é bↄ n kiia kↄ̃n bori pariinↄ dↄ, n bori kenↄ égↄ̃ dɛ kínanↄ ũ. ");
INSERT INTO bus_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Mɛ́ bùsu kɛ̀ má kpà Ibraĩ kↄ̃n Isaakuoa kpámma kↄ̃n n boriinↄ n gaa gbɛra. ");
INSERT INTO bus_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ben Luda fɛ̀ɛ à bↄ̀ guu kɛ̀ à yã ònɛn. ");
INSERT INTO bus_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakubu gbɛ̀ pɛ̀ɛ guu kɛ̀ Luda yã ònɛn dↄngupↄ ũ. À í tↄ̃̀a à nↄ́si kùa. ");
INSERT INTO bus_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ben Yakubu tↄ́ kpà guu kɛ̀ Luda yã ònɛn pìnɛ Bɛtɛli. ");
INSERT INTO bus_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ben aↄ̃ fɛ̀ɛ Bɛtɛli wà dà zɛ́n. Kɛ̀ aↄ̃ kà kĩi kↄ̃n Ɛflatao, Rasɛli nɛ́'igurↄↄ kà, ben nɛ́'ii kɛ̀a zĩ'ũ. ");
INSERT INTO bus_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Nɛ́'iwãwãa à kũ̀ gbãa, ben nɛ́sɛɛri bènɛ: Ǹton vĩa kɛro, n nɛ́gↄ̃gbɛ̃ ì dↄ. ");
INSERT INTO bus_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Rasɛli gbãa vĩ dↄro èe gaa, ben à tↄ́ kpà a nɛ́ pìnɛ Bɛnↄni, ben à de tↄ́ kpànɛ Bɛyãmi. ");
INSERT INTO bus_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Kɛ̀ Rasɛli gà, wà à vĩ̀i Ɛflata kɛ̀ wè be tia Bɛtɛlɛmu zɛ́n. ");
INSERT INTO bus_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakubu gbɛ̀ dↄngupↄ pɛ̀ɛ à miraa. Rasɛli mira gbɛ̀ pì kú gwe ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isaraili ɛ̀ara à dà zɛ́n, ben à bùra kàɛ sãdãrinↄ gugwagba aɛ. ");
INSERT INTO bus_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Gurↄↄ kɛ̀ à kú bùsu pìn Rubɛni gàa à dàɛ kↄ̃n Bilao, Yakubu nↄ yìgisai, ben Yakubu yã pì mà. Yakubu nɛ́gↄ̃gbɛ̃nↄ ì mɛ̀n kuri awɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea nɛ́gↄ̃gbɛ̃nↄn yɛ̀: Yakubu daudu Rubɛni, Simɛↄ, Levi, Yuda, Isaka kↄ̃n Zɛbulunio. ");
INSERT INTO bus_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rasɛli nɛ́nↄn Yusufu kↄ̃n Bɛyãmio ũ. ");
INSERT INTO bus_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rasɛli zĩkɛri Bila nɛ́nↄn Dani kↄ̃n Nafatalio ũ. ");
INSERT INTO bus_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lea zĩkɛri Zilipa nɛ́nↄn Gada kↄ̃n Asao ũ. Nɛ́gↄ̃gbɛ̃ kɛ̀ wà ń í kↄ̃n Yakubuo Mɛsↄpↄtamianↄn gwe. ");
INSERT INTO bus_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ben Yakubu kà a de Isaaku kiia Mamare. À kú Kiriataba kɛ̀ wè be tia Ɛblↄnu saɛ, guu kɛ̀ Ibraĩ kↄ̃n Isaakuo vɛ̃̀ɛn. ");
INSERT INTO bus_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaaku kà wɛ̃̀ bakɛ̃ndo ");
INSERT INTO bus_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","à zi kũ̀ kótokoto, ben à gà à kà a gbɛ̃nↄla, ben à nɛ́nↄ Isau kↄ̃n Yakubuo à vĩ̀i. ");
INSERT INTO bus_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Isau kɛ̀ wè benɛ dↄ Ɛdↄmu boriinↄ yãn yɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Isau Kanaa nↄgbɛ̃nↄ sɛ̀, Iti bori Ɛlↄni nɛ́ Ada kↄ̃n Ivi bori Ana nɛ́ Ɔↄlibama, Zibɛↄ̃ dioo. ");
INSERT INTO bus_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","À Sumaila nɛ́ Basɛma, Nɛbayo dãre sɛ̀ dↄ. ");
INSERT INTO bus_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada Ɛlifaza ìo, ben Basɛma Ruɛli ì. ");
INSERT INTO bus_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ɔↄlibama Yeusu kↄ̃n Yalamuo kↄ̃n Korao ì. Isau nɛ́gↄ̃gbɛ̃ kɛ̀ wà ń í Kanaa bùsunↄn gwe. ");
INSERT INTO bus_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Isau a nↄↄnↄ sɛ̀ɛ kↄ̃n a nɛ́gↄ̃gbɛ̃nↄ kↄ̃n a nɛ́nↄgbɛ̃nↄ kↄ̃n a bɛdeenↄ ń píngi kↄ̃n a pↄ́kãdeenↄ kↄ̃n a auziki kɛ̀ à è Kanaa bùsunnↄ píngi, ben à gàa Sei bùsun à zã̀ kũ̀ kↄ̃n a dãaro Yakubuo, ");
INSERT INTO bus_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","zaakɛ aↄ̃ auziki bíta bé à tò aↄ̃é fↄ̃ wàgↄ̃ kú kↄ̃oro. Bùsu kɛ̀ aↄ̃ↄ kún e mↄ́ḿmaro, kɛ̀ aↄ̃ pↄ́nↄↄ pari yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Isau vɛ̃̀ɛ Sei gusĩsĩdeen kɛ̀ wè be tia Ɛdↄmu. ");
INSERT INTO bus_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Isau kɛ̀ dɛ Ɛdↄmunↄ dezi káaku ũ boriinↄn yɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Isau nɛ́gↄ̃gbɛ̃nↄ tↄ́n yɛ̀: Ada nɛ́ Ɛlifaza kↄ̃n Basɛma nɛ́ Ruɛlio. ");
INSERT INTO bus_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ɛlifaza nɛ́gↄ̃gbɛ̃nↄn Temana, Omaa, Zefo, Gatamu kↄ̃n Kenazio ũ. ");
INSERT INTO bus_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ɛlifaza nↄ yìgisain Timina ũ. Àmbe à Amalɛki ìo. Isau nↄ Ada dionↄn gwe. ");
INSERT INTO bus_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ruɛli nɛ́gↄ̃gbɛ̃nↄn yɛ̀: Naata, Zɛra, Sama kↄ̃n Mizao. Isau nↄ Basɛma dionↄn gwe. ");
INSERT INTO bus_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Isau nↄ Ana nɛ́ Ɔↄlibama, Zibɛↄ̃ dioo nɛ́gↄ̃gbɛ̃nↄn yɛ̀: Yeusu, Yalamu kↄ̃n Korao. ");
INSERT INTO bus_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Isau bori kínanↄn yɛ̀: Isau daudu Ɛlifaza bori kínanↄn Temana, Omaa, Zefo, Kenazi, ");
INSERT INTO bus_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatamu kↄ̃n Amalɛkio ũ. Ɛlifaza bori kínanↄ, Ada dionↄn gwe. Aↄ̃ↄ kú Ɛdↄmunↄ bùsun. ");
INSERT INTO bus_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Isau nɛ́ Ruɛli bori kínanↄn yɛ̀: Naata, Zɛra, Sama kↄ̃n Mizao. Ruɛli bori kínanↄ, Basɛma dionↄn gwe. Aↄ̃ↄ kú Ɛdↄmunↄ bùsun. ");
INSERT INTO bus_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Isau nↄ Ɔↄlibama bori kínanↄn yɛ̀: Yeusu, Yalamu kↄ̃n Korao. Ana nɛ́ Ɔↄlibama dionↄn gwe. ");
INSERT INTO bus_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Isau kɛ̀ wè benɛ dↄ Ɛdↄmu nɛ́gↄ̃gbɛ̃nↄn gwe, à bori kínanↄn gwe. ");
INSERT INTO bus_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Sei, Ori borii kɛ̀ kú Ɛdↄmunↄ bùsun zaa káaku nɛ́gↄ̃gbɛ̃nↄn yɛ̀: Lotana, Sobala, Zibɛↄ̃, Ana, ");
INSERT INTO bus_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disↄ̃, Ɛza kↄ̃n Disão. ");
INSERT INTO bus_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotana nɛ́gↄ̃gbɛ̃nↄn yɛ̀: Ori kↄ̃n Omamuo. Lotana dãren Timina ũ. ");
INSERT INTO bus_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobala nɛ́gↄ̃gbɛ̃nↄn yɛ̀: Alavã, Manaa, Ebala, Sefo kↄ̃n Onamuo. ");
INSERT INTO bus_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibɛↄ̃ nɛ́gↄ̃gbɛ̃nↄn yɛ̀: Aya kↄ̃n Anao. Ana pì bé à bↄ̀ bia wãaa zaa gbáan gurↄↄ kɛ̀ èe a de zaakinↄ dãa. ");
INSERT INTO bus_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana nɛ́gↄ̃gbɛ̃n Disↄ̃ ũ, à nɛ́nↄgbɛ̃ sↄ̃ Ɔↄlibama. ");
INSERT INTO bus_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disↄ̃ nɛ́gↄ̃gbɛ̃nↄn yɛ̀: Ɛmɛdã, Ɛsɛbã, Itirana kↄ̃n Keranao. ");
INSERT INTO bus_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ɛza nɛ́gↄ̃gbɛ̃nↄn yɛ̀: Bilana, Zavã kↄ̃n Akanao. ");
INSERT INTO bus_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disã nɛ́gↄ̃gbɛ̃nↄn yɛ̀: Uzu kↄ̃n Aranao. ");
INSERT INTO bus_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ori bori kínanↄn yɛ̀: Lotana, Sobala, Zibɛↄ̃, Ana, ");
INSERT INTO bus_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disↄ̃, Ɛza kↄ̃n Disão. Ori bori kínanↄ kↄ̃n ń borii kɛ̀ aↄ̃ↄ kú Sei bùsunnↄn gwe. ");
INSERT INTO bus_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Kína kɛ̀ aↄ̃ kí blè Ɛdↄmunↄ bùsun Isarailinↄ kínanↄ ãanↄn yɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bɛↄ nɛ́ Bɛla, Dinaba gbɛ̃ bé à kí blè Ɛdↄmu káaku. ");
INSERT INTO bus_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Kɛ̀ à gà, ben Zɛra nɛ́ Yobabu, Bↄzↄra gbɛ̃ kí blè à gɛ̃ɛ ũ. ");
INSERT INTO bus_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Kɛ̀ à gà, ben Temana bùsu gbɛ̃ Usamu kí blè à gɛ̃ɛ ũ. ");
INSERT INTO bus_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Kɛ̀ à gà, ben Bedada nɛ́ Adada, Avi gbɛ̃ kí blè à gɛ̃ɛ ũ. Àmbe à zĩ̀ blè Midiãnↄa Mↄabunↄ bùsun. ");
INSERT INTO bus_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Kɛ̀ à gà, ben Masareka gbɛ̃ Samala kí blè à gɛ̃ɛ ũ. ");
INSERT INTO bus_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Kɛ̀ à gà, ben Reobo kɛ̀ kú Yuflati saɛ gbɛ̃ Saulu kí blè à gɛ̃ɛ ũ. ");
INSERT INTO bus_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Kɛ̀ à gà, ben Akabo nɛ́ Baali Ana kí blè à gɛ̃ɛ ũ. ");
INSERT INTO bus_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Kɛ̀ à gà, ben Pau gbɛ̃ Adada kí blè à gɛ̃ɛ ũ. À nↄↄ tↄ́n Mɛtabɛli, Matarɛdi nɛ́mɛ, Mɛzaba dio. ");
INSERT INTO bus_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Isau bori kínanↄ tↄ́n yɛ̀ kↄ̃n ń bùsunↄ: Timina, Alava, Yɛtɛ, ");
INSERT INTO bus_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Ɔↄlibama, Ela, Pinↄ, ");
INSERT INTO bus_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenazi, Temana, Mibiza, ");
INSERT INTO bus_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magadiɛli kↄ̃n Iramuo. Ɛdↄmunↄ kínanↄn gwe wɛ́tɛ kↄ̃n wɛ́tɛo bùsu kɛ̀ aↄ̃ vɛ̃̀ɛn. Isau kɛ̀ dɛ Ɛdↄmunↄ dezi ũu boriinↄn gwe. ");
INSERT INTO bus_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakubu kú Kanaa bùsun guu kɛ̀ a de vɛ̃̀ɛn. ");
INSERT INTO bus_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yakubu boriinↄ yãn yɛ̀. Yusufu nɛ́ gↄ̃kparɛmɛ. À wɛ̃̀ gɛ̃ro awɛɛplaadee guu kɛ̀ èe sãanↄ dãa kↄ̃n a vĩ̀inↄ, à de nↄↄnↄ Bila kↄ̃n Zilipao nɛ́nↄ, ben à dà zaaa kɛ̀ aↄ̃ↄ kɛ̀ kↄmↄtↄ kɛ̀ a denɛ. ");
INSERT INTO bus_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Isaraili ye Yusufuzi dɛ a nɛ́ kpaaanↄla kɛ̀ à à ì a zikũ guu yãnzi, ben à utagyaba zↄ̃̀nɛ. ");
INSERT INTO bus_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Kɛ̀ à vĩ̀inↄ è ń dee ye Yusufuzi dɛńla, ben aↄ̃ zàn aↄ̃è we wà yã nnaa ooro. ");
INSERT INTO bus_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Yusufu nanaa ò, ben à tↄ̃kɛ̃̀ a vĩ̀inↄnɛ, ben aↄ̃ ɛ̀ara wà zàn dɛ zi pↄ́la. ");
INSERT INTO bus_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","À bèńnɛ: À nanaa kɛ̀ má ò ma. ");
INSERT INTO bus_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Má è wée ése yiyii bura, ben ma ése bakaa fɛ̀ɛ à zɛ̀. A pↄ́nↄ lìgazi, ben aↄ̃ nàɛnɛ. ");
INSERT INTO bus_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ben à vĩ̀inↄ bènɛ: Nɛ́ kí blewan yↄ́? Nɛ́ gbãaa blewan yↄ́? Ben aↄ̃ ɛ̀ara wà zàn dɛ yã pↄ́la nanaa kɛ̀ à ò pì yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yusufu ɛ̀ara à nanaa ò dↄ, ben à tↄ̃kɛ̃̀ a vĩ̀inↄnɛ à bè: Ma ɛara ma nanaa ò dↄ. Má è ↄfãntɛ̃ kↄ̃n mↄvurao kↄ̃n sↄsↄnɛ mɛ̀n kuri awɛɛdoonↄↄ e naɛɛmɛ. ");
INSERT INTO bus_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","À nanaa pì tↄ̃kɛ̃̀ a denɛ dↄ, ben à de pàtaa à bè: Nana kparee takan ń ò lɛɛ? Mapi kↄ̃n n dao kↄ̃n n vĩ̀inↄ, wé mↄ́ wà kúɛ n aɛn yↄ́? ");
INSERT INTO bus_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","À vĩ̀inↄ nↄ̀sɛgↄ̃aanↄ kpào. À de sↄ̃ nanaa pì yã kũna a nↄ̀sɛ guu. ");
INSERT INTO bus_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","À vĩ̀inↄ gàa ń de sãanↄ dã Sɛkɛmu. ");
INSERT INTO bus_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ben Isaraili bè Yusufunɛ: N vĩ̀inↄ e sãa dãa Sɛkɛmu. Mɛ́ n zĩ ń kiia. À wèàla à bè: Ma yãa. ");
INSERT INTO bus_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ben à bènɛ: Ǹ gá ǹ n vĩ̀inↄ gwa kↄ̃n sãanↄ, tó aↄ̃ↄ aafia. Ǹ ɛara ǹ sumɛ kↄ̃n aↄ̃ baaruo. Ben à à gbàrɛ, à bↄ̀ Ɛblↄnu guzurɛn à gàa Sɛkɛmu. ");
INSERT INTO bus_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Èe likↄ̃aa zↄ̃ↄ sɛ̃̀n, ben gↄ̃gbɛ̃ ke dààlɛ à à là: Bↄ́n nɛ́ɛ wɛtɛɛ? ");
INSERT INTO bus_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","À wèàla à bè: Mɛ́ɛ ma vĩ̀inↄ wɛtɛɛmɛ. Tó ń ń sãdãkii dↄ̃, ǹ omɛ. ");
INSERT INTO bus_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Gↄ̃gbɛ̃ pì bè: Kɛ̀ aↄ̃ bↄ̀ gura kɛ̀, má mà aↄ̃ bè wèe gaa Dotãmɛ. Ben Yusufu pɛ̀ɛńzi à ń lé Dotã. ");
INSERT INTO bus_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Kɛ̀ aↄ̃ à è kãaa, ai àgↄ̃ gá ká ń kiia, aↄ̃ lɛ́ kpàkↄ̃sↄ̃zi wà bè wà à dɛ. ");
INSERT INTO bus_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Aↄ̃ bèkↄ̃nɛ: À gwa, nana'ori e mↄↄ kãaa. ");
INSERT INTO bus_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","À tó wà à dɛ wà à zu lↄ̀gↄ kɛ̀nↄ doke guu, wé be nↄ̀bↄ pãsĩ bé à à dɛ̀ à sò. Ɛ̃ndɛ̃ wé e lán à nanaanↄ é mì dɛ nà. ");
INSERT INTO bus_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Kɛ̀ Rubɛni yã pì mà, à yezi à à mì sí, ben à bè: Wàton à dɛro, ");
INSERT INTO bus_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","àton aru bↄaro. À à zu lↄ̀gↄ kɛ̀kiin gbáan kɛ̀. Àton à dɛro. Rubɛni òńnɛ lɛ, kɛ̀ à yezi à à mì sí à à kpá a dea yãnzimɛ. ");
INSERT INTO bus_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Kɛ̀ Yusufu kà a vĩ̀inↄ kiia, aↄ̃ à uta bↄ̀, à utagyaba maaa pì. ");
INSERT INTO bus_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ben aↄ̃ à sɛ̀ wà à zù lↄ̀gↄ pìn. Lↄ̀gↄ pì da korimɛ à í vĩro. ");
INSERT INTO bus_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ben aↄ̃ vɛ̃̀ɛ wèe pↄ́ blee. Kɛ̀ aↄ̃ wɛ́ɛ sɛ̀, aↄ̃ Sumaila bori laatarinↄ è, aↄ̃ bↄ̀ Giliada bùsun aↄ̃ↄe gaa Igipiti. Aↄ̃ lakuminↄↄ dò pↄ́nↄ kↄ̃n lí'ↄ ɛ̃zɛ̃o kↄ̃n lí'ↄ gũ nnannaao sɛna. ");
INSERT INTO bus_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ben Yuda bè a gbɛ̃nↄnɛ: Tó wa wa dãaro dɛ̀, ben wa à gɛ̀ ùtɛ, bↄ́ àren wé ee? ");
INSERT INTO bus_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","À tó wà à yá Sumaila borii pìnↄa. Wàton à dɛro, wa dãaronloo? Wa aru dↄ̃nkↄ̃mɛ. Ben à gbɛ̃nↄ à yã mà. ");
INSERT INTO bus_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Kɛ̀ Midiã laatari pìnↄↄ e mↄↄ gɛ̃ zɛ́la, ben aↄ̃ Yusufu gà wà bↄ̀ lↄ̀gↄn, aↄ̃ à yà Sumaila borii pìnↄa kondogi baro, ben wà tào Igipiti. ");
INSERT INTO bus_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Kɛ̀ Rubɛni mↄ̀ lↄ̀gↄ pì kiia, èe Yusufu e gwe dↄro, ben à a pↄ́kãsãanↄ gà à kɛ̃̀kɛ̃, ");
INSERT INTO bus_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ben à gàa a dãaronↄ kiia à bè: Nɛ́ pì kú gwe dↄro. Mɛ́ gá má kↄ̃n beeeo? ");
INSERT INTO bus_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Aↄ̃ blèkofĩi kũ̀ wà dɛ̀, ben aↄ̃ Yusufu uta pì sɛ̀ wà màɛ à aru guu. ");
INSERT INTO bus_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ben aↄ̃ à utagyaba pì sɛ̀ wà gàao ń denɛ aↄ̃ bè: Pↄ́ kɛ̀ wá èn yɛ̀. N nɛ́ utan yↄ́, ke à pↄ́nlo? ");
INSERT INTO bus_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","À dↄ̃̀, ben à bè: Ma nɛ́ utamɛ, nↄ̀bↄ pãsĩ bé à à sò. Wãiyoo, wà ma nɛ́ Yusufu kã̀sãkãsãkↄ̃ɛmɛ. ");
INSERT INTO bus_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ben à a utadaa gà à kɛ̃̀ à pↄ́kãsãa sɛ̀ à dà, ben à a nɛ́ pì sósobi kɛ̀ gìkɛna. ");
INSERT INTO bus_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","À nɛ́gↄ̃gbɛ̃nↄ kↄ̃n à nɛ́nↄgbɛ̃nↄ mↄ̀ à làakari kpáɛnɛ ń píngi, mↄde à gì a làakari kpáɛzi à bè: Mɛ́gↄ̃ ma nɛ́ pì gɛ̀ ↄ́ↄ dↄↄmɛ ai mà gá táo à kiia gɛ̀wãan. Ben èe sósobi ↄ́ↄ dↄↄ a nɛ́ pì yã musu. ");
INSERT INTO bus_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Midiã pìnↄ sↄ̃ Yusufu yà Pↄtifaa Igipiti. Fili'auna ìba kemɛ, àmbe à dogarinↄ gbɛ̃nsi ũ. ");
INSERT INTO bus_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Zĩ beeea Yuda bↄ̀ a gbɛ̃nↄ kiia à gàa à vɛ̃̀ɛ Adulamu gbɛ̃ kɛ̀ wè benɛ Ira bɛ. ");
INSERT INTO bus_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Gwen à dàkↄ̃rɛ kↄ̃n Kanaa bùsu gbɛ̃ kɛ̀ wè benɛ Sua nɛ́nↄgbɛ̃o, ben à à sɛ̀ nↄↄ ũ. ");
INSERT INTO bus_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","À nↄ̀ sì à nɛ́ ì gↄ̃gbɛ̃ ũ, ben à tↄ́ kpànɛ Ɛɛ. ");
INSERT INTO bus_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","À ɛ̀ara à nↄ̀ sì dↄ à nɛ́gↄ̃gbɛ̃ ì, ben à tↄ́ kpànɛ Ona. ");
INSERT INTO bus_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","À ɛ̀ara à nɛ́gↄ̃gbɛ̃ ì dↄ, ben à tↄ́ kpànɛ Sela. Gurↄↄ kɛ̀ à nɛ́ pì ì, à kú Kezibimɛ. ");
INSERT INTO bus_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ben Yuda nↄgbɛ̃ kɛ̀ wè benɛ Tama sɛ̀ a daudu Ɛɛnɛ. ");
INSERT INTO bus_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ɛɛ kɛ̀ Diinɛ zaa, ben à à dɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ben Yuda bè Onanɛ: Ǹ n vĩ̀i gyaanↄↄ sɛ́ ǹ borii kɛ n vĩ̀inɛ, lán wè kɛ nà. ");
INSERT INTO bus_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Kɛ̀ Ona dↄ̃ kɛ̀ nɛ́ kɛ̀ é i kↄ̃n a vĩ̀i gyaanↄↄo égↄ̃ dɛ a borii ũro, tó à dàɛo ben à yezi a zĩnda e, è à gↄ̃gbɛ̃ pↄ́ kwɛ́ɛmɛ, lɛ àton borii kɛ a vĩ̀inɛro yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Yã kɛ̀ èe kɛɛ pì kɛ̀ Diinɛ zaa, ben à à dɛ̀ dↄ. ");
INSERT INTO bus_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ben Yuda bè a nɛ́ gyaanↄ Tamanɛ: Ǹ gá ǹgↄ̃ gyaanↄↄ blee n de bɛ ai ma nɛ́ Sela ìsi kũ. Zaakɛ èe daa Sela é ga lán a vĩ̀inↄ bàmɛ. Ben Tama gàa à vɛ̃̀ɛ a de bɛ. ");
INSERT INTO bus_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Kɛ̀ à gurↄↄ gì kɛ̀, ben Yuda naↄ̃ gà. Kɛ̀ à nↄ̀sɛ kpàɛ, à dà zɛ́n èe gaa a sãkãkɛ̃ɛrinↄ kiia Timina kↄ̃n a gbɛ̃nna Irao. ");
INSERT INTO bus_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ben wà à baaru kpà Tamanɛ wà bè: N zã de e gaa Timina a sãanↄ kã kɛ̃ɛ. ");
INSERT INTO bus_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ben à a gyaanↄblepↄnↄ bↄ̀ à pↄ́dangãn sɛ̀ à kù a uua, ben à gàa à vɛ̃̀ɛ Enaimu bĩilɛa Timina zɛ́n. Zaakɛ à è Sela bíta kũ̀, wèe à kpáa nↄↄ ũro. ");
INSERT INTO bus_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Kɛ̀ Yuda à è, ben à à dìɛ kaarua ũ kɛ̀ à pↄ́ kù a uua yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ben à sↄ̃̀zi zɛ́ saɛ à bè: Ǹ tó mà daɛnyo. Èe à dↄ̃ a nɛ́ gyaanↄↄ ũro. Ben nↄgbɛ̃ pì bè: Tó n daɛmao, bↄ́n nɛ́ kpámaa? ");
INSERT INTO bus_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","À wèàla à bè: Mɛ́ ma kpàsa blènɛ mɛ̀n doo kpãsãnnɛ. Ben à bè: Ǹ tↄↄba diɛmɛ ai ǹgↄ̃ gaa kpãsã. ");
INSERT INTO bus_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ben à à là à bè: Bↄ́ tↄↄban mɛ́ diɛnnɛɛ? A bè: Ǹ n sèedakɛbↄ kↄ̃n a bào kↄ̃n gò kɛ̀ ń kũnao kpáma. Ben à kpàa à dàɛo à nↄ̀ dↄ̀n. ");
INSERT INTO bus_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ben nↄgbɛ̃ pì fɛ̀ɛ à tà bɛ à a pↄ́dangãn bↄ̀ à a gyaanↄblepↄnↄ sɛ̀ à dà. ");
INSERT INTO bus_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuda a gbɛ̃nna Adulamu gbɛ̃ zĩ̀ kↄ̃n blènɛo à tↄↄba boo nↄgbɛ̃ pì kiia. Kɛ̀ à kà, èe à ero. ");
INSERT INTO bus_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ben à gwedeenↄ làla à bè: Kaarua kɛ̀ kú Enaimu zɛ́ saɛ kɛ̀ yã kú máa? Aↄ̃ wèàla wà bè: Kaarua kee kú kɛ̀ro fá! ");
INSERT INTO bus_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ben à ɛ̀ara à tà, à bè Yudanɛ: Mɛ́ɛ à ero. Gwedeenↄ bè wà kaarua ke dↄ̃ gwe yã sero. ");
INSERT INTO bus_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ben Yuda bè: Àgↄ̃ pↄ́ pìnↄ kũna. Wé tó gbɛ̃nↄ wa yáa dↄro. Ma n zĩ kↄ̃n blè pìo, nɛ́ɛ à ero. ");
INSERT INTO bus_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Mↄ aagↄ̃ↄ gbɛra wà mↄ̀ wà ò Yudanɛ wà bè: N nɛ́ naↄ̃ Tama kaarua kà, ben à nↄ̀ sì a pãpãkɛna pì guu. Yuda bè: À bↄo wà tɛ́ sↄ̃a. ");
INSERT INTO bus_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Kɛ̀ wèe bↄↄo bàazi, à lɛ́kpãsã kɛ̀ a zã denɛ à bè: Gbɛ̃ kɛ̀ pↄ́ kɛ̀kiinↄ vĩi bé à nↄ̀ dↄ̀magu. Ǹ sèedakɛbↄ kↄ̃n a bào kↄ̃n gò kɛ̀kiio gwa, tó ń à de dↄ̃. ");
INSERT INTO bus_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda pↄ́ pìnↄ dↄ̃̀, ben à bè: Nↄgbɛ̃ pì yã nna dɛmala, zaakɛ mɛ́ɛ à kpá ma nɛ́ Selaaro. Yuda e daɛo dↄro. ");
INSERT INTO bus_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Kɛ̀ à kà nɛ́'ina, à mↄ̀ à lè sìkanↄ bé wà kú à gbɛɛɛ guu. ");
INSERT INTO bus_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Gurↄↄ kɛ̀ èe nɛ́ ii, aↄ̃ gbɛ̃ndoo ↄ bↄ̀, ben nɛ́sɛɛri wↄ̃ↄ tɛ̃aa dↄ̀a à bè: Nɛ́ kɛ̀kii bé à bↄ̀ káaku. ");
INSERT INTO bus_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Kɛ̀ nɛ́ pì a ↄↄ sↄ̀kpa, ben nɛ́ plaadee bↄ̀, ben nↄgbɛ̃ pì bè: N bↄ bùimɛ fá! Ben wà tↄ́ kpànɛ Pɛrɛzi. ");
INSERT INTO bus_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Beee gbɛra kɛ̀ à gbɛ̃ndoo kɛ̀ wà wↄ̃ↄ tɛ̃aa dↄ̀ à ↄↄa bↄ̀, ben wà tↄ́ kpànɛ Zɛra. ");
INSERT INTO bus_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Kɛ̀ Sumaila boriinↄ kà kↄ̃n Yusufuo Igipiti, ben Igipiti gbɛ̃ Pↄtifa à lùḿma. Fili'auna ìba kemɛ, àmbe à dogarinↄ gbɛ̃nsi ũ. ");
INSERT INTO bus_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Dii kú kↄ̃n Yusufuo à à dàkↄ̃rɛ kↄ̃n mìnnaao. À kú a dii Igipiti gbɛ̃ pì bɛ. ");
INSERT INTO bus_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Kɛ̀ à dii pì è Dii kúo ègↄ̃ à dakↄ̃rɛɛ kↄ̃n saao yã kɛ̀ èe kɛɛnↄ guu píngi, ");
INSERT INTO bus_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ben Yusufu à pↄnnaa è. Pↄtifa à dìɛ a bɛgwari ũ à pↄ́ kɛ̀ à vĩinↄ nànɛ a ↄzĩ píngi. ");
INSERT INTO bus_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Zaa gurↄↄ kɛ̀ à à dìɛ a bɛgwari ũ, Dii aubarika dà à bɛɛn Yusufu yãnzi. Dii aubarika dà pↄ́ kɛ̀ dɛ à pↄ́ ũunↄn píngi, bɛ pↄ́nↄ kↄ̃n bura pↄ́nↄ mámmam. ");
INSERT INTO bus_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ben Pↄtifa a pↄ́ píngi nà Yusufunɛ a ↄzĩ. À bà kú yãkeoro, tó èe kɛ pↄ́blee baasiro. Yusufu sↄ̃ nɛ́ gↄ̃ ↄ̀wazimɛ, ben à zɛna maa. ");
INSERT INTO bus_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Zĩkea Yusufu nii gɛ̃̀ a dii naↄ̃gu, ben à bènɛ: Ǹ daɛmao. ");
INSERT INTO bus_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ben à gì à bè: Ǹ gwa, ma dii bà kú yãkeo ua kɛ̀ guu dↄro, à pↄ́ kɛ̀ à vĩinↄ nàmɛ ma ↄzĩ píngi. ");
INSERT INTO bus_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","À gbãaa dɛmala ua kɛ̀ guuro, èe gímɛ kↄ̃n pↄ́keoro, sé mpi, kɛ̀ ń dɛ à nↄↄ ũ yãnzi. Mɛ́ fↄ̃ mà yã zaa beee taka kɛ mà durun kɛ Ludanɛro. ");
INSERT INTO bus_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Baa kɛ̀ nↄgbɛ̃ pì ègↄ̃ oonɛ baabↄrɛ, èe we à dàɛoro, à yezi àgↄ̃ kúo sero. ");
INSERT INTO bus_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Zĩkea kɛ̀ Yusufu gɛ̃̀ kpɛ́n a zĩi kɛ, à mↄ̀ à lè ua zĩkɛri kee kú kpɛ́ guuro. ");
INSERT INTO bus_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ben nↄgbɛ̃ pì à kũ̀ a utaa à bè: Ǹ daɛmao. Ben Yusufu a uta tònɛ gwe à bàa lɛ̀ à bↄ̀ bàazi. ");
INSERT INTO bus_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Kɛ̀ nↄgbɛ̃ pì è à a uta tòare à bàa lɛ̀ à bↄ̀ bàazi, ");
INSERT INTO bus_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ben à ua zĩkɛrinↄ sìsi à bèńnɛ: À gwa, wà mↄ̀we kↄ̃n Eberuo, ben èe dↄkɛɛwao. À gɛ̃̀mazi à daɛmao, ben ma wii lɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Kɛ̀ à mà ma wiii dↄ̀awa, ben à a uta tò kaɛna ma saɛ à bàa lɛ̀ à bↄ̀ bàazi. ");
INSERT INTO bus_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ben nↄgbɛ̃ pì uta pì kàɛ a saɛ ai Yusufu dii sù, ");
INSERT INTO bus_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ben à bènɛ: Eberu zↄ̀ kɛ̀ n suowe dↄkɛ̀mao à gɛ̃̀mazi. ");
INSERT INTO bus_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Kɛ̀ ma wiii dↄ̀a, ben à à uta tò kaɛna ma saɛ à bàa lɛ̀ à bↄ̀ bàazi. ");
INSERT INTO bus_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Kɛ̀ nↄgbɛ̃ pì yã pì ò a zãnɛ à bè, lán n zↄ̀ kɛ̀mɛ nàn gwe, ben Yusufu dii pↄ fɛ̃̀ maamaa. ");
INSERT INTO bus_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ben à bè wà Yusufu kũ wà à da kpɛ́siaan, guu kɛ̀ kína pisinanↄↄ káɛn, ben à gurↄplaa kɛ̀ gwe. ");
INSERT INTO bus_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Baa kↄ̃n beeeo Dii kúo à gbɛ̃kɛɛ kɛ̀nɛ à tò à yã kà pisinanↄ dãkparin. ");
INSERT INTO bus_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ben dãkpari pì pisinanↄ nà Yusufunɛ a ↄzĩ ń píngi, wè yãke kɛ à sairo. ");
INSERT INTO bus_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Pisinanↄ dãkpari pì bà ègↄ̃ kú Yusufu yãoro, kɛ̀ Dii kúo yãnzi, ben ègↄ̃ à daakↄ̃rɛ kↄ̃n saao yã kɛ̀ èe kɛɛ guu píngi. ");
INSERT INTO bus_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Beee gbɛra Igipiti kí Fili'auna wɛ̃kpaatɛri kↄ̃n a burɛdikɛrio taari kɛ̀nɛ. ");
INSERT INTO bus_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","À pↄ fɛ̃̀ a ìba gↄ̃ↄn plaaa pìnↄzi, à wɛ̃kpaatɛri kí kↄ̃n à burɛdikɛri kío. ");
INSERT INTO bus_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ben à ń ká kpɛ́siaan a dogarinↄ gbɛ̃nsi bɛ, kpɛ́ kɛ̀ wà Yusufu dàn. ");
INSERT INTO bus_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Dogarinↄ gbɛ̃nsi pì Yusufu dìɛ àgↄ̃ ń gwaa, ben aↄ̃ gurↄplaa kɛ̀ kpɛ́ pìn gwe. ");
INSERT INTO bus_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Gwãavĩ dↄ̃nkↄ̃a Igipiti kína wɛ̃kpaatɛri kↄ̃n burɛdikɛri pìo nanaa ò ń gↄ̃ↄn plaaa ń píngi, baade kↄ̃n a pↄ́o kↄ̃n a bↄkↄ̃tɛnao. ");
INSERT INTO bus_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Kɛ̀ Yusufu mↄ̀ ń gwa kↄngↄ, à è aↄ̃ uu sìsi. ");
INSERT INTO bus_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ben à ń lá à bè: Bↄ́ yã bé à tò a uu sisina gbã̀a? ");
INSERT INTO bus_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Aↄ̃ wèàla wà bè: Nanaan wá ò, gbɛ̃kee kú kɛ̀ kɛ̀ à à bↄkↄ̃tɛna owero. Ben à bèńnɛ: Luda bé à nana bↄkↄ̃tɛna vĩroo? À a nanaa pìnↄ omɛ mà ma. ");
INSERT INTO bus_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ben wɛ̃kpaatɛri kí a pↄ́ ònɛ à bè: Ma nanaa guu ma geepi lí è ma saɛ. ");
INSERT INTO bus_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Geepi lí pì gã̀ aagↄ̃mɛ. À lá bↄ̀ à vú kɛ̀ à nɛ́ ì à mà. ");
INSERT INTO bus_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Má Fili'auna togo kũna, ben ma geepi bɛɛ pìnↄ sɛ̀ má fɛ̃̀ à togoo pì guu má kpàa. ");
INSERT INTO bus_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusufu bènɛ: Nanaa pì bↄkↄ̃tɛnan yɛ̀. Lígã aagↄ̃ↄ pìnↄ nɛ́ gurↄ aagↄ̃ↄmɛ. ");
INSERT INTO bus_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Gurↄ aagↄ̃ↄ gbɛra Fili'auna é n mì sí. Eé ɛara à n da n zĩi guu, nɛ́ ɛara ǹgↄ̃ geepiwɛ̃ɛ bↄↄnɛ lán nɛɛ̀gↄ̃ kɛɛ nà yã. ");
INSERT INTO bus_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Tó yã bↄ̀nyo nna, ǹ tó ma yã gↄ̃ dↄngu. Ǹ gbɛ̃kɛɛ kɛmɛ ǹ ma yã o Fili'aunanɛ lɛ à ma bↄ kpɛ́siaa kɛ̀ guu. ");
INSERT INTO bus_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Zaakɛ wà ma kũ kpãi zaa Eberu bùsun, ben baa Igipiti kɛ̀ mɛ́ɛ yãke kɛ à kà wà ma da wɛ̀ɛ kɛ̀ guuro. ");
INSERT INTO bus_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Kɛ̀ burɛdikɛri kí è Yusufu nanaa pì bↄkↄ̃tɛna bↄ̀ kↄ̃n wɛ̃kpaatɛrio nna, ben à bènɛ: Ma nanaa guu sↄ̃ má è má burɛdi sɛna gbíi aagↄ̃ dikↄ̃ana. ");
INSERT INTO bus_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Gbíi kɛ̀ kú musu, burɛdi bori parii kɛ̀ má kɛ̀ Fili'aunanɛ ká à guu, ben bãanↄↄ e blee ma musu. ");
INSERT INTO bus_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusufu bènɛ: À bↄkↄ̃tɛnan yɛ̀. Gbíi aagↄ̃ↄ pìnↄ gurↄ aagↄ̃ↄmɛ. ");
INSERT INTO bus_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Gurↄ aagↄ̃ↄ gbɛra Fili'auna é n mì zↄ̃ à n logo lía, bãanↄ é n ble. ");
INSERT INTO bus_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","À gurↄ aagↄ̃dee sↄ̃ Fili'auna igurↄ làa kↄ̃kↄ̃mɛ, ben à pↄ́blee kɛ̀ a ìbanↄnɛ. À wɛ̃kpaatɛri kí kↄ̃n burɛdikɛri kío bↄ̀ɛ kpɛ́n a ìbanↄ wáa. ");
INSERT INTO bus_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ben à ɛ̀ara à wɛ̃kpaatɛri kí dà a zĩin à ɛara àgↄ̃ í bↄↄare. ");
INSERT INTO bus_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ben à burɛdikɛri kí lògo lía lán Yusufu ń nanaanↄ bↄkↄ̃tɛna òńnɛ nà. ");
INSERT INTO bus_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Yusufu yã e dↄ wɛ̃kpaatɛrikin dↄro, à yã sã̀n. ");
INSERT INTO bus_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Wɛ̃̀ plaa papana gbɛra Fili'auna nanaa ò, à è á zɛna Nili lɛ́a. ");
INSERT INTO bus_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","À è zùda maa mɛ̀kpananↄ bↄ̀ɛ swaa pì wɛ̀ɛn mɛ̀n swɛɛplaa aↄ̃ↄe sɛ̃̀ blee tàfe guu. ");
INSERT INTO bus_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ben à zùda yãyãna wↄ̀zↄgↄwↄzↄgↄnↄ è mɛ̀n swɛɛplaa dↄ. Aↄ̃ bↄ̀ swawɛɛn wà tɛ̀ à káakupↄnↄ kpɛɛ aↄ̃ zɛ̀ ń saɛ swa lɛ́a. ");
INSERT INTO bus_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ben zù yãyãna wↄ̀zↄgↄwↄzↄgↄ pìnↄ zù maa mɛ̀kpana pìnↄ mↄ̀mↄ, ben Fili'auna vù. ");
INSERT INTO bus_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","À ɛ̀ara à ii ò, ben à nanaa ò dↄ. À è ése sáko maa wɛ́ɛdee pìa ése lí dↄ̃nkↄ̃a sáko swɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ben à ése sáko wɛ́ɛ wodowodoo kɛ̀ lou'i kɛ̃̀sãḿmanↄ è, à pìa ń gbɛra dↄ sáko swɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ben ése sáko wɛ́ɛ wodowodoo pìnↄ ése sáko maa wɛ́ɛdee pìnↄ mↄ̀mↄ. Kɛ̀ Fili'auna vù, à è nanaan á ò. ");
INSERT INTO bus_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Kɛ̀ guu dↄ̀, à kú bídi guu, ben à Igipiti màsokɛrinↄ kↄ̃n wɛ́ɛzɛ̃rinↄ sìsi ń píngi. À a nanaanↄ tↄ̃kɛ̃̀ńnɛ, mↄde aↄ̃ gbɛ̃kee e fↄ̃ à à bↄkↄ̃tɛna ònɛro. ");
INSERT INTO bus_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ben wɛ̃kpaatɛri kí fɛ̀ɛ à yã ò Fili'aunanɛ à bè: Taari kɛ̀ má kɛ̀ yãa dↄ̀magu gbã̀a. ");
INSERT INTO bus_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Kí, n pↄ fɛ̃̀ n zↄ̀blerinↄzi yã, ben n ma da kpɛ́siaan n dogarinↄ gbɛ̃nsi bɛ lɛdo kↄ̃n burɛdikɛrikio. ");
INSERT INTO bus_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Gwãavĩ dↄ̃nkↄ̃a wa nanaa ò, wa baade kↄ̃n a pↄ́o kↄ̃n à bↄkↄ̃tɛnao. ");
INSERT INTO bus_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Eberu gↄ̃kparɛ kee kúwao gwe, n dogarinↄ gbɛ̃nsi zↄ̀mɛ. Kɛ̀ wa wa nanaanↄ tↄ̃kɛ̃̀nɛ, ben à wa baade pↄ́ bↄkↄ̃tɛna ònɛ. ");
INSERT INTO bus_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Yã pìnↄ kɛ̀ lán à òwe nà. N ɛara n ma da ma zĩin, ben n burɛdikɛri kí pì lògo lía. ");
INSERT INTO bus_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ben Fili'auna gbɛ̃ zĩ̀ wà Yusufu sísi, ben wà gàa wà à bↄ̀ wɛ̀ɛn kpakpaa. À mì bò à a pↄ́kãsãanↄ lìɛ, ben à gàa Fili'auna kiia. ");
INSERT INTO bus_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ben Fili'auna bènɛ: Ma nanaa ò, gbɛ̃kee e fↄ̃ à à bↄkↄ̃tɛna òmɛro. Má mà wà bè tó wà ònnɛ, nɛɛ̀ fↄ̃ ǹ à bↄkↄ̃tɛna ońnɛ. ");
INSERT INTO bus_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusufu bènɛ: Èe kɛ mámbeero! Luda bé eé à bↄkↄ̃tɛna onnɛ, kí. ");
INSERT INTO bus_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ben Fili'auna bènɛ: Ma nanaa guu má è má zɛna Nili lɛ́a. ");
INSERT INTO bus_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Má è zùda maa mɛ̀kpana mɛ̀n swɛɛplaaanↄ bↄ̀ɛ swawɛɛn aↄ̃ↄe sɛ̃̀ blee tàfe guu. ");
INSERT INTO bus_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ben ma zùda pãndenↄ è dↄ mɛ̀n swɛɛplaa aↄ̃ↄ yãyãna wↄ̀zↄgↄwↄzↄgↄ, mɛ́ɛ zù yãyãna beee takanↄ e Igipiti kɛ̀ zikiro. ");
INSERT INTO bus_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ben zùda yãyãna wↄ̀zↄgↄwↄzↄgↄ pìnↄ zù mɛ̀kpana káakupↄ mɛ̀n swɛɛplaaa pìnↄ mↄ̀mↄ. ");
INSERT INTO bus_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Baa kɛ̀ aↄ̃ ń mↄ́mↄ, aↄ̃ gↄ̃̀ yãyãna lán yãa bàmɛ, gbɛ̃ke é dↄ̃ kɛ̀ aↄ̃ ń mↄ́mↄ sero. Ben ma vu. ");
INSERT INTO bus_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Nanaa guu dↄ má è, ése sáko maa wɛ́ɛde pìa ése lí dↄ̃nkↄ̃a sáko swɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ben má è ése sáko teee wɛ́ɛ wodowodoo kɛ̀ lou'i kɛ̃̀sãḿmanↄ pìa ń gbɛra dↄ sáko swɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ben ése sáko wɛ́ɛ wodowodoo pìnↄ ése sáko wɛ́ɛdee pìnↄ mↄ̀mↄ. Kɛ̀ má ò màsokɛrinↄnɛ, aↄ̃ gbɛ̃kee e fↄ̃ à à bↄkↄ̃tɛna òmɛro. ");
INSERT INTO bus_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ben Yusufu bènɛ: Kí, nanaa kɛ̀ ń ò pìnↄ bↄkↄ̃tɛna dↄ̃nkↄ̃mɛ. Luda yã kɛ̀ à yezi à kɛɛ ↄ̀dↄannɛmɛ, kí. ");
INSERT INTO bus_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Zù maa mɛ̀n swɛɛplaaa pìnↄ nɛ́ wɛ̃̀ swɛɛplaamɛ. Ése sáko wɛ́ɛde sáko swɛɛplaaa pìnↄ sↄ̃ wɛ̃̀ swɛɛplaamɛ. Nanaa pìnↄ bↄkↄ̃tɛna dↄ̃nkↄ̃mɛ. ");
INSERT INTO bus_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Zù yãyãna wↄ̀zↄgↄwↄzↄgↄ mɛ̀n swɛɛplaaa kɛ̀ aↄ̃ bↄ̀ɛ wà tɛ̀ à káakupↄnↄ kpɛɛ pìnↄ nɛ́ wɛ̃̀ swɛɛplaamɛ. Lɛmɛ ése sáko wɛ́ɛ wodowodoo kɛ̀ lou'i kɛ̃̀sãḿma sáko swɛɛplaaa pìnↄ dɛ lɛ dↄ. Beeenↄmɛ wɛ̃̀ swɛɛplaaa kɛ̀ dekaa é ká ũ. ");
INSERT INTO bus_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Lán má ònnɛ nà tia, kí, ma bè Ludaa e yã kɛ̀ à yezi à kɛɛ ↄdↄↄannɛmɛ. ");
INSERT INTO bus_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Blɛwɛɛ égↄ̃ di Igipiti gu píngia maamaa ai wɛ̃̀ swɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Beee gbɛra dekaa é ká ai wɛ̃̀ swɛɛplaa, kãna gbãaa pì yã é sã Igipitinↄn. Dekaa pì é bùsu pì dɛ. ");
INSERT INTO bus_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Dekaa kɛ̀ eé mↄ́ pì égↄ̃ pãsĩ maamaa, kãna gbãaa pì yã é dↄ gbɛ̃ken dↄro. ");
INSERT INTO bus_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Kí, kɛ̀ gɛ̃̀n plaan n nanaa pì ò, kɛ̀ Luda bé à dìɛ yãnzimɛ. Eé kɛ tiamɛ, à seka vĩro. ");
INSERT INTO bus_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Tia sa kí, ǹ wɛ́ɛzɛ̃ri ↄ̃ndↄ̃dee wɛtɛ ǹ diɛ àgↄ̃ dɛ gbãadee ũ Igipiti. ");
INSERT INTO bus_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Kí, ǹ gbɛ̃nↄ diɛ gbɛ̃nsinↄ ũ Igipiti aↄ̃gↄ̃ blɛwɛɛ sↄↄrodee kaakↄ̃a wɛ̃̀ swɛɛplaaa kɛ̀ blɛwɛɛ égↄ̃ din pì guu. ");
INSERT INTO bus_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Aↄ̃é blɛɛ kakↄ̃a wɛ̃̀ maaa kɛ̀ èe mↄↄnↄ guu wà blɛwɛɛ ká dↄ̃̀nↄ guu wɛ́tɛ kↄ̃n wɛ́tɛo kↄ̃n n tↄ́o, aↄ̃égↄ̃ dãkpaa. ");
INSERT INTO bus_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Tó dekaa kɛ̀ é kɛ wɛ̃̀ swɛɛplaaa pì kà Igipiti, blɛɛ pì égↄ̃ dɛ pↄ́ zikana ũ lɛ dekaa pì tón Igipitinↄ dɛdɛro yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Yã pì kɛ̀ Fili'aunanɛ kↄ̃n a ìbanↄ ń píngi, ");
INSERT INTO bus_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ben à bèńnɛ: Gbɛ̃ kɛ̀kii Luda Nini vĩ. Wé gbɛ̃ke e lán à bà dↄↄ́? ");
INSERT INTO bus_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ben à bè Yusufunɛ: Lán Ludaa tò ń yã beeenↄ dↄ̃ píngi nà, wɛ́ɛzɛ̃ri ↄ̃ndↄ̃de kee kuu lán n bàro. ");
INSERT INTO bus_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ḿbe nɛ́gↄ̃ dɛ ma ua gbɛ̃nsi ũ, ma gbɛ̃nↄ égↄ̃ mì siɛɛnnɛ ń píngi. Kpata bé é tó màgↄ̃ dɛnla ado. ");
INSERT INTO bus_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ben à ɛ̀ara à bènɛ: Nɛ́gↄ̃ gbãa vĩ Igipiti bùsu gu píngia. ");
INSERT INTO bus_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ben à tãnga sèedakɛbↄ bↄ̀ a ↄnɛa à dà Yusufunɛ a ↄnɛa, à babagaa uta dànɛ à vura kã̀mbɛɛ dànɛ a waaa. ");
INSERT INTO bus_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","À a sↄ̃goro plaadee kpàa táa'obↄ ũ, ben gbɛ̃ kɛ̀ aↄ̃ↄ dↄnɛ aɛnↄ ègↄ̃ pataa: À kúɛ! À kúɛ! Lɛmɛ Fili'auna tò Yusufu gbãa vĩ Igipiti bùsun lɛ. ");
INSERT INTO bus_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","À bènɛ dↄ: Mámbe Fili'auna, gbɛ̃ke é fↄ̃ à yãke kɛ Igipiti kɛ̀ n lɛ́ saɛro. ");
INSERT INTO bus_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","À tↄ́ kpànɛ Zafɛna Panɛa, ben à Ɛliↄpↄli wɛ́tɛ sa'ori Potifɛra nɛ́nↄgbɛ̃ Asɛna kpàa nↄↄ ũ. ");
INSERT INTO bus_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Gurↄↄ kɛ̀ Yusufu zĩi sɛ̀ Igipiti kí Fili'auna bɛ, à wɛ̃̀ baaakurimɛ. Ben à bↄ̀ Fili'auna kiia à gàa à lili ò Igipiti gu píngia. ");
INSERT INTO bus_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Kãna gbãaa kuu ai wɛ̃̀ swɛɛplaa, blɛwɛɛ din maamaa. ");
INSERT INTO bus_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ben Yusufu blɛwɛɛ kɛ̀ din Igipiti wɛ̃̀ swɛɛplaaa pìnↄ kàkakↄ̃a wɛ́tɛ kↄ̃n wɛ́tɛo pↄ́ zikana ũ, wɛ́tɛ píngi kↄ̃n a buraa kɛ̀ ligazinↄ pↄ́o. ");
INSERT INTO bus_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","A blɛwɛɛ kàkↄ̃a bítabita lán ísialɛ bùsu'ãatɛ̃ bà, ben wà zɛ̀ à zaka lɛ́ yↄ̃naa, kɛ̀ weé fↄ̃ wà à lɛ́ dↄ̃ro yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ai dekaa gↄ̃ gá ká Yusufu naↄ̃ Asɛna, Potifɛra nɛ́, nɛ́gↄ̃gbɛ̃nↄ ì mɛ̀n plaa. ");
INSERT INTO bus_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusufu tↄ́ kpà a daudunɛ Manase à bè: Ludaa tò ma de bɛdeenↄ kↄ̃n nawɛ̃a kɛ̀ má kɛ̀o yã sã̀magu píngi. ");
INSERT INTO bus_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ben à tↄ́ kpà à plaadeenɛ Ɛflaimu à bè: Ludaa tò ma gↄ̃ nɛ́dee ũ bùsu kɛ̀ wà wɛ́ɛ tã̀maan. ");
INSERT INTO bus_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Kɛ̀ kãna gbãaa kɛ̀ kú Igipiti wɛ̃̀ swɛɛplaaa pì yã̀a, ");
INSERT INTO bus_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ben wɛ̃̀ swɛɛplaaa kɛ̀ dekaa é ká nàa lán Yusufu ò nà. Dekaa kà bùsu kↄ̃n bùsuo píngi, mↄde blɛwɛɛ di Igipiti gu píngiamɛ. ");
INSERT INTO bus_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Kɛ̀ nↄaa gɛ̃̀ Igipitinↄn píngi, aↄ̃ wii lɛ̀ Fili'aunanɛ à pↄ́blee kpáḿma. Ben à bèńnɛ ń píngi: À gá Yusufu kiia à kɛ lán eé oare nà. ");
INSERT INTO bus_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Dekaa dà bùsu pìla píngi, ben Yusufu dↄ̃̀nↄ wɛ̃̀wɛ̃ à blɛwɛɛ yàya Igipitinↄa, kɛ̀ dekaa pì gbãa kũ̀ ń bùsun yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ben gbɛ̃nↄ bↄ̀ anduna gu píngia wà mↄ̀ Igipiti blɛwɛɛ lú Yusufua, zaakɛ dekaa gbãa kũ̀ anduna guu píngimɛ. ");
INSERT INTO bus_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Kɛ̀ Yakubu mà blɛwɛɛ kú Igipiti, à bè a nɛ́nↄnɛ: Égↄ̃ káɛ kɛ̀ pãↄ́? ");
INSERT INTO bus_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Má mà blɛwɛɛ kú Igipiti. À gá lúwe gwe, lɛ wàton garo, wàgↄ̃ kuu aafia yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ben Yusufu vĩ̀i gↄ̃ↄn kurinↄ gàa Igipiti blɛwɛɛ lú. ");
INSERT INTO bus_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Yakubu e Yusufu dãaro Bɛyãmi zĩńyoro, zaakɛ à bè: Wègↄ̃ dↄ̃ro tó yã zaaa é à le. ");
INSERT INTO bus_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ben Isaraili nɛ́ pìnↄ gàa blɛwɛɛ lú kↄ̃n gbɛ̃ pãndenↄ, zaakɛ dekaa pì kà Kanaa bùsun dↄ. ");
INSERT INTO bus_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yusufu bé à bùsu pì gbɛ̃nsi ũ. Àmbe è blɛwɛɛ yá baade píngia. Ben à vĩ̀inↄ mↄ̀ wà kùɛnɛ aↄ̃ ń aɛ pɛ̀ɛ tↄↄtɛa. ");
INSERT INTO bus_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Kɛ̀ à a vĩ̀inↄ è, à ń dↄ̃, ben à a zĩnda kɛ̀ńnɛ nibↄ ũ. Ben à yã òńnɛ pãsĩpãsĩ à ń lá à bè: A bↄ máa? Aↄ̃ wèàla wà bè: Wa bↄ Kanaa bùsun wa mↄ blɛwɛɛ lúmɛ. ");
INSERT INTO bus_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yusufu a vĩ̀inↄ dↄ̃̀, mↄde aↄ̃ↄe à dↄ̃ro. ");
INSERT INTO bus_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Nanaa kɛ̀ à ò yã ń yã musu dↄ̀n, ben à bèńnɛ: Gu'asiigwarinↄn a ũ, a mↄ wa bùsu kɛ̃sãkii gwamɛ. ");
INSERT INTO bus_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Aↄ̃ wèàla wà bè: Auo dii! N zↄ̀blerinↄn wa ũ, wa mↄ blɛwɛɛ lúmɛ. ");
INSERT INTO bus_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Dedↄ̃nkↄ̃deenↄn wa ũ wa píngi. Náanɛdeenↄn wa ũ. Wapinↄ n zↄ̀blerinↄ, gu'asiigwarinↄn wa ũro. ");
INSERT INTO bus_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ben à bèńnɛ: Ɛgɛɛmɛ! A mↄ wa bùsu asii dↄ̃mɛ. ");
INSERT INTO bus_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Aↄ̃ bè: Wapinↄ n zↄ̀blerinↄ, dedↄ̃nkↄ̃deenↄn wa ũ, wa gↄ̃ↄn kuri awɛɛplaamɛ. Kanaa bùsu gbɛ̃nↄn wa ũ. Wa dãaro gↄ̃̀ bɛ kↄ̃n wa deo, wa gbɛ̃ndoo kuuro. ");
INSERT INTO bus_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ben Yusufu bèńnɛ: Lán má òare nà, gu'asiigwarinↄn a ũ. ");
INSERT INTO bus_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Yã kɛ̀ é tó mà a yãpuraa dↄ̃ↄn yɛ̀. Kↄ̃n Fili'auna kuunao é bↄɛ kɛ̀ro, séto a dãaro pì mↄ̀ kɛ̀ baasiro. ");
INSERT INTO bus_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","À a gbɛ̃ndoo zĩ à a dãaro sɛ́, a gbɛ̃ kpaaanↄ é gↄ̃ kpɛ́siaan kɛ̀, mɛ́ dↄ̃ tó a yã yãpuraamɛ. Tó lɛnlo, kↄ̃n Fili'auna kuunao gu'asiigwarinↄn a ũ. ");
INSERT INTO bus_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ben à ń ká kpɛ́n ai gurↄ aagↄ̃. ");
INSERT INTO bus_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","À gurↄ aagↄ̃dee zĩ à bèńnɛ: Má Luda vĩa vĩ. À yã kɛ̀ mɛ́ oaree kɛ, é bↄ aafia. ");
INSERT INTO bus_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Tó náanɛdeenↄn a ũ, à a gbɛ̃ndoo tó da kpɛ́n kɛ̀, a gbɛ̃ kpaaanↄ é tá kↄ̃n blɛwɛɛo a bɛde nↄadɛrinↄnɛ, ");
INSERT INTO bus_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","é ɛara à mↄ́mɛ kↄ̃n a dãaro pìo, mɛ́ dↄ̃ kɛ̀ a yã yãpuraamɛ, weé a dɛdɛ dↄro. Ben aↄ̃ wèzi lɛ. ");
INSERT INTO bus_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Aↄ̃ bèkↄ̃nɛ: Yãpuraamɛ taarideenↄn wa ũ yã kɛ̀ wá kɛ̀ wa dãaronɛ yã yãnzi. Wá è gurↄↄ kɛ̀ èe agbaa kpaawe, à kɛ̀ wɛ̃nda, ben wée à yã maro. Beee yãnzin yã kɛ̀ wa lezi. ");
INSERT INTO bus_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ben Rubɛni bèńnɛ: Kɛ̀ má òare àton yãke kɛ nɛ́ pìnɛro, ée ma yã maro. À aru gɛ̃ɛn Ludaa e boowa kɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Aↄ̃ↄ dↄ̃ Yusufu e maaro, zaakɛ kɛ̀ èe yã oońnɛ, wèe liɛɛńnɛmɛ. ");
INSERT INTO bus_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ben à gù ń kiia à gàa à ↄ́ↄ dↄ̀. Kɛ̀ à sù, à yã òńnɛ, ben à Simɛↄ bↄ̀ ń guu à à yì ń wáa. ");
INSERT INTO bus_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yusufu bè, wà blɛwɛɛ káńnɛ ń sàkinↄ pa wà ń baade ↄↄ danɛ à pↄ́n wà zɛ́ kũsãɛ kɛńnɛ. Kɛ̀ wà kɛ̀ńnɛ lɛ, ");
INSERT INTO bus_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","aↄ̃ ń blɛwɛɛnↄ dì ń zaakinↄnɛ, ben aↄ̃ dà zɛ́n. ");
INSERT INTO bus_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Kɛ̀ aↄ̃ kà guu kɛ̀ aↄ̃ↄe iin, kɛ̀ aↄ̃ gbɛ̃ndoo a sàki pòro lɛ à pↄ́ kpá a zaakia, ben à a ↄↄ è a sàki lɛ́n. ");
INSERT INTO bus_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ben à bè a gbɛ̃nↄnɛ: À ma sàki guu gwa, wà ma ↄↄ sↄ̀kpamɛ! Ben swɛ̃̀ kɛ̃̀ńgu, aↄ̃ bèkↄ̃nɛ kↄ̃n luganao: Bↄ́ yãn Ludaa kɛ̀we lɛɛ? ");
INSERT INTO bus_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kɛ̀ aↄ̃ kà ń de Yakubu kiia Kanaa bùsun, aↄ̃ yã kɛ̀ ń lé tↄ̃kɛ̃̀nɛ píngi wà bè: ");
INSERT INTO bus_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Bùsu gbɛ̃nsi pì yã òwe pãsĩpãsĩ à wa diɛ gu'asiigwarinↄ ũmɛ. ");
INSERT INTO bus_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Wa bènɛ náanɛdeenↄn wa ũ, gu'asiigwarinↄn wa ũro. ");
INSERT INTO bus_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Dedↄ̃nkↄ̃deenↄn wa ũ, wa gↄ̃ↄn kuri awɛɛplaamɛ, wa gbɛ̃ndoo kuuro, wa dãaro gↄ̃̀ Kanaa bùsun kↄ̃n wa deo. ");
INSERT INTO bus_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ben bùsu gbɛ̃nsi pì bèwe yã kɛ̀ eé tó à wa dↄ̃ náanɛdeenↄ ũun yɛ̀. À bè wà wa gbɛ̃ndoo tóao, wà blɛwɛɛ sɛ́ wà táo wa bɛde nↄadɛrinↄnɛ, ");
INSERT INTO bus_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","wà liara wà mↄ́are kↄ̃n wa dãaroo, é dↄ̃ sa kɛ̀ gu'asiigwarinↄn wa ũro, náanɛdeenↄn wa ũ, é wa gbɛ̃ndoo kpáwa, wé laa tá bùsu pìn. ");
INSERT INTO bus_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Kɛ̀ aↄ̃ↄe blɛwɛɛ bↄɛɛ ń sàkinↄ guu, aↄ̃ baade a ↄↄsↄnↄ è a pↄ́ guu. Kɛ̀ aↄ̃ ń ↄↄnↄ è lɛ, vĩa ń kũ ń píngi kↄ̃n ń deo. ");
INSERT INTO bus_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ben aↄ̃ de bèńnɛ: Á yezi mà gↄ̃ nɛ́ sain yↄ́? Yusufu kuuro, Simɛↄ kuuro, ben á yezi à Bɛyãmi síma dↄↄ́? Yã píngi e bↄↄmɛ zaamɛ. ");
INSERT INTO bus_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ben Rubɛni bè a denɛ: Tó mɛ́ɛ suonnɛro, ǹ ma nɛ́gↄ̃gbɛ̃ plaaanↄ dɛdɛ. Ǹ à kpáma, mɛ́ suonnɛ. ");
INSERT INTO bus_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ben Yakubu bè: Ma nɛ́ é gáaoro, zaakɛ à vĩ̀i dadↄ̃nkↄ̃dee gà, àmbe à gↄ̃̀ ado. Ma zi kũ̀. Tó yãke à lè tá kɛ̀ ée oo guu, eé tó mà tá miran kↄ̃n pↄsiaaomɛ. ");
INSERT INTO bus_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Dekaa pãsĩ kũ̀ Kanaa bùsun. ");
INSERT INTO bus_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Kɛ̀ aↄ̃ blɛwɛɛ kɛ̀ aↄ̃ bↄ̀o Igipiti blè wà yã̀a, aↄ̃ de bèńnɛ: À ɛara à gá blɛwɛɛ lú féte dↄ. ");
INSERT INTO bus_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ben Yuda bènɛ: Gↄ̃gbɛ̃ pì òwe sãnsãmmɛ à bè, tó wa dãaro kúwaoro, wé wɛ́ɛ sikↄ̃lɛro. ");
INSERT INTO bus_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Tó nɛ́ we wa dãaro gáwao, wé gá wà blɛwɛɛ lúnnɛ. ");
INSERT INTO bus_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Tó nɛ́ɛ we sↄ̃ro, wé gáro, zaakɛ gbɛ̃ pì òwe, tó wa dãaro kúwaoro, wé wɛ́ɛ sikↄ̃lɛro. ");
INSERT INTO bus_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ben Isaraili bè: Bↄ́yãnzin a ĩa dàmazi, kɛ̀ á ò gbɛ̃ pìnɛ á dãaro vĩi? ");
INSERT INTO bus_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Aↄ̃ wèàla wà bè: Àmbe à yã gbèkawa kↄ̃n wa bɛdeenↄ yão à bè: A de kuu ai tiaↄ́? Á dãaro vĩↄ́? Yã beeenↄ musun wa weàla. Wá dↄ̃ yã eé be wà mↄ́ kↄ̃n wa dãaroon yↄ́? ");
INSERT INTO bus_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ben Yuda bè a denɛ: Ǹ tó nɛ́ pì gámao. Wé fɛɛ wà gá gↄ̃ↄmɛ, lɛ wapinↄ kↄ̃n mpio kↄ̃n wa nɛ́nↄ tón gagaro yãnzi, wégↄ̃ kuu aafia. ");
INSERT INTO bus_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","À gↄ̃̀ ma yã ũmɛ. Ma a zĩnda wɛ̃̀ndi dìɛ à pↄ́ gɛ̃ɛ ũ. Tó mɛ́ɛ suonnɛ aafiaro, ma gↄ̃ n taaridee ũmɛ. ");
INSERT INTO bus_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Tó wée seka kɛ yãro, lɛ wa gaa gɛ̃̀n plaadeeo wa su. ");
INSERT INTO bus_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ben aↄ̃ de bèńnɛ: Tó lɛmɛ, à yã kɛ̀kii kɛ. À wa bùsu pↄ́ maaanↄ sɛ́ɛ à ká a sàkinↄ guu à gá à gↄ̃gbɛ̃ pì gba. À lí'ↄ ɛ̃zɛ̃ sɛ́ féte kↄ̃n zↄ́'io féte kↄ̃n dò pↄ́nↄ kↄ̃n lí'ↄ gũ nnannaao kↄ̃n gↄ̀rↄo kↄ̃n sĩo. ");
INSERT INTO bus_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","À gá kↄ̃n ↄↄo lɛo plaa à ↄↄ kɛ̀ wà dàare a sàkinↄ guu sↄkpańnɛ. Ke wà sã̀sãn yá, á dↄ̃ro. ");
INSERT INTO bus_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","À a dãaro sɛ́ à ɛara à gá gↄ̃gbɛ̃ pì kiia. ");
INSERT INTO bus_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Luda Gbãapingide tó gbɛ̃ pì a wɛ̃nda gwa à a gbɛ̃ndo kↄ̃n Bɛyãmio gbarɛ aↄ̃ suao. Mapi sↄ̃, tó Luda ma nɛ́nↄ sìmamɛ, à sìman gwe. ");
INSERT INTO bus_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Aↄ̃ pↄ́ kɛ̀ aↄ̃é gá wà à gbaa pìnↄ sɛ̀ɛ kↄ̃n ↄↄo lɛo plaa kↄ̃n Bɛyãmio aↄ̃ fɛ̀ɛ wà gàa Igipiti, ben aↄ̃ gàa Yusufu kiia. ");
INSERT INTO bus_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Kɛ̀ Yusufu Bɛyãmi è ń tɛ́, à bè a bɛgwarinɛ: Ǹ gá kↄ̃n gbɛ̃ beeenↄ ma bɛ. Ǹ nↄ̀bↄ dɛ ǹ kɛkɛ, zaakɛ gbɛ̃ pìnↄ é pↄ́ blemao fãantɛ̃amɛ. ");
INSERT INTO bus_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Bɛgwari pì yã kɛ̀ Yusufu dànɛ kɛ̀ à gàańyo à bɛ. ");
INSERT INTO bus_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Kɛ̀ wèe gaańyo Yusufu bɛ lɛ, vĩa ń kũ aↄ̃ bè: Ɔↄ kɛ̀ wà dà wa sàkinↄ guu yã bé à tò wèe mↄↄwao kɛ̀. Aↄ̃ↄ yezi wà lɛ́ɛwa wà gbãaa mↄ́we wà wa kũkũ zↄ̀nↄ ũ, wà wa zaakinↄ sɛ́ɛmɛ. ");
INSERT INTO bus_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Kɛ̀ aↄ̃ kà Yusufu bɛ kpɛɛlɛ, aↄ̃ sↄ̃̀ à bɛgwari pìzi aↄ̃ bè: ");
INSERT INTO bus_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Maree, n yã nna! Wa mↄ wà blɛwɛɛ lú kɛ̀ yã káaku. ");
INSERT INTO bus_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Kɛ̀ wa ka guu kɛ̀ wé iin, wa wa sàkinↄ pòro, ben wa baade a ↄↄ è a sàki lɛ́n papana. Ben wa su ↄↄ pìo wa ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Wa mↄ ↄↄ pãndeo lɛ wà blɛ pãnde lúo. Wá dↄ̃ gbɛ̃ kɛ̀ ↄↄ pì dà wa sàkinↄ guuro. ");
INSERT INTO bus_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Bɛgwari pì bè: Àton bídi kɛro, àton vĩa kɛro. A Luda, a de Luda bé à ↄↄ pì dàare a sàkinↄ guu. A ↄↄ ma kii lè. Ben à Simɛↄ bↄ̀ńnɛ. ");
INSERT INTO bus_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Bɛgwari pì gɛ̃̀ńyo Yusufu ua guu, à í kpàḿma aↄ̃ zú oo, ben à sɛ̃̀ kpà ń zaakinↄa. ");
INSERT INTO bus_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ben aↄ̃ pↄ́ kɛ̀ aↄ̃é Yusufu gbaa pì yã kɛ̀kɛ ai àgↄ̃ gá su fãantɛ̃, zaakɛ aↄ̃ↄ mà weé pↄ́ ble à bɛmɛ. ");
INSERT INTO bus_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Kɛ̀ Yusufu sù bɛ, aↄ̃ à gbà pↄ́ kɛ̀ aↄ̃ mↄ̀o pìnↄ aↄ̃ dàɛ tↄↄtɛ à aɛ. ");
INSERT INTO bus_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","À ń aafia gbèka, ben à bè: A de zikũna kɛ̀ a à yã ò pì gbãaↄ́? À kú wɛ̃̀ndioↄ́? ");
INSERT INTO bus_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Aↄ̃ wèàla wà bè: Wa de n zↄ̀bleri gbãa à kuu ai tia. Ben aↄ̃ kùɛnɛ wà aɛ pɛ̀ɛ tↄↄtɛa. ");
INSERT INTO bus_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yusufu wɛ́ɛ sɛ̀ à a dãaro dadↄ̃nkↄ̃de Bɛyãmi gwà à bè: A dãaro kɛ̀ a à yã òmɛɛ pìn yɛ̀ↄ́? Ben à bè Bɛyãminɛ: Luda aubarika dangu. ");
INSERT INTO bus_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Kɛ̀ à a dãaro gwà, à pↄↄ kɛ̀ nna bíta à yezi à ↄ́ↄ dↄ, ben à gɛ̃̀ kpɛ́tu kpakpaa, à ↄ́ↄ dↄ̀ gwe. ");
INSERT INTO bus_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Kɛ̀ à uu pìpi, ben à bↄ̀ à a zĩnda kũ̀ à bè wà mↄ́ pↄ́bleeo. ");
INSERT INTO bus_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Wà pↄ́blee dìɛnɛ ado, aↄ̃ pↄ́ sↄ̃ adona, Igipiti kɛ̀ aↄ̃ↄ kúonↄ pↄ́ adona dↄ, zaakɛ Igipitinↄ è pↄ́ ble kↄ̃n Eberunↄro aↄ̃è kakↄ̃ańyoro. ");
INSERT INTO bus_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Wà ń vɛ̃ɛvɛ̃ɛ à aɛ ń sáakɛɛa, zaa daudua ai ń gbɛ̃ zãaa, ben aↄ̃ lɛ́ àɛ wà kↄ̃ gwàgwa. ");
INSERT INTO bus_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ben wà pↄ́blee kɛ̀ kú Yusufu aɛ kpàatɛtɛńnɛ. Bɛyãmi pↄ́ bíta dɛ gbɛ̃ kpaaanↄ pↄ́la lɛo sↄↄro. Ben aↄ̃ pↄ́ blè aↄ̃ í mì kↄ̃n Yusufuo ai wà kã̀. ");
INSERT INTO bus_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yusufu bè a bɛgwarinɛ: Ǹ blɛwɛɛ káka gbɛ̃ pìnↄnɛ ń sàkinↄ pa lán aↄ̃é fↄ̃ wà sɛ́ nà. Ǹ baade ↄↄ danɛ a sàki lɛ́n ");
INSERT INTO bus_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ǹ ma kondogi togo sɛ́ ǹ da ń dãaro sàkin kↄ̃n à blɛwɛɛ ↄↄo. Ben à kɛ̀ lán Yusufu ònɛ nà. ");
INSERT INTO bus_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kɛ̀ guu dↄ̀ gↄ̃ↄ, wà ń gbáɛ kↄ̃n ń zaakinↄ. ");
INSERT INTO bus_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ai aↄ̃gↄ̃ gá ká zã̀, ben Yusufu bè a bɛgwarinɛ: Ǹ fɛɛ ǹ pɛ́ɛńzi. Tó n ń lé, ǹ ń la ǹ be bↄ́yãnzin aↄ̃ fĩa bòmɛ à zaaao à maaa gɛ̃ɛ ũzi? ");
INSERT INTO bus_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Bↄ́yãnzin aↄ̃ ma togoo kɛ̀ mɛɛ̀ í mio mà màso kɛo sɛ̀ kpãii? Ǹ ońnɛ kɛ̀ aↄ̃ yã zaaa kɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Kɛ̀ à ń lé, à yã pì òńnɛ, ");
INSERT INTO bus_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ben aↄ̃ wèàla wà bè: Maree, à kɛ̀ dia ń ò lɛɛ? Kúku! Wamↄwa n zↄ̀blerinↄ, weè yã beee taka kɛro. ");
INSERT INTO bus_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ɔↄ kɛ̀ wá è yã wa sàkinↄ lɛ́ guu, wée ɛara wa suonnɛ bↄna zaa Kanaaroo? Wé fↄ̃ wà kondogi ke vura sɛ́ kpãi n dii bɛↄ́? ");
INSERT INTO bus_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Maree, wa gbɛ̃ kɛ̀ ń è à kiia, adee gà, wa píngi wé gↄ̃ n zↄ̀nↄ ũ. ");
INSERT INTO bus_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","À bè: Tↄ̀, à kɛ lán á ò nà. Gbɛ̃ kɛ̀ wà è à kiia é gↄ̃ ma zↄ̀ ũmɛ, a gbɛ̃ kpaaanↄ é gↄ̃ taari sai. ");
INSERT INTO bus_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ben aↄ̃ baade a sàki pìta à pòro gↄ̃ↄ. ");
INSERT INTO bus_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ben bɛgwari pì ń sàkinↄ gwàgwa. À nà ń vĩ̀i pↄ́a ai à gàa à kào ń dãaro pↄ́a, ben à togoo pì è Bɛyãmi pↄ́ guu. ");
INSERT INTO bus_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Aↄ̃ ń utanↄ gà wà kɛ̃̀kɛ̃, ben aↄ̃ baade a asoo yì a zaakinɛ aↄ̃ ɛ̀ara wà gɛ̃̀ wɛ́tɛ guu. ");
INSERT INTO bus_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Kɛ̀ Yuda kↄ̃n a gbɛ̃nↄ kà Yusufu bɛ, aↄ̃ à lè gwe, ben aↄ̃ kùɛ à aɛ tↄↄtɛa. ");
INSERT INTO bus_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","À bèńnɛ: Bↄ́yãnzin á kɛ̀ lɛzi? Á dↄ̃ kɛ̀ ma taka è màso kɛroo? ");
INSERT INTO bus_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda wèàla à bè: Dii, wé bennɛ diamɛ? À yãke ona vĩro. Wé kɛ dia wà wa zĩnda bↄ yãn? Luda bé à bↄ̀ wa taaria. Dii, wa gↄ̃ n zↄ̀nↄ ũ kɛ̀, wapinↄ kↄ̃n gbɛ̃ kɛ̀ wà togoo pì è à kiiao. ");
INSERT INTO bus_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ben Yusufu bè: Kai! Mɛ́ fↄ̃ mà beee kɛro. Gbɛ̃ kɛ̀ wà togoo pì èa bé eé gↄ̃ ma zↄ̀ ũ, a gbɛ̃ kpaaanↄ é ɛara à tá a de kiia aafia. ");
INSERT INTO bus_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ben Yuda sↄ̃̀zi à bè: N yã nna dii! Ǹ tó mamↄma n zↄ̀bleri mà yã onnɛ. Ǹton pↄ fɛ̃maziro dii, zaakɛ ń sáa kↄ̃n Fili'aunaomɛ. ");
INSERT INTO bus_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Dii, n wa la yã tó wá de vĩ ke dãaro. ");
INSERT INTO bus_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ben wa bè wa de zi kũ̀, bensↄ̃ wa dãaro kuu dↄ, wa de à ì a zikũ guumɛ. Nɛ́ pì vĩ̀i dadↄ̃nkↄ̃dee gà, àmbe à gↄ̃̀ ado, ben wa de pì yezi maamaa. ");
INSERT INTO bus_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ń ò wamↄwa n zↄ̀blerinↄnɛ wà à sɛ́ wà mↄ́onnɛ lɛ ǹ wɛ́ɛ siàlɛ. ");
INSERT INTO bus_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Dii, wa bènnɛ nɛ́ pì é fↄ̃ à a de tóro. Tó à à tò, de pì é gamɛ. ");
INSERT INTO bus_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ben n bèwe, tó wée mↄ́ kↄ̃n wa dãaro pìoro, wé wɛ́ɛ sikↄ̃lɛro. ");
INSERT INTO bus_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Kɛ̀ wa ta wa de kiia, wa n yã ònɛ. ");
INSERT INTO bus_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ben wa de pì bè wà ɛara wà gá blɛwɛɛ lú féte dↄ. ");
INSERT INTO bus_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Wa bè, tó èe kɛ wa dãaro kúwao baasiro, wé fↄ̃ wà gáro, zaakɛ tó à kúwaoro, wa wɛ́ɛ é sikↄ̃lɛro. ");
INSERT INTO bus_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ben wa de bèwe, wá dↄ̃ kɛ̀ a naↄ̃ nɛ́ ì mɛ̀n plaa. ");
INSERT INTO bus_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Kɛ̀ à doo bↄ̀ à bɛ, èe à e dↄro ai gbã̀a. À bè nↄ̀bↄ pãsĩ bé à à sò. ");
INSERT INTO bus_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","À bè tó wa nɛ́ beee sìawa, ben yã zaaa à lè, lán a zi kũ̀ nà, wé tó à tá miran kↄ̃n pↄsiaaomɛ. ");
INSERT INTO bus_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Tia sa, tó ma ta ma de kiia, ben à nɛ́ pì kúwaoro, eé gamɛ, zaakɛ à pↄↄ nàamɛ. ");
INSERT INTO bus_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Tó wa dee e nɛ́ pì e wa tɛ́ro, eé tá miran a zikũ guu kↄ̃n pↄsiaaomɛ. ");
INSERT INTO bus_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ma a zĩnda kpà ma dea nɛ́ pì gɛ̃ɛ ũmɛ, ma bè tó mɛ́ɛ suonɛro, mɛ́ gↄ̃ à taaridee ũ ai ma wɛ̃̀ndi lɛ́n. ");
INSERT INTO bus_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Dii, n yã nna! Ǹ tó mà gↄ̃ n zↄ̀ ũ nɛ́ pì gɛ̃ɛ ũ, lɛ à tá kↄ̃n a vĩ̀inↄ. ");
INSERT INTO bus_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Tó èe kɛ kↄ̃n nɛ́ pìoro, mɛ́ fↄ̃ mà tá ma de kiiaro. Ǹton tó mà yã zaaa kɛ̀ eé ma de lee ero. ");
INSERT INTO bus_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yusufu e fↄ̃ à a zĩnda kũ̀ a ìba kɛ̀ aↄ̃ↄ kú gweenↄ aɛzĩ dↄro, ben à pũ̀tã à bè: Amↄa kɛ̀ á kú kɛ̀nↄ, à bↄɛ a píngi! Kɛ̀ gbɛ̃kee kú gwe dↄro, ben à a zĩnda tↄ̃kɛ̃̀ a vĩ̀inↄnɛ sa. ");
INSERT INTO bus_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Èe ↄ́ↄ dↄↄ gbãngbãn ai Igipitinↄↄ mà, ben Fili'auna bɛdeenↄ à baaru mà. ");
INSERT INTO bus_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ben à bè a gbɛ̃ pìnↄnɛ: Yusufun ma ũ. Ma de kuu ai tiaↄ́? Ben swɛ̃̀ kɛ̃̀ńgu, aↄ̃ↄe fↄ̃ wà wèàlaro. ");
INSERT INTO bus_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ben Yusufu bèńnɛ: À sↄ̃mazi. Kɛ̀ aↄ̃ sↄ̃̀zi, ben à bè: Mámbe a dãaro Yusufu kɛ̀ á yà wà sùo Igipiti kɛ̀ ũ. ");
INSERT INTO bus_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Tia sa àton tó a nↄ̀sɛ yakaro. Àton pↄ fɛ̃ ma yana yã musuro, zaakɛ gbɛ̃nↄ mìsina yãnzin Luda ma zĩ a aɛ kɛ̀zi. ");
INSERT INTO bus_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Dekaa kana bùsun kɛ̀ wɛ̃̀ plaadeen yɛ̀. Weé bú baro weé pↄ́ kɛ̃ro ai wɛ̃̀ sↄↄro. ");
INSERT INTO bus_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ludaa tò ma dↄare aɛ lɛ wa borii bↄ aafia anduna guu, mà a mì sí maamaa. ");
INSERT INTO bus_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Èe kɛ ámbe a ma zĩ kɛ̀ro, Ludamɛ. À ma diɛ Fili'auna lɛ́dammari ũ, à bɛgwari ũ, Igipiti gu píngi gbɛ̃nsi ũ. ");
INSERT INTO bus_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","À kɛ kpakpaa, à gá wa de kiia à onɛ à nɛ́ Yusufu bè Luda a diɛ Igipiti bùsu gbãadee ũ. À su ma kiia kɛ̀ gↄ̃ↄ. ");
INSERT INTO bus_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Àgↄ̃ kúmao kĩi à vɛ̃ɛ Gosɛ̃ bùsun kↄ̃n a nɛ́nↄ kↄ̃n a dionↄ kↄ̃n a sãanↄ kↄ̃n a blènↄ kↄ̃n a zùnↄ kↄ̃n pↄ́ kɛ̀ à vĩinↄ píngi. ");
INSERT INTO bus_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Mɛ́ à gwa kɛ̀, zaakɛ dekaa égↄ̃ kuu ai wɛ̃̀ sↄↄro dↄmɛ. Tó lɛnlo, àpi kↄ̃n a bɛdeenↄ kↄ̃n pↄ́ kɛ̀ à vĩinↄ é kaatɛ píngi. ");
INSERT INTO bus_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Apinↄ kↄ̃n Bɛyãmio, á è wɛ́ɛo kɛ̀ mamↄma Yusufu mámbe mɛ́ɛ yã ooare. ");
INSERT INTO bus_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","À bɛ̀ɛ kɛ̀ má vĩ Igipiti kɛ̀ yã o ma denɛ kↄ̃n pↄ́ kɛ̀ á èo píngi. À gá à suo kɛ̀ kpakpaa. ");
INSERT INTO bus_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","À vĩ̀ à lògo a dãaro Bɛyãmi waaa à ↄ́ↄ dↄ̀, ben Bɛyãmi mlɛ̃̀a à ↄ́ↄ dↄ̀ se. ");
INSERT INTO bus_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ben à lɛ́ pɛ̀pɛ a vĩ̀inↄa ń píngi kↄ̃n ↄ́ↄ dↄↄo. Beee gbɛra a vĩ̀inↄ yã òo. ");
INSERT INTO bus_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Kɛ̀ Yusufu vĩ̀inↄ mↄna baaru kà Fili'auna bɛ, à kɛ̀nɛ nna kↄ̃n a ìbanↄ. ");
INSERT INTO bus_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ben à bè Yusufunɛ: Ǹ o n vĩ̀inↄnɛ aↄ̃ ń asoo yi ń zaakinↄnɛ aↄ̃ fɛɛ wà gá Kanaa, ");
INSERT INTO bus_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","aↄ̃ ń de sɛ́ kↄ̃n n bɛdeenↄ aↄ̃ suńyo ma kiia kɛ̀. Mɛ́ Igipiti bùsu gu maaa kpáḿma aↄ̃gↄ̃ nnaa maa. ");
INSERT INTO bus_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ǹ ońnɛ dↄ aↄ̃ Igipiti zùgoronↄ sɛ́ ń nɛ́ fétenↄ kↄ̃n ń nↄgbɛ̃nↄ yãnzi, aↄ̃ ń de sɛ́ wà suo. ");
INSERT INTO bus_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Aↄ̃ton laasuu lɛ́ pↄ́ kɛ̀ aↄ̃é tó gweenↄaro, zaakɛ Igipiti gu maaa é gↄ̃ ń pↄ́ ũmɛ. ");
INSERT INTO bus_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ben Isaraili nɛ́ pìnↄↄ kɛ̀ lɛ. Yusufu zùgoronↄ kpàḿma lán Fili'auna ò nà. À zɛ́ kũsãɛ kɛ̀ńnɛ dↄ. ");
INSERT INTO bus_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","À ń gbá uta ìsinↄ ń píngi, ben à Bɛyãmi gbà kondogi ↄↄ mɛ̀n wàa do kpɛ́ basↄↄro kↄ̃n uta ìsinↄ mɛ̀n sↄↄro. ");
INSERT INTO bus_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","À Igipiti pↄ́ maaanↄ kpã̀sã a denɛ zaaki aso kuri kↄ̃n blɛwɛɛo kↄ̃n pↄ́bleeo zaaki aso kuri a de zɛ́ kũsãɛ ũ. ");
INSERT INTO bus_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Kɛ̀ à ń gbáɛ à bè: Àton swèe kɛ zɛ́nlo! Ben aↄ̃ tà. ");
INSERT INTO bus_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Aↄ̃ bↄ̀ Igipiti, ben aↄ̃ kà Kanaa bùsun ń de Yakubu kiia. ");
INSERT INTO bus_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Aↄ̃ bènɛ: Yusufu kú wɛ̃̀ndio ai tia, àmbe Igipiti bùsu gbɛ̃nsi ũ. Ben Yakubu kɛ̀ sã̀ii, èe síro. ");
INSERT INTO bus_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ben aↄ̃ yã kɛ̀ Yusufu òńnɛ ònɛ píngi. Kɛ̀ Isaraili zùgoro kɛ̀ Yusufu gbàrɛ à a sɛ́nↄ è, ben à laasuu kɛ̀ do sa, ");
INSERT INTO bus_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ben à bè: Kɛ̀kii mↄ̀! Ma nɛ́ Yusufu kú wɛ̃̀ndio ai tia. Mɛ́ gá mà wɛ́ɛ siàlɛ lɛ má kpɛ́ mà ga. ");
INSERT INTO bus_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Isaraili dà zɛ́n kↄ̃n pↄ́ kɛ̀ a vĩinↄ píngi. Kɛ̀ à kà Bɛsɛba, à saa ò a de Isaaku Ludaa. ");
INSERT INTO bus_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ben Luda bↄ̀ à mↄ̀zi wɛ́ɛgupu'ena guu gwãavĩ à bè: Yakubu! Yakubu! À wèàla à bè: Maɛ kɛ̀! ");
INSERT INTO bus_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ben à bè: Mámbe Luda ũ, n de Luda. Ǹton bídi kɛ Igipiti gana yã musuro, zaakɛ gwen mɛ́ n borii kaaran maamaa. ");
INSERT INTO bus_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mɛ́ gányo Igipiti mà ɛara mà su kↄ̃n n boriinↄ. Yusufu gbádaan nɛ́ gan. ");
INSERT INTO bus_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ben Yakubu fɛ̀ɛ Bɛsɛba. À nɛ́nↄ à dà zùgoro kɛ̀ Fili'auna gbàrɛ wà à sɛ́onↄ guu kↄ̃n ń nɛ́nↄ kↄ̃n ń naↄ̃ↄnↄo. ");
INSERT INTO bus_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Aↄ̃ ń pↄ́kãdeenↄ kↄ̃n auziki kɛ̀ aↄ̃ↄ è Kanaa bùsu guunↄ sɛ̀ɛ wà tào Igipiti. ");
INSERT INTO bus_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Yakubu tà gwe kↄ̃n a nɛ́gↄ̃gbɛ̃nↄ kↄ̃n a nɛ́nↄgbɛ̃nↄ kↄ̃n a dionↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Isaraili kɛ̀ aↄ̃ tà Igipitinↄ tↄ́nↄn yɛ̀, Yakubu kↄ̃n a boriinↄ. Yakubu daudu Rubɛni. ");
INSERT INTO bus_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubɛni nɛ́gↄ̃gbɛ̃nↄn Anↄku, Palu, Ɛzɛrↄnu kↄ̃n Kaamio ũ. ");
INSERT INTO bus_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simɛↄ nɛ́gↄ̃gbɛ̃nↄn Yemuɛli, Yami, Oada, Yakĩ, Zoa kↄ̃n Saulu kɛ̀ à à ì kↄ̃n Kanaa nↄgbɛ̃oo ũ. ");
INSERT INTO bus_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi nɛ́gↄ̃gbɛ̃nↄn Gɛsↄnu, Koa kↄ̃n Mɛrario ũ. ");
INSERT INTO bus_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yuda nɛ́gↄ̃gbɛ̃nↄn Ɛɛ, Ona, Sela, Pɛrɛzi kↄ̃n Zɛrao ũ, mↄde Ɛɛ kↄ̃n Onao gà Kanaamɛ. Pɛrɛzi nɛ́gↄ̃gbɛ̃nↄn Ɛzɛrↄnu kↄ̃n Amuluo ũ. ");
INSERT INTO bus_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaka nɛ́gↄ̃gbɛ̃nↄn Tola, Pua, Yasubu kↄ̃n Simirↄnuo ũ. ");
INSERT INTO bus_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zɛbuluni nɛ́gↄ̃gbɛ̃nↄn Sɛrɛdi, Ɛlↄni kↄ̃n Yalɛlio ũ. ");
INSERT INTO bus_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Nɛ́gↄ̃gbɛ̃ kɛ̀ Lea ń í kↄ̃n Yakubuo Mɛsↄpↄtamianↄn gwe. Àmbe à a nɛ́nↄgbɛ̃ Dina ì dↄ. Aↄ̃ borii pìnↄ ń píngi gↄ̃ↄn baaakuri awɛɛ'aagↄ̃mɛ. ");
INSERT INTO bus_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gada nɛ́gↄ̃gbɛ̃nↄn Zɛfↄ̃, Agi, Suni, Ɛzɛbↄ̃, Eri, Arodi kↄ̃n Arɛlio ũ. ");
INSERT INTO bus_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asa nɛ́gↄ̃gbɛ̃nↄn Imina, Isiva, Isivi kↄ̃n Bɛriao ũ kↄ̃n ń dãre Sɛrao. Bɛria nɛ́gↄ̃gbɛ̃nↄn Eberu kↄ̃n Malakiɛlio ũ. ");
INSERT INTO bus_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Labã bé à Zilipa kpà Leaa. Borii kɛ̀ Zilipa kɛ̀ kↄ̃n Yakubuon gwe. Aↄ̃ gↄ̃ↄn gɛ̃ro awɛɛdomɛ. ");
INSERT INTO bus_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakubu naↄ̃ Rasɛli nɛ́gↄ̃gbɛ̃nↄn Yusufu kↄ̃n Bɛyãmio ũ. ");
INSERT INTO bus_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yusufu Manase kↄ̃n Ɛflaimuo ì Igipiti kↄ̃n a naↄ̃ Asɛna, Ɛliↄpↄli sa'ori Potifɛra nɛ́o. ");
INSERT INTO bus_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Bɛyãmi nɛ́gↄ̃gbɛ̃nↄn Bɛla, Bɛkɛ, Asabɛli, Gera, Naama, Ɛhi, Rosu, Mupimu, Upimu kↄ̃n Adao ũ. ");
INSERT INTO bus_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Borii kɛ̀ Rasɛli kɛ̀ kↄ̃n Yakubuonↄn gwe. Aↄ̃ gↄ̃ↄn gɛ̃ro dosaimɛ. ");
INSERT INTO bus_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dani nɛ́gↄ̃gbɛ̃ Usimu. ");
INSERT INTO bus_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nafatali nɛ́gↄ̃gbɛ̃nↄn Yaziɛli, Guni, Yɛzɛ kↄ̃n Silɛmuo ũ. ");
INSERT INTO bus_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Labã bé à Bila kpà Rasɛlia. Borii kɛ̀ Bila kɛ̀ kↄ̃n Yakubuonↄn gwe. Aↄ̃ gↄ̃ↄn swɛɛplaamɛ. ");
INSERT INTO bus_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yakubu borii kɛ̀ aↄ̃ tàńyo Igipitinↄn gwe. Aↄ̃ gↄ̃ↄn baaagↄ̃ awɛɛswɛɛdomɛ à nɛ́ naↄ̃ↄnↄ baasi. ");
INSERT INTO bus_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Kɛ̀ Yusufu nɛ́ ì Igipiti gↄ̃ↄn plaa, ben Yakubu borii kɛ̀ aↄ̃ tà gweenↄ kɛ̀ gↄ̃ↄn baaagↄ̃ akuri. ");
INSERT INTO bus_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakubu Yuda zĩ̀ à dↄnɛ aɛ Yusufu kiia, lɛ à Gosɛ̃ bùsu zɛ́ ↄdↄanɛ. Kɛ̀ aↄ̃ kà gwe, ");
INSERT INTO bus_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ben Yusufu gɛ̃̀ a sↄ̃goron à gàa da a delɛ gwe. Kɛ̀ à à lè, à mlɛ̃̀a à ↄ́ↄ dↄ̀ gìkɛna. ");
INSERT INTO bus_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ben Isaraili bè Yusufunɛ: Lán ma wɛ́ɛ sìnlɛ nà má è ń kú wɛ̃̀ndio, gaa é fↄ̃ à ma sɛ́ sa. ");
INSERT INTO bus_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yusufu bè a vĩ̀inↄnɛ kↄ̃n a de bɛdeenↄ: Mɛ́ gá mà o Fili'aunanɛ ma vĩ̀inↄ kↄ̃n ma de bɛdee kɛ̀ aↄ̃ↄ kú Kanaa bùsunnↄ sù ma kiia. ");
INSERT INTO bus_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Mɛ́ onɛ kɛ̀ sãdãrinↄn a ũ, á pↄ́kãdeenↄ vĩ, ben a mↄ kↄ̃n a sãanↄ kↄ̃n a blènↄ kↄ̃n a zùnↄ kↄ̃n pↄ́ kɛ̀ á vĩinↄ píngi. ");
INSERT INTO bus_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Tó Fili'auna a sisi, ben à a la bↄ́ zĩin eè kɛ, ");
INSERT INTO bus_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","à onɛ à be á pↄ́kãdedeenↄ ũ zaa a gↄ̃kparɛkɛgurↄ ai kↄ̃n a gbã̀ao lán a dezinↄ bà. Tó á ònɛ lɛ, é e à vɛ̃ɛ Gosɛ̃ bùsun, zaakɛ Igipitinↄ è kakↄ̃a kↄ̃n sãdãrinↄro. ");
INSERT INTO bus_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yusufu gàa à yã ò Fili'aunanɛ à bè: Ma vĩ̀inↄ bↄ̀ Kanaa bùsun kↄ̃n ń sãanↄ kↄ̃n ń blènↄ kↄ̃n ń zùnↄ kↄ̃n pↄ́ kɛ̀ aↄ̃ↄ vĩinↄ píngi, aↄ̃ mↄ̀ Gosɛ̃ bùsun. ");
INSERT INTO bus_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ben à a vĩ̀inↄ sɛ̀ gↄ̃ↄn sↄↄro à ń ↄdↄa Fili'aunanɛ. ");
INSERT INTO bus_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Fili'auna ń lá à bè: Bↄ́ zĩin eè kɛɛ? Aↄ̃ wèàla wà bè: Wamↄwa n zↄ̀blerinↄ, sãdãrinↄn wa ũ lán wa dezinↄ bà. ");
INSERT INTO bus_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ben aↄ̃ bènɛ: Wa mↄ vɛ̃ɛ bùsun kɛ̀ gurↄ plaamɛ, zaakɛ dekaa kú Kanaa bùsun maamaa, sɛ̃̀ kuu kɛ̀ wa sãanↄ blero. Wamↄwa n zↄ̀blerinↄ, ǹ wa gba zɛ́ wà vɛ̃ɛ Gosɛ̃ bùsun. ");
INSERT INTO bus_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ben Fili'auna bè Yusufunɛ: Lán n de kↄ̃n n vĩ̀inↄ sù n kiia nà, ");
INSERT INTO bus_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ǹ ń káɛ Igipiti gu maaan. Aↄ̃ vɛ̃ɛ Gosɛ̃ bùsun. Tó làakarideenↄↄ kú ń tɛ́, ǹ ma pↄ́nↄ nańnɛ ń ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ben Yusufu a de Yakubu sɛ̀ à gàa à ↄ̀dↄa Fili'aunanɛ. Ben Yakubu sa maaa ònɛ. ");
INSERT INTO bus_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Fili'auna à là à bè: N ka wɛ̃̀n gbaa? ");
INSERT INTO bus_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","À wèàla à bè: Ma kuuna anduna guu wɛ̃̀ baswɛɛdo akurideen yɛ̀. Ma wɛ̃̀ e ká ma dezinↄ pↄ́ ũro, ben à yã'ↄ̃amma vĩ. ");
INSERT INTO bus_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","À sa maaa ò Fili'aunanɛ dↄ, ben à bↄ̀ à kiia. ");
INSERT INTO bus_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yusufu a de kↄ̃n a vĩ̀inↄ kàɛ Igipiti bùsu gu maaan, à ń gbá bùsu kɛ̀ Ramɛsɛ dɛ à wɛ́tɛdaa ũ lán Fili'auna ò nà. ");
INSERT INTO bus_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yusufu blɛwɛɛ kpà a dea kↄ̃n a vĩ̀inↄ kↄ̃n a de bɛdeenↄ ń píngi ua kↄ̃n uao ń pari lɛ́n. ");
INSERT INTO bus_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Dekaa kɛ̀ gbãa, blɛwɛɛ kú gukearo. Igipitinↄ kↄ̃n Kanaanↄ gbãaa yã̀a. ");
INSERT INTO bus_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Wèe blɛwɛɛ luu, ben Yusufu ↄↄ kɛ̀ kú Igipiti kↄ̃n Kanaao sì píngi à tào Fili'auna bɛ. ");
INSERT INTO bus_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Kɛ̀ Igipitinↄ kↄ̃n Kanaanↄ ↄↄ yã̀a, Igipitinↄ mↄ̀ Yusufu kiia ń píngi aↄ̃ bè: Ɔↄ kuu dↄro. Ǹ wa gba blɛwɛɛ. Ǹton tó wà ga n wáaro. ");
INSERT INTO bus_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusufu bè: Lán ↄↄ kuuro nà, à mↄ́ kↄ̃n a pↄ́kãdeenↄ, mɛ́ blɛwɛɛ kpáawa à musu. ");
INSERT INTO bus_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ben aↄ̃ mↄ̀ Yusufunɛ kↄ̃n pↄ́kãdeenↄ, ben à blɛwɛɛ kpàḿma sↄ̃nↄ kↄ̃n sãanↄ kↄ̃n blènↄ kↄ̃n zùnↄ kↄ̃n zaakinↄ musu. Wɛ̃̀ beeea à blɛwɛɛ kpàḿma ń pↄ́kãdeenↄ musumɛ. ");
INSERT INTO bus_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Kɛ̀ wɛ̃̀ beee gɛ̃̀tɛ, ben aↄ̃ mↄ̀ à kiia à wɛ̃̀ làa wà bènɛ: Dii, wé fↄ̃ wà yãke utɛnnɛro. Ɔↄ yã̀a, ben wa pↄ́kãdeenↄ gↄ̃̀ n pↄ́ ũ. Pↄ́kee e gↄ̃ wà kpámmaro, wapinↄ kↄ̃n wa buraanↄ baasiro. ");
INSERT INTO bus_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ǹton tó wà ga n wáa kↄ̃n wa buraanↄro. Ǹ wa lú kↄ̃n wa buraanↄ ǹ fĩa bo kↄ̃n blɛwɛɛo wà gↄ̃ Fili'auna zↄ̀nↄ ũ, wapinↄ kↄ̃n wa buraanↄ. Ǹ wa gba blɛwɛɛ lɛ wàton garo wàgↄ̃ kuu, lɛ dↄ wa buraanↄ tón gↄ̃ taagaa ũro. ");
INSERT INTO bus_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ben Yusufu Igipiti buraanↄ lù Fili'aunanɛ píngi, zaakɛ Igipitinↄ baade a buraa yà, kɛ̀ nↄaa ń kũ gbãa yãnzi, ben bùsu gↄ̃̀ Fili'auna pↄ́ ũ. ");
INSERT INTO bus_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yusufu Igipitinↄ sì zↄ̀nↄ ũ ń píngi zaa ń bùsu lɛ́n kɛ̀ gana à lɛ́ kãa. ");
INSERT INTO bus_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Mↄde èe sa'orinↄ buraanↄ lúro, zaakɛ Fili'auna dìɛ àgↄ̃ blɛwɛɛ kpáḿma gurↄ sãnda píngi. Lán aↄ̃ↄ kú kↄ̃n blɛwɛɛ kɛ̀ Fili'auna è kpáḿmao nà, aↄ̃ↄe ń buraanↄ yáro. ");
INSERT INTO bus_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ben Yusufu bè gbɛ̃nↄnɛ: Ma a lu kↄ̃n a buraanↄ sa, a gↄ̃ Fili'auna pↄ́ ũ. Blɛwɛɛn yɛ̀. À gá à tↄ̃. ");
INSERT INTO bus_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Pↄ́kɛ̃gurↄ àgae à lɛo sↄↄrode kpá Fili'aunaa, à kpaa é gↄ̃are blɛwɛɛ ũ kↄ̃n pↄ́bleeo. Àgae beee ble kↄ̃n a nɛ́nↄ kↄ̃n a bɛdeenↄ a píngi. ");
INSERT INTO bus_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ben aↄ̃ bè: N wa mì sì. Ǹ tó wà n pↄnnaa e dii, wà gↄ̃ Fili'auna zↄ̀nↄ ũ. ");
INSERT INTO bus_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ben Yusufu yã dìɛ Igipiti à bè, burapↄ lɛo sↄↄrodee égↄ̃ dɛ Fili'auna pↄ́ ũ. Yã pì kuu ai kↄ̃n a gbã̀ao. Sa'orinↄ bùsu bé èe gↄ̃ Fili'auna pↄ́ ũro ado. ");
INSERT INTO bus_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Isarailinↄↄ kú Gosɛ̃ bùsun zaa Igipiti. Aↄ̃ ń zĩnda tↄↄtɛ vĩ gwe, ben aↄ̃ nɛ́ ì wà kàara maamaa. ");
INSERT INTO bus_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakubu kɛ̀ wɛ̃̀ gɛ̃ro awɛɛplaa Igipiti, à wɛ̃̀ píngipingi baswɛɛplaa awɛɛswɛɛplaamɛ. ");
INSERT INTO bus_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Kɛ̀ à kà gana, à a nɛ́ Yusufu sìsi, ben à bènɛ: N yã nna! Tó ma n pↄnnaa è, ǹ n ↄↄ da ma gbáda gbáru ǹ gbɛ̃kɛ kↄ̃n náanɛo yã kɛmɛ. Ǹton ǹ ma vĩi Igipitiro. ");
INSERT INTO bus_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Tó ma ka ma dezinↄla, ǹ ma sɛ́ ǹ bↄmao Igipiti kɛ̀ ǹ ma vĩi ma dezi pìnↄ mirawɛɛn. Ben Yusufu bènɛ: Mɛ́ yã kɛ̀ ń ò kɛnnɛ. ");
INSERT INTO bus_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ben Yakubu bè: Ǹ la damɛ. Kɛ̀ à la dànɛ, ben Yakubu gbãa è a gòa à dↄnzi kɛ̀. ");
INSERT INTO bus_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Gurↄ plaaa gbɛra wà ò Yusufunɛ à dee e gyãa kɛɛ, ben à a nɛ́ gↄ̃ↄn plaaanↄ Manase kↄ̃n Ɛflaimuo sɛ̀ɛ à gàańyo. ");
INSERT INTO bus_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Kɛ̀ wà ò Yakubunɛ à nɛ́ Yusufu mↄ̀ à gwa, à aĩa kɛ̀ à fɛ̀ɛ à vɛ̃̀ɛ a gádo musu. ");
INSERT INTO bus_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","À bè Yusufunɛ: Luda Gbãapingide bↄ̀ à mↄ̀mazi zaa Luzu, Kanaa bùsun à aubarika dàmagu ");
INSERT INTO bus_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","à bèmɛ é tó mà nɛ́ i maamaa, é ma kaara mà gↄ̃ boriinↄ dezi ũ, é bùsu pì kpá ma boriinↄa ma gbɛra ń pↄ́ ũ ai gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Tia sa nɛ́ gↄ̃ↄn plaaa kɛ̀ n ń í Igipiti ai màgↄ̃ mↄ́ n kiianↄ ma pↄ́nↄmɛ. Ɛflaimu kↄ̃n Manaseo gↄ̃̀ ma nɛ́nↄ ũ lán Rubɛni kↄ̃n Simɛↄo dɛ nà. ");
INSERT INTO bus_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Nɛ́ kɛ̀ nɛ́ ń i ń gbɛraanↄ bé weégↄ̃ dɛ n pↄ́ ũ, aↄ̃é ń túbi e ń vĩ̀inↄ kiia. ");
INSERT INTO bus_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Zaakɛ kɛ̀ mɛ́ɛ suu kↄ̃n Mɛsↄpↄtamiao, n da Rasɛli gà zɛ́n Ɛflata kɛ̀ wè be tia Bɛtɛlɛmu lɛ́zi zaa Kanaa bùsun, ben ma à vĩ̀i zɛ́n gwe. ");
INSERT INTO bus_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ben Isaraili Yusufu nɛ́nↄ gwà à bè: Dénↄn gwee? ");
INSERT INTO bus_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","À bè a denɛ: Nɛ́ kɛ̀ Luda ma gba kɛ̀nↄn gwe. Ben Isaraili bè: Ǹ mↄ́ńyo ma kiia mà sa'olɛ kɛńnɛ. ");
INSERT INTO bus_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Zikũ Isaraili wɛ́ɛ bùsa èe guu ee maaro, ben Yusufu sↄ̃̀zi kↄ̃n nɛ́ pìnↄ. Isaraili lɛ́ pɛ̀pɛḿma à ń kpá a kùla, ");
INSERT INTO bus_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ben à bè Yusufunɛ: Mɛ́ɛ kpákpaa yã mà wɛ́ɛ sinlɛ dↄro, ben Ludaa tò ma n e kↄ̃n n nɛ́nↄ dↄ. ");
INSERT INTO bus_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yusufu ń gú a de gbála, ben à kùɛnɛ à a aɛ pɛ̀ɛ. ");
INSERT INTO bus_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ben Yusufu a nɛ́nↄ kũ̀ ń plaa ń píngi. À Ɛflaimu kũ̀ kↄ̃n ↄplaao Yakubu ↄzɛɛzi, ben à Manase kũ̀ a ↄzɛɛzi Yakubu ↄplaazi, ben à sↄ̃̀zi kↄ̃n nɛ́ pìnↄ. ");
INSERT INTO bus_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ben Yakubu a ↄↄ pã̀kↄ̃la à a ↄplaa nà Ɛflaimu kɛ̀ dɛ dãaro ũu mìa à a ↄzɛɛ nà Manase kɛ̀ dɛ daudu ũu mìa. ");
INSERT INTO bus_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ben à sa'olɛ kɛ̀ Yusufunɛ à bè: Luda kɛ̀ ma dezinↄ Ibraĩ kↄ̃n Isaakuo táa òo, Luda kɛ̀ dↄ̀mɛ aɛ ma kuuna guu ai kↄ̃n a gbã̀ao, ");
INSERT INTO bus_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","à Malaika kɛ̀ ma bↄ à zaaan píngi, à aubarika da nɛ́ kɛ̀kiinↄn, à tó wàgↄ̃ ń sísii ma tↄ́a, kↄ̃n ma dezinↄ Ibraĩ kↄ̃n Isaakuo tↄ́o, à tó aↄ̃gↄ̃ kↄ̃ↄ maamaa anduna guu. ");
INSERT INTO bus_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Kɛ̀ Yusufu è a de a ↄplaa nà Ɛflaimu mìa, èe kɛnɛ nnaro. À a de ↄↄ kũ̀ lɛ à gu Ɛflaimu mìa à na Manase pↄ́a ");
INSERT INTO bus_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","à bè: Lɛnlo Baa, gbɛ̃ kɛ̀kii bé à daudu ũ. Ǹ n ↄplaa na à mìa. ");
INSERT INTO bus_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ben à de gì à bè: Má dↄ̃ ma nɛ́, má dↄ̃. Àpi sↄ̃ eé gↄ̃ borii ũ, eégↄ̃ bíta, mↄde à dãaro bíta égↄ̃ dɛàla, à borii égↄ̃ pari. ");
INSERT INTO bus_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Zĩ beeea à sa'olɛ kɛ̀ńnɛ à bè: Isarailinↄ é sa maaa okↄ̃nɛ kↄ̃n a tↄ́o aↄ̃é be Luda tó ǹ gↄ̃ lán Ɛflaimu kↄ̃n Manaseo bà. Lɛmɛ à Ɛflaimu dↄ̀ Manasenɛ aɛ lɛ. ");
INSERT INTO bus_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ben Isaraili bè Yusufunɛ: Ma ka gana, mↄde Luda égↄ̃ kúao, eé ɛara à táao a dezinↄ bùsun. ");
INSERT INTO bus_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Sɛkɛmu bùsu maaa kɛ̀ má sì Amↄrinↄa kↄ̃n ma fɛ̃ɛdaao kↄ̃n ma sáo, ma n gba, mmↄn kɛ̀ ń dɛ n vĩ̀inↄla. ");
INSERT INTO bus_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakubu a nɛ́nↄ sìsi, ben à bè: À kↄ̃ kakↄ̃a mà yã kɛ̀ eé a le ziakpɛɛ zĩ oare. ");
INSERT INTO bus_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","À kↄ̃ kakↄ̃a ma nɛ́nↄ à swã kpá, à a de Isaraili yã ma. ");
INSERT INTO bus_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubɛni ma daudu ma gbãaa, ma kana gↄ̃ lɛ́zĩ nɛ́ káaku, n bɛ̀ɛ dɛńla kↄ̃n n gbãaao. ");
INSERT INTO bus_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ń pãsĩ lán ísↄ̃ bà, mↄde nɛ́gↄ̃ dɛńlaro, zaakɛ n didi n da n de gádoa, n daɛ kↄ̃n ma nↄↄnↄ dokeo. ");
INSERT INTO bus_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simɛↄ kↄ̃n Levio bé wà kↄ̃ gbɛ̃nↄ ũ, aↄ̃ↄ pãsĩ kↄ̃n fɛ̃ɛdaao. ");
INSERT INTO bus_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ma lɛ́ kú aↄ̃ kakↄ̃ana guuro, ma baka kú aↄ̃ yãgↄ̃gↄ̃na guuro, zaakɛ aↄ̃ gbɛ̃nↄ dɛ̀dɛ pↄfɛ̃ guu, aↄ̃ zù gbátĩkyanↄ zↄ̃̀zↄ̃ lán aↄ̃ↄ yezi nà. ");
INSERT INTO bus_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Luda láari zĩḿma ń pↄfɛ̃ bíta yãnzi, à lɛ́ kɛńnɛ ń pãsĩkɛ yãnzi. Mɛ́ ń kɛ̃kↄ̃a Yakubu boriinↄ tɛ́, mɛ́ ń boriinↄ fãakↄ̃a Isarailinↄ guu. ");
INSERT INTO bus_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yuda, n gbɛ̃nↄ é n tↄ́ kpá. Nɛ́ n ibɛɛnↄ kũ ń waaa, n de nɛ́nↄ é kúɛnnɛ. ");
INSERT INTO bus_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda dɛ lán músu bà, ma nɛ́ pì è su kↄ̃n tofekao. È gáɛ è daɛ a tòn. dé bé é fↄ̃ à à fɛɛɛ? ");
INSERT INTO bus_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Kpata é gu Yudalaro, à boriinↄ bé weégↄ̃ gò kũna ai Silo gá mↄ́, bori píngi é mì siɛnɛ. ");
INSERT INTO bus_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Eé a zaaki dↄ geepi lía, eé a zaakinɛ yi geepi lí maaaa. Geepiwɛ̃ɛ égↄ̃ dizimɛ eé a pↄ́kãsãanↄ pípio eé a uta pípi kↄ̃n geepi'io. ");
INSERT INTO bus_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Geepiwɛ̃ɛ é à wɛ́ɛ tɛ̃a kũ, zwii é a swaa pura kũ. ");
INSERT INTO bus_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zɛbuluni égↄ̃ kú ísiaa saɛ, à bùsu égↄ̃ dɛ góro'itɛnↄ bàdↄkii ũ, à bùsu lɛ́ é zɛ Sidↄ̃. ");
INSERT INTO bus_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isaka dɛ lán zaaki gbãaa kɛ̀ daɛna aso mɛ̀n plaaa dagura bà. ");
INSERT INTO bus_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Tó à boriinↄↄ è ń kámmabokii maa, bensↄ̃ aↄ̃ bùsu pì vɛ̃ɛna nna, aↄ̃é naɛ asosɛnanɛ wà zↄ̀zĩi kɛ. ");
INSERT INTO bus_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dani é a gbɛ̃nↄ bↄ yãn Isaraili boriinↄ doke ũ. ");
INSERT INTO bus_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dani égↄ̃ dɛ lán mlɛ̃̀ kɛ̀ kú zɛ́ saɛ bà, lán pitigoo kɛ̀ kú zɛ́wɛwɛ guu bà. È sↄ̃ lɛ́ a gbáa, lɛ gbɛ̃ kɛ̀ di à musu lɛ́ɛ a kpɛɛgãnda. ");
INSERT INTO bus_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Dii, mɛɛ̀ wɛ́ɛ dↄ n mìsinazi. ");
INSERT INTO bus_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gada sↄ̃, zĩ̀kpɛɛnↄ é sińgu, mↄde aↄ̃é lɛ́ɛ ń gbɛ̃ zãadeenↄa. ");
INSERT INTO bus_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asa blɛwɛɛ égↄ̃ nↄ́si vĩ, pↄ́blee kɛ̀ à blena nna kínanↄnɛn eé kpá. ");
INSERT INTO bus_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nafatali dɛ lán gbɛ̃ɛ lí kɛ̀ è gã̀ maaanↄ kɛɛ bà. ");
INSERT INTO bus_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusufu dɛ lán lí nɛ́'iri kɛ̀ kú bia saɛ bà, à gã̀nↄ è poro à da gũ̀la. ");
INSERT INTO bus_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Kàzurinↄ é íbɛtɛ kpáo, aↄ̃é pɛ́a kↄ̃n kào. ");
INSERT INTO bus_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Eégↄ̃ a sá kũna degena sai Yakubu Luda Gbãabitade gãzĩ, à ↄ gbãaa égↄ̃ wãa Isarailinↄ Gbɛ̀si kɛ̀ è dↄnɛ aɛ yãnzi. ");
INSERT INTO bus_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","N de Luda é dↄnlɛ, Gbãapingide é aubarika dangu kↄ̃n lou'i kɛ̀ è bↄ musuo, kↄ̃n aubarika kɛ̀ kaɛna tↄↄtɛ gĩzĩo, lɛ n nↄↄnↄ kↄ̃n n pↄ́nↄ gↄ̃ dɛ nɛ́dandeenↄ ũ. ");
INSERT INTO bus_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Sa'olɛ kɛ̀ n de kɛ̀nnɛɛ dɛ ma dezinↄ pↄ́la, à bíta dɛ kpii ziinↄla. Luda tó aubarika kɛ̀nↄ gↄ̃ Yusufu mìa, gbɛ̃ kɛ̀ wà dìɛ adona a gbɛ̃nↄ tɛ́ musu. ");
INSERT INTO bus_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Bɛyãmi dɛ lán lɛwan pãsĩ bà, eè lɛ́ɛ gbɛ̃nↄa kↄngↄ eè ń pↄ́nↄ kpaatɛ uusiɛ. ");
INSERT INTO bus_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Isaraili bori mɛ̀n kuri awɛɛplaaanↄn gwe ń píngi. Sa'olɛ kɛ̀ aↄ̃ dee kɛ̀ńnɛn gwe baade kↄ̃n a pↄ́o. ");
INSERT INTO bus_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ben à bèńnɛ: Tó ma anduna tò, à ma vĩi ma dezinↄ gbɛ̀wɛɛ kɛ̀ kú Iti bori Ɛflↄnu buraa guu. ");
INSERT INTO bus_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Gbɛ̀wɛɛ pì kú Makpɛlamɛ, Mamare ↄfãntɛ̃bↄɛ kpa Kanaa bùsun, buraa kɛ̀ Ibraĩ lù Iti bori Ɛflↄnua mirawɛɛ ũ. ");
INSERT INTO bus_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Gwen wà Ibraĩ kↄ̃n a naↄ̃ Sarao vĩ̀in. Gwen wà Isaaku kↄ̃n a naↄ̃ Rɛbɛkao vĩ̀in. Gwen ma Lea vĩ̀in. ");
INSERT INTO bus_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Wà buraa pì kↄ̃n a gbɛ̀wɛɛo lù Itinↄamɛ. ");
INSERT INTO bus_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Kɛ̀ Yakubu lɛ́ dìɛ a nɛ́nↄnɛ à yã̀a, à ɛ̀ara à dàɛ, ben à gà. ");
INSERT INTO bus_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yusufu kùsi a dea à ↄ́ↄ dↄ̀ à musu à lɛ́ pɛ̀pɛa. ");
INSERT INTO bus_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ben à ò a zĩkɛri ɛ̃zɛ̃deenↄnɛ aↄ̃ ɛ̃zɛ̃ kɛ̀ è tó gɛ̀ vãroo máma a de gɛ̀a. Ben aↄ̃ↄ màma Isaraili gɛ̀a ");
INSERT INTO bus_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ai gurↄ baplaa lɛ àton yai kũro yãnzi, zaakɛ lɛn Igipitinↄ è kɛ lɛ, ben aↄ̃ à gɛ̀ ↄ́ↄ dↄ̀ gurↄ baaagↄ̃ akuri. ");
INSERT INTO bus_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Kɛ̀ aↄ̃ à gɛ̀ ↄ́ↄ dↄ̀ wà yã̀a, Yusufu bè Fili'auna bɛdeenↄnɛ: A yã nna! Tó ma a pↄnnaa è, à omɛ Fili'aunanɛ à be: ");
INSERT INTO bus_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Kɛ̀ ma dee e gaa, à tò ma la dànɛ à bè mà a vĩi mirawɛɛ kɛ̀ à yↄ̃̀ a zĩnda pↄ́ ũ Kanaa bùsun. Ǹ ma gba zɛ́ mà gá mà a de vĩi sa, mɛ́ liara mà su. ");
INSERT INTO bus_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ben Fili'auna bènɛ: Ǹ gá ǹ n de vĩi, zaakɛ à tò n la dàare. ");
INSERT INTO bus_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Kɛ̀ Yusufu e gaa a de vĩi, Fili'auna ìbanↄ kↄ̃n a bɛ gbɛ̃nsinↄ kↄ̃n Igipiti bùsu gbãadeenↄ gàao ń píngi. ");
INSERT INTO bus_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yusufu bɛdeenↄ kↄ̃n a vĩ̀inↄ kↄ̃n a de bɛdeenↄ gàao ń píngi dↄ. Aↄ̃ nɛ́ fétenↄ kↄ̃n ń sãanↄ kↄ̃n ń blènↄ kↄ̃n ń zùnↄ bé wà gↄ̃̀ Gosɛ̃ bùsun ńtɛ̃ɛ. ");
INSERT INTO bus_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Sↄ̃goronↄ kↄ̃n sↄ̃deenↄ gàao dↄ. Gbɛ̃ kɛ̀ aↄ̃ gàa zɛnɛ pìnↄↄ pari maamaa. ");
INSERT INTO bus_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Kɛ̀ aↄ̃ kà Atada blɛwɛɛgbɛ̃kiia Yoda baa, gwen aↄ̃ wii gbãaa lɛ̀n ai, aↄ̃ gɛ̀ ↄ́ↄ dↄ̀ maamaa, ben Yusufu a de sósobi kɛ̀ ai gurↄ swɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kɛ̀ Kanaa bùsudeenↄↄ è lán wèe gɛ̀ kɛɛ nà Atada blɛwɛɛgbɛ̃kiia, ben aↄ̃ bè: Igipitinↄ gɛ̀kɛna bítan yɛ̀. Beee yãnzi wà tↄ́ kpà Yoda baa guu pìnɛ Abɛli Igipiti. ");
INSERT INTO bus_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Lɛn Yakubu nɛ́nↄↄ kɛ̀ lɛ lán à òńnɛ nà. ");
INSERT INTO bus_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Aↄ̃ à gɛ̀ sɛ̀ wà gàao Kanaa bùsun, ben aↄ̃ à vĩ̀i Makpɛla bura gbɛ̀wɛɛ kɛ̀ Ibraĩ lù Iti bori Ɛflↄnua mirawɛɛ ũu guu Mamare ↄfãntɛ̃bↄɛ kpa. ");
INSERT INTO bus_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Kɛ̀ Yusufu a de vĩ̀i à yã̀a, à lìara à tà Igipiti kↄ̃n a vĩ̀inↄ kↄ̃n gbɛ̃ kɛ̀ aↄ̃ gàa zɛnɛ à de gɛ̀ vĩinↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Kɛ̀ Yusufu vĩ̀inↄ è ń de gà, ben aↄ̃ bè: Tó Yusufu íbɛtɛ kpàwao, ben à yezi à à zaaa kɛ̀ wá kɛ̀nɛ píngi fĩa bowe sↄ̃ nɛ́? ");
INSERT INTO bus_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ben aↄ̃ lɛ́kpãsã kɛ̀nɛ wà bè: Lɛ n dee kpɛ́ à ga à bè ");
INSERT INTO bus_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","wà onnɛ ǹ wa taari kↄ̃n wa durun-o kɛ̃we, zaakɛ à zaaan wá kɛ̀nnɛ. N yã nna! Ǹ wa taarinↄ kɛ̃we. N de Luda zↄ̀blerinↄn wa ũ. Kɛ̀ wà yã pì ò Yusufunɛ, ben à ↄ́ↄ dↄ̀. ");
INSERT INTO bus_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ben à vĩ̀inↄ mↄ̀ a kiia aↄ̃ kùɛ à aɛzĩ aↄ̃ bè: N zↄ̀nↄn wa ũ. ");
INSERT INTO bus_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ben Yusufu bèńnɛ: Àton vĩa kɛro. Ludan ma ũↄ́? ");
INSERT INTO bus_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Á yezi à à zaaa kɛmɛ yã, ben Ludaa lìɛ à maaa ũ, lɛ à e à gbɛ̃nↄ mì sí pari lán èe kɛɛ nà tia. ");
INSERT INTO bus_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Àton vĩa kɛro. Mɛ́ a gwa kↄ̃n a nɛ́nↄ. Ben à náanɛ kpàḿma à ń làakari kpàɛ. ");
INSERT INTO bus_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusufu kú Igipiti kↄ̃n a de bɛdeenↄ ai à kà wɛ̃̀ basↄↄro akuri. ");
INSERT INTO bus_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","À wɛ́ɛ sì Ɛflaimu swãkpɛɛnↄlɛ, ben à wɛ́ɛ sì Manase nɛ́ Maki nɛ́nↄlɛ dↄ. ");
INSERT INTO bus_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ben Yusufu bè a gbɛ̃nↄnɛ: Ma ka gana. Luda bé eé mↄ́ dↄalɛ à bↄao bùsu kɛ̀n à gáao bùsu kɛ̀ à à lɛ́ gbɛ̃̀ Ibraĩnɛ kↄ̃n Isaakuo kↄ̃n Yakubuo guu. ");
INSERT INTO bus_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ben Yusufu tò Isarailinↄ la dàare à bè: Gurↄↄ kɛ̀ Luda é mↄ́ dↄalɛ, à ma wánↄ sɛ́ɛ à bↄo guu kɛ̀n. ");
INSERT INTO bus_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yusufu wɛ̃̀ basↄↄro akurideen à gà. Ben wà ɛ̃zɛ̃ kɛ̀ è tó gɛ̀ vãroo màma à gɛ̀a wà dà àkpati guu Igipiti. ");
INSERT INTO bus_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Isaraili nɛ́ kɛ̀ aↄ̃ tà Igipiti kↄ̃n ń de Yakubuo, baade kↄ̃n a bɛ gbɛ̃nↄ tↄ́n yɛ̀: ");
INSERT INTO bus_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubɛni, Simɛↄ, Levi, Yuda, ");
INSERT INTO bus_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isaka, Zɛbuluni, Bɛyãmi, ");
INSERT INTO bus_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani, Nafatali, Gada kↄ̃n Asao. ");
INSERT INTO bus_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yakubu borii pìnↄ ń píngi gↄ̃ↄn baaagↄ̃ akurimɛ. Yusufu sↄ̃ gĩakɛ à kú Igipiti kↄ̀. ");
INSERT INTO bus_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ben Yusufu gà kↄ̃n a vĩ̀inↄ kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ kuu a gurↄↄanↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Isarailinↄ nɛ́ ì wà kↄ̃̀, aↄ̃ kàara wà pari kũ̀ maamaa, aↄ̃ dà bùsu pìla píngi. ");
INSERT INTO bus_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Kína dufu kɛ̀ Yusufu dↄ̃roo kpata blè Igipiti, ");
INSERT INTO bus_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","ben à bè a gbɛ̃nↄnɛ: À Isarailinↄ gwa, aↄ̃ pari kũ̀ wà dàwala. ");
INSERT INTO bus_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Wà gá wà ↄ̃ndↄ̃ↄ daɛńzi lɛ aↄ̃ton kaararo yãnzi. Tó zĩ̀ fɛ̀ɛ, aↄ̃é na wa ibɛɛnↄa aↄ̃ zĩ̀ káwao aↄ̃é bↄɛ wa bùsun. ");
INSERT INTO bus_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ben wà gbɛ̃nↄ dìɛńnɛ ń diinↄ ũ aↄ̃ wɛ́ɛ tãḿma kↄ̃n zĩ gbãaa kɛnao. Lɛn aↄ̃ Pitomu kↄ̃n Ramɛsɛo kàɛ Fili'aunanɛ a pↄ́blekaɛkiinↄ ũ lɛ. ");
INSERT INTO bus_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Mↄde dian wèe ĩa daaḿma nà, lɛn aↄ̃ègↄ̃ kaara lɛ aↄ̃ↄe daagula, ben swɛ̃̀ kɛ̃̀ Igipitinↄn ń yã musu. ");
INSERT INTO bus_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Ben wà ń dá zↄ̀zĩ pãsĩn ");
INSERT INTO bus_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","wà ń nↄ̀sɛ yàka wà gũ̀ zĩ gbãaa dàńnɛ kↄ̃n kúnkubↄnanↄ kↄ̃n bura zĩ píngio. Wà zĩi pìnↄ dàńnɛ píngi pãsĩpãsĩ. ");
INSERT INTO bus_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ben Igipiti kína Eberu nɛ́sɛɛrinↄ sìsi, à doo tↄ́n Sifira, à doo sↄ̃ tↄ́n Pua. ");
INSERT INTO bus_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","À bèńnɛ: Tó é nɛ́ i Eberu nↄgbɛ̃nↄnɛ sa, tó gↄ̃gbɛ̃mɛ, à à dɛ. Tó nↄgbɛ̃mɛ sↄ̃, à à tó. ");
INSERT INTO bus_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Nↄgbɛ̃ pìnↄↄ Luda vĩa vĩ, aↄ̃ↄe yã kɛ̀ à òńnɛ kɛro, aↄ̃ↄe nɛ́gↄ̃gbɛ̃nↄ too. ");
INSERT INTO bus_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ben kína pì ń sísi à ń lá à bè: À kɛ̀ dia á kɛ̀ lɛ a nɛ́gↄ̃gbɛ̃nↄ tò? ");
INSERT INTO bus_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Aↄ̃ wèàla wà bè: Eberu nↄgbɛ̃nↄↄ dɛ lán Igipiti nↄgbɛ̃nↄ bàro, aↄ̃ↄ wãa, ai wàgↄ̃ gá ká, aↄ̃è nɛ́ i. ");
INSERT INTO bus_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Lɛn Isarailinↄↄ e kaara lɛ aↄ̃ↄe pari kũu. Ben Luda yã maaa kɛ̀ nɛ́sɛɛri pìnↄnɛ ");
INSERT INTO bus_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","à ń gbá nɛ́nↄ, kɛ̀ aↄ̃ↄ à vĩa vĩ yãnzi. ");
INSERT INTO bus_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ben Fili'auna yã dìɛ a gbɛ̃nↄnɛ ń píngi à bè: À Eberu nɛ́gↄ̃gbɛ̃ kɛ̀ wà ń ínↄ ká Nili ín ń píngi, mↄde à nɛ́nↄgbɛ̃nↄ tó. ");
INSERT INTO bus_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Levi bori gↄ̃gbɛ̃ Levi bori nↄgbɛ̃ sɛ̀. ");
INSERT INTO bus_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Nↄↄ pì nↄ̀ sì à nɛ́ ì gↄ̃gbɛ̃ ũ. Kɛ̀ à è nɛ́ pì maa, ben à à ùtɛ mↄ aagↄ̃. ");
INSERT INTO bus_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Kɛ̀ èe fↄ̃ à à ùtɛ dↄro, à kɛbu gbíi sɛ̀ à kↄntaa lɛ̀a lɛ í tón gɛ̃ à guuro. Ben à nɛ́ pì dàn à gàa à dìɛ Nili í lɛ́a waa guu. ");
INSERT INTO bus_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Nɛ́ pì dãree zɛ kãaa èe gwaa yã kɛ̀ eé à le. ");
INSERT INTO bus_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ben Fili'auna nɛ́nↄgbɛ̃ gàa zú o swaa pìzi, à gbɛ̃nↄↄ e lili oo swaa pì lɛ́a. À gbíi è diɛna waan, ben à a zↄ̀nↄkpare zĩ̀ à gàa à à sɛ̀. ");
INSERT INTO bus_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Kɛ̀ à wɛ̃̀, à nɛ́ è dan, èe ↄ́ↄ dↄↄ. À kɛ̀nɛ wɛ̃nda à bè: Eberu nɛ́gↄ̃gbɛ̃mɛ. ");
INSERT INTO bus_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ben nɛ́ pì dãre mↄ̀ à bè Fili'auna nɛ́ pìnɛ: Ń yezi mà gá mà Eberu nↄgbɛ̃ sísinnɛ àgↄ̃ yↄ̃ kpaannɛ nɛ́ pìan yↄ́? ");
INSERT INTO bus_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","À wèàla à bè: Ee, ǹ gá! Ben nɛ́nↄgbɛ̃ pì gàa à nɛ́ pì da sìsi. ");
INSERT INTO bus_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Fili'auna nɛ́nↄgbɛ̃ pì bènɛ: Ǹ nɛ́ pì sɛ́ ǹ táo ǹgↄ̃ à gwaamɛ, mɛ́gↄ̃ fĩa boonnɛ. Ben à nɛ́ pì sɛ̀ à tào, èe à gwaa. ");
INSERT INTO bus_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Kɛ̀ nɛ́ pì bíta kũ̀, à à sɛ̀ à gàao Fili'auna nɛ́nↄgbɛ̃ pìnɛ, ben à à sì a nɛ́ ũ. À tↄ́ kpànɛ Musa, zaakɛ à bè, a à bↄ̀ í guumɛ. ");
INSERT INTO bus_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Zĩkea kɛ̀ Musa kɛ̀ bíta, à gàa a bori Eberunↄ gwa, ben à zĩ gbãaa kɛ̀ aↄ̃ↄe kɛɛ è. À è Igipiti gbɛ̃ e a bori daa gbɛ̃ɛ. ");
INSERT INTO bus_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Kɛ̀ à guu gwàgwa, èe gbɛ̃ke ero, ben à Igipiti gbɛ̃ pì dɛ̀ à à ùtɛ bùsu'ãatɛ̃n. ");
INSERT INTO bus_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Kɛ̀ guu dↄ̀, à bↄ̀ à Eberunↄ è gↄ̃ↄn plaa, aↄ̃ↄe swèe kɛɛ. Ben à gbɛ̃ kɛ̀ à yã nnaroo là à bè: Bↄ́yãnzi nɛ́ɛ n gbɛ̃ndoo gbɛ̃ɛzi? ");
INSERT INTO bus_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","À wèàla à bè: Dé bé à n diɛ kí yãgↄ̃gↄ̃ri ũwee? Ń yezi ǹ ma dɛ lán n Igipiti gbɛ̃ dɛ̀ nàn yↄ́? Ben vĩa Musa kũ̀ à bè: Wà yã kɛ̀ má kɛ̀ dↄ̃̀ fá! ");
INSERT INTO bus_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Kɛ̀ Fili'auna yã pì mà, èe wɛtɛɛ à Musa dɛ, ben à bàa lɛ̀nɛ à tà Midiã bùsun, ben à vɛ̃̀ɛ lↄ̀gↄ saɛ gwe. ");
INSERT INTO bus_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Midiã sa'ori nɛ́nↄgbɛ̃nↄ vĩ gↄ̃ↄn swɛɛplaa, ben aↄ̃ mↄ̀ wà í tↄ̀, aↄ̃ↄ kà pↄ́kãdeenↄ gbãngo ímikiin ń de pↄ́kãdeenↄnɛ. ");
INSERT INTO bus_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Kɛ̀ sãdãri kenↄ mↄ̀ aↄ̃ↄe pɛɛḿma, ben Musa fɛ̀ɛ à yã sìńyo, ben à í kpàńnɛ ń pↄ́kãdeenↄa. ");
INSERT INTO bus_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Kɛ̀ aↄ̃ tà ń de Ruɛli kiia, à ń lá à bè: À kɛ̀ dia a su idɛ lɛ gbã̀a? ");
INSERT INTO bus_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Aↄ̃ wèàla wà bè: Igipiti gↄ̃gbɛ̃ ke bé à wa si sãdãrinↄa. Àmbe se à í tↄ̀ à kpàwe wa pↄ́kãdeenↄa. ");
INSERT INTO bus_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ben à ń lá à bè: Adee pì kú mámɛ? Bↄ́yãnzi a gↄ̃gbɛ̃ pì tò gwezi? À à sísi à mↄ́ à pↄ́ blewao. ");
INSERT INTO bus_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa mↄ̀, ben à wè à vɛ̃̀ɛ kↄ̃n gↄ̃gbɛ̃ pìo, ben gↄ̃gbɛ̃ pì a nɛ́nↄgbɛ̃ Zipora kpàa nↄↄ ũ. ");
INSERT INTO bus_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ben Zipora nɛ́ ì gↄ̃gbɛ̃ ũ, ben Musa tↄ́ kpànɛ Gɛsↄmu, à bè: Gbɛ̃ zĩ̀tↄn ma ũ gbɛ̃ pãndenↄ bùsun kɛ̀. ");
INSERT INTO bus_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Kɛ̀ à gì kɛ̀, ben Igipiti kína gà. Isarailinↄↄ e mboo zↄ̀zĩi kɛ̀ aↄ̃ↄe kɛɛ yãnzi, aↄ̃ↄe wii lɛɛ, ben aↄ̃ wii pì Luda lè. ");
INSERT INTO bus_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","À ń mbona mà, à bà kɛ̀ kú kↄ̃n Ibraĩo kↄ̃n Isaakuo kↄ̃n Yakubuo e sãnlo. ");
INSERT INTO bus_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Luda Isarailinↄ gwà, ben aↄ̃ kɛ̀nɛ wɛ̃nda. ");
INSERT INTO bus_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Musa e a anzure Midiã bùsu sa'ori pↄ́kãdeenↄ dãa à vĩ̀ gbáala ai à kà kpiii kɛ̀ wè sísi Orɛbu kiia. ");
INSERT INTO bus_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ben Dii Malaika bↄ̀ à mↄ̀zi tɛ́vura guu gyanton. Musa gyanto pì gwà à è tɛ́ kúa, mↄde èe tɛ́ kũro. ");
INSERT INTO bus_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ben à bè: Mɛ́ gá mà dabuyã pì gwa mà dↄ̃ pↄ́ kɛ̀ tò gyanto pì e tɛ́ kũuro. ");
INSERT INTO bus_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Kɛ̀ Dii è à mↄ̀ gwa, ben à lɛ́ zùzi zaa gyanto pì guu à bè: Musa! Musa! Ben à wèàla à bè: Maɛ kɛ̀! ");
INSERT INTO bus_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Luda bènɛ: Ǹton sↄ̃ziro. Ǹ n kyatee bↄbↄ, zaakɛ guu kɛ̀ ń zɛn kú adonamɛ. ");
INSERT INTO bus_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ben à bè: Mámbe n dezinↄ Ibraĩ kↄ̃n Isaakuo kↄ̃n Yakubuo Luda ũ. Ben Musa pↄ́ kù a wɛ́ɛa, kɛ̀ à Luda gwana vĩa vĩ yãnzi. ");
INSERT INTO bus_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ben Dii bè: Ma yã'ↄ̃amma kɛ̀ ma gbɛ̃nↄↄ kúo Igipiti è, ma wiii kɛ̀ aↄ̃ wɛ́ɛtãmmarinↄↄ tò aↄ̃ↄe lɛɛ mà. Má wahaa kɛ̀ aↄ̃ↄ kúo dↄ̃. ");
INSERT INTO bus_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ma pita mà ń sí Igipitinↄa mà ń bↄɛ bùsu pìn mà gáńyo bùsu maa yàasan, guu kɛ̀ zwi kↄ̃n zↄ́'io din, bùsu kɛ̀ Kanaanↄↄ kún kↄ̃n Itinↄ kↄ̃n Amↄrinↄ kↄ̃n Pɛrizinↄ kↄ̃n Ivinↄ kↄ̃n Yebusinↄo. ");
INSERT INTO bus_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Isarailinↄ wiilɛna kà ma kiia tia sa, ma ĩaa kɛ̀ Igipitinↄↄ e daaḿma è. ");
INSERT INTO bus_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ǹ gá tia sa, ma n zĩ Fili'aunaamɛ lɛ ǹ ma gbɛ̃ Isarailinↄ bↄɛ Igipiti. ");
INSERT INTO bus_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ben Musa bè Ludanɛ: Dén ma ũ kɛ̀ mɛ́ gá Fili'auna kiia mà Isarailinↄ bↄɛ Igipiti? ");
INSERT INTO bus_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Luda bènɛ: Mɛ́gↄ̃ kúnyo. Zĩna kɛ̀ ma n zĩi sèedan yɛ̀. Tó n ń bↄ́ɛ Igipiti, é dↄnzi kɛmɛ kpiii kɛ̀ kiia. ");
INSERT INTO bus_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ben Musa bè Ludanɛ: Tó ma gaa má ò Isarailinↄnɛ ma bè, aↄ̃ dezinↄ Luda bé à ma zĩḿma, tó aↄ̃ ma la n tↄ́zi sↄ̃ nɛ́? Mɛ́ beńnɛ diamɛ? ");
INSERT INTO bus_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Luda wèàla à bè: Mámbe gbɛ̃ kɛ̀ má dɛ à ũu ũ. Ǹ ońnɛ kɛ̀ mámbe ma n zĩḿma. ");
INSERT INTO bus_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Luda bènɛ dↄ: Ǹ o Isarailinↄnɛ kɛ̀ mamↄma Dii aↄ̃ dezinↄ Ibraĩ kↄ̃n Isaakuo kↄ̃n Yakubuo Luda bé à n zĩḿma. Ma tↄ́n gwe gurↄ píngi. Àgↄ̃ ma sisii lɛ ai a boriia. ");
INSERT INTO bus_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ǹ gá ǹ Isaraili gbɛ̃nsinↄ kakↄ̃a ǹ ońnɛ kɛ̀ mamↄma Dii aↄ̃ dezinↄ Ibraĩ kↄ̃n Isaakuo kↄ̃n Yakubuo Luda bé à bↄ̀ à mↄ̀nzi. Ǹ ońnɛ kɛ̀ mɛ́ɛ ń ee ma yã kɛ̀ wèe kɛɛńnɛ Igipiti è. ");
INSERT INTO bus_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Mɛ́ ń bↄɛ Igipiti guu kɛ̀ wèe wɛ́ɛ tãaḿma pìn, mɛ́ gáńyo bùsu kɛ̀ Kanaanↄↄ kún kↄ̃n Itinↄ kↄ̃n Amↄrinↄ kↄ̃n Pɛrizinↄ kↄ̃n Ivinↄ kↄ̃n Yebusinↄo, guu kɛ̀ zwi kↄ̃n zↄ́'io din. ");
INSERT INTO bus_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Aↄ̃é n yã ma. Mpi kↄ̃n Isaraili gbɛ̃nsinↄ à gá à Igipiti kína le à onɛ kɛ̀ mamↄma Dii Eberunↄ Luda ma bↄ ma mↄazi, ma bè à a gba zɛ́ à gá gurↄ aagↄ̃ↄ kɛ gbáan lɛ à saa o mamↄma Dii a Ludaa. ");
INSERT INTO bus_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Má dↄ̃ kɛ̀ Igipiti kína é we à gáro, séto ma gã nàa. ");
INSERT INTO bus_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Mɛ́ ↄ tↄ̃ Igipitinↄa, mɛ́ dabuyãnↄ kɛ mà kpáońzi, eé gbasa à a gbarɛ. ");
INSERT INTO bus_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Mɛ́ tó Igipitinↄ a wɛ́ɛ gwa, lɛ tó ée taa, é tá ↄkoriro. ");
INSERT INTO bus_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","A nↄgbɛ̃ píngi kondogi ke vura nↄmaablebↄnↄ kↄ̃n pↄ́kãsãanↄ gbeka a Igipiti nↄgbɛ̃ daa kↄ̃n ń nↄgbɛ̃ kɛ̀ aↄ̃ↄ kú a bɛɛnↄ, à da a nɛ́gↄ̃gbɛ̃nↄnɛ kↄ̃n a nɛ́nↄgbɛ̃nↄ. Lɛn é Igipitinↄ pↄ́nↄ síḿma lɛ maamaa. ");
INSERT INTO bus_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musa wèàla à bè: Tó aↄ̃ↄe ma náanɛ kɛro, ben aↄ̃ↄe ma yã maro, tó aↄ̃ bè ḿbe n bↄ n mↄmaziro sↄ̃ nɛ́? ");
INSERT INTO bus_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ben Dii a là à bè: Bↄ́n ń kũna gwee? À wèàla à bè: Gòmɛ. ");
INSERT INTO bus_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Dii bènɛ: Ǹ gò pì pãɛ tↄↄtɛ. Kɛ̀ à pã̀ɛ, ben à lì mlɛ̃̀ ũ, ben Musa bↄ̀ru kpɛɛ. ");
INSERT INTO bus_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Dii bènɛ: Ǹ ↄ bↄ ǹ kũ à vlãa. Kɛ̀ à kũ̀, ben à ɛ̀ara à lì gò ũ à ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Dii bènɛ: Lɛn nɛ́ kɛ lɛ, lɛ aↄ̃ sí kɛ̀ mamↄma Dii aↄ̃ dezinↄ Ibraĩ kↄ̃n Isaakuo kↄ̃n Yakubuo Luda bé à bↄ̀ à mↄ̀nzi. ");
INSERT INTO bus_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Dii ɛ̀ara à bènɛ dↄ: Ǹ n ↄↄ sↄtↄ n utan. Ben à sↄ̀tↄn. Kɛ̀ à bↄ̀, à è a ↄↄ lì kusu ũ, à kɛ̀ púu lán buu bà. ");
INSERT INTO bus_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Dii bènɛ: Ǹ ɛara ǹ n ↄↄ sↄtↄ n utan. À ɛ̀ara à sↄ̀tↄn. Kɛ̀ à bↄ̀, à è à kɛ̀ a gbɛ̀n. ");
INSERT INTO bus_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Dii bènɛ: Tó aↄ̃ↄe n náanɛ kɛ wà sèeda káakupↄ sìro, aↄ̃é à zãa pↄ́ sí. ");
INSERT INTO bus_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Tó aↄ̃ↄe sèeda plaaa pìnↄ sí wà n yã mà sↄ̃ro, ǹ Nili í tↄ́ ǹ kwɛ́ɛ tↄↄtɛ, eé li aru ũ. ");
INSERT INTO bus_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ben Musa bènɛ: N yã nna Dii! Zaa zi yã'ona aagamaoro. Baa zaa gurↄↄ kɛ̀ n yã òmɛ, ma lɛ́ tìisimɛ. ");
INSERT INTO bus_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ben Dii bènɛ: Dé bé à lɛ́ dↄ̀ gbɛ̃nteenɛ? Dé bé è à nɛ́nɛ naɛ ke è à swãdo kũu? Dé bé è tó à guu e ke è à vĩ̀a kũu? Mamↄma Dii, mámbeeroo? ");
INSERT INTO bus_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ǹ gá! Mɛ́ n ĩan ká yã'onao, mɛ́ yã kɛ̀ nɛ́ oo dannɛ. ");
INSERT INTO bus_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ben à bè: N yã nna Dii! N yã nna! Ǹ gbɛ̃ pãnde zĩ. ");
INSERT INTO bus_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ben Dii pↄ fɛ̃̀ Musazi à bè: N vĩ̀i Aruna Levi borii kuuroo? Má dↄ̃ kɛ̀ yã'ona zĩ'ũoro. Èe mↄↄ danlɛ. Tó à wɛ́ɛ sìnlɛ, à pↄↄ é kɛ nna. ");
INSERT INTO bus_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ǹ yã oo ǹ yã kɛ̀ eé oo danɛ. Mapi, mɛ́gↄ̃ à ĩan ká kↄ̃n yã'onao, mɛ́gↄ̃ yã kɛ̀ é kɛɛ daaare. ");
INSERT INTO bus_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Eé yã o gbɛ̃nↄnɛ n gɛ̃ɛ ũ, eégↄ̃ dɛ n lɛ́gbɛkpari ũ, nɛ́gↄ̃ dɛnɛ lán Luda bà. ");
INSERT INTO bus_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ǹ gò kɛ̀ sɛ́ ǹgↄ̃ kũna ǹ sèedanↄ kɛo. ");
INSERT INTO bus_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Musa tà a anzure Yɛtoro kiia à bènɛ: Ǹ ma gba zɛ́ mà tá ma gbɛ̃nↄ kiia Igipiti, mà e tó aↄ̃ↄ kpɛ́ kú wɛ̃̀ndio ai tia. Yɛtoro bènɛ: Ǹ pita aafia. ");
INSERT INTO bus_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Àɛ sↄ̃ Dii gĩakɛ à bè Musanɛ Midiã bùsun: Ǹ fɛɛ ǹ tá Igipiti, zaakɛ gbɛ̃ kɛ̀ aↄ̃ↄe n wɛtɛɛ wà n dɛ yãanↄ gàga ń píngi. ");
INSERT INTO bus_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ben Musa a naↄ̃ sɛ̀ kↄ̃n a nɛ́gↄ̃gbɛ̃nↄ à ń dí zaakia, à lìara èe taa Igipiti à Luda gò pì kũna. ");
INSERT INTO bus_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ben Dii bènɛ: Tó n ka Igipiti, ǹ dabuyã kɛ̀ ma à gbãaa kpàmmaanↄ kɛ Fili'auna aɛ píngi. Mↄde mɛ́ à kùgbãa kũ, eé gí gbɛ̃nↄ gbarɛzi. ");
INSERT INTO bus_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ǹ onɛ mamↄma Dii ma bè, Isaraili boriin ma daudu ũ, ");
INSERT INTO bus_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ben ma bènɛ à ma daudu gbarɛ à gá dↄnzi kɛmɛ. Lán à gì à gbarɛzi nà, mɛ́ à daudu dɛ sa. ");
INSERT INTO bus_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Zɛ́ guu Musa e ii gukea, ben Dii à lè gwe à yezi à à dɛ. ");
INSERT INTO bus_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Ben Zipora gbɛ̀ fɛ̃ɛ sɛ̀ à a nɛ́ bã̀ngu kɛ̀o à a gɛfↄↄ nà Musa gbáa à bè: Yãpuramɛ, ń dɛmɛ gↄ̃ arudee ũ. ");
INSERT INTO bus_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Bã̀ngukɛna beee yãnzin à bènɛ gↄ̃ arudeezi. Ben Dii Musa tò. ");
INSERT INTO bus_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Dii bè Arunanɛ: Ǹ gá da Musalɛ gbáan. Ben à gàa à à lè Luda kpiii kiia, à lɛ́ pɛ̀ à gasua. ");
INSERT INTO bus_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Musa yã kɛ̀ Dii a zĩ à oo tↄ̃kɛ̃̀ Arunanɛ kↄ̃n sèeda kɛ̀ à bènɛ à kɛɛnↄ. ");
INSERT INTO bus_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ben Musa kↄ̃n Arunao tà Igipiti aↄ̃ Isaraili gbɛ̃nsinↄ kàkↄ̃a. ");
INSERT INTO bus_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aruna yã kɛ̀ Dii ò Musanɛ tↄ̃kɛ̃̀ńnɛ ń píngi, ben Musa dabuyã pìnↄ kɛ̀ Isarailinↄ wáa. ");
INSERT INTO bus_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Aↄ̃ yã pì sì. Kɛ̀ aↄ̃ↄ mà Dii bé à mↄ̀ ń gwa à ń yã'ↄ̃amma è, ben aↄ̃ kùɛ wà dↄnzi kɛ̀nɛ. ");
INSERT INTO bus_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Beee gbɛra Musa kↄ̃n Arunao gàa wà Fili'auna lè aↄ̃ bènɛ: Yã kɛ̀ Dii Isarailinↄ Ludaa òn yɛ̀. À bè ǹ a gbɛ̃nↄ gbarɛ aↄ̃ gá zĩbaa kɛare gbáan. ");
INSERT INTO bus_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Fili'auna wèńla à bè: Dén Dii ũ kɛ̀ mà à yã ma mà Isarailinↄ gbarɛɛ? Má Dii dↄ̃ro. Mɛ́ Isarailinↄ gbarɛro. ");
INSERT INTO bus_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ben aↄ̃ bènɛ: Eberunↄ Luda bé à bↄ̀ à mↄ̀wazi. Ǹ wa gba zɛ́ wà gá wà gurↄ aagↄ̃ↄ kɛ gbáan wà saa o Dii wa Luda pìa, lɛ àton gyãa káwaguro kesↄ̃ zĩ̀. ");
INSERT INTO bus_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ben Igipiti kína pì bè Musa kↄ̃n Arunaonɛ: À kɛ̀ dia á tò gbɛ̃nↄ làakari e goo ń zĩia? À sↄkpa a zĩia. ");
INSERT INTO bus_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ben à ɛ̀ara à bè: Kɛ̀ gbɛ̃nↄ pari kũ̀ sa, ben á yezi aↄ̃ kámma bo kↄ̃n ń zĩioↄ́? ");
INSERT INTO bus_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Zĩ beeea Fili'auna yã dìɛ Isaraili wɛ́ɛtãmmarinↄnɛ kↄ̃n ń dↄn'aɛdeenↄ à bè: ");
INSERT INTO bus_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Àton sɛ̃̀buru kpáḿma aↄ̃ kúnku bↄo lán eè kɛ nà yã dↄro. Aↄ̃ gá wà ń pↄ́ kɛ̃ ń zĩnda. ");
INSERT INTO bus_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Mↄde aↄ̃ kúnku bↄ lán aↄ̃è bↄ nà yã lɛ́n. Àton lagońnɛro, zaakɛ mɛadeenↄmɛ. Beee yãnzi aↄ̃ wiii ègↄ̃ dↄ, aↄ̃ↄe bee wà yezi wà gá saa o ń Ludaazi. ");
INSERT INTO bus_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","À zĩi kaarańnɛ lɛ aↄ̃ton ĩampakii e aↄ̃ làakari kpá ɛgɛyãnↄa dↄro. ");
INSERT INTO bus_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ben aↄ̃ wɛ́ɛtãmmari pìnↄ kↄ̃n ń dↄn'aɛdeenↄ mↄ̀ aↄ̃ bèńnɛ: Fili'auna bè wàton sɛ̃̀buru kpáawa dↄro. ");
INSERT INTO bus_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","À gá à wɛtɛ a zĩnda guu kɛ̀ é en. Baa kↄ̃n beeeo wé zĩi lagoarero, baa féte. ");
INSERT INTO bus_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ben aↄ̃ fã̀akↄ̃a wà gàa Igipiti gu píngi sɛ̃̀ kɛ̃ sɛ̃̀buru ũ. ");
INSERT INTO bus_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Aↄ̃ wɛ́ɛtãmmari pìnↄ ègↄ̃ nakↄ̃rɛɛḿma lán guu e dↄↄ nà, lɛ aↄ̃ ń zĩ nɛ lán aↄ̃è nɛ nà gurↄↄ kɛ̀ wèe sɛ̃̀buru kpaaḿma. ");
INSERT INTO bus_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Wà gbɛ̃na kɛ̀ Isaraili dↄn'aɛdee kɛ̀ aↄ̃ wɛ́ɛtãmmarinↄↄ dìɛnↄnɛ wà bèńnɛ: À kɛ̀ dia ée kúnku bↄ gbã̀a ke gĩa à kà lán wà a lɛ́ dìɛare nà yãroo? ");
INSERT INTO bus_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ben Isaraili dↄn'aɛdeenↄ gàa wà wii lɛ̀ Fili'aunaa wà bè: À kɛ̀ dia nɛ́ɛ kɛɛ wamↄwa n zↄ̀blerinↄnɛ lɛɛ? ");
INSERT INTO bus_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Wèe sɛ̃̀buru kpaawa dↄro, ben wèe bee wà kúnku bↄ. Wèe wa gbɛ̃ɛ, mↄde n gbɛ̃nↄ bé wà taari vĩ. ");
INSERT INTO bus_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ben à bè: Mɛadeenↄn a ũ. Lɛn á dɛ lɛ! Beee yãnzi eègↄ̃ bee é gá saa o Diiazi. ");
INSERT INTO bus_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","À gá zĩi kɛ. Weé sɛ̃̀buru kpáawa dↄro, baa kↄ̃n beeeo é kúnku bↄ lán wà dàare nà lɛ́mmɛ. ");
INSERT INTO bus_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Kɛ̀ wà ò Isaraili dↄn'aɛdeenↄnɛ aↄ̃ton gurↄ doo kúnkubↄna lagoro, aↄ̃ↄ dↄ̃̀ kɛ̀ wà yã è sa. ");
INSERT INTO bus_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Kɛ̀ aↄ̃ bↄ̀ Fili'auna kiia, aↄ̃ dàkↄ̃rɛ kↄ̃n Musao kↄ̃n Arunao, aↄ̃ↄe ń dãa, ");
INSERT INTO bus_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ben aↄ̃ bèńnɛ: Dii a yã gwa à yãkpaɛ kɛao, zaakɛ á tò Fili'auna kↄ̃n a gbɛ̃nↄↄ ye wa kãziro. A wa dɛna gbãaa kpàḿman gwe. ");
INSERT INTO bus_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Ben Musa lìara à gàa à bè Diinɛ: Dii, bↄ́yãnzi n ĩa dà gbɛ̃ pìnↄa? Beee yãnzin n ma zĩziↄ́? ");
INSERT INTO bus_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Zaa gurↄↄ kɛ̀ ma gaa ma yã ò Fili'aunanɛ kↄ̃n n tↄ́o, ben èe ĩa da n gbɛ̃nↄa, ben nɛ́ɛ ń bↄ sↄ̃ro nɛ́! ");
INSERT INTO bus_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ben Dii bènɛ: Nɛ́ yã kɛ̀ mɛ́ kɛ Fili'aunanɛ e tia. Eé ń gbarɛ ma gbãa bíta yãnzi. Eé pɛ́ḿma a bùsun ma gbãa bíta yãnzi. ");
INSERT INTO bus_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ben Luda ɛ̀ara à yã ò Musanɛ à bè: Mámbe Dii ũ, ");
INSERT INTO bus_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ma bↄ ma mↄ Ibraĩ kↄ̃n Isaakuo kↄ̃n Yakubuozi Luda Gbãapingide ũ, mↄde aↄ̃ↄe ma dↄ̃ ma tↄ́ Diiaro. ");
INSERT INTO bus_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ma bà kúńyo, ma bè mɛ́ Kanaa bùsu kɛ̀ aↄ̃ↄ kú à guu gbɛ̃ zĩ̀tↄ ũ kpáḿma. ");
INSERT INTO bus_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ma Isarailinↄ mbona mà aↄ̃ zↄ̀blena Igipitinↄnɛ yãnzi, ben ma bà kɛ̀ kúńyo pì yã e sãmaguro. ");
INSERT INTO bus_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Beee yãnzi ǹ o Isarailinↄnɛ kɛ̀ mámbe Dii ũ. Mɛ́ a bↄ zĩ gbãaa kɛ̀ Igipitinↄↄ dàaree guu, mɛ́ a bↄ zↄ̀bleen. Mɛ́ yãkpaɛ kɛńyo mà a bↄ kↄ̃n ma gã̀sã gbãaao. ");
INSERT INTO bus_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Mɛ́ a sɛ́ ma gbɛ̃nↄ ũ, mɛ́gↄ̃ dɛ a Luda ũ, égↄ̃ dↄ̃ kɛ̀ mámbe Dii a Luda kɛ̀ à a bↄ Igipiti zĩ gbãaa guu ũ. ");
INSERT INTO bus_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Mɛ́ gáao bùsu kɛ̀ ma à lɛ́ gbɛ̃̀ Ibraĩnɛ kↄ̃n Isaakuo kↄ̃n Yakubuo guu. Mɛ́ a gba àgↄ̃ vĩ. Mámbe Dii ũ. ");
INSERT INTO bus_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa yã pì ò Isarailinↄnɛ, mↄde aↄ̃ↄe à yã maro kɛ̀ zↄ̀zĩ pãsĩ ń mɛ̀ yↄ̀ yãnzi. ");
INSERT INTO bus_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ben Dii ò Musanɛ à bè: ");
INSERT INTO bus_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Ǹ gá ǹ o Igipiti kí Fili'aunanɛ à Isarailinↄ gbarɛ aↄ̃ bↄɛ a bùsun. ");
INSERT INTO bus_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ben Musa wè Diila à bè: Lán Isarailinↄ è ma yã maro nà, mamↄma kɛ̀ ma lɛ́ tìisi, dian Fili'auna é ma yã ma nà? ");
INSERT INTO bus_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Dii yã ò Musanɛ kↄ̃n Arunao Isarailinↄ yã musu kↄ̃n Igipiti kínao, à òńnɛ aↄ̃ bↄɛ kↄ̃n Isarailinↄ Igipiti. ");
INSERT INTO bus_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Aↄ̃ bori uabɛde káakunↄ tↄ́n yɛ̀. Isaraili daudu Rubɛni nɛ́gↄ̃gbɛ̃nↄn yɛ̀: Anↄku, Palu, Ɛzɛrↄnu, Kaami. Rubɛni boriinↄn gwe danɛdanɛ. ");
INSERT INTO bus_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simɛↄ nɛ́gↄ̃gbɛ̃nↄn yɛ̀: Yemuɛli, Yami, Oada, Yakĩ, Zoa kↄ̃n Kanaa nↄgbɛ̃ nɛ́ Soluo. Simɛↄ boriinↄn gwe danɛdanɛ. ");
INSERT INTO bus_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Levi nɛ́gↄ̃gbɛ̃nↄ tↄ́n yɛ̀ aↄ̃ boriinↄa: Gɛsↄnu, Koa, Mɛrari. Levi kɛ̀ wɛ̃̀ baswɛɛdo akuri awɛɛswɛɛplaamɛ. ");
INSERT INTO bus_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gɛsↄnu nɛ́gↄ̃gbɛ̃nↄn yɛ̀ aↄ̃ boriinↄa danɛdanɛ: Libini kↄ̃n Simɛio. ");
INSERT INTO bus_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Koa nɛ́gↄ̃gbɛ̃nↄ tↄ́n yɛ̀: Amlamu, Iza, Ɛblↄnu, Uziɛli. Koa kɛ̀ wɛ̃̀ baswɛɛdo akuri awɛɛ'aagↄ̃mɛ. ");
INSERT INTO bus_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Mɛrari nɛ́gↄ̃gbɛ̃nↄn Mali kↄ̃n Musio ũ. Levi boriinↄn gwe danɛdanɛ. ");
INSERT INTO bus_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amlamu a dasɛ̃ Yↄkɛbɛdi sɛ̀ nↄↄ ũ, ben à Aruna kↄ̃n Musao ìo. Amlamu kɛ̀ wɛ̃̀ baswɛɛdo akuri awɛɛswɛɛplaamɛ. ");
INSERT INTO bus_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Iza nɛ́gↄ̃gbɛ̃nↄn Kora kↄ̃n Nɛfɛgio kↄ̃n Zikirio ũ. ");
INSERT INTO bus_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uziɛli nɛ́gↄ̃gbɛ̃nↄn Misaili kↄ̃n Ɛlɛzafão kↄ̃n Sitirio ũ. ");
INSERT INTO bus_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aruna Aminadabu nɛ́ Ɛlisɛba, Nasↄ̃ dãre sɛ̀ nↄↄ ũ, ben à Nadabu kↄ̃n Abiuo kↄ̃n Ɛlɛazao kↄ̃n Itamao ìo. ");
INSERT INTO bus_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kora nɛ́gↄ̃gbɛ̃nↄn Asi kↄ̃n Ɛlɛkanao kↄ̃n Abiasafao ũ. Kora boriinↄn gwe danɛdanɛ. ");
INSERT INTO bus_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aruna nɛ́ Ɛlɛaza Putiɛli nɛ́nↄgbɛ̃nↄ doke sɛ̀ nↄↄ ũ, ben à Finɛasi ìo. Levi bori uabɛde káakunↄn gwe danɛdanɛ. ");
INSERT INTO bus_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aruna kↄ̃n Musa kɛ̀ Dii òńnɛ aↄ̃ Isarailinↄ bↄɛ Igipiti gãli kↄ̃n gãlion gwe. ");
INSERT INTO bus_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Aↄ̃pinↄ bé wà yã ò Igipiti kí Fili'aunanɛ lɛ aↄ̃ Isarailinↄ bↄɛ Igipiti. ");
INSERT INTO bus_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Kɛ̀ Dii yã ò Musanɛ Igipiti, ");
INSERT INTO bus_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","à bè ambe Dii ũ, yã kɛ̀ ée oonɛn à o Fili'aunanɛ píngi. ");
INSERT INTO bus_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ben Musa bènɛ a lɛ́ tìisi, dian Fili'auna é a yã ma nà? ");
INSERT INTO bus_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ben Dii bè Musanɛ: Ǹ gwa! Ma n kɛ lán ma bà Fili'aunanɛ, bensↄ̃ n vĩ̀i Aruna dɛ n lɛ́gbɛkpari ũ. ");
INSERT INTO bus_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ǹ yã kɛ̀ má ònnɛ píngi o n vĩ̀i Arunanɛ, eé o Fili'aunanɛ à Isarailinↄ gbarɛ aↄ̃ bↄɛ a bùsun. ");
INSERT INTO bus_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Baa kↄ̃n beeeo mɛ́ à kùgbãa kũ. Mɛ́ sèedanↄ kↄ̃n dabuyãnↄ kɛ Igipiti pari, ");
INSERT INTO bus_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","mↄde Fili'auna é a yã maro. Mɛ́ ↄ tↄ̃ Igipitia mà yãkpaɛ kɛńyo pãsĩpãsĩ, mɛ́ bↄ kↄ̃n ma zĩ̀kpɛ Isarailinↄo. ");
INSERT INTO bus_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Tó ma bↄ ma gbãaao Igipitia, mɛ́ Isarailinↄ bↄɛn, Igipitinↄ é dↄ̃ sa kɛ̀ mámbe Dii ũ. ");
INSERT INTO bus_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Ben Musa kↄ̃n Arunao kɛ̀ lán Dii òńnɛ nà. ");
INSERT INTO bus_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Gurↄↄ kɛ̀ aↄ̃ yã ò Fili'aunanɛ, Musa kuu wɛ̃̀ basiigↄ̃, Aruna sↄ̃ wɛ̃̀ basiigↄ̃ awɛɛ'aagↄ̃. ");
INSERT INTO bus_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ben Dii bè Musanɛ kↄ̃n Arunao: ");
INSERT INTO bus_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Tó Fili'auna dabuyã gbèkamma, ǹ o Arunanɛ à a gò sɛ́ à pãɛ à aɛ, eé li mlɛ̃̀ ũ. ");
INSERT INTO bus_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Kɛ̀ Musa kↄ̃n Arunao gàa Fili'auna kiia, aↄ̃ↄ kɛ̀ lán Dii òńnɛ nà. Aruna a gò sɛ̀ à pã̀ɛ Fili'auna kↄ̃n a ìbanↄ aɛ, ben à lì mlɛ̃̀ ũ. ");
INSERT INTO bus_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ben Fili'auna Igipiti wɛ́ɛzɛ̃rinↄ kↄ̃n ɛ̃zɛ̃deenↄ sìsi, ben aↄ̃ dabuyã dↄ̃nkↄ̃ pìnↄ kɛ̀ se ń ɛ̃zɛ̃dekɛɛ guu. ");
INSERT INTO bus_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Kɛ̀ aↄ̃ baade a gò pã̀ɛ, ben aↄ̃ gò pìnↄ lì mlɛ̃̀nↄ ũ, ben Aruna gò ń pↄ́nↄ mↄ̀mↄ. ");
INSERT INTO bus_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Fili'auna swã gbãa, èe ń yã maro lán Dii ò nà. ");
INSERT INTO bus_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Dii bè Musanɛ: Fili'auna kù gbãa à gì gbɛ̃nↄ gbarɛzi. ");
INSERT INTO bus_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ǹ gá ǹ à le zia kↄngↄ gurↄↄ kɛ̀ èe gaa swaazi. Ǹgↄ̃ à dãa Nili saɛ gwe. Ǹgↄ̃ n gò kɛ̀ lì mlɛ̃̀ ũu pì kũna. ");
INSERT INTO bus_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ǹ benɛ mamↄma Dii Eberunↄ Luda ma n zĩa, ń ònɛ à ma gbɛ̃nↄ gbarɛ aↄ̃ gá dↄnzi kɛmɛ gbáan, mↄde ai tia à gìmazi. ");
INSERT INTO bus_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Mamↄma Dii ma bè, yã kɛ̀ eé tó àgↄ̃ dↄ̃ kɛ̀ mámbe Dii ũun yɛ̀. Tó n Nili í lɛ̀ kↄ̃n gò kɛ̀ ń kũnao, eé li aru ũ. ");
INSERT INTO bus_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Kpↄ̀ kɛ̀ aↄ̃ↄ kú í pì guunↄ é gaga, Nili í é gũu sↄ̃, Igipitinↄ é fua wà mi. ");
INSERT INTO bus_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ben Dii ɛ̀ara à bè Musanɛ: Ǹ o Arunanɛ à a gò sɛ́ à dↄ Igipiti ínↄla, aↄ̃ swaanↄ kↄ̃n ń swa'ↄnɛnↄ kↄ̃n ń íbↄkiinↄ kↄ̃n ń íkakiinↄ píngi é gↄ̃ aru ũ. Aru égↄ̃ dagula Igipiti, baa kpɛ̃ɛnↄ kↄ̃n orozã guunↄ. ");
INSERT INTO bus_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Ben Musa kↄ̃n Arunao kɛ̀ lán Dii òńnɛ nà. Aruna a gò pì sɛ̀, à Nili í lɛ̀o Fili'auna kↄ̃n a ìbanↄ wáa, ben í pì gↄ̃̀ aru ũ píngi. ");
INSERT INTO bus_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Kpↄ̀ kɛ̀ aↄ̃ↄ kú à guunↄ gàga, ben Nili í pì gũu sↄ̃̀, Igipitinↄ fùa wà mi. Aru dagula Igipiti. ");
INSERT INTO bus_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Igipiti ɛ̃zɛ̃deenↄↄ kɛ̀ lɛ se ń ɛ̃zɛ̃dekɛɛ guu, ben Fili'auna kùgbãa kũ̀, èe ń yã maro lán Dii ò nà. ");
INSERT INTO bus_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Fili'auna lìara à tà a bɛ, èe yã pì da sero. ");
INSERT INTO bus_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Igipitinↄ íbↄkii yↄ̃̀yↄ̃ Nili baa lɛ wà í mi, zaakɛ aↄ̃ↄe fↄ̃ wà swada í mìro. ");
INSERT INTO bus_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","À kuu lɛ ai gurↄ swɛɛplaamɛ Dii Nili lɛna gbɛra. ");
INSERT INTO bus_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ben Dii bè Musanɛ: Ǹ gá ǹ o Fili'aunanɛ, mamↄma Dii ma bè à ma gbɛ̃nↄ gbarɛ aↄ̃ gá dↄnzi kɛmɛ. ");
INSERT INTO bus_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Tó à gì ń gbarɛzi sↄ̃, mɛ́ tó blↄ̀nↄ da à bùsu gu píngila. ");
INSERT INTO bus_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Blↄ̀nↄ é Nili pa ai aↄ̃ bikũ baa, aↄ̃é gɛ̃ à ua guu ai à kpɛ́n, aↄ̃é didi à gádoa. Aↄ̃é gɛ̃ à ìbanↄ uanↄ guu kↄ̃n à gbɛ̃nↄ uanↄ. Aↄ̃é ká à kĩinↄ kↄ̃n à gónↄ guu. ");
INSERT INTO bus_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Blↄ̀nↄ é didia kↄ̃n à gbɛ̃nↄ kↄ̃n à ìbanↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Dii ɛ̀ara à bè Musanɛ: Ǹ o Arunanɛ à a gò sɛ́ à dↄ swaanↄla kↄ̃n swa'ↄnɛnↄ kↄ̃n íbↄkiinↄ, blↄ̀nↄ é da Igipiti bùsula. ");
INSERT INTO bus_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Kɛ̀ Aruna a gò dↄ̀ Igipiti ínↄla, ben blↄ̀nↄ bↄ̀ɛ wà dà bùsu pìla. ");
INSERT INTO bus_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ben ɛ̃zɛ̃dee pìnↄↄ kɛ̀ lɛ se ń ɛ̃zɛ̃dekɛɛ guu, aↄ̃ↄ tò blↄ̀nↄ dà Igipitila. ");
INSERT INTO bus_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ben Fili'auna Musa kↄ̃n Arunao sìsi à bè: À agbaa kpá Diinɛ à blↄ̀nↄ kɛ̃ma kↄ̃n ma gbɛ̃nↄ, mɛ́ a gbɛ̃nↄ gbarɛ aↄ̃ gá saa oa. ");
INSERT INTO bus_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ben Musa bè Fili'aunanɛ: Ǹ gurↄↄ diɛmɛ mà agbaa kpánnɛ Diinɛ kↄ̃n n ìbanↄ kↄ̃n n gbɛ̃nↄ, lɛ à blↄ̀nↄ kɛ̃mma kↄ̃n n uanↄ aↄ̃égↄ̃ kú swaazi ado. ");
INSERT INTO bus_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Fili'auna bè: Zia. Ben Musa bè: Eé kɛ lán ń ò nà lɛ ǹgↄ̃ dↄ̃ kɛ̀ gbɛ̃kee dɛ lán Dii wa Luda bàro. ");
INSERT INTO bus_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Blↄ̀nↄ é kɛ̃mma kↄ̃n n uanↄ kↄ̃n n ìbanↄ kↄ̃n n gbɛ̃nↄ aↄ̃égↄ̃ kú swaazi ado. ");
INSERT INTO bus_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Kɛ̀ Musa kↄ̃n Arunao gù Fili'auna kiia, Musa wɛ́ɛ kɛ̀ Diia blↄ̀ kɛ̀ aↄ̃ dà Fili'aunalaanↄ yã musu. ");
INSERT INTO bus_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Dii Musa wɛ́ɛkɛɛ sì, ben blↄ̀nↄ gàga kpɛ́nↄ guu kↄ̃n uanↄ kↄ̃n buraanↄ. ");
INSERT INTO bus_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Wà ń kákakↄ̃a, ben bùsu gũu sↄ̃̀ píngi. ");
INSERT INTO bus_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Kɛ̀ Fili'auna è à kɛ̀ sã̀ↄ, à swã kpɛ́ gbãa, ben à gì Musa kↄ̃n Arunao yã mazi lán Dii ò nà. ");
INSERT INTO bus_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Dii bè Musanɛ: Ǹ o Arunanɛ à a gò sɛ́, à tↄↄtɛ lɛ́o, bùsuti é li gãi ũ Igipiti gu píngia. ");
INSERT INTO bus_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ben aↄ̃ↄ kɛ̀ lɛ. Aruna a gò sɛ̀ à tↄↄtɛ lɛ̀o, ben bùsuti lì gãinↄ ũ, aↄ̃ dà gbɛ̃nteenↄla kↄ̃n nↄ̀bↄnↄ. Igipiti bùsuti lì gãinↄ ũ píngi. ");
INSERT INTO bus_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ɛ̃zɛ̃deenↄↄ yↄ̃̀ wà gwà se ń ɛ̃zɛ̃dekɛɛ guu, ben aↄ̃ fùa. Gãinↄ dà gbɛ̃nteenↄla kↄ̃n nↄ̀bↄnↄ. ");
INSERT INTO bus_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ben ɛ̃zɛ̃deenↄ bè Fili'aunanɛ: Luda ↄgbɛmɛ. Mↄde Fili'auna swã kpɛ́ gbãa, à gì ń yã mazi lán Dii ò nà. ");
INSERT INTO bus_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Dii bè Musanɛ: Ǹ fɛɛ kↄngↄ idɛ'idɛ ǹ gá ǹ Fili'auna le gurↄↄ kɛ̀ èe gaa swaazi, ǹ onɛ mamↄma Dii ma bè, à ma gbɛ̃nↄ gbarɛ aↄ̃ gá dↄnzi kɛmɛ. ");
INSERT INTO bus_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Tó à gì ń gbarɛzi, mɛ́ ifĩinↄ daàla kↄ̃n à ìbanↄ kↄ̃n à gbɛ̃nↄ kↄ̃n à kpɛ́nↄ. Igipiti kpɛ́nↄ é pa kↄ̃n ifĩinↄ, baa tↄↄtɛ aↄ̃é daàla. ");
INSERT INTO bus_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Gurↄ beeea mɛ́ Gosɛ̃ bùsu guu kɛ̀ ma gbɛ̃nↄↄ kún tó ado. Gwen ifĩinↄ é dan gularo, lɛ àgↄ̃ dↄ̃ kɛ̀ mámbe Dii ũ à bùsun. ");
INSERT INTO bus_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Mɛ́ ma gbɛ̃nↄ dↄ̃kↄ̃zi kↄ̃n à gbɛ̃nↄ. Zian sèeda pì é kɛ. ");
INSERT INTO bus_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ben Dii kɛ̀ lɛ. Ifĩinↄ kà Fili'auna ua guu kↄ̃n à ìbanↄ uanↄ. Igipiti yàka píngi ifĩinↄ yãnzi. ");
INSERT INTO bus_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Ben Fili'auna Musa kↄ̃n Arunao sìsi à bè: À gá saa o a Ludaa bùsu kɛ̀n. ");
INSERT INTO bus_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ben Musa bènɛ: Eé sí kɛ wà kɛ lɛro, zaakɛ pↄ́ kɛ̀ wé saa oo Dii wa Ludaa pì dɛ Igipitinↄnɛ tɛ̃̀ ũmɛ. Tó wa saa ò kↄ̃n pↄ́ kɛ̀ dɛńnɛ tɛ̃̀ ũuo ń wáa, aↄ̃é wa pápa gbɛ̀o wà wa dɛdɛroo? ");
INSERT INTO bus_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Wé táa o gbáan gurↄ aagↄ̃mɛ, wé gbasa wà saa o Dii wa Ludaa lán à òwe nà. ");
INSERT INTO bus_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ben Fili'auna bè: Mɛ́ a gbarɛ à gá saa o Dii a Ludaa gbáan, mↄde àton gá zã̀ro. À agbaa kpanɛmɛ sa. ");
INSERT INTO bus_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa bènɛ: Tó ma ta, mɛ́ agbaa kpánɛ, eé ifĩinↄ kɛ̃mma zia kↄ̃n n ìbanↄ kↄ̃n n gbɛ̃nↄ. Mↄde ǹton mↄnafiki kɛ dↄro. Ǹ tó gbɛ̃nↄ gá saa o Diia. ");
INSERT INTO bus_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Kɛ̀ Musa bↄ̀ Fili'auna kiia, à agbaa kpànɛ Diinɛ. ");
INSERT INTO bus_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Dii à wɛ́ɛkɛɛ sì, ben ifĩinↄ kɛ̃̀ Fili'aunaa kↄ̃n a ìbanↄ kↄ̃n a gbɛ̃nↄ. Èe gↄ̃ gukearo, baa mɛ̀n do. ");
INSERT INTO bus_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Mↄde Fili'auna swã kpɛ́ gbãa ai tia, à gì ń gbarɛzi. ");
INSERT INTO bus_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Dii bè Musanɛ: Ǹ gá ǹ Fili'auna le ǹ onɛ Dii Eberunↄ Luda bè à ma gbɛ̃nↄ gbarɛ aↄ̃ gá dↄnzi kɛmɛ. ");
INSERT INTO bus_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Tó à gì ń gbarɛzi, tó à kpɛ́ ń kũna ai tia, ");
INSERT INTO bus_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","mɛ́ ↄ tↄ̃ à pↄ́kãdeenↄa bura. Mɛ́ gagyã pãsĩ ká à sↄ̃nↄn kↄ̃n à zaakinↄ kↄ̃n à lakuminↄ kↄ̃n à zùnↄ kↄ̃n à sãanↄ kↄ̃n à blènↄ. ");
INSERT INTO bus_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Mɛ́ Isaraili pↄ́kãdeenↄ dↄ̃kↄ̃zi kↄ̃n Igipitinↄ pↄ́nↄo. Isarailinↄ pↄ́kãdeenↄ ke é garo. ");
INSERT INTO bus_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Mamↄma Dii ma à gurↄↄ dìɛ. Zian mɛ́ beee kɛ bùsu kɛ̀n. ");
INSERT INTO bus_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Kɛ̀ guu dↄ̀, ben Dii kɛ̀ lɛ. Igipitinↄ pↄ́kãdeenↄ gàga píngi, mↄde Isarailinↄ pↄ́kãdeenↄ kee e garo. ");
INSERT INTO bus_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Fili'auna yã kɛ̀ kɛ̀ pì gbèka, à mà Isarailinↄ pↄ́kãdeenↄ kee e garo, mↄde à swã kpɛ́ gbãa, à gì gbɛ̃ pìnↄ gbarɛzi. ");
INSERT INTO bus_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Dii bè Musanɛ kↄ̃n Arunao: À mↄ̀dakpɛ túbu kↄ ↄkũ doodo, Musa fã Fili'auna aɛ. ");
INSERT INTO bus_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Eé da Igipiti bùsula píngi lán lutɛ̃ bà, eé ká gbɛ̃nteenↄn kↄ̃n nↄ̀bↄnↄ bↄ̀gĩi ũ gu píngia. ");
INSERT INTO bus_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ben aↄ̃ mↄ̀dakpɛ túbu sɛ̀ɛ aↄ̃ gàao Fili'auna kiia. Kɛ̀ Musa túbu pì fã̀ musu, ben à kà gbɛ̃nteenↄn kↄ̃n nↄ̀bↄnↄ bↄ̀gĩi ũ. ");
INSERT INTO bus_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ɛ̃zɛ̃deenↄↄ e fↄ̃ wà gàa Musa kiiaro bↄ̀gĩi pìnↄ yãnzi, zaakɛ à dàńla kↄ̃n Igipitinↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ben Dii Fili'auna kù kɛ̀ gbãa lán à ò Musanɛ nà, ben à gì ń yã mazi. ");
INSERT INTO bus_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Dii bè Musanɛ: Ǹ fɛɛ kↄngↄ idɛ'idɛ ǹ gá ǹ Fili'auna le, ǹ onɛ mamↄma Dii Eberunↄ Luda ma bè à ma gbɛ̃nↄ gbarɛ aↄ̃ gá dↄnzi kɛmɛ. ");
INSERT INTO bus_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Tia sa mɛ́ yã pãsĩ píngi daàla kↄ̃n a ìbanↄ kↄ̃n à gbɛ̃nↄ, lɛ àgↄ̃ dↄ̃ kɛ̀ anduna guu píngi gbɛ̃kee dɛ lán ma bàro. ");
INSERT INTO bus_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Zaakɛ tó ma ↄ tↄ̃̀ḿma ma gagyãa kàńgu yã, lɛ àpi kↄ̃n a gbɛ̃nↄ yã̀a anduna guu. ");
INSERT INTO bus_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ma à kà kpatan lɛ mà a gbãaa ↄdↄanɛ, wà ma tↄ́ kpá anduna guu píngi. ");
INSERT INTO bus_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Lán èe a zĩnda sɛɛ lezĩ dɛ ma gbɛ̃nↄla nà ai tia, èe ń gbarɛro, ");
INSERT INTO bus_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","zia mↄndaa'i mɛ́ tó lougbɛ pãsĩ ma maamaa, lougbɛ kɛ̀ a taka e ma Igipiti zikiro zaa lán wà à kàɛ nà ai mↄna gbã̀a. ");
INSERT INTO bus_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ǹ onɛ à gbɛ̃nↄ zĩ aↄ̃ à pↄ́kãdeenↄ kↄ̃n pↄ́ kɛ̀ à vĩ buraanↄ sɛ́ɛ wà káka kpɛ́n píngi. Gbɛ̃nteenↄ kↄ̃n pↄ́ kɛ̀ aↄ̃ↄ kú bàazinↄ, tó wèe gɛ̃ńyo kpɛ́nlo, lougbɛ é maḿma aↄ̃é gagamɛ. ");
INSERT INTO bus_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Fili'auna ìba kenↄ vĩa kɛ̀ Dii yãnɛ, aↄ̃ ń zĩkɛrinↄ kↄ̃n ń pↄ́kãdeenↄ kàka kpɛ́n. ");
INSERT INTO bus_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Mↄde gbɛ̃ kɛ̀ aↄ̃ↄe Dii yã daroonↄ ń zĩkɛrinↄ kↄ̃n ń pↄ́kãdeenↄ tò bàazi. ");
INSERT INTO bus_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ben Dii bè Musanɛ: Ǹ ↄ sɛ́ musu, lougbɛ é ma gbɛ̃nteenↄ kↄ̃n pↄ́kãdeenↄ kↄ̃n bura pↄ́nↄa Igipiti bùsu gu píngia. ");
INSERT INTO bus_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Kɛ̀ Musa a gò dↄ̀ musu, Dii tò lou e pũtãa èe maa kↄ̃n gbɛ̀o èe pii, ben laa e pɛɛɛ tↄↄtɛa. Dii tò lougbɛ mà Igipitinↄla. ");
INSERT INTO bus_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Lougbɛ e maa, lou e pii. Lougbɛ pì pãsĩ. Zaa lán Igipiti bùsu kuu nà, lou beee taka e ma zikiro. ");
INSERT INTO bus_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Lougbɛ pì pↄ́ kɛ̀ kú bàazi Igipiti bùsu guunↄ ásaru kɛ̀ píngi, gbɛ̃nteenↄ kↄ̃n pↄ́kãdeenↄ kↄ̃n bura pↄ́nↄ píngi. À sɛ̃̀tɛ línↄ ɛ̀'ɛ píngi. ");
INSERT INTO bus_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Gosɛ̃ bùsu guu kɛ̀ Isarailinↄↄ kúnn lougbɛ pì e kánlo ado. ");
INSERT INTO bus_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Fili'auna Musa kↄ̃n Arunao sìsi à bèńnɛ: Tia sa ma durun kɛ̀. Dii yã bé à nna, mapi kↄ̃n ma gbɛ̃nↄ taarideenↄn wa ũ. ");
INSERT INTO bus_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","À agbaa kpánɛ. Lapatana kↄ̃n lougbɛ kɛ̀kiio mↄ̀ lɛ. Mɛ́ a gbarɛ sa, mɛ́ gíare dↄro. ");
INSERT INTO bus_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa bènɛ: Tó ma bↄ wɛ́tɛ kpɛɛ, mɛ́ ma ↄↄnↄ dↄ Dii kúkiia, lapatana é zɛ, lougbɛ é yãa, lɛ ǹgↄ̃ dↄ̃ kɛ̀ tↄↄtɛ nɛ́ Dii pↄ́mɛ. ");
INSERT INTO bus_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Mↄde má dↄ̃ kɛ̀ mpi kↄ̃n n ìbanↄ, ée vĩa kɛɛ Dii Ludanɛro ai tia. ");
INSERT INTO bus_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Nagã kↄ̃n gbadoo yàka, zaakɛ nagãa gĩakɛ à pìa, gbado mↄree bↄ̀. ");
INSERT INTO bus_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ése kↄ̃n weaao e yakaro kɛ̀ aↄ̃è ma zãa yãnzi. ");
INSERT INTO bus_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Musa bↄ̀ Fili'auna kiia à gàa wɛ́tɛ kpɛɛ à a ↄↄnↄ dↄ̀ Dii kúkiia, ben lapatana kↄ̃n lougbɛo zɛ̀, lou e ma dↄro. ");
INSERT INTO bus_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Kɛ̀ Fili'auna è lou kↄ̃n lougbɛo kↄ̃n lapatanao zɛ̀, ben à kpɛ́ èe durun kɛɛ, à swã kpɛ́ gbãa, àpi kↄ̃n a ìbanↄ. ");
INSERT INTO bus_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","À kù kpɛ́ gbãa à gì Isarailinↄ gbarɛzi lán Ludaa dà Musanɛ à ònɛ nà. ");
INSERT INTO bus_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Dii bè Musanɛ: Ǹ gá Fili'auna kiia, zaakɛ ma à kùgbãa kũ̀ kↄ̃n à ìbanↄ, lɛ mà a dabuyã kɛ̀kiinↄ kɛ ń tɛ́, ");
INSERT INTO bus_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","lɛ ǹ e ǹ o n nɛ́nↄnɛ kↄ̃n n dionↄ lán ma wɛ́ɛ tã̀ Igipitinↄa nà kↄ̃n dabuyã kɛ̀ má kɛ̀ ń tɛ́nↄ, àgↄ̃ dↄ̃ kɛ̀ mámbe Dii ũ. ");
INSERT INTO bus_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ben Musa kↄ̃n Arunao gàa wà bè Fili'aunanɛ: Dii Eberunↄ Luda bè nɛ́gↄ̃ kuu mìsiɛnaare sai ai bↄrɛmɛ? Ǹ a gbɛ̃nↄ gbarɛ aↄ̃ gá dↄnzi kɛare. ");
INSERT INTO bus_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Tó n gi ń gbarɛzi, zia eé sutɛ̃nↄ ká n bùsun. ");
INSERT INTO bus_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Aↄ̃é da tↄↄtɛla, weé guu ero. Aↄ̃é lɛ́ɛ pↄ́ kɛ̀ gↄ̃̀nnɛ lougbɛ gbɛraanↄa kↄ̃n línↄ píngi. ");
INSERT INTO bus_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Aↄ̃é pa n kpɛ́nↄ guu kↄ̃n n ìbanↄ pↄ́nↄ kↄ̃n Igipitinↄ pↄ́nↄ píngi. N denↄ kↄ̃n n dezinↄ e à taka e zikiro zaa gurↄↄ kɛ̀ aↄ̃ vɛ̃̀ɛ bùsu kɛ̀n ai mↄna gbã̀a. Ben Musa lìara à bↄ̀ Fili'auna kiia. ");
INSERT INTO bus_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Fili'auna ìbanↄ bènɛ: Gbɛ̃ pìnↄ égↄ̃ mↄ́nzi kpaawazi lɛ ai bↄrɛmɛ? Ǹ gbɛ̃ pìnↄ gbarɛ aↄ̃ gá dↄnzi kɛ Dii ń Ludanɛ. Ń dↄ̃ kɛ̀ Igipiti kàatɛroo? ");
INSERT INTO bus_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ben wà ɛ̀ara wà sù kↄ̃n Musao kↄ̃n Arunao Fili'auna kiia, à bèńnɛ: À gá dↄnzi kɛ Dii a Ludanɛ. A dénↄ bé wé gáa? ");
INSERT INTO bus_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa wèàla à bè: Nɛ́ féte gbɛ̃nsi. Wé gá wa píngimɛ kↄ̃n wa nɛ́gↄ̃gbɛ̃nↄ kↄ̃n wa nɛ́nↄgbɛ̃nↄ kↄ̃n wa sãanↄ kↄ̃n wa blènↄ kↄ̃n wa zùnↄ, zaakɛ Dii zĩbaan wée gaa kɛ. ");
INSERT INTO bus_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Ben à bèńnɛ: Tó ma a gbarɛ kↄ̃n a nↄgbɛ̃nↄ kↄ̃n a nɛ́nↄ a píngi, ásarumɛ, Dii a bↄ! À làakari kɛ! Ée wɛtɛɛ à fɛ̃maomɛ. ");
INSERT INTO bus_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Auo! A gↄ̃gbɛ̃nↄ bé wé gá dↄnzi kɛ Diinɛ, zaakɛ lɛn á gbèka lɛ. Ben wà pɛ̀ḿma Fili'auna aɛzĩ. ");
INSERT INTO bus_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Dii bè Musanɛ: Ǹ n ↄↄ dↄ Igipiti bùsula, sutɛ̃nↄ é ká wà sɛ̃̀ kↄ̃n lá kɛ̀ bↄ̀ɛ lougbɛ gbɛraanↄ ble píngi. ");
INSERT INTO bus_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Kɛ̀ Musa a gò dↄ̀ Igipitila, Dii bↄ̀ kↄ̃n ĩao ↄfãntɛ̃bↄɛ kpa, èe paa bùsu pìa fãantɛ̃ kↄ̃n gwãavĩo zɛna sai. Kɛ guu dↄ̀, ↄfãntɛ̃bↄɛ ĩa pì sù kↄ̃n sutɛ̃nↄ. ");
INSERT INTO bus_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ben sutɛ̃ pìnↄ mↄ̀ wà dà Igipiti bùsula píngi. Aↄ̃ↄ pari dɛ à yã pↄ́nↄla, à taka é kɛ ziki dↄro. ");
INSERT INTO bus_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Aↄ̃ dà tↄↄtɛla gu píngi, ben tↄↄtɛ sia kũ̀. Aↄ̃ sɛ̃̀ kↄ̃n lánↄ kↄ̃n líbɛɛ kɛ̀ bↄ̀ lougbɛ gbɛraanↄ blè píngi. Sɛ̃̀ kↄ̃n láo kú Igipiti bùsun dↄro. ");
INSERT INTO bus_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Gwe gↄ̃ↄ Fili'auna Musa kↄ̃n Arunao sìsi à bè: Ma durun kɛ̀ Dii a Ludanɛ kↄ̃n apinↄ. ");
INSERT INTO bus_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","À sùu gɛ̃̀n doo kɛ̀kii kɛmɛ kↄ̃n ma durun-o à agbaa kpámɛ Dii a Ludanɛ à gagana kɛ̀kii kɛ̃ma. ");
INSERT INTO bus_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Kɛ̀ à bↄ̀ Fili'auna kiia, à agbaa kpà Diinɛ. ");
INSERT INTO bus_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ben Dii bↄ̀ kↄ̃n ĩa gbãaao ↄfãntɛ̃gɛ̃kpɛn kpa, à mↄ̀ à sutɛ̃nↄ sɛ̀ɛ à kà Isia Tɛ̃aan. Baa sutɛ̃ mɛ̀n doo e gↄ̃ Igipiti dↄro. ");
INSERT INTO bus_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Mↄde Dii Fili'auna kù kɛ̀ gbãa, ben à gì Isarailinↄ gbarɛzi. ");
INSERT INTO bus_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Dii bè Musanɛ: Ǹ ↄ sɛ́ musu, gusiaa kɛ̀ weé fↄ̃ wà ↄ kɛa é da Igipitila. ");
INSERT INTO bus_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Kɛ̀ Musa a ↄↄ dↄ̀ musu, ben gusia níginigi dà Igipiti gu píngia ai gurↄ aagↄ̃. ");
INSERT INTO bus_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Wè kↄ̃ ero, gbɛ̃kee e gu a gbɛ̀nlo ai gurↄ aagↄ̃ↄ pìa. Mↄde gupuraa kú guu kɛ̀ Isarailinↄↄ kún píngi. ");
INSERT INTO bus_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ben Fili'auna Musa sìsi à bè: À gá dↄnzi kɛ Diinɛ kↄ̃n a nↄgbɛ̃nↄ kↄ̃n a nɛ́nↄ a píngi, mↄde à a sãanↄ kↄ̃n a blènↄ kↄ̃n a zùnↄ tó. ");
INSERT INTO bus_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Musa bè: Ǹ tó wàgↄ̃ wa sa'opↄnↄ kↄ̃n sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũnↄ kũna, lɛ wà e wà Dii wa Luda gbãgbão. ");
INSERT INTO bus_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Séto wà gá kↄ̃n wa pↄ́kãdeenↄ, baa mɛ̀n doo é gↄ̃ro, zaakɛ aↄ̃ tɛ́n wé sa'opↄnↄ bↄn wà Dii wa Luda gbãgbão. Lɛ wà kpɛ́ wà ká gwe, wá dↄ̃ pↄ́ kɛ̀ wé sɛ́ wà saa ooa gĩaro. ");
INSERT INTO bus_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Dii Fili'auna kùgbãa kũ̀, èe we à ń gbarɛro. ");
INSERT INTO bus_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Fili'auna bè Musanɛ: Ǹ gu ma aɛ! Ǹton tó wa wɛ́ɛ kɛ siigↄ̃ dↄro. Zĩ kɛ̀ wa wɛ́ɛ sìkↄ̃lɛ, n gamɛ. ");
INSERT INTO bus_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Ben Musa bè: Lán ń ò nà, nɛ́ wɛ́ɛ simalɛ dↄro. ");
INSERT INTO bus_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Àɛ sↄ̃ Dii gĩakɛ à bè Musanɛ: Mɛ́ ĩa da Fili'aunaa kↄ̃n Igipiti bùsuo gɛ̃̀n do dↄ, eé gbasa à a gbarɛ. Tó èe a gbarɛɛ, eé pɛ́awamɛ! ");
INSERT INTO bus_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ǹ o gbɛ̃nↄnɛ aↄ̃ baade gↄ̃gbɛ̃ kↄ̃n nↄgbɛ̃o kondogi pↄ́nↄ kↄ̃n vura pↄ́nↄ gbeka a Igipiti gbɛ̃daaaa. ");
INSERT INTO bus_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Mɛ́ tó Isarailinↄ kɛ Igipitinↄo nna. Musa sↄ̃ ègↄ̃ bɛ̀ɛ vĩ Igipiti guu Fili'auna ìbanↄnɛ kↄ̃n a gbɛ̃nↄ. ");
INSERT INTO bus_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ben Musa bè Fili'aunanɛ: Dii bè gwãavĩ lezãndo é ba Igipiti bùsula, ");
INSERT INTO bus_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Igipiti daudunↄ é gaga ń píngi sɛna zaa Fili'auna kɛ̀ vɛ̃ɛna kpatan nɛ́a ai à gàa pɛ́ nↄgbɛ̃ zĩkɛri kɛ̀ aↄ̃è wísi lↄ́nↄ nɛ́a kↄ̃n pↄ́kãde nɛ́kya káakunↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Weé sósobi ↄ́ gbãaa dↄ Igipiti gu píngia, à taka e kɛ yãro, eé kɛ ziki dↄro. ");
INSERT INTO bus_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Mↄde Isarailinↄ tɛ́ baa gbɛ̃ é gbon kɛ gbɛ̃ntee ke pↄ́kãdeearo, lɛ ǹgↄ̃ dↄ̃ kɛ̀ Dii Igipitinↄ dↄ̃kↄ̃zi kↄ̃n Isarailinↄ. ");
INSERT INTO bus_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","N ìba kɛ̀kiinↄ é mↄ́ ma kiia ń píngi aↄ̃é kúɛmɛ, aↄ̃é be mà gá kↄ̃n ma gbɛ̃nↄo ń píngi. Beee gbɛra sa mɛ́ gá. Ben Musa bↄ̀ Fili'auna kiia kↄ̃n pↄfɛ̃ bítao. ");
INSERT INTO bus_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Dii bè Musanɛ yã: Fili'auna é n yã maro, lɛ ma dabuyãkɛnanↄ e à pari kũ Igipiti. ");
INSERT INTO bus_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa kↄ̃n Arunao dabuyã pìnↄ kɛ̀ Fili'auna aɛ píngi, ben Dii à kùgbãa kũ̀. À gì Isarailinↄ gbarɛzi aↄ̃ bↄ a bùsun. ");
INSERT INTO bus_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Dii yã ò Musanɛ kↄ̃n Arunao Igipiti à bè: ");
INSERT INTO bus_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Mↄↄ kɛ̀kii égↄ̃ dɛare mↄ káaku ũ wɛ̃̀ kↄ̃n wɛ̃̀o. ");
INSERT INTO bus_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","À o Isarailinↄnɛ ń píngi, mↄↄ kɛ̀ki gurↄ kuridee zĩ aↄ̃é sãa bↄbↄ mɛ̀n doodo ualɛ kↄ̃n ualɛo píngi. ");
INSERT INTO bus_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Tó ua gbɛ̃nↄ parii e ká aↄ̃ sã mɛ̀n doo só sↄ̃ro, aↄ̃ kpaatɛ kↄ̃n ua kɛ̀ aↄ̃ↄ kú kↄ̃ saɛo à gbɛ̃nↄ lɛ́n, lɛ a kpaaa tón gↄ̃ro yãnzi. ");
INSERT INTO bus_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","À sãkaro ke blèkofĩi nɛ́ bↄ̀rↄ kɛ̀ see vĩroo bↄ. ");
INSERT INTO bus_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Isarailinↄ píngi, baade a pↄ́ gwa ai mↄↄ kɛ̀ki gurↄ gɛ̃ro dosaidee zĩ. Uusiɛn weé dɛ, ");
INSERT INTO bus_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","weé à aru ma kpɛ́ kɛ̀ weé à nↄ̀bↄ són kpɛɛlɛ gũ̀nↄa ↄplazi kↄ̃n ↄzɛzio kↄ̃n musuo. ");
INSERT INTO bus_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Gwãavĩ dↄ̃nkↄ̃ pìa weé nↄ̀bↄ pì kpá tɛ́a, weé só kↄ̃n burɛdi sɛ́sɛ'ɛ̃zɛ̃saio kↄ̃n lá kyã̀kyão. ");
INSERT INTO bus_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Àton só búsu ke fùfukɛnaro. À kpá tɛ́a kↄ̃n a mìo kↄ̃n a gbánↄ kↄ̃n a pↄ́guunↄ. ");
INSERT INTO bus_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Àton tó guu dↄ à kpaaaaro. Tó à kpaaa gↄ̃̀, à kpáta à tɛ́ kũ. ");
INSERT INTO bus_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Tó ée soo, à asaa dↄawa à kyatee kpá, a gò gↄ̃ nana a ↄzĩ. À só kpakpaa, zaakɛ Dii Banla sa'opↄmɛ. ");
INSERT INTO bus_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Gwãavĩ pìa mɛ́ ba Igipitila mà daudunↄ dɛdɛ bùsu pì gu píngia kↄ̃n pↄ́kãde nɛ́kya káakunↄ ń píngi, mɛ́ wí da Igipiti tãanↄa. Mámbe Dii ũ. ");
INSERT INTO bus_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Aru pì égↄ̃ dɛ sèeda ũ kpɛ́ kɛ̀ á kú à guunↄa. Tó mɛ́ɛ ↄ tↄ̃ↄ Igipitinↄa, tó ma aru pì è, mɛ́ gɛ̃ala, gagana pì é a lero. ");
INSERT INTO bus_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","À gurↄↄ pì diɛ ma zĩbaa gurↄↄ ũ dↄngu yãnzi, àgↄ̃ zĩbaa pì kɛɛ kɛ̀atokↄ̃nɛpↄ ũ ai a boriia. ");
INSERT INTO bus_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Gurↄ swɛɛplaaa guu à burɛdi sɛ́sɛ'ɛ̃zɛ̃sai só. À gurↄ káakudee zĩ à burɛdisɛsɛ'ɛ̃zɛ̃ kɛ̀ kú a kpɛ́ guunↄ kwɛ́ɛ, zaakɛ gbɛ̃ kɛ̀ pↄ́sɛsɛna sò gurↄ swɛɛplaaa pì guu, weé a bↄ Isarailinↄ tɛ́ wà à dɛmɛ. ");
INSERT INTO bus_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","À gurↄ káakudee zĩ kↄ̃n à gurↄ swɛɛplaadeeo à kↄ̃ kakↄ̃a à dↄnzi kɛmɛ. Àton zĩi ke kɛ gurↄↄ mↄ̀nↄaro, sé pↄ́blekɛna baade pínginɛ baasiro, à lɛ́n gwe. ");
INSERT INTO bus_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","À Burɛdi Sɛ́sɛ'ɛ̃zɛ̃sai zĩbaa kɛ, zaakɛ zĩ beeean ma a bↄɛ Igipiti lán zĩ̀kpɛɛnↄ bà. A boriinↄ gↄ̃ zĩbaa pì kɛɛ kɛ̀atokↄ̃nɛpↄ ũ. ");
INSERT INTO bus_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Mↄ káaku gurↄ gɛ̃ro dosaidee zĩ uusiɛ, àgↄ̃ burɛdi sɛ́sɛ'ɛ̃zɛ̃sai soo ai à gurↄ baro awɛɛdodee zĩ uusiɛ. ");
INSERT INTO bus_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Gurↄ swɛɛplaaa guu burɛdisɛsɛ'ɛ̃zɛ̃ tón gↄ̃ kú a bɛro, zaakɛ gbɛ̃ kɛ̀ pↄ́sɛsɛna sò, gbɛ̃ zĩ̀tↄn yoo, bɛdeen yoo, weé à bↄ Isarailinↄ tɛ́ wà à dɛmɛ. ");
INSERT INTO bus_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Àton pↄ́sɛsɛna só gurↄ pìaro. Guu kɛ̀ á kún píngi, àgae burɛdi sɛ́sɛ'ɛ̃zɛ̃sai só. ");
INSERT INTO bus_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Musa Isaraili gbɛ̃nsinↄ sìsi ń píngi à bèńnɛ: À gá à a ua sã kũ à dɛ Banla zĩbaakɛpↄ ũ. ");
INSERT INTO bus_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","À sɛ̃̀sↄ̃vlãa sɛ́ à zↄ̃ aru kɛ̀ kú taa guua à máma a kpɛɛlɛ gũ̀a, ↄplazi kↄ̃n ↄzɛzio kↄ̃n à musuo. A gbɛ̃ke tón bↄ bàaziro ai guu dↄ. ");
INSERT INTO bus_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Tó Dii e baa bùsula èe Igipitinↄ dɛdɛɛ, tó à aru è kpɛɛlɛ gũ̀nↄa, eé gɛ̃àlamɛ. Eé tó gbɛ̃dɛdɛri gɛ̃azi à a dɛdɛro. ");
INSERT INTO bus_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Apinↄ kↄ̃n a boriinↄ àgↄ̃ yã pì kũna kɛatokↄ̃nɛpↄ ũ ai a boriia. ");
INSERT INTO bus_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Tó a gɛ̃ bùsu kɛ̀ Dii é a gbaan lán à à lɛ́ gbɛ̃̀are nà, àgↄ̃ dↄnziyã pì kũna. ");
INSERT INTO bus_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Tó a nɛ́nↄ dↄnziyã pì mì gbèkaawa, ");
INSERT INTO bus_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","à ońnɛ kɛ̀ Banla saa kɛ̀ wè o Diiamɛ, zaakɛ kɛ̀ à Igipitinↄ dɛ̀dɛ, à gɛ̃̀ wa Isarailinↄ kpɛ́la, èe wa dɛdɛro. Ben gbɛ̃nↄ kùɛ aↄ̃ dↄnzi kɛ̀ Diinɛ. ");
INSERT INTO bus_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Kɛ̀ aↄ̃ tà, aↄ̃ↄ kɛ̀ lán Dii ò Musa kↄ̃n Arunaonɛ nà. ");
INSERT INTO bus_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Gwãavĩ lezãndo Dii Igipiti daudunↄ dɛ̀dɛ ń píngi, naana zaa Fili'auna kɛ̀ vɛ̃ɛna kpatan nɛ́a ai à gàa pɛ́ pisinanↄ nɛ́nↄa kↄ̃n pↄ́kãde nɛ́kya káakunↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Fili'auna fɛ̀ɛ gwãavĩ kↄ̃n a ìbanↄ kↄ̃n Igipitinↄ ń píngi, ben sósobi ↄ́ dà Igipitila, zaakɛ ua kee kuu gɛ̀ sairo. ");
INSERT INTO bus_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Gwãavĩn Fili'auna Musa kↄ̃n Arunao sìsi à bèńnɛ: À fɛɛ kↄ̃n Isarailinↄ à bↄɛ ma gbɛ̃nↄ tɛ́. À gá dↄnzi kɛ Diinɛ lán á ò nà. ");
INSERT INTO bus_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","À a blènↄ kↄ̃n a sãanↄ kↄ̃n a zùnↄ sɛ́ɛ lán á ò nà. À gá à sa maaa omɛ se. ");
INSERT INTO bus_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Igipitinↄ nàkↄ̃rɛ gbɛ̃ pìnↄa aↄ̃ bↄɛńnɛ ń bùsun kpakpaa, zaakɛ aↄ̃ bè: Wé gaga wa píngimɛ. ");
INSERT INTO bus_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Isarailinↄ ń flawadɛnanↄ kà taanↄ guu a sɛ́sɛ'ɛ̃zɛ̃ sai, aↄ̃ ń utanↄ fĩ̀fĩa aↄ̃ↄ dàda ń gã̀n. ");
INSERT INTO bus_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Aↄ̃ↄ kɛ̀ lán Musa òńnɛ nà, aↄ̃ kondogi pↄ́nↄ kↄ̃n vura pↄ́nↄ kↄ̃n pↄ́kãsãanↄ gbèka Igipitinↄa. ");
INSERT INTO bus_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Dii tò aↄ̃ↄ kɛ̀ kↄ̃o nna, ben aↄ̃ↄ kpàḿma. Lɛmɛ aↄ̃ Igipitinↄ pↄ́nↄ sìḿma lɛ. ");
INSERT INTO bus_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Isarailinↄↄ dà zɛ́n kɛ̀sɛ, aↄ̃ bↄ̀ɛ kↄ̃n Ramɛsɛo aↄ̃ tà Suko. Gↄ̃gbɛ̃nↄ gↄ̃ↄn bↄrↄ wàa aagↄ̃mɛ, nɛ́nↄ kↄ̃n nↄgbɛ̃nↄ baasi. ");
INSERT INTO bus_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Bori zĩ̀tↄnↄ tàńyo pari dↄ. Blènↄ kↄ̃n sãanↄ kↄ̃n zùnↄ parii kɛ̀ bíta. ");
INSERT INTO bus_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Aↄ̃ burɛdi sɛ́sɛ'ɛ̃zɛ̃sai kɛ̀ kↄ̃n flawadɛna kɛ̀ aↄ̃ bↄ̀o Igipitio. Aↄ̃ↄ kɛ̀ sɛ́sɛ'ɛ̃zɛ̃ sai, zaakɛ wà pɛ̀ḿma Igipiti kãndomɛ. Aↄ̃ↄe e wà pↄ́blee kɛ̀ wà sɛ̀ kũsãɛ ũro. ");
INSERT INTO bus_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Isarailinↄ kuuna Igipiti kɛ̀ wɛ̃̀ wàa plaa kↄ̃n baaakurio. ");
INSERT INTO bus_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Wɛ̃̀ wàa plaa kↄ̃n baaakurio pì papana gbɛra, zĩbaa pì zĩn Dii zĩ̀kpɛɛ pìnↄ bↄ̀ɛ Igipiti ń píngi. ");
INSERT INTO bus_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Gwãavĩ pì nɛ́ Dii pↄ́mɛ. Isarailinↄ égↄ̃ a itɛ̃ kɛɛ ai ń boriia, zaakɛ gwãavĩ pìn Dii Isarailinↄ bↄna Igipiti itɛ̃ kɛ̀. ");
INSERT INTO bus_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Dii bè Musanɛ kↄ̃n Arunao: Banla yã kɛ̀ má dìɛn yɛ̀. Bori zĩ̀tↄ ke toga à à nↄ̀bↄ sóro, ");
INSERT INTO bus_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","mↄde zↄ̀ kɛ̀ á lù, tó à bã̀ngu kɛ̀, eé só. ");
INSERT INTO bus_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Nibↄ ke asaiazĩkɛri toga à sóro. ");
INSERT INTO bus_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","À só kpɛ́n, àton bↄ kↄ̃n à nↄ̀bↄ pìo bàaziro. Àton sãa pì wá ke ɛ́ro. ");
INSERT INTO bus_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Isarailinↄ píngi gae zĩbaa pì kɛ. ");
INSERT INTO bus_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Tó gbɛ̃ zĩ̀tↄ kú a tɛ́, tó à yezi à Banla zĩbaa kɛ Diinɛ, à a bɛ gↄ̃gbɛ̃nↄ bã̀ngu kɛ ń píngi à gↄ̃ bɛdee ũ, eé gbasa à kɛ. Gɛfↄↄdee toga à sóro. ");
INSERT INTO bus_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Bɛde kↄ̃n gbɛ̃ zĩ̀tↄ kɛ̀ kúao, doka dↄ̃nkↄ̃ pìmɛ. ");
INSERT INTO bus_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Ben Isarailinↄↄ kɛ̀ lán Dii ò Musa kↄ̃n Arunaonɛ nà ń píngi. ");
INSERT INTO bus_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Zĩ beeean Dii Isarailinↄ bↄ̀ɛ Igipiti gãli kↄ̃n gãlio. ");
INSERT INTO bus_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Dii yã ò Musanɛ à bè: ");
INSERT INTO bus_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Àgae Isaraili daudunↄ kↄ̃n pↄ́kãde nɛ́kya káakunↄ kpáma, zaakɛ ma pↄ́nↄmɛ ń píngi. ");
INSERT INTO bus_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Musa bè gbɛ̃nↄnɛ: A bↄna Igipiti zↄ̀blenan gurↄↄ kɛ̀ki yã gↄ̃ dↄagu, zaakɛ Dii bé à a bↄɛ Igipiti kↄ̃n a ↄ gbãaao. Àton pↄ́sɛsɛna só gurↄↄ pìaro. ");
INSERT INTO bus_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ée bↄɛɛ Igipiti gbã̀amɛ mↄ káaku kɛ̀ wè sísi Abibu guu. ");
INSERT INTO bus_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Dii lɛ́ gbɛ̃̀ a dezinↄnɛ à bè é bùsu kɛ̀ zwi kↄ̃n zↄ́'io din, kɛ̀ Kanaanↄ kↄ̃n Itinↄ kↄ̃n Amↄrinↄ kↄ̃n Ivinↄ kↄ̃n Yebusinↄↄ kún kpáawa. Tó à tò a ka, à zĩbaa pì kɛ mↄↄ kɛ̀kiin. ");
INSERT INTO bus_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Àgae burɛdi sɛ́sɛ'ɛ̃zɛ̃sai só ai gurↄ swɛɛplaa. À gurↄ swɛɛplaadee pì zĩ égↄ̃ dɛare Dii zĩbaa gurↄↄ ũ. ");
INSERT INTO bus_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Àgae burɛdi sɛ́sɛ'ɛ̃zɛ̃sai só ai gurↄ swɛɛplaaa pì papa. Pↄ́sɛsɛna ke burɛdi ɛ̃zɛ̃ ke tóngↄ̃ kú ua ke guu a bùsunlo. ");
INSERT INTO bus_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Zĩ pìa àgae o a nɛ́gↄ̃gbɛ̃nↄnɛ ée kɛɛ lɛ yã kɛ̀ Dii kɛ̀are kɛ̀ à a bↄɛ Igipiti yãnzimɛ. ");
INSERT INTO bus_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Zĩbaa pì égↄ̃ dɛare sèeda ũ lán pↄ́ dana ↄↄa bà, ke lán dↄngu pↄ́ yina mì'aɛa bà, lɛ Dii doka gↄ̃ kú a lɛ́n, zaakɛ àmbe à a bↄɛ Igipiti kↄ̃n a ↄ gbãaao. ");
INSERT INTO bus_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Àgae dokayã pì kɛ a gurↄↄa wɛ̃̀ kↄ̃n wɛ̃̀o. ");
INSERT INTO bus_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Tó Dii tò a ka Kanaa bùsun, ben à kpàawa lán à à lɛ́ gbɛ̃̀are nà kↄ̃n a dezinↄ, ");
INSERT INTO bus_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","àgae a daudunↄ kpáa ń píngi. A pↄ́kãde nɛ́kya káakunↄ ègↄ̃ dɛ à pↄ́ ũ ń píngi. ");
INSERT INTO bus_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Àgae a zaaki nɛ́kya káaku tↄↄba bo kↄ̃n sãnɛo. Tó ée boro, à à waa fĩ. Àgae a daudunↄ tↄↄba bo ń píngi. ");
INSERT INTO bus_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Tó a nɛ́gↄ̃gbɛ̃nↄ a la à mìzi zia wà bè, bↄ́ yãn gwee, à beńnɛ kɛ̀ Dii a bↄɛ zↄ̀bleen Igipiti yã kↄ̃n a ↄ gbãaao yãnzimɛ. ");
INSERT INTO bus_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Kɛ̀ Fili'auna kùgbãaa kɛ̀ à gì wa gbarɛzi, ben Dii Igipiti daudunↄ dɛ̀dɛ ń píngi kↄ̃n pↄ́kãde nɛ́kya káakunↄ ń píngi. Beee yãnzin weè saa oa kↄ̃n pↄ́kãde nɛ́kya káakunↄzi píngi, weè wa daudunↄ tↄↄba bo. ");
INSERT INTO bus_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Kɛ̀kii égↄ̃ dɛ sèeda ũ lán pↄ́ dana wa ↄↄa bà ke pↄ́ yina wa mì'aɛa bà, zaakɛ Dii bé à wa bↄɛ Igipiti kↄ̃n a ↄ gbãaao. ");
INSERT INTO bus_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Kɛ̀ Fili'auna Isarailinↄ gbàrɛ, Luda e bↄńyo Filisitininↄ bùsu zɛ́ kparo, baa kↄ̃n à kĩkɛɛo, zaakɛ à bè: Tó wà fɛ̀ɛńzi kↄ̃n zĩ̀o, aↄ̃é ń nↄ̀sɛ liɛ wà liara Igipiti. ");
INSERT INTO bus_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Luda pã̀ zɛ́ pìnɛ, ben à gbáa zɛ́ sɛ̀ńyo Isia Tɛ̃aa kpa. Isarailinↄ bↄ̀ɛ Igipiti aↄ̃ ń gↄ̃kɛbↄnↄ kũna. ");
INSERT INTO bus_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa Yusufu wánↄ sɛ̀ èe taao, zaakɛ Yusufu tò Isarailinↄ lɛ́ gbɛ̃̀are yã à bè, tó Luda mↄ̀ ń bↄ, aↄ̃é a wánↄ sɛ́ɛ wà bↄo gwe. ");
INSERT INTO bus_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Kɛ̀ aↄ̃ bↄ̀ Suko, aↄ̃ gàa wà bùra kàɛ gbáa lɛ́a zaa Etamu. ");
INSERT INTO bus_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Dii ègↄ̃ dↄↄńnɛ aɛ tɛ́luguu guu fãantɛ̃ lɛ àgↄ̃ zɛ́ ↄdↄↄańnɛ. Gwãavĩ sↄ̃ ègↄ̃ dↄↄńnɛ aɛ tɛ́nɛnɛ guu, lɛ àgↄ̃ guu puuńnɛ aↄ̃gↄ̃ táa oo fãantɛ̃ kↄ̃n gwãavĩo. ");
INSERT INTO bus_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Tɛ́luguu pì è gu ń aɛ fãantɛ̃ro, tɛ́nɛnɛ pì è gu ń aɛ gwãavĩro. ");
INSERT INTO bus_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Dii bè Musanɛ: ");
INSERT INTO bus_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Ǹ o Isarailinↄnɛ aↄ̃ ɛara wà gá bùra káɛ Pi'airo saɛ Migidolu kↄ̃n ísiaao dagura, aɛdↄkↄ̃ana kↄ̃n Baali Zɛfↄ̃o. À bùra káɛ ísiaa saɛ gwe. ");
INSERT INTO bus_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Fili'auna égↄ̃ daa a sãsã, gbáa a kũmɛ. ");
INSERT INTO bus_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Mɛ́ a kùgbãa kũ, eé pɛɛazi, mɛ́ tↄ́ bↄ Fili'auna kↄ̃n a zĩ̀kpɛɛnↄ yã sàabu, Igipitinↄ égↄ̃ dↄ̃ kɛ̀ mámbe Dii ũ. Ben Isarailinↄↄ kɛ̀ lɛ. ");
INSERT INTO bus_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Kɛ̀ wà ò Igipiti kí Fili'aunanɛ gbɛ̃ pìnↄ bàa lɛ̀, ben àpi kↄ̃n a ìbanↄ nↄ̀sɛ lìɛ Isarailinↄ yã musu wà bè: Bↄ́n wá kɛ̀, ben wá tò aↄ̃ bↄ̀ zↄ̀blenaween? ");
INSERT INTO bus_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Ben Fili'auna góro dↄ̀ a sↄ̃nɛ à a zĩ̀kpɛɛnↄ kàkↄ̃a. ");
INSERT INTO bus_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","À sↄ̃goro maaanↄ sɛ̀ mɛ̀n wàa aagↄ̃ kↄ̃n Igipiti sↄ̃goronↄ píngi kↄ̃n zĩ̀kari gbɛ̃nsinↄo ká ń guu. ");
INSERT INTO bus_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Dii Igipiti kí Fili'auna kùgbãa kũ̀, ben à pɛ̀ɛ Isaraili kɛ̀ aↄ̃ↄe bↄɛɛ kↄ̃n kùgbãaaonↄzi. ");
INSERT INTO bus_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Ben Igipitinↄ pɛ̀ɛńzi kↄ̃n Fili'auna sↄ̃nↄ kↄ̃n à sↄ̃goronↄ kↄ̃n à sↄ̃deenↄ kↄ̃n à zĩ̀kpɛɛnↄ ń píngi, ben aↄ̃ↄe mↄↄ ń le ń bùran ísiaa saɛ kĩi kↄ̃n Pi'airoo aɛdↄkↄ̃ana kↄ̃n Baali Zɛfↄ̃o. ");
INSERT INTO bus_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Kɛ̀ Fili'auna kà kĩi, Isarailinↄ wɛ́ɛ sɛ̀, ben aↄ̃ Igipitinↄ è tɛ́ ń kpɛɛ. Vĩa ń kũ maamaa, ben aↄ̃ wii pɛ̀ Diizi. ");
INSERT INTO bus_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Aↄ̃ bè Musanɛ: Miranↄↄ kú Igipitinloo? Bↄ́yãnzi n mↄwao gbáan kɛ̀ wà gagazi? À kɛ̀ dia n bↄwao Igipiti? ");
INSERT INTO bus_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Asa wá ònnɛ Igipiti wà bè ǹ wa tó tɛɛɛ wà zↄ̀ ble Igipitinↄnɛ! Zↄ̀blenańnɛ maawe dɛ gagana gbáa kɛ̀nla. ");
INSERT INTO bus_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa bèńnɛ: Àton tó vĩa a kũro. À zɛ tɛɛɛ é e lán Dii é a mì sí nà gbã̀a, zaakɛ Igipiti kɛ̀ ée ń ee gbã̀a kɛ̀nↄ, é ń e ziki dↄro. ");
INSERT INTO bus_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Dii bé eé zĩ̀ káare. Àgↄ̃ yĩtɛna kítikiti dé! ");
INSERT INTO bus_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Dii Musa là à bè: Bↄ́ wiiin nɛ́ɛ pɛɛmazii? Ǹ o gbɛ̃nↄnɛ aↄ̃ fɛɛ wà bↄ kↄ̃n táo. ");
INSERT INTO bus_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ǹ n gò dↄ ísiaala à zↄ̃kↄ̃rɛ, lɛ Isarailinↄ e wà gɛ̃tɛ à dagura gukoria. ");
INSERT INTO bus_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Mapi, mɛ́ Igipitinↄ kùgbãa kũ, aↄ̃é gɛ̃n ń gbɛra, mɛ́ tↄ́ bↄ Fili'auna kↄ̃n a zĩ̀kpɛɛnↄ kↄ̃n a sↄ̃goronↄ kↄ̃n a sↄ̃deenↄ yã sàabu. ");
INSERT INTO bus_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Tó ma tↄ́ bↄ̀ Fili'auna kↄ̃n a sↄ̃goronↄ kↄ̃n a sↄ̃deenↄ yã sàabu, Igipitinↄ égↄ̃ dↄ̃ sa kɛ̀ mámbe Dii ũ. ");
INSERT INTO bus_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Luda Malaika kɛ̀ dↄ Isarailinↄnɛ aɛ lìara à gàa ń kpɛɛ kpa, ben tɛ́luguu kɛ̀ kú ń aɛ lìara à gàa ń kpɛɛ dↄ ");
INSERT INTO bus_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","aↄ̃pinↄ kↄ̃n Igipitinↄ dagura. Tɛ́luguu pì guu pù Isarailinↄnɛ à gusiaa kpà Igipitinↄnɛ, ben aↄ̃ gbɛ̃kee e e à sↄ̃̀ a daazi gwãavĩ beeearo. ");
INSERT INTO bus_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Kɛ̀ Musa a ↄↄ dↄ̀ ísiaala, ben Dii bↄ̀ kↄ̃n ĩa gbãaao ↄfãntɛ̃bↄɛ kpa. À kàka ai guu gàa dↄ̀o à ísiaa lɛ̀ à kpàatɛkↄ̃rɛ, ben gukori bↄ̀. Kɛ̀ í zↄ̃̀kↄ̃rɛ, ");
INSERT INTO bus_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ben Isarailinↄ táa ò gukoria aↄ̃ bikũ̀. Í bĩi bò aↄ̃ ↄplaazi kↄ̃n ↄzɛzio. ");
INSERT INTO bus_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ben Igipitinↄ pɛ̀ɛńzi. Fili'auna sↄ̃nↄ kↄ̃n a sↄ̃goronↄ kↄ̃n a sↄ̃deenↄ píngi tɛ́ ń kpɛɛ ísiaa guu. ");
INSERT INTO bus_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Gudↄnao Dii Igipiti zĩ̀kpɛɛnↄ gwà zaa tɛ́nɛnɛ guu, ben à tò aↄ̃ lìkↄ̃a. ");
INSERT INTO bus_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","À tò aↄ̃ sↄ̃goronↄ vlɛ̃̀ɛ, à tò aↄ̃ táa'ona kɛ̀ zĩ'ũ, ben aↄ̃ bè: Wà bàa lɛ́ Isarailinↄnɛ, zaakɛ Dii e zĩ̀ kaawaońnɛmɛ. ");
INSERT INTO bus_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Dii bè Musanɛ: Ǹ n ↄↄ dↄ ísiaala, í é da Igipitinↄla kↄ̃n ń sↄ̃goronↄ kↄ̃n ń sↄ̃deenↄ. ");
INSERT INTO bus_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Ben Musa a ↄↄ dↄ̀ ísiaala, ben í e suu a gbɛ̀n gudↄnao. Lán í e suu nà, ben Igipitinↄ bàa sì aↄ̃ↄ yezi wà bↄɛ. Gwen Dii tò ísiaa dàńlan. ");
INSERT INTO bus_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Í sù a dà sↄ̃goronↄla kↄ̃n sↄ̃deenↄ kↄ̃n Fili'auna zĩ̀kpɛɛ kɛ̀ aↄ̃ gɛ̃̀ ísiaa guu Isarailinↄ gbɛraanↄ ń píngi. Aↄ̃ kee e bↄro, baa mɛ̀n do. ");
INSERT INTO bus_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Isarailinↄ sↄ̃ táa ò í dagura gukoriamɛ. Í bĩi bò aↄ̃ ↄplaazi kↄ̃n ↄzɛzio. ");
INSERT INTO bus_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Zĩ beeean Dii Isarailinↄ sì Igipitinↄa, ben Isarailinↄ Igipiti pìnↄ gɛ̀nↄ è ísiaa baa. ");
INSERT INTO bus_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Kɛ̀ Isarailinↄ Dii gbãa bíta kɛ̀ à mↄ̀ Igipitinↄnɛ è, aↄ̃ vĩa kɛ̀nɛ, ben aↄ̃ à náanɛ kɛ̀ kↄ̃n à zↄ̀bleri Musao. ");
INSERT INTO bus_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ben Musa kↄ̃n Isarailinↄ ń píngi lɛ̀ kɛ̀ sì Diinɛ wà bè: Mɛ́ lɛ̀ sí Diinɛ, zaakɛ à tↄ́ bↄna, à sↄ̃deenↄ kↄ̃n ń sↄ̃nↄ kà ísiaan. ");
INSERT INTO bus_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Dii bé ma gbãaa ũ, mɛ́ lɛ́ maa, àpi bé à ma mì sì. Àmbe ma Luda ũ, mɛ́ à tↄ́ kpá. Àmbe ma de Luda ũ, mɛ́ à tↄ́ sɛ́ lezĩ. ");
INSERT INTO bus_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Dii nɛ́ zĩ̀karimɛ, à tↄ́n Dii. ");
INSERT INTO bus_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","À Fili'auna sↄ̃goronↄ kↄ̃n à zĩ̀kpɛɛnↄ kà ísiaan, à zĩ̀kari gbɛ̃nsinↄ vlɛ̃̀ɛ Isia Tɛ̃aan. ");
INSERT INTO bus_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Í lↄ̀dee pì dàńla, aↄ̃ kpàɛ gĩzĩ lán gbɛ̀ bà. ");
INSERT INTO bus_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Dii, n ↄplaan gbãaa kún kↄ̃n bítakɛɛo, Dii, n n ibɛɛnↄ dúgu zↄ̃̀ kↄ̃n n ↄplaao. ");
INSERT INTO bus_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","N n zangurinↄ nɛ̀ n gakui bíta guu, n pↄ fɛ̃̀ n ń náɛ lán sɛ̃̀ bà. ");
INSERT INTO bus_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","N pↄ́ bↄ̀ n yĩzĩ, ben í zↄ̃̀kↄ̃rɛ, à gↄ̃̀ zɛna lán bĩi bà, ísiaa ì ai a guragura. ");
INSERT INTO bus_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Wa ibɛɛ pìnↄ bè, aↄ̃é pɛ́ɛwazi aↄ̃ wa lemɛ, aↄ̃é wa pↄ́nↄ sɛ́ɛ lán aↄ̃ↄ yezi nà, aↄ̃é ń fɛ̃ɛdaanↄ woto aↄ̃ wa dɛdɛo. ");
INSERT INTO bus_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","N n lɛ́'ĩa vù, ben ísiaa dàńla, aↄ̃ kpàɛ lán beoma bà í bíta pìn. ");
INSERT INTO bus_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Dii, tãanↄ tɛ́ à kparee bé à dɛ lán n bà? Dén weé lɛ́kↄ̃zinyo? Yãbↄnsaɛkɛri, n bítakɛɛ adona, n gakui naasi vĩ. ");
INSERT INTO bus_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","N n ↄplaa pòro, ben tↄↄtɛ ń mↄmↄ. ");
INSERT INTO bus_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Wamↄwa kɛ̀ n wa bo zↄ̀bleennↄ nɛ́ dↄwe aɛ n gbɛ̃kɛɛ guu, nɛ́ gáwao n bùsun kↄ̃n n gbãaao. ");
INSERT INTO bus_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Tó boriinↄ mà, aↄ̃é lugaluga, Filisitini bùsudeenↄ kù égↄ̃ vĩi. ");
INSERT INTO bus_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ɛdↄmunↄ kínanↄ é bídi kɛ, swɛ̃̀ é kɛ̃ Mↄabu dↄn'aɛdeenↄn, Kanaa bùsudeenↄ mɛ̀ é yↄ́ ń píngi. ");
INSERT INTO bus_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Vĩa bíta é ń kũ, swɛ̃̀ é kɛ̃ńgu, aↄ̃é gↄ̃ kítikiti lán gbɛ̀ bà n gbãa bíta yãnzi Dii, ai wamↄwa kɛ̀ n wa sɛ n pↄ́ ũunↄ gɛ̃tɛ. ");
INSERT INTO bus_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Dii, nɛ́ gáwao kpiii kɛ̀ ń sɛ̀ n pↄ́ ũu kiia, nɛ́ wa kãsãa pɛ́ɛ guu kɛ̀ ń dìɛ n vɛ̃ɛkii ũun, n kúkii kɛ̀ ń kɛ̀kɛ n zĩndanɛ pì. ");
INSERT INTO bus_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Dii égↄ̃ kí blee gurↄ píngimɛ. ");
INSERT INTO bus_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Kɛ̀ Fili'auna sↄ̃nↄ kↄ̃n à sↄ̃goronↄ kↄ̃n à sↄ̃deenↄ gɛ̃̀ ísiaa guu, ben Dii sù kↄ̃n ío à dàńla, mↄde Isarailinↄ táa ò gukoria ísiaa pì guu. ");
INSERT INTO bus_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ben annabi Miriamu, Aruna dãre, a sɛ̃gɛ̃sɛ̃gɛ̃ sɛ̀, ben nↄgbɛ̃nↄ bↄ̀ wà tɛ́zi ń píngi, aↄ̃ↄe sɛ̃gɛ̃sɛ̃gɛ̃ paa aↄ̃ↄe ↄ̃ wãa. ");
INSERT INTO bus_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriamu lɛ̀ sìńnɛ à bè: À lɛ̀ sí Diinɛ, zaakɛ à tↄ́ bↄna, à sↄ̃deenↄ kↄ̃n ń sↄ̃nↄ kà ísiaan. ");
INSERT INTO bus_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Musa dà zɛ́n kↄ̃n Isarailinↄ, aↄ̃ kɛ̃̀ Isia Tɛ̃aaa aↄ̃ gɛ̃̀ Suru gbáan. Aↄ̃ táa ò gurↄ aagↄ̃ gbáa pìn aↄ̃ↄe í ero. ");
INSERT INTO bus_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Kɛ̀ aↄ̃ kà guu kɛ̀ wè sísi Mara, aↄ̃ↄe fↄ̃ wà à í mìro kɛ̀ à kɛ̀ kyã̀kyã yãnzi. Beee yãnzi wà tↄ́ kpà guu pìnɛ Mara. ");
INSERT INTO bus_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ben gbɛ̃nↄ zↄka kà Musazi wà bè: Bↄ́n wé mii? ");
INSERT INTO bus_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Musa wii pɛ̀ Diizi, ben Dii lí ↄ̀dↄanɛ. Kɛ̀ Musa lí pì zù ín, ben í pì kɛ̀ nna. Gwen Dii yã dìɛńnɛ kↄ̃n dokao à ń lɛ́ à ń gwá ");
INSERT INTO bus_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","à bè: Tó a làakari dↄ̀ mamↄma Dii a Luda yãa ée yã kɛ̀ má yezi kɛɛ, tó a yã kɛ̀ má dìɛnↄ mà, ben á ma dokanↄ kũna píngi, mɛ́ gyãa kɛ̀ má kà Igipitinↄn ke káaguro, zaakɛ mámbe Dii kɛ̀ è a gba aafia ũ. ");
INSERT INTO bus_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Beee gbɛra aↄ̃ kà Ɛlimu, guu kɛ̀ íbↄki mɛ̀n kuri awɛɛplaaanↄↄ kún kↄ̃n damina lí mɛ̀n baaagↄ̃ akurinↄo. Ben aↄ̃ bùra kàɛ í pì saɛ gwe. ");
INSERT INTO bus_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Isarailinↄ fɛ̀ɛ Ɛlimu ń píngi, ben aↄ̃ kà Sini gbáa kɛ̀ kú Ɛlimu kↄ̃n Sinaio dagura aↄ̃ bↄna Igipiti mↄ plaadee guu gurↄ gɛ̃rodee zĩ. ");
INSERT INTO bus_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ben aↄ̃ zↄka kà Musa kↄ̃n Arunaozi gbáan gwe ń píngi ");
INSERT INTO bus_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","aↄ̃ bèńnɛ: Bↄ́yãnzi Dii e wa dɛdɛ Igipitirozi? Gwe weè vɛ̃ɛ wà pↄ́ ble kↄ̃n nↄ̀bↄo ai wà kã, ben a mↄwao gbáan kɛ̀ à wa dɛdɛ kↄ̃n nↄaao. ");
INSERT INTO bus_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Dii bè Musanɛ: Bↄna musu mɛ́ pↄ́blee fãkɛare. Gbɛ̃nↄ é bↄɛ wà gurↄ doo pↄ́ sɛ́ɛ lán gu e dↄↄ nà ń blena lɛ́n, lɛ mà ń yↄ̃ mà gwa tó aↄ̃ↄ ma doka kũna. ");
INSERT INTO bus_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Gurↄ swɛɛdodee zĩ gurↄ plaaa pↄ́n aↄ̃é sɛ́ɛ aↄ̃ à pↄ́blee kɛ. ");
INSERT INTO bus_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ben Musa kↄ̃n Arunao bèńnɛ ń píngi: Uusiɛa é dↄ̃ kɛ̀ Dii bé à a bↄɛ Igipiti, ");
INSERT INTO bus_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","zia kↄngↄ é Dii gakui e. À zↄka kɛ̀ á kàazii mà. Bↄ́n wa ũ kɛ̀ é gbasa a zↄka kàwazii? ");
INSERT INTO bus_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Musa ɛ̀ara à bè: Dii é a gba nↄ̀bↄ à só uusiɛa, zia kↄngↄ eé pↄ́blee kpáawa a blena lɛ́n, kɛ̀ à zↄka kɛ̀ á kàazii mà yãnzi. Pↄ́ken wa ũro. Èe kɛ wámbe a zↄka kàwaziro, Diimɛ. ");
INSERT INTO bus_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ben Musa bè Arunanɛ: Ǹ o Isarailinↄnɛ ń píngi aↄ̃ sↄ̃ Diizi, zaakɛ à ń zↄkakana mà. ");
INSERT INTO bus_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Kɛ̀ Aruna e yã oońnɛ, aↄ̃ aɛ dↄ̀ gbáa kpa, ben aↄ̃ↄ è Dii gakui bↄ̀ à mↄ̀ńzi tɛ́luguu guu. ");
INSERT INTO bus_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ben Dii yã ò Musanɛ à bè: ");
INSERT INTO bus_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Ma Isarailinↄ zↄkakana mà. Ǹ ońnɛ uusiɛa aↄ̃é nↄ̀bↄ só, zia kↄngↄ aↄ̃é pↄ́ ble wà kã, aↄ̃é dↄ̃ kɛ̀ mámbe Dii ń Luda ũ. ");
INSERT INTO bus_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Uusiɛ bùrunↄ mↄ̀ wà dà ń bùrala. Kɛ̀ guu dↄ̀ kpíi kpà à lìgańzi. ");
INSERT INTO bus_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Kɛ̀ kpíi kɛ̃̀, ben pↄ́ gↄ̃̀ kaɛna tↄↄtɛa púu ketekete lán pↄ́ kokũ bà. ");
INSERT INTO bus_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Kɛ̀ Isarailinↄↄ è, aↄ̃ bèkↄ̃nɛ: Bↄ́n gwee? Zaakɛ aↄ̃ↄe dↄ̃ tó bↄ́nlo. Musa bèńnɛ: Pↄ́ kɛ̀ Dii kpàawa à bleen gwe. ");
INSERT INTO bus_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Yã kɛ̀ Dii dìɛareen yɛ̀: A baade sɛ́ɛ a blena lɛ́n. À sɛ́ɛ a baade mìa zaka lɛ́ doodo a uadeenↄ pari lɛ́n. ");
INSERT INTO bus_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Isarailinↄↄ kɛ̀ lɛ. Aↄ̃ↄ sɛ̀ɛ, gbɛ̃kenↄ pↄ́ bíta, gbɛ̃kenↄ pↄ́ nɛ́ngo. ");
INSERT INTO bus_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Kɛ̀ wà zaka dàn, gbɛ̃ kɛ̀ sɛ̀ɛ bíta pↄ́ e diziro, gbɛ̃ kɛ̀ sɛ̀ɛ féte pↄ́ e kɛ̃sãaro. ");
INSERT INTO bus_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musa bèńnɛ: Gbɛ̃ke tón à kpaa tó ai guu dↄaro. ");
INSERT INTO bus_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Gbɛ̃kenↄ e Musa yã maro, aↄ̃ à kpaaa tò ai guu dↄ̀, ben à kↄ̀kↄ kà à vã̀, ben Musa pↄ fɛ̃̀ gbɛ̃ pìnↄzi. ");
INSERT INTO bus_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Lán guu e dↄↄ nà baade è sɛ́ɛ a blena lɛ́n. Tó ↄfãntɛ̃ gbã̀, à kɛ̀ gↄ̃̀ tↄↄtɛa è yↄ́mɛ. ");
INSERT INTO bus_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Gurↄ swɛɛdodee zĩ aↄ̃ pↄ́blee sɛ̀ɛ lɛo plaa, baade mìa zaka lɛ́ plaplaa. Ben aↄ̃ gbɛ̃nsinↄ gàa wà ò Musanɛ ń píngi. ");
INSERT INTO bus_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","À bèńnɛ: Lɛn Dii dìɛ lɛ. Zia nɛ́ kámmabogurↄↄ zĩmɛ, Dii gurↄↄmɛ. À pↄ́ kɛ̀ á yezi à kpá tɛ́a kpá tɛ́a. À pↄ́ kɛ̀ á yezi à disa disa, à à kpaaa kɛ̀ gↄ̃̀ diɛ ai guu dↄ̀. ");
INSERT INTO bus_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Aↄ̃ↄ dìɛ ai guu dↄ̀ lán Musa ò nà. Beekii e vãro èe kↄ̀kↄ káro. ");
INSERT INTO bus_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Ben Musa bèńnɛ: À ble gbã̀a, zaakɛ kámmabogurↄↄ zĩmɛ, é e gukea gbã̀aro. ");
INSERT INTO bus_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Àgae sɛ́ɛ ai gurↄ swɛɛdo. À gurↄ swɛɛplaadee nɛ́ kámmabogurↄↄ zĩmɛ, eégↄ̃ kuu zĩ pìaro. ");
INSERT INTO bus_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Gurↄ swɛɛplaadee zĩ gbɛ̃kenↄ bↄ̀ wà gàa sɛ́ɛ, ben aↄ̃ↄe ero. ");
INSERT INTO bus_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ben Dii bè Musanɛ: Égↄ̃ kú kↄ̃n doka kɛ̀ má dìɛ masaio ai bↄrɛmɛ? ");
INSERT INTO bus_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Àgↄ̃ dↄ̃ kɛ̀ mamↄma Dii mámbe ma kámmabogurↄↄ dìɛare. Beee yãnzi gurↄ swɛɛdodee zĩ mɛɛ̀ gurↄ plaaa pↄ́blee kpáawa. Baade gↄ̃ kú a gbɛ̀n, gbɛ̃ke tón gu a gbɛ̀n gurↄ swɛɛplaadee pì zĩro. ");
INSERT INTO bus_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ben aↄ̃ kámma bò gurↄ swɛɛplaadee zĩ. ");
INSERT INTO bus_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Isarailinↄ tↄ́ kpà pↄ́blee pìnɛ mana. À dɛ lán pↄ́wɛɛ pura keteketenↄ bàmɛ. À í nna lán kàra zↄ́dee bà. ");
INSERT INTO bus_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa bè: Yã kɛ̀ Dii dìɛn yɛ̀: Wà mana zaka lɛ́ doo diɛ wa boriinↄnɛ, lɛ aↄ̃ pↄ́blee kɛ̀ à kpàwa wá blè gbáan wa bↄna Igipiti gbɛraa e se. ");
INSERT INTO bus_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ben Musa bè Arunanɛ: Ǹ loo sɛ́ ǹ mana zaka lɛ́ doo kán ǹ diɛ Dii aɛ, lɛ àgↄ̃ diɛna wa boriinↄnɛ. ");
INSERT INTO bus_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Ben Aruna dìɛ gbɛ̀ walaanↄ saɛ lɛ àgↄ̃ diɛna lán Dii ò Musanɛ nà. ");
INSERT INTO bus_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Isarailinↄ mana blè wɛ̃̀ baplaa ai aↄ̃ gàa wà kào bùsu kɛ̀ gbɛ̃nↄↄ kún. Aↄ̃ mana pì blè ai aↄ̃ gàa wà kào Kanaa bùsu lɛ́a. ");
INSERT INTO bus_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Zaka lɛ́ doo nɛ́ lita plaaamɛ. ");
INSERT INTO bus_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Isarailinↄ fɛ̀ɛ Sini gbáan ń píngi, aↄ̃ↄe bùra káɛkaɛɛ lán Dii òńnɛ nà, ben aↄ̃ gàa wà bùra kàɛ Rɛfidimu. Aↄ̃ↄe í e wà mì gwero, ");
INSERT INTO bus_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","ben aↄ̃ zↄka kà Musazi wà bè: Ǹ wa gba í wà mi. À bèńnɛ: Bↄ́yãnzi ée lɛokpakↄ̃a kɛɛmaozi? A kɛ̀ dia ée Dii lɛɛ ée gwaa? ");
INSERT INTO bus_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Kɛ̀ ímii e ń dɛɛ, ben aↄ̃ zↄka kà Musazi wà bè: Bↄ́yãnzi n bↄwao Igipitizi? Ń yezi ímii wa dɛ kↄ̃n wa nɛ́nↄ kↄ̃n wa pↄ́kãdeenↄon yↄ́? ");
INSERT INTO bus_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ben Musa wii pɛ̀ Diizi à bè: Dian mɛ́ kɛ kↄ̃n gbɛ̃ pìnↄ nà? À gↄ̃̀ féte kɛ̀ aↄ̃é ma pápa gbɛ̀o wà ma dɛ. ");
INSERT INTO bus_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Dii bènɛ: Ǹ Isaraili gbɛ̃nsinↄ sɛ́ɛ à dↄ gbɛ̃ pìnↄnɛ aɛ. Ǹ n gò kɛ̀ n Nili lɛ̀o sɛ́ dↄ. ");
INSERT INTO bus_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Mɛ́ zɛ n aɛ Orɛbu gbɛ̀si saɛ gwe. Ǹ gbɛ̀si pì lɛ́, í é bↄ lɛ aↄ̃ mi. Ben Musa kɛ̀ lɛ Isaraili gbɛ̃nsinↄ wáa. ");
INSERT INTO bus_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ben wà tↄ́ kpà guu pìnɛ Masa, zaakɛ gwen aↄ̃ Dii yↄ̃̀n wà gwà wà bè: Dii kúwaon gweↄ́? Wà tↄ́ kpànɛ Mɛriba dↄ, kɛ̀ Isarailinↄ zↄka kà gwe yãnzi. ");
INSERT INTO bus_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amalɛkinↄ mↄ̀ zĩ̀ ká kↄ̃n Isarailinↄ Rɛfidimu. ");
INSERT INTO bus_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Ben Musa bè Yↄsuanɛ: Ǹ gbɛ̃nↄ plɛplɛ wa tɛ́ à gá zĩ̀ ká kↄ̃n Amalɛkinↄ. Zia mɛ́gↄ̃ zɛna sĩ̀sĩ kɛ̀kii mìsↄ̃ntɛ̃a kↄ̃n Luda gòo kũna. ");
INSERT INTO bus_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yↄsua kɛ̀ lán Musa ònɛ nà, à gàa zĩ̀ ká kↄ̃n Amalɛkinↄ. Ben Musa kↄ̃n Arunao kↄ̃n Uruo dìdi sĩ̀sĩ pì mìsↄ̃ntɛ̃a. ");
INSERT INTO bus_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Tó Musa a ↄↄnↄ sɛ̀, Isarailinↄ ègↄ̃ zĩ̀ blee Amalɛkinↄamɛ, mↄde tó à a ↄↄnↄ dìɛ sↄ̃, Amalɛkinↄ ègↄ̃ zĩ̀ blee Isarailinↄa. ");
INSERT INTO bus_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Kɛ̀ Musa ↄↄnↄ wã̀, wà gbɛ̀ sɛ̀ wà dìɛ à gbáru à vɛ̃̀ɛa, ben Aruna kↄ̃n Uruo à ↄↄnↄ kũkũna, gbɛ̃ doo ↄplazi, gbɛ̃ doo ↄzɛzi, ben à ↄↄnↄ gↄ̃̀ zɛna ai ↄfãntɛ̃ gàa à gɛ̃̀o kpɛ́n. ");
INSERT INTO bus_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ben Yↄsua zĩ̀ blè Amalɛkinↄa à ń dɛ́dɛ kↄ̃n fɛ̃ɛdaao. ");
INSERT INTO bus_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Dii bè Musanɛ: Ǹ kɛ̀kii kɛ̃ takada guu lɛ àgↄ̃ dɛ dↄngu pↄ́ ũ ǹ o Yↄsuanɛ, zaakɛ mɛ́ Amalɛkinↄ borii bↄ anduna guu ń píngi. ");
INSERT INTO bus_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musa gbãgbãkii bò, ben à tↄ́ kpànɛ Diin ma tuuta ũ ");
INSERT INTO bus_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","à bè: Ma ↄↄ sɛ̀ Dii kpata kpa. Dii égↄ̃ zĩ̀ ká kↄ̃n Amalɛkinↄ gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Musa anzure Yɛtoro, Midiã sa'ori, yã kɛ̀ Ludaa kɛ̀ Musanɛ kↄ̃n a gbɛ̃ Isarailinↄo mà, lán Dii ń bↄ́ɛ Igipiti nà. ");
INSERT INTO bus_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Àɛ kɛ̀ sↄ̃ Musa gĩakɛ à a naↄ̃ Zipora zĩ̀ bɛ ");
INSERT INTO bus_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","kↄ̃n a nɛ́gↄ̃gbɛ̃ mɛ̀n plaaanↄ. À doo tↄ́n Gɛsↄmu, zaakɛ Musa bè gbɛ̃ zĩ̀tↄn a ũ danↄ bùsun. ");
INSERT INTO bus_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","À doo tↄ́n Ɛliɛza, zaakɛ Musa bè a de Luda a faaba kɛ̀ à a bↄ Fili'auna fɛ̃ɛdaa lɛ́zĩ. ");
INSERT INTO bus_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Ben Yɛtoro fɛ̀ɛ èe mↄↄ Musa kiia kↄ̃n à nɛ́nↄ kↄ̃n à naↄ̃o guu kɛ̀ à bùra kàɛn Luda kpiii saɛ gbáan. ");
INSERT INTO bus_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","À lɛ́kpãsã kɛ̀ Musanɛ à bè: Mɛ́ɛ mↄↄ n kiia kↄ̃n n naↄ̃o kↄ̃n n nɛ́ mɛ̀n plaaanↄo. ");
INSERT INTO bus_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Musa bↄ̀ à gàa à dà a anzurelɛ à kùɛ à lɛ́ pɛ̀ à gasua. Aↄ̃ kↄ̃ aafia gbèka, ben aↄ̃ gɛ̃̀ kpɛ́n. ");
INSERT INTO bus_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa yã kɛ̀ Dii kɛ̀ Fili'aunanɛ kↄ̃n Igipitinↄ Isarailinↄ yãnzi tↄ̃kɛ̃̀nɛ píngi kↄ̃n nawɛ̃a kɛ̀ aↄ̃ↄ è zɛ́ guunↄ píngi kↄ̃n lán Dii ń bↄ́ nào. ");
INSERT INTO bus_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yɛtoro pↄↄ kɛ̀ nna yã maaa kɛ̀ Dii kɛ̀ Isarailinↄnɛa píngi kↄ̃n lán à ń bↄ́ Igipitinↄ ↄzĩ nào. ");
INSERT INTO bus_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ben à bè: Wà Dii sáabu kpá lán à a bↄ Fili'auna kↄ̃n Igipitinↄ ↄzĩ nà. ");
INSERT INTO bus_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Má dↄ̃̀ sa kɛ̀ Dii bíta dɛ tãanↄla ń píngi. Kɛ̀ Igipitinↄ kya kàagu, à yã mↄ̀ńnɛ. ");
INSERT INTO bus_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Ben Yɛtoro sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ ò Ludaa kↄ̃n sa'opↄ pãndenↄ dↄ. Ben Aruna kↄ̃n Isaraili gbɛ̃nsinↄ ń píngi mↄ̀ wà pↄ́ blèo Luda aɛ. ");
INSERT INTO bus_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Kɛ̀ guu dↄ̀ Musa vɛ̃̀ɛ èe yã gↄ̃gↄ̃ↄńnɛ, aↄ̃ↄ káɛzi zaa kↄngↄ ai uusiɛ. ");
INSERT INTO bus_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Kɛ̀ Musa anzure yã kɛ̀ èe kɛɛńnɛ è píngi, ben à à là à bè: Bↄ́n nɛ́ɛ kɛɛ kↄ̃n gbɛ̃ kɛ̀nↄ lɛɛ? Bↄ́yãnzi nɛ́ɛ yãkpaɛ kɛɛńnɛ ndo, baade píngi káɛnzi zaa kↄngↄ ai uusiɛ? ");
INSERT INTO bus_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa wèàla à bè: Gbɛ̃nↄ è mↄ́ ma kiia aↄ̃ Luda pↄyeziyã mamɛ. ");
INSERT INTO bus_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Tó aↄ̃ yãkete vĩ, aↄ̃è mↄ́ ma kiia mà yã pì gↄ̃gↄ̃ńnɛ mà Luda doka kɛ̀ à dìɛnↄ ońnɛ. ");
INSERT INTO bus_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Musa anzure bènɛ: Yã kɛ̀ nɛ́ɛ kɛɛ maaro. ");
INSERT INTO bus_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Nɛ́ kpasa, gbɛ̃ kɛ̀ aↄ̃ↄ kúnyonↄ é kpasa dↄ, zaakɛ zĩi pì dɛnla, nɛ́ fↄ̃ ǹ kɛ ndoro. ");
INSERT INTO bus_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ǹ ma yã ma sa, mɛ́ lɛ́ damma, Luda égↄ̃ kúnyo. Nɛ́gↄ̃ dɛńnɛ yãgↄ̃gↄ̃ri ũ, nɛ́gↄ̃ gaa kↄ̃n ń yãnↄ Luda kiia, ");
INSERT INTO bus_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","nɛ́gↄ̃ doka kɛ̀ Ludaa dìɛnↄ daańnɛ, nɛ́gↄ̃ zɛ́ kɛ̀ dɛ aↄ̃ sɛ́ ↄdↄↄańnɛ kↄ̃n yã kɛ̀ aↄ̃é kɛɛnↄ. ");
INSERT INTO bus_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ǹ gbɛ̃ làakaride náanɛdee kɛ̀ aↄ̃ↄ Luda vĩa vĩ ben aↄ̃è ↄdↄnkpɛɛgbaa síroonↄ plɛplɛ ń tɛ́, ǹ ń diɛ gↄ̃ↄn wàa sↄsↄↄroonↄ dↄn'aɛdeenↄ ũ kↄ̃n gↄ̃ↄn basↄsↄↄroo kↄ̃n gↄ̃ↄn baplaa akurio kↄ̃n gↄ̃ↄn kurikurio, ");
INSERT INTO bus_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","lɛ aↄ̃gↄ̃ yã gↄ̃gↄ̃ↄ gbɛ̃ pìnↄnɛ gurↄ píngi. Aↄ̃é mↄ́ n kiia kↄ̃n yã zĩ'ũunↄ píngi, mↄde aↄ̃é yã nɛ́ngonↄ gↄ̃gↄ̃ ń zĩnda. Beee bé eé n asoo lagonnɛ. ");
INSERT INTO bus_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Tó Dii wènnɛ, tó ń kɛ̀ lɛ, nɛ́ fuaro, gbɛ̃ pìnↄ é tá bɛ làakario kpaɛna. ");
INSERT INTO bus_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa a anzure yã mà à kɛ̀ lán à òare nà píngi. ");
INSERT INTO bus_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","À gbɛ̃ làakarideenↄ plɛ̀plɛ Isaraili boriinↄ tɛ́ píngi à ń díɛ gↄ̃ↄn wàa sↄsↄↄroonↄ dↄn'aɛdeenↄ ũ kↄ̃n gↄ̃ↄn basↄsↄↄroo kↄ̃n gↄ̃ↄn baplaa akurio kↄ̃n gↄ̃ↄn kurikurio. ");
INSERT INTO bus_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ben aↄ̃ègↄ̃ yã gↄ̃gↄ̃ↄńnɛ gurↄ píngi. Yã zĩ'ũun aↄ̃è mↄ́o Musa kiia, ben aↄ̃è yã nɛ́ngonↄ gↄ̃gↄ̃ ń zĩnda. ");
INSERT INTO bus_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Musa gàa à zɛ̀ a anzurenɛ, ben à tà a bùsun. ");
INSERT INTO bus_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Isarailinↄ bↄna Igipiti mↄ aagↄ̃dee guu ");
INSERT INTO bus_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","aↄ̃ fɛ̀ɛ Rɛfidimu. Kɛ̀ aↄ̃ kà Sinai gbáan, ben aↄ̃ bùra kàɛ gwe Sinai kpiii saɛ. ");
INSERT INTO bus_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Musa dìdi à gàa Luda kiia kpiii pì musu, ben Dii lɛ́ zùzi à bè: Ǹ yã kɛ̀kii o Yakubu bori Isarailinↄnɛ: ");
INSERT INTO bus_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Á è lán má kɛ̀ Igipitinↄnɛ nà, lán ma a sɛ ma suao ma kiia, lán kúu è a nɛ́ sɛ́ a dɛ̀bɛa nà. ");
INSERT INTO bus_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Tó a ma yã mà á ma bà kuunaao yã kũna tia sa, égↄ̃ dɛ ma gbɛ̃ yenzideenↄ ũ bori píngi tɛ́. Baa kɛ̀ anduna dɛ ma pↄ́ ũ píngi, ");
INSERT INTO bus_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","égↄ̃ dɛmɛ kínanↄ kↄ̃n sa'orinↄ ũ, ma gbɛ̃ kɛ̀ aↄ̃ↄ kú adonanↄ ũ. Yã kɛ̀ nɛ́ o Isarailinↄnɛn gwe. ");
INSERT INTO bus_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Musa pìta à gbɛ̃nsinↄ sìsi, ben à yã kɛ̀ Dii ònɛ tↄ̃kɛ̃̀ńnɛ píngi. ");
INSERT INTO bus_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Gbɛ̃nↄ wèàla ń píngi wà bè: Yã kɛ̀ Dii òwe píngi wé kɛ. Ben Musa gàa à yã kɛ̀ wà ò tↄ̃kɛ̃̀ Diinɛ. ");
INSERT INTO bus_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Dii bènɛ: Mɛ́ mↄ n kiia tɛ́sukpɛ gègete guu, lɛ gurↄↄ kɛ̀ mɛ́ɛ yã oonnɛ, aↄ̃é ma aↄ̃égↄ̃ n náanɛ vĩ gurↄ píngi. Ben Musa yã kɛ̀ gbɛ̃nↄↄ ò tↄ̃kɛ̃̀ Diinɛ. ");
INSERT INTO bus_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ben Dii bènɛ: Ǹ gá ń kiia ǹ ońnɛ aↄ̃ gbãsĩ bↄ ń zĩndan gbã̀a kↄ̃n ziaao, aↄ̃ ń pↄ́kãsãanↄ pípi. ");
INSERT INTO bus_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Aↄ̃gↄ̃ kú soru guu ziando, zaakɛ à gurↄ aagↄ̃dee zĩ mɛ́ pita mà zɛ Sinai kpiii musu baade píngi wáa. ");
INSERT INTO bus_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ǹ tↄↄtɛ lɛ́ sèeda dańnɛ kpiii pì gɛɛzi ai à lìgazi píngi. Ǹ ońnɛ aↄ̃ làakari kɛ. Aↄ̃ton didi kpiii pìaro. Aↄ̃ gbɛ̃ke tón ↄ kɛa sero. Gbɛ̃ kɛ̀ ↄ kɛ̀a, wà adee dɛ. ");
INSERT INTO bus_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Wàton ↄ kɛ adeearo. Wà à pápa gbɛ̀o ke wà à pápa kào wà dɛ. Pↄ́kãdeen yoo, gbɛ̃nteen yoo, à gàmɛ. Tó aↄ̃ↄ mà wà kuru pɛ̀ wà à bà gà, aↄ̃ sↄ̃ kpiii pìzi. ");
INSERT INTO bus_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Musa pìta kpiii pìa à mↄ̀ à gbɛ̃nↄ lè à òńnɛ aↄ̃ gbãsĩ bↄ ń zĩndan aↄ̃ ń pↄ́kãsãanↄ pípi. ");
INSERT INTO bus_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","À ɛ̀ara à bèńnɛ: Àgↄ̃ kú soru guu gurↄ aagↄ̃dee zĩ yãnzi. Àton daɛ kↄ̃n nↄgbɛ̃oro. ");
INSERT INTO bus_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Kɛ̀ guu dↄ̀ à gurↄ aagↄ̃dee pìa, ben laa e pataa èe pii, ben lou sìsi kpiii musu. Kɛ̀ aↄ̃ kuru'ↄ gbãaa mà, ben vĩa gbɛ̃ kɛ̀ aↄ̃ↄ kú bùrannↄ kũ̀ ń píngi aↄ̃ↄe lugalugaa. ");
INSERT INTO bus_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Musa bↄ̀ńyo bùran à gàańyo Luda kiia, ben aↄ̃ zɛ̀ gĩzĩ kpiii pì saɛ. ");
INSERT INTO bus_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Tɛ́sukpɛ dà Sinai kpiiila kɛ̀ Dii pìta gwe kↄ̃n tɛ́o yãnzi. Tɛ́sukpɛ pì fɛ̀ɛ lán mↄ̀da tɛ́sukpɛ bà, ben kpiii pì e nigãnigãa maamaa. ");
INSERT INTO bus_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Kuru'ↄ gbãaa e kaara. Kɛ̀ Musa yã ò, ben Luda wèàla lapatana guu. ");
INSERT INTO bus_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Dii pìta à zɛ̀ Sinai kpiii mìsↄ̃ntɛ̃a à Musa sìsi, ben à dìdi à gàa gwe. ");
INSERT INTO bus_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Dii bènɛ: Ǹ pita ǹ kpãkɛ̃ gbɛ̃nↄzi, aↄ̃ton vĩ gulɛla aↄ̃ mↄ́ wà ma gwaro, lɛ aↄ̃ paridee tón gagaro yãnzi. ");
INSERT INTO bus_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Baa sa'ori kɛ̀ aↄ̃è sↄ̃maziinↄ, aↄ̃ gbãsĩ bↄ ń zĩndan lɛ màton fɛ̃ńziro yãnzi. ");
INSERT INTO bus_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa bè Diinɛ: Aↄ̃é didiro, zaakɛ n kpãkɛ̃wazi n bè wà tↄↄtɛ lɛ́ sèeda da kpiii pì gɛɛzi à gↄ̃ n pↄ́ ũmɛ. ");
INSERT INTO bus_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ben Dii bènɛ: Ǹ pita ǹ Aruna sɛ́ ǹ suo, mↄde sa'orinↄ kↄ̃n gbɛ̃ kpaaanↄ tón vĩ guu baa aↄ̃ mↄ́ ma kiiaro lɛ màton fɛ̃ńziro yãnzi. ");
INSERT INTO bus_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ben Musa pìta gbɛ̃ pìnↄ kiia à yã pì òńnɛ. ");
INSERT INTO bus_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Luda yã kɛ̀kii ò píngi à bè: ");
INSERT INTO bus_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Mámbe Dii a Luda ũ. Ma a bↄɛ zↄ̀bleen Igipiti. ");
INSERT INTO bus_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Àtongↄ̃ dii ke vĩ ma gbɛraro. ");
INSERT INTO bus_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","5","Àton pↄ́ke taka kɛ à kúɛ à dↄnzi kɛnɛro, pↄ́ kɛ̀ kú musu ke tↄↄtɛa ke í guun yoo, zaakɛ mamↄma Dii a Luda má nↄ̀sɛgↄ̃aanↄ vĩ. Mɛɛ̀ gbɛ̃ kɛ̀ yemaziroonↄ yã zaa wí ń boriinↄ musu ai à gá pɛ́ ń swãkpɛɛnↄa kↄ̃n ń nasionↄ. ");
INSERT INTO bus_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Gbɛ̃ kɛ̀ aↄ̃ↄ yemazi aↄ̃ↄ ma dokayãnↄ kũnanↄ sↄ̃, mɛɛ̀gↄ̃ gbɛ̃kɛɛ vĩńyomɛ ai ń boriia. ");
INSERT INTO bus_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Àton mamↄma Dii a Luda tↄ́ sí pãpãro, zaakɛ gbɛ̃ kɛ̀ ma tↄ́ sì pãpãa mɛ́ tó à bↄ pãro. ");
INSERT INTO bus_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Àgae dↄn kámmabogurↄↄ zĩ nɛ́ ma pↄ́mɛ. ");
INSERT INTO bus_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Àgae a bura zĩ kↄ̃n a zĩ píngio kɛ gurↄ swɛɛdo, ");
INSERT INTO bus_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","à swɛɛplaadee gↄ̃ dɛare kámmabogurↄↄ ũ, zaakɛ mamↄma Dii a Luda ma pↄ́mɛ. Àton zĩi ke kɛ gurↄↄ pì zĩro, apinↄ ke a nɛ́gↄ̃gbɛ̃ ke a nɛ́nↄgbɛ̃ ke a zĩkɛri gↄ̃gbɛ̃ ke nↄgbɛ̃ ke a pↄ́kãdee ke nibↄ kɛ̀ kú a bɛ. ");
INSERT INTO bus_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Zaakɛ gurↄ swɛɛdon ma musu kↄ̃n tↄↄtɛo kɛ̀ kↄ̃n ísiaao kↄ̃n pↄ́ kɛ̀ kú ń guunↄ píngi, ben ma kámma bò à gurↄ swɛɛplaadee zĩ. Beee yãnzi ma aubarika dà kámmabogurↄↄ pìnzi, má dìɛ ma pↄ́ ũ. ");
INSERT INTO bus_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Àgae bɛ̀ɛ lí a de kↄ̃n a daonɛ, lɛ à gì kɛ bùsu kɛ̀ mamↄma Dii a Luda mɛ́ɛ kpaaawaan. ");
INSERT INTO bus_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Àton gbɛ̃ dɛro. ");
INSERT INTO bus_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Àton zina kɛro. ");
INSERT INTO bus_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Àton kpãi oro. ");
INSERT INTO bus_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Àton yã di a gbɛ̃daaaaro. ");
INSERT INTO bus_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Àton a gbɛ̃daaa ua ni dɛro. Àton à nↄↄ ni dɛro ke à zĩkɛri gↄ̃gbɛ̃ ke nↄgbɛ̃ ke à zù ke à zaaki ke pↄ́ kɛ̀ à vĩinↄ píngi. ");
INSERT INTO bus_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Baade píngi lapatana mà kↄ̃n kuru'ↄo, aↄ̃ loupina è kↄ̃n tɛ́sukpɛo dↄ kpiii musu, ben vĩa ń kũ aↄ̃ↄe lugalugaa aↄ̃ↄ zɛ kãaa. ");
INSERT INTO bus_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Aↄ̃ bè Musanɛ: Ǹ yã owe n zĩnda, wé ma. Ǹton tó Luda yã owero, lɛ wàton gagaro yãnzi. ");
INSERT INTO bus_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa bèńnɛ: Àton tó vĩa a kũro, zaakɛ kɛ̀ à a yↄ̃ à gwa yãnzin à mↄ̀zi, lɛ àgↄ̃ à vĩa vĩ bensↄ̃ àton durun kɛro yãnzi. ");
INSERT INTO bus_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Aↄ̃ↄ zɛ kãaa, ben Musa sↄ̃̀ tɛ́sukpɛ gègete pìzi, guu kɛ̀ Ludaa kún pìn. ");
INSERT INTO bus_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ben Dii bè Musanɛ: Ǹ yã kɛ̀kii o Isarailinↄnɛ: Á mà a zĩndanda lán ma yã òare zaa musu nà. ");
INSERT INTO bus_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Àton tãa ke kɛ à namaro. Àton kondogi ke vura pi tãanↄ ũro. ");
INSERT INTO bus_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","À ma gbãgbãkii bo kↄ̃n ɛ̃ɛo à saa oa kↄ̃n sãanↄ kↄ̃n zùnↄ, sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ kↄ̃n kɛnnakↄ̃o sa'opↄo. Guu kɛ̀ má dìɛare àgↄ̃ ma sísin, mɛ́ mↄ́ a kiia mà aubarika daagu. ");
INSERT INTO bus_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Tó ée ma gbãgbãkii pì boo kↄ̃n gbɛ̀o, àton bo kↄ̃n gbɛ̀ anaoro, zaakɛ tó a gã pɛ̀ɛa, á tò à gbãsĩ lɛ̀n gwe. ");
INSERT INTO bus_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Àton ma gbãgbãkii bo à à didikii kɛro, lɛ a bũukɛɛ tón ↄdↄaaro yãnzi. ");
INSERT INTO bus_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Àton wàpe baaru kpáro. Àton zɛ kↄ̃n gbɛ̃ zaaao ɛgɛ sèedadee ũro. ");
INSERT INTO bus_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Àton tɛ́ pariizi yãzaakɛna guuro. Àton zɛ kↄ̃n pariio yãkpaɛ guu à bↄ yãzɛdee kpɛɛro. ");
INSERT INTO bus_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Tó takaaside yã nnaro, àton zɛoro. ");
INSERT INTO bus_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Tó n ibɛɛ zù ke à zaaki sã̀sã bensↄ̃ n kpakũo, ǹ kũ ǹ gáonɛ bɛ. ");
INSERT INTO bus_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Tó n n zanguri zaaki è èe fuu asooa, ǹ à ĩan ká, ǹton à tónlo. ");
INSERT INTO bus_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Tó takaaside yã nna, àton bↄ à kpɛɛro. ");
INSERT INTO bus_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","À zã̀ kũ kↄ̃n mↄnafikio. Àton taarisaidee ke gbɛ̃ maaa dɛro, zaakɛ mɛ́ tó taaridee bↄ pãro. ");
INSERT INTO bus_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Àton ↄdↄnkpɛɛgbaa síro, zaakɛ ↄdↄnkpɛɛgbaa è tó wɛ́ɛdeenↄ vĩa kũmɛ, bensↄ̃ è gbɛ̃ maaanↄ yã liɛ kpɛɛgãnda. ");
INSERT INTO bus_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Àton wɛ́ɛ tã bↄ̀amↄaro. Á bↄ̀amↄkɛɛ dↄ̃, zaakɛ bↄ̀amↄnↄn a ũ yã zaa Igipiti. ");
INSERT INTO bus_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Àgae pↄ́ tↄ̃ a buraanↄa à kɛkɛ ai wɛ̃̀ swɛɛdo, ");
INSERT INTO bus_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","à wɛ̃̀ swɛɛplaadeen à tó tↄↄtɛ kámma bo à ĩam pá, lɛ a takaasideenↄ e wà à zã̀ kɛ̀ bↄ̀ɛ gweenↄ kↄ̃ↄ wɛ, nↄ̀bↄsɛ̃tɛnↄ e wà à kpaa só. À kɛ lɛ dↄ kↄ̃n a geepi búo kↄ̃n a kùkpɛo. ");
INSERT INTO bus_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Àgaegↄ̃ zĩi kɛɛ ai gurↄ swɛɛdo, à swɛɛplaadeen àgae kámma bo, lɛ a zùnↄ kↄ̃n a zaakinↄ e wà kámma bo, bensↄ̃ a zↄ̀nↄ kↄ̃n bↄ̀amↄnↄ é e wà ĩam pá. ");
INSERT INTO bus_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Àgↄ̃ yã kɛ̀ má òareenↄ kũna píngi. Àton tãanↄ tↄ́ síro. Wàton ń tↄ́ ma a lɛ́n sero. ");
INSERT INTO bus_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Wɛ̃̀ kↄ̃n wɛ̃̀o àgae mↄ́ zĩbaa kɛmɛ gɛ̃̀n aagↄ̃. ");
INSERT INTO bus_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Àgae Burɛdi Sɛ́sɛ'ɛ̃zɛ̃sai zĩbaa kɛ lán má dìɛare nà, àgae burɛdi sɛ́sɛ'ɛ̃zɛ̃sai só ai gurↄ swɛɛplaa mↄↄ kɛ̀ wè be Abibu guu a gurↄↄa, zaakɛ mↄↄ pì guun a bↄɛ Igipiti. Gbɛ̃ke tón mↄ́ ma kiia ↄkoriro. ");
INSERT INTO bus_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Àgae Pↄ́kɛkɛna zĩbaa kɛ gurↄↄ kɛ̀ a na pↄ́kɛkɛnaa, à a bura pↄ́ káakunↄ kpáma. Àgae Pↄ́dufublena zĩbaa kɛ wɛ̃̀ yãanaa, gurↄↄ kɛ̀ a a bura pↄ́nↄ kàkↄ̃a píngi. ");
INSERT INTO bus_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Wɛ̃̀ kↄ̃n wɛ̃̀o gɛ̃̀n aagↄ̃ a gↄ̃gbɛ̃ píngi mↄ́ kakↄ̃ana kɛ mamↄma Dii a Luda aɛzĩ. ");
INSERT INTO bus_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Àton pↄ́sɛsɛna kpáma lɛdo kↄ̃n sa'opↄ aruoro. Àton zĩbaa sa'opↄ nↄ́si diɛ guu dↄaro. ");
INSERT INTO bus_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Àgae gá mamↄma Dii a Luda ua kↄ̃n a bura pↄ́ káakunↄ. Àton blènɛ nↄ̀bↄ kuku kↄ̃n à da yↄ̃'ioro. ");
INSERT INTO bus_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Mɛ́ Malaika gbarɛ à dↄare aɛ à a dãkpa zɛ́n à káao guu kɛ̀ má kɛ̀kɛn. ");
INSERT INTO bus_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","À làakari dↄ à yãa à à yã ma. Àton bↄ à kpɛɛro, zaakɛ eé sùu kɛao a taari yã musuro kɛ̀ ma tↄ́ kúa yãnzi. ");
INSERT INTO bus_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Tó a à yã mà bensↄ̃ a yã kɛ̀ má òaree kɛ̀ píngi, mɛ́gↄ̃ dɛ a ibɛɛnↄ ibɛɛ ũmɛ, a wɛdɛrinↄ wɛdɛri ũ. ");
INSERT INTO bus_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ma Malaika pì é dↄare aɛ à gá zɛare bùsu kɛ̀ Amↄrinↄↄ kún kↄ̃n Itinↄ kↄ̃n Pɛrizinↄ kↄ̃n Kanaanↄ kↄ̃n Ivinↄ kↄ̃n Yebusinↄo, mɛ́ ń kaatɛ. ");
INSERT INTO bus_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Àton kúɛ ń tãanↄnɛ à zↄ̀ bleńnɛro, àton ń kɛna kɛro. À ń gboro à ń gbɛ̀nↄ wíwi. ");
INSERT INTO bus_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","À dↄ Dii a Ludazi, eé aubarika daare a pↄ́bleen kↄ̃n a íminao, eé gyãanↄ kɛ̃awa. ");
INSERT INTO bus_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Nↄgbɛ̃nↄ é nↄ̀ bↄɛ a bùsunlo bensↄ̃ pãaa égↄ̃ kuuro. Mɛ́ a wɛ̃̀ndi bà dↄare kↄ̃n mↄ̀kyakooo. ");
INSERT INTO bus_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Mɛ́ vĩa dada gbɛ̃ kɛ̀ aↄ̃ↄ kú a aɛnↄzi mɛ́ tó bídi gɛ̃ borii kɛ̀ a ka ń kiianↄn, mɛ́ tó a ibɛɛnↄ kpɛɛ kpáare. ");
INSERT INTO bus_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Mɛ́ zↄ̃mantɛ̃nↄ gbarɛ a aɛ aↄ̃ ká Ivinↄn kↄ̃n Kanaanↄ kↄ̃n Itinↄ aↄ̃ pɛ́ḿmaare. ");
INSERT INTO bus_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Èe kɛ mɛ́ pɛ́ḿmaare wɛ̃̀ doo guu gↄ̃ↄnlo, lɛ bùsu pì tón gↄ̃ lákpɛ ũ nↄ̀bↄsɛ̃tɛnↄ daalaro yãnzi. ");
INSERT INTO bus_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Mɛ́gↄ̃ pɛ́ḿmaare busɛbusɛmɛ ai à gá pari kũ à ká à bùsu pì sí. ");
INSERT INTO bus_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Mɛ́ a bùsu lɛ́ kɛare zaa Isia Tɛ̃a lɛ́a ai Filisitininↄ Isia lɛ́a, zaa gbáa lɛ́n ai Yuflati lɛ́a. Mɛ́ bùsu pì deenↄ naare a ↄzĩ à pɛ́ḿma. ");
INSERT INTO bus_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","A bà tóngↄ̃ kú ń yãn ke ń tãanↄ yãnlo. ");
INSERT INTO bus_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Àton tó aↄ̃gↄ̃ kú a bùsunlo, lɛ aↄ̃ton tó à durun kɛmɛro, zaakɛ tó a ń tãanↄ gbã̀gbã, a takutɛɛ kpàkpa a zĩndanɛmɛ. ");
INSERT INTO bus_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Dii bè Musanɛ: Mmↄn kↄ̃n Arunao kↄ̃n Nadabuo kↄ̃n Abiuo kↄ̃n Isaraili gbɛ̃nsi gↄ̃ↄn baaagↄ̃ akurinↄ, à didi kpiiia à mↄ́ ma kiia, à dↄnzi kɛmɛ zaa kãaa. ");
INSERT INTO bus_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ḿbe nɛ́ sↄ̃mazi ndo, gbɛ̃ kpaaanↄ tón mↄ́ kĩiro bensↄ̃ parii tón didińyo kpiii kɛ̀ musuro. ");
INSERT INTO bus_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musa gàa à yã kɛ̀ Dii ò tↄ̃kɛ̃̀ńnɛ píngi kↄ̃n dokayãnↄ píngi. Aↄ̃ wè lɛdolɛ ń píngi wà bè: Yã kɛ̀ Dii ò píngi wé kɛ. ");
INSERT INTO bus_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ben Musa yã kɛ̀ Dii ò pìnↄ kɛ̃̀ takada guu píngi. À fɛ̀ɛ kↄngↄ idɛ'idɛ à gbãgbãkii bò kpiigɛɛzi, ben à gbɛ̀ pɛ̀ɛpɛɛ mɛ̀n kuri awɛɛplaa Isaraili bori kuri awɛɛplaaanↄ pↄ́ ũ. ");
INSERT INTO bus_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","À Isaraili gↄ̃kparɛnↄ zĩ̀ kↄ̃n zùswarenɛ bↄ̀rↄnↄ, ben aↄ̃ sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ òo Diia kↄ̃n sáabukpana sa'opↄnↄ. ");
INSERT INTO bus_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Ben Musa zù pìnↄ aru sì à kpàatɛ lɛo plaa. À à lɛo doo dìɛ kↄ̃n taao à à lɛo doo àɛ gbãgbãkiia. ");
INSERT INTO bus_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ben à Dii bà kuunańyo takada sɛ̀ à à kyó kɛ̀ńnɛ. Ben aↄ̃ bè: Yã kɛ̀ Dii ò píngi, wé kɛ wé mì siɛnɛ. ");
INSERT INTO bus_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ben à aru pì sɛ̀ à fã̀ḿma à bè: Dii bà kuunaao arun gwe lán á mà nà píngi. ");
INSERT INTO bus_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Musa kↄ̃n Arunao kↄ̃n Nadabuo kↄ̃n Abiuo kↄ̃n Isaraili gbɛ̃nsi gↄ̃ↄn baaagↄ̃ akurinↄ dìdi kpiiia. ");
INSERT INTO bus_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Aↄ̃ Isarailinↄ Luda è. Safia gbɛ̀ gusararaa kaɛna à gbá gĩzĩ, à í dɛ búgu wásawasa lán ludambɛ búgu bà. ");
INSERT INTO bus_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ludaa e pↄ́ke kɛ Isaraili gbãadee pìnↄnɛro. Aↄ̃ wɛ́ɛ sìàlɛ, ben aↄ̃ pↄ́ blè aↄ̃ í mì. ");
INSERT INTO bus_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Dii bè Musanɛ: Ǹ didi kpiiia ǹ mↄ́ ma kiia ǹgↄ̃ kú gwe. Mɛ́ gbɛ̀ walaa kɛ̀ ma a dokayãnↄ kɛ̃̀anↄ kpámma, lɛ ǹ e ǹ dańnɛ. ");
INSERT INTO bus_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ben à fɛ̀ɛ kↄ̃n a kpàasi Yↄsuao, aↄ̃ↄe gaa didi Luda kpiiia. ");
INSERT INTO bus_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ben Musa bè gbɛ̃nsinↄnɛ: Àgↄ̃ wa dãa kɛ̀, wé ɛara wà su a kiia. Aruna kↄ̃n Uruo égↄ̃ kúao. Tó gbɛ̃ke yãke vĩ, à gáo ń kiia. ");
INSERT INTO bus_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ben Musa dìdi kpiii pìa. Tɛ́sukpɛ dà à mìsↄ̃ntɛ̃la, ");
INSERT INTO bus_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ben Dii gakui pìta Sinai kpiii pìa. Tɛ́sukpɛ pì daàla lɛ ai gurↄ swɛɛdo, à gurↄ swɛɛplaadeen Dii lɛ́ zù Musazi zaa tɛ́sukpɛ pì guu. ");
INSERT INTO bus_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Isarailinↄ Dii gakui è lán tɛ́ kɛ̀ è ń blee bà kpiii pì mìsↄ̃ntɛ̃a. ");
INSERT INTO bus_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ben Musa gɛ̃̀ tɛ́luguu pì guu à ɛ̀ara à dìdi kpiii pìa. À kú gwe ai gurↄ baplaa fãantɛ̃ kↄ̃n gwãavĩo. ");
INSERT INTO bus_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Dii yã ò Musanɛ à bè: ");
INSERT INTO bus_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Ǹ ma! Ma Uri nɛ́ Bezalɛli, Uru dio, Yuda borii sɛ̀. ");
INSERT INTO bus_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Má tò ma Ninii kúa, ben à ↄ̃ndↄ̃ kↄ̃n gonio kↄ̃n dↄ̃nao è ↄzĩ píngi guu. ");
INSERT INTO bus_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","À zã ble pↄ́nↄa dↄ̃ kↄ̃n vurao kↄ̃n kondogio kↄ̃n mↄ̀gotɛ̃o. ");
INSERT INTO bus_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","À gbɛ̀ bɛ̀ɛde ana dↄ̃ kↄ̃n à dana pↄ́ guuo kↄ̃n lí'anao kↄ̃n ↄzĩ sãnda píngio. ");
INSERT INTO bus_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Beee gbɛra ma Aisamaki nɛ́ Ɔↄliabu, Dani borii dìɛ à dↄnlɛri ũ. Ma ↄzĩkɛrinↄ gbà ↄ̃ndↄ̃ↄ ń píngi, lɛ aↄ̃ e wà pↄ́ kɛ̀ má dìɛnnɛɛnↄ kɛ píngi: ");
INSERT INTO bus_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Dakↄ̃rɛki kuta kↄ̃n doka àkpatio kↄ̃n à nɛ́kpaɛo kↄ̃n kpɛ́ pì pↄ́ ketenↄ píngi, ");
INSERT INTO bus_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","teebu kↄ̃n a pↄ́ ketenↄ, vura atɛ̃ɛ dabu kↄ̃n a pↄ́ ketenↄ píngi, tuaetitikpatakii, ");
INSERT INTO bus_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ oki kↄ̃n a pↄ́ ketenↄ píngi, dàga kↄ̃n a dibↄo, ");
INSERT INTO bus_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","pↄ́kãsãa kɛ̀ wà tã̀nↄ, sa'ori Aruna pↄ́kãsãa kɛ̀ eé sↄ̃omaziinↄ kↄ̃n à nɛ́nↄ sa'opↄkãsãanↄ píngi, ");
INSERT INTO bus_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","pↄ́ kyakɛnↄsi kↄ̃n bisakuta tuaetiti gũ nnaao. Aↄ̃ pↄ́ pìnↄ kɛ, lán má dìɛnnɛ nà píngi. ");
INSERT INTO bus_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Dii yã ò Musanɛ à bè: ");
INSERT INTO bus_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Ǹ o Isarailinↄnɛ aↄ̃ kámmabogurↄↄ kɛ̀ má dìɛ yã da, zaakɛ à dɛ sèeda ũ mapi kↄ̃n apinↄ dagura ai a boriia, lɛ à e à dↄ̃ mamↄma Dii ma a sɛ ma gbɛ̃nↄ ũ. ");
INSERT INTO bus_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Àgae kámmabogurↄↄ pì yã da, zaakɛ gurↄↄ pì kuuare adonamɛ. Gbɛ̃ kɛ̀ gurↄↄ pì tɛ̃̀ kɛ̀, adee gàmɛ. Gbɛ̃ kɛ̀ zĩi kɛ̀ gurↄↄ pìa, wà adee bↄ a gbɛ̃nↄ tɛ́ wà dɛ. ");
INSERT INTO bus_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Àgae zĩi kɛ gurↄ swɛɛdo, à gurↄ swɛɛplaadeen é kámma bo, zaakɛ mamↄma Dii ma pↄ́mɛ. Gbɛ̃ kɛ̀ zĩi kɛ̀ kámmabogurↄↄa gàmɛ. ");
INSERT INTO bus_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Isarailinↄ gaegↄ̃ kámmabogurↄↄ pì yã kũna aↄ̃ diɛ gurↄ ìsi ũ ai ń boriia ma bà kuunańyo yã ũ. ");
INSERT INTO bus_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Eégↄ̃ dɛ sèeda ũ mapi kↄ̃n Isarailinↄ dagura gurↄ píngi, zaakɛ mamↄma Dii ma musu kↄ̃n andunao kɛ̀ gurↄ swɛɛdomɛ, ben má yã̀a ma kámma bò à gurↄ swɛɛplaadee zĩ. ");
INSERT INTO bus_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Kɛ̀ Dii yã ò Musanɛ Sinai kpiii musu à yã̀a, ben à dokayã kɛ̃̀ gbɛ̀ walaanↄa mɛ̀n plaa kↄ̃n a zĩnda ↄnɛo à kpàa. ");
INSERT INTO bus_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Kɛ̀ gbɛ̃nↄↄ è kɛ̀ Musa e pita kpiii musu kpaaro, aↄ̃ kàkↄ̃a Arunazi aↄ̃ bènɛ: Ǹ fɛɛ ǹ tãa kenↄ kɛwe lɛ aↄ̃ dↄwe aɛ, zaakɛ Musa kɛ̀ wa bↄɛ Igipiti pì, wá dↄ̃ yã kɛ̀ à à lèro. ");
INSERT INTO bus_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ben Aruna bèńnɛ: À a nↄgbɛ̃nↄ vura swãinↄ bↄɛ kↄ̃n a nɛ́gↄ̃gbɛ̃nↄ pↄ́nↄ kↄ̃n a nɛ́nↄgbɛ̃nↄ pↄ́nↄ à mↄ́omɛ. ");
INSERT INTO bus_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ben ń píngi a vura swãinↄ bↄ̀bↄ aↄ̃ↄ kpà Arunaa. ");
INSERT INTO bus_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","À sì à kàsa lán zùswarenɛ bↄ̀rↄ bà, ben à lↄ̀lↄ. Ben wà bè: Isarailinↄ, a tãan yɛ̀! Àmbe à a bↄɛ Igipiti. ");
INSERT INTO bus_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Kɛ̀ Aruna è lɛ, à sa'okii bò zù pì aɛ, ben à kpàakpa kɛ̀ à bè: Dii zĩbaa kuu zia. ");
INSERT INTO bus_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Kɛ̀ guu dↄ̀, gbɛ̃nↄ fɛ̀ɛ wà sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ òa kↄ̃n kɛnnakↄ̃o sa'opↄo. Gbɛ̃nↄ vɛ̃̀ɛ wèe pↄ́ blee wèe í mii, ben aↄ̃ fɛ̀ɛ wèe pãpãa kɛɛ. ");
INSERT INTO bus_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ben Dii bè Musanɛ: Ǹ pita ǹ gá! N gbɛ̃ kɛ̀ n bↄńyo Igipitinↄ yàka. ");
INSERT INTO bus_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Aↄ̃ kɛ̃̀ zɛ́ kɛ̀ má ↄ̀dↄańnɛa kpakpaa, aↄ̃ vura kàsa tãa ũ lán zùswarenɛ bↄ̀rↄ bà, aↄ̃ kùɛnɛ aↄ̃ saa òa wà bè, Isarailinↄ tãa kɛ̀ à ń bↄ́ɛ Igipitin gwe. ");
INSERT INTO bus_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ben Dii lìara à bè Musanɛ: Má è gbɛ̃ pìnↄ swã gbãamɛ. ");
INSERT INTO bus_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ǹ gumala lɛ mà a pɛ̃tɛ̃ fɛɛńzi mà ń kaatɛ, mↄde mɛ́ n boriinↄ kɛ bíta. ");
INSERT INTO bus_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ben Musa agbaa kpà Dii a Ludanɛ à bè: Dii, bↄ́yãnzin n pɛ̃tɛ̃ é fɛɛ n gbɛ̃nↄazi kɛ̀ n ń bↄ́ɛ Igipiti kↄ̃n n gbãa bítao kↄ̃n n gã̀sã gbãaao? ");
INSERT INTO bus_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Igipitinↄ é be aↄ̃ kaatɛna yãnzin n ń bↄ́ɛzi, lɛ ǹ e ǹ ń dɛdɛ kpiiinↄ musu ǹ ń yãa anduna guu. Ǹ n pↄfɛ̃ kpáɛ ǹ yã kɛ̀ ń yezi ǹ pita n gbɛ̃nↄa pì bↄ n nↄ̀sɛn. ");
INSERT INTO bus_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ǹ dↄ n zↄ̀blerinↄ Ibraĩ kↄ̃n Isaakuo kↄ̃n Isarailio yãn, zaakɛ ń sìńnɛ kↄ̃n n kuunao n bè, nɛ́ ń borii kaara lán sↄsↄnɛnↄ bà, nɛ́ bùsu kɛ̀ n à yã òńnɛ kpá ń boriinↄa wàgↄ̃ vĩ gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ben Dii yã kɛ̀ à bè é pita a gbɛ̃nↄa pì bↄ̀ a nↄ̀sɛn. ");
INSERT INTO bus_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musa ɛ̀ara à pìta kpiiia, à doka gbɛ̀ walaa mɛ̀n plaaa pìnↄ kũna a ↄzĩ. Yã kɛ̃na gbɛ̀ pìnↄa kpa plaplaa píngi. ");
INSERT INTO bus_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Luda bé à gbɛ̀ walaa pìnↄ à, àmbe à yã kɛ̃̀ḿma. ");
INSERT INTO bus_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yↄsua gbɛ̃nↄ wiii mà, ben à bè Musanɛ: Ǹ zĩ̀ wii ma dↄ bùran. ");
INSERT INTO bus_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Musa bè: Zĩ̀blena wiii bé à dↄ gwero, wɛ̃nda ↄ́ↄdↄnan gwe sↄ̃ro, gbɛ̃nↄ lɛ̀sinan mɛ́ɛ maa. ");
INSERT INTO bus_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Kɛ̀ à kà kĩi kↄ̃n bùrao, à è wèe ↄ̃ wãa zùswaree pì aɛ, ben à pↄ fɛ̃̀. À gbɛ̀ walaa kɛ̀ à kũna pìnↄ pã̀ɛ kpiigɛɛzi gwe, aↄ̃ wìwi. ");
INSERT INTO bus_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ben à zùsware kɛ̀ wà pì pì sɛ̀ à dà tɛ́n. À à tí bò, ben à kà ín à kpà Isarailinↄa, aↄ̃ mì. ");
INSERT INTO bus_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ben Musa Aruna là à bè: Bↄ́n gbɛ̃ pìnↄↄ kɛ̀nnɛ, gbasa ń tò aↄ̃ durun bíta kɛ̀ taka kɛ̀? ");
INSERT INTO bus_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ben à wèàla à bè: Ǹton pↄ fɛ̃ro, mare. Ń gbɛ̃ pìnↄ dↄ̃, kɛ̀ aↄ̃ↄ zaa. ");
INSERT INTO bus_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Aↄ̃mbe aↄ̃ bèmɛ mà tãa ke kɛ à dↄńnɛ aɛ. Aↄ̃ bè Musa kɛ̀ wa bↄɛ Igipiti pì, wà dↄ̃ yã kɛ̀ à à lèro. ");
INSERT INTO bus_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ben ma bèńnɛ gbɛ̃ kɛ̀ aↄ̃ vura vĩinↄ bↄɛ wà mↄ́o. Kɛ̀ aↄ̃ mↄ̀o, ben má kà tɛ́n, ben à bↄ̀ zùswarenɛ bↄ̀rↄ pì ũ. ");
INSERT INTO bus_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa è Aruna tò gbɛ̃nↄↄ e ń pↄyezi kɛɛ, ben aↄ̃ gↄ̃̀ fabona pↄ́ ũ ń ibɛɛnↄnɛ. ");
INSERT INTO bus_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Ben à zɛ̀ bùra gɛ̃kiia à bè: Gbɛ̃ kɛ̀ aↄ̃ↄ kú Dii kpaanↄ mↄ́ ma kuu. Ben Levi boriinↄ kàkↄ̃a à kuu. ");
INSERT INTO bus_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","À bèńnɛ: Dii Isarailinↄ Luda bè, a baade a fɛ̃ɛdaa logo à dↄdↄ bùrazi gulɛ kↄ̃n gulɛo, a baade a gbɛ̃nↄ kↄ̃n a gbɛ̃nnanↄ kↄ̃n a gbɛ̃daaanↄ dɛdɛ. ");
INSERT INTO bus_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Levi boriinↄↄ kɛ̀ lán Musa dàńnɛ nà. Gbɛ̃ kɛ̀ wà ń dɛ́dɛ zĩ pìanↄ kà gↄ̃ↄn bↄrↄ aagↄ̃ taka. ");
INSERT INTO bus_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ben Musa bè Levi borii pìnↄnɛ: Lán a bↄ a nɛ́nↄ kↄ̃n a gbɛ̃nↄ kpɛɛ nà, a a zĩnda kpà Diia gbã̀a, Dii aubarika dàagu gbã̀an gwe. ");
INSERT INTO bus_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Kɛ̀ guu dↄ̀ Musa bè gbɛ̃nↄnɛ: A durun bíta kɛ̀, baa kↄ̃n beeeo mɛ́ ɛara mà didi kpiiia mà gá Dii kiia dↄ, wègↄ̃ dↄ̃ro ke mɛ́ e mà agbaa kpánɛare a durun yã musu. ");
INSERT INTO bus_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ben à ɛ̀ara à gàa Dii kiia à bè: N yã nna! Gbɛ̃ pìnↄ durun bíta kɛ̀, aↄ̃ tãa ke kɛ̀ ń zĩndanɛ kↄ̃n vurao. ");
INSERT INTO bus_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ǹ sùu kɛ! Ǹ ń durun kɛ̃ńnɛ. Tó lɛnlo, ǹ ma tↄ́ gogo takada kɛ̀ ń kɛ̃̀ guu. ");
INSERT INTO bus_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Dii bènɛ: Gbɛ̃ kɛ̀ durun kɛ̀mɛ tↄ́n mɛ́ gogo ma takada guu. ");
INSERT INTO bus_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ǹ gá kↄ̃n gbɛ̃nↄ guu kɛ̀ má ònnɛɛn sa. Ma Malaika é dↄnnɛ aɛ. Baa kↄ̃n beeeo tó ma wɛ́ɛtãmmana gurↄↄ kà, mɛ́ wɛ́ɛ tãḿma ń durun yãnzi. ");
INSERT INTO bus_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ben Dii gagyãa kà gbɛ̃nↄn zùswaree kɛ̀ aↄ̃ↄ tò Aruna pì pì yãnzi. ");
INSERT INTO bus_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Dii bè Musanɛ: Ǹ fɛɛ ǹ gu kɛ̀, mpi kↄ̃n gbɛ̃ kɛ̀ n bↄńyo Igipitinↄ, ǹ gáńyo bùsu kɛ̀ má la dà Ibraĩnɛ kↄ̃n Isaakuo kↄ̃n Yakubuo ma bè mɛ́ kpá ń boriinↄan. ");
INSERT INTO bus_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Mɛ́ Malaika gbarɛ à dↄare aɛ mɛ́ pɛ́are Kanaanↄa kↄ̃n Amↄrinↄ kↄ̃n Itinↄ kↄ̃n Pɛrizinↄ kↄ̃n Ivinↄ kↄ̃n Yebusinↄo. ");
INSERT INTO bus_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","À gá bùsu kɛ̀ zwi kↄ̃n zↄ́'io din pì guu. Mↄde mɛ́ gáaoro, lɛ màton a kaatɛ zɛ́nlo yãnzi, zaakɛ swãgbãadeenↄn a ũ. ");
INSERT INTO bus_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Kɛ̀ gbɛ̃nↄ yã pãsĩ pì mà, aↄ̃ ↄ́ↄ dↄ̀, ben gbɛ̃kee e a zãblebↄnↄ da dↄro. ");
INSERT INTO bus_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Zaakɛ Dii gĩakɛ à yã ò Musanɛ à o Isarailinↄnɛ à be: Swãgbãadeenↄn ń ũ, baa tó ma táa òńyo kɛ̀sɛ do, mɛ́ ń kaatɛ. Aↄ̃ baade ń zãblebↄnↄ bↄbↄ, mɛ́gↄ̃ dↄ̃ dian mɛ́ kɛńyo nà. ");
INSERT INTO bus_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ben Isarailinↄ ń zãblebↄnↄ bↄ̀bↄ, aↄ̃ↄe da dↄro zaa Orɛbu kpii kiia. ");
INSERT INTO bus_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Musa è bisakuta sɛ́ à gá à dↄ bùra kpɛɛ bↄruna kↄ̃n bùra pìo féte. À tↄ́ kpà kutaa pìnɛ dakↄ̃rɛki kutaa. Gbɛ̃ kɛ̀ ye Dii yãzi adee è bↄ à gá dakↄ̃rɛki kutaa pì kiia bùra kpɛɛ gwe. ");
INSERT INTO bus_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Tó Musa bↄ̀ èe gaa kpɛ́ pì kiia, baade è bↄ à zɛ a kpɛɛlɛa àgↄ̃ à gwaa ai à gá à gɛ̃n. ");
INSERT INTO bus_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Tó Musa gɛ̃̀ kpɛ́ pìn, tɛ́luguu è pita àgↄ̃ dↄ kpɛɛlɛa, ben Dii è yã oo. ");
INSERT INTO bus_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Tó gbɛ̃nↄↄ è tɛ́luguu pì dↄ kpɛɛlɛ pìa, baade è dↄnzi kɛ a kpɛɛlɛ. ");
INSERT INTO bus_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Dii è yã o kↄ̃n Musao tɛ̃tɛ̃ntɛ̃, lán gbɛ̃ è yã o kↄ̃n a gbɛ̃nnao nà. Musa è ɛara à su bùran, mↄde Nuni nɛ́ Yↄsua à kpàasi è bↄ kpɛ́ pìnlo. ");
INSERT INTO bus_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa bè Diinɛ: N bèmɛ mà gá kↄ̃n gbɛ̃ pìnↄ, mↄde nɛ́ɛ gbɛ̃ kɛ̀ nɛ́ɛ daamɛɛ omɛro. Àɛ kɛ̀ sↄ̃ n bè, ń ma dↄ̃ n gbɛ̃nna ũ bensↄ̃ ma n pↄnnaa è. ");
INSERT INTO bus_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Zaakɛ ma n pↄnnaa è, ǹ tó mà n laasuunↄ dↄ̃ sa, lɛ mà e màgↄ̃ n dↄ̃ màgↄ̃ nnanyo yãpura. Ǹgↄ̃ dↄ̃ kɛ̀ borii kɛ̀kii nɛ́ n gbɛ̃nↄmɛ. ");
INSERT INTO bus_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ben Dii wèàla à bè: Ma wɛ́ɛ égↄ̃ tɛ́azi mà a gba kámmabona. ");
INSERT INTO bus_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa bè: Tó nɛ́ wɛ́ɛ tɛ́waziro, ǹton wa fɛɛ kɛ̀ro. ");
INSERT INTO bus_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Tó nɛ́ɛ gáwaoro, dian weé e wà dↄ̃ kɛ̀ mapi kↄ̃n n gbɛ̃ pìnↄ wá nnanyo? Weé wa dↄ̃kↄ̃zi kↄ̃n bori pãndenↄ anduna guu diamɛ? ");
INSERT INTO bus_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Dii bènɛ: Yã kɛ̀ ń gbèkamaa pì mɛ́ kɛ, zaakɛ n ma pↄnnaa è, má n dↄ̃ ma gbɛ̃nna ũ. ");
INSERT INTO bus_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musa bè: Ǹ n gakui ↄdↄamɛ. ");
INSERT INTO bus_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ben Dii wèàla à bè: Mɛ́ tó ma maakɛ píngi bↄ n aɛ, mɛ́ ma tↄ́ Dii sísi n aɛ, zaakɛ gbɛ̃ kɛ̀ má yezi mà sùu kɛon mɛ́ kɛo, bensↄ̃ gbɛ̃ kɛ̀ má yezi mà wɛ̃nda dↄ̃nɛn mɛ́ dↄ̃nɛ. ");
INSERT INTO bus_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ben à bè: Nɛ́ fↄ̃ ǹ ma uu gwaro, zaakɛ gbɛ̃ntee é fↄ̃ à wɛ́ɛ simalɛ àgↄ̃ kuuro. ");
INSERT INTO bus_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Dii bè: Ǹ guu gwa da ma saɛ kɛ̀. Ǹ zɛ gbɛ̀ musu gwe. ");
INSERT INTO bus_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Tó ma gakui pì e gɛ̃ɛ, mɛ́ n sↄtↄ gbɛ̀kotoon mà a ↄↄ kúnla ai mà gɛ̃tɛ. ");
INSERT INTO bus_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Tó ma a ↄↄ gònla, nɛ́ ma kpɛɛ kpaa e sa, mↄde weé fↄ̃ wà ma uu ero. ");
INSERT INTO bus_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Dii bè Musanɛ: Ǹ gbɛ̀ walaa kɛ mɛ̀n plaa lán káakupↄnↄ bà, mɛ́ yã kɛ̀ kú à káakupↄ kɛ̀ ń wìnↄa kɛ̃ḿma. ");
INSERT INTO bus_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ǹgↄ̃ kú soru guu kↄngↄ. Ǹ didi Sinai kpiiia ǹ zɛ ma aɛ à mìsↄ̃ntɛ̃a. ");
INSERT INTO bus_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Gbɛ̃ke tón mↄ́nyoro. Wàton gbɛ̃ke e gukea kpiii pìa sero. Baa sãa ke zù tón mↄ́ pↄ́ ble à gĩzĩro. ");
INSERT INTO bus_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Musa gbɛ̀ walaa à mɛ̀n plaa lán káakupↄnↄ bà. À fɛ̀ɛ kↄngↄ idɛ'idɛ, ben à dìdi Sinai kpiiia à gbɛ̀ walaa mɛ̀n plaaa pìnↄ kũna a ↄzĩ lán Dii ònɛ nà. ");
INSERT INTO bus_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Dii pìta tɛ́sukpɛ guu à zɛ̀ à saɛ, ben à a zĩnda tↄ́ sìsi. ");
INSERT INTO bus_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Kɛ̀ Dii e gɛ̃ɛ à aɛ, à a tↄ́ sìsi à bè: Dii, Dii Luda wɛ̃ndadↄ̃nnɛri sùudeen ma ũ. Ma pↄↄ è fɛ̃ kpaaro, má gbɛ̃kɛ kↄ̃n náanɛo vĩ bíta. ");
INSERT INTO bus_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Mɛɛ̀gↄ̃ gbɛ̃kɛɛ vĩ kↄ̃n gbɛ̃nↄo ai ń bori lɛ́mmɛ, mɛ́ ń yã zaaanↄ kɛ̃ńnɛ kↄ̃n ń taarinↄ kↄ̃n ń durunnↄo. Mↄde mɛɛ̀ tó taaridee bↄ pãro. Mɛɛ̀ denↄ yã zaaa wí ń nɛ́nↄ musu kↄ̃n ń dionↄ kↄ̃n ń swãkpɛɛnↄ kↄ̃n ń nasionↄo. ");
INSERT INTO bus_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Musa dàɛ a puua à dↄnzi kɛ̀nɛ gↄ̃ↄ ");
INSERT INTO bus_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","à bè: Dii, zaakɛ ma n pↄnnaa è, ǹ gáwao. Baa kɛ̀ gbɛ̃ pìnↄ swã gbãa, ǹ sùu kɛwao kↄ̃n wa yã zaaanↄ kↄ̃n wa durunnↄo, ǹ wa sɛ́ n pↄ́nↄ ũ. ");
INSERT INTO bus_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Dii bè: Ma bà égↄ̃ kúaomɛ. Mɛ́ yãbↄnsaɛ kɛ a píngi wáa kɛ̀ gbɛ̃kee e a taka kɛ bori ke guu andunan zikiro. Borii kɛ̀ aↄ̃ↄ ligaaziinↄ é ma yãkɛna e, zaakɛ mɛ́ yã naasidee kɛao. ");
INSERT INTO bus_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Àgↄ̃ yã kɛ̀ má òare gbã̀a kũna, mɛ́ pɛ́are Amↄrinↄa kↄ̃n Kanaanↄ kↄ̃n Itinↄ kↄ̃n Pɛrizinↄ kↄ̃n Ivinↄ kↄ̃n Yebusinↄo. ");
INSERT INTO bus_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","À làakari kɛ! Àton lɛdolɛ kɛ kↄ̃n bùsu kɛ̀ ée gaa gɛ̃n deenↄoro, lɛ àton takutɛɛ kpákpa a zĩndanɛro yãnzi. ");
INSERT INTO bus_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","À ń sa'okiinↄ gboro à ń tãa gbɛ̀nↄ wíwi à Asɛra línↄ zↄ̃zↄ̃. ");
INSERT INTO bus_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Àton kúɛ tãanɛro, zaakɛ mamↄma Dii ma tↄ́n Nↄ̀sɛgↄ̃aanↄ, mɛɛ̀ nↄ̀sɛgↄ̃aanↄ kpá. ");
INSERT INTO bus_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","À làakari kɛ! Àton lɛ́dolɛ kɛ kↄ̃n bùsu pì deenↄoro, zaakɛ tó aↄ̃ↄe pãpãa kɛɛ ń tãanↄ yã musu, aↄ̃ↄe saa ooḿma, aↄ̃é a sísi à ń sa'onↄbↄ sóńyomɛ. ");
INSERT INTO bus_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Àton nↄↄ sɛ́ a nɛ́nↄnɛ ń tɛ́ro, zaakɛ tó aↄ̃ nɛ́nↄgbɛ̃nↄↄ e pãpãa kɛɛ ń tãanↄ yã musu, aↄ̃é tó a nɛ́nↄ pãpãa kɛńyo se. ");
INSERT INTO bus_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Àton mↄ̀ pi tãa ũro. ");
INSERT INTO bus_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Àgae Burɛdi Sɛ́sɛ'ɛ̃zɛ̃sai zĩbaa kɛ. Àgae burɛdi sɛ́sɛ'ɛ̃zɛ̃sai só gurↄ swɛɛplaa mↄↄ kɛ̀ wè sísi Abibu guu lán má dìɛare nà, zaakɛ mↄↄ pì guun a bↄɛ Igipiti. ");
INSERT INTO bus_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","A daudunↄ nɛ́ ma pↄ́nↄmɛ ń píngi kↄ̃n a pↄ́kãde nɛ́kya káakunↄ ń píngi, zù ke pↄ́ ketenↄ. ");
INSERT INTO bus_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Àgae zaaki nɛ́kya káaku bo kↄ̃n sãao. Tó ée boro, à à waa fĩ à dɛ. Àgae a daudunↄ bo. Gbɛ̃ke tón mↄ́ ma kiia ↄkoriro. ");
INSERT INTO bus_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Àgae zĩi kɛ gurↄ swɛɛdo à kámma bo à gurↄ swɛɛplaadee zĩ, baa búwigurↄ ke pↄ́kɛ̃gurↄ. ");
INSERT INTO bus_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Àgae Pↄ́kɛ̃na zĩbaa kɛ gurↄↄ kɛ̀ a na bura pↄ́ káaku kɛkɛnaa. Àgae Pↄ́dufublena zĩbaa kɛ wɛ̃̀ yãanaa. ");
INSERT INTO bus_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Wɛ̃̀ kↄ̃n wɛ̃̀o gↄ̃gbɛ̃ píngi gae mↄ́ mamↄma Dii Isarailinↄ Luda aɛzĩ gɛ̃̀n aagↄ̃. ");
INSERT INTO bus_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Mɛ́ pɛ́are boriinↄa mɛ́ a bùsu lɛ́ kaaraare. Gbɛ̃ke é a bùsu nii dɛ gurↄↄ kɛ̀ ée mↄↄ mamↄma Dii a Luda aɛzĩ wɛ̃̀ kↄ̃n wɛ̃̀o gɛ̃̀n aagↄ̃ro. ");
INSERT INTO bus_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Àton pↄ́sɛsɛna kpáma lɛdo kↄ̃n sa'opↄ aruoro. Àton Banla sa'onↄbↄ diɛ guu dↄ̀aro. ");
INSERT INTO bus_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Àgae gá mamↄma Dii a Luda ua kↄ̃n a bura pↄ́ káakunↄ. Àton blènɛ nↄ̀bↄ kuku kↄ̃n à da yↄ̃'ioro. ");
INSERT INTO bus_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ben Dii bè Musanɛ: Ǹ yã pìnↄ kɛ̃ takadan, zaakɛ ma bà kuunanyo kↄ̃n Isarailinↄ yãnↄmɛ. ");
INSERT INTO bus_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa kú kↄ̃n Diio gwe ai gurↄ baplaa fãantɛ̃ kↄ̃n gwãavĩo pↄ́blena sai ímina sai. Ben Dii a bà kuunańyo yã mɛ̀n kurinↄ kɛ̃̀ gbɛ̀ walaa pìnↄa. ");
INSERT INTO bus_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Kɛ̀ Musa pìta Sinai kpiiia, à gbɛ̀ walaa mɛ̀n plaaa kɛ̀ doka kɛ̃a pìnↄ kũna a ↄzĩ. À dↄ̃ kɛ̀ a uu e tɛ́ kɛɛ aↄ̃ yã'ona kↄ̃n Diio yãnziro. ");
INSERT INTO bus_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Kɛ̀ Aruna kↄ̃n Isarailinↄ à è ń píngi, à uu e tɛ́ kɛɛ, vĩa ń kũ wà sↄ̃zi. ");
INSERT INTO bus_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ben Musa ń sísi. Aruna kↄ̃n gbɛ̃nsinↄ ɛ̀ara wà mↄ̀ à kiia, ben à yã òńyo. ");
INSERT INTO bus_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Beee gbɛra Isarailinↄ sↄ̃̀zi ń píngi, ben à yã kɛ̀ Dii dìɛnɛ Sinai kpiii musu òńnɛ píngi. ");
INSERT INTO bus_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Kɛ̀ à yã òńnɛ à yã̀a, à sáta kù a uua. ");
INSERT INTO bus_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Tó à gɛ̃̀ à yã o Diio, è sáta go lɛ à kpɛ́ à bↄ. Tó à bↄ̀, è yã kɛ̀ Dii dìɛnɛ o Isarailinↄnɛ, ");
INSERT INTO bus_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ben aↄ̃è e kɛ̀ à uu e tɛ́ kɛɛ. Musa è ɛara à sáta kú a uua lɛ à kpɛ́ à gɛ̃ à yã o Diio. ");
INSERT INTO bus_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Dii bè Musanɛ: ");
INSERT INTO bus_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Ǹ kutaa dↄ kɛ̀ dɛ dakↄ̃rɛki kutaa ũ mↄ káakun gurↄ káaku zĩ ");
INSERT INTO bus_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ǹ àkpati kɛ̀ doka gbɛ̀ walaanↄↄ kú à guu diɛn ǹ lábure mↄ̀ kpázi. ");
INSERT INTO bus_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ǹ gɛ̃ kↄ̃n teebu mↄ̀o ǹ à taanↄ káɛa zɛ́azɛa. Ǹ gɛ̃ kↄ̃n dabu mↄ̀o ǹ à fitianↄ kɛkɛ. ");
INSERT INTO bus_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ǹ vura tuaetitikpatakii mↄ̀ diɛ doka àkpati aɛ ǹ kuta kpɛɛlɛ lábure logo ǹ tataàlɛ. ");
INSERT INTO bus_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Ǹ sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ okii diɛ dakↄ̃rɛki kpɛɛlɛa, ");
INSERT INTO bus_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ǹ dàga mↄ̀ diɛ dakↄ̃rɛki kutaa dagura kↄ̃n sa'okiio ǹ í kán. ");
INSERT INTO bus_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ǹ kara mↄ̀ kpá ǹ ligazi, ǹ lábure kpá kara pì lɛ́a. ");
INSERT INTO bus_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Ǹ pↄ́ kyakɛnↄsi mↄ̀ sɛ́ ǹ kú kpɛ́ pìa kↄ̃n pↄ́ kɛ̀ kú à guunↄ píngi ǹ diɛ ma pↄ́ ũ kↄ̃n à zĩkɛbↄnↄ, aↄ̃é gↄ̃ ma pↄ́ ũ. ");
INSERT INTO bus_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ǹ nↄ́si pì kú sa'okii pìa kↄ̃n a zĩkɛbↄnↄ píngi. Ǹ sa'okii pì diɛ ma pↄ́ ũ, eégↄ̃ dɛ ma pↄ́ ũ dɛńla. ");
INSERT INTO bus_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ǹ nↄ́si pì kú dàga pìa kↄ̃n a dibↄo, aↄ̃é gↄ̃ ma pↄ́ ũ. ");
INSERT INTO bus_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Ǹ mↄ́ kↄ̃n Arunao kↄ̃n a nɛ́nↄ dakↄ̃rɛki kpɛɛlɛa ǹ ń zú o gwe. ");
INSERT INTO bus_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ǹ sa'ori pↄ́kãsãa mↄ̀nↄ da Arunanɛ, ǹ nↄ́si kúa ǹ à diɛ ma pↄ́ ũ, eé gↄ̃ ma gbã̀gbãri ũ. ");
INSERT INTO bus_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ǹ mↄ́ kↄ̃n à nɛ́nↄ dↄ ǹ utagyaba mↄ̀nↄ dadańnɛ, ");
INSERT INTO bus_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ǹ nↄ́si kúkuḿma lán ń kù ń dea nà, aↄ̃é ma gbãgbã. Nↄ́sikuḿmana pì bé eé tó aↄ̃gↄ̃ dɛ ma gbã̀gbãrinↄ ũ ai ń boriia. ");
INSERT INTO bus_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musa kɛ̀ lán Dii ònɛ nà píngi. ");
INSERT INTO bus_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Aↄ̃ bↄna Igipiti wɛ̃̀ plaade mↄ káaku gurↄ káaku zĩn wà kutaa pì dↄ̀. ");
INSERT INTO bus_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Kɛ̀ Musa e kutaa pì dↄↄ, à à zɛbↄ mↄ̀nↄ pɛ̀ɛpɛɛ gĩa, ben à à lípɛɛ mↄ̀nↄ pɛ̀pɛn à à líkpannↄ kpàkpan, ben à lípɛɛnↄ pɛ̀ɛpɛɛ. ");
INSERT INTO bus_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","À bisa dààla, ben à báa kpààla lán Dii ònɛ nà. ");
INSERT INTO bus_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","À sèeda gbɛ̀ walaanↄ sɛ̀ à kà àkpati pì guu, à àkpati pì sɛ́linↄ dà à zãanↄ guu, ben à à nɛ́ kùɛa. ");
INSERT INTO bus_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","À gɛ̃̀o kpɛ́n, ben à lábure kpà sèeda àkpati pìzi lán Dii ònɛ nà. ");
INSERT INTO bus_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","À teebu dìɛ dakↄ̃rɛki kutaan lábure pì kpɛɛlɛ kpa gu'igbãroo kpa. ");
INSERT INTO bus_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","À burɛdi kàɛa Diinɛ zɛ́azɛa lán à ònɛ nà. ");
INSERT INTO bus_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","À dabu dìɛ dakↄ̃rɛki kutaan aɛdↄkↄ̃ana teebua sↄↄmɛtɛ kpa, ");
INSERT INTO bus_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","à fitianↄ nàna Dii aɛ lán à ònɛ nà. ");
INSERT INTO bus_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ben à vura tuaetitikpatakii pì dìɛ dakↄ̃rɛki kutaan lábure saɛ, ");
INSERT INTO bus_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ben à tuaetiti gũ nnaa kpàtaa lán Dii ònɛ nà. ");
INSERT INTO bus_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ben à lábure kpà kutaa pì lɛ́a. ");
INSERT INTO bus_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","À sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ okii dìɛ dakↄ̃rɛki kpɛɛlɛa, ben à sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ òa kↄ̃n flawao lán Dii ònɛ nà. ");
INSERT INTO bus_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","À dàga mↄ̀ dìɛ dakↄ̃rɛki kutaa dagura kↄ̃n sa'okiio, ben à í kàn. ");
INSERT INTO bus_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Gwen Musa kↄ̃n Arunao kↄ̃n a nɛ́gↄ̃gbɛ̃nↄ è ń ↄↄnↄ kↄ̃n ń gbánↄ pípin. ");
INSERT INTO bus_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Tó aↄ̃ↄe gɛ̃ɛ dakↄ̃rɛki kutaan, ke tó aↄ̃ↄe sↄ̃ↄ sa'okiizi, aↄ̃è ń ↄↄnↄ kↄ̃n ń gbánↄ pípin lán Dii ò Musanɛ nà. ");
INSERT INTO bus_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ben à kara kpà à lìga kutaa pìzi kↄ̃n sa'okiio, ben à lábure kpà kara pì lɛ́a. Lɛn Musa zĩi pì kɛ̀ à yã̀a lɛ. ");
INSERT INTO bus_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ben tɛ́luguu pì dà dakↄ̃rɛki kutaa pìla, Dii gakui kutaa pì pà. ");
INSERT INTO bus_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa e fↄ̃ à gɛ̃̀ dakↄ̃rɛki kutaa pìnlo, kɛ̀ tɛ́luguu dààla bensↄ̃ kɛ̀ Dii gakui kutaa pì pà yãnzi. ");
INSERT INTO bus_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Isarailinↄ táa'ona guu, tó tɛ́luguu pì gò kutaa pìa, ben aↄ̃è fɛɛ kↄ̃n táo. ");
INSERT INTO bus_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Tó tɛ́luguu pì e goaro, aↄ̃è fɛɛ kↄ̃n táoro, sé zĩ kɛ̀ à gòa. ");
INSERT INTO bus_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Fãantɛ̃ Dii tɛ́luguu è da kutaa pìla, gwãavĩ sↄ̃ tɛ́ ègↄ̃ kú tɛ́luguu pì guu. Lɛn Isarailinↄ è e lɛ ń píngi ń táa'ona guu píngi. ");
INSERT INTO bus_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Dii yã ò Musanɛ Sinai gbáan Isarailinↄ bↄna Igipiti wɛ̃̀ plaade mↄ káaku guu à bè: ");
INSERT INTO bus_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Isarailinↄ gae Banla zĩbaa kɛ à gurↄↄa. ");
INSERT INTO bus_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","À zĩbaa pì kɛ mↄↄ kɛ̀kii gurↄ gɛ̃rodosaideen uusiɛ. À kɛ lán má dàare nà píngi kↄ̃n à dokayã kɛ̀ má dàareenↄ. ");
INSERT INTO bus_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Musa ò Isarailinↄnɛ aↄ̃ Banla zĩbaa kɛ, ");
INSERT INTO bus_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ben aↄ̃ zĩbaa pì kɛ̀ Sinai gbáan mↄ káaku gurↄ gɛ̃rodosaideen uusiɛ. Aↄ̃ↄ kɛ̀ lán Dii ò Musanɛ nà píngi. ");
INSERT INTO bus_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Gbɛ̃kenↄ kú gwe aↄ̃ↄ gbãsĩ kɛ̀ aↄ̃ ↄ kɛ̀ gɛ̀a yãnzi, ben aↄ̃ↄe e wà Banla zĩbaa kɛ̀ zĩ beeearo. Ben aↄ̃ gàa wà Musa kↄ̃n Arunao lè zĩ beeea gↄ̃ↄ ");
INSERT INTO bus_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","aↄ̃ bè Musanɛ: Gɛ̀ yã musu wa gbãsĩ lɛ̀. Bↄ́yãnzi wà gìwe wà mↄ́ kↄ̃n gbaanↄ Diinɛ kↄ̃n wa gbɛ̃nↄo à gurↄↄazi? ");
INSERT INTO bus_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musa wèńla à bè: À zɛ ai mà ma lán Dii é o a yã musu nà. ");
INSERT INTO bus_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Ben Dii bè Musanɛ: ");
INSERT INTO bus_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Ǹ o Isarailinↄnɛ, tó aↄ̃ gbɛ̃kenↄ ke aↄ̃ boriinↄↄ kpɛ́ gbãsĩ gɛ̀ yã musu, ke aↄ̃ gàa wɛ́tɛ zã̀azã ken, aↄ̃é fↄ̃ wà Banla zĩbaa kɛmɛ zãa. ");
INSERT INTO bus_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Mↄ plaadee gurↄ gɛ̃rodosaidee uusiɛn aↄ̃é zĩbaa pì kɛ. Aↄ̃é sã nↄ̀bↄ só kↄ̃n burɛdi sɛ́sɛ'ɛ̃zɛ̃saio kↄ̃n lá kyã̀kyão. ");
INSERT INTO bus_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Aↄ̃ton à ke tó guu dↄ̀aro bensↄ̃ aↄ̃ton sãa pì wá ke ɛ́ro. Aↄ̃é Banla zĩbaa pì kɛ lán má dìɛare nà píngi. ");
INSERT INTO bus_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Gbɛ̃ kɛ̀ èe gbãsĩ lɛ́ro bensↄ̃ èe gá wɛ́tɛ kearo, tó à gì Banla zĩbaa pì kɛzi, wà adee bↄ a gbɛ̃nↄ tɛ́, zaakɛ èe mↄ́mɛ kↄ̃n gbaao à gurↄↄaro. À taari é wí à musu. ");
INSERT INTO bus_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Bↄ̀amↄ kɛ̀ kú a tɛ́ bensↄ̃ à yezi à Banla zĩbaa kɛmɛ, séde à kɛ lán ma à doka dìɛare nà. Bↄ̀amↄ kↄ̃n bɛdeeo ń píngi yã dↄ̃nkↄ̃mɛ. ");
INSERT INTO bus_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Zĩ kɛ̀ wà bisakutaa mↄ̀ dↄ̀, tɛ́luguu pì dà sèeda kutaa pìla. Zaa uusiɛ ai guu gàa à dↄ̀o tɛ́luguu pì kú kutaa pì musu lán tɛ́ bà. ");
INSERT INTO bus_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Lɛn ègↄ̃ kuu lɛ gurↄ píngi, ègↄ̃ kú kutaa pìla fãantɛ̃, gwãavĩ sↄ̃ lán tɛ́ bà. ");
INSERT INTO bus_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Tó à gò kutaa pìa, ben Isarailinↄ è fɛɛ kↄ̃n táo. Guu kɛ̀ tɛ́luguu pì zɛ̀n, gwen aↄ̃è bùra káɛn. ");
INSERT INTO bus_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Tó Dii ↄ̀dↄańnɛ lɛ, aↄ̃è bùra fɛɛ. Tó à ↄ̀dↄańnɛ dↄ, aↄ̃è ɛara wà bùra káɛ. Tó tɛ́luguu pì da kutaa pìla sↄ̃, aↄ̃ bùra ègↄ̃ kaɛnamɛ. ");
INSERT INTO bus_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Tó tɛ́luguu pì e gurↄ plaaa kɛɛ kutaa pìla, aↄ̃ègↄ̃ Dii yã maa, aↄ̃è bùra fɛɛro. ");
INSERT INTO bus_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Zĩkenↄa tɛ́luguu pì è gurↄ plaaa kɛ kutaalaro. Tó Dii ↄ̀dↄańnɛ, aↄ̃è bùra káɛ, tó Dii ɛ̀ara à ↄ̀dↄańnɛ dↄ, ben aↄ̃è bùra fɛɛ. ");
INSERT INTO bus_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Zĩkenↄa sↄ̃ tɛ́luguu pì è zɛ gu dↄ̃nkↄ̃ féte zaa uusiɛ ai kↄngↄ. Tó à gòa kↄngↄ, ben aↄ̃è bùra fɛɛ. Fãantɛ̃ ke gwãavĩn yoo, tó tɛ́luguu pì gòa, aↄ̃è bùra fɛɛmɛ. ");
INSERT INTO bus_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Tó tɛ́luguu pì gↄ̃̀ zɛna kutaa pìla gurↄ do ke mↄ do ke wɛ̃̀ don yoo, aↄ̃ègↄ̃ kaɛna bùrammɛ, aↄ̃è fɛɛro. Tó à gòa, ben aↄ̃è bùra fɛɛ. ");
INSERT INTO bus_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Aↄ̃è bùra káɛ ke wà bùra fɛɛ Dii lɛ́ saɛro. Aↄ̃ègↄ̃ Dii yã maa lán à dà Musanɛ à òńnɛ nà. ");
INSERT INTO bus_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Dii yã ò Musanɛ à bè: ");
INSERT INTO bus_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Ǹ kãkãki pi mɛ̀n plaa kↄ̃n kondogi kɛ̀ wà gbɛ̃̀gbɛ̃ maamaaao gbɛ̃nↄ kakↄ̃abↄ ũ lɛ aↄ̃gae bùra fɛɛ. ");
INSERT INTO bus_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Tó wà kãkãki pìnↄ pɛ̀, gbɛ̃nↄ é mↄ́ wà kakↄ̃anzi ń píngi dakↄ̃rɛki kpɛɛlɛa. ");
INSERT INTO bus_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Tó kãkãki mɛ̀n doon wà pɛ̀, Isaraili bori dↄn'aɛdee kɛ̀ aↄ̃ↄ dɛ kí ũunↄ bé wé mↄ́ wà kakↄ̃anzi. ");
INSERT INTO bus_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Tó wà kãkãki pìnↄ pɛ̀ sikↄ̃kɛnao, gbɛ̃ kɛ̀ aↄ̃ bùra kú ↄfãntɛ̃bↄɛ kpaanↄ bé wé bùra fɛɛ káaku. ");
INSERT INTO bus_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Tó wà à gɛ̃̀n plaadee pɛ̀ sikↄ̃kɛnao, gbɛ̃ kɛ̀ aↄ̃ bùra kú sↄↄmɛtɛ kpaanↄ bé wé bùra fɛɛ. Kãkãkipɛna sikↄ̃kɛnao pìn gbɛ̃nↄ dana zɛ́n sèeda ũ. ");
INSERT INTO bus_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Tó wà yezi wà gbɛ̃nↄ kakↄ̃a, wàgae pɛ́ sikↄ̃kɛna sai. ");
INSERT INTO bus_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Aruna nɛ́ sa'orinↄ bé wé kãkãki pìnↄ pɛ́. Eégↄ̃ dɛare doka ũ gurↄ píngi, apinↄ kↄ̃n a boriinↄ. ");
INSERT INTO bus_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Gurↄↄ kɛ̀ a ka a bùsun, tó ée gaa zĩ̀ ká kↄ̃n a ibɛɛ kɛ̀ aↄ̃é gà wà fɛɛaonↄ, àgae kãkãki pìnↄ pɛ́ sikↄ̃kɛnao, lɛ a yã e à dↄ mamↄma Dii a Ludan, mɛ́ a bↄ a ibɛɛ pìnↄ ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Gurↄↄ kɛ̀ ée pↄnnaa kɛɛ sↄ̃, zĩbaan yoo, mↄ dufu gurↄ káaku zĩn yoo, àgae kãkãki pìnↄ pɛ́ a sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũnↄa kↄ̃n a sáabukpana sa'opↄnↄ, a yã é dↄmagu. Mámbe Dii a Luda ũ. ");
INSERT INTO bus_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Wɛ̃̀ plaade mↄ plaade gurↄ barodee zĩ, tɛ́luguu gò sèeda kutaala, ");
INSERT INTO bus_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ben Isarailinↄ bùra fɛ̀ɛ Sinai gbáan, aↄ̃ↄe sↄ̃ki kpákpaa ai tɛ́luguu gàa à zɛ̀ Parani gbáan. ");
INSERT INTO bus_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Aↄ̃ bùra fɛɛna káakun gwe. Aↄ̃ↄ kɛ̀ lán Dii dà Musanɛ à òńnɛ nà. ");
INSERT INTO bus_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Yuda zĩ̀kpɛɛnↄ bé wà bùra fɛ̀ɛ gãli kↄ̃n gãlio káaku kↄ̃n ń tuutao. Aminadabu nɛ́ Nasↄ̃n ń dↄn'aɛdee ũ. ");
INSERT INTO bus_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Zua nɛ́ Nɛtanɛlin Isaka zĩ̀kpɛɛnↄ dↄn'aɛdee ũ. ");
INSERT INTO bus_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eloni nɛ́ Ɛliabun Zɛbuluni zĩ̀kpɛɛnↄ dↄn'aɛdee ũ. ");
INSERT INTO bus_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Gɛsↄnu boriinↄ kↄ̃n Mɛrari boriinↄ kutaa pì gbòro, ben aↄ̃ↄ sɛ̀ wà dào zɛ́n. ");
INSERT INTO bus_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ben Rubɛni zĩ̀kpɛɛnↄ bùra fɛ̀ɛ gãli kↄ̃n gãlio kↄ̃n ń tuutao. Sedeu nɛ́ Ɛlizun ń dↄn'aɛdee ũ. ");
INSERT INTO bus_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Zurisadai nɛ́ Selumiɛlin Simɛↄ zĩ̀kpɛɛnↄ dↄn'aɛdee ũ. ");
INSERT INTO bus_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Dɛwɛli nɛ́ Ɛliasafan Gada zĩ̀kpɛɛnↄ dↄn'aɛdee ũ. ");
INSERT INTO bus_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Ben Koa boriinↄ Luda pↄ́nↄ sɛ̀ wà dào zɛ́n. Wà kutaa pì dↄ̀ ai aↄ̃gↄ̃ ká. ");
INSERT INTO bus_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ben Ɛflaimu zĩ̀kpɛɛnↄ bùra fɛ̀ɛ gãli kↄ̃n gãlio kↄ̃n ń tuutao. Amiudu nɛ́ Ɛlisaman ń dↄn'aɛdee ũ. ");
INSERT INTO bus_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Pedazu nɛ́ Gamaliɛlin Manase zĩ̀kpɛɛnↄ dↄn'aɛdee ũ. ");
INSERT INTO bus_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Gideoni nɛ́ Abidãn Bɛyãmi zĩ̀kpɛɛnↄ dↄn'aɛdee ũ. ");
INSERT INTO bus_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ben Dani zĩ̀kpɛɛnↄ bùra fɛ̀ɛ gãli kↄ̃n gãlio kↄ̃n ń tuutao. Aↄ̃mbe aↄ̃ègↄ̃ tɛ́ kpɛɛ. Amisadai nɛ́ Ayɛzan aↄ̃ dↄn'aɛdee ũ. ");
INSERT INTO bus_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Ɔkↄrana nɛ́ Pagiɛlin Asa zĩ̀kpɛɛnↄ dↄn'aɛdee ũ. ");
INSERT INTO bus_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Enana nɛ́ Airan Nafatali zĩ̀kpɛɛnↄ dↄn'aɛdee ũ. ");
INSERT INTO bus_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Lán Isarailinↄ è bùra fɛɛfɛɛ wàgↄ̃ tɛ́tɛkↄ̃zi nàn gwe gãli kↄ̃n gãlio. ");
INSERT INTO bus_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Obabun Musa anzure Ruɛli nɛ́ ũ, Midiã boriimɛ. Musa bènɛ: Wée daa zɛ́n gana bùsu kɛ̀ Dii bè é wa gbaan. Ǹ mↄ́ ǹ gáwao, wé yã maaa kɛnnɛ, zaakɛ Dii nnamana gwe lɛ́ gbɛ̃̀we. ");
INSERT INTO bus_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ben à bènɛ: Mɛ́ gáro, mɛ́ ɛara ma bùsun ma bɛdeenↄ kiiamɛ. ");
INSERT INTO bus_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Musa bè: N yã nna. Ǹton wa tónlo, zaakɛ ń bùrakaɛki maaa dↄ̃ bensↄ̃ ḿbe nɛ́ kɛ wa wɛ́ɛdee ũ. ");
INSERT INTO bus_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Tó n gaawao, wé yã maaa kɛ̀ Dii é kɛwee kɛnnɛ se. ");
INSERT INTO bus_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Isarailinↄ bùra fɛ̀ɛ Dii kpiii saɛ aↄ̃ táa ò gurↄ aagↄ̃. Wà dↄ̀ aɛ kↄ̃n Dii bà kuunańyo àkpatio lɛ à bùrakaɛkii ↄdↄańnɛ. ");
INSERT INTO bus_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Tó aↄ̃ fɛ̀ɛ wà dà zɛ́n, Dii tɛ́luguu pì ègↄ̃ kúńla fãantɛ̃. ");
INSERT INTO bus_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Tó wà dà zɛ́n kↄ̃n àkpatio, Musa è be: Ǹ fɛɛ Dii, lɛ n ibɛɛnↄ fãakↄ̃a, lɛ n zangurinↄ bàa lɛ́nnɛ. ");
INSERT INTO bus_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Tó wà dìɛ, Musa è be: Dii, ǹ ɛara ǹ su Isaraili bↄrↄ ũgbangbanↄa. ");
INSERT INTO bus_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Isarailinↄ zↄka kà Diizi ń nawɛ̃akɛna yãnzi. Kɛ̀ Dii mà, à pↄ fɛ̃̀, ben à tɛ́ fɛ̀ɛ ń tɛ́, aↄ̃ bùra kpadoo tɛ́ kũ̀. ");
INSERT INTO bus_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Ben gbɛ̃nↄ wii pɛ̀ Musazi. Kɛ̀ à wɛ́ɛ kɛ̀ Diia, ben tɛ́ pì zɛ̀. ");
INSERT INTO bus_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ben wà tↄ́ kpà guu pìnɛ Tabera, kɛ̀ Dii tɛ́ fɛ̀ɛ ń tɛ́ gwe yãnzi. ");
INSERT INTO bus_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Bori pãndenↄ kú Isarailinↄ tɛ́, aↄ̃ↄe pↄ́ble pãnde nii dɛɛ, ben Isarailinↄↄ e ↄ́ↄ dↄↄ se wà bè: Mán wé nↄ̀bↄ en wà sóo? ");
INSERT INTO bus_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Wée kpↄ̀ kɛ̀ wá sò Igipiti wa pↄyezia bɛgɛ kɛɛ kↄ̃n plɛ̃̀nↄ kↄ̃n gbɛzɛɛnↄ kↄ̃n ɛfↄnↄ kↄ̃n aubasanↄ kↄ̃n aubasa gizonↄo. ");
INSERT INTO bus_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Tia sa wa lɛ́ gà, zaakɛ weè pↄ́ke ero, tó èe kɛ mana kɛ̀ baasiro. ");
INSERT INTO bus_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mana pì wɛ́ɛ kete, à dɛ lán lí'ↄↄ bàmɛ. ");
INSERT INTO bus_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Isarailinↄ è sɛ́ɛ wà lↄ́ gbɛ̀n ke aↄ̃è zↄ̃ gón. Aↄ̃è disa wà kàra kɛo. À nna lán kàra tɛ̃ngo bà. ");
INSERT INTO bus_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Tó kpíi kpà bùran gwãavĩ, ben mana pì è kwɛ́ se. ");
INSERT INTO bus_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa mà wèe ↄ́ↄ dↄↄ ualɛ kↄ̃n ualɛo. Dii pↄ fɛ̃̀ maamaa, ben à kɛ̀ Musanɛ ĩi ");
INSERT INTO bus_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","à bènɛ: Bↄ́yãnzin nɛ́ɛ wɛ́ɛ tãamazi? Ma yã kparee bé à kɛ̀nnɛ zaa, ben n gbɛ̃ pìnↄ gwana asoo dìmɛɛ? ");
INSERT INTO bus_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Mámbe ma gbɛ̃ pìnↄ nↄ̀ sìↄ́? Mámbe ma ń íↄ́? Bↄ́yãnzi n bèmɛ mà ń kú kpɛɛ lán nɛ́dandee bà mà gáńyo bùsu kɛ̀ ń la dà aↄ̃ dezinↄnɛnzi? ");
INSERT INTO bus_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Mákpan mɛ́ nↄ̀bↄ en mà kpá gbɛ̃ pìnↄa ń píngii? Zaakɛ aↄ̃ↄe wii pɛɛmazi wèe bee mà ń gba nↄ̀bↄ wà só. ");
INSERT INTO bus_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Mɛ́ fↄ̃ mà gbɛ̃ pìnↄↄ kú kpɛɛ ń píngi madoro, zaakɛ aↄ̃ asoo dɛmala. ");
INSERT INTO bus_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Tó lɛn nɛ́ kɛmɛ lɛ, ǹ tó ma n pↄnnaa e ǹ ma dɛ gↄ̃ↄ. Ǹton tó mà nawɛ̃a pì kɛ dↄro. ");
INSERT INTO bus_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Ben Dii bènɛ: Ǹ Isaraili gbɛ̃nsi kɛ̀ ń ń dↄ̃ dↄn'aɛdee ũunↄ kakↄ̃a gↄ̃ↄn baaagↄ̃ akuri ǹ mↄ́ńyo dakↄ̃rɛki kuta kiia aↄ̃gↄ̃ kúnyo gwe. ");
INSERT INTO bus_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Mɛ́ pita mà yã onnɛ gwe mà a Ninii kɛ̀ kúmmaa kpadoo go mà dińnɛ, aↄ̃é gbɛ̃nↄ gwana aso sɛ́nyo lɛ ǹtongↄ̃ ń sɛna ndo dↄro yãnzi. ");
INSERT INTO bus_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Ǹ o gbɛ̃nↄnɛ aↄ̃ gbãsĩ bↄ ń zĩndan zia yãnzi, aↄ̃é nↄ̀bↄ e wà só. Zaakɛ aↄ̃ wii pɛ̀mazi wà bè, mán wé nↄ̀bↄ en kɛ̀ wà sóo? Aↄ̃ bè wà sã̀ↄ Igipiti. Beee yãnzin mɛ́ ń gba nↄ̀bↄ aↄ̃ sózi. ");
INSERT INTO bus_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Aↄ̃é só èe kɛ gurↄ donlo, gurↄ plaanlo, gurↄ sↄↄronlo, gurↄ kurinlo, gurↄ baronlo. ");
INSERT INTO bus_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Aↄ̃é só mↄ do gbãngbãn ai à bↄ ń yĩn à nii bↄ ń pↄↄ guu. Zaakɛ mamↄma Dii má kú ń tɛ́, ben aↄ̃ pã kpàmazi. Aↄ̃ zↄka dↄ̀ma wà bè, bↄ́yãnzi wà bↄ̀ Igipitizi? ");
INSERT INTO bus_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Ben Musa bè: Gↄ̃gbɛ̃nↄↄ kúmao tá guu gↄ̃ↄn bↄrↄ wàa aagↄ̃, ben n bè nɛ́ nↄ̀bↄ kpáḿma wà só ai mↄ do gbãngbãn-ↄ́? ");
INSERT INTO bus_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Baa tó wà sãanↄ kↄ̃n zùnↄ dɛ̀dɛ paripari, eé mↄ́ḿmaↄ́? Tó wà ísia kpↄ̀nↄ sɛ̀ɛ píngi, eé mↄ́ḿmaↄ́? ");
INSERT INTO bus_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Dii wèàla à bè: Ma gbãaa é kánloo? Nɛ́ e tia, tó yã kɛ̀ má ònnɛɛ é kɛ ke eé kɛro. ");
INSERT INTO bus_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Musa bↄ̀ à Dii yã pìnↄ òńnɛ. À Isaraili gbɛ̃nsinↄ kàkↄ̃a gↄ̃ↄn baaagↄ̃ akuri à ń zɛ́ wà lìga kutaa pìzi. ");
INSERT INTO bus_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Ben Dii pìta tɛ́luguu guu à yã òo. À a Ninii kɛ̀ kúa kpadoo gò à dì gbɛ̃nsi gↄ̃ↄn baaagↄ̃ akuri pìnↄnɛ. Kɛ̀ à a Ninii pì dìńnɛ lɛ, aↄ̃ annabikɛɛ kɛ̀, beee gbɛra aↄ̃ↄe ɛara wà kɛ̀ dↄro. ");
INSERT INTO bus_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Gbɛ̃ kɛ̀ Musa ń sɛ́ gↄ̃ↄn plaaanↄ gↄ̃̀ bùran, gbɛ̃ doo tↄ́n Ɛlɛdada, gbɛ̃ doo sↄ̃ Mɛdada. Aↄ̃ↄe gá kutaa kiiaro, mↄde Ninii pì sùḿma se, ben aↄ̃ annabikɛɛ kɛ̀ bùran. ");
INSERT INTO bus_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Gↄ̃kparɛ ke bàa lɛ̀ à gàa à bè Musanɛ: Ɛlɛdada kↄ̃n Mɛdadao e annabikɛyã oo bùran. ");
INSERT INTO bus_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Nuni nɛ́ Yↄsuan Musa kpàasi ũ zaa a ↄ̀wazikɛgurↄ, ben à bè: Baa Musa, ǹ gíńnɛ. ");
INSERT INTO bus_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Ben Musa bènɛ: Nɛ́ɛ nↄ̀sɛgↄ̃aanↄ kɛɛńyo ma yã musun yↄ́? Tó Dii a Ninii dì a gbɛ̃nↄnɛ aↄ̃ gↄ̃̀ annabinↄ ũ ń píngi, à maaroo? ");
INSERT INTO bus_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Ben Musa ɛ̀ara bùran kↄ̃n Isarailinↄ gbɛ̃nsi pìnↄo. ");
INSERT INTO bus_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Dii tò ĩa bↄ̀ ísiaa kpa à mↄ̀ kↄ̃n bùrunↄ, aↄ̃ dà bùrala. Aↄ̃ lìga bùrazi baama píngi à kà tágurↄ doo ũ, bensↄ̃ aↄ̃ vĩana lezĩ kà gã̀sãsuu plaa. ");
INSERT INTO bus_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Fãantɛ̃ beeea kↄ̃n gwãavĩo kↄ̃n à gu làa dↄnao aↄ̃ fɛ̀ɛ wà gàa wà bùrunↄ kũ̀kũ. Gbɛ̃ kɛ̀ èe kũkũ bítaroo kũ̀kũ sùu baro. Ben aↄ̃ↄ fã̀ɛ à gàga. ");
INSERT INTO bus_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Kɛ̀ aↄ̃ à nↄ̀bↄ dà ń lɛ́n gↄ̃ↄ, aↄ̃ↄe e wà só bítaro, ben Dii pↄ fɛ̃̀ńzi à gagyãa kàńgu. ");
INSERT INTO bus_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Ben wà tↄ́ kpà guu pìnɛ Lóudeenↄ Mira, zaakɛ gwen wà gbɛ̃ kɛ̀ nↄ̀bↄ lóu ń kũnↄ vĩ̀in. ");
INSERT INTO bus_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Ben Isarailinↄ fɛ̀ɛ gwe aↄ̃ gàa Azero aↄ̃ gurↄplaa kɛ̀ gwe. ");
INSERT INTO bus_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriamu kↄ̃n Arunao Musa taari è Etiopia nↄↄ kɛ̀ à sɛ̀ yã musu, zaakɛ à Etiopia nↄↄ sɛ̀. ");
INSERT INTO bus_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Aↄ̃ bè: Musa adon Dii dìɛ à yã ò à gãzĩↄ́? Èe o wa gãzĩ seroo? Dii yã pì mà. ");
INSERT INTO bus_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Musa nɛ́ gbɛ̃ busɛmɛ, à sáa kú anduna guuro. ");
INSERT INTO bus_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Gwe gↄ̃ↄ Dii bè Musa kↄ̃n Arunao kↄ̃n Miriamuonɛ: À bↄɛ à gá dakↄ̃rɛki kuta kiia a gↄ̃ↄn aagↄ̃a. Ben aↄ̃ gàa ń gↄ̃ↄn aagↄ̃a ń píngi. ");
INSERT INTO bus_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Dii pìta tɛ́luguu guu à zɛ̀ kutaa pì kpɛɛlɛa. À Aruna kↄ̃n Miriamuo sìsi, ben aↄ̃ sↄ̃̀zi ń plaa ń píngi. ");
INSERT INTO bus_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","À bèńnɛ: À ma yã ma. Tó ma annabi kee kú a tɛ́, mɛɛ̀ bↄ mà mↄ́zi wɛ́ɛgupu guu mɛɛ̀ yã onɛ nanaa guumɛ. ");
INSERT INTO bus_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Mↄde à dɛ lɛ kↄ̃n ma zↄ̀bleri Musaoro. Zĩkɛri náanɛdeemɛ ma ua gbɛ̃nↄ tɛ́ ń píngi. ");
INSERT INTO bus_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Weè yã bↄ kↄ̃ lɛ́n. Mɛɛ̀ yã onɛ mà à ke utɛnɛro. È wɛ́ɛ si ma takalɛ. À kɛ̀ dia ée ma zↄ̀bleri Musa taari'ena vĩa kɛroo? ");
INSERT INTO bus_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Ben Dii pↄ fɛ̃̀ńzi, à a taa o. ");
INSERT INTO bus_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Kɛ̀ tɛ́luguu pì gò kutaa pìla, kusu dà Miriamula gↄ̃ↄ, à pura kũ̀ lán buu bà. Kɛ̀ Aruna lìɛ à à gwà, à è kusu dààla, ");
INSERT INTO bus_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ben à bè Musanɛ: N yã nna Baa! Ǹton tó wà mìsaiyã taarikɛna gbɛ̀ ero. ");
INSERT INTO bus_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ǹton tó àgↄ̃ dɛ lán nɛ́ kɛ̀ wà ì gɛ̀ à mɛ̀ kpadoo yakana bàro. ");
INSERT INTO bus_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Musa wii pɛ̀ Diizi à bè: Luda, n yã nna! Ǹ à kɛ̃kↄ̃a. ");
INSERT INTO bus_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Ben Dii bènɛ: Tó à de bé à lóu sù à uua, eé kɛnɛ wíyã ũ ai gurↄ swɛɛplaaroo? Wà bↄo bùra kpɛɛ gurↄ swɛɛplaa gĩa, gbasa wà à sí. ");
INSERT INTO bus_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Miriamu kú bùra kpɛɛ ai gurↄ swɛɛplaa. Isarailinↄↄ e da zɛ́nlo sé kɛ̀ wà ɛ̀ara wà à sì. ");
INSERT INTO bus_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Beee gbɛra aↄ̃ fɛ̀ɛ Azero aↄ̃ gàa wà bùra kàɛ Parani gbáan. ");
INSERT INTO bus_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Dii bè Musanɛ: ");
INSERT INTO bus_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Ǹ gbɛ̃nↄ zĩ aↄ̃ gá Kanaa bùsu kɛ̀ mɛ́ɛ kpaa Isarailinↄa gwa. Ǹ ń dezinↄ bori gbɛ̃ kɛ̀ aↄ̃ↄ dɛ dↄn'aɛdee ũunↄ sɛ́ mɛ̀n doodo ǹ ń zĩ. ");
INSERT INTO bus_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ben à ń gbáɛ lɛ bↄna Parani gbáan lán Dii ò nà. Gbɛ̃ pìnↄ nɛ́ Isaraili dↄn'aɛdeenↄmɛ ń píngi. ");
INSERT INTO bus_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Aↄ̃ tↄ́nↄn yɛ̀: Rubɛni boriinↄ guu Zaku nɛ́ Samua, ");
INSERT INTO bus_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simɛↄ boriinↄ guu Ori nɛ́ Safata, ");
INSERT INTO bus_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Yuda boriinↄ guu Yefunɛ nɛ́ Kalɛbu, ");
INSERT INTO bus_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Isaka boriinↄ guu Yusufu nɛ́ Igali, ");
INSERT INTO bus_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Ɛflaimu boriinↄ guu Nuni nɛ́ Osea, ");
INSERT INTO bus_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Bɛyãmi boriinↄ guu Rafu nɛ́ Paliti, ");
INSERT INTO bus_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zɛbuluni boriinↄ guu Sodi nɛ́ Gadiɛli, ");
INSERT INTO bus_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Yusufu nɛ́ Manase boriinↄ guu Susi nɛ́ Gadi, ");
INSERT INTO bus_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dani boriinↄ guu Gɛmali nɛ́ Amiɛli, ");
INSERT INTO bus_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Asa boriinↄ guu Mikaɛli nɛ́ Setu, ");
INSERT INTO bus_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nafatali boriinↄ guu Vofosi nɛ́ Nabi, ");
INSERT INTO bus_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gada boriinↄ guu Maki nɛ́ Guɛli. ");
INSERT INTO bus_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Gbɛ̃ kɛ̀ Musa ń zĩ bùsu gwaanↄn gwe. Musa tↄ́ kpà Nuni nɛ́ Oseanɛ Yↄsua. ");
INSERT INTO bus_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Kɛ̀ Musa e ń zĩi Kanaa bùsu gwa, à bèńnɛ: À bↄɛ kↄ̃n Nɛgɛvi gbáao à di bùsu gusĩsĩdeea. ");
INSERT INTO bus_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","À gwa lán bùsu pì dɛ nà, tó à gbɛ̃nↄↄ gbãa kesↄ̃ aↄ̃ↄ busɛ, tó aↄ̃ↄ pari kesↄ̃ aↄ̃ↄ pariro, ");
INSERT INTO bus_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","tó aↄ̃ bùsu maa kesↄ̃ à zaa, tó aↄ̃ wɛ́tɛnↄ bĩi vĩ kesↄ̃ à vĩro, ");
INSERT INTO bus_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","tó à tↄↄtɛ gbãa kesↄ̃ à bùsa, tó à línↄ vĩ kesↄ̃ à vĩro. À aĩa kɛ à bùsu pì líbɛɛnↄ sɛ́ɛ à suo. Zaakɛ geepi bɛ káakunↄ magurↄↄn yɛ̀. ");
INSERT INTO bus_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ben aↄ̃ gàa wà bùsu pì asii gwàgwa zaa Zini gbáan ai Reobo, Lebo Amata kpa. ");
INSERT INTO bus_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Kɛ̀ aↄ̃ bↄ̀ɛ kↄ̃n Nɛgɛvi gbáao, aↄ̃ kà Ɛblↄnu, guu kɛ̀ Anaki boriinↄ Aima kↄ̃n Sesaio kↄ̃n Talamaio kún. Ɛblↄnu kaɛna Zoã kɛ̀ kú Igipiti ã wɛ̃̀ swɛɛplaamɛ. ");
INSERT INTO bus_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Kɛ̀ aↄ̃ kà Ɛsɛkↄlu guzurɛn, aↄ̃ geepi yↄ̃ doo zↄ̃̀ gwe aↄ̃ↄ lògo lía, ben gↄ̃ↄn plaaanↄ sɛna. Aↄ̃ biisioo kↄ̃n kãkãpuraao sɛ̀ dↄ. ");
INSERT INTO bus_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Wà tↄ́ kpà guu pìnɛ Ɛsɛkↄlu guzurɛ, geepi yↄ̃ kɛ̀ Isarailinↄↄ zↄ̃̀ gwe yãnzi. ");
INSERT INTO bus_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Kɛ̀ aↄ̃ bùsu pì yakɛ̀ gurↄ baplaa, ben aↄ̃ ɛ̀ara wà sù. ");
INSERT INTO bus_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Kɛ̀ aↄ̃ sù Kadɛsi, Parani gbáan, aↄ̃ gàa Musa kↄ̃n Arunao kↄ̃n Isarailinↄ kiia píngi. Aↄ̃ sù kↄ̃n baaruo Isarailinↄnɛ ń píngi, ben aↄ̃ bùsu pì líbɛɛnↄ ↄ̀dↄańnɛ. ");
INSERT INTO bus_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Aↄ̃ yã pì gbã̀ Musanɛ wà bè: Wa gaa bùsu kɛ̀ n wa zĩin. Zwi kↄ̃n zↄ́'io di gwe. À líbɛɛnↄn yɛ̀. ");
INSERT INTO bus_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Mↄde bùsu pì deenↄ gbãa. Aↄ̃ wɛ́tɛnↄ bĩi vĩ bensↄ̃ aↄ̃ wɛ́tɛ pìnↄ bíta maamaa. Wa Anaki boriinↄ è gwe se. ");
INSERT INTO bus_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalɛkinↄↄ kú Nɛgɛvi gbáan. Itinↄ kↄ̃n Yebusinↄ kↄ̃n Amↄrinↄↄ kú bùsu gusĩsĩdeen, bensↄ̃ Kanaanↄↄ kú ísiaa saɛ kↄ̃n Yoda saɛo. ");
INSERT INTO bus_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kalɛbu gbɛ̃nↄ lɛ́ yĩ̀tɛ Musa aɛ, ben à bè: Wà gá wà bùsu pì sí, zaakɛ wé fↄ̃ wà zĩ̀ bleḿma. ");
INSERT INTO bus_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ben gbɛ̃ kɛ̀ aↄ̃ gàaonↄ bè: Wé fↄ̃ wà lɛ́ɛ gbɛ̃ pìnↄaro, zaakɛ aↄ̃ gbãaa dɛwala. ");
INSERT INTO bus_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ben aↄ̃ bùsu kɛ̀ aↄ̃ↄ yakɛ̀ pì fabò Isarailinↄnɛ wà bè: Bùsu kɛ̀ wá yakɛ̀ pì nɛ́ bùsu kɛ̀ è a gbɛ̃nↄ mↄ́mↄmɛ. Gbɛ̃ kɛ̀ wa ń é gweenↄ ń píngi nɛ́ gbɛ̃ gbã̀anↄmɛ. ");
INSERT INTO bus_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Wa gbɛ̃ gbã̀agbãanↄ è gwe Anaki boriinↄ ũ. Wa a zĩnda è lán babanɛnↄn bà, lɛn wá dɛ lɛ ń wɛ́ɛn se. ");
INSERT INTO bus_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Isarailinↄↄ e wii gbãaa pɛɛ ń píngi, aↄ̃ↄe ↄ́ↄ dↄↄ gwãavĩ beeea. ");
INSERT INTO bus_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Aↄ̃ zↄka dↄ̀ Musaa kↄ̃n Arunao ń píngi wà bèńnɛ: Tó wa gaga Igipiti kesↄ̃ gbáan kɛ̀, lɛ à kɛ̀ maa. ");
INSERT INTO bus_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Bↄ́yãnzin Dii e taawao bùsu pìnzi? Weé wa dɛdɛ kↄ̃n fɛ̃ɛdaaomɛ, weé wa nↄgbɛ̃nↄ kↄ̃n wa nɛ́nↄ kũkũ. Wa sↄkpana Igipiti sã̀ↄroo? ");
INSERT INTO bus_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ben aↄ̃ bèkↄ̃nɛ: Wà dↄn'aɛdee diɛ wà ɛara wà tá Igipiti. ");
INSERT INTO bus_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Musa kↄ̃n Arunao dàɛ ń puua gbɛ̃ píngi aɛ. ");
INSERT INTO bus_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ben gu'asiigwarinↄ gↄ̃ↄn plaa Nuni nɛ́ Yↄsua kↄ̃n Yefunɛ nɛ́ Kalɛbuo ń utanↄ gàga wà kɛ̃̀kɛ̃ ");
INSERT INTO bus_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","aↄ̃ bè gbɛ̃nↄnɛ: Bùsu kɛ̀ wa bↄɛn wá yakɛ̀ pì maa maamaa. ");
INSERT INTO bus_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Tó wa yã kà Diinɛ, eé gáwao bùsu pìn, bùsu kɛ̀ zwi kↄ̃n zↄ́'io din pì, à wa gba. ");
INSERT INTO bus_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Àton bↄ Dii kpɛɛro. Àton vĩa kɛ bùsu pì deenↄnɛro, zaakɛ wa blɛɛnↄmɛ, aↄ̃ↄ utɛkii vĩ dↄro. Dii kúwao, àton vĩa kɛro. ");
INSERT INTO bus_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Baade píngi e bee wà ń pápa kↄ̃n gbɛ̀o, ben Dii gakui bↄ̀ à mↄ̀ Isarailinↄzi dakↄ̃rɛki kuta kiia. ");
INSERT INTO bus_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Dii bè Musanɛ: Gbɛ̃ pìnↄ égↄ̃ kya kaamagu gurↄ píngin yↄ́? Baa kↄ̃n dabuyã parii kɛ̀ má kɛ̀ ń tɛ́nↄ, aↄ̃égↄ̃ gii ma náanɛ kɛzi gurↄ píngin yↄ́? ");
INSERT INTO bus_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Mɛ́ gagyã kpánzi mà ń kaatɛ, mɛ́ n boriinↄ kɛ pari, aↄ̃ gbãaa égↄ̃ dɛ gbɛ̃ pìnↄla. ");
INSERT INTO bus_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Ben Musa bè Diinɛ: Ḿbe n gbɛ̃ pìnↄ bↄ̀ɛ Igipiti kↄ̃n n gbãaao. Tó Igipitinↄↄ mà, ");
INSERT INTO bus_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","aↄ̃é gí o bùsu kɛ̀ deenↄnɛziro. Zaakɛ aↄ̃ↄ dↄ̃ kɛ̀ ń kúwao, nɛɛ̀ bↄ ǹ mↄ́wazi tɛ̃tɛ̃ntɛ̃. Aↄ̃ↄ dↄ̃ kɛ̀ n tɛ́luguu ègↄ̃ kú wa musu, nɛɛ̀ dↄwe aɛ à guu fãantɛ̃, gwãavĩ sↄ̃ tɛ́ guu. ");
INSERT INTO bus_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Tó n gbɛ̃ pìnↄ dɛ̀ kãndo gↄ̃ↄ, borii kɛ̀ aↄ̃ yã pì mànↄ é be: ");
INSERT INTO bus_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Dii fùa à gá kↄ̃n gbɛ̃ pìnↄ bùsu kɛ̀ à la dàńnɛn, beee yãnzin à ń dɛ́dɛ gbáanzi. ");
INSERT INTO bus_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Dii, ǹ n gbãa bíta ↄdↄańnɛ sa, lán ń ò nà n bè ");
INSERT INTO bus_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","n pↄↄ è fɛ̃ kpaaro, ń gbɛ̃kɛɛ vĩ bíta, nɛɛ̀ gbɛ̃nↄ yã zaaanↄ kↄ̃n ń taarinↄ kɛ̃ńnɛ, mↄde nɛɛ̀ tó taaridee bↄ̀ pãro. Nɛɛ̀ denↄ yã zaaanↄ wí ń boriinↄ musu ai à gá à pɛ́ ń swãkpɛɛnↄa kↄ̃n ń nasionↄ. ");
INSERT INTO bus_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Lán n sùu kɛ̀ kↄ̃n gbɛ̃ pìnↄo nà zaa Igipiti ai aↄ̃ gàa wà kào kɛ̀, ǹ ń durun kɛ̃ńnɛ n gbɛ̃kɛ bíta guu. ");
INSERT INTO bus_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Ben Dii bè: Lán n wɛ́ɛ kɛ̀ma nà, mɛ́ sùu kɛńyo. ");
INSERT INTO bus_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Mↄde lán mɛɛ̀gↄ̃ kuu nà bensↄ̃ ma gakui dà andunala píngi, ");
INSERT INTO bus_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","gbɛ̃ kɛ̀ aↄ̃ ma gakui è kↄ̃n dabuyã kɛ̀ má kɛ̀ Igipiti kↄ̃n gbáa guuo kɛ̀ aↄ̃ ma lɛ wà ma gwa gɛ̃̀n kuri aↄ̃ gì ma yã mazinↄ, ");
INSERT INTO bus_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ń gbɛ̃ke é wɛ́ɛ si bùsu kɛ̀ ma la dà ń dezinↄnɛ pìlɛro. Gbɛ̃ kɛ̀ aↄ̃ kya kàmaguunↄ ke é wɛ́ɛ siàlɛro. ");
INSERT INTO bus_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Lán ma zↄ̀bleri Kalɛbu nↄ̀sɛ bↄ̀ ado nà, à tɛ́mazi kↄ̃n nↄ̀sɛo do, mɛ́ tó à gɛ̃ bùsu kɛ̀ à gàan pì guu, à boriinↄ é e túbi ũ. ");
INSERT INTO bus_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Zaakɛ Amalɛkinↄ kↄ̃n Kanaanↄↄ kú guzurɛn gwe, à ɛara à da gbáa zɛ́n zia Isia Tɛ̃aa kpa. ");
INSERT INTO bus_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Dii bè Musanɛ kↄ̃n Arunao: ");
INSERT INTO bus_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Gbɛ̃ zaaa kɛ̀nↄ é zↄka kámazi gurↄ píngin yↄ́? Ma zↄka kɛ̀ aↄ̃ↄe kaamazii mà. ");
INSERT INTO bus_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ǹ beńnɛ mamↄma Dii ma bè má kuu. Lán aↄ̃ wɛ́ɛ kɛ̀ma nà, lɛn mɛ́ kɛńnɛ lɛ. ");
INSERT INTO bus_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Aↄ̃ gɛ̀nↄ é gↄ̃ kaɛna gbáan kɛ̀, aↄ̃ gbɛ̃ kɛ̀ aↄ̃ kà wɛ̃̀ baro ke dɛàlaanↄ píngi. Aↄ̃ gbɛ̃ kɛ̀ wà ń náro bensↄ̃ aↄ̃ zↄka kàmaziinↄ ");
INSERT INTO bus_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","é gɛ̃ bùsu kɛ̀ ma à lɛ́ gbɛ̃̀ńnɛnlo, séde Yefunɛ nɛ́ Kalɛbu kↄ̃n Nuni nɛ́ Yↄsuao baasiro. ");
INSERT INTO bus_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Aↄ̃ nɛ́ kɛ̀ aↄ̃ bè weé ń kũkũnↄn mɛ́ gɛ̃ńyo, lɛ aↄ̃ bùsu kɛ̀ ń denↄ gìzi pì nnaa ma. ");
INSERT INTO bus_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Aↄ̃pinↄ sↄ̃, aↄ̃ gɛ̀nↄ é gↄ̃ kaɛna gbáan kɛ̀mɛ. ");
INSERT INTO bus_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Aↄ̃ nɛ́nↄ é pↄ́nↄ dãdã gbáan kɛ̀ ai wɛ̃̀ baplaa, aↄ̃ ń denↄ náanɛ sai gbɛ̀ e. Aↄ̃ denↄ gɛ̀nↄ é gↄ̃ gbáan kɛ̀ ń píngi. ");
INSERT INTO bus_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Lán wà bùsu pì yakɛ̀ gurↄ baplaa nà, lɛn aↄ̃égↄ̃ ń yã zaaa gbɛ̀ e lɛ ai wɛ̃̀ baplaa, wɛ̃̀ doodo gurↄ doodo, aↄ̃égↄ̃ dↄ̃ lán íbɛtɛkpanamao dɛ nà. ");
INSERT INTO bus_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Mamↄma Dii mámbe ma yã pì ò, lɛmɛ sↄ̃ mɛ́ kɛ gbɛ̃ zaaa kɛ̀ aↄ̃ kàkↄ̃amazii pìnↄnɛ lɛ. Aↄ̃é gaga gbáan kɛ̀ ń píngi. ");
INSERT INTO bus_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Gbɛ̃ kɛ̀ Musa ń zĩ aↄ̃ bùsu yakɛ̀ kɛ̀ aↄ̃ sù aↄ̃ kya kà bùsu pìn aↄ̃ↄ tò wà zↄka dↄ̀anↄ, ");
INSERT INTO bus_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Dii gagyãa kà gbɛ̃ pìnↄn, ben aↄ̃ gàga. ");
INSERT INTO bus_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Gbɛ̃ kɛ̀ aↄ̃ gàa wà bùsu yakɛ̀ pìnↄ tɛ́, Nuni nɛ́ Yↄsua kↄ̃n Yefunɛ nɛ́ Kalɛbuo bé wà gↄ̃̀ wɛ̃̀ndio. ");
INSERT INTO bus_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Musa yã pìnↄ tↄ̃kɛ̃̀ Isarailinↄnɛ píngi, ben aↄ̃ ↄ́ↄ dↄ̀ maamaa. ");
INSERT INTO bus_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Aↄ̃ fɛ̀ɛ kↄngↄ idɛ'idɛ, aↄ̃ mì pɛ̀ kpiiinↄa aↄ̃ bè: À gwa, wée gaa guu kɛ̀ Dii òn. Wa wa durun dↄ̃̀ sa. ");
INSERT INTO bus_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Musa bè: Bↄ́yãnzi ée pãa Dii yãnɛzi? Beee é sí kɛro. ");
INSERT INTO bus_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Àton gáro, zaakɛ Dii kúaoro. A ibɛɛnↄ é zĩ̀ bleawa. ");
INSERT INTO bus_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amalɛkinↄ kↄ̃n Kanaanↄↄ kú a aɛ gwe. Aↄ̃é a dɛdɛ kↄ̃n fɛ̃ɛdaao. Dii égↄ̃ kúaoro, kɛ̀ a gi tɛ́zizi yãnzi. ");
INSERT INTO bus_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ben aↄ̃ wada yã kɛ̀ aↄ̃ mì pɛ̀ kpiiinↄa, baa kɛ̀ Dii bà kuunańyo àkpati gↄ̃̀ bùran kↄ̃n Musao. ");
INSERT INTO bus_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Ben Amalɛkinↄ kↄ̃n Kanaa kɛ̀ aↄ̃ↄ kú gusĩsĩdee pìnnↄ lɛ̀ɛḿma aↄ̃ zĩ̀ blèḿma wà pɛ̀ḿma ai Ɔↄma. ");
INSERT INTO bus_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Isarailinↄ kà Zini gbáan ń píngi mↄ káaku guu, ben aↄ̃ vɛ̃̀ɛ Kadɛsi. Gwen Miriamu gàn, wà à vĩ̀i. ");
INSERT INTO bus_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Í kuu wà miro, ben aↄ̃ kàkↄ̃a Musa kↄ̃n Arunaozi. ");
INSERT INTO bus_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Aↄ̃ zↄka kà Musazi wà bè: Tó wa gaga yã kↄ̃n gbɛ̃ kɛ̀ aↄ̃ gàga Dii aɛnↄ, lɛ beee sã̀ↄ. ");
INSERT INTO bus_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Bↄ́yãnzi a mↄwao gbáa kɛ̀kiin lɛ wà gaga kɛ̀ kↄ̃n wa pↄ́kãdeenↄozi? ");
INSERT INTO bus_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Bↄ́yãnzi a bↄɛwao Igipiti a mↄwao gu zaaa kɛ̀ guuzi? Pↄ́wɛɛ ke kãkã lí ke geepi bɛɛ ke biisioo kú kɛ̀ro, bensↄ̃ í kú kɛ̀ wà miro. ");
INSERT INTO bus_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Musa kↄ̃n Arunao parii tò aↄ̃ gàa dakↄ̃rɛki kpɛɛlɛa aↄ̃ dàɛ ń puua, ben Dii gakui bↄ̀ à mↄ̀ńzi. ");
INSERT INTO bus_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Dii yã ò Musanɛ à bè: ");
INSERT INTO bus_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Ǹ gò sɛ́, mpi kↄ̃n n vĩ̀i Arunao à gbɛ̃ pìnↄ kakↄ̃a à yã o gbɛ̀si kɛ̀kãanɛ ń wáa, í é bↄn. Lɛn nɛ́ í bↄńnɛ gbɛ̀ pìn aↄ̃ mi lɛ kↄ̃n ń pↄ́kãdeenↄ. ");
INSERT INTO bus_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Musa gò sɛ̀ Dii aɛzĩ lán à ònɛ nà. ");
INSERT INTO bus_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Musa kↄ̃n Arunao ń kákↄ̃a gbɛ̀si pì aɛ, ben à bèńnɛ: À ma a swãgbãadeenↄ! Á yezi wà í bↄare gbɛ̀ kɛ̀kii guun yↄ́? ");
INSERT INTO bus_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Ben Musa ↄↄ sɛ̀ musu à gbɛ̀ pì lɛ̀ kↄ̃n a gòo gɛ̃̀n plaa. Í bↄ̀ maamaa, ben aↄ̃ mì kↄ̃n ń pↄ́kãdeenↄ. ");
INSERT INTO bus_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Ben Dii bè Musanɛ kↄ̃n Arunao: Zaakɛ ée ma náanɛ kɛ a ma tↄ́ bↄ̀ Isarailinↄnɛro, é gɛ̃ńyo bùsu kɛ̀ mɛ́ɛ kpaaḿmanlo. ");
INSERT INTO bus_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Mɛriba íbↄkiin gwe, guu kɛ̀ Isarailinↄ zↄka kàn Diizi, ben à a ludakɛɛ ↄ̀dↄańnɛ. ");
INSERT INTO bus_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Musa gbɛ̃nↄ zĩ̀ aↄ̃ bↄ̀ Kadɛsi wà gàa Ɛdↄmunↄ kína kiia aↄ̃ bè: Wamↄwa n danɛ Isarailinↄ bè, ń nawɛ̃a kɛ̀ à wa leenↄ dↄ̃ píngi. ");
INSERT INTO bus_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Wa dezinↄ gàa Igipiti, ben wa gì kɛ̀ gwe. Igipitinↄ ĩa dàwa kↄ̃n wa dezinↄ. ");
INSERT INTO bus_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Wa wii pɛ̀ Diizi, ben à yã sìwao. À a Malaika zĩ̀ à bↄ̀wao Igipiti. Tia sa wá kú Kadɛsi, n bùsu lɛ́zɛkiia. ");
INSERT INTO bus_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ǹ wa gba zɛ́ wà bↄɛ kↄ̃n n bùsuo. Wé gɛ̃ buraanↄ ke geepi búnↄnlo, wé a lↄ̀gↄ'i miro. Wégↄ̃ tɛ́ kína zɛ́daa guumɛ. Wé liɛ ↄplazi ke ↄzɛziro ai wà gá gɛ̃tɛo n bùsula. ");
INSERT INTO bus_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Ben Ɛdↄmunↄ bèńnɛ: É e à bↄɛ kↄ̃n wa bùsuoro. Tó a gi, wé bↄ wà daalɛ kↄ̃n fɛ̃ɛdaao. ");
INSERT INTO bus_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Isarailinↄ bèńnɛ: Wé bↄɛ kↄ̃n zɛ́daaomɛ. Tó wapinↄ ke wa pↄ́kãdeenↄ a í mì, wé à fĩa bo. Wá yezi wà bↄɛmmɛ pã. ");
INSERT INTO bus_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Ɛdↄmunↄ bè: É e à gɛ̃ro. Ben aↄ̃ zĩ̀karinↄ bↄ̀ɛ paripari aↄ̃ mↄ̀ dańlɛ kↄ̃n gbãaao. ");
INSERT INTO bus_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Zaakɛ Ɛdↄmunↄ gì Isarailinↄnɛ aↄ̃ gɛ̃ kↄ̃n ń bùsuo, ben Isarailinↄ pã̀ńnɛ. ");
INSERT INTO bus_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Isarailinↄ bↄ̀ Kadɛsi ń píngi aↄ̃ kà Oru kpii kiia ");
INSERT INTO bus_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Ɛdↄmunↄ bùsu lɛ́zɛkiia. Gwen Dii yã òn Musanɛ kↄ̃n Arunao à bè: ");
INSERT INTO bus_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aruna é ká a dezinↄla tia, eé gɛ̃ bùsu kɛ̀ mɛ́ɛ Isarailinↄ gbaa guuro, kɛ̀ a gↄ̃ↄn plaaa a gi ma yã mazi zaa Mɛriba yãnzi. ");
INSERT INTO bus_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Ǹ Aruna kↄ̃n a nɛ́ Ɛlɛazao sɛ́ ǹ didińyo Oru kpiiia ");
INSERT INTO bus_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ǹ Aruna pↄ́kãsãanↄ bↄɛa ǹ da à nɛ́ Ɛlɛazanɛ gwe. Gwen Aruna é gan à ká a dezinↄla. ");
INSERT INTO bus_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa kɛ̀ lán Dii ònɛ nà. À dìdi Oru kpiiia gbɛ̃nↄ wáa píngi ");
INSERT INTO bus_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","à Aruna pↄ́kãsãanↄ bↄ̀ɛa à dà à nɛ́ Ɛlɛazanɛ, ben Aruna gà kpiii pì musu gwe. Kɛ̀ Musa kↄ̃n Ɛlɛazao pìta kpiii pìa ");
INSERT INTO bus_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","bensↄ̃ Isarailinↄↄ mà kɛ̀ Aruna gà, ben aↄ̃ à gɛ̀ sósobi kɛ̀ gurↄ baaakuri. ");
INSERT INTO bus_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Aradi kɛ̀ kú Nɛgɛvi bùsun kína nɛ́ Kanaa gbɛ̃mɛ. Kɛ̀ à mà Isarailinↄↄ tɛ́ Atarimu zɛ́n aↄ̃ↄe mↄↄ, ben à bↄ̀ à dàńlɛ kↄ̃n zĩ̀o à ń gbɛ̃kenↄ kũ̀kũ. ");
INSERT INTO bus_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Ben Isarailinↄ lù sɛ̀ Diinɛ wà bè: Tó n gbɛ̃ pìnↄ nàwe wa ↄzĩ, wé ń wɛ́tɛnↄ kaatɛ mámmam. ");
INSERT INTO bus_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Dii Isarailinↄ yã mà, ben à Kanaa pìnↄ kpàḿma. Aↄ̃ ń káatɛ kↄ̃n ń wɛ́tɛnↄ píngi, ben wà tↄ́ kpà guu pìnɛ Ɔↄma. ");
INSERT INTO bus_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Kɛ̀ aↄ̃ fɛ̀ɛ Oru kpiii pì kiia, aↄ̃ Isia Tɛ̃a zɛ́ sɛ̀ lɛ wà pã Ɛdↄmunↄ bùsunɛ. Ben aↄ̃ fù mɛnaa zɛ́n ");
INSERT INTO bus_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","aↄ̃ Luda kↄ̃n Musao taari è wà bè: Bↄ́yãnzin a bↄwao Igipiti lɛ wà gaga gbáan kɛ̀zi? Pↄ́blee kuuro, í kuuro, wa za pↄ́ble gina kɛ̀n. ");
INSERT INTO bus_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Ben Dii mlɛ̃̀ pãsĩnↄ zĩ̀ḿma aↄ̃ ń lɛ́lɛ, ben aↄ̃ gàga paripari. ");
INSERT INTO bus_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Gbɛ̃nↄ mↄ̀ Musa kiia wà bè: Wa durun kɛ̀, zaakɛ wa Dii kↄ̃n mpio taari è. Ǹ agbaa kpánɛwe lɛ à wa kɛ̃kↄ̃a kↄ̃n mlɛ̃̀ kɛ̀nↄ. Ben à agbaa kpànɛńnɛ. ");
INSERT INTO bus_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Dii bènɛ: Ǹ mlɛ̃̀ pi ǹ logo lía ǹ pɛ́ɛ. Tó mlɛ̃̀ gbɛ̃ lɛ̀, tó à wɛ́ɛ sɛ̀ à gwà, eé aafia e. ");
INSERT INTO bus_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ben à mↄ̀gotɛ̃ pì mlɛ̃̀ ũ à lògo lía à pɛ̀ɛ. Tó mlɛ̃̀ gbɛ̃ lɛ̀ bensↄ̃ à wɛ́ɛ sɛ̀ à mↄ̀gotɛ̃ mlɛ̃̀ pì gwà, è aafia e. ");
INSERT INTO bus_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Isarailinↄ dà zɛ́n, ben aↄ̃ bùra kàɛ Obo. ");
INSERT INTO bus_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Bↄna Obo aↄ̃ gàa wà bùra kàɛ Iɛ'abarimu gbáan Mↄabunↄ bùsu ↄfãntɛ̃bↄɛ kpa. ");
INSERT INTO bus_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Bↄna gwe aↄ̃ gàa wà bùra kàɛ Zeredi guzurɛn. ");
INSERT INTO bus_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Bↄna gwe aↄ̃ bùra kàɛ Anↄ baa kãa kpa, gbáa kɛ̀ kú Amↄrinↄ bùsu lɛ́zɛkiia. Anↄ pìn Mↄabu kↄ̃n Amↄrinↄ bùsunↄ lɛ́zɛkii ũ. ");
INSERT INTO bus_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Beee yãnzin wà bè Dii zĩ̀katakada guu: Waɛbu kɛ̀ kú Sufa bùsun kↄ̃n Anↄ swa'ↄnɛnↄ ");
INSERT INTO bus_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","kↄ̃n ń guzurɛ kɛ̀ tà ai Aranↄ Mↄabunↄ bùsu lɛ́zɛkiio. ");
INSERT INTO bus_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Bↄna gwe dↄ aↄ̃ gàa Lↄ̀gↄ, guu kɛ̀ Dii bèn Musanɛ: Ǹ gbɛ̃nↄ kakↄ̃a mà í kpáḿma. ");
INSERT INTO bus_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Gwen Isarailinↄ lɛ̀ kɛ̀kii sìn: Í bↄ lↄ̀gↄn, gbasa wà lɛ̀ sínɛ, ");
INSERT INTO bus_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","lↄ̀gↄ kɛ̀ wa dↄn'aɛdeenↄↄ yↄ̃̀ kↄ̃n línↄ, lↄ̀gↄ kɛ̀ wɛ̃ɛnɛnↄↄ pà kↄ̃n ń gònↄ. Bↄna gbáan aↄ̃ gàa Matana. ");
INSERT INTO bus_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Matana gbɛra Naliɛli, Naliɛli gbɛra Bamↄ. ");
INSERT INTO bus_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Bamↄ gbɛra guzurɛ kɛ̀ kú Mↄabunↄ bùsun, guu kɛ̀ Pisiga mìsↄ̃ntɛ̃ aɛ dↄ gbáaa. ");
INSERT INTO bus_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Isarailinↄ gbɛ̃nↄ zĩ̀ Amↄrinↄ kí Siↄ̃a aↄ̃ bè: ");
INSERT INTO bus_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Ǹ wa gba zɛ́ wà bↄɛ kↄ̃n n bùsuo. Wé gɛ̃ buraanↄ ke geepi búnↄnlo, wé a lↄ̀gↄ'i miro. Wégↄ̃ tɛ́ kína zɛ́daa guumɛ ai wà gá gɛ̃tɛo n bùsula. ");
INSERT INTO bus_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Siↄ̃ e ń gba zɛ́ aↄ̃ gɛ̃tɛ a bùsunlo. À a zĩ̀karinↄ kàkↄ̃a ń píngi, aↄ̃ bↄ̀ɛ wèe gaańzi gbáan. Kɛ̀ aↄ̃ kà Yaza, aↄ̃ zĩ̀ kà kↄ̃n Isarailinↄ, ");
INSERT INTO bus_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","ben Isarailinↄ ń dɛ́dɛ kↄ̃n fɛ̃ɛdaao aↄ̃ ń bùsu sìḿma zaa Anↄ ai Yabokuzi Amↄninↄ bùsun, zaakɛ Amↄninↄ bùsu lɛ́zɛkii pì pãsĩ, è sí gɛ̃nlo. ");
INSERT INTO bus_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Isarailinↄ Amↄri wɛ́tɛnↄ sì píngi kↄ̃n Ɛsɛbↄ̃o kↄ̃n a lakutunↄ píngi, ben aↄ̃ vɛ̃̀ɛn. ");
INSERT INTO bus_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Ɛsɛbↄ̃n Amↄrinↄ kí Siↄ̃ wɛ́tɛdaa ũ. Siↄ̃ zĩ̀ kà yã kↄ̃n Mↄabunↄ kína káakuo, ben à à bùsu sìa ai Anↄ swaazi. ");
INSERT INTO bus_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Beee yãnzin kɛrɛɛnↄ è be: À mↄ́ Ɛsɛbↄ̃, wà Siↄ̃ wɛ́tɛdaa pì kɛkɛ wà káɛ! ");
INSERT INTO bus_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Tɛ́ bↄ̀ Ɛsɛbↄ̃ yã, zĩ̀karinↄ bↄ̀ Siↄ̃ wɛ́tɛ pì guu, aↄ̃ Mↄabunↄ bùsu wɛ́tɛda Ara kàatɛ Anↄ mì sĩ̀sĩ gbɛ̃ pìnↄ. ");
INSERT INTO bus_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Wãiyoo Mↄabunↄ! Kɛmↄsi gbã̀gbãrinↄ, a kaatɛmɛ! Kɛmↄsi tò a gↄ̃gbɛ̃nↄ fã̀akↄ̃a, à a nↄgbɛ̃nↄ kpà Amↄrinↄ kí Siↄ̃a zĩ̀zↄnↄ ũ. ");
INSERT INTO bus_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Ben wa ń fú, wa ń dɛ́dɛ zaa Ɛsɛbↄ̃ ai Dibↄ̃. Wa ń káatɛ ai Nↄfa kↄ̃n Mɛdɛbao. ");
INSERT INTO bus_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Lɛn Isarailinↄ vɛ̃̀ɛ Amↄrinↄ bùsun lɛ. ");
INSERT INTO bus_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Musa gbɛ̃nↄ zĩ̀ Yaza asii gwa, ben Isarailinↄ gwee sì kↄ̃n à lakutunↄ píngi, aↄ̃ pɛ̀ Amↄri kɛ̀ aↄ̃ↄ kú gweenↄa. ");
INSERT INTO bus_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Ben Isarailinↄ lìɛ aↄ̃ Basã zɛ́ sɛ̀. Ben Basã kí Ogu gàańzi kↄ̃n a zĩ̀kpɛɛnↄ ń píngi aↄ̃ zĩ̀ kàńyo Ɛdɛrɛi. ");
INSERT INTO bus_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Dii bè Musanɛ: Ǹton vĩa kɛnɛro, zaakɛ ma à nànnɛ n ↄzĩ kↄ̃n à gbɛ̃nↄ kↄ̃n à bùsuo píngi. Ǹ kɛnɛ lán ń kɛ̀ Amↄrinↄ kí Siↄ̃ kɛ̀ kí blè Ɛsɛbↄ̃nɛ nà. ");
INSERT INTO bus_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Ben aↄ̃ Ogu dɛ̀ kↄ̃n à nɛ́nↄ kↄ̃n à zĩ̀kpɛɛnↄ ń píngi, baa gbɛ̃ mɛ̀n doo e bↄro, ben aↄ̃ à bùsu pì sì. ");
INSERT INTO bus_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Isarailinↄ dà zɛ́n, ben aↄ̃ bùra kàɛ Mↄabunↄ bùsu sɛ̃̀n Yoda baa kãa kɛ̀ aɛ dↄ Yɛrikoa kpa. ");
INSERT INTO bus_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Zipo nɛ́ Balaki Mↄabunↄ kína è lán Isarailinↄↄ kɛ̀ Amↄrinↄnɛ nà, ");
INSERT INTO bus_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ben swɛ̃̀ kɛ̃̀ Mↄabunↄn, vĩa ń kũ Isarailinↄ parikɛɛ yãnzi. ");
INSERT INTO bus_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Ben Mↄabunↄ bè Midiã gbɛ̃nsinↄnɛ: Parii kɛ̀kii é pↄ́ kɛ̀ ligawaziinↄ ble píngi lán zù è sɛ̃̀ ble nà. ");
INSERT INTO bus_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Ben Balaki gbɛ̃nↄ zĩ̀ Bɛↄ nɛ́ Balamua ai Peto, Yuflati saɛ à bɛ bùsun. À bèńnɛ aↄ̃ à sísi à mↄ́ aↄ̃ benɛ: Gbɛ̃kenↄ bↄ̀ Igipiti aↄ̃ dàgula aↄ̃ↄ káɛ ma saɛ. ");
INSERT INTO bus_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","N yã nna! Ǹ mↄ́ ǹ ń kámɛ, zaakɛ aↄ̃ gbãaa dɛmala. Wègↄ̃ dↄ̃ro ke mɛ́ e mà zĩ̀ bleḿma mà pɛ́ḿma bùsu kɛ̀n gwɛɛ. Má dↄ̃ kɛ̀ gbɛ̃ kɛ̀ n sa maaa ònɛ égↄ̃ dɛ aubarikadee ũmɛ. Gbɛ̃ kɛ̀ sↄ̃ n sa zaaa ònɛ, eégↄ̃ dɛ kana pↄ́ ũmɛ. ");
INSERT INTO bus_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Mↄabu kↄ̃n Midiã gbɛ̃nsinↄ dà zɛ́n, aↄ̃ↄ màsokɛna gbaa kɛ̀ aↄ̃é da Balamunɛ kũna. Kɛ̀ aↄ̃ kà à kiia, aↄ̃ yã kɛ̀ Balaki ń zĩo ònɛ. ");
INSERT INTO bus_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","À bèńnɛ: À i kɛ̀, mɛ́ yã kɛ̀ Dii é omɛɛ oare. Ben Mↄabu kínɛ pìnↄ ì Balamu bɛ. ");
INSERT INTO bus_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Ben Luda bↄ̀ à mↄ̀ Balamuzi à à là à bè: Dénↄn gbɛ̃ kɛ̀ aↄ̃ↄ kúnyo kɛ̀kiinↄ ũu? ");
INSERT INTO bus_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","À wèàla à bè: Zipo nɛ́ Balaki, Mↄabunↄ kína bé à ń zĩma. Aↄ̃ bè ");
INSERT INTO bus_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","gbɛ̃ kenↄ bↄ̀ Igipiti aↄ̃ dàgula. Ben à bè mà mↄ́ mà ń káare lɛ à e à zĩ̀ bleḿma à pɛ́ḿma. ");
INSERT INTO bus_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Ben Luda bènɛ: Ǹton tɛ́ńziro. Ǹton sa zaaa ońnɛro, zaakɛ ma aubarika dàńgu kↄ̀. ");
INSERT INTO bus_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Kɛ̀ Balamu fɛ̀ɛ kↄngↄ, à bè Balaki kínɛnↄnɛ: À tá a bùsun, zaakɛ Dii gìmɛ mà tɛ́azi. ");
INSERT INTO bus_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Ben Mↄabu kínɛ pìnↄ fɛ̀ɛ wà tà Balaki kiia aↄ̃ bè: Balamu gì mↄ́waozi. ");
INSERT INTO bus_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balaki ɛ̀ara à kínɛ pãndenↄ zĩ̀ dↄ, aↄ̃ pari kↄ̃n ń gakuio dɛ gbɛ̃ káakunↄla. ");
INSERT INTO bus_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Kɛ̀ aↄ̃ kà Balamu kiia, aↄ̃ bè: Zipo nɛ́ Balaki bè ǹton tó pↄ́ke kpánnɛ kↄ̃n mↄna a kiiaoro, ");
INSERT INTO bus_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","zaakɛ eé gbaa kɛnnɛ maamaa. Pↄ́ kɛ̀ ń ònɛ píngi é kɛ. N yã nna! Ǹ mↄ́ ǹ gbɛ̃ pìnↄ kámɛ. ");
INSERT INTO bus_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Ben Balamu bè Balaki zĩ̀ri pìnↄnɛ: Baa tó Balaki kondogi kↄ̃n vura kɛ̀ kú a bɛɛo kpàma píngi, mɛ́ fↄ̃ mà bↄ Dii ma Luda yã kpɛɛro, baa féte. ");
INSERT INTO bus_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","À i kɛ̀ gwãavĩa lán gbɛ̃ káakunↄↄ kɛ̀ nà ai mà ma dↄ yã kɛ̀ Dii é kaaramɛ. ");
INSERT INTO bus_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Luda bↄ̀ à mↄ̀zi gwãavĩ à bènɛ: Zaakɛ gbɛ̃ kɛ̀nↄ mↄ̀ n sísi, ǹ fɛɛ ǹ gáńyo, mↄde yã kɛ̀ mɛ́ oon ǹ kɛ. ");
INSERT INTO bus_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balamu fɛ̀ɛ kↄngↄ à gàari yì a zaakinɛ, ben à gàa kↄ̃n Mↄabu kínɛ pìnↄo. ");
INSERT INTO bus_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Luda pↄ fɛ̃̀ à gana yãnzi, ben Dii Malaika gàa à zɛ à zɛ́ zↄ̃̀nɛ. Balamu di a zaaki kpɛɛ, à zĩkɛri gↄ̃ↄn plaaanↄn tɛ́o. ");
INSERT INTO bus_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Kɛ̀ zaaki pì è Dii Malaika zɛna zɛ́ guu à fɛ̃ɛdaa wòto à kũna, ben à lìɛ sɛ̃̀n. Balamu à lɛ̀, ben à ɛ̀ara à dà zɛ́n. ");
INSERT INTO bus_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Dii Malaika gàa à zɛ̀ zɛ́ wɛ́wɛn geepi líkpɛ kɛ̀ gbɛ̀ kara ligazinↄ dagura. ");
INSERT INTO bus_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Kɛ̀ zaaki pì Dii Malaika è, à nà gũ̀a à Balamu gbá lↄ̀a. Ben Balamu ɛ̀ara à à lɛ̀ dↄ. ");
INSERT INTO bus_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Dii Malaika ɛ̀ara à gàa aɛ dↄ à zɛ̀ gu kpaatogoo kɛ̀ liɛkii vĩroon. ");
INSERT INTO bus_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Kɛ̀ zaaki pì Dii Malaika pì è, à kùɛ kↄ̃n Balamuo. Ben Balamu pↄ fɛ̃̀ à à lɛ̀ gòo. ");
INSERT INTO bus_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Ben Dii zaaki pì gbà lɛ́ à yã ò Balamunɛ à bè: Bↄ́n má kɛ̀nnɛ n ma lɛ ai gɛ̃̀n aagↄ̃ↄ? ");
INSERT INTO bus_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balamu wèàla à bè: Kɛ̀ n yↄ̃nkↄyã kɛ̀mɛ yãnzimɛ. Tó má fɛ̃ɛ kũna, lɛ ma n dɛ gↄ̃ↄ. ");
INSERT INTO bus_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Ben zaaki pì bènɛ: N zaaki kɛ̀ nɛɛ̀gↄ̃ diia gurↄ sãnda píngia mↄna gbã̀an ma ũroo? Má kɛ̀nnɛ lɛ zikiↄ́? À bè: Auo. ");
INSERT INTO bus_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Ben Dii Balamu wɛ́ɛ kɛ̃̀nɛ, à à Malaika è zɛna zɛ́n à fɛ̃ɛdaa wòto à kũna. Ben à kùɛ à mì pɛ̀ɛ. ");
INSERT INTO bus_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Dii Malaika à là à bè: Bↄ́yãnzin n n zaaki lɛ̀ ai gɛ̃̀n aagↄ̃zi? Ma mↄ zɛ́ zↄ̃nnɛmɛ, zaakɛ n wãmɛ. ");
INSERT INTO bus_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Kɛ̀ zaaki pì ma e, ben à lìɛmɛ ai gɛ̃̀n aagↄ̃. Tó èe liɛmɛ yãro, lɛ ma n dɛ ma à tò. ");
INSERT INTO bus_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balamu bè Dii Malaika pìnɛ: Ma durun kɛ̀, zaakɛ má dↄ̃ kɛ̀ n zɛ́ zↄ̃̀mɛro. Zaakɛ ma gana kɛ̀nnɛ zaa, mɛ́ ɛara mà tá. ");
INSERT INTO bus_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ben Dii Malaika bè Balamunɛ: Ǹ gá kↄ̃n gbɛ̃ pìnↄ, yã kɛ̀ mɛ́ dannɛɛn ǹ o. Ben Balamu gàa kↄ̃n Balaki kínɛ pìnↄo. ");
INSERT INTO bus_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Kɛ̀ Balaki mà Balamu e mↄↄ, ben à gàa à dààlɛ wɛ́tɛ kɛ̀ kú Anↄ baa, Mↄabunↄ bùsu lɛ́zɛkiia. ");
INSERT INTO bus_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Ben à bè Balamunɛ: Kɛ̀ ma gbɛ̃nↄ zĩ̀ wà n sísi yã, à kɛ̀ dia nɛ́ɛ mↄ́roo? Mɛ́ fↄ̃ mà gbaa kɛnnɛnloo? ");
INSERT INTO bus_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balamu wèàla à bè: Ma mↄ sa, mↄde má yã sãnda píngi ona zɛ́ vĩro. Yã kɛ̀ Luda é damɛɛn mɛ́ o. ");
INSERT INTO bus_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Ben Balaki gàa kↄ̃n Balamuo Kiria'uzo. ");
INSERT INTO bus_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","À saa ò kↄ̃n zùnↄ kↄ̃n sãanↄ à à nↄ̀bↄ kpà Balamua kↄ̃n kínɛ kɛ̀ aↄ̃ↄ kúo lɛdoonↄ. ");
INSERT INTO bus_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Kɛ̀ guu dↄ̀, à Balamu sɛ̀ à gàao Bamↄ Baali. Gwen Balamu Isarailinↄ bùra kpadoo èn. ");
INSERT INTO bus_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balamu bè Balakinɛ: Ǹ gbãgbãkii bomɛ kɛ̀ mɛ̀n swɛɛplaa, ǹ mↄ́mɛ kↄ̃n zùswareenↄ mɛ̀n swɛɛplaa kↄ̃n sãkaronↄ mɛ̀n swɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaki kɛ̀ lán Balamu ònɛ nà, ben aↄ̃ saa ò kↄ̃n zùswareeo kↄ̃n sãkaroo gbãgbãkii pìnↄa píngi. ");
INSERT INTO bus_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Ben Balamu bènɛ: Ǹ zɛ n sa'opↄzi. Mɛ́ gá mà gwa tó Dii é mↄ́ yã omɛ, mɛ́ yã kɛ̀ eé omɛɛ onnɛ. Ben à gàa à zɛ̀ gu lezĩ gbáagbaaa. ");
INSERT INTO bus_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Luda mↄ̀ à à lè, ben Balamu bènɛ: Ma gbãgbãkii bò mɛ̀n swɛɛplaa, ben ma saa òḿma píngi kↄ̃n zùswareeo kↄ̃n sãkaroo. ");
INSERT INTO bus_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Dii yã dànɛ à lɛ́n, ben à bè: Ǹ ɛara ǹ gá ǹ Balaki le ǹ onɛ lán má dànnɛ nà. ");
INSERT INTO bus_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ben à ɛ̀ara à gàa à à lè zɛna a sa'opↄzi kↄ̃n Mↄabu kínɛnↄ ń píngi, ");
INSERT INTO bus_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","ben à yã kɛ̀ à è ò à bè: Mↄabunↄ kí Balaki ma sisi Siria bùsun, ben ma bↄ ↄfãntɛ̃bↄɛ kpa kpiiinↄ kiia ma mↄ. À bè mà bↄare Isarailinↄ kpɛɛ, mà mↄ́ mà sa zaaa oare Yakubu borii pìnↄnɛ. ");
INSERT INTO bus_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Mɛ́ kɛ dia mà gbɛ̃ kɛ̀ Luda e ń károonↄ káa? Mɛ́ kɛ dia mà bↄ gbɛ̃ kɛ̀ Dii e bↄ ń kpɛɛroonↄ kpɛɛɛ? ");
INSERT INTO bus_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Zaa kpii mìsↄ̃ntɛ̃an mɛ́ɛ ń ee, zaa gulezĩan mɛ́ɛ wɛ́ɛ siińlɛ. Gbɛ̃ pìnↄↄ kú ńdona, aↄ̃ ń zĩnda dìɛ ńdona kↄ̃n bori pãndenↄ. ");
INSERT INTO bus_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Yakubu boriinↄↄ pari lán bùsu'ãatɛ̃ bà, weé fↄ̃ wà Isarailinↄ naro wà ń lɛ́ dↄ̃ro. Luda tó ma gaa gↄ̃ dɛ lán a gbɛ̃nↄ pↄ́ bà, ma yãana gↄ̃ dɛ lán ń pↄ́ bà. ");
INSERT INTO bus_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Ben Balaki bènɛ: Ń kɛ̀mɛ dian gwee? Ma mↄnyo lɛ ǹ ma ibɛɛnↄ kámɛ, ben sa maaan ń òńnɛↄ́? ");
INSERT INTO bus_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","À wèàla à bè: Yã kɛ̀ Dii dàmɛ ma lɛ́nn mɛ́ oroo? ");
INSERT INTO bus_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balaki bènɛ: Ǹ mↄ́ wà gá gu pãndea, guu kɛ̀ nɛ́ ń en. Ǹ ń kámɛ gwe, zaakɛ aↄ̃ kpadoon nɛ́ e, nɛ́ ń e ń píngiro. ");
INSERT INTO bus_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Ben à gàao gudãkparinↄ guun Pisiga kpii mìsↄ̃ntɛ̃a. À gbãgbãkii bò gwe mɛ̀n swɛɛplaa, ben à saa òḿma píngi kↄ̃n zùswareeo kↄ̃n sãkaroo. ");
INSERT INTO bus_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Ben Balamu bènɛ: Ǹ zɛ n sa'opↄzi kɛ̀, mɛ́ gá mà à le gwe. ");
INSERT INTO bus_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Ben Dii mↄ̀ à yã dànɛ à lɛ́n, ben à bènɛ: Ǹ ɛara ǹ gá ǹ Balaki le ǹ onɛ lán má dànnɛ nà. ");
INSERT INTO bus_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Ben à ɛ̀ara à gàa à à lè zɛna a sa'opↄzi kↄ̃n Mↄabu kínɛnↄo. Balaki à là à bè: Dii bè diamɛ? ");
INSERT INTO bus_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Ben à yã kɛ̀ à è ò à bè: Zipo nɛ́ Balaki, ǹ swã kpá ǹ ma yã ma! ");
INSERT INTO bus_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Luda nɛ́ gbɛ̃nteenlo gbasa à ɛgɛɛ to, è nↄ̀sɛ liɛ lán busãnsi bàro. Eé gí yã kɛ̀ à ò kɛziↄ́? Eé gí lɛ́ kɛ̀ à gbɛ̃̀ńnɛ papaziↄ́? ");
INSERT INTO bus_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","À bèmɛ mà sa maaa ońnɛmɛ. À aubarika dàńgu, mɛ́ fↄ̃ mà gíro. ");
INSERT INTO bus_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Mɛ́ɛ yã zaa ke e Yakubu boriinↄaro, mɛ́ɛ yã'ↄ̃amma ke e Isarailinↄaro. Dii ń Ludaa kúńyo, aↄ̃è à kíkɛ tↄ́ bↄ ń tɛ́. ");
INSERT INTO bus_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Luda ń bↄ́ɛ Igipiti, aↄ̃ gbãaa vĩ lán zùsɛ̃tɛ bà. ");
INSERT INTO bus_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Weé fↄ̃ wà pↄ́ da Yakubu boriinↄaro, weé fↄ̃ wà àisi zaaa kpá Isarailinↄziro. Zaa gbã̀a weégae o ń yã musu, kɛ̀ yã kɛ̀ Ludaa kɛ̀n gwe. ");
INSERT INTO bus_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Borii pì è fɛɛ lán músudaa bà, è a zĩnda sɛ́ lán musukya bà. È daɛro ai à gá pↄ́ kũ à só, ai à gá pↄ́ kɛ̀ à dɛ̀nↄ aru mio. ");
INSERT INTO bus_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balaki bènɛ: Ǹton ń káro. Ǹton sa maaa ońnɛ sero. ");
INSERT INTO bus_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balamu bènɛ: Mɛ́ɛ onnɛ kɛ̀ yã kɛ̀ Dii dàmɛɛn mɛ́ oroo? ");
INSERT INTO bus_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balaki bè Balamunɛ: Ǹ mↄ́ sa, mɛ́ gányo gu pãndea. Wègↄ̃ dↄ̃ro tó eé kɛ Ludanɛ ǹ gbɛ̃ pìnↄ kámɛ gwe sa. ");
INSERT INTO bus_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Ben Balaki gàao Peo kpiii musu kɛ̀ aɛ dↄ gbáaa. ");
INSERT INTO bus_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balamu bènɛ: Ǹ gbãgbãkii bomɛ kɛ̀ mɛ̀n swɛɛplaa, ǹ mↄ́mɛ kↄ̃n zùswareenↄ mɛ̀n swɛɛplaa kↄ̃n sãkaronↄ mɛ̀n swɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaki kɛ̀ lán à ònɛ nà à saa òḿma kↄ̃n zùswaree pìnↄ kↄ̃n sãkaro pìnↄo. ");
INSERT INTO bus_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Kɛ̀ Balamu è sa maa ona Isarailinↄnɛ kà Diin, èe gá màso kɛ lán yãa bà dↄro, ben à aɛ dↄ̀ gbáaa. ");
INSERT INTO bus_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Kɛ̀ à wɛ́ɛ zù, ben à Isarailinↄ è kaɛna ń boriia. Luda Nini pìtaa, ");
INSERT INTO bus_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ben à yã kɛ̀ à è ò à bè: Bɛↄ nɛ́ Balamu yãn yɛ̀, mamↄma kɛ̀ ma wɛ́ɛ kɛ̃na yãn yɛ̀. ");
INSERT INTO bus_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Mamↄma kɛ̀ mɛɛ̀ Luda yã ma yãn yɛ̀. Ma Gbãapingide wɛ́ɛgupu è, má daɛna ma puua, ma wɛ́ɛ wɛ̃na. ");
INSERT INTO bus_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Yakubu boriinↄ bùrakaɛna maa fá! Isaraili bisakutaanↄↄ maa! ");
INSERT INTO bus_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Aↄ̃ kaɛna lán guzurɛ dàkonↄ bà, lán swa dↄ̀rↄ kara búnↄ bà. Aↄ̃ↄ dɛ lán zà lí kɛ̀ Dii bànↄ bà, lán sida lí kɛ̀ aↄ̃ↄ kú í saɛnↄ bà. ");
INSERT INTO bus_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Í é ń orozãnↄ pa yɛ́lɛlɛ, aↄ̃ pↄ́tↄ̃nanↄ é í e maamaa. Aↄ̃ kína gbãaa égↄ̃ dɛ Agagala, aↄ̃ kpata é tↄ́ bↄ. ");
INSERT INTO bus_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Luda ń bↄ́ɛ Igipiti, aↄ̃ gbãaa vĩ lán zùsɛ̃tɛ bà. Aↄ̃è zĩ̀ ble borii kɛ̀ aↄ̃ íbɛtɛ kpàńyonↄa, aↄ̃è ń wánↄ wíwi aↄ̃è ń pápa kào. ");
INSERT INTO bus_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Aↄ̃è sↄ̃pɛɛ wà daɛ lán músu bà, dé bé eé fↄ̃ à ń fɛɛɛ? Luda aubarika da gbɛ̃ kɛ̀ aↄ̃é sa maaa ońnɛnↄn, à gbɛ̃ kɛ̀ aↄ̃é sa zaaa ońnɛnↄ ká. ");
INSERT INTO bus_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balaki pↄ fɛ̃̀ Balamuzi à ↄnɛtee dↄ̀a à bè: Ma ibɛɛnↄ kana yãnzin ma n sisizi, ben n sa maaa òńnɛ gɛ̃̀n aagↄ̃ↄ́? ");
INSERT INTO bus_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Ǹ tá n bɛ tia gↄ̃ↄ. Ma bè mɛ́ gbaa kɛnnɛmɛ yã, mↄde Dii gìnnɛ ǹ láada e. ");
INSERT INTO bus_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balamu bènɛ: Mɛ́ɛ o gbɛ̃ kɛ̀ n ń zĩmaanↄnɛroo! ");
INSERT INTO bus_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Ma bè baa tó n ma gba n bɛɛ kɛ̀ pana kↄ̃n kondogio kↄ̃n vurao, mɛ́ bↄ Dii yã kpɛɛ mà yã kɛ kↄ̃n ma zĩnda pↄyezioro, à maaa ke à zaaa. Yã kɛ̀ Dii bè mà oon mɛ́ o. ");
INSERT INTO bus_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Mɛ́ɛ taa ma gbɛ̃nↄ kiia sa. Ǹ mↄ́ mà onnɛ lán gbɛ̃ pìnↄ é kɛ n gbɛ̃nↄnɛ nà zia. ");
INSERT INTO bus_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Ben Balamu yã kɛ̀ à è ò à bè: Bɛↄ nɛ́ Balamu yãn yɛ̀, mamↄma kɛ̀ ma wɛ́ɛ kɛ̃na yãn yɛ̀. ");
INSERT INTO bus_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Mamↄma kɛ̀ mɛɛ̀ Luda yã ma yãn yɛ̀. Má Luda Musude nↄ̀sɛguuyã dↄ̃. Ma Gbãapingide wɛ́ɛgupu è, má daɛna ma puua, ma wɛ́ɛ wɛ̃na. ");
INSERT INTO bus_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Mɛ́ɛ Isarailinↄ ee, èe kɛ tianlo, mɛ́ɛ ń gwaa, à gurↄↄ e ká gĩaro. Sↄsↄnɛ é bↄ Yakubu boriinↄ tɛ́, kpatableri é bↄ Isarailinↄ tɛ́, eé Mↄabunↄ mì wíwi, eé zↄkakari pìnↄ mìwatoro fↄ̃fↄ̃. ");
INSERT INTO bus_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Ɛdↄmunↄ bùsu é gↄ̃ à pↄ́ ũ, à ibɛɛ Sei bùsu é gↄ̃ à pↄ́ ũ, Isarailinↄ gbãaa égↄ̃ kaaramɛ. ");
INSERT INTO bus_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Yakubu bori ke é kí bleḿma, eé gbɛ̃ kpaaa kɛ̀ aↄ̃ gↄ̃̀nↄ kaatɛ. ");
INSERT INTO bus_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Balamu Amalɛki boriinↄ è, ben à yã kɛ̀ à è ò à bè: Amalɛki boriinↄ nɛ́ boriinↄ mìdeemɛ, mↄde aↄ̃é kaatɛ zãa. ");
INSERT INTO bus_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Kɛ̀ Balamu Keninↄ è, ben à yã kɛ̀ à è ò à bè: A kúkii gbãa gíngin, a sà kú gbɛ̀ musu. ");
INSERT INTO bus_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Baa kↄ̃n beeeo weé a kaatɛmɛ, Asirianↄ é a kũkũ zĩ̀zↄnↄ ũ. ");
INSERT INTO bus_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Balamu yã kɛ̀ à è ò dↄ à bè: O'o, tó Ludaa kɛ̀ lɛ, dé bé eé bↄↄ? ");
INSERT INTO bus_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Góro'itɛnↄ é bↄ Sipiru bùsun, aↄ̃é zĩ̀ ble Asirianↄ kↄ̃n Eberunↄa, mↄde aↄ̃pinↄ é kaatɛmɛ se. ");
INSERT INTO bus_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Balamu fɛ̀ɛ à tà a bɛ, ben Balaki dà zɛ́n se. ");
INSERT INTO bus_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","Tó aubarika kↄ̃n kana yã kɛ̀ má dìɛaree kɛ̀kiinↄ a le píngi, àgↄ̃ dↄn borii kɛ̀ Dii a Luda é pɛ́awa à a fãakↄ̃a ń tɛ́nↄ guu. ");
INSERT INTO bus_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","Tó apinↄ kↄ̃n a nɛ́nↄ ɛ̀ara wà aɛ dↄ̀ Dii a Ludaa, tó a à yã kɛ̀ mɛ́ɛ diɛɛare gbã̀a mà píngi kↄ̃n nↄ̀sɛo do kↄ̃n pↄyezinao, ");
INSERT INTO bus_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","Dii a Luda é a wɛ̃nda gwa, eé ɛara à a kakↄ̃a zaa borii kɛ̀ à a fãakↄ̃a ń tɛ́nↄ guu à suao a gwena ziin. ");
INSERT INTO bus_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","Baa tó à pɛ̀awa à a fãakↄ̃a bùsu kɛ̀ aↄ̃ↄ kú ai anduna lɛ́anↄ guu, eé a boriinↄ kakↄ̃a gwe à suńyo. ");
INSERT INTO bus_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","Eé ɛarańyo bùsu kɛ̀ dɛ aↄ̃ dezinↄ pↄ́ ũu guu. Tó aↄ̃ bùsu pì kũ̀, eé aubarika dańgu, eé tó aↄ̃ pari kũ dɛ ń dezinↄla. ");
INSERT INTO bus_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","Dii a Luda é a swɛ̃̀ pípiare kↄ̃n a boriinↄ, a ninii égↄ̃ yezi kↄ̃n nↄ̀sɛo do lɛ àgↄ̃ kú wɛ̃̀ndio. ");
INSERT INTO bus_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","Dii a Luda é láari kɛ̀kiinↄ zĩ a ibɛɛ kɛ̀ aↄ̃ zàagu aↄ̃ↄe wɛ́ɛ tãaawaanↄa, ");
INSERT INTO bus_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","é ɛara à Dii yã ma àgↄ̃ zĩi kɛɛ kↄ̃n à yãdiɛna kɛ̀ mɛ́ɛ ooare gbã̀anↄo. ");
INSERT INTO bus_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","Dii a Luda é aubarika daagu a zĩ píngin, eé tó a nɛ́nↄ kↄ̃ kↄ̃n a pↄ́kãdeenↄ kↄ̃n a bura pↄ́nↄ. À pↄↄ é ɛara à kɛawa nna, eé à maaa kɛare lán à pↄↄ kɛ̀ nna a dezinↄa nà. ");
INSERT INTO bus_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","Tó a Dii a Luda yã mà a à ↄdↄkii gwà bensↄ̃ á à yãdiɛna kɛ̀ aↄ̃ↄ kú doka takada kɛ̀kii guunↄ kũna, tó a aɛ dↄ̀ Dii a Ludaa kↄ̃n nↄ̀sɛo do kↄ̃n pↄyezinao, eé beeenↄ kɛare píngi. ");
INSERT INTO bus_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","Yã kɛ̀ mɛ́ɛ diɛɛare gbã̀a pì zĩ'ũu dɛ a gbãa lɛ́laro. À sↄ̃ↄ zã̀aoro. ");
INSERT INTO bus_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","À kú ludambɛro, gbasa à be, dé bé eé gá ludambɛ à pitao lɛ à ma à zĩi kɛa. ");
INSERT INTO bus_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","À kú ísiaa baa kãa kparo, gbasa à be, dé bé eé bikũ ísiaa baa à suo lɛ à ma àgↄ̃ kũna. ");
INSERT INTO bus_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","Yã pì kúao kĩikĩi, à kú a lɛ́n kↄ̃n a nↄ̀sɛo lɛ à e à zĩi kɛa. ");
INSERT INTO bus_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","À ma! Mɛ́ɛ wɛ̃̀ndi kↄ̃n yã maaao diɛɛ a are gbã̀a kↄ̃n gaao kↄ̃n yã zaaao. ");
INSERT INTO bus_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","Mɛ́ɛ diɛɛare gbã̀a, àgↄ̃ ye Dii a Ludazi àgↄ̃ tɛ́ à kɛ̀sɛgbɛzi, à à ↄdↄkii gwa àgↄ̃ à yãdiɛnanↄ kↄ̃n à dokayãnↄ kũna, lɛ àgↄ̃ kuu à pari kũ, Dii a Luda é aubarika daagu bùsu kɛ̀ ée gaa sí guu. ");
INSERT INTO bus_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","Mↄde tó a kpɛɛ lìnɛ bensↄ̃ ée à yã maro, tó a kɛ̃a bensↄ̃ a tãanↄ gbã̀gbã a dↄnzi kɛ̀ńnɛ, ");
INSERT INTO bus_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","mɛ́ɛ ooare gbã̀a, a kaatɛn gwe! É gì kɛ bùsu kɛ̀ ée bikũu Yodaa ée gaa sí guuro. ");
INSERT INTO bus_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","Ludambɛ kↄ̃n tↄↄtɛon ma sèedadeenↄ ũ gbã̀a a yã musu. Ma wɛ̃̀ndi kↄ̃n gaao dìɛ a are, aubarika yãnↄ kↄ̃n kana yãnↄ. À wɛ̃̀ndi sɛ́ lɛ apinↄ kↄ̃n a nɛ́nↄ e àgↄ̃ kuu. ");
INSERT INTO bus_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","Àgↄ̃ ye Dii a Ludazi àgↄ̃ à yã maa à naa, zaakɛ àmbe a wɛ̃̀ndi ũ. Eé tó à gì kɛ bùsu kɛ̀ à la dà a dezi Ibraĩ kↄ̃n Isaakuo kↄ̃n Yakubuonↄnɛ, à bè é kpáḿma guu. ");
INSERT INTO bus_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","Kɛ̀ Musa yã kɛ̀kiinↄ ò Isarailinↄnɛ à yã̀a, ");
INSERT INTO bus_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","à bè: Tia la ma ka wɛ̃̀ baswɛɛdo, mɛ́ fↄ̃ mà dↄare aɛ dↄro. Dii bèmɛ mɛ́ bikũ Yodaaro. ");
INSERT INTO bus_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","Dii a Luda bé eé dↄare aɛ à bikũ. Eé borii kɛ̀ aↄ̃ↄ kú gweenↄ kaatɛare lɛ à ń bùsu sí. Yↄsua bé eégↄ̃ dↄↄare aɛ sa lán Dii ò nà. ");
INSERT INTO bus_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","Dii é kɛ borii pìnↄnɛ lán à kɛ̀ Amↄrinↄ kínanↄnɛ nà Siↄ̃ kↄ̃n Oguo kↄ̃n ń bùsuo kɛ̀ à ń káatɛ. ");
INSERT INTO bus_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","Dii é ń naare a ↄzĩ, é kɛńnɛ lán má dìɛare nà píngi. ");
INSERT INTO bus_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","À a làakari kpáɛ àgↄ̃ wↄ́rↄngↄ vĩ! Àton tó vĩa a kũro, àton tó swɛ̃̀ kɛ̃agu ń yãnziro, zaakɛ Dii a Luda bé èe gaaao. Eé a tónlo eé pã kpáaziro. ");
INSERT INTO bus_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","Ben Musa Yↄsua sìsi Isarailinↄ píngi wáa à bènɛ: Ǹ zɛ gbãa ǹgↄ̃ wↄ́rↄngↄ vĩ, zaakɛ ḿbe nɛ́ gá kↄ̃n gbɛ̃ kɛ̀nↄ bùsu kɛ̀ Dii la dà ń dezi káakunↄnɛ à bè é kpáḿma guu. Ḿbe nɛ́ bùsu pì kpaatɛtɛńnɛ. ");
INSERT INTO bus_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","Dii bé eé dↄnnɛ aɛ. Àmbe eégↄ̃ kúnyo, eé n tónlo eé pã kpánzi zikiro. Ǹton tó vĩa n kũro ǹton bídi kɛro. ");
INSERT INTO bus_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","Musa doka pì kɛ̃̀ takada guu à kpà sa'ori Levi borii kɛ̀ aↄ̃ègↄ̃ Dii bà kuunańyo àkpati sɛnanↄa kↄ̃n Isaraili gbɛ̃nsinↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","Musa yã dìɛńnɛ à bè: Wɛ̃̀ swɛɛplaplaaa gbɛra, wɛ̃̀ kɛ̀ wè fĩadeenↄ kɛ̃ Kutadↄna zĩbaagurↄ, ");
INSERT INTO bus_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","tó Isarailinↄ mↄ̀ wà ń zĩnda ↄ̀dↄa Dii ń Ludanɛ ń píngi guu kɛ̀ eé sɛ́ guu, àgae doka takada kɛ̀ki kyó kɛńnɛ wà ma. ");
INSERT INTO bus_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","Àgae ń kakↄ̃a, gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄ kↄ̃n nɛ́ fétenↄ kↄ̃n bↄ̀amↄ kɛ̀ aↄ̃ↄ kú a wɛ́tɛnnↄ, lɛ wà ma wà dada, wà e wàgↄ̃ Dii a Luda vĩa vĩ, wàgↄ̃ dokayã pìnↄ kũna píngi wàgↄ̃ zĩi kɛɛa. ");
INSERT INTO bus_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","Aↄ̃ nɛ́ kɛ̀ aↄ̃ yã pì dↄ̃roonↄ é ma, aↄ̃égↄ̃ vĩakɛna Dii a Ludanɛ dadaa gurↄↄ kɛ̀ á kú bùsu kɛ̀ ée bikũu Yodaa à gá sí pì guu. ");
INSERT INTO bus_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","Dii bè Musanɛ: N gagurↄↄ kà kĩi. Ǹ Yↄsua sísi à gá zɛ dakↄ̃rɛkiia, mɛ́ zĩi nanɛ a ↄzĩ. Ben Musa kↄ̃n Yↄsuao gàa wà zɛ̀ dakↄ̃rɛkiia. ");
INSERT INTO bus_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","Dii bↄ̀ à mↄ̀ńzi gwe tɛ́luguu kɛ̀ zɛna kutaa pì kpɛɛlɛ guu. ");
INSERT INTO bus_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","Ben Dii bè Musanɛ: Tó n ka n dezinↄla, gbɛ̃ pìnↄ é fɛɛ wà pãpãa kɛ wà dↄ bùsu kɛ̀ aↄ̃ↄe gɛ̃ɛn tãanↄzi. Aↄ̃é pã kpámazi aↄ̃ ma bà kuunańyo yã gboro. ");
INSERT INTO bus_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","Zĩ pìa mɛ́ pↄ fɛ̃ńzi mà pã kpáńzi, mɛ́ kpɛɛ lińnɛ wà ń kaatɛ. Kisianↄ é wí ń musu bíta aↄ̃é nawɛ̃anↄ kɛ. Zĩ pìa aↄ̃é be: Kisia pìnↄ wì wa musu kɛ̀ wa Ludaa kúwaoro yãnzin yee? ");
INSERT INTO bus_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","Zĩ pìan mɛ́ kpɛɛ lińnɛ yã zaaa kɛ̀ aↄ̃ↄ kɛ̀ yãnzi, aↄ̃ aɛ dↄ̀ tãanↄa. ");
INSERT INTO bus_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","Ǹ lɛ̀ kɛ̀kii kɛ̃ takadan sa ǹ dada Isarailinↄnɛ aↄ̃ sí, lɛ àgↄ̃ dɛmɛ aↄ̃ bↄna ma kpɛɛ sèeda ũ. ");
INSERT INTO bus_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","Tó ma gaańyo bùsu kɛ̀ má la dà ń dezi káakunↄnɛ guu, bùsu kɛ̀ zwi kↄ̃n zↄ́'io din pì, tó aↄ̃ kã̀ wà mɛ̀ kpà, aↄ̃é aɛ dↄ tãanↄamɛ wà ń gbãgbã. Aↄ̃é pã kpámazi wà ma bà kuunańyo yã gboro. ");
INSERT INTO bus_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","Tó kisia pìnↄ ń lé bíta aↄ̃ↄe nawɛ̃a kɛɛ, lɛ̀ pì bé eé ń yã zaaa káńnɛ ń ↄzĩ, zaakɛ à yã é sã ń boriinↄnlo. Má yã kɛ̀ kú ń nↄ̀sɛn gbã̀a dↄ̃ ai màgↄ̃ gáńyo bùsu kɛ̀ má la dàńnɛ guu. ");
INSERT INTO bus_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","Musa lɛ̀ pì kɛ̃̀ takadan zĩ pìa, ben à dà Isarailinↄnɛ. ");
INSERT INTO bus_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","Dii yã dìɛ Nuni nɛ́ Yↄsuanɛ à bè: Ǹ làakari kpáɛ ǹgↄ̃ wↄ́rↄngↄ vĩ! Ḿbe nɛ́ gá kↄ̃n Isarailinↄ bùsu kɛ̀ má la dàńnɛ guu, bensↄ̃ mapi mɛ́gↄ̃ kúnyo. ");
INSERT INTO bus_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","Kɛ̀ Musa dokayã pìnↄ kɛ̃̀ takadan à yã̀a píngi, ");
INSERT INTO bus_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","à yã dìɛ Levi borii kɛ̀ aↄ̃ègↄ̃ Dii bà kuunańyo àkpati sɛnanↄnɛ à bè: ");
INSERT INTO bus_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","À doka takada kɛ̀kii sí à diɛ Dii a Luda bà kuunaao àkpati saɛ, àgↄ̃ kú gwe a bↄna Dii kpɛɛ sèeda ũ. ");
INSERT INTO bus_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","Zaakɛ má a swãgbãaa dↄ̃, lán eè gí yãzi nà. Zaa gurↄↄ kɛ̀ má kúao eègↄ̃ bↄↄ Dii yã kpɛɛmɛ ai kↄ̃n à tiaao. Weé ma gaa gbɛra pↄ́ o dↄↄ́? ");
INSERT INTO bus_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","À a bori gbɛ̃nsinↄ kↄ̃n a dↄn'aɛdeenↄ kakↄ̃amɛ, lɛ mà yã kɛ̀nↄ dańnɛ ń swãla, ludambɛ kↄ̃n tↄↄtɛo égↄ̃ dɛ ma sèedadeenↄ ũ a yã musu. ");
INSERT INTO bus_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","Zaakɛ má dↄ̃ kɛ̀ é a zĩnda yaka ma gaa gbɛra, é kɛ̃ zɛ́ kɛ̀ má ↄ̀dↄaareea. Beee gbɛra kisia é a le, zaakɛ é yã kɛ̀ zaa Diinɛ kɛ, eé pↄ fɛ̃azi tãa kɛ̀ á kɛ̀nↄ yãnzi. ");
INSERT INTO bus_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","Ben Musa lɛ̀ pì yã dà Isaraili kɛ̀ aↄ̃ kakↄ̃ananↄnɛ ń swãla mámmam. ");
INSERT INTO bus_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","Musa bↄ̀ Mↄabunↄ bùsu sɛ̃̀tɛ à dìdi Nɛbo kpiiia ai Pisiga kpii mìsↄ̃ntɛ̃ kɛ̀ aɛ dↄ Yɛrikoa, ben Dii bùsu pì ↄ̀dↄanɛ píngi zaa Giliada bùsun ai Daninↄ bùsun ");
INSERT INTO bus_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","kↄ̃n Nafatalinↄ bùsuo píngi kↄ̃n Ɛflaimunↄ bùsuo kↄ̃n Manasenↄ bùsuo kↄ̃n Yudanↄ bùsuo píngi ai ísiaa kɛ̀ kú ↄfãntɛ̃gɛ̃kpɛn kpa ");
INSERT INTO bus_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","kↄ̃n Nɛgɛvio kↄ̃n Yɛriko daminalide guzurɛo ai Zoa. ");
INSERT INTO bus_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","Ben Dii bènɛ: Bùsu kɛ̀ ma la dà Ibraĩnɛ kↄ̃n Isaakuo kↄ̃n Yakubuo ma bè mɛ́ kpá ń boriinↄa pìn gwe. Má tò n wɛ́ɛ sìàlɛ, mↄde nɛ́ bikũ Yodaa ǹ gɛ̃nlo. ");
INSERT INTO bus_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Ben Dii zↄ̀bleri Musa gà Mↄabunↄ bùsun gwe lán Dii ò nà. ");
INSERT INTO bus_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","Ben Dii à vĩ̀i guzurɛn gwe Bɛtɛpeo kpa. Gbɛ̃kee à mira kii dↄ̃ro ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","Musa gà a wɛ̃̀ baswɛɛdodee guumɛ. À wɛ́ɛ nna bensↄ̃ à gbãaa e lagoro. ");
INSERT INTO bus_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","Isarailinↄ à gɛ̀ kɛ̀ gurↄ baaakuri Mↄabunↄ bùsu sɛ̃̀tɛ, ben à gɛ̀sosobikɛna kↄ̃n ↄ́ↄ dↄↄo yã̀a. ");
INSERT INTO bus_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","Nuni nɛ́ Yↄsua pana ↄ̃ndↄ̃ↄo kɛ̀ Musa ↄ nàa yãnzi. Isarailinↄ à yã mà, aↄ̃ↄ kɛ̀ lán Dii dà Musanɛ nà. ");
INSERT INTO bus_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","Annabi kee e bↄ Isarailinↄ guu lán Musa bà dↄro. È yã o kↄ̃n Diio tɛ̃tɛ̃ntɛ̃ ");
INSERT INTO bus_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","bensↄ̃ à sèedanↄ kↄ̃n dabuyã kɛ̀ Dii à zĩ̀onↄ kɛ̀ Igipiti, Fili'auna kↄ̃n a ìbanↄ kↄ̃n a gbɛ̃nↄ aɛ ń píngi. ");
INSERT INTO bus_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","Gbɛ̃kee e yã naaside bíta kɛ kↄ̃n iko gbãaao lán Musa bà Isarailinↄ wɛ́ɛ sìàlɛ dↄro. ");
INSERT INTO bus_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Dii zↄ̀bleri Musa gaa gbɛra Dii yã ò Musa kpàasi Yↄsua, Nuni nɛ́nɛ à bè: ");
INSERT INTO bus_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","Ma zↄ̀bleri Musa gà. Ǹ fɛɛ ǹ bikũ Yodaa kɛ̀ sa, mpi kↄ̃n Isarailinↄ ń píngi, à gɛ̃ bùsu kɛ̀ má kpàawaan. ");
INSERT INTO bus_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Guu kɛ̀ a gbá pɛ̀ɛn píngi, má kpàawa lán má ò Musanɛ nàmɛ. ");
INSERT INTO bus_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Sɛna zaa gbáan ai gana Lɛbanↄ bùsun, sɛna zaa swa bíta kɛ̀ wè be Yuflati ai gana ísiaa kɛ̀ kú ↄfãntɛ̃gɛ̃kpɛn kpa, Itinↄ bùsu pì é gↄ̃ a bùsu ũ píngimɛ. ");
INSERT INTO bus_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Ai ǹ gá gao gbɛ̃ke é e à n gã̀sã fĩro. Lán má kú kↄ̃n Musao nà, lɛn mɛ́gↄ̃ kúnyo lɛ. Mɛ́ n tónlo, mɛ́ pã kpánzi zikiro. ");
INSERT INTO bus_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Ǹ zɛ gbãa ǹgↄ̃ wↄ́rↄngↄ vĩ, zaakɛ ḿbe nɛ́ bùsu kɛ̀ ma à lɛ́ gbɛ̃̀ a dezi káakunↄnɛ ma bè mɛ́ kpáḿma sí ǹ kpá gbɛ̃ kɛ̀nↄa. ");
INSERT INTO bus_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Ǹ zɛ gbãa ǹgↄ̃ wↄ́rↄngↄ vĩ dé! Ǹ làakari dↄ doka kɛ̀ ma zↄ̀bleri Musa dànnɛɛa ǹgↄ̃ kũna píngi. Ǹton kɛ̃a ǹ na ↄplazi ke ↄzɛziro, n tá égae kɛ nna. ");
INSERT INTO bus_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Ǹ tó Musa doka takada pì yã gↄ̃ da n lɛ́n, ǹgↄ̃ laasuu lɛɛa fãantɛ̃ kↄ̃n gwãavĩo. Ǹ làakari dↄ yã kɛ̀ kú à guunↄa píngi ǹ zĩi kɛa, n tá égↄ̃ nna n yã égae bↄ maa. ");
INSERT INTO bus_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Mámbe ma yã dìɛnnɛroo? Ǹ zɛ gbãa ǹgↄ̃ wↄ́rↄngↄ vĩ. Ǹton tó vĩa n kũro. Ǹton bídi kɛro, zaakɛ mamↄma Dii n Luda, mɛ́gↄ̃ kúnyo guu kɛ̀ nɛ́ɛ gaan píngi. ");
INSERT INTO bus_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Ben Yↄsua bè Isaraili dↄn'aɛdeenↄnɛ: ");
INSERT INTO bus_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","À gɛ̃tɛ bùran à o gbɛ̃nↄnɛ aↄ̃ kũsãɛ soru kɛ, zaakɛ gurↄ aagↄ̃ↄ gbɛra aↄ̃é bikũ Yodaa kɛ̀, aↄ̃é gá bùsu kɛ̀ Dii ń Ludaa kpàḿma wàgↄ̃ vĩ sí. ");
INSERT INTO bus_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Yↄsua bè Rubɛninↄnɛ kↄ̃n Gadanↄ kↄ̃n Manasenↄ kpadooo: ");
INSERT INTO bus_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","À dↄ yã kɛ̀ Dii zↄ̀bleri Musa dìɛaree kɛ̀kiin, à bè Dii a Luda é tó à kámmabokii e à bùsu kɛ̀kii kpàawa. ");
INSERT INTO bus_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Beee yãnzi a nↄgbɛ̃nↄ kↄ̃n a nɛ́ fétenↄ kↄ̃n a pↄ́kãdeenↄ gↄ̃ bùsu kɛ̀ Musa kpàawaan Yoda baa kɛ̀ kpa, a zĩ̀kpɛɛnↄ dↄ ń gbɛ̃nↄnɛ aɛ wà bikũ ń píngi, aↄ̃gↄ̃ ń gↄ̃kɛbↄnↄ kũna aↄ̃ dↄńlɛ ");
INSERT INTO bus_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","ai Dii gↄ̃ tó a gbɛ̃nↄ kámmabokii e lán à kɛ̀are nà, aↄ̃pinↄ sↄ̃ égↄ̃ bùsu kɛ̀ Dii a Ludaa e kpaaḿma vĩ. Beee gbɛra é su bùsu kɛ̀ gↄ̃̀ a pↄ́ ũu kɛ̀ guu, é vɛ̃ɛ bùsu kɛ̀ Dii zↄ̀bleri Musa kpàawa Yoda baa kɛ̀ ↄfãntɛ̃bↄɛ kpaa pìn. ");
INSERT INTO bus_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Ben aↄ̃ wèàla wà bè: Yã kɛ̀ ń dìɛwe píngi wé kɛ. Guu kɛ̀ n wa zĩin píngi wé gámɛ. ");
INSERT INTO bus_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Lán wa zĩi kɛ̀ Musa yãa nà píngi, lɛn wé zĩi kɛ n yãa lɛ se. Dii n Luda gↄ̃ kúnyo, lán à kú kↄ̃n Musao nà. ");
INSERT INTO bus_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Gbɛ̃ kɛ̀ bↄ̀ n yã kpɛɛ à gì yã kɛ̀ ń dìɛnɛ kɛzi, adee gàmɛ. Ǹ zɛ gbãa ǹgↄ̃ wↄ́rↄngↄ vĩ dé! ");
INSERT INTO bus_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Zaa Sitimu Nuni nɛ́ Yↄsua gu'asiigwarinↄ zĩ̀ gↄ̃ↄn plaa asii guu à bè: À gá à wɛ́ɛ kpáɛ bùsu pìzi, atɛ̃nsa Yɛriko. Ben aↄ̃ gàa gwe, aↄ̃ gàa wà pìta kaarua kɛ̀ wè sísi Rahabu bɛɛn. ");
INSERT INTO bus_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Ben wà bè Yɛriko kínanɛ: Isaraili kenↄ gɛ̃̀ kɛ̀ uusiɛa lɛ wà wa bùsu asii gwa. ");
INSERT INTO bus_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Ben kína pì gbɛ̃nↄ zĩ̀ Rahabua aↄ̃ bè: Ǹ bↄ kↄ̃n gↄ̃gbɛ̃ kɛ̀ aↄ̃ mↄ̀ n kiianↄ, zaakɛ wa bùsu píngi asii gwana yãnzin aↄ̃ mↄ̀zi. ");
INSERT INTO bus_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","Àɛ sↄ̃ nↄgbɛ̃ pì gĩakɛ à gↄ̃ↄn plaaa pìnↄ ùtɛ kↄ̀, ben à bè: Gbɛ̃ pìnↄ mↄ̀ ma kiia kɛ̀ yãpura. Má dↄ̃ guu kɛ̀ aↄ̃ bↄ̀nlo. ");
INSERT INTO bus_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","Kɛ̀ guu sì bĩizɛtatagurↄ, aↄ̃ bↄ̀ɛ. Má dↄ̃ tó mákpan aↄ̃ tànlo. À ń gbɛ̀ sɛ́ kpakpaa, é ń le. ");
INSERT INTO bus_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","Àɛ sↄ̃ à gĩakɛ à ń sɛ́ à gàańyo kpɛ́ musu à ń útɛ gbↄ̃̀ↄ lí kɛ̀ kaɛna gween kↄ̀. ");
INSERT INTO bus_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Zĩ̀rinↄ pɛ̀ɛńzi zɛ́n ai Yoda bikũkiia, ben wà bĩizɛ tàta ń kpɛɛ gↄ̃ↄ. ");
INSERT INTO bus_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Ai gu'asiigwari pìnↄ gↄ̃ daɛ, Rahabu dìdi ń kiia kpɛ́ musu ");
INSERT INTO bus_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","à bèńnɛ: Má dↄ̃ kɛ̀ Dii bùsu kɛ̀ kpàawa. A vĩa wa kũ, ben bùsu kɛ̀ deenↄ kã gà ń píngi a yãnzi. ");
INSERT INTO bus_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Wa mà lán Dii Isia Tɛ̃aa zↄ̃̀kↄ̃rɛare nà gurↄↄ kɛ̀ a bↄɛ Igipiti kↄ̃n yã kɛ̀ á kɛ̀ Siↄ̃ kↄ̃n Oguonɛ, a Amↄrinↄ kína gↄ̃ↄn plaaa pìnↄ kɛ̀ dúgudugu Yoda baa kãa kpa. ");
INSERT INTO bus_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Kɛ̀ wá mà, swɛ̃̀ kɛ̃̀wagu, wa ninii dà batan a yãnzi, zaakɛ Dii a Ludan musu kↄ̃n tↄↄtɛo Luda ũ. ");
INSERT INTO bus_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","Zaakɛ ma gbɛ̃kɛɛ kɛ̀are, apinↄ sↄ̃ à símɛ sa kↄ̃n Dii tↄ́o kɛ̀ é gbɛ̃kɛɛ kɛ ma de bɛdeenↄnɛ. À sèeda kɛmɛ lɛ màgↄ̃ dↄ̃ sãnsãn ");
INSERT INTO bus_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","kɛ̀ é ma de kↄ̃n ma dao kↄ̃n ma vĩ̀inↄ kↄ̃n ma dãaronↄ kↄ̃n wa gbɛ̃nↄ mì sí ń píngi à wa bↄ gaa lɛ́zĩ. ");
INSERT INTO bus_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Ben gↄ̃gbɛ̃ pìnↄ wèàla wà bè: Ḿbe wa wɛ̃̀ndi ũ, wámbe n wɛ̃̀ndi ũ se. Tó nɛ́ɛ wa yã o gbɛ̃kee màro, tó Dii bùsu kɛ̀ kpàwa, wé gbɛ̃kɛɛ kɛnnɛ yãpura. ");
INSERT INTO bus_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Ben à ń bↄ́ɛ windo guu à ń píta bĩi kpɛɛ kↄ̃n bào, zaakɛ à bɛɛ kɛ̀ à kún kú wɛ́tɛ bĩi musumɛ. ");
INSERT INTO bus_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","À bèńnɛ: À mì pɛ́ kpiiinↄa lɛ a gbɛ̀sɛrinↄ tón dakↄ̃rɛaoro yãnzi. Àgↄ̃ utɛna gwe gurↄ aagↄ̃ ai a gbɛ̀sɛrinↄ su, é gbasa à da zɛ́n. ");
INSERT INTO bus_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","18","Ben gↄ̃gbɛ̃ pìnↄ bènɛ: Tó wa ɛara wa gɛ̃ a bùsun, ǹ wↄ̃ↄ tɛ̃aa kɛ̀kii dↄ windo kɛ̀ nɛ́ɛ wa bↄɛɛn kɛ̀a, ǹ n de kↄ̃n n dao kↄ̃n n vĩ̀inↄ kↄ̃n n dãaronↄ kↄ̃n n de bɛdeenↄ kakↄ̃anzi ń píngi n kpɛ́ kɛ̀kiin. Tó nɛ́ɛ kɛ lɛro, wa bà égↄ̃ kú ladana kɛ̀ ń tò wá la dànnɛɛn dↄro. ");
INSERT INTO bus_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Tó aↄ̃ gbɛ̃ke bↄ̀ n kpɛ́n à gàa gãalɛ, à a zĩnda dɛ̀n gwe, wa yãn dↄro. Tó aↄ̃ gbɛ̃kee kúnyo kpɛ́n, ben wà à dɛ̀, wámbe à gana yã é wí wa musu. ");
INSERT INTO bus_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Tó n wa kↄmↄtↄ kɛ̀ gbɛ̃nↄnɛ sↄ̃, wa bà égↄ̃ kú ladana kɛ̀ ń tò wá la dànnɛɛ pìn dↄro. ");
INSERT INTO bus_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Ben Rahabu bè: Àgↄ̃ dɛ lán á ò nà. Ben à ń gbáɛ aↄ̃ tà. Ben à wↄ̃ↄ tɛ̃aa pì dↄ̀ a windoa. ");
INSERT INTO bus_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Kɛ̀ aↄ̃ pìta bĩia lɛ, aↄ̃ mì pɛ̀ kpiiinↄa, ben aↄ̃ ì gwe gurↄ aagↄ̃ ai ń gbɛ̀sɛrinↄ gàa sùo. Aↄ̃ gbɛ̀sɛri pìnↄ ń wɛ́tɛ zɛ́ saɛ píngi aↄ̃ↄe ń ero. ");
INSERT INTO bus_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Ben gↄ̃ↄn plaaa pìnↄ dà zɛ́n aↄ̃ pìta kpiii pìnↄa aↄ̃ bikũ̀ swaaa. Kɛ̀ aↄ̃ kà Nuni nɛ́ Yↄsua kiia, aↄ̃ yã kɛ̀ à ń lé gbã̀nɛ píngi ");
INSERT INTO bus_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","wà bè: Dii bùsu pì nàwe wa ↄzĩ píngi. Bùsu pì deenↄ kã gà ń píngi wa yãnzi. ");
INSERT INTO bus_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Yↄsua fɛ̀ɛ kↄngↄ idɛ'idɛ kↄ̃n Isarailinↄ ń píngi. Bↄna Sitimu aↄ̃ gàa Yodazi, ben aↄ̃ bùra kàɛ gwe ai aↄ̃gↄ̃ gá bikũ. ");
INSERT INTO bus_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Gurↄ aagↄ̃ↄ gbɛra Isaraili dↄn'aɛdeenↄ dↄ̀dↄ bùrazi ");
INSERT INTO bus_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","aↄ̃ yã dìɛ gbɛ̃nↄnɛ wà bè: Tó á è Levi bori sa'orinↄ Dii a Luda bà kuunawao àkpati sɛna, à da zɛ́n àgↄ̃ tɛ́ ń kpɛɛ, ");
INSERT INTO bus_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","lɛ à e à dↄ̃ zɛ́ kɛ̀ é sɛ́, zaakɛ ée zɛ́ pì sɛ́ zikiro. Àgↄ̃ tɛ́ zã̀azã lán kiloo do taka bàↄↄ! Àton sↄ̃ àkpati pìziro. ");
INSERT INTO bus_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Ben Yↄsua bè gbɛ̃nↄnɛ: À gbãsĩ bↄ a zĩndan, zaakɛ Dii é yãbↄnsaɛ kɛ a tɛ́ zia. ");
INSERT INTO bus_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Ben à ɛ̀ara à bè sa'orinↄnɛ: À Dii bà kuunawao àkpati sɛ́ à dↄ gbɛ̃nↄnɛ aɛ à bikũo. Ben aↄ̃ àkpati pì sɛ̀ wà dↄ̀o gbɛ̃nↄnɛ aɛ. ");
INSERT INTO bus_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Dii bè Yↄsuanɛ: Mɛ́ na n sɛna lezĩa Isarailinↄnɛ gbã̀a, aↄ̃égↄ̃ dↄ̃ kɛ̀ má kúnyo lán má kú kↄ̃n Musao nà. ");
INSERT INTO bus_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Ǹ o sa'ori kɛ̀ aↄ̃ↄ ma bà kuunaao àkpati sɛnanↄnɛ, tó aↄ̃ kà Yodazi, aↄ̃ gɛ̃ wà zɛ à ín. ");
INSERT INTO bus_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Ben Yↄsua bè Isarailinↄnɛ: À mↄ́ kɛ̀ à Dii a Luda yã ma. ");
INSERT INTO bus_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Ben à ɛ̀ara à bè: Lɛn égↄ̃ dↄ̃ kɛ̀ Luda Wɛ̃̀ndidee kúao lɛ, bensↄ̃ eé pɛ́are Kanaanↄa kↄ̃n Itinↄ kↄ̃n Ivinↄ kↄ̃n Pɛrizinↄ kↄ̃n Gigasinↄ kↄ̃n Amↄrinↄ kↄ̃n Yebusinↄo. ");
INSERT INTO bus_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","À gwa! Anduna píngi Dii bà kuunawao àkpati é dↄare aɛ ai Yoda ín. ");
INSERT INTO bus_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","À gↄ̃ↄn kuri awɛɛplaaanↄ sɛ́ a tɛ́, bori kↄ̃n boriio gbɛ̃ mɛ̀n doodo. ");
INSERT INTO bus_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Tó sa'ori kɛ̀ aↄ̃ↄ anduna píngi Dii àkpati sɛnanↄ gbá pɛ̀ɛ Yoda ín, í pì é zↄ̃kↄ̃rɛ, í kɛ̀ èe bↄↄ swaa musu é bĩi kɛ à gↄ̃ zɛna a gbɛ̀n. ");
INSERT INTO bus_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Kɛ̀ gbɛ̃nↄ bùra fɛ̀ɛ wà dà zɛ́n, aↄ̃ↄe gaa bikũ Yodaa, sa'ori kɛ̀ aↄ̃ↄ Dii bà kuunańyo àkpati sɛnanↄↄ tɛ́ ń aɛ lɛ. ");
INSERT INTO bus_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","Pↄ́kɛkɛgurↄ píngi swaa pì è pa ai à dà sĩ̀sĩla, mↄde gurↄↄ kɛ̀ àkpatisɛri pìnↄ kà swaa pìzi, kɛ̀ aↄ̃ gbá pɛ̀ɛ ín, ");
INSERT INTO bus_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","ben í kɛ̀ èe bↄↄ swaa pì musu zↄ̃̀kↄ̃rɛ à bĩi kɛ̀ à gↄ̃̀ zɛna a gbɛ̀n zaa zã̀azã wɛ́tɛ kɛ̀ wè be Adamu saɛ Zarɛtã bùsun. Í kɛ̀ èe taa sɛ̀bɛ wisideen zↄ̃̀kↄ̃rɛ míↄmiↄ, ben gbɛ̃nↄ bikũ̀ aɛdↄkↄ̃ana kↄ̃n Yɛrikoo. ");
INSERT INTO bus_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Sa'ori kɛ̀ aↄ̃ↄ Dii bà kuunańyo àkpati sɛnanↄ gↄ̃̀ zɛna Yoda wɛ̀ɛn tↄↄtɛ koria gíngin, ben Isaraili bori píngi tɛ́ gukori pìn ai aↄ̃ gàa wà bikũ̀ ń píngi wà yã̀a. ");
INSERT INTO bus_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Kɛ̀ Isaraili bori píngi bikũ̀ Yodaa wà yã̀a, ben Dii bè Yↄsuanɛ: ");
INSERT INTO bus_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","A bori mɛ̀n kuri awɛɛplaaanↄ tɛ́ à gbɛ̃nↄ sɛ́n doodo ");
INSERT INTO bus_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","ǹ ońnɛ aↄ̃ gbɛ̀ sɛ́ɛ swawɛɛn mɛ̀n kuri awɛɛplaa guu kɛ̀ sa'orinↄↄ zɛn súusu, aↄ̃ bikũo wà káɛ guu kɛ̀ é in gwãavĩa. ");
INSERT INTO bus_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Ben Yↄsua gↄ̃ↄn kuri awɛɛplaaanↄ dìɛ Isaraili boriinↄ tɛ́ doodo, ben à ń sísi ");
INSERT INTO bus_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","à bèńnɛ: À gá Yoda wɛ̀ɛn Dii a Luda àkpati aɛ, a baade gbɛ̀ sɛ́ à di a gã̀n a Isaraili boriinↄ pari lɛ́n. ");
INSERT INTO bus_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","Gbɛ̀ kɛ̀kiinↄ é gↄ̃are sèeda ũ. Tó a nɛ́nↄ a la zia, bↄ́n gbɛ̀ kɛ̀nↄↄ dɛare à ũu, ");
INSERT INTO bus_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","à beńnɛ, kɛ̀ wèe bikũu kↄ̃n Dii bà kuunawao àkpatio, ben à í zↄ̃̀kↄ̃rɛ, ben gbɛ̀ pìnↄ gↄ̃̀ Isarailinↄnɛ à dↄngu pↄ́ ũ ai gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Lɛn Isarailinↄↄ kɛ̀ lɛ lán Yↄsua òńnɛ nà. Aↄ̃ gbɛ̀ sɛ̀ɛ Yoda wɛ̀ɛn mɛ̀n kuri awɛɛplaa Isaraili boriinↄ pari lɛ́n lán Dii ò Yↄsuanɛ nà. Aↄ̃ bikũ̀o aↄ̃ↄ kàɛ guu kɛ̀ aↄ̃ ìn. ");
INSERT INTO bus_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Gbɛ̀ mɛ̀n kuri awɛɛplaaa kɛ̀ wà sɛ̀ɛ swawɛɛn sa'ori kɛ̀ aↄ̃ àkpati sɛna pìnↄ zɛkiian Yↄsua dìdikↄ̃a, aↄ̃ↄ kú gwe ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Sa'ori kɛ̀ aↄ̃ↄ àkpati pì sɛnanↄ gↄ̃̀ zɛna swawɛɛn ai yã kɛ̀ Dii dìɛ Yↄsuanɛ à ò gbɛ̃nↄnɛ gàa à kɛ̀o píngi lán Musa dìɛnɛ nà. Gbɛ̃nↄ kɛ̀ kpaa aↄ̃ bikũ̀. ");
INSERT INTO bus_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","Kɛ̀ aↄ̃ bikũ̀ ń píngi wà yã̀a, gbasa sa'orinↄ bikũ̀ kↄ̃n Dii àkpatio gbɛ̃nↄ wáa. ");
INSERT INTO bus_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Rubɛni bori gↄ̃gbɛ̃nↄ kↄ̃n Gada bori gↄ̃gbɛ̃nↄ kↄ̃n Manasenↄ kpado gↄ̃gbɛ̃nↄ bé wà dↄ̀ Isaraili bori kpaaanↄnɛ aɛ wà bikũ̀ lán Musa òńnɛ yã nà. Aↄ̃ ń gↄ̃kɛbↄnↄ kũna. ");
INSERT INTO bus_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","Aↄ̃ zĩ̀kpɛɛnↄ kà gↄ̃ↄn bↄrↄ baplaa taka. Aↄ̃ bikũ̀ Dii aɛ aↄ̃ gàa Yɛriko gbáan kↄ̃n zĩ̀ soruo. ");
INSERT INTO bus_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Zĩ beeean Dii Yↄsua sɛ̀ lezĩ Isarailinↄnɛ ń píngi, ben aↄ̃ à yã mà ai à gàa à gào lán aↄ̃ Musa yã mà nà. ");
INSERT INTO bus_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Ben Dii bè Yↄsuanɛ: ");
INSERT INTO bus_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","Ǹ o sa'ori kɛ̀ aↄ̃ↄ doka àkpati sɛnanↄnɛ aↄ̃ bↄ swawɛɛn. ");
INSERT INTO bus_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Ben Yↄsua òńnɛ aↄ̃ bↄ swawɛɛn, ");
INSERT INTO bus_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","ben aↄ̃ bↄ̀n. Kɛ̀ aↄ̃ gbá pɛ̀ɛ sĩ̀sĩa, ben swa'i ɛ̀ara à sù a gbɛ̀n gↄ̃ↄ. À pà à dàgula ai à dà sĩ̀sĩla lán káakupↄ bà. ");
INSERT INTO bus_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Mↄ káaku gurↄ kuridee zĩn Isarailinↄ bↄ̀ Yoda swawɛɛn aↄ̃ gàa wà bùra kàɛ Giligala, Yɛriko ↄfãntɛ̃bↄɛ kpa. ");
INSERT INTO bus_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Yↄsua gbɛ̀ mɛ̀n kuri awɛɛplaaa kɛ̀ wà sɛ̀ɛ Yoda wɛ̀ɛn pìnↄ dìdikↄ̃a Giligala gwe. ");
INSERT INTO bus_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","À bè gbɛ̃nↄnɛ: Tó a nɛ́nↄ gà wà ń denↄ là zia wà bè, gbɛ̀ kɛ̀nↄ yáasi dɛ diamɛ? ");
INSERT INTO bus_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","À beńnɛ, a bikũna Yodaa gukoria sèedamɛ, ");
INSERT INTO bus_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","zaakɛ Dii a Luda à í bàbaare a zɛ́n, ben a bikũ̀ lán a bikũ̀ Isia Tɛ̃aa kɛ̀ à à í bàbaareea nà. ");
INSERT INTO bus_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Dii kɛ̀ lɛ, lɛ anduna bori píngi gↄ̃ dↄ̃ kɛ̀ à gbãa vĩ, apinↄ sↄ̃ àgↄ̃ Dii a Luda vĩa vĩ gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Kɛ̀ Amↄrinↄ kína kɛ̀ aↄ̃ↄ kú Yoda ↄfãntɛ̃gɛ̃kpɛn kpaanↄ kↄ̃n Kanaanↄ kína kɛ̀ aↄ̃ↄ kú ísiaa saɛnↄↄ mà lán Dii Yoda í zↄ̃̀kↄ̃rɛ Isarailinↄnɛ aↄ̃ bikũ̀ nà, ben swɛ̃̀ kɛ̃̀ńgu aↄ̃ kã gà ń píngi Isarailinↄ yãnzi. ");
INSERT INTO bus_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Gurↄ beeea Dii bè Yↄsuanɛ: Ǹ gbɛ̀ fɛ̃ɛnↄ kɛ ǹ ɛara ǹ bã̀ngu kɛ Isarailinↄnɛ. ");
INSERT INTO bus_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Ben Yↄsua bè wà gbɛ̀ fɛ̃ɛnↄ kɛ, ben wà bã̀ngu kɛ̀o Isarailinↄnɛ guu kɛ̀ wè be tia Gɛfↄↄ Sĩ̀sĩ. ");
INSERT INTO bus_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","Yã kɛ̀ tò à bã̀ngu kɛ̀ńnɛn yɛ̀. Isarailinↄ bↄɛna Igipiti gbɛra, aↄ̃ tá guu, gↄ̃ gbãaa kɛ̀ aↄ̃ bã̀ngu kɛ̀nↄ gàga gbáan ń píngi. ");
INSERT INTO bus_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","Gbɛ̃ kɛ̀ aↄ̃ bↄ̀ɛ Igipitinↄ bã̀ngukɛna ń píngi. Gbɛ̃ kɛ̀ wà ń í gbáan zɛ́ guu bↄna Igipiti gbɛraanↄ, aↄ̃mbe aↄ̃ↄe bã̀ngu kɛro. ");
INSERT INTO bus_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","Isarailinↄↄ tɛ́ gbáan wɛ̃̀ baplaa ai gbɛ̃ kɛ̀ aↄ̃ↄ dɛ gↄ̃ gbãaanↄ ũ gurↄↄ kɛ̀ aↄ̃ bↄ̀ɛ Igipitinↄ gàa wà gàgao ń píngi, zaakɛ aↄ̃ↄe Dii yã maro. Dii bèńnɛ aↄ̃é wɛ́ɛ si bùsu kɛ̀ a à lɛ́ gbɛ̃̀ ń dezinↄnɛ à bè é kpáḿmalɛro, bùsu kɛ̀ zwi kↄ̃n zↄ́'io din pì. ");
INSERT INTO bus_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Aↄ̃ nɛ́ kɛ̀ Dii tò aↄ̃ fɛ̀ɛ ń gbɛraanↄn Yↄsua bã̀ngu kɛ̀ńnɛ, zaakɛ gɛfↄↄdeenↄmɛ, wèe bã̀ngu kɛńnɛ zɛ́nlo. ");
INSERT INTO bus_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Kɛ̀ Isarailinↄ bã̀ngu kɛ̀ ń píngi wà yã̀a, aↄ̃ gↄ̃̀ guu kɛ̀ aↄ̃ bùra kàɛn gwe ai ń bↄ̀ gàa à yã̀ao. ");
INSERT INTO bus_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Ben Dii bè Yↄsuanɛ: Ma wí kɛ̀ Igipitinↄↄ dàawaa bↄ̀are gbã̀an gwe. Ben wà tↄ́ kpà guu pìnɛ Giligala ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Isarailinↄ bùra kaɛna Giligala ben aↄ̃ Banla zĩbaa kɛ̀ Yɛriko gbáan gwe mↄↄ pì gurↄ gɛ̃ro dosaidee zĩ uusiɛ. ");
INSERT INTO bus_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Kɛ̀ wà zĩbaa pì kɛ̀ guu dↄ̀ aↄ̃ bùsu pì bura pↄ́nↄ blè, burɛdi sɛ́sɛ'ɛ̃zɛ̃sainↄ kↄ̃n pↄ́wɛɛ kpatanao. ");
INSERT INTO bus_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Aↄ̃ bùsu pì bura pↄ́nↄ blena gbɛra, kɛ̀ guu dↄ̀, manakwɛɛna zɛ̀, èe kwɛ́ɛńnɛ dↄro, ben aↄ̃ Kanaa bùsu blɛɛ blè wɛ̃̀ beeea sa. ");
INSERT INTO bus_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Kɛ̀ Yↄsua kà kĩi kↄ̃n Yɛrikoo, à wɛ́ɛ sɛ̀ à guu gwà, ben à gↄ̃gbɛ̃ ke è zɛna a aɛ kↄ̃n fɛ̃ɛdaao na à ↄzĩ. Ben Yↄsua sↄ̃̀zi à à là à bè: Ń kú wa kpɛɛn yↄ́, ke wa ibɛɛnↄ kpɛɛ? ");
INSERT INTO bus_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","À wèàla à bè: Lɛnlo. Dii zĩ̀kpɛɛnↄ dↄn'aɛdeen ma ũ, ma kanan yɛ̀. Ben Yↄsua kùɛnɛ à mì pɛ̀ɛ, ben à à là à bè: Bↄ́n ma Dii é o mamↄma a zↄ̀blerinɛ? ");
INSERT INTO bus_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Dii zĩ̀kpɛɛnↄ dↄn'aɛdee pì wèàla à bè: Ǹ n kyatee bↄbↄ, zaakɛ guu kɛ̀ ń zɛ́n kú adona. Ben Yↄsua kɛ̀ lɛ. ");
INSERT INTO bus_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Wà Yɛriko bĩizɛ gbànↄ tàta gíngin Isarailinↄ yãnzi. Gbɛ̃kee e bↄro, gbɛ̃kee e gɛ̃ro. ");
INSERT INTO bus_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Ben Dii bè Yↄsuanɛ: Ǹ gwa, ma Yɛriko nànnɛ n ↄzĩ kↄ̃n à kínao kↄ̃n à zĩ̀kpɛɛnↄ. ");
INSERT INTO bus_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Mpi kↄ̃n n zĩ̀kpɛɛnↄ à gá liga wɛ́tɛ pìzi gɛ̃̀n do a píngi à su. Àgↄ̃ ligaazi lɛ gɛ̃̀n doodo ai gurↄ swɛɛdo. ");
INSERT INTO bus_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Sa'ori gↄ̃ↄn swɛɛplaaanↄ dↄ àkpatinɛ aɛ aↄ̃gↄ̃ kuu kũna. À gurↄ swɛɛplaadee zĩ à liga wɛ́tɛ pìzi gɛ̃̀n swɛɛplaa gurↄↄ kɛ̀ sa'ori pìnↄↄ e ń kuu pɛɛ. ");
INSERT INTO bus_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Tó aↄ̃ kuu pɛ̀ aↄ̃ↄe à bà gaa, ben a à ↄ́ mà, gbɛ̃ píngi wii lɛ́ gbãngbãn, wɛ́tɛ bĩi é lɛ́ɛ, a baade é sin súusu. ");
INSERT INTO bus_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Ben Nuni nɛ́ Yↄsua sa'orinↄ sìsi à bèńnɛ: À Dii bà kuunawao àkpati sɛ́, a gↄ̃ↄn swɛɛplaaanↄ é dↄnɛ aɛ, a baade égↄ̃ kuu kũna. ");
INSERT INTO bus_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Ben à bè gbɛ̃nↄnɛ: À fɛɛ à gá liga wɛ́tɛzi gɛ̃̀n do. Zĩ̀kpɛɛnↄ bé wà dↄ Dii àkpatinɛ aɛ. ");
INSERT INTO bus_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Kɛ̀ Yↄsua yã ò gbɛ̃nↄnɛ, ben sa'ori gↄ̃ↄn swɛɛplaaa kɛ̀ aↄ̃ kuu kũna pìnↄ fɛ̀ɛ wà dↄ̀ Dii bà kuunańyo àkpatinɛ aɛ, aↄ̃ↄe ń kuu pɛɛ. ");
INSERT INTO bus_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Zĩ̀kpɛɛnↄↄ tɛ́ sa'ori pìnↄ aɛ, parii tɛ́ àkpati kpɛɛ, bensↄ̃ kuunↄ ↄ́ dↄ. ");
INSERT INTO bus_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Yↄsua gĩakɛ à ò gbɛ̃nↄnɛ à bè: Àton wii lɛ́ro. Àton tó wà a kĩi maro. Àton tó yãke bↄ a lɛ́nlo ai gurↄↄ kɛ̀ mɛ́ oare à wii lɛ́, gbasa à lɛ́. ");
INSERT INTO bus_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Aↄ̃ gàa wà lìga wɛ́tɛ pìzi kↄ̃n àkpatio gɛ̃̀n do lɛ, ben aↄ̃ ɛ̀ara wà tà ń bùran aↄ̃ ì gwe. ");
INSERT INTO bus_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Yↄsua fɛ̀ɛ kↄngↄ idɛ'idɛ, ben sa'orinↄ Dii àkpati sɛ̀. ");
INSERT INTO bus_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","Sa'ori gↄ̃ↄn swɛɛplaaa kɛ̀ aↄ̃ kuu kũna pìnↄ dↄ̀ Dii àkpatinɛ aɛ, aↄ̃ↄe pɛɛ. Zĩ̀kpɛɛnↄ dↄ̀ńnɛ aɛ, parii tɛ́ àkpati pì kpɛɛ, bensↄ̃ kuunↄ ↄ́ dↄ. ");
INSERT INTO bus_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Aↄ̃ lìga wɛ́tɛ pìzi gɛ̃̀n do à gurↄ plaadee zĩ, ben aↄ̃ ɛ̀ara wà tà ń bùran. Aↄ̃ↄ kɛ̀ lɛ ai gurↄ swɛɛdo. ");
INSERT INTO bus_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","À gurↄ swɛɛplaadee zĩ aↄ̃ fɛ̀ɛ idɛ'idɛ gudↄnao, ben aↄ̃ ɛ̀ara wà gàa wà lìga wɛ́tɛ pìzi lán aↄ̃è kɛ nà. Mↄde zĩ beeea aↄ̃ lìgazi gɛ̃̀n swɛɛplaamɛ. ");
INSERT INTO bus_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","À gɛ̃̀n swɛɛplaadee pìa gurↄↄ kɛ̀ sa'orinↄↄ e gaa ń kuu pɛ́ gbãngbãn, ben Yↄsua bè gbɛ̃nↄnɛ: À wii lɛ́, zaakɛ Dii wɛ́tɛ pì kpàawamɛ. ");
INSERT INTO bus_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Dii wɛ́tɛ pì kↄ̃n pↄ́ kɛ̀ kúnnↄ dìɛ a pↄ́ ũ. Wà ń kaatɛ ń píngi. Kaarua Rahabu kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ kúo à bɛɛnↄ bé wé bↄ ńtɛ̃ɛ, zaakɛ àmbe à gu'asiigwari kɛ̀ wà ń zĩnↄ ùtɛ. ");
INSERT INTO bus_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","À làakari kɛ! Àton pↄ́ kɛ̀ Dii tɛ̃̀ ke sɛ́ro, lɛ àton kaatɛro yãnzi. Tó á sɛ̀, é yã gáɛ a bùranɛ à gↄ̃ kaatɛna pↄ́ ũ. ");
INSERT INTO bus_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Kondogi kↄ̃n vurao kↄ̃n mↄ̀gotɛ̃ pↄ́nↄ kↄ̃n mↄ̀si pↄ́nↄ píngi nɛ́ Dii pↄ́mɛ. Séde wà ká Dii auziki utɛkiin. ");
INSERT INTO bus_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Kɛ̀ wà kuu pɛ̀ bensↄ̃ Isarailinↄ wii lɛ̀ gbãngbãn lɛ, wɛ́tɛ bĩinↄ lɛ̀ɛ. Ben aↄ̃ baade sìn súusu, ben aↄ̃ wɛ́tɛ pì sì. ");
INSERT INTO bus_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Aↄ̃ pↄ́ kɛ̀ kúnnↄ dìɛ Dii pↄ́ ũ, ben aↄ̃ gbɛ̃nↄ kàatɛ ń píngi kↄ̃n fɛ̃ɛdaao, gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄ, nɛ́ fétenↄ gbɛ̃nsinↄ kↄ̃n zùnↄ kↄ̃n sãanↄ kↄ̃n zaakinↄo. ");
INSERT INTO bus_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Yↄsua bè gↄ̃ↄn plaaa kɛ̀ aↄ̃ gàa wà bùsu pì asii gwànↄnɛ: À gɛ̃ kaarua pì bɛɛn à bↄo kↄ̃n a gbɛ̃nↄ, lán a à lɛ́ gbɛ̃̀nɛ nà. ");
INSERT INTO bus_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Ben gↄ̃kparɛ pìnↄ gàa wà bↄ̀ kↄ̃n Rahabuo kↄ̃n a deo kↄ̃n a dao kↄ̃n a vĩ̀inↄ kↄ̃n a dãaronↄ kↄ̃n a gbɛ̃nↄ ń píngi. Aↄ̃ sùo kↄ̃n à danɛnↄ ń píngi, ben aↄ̃ ń káɛ Isarailinↄ bùra saɛ. ");
INSERT INTO bus_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Ben aↄ̃ tɛ́ sↄ̃̀ wɛ́tɛ pìa kↄ̃n pↄ́ kɛ̀ kúnnↄ píngi, tó èe kɛ kondogi kↄ̃n vurao kↄ̃n mↄ̀gotɛ̃ pↄ́nↄ kↄ̃n mↄ̀si pↄ́ kɛ̀ aↄ̃ↄ sɛ̀ɛ wà kàɛ Dii bisakuta auziki utɛkiin baasiro. ");
INSERT INTO bus_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Yↄsua tò kaarua Rahabu bↄ̀ aafia kↄ̃n à de bɛdeenↄ kↄ̃n à gbɛ̃nↄ ń píngi, kɛ̀ à gu'asiigwari kɛ̀ Yↄsua ń zĩ Yɛriko asii gwaanↄ ùtɛ yãnzi, ben aↄ̃ gↄ̃̀ Isarailinↄ tɛ́ ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Gurↄ beeea Yↄsua lɛ́ kɛ̀ à bè: Dii láari kɛ gbɛ̃ kɛ̀ eé fɛɛ à Yɛriko wɛ́tɛ kɛ̀ kɛkɛ à káɛa. Tó à à bĩi ɛ̃ɛ kpàɛ, à daudu é ga. Tó à à gbànↄ pɛ̀ɛ sↄ̃, à nɛ́ zãadee é ga. ");
INSERT INTO bus_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Dii kú kↄ̃n Yↄsuao, ben à tↄ́ dà bùsu pìla píngi. ");
INSERT INTO bus_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Isarailinↄ tɛ̃̀ pↄ́ kɛ̀. Kaami nɛ́ Akã, Zimiri dio, Zɛra swãkpɛɛ, Yuda borii bé à tɛ̃̀ pↄ́ kenↄ sɛ̀, ben Dii pↄ fɛ̃̀ Isarailinↄzi. ");
INSERT INTO bus_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","Yↄsua gbɛ̃nↄ zĩ̀ à bè, aↄ̃ bↄ Yɛriko wà gá Ai kɛ̀ kú Bɛtavɛ̃ saɛ Bɛtɛli ↄfãntɛ̃bↄɛ kpa lɛ wà bùsu pì asii gwa. Ben aↄ̃ gàa wà Ai asii gwà. ");
INSERT INTO bus_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","Kɛ̀ aↄ̃ sù Yↄsua kiia, aↄ̃ bènɛ: Aideenↄↄ pariro, èe ká wà gá gwe wa píngiro. Tó gↄ̃ↄn wàa kuri ke wàa gɛ̃roo gàa, aↄ̃é wɛ́tɛ pì sí. Ǹton ĩa da gbɛ̃nↄa ń píngiro. ");
INSERT INTO bus_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","Kɛ̀ gↄ̃ↄn wàa gɛ̃roonↄ gàa gwe, ben Aideenↄ ń fú ");
INSERT INTO bus_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","aↄ̃ pɛ̀ḿma bↄna zaa ń wɛ́tɛ bĩilɛa ai gbɛ̀wikiia, aↄ̃ ń dɛ́dɛ sĩ̀sĩgɛɛzi gↄ̃ↄn baaakuri awɛɛswɛɛdo. Ben swɛ̃̀ kɛ̃̀ Isarailinↄn aↄ̃ ninii dà batan. ");
INSERT INTO bus_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","Yↄsua a uta gà à kɛ̃̀ à dàɛ a puua Dii àkpati aɛ ai uusiɛ. Àpi kↄ̃n Isaraili gbɛ̃nsinↄ bùsu kùku ń mìa. ");
INSERT INTO bus_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","Ben Yↄsua bè: Á'a, Dii Luda! À kɛ̀ dia n wa bikũ Yodaa n wa na Amↄrinↄnɛ ń ↄzĩ aↄ̃ wa kaatɛɛ? Tó wá vɛ̃ɛna Yoda baa kãa kpa yã nɛ́! ");
INSERT INTO bus_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","N yã nna Dii! Zaakɛ Isarailinↄ bↄ̀ru kpɛɛ ń ibɛɛnↄnɛ, mɛ́ be dia saa? ");
INSERT INTO bus_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","Kanaanↄ kↄ̃n bùsu kɛ̀ deenↄ é yã pì ma ń píngi, aↄ̃ ligawazi aↄ̃ wa kaatɛ andunan. N tↄ́ bítakɛɛ sↄ̃ nɛ́? Nɛ́ kɛo diamɛ? ");
INSERT INTO bus_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","Ben Dii bè Yↄsuanɛ: Ǹ fɛɛ ǹ zɛ! À kɛ̀ dia ń daɛna n puua? ");
INSERT INTO bus_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","Isarailinↄ durun kɛ̀, aↄ̃ ma bà kuunańyo yã gbòro. Aↄ̃ tɛ̃̀ pↄ́ kenↄ sɛ̀, aↄ̃ kpãi ò, aↄ̃ mↄnafiki kɛ̀, aↄ̃ pↄ́ pì dà ń pↄ́nↄ guu. ");
INSERT INTO bus_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","Beee yãnzi aↄ̃ↄe fↄ̃ wà ń ibɛɛnↄ gã̀ fĩ̀ro. Aↄ̃ bↄ̀ru kpɛɛńnɛ, kɛ̀ aↄ̃ gↄ̃̀ kaatɛna pↄ́ ũ yãnzi. Mɛ́gↄ̃ kúao dↄro, séto a tɛ̃̀ pↄ́ kɛ̀ kú a tɛ́nↄ kàatɛ. ");
INSERT INTO bus_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","Ǹ fɛɛ ǹ gá gbãsĩ bↄ n gbɛ̃nↄn. Ǹ beńnɛ aↄ̃ gbãsĩ bↄ ń zĩndan ai guu gↄ̃ gá dↄ, zaakɛ mamↄma Dii Isarailinↄ Luda ma bè, tɛ̃̀ pↄ́ kú a tɛ́mɛ. É fↄ̃ à zɛ a ibɛɛnↄ aɛro séto à pↄ́ pì bↄ̀ a tɛ́. ");
INSERT INTO bus_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","Tó guu dↄ̀, à sↄ̃mazi bori kↄ̃n boriio. Borii kɛ̀ má sɛ̀ é sↄ̃mazi danɛdanɛ, danɛ kɛ̀ má sɛ̀nↄ é sↄ̃mazi ualɛ kↄ̃n ualɛo, ualɛ kɛ̀ má sɛ̀ sↄ̃, à gↄ̃gbɛ̃nↄ é sↄ̃mazi doodo. ");
INSERT INTO bus_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","Gbɛ̃ kɛ̀ wà gà wà tɛ̃̀ pↄ́ pì èa, weé adee kpata kↄ̃n pↄ́ kɛ̀ à vĩinↄ píngi, zaakɛ à ma bà kuunaao yã gbòromɛ, à wí dà Isarailinↄa. ");
INSERT INTO bus_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","Yↄsua fɛ̀ɛ kↄngↄ idɛ'idɛ, à tò Isarailinↄ sↄ̃̀ Diizi bori kↄ̃n boriio, ben gbɛ̀ Yuda borii sɛ̀. ");
INSERT INTO bus_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","Ben à tò Yudanↄ sↄ̃̀zi danɛdanɛ, ben gbɛ̀ Zɛra danɛnↄ sɛ̀. À tò Zɛra danɛnↄ sↄ̃̀zi ualɛ kↄ̃n ualɛo, ben gbɛ̀ Zimiri ua sɛ̀. ");
INSERT INTO bus_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","Ben à tò à ua gↄ̃gbɛ̃nↄ sↄ̃̀zi doodo, ben gbɛ̀ Kaami nɛ́ Akã, Zimiri dio, Zɛra swãkpɛɛ, Yuda borii sɛ̀. ");
INSERT INTO bus_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","Ben Yↄsua bè Akãnɛ: Nɛ́, ǹ yãpuraa o ǹ bɛ̀ɛ lí Dii Isarailinↄ Ludanɛ. Ǹ yã kɛ̀ ń kɛ̀ omɛ. Ǹton à ke utɛmɛro. ");
INSERT INTO bus_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Ben Akã wèàla à bè: Yãpuramɛ, ma durun kɛ̀ Dii Isarailinↄ Ludanɛ. Yã kɛ̀ má kɛ̀n yɛ̀. ");
INSERT INTO bus_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","Ma Babilↄnia gumusu maaa è ń pↄ́nↄ tɛ́ kↄ̃n kondogio kiloo plaa kↄ̃n vura kiloo kusuo, ben à nii gɛ̃̀magu má sɛ̀. À utɛna wɛ̀ɛn ma kpɛ́n, kondogi kú gĩzĩ. ");
INSERT INTO bus_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","Ben Yↄsua gbɛ̃nↄ zĩ̀ gwe. Aↄ̃ kɛ̀ kpaa aↄ̃ gàa wà gɛ̃̀ à kpɛ́n, ben aↄ̃ↄ è utɛna gwe, kondogi kú gĩzĩ. ");
INSERT INTO bus_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","Ben aↄ̃ↄ sɛ̀ɛ wà mↄ̀o Yↄsuanɛ kↄ̃n Isarailinↄ ń píngi, aↄ̃ↄ kàɛ Dii aɛ. ");
INSERT INTO bus_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","Ben Yↄsua kↄ̃n Isarailinↄ Zɛra swãkpɛɛ Akã sɛ̀ kↄ̃n kondogi pìo kↄ̃n gumusu pìo kↄ̃n vura pìo kↄ̃n à nɛ́gↄ̃gbɛ̃nↄ kↄ̃n à nɛ́nↄgbɛ̃nↄ kↄ̃n à zùnↄ kↄ̃n à zaakinↄ kↄ̃n à sãanↄ kↄ̃n à bisakutaao kↄ̃n à pↄ́nↄ píngi, aↄ̃ gàańyo Akoo guzurɛn. ");
INSERT INTO bus_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","Ben Yↄsua bè: N yã gàɛwe fá! Dii é yã mↄ́nnɛ gbã̀a sↄ̃. Ben Isarailinↄ à pàpa gbɛ̀o ń píngi, aↄ̃ à dɛ̀ kↄ̃n à gbɛ̃nↄ ń píngi, ben aↄ̃ ń kpáta. ");
INSERT INTO bus_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","Aↄ̃ gbɛ̀ kàkaàla, gbɛ̀didikↄ̃ana bíta pì kú gwe ai kↄ̃n a gbã̀ao. Ben Dii pↄfɛ̃ kpàɛ. Beee yãnzin wè be guu pìnɛ Akoo guzurɛ. ");
INSERT INTO bus_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","Dii bè Yↄsuanɛ: Ǹton tó vĩa n kũro. Ǹton bídi kɛro. Ǹ zĩ̀kpɛɛnↄ sɛ́ɛ ǹ gáńyo ń píngi, à lɛ́ɛ Aia, zaakɛ ma Ai kína nànnɛ n ↄzĩ kↄ̃n à gbɛ̃nↄ kↄ̃n à wɛ́tɛo kↄ̃n à bùsuo. ");
INSERT INTO bus_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","Ǹ kɛ Ai kↄ̃n a kínaonɛ lán ń kɛ̀ Yɛriko kↄ̃n a kínaonɛ nà, mↄde é fↄ̃ à ń pↄ́nↄ kↄ̃n ń pↄ́kãdeenↄ sɛ́ɛ a pↄ́ ũ sa. Ǹ naɛńnɛ ń wɛ́tɛ kpɛɛ. ");
INSERT INTO bus_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","Ben Yↄsua kↄ̃n a zĩ̀kpɛɛnↄ gàa wà lɛ́ɛ Aia ń píngi. À gↄ̃sagbãaanↄ sɛ̀ gↄ̃ↄn bↄrↄ baaakuri, ben à ń gbáɛ gwãavĩ ");
INSERT INTO bus_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","à bèńnɛ: À swã kpá! À naɛńnɛ ń wɛ́tɛ kpɛɛ. Àton kɛ zã̀ wɛ́tɛ pìoro. Àgↄ̃ kú soru guu a píngi. ");
INSERT INTO bus_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","Mapi kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ kúmaonↄ wé sↄ̃ wɛ́tɛ pìzi. Tó aↄ̃ bↄ̀ dawalɛ, wégↄ̃ bàa lɛ́ńnɛ lán káaku bà. ");
INSERT INTO bus_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","Aↄ̃é pɛ́wa ai aↄ̃é kɛ̃ ń wɛ́tɛa zã̀, zaakɛ aↄ̃égↄ̃ daa wée bàa lɛɛńnɛ lán káaku bàmɛ. Tó wée bàa lɛɛńnɛ lɛ, ");
INSERT INTO bus_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","à fɛɛ a utɛkiia à wɛ́tɛ pì sí. Dii a Ludaa nàare a ↄzĩmɛ. ");
INSERT INTO bus_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","Tó a wɛ́tɛ pì sì, à tɛ́ sↄ̃a lán Dii ò nà. À làakari kɛ, à kɛ lán má dìɛare nà. ");
INSERT INTO bus_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","Ben Yↄsua ń gbáɛ, aↄ̃ gàa guu kɛ̀ aↄ̃é e wà ń zãmba kɛn. Aↄ̃ nàɛ Bɛtɛli kↄ̃n Aio dagura Ai ↄfãntɛ̃gɛ̃kpɛn kpa. Gwãavĩ beeea Yↄsua ì bùran gwe kↄ̃n a gbɛ̃nↄo. ");
INSERT INTO bus_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","À fɛ̀ɛ kↄngↄ idɛ'idɛ à gbɛ̃nↄ kàkↄ̃a, ben àpi kↄ̃n Isaraili gbɛ̃nsinↄ dↄ̀ńnɛ aɛ ai aↄ̃ gàa káo Ai. ");
INSERT INTO bus_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","Zĩ̀kpɛɛ kɛ̀ aↄ̃ↄ kúonↄ sↄ̃̀ wɛ́tɛ pìzi ń píngi. Kɛ̀ aↄ̃ kào kĩi, aↄ̃ bùra kàɛ à aɛ gu'igbãroo kpa. Guzurɛ kú ń dagura kↄ̃n Aio. ");
INSERT INTO bus_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","Yↄsua gbɛ̃nↄ sɛ̀ bↄrↄ sↄↄro. À gĩakɛ à ń útɛ Bɛtɛli kↄ̃n Aio dagura kↄ̀ Ai ↄfãntɛ̃gɛ̃kpɛn kpa. ");
INSERT INTO bus_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","Isarailinↄ bùra kàɛ wɛ́tɛ gu'igbãroo kpa, bensↄ̃ gbɛ̃ kɛ̀ aↄ̃ↄ naɛna pìnↄↄ kú wɛ́tɛ ↄfãntɛ̃gɛ̃kpɛn kpa. Gwãavĩ beeea Yↄsua ì guzurɛmmɛ. ");
INSERT INTO bus_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","Kɛ̀ Ai kína Isarailinↄ è lɛ, àpi kↄ̃n a wɛ́tɛdeenↄ fɛ̀ɛ wà kɛ̀ kpaa wà gàańzi kↄ̃n zĩ̀o guu kɛ̀ aɛ dↄ̀ Araba gbáaa. À dↄ̃ kɛ̀ gbɛ̃nↄↄ naɛna a wɛ́tɛ kpɛɛro. ");
INSERT INTO bus_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","Yↄsua kↄ̃n Isarailinↄↄ e kɛɛ lán wà be Aideenↄↄ e ń fuu bà, aↄ̃ↄe bàa lɛɛńnɛ aↄ̃ mì pɛ̀ gbáaa. ");
INSERT INTO bus_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","Aideenↄ kↄ̃ sìsi ń píngi aↄ̃ bↄɛ wà pɛ́ Yↄsuanↄa, ben aↄ̃ pɛ̀ḿma ai aↄ̃ gàa wà kɛ̃̀ ń wɛ́tɛa zã̀azã. ");
INSERT INTO bus_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","Gↄ̃gbɛ̃ kee e gↄ̃ wɛ́tɛ guuro, aↄ̃ bↄ̀ɛ wà pɛ̀ Isarailinↄa ń píngi, ben aↄ̃ ń wɛ́tɛ bĩilɛ tò wɛ̃na, aↄ̃ↄe pɛɛ Isarailinↄa. ");
INSERT INTO bus_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","Dii bè Yↄsuanɛ: Ǹ sári kɛ̀ ń kũna dↄ Aia, zaakɛ má nànnɛ n ↄzĩmɛ. Ben Yↄsua a sári pì dↄ̀ Aia. ");
INSERT INTO bus_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","Kɛ̀ à ↄ pòro lɛ, ben gbɛ̃ kɛ̀ aↄ̃ↄ naɛnanↄ fɛ̀ɛ wà sì wɛ́tɛn gↄ̃ↄ aↄ̃ↄ sì, ben aↄ̃ kɛ̀ kpaa wà tɛ́ sↄ̃̀a. ");
INSERT INTO bus_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","Kɛ̀ Aideenↄ lìɛ wà ń kpɛɛ gwà, ben aↄ̃ↄ è tɛ́sukpɛ fɛ̀ɛ à dà ń wɛ́tɛla, ben aↄ̃ↄe gákii e dↄro, zaakɛ Isaraili kɛ̀ aↄ̃ bàa lɛ̀ wà mì pɛ̀ gbáaanↄ lìɛ wà aɛ dↄ̀ ń pɛmmari pìnↄa. ");
INSERT INTO bus_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","Kɛ̀ Yↄsua kↄ̃n Isarailinↄↄ è ń gbɛ̃ kɛ̀ aↄ̃ↄ naɛnanↄ wɛ́tɛ sì bensↄ̃ tɛ́sukpɛ fɛ̀ɛ à dà wɛ́tɛla, ben aↄ̃ ɛ̀ara wà lɛ̀ɛ Aidee pìnↄa. ");
INSERT INTO bus_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","Isaraili kpaaanↄ bↄ̀ɛ wɛ́tɛ pìn aↄ̃ gàa Aideenↄzi kↄ̃n zĩ̀o, ben aↄ̃ lìgańzi. Aↄ̃ lɛ̀ɛḿma, ben aↄ̃ gbɛ̃kee e e à bↄ̀ro, aↄ̃ gbɛ̃kee e e à bàa lɛ̀ro. ");
INSERT INTO bus_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","Mↄde aↄ̃ Ai kína kũ̀ bɛ̃ɛ aↄ̃ gàao Yↄsuanɛ. ");
INSERT INTO bus_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","Isarailinↄ Aideenↄ dɛ̀dɛ míↄmiↄ buraanↄa kↄ̃n sɛ̃̀tɛnↄ guu kɛ̀ aↄ̃ ń lén. Kɛ̀ aↄ̃ Aideenↄ dɛ̀dɛ kↄ̃n fɛ̃ɛdaao lɛ, ben aↄ̃ ɛ̀ara wà gɛ̃̀ wɛ́tɛ pìn, aↄ̃ gbɛ̃ kɛ̀ aↄ̃ gↄ̃̀ gweenↄ dɛ̀dɛ dↄ. ");
INSERT INTO bus_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","Gbɛ̃ kɛ̀ aↄ̃ gàga zĩ pìanↄ gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄ ń píngi gↄ̃ↄn bↄrↄ kuri awɛɛplaamɛ. Aideenↄ sↄ̃ lɛ́n gwe. ");
INSERT INTO bus_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","Yↄsua ↄↄ kɛ̀ à sári kũnao pì kpɛ́ dↄ ai wà gàa wà Aideenↄ dúgu zↄ̃o. ");
INSERT INTO bus_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","Isarailinↄ wɛ́tɛ pì pↄ́kãdeenↄ kↄ̃n à pↄ́nↄ nàkↄ̃a wà tào lán Dii ò Yↄsuanɛ nà. ");
INSERT INTO bus_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","Lɛn Yↄsua tɛ́ sↄ̃̀ Aia lɛ, à tò à gↄ̃̀ bɛzĩ ũ, ben à gↄ̃̀ da kori ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","Ben à Ai kína lògo lía ai uusiɛ. Kɛ̀ ↄfãntɛ̃ e gɛ̃ɛ kpɛ́n, à bè wà à gɛ̀ bakɛ̃ lía wà zu wɛ́tɛ bĩilɛa gwe. Ben wà gbɛ̀ kàkↄ̃aa paripari, gbɛ̀didikↄ̃ana pì kú gwe ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","Yↄsua Dii Isarailinↄ Luda gbãgbãkii bò Ebala kpiii musu ");
INSERT INTO bus_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","lán Dii zↄ̀bleri Musa dìɛ Isarailinↄnɛ nà. À bò lán Musa kɛ̃̀ a doka takada guu nà, à bè wà bo kↄ̃n gbɛ̀ kɛ̀ wèe gã pɛ́ɛa wà àroonↄ. Ben wà sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ ò Diia gwe kↄ̃n sáabukpana sa'opↄnↄ. ");
INSERT INTO bus_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","Ben Yↄsua doka kɛ̀ Musa kɛ̃̀ pì kɛ̃̀ gbɛ̀ pìnↄa gwe Isarailinↄ wáa. ");
INSERT INTO bus_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","Isarailinↄ píngi, bɛdeenↄ kↄ̃n bↄ̀amↄnↄ kↄ̃n ń gbɛ̃nsinↄ kↄ̃n ń dↄn'aɛdeenↄ kↄ̃n ń yãkpaɛkɛrinↄↄ zɛna àkpati saɛ ↄplazi kↄ̃n ↄzɛzio. Aↄ̃ aɛ dↄ̀ Levi bori sa'ori kɛ̀ aↄ̃ègↄ̃ Dii bà kuunańyo àkpati sɛnanↄa. Gbɛ̃ kpadoonↄ aɛ dↄna Gɛrizimu kpiiia, gbɛ̃ kpadoonↄ sↄ̃ Ebala kpiiia, lán Dii zↄ̀bleri Musa gĩakɛ à dìɛ wà sa maaa o Isarailinↄnɛ nà. ");
INSERT INTO bus_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","Beee gbɛra Yↄsua dokayã pìnↄ kyó kɛ̀ńnɛ píngi, aubarika kɛ̀ Dii è dańgunↄ kↄ̃n kɛ̀ è bↄńgunↄo lán à kú Musa doka takada guu nà. ");
INSERT INTO bus_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","Yã kɛ̀ Musa dìɛnↄ tɛ́ píngi, à kee e gↄ̃ kɛ̀ Yↄsua gì à kyó kɛ pariinɛziro. Baa nↄgbɛ̃nↄ kↄ̃n nɛ́ fétenↄ kↄ̃n bↄ̀amↄ kɛ̀ aↄ̃ↄ kú ń tɛ́nↄↄ kú gwe ń píngi. ");
INSERT INTO bus_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","Borii kɛ̀ aↄ̃ↄ kú Yoda ↄfãntɛ̃gɛ̃kpɛn kpaanↄ, sĩ̀sĩdeenↄ kↄ̃n gusararadeenↄ kↄ̃n ísialɛadeenↄ ai à gàa pɛ́ Lɛbanↄ bùsua, Itinↄ kↄ̃n Amↄrinↄ kↄ̃n Kanaanↄ kↄ̃n Pɛrizinↄ kↄ̃n Ivinↄ kↄ̃n Yebusinↄo, kɛ̀ aↄ̃ kínanↄ Ai yã pì baaru mà, ");
INSERT INTO bus_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","ben aↄ̃ kↄ̃ kàkↄ̃a ń píngi lɛ wà gá wà zĩ̀ ká kↄ̃n Yↄsuao kↄ̃n à gbɛ̃ Isarailinↄ. ");
INSERT INTO bus_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","Kɛ̀ Gibiↄ̃deenↄ yã kɛ̀ Yↄsua kɛ̀ Yɛrikonɛ kↄ̃n Aio baaru mà, ");
INSERT INTO bus_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","aↄ̃ ↄ̃ndↄ̃ↄ dàɛńzi. Aↄ̃ kũsãɛ kàka sàki zikũnanↄ guu aↄ̃ dìdi zaakinↄnɛ kↄ̃n geepiwɛ̃ tùu zi parana nabinabinanↄo. ");
INSERT INTO bus_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","Aↄ̃ↄ kyate nambata nanananↄ kpákpana, aↄ̃ↄ pↄsia utanↄ dadana. Aↄ̃ burɛdi kũsãɛ gagana bensↄ̃ à pù kpà. ");
INSERT INTO bus_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","Aↄ̃ fɛ̀ɛ wà gàa wà Yↄsua lè kↄ̃n a gbɛ̃nↄ Giligala bùran, ben aↄ̃ bèńnɛ: Bùsu kɛ̀ wa bↄn zã̀. Wá yezi à lɛdolɛ kɛwao. ");
INSERT INTO bus_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","Ben Isarailinↄ bè Ivi pìnↄnɛ: Tó a bɛɛ kú kɛ̀ kĩimɛ, wé lɛdolɛ kɛaoro yooo! ");
INSERT INTO bus_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","Ben aↄ̃ bè Yↄsuanɛ: N zↄ̀blerinↄn wa ũ. Ben Yↄsua ń lá à bè: Dénↄn a ũu? A bↄ mámɛ? ");
INSERT INTO bus_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","Aↄ̃ wèàla wà bè: Wamↄwa n zↄ̀blerinↄ, wa bↄ bùsu zã̀azãmmɛ Dii n Luda tↄ́ kɛ̀ dàgula yãnzi. Wa à baaru mà kↄ̃n yã kɛ̀ à kɛ̀ Igipitinↄ píngi ");
INSERT INTO bus_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","kↄ̃n yã kɛ̀ à kɛ̀ Amↄrinↄ kína gↄ̃ↄn plaaa kɛ̀ aↄ̃ↄ kú Yoda baa kãa kpaanↄnɛ, Ɛsɛbↄ̃ kí Siↄ̃ kↄ̃n Basã kí Ogu kɛ̀ kú Asataroo. ");
INSERT INTO bus_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","Wa gbɛ̃nsinↄ kↄ̃n wa bùsudeenↄ bè wà kũsãɛ sɛ́ wà mↄ́ wà a le, wà beare a zↄ̀blerinↄn wa ũ. Beee yãnzi à lɛdolɛ kɛwao. ");
INSERT INTO bus_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","Wa kũsãɛn yɛ̀. Wa bↄo bɛ burɛdi wãaa ũmɛ gurↄↄ kɛ̀ wa da zɛ́n wée mↄↄ a kiia. À gwa dian à kori kũ̀ nà à pù kpà. ");
INSERT INTO bus_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","Wa geepiwɛ̃ tùunↄn yɛ̀. Wa geepiwɛ̃ɛ kàn tùu dufu ũmɛ. À gwa dian aↄ̃ pàrapara nà. À wa utanↄ kↄ̃n wa kyateenↄ gwa. Aↄ̃ yàkayaka tá gbã̀a kɛ̀ wá ò yãnzi. ");
INSERT INTO bus_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","Ben Isarailinↄ ń kũsãɛ blèńyo Dii lɛ́ saɛ. ");
INSERT INTO bus_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","Yↄsua lɛdolɛ kɛ̀ńyo à bè é ń dɛdɛro, ben Isaraili dↄn'aɛdeenↄ la dà à yã musu. ");
INSERT INTO bus_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","Aↄ̃ lɛdolɛkɛnańyo gbɛra à gurↄ aagↄ̃dee zĩ, ben aↄ̃ↄ mà kɛ̀ aↄ̃ bɛɛ zã̀ńyoro, aↄ̃ↄ kú kↄ̃ saɛmɛ. ");
INSERT INTO bus_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","Ben Isarailinↄ dà zɛ́n, à gurↄ aagↄ̃dee zĩ aↄ̃ kà ń wɛ́tɛnↄ kiia, Gibiↄ̃ kↄ̃n Kɛfirao kↄ̃n Beroo kↄ̃n Kiriayarimuo. ");
INSERT INTO bus_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","Aↄ̃ↄe lɛ́ɛḿmaro, zaakɛ aↄ̃ dↄn'aɛdeenↄ sìńnɛ kↄ̃n Dii ń Luda tↄ́omɛ. Gbɛ̃ píngi e wisↄ̃ↄ ń dↄn'aɛdeenↄzi, ");
INSERT INTO bus_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","ben dↄn'aɛdee pìnↄ bèńnɛ: Wámbe wá sìńnɛ kↄ̃n Dii wa Luda tↄ́o. Èe kↄ̃ sío kɛ̀ wà ↄ naḿma dↄro. ");
INSERT INTO bus_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","Yã kɛ̀ wé kɛńnɛn yɛ̀. Wé ń tó gwe ladana kɛ̀ wá kɛ̀ńnɛ yãnzi, lɛ Dii pↄfɛ̃ tón pita wa musuro. ");
INSERT INTO bus_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","Ben aↄ̃ ɛ̀ara wà bè: Wà ń tó, aↄ̃égↄ̃ dɛ wa yàkawɛrinↄ ũ kↄ̃n wa ítↄtↄrinↄ. Ben Isarailinↄ zɛ̀ kↄ̃n ń dↄn'aɛdeenↄ yã pìo. ");
INSERT INTO bus_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","Ben Yↄsua Gibiↄ̃deenↄ sìsi à bèńnɛ: Bↄ́yãnzin a ɛgɛɛ tòwe lɛzi? Ase wá kaɛna kↄ̃ gbálamɛ, ben a bè a kúkii zã̀waoↄ́? ");
INSERT INTO bus_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","A gↄ̃ kana pↄ́ ũ ma Luda kiia sa. Égↄ̃ dɛ à kpɛ́ yàkawɛrinↄ ũ kↄ̃n à ítↄtↄrinↄo gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","Ben aↄ̃ bènɛ: Wà bè wamↄwa n zↄ̀blerinↄnɛ súusu lán Dii n Ludaa ò a zↄ̀bleri Musanɛ nà. À bè é bùsu pì kpáawa píngi à gbɛ̃ kɛ̀ aↄ̃ↄ kúnnↄ kaatɛare ń píngi. Vĩa wa kũ maamaa wa wɛ̃̀ndi yã musu, beee yãnzi wa kɛ̀ lɛzi. ");
INSERT INTO bus_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","Wá kú n ↄzĩmɛ sa. Yã kɛ̀ kɛ̀nnɛ maa bensↄ̃ à zɛ́ vĩn kɛwe. ");
INSERT INTO bus_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","Lɛn Yↄsua kɛ̀ lɛ à ń bↄ́ Isarailinↄ ↄzĩ, aↄ̃ↄe ń dɛdɛro. ");
INSERT INTO bus_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","Zĩ beeean à ń díɛ Isarailinↄ yàkawɛrinↄ kↄ̃n ń ítↄtↄrinↄ ũ, aↄ̃ègↄ̃ yàka wɛɛ, aↄ̃ègↄ̃ í tↄtↄↄ Dii gbãgbãkiinɛ guu kɛ̀ Dii é diɛn. Ben aↄ̃ↄ kuu lɛ ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","Yerusalɛmu kí Adonizɛdɛki mà kɛ̀ Yↄsua Ai sì à kɛ̀nɛ dúgudugu, à kɛ̀ Ainɛ kↄ̃n a kínao lán à kɛ̀ Yɛriko kↄ̃n a kínaonɛ nà. À mà dↄ kɛ̀ Gibiↄ̃deenↄ kↄ̃ yã mà kↄ̃n Isarailinↄ bensↄ̃ aↄ̃ↄ kú kↄ̃ saɛ. ");
INSERT INTO bus_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","Ben vĩa Yerusalɛmudeenↄ kũ̀ maamaa, zaakɛ Gibiↄ̃ nɛ́ mɛɛwimɛ lán kína wɛ́tɛ ke bà. À bíta dɛ Aila bensↄ̃ à gↄ̃gbɛ̃nↄ nɛ́ zĩ̀kari gbãaanↄmɛ. ");
INSERT INTO bus_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Ben Yerusalɛmu kí Adonizɛdɛki lɛ́kpãsã kɛ̀ Ɛblↄnu kí Oamunɛ kↄ̃n Yamu kí Piramuo kↄ̃n Lakisi kí Yafiao kↄ̃n Ɛgɛlↄni kí Dɛbio à bè: ");
INSERT INTO bus_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","À mↄ́ à dↄmalɛ wà gá lɛ́ɛ Gibiↄ̃deenↄa, zaakɛ aↄ̃ kↄ̃ yã mà kↄ̃n Yↄsuao kↄ̃n Isarailinↄ. ");
INSERT INTO bus_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","Ben Amↄrinↄ kína gↄ̃ↄn sↄↄroo pìnↄ, Yerusalɛmu kína kↄ̃n Ɛblↄnu kínao kↄ̃n Yamu kínao kↄ̃n Lakisi kínao kↄ̃n Ɛgɛlↄni kínao kↄ̃n ń zĩ̀kpɛɛnↄ kↄ̃ kàkↄ̃a. Aↄ̃ gàa wà bùra kàɛ Gibiↄ̃ saɛ, ben aↄ̃ gàańzi kↄ̃n zĩ̀o. ");
INSERT INTO bus_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Ben Gibiↄ̃deenↄ gbɛ̃nↄ zĩ̀ Yↄsuaa Giligala bùran aↄ̃ bè: Ǹton pã kpá wamↄwa n zↄ̀blerinↄziro. Ǹ kɛ kpaa ǹ mↄ́ ǹ wa mì sí. Ǹ mↄ́ ǹ dↄwalɛ, zaakɛ Amↄrinↄ kína kɛ̀ aↄ̃ↄ kú gusĩsĩdeennↄ kàkↄ̃awazi ń píngi. ");
INSERT INTO bus_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Ben Yↄsua kↄ̃n a gↄ̃sagbãaanↄ kↄ̃n a zĩ̀kpɛɛnↄ bↄ̀ɛ Giligala, aↄ̃ↄe mↄↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Ben Dii bè Yↄsuanɛ: Ǹton vĩa kɛńnɛro. Ma ń nánnɛ n ↄzĩ, aↄ̃ gbɛ̃ke é fↄ̃ à n gã̀ fĩro. ");
INSERT INTO bus_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Bↄna Giligala Yↄsua táa ò gwãavĩ ai guu gàa à dↄ̀o à sùḿma kãndo zɛna sai. ");
INSERT INTO bus_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","Ben Dii tò aↄ̃ kɛ̀ gìri aↄ̃ lɛ̀kↄ̃a Isarailinↄ aɛ, ben Isarailinↄ lɛ̀ɛḿma aↄ̃ ń dɛ́dɛ maamaa Gibiↄ̃ gwe, ben aↄ̃ pɛ̀ḿma Bɛtoroni zɛ́n dↄ. Aↄ̃ ń dɛ́dɛ ai à gàa pɛ́ Azeka kↄ̃n Makɛdaoa. ");
INSERT INTO bus_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Kɛ̀ aↄ̃ↄe bàa lɛɛ Isarailinↄnɛ zɛ́ kɛ̀ bↄ̀ Bɛtoroni kɛ̀ à gàa Azeka guu, Dii lougbɛ gbɛ̃̀ntɛ̃ sì ń tɛ́. Gbɛ̃ kɛ̀ lougbɛ pì ń dɛ́dɛnↄↄ pari dɛ gbɛ̃ kɛ̀ Isarailinↄ ń dɛ́dɛ kↄ̃n fɛ̃ɛdaaonↄla. ");
INSERT INTO bus_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Gurↄↄ kɛ̀ Dii Amↄri pìnↄ nà Isarailinↄnɛ ń ↄzĩ, ben Yↄsua yã ò Diio Isarailinↄ wáa à bè: Ǹ tó ↄfãntɛ̃ zɛ a gbɛ̀n Gibiↄ̃la! Ǹ tó mↄↄ zɛ tɛɛɛ Ayalↄni guzurɛla! ");
INSERT INTO bus_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Ben ↄfãntɛ̃ zɛ̀ a gbɛ̀n lɛ, ben mↄↄ zɛ̀ dↄ ai Isarailinↄ gàa wà gɛ̃ɛ bò ń ibɛɛnↄa. Yã pì kú Yasa takadan. Ɔfãntɛ̃ gↄ̃̀ zɛna mìdangura, èe gu a gbɛ̀nlo ai gurↄ do gbãngbãn. ");
INSERT INTO bus_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Wèe gurↄ beee taka e zikiro, bensↄ̃ wèe e à gbɛraro. Dii gbɛ̃ntee yã mà, zaakɛ èe zĩ̀ kaa Isarailinↄnɛmɛ. ");
INSERT INTO bus_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Ben Yↄsua tà Giligala bùran kↄ̃n a gbɛ̃nↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","Kɛ̀ kí gↄ̃ↄn sↄↄroo pìnↄ bàa lɛ̀, wà gàa wà ùtɛ gbɛ̀wɛɛn zaa Makɛda, ");
INSERT INTO bus_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","ben wà bè Yↄsuanɛ: Wà bↄ̀ kí gↄ̃ↄn sↄↄroo mↄ̀nↄa gbɛ̀wɛɛn zaa Makɛda. ");
INSERT INTO bus_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","Ben Yↄsua bè: À gbɛ̀ gbɛ̃̀ntɛ̃nↄ yĩpa à tata gbɛ̀wɛɛ pìlɛ, à gbɛ̃nↄ diɛ gwe wàgↄ̃ dãkpaa. ");
INSERT INTO bus_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","Àton zɛro. À pɛ́ɛ a ibɛɛnↄzi à lɛ́ɛḿma kpɛɛ kpa. Àton tó aↄ̃ ń wɛ́tɛnↄ lero, zaakɛ Dii a Luda ń náare a ↄzĩmɛ. ");
INSERT INTO bus_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","Yↄsua kↄ̃n a gbɛ̃nↄ ń dɛ́dɛ ai aↄ̃ↄ yezi wà yãa, aↄ̃ gbɛ̃ kɛ̀ aↄ̃ bↄ̀nↄ kà ń wɛ́tɛ bĩideenↄ guu. ");
INSERT INTO bus_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","Ben Isarailinↄ sù Yↄsuaa bùran Makɛda aafia ń píngi. Gbɛ̃kee e fↄ̃ à yãke ò Isarailinↄ yã musu dↄro. ");
INSERT INTO bus_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","Ben Yↄsua bè: À gbɛ̀ go gbɛ̀wɛɛ pìlɛ à bↄɛmɛ kↄ̃n kí gↄ̃ↄn sↄↄroo pìnↄ. ");
INSERT INTO bus_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","Ben aↄ̃ↄ kɛ̀ lɛ aↄ̃ bↄ̀ɛnɛ kↄ̃n kí gↄ̃ↄn sↄↄroo pìnↄ, Yerusalɛmu kína kↄ̃n Ɛblↄnu kínao kↄ̃n Yamu kínao kↄ̃n Lakisi kínao kↄ̃n Ɛgɛlↄni kínao. ");
INSERT INTO bus_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","Kɛ̀ wà ń bↄ́ɛ lɛ, ben à Isaraili zĩ̀kpɛɛnↄ sìsi ń píngi à bè ń dↄn'aɛdee kɛ̀ aↄ̃ gàaaonↄnɛ: À sↄ̃ kĩi à gbá zɛzɛ kína kɛ̀nↄ waaa. Ben aↄ̃ mↄ̀ wà gbá zɛ̀zɛ ń waaa. ");
INSERT INTO bus_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","Yↄsua bèńnɛ: Àton tó vĩa a kũro, àton bídi kɛro. À zɛ gbãa àgↄ̃ wↄ́rↄngↄ vĩ, zaakɛ lɛn Dii é kɛ lɛ kↄ̃n a ibɛɛ kɛ̀ é zĩ̀ káńyonↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","Beee gbɛra Yↄsua ń dɛ́dɛ à ń lógo lía, baade kↄ̃n a lío, ben aↄ̃ gↄ̃̀ logologona gwe ai uusiɛ. ");
INSERT INTO bus_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","Kɛ̀ ↄfãntɛ̃ e gɛ̃ɛ kpɛ́n, à bè wà ń gɛ̀nↄ bakɛ̃ lí pìnↄa wà ń zu gbɛ̀wɛɛ kɛ̀ aↄ̃ ùtɛn pìn. Ben wà kɛ̀ lɛ, wà gbɛ̀ gbɛ̃̀ntɛ̃nↄ tàta wɛ̀ɛ pìlɛ, à kú gwe ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","Zĩ beeean Yↄsua Makɛda sì. À à kína kↄ̃n à gbɛ̃nↄ dɛ̀dɛ ń píngi kↄ̃n fɛ̃ɛdaao à ń káatɛ. Baa gbɛ̃ mɛ̀n doo e bↄro. Ben à kɛ̀ Makɛda kínanɛ lán à kɛ̀ Yɛriko kínanɛ nà. ");
INSERT INTO bus_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","Yↄsua kↄ̃n Isarailinↄ bↄ̀ɛ Makɛda ń píngi, ben aↄ̃ gàa Libina aↄ̃ lɛ̀ɛa. ");
INSERT INTO bus_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","Dii wɛ́tɛ pì kↄ̃n a kínao nàńnɛ ń ↄzĩ, ben aↄ̃ ń dɛ́dɛ kↄ̃n fɛ̃ɛdaao ń píngi, aↄ̃ gbɛ̃kee e bↄro. Ben aↄ̃ↄ kɛ̀ à kínanɛ lán aↄ̃ↄ kɛ̀ Yɛriko kínanɛ nà. ");
INSERT INTO bus_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","Ben Yↄsua kↄ̃n a gbɛ̃nↄ bↄ̀ɛ Libina aↄ̃ gàa Lakisi. Aↄ̃ lìgazi aↄ̃ lɛ̀ɛa. ");
INSERT INTO bus_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","Dii Lakisi nàńnɛ ń ↄzĩ, à gurↄ plaadee zĩn aↄ̃ↄ sì. Aↄ̃ gbɛ̃ kɛ̀ aↄ̃ↄ kúnnↄ dɛ̀dɛ kↄ̃n fɛ̃ɛdaao ń píngi lán aↄ̃ↄ kɛ̀ Libinanɛ nà. ");
INSERT INTO bus_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","Kɛ̀ Gɛza kí Oramu mↄ̀ à dↄ Lakisideenↄlɛ, ben Yↄsua zĩ̀ blèa kↄ̃n à zĩ̀kpɛɛnↄ, aↄ̃ gbɛ̃kee e bↄro. ");
INSERT INTO bus_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","Aↄ̃ bↄ̀ Lakisi, ben aↄ̃ gàa wà lìga Ɛgɛlↄnizi aↄ̃ lɛ̀ɛa. ");
INSERT INTO bus_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","Aↄ̃ wɛ́tɛ pì sì zĩ beeea gↄ̃ↄ, ben aↄ̃ gbɛ̃ kɛ̀ aↄ̃ↄ kúnnↄ dɛ̀dɛ kↄ̃n fɛ̃ɛdaao aↄ̃ ń káatɛ lán aↄ̃ↄ kɛ̀ Lakisinɛ nà. ");
INSERT INTO bus_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","Kɛ̀ aↄ̃ bↄ̀ɛ Ɛgɛlↄni, ben aↄ̃ gàa Ɛblↄnu aↄ̃ lɛ̀ɛa. ");
INSERT INTO bus_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","Aↄ̃ wɛ́tɛ pì sì aↄ̃ à gbɛ̃nↄ kↄ̃n à kínao dɛ̀dɛ kↄ̃n fɛ̃ɛdaao kↄ̃n à lakutudeenↄ. Aↄ̃ gbɛ̃ kɛ̀ aↄ̃ↄ kúnnↄ kàatɛ, aↄ̃ gbɛ̃kee e bↄro, lán aↄ̃ↄ kɛ̀ Ɛgɛlↄninɛ nà. ");
INSERT INTO bus_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","Ben aↄ̃ gàa Dɛbi aↄ̃ lɛ̀ɛa. ");
INSERT INTO bus_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","Aↄ̃ wɛ́tɛ pì sì kↄ̃n à kínao kↄ̃n à lakutunↄ píngi. Ben aↄ̃ ń dɛ́dɛ kↄ̃n fɛ̃ɛdaao aↄ̃ gbɛ̃ kɛ̀ aↄ̃ↄ kúnnↄ kàatɛ lán aↄ̃ↄ kɛ̀ Ɛblↄnunɛ nà, aↄ̃ gbɛ̃kee e bↄro. Aↄ̃ↄ kɛ̀ Dɛbinɛ kↄ̃n à kínao lán aↄ̃ↄ kɛ̀ Libinanɛ kↄ̃n à kínao nà. ");
INSERT INTO bus_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","Yↄsua bùsu pì deenↄ kↄ̃n à kínanↄ dɛ̀dɛ ń píngi, gusĩsĩdeenↄ kↄ̃n Nɛgɛvideenↄ kↄ̃n gusararadeenↄ kↄ̃n sĩ̀sĩgɛɛdeenↄ ń píngi. Èe gbɛ̃ke tó bɛ̃ɛro, à gbɛ̃ kɛ̀ aↄ̃ↄ kú gweenↄ kàatɛ lán Dii Isarailinↄ Ludaa ònɛ nà. ");
INSERT INTO bus_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","À ń dɛ́dɛ sɛna zaa Kadɛsi Banɛa ai à gàa pɛ́ Gazaa, zaa Gosɛ̃ bùsun píngi ai à gàa pɛ́ Gibiↄ̃a. ");
INSERT INTO bus_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","Yↄsua zĩ̀ blè kína pìnↄa kↄ̃n ń bùsunↄ gɛ̃̀n do gↄ̃ↄ, kɛ̀ Dii Isarailinↄ Ludaa e zĩ̀ kaańnɛ yãnzi. ");
INSERT INTO bus_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","Ben à ɛ̀ara kↄ̃n a gbɛ̃nↄo bùran zaa Giligala. ");
INSERT INTO bus_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","Kɛ̀ Azo kí Yabĩ à baaru mà, à gbɛ̃nↄ zĩ̀ Madↄ̃ kí Yobabua kↄ̃n Simirↄnu kínao kↄ̃n Akasafa kínao ");
INSERT INTO bus_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","kↄ̃n kína kɛ̀ aↄ̃ↄ kú gu'igbãroo kpaanↄ ń píngi, kína kɛ̀ aↄ̃ↄ kú gukpiideenↄ kↄ̃n sɛ̃̀tɛpↄↄtu kɛ̀ kú Galili sↄↄmɛtɛ kpaao kↄ̃n gusararaao kↄ̃n Dↄru gusĩsĩdee kɛ̀ kú ↄfãntɛ̃gɛ̃kpɛn kpaao. ");
INSERT INTO bus_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","Ben à ɛ̀ara à gbɛ̃nↄ zĩ̀ dↄ Kanaa kɛ̀ aↄ̃ↄ kú ↄfãntɛ̃bↄɛ kpaanↄa kↄ̃n ↄfãntɛ̃gɛ̃kpɛn kpaanↄ ń píngi, Amↄrinↄ kↄ̃n Itinↄ kↄ̃n Pɛrizinↄ kↄ̃n Yebusi kɛ̀ aↄ̃ↄ kú gukpiideennↄ kↄ̃n Ivi kɛ̀ aↄ̃ↄ kú Mizipa bùsun Ɛmↄni gbɛ̀ saɛnↄo. ");
INSERT INTO bus_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","Aↄ̃ bↄ̀ɛ kↄ̃n ń zĩ̀kpɛɛnↄ ń píngi paripari lán ísialɛ bùsu'ãatɛ̃ bà. Aↄ̃ sↄ̃nↄ kↄ̃n ń sↄ̃goronↄↄ pari. ");
INSERT INTO bus_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","Ben kína pìnↄ kↄ̃ kàkↄ̃a aↄ̃ mↄ̀ wà bùra kàɛ lɛdo Mɛromu ínↄ saɛ, lɛ wà zĩ̀ ká kↄ̃n Isarailinↄ. ");
INSERT INTO bus_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","Ben Dii bè Yↄsuanɛ: Ǹton vĩa kɛńnɛro. Zia mↄndaa'i mɛ́ ń na Isarailinↄnɛ ń ↄzĩ aↄ̃ ń dɛdɛ. Ǹ ń sↄ̃nↄ gbátĩkyanↄ zↄ̃zↄ̃ ǹ ń sↄ̃goronↄ kpata. ");
INSERT INTO bus_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","Ben Yↄsua kↄ̃n a zĩ̀kpɛɛnↄ gàańzi zĩ̀o kãndo ń píngi aↄ̃ dàńla Mɛromu ínↄ saɛ gwe. ");
INSERT INTO bus_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","Dii ń náńnɛ ń ↄzĩ, ben aↄ̃ ń dɛ́dɛ aↄ̃ pɛ̀ ń gbɛ̃kenↄa ai Sidↄ̃ mɛɛwin kↄ̃n Misirefo Maimuo kↄ̃n Mizipa guzurɛ kɛ̀ kú ↄfãntɛ̃bↄɛ kpaao. Aↄ̃ ń dɛ́dɛ, aↄ̃ gbɛ̃kee e bↄro. ");
INSERT INTO bus_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","Yↄsua kɛ̀ńnɛ lán Dii ònɛ nà, à ń sↄ̃nↄ gbátĩkyanↄ zↄ̃̀zↄ̃ à ń sↄ̃goronↄ kpàta. ");
INSERT INTO bus_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","Zĩ pìa Yↄsua lìara à gàa à Azo sì, ben à à kína dɛ̀ kↄ̃n fɛ̃ɛdaao. Azo pìn kína pìnↄ wɛ́tɛ mìdee ũ gurↄ beeea. ");
INSERT INTO bus_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","Isarailinↄ gbɛ̃ kɛ̀ aↄ̃ↄ kúnnↄ dɛ̀dɛ kↄ̃n fɛ̃ɛdaao aↄ̃ ń káatɛ, aↄ̃ gbɛ̃kee e gↄ̃ro, ben aↄ̃ tɛ́ sↄ̃̀a. ");
INSERT INTO bus_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","Yↄsua wɛ́tɛ pìnↄ sì píngi kↄ̃n ń kínanↄ, à ń dɛ́dɛ kↄ̃n fɛ̃ɛdaao à ń káatɛ lán Dii zↄ̀bleri Musa ò nà. ");
INSERT INTO bus_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","Mↄde Isarailinↄↄ e tɛ́ sↄ̃ wɛ́tɛ kɛ̀ wà ɛ̀ara wà kàɛ ń bɛzĩ gbɛ̀nnↄaro, séde Azo kɛ̀ Yↄsua tɛ́ sↄ̃̀a pì baasiro. ");
INSERT INTO bus_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","Isarailinↄ wɛ́tɛ pìnↄ pↄ́nↄ nàkↄ̃a ń pↄ́ ũ kↄ̃n ń pↄ́kãdeenↄ aↄ̃ tào. Aↄ̃ ń gbɛ̃nↄ dɛ̀dɛ kↄ̃n fɛ̃ɛdaao ń píngi ai aↄ̃ ń káatɛ, aↄ̃ↄe gbɛ̃ke tó bɛ̃ɛro. ");
INSERT INTO bus_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","Yã kɛ̀ Dii ò a zↄ̀bleri Musanɛ, Musa yã pì ò Yↄsuanɛ, ben Yↄsua kɛ̀ lɛ píngi, èe yã kɛ̀ Dii ò Musanɛ ke tóro. ");
INSERT INTO bus_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","Lɛn Yↄsua bùsu pì sì lɛ píngi, à gukpiide kↄ̃n Nɛgɛvio píngi kↄ̃n Gosɛ̃ bùsuo píngi kↄ̃n gusararaao kↄ̃n sɛ̃̀tɛpↄↄtuo píngi. À Isaraili gukpiide kↄ̃n gusararaao sì ");
INSERT INTO bus_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","sɛna zaa Alaki gbɛ̀ kɛ̀ kú Sei bùsun ai à gàa pɛ́ Baali Gada kɛ̀ kú Lɛbanↄ bùsu guzurɛn Ɛmↄni gbɛ̀ saɛ. À ń kínanↄ kũ̀kũ ń píngi à ń dɛ́dɛ. ");
INSERT INTO bus_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","À zĩ̀kana gì kɛ̀ kↄ̃n kína pìnↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","Ivi kɛ̀ aↄ̃ↄ kú Gibiↄ̃nↄ baasiro wɛ́tɛ kee e kↄ̃ yã mà kↄ̃n Isarailinↄro, aↄ̃ ń blé zĩ̀o píngi. ");
INSERT INTO bus_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","Dii bé à tò aↄ̃ swã gbã̀gbã, ben aↄ̃ zĩ̀ kà kↄ̃n Isarailinↄ, lɛ Isarailinↄ e wà ń kaatɛ ń wɛ̃ndagwana sai, à yãańyo mámmam lán à ò Musanɛ nà. ");
INSERT INTO bus_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","Gurↄↄ pìan Yↄsua gàa à Anakinↄ dɛ̀dɛ gukpiideen kↄ̃n Ɛblↄnuo kↄ̃n Dɛbio kↄ̃n Anabuo. À ń káatɛ à ń wɛ́tɛnↄ kɛ̀ dúgudugu Yuda gukpiideen kↄ̃n Isaraili gukpiideeo píngi. ");
INSERT INTO bus_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","Anaki bori kee e gↄ̃ Isarailinↄ bùsun dↄro, séde Gaza kↄ̃n Gatao kↄ̃n Asadↄdio. ");
INSERT INTO bus_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","Yↄsua bùsu pì sì píngi lán Dii ò Musanɛ nàmɛ, ben à kpà Isarailinↄa à kpàatɛtɛńnɛ danɛdanɛ túbi ũ. Ben bùsu pì gↄ̃̀ kaɛna aafia zĩ̀ sai. ");
INSERT INTO bus_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","À gurↄplaa kɛ̀ kɛ̀ Dii tò Isarailinↄ kámma bò ń ibɛɛ kɛ̀ aↄ̃ lìgańzinↄ yã musu, bensↄ̃ Yↄsua zi kũ̀ kótokoto. ");
INSERT INTO bus_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","Ben à Isarailinↄ sìsi, aↄ̃ gbɛ̃nsinↄ kↄ̃n ń mìdeenↄ kↄ̃n ń yãkpaɛkɛrinↄ kↄ̃n ń dↄn'aɛdeenↄ ń píngi, à bèńnɛ: Ma zi kũ̀ kótokoto. ");
INSERT INTO bus_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","A wɛ́ɛ è yã kɛ̀ Dii a Ludaa kɛ̀ bori beeenↄnɛ a yãnzi. Dii a Luda bé à zĩ̀ kàare. ");
INSERT INTO bus_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","Ma borii kɛ̀ aↄ̃ gↄ̃̀ Yoda dagura kↄ̃n ↄfãntɛ̃gɛ̃kpɛn kpa ísia bítaonↄ bùsu kpàatɛ a boriinↄnɛ túbi ũ kↄ̃n borii kɛ̀ ma ń káatɛnↄ pↄ́o. ");
INSERT INTO bus_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","Dii a Luda é ↄ sↄ̃ńziare eé pɛ́ḿmaare, é ń bùsunↄ síḿma lɛ àgↄ̃ vĩ lán à à lɛ́ gbɛ̃̀are nà. ");
INSERT INTO bus_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","À zɛ gbãa maamaa. À làakari kɛ àgↄ̃ zĩi kɛ yã kɛ̀ kú Musa doka takada guua. Àton pãnɛ ↄplazi ke ↄzɛziro. ");
INSERT INTO bus_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","A bà tóngↄ̃ kú kↄ̃n borii kɛ̀ aↄ̃ gↄ̃̀ a tɛ́ pìnↄoro. Àton ń tãanↄ tↄ́ sísiro, àton la dańyoro. Àton dↄńzi à kúɛńnɛro. ");
INSERT INTO bus_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","Àgↄ̃ naa Dii a Ludazi ado lán ée kɛɛ nà ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","Dii ↄ sↄ̃̀are bori bíta gbãadeenↄzi, gbɛ̃kee e fↄ̃ à a gã̀ fĩ̀ro ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","A gbɛ̃ mɛ̀n doo è gↄ̃ↄn wàa sↄↄroonↄ fu, kɛ̀ Dii a Ludaa e zĩ̀ kaaare lán à à lɛ́ gbɛ̃̀are nà yãnzi. ");
INSERT INTO bus_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","À làakari kɛ maamaa àgↄ̃ ye Dii a Ludazi. ");
INSERT INTO bus_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","Tó a kpɛɛ lìnɛ, ben a na borii kɛ̀ aↄ̃ gↄ̃̀ a tɛ́ pìnↄa, tó a ń nↄgbɛ̃nↄ sɛ̀ bensↄ̃ a kakↄ̃ańyo, ");
INSERT INTO bus_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","àgↄ̃ dↄ̃ sãnsãn kɛ̀ Dii a Luda é pɛ́are borii pìnↄa dↄro. Aↄ̃é gↄ̃are takutɛɛ ke mↄ̀ ũ ke flã̀nↄ ũ a kpɛɛgura kesↄ̃ kↄ̀kↄnↄ ũ a wɛ́ɛn ai a gaa kaatɛo bùsu maaa kɛ̀ Dii a Ludaa kpàawa kɛ̀kii guu. ");
INSERT INTO bus_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","À gwa! Ma ka gana anduna píngi gákiia sa. Á dↄ̃ a nↄ̀sɛn kↄ̃n a laasuuo píngi kɛ̀ sa maaa kɛ̀ Dii a Ludaa òareenↄ guu, baa mɛ̀n doo e kɛ pãro. À pàpa píngi, aↄ̃ kee e lɛ́ɛ pãro. ");
INSERT INTO bus_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","16","Lán sa maaa kɛ̀ Dii a Ludaa òaree pàpa a musu nà píngi, tó a Dii a Luda bà kuunaao yã kɛ̀ à dìɛaree gbòro, a gaa a dↄ tãanↄzi a kuɛńnɛ, Dii é tó sa zaaa kɛ̀ à ò pìnↄ píngi a le ai à gá à a kaatɛo bùsu maaa kɛ̀ à kpàawaa kɛ̀kiin. Dii é pↄfɛ̃ pitaawa, é kaatɛ gↄ̃ↄ bùsu maaa kɛ̀ à kpàawaa kɛ̀kii pìn. ");
INSERT INTO bus_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Yↄsua Isaraili boriinↄ kàkↄ̃a Sɛkɛmu. À Isaraili gbɛ̃nsinↄ kↄ̃n ń mìdeenↄ kↄ̃n ń yãkpaɛkɛrinↄ kↄ̃n ń dↄn'aɛdeenↄ sìsi, ben aↄ̃ mↄ̀ wà zɛ̀ Luda aɛ. ");
INSERT INTO bus_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Ben Yↄsua bèńnɛ: Yã kɛ̀ Dii Isarailinↄ Ludaa òn yɛ̀: A dezinↄ kú Yuflati baa kãa kpamɛ yã, aↄ̃ dↄ̀ tãanↄzi. Ibraĩ kↄ̃n Naonↄ de Tera kú ń tɛ́. ");
INSERT INTO bus_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Ben ma a dezi káaku Ibraĩ sɛ̀ zaa Yuflati baa kãa kpa, ma gɛ̃tɛo Kanaa bùsun píngi, ben má tò à borii kↄ̃̀. Ma à gbà Isaaku, ");
INSERT INTO bus_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","ben ma Isaaku gbà Yakubu kↄ̃n Isauo. Ma Isau gbà Sei gusĩsĩdee. Yakubu kↄ̃n a nɛ́nↄ sↄ̃ aↄ̃ tà Igipiti. ");
INSERT INTO bus_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","Ma Musa kↄ̃n Arunao zĩ̀, ben ma wɛ́ɛ tã̀ Igipitinↄa kↄ̃n yã kɛ̀ má kɛ̀ ń tɛ́nↄ, ben ma a bↄɛn. ");
INSERT INTO bus_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","Kɛ̀ ma a dezinↄ bↄ̀ɛ Igipiti, kɛ̀ a ka ísiaazi, ben Igipitinↄ pɛ̀ɛazi kↄ̃n sↄ̃goronↄ kↄ̃n sↄ̃deenↄ ai Isia Tɛ̃aazi. ");
INSERT INTO bus_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","Kɛ̀ a wii pɛ̀mazi, ben ma gusiaa dà a dagura kↄ̃n Igipiti pìnↄ, ben má tò ísiaa dàńla míↄmiↄ. A wɛ́ɛ yã kɛ̀ má kɛ̀ Igipitinↄnɛ è. Beee gbɛra a gurↄplaa kɛ̀ gbáan. ");
INSERT INTO bus_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","Ma mↄao Amↄri kɛ̀ aↄ̃ↄ kú Yoda ↄfãntɛ̃bↄɛ kpaanↄ bùsun. Kɛ̀ aↄ̃ fɛ̀ɛazi zĩ̀o, ben ma ń náare a ↄzĩ. Ma ń káatɛ, ben aↄ̃ bùsu gↄ̃̀ a pↄ́ ũ. ");
INSERT INTO bus_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","Kɛ̀ Zipo nɛ́ Balaki, Mↄabunↄ kína fɛ̀ɛazi zĩ̀o, à Bɛↄ nɛ́ Balamu sìsi à a ká. ");
INSERT INTO bus_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","Ben ma gi Balamu yã mazi má tò à sa maaa òare, ma a bↄ Balaki ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","Beee gbɛra a bikũ Yodaa a ka Yɛriko. Ben Yɛrikodeenↄ zĩ̀ kàao. Amↄrinↄ kↄ̃n Pɛrizinↄ kↄ̃n Kanaanↄ kↄ̃n Itinↄ kↄ̃n Gigasinↄ kↄ̃n Ivinↄ kↄ̃n Yebusinↄ zĩ̀ kàao dↄ, ben ma ń náare a ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","Ma zↄ̃mantɛ̃nↄ gbàrɛ a aɛ, aↄ̃ pɛ̀are Amↄrinↄ kína gↄ̃ↄn plaaanↄa. Èe kɛ a fɛ̃ɛdaa ke a kà bé à pɛ̀ḿmaro. ");
INSERT INTO bus_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","Ma tↄↄtɛ kɛ̀ ámbe a à zĩi kɛ̀roo kpàawa kↄ̃n wɛ́tɛ kɛ̀ ámbe á kàɛroonↄ, ben á kú wɛ́tɛ pìnↄ guu. Ée geepi lí kↄ̃n kù lí kɛ̀ ámbe á bàroonↄ bɛɛ blee. ");
INSERT INTO bus_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","Ben Yↄsua bè: Àgↄ̃ Dii vĩa vĩ àgↄ̃ dↄↄzi yãpura kↄ̃n nↄ̀sɛo do. À tãa kɛ̀ a dezinↄ dↄ̀ńzi Yuflati baa kãa kpa kↄ̃n Igipitionↄ bↄ a tɛ́ à dↄ Diizi. ");
INSERT INTO bus_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Tó zↄ̀blena Diinɛ kɛ̀are zaa, ɛ̃ndɛ̃ à zɛ kↄ̃n tãa kɛ̀ á yezi à dↄzio gbã̀a, tãa kɛ̀ a dezinↄ dↄ̀ńzi Yuflati baa kãa kpaanↄn yoo, kesↄ̃ Amↄri kɛ̀ á kú ń bùsunnↄ pↄ́. Mↄde mamↄma kↄ̃n ma bɛdeenↄ, Diin wégↄ̃ dↄↄzi. ");
INSERT INTO bus_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Ben gbɛ̃nↄ wèàla wà bè: Gyam! Wé fↄ̃ wà pã kpá Diizi wà dↄ tãanↄziro. ");
INSERT INTO bus_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Dii wa Luda bé à wa bↄ zↄ̀bleen Igipiti bùsun kↄ̃n wa denↄo. Àmbe à dabuyã bíta pìnↄ kɛ̀ wa wáa, à wa dãkpa wa táa'ona guu píngi à wa bↄ borii kɛ̀ wa gɛ̃tɛ ń guunↄ ↄzĩ ń píngi. ");
INSERT INTO bus_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Dii bé à pɛ̀we Amↄrinↄa kↄ̃n borii kɛ̀ aↄ̃ↄ kú bùsu kɛ̀kiinnↄo. Beee yãnzi wégↄ̃ dↄↄ Diizi se, zaakɛ àmbe wa Luda ũ. ");
INSERT INTO bus_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Ben Yↄsua bè gbɛ̃nↄnɛ: É fↄ̃ à dↄ Diiziro. Zaakɛ à kú adona, Luda nↄ̀sɛgↄ̃aanↄdeemɛ. Eé a taarinↄ kↄ̃n a durunnↄ kɛ̃arero. ");
INSERT INTO bus_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","Baa kɛ̀ à yã maaa kɛ̀are yã, tó a pã kpàzi a dↄ bori zĩ̀tↄnↄ tãanↄzi, eé ɛara à kisia zĩawa à a kaatɛ. ");
INSERT INTO bus_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Ben gbɛ̃nↄ bè Yↄsuanɛ: Lɛnlo! Diin wégↄ̃ dↄↄzi. ");
INSERT INTO bus_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","Ben Yↄsua bèńnɛ: Ámbe a zĩnda sèedadeenↄ ũ, kɛ̀ a zɛo àgↄ̃ dↄↄ Diizi. Ben aↄ̃ bè: Ee! À sèedadeenↄn wa ũ. ");
INSERT INTO bus_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Ben Yↄsua bè: Tó lɛmɛ, à bori zĩ̀tↄnↄ tãa kɛ̀ aↄ̃ↄ kúaonↄ bↄ a tɛ́ à a swɛ̃̀ kpá Dii Isarailinↄ Ludaa. ");
INSERT INTO bus_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Ben gbɛ̃nↄ bènɛ: Dii wa Ludan wégↄ̃ dↄↄzi wàgↄ̃ à yã maa. ");
INSERT INTO bus_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","Zĩ beeean Yↄsua ɛ̀ara à Dii bà kuunańyo yã kɛ̀kɛ gbɛ̃nↄnɛ. Zaa Sɛkɛmu gwe à dokayãnↄ kↄ̃n yãdiɛnanↄ zɛ́ kpàɛńnɛ, ");
INSERT INTO bus_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","ben à yã pìnↄ kɛ̃̀ Luda doka takadan. Ben à gbɛ̀ gbɛ̃̀ntɛ̃ sɛ̀ à pɛ̀ɛ gbíi lí gbáru Dii gbãgbãkiia gwe. ");
INSERT INTO bus_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Ben à bè gbɛ̃nↄnɛ: À gwa! Gbɛ̀ kɛ̀kii bé eégↄ̃ dɛwe sèedadee ũ. Gbɛ̀ pì yã kɛ̀ Dii òwee mà píngi. Eégↄ̃ dɛare sèedadee ũ lɛ àton mↄnafiki kɛ a Ludanɛro. ");
INSERT INTO bus_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Yↄsua gbɛ̃nↄ gbàrɛ, ben baade tà a bùsu kɛ̀ wà kpàa túbi ũu guu. ");
INSERT INTO bus_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Yã beeenↄ gbɛra Dii zↄ̀bleri Yↄsua, Nuni nɛ́ gà. À kɛ̀ wɛ̃̀ basↄↄro akuri. ");
INSERT INTO bus_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Wà à vĩ̀i guu kɛ̀ dɛ à túbi ũu guu Timina Sɛra, Ɛflaimunↄ gukpiideen Gaasi kpiii gu'igbãroo kpa. ");
INSERT INTO bus_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Isarailinↄ dↄ̀ Diizi Yↄsua gurↄ píngi kↄ̃n gbɛ̃nsi kɛ̀ aↄ̃ↄ kuu à gbɛraanↄ gurↄↄo dↄ. Gbɛ̃nsi pìnↄ wɛ́ɛ sì yã kɛ̀ Dii kɛ̀ Isarailinↄnɛlɛ píngi. ");
INSERT INTO bus_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Yusufu wánↄ kɛ̀ Isarailinↄ bↄ̀o Igipiti sↄ̃, aↄ̃ↄ vĩ̀i Sɛkɛmu tↄↄtɛ guu, kɛ̀ Yakubu lù Sɛkɛmu de Amↄ nɛ́nↄa kondogi basↄↄro. Tↄↄtɛ pì kú Yusufunↄ túbi guumɛ. ");
INSERT INTO bus_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Kɛ̀ Aruna nɛ́ Ɛlɛaza gà, ben wà à vĩ̀i zaa Gibɛa, wɛ́tɛ kɛ̀ wà kpà à nɛ́ Finɛasia túbi ũ Ɛflaimunↄ gukpiideen. ");
INSERT INTO bus_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","Yↄsua gaa gbɛra Isarailinↄ Dii gbèka wà bè: Dénↄ bé weé gá zĩ̀ káwe kↄ̃n Kanaanↄo káakuu? ");
INSERT INTO bus_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","Ben Dii bè: Yudanↄ bé weé gá. À ma! Ma bùsu pì nàńnɛ ń ↄzĩmɛ. ");
INSERT INTO bus_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","Ben Yudanↄ bè ń danɛ Simɛↄnↄnɛ: À mↄ́ à gá zɛwe guu kɛ̀ Ludaa kpàwa túbi ũu guu, wà zĩ̀ ká kↄ̃n Kanaanↄ wé gbasa wà gá zɛare guu kɛ̀ à kpàawaan. Ben Simɛↄnↄ gàańyo. ");
INSERT INTO bus_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","Kɛ̀ Yudanↄ gàa lɛ, Dii Kanaanↄ kↄ̃n Pɛrizinↄ nàńnɛ ń ↄzĩ, ben aↄ̃ ń dɛ́dɛ zaa Bɛzɛki bↄrↄ kuri. ");
INSERT INTO bus_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","Gwen aↄ̃ Adonibɛzɛki lèn aↄ̃ zĩ̀ kào, ben aↄ̃ Kanaanↄ kↄ̃n Pɛrizi pìnↄ dɛ̀dɛ. ");
INSERT INTO bus_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","Kɛ̀ kína pì e bàa lɛɛ, ben aↄ̃ pɛ̀a. Aↄ̃ à kũ̀, ben aↄ̃ à ↄnɛmidaanↄ kↄ̃n à gbánɛmidaanↄ zↄ̃̀zↄ̃. ");
INSERT INTO bus_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","Ben Adonibɛzɛki bè: Ma kí gↄ̃ↄn baaagↄ̃ akurinↄ ↄnɛmidaanↄ kↄ̃n ń gbánɛmidaanↄ zↄ̃̀zↄ̃, ben aↄ̃ pↄ́blee kɛ̀ lɛ̀ɛ ma teebu gĩzĩ kↄ̃ↄ wɛ̀. Lán má kɛ̀ gbɛ̃ pìnↄnɛ nà, à fĩan Ludaa bòmɛ. Ben aↄ̃ gàao Yerusalɛmu, gwen à gàn. ");
INSERT INTO bus_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","Kɛ̀ Yudanↄ lɛ̀ɛ Yerusalɛmua, aↄ̃ↄ sì, ben aↄ̃ à gbɛ̃nↄ dɛ̀dɛ kↄ̃n fɛ̃ɛdaao aↄ̃ tɛ́ sↄ̃̀a. ");
INSERT INTO bus_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","Beee gbɛra Yudanↄ gàa wà zĩ̀ ká kↄ̃n Kanaa kɛ̀ aↄ̃ↄ kú gusĩsĩdeennↄ kↄ̃n Nɛgɛvio kↄ̃n gusararaao. ");
INSERT INTO bus_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","Aↄ̃ gàa wà lɛ̀ɛ Kanaa kɛ̀ wà kú Ɛblↄnunↄa. Ɛblↄnu tↄ́n Kiriataba yã. Gwen aↄ̃ zĩ̀ blèn Sesai kↄ̃n Aimao kↄ̃n Talamaioa. ");
INSERT INTO bus_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","Bↄna gwe aↄ̃ gàa lɛ́ɛ Dɛbideenↄa. Dɛbi tↄ́n Kiriasɛfa yã. ");
INSERT INTO bus_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","Ben Kalɛbu bè: Gbɛ̃ kɛ̀ lɛ̀ɛ Kiriasɛfa pìa à sìn, mɛ́ ma nɛ́nↄgbɛ̃ Akasa kpáa nↄↄ ũ. ");
INSERT INTO bus_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","Kalɛbu dãaro Kenazi nɛ́ Ɔtↄniɛli bé à sì, ben Kalɛbu a nɛ́nↄgbɛ̃ pì kpàa. ");
INSERT INTO bus_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","Kɛ̀ à à sɛ̀, ben à nàkↄ̃rɛa à gá tↄↄtɛ wɛ́ɛ kɛ a dea. Kɛ̀ nↄgbɛ̃ pì pìta a zaakia, ben Kalɛbu à là à bè: Bↄ́n ń yezi? ");
INSERT INTO bus_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","Ben à wèàla à bè: Ǹ gbaa kɛmɛ. Zaakɛ guu kɛ̀ n ma gbaa kú Nɛgɛvi gbáan, ǹ ma gba à íbↄkidee dↄ. Ben Kalɛbu à gbà guu kɛ̀ à íbↄkii kún sĩ̀sĩ musu kↄ̃n kɛ̀ à íbↄkii kú guzurɛ guuo. ");
INSERT INTO bus_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","Musa anzure borii kɛ̀ wè be Keninↄ bↄ̀ wɛ́tɛ daminalideen kↄ̃n Yudanↄ, aↄ̃ gàa wà vɛ̃̀ɛńyo ń bùsun Aradi saɛ Nɛgɛvi gbáan. ");
INSERT INTO bus_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","Ben Yudanↄ kↄ̃n ń danɛ Simɛↄnↄ gàa wà lɛ̀ɛ Kanaa kɛ̀ aↄ̃ↄ kú Zɛfanↄa. Aↄ̃ wɛ́tɛ pì kàatɛ mámmam, ben aↄ̃ tↄ́ kpànɛ Ɔↄma. ");
INSERT INTO bus_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","Yudanↄ Gaza kↄ̃n Asakɛlↄnio kↄ̃n Ɛkɛrↄnuo kↄ̃n ń guunↄ sì. ");
INSERT INTO bus_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","Dii kúńyo, ben aↄ̃ ń gukpiidee sì, mↄde aↄ̃ↄe fↄ̃ wà pɛ̀ gusararadeenↄaro, kɛ̀ gbɛ̃ pìnↄ sↄ̃goro mↄ̀pↄnↄ vĩ yãnzi. ");
INSERT INTO bus_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","Wà Ɛblↄnu kpà Kalɛbua, lán Musa à lɛ́ gbɛ̃̀ nà, ben à pɛ̀ Anaki bori gↄ̃ↄn aagↄ̃ↄnↄa gwe. ");
INSERT INTO bus_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","Bɛyãminↄ sↄ̃ↄ e pɛ́ Yebusi kɛ̀ aↄ̃ↄ kú Yerusalɛmunↄaro, ben Yebusinↄↄ kúńyo Yerusalɛmu ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","Yusufunↄ sↄ̃ lɛ̀ɛ Bɛtɛlia bensↄ̃ Dii kúńyo. ");
INSERT INTO bus_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","Bɛtɛli tↄ́n Luzu yã. Kɛ̀ aↄ̃ gbɛ̃nↄ zĩ̀ Bɛtɛli asii gwa, ");
INSERT INTO bus_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","gu'asiigwari pìnↄ gↄ̃gbɛ̃ ke è èe bↄↄ wɛ́tɛ pìn, ben aↄ̃ bènɛ: Ǹ owe dian wé kɛ nà wà gɛ̃ wɛ́tɛ guu wé gbɛ̃kɛɛ kɛnnɛ. ");
INSERT INTO bus_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","Kɛ̀ à zɛ́ ↄ̀dↄańnɛ, ben aↄ̃ wɛ́tɛ pì deenↄ dɛ̀dɛ kↄ̃n fɛ̃ɛdaao, ben aↄ̃ gↄ̃gbɛ̃ pì tò kↄ̃n à danɛnↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","Gↄ̃gbɛ̃ pì gàa Itinↄ bùsun à wɛ́tɛ kàɛ gwe, ben à tↄ́ kpànɛ Luzu. Tↄ́ beee bé à gↄ̃̀nɛ ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","Manasenↄↄ e pɛ́ Kanaa kɛ̀ aↄ̃ↄ kú Bɛtɛsã kↄ̃n Tanakio kↄ̃n Dↄruo kↄ̃n Ibleamuo kↄ̃n Mɛgidoo kↄ̃n ń lakutunↄaro, zaakɛ aↄ̃ gì wà kpɛ́ vɛ̃ɛ bùsu pìmmɛ. ");
INSERT INTO bus_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","Kɛ̀ Isarailinↄ gbãaa è, ben aↄ̃ Kanaanↄ dà zↄ̀zĩin, aↄ̃ↄe pɛ́ḿma ń píngiro. ");
INSERT INTO bus_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","Lɛmɛ se Ɛflaimunↄↄ e pɛ́ Kanaa kɛ̀ aↄ̃ↄ kú Gɛzanↄaro, ben aↄ̃ↄ kú gwe lɛdo. ");
INSERT INTO bus_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","Lɛmɛ dↄ Zɛbuluninↄↄ e pɛ́ Kanaa kɛ̀ aↄ̃ↄ kú Kitironu kↄ̃n Naloluonↄaro, ben aↄ̃ ń dá zↄ̀zĩin. ");
INSERT INTO bus_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","Lɛmɛ dↄ Asanↄↄ e pɛ́ gbɛ̃ kɛ̀ aↄ̃ↄ kú Ako kↄ̃n Sidↄ̃o kↄ̃n Alabuo kↄ̃n Akazibuo kↄ̃n Ɛlɛbao kↄ̃n Afɛkio kↄ̃n Reobuoaro, ");
INSERT INTO bus_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","ben aↄ̃ vɛ̃̀ɛ lɛdo kↄ̃n Kanaa bùsudee pìnↄo. ");
INSERT INTO bus_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","Lɛmɛ dↄ Nafatalinↄↄ e pɛ́ Bɛsɛmɛsideenↄ kↄ̃n Bɛtanadeenↄaro, ben aↄ̃ vɛ̃̀ɛ lɛdo kↄ̃n Kanaa bùsudee pìnↄ aↄ̃ ń dá zↄ̀zĩin. ");
INSERT INTO bus_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","Amↄrinↄ Daninↄ yĩ̀pa aↄ̃ ń kpá gukpiideen, aↄ̃ↄe weńnɛ aↄ̃ mↄ́ vɛ̃ɛ gusararaanlo. ");
INSERT INTO bus_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","Amↄri pìnↄ gì wà kpɛ́ vɛ̃ɛ Ɛrɛsi kpiiia kↄ̃n Ayalↄnio kↄ̃n Salabimuo. Kɛ̀ Yusufunↄ gbãaa kàara, ben aↄ̃ ń dá zↄ̀zĩin. ");
INSERT INTO bus_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","Amↄrinↄ bùsu lɛ́zɛkii nàa zaa Swí Gbɛ̀kotozɛn ai à gàa pɛ́ Selaa ai à gàao aɛ kpa. ");
INSERT INTO bus_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","Dii Malaika bↄ̀ Giligala à gàa Bokimu à bè: Ma a bↄɛ Igipiti, ma gɛ̃ao bùsu kɛ̀ ma la dà a dezinↄnɛ kɛ̀kii guu. Ma bè mɛ́ ma bà kuunaao yã gboro zikiro. ");
INSERT INTO bus_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","Má òare a yã tón kakↄ̃a kↄ̃n bùsu kɛ̀ deenↄoro. Má òare à ń sa'okiinↄ gboro, ben ée ma yã maro. À kɛ̀ dia á kɛ̀ lɛɛ? ");
INSERT INTO bus_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","Tↄ̀! Mɛ́ɛ ooare, mɛ́ pɛ́ḿmaare dↄro. Aↄ̃égↄ̃ dɛare lɛ̀ ũ a gbã̀ntɛ̃a bensↄ̃ aↄ̃ tãanↄ égↄ̃ dɛare takutɛɛ ũ. ");
INSERT INTO bus_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","Kɛ̀ Dii Malaika yã pì ò Isarailinↄnɛ, aↄ̃ ↄ́ↄ dↄ̀ gbãngbãn. ");
INSERT INTO bus_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","Ben aↄ̃ tↄ́ kpà guu pìnɛ Bokimu, ben aↄ̃ saa ò Diia gwe. ");
INSERT INTO bus_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","Yↄsua gbɛ̃nↄ gbarɛna gbɛra baade gàa à guu kɛ̀ wà kpàa túbi ũu kũ̀. ");
INSERT INTO bus_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","Aↄ̃ dↄ̀ Diizi Yↄsua gurↄↄa píngi kↄ̃n gbɛ̃nsi kɛ̀ aↄ̃ↄ kuu à gbɛraanↄ gurↄo dↄ. Gbɛ̃nsi pìnↄ wɛ́ɛ sì yã bíta kɛ̀ Dii kɛ̀ Isarailinↄnɛlɛ píngi. ");
INSERT INTO bus_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","Kɛ̀ Dii zↄ̀bleri Nuni nɛ́ Yↄsua kɛ̀ wɛ̃̀ basↄↄro akuri, ben à gà. ");
INSERT INTO bus_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","Wà à vĩ̀i guu kɛ̀ dɛ à túbi ũu guu zaa Timina Ɛrɛsi, Ɛflaimunↄ gukpiideen, Gaasi kpii gu'igbãroo kpa. ");
INSERT INTO bus_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Kɛ̀ Yↄsua gurↄ gbɛ̃nↄ gàga ń píngi, nɛ́ kɛ̀ aↄ̃ fɛ̀ɛ ń gbɛraanↄↄ Dii dↄ̃ro, bensↄ̃ aↄ̃ yã kɛ̀ à kɛ̀ ń dezinↄnɛ dↄ̃ro. ");
INSERT INTO bus_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","Ben aↄ̃ yã kɛ̀ zaa Diinɛ kɛ̀ aↄ̃ dↄ̀ tãanↄzi. ");
INSERT INTO bus_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","Aↄ̃ pã kpà Dii ń dezinↄ Luda kɛ̀ à ń bↄ́ɛ Igipitizi, aↄ̃ tɛ̀ borii kɛ̀ aↄ̃ↄ ligańzinↄ tãanↄzi aↄ̃ dↄnzi kɛ̀ńnɛ, ben aↄ̃ Dii pↄↄ fɛ̃̀. ");
INSERT INTO bus_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","Aↄ̃ pã kpàzi aↄ̃ dↄ̀ Baalizi kↄ̃n Asatorɛo. ");
INSERT INTO bus_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","Ben Dii pↄ fɛ̃̀ńzi à ń ná ń wɛ́ɛtãmmarinↄnɛ ń ↄzĩ aↄ̃ ń wáa. À ń kpá ń ibɛɛ kɛ̀ aↄ̃ↄ ligańzinↄa, ben aↄ̃ↄe fↄ̃ wà gì ń zĩndao ń ibɛɛ pìnↄ ↄzĩro. ");
INSERT INTO bus_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","Gurↄↄ kɛ̀ aↄ̃ gàa zĩ̀ ká píngi, Dii è bↄ ń kpɛɛmɛ lɛ yã tón bↄńyo nnaro yãnzi, lán à dàńnɛ ń swãla nà, ben aↄ̃ gↄ̃̀ wɛ́ɛtãmma bíta guu. ");
INSERT INTO bus_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","Ben Dii yãgↄ̃gↄ̃rinↄ bↄ̀bↄ ń tɛ́ lɛ aↄ̃ ń sí ń wɛ́ɛtãmmarinↄa. ");
INSERT INTO bus_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","Mↄde aↄ̃è ń yãgↄ̃gↄ̃ri pìnↄ yã maro, aↄ̃ pãpãa kɛ̀ wà dↄnzi kɛ̀ tãanↄnɛ. Aↄ̃ kɛ̃̀ zɛ́ kɛ̀ ń dezinↄ sɛ̀a kpakpaa, aↄ̃ègↄ̃ yã kɛ̀ Dii dìɛńnɛnↄ kũna lán ń dezi pìnↄ bàro. ");
INSERT INTO bus_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Tó Dii yãgↄ̃gↄ̃ri bↄ̀ ń tɛ́, ègↄ̃ kú kↄ̃n yãgↄ̃gↄ̃ri pìo, ben ègↄ̃ ń sí ń ibɛɛnↄ ↄzĩ ai yãgↄ̃gↄ̃ri pì wɛ̃̀ndi lɛ́n, zaakɛ tó aↄ̃ m̀bo gbɛ̃ kɛ̀ aↄ̃ↄe ↄ tↄ̃ↄḿma aↄ̃ↄe ĩa daḿmanↄ yãnzi, Dii è ń wɛ̃nda gwamɛ. ");
INSERT INTO bus_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Tó yãgↄ̃gↄ̃ri gà sↄ̃, aↄ̃è ɛara wà yaka dɛ ń denↄlamɛ. Aↄ̃è dↄ tãanↄzi aↄ̃è ń gbãgbã aↄ̃è dↄnzi kɛńnɛ. Aↄ̃è ń yãzaakɛna pìnↄ kↄ̃n ń swãgbãaao tóro. ");
INSERT INTO bus_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","Ben Dii pↄ fɛ̃̀ńzi à bè: Zaakɛ borii kɛ̀ ma bà kuuna kↄ̃n ń dezinↄ yã gbòro aↄ̃ↄe ma yã maro, ");
INSERT INTO bus_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","mɛ́ pɛ́ńnɛ borii kɛ̀ Yↄsua gà à ń tó ń bùsunnↄ kea dↄro. ");
INSERT INTO bus_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","Mɛ́ ń swi kɛ Isarailinↄa lɛ mà ń yↄ̃ mà gwa, tó aↄ̃é ma zɛ́ sɛ́ aↄ̃gↄ̃ ma yã kũna lán ń dezinↄ kũ̀ nà, ke tó aↄ̃é kɛ lɛro. ");
INSERT INTO bus_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","Beee yãnzin Dii borii pìnↄ tò gwezi. Èe ń na Yↄsuanɛ a ↄzĩ à pɛ̀ḿma gↄ̃ↄro. ");
INSERT INTO bus_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","1","Dii borii pìnↄ tò gwe lɛ à Isaraili kɛ̀ wèe Kanaa bùsu zĩ̀ ká ń wáaroonↄ yↄ̃ à gwao, ");
INSERT INTO bus_vpl VALUES ("JG3_2","008_3_2","JDG","3","2","2","lɛ dↄ à zĩ̀kana dada gbɛ̃ kɛ̀ aↄ̃ↄ zĩ̀kana dↄ̃ yãroo pìnↄnɛ. Borii pìnↄn yɛ̀: ");
INSERT INTO bus_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","Filisitininↄ kína gↄ̃ↄn sↄↄroonↄ kↄ̃n Kanaanↄ píngi kↄ̃n Sidↄ̃deenↄ kↄ̃n Ivi kɛ̀ aↄ̃ↄ kú Lɛbanↄ gukpiideennↄ zaa Baali Ɛmↄni gbɛ̀a ai à gàa pɛ́ Lebo Amataa. ");
INSERT INTO bus_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","À ń tó lɛ à Isarailinↄ yↄ̃ à gwao, tó aↄ̃égↄ̃ yã kɛ̀ à dìɛ ń dezinↄnɛ Musa gãzĩnↄ kũna. ");
INSERT INTO bus_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","Beee yãnzin Isarailinↄ vɛ̃̀ɛ Kanaanↄ tɛ́ kↄ̃n Itinↄ kↄ̃n Amↄrinↄ kↄ̃n Pɛrizinↄ kↄ̃n Ivinↄ kↄ̃n Yebusinↄozi. ");
INSERT INTO bus_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","Aↄ̃ ń nɛ́nↄgbɛ̃nↄ sɛ̀ nↄↄ ũ bensↄ̃ aↄ̃ ń nɛ́nↄgbɛ̃nↄ kpã̀sã borii pìnↄ nɛ́gↄ̃gbɛ̃nↄa, ben aↄ̃ dↄ̀ ń tãanↄzi. ");
INSERT INTO bus_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","Isarailinↄ yã kɛ̀ Dii gìzi kɛ̀. Dii ń Luda yã sã̀ńgu, ben aↄ̃ dↄ̀ Baalizi kↄ̃n Asatorɛo. ");
INSERT INTO bus_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","Ben Dii pↄ fɛ̃̀ńzi à ń yá Mɛsↄpↄtamia bùsu kí Kusãrisataimua, ben aↄ̃ zↄ̀ blènɛ ai wɛ̃̀ sↄraagↄ̃. ");
INSERT INTO bus_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","Kɛ̀ aↄ̃ wii pɛ̀ Diizi, ben à mìsiri bↄ̀ńnɛ, àmbe Kalɛbu dãaro Kenazi nɛ́ Ɔtↄniɛli ũ. Àmbe à ń bↄ́. ");
INSERT INTO bus_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","Dii Nini sùa, ben à yã gↄ̃̀gↄ̃ Isarailinↄnɛ à dↄ̀ńnɛ aɛ zĩ̀ guu. Dii Mɛsↄpↄtamia bùsu kí Kusãrisataimu nànɛ a ↄzĩ, ben à gbãaa mↄ̀nɛ. ");
INSERT INTO bus_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","Ben aↄ̃ bùsu gↄ̃̀ kaɛna aafia wɛ̃̀ baplaa ai Kenazi nɛ́ Ɔtↄniɛli gàa gao. ");
INSERT INTO bus_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","Isarailinↄ ɛ̀ara wà yã kɛ̀ Dii gìzi kɛ̀ dↄ, ben Dii tò Mↄabu kí Ɛgɛlↄni gbãaa mↄ̀ńnɛ à zaaa kɛ̀ aↄ̃ↄ kɛ̀ pì yãnzi. ");
INSERT INTO bus_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","Ɛgɛlↄni Amↄninↄ kↄ̃n Amalɛkinↄ nàawa, ben aↄ̃ mↄ̀ wà lɛ̀ɛ Isarailinↄa aↄ̃ wɛ́tɛ daminalidee sì. ");
INSERT INTO bus_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","Isarailinↄ zↄ̀ blè Mↄabu kí Ɛgɛlↄninɛ ai wɛ̃̀ baro plaasai. ");
INSERT INTO bus_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","Ben aↄ̃ wii pɛ̀ Diizi, ben à mìsiri bↄ̀ńnɛ, àmbe Gera nɛ́ Ɛudu, Bɛyãmi borii ũ. Ɔzɛdeemɛ. Isarailinↄ à zĩ̀ tángba kpá Mↄabu kí Ɛgɛlↄnia. ");
INSERT INTO bus_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","Ɛudu fɛ̃ɛ lɛ́kpaplaadee pì à gbã̀a kà gã̀sãsuu do. À nà a gbáda ↄplaaa a uta gbáru, ");
INSERT INTO bus_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","ben à gàa à tángba kpà Ɛgɛlↄnia. Ɛgɛlↄni sↄ̃ nɛ́ gbɛ̃ mɛ̀deemɛ maamaa. ");
INSERT INTO bus_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","Kɛ̀ Ɛudu kↄ̃n gbɛ̃ kɛ̀ aↄ̃ tángba sɛ̀ wà gàaonↄ tángba kpàa wà yã̀a, ben Ɛudu a gbɛ̃ pìnↄ gbàrɛ zɛ́n. ");
INSERT INTO bus_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","Ben à ɛ̀ara tãa kɛ̀ kú Giligala saɛ à sù kína pì kiia dↄ à bè: Má asiiyã ke vĩ mà onnɛ. Ben kína pì bè: À tó mà yã ma, ben à ìba kɛ̀ aↄ̃ↄ kúonↄ bↄ̀ɛ. ");
INSERT INTO bus_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","Ɛgɛlↄni vɛ̃ɛna ado kpɛ́ musu ĩampakiin, ben Ɛudu sↄ̃̀zi à bè: Má yã kɛ̀ bↄ̀ Luda kiia vĩ mà onnɛ. Kɛ̀ kína pì fɛ̀ɛ a kìtan, ");
INSERT INTO bus_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","ben Ɛudu a fɛ̃ɛ gà à wòto kↄ̃n ↄzɛɛo a gbáda ↄplaaa, ben à à zↄ̃̀o a gbɛɛɛn. ");
INSERT INTO bus_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","Ben fɛ̃ɛ pì gɛ̃̀ à gbɛɛɛn kↄ̃n a páo píngi ai à bↄ̀ à kpɛɛ kpa. Ɛudu e fɛ̃ɛ pì wotoro ai à gbɛɛ nↄ́si dààla. ");
INSERT INTO bus_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","Ɛudu bↄ̀ kpɛɛlɛa à kpɛ́ ĩampakii pì zɛ́ tàta à mↄ̀nɛ kã̀. ");
INSERT INTO bus_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","À bↄna gbɛra Ɛgɛlↄni zĩ̀rinↄ mↄ̀ aↄ̃ ĩampakii pì zɛ́ è kãna, ben aↄ̃ bè: Eégↄ̃ bĩikpɛɛ kɛɛ kpɛ́ ĩampakiian yee? ");
INSERT INTO bus_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","Aↄ̃ↄe à dãa ai aↄ̃ bídi kɛ̀. Kɛ̀ aↄ̃ↄ è èe zɛ́ wɛ̃ńnɛro, ben aↄ̃ mↄ̀nɛ sɛ̀ wà wɛ̃̀ aↄ̃ gɛ̃̀ wà ń dii è daɛna tↄↄtɛ gɛ̀ ũ. ");
INSERT INTO bus_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","Gurↄↄ kɛ̀ aↄ̃ↄ kpɛ́ wèe kí dãa lɛ, Ɛudu bàa lɛ̀ à dↄ̀ tãa pìnↄzi à tà Seira. ");
INSERT INTO bus_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","Kɛ̀ à kà gwe, à tò wà kuu pɛ̀ Ɛflaimu gukpiideen, ben Isarailinↄ pìtao kpiiinↄa, Ɛudu dↄ̀ńnɛ aɛ. ");
INSERT INTO bus_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","À bèńnɛ: À tɛ́mazi, zaakɛ Dii a ibɛɛ Mↄabunↄ nàare a ↄzĩ. Aↄ̃ tɛ̀zi, ben aↄ̃ Yoda bikũkii kɛ̀ è gá Mↄabunↄ bùsun sì, aↄ̃ↄe we gbɛ̃ke bikũ dↄro. ");
INSERT INTO bus_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","Zĩ beeea aↄ̃ Mↄabu gↄ̃ gbãaanↄ dɛ̀dɛ lán bↄrↄ kuri bà, aↄ̃ gbɛ̃kee e bↄro. ");
INSERT INTO bus_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","Zĩ beeean Isarailinↄ gbãaa mↄ̀ Mↄabunↄnɛ, ben aↄ̃ bùsu gↄ̃̀ kaɛna aafia ai wɛ̃̀ basiigↄ̃. ");
INSERT INTO bus_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","Ɛudu gbɛra Anata nɛ́ Samaga Filisitininↄ dɛ̀dɛ gↄ̃ↄn wàa aagↄ̃ kↄ̃n zùdãgoo. À Isarailinↄ mì sì se. ");
INSERT INTO bus_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","Kɛ̀ Ɛudu gà, Isarailinↄ ɛ̀ara wà yã kɛ̀ Dii gìzi kɛ̀ dↄ. ");
INSERT INTO bus_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","Ben Dii ń yá Kanaa kí Yabĩ kɛ̀ vɛ̃ɛna Azoa. À zĩ̀kpɛɛnↄ gbɛ̃nsi tↄ́n Sisera. À bɛɛn Arose Goyimu. ");
INSERT INTO bus_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","À sↄ̃goro mↄ̀pↄnↄ vĩ mɛ̀n wàa siigↄ̃ kpɛ́ basↄↄro. À gbãaa mↄ̀ Isarailinↄnɛ pãsĩpãsĩ ai wɛ̃̀ baro, ben Isarailinↄ wii pɛ̀ Diizi. ");
INSERT INTO bus_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","Gurↄ beeea nↄgbɛ̃ annabi kɛ̀ wè benɛ Debora, Lapido naↄ̃ↄ dɛ Isarailinↄ yãgↄ̃gↄ̃ri ũ. ");
INSERT INTO bus_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","È yã gↄ̃gↄ̃ńnɛ a damina lí gbáru Rama kↄ̃n Bɛtɛlio dagura Ɛflaimunↄ gukpiideen. Isarailinↄ ègↄ̃ gaa à kiia gwe. ");
INSERT INTO bus_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","Ben à Abinↄamu nɛ́ Baraki kɛ̀ kú Kɛdɛsi, Nafatalinↄ bùsun sìsi à bènɛ: Dii Isarailinↄ Luda bè ǹ fɛɛ ǹ gá Nafatalinↄ kↄ̃n Zɛbuluninↄ sɛ́ gↄ̃ↄn bↄrↄ kuri ǹ gáńyo Tabo kpiiia. ");
INSERT INTO bus_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","Dii é Yabĩ zĩ̀kpɛɛnↄ gbɛ̃nsi Sisera gáɛ à mↄ́o Kisↄ̃ swaazi kↄ̃n à sↄ̃goronↄ kↄ̃n à zĩ̀kpɛɛnↄ paripari, gwen eé à nannɛ n ↄzĩn. ");
INSERT INTO bus_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","Ben Baraki bènɛ: Tó nɛ́ gámao dé, mɛ́ gá. Tó nɛ́ gámao sↄ̃ro, mɛ́ gáro. ");
INSERT INTO bus_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","Ben Debora bè: Mɛ́ gányo, mↄde zaakɛ ń ò lɛ, èe kɛ n tↄ́ bé eé bↄro. Nↄgbɛ̃n Dii é Sisera nanɛ a ↄzĩ sa. Ben Debora fɛ̀ɛ à gàao Kɛdɛsi. ");
INSERT INTO bus_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","Ben Baraki Zɛbuluninↄ kↄ̃n Nafatalinↄ kàkↄ̃a Kɛdɛsi, ben à dà zɛ́n kɛ̀sɛ kↄ̃n gↄ̃ↄn bↄrↄ kuri pìnↄ. Debora kú ń tɛ́. ");
INSERT INTO bus_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","Keni bori Eberu bↄ̀ Keninↄ bùsun yã, à mↄ̀ à bùra kàɛ gbíi lí kɛ̀ kú Zananimu gbáru Kɛdɛsi saɛ. Keninↄ nɛ́ Musa anzure Obabu boriinↄ dokemɛ. ");
INSERT INTO bus_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","Wà ò Siseranɛ kɛ̀ Abinↄamu nɛ́ Baraki gàa Tabo kpiiia, ");
INSERT INTO bus_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","ben à a sↄ̃goro mↄ̀pↄnↄ kàkↄ̃a mɛ̀n wàa siigↄ̃ kↄ̃n basↄↄrooo kↄ̃n zĩ̀kari kɛ̀ aↄ̃ↄ kúonↄ. À ń sɛ́ Arose Goyimu, aↄ̃ gàa Kisↄ̃ swaazi. ");
INSERT INTO bus_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","Ben Debora bè Barakinɛ: Ǹ gá, zaakɛ gbã̀an Dii é Sisera nannɛ n ↄzĩ. À dɛ Dii gĩakɛ à dↄ̀nnɛ aɛ kↄ̀ fá. Ben Baraki pìta Tabo kpiiia kↄ̃n zĩ̀kari gↄ̃ↄn bↄrↄ kuri pìnↄ. ");
INSERT INTO bus_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","Dii tò Sisera kↄ̃n à sↄ̃goronↄ kↄ̃n à zĩ̀karinↄ lɛ̀kↄ̃a Baraki fɛ̃ɛdaanɛ, ben Sisera bↄ̀ a sↄ̃goron à bàa lɛ̀. ");
INSERT INTO bus_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","Baraki pɛ̀ɛ Sisera zĩ̀karinↄ kↄ̃n ń sↄ̃goronↄzi ai Arose Goyimu. Gwen à ń dɛ́dɛn kↄ̃n fɛ̃ɛdaao ń píngi, baa gbɛ̃ mɛ̀n do èe gↄ̃ro. ");
INSERT INTO bus_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","Ben Sisera bàa lɛ̀ kɛ̀sɛ à gàa Keni bori Eberu naↄ̃ Yaɛli kuta kiia, zaakɛ Azo kí Yabĩ kↄ̃n Eberu bɛdeenↄ kↄ̃ yã mà yã. ");
INSERT INTO bus_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","Yaɛli bↄ̀ à dààlɛ à bè: Ǹ mↄ́ ǹ gɛ̃ kpɛ́n, Maree. Ǹ gɛ̃! Ǹton tó vĩa n kũro. Kɛ̀ à gɛ̃̀, ben nↄgbɛ̃ pì bisa dààla, ");
INSERT INTO bus_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","ben Sisera bènɛ: Ímii e ma dɛɛ. Ǹ ma gba í mà mi. Ben à zwi tùu sɛ̀ à tↄ̀nɛ à mì, ben à ɛ̀ara à bisa kùàla. ");
INSERT INTO bus_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","Sisera bènɛ: Ǹ zɛ kpɛɛlɛ. Tó gbɛ̃ke mↄ̀ à n la à be, gbɛ̃kee kú kɛ̀ↄ́, ǹ benɛ, auo. ");
INSERT INTO bus_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","Kpasa'ii à sɛ̀, ben Eberu naↄ̃ Yaɛli kuta káro sɛ̀ kↄ̃n ereeo à sↄ̃̀o Siserazi tɛɛɛ, ben à káro pì pɛ̀ à swãgɛɛa à pà ai à gɛ̃̀ à gàa à tↄↄtɛ kũ̀, ben à gà. ");
INSERT INTO bus_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","Baraki sↄ̃ↄ e pɛɛɛ Siserazi, ben Yaɛli bↄ̀ à gàa à dààlɛ à bè: Ǹ mↄ́ mà gbɛ̃ kɛ̀ nɛ́ɛ wɛtɛɛ ↄdↄannɛ. Kɛ̀ à gɛ̃̀ kpɛ́n, ben à Sisera è daɛna, à gà kↄ̃n károo pɛna à swãgɛɛa. ");
INSERT INTO bus_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","Zĩ beeean Luda Kanaa kí Yabĩ bùsa Isarailinↄnɛ. ");
INSERT INTO bus_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","Ben Isarailinↄ pãsĩkɛɛ e kaara ai aↄ̃ gàa wà Kanaa kí Yabĩ dɛ̀o. Ben aↄ̃ bùsu gↄ̃̀ a làakaria ai wɛ̃̀ baplaa. ");
INSERT INTO bus_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","Isarailinↄ ɛ̀ara wà yã kɛ̀ Dii gìzi kɛ̀ dↄ, ben Dii ń ná Midiãnↄnɛ ń ↄzĩ ai wɛ̃̀ swɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","Kɛ̀ Midiãnↄↄ e ↄ tↄ̃ↄḿma, ben Isarailinↄ utɛkiinↄ kɛ̀kɛ gukpiideenↄn kↄ̃n gbɛ̀wɛɛnↄ kↄ̃n sɛ̃̀tɛpↄↄtunↄo. ");
INSERT INTO bus_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","Tó aↄ̃ pↄ́ tↄ̃̀, Midiãnↄ kↄ̃n Amalɛkinↄ kↄ̃n ↄfãntɛ̃bↄɛ kpa bori pãndenↄ è mↄ́ wà lɛ́ɛḿmamɛ. ");
INSERT INTO bus_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","Aↄ̃è mↄ́ wà bùra káɛ ń bùsun, ben aↄ̃è ń bura pↄ́nↄ yakańnɛ ai à gá pɛ́o Gazaa. Aↄ̃è pↄ́ke tó Isarailinↄnɛro ke sãa ke zù ke zaaki. ");
INSERT INTO bus_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","Aↄ̃è mↄ́ kↄ̃n ń pↄ́kãdeenↄ kↄ̃n ń bisakutaanↄ paripari lán sutɛ̃nↄ bà. Gbɛ̃ke ègↄ̃ ḿpinↄ kↄ̃n ń lakuminↄ lɛ́ dↄ̃ro. Aↄ̃è mↄ́ wà bùsu yakamɛ. ");
INSERT INTO bus_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","Midiãnↄ Isarailinↄ kpà takaasikɛɛzi, ben aↄ̃ wii pɛ̀ Diizi. ");
INSERT INTO bus_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","Kɛ̀ aↄ̃ wii pɛ̀ Diizi Midiãnↄ yã musu lán beee bà, ");
INSERT INTO bus_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","ben Dii annabi bↄ̀ńnɛ à bè: Mamↄma Dii Isarailinↄ Luda ma bè ma a bↄ zↄ̀bleen ma a bↄɛ Igipiti. ");
INSERT INTO bus_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","Ma a bↄ Igipitinↄ ↄzĩ kↄ̃n gbɛ̃ kɛ̀ aↄ̃ ↄ tↄ̃̀awaanↄ ń píngi ma pɛ́ḿmaare, ben ma ń bùsu kpàawa. ");
INSERT INTO bus_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","Kɛ̀ ma bèare mámbe Dii a Luda ũ, àton Amↄri kɛ̀ á kú ń bùsunnↄ tãanↄ gbãgbãro, ben a gi ma yã mazi. ");
INSERT INTO bus_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","Dii Malaika mↄ̀ à vɛ̃̀ɛ gbíi lí gbáru zaa Ɔfla, Abiɛza bori Yoasi bɛ wɛ́tɛ. À nɛ́ Gidiↄn e blɛwɛɛ gbɛ̃ɛ geepi'ifɛ̃ki wɛ̀ɛn lɛ Midiãnↄ tón à ero yãnzi. ");
INSERT INTO bus_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","Kɛ̀ Dii Malaika bↄ̀ à mↄ̀zi, à bènɛ: Gↄ̃ gbãaa, Dii kúnyo. ");
INSERT INTO bus_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","Ben Gidiↄn bènɛ: Maree, tó Dii kúwao, bↄ́yãnzin yã kɛ̀nↄ wa lezi píngii? Dabuyã kɛ̀ wa denↄ à yã tↄ̃kɛ̃̀weenↄↄ kú mámɛ? Aↄ̃ bè Dii wa bↄɛ Igipiti, mↄde tiala à pã kpàwazi, ben à wa na Midiãnↄnɛ ń ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","Ben Dii aɛ dↄ̀a à bè: Ǹ gá kↄ̃n gbãaa kɛ̀ ń vĩio ǹ Isarailinↄ bↄ Midiãnↄ ↄzĩ. À dɛ mámbe mɛ́ɛ n zĩi fá. ");
INSERT INTO bus_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","Ben Gidiↄn à là à bè: Maree, mɛ́ fↄ̃ mà Isarailinↄ bↄ diamɛ? Ma ua bé à kɛ̃sãna Manasenↄ tɛ́ bensↄ̃ mámbe má nɛ́ngo dɛńla ma de bɛdeenↄ tɛ́. ");
INSERT INTO bus_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","Dii wèàla à bè: Mɛ́gↄ̃ kúnyo, nɛ́ Midiãnↄ lɛ́ ǹ nɛ lán gbɛ̃ mɛ̀n doo bà. ");
INSERT INTO bus_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","Ben Gidiↄn bènɛ: Tó ma n pↄnnaa è, ǹ sèeda ↄdↄamɛ lɛ màgↄ̃ dↄ̃ kɛ̀ ḿbe nɛ́ɛ yã oomao. ");
INSERT INTO bus_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","Ǹton gu kɛ̀ro ai mà su. Mɛ́ mↄ́nnɛ kↄ̃n gbaao mà diɛnnɛ. Ben à wèàla à bè: Mɛ́gↄ̃ kú kɛ̀ ai ǹ ɛara ǹ su. ");
INSERT INTO bus_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","Gidiↄn gàa à blènɛ dɛ̀ à kɛ̀kɛ, à burɛdi sɛ́sɛ'ɛ̃zɛ̃sai kɛ̀ kↄ̃n wísiti kilo kurio. À nↄ̀bↄ kà gbíin à dò kà oroon à gàao gbíi lí pì gbáru gwe, ben à dìɛnɛ. ");
INSERT INTO bus_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","Luda Malaika bènɛ: Ǹ nↄ̀bↄ kↄ̃n burɛdio sɛ́ ǹ káɛ gbɛ̀ kɛ̀kiia ǹ dò ɛɛa. Ben à kɛ̀ lɛ. ");
INSERT INTO bus_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","Ben Dii Malaika gò kɛ̀ à kũna zↄ̃̀ nↄ̀bↄ kↄ̃n burɛdi pìoa, ben tɛ́ bↄ̀ gbɛ̀ pì guu à kũ̀ nↄ̀bↄ kↄ̃n burɛdi pìoa, ben Dii Malaika pì gusii lɛ̀. ");
INSERT INTO bus_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","Kɛ̀ Gidiↄn dↄ̃̀ Dii Malaikamɛ, à bè: Kúku Dii Luda, ase n Malaikan ma wɛ́ɛ sìàlɛ tɛ̃tɛ̃ntɛ̃ↄ́? ");
INSERT INTO bus_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","Ben Dii bènɛ: Ǹgↄ̃ kú aafia! Ǹton tó vĩa n kũro. Nɛ́ garo. ");
INSERT INTO bus_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","Gidiↄn Dii gbãgbãkii bò gwe, ben à tↄ́ kpà guu pìnɛ Dii Aafiade. À kú Ɔfla Abiɛza gwe ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","Zĩ beeea gwãavĩ Dii bènɛ: Ǹ n de zùswaree kɛ̀ kà wɛ̃̀ swɛɛplaa kũ ǹ Baali gbãgbãkii kɛ̀ n dee vĩi gboro ǹ Asɛra lí kɛ̀ zɛ à saɛ zↄ̃ ǹ nɛ. ");
INSERT INTO bus_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","Ǹ mamↄma Dii n Luda gbãgbãkii bo a zɛ́a gu gbãaa kɛ̀kii musu. Ǹ Asɛra lí kɛ̀ ń zↄ̃̀ sɛ́ɛ yàka ũ ǹ sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ oma kↄ̃n zù pìo. ");
INSERT INTO bus_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","Ben Gidiↄn a zĩkɛrinↄ sɛ̀ gↄ̃ↄn kuri à kɛ̀ lán Dii ònɛ nà. Kɛ̀ èe vĩa kɛɛ a de bɛdeenↄnɛ kↄ̃n wɛ́tɛdeenↄ yãnzi, èe we à kɛ̀ fãantɛ̃ro, gwãavĩn à kɛ̀. ");
INSERT INTO bus_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","Kɛ̀ wɛ́tɛdeenↄ fɛ̀ɛ kↄngↄ, aↄ̃ↄ è wà Baali gbãgbãkii gbòro wà Asɛra lí kɛ̀ zɛ à saɛ zↄ̃̀ wà nɛ̀ wà saa ò kↄ̃n zùo sa'oki dufu kɛ̀ wà bòa. ");
INSERT INTO bus_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","Ben aↄ̃ kↄ̃ làla: Dé bé à kɛ̀kii kɛ̀? Kɛ̀ wà dↄ̀ńzi wà gbèkagbeka, ben aↄ̃ mà wà bè: Yoasi nɛ́ Gidiↄn bé à kɛ̀ lɛ. ");
INSERT INTO bus_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","Ben wɛ́tɛdeenↄ gàa wà bè Yoasinɛ: Ǹ bↄ kↄ̃n n nɛ́o wà à dɛ, zaakɛ à Baali gbãgbãkii gbòro bensↄ̃ à Asɛra lí kɛ̀ zɛ à saɛ zↄ̃̀ à nɛ̀. ");
INSERT INTO bus_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","Ben Yoasi bè gbɛ̃ kɛ̀ aↄ̃ↄ ligaaziinↄnɛ: Ámbe é yã sí kↄ̃n Baalioↄ́? Ámbe é à bↄↄ́? Weé gbɛ̃ kɛ̀ yã sìo dɛ ai guu gↄ̃ gá dↄ. Tó tãan à ũ, à gí a zĩndao à gbãgbãkii kɛ̀ wà gbòro yãnzi. ");
INSERT INTO bus_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","Zĩ beeean wà tↄ́ kpà Gidiↄnnɛ Yerubaali wà bè: Wà à tó kↄ̃n Baalio, zaakɛ à gbãgbãkiin à gbòro. ");
INSERT INTO bus_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","Midiãnↄ kↄ̃n Amalɛkinↄ kↄ̃n ↄfãntɛ̃bↄɛ kpa gbɛ̃ pãndenↄ kↄ̃ kàkↄ̃a ń píngi aↄ̃ bikũ̀ Yodaa, ben aↄ̃ bùra kàɛ Yɛzɛrili guzurɛn. ");
INSERT INTO bus_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","Dii Nini sù Gidiↄn-a, ben à Abiɛzanↄ sìsi kↄ̃n kuuo lɛ aↄ̃ mↄ́ wà tɛ́azi. ");
INSERT INTO bus_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","À gbɛ̃nↄ zĩ̀ Manasenↄ bùsu gu píngia wà ń sísi se aↄ̃ mↄ́ wà tɛ́azi. Ben à gbɛ̃nↄ zĩ̀ Asanↄ bùsun kↄ̃n Zɛbuluninↄ bùsuo kↄ̃n Nafatalinↄ bùsuo. Ben aↄ̃ mↄ̀ wà nàḿma. ");
INSERT INTO bus_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","Gidiↄn bè Ludanɛ: Tó nɛ́ Isarailinↄ bↄ ma gãzĩ lán n à lɛ́ gbɛ̃̀mɛ nà, ");
INSERT INTO bus_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","ǹ gwa, mɛ́ɛ sãkã kaɛɛ blɛwɛɛgbɛ̃kiia. Tó kpíi kpà sãkã pìa ado, bensↄ̃ tↄↄtɛ gↄ̃̀ kori, mɛ́ dↄ̃ sa kɛ̀ nɛ́ Isarailinↄ bↄ ma gãzĩ lán ń ò nà. ");
INSERT INTO bus_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","Ben à kɛ̀ lɛ. Kɛ̀ guu dↄ̀, ben à fɛ̀ɛ idɛ'idɛ, à sãkã pì fɛ̃̀, à í taa pà. ");
INSERT INTO bus_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","Ben Gidiↄn bè Ludanɛ: Ǹton pↄ fɛ̃maoro. Má yezi mà yã gbekamma gɛ̃̀n do dↄ. Ǹ tó mà gwa sãkãa gɛ̃̀n do dↄ. Kɛ̀kii sa, ǹ tó kpíi kpá tↄↄtɛa ado, sãkã gↄ̃ kori. ");
INSERT INTO bus_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","Gwãavĩ beeea Ludaa kɛ̀ lɛ. Kpíi kpà tↄↄtɛa gu píngia, sãkã bé à gↄ̃̀ kori ado. ");
INSERT INTO bus_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","Gidiↄn kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ kúonↄ fɛ̀ɛ kↄngↄ idɛ'idɛ aↄ̃ gàa wà bùra kàɛ Arodi íbↄkiia. Midiãnↄ bùra kú guzurɛn gu'igbãroo kpa Mↄre sĩ̀sĩgɛɛzi. ");
INSERT INTO bus_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","Ben Dii bè Gidiↄnnɛ: Gbɛ̃ kɛ̀ aↄ̃ↄ kúnyonↄ kɛ̀ pari, mɛ́ Midiãnↄ nańnɛ ń ↄzĩro. Tó má ń náńnɛ ń ↄzĩ, aↄ̃é ĩa dã wà be ń zĩnda gbãaa bé à ń bↄ́. ");
INSERT INTO bus_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","Ǹ kpàakpa kɛ gĩa ǹ beńnɛ, gbɛ̃ kɛ̀ swɛ̃̀ kɛ̃̀n, ben èe lugalugaa, adee ɛara. Ben gↄ̃ↄn bↄrↄ baro awɛɛplaaa ɛ̀ara, gↄ̃ↄn bↄrↄ kuri bé à gↄ̃̀. ");
INSERT INTO bus_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","Ben Dii bè Gidiↄnnɛ: Aↄ̃ↄ kpɛ́ pari ai tia. Ǹ gáńyo í kiia, mɛ́ ń plɛplɛnnɛ gwe. Gbɛ̃ kɛ̀ má ònnɛ aↄ̃é gányonↄ bé weé gá, gbɛ̃ kɛ̀ má ònnɛ aↄ̃é gányoroonↄ sↄ̃ bé weé gↄ̃. ");
INSERT INTO bus_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","Kɛ̀ à gàańyo í kiia, Dii bènɛ: Ǹ gbɛ̃ kɛ̀ ń è aↄ̃ lɛ́ pɛ̀ ía lán gbɛ̃ɛ bànↄ plɛkↄ̃tɛ kↄ̃n gbɛ̃ kɛ̀ aↄ̃ kùɛ ń kosooa wà í dã̀ ↄↄo wèe miinↄ. ");
INSERT INTO bus_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","Gbɛ̃ kɛ̀ aↄ̃ lɛ́ pɛ̀ íanↄ gↄ̃ↄn wàa do kpɛ́ basↄↄromɛ. Gbɛ̃ kpaaanↄ sↄ̃ kùɛ ń kosooa aↄ̃ í mì. ");
INSERT INTO bus_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","Ben Dii bè Gidiↄnnɛ: Mɛ́ Midiãnↄ naare a ↄzĩ kↄ̃n gↄ̃ↄn wàa do kpɛ́ basↄↄroo kɛ̀ aↄ̃ lɛ́ pɛ̀ íanↄo sa mà a bↄ. Ǹ gbɛ̃ kpaaanↄ gbarɛ, aↄ̃ baade tá a bɛ. ");
INSERT INTO bus_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","Ben Gidiↄn gↄ̃ↄn wàa do kpɛ́ basↄↄroo pìnↄ sɛ̀, aↄ̃ gbɛ̃ kɛ̀ aↄ̃ↄe taa bɛɛnↄ kũsãɛnↄ kↄ̃n ń kuunↄ sìḿma, ben à ń gbáɛ. Gidiↄn kú sĩ̀sĩ musu, Midiãnↄ bùra kú guzurɛn à gĩzĩ. ");
INSERT INTO bus_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","Gwãavĩ beeea Dii yã ònɛ à bè: Ǹ fɛɛ ǹ gáńzi ń bùran, zaakɛ ma ń nánnɛ n ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","Tó vĩa e n kũu ǹ gáńzimɛ, ǹ pita ǹ gá lɛdo kↄ̃n n zĩkɛri Purao ");
INSERT INTO bus_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","ǹ swã kpá yã kɛ̀ aↄ̃ↄe oozi. Yã pì é n gba swɛ̃̀ lɛ ǹ gáńzi ń bùran. Ben à pìta kↄ̃n a zĩkɛri Purao aↄ̃ sↄ̃̀ ń bùra lɛ́zi. ");
INSERT INTO bus_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","Midiãnↄ kↄ̃n Amalɛkinↄ kↄ̃n ↄfãntɛ̃bↄɛ kpa gbɛ̃ pãndenↄ kaɛna guzurɛn ń píngi, aↄ̃ kpá lán sutɛ̃nↄ bà. Wèe fↄ̃ wà ń lakuminↄ nàroro, aↄ̃ↄ pari lán ísialɛ bùsu'ãatɛ̃ bà. ");
INSERT INTO bus_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","Kɛ̀ Gidiↄn kà gwe, à gbɛ̃ke lè, èe a nanaa tↄ̃kɛ̃ɛ a gbɛ̃ndoonɛ à bè: Ǹ nanaa kɛ̀ má ò ma. Má è burɛdi kↄ̃̀ↄ kporogoo e gbegere paa, ben à lɛ̀ɛ wa bùran à sì bisakutaaa, ben kutaa pì lɛ̀ɛ kpɛɛgãnda à gↄ̃̀ kaɛna. ");
INSERT INTO bus_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","Ben à gbɛ̃ndoo pì bènɛ: Yoasi nɛ́ Gidiↄn, Isaraili bori fɛ̃ɛdaan ń è gwe, èe kɛ pↄ́ pãndenlo. Luda Midiãnↄ kↄ̃n wa bùrao nànɛ à ↄzĩ píngi. ");
INSERT INTO bus_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","Kɛ̀ Gidiↄn nanaa pì yã mà kↄ̃n à bↄkↄ̃tɛnao, à dↄnzi kɛ̀ Diinɛ. Ben à ɛ̀ara Isarailinↄ bùran à bè: À fɛɛ! Dii Midiãnↄ nàwe wa ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","À gↄ̃ↄn wàa do kpɛ́ basↄↄroo pìnↄ kpàatɛ gãli aagↄ̃, ben à kuu kↄ̃n lo korio kpà ń baadea. Ben wà sɛ̃̀ tɛ́ sↄ̀tↄsↄtↄ loo pìnↄ guu. ");
INSERT INTO bus_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","À bèńnɛ: Mɛ́ɛ gaa ai ń bùra lɛ́a. Àgↄ̃ ma gwaa. Lán á è má kɛ̀ nà, à kɛ lɛ se. ");
INSERT INTO bus_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","À liga ń bùrazi píngi. Tó mapi kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ kúmaonↄ wa kuu pɛ̀, à a pↄ́ pɛ́ se à wii lɛ́ à be: Dii pↄ́mɛ kↄ̃n Gidiↄn-o. ");
INSERT INTO bus_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","Gidiↄn kↄ̃n gↄ̃ↄn basↄↄroo kɛ̀ aↄ̃ↄ kúonↄ kà bùra lɛ́a lezãndo gudãkparinↄ kↄ̃ lendekɛna gbɛra gↄ̃ↄ. Ben aↄ̃ ń kuu pɛ̀ ń píngi, aↄ̃ loo kɛ̀ aↄ̃ kũnanↄ wìwi. ");
INSERT INTO bus_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","Ben gãli aagↄ̃ↄ pìnↄ baade a kuu pɛ̀ aↄ̃ ń loonↄ wìwi. Aↄ̃ↄ sɛ̃̀ tɛ́nↄ kũna ↄzɛɛo, aↄ̃ kuu kɛ̀ aↄ̃ↄe pɛɛnↄ kũna ↄplaan. Ben aↄ̃ wii lɛ̀ wà bè: Dii kↄ̃n Gidiↄn-o fɛ̃ɛdaamɛ. ");
INSERT INTO bus_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","Baade zɛ a gbɛ̀n ligana bùrazi, ben bùradeenↄ fɛ̀ɛ wà lɛ̀ kↄ̃a kↄ̃n wiiio aↄ̃ bàa lɛ̀. ");
INSERT INTO bus_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","Kɛ̀ wà kuu mɛ̀n wàa do kpɛ́ basↄↄroonↄ pɛ̀ lɛ, Dii tò bùra pì deenↄ kↄ̃ dɛ̀dɛ kↄ̃ tɛ̃ɛ kↄ̃n fɛ̃ɛdaao. Zĩ̀kari pìnↄ bàa lɛ̀ wà tà Bɛtɛsita kↄ̃n Zererao ai Abɛli Mɛↄla lɛ́a Taba kpa. ");
INSERT INTO bus_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","Wà Nafatalinↄ kↄ̃n Asanↄ sìsi kↄ̃n Manasenↄ ń píngi, ben aↄ̃ pɛ̀ɛ Midiãnↄzi. ");
INSERT INTO bus_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","Ben Gidiↄn gbɛ̃nↄ zĩ̀ aↄ̃ gàa Ɛflaimunↄ gukpiideen píngi, aↄ̃ bèńnɛ: À pita à gá Midiãnↄzi. À zɛ́ zↄ̃ńnɛ Yoda bikũkiinↄa ai Bɛtɛbara. Ben wà Ɛflaimunↄ sìsi ń píngi aↄ̃ gàa wà zɛ́ zↄ̃̀ńnɛ Yoda bikũkiinↄa ai Bɛtɛbara. ");
INSERT INTO bus_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","Ben Ɛflaimunↄ Midiã kínanↄ kũ̀ gↄ̃ↄn plaa, Orɛbu kↄ̃n Zebuo. Aↄ̃ Orɛbu dɛ̀ gbɛ̀ saɛ, kɛ̀ wè be tia Orɛbu gbɛ̀. Aↄ̃ Zebu dɛ̀ dↄ, guu pìn wè be tia Zebu geepi'ifɛ̃kii. Ben aↄ̃ ɛ̀ara wà pɛ̀ Midiãnↄa. Ben wà kína pìnↄ mì zↄ̃̀zↄ̃ wà gàao Gidiↄnnɛ Yoda baa kãa kpa. ");
INSERT INTO bus_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","Ɛflaimunↄ Gidiↄn là wà bè: Bↄ́yãnzin ń kɛ̀we lɛzi? Kɛ̀ nɛ́ɛ gaa zĩ̀ ká kↄ̃n Midiãnↄ, ben nɛ́ɛ wa sísiroo? Ben aↄ̃ wisↄ̃̀zi lɛ pãsĩpãsĩ, ");
INSERT INTO bus_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","ben à bèńnɛ: Bↄ́n má kɛ̀ kɛ̀ kà a pↄ́ ũu? A Ɛflaimunↄ geepi kↄ̃ↄwɛna maa dɛ wamↄwa Abiɛzanↄ geepikɛkɛnala. ");
INSERT INTO bus_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","Luda Midiã kínanↄ Orɛbu kↄ̃n Zebuo nàare a ↄzĩ. Bↄ́n ma fↄ̃ má kɛ̀ kɛ̀ kà a pↄ́ ũu? Kɛ̀ à òńnɛ lɛ, ben aↄ̃ pↄfɛ̃ gbasa à kpàɛ sa. ");
INSERT INTO bus_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","Gidiↄn kↄ̃n a gbɛ̃ gↄ̃ↄn wàa do kpɛ́ basↄↄroonↄↄ kpɛ́ wèe pɛɛɛ Midiãnↄzi, baa kɛ̀ aↄ̃ gbãaa bùsa. Kɛ̀ aↄ̃ kà Yodazi, ben aↄ̃ bikũ̀. ");
INSERT INTO bus_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","Ben à bè Sukodeenↄnɛ: À ma gbɛ̃nↄ gba pↄ́blee. Aↄ̃ gbãaa bùsa bensↄ̃ má kpɛ́ mɛ́ɛ pɛɛɛ Midiã kínanↄ Zɛba kↄ̃n Zalamunaozi. ");
INSERT INTO bus_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","Ben Suko gbɛ̃nsinↄ bè: Zɛba kↄ̃n Zalamunao gɛ̃̀ n ↄzĩ kↄ̀n yↄ́? À kɛ̀ dia wé n zĩ̀karinↄ gba pↄ́bleee? ");
INSERT INTO bus_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","Gidiↄn wèńla à bè: Zaakɛ á ò lɛ, tó Dii Zɛba kↄ̃n Zalamunao nàmɛ ma ↄzĩ, mɛ́ a kɛ gyáigyai kↄ̃n gbáa lɛ̀o. ");
INSERT INTO bus_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","Zaa gwe à gàa Pɛniɛli, ben à wɛ́ɛ kɛ̀ḿma lɛ dↄ. Pɛniɛlideenↄ wèàla lán Sukodeenↄ wèàla nàmɛ dↄ, ");
INSERT INTO bus_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","ben à bèńnɛ se: Tó ma gaa ma su aafia, mɛ́ gudãkpaki lezĩ kɛ̀ gboro. ");
INSERT INTO bus_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","Zɛba kↄ̃n Zalamunao kú Kako kↄ̃n ń zĩ̀karinↄ gↄ̃ↄn bↄrↄ gɛ̃ro. Ɔfãntɛ̃bↄɛ kpa zĩ̀kpɛɛ kɛ̀ aↄ̃ gↄ̃̀nↄn gwe. Aↄ̃ fɛ̃ɛdadeenↄ gàga gↄ̃ↄn bↄrↄ baswɛɛdo. ");
INSERT INTO bus_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","Gidiↄn laatarinↄ zɛ́ sɛ̀ Nↄba kↄ̃n Yↄgbɛao ↄfãntɛ̃bↄɛ kpa, ben à sì zĩ̀kari pìnↄ tɛ́ gurↄↄ kɛ̀ aↄ̃ sã̀ ń zĩnda yãn. ");
INSERT INTO bus_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","Midiã kína pìnↄ Zɛba kↄ̃n Zalamunao bàa lɛ̀, ben à pɛ̀ɛńzi à ń kũkũ, ben à tò ń zĩ̀karinↄ lɛ̀kↄ̃a ń píngi. ");
INSERT INTO bus_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","Kɛ̀ Yoasi nɛ́ Gidiↄn bↄ̀ zĩ̀lan èe suu, à bↄ̀ɛ Ɛrɛsi Gbɛ̀kotozɛn, ");
INSERT INTO bus_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","ben à Suko gↄ̃kparɛ ke kũ̀ à à làla yãzi, ben gↄ̃kparɛ pì Suko gbɛ̃nsinↄ tↄ́ kɛ̃̀nɛ takadan gↄ̃ↄn baaagↄ̃ akuri awɛɛswɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","Ben Gidiↄn gàa à Sukodeenↄ lè à bè: Zɛba kↄ̃n Zalamunaon yɛ̀. A ma lalandi kɛ̀ yã a bè, Zɛba kↄ̃n Zalamunao e gɛ̃ ma ↄzĩ kↄ̀ro. É fↄ̃ à ma gbɛ̃ kɛ̀ ń gbãaa bùsanↄ gba pↄ́bleero. ");
INSERT INTO bus_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","Ben à wɛ́tɛ pì gbɛ̃nsi pìnↄ kũ̀kũ à ń kɛ́ gyáigyai kↄ̃n gbáa lɛ̀o, aↄ̃ dↄ̃̀ ń mɛ̀a. ");
INSERT INTO bus_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","Ben à gàa à Pɛniɛli gudãkpaki lezĩ gbòro à wɛ́tɛ gↄ̃gbɛ̃nↄ dɛ̀dɛ. ");
INSERT INTO bus_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","Ben à Zɛba kↄ̃n Zalamunao là à bè: Gbɛ̃ kɛ̀ a ń dɛ́dɛ Tabonↄↄ dɛ diamɛ? Aↄ̃ wèàla wà bè: Aↄ̃ↄ dɛ lán n bàmɛ, aↄ̃ kakana dɛ lán kínɛnↄ bà. ");
INSERT INTO bus_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","Ben Gidiↄn bèńnɛ: Ma vĩ̀i dadↄ̃nkↄ̃deenↄn gwe. Tó a ń tó yã, kↄ̃n Diio mɛ́ a dɛdɛro. ");
INSERT INTO bus_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","Ben à bè a daudu Yɛtanɛ: Ǹ fɛɛ ǹ ń dɛdɛ. Nɛ́ pì e a fɛ̃ɛdaa wotoro, vĩa à kũ̀, zaakɛ nɛ́ fétemɛ. ");
INSERT INTO bus_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","Ben Zɛba kↄ̃n Zalamunao bè: Ǹ fɛɛ ǹ wa dɛdɛ n zĩnda. Baade kↄ̃n a gbãaaomɛ. Ben Gidiↄn fɛ̀ɛ à ń dɛ́dɛ à mↄ̀ kã̀mbɛɛ kɛ̀ da ń lakuminↄ waalɛ bↄ̀ɛ. ");
INSERT INTO bus_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","Isarailinↄ bè Gidiↄnnɛ: Ǹ gↄ̃ wa mìdee ũ kↄ̃n n boriinↄ. Zaakɛ ḿbe n wa bↄ Midiãnↄ ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","Ben Gidiↄn bèńnɛ: Mɛ́ gↄ̃ a mìdee ũro, baa ma nɛ́. Diin a kí ũ. ");
INSERT INTO bus_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","Ben à ɛ̀ara à bèńnɛ: Mɛ́ɛ wɛ́ɛ kɛɛawa: A baade swãi kɛ̀ à sìḿma kpáma mɛ̀n doodo. Midiãnↄ ègↄ̃ vura swãi dana, zaakɛ Sumaila boriinↄmɛ. ");
INSERT INTO bus_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","Aↄ̃ bènɛ: Wé kpámma kↄ̃n nↄ̀sɛo do. Aↄ̃ bisa kpàɛ, ben baade swãi kɛ̀ à sìḿmanↄ dàn mɛ̀n doodo. ");
INSERT INTO bus_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","Vura swãi kɛ̀ à gbèkaḿma pìnↄ tìisi kà kilo baro, mↄ̀kãmbɛɛnↄ kↄ̃n swãinↄ kↄ̃n gumusu tɛ̃aa kɛ̀ Midiã kínanↄↄ dananↄ kↄ̃n mↄ̀kãmbɛɛ kɛ̀ da ń lakuminↄ waalɛnↄ baasi. ");
INSERT INTO bus_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","Ben à pì màsokɛbↄ ũ à pɛ̀ɛ a bɛ wɛ́tɛn zaa Ɔfla. Ben Isarailinↄ pãpãa kɛ̀ wà dↄ̀zi ń píngi, ben à gↄ̃̀ takutɛɛ ũ Gidiↄnnɛ kↄ̃n à bɛdeenↄ. ");
INSERT INTO bus_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","Lɛn Isarailinↄ Midiãnↄ gbãaa bùsa lɛ. Midiãnↄↄ e e wà mì bↄ̀ dↄro. Ben Isarailinↄ bùsu gↄ̃̀ kaɛna aafia Gidiↄn gurↄ ai wɛ̃̀ baplaa. ");
INSERT INTO bus_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","Yoasi nɛ́ Gidiↄn gàa à vɛ̃̀ɛ a bɛ. ");
INSERT INTO bus_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","À nɛ́gↄ̃gbɛ̃ kɛ̀ à ń ínↄ gↄ̃ↄn baaagↄ̃ akurimɛ, zaakɛ à nↄↄnↄↄ pari. ");
INSERT INTO bus_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","À nↄpↄsɛɛ vĩ dↄ zaa Sɛkɛmu kɛ̀ à nɛ́gↄ̃gbɛ̃ ìo, ben wà tↄ́ kpànɛ Abimɛlɛki. ");
INSERT INTO bus_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","Yoasi nɛ́ Gidiↄn gà a zikũmmɛ, ben wà à mira kpàkↄ̃zi kↄ̃n a de pↄ́o zaa Ɔfla Abiɛza. ");
INSERT INTO bus_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","Kɛ̀ Gidiↄn gà gↄ̃ↄ, ben Isarailinↄ ɛ̀ara wà pãpãa kɛ̀ wà dↄ̀ Baalizi. Ben aↄ̃ tãa kɛ̀ wè be Baalibaakuwao pɛ̀ɛ ń dii ũ, ");
INSERT INTO bus_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","ben Dii ń Luda kɛ̀ à ń bↄ́ ń ibɛɛ kɛ̀ aↄ̃ↄ ligańzi kpa píngianↄ ↄzĩ yã sã̀ńgu. ");
INSERT INTO bus_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","Aↄ̃ↄe gbɛ̃kɛɛ kɛ Gidiↄn kɛ̀ wè benɛ dↄ Yerubaali bɛdeenↄnɛ yã maaa kɛ̀ à kɛ̀ńnɛ píngi musuro. ");
INSERT INTO bus_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","Isarailinↄ ɛ̀ara wà yã kɛ̀ Dii gìzi kɛ̀ dↄ, ben Dii ń ná Filisitininↄnɛ ń ↄzĩ ai wɛ̃̀ baplaa. ");
INSERT INTO bus_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","Gↄ̃gbɛ̃ kee kú Zↄra, Dani boriimɛ, à tↄ́n Manↄa. À naↄ̃ nɛ́ pãaamɛ, èe nɛ́ iro. ");
INSERT INTO bus_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","Dii Malaika bↄ̀ à mↄ̀ nↄgbɛ̃ pìzi à bè: Ǹ ma! Pãaan n ũ, nɛ́ɛ nɛ́ iro, mↄde nɛ́ nↄ̀ sí ǹ nɛ́ i gↄ̃gbɛ̃ ũ. ");
INSERT INTO bus_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","Ǹ làakari kɛ! Ǹton geepiwɛ̃ɛ ke í gbãa ke miro. Ǹton tɛ̃̀ ke blero. ");
INSERT INTO bus_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","Nɛ́ nↄ̀ sí ǹ nɛ́ i gↄ̃gbɛ̃ ũ. Gɛ̃ɛ tón na nɛ́ pì mìaro, zaakɛ eégↄ̃ dɛ Luda pↄ́ ũmɛ zaa a igurↄ. Àmbe eé na Isarailinↄ bↄnaa Filisitininↄ ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","Ben nↄgbɛ̃ pì gàa à ò a zãnɛ à bè: Luda gbɛ̃ke mↄ̀ ma kiia. Tó n à è, à dɛ lán Luda Malaika bà à naasi vĩ maamaa. Mɛ́ɛ à la tó mán à bↄ̀nlo, bensↄ̃ èe a tↄ́ omɛro. ");
INSERT INTO bus_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","À bèmɛ mɛ́ nↄ̀ sí mà nɛ́ i gↄ̃gbɛ̃ ũ. À bèmɛ màton wɛ̃ɛ ke í gbãa ke miro, bensↄ̃ màton tɛ̃̀ ke blero, zaakɛ nɛ́ pì égↄ̃ dɛ Luda pↄ́ ũmɛ zaa a igurↄ ai à wɛ̃̀ndi lɛ́n. ");
INSERT INTO bus_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","Ben Manↄa wɛ́ɛ kɛ̀ Diia à bè: N yã nna Dii! Ǹ tó gbɛ̃ kɛ̀ ń zĩ̀ ɛara à mↄ́ dↄ à yã kɛ̀ wé kɛ kↄ̃n nɛ́ pìo à ina gbɛraa dawe. ");
INSERT INTO bus_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","Luda Manↄa yã mà, ben Luda Malaika pì ɛ̀ara à mↄ̀ nↄgbɛ̃ pìzi gurↄↄ kɛ̀ à kú bura. À zã Manↄa kúo gwero, ");
INSERT INTO bus_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","ben à kɛ̀ kpaa à bàa lɛ̀ à gàa à ònɛ à bè: Gↄ̃gbɛ̃ kɛ̀ bↄ̀ à mↄ̀ mazi zĩ mↄ̀a kɛ̀ dↄee! ");
INSERT INTO bus_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","Manↄa fɛ̀ɛ à tɛ̀ a naↄ̃zi. Kɛ̀ à kà gↄ̃gbɛ̃ pì kiia, à à là à bè: Ḿbe n yã ò ma naↄ̃oↄ́? À wèàla à bè: Mámbee! ");
INSERT INTO bus_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","Ben Manↄa à là à bè: Tó n yã pì gàa à kɛ̀ lɛ, nɛ́ pì kuuna égↄ̃ dɛ diamɛ? Bↄ́ zĩin eégↄ̃ kɛɛ? ");
INSERT INTO bus_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","Dii Malaika wèàla à bè: N naↄ̃ gↄ̃ yã kɛ̀ má ònɛ kũna píngi. ");
INSERT INTO bus_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","Àton geepi lí pↄ́ke blero. Àton wɛ̃ɛ ke í gbãa ke miro. Àton tɛ̃̀ ke blero. Àgↄ̃ yã kɛ̀ má dìɛnɛ kũna píngi. ");
INSERT INTO bus_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","15","Ben Manↄa bènɛ: N yã nna, ǹ zɛ gĩa ai wà blènɛ bↄ̀rↄ kɛkɛnnɛ. ");
INSERT INTO bus_vpl VALUES ("JG13_16","008_13_16","JDG","13","16","16","Dii Malaika wèàla à bè: Baa tó ma gↄ̃ kɛ̀, mɛ́ n pↄ́ke blero. Tó n sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ soru kɛ̀, ǹ o Diia. Manↄa e dↄ̃ kɛ̀ Dii Malaikanlo, ");
INSERT INTO bus_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","ben à à là à bè: N tↄ́n diaa? Tó yã kɛ̀ ń ò pì kɛ̀, wé sáabu kɛnnɛ. ");
INSERT INTO bus_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","Dii Malaika wèàla à bè: Bↄ́yãnzin nɛ́ɛ ma tↄ́ gbekaazi? Tↄ́ bↄnsaɛmɛ. ");
INSERT INTO bus_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","Ben Manↄa blènɛ bↄ̀rↄ kũ̀ à flawa sɛ̀ à Dii gbã̀gbão gbɛ̀ ke musu. Kɛ̀ Manↄa kↄ̃n a naↄ̃o wɛ́ɛ kà wèe gwaa, ben Dii yãbↄnsaɛ kɛ̀ ");
INSERT INTO bus_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","à tò tɛ́ bↄ̀ sa'okii pìn à fɛ̀ɛ musu, ben Dii Malaika fɛ̀ɛ tɛ́nɛnɛ pì guu à tà musu. Kɛ̀ Manↄa kↄ̃n a naↄ̃o è lɛ, ben aↄ̃ dàɛ ń puua. ");
INSERT INTO bus_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","Dii Malaika e gà à mↄ̀ Manↄa kↄ̃n a naↄ̃ozi dↄro, ben Manↄa dↄ̃̀ sa kɛ̀ Dii Malaikamɛ. ");
INSERT INTO bus_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","Manↄa bè a naↄ̃nɛ: Wa gan gweee! Zaakɛ wa wɛ́ɛ sì Ludalɛ. ");
INSERT INTO bus_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","Ben à naↄ̃ bènɛ: Tó Dii yezi à wa dɛmɛ, lɛ èe saa kɛ̀ wá òa kↄ̃n flawao síro, lɛ èe yã kɛ̀nↄ owero bensↄ̃ èe yã pì ↄdↄawero. ");
INSERT INTO bus_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","Nↄgbɛ̃ pì nɛ́ ì gↄ̃gbɛ̃ ũ, ben à tↄ́ kpànɛ Samusĩ. Nɛ́ pì bíta kũ̀, bensↄ̃ Dii aubarika dàn. ");
INSERT INTO bus_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","Dii Nini nà zĩkɛnaa à guu gurↄↄ kɛ̀ à kú Daninↄ bùran, Zↄra dagura kↄ̃n Ɛsɛtaoluo. ");
INSERT INTO bus_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","Samusĩ gàa Timina, ben à Filisitini nɛ́nↄkparɛ ke è gwe. ");
INSERT INTO bus_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","Kɛ̀ à sù, ben à bè a de kↄ̃n a daonɛ: Ma Filisitini nɛ́nↄkparɛ ke è zaa Timina. À gá à à wɛtɛmɛ mà sɛ́ nↄↄ ũ. ");
INSERT INTO bus_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","Ben à de kↄ̃n à dao bènɛ: Nↄↄ kú n danɛnↄ ke n boriinↄ tɛ́nloo? Ben nɛ́ gá ǹ nↄↄ sɛ́ Filisitini gɛfↄↄdeenↄ tɛ́ↄ? Ben Samusĩ bè a denɛ: Ǹ gá ǹ à wɛtɛmɛ dé, zaakɛ nↄkparɛ pìn má yezi. ");
INSERT INTO bus_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","À de kↄ̃n à dao e dↄ̃ kɛ̀ yã pì bↄ̀ Dii kiianlo, zaakɛ Dii e zɛ́ wɛtɛɛ à yã mↄ Filisitininↄnɛmɛ. Gurↄ beeea Filisitininↄ bé wèe kí blee Isarailinↄa. ");
INSERT INTO bus_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","Ben Samusĩ e gaa Timina kↄ̃n a de kↄ̃n a dao. Kɛ̀ aↄ̃ kà Timina geepi bura, músunɛ bↄ̀rↄ bↄ̀ Samusĩzi èe pũtãa. ");
INSERT INTO bus_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","Dii Nini sùa, ben à músu pì kũ̀ à kɛ̃̀kↄ̃rɛ lán wà be blènɛ bↄ̀rↄ à kɛ̃̀kↄ̃rɛ bà. À pↄ́ke kũna à ↄzĩ sↄ̃ro. Èe yã kɛ̀ à kɛ̀ pì o a de ke a danɛro. ");
INSERT INTO bus_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","Ben à gàa à yã ò kↄ̃n nↄkparɛ pìo, nↄkparɛ pì sↄ̃ kɛ̀nɛ maa. ");
INSERT INTO bus_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","Kɛ̀ à gurↄplaa kɛ̀, à fɛ̀ɛ èe gaa nↄↄ pì sɛ́ sa, ben à lìɛ à gàa músu gɛ̀ pì gwa. Ben à è zↄ́nↄ sà dↄ̀ à gɛ̀a ai aↄ̃ í kɛ̀. ");
INSERT INTO bus_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","Ben à ↄ dàn à à sà gà à wòto èe blee, ben èe taao. Kɛ̀ à kà a de kↄ̃n a dao kiia, à lìńnɛ aↄ̃ↄ blè, mↄde èe ońnɛ kɛ̀ a bò músu gɛ̀ guunlo. ");
INSERT INTO bus_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","À de gàa nↄkparɛ pì kiia, ben Samusĩ pↄnna pↄ́blee kɛ̀ńnɛ lán nↄsɛri è kɛ nà. ");
INSERT INTO bus_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","Kɛ̀ à mↄ̀, wà gↄ̃kparɛnↄ sìsi gↄ̃ↄn baaakuri wàgↄ̃ kúo. ");
INSERT INTO bus_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","Ben Samusĩ bèńnɛ: Má gara gbooto ke vĩ mà daare. Ai pↄ́blena gurↄ swɛɛplaaa kɛ̀ gá papao, tó a fↄ̃ à gara pì bòmɛ, mɛ́ bisa kpáawa pii baaakuri kↄ̃n utao waa baaakuri. ");
INSERT INTO bus_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","Tó ée fↄ̃ à bòmɛ sↄ̃ro, ámbe é bisa pii baaakuri kↄ̃n uta waa baaakurio kpáma. Ben aↄ̃ bènɛ: Ǹ ǹ gara pì dawe wà ma. ");
INSERT INTO bus_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","À bèńnɛ: Pↄ́blee bↄ̀ pↄ́sori guu, pↄ́ nnaa bↄ̀ pↄ́ gbãaa guu. Ben aↄ̃ↄe fↄ̃ wà gara pì bòro ai gurↄ aagↄ̃. ");
INSERT INTO bus_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","À gurↄ siigↄ̃dee zĩn aↄ̃ bè Samusĩ naↄ̃nɛ: Ǹ ↄ̃ndↄ̃ↄ kɛ n zãzi à gara pì bowe. Tó lɛnlo, wé n kpata kↄ̃n n de bɛdeenↄ. Ase a wa sisi lɛ à wa pↄ́nↄ síwamɛ? ");
INSERT INTO bus_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","Ben Samusĩ naↄ̃ e ↄ́ↄ dↄↄnɛ à bè: N zamagu! Ń yemaziro! N gara ke dà ma gbɛ̃nↄnɛ, bensↄ̃ nɛ́ɛ bomɛro. Ben à bènɛ: Mɛ́ɛ bo ma de ke ma danɛro. Bↄ́ bé à tò mɛ́ onnɛɛ? ");
INSERT INTO bus_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","Èe ↄ́ↄ dↄↄnɛ ai gurↄ swɛɛplaaa pì gàa à pàpao. À gurↄ swɛɛplaadee pì zĩ ben Samusĩ gara pì bònɛ kɛ̀ à nàkↄ̃rɛa yãnzi, ben nↄↄ pì gàa à ò a gbɛ̃nↄnɛ. ");
INSERT INTO bus_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","À gurↄ swɛɛplaadee zĩ ai ↄfãntɛ̃ gↄ̃ gá gɛ̃ kpɛ́n wɛ́tɛ pì gↄ̃kparɛnↄ bènɛ: Bↄ́ nnaa bé à dɛ zↄ́laa? Bↄ́ gbãaa bé à dɛ músulaa? Ben Samusĩ bèńnɛ: Tó èe kɛ a bú wì kↄ̃n ma zùnunuoro, lɛ ée fↄ̃ a ma gara pì bòro. ");
INSERT INTO bus_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","Dii Nini sùa, ben à gàa Asakɛlↄni à gↄ̃gbɛ̃nↄ dɛ̀dɛ gↄ̃ↄn baaakuri à ń pↄ́kãsãanↄ pìtiḿma, ben à gàa à kpà gbɛ̃ kɛ̀ aↄ̃ à gara pì bònɛnↄa. Ben à pↄ fɛ̃̀ à tà a de bɛ. ");
INSERT INTO bus_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","Ben wà Samusĩ nↄↄ pì kũ̀ wà kpà à gbɛ̃nna kɛ̀ zɛ̀ à saɛ nↄↄ pì sɛ́gurↄↄ zĩa. ");
INSERT INTO bus_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","Kɛ̀ à kɛ̀ gurↄ plaa, burapↄnↄkɛkɛgurↄↄ kà, ben Samusĩ blènɛ bↄ̀rↄ kũ̀ à gàa a nↄↄ pì gwao. À bè: Má yezi mà gá ma naↄ̃zi kpɛ́ guu. Ben à nↄↄ pì de e à gba zɛ́ro ");
INSERT INTO bus_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","à bè: Mɛ́ɛ daa n yezinlo, ben ma à kpà n gbɛ̃nnaa. À dãaro maa dɛàla. Ǹ à sɛ́ à gɛ̃ɛ ũ. ");
INSERT INTO bus_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","Samusĩ bèńnɛ: Tó ma yã zaaa kɛ̀ a Filisitininↄnɛ sa, mɛ́gↄ̃ taari vĩ dↄro. ");
INSERT INTO bus_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","Samusĩ gàa à gbɛ̃ngboonↄ kũ̀kũ wàa do kpɛ́ basↄↄro, ben à sɛ̃̀ yìyi sↄ̀ↄↄsↄↄↄ. À gbɛ̃ngboo pìnↄ vlãa yìyi kↄ̃a plaplaa, ben à sɛ̃̀ pì yìyi ń vlãa pìnↄa. ");
INSERT INTO bus_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","À tɛ́ nà sɛ̃̀ pìnↄa, ben à gbɛ̃ngboo pìnↄ gbàrɛ Filisitininↄ bura. Aↄ̃ blɛwɛɛ tɛ́ kũ̀ píngi kↄ̃n ń blɛwɛɛ gbànↄ kↄ̃n ń geepi búnↄ kↄ̃n ń kùkpɛnↄ píngi. ");
INSERT INTO bus_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","Ben Filisitininↄ bè: Dé bé à yã kɛ̀ taka kɛ̀wee? Ben wà bè: Samusĩmɛ, Timina gbɛ̃ anzure. À anzure pì à nↄↄ sìamɛ, ben à kpà à gbɛ̃nnaa. Ben Filisitininↄ gàa wà tɛ́ sↄ̃̀ nↄↄ pìa kↄ̃n a deo. ");
INSERT INTO bus_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","Samusĩ bèńnɛ: Zaakɛ á kɛ̀ lɛ, mɛ́ kámma boro ai ma gaa gɛ̃ɛ booawa. ");
INSERT INTO bus_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","À sì ń tɛ́ à ń kɛ́ dúgudugu, aↄ̃ dɛdɛna pì gɛ̃̀ ↄla, ben à gàa à vɛ̃̀ɛ Etamu gbɛ̀wɛɛn. ");
INSERT INTO bus_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","Filisitininↄ gàa wà bùra kàɛ Yudanↄ bùsun, aↄ̃gↄ̃ kpá guula ai Gɛɛwa saɛ. ");
INSERT INTO bus_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","Ben Yudanↄ ń lá wà bè: Bↄ́yãnzin a mↄwazi kↄ̃n zĩ̀ozi? Ben aↄ̃ bè: Wa mↄ wà Samusĩ kũmɛ, lɛ wà kɛnɛ lán à kɛ̀we nà. ");
INSERT INTO bus_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","Ben Yudanↄ gↄ̃ↄn bↄrↄ aagↄ̃ↄnↄ gàa Etamu gbɛ̀wɛɛ kiia aↄ̃ bè Samusĩnɛ: Ń dↄ̃ kɛ̀ Filisitininↄ bé wèe kí bleewaroo? Bↄ́ yãn ń kɛ̀we gwee? À wèńla à bè: Pↄ́ kɛ̀ aↄ̃ↄ kɛ̀mɛɛn má kɛ̀ńnɛ. ");
INSERT INTO bus_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","Ben aↄ̃ bè: Wa mↄ wà n yi wà n kpáḿmamɛ. Ben Samusĩ bè: À la damɛ kɛ̀ é ma dɛ a zĩndaro. ");
INSERT INTO bus_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","Ben aↄ̃ bènɛ: Auo! Wé n dɛro. Wé n yi kↄ̃n bàomɛ wà n nańnɛ ń ↄzĩ. Ben aↄ̃ à yì kↄ̃n bà dufuo mɛ̀n plaa aↄ̃ bↄ̀o gbɛ̀wɛɛ pì guu. ");
INSERT INTO bus_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","Kɛ̀ wà kào Gɛɛwa, ben Filisitininↄ mↄ̀ wà daàlɛ, aↄ̃ↄe wuu kaaa. Dii Nini sù Samusĩa, ben bà kɛ̀ wà à yìo a ↄↄnↄa gↄ̃̀ lán zĩndoo tɛ́kũna bà, ben bà pìnↄ zↄ̃̀zↄ̃kↄ̃rɛ à ↄↄa. ");
INSERT INTO bus_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","À zaaki gɛ̀ dufu gɛɛwa è, ben à nàɛ à sɛ̀ à gↄ̃ↄn wàa sↄↄroonↄ dɛ̀dɛo. ");
INSERT INTO bus_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","Samusĩ bè: Zaaki gɛɛwan ma gↄ̃ↄn wàa sↄↄroonↄ dɛ̀dɛo, zaaki gɛɛwan ma ń tↄ̃tↄ̃okↄ̃la. ");
INSERT INTO bus_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","Kɛ̀ à yã pì ò à yã̀a, ben à gɛɛwa pì zĩ̀nna. Ben wà tↄ́ kpà guu pìnɛ Gɛɛwa sĩ̀sĩ. ");
INSERT INTO bus_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","Ímii à kũ̀ gbãa, ben à wii pɛ̀ Diizi à bè: Ń tò mamↄma n zↄ̀bleri ma zĩ̀ blè maamaa, ben nɛ́ tó mà ga kↄ̃n ímiio mà lɛ́ɛ Filisitini gɛfↄↄdeenↄ ↄzĩↄ́? ");
INSERT INTO bus_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","Luda Gɛɛwa gu zòoto pàra, ben í bↄ̀n. Samusĩ mì, ben à wɛ̃̀ndi sù à gbãaa è. Beee yãnzin wè guu pì sísi Ɛnakore. À kú Gɛɛwa ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","Samusĩ yã gↄ̃̀gↄ̃ Isarailinↄnɛ ai wɛ̃̀ baro Filisitininↄ kíblemmanagurↄ. ");
INSERT INTO bus_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","Samusĩ gàa Gaza à kaarua ke è gwe, ben à gɛ̃̀ à daɛo. ");
INSERT INTO bus_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","Wà bè Gazadeenↄnɛ: Samusĩ kú kɛ̀. Ben aↄ̃ lìga guu pìzi, wèe à kpákpaa wɛ́tɛ gɛ̃kiia gwãavĩ. Aↄ̃ yĩ̀tɛ gwãavĩ pìa wà bè: Tó guu dↄ̀, wé à dɛmɛ. ");
INSERT INTO bus_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","Samusĩ dàɛ gwe ai lezãndo, ben à fɛ̀ɛ à gàa à wɛ́tɛ gɛ̃kii gbà kũ̀ kↄ̃n a lípɛɛ mɛ̀n plaaanↄ à wùrɛ kↄ̃n à gbãngao lɛdo. À dà a gã̀n à gàa à zĩ̀nna sĩ̀sĩ kɛ̀ aɛ dↄ Ɛblↄnua musu. ");
INSERT INTO bus_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","Beee gbɛra Samusĩ yè nↄgbɛ̃ kezi zaa Sↄrɛki guzurɛn, à tↄ́n Dɛlila. ");
INSERT INTO bus_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","Ben Filisitininↄ kínanↄ gàa wà nↄgbɛ̃ pì lè aↄ̃ bènɛ: Ǹ ↄ̃ndↄ̃ↄ daɛzi lɛ ǹ e ǹ à gbãa bíta pì asii dↄ̃ kↄ̃n dian wé kɛ nà wà gbãaa mↄ́nɛo. Tó wa à yì bào wa à gbãaa bùsa, wa baade é n gba kondogi ↄↄ mɛ̀n wàa sↄↄro kpɛ́ basↄↄro. ");
INSERT INTO bus_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","Ben Dɛlila bè Samusĩnɛ: Ǹ ń gbãa bíta asii omɛ kↄ̃n dian weé kɛ nà wà n yi bào wà n gbãaa busao. ");
INSERT INTO bus_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","À wèàla à bè: Tó wà ma yi kↄ̃n kyã yĩi mɛ̀n swɛɛplaaao, beee bé eé ma busa màgↄ̃ dɛ lán baade bà. ");
INSERT INTO bus_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","Filisitininↄ kínanↄ mↄ̀ Dɛlilanɛ kↄ̃n kyã yĩi kɛ̀ èe kori kũrooo mɛ̀n swɛɛplaaa, ben à à yìo. ");
INSERT INTO bus_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","À kũ̀rinↄↄ utɛna kpɛ́tu, ben Dɛlila bè Samusĩnɛ: Samusĩ! Filisitininↄↄɛ zɛnla fá! Ben à kyã pìnↄ kɛ̃̀kɛ̃ lán bà mùna bà, wèe à gbãaa asii dↄ̃ro. ");
INSERT INTO bus_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","Ben Dɛlila bènɛ: Nɛ́ɛ ma lalandi kɛɛ, nɛ́ɛ ɛgɛɛ toomɛmɛ. Ǹ omɛ sa dian weé n yi nà. ");
INSERT INTO bus_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","Ben à bènɛ: Tó wà ma yi kↄ̃n bà gègete dufu kɛ̀ wèe zĩi kɛo zikirooo, eé ma busa màgↄ̃ dɛ lán baade bà. ");
INSERT INTO bus_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","Ben Dɛlila bà pì sɛ̀ à à yìo. À kũ̀rinↄↄ utɛna kpɛ́tu, ben à bè: Samusĩ! Filisitininↄↄɛ zɛnlaee! Ben Samusĩ bà kɛ̀ dↄ a ↄↄa pì kɛ̃̀kɛ̃ lán sↄbuba bà. ");
INSERT INTO bus_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","Dɛlila bènɛ: Nɛ́ɛ ma lalandi kɛɛ ai tia. Nɛ́ɛ ɛgɛɛ toomɛ. Ǹ omɛ sa dian weé n yi nà? Ben à bènɛ: Tó n ma mìkã gbã̀a mɛ̀n swɛɛplaaanↄ kũ̀ ń dà àsan ń tã̀, ben n káro pɛ̀a, mɛ́ busa màgↄ̃ dɛ lán baade bà. Dɛlila tò ii à sɛ̀, ben à à mìkã gbã̀a mɛ̀n swɛɛplaaa pìnↄ kũ̀ à tã̀ lán bisatãna bà ");
INSERT INTO bus_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","à káro pɛ̀a. Ben à bè: Samusĩ! Filisitininↄↄɛ zɛnlaee! Ben à vù à àsa pì gà à wùrɛ kↄ̃n a mìkão. ");
INSERT INTO bus_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","Dɛlila ɛ̀ara à bènɛ dↄ: Nɛɛ̀gↄ̃ bee ń yemazi, bensↄ̃ nɛɛ̀ ma náanɛ kɛro nɛ́? N ma lalandi kɛ̀ à kà gɛ̃̀n aagↄ̃. Nɛ́ɛ n gbãa bíta asii omɛro. ");
INSERT INTO bus_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","Lɛn ègↄ̃ nakↄ̃rɛɛa lɛ kↄ̃n yã beee takao yãana sai. Èe a zĩnda busaanɛ ai à gàa à fù mɛnaa à yezi à ga. ");
INSERT INTO bus_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","Ben à yã kɛ̀ kú a swɛ̃̀n ònɛ píngi sa à bè: Gɛ̃ɛ e na ma mìa zikiro, zaakɛ wà ma kɛ Luda pↄ́ ũmɛ. Tó wà ma mì bò, ma gbãaa é bↄmagu, mɛ́ busa màgↄ̃ dɛ lán baade bà. ");
INSERT INTO bus_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","Kɛ̀ Dɛlila è à yã kɛ̀ kú à swɛ̃̀n òare píngi, ben à lɛ́kpãsã kɛ̀ Filisitininↄ kínanↄnɛ à bè: À ɛara à mↄ́ gɛ̃̀n do dↄ, zaakɛ à à píngi òmɛ sa. Ben aↄ̃ ɛ̀ara wà mↄ̀ à kiia, aↄ̃ↄ kondogi pì kũna. ");
INSERT INTO bus_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","Dɛlila tò ii Samusĩ sɛ̀ a gbála, ben à gↄ̃gbɛ̃ ke sìsi. À à mìkã gbã̀a mɛ̀n swɛɛplaaa pìnↄ bò, ben à nà busanaa à gbãaa pì bↄ̀n. ");
INSERT INTO bus_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","Dɛlila bè: Samusĩ! Filisitininↄↄɛ zɛnlaee! Ben à vù èe daa é kɛ lán yãa bà à a zĩnda bↄmɛ. À dↄ̃ kɛ̀ Dii a tonlo. ");
INSERT INTO bus_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","Ben Filisitininↄ à kũ̀, wà à wɛ́ɛnↄ bↄ̀bↄ, ben aↄ̃ gàao Gaza. Aↄ̃ mↄ̀gotɛ̃ gata kpànɛ, ben wà à dà èe wísi lↄↄ kpɛ́siaan. ");
INSERT INTO bus_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","À mìkã pì ɛ̀ara à nà kpaɛnaa dↄ à bona gbɛra. ");
INSERT INTO bus_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","Filisitininↄ kínanↄ kↄ̃ kàkↄ̃a lɛ wà ń tãa Dagↄni gbãgbã, ben aↄ̃ↄe pↄnnaa kɛɛ wèe bè: Wa tãa wa ibɛɛ Samusĩ nàwe wa ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","Kɛ̀ Filisitininↄ à è, aↄ̃ ń tãa sáabu kpà wà bè: Wa ibɛɛ wa bùsu dɛ̀, à wa gbɛ̃nↄ dɛ̀dɛ dúgudugu, ben wa tãa à nàwe wa ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","Lán aↄ̃ pↄↄ kɛ̀ nna nà aↄ̃ bè: À Samusĩ sísi à kↄ̃kↄ̃ owe. Ben wà à bↄ̀ kpɛ́siaan à yáadↄziyã kɛ̀ńnɛ. Kɛ̀ wà à zɛ̀ kpɛ́ wesagbanↄ dagura, ");
INSERT INTO bus_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","à bè gↄ̃kparɛ kɛ̀ à à ↄ kũnanɛ: Ǹ gámao wesagba kɛ̀ aↄ̃ kpɛ́ sɛnanↄ saɛ lɛ mà ↄ nanaa mà gbãaa ea. ");
INSERT INTO bus_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","Tãakpɛ pì pà, gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄↄ kú gwe kↄ̃n Filisitininↄ kínanↄ ń píngi. Gbɛ̃ kɛ̀ aↄ̃ↄ kú kpɛ́ pì musu kà gↄ̃ↄn bↄrↄ aagↄ̃, kɛ̀ aↄ̃ mↄ̀ Samusĩ kↄ̃kↄ̃ gwa. ");
INSERT INTO bus_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","Samusĩ wɛ́ɛ kɛ̀ Diia à bè: Dii Luda, ǹ tó ma yã dↄngu. Luda, ǹ ma gba gbãaa gɛ̃̀n do dↄ lɛ mà gɛ̃ɛ boo Filisitininↄa ma wɛ́ɛ mɛ̀n plaa yã musu. ");
INSERT INTO bus_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","À ↄ nàna wesagba mɛ̀n plaaa kɛ̀ aↄ̃ kpɛ́ pì kũna gura súusunↄa, à ↄplaa kú à dooa à ↄzɛɛ kú à dooa dↄ. ");
INSERT INTO bus_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","À bè: Ǹ tó mà ga kↄ̃n Filisitininↄo! À nàɛ, ben à ↄ yĩ̀pazi kↄ̃n gbãaao, ben kpɛ́ pì gbòro à sì Filisitininↄ kínanↄa kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ kú à guunↄ ń píngi. Gbɛ̃ kɛ̀ Samusĩ ń dɛ́dɛ a gagurↄↄnↄↄ pari dɛ gbɛ̃ kɛ̀ à ń dɛ́dɛ gurↄↄ kɛ̀ à kú wɛ̃̀ndiola. ");
INSERT INTO bus_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","À dãaronↄ kↄ̃n à de bɛdeenↄ mↄ̀ ń píngi aↄ̃ à gɛ̀ sɛ̀ wà tào, ben aↄ̃ à mira kpàkↄ̃zi kↄ̃n à de Manↄa pↄ́o, Zↄra kↄ̃n Ɛsɛtaoluo dagura. À yã gↄ̃̀gↄ̃ Isarailinↄnɛ ai wɛ̃̀ baro. ");
INSERT INTO bus_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Gurↄↄ kɛ̀ yãgↄ̃gↄ̃rinↄↄ e kí blee Isarailinↄ bùsun, dekaa kà, ben gↄ̃gbɛ̃ ke bↄ̀ Bɛtɛlɛmu, Yudanↄ bùsun, à gàa gurↄplaa kɛ Mↄabunↄ bùsun kↄ̃n a naↄ̃o kↄ̃n a nɛ́gↄ̃gbɛ̃ gↄ̃ↄn plaaanↄ. ");
INSERT INTO bus_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Gↄ̃gbɛ̃ pì tↄ́n Ɛlimɛlɛki. À naↄ̃ tↄ́n Naomi. À nɛ́nↄ tↄ́n Malonu kↄ̃n Kiliↄ̃o. Ɛflata bùsu gbɛ̃nↄmɛ. Aↄ̃ gàa Mↄabunↄ bùsun, ben aↄ̃ↄ kú gwe. ");
INSERT INTO bus_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Gwen Naomi zã Ɛlimɛlɛki gàn, ben à gↄ̃̀ gwe kↄ̃n a nɛ́ gↄ̃ↄn plaaa pìnↄ. ");
INSERT INTO bus_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Aↄ̃ Mↄabu nↄgbɛ̃nↄ sɛ̀ nↄↄnↄ ũ, à doo tↄ́n Opa, à doo sↄ̃ Rutu. Aↄ̃ↄ kú gwe lán wɛ̃̀ kuri taka bà, à gbɛran ");
INSERT INTO bus_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Malonu kↄ̃n Kiliↄ̃o gà ń plaa ń píngi, ben Naomi gↄ̃̀ gↄ̃ↄ sai nɛ́ sai. ");
INSERT INTO bus_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Kɛ̀ à kú Mↄabunↄ bùsun gwe, à mà kɛ̀ Dii a gbɛ̃nↄ wɛ̃nda gwà à ń gbá pↄ́blee, ben à soru kɛ̀ à ta kↄ̃n a nɛ́ naↄ̃ pìnↄ. ");
INSERT INTO bus_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Ben à fɛ̀ɛ guu kɛ̀ à kún à dà zɛ́n kↄ̃n a nɛ́ naↄ̃ pìnↄ, aↄ̃ↄe taa Yudanↄ bùsun. ");
INSERT INTO bus_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Ben à bè a nɛ́ naↄ̃ pìnↄnɛ: À liara à tá a danↄ kiia. Dii gbɛ̃kɛɛ kɛare lán á kɛ̀ a gↄ̃ↄ kɛ̀ aↄ̃ gànↄnɛ nà kↄ̃n mapio. ");
INSERT INTO bus_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Dii tó a baade ɛara à zã kɛ à vɛ̃ɛkii e. Kɛ̀ à lɛ́ zàḿma, ben aↄ̃ ↄ́ↄ dↄ̀ gbãngbãn. ");
INSERT INTO bus_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Aↄ̃ bènɛ: Wé tányo n gbɛ̃nↄ kiiamɛ. ");
INSERT INTO bus_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Ben à bè a nɛ́ gyaanↄↄ pìnↄnɛ: À liara! Bↄ́yãnzi é támaozi? Mɛ́ ɛara mà nɛ́gↄ̃gbɛ̃nↄ i lɛ à e à zã kɛḿma dↄn yↄ́? ");
INSERT INTO bus_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","À liara à tá! Ma zi kũ̀, mɛ́ e mà zã kɛ dↄro. Baa tó ma bè mɛ́ wɛ́ɛ dↄ zãkɛnazi, ben má è uusiɛa ma nɛ́gↄ̃gbɛ̃nↄ ìo, ");
INSERT INTO bus_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","é fↄ̃ à ń dã ai aↄ̃ bíta kũↄ́? É fↄ̃ àgↄ̃ kuu pↄsɛ ń yãnziↄ́? Auo, ma nɛ́nↄ! Dii kpɛɛ lìmɛmɛ. Yã kɛ̀ à a lee pì e kɛmɛ nnaro fá! ");
INSERT INTO bus_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Aↄ̃ ɛ̀ara wà nà ↄ́ↄ dↄↄa, ben Opa lɛ́ zà a zã da pìa, mↄde Rutu gì à nàa. ");
INSERT INTO bus_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Ben Naomi bènɛ: Ǹ gwa, n gbɛ̃ndoo e taa a gbɛ̃nↄ kↄ̃n a tãanↄzi. Ǹ liara ǹ táo. ");
INSERT INTO bus_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ben Rutu bènɛ: Ǹton nakↄ̃rɛma mà n tón mà táro. Guu kɛ̀ n kɛ̀sɛ e pɛɛɛn, wégↄ̃ lɛdomɛ. Guu kɛ̀ n pitan, gwen mɛ́ pitan. N gbɛ̃nↄ é gↄ̃ ma gbɛ̃nↄ ũ, n Luda é gↄ̃ ma Luda ũ. ");
INSERT INTO bus_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Guu kɛ̀ n gan, gwen mɛ́ gan wà ma vĩi gwe. Gaa baasiro pↄ́ke é wa kɛ̃kↄ̃aro. Tó ma kɛ̃mma, Dii yã kɛmɛ pãsĩpãsĩ. ");
INSERT INTO bus_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Kɛ̀ Naomi è à zɛ̀o à táaomɛ, èe yãke onɛ dↄro. ");
INSERT INTO bus_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Ben aↄ̃ plaa ń píngi gàa aɛ ai aↄ̃ kà Bɛtɛlɛmu. Kɛ̀ aↄ̃ kà gwe, wɛ́tɛ lògo ń yã musu. Gbɛ̃nↄ bè: Naomin gwe sↄ̃ↄ́? ");
INSERT INTO bus_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Ben à bèńnɛ: Àtongae ma sísi Naomi dↄro, séde Mara, zaakɛ Gbãapingide pↄsiayã kɛ̀mɛ. ");
INSERT INTO bus_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Ma gaa wɛ́tɛa kↄ̃n pↄ́o, ben Dii sùmao ↄkori. Bↄ́ yã bé à tò é ma sísi Naomii? Dii bↄ̀ ma kpɛɛ, Gbãapingide yã'ↄ̃amma kpàmazi. ");
INSERT INTO bus_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Lán Naomi sù kↄ̃n Mↄabunↄ bùsuo nàn gwe kↄ̃n a nɛ́ naↄ̃ Rutu, Mↄabu boriio. Aↄ̃ kà Bɛtɛlɛmu gurↄↄ kɛ̀ wà nà nagãkɛ̃naamɛ. ");
INSERT INTO bus_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Naomi zã Ɛlimɛlɛki bɛ gↄ̃gbɛ̃ kee kuu, gbɛ̃nsi auzikideemɛ, à tↄ́n Bↄaza. ");
INSERT INTO bus_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Mↄabu nↄgbɛ̃ Rutu bè Naominɛ: Ǹ tó mà gá bura nagã kↄ̃ↄ wɛ màgↄ̃ tɛ́ gbɛ̃ kɛ̀ ma wɛ̃nda gwà kpɛɛ. Ben à bè a nɛ́ gyaanↄↄ pìnɛ: Ǹ gá! ");
INSERT INTO bus_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Ben à fɛ̀ɛ à gàa nagã kↄ̃ↄ wɛ bura, ègↄ̃ tɛ́ pↄ́kɛ̃rinↄ kpɛɛ. À mↄ̀ à lè buraa kɛ̀ à gàan pì nɛ́ Ɛlimɛlɛki danɛ Bↄaza buraamɛ. ");
INSERT INTO bus_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Ben Bↄaza bↄ̀ Bɛtɛlɛmu. Kɛ̀ à kà gwe, à ì kpà pↄ́kɛ̃rinↄa à bè: Dii gↄ̃ kúao! Ben aↄ̃ bènɛ: Dii aubarika dangu! ");
INSERT INTO bus_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Bↄaza bè a zĩkɛri kɛ̀ dɛ à pↄ́kɛ̃rinↄ gwàri ũunɛ: Dé bé à nↄkparɛ kɛ̀kãa vĩi? ");
INSERT INTO bus_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Ben à wèàla à bè: Nↄkparɛ pì nɛ́ Mↄabu nↄgbɛ̃ kɛ̀ Naomi bↄ̀o Mↄabunↄ bùsun à sùomɛ. ");
INSERT INTO bus_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","À bè mà tó à nagãa kↄ̃ↄ wɛ pↄ́kɛ̃rinↄ kpɛɛ, ben èe zĩi kɛɛ zaa kↄngↄ. Tian à mↄ̀ kámma bo féte kutaa guu. ");
INSERT INTO bus_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Ben Bↄaza gàa à bè Rutunɛ: Ǹ ma yã ma. Ǹton gá nagã kↄ̃ↄ wɛ bú pãnde guuro. Ǹton gɛ̃walaro. Ǹ gↄ̃ kɛ̀ kↄ̃n ma nↄgbɛ̃ zĩkɛrinↄ. ");
INSERT INTO bus_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Ǹ wɛ́ɛ dↄ zĩi kɛ̀ aↄ̃ↄe kɛɛzi ǹgↄ̃ tɛ́ ń kpɛɛ. Má ò ma gↄ̃kparɛnↄnɛ aↄ̃ton ĩa dammaro. Tó ímii e n dɛɛ, ǹ gá ǹ í kɛ̀ aↄ̃ↄ kà orozãnↄn mi. ");
INSERT INTO bus_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","À kùɛnɛ à mì pɛ̀ɛ à bè: À kɛ̀ dia mamↄma kɛ̀ bori pãnde nↄgbɛ̃n ma ũ, n làakari dↄ̀ma, ben n yã maaa kɛ̀mɛɛ? ");
INSERT INTO bus_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Ben Bↄaza wèàla à bè: Wà yã kɛ̀ ń kɛ̀ n zã danɛ n zã gaa gbɛraa òmɛ píngi, lán n n de kↄ̃n n dao tò nà kↄ̃n n bùsuo, ben n mↄ n vɛ̃ɛ gbɛ̃ kɛ̀ ń ń dↄ̃ yãroonↄ tɛ́. ");
INSERT INTO bus_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Dii fĩa bonnɛ yã kɛ̀ ń kɛ̀ musu. Lán n mↄ n sↄtↄ Dii Isarailinↄ Luda ↄru guu nà, à fĩa bonnɛ maamaa. ");
INSERT INTO bus_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rutu bè: Baa, n yã maaa kɛ̀mɛ fá! N ma làakari kpàɛmɛ, n yã nnaa ò mamↄma n zĩkɛrinɛ, baa kɛ̀ n zĩkɛrinↄ doken ma ũro. ");
INSERT INTO bus_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Pↄ́blegurↄ Bↄaza bènɛ: Ǹ mↄ́ ǹ pↄ́ ble kɛ̀ ǹgↄ̃ burɛdi zↄ̃ↄ dòa. Ben à vɛ̃̀ɛ pↄ́kɛ̃rinↄ saɛ. Bↄaza pↄ́wɛɛ kpatana kpàa, ben à pↄ́ blè à kã̀ ai à kpaaa gↄ̃̀. ");
INSERT INTO bus_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Kɛ̀ à fɛ̀ɛ èe gaa pↄ́ kↄ̃ↄ wɛ, ben Bↄaza ò gↄ̃kparɛnↄnɛ à bè: Baa tó èe pↄ́ kↄ̃ↄ wɛɛ nagãa kɛ̀ kaɛna tɛ́, àton wí daaro. ");
INSERT INTO bus_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","À à sà kenↄ bↄbↄnɛ nagãa guu à tó à kↄ̃ↄ wɛ. Àton pataaro. ");
INSERT INTO bus_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Ben à pↄ́ kↄ̃ↄ wɛ̀ ai uusiɛ. Kɛ̀ à zↄ̃̀ à à wɛ́ɛ bↄ̀, à kà koto lɛ́ do taka bà. ");
INSERT INTO bus_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Kɛ̀ à sɛ̀ à tào bɛ, ben à pↄ́ kɛ̀ à kↄ̃ↄ wɛ̀ pì ↄ̀dↄa a zã danɛ. À pↄ́ kɛ̀ à fùa à blee pì kpàa dↄ. ");
INSERT INTO bus_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Ben à zã da à là à bè: Mákpan n pↄ́ kↄ̃ↄ wɛ̀n gbã̀a? N zĩi kɛ̀ mámɛ? Luda aubarika da gbɛ̃ kɛ̀ làakari dↄ̀mmaan. Ben à gbɛ̃ kɛ̀ à zĩi kɛ̀ à bura yã ònɛ à bè: Gbɛ̃ kɛ̀ ma zĩi kɛ̀ à bura gbã̀a tↄ́n Bↄaza. ");
INSERT INTO bus_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Ben Naomi bè: Ma Dii sáabu kɛ̀! À kpɛ́ èe gbɛ̃kɛɛ kɛɛ wamↄwa kɛ̀ wá bɛ̃ɛnↄnɛ kↄ̃n wa gbɛ̃ kɛ̀ aↄ̃ gànↄ. Ben à ɛ̀ara à bè: Gbɛ̃ pì nɛ́ wa danɛ fɛ̃̀fɛ̃ bòrinↄ dokemɛ. ");
INSERT INTO bus_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Ben Mↄabu nↄgbɛ̃ Rutu bè: À bèmɛ mà na a zĩkɛrinↄa ai aↄ̃ gá pↄ́ kɛ̃ wà yãao. ");
INSERT INTO bus_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Ben Naomi bè a nɛ́ gyaanↄↄ pìnɛ: À maa ǹ gá kↄ̃n à nↄgbɛ̃ zĩkɛrinↄ lɛ wàton ĩa damma bura pãndearo yãnzi. ");
INSERT INTO bus_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Ben à nà Bↄaza nↄgbɛ̃ zĩkɛrinↄa. Ègↄ̃ pↄ́ kↄ̃ↄ wɛɛ ń kpɛɛ ai wà gàa wà nagã kↄ̃n gbadooo kɛ̃̀ wà yã̀a. À kú a zã da bɛmɛ. ");
INSERT INTO bus_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Naomi bè a nɛ́ gyaanↄↄ pìnɛ: À maa mà bɛɛ wɛtɛnnɛ, guu kɛ̀ nɛ́ e ǹgↄ̃ kún aafia. ");
INSERT INTO bus_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Bↄaza kɛ̀ ń kú kↄ̃n à zĩkɛrinↄ nɛ́ wa danɛnloo? Àmbe èe pↄ́wɛɛ gbɛ̃ɛ uusiɛa. ");
INSERT INTO bus_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ǹ zú o ǹ nↄ́si kɛmma. Ǹ n pↄ́ maaa da ǹ gá blɛwɛɛgbɛ̃kiia. Ǹton tó à n yã dↄ̃ro ai à pↄ́ blè à í mì à yã̀a. ");
INSERT INTO bus_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Tó à dàɛ, ǹ guu kɛ̀ à dàɛn gwa, ǹ gá ǹ à bisa lɛ́ sɛ́ ǹ daɛ à gbá saɛ. Eé yã kɛ̀ nɛ́ kɛɛ onnɛ. ");
INSERT INTO bus_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Ben à bènɛ: Yã kɛ̀ ń ò píngi, mɛ́ kɛmɛ. ");
INSERT INTO bus_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Ben à gàa blɛwɛɛgbɛ̃kiia à yã kɛ̀ a zã daa ònɛ pì kɛ̀ píngi. ");
INSERT INTO bus_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Bↄaza pↄ́ blè à í mì, à pↄↄ kɛ̀ nna. À gàa à dàɛ pↄ́wɛɛ tò saɛ kãa kpa, ben Rutu lↄↄtɛ̀zi tɛɛɛ, à bisa gò à gbála à dàɛ gwe. ");
INSERT INTO bus_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Lezãndo kɛ̀ Bↄaza kɛ̀ gìri, à vù kↄ̃n iio à lìɛ, ben à è nↄgbɛ̃ bé à daɛna a gbá saɛ. ");
INSERT INTO bus_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Kɛ̀ à bè, démɛ, ben Rutu wèàla à bè: N zĩkɛri Rutumɛ. Ǹ n bisa lɛ́ kúmala, zaakɛ ma danɛ fɛ̃̀fɛ̃ kɛ̀ eé ma boon n ũ. ");
INSERT INTO bus_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","À bènɛ: Dii aubarika dangu! Gbɛ̃kɛɛ kɛ̀ ń kɛ̀ zãa kɛ̀kii dɛ à káakupↄla. Nɛ́ɛ gá n gↄ̃kparɛ wɛ̀tɛro, takaasidee kesↄ̃ auzikidee. ");
INSERT INTO bus_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ǹton tó vĩa n kũro. Pↄ́ kɛ̀ n wɛ́ɛ kɛ̀ píngi, mɛ́ kɛnnɛ, zaakɛ wɛ́tɛdeenↄↄ dↄ̃ ń píngi kɛ̀ nↄ maaan n ũ. ");
INSERT INTO bus_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Yãpuraamɛ! N danɛn ma ũ, mↄde danɛ fɛ̃̀fɛ̃ pãndee kuu à fɛ̃fɛ̃kɛɛ dɛmala. ");
INSERT INTO bus_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Ǹ i kɛ̀ gwãavĩa, zia kↄngↄ tó à yezi à n bomɛ, à maa, à n bo. Mↄde tó èe weziro, má sì kↄ̃n Diio mɛ́ n bo. Ǹ i kɛ̀ ai guu dↄ. ");
INSERT INTO bus_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","À daɛna à gbá saɛ gwe ai gukɛ̃kↄ̃anao, ben à fɛ̀ɛ ai guwɛɛ gↄ̃ gá kɛ̃, zaakɛ Bↄaza bènɛ àton tó gbɛ̃kee dↄ̃ kɛ̀ à mↄ̀ blɛwɛɛgbɛ̃kiiaro. ");
INSERT INTO bus_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","À bènɛ dↄ: Ǹ n pↄ́dangãn poro ǹgↄ̃ kũna. Kɛ̀ à kũna, ben Bↄaza nagãa kànnɛ zaka lɛ́ swɛɛdo à dìnɛ, ben à tào bɛ. ");
INSERT INTO bus_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Kɛ̀ à kà bɛ, à zã da à là à bè: Yã kɛ̀ dia gwee? Ben à yã kɛ̀ gↄ̃gbɛ̃ pì kɛ̀nɛ ònɛ píngi ");
INSERT INTO bus_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","à bè: À ma gba nagã zaka lɛ́ swɛɛdoo kɛ̀kiimɛ. À bè à maa mà tá ma zã daa ↄkoriro. ");
INSERT INTO bus_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Ben Naomi bè: Ǹ vɛ̃ɛ tɛɛɛ ai ǹ yã pì mìdɛna dↄ̃, zaakɛ gↄ̃gbɛ̃ pì é kámma bo gbã̀a yã pì mìdɛna sairo. ");
INSERT INTO bus_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Bↄaza gàa à vɛ̃̀ɛ wɛ́tɛ bĩilɛa, ben à è danɛ fɛ̃̀fɛ̃ bòri kɛ̀ à à yã ò pì e mↄↄ. Ben à bè: Ma gbɛ̃, ǹ mↄ́ ǹ vɛ̃ɛ. ");
INSERT INTO bus_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Ben à wɛ́tɛ gbɛ̃nsinↄ sìsi gↄ̃ↄn kuri à bè aↄ̃ vɛ̃ɛ. ");
INSERT INTO bus_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Ben à bè danɛ fɛ̃̀fɛ̃ pìnɛ: Naomi kɛ̀ sù kↄ̃n Mↄabunↄ bùsuo e wa vĩ̀i Ɛlimɛlɛki bura kpadoo yaa. ");
INSERT INTO bus_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Ben má è à maa mà à yã onnɛ, lɛ ǹ lú wa gbɛ̃nsi kɛ̀ aↄ̃ↄ vɛ̃ɛna kɛ̀nↄ wáa. Tó ń yezi ǹ bomɛ, ǹ bo. Tó ń yezi ǹ bo sↄ̃ro, ǹ omɛ mà ma, zaakɛ ḿbe ń à bona zɛ́ vĩ. Tó n baka gɛ̃̀, sé mapi. Ben gↄ̃gbɛ̃ pì bè: Mɛ́ bo. ");
INSERT INTO bus_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Ben Bↄaza bè: Tó n tↄↄtɛ pì lù Naomi kↄ̃n Mↄabu nↄgbɛ̃ Rutuoa, nɛ́ gbɛ̃ kɛ̀ gà gyaanↄↄ e dↄ, lɛ à tↄ́ e à gↄ̃ à túbia. ");
INSERT INTO bus_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Ben danɛ fɛ̃̀fɛ̃ bòri pì bè: Tó lɛn à dɛ lɛ, mɛ́ boro, lɛ màton ma zĩnda túbi yakaro yãnzi. Ǹ n pↄ́ bo, zaakɛ mɛ́ fↄ̃ mà boro. ");
INSERT INTO bus_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Isarailinↄ bùsun yã tó gbɛ̃ e tↄↄtɛ boo ke èe à lendee kpaa, tó èe yã mì dɛɛ, è a kyate gbá doo bↄ à dↄ gbɛ̃nɛmɛ yã pì mìdɛna sèeda ũ Isarailinↄnɛ. ");
INSERT INTO bus_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Kɛ̀ danɛ fɛ̃̀fɛ̃ bòri pì bè Bↄazanɛ à lú, ben à a kyatee bↄ̀ à kpà Bↄazaa. ");
INSERT INTO bus_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Ben Bↄaza bè gbɛ̃nsi pìnↄnɛ kↄ̃n gbɛ̃ kpaaanↄ ń píngi: Ámbe sèedadeenↄ ũ gbã̀a, kɛ̀ ma Ɛlimɛlɛki kↄ̃n Malonuo kↄ̃n Kiliↄ̃o pↄ́nↄ lù Naomia píngi. ");
INSERT INTO bus_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Ben ma Malonu gyaanↄ Rutu, Mↄabu nↄgbɛ̃ è nↄↄ ũ dↄ, lɛ gbɛ̃ kɛ̀ gà pì tↄ́ e àgↄ̃ kú à túbia, lɛ à tↄ́ tón ga à gbɛ̃nↄ tɛ́ ke à wɛ́tɛ kɛ̀ guuro. Ámbe yã pì sèedadeenↄ ũ gbã̀a. ");
INSERT INTO bus_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Ben gbɛ̃nsi pìnↄ kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ kú gãnu guunↄ bè ń píngi: Wámbe sèedadeenↄ ũ. Dii tó nↄgbɛ̃ kɛ̀ èe gɛ̃ɛ n ua pì gↄ̃ lán Rasɛli kↄ̃n Leao bà. Aↄ̃ plaa ń píngi bé wà Isarailinↄ borii kɛ̀. Eé tó ǹ gbãa kũ Ɛflata bùsun ǹ tↄ́ bↄ Bɛtɛlɛmu. ");
INSERT INTO bus_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Dii tó borii kɛ̀ eé kpámma kↄ̃n nↄgbɛ̃ pìonↄ gↄ̃ lán Pɛrɛzi kɛ̀ Tama ì Yudanɛ boriinↄ bà. ");
INSERT INTO bus_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Ben Bↄaza Rutu sɛ̀ nↄↄ ũ. À dàɛo, ben Dii tò à nↄ̀ sì, ben à nɛ́ ì gↄ̃gbɛ̃ ũ. ");
INSERT INTO bus_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Ben nↄgbɛ̃nↄ bè Naominɛ: Wa Dii sáabu kɛ̀, èe n tó borii sai gbã̀aro. Luda tó nɛ́ pì tↄ́ bↄ Isarailinↄ tɛ́. ");
INSERT INTO bus_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Eé n làakari kpáɛnnɛ, eé n gwa n zikũ guu, zaakɛ n nɛ́ gyaanↄↄ kɛ̀ yenzi bé à à ìnnɛ, à sↄ̃ à maannɛ dɛ nɛ́gↄ̃gbɛ̃ gↄ̃ↄn swɛɛplaaanↄla. ");
INSERT INTO bus_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Ben Naomi nɛ́ pì sɛ̀ à kpà a kùla à gↄ̃̀ à gwàri ũ. ");
INSERT INTO bus_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Ben nↄgbɛ̃ kɛ̀ aↄ̃ↄ kú gweenↄ bè: Wà nɛ́gↄ̃gbɛ̃ ì Naominɛ. Ben aↄ̃ tↄ́ kpànɛ Ɔbɛdi. Àmbe Yɛsɛ de, Dauda dezi ũ. ");
INSERT INTO bus_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Pɛrɛzi boriinↄ zɛ́kpaɛn yɛ̀: Pɛrɛzi bé à Ɛzɛrↄnu ì, ");
INSERT INTO bus_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Ɛzɛrↄnu Ramu ì, Ramu Aminadabu ì, ");
INSERT INTO bus_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadabu Nasↄ̃ ì, Nasↄ̃ Salamↄ ì, ");
INSERT INTO bus_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salamↄ Bↄaza ì, Bↄaza Ɔbɛdi ì, ");
INSERT INTO bus_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Ɔbɛdi Yɛsɛ ì, ben Yɛsɛ Dauda ì. ");
INSERT INTO bus_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Gↄ̃gbɛ̃ kee kú Rama, Ɛflaimu bùsu gusĩsĩdeen. Zufu boriimɛ, à tↄ́n Ɛlɛkana, Yeroamu nɛ́mɛ. Ɛflaimu borii kɛ̀ wè benɛ Zufu pì bé à Tohu ì, ben Tohu Ɛliu ì, ben Ɛliu Yeroamu pì ì. ");
INSERT INTO bus_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Ɛlɛkana nↄↄnↄ vĩ mɛ̀n plaa, à káaku tↄ́n Ana, à plaade tↄ́n Penina. Penina bé à nɛ́nↄ vĩ, Ana sↄ̃ↄ e nɛ́ iro. ");
INSERT INTO bus_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Wɛ̃̀ kↄ̃n wɛ̃̀o gↄ̃gbɛ̃ pì è bↄ a wɛ́tɛ guu à gá dↄnzi kɛ Dii Zĩ̀kpɛdenɛ zaa Silo à saa oa. Ɛli nɛ́gↄ̃gbɛ̃ mɛ̀n plaaanↄ Ɔfini kↄ̃n Finɛasio kú gwe Dii gbã̀gbãrinↄ ũ. ");
INSERT INTO bus_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Gurↄↄ kɛ̀ Ɛlɛkana saa ò, è à nↄ̀bↄ kpá a naↄ̃ Peninaa kↄ̃n à nɛ́gↄ̃gbɛ̃nↄ kↄ̃n à nɛ́nↄgbɛ̃nↄ ń píngi, ");
INSERT INTO bus_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","ben è à lɛo plaaa kpá Anaa kɛ̀ à yezi yãnzi, baa kɛ̀ Dii à kɛ̀ pãaa ũ. ");
INSERT INTO bus_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","À gↄ̃aanↄ pì sↄ̃, ègↄ̃ à faboo kɛ̀ à kuu pãaa ũ yãnzi, lɛ à à nↄ̀sɛ fɛɛnɛ. ");
INSERT INTO bus_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Lɛn ègↄ̃ kɛɛnɛ lɛ wɛ̃̀ kↄ̃n wɛ̃̀o. Tó Ana gàa Dii kpɛ́ guu, à gↄ̃aanↄ pì è à fabo, ben è ↄ́ↄ dↄ ai à fua à pↄ́ ble. ");
INSERT INTO bus_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Ben à zã è à lá: Ana, bↄ́ bé à n le nɛ́ɛ ↄ́ↄ dↄↄ, ben n gi pↄ́ blezii? À kɛ̀ dia n nↄ̀sɛ yàka? Má dɛnnɛ nɛ́gↄ̃gbɛ̃ mɛ̀n kurilaroo? ");
INSERT INTO bus_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","Zĩkea kɛ̀ aↄ̃ↄ kú Silo, aↄ̃ pↄ́ blè wà yã̀a, sa'ori Ɛli vɛ̃ɛna kìtaa Dii kpɛ́ kpɛɛlɛ, ben Ana fɛ̀ɛ ");
INSERT INTO bus_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","kↄ̃n nↄ̀sɛyakana bítao, à wɛ́ɛ kɛ̀ Diia kↄ̃n ↄ́ↄ dↄↄo maamaa. ");
INSERT INTO bus_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Ben à lù sɛ̀ Diinɛ à bè: Dii Zĩ̀kpɛde, ǹ tó mamↄma n zↄ̀bleri yã dↄngu! Ǹ ma wɛ̃nda gwa! Tó ma yã e sãnguro, bensↄ̃ n ma gba nɛ́gↄ̃gbɛ̃, mɛ́ à kpámma n pↄ́ ũ ai à wɛ̃̀ndi lɛ́n, gɛ̃ɛ é na à mìa zikiro. ");
INSERT INTO bus_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Kɛ̀ à wɛ́ɛkɛna Diia pì e yãaaro, ben Ɛli e à lɛ́ tàasi kɛɛ. ");
INSERT INTO bus_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","Ana e adua pì kɛɛ a swɛ̃̀ guu, à lɛ́ bé èe kɛɛ zúgizugi, èe yã o à bↄ̀ a lɛ́n gbɛ̃kee màro. Ɛli e daa wɛ̃ɛ e à dɛɛmɛ, ");
INSERT INTO bus_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","ben à bènɛ: Wɛ̃ɛ égↄ̃ n dɛɛ ai bↄrɛmɛ? Ǹ mì kɛ̃ wɛ̃ɛa. ");
INSERT INTO bus_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Ben Ana wèàla à bè: Èe kɛ lɛnlo Baa! Nↄgbɛ̃ pↄsiadeen ma ũ, mɛ́ɛ wɛ̃ɛ ke í gbãa ke miro. Mɛ́ɛ ma yã'ↄ̃ammanↄ oo Diinɛmɛ. ");
INSERT INTO bus_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Ǹton mamↄma n zↄ̀bleri diɛ nↄgbɛ̃ pãpãdee ũro. Ma nↄ̀sɛ kɛ̀ yàka kↄ̃n ma kuuna bídi guuo bé à tò mɛ́ɛ wɛ́ɛ kɛɛ gura kɛ̀ ai tia. ");
INSERT INTO bus_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Ben Ɛli bènɛ: Ǹ tá kↄ̃n aafiao. Isarailinↄ Luda n gba pↄ́ kɛ̀ n wɛ́ɛ kɛ̀a. ");
INSERT INTO bus_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Ben Ana bè: Ǹ tó mapi n zↄ̀bleri yã kánnɛ. Ben à tà à pↄ́ blè à uu wère. ");
INSERT INTO bus_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Kɛ̀ guu dↄ̀, aↄ̃ fɛ̀ɛ idɛ'idɛ aↄ̃ gàa wà dↄnzi kɛ̀ Diinɛ. Ben aↄ̃ ɛ̀ara wà tà ń bɛ wɛ́tɛ zaa Rama. Kɛ̀ Ɛlɛkana dàɛ kↄ̃n a naↄ̃ Anao, à yã dↄ̀ Diin. ");
INSERT INTO bus_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Gurↄ beeean à nↄ̀ sì à nɛ́ ì gↄ̃gbɛ̃ ũ, ben à tↄ́ kpànɛ Samuɛli, zaakɛ à bè: Ma à wɛ́ɛ kɛ̀ Diiamɛ. ");
INSERT INTO bus_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Ben Ɛlɛkana fɛ̀ɛ kↄ̃n a bɛdeenↄ ń píngi, aↄ̃ ɛ̀ara wà gàa saa kɛ̀ wè o wɛ̃̀ kↄ̃n wɛ̃̀o o Diia, aↄ̃ lù kɛ̀ aↄ̃ↄ sɛ̀nɛ fĩa bo. ");
INSERT INTO bus_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Mↄde Ana e gáro. À bè a zãnɛ: Tó nɛ́ pì kɛ̃̀, ben mɛ́ gá à ↄdↄa Diinɛ, eégↄ̃ kú gwe gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Ben à zã bènɛ: Lán à kɛ̀nnɛ maa nà ǹ kɛ. Ǹ tó ai à kɛ̃. Dii tó yã pì kɛ. Ben nↄgbɛ̃ pì a nɛ́ gwà ai à gàa à kɛ̃̀o. ");
INSERT INTO bus_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Kɛ̀ à kɛ̃̀, ben à à sɛ̀ à gàao Dii kpɛ́n zaa Silo kↄ̃n zùsware wɛ̃̀ aagↄ̃ↄo kↄ̃n wísitio konko do kↄ̃n geepiwɛ̃ɛo tùu do. Nɛ́ pì kɛ̀ gↄ̃kparɛ ũ. ");
INSERT INTO bus_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Kɛ̀ aↄ̃ zùswaree pì kòto kpà, ben aↄ̃ gàa kↄ̃n nɛ́ pìo Ɛli kiia. ");
INSERT INTO bus_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Ben Ana bènɛ: Baa, ǹ gaafaa kɛmɛ! Kↄ̃n n kuunao mámbe nↄgbɛ̃ kɛ̀ zɛ mɛ́ɛ wɛ́ɛ kɛɛ Diia n wáa gura kɛ̀ ũ. ");
INSERT INTO bus_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Nɛ́ kɛ̀kiin ma wɛ́ɛ kɛ̀ Diia, ben à ma gba pↄ́ kɛ̀ má gbèkaa pì. ");
INSERT INTO bus_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Beee yãnzin ma mↄ à kpá Diiazi, lɛ àgↄ̃ kuu à pↄ́ ũ ai a wɛ̃̀ndi lɛ́n. Ben aↄ̃ dↄnzi kɛ̀ Diinɛ gwe. ");
INSERT INTO bus_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Ben Ana adua kɛ̀ à bè: Ma nↄ̀sɛ e yáa dↄↄ Diia, ma mì da'iana Dii yãnzi. Mɛ́ɛ woo kaa ma ibɛɛnↄa, ma pↄↄ kɛ̀ nna, kɛ̀ à ma mì sì. ");
INSERT INTO bus_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","Gbɛ̃kee kú adona lán Dii bàro, gbɛ̃kee kuu lán à bàro, gbɛ̀si kee kuu lán wa Luda bàro. ");
INSERT INTO bus_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","Àton yã bↄɛ kↄ̃n yↄ̃nkↄↄoro, àton tó wadayã bↄ a lɛ́nlo, zaakɛ Dii Ludan yãdↄ̃ri ũ, àmbe è wa yãkɛnanↄ yↄ̃ à gwa. ");
INSERT INTO bus_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","Gↄ̃sagbãaanↄ sá ɛ̀'ɛ, mↄde gbɛ̃ funanↄ gbãa asaa dↄ̀ ń pii. ");
INSERT INTO bus_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Gbɛ̃ kãna e a zĩnda aya kɛɛ pↄ́blee yãnzi, mↄde nↄaa e gbɛ̃ kɛ̀ èe à dɛ yãa dɛ dↄro. Pãaa nɛ́ ì mɛ̀n swɛɛplaa, mↄde nɛ́pari'iri gↄ̃̀ wɛ̃nda. ");
INSERT INTO bus_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","Dii bé è tó gbɛ̃ ga, bensↄ̃ è tó gbɛ̃ gↄ̃ kuu. Àmbe è tó gbɛ̃ gɛ̃ bùsu guu, bensↄ̃ è gɛ̀ vu. ");
INSERT INTO bus_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","Dii bé è mↄ́ kↄ̃n takaasio kↄ̃n kuuna nnaao, è ↄ tↄ̃ gbɛ̃kenↄa, è gbɛ̃kenↄ sɛ́ lezĩ. ");
INSERT INTO bus_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","È wɛ̃ndadeenↄ bↄ bùsutitin, è takaasideenↄ bↄ tubura. È ń vɛ̃ɛ gu dↄ̃nkↄ̃n kↄ̃n kínɛnↄ, è tó aↄ̃ kpata ble kↄ̃n gakuio. Zaakɛ tↄↄtɛ kãsãpɛɛkiinↄ nɛ́ Dii pↄ́mɛ, ben à anduna kàɛa. ");
INSERT INTO bus_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","È a gbɛ̃nↄ gbápɛɛki dãkpańnɛ, è zaakɛrinↄ dúgu zↄ̃ gusiaan. Gbɛ̃ke é fↄ̃ à ↄsii nɛ kↄ̃n a zĩnda gbãaaoro. ");
INSERT INTO bus_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","Dii é a ibɛɛnↄ ú lↄ́, eé pata a ibɛɛnↄa zaa musu, eé yãkpaɛ kɛńyo ai anduna lɛ́zɛkiia. Eé gbãaa kpá kína kɛ̀ à kàa, eé gbɛ̃ kɛ̀ à sɛ̀ pì mì da ía. ");
INSERT INTO bus_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Ben Ɛlɛkana tà a bɛ wɛ́tɛ zaa Rama, ben nɛ́gↄ̃gbɛ̃ pì gↄ̃̀, èe zĩi kɛɛ Diinɛ kↄ̃n sa'ori Ɛlio. ");
INSERT INTO bus_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","Ɛli nɛ́gↄ̃gbɛ̃nↄ nɛ́ nɛ́ pãsĩnↄmɛ, aↄ̃è Dii daro. ");
INSERT INTO bus_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","Yã kɛ̀ sa'ori pìnↄ è kɛńnɛn yɛ̀. Tó gbɛ̃ saa ò, gurↄↄ kɛ̀ èe nↄ̀bↄ pì fùfu kɛɛ, sa'ori ìba ke è mↄ́ kↄ̃n saka gbã̀dã aagↄ̃deeo kũna. ");
INSERT INTO bus_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","Ben è pɛɛ taa guu ke oroo ke mↄ̀'oroo, ben sa'ori è pↄ́ kɛ̀ saka pì bↄ̀o sɛ́ a pↄ́ ũ píngi. Lɛn aↄ̃è kɛ Isaraili kɛ̀ aↄ̃ mↄ̀ Silonↄnɛ lɛ ń píngi. ");
INSERT INTO bus_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","Baa ai wàgↄ̃ gá nↄ̀bↄ kpá tɛ́a à nↄ́si yãa, sa'ori ìba ke è mↄ́ à be gbɛ̃ kɛ̀ saa ò pìnɛ: Ǹ nↄ̀bↄ kpá sa'oria à kpá tɛ́a, zaakɛ eé we à nↄ̀bↄ fùfukɛna símmaro, sé à búsu. ");
INSERT INTO bus_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","Tó gbɛ̃ pì bènɛ é nↄ̀bↄ kpá tɛ́a gĩa a nↄ́si yãa, gbasa pↄ́ kɛ̀ à yezi à sɛ́ sa, ben ìba pì è be: Auo! Ǹ kpáma gↄ̃ↄ! Tó n gi, mɛ́ bↄ kↄ̃n gbãaao. ");
INSERT INTO bus_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","Gↄ̃kparɛ pìnↄ durun kɛ̀ bíta Diinɛ maamaa, zaakɛ aↄ̃ↄe kya kaa à sa'onↄbↄmmɛ. ");
INSERT INTO bus_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","Nɛ́gↄ̃gbɛ̃ Samuɛli sↄ̃ ègↄ̃ zĩi kɛɛ Diinɛ kↄ̃n dansiki utao dana. ");
INSERT INTO bus_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","À da è uta gyaba nɛ́ngo zↄ̃nɛ. Tó èe mↄↄ saa o kↄ̃n a zão wɛ̃̀ kↄ̃n wɛ̃̀o, ben è mↄ́onɛ. ");
INSERT INTO bus_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Ɛli è sa maaa o Ɛlɛkananɛ kↄ̃n a nↄↄ pìo à be: Dii n gba nɛ́ dↄ kↄ̃n n nↄↄ pìo, nɛ́ kɛ̀ à à wɛ́ɛ kɛ̀ ben à kpà Diia pì gɛ̃ɛ ũ. Ben aↄ̃è tá ń bɛ. ");
INSERT INTO bus_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Ben Dii aubarika dà Anan, à ɛ̀ara à nɛ́ ì mɛ̀n sↄↄro, gↄ̃gbɛ̃nↄ gↄ̃ↄn aagↄ̃, nↄgbɛ̃nↄ plaa. Nɛ́gↄ̃gbɛ̃ Samuɛli sↄ̃ↄ e bíta kũu Dii ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","Ɛli zi kũ̀ kótokoto, à yã kɛ̀ a nɛ́nↄↄ e kɛɛ Isarailinↄnɛ mà píngi kↄ̃n lán aↄ̃è daɛ kↄ̃n nↄgbɛ̃ kɛ̀ aↄ̃ègↄ̃ zĩi kɛɛ dakↄ̃rɛki kuta kpɛɛlɛnↄo nà. ");
INSERT INTO bus_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","Ben à ń lá à bè: Bↄ́ bé à tò ée yã kɛɛ lɛɛ? Má mà baade píngi e a yãzaakɛna oo. ");
INSERT INTO bus_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","Àton kɛ lɛro ma nɛ́nↄ! Baaru kɛ̀ má mà kɛ̀ èe daagula Dii gbɛ̃nↄ tɛ́ pì maaro. ");
INSERT INTO bus_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","Tó gbɛ̃ durun kɛ̀ a gbɛ̃daaanɛ, Luda é à yã gↄ̃gↄ̃, mↄde tó gbɛ̃ durun kɛ̀ Diinɛ, dé bé eé agbaa kpánɛ? Ben aↄ̃ gì ń de yã mazi, zaakɛ Dii zɛ̀ kↄ̃n ń dɛdɛna yãomɛ. ");
INSERT INTO bus_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","Nɛ́gↄ̃gbɛ̃ Samuɛli sↄ̃ↄ e bíta kũu èe kaara. Ègↄ̃ nna kↄ̃n Diio kↄ̃n baade píngio. ");
INSERT INTO bus_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","Ben Luda gbɛ̃ke mↄ̀ à bè Ɛlinɛ: Dii bè, gurↄↄ kɛ̀ n dezi Aruna bɛdeenↄↄ e zↄ̀ blee Firi'aunanɛ zaa Igipiti, a bↄ a mↄńzi tɛ̃tɛ̃ntɛ̃, ");
INSERT INTO bus_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","Isaraili boriinↄ tɛ́ píngi n dezi Arunan á sɛ̀ a gbã̀gbãri ũ. Ben à a gbãgbã, à tuaetiti kàare tɛ́n kↄ̃n sa'o'utao dana. Dii bè, a sa'opↄ kɛ̀ Isarailinↄ è kpáta kpà à boriinↄa píngi. ");
INSERT INTO bus_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","Dii bè, bↄ́ bé à tò eè a sa'onↄbↄ zↄ̃ kↄ̃n gbáo kↄ̃n gbaa kɛ̀ á dìɛ aↄ̃ mↄ́oare a kpɛ́ guuo? À bè, bↄ́yãnzi nɛɛ̀ n nɛ́nↄ diɛ dɛalazi, ben ée mɛ̀ kpaa kↄ̃n a gbɛ̃ Isarailinↄ sa'onↄbↄ maaao? ");
INSERT INTO bus_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","Beee yãnzi Dii Isarailinↄ Luda bè, á dìɛ yã n boriinↄ kↄ̃n n dezi boriinↄ bé wàgae a gbãgbã ai gurↄ píngi, mↄde tia ée we beeezi dↄro. À bè, gbɛ̃ kɛ̀ à a kpe dàn é bɛ̀ɛ línɛ, gbɛ̃ kɛ̀ kya kàaguun é kɛ pↄ́ ũro. ");
INSERT INTO bus_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","Ǹ ma! À bè, gurↄke é mↄ́, é n bɛ gbãaa símma kↄ̃n n de bɛ pↄ́o. Mare zi ke égↄ̃ kú n ua dↄro. ");
INSERT INTO bus_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","Nɛ́ nawɛ̃a e a bɛ. Baa tó a aubarika pìsi Isarailinↄa ń píngi, mare zi ke égↄ̃ kú n uaro ai gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","N uadeenↄ é gaga zɛ́gbãn ń píngi. N gbɛ̃ kɛ̀ ée à bↄ a gbãgbãzĩinloo é tó n wɛ́ɛ wo kↄ̃n ↄ́ↄ dↄↄo, n pↄↄ é sia kũ. ");
INSERT INTO bus_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","N nɛ́ gↄ̃ↄn plaa Ɔfini kↄ̃n Finɛasio é gaga gurↄ dↄ̃nkↄ̃ zĩ aↄ̃ plaa ń píngi. Beee égↄ̃ dɛnnɛ sèeda ũ kɛ̀ yã kɛ̀ á ò é kɛ píngi. ");
INSERT INTO bus_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","Dii bè, é gbɛ̃ sɛ́ sa'ori náanɛdee ũ, eé a pↄyeziyã kɛ lán á yezi nà. É à boriinↄ gba gbãaa gíngin, eégↄ̃ zĩi kɛɛ kína kɛ̀ é kánɛ ai gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","N borii kɛ̀ aↄ̃ gↄ̃̀nↄ é mↄ́ wà kúɛ kɛnɛ ↄↄ ke burɛdi yãnzi aↄ̃ be: Ǹ sa'ori zĩ ke dawe wà kɛ, lɛ wà pↄ́ féte e wàgↄ̃ blee. ");
INSERT INTO bus_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Nɛ́gↄ̃gbɛ̃ Samuɛli e zĩi kɛɛ Diinɛ Ɛli ↄzĩ. Gurↄ beeea Dii yã è su gbɛ̃a kpakpaaro, ben wɛ́ɛgupu'ena kuu pariro. ");
INSERT INTO bus_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Zĩkea Ɛli daɛna a daɛkiia. À wɛ́ɛ bùsa, èe guu ee maamaa dↄro. ");
INSERT INTO bus_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Samuɛli daɛna Dii kpɛ́n, guu kɛ̀ Luda àkpati kún. Luda fitia e ga kↄ̀ro. ");
INSERT INTO bus_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","Ben Dii lɛ́ zù Samuɛlizi. À wèàla à bè: Maɛ kɛ̀! ");
INSERT INTO bus_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Ben à bàa lɛ̀ à gàa Ɛli kiia à bè: N lɛ́ zùmazin yↄ́? Maɛ kɛ̀. Ben à bènɛ: Mɛ́ɛ lɛ́ zunziro. Ǹ gá daɛ. Ben à ɛ̀ara à gàa à dàɛ. ");
INSERT INTO bus_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","Dii ɛ̀ara à lɛ́ zùzi dↄ, ben à ɛ̀ara à gàa Ɛli kiia à bè: N lɛ́ zùmazin yↄ́? Maɛ kɛ̀. Ben à bè: Ma nɛ́, mɛ́ɛ lɛ́ zunziro. Ǹ gá daɛ. ");
INSERT INTO bus_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Samuɛli sↄ̃ↄ Dii dↄ̃ gĩaro, Dii yã e sua kↄ̀ro. ");
INSERT INTO bus_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Dii ɛ̀ara à lɛ́ zùzi à gɛ̃̀n aagↄ̃deeo, ben à fɛ̀ɛ à gàa Ɛli kiia dↄ à bè: N lɛ́ zùmazin yↄ́? Maɛ kɛ̀. Ben Ɛli dↄ̃̀ sa kɛ̀ Dii bé èe lɛ́ zuu gↄ̃kparɛ pìzi. ");
INSERT INTO bus_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Ben à bènɛ: Ǹ gá daɛ. Tó à lɛ́ zùnzi sa, ǹ be: Ǹ yã o Dii, n zↄ̀bleri swã dↄ. Ben Samuɛli gàa à dàɛ a daɛkiia. ");
INSERT INTO bus_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Dii mↄ̀ à zɛ̀ gwe, à lɛ́ zùzi lán yã pↄ́ bà à bè: Samuɛli! Samuɛli! Ben Samuɛli bè: Ǹ yã o Dii, mamↄma n zↄ̀bleri ma swã dↄ. ");
INSERT INTO bus_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Ben Dii bènɛ: Ǹ ma! Mɛ́ yã kɛ Isarailinↄ tɛ́, gbɛ̃ kɛ̀ à à baaru mà é kɛkɛ à swã wɛ̃mɛ. ");
INSERT INTO bus_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Gurↄ beeea mɛ́ àisi kɛ̀ má kpà Ɛli bɛdeenↄzi kɛ píngi zaa à daɛnaa ai à mìdɛnaa. ");
INSERT INTO bus_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Ma bènɛ mɛ́ tó yã gae wí à bɛdeenↄ musu ai gurↄ píngi à zaaa kɛ̀ à à yã dↄ̃ yãnzi. À nɛ́nↄ ń zĩnda kpɛ bↄ̀, ben èe gíńnɛro. ");
INSERT INTO bus_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Beee yãnzi ma la dà Ɛli bɛdeenↄ yã musu ma bè: Sa'ona ke gbadana é Ɛli bɛdeenↄ taari kɛ̃ḿma zikiro. ");
INSERT INTO bus_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Samuɛli dàɛ ai guu dↄ̀, ben à Dii kpɛ́ gbànↄ wɛ̃̀wɛ̃. À wɛ́ɛgupu kɛ̀ à è ona Ɛlinɛ vĩa vĩ. ");
INSERT INTO bus_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","Ben Ɛli à sìsi à bè: Samuɛli ma nɛ́! À wèàla à bè: Maɛ kɛ̀! ");
INSERT INTO bus_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Ben à à là à bè: À bènnɛ diamɛ? Ǹton yã pì utɛmɛro. Tó n yã kɛ̀ à ònnɛɛ ke ùtɛmɛ, Luda yã kɛnnɛ pãsĩpãsĩ. ");
INSERT INTO bus_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Ben Samuɛli yã pì tↄ̃kɛ̃̀nɛ píngi, èe à ke utɛnɛro. Ben Ɛli bè: Diin à ũ. Lán à kɛ̀nɛ maa nà à kɛ. ");
INSERT INTO bus_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Samuɛli e bíta kũu, bensↄ̃ Dii kúo. Èe tó yã kɛ̀ à ò lɛ̀ɛ pãro. ");
INSERT INTO bus_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Ben Isaraili kɛ̀ aↄ̃ↄ kú zaa Dani ai Bɛsɛbanↄↄ dↄ̃̀ ń píngi sa kɛ̀ Samuɛli nɛ́ Dii annabimɛ yãpura. ");
INSERT INTO bus_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Dii ègↄ̃ bↄↄ àgↄ̃ mↄↄ Samuɛlizi zaa Silo, guu kɛ̀ à a zĩnda ↄ̀dↄanɛn káaku. È yã onɛ, ben Isarailinↄↄ e à yã maa ń píngi. ");
INSERT INTO bus_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","Isarailinↄ bↄ̀ɛ aↄ̃ gàa Filisitininↄzi zĩ̀o. Aↄ̃ bùra kàɛ Ɛbɛnɛza, Filisitininↄ sↄ̃ↄ kú Afɛki. ");
INSERT INTO bus_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","Filisitininↄ zĩ̀'ↄↄ pòro aↄ̃ gàao Isarailinↄzi. Kɛ̀ zĩ̀ gbãa kũ̀, ben Filisitininↄ Isarailinↄ blè aↄ̃ ń dɛdɛ zĩ̀lan gwe lán gↄ̃ↄn bↄrↄ siigↄ̃ taka bà. ");
INSERT INTO bus_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","Kɛ̀ Isarailinↄ sù ń bùran, aↄ̃ gbɛ̃nsinↄ bè: Bↄ́yãnzi Dii tò Filisitininↄ wa ble zĩ̀o gbã̀azi? Wà gá wà Dii bà kuunawao àkpati sɛ́ zaa Silo wà suo àgↄ̃ kúwao, lɛ àgae wa bↄ wa ibɛɛnↄ ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","Ben aↄ̃ gbɛ̃nↄ zĩ̀ Silo aↄ̃ gàa wà Dii bà kuunańyo àkpati sɛ̀ wà sùo. Àmbe Dii Zĩ̀kpɛde kíblekita ũ kɛrubunↄ dagura. Ɛli nɛ́ gↄ̃ↄn plaaanↄ Ɔfini kↄ̃n Finɛasio kú kↄ̃n àkpati pìo gwe. ");
INSERT INTO bus_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","Kɛ̀ wà kào Isarailinↄ bùran, aↄ̃ vĩ̀ kↄ̃n pↄnna wiiio ń píngi ai tↄↄtɛ nìgã. ");
INSERT INTO bus_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","Kɛ̀ Filisitininↄ wiii pì mà, aↄ̃ bè: Bↄ́ wii gbãaa bé à dↄ Eberunↄ bùran lɛɛ? Kɛ̀ aↄ̃ dↄ̃̀ Dii àkpati bé à pìta ń bùran, ");
INSERT INTO bus_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","vĩa ń kũ aↄ̃ bè: Tãa ke pìta ń bùrammɛ. Yã gìwao sa! Yã beee taka e kɛ zikiro. ");
INSERT INTO bus_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","Yã gìwao! Dé bé eé wa bↄ tãa gbãadee pìnↄ ↄzĩi? Tãa pìnↄ bé wà yã gàɛ Igipitinↄnɛ gbáan. ");
INSERT INTO bus_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","Wamↄwa Filisitininↄ wà swɛ̃̀ diɛ wà gↄ̃gbɛ̃kɛɛ kɛ. Tó wée kɛ lɛro, wé zↄ̀ ble Eberunↄnɛ lán aↄ̃ↄe bleewe nàmɛ. Wà gↄ̃gbɛ̃kɛɛ kɛ wà zĩ̀ káńyo. ");
INSERT INTO bus_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","Ben Filisitininↄ fɛ̀ɛ Isarailinↄzi kↄ̃n zĩ̀o aↄ̃ ń fu, ben aↄ̃ baade bàa lɛ̀ wà tà bɛ, zaakɛ aↄ̃ dɛdɛna kɛ̀ bíta. Filisitininↄ ń gbɛ̃ kɛ̀ aↄ̃ↄ tɛ́ kɛ̀sɛnↄ dɛ̀dɛ gↄ̃ↄn bↄrↄ baaakuri. ");
INSERT INTO bus_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","Aↄ̃ Luda àkpati sìḿma, ben wà Ɛli nɛ́ gↄ̃ↄn plaaanↄ Ɔfini kↄ̃n Finɛasio dɛ̀dɛ. ");
INSERT INTO bus_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","Bɛyãmi bori gbɛ̃ke bↄ̀ zĩ̀lan à bàa lɛ̀ à gàa Silo zĩ pìa. À a pↄ́kãsãanↄ gà à kɛ̃̀kɛ̃ à bùsu kù a mìa. ");
INSERT INTO bus_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","Kɛ̀ à kà, à Ɛli lè vɛ̃ɛna kìtaa zɛ́ saɛ, èe guu dãkpaa, zaakɛ à làakari kpaɛnaro Luda àkpati yãnzi. Kɛ̀ gbɛ̃ pì gɛ̃̀ wɛ́tɛn, à baaru kpà wɛ́tɛdeenↄnɛ, ben aↄ̃ↄe ↄ́ↄ dↄↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","Kɛ̀ Ɛli wiii pì mà à bè: Zↄka beee bↄ̀ mámɛ? Ben gbɛ̃ pì kɛ̀ kpakpaa à gá onɛ. ");
INSERT INTO bus_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","Ɛli zii kà wɛ̃̀ basↄↄro plaasai, à wɛ́ɛ gↄ̃̀ dãadãa, èe guu e dↄro. ");
INSERT INTO bus_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","Ben gbɛ̃ pì bènɛ: Tian ma bↄ zĩ̀lan, ma bↄ zaa gwe kↄ̃n bào gbã̀amɛ. Ben Ɛli à là à bè: Bↄ́ bé à kɛ̀ gwee, ma gbɛ̃? ");
INSERT INTO bus_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","Baarukpari pì wèàla à bè: Isarailinↄ bàa lɛ̀ Filisitininↄnɛ, ben Filisitininↄ ń dɛdɛ paripari. N nɛ́ gↄ̃ↄn plaaanↄ Ɔfini kↄ̃n Finɛasio gàga dↄ. Wà Luda àkpati sìḿma dↄ. ");
INSERT INTO bus_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","Kɛ̀ à Luda àkpati yã ò, Ɛli bↄ̀ a kìtan à lɛ̀ɛ a kpɛɛgãnda wɛ́tɛ bĩilɛ saɛ, ben à waa ɛ̀ à gà, zaakɛ à zi kũ̀, bensↄ̃ gbɛ̃ kãnamɛ. À dↄ̀ Isarailinↄnɛ aɛ ai wɛ̃̀ baplaa. ");
INSERT INTO bus_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","Ɛli nɛ́ Finɛasi naↄ̃ nↄ̀sina, à kà nɛ́'ina. Kɛ̀ à Luda àkpati sina baaru mà kↄ̃n a zã de ganao kↄ̃n a zã ganao, ben à kùɛ à nɛ́ ì, zaakɛ nↄ̀wãwãa fɛ̀ɛa. ");
INSERT INTO bus_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","Kɛ̀ èe gbãsĩ lɛɛ, gbɛ̃ kɛ̀ aↄ̃ à kũkũnanↄ bènɛ: Ǹton tó vĩa n kũro, zaakɛ n nɛ́ ì gↄ̃gbɛ̃ ũ. Mↄde èe weńlaro, èe ń yã daro. ");
INSERT INTO bus_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","Ben à tↄ́ kpà nɛ́ pìnɛ Ikabodu à bè: Isarailinↄ gakui kↄ̀ ɛ̀. Zaakɛ wà Luda àkpati sìḿma, bensↄ̃ à zã de kↄ̃n à zão gàga dↄ. ");
INSERT INTO bus_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","À bè: Isarailinↄ gakui kↄ̀ ɛ̀, zaakɛ wà Luda àkpati sìḿma. ");
INSERT INTO bus_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","Kɛ̀ Filisitininↄ Luda àkpati sì, aↄ̃ bↄ̀o Ɛbɛnɛza aↄ̃ tào Asadↄdi. ");
INSERT INTO bus_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","Ben aↄ̃ gɛ̃̀o ń tãa Dagↄni kpɛ́n aↄ̃ dìɛ à saɛ. ");
INSERT INTO bus_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","Kɛ̀ guu dↄ̀, Asadↄdideenↄ fɛ̀ɛ idɛ'idɛ, ben aↄ̃ↄ è Dagↄni lɛ̀ɛ tↄↄtɛ a puua Dii àkpati aɛ. Ben aↄ̃ Dagↄni sɛ̀ wà pɛ̀ɛ a gbɛ̀n. ");
INSERT INTO bus_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","Kɛ̀ guu dↄ̀ dↄ, aↄ̃ fɛ̀ɛ idɛ'idɛ, ben aↄ̃ↄ è Dagↄni lɛ̀ɛ tↄↄtɛ a puua dↄ Dii àkpati aɛ. À mì kↄ̃n à ↄↄnↄ wòkↄ̃rɛ kaɛna kpɛɛlɛ tintia. À gbãn gↄ̃̀ diɛna ado. ");
INSERT INTO bus_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","Beee yãnzi Dagↄni gbã̀gbãrinↄ kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄe gɛ̃ɛ à kpɛ́n Asadↄdinↄ è kɛ̀sɛ pɛ́ɛ à kpɛ́ kpɛɛlɛ tintiarozi ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","Dii ↄ tↄ̃̀ Asadↄdideenↄa à ń ásaru kɛ̀ à gbɛ̀nɛ kàńgu, Asadↄdi kↄ̃n a lakutunↄ píngi. ");
INSERT INTO bus_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","Kɛ̀ Asadↄdideenↄↄ è lɛ, aↄ̃ bè: Isarailinↄ tãa àkpati é e àgↄ̃ kúwao kɛ̀ dↄro, zaakɛ èe ↄ tↄ̃ↄwa kↄ̃n wa tãa Dagↄnio pãsĩpãsĩ. ");
INSERT INTO bus_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","Ben aↄ̃ gbɛ̃nↄ zĩ̀ aↄ̃ ń kínanↄ kàkↄ̃a ń píngi, ben aↄ̃ ń lá wà bè: Dian wé kɛ nà kↄ̃n Isarailinↄ tãa àkpatioee? Ben aↄ̃ bè: Wà gáo Gata. Ben aↄ̃ gàao. ");
INSERT INTO bus_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","Kɛ̀ aↄ̃ kào gwe, Dii ↄ tↄ̃̀ wɛ́tɛ gwe deenↄa dↄ, ben wɛ́tɛ pì lògo. Dii gagyãa kàńgu, gbɛ̀nɛ dàńla ń píngi nɛ́ féte gbɛ̃nsi. ");
INSERT INTO bus_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","Ben aↄ̃ gàa kↄ̃n Luda àkpati pìo Ɛkɛrↄnu. Kɛ̀ aↄ̃ↄe gɛ̃ɛo, wɛ́tɛ pì deenↄ wii lɛ̀ wà bè: Wà gɛ̃̀wazi kↄ̃n Isarailinↄ tãa àkpatio lɛ aↄ̃ wa dɛdɛ wa boriiamɛ. ");
INSERT INTO bus_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","Ben aↄ̃ gbɛ̃nↄ zĩ̀ aↄ̃ ń kínanↄ kàkↄ̃a ń píngi aↄ̃ bèńnɛ: À Isarailinↄ tãa àkpati sɛ́ à táo a gbɛ̀n, lɛ àton wa dɛdɛ wa boriiaro. Zaakɛ gagaa tò wɛ́tɛ pì lògo, Luda ↄ tↄ̃̀ḿma gwe maamaa. ");
INSERT INTO bus_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","Gbɛ̀nɛ kà gbɛ̃ kɛ̀ aↄ̃ↄe garoonↄn, ben wɛ́tɛ pì deenↄ wiii kà ludambɛ. ");
INSERT INTO bus_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","Dii àkpati kú Filisitininↄ bùsun ai mↄ swɛɛplaa, ");
INSERT INTO bus_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","ben aↄ̃ sa'orinↄ kↄ̃n màsokɛrinↄ kàkↄ̃a aↄ̃ ń lá wà bè: Dian wé kɛ nà kↄ̃n Dii àkpatioee? À owe lán wé kɛ nà wà táo à gbɛ̀n. ");
INSERT INTO bus_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","Ben aↄ̃ wèńla wà bè: Tó ée taa kↄ̃n Isarailinↄ tãa àkpatio, àton táo koriro. À à gba pↄ́ a taari yãnzi, é kɛ̃kↄ̃a, é yã kɛ̀ à tò èe ↄ goawaroo dↄ̃. ");
INSERT INTO bus_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","Ben aↄ̃ ń lá wà bè: Bↄ́n wé à gba wà táo wa taari yãnzii? Aↄ̃ wèńla wà bè: À vura pi lán gbɛ̀nɛ bà mɛ̀n sↄↄro kↄ̃n ɛ̃ɛnↄ dↄ mɛ̀n sↄↄro a kínanↄ pari lɛ́n, zaakɛ gyã dↄ̃nkↄ̃ pì a le kↄ̃n a kínanↄ a píngi. ");
INSERT INTO bus_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","À a gbɛ̀nɛnↄ taka pi kↄ̃n ɛ̃ɛ kɛ̀ aↄ̃ↄe wa bùsu yakaanↄ, à Isarailinↄ tãa kpe dao. Ke eé ↄ gowa kↄ̃n wa tãanↄ kↄ̃n wa bùsuo gwɛɛ? ");
INSERT INTO bus_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","Bↄ́yãnzin á yezi à swãgbãaa kɛ lán Igipitinↄ kↄ̃n Firi'aunao kɛ̀ nàee? Kɛ̀ à wɛ́ɛ tã̀ḿma ai aↄ̃ Isarailinↄ gbàrɛ aↄ̃ tà, à yã e dↄaguroo? ");
INSERT INTO bus_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","Tia sa à gá à zùgoro dufu kɛ, à mↄ́ kↄ̃n zù nɛ́dande mɛ̀n plaaa kɛ̀ wèe gbóngo dańnɛ zikiroonↄ. À góro pì dↄḿma, à ń nɛ́ kɛ̀ aↄ̃ↄ tɛ́ńzinↄ kɛ̃ḿma à táńyo ń kara guu. ");
INSERT INTO bus_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","À Dii àkpati sɛ́ à da góro pì guu, à vura pↄ́ kɛ̀ ée kpãsãa a taari yãnzinↄ ká batan à diɛ àkpati pì saɛ, à zùnↄ da zɛ́n aↄ̃ gáo ");
INSERT INTO bus_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","àgↄ̃ gwaa. Tó àkpati pì a bùsu zɛ́ sɛ̀ èe gaa Bɛsɛmɛsi kpa, ɛ̃ndɛ̃ àmbe à kisia bíta pì zĩ̀wa. Tó èe zɛ́ sɛ́ gwe kpa sↄ̃ro, wégↄ̃ dↄ̃ kɛ̀ àmbe à ↄ tↄ̃̀waro, yã bé à sù lɛ. ");
INSERT INTO bus_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","Ben aↄ̃ↄ kɛ̀ lɛ, aↄ̃ góro dↄ̀ zù nɛ́dande mɛ̀n plaaanↄa aↄ̃ ń nɛ́nↄ kà kara guu, ");
INSERT INTO bus_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","ben aↄ̃ Dii àkpati dà góro pì guu kↄ̃n bata kɛ̀ vura ɛ̃ɛnↄ kↄ̃n gbɛ̀nɛ takanↄↄ kú à guuo. ");
INSERT INTO bus_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","Ben zù pìnↄ zɛ́ sɛ̀ súusu aↄ̃ aɛ dↄ Bɛsɛmɛsi zɛ́a, aↄ̃ↄe gaa aↄ̃ↄe ↄ́ↄ dↄↄ, aↄ̃ↄe liɛ ↄplazi ke ↄzɛziro. Filisitininↄ kínanↄↄ tɛ́ ń kpɛɛ ai Bɛsɛmɛsi bùsu lɛ́zɛkiin. ");
INSERT INTO bus_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","Bɛsɛmɛsideenↄↄ e pↄ́wɛɛ kɛkɛɛ guzurɛn. Kɛ̀ aↄ̃ wɛ́ɛ sɛ̀ musu, aↄ̃ àkpati pì è, ben aↄ̃ pↄↄ kɛ̀ nna kↄ̃n à enao. ");
INSERT INTO bus_vpl VALUES ("S16_14","010_6_14","1SA","6","14","15","Kɛ̀ góro pì kà Bɛsɛmɛsi gbɛ̃ Yↄsua búgbɛa, ben à zɛ̀ gbɛ̀ gbɛ̃̀ntɛ̃ ke saɛ gwe. Ben Levinↄ Dii àkpati pì bↄ̀ kↄ̃n bata kɛ̀ vura pↄ́nↄↄ kú à guuo, aↄ̃ↄ kàɛ gbɛ̀ gbɛ̃̀ntɛ̃ pìa. Ben Bɛsɛmɛsideenↄ góro pì lí zↄ̃̀zↄ̃kↄ̃rɛ yàka ũ, aↄ̃ sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ ò Diia kↄ̃n zù pìnↄ. Zĩ beeea aↄ̃ sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũnↄ ò Diia kↄ̃n sa'opↄ pãndenↄ. ");
INSERT INTO bus_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","Filisitininↄ kína gↄ̃ↄn sↄↄroonↄ yã pì è, ben aↄ̃ ɛ̀ara wà tà Ɛkɛrↄnu zĩ beee zĩ. ");
INSERT INTO bus_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","Vura gbɛ̀nɛ kɛ̀ Filisitininↄↄ kpã̀sã Diinɛ ń taari yãnzinↄn yɛ̀: Asadↄdi pↄ́ mɛ̀n do, Gaza pↄ́ mɛ̀n do, Asakɛlↄni pↄ́ mɛ̀n do, Gata pↄ́ mɛ̀n do, Ɛkɛrↄnu pↄ́ mɛ̀n do. ");
INSERT INTO bus_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","Vura ɛ̃ɛnↄↄ kuu dↄ Filisitini mɛɛwi pìnↄ pari lɛ́n, aↄ̃ kína gↄ̃ↄn sↄↄroonↄ pↄ́ ũ. Aↄ̃ mɛɛwi bĩidee pìnↄ baade kↄ̃n a lakutunↄ. Gbɛ̀ gbɛ̃̀ntɛ̃ kɛ̀ wà Dii àkpati dìɛa Bɛsɛmɛsi gbɛ̃ Yↄsua búgbɛa pìn sèeda ũ ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","Ben Dii Bɛsɛmɛside kenↄ dɛ̀dɛ, kɛ̀ aↄ̃ a àkpati guu gwà yãnzi. À ń dɛdɛ gↄ̃ↄn baaagↄ̃ akurimɛ, ben wà sósobi ↄ́ↄ dↄ̀, kɛ̀ Dii kaatɛ bíta kpàńzi yãnzi. ");
INSERT INTO bus_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","Ben Bɛsɛmɛsideenↄ bè: Dé bé eé fↄ̃ à zɛ Dii Luda kɛ̀ kú adona pì aɛɛ? Wé àkpati pì kpãsã dénↄ kiia saa? ");
INSERT INTO bus_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","Ben aↄ̃ gbɛ̃nↄ zĩ̀ Kiriayarimudeenↄa aↄ̃ bè: Filisitininↄ sù kↄ̃n Dii àkpatio. À mↄ́ à sɛ́ à táo a kiia. ");
INSERT INTO bus_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","Ben Kiriayarimudeenↄ mↄ̀ wà Dii àkpati pì sɛ̀ aↄ̃ tào Abinadabu bɛ sĩ̀sĩ musu. Ben aↄ̃ à nɛ́ Ɛlɛaza dìɛ à dãkpari ũ. ");
INSERT INTO bus_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","Àkpati pì kú Kiriayarimu à gì kɛ̀, à kɛ̀ gwe wɛ̃̀ baro. Isarailinↄↄ e wii pɛɛ Diizi ń píngi, aↄ̃ↄe à kii wɛtɛɛ. ");
INSERT INTO bus_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","Ben Samuɛli bè Isarailinↄnɛ ń píngi: Tó a aɛ dↄ̀ Diia kↄ̃n nↄ̀sɛo do, à bori zĩ̀tↄnↄ tãanↄ kↄ̃n Asatorɛnↄ bↄɛ a tɛ́, à a zĩnda kpá Diia àgↄ̃ dↄↄzi ado, eé a bↄ Filisitininↄ ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","Ben Isarailinↄ Baalinↄ kↄ̃n Asatorɛnↄ bↄ̀ɛ ń tɛ́, aↄ̃ↄe dↄↄ Diizi ado. ");
INSERT INTO bus_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","Ben Samuɛli bè: a Isarailinↄ à kↄ̃ kakↄ̃a Mizipa a píngi, mɛ́ agbaa kpáare Diinɛ. ");
INSERT INTO bus_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","Kɛ̀ aↄ̃ kↄ̃ kàkↄ̃a gwe, ben aↄ̃ í tↄ̀ aↄ̃ↄ kwɛ̀ɛ Dii aɛ. Zĩ beeean aↄ̃ lɛ́ yì aↄ̃ bè: Wa durun kɛ̀ Diinɛ. Ben Samuɛli yã gↄ̃̀gↄ̃ Isarailinↄnɛ Mizipa gwe. ");
INSERT INTO bus_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","Kɛ̀ Filisitininↄↄ mà Isarailinↄ kↄ̃ kàkↄ̃a Mizipa, ben aↄ̃ kínanↄ gàa lɛ́ɛḿma. Kɛ̀ Isarailinↄↄ mà, vĩa ń kũ, ");
INSERT INTO bus_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","ben aↄ̃ bè Samuɛlinɛ: Ǹtongↄ̃ yĩtɛnaro! Ǹ wii pɛ́ Dii wa Ludazi lɛ à wa sí Filisitininↄa. ");
INSERT INTO bus_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","Ben Samuɛli sãnɛ yↄ̃miri sɛ̀ à sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ ò Diia, ben à wii pɛ̀zi Isarailinↄnɛ. Ben Dii sìo. ");
INSERT INTO bus_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","Kɛ̀ Samuɛli e saa pì oo, Filisitininↄↄ e mↄↄ Isarailinↄa kↄ̃n zĩ̀o. Zĩ beeean Dii tò la gbãaa pàta Filisitininↄa. Aↄ̃ bídi kɛ̀ wà lɛ̀kↄ̃a, ben Isarailinↄ ń ásaru kɛ̀. ");
INSERT INTO bus_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","Kɛ̀ Isarailinↄ bↄ̀ɛ Mizipa aↄ̃ pɛ̀ Filisitininↄa, aↄ̃ ń dɛdɛ aↄ̃ ń kpá ai Bɛtɛka. ");
INSERT INTO bus_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","Ben Samuɛli gbɛ̀ pɛ̀ɛ Mizipa kↄ̃n Sɛnio dagura à tↄ́ kpànɛ Ɛbɛnɛza, zaakɛ à bè: Dii bé à wa ĩan kà ai wa kao kɛ̀. ");
INSERT INTO bus_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","Lɛn aↄ̃ Filisitininↄ fù lɛ, ben aↄ̃ↄe fↄ̃ wà ɛ̀ara wà mↄ̀ńzi zĩ̀o ń bùsun dↄro. Dii ↄ gbãaa mↄ̀ Filisitininↄnɛ ai Samuɛli kuuna gurↄ zakan. ");
INSERT INTO bus_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","Wɛ́tɛ kɛ̀ Filisitininↄↄ sì Isarailinↄa yãanↄ ɛ̀ara à gↄ̃̀ ń pↄ́ ũ zaa Ɛkɛrↄnu ai à gàa pɛ́ Gataa. Isarailinↄ wɛ́tɛ pìnↄ kↄ̃n ń bùsunↄ sì Filisitininↄa píngi. Isarailinↄ kↄ̃n Amↄrinↄ sↄ̃ↄ kú kↄ̃o yãkete sai. ");
INSERT INTO bus_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","Samuɛli nɛ́ Isarailinↄ dↄn'aɛdeemɛ ai a kuuna gurↄ zakan. ");
INSERT INTO bus_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","Wɛ̃̀ kↄ̃n wɛ̃̀o ègↄ̃ gaa Bɛtɛli kↄ̃n Giligalao kↄ̃n Mizipao, è yã gↄ̃gↄ̃ Isarailinↄnɛ wɛ́tɛ pìnↄ guu. ");
INSERT INTO bus_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","Ben è ɛara à tá Rama, zaakɛ à bɛɛn gwe. È yã gↄ̃gↄ̃ Isarailinↄnɛ gwe dↄ. Gwen à Dii gbãgbãkii bòn. ");
INSERT INTO bus_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","Kɛ̀ Samuɛli zi kũ̀, à a nɛ́nↄ dìɛ Isarailinↄnɛ dↄn'aɛdeenↄ ũ. ");
INSERT INTO bus_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","À nɛ́gↄ̃gbɛ̃ káaku tↄ́n Yoɛli, à plaadee Abia. Aↄ̃mbe aↄ̃è yã gↄ̃gↄ̃ńnɛ Bɛsɛba. ");
INSERT INTO bus_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Mↄde à nɛ́ pìnↄↄ e tɛ́ à tuubaziro. Ɔↄyã ń swɛ̃̀ blè, aↄ̃è ↄdↄnkpɛɛgbaa sí, aↄ̃è yã gↄ̃gↄ̃ a zɛ́aro. ");
INSERT INTO bus_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Ben Isaraili gbɛ̃nsinↄ kↄ̃ kàkↄ̃a, aↄ̃ gàa wà Samuɛli lè Rama ");
INSERT INTO bus_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","aↄ̃ bè: Ǹ gwa, n zi kũ̀, ben n nɛ́nↄↄ tɛ́ n tuubaziro. Ǹ kína diɛwe sa lɛ àgↄ̃ dɛ wa dↄn'aɛdee ũ, lán bori píngi a pↄ́ vĩ nà. ");
INSERT INTO bus_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Kɛ̀ aↄ̃ bè à kí káńnɛ àgↄ̃ dɛ ń dↄn'aɛdee ũ, yã pì e kɛ Samuɛlinɛro, ben à wɛ́ɛ kɛ̀ Diia. ");
INSERT INTO bus_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Ben Dii bè Samuɛlinɛ: Ǹ gbɛ̃ pìnↄ yã ma, zaakɛ ḿbe aↄ̃ gìnziro. Mámbe aↄ̃ gìmazi lɛ màton kí bleńnɛro yãnzi. ");
INSERT INTO bus_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Lán aↄ̃ↄe kɛɛ nà zaa gurↄↄ kɛ̀ ma ń bↄɛ Igipiti ai gbã̀a, aↄ̃ pã kpàmazi aↄ̃ dↄ̀ tãanↄzi, lɛn aↄ̃ↄe kɛɛnnɛ lɛ dↄ. ");
INSERT INTO bus_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Ǹ ń yã ma sa, ǹ lɛ́ daḿma ǹ tó aↄ̃gↄ̃ dↄ̃ lán gbɛ̃ kɛ̀ eé kí bleńnɛ yãnↄ égↄ̃ dɛ nà. ");
INSERT INTO bus_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Ben Samuɛli Dii yã pì tↄ̃kɛ̃̀ gbɛ̃ kɛ̀ aↄ̃ↄe kína gbekaaanↄnɛ píngi ");
INSERT INTO bus_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","à bè: Lán gbɛ̃ kɛ̀ eé kí bleare yãnↄ égↄ̃ dɛ nàn yɛ̀. Eé a nɛ́gↄ̃gbɛ̃nↄ sí à ń diɛ a sↄ̃gorodeenↄ kↄ̃n a sↄ̃deenↄ ũmɛ. Aↄ̃égↄ̃ táa oo à sↄ̃goro aɛ kↄ̃n bào. ");
INSERT INTO bus_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Eé ń diɛ gↄ̃ↄn wàa sↄsↄↄro ke gↄ̃ↄn baplaa akurikurinↄ gbɛ̃nsinↄ ũ. Aↄ̃égↄ̃ à bú wiinɛ, aↄ̃égↄ̃ à pↄ́nↄ kɛkɛɛnɛ, aↄ̃égↄ̃ à zĩ̀kabↄnↄ piinɛ kↄ̃n à sↄ̃goro pↄ́nↄ. ");
INSERT INTO bus_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Eé a nɛ́nↄgbɛ̃nↄ sí à ń diɛ nↄ́sigũnnakɛrinↄ kↄ̃n pↄ́blekɛrinↄ kↄ̃n burɛdikɛrinↄ ũ. ");
INSERT INTO bus_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Eé a buraanↄ kↄ̃n a geepi búnↄ kↄ̃n a kùkpɛ maaanↄ síawa à kpá a ìbanↄa. ");
INSERT INTO bus_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Eé a blɛwɛɛ kↄ̃n a geepi bɛɛnↄ lɛo kuridee síawa à kpá a bɛgwarinↄ kↄ̃n a ìbanↄa. ");
INSERT INTO bus_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Eé a zↄ̀gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄ sí kↄ̃n a zù maaanↄ kↄ̃n a zaakinↄ àgↄ̃ a zĩnda zĩi kɛɛo. ");
INSERT INTO bus_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Eé a pↄ́kãdeenↄ lɛo kuridee síawa, apinↄ é gↄ̃ à zↄ̀nↄ ũ. ");
INSERT INTO bus_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Gurↄ beeea sa é wii pɛ́ Diizi gbɛ̃ kɛ̀ á sɛ̀ a kína ũu pì yãnzi, mↄde eé weala gurↄ beeea dↄro. ");
INSERT INTO bus_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Ben aↄ̃ gì Samuɛli yã mazi aↄ̃ bè: Auo! Wá yezi wàgↄ̃ kína vĩmɛ, ");
INSERT INTO bus_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","wégↄ̃ dɛ lán bori kpaaanↄ bà se. Wa kína bé eégae yã gↄ̃gↄ̃we, àmbe eégae dↄwe aɛ zĩ̀ guu. ");
INSERT INTO bus_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Kɛ̀ Samuɛli ń yã mà píngi, à gàa à gbã̀ Diinɛ. ");
INSERT INTO bus_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Ben Dii bènɛ: Ǹ ń yã ma, ǹ kína káńnɛ. Ben Samuɛli bè Isaraili pìnↄnɛ: A baade tá a wɛ́tɛ. ");
INSERT INTO bus_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Bɛyãmi bori kee kuu, à tↄ́n Kisi. Auzikideemɛ. Bɛyãmi borii bé à Afia ì, Afia Bekora ì, Bekora Zero ì, Zero Abiɛli ì, ben Abiɛli Kisi pì ì. ");
INSERT INTO bus_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","À nɛ́gↄ̃gbɛ̃ vĩ, à tↄ́n Solu. Gↄ̃kparɛ maaamɛ. À maa sáa kú Isarailinↄ tɛ́ro, aↄ̃ gbɛ̃ke gbã̀a e vĩ à gã̀nlaro. ");
INSERT INTO bus_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Kɛ̀ Kisi pì zaakinↄ sã̀sã, ben à bè a nɛ́ pìnɛ: Ǹ fɛɛ ǹ zĩkɛrinↄ mɛ̀n doo sɛ́ à gá zaaki pìnↄ wɛtɛ. ");
INSERT INTO bus_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","Ben aↄ̃ Ɛflaimu bùsu gusĩsĩdee pàra kↄ̃n Salisa bùsuo, aↄ̃ↄe ń ero. Ben aↄ̃ Salimu bùsu pàra, mↄde aↄ̃ↄ kú gwero. Ben aↄ̃ Bɛyãmi bùsu pàra, aↄ̃ↄe zaaki pìnↄ ero. ");
INSERT INTO bus_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","Kɛ̀ aↄ̃ kà Zufu bùsun, Solu bè zĩkɛri kɛ̀ aↄ̃ↄ tɛ́ lɛdoo pìnɛ: Ǹ mↄ́ wà ɛara. Tó wée táro, ma maree é bídi kɛ wa yãzi, eé zaakinↄ yã da dↄro. ");
INSERT INTO bus_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","Ben à wèàla: Ǹ ma! Luda gbɛ̃kee kú wɛ́tɛ kɛ̀ guu. À bɛ̀ɛ vĩ, yã kɛ̀ à ò bé è kɛ. Wà gá gwe. Ke eé zɛ́ kɛ̀ wé sɛ́ wà wa zaaki pìnↄ eo owe gwɛɛ. ");
INSERT INTO bus_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","Ben Solu wèàla à bè: Tó wée gaa, bↄ́n wé gáonɛ? Pↄ́ble kee e gↄ̃ wa bↄ̀kↄn dↄro. Wá pↄ́ke vĩ wà Luda gbɛ̃ pì gbaro. Ke bↄ́n wá vĩi? ");
INSERT INTO bus_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","Ben zĩkɛri pì ɛ̀ara à bè Solunɛ: Ǹ gwa! Má ↄↄ vĩ féte kɛ̀. Mɛ́ à gba, eé wa da zɛ́ kɛ̀ dɛ wà sɛ́a. ");
INSERT INTO bus_vpl VALUES ("S19_9","010_9_9","1SA","9","9","9","Isarailinↄ bùsun yã, tó gbɛ̃ e gaa yã gbeka Ludaa è be: Ǹ mↄ́ wà gá wɛ́ɛgupu'eri kiia. Zaakɛ gbɛ̃ kɛ̀ wè sísi gbã̀a annabi ũ, àmbe wè sísi yã wɛ́ɛgupu'eri ũ. ");
INSERT INTO bus_vpl VALUES ("S19_10","010_9_10","1SA","9","10","10","Ben Solu bè a zĩkɛrinɛ: N yã maaa ò. Wà gá. Ben aↄ̃ↄe gaa wɛ́tɛ kɛ̀ Luda gbɛ̃ pì kún-a. ");
INSERT INTO bus_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","Kɛ̀ aↄ̃ↄe wɛ́tɛ pì sĩ̀sĩ kũu, aↄ̃ dàkↄ̃rɛ kↄ̃n nↄkparɛnↄ, aↄ̃ↄe gaa í tↄ́. Ben aↄ̃ ń lá wà bè: Wɛ́ɛgupu'eri kú bɛↄ́? ");
INSERT INTO bus_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","Aↄ̃ wèńla wà bè: Eè, à kú aɛ gwe. À kɛ kpakpaa. Gbã̀an à sù, zaakɛ wà yezi wà saa o gbãgbãkiiamɛ. ");
INSERT INTO bus_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","Tó a gɛ̃ wɛ́tɛn, é à e ai àgↄ̃ gá pↄ́ ble gbãgbãkii pìa. Zaakɛ weé pↄ́ ble gĩaro, à gↄ̃̀ ai à mↄ́, àpi bé eé aubarika da sa'opↄbleen gĩa, gbasa gbɛ̃ kɛ̀ wà ń sísinↄ pↄ́ ble. Àgↄ̃ wãa, zaakɛ à egurↄ zakan yɛ̀. ");
INSERT INTO bus_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","Kɛ̀ aↄ̃ gɛ̃̀ wɛ́tɛ pì guu, ben aↄ̃ dàkↄ̃rɛ kↄ̃n Samuɛlio gↄ̃ↄ, à bↄ̀ èe gaa gbãgbãkii pìa. ");
INSERT INTO bus_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Ai Solu gↄ̃ gá mↄ́, Dii gĩakɛ à yã kɛ̀ dà Samuɛlinɛ a swãla à bè: ");
INSERT INTO bus_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","Zia mↄndaa'i mɛ́ Bɛyãmi bùsu gbɛ̃ zĩmma. Ǹ nↄ́si kúa ǹ à diɛ ma gbɛ̃ Isarailinↄ dↄn'aɛdee ũ. Eé ma gbɛ̃ pìnↄ bↄ Filisitininↄ ↄzĩ. Ma a gbɛ̃ pìnↄ wiii mà, ben ma ń wɛ̃nda gwà. ");
INSERT INTO bus_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Kɛ̀ Samuɛli Solu è, Dii bènɛ: Gbɛ̃ kɛ̀ ma à yã ònnɛɛ pìn gwe. Àmbe eé kí ble ma gbɛ̃nↄnɛ. ");
INSERT INTO bus_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","Ben Solu sↄ̃̀ Samuɛlizi wɛ́tɛ bĩilɛa à à là à bè: Wɛ́ɛgupu'eri bɛɛ kú mámɛ? Ǹ ↄdↄamɛ. ");
INSERT INTO bus_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","Ben Samuɛli wèàla à bè: Mámbe adee pì ũ. Ǹ dↄmɛ aɛ wà gá gbãgbãkiia, nɛ́ pↄ́ blemao gbã̀a. Zia kↄngↄ mɛ́ n nↄ̀sɛguuyã onnɛ píngi, gbasa mà n gbarɛ. ");
INSERT INTO bus_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","Ǹton n zaaki kɛ̀ sã̀sã zaa gurↄ aagↄ̃ↄnↄ damu kɛro, zaakɛ wà ń é. Dén Isarailinↄↄ yezi ń píngii, tó èe kɛ mpi kↄ̃n n de bɛdeenↄ baasiro? ");
INSERT INTO bus_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","Ben Solu bè: Bɛyãmi boriin ma ũroo? Ma borii bé à nɛ́ngo dɛ Isaraili boriinↄla ń píngi, ben ma danɛnↄ bé wà kɛ̃sãnańzi Bɛyãmi boriinↄ tɛ́. Bↄ́yãnzi nɛ́ɛ yã beee taka oomɛzi? ");
INSERT INTO bus_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","Ben Samuɛli Solu kↄ̃n a zĩkɛrio sɛ̀ à gɛ̃̀ńyo pↄ́blekpɛn, à vɛ̃ɛki maaa kpàḿma gbɛ̃ kɛ̀ wà ń sísinↄ tɛ́. Gbɛ̃ pìnↄ kà gↄ̃ↄn baaakuri taka bà. ");
INSERT INTO bus_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","Ben Samuɛli bè pↄ́blekɛrinɛ: Ǹ nↄ̀bↄ kɛ̀ má kpàmma ma bè ǹ à diɛkii kɛɛ pì sɛ́ ǹ mↄ́o. ");
INSERT INTO bus_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","Ben pↄ́blekɛri pì mↄ̀ kↄ̃n nↄ̀bↄ gbá pìo à dìɛ Solu aɛ. Ben Samuɛli bè: Pↄ́ kɛ̀ wà dìɛnnɛɛn yɛ̀. Ǹ só, zaakɛ wà dìɛnnɛ ai mↄndaa'i kↄ̃n gbɛ̃ kɛ̀ ma ń sísinↄ. Ben Solu pↄ́ blè kↄ̃n Samuɛlio zĩ beeea. ");
INSERT INTO bus_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","Kɛ̀ aↄ̃ pìta gbãgbãkii pìa, aↄ̃ gɛ̃̀ wɛ́tɛ guu, ben Samuɛli gàa à yã ò kↄ̃n Soluo a kpɛ́ musu. ");
INSERT INTO bus_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","Ben aↄ̃ ì gwe. Kɛ̀ guu yezi à dↄ, ben Samuɛli lɛ́ zù Soluzi kpɛ́ musu gwe à bè: Ǹ fɛɛ, mà gá zɛnnɛ. Kɛ̀ Solu fɛ̀ɛ, àpi kↄ̃n Samuɛlio aↄ̃ bↄ̀ bàazi ń plaaa. ");
INSERT INTO bus_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","Kɛ̀ aↄ̃ kà wɛ́tɛ kpɛɛ, ben Samuɛli bè Solunɛ: Ǹ o n zĩkɛrinɛ àgↄ̃ gaa, mpi ǹ zɛ gĩa lɛ mà yã kɛ̀ Dii ò onnɛ. ");
INSERT INTO bus_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Ben Samuɛli nↄ́si tùu sɛ̀ à nↄ́si kù Solunɛ a mìa, ben à lɛ́ pɛ̀a à bè: Dii bé à n diɛ dↄn'aɛdee ũ a gbɛ̃ Isarailinↄnɛ. Nɛ́ kí ble Dii gbɛ̃nↄnɛ ǹ ń bↄ ń ibɛɛ kɛ̀ aↄ̃ ligańzinↄ ↄzĩ. Sèeda kɛ̀ eé tó ǹ dↄ̃ kɛ̀ Dii bé à n diɛ a gbɛ̃nↄ dↄn'aɛdee ũun yɛ̀. ");
INSERT INTO bus_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","Tó wa kɛ̃kↄ̃a kɛ̀ tia, nɛ́ da gↄ̃ↄn plaaanↄlɛ Zɛlɛza, Rasɛli mira saɛ, Bɛyãmi bùsu lɛ́zɛkiia. Aↄ̃é bennɛ: Wà zaaki kɛ̀ n gaa wɛtɛɛnↄ è. Aↄ̃ yã n de kũna gbãa dↄro, n yã kã̀hãnn èe kɛɛ sa, èe bee dian é kɛ a nɛ́ yã musu nà? ");
INSERT INTO bus_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","Bↄna gwe, tó n gaa aɛ, tó n ka gbíi lí beee kiia zaa Tabo, gↄ̃ↄn aagↄ̃ↄ é danlɛ gwe dↄ, aↄ̃ↄe gaa Luda gbãgbã zaa Bɛtɛli. Aↄ̃ gbɛ̃ doo blènɛnↄ kũna mɛ̀n aagↄ̃, aↄ̃ gbɛ̃ doo burɛdi kũna mɛ̀n aagↄ̃, ben aↄ̃ gbɛ̃ doo geepiwɛ̃ kũna tùu do. ");
INSERT INTO bus_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","Aↄ̃é n aafia gbeka, aↄ̃é burɛdi mɛ̀n plaaa kpámma, nɛ́ sí. ");
INSERT INTO bus_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","Beee gbɛra tó n ka Luda sĩ̀sĩ kɛ̀ kú Gibɛa, guu kɛ̀ Filisitininↄ gudãkpakii kún, tó n ka kĩi kↄ̃n wɛ́tɛ pìo, nɛ́ kpákↄ̃a kↄ̃n annabinↄ aↄ̃ↄ tɛ́tɛkↄ̃zi, aↄ̃ↄe pitaa gbãgbãkiia. Wèe dↄↄńnɛ aɛ kↄ̃n kuntiginↄ kↄ̃n gã̀gãnↄ kↄ̃n kurenↄ kↄ̃n mↄrↄnↄ, aↄ̃ↄe annabikɛyã oo. ");
INSERT INTO bus_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","Dii Nini é summa, nɛ́ annabikɛyã ońyo, nɛ́ li gbɛ̃ dufu ũ. ");
INSERT INTO bus_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Tó sèeda beeenↄ kɛ̀ lɛ, ǹ yã kɛ̀ n à kɛna zɛ́ è kɛ, zaakɛ Ludaa kúnyo. ");
INSERT INTO bus_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","Ǹ dↄmɛ aɛ gana Giligala, mɛ́ n le gwe, mɛ́ sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ o kↄ̃n kɛnnakↄ̃o sa'opↄo. Ǹ ma dã gwe ai gurↄ swɛɛplaa, mɛ́ mↄ́ mà n le gwe, mɛ́ yã kɛ̀ nɛ́ kɛɛ onnɛ. ");
INSERT INTO bus_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Kɛ̀ Solu kpɛɛ lì Samuɛlinɛ, èe taa, Luda à nↄ̀sɛ lìɛnɛ, ben sèeda pìnↄ kɛ̀ zĩ beee zĩ píngi. ");
INSERT INTO bus_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","Kɛ̀ aↄ̃ kà Gibɛa, annabinↄ dààlɛ aↄ̃ↄ tɛ́tɛkↄ̃zi, ben Luda Nini sùa, èe annabikɛyã oońyo. ");
INSERT INTO bus_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Kɛ̀ gbɛ̃ kɛ̀ aↄ̃ↄ à dↄ̃ↄnↄ à è, èe annabikɛyã oo kↄ̃n annabinↄ, aↄ̃ kↄ̃ làla wà bè: Bↄ́ bé à Kisi nɛ́ lèee? Solu kú annabinↄ tɛ́mɛ see? ");
INSERT INTO bus_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","Ben Gibɛa gbɛ̃ke yã wèńla à bè: Gbɛ̃ kpaaanↄ denↄn dénↄ ũ sↄ̃ↄ? Ben à gↄ̃̀ pena pↄ́ ũ wè be: Solu kú annabinↄ tɛ́mɛ see? ");
INSERT INTO bus_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","Kɛ̀ Solu annabikɛyã ò à yã̀a, ben à gàa gbãgbãkii pìa. ");
INSERT INTO bus_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","Kɛ̀ Solu tà bɛ kↄ̃n a zĩkɛrio, à desɛ̃ ń lá à bè: A gaa mámɛ? Solu wèàla à bè: Wa gaa zaakinↄ wɛtɛmɛ. Kɛ̀ wée ń ero, ben wa gaa Samuɛli kiia. ");
INSERT INTO bus_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","Ben Solu desɛ̃ bènɛ: Yã kɛ̀ Samuɛli òaree tↄ̃kɛ̃mɛ. ");
INSERT INTO bus_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Ben Solu bè: À bèwe wà zaaki pìnↄ è. Mↄde èe kpata yã kɛ̀ Samuɛli ònɛ tↄ̃kɛ̃nɛro. ");
INSERT INTO bus_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Ben Samuɛli Isarailinↄ kàkↄ̃a Dii aɛ Mizipa. ");
INSERT INTO bus_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","À bèńnɛ: Dii a Luda bè, a a bↄɛ Igipiti, a a si Igipitinↄ kↄ̃n borii kɛ̀ aↄ̃ ↄ tↄ̃̀awaanↄ ↄzĩ ń píngi. ");
INSERT INTO bus_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Luda a bↄ a yã'ↄ̃ammanↄ kↄ̃n a nawɛ̃akɛnanↄ guu píngi, ben a gizi gbã̀a, a bènɛ à kí káare kpatan. Tↄ̀, à mↄ́ à zɛ Dii aɛ sa bori kↄ̃n boriio, ualɛ kↄ̃n ualɛo. ");
INSERT INTO bus_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Kɛ̀ Samuɛli mↄ̀ kↄ̃n Isaraili boriinↄ ń píngi, ben Bɛyãmi boriinↄ kàbankpɛ blè. ");
INSERT INTO bus_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Ben à mↄ̀ kↄ̃n Bɛyãmi boriinↄ ualɛ kↄ̃n ualɛo. Ben Matari ua kàbankpɛ blè. Uadee pìnↄ tɛ́ Kisi nɛ́ Solu bé à blè. Kɛ̀ wà à wɛ̀tɛ, wèe à ero. ");
INSERT INTO bus_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Ben wà ɛ̀ara wà Dii là dↄ wà bè: Gↄ̃gbɛ̃ pì mↄ̀ kɛ̀ kↄ̀ↄ́? Ben Dii bè: À utɛna asoonↄ dagura. ");
INSERT INTO bus_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Ben wà bàa lɛ̀ wà gàa wà à bↄ̀ wà sùo ń tɛ́. Kɛ̀ à zɛ̀ ń tɛ́, aↄ̃ píngi gbã̀a zɛ̀ à gã̀ lɛ́n. ");
INSERT INTO bus_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Ben Samuɛli bèńnɛ ń píngi: A gbɛ̃ kɛ̀ Dii sɛ̀ èↄ́? Gbɛ̃kee kuu lán à bà a tɛ́ro. Ben baade píngi wii lɛ̀ wà bè: Luda wa kína dↄ̃ kↄ̃n aafiao! ");
INSERT INTO bus_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","Ben Samuɛli kíblena zɛ́ bↄ̀kↄ̃tɛńnɛ, ben à kɛ̃̀ takadan à dìɛ Dii kpɛ́n. Ben à ń gbáɛ, baade tà a bɛ. ");
INSERT INTO bus_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","Solu sↄ̃ tà a bɛ zaa Gibɛa. Gↄ̃ wↄ́rↄngↄdee kɛ̀ Luda zĩi kɛ̀ ń swɛ̃̀ guunↄ tɛ̀zi. ");
INSERT INTO bus_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","Ben gbɛ̃ pã kenↄ bè: Gbɛ̃ beee bé eé wa mì síↄ́? Ben aↄ̃ kya kàn, aↄ̃ↄe mↄ́nɛ kↄ̃n pↄ́keoro, mↄde Solu a yĩtɛɛ o. ");
INSERT INTO bus_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","Amↄni bori Naasa mↄ̀ kↄ̃n a zĩ̀kpɛɛnↄ, aↄ̃ bùra kàɛ Yabɛsi Giliada saɛ, ben Yabɛsideenↄ bè Naasanɛ: Ǹ lɛdolɛ kɛwao, wé mì siɛnnɛ. ");
INSERT INTO bus_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","Ben Naasa bèńnɛ: Tó ma a baade wɛ́ɛ ↄplakpapↄ bↄ̀bↄ, ben wí Isarailinↄ kũ̀ ń píngi, mɛ́ gbasa mà lɛdolɛ kɛao. ");
INSERT INTO bus_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","Ben Yabɛsi gbɛ̃nsinↄ bènɛ: Ǹ wa gba gurↄ swɛɛplaaa lɛ wà gbɛ̃nↄ zĩ Isarailinↄ bùsu guu píngi. Tó gbɛ̃kee kuu à wa mì síro, wé wa zĩnda kpámma. ");
INSERT INTO bus_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","Kɛ̀ zĩ̀ri pìnↄ kà Solu bɛ zaa Gibɛa, aↄ̃ yã pì òńnɛ, ben wà sósobi ↄ́ↄ dↄ̀. ");
INSERT INTO bus_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","Gurↄ beeea Solu e suu kↄ̃n buraao, à tɛ́ a zùnↄzi, ben à bè: Bↄ́ yã bé à mↄ̀, ben wèe ↄ́ↄ dↄↄ? Ben wà Yabɛsidee pìnↄ yã tↄ̃kɛ̃̀nɛ. ");
INSERT INTO bus_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","Kɛ̀ Solu yã pì mà, Luda Nini sùa, ben à pↄ fɛ̃̀ maamaa. ");
INSERT INTO bus_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","À zù sɛ̀ mɛ̀n plaa à dɛ̀ à zↄ̃̀zↄ̃kↄ̃rɛ, ben à gbɛ̃nↄ zĩ̀o Isarailinↄ bùsu guu píngi aↄ̃ bè: Lɛn weé kɛ gbɛ̃ kɛ̀ e tɛ́ Soluzi kↄ̃n Samuɛlioroo zùnↄnɛ lɛ. Ben vĩa ń kũ Dii yã musu, aↄ̃ bↄ̀ wà tɛ̀ńzi lɛdo ń píngi. ");
INSERT INTO bus_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","Solu ń náro zaa Bɛzɛki. Isarailinↄ kà gↄ̃ↄn bↄrↄ wàa do kpɛ́ basↄↄro. Yudanↄↄ kú ń tɛ́ gↄ̃ↄn bↄrↄ baaakuri. ");
INSERT INTO bus_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","Ben wà bè zĩ̀ri kɛ̀ aↄ̃ mↄ̀ pìnↄnɛ: À gá à o a gbɛ̃nↄnɛ, zia ai ↄfãntɛ̃ gↄ̃ gá gbã, wé ń mì sí. Kɛ̀ zĩ̀rinↄ tà, aↄ̃ yã pì baaru kpà Yabɛsideenↄnɛ, ben aↄ̃ pↄↄ kɛ̀ nna. ");
INSERT INTO bus_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","Aↄ̃ bè Amↄninↄnɛ: Wé wa zĩnda kpáawa zia, é a pↄyeziyã kɛwa. ");
INSERT INTO bus_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","Solu a gbɛ̃nↄ kpàatɛtɛ gãli aagↄ̃. Gudↄnaon aↄ̃ sì Amↄninↄn ń bùran aↄ̃ ń dɛdɛ ai ↄfãntɛ̃ gàa à fɛɛo. Ben gbɛ̃ kɛ̀ aↄ̃ gↄ̃̀nↄ fã̀akↄ̃a doodo. ");
INSERT INTO bus_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","Ben wà bè Samuɛlinɛ: Dénↄ bé wà bè Solu é kí bleweroo? À bↄɛńyo wà ń dɛdɛ. ");
INSERT INTO bus_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","Ben Solu bè: Weé gbɛ̃ke dɛ gbã̀aro, zaakɛ Dii Isarailinↄ mì sì gbã̀amɛ. ");
INSERT INTO bus_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","Ben Samuɛli bè gbɛ̃nↄnɛ: À mↄ́ wà gá Giligala wà ɛara wà Solu kpá kpatan gwe dↄ. ");
INSERT INTO bus_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","Ben aↄ̃ gàa Giligala ń píngi, aↄ̃ ɛ̀ara wà Solu kpà kpatan Dii aɛ gwe dↄ, aↄ̃ kɛnnakↄ̃o saa ò Diia, ben Solu kↄ̃n Isarailinↄ pↄnnaa kɛ̀ gwe ń píngi maamaa. ");
INSERT INTO bus_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","Samuɛli bè Isarailinↄnɛ ń píngi: Ma yã kɛ̀ á òmɛɛ mà píngi, ma kí kàare kpatan. ");
INSERT INTO bus_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","Àpi bé eé dↄare aɛ sa. Mapi sↄ̃ ma zi kũ̀, ma mìkã pura kũ̀ ben ma nɛ́nↄↄ kúao. Ma dↄare aɛ zaa ma gↄ̃kparɛkɛgurↄ ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","Maɛ kɛ̀! À kɛ ma sèedadeenↄ ũ Dii kↄ̃n kí kɛ̀ à kpào aɛ. Ma zù ke zaaki sì a gbɛ̃keaↄ́? Ma a gbɛ̃ke blèↄ́? Ma wɛ́ɛ tã̀ a gbɛ̃keaↄ́? Ma ↄdↄnkpɛɛgbaa sì a gbɛ̃kea ai à ma wɛ́ɛ tàtaↄ́? Tó má kɛ̀ lɛ, mɛ́ à fĩa bonɛ. ");
INSERT INTO bus_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","Ben aↄ̃ wèàla wà bè: Nɛ́ɛ wa blero, nɛ́ɛ wɛ́ɛ tãwaro, nɛ́ɛ pↄ́ke sí wa gbɛ̃kearo. ");
INSERT INTO bus_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","Samuɛli bèńnɛ dↄ: Dii kↄ̃n kí kɛ̀ à kàon a sèedadeenↄ ũ gbã̀a, kɛ̀ ée taari emaro. Aↄ̃ bè: Dii bé wa sèedadee ũ. ");
INSERT INTO bus_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","Ben Samuɛli bèńnɛ: Dii bé à Musa kↄ̃n Arunao dìɛ, ben aↄ̃ bↄ̀ kↄ̃n a dezinↄo Igipiti. ");
INSERT INTO bus_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","À zɛ tɛɛɛ Dii aɛ, mɛ́ yã maaa kɛ̀ à kɛ̀are kↄ̃n a dezinↄ tↄ̃kɛ̃are. ");
INSERT INTO bus_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","Yakubunↄ gana Igipiti gbɛra a dezinↄ wii pɛ̀ Diizi, ben à Musa kↄ̃n Arunao dìɛ, aↄ̃ ń bↄ́ɛ Igipiti, ben aↄ̃ ń káɛ bùsu kɛ̀kiin. ");
INSERT INTO bus_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","Kɛ̀ Dii ń Luda yã sã̀ńgu yãnzi, ben à ń kpá Azo zĩ̀kpɛɛnↄ gbɛ̃nsi Siseraa kↄ̃n Filisitininↄ kↄ̃n Mↄabunↄ kío, aↄ̃ↄe zĩ̀ kaańyo. ");
INSERT INTO bus_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","Ben aↄ̃ wii pɛ̀ Diizi wà bè: Wa durun kɛ̀ wa pã kpànzi wa dↄ̀ Baalinↄzi kↄ̃n Asatorɛnↄ. Ǹ wa bↄ wa ibɛɛnↄ ↄzĩ sa, wégↄ̃ dↄↄnzi. ");
INSERT INTO bus_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","Ben Dii Gidiↄn dìɛ kↄ̃n Barakio kↄ̃n Yɛfɛtao kↄ̃n Samusĩo aↄ̃ a bↄ a ibɛɛ pìnↄ ↄzĩ baama píngi, ben a gↄ̃ kaɛna aafia. ");
INSERT INTO bus_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","Kɛ̀ á è Amↄni kí Naasa e mↄↄ lɛ́ɛawa, baa kɛ̀ Dii a Ludan a kína ũ, a bèmɛ: Lɛnlo! Kín á yezi! ");
INSERT INTO bus_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","Tia la kína kɛ̀ á gbèka á sɛ̀n yɛ̀, àɛ kɛ̀ Dii à dìɛare. ");
INSERT INTO bus_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","Tó á Dii vĩa vĩ ben ée dↄↄzi, tó ée à yã maa ben ée bↄ à yã kpɛɛro, tó apinↄ kↄ̃n gbɛ̃ kɛ̀ èe kí bleeareeo tɛ́ Dii a Ludazi, égↄ̃ aafia. ");
INSERT INTO bus_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","Tó ée Dii yã ma sↄ̃ro, ben a bↄ à yã kpɛɛ, eé ↄ tↄ̃awamɛ lán à kɛ̀ a dezinↄnɛ nà. ");
INSERT INTO bus_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","À zɛ à yã bíta kɛ̀ Dii é kɛaree e. ");
INSERT INTO bus_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","Ésekɛ̃gurↄↄn wá kún kɛ̀roo? Mɛ́ Dii sísi, eé tó lou vĩ à ma, égↄ̃ dↄ̃ kɛ̀ a kína gbekana kɛ̀ Diinɛ zaa maamaa. ");
INSERT INTO bus_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","Ben Samuɛli Dii sìsi, ben Dii tò lou vĩ̀ à mà zĩ beeea. Ben baade píngi vĩa kɛ̀ Diinɛ kↄ̃n Samuɛlio maamaa. ");
INSERT INTO bus_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","Ben aↄ̃ bènɛ: Ǹ wɛ́ɛ kɛwe Dii n Ludaa lɛ wapinↄ n zↄ̀blerinↄ tón gagaro. Wa yã zaaa kà wa durunnↄla, kɛ̀ wa kína gbèka. ");
INSERT INTO bus_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","Samuɛli bèńnɛ: Àton tó vĩa a kũro. A yã zaaa pì kɛ̀ píngimɛ, mↄde àton kɛ̃ Diiaro. Àgↄ̃ dↄↄzi kↄ̃n nↄ̀sɛo do. ");
INSERT INTO bus_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","Àton kɛ̃a à tɛ́ pↄ́ ginanↄziro. Aↄ̃ↄ àre vĩro, aↄ̃é fↄ̃ wà gbɛ̃ bↄro, zaakɛ pↄ́ pãanↄmɛ. ");
INSERT INTO bus_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","Dii é a gbɛ̃nↄ zĩnnaro a zĩnda tↄ́ bíta yãnzi, zaakɛ à kɛ̀nɛ à a kɛ a gbɛ̃nↄ ũ. ");
INSERT INTO bus_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","Mapi sↄ̃, Dii tón tó mà durun kɛare mà aduakɛnaare tóro. Mɛ́ zɛ́ maaa kɛ̀ dɛ à sɛ́ ↄdↄaare. ");
INSERT INTO bus_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","À vĩa kɛ Diinɛ, àgↄ̃ dↄↄzi kↄ̃n náanɛo kↄ̃n nↄ̀sɛo do. À laasuu lɛ́ yã bíta kɛ̀ à kɛ̀areenↄa. ");
INSERT INTO bus_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","Tó a gi a tɛ à zaaazi, apinↄ kↄ̃n a kínao, weé a kaatɛ a píngi. ");
INSERT INTO bus_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","Kɛ̀ Solu kí blè Isarailinↄnɛ wɛ̃̀ plaa, ");
INSERT INTO bus_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","à ń zĩ̀karinↄ sɛ̀ gↄ̃ↄn bↄrↄ aagↄ̃. Gↄ̃ↄn bↄrↄ plaaa kúo Mikimasa kↄ̃n Bɛtɛli gusĩsĩdeeo. Gↄ̃ↄn bↄrↄ doo kú kↄ̃n à nɛ́ Yonatão Gibɛa, Bɛyãmi bùsun. Ben à gbɛ̃ kpaaanↄ gbàrɛ, baade tà a bɛ. ");
INSERT INTO bus_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","Yonatã lɛ̀ɛ Filisitini gudãkpakii kɛ̀ kú Gɛbaa, ben Filisitininↄ à baaru mà. Ben Solu zĩ̀ kuu pɛ̀ Isarailinↄ bùsu gu píngia à bè Eberunↄ ma! ");
INSERT INTO bus_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","Ben Isarailinↄↄ mà ń píngi wà bè, Solu lɛ̀ɛ Filisitini gudãkpakiia, ben Filisitininↄ Isarailinↄ kyãkyãma bò. Ben wà Isarailinↄ sìsi, aↄ̃ mↄ̀ wà nà Solua Giligala. ");
INSERT INTO bus_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","Ben Filisitininↄ kↄ̃ kàkↄ̃a aↄ̃ zĩ̀ ká kↄ̃n Isarailinↄ. Aↄ̃ sↄ̃goronↄ kà bↄrↄ baaakuri, aↄ̃ sↄ̃gorodeenↄ kà bↄrↄ swɛɛdo, ben aↄ̃ kɛ̀sɛdeenↄↄ pari lán ísialɛ bùsu'ãatɛ̃ bà. Ben aↄ̃ fɛ̀ɛ wà gàa wà bùra kàɛ Mikimasa, Bɛtavɛ̃ ↄfãntɛ̃bↄɛ kpa. ");
INSERT INTO bus_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","Kɛ̀ Isarailinↄↄ è wà kú nawɛ̃a guu wèe naakↄ̃rɛḿma, ben aↄ̃ ùtɛ gbɛ̀wɛɛnↄ guu kↄ̃n dàkonↄ kↄ̃n gbɛ̀ sↄ̀tↄnↄ kↄ̃n kokotɛ̃wɛɛnↄ kↄ̃n lↄ̀gↄnↄo. ");
INSERT INTO bus_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","Aↄ̃ gbɛ̃kenↄ toke lɛ̀ wà bikũ̀ Yodaa ai Gada bùsun kↄ̃n Giliada bùsuo. Solu kpɛ́ kú Giligala, vĩa e gbɛ̃ kɛ̀ aↄ̃ↄ kúonↄ kũu maamaa. ");
INSERT INTO bus_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","À Samuɛli dã̀ gurↄ swɛɛplaa lán à dìɛnɛ nà. Kɛ̀ èe mↄ́ro, ben à gbɛ̃nↄↄ e fãakↄ̃a. ");
INSERT INTO bus_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","Ben Solu bè: À mↄ́mɛ kↄ̃n sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũo kↄ̃n sáabukpa sa'opↄnↄ. Ben à sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ pì ò. ");
INSERT INTO bus_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","Kɛ̀ à yã̀a, Samuɛli e kaa, ben Solu pì gàa à dààlɛ à gbãakɛ kpàzi. ");
INSERT INTO bus_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","Ben Samuɛli bènɛ: Bↄ́ yãn ń kɛ̀ gwee? Solu wèàla à bè: Kɛ̀ má è ma gbɛ̃nↄↄ e fãakↄ̃a, bensↄ̃ nɛ́ɛ mↄ́ gurↄↄ kɛ̀ ń dìɛaro yãnzimɛ. Filisitininↄↄ e kↄ̃ kaakↄ̃a Mikimasa, ");
INSERT INTO bus_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","ben ma bè, aↄ̃ton lɛ́ɛma Giligala kɛ̀ ai mà Dii gbeka. Ben ma saa pì ò tiasi. ");
INSERT INTO bus_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Ben Samuɛli bènɛ: N faasaiyã kɛ̀! Ń yã kɛ̀ Dii n Ludaa dìɛnnɛɛ kũnaro. Tó ń kũna yãmɛ, lɛ Dii é tó n boriinↄ gↄ̃ kpata blee Isarailinↄnɛ gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Tia la nɛ́ gì kɛ kpatanlo. Lán ń yã kɛ̀ Dii dìɛnnɛɛ kũnaro nà, à gĩakɛ à gbɛ̃ kɛ̀ à pↄↄ kɛ̀nɛ wɛ̀tɛ, à à dìɛ a gbɛ̃nↄ dↄn'aɛdee ũ. ");
INSERT INTO bus_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","Ben Samuɛli fɛ̀ɛ Giligala à gàa Gibɛa, Bɛyãmi bùsun. Ben Solu a zĩ̀kari kɛ̀ aↄ̃ↄ kúonↄ nàro, aↄ̃ kà gↄ̃ↄn wàa aagↄ̃ taka bà. ");
INSERT INTO bus_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","Solu kↄ̃n a nɛ́ Yonatão kↄ̃n a zĩ̀kari kɛ̀ aↄ̃ↄ kúńyonↄↄ kú Gibɛa, Filisitininↄ sↄ̃ bùra kàɛ Mikimasa. ");
INSERT INTO bus_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","Zĩ̀kari gãli aagↄ̃ↄnↄ bↄ̀ɛ Filisitininↄ bùran aↄ̃ gàa lɛ́ɛ Isarailinↄa. Gãli doo gàa Ɔfla kpa Suali bùsun, ");
INSERT INTO bus_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","gãli doo gàa Bɛtoroni kpa, ben à aagↄ̃dee gàa Isarailinↄ bùsu lɛ́n, sĩ̀sĩ kɛ̀ aɛdↄna kperanↄ guzurɛa kↄ̃n gbáao. ");
INSERT INTO bus_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","Sia kú Isarailinↄ bùsunlo, zaakɛ Filisitininↄ bè, Eberunↄ tón fɛ̃ɛda ke sári piro. ");
INSERT INTO bus_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","Filisitininↄ kiian Isarailinↄ è gá swaaronↄ kↄ̃n zùswaaronↄ kↄ̃n kpásanↄ kↄ̃n kontonↄ lɛ́ kɛkɛn píngi. ");
INSERT INTO bus_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","Swaaro kↄ̃n zùswaaro lɛ́kɛkɛna kà kondogi ↄↄ plaplaa, sakanↄ kↄ̃n kpásanↄ sↄ̃ kondogi ↄↄ doodo. ");
INSERT INTO bus_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","À yã bé à tò zĩ̀ pì kágurↄ Solu kↄ̃n Yonatão zĩ̀karinↄ fɛ̃ɛda ke sári kũnaro, sé Solu kↄ̃n Yonatão baasiro. ");
INSERT INTO bus_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","Filisitini gudãkparinↄ gàa Mikimasa gbɛ̀kotoon. ");
INSERT INTO bus_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","Zĩkea Solu nɛ́ Yonatã bè gↄ̃kparɛ kɛ̀ à a zĩ̀kapↄnↄ kũnanɛ: Ǹ mↄ́ wà gá Filisitini gudãkii kpa kãa. Èe o a denɛ sↄ̃ro. ");
INSERT INTO bus_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","Solu kú biisio lí gbáru zaa Migirↄnu, Gibɛa saɛ kↄ̃n zĩ̀kpɛɛnↄ gↄ̃ↄn wàa aagↄ̃. ");
INSERT INTO bus_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","Sa'ori Ahia kú ń tɛ́, à a dansiki dana. Ikabodu vĩ̀i Aitubu nɛ́mɛ. Aitubu pì nɛ́ Finɛasi nɛ́mɛ, Ɛli kɛ̀ dɛ Luda gbã̀gbãri ũ zaa Silo diomɛ. Aↄ̃ gbɛ̃kee dↄ̃ Yonatã gàa gukearo. ");
INSERT INTO bus_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","Gbɛ̀kotoo kɛ̀ Yonatã yezi à gɛ̃n à Filisitini gudãkparinↄ le, gbɛ̀ sↄ̃ntɛnↄ pɛɛpɛɛnan ↄplazi kↄ̃n ↄzɛzio. A doo tↄ́n Bozezi, a doo sↄ̃ Sɛnɛ. ");
INSERT INTO bus_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","A doo kú gu'igbãroon Mikimasa kpa, a doo sↄ̃ sↄↄmɛtɛ Gɛba kpa. ");
INSERT INTO bus_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","Ben Yonatã bè gↄ̃kparɛ pìnɛ: Ǹ mↄ́ wà gá gɛfↄↄde gudãkpari pìnↄ kiia. Ke Dii é wa ĩan ká gwɛɛ? Zaakɛ pↄ́ke é fↄ̃ à kpá Diinɛ à gí wà mì síziro, baa tó wá pari kesↄ̃ wá pariro. ");
INSERT INTO bus_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","Ben à zĩ̀kapↄnↄsɛri pì bènɛ: Lán à n pↄↄ gbà nà píngi dé, ǹ kɛ. Lán ń sɛ̀ nà, má kúnyo kↄ̃n nↄ̀sɛo domɛ. ");
INSERT INTO bus_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","Ben Yonatã bè: Tↄ̀, wà gáńzi wà wa zĩnda ↄdↄańnɛ. ");
INSERT INTO bus_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","Tó aↄ̃ bèwe wà zɛ wà ń dãmɛ, wé zɛ wa gbɛ̀n, wé gáńzi dↄro. ");
INSERT INTO bus_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","Tó aↄ̃ bè wà mↄ́mɛ sↄ̃, wé gáńzi, zaakɛ beee bé eégↄ̃ dɛ sèeda ũ kɛ̀ Dii ń náwe wa ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","Ben aↄ̃ ń zĩnda ↄ̀dↄa Filisitini gudãkpari pìnↄnɛ. Ben Filisitini pìnↄ bè: À gwa! Eberunↄↄ e bↄↄ wɛ̀ɛ kɛ̀ aↄ̃ ùtɛnnↄ guu. ");
INSERT INTO bus_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","Ben gudãkpari pìnↄ lɛ́ zù Yonatãzi kↄ̃n a zĩ̀kapↄnↄsɛrio wà bè: À mↄ́ wà yãke oare kɛ̀. Ben Yonatã bè a zĩ̀kapↄnↄsɛrinɛ: Ǹgↄ̃ tɛ́ ma kpɛɛ, zaakɛ Dii ń ná Isarailinↄnɛ ń ↄzĩmɛ. ");
INSERT INTO bus_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","Ben Yonatã e lↄↄtɛɛ kuɛna, ben à zĩ̀kapↄnↄsɛri tɛ́ à kpɛɛ. Kɛ̀ Yonatã ń nɛ́, ben à zĩ̀kapↄnↄsɛri pì ń dɛdɛ. ");
INSERT INTO bus_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","Lɛ́ɛmmana káaku pì guu Yonatã kↄ̃n a zĩ̀kapↄnↄsɛrio ń dɛdɛ gↄ̃ↄn baro taka bà. Guu pì kpã̀ngu kà lán bàlɛna basↄↄro taka bà. ");
INSERT INTO bus_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","Ben swɛ̃̀ kɛ̃̀ Filisitininↄn ń bùran kↄ̃n zĩ̀lan-o píngi. Vĩa ń zĩ̀kpɛɛnↄ kũ̀, gudãkparinↄ kↄ̃n gbɛ̃ kɛ̀ aↄ̃è gá lɛ́ɛ Isarailinↄanↄ ń píngi. Ben tↄↄtɛ nìgãnigã. Luda bé à tò swɛ̃̀ kɛ̃̀ńgu lɛ. ");
INSERT INTO bus_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","Kɛ̀ Solu gudãkpari kɛ̀ aↄ̃ↄ kúo Gibɛanↄↄ è Filisitini zĩ̀kpɛɛnↄ bàa lɛ̀ wèe fãakↄ̃a baama píngi, ");
INSERT INTO bus_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","ben Solu bè gbɛ̃ kɛ̀ aↄ̃ↄ kúaonↄnɛ: À wa gbɛ̃nↄ dↄdↄ à gwa, wé dↄ̃ gbɛ̃ kɛ̀ aↄ̃ bↄ̀ wa tɛ́. Kɛ̀ aↄ̃ↄ gwà, aↄ̃ↄ è Yonatã kↄ̃n a zĩ̀kapↄnↄsɛrio bé wà kú ń tɛ́ro. ");
INSERT INTO bus_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","Ben Solu bè Ahianɛ: Ǹ mↄ́ kↄ̃n n dansiki utao wà gbeka Diia. Zaakɛ zĩ beeea à sa'o'uta pì dana Isarailinↄ tɛ́ gwemɛ. ");
INSERT INTO bus_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","Gurↄↄ kɛ̀ Solu e yã oo sa'ori pìnɛ, zↄka kɛ̀ dↄ Filisitininↄ bùran kɛ̀kɛ èe kaara, ben Solu bènɛ à tó gwe. ");
INSERT INTO bus_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","Solu a zĩ̀kpɛɛnↄ kàkↄ̃a ń píngi, aↄ̃ gɛ̃̀ zĩ̀n, ben aↄ̃ↄ è swɛ̃̀ kɛ̃̀ Filisitininↄn maamaa, aↄ̃ↄe kↄ̃ ásaru kɛɛ fɛ̃ɛdaao. ");
INSERT INTO bus_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","Eberu kɛ̀ aↄ̃ vɛ̃̀ɛ Filisitininↄ tɛ́ yã kɛ̀ aↄ̃ mↄ̀ńyo ń bùra guunↄ ɛ̀ara wà nà ń gbɛ̃ kɛ̀ aↄ̃ↄ kú kↄ̃n Soluo kↄ̃n Yonatãoa. ");
INSERT INTO bus_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","Kɛ̀ Isaraili kɛ̀ aↄ̃ↄ utɛna Ɛflaimu bùsu gusĩsĩdeen gweenↄↄ mà Filisitininↄↄ e bàa lɛɛ, aↄ̃ nà ń gbɛ̃nↄa dↄ aↄ̃ pɛ̀ɛńzi zĩn. ");
INSERT INTO bus_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","Lɛn Dii Isarailinↄ bↄ̀ lɛ zĩ beeea, ben aↄ̃ zĩ̀ blè ai Bɛtavɛ̃. ");
INSERT INTO bus_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","Isarailinↄ nawɛ̃a kɛ̀ zĩ beeea, zaakɛ Solu lù sɛ̀ kↄ̃n Luda tↄ́o a zĩ̀kpɛɛnↄnɛ à bè: Ai uusiɛ gá kɛo, gbɛ̃ kɛ̀ pↄ́ blè ai màgↄ̃ gá gɛ̃ɛ bo ma ibɛɛnↄa, adee gↄ̃̀ láaripↄ ũmɛ. Ben aↄ̃ gbɛ̃kee e pↄ́ blero. ");
INSERT INTO bus_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","Zĩ̀kpɛɛnↄ sì lákpɛn ń píngi, ben aↄ̃ zↄ́'i è di guu pìn. ");
INSERT INTO bus_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","Kɛ̀ aↄ̃ sì lákpɛn lɛ, aↄ̃ↄ è zↄ́'i e bàa lɛɛ, mↄde aↄ̃ gbɛ̃kee e ↄ zↄ̃a à dà a lɛ́nlo, kɛ̀ aↄ̃ↄe vĩa kɛɛ ladana kɛ̀ Solu kɛ̀ yãnzi. ");
INSERT INTO bus_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","Yonatã sↄ̃ↄ e yã kɛ̀ a dee dìɛ a zĩ̀kpɛɛnↄnɛ maro, ben à a gò kɛ̀ à kũna zↄ̃̀ zↄ́sa pìa. À ↄ kɛ̀a à dà a lɛ́n, ben à wɛ́ɛ kɛ̃̀. ");
INSERT INTO bus_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","Ben zĩ̀kari ke bènɛ: N de lù sɛ̀ a zĩ̀kpɛɛnↄnɛ kↄ̃n Luda tↄ́o à bè, gbɛ̃ kɛ̀ pↄ́ blè gbã̀a, adee gↄ̃̀ láaripↄ ũmɛ. Beee yãnzin ń baade píngi mɛ̀ bùsazi. ");
INSERT INTO bus_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","Ben Yonatã bè: Ma dee e ĩa daḿmamɛ. Ǹ gwa lán ma wɛ́ɛ kɛ̃̀ nà, kɛ̀ ma zↄ́ pì mↄ̀sↄ féte yãnzi. ");
INSERT INTO bus_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","Tó gbɛ̃nↄ pↄ́ kɛ̀ aↄ̃ↄ sì ń ibɛɛnↄa blè gbã̀a yã dé, lɛ aↄ̃ Filisitininↄ dɛ̀dɛ dɛ beeela. ");
INSERT INTO bus_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","Zĩ beeean Isarailinↄ Filisitininↄ dɛ̀dɛ sɛna zaa Mikimasa ai Ayalↄni. Aↄ̃ kpàsa búgubugu, ");
INSERT INTO bus_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","ben aↄ̃ sì ń pↄ́kãdeenↄ tɛ́, aↄ̃ sãanↄ kↄ̃n zùnↄ kↄ̃n zùnɛnↄ kũ̀kũ aↄ̃ↄ dɛ̀dɛ gwe gↄ̃ↄ, aↄ̃ↄe soo kↄ̃n a aruo. ");
INSERT INTO bus_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","Ben wà à baaru kpà Solunɛ wà bè: Ǹ gwa! Wèe durun kɛɛ Diinɛ, wèe nↄ̀bↄ soo kↄ̃n à aruo. Ben Solu bè: A bↄ Dii yã kpɛɛ. À gbɛ̀ gbɛ̃̀ntɛ̃ gbegere pá à suomɛ kɛ̀ kpakpaa. ");
INSERT INTO bus_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","Ben à bè: À fãakↄ̃a ń tɛ́, à beńnɛ aↄ̃ baade mↄ́ ma kiia kↄ̃n a zùo ke a sãa, aↄ̃ kòto kpá gura kɛ̀ wà só. Àton durun kɛ Diinɛ à nↄ̀bↄ só kↄ̃n à aruoro. Ben baade mↄ̀ kↄ̃n a zùo gwãavĩ beeea, à à kòto kpàkpa gwe. ");
INSERT INTO bus_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","Solu Dii gbãgbãkii bò gwe. Sa'okii kɛ̀ à bò káakun gwe. ");
INSERT INTO bus_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","Ben Solu bè: Wà pɛ́ɛ Filisitininↄzi gwãavĩa wàgↄ̃ ń dɛdɛɛ ai guu gá dↄo. Wàton ń gbɛ̃ke tóro. Ben wà bènɛ: Ǹ kɛ lán à kɛ̀nnɛ maa nà. Ben sa'ori bè: À tó wà gbeka Ludaa kɛ̀ gĩa. ");
INSERT INTO bus_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","Ben Solu gbèka Ludaa: Wà pɛ́ɛ Filisitininↄzi, nɛ́ ń nawe wa ↄzĩↄ́? Ben èe weàla zĩ beee zĩro. ");
INSERT INTO bus_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","Ben Solu bè: a zĩ̀kpɛ gbɛ̃nsinↄ a píngi, à sↄ̃mazi kɛ̀, lɛ wà e wà dↄ̃ durun kɛ̀ wà kɛ̀ gbã̀a. ");
INSERT INTO bus_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","Kↄ̃n Dii Isarailinↄ Mìsiri tↄ́o, baa tó ma nɛ́ Yonatã bé à durun kɛ̀, séde à ga. Ben gbɛ̃kee e yã siàlaro. ");
INSERT INTO bus_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","Ben à bèńnɛ: À zɛ kpado kãa, mapi kↄ̃n ma nɛ́o wégↄ̃ kú kpado kɛ̀. Ben wà bènɛ: Ǹ kɛ lán à kɛ̀nnɛ maa nà. ");
INSERT INTO bus_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","Solu bè Dii Isarailinↄ Ludanɛ: Ǹ tó wà yãpuraa dↄ̃. Ben yã Yonatã kↄ̃n Soluo blè, ben parii mì bↄ̀ bàn. ");
INSERT INTO bus_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","Solu bè: À gbɛ̀ la mapi kↄ̃n ma nɛ́o musu. Kɛ̀ yã Yonatã blè, ");
INSERT INTO bus_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","ben Solu bènɛ: Ǹ yã kɛ̀ ń kɛ̀ omɛ. Ben Yonatã bènɛ: Ma gò lɛ́ sↄ̃ntɛn má zↄ̃̀ zↄ́a, féte má mↄ̀sↄ. Maɛ kɛ̀! Mà ga. ");
INSERT INTO bus_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","Ben Solu bè: Yonatã, tó nɛ́ɛ garo, Luda yã kɛmɛ pãsĩpãsĩ. ");
INSERT INTO bus_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","Ben wà bè Solunɛ: Yonatã gaↄ́! Àmↄ kɛ̀ tò wa zĩ̀ blèↄ́? Auo! Kↄ̃n Ludao wée we kɛ̀ baa à mìkã mɛ̀n doo lɛ́ɛ tↄↄtɛro, zaakɛ Luda dↄnlɛn à beee kɛ̀o gbã̀a. Lɛn wà Yonatã mì sì lɛ, èe garo. ");
INSERT INTO bus_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","Ben Solu kámma bò kↄ̃n pɛɛna Filisitininↄzio, ben Filisitininↄ tà ń bùsun. ");
INSERT INTO bus_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","Kɛ̀ Solu vɛ̃̀ɛ Isarailinↄ kpatan à yã̀a, à zĩ̀ kà kↄ̃n a ibɛɛnↄ gu píngia: Mↄabunↄ kↄ̃n Amↄninↄ kↄ̃n Ɛdↄmunↄ kↄ̃n Zoba kínanↄ kↄ̃n Filisitininↄo. Kpaa kɛ̀ à lìɛn píngi, è zĩ̀ bleḿmamɛ. ");
INSERT INTO bus_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","À wↄ́rↄngↄkɛ tↄ́ bↄ̀ à zĩ̀ blè Amalɛkinↄa, à Isarailinↄ sì ń wɛ́ɛtãmmarinↄa. ");
INSERT INTO bus_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","Yonatã kↄ̃n Isibosɛo kↄ̃n Malakisuaon Solu nɛ́gↄ̃gbɛ̃nↄ ũ. À nɛ́nↄgbɛ̃nↄ vĩ gↄ̃ↄn plaa. À káaku tↄ́n Mɛraba, à plaade tↄ́n Mikala. ");
INSERT INTO bus_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","À naↄ̃ tↄ́n Ainↄama, Aimaza nɛ́mɛ. À zĩ̀kpɛɛnↄ gbɛ̃nsi tↄ́n Abana. Solu pì dãaromɛ, à desɛ̃ Nɛrɛ nɛ́mɛ. ");
INSERT INTO bus_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","Solu de Kisi kↄ̃n Abana de Nɛrɛon Abiɛli nɛ́nↄ ũ. ");
INSERT INTO bus_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","Solu gurↄ ègↄ̃ pãsĩ kↄ̃n Filisitininↄo gurↄ píngi. Tó Solu gↄ̃sagbãa ke wↄ́rↄngↄdee è, è à sí à na a zĩ̀kpɛɛnↄamɛ. ");
INSERT INTO bus_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Samuɛli bè Solunɛ: Mámbe Dii ma zĩ, ben ma nↄ́si kùmma n kpatablena à gbɛ̃ Isarailinↄnɛ sèeda ũ. Tↄ̀! Ǹ swã kpá Dii yãzi sa. ");
INSERT INTO bus_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Dii Zĩ̀kpɛde bè, é gɛ̃ɛ bo Amalɛkinↄa yã kɛ̀ aↄ̃ↄ kɛ̀ Isarailinↄnɛ, kɛ̀ aↄ̃ zɛ́ zↄ̃̀ńnɛ ń bↄɛna Igipiti gbɛra yãnzi. ");
INSERT INTO bus_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Ǹ gá lɛ́ɛḿma sa, ǹ ń kaatɛ ń píngi. Ǹton ń gbɛ̃ke tóro. Ǹ ń dɛdɛ ń píngi, gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄ kↄ̃n nɛ́nↄ kↄ̃n nɛ́kpãntɛ̃nↄ kↄ̃n zùnↄ kↄ̃n sãanↄ kↄ̃n lakuminↄ kↄ̃n zaakinↄo. ");
INSERT INTO bus_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Ben Solu a gbɛ̃nↄ sìsi à ń kakↄ̃a Telaimu. À zĩ̀kpɛ kɛ̀sɛdeenↄ gↄ̃ↄn bↄrↄ wàa domɛ. Yudanↄↄ kuu dↄ gↄ̃ↄn bↄrↄ kuri. ");
INSERT INTO bus_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","Ben Solu gàa Amalɛkinↄ wɛ́tɛ, à nàɛ èe ń kpákpaa swawɛɛn. ");
INSERT INTO bus_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","Solu lɛ́kpãsã kɛ̀ Keninↄnɛ à bè: À bↄɛ Amalɛkinↄ tɛ́ lɛ màton a dɛdɛńyoro yãnzi, zaakɛ ámbe a yã maaa kɛ̀ Isarailinↄnɛ ń bↄɛna Igipiti gbɛra. Kɛ̀ Keninↄ bↄ̀ɛ Amalɛkinↄ tɛ́, ");
INSERT INTO bus_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","ben Solu gàa à lɛ̀ɛ Amalɛki pìnↄa sɛna zaa Avila ai à gàa pɛ́o Suru kɛ̀ kú Igipiti ↄfãntɛ̃bↄɛ kpaaa. ");
INSERT INTO bus_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","À Amalɛki kí Agaga kũ̀ bɛ̃ɛ, ben à à gbɛ̃nↄ dɛ̀dɛ kↄ̃n fɛ̃ɛdaao ń píngi. ");
INSERT INTO bus_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Solu kↄ̃n a zĩ̀kpɛɛnↄↄ e Agaga dɛro, bensↄ̃ aↄ̃ sã maaanↄ sɛ̀ɛ kↄ̃n zùnↄ kↄ̃n zùnɛ mɛ̀kpananↄ kↄ̃n sãnɛ bↄ̀rↄnↄ kↄ̃n pↄ́ maaanↄ píngi, aↄ̃ↄe we wà ń dɛdɛro. Pↄ́ ginanↄ kↄ̃n pↄ́ yãyãnanↄn aↄ̃ↄ dɛ̀dɛ píngi. ");
INSERT INTO bus_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Ben Dii yã sù Samuɛlia à bè: ");
INSERT INTO bus_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","Ma Solu kana kpatan tò ma nↄ̀sɛ yàka, zaakɛ à kpɛɛ lìmɛ. Lán má dànɛ nà, è kɛ lɛro. Yã pì dì Samuɛlia, ben à wii pɛ̀ Diizi ai guu gàa à dↄ̀o. ");
INSERT INTO bus_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Kɛ̀ Samuɛli fɛ̀ɛ kↄngↄ idɛ'idɛ, à gàa da Solulɛ, ben wà bènɛ: Solu gàa Kamɛli. À sèeda pɛ̀ɛ gwe a zĩnda dↄngupↄ ũ, ben à gɛ̃̀tɛ à tà Giligala. ");
INSERT INTO bus_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Kɛ̀ Samuɛli Solu lè, ben Solu bènɛ: Dii aubarika dangu! Má kɛ̀ lán Dii òmɛ nà. ");
INSERT INTO bus_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Ben Samuɛli à là à bè: Sã wiii kɛ̀ ma swã e maa dɛ diamɛ? Zù wiii kɛ̀ mɛ́ɛ maa bↄ̀ mámɛ? ");
INSERT INTO bus_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Ben Solu wèàla à bè: Amalɛkinↄ pↄ́nↄmɛ, zaakɛ wà ń sãanↄ kↄ̃n ń zù maaanↄ sɛ̀ɛ wà sùo wà saa oo Dii n Ludaamɛ. Wa ń kpaaanↄ dɛ̀dɛ. ");
INSERT INTO bus_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Ben Samuɛli bènɛ: Ǹ yĩtɛ lɛ, mɛ́ yã kɛ̀ Dii òmɛ gwãavĩa onnɛ. Ben Solu bè: Ǹ o. ");
INSERT INTO bus_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Ben Samuɛli bè: Kɛ̀ n n zĩnda féte bò yã, nɛ́ɛ gↄ̃ Isaraili boriinↄ dↄn'aɛdee ũroo? Dii n ka kpatan Isarailinↄ kína ũ, ");
INSERT INTO bus_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","ben à n zĩ bↄkↄ̃tɛ kɛare kɛ̀ à bè: Ǹ gá ǹ Amalɛkinↄ dɛdɛ, zaakɛ durunkɛrinↄmɛ. Ǹ gá ǹ zĩ̀ káńyo ai ǹ ń kaatɛ. ");
INSERT INTO bus_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","À kɛ̀ dia n gi Dii yã mazi, n lɛɛ ń pↄ́nↄa, n yã kɛ̀ Dii yeziroo kɛ̀? ");
INSERT INTO bus_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Ben Solu bènɛ: Ma Dii yã mà, ma bↄkↄ̃tɛ kɛ̀ à ma zĩ mà kɛɛ kɛ̀. Ma Amalɛkinↄ dɛ̀dɛ ń píngi, ben ma su kↄ̃n ń kí Agagao. ");
INSERT INTO bus_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Ben zĩ̀karinↄ sã maaanↄ kↄ̃n zù maaanↄ bↄ̀ pↄ́ kɛ̀ wà sɛ̀ɛ pìnↄ tɛ́, lɛ wà saa oo Dii n Ludaa zaa Giligala kɛ̀. ");
INSERT INTO bus_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Ben Samuɛli bè: Dii yã kũna maanɛ dɛ sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũla. Mìsiɛnanɛ dɛ sa'onala. À yãmana dɛ sa'ona kↄ̃n sãkaro mɛ̀kpanaola. ");
INSERT INTO bus_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Gina à yã mazi durun sɛ̃nkpɛ kↄ̃n màsokɛnaomɛ. Dↄkɛnao zaa sɛ̃nkpɛ kↄ̃n tãagbãgbãnaomɛ. Lán n gi Dii yã mazi nà, àpi gì n kíkɛɛzi se. ");
INSERT INTO bus_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Ben Solu bènɛ: Ma durun kɛ̀. Ma pã Dii yã kɛ̀ ń òmɛɛnɛ, zaakɛ ma vĩa kɛ̀ gbɛ̃nↄnɛ, ben ma ń yã mà. ");
INSERT INTO bus_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","Ǹ sùu kɛmao kↄ̃n ma durun pìo sa. Ǹ ɛara ǹ gámao lɛ mà e mà dↄnzi kɛ Diinɛ. ");
INSERT INTO bus_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","Ben Samuɛli bènɛ: Mɛ́ gányoro. N gi Dii yãzi, ben à gìnnɛ ǹgↄ̃ dɛ Isarailinↄ kína ũ. ");
INSERT INTO bus_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Kɛ̀ Samuɛli kpɛɛ lì, èe taa, ben Solu à kũ̀ a uta lɛ́a, ben à kɛ̃̀ à ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Ben Samuɛli bènɛ: Dii n bↄ Isarailinↄ kpatan zaa gbã̀a, ben à n gbɛ̃daaa kɛ̀ à maa dɛnlaa kàn. ");
INSERT INTO bus_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Isarailinↄ Luda Gakuide è ɛgɛɛ toro, è a laasuu liɛro, zaakɛ gbɛ̃nteenlo, gbasa à a laasuu liɛ. ");
INSERT INTO bus_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","Ben Solu bènɛ: Ma durun kɛ̀. Baa kↄ̃n beeeo n yã nna, ǹ ma kpe da Isaraili gbɛ̃nsinↄ kↄ̃n gbɛ̃ píngio aɛ. Ǹ gá zɛmɛ lɛ mà e mà dↄnzi kɛ Dii n Ludanɛ. ");
INSERT INTO bus_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","Ben Samuɛli ɛ̀ara à gàa à zɛ̀nɛ, ben Solu dↄnzi kɛ̀ Diinɛ. ");
INSERT INTO bus_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","Ben Samuɛli bè: À mↄ́ kↄ̃n Amalɛki kí Agagao. Kɛ̀ kína pì e mↄↄ, èe kpákpaa kɛ̀ yãkee kuuro, zaakɛ èe daa a bↄ gaa lɛ́zĩmɛ. ");
INSERT INTO bus_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","Ben Samuɛli bè: Lán n fɛ̃ɛdaa tò nↄgbɛ̃ paridee kòra a nɛ́zi nà, lɛn n da é kora a nɛ́zi lɛ se. Ben à Agaga zↄ̃̀zↄ̃kↄ̃rɛ Dii aɛ Giligala gwe. ");
INSERT INTO bus_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Ben à tà Rama. Solu sↄ̃ tà a bɛ Gibɛa. ");
INSERT INTO bus_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Baa kɛ̀ Solu kɛ̀ Samuɛlinɛ wɛ̃nda, Samuɛli e gá à wɛ́ɛ kpáɛzi dↄro ai à gàa gao, zaakɛ Dii pↄↄ yàka kɛ̀ à Solu kà Isarailinↄ kína ũ yãnzi. ");
INSERT INTO bus_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Dii bè Samuɛlinɛ: Nɛ́gↄ̃ ↄ́ↄ dↄↄ Solu yã musu ai bↄrɛmɛ? Ma ginɛ à kí ble Isarailinↄnɛ. Ǹ nↄ́si ká koban à pa ǹ da zɛ́n. Ma n zĩ Bɛtɛlɛmu gbɛ̃ Yɛsɛ kiia, zaakɛ à nɛ́nↄ doken má sɛ̀ à gↄ̃ kí ũ. ");
INSERT INTO bus_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Ben Samuɛli bè: Dian mɛ́ kɛ nà mà gá gwee? Tó Solu mà, eé ma dɛ. Ben Dii bènɛ: Ǹ zùnunu sɛ́ ǹ gáo ǹ be n mↄ ma gbãgbãmɛ. ");
INSERT INTO bus_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Ǹ Yɛsɛ sísi saa pì onaa, mɛ́ yã kɛ̀ nɛ́ kɛɛ onnɛ, nɛ́ nↄ́si kúmɛ gbɛ̃ kɛ̀ mɛ́ ↄdↄannɛɛ mìa. ");
INSERT INTO bus_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Samuɛli yã kɛ̀ Dii ònɛ kɛ̀. Kɛ̀ èe kaa Bɛtɛlɛmu, lakutu pì gbɛ̃nsinↄ gàa wà dààlɛ. Vĩa ń kũ, ben aↄ̃ à là wà bè: Aafian n mↄ kɛ̀ↄ́? ");
INSERT INTO bus_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","À bè: Aafiamɛ. Ma mↄ Dii gbãgbãmɛ. À gbãsĩ bↄ a zĩndan à gámao saa o. Ben à gbãsĩ bↄ̀ Yɛsɛn kↄ̃n a nɛ́gↄ̃gbɛ̃nↄ à ń sísi sa'onaa. ");
INSERT INTO bus_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Kɛ̀ aↄ̃ kà, Samuɛli Ɛliabu è, ben à laasuu lɛ̀ à bè: Gbɛ̃ kɛ̀ Dii sɛ̀ bé à zɛna à aɛ gwe. ");
INSERT INTO bus_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Ben Dii bènɛ: Ǹton à zɛna ke à gbã̀akɛɛ gwaro, ma gizimɛ. Mɛɛ̀ gbɛ̃ gwa lán gbɛ̃ntee è gwa nàro. Gbɛ̃ntee è gbɛ̃ gwa a mɛ̀amɛ, mapi sↄ̃, swɛ̃̀n mɛɛ̀ gwa. ");
INSERT INTO bus_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Ben Yɛsɛ Abinadabu sìsi, à mↄ̀ Samuɛli aɛ, ben à bè: Dii e gbɛ̃ kɛ̀kii sɛ́ro. ");
INSERT INTO bus_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Ben Yɛsɛ Sama sìsi, à mↄ̀ Samuɛli aɛ dↄ, ben à bè: Dii e gbɛ̃ kɛ̀kii sɛ́ro. ");
INSERT INTO bus_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Ben Yɛsɛ a nɛ́gↄ̃gbɛ̃ gↄ̃ↄn swɛɛplaaanↄ sìsi, aↄ̃ mↄ̀ Samuɛli aɛ, ben à bè: Dii e ń gbɛ̃ke sɛ́ro. ");
INSERT INTO bus_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Ben à Yɛsɛ là à bè: N gↄ̃kparɛnↄ lɛ́n yɛ̀ ń píngiↄ́? À wèàla à bè: Aↄ̃ gbɛ̃ zãadee bé à kú kɛ̀ro, èe sãa dãamɛ. Ben Samuɛli bènɛ: Ǹ gbɛ̃ zĩ wà à sísi. Wé pↄ́ke kɛro séto à sù. ");
INSERT INTO bus_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Ben à gbɛ̃ zĩ̀a, à mↄ̀. Nɛ́ pì nɛ́ gbɛ̃ tɛ̃aamɛ, à zɛna maa bensↄ̃ à uu kɛ̃kↄ̃ana. Ben Dii bè: Ǹ fɛɛ ǹ nↄ́si kú à mìa, zaakɛ àpin gwe. ");
INSERT INTO bus_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Ben Samuɛli koba pì sɛ̀ à nↄ́si kù à mìa à vĩ̀inↄ wáa. Zaa zĩ beeean Dii Nini sù Daudaa. Beee gbɛra Samuɛli ɛ̀ara à tà Rama. ");
INSERT INTO bus_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Dii Nini gò Solua, ben Dii tò zĩn pãsĩ sùa. ");
INSERT INTO bus_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","À ìbanↄ bènɛ: Ludaa tò zĩn pãsĩ e wɛ́ɛ tãamma. ");
INSERT INTO bus_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Kí, ǹ tó wamↄwa n ìbanↄ gbɛ̃ kɛ̀ mↄrↄlɛna dↄ̃ↄ wɛtɛ. Tó Ludaa tò zĩn pãsĩ pì sùmma, eégae mↄrↄ lɛ́nnɛ, ǹgae e ǹ kɛ sã̀ↄ. ");
INSERT INTO bus_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Ben à bè a ìbanↄnɛ. À gbɛ̃ kɛ̀ mↄrↄlɛna dↄ̃ maamaa wɛtɛ à mↄ́omɛ. ");
INSERT INTO bus_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","Ben à ìbanↄ doke bènɛ: Ma Bɛtɛlɛmu gbɛ̃ Yɛsɛ nɛ́ ke è, à mↄrↄlɛna dↄ̃. Zĩ̀kpɛ wↄ́rↄngↄdeemɛ, bensↄ̃ à yã'ona dↄ̃. Gↄ̃ maaamɛ, bensↄ̃ Dii kúo. ");
INSERT INTO bus_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","Ben Solu gbɛ̃nↄ zĩ̀ Yɛsɛa, aↄ̃ gàa wà bènɛ: Solu bè ǹ n nɛ́ Dauda kɛ̀ è sãanↄ dã gbarɛare. ");
INSERT INTO bus_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","Ben Yɛsɛ burɛdi dì zaakinɛ kↄ̃n geepiwɛ̃ɛo tùu do kↄ̃n blèkofĩinɛ bↄ̀rↄo, à a nɛ́ Dauda gbàrɛo Solua. ");
INSERT INTO bus_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","Kɛ̀ à kà Solu kiia, à gↄ̃̀ à zĩkɛri ũ. Solu yezi maamaa, ben à à dìɛ a zĩ̀kapↄnↄsɛrinↄ doke ũ. ");
INSERT INTO bus_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","Ben Solu gbɛ̃ zĩ̀ Yɛsɛa à bè: Ǹ tó Dauda gↄ̃ ma zĩkɛri ũ, zaakɛ à yã è kɛmɛ nna. ");
INSERT INTO bus_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","Tó Ludaa tò zĩn pì sù Solua, ben Dauda è a mↄrↄ sɛ́ àgↄ̃ lɛɛnɛ. Tó zĩn pì gòa, ben è kɛ sã̀ↄ, à su a làakaria. ");
INSERT INTO bus_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","Filisitininↄ ń zĩ̀kpɛɛnↄ kàkↄ̃a, aↄ̃ↄe zĩ̀ soru kɛɛ Soko zaa Yudanↄ bùsun, ben aↄ̃ bùra kàɛ Ɛfɛsi Damimu, Soko kↄ̃n Azekao dagura. ");
INSERT INTO bus_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","Solu kↄ̃n Isarailinↄ sↄ̃ kↄ̃ kàkↄ̃a aↄ̃ bùra kàɛ Ela gusararaan, aↄ̃ↄe soru kɛɛ aↄ̃ gá Filisitininↄzi zĩ̀o. ");
INSERT INTO bus_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","Filisitininↄↄ kú sĩ̀sĩa kãa kpa, Isarailinↄ sↄ̃ↄ kú sĩ̀sĩa kɛ̀ kpa, guzurɛ kú ń dagura. ");
INSERT INTO bus_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Ben Gata gↄ̃sagbãaa kɛ̀ wè sísi Gↄlaya bↄ̀ Filisitininↄ bùran. À gbã̀a kà gã̀sãsuu swɛɛdo. ");
INSERT INTO bus_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","À mↄ̀gotɛ̃ fùra kuna, à mↄ̀gotɛ̃ uta kɛ̀ dɛ lán kpↄ̀tɛɛ bà dana kɛ̀ à tìisi kà kiloo baaagↄ̃. ");
INSERT INTO bus_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","À mↄ̀gotɛ̃ sòkoto yina dↄ, bensↄ̃ à mↄ̀gotɛ̃ sári lɛ̀ɛtɛgɛɛ logona a kpɛɛ kpa. ");
INSERT INTO bus_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","À sári sↄ̃ntɛ kũna, à pá dɛ lán bisatãri àsa lí bà. À wɛ́ɛ tìisi kà kiloo swɛɛplaa. À sɛngbangosɛri tɛna à aɛ. ");
INSERT INTO bus_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Gↄlaya zɛ̀ à lɛ́ zù Isaraili zĩ̀kpɛɛnↄzi à bè: Bↄ́yãnzin a bↄɛ kↄ̃n zĩ̀ozi? Á dↄ̃ kɛ̀ Filisitinin ma ũroo? Amↄa sↄ̃, Solu zↄ̀nↄn a ũ. À gbɛ̃ke bↄ a tɛ́ à pita à mↄ́ ma kiia. ");
INSERT INTO bus_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Tó eé fↄ̃ à zĩ̀ kámao à ma dɛ, ma gbɛ̃nↄ é gↄ̃ a zↄ̀nↄ ũ. Tó mámbe ma à dɛ̀ sↄ̃, é gↄ̃ wa zↄ̀nↄ ũ, égↄ̃ zↄ̀ bleewe. ");
INSERT INTO bus_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Ben Filisitini pì ɛ̀ara à bè: Mɛ́ɛ kùsɛ biii Isaraili zĩ̀kpɛɛnↄa gbã̀a. À gbɛ̃ wɛtɛmɛ lɛ wà zĩ̀ ká lɛdo. ");
INSERT INTO bus_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Kɛ̀ Solu kↄ̃n Isarailinↄ à yã pì mà ń píngi, aↄ̃ bídi kɛ̀, swɛ̃̀ kɛ̃̀ńgu. ");
INSERT INTO bus_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","Dauda nɛ́ Ɛflata gbɛ̃ Yɛsɛ nɛ́mɛ. Yɛsɛ nɛ́ Bɛtɛlɛmu kɛ̀ kú Yudanↄ bùsun gbɛ̃mɛ. À nɛ́gↄ̃gbɛ̃nↄ ì gↄ̃ↄn sↄraagↄ̃. Solu gurↄ gbɛ̃ zikũnamɛ. ");
INSERT INTO bus_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","À nɛ́ gbãa gↄ̃ↄn aagↄ̃ↄnↄↄ kú zĩ̀lan kↄ̃n Soluo. À nɛ́gↄ̃gbɛ̃ káaku tↄ́n Ɛliabu, à plaade tↄ́n Abinadabu, à aagↄ̃de tↄ́n Sama. ");
INSERT INTO bus_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","Daudan Yɛsɛ nɛ́ zãadee ũ. À vĩ̀i pìnↄↄ tɛ́ Soluzi, ");
INSERT INTO bus_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","mↄde Dauda è gá Solu kiia à ɛara à su Bɛtɛlɛmu à a de sãanↄ dã. ");
INSERT INTO bus_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","Filisitini pì è bↄ à a zĩnda ↄdↄańnɛ kↄngↄ kↄ̃n uusiɛo ai gurↄ baplaa. ");
INSERT INTO bus_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","Zĩkea Yɛsɛ bè a nɛ́ Daudanɛ: Ǹ ése kpatana kpɛ̃ɛ doo kɛ̀ kↄ̃n burɛdi mɛ̀n kuri kɛ̀nↄ sɛ́ ǹ gáo n vĩ̀inↄnɛ kpakpaa ń bùran. ");
INSERT INTO bus_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","Ǹ gàsi mɛ̀n kuri kɛ̀nↄ sɛ́ ǹ kpá ń gãli gbɛ̃nsia. Ǹ gá ǹ ń gwa, tó aↄ̃ↄ aafia, ǹ su sèedao kɛ̀ aↄ̃ↄ kuu aafia. ");
INSERT INTO bus_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Aↄ̃ↄ kú kↄ̃n Soluo kↄ̃n Isarailinↄ píngi Ela guzurɛn, aↄ̃ↄe zĩ̀ kaa kↄ̃n Filisitininↄ. ");
INSERT INTO bus_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Dauda fɛ̀ɛ kↄngↄ idɛ'idɛ, à a sãanↄ tò kↄ̃n sãdãri pãndeo. À a asoo sɛ̀, ben à dà zɛ́n lán Yɛsɛ ònɛ nà. Kɛ̀ à kà zĩ̀kpɛɛnↄ bùran, à mↄ̀ à lè aↄ̃ↄe gaa zĩ̀lan, aↄ̃ↄe wii gbãaa lɛɛ. ");
INSERT INTO bus_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Isarailinↄ kↄ̃n Filisitininↄↄ e soru kɛɛ aↄ̃ aɛ dↄkↄ̃a. ");
INSERT INTO bus_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","Ben Dauda a asoo nà pↄ́dãkparinɛ a ↄzĩ, ben à bàa lɛ̀ à gàa zĩ̀lan. À a vĩ̀inↄ lè gwe, ben à ì kpàḿma. ");
INSERT INTO bus_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","Kɛ̀ èe yã oońyo, Filisitininↄ gↄ̃sagbãa Gↄlaya, Gata gbɛ̃ bↄ̀ Filisitini zĩ̀kpɛɛnↄ tɛ́, à ɛ̀ara à fɛ̀ɛ kↄ̃n a yã pìo. Dauda yã pì mà. ");
INSERT INTO bus_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Kɛ̀ Isarailinↄ à è, swɛ̃̀ kɛ̃̀ńgu, aↄ̃ lɛ̀kↄ̃a ń píngi. ");
INSERT INTO bus_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","Aↄ̃ↄe ookↄ̃nɛ wèe bee: Ée gↄ̃gbɛ̃ pì e à bↄ̀roo? Tó à bↄ̀, è kùsɛ biiwamɛ. Gbɛ̃ kɛ̀ à à dɛ̀, kína é adee gba auziki bíta, eé a nɛ́nↄgbɛ̃ kpáa dↄ nↄↄ ũ, bensↄ̃ à bɛdeenↄ é bɛ'ↄↄ kpá dↄro. ");
INSERT INTO bus_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Ben Dauda gbɛ̃ kɛ̀ aↄ̃ↄ zɛna a saɛnↄ là à bè: Bↄ́n weé kɛ gbɛ̃ kɛ̀ à Filisitini pì dɛ̀ à Isarailinↄ bↄ̀ wí guunɛ? Dén Filisitini gɛfↄↄdee pì ũ, gbasa àgↄ̃ Luda Wɛ̃̀ndide zĩ̀kpɛɛnↄ lɛ́ gwa yãzii? ");
INSERT INTO bus_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Ben wà bènɛ lán gbɛ̃nↄↄ e oo nà: Lɛn weé kɛ gbɛ̃ kɛ̀ à à dɛ̀nɛ lɛ. ");
INSERT INTO bus_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","Kɛ̀ à vĩ̀i gbɛ̃nside Ɛliabu mà Dauda e yã oo kↄ̃n gbɛ̃nↄ, à pↄ fɛ̃̀zi à bè: À kɛ̀ dia n mↄ kɛ̀? Dén n sã féte kɛ̀gweenↄ tònɛ gbáan? Má n wada kↄ̃n n nↄ̀sɛ zaaao dↄ̃. N mↄ zĩ̀ gwamɛ. ");
INSERT INTO bus_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","Dauda bè: Bↄ́n má kɛ̀? Yãn má gbèkaroo? ");
INSERT INTO bus_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","Ben à kpɛɛ lìnɛ à gàa à yã dↄ̃nkↄ̃ pì là gbɛ̃ pãndea. Lán gbɛ̃ káaku ònɛ nà, lɛn wà ònɛ lɛ dↄ. ");
INSERT INTO bus_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Wà yã kɛ̀ Dauda ò pì tↄ̃kɛ̃̀ Solunɛ, ben à gbɛ̃ zĩ̀ wà à sìsi. ");
INSERT INTO bus_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","Kɛ̀ Dauda mↄ̀, à bè Solunɛ: Gbɛ̃ke tón tó swɛ̃̀ kɛ̃agu Filisitini pì yã musuro. Mamↄma n zↄ̀bleri, mɛ́ gá zĩ̀ káo. ");
INSERT INTO bus_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Ben Solu bènɛ: Nɛ́ fↄ̃ ǹ gá zĩ̀ ká kↄ̃n Filisitini pìoro. Nɛ́ féten n ũ. Gↄ̃gbɛ̃ pì sↄ̃ nɛ́ zĩ̀karimɛ zaa a gↄ̃kparɛkɛgurↄ. ");
INSERT INTO bus_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Ben Dauda bènɛ: Mamↄma n zↄ̀bleri, mámbe mɛɛ̀gↄ̃ ma de sãanↄ dãa. Tó músu ke kpera mↄ̀ à sãa kũ̀ kpàsan, ");
INSERT INTO bus_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","mɛɛ̀ à gbɛsɛ mà lɛ́ mà sãa pì bↄ à lɛ́zĩ. Tó à ɛ̀aramazi, ben mɛɛ̀ à kũ a lɛ́tãnkaa mà lɛ́ mà dɛ. ");
INSERT INTO bus_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Mapi n zↄ̀bleri, ma músu dɛ̀, ma kpera dɛ̀. Filisitini gɛfↄↄdee pì é gↄ̃ lán ń bà, zaakɛ èe Luda Wɛ̃̀ndide zĩ̀kpɛɛnↄ lɛ́ gwaa yãzi. ");
INSERT INTO bus_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","Dauda ɛ̀ara à bè: Lán Dii ma bↄ músu kↄ̃n kperao lɛ́zĩ nà, lɛn eé ma bↄ Filisitini pì ↄzĩ lɛ. Ben Solu bènɛ: Ǹ gá! Dii gↄ̃ kúnyo. ");
INSERT INTO bus_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Solu a zĩ̀ka'uta dànɛ à a mↄ̀gotɛ̃ fùra kùnɛ, ben à a mↄ̀ uta dànɛ. ");
INSERT INTO bus_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","Dauda Solu fɛ̃ɛdaa lògo zĩ̀ka'uta pìa. Kɛ̀ à yↄ̃̀ táa, ben à fùa, zaakɛ èe kↄ̃ dↄ̃oro. Ben à bè Solunɛ: Mɛ́ fↄ̃ mà gá kↄ̃n pↄ́ pìnↄro, zaakɛ mɛ́ɛ kↄ̃ dↄ̃oro. Ben à pↄ́ pìnↄ bↄ̀ɛ píngi à kàɛ. ");
INSERT INTO bus_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","À a gò sɛ̀, ben à gàa à gbɛ̀ pↄ́rↄpↄrↄ sɛ̀ɛ swawɛɛn mɛ̀n sↄↄro à kà a sãdãbↄkↄn. Ben èe sↄ̃ↄ Filisitini pìzi, à a gbɛ̀mba kũna. ");
INSERT INTO bus_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Ben Filisitini pì e sↄ̃ↄ Daudazi, à sɛngbangosɛri tɛ́ à aɛ. ");
INSERT INTO bus_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","Kɛ̀ à Dauda gwà, à è nɛ́ féte tɛ̃a maaamɛ, ben à dↄkɛ̀o ");
INSERT INTO bus_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","à bènɛ: Gbɛ̃ɛn ma ũ, ben n gbasa nɛ́ɛ mↄↄmazi kↄ̃n gòoↄ́? Ben à à kà kↄ̃n a tãa tↄ́o. ");
INSERT INTO bus_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","Ben à ɛ̀ara à bè: Ǹ sↄ̃mazi ǹ gwa, bãanↄ é n ble, nↄ̀bↄ pãsĩnↄ é n só. ");
INSERT INTO bus_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","Dauda bènɛ: Fɛ̃ɛda kↄ̃n sári lɛ̀ɛtɛgɛɛo kↄ̃n sári sↄ̃ntɛon nɛ́ɛ mↄↄo mazi. Mapi sↄ̃, Dii Zĩ̀kpɛde Isarailinↄ Luda kɛ̀ n à lɛ́ gwà yãzi tↄ́n mɛ́ɛ mↄↄonzi. ");
INSERT INTO bus_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","Dii é n namɛ ma ↄzĩ gbã̀a. Mɛ́ n dɛ mà n mì zↄ̃, mɛ́ Filisitini zĩ̀kpɛɛnↄ gɛ̀nↄ kpá bãanↄa kↄ̃n nↄ̀bↄ pãsĩnↄ gbã̀a aↄ̃ só, anduna é dↄ̃ kɛ̀ Ludaa kú kↄ̃n Isarailinↄ. ");
INSERT INTO bus_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Gbɛ̃ kɛ̀ aↄ̃ kàkↄ̃a gura kɛ̀nↄ é dↄ̃ kɛ̀ Dii è zĩ̀ ble kↄ̃n fɛ̃ɛdaao ke kↄ̃n sárioro. Dii bé à zĩ̀ vĩ, eé a nawe wa ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Gurↄↄ kɛ̀ Filisitini pì e sↄ̃ↄ Daudazi, à mↄ́ dakↄ̃rɛo, ben Dauda bàa lɛ̀ èe gaazi guu kɛ̀ weé zĩ̀ kán. ");
INSERT INTO bus_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","Ben à ↄ gɛ̃̀ a bↄ̀kↄn à gbɛ̀ bↄ̀ à dà a gbɛ̀mban. Kɛ̀ à Filisitini pì gbã̀o, ben à à pà a aɛa. Gbɛ̀ pì gɛ̃̀ à aɛwan, ben à lɛ̀ɛ a puua. ");
INSERT INTO bus_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","Gbɛ̀mban Dauda zĩ̀ blèo Filisitini pìa. À à pào a nɛ̀, baa fɛ̃ɛdaa à kũnaro. ");
INSERT INTO bus_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","Ben à bàa lɛ̀ à gàa à zɛ̀àla, à à fɛ̃ɛdaa wòto à kpɛ́n à à dɛ̀ à à mì zↄ̃̀o. Kɛ̀ Filisitininↄↄ è ń gↄ̃sagbãaa pì gà, ben aↄ̃ lɛ̀kↄ̃a. ");
INSERT INTO bus_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Ben Isarailinↄ kↄ̃n Yudanↄ pɛ̀ɛńzi kↄ̃n wiiio, aↄ̃ pɛ̀ḿma ai Gata bĩilɛa kↄ̃n Ɛkɛrↄnu bĩilɛo. Gbɛ̃ kɛ̀ aↄ̃ ń dɛdɛnↄ gɛ̀nↄ gↄ̃̀ kaɛna sɛna zaa Saraimu zɛ́n ai Gata kↄ̃n Ɛkɛrↄnuo. ");
INSERT INTO bus_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","Kɛ̀ aↄ̃ sù kↄ̃n pɛna Filisitininↄao, ben aↄ̃ ń bùra pↄ́nↄ nàkↄ̃a wà gɛ̃̀tɛo. ");
INSERT INTO bus_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","Dauda Filisitini pì mì sɛ̀ à gàao Yerusalɛmu, à à gↄ̃kɛbↄnↄ kàɛ a kpɛ́n. ");
INSERT INTO bus_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","Gurↄↄ kɛ̀ Dauda e sↄ̃ↄ Filisitini pìzi, Solu e à gwaa, ben à a zĩ̀kpɛɛnↄ gbɛ̃nsi Abana là à bè: Dé nɛ́n nɛ́gↄ̃gbɛ̃ pì ũu? À wèàla à bè: Kí, kↄ̃n n kuunao, má dↄ̃ro. ");
INSERT INTO bus_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","Ben kína bè: Ǹ gbeka ǹ ma tó dé nɛ́n gↄ̃kparɛ pì ũ. ");
INSERT INTO bus_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","Kɛ̀ Dauda sù kↄ̃n Filisitini pì dɛnao, Abana à sɛ̀ à gàao Solu kiia, à Filisitini pì mì kũna. ");
INSERT INTO bus_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","Ben Solu à là à bè: Gↄ̃kparɛ, dé nɛ́n n ũu? À wèàla à bè: N zↄ̀bleri Yɛsɛ, Bɛtɛlɛmu gbɛ̃ nɛ́n ma ũ. ");
INSERT INTO bus_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","Kɛ̀ Dauda yã ò kↄ̃n Soluo à yã̀a, ben Yonatã gbɛ̃nna kpào à yezi lán a zĩnda wɛ̃̀ndi bà. ");
INSERT INTO bus_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","Zaa zĩ beeean Solu à dìɛ a bɛ, èe we à tá a de bɛ dↄro. ");
INSERT INTO bus_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","Yonatã yã yìo kɛ̀ à yezi lán a zĩnda wɛ̃̀ndi bà yãnzi. ");
INSERT INTO bus_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","Ben à a utadaa kɛ̀ à dana bↄ̀ à à gbà kↄ̃n a zĩ̀ka'utao kↄ̃n a fɛ̃ɛdaao kↄ̃n a sáo kↄ̃n a asaao. ");
INSERT INTO bus_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Guu kɛ̀ Solu Dauda gbàrɛn zĩ̀ ká píngi, è saa kũmɛ, ben à à dìɛ zĩ̀kpɛɛnↄ gbɛ̃nsi ũ. À yã è kɛ baade pínginɛ nnamɛ kↄ̃n Solu ìbanↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Kɛ̀ zĩ̀kpɛɛnↄↄ e suu Dauda Filisitini pì dɛna gbɛra, nↄgbɛ̃nↄ bↄ̀ Isaraili wɛ́tɛnↄ guu píngi, aↄ̃ gàa da ń kí Solulɛ, aↄ̃ↄe lɛ̀ sii aↄ̃ↄe ↄ̃ wãa, aↄ̃ↄe gã̀gã lɛɛ aↄ̃ↄe pↄnnaa kɛɛ aↄ̃ↄe sɛ̃gɛ̃sɛ̃gɛ̃ paa. ");
INSERT INTO bus_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Aↄ̃ↄe lɛ̀ sii wèe dↄↄkↄ̃nɛ, aↄ̃ↄe ↄ̃ wãa wèe bee: Solu gbɛ̃nↄ dɛ̀dɛ gↄ̃ↄn wàa sↄsↄↄro, Dauda sↄ̃ gↄ̃ↄn bↄrↄ lɛo ũgbangba. ");
INSERT INTO bus_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Yã pì kɛ̀ Solunɛ zaa maamaa, ben à pↄ fɛ̃̀ à bè: Wà gↄ̃ↄn bↄrↄ lɛo ũgbangba kpà Daudaa, mapi sↄ̃ wàa sↄsↄↄro. Kpata bé à gↄ̃̀ à sí sa. ");
INSERT INTO bus_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Zaa zĩ beeean à wɛ́ɛ dↄ̀nɛ. ");
INSERT INTO bus_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","Kɛ̀ guu dↄ̀, ben Ludaa tò Solu zĩn pãsĩ pì dìa, èe yãbuu tãa a kpɛ́n, ben Dauda a mↄrↄ sɛ̀, èe lɛɛ lán è lɛ́ nà. Solu a sári kũna, ");
INSERT INTO bus_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","ben à à gbã̀o, èe daa é Dauda páo lɛ à nakↄ̃a kↄ̃n gũ̀omɛ. Ben Dauda a zĩnda gbɛ̃̀ɛnɛ ai gɛ̃̀n plaa. ");
INSERT INTO bus_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","Solu e vĩa kɛɛ Daudanɛ kɛ̀ Dii kúo bensↄ̃ à kpɛɛ lìare yãnzi. ");
INSERT INTO bus_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","Ben à pɛ̀ Daudaa a kiia, à à dìɛ zĩ̀kpɛ gↄ̃ↄn wàa sↄↄroonↄ gbɛ̃nsi ũ. Àmbe ègↄ̃ dↄńnɛ aɛ zĩ̀lan. ");
INSERT INTO bus_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","Guu kɛ̀ à gàan píngi è saa kũmɛ, kɛ̀ Dii kúo yãnzi. ");
INSERT INTO bus_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","Kɛ̀ Solu è ègↄ̃ saa kũu, ben à vĩa kɛ̀nɛ dɛ káakula. ");
INSERT INTO bus_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","Isarailinↄ kↄ̃n Yudanↄ sↄ̃ↄ ye Daudazi ń píngi, kɛ̀ ègↄ̃ dↄↄńnɛ aɛ zĩ̀lan yãnzi. ");
INSERT INTO bus_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","Ben Solu bènɛ: Mɛ́ ma nɛ́nↄgbɛ̃ káaku Mɛraba kpámma nↄↄ ũ. Ǹ wↄ́rↄngↄ kɛ ǹ Dii zĩ̀ kámɛ. Zaakɛ Solu laasuu lɛ̀ à bè: Mɛ́ ↄ naaro, Filisitininↄ bé wé à dɛ. ");
INSERT INTO bus_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","Ben Dauda bènɛ: Dén ma ũu? Dén ma bɛdeenↄ kↄ̃n ma de boriinↄ ũ kɛ̀ mɛ́ gbasa mà gↄ̃ n anzure ũu? ");
INSERT INTO bus_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","Kɛ̀ Mɛraba kà wà à kpá Daudaa, ben Solu à kpà Mɛↄla gbɛ̃ Adariɛlia. ");
INSERT INTO bus_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","Solu nɛ́nↄgbɛ̃ Mikala ye Daudazi. Kɛ̀ wà yã pì ò Solunɛ, à kɛ̀nɛ nna ");
INSERT INTO bus_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","à bè: Mɛ́ à kpáamɛ, eé gↄ̃nɛ takutɛɛ ũ, Filisitininↄ é à dɛ. Ben à bè Daudanɛ: Nɛ́ ma nɛ́ pãnde e ǹ sɛ́ sa. ");
INSERT INTO bus_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","Ben à bè a ìbanↄnɛ: À yã o Daudanɛ asii guu, à onɛ à yã kàmɛ, bensↄ̃ ma ìbanↄↄ yezi ń píngi. À ma nɛ́nↄgbɛ̃ sɛ́. ");
INSERT INTO bus_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","À ìbanↄ yã pì dà Daudanɛ a swãla, ben à bèńnɛ: Gↄ̃na kína nɛ́ zã ũu nɛ́ yã aagan yↄ́? Takaasideen ma ũ, dé bé à ma dↄ̃ↄ? ");
INSERT INTO bus_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","Kɛ̀ Solu ìbanↄ sù, aↄ̃ Dauda yã pì tↄ̃kɛ̃̀nɛ. ");
INSERT INTO bus_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","Ben Solu bè: À onɛ má ye anzure pↄ́keziro, sé à gɛ̃ɛ bomɛ ma ibɛɛ Filisitininↄa, à sumɛ kↄ̃n ń gɛfↄↄnↄ mɛ̀n basↄↄro. Èe kpákpaa Filisitininↄ é à dɛmɛ. ");
INSERT INTO bus_vpl VALUES ("S118_26","010_18_26","1SA","18","26","26","Kɛ̀ ìba pìnↄ yã pì tↄ̃kɛ̃̀ Daudanɛ, gↄ̃na kína nɛ́ zã ũu kɛ̀nɛ nna sa. Ai nↄↄ pì sɛ́gurↄↄ gↄ̃ gá ká, ");
INSERT INTO bus_vpl VALUES ("S118_27","010_18_27","1SA","18","27","27","Dauda kↄ̃n a zĩ̀kpɛɛnↄ fɛ̀ɛ wà gàa wà Filisitininↄ dɛ̀dɛ gↄ̃ↄn wàa do, ben à sù kↄ̃n ń gɛfↄↄnↄo à kpà kínaa píngi, lɛ à e à gↄ̃ à nɛ́ zã ũ yãnzi. Ben Solu a nɛ́ Mikala kpàa nↄↄ ũ. ");
INSERT INTO bus_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","Kɛ̀ Solu è lɛ, à dↄ̃̀ kɛ̀ Dii kú kↄ̃n Daudao bensↄ̃ a nɛ́ Mikala yezi, ");
INSERT INTO bus_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","ben à vĩakɛnanɛ kàara, à gↄ̃̀ à ibɛɛ ũ ai à gàa gào. ");
INSERT INTO bus_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","Gurↄↄ kɛ̀ Filisitininↄ kínanↄↄ e bↄɛɛ wà gá zĩ̀ ká, Dauda è saa kũ dɛ Solu ìba kpaaanↄla, ben à tↄ́ bↄ̀ maamaa. ");
INSERT INTO bus_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","Solu ò a nɛ́ Yonatãnɛ kↄ̃n a ìbanↄ ń píngi aↄ̃ Dauda dɛ. Mↄde Yonatã yezi à ↄ gɛ̃̀, ");
INSERT INTO bus_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","ben à à gbà làakari à bè: Ma dee e wɛtɛɛ à n dɛ. Ǹgↄ̃ n zĩnda kũna dↄ̃ zia kↄngↄ. Ǹ utɛkii wɛtɛ ǹgↄ̃ kú gwe. ");
INSERT INTO bus_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","Mɛ́ bↄ wɛ́tɛ kpɛɛ kↄ̃n ma deo, wé zɛ guu kɛ̀ n utɛn. Mɛ́ n yã onɛ. Lán à òmɛ nà, mɛ́ onnɛ. ");
INSERT INTO bus_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","Ben Yonatã gàa à Dauda maa bò a denɛ à bè: Baa, ǹton yã zaaa kɛ n zↄ̀bleri Daudanɛro, zaakɛ èe zaa ke kɛnnɛro. À yãkɛnanↄↄ àre vĩnnɛ maamaa. ");
INSERT INTO bus_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","Kɛ̀ à Filisitini pì dɛ̀, à gì a wɛ̃̀ndizimɛ, ben Dii tò wa zĩ̀ bíta blè wa píngi. Ń è, ben n pↄↄ kɛ̀ nna. Bↄ́yãnzi ń yezi ǹ yã zaaa kɛ taarisaidee pìnɛzi ǹ à dɛ pãa? ");
INSERT INTO bus_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","Solu à yã mà, ben à lù sɛ̀ à bè: Kↄ̃n Diio weé à dɛro. ");
INSERT INTO bus_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","À gbɛra Yonatã Dauda sìsi, à yã pì tↄ̃kɛ̃̀nɛ píngi, ben à gàa kↄ̃n Daudao Solu kiia, ben èe zĩi kɛɛnɛ lán a zii bà. ");
INSERT INTO bus_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","Zĩ̀ ɛ̀ara à fɛ̀ɛ, ben Dauda gàa zĩ̀ ká kↄ̃n Filisitininↄ. À sìńgu à zĩ̀ blèḿma búgubugu, ben aↄ̃ bàa lɛ̀nɛ. ");
INSERT INTO bus_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","Dii tò Solu zĩn pãsĩ pì ɛ̀ara à dìa gurↄↄ kɛ̀ à vɛ̃ɛna a kpɛ́n. À a sári kũna, ben Dauda e a mↄrↄ lɛɛnɛ. ");
INSERT INTO bus_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","Solu wɛ̀tɛ à Dauda páo lɛ à à nakↄ̃a kↄ̃n gũ̀o. Kɛ̀ à gbɛ̃̀ɛnɛ, ben sári pì gàa à gũ̀ pà. Gwãavĩ beeean Dauda bàa lɛ̀ à tà. ");
INSERT INTO bus_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","Ben Solu gbɛ̃nↄ zĩ̀ Dauda bɛ, lɛ aↄ̃ à dãdã aↄ̃ à dɛ kↄngↄ, ben à naↄ̃ Mikala à gbà làakari à bè: Tó nɛ́ɛ bàa sí gwãavĩaro, weé n dɛ zia. ");
INSERT INTO bus_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","Ben Dauda bↄ̀ windo guu, Mikala à gbàrɛ kↄ̃n bào tↄↄtɛ, ben à bàa lɛ̀ à gɛ̃̀ zɛ́la. ");
INSERT INTO bus_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","Ben Mikala tãa sɛ̀ à dàɛ gádoa, à blè báa sɛ̀ à kù tãa pì mìla, ben à bisa kùàla. ");
INSERT INTO bus_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","Kɛ̀ Solu gbɛ̃nↄ zĩ̀ Dauda kũ, Mikala bè à gbãaro. ");
INSERT INTO bus_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","Ben Solu ɛ̀ara à gbɛ̃nↄ zĩ̀ Dauda gwa à bèńnɛ: À à sɛ́ kↄ̃n a gádoo lɛdo, à suomɛ lɛ mà à dɛ. ");
INSERT INTO bus_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","Kɛ̀ aↄ̃ gɛ̃̀ kpɛ́n, tãa pìn aↄ̃ↄ è gádoa, blè báa kú à mìla. ");
INSERT INTO bus_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","Ben Solu Mikala là à bè: Bↄ́yãnzi n bↄ ma kpɛɛ n ma ibɛɛ gbàrɛ à pìtimaguzi? Mikala wèàla à bè: À bèmɛ mà tó à gɛ̃ zɛ́la. Tó ma gi sↄ̃, é ma dɛ. ");
INSERT INTO bus_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","Kɛ̀ Dauda bàa lɛ̀ à gɛ̃̀ zɛ́la, à gàa Samuɛli gwa zaa Rama. À yã kɛ̀ Solu kɛ̀nɛ tↄ̃kɛ̃̀nɛ píngi, ben aↄ̃ gàa wà vɛ̃̀ɛ Nayo lɛdo. ");
INSERT INTO bus_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","Kɛ̀ wà ò Solunɛ Dauda kú Nayo zaa Rama, ");
INSERT INTO bus_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","ben Solu gbɛ̃nↄ zĩ̀ à kũ. Kɛ̀ aↄ̃ kà gwe, aↄ̃ↄ lè annabi gãli e dɛdɛɛ, Samuɛli kú ń tɛ́ ń dↄn'aɛdee ũ. Ben Luda Nini sù zĩ̀ri pìnↄa, aↄ̃ↄe dɛdɛɛ se. ");
INSERT INTO bus_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","Kɛ̀ wà ò Solunɛ, ben à gbɛ̃ pãndenↄ zĩ̀, ben aↄ̃ↄ dɛ̀dɛ lɛ dↄ. Solu ɛ̀ara à gbɛ̃nↄ zĩ̀ à gɛ̃̀n aagↄ̃deeo, ben aↄ̃ↄ dɛ̀dɛ se dↄ. ");
INSERT INTO bus_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","Ben Solu pì fɛ̀ɛ èe gaa Rama a zĩnda sa. Kɛ̀ à kà lↄ̀gↄ bíta kɛ̀ kú Sɛku saɛ, à gbɛ̃nↄ gbèka à bè: Samuɛli kↄ̃n Daudao kú mámɛ? Ben wà bènɛ: Aↄ̃ↄ kú Nayo zaa Rama. ");
INSERT INTO bus_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","Kɛ̀ èe gaa gwe, ben Luda Nini sù baa àpia se, èe dɛdɛɛ èe gaa ai à gàa à kào Nayo zaa Rama. ");
INSERT INTO bus_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","À a pↄ́kãsãanↄ pìtiawa, à dɛ̀dɛ Samuɛli aɛzĩ. Zĩ beeea fãantɛ̃ kↄ̃n gwãavĩo píngi ègↄ̃ daɛna bũumɛ. À yã bé à tò wè be: Solu kú annabinↄ tɛ́mɛ se dↄↄ? ");
INSERT INTO bus_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","Dauda bↄ̀ Nayo zaa Rama, à bàa lɛ̀ à gàa à Yonatã lè, ben à à là à bè: Bↄ́n má kɛ̀? Dà kpareen má kɛ̀? Yã zaa kpareen má kɛ̀ n denɛ kɛ̀ èe wɛtɛɛ à ma dɛɛ? ");
INSERT INTO bus_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","À wèàla à bè: Gyam! Nɛ́ garo. Ǹ gwa, ma de è yãke kɛ à gí damɛ ma swãlaziro, yã bíta ke à nɛ́ngon yoo. Ma de égↄ̃ yã beee taka kɛɛ à gí omɛziↄ́? Mɛ́ɛ síro! ");
INSERT INTO bus_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","Ben Dauda bè dↄ: N dee dↄ̃ sãnsãn kɛ̀ ma n pↄnnaa è. Beee yãnzin èe tó n yã pì màro, lɛ n pↄↄ tón yakaro yãnzi. Kↄ̃n Dii kuunao kↄ̃n n kuunao má kú gaa lɛ́zĩmɛ. ");
INSERT INTO bus_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","Ben Yonatã bènɛ: Pↄ́ kɛ̀ ń yezi píngi mɛ́ kɛnnɛ. ");
INSERT INTO bus_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","Ben Dauda bènɛ: Ǹ gwa, mↄ dufu zĩbaamɛ zia. À kũ̀ mà vɛ̃ɛ mà pↄ́ ble kↄ̃n kínaomɛ. Ǹ tó mà gá mà utɛ sɛ̃̀tɛ ai ziando uusiɛ. ");
INSERT INTO bus_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","Tó n de ma gbeka, ǹ benɛ ma zɛ́ gbèkamma mà gá ma bɛ wɛ́tɛ Bɛtɛlɛmu kpakpaa, kɛ̀ ma bɛdeenↄ píngi e saa kɛ̀ wè o wɛ̃̀ kↄ̃n wɛ̃̀o oo gwe yãnzi. ");
INSERT INTO bus_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","Tó à bè à maa, mɛ́gↄ̃ aafia, mↄde tó à pↄ fɛ̃̀ maamaa, ǹgↄ̃ dↄ̃ kɛ̀ yã zaaan à zɛ̀o à kɛmɛ gwe. ");
INSERT INTO bus_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","Ǹ gbɛ̃kɛɛ kɛ mamↄma n zↄ̀blerinɛ, zaakɛ n yã yìmao kↄ̃n Dii dↄ̃naomɛ. Tó má taari vĩ, ǹ ma dɛ n zĩnda. Ǹton ma kpá n dearo. ");
INSERT INTO bus_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","Ben Yonatã bè: Gyam! Tó má dↄ̃ kɛ̀ ma de zɛ̀o à zaaa kɛnnɛ, lɛ mɛ́ onnɛroo? ");
INSERT INTO bus_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","Ben Dauda à là à bè: Tó n de gà à yã pãsĩ ònnɛ, dé bé eé omɛɛ? ");
INSERT INTO bus_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","Ben Yonatã bènɛ: Ǹ mↄ́ wà gá sɛ̃̀tɛ. Ben aↄ̃ bↄ̀ɛ wà gàa sɛ̃̀tɛ ń plaa. ");
INSERT INTO bus_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","Ben Yonatã bè: Má sì kↄ̃n Dii Isarailinↄ Ludao, ai ziando mↄndaa'i mɛ́ ma de yↄ̃ mà gwa. Tó n yã kànɛ, mɛ́ lɛ́kpãsã kɛnnɛ. ");
INSERT INTO bus_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","Tó ma dee yezi à à zaaa kɛnnɛmɛ sↄ̃, ben mɛ́ɛ lɛ́kpãsã kɛnnɛ ma n gbarɛ n ta aafiaro, Dii yã kɛmɛ pãsĩpãsĩ. Dii gↄ̃ kúnyo lán à kú kↄ̃n ma deo yã nà. ");
INSERT INTO bus_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","Lán má kpɛ́ kú wɛ̃̀ndio nà ǹ gbɛ̃kɛɛ kɛmɛ lán Dii è kɛńnɛ nà, kɛ̀ wàton ma dɛro yãnzi. ");
INSERT INTO bus_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","N gbɛ̃kɛɛ tón yãa kↄ̃n ma bɛdeenↄ zikiro, baa tó Dii tò n ibɛɛnↄ yã̀a anduna guu. ");
INSERT INTO bus_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","Lɛn Yonatã yã yì kↄ̃n Daudao lɛ, ben à bè: Dii gɛ̃ɛ bonnɛ n ibɛɛnↄa. ");
INSERT INTO bus_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","Ben Yonatã tò Dauda ɛ̀ara à lù sɛ̀are dↄ a yenzi yãnzi, zaakɛ à yezi lán a zĩnda wɛ̃̀ndi bàmɛ. ");
INSERT INTO bus_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","Ben Yonatã bènɛ: Mↄ dufu zĩbaa kuu zia. Tó wèe gbɛ̃ke e n vɛ̃ɛkiinlo, weé n gbeka. ");
INSERT INTO bus_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","Ziando ǹ gá ǹ utɛ guu kɛ̀ n utɛn yãa pì naanagurↄ, nɛ́gↄ̃ kú gbɛ̀ kɛ̀ dɛ tↄↄtɛ lɛ́ sèeda ũu saɛ gwe. ");
INSERT INTO bus_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","Mɛ́ kà zu gbɛ̀ pì saɛ wɛ́n aagↄ̃ lándↄ̃ mɛ́ɛ pↄ́ gbãa bà, ");
INSERT INTO bus_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","mɛ́ nɛ́gↄ̃gbɛ̃ ke zĩ à gá kà pìnↄ wɛtɛ. Tó ma bènɛ, kànↄↄ kú à kpɛɛ, à sɛ́ɛ à mↄ́o, ǹ mↄ́, má sì kↄ̃n Diio nɛ́gↄ̃ aafiamɛ, kari kuuro. ");
INSERT INTO bus_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","Tó ma bènɛ kànↄↄ kú à aɛ sↄ̃, ǹ gá, zaakɛ Dii bé à n gbarɛ. ");
INSERT INTO bus_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","Yã kɛ̀ wá yì kↄ̃o sↄ̃, Dii bé eégↄ̃ dɛ yã pì sèedadee ũ gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","Ben Dauda gàa à ùtɛ sɛ̃̀n. Kɛ̀ mↄ dufu bↄ̀, kína vɛ̃̀ɛ lɛ à pↄ́ ble. ");
INSERT INTO bus_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","À vɛ̃̀ɛ a vɛ̃ɛkiia gũ̀ saɛ. Yonatã vɛ̃̀ɛ à aɛ, Abana kú à saɛ. Dauda vɛ̃ɛkii sↄ̃, gbɛ̃kee kú gwero. ");
INSERT INTO bus_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","Solu e yãke o zĩ beeearo, zaakɛ èe daa yãke bé à à lè, à kú gbãsĩomɛ, beee bé à kpànɛ. ");
INSERT INTO bus_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","Kɛ̀ guu dↄ̀ mↄ gurↄ plaadee zĩ, Dauda vɛ̃ɛkii gↄ̃ da kori, ben Solu a nɛ́ là à bè: Bↄ́yãnzi Yɛsɛ nɛ́ e mↄ́ pↄ́ ble gĩa kↄ̃n gbã̀aoroo? ");
INSERT INTO bus_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","Ben à bènɛ: À zɛ́ gbèkama, à bè é gá Bɛtɛlɛmu. ");
INSERT INTO bus_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","À bè mà tó à gá, zaakɛ a bɛdeenↄↄ e saa oo wɛ́tɛ pì guumɛ, ben a vĩ̀i bèare à mↄ́. À bè tó à kɛ̀mɛ, mà a gbarɛ à gá a vĩ̀inↄ gwa. Beee yãnzin èe mↄ́ pↄ́ blenyorozi. ");
INSERT INTO bus_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","Ben Solu pↄ fɛ̃̀ Yonatãzi à bè: Nɛ́ faasai swãgbãade! Má dↄ̃ kɛ̀ n zɛ Yɛsɛ nɛ́ kpɛɛmɛ. N wí dà n zĩndaa kↄ̃n n dao. ");
INSERT INTO bus_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","Tó Yɛsɛ nɛ́ pì gↄ̃ kú kũ wɛ̃̀ndio, nɛ́ e ǹ kpata blero. Ǹ gbɛ̃nↄ zĩ aↄ̃ à kũ wà suomɛ tia. Séto à ga. ");
INSERT INTO bus_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","Ben Yonatã à là à bè: Bↄ́yãnzin eé gazi? Bↄ́n à kɛ̀? ");
INSERT INTO bus_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","Ben Solu Yonatã gbã̀ kↄ̃n sário lɛ à e à à dɛ, ben Yonatã dↄ̃̀ sa kɛ̀ a de zɛ̀ kↄ̃n Dauda dɛnaomɛ. ");
INSERT INTO bus_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","Yonatã fɛ̀ɛ à gò pↄ́bleela kↄ̃n pↄfɛ̃o, èe gà à pↄ́ blè mↄ gurↄ plaadee pì zĩ dↄro, zaakɛ à nↄ̀sɛ yàka Dauda yã musu, kɛ̀ à de à dìɛ gbɛ̃ futaa ũ yãnzi. ");
INSERT INTO bus_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","Kɛ̀ guu dↄ̀, Yonatã bↄ̀ à gàa Dauda le guu pìn. Nɛ́gↄ̃gbɛ̃ kee tɛ́zi. ");
INSERT INTO bus_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","Ben à bè nɛ́ pìnɛ. Ǹ bàa lɛ́ ǹ gá kãa. Tó ma kà zù, nɛ́ wɛtɛ. Kɛ̀ nɛ́ pì bàa lɛ̀ èe gaa, ben Yonatã kà zù à mìla. ");
INSERT INTO bus_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","Kɛ̀ nɛ́ pì kà guu kɛ̀ Yonatã kà pɛ̀ɛn, ben à lɛ́ zù nɛ́ pìzi à bè: Kà pìnↄↄ kú n aɛ kãa. ");
INSERT INTO bus_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","Ben Yonatã ɛ̀ara à lɛ́ zùzi dↄ à bè: Ǹ gá kpakpaa, ǹton zɛro. Ben nɛ́ pì kà pìnↄ sɛ̀ɛ à sùo a diinɛ. ");
INSERT INTO bus_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","Nɛ́ pì e yã pì dↄ̃ro, séde Yonatã kↄ̃n Daudao. ");
INSERT INTO bus_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","Ben Yonatã a gↄ̃kɛbↄnↄ kpà nɛ́ pìa à bè: Ǹ sí ǹ táo bɛ. ");
INSERT INTO bus_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","Kɛ̀ nɛ́ pì tà, Dauda fɛ̀ɛ gbɛ̀ kpɛɛ à mↄ̀ à kùɛ Yonatãnɛ gɛ̃̀n aagↄ̃ à dàɛ a puua. Ben aↄ̃ lɛ́ pɛ̀kↄ̃a aↄ̃ ↄ́ↄ dↄ̀ ń plaa ń píngi, Dauda pↄ́ bé à bíta. ");
INSERT INTO bus_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","Ben Yonatã bènɛ: Ǹ tá aafia, zaakɛ wa lù sɛ̀ kↄ̃n Dii tↄ́o wa bè, Diin wa sèedadee ũ ma boriinↄ kↄ̃n n boriinↄ dagura ai gurↄ píngi. Dauda bↄ̀ gwe, ben Yonatã ɛ̀ara à tà a bɛ. ");
INSERT INTO bus_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","Kɛ̀ Dauda e gaa sa'oriki Aimɛlɛki kiia zaa Nↄbu, Aimɛlɛki pì bↄ̀ à gàa à daàlɛ. Vĩa à kũ̀, ben à à là à bè: Bↄ́ bé à tò ń tɛ́ ndo, gbɛ̃kee kúnyoroee? ");
INSERT INTO bus_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","Dauda wèàla à bè: Kí bé à zĩi dàmɛ, à bè màton tó gbɛ̃ke yã kɛ̀ á dìɛmɛ à ma zĩ mà kɛɛ dↄ̃ro. Ben wa guu zↄ̃̀kↄ̃nɛ kↄ̃n ma ìbanↄ aↄ̃ dↄmɛ aɛ. ");
INSERT INTO bus_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Pↄ́ble kpareen ń vĩ kɛ̀ tiaa? Ǹ ma gba burɛdi mɛ̀n sↄↄro kesↄ̃ pↄ́ kɛ̀ ń vĩ píngi dé. ");
INSERT INTO bus_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Ben sa'oriki pì bè: Burɛdi pã kuuro, séde kɛ̀ wà kàɛ Ludanɛ baasiro. Tó n gbɛ̃nↄↄ e kakↄ̃a kↄ̃n nↄgbɛ̃oro, mɛ́ kpámma. ");
INSERT INTO bus_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","Ben Dauda bènɛ: À dɛ lɛ kↄ̀, wá wa zĩnda kũna nↄgbɛ̃nↄ yã musu, lán weè kɛ nà wà gbasa wà da zɛ́n wà gá zĩ̀ ká. Ma gbɛ̃nↄ mɛ̀nↄↄ gbãsĩro. Baa gurↄↄ kɛ̀ wée pↄyezi táa oo, aↄ̃ègↄ̃ gbãsĩro, atɛ̃nsa tá kɛ̀ wée oo gbã̀aro. ");
INSERT INTO bus_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Ben sa'oriki pì Luda burɛdi sɛ̀ à kpàa, zaakɛ burɛdi kee kú gwero, sé kɛ̀ wà kàɛ Ludanɛ. Wè burɛdi pì sɛ́ Dii aɛmɛ, ben wè à lende kpá kↄ̃n burɛdi dufuo. ");
INSERT INTO bus_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","Solu ìbanↄ dokee kú gwe gurↄↄ pìa, à tↄ́n Doɛgi. Ɛdↄmu boriimɛ, àmbe Solu sãdãriki ũ. ");
INSERT INTO bus_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","Ben Dauda Aimɛlɛki là à bè: Ń sári ke fɛ̃ɛdaa vĩ kɛ̀ↄ́? Mɛ́ɛ e ma a fɛ̃ɛda ke gↄ̃kɛbↄ ke sɛ̀ro, zaakɛ kí zĩ kùrukuru dàmɛmɛ. ");
INSERT INTO bus_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","Sa'oriki pì wèàla à bè: Gↄlaya, Filisitini kɛ̀ ń dɛ̀ Ela guzurɛn fɛ̃ɛdaa kú kɛ̀. À kú dansiki kpɛɛ, bisa fĩfĩa. Tó ń yezi, ǹ sɛ́, zaakɛ à pãndee kú kɛ̀ dↄro, séde beee pì. Ben Dauda bè: Ǹ kpáma, à sáa kuuro. ");
INSERT INTO bus_vpl VALUES ("S121_10","010_21_10","1SA","21","10","10","Dauda bàa lɛ̀ Solunɛ zĩ beeea, à tà Gata kí Akisi kiia. ");
INSERT INTO bus_vpl VALUES ("S121_11","010_21_11","1SA","21","11","11","Ben Akisi ìbanↄ bènɛ: Isarailinↄ bùsu kí Daudan yɛ̀roo? Àpin wè ↄ̃ wã wà lɛ̀ sí à yã musuroo? Wè be: Solu gbɛ̃nↄ dɛ̀dɛ gↄ̃ↄn wàa sↄsↄↄro, Dauda sↄ̃ gↄ̃ↄn bↄrↄ lɛo ũgbangba. ");
INSERT INTO bus_vpl VALUES ("S121_12","010_21_12","1SA","21","12","12","Yã pì Dauda kũ̀ gbãa, èe vĩa kɛɛ Akisinɛ maamaa. ");
INSERT INTO bus_vpl VALUES ("S121_13","010_21_13","1SA","21","13","13","Ben à a zĩnda lìɛ, èe ĩadeyãnↄ kɛkɛɛ ń aɛzĩ. À ↄgbɛ gàɛgaɛ bĩi zɛ́ gbànↄa, à tò lóu e plaa a lɛ́tãnkaa. ");
INSERT INTO bus_vpl VALUES ("S121_14","010_21_14","1SA","21","14","14","Ben Akisi bè a ìbanↄnɛ: À gwa! Gbɛ̃ pì nɛ́ ĩadeemɛ. Bↄ́yãnzin a à sɛ̀ a mↄo ma kiiazi? ");
INSERT INTO bus_vpl VALUES ("S121_15","010_21_15","1SA","21","15","15","Ĩadeenↄ kɛ̃̀sãmamɛɛ, ben a gbɛ̃ pì sɛ̀ a mↄo ma kiia lɛ à ĩadeyãnↄ kɛkɛmɛↄ́? Eé e à gɛ̃ ma uaro. ");
INSERT INTO bus_vpl VALUES ("S122_1","010_22_1","1SA","22","1","1","Dauda bↄ̀ gwe à bàa lɛ̀, à gàa à gɛ̃̀ Adulamu gbɛ̀wɛɛn. Kɛ̀ à vĩ̀inↄ kↄ̃n à de bɛdeenↄ à baaru mà, aↄ̃ gàa wà à lè gwe. ");
INSERT INTO bus_vpl VALUES ("S122_2","010_22_2","1SA","22","2","2","Yã'ↄ̃ammadeenↄ kↄ̃n fĩadeenↄ kↄ̃n gbɛ̃ kɛ̀ yã è kɛńnɛroonↄ kàkↄ̃azi ń píngi, ben à gↄ̃̀ ń gbɛ̃nsi ũ. Aↄ̃ kà gↄ̃ↄn wàa plaa taka bà. ");
INSERT INTO bus_vpl VALUES ("S122_3","010_22_3","1SA","22","3","3","Bↄna zaa gwe Dauda gàa Mizipa, Mↄabunↄ bùsun, à bè Mↄabu kínanɛ: Ǹ ma de kↄ̃n ma dao gba zɛ́ aↄ̃gↄ̃ kúnyo ai mà dↄ̃ lán Luda é kɛmɛ nà. ");
INSERT INTO bus_vpl VALUES ("S122_4","010_22_4","1SA","22","4","4","Ben à ń tó kↄ̃n Mↄabu kínao gwe. Aↄ̃ↄ kúo gurↄↄ kɛ̀ Dauda kú sɛ̃̀tɛ pↄ̀rↄtu. ");
INSERT INTO bus_vpl VALUES ("S122_5","010_22_5","1SA","22","5","5","Beee gbɛra annabi Gada mↄ̀ à yã ò Daudanɛ à bè: Ǹtongↄ̃ kú sɛ̃̀tɛ pↄ̀rↄtu dↄro. Ǹ ɛara ǹ tá Yudanↄ bùsun. Ben à fɛ̀ɛ à gàa Ɛrɛti líkpɛn. ");
INSERT INTO bus_vpl VALUES ("S122_6","010_22_6","1SA","22","6","6","Zĩkea Solu vɛ̃ɛna sãma lí gbáru Gibɛa sĩ̀sĩa. À a sári kũna, à ìbanↄ lìgazi ń píngi. Ben à mà wà Dauda kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ kúonↄ kúkii dↄ̃̀. ");
INSERT INTO bus_vpl VALUES ("S122_7","010_22_7","1SA","22","7","7","Ben à bè a ìba pìnↄnɛ: a Bɛyãmi boriinↄ, à ma yã ma a píngi. Yɛsɛ nɛ́ é buraanↄ kↄ̃n geepi búnↄ kpáawaↄ́? Eé a diɛ zĩ̀kari gↄ̃ↄn wàa sↄsↄↄro ke gↄ̃ↄn basↄsↄↄroonↄ gbɛ̃nsinↄ ũↄ́? ");
INSERT INTO bus_vpl VALUES ("S122_8","010_22_8","1SA","22","8","8","A píngi a lɛ́ kpàkↄ̃sↄ̃mazimɛ. Kɛ̀ ma nɛ́ yã yì kↄ̃n Yɛsɛ nɛ́o, a gbɛ̃kee e omɛro. A gbɛ̃kee e ma wɛ̃nda gwaro. Èe damɛ ma swãla kɛ̀ ma nɛ́ ma ìba pì nↄ̀sɛ fɛ̀ɛ àgↄ̃ ma wɛtɛɛ à ma dɛ, lán èe kɛɛ nà tiaro. ");
INSERT INTO bus_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","Ɛdↄmu bori Doɛgi kú kↄ̃n Solu ìbanↄ gwe, ben à bè: Ma Yɛsɛ nɛ́ è, à mↄ̀ Aitubu nɛ́ Aimɛlɛki kiia zaa Nↄbu. ");
INSERT INTO bus_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","À yã gbèkanɛ Diia, ben à kũsãɛ kpàa kↄ̃n Filisitini bori Gↄlaya fɛ̃ɛdaao. ");
INSERT INTO bus_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","Ben kína gbɛ̃nↄ zĩ̀ aↄ̃ sa'oriki Aimɛlɛki sísi kↄ̃n a de bɛdee kɛ̀ aↄ̃ↄ dɛ sa'orinↄ ũ zaa Nↄbunↄ ń píngi. Ben aↄ̃ mↄ̀ kína kiia ń píngi. ");
INSERT INTO bus_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","Ben Solu bènɛ: Ǹ swã kpá ǹ ma, Aitubu nɛ́. À wèàla à bè: Ma swã dↄ, Baa. ");
INSERT INTO bus_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","Ben Solu à là à bè: Bↄ́yãnzin mmↄn kↄ̃n Yɛsɛ nɛ́o a lɛ́ kpàkↄ̃sↄ̃mazizi? Bↄ́yãnzin n pↄ́blee kpàa kↄ̃n fɛ̃ɛdaaozi? N yã gbèkanɛ Ludaa, lɛ à fɛɛmazi àgↄ̃ ma wɛtɛɛ à ma dɛ, lán èe kɛɛ nà tia. ");
INSERT INTO bus_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","Aimɛlɛki wèàla à bè: N ìbanↄ tɛ́ píngi, dé bé à náanɛ vĩ à kà Dauda ũu? N nɛ́ zãmɛ, n zĩnda dogarinↄ kínamɛ, bensↄ̃ à tↄ́ bↄ̀ n bɛ. ");
INSERT INTO bus_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","Mɛ́ɛ gbekanɛ Ludaa zikiroo? Kai! Baa, ǹton yã di mamↄma n zↄ̀bleriaro ke ma de bɛdeenↄ, zaakɛ má yãke dↄ̃ yã pì musuro pátipati. ");
INSERT INTO bus_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","Ben kí bènɛ: Nɛ́ gamɛ, mpi kↄ̃n n de bɛdeenↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","Ben à ò dogari kɛ̀ aↄ̃ↄ kú gweenↄnɛ à bè: À fɛɛ à Dii gbã̀gbãrinↄ dɛdɛ, zaakɛ ń ↄↄ kú Dauda yãmmɛ. Aↄ̃ↄ à bàalɛna yã dↄ̃, ben aↄ̃ↄe omɛro. Mↄde à ìba pìnↄↄ e wezi wà ↄ sɛ̀ wà Dii gbã̀gbãri pìnↄ dɛ̀dɛro. ");
INSERT INTO bus_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","Ben kí bè Doɛginɛ: Ǹ fɛɛ ǹ sa'ori pìnↄ dɛdɛ. Ben à fɛ̀ɛ à ń dɛdɛ gↄ̃ↄ. À sa'o'utadari pìnↄ dɛ̀dɛ gↄ̃ↄn basiigↄ̃ asↄↄromɛ. ");
INSERT INTO bus_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","Ben Solu ɛ̀ara à sa'ori pìnↄ wɛ́tɛ Nↄbudeenↄ dɛ̀dɛ dↄ, gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄ kↄ̃n nɛ́ gbãaanↄ kↄ̃n nɛ́kpãntɛ̃nↄ kↄ̃n zùnↄ kↄ̃n zaakinↄ kↄ̃n sãanↄ. Wà ń dɛdɛ kↄ̃n fɛ̃ɛdaao ń píngi. ");
INSERT INTO bus_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","Ben Aimɛlɛki nɛ́ ke pìtińgu, à tↄ́n Abiata. À bàa lɛ̀ à gàa à nà Daudaa. ");
INSERT INTO bus_vpl VALUES ("S122_21","010_22_21","1SA","22","21","21","À bè Daudanɛ, Solu Dii gbã̀gbãrinↄ dɛ̀dɛ ń píngi. ");
INSERT INTO bus_vpl VALUES ("S122_22","010_22_22","1SA","22","22","22","Ben Dauda bènɛ: Kɛ̀ ma Ɛdↄmu bori Doɛgi è gwe zĩ beeea, má dↄ̃ sãnsãn kɛ̀ eé o Solunɛ. Ma yãnzin wà n de bɛdeenↄ dɛ̀dɛzi ń píngi. ");
INSERT INTO bus_vpl VALUES ("S122_23","010_22_23","1SA","22","23","23","Ǹgↄ̃ kúmao. Ǹton tó vĩa n kũro. Gbɛ̃ kɛ̀ èe n wɛtɛɛ à n dɛɛ e ma wɛtɛɛ à ma dɛmɛ se. Yãke é n le ma kiiaro. ");
INSERT INTO bus_vpl VALUES ("S123_1","010_23_1","1SA","23","1","1","Wà ò Daudanɛ wà bè: Ǹ gwa, Filisitininↄↄ e zĩ̀ kaa kↄ̃n Kɛiladeenↄ, aↄ̃ↄe ń pↄ́wɛɛnↄ naakↄ̃a. ");
INSERT INTO bus_vpl VALUES ("S123_2","010_23_2","1SA","23","2","2","Ben Dauda gbèka Diia à bè: Mà gá mà lɛ́ɛ Filisitini pìnↄan yↄ́? Ben Dii bènɛ: Ǹ gá ǹ lɛ́ɛḿma ǹ Kɛiladeenↄ mì sí. ");
INSERT INTO bus_vpl VALUES ("S123_3","010_23_3","1SA","23","3","3","Ben Dauda gbɛ̃nↄ bènɛ: Lán vĩa e wa kũu Yudanↄ bùsu kɛ̀n nà, wé fↄ̃ wà gá wà zĩ̀ ká kↄ̃n Filisitininↄ Kɛilaↄ́? ");
INSERT INTO bus_vpl VALUES ("S123_4","010_23_4","1SA","23","4","4","Dauda ɛ̀ara à gbèka Diia dↄ, ben Dii bènɛ: Ǹ fɛɛ ǹ gá Kɛila, zaakɛ mɛ́ Filisitininↄ nannɛ n ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("S123_5","010_23_5","1SA","23","5","5","Ben Dauda gàa Kɛila kↄ̃n a gbɛ̃nↄ, à zĩ̀ kà kↄ̃n Filisitininↄ, ben à ń pↄ́kãdeenↄ sìḿma. À Filisitininↄ dɛ̀dɛ paripari, ben à Kɛiladeenↄ mì sì. ");
INSERT INTO bus_vpl VALUES ("S123_6","010_23_6","1SA","23","6","6","Kɛ̀ Aimɛlɛki nɛ́ Abiata bàa lɛ̀ èe gaa Dauda kiia yã, à a sa'o'uta kũna, ben à gàao Kɛila. ");
INSERT INTO bus_vpl VALUES ("S123_7","010_23_7","1SA","23","7","7","Kɛ̀ Solu mà Dauda gàa Kɛila, à bè: Luda gìzimɛ, ben à à nàmɛ ma ↄzĩ, zaakɛ à a zĩnda tàta wɛ́tɛ bĩidee guumɛ. ");
INSERT INTO bus_vpl VALUES ("S123_8","010_23_8","1SA","23","8","8","Solu a zĩ̀kpɛɛnↄ kàkↄ̃a ń píngi, lɛ aↄ̃ gá Dauda kagura kɛ kↄ̃n à gbɛ̃nↄ zaa Kɛila. ");
INSERT INTO bus_vpl VALUES ("S123_9","010_23_9","1SA","23","9","9","Kɛ̀ Dauda mà Solu e à zaaa kpaakↄ̃sↄ̃azi, ben à bè sa'ori Abiatanɛ à mↄ́ kↄ̃n sa'o'utao. ");
INSERT INTO bus_vpl VALUES ("S123_10","010_23_10","1SA","23","10","10","Ben Dauda bè: Dii Isarailinↄ Luda, mapi n zↄ̀bleri má mà Solu e zɛ́ wɛtɛɛ à mↄ́ Kɛila à wɛ́tɛ kɛ̀ kaatɛ ma yãnzi. ");
INSERT INTO bus_vpl VALUES ("S123_11","010_23_11","1SA","23","11","11","Kɛiladeenↄ é ma kpáan yↄ́? Solu é mↄ́ kɛ̀ lán má mà nàn yↄ́? Dii Isarailinↄ Luda, ǹ o mamↄma n zↄ̀blerinɛ. Ben Dii bènɛ: Eé mↄ́. ");
INSERT INTO bus_vpl VALUES ("S123_12","010_23_12","1SA","23","12","12","Ben Dauda à là dↄ: Kɛiladeenↄ é ma kpáa kↄ̃n ma gbɛ̃nↄn yↄ́? Ben Dii bè: Aↄ̃é a kpáamɛ. ");
INSERT INTO bus_vpl VALUES ("S123_13","010_23_13","1SA","23","13","13","Ben Dauda kↄ̃n a gbɛ̃nↄ fɛ̀ɛ, aↄ̃ kà gↄ̃ↄn wàa aagↄ̃ taka bà. Kɛ̀ aↄ̃ bↄ̀ Kɛila, ben aↄ̃ↄe sↄ̃ki kpákpaa. Kɛ̀ Solu mà Dauda bↄ̀ Kɛila, èe gà à gàa gwe dↄro. ");
INSERT INTO bus_vpl VALUES ("S123_14","010_23_14","1SA","23","14","14","Dauda kú zɛki gbãaan gbáan Zifi bùsu sĩ̀sĩdeen. Lán guu e dↄↄ nà Solu ègↄ̃ à wɛtɛɛ à dɛ, mↄde Ludaa e Dauda nanɛ à ↄzĩro. ");
INSERT INTO bus_vpl VALUES ("S123_15","010_23_15","1SA","23","15","15","Gurↄↄ kɛ̀ Dauda kú Zifi bùsu líkpɛn, à mà Solu kↄ̃n à gbɛ̃nↄↄ e mↄↄ a dɛ. ");
INSERT INTO bus_vpl VALUES ("S123_16","010_23_16","1SA","23","16","16","Ben Solu nɛ́ Yonatã fɛ̀ɛ à gàa à Dauda lè zaa líkpɛ pìn, à à gbà swɛ̃̀ kↄ̃n Luda tↄ́o. ");
INSERT INTO bus_vpl VALUES ("S123_17","010_23_17","1SA","23","17","17","À bènɛ: Ǹton tó vĩa n kũro, zaakɛ ma de é e à ↄ nammaro. Ḿbe nɛ́ kí ble Isarailinↄnɛ, mapi sↄ̃ mɛ́gↄ̃ dɛ n plaadee ũ. Ma de pì beee dↄ̃ se. ");
INSERT INTO bus_vpl VALUES ("S123_18","010_23_18","1SA","23","18","18","Ben aↄ̃ yã yì kↄ̃o ń plaa Dii aɛ. Dauda gↄ̃̀ líkpɛn gwe, ben Yonatã tà bɛ. ");
INSERT INTO bus_vpl VALUES ("S123_19","010_23_19","1SA","23","19","19","Beee gbɛra Zifideenↄ gàa wà Solu lè Gibɛa aↄ̃ bè: Dauda utɛna wa bùsun sɛ̃̀tɛ pↄ̀rↄtu. À kú líkpɛn Akila sĩ̀sĩgɛɛzi Yɛsimↄ sↄↄmɛtɛ kpa. ");
INSERT INTO bus_vpl VALUES ("S123_20","010_23_20","1SA","23","20","20","Kí, gurↄↄ kɛ̀ ń yezi píngi, ǹ mↄ́ gwe, wé à kpámma. ");
INSERT INTO bus_vpl VALUES ("S123_21","010_23_21","1SA","23","21","21","Ben Solu bè: Dii aubarika daagu kɛ̀ a ma wɛ̃nda gwà yãnzi. ");
INSERT INTO bus_vpl VALUES ("S123_22","010_23_22","1SA","23","22","22","À tá à ɛara à soru kɛ. À guu kɛ̀ è gán gbekagbeka kↄ̃n gbɛ̃ kɛ̀ aↄ̃ à ènↄ, zaakɛ má mà wà bè, à ↄ̃ndↄ̃ↄ nɛ́ ↄ̃ndↄ̃ↄnlo. ");
INSERT INTO bus_vpl VALUES ("S123_23","010_23_23","1SA","23","23","23","À gbekagbeka lɛ à e à à utɛkiinↄ dↄ̃ píngi, à ɛara à mↄ́ à ma le, lɛ mà à sãnsãn ma, mɛ́ gáao. Tó à kú a bùsun gwemɛ, mɛ́ pɛ́ɛzi Yuda boriinↄ tɛ́ píngi. ");
INSERT INTO bus_vpl VALUES ("S123_24","010_23_24","1SA","23","24","24","Ben aↄ̃ dà zɛ́n, aↄ̃ dↄ̀ Solunɛ aɛ gana Zifi. Àɛ sↄ̃ Dauda kↄ̃n a gbɛ̃nↄ gĩakɛ wà kú Maↄni gbáan sɛ̃̀tɛ Yɛsimↄ sↄↄmɛtɛ kpa. ");
INSERT INTO bus_vpl VALUES ("S123_25","010_23_25","1SA","23","25","25","Kɛ̀ Solu kↄ̃n a gbɛ̃nↄↄ e mↄↄ pɛ́ɛzi, à à baaru mà, ben à pìta kpiii pìa à gàa à kú Maↄni gbáan. Kɛ̀ Solu mà, ben à pɛ̀ɛzi Maↄni gbáan gwe. ");
INSERT INTO bus_vpl VALUES ("S123_26","010_23_26","1SA","23","26","26","Solunↄ e táa oo kpiii kpɛɛ kãa kpa, Daudanↄ e táa oo à kpɛɛ kɛ̀ kpa, aↄ̃ↄe wãa aↄ̃ↄe bàa lɛɛ Solunɛ. Gurↄↄ kɛ̀ Solu kↄ̃n a gbɛ̃nↄↄ e ligaa Daudanↄzi aↄ̃ ń kũ, ");
INSERT INTO bus_vpl VALUES ("S123_27","010_23_27","1SA","23","27","27","ben gbɛ̃ke mↄ̀ à baaru kpà Solunɛ à bè: Ǹ kɛ kpakpaa, Filisitininↄ mↄ̀ wà lɛ̀ɛ wa bùsua. ");
INSERT INTO bus_vpl VALUES ("S123_28","010_23_28","1SA","23","28","28","Ben Solu pɛɛna Daudazi tò, à gàa Filisitininↄ le. Beee yãnzi wè guu pì sísi Kↄ̃kpaatɛkpiii. ");
INSERT INTO bus_vpl VALUES ("S123_29","010_23_29","1SA","23","29","29","Beee gbɛra Dauda bↄ̀ gwe à gàa à vɛ̃̀ɛ sɛ̃̀tɛ pↄ̀rↄtu, guu kɛ̀ wè sísi Ɛngɛdi. ");
INSERT INTO bus_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","Kɛ̀ Solu sù kↄ̃n pɛɛna Filisitininↄzio, wà bènɛ Dauda kú Ɛngɛdi gbáan. ");
INSERT INTO bus_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","Ben à Isaraili zĩ̀kpɛɛnↄ sɛ̀ɛ gↄ̃ↄn bↄrↄ aagↄ̃ à dàńyo zɛ́n, lɛ aↄ̃ Daudanↄ wɛtɛ guu kɛ̀ wè sísi Zↄ̃nↄ Gbɛ̀a. ");
INSERT INTO bus_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","Kɛ̀ à kà sãanↄ kara kɛ̀ kú zɛ́ saɛ kiia, à gbɛ̀wɛɛ è gwe, ben à gɛ̃̀n à gàa dↄzɛzi kɛ. Dauda kↄ̃n a gbɛ̃nↄ sↄ̃ↄ kú gbɛ̀wɛɛ pìn zaa à lɛ́zɛkiia. ");
INSERT INTO bus_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","Ben Dauda gbɛ̃nↄ bènɛ: Ǹ gwa, à gurↄↄn gbã̀a kɛ̀ Dii bè é n ibɛɛ nannɛ n ↄzĩ ǹ yã kɛnɛ lán ń yezi nà. Ben Dauda fɛ̀ɛ tɛɛɛ, à Solu utagumusu lɛ́ zↄ̃̀ à saɛ. ");
INSERT INTO bus_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","À gbɛra Dauda gɛ̃̀ laasuun Solu uta lɛ́ kɛ̀ à zↄ̃̀ pì yãnzi, ");
INSERT INTO bus_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","à bè a gbɛ̃nↄnɛ: Kai! Dii tón tó mà yã beee taka kɛ ma dii kɛ̀ à à kpànɛro. Mɛ́ ↄ naaro, zaakɛ Dii bé à à kpà kpatan. ");
INSERT INTO bus_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","Dauda kpã̀kɛ̃ a gbɛ̃nↄzi kↄ̃n yã pìo, èe tó aↄ̃ Solu dɛ̀ro. Kɛ̀ Solu bↄ̀ gbɛ̀wɛɛn, èe gɛ̃ɛ zɛ́la, ");
INSERT INTO bus_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","ben Dauda bↄ̀ gbɛ̀wɛɛ pìn, à lɛ́ zùzi à bè: Ma dii kí! Kɛ̀ Solu lìɛ à a kpɛɛ gwà, ben Dauda kùɛ à dàɛ a puua. ");
INSERT INTO bus_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","Ben à bè Solunɛ: Tó wà bè ma yã zaaa kpàkpa n musu, bↄ́ yã bé à tò nɛɛ̀ síi? ");
INSERT INTO bus_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","Ǹ gwa! N wɛ́ɛ è gbã̀a lán Dii n namɛ ma ↄzĩ nà gbɛ̀wɛɛn. Wà bèmɛ mà n dɛ, ben ma n wɛ̃nda gwà, ma bè mɛ́ ↄ na ma diiaro, zaakɛ Dii bé à à kpà kpatan. ");
INSERT INTO bus_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","Ǹ gwa kɛ̀ Baa! Ǹ gwa, má n uta lɛ́ kũna kɛ̀! Ma n uta lɛ́ zↄ̃̀, mↄde mɛ́ɛ n dɛro. Ń dↄ̃̀ sa kɛ̀ má n kũna kↄ̃n nↄ̀sɛ zaaaoro. Mɛ́ɛ taari kɛnnɛro, ben nɛ́ɛ ma wɛtɛɛ ǹ ma dɛ. ");
INSERT INTO bus_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","Dii yã gↄ̃gↄ̃we à gɛ̃ɛ bommamɛ, mↄde mapi mɛ́ ↄ nammaro. ");
INSERT INTO bus_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","Lán wà yáasi zù zaa zi nà wà bè, yã zaaa è bↄ zaakɛrinↄ kiiamɛ, mɛ́ ↄ nammaro. ");
INSERT INTO bus_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","N Isarailinↄ kína, dé yãnzin n bↄzi? Dén nɛ́ɛ pɛ́ɛzi? Gbɛ̃ɛ gɛ̀n yↄ́? Ke kↄ̀kↄ nɛ́ngo? ");
INSERT INTO bus_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","Dii ma yã gwa à yã gↄ̃gↄ̃we. À yã nnaa kpáma à zɛmao à ma bↄ n ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","Kɛ̀ Dauda yã beee ò Solunɛ à yã̀a, Solu bè: Ma nɛ́ Dauda, n kòton gweↄ́? Ben Solu vĩ̀ wiiio ");
INSERT INTO bus_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","à bè Daudanɛ: N yã nnaa dɛmala, zaakɛ yã zaaan má kɛ̀nnɛ, ben n fĩa bòmɛ kↄ̃n à maaao. ");
INSERT INTO bus_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","N yã maaa kɛ̀ ń kɛ̀mɛɛ ò tia. Kɛ̀ Dii ma nannɛ n ↄzĩ, nɛ́ɛ ma dɛro. ");
INSERT INTO bus_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","Tó gbɛ̃ bↄ̀ a ibɛɛa, è tó à tá aafiaↄ́? Dii yã maaa kɛ̀ ń kɛ̀mɛ gbã̀a fĩa bonnɛ. ");
INSERT INTO bus_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","Má dↄ̃ sa kɛ̀ nɛ́ gↄ̃ kí ũ, nɛ́gↄ̃ kí blee Isarailinↄnɛ. ");
INSERT INTO bus_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","Ǹ símɛ kↄ̃n Dii tↄ́o kɛ̀ nɛ́ ma borii kaatɛro, nɛ́ ma tↄ́ dɛ ma de bɛdeenↄ tɛ́ro. ");
INSERT INTO bus_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","Ben Dauda la dà Solunɛ. Kɛ̀ Solu tà bɛ, ben Dauda kↄ̃n a gbɛ̃nↄ ɛ̀ara wà tà sɛ̃̀tɛ pↄ̀rↄtu. ");
INSERT INTO bus_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","Samuɛli gà, ben Isarailinↄ kàkↄ̃a ń píngi, aↄ̃ↄe ↄ́ↄ dↄↄ à gaa musu, ben wà à vĩ̀i a bɛ zaa Rama. Beee gbɛra Dauda gàa Parani sɛ̃̀tɛ. ");
INSERT INTO bus_vpl VALUES ("S125_2","010_25_2","1SA","25","2","2","Maↄni gbɛ̃kee kuu, à bↄkↄ̃tɛ vĩ Kamɛli gwe. Auzikide sàmɛ, à sãanↄ vĩ bↄrↄ aagↄ̃ kↄ̃n blènↄ wàa sↄↄro. Ben à mↄ̀ Kamɛli lɛ à a sãanↄ kã kɛ̃ɛ. ");
INSERT INTO bus_vpl VALUES ("S125_3","010_25_3","1SA","25","3","3","À tↄ́n Nabala, à naↄ̃ tↄ́n Abigaili. Nↄgbɛ̃ pì làakari vĩ bensↄ̃ à kakana maa, mↄde à gↄ̃ↄ pì gbɛ̃ke wí vĩro, à yãkɛnanↄↄ dↄ̀rↄ vĩro. Kalɛbu boriimɛ. ");
INSERT INTO bus_vpl VALUES ("S125_4","010_25_4","1SA","25","4","4","Gurↄↄ kɛ̀ Dauda kú sɛ̃̀tɛ, à mà Nabala mↄ̀ a sãanↄ kã kɛ̃ɛ. ");
INSERT INTO bus_vpl VALUES ("S125_5","010_25_5","1SA","25","5","5","Ben à a ìbanↄ zĩ̀ gↄ̃ↄn kuri à bèńnɛ: À fɛɛ à gá Nabala kiia zaa Kamɛli, à ì kpáamɛ ");
INSERT INTO bus_vpl VALUES ("S125_6","010_25_6","1SA","25","6","6","à onɛ à be: Luda n dↄ̃ aafiao kↄ̃n n uao kↄ̃n n gbɛ̃nↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("S125_7","010_25_7","1SA","25","7","7","Má mà n mↄ kↄ̃n sãkãkɛ̃ɛrinↄ. Kɛ̀ n sãdãrinↄↄ kúwao, wée ĩa daḿmaro, ń kuuna Kamɛli guu, pↄ́kee e kɛ̃sãḿmaro. ");
INSERT INTO bus_vpl VALUES ("S125_8","010_25_8","1SA","25","8","8","Ǹ n zĩkɛri pìnↄ la, aↄ̃é onnɛ. Ǹ tó ma ìbanↄ n pↄnnaa e, zaakɛ zĩbaa zĩmɛ. N zↄ̀bleri pìnↄ kↄ̃n mamↄma n nɛ́o ǹ wa gba pↄ́ kɛ̀ ń è. ");
INSERT INTO bus_vpl VALUES ("S125_9","010_25_9","1SA","25","9","9","Kɛ̀ Dauda ìba pìnↄ kà, aↄ̃ yã pì tↄ̃kɛ̃̀ Nabalanɛ kↄ̃n Dauda tↄ́o, ben aↄ̃ sↄ̃̀kpazi. ");
INSERT INTO bus_vpl VALUES ("S125_10","010_25_10","1SA","25","10","10","Ben Nabala bèńnɛ: Dén Dauda ũu? Dén Yɛsɛ nɛ́ pì ũu? Zↄ̀ kɛ̀ aↄ̃ kɛ̃̀ n diinↄa gbã̀anↄↄ pari. ");
INSERT INTO bus_vpl VALUES ("S125_11","010_25_11","1SA","25","11","11","Á yezi mà a burɛdi kↄ̃n ma ío kↄ̃n nↄ̀bↄ kɛ̀ má dɛ̀ ma sãkãkɛ̃ɛrinↄnɛo sɛ́ɛ mà kpá gbɛ̃ kɛ̀ má ń bↄkii dↄ̃roonↄan yↄ́? ");
INSERT INTO bus_vpl VALUES ("S125_12","010_25_12","1SA","25","12","12","Ben Dauda gbɛ̃nↄ ɛ̀ara wà dà zɛ́n aↄ̃ tà. Kɛ̀ aↄ̃ kà, aↄ̃ yã pìnↄ gbã̀nɛ píngi. ");
INSERT INTO bus_vpl VALUES ("S125_13","010_25_13","1SA","25","13","13","Ben Dauda bè a gbɛ̃ pìnↄnɛ: A baade a fɛ̃ɛdaa logo. Ben ń baade a fɛ̃ɛdaa lògo kↄ̃n Daudao se. Gbɛ̃ kɛ̀ aↄ̃ gàa kↄ̃n Daudaonↄ kà wàa plaa taka, ben gↄ̃ↄn wàa doo gↄ̃̀ kↄ̃n asoonↄ. ");
INSERT INTO bus_vpl VALUES ("S125_14","010_25_14","1SA","25","14","14","À mↄ̀ à lè zĩkɛri pìnↄ doke gàa à ò Nabala naↄ̃ Abigailinɛ à bè: Dauda gbɛ̃nↄ zĩ̀ aↄ̃ bↄ̀ sɛ̃̀tɛ aↄ̃ mↄ̀ wà ì kpà wa diia, ben à pàtaḿma. ");
INSERT INTO bus_vpl VALUES ("S125_15","010_25_15","1SA","25","15","15","Gbɛ̃ pìnↄ sↄ̃ yã maaa kɛ̀we maamaa, aↄ̃ↄe ĩa dawaro. Kɛ̀ wá kúńyo sɛ̃̀tɛ, pↄ́ke è sãsãwaro. ");
INSERT INTO bus_vpl VALUES ("S125_16","010_25_16","1SA","25","16","16","Gurↄↄ kɛ̀ wée sãa dãa ń saɛ fãantɛ̃ kↄ̃n gwãavĩo píngi, aↄ̃ègↄ̃ ligawazi lán bĩi bà. ");
INSERT INTO bus_vpl VALUES ("S125_17","010_25_17","1SA","25","17","17","Ǹ laasuu lɛ́ yã kɛ̀ nɛ́ kɛɛa, zaakɛ aↄ̃ zɛ̀o wà yã zaaa kɛ wa diinɛ kↄ̃n à uadeenↄ ń píngi. Àpi maaro, è gbɛ̃ lɛ́damma síro. ");
INSERT INTO bus_vpl VALUES ("S125_18","010_25_18","1SA","25","18","18","Ben Abigaili burɛdi nàkↄ̃a kpakpaa mɛ̀n wàa do kↄ̃n geepiwɛ̃ɛo tùu plaa kↄ̃n sãa kɛ̀ wà kɛ̀kɛnↄ mɛ̀n sↄↄro kↄ̃n pↄ́wɛɛ kpatanao kpɛ̃ɛ sↄↄro kↄ̃n geepi kàranↄ mɛ̀n basↄↄro kↄ̃n kãkã bɛ kori kàranↄ mɛ̀n wàa do, aↄ̃ↄ yì zaakinↄnɛ. ");
INSERT INTO bus_vpl VALUES ("S125_19","010_25_19","1SA","25","19","19","Ben à bè a zĩkɛrinↄnɛ: Àgↄ̃ dↄↄ aɛ, mɛ́gↄ̃ tɛ́ a kpɛɛ. Èe yãke o a zã Nabalanɛro. ");
INSERT INTO bus_vpl VALUES ("S125_20","010_25_20","1SA","25","20","20","Ben à di a zaakia, èe pitaa sĩ̀sĩa. Kɛ̀ à bↄ̀ sĩ̀sĩ kpɛɛ, aↄ̃ dàkↄ̃rɛ Daudao, èe pitaa sĩ̀sĩa se kↄ̃n à gbɛ̃nↄ, aↄ̃ↄe mↄↄ. ");
INSERT INTO bus_vpl VALUES ("S125_21","010_25_21","1SA","25","21","21","Dauda e oo a gbɛ̃nↄnɛ: Ma gbɛ̃ pì pↄ́nↄ dã̀kpanɛ sɛ̃̀tɛ pãmɛ. Wée à pↄ́ke sɛ́ro, ben à yã maaa kɛ̀ má kɛ̀nɛ fĩa bòmɛ kↄ̃n à zaaao. ");
INSERT INTO bus_vpl VALUES ("S125_22","010_25_22","1SA","25","22","22","Tó ma à gↄ̃gbɛ̃ ke tò bɛ̃ɛ ai guu gↄ̃ gá dↄ, Luda yã kɛmɛ pãsĩpãsĩ. ");
INSERT INTO bus_vpl VALUES ("S125_23","010_25_23","1SA","25","23","23","Kɛ̀ Abigaili à è, ben à pìta a zaakia kpakpaa, à kùɛ Daudanɛ à aɛ pɛ̀ɛ. ");
INSERT INTO bus_vpl VALUES ("S125_24","010_25_24","1SA","25","24","24","Ben à kùɛ à gbá saɛ à bè: Baa, taari pì gↄ̃̀ ma mɛ̀n do musu. Ǹ mamↄma n zↄ̀bleri gba zɛ́ mà yã onnɛ. Ǹ swã kpá mamↄma n zↄ̀bleri yãzi. ");
INSERT INTO bus_vpl VALUES ("S125_25","010_25_25","1SA","25","25","25","Baa, Nabala maaro. Ǹton à yã daro. À yãnↄↄ dɛ lán a tↄ́ bàmɛ. À tↄ́n Mìsaide, bensↄ̃ mìsaiyãn ègↄ̃ kɛɛ. Mamↄma n zↄ̀bleri sↄ̃, mɛ́ɛ gbɛ̃ kɛ̀ n ń zĩnↄ ero. ");
INSERT INTO bus_vpl VALUES ("S125_26","010_25_26","1SA","25","26","26","Baa, lán Dii kuu bensↄ̃ ń kuu nà, Dii gìnnɛ ǹ gbɛ̃ dɛ ǹ gɛ̃ɛ bo n zĩnda. Dii tó n ibɛɛnↄ kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄe n kpákpaa à zaaaonↄ gↄ̃ lán Nabala bà. ");
INSERT INTO bus_vpl VALUES ("S125_27","010_25_27","1SA","25","27","27","Tia sa Baa, ǹ gbaa kɛ̀ mamↄma n zↄ̀bleri ma mↄonnɛɛ kɛ̀ sí ǹ kpá n ìbanↄa. ");
INSERT INTO bus_vpl VALUES ("S125_28","010_25_28","1SA","25","28","28","Ǹ sùu kɛ kↄ̃n mamↄma n zↄ̀blerio kↄ̃n ma taario dↄ. Dii é tó n boriinↄ gↄ̃ kí blee ai gurↄ píngi, zaakɛ nɛɛ̀ zĩ̀ ká Diinɛmɛ, weé à zaa ke emma zikiro. ");
INSERT INTO bus_vpl VALUES ("S125_29","010_25_29","1SA","25","29","29","Baa tó gbɛ̃ke fɛ̀ɛ èe pɛɛɛnzi à n dɛ, Dii n Luda é n wɛ̃̀ndi dãkpa, eé n ibɛɛnↄ wɛ̃̀ndi da gbɛ̀mban à zu. ");
INSERT INTO bus_vpl VALUES ("S125_30","010_25_30","1SA","25","30","30","Baa, tó Dii yã maaa kɛ̀nnɛ lán à lɛ́ gbɛ̃̀nnɛ nà píngi, tó à n diɛ Isarailinↄ gbɛ̃nsi ũ, ");
INSERT INTO bus_vpl VALUES ("S125_31","010_25_31","1SA","25","31","31","ǹton gɛ̃ laasuun à n da yãn gbɛ̃dɛna pã ke gɛ̃ɛbona n zĩndanɛ yã musuro. Baa, tó Dii yã maaa kɛ̀nnɛ, ǹ tó mamↄma n zↄ̀bleri ma yã gↄ̃ dↄngu. ");
INSERT INTO bus_vpl VALUES ("S125_32","010_25_32","1SA","25","32","32","Ben Dauda bè Abigailinɛ: Wà Dii Isarailinↄ Luda sáabu kpá, zaakɛ à n zĩ ǹ damalɛ gbã̀a. ");
INSERT INTO bus_vpl VALUES ("S125_33","010_25_33","1SA","25","33","33","Ma n sáabu kpà se kↄ̃n lɛ́damma kɛ̀ n ma gbaao, zaakɛ ḿbe n kpamɛ gbã̀a, ben mɛ́ɛ gbɛ̃ dɛ ma gɛ̃ɛ bò ma zĩndanɛro. ");
INSERT INTO bus_vpl VALUES ("S125_34","010_25_34","1SA","25","34","34","Tó beeenlo, kↄ̃n Dii Isarailinↄ Luda kɛ̀ gìmɛ mà yã zaaa kɛnnɛɛo, tó nɛ́ɛ wã n mↄ n damalɛ yãro, lɛ guu é dↄ Nabala nɛ́gↄ̃gbɛ̃ kearo. ");
INSERT INTO bus_vpl VALUES ("S125_35","010_25_35","1SA","25","35","35","Ben Dauda pↄ́ kɛ̀ Abigaili mↄ̀onɛ sì à bè: Ǹ ká bɛ aafia. Ma n yã mà, ma n yodaado kɛ̀. ");
INSERT INTO bus_vpl VALUES ("S125_36","010_25_36","1SA","25","36","36","Kɛ̀ Abigaili kà Nabala kiia, à è èe pↄ́ blee lán kína bà. À pↄↄ kɛ̀ nna, à wɛ̃ɛ gbɛ̃̀ à kã̀. Ben à naↄ̃ pì e lɛ́ bↄ à yãke ònɛro, sé kɛ̀ guu dↄ̀. ");
INSERT INTO bus_vpl VALUES ("S125_37","010_25_37","1SA","25","37","37","Kɛ̀ guu dↄ̀, Nabala wɛ́ɛ kɛ̃̀, ben à naↄ̃ yã kɛ̀ à kɛ̀ pì ònɛ. Ben swɛ̃̀ kɛ̃̀n, à gↄ̃̀ lán gbɛ̀ bà. ");
INSERT INTO bus_vpl VALUES ("S125_38","010_25_38","1SA","25","38","38","Kɛ̀ à kɛ̀ lán gurↄ kuri bà, ben Dii gò tↄ̃̀a, à gà. ");
INSERT INTO bus_vpl VALUES ("S125_39","010_25_39","1SA","25","39","39","Kɛ̀ Dauda Nabala gana baaru mà, à bè: Wà Dii kɛ̀ zɛ̀mao sáabu kpá, à wí kɛ̀ Nabala dàmaa bↄ̀mɛ. À gìmɛ mà yã zaaa kɛ, ben à tò Nabala zaakɛna wì à zĩnda musu. Beee gbɛra Dauda gbɛ̃nↄ zĩ̀ Abigailia aↄ̃ onɛ á yezi à à sɛ́ nↄↄ ũ. ");
INSERT INTO bus_vpl VALUES ("S125_40","010_25_40","1SA","25","40","40","Kɛ̀ Dauda ìba pìnↄ kà Abigaili kiia zaa Kamɛli, aↄ̃ bènɛ: Dauda bé à wa zĩmma, à yezi à n sɛ́ nↄↄ ũ. ");
INSERT INTO bus_vpl VALUES ("S125_41","010_25_41","1SA","25","41","41","Ben à fɛ̀ɛ à kùɛ à a mì pɛ̀ɛ à bè: À zↄ̀blerin ma ũ, má yãana mà a dii ìbanↄ gbá pípińnɛ. ");
INSERT INTO bus_vpl VALUES ("S125_42","010_25_42","1SA","25","42","42","Ben à fɛ̀ɛ à dì zaakia gↄ̃ↄ. À nↄgbɛ̃ zĩkɛrinↄ gàao gↄ̃ↄn sↄↄro. Aↄ̃ dà zɛ́n kↄ̃n Dauda zĩ̀rinↄ, ben à gↄ̃̀ à nↄↄ ũ. ");
INSERT INTO bus_vpl VALUES ("S125_43","010_25_43","1SA","25","43","43","Dauda Yɛzɛrili gbɛ̃ Ainↄama kũna nↄↄ ũ dↄ. Aↄ̃ plaa ń píngi kɛ̀ à nↄↄnↄ ũ. ");
INSERT INTO bus_vpl VALUES ("S125_44","010_25_44","1SA","25","44","44","Solu a nɛ́ Mikala kɛ̀ dɛ Dauda nↄↄ ũ yãa kpà Laisi nɛ́ Palatiɛli, Galimu gbɛ̃a. ");
INSERT INTO bus_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","Zifideenↄ gàa wà Solu lè Gibɛa aↄ̃ bènɛ: Dauda utɛna Akila sĩ̀sĩgɛɛzi kɛ̀ aɛdↄna Yɛsimↄa. ");
INSERT INTO bus_vpl VALUES ("S126_2","010_26_2","1SA","26","2","2","Ben Solu gàa Zifi sɛ̃̀tɛ kↄ̃n Isaraili zĩ̀kpɛɛnↄ gↄ̃ↄn bↄrↄ aagↄ̃, aↄ̃ↄe Dauda wɛtɛɛ wà à dɛ sɛ̃̀ pìn. ");
INSERT INTO bus_vpl VALUES ("S126_3","010_26_3","1SA","26","3","3","Solu bùra kàɛ zɛ́ saɛ Akila sĩ̀sĩgɛɛ kɛ̀ aɛdↄna Yɛsimↄa, ben Dauda kú sɛ̃̀n. Kɛ̀ à mà Solu e pɛɛɛazi, ");
INSERT INTO bus_vpl VALUES ("S126_4","010_26_4","1SA","26","4","4","ben à gu'asiigwarinↄ zĩ̀, gbasa à dↄ̃̀ sa kɛ̀ Solu kà. ");
INSERT INTO bus_vpl VALUES ("S126_5","010_26_5","1SA","26","5","5","Ben Dauda fɛ̀ɛ à gàa guu kɛ̀ Solu bùra kàɛn. À Solu kↄ̃n a zĩ̀kpɛɛnↄ gbɛ̃nsi Nɛrɛ nɛ́ Abanao daɛkii è. Solu daɛna bùra guu, à gbɛ̃nↄ kàɛ wà ligazi. ");
INSERT INTO bus_vpl VALUES ("S126_6","010_26_6","1SA","26","6","6","Ben Dauda Iti bori Aimɛlɛki kↄ̃n Zeruya nɛ́ Abisaio là à bè: Dé bé eé gámao bùra pìn Solu kiia? Ben Abisai bènɛ: Mámbe mɛ́ gányo. ");
INSERT INTO bus_vpl VALUES ("S126_7","010_26_7","1SA","26","7","7","Kɛ̀ Dauda kↄ̃n Abisaio lↄↄtɛ̀ gbɛ̃ pìnↄzi gwãavĩ, ben aↄ̃ Solu è daɛna, èe ii oo bùra guu, à sári pɛɛna à mìzi. Abana kↄ̃n a gbɛ̃nↄↄ daɛna wà ligazi ń píngi. ");
INSERT INTO bus_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","Ben Abisai bè Daudanɛ: Luda n ibɛɛ nànnɛ n ↄzĩ gbã̀a. Ǹ tó mà à zↄ̃ kↄ̃n sário mà à nakↄ̃a kↄ̃n tↄↄtɛo. Mɛ́ à zↄ̃ gɛ̃̀n domɛ, èe kɛ gɛ̃̀n plaanlo. ");
INSERT INTO bus_vpl VALUES ("S126_9","010_26_9","1SA","26","9","9","Ben Dauda bènɛ: Ǹton à dɛro. Dé bé eé fↄ̃ à ↄ na kína kɛ̀ Dii kàa à bↄ pãa? ");
INSERT INTO bus_vpl VALUES ("S126_10","010_26_10","1SA","26","10","10","Ben Dauda ɛ̀ara à bè: Dii kuu! Dii bé eé gò tↄ̃a à ga, tó à gurↄↄ pàpa kesↄ̃ à gà zĩ̀lan. ");
INSERT INTO bus_vpl VALUES ("S126_11","010_26_11","1SA","26","11","11","Kai! Dii tón tó mà ↄ na kína kɛ̀ à kàaro. Wà gá wà sári kɛ̀ kú à mìzi sɛ́ kↄ̃n à í zɛ̀rɛo wà táo. ");
INSERT INTO bus_vpl VALUES ("S126_12","010_26_12","1SA","26","12","12","Dauda sári kↄ̃n í zɛ̀rɛ kɛ̀ kú Solu mìzio sɛ̀, ben aↄ̃ tào. Aↄ̃ gbɛ̃kee e ń ero, aↄ̃ ń yã dↄ̃ro, aↄ̃ↄe ii oo ń píngi. Aↄ̃ gbɛ̃kee e vuro, zaakɛ Dii bé à tò i ìsi dàńla. ");
INSERT INTO bus_vpl VALUES ("S126_13","010_26_13","1SA","26","13","13","Kɛ̀ Dauda bikũ̀ guzurɛ baa kãa kpa, ben à zɛ̀ sĩ̀sĩ musu zã̀azã, gu yàasa dana ń dagura. ");
INSERT INTO bus_vpl VALUES ("S126_14","010_26_14","1SA","26","14","14","Ben à lɛ́ zù Abanazi kↄ̃n a gbɛ̃nↄ à bè: Abanaooo! Ń yĩtɛnan yↄ́? Abana wèàla à bè: Dé bé èe lɛ́ zuu kínazi? ");
INSERT INTO bus_vpl VALUES ("S126_15","010_26_15","1SA","26","15","15","Dauda bènɛ: Gↄ̃sagbãaan n ũroo? Gbɛ̃ke kà lán n bà Isarailinↄ bùsunn yↄ́? Gbɛ̃ke mↄ̀ n dii kína dɛ. Bↄ́ yã bé à tò nɛ́ɛ à dãkparoo? ");
INSERT INTO bus_vpl VALUES ("S126_16","010_26_16","1SA","26","16","16","Nɛ́ɛ yã kɛ a zɛ́aro. Má sì kↄ̃n Diio a kↄ̃ sìo wà a dɛdɛmɛ, zaakɛ ée a dii kína kɛ̀ Dii kpà kpatan dãkparo. Ǹ gwa! Kí sári kↄ̃n à í zɛ̀rɛ kɛ̀ kú à mìzio kú mámɛ? ");
INSERT INTO bus_vpl VALUES ("S126_17","010_26_17","1SA","26","17","17","Solu Dauda kòto dↄ̃̀, ben à bè: Dauda ma nɛ́, n kòton gweↄ́? À wèàla à bè: Ma dii kí, ma kòtomɛ. ");
INSERT INTO bus_vpl VALUES ("S126_18","010_26_18","1SA","26","18","18","Dauda ɛ̀ara à bè: Bↄ́ yã bé à tò ma dii e pɛɛɛ mamↄma a zↄ̀bleriazi? Bↄ́n má kɛ̀? Bↄ́ taarin má kɛ̀? ");
INSERT INTO bus_vpl VALUES ("S126_19","010_26_19","1SA","26","19","19","Ma dii kí, ǹ swã kpá mamↄma n zↄ̀bleri yãzi sa. Tó Dii bé à n swi kɛ̀ma, à ma sa'ona gũu ma. Tó gbɛ̃nteenↄmɛ sↄ̃, Dii láari kɛḿma, zaakɛ aↄ̃ pɛ̀ma wà ma bↄ Dii gbɛ̃nↄ tɛ́, aↄ̃ bè mà gá mà dↄ tãanↄzimɛ. ");
INSERT INTO bus_vpl VALUES ("S126_20","010_26_20","1SA","26","20","20","Ǹton tó wà ma dɛ zã̀ kↄ̃n Diioro. Isarailinↄ kína bↄ̀, èe kↄ̀kↄ nɛ́ngo wɛtɛ à dɛ, lán wègↄ̃ pɛɛ dↄ̃ↄa sĩ̀sĩnↄ musu nà. ");
INSERT INTO bus_vpl VALUES ("S126_21","010_26_21","1SA","26","21","21","Ben Solu bè: Ma durun kɛ̀. Ma nɛ́ Dauda, ǹ ɛara ǹ su. Mɛ́ ĩa damma dↄro, zaakɛ n ma wɛ̃̀ndi bɛ̀ɛ kɛ̀ gbã̀a. Yãpuramɛ, ma yↄ̃nkↄyã kɛ̀, ma zã yãa maamaa. ");
INSERT INTO bus_vpl VALUES ("S126_22","010_26_22","1SA","26","22","22","Ben Dauda bènɛ: N sárin yɛ̀. Ǹ tó n ìbanↄ doke bikũ à mↄ́ à sí. ");
INSERT INTO bus_vpl VALUES ("S126_23","010_26_23","1SA","26","23","23","Dii è fĩa bo baadenɛ à maakɛna kↄ̃n a náanɛo musu. Dii n namɛ ma ↄzĩ gbã̀a, mↄde mɛ́ɛ we mà ↄ nàmmaro kɛ̀ Dii bé à n ka kpatan yãnzi. ");
INSERT INTO bus_vpl VALUES ("S126_24","010_26_24","1SA","26","24","24","Lán ma n wɛ̃̀ndi bɛ̀ɛ kɛ̀ gbã̀a nà, Dii ma wɛ̃̀ndi bɛ̀ɛ dↄ̃ lɛ, à ma sí yã zaa píngia. ");
INSERT INTO bus_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","Ben Solu bènɛ: Luda aubarika dangu ma nɛ́ Dauda. Nɛ́ yã ìsi kɛ, n mì égↄ̃ da'iana. Kɛ̀ Dauda gɛ̃̀ zɛ́la, ben Solu tà bɛ. ");
INSERT INTO bus_vpl VALUES ("S127_1","010_27_1","1SA","27","1","1","Dauda laasuu lɛ̀ à bè: Solu é ma dɛ zĩkea. Tó mɛ́ɛ bàa lɛ́ ma ta Filisitininↄ bùsunlo, eé bↄmao nnaro. Tó ma bàa lɛ̀, Solu é mì kɛ̃ ma wɛtɛnaa, mɛ́ bↄ à ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("S127_2","010_27_2","1SA","27","2","2","Ben Dauda fɛ̀ɛ à gàa Gata kí Akisi, Maↄku nɛ́ kiia. Gↄ̃ↄn wàa aagↄ̃ↄnↄ gàao. ");
INSERT INTO bus_vpl VALUES ("S127_3","010_27_3","1SA","27","3","3","Ben Dauda kↄ̃n a gbɛ̃nↄ vɛ̃̀ɛ Gata kↄ̃n Akisio, baade kↄ̃n a bɛdeenↄ. Dauda kú gwe kↄ̃n a nↄↄnↄ mɛ̀n plaa, Yɛzɛrili gbɛ̃ Ainↄama kↄ̃n Kamɛli gbɛ̃ Abigaili kɛ̀ dɛ Nabala nↄↄ ũ yãao. ");
INSERT INTO bus_vpl VALUES ("S127_4","010_27_4","1SA","27","4","4","Kɛ̀ wà ò Solunɛ Dauda bàa lɛ̀ à tà Gata, èe pɛ́ɛzi dↄro. ");
INSERT INTO bus_vpl VALUES ("S127_5","010_27_5","1SA","27","5","5","Dauda bè Akisinɛ: Tó ma n pↄnnaa è, ǹ ma gba zɛ́ mà vɛ̃ɛ gukea n lakutunↄ doke guu. Mamↄma n zↄ̀bleri má yezi màgↄ̃ kúnyo n mɛɛwinlo. ");
INSERT INTO bus_vpl VALUES ("S127_6","010_27_6","1SA","27","6","6","Zĩ beeean Akisi Zikilaga kpàa, ben à gↄ̃̀ Yudanↄ kínanↄ pↄ́ ũ ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("S127_7","010_27_7","1SA","27","7","7","Dauda kuuna Filisitininↄ bùsun kà wɛ̃̀ do kↄ̃n mↄ siigↄ̃ↄo. ");
INSERT INTO bus_vpl VALUES ("S127_8","010_27_8","1SA","27","8","8","Ben Dauda kↄ̃n a gbɛ̃nↄ gàa wà lɛ̀ɛ Gesurunↄa kↄ̃n Gizinↄ kↄ̃n Amalɛkinↄ. Gbɛ̃ pìnↄↄ kú bùsu pìn zaa zimɛ bↄna zaa Suru ai à gàa pɛ́ Igipitia. ");
INSERT INTO bus_vpl VALUES ("S127_9","010_27_9","1SA","27","9","9","Tó Dauda zĩ̀ blè bùsu pì lakutunↄa, è gↄ̃gbɛ̃ ke nↄgbɛ̃ ke tó bɛ̃ɛro, sãanↄ kↄ̃n zùnↄ kↄ̃n zaakinↄ kↄ̃n lakuminↄ kↄ̃n pↄ́kãsãanↄn è nakↄ̃a. Tó à tà, è gá Akisi kiia. ");
INSERT INTO bus_vpl VALUES ("S127_10","010_27_10","1SA","27","10","10","Tó Akisi à là guu kɛ̀ à lɛ̀ɛn gbɛ̃nↄa gbã̀a, Dauda è benɛ a gaa Nɛgɛvi bùsun, Yudanↄ ke Yeramɛli boriinↄ ke Keninↄ kiiamɛ. ");
INSERT INTO bus_vpl VALUES ("S127_11","010_27_11","1SA","27","11","11","Dauda è gↄ̃gbɛ̃ ke nↄgbɛ̃ ke tó bɛ̃ɛ wà suo Gataro, zaakɛ èe bee: Gbɛ̃ke é kↄmↄtↄ kɛńnɛ à be dia má kɛ̀ nàn yɛ̀. Lɛn ègↄ̃ kɛɛ lɛ gurↄↄ kɛ̀ à kú Filisitininↄ bùsun. ");
INSERT INTO bus_vpl VALUES ("S127_12","010_27_12","1SA","27","12","12","Akisi Dauda náanɛ kɛ̀ à bè a zĩndanɛ: Isarailinↄ gì à kãzimɛ. Eégↄ̃ dɛ ma zↄ̀bleri ũmɛ gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("S128_1","010_28_1","1SA","28","1","1","Gurↄ beeenↄa Filisitininↄ ń zĩ̀kpɛɛnↄ kàkↄ̃a, aↄ̃ↄ yezi wà gá wà zĩ̀ ká kↄ̃n Isarailinↄ. Ben Akisi bè Daudanɛ: Asa ń dↄ̃ kɛ̀ mmↄn kↄ̃n n gbɛ̃nↄ é gámao zĩ̀ ká sↄ̃ↄ? ");
INSERT INTO bus_vpl VALUES ("S128_2","010_28_2","1SA","28","2","2","Ben Dauda bènɛ: Tↄ̀, nɛ́ e sa lán mamↄma n zↄ̀bleri mɛ́ kɛ nà. Ben Akisi bènɛ: Tó lɛmɛ, mɛ́ n kɛ ma dãkpari ũ ai gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","Samuɛli sↄ̃ gĩakɛ à gà kↄ̀, Isarailinↄ kàkↄ̃a ń píngi, aↄ̃ ↄ́ↄ dↄ̀ à ga yã musu, ben aↄ̃ à vĩ̀ a bɛ wɛ́tɛn zaa Rama. Solu pɛ̀ weegũnnadeenↄa kↄ̃n gɛ̀sisirinↄ Isarailinↄ bùsun. ");
INSERT INTO bus_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","Kɛ̀ Filisitininↄ kↄ̃ kàkↄ̃a, aↄ̃ mↄ̀ wà bùra kàɛ Sunɛmu. Ben Solu Isarailinↄ kàkↄ̃a ń píngi, aↄ̃ bùra kàɛ Giliboa. ");
INSERT INTO bus_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","Kɛ̀ Solu Filisitini zĩ̀kpɛɛnↄ è, vĩa à kũ̀, swɛ̃̀ kɛ̃̀n maamaa. ");
INSERT INTO bus_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","À gbèka Diia, ben Dii e weàla nanaa guu ke kↄ̃n Urimuo ke annabinↄ gãzĩro. ");
INSERT INTO bus_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","Ben Solu bè a ìbanↄnɛ: À nↄgbɛ̃ wegũnnade gɛ̀sisiri ke wɛtɛmɛ, lɛ mà gá mà yã gbekaa. Ben aↄ̃ bènɛ: Nↄgbɛ̃ wegũnnade gɛ̀sisiri kee kú Ɛndↄ. ");
INSERT INTO bus_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","Ben Solu a zĩnda lìɛ à pↄ́kãsã pãndenↄ dà, ben à gàa à nↄgbɛ̃ pì lè gwãavĩ, à gↄ̃ↄn plaaanↄ tɛ̀zi. À bènɛ: Ǹ tó n zĩn mↄ́ ǹ gɛ̀ kɛ̀ mɛ́ à tↄ́ onnɛ sísimɛ. ");
INSERT INTO bus_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","Ben nↄgbɛ̃ pì bènɛ: Ń dↄ̃ sãnsãn yã kɛ̀ Solu kɛ̀, kɛ̀ à a bùsu zɛ́ zↄ̃̀ wegũnnadeenↄnɛ kↄ̃n gɛ̀sisirinↄo. Bↄ́ yã bé à tò nɛ́ɛ takutɛɛ kpákpaamɛ lɛ wà ma dɛzi? ");
INSERT INTO bus_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","Ben Solu sìnɛ kↄ̃n Dii tↄ́o à bè: Má sì kↄ̃n Diio weé ĩa damma yã kɛ̀ musuro. ");
INSERT INTO bus_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","Ben nↄgbɛ̃ pì bè: Gɛ̀ kpareen mà sísinnɛɛ? À bè: Samuɛli gɛ̀mɛ. ");
INSERT INTO bus_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","Kɛ̀ nↄgbɛ̃ pì Samuɛli è, à vĩ̀ wiiio à bè Solunɛ: Ase ḿbe Solu ũu? Bↄ́yãnzin n ↄ̃ndↄ̃ↄ kɛ̀mɛzi? ");
INSERT INTO bus_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","Ben kí bènɛ: Ǹton tó vĩa n kũro. Bↄ́n ń è? À bènɛ: Gɛ̀wãadeen má è, èe bↄↄ tↄↄtɛn. ");
INSERT INTO bus_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","Ben Solu à là à bè: À kɛ̀ diamɛ? À bènɛ: Mare zi ke bé èe mↄↄ, à utadaa dana. Ben Solu dↄ̃̀ kɛ̀ Samuɛlimɛ, ben à kùɛ à dàɛ a puua. ");
INSERT INTO bus_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","Ben Samuɛli à là à bè: Bↄ́yãnzin n ĩa dàmazi, kɛ̀ n ma sisiee? À wèàla à bè: Ma nawɛ̃a bíta èmɛ. Filisitininↄ bé wà mↄ̀ zĩ̀ kámao, ben Luda kpɛɛ lìmɛ. È wemala annabi gãzĩ ke nanaa guu dↄro. Beee yãnzin ma n sisizi. Ǹ omɛ lán mɛ́ kɛ nà. ");
INSERT INTO bus_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","Samuɛli bènɛ: Dii kpɛɛ lìnnɛ à gↄ̃̀ n ibɛɛ ũ, ben n mↄ nɛ́ɛ yã gbekaama sↄ̃ nɛ́? ");
INSERT INTO bus_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","Dii kɛ̀nnɛ lán à dàmɛ má ònnɛ nà. À n bↄ kpatan à n gbɛ̃daa Dauda kàn. ");
INSERT INTO bus_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","Dii beee kɛ̀nnɛ gbã̀a, kɛ̀ nɛ́ɛ à yã maro yãnzimɛ. Nɛ́ɛ pↄfɛ̃ pãsĩ bↄbↄnɛ Amalɛkinↄaro. ");
INSERT INTO bus_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","Dii é Isarailinↄ kↄ̃n mpio kpá Filisitininↄamɛ. Mmↄn kↄ̃n n nɛ́gↄ̃gbɛ̃nↄ égↄ̃ kúmao kɛ̀ zia. Dii é Isaraili zĩ̀kpɛɛnↄ kpá Filisitininↄa. ");
INSERT INTO bus_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","Samuɛli yã pì tò vĩa Solu kũ̀ maamaa, ben à lɛ̀ɛ a puua sↄ̀rↄrↄ gↄ̃ↄ. À gbãaa yã̀a, zaakɛ èe pↄ́ke ble gurↄ beeea ke gwãavĩ beeearo. ");
INSERT INTO bus_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","Kɛ̀ nↄgbɛ̃ pì mↄ̀ Solu kiia, à è swɛ̃̀ kɛ̃̀n maamaa, ben à bènɛ: Mamↄma n zↄ̀bleri ma n yã mà, ma a zĩnda kpà karizi, ma yã kɛ̀ ń òmɛɛ kɛ̀. ");
INSERT INTO bus_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","Ǹ n zↄ̀bleri yã ma sa. Ǹ tó mà pↄ́blee diɛnnɛ ǹ ble, lɛ ǹ gbãa e ǹ da zɛ́n. ");
INSERT INTO bus_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","Ben Solu gì à bè: Mɛ́ pↄ́ blero. Kɛ̀ à ìbanↄ nàkↄ̃rɛa lɛdo kↄ̃n nↄgbɛ̃ pìo, ben à ń yã mà. Ben à fɛ̀ɛ tↄↄtɛ à vɛ̃̀ɛ gádoa. ");
INSERT INTO bus_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","Nↄgbɛ̃ pì zù nɛ́ bↄ̀rↄ mɛ̀kpana vĩ bàdↄna a bɛ. À gàa à dɛ̀ gↄ̃ↄ, ben à flawa sɛ̀ à dɛ̀, à burɛdi sɛ́sɛ'ɛ̃zɛ̃sai kɛ̀o. ");
INSERT INTO bus_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","À dìɛ Solunɛ kↄ̃n à ìbanↄ. Aↄ̃ↄ blè, ben aↄ̃ fɛ̀ɛ wà tà gwãavĩ beeea gↄ̃ↄ. ");
INSERT INTO bus_vpl VALUES ("S129_1","010_29_1","1SA","29","1","1","Filisitininↄ ń zĩ̀kpɛɛnↄ kàkↄ̃a Afɛki, bensↄ̃ Isarailinↄ bùra kú Yɛzɛrili íbↄkiia. ");
INSERT INTO bus_vpl VALUES ("S129_2","010_29_2","1SA","29","2","2","Filisitininↄ kínanↄↄ e gɛ̃tɛɛ kↄ̃n ń zĩ̀kpɛ gãlinↄ, aↄ̃ kenↄ gↄ̃ↄn basↄsↄↄro, aↄ̃ kenↄ wàa sↄsↄↄro. Dauda kↄ̃n a gbɛ̃nↄↄ tɛ́ ń kpɛɛ kↄ̃n Akisio. ");
INSERT INTO bus_vpl VALUES ("S129_3","010_29_3","1SA","29","3","3","Ben Filisitininↄ kína pìnↄ Akisi là wà bè: Eberu kɛ̀nↄ sↄ̃ nɛ́? À wèńla à bè: Daudan yɛ̀. Isarailinↄ kí Solu ìba kemɛ yã. À gurↄplaa kɛ̀mao. À kúmao dɛ wɛ̃̀ doola. Naana zaa gurↄↄ kɛ̀ à mↄ̀ ma kiia ai gbã̀a, mɛ́ɛ taari ke earo. ");
INSERT INTO bus_vpl VALUES ("S129_4","010_29_4","1SA","29","4","4","Ben kína pìnↄ pɛ̃tɛ̃ kɛ̀o wà bè: Ǹ gↄ̃gbɛ̃ pì gbarɛ à tá guu kɛ̀ ń kpàan. Eé e à gáwao zĩ̀lanlo, lɛ àton bↄ wa kpɛɛ gwero yãnzi. Dian eé e à kɛ nna kↄ̃n a diio nà, tó èe kɛ à tà kↄ̃n wa gbɛ̃kenↄ mìo baasiroo? ");
INSERT INTO bus_vpl VALUES ("S129_5","010_29_5","1SA","29","5","5","Dauda kɛ̀ wà lɛ̀ sì wà ↄ̃ wã̀ à yã musun gweroo? Kɛ̀ wà bè: Solu gbɛ̃nↄ dɛ̀dɛ gↄ̃ↄn wàa sↄsↄↄro, Dauda sↄ̃ gↄ̃ↄn bↄrↄ lɛo ũgbangba. ");
INSERT INTO bus_vpl VALUES ("S129_6","010_29_6","1SA","29","6","6","Ben Akisi Dauda sìsi à bènɛ: Má sì kↄ̃n Diio ń kuu gbɛ̃ maaa ũ ma kiia, n ganamao zĩ̀lan kɛ̀mɛ nna, zaakɛ naana zaa gurↄↄ kɛ̀ n mↄ ma kiia ai gbã̀a, mɛ́ɛ taari ke emmaro. Mↄde ń yã e kɛ wa kínanↄnɛro. ");
INSERT INTO bus_vpl VALUES ("S129_7","010_29_7","1SA","29","7","7","Ǹ ɛara ǹ tá kↄ̃n aafiao lɛ ǹton yãke kɛ à kɛńnɛ zaaro. ");
INSERT INTO bus_vpl VALUES ("S129_8","010_29_8","1SA","29","8","8","Ben Dauda Akisi là à bè: Bↄ́n má kɛ̀? Naana zaa gurↄↄ kɛ̀ ma mↄ n kiia ai gbã̀a, bↄ́n ń èmaa? Bↄ́yãnzin mɛ́ e mà gá mà zĩ̀ ká kↄ̃n ma dii kí ibɛɛnↄoroo? ");
INSERT INTO bus_vpl VALUES ("S129_9","010_29_9","1SA","29","9","9","Ben Akisi bènɛ: Má dↄ̃ kɛ̀ ń maamɛ lán Luda malaika bà, mↄde wa kínanↄ bè ǹton gáwao zĩ̀lanlo. ");
INSERT INTO bus_vpl VALUES ("S129_10","010_29_10","1SA","29","10","10","Tó guu dↄ̀, ǹ fɛɛ kↄngↄ idɛ'idɛ kↄ̃n n dii Solu zↄ̀bleri kɛ̀ aↄ̃ mↄ̀nyonↄ, à tá. ");
INSERT INTO bus_vpl VALUES ("S129_11","010_29_11","1SA","29","11","11","Ben Dauda fɛ̀ɛ kↄngↄ idɛ'idɛ kↄ̃n a gbɛ̃nↄ, aↄ̃ↄe taa Filisitininↄ bùsun. Filisitininↄ sↄ̃ gàa Yɛzɛrili. ");
INSERT INTO bus_vpl VALUES ("S130_1","010_30_1","1SA","30","1","1","Dauda kↄ̃n a gbɛ̃nↄ kà Zikilaga à gurↄ aagↄ̃dee zĩ. À mↄ̀ à lè Amalɛkinↄ mↄ̀ wà lɛ̀ɛ Nɛgɛvi bùsua kↄ̃n Zikilagao ń kpɛɛ. Aↄ̃ lɛ̀ɛ Zikilagaa aↄ̃ tɛ́ sↄ̃̀a. ");
INSERT INTO bus_vpl VALUES ("S130_2","010_30_2","1SA","30","2","2","Aↄ̃ nↄgbɛ̃ kɛ̀ aↄ̃ↄ kú gweenↄ kũ̀kũ, nɛ́nↄgbɛ̃nↄ kↄ̃n nↄgbɛ̃ ìsinↄ ń píngi. Aↄ̃ↄe ń gbɛ̃ke dɛro, aↄ̃ ń sɛ́ɛ wà tàńyo. ");
INSERT INTO bus_vpl VALUES ("S130_3","010_30_3","1SA","30","3","3","Kɛ̀ Dauda kↄ̃n a gbɛ̃nↄ kà ń bɛ wɛ́tɛ, aↄ̃ↄ è wà tɛ́ sↄ̃̀a wà ń nↄgbɛ̃nↄ kↄ̃n ń nɛ́gↄ̃gbɛ̃nↄ kↄ̃n ń nɛ́nↄgbɛ̃nↄ kũ̀kũ wà tàńyo. ");
INSERT INTO bus_vpl VALUES ("S130_4","010_30_4","1SA","30","4","4","Ben Dauda kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ kúonↄ wii lɛ̀ aↄ̃ ↄ́ↄ dↄ̀ ai aↄ̃ gbãaa yã̀a, ai aↄ̃ↄe fↄ̃ wà ↄ́ↄ dↄ̀ dↄro. ");
INSERT INTO bus_vpl VALUES ("S130_5","010_30_5","1SA","30","5","5","Wà Dauda nↄↄnↄ kũ̀kũ wà tàńyo ń plaa Ainↄama kↄ̃n Abigailio. ");
INSERT INTO bus_vpl VALUES ("S130_6","010_30_6","1SA","30","6","6","Dauda wɛ́ɛtãmma è maamaa, zaakɛ wèe bee wà à pápa gbɛ̀o wà dɛmɛ. Aↄ̃ baade píngi nↄ̀sɛ yàka aↄ̃ nɛ́gↄ̃gbɛ̃nↄ kↄ̃n ń nɛ́nↄgbɛ̃nↄ yã musu. Mↄde Dauda gbãa è Dii a Ludaa, ");
INSERT INTO bus_vpl VALUES ("S130_7","010_30_7","1SA","30","7","7","ben à bè sa'ori Abiatanɛ: Ǹ mↄ́ kↄ̃n n dansiki utao. Kɛ̀ à gàaonɛ, ");
INSERT INTO bus_vpl VALUES ("S130_8","010_30_8","1SA","30","8","8","ben Dauda yã gbèka Diia, à à là à bè: Mà pɛ́ɛ gbãamↄnnɛri pìnↄzi mɛ́ ń leↄ́? À bènɛ: Ǹ pɛ́ɛńzi, nɛ́ ń le ǹ n gbɛ̃nↄ mì sí. ");
INSERT INTO bus_vpl VALUES ("S130_9","010_30_9","1SA","30","9","9","Ben Dauda dà zɛ́n kↄ̃n gↄ̃ↄn wàa aagↄ̃ↄnↄ. Kɛ̀ aↄ̃ kà Beso swaazi, gbɛ̃kenↄ gↄ̃̀ gwe. ");
INSERT INTO bus_vpl VALUES ("S130_10","010_30_10","1SA","30","10","10","Gↄ̃ↄn wàa doonↄ gbãaa yã̀a, aↄ̃ↄe fↄ̃ wà bikũ̀ swaa pìaro, ben Dauda bikũ̀, à tɛ́ ń gbɛ̀zi kↄ̃n gↄ̃ↄn wàa plaaanↄ. ");
INSERT INTO bus_vpl VALUES ("S130_11","010_30_11","1SA","30","11","11","Aↄ̃ Igipiti gbɛ̃ke è sɛ̃̀tɛ, ben aↄ̃ gàao Dauda kiia. Wà pↄ́blee kpàa à blè, wà í kpàa à mì. ");
INSERT INTO bus_vpl VALUES ("S130_12","010_30_12","1SA","30","12","12","Ben aↄ̃ kãkã bɛ kori kpàa kↄ̃n geepi kàrao mɛ̀n plaa à sò. Ben à mɛ̀ sù, zaakɛ à kɛ̀ fãantɛ̃ kↄ̃n gwãavĩo gurↄ aagↄ̃ pↄ́blesai ímisai. ");
INSERT INTO bus_vpl VALUES ("S130_13","010_30_13","1SA","30","13","13","Ben Dauda à là à bè: Dé gbɛ̃n n ũu? N bↄ mámɛ? Ben Igipiti gbɛ̃ pì bè: Amalɛki zↄ̀n ma ũ. À gurↄ aagↄ̃deen yɛ̀, ma dii pã kpàmazi kɛ̀ mɛ́ɛ gyãa kɛɛ yãnzi. ");
INSERT INTO bus_vpl VALUES ("S130_14","010_30_14","1SA","30","14","14","Wa lɛɛ Nɛgɛvi bùsuamɛ, guu kɛ̀ Kiritinↄↄ kún kↄ̃n Yudanↄ kↄ̃n Kalɛbu boriinↄ, ben wà tɛ́ sↄ̃̀ Zikilagaa. ");
INSERT INTO bus_vpl VALUES ("S130_15","010_30_15","1SA","30","15","15","Ben Dauda à là à bè: Nɛ́ fↄ̃ ǹ gámao gbɛ̃ pìnↄ kiiaↄ́? À wèàla à bè: Tó ń sìmɛ kↄ̃n Luda tↄ́o kɛ̀ nɛ́ ma dɛro, tó nɛ́ ma kpá ma diiaro, mɛ́ gányo ń kiia. ");
INSERT INTO bus_vpl VALUES ("S130_16","010_30_16","1SA","30","16","16","Ben à gàao. Kɛ̀ aↄ̃ kà, aↄ̃ ń lé, aↄ̃ↄ fãakↄ̃ana gu píngia, aↄ̃ↄe pↄ́ blee, aↄ̃ↄe í mii, aↄ̃ↄe pↄnnaa kɛɛ pↄ́ bíta kɛ̀ aↄ̃ↄ sɛ̀ɛ Filisitininↄ bùsunnↄ kↄ̃n Yudanↄ bùsuo yãnzi. ");
INSERT INTO bus_vpl VALUES ("S130_17","010_30_17","1SA","30","17","17","Ben Dauda sì ń tɛ́ à ń dɛdɛ naana zaa uusiɛ ai gu làa gàa à dↄ̀o uusiɛ. Aↄ̃ gbɛ̃kee e bↄkii ero, séde gↄ̃kparɛ gↄ̃ↄn wàa plaaa kɛ̀ aↄ̃ dì lakumia aↄ̃ bàa lɛ̀nↄ baasiro. ");
INSERT INTO bus_vpl VALUES ("S130_18","010_30_18","1SA","30","18","18","Dauda gbɛ̃ kɛ̀ Amalɛkinↄ ń kũkũnↄ mì sì ń píngi kↄ̃n a nↄↄnↄ ń plaa. ");
INSERT INTO bus_vpl VALUES ("S130_19","010_30_19","1SA","30","19","19","Aↄ̃ gbɛ̃kee e sãsãro, nɛ́ féte gbɛ̃nsi, nɛ́gↄ̃gbɛ̃nↄ kↄ̃n nɛ́nↄgbɛ̃nↄ ń píngi. Baa pↄ́ kɛ̀ aↄ̃ↄ sɛ̀ɛnↄ, Dauda ɛ̀ara à pↄ́ pìnↄ sì píngi. ");
INSERT INTO bus_vpl VALUES ("S130_20","010_30_20","1SA","30","20","20","À sãanↄ kↄ̃n zùnↄ nàkↄ̃a, ben à gbɛ̃nↄ pↄ́kãdee pìnↄ kpan'aɛ kɛ̀ aↄ̃ bè: Dauda pↄ́nↄn yɛ̀. ");
INSERT INTO bus_vpl VALUES ("S130_21","010_30_21","1SA","30","21","21","Ben Dauda kà gↄ̃ↄn wàa doo kɛ̀ aↄ̃ gbãaa yã̀a aↄ̃ↄe fↄ̃ wà gàaoro aↄ̃ gↄ̃̀ Beso swaazinↄ kiia. Aↄ̃ bↄ̀ɛ wà dààlɛ kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ kúonↄ. Kɛ̀ Dauda sↄ̃̀ńzi, à ì kpàḿma, ");
INSERT INTO bus_vpl VALUES ("S130_22","010_30_22","1SA","30","22","22","ben gbɛ̃ pãsĩ gaabudee kɛ̀ aↄ̃ↄ tɛ́ Daudazinↄ bè: Lán aↄ̃ↄe gáwaoro nà, wé pↄ́ kɛ̀ wá sìnↄ ke kpáḿmaro, tó èe kɛ aↄ̃ baade naↄ̃ kↄ̃n a nɛ́nↄ baasiro. Aↄ̃ ń sɛ́ wà táńyo. ");
INSERT INTO bus_vpl VALUES ("S130_23","010_30_23","1SA","30","23","23","Ben Dauda bè: Auo! Ma gbɛ̃nↄ, àton kɛ lɛ kↄ̃n pↄ́ kɛ̀ Dii kpàwaanↄro, zaakɛ à wa dãkpa à gbãamↄnnɛri kɛ̀ aↄ̃ lɛ̀ɛwaanↄ nàwe wa ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("S130_24","010_30_24","1SA","30","24","24","Dé bé é yã kɛ̀ á ò kɛ̀kii sí sↄ̃ↄ? Gbɛ̃ kɛ̀ aↄ̃ gↄ̃̀ aↄ̃ↄe pↄ́nↄ dãkpaanↄ asaia égↄ̃ dↄ̃nkↄ̃ kↄ̃n gbɛ̃ kɛ̀ aↄ̃ gàa zĩ̀lannↄmɛ. Wé kpaatɛtɛkↄ̃nɛ sáasaamɛ. ");
INSERT INTO bus_vpl VALUES ("S130_25","010_30_25","1SA","30","25","25","Kɛ̀ Dauda yã pì dìɛ, ben à gↄ̃̀ doka ũ Isarailinↄnɛ zaa zĩ beeea ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("S130_26","010_30_26","1SA","30","26","26","Kɛ̀ Dauda kà Zikilaga, à pↄ́ kɛ̀ à sì kenↄ kpã̀sã Yudanↄ bùsu gbɛ̃nsi kɛ̀ aↄ̃ↄ dɛ a gbɛ̃nna ũunↄnɛ à bè: Gbaa kɛ̀ á è pↄ́ kɛ̀ wá sì Dii ibɛɛnↄa guunↄn gwe. ");
INSERT INTO bus_vpl VALUES ("S130_27","010_30_27","1SA","30","27","27","À kpã̀sãńnɛ Bɛtɛli kↄ̃n Ramↄ Nɛgɛvio kↄ̃n Yatio ");
INSERT INTO bus_vpl VALUES ("S130_28","010_30_28","1SA","30","28","28","kↄ̃n Aroao kↄ̃n Sifimↄo kↄ̃n Ɛsɛtɛmↄao ");
INSERT INTO bus_vpl VALUES ("S130_29","010_30_29","1SA","30","29","29","kↄ̃n Rakalao kↄ̃n Yeramɛli bori wɛ́tɛnↄ kↄ̃n Keni wɛ́tɛnↄ ");
INSERT INTO bus_vpl VALUES ("S130_30","010_30_30","1SA","30","30","30","kↄ̃n Ɔↄmao kↄ̃n Borasão kↄ̃n Atakao ");
INSERT INTO bus_vpl VALUES ("S130_31","010_30_31","1SA","30","31","31","kↄ̃n Ɛblↄnuo kↄ̃n guu kɛ̀ Dauda lili òn kↄ̃n a gbɛ̃nↄ píngi. ");
INSERT INTO bus_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","Filisitininↄ zĩ̀ kà kↄ̃n Isarailinↄ, ben Isarailinↄ bàa lɛ̀ńnɛ ai aↄ̃ paridee gàga Giliboa sĩ̀sĩgɛɛzi. ");
INSERT INTO bus_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","Filisitininↄ pɛ̀ɛ Solu kↄ̃n a nɛ́gↄ̃gbɛ̃nↄzi, ben aↄ̃ à nɛ́ pìnↄ Yonatã kↄ̃n Abinadabuo kↄ̃n Malakisuao dɛ̀dɛ. ");
INSERT INTO bus_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Zĩ̀ kɛ̀ wèe kaa Solu saɛ pãsĩ kũ̀, ben kàzurinↄ à pà, à kɛ̃̀nna maamaa. ");
INSERT INTO bus_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","Ben à bè a zĩ̀kapↄnↄsɛrinɛ: Ǹ n fɛ̃ɛdaa woto ǹ ma zↄ̃ ǹ ma dɛo. Tó lɛnlo, gɛfↄↄdee kɛ̀nↄ é ma zↄ̃ aↄ̃ kↄ̃kↄ̃ omao. Ben vĩa à zĩ̀kapↄnↄsɛri kũ̀, èe weziro, ben Solu a fɛ̃ɛdaa sɛ̀, à a zĩnda ò'oàla. ");
INSERT INTO bus_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Kɛ̀ à zĩ̀kapↄnↄsɛri è à gà, ben à a zĩnda ò'o a fɛ̃ɛdaala se à gà. ");
INSERT INTO bus_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","Lɛn Solu kↄ̃n a nɛ́gↄ̃gbɛ̃ gↄ̃ↄn aagↄ̃ kↄ̃n a zĩ̀kapↄnↄsɛrio kↄ̃n a gbɛ̃nↄ gàga lɛdo lɛ zĩ dↄ̃nkↄ̃ pì zĩ ń píngi. ");
INSERT INTO bus_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","Kɛ̀ Isaraili kɛ̀ aↄ̃ↄ kú guzurɛn gweenↄ kↄ̃n ń gbɛ̃ kɛ̀ aↄ̃ↄ kú Yoda baa kãa kpaanↄ è ń zĩ̀kpɛɛnↄ bàa lɛ̀, bensↄ̃ Solu kↄ̃n a nɛ́nↄ gàga, aↄ̃ bàa lɛ̀ aↄ̃ ń wɛ́tɛnↄ tò gwe, ben Filisitininↄ mↄ̀ wà vɛ̃̀ɛn. ");
INSERT INTO bus_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","Kɛ̀ guu dↄ̀, ben Filisitininↄ mↄ̀ aↄ̃ↄe pↄ́nↄ bↄbↄↄ gbɛ̃ kɛ̀ aↄ̃ gàganↄa, ben aↄ̃ Solu kↄ̃n a nɛ́ mɛ̀n aagↄ̃ↄ pìnↄ gɛ̀ è kaɛna Giliboa sĩ̀sĩgɛɛzi. ");
INSERT INTO bus_vpl VALUES ("S131_9","010_31_9","1SA","31","9","9","Ben aↄ̃ Solu mì zↄ̃̀ aↄ̃ à gↄ̃kɛbↄnↄ bↄ̀ɛa, ben aↄ̃ gbɛ̃nↄ zĩ̀ aↄ̃ à baaru kpàkpa Filisitininↄ bùsu gu píngia kↄ̃n ń tãakpɛnↄ. ");
INSERT INTO bus_vpl VALUES ("S131_10","010_31_10","1SA","31","10","10","Wà à gↄ̃kɛbↄnↄ kàɛ tãa kɛ̀ wè sísi Asatorɛ kpɛ́n, ben wà à gɛ̀ lògo Bɛtɛsã bĩia. ");
INSERT INTO bus_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","Kɛ̀ Yabɛsi Giliadadeenↄ yã kɛ̀ Filisitininↄↄ kɛ̀ Solunɛ pì mà, ");
INSERT INTO bus_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","ben aↄ̃ gↄ̃sagbãaanↄ fɛ̀ɛ ń píngi aↄ̃ tá gwãavĩ ò zĩ beeea, aↄ̃ Solu kↄ̃n a nɛ́nↄ gɛ̀nↄ bàkɛ̃ Bɛtɛsã bĩia, ben aↄ̃ tào Yabɛsi aↄ̃ tɛ́ sↄ̃̀ḿma gwe. ");
INSERT INTO bus_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","Aↄ̃ ń wánↄ sɛ̀ɛ aↄ̃ↄ vĩ̀i sãma lí gbáru Yabɛsi gwe, ben aↄ̃ lɛ́ yì gurↄ swɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("S21_1","011_1_1","2SA","1","1","1","Solu gana gbɛra Dauda sù kↄ̃n zĩ̀blena Amalɛkinↄao, ben à gↄ̃̀ Zikilaga gurↄ plaa. ");
INSERT INTO bus_vpl VALUES ("S21_2","011_1_2","2SA","1","2","2","À gurↄ aagↄ̃dee zĩ gↄ̃gbɛ̃ ke bↄ̀ Solu bùran à mↄ̀. À pↄ́kãsãanↄ kɛ̃kɛ̃na, bùsu ká à mìn. Kɛ̀ à kà Dauda kiia, à kùɛnɛ à dàɛ a puua. ");
INSERT INTO bus_vpl VALUES ("S21_3","011_1_3","2SA","1","3","3","Dauda à là à bè: N bↄ mámɛ? À wèàla à bè: Ma bↄ Isarailinↄ bùrammɛ. ");
INSERT INTO bus_vpl VALUES ("S21_4","011_1_4","2SA","1","4","4","Ben Dauda à là dↄ: À kɛ̀ diamɛ? Ǹ omɛ. Ben à wèàla à bè: Isarailinↄ bↄ̀ zĩ̀lan wà bàa lɛ̀. Aↄ̃ paridee lɛ̀ɛ wà gàga. Solu kↄ̃n a nɛ́ Yonatão gà dↄ. ");
INSERT INTO bus_vpl VALUES ("S21_5","011_1_5","2SA","1","5","5","Ben Dauda gↄ̃kparɛ kɛ̀ èe baaru pì kpaanɛ là à bè: N kɛ dian ń dↄ̃ kɛ̀ Solu kↄ̃n a nɛ́ Yonatão gà? ");
INSERT INTO bus_vpl VALUES ("S21_6","011_1_6","2SA","1","6","6","À wèàla à bè: Àɛ sↄ̃ má kú Giliboa kpiigɛɛzi gwemɛ, ben ma Solu è, èe gbãa ee a sária. Sↄ̃gorodeenↄ kↄ̃n sↄ̃deenↄↄ e kaao kĩi. ");
INSERT INTO bus_vpl VALUES ("S21_7","011_1_7","2SA","1","7","7","Kɛ̀ à lìɛ ma kpa, à ma e, ben à ma sisi. Ma bè: Máɛ kɛ̀! ");
INSERT INTO bus_vpl VALUES ("S21_8","011_1_8","2SA","1","8","8","Ben à ma la, mámbe dé ũu? Ben ma weàla ma bè Amalɛki boriin ma ũ. ");
INSERT INTO bus_vpl VALUES ("S21_9","011_1_9","2SA","1","9","9","Ben à bèmɛ mà sↄ̃azi mà a dɛ, zaakɛ á kú gaa lɛ́zĩmɛ, baa kɛ̀ a wɛ́ɛ kpɛ́ kɛ̃na féte. ");
INSERT INTO bus_vpl VALUES ("S21_10","011_1_10","2SA","1","10","10","Ben ma sↄ̃zi ma à dɛ̀, zaakɛ má dↄ̃ eé fↄ̃ à ble à lɛɛna gbɛra dↄro. Ben ma à kífura kɛ̀ à kuna sɛ̀ kↄ̃n zãa kɛ̀ à danao, ben ma suonnɛ kɛ̀ ma dii. ");
INSERT INTO bus_vpl VALUES ("S21_11","011_1_11","2SA","1","11","11","Ben Dauda a pↄ́kãsãanↄ gà à kɛ̃̀, ben gbɛ̃ kɛ̀ aↄ̃ↄ kúonↄ ń pↄ́nↄ kɛ̃̀kɛ̃ se. ");
INSERT INTO bus_vpl VALUES ("S21_12","011_1_12","2SA","1","12","12","Aↄ̃ Solu kↄ̃n a nɛ́ Yonatão gana ↄ́ↄ dↄ̀ kↄ̃n Dii gbɛ̃ Isarailinↄ, zaakɛ zĩ̀ ń blé. Wɛ́ɛ'i bↄ̀ḿma, ben aↄ̃ lɛ́ yì ai uusiɛ. ");
INSERT INTO bus_vpl VALUES ("S21_13","011_1_13","2SA","1","13","13","Dauda gↄ̃kparɛ kɛ̀ à baaru pì kpànɛ là à bè: N bɛɛ kú mámɛ? Ben à bènɛ: Bↄ̀amↄ nɛ́n ma ũ, Amalɛki borii. ");
INSERT INTO bus_vpl VALUES ("S21_14","011_1_14","2SA","1","14","14","Ben Dauda à là à bè: À kɛ̀ dia kína kɛ̀ Dii kà dɛna vĩa e n kũroo? ");
INSERT INTO bus_vpl VALUES ("S21_15","011_1_15","2SA","1","15","15","Ben Dauda a gↄ̃kparɛnↄ doke sìsi à bè: Ǹ à lɛ́ ǹ dɛ se. Ben à à lɛ̀ à dɛ̀. ");
INSERT INTO bus_vpl VALUES ("S21_16","011_1_16","2SA","1","16","16","Zaakɛ Dauda gĩakɛ à bènɛ: N n zĩnda dɛ̀mɛ. N zĩnda lɛ́ bé à n da yãn, n bè n kína kɛ̀ Dii kà dɛ̀. ");
INSERT INTO bus_vpl VALUES ("S21_17","011_1_17","2SA","1","17","17","Dauda sósobi lɛ̀ kɛ̀ sì Solu kↄ̃n a nɛ́ Yonatão ga yã musu. ");
INSERT INTO bus_vpl VALUES ("S21_18","011_1_18","2SA","1","18","18","À bè wà lɛ̀ pì dada Yudanↄnɛ. À kú Yasa takadan. ");
INSERT INTO bus_vpl VALUES ("S21_19","011_1_19","2SA","1","19","19","Isarailinↄ gakuideenↄ gàga sĩ̀sĩgɛɛzi, gↄ̃sagbãaanↄ ii òmɛ! ");
INSERT INTO bus_vpl VALUES ("S21_20","011_1_20","2SA","1","20","20","Àton à baaru kpá Gata zɛ́daanlo, lɛ Filisitini nↄgbɛ̃nↄ tón à pↄnnaa kɛro yãnzi. Àton à kpàakpa kɛ Asakɛlↄniro, lɛ gɛfↄↄde nɛ́nↄgbɛ̃nↄ tón áyuwi kɛro. ");
INSERT INTO bus_vpl VALUES ("S21_21","011_1_21","2SA","1","21","21","Kpíi tón kpá Giliboa gbɛ̀ musua dↄro, lou tón ma buraa kɛ̀ aↄ̃ↄ kú gweenↄa dↄro, gwen wà ↄ sↄ̃̀ gↄ̃sagbãaanↄ sɛngbangonↄzi, nↄ́si dↄkↄna Solu sɛngbangoa lɛ́ zɛ̀! ");
INSERT INTO bus_vpl VALUES ("S21_22","011_1_22","2SA","1","22","22","Kɛ̀ wèe gↄ̃sagbãaa aru fãa guua, wèe ń gbɛɛɛ paraa, Yonatã kàzuri pãsĩ è kpɛɛ gwaro, Solu fɛ̃ɛdade pãsĩ è su koriro. ");
INSERT INTO bus_vpl VALUES ("S21_23","011_1_23","2SA","1","23","23","Solu kↄ̃n Yonatão, gbɛ̃ maa yenzideenↄmɛ! Aↄ̃ↄe kɛ̃kↄ̃a wɛ̃̀ndi ke gaanlo. Aↄ̃ wãaa dɛ kúunↄla, aↄ̃ gbãaa dɛ músunↄla. ");
INSERT INTO bus_vpl VALUES ("S21_24","011_1_24","2SA","1","24","24","Isaraili nↄgbɛ̃nↄ, à wɛ́ɛ'i kán Solu ga yã musu. À bisa tɛ̃aa yìare kↄ̃n nↄmaablebↄnↄ, à a pↄ́kãsãanↄ kɛ̀kɛare kↄ̃n zãblebↄ kɛ̀ wà pì kↄ̃n vuraonↄ. ");
INSERT INTO bus_vpl VALUES ("S21_25","011_1_25","2SA","1","25","25","Gↄ̃sagbãaanↄ ii ò zĩ̀lan fá! Yonatã daɛna gɛ̀ ũ sĩ̀sĩgɛɛzi. ");
INSERT INTO bus_vpl VALUES ("S21_26","011_1_26","2SA","1","26","26","Ma gbɛ̃ Yonatã, ma gↄ̃ nawɛ̃a guu n yãnzi, ń maamɛ wásawasa. Yenzi kɛ̀ ń vĩmao sáa vĩro, à dɛ nↄ yenzila. ");
INSERT INTO bus_vpl VALUES ("S21_27","011_1_27","2SA","1","27","27","Gↄ̃sagbãaanↄ ii ò fá! Aↄ̃ gↄ̃kɛbↄnↄ kàatɛ. ");
INSERT INTO bus_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","Beee gbɛra Dauda Dii là à bè: Mà gá Yuda wɛ́tɛnↄ doke guuↄ́? Dii bènɛ à gá, ben Dauda ɛ̀ara à à là à bè: Mákpan mà gán? Dii wèàla à bè: Ɛblↄnu kpa. ");
INSERT INTO bus_vpl VALUES ("S22_2","011_2_2","2SA","2","2","2","Ben Dauda gàa gwe kↄ̃n a nↄ mɛ̀n plaaanↄ, Yɛzɛrili gbɛ̃ Ainↄama kↄ̃n Nabala gyaanↄ Abigaili, Kamɛli gbɛ̃o. ");
INSERT INTO bus_vpl VALUES ("S22_3","011_2_3","2SA","2","3","3","Dauda gàa kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ kúonↄ dↄ, baade kↄ̃n a bɛdeenↄ, ben aↄ̃ vɛ̃̀ɛ Ɛblↄnu kↄ̃n à lakutunↄo. ");
INSERT INTO bus_vpl VALUES ("S22_4","011_2_4","2SA","2","4","4","Ben Yudanↄ gbɛ̃nsinↄ mↄ̀ wà nↄ́si kù Dauda mìa gwe, aↄ̃ à kà Yudanↄ kína ũ. Kɛ̀ Dauda mà Yabɛsi Giliadadeenↄ bé wà Solu vĩ̀i, ");
INSERT INTO bus_vpl VALUES ("S22_5","011_2_5","2SA","2","5","5","à gbɛ̃nↄ zĩ̀ḿma, aↄ̃ gàa wà bèńnɛ: Dauda bè Dii aubarika daagu, kɛ̀ a gbɛ̃kɛɛ kɛ̀ Solu a diinɛ a à vĩ̀i. ");
INSERT INTO bus_vpl VALUES ("S22_6","011_2_6","2SA","2","6","6","Dii gbɛ̃kɛ yã kↄ̃n náanɛ yão kɛare. Mapi sↄ̃ mɛ́ à maaa kɛare kɛ̀ a yã pì kɛ̀ yãnzi. ");
INSERT INTO bus_vpl VALUES ("S22_7","011_2_7","2SA","2","7","7","Tia sa àgↄ̃ gbãa à kùgbãaa kɛ. A dii Solu gà ben Yudanↄ ma ka ń kína ũ. ");
INSERT INTO bus_vpl VALUES ("S22_8","011_2_8","2SA","2","8","8","Nɛrɛ nɛ́ Abana, Solu zĩ̀kpɛɛnↄ gbɛ̃nsi gĩakɛ à gàa se kↄ̃n Solu nɛ́ Isibosɛo Manaimu. ");
INSERT INTO bus_vpl VALUES ("S22_9","011_2_9","2SA","2","9","9","Ben à à kà kí ũ Giliada bùsun kↄ̃n Asa boriinↄ bùsuo kↄ̃n Yɛzɛrilio kↄ̃n Ɛflaimu boriinↄ bùsuo kↄ̃n Bɛyãmi boriinↄ bùsuo kↄ̃n Isarailinↄ bùsu kpaaanↄ píngi. ");
INSERT INTO bus_vpl VALUES ("S22_10","011_2_10","2SA","2","10","10","Solu nɛ́ Isibosɛ wɛ̃̀ baplaadee guun à gↄ̃̀ Isarailinↄ kína ũ. À kí blè wɛ̃̀ plaa. Yudanↄ sↄ̃, Daudan aↄ̃ zɛ̀o. ");
INSERT INTO bus_vpl VALUES ("S22_11","011_2_11","2SA","2","11","11","Dauda kí blè Yudanↄnɛ zaa Ɛblↄnu ai wɛ̃̀ swɛɛplaa kↄ̃n mↄ swɛɛdooo. ");
INSERT INTO bus_vpl VALUES ("S22_12","011_2_12","2SA","2","12","12","Nɛrɛ nɛ́ Abana kↄ̃n Solu nɛ́ Isibosɛ zĩ̀kpɛɛnↄ bↄ̀ Manaimu wà gàa Gibiↄ̃. ");
INSERT INTO bus_vpl VALUES ("S22_13","011_2_13","2SA","2","13","13","Zeruya nɛ́ Yoabu kↄ̃n Dauda zĩ̀kpɛɛnↄ fɛ̀ɛ wà gàa dańlɛ Gibiↄ̃ íkaɛkii saɛ. Aↄ̃ gãli doo kú í baa kɛ̀ kpa, aↄ̃ gãli doo kú í baa kãa kpa. ");
INSERT INTO bus_vpl VALUES ("S22_14","011_2_14","2SA","2","14","14","Ben Abana bè Yoabunɛ: Ǹ tó gↄ̃kparɛ kenↄ fɛɛ kↄ̃zi wà gwa. Ben Yoabu bè: Aↄ̃ gá. ");
INSERT INTO bus_vpl VALUES ("S22_15","011_2_15","2SA","2","15","15","Ben Bɛyãmi zĩ̀karinↄ fɛ̀ɛ gↄ̃ↄn kuri awɛɛplaa Isibosɛ pↄ́ ũ, ben Dauda zĩ̀karinↄ fɛ̀ɛ gↄ̃ↄn kuri awɛɛplaa se. ");
INSERT INTO bus_vpl VALUES ("S22_16","011_2_16","2SA","2","16","16","Baade ↄ kà a ↄsikari daa mìkpɛɛzi, ben aↄ̃ kↄ̃ zↄ̃̀zↄ̃ kↄ̃ gbã̀ntɛ̃a kↄ̃n fɛ̃ɛo aↄ̃ lɛ̀ɛ lɛdolɛ. Ben wà tↄ́ kpà Gibiↄ̃ guu pìnɛ Fɛ̃ɛlɛnnabura. ");
INSERT INTO bus_vpl VALUES ("S22_17","011_2_17","2SA","2","17","17","Zĩ̀ kɛ̀ wà kà zĩ beeea pãsĩ maamaa, ben Dauda zĩ̀kpɛɛnↄ zĩ̀ blè Abana kↄ̃n Isarailinↄa. ");
INSERT INTO bus_vpl VALUES ("S22_18","011_2_18","2SA","2","18","18","Zeruya nɛ́gↄ̃gbɛ̃ gↄ̃ↄn aagↄ̃ↄnↄↄ kú gwe, Yoabu kↄ̃n Abisaio kↄ̃n Asahɛlio. Asahɛli sↄ̃ bà nna lán zↄ̃ bà. ");
INSERT INTO bus_vpl VALUES ("S22_19","011_2_19","2SA","2","19","19","Ben à pɛ̀ɛ Abanazi, èe liɛ ↄplazi ke ↄzɛziro. ");
INSERT INTO bus_vpl VALUES ("S22_20","011_2_20","2SA","2","20","20","Kɛ̀ Abana a kpɛɛ gwà à à è, ben à bè: Asahɛli, ḿbe gweↄ́? À wèàla à bè: Mámbee! ");
INSERT INTO bus_vpl VALUES ("S22_21","011_2_21","2SA","2","21","21","Ben Abana bènɛ: Ǹ liɛ n ↄplaazi ke ↄzɛɛzi, ǹ gↄ̃kparɛnↄ doke kũ ǹ à pↄ́nↄ sía. Mↄde Asahɛli e zɛnɛro. ");
INSERT INTO bus_vpl VALUES ("S22_22","011_2_22","2SA","2","22","22","Abana ɛ̀ara à bènɛ dↄ: Ǹton sↄ̃maziro. Ń yezi mà n dɛn yↄ́? Tó ma n dɛ, mɛ́ we wa wɛ́ɛ kɛ siigↄ̃ kↄ̃n n vĩ̀i Yoabuo dↄↄ́? ");
INSERT INTO bus_vpl VALUES ("S22_23","011_2_23","2SA","2","23","23","Mↄde Asahɛli gì, èe zɛnɛro, ben Abana à zↄ̃̀ a gbɛɛɛn kↄ̃n a sári páo ai à bↄ̀ kpɛɛ kpa. Gwen à lɛ̀ɛn à gà gↄ̃ↄ. Kɛ̀ baade píngi kà guu kɛ̀ à lɛ̀ɛ à gà pìn, aↄ̃ zɛ̀ wèe gwaa. ");
INSERT INTO bus_vpl VALUES ("S22_24","011_2_24","2SA","2","24","24","Ben Yoabu kↄ̃n Abisaio pɛ̀ Abanazi ai ↄfãntɛ̃ gàa à gɛ̃̀o kpɛ́n. Aↄ̃ kà Ama sĩ̀sĩ kɛ̀ kú Gia ↄfãntɛ̃bↄɛ kpa Gibiↄ̃ gbáa zɛ́n. ");
INSERT INTO bus_vpl VALUES ("S22_25","011_2_25","2SA","2","25","25","Bɛyãmi boriinↄ kàkↄ̃a Abanazi gãli do, ben aↄ̃ gàa wèe gii kↄ̃n ń zĩndao sĩ̀sĩ musu. ");
INSERT INTO bus_vpl VALUES ("S22_26","011_2_26","2SA","2","26","26","Ben Abana lɛ́ zù Yoabuzi à bè: Wé zɛ kↄ̃dɛdɛnanɛroo? Ń dↄ̃ kɛ̀ yã pì é mì dɛ kↄ̃n pↄsiaaoroo? Nɛ́ o n gbɛ̃nↄnɛ aↄ̃ zɛwe aↄ̃ ɛara wà tároo? ");
INSERT INTO bus_vpl VALUES ("S22_27","011_2_27","2SA","2","27","27","Ben Yoabu wèàla à bè: Ludaa kuu! Tó nɛ́ɛ lɛ́ sí yãro, ma gbɛ̃nↄ é zɛarero ai gu gá dↄo. ");
INSERT INTO bus_vpl VALUES ("S22_28","011_2_28","2SA","2","28","28","Kɛ̀ Yoabu kuru pɛ̀, ben à gbɛ̃nↄ kámma bò, aↄ̃ↄe gá Isarailinↄa zĩ̀o dↄro. ");
INSERT INTO bus_vpl VALUES ("S22_29","011_2_29","2SA","2","29","29","Gwãavĩ beeea Abana kↄ̃n a gbɛ̃nↄ táa ò sɛ̃̀n aↄ̃ bikũ̀ Yodaa, ben aↄ̃ dↄ̀ swadↄↄzi ai aↄ̃ gàa wà kà Manaimu. ");
INSERT INTO bus_vpl VALUES ("S22_30","011_2_30","2SA","2","30","30","Kɛ̀ Yoabu sù kↄ̃n pɛna Abanaao, ben à a zĩ̀kpɛɛnↄ kàkↄ̃a ń píngi. Dauda gbɛ̃nↄ tɛ́ gↄ̃ↄn baro dosai bé wà kuuro, Asahɛli baasi. ");
INSERT INTO bus_vpl VALUES ("S22_31","011_2_31","2SA","2","31","31","Aↄ̃ Bɛyãmi kɛ̀ aↄ̃ↄ kú kↄ̃n Abanaonↄ dɛ̀dɛ gↄ̃ↄn wàa do kↄ̃n basↄraagↄ̃ↄo. ");
INSERT INTO bus_vpl VALUES ("S22_32","011_2_32","2SA","2","32","32","Aↄ̃ Asahɛli gɛ̀ sɛ̀ aↄ̃ↄ vĩ̀i à de miran Bɛtɛlɛmu. Ben Yoabu kↄ̃n a gbɛ̃nↄ táa ò gwãavĩ aↄ̃ kà Ɛblↄnu gudↄnao. ");
INSERT INTO bus_vpl VALUES ("S23_1","011_3_1","2SA","3","1","1","Zĩ̀ kɛ̀ Solu bɛdeenↄↄ kà kↄ̃n Dauda bɛdeenↄ gì kɛ̀. Dauda gbãaa e kaara, Solu bɛdeenↄ sↄ̃ gbãaa e lagoo. ");
INSERT INTO bus_vpl VALUES ("S23_2","011_3_2","2SA","3","2","2","Nɛ́gↄ̃gbɛ̃ kɛ̀ Dauda ì Ɛblↄnunↄ tↄ́n yɛ̀. À káaku tↄ́n Aminↄ. À da tↄ́n Ainↄama, Yɛzɛrili gbɛ̃mɛ. ");
INSERT INTO bus_vpl VALUES ("S23_3","011_3_3","2SA","3","3","3","À plaade tↄ́n Kiliabu. À da tↄ́n Abigaili, Nabala gyaanↄ Kamɛli gbɛ̃mɛ. À aagↄ̃de tↄ́n Abusalomu. À da tↄ́n Maaka, Gesuu kína Talamai nɛ́mɛ. ");
INSERT INTO bus_vpl VALUES ("S23_4","011_3_4","2SA","3","4","4","À siigↄ̃de tↄ́n Adonia. À da tↄ́n Agi. À sↄↄrode tↄ́n Sefatia. À da tↄ́n Abitali. ");
INSERT INTO bus_vpl VALUES ("S23_5","011_3_5","2SA","3","5","5","À swɛɛdode tↄ́n Itiriamu. À da tↄ́n Egela. Dauda nↄↄnↄ nɛ́ pìnↄ ì Ɛblↄnumɛ. ");
INSERT INTO bus_vpl VALUES ("S23_6","011_3_6","2SA","3","6","6","Gurↄↄ kɛ̀ Solu bɛdeenↄↄ e zĩ̀ kaa kↄ̃n Dauda bɛdeenↄ, Abana e gbãa kũu Solu bɛdeenↄ guu. ");
INSERT INTO bus_vpl VALUES ("S23_7","011_3_7","2SA","3","7","7","Solu nↄ yìgisai vĩ yã, à tↄ́n Rizipa, Aya nɛ́mɛ. Isibosɛ bè Abananɛ: N kɛ dia n daɛ kↄ̃n ma de nↄↄo? ");
INSERT INTO bus_vpl VALUES ("S23_8","011_3_8","2SA","3","8","8","Abana pↄ fɛ̃̀ maamaa Isibosɛ yã pì yãnzi à bè: Gbɛ̃ɛ gɛ̀n ma ũ Yudanↄ kpaↄ́? Mɛ́ɛ gbɛ̃kɛɛ kɛɛ n de Solu bɛdeenↄnɛ kↄ̃n à dãaronↄ kↄ̃n à gbɛ̃nnanↄ ai kↄ̃n a gbã̀ao. Mɛ́ɛ n na Daudanɛ a ↄzĩro, ben nɛ́ɛ ma taari ee nↄgbɛ̃ pì yã musu saa? ");
INSERT INTO bus_vpl VALUES ("S23_9","011_3_9","2SA","3","9","9","Tó mɛ́ɛ lɛ́ kɛ̀ Dii gbɛ̃̀ Daudanɛ kɛnɛro, Luda yã kɛmɛ pãsĩpãsĩ. ");
INSERT INTO bus_vpl VALUES ("S23_10","011_3_10","2SA","3","10","10","Mɛ́ kpata sí Solu bɛdeenↄa mà tó Dauda gↄ̃ Isarailinↄ kↄ̃n Yudanↄ kína ũ sɛna zaa Dani ai à gá pɛ́o Bɛɛsɛbaa. ");
INSERT INTO bus_vpl VALUES ("S23_11","011_3_11","2SA","3","11","11","Isibosɛ e sí à wè Abanala dↄro, kɛ̀ èe vĩa kɛɛnɛ yãnzi. ");
INSERT INTO bus_vpl VALUES ("S23_12","011_3_12","2SA","3","12","12","Abana gbɛ̃nↄ zĩ̀ Daudaa kↄ̃n a tↄ́o à bènɛ: Dé bé à bùsu vĩi? Wà lɛdolɛ kɛ, mɛ́ dↄnlɛ lɛ Isarailinↄ bà e àgↄ̃ kúnyo ń píngi. ");
INSERT INTO bus_vpl VALUES ("S23_13","011_3_13","2SA","3","13","13","Ben Dauda bè: À maa, mɛ́ lɛdolɛ kɛnyo, mↄde yã mɛ̀n doon mɛ́ɛ gbekaamma. Tó nɛ́ɛ mↄↄ ma gwa, tó nɛ́ɛ mↄ́mɛ kↄ̃n Solu nɛ́nↄgbɛ̃ Mikalaoro, ǹton tó wa wɛ́ɛ sikↄ̃lɛro. ");
INSERT INTO bus_vpl VALUES ("S23_14","011_3_14","2SA","3","14","14","Dauda lɛ́kpãsã kɛ̀ Solu nɛ́ Isibosɛnɛ à bè: Ǹ ma naↄ̃ Mikala sukpamɛ. Ma anzure blè kↄ̃n Filisitininↄ gɛfↄↄo mɛ̀n basↄↄro. ");
INSERT INTO bus_vpl VALUES ("S23_15","011_3_15","2SA","3","15","15","Ben Isibosɛ gbɛ̃nↄ zĩ̀, aↄ̃ nↄgbɛ̃ pì sì a zã Palatiɛli, Laisi nɛ́a. ");
INSERT INTO bus_vpl VALUES ("S23_16","011_3_16","2SA","3","16","16","Ben à zã pì e gaao à tɛ́zi ai Bahurimu, èe ↄ́ↄ dↄↄ. Ben Abana ònɛ à ɛara à tá, ben à ɛ̀ara. ");
INSERT INTO bus_vpl VALUES ("S23_17","011_3_17","2SA","3","17","17","Abana yã ò kↄ̃n Isaraili gbɛ̃nsinↄ à bè: Zaa zi ée wɛtɛɛ Dauda gↄ̃ dɛ a kína ũ. ");
INSERT INTO bus_vpl VALUES ("S23_18","011_3_18","2SA","3","18","18","À à ká sa, zaakɛ Dii lɛ́ gbɛ̃̀nɛ à bè, é a gbɛ̃ Isarailinↄ bↄ Filisitininↄ kↄ̃n ń ibɛɛnↄ ↄzĩ ń píngi a zↄ̀bleri Dauda pì gãzĩmɛ. ");
INSERT INTO bus_vpl VALUES ("S23_19","011_3_19","2SA","3","19","19","Abana yã pì dà Bɛyãmi boriinↄnɛ ń swãla dↄ. Ben à gàa Ɛblↄnu, lɛ à yã kɛ̀ à kɛ̀ Bɛyãmi boriinↄ kↄ̃n Isarailinↄnɛ pì o Daudanɛ. ");
INSERT INTO bus_vpl VALUES ("S23_20","011_3_20","2SA","3","20","20","Kɛ̀ à kà Dauda kiia zaa Ɛblↄnu kↄ̃n gↄ̃ↄn baroo kɛ̀ aↄ̃ kúonↄ, ben Dauda pↄnna pↄ́blee kɛ̀ńnɛ. ");
INSERT INTO bus_vpl VALUES ("S23_21","011_3_21","2SA","3","21","21","Ben Abana bè Daudanɛ: Ma dii kí, ǹ tó mà fɛɛ mà gá mà Isarailinↄ kakↄ̃annɛ ń píngi, lɛ aↄ̃ lɛdolɛ kɛnyo, nɛ́gↄ̃ dɛ bùsu kɛ̀ n pↄↄ yezi píngi kína ũ. Ben Dauda Abana gbàrɛ, à tá aafia. ");
INSERT INTO bus_vpl VALUES ("S23_22","011_3_22","2SA","3","22","22","Zĩ beeea Yoabu kↄ̃n Dauda gbɛ̃nↄ sù kↄ̃n lɛ́ɛmmanao. Aↄ̃ pↄ́nↄ sì gbɛ̃nↄa maamaa aↄ̃ sùo. Abana kú kↄ̃n Daudao gwe dↄro, zaakɛ à à gbàrɛ, à tá aafia. ");
INSERT INTO bus_vpl VALUES ("S23_23","011_3_23","2SA","3","23","23","Kɛ̀ Yoabu kↄ̃n zĩ̀kari kɛ̀ aↄ̃ kúonↄ kà, wà ònɛ Nɛrɛ nɛ́ Abana mↄ̀ kína gwa, ben à à gbàrɛ à tá aafia. ");
INSERT INTO bus_vpl VALUES ("S23_24","011_3_24","2SA","3","24","24","Ben Yoabu gàa à kína lè à bè: Bↄ́ yãn ń kɛ̀ gwee? Kɛ̀ Abana mↄ̀ n kiia, bↄ́yãnzi ń tò à tàzi? ");
INSERT INTO bus_vpl VALUES ("S23_25","011_3_25","2SA","3","25","25","Ń Nɛrɛ nɛ́ Abana dↄ̃roo? À mↄ̀ ↄ̃ndↄ̃ↄ kɛnzi, lɛ à e àgↄ̃ n gágurↄↄ kↄ̃n n sugurↄↄo dↄ̃ kↄ̃n n yãkɛnanↄ píngi. ");
INSERT INTO bus_vpl VALUES ("S23_26","011_3_26","2SA","3","26","26","Kɛ̀ Yoabu bↄ̀ Dauda kiia, ben à gbɛ̃nↄ zĩ̀, aↄ̃ pɛ̀ɛ Abanazi. Aↄ̃ à lè Sira lↄ̀gↄ kiia, ben aↄ̃ↄe suuo, mↄde Dauda à yã dↄ̃ro. ");
INSERT INTO bus_vpl VALUES ("S23_27","011_3_27","2SA","3","27","27","Kɛ̀ wà kà kↄ̃n Abanao Ɛblↄnu wɛ́tɛ bĩilɛa, ben Yoabu à sìsi lándↄ̃ à yezi à asiiyã onɛ bà, ben à à zↄ̃̀ a gbɛɛɛn, à à dɛ̀. À dãaro Asahɛli dɛna gɛ̃ɛn à bòa gwe. ");
INSERT INTO bus_vpl VALUES ("S23_28","011_3_28","2SA","3","28","28","Beee gbɛra kɛ̀ Dauda mà, à bè: Mapi kↄ̃n ma kíkɛɛo, mɛ́gↄ̃ taari vĩ Diinɛ Nɛrɛ nɛ́ Abana dɛna yã musuro. ");
INSERT INTO bus_vpl VALUES ("S23_29","011_3_29","2SA","3","29","29","Yã pì é wí Yoabu musumɛ kↄ̃n à de bɛdeenↄ ń píngi. Yoabu bɛdeenↄ égↄ̃ kuu kɛntudee ke kusu ke ɛrɛ ke gbɛ̃ kɛ̀ zĩ̀ à blè ke nↄadɛri sairo. ");
INSERT INTO bus_vpl VALUES ("S23_30","011_3_30","2SA","3","30","30","Yoabu kↄ̃n Abisaio Abana dɛ̀, kɛ̀ àmbe à ń dãaro Asahɛli dɛ̀ zĩ̀lan zaa Gibiↄ̃ yãnzi. ");
INSERT INTO bus_vpl VALUES ("S23_31","011_3_31","2SA","3","31","31","Ben Dauda bè Yoabunɛ kↄ̃n gbɛ̃ kɛ̀ aↄ̃ kúonↄ ń píngi: À a pↄ́kãsãanↄ gága à kɛ̃kɛ̃, à uta kãsãanↄ dada, àgↄ̃ tɛ́ aɛ kↄ̃n Abana gɛ̀o kↄ̃n ↄ́ↄ dↄↄo. Kí Dauda sↄ̃ↄ tɛ́ ń kpɛɛ. ");
INSERT INTO bus_vpl VALUES ("S23_32","011_3_32","2SA","3","32","32","Ben wà à vĩ̀i Ɛblↄnu gwe. Kína sósobi ↄ́ↄ dↄ̀ gbãngbãn Abana miraa, ben baade píngi ↄ́ↄ dↄ̀ se. ");
INSERT INTO bus_vpl VALUES ("S23_33","011_3_33","2SA","3","33","33","Ben kína sósobilɛ kɛ̀kii sì Abana yã musu à bè: Abana gana lán mìsaidee bà maan gweↄ́? ");
INSERT INTO bus_vpl VALUES ("S23_34","011_3_34","2SA","3","34","34","Wèe n gã̀ yinnɛ n kpɛɛ kparo, wèe gata kpánnɛro, n ga lán gbɛ̃ kɛ̀ gɛ̃̀ zaakɛrinↄ ↄzĩ bà. Ben baade píngi ɛ̀ara wà ↄ́ↄ dↄ̀ dↄ. ");
INSERT INTO bus_vpl VALUES ("S23_35","011_3_35","2SA","3","35","35","Baade píngi mↄ̀ wà ò Daudanɛ à pↄ́ ble ai guu gↄ̃ gá si, mↄde à ladà à bè: Tó ma burɛdi ke pↄ́ble ke dà ma lɛ́n ↄfãntɛ̃ gɛ̃na kpɛ́n sai, Luda yã kɛmɛ pãsĩpãsĩ. ");
INSERT INTO bus_vpl VALUES ("S23_36","011_3_36","2SA","3","36","36","Baade píngi wɛ́ɛ tɛ̀ yã pìzi, ben à kɛ̀ńnɛ maa. Yã kɛ̀ kí e kɛɛ píngi è kɛ gbɛ̃nↄnɛ maamɛ. ");
INSERT INTO bus_vpl VALUES ("S23_37","011_3_37","2SA","3","37","37","Zĩ beeea Dauda gbɛ̃nↄ kↄ̃n Isarailinↄ píngi dↄ̃̀ sa kɛ̀ kí lɛ́ kú Nɛrɛ nɛ́ Abana dɛna yãnlo. ");
INSERT INTO bus_vpl VALUES ("S23_38","011_3_38","2SA","3","38","38","Ben à bè a gbɛ̃ pìnↄnɛ: Á dↄ̃ kɛ̀ Isaraili dↄn'aɛde bíta gà gbã̀aroo? ");
INSERT INTO bus_vpl VALUES ("S23_39","011_3_39","2SA","3","39","39","Mamↄma sↄ̃, baa kɛ̀ Luda ma ka kí ũ, ma busa gbã̀a. Zeruya nɛ́ pìnↄ yãkɛna pãsĩ dɛ ma pↄ́la. Dii bé eé fĩa bo zaakɛrinɛ a zaa lɛ́n. ");
INSERT INTO bus_vpl VALUES ("S24_1","011_4_1","2SA","4","1","1","Kɛ̀ Solu nɛ́ Isibosɛ mà Abana gà Ɛblↄnu, à kã gà, ben Isarailinↄ gↄ̃̀ bídi guu ń píngi. ");
INSERT INTO bus_vpl VALUES ("S24_2","011_4_2","2SA","4","2","2","Solu nɛ́ pì zĩ̀kpɛ gbɛ̃nsinↄ vĩ gↄ̃ↄn plaa, à doo tↄ́n Baana, à doo sↄ̃ Rekabu. Beero gbɛ̃ Rimↄ, Bɛyãmi bori nɛ́nↄmɛ. Wà Beero dìɛ Bɛyãmi bùsu pↄ́ ũ yãmɛ, ");
INSERT INTO bus_vpl VALUES ("S24_3","011_4_3","2SA","4","3","3","zaakɛ Beerodeenↄ bàa lɛ̀ wà tà Gitaimu aↄ̃ↄ kú gwe ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("S24_4","011_4_4","2SA","4","4","4","Solu nɛ́ Yonatã sↄ̃ nɛ́ vĩ ɛrɛ ũ. Gurↄↄ kɛ̀ nɛ́ pì kà wɛ̃̀ sↄↄro, ben Solu kↄ̃n Yonatão gana Yɛzɛrili baaru sù. Kɛ̀ à gwàri à sɛ̀ èe bàa lɛɛo, à wãna guun nɛ́ pì pìtia à lɛ̀ɛ. Bee bé à tò à ɛrɛ kũ̀. À tↄ́n Mɛfibosɛ. ");
INSERT INTO bus_vpl VALUES ("S24_5","011_4_5","2SA","4","5","5","Beero gbɛ̃ Rimↄ nɛ́ pìnↄ Rekabu kↄ̃n Baanao fɛ̀ɛ, ↄfãntɛ̃ gbãaazin aↄ̃ kà Isibosɛ bɛ, gurↄↄ kɛ̀ èe i fãantɛ̃ oo. ");
INSERT INTO bus_vpl VALUES ("S24_6","011_4_6","2SA","4","6","6","Ben Rekabu kↄ̃n a dãaro Baanao gɛ̃̀ kpɛ́n aↄ̃ↄ kɛ̀ lándↄ̃ wèe gaa pↄ́wɛɛ kↄↄ bà. ");
INSERT INTO bus_vpl VALUES ("S24_7","011_4_7","2SA","4","7","7","Kɛ̀ aↄ̃ gɛ̃̀ kpɛ́n, Isibosɛ daɛna a gádoa, ben aↄ̃ gɛ̃̀zi kpɛ́nɛ guu aↄ̃ à zↄ̃̀ wà dɛ̀. Ben aↄ̃ à mì zↄ̃̀ aↄ̃ↄ sɛ̀ wà tào. Aↄ̃ pɛ̀ɛ Yoda sɛ̃̀n, ben aↄ̃ táa ò ai guu gàa à dↄ̀o. ");
INSERT INTO bus_vpl VALUES ("S24_8","011_4_8","2SA","4","8","8","Aↄ̃ mↄ̀ Dauda kiia Ɛblↄnu kↄ̃n Isibosɛ mìo aↄ̃ bènɛ: Ǹ gwa, n ibɛɛ Solu kɛ̀ à wɛ̀tɛ à n dɛ nɛ́ Isibosɛ mìn yɛ̀. Wa dii kí, Dii gɛ̃ɛ bònnɛ Solu kↄ̃n a boriinↄa gbã̀a. ");
INSERT INTO bus_vpl VALUES ("S24_9","011_4_9","2SA","4","9","9","Dauda wèńla à bè: Dii kuu! À ma bↄ ma nawɛ̃akɛna guu píngi. ");
INSERT INTO bus_vpl VALUES ("S24_10","011_4_10","2SA","4","10","10","Kɛ̀ gbɛ̃ke mↄ̀ ma kiia Zikilaga yã à bè Solu gà, èe daa baaru nnaan ée kpaa, ben ma à kũ̀ má dɛ̀. À baaru àren gwe. ");
INSERT INTO bus_vpl VALUES ("S24_11","011_4_11","2SA","4","11","11","Dɛbeeelana lán amↄa gbɛ̃ zaaanↄ a taarisaidee dɛ̀ a gádoa a kpɛ́n nà, mɛ́ à dɛna gɛ̃ɛ boawa mà a wɛ̃̀ndi bↄ se. ");
INSERT INTO bus_vpl VALUES ("S24_12","011_4_12","2SA","4","12","12","Ben Dauda yã ò a gbɛ̃nↄnɛ, ben aↄ̃ ń dɛdɛ. Aↄ̃ ń ↄla kↄ̃n ń gbálanↄ zↄ̃̀zↄ̃, ben aↄ̃ ń gɛ̀nↄ lògo Ɛblↄnu ítↄkii saɛ. Ben wà Isibosɛ mì sɛ̀ wà vĩ̀i Abana miran zaa Ɛblↄnu. ");
INSERT INTO bus_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","Isarailinↄ mↄ̀ ń boriia ń píngi Dauda kiia zaa Ɛblↄnu aↄ̃ bè: Wa aru dↄ̃nkↄ̃mɛ. ");
INSERT INTO bus_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","Zaa zi gurↄↄ kɛ̀ Solu dɛ wa kí ũ, ḿbe nɛɛ̀ dↄwe aɛ zĩ̀lan, gana kↄ̃n sunao. Ben Dii bènnɛ, ḿbe nɛ́gↄ̃ dɛ a gbɛ̃ Isarailinↄ dↄn'aɛdee ũ, aↄ̃ kína ũ. ");
INSERT INTO bus_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","Kɛ̀ Isaraili gbɛ̃nsinↄ mↄ̀ kí Dauda kiia zaa Ɛblↄnu ń píngi, gwen à lɛdolɛ kɛ̀nńyo Dii aɛ, ben aↄ̃ nↄ́si kù à mìa aↄ̃ à kà Isarailinↄ kpatan. ");
INSERT INTO bus_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","Dauda kɛ̀ wɛ̃̀ baaakuri gurↄↄ kɛ̀ à nà kíblenaa, à vɛ̃̀ɛ kpatan wɛ̃̀ baplaa. ");
INSERT INTO bus_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","À kí blè Yudanↄnɛ zaa Ɛblↄnu wɛ̃̀ swɛɛplaa kↄ̃n mↄ swɛɛdoo, ben à kí blè Yudanↄnɛ kↄ̃n Isarailinↄ píngi zaa Yerusalɛmu wɛ̃̀ baaakuri awɛɛ'aagↄ̃. ");
INSERT INTO bus_vpl VALUES ("S25_6","011_5_6","2SA","5","6","6","Kí kↄ̃n a gbɛ̃nↄ gàa Yerusalɛmu lɛ à zĩ̀ ká kↄ̃n Yebusi kɛ̀ aↄ̃ↄ kú gweenↄ. Ben aↄ̃ bè Daudanɛ: Nɛ́ gɛ̃ kɛ̀ro, baa vĩ̀anↄ kↄ̃n ɛrɛnↄ aↄ̃é pɛ́mma. Aↄ̃ↄe daa Dauda é e à gɛ̃ gwero. ");
INSERT INTO bus_vpl VALUES ("S25_7","011_5_7","2SA","5","7","7","Kↄ̃n beeeo Dauda wɛ́tɛ bĩidee kɛ̀ wè sísi dↄ Zayↄn pì sì, ben à gↄ̃̀ à wɛ́tɛdaa ũ. ");
INSERT INTO bus_vpl VALUES ("S25_8","011_5_8","2SA","5","8","8","Zĩ beeea Dauda bè: Tó gbɛ̃ yezi à Yebusinↄ dɛdɛ, séde à gɛ̃ ízɛ kɛ̀ wà yↄ̃̀ gbɛ̀n guu, eé ɛrɛnↄ kↄ̃n vĩ̀a pìnↄ le. Dauda ibɛɛnↄmɛ. Bee yãnzi wè be, vĩ̀anↄ kↄ̃n ɛrɛnↄ é gɛ̃ kíbɛro. ");
INSERT INTO bus_vpl VALUES ("S25_9","011_5_9","2SA","5","9","9","Ben Dauda bɛɛ kũ̀ wɛ́tɛ bĩidee pì guu, à a zĩnda tↄ́ kpànɛ, Dauda Wɛ́tɛ. À kpɛ́nↄ bòbo à lìgazi ai gura kɛ̀ wà wɛ̀ɛ tàtan, wè be Milo. ");
INSERT INTO bus_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","Dauda gbãaa e kaara, zaakɛ Dii Luda Zĩ̀kpɛdee kúo. ");
INSERT INTO bus_vpl VALUES ("S25_11","011_5_11","2SA","5","11","11","Taya kí Hiramu gbɛ̃nↄ zĩ̀ Daudaa kↄ̃n sida línↄ kↄ̃n lí'arinↄ kↄ̃n gbɛ̀'arinↄ, ben aↄ̃ bɛɛ bònɛ. ");
INSERT INTO bus_vpl VALUES ("S25_12","011_5_12","2SA","5","12","12","Ben Dauda dↄ̃̀ sa kɛ̀ Dii a ka Isarailinↄ kí ũmɛ, bensↄ̃ à a kpata kàaraare kɛ̀ Isarailinↄↄ dɛ Dii gbɛ̃nↄ ũ yãnzi. ");
INSERT INTO bus_vpl VALUES ("S25_13","011_5_13","2SA","5","13","13","Dauda bↄna Ɛblↄnu gbɛra à ɛ̀ara à nↄ pãndenↄ sɛ̀ à kàara Yerusalɛmu dↄ kↄ̃n nↄ yìgisainↄ, ben à nɛ́gↄ̃gbɛ̃nↄ kↄ̃n nɛ́nↄgbɛ̃nↄ ìńyo. ");
INSERT INTO bus_vpl VALUES ("S25_14","011_5_14","2SA","5","14","14","Nɛ́gↄ̃gbɛ̃ kɛ̀ à ń í Yerusalɛmu pìnↄ tↄ́n yɛ̀: Samua, Sobabu, Natã, Sulemanu, ");
INSERT INTO bus_vpl VALUES ("S25_15","011_5_15","2SA","5","15","15","Ibaa, Ɛlisua, Nɛfɛgi, Yafia, ");
INSERT INTO bus_vpl VALUES ("S25_16","011_5_16","2SA","5","16","16","Ɛlisama, Ɛliada kↄ̃n Ɛlifɛlɛtio. ");
INSERT INTO bus_vpl VALUES ("S25_17","011_5_17","2SA","5","17","17","Kɛ̀ Filisitininↄↄ mà wà Dauda kà Isarailinↄ kí ũ, ben aↄ̃ gàa wèe wɛtɛɛ wà à dɛ ń píngi. Kɛ̀ à ń baaru mà, ben à gàa sɛ̃̀tɛ pↄ̀rↄtu. ");
INSERT INTO bus_vpl VALUES ("S25_18","011_5_18","2SA","5","18","18","Filisitininↄ zĩ̀'ↄↄ pòro Rɛfaimu guzurɛn, ");
INSERT INTO bus_vpl VALUES ("S25_19","011_5_19","2SA","5","19","19","ben Dauda Dii là à bè: Mà gá mà lɛ́ɛ Filisitininↄa, nɛ́ ń namɛ ma ↄzĩↄ́? Ben Dii wèàla à bè: Ǹ gá, mɛ́ ń nannɛ n ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("S25_20","011_5_20","2SA","5","20","20","Ben Dauda gàa Baali Pɛrazimu, à zĩ̀ blèḿma gwe. Ben à bè: Dii dↄ̀mɛ aɛ, à bↄ̀ à mↄ̀ ma ibɛɛnↄzi bùi lán í è guu fↄ̃ nà. Ben à tↄ́ kpà guu pìnɛ Baali Pɛrazimu. ");
INSERT INTO bus_vpl VALUES ("S25_21","011_5_21","2SA","5","21","21","Filisitininↄ ń tãanↄ tò gwe, ben Dauda kↄ̃n a gbɛ̃nↄↄ sɛ̀ɛ wà tào. ");
INSERT INTO bus_vpl VALUES ("S25_22","011_5_22","2SA","5","22","22","Filisitininↄ ɛ̀ara wà mↄ̀ dↄ, aↄ̃ zĩ̀'ↄↄ pòro Rɛfaimu guzurɛn. ");
INSERT INTO bus_vpl VALUES ("S25_23","011_5_23","2SA","5","23","23","Ben Dauda ɛ̀ara à Dii là dↄ. Ben Dii wèàla à bè: Ǹton gáńzi súusuro. Ǹ ligańzi kpɛɛ kpa ǹ lɛ́ɛḿma kpɛ̃̀ líkpɛ saɛ. ");
INSERT INTO bus_vpl VALUES ("S25_24","011_5_24","2SA","5","24","24","Tó a kɛ̀sɛ kĩi mà lí pìnↄ musu, à kɛ kpakpaa, zaakɛ mámbe ma bↄ ma dↄare aɛ gwe, lɛ mà zĩ̀ bleare Filisitini zĩ̀kpɛɛnↄa yãnzi. ");
INSERT INTO bus_vpl VALUES ("S25_25","011_5_25","2SA","5","25","25","Dauda kɛ̀ lán Dii ònɛ nà, ben à zĩ̀ blè Filisitininↄa sɛna zaa Gibiↄ̃ ai à gàa pɛ́ Gɛzaa. ");
INSERT INTO bus_vpl VALUES ("S26_1","011_6_1","2SA","6","1","1","Dauda ɛ̀ara à Isaraili kɛ̀ à ń sɛ́nↄ kàkↄ̃a gↄ̃ↄn bↄrↄ baaakuri. ");
INSERT INTO bus_vpl VALUES ("S26_2","011_6_2","2SA","6","2","2","Ben à fɛ̀ɛ à dàńyo zɛ́n, aↄ̃ gàa Baala kɛ̀ kú Yuda bùsun, lɛ aↄ̃ Luda àkpati sɛ́ wà suo. Dii Zĩ̀kpɛde ègↄ̃ vɛ̃ɛna kpatan àkpati pì malaika dɛ̀bɛdeenↄ dagura, bee yãnzin wè be à tↄ́ kúazi. ");
INSERT INTO bus_vpl VALUES ("S26_3","011_6_3","2SA","6","3","3","Aↄ̃ àkpati pì dà zùgoro dufu guu Abinadabu bɛ sĩ̀sĩ musu, ben aↄ̃ dào zɛ́n. Abinadabu nɛ́nↄ Uza kↄ̃n Ahioo bé aↄ̃ↄe dↄↄ zùgoro pìzi, ");
INSERT INTO bus_vpl VALUES ("S26_4","011_6_4","2SA","6","4","4","Luda àkpati kún. Ahio bé à tɛ́ aɛ, ");
INSERT INTO bus_vpl VALUES ("S26_5","011_6_5","2SA","6","5","5","ben Dauda kↄ̃n Isarailinↄↄ e ↄ̃ wãa ń píngi Dii aɛ ń gbãa zaka lɛ́n kↄ̃n lɛ̀sinao. Wèe mↄrↄ lɛɛ kↄ̃n kúuo kↄ̃n sɛ̃gɛ̃sɛ̃gɛ̃o kↄ̃n fagao kↄ̃n sɛ̃̀gɛ̃o. ");
INSERT INTO bus_vpl VALUES ("S26_6","011_6_6","2SA","6","6","6","Kɛ̀ aↄ̃ kà Nakↄ̃ ésegbɛ̃kiia, zùnↄ gɛ̃̀n sì, ben Uza ↄ bↄ̀ à nà Luda àkpatia. ");
INSERT INTO bus_vpl VALUES ("S26_7","011_6_7","2SA","6","7","7","Ben Dii pↄ fɛ̃̀zi, à à lɛ̀ a dɛ̀ àkpati saɛ gwe dà kɛ̀ à kɛ̀ yãnzi. ");
INSERT INTO bus_vpl VALUES ("S26_8","011_6_8","2SA","6","8","8","Dauda nↄ̀sɛ yàka, kɛ̀ Dii pↄ fɛ̃̀ Uzazi yãnzi, ben wè guu pì sísi Pↄfɛ̃'uzazi ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("S26_9","011_6_9","2SA","6","9","9","Zĩ beeea vĩa Dauda kũ̀ Dii yã musu à bè: Dian mɛ́ kɛ nà mà Dii àkpati sɛ́ mà táo? ");
INSERT INTO bus_vpl VALUES ("S26_10","011_6_10","2SA","6","10","10","Ben èe we à táo a wɛ́tɛ guu dↄro, à lìɛ à tào Gata gbɛ̃ Ɔbɛdi Ɛdↄmu bɛ. ");
INSERT INTO bus_vpl VALUES ("S26_11","011_6_11","2SA","6","11","11","Dii àkpati kú à bɛ ai mↄ aagↄ̃, ben Dii aubarika dàn kↄ̃n à bɛdeenↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("S26_12","011_6_12","2SA","6","12","12","Wà bè kí Daudanɛ: Dii aubarika dà Ɔbɛdi Ɛdↄmu bɛdeenↄn kↄ̃n pↄ́ kɛ̀ à vĩinↄ píngi a àkpati yãnzi. Ben Dauda gàa gwe, à Luda àkpati sɛ̀ èe suuo a wɛ́tɛ guu kↄ̃n pↄnnaao. ");
INSERT INTO bus_vpl VALUES ("S26_13","011_6_13","2SA","6","13","13","Kɛ̀ gbɛ̃ kɛ̀ aↄ̃ↄ Dii àkpati sɛnanↄ gbá sɛ̀ gɛ̃̀n swɛɛdo, ben Dauda saa ò kↄ̃n zùswareeo kↄ̃n zùnɛ bↄ̀rↄ mɛ̀kpanao. ");
INSERT INTO bus_vpl VALUES ("S26_14","011_6_14","2SA","6","14","14","Dauda sa'o'uta dana, èe ↄ̃ wãa Dii aɛ a gbãa zaka lɛ́n. ");
INSERT INTO bus_vpl VALUES ("S26_15","011_6_15","2SA","6","15","15","Àpi kↄ̃n Isarailinↄ píngi e suu kↄ̃n Dii àkpatio, aↄ̃ↄe pↄnna wii lɛɛ, aↄ̃ↄe kuru pɛɛ. ");
INSERT INTO bus_vpl VALUES ("S26_16","011_6_16","2SA","6","16","16","Kɛ̀ Dii àkpati e gɛ̃ɛ Dauda wɛ́tɛ guu, ben Solu nɛ́ Mikala e tↄↄtɛ gwaa windo guu. Kɛ̀ à è kí Dauda e vĩvĩi èe ↄ̃ wãa Dii aɛ, à kya kàn a swɛ̃̀ guu. ");
INSERT INTO bus_vpl VALUES ("S26_17","011_6_17","2SA","6","17","17","Kɛ̀ wà sù kↄ̃n Dii àkpatio, wà dìɛ a gbɛ̀n bisakutaa kɛ̀ Dauda dↄ̀nɛ guu. Ben à sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ ò Dii aɛ kↄ̃n kɛnnakↄ̃o sa'opↄo. ");
INSERT INTO bus_vpl VALUES ("S26_18","011_6_18","2SA","6","18","18","Kɛ̀ à saa ò à yã̀a, à sa maaa ò gbɛ̃nↄnɛ kↄ̃n Dii Zĩ̀kpɛde tↄ́o. ");
INSERT INTO bus_vpl VALUES ("S26_19","011_6_19","2SA","6","19","19","Ben à burɛdi kpàatɛtɛ Isaraili kɛ̀ aↄ̃ kakↄ̃ana gweenↄnɛ kↄ̃̀ↄ doodo gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄ ń píngi kↄ̃n damina kàrao mɛ̀n doodo kↄ̃n geepi kàrao mɛ̀n doodo. ");
INSERT INTO bus_vpl VALUES ("S26_20","011_6_20","2SA","6","20","20","Kɛ̀ Dauda e suu bɛ lɛ à sa maaa o a bɛdeenↄnɛ, ben Solu nɛ́ Mikala bↄ̀ à gàa à dààlɛ à bè: Mmↄn Isarailinↄ kína, gbɛ̃ bɛ̀ɛde yãn ń kɛ̀ gwe gbã̀aↄ́? N n zĩnda mɛ̀ ↄ̀dↄa n ìba nↄgbɛ̃ zĩkɛrinↄnɛ, lán wísaidee è a zĩnda mɛ̀ ↄdↄańnɛ nà. ");
INSERT INTO bus_vpl VALUES ("S26_21","011_6_21","2SA","6","21","21","Ben Dauda bè Mikalanɛ: Diin ma ↄ̃ wã̀nɛ. Dii bé à ma sɛ n de kↄ̃n a bɛdeenↄ gɛ̃ɛ ũ, à ma kɛ a gbɛ̃ Isarailinↄ dↄn'aɛdee ũ. ");
INSERT INTO bus_vpl VALUES ("S26_22","011_6_22","2SA","6","22","22","Mɛ́ gbɛ̃ futa yã kɛ dɛ beeela, mɛ́ ma zĩnda kɛ̃sã n ena guu, mↄde nↄgbɛ̃ zĩkɛri kɛ̀ ń tɛ́ḿma pìnↄ bé aↄ̃é ma bɛ̀ɛ kɛ. ");
INSERT INTO bus_vpl VALUES ("S26_23","011_6_23","2SA","6","23","23","Solu nɛ́ Mikala sↄ̃ↄ e nɛ́ iro ai à gàa à gà o. ");
INSERT INTO bus_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","Kɛ̀ kí vɛ̃̀ɛ a bɛ, Dii à bↄ̀ ibɛɛ kɛ̀ aↄ̃ↄ ligazinↄ ↄzĩ à à gbà ĩampakii, ");
INSERT INTO bus_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","ben kí bè annabi Natãnɛ: Á'a! Kpɛ́ kɛ̀ wà dↄ̀ kↄ̃n sida líon mɛ́gↄ̃ vɛ̃ɛɛn, Luda àkpati gↄ̃ diɛna bisakutaan-ↄ́? ");
INSERT INTO bus_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Natã wèàla à bè: Lán à kɛ̀nnɛ nà ǹ kɛ, zaakɛ Dii kúnyo. ");
INSERT INTO bus_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","Gwãavĩ beeea Dii yã sù Natãa à bè: ");
INSERT INTO bus_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","Ǹ gá ǹ o ma zↄ̀bleri Daudanɛ kɛ̀ ma bè, àmbe eé kpɛ́ kɛ̀ mɛ́gↄ̃ kún dↄmɛro. ");
INSERT INTO bus_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","Zaa gurↄↄ kɛ̀ ma Isarailinↄ bↄ̀ɛ Igipiti ai gbã̀a mɛ́ɛ bɛɛ kũro. Mɛɛ̀gↄ̃ sↄ̃ki kpákpaamɛ, bisakuta bé ma kúkii ũ. ");
INSERT INTO bus_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","Guu kɛ̀ ma sↄ̃ki kpàkpan kↄ̃n ma gbɛ̃ Isarailinↄ ń píngi mɛɛ̀ dↄn'aɛdeenↄ diɛ aↄ̃ dↄńnɛ aɛ. Má ò ń gbɛ̃kenɛ, à kɛ̀ dia èe kpɛ́ dↄmɛ kↄ̃n sida líoro zikiↄ́? ");
INSERT INTO bus_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","Ǹ gá ǹ o ma zↄ̀bleri Daudanɛ, mamↄma Dii Zĩ̀kpɛde ma bè, ma à sɛ̀ sãdãkiia lɛ àgↄ̃ dɛ ma gbɛ̃ Isarailinↄ dↄn'aɛdee ũ. ");
INSERT INTO bus_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","Má kúo guu kɛ̀ à gàan píngi, ben ma à ibɛɛnↄ dɛ̀dɛnɛ. Mɛ́ à tↄ́ bↄ maamaa sa, eégↄ̃ kú anduna tↄ́deenↄ tɛ́. ");
INSERT INTO bus_vpl VALUES ("S27_10","011_7_10","2SA","7","10","10","Mɛ́ bùsu kpá ma gbɛ̃ Isarailinↄa, mɛ́ ń káɛn, aↄ̃é vɛ̃ɛn ń pↄ́ ũ. Aↄ̃ làakari gↄ̃ kpaɛna. Gbɛ̃ zaaanↄ é e wà wɛ́ɛ tãḿma lán aↄ̃ wɛ́ɛ tã̀ḿma káaku ");
INSERT INTO bus_vpl VALUES ("S27_11","011_7_11","2SA","7","11","11","gurↄↄ kɛ̀ ma dↄn'aɛdeenↄ dìɛńnɛ nà dↄro. Mɛ́ à bↄ a ibɛɛ pìnↄ ↄzĩ ń píngi. Mamↄma Dii mɛ́ɛ oonɛ, mámbe mɛ́ ua pɛ́ɛnɛ à boriinↄ gbãa'ekii ũ. ");
INSERT INTO bus_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Tó à gurↄↄ pàpa à gà, mɛ́ à borii kɛ̀ bↄ̀ à mɛ̀n ke sɛ́ lezĩ, mɛ́ à kpá kpatan. ");
INSERT INTO bus_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","Àpi bé eé kpɛ́ dↄ kɛ̀ ma tↄ́ égↄ̃ kúa, mɛ́ à kpatablena gbá pɛ́ɛ, eégↄ̃ kí blee ai gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Mɛ́gↄ̃ dɛnɛ De ũ, eégↄ̃ dɛ ma nɛ́ ũ. Tó à taari kɛ̀, mɛ́ wɛ́ɛ tãa kↄ̃n gòomɛ, lán gbɛ̃ntee è gbɛ̃ gbɛ̃ nà. ");
INSERT INTO bus_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Mↄde ma gbɛ̃kɛ é kɛ̃kↄ̃ao lán má kɛ̃̀kↄ̃a kↄ̃n Solu kɛ̀ má à bↄ̀ Dauda aɛzĩ nàro. ");
INSERT INTO bus_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","À boriinↄ égↄ̃ kpata blee gurↄ píngi. À kpata pì égↄ̃ yãana vĩro. ");
INSERT INTO bus_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Ben Natã yã pì gbã̀ Daudanɛ lán Dii ònɛ nà píngi. ");
INSERT INTO bus_vpl VALUES ("S27_18","011_7_18","2SA","7","18","18","Ben kí Dauda gɛ̃̀ à vɛ̃̀ɛ Dii aɛ à bè: Dii Luda, bↄ́n ma ũu? Dénↄn ma bɛdeenↄ ũ kɛ̀ n ma ka gwena kɛ̀ takaa? ");
INSERT INTO bus_vpl VALUES ("S27_19","011_7_19","2SA","7","19","19","Dii Luda, bee nɛ́ yã nɛ́ngomɛ n kiia, ben n mamↄma n zↄ̀bleri borii kɛ̀ aↄ̃égↄ̃ kú ziaanↄ yã ò dↄↄ́? Lɛn nɛɛ̀ kɛńnɛ lɛↄ́, Dii Luda? ");
INSERT INTO bus_vpl VALUES ("S27_20","011_7_20","2SA","7","20","20","Dii Luda, mɛ́ bennɛ diamɛ dↄↄ? Mamↄma n zↄ̀bleri ń ma dↄ̃. ");
INSERT INTO bus_vpl VALUES ("S27_21","011_7_21","2SA","7","21","21","N yã bíta pì kɛ̀ lán n pↄↄ yezi nà yã kɛ̀ ń ò yãnzi, ben ń tò mamↄma n zↄ̀bleri má dↄ̃̀. ");
INSERT INTO bus_vpl VALUES ("S27_22","011_7_22","2SA","7","22","22","Dii Luda, ń bíta fá! Weé gbɛ̃ke lɛ́kↄ̃zinyoro. N baasiro dii ke kuuro, lán wá mà kↄ̃n wa swão nà. ");
INSERT INTO bus_vpl VALUES ("S27_23","011_7_23","2SA","7","23","23","Dén weé lɛ́kↄ̃zi kↄ̃n n gbɛ̃ Isarailinↄↄ? Anduna boriinↄ tɛ́ bori mɛ̀n doo pìn n bↄ n gaa ń bò, lɛ aↄ̃gↄ̃ dɛ n gbɛ̃nↄ ũ. N n zĩnda tↄ́ bↄ̀, n yã bíta bↄnsaɛnↄ kɛ̀ n gbɛ̃ pìnↄnɛ, n pɛ bori kenↄa kↄ̃n ń tãanↄ n gbɛ̃ kɛ̀ n ń bó Igipitinↄ aɛzĩ. ");
INSERT INTO bus_vpl VALUES ("S27_24","011_7_24","2SA","7","24","24","N Isarailinↄ dìɛ aↄ̃gↄ̃ dɛ n gbɛ̃nↄ ũ ai gurↄ píngi. Dii, n gↄ̃ ń Luda ũ. ");
INSERT INTO bus_vpl VALUES ("S27_25","011_7_25","2SA","7","25","25","Dii Luda, lɛ́ kɛ̀ ń gbɛ̃̀ mamↄma n zↄ̀blerinɛ kↄ̃n ma boriinↄ yã musu, ǹgↄ̃ zĩi kɛɛa gurↄ píngi. Ǹ kɛ lán ń ò nà ");
INSERT INTO bus_vpl VALUES ("S27_26","011_7_26","2SA","7","26","26","lɛ ǹ tↄ́ bↄ maamaa ai gurↄ píngi. Gbɛ̃nↄ é be Dii Zĩ̀kpɛde bé Isarailinↄ Luda ũ. Mamↄma n zↄ̀bleri Dauda, nɛ́ ma boriinↄ kãsãa pɛ́ɛ, ");
INSERT INTO bus_vpl VALUES ("S27_27","011_7_27","2SA","7","27","27","zaakɛ Dii Zĩ̀kpɛde Isarailinↄ Luda, ń òmɛ n bè, nɛ́ ma ua pɛ́ɛmɛ ma boriinↄ gbãa'ekii ũ. Bee yãnzi mamↄma n zↄ̀bleri ma kùgbãaa kɛ̀ ma wɛ́ɛkɛɛ kɛ̀ kɛ̀mmazi. ");
INSERT INTO bus_vpl VALUES ("S27_28","011_7_28","2SA","7","28","28","Dii Luda, ḿbe Luda ũ, n yã náanɛ vĩ, ben n yã maaa kɛ̀nↄ lɛ́ gbɛ̃̀ mamↄma n zↄ̀blerinɛ. ");
INSERT INTO bus_vpl VALUES ("S27_29","011_7_29","2SA","7","29","29","Ǹ aubarika da mamↄma n zↄ̀bleri boriinↄn sa, n wɛ́ɛ égↄ̃ tɛ́ńzi gurↄ píngi. Dii Luda, n yã ò n aubarika dà mamↄma n zↄ̀bleri boriinↄn, aↄ̃égↄ̃ aubarika vĩ ai gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("S28_1","011_8_1","2SA","8","1","1","Beee gbɛra Dauda zĩ̀ blè Filisitininↄa à ń búsa à ń mɛɛwi Gata sìḿma. ");
INSERT INTO bus_vpl VALUES ("S28_2","011_8_2","2SA","8","2","2","À zĩ̀ blè Mↄabunↄa, ben à tò aↄ̃ dàɛ kↄ̃ saɛ tↄↄtɛ. À bà yↄ̃̀ḿma. Tó à gbɛ̃ kɛ̀ aↄ̃ↄ kú bà plaa dagura dɛ̀dɛ, è gbɛ̃ kɛ̀ aↄ̃ↄ kú bà do dagura tó bɛ̃ɛ. Ben Mↄabunↄ gↄ̃̀ Dauda zↄ̀blerinↄ ũ, ben aↄ̃ègↄ̃ tángba kpaanɛ. ");
INSERT INTO bus_vpl VALUES ("S28_3","011_8_3","2SA","8","3","3","Dauda zĩ̀ blè Reobo nɛ́ Adadɛza, Zoba kínaa, gurↄↄ kɛ̀ kí pì ɛ̀ara èe gaa ↄ tↄ̃ Yuflati swasaɛdeenↄa. ");
INSERT INTO bus_vpl VALUES ("S28_4","011_8_4","2SA","8","4","4","Ben à à sↄ̃goronↄ kũ̀kũ mɛ̀n wàa sↄↄro kↄ̃n sↄ̃gorodeenↄ gↄ̃ↄn bↄrↄ swɛɛplaa kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ tɛ́ kɛ̀sɛnↄ gↄ̃ↄn bↄrↄ baro. Ben à ń sↄ̃nↄ gbátĩkyanↄ zↄ̃̀zↄ̃ píngi, mɛ̀n basↄↄro bé aↄ̃ bↄ̀. ");
INSERT INTO bus_vpl VALUES ("S28_5","011_8_5","2SA","8","5","5","Siria kɛ̀ aↄ̃ↄ kú Damasakunↄ mↄ̀ ↄ da Adadɛzaa, ben Dauda ń gbɛ̃nↄ dɛ̀dɛ gↄ̃ↄn bↄrↄ baro awɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("S28_6","011_8_6","2SA","8","6","6","À gudãkparinↄ dìɛdiɛ Siria bùsun, ben aↄ̃ gↄ̃̀ à zↄ̀blerinↄ ũ, aↄ̃ègↄ̃ tángba kpaanɛ. Dii tò Dauda zĩ̀ blè guu kɛ̀ à gàan píngi. ");
INSERT INTO bus_vpl VALUES ("S28_7","011_8_7","2SA","8","7","7","Dauda Adadɛza ìbanↄ vura sɛngbangonↄ sɛ̀ɛ à tào Yerusalɛmu. ");
INSERT INTO bus_vpl VALUES ("S28_8","011_8_8","2SA","8","8","8","À mↄ̀gotɛ̃ sɛ̀ɛ bítabita Adadɛza wɛ́tɛ kɛ̀ wè sísi Teba kↄ̃n Berotaio guu. ");
INSERT INTO bus_vpl VALUES ("S28_9","011_8_9","2SA","8","9","9","Kɛ̀ Amata kí Tou mà Dauda zĩ̀ blè Adadɛza zĩ̀kpɛɛnↄa ń píngi, ");
INSERT INTO bus_vpl VALUES ("S28_10","011_8_10","2SA","8","10","10","ben à a nɛ́ Adoramu zĩ̀ ì kpáa. À à sáabu kpà zĩ̀ kɛ̀ à blè Adadɛzaa yãnzi, zaakɛ Tou zĩ̀ kào yã. Adoramu mↄ̀ kↄ̃n vura pↄ́nↄ kↄ̃n kondogi pↄ́nↄ kↄ̃n mↄ̀gotɛ̃ pↄ́nↄ, ");
INSERT INTO bus_vpl VALUES ("S28_11","011_8_11","2SA","8","11","11","ben kí Dauda kàɛ Dii pↄ́ ũ lán à kɛ̀ kↄ̃n borii kɛ̀ à gbãaa blèḿmanↄ kondogi pↄ́nↄ kↄ̃n vura pↄ́nↄo nà píngi, ");
INSERT INTO bus_vpl VALUES ("S28_12","011_8_12","2SA","8","12","12","Ɛdↄmunↄ kↄ̃n Mↄabunↄ kↄ̃n Amↄninↄ kↄ̃n Filisitininↄ kↄ̃n Amalɛkinↄ. Lɛn à kɛ̀ lɛ kↄ̃n pↄ́ kɛ̀ à sì Zoba kí Adadɛza, Reobo nɛ́ao. ");
INSERT INTO bus_vpl VALUES ("S28_13","011_8_13","2SA","8","13","13","Lɛn Dauda tↄ́ bↄ̀ lɛ. Kɛ̀ à zĩ̀ blè Sirianↄa à sù, à Ɛdↄmunↄ dɛ̀dɛ Guzurɛ Wisideen gↄ̃ↄn bↄrↄ baro plaasai. ");
INSERT INTO bus_vpl VALUES ("S28_14","011_8_14","2SA","8","14","14","Ben à gudãkparinↄ dìɛdiɛ Ɛdↄmu bùsun dↄ, ben Ɛdↄmu pìnↄ gↄ̃̀ à zↄ̀blerinↄ ũ. Guu kɛ̀ Dauda gàan píngi Dii è tó à zĩ̀ blemɛ. ");
INSERT INTO bus_vpl VALUES ("S28_15","011_8_15","2SA","8","15","15","Daudan Isaraili bori píngi kína ũ, à yã maaa kɛ̀ a gbɛ̃nↄnɛ a zɛ́a. ");
INSERT INTO bus_vpl VALUES ("S28_16","011_8_16","2SA","8","16","16","Zeruya nɛ́ Yoabun zĩ̀kpɛɛnↄ gbɛ̃nsi ũ. Ailudi nɛ́ Yosafatan baarukpari ũ. ");
INSERT INTO bus_vpl VALUES ("S28_17","011_8_17","2SA","8","17","17","Aitubu nɛ́ Zadↄki kↄ̃n Abiata nɛ́ Aimɛlɛkion sa'orikinↄ ũ. Serayan takadakɛ̃ri ũ. ");
INSERT INTO bus_vpl VALUES ("S28_18","011_8_18","2SA","8","18","18","Yoyada nɛ́ Bɛnayan dogarinↄ gbɛ̃nsi ũ. Dauda zĩnda nɛ́gↄ̃gbɛ̃nↄn a kpàasinↄ ũ. ");
INSERT INTO bus_vpl VALUES ("S29_1","011_9_1","2SA","9","1","1","Dauda gbɛ̃nↄ là: Solu bori kee e gↄ̃roo? Má yezi mà gbɛ̃kɛɛ kɛnɛ Yonatã yãnzi. ");
INSERT INTO bus_vpl VALUES ("S29_2","011_9_2","2SA","9","2","2","Solu bɛ zĩkɛri ke kuu, à tↄ́n Ziba, ben wà à sìsi kí Daudanɛ. À à là à bè: Ḿbe Ziba ũↄ́? À wèàla à bè: Ee, n zↄ̀blerin ma ũ. ");
INSERT INTO bus_vpl VALUES ("S29_3","011_9_3","2SA","9","3","3","Ben kí pì à là à bè: Solu bori ke kuu ai tiaↄ́? Má yezi mà Luda gbɛ̃kɛɛ kɛnɛmɛ. Ben Ziba wèàla à bè: Yonatã nɛ́ ke kuu ai tia. Ɛrɛmɛ. ");
INSERT INTO bus_vpl VALUES ("S29_4","011_9_4","2SA","9","4","4","Ben kí à là à bè: À kú mámɛ? Ziba wèàla à bè: À kú Amiɛli nɛ́ Maki bɛ zaa Lodɛba. ");
INSERT INTO bus_vpl VALUES ("S29_5","011_9_5","2SA","9","5","5","Kí Dauda gbɛ̃nↄ zĩ̀, ben wà mↄ̀o. ");
INSERT INTO bus_vpl VALUES ("S29_6","011_9_6","2SA","9","6","6","Kɛ̀ Yonatã nɛ́ Mɛfibosɛ, Solu dio kà Dauda kiia, à kùɛnɛ à dàɛ a puua. Ben Dauda bè: Mɛfibosɛ! À wèàla à bè: N zↄ̀blerin ma ũ. ");
INSERT INTO bus_vpl VALUES ("S29_7","011_9_7","2SA","9","7","7","Ben Dauda bènɛ: Ǹton tó vĩa n kũro, zaakɛ mɛ́ gbɛ̃kɛɛ kɛnnɛ n de Yonatã yãnzimɛ. Mɛ́ n dezi Solu buraanↄ sukpannɛ píngi, nɛ́gaegↄ̃ mↄↄ pↄ́ blemao gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("S29_8","011_9_8","2SA","9","8","8","Mɛfibosɛ kùɛnɛ à bè: Bↄ́n mamↄma n zↄ̀bleri ũ kɛ̀ nɛ́ ma wɛ̃nda gwaa? Má dɛ lán gbɛ̃ɛ gɛ̀ bàroo? ");
INSERT INTO bus_vpl VALUES ("S29_9","011_9_9","2SA","9","9","9","Ben kí Dauda Solu zĩkɛri Ziba sìsi à bènɛ: Pↄ́ kɛ̀ dɛ Solu pↄ́ ũ kↄ̃n à bɛdeenↄ pↄ́o píngi, má kpà n dii dioamɛ. ");
INSERT INTO bus_vpl VALUES ("S29_10","011_9_10","2SA","9","10","10","Mpi kↄ̃n n nɛ́nↄ kↄ̃n n zĩkɛrinↄ, àgae à tↄↄtɛ zĩi kɛnɛ, à à pↄ́nↄ kɛkɛ, lɛ à e àgↄ̃ kũsãɛ vĩ. N dii dio Mɛfibosɛ égaegↄ̃ pↄ́ bleemao gurↄ píngi. Ziba sↄ̃ nɛ́gↄ̃gbɛ̃nↄ vĩ gↄ̃ↄn gɛ̃ro kↄ̃n zĩkɛrinↄ gↄ̃ↄn baro. ");
INSERT INTO bus_vpl VALUES ("S29_11","011_9_11","2SA","9","11","11","Ben Ziba bè kínɛ: Yã kɛ̀ ma dii kí ò mamↄma a zↄ̀blerinɛ, mɛ́ kɛ píngimɛ. Ben Mɛfibosɛ ègↄ̃ pↄ́ blee kↄ̃n kío, à gↄ̃̀ lán kína nɛ́nↄ doke bà. ");
INSERT INTO bus_vpl VALUES ("S29_12","011_9_12","2SA","9","12","12","Mɛfibosɛ nɛ́gↄ̃gbɛ̃ vĩ, à tↄ́n Mika, bensↄ̃ Ziba bɛdeenↄ gↄ̃̀ Mɛfibosɛ zĩkɛrinↄ ũ ń píngi. ");
INSERT INTO bus_vpl VALUES ("S29_13","011_9_13","2SA","9","13","13","À kú Yerusalɛmu, zaakɛ ègↄ̃ pↄ́ blee kↄ̃n kío gurↄ píngimɛ. Bensↄ̃ ɛrɛn à ũ. ");
INSERT INTO bus_vpl VALUES ("S210_1","011_10_1","2SA","10","1","1","Beee gbɛra Amↄni kína gà, ben à nɛ́ Anuni vɛ̃̀ɛ à gɛ̃ɛ ũ. ");
INSERT INTO bus_vpl VALUES ("S210_2","011_10_2","2SA","10","2","2","Dauda bè: Mɛ́ gbɛ̃kɛɛ kɛ Naasa nɛ́ Anuninɛ lán à de gbɛ̃kɛɛ kɛ̀mɛ yã nà. Ben Dauda a ìba kenↄ zĩ̀a, lɛ aↄ̃ gá Amↄninↄ bùsun wà à làakari kpáɛnɛ à de ga yã musu. Kɛ̀ Dauda ìba pìnↄ kà gwe, ");
INSERT INTO bus_vpl VALUES ("S210_3","011_10_3","2SA","10","3","3","Amↄni kínɛnↄ bè ń dii Anuninɛ: Nɛ́ɛ daa Dauda gbɛ̃nↄ zĩ̀mma n de gɛ̀ kpedana yãnzi lɛ à n làakari kpáɛnnɛn yↄ́? À ń zĩ lɛ aↄ̃ mↄ́ wa wɛ́tɛ asii gwamɛ, lɛ aↄ̃ ɛara wà mↄ́ wà wɛ́tɛ ble zĩ̀o. ");
INSERT INTO bus_vpl VALUES ("S210_4","011_10_4","2SA","10","4","4","Ben Anuni Dauda ìba pìnↄ kũ̀kũ à ń lɛ́tãnka kã bò kpadokpado, à ń pↄ́kãsãanↄ zↄ̃̀zↄ̃ ń pↄ̀rↄnↄ dagura, ben à ń gbáɛ. ");
INSERT INTO bus_vpl VALUES ("S210_5","011_10_5","2SA","10","5","5","Kɛ̀ wà ò Daudanɛ, ben à gbɛ̃nↄ zĩ̀ aↄ̃ gá dańlɛ, zaakɛ wí ń kũ maamaa. Aↄ̃ bèńnɛ: Kí bè, à vɛ̃ɛ Yɛriko ai a lɛ́tãnka kã kú, é gbasa à su. ");
INSERT INTO bus_vpl VALUES ("S210_6","011_10_6","2SA","10","6","6","Kɛ̀ Amↄninↄↄ è Dauda ye ń kãzi dↄro, ben aↄ̃ fĩa bò gbɛ̃nↄnɛ lɛ aↄ̃ zĩ̀ káńnɛ: Siria kɛ̀ aↄ̃ↄ kú Bɛtɛreobu kↄ̃n Zobao kɛ̀ aↄ̃ↄ tɛ́ kɛ̀sɛnↄ gↄ̃ↄn bↄrↄ baro kↄ̃n kí Maaka zĩ̀kpɛɛnↄ gↄ̃ↄn bↄrↄ do kↄ̃n Tobudeenↄ gↄ̃ↄn bↄrↄ kuri awɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("S210_7","011_10_7","2SA","10","7","7","Kɛ̀ Dauda mà lɛ, ben à Yoabu gbàrɛḿma kↄ̃n zĩ̀karinↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("S210_8","011_10_8","2SA","10","8","8","Amↄninↄ bↄ̀ wà zĩ̀'ↄↄ pòro ń wɛ́tɛ bĩilɛa, ben Zoba kↄ̃n Bɛtɛreobuo Sirianↄ kↄ̃n Tobudeenↄ kↄ̃n Maaka gbɛ̃nↄↄ kú sɛ̃̀n ńtɛ̃ɛ. ");
INSERT INTO bus_vpl VALUES ("S210_9","011_10_9","2SA","10","9","9","Kɛ̀ Yoabu è wà zĩ̀'ↄↄ pòro a aɛ kↄ̃n a kpɛɛo, ben à Isaraili zĩ̀kari maaanↄ plɛ̀plɛ à ń kpáatɛtɛ aↄ̃ gá lɛ́ɛ Sirianↄa. ");
INSERT INTO bus_vpl VALUES ("S210_10","011_10_10","2SA","10","10","10","Ben à zĩ̀kari kpaaanↄ nà a dãaro Abisainɛ a ↄzĩ, ben à ń gbáɛ aↄ̃ gá lɛ́ɛ Amↄninↄa. ");
INSERT INTO bus_vpl VALUES ("S210_11","011_10_11","2SA","10","11","11","À bè: Tó Sirianↄ gbãaa e ma fuu, ǹ mↄ́ ǹ ↄ dama. Tó Amↄninↄ gbãaa e n fuumɛ sↄ̃, mɛ́ mↄ́ mà ↄ damma. ");
INSERT INTO bus_vpl VALUES ("S210_12","011_10_12","2SA","10","12","12","Ǹgↄ̃ gbãa, wà gↄ̃gbɛ̃kɛɛ kɛ wa gbɛ̃nↄ kↄ̃n wa Dii wɛ́tɛnↄ yã musu. Dii é yã kɛ̀ kɛ̀nɛ maa kɛ. ");
INSERT INTO bus_vpl VALUES ("S210_13","011_10_13","2SA","10","13","13","Ben Yoabu kↄ̃n zĩ̀kari kɛ̀ aↄ̃ kúonↄ gàa Sirianↄa kↄ̃n zĩ̀o, ben Siria pìnↄ bàa lɛ̀ńnɛ. ");
INSERT INTO bus_vpl VALUES ("S210_14","011_10_14","2SA","10","14","14","Kɛ̀ Amↄninↄↄ è Sirianↄ bàa lɛ̀, ben aↄ̃ bàa lɛ̀ Abisainɛ se aↄ̃ sì wɛ́tɛ guu, ben Yoabu ń tó gwe à tà Yerusalɛmu. ");
INSERT INTO bus_vpl VALUES ("S210_15","011_10_15","2SA","10","15","15","Kɛ̀ Sirianↄↄ è Isarailinↄ zĩ̀ blèḿma, ben aↄ̃ ɛ̀ara wà kↄ̃ kàkↄ̃a. ");
INSERT INTO bus_vpl VALUES ("S210_16","011_10_16","2SA","10","16","16","Ben Adadɛza gbɛ̃nↄ zĩ̀, aↄ̃ sù kↄ̃n Siria kɛ̀ aↄ̃ↄ kú Yuflati baa kãa kpaanↄ, ben aↄ̃ gàa Elamu. Sobakin Adadɛza zĩ̀kpɛɛ pìnↄ gbɛ̃nsi ũ. ");
INSERT INTO bus_vpl VALUES ("S210_17","011_10_17","2SA","10","17","17","Kɛ̀ Dauda mà lɛ, ben à Isarailinↄ kàkↄ̃a ń píngi, à bikũ̀ńyo Yodaa à gàa Elamu. Ben Sirianↄ zĩ̀'ↄↄ pòrozi, ben aↄ̃ sìkↄ̃n. ");
INSERT INTO bus_vpl VALUES ("S210_18","011_10_18","2SA","10","18","18","Kɛ̀ aↄ̃ↄe bàa lɛɛ Isarailinↄnɛ, ben Dauda ń dɛdɛ sↄ̃gorodeenↄ gↄ̃ↄn wàa aagↄ̃ kpɛ́ basↄↄro kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ tɛ́ kɛ̀sɛnↄ gↄ̃ↄn bↄrↄ baplaa. Gwen wà ń zĩ̀kpɛɛnↄ gbɛ̃nsi Sobaki dɛ̀n. ");
INSERT INTO bus_vpl VALUES ("S210_19","011_10_19","2SA","10","19","19","Kɛ̀ kí kɛ̀ aↄ̃ↄ dɛ Adadɛza zↄ̀blerinↄ ũu è Isarailinↄ zĩ̀ blèḿma lɛ, ben aↄ̃ lɛdolɛ kɛ̀ kↄ̃n Isarailinↄ aↄ̃ gↄ̃̀ ń zↄ̀blerinↄ ũ. Vĩa Sirianↄ kũ̀, aↄ̃ↄe gá wà ↄ da Amↄninↄa dↄro. ");
INSERT INTO bus_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","Kɛ̀ í kɛ̃̀ tↄↄtɛa, gurↄↄ kɛ̀ kínanↄ è gá zĩ̀ ká, ben Dauda Yoabu zĩ̀ kↄ̃n a ìbanↄ kↄ̃n Isarailinↄ ń píngi. Aↄ̃ Amↄninↄ ásaru kɛ̀, ben aↄ̃ lìga Rabazi. Dauda sↄ̃ↄ kú Yerusalɛmu. ");
INSERT INTO bus_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","Kɛ̀ uusiɛ kɛ̀, ben Dauda fɛ̀ɛ a gádoa, èe ligaa a kpɛ́ musu. Zaa kpɛ́ musu gwe ben à nↄgbɛ̃ ke è, èe zú oo. Nↄgbɛ̃ pì nɛ́ nↄ maaamɛ maamaa, ");
INSERT INTO bus_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","ben à gbɛ̃ zĩ̀ wà nↄgbɛ̃ pì yã gbeka. Ben wà bènɛ: Ɛliamu nɛ́ Basɛban gwe, Iti bori Uria naↄ̃mɛ. ");
INSERT INTO bus_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","Ben Dauda gbɛ̃nↄ zĩ̀ wà à sísi. Kɛ̀ à mↄ̀, ben Dauda dàɛo, ben nↄgbɛ̃ pì tà bɛ. Àɛ sↄ̃ à zúbaɛ gbãsĩ bↄ̀ dufumɛ. ");
INSERT INTO bus_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","Kɛ̀ à nↄ̀ sì, ben à lɛ́kpãsã kɛ̀ Daudanɛ à bè a nↄ̀ sì. ");
INSERT INTO bus_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","Ben Dauda gbɛ̃ zĩ̀ Yoabua à bè: Ǹ Iti bori Uria gbarɛmɛ. Ben Yoabu à gbàrɛnɛ. ");
INSERT INTO bus_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","Kɛ̀ Uria pì mↄ̀, ben Dauda Yoabu aafia gbèka kↄ̃n zĩ̀kpɛɛnↄ kↄ̃n zĩ̀ kɛ̀ aↄ̃ↄe kaao. ");
INSERT INTO bus_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","Ben Dauda bènɛ: Ǹ tá bɛ ǹ zú o. Kɛ̀ Uria bↄ̀ kíbɛ, ben kína gbɛ̃ zĩ̀a kↄ̃n pↄ́bleeo. ");
INSERT INTO bus_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","Mↄde Uria e tá a bɛro, kíbɛ gãnu guun à ìn kↄ̃n kíbɛ zĩkɛrinↄ. ");
INSERT INTO bus_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","Kɛ̀ wà ò Daudanɛ wà bè, Uria e tá a bɛro, ben à Uria là à bè: À dɛ n bↄ tázi n sumɛ gwɛɛ? À kɛ̀ dia nɛ́ɛ tá bɛroo? ");
INSERT INTO bus_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","Uria wèàla à bè: Àkpati kↄ̃n Isarailinↄ kↄ̃n Yudanↄↄ kú bisakutaanↄ guu. Ma dii Yoabu kↄ̃n a gbɛ̃nↄↄ kú zĩ̀lan. Mɛ́ fↄ̃ mà tá bɛ mà pↄ́ ble mà í mi, mà daɛ kↄ̃n ma naↄ̃oro. Kↄ̃n n kuunao mɛ́ yã pì taka kɛro. ");
INSERT INTO bus_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","Ben Dauda bènɛ: Ǹ gↄ̃ kɛ̀ gbã̀a dↄ, zian mɛ́ n gbarɛ. Ben Uria gↄ̃̀ Yerusalɛmu zĩ beeea kↄ̃n a gudↄ làao dↄ. ");
INSERT INTO bus_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","Dauda à sìsi à pↄ́ blè à í mìo, ben Dauda í kàkanɛ. Mↄde kɛ̀ à bↄ̀ uusiɛ, à gàa à ì kↄ̃n a dii kína zĩkɛrinↄomɛ, èe tá a bɛro. ");
INSERT INTO bus_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","Kɛ̀ guu dↄ̀ Dauda takada kɛ̃̀ Yoabunɛ, ben à Uria gbàrɛo. ");
INSERT INTO bus_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","Takada pì guu à bè: À Uria dↄńnɛ aɛ guu kɛ̀ zĩ̀ pãsĩn, é bↄ à kpɛɛ lɛ wà e wà à dɛ. ");
INSERT INTO bus_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","Gurↄↄ kɛ̀ Yoabu e ligaa wɛ́tɛ pìzi, ben à Uria dà guu kɛ̀ à dↄ̃ gↄ̃sa gbãaanↄ kún. ");
INSERT INTO bus_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","Kɛ̀ wɛ́tɛdeenↄ bↄ̀ɛ wèe zĩ̀ kaa kↄ̃n Yoabuo, aↄ̃ Dauda zĩ̀kari kenↄ dɛ̀dɛ. Iti bori Uria kú ń tɛ́. ");
INSERT INTO bus_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","Ben Yoabu gbɛ̃ zĩ̀ Daudaa lɛ à zĩ̀ yã gbãnɛ píngi. ");
INSERT INTO bus_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","À bè zĩ̀ri pìnɛ: Tó n zĩ̀ yã gbã̀ kínɛ píngi n yãa, ");
INSERT INTO bus_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","tó à nↄ̀sɛ fɛ̀ɛ à n la à bè: Bↄ́ bé à tò a sↄ̃ wɛ́tɛzi kĩikĩi kↄ̃n zĩ̀o? Á dↄ̃ kɛ̀ bĩimusudeenↄ è kà gbarɛńzi tↄↄtɛroo? ");
INSERT INTO bus_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","Dé bé à Gidiↄn nɛ́ Abimɛlɛki dɛ̀? Nↄgbɛ̃ bé à ↄ sↄ̃̀ wísilↄgbɛzi zaa bĩi musu, ben à à dɛ̀ Tebeziroo? À kɛ̀ dia a sↄ̃ bĩizi kĩikĩi lɛɛ? Tó à ònnɛ lɛ, ǹ benɛ a zↄ̀bleri Uria, Iti borii gà dↄ. ");
INSERT INTO bus_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","Ben zĩ̀ri pì dà zɛ́n. Kɛ̀ à kà Dauda kiia, à yã kɛ̀ Yoabu dànɛ ònɛ píngi. ");
INSERT INTO bus_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","À bè: Gbɛ̃nↄ bↄ̀ɛ wɛ́tɛ guu wèe gbãa mↄↄwe bĩi kpɛɛmɛ, ben wa pɛḿma ai ń wɛ́tɛ bĩilɛa. ");
INSERT INTO bus_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","Aↄ̃ kàzurinↄↄ kú zaa bĩi musumɛ, ben aↄ̃ kà fã̀ n gbɛ̃nↄ tɛ́ tↄↄtɛ aↄ̃ n gbɛ̃kenↄ dɛ̀dɛ. N zↄ̀bleri Uria, Iti borii gà se. ");
INSERT INTO bus_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","Ben Dauda bè zĩ̀ri pìnɛ: Ǹ o Yoabunɛ àton tó yã pì à nↄ̀sɛ yakaro. Wègↄ̃ dↄ̃ gbɛ̃ kɛ̀ zĩ̀ é ń blero. À zĩ̀ ká wɛ́tɛ pìo kↄ̃n gbãaao à kaatɛ. Ǹ à gba swɛ̃̀ lɛ. ");
INSERT INTO bus_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","Kɛ̀ Uria naↄ̃ mà a zã gà, à ↄ́ↄ dↄ̀. ");
INSERT INTO bus_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","Kɛ̀ wà gɛ̀ kɛ̀ wà yã̀a, Dauda gbɛ̃nↄ zĩ̀ aↄ̃ sùo a bɛ, ben à gↄ̃̀ à nↄↄ ũ. À nɛ́ ìo gↄ̃gbɛ̃ ũ, ben yã kɛ̀ Dauda kɛ̀ pì kɛ̀ Diinɛ zaa. ");
INSERT INTO bus_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","Dii Natã zĩ̀ Daudaa. Kɛ̀ à kà, à bènɛ: Gↄ̃gbɛ̃ gↄ̃ↄn plaa kenↄ bé wà kú wɛ́tɛ ke guu, gbɛ̃ doo nɛ́ auzikideemɛ, gbɛ̃ doo sↄ̃ takaasideemɛ. ");
INSERT INTO bus_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","Auzikidee pì sãanↄ kↄ̃n zùnↄ vĩ paripari, ");
INSERT INTO bus_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","takaasidee pì sↄ̃ pↄ́ke vĩro, sã núnu nɛ́ngo mɛ̀n doken à lù. Ben à dàto ai à bíta kũ̀ à bɛ kↄ̃n à nɛ́nↄ. Aↄ̃ègↄ̃ pↄ́ dↄ̃nkↄ̃ blee aↄ̃ègↄ̃ í mii ta dↄ̃nkↄ̃n, è dàɛ à pↄtɛ, ben èe à gwaa lán a zĩnda nɛ́nↄkparɛ bà. ");
INSERT INTO bus_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","Kɛ̀ nibↄ pìta auzikidee pìa, ben èe we à sãa ke zù kũ̀ a kpàsa guu à nibↄ pì yàari kɛoro. Takaasidee sã núnu nɛ́ngo pìn à sìa à a nibↄ pì yàari kɛ̀o. ");
INSERT INTO bus_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","Ben Dauda pↄ fɛ̃̀ auzikidee pì yã musu maamaa, à bè Natãnɛ: Kↄ̃n Dii kuunao, à kↄ̃ sìo wà gbɛ̃ kɛ̀ yã pì kɛ̀ dɛmɛ. ");
INSERT INTO bus_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","Kɛ̀ à kɛ̀ lɛ, èe à wɛ̃nda gwaro, ɛ̃ndɛ̃ à sãa pì fĩa bo lɛo siigↄ̃. ");
INSERT INTO bus_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","Ben Natã bè Daudanɛ: Ḿbe adee pì ũ. Dii Isarailinↄ Luda bé à yã kɛ̀ ò à bè: Ma n ka Isarailinↄ kí ũ, ma n bↄ Solu ↄzĩ, ");
INSERT INTO bus_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","ben ma n dii pì bɛɛ kpàmma, ma à nↄↄnↄ nànnɛ n ↄzĩ. Ma Isarailinↄ kↄ̃n Yudanↄ kpàmma n gbɛ̃nↄ ũ. Tó beeenↄ kɛ̀mma nɛ́ngo yã, lɛ mà à pãndenↄ kaarannɛ dↄ. ");
INSERT INTO bus_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","Bↄ́yãnzi n kya kà ma yãnzi? N yã kɛ̀ má yeziroo kɛ̀, n Iti bori Uria dɛ̀ kↄ̃n fɛ̃ɛdaao, n à nↄↄ sìa ń sɛ̀. Ń tò Amↄninↄ à dɛ̀ zĩ̀ guu. ");
INSERT INTO bus_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","Zaa gbã̀a yã pãsĩ é kɛ̃ n bɛɛa ziki dↄro, zaakɛ n kya kàmagu, n Iti bori Uria nↄↄ sìa ń sɛ̀. ");
INSERT INTO bus_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","Ben Dii ɛ̀ara à yã kɛ̀ ò dↄ à bè: Ǹ ma! Mɛ́ tó n zĩnda bɛdeenↄ mↄ́nzi kɛnnɛ. Mɛ́ n nↄↄnↄ símma mà ń kpá n gbɛ̃daa kea n wáa, eé daɛńyo gupuraaa. ");
INSERT INTO bus_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","N yã pì kɛ̀ asii guumɛ. Mapi sↄ̃ mɛ́ yã pì kɛnnɛ gupuraaa Isarailinↄ wáa ń píngi. ");
INSERT INTO bus_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","Ben Dauda bè Natãnɛ: Ma durun kɛ̀ Diinɛ. Ben Natã bènɛ: Dii n durun kɛ̃̀mma, nɛ́ garo. ");
INSERT INTO bus_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","Mↄde lán n dↄkɛ Diio maamaa nà kↄ̃n yã pì kɛnao, bee yãnzi nɛ́gↄ̃gbɛ̃ kɛ̀ nↄgbɛ̃ pì ìnyo é gamɛ. ");
INSERT INTO bus_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","Kɛ̀ Natã tà bɛ, ben Dii tò nɛ́ kɛ̀ Uria naↄ̃ↄ ì kↄ̃n Daudao pì gyã kũ̀. ");
INSERT INTO bus_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","Ben Dauda e kúɛ kɛɛ Ludanɛ nɛ́ pì yã musu kↄ̃n lɛ́yinao, gwãavĩ è daɛ tↄↄtɛmɛ. ");
INSERT INTO bus_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","À bɛ gbɛ̃nsinↄ ègↄ̃ zɛàla lɛ aↄ̃ à fɛɛ tↄↄtɛ, mↄde è weziro, è pↄ́ bleńyoro. ");
INSERT INTO bus_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","À gurↄ swɛɛplaadee zĩn nɛ́ pì gà. Vĩa Dauda ìbanↄ kũ̀, aↄ̃ↄe fↄ̃ wà ònɛ kɛ̀ nɛ́ pì gàro. Aↄ̃ bè: Gurↄↄ kɛ̀ nɛ́ pì kuu, wa yã ònɛ, èe wa yã maro. Dian wé onɛ nà sa kɛ̀ nɛ́ pì gà? Eé yã zaaa kɛ. ");
INSERT INTO bus_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","Dauda è a ìbanↄↄ e yã kpãi ookↄ̃nɛ, ben a dↄ̃̀ kɛ̀ nɛ́ pì gàmɛ. À ń lá à bè: Nɛ́ pì gàn yↄ́? Ben aↄ̃ wèàla wà bè: Ee! À gàmɛ. ");
INSERT INTO bus_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","Dauda fɛ̀ɛ tↄↄtɛ à zú ò, à nↄ́si kɛ̀awa à a pↄ́kãsãanↄ lìɛ, ben à gàa à kùɛ Diinɛ a kpɛ́n. Kɛ̀ à ɛ̀ara à tà bɛ, à pↄ́blee gbèka, ben wà kpàa à blè. ");
INSERT INTO bus_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","À ìbanↄ à là wà bè: À kɛ̀ dia nɛ́ɛ yã kɛɛ lɛɛ? Gurↄↄ kɛ̀ nɛ́ pì kuu, n lɛ́ yì n ↄ́ↄ dↄ̀. Kɛ̀ à gà sa, n fɛɛ n pↄ́ blè. ");
INSERT INTO bus_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","À wèńla à bè: Gurↄↄ kɛ̀ nɛ́ pì kuu, ma lɛ́ yì ma ↄ́ↄ dↄ̀, zaakɛ ma bè, ke Dii é ma wɛ̃nda gwa à tó nɛ́ pì gↄ̃ kuu gwɛɛ, dé bé à dↄ̃ↄ? ");
INSERT INTO bus_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","Lán à gà nà sa, bↄ́yãnzin mɛ́gↄ̃ lɛ́yinazi dↄↄ? Mɛ́ fↄ̃ mà à vun yↄ́? Mɛ́ gá à kiiamɛ, mↄde eé ɛara à su ma kiiaro. ");
INSERT INTO bus_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","Dauda a naↄ̃ Basɛba làakari kpàɛnɛ, ben à gàa à dàɛo. À nɛ́ ì gↄ̃gbɛ̃ ũ, ben à tↄ́ kpànɛ Sulemanu. Dii yezi, ");
INSERT INTO bus_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","ben à annabi Natã zĩ̀a à tↄ́ kpà nɛ́ pìnɛ Yɛdidia Dii yenzi pì yãnzi. ");
INSERT INTO bus_vpl VALUES ("S212_26","011_12_26","2SA","12","26","26","Ai tia Yoabu kpɛ́ e zĩ̀ kaa kↄ̃n Amↄninↄ zaa Raba, ben à kíbɛɛ sì. ");
INSERT INTO bus_vpl VALUES ("S212_27","011_12_27","2SA","12","27","27","Ben à gbɛ̃nↄ zĩ̀ Daudaa à bè: Ma zĩ̀ kà kↄ̃n Rabadeenↄ, ben ma ń ítↄkii sìḿma. ");
INSERT INTO bus_vpl VALUES ("S212_28","011_12_28","2SA","12","28","28","Ǹ zĩ̀kpɛ kpaaanↄ kakↄ̃a sa, ǹ mↄ́ ǹ liga wɛ́tɛ pìzi ǹ sí. Tó lɛnlo, mɛ́ sí, weé ma tↄ́ kpánɛ. ");
INSERT INTO bus_vpl VALUES ("S212_29","011_12_29","2SA","12","29","29","Ben Dauda zĩ̀kpɛɛnↄ kàkↄ̃a ń píngi, à gàa à lɛ̀ɛ Rabaa à sì. ");
INSERT INTO bus_vpl VALUES ("S212_30","011_12_30","2SA","12","30","30","Wà ń kína vura fùra gò wà kù Daudanɛ. À tìisi kà kiloo baaakuri, bensↄ̃ gbɛ̀ bɛ̀ɛdee kúa. À wɛ́tɛ pì pↄ́nↄ nàkↄ̃a maamaa, ");
INSERT INTO bus_vpl VALUES ("S212_31","011_12_31","2SA","12","31","31","ben à gbɛ̃ kɛ̀ aↄ̃ↄ kú gweenↄ kũ̀kũ à bↄ̀ɛńyo, à ń dá sagasigi zĩin kↄ̃n diga zĩio kↄ̃n kpása zĩio, bensↄ̃ à tò aↄ̃ kúnku bↄ̀. Lɛn à kɛ̀ Amↄni wɛ́tɛnↄnɛ lɛ píngi, ben à ɛ̀ara à tà Yerusalɛmu kↄ̃n a zĩ̀kpɛɛnↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("S213_1","011_13_1","2SA","13","1","1","Beee gbɛra Dauda nɛ́ Abusalomu dãre maaa vĩ, à tↄ́n Tama, ben Dauda nɛ́ Aminↄ yezi. ");
INSERT INTO bus_vpl VALUES ("S213_2","011_13_2","2SA","13","2","2","Yã pì e ĩa daa Aminↄ pìa ai à kà gyãkɛna a dãre Tama pì yãnzi, zaakɛ à gↄ̃gbɛ̃ dↄ̃ro, eé fↄ̃ à yãke kɛnɛro. ");
INSERT INTO bus_vpl VALUES ("S213_3","011_13_3","2SA","13","3","3","Aminↄ gbɛ̃nna ke vĩ, à tↄ́n Yonadabu, Dauda vĩ̀i Simɛa nɛ́mɛ. Yonadabu ↄ̃ndↄ̃ gbãa, ");
INSERT INTO bus_vpl VALUES ("S213_4","011_13_4","2SA","13","4","4","ben à Aminↄ là à bè: À kɛ̀ dia n kínɛ'ina n mɛ̀ ègↄ̃ busana lán guu e dↄↄ nà lɛɛ? Nɛ́ omɛroo? Ben Aminↄ wèàla à bè: Má ye ma dãaro Abusalomu dãre Tamazimɛ. ");
INSERT INTO bus_vpl VALUES ("S213_5","011_13_5","2SA","13","5","5","Ben Yonadabu bènɛ: Ǹ gá ǹ daɛ n gádoa lán gyãreen n ũu bà. Tó n de mↄ̀ n gwa, ǹ onɛ ń yezi n dãre Tama mↄ́ à pↄ́blee kpámma. À mↄ́ à kɛkɛ n wáa lɛ n wɛ́ɛ gↄ̃ ee, gbasa à nannɛ n ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("S213_6","011_13_6","2SA","13","6","6","Ben Aminↄ dàɛ lán gyãree bà. Kɛ̀ kí mↄ̀ à gwa, ben à bènɛ: Ǹ tó ma dãre Tama mↄ́ à kàra kɛmɛ ma wáa, à kpáma kↄ̃n a ↄↄo. ");
INSERT INTO bus_vpl VALUES ("S213_7","011_13_7","2SA","13","7","7","Ben Dauda gbɛ̃ zĩ̀ Tamaa a bɛ à bè: Ǹ gá n vĩ̀i Aminↄ kpɛ́n ǹ pↄ́blee kɛnɛ. ");
INSERT INTO bus_vpl VALUES ("S213_8","011_13_8","2SA","13","8","8","Kɛ̀ Tama gɛ̃̀ à kpɛ́n, à à lè daɛna, ben à wísiti yà à kàra kàsao à wáa. ");
INSERT INTO bus_vpl VALUES ("S213_9","011_13_9","2SA","13","9","9","Ben à taa sɛ̀ à kàra pì kànnɛ. Aminↄ gì sózi à bè: Ǹ pɛ́ gbɛ̃nↄa aↄ̃ bↄɛ ń píngi. Kɛ̀ gbɛ̃ kɛ̀ aↄ̃ kúonↄ bↄ̀ɛ ń píngi, ");
INSERT INTO bus_vpl VALUES ("S213_10","011_13_10","2SA","13","10","10","ben à bè Tamanɛ: Ǹ mↄ́ kↄ̃n pↄ́blee pìo kpɛ́nɛ guu kɛ̀ ǹ kpáma. Ben Tama kàra kɛ̀ à kɛ̀ sɛ̀ à gɛ̃̀o a vĩ̀i Aminↄ pì kiia kpɛ́nɛ guu. ");
INSERT INTO bus_vpl VALUES ("S213_11","011_13_11","2SA","13","11","11","Kɛ̀ à sↄ̃̀zi, èe mↄↄ kpáa à só, ben à a dãre pì kũ̀ à bè: Ǹ tó mà daɛnyo. ");
INSERT INTO bus_vpl VALUES ("S213_12","011_13_12","2SA","13","12","12","Ben à bè a vĩ̀i pìnɛ: Auo! Ǹton gbãa mↄ́mɛro. Zaakɛ wa Isarailinↄ weè yã beee taka kɛro. Ǹton yã dↄ̀rↄsai beee taka kɛmɛro. ");
INSERT INTO bus_vpl VALUES ("S213_13","011_13_13","2SA","13","13","13","Mɛ́ gɛ̃ mámɛ kↄ̃n wíyã beeeo? Mmↄn sↄ̃, Isarailinↄ é n diɛ gbɛ̃ pãa ũ. Ǹ sùu kɛ! Ǹ yã o kínɛ, eé gí ma kpámmaziro. ");
INSERT INTO bus_vpl VALUES ("S213_14","011_13_14","2SA","13","14","14","Èe we à à yã màro. À gbãa mↄ̀nɛ, ben à kùsia à dàɛo. ");
INSERT INTO bus_vpl VALUES ("S213_15","011_13_15","2SA","13","15","15","Ben Aminↄ zàn pãsĩpãsĩ. Zangu kɛ̀ à sɛ̀ kↄ̃n Tama pìo dɛ yenzi kɛ̀ à vĩo yãala. Ben à bènɛ: Ǹ fɛɛ ǹ bↄ. ");
INSERT INTO bus_vpl VALUES ("S213_16","011_13_16","2SA","13","16","16","Ben nↄgbɛ̃ pì bè a vĩ̀i pìnɛ: Auo! N pɛnama taari bíta dɛ pↄ́ kɛ̀ ń kɛ̀mɛɛla. Baa kↄ̃n beeeo èe we à à yã màro. ");
INSERT INTO bus_vpl VALUES ("S213_17","011_13_17","2SA","13","17","17","Ben Aminↄ a zĩkɛri gↄ̃kparɛ sìsi à bè: Ǹ pɛ́ nↄgbɛ̃ kɛ̀a à bↄmɛ ma kpɛ́n, ǹ gbà tata ǹ à mↄ̀nɛ ká. ");
INSERT INTO bus_vpl VALUES ("S213_18","011_13_18","2SA","13","18","18","Ben à zĩkɛri pì à sɛ̀ à bↄ̀o bàazi, à gbà tàta à à mↄ̀nɛ kà. Nↄgbɛ̃ pì uta gbã̀a dana, zaakɛ uta beee takan kí nɛ́nↄkparɛ lɛziinↄ ègↄ̃ dana. ");
INSERT INTO bus_vpl VALUES ("S213_19","011_13_19","2SA","13","19","19","Ben Tama túbu gbɛ̃̀ a mìa, à a uta gbã̀a kɛ̀ à dana pì gà à kɛ̃̀ à ↄ dì a musu, èe ↄ́ↄ dↄↄ èe taa. ");
INSERT INTO bus_vpl VALUES ("S213_20","011_13_20","2SA","13","20","20","À dãgↄ̃ dadↄ̃nkↄ̃de Abusalomu bènɛ: N dãgↄ̃ Aminↄ dàɛnyon yↄ́? Ǹton o gbɛ̃ke maro, zaakɛ n dãgↄ̃mɛ. Ǹtongↄ̃ yã pì kũna n swɛ̃̀ guuro. Ben Tama vɛ̃̀ɛ a dãgↄ̃ Abusalomu bɛ nↄ̀sɛo yakana. ");
INSERT INTO bus_vpl VALUES ("S213_21","011_13_21","2SA","13","21","21","Kɛ̀ kí Dauda yã pì mà, à pↄ fɛ̃̀ maamaa. ");
INSERT INTO bus_vpl VALUES ("S213_22","011_13_22","2SA","13","22","22","Abusalomu e yãke o Aminↄnɛro, yã zaaa ke à maaa. À zàn, kɛ̀ à kùsi a dãre Tamaa yãnzi. ");
INSERT INTO bus_vpl VALUES ("S213_23","011_13_23","2SA","13","23","23","Wɛ̃̀ plaa gbɛra Abusalomu kú Baali Azo, Ɛflaimu bùsu lɛ́n kↄ̃n a sãkãkɛ̃ɛrinↄ, ben à kína nɛ́nↄ sìsi pↄnna pↄ́bleea ń píngi. ");
INSERT INTO bus_vpl VALUES ("S213_24","011_13_24","2SA","13","24","24","Ben à gàa à kí lè à bè: Kí, wèe mamↄma n zↄ̀bleri sãanↄ kã kɛ̃ɛɛ. Mpi kↄ̃n n ìbanↄ é tɛ́maziroo? ");
INSERT INTO bus_vpl VALUES ("S213_25","011_13_25","2SA","13","25","25","Ben kí wè a nɛ́ pìla à bè: Auo! Wé fↄ̃ wà gá wa píngiro. Wé kɛnnɛ asoo ũ. À nàkↄ̃rɛa, mↄde èe gáro, ben à sa maaa ònɛ. ");
INSERT INTO bus_vpl VALUES ("S213_26","011_13_26","2SA","13","26","26","Ben Abusalomu bè: Tó nɛ́ gáro, ǹ tó ma vĩ̀i Aminↄ gáwao. Kí à là à bè: Bↄ́yãnzi ń yezi à gányozi? ");
INSERT INTO bus_vpl VALUES ("S213_27","011_13_27","2SA","13","27","27","Abusalomu nàkↄ̃rɛa, ben kí tò Aminↄ gàao kↄ̃n a nɛ́ kpaaanↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("S213_28","011_13_28","2SA","13","28","28","Abusalomu yã dìɛ a gbɛ̃nↄnɛ à bè: À swã kpá! Tó í Aminↄ kũ̀, tó má òare à à zↄ̃, à à dɛ. Àton tó vĩa a kũro. Mámbe ma a dan! À zɛ gbãa à gↄ̃gbɛ̃kɛɛ kɛ. ");
INSERT INTO bus_vpl VALUES ("S213_29","011_13_29","2SA","13","29","29","Abusalomu gbɛ̃nↄ kɛ̀ lán à dìɛńnɛ nà aↄ̃ à dɛ̀, ben kína nɛ́ kpaaanↄ fɛ̀ɛ wà dì ń bãagãsↄ̃nↄ kpɛɛ aↄ̃ bàa lɛ̀. ");
INSERT INTO bus_vpl VALUES ("S213_30","011_13_30","2SA","13","30","30","Gurↄↄ kɛ̀ aↄ̃ↄ tɛ́ zɛ́n, Dauda à baaru mà wà bè: Abusalomu kí nɛ́nↄ dɛ̀dɛ ń píngi, aↄ̃ gbɛ̃kee e gↄ̃ro. ");
INSERT INTO bus_vpl VALUES ("S213_31","011_13_31","2SA","13","31","31","Dauda fɛ̀ɛ à a pↄ́kãsãanↄ gà à kɛ̃̀, ben à dàɛ tↄↄtɛ. À ìba kɛ̀ aↄ̃ↄ zɛzɛzinↄ ń pↄ́kãsãanↄ gà wà kɛ̃̀kɛ̃ se. ");
INSERT INTO bus_vpl VALUES ("S213_32","011_13_32","2SA","13","32","32","Ben Dauda vĩ̀i Simɛa nɛ́ Yonadabu bè: Baa, ǹtongↄ̃ daa wà n nɛ́ gↄ̃kparɛnↄ dɛ̀dɛ píngiro, Aminↄ ado bé à gà. Wà yã pì dↄ̃̀ Abusalomu wɛ́ɛa zaa gurↄↄ kɛ̀ Aminↄ kùsi a dãre Tamaamɛ. ");
INSERT INTO bus_vpl VALUES ("S213_33","011_13_33","2SA","13","33","33","Ma dii kí, ǹtongↄ̃ yã pì kũna n nↄ̀sɛ guuro. N nɛ́gↄ̃gbɛ̃nↄↄ e gaga píngiro, séde Aminↄ ado. ");
INSERT INTO bus_vpl VALUES ("S213_34","011_13_34","2SA","13","34","34","Abusalomu sↄ̃ bàa lɛ̀. Kɛ̀ gↄ̃kparɛ gudãkpari wɛ́ɛ zù, à è wà tɛ́ Oronaimu zɛ́n sĩ̀sĩgɛɛzi paripari. À gàa à bè kínɛ: Ma gbɛ̃nↄ è tɛ́ sĩ̀sĩgɛɛzi Oronaimu kpa. ");
INSERT INTO bus_vpl VALUES ("S213_35","011_13_35","2SA","13","35","35","Ben Yonadabu bè kínɛ: Ń èↄ́? N nɛ́nↄ bé aↄ̃ↄe suu gwe lán má ònnɛ nà. ");
INSERT INTO bus_vpl VALUES ("S213_36","011_13_36","2SA","13","36","36","Kɛ̀ à yã pì ò à yã̀a, ben kína nɛ́ pìnↄ kà gↄ̃ↄ, aↄ̃ↄe sósobi ↄ́ↄ dↄↄ. Kí kↄ̃n a ìbanↄ ↄ́ↄ dↄ̀ ń píngi maamaa dↄ. ");
INSERT INTO bus_vpl VALUES ("S213_37","011_13_37","2SA","13","37","37","Abusalomu bàa lɛ̀ à tà Amiudu nɛ́ Talamai, Gesuu kína kiia. Kí Dauda sↄ̃ ègↄ̃ a nɛ́ ga ↄ́ↄ dↄↄ gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("S213_38","011_13_38","2SA","13","38","38","Kɛ̀ Abusalomu bàa lɛ̀ à tà Gesuu, à kú gwe ai wɛ̃̀ aagↄ̃. ");
INSERT INTO bus_vpl VALUES ("S213_39","011_13_39","2SA","13","39","39","Kɛ̀ kí Dauda nↄ̀sɛ kpàɛ Aminↄ ga yã musu, ben èe Abusalomu bɛgɛ kɛɛ sa. ");
INSERT INTO bus_vpl VALUES ("S214_1","011_14_1","2SA","14","1","1","Zeruya nɛ́ Yoabu dↄ̃ kɛ̀ kí pↄↄ kpɛ́ kú Abusalomua, ");
INSERT INTO bus_vpl VALUES ("S214_2","011_14_2","2SA","14","2","2","ben à gbɛ̃nↄ zĩ̀ Tɛkoa, aↄ̃ nↄgbɛ̃ ↄ̃ndↄ̃de ke sɛ̀ wà sùo. Ben à bènɛ: Ǹ kɛ lándↄ̃ nɛ́ɛ sósobi kɛɛ bà. Ǹ gyaanↄ pↄ́kãsãanↄ da. Ǹton nↄ́si kɛmmaro. Ǹ kɛ lán nↄgbɛ̃ kɛ̀ à gbɛ̃ gà, èe à ↄ́ↄ dↄↄ à gì kɛ̀ bà. ");
INSERT INTO bus_vpl VALUES ("S214_3","011_14_3","2SA","14","3","3","Ǹ gá kí kiia lɛ, ǹ yã kɛ̀ onɛ. Ben Yoabu yã kàka nↄgbɛ̃ pìnɛ. ");
INSERT INTO bus_vpl VALUES ("S214_4","011_14_4","2SA","14","4","4","Kɛ̀ Tɛkoa nↄgbɛ̃ pì gàa à kí lè, à kùɛnɛ à mì pɛ̀ɛnɛ à bè: Kí, ǹ ma mì sí! ");
INSERT INTO bus_vpl VALUES ("S214_5","011_14_5","2SA","14","5","5","Ben kí pì à là à bè: Bↄ́n ń yezi? À wèàla à bè: Gyaanↄↄn ma ũ, ma zã gà. ");
INSERT INTO bus_vpl VALUES ("S214_6","011_14_6","2SA","14","6","6","Mamↄma n zↄ̀bleri, má nɛ́gↄ̃gbɛ̃nↄ vĩ gↄ̃ↄn plaa. Kɛ̀ aↄ̃ↄe swèe kɛɛ ń kↄ̃ tɛ̃ɛ bura, gbɛ̃kee kuu à ń yokↄ̃aro. Ben gbɛ̃ doo a gbɛ̃ndoo lɛ̀ à dɛ̀. ");
INSERT INTO bus_vpl VALUES ("S214_7","011_14_7","2SA","14","7","7","Ben ma bɛdeenↄ fɛ̀ɛ ń píngi, aↄ̃ↄ bè mamↄma n zↄ̀blerinɛ mà ma nɛ́ kɛ̀ à a gbɛ̃ndoo dɛ̀ pì kpáḿma wà dɛ, kɛ̀ à a gbɛ̃ndoo dɛ̀ yãnzi. Aↄ̃ↄ yezi wà yàka tɛ́mio kɛ̀ gↄ̃̀mɛ túbibleri ũu pì tɛ́ dɛmɛ, lɛ ma zã tóngↄ̃ tↄ́ ke borii vĩ anduna guu dↄro yãnzi. ");
INSERT INTO bus_vpl VALUES ("S214_8","011_14_8","2SA","14","8","8","Ben kí bè nↄgbɛ̃ pìnɛ: Ǹ tá bɛ, mɛ́ yã diɛ n yã pì musu. ");
INSERT INTO bus_vpl VALUES ("S214_9","011_14_9","2SA","14","9","9","Ben Tɛkoa nↄgbɛ̃ pì bè: Ma dii kí, taari pì wí ma musu kↄ̃n ma de bɛdeenↄ, mpi ǹgↄ̃ kuu taari sai kↄ̃n n kíkɛɛo. ");
INSERT INTO bus_vpl VALUES ("S214_10","011_14_10","2SA","14","10","10","Ben kí bè: Tó gbɛ̃ke lɛ́ pà yã pìa, ǹ mↄ́o ma kiia kɛ̀, eé n lɛ́ wɛtɛo dↄro. ");
INSERT INTO bus_vpl VALUES ("S214_11","011_14_11","2SA","14","11","11","Ben nↄgbɛ̃ pì bè: Kí, ǹ lɛ́ gbɛ̃ kↄ̃n Dii n Luda tↄ́o, lɛ gɛ̃ɛbori tón ma nɛ́ doo kɛ̀ gↄ̃̀ laata kpáro yãnzi. Ben kí pì bè: Kↄ̃n Diio n nɛ́ pì mìkã ke é lɛ́ɛ tↄↄtɛro. ");
INSERT INTO bus_vpl VALUES ("S214_12","011_14_12","2SA","14","12","12","Ben nↄgbɛ̃ pì bè: Ma dii kí, mamↄma n zↄ̀bleri ǹ ma gba zɛ́ mà ɛara mà yã onnɛ. À wèàla à bè: Ǹ o! ");
INSERT INTO bus_vpl VALUES ("S214_13","011_14_13","2SA","14","13","13","Ben à bènɛ: À kɛ̀ dia nɛ́ɛ Luda gbɛ̃nↄ kpákpaa kↄ̃n à zaaao? Yã kɛ̀ ń òmɛɛ bé à n da yãn, zaakɛ nɛ́ɛ gbɛ̃ kɛ̀ n pɛa gbɛsɛ n suoro. ");
INSERT INTO bus_vpl VALUES ("S214_14","011_14_14","2SA","14","14","14","Wa píngi wé ga, wégↄ̃ dɛ lán í kɛ̀ kwɛ̀ɛ tↄↄtɛ gbɛ̃kee e e à sɛ̀ɛ dↄroo bà. Luda è gbɛ̃ kɛ̀ wà pɛ̀a wɛ̃̀ndi bↄro, è zɛ́ wɛtɛ adee ɛara à suawamɛ. ");
INSERT INTO bus_vpl VALUES ("S214_15","011_14_15","2SA","14","15","15","Ma mↄ yã pì o ma dii kínɛmɛ, zaakɛ gbɛ̃nↄↄ tò vĩa ma kũ. Ben mamↄma n zↄ̀bleri ma bè mɛ́ yã pì gbãnnɛ. Wègↄ̃ dↄ̃ro ke nɛ́ ma wɛ́ɛkɛna sí ");
INSERT INTO bus_vpl VALUES ("S214_16","011_14_16","2SA","14","16","16","ǹ ma bↄ gbɛ̃ kɛ̀ yezi à mapi kↄ̃n ma nɛ́o tↄↄtɛ kɛ̀ Ludaa tòwe sí wa ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("S214_17","011_14_17","2SA","14","17","17","Ma dii kí, mamↄma n zↄ̀bleri ma bè n yã é tó ma làakari kpáɛ, zaakɛ ń dɛ lán Luda malaika bàmɛ, nɛɛ̀ swã kpá yã maa kↄ̃n a zaaaozi píngimɛ. Dii n Luda gↄ̃ kúnyo. ");
INSERT INTO bus_vpl VALUES ("S214_18","011_14_18","2SA","14","18","18","Ben kí bènɛ: Ǹton gí yã kɛ̀ mɛ́ɛ n laa oziro. Ben nↄgbɛ̃ pì bè: Ǹ o ma dii kí! ");
INSERT INTO bus_vpl VALUES ("S214_19","011_14_19","2SA","14","19","19","Ben kí à là à bè: Yoabu lɛ́ kú yã pì guuↄ́? Nↄgbɛ̃ pì wèàla à bè: Ma dii kí, kↄ̃n n kuunao yã kɛ̀ ń ò pì gagana vĩro. Ee, n zↄ̀bleri Yoabu bé à yã pì kàkamɛ píngi. ");
INSERT INTO bus_vpl VALUES ("S214_20","011_14_20","2SA","14","20","20","N zↄ̀bleri Yoabu kɛ̀ lɛ, lɛ à e à yã kɛ̀ logona tiaa kɛ̀ kɛkɛ yãnzimɛ. Ma dii, ń ↄ̃ndↄ̃ lán Luda malaika bàmɛ, ń yã kɛ̀ kɛ̀ anduna guu dↄ̃ píngi. ");
INSERT INTO bus_vpl VALUES ("S214_21","011_14_21","2SA","14","21","21","Ben kí gàa à bè Yoabunɛ: Tↄ̀, mɛ́ yã pì kɛ sa. Ǹ gá ǹ gↄ̃kparɛ Abusalomu gbɛsɛ ǹ suo. ");
INSERT INTO bus_vpl VALUES ("S214_22","011_14_22","2SA","14","22","22","Ben Yoabu kùɛ kínɛ à mì pɛ̀ɛnɛ, à à sáabu kpà à bè: Ma dii kí, mamↄma n zↄ̀bleri, má dↄ̃̀ gbã̀a sa kɛ̀ ma yã kànnɛ, zaakɛ n ma yã mà. ");
INSERT INTO bus_vpl VALUES ("S214_23","011_14_23","2SA","14","23","23","Ben Yoabu fɛ̀ɛ à gàa à Abusalomu gbɛ̀sɛ zaa Gesuru à sùo Yerusalɛmu. ");
INSERT INTO bus_vpl VALUES ("S214_24","011_14_24","2SA","14","24","24","Ben kí bè: Ǹ onɛ à gá vɛ̃ɛ a zĩnda bɛ, wa wɛ́ɛ é kɛ siigↄ̃ro. Ben Abusalomu gàa à vɛ̃̀ɛ a bɛ, aↄ̃ↄe wɛ́ɛ sikↄ̃lɛ kↄ̃n kíoro. ");
INSERT INTO bus_vpl VALUES ("S214_25","011_14_25","2SA","14","25","25","Gↄ̃ maa kee kú Isarailinↄ tɛ́ lán Abusalomu bàro. Wègↄ̃ à maakɛ yã oo maamaa. Sɛna zaa à kɛ̀sɛa ai à gàa pɛ́ à mìdangura see kee kúaro. ");
INSERT INTO bus_vpl VALUES ("S214_26","011_14_26","2SA","14","26","26","Ègↄ̃ a mì boo wɛ̃̀ kↄ̃n wɛ̃̀omɛ. È kɛa tìisi. Tó à bò, è yↄ̃ kilooa, à tìisi ègↄ̃ dɛ kiloo plaala. ");
INSERT INTO bus_vpl VALUES ("S214_27","011_14_27","2SA","14","27","27","À nɛ́gↄ̃gbɛ̃nↄ ì gↄ̃ↄn aagↄ̃ kↄ̃n nɛ́nↄgbɛ̃o mɛ̀n do. Nɛ́nↄgbɛ̃ pì tↄ́n Tama. Nↄ maaamɛ. ");
INSERT INTO bus_vpl VALUES ("S214_28","011_14_28","2SA","14","28","28","Abusalomu kú Yerusalɛmu ai wɛ̃̀ plaa wɛ́ɛsina kílɛ sai. ");
INSERT INTO bus_vpl VALUES ("S214_29","011_14_29","2SA","14","29","29","Ben à Yoabu sìsi à gáare kí kiia, mↄde Yoabu e we à mↄ̀ à kiiaro. Ben à ɛ̀ara à à sìsi dↄ, èe we à mↄ̀ro. ");
INSERT INTO bus_vpl VALUES ("S214_30","011_14_30","2SA","14","30","30","Ben à bè a zĩkɛrinↄnɛ: À Yoabu buraa kɛ̀ kú ma pↄ́ saɛ gwa, à nagãa mà. À gá à tɛ́ sↄ̃a. Ben Abusalomu zĩkɛrinↄ gàa wà tɛ́ sↄ̃̀ Yoabu buraa pìa. ");
INSERT INTO bus_vpl VALUES ("S214_31","011_14_31","2SA","14","31","31","Ben Yoabu fɛ̀ɛ à gàa Abusalomu bɛ, à à là à bè: Bↄ́yãnzi n zĩkɛrinↄ tɛ́ sↄ̃̀ ma buraaazi? ");
INSERT INTO bus_vpl VALUES ("S214_32","011_14_32","2SA","14","32","32","Ben Abusalomu wèàla à bè: Ǹ gwa, ma gbɛ̃ zĩ̀mma ma bè ǹ mↄ́ mà n zĩ kía, lɛ ǹ à la bↄ́ bé à tò à ma gbɛ̀sɛ zaa Gesuru à sùmaozi? Ma kuuna gwee sã̀ↄmɛ dɛ gura kɛ̀la! Má yezi mà kↄ̃ e kↄ̃n kío tia. Tó má taari ke vĩ, ɛ̃ndɛ̃ à ma dɛ. ");
INSERT INTO bus_vpl VALUES ("S214_33","011_14_33","2SA","14","33","33","Ben Yoabu gàa à yã pì ò kínɛ. Ben kí Abusalomu sìsi. Kɛ̀ à mↄ̀, à kùɛnɛ à dàɛ a puua. Ben kí lɛ́ pɛ̀a. ");
INSERT INTO bus_vpl VALUES ("S215_1","011_15_1","2SA","15","1","1","Beee gbɛra Abusalomu sↄ̃goro è a zĩndanɛ kↄ̃n sↄ̃nↄ kↄ̃n gↄ̃gbɛ̃nↄ gↄ̃ↄn baplaa akuri kɛ̀ aↄ̃égↄ̃ bàa lɛɛ à aɛnↄ. ");
INSERT INTO bus_vpl VALUES ("S215_2","011_15_2","2SA","15","2","2","È fɛɛ kↄngↄ idɛ'idɛ àgↄ̃ zɛna bĩilɛ saɛ. Tó gbɛ̃ yã vĩ kↄ̃n a gbɛ̃daaao èe gaao kí kiia à kɛkɛnɛ, Abusalomu è adee sísi à benɛ: Wɛ́tɛ kpareen n bↄn? Tó à wèàla à bè: Mamↄma n zↄ̀bleri ma bↄ Isaraili borii kɛ̀ guumɛ, ");
INSERT INTO bus_vpl VALUES ("S215_3","011_15_3","2SA","15","3","3","ben Abusalomu è benɛ: N yã nnamɛ, bensↄ̃ à zɛ́ vĩ, mↄde kí gbɛ̃kee kuu à swã kpá n yãziro. ");
INSERT INTO bus_vpl VALUES ("S215_4","011_15_4","2SA","15","4","4","Abusalomu è ɛara à be: Tó wà ma kɛ yãkpaɛkɛri ũ wa bùsun, gbɛ̃ kɛ̀ yã vĩ ke gbɛ̃ kɛ̀ èe gbɛ̃ gbekaa yãkpaɛkɛkiia ń píngi eégae mↄ́ ma kiia, mɛ́gae à yã kɛkɛnɛ a zɛ́a. ");
INSERT INTO bus_vpl VALUES ("S215_5","011_15_5","2SA","15","5","5","Tó gbɛ̃ mↄ̀ à kùɛ à aɛ, è ↄ bↄ à adee kũ à lɛ́ pɛ́amɛ. ");
INSERT INTO bus_vpl VALUES ("S215_6","011_15_6","2SA","15","6","6","Lɛn ègↄ̃ kɛɛ lɛ Isaraili kɛ̀ aↄ̃ↄe mↄ́ yãkpaɛ kɛ kí kiianↄnɛ ń píngi, ben aↄ̃ swɛ̃̀ tà à kpa. ");
INSERT INTO bus_vpl VALUES ("S215_7","011_15_7","2SA","15","7","7","Wɛ̃̀ siigↄ̃ↄ gbɛra à bè kínɛ: Ǹ ma gba zɛ́ mà gá lù kɛ̀ má sɛ̀ Diinɛ saa o zaa Ɛblↄnu. ");
INSERT INTO bus_vpl VALUES ("S215_8","011_15_8","2SA","15","8","8","Mamↄma n zↄ̀bleri ma lù pì sɛ̀nɛ gurↄↄ kɛ̀ má kú Gesuru, Siria bùsun ma bè: Tó Dii tò ma su Yerusalɛmu, mɛ́ saa oa Ɛblↄnumɛ. ");
INSERT INTO bus_vpl VALUES ("S215_9","011_15_9","2SA","15","9","9","Kí bènɛ: Ǹ gá ǹ su aafia! Ben à fɛ̀ɛ à gàa Ɛblↄnu. ");
INSERT INTO bus_vpl VALUES ("S215_10","011_15_10","2SA","15","10","10","À gbɛ̃nↄ zĩ̀ Isaraili boriinↄ kiia píngi à bè: Tó a kuru'ↄ mà dↄ, à be Abusalomu bé à kí blè Ɛblↄnu. ");
INSERT INTO bus_vpl VALUES ("S215_11","011_15_11","2SA","15","11","11","Gurↄↄ kɛ̀ èe fɛɛɛ Yerusalɛmu à gbɛ̃nↄ sìsi gↄ̃ↄn wàa do aↄ̃ gá zɛare, ben aↄ̃ gàa kↄ̃n nↄ̀sɛo do, aↄ̃ yã pì asii dↄ̃ro. ");
INSERT INTO bus_vpl VALUES ("S215_12","011_15_12","2SA","15","12","12","Gurↄↄ kɛ̀ èe saa oo, à Gilo gbɛ̃ Aitofɛli, Dauda lɛ́dammari sìsi zaa à bɛ wɛ́tɛn, ben lɛ́kpakↄ̃sↄ̃na Daudazi e kaara. Gbɛ̃ kɛ̀ aↄ̃ↄ kú kↄ̃n Abusalomuonↄ pari kũ̀ wèe kaara. ");
INSERT INTO bus_vpl VALUES ("S215_13","011_15_13","2SA","15","13","13","Baarukpari mↄ̀ à bè Daudanɛ: Isarailinↄ swɛ̃̀ tà Abusalomu kpa. ");
INSERT INTO bus_vpl VALUES ("S215_14","011_15_14","2SA","15","14","14","Ben Dauda bè a ìba kɛ̀ aↄ̃ↄ kúao Yerusalɛmunↄnɛ: À fɛɛ wà bàa lɛ́. Tó wée kɛ lɛro, wé piti Abusalomunlo. Wà kɛ kpakpaa. Tó wée kɛ kpakpaaro, eé wa le kɛ̀, eé wa ásaru kɛ, eé wɛ́tɛdeenↄ dɛdɛ kↄ̃n fɛ̃ɛdaaomɛ. ");
INSERT INTO bus_vpl VALUES ("S215_15","011_15_15","2SA","15","15","15","Kí ìbanↄ bènɛ: Wa dii kí, yã kɛ̀ n zɛo píngi, wamↄwa n zↄ̀blerinↄ wá yãanamɛ. ");
INSERT INTO bus_vpl VALUES ("S215_16","011_15_16","2SA","15","16","16","Ben kí dà zɛ́n. À bɛdeenↄ bↄ̀ wà tɛ̀zi ń píngi, mↄde à a nↄ yìgisai mɛ̀n kurinↄ tò gwe aↄ̃gↄ̃ bɛɛ gwaa. ");
INSERT INTO bus_vpl VALUES ("S215_17","011_15_17","2SA","15","17","17","Kí dà zɛ́n lɛ kↄ̃n a gbɛ̃nↄ. Kɛ̀ aↄ̃ kà wɛ́tɛ kpɛɛ, à lìɛ à zɛ̀. ");
INSERT INTO bus_vpl VALUES ("S215_18","011_15_18","2SA","15","18","18","Ben à ìbanↄ píngi kↄ̃n a dogarinↄ kↄ̃n Gatadeenↄ gↄ̃ↄn wàa aagↄ̃ↄ kɛ̀ aↄ̃ↄ tɛ́zi zaa Gatanↄ gɛ̃̀tɛ ń píngi. ");
INSERT INTO bus_vpl VALUES ("S215_19","011_15_19","2SA","15","19","19","Ben kí bè Gata gbɛ̃ Itainɛ: Bↄ́yãnzi nɛ́ɛ gaawaozi? Ǹ ɛara ǹ tá ǹgↄ̃ kú kↄ̃n kí dufuo, zaakɛ gbɛ̃ zĩ̀tↄn n ũ, n bↄ n bùsummɛ. ");
INSERT INTO bus_vpl VALUES ("S215_20","011_15_20","2SA","15","20","20","N suna e gurↄplaa kɛro, ben ń yezi ǹgↄ̃ likↄ̃aa zↄ̃ↄwaoↄ́? Má dↄ̃ guu kɛ̀ mɛ́ɛ gaanlo. Ǹ n gbɛ̃nↄ kakↄ̃a ǹ táńyo. Dii gbɛ̃kɛ kↄ̃n náanɛ yão kɛnnɛ. ");
INSERT INTO bus_vpl VALUES ("S215_21","011_15_21","2SA","15","21","21","Ben Itai wèàla à bè: Ma dii kí, kↄ̃n Dii kuunao kↄ̃n n kuunao, guu kɛ̀ ń kún píngi, mamↄma n zↄ̀bleri mɛ́gↄ̃ kú gwemɛ, gaan yoo kesↄ̃ wɛ̃̀ndi yoo. ");
INSERT INTO bus_vpl VALUES ("S215_22","011_15_22","2SA","15","22","22","Ben Dauda bènɛ: Ǹ dↄmɛ aɛ wà gá! Ben Gata gbɛ̃ Itai ɛ̀ara à dà zɛ́n kↄ̃n a gbɛ̃nↄ kↄ̃n a danɛ kɛ̀ aↄ̃ↄ kúonↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("S215_23","011_15_23","2SA","15","23","23","Kɛ̀ aↄ̃ↄe gɛ̃ɛ zɛ́la ń píngi, ben bùsudeenↄ wiii sìn. Kɛ̀ kí bikũ̀ Kidironua, ben aↄ̃ píngi aↄ̃ gbáa zɛ́ sɛ̀. ");
INSERT INTO bus_vpl VALUES ("S215_24","011_15_24","2SA","15","24","24","Zadↄki kú gwe dↄ kↄ̃n Levinↄ ń píngi. Aↄ̃ Luda bà kuunańyo àkpati sɛna. Aↄ̃ↄ àkpati pì dìɛ Abiata saɛ ai gbɛ̃nↄ bↄ̀ɛ wɛ́tɛn wà yã̀a ń píngi. ");
INSERT INTO bus_vpl VALUES ("S215_25","011_15_25","2SA","15","25","25","Ben kí bè Zadↄkinɛ: Ǹ Luda àkpati sɛ́ ǹ gɛ̃o wɛ́tɛ guu. Tó ma Dii ma pↄnnaa è, eé tó mà su mà wɛ́ɛ siàlɛ kↄ̃n à kúkiio. ");
INSERT INTO bus_vpl VALUES ("S215_26","011_15_26","2SA","15","26","26","Tó à bè ma yã e káaguro sↄ̃, ma yãa. À kɛmɛ lán à kɛ̀nɛ maa nà. ");
INSERT INTO bus_vpl VALUES ("S215_27","011_15_27","2SA","15","27","27","Ben kí ɛ̀ara à bè sa'ori Zadↄkinɛ: Wɛ́ɛgupu'erin n ũroo? Ǹ ɛara ǹ tá wɛ́tɛ guu aafia kↄ̃n n nɛ́ Aimazao kↄ̃n Abiata nɛ́ Yonatão. À tá kↄ̃n a nɛ́ gↄ̃ↄn plaaa pìnↄ. ");
INSERT INTO bus_vpl VALUES ("S215_28","011_15_28","2SA","15","28","28","Mɛ́gↄ̃ zɛna swabikũkiia sɛ̃̀tɛ ai mà baaru ma a kiia. ");
INSERT INTO bus_vpl VALUES ("S215_29","011_15_29","2SA","15","29","29","Ben Zadↄki kↄ̃n Abiatao Luda àkpati sɛ̀ wà tào Yerusalɛmu, ben aↄ̃ gↄ̃̀ gwe. ");
INSERT INTO bus_vpl VALUES ("S215_30","011_15_30","2SA","15","30","30","Dauda e Kùkpɛ sĩ̀sĩ kũu èe ↄ́ↄ dↄↄ. À pↄ́ kù a mìa, à kyatee kpanaro. Gbɛ̃ kɛ̀ aↄ̃ↄ kúonↄ pↄ́ kù ń mìa ń píngi, aↄ̃ↄe ↄ́ↄ dↄↄ wèe gaao. ");
INSERT INTO bus_vpl VALUES ("S215_31","011_15_31","2SA","15","31","31","Kɛ̀ wà bè Daudanɛ Aitofɛli kú gbɛ̃ kɛ̀ zɛ̀ kↄ̃n Abusalomuonↄ tɛ́, ben Dauda adua kɛ̀ à bè: Dii, ǹ tó à lɛ́damma gↄ̃ dɛ faasaiyã ũ. ");
INSERT INTO bus_vpl VALUES ("S215_32","011_15_32","2SA","15","32","32","Kɛ̀ Dauda kà sĩ̀sĩ mìsↄ̃ntɛ̃a, guu kɛ̀ dↄnzikɛkii kún, Aki gbɛ̃ Usai mↄ̀ à dààlɛ, à uta kɛ̃na bensↄ̃ bùsu kú à mìa. ");
INSERT INTO bus_vpl VALUES ("S215_33","011_15_33","2SA","15","33","33","Dauda bènɛ: Tó n gaamao, nɛ́gↄ̃ dɛmɛ asoo ũmɛ. ");
INSERT INTO bus_vpl VALUES ("S215_34","011_15_34","2SA","15","34","34","Tó n ɛara n ta wɛ́tɛn, ben ń bè Abusalomunɛ à zↄ̀blerin n ũ sↄ̃, nɛ́ Aitofɛli lɛ́damma gboromɛmɛ. Ǹ benɛ à de zↄ̀blerin n ũ yã, mↄde tia n gↄ̃ à zↄ̀bleri ũmɛ sa. ");
INSERT INTO bus_vpl VALUES ("S215_35","011_15_35","2SA","15","35","35","Sa'orinↄ Zadↄki kↄ̃n Abiatao gↄ̃ kúnyo gwe. Ǹ yã kɛ̀ ń mà kíbɛɛ tↄ̃kɛ̃ńnɛ píngi. ");
INSERT INTO bus_vpl VALUES ("S215_36","011_15_36","2SA","15","36","36","Aↄ̃ nɛ́ gↄ̃ↄn plaaanↄↄ kúnyo gwe, Zadↄki nɛ́ Aimaza kↄ̃n Abiata nɛ́ Yonatão. Tó n yãke mà, ǹ nɛ́ pìnↄ zĩ aↄ̃ mↄ́ wà omɛ. ");
INSERT INTO bus_vpl VALUES ("S215_37","011_15_37","2SA","15","37","37","Ben Dauda gbɛ̃nna Usai pì tà, à kà Yerusalɛmu gurↄↄ kɛ̀ Abusalomu e gɛ̃ɛ. ");
INSERT INTO bus_vpl VALUES ("S216_1","011_16_1","2SA","16","1","1","Kɛ̀ Dauda vĩ̀ sĩ̀sĩ mìdangurala féte, à è Mɛfibosɛ bɛgwari Ziba gàari yì zaakinↄnɛ mɛ̀n plaa, èe mↄↄ daalɛ. Aↄ̃ↄ burɛdi sɛna mɛ̀n wàa do kↄ̃n geepi kàrao mɛ̀n basↄↄro kↄ̃n kãkã kàrao mɛ̀n basↄↄro kↄ̃n geepiwɛ̃ɛo tùu do. ");
INSERT INTO bus_vpl VALUES ("S216_2","011_16_2","2SA","16","2","2","Ben Dauda Ziba là à bè: Bↄ́ bé à tò n mↄ kↄ̃n beeeo? Ziba wèàla à bè: Kí, zaakinↄ nɛ́ n bɛdeenↄ pↄ́mɛ aↄ̃ dia. Burɛdi kↄ̃n kàranↄ nɛ́ n gbɛ̃nↄ pↄ́bleemɛ. Geepiwɛ̃ɛ sↄ̃, gbɛ̃ kɛ̀ aↄ̃ kpàsa gbáa guunↄ íminamɛ. ");
INSERT INTO bus_vpl VALUES ("S216_3","011_16_3","2SA","16","3","3","Kí à là à bè: N dii kɛ̀ kɛ̀ sai dio kú mámɛ? Ziba wèàla à bè: À gↄ̃̀ Yerusalɛmu, zaakɛ èe daa Isarailinↄ a ká a dezi kpatan gbã̀amɛ. ");
INSERT INTO bus_vpl VALUES ("S216_4","011_16_4","2SA","16","4","4","Ben kí bènɛ: Pↄ́ kɛ̀ Mɛfibosɛ vĩ píngi gↄ̃̀ n pↄ́ ũ. Ben Ziba bè: Máɛ kúɛ kɛ̀! Ma dii kí, ǹ tó màgↄ̃ n pↄnnaa e lɛ. ");
INSERT INTO bus_vpl VALUES ("S216_5","011_16_5","2SA","16","5","5","Kɛ̀ kí Dauda sↄ̃̀ Bahurimuzi, à è gↄ̃gbɛ̃ ke bↄ̀. À tↄ́n Simɛi, Gera nɛ́mɛ. Àmbe bori dↄ̃nkↄ̃ kↄ̃n Solu bɛdeenↄ. À bↄ̀ wɛ́tɛ guu, èe Dauda kaa. ");
INSERT INTO bus_vpl VALUES ("S216_6","011_16_6","2SA","16","6","6","Èe kí Dauda kↄ̃n à gbɛ̃nↄ gbãgbãa kↄ̃n gbɛ̀o, baa kɛ̀ à zĩ̀karinↄ kↄ̃n à dogarinↄↄ kú à ↄplaazi kↄ̃n à ↄzɛɛzio ń píngi. ");
INSERT INTO bus_vpl VALUES ("S216_7","011_16_7","2SA","16","7","7","Èe à sↄ̃sↄ̃ↄ èe bee: Ǹ gá! Ǹ gá! Gbɛ̃dɛri! Pↄ́ pã! ");
INSERT INTO bus_vpl VALUES ("S216_8","011_16_8","2SA","16","8","8","Dii fĩa bònnɛ Solu kɛ̀ n kí blè à gbɛ̀n bɛdeenↄ dɛdɛna yã yãnzi. Dii n bↄ kpatan à n nɛ́ Abusalomu kàn. Ásaru kɛ̀mma sa, zaakɛ gbɛ̃dɛrin n ũ. ");
INSERT INTO bus_vpl VALUES ("S216_9","011_16_9","2SA","16","9","9","Ben Zeruya nɛ́ Abisai bè kínɛ: Ma dii kí, à maa gbɛ̃ɛ gɛ̀ kɛ̀ gↄ̃ n sↄ̃sↄ̃ↄro. Ǹ tó mà gá mà à mì zↄ̃. ");
INSERT INTO bus_vpl VALUES ("S216_10","011_16_10","2SA","16","10","10","Ben kí bè: Zeruya nɛ́nↄ, bↄ́ bé à wa kakↄ̃aa? Tó Dii bé à ònɛ à ma sↄ̃sↄ̃, ben èe ma sↄ̃sↄ̃ↄ, dé bé eé fↄ̃ à à la à be, bↄ́yãnzi èe kɛɛ lɛzi? ");
INSERT INTO bus_vpl VALUES ("S216_11","011_16_11","2SA","16","11","11","Ben Dauda ò Abisainɛ kↄ̃n a ìbanↄ ń píngi à bè: À gwa, ma zĩnda nɛ́'ina bé èe wɛtɛɛ à ma dɛ, ɛ̃ndɛ̃ weé Bɛyãmi bori kɛ̀ki nɛ́ o dↄↄ́? À à tó gwe. Tó Dii bé à bènɛ à ma sↄ̃sↄ̃, à maamɛ. ");
INSERT INTO bus_vpl VALUES ("S216_12","011_16_12","2SA","16","12","12","Wègↄ̃ dↄ̃ro ke Dii é ma nawɛ̃akɛna gwa à fĩa bomɛ kↄ̃n à maaao sↄ̃sↄ̃ kɛ̀ wèe kɛɛmɛ gbã̀a kɛ̀ yãnzi gwɛɛ. ");
INSERT INTO bus_vpl VALUES ("S216_13","011_16_13","2SA","16","13","13","Kɛ̀ Dauda tɛ́ zɛ́n kↄ̃n a gbɛ̃nↄ, Simɛi tɛ́ sĩ̀sĩ pãnde gɛɛzi, èe à sↄ̃sↄ̃ↄ èe à gbãgbãa kↄ̃n gbɛ̀o èe bùsu fãa. ");
INSERT INTO bus_vpl VALUES ("S216_14","011_16_14","2SA","16","14","14","Kɛ̀ kí kↄ̃n a gbɛ̃ kɛ̀ aↄ̃ↄ kúonↄ kà swaazi, aↄ̃ kpàsa, ben aↄ̃ kámma bò gwe. ");
INSERT INTO bus_vpl VALUES ("S216_15","011_16_15","2SA","16","15","15","Abusalomu kà Yerusalɛmu kↄ̃n Isarailinↄ ń píngi. Aitofɛli kúo. ");
INSERT INTO bus_vpl VALUES ("S216_16","011_16_16","2SA","16","16","16","Ben Dauda gbɛ̃nna Usai, Aki gbɛ̃ gàa à Abusalomu lè à bènɛ: Luda n dↄ̃ kↄ̃n aafiao Zaaki! Luda n dↄ̃ kↄ̃n aafiao Zaaki! ");
INSERT INTO bus_vpl VALUES ("S216_17","011_16_17","2SA","16","17","17","Abusalomu à là à bè: Gbɛ̃kɛɛ kɛ̀ ń vĩ kↄ̃n n gbɛ̃nnaon gweↄ́? À kɛ̀ dia nɛ́ɛ gá kↄ̃n n gbɛ̃nnaoroo? ");
INSERT INTO bus_vpl VALUES ("S216_18","011_16_18","2SA","16","18","18","Usai wèàla à bè: Lɛnlo! Gbɛ̃ kɛ̀ Dii sɛ̀ kↄ̃n gbɛ̃ kɛ̀kiinↄ pↄ́n ma ũ. Ma zɛ kↄ̃n kína kɛ̀ Isarailinↄↄ kà pìo. ");
INSERT INTO bus_vpl VALUES ("S216_19","011_16_19","2SA","16","19","19","Beee gbɛra dↄ, dé bé à maa mà zↄ̀ blenɛ, n baasiroo? Lán ma zↄ̀ blè n denɛ nà, lɛn mɛ́ blennɛ lɛ. ");
INSERT INTO bus_vpl VALUES ("S216_20","011_16_20","2SA","16","20","20","Abusalomu bè Aitofɛlinɛ: À lɛ́ dawa. Bↄ́n wé kɛɛ? ");
INSERT INTO bus_vpl VALUES ("S216_21","011_16_21","2SA","16","21","21","Ben Aitofɛli wèàla à bè: Ǹ gá ǹ daɛ kↄ̃n n de nↄ yìgisai kɛ̀ à ń tó kɛ̀ aↄ̃ↄe bɛɛ gwaanↄo, lɛ Isarailinↄ e wà dↄ̃ ń píngi kɛ̀ ń tò n dee ye n kãziro, gbɛ̃ kɛ̀ aↄ̃ↄ kúnyonↄ gbãaa é kaara. ");
INSERT INTO bus_vpl VALUES ("S216_22","011_16_22","2SA","16","22","22","Ben wà bisakutaa dↄ̀ Abusalomunɛ kpɛ́ musu, ben à gàa à dàɛ kↄ̃n a de nↄↄ pìnↄ gwe Isarailinↄ píngi wáa. ");
INSERT INTO bus_vpl VALUES ("S216_23","011_16_23","2SA","16","23","23","Gurↄ beeenↄa lɛ́ kɛ̀ Aitofɛli è daḿma dɛ lán gbɛ̃ kɛ̀ yã gbèka Ludaa yã bàmɛ. Lɛn Aitofɛli lɛ́damma dɛ lɛ Daudanɛ kↄ̃n Abusalomuo ń píngi. ");
INSERT INTO bus_vpl VALUES ("S217_1","011_17_1","2SA","17","1","1","Aitofɛli bè Abusalomunɛ: Tó mámbee, mɛ́ zĩ̀karinↄ sɛ́ gↄ̃ↄn bↄrↄ kuri awɛɛplaa mà pɛ́ɛńyo Daudazi gwãavĩa. ");
INSERT INTO bus_vpl VALUES ("S217_2","011_17_2","2SA","17","2","2","Mɛ́ lɛ́ɛa gurↄↄ kɛ̀ à kpàsa à ↄↄ bùsa, mɛ́ à fu. À gbɛ̃nↄ é bàa lɛ́ ń píngi, mɛ́ à dɛ ado, ");
INSERT INTO bus_vpl VALUES ("S217_3","011_17_3","2SA","17","3","3","mɛ́ sunnɛ kↄ̃n gbɛ̃ pìnↄ ń píngi. Gbɛ̃ kɛ̀ nɛ́ɛ wɛtɛɛ ǹ à dɛɛ gaan gbɛ̃ pìnↄ suna ũ ń píngi. Tó à gà, gbɛ̃ kpaaanↄ é gↄ̃ aafia ń píngi. ");
INSERT INTO bus_vpl VALUES ("S217_4","011_17_4","2SA","17","4","4","Yã pì kɛ̀ Abusalomunɛ nna kↄ̃n Isaraili gbɛ̃nsinↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("S217_5","011_17_5","2SA","17","5","5","Ben Abusalomu bè: Wà Aki gbɛ̃ Usai sísi dↄ wà ma lán eé o nà se. ");
INSERT INTO bus_vpl VALUES ("S217_6","011_17_6","2SA","17","6","6","Kɛ̀ Usai kà, Abusalomu bènɛ: Lán Aitofɛli ò nàn yɛ̀. Wà kɛ lán à ò nàn yↄ́? Ke wàton kɛ lɛro. Ń è diamɛ? ");
INSERT INTO bus_vpl VALUES ("S217_7","011_17_7","2SA","17","7","7","Usai wèàla à bè: Lɛ́ kɛ̀ Aitofɛli dàawa gbã̀a kɛ̀kii maaro. ");
INSERT INTO bus_vpl VALUES ("S217_8","011_17_8","2SA","17","8","8","Ń n de dↄ̃ kↄ̃n a gbɛ̃nↄ. Zĩ̀kari maaanↄn ń ũ, aↄ̃ↄ pãsĩ lán músu nɛ́dandee kɛ̀ wà à nɛ́nↄ sìa bàmɛ. N de nɛ́ zĩ̀kari gbãaamɛ, eé we à i gu dↄ̃nkↄ̃n kↄ̃n a gbɛ̃nↄoro. ");
INSERT INTO bus_vpl VALUES ("S217_9","011_17_9","2SA","17","9","9","Guu kɛ̀ à kún tia, eégↄ̃ utɛna gbɛ̀wɛɛ guu ke gukea. Tó à gà à lɛ̀ɛ wa gbɛ̃nↄa káaku sↄ̃, gbɛ̃ kɛ̀ à à baaru mà é be, wà zĩ̀ blè Abusalomu zĩ̀kpɛɛnↄamɛ. ");
INSERT INTO bus_vpl VALUES ("S217_10","011_17_10","2SA","17","10","10","Baa gↄ̃sagbãaa kɛ̀ wↄ́rↄngↄ vĩ lán músu bànↄ swɛ̃̀ é kɛ̃ńgumɛ, zaakɛ Isarailinↄↄ dↄ̃ ń píngi kɛ̀ n de nɛ́ zĩ̀kari pãsĩmɛ, bensↄ̃ gↄ̃sagbãaanↄↄ kúo. ");
INSERT INTO bus_vpl VALUES ("S217_11","011_17_11","2SA","17","11","11","Beee yãnzi lɛ́damma yã kɛ̀ má vĩin yɛ̀. Ǹ Isarailinↄ kakↄ̃anzi ń píngi zaa Dani ai gana Bɛsɛba, aↄ̃gↄ̃ pari lán ísialɛ bùsu'ãatɛ̃ bà, ǹ dↄńnɛ aɛ zĩ̀lan. ");
INSERT INTO bus_vpl VALUES ("S217_12","011_17_12","2SA","17","12","12","Wé à le guu kɛ̀ à kún píngi, wé lɛ́ɛa lán kpíi è kwɛ́ tↄↄtɛa nà. Àpi kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ kúonↄ ń píngi, aↄ̃ gbɛ̃ke é bↄro. ");
INSERT INTO bus_vpl VALUES ("S217_13","011_17_13","2SA","17","13","13","Tó à gà à gɛ̃̀ wɛ́tɛ ke guumɛ sↄ̃, Isaraili baade píngi é bà sɛ́ à gáo gwe, aↄ̃é wɛ́tɛ pì kaɛbↄnↄ gáɛ wà táo guzurɛn. Baa à gbɛ̀ kaso ke, weé e gwe dↄro. ");
INSERT INTO bus_vpl VALUES ("S217_14","011_17_14","2SA","17","14","14","Ben Abusalomu kↄ̃n Isarailinↄ bè ń píngi: Usai lɛ́damma maa dɛ Aitofɛli pↄ́la. Dii bé à zɛ̀o à Aitofɛli lɛ́damma maaa pì gboro, lɛ à e à Abusalomu ásaru kɛ yãnzi. ");
INSERT INTO bus_vpl VALUES ("S217_15","011_17_15","2SA","17","15","15","Ben Usai ò sa'ori Zadↄkinɛ kↄ̃n sa'ori Abiatao à bè: Aitofɛli lɛ́ dà Abusalomua kↄ̃n Isaraili gbɛ̃nsinↄ à bè à kɛ lán kɛ̀ bà, ben ma lɛ́ dàḿma ma bè aↄ̃ kɛ lán kɛ̀ bà. ");
INSERT INTO bus_vpl VALUES ("S217_16","011_17_16","2SA","17","16","16","À gbɛ̃nↄ zĩ kpakpaa aↄ̃ gá wà o Daudanɛ àton i swabikũkiiaro, à bikũ kpakpaa, lɛ wàton àpi kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ kúonↄ dúgu zↄ̃ro yãnzi. ");
INSERT INTO bus_vpl VALUES ("S217_17","011_17_17","2SA","17","17","17","Yonatã kↄ̃n Aimazao kú Ɛnlogɛli, zaakɛ aↄ̃é fↄ̃ wà bↄ gupuraaa Yerusalɛmuro. Ben nↄkparɛ zĩkɛri ke gàa à òńnɛ aↄ̃ gá baaru pì kpá kí Daudanɛ. ");
INSERT INTO bus_vpl VALUES ("S217_18","011_17_18","2SA","17","18","18","Bensↄ̃ gↄ̃kparɛ ke ń é, ben à gàa à ò Abusalomunɛ. Gↄ̃ↄn plaaa pìnↄ dà zɛ́n gↄ̃ↄ aↄ̃ gàa gbɛ̃ke bɛ Bahurimu. Lↄ̀gↄ kú uan gwe, ben aↄ̃ gɛ̃̀n. ");
INSERT INTO bus_vpl VALUES ("S217_19","011_17_19","2SA","17","19","19","Ben bɛdee pì naↄ̃ lↄ̀gↄ pì nɛ́ kpààlɛ à pↄ́wɛɛ fã̀ɛa, gbɛ̃kee à yã dↄ̃ro. ");
INSERT INTO bus_vpl VALUES ("S217_20","011_17_20","2SA","17","20","20","Kɛ̀ Abusalomu gbɛ̃nↄ mↄ̀ nↄgbɛ̃ pì bɛ aↄ̃ bè: Aimaza kↄ̃n Yonatão kú mámɛ? À wèńla à bè: Aↄ̃ bikũ̀ swa'ↄnɛa. Aↄ̃ ń wɛ́tɛ, aↄ̃ↄe ń ero, ben aↄ̃ ɛ̀ara wà tà Yerusalɛmu. ");
INSERT INTO bus_vpl VALUES ("S217_21","011_17_21","2SA","17","21","21","Kɛ̀ aↄ̃ tà, ben gↄ̃ↄn plaaa pìnↄ bↄ̀ɛ lↄ̀gↄ pì guu, aↄ̃ gàa wà bè kí Daudanɛ: Ǹ bikũ swaaa kpakpaa, zaakɛ Aitofɛli n kpakpa kↄ̃n à zaaaomɛ. ");
INSERT INTO bus_vpl VALUES ("S217_22","011_17_22","2SA","17","22","22","Dauda dà zɛ́n kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ kúonↄ ń píngi, aↄ̃ bikũ̀ Yodaa. Kɛ̀ guu dↄ̀, aↄ̃ gbɛ̃kee e gↄ̃ro, aↄ̃ bikũ̀ ń píngi. ");
INSERT INTO bus_vpl VALUES ("S217_23","011_17_23","2SA","17","23","23","Kɛ̀ Aitofɛli è wèe zĩi kɛ a lɛ́dammaaro, à fɛ̀ɛ à gàari yì a zaakinɛ à tà a bɛ wɛ́tɛ. À a bɛ pↄ́nↄ nàkↄ̃a, ben à a zĩnda lògo à gà, ben wà à vĩ̀i a de mirawɛɛn. ");
INSERT INTO bus_vpl VALUES ("S217_24","011_17_24","2SA","17","24","24","Dauda gàa Manaimu, ben Abusalomu bikũ̀ Yodaa kↄ̃n Isarailinↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("S217_25","011_17_25","2SA","17","25","25","Abusalomu Amasa dìɛ zĩ̀kpɛɛnↄ gbɛ̃nsi ũ Yoabu gɛ̃ɛ ũ. Amasa nɛ́ Sumaila bori Yɛta nɛ́mɛ. À dan Naasa nɛ́ Abigaili ũ, Yoabu da Zeruya dãaromɛ. ");
INSERT INTO bus_vpl VALUES ("S217_26","011_17_26","2SA","17","26","26","Isarailinↄ kↄ̃n Abusalomuo bùra kàɛ Giliada bùsun. ");
INSERT INTO bus_vpl VALUES ("S217_27","011_17_27","2SA","17","27","27","Kɛ̀ Dauda kà Manaimu, Naasa nɛ́ Sobi, Raba wɛ́tɛ kɛ̀ kú Amↄninↄ bùsun gbɛ̃ mↄ̀ kↄ̃n Lodɛba gbɛ̃ Amiɛli nɛ́ Makio kↄ̃n Rogɛlimu kɛ̀ kú Giliada bùsun gbɛ̃ Bazilaio. ");
INSERT INTO bus_vpl VALUES ("S217_28","011_17_28","2SA","17","28","28","Aↄ̃ mↄ̀ kↄ̃n daɛbↄnↄ kↄ̃n taanↄ kↄ̃n oroonↄ kↄ̃n éseo kↄ̃n nagãao kↄ̃n wísitio kↄ̃n pↄ́wɛɛ kpatanao kↄ̃n bláo kↄ̃n dò pↄ́nↄ ");
INSERT INTO bus_vpl VALUES ("S217_29","011_17_29","2SA","17","29","29","kↄ̃n zↄ́o kↄ̃n zwifãanio kↄ̃n sã nↄ̀bↄo kↄ̃n gàsio, aↄ̃ↄ kpà Daudaa kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ kúonↄ aↄ̃ ble, zaakɛ aↄ̃ bè: Nↄa kↄ̃n ímiio gbɛ̃ pìnↄ dɛ̀ gbáan, aↄ̃ kpàsamɛ. ");
INSERT INTO bus_vpl VALUES ("S218_1","011_18_1","2SA","18","1","1","Dauda gbɛ̃ kɛ̀ aↄ̃ↄ kúonↄ kàkↄ̃a, ben à gbɛ̃nsinↄ dìɛdiɛ gↄ̃ↄn bↄrↄ doodoonↄnɛ kↄ̃n gↄ̃ↄn basↄsↄↄroonↄ. ");
INSERT INTO bus_vpl VALUES ("S218_2","011_18_2","2SA","18","2","2","Ben à a zĩ̀kari pìnↄ kpàatɛtɛ gãli aagↄ̃. À gãli doo nà Zeruya nɛ́ Yoabunɛ a ↄzĩ, à doo sↄ̃ Yoabu dãaro Abisai ↄzĩ, à doo sↄ̃ Gata gbɛ̃ Itai ↄzĩ. Ben kí bè a zĩ̀karinↄnɛ: Mámbe mɛ́ dↄare aɛ. ");
INSERT INTO bus_vpl VALUES ("S218_3","011_18_3","2SA","18","3","3","Ben gbɛ̃nↄ bè: Ǹton gáro. Tó wa gà wa bàa lɛ̀, aↄ̃é wa yã daro. Baa tó wa gbɛ̃ kpadoonↄ gàga, aↄ̃é wa yã daro. Mmↄn aↄ̃ↄe n gwaa dɛ gↄ̃ↄn bↄrↄ kurinↄla. N dↄnawalɛ wɛ́tɛ guu bé à maa. ");
INSERT INTO bus_vpl VALUES ("S218_4","011_18_4","2SA","18","4","4","Ben kí bèńnɛ: Lán à kɛ̀are maa nàn mɛ́ kɛ. Kí gàa à zɛ̀ bĩilɛ saɛ, ben zĩ̀karinↄ bↄ̀ɛ gãli kↄ̃n gãlio gↄ̃ↄn basↄsↄↄroonↄ kↄ̃n gↄ̃ↄn bↄrↄ doodoonↄ. ");
INSERT INTO bus_vpl VALUES ("S218_5","011_18_5","2SA","18","5","5","Ben kí yã dìɛ Yoabunɛ kↄ̃n Abisaio kↄ̃n Itaio à bè: À kɛ gↄ̃kparɛ Abusalomunɛ busɛbusɛ ma yãnzi. Zĩ̀karinↄ yã kɛ̀ kí dìɛ gbɛ̃nsinↄnɛ Abusalomu yã musu mà ń píngi. ");
INSERT INTO bus_vpl VALUES ("S218_6","011_18_6","2SA","18","6","6","Zĩ̀kpɛɛnↄ bↄ̀ɛ wà gàa lákpɛn, lɛ wà zĩ̀ ká kↄ̃n Isarailinↄ, ben aↄ̃ sìkↄ̃n Ɛflaimu dàkon. ");
INSERT INTO bus_vpl VALUES ("S218_7","011_18_7","2SA","18","7","7","Dauda zĩ̀kpɛɛnↄ zĩ̀ blè Isarailinↄa. Gbɛ̃ kɛ̀ aↄ̃ gàga zĩ beeeanↄↄ pari, gↄ̃ↄn bↄrↄ baromɛ. ");
INSERT INTO bus_vpl VALUES ("S218_8","011_18_8","2SA","18","8","8","Zĩ̀ pì dà bùsu pìla píngi, ben zĩ beeea sɛ̃̀tɛ gbɛ̃nↄ blè pari dɛ fɛ̃ɛdaala. ");
INSERT INTO bus_vpl VALUES ("S218_9","011_18_9","2SA","18","9","9","Kɛ̀ Abusalomu kpàkↄ̃a kↄ̃n Dauda gbɛ̃nↄ, à dina bãagãsↄ̃ kpɛɛ. Ben bãagãsↄ̃ pì gàa gbíi lí ìsi gã̀nↄ gbáru, ben à waa kpà lígãn gíngin, ben à sↄ̃ pì gɛ̃̀ zɛ́la, à gↄ̃̀ logona lígãn gwe. ");
INSERT INTO bus_vpl VALUES ("S218_10","011_18_10","2SA","18","10","10","Kɛ̀ gbɛ̃ke à è, à gàa à bè Yoabunɛ: Ma Abusalomu è kpana lígãn. ");
INSERT INTO bus_vpl VALUES ("S218_11","011_18_11","2SA","18","11","11","Ben Yoabu bè gbɛ̃ kɛ̀ baaru pì kpànɛnɛ: Bↄ́ↄↄ? N à èↄ́? Bↄ́yãnzin nɛ́ɛ à lɛ́ ń nɛ̀ziroo? Lɛ yã ma n gba kondogi ↄↄ mɛ̀n kuri kↄ̃n zĩ̀ka'asaao. ");
INSERT INTO bus_vpl VALUES ("S218_12","011_18_12","2SA","18","12","12","Ben gbɛ̃ pì wè Yoabula à bè: Baa tó wà kondogi ↄↄ wàa sↄↄroo yↄ̃̀ wà kà ma ↄↄn, mɛ́ fↄ̃ mà ↄ pá kína nɛ́ pìaro, zaakɛ kí yã dìɛnnɛ kↄ̃n Abisaio kↄ̃n Itaio wa swã mà, à bè wà kɛ gↄ̃kparɛ Abusalomunɛ busɛbusɛ. ");
INSERT INTO bus_vpl VALUES ("S218_13","011_18_13","2SA","18","13","13","Tó ma à dɛ̀, lɛ ma ásaru kɛ̀ ma zĩndanɛmɛ. À kee utɛna kínanɛro, mmↄn sↄ̃ nɛ́ zɛmaoro. ");
INSERT INTO bus_vpl VALUES ("S218_14","011_18_14","2SA","18","14","14","Yoabu bè: Mɛ́ zɛ mà n dã dↄro. Ben à sári sↄ̃ntɛ sɛ̀ mɛ̀n aagↄ̃, à gàa à Abusalomu zↄ̃̀o a swɛ̃̀n gurↄↄ kɛ̀ à kpana lígãn bɛ̃ɛ. ");
INSERT INTO bus_vpl VALUES ("S218_15","011_18_15","2SA","18","15","15","Ben Yoabu zĩ̀kapↄnↄsɛri gↄ̃ↄn kurinↄ lìgazi aↄ̃ à dɛ̀. ");
INSERT INTO bus_vpl VALUES ("S218_16","011_18_16","2SA","18","16","16","Ben Yoabu kuru pɛ̀ à a zĩ̀karinↄ milɛ blè, ben aↄ̃ kámma bò kↄ̃n pɛɛna Isarailinↄzio. ");
INSERT INTO bus_vpl VALUES ("S218_17","011_18_17","2SA","18","17","17","Aↄ̃ Abusalomu gɛ̀ sɛ̀ aↄ̃ↄ zù wɛ̀ɛ bíta guu lákpɛn gwe, ben aↄ̃ gbɛ̀ kàkↄ̃aa, à gↄ̃̀ gbɛ̀didikↄ̃ana bíta ũ. Isarailinↄ sↄ̃ bàa lɛ̀, baade tà a bɛ. ");
INSERT INTO bus_vpl VALUES ("S218_18","011_18_18","2SA","18","18","18","Gurↄↄ kɛ̀ Abusalomu kuu, à gbɛ̀ pɛ̀ɛ a zĩndanɛ Kína guzurɛn, zaakɛ à bè á nɛ́gↄ̃gbɛ̃ vĩro, ben á yezi a tↄ́ garo. À a zĩnda tↄ́ kpà gbɛ̀ kɛ̀ à pɛ̀ɛ pìnɛ, ben wè gwe sísi Abusalomu Dↄngupↄ ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("S218_19","011_18_19","2SA","18","19","19","Zadↄki nɛ́ Aimaza bè: Ǹ tó mà bàa lɛ́ mà gá baaru kpá kínɛ, lán Dii yã nnaa kpàa nà à à bↄ̀ a ibɛɛnↄ ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("S218_20","011_18_20","2SA","18","20","20","Ben Yoabu bènɛ: Nɛ́ e ǹ baaru kpá gbã̀aro, sé gurↄ pãnde zĩ. Gbã̀a pↄ́ kɛ̀kiin nɛ́ kpáro, kɛ̀ kína nɛ́ gà yãnzi. ");
INSERT INTO bus_vpl VALUES ("S218_21","011_18_21","2SA","18","21","21","Ben Yoabu bè Etiopia boriinɛ: Ǹ gá ǹ yã kɛ̀ ń è o kínɛ. Ben Etiopia borii pì kùɛ Yoabunɛ à fɛ̀ɛ kↄ̃n bào. ");
INSERT INTO bus_vpl VALUES ("S218_22","011_18_22","2SA","18","22","22","Zadↄki nɛ́ Aimaza ɛ̀ara à bè Yoabunɛ: Baa à fↄ̃̀ à kɛ dia, ǹ tó mà bàa lɛ́ màgↄ̃ tɛ́ Etiopia borii pì kpɛɛ. Ben Yoabu bènɛ: Nɛ́, bↄ́yãnzin ń yezi ǹ gázi? Baaru pì égↄ̃ àre ke vĩnnɛro. ");
INSERT INTO bus_vpl VALUES ("S218_23","011_18_23","2SA","18","23","23","Ben Aimaza bè: Baa à fↄ̃̀ à kɛ̀ dia, má yezi mà gámɛ. Ben Yoabu bènɛ: Ǹ gá! Ben à bàa lɛ̀ à gàa à bↄ̀ɛ swaa saɛ zɛ́o, à Etiopia borii pì kɛ̃̀. ");
INSERT INTO bus_vpl VALUES ("S218_24","011_18_24","2SA","18","24","24","Dauda vɛ̃ɛna wɛ́tɛ bĩilɛ gbà mɛ̀n plaaanↄ dagura. Gudãkpari dìdi bĩia ai gãnu pì musu. Kɛ̀ à wɛ́ɛ zù, à gbɛ̃ke è à tɛ́ kↄ̃n bào. ");
INSERT INTO bus_vpl VALUES ("S218_25","011_18_25","2SA","18","25","25","À lɛ́ zù kízi à ònɛ. Ben kí bè: Lán à tɛ́ ado nà, èe mↄↄ kↄ̃n baaru nnaaomɛ. Kɛ̀ èe mↄↄ, à kà kĩi. ");
INSERT INTO bus_vpl VALUES ("S218_26","011_18_26","2SA","18","26","26","Ben gudãkpari pì gbɛ̃ pãnde è dↄ, èe bàa lɛ́ɛ. À lɛ́ zù zɛ́dãkparizi à bè: Gbɛ̃ pãndee tɛ́ à kpɛɛ kãa kↄ̃n bào, èe mↄↄ dↄ. Ben kí bè: Èe mↄↄ kↄ̃n baaru nnaaomɛ se dↄ. ");
INSERT INTO bus_vpl VALUES ("S218_27","011_18_27","2SA","18","27","27","Ben gudãkpari pì bè: Má è gbɛ̃ káaku bàalɛna dɛ lán Zadↄki nɛ́ Aimaza bàalɛna bà. Ben kí bè: Gbɛ̃ maaamɛ, baaru nnaan èe mↄↄo. ");
INSERT INTO bus_vpl VALUES ("S218_28","011_18_28","2SA","18","28","28","Aimaza lɛ́ zù kízi à bè: Aafia kuu! Ben à kùɛ kínɛ à mì pɛ̀ɛ tↄↄtɛa à bè: Wà Dii n Luda sáabu kpá, à gbɛ̃ kɛ̀ aↄ̃ kùsɛ bìimmaanↄ nànnɛ n ↄzĩ, ma dii kí. ");
INSERT INTO bus_vpl VALUES ("S218_29","011_18_29","2SA","18","29","29","Ben kí à là à bè: Gↄ̃kparɛ Abusalomu kú aafiaoↄ́? Aimaza wèàla à bè: Kɛ̀ Yoabu e n zↄ̀bleri zĩi kↄ̃n mamↄma n zↄ̀blerio, má mà zↄka fɛ̀ɛ maamaa, mↄde má dↄ̃ tó bↄ́ bé à sùro. ");
INSERT INTO bus_vpl VALUES ("S218_30","011_18_30","2SA","18","30","30","Kí bè: Ǹ zɛ kpado kɛ̀ gĩa. Ben à zɛ̀ gwe. ");
INSERT INTO bus_vpl VALUES ("S218_31","011_18_31","2SA","18","31","31","Kɛ̀ Etiopia borii sù, à bè: Ma dii kí, ma mↄnnɛ kↄ̃n baaru nnaaomɛ. Dii yã nnaa kpàmma gbã̀a, à n bↄ gbɛ̃ kɛ̀ aↄ̃ bↄ̀ n kpɛɛnↄ ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("S218_32","011_18_32","2SA","18","32","32","Ben kí à là à bè: Gↄ̃kparɛ Abusalomu kú aafiaoↄ́? Etiopia borii pì wèàla à bè: Ma dii kí, Luda tó n ibɛɛnↄ kↄ̃n gbɛ̃ kɛ̀ aↄ̃ fɛ̀ɛ wèe ĩa daammaanↄ gↄ̃ lán gↄ̃kparɛ pì bà. ");
INSERT INTO bus_vpl VALUES ("S218_33","011_18_33","2SA","18","33","33","Swɛ̃̀ kɛ̃̀ kín, à dìdi à gɛ̃̀ kpɛ́ kɛ̀ kú gãnu pì musu, ben à ↄ́ↄ dↄ̀ gwe. Gurↄↄ kɛ̀ èe didii gwe à bè: O'o ma nɛ́ Abusalomu! Ma nɛ́ Abusalomu! Ma gana n gɛ̃ɛ ũu sã̀ↄ yã! Abusalomu ma nɛ́! Ma nɛ́! ");
INSERT INTO bus_vpl VALUES ("S219_1","011_19_1","2SA","19","1","1","Wà bè Yoabunɛ: Kí e ↄ́ↄ dↄↄ, èe sósobi kɛɛ Abusalomu yã musu. ");
INSERT INTO bus_vpl VALUES ("S219_2","011_19_2","2SA","19","2","2","Zĩ beeea zĩ̀karinↄ zĩ̀blena pↄnnaa lì sósobikɛna ũ, zaakɛ aↄ̃ↄ mà wà bè, kí nↄ̀sɛ yàka a nɛ́ yã musu. ");
INSERT INTO bus_vpl VALUES ("S219_3","011_19_3","2SA","19","3","3","Zĩ beeea zĩ̀karinↄ gɛ̃̀ wɛ́tɛn sↄ̀ↄↄsↄↄↄ lán gbɛ̃ kɛ̀ aↄ̃ bàa lɛ̀ zĩ̀lan, wí ń kũnↄ bà. ");
INSERT INTO bus_vpl VALUES ("S219_4","011_19_4","2SA","19","4","4","Kí pↄ́ kù a wɛ́ɛla, èe sósobi ↄ́ↄ dↄↄ èe bee: O'o ma nɛ́ Abusalomu! Abusalomu ma nɛ́! Ma nɛ́! ");
INSERT INTO bus_vpl VALUES ("S219_5","011_19_5","2SA","19","5","5","Ben Yoabu gàa à kí lè kpɛ́n à bè: N wí dà n gbɛ̃nↄa gbã̀a. Aↄ̃ n bↄ gbã̀a kↄ̃n n nɛ́gↄ̃gbɛ̃nↄ kↄ̃n n nɛ́nↄgbɛ̃nↄ kↄ̃n n naↄ̃nↄ kↄ̃n n nↄ yìgisainↄ. ");
INSERT INTO bus_vpl VALUES ("S219_6","011_19_6","2SA","19","6","6","N zangurinↄn ń yeńzi, ben ń za n yenzideenↄn. Ń ↄ̀dↄawe gbã̀a, kɛ̀ wamↄwa n zĩ̀kpɛ gbɛ̃nsinↄ kↄ̃n wa gbɛ̃nↄ wée kánnɛ pↄ́ke ũro. Má dↄ̃̀ sa, tó Abusalomu kuu gbã̀a, ben wapinↄ wa gaga wa píngi, beee bé eé kɛnnɛ nna. ");
INSERT INTO bus_vpl VALUES ("S219_7","011_19_7","2SA","19","7","7","Ǹ fɛɛ ǹ bↄ sa. Ǹ gá ǹ yã nnaa o n gbɛ̃nↄnɛ. Má sìnnɛ kↄ̃n Diio, tó nɛ́ɛ gáro, aↄ̃ gbɛ̃ke é inyo kɛ̀ gwãavĩaro. Beee é kɛnnɛ zaa dɛ yã zaaa kɛ̀ à n le zaa n ↄ̀wazikɛgurↄ ai mↄna gbã̀ala. ");
INSERT INTO bus_vpl VALUES ("S219_8","011_19_8","2SA","19","8","8","Ben kí fɛ̀ɛ à gàa à vɛ̃̀ɛ bĩilɛa. Kɛ̀ wà ò gbɛ̃nↄnɛ kí vɛ̃ɛna gãnulɛa, ben aↄ̃ mↄ̀ wà zɛ̀ à aɛ ń píngi. Isarailinↄ bàa lɛ̀, baade tà a bɛ. ");
INSERT INTO bus_vpl VALUES ("S219_9","011_19_9","2SA","19","9","9","Isaraili boriinↄ tɛ́ píngi gbɛ̃nↄↄ e lɛokpakↄ̃a kɛɛ wà bè: Kí wa si wa ibɛɛnↄa à wa bↄ Filisitininↄ ↄzĩ, ben à bàa lɛ̀ à bↄ̀ wa bùsun Abusalomu yãnzi. ");
INSERT INTO bus_vpl VALUES ("S219_10","011_19_10","2SA","19","10","10","Wa Abusalomu kpà kpatan, ben à gà zĩ̀lan. Bↄ́n ée dãa kↄ̃n kína gbɛsɛnao dↄↄ? ");
INSERT INTO bus_vpl VALUES ("S219_11","011_19_11","2SA","19","11","11","Kí Dauda gbɛ̃nↄ zĩ̀ sa'ori Zadↄkia kↄ̃n sa'ori Abiatao à bè: Yã kɛ̀ Isarailinↄↄ e oo píngi gɛ̃̀ ma swãn zaa ma kúkiia kɛ̀. À yã kɛ̀kii gbeka Yuda gbɛ̃nsinↄa à be: Bↄ́yãnzi a gↄ̃ kpɛɛ kↄ̃n ma gbɛsɛnaozi? ");
INSERT INTO bus_vpl VALUES ("S219_12","011_19_12","2SA","19","12","12","Ma gbɛ̃nↄ, pↄ́ dↄ̃nkↄ̃nↄn wa ũ, wa aru dↄ̃nkↄ̃mɛ. À kɛ̀ dia a gì kɛ̀ kↄ̃n ma gbɛsɛnao? ");
INSERT INTO bus_vpl VALUES ("S219_13","011_19_13","2SA","19","13","13","Ǹ o Amasanɛ pↄ́ dↄ̃nkↄ̃nↄn wa ũ, wa aru dↄ̃nkↄ̃mɛ. Tó mɛ́ɛ tó à gↄ̃̀ ma zĩ̀kpɛɛnↄ gbɛ̃nsi ũ Yoabu gbɛ̀n zaa gbã̀aro, Luda yã kɛmɛ pãsĩpãsĩ. ");
INSERT INTO bus_vpl VALUES ("S219_14","011_19_14","2SA","19","14","14","À yã Yudanↄ swɛ̃̀ blè, aↄ̃ lɛ́ kɛ̀ do, ben aↄ̃ lɛ́kpãsã kɛ̀nɛ wà bè: Ǹ su kↄ̃n n gbɛ̃nↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("S219_15","011_19_15","2SA","19","15","15","Kí e suu, à kà Yodazi, ben Yudanↄ gàa daàlɛ zaa Giligala, lɛ wà bikũo swaa pìa. ");
INSERT INTO bus_vpl VALUES ("S219_16","011_19_16","2SA","19","16","16","Gera nɛ́ Simɛi, Bɛyãmi borii kɛ̀ kú Bahurimu wã̀ à gá da kí Daudalɛ kↄ̃n Yudanↄ. ");
INSERT INTO bus_vpl VALUES ("S219_17","011_19_17","2SA","19","17","17","Bɛyãmi boriinↄↄ kúo gↄ̃ↄn wàa sↄↄro. Solu bɛgwari Ziba gàa dↄ kↄ̃n a nɛ́gↄ̃gbɛ̃ gↄ̃ↄn gɛ̃roonↄ kↄ̃n a zĩkɛri gↄ̃ↄn baroonↄ. Aↄ̃ wã̀ wà kà Yoda lɛ́a kí ã, ");
INSERT INTO bus_vpl VALUES ("S219_18","011_19_18","2SA","19","18","18","lɛ wà e wà bikũ kↄ̃n kíbɛdeenↄ, aↄ̃ yã kɛ̀ eé kɛ kínɛ nnaa kɛ yãnzi. Ben Gera nɛ́ Simɛi dàɛ kí aɛ ai àgↄ̃ gá bikũ Yodaa. ");
INSERT INTO bus_vpl VALUES ("S219_19","011_19_19","2SA","19","19","19","À bènɛ: Ma dii, ǹton ma taari yã daro. Yã zaaa kɛ̀ mamↄma n zↄ̀bleri má kɛ̀nnɛ gurↄↄ kɛ̀ n bↄ Yerusalɛmu tón dↄnguro. Ma dii kí, ǹtongↄ̃ yã pì kũna n swɛ̃̀ guuro. ");
INSERT INTO bus_vpl VALUES ("S219_20","011_19_20","2SA","19","20","20","Mamↄma n zↄ̀bleri, má dↄ̃ kɛ̀ ma durun kɛ̀. Yusufu boriinↄ tɛ́ píngi, mámbe ma dↄńnɛ aɛ ma mↄ danlɛ gbã̀a ma dii kí. ");
INSERT INTO bus_vpl VALUES ("S219_21","011_19_21","2SA","19","21","21","Ben Zeruya nɛ́ Abisai bè: Simɛi láari bↄ̀ kí kɛ̀ Dii kàn. Èe ká wà à dɛroo? ");
INSERT INTO bus_vpl VALUES ("S219_22","011_19_22","2SA","19","22","22","Ben Dauda bè: Zeruya nɛ́nↄ, bↄ́n wa vĩ kↄ̃o? Á yezi à zɛ́ zↄ̃mɛ gbã̀an yↄ́? Wé gbɛ̃ke dɛ Isarailinↄ bùsun gbã̀aro, zaakɛ má dↄ̃ gbã̀a kɛ̀ mámbe Isarailinↄ kína ũ. ");
INSERT INTO bus_vpl VALUES ("S219_23","011_19_23","2SA","19","23","23","Ben kí bè Simɛinɛ: Nɛ́ garo. Ben kí la dànɛ. ");
INSERT INTO bus_vpl VALUES ("S219_24","011_19_24","2SA","19","24","24","Solu dio Mɛfibosɛ gàa da kílɛ. Zaa gurↄↄ kɛ̀ kí bↄ̀ wɛ́tɛ ai gurↄↄ kɛ̀ à sù aafia, Mɛfibosɛ e a gbá pípiro, èe a yĩkã zↄ̃zↄ̃ro, èe a pↄ́nↄ pípiro. ");
INSERT INTO bus_vpl VALUES ("S219_25","011_19_25","2SA","19","25","25","Kɛ̀ à bↄ̀ Yerusalɛmu à mↄ̀ à dà kílɛ, ben kí à là à bè: Mɛfibosɛ, à kɛ̀ dia nɛ́ɛ gámaoroo? ");
INSERT INTO bus_vpl VALUES ("S219_26","011_19_26","2SA","19","26","26","À wèàla à bè: Ma dii kí, ma zĩkɛri bé à ↄ̃ndↄ̃ↄ kɛ̀mazi. Má ònɛ à gàari yimɛ ma zaakinɛ mà dia mà gányo, zaakɛ ɛrɛn ma ũ. ");
INSERT INTO bus_vpl VALUES ("S219_27","011_19_27","2SA","19","27","27","Ma dii kí, ben à gàa à mamↄma n zↄ̀bleri yàka n kiia. Ma dii kí ń dɛ lán Luda malaika bàmɛ. Ǹ kɛ lán à kɛ̀nnɛ maa nà. ");
INSERT INTO bus_vpl VALUES ("S219_28","011_19_28","2SA","19","28","28","Ma dii kí, à dɛ yã n ma de bɛdeenↄ dɛ̀dɛ ń píngi, ben n mamↄma n zↄ̀bleri baka kàkↄ̃a kↄ̃n n gbɛ̃ kɛ̀ aↄ̃è pↄ́ ble lɛdoonↄ. Má zɛ́ vĩ mà kúɛ ke kɛnnɛ dↄro. ");
INSERT INTO bus_vpl VALUES ("S219_29","011_19_29","2SA","19","29","29","Ben kí bènɛ: Yã kpareen nɛ́ o dↄↄ? Má dìɛ kɛ̀ mpi kↄ̃n Zibao, à tↄↄtɛ kpaatɛkↄ̃nɛmɛ. ");
INSERT INTO bus_vpl VALUES ("S219_30","011_19_30","2SA","19","30","30","Ben Mɛfibosɛ bè kínɛ: Ma dii kí, zaakɛ n su bɛ aafia, ǹ tó à sɛ́ píngi. ");
INSERT INTO bus_vpl VALUES ("S219_31","011_19_31","2SA","19","31","31","Giliada bùsu gbɛ̃ Bazilai bↄ̀ Rogɛlimu à gàa zɛ kínɛ ai Yoda baa kãa kpa. ");
INSERT INTO bus_vpl VALUES ("S219_32","011_19_32","2SA","19","32","32","Bazilai zi kũ̀ maamaa, à kà wɛ̃̀ basiigↄ̃. À kí yàari kɛ̀ gurↄↄ kɛ̀ à kú Manaimu, zaakɛ auzikide bítamɛ. ");
INSERT INTO bus_vpl VALUES ("S219_33","011_19_33","2SA","19","33","33","Ben kí bènɛ: Ǹ bikũmao, mɛ́ n gwa ma bɛ zaa Yerusalɛmu. ");
INSERT INTO bus_vpl VALUES ("S219_34","011_19_34","2SA","19","34","34","Bazilai wèàla à bè: Wɛ̃̀ ũgba bé à gↄ̃̀mɛ anduna guu kɛ̀ mà tányo Yerusalɛmu? ");
INSERT INTO bus_vpl VALUES ("S219_35","011_19_35","2SA","19","35","35","Ma ka wɛ̃̀ basiigↄ̃ kↄ̀. Má pↄ́ maa kↄ̃n à zaaao dↄ̃kↄ̃zi dↄↄ́? Mamↄma n zↄ̀bleri mɛ́ fↄ̃ mà pↄ́blena ke pↄ́mina nnaa ma dↄↄ́? Mɛ́ gↄ̃gbɛ̃ ke nↄgbɛ̃ lɛ̀sirinↄ kòto ma dↄↄ́? Ma dii kí, ǹ tó mà asoo lagonnɛ. ");
INSERT INTO bus_vpl VALUES ("S219_36","011_19_36","2SA","19","36","36","Mamↄma n zↄ̀bleri wé Yoda bikũ lɛdo, mà zɛnnɛ kĩikĩi gwe. À kɛ̀ dia ń yezi ǹ fĩa bomɛ lɛɛ? ");
INSERT INTO bus_vpl VALUES ("S219_37","011_19_37","2SA","19","37","37","Mamↄma n zↄ̀bleri, ǹ tó mà ɛara mà tá ma bɛ wɛ́tɛ, lɛ gaa tón ma sɛ́ màgↄ̃ zã̀ kↄ̃n ma de kↄ̃n ma da miraoro. Ǹ ma nɛ́ n zↄ̀bleri Kimamu gwa kɛ̀. Ma dii kí, ǹ tó à bikũnyo. Ǹ kɛnɛ lán à kɛ̀nnɛ maa nà. ");
INSERT INTO bus_vpl VALUES ("S219_38","011_19_38","2SA","19","38","38","Ben kí bè: Kimamu é bikũmao. Mɛ́ yã kɛ̀ à kɛ̀nnɛ maaa kɛnɛ, yã kɛ̀ ń gbèkama sↄ̃ píngi mɛ́ kɛnnɛ. ");
INSERT INTO bus_vpl VALUES ("S219_39","011_19_39","2SA","19","39","39","Baade píngi bikũ̀ Yodaa, ben kí bikũ̀. Kí lɛ́ pɛ̀ Bazilaia à sa maaa ònɛ, ben Bazilai ɛ̀ara à tà a bɛ. ");
INSERT INTO bus_vpl VALUES ("S219_40","011_19_40","2SA","19","40","40","Kɛ̀ kí bikũ̀ à gàa Giligala, Kimamu bikũ̀o. Yuda zĩ̀karinↄ ń píngi kↄ̃n Isaraili zĩ̀kari kpadoonↄ kí bikũ̀. ");
INSERT INTO bus_vpl VALUES ("S219_41","011_19_41","2SA","19","41","41","Ben Isaraili bori píngi mↄ̀ wà kí lè aↄ̃ bènɛ: À kɛ̀ dia wa gbɛ̃ Yudanↄ bikũ̀ao kpãi, mmↄn kↄ̃n n bɛdeenↄ kↄ̃n n gbɛ̃nↄ píngii? ");
INSERT INTO bus_vpl VALUES ("S219_42","011_19_42","2SA","19","42","42","Ben Yudanↄ wèńla wà bè: Kɛ̀ kí dɛ wa danɛ ũ yãnzimɛ. Bↄ́yãnzi yã beee kɛ̀are zaazi? Wée kí kũsãɛ blero, wée à pↄ́ke sí wa pↄ́ ũro. ");
INSERT INTO bus_vpl VALUES ("S219_43","011_19_43","2SA","19","43","43","Ben Isarailinↄ bè Yudanↄnɛ: Zaakɛ wa bori lɛo kurimɛ, wa baka kú kↄ̃n kí Daudao dɛ a pↄ́la. Bↄ́yãnzi a wa diɛ futazi lɛɛ? Wámbe wa kí gbɛsɛna yã ò káakuroo? Mↄde Yudanↄ wena pãsĩ dɛ Isarailinↄ pↄ́la. ");
INSERT INTO bus_vpl VALUES ("S220_1","011_20_1","2SA","20","1","1","Gaabude ke bé à kú gwe, à tↄ́n Sɛba, Bikiri nɛ́, Bɛyãmi boriimɛ. Ben à kuru pɛ̀ à bè: Wa baka kakↄ̃ana kↄ̃n Daudaoro, wa bà kú kↄ̃n Yɛsɛ nɛ́oro, a Isarailinↄ, a baade tá a bɛ. ");
INSERT INTO bus_vpl VALUES ("S220_2","011_20_2","2SA","20","2","2","Ben Isarailinↄ kɛ̃̀ Daudaa ń píngi aↄ̃ gàa wà nà Bikiri nɛ́ Sɛbaa, mↄde Yudanↄ zɛ̀ kↄ̃n ń kío bↄna zaa Yodazi ai Yerusalɛmu. ");
INSERT INTO bus_vpl VALUES ("S220_3","011_20_3","2SA","20","3","3","Kɛ̀ Dauda sù a bɛ Yerusalɛmu, à a nↄ yìgisai gↄ̃ↄn kuri kɛ̀ à tò aↄ̃ↄe bɛɛ gwaanↄ sɛ̀ à ń ká kpɛ́n wàgↄ̃ ń dãkpaa. Dauda ń gwá, mↄde èe daɛńyo dↄro. Wà ń káka kpɛ́n gyaanↄnↄ ũmɛ ai aↄ̃ gàa wà gàgao. ");
INSERT INTO bus_vpl VALUES ("S220_4","011_20_4","2SA","20","4","4","Ben kí bè Amasanɛ: Ǹ Yuda zĩ̀kpɛɛnↄ sísi aↄ̃ kakↄ̃amazi gurↄ aagↄ̃ↄ dagura. Mmↄn sↄ̃, nɛ́gↄ̃ kú kɛ̀mɛ. ");
INSERT INTO bus_vpl VALUES ("S220_5","011_20_5","2SA","20","5","5","Amasa gàa à Yudanↄ sìsi, mↄde à gì kɛ̀ dɛ gurↄↄ kɛ̀ kí dìɛnɛla. ");
INSERT INTO bus_vpl VALUES ("S220_6","011_20_6","2SA","20","6","6","Ben Dauda bè Abisainɛ: Bikiri nɛ́ Sɛba é ĩa dawa tia dɛ ĩaa kɛ̀ Abusalomu dàwaala. Ǹ ma gbɛ̃nↄ sɛ́ɛ à pɛ́ɛzi, lɛ àton sí wɛ́tɛ bĩideen à piti wa ↄzĩro yãnzi. ");
INSERT INTO bus_vpl VALUES ("S220_7","011_20_7","2SA","20","7","7","Ben Yoabu gbɛ̃nↄ kↄ̃n kí dãkparinↄ kↄ̃n zĩ̀karinↄ ń píngi wà bↄ̀ɛ Yerusalɛmu wà pɛ̀ɛ Bikiri nɛ́ Sɛbazi. ");
INSERT INTO bus_vpl VALUES ("S220_8","011_20_8","2SA","20","8","8","Gurↄↄ kɛ̀ aↄ̃ↄ kú gbɛ̀ gbɛ̃̀ntɛ̃ kɛ̀ kú Gibiↄ̃ saɛ, ben Amasa mↄ̀ dańlɛ. Yoabu zĩ̀ka'uta dana, à fɛ̃ɛ dↄna à pii. Kɛ̀ à sↄ̃̀ Amasazi, à fɛ̃ɛ pì wòto a kpɛ́ɛn ");
INSERT INTO bus_vpl VALUES ("S220_9","011_20_9","2SA","20","9","9","à bènɛ: Ma gbɛ̃, ń aafiaↄ́? Ben à Amasa kũ̀ a lɛ́tãnkaa kↄ̃n a ↄ plaaao lán à yezi à lɛ́ pɛ́a bà. ");
INSERT INTO bus_vpl VALUES ("S220_10","011_20_10","2SA","20","10","10","Amasa e fɛ̃ɛ kɛ̀ kú Yoabu ↄↄn tàasi káro, ben Yoabu à zↄ̃̀o a gbɛɛɛn, à nↄaɛnↄ bↄ̀ɛ à kàɛ tↄↄtɛ. Yoabu e gà à zↄ̃̀o gɛ̃̀n plaa dↄro, zaakɛ à gà kↄ̀. Ben Yoabu kↄ̃n a dãaro Abisaio pɛ̀ɛ Bikiri nɛ́ Sɛbazi. ");
INSERT INTO bus_vpl VALUES ("S220_11","011_20_11","2SA","20","11","11","Yoabu ìbanↄ doke gↄ̃̀ zɛna Amasala à bè: Gbɛ̃ kɛ̀ zɛ̀ kↄ̃n Yoabuo kↄ̃n Daudao, à dↄ Yoabuzi. ");
INSERT INTO bus_vpl VALUES ("S220_12","011_20_12","2SA","20","12","12","Aru daa Amasa gɛ̀la zɛ́daan, ben zĩ̀kari kɛ̀ aↄ̃ↄe mↄↄnↄ zɛ̀ aↄ̃ↄe gwaa ń píngi. Kɛ̀ Yoabu ìba pì è gbɛ̃ kɛ̀ aↄ̃ↄe mↄↄ gweenↄ ń píngi wà zɛ̀ wèe gwaa, ben à Amasa gɛ̀ gàɛ à gùo zɛ́n à dìɛ sɛ̃̀n, ben à uta kùàla. ");
INSERT INTO bus_vpl VALUES ("S220_13","011_20_13","2SA","20","13","13","Kɛ̀ à gàɛ à gùo zɛ́n lɛ, baade píngi bↄ̀ à tɛ̀ Yoabuzi, ben aↄ̃ Bikiri nɛ́ Sɛba gbɛ̀sɛ. ");
INSERT INTO bus_vpl VALUES ("S220_14","011_20_14","2SA","20","14","14","Sɛba lili ò Isaraili boriinↄ bùsun píngi ai Abɛli Bɛtɛmaka, ben Bɛri boriinↄ mↄ̀ wà kàkↄ̃a wà tɛ̀zi gwe. ");
INSERT INTO bus_vpl VALUES ("S220_15","011_20_15","2SA","20","15","15","Yoabunↄ mↄ̀ wà lìgazi zaa Abɛli Bɛtɛmaka. Wà bùsu kàɛkaɛ wɛ́tɛ bĩi saɛ, ben aↄ̃ↄe wɛtɛɛ wà bĩi pì gboro. ");
INSERT INTO bus_vpl VALUES ("S220_16","011_20_16","2SA","20","16","16","Ben nↄgbɛ̃ ↄ̃ndↄ̃de ke lɛ́ zù zaa wɛ́tɛ guu à bè: À swã kpá! À swã kpá! Ǹ o Yoabunɛ à mↄ́ kɛ̀, mà yã onɛ. ");
INSERT INTO bus_vpl VALUES ("S220_17","011_20_17","2SA","20","17","17","Kɛ̀ Yoabu sↄ̃̀ nↄgbɛ̃ pìzi, ben à à là à bè: Ḿbe Yoabu ũↄ́? À wèàla à bè: Mámbee! Ben à bènɛ: Ǹ swã kpá mamↄma n zↄ̀bleri yãzi. À bè: Ma swã kpà. ");
INSERT INTO bus_vpl VALUES ("S220_18","011_20_18","2SA","20","18","18","Ben nↄgbɛ̃ pì bè: Wè be yã, ǹ yã gbeka Abɛlideenↄa, yã e à mì dɛ. ");
INSERT INTO bus_vpl VALUES ("S220_19","011_20_19","2SA","20","19","19","Wá kuu yãkete sai Isaraili gbɛ̃ náanɛdeenↄ ũ, ben nɛ́ɛ wɛtɛɛ ǹ Isaraili wɛ́tɛ tↄ́dee kɛ̀ kaatɛↄ́? Bↄ́yãnzi ń yezi ǹ Dii wɛ́tɛ dɛzi? ");
INSERT INTO bus_vpl VALUES ("S220_20","011_20_20","2SA","20","20","20","Yoabu wèàla à bè: Agya! Lɛnlo! Má yezi mà a dɛdɛro. Má yezi mà a wɛ́tɛ kaatɛro. ");
INSERT INTO bus_vpl VALUES ("S220_21","011_20_21","2SA","20","21","21","Lɛnlo! Gbɛ̃ kɛ̀ wè sísi Bikiri nɛ́ Sɛba, Ɛflaimu boriinↄ bùsu sĩ̀sĩde gbɛ̃ bé à fɛ̀ɛ kí Daudazi. À gbɛ̃ mɛ̀n doo pì kpáma, mɛ́ go a wɛ́tɛla. Ben nↄgbɛ̃ pì bènɛ: Ǹ ma! Weé à mì zunnɛ zaa bĩi musu. ");
INSERT INTO bus_vpl VALUES ("S220_22","011_20_22","2SA","20","22","22","Nↄgbɛ̃ pì gàa à a gbɛ̃nↄ lè kↄ̃n a ↄ̃ndↄ̃kɛyão, ben wà Bikiri nɛ́ Sɛba mì zↄ̃̀ wà zù Yoabunɛ. Yoabu kuru pɛ̀, ben wà fã̀akↄ̃a, wà wɛ́tɛ pì tò gwe. Baade tà a bɛ, ben Yoabu pì tà kí kiia Yerusalɛmu. ");
INSERT INTO bus_vpl VALUES ("S220_23","011_20_23","2SA","20","23","23","Yoabun Isaraili zĩ̀kpɛɛnↄ píngi gbɛ̃nsi ũ. Yoyada nɛ́ Bɛnayan dogarinↄ gbɛ̃nsi ũ. ");
INSERT INTO bus_vpl VALUES ("S220_24","011_20_24","2SA","20","24","24","Adoniramu bé zↄ̀nↄ gbɛ̃nsi ũ. Ailudi nɛ́ Yosafatan baarukpari ũ. ");
INSERT INTO bus_vpl VALUES ("S220_25","011_20_25","2SA","20","25","25","Sevan takadakɛ̃ri ũ. Zadↄki kↄ̃n Abiataon sa'orikinↄ ũ. ");
INSERT INTO bus_vpl VALUES ("S220_26","011_20_26","2SA","20","26","26","Yairi gbɛ̃ Iran Dauda kpàasi ũ. ");
INSERT INTO bus_vpl VALUES ("S221_1","011_21_1","2SA","21","1","1","Dekaa kuu Dauda gurↄↄa, à gì kɛ̀ ai wɛ̃̀ aagↄ̃. Dauda Dii wɛ́ɛ wɛ̀tɛ, ben Dii bè: Solu yãnzimɛ. Gbɛ̃dɛyã wì à bɛɛ musu, kɛ̀ à Gibiↄ̃deenↄ dɛ̀dɛ yãnzi. ");
INSERT INTO bus_vpl VALUES ("S221_2","011_21_2","2SA","21","2","2","Ben kí Gibiↄ̃deenↄ sìsi, à yã òńnɛ. Gibiↄ̃deenↄↄ dɛ Isarailinↄ ũro, Amↄri borii kɛ̀ gↄ̃̀nↄmɛ. Isarailinↄ la dàńnɛ yã wà bè weé ń dɛdɛro, ben Solu wɛ̀tɛ à ń laata kpá a aĩakɛna Isarailinↄnɛ kↄ̃n Yudanↄo yãnzi. ");
INSERT INTO bus_vpl VALUES ("S221_3","011_21_3","2SA","21","3","3","Ben Dauda Gibiↄ̃deenↄ là à bè: Bↄ́n á yezi mà kɛaree? Mɛ́ agbaa kpáare diamɛ, lɛ à e à Dii gbɛ̃nↄ sáabu kpáa? ");
INSERT INTO bus_vpl VALUES ("S221_4","011_21_4","2SA","21","4","4","Aↄ̃ wèàla wà bè: Wá zɛ́ vĩ wà kondogi ke vura gbeka Solua ke a bɛdeeanↄro, bensↄ̃ wá zɛ́ vĩ wà Isaraili gbɛ̃ke dɛro. Ben Dauda ń lá à bè: Ée bee diamɛ? Bↄ́n mɛ́ kɛaree? ");
INSERT INTO bus_vpl VALUES ("S221_5","011_21_5","2SA","21","5","5","Aↄ̃ wèàla wà bè: Gbɛ̃ kɛ̀ à wa dɛdɛ à lɛ́ kpàkↄ̃sↄ̃wazi à wa yãa lɛ à e à wa borii bↄ Isarailinↄ guu yãnzi, ");
INSERT INTO bus_vpl VALUES ("S221_6","011_21_6","2SA","21","6","6","tó wà à bori gↄ̃gbɛ̃ mɛ̀n swɛɛplaaanↄ kpáwa, wé ń logo lía Dii aɛ Gibɛa, kí Solu kɛ̀ Dii kà pì bɛ wɛ́tɛn. Ben kí bè: Mɛ́ ń kpáawa. ");
INSERT INTO bus_vpl VALUES ("S221_7","011_21_7","2SA","21","7","7","Kí e Yonatã nɛ́ Mɛfibosɛ, Solu dio kpáḿmaro, lɛ́ kɛ̀ aↄ̃ↄ kɛ̀ Diia lɛdo kↄ̃n Yonatão yãnzi. ");
INSERT INTO bus_vpl VALUES ("S221_8","011_21_8","2SA","21","8","8","À nɛ́gↄ̃gbɛ̃ gↄ̃ↄn plaaa kɛ̀ Aya nɛ́nↄgbɛ̃ Rizipa ì kↄ̃n Soluo sɛ̀. Aↄ̃ tↄ́n yɛ̀: Aamↄni kↄ̃n Mɛfibosɛo. À nɛ́gↄ̃gbɛ̃ gↄ̃ↄn sↄↄroo kɛ̀ Solu nɛ́nↄgbɛ̃ Mɛraba ì kↄ̃n Mɛↄla gbɛ̃ Bazilai nɛ́ Adiɛlionↄ sɛ̀ dↄ. ");
INSERT INTO bus_vpl VALUES ("S221_9","011_21_9","2SA","21","9","9","À ń ná Gibiↄ̃deenↄnɛ ń ↄzĩ, ben aↄ̃ ń logo lía sĩ̀sĩ musu Dii aɛ. Gↄ̃ↄn swɛɛplaaa pìnↄ gà lɛdomɛ, wà ń dɛdɛ pↄ́ dúfu kɛkɛgurↄ. ");
INSERT INTO bus_vpl VALUES ("S221_10","011_21_10","2SA","21","10","10","Aya nɛ́ Rizipa pↄsia utanↄ sɛ̀ à kpàɛ a zĩndanɛ gbɛ̀a gwe. Zaa pↄ́ dúfu kɛkɛgurↄ ai lou gàa à gɛ̀ pìnↄ gbɛ̃̀, ègↄ̃ gii bãanↄnɛ aↄ̃ zↄ̃ḿma fãantɛ̃, ègↄ̃ gii sɛ̃̀tɛ nↄ̀bↄnↄnɛ aↄ̃ sↄ̃ńzi gwã. ");
INSERT INTO bus_vpl VALUES ("S221_11","011_21_11","2SA","21","11","11","Wà yã kɛ̀ Solu nↄ yìgisai pì kɛ̀ ò Daudanɛ, ");
INSERT INTO bus_vpl VALUES ("S221_12","011_21_12","2SA","21","12","12","ben à gàa à Solu kↄ̃n à nɛ́ Yonatão wánↄ sɛ̀ɛ Yabɛsi Giliadadeenↄ kiia. À mↄ̀ à lè wà ń gɛ̀nↄ sɛ̀ɛ kpãi Bɛtɛsã gãalɛ, guu kɛ̀ Filisitininↄ ń logo bĩia Solu dɛna Giliboa gbɛra. ");
INSERT INTO bus_vpl VALUES ("S221_13","011_21_13","2SA","21","13","13","Dauda tò wà ń gɛ̀wa pìnↄ sɛ̀ɛ wà tào, wà kàkↄ̃a kↄ̃n gbɛ̃ kɛ̀ wà ń logo pìnↄ gɛ̀wanↄ, ");
INSERT INTO bus_vpl VALUES ("S221_14","011_21_14","2SA","21","14","14","ben wà vĩ̀i Solu de Kisi miran Zɛla, Bɛyãmi boriinↄ bùsun. Wà yã kɛ̀ kína dìɛ kɛ̀ píngi, ben Luda adua kɛ̀ wà kɛ̀ Isarailinↄ bùsu yã musu sìńyo. ");
INSERT INTO bus_vpl VALUES ("S221_15","011_21_15","2SA","21","15","15","Filisitininↄ ɛ̀ara wà zĩ̀ kà kↄ̃n Isarailinↄ dↄ. Dauda kↄ̃n a gbɛ̃nↄ gàa wà zĩ̀ kàńyo. Kɛ̀ Dauda gbãaa yã̀a, ");
INSERT INTO bus_vpl VALUES ("S221_16","011_21_16","2SA","21","16","16","ben gbɛ̃ gbã̀anↄ bori Isibi Bɛnↄbu bè é Dauda dɛmɛ. À mↄ̀gotɛ̃ sári tìisi dɛ kiloo aagↄ̃ↄla, à fɛ̃ɛda dufu logona. ");
INSERT INTO bus_vpl VALUES ("S221_17","011_21_17","2SA","21","17","17","Ben Zeruya nɛ́ Abisai dↄ̀àlɛ à Filisitini pì dɛ̀. Ben Dauda gbɛ̃nↄ la dànɛ wà bè: Nɛ́ gáwao zĩ̀lan dↄro, lɛ wa Isarailinↄ fitia tón garo yãnzi. ");
INSERT INTO bus_vpl VALUES ("S221_18","011_21_18","2SA","21","18","18","Beee gbɛra aↄ̃ↄe zĩ̀ kaa kↄ̃n Filisitininↄ Gobu, ben Usa gbɛ̃ Sibekai gbɛ̃ gbã̀a borii kɛ̀ wè sísi Safa dɛ̀. ");
INSERT INTO bus_vpl VALUES ("S221_19","011_21_19","2SA","21","19","19","Zĩ̀ ɛ̀ara à fɛ̀ɛ kↄ̃n Filisitininↄ Gobu dↄ, ben Bɛtɛlɛmu gbɛ̃ Yairi nɛ́ Ɛlana Gata gbɛ̃ Gↄlaya dãaro Lami dɛ̀. Lami sári pá dɛ lán bisatãri àsa lí bàmɛ. ");
INSERT INTO bus_vpl VALUES ("S221_20","011_21_20","2SA","21","20","20","Kɛ̀ aↄ̃ↄe zĩ̀ kaańyo Gata dↄ, gbɛ̃ bíta kee kú gwe, à ↄnɛnↄ kↄ̃n à gbánɛnↄ mɛ̀n swɛɛdodomɛ, à kɛ̀ píngi baaasↄↄro dosai. Gbɛ̃ gbã̀anↄ boriimɛ dↄ. ");
INSERT INTO bus_vpl VALUES ("S221_21","011_21_21","2SA","21","21","21","À kùsɛ bìi Isarailinↄa, ben Dauda vĩ̀i Simɛa nɛ́ Yonatã à dɛ̀. ");
INSERT INTO bus_vpl VALUES ("S221_22","011_21_22","2SA","21","22","22","Gↄ̃ↄn siigↄ̃ↄ pìnↄ nɛ́ Gata gbɛ̃ gbã̀anↄ boriinↄmɛ. Dauda kↄ̃n a gbɛ̃nↄ bé wà ń dɛdɛ. ");
INSERT INTO bus_vpl VALUES ("S222_1","011_22_1","2SA","22","1","1","Kɛ̀ Dii kí Dauda bↄ̀ Solu kↄ̃n à ibɛɛ kpaaanↄ ↄzĩ, à lɛ̀ dà kↄ̃n Dii tↄ́o ");
INSERT INTO bus_vpl VALUES ("S222_2","011_22_2","2SA","22","2","2","à bè: Diin ma gbɛ̀si kↄ̃n ma zɛki gbãaao ũ, ma mìsirimɛ. ");
INSERT INTO bus_vpl VALUES ("S222_3","011_22_3","2SA","22","3","3","Ma Ludan ma gbɛ̀si ũ, mɛɛ̀ nazi. Àmbe ma sɛngbango ũ ma mìsiri gbãa kↄ̃n ma gulezĩo, ma utɛki kↄ̃n ma bↄkiio, è ma sí gbɛ̃ pãsĩnↄa. ");
INSERT INTO bus_vpl VALUES ("S222_4","011_22_4","2SA","22","4","4","Dii kà wà à sáabu kpá. Mɛɛ̀ à sísi, è ma bↄ ma ibɛɛnↄ ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("S222_5","011_22_5","2SA","22","5","5","Góro'itɛ vlɛ̃̀ɛmao, ísↄ̃ kɛ̀ è ń kaatɛ e ma blee. ");
INSERT INTO bus_vpl VALUES ("S222_6","011_22_6","2SA","22","6","6","Mira bànↄ lìgamazi, gaa takutɛɛ kpàkpamɛ ma aɛ. ");
INSERT INTO bus_vpl VALUES ("S222_7","011_22_7","2SA","22","7","7","Kɛ̀ má kú nawɛ̃a guu lɛ, ma Dii sìsi, ma wii pɛ̀ ma Ludazi, ben à ma kòto mà zaa a bɛ, ma wiii kà à kiia, à gɛ̃̀ à swãn. ");
INSERT INTO bus_vpl VALUES ("S222_8","011_22_8","2SA","22","8","8","Tↄↄtɛ lùgaluga à nìgãnigã, kpiiinↄ dègedege ai ń kãsãan. Aↄ̃ lùgaluga kɛ̀ à pↄ fɛ̃̀ yãnzi. ");
INSERT INTO bus_vpl VALUES ("S222_9","011_22_9","2SA","22","9","9","Tɛ́sukpɛ bↄ̀ à yĩzĩ, tɛ́ kɛ̀ è ń kpata bↄ̀ à lɛ́n, à yↄ̃̀nↄↄ e tɛ́ kɛɛ à aɛ. ");
INSERT INTO bus_vpl VALUES ("S222_10","011_22_10","2SA","22","10","10","À musu wɛ̃̀ à pìta, lou sìsi à gbá gĩzĩ. ");
INSERT INTO bus_vpl VALUES ("S222_11","011_22_11","2SA","22","11","11","Èe vĩaa dina kɛrubu kpɛɛ, èe yàa paa ĩala. ");
INSERT INTO bus_vpl VALUES ("S222_12","011_22_12","2SA","22","12","12","À gusiaa dà a zĩndala, ludambɛ sia kũ̀ à kúkiila. ");
INSERT INTO bus_vpl VALUES ("S222_13","011_22_13","2SA","22","13","13","Zaa à gakui tɛ́kɛna guu lou e pii pãsĩpãsĩ. ");
INSERT INTO bus_vpl VALUES ("S222_14","011_22_14","2SA","22","14","14","Dii pàta zaa musu, Luda Musude kòto dↄ lapatana ũ. ");
INSERT INTO bus_vpl VALUES ("S222_15","011_22_15","2SA","22","15","15","À kà fã̀ ma ibɛɛnↄa à ń fãakↄ̃a, à tò lou pìḿma à pɛ̀ḿma. ");
INSERT INTO bus_vpl VALUES ("S222_16","011_22_16","2SA","22","16","16","Kɛ̀ Dii pàtaḿma, kɛ̀ à pↄ́ bↄ̀ a yĩzĩ, ísia tↄↄtɛ bↄ̀ gupuraaa, anduna kãsãa gↄ̃̀ kaɛna pↄ̃tɛ̃. ");
INSERT INTO bus_vpl VALUES ("S222_17","011_22_17","2SA","22","17","17","À ↄ bↄ̀ zaa musu à ma kũ, à ma bↄ swadaa guu. ");
INSERT INTO bus_vpl VALUES ("S222_18","011_22_18","2SA","22","18","18","À ma si ma ibɛɛ gbãaa ↄzĩ kↄ̃n ma zanguri kɛ̀ aↄ̃ gbãaa dɛmalaanↄ. ");
INSERT INTO bus_vpl VALUES ("S222_19","011_22_19","2SA","22","19","19","Aↄ̃ lɛ̀ɛma ma mↄ́nzikɛgurↄ, mↄde Dii zɛ̀mao. ");
INSERT INTO bus_vpl VALUES ("S222_20","011_22_20","2SA","22","20","20","À ma bↄ à ma gba mɛ̀porokii, à ma mì sì, kɛ̀ à yemazi yãnzi. ");
INSERT INTO bus_vpl VALUES ("S222_21","011_22_21","2SA","22","21","21","Dii yã kɛ̀mɛ ma nↄ̀sɛ maa lɛ́n, à fĩa bòmɛ ma gbãsĩsaikɛ lɛ́n. ");
INSERT INTO bus_vpl VALUES ("S222_22","011_22_22","2SA","22","22","22","Zaakɛ má Luda yãdiɛnanↄ kũna, mɛ́ɛ à zaaa kɛ ma a Luda tònlo. ");
INSERT INTO bus_vpl VALUES ("S222_23","011_22_23","2SA","22","23","23","À dokayãnↄ ègↄ̃ dↄↄmɛ aɛ píngi, mɛ́ɛ kpɛɛ li yã kɛ̀ à dìɛnↄnɛro. ");
INSERT INTO bus_vpl VALUES ("S222_24","011_22_24","2SA","22","24","24","Má kuuna taari vĩ Diinɛro, má a zĩnda kũna durun sai. ");
INSERT INTO bus_vpl VALUES ("S222_25","011_22_25","2SA","22","25","25","Dii fĩa bòmɛ ma nↄ̀sɛ maa lɛ́n, zaakɛ à è má kuu gbãsĩ sai. ");
INSERT INTO bus_vpl VALUES ("S222_26","011_22_26","2SA","22","26","26","Náanɛdeen n ũ náanɛdeenↄnɛ, taarisaideen n ũ taarisaideenↄnɛ. ");
INSERT INTO bus_vpl VALUES ("S222_27","011_22_27","2SA","22","27","27","Ń wásawasa gbɛ̃ wásawasanↄnɛ, mↄde nɛɛ̀ íbɛtɛ kpá kↄ̃n gbɛ̃ dↄ̀rↄsaideenↄo. ");
INSERT INTO bus_vpl VALUES ("S222_28","011_22_28","2SA","22","28","28","Nɛɛ̀ zĩndabusarinↄ mì sí, nɛɛ̀ gbɛ̃ kɛ̀ aↄ̃è ń zĩnda sɛ́ lezĩnↄ sↄ̃ɛ. ");
INSERT INTO bus_vpl VALUES ("S222_29","011_22_29","2SA","22","29","29","Dii, ḿbe ma fitia ũ, Dii, nɛɛ̀ ma gusiaa liɛ gupuraa ũ. ");
INSERT INTO bus_vpl VALUES ("S222_30","011_22_30","2SA","22","30","30","Kↄ̃n n gbãaao mɛ́ fↄ̃ mà kù kpá karaa, ma Luda gãzĩ mɛ́ fↄ̃ mà vĩ gũ̀la. ");
INSERT INTO bus_vpl VALUES ("S222_31","011_22_31","2SA","22","31","31","Luda kɛ̀kii sↄ̃ yãkɛna bↄɛzina, Dii yã see vĩro, à wásawasa, à dɛ sɛngbango ũ gbɛ̃ kɛ̀ aↄ̃ nàzinↄnɛ. ");
INSERT INTO bus_vpl VALUES ("S222_32","011_22_32","2SA","22","32","32","Dii baasiro, dén Luda ũu? Wa Luda baasiro, dén gbɛ̀si ũu? ");
INSERT INTO bus_vpl VALUES ("S222_33","011_22_33","2SA","22","33","33","Luda bé è ma gba gbãaa, àmbe è zɛ́ poromɛ súusu. ");
INSERT INTO bus_vpl VALUES ("S222_34","011_22_34","2SA","22","34","34","È tó ma gbá kãi gↄ̃ nna lán zↄ̃ pↄ́ bà, è tó màgↄ̃ táa oo gulezĩnↄ musu. ");
INSERT INTO bus_vpl VALUES ("S222_35","011_22_35","2SA","22","35","35","È zĩ̀kana dadamɛ, ai ma gã̀sã é fↄ̃ à mↄ̀gotɛ̃ sá gá. ");
INSERT INTO bus_vpl VALUES ("S222_36","011_22_36","2SA","22","36","36","Nɛɛ̀ n zĩ̀blesɛngbango kpáma, nɛɛ̀ naɛ ǹ ma tↄ́ bↄ. ");
INSERT INTO bus_vpl VALUES ("S222_37","011_22_37","2SA","22","37","37","Nɛɛ̀ ma zɛ́ yàasa kũmɛ, lɛ ma gbá tón sataro. ");
INSERT INTO bus_vpl VALUES ("S222_38","011_22_38","2SA","22","38","38","Ma pɛɛ ma ibɛɛnↄzi ma ń dúgu zↄ̃̀, mɛ́ɛ ɛara mà suro, sé kɛ̀ ma gaa ma ń dɛdɛ. ");
INSERT INTO bus_vpl VALUES ("S222_39","011_22_39","2SA","22","39","39","Ma ń wiwi dúgudugu, aↄ̃ↄe fↄ̃ wà fɛ̀ɛ dↄro, aↄ̃ lɛ̀ɛ wà gↄ̃̀ kaɛna ma gbá gĩzĩ. ");
INSERT INTO bus_vpl VALUES ("S222_40","011_22_40","2SA","22","40","40","N ma gba gbãaa ma zĩ̀ kào, ń tò ma ibɛɛnↄ mì nàɛmɛ. ");
INSERT INTO bus_vpl VALUES ("S222_41","011_22_41","2SA","22","41","41","Ń tò ma zangurinↄ kpɛɛ lì, ben ma a ibɛɛ pìnↄ kàatɛ. ");
INSERT INTO bus_vpl VALUES ("S222_42","011_22_42","2SA","22","42","42","Aↄ̃ wii lɛ̀, gbɛ̃kee e ń mì síro, aↄ̃ lɛ́ zù Diizi, èe weńlaro. ");
INSERT INTO bus_vpl VALUES ("S222_43","011_22_43","2SA","22","43","43","Ma ń kɛ́ tíkɛtikɛ lán bùsutiti bà, ma táa òḿma lán zɛ́ guu bↄtↄnga bà. ");
INSERT INTO bus_vpl VALUES ("S222_44","011_22_44","2SA","22","44","44","N ma bↄ ma gbɛ̃ kɛ̀ aↄ̃ fɛ̀ɛmaziinↄ ↄzĩ, n ma kɛ boriinↄ mìdee ũ. Borii kɛ̀ má ń dↄ̃roonↄ è zↄ̀ blemɛ, ");
INSERT INTO bus_vpl VALUES ("S222_45","011_22_45","2SA","22","45","45","bori zĩ̀tↄnↄ è na ń sàsaa ma aɛ. Tó aↄ̃ ma yã mà, aↄ̃è mì siɛmɛ. ");
INSERT INTO bus_vpl VALUES ("S222_46","011_22_46","2SA","22","46","46","Aↄ̃ kã è ga, aↄ̃è bↄ ń zɛki gbãaanↄn kↄ̃n luganao. ");
INSERT INTO bus_vpl VALUES ("S222_47","011_22_47","2SA","22","47","47","Dii kuu! Aubarikadeen ma gbɛ̀si ũ! Wà Luda ma gbɛ̀si ma mìsiri tↄ́ bↄ! ");
INSERT INTO bus_vpl VALUES ("S222_48","011_22_48","2SA","22","48","48","Luda bé è gɛ̃ɛ bomɛ, è tó boriinↄ mì siɛmɛ, ");
INSERT INTO bus_vpl VALUES ("S222_49","011_22_49","2SA","22","49","49","è tó mà piti ma ibɛɛnↄn. N ma gba gbãaa dɛ ma zangurinↄla, n ma bↄ gbɛ̃ pãsĩnↄ ↄzĩ. ");
INSERT INTO bus_vpl VALUES ("S222_50","011_22_50","2SA","22","50","50","Beee yãnzi mɛ́ n sáabu kpá boriinↄ tɛ́, mɛ́ n tↄ́ kpá, Dii. ");
INSERT INTO bus_vpl VALUES ("S222_51","011_22_51","2SA","22","51","51","Dii è zĩ̀ bíta ble kína kɛ̀ à à sɛ̀nɛ, è gbɛ̃kɛɛ kɛ kína kɛ̀ à à kànɛ, mamↄma Dauda kↄ̃n ma boriinↄo ai gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("S223_1","011_23_1","2SA","23","1","1","Yã zãa kɛ̀ Dauda òn yɛ̀. Yɛsɛ nɛ́ Dauda yãn yɛ̀, gbɛ̃ kɛ̀ Luda à gbà gbãaa yã'onamɛ. Yakubu Luda à kà kí ũ, àmbe Isarailinↄ lɛ̀dari maaa ũ. ");
INSERT INTO bus_vpl VALUES ("S223_2","011_23_2","2SA","23","2","2","Dii Nini yã dàmɛ, à yã da ma lɛ́n. ");
INSERT INTO bus_vpl VALUES ("S223_3","011_23_3","2SA","23","3","3","Isarailinↄ Luda yã ò, Isarailinↄ Gbɛ̀si bèmɛ: Tó gbɛ̃ kí blè gbɛ̃nↄnɛ a zɛ́a, tó à kí blè vĩakɛna Ludanɛ guu, ");
INSERT INTO bus_vpl VALUES ("S223_4","011_23_4","2SA","23","4","4","ègↄ̃ dɛ lán ↄfãntɛ̃ bↄɛna gupuraa bàmɛ, lán gudↄna gukɛ̃kↄ̃ana bà, lán lou kɛ̀ è tó sɛ̃̀ bↄɛ bà. ");
INSERT INTO bus_vpl VALUES ("S223_5","011_23_5","2SA","23","5","5","Ma bɛdeenↄ nna kↄ̃n Ludaoroo? À bà égↄ̃ kúmao ai gurↄ píngi. À à yã gↄ̃̀gↄ̃ píngi, à seka vĩro. Eé ma mìsina yã kɛkɛ à pàparoo? Eé pↄ́ kɛ̀ má à nii vĩ kpáma píngiroo? ");
INSERT INTO bus_vpl VALUES ("S223_6","011_23_6","2SA","23","6","6","Gbɛ̃ pãanↄↄ dɛ lán lɛ̀ bàmɛ, wè zↄ̃ wà zĩnnamɛ, è sí kũ kyáuro. ");
INSERT INTO bus_vpl VALUES ("S223_7","011_23_7","2SA","23","7","7","Gbɛ̃ kɛ̀ yezi à ↄ páa, séto àgↄ̃ gↄ̃kɛbↄ ke gò kũna, è tɛ́ sↄ̃a guu kɛ̀ à kún. ");
INSERT INTO bus_vpl VALUES ("S223_8","011_23_8","2SA","23","8","8","Dauda gↄ̃sagbãaanↄ tↄ́n yɛ̀. Takemↄ gbɛ̃ Yasↄbeamun zĩ̀kari tↄ́de gↄ̃ↄn aagↄ̃ↄnↄ gbɛ̃nsi ũ. Àmbe à sári sɛ̀ gↄ̃ↄn wàa siigↄ̃ↄnↄzi à ń zↄ̃zↄ̃o ń píngi gurↄ dↄ̃nkↄ̃ zĩ. ");
INSERT INTO bus_vpl VALUES ("S223_9","011_23_9","2SA","23","9","9","Gbɛ̃ beee gbɛra Dodai nɛ́ Ɛlɛaza, Ahoa gbɛ̃ kú zĩ̀kari gↄ̃ↄn aagↄ̃ↄ pìnↄ tɛ́ dↄ. À kú kↄ̃n Daudao gurↄↄ kɛ̀ Isarailinↄ kàkↄ̃a aↄ̃ zĩ̀ kà kↄ̃n Filisitininↄ zaa Pasadamimu. Isarailinↄ bↄru kpɛɛ, ");
INSERT INTO bus_vpl VALUES ("S223_10","011_23_10","2SA","23","10","10","àmbe à fɛ̀ɛ à Filisitininↄ dɛ̀dɛ ai à ↄↄ yã̀a à gbã̀gbã à gↄ̃̀ fɛ̃ɛda pá kũna. Dii tò à zĩ̀ blè maamaa zĩ beeea. Zĩ̀kari kpaaanↄ ɛ̀ara wà sù aↄ̃ à lè, mↄde pↄ́nↄ pitina gɛ̀nↄa yãnzimɛ. ");
INSERT INTO bus_vpl VALUES ("S223_11","011_23_11","2SA","23","11","11","Gbɛ̃ beee gbɛra Age nɛ́ Sama gusĩsĩde gbɛ̃. Kɛ̀ Filisitininↄ gãli kàkↄ̃a guu kɛ̀ blá bú kún, Isarailinↄ bàa lɛ̀ńnɛ, ");
INSERT INTO bus_vpl VALUES ("S223_12","011_23_12","2SA","23","12","12","àmbe à zɛ̀ à gì bú pì dagura. À bú pì sìḿma à Filisitininↄ dɛ̀dɛ. Dii tò à zĩ̀ blè maamaa. ");
INSERT INTO bus_vpl VALUES ("S223_13","011_23_13","2SA","23","13","13","Pↄ́kɛ̃gurↄ wↄ́rↄngↄde gↄ̃ↄn baaakurinↄ tɛ́, gↄ̃ↄn aagↄ̃ↄnↄ bↄ̀ wà gàa Dauda kiia zaa Adulamu gbɛ̀wɛɛn. Filisitininↄ gãli bùra kaɛna Rɛfaimu guzurɛn. ");
INSERT INTO bus_vpl VALUES ("S223_14","011_23_14","2SA","23","14","14","Gurↄ beeea Dauda kú sɛ̃̀tɛ pↄ̀rↄtu, Filisitini gudãkparinↄ sↄ̃ↄ kú Bɛtɛlɛmu. ");
INSERT INTO bus_vpl VALUES ("S223_15","011_23_15","2SA","23","15","15","Dauda e a bɛ í ni dɛɛ à bè: Dé bé eé gá à Bɛtɛlɛmu bĩilɛ lↄ̀gↄ'i tↄ́mɛɛ? ");
INSERT INTO bus_vpl VALUES ("S223_16","011_23_16","2SA","23","16","16","Wↄ́rↄngↄde gↄ̃ↄn aagↄ̃ↄ pìnↄ bé wà gàa wà gɛ̃̀ Filisitininↄ bùran, aↄ̃ Bɛtɛlɛmu bĩilɛ lↄ̀gↄ'i tↄ̀ wà sùo Daudanɛ. Ben èe we à mìro, à kwɛ̀ɛ Dii aɛ sa'o'i ũ. ");
INSERT INTO bus_vpl VALUES ("S223_17","011_23_17","2SA","23","17","17","À bè: O'o Dii, mɛ́ fↄ̃ mà í kɛ̀ miro. Gbɛ̃ kɛ̀ aↄ̃ gì ń wɛ̃̀ndizinↄ arumɛ. Èe we à mìro. Wↄ́rↄngↄde gↄ̃ↄn aagↄ̃ↄ pìnↄ yãkɛnan gwe. ");
INSERT INTO bus_vpl VALUES ("S223_18","011_23_18","2SA","23","18","18","Zeruya nɛ́ Abisai, Yoabu dãaro bé wↄ́rↄngↄde gↄ̃ↄn baaakurinↄ gbɛ̃nsi ũ. Àmbe à sári sɛ̀ gↄ̃ↄn wàa do kpɛ́ basↄↄroonↄzi à ń dɛdɛ, ben à tↄ́ bↄ̀ gↄ̃ↄn baaakuri pìnↄ tɛ́. ");
INSERT INTO bus_vpl VALUES ("S223_19","011_23_19","2SA","23","19","19","À tↄ́ bↄ̀ dɛ wↄ́rↄngↄde gↄ̃ↄn aagↄ̃ↄ pìnↄla, ben à gↄ̃̀ ń gbɛ̃nsi ũ, mↄde à kú wↄ́rↄngↄde tↄ́de gↄ̃ↄn aagↄ̃ↄ pìnↄ tɛ́ro. ");
INSERT INTO bus_vpl VALUES ("S223_20","011_23_20","2SA","23","20","20","Yoyada nɛ́ Bɛnaya, Kabazɛli gbɛ̃n zĩ̀kari wↄ́rↄngↄdee ũ. À yãkɛnanↄↄ pari. À Mↄabu zĩ̀kari tↄ́deenↄ dɛ̀dɛ gↄ̃ↄn plaa. À gɛ̃̀ wɛ̀ɛ guu gurↄↄ kɛ̀ lougbɛ kwɛ̀ɛ, à músu dɛ̀. ");
INSERT INTO bus_vpl VALUES ("S223_21","011_23_21","2SA","23","21","21","À Igipiti gↄ̃sagbãaa kɛ̀ sári kũna dɛ̀. À sↄ̃̀zi kↄ̃n gòo à à sári sìa à à dɛ̀o. ");
INSERT INTO bus_vpl VALUES ("S223_22","011_23_22","2SA","23","22","22","Yoyada nɛ́ Bɛnaya bé à yã pìnↄ kɛ̀, ben à tↄ́ bↄ̀ wↄ́rↄngↄde gↄ̃ↄn baaakuri pìnↄ tɛ́. ");
INSERT INTO bus_vpl VALUES ("S223_23","011_23_23","2SA","23","23","23","À tↄ́ bↄ̀ dɛ wↄ́rↄngↄde gↄ̃ↄn baaakuri pìnↄla, mↄde à kú wↄ́rↄngↄ tↄ́de gↄ̃ↄn aagↄ̃ↄ pìnↄ tɛ́ro. Ben Dauda à dìɛ a dãkparinↄ gbɛ̃nsi ũ. ");
INSERT INTO bus_vpl VALUES ("S223_24","011_23_24","2SA","23","24","24","Gↄ̃ↄn baaakuri pìnↄ tↄ́n yɛ̀: Yoabu dãaro Asahɛli, doodo nɛ́ Ɛlana Bɛtɛlɛmu gbɛ̃, ");
INSERT INTO bus_vpl VALUES ("S223_25","011_23_25","2SA","23","25","25","Arodi gbɛ̃nↄ Sama kↄ̃n Ɛlikao, ");
INSERT INTO bus_vpl VALUES ("S223_26","011_23_26","2SA","23","26","26","Paliti gbɛ̃ Ɛlɛzi, Tɛkoa gbɛ̃ Ikɛsi nɛ́ Ira, ");
INSERT INTO bus_vpl VALUES ("S223_27","011_23_27","2SA","23","27","27","Anato gbɛ̃ Abiɛza, Usa gbɛ̃ Mɛbunai, ");
INSERT INTO bus_vpl VALUES ("S223_28","011_23_28","2SA","23","28","28","Ahoa gbɛ̃ Salamↄ, Nɛtofa gbɛ̃ Marai, ");
INSERT INTO bus_vpl VALUES ("S223_29","011_23_29","2SA","23","29","29","Nɛtofa gbɛ̃ Baana nɛ́ Ɛlɛbu, Gibɛa kɛ̀ kú Bɛyãmi bùsun gbɛ̃ Ribai nɛ́ Itai, ");
INSERT INTO bus_vpl VALUES ("S223_30","011_23_30","2SA","23","30","30","Piratↄ̃ gbɛ̃ Bɛnaya, Gaasi guzurɛ gbɛ̃ Idai, ");
INSERT INTO bus_vpl VALUES ("S223_31","011_23_31","2SA","23","31","31","Araba gbɛ̃ Abialabↄ̃, Bahurimu gbɛ̃ Azamavɛ, ");
INSERT INTO bus_vpl VALUES ("S223_32","011_23_32","2SA","23","32","32","Salaboni gbɛ̃ Ɛliabu, Yasɛ̃ nɛ́nↄ, ");
INSERT INTO bus_vpl VALUES ("S223_33","011_23_33","2SA","23","33","33","gusĩsĩde gbɛ̃ Sama nɛ́ Yonatã, gusĩsĩde gbɛ̃ Saraa nɛ́ Ahiamu, ");
INSERT INTO bus_vpl VALUES ("S223_34","011_23_34","2SA","23","34","34","Maaka gbɛ̃ Asabai nɛ́ Ɛlifɛlɛti, Gilo gbɛ̃ Aitofɛli nɛ́ Ɛliamu, ");
INSERT INTO bus_vpl VALUES ("S223_35","011_23_35","2SA","23","35","35","Kamɛli gbɛ̃ Ɛzɛro, Larubu bori Parai, ");
INSERT INTO bus_vpl VALUES ("S223_36","011_23_36","2SA","23","36","36","Zoba gbɛ̃ Natã nɛ́ Igali, Gada bori Bani, ");
INSERT INTO bus_vpl VALUES ("S223_37","011_23_37","2SA","23","37","37","Amↄni bori Zɛlɛki, Bero gbɛ̃ Narai, Zeruya nɛ́ Yoabu zĩ̀kapↄnↄsɛri, ");
INSERT INTO bus_vpl VALUES ("S223_38","011_23_38","2SA","23","38","38","Yɛta gbɛ̃nↄ Ira kↄ̃n Garɛbuo ");
INSERT INTO bus_vpl VALUES ("S223_39","011_23_39","2SA","23","39","39","kↄ̃n Iti bori Uriao. Aↄ̃ píngi aↄ̃ↄ gↄ̃ↄn baaakuri awɛɛswɛɛplaamɛ. ");
INSERT INTO bus_vpl VALUES ("S224_1","011_24_1","2SA","24","1","1","Dii ɛ̀ara à pↄ fɛ̃̀ Isarailinↄzi, ben à Dauda dà à ↄ kà yãzi à bè: Ǹ gá ǹ Isarailinↄ kↄ̃n Yudanↄ naro. ");
INSERT INTO bus_vpl VALUES ("S224_2","011_24_2","2SA","24","2","2","Ben kí bè Yoabunɛ kↄ̃n zĩ̀kpɛ gbɛ̃nsi kɛ̀ aↄ̃ↄ kúonↄ à bè: À Isaraili boriinↄ bùsu para sɛna zaa Dani ai à gá pɛ́ Bɛsɛbaa, à zĩ̀karinↄ naro lɛ mà e mà ń pari lɛ́ dↄ̃. ");
INSERT INTO bus_vpl VALUES ("S224_3","011_24_3","2SA","24","3","3","Ben Yoabu bè kínɛ: Ma dii kí, Dii n Luda n gbɛ̃nↄ kↄ̃nnɛ lɛo basↄↄro ǹ wɛ́ɛ siàlɛ, mↄde ma dii kí, à kɛ̀ dia ń yezi ǹ kɛ lɛɛ? ");
INSERT INTO bus_vpl VALUES ("S224_4","011_24_4","2SA","24","4","4","Baa kↄ̃n beeeo kí yã Yoabu kↄ̃n zĩ̀kpɛ gbɛ̃nsinↄ blè, ben aↄ̃ bↄ̀ɛ kí kiia aↄ̃ gàa Isarailinↄ naro. ");
INSERT INTO bus_vpl VALUES ("S224_5","011_24_5","2SA","24","5","5","Kɛ̀ aↄ̃ bikũ̀ Yodaa, ben aↄ̃ bùra kàɛ Aroa saɛ. Wɛ́tɛ pì kú guzurɛmmɛ. Ben aↄ̃ lili ò Gada bùsun ai Yaza. ");
INSERT INTO bus_vpl VALUES ("S224_6","011_24_6","2SA","24","6","6","Aↄ̃ lili ò Giliada bùsun aↄ̃ gàa Kadɛsi, Itinↄ bùsun ai Daniyani, ben aↄ̃ gàa Sidↄ̃ kpa. ");
INSERT INTO bus_vpl VALUES ("S224_7","011_24_7","2SA","24","7","7","Aↄ̃ gàa Taya wɛ́tɛ bĩideen kↄ̃n Ivi wɛ́tɛnↄ kↄ̃n Kanaa wɛ́tɛnↄ píngi, ben aↄ̃ gàa Yudanↄ bùsu sↄↄmɛtɛ kpa ai Bɛsɛba. ");
INSERT INTO bus_vpl VALUES ("S224_8","011_24_8","2SA","24","8","8","Aↄ̃ lili ò bùsu pìn píngi. Mↄ kɛ̃ndo kↄ̃n gurↄ barooo gbɛra aↄ̃ ɛ̀ara wà sù Yerusalɛmu. ");
INSERT INTO bus_vpl VALUES ("S224_9","011_24_9","2SA","24","9","9","Ben Yoabu gbɛ̃ kɛ̀ à ń naronↄ lɛ́ ò kínɛ. Isaraili gↄ̃gbɛ̃ kɛ̀ aↄ̃ↄ fɛ̃ɛdaa dↄ̃ↄnↄ gↄ̃ↄn bↄrↄ wàa siigↄ̃. Yudanↄ sↄ̃ gↄ̃ↄn bↄrↄ wàa plaa kpɛ́ basↄↄro. ");
INSERT INTO bus_vpl VALUES ("S224_10","011_24_10","2SA","24","10","10","Gbɛ̃ pìnↄ narona gbɛra Dauda kú tóadↄ̃yãa guu, ben à bè Diinɛ: Ma durun kɛ̀ yã pì kɛna guu maamaa. Dii, mamↄma n zↄ̀bleri, ǹ ma taari kɛ̃mɛ sa, zaakɛ ma yↄ̃nkↄyã kɛ̀. ");
INSERT INTO bus_vpl VALUES ("S224_11","011_24_11","2SA","24","11","11","Ai Dauda gↄ̃ gá fɛɛ kↄngↄ, Dii yã dìdi annabi Gada, Dauda wɛ́ɛgupu'eria à bè: ");
INSERT INTO bus_vpl VALUES ("S224_12","011_24_12","2SA","24","12","12","Ǹ gá ǹ o Daudanɛ kɛ̀ ma bè, mɛ́ yã mɛ̀n aagↄ̃ kpáɛ à aɛzĩ. À yã pìnↄ doke gwa à sɛ́, mɛ́ kɛnɛ. ");
INSERT INTO bus_vpl VALUES ("S224_13","011_24_13","2SA","24","13","13","Ben Gada gàa à Dauda lè à bènɛ: Dekaa kana n bùsun wɛ̃̀ swɛɛplaaa ke n ibɛɛnↄ pɛɛnanzi ǹ bàa lɛ́ńnɛ mↄ aagↄ̃ ke gagyãa gɛ̃na n bùsun gurↄ aagↄ̃, à kpareen ń sɛ̀? Ǹ laasuu lɛ́a ǹ gwa, mɛ́ gá mà o Luda kɛ̀ ma zĩinɛ. ");
INSERT INTO bus_vpl VALUES ("S224_14","011_24_14","2SA","24","14","14","Ben Dauda bè Gadanɛ: Má kú nawɛ̃a bíta guu. Má sì wà lɛ́ɛ wà da Dii ↄzĩ, zaakɛ à wɛ̃nda vĩ maamaa. Àton tó mà lɛ́ɛ mà da gbɛ̃ntee ↄzĩro. ");
INSERT INTO bus_vpl VALUES ("S224_15","011_24_15","2SA","24","15","15","Ben Dii tò gagyãa gɛ̃̀ Isarailinↄn zaa kↄngↄ beeea ai gurↄↄ kɛ̀ à zɛ̀o. Sɛna zaa Dani ai à gàa pɛ́ Bɛsɛbaa Isarailinↄ gàga gↄ̃ↄn bↄrↄ baaagↄ̃ akuri. ");
INSERT INTO bus_vpl VALUES ("S224_16","011_24_16","2SA","24","16","16","Kɛ̀ malaika ↄ bↄ̀ à Yerusalɛmudeenↄ kaatɛ, Dii a nↄ̀sɛ lìɛ yã pì musu, ben à bè malaika kɛ̀ èe ń kaatɛɛ pìnɛ: Ǹ zɛ lɛ! Ǹ n ↄↄ sↄkpa sa. Yebusi bori Arauna blɛwɛɛgbɛ̃kiin Dii malaika pì kún. ");
INSERT INTO bus_vpl VALUES ("S224_17","011_24_17","2SA","24","17","17","Gurↄↄ kɛ̀ Dauda malaika pì è èe ń dɛdɛɛ, à bè Diinɛ: Mámbe ma durun kɛ̀ ma taari kɛ̀. Gbɛ̃ pìnↄ nɛ́ ma kpàsa sãanↄmɛ, aↄ̃ↄe yãke kɛro. Ǹ tó n pↄfɛ̃ pita mapi kↄ̃n ma de bɛdeenↄa. ");
INSERT INTO bus_vpl VALUES ("S224_18","011_24_18","2SA","24","18","18","Zĩ beeea Gada gàa à Dauda lè à bènɛ: Ǹ gá Dii gbãgbãkii bo Yebusi bori Arauna pↄ́wɛɛgbɛ̃kiia. ");
INSERT INTO bus_vpl VALUES ("S224_19","011_24_19","2SA","24","19","19","Ben Dauda gàa lán Dii à yã ò Gadanɛ nà. ");
INSERT INTO bus_vpl VALUES ("S224_20","011_24_20","2SA","24","20","20","Kɛ̀ Arauna wɛ́ɛ zù, à è kí kↄ̃n a gbɛ̃nↄↄ e mↄↄ a kiia, ben à gàa à kùɛnɛ à dàɛ a puua ");
INSERT INTO bus_vpl VALUES ("S224_21","011_24_21","2SA","24","21","21","à bè: Ma dii kí, à kɛ̀ dia nɛ́ɛ mↄↄ mamↄma n zↄ̀bleri kiia lɛɛ? Dauda wèàla à bè: Ma mↄ mà n pↄ́wɛɛgbɛ̃ki lúmma mà Dii gbãgbãkii bommɛ, lɛ gagyãa pì e à go gbɛ̃nↄa yãnzi. ");
INSERT INTO bus_vpl VALUES ("S224_22","011_24_22","2SA","24","22","22","Ben Arauna bè Daudanɛ: Ma dii kí, ǹ pↄ́ kɛ̀ kɛ̀nnɛ maaa sɛ́ ǹ saa oo. Ǹ zùnↄ gwa sa'opↄ ũ. Ǹ pↄ́wɛɛgbɛ̃gonↄ kↄ̃n gbóngonↄ sɛ́ɛ yàka ũ. ");
INSERT INTO bus_vpl VALUES ("S224_23","011_24_23","2SA","24","23","23","Kí, ma n gbaa píngi. Arauna ɛ̀ara à bènɛ dↄ: Dii n Luda sínnɛ. ");
INSERT INTO bus_vpl VALUES ("S224_24","011_24_24","2SA","24","24","24","Ben kí bènɛ: Auo! Mɛ́ lúmmamɛ, mɛ́ à fĩa bonnɛ. Mɛ́ saa o Dii ma Ludaa pã fĩabosairo. Ben à pↄ́wɛɛgbɛ̃kii pì kↄ̃n zùnↄ lùa kondogi baplaa akuri. ");
INSERT INTO bus_vpl VALUES ("S224_25","011_24_25","2SA","24","25","25","Ben à Dii gbãgbãkii bò gwe à sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ òa kↄ̃n kɛnnakↄ̃o sa'opↄnↄ. Dii sìnɛ à bùsu yã musu, ben gagyãa pì zɛ̀. ");
INSERT INTO bus_vpl VALUES ("K11_1","012_1_1","1KI","1","1","1","Gurↄↄ kɛ̀ kí Dauda zi kũ̀ kótokoto, baa tó wà bisanↄ kùàla, ĩa ègↄ̃ kpɛɛ à dɛɛmɛ. ");
INSERT INTO bus_vpl VALUES ("K11_2","012_1_2","1KI","1","2","2","Ben à ìbanↄ bènɛ: Wa dii kí, ǹ tó wà nↄkparɛ wɛtɛnnɛ, àgↄ̃ zĩi kɛɛnnɛ àgↄ̃ n gwaa, àgↄ̃ daɛɛ n saɛ lɛ ĩa tón n dɛ dↄro. ");
INSERT INTO bus_vpl VALUES ("K11_3","012_1_3","1KI","1","3","3","Ben wà gàa wà kpáɛ kɛ̀ nↄkparɛ maaazi Isarailinↄ bùsun píngi, ben wà bↄ̀ Sunɛmu nↄgbɛ̃ Abisagaa, wà à sɛ̀ wà sùo kínanɛ. ");
INSERT INTO bus_vpl VALUES ("K11_4","012_1_4","1KI","1","4","4","Nↄkparɛ pì nɛ́ nↄ maaamɛ. Ègↄ̃ kína gwaa àgↄ̃ zĩi kɛɛnɛ, mↄde kí à dↄ̃ nↄgbɛ̃ ũro. ");
INSERT INTO bus_vpl VALUES ("K11_5","012_1_5","1KI","1","5","5","Dauda naↄ̃ Agi nɛ́ Adonia a zĩnda dìɛ kɛ̀ a ka, ben à bè ámbe é kí ble. Ben à sↄ̃goronↄ sɛ̀ kↄ̃n sↄ̃deenↄ kↄ̃n gↄ̃gbɛ̃ gↄ̃ↄn baplaa akuri kɛ̀ aↄ̃égↄ̃ bàa lɛɛ wàgↄ̃ tɛ́arɛ aɛnↄ. ");
INSERT INTO bus_vpl VALUES ("K11_6","012_1_6","1KI","1","6","6","À dee e kpãkɛ̃zi ziki à be, à kɛ̀ dia nɛ́ɛ kɛɛ lɛɛro. Àpi sↄ̃ nɛ́ gↄ̃ maaamɛ. Abusalomu bé à yↄ̃ mì à kpàa. ");
INSERT INTO bus_vpl VALUES ("K11_7","012_1_7","1KI","1","7","7","Ben à lɛdolɛ kɛ̀ kↄ̃n Zeruya nɛ́ Yoabuo kↄ̃n sa'ori Abiatao, ben aↄ̃ zɛ̀o. ");
INSERT INTO bus_vpl VALUES ("K11_8","012_1_8","1KI","1","8","8","Mↄde sa'ori Zadↄki kↄ̃n Yoyada nɛ́ Bɛnayao kↄ̃n annabi Natão kↄ̃n Simɛio kↄ̃n Dauda gbɛ̃nnanↄ kↄ̃n à dogarinↄↄ e zɛoro. ");
INSERT INTO bus_vpl VALUES ("K11_9","012_1_9","1KI","1","9","9","Adonia saa ò kↄ̃n sãanↄ kↄ̃n zùnↄ kↄ̃n zùnɛ mɛ̀kpananↄ Mlɛ̃̀gbɛ kɛ̀ kú Ɛnlogɛli saɛa. À a dãaro kínɛnↄ sìsi ń píngi kↄ̃n Yuda kɛ̀ aↄ̃ↄ dɛ kína ìba ũunↄ ń píngi. ");
INSERT INTO bus_vpl VALUES ("K11_10","012_1_10","1KI","1","10","10","Èe annabi Natã sísiro ke Bɛnaya ke Dauda dogarinↄ ke a zĩnda dãaro Sulemanu. ");
INSERT INTO bus_vpl VALUES ("K11_11","012_1_11","1KI","1","11","11","Ben Natã gàa à Sulemanu da Basɛba là à bè: Nɛ́ɛ ma kɛ̀ Agi nɛ́ Adonia kí blè wa dii kí Dauda dↄ̃na sairoo? ");
INSERT INTO bus_vpl VALUES ("K11_12","012_1_12","1KI","1","12","12","Tↄ̀, ǹ tó mà lɛ́ damma sa lán nɛ́ kɛ nà, ǹ n zĩnda mì sí kↄ̃n n nɛ́ Sulemanu pↄ́o. ");
INSERT INTO bus_vpl VALUES ("K11_13","012_1_13","1KI","1","13","13","Ǹ fɛɛ ǹ gá kí Dauda le ǹ benɛ, kɛ̀ à la dànnɛ yã à bè n nɛ́ Sulemanu bé eé kí ble a gɛ̃ɛ ũ à vɛ̃ɛ a kpatan sↄ̃ nɛ́? À kɛ̀ dia Adonia gↄ̃̀ kí ũu? ");
INSERT INTO bus_vpl VALUES ("K11_14","012_1_14","1KI","1","14","14","Gurↄↄ kɛ̀ ń kpɛ́ nɛ́ɛ yã oonɛ, mɛ́ gɛ̃ mà yã'i kaara se. ");
INSERT INTO bus_vpl VALUES ("K11_15","012_1_15","1KI","1","15","15","Ben Basɛba gàa à kína lè à kpɛ́n, guu kɛ̀ Sunɛmu nↄgbɛ̃ Abisaga e à gwaan. Kí sↄ̃ zi kũ̀. ");
INSERT INTO bus_vpl VALUES ("K11_16","012_1_16","1KI","1","16","16","Basɛba kùɛ à mì pɛ̀ɛnɛ, ben kí à là à bè: Bↄ́n ń yezi? ");
INSERT INTO bus_vpl VALUES ("K11_17","012_1_17","1KI","1","17","17","À wèàla à bè: Ma dii, ḿbe ń sì mamↄma n zↄ̀blerinɛ kↄ̃n Dii n Luda tↄ́o, n bè ma nɛ́ Sulemanu bé eé kí ble n gɛ̃ɛ ũ à vɛ̃ɛ n kpatan. ");
INSERT INTO bus_vpl VALUES ("K11_18","012_1_18","1KI","1","18","18","Tia sↄ̃ ma dii kí, Adonia bé à kɛ̀ kí ũ, bensↄ̃ ń à yã dↄ̃ro. ");
INSERT INTO bus_vpl VALUES ("K11_19","012_1_19","1KI","1","19","19","À saa ò kↄ̃n zùnↄ kↄ̃n zùnɛ mɛ̀kpananↄ kↄ̃n sãanↄ paripari, à n nɛ́nↄ sìsi ń píngi kↄ̃n sa'ori Abiatao kↄ̃n zĩ̀kpɛ dↄn'aɛde Yoabuo, mↄde èe n zↄ̀bleri Sulemanu sísiro. ");
INSERT INTO bus_vpl VALUES ("K11_20","012_1_20","1KI","1","20","20","Ma dii kí, ḿbe Isarailinↄ píngi sↄ̃kpanzi, wà ma tó dé bé eé kɛ kí ũ n gbɛ̀n. ");
INSERT INTO bus_vpl VALUES ("K11_21","012_1_21","1KI","1","21","21","Ma dii kí, tó n gaa n dezinↄ kúkiia, mapi kↄ̃n ma nɛ́ Sulemanuo, weégↄ̃ wa gwaa taarideenↄ ũmɛ. ");
INSERT INTO bus_vpl VALUES ("K11_22","012_1_22","1KI","1","22","22","Kɛ̀ à kpɛ́ èe yã oo kↄ̃n kínao, ben annabi Natã mↄ̀. ");
INSERT INTO bus_vpl VALUES ("K11_23","012_1_23","1KI","1","23","23","Wà ò kínɛ kɛ̀ annabi Natã kú kɛ̀. Ben Natã gɛ̃̀ à kùɛ kínanɛ à dàɛ a puua ");
INSERT INTO bus_vpl VALUES ("K11_24","012_1_24","1KI","1","24","24","à bè: Ma dii kí, ḿbe n bè Adonia kɛ kí ũ à vɛ̃ɛ kpatan n gɛ̃ɛ ũↄ́? ");
INSERT INTO bus_vpl VALUES ("K11_25","012_1_25","1KI","1","25","25","Zaakɛ à gàa à saa ò gbã̀a kↄ̃n zùnↄ kↄ̃n zùnɛ mɛ̀kpananↄ kↄ̃n sãanↄ paripari. À n nɛ́nↄ sìsi ń píngi kↄ̃n n zĩ̀kpɛ dↄn'aɛdeeo kↄ̃n sa'ori Abiatao. Aↄ̃ↄe pↄ́ bleeo, wèe í mii tia, aↄ̃ↄe bee: Luda kí Adonia dↄ̃ kↄ̃n aafiao! ");
INSERT INTO bus_vpl VALUES ("K11_26","012_1_26","1KI","1","26","26","Mↄde èe mamↄma n zↄ̀bleri sísiro ke sa'ori Zadↄki ke Yoyada nɛ́ Bɛnaya ke n zↄ̀bleri Sulemanu. ");
INSERT INTO bus_vpl VALUES ("K11_27","012_1_27","1KI","1","27","27","Ma dii kí, ase lɛ n kɛ̀ lɛɛ, ben n gi gbɛ̃ kɛ̀ eé vɛ̃ɛ kpatan n gɛ̃ɛ ũu o wamↄwa n zↄ̀blerinↄnɛziↄ́? ");
INSERT INTO bus_vpl VALUES ("K11_28","012_1_28","1KI","1","28","28","Ben kí Dauda bè: À Basɛba sísimɛ. Kɛ̀ Basɛba mↄ̀ à gɛ̃̀, à mↄ̀ à zɛ̀ kí aɛ. ");
INSERT INTO bus_vpl VALUES ("K11_29","012_1_29","1KI","1","29","29","Ben kína la dànɛ à bè: Kↄ̃n Dii kuunao! Àmↄ kɛ̀ à ma bↄ nawɛ̃a píngi guu. ");
INSERT INTO bus_vpl VALUES ("K11_30","012_1_30","1KI","1","30","30","Ladana kɛ̀ má kɛ̀nnɛ kↄ̃n Dii Isarailinↄ Luda tↄ́o, ma bè n nɛ́ Sulemanu bé eé kí ble ma gbɛ̀n à vɛ̃ɛ kpatan ma gɛ̃ɛ ũ, mɛ́ papa gbã̀a kãnkãmmɛ. ");
INSERT INTO bus_vpl VALUES ("K11_31","012_1_31","1KI","1","31","31","Ben Basɛba kùɛ à mì pɛ̀ɛ tↄↄtɛ kínanɛ à bè: Ma dii kí Dauda, Luda n dↄ̃ kↄ̃n aafiao gurↄ píngi! ");
INSERT INTO bus_vpl VALUES ("K11_32","012_1_32","1KI","1","32","32","Ben kí Dauda bè: À sa'ori Zadↄki sísimɛ kↄ̃n annabi Natão kↄ̃n Yoyada nɛ́ Bɛnayao. Kɛ̀ aↄ̃ mↄ̀ kína kiia, ");
INSERT INTO bus_vpl VALUES ("K11_33","012_1_33","1KI","1","33","33","à bèńnɛ: À ma ìbanↄ kakↄ̃a é ma nɛ́ Sulemanu sɛ́ à à di ma bãagãsↄ̃a, é gáo Giↄ̃. ");
INSERT INTO bus_vpl VALUES ("K11_34","012_1_34","1KI","1","34","34","Gwen sa'ori Zadↄki kↄ̃n annabi Natão é nↄ́si kúa aↄ̃ à ká Isarailinↄ kí ũ, é kuru pɛ́ à wii lɛ́ à be: Luda kí Sulemanu dↄ̃ kↄ̃n aafiao! ");
INSERT INTO bus_vpl VALUES ("K11_35","012_1_35","1KI","1","35","35","Beee gbɛra é suo, eé vɛ̃ɛ kpatan àgↄ̃ kí blee ma gbɛ̀n. Àmbe má dìɛ Isarailinↄ kↄ̃n Yudanↄ dↄn'aɛdee ũ. ");
INSERT INTO bus_vpl VALUES ("K11_36","012_1_36","1KI","1","36","36","Ben Yoyada nɛ́ Bɛnaya bè kínanɛ: À kɛ lɛ! Dii n Luda n lɛ́gbɛ sí ma dii kí! ");
INSERT INTO bus_vpl VALUES ("K11_37","012_1_37","1KI","1","37","37","Lán Dii kúnyo nà ma dii kí, àgↄ̃ kú kↄ̃n Sulemanuo lɛ, à à kíkɛ sɛ́ lezĩ dɛ n pↄ́la se. ");
INSERT INTO bus_vpl VALUES ("K11_38","012_1_38","1KI","1","38","38","Ben sa'ori Zadↄki kↄ̃n annabi Natão kↄ̃n Yoyada nɛ́ Bɛnayao kↄ̃n dogarinↄ gàa wà Sulemanu dì kí Dauda bãagãsↄ̃a, aↄ̃ gàa zɛnɛ Giↄ̃. ");
INSERT INTO bus_vpl VALUES ("K11_39","012_1_39","1KI","1","39","39","Ben sa'ori Zadↄki nↄ́si tùu sɛ̀ Dii kpɛ́n, à nↄ́si pì kù Sulemanua. Ben wà kuu pɛ̀, baade píngi wii lɛ̀ wà bè: Luda kí Sulemanu dↄ̃ kↄ̃n aafiao! ");
INSERT INTO bus_vpl VALUES ("K11_40","012_1_40","1KI","1","40","40","Ben baade píngi bↄ̀ wà tɛ̀zi, aↄ̃ↄe suu aↄ̃ↄe gaasia pɛɛ, aↄ̃ↄe pↄnnaa kɛɛ maamaa ai tↄↄtɛ nìgã kĩi kɛ̀ aↄ̃ↄe kɛɛ pì yãnzi. ");
INSERT INTO bus_vpl VALUES ("K11_41","012_1_41","1KI","1","41","41","Kɛ̀ Adonia kↄ̃n gbɛ̃ kɛ̀ à ń sisinↄ pↄ́ blè wà yã̀a, aↄ̃ↄe mↄↄ fɛɛ, ben aↄ̃ kĩi pì mà. Kɛ̀ Yoabu kuru'ↄ pì mà, ben à bè: Bↄ́ zↄka bé à dↄ wɛ́tɛ guu lɛɛ? ");
INSERT INTO bus_vpl VALUES ("K11_42","012_1_42","1KI","1","42","42","Èe yã pì o à yã̀aro, ben sa'ori Abiata nɛ́ Yonatã gàa káo gↄ̃ↄ. Ben Adonia bè: Ǹ gɛ̃. Gbɛ̃ bɛ̀ɛdeen n ũ, mɛ́ɛ sii baaru nnaan n suo. ");
INSERT INTO bus_vpl VALUES ("K11_43","012_1_43","1KI","1","43","43","Ben Yonatã bè Adonianɛ: Lɛnlo! Wa dii kí Dauda Sulemanu kpà kpatan. ");
INSERT INTO bus_vpl VALUES ("K11_44","012_1_44","1KI","1","44","44","À sa'ori Zadↄki kↄ̃n annabi Natão kↄ̃n Yoyada nɛ́ Bɛnayao kↄ̃n a dogarinↄ gbàrɛ aↄ̃ gáo, ben aↄ̃ gàa wà à dì kína bãagãsↄ̃a. ");
INSERT INTO bus_vpl VALUES ("K11_45","012_1_45","1KI","1","45","45","Ben sa'ori Zadↄki kↄ̃n annabi Natão nↄ́si kùa aↄ̃ à kà kí ũ zaa Giↄ̃. Kɛ̀ aↄ̃ bↄ̀ gwe, aↄ̃ sù kↄ̃n pↄnnakɛnao, ben wɛ́tɛ lògo. Kĩi kɛ̀ á màn gwe. ");
INSERT INTO bus_vpl VALUES ("K11_46","012_1_46","1KI","1","46","46","Baa diamɛ Sulemanu vɛ̃̀ɛ kpatan kↄ̀. ");
INSERT INTO bus_vpl VALUES ("K11_47","012_1_47","1KI","1","47","47","Ben wa dii kí Dauda ìbanↄ mↄ̀ wà ì kpàa se, aↄ̃ bè Luda Sulemanu tↄ́ bↄ dɛ à pↄ́la! Luda à kíkɛɛ gba gbãaa dɛ à pↄ́la! Ben Dauda mì nàɛ à dↄnzi kɛ̀ Diinɛ a daɛbↄa ");
INSERT INTO bus_vpl VALUES ("K11_48","012_1_48","1KI","1","48","48","à bè: Wà Dii Isarailinↄ Luda sáabu kpá, kɛ̀ à tò ma wɛ́ɛ sì ma gɛ̃ɛ kana kí ũlɛ gbã̀a. ");
INSERT INTO bus_vpl VALUES ("K11_49","012_1_49","1KI","1","49","49","Kɛ̀ gbɛ̃ kɛ̀ Adonia ń sisinↄↄ mà lɛ, ben aↄ̃ làakari fɛ̀ɛ, baade a zɛ́ kũ̀. ");
INSERT INTO bus_vpl VALUES ("K11_50","012_1_50","1KI","1","50","50","Kɛ̀ Adonia e vĩa kɛɛ Sulemanunɛ yãnzi, ben à fɛ̀ɛ à gàa à nà Dii gbãgbãkiizi, à a koba kũ̀. ");
INSERT INTO bus_vpl VALUES ("K11_51","012_1_51","1KI","1","51","51","Ben wà bè Sulemanunɛ: Adonia e vĩa kɛɛnnɛ, à gàa à nà Dii gbãgbãkiizi à à koba kũna, èe bee ǹ la da amↄa n zↄ̀blerinɛ gbã̀a, kɛ̀ nɛ́ a dɛro. ");
INSERT INTO bus_vpl VALUES ("K11_52","012_1_52","1KI","1","52","52","Ben Sulemanu bè: Tó à a zĩnda kũna dↄ̃ gbɛ̃ maaa ũ, baa à mìkã wɛ́n do eé lɛ́ɛ tↄↄtɛro. Tó wà gà wà à zaa ke èa sↄ̃, à gàmɛ. ");
INSERT INTO bus_vpl VALUES ("K11_53","012_1_53","1KI","1","53","53","Ben kí Sulemanu gbɛ̃nↄ zĩ̀, aↄ̃ Adonia gò Dii gbãgbãkiia. Kɛ̀ Adonia pì mↄ̀ à kùɛnɛ, ben Sulemanu bènɛ: Ǹ tá n bɛ. ");
INSERT INTO bus_vpl VALUES ("K12_1","012_2_1","1KI","2","1","1","Kɛ̀ Dauda gagurↄↄ kà kĩi, à lɛ́ dìɛ a nɛ́ Sulemanunɛ à bè: ");
INSERT INTO bus_vpl VALUES ("K12_2","012_2_2","1KI","2","2","2","Mɛ́ɛ gaa anduna gbɛ̃ píngi gákiia. Ǹ zɛ gbãa, nɛ́ n zĩnda ↄdↄa kɛ̀ nɛ́gↄ̃gbɛ̃n n ũ! ");
INSERT INTO bus_vpl VALUES ("K12_3","012_2_3","1KI","2","3","3","Ǹgaegↄ̃ Dii n Luda yãnↄ kũna, nɛ́gↄ̃ tɛ́ à zɛ́zi, nɛ́gↄ̃ à ↄdↄkii gwaa, nɛ́gↄ̃ à yãdiɛnanↄ kũna kↄ̃n à dokayãnↄ kↄ̃n à yã'onnɛnanↄ, lán à kú Musa doka takadan nà, yã kɛ̀ nɛ́ɛ kɛɛ píngi égↄ̃ bↄↄ maa, n tá píngi égↄ̃ nna. ");
INSERT INTO bus_vpl VALUES ("K12_4","012_2_4","1KI","2","4","4","Lɛn Dii é yã kɛ̀ à òmɛɛ papa lɛ à bè, tó ma nɛ́nↄ ń zĩnda kũna dↄ̃ bensↄ̃ aↄ̃ↄ tɛ́ ma zɛ́zi kↄ̃n nↄ̀sɛo do kↄ̃n pↄyezinao píngi, ma boriinↄ égↄ̃ vɛ̃ɛna Isarailinↄ kpatan gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("K12_5","012_2_5","1KI","2","5","5","Ń yã kɛ̀ Zeruya nɛ́ Yoabu kɛ̀mɛɛ dↄ̃, lán à Isaraili zĩ̀kpɛ dↄn'aɛde gↄ̃ↄn plaaanↄ dɛ̀dɛ nà, Nɛɛ nɛ́ Abana kↄ̃n Yɛta nɛ́ Amasao. À gbɛ̃ pìnↄ dɛ̀dɛ, èe kɛ sↄ̃ zĩ̀ gurↄnlo. Aↄ̃ aru gↄ̃̀ à musu, à kù à asaaa kↄ̃n à kyateenↄ. ");
INSERT INTO bus_vpl VALUES ("K12_6","012_2_6","1KI","2","6","6","Ǹ yã kɛnɛ n ↄ̃ndↄ̃na lɛ́n. Ǹton tó à mìkã pura kũ gbasa à daɛ miran yĩi guuro. ");
INSERT INTO bus_vpl VALUES ("K12_7","012_2_7","1KI","2","7","7","Ǹ gbɛ̃kɛɛ kɛ Giliada gbɛ̃ Bazilai nɛ́gↄ̃gbɛ̃nↄnɛ. Ǹ ń diɛ gbɛ̃ kɛ̀ égↄ̃ pↄ́ blee lɛdoonↄ tɛ́, zaakɛ aↄ̃mbe aↄ̃ zɛ̀mao gurↄↄ kɛ̀ mɛ́ɛ bàa sii n vĩ̀i Abusalomunɛ. ");
INSERT INTO bus_vpl VALUES ("K12_8","012_2_8","1KI","2","8","8","Bɛyãmi bori Gera nɛ́ Simɛi, Bahurimu gbɛ̃ kúnyo dↄ. À ma ka pãsĩpãsĩ gurↄↄ kɛ̀ mɛ́ɛ gaa Manaimu. Kɛ̀ à mↄ̀ à ma le Yodazi, má sìnɛ kↄ̃n Diio kɛ̀ mɛ́ à dɛro. ");
INSERT INTO bus_vpl VALUES ("K12_9","012_2_9","1KI","2","9","9","Baa kↄ̃n beeeo ǹton à tó pã wɛ́ɛtãmma sairo. Ń ↄ̃ndↄ̃, ń dↄ̃ dian nɛ́ kɛnɛ nà à ga zɛ́gbãn à gɛ̃ miran. ");
INSERT INTO bus_vpl VALUES ("K12_10","012_2_10","1KI","2","10","10","Ben Dauda gà. Yerusalɛmu fáandi kɛ̀ wà à vĩ̀in wè be Dauda wɛ́tɛ. ");
INSERT INTO bus_vpl VALUES ("K12_11","012_2_11","1KI","2","11","11","À kɛ̀ Isarailinↄ kí ũ ai wɛ̃̀ baplaa, Ɛblↄnu wɛ̃̀ swɛɛplaa, Yerusalɛmu wɛ̃̀ baaakuri awɛɛ'aagↄ̃. ");
INSERT INTO bus_vpl VALUES ("K12_12","012_2_12","1KI","2","12","12","Sulemanu vɛ̃̀ɛ a de gbɛ̀n bensↄ̃ à kpata kãsãa pɛɛna. ");
INSERT INTO bus_vpl VALUES ("K12_13","012_2_13","1KI","2","13","13","Agi nɛ́ Adonia gàa à Sulemanu da Basɛba lè, ben Basɛba à là à bè: Aafian n mↄↄ́? À wèàla à bè: Aafiamɛ! ");
INSERT INTO bus_vpl VALUES ("K12_14","012_2_14","1KI","2","14","14","Adonia ɛ̀ara à bè: Má yã vĩ mà onnɛ. Basɛba bè: Ǹ o! ");
INSERT INTO bus_vpl VALUES ("K12_15","012_2_15","1KI","2","15","15","Ben Adonia bè: Ń dↄ̃ kɛ̀ kpata nɛ́ ma pↄ́mɛ yã. Isarailinↄ wɛ́ɛ kúma ń píngi mà kɛ ń kí ũ, ben yã lìɛ, ma dãaro bé à kpata blè, zaakɛ Dii bé à à kà. ");
INSERT INTO bus_vpl VALUES ("K12_16","012_2_16","1KI","2","16","16","Tia sa yã mɛ̀n doon mɛ́ɛ wɛ́ɛ kɛɛmma, ǹton gí kɛmɛziro. Basɛba bè: Ǹ o! ");
INSERT INTO bus_vpl VALUES ("K12_17","012_2_17","1KI","2","17","17","Ben à bè: Ǹ wɛ́ɛ kɛmɛ kí Sulemanua à Sunɛmu nↄgbɛ̃ Abisaga kpáma nↄↄ ũ, zaakɛ eé gíonnɛro. ");
INSERT INTO bus_vpl VALUES ("K12_18","012_2_18","1KI","2","18","18","Basɛba bènɛ: Tↄ̀, mɛ́ onɛnnɛ. ");
INSERT INTO bus_vpl VALUES ("K12_19","012_2_19","1KI","2","19","19","Kɛ̀ Basɛba gàa à kí Sulemanu lè Adonia yã pì musu, ben kína pì fɛ̀ɛ à gàa à dààlɛ à kùɛnɛ, ben à ɛ̀ara à mↄ̀ à vɛ̃̀ɛ a kíblekitan. Ben wà mↄ̀ Basɛbanɛ kↄ̃n kíblekita pãndeo, ben à vɛ̃̀ɛ kí ↄplaazi. ");
INSERT INTO bus_vpl VALUES ("K12_20","012_2_20","1KI","2","20","20","Basɛba bè: Pↄ́ken má yezi mà wɛ́ɛ kɛmma, ǹton ma tɛ̃ro. Ben kí bè: Ǹ wɛ́ɛ kɛ Naa, mɛ́ n tɛ̃ro. ");
INSERT INTO bus_vpl VALUES ("K12_21","012_2_21","1KI","2","21","21","Ben Basɛba bè: Ǹ tó wà Sunɛmu nↄgbɛ̃ Abisaga kpá n vĩ̀i Adoniaa à à sɛ́ nↄↄ ũ. ");
INSERT INTO bus_vpl VALUES ("K12_22","012_2_22","1KI","2","22","22","Ben kí Sulemanu a da là à bè: Bↄ́yãnzin nɛ́ɛ Sunɛmu nↄgbɛ̃ Abisaga wɛ́ɛ kɛɛ Adonianɛzi? Ǹ kpata wɛ́ɛ kɛnɛ gↄ̃ↄmɛee! Zaakɛ ma vĩ̀imɛ. Nɛ́ɛ kpata wɛ́ɛ kɛɛnɛ kↄ̃n sa'ori Abiatao kↄ̃n Zeruya nɛ́ Yoabuomɛ. ");
INSERT INTO bus_vpl VALUES ("K12_23","012_2_23","1KI","2","23","23","Ben kí Sulemanu sì kↄ̃n Diio à bè: Tó Adonia e kora a wɛ̃̀ndizi yã kɛ̀ à wɛ́ɛ kɛ̀ kɛ̀ yãnziro, Luda yã kɛmɛ pãsĩpãsĩ. ");
INSERT INTO bus_vpl VALUES ("K12_24","012_2_24","1KI","2","24","24","Zaakɛ Dii ma ka kpatan, à ma diɛ ma de Dauda gɛ̃ɛ ũ, à ma borii gbà gbãaa lán à à lɛ́ gbɛ̃̀ nà, má sì kↄ̃n Diio Adonia é ga gbã̀amɛ. ");
INSERT INTO bus_vpl VALUES ("K12_25","012_2_25","1KI","2","25","25","Ben kí Sulemanu Yoyada nɛ́ Bɛnaya dà, à gàa à Adonia lɛ̀ à dɛ̀. ");
INSERT INTO bus_vpl VALUES ("K12_26","012_2_26","1KI","2","26","26","Kína bè sa'ori Abiatanɛ: Ǹ ɛara ǹ tá n guun Anato. À kↄ̃ sìo ǹ gamɛ, mↄde mɛ́ n dɛ tiaro, zaakɛ ḿbe n Dii Luda àkpati sɛ̀ n dↄo ma de Daudanɛ aɛ, bensↄ̃ n zɛo à nawɛ̃a píngi guu. ");
INSERT INTO bus_vpl VALUES ("K12_27","012_2_27","1KI","2","27","27","Lɛn Sulemanu pɛ̀ Abiataa lɛ, à à bↄ̀ Dii gbãgbãna zĩin, lɛ yã kɛ̀ Dii ò Ɛli bɛdeenↄ musu zaa Silo e à papa yãnzi. ");
INSERT INTO bus_vpl VALUES ("K12_28","012_2_28","1KI","2","28","28","Kɛ̀ Yoabu yã pì baaru mà, ben à bàa sì à gàa Dii bisakuta kiia, à nà Dii gbãgbãkiizi à à koba kũ̀. Yoabu zɛ̀ kↄ̃n Adoniaomɛ yã, mↄde èe zɛ kↄ̃n Abusalomuoro. ");
INSERT INTO bus_vpl VALUES ("K12_29","012_2_29","1KI","2","29","29","Wà ò kí Sulemanunɛ kɛ̀ Yoabu bàa lɛ̀ à gàa Dii bisakuta kiia, à kú sa'okii pì saɛ, ben Sulemanu bè Yoyada nɛ́ Bɛnayanɛ à gá à yãao gwe. ");
INSERT INTO bus_vpl VALUES ("K12_30","012_2_30","1KI","2","30","30","Kɛ̀ Bɛnaya kà Dii bisakuta kiia, à bènɛ: Kína bè ǹ bↄ gwe! Ben Yoabu bè: Auo! Gura kɛ̀n mɛ́ gan. Ben Bɛnaya gbɛ̃nↄ zĩ̀ kínaa à bè: Lán Yoabu wèmala nàn yɛ̀. ");
INSERT INTO bus_vpl VALUES ("K12_31","012_2_31","1KI","2","31","31","Ben kína bènɛ: Ǹ kɛnɛ lán à ò nà. Ǹ à dɛ, nɛ́ à vĩi, lɛ à gbɛ̃dɛna pã yã tón wí mapi kↄ̃n ma de bɛdeenↄ musuro. ");
INSERT INTO bus_vpl VALUES ("K12_32","012_2_32","1KI","2","32","32","Dii é tó à gbɛ̃dɛna yã wí à musu, zaakɛ à lɛ̀ɛ taarisaide gↄ̃ↄn plaaa kɛ̀ aↄ̃ maaa dɛalaanↄa. À Nɛɛ nɛ́ Abana, Isaraili zĩ̀kpɛ dↄn'aɛde kↄ̃n Yɛta nɛ́ Amasa, Yuda zĩ̀kpɛ dↄn'aɛdeeo dɛ̀dɛ ma de lɛ́ saɛ. ");
INSERT INTO bus_vpl VALUES ("K12_33","012_2_33","1KI","2","33","33","Aↄ̃ dɛna yã égↄ̃ wii Yoabu kↄ̃n a boriinↄ musu gurↄ píngi, mↄde Dii égↄ̃ Dauda kↄ̃n a boriinↄ kↄ̃n a uao kↄ̃n a kpatao gbaa aafia gurↄ sãnda píngia. ");
INSERT INTO bus_vpl VALUES ("K12_34","012_2_34","1KI","2","34","34","Ben Yoyada nɛ́ Bɛnaya gàa à Yoabu lɛ̀ à dɛ̀, ben wà à vĩ̀i a bɛ zaa gbáan. ");
INSERT INTO bus_vpl VALUES ("K12_35","012_2_35","1KI","2","35","35","Ben kína Yoyada nɛ́ Bɛnaya dìɛ zĩ̀kpɛ dↄn'aɛdee ũ Yoabu gbɛ̀n, sa'ori Zadↄki sↄ̃, Abiata gbɛ̀n. ");
INSERT INTO bus_vpl VALUES ("K12_36","012_2_36","1KI","2","36","36","Kína gbɛ̃nↄ zĩ̀ aↄ̃ Simɛi sìsi, ben à bènɛ: Ǹ bɛɛ bo Yerusalɛmu kɛ̀ ǹgↄ̃ kún. Ǹton bↄ bɛa kɛ̀ ǹ gá gukearo. ");
INSERT INTO bus_vpl VALUES ("K12_37","012_2_37","1KI","2","37","37","Ǹgↄ̃ dↄ̃ sãnsãn zĩ kɛ̀ n bikũ̀ Kidironua, n gan gwe. Mↄde ḿbe n n zĩnda dɛ̀. ");
INSERT INTO bus_vpl VALUES ("K12_38","012_2_38","1KI","2","38","38","Ben Simɛi bè kínɛ: Yã maaan ń ò ma dii kí. Mamↄma n zↄ̀bleri mɛ́ kɛ lán ń ò nà. Ben à kú Yerusalɛmu lɛ ai à gì kɛ̀. ");
INSERT INTO bus_vpl VALUES ("K12_39","012_2_39","1KI","2","39","39","Wɛ̃̀ aagↄ̃ↄ gbɛra Simɛi zↄ̀ gↄ̃ↄn plaaanↄ bàa sì wà tà Maaka nɛ́ Akisi, Gata kína kiia, ben wà bè Simɛinɛ: N zↄ̀nↄↄ kú Gata. ");
INSERT INTO bus_vpl VALUES ("K12_40","012_2_40","1KI","2","40","40","Ben Simɛi fɛ̀ɛ à gàari yì a zaakinɛ, à gàa Akisi kiia Gata a zↄ̀ pìnↄ wɛtɛ. Kɛ̀ à ń é, ben à ń sɛ́ɛ Gata à sùńyo. ");
INSERT INTO bus_vpl VALUES ("K12_41","012_2_41","1KI","2","41","41","Ben wà ò Sulemanunɛ, Simɛi bↄ̀ Yerusalɛmu à gàa Gata à ɛ̀ara à sù. ");
INSERT INTO bus_vpl VALUES ("K12_42","012_2_42","1KI","2","42","42","Ben kína gbɛ̃nↄ zĩ̀ aↄ̃ Simɛi sìsiare, ben à bènɛ: Má tò ń sì kↄ̃n Diio, ben ma lɛ́ dàmma ma bè, zĩ kɛ̀ n bↄ kɛ̀ n gaa gukea, ǹgↄ̃ dↄ̃ kɛ̀ n gamɛ. Ben ń bèmɛ, yã maaamɛ, ń mà. ");
INSERT INTO bus_vpl VALUES ("K12_43","012_2_43","1KI","2","43","43","Bↄ́yãnzin n bↄ ladana kɛ̀ ń kɛ̀ kↄ̃n Dii tↄ́o kpɛɛzi kↄ̃n yã kɛ̀ má dànnɛɛo? ");
INSERT INTO bus_vpl VALUES ("K12_44","012_2_44","1KI","2","44","44","Ben kína ɛ̀ara à bènɛ dↄ: Yã zaaa kɛ̀ ń kɛ̀ ma de Daudanɛ dↄngu píngi. Dii bé eé tó à zaaa pì wí n musu sa, ");
INSERT INTO bus_vpl VALUES ("K12_45","012_2_45","1KI","2","45","45","mↄde eé aubarika damagu à tó Dauda kpata kãsãa gↄ̃ pɛɛna ai gurↄ sãnda píngia. ");
INSERT INTO bus_vpl VALUES ("K12_46","012_2_46","1KI","2","46","46","Kína Yoyada nɛ́ Bɛnaya dà, ben à gàa à Simɛi lɛ̀ à dɛ̀. Lɛn Sulemanu kpata kãsãa pɛ̀ɛ lɛ. ");
INSERT INTO bus_vpl VALUES ("K13_1","012_3_1","1KI","3","1","1","Sulemanu lɛdolɛ kɛ̀ kↄ̃n Igipiti kí Fili'aunao, à à nɛ́nↄgbɛ̃ sɛ̀ nↄↄ ũ à sùo Dauda wɛ́tɛn àton a bɛ kↄ̃n Dii uao kↄ̃n Yerusalɛmu bĩio bo à mì dɛ. ");
INSERT INTO bus_vpl VALUES ("K13_2","012_3_2","1KI","3","2","2","Gurↄ beeea wèe kpɛ́ bo Diinɛ kↄ̀ro, ben wègↄ̃ saa oo kpiii musu tãagbãgbãkiinↄa. ");
INSERT INTO bus_vpl VALUES ("K13_3","012_3_3","1KI","3","3","3","Sulemanu ye Diizi, à a de Dauda yãdiɛnanↄ kũna, mↄde è saa o gbãgbãkii pìnↄa, ben ègↄ̃ tuaetiti kpata gwe. ");
INSERT INTO bus_vpl VALUES ("K13_4","012_3_4","1KI","3","4","4","Ben à gàa saa o zaa Gibiↄ̃, zaakɛ gbãgbãkii pì bé à dɛ à kpaaanↄla. À sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ ò gwe mɛ̀n wàa sↄↄro. ");
INSERT INTO bus_vpl VALUES ("K13_5","012_3_5","1KI","3","5","5","Gwen Dii bↄ̀ à mↄ̀zi nanaa guu gwãavĩ à bè: Ǹ pↄ́ kɛ̀ ń yezi wɛ́ɛ kɛma. ");
INSERT INTO bus_vpl VALUES ("K13_6","012_3_6","1KI","3","6","6","Ben Sulemanu bè: N gbɛ̃kɛɛ kɛ̀ n zↄ̀bleri ma de Daudanɛ maamaa, kɛ̀ à dɛnnɛ gbɛ̃ maa náanɛde nↄ̀sɛpuradee ũ yãnzi. N gbɛ̃kɛ bíta kɛ̀nɛ, ń tò mamↄma à nɛ́ e kí blee à gɛ̃ɛ ũ gbã̀a kɛ̀a. ");
INSERT INTO bus_vpl VALUES ("K13_7","012_3_7","1KI","3","7","7","Tia sa Dii ma Luda, n mamↄma n zↄ̀bleri kà kí ũ ma de Dauda gbɛ̀n. Nɛ́ féten ma ũ, má yãke gbá dↄ̃ro. ");
INSERT INTO bus_vpl VALUES ("K13_8","012_3_8","1KI","3","8","8","Mamↄma n zↄ̀bleri, má kú n gbɛ̃ kɛ̀ ń sɛ̀nↄ tɛ́. Aↄ̃ↄ pari, weé fↄ̃ wà ń naro wà ń lɛ́ dↄ̃ro. ");
INSERT INTO bus_vpl VALUES ("K13_9","012_3_9","1KI","3","9","9","Ǹ mamↄma n zↄ̀bleri gba ↄ̃ndↄ̃ↄ, lɛ màgae yã gↄ̃gↄ̃ n gbɛ̃nↄnɛ a zɛ́a, màgↄ̃ à maaa dↄ̃kↄ̃zi kↄ̃n à zaaao. Tó lɛnlo, dian mɛ́ kɛ nà mà yã gↄ̃gↄ̃ n gbɛ̃ pari daa pìnↄnɛ? ");
INSERT INTO bus_vpl VALUES ("K13_10","012_3_10","1KI","3","10","10","Yã kɛ̀ Sulemanu wɛ́ɛ kɛ̀ pì kɛ̀ Diinɛ, ");
INSERT INTO bus_vpl VALUES ("K13_11","012_3_11","1KI","3","11","11","ben à bènɛ: Zaakɛ yã kɛ̀ ń wɛ́ɛ kɛ̀n gwe, nɛ́ɛ wɛ̃̀ndi gbã̀a wɛ́ɛ kɛro ke auziki ke n ibɛɛnↄ gaa, séde yãgↄ̃gↄ̃na a zɛ́a dↄ̃nan ń wɛ́ɛ kɛ̀, ");
INSERT INTO bus_vpl VALUES ("K13_12","012_3_12","1KI","3","12","12","mɛ́ kɛ lán ń wɛ́ɛ kɛ̀ nà, mɛ́ n gba ↄ̃ndↄ̃ kↄ̃n wɛ́ɛzɛ̃ɛo. Gbɛ̃ kee kuu n ã ke n gbɛra kɛ̀ eégↄ̃ ↄ̃ndↄ̃ lán n bàro. ");
INSERT INTO bus_vpl VALUES ("K13_13","012_3_13","1KI","3","13","13","Mɛ́ pↄ́ kɛ̀ nɛ́ɛ wɛ́ɛ kɛro kpámma dↄ. Mɛ́ n gba auziki kↄ̃n gakuio píngi ai n wɛ̃̀ndi lɛ́n. Kína ke é ká n ũro. ");
INSERT INTO bus_vpl VALUES ("K13_14","012_3_14","1KI","3","14","14","Tó ń tɛ́mazi, bensↄ̃ ń ma yã'onnɛnanↄ kↄ̃n ma yãdiɛnanↄ kũna lán n de Dauda kũna nà, mɛ́ n wɛ̃̀ndi dↄnnɛ kↄ̃n mↄ̀kyakooo. ");
INSERT INTO bus_vpl VALUES ("K13_15","012_3_15","1KI","3","15","15","Ben Sulemanu vù, à è kɛ̀ nanaan á ò. Ben à tà Yerusalɛmu, à gàa à zɛ̀ Dii bà kuuna kↄ̃n Isarailinↄ àkpati aɛ, à sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũnↄ kↄ̃n kɛnnakↄ̃o sa'opↄnↄ ò gwe, ben à pↄnna pↄ́blee kɛ̀ a ìbanↄnɛ. ");
INSERT INTO bus_vpl VALUES ("K13_16","012_3_16","1KI","3","16","16","Zĩkea kaarua gↄ̃ↄn plaa kenↄ mↄ̀ Sulemanu kiia, aↄ̃ zɛ̀ à aɛ. ");
INSERT INTO bus_vpl VALUES ("K13_17","012_3_17","1KI","3","17","17","Aↄ̃ gbɛ̃ doo bè: Ǹ gaafaa kɛmɛ kí. Mapi kↄ̃n nↄgbɛ̃ kɛ̀o wá kú kpɛ́ dↄ̃nkↄ̃mmɛ. Ben ma nɛ́ ì wámbe wa plaa kpɛ́ pì guu. ");
INSERT INTO bus_vpl VALUES ("K13_18","012_3_18","1KI","3","18","18","À gurↄ aagↄ̃dee zĩ nↄgbɛ̃ pì nɛ́ ì se. Wámbe wa plaa kpɛ́ pì guu, gbɛ̃kee kúwao gwero. ");
INSERT INTO bus_vpl VALUES ("K13_19","012_3_19","1KI","3","19","19","Kɛ̀ nↄgbɛ̃ pì dàɛ a nɛ́gↄ̃gbɛ̃ pìa gwãavĩ, ben à gà. ");
INSERT INTO bus_vpl VALUES ("K13_20","012_3_20","1KI","3","20","20","Ben à fɛ̀ɛ gwãavĩ lezãndo, à ma nɛ́gↄ̃gbɛ̃ sɛ̀ ma saɛ gurↄↄ kɛ̀ mamↄma n zↄ̀bleri e ii oo, à dàɛ a saɛ, ben à a nɛ́ gɛ̀ kii sɛ̀ à dàɛmɛ ma saɛ. ");
INSERT INTO bus_vpl VALUES ("K13_21","012_3_21","1KI","3","21","21","Kɛ̀ ma vu kↄngↄ mà yↄ̃ kpá ma nɛ́a, ben má è gɛ̀. Kɛ̀ má gwà tíii, ben má è ma nɛ́nlo. ");
INSERT INTO bus_vpl VALUES ("K13_22","012_3_22","1KI","3","22","22","Ben nↄgbɛ̃ pì gbɛ̃ndoo bè: Ɛgɛɛmɛ! Ma nɛ́ bé à bɛ̃ɛ, n pↄ́ bé à gà. Ben nↄgbɛ̃ káaku bè: Ɛgɛɛmɛ! N nɛ́ bé à gà, ma pↄ́ bé à bɛ̃ɛ. Ben aↄ̃ↄe lɛokpakↄ̃a kɛɛ kína aɛzĩ. ");
INSERT INTO bus_vpl VALUES ("K13_23","012_3_23","1KI","3","23","23","Ben kína bè: Gbɛ̃ kɛ̀kii e bee a nɛ́ bé à bɛ̃ɛ, n pↄ́ bé à gà, bensↄ̃ gbɛ̃ kɛ̀kãa e bee, ɛgɛɛmɛ, n nɛ́ bé à gà, a pↄ́ bé à bɛ̃ɛ. ");
INSERT INTO bus_vpl VALUES ("K13_24","012_3_24","1KI","3","24","24","Ben kína bè: À mↄ́mɛ kↄ̃n fɛ̃ɛdaao. Ben wà mↄ̀onɛ. ");
INSERT INTO bus_vpl VALUES ("K13_25","012_3_25","1KI","3","25","25","Ben kína bè: À nɛ́ kɛ̀ bɛ̃ɛ zↄ̃kↄ̃rɛ plaa, à à kpadoo kpá gbɛ̃ dooa, é à kpadoo kpá dooa. ");
INSERT INTO bus_vpl VALUES ("K13_26","012_3_26","1KI","3","26","26","Nↄgbɛ̃ kɛ̀ a nɛ́ bɛ̃ɛ sↄ̃, nɛ́ pì kɛ̀nɛ wɛ̃nda, ben à bè kínanɛ: Kí, ǹ nɛ́ kɛ̀ bɛ̃ɛ pì kpáa, ǹton à dɛro. Ben à gbɛ̃ndoo bè: Wà à zↄ̃kↄ̃rɛ plaa, wa píngi wà korazi. ");
INSERT INTO bus_vpl VALUES ("K13_27","012_3_27","1KI","3","27","27","Ben kína yã mì dɛ̀ à bè: À nɛ́ kɛ̀ bɛ̃ɛ pì kpá nↄgbɛ̃ káakua. Àton à dɛro. À dan gwe. ");
INSERT INTO bus_vpl VALUES ("K13_28","012_3_28","1KI","3","28","28","Kɛ̀ Isarailinↄ yãkpaɛ kɛ̀ kína kɛ̀ pì mà, aↄ̃ vĩa kɛ̀nɛ, zaakɛ aↄ̃ↄ è Luda à gbà ↄ̃ndↄ̃ↄ à yã gↄ̃gↄ̃ a zɛ́a. ");
INSERT INTO bus_vpl VALUES ("K14_1","012_4_1","1KI","4","1","1","Kí Sulemanun Isaraili bori píngi kína ũ. ");
INSERT INTO bus_vpl VALUES ("K14_2","012_4_2","1KI","4","2","2","À bùsu dↄn'aɛdeenↄ tↄ́n yɛ̀: Zadↄki nɛ́ Azarian sa'oriki ũ. ");
INSERT INTO bus_vpl VALUES ("K14_3","012_4_3","1KI","4","3","3","Sisa nɛ́nↄ Ɛliↄrɛfi kↄ̃n Ahiaon à takadakɛ̃rinↄ ũ. Ailudi nɛ́ Yosafatan yãzibaarukɛ̃ri ũ. ");
INSERT INTO bus_vpl VALUES ("K14_4","012_4_4","1KI","4","4","4","Yoyada nɛ́ Bɛnayan à zĩ̀kpɛ dↄn'aɛdee ũ. Zadↄki kↄ̃n Abiataon sa'orinↄ ũ. ");
INSERT INTO bus_vpl VALUES ("K14_5","012_4_5","1KI","4","5","5","Natã nɛ́ Azarian à gu dↄn'aɛdeenↄ gbɛ̃nsi ũ. Sa'ori Zabudu, Natã nɛ́n à kpàasi ũ. ");
INSERT INTO bus_vpl VALUES ("K14_6","012_4_6","1KI","4","6","6","Aisan à bɛgwari ũ. Abada nɛ́ Adoniramun zↄ̀zĩ gbɛ̃nsi ũ. ");
INSERT INTO bus_vpl VALUES ("K14_7","012_4_7","1KI","4","7","7","Kí Sulemanu Isarailinↄ bùsu gbɛ̃nsinↄ dìɛdiɛ guunↄa gↄ̃ↄn kuri awɛɛplaa. Wɛ̃̀ kↄ̃n wɛ̃̀o aↄ̃ baade è mↄ́ kína kↄ̃n a uadeenↄnɛ kↄ̃n pↄ́bleeo aↄ̃ baade kↄ̃n a mↄↄo. ");
INSERT INTO bus_vpl VALUES ("K14_8","012_4_8","1KI","4","8","8","Aↄ̃ tↄ́n yɛ̀: Bɛnuru bé à Ɛflaimu boriinↄ gu sĩ̀sĩdee vĩ. ");
INSERT INTO bus_vpl VALUES ("K14_9","012_4_9","1KI","4","9","9","Bɛnidɛka bé à Makaza kↄ̃n Salabimuo kↄ̃n Bɛsɛmɛsio kↄ̃n Ɛlↄni Bɛtanao vĩ. ");
INSERT INTO bus_vpl VALUES ("K14_10","012_4_10","1KI","4","10","10","Bɛnɛsɛdi bé à Arubo kↄ̃n Sokoo vĩ kↄ̃n Ɛfa guuo píngi dↄ. ");
INSERT INTO bus_vpl VALUES ("K14_11","012_4_11","1KI","4","11","11","Bɛnabinadabu bé à Dↄru gusĩsĩdee vĩ. Sulemanu nɛ́nↄgbɛ̃ Tafamɛ à nↄↄ ũ. ");
INSERT INTO bus_vpl VALUES ("K14_12","012_4_12","1KI","4","12","12","Ailudi nɛ́ Baana bé à Tanaki vĩ kↄ̃n Mɛgidoo kↄ̃n Bɛtɛsã guu kɛ̀ kĩi kↄ̃n Zarɛtão Yɛzɛrili gĩzĩ kpa píngi zaa Bɛtɛsã ai Abɛli Mɛↄla ai Yↄkɛmɛamu kãa kpa. ");
INSERT INTO bus_vpl VALUES ("K14_13","012_4_13","1KI","4","13","13","Bɛnigɛba bé à Ramↄ Giliada vĩ kↄ̃n Manase nɛ́ Yairi lakutu kɛ̀ kú Giliada guunnↄ kↄ̃n Agobu guu kɛ̀ kú Basão kↄ̃n à mɛɛwi bĩide mɛ̀n baaagↄ̃ↄnↄ. Wà ń zɛ́ gbãnganↄ kɛ̀ kↄ̃n mↄ̀gotɛ̃omɛ. ");
INSERT INTO bus_vpl VALUES ("K14_14","012_4_14","1KI","4","14","14","Ido nɛ́ Ainadabu bé à Manaimu guu vĩ. ");
INSERT INTO bus_vpl VALUES ("K14_15","012_4_15","1KI","4","15","15","Aimaza bé à Nafatali guu vĩ. Àmbe à Sulemanu nɛ́nↄgbɛ̃ Basɛma sɛ̀ nↄↄ ũ. ");
INSERT INTO bus_vpl VALUES ("K14_16","012_4_16","1KI","4","16","16","Usai nɛ́ Baana bé à Asa guu vĩ kↄ̃n Alotio. ");
INSERT INTO bus_vpl VALUES ("K14_17","012_4_17","1KI","4","17","17","Parua nɛ́ Yosafata bé à Isaka guu vĩ. ");
INSERT INTO bus_vpl VALUES ("K14_18","012_4_18","1KI","4","18","18","Ela nɛ́ Simɛi bé à Bɛyãmi guu vĩ. ");
INSERT INTO bus_vpl VALUES ("K14_19","012_4_19","1KI","4","19","19","Uri nɛ́ Gɛba bé à Giliada guu vĩ. Amↄrinↄ kí Siↄ̃ kↄ̃n Basã kí Oguo bé wà kú gwe yã. Gɛban guu pì dↄn'aɛdee ũ ado. ");
INSERT INTO bus_vpl VALUES ("K14_20","012_4_20","1KI","4","20","20","Yudanↄ kↄ̃n Isarailinↄↄ pari lán ísialɛ bùsu'ãatɛ̃ bà. Aↄ̃ègↄ̃ pↄ́ blee wàgↄ̃ í mii wà pↄnnaa kɛ. ");
INSERT INTO bus_vpl VALUES ("K14_21","012_4_21","1KI","4","21","21","Zaa Yuflati ai Filisitininↄ bùsun kↄ̃n Igipiti bùsu lɛ́o, Sulemanu bé à kí blè bùsu pìnↄa píngi. Bùsu pìnↄ gbɛ̃nↄ ègↄ̃ tángba kpaaa ai à wɛ̃̀ndi lɛ́n. ");
INSERT INTO bus_vpl VALUES ("K14_22","012_4_22","1KI","4","22","22","Sulemanu ua gurↄ do blɛɛn yɛ̀: Flawa sàki baplaa akuri, wísiti sàki basↄↄro. ");
INSERT INTO bus_vpl VALUES ("K14_23","012_4_23","1KI","4","23","23","Zù mɛ̀kpana kɛ̀ wà gwà bɛ mɛ̀n kuri, kpàsa zù mɛ̀n baro, sã mɛ̀n basↄↄro kↄ̃n gãanↄ kↄ̃n zↄ̃nↄ kↄ̃n dùanↄ kↄ̃n ko maaanↄ dↄ. ");
INSERT INTO bus_vpl VALUES ("K14_24","012_4_24","1KI","4","24","24","Zaakɛ à kí blè bùsu kɛ̀ kú Yuflati ↄfãntɛ̃gɛ̃kpɛn kpaanↄa píngi sɛna zaa Tifisa ai Gaza, bensↄ̃ yãkete kú gukearo. ");
INSERT INTO bus_vpl VALUES ("K14_25","012_4_25","1KI","4","25","25","Sulemanu gurↄↄa Yudanↄ kↄ̃n Isaraili kɛ̀ aↄ̃ↄ kú zaa Dani ai Bɛsɛbanↄ kaɛna ń bùsun ń làakaria, baade kↄ̃n a geepi línↄ kↄ̃n a kãkãpura línↄ. ");
INSERT INTO bus_vpl VALUES ("K14_26","012_4_26","1KI","4","26","26","Sulemanu sↄ̃ kɛ̀ aↄ̃è góro gáɛnↄ kɛ́sɛ bↄrↄ siigↄ̃. À sↄ̃ kɛ̀ wè diḿmanↄ sↄ̃, bↄrↄ kuri awɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("K14_27","012_4_27","1KI","4","27","27","Gu gbɛ̃nsi pìnↄ sↄ̃, aↄ̃ baade ègↄ̃ mↄↄnɛ kↄ̃n blɛɛo a mↄↄn kí Sulemanu kↄ̃n gbɛ̃ kɛ̀ aↄ̃è mↄ́ pↄ́ bleonↄ pↄ́ ũ. Pↄ́ke è kɛ̃sãḿmaro. ");
INSERT INTO bus_vpl VALUES ("K14_28","012_4_28","1KI","4","28","28","Aↄ̃ègↄ̃ mↄↄ sↄ̃ pìnↄnɛ kↄ̃n éseo kↄ̃n sɛ̃̀o dↄ guu kɛ̀ aↄ̃ↄ kún, lán wà dìɛ ń baadenɛ nà. ");
INSERT INTO bus_vpl VALUES ("K14_29","012_4_29","1KI","4","29","29","Luda Sulemanu gbà ↄ̃ndↄ̃ kↄ̃n wɛ́ɛzɛ̃ɛo maamaa. Weé fↄ̃ wà à dↄ̃na lɛ́ dↄ̃ro, lán weé fↄ̃ wà ísialɛ bùsu'ãatɛ̃ lɛ́ dↄ̃ro nà. ");
INSERT INTO bus_vpl VALUES ("K14_30","012_4_30","1KI","4","30","30","Sulemanu ↄ̃ndↄ̃ↄ dɛ ↄfãntɛ̃bↄɛkpadeenↄ kↄ̃n Igipitinↄ pↄ́la ń píngi. ");
INSERT INTO bus_vpl VALUES ("K14_31","012_4_31","1KI","4","31","31","À ↄ̃ndↄ̃ↄ dɛ gbɛ̃ píngila. À dɛ Ɛzɛra bori Etani pↄ́la kↄ̃n Maↄli nɛ́nↄ Emani kↄ̃n Kalakↄlio kↄ̃n Daadao. À tↄ́ bↄ̀ bùsu kɛ̀ lìgazinↄ guu píngi. ");
INSERT INTO bus_vpl VALUES ("K14_32","012_4_32","1KI","4","32","32","À yáasi zù bↄrↄ aagↄ̃ bensↄ̃ lɛ̀ kɛ̀ à dànↄ kà bↄrↄ do kↄ̃n mɛ̀n sↄↄroo. ");
INSERT INTO bus_vpl VALUES ("K14_33","012_4_33","1KI","4","33","33","À línↄ kↄ̃n lánↄ yã bↄkↄ̃tɛna kɛ̀, naana zaa sida lí kɛ̀ kú Lɛbanↄ bùsun ai à gàa pɛ́ sɛ̃̀sↄ̃vlãa kɛ̀ è bↄɛ bĩianↄa. À nↄ̀bↄnↄ yã dàńnɛ dↄ kↄ̃n bãanↄ kↄ̃n pↄ́taa'onkusɛanↄ kↄ̃n kpↄ̀nↄ. ");
INSERT INTO bus_vpl VALUES ("K14_34","012_4_34","1KI","4","34","34","Kína kɛ̀ aↄ̃ↄ kú anduna guunↄ à ↄ̃ndↄ̃ baaru mà ń píngi. Bùsu kↄ̃n bùsuo píngi ń gbɛ̃nↄ zĩ̀ wà gá à ↄ̃ndↄ̃yã ma. ");
INSERT INTO bus_vpl VALUES ("K15_1","012_5_1","1KI","5","1","1","Kɛ̀ Taya kí Hiramu mà kɛ̀ wà Sulemanu kà kí ũ a de gɛ̃ɛ ũ, à a ìba kenↄ zĩ̀a, zaakɛ Dauda gbɛ̃nnamɛ yã. ");
INSERT INTO bus_vpl VALUES ("K15_2","012_5_2","1KI","5","2","2","Ben Sulemanu lɛ́kpãsã kɛ̀ Hiramunɛ à bè: ");
INSERT INTO bus_vpl VALUES ("K15_3","012_5_3","1KI","5","3","3","Ń dↄ̃ kɛ̀ ma de Dauda e e à kpɛ́ bò Dii a Ludanɛro, kɛ̀ borii kɛ̀ aↄ̃ↄ ligazinↄↄ e zĩ̀ kaao yãnzi, ai Dii gàa à ń kɛ́nɛ tinti ũ. ");
INSERT INTO bus_vpl VALUES ("K15_4","012_5_4","1KI","5","4","4","Tia sa Dii ma Ludaa tò ma ĩampakii è. Ibɛɛ kee kú gukearo, mↄ́nzi kee kuuro. ");
INSERT INTO bus_vpl VALUES ("K15_5","012_5_5","1KI","5","5","5","Beee yãnzin má yezi mà kpɛ́ bo Dii ma Ludanɛzi, lán Dii ò ma de Daudanɛ nà, à bè à nɛ́ kɛ̀ é kpá kpatan à gɛ̃ɛ ũu bé eé kpɛ́ boare. ");
INSERT INTO bus_vpl VALUES ("K15_6","012_5_6","1KI","5","6","6","Ǹ gbɛ̃nↄ da aↄ̃ Lɛbanↄ sida línↄ zↄ̃zↄ̃mɛ. Ma zĩkɛrinↄ é zĩi pì kɛ kↄ̃n n zĩkɛrinↄ lɛdo, mɛ́ n zĩkɛri pìnↄ fĩa bonnɛ lán ń ò nà píngi. Ń dↄ̃ kɛ̀ wá gbɛ̃ke vĩ à lízↄ̃na dↄ̃ lán a Sidↄ̃deenↄ bàro. ");
INSERT INTO bus_vpl VALUES ("K15_7","012_5_7","1KI","5","7","7","Kɛ̀ Hiramu Sulemanu yã pì mà, à pↄↄ kɛ̀ nna maamaa à bè: Wà Dii tↄ́ kpá gbã̀a, zaakɛ à Dauda gbà nɛ́ ↄ̃ndↄ̃dee, èe dↄↄ a gbɛ̃ pariinↄnɛ aɛ. ");
INSERT INTO bus_vpl VALUES ("K15_8","012_5_8","1KI","5","8","8","Ben Hiramu gbɛ̃nↄ zĩ̀ Sulemanua à bè: Ma lɛ́kpãsã kɛ̀ ń kɛ̀mɛɛ mà. Mɛ́ kɛ lán ń yezi nà sida línↄ kↄ̃n pini línↄ yã musu. ");
INSERT INTO bus_vpl VALUES ("K15_9","012_5_9","1KI","5","9","9","Ma zĩkɛrinↄ é lí pìnↄ sɛ́ zaa Lɛbanↄ kpiiinↄ musu, aↄ̃é pitao ísialɛa, mɛ́ yiyi mà gbɛ̃nↄ zĩonnɛ ísiaala. Guu kɛ̀ ń òmɛn, gwen mɛ́ tó wà káɛnnnɛ, gbasa ǹ táo. Mpi sↄ̃, yã kɛ̀ má yezi ǹ kɛmɛɛn yɛ̀: Ǹ pↄ́blee kpá ma uadeenↄa. ");
INSERT INTO bus_vpl VALUES ("K15_10","012_5_10","1KI","5","10","10","Lɛn Hiramu ègↄ̃ sida línↄ kↄ̃n pini línↄ kpaa Sulemanua lɛ lán à yezi nà. ");
INSERT INTO bus_vpl VALUES ("K15_11","012_5_11","1KI","5","11","11","Sulemanu sↄ̃ ègↄ̃ pↄ́wɛɛ kpaaa wɛ̃̀ kↄ̃n wɛ̃̀o tↄn wàa plaa kↄ̃n nↄ́sio lita bↄrↄ wàa plaa. ");
INSERT INTO bus_vpl VALUES ("K15_12","012_5_12","1KI","5","12","12","Dii Sulemanu gbà ↄ̃ndↄ̃ↄ lán à à lɛ́ gbɛ̃̀nɛ nà. Hiramu kↄ̃n Sulemanuo nna kↄ̃o, ben aↄ̃ lɛdolɛ vĩ. ");
INSERT INTO bus_vpl VALUES ("K15_13","012_5_13","1KI","5","13","13","Kí Sulemanu gbɛ̃nↄ sɛ̀sɛ Isaraili boriinↄ tɛ́ píngi à ń dá zĩi pì guu gↄ̃ↄn bↄrↄ baaakuri. ");
INSERT INTO bus_vpl VALUES ("K15_14","012_5_14","1KI","5","14","14","Ègↄ̃ ń zĩ Lɛbanↄ bùsun mↄ kↄ̃n mↄo gↄ̃ↄn bↄrↄ kuri. Gbɛ̃ pìnↄ è kɛ Lɛbanↄ mↄ do, ben aↄ̃è su wà kɛ bɛ mↄ plaplaa. Adoniramun zↄ̀zĩi pì gbɛ̃nsi ũ. ");
INSERT INTO bus_vpl VALUES ("K15_15","012_5_15","1KI","5","15","15","Sulemanu gbɛ̀'arinↄ vĩ gukpiideen gↄ̃ↄn bↄrↄ basiigↄ̃, à sɛ̀sɛrinↄ sↄ̃ gↄ̃ↄn bↄrↄ baaagↄ̃ akuri. ");
INSERT INTO bus_vpl VALUES ("K15_16","012_5_16","1KI","5","16","16","Gbɛ̃ pìnↄ baasi, Sulemanu gbɛ̃nↄ dìɛdiɛ gↄ̃ↄn bↄrↄ aagↄ̃ kↄ̃n wàa aagↄ̃o, aↄ̃gↄ̃ wɛ́ɛ tɛɛ zĩi pìzi. ");
INSERT INTO bus_vpl VALUES ("K15_17","012_5_17","1KI","5","17","17","Kína yã dìɛ, ben wà gbɛ̀ gbɛ̃̀ntɛ̃ maaanↄ yↄ̃̀yↄ̃ wà à, wà sɛ̀ɛ wà sùo kpɛ́ pì ɛ̃daɛbↄnↄ ũ. ");
INSERT INTO bus_vpl VALUES ("K15_18","012_5_18","1KI","5","18","18","Lɛn Sulemanu zĩkɛrinↄ kↄ̃n Hiramu zĩkɛrinↄ kↄ̃n Gebalideenↄ lí zↄ̃̀zↄ̃ lɛ aↄ̃ kɛ̀kɛ, aↄ̃ gbɛ̀ kɛ̀kɛ kpɛ́ pì bobↄ ũ. ");
INSERT INTO bus_vpl VALUES ("K16_1","012_6_1","1KI","6","1","1","Isarailinↄ bↄna Igipiti wɛ̃̀ wàa plaa kpɛ́ basiigↄ̃ↄ gbɛra, Sulemanu kíblena wɛ̃̀ siigↄ̃deen, à mↄ plaadee kɛ̀ wè be Zivi guu, ben à nà Dii ua kaɛnaa. ");
INSERT INTO bus_vpl VALUES ("K16_2","012_6_2","1KI","6","2","2","Kpɛ́ kɛ̀ à bò Diinɛ pì gbã̀a kà gã̀sãsuu baaagↄ̃, à yàasa baro, à lezĩ baaakuri. ");
INSERT INTO bus_vpl VALUES ("K16_3","012_6_3","1KI","6","3","3","Kpɛ́ pì gbàadaaa vĩ a aɛ, à gbã̀a sɛ̃nkpɛo gã̀sãsuu baro, à yàasa sↄ̃ gã̀sãsuu kuri. ");
INSERT INTO bus_vpl VALUES ("K16_4","012_6_4","1KI","6","4","4","À à windonↄ bↄ̀bↄ, à lɛ́nↄↄ dɛ yàasa, à guu kpaa dɛ kpaatogo. ");
INSERT INTO bus_vpl VALUES ("K16_5","012_6_5","1KI","6","5","5","À kpɛ́nɛnↄ bòbo à lìga kpɛ́ pìzi kↄ̃n a Ludakukiio kpa plaplaa kↄ̃n a kpɛɛo. ");
INSERT INTO bus_vpl VALUES ("K16_6","012_6_6","1KI","6","6","6","À didikↄ̃ana aagↄ̃gↄ̃, kpɛ́nɛ kɛ̀ kú tↄↄtɛnↄ yàasa kà gã̀sãsuu sↄsↄↄro, kɛ̀ kú guranↄ swɛɛdodo, kɛ̀ kú musunↄ swɛɛplaplaa. Dii kpɛ́ gbɛ̀ kɛ̀ kú musunↄ yàasa kɛ̃̀sã tↄↄtɛ pↄ́zi, lɛ wà e wà kpɛ́nɛ pì zànↄ didia kpɛ́ pì gbɛ̀fↄ̃na sai. ");
INSERT INTO bus_vpl VALUES ("K16_7","012_6_7","1KI","6","7","7","Kɛ̀ wèe kpɛ́ pì boo, wà bò kↄ̃n gbɛ̀ kɛ̀ wà à zaa a yↄ̃kiiaomɛ. Wèe eree ke gã ke zĩkɛbↄ ke kĩi ma kpɛ́ pì bokiiaro. ");
INSERT INTO bus_vpl VALUES ("K16_8","012_6_8","1KI","6","8","8","Kpɛ́nɛ kɛ̀ kú tↄↄtɛnↄ píngi gɛ̃kii kú à sↄↄmɛtɛ kpamɛ. Didikii gàa kpɛ́nɛ kɛ̀ kú guranↄ kↄ̃n kpɛ́nɛ kɛ̀ di à musunↄ kiia. ");
INSERT INTO bus_vpl VALUES ("K16_9","012_6_9","1KI","6","9","9","Kɛ̀ à kpɛ́ pì bò à yã̀a, à dↄ̀ kↄ̃n zà línↄ kↄ̃n sida lí lɛ̀ɛtɛgɛɛnↄ. ");
INSERT INTO bus_vpl VALUES ("K16_10","012_6_10","1KI","6","10","10","À kpɛ́nɛ pìnↄ bò kpɛ́ pì gbã̀a lɛ́mmɛ. À píngi lezĩ gã̀sãsuu sↄsↄↄromɛ, bensↄ̃ wà ń pɛ́pɛ kpɛ́ pìa kↄ̃n sida lío. ");
INSERT INTO bus_vpl VALUES ("K16_11","012_6_11","1KI","6","11","11","Ben Dii yã ò Sulemanunɛ à bè: ");
INSERT INTO bus_vpl VALUES ("K16_12","012_6_12","1KI","6","12","12","Kpɛ́ kɛ̀ nɛ́ɛ boo kɛ̀ki yã musu, tó nɛ́ɛ ma ↄdↄkii gwaa, tó n ma yãdannɛnanↄ kɛ̀, tó ń yã kɛ̀ má dìɛńnɛnↄ kũna nɛ́ɛ zĩi kɛɛa, mɛ́ lɛ́ kɛ̀ má gbɛ̃̀ n de Daudanɛ papannɛ. ");
INSERT INTO bus_vpl VALUES ("K16_13","012_6_13","1KI","6","13","13","Mɛ́gↄ̃ kú ma gbɛ̃ Isarailinↄ tɛ́, mɛ́ ń tónlo. ");
INSERT INTO bus_vpl VALUES ("K16_14","012_6_14","1KI","6","14","14","Kɛ̀ Sulemanu kpɛ́ pì bò à yã̀a, ");
INSERT INTO bus_vpl VALUES ("K16_15","012_6_15","1KI","6","15","15","à sida lí lɛ̀ɛtɛgɛɛnↄ nàna à gũ̀a à guu sɛ́lɛlɛ zaa tↄↄtɛ ai à sàtazi, ben à pini lí lɛ̀ɛtɛgɛɛnↄ kpàɛ à tↄↄtɛ píngi. ");
INSERT INTO bus_vpl VALUES ("K16_16","012_6_16","1KI","6","16","16","À kpɛ́nɛ kɛ̀ kpɛ́ pì guu Ludakukii ũ, à gbã̀a kà gã̀sãsuu baro, ben à sida lí lɛ̀ɛtɛgɛɛnↄ nàna à gũ̀a sɛ́lɛlɛ zaa tↄↄtɛ ai à sàtazi. ");
INSERT INTO bus_vpl VALUES ("K16_17","012_6_17","1KI","6","17","17","Kpɛ́ pì gãnu gbã̀a kà gã̀sãsuu baplaa. ");
INSERT INTO bus_vpl VALUES ("K16_18","012_6_18","1KI","6","18","18","Sida lí kɛ̀ wà nàna kpɛ́ pì guu, wà ↄzĩi kɛ̀a lán tùu kↄ̃n lávu pianao bà. À píngi nɛ́ sida límɛ, wè gbɛ̀ ke e gupuraaro. ");
INSERT INTO bus_vpl VALUES ("K16_19","012_6_19","1KI","6","19","19","À kpɛ́ pì kpɛ́nɛ kɛ̀kɛ Dii bà kuuna kↄ̃n Isarailinↄ àkpati diɛkii ũ. ");
INSERT INTO bus_vpl VALUES ("K16_20","012_6_20","1KI","6","20","20","Kpɛ́nɛ pì gbã̀a kà gã̀sãsuu baro, à yàasa dↄ baro, à lezĩ sↄ̃ baro. À vura atɛ̃ɛ nàna kpɛ́nɛ pì gũ̀a píngi. À tuaetitikpatakii kɛ̀ wà kɛ̀ kↄ̃n sida lío nàna kↄ̃n vurao dↄ. ");
INSERT INTO bus_vpl VALUES ("K16_21","012_6_21","1KI","6","21","21","À vura atɛ̃ɛ nàna gãnu gũ̀a dↄ, ben à mↄ̀kyakoo kɛ̀ wà pì kↄ̃n vuraonↄ lògologo kpɛ́nɛ gũ̀ kɛ̀ à vura nànaa pìa kpɛɛlɛ kpa. ");
INSERT INTO bus_vpl VALUES ("K16_22","012_6_22","1KI","6","22","22","À vura nàna kpɛ́ pì guuguu sɛ́lɛlɛ kↄ̃n tuaetitikpatakii kɛ̀ kú kpɛ́nɛ pì saɛo. ");
INSERT INTO bus_vpl VALUES ("K16_23","012_6_23","1KI","6","23","23","À kù lí à kɛrubunↄ ũ mɛ̀n plaa, à dìɛ kpɛ́nɛ guu. Kɛrubu pìnↄ lezĩ kà gã̀sãsuu kuri. ");
INSERT INTO bus_vpl VALUES ("K16_24","012_6_24","1KI","6","24","24","Aↄ̃ dɛ̀bɛnↄ gbã̀a kà gã̀sãsuu sↄsↄↄro. Zaa dɛ̀bɛ do lɛ́a kɛ̀ ai à do lɛ́a kãa à gbã̀a gã̀sãsuu kuri. ");
INSERT INTO bus_vpl VALUES ("K16_25","012_6_25","1KI","6","25","25","Kɛrubu mɛ̀n plaaa pìnↄↄ bↄ̀kↄ̃ba, aↄ̃ↄ sɛ̃nkpɛmɛ. ");
INSERT INTO bus_vpl VALUES ("K16_26","012_6_26","1KI","6","26","26","Aↄ̃ plaa ń píngi lezĩ kà gã̀sãsuu kurikuri. ");
INSERT INTO bus_vpl VALUES ("K16_27","012_6_27","1KI","6","27","27","Ben à ń káɛ kpɛ́ pì kpɛ́nɛ guu. Aↄ̃ dɛ̀bɛnↄↄ poroporona, à doo dɛ̀bɛ gàa à pɛ̀ gũ̀a kãa, à doo pↄ́ pɛ̀ gũ̀a kɛ̀, ben aↄ̃ dɛ̀bɛ kɛ̀ gↄ̃̀nↄ pɛ̀ kↄ̃a kpɛ́nɛ pì guragura. ");
INSERT INTO bus_vpl VALUES ("K16_28","012_6_28","1KI","6","28","28","À vura nàna kɛrubu pìnↄa dↄ. ");
INSERT INTO bus_vpl VALUES ("K16_29","012_6_29","1KI","6","29","29","À ↄzĩi kɛ̀ kpɛ́ pì gũ̀nↄa gãnu kↄ̃n kpɛ́nɛo píngi, à kɛrubunↄ wɛ̃zã kɛ̀ kↄ̃n damina línↄ kↄ̃n lávu piananↄ. ");
INSERT INTO bus_vpl VALUES ("K16_30","012_6_30","1KI","6","30","30","À vura kpàɛ kpɛ́ pì tↄↄtɛ dↄ, gãnu kↄ̃n kpɛ́nɛo píngi. ");
INSERT INTO bus_vpl VALUES ("K16_31","012_6_31","1KI","6","31","31","À kpɛ́nɛ pì gbànↄ kↄ̃n à lípɛɛnↄ kɛ̀ kↄ̃n kù lío. À musu kɛ̀ sↄ̃ntɛ. ");
INSERT INTO bus_vpl VALUES ("K16_32","012_6_32","1KI","6","32","32","À ↄzĩi kɛ̀ kù lí gbà mɛ̀n plaaa pìnↄa, à kɛrubunↄ wɛ̃zã kɛ̀ kↄ̃n damina línↄ kↄ̃n lávu piananↄ, ben à vura nànaa. ");
INSERT INTO bus_vpl VALUES ("K16_33","012_6_33","1KI","6","33","33","À gãnu gbà lí kɛ̀ kusua siigↄ̃ kↄ̃n kù lío dↄ. ");
INSERT INTO bus_vpl VALUES ("K16_34","012_6_34","1KI","6","34","34","À à gbànↄ kɛ̀ kↄ̃n pini lío ↄla plaa. Gbà pìnↄ ↄla píngi è nakↄ̃a guragura. ");
INSERT INTO bus_vpl VALUES ("K16_35","012_6_35","1KI","6","35","35","Ben à ↄzĩi kɛ̀ gbà pìnↄa, à kɛrubunↄ wɛ̃zã kɛ̀ kↄ̃n damina lío kↄ̃n lávu pianao, ben à vura nànaa. ");
INSERT INTO bus_vpl VALUES ("K16_36","012_6_36","1KI","6","36","36","À bĩi bò à lìga à uazi. Bĩi pì gbɛ̀ kɛ̀ wà ànↄ vĩ didikↄ̃ana lɛo aagↄ̃gↄ̃, ben sida lí kɛ̀ wà zↄ̃̀nↄ kpákpa à musu. ");
INSERT INTO bus_vpl VALUES ("K16_37","012_6_37","1KI","6","37","37","Wà Dii kpɛ́ pì ɛ̃ɛ kpàɛ Sulemanu kíblena wɛ̃̀ siigↄ̃den, à mↄↄ kɛ̀ wè be Zivi guumɛ, ");
INSERT INTO bus_vpl VALUES ("K16_38","012_6_38","1KI","6","38","38","ben wà à laata kpà à wɛ̃̀ kuri awɛɛdodeen, à mↄ sↄraagↄ̃dee kɛ̀ wè be Bulu guu lán à kpɛ́ zĩi dìɛ nà. À bona kↄ̃n à kɛkɛnao kà wɛ̃̀ swɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("K17_1","012_7_1","1KI","7","1","1","Sulemanu a bɛ bona zĩi kɛ̀ píngi wɛ̃̀ kuri awɛɛ'aagↄ̃mɛ. ");
INSERT INTO bus_vpl VALUES ("K17_2","012_7_2","1KI","7","2","2","À kpɛ́ kɛ̀ wè be Lɛbanↄ líkpɛ bò, à gbã̀a kà gã̀sãsuu basↄↄro, à yàasa kà gã̀sãsuu baplaa akuri, à lezĩ sↄ̃ baaakuri. À sida línↄ pɛ̀ɛpɛɛ dↄ̀rↄ siigↄ̃, ben à sida lí kɛ̀ wà ànↄ kpàkpańla ");
INSERT INTO bus_vpl VALUES ("K17_3","012_7_3","1KI","7","3","3","mɛ̀n baplaa asↄↄro, dↄ̀rↄ kↄ̃n dↄ̀rↄo gɛ̃rogɛ̃ro lɛo aagↄ̃, ben à sida línↄ kpàkpa lí kɛ̀ wà kpà pìnↄla. ");
INSERT INTO bus_vpl VALUES ("K17_4","012_7_4","1KI","7","4","4","À à windonↄ bↄ̀bↄ dↄ̀rↄ aagↄ̃gↄ̃ didikↄ̃ana aɛo dↄdↄkↄ̃a. ");
INSERT INTO bus_vpl VALUES ("K17_5","012_7_5","1KI","7","5","5","Kpɛ́ pì lɛ́nↄ lezĩ kↄ̃n à yàasao píngi sɛ̃nkpɛkpɛmɛ. À lɛ́nↄↄ mɛ̀n aagↄ̃gↄ̃ kãa kpa kↄ̃n kɛ̀ kpaao aɛo dↄdↄkↄ̃a. ");
INSERT INTO bus_vpl VALUES ("K17_6","012_7_6","1KI","7","6","6","À wesagbanↄ pɛ̀ɛpɛɛ kpɛ́ pì kpɛɛlɛ. Kpɛɛlɛ pì gbã̀a kà gã̀sãsuu baplaa akuri, à yàasa sↄ̃ baaakuri. À gãnu bò wesagba pìnↄ aɛ, ben à wesagbanↄ pɛ̀ɛpɛɛ à gbàadaaa dↄ̀ gãnu pì lɛ́a. ");
INSERT INTO bus_vpl VALUES ("K17_7","012_7_7","1KI","7","7","7","À a kíblekita dìɛ gãnu pìn. Gwen è yã gↄ̃gↄ̃n, ben wè be Yãkpaɛkɛkpɛ. À sida lí lɛ̀ɛtɛgɛɛnↄ nàna à gũ̀a zaa tↄↄtɛ ai à sàtaa. ");
INSERT INTO bus_vpl VALUES ("K17_8","012_7_8","1KI","7","8","8","À kpɛ́ kɛ̀ è in kú aɛ. À bↄ̀kↄ̃ba kↄ̃n gãnu pìo. Lɛn kpɛ́ kɛ̀ à dↄ̀ Fili'auna nɛ́nↄgbɛ̃ kɛ̀ à sɛ̀ nↄↄ ũunɛ dɛ lɛ dↄ. ");
INSERT INTO bus_vpl VALUES ("K17_9","012_7_9","1KI","7","9","9","Kpɛ́ pìnↄ bona, gbɛ̀ maaanↄn wà ɛ̃ɛ dàɛo ai à gàa pɛ́ à sàtaa. Wà gbɛ̀ pìnↄ yↄ̃̀yↄ̃ gbasa wà zↄ̃̀zↄ̃kↄ̃rɛ kↄ̃n sagasigio kpa plaplaa píngi. Lɛmɛ ua guu kpaa dɛ lɛ kↄ̃n bàazi kpaao. ");
INSERT INTO bus_vpl VALUES ("K17_10","012_7_10","1KI","7","10","10","Wà kpɛ́ pìnↄ ɛ̃ɛ dàɛ kↄ̃n gbɛ̀ gbɛ̃̀ntɛ̃ maaanↄ, à kenↄ gbã̀a kà gã̀sãsuu kuri, à kenↄ sↄ̃ sↄraagↄ̃, ");
INSERT INTO bus_vpl VALUES ("K17_11","012_7_11","1KI","7","11","11","gbasa wà bò kↄ̃n gbɛ̀ maaa kɛ̀ wà yↄ̃̀yↄ̃ wà ànↄ kↄ̃n sida lío. ");
INSERT INTO bus_vpl VALUES ("K17_12","012_7_12","1KI","7","12","12","À bĩi bò à lìga ua bíta pìzi, à gbɛ̀ kɛ̀ wà ànↄ vĩ didikↄ̃ana dↄ̀rↄ aagↄ̃, ben sida lí kɛ̀ wà ànↄ kpákpa à musu, lán Dii kpɛ́ kↄ̃n à gbàadaaao ua bĩi dɛ nà. ");
INSERT INTO bus_vpl VALUES ("K17_13","012_7_13","1KI","7","13","13","Kí Sulemanu gbɛ̃nↄ zĩ̀ Huramu sísi zaa Taya, ben wà sùo. ");
INSERT INTO bus_vpl VALUES ("K17_14","012_7_14","1KI","7","14","14","Huramu pì da nɛ́ Nafatali boriimɛ, bensↄ̃ gyaanↄↄmɛ. À de nɛ́ Taya gbɛ̃mɛ, bensↄ̃ mↄ̀gotɛ̃ ↄzĩkɛrimɛ. Huramu pì wɛ́ɛzɛ̃ɛ vĩ kↄ̃n dↄ̃nao mↄ̀gotɛ̃ zĩ píngi guu. Kɛ̀ à mↄ̀ kí Sulemanu kiia, ben à zĩi kɛ̀ à dànɛ kɛ̀ píngi. ");
INSERT INTO bus_vpl VALUES ("K17_15","012_7_15","1KI","7","15","15","À wesagba pì mɛ̀n plaa kↄ̃n mↄ̀gotɛ̃o. À píngi lezĩ kà gã̀sãsuu baro plaasai, à lɛ́ yàasa sↄ̃ kuri awɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("K17_16","012_7_16","1KI","7","16","16","À à mìfura pì kↄ̃n mↄ̀gotɛ̃o mɛ̀n plaa à dì wesagba pìnↄ musu. Mìfura pìnↄ lezĩ kà gã̀sãsuu sↄsↄↄro. ");
INSERT INTO bus_vpl VALUES ("K17_17","012_7_17","1KI","7","17","17","À mↄ̀kyakoonↄ pì, ben à fĩ̀fĩ à mì pìnↄa lán kã̀mbɛɛ bà, aↄ̃ↄ logologona mɛ̀n swɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("K17_18","012_7_18","1KI","7","18","18","À pↄ́nↄ pì lán biisio bɛɛnↄ bà à dↄ̀dↄ wesagba mì pìnↄa à lìgazi dↄ̀rↄ plaa, mↄ̀kyakoo pìnↄ gĩzĩ kↄ̃n à musuo. À mì pìnↄↄ sɛ̃nkpɛ píngi. ");
INSERT INTO bus_vpl VALUES ("K17_19","012_7_19","1KI","7","19","19","À Dii kpɛ́ gbàadaaa wesagba mì pìnↄ pì kↄ̃n dↄ̃nao lán ítɛbaagunna vú bà. Ítɛbaagunna vú pìnↄ lezĩ kà gã̀sãsuu siisiigↄ̃. ");
INSERT INTO bus_vpl VALUES ("K17_20","012_7_20","1KI","7","20","20","Biisio bɛɛ pìnↄↄ dↄdↄ wesagba mì pìnↄ kũ̀dↄkii musu mɛ̀n wàa doodo ligana mↄ̀kyakoo pìnↄzi dↄ̀rↄdↄrↄ. ");
INSERT INTO bus_vpl VALUES ("K17_21","012_7_21","1KI","7","21","21","Ben à wesagba pìnↄ pɛ̀ɛpɛɛ kɛ̀ aↄ̃ↄ Dii kpɛ́ gbàadaa kũna. À tↄ́ kpà ↄplaa kpa pↄ́nɛ Eé Káɛ, ↄzɛɛ kpa pↄ́ sↄ̃ Gbãaa Kúa. ");
INSERT INTO bus_vpl VALUES ("K17_22","012_7_22","1KI","7","22","22","Wesagba pìnↄ mìnↄ bↄ̀ lán ítɛbaagunna vú bà. Lɛn à wesagba pìnↄ pì lɛ píngi. ");
INSERT INTO bus_vpl VALUES ("K17_23","012_7_23","1KI","7","23","23","À mↄ̀ kàsa íkakii ũ bòotoko. À lɛ́ kɛ̀ kpa ai à lɛ́ kãa kpaa kà gã̀sãsuu kuri, à lezĩ kà gã̀sãsuu sↄↄro, à lɛ́ yàasa sↄ̃ baaakuri. ");
INSERT INTO bus_vpl VALUES ("K17_24","012_7_24","1KI","7","24","24","À ↄzĩi kɛ̀ íkakii pìa lán tùunↄ bà, à lìga à lɛ́zi gĩzĩ dↄ̀rↄ plaa, gã̀sãsuu do píngi tùu mɛ̀n kuri. À íkakii pì kàsa lɛdo kↄ̃n tùu wɛ̃zãdee pìnↄ. ");
INSERT INTO bus_vpl VALUES ("K17_25","012_7_25","1KI","7","25","25","Íkakii pì di zùsware mɛ̀n kuri awɛɛplaaanↄ musu. Zù mɛ̀n aagↄ̃ↄnↄ mì dↄ gu'igbãroo kpa, mɛ̀n aagↄ̃ↄnↄ ↄfãntɛ̃gɛ̃kpɛn kpa, mɛ̀n aagↄ̃ↄnↄ sↄↄmɛtɛ kpa, mɛ̀n aagↄ̃ↄnↄ sↄ̃ ↄfãntɛ̃bↄɛ kpa. Íkakii pì di ń musu, bensↄ̃ aↄ̃ pↄ̀rↄnↄↄ dↄdↄ gura. ");
INSERT INTO bus_vpl VALUES ("K17_26","012_7_26","1KI","7","26","26","Íkakii pì gègete kà ↄla yàasa ũ. À swã dɛ lán oro swã bà, lán ítɛbaagunna swã bà. Gãnↄↄ lɛ́ wàa do ín è sí. ");
INSERT INTO bus_vpl VALUES ("K17_27","012_7_27","1KI","7","27","27","À tadibↄnↄ pì kↄ̃n mↄ̀gotɛ̃o mɛ̀n kuri. Aↄ̃ píngi gbã̀a kà gã̀sãsuu siigↄ̃, à yàasa dↄ siigↄ̃, à lezĩ sↄ̃ aagↄ̃. ");
INSERT INTO bus_vpl VALUES ("K17_28","012_7_28","1KI","7","28","28","Kɛ̀ wà tadibↄ pìnↄ pì, wà mↄ̀ lɛ̀ɛtɛgɛɛnↄ kpà à gbánↄ dagura. ");
INSERT INTO bus_vpl VALUES ("K17_29","012_7_29","1KI","7","29","29","Ben wà músu wɛ̃zãnↄ kɛ̀ mↄ̀ lɛ̀ɛtɛgɛɛ pìnↄa píngi kↄ̃n zùsware wɛ̃zãnↄ kↄ̃n kɛrubu wɛ̃zãnↄo. Wà lávutãna wɛ̃zã kɛ̀ músu pìnↄ kↄ̃n zùswaree pìnↄ musu kↄ̃n à gĩzĩo. ");
INSERT INTO bus_vpl VALUES ("K17_30","012_7_30","1KI","7","30","30","Tadibↄ pìnↄ mↄ̀gotɛ̃ górogba kↄ̃n gòo vĩ mɛ̀n siisiigↄ̃. Aↄ̃ gbá vĩ mɛ̀n siisiigↄ̃ dↄ. Gbá pìnↄ musun wè taa din. Wà gbá pìnↄ kàsa, wà lávutãna wɛ̃zã kɛ̀ à kpa siigↄ̃ↄa. ");
INSERT INTO bus_vpl VALUES ("K17_31","012_7_31","1KI","7","31","31","Tadibↄ pìnↄ lɛ́ wɛ̃na bòotoko, à lɛ́ kpaa bↄna gã̀sãsuu do, bensↄ̃ à zòoto kà ↄtã do. Wà wɛ̃zã kɛ̀ à lɛ́ kɛ̀ bↄ̀ musua dↄ. Tadibↄ pìnↄↄ mↄ̀ lɛ̀ɛtɛgɛ goodadeenↄ vĩ, aↄ̃ↄ dɛ bòotokoro. ");
INSERT INTO bus_vpl VALUES ("K17_32","012_7_32","1KI","7","32","32","Górogba pìnↄↄ kú mↄ̀ lɛ̀ɛtɛgɛɛ pìnↄ gĩzĩ. À gònↄ pɛ́pɛna tadibↄ pìnↄ gbánↄa. Górogba pìnↄ lezĩ kà gã̀sãsuu do kↄ̃n a kusuo. ");
INSERT INTO bus_vpl VALUES ("K17_33","012_7_33","1KI","7","33","33","Wà górogba pìnↄ pì lán sↄ̃goro pↄ́ bàmɛ. Wà à gònↄ kↄ̃n à górogbanↄ kↄ̃n à mↄ̀teeenↄ kↄ̃n à oroonↄ kàsa kↄ̃n mↄ̀gotɛ̃o píngi. ");
INSERT INTO bus_vpl VALUES ("K17_34","012_7_34","1KI","7","34","34","Tadibↄ pìnↄ kũkii vĩ mɛ̀n siisiigↄ̃ a goodanↄa. ");
INSERT INTO bus_vpl VALUES ("K17_35","012_7_35","1KI","7","35","35","Tadibↄ pìnↄ musu dɛ bòotoko, à lezĩ kà ↄtã do. À gbánↄ kↄ̃n à mↄ̀ lɛ̀ɛtɛgɛɛnↄↄ na tadibↄ pìnↄ musu. ");
INSERT INTO bus_vpl VALUES ("K17_36","012_7_36","1KI","7","36","36","À kɛrubu wɛ̃zã kɛ̀ à gbánↄ kↄ̃n à mↄ̀ lɛ̀ɛtɛgɛɛnↄa kↄ̃n músu wɛ̃zãnↄ kↄ̃n damina línↄ wɛ̃zãnↄo, guu kɛ̀ à è píngi. À lávutãna wɛ̃zã kɛ̀ à lìgazi dↄ. ");
INSERT INTO bus_vpl VALUES ("K17_37","012_7_37","1KI","7","37","37","Lɛn à tadibↄ pìnↄ pì lɛ. À kàsa pↄ́ dↄ̃nkↄ̃ guumɛ, aↄ̃ bítakɛ kↄ̃n ń bↄnao sɛ̃nkpɛmɛ. ");
INSERT INTO bus_vpl VALUES ("K17_38","012_7_38","1KI","7","38","38","Ben à dàga pì kↄ̃n mↄ̀gotɛ̃o mɛ̀n kuri. À píngi è í sí à kà gãnↄↄ lɛ́ siisiigↄ̃. Dàga pìnↄ yàasa kà gã̀sãsuu siisiigↄ̃. Kɛ̀ à dàga pìnↄ dìdi tadibↄ mɛ̀n kuri pìnↄa, ");
INSERT INTO bus_vpl VALUES ("K17_39","012_7_39","1KI","7","39","39","ben à kàɛ Dii kpɛ́ aɛ, mɛ̀n sↄↄroo ↄplazi, mɛ̀n sↄↄroo ↄzɛzi. À íkakii pì dìɛ ↄzɛzi Dii kpɛ́ gooda kɛ̀ kú ↄfãntɛ̃bↄɛ sↄↄmɛtɛ kpaa saɛ. ");
INSERT INTO bus_vpl VALUES ("K17_40","012_7_40","1KI","7","40","40","Ben Huramu oro túbukabↄnↄ kↄ̃n a sɛ́ɛbↄnↄ kↄ̃n ta arusibↄnↄ pì dↄ. Lɛn à Dii ua zĩi kɛ̀ kí Sulemanu dànɛ kɛ̀ lɛ, à à laata kpà píngi. ");
INSERT INTO bus_vpl VALUES ("K17_41","012_7_41","1KI","7","41","41","Zĩi kɛ̀ à kɛ̀ pìnↄn yɛ̀: Wesagba mɛ̀n plaa, à mì kɛ̀ bↄ̀ lán loo bà kɛ̀ kú wesagba pìnↄ musu mɛ̀n plaa, mↄ̀kyakoo kɛ̀ à zã blèo à mì pìnↄa mɛ̀n plaa, ");
INSERT INTO bus_vpl VALUES ("K17_42","012_7_42","1KI","7","42","42","biisio bɛɛ kɛ̀ à dↄ̀dↄ mↄ̀kyakoo pìnↄa musu mɛ̀n wàa plaa. À kɛ̀ ai dↄ̀rↄ plaa zãblebↄ ũ wesagba mì pìnↄa. ");
INSERT INTO bus_vpl VALUES ("K17_43","012_7_43","1KI","7","43","43","Tadibↄ pìnↄ mɛ̀n kuri kↄ̃n à dàganↄ mɛ̀n kuri. ");
INSERT INTO bus_vpl VALUES ("K17_44","012_7_44","1KI","7","44","44","Íkakii mɛ̀n do kↄ̃n zùswaree kɛ̀ kú à gĩzĩnↄ mɛ̀n kuri awɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("K17_45","012_7_45","1KI","7","45","45","Túbukabↄ pìnↄ kↄ̃n a sɛ́ɛbↄnↄ kↄ̃n ta arusibↄnↄ. Pↄ́ kɛ̀ Huramu pì kí Sulemanunɛ Dii ua pↄ́ ũunↄ píngi, à ń pí kↄ̃n mↄ̀gotɛ̃ lↄ́lↄnaomɛ. ");
INSERT INTO bus_vpl VALUES ("K17_46","012_7_46","1KI","7","46","46","Kína tò wà pↄ́ pìnↄ kàsa kↄ̃n Yoda gũ̀o zaa Suko kↄ̃n Zarɛtão dagura. ");
INSERT INTO bus_vpl VALUES ("K17_47","012_7_47","1KI","7","47","47","Sulemanu e tó wà pↄ́ kɛ̀ wà pì kↄ̃n mↄ̀gotɛ̃o pìnↄ yↄ̃ kilooa à à tìisi dↄ̃̀ro, kɛ̀ à kɛ̀ pari yãnzi. ");
INSERT INTO bus_vpl VALUES ("K17_48","012_7_48","1KI","7","48","48","Sulemanu pↄ́ kɛ̀ kú Dii kpɛ́ guunↄ pì dↄ, tuaetitikpatakii kɛ̀ wà kɛ̀ kↄ̃n vurao kↄ̃n vura teebu kɛ̀ wè Dii burɛdi káɛao ");
INSERT INTO bus_vpl VALUES ("K17_49","012_7_49","1KI","7","49","49","kↄ̃n dabu kɛ̀ wà kàɛ gãnu guu kpɛ́nɛ aɛ ↄplazi kↄ̃n ↄzɛzio mɛ̀n sↄsↄↄro. Wà pì kↄ̃n vurao atɛ̃ɛ kↄ̃n à fitianↄ kↄ̃n à kpàkonↄ píngi, wà lávu wɛ̃zã kɛ̀ḿma. ");
INSERT INTO bus_vpl VALUES ("K17_50","012_7_50","1KI","7","50","50","À vura ímibↄnↄ pì dↄ kↄ̃n fitiadɛbↄnↄ kↄ̃n taanↄ kↄ̃n gↄ̃mbↄnↄ kↄ̃n tɛ́sibↄnↄ kↄ̃n kpɛ́nɛ kɛ̀ wè be Ludakuki gbà asigbenↄ kↄ̃n gãnu pↄ́nↄ. ");
INSERT INTO bus_vpl VALUES ("K17_51","012_7_51","1KI","7","51","51","Kɛ̀ kí Sulemanu Dii ua zĩi pì kɛ̀ à yã̀a píngi, ben à mↄ̀ kↄ̃n vurao kↄ̃n kondogio kↄ̃n pↄ́ kɛ̀ a de Dauda dìɛ Dii pↄ́ ũunↄ, ben à kà Dii ua auzikikaɛkiin. ");
INSERT INTO bus_vpl VALUES ("K18_1","012_8_1","1KI","8","1","1","Ben kí Sulemanu Isaraili gbɛ̃nsinↄ sìsi Yerusalɛmu, aↄ̃ borii dↄn'aɛdeenↄ kↄ̃n ń uabɛdeenↄ ń píngi, lɛ aↄ̃ mↄ́ wà Dii bà kuunańyo àkpati sɛ́ Dauda wɛ́tɛ kɛ̀ wè be Zayↄn wà suo. ");
INSERT INTO bus_vpl VALUES ("K18_2","012_8_2","1KI","8","2","2","Ben Isarailinↄ kàkↄ̃a à aɛ ń píngi mↄ swɛɛplaade Ɛtanimu zĩbaagurↄↄ zĩ. ");
INSERT INTO bus_vpl VALUES ("K18_3","012_8_3","1KI","8","3","3","Kɛ̀ Isaraili gbɛ̃nsinↄ pɛ̀kↄ̃rɛ ń píngi, ben sa'orinↄ Dii àkpati pì sɛ̀ ");
INSERT INTO bus_vpl VALUES ("K18_4","012_8_4","1KI","8","4","4","kↄ̃n dakↄ̃rɛki kutaao kↄ̃n Dii pↄ́ kɛ̀ kú à guunↄ. Sa'orinↄ kↄ̃n Levi boriinↄ bé wà pↄ́ pìnↄ sɛ̀ wà sùo, ");
INSERT INTO bus_vpl VALUES ("K18_5","012_8_5","1KI","8","5","5","ben kí Sulemanu kↄ̃n Isaraili kɛ̀ aↄ̃ kàkↄ̃a à aɛnↄ saa ò kↄ̃n sãanↄ kↄ̃n zùnↄ àkpati pì aɛ. Pↄ́ kɛ̀ aↄ̃ saa òo pìnↄↄ parii kɛ̀ bíta, èe sí naroro. ");
INSERT INTO bus_vpl VALUES ("K18_6","012_8_6","1KI","8","6","6","Ben sa'orinↄ gɛ̃̀ kↄ̃n Dii bà kuunańyo àkpatio à kpɛ́n ai kpɛ́nɛ kɛ̀ wè be Ludakukiin. Aↄ̃ↄ dìɛ à diɛkiia gwe kɛrubunↄ gĩzĩ. ");
INSERT INTO bus_vpl VALUES ("K18_7","012_8_7","1KI","8","7","7","Kɛrubu pìnↄ dɛ̀bɛnↄↄ poroporona àkpati pì kↄ̃n à sɛ́linↄla. ");
INSERT INTO bus_vpl VALUES ("K18_8","012_8_8","1KI","8","8","8","À sɛ́li pìnↄↄ gbã̀a ai wè ń lɛ́ e Dii kpɛ́ gãnu guu, mↄde wè e ua kparo. Lí pìnↄↄ kú gwe ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("K18_9","012_8_9","1KI","8","9","9","Pↄ́kee kú àkpati pì guuro, tó èe kɛ gbɛ̀ walaa mɛ̀n plaaa kɛ̀ Musa dàn zaa Orɛbu, guu kɛ̀ Dii bè a bà égↄ̃ kú kↄ̃n Isarailinↄ aↄ̃ bↄna Igipiti gbɛraa baasiro. ");
INSERT INTO bus_vpl VALUES ("K18_10","012_8_10","1KI","8","10","10","Kɛ̀ sa'orinↄ bↄ̀ɛ Dii kpɛ́n, tɛ́sukpɛ kpɛ́ pì pà, ");
INSERT INTO bus_vpl VALUES ("K18_11","012_8_11","1KI","8","11","11","aↄ̃ↄe fↄ̃ wà gɛ̃̀ wà ń zĩi kɛ gwero tɛ́sukpɛ pì yãnzi, zaakɛ Dii gakui a kpɛ́ pà. ");
INSERT INTO bus_vpl VALUES ("K18_12","012_8_12","1KI","8","12","12","Ben Sulemanu bè: Dii bè égↄ̃ kú tɛ́sukpɛ siaa guumɛ. ");
INSERT INTO bus_vpl VALUES ("K18_13","012_8_13","1KI","8","13","13","Ben à bè Diinɛ: Ma kpɛ́ naasidee kɛ̀kii bònnɛ, ǹgↄ̃ kú à guu gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("K18_14","012_8_14","1KI","8","14","14","Ben à lìɛ à aɛ dↄ̀ pariia à sa maaa òńnɛ. ");
INSERT INTO bus_vpl VALUES ("K18_15","012_8_15","1KI","8","15","15","Ben à bè: Wà Dii Isarailinↄ Luda sáabu kpá! À lɛ́ gbɛ̃̀ ma de Daudanɛ, ben à pàpa. Zaakɛ à bè, ");
INSERT INTO bus_vpl VALUES ("K18_16","012_8_16","1KI","8","16","16","zaa gurↄↄ kɛ̀ a a gbɛ̃ Isarailinↄ bↄ̀ɛ Igipiti, ée Isaraili wɛ́tɛ ke diɛ wà kpɛ́ bon arero. Daudan a sɛ̀ a gbɛ̃ Isarailinↄ dↄn'aɛdee ũ. ");
INSERT INTO bus_vpl VALUES ("K18_17","012_8_17","1KI","8","17","17","Kɛ̀ ma de Dauda yezi à kpɛ́ bo Dii Isarailinↄ Ludanɛ, ");
INSERT INTO bus_vpl VALUES ("K18_18","012_8_18","1KI","8","18","18","ben Dii bènɛ kpɛ́bonaare lɛ a tↄ́ gↄ̃ kúa laasuu kɛ̀ à kɛ̀ pì maa, ");
INSERT INTO bus_vpl VALUES ("K18_19","012_8_19","1KI","8","19","19","mↄde èe kɛ àpi bé eé boarero, à zĩnda nɛ́ ke bé eé boare. ");
INSERT INTO bus_vpl VALUES ("K18_20","012_8_20","1KI","8","20","20","Ben Dii kɛ̀ lán à à lɛ́ gbɛ̃̀nɛ nà. Ma gↄ̃ ma de Dauda gɛ̃ɛ ũ, ma vɛ̃ɛ Isaraili kpatan lán Dii Isarailinↄ Luda à lɛ́ gbɛ̃̀ nà, ben ma kpɛ́ kɛ̀ bònɛ lɛ à tↄ́ gↄ̃ kúa yãnzi. ");
INSERT INTO bus_vpl VALUES ("K18_21","012_8_21","1KI","8","21","21","Gwen ma Dii àkpati diɛkii kɛ̀kɛn. Dii bà kuuna kↄ̃n wa dezinↄ aↄ̃ bↄna Igipiti gbɛra yã kú à guu. ");
INSERT INTO bus_vpl VALUES ("K18_22","012_8_22","1KI","8","22","22","Sulemanu aɛ dↄ̀ Dii gbãgbãkiia Isaraili kɛ̀ aↄ̃ kakↄ̃ana gweenↄ wáa ń píngi, ben à a ↄↄnↄ sɛ̀ musu ");
INSERT INTO bus_vpl VALUES ("K18_23","012_8_23","1KI","8","23","23","à bè: Dii Isarailinↄ Luda, gbɛ̃ke è sí lɛ́kↄ̃zinyo musu ke tↄↄtɛro. N gbɛ̃kɛɛ guu n bà kú kↄ̃n n zↄ̀bleri kɛ̀ aↄ̃ↄ tɛ́ n zɛ́n kↄ̃n nↄ̀sɛ dooonↄ. ");
INSERT INTO bus_vpl VALUES ("K18_24","012_8_24","1KI","8","24","24","N yã kɛ̀ n à lɛ́ gbɛ̃̀ n zↄ̀bleri ma de Daudanɛ pàpa. Ń ò kↄ̃n lɛ́omɛ yã, gbã̀a san ń pàpa. ");
INSERT INTO bus_vpl VALUES ("K18_25","012_8_25","1KI","8","25","25","Tia sa Dii Isarailinↄ Luda, n lɛ́ gbɛ̃̀ n zↄ̀bleri ma de Daudanɛ n bè, tó à boriinↄ ń zĩnda kũna dↄ̃ bensↄ̃ aↄ̃ↄ tɛ́ n zɛ́n lán à tɛ́zi nà, aↄ̃égↄ̃ kú Isaraili kpatan gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("K18_26","012_8_26","1KI","8","26","26","Isarailinↄ Luda, ǹ tó yã kɛ̀ ń ò n zↄ̀bleri ma de Daudanɛ kɛ yãpuraa ũ sa. ");
INSERT INTO bus_vpl VALUES ("K18_27","012_8_27","1KI","8","27","27","Mↄde Luda, nɛ́gↄ̃ kú tↄↄtɛ kɛ̀ yãpuran yↄ́? Musu kↄ̃n a lezĩkɛɛo é fↄ̃ à n síro, benle kpɛ́ kɛ̀ má bònnɛɛ kɛ̀kii saↄ́? ");
INSERT INTO bus_vpl VALUES ("K18_28","012_8_28","1KI","8","28","28","Dii ma Luda, ǹ làakari dↄ mapi n zↄ̀bleria, ǹ ma aduakɛna kↄ̃n ma agbaakpanannɛɛo sí. Ǹ swã kpá wiii kɛ̀ mapi n zↄ̀bleri mɛ́ɛ pɛɛnziizi kↄ̃n adua kɛ̀ mɛ́ɛ kɛɛmmaao gbã̀a. ");
INSERT INTO bus_vpl VALUES ("K18_29","012_8_29","1KI","8","29","29","Ǹ tó n wɛ́ɛ gↄ̃ pɛna kpɛ́ kɛ̀kiia gwãavĩ kↄ̃n fãantɛ̃o, guu kɛ̀ n bè n tↄ́ égↄ̃ kúa kɛ̀kii pì. Ǹ adua kɛ̀ mapi n zↄ̀bleri mɛɛ̀ kɛɛ aɛdↄna guu kɛ̀kiia ma. ");
INSERT INTO bus_vpl VALUES ("K18_30","012_8_30","1KI","8","30","30","Tó mapi n zↄ̀bleri ke n gbɛ̃ Isarailinↄ aɛ dↄ̀ guu kɛ̀kiia, tó wa wɛ́ɛ kɛ̀mma, ǹgae wa wɛ́ɛkɛna sí zaa n kúkiia musu ǹ sùu kɛwao. ");
INSERT INTO bus_vpl VALUES ("K18_31","012_8_31","1KI","8","31","31","Tó gbɛ̃ taari kɛ̀ a gbɛ̃daaanɛ, ben wà bènɛ à la da, tó à mↄ̀ à la dà n gbãgbãkii kɛ̀ aɛ, ");
INSERT INTO bus_vpl VALUES ("K18_32","012_8_32","1KI","8","32","32","ǹgae zɛńyo zaa n kúkiia musu ǹ ↄdↄańnɛ. Ǹgae yã gↄ̃gↄ̃ n zↄ̀blerinↄnɛ ǹ yã da taarideela, lɛ à yãkɛna wí à musu ǹ yã nnaa kpá taarisaideea, lɛ wà e wà dↄ̃ kɛ̀ à yãke vĩro. ");
INSERT INTO bus_vpl VALUES ("K18_33","012_8_33","1KI","8","33","33","Tó n gbɛ̃ Isarailinↄ ibɛɛnↄ zĩ̀ blèḿma durun kɛ̀ aↄ̃ↄ kɛ̀nnɛ yãnzi, aↄ̃ tàńyo, tó aↄ̃ ɛ̀ara wà aɛ dↄ̀mma wà n sisi, tó aↄ̃ wɛ́ɛ kɛ̀mma wà agbaa kpànnɛ kpɛ́ kɛ̀kiia, ");
INSERT INTO bus_vpl VALUES ("K18_34","012_8_34","1KI","8","34","34","zaa n kúkiia musu ǹgae zɛńyo ǹ sùu kɛńyo kↄ̃n ń durunnↄ, ǹ ɛarańyo bùsu kɛ̀ ń kpà ń dezinↄa kɛ̀kii pì guu. ");
INSERT INTO bus_vpl VALUES ("K18_35","012_8_35","1KI","8","35","35","Tó ludambɛɛ gↄ̃̀ da wáawaa, lou gì mazi kɛ̀ aↄ̃ durun kɛ̀nnɛ yãnzi, tó aↄ̃ aɛ dↄ̀ guu kɛ̀kiia aↄ̃ wɛ́ɛ kɛ̀mma aↄ̃ n sisi, bensↄ̃ aↄ̃ kpɛɛ lì ń durunnɛ kɛ̀ n wɛ́ɛ tã̀ḿma yãnzi, ");
INSERT INTO bus_vpl VALUES ("K18_36","012_8_36","1KI","8","36","36","zaa n kúkiia musu ǹgae zɛńyo ǹ sùu kɛńyo kↄ̃n ń durunnↄ. Ǹgae ń da zɛ́ maaan, nɛ́ tó lou ma n bùsu kɛ̀ ń kpà n gbɛ̃nↄa aↄ̃ pↄ́ ũu kɛ̀ guu. ");
INSERT INTO bus_vpl VALUES ("K18_37","012_8_37","1KI","8","37","37","Tó dekaa ke gagyãa kà bùsu kɛ̀n, ke pↄ́wɛɛpↄ̃si ke pↄ́pukpana ke sutɛ̃nↄ ke kwaanↄ ke tó ibɛɛnↄ lìga ń wɛ́tɛ kezi ke tó mↄ́nzi ke gyãa gɛ̃̀ ń tɛ́, ");
INSERT INTO bus_vpl VALUES ("K18_38","012_8_38","1KI","8","38","38","tó aↄ̃ gbɛ̃ke yã kɛ̀ à a lee dↄ̃̀, tó à a ↄↄ dↄ̀ kpɛ́ kɛ̀kii kpa, tó à wɛ́ɛ kɛ̀mma à agbaa kpànnɛ, ");
INSERT INTO bus_vpl VALUES ("K18_39","012_8_39","1KI","8","39","39","zaa n kúkiia musu ǹgae zɛo ǹ sùu kɛo, nɛ́ dↄàlɛ. Ǹgae fĩa bonɛ a yãkɛnaa, zaakɛ ń à nↄ̀sɛ dↄ̃. Ḿbe ń baade píngi nↄ̀sɛ dↄ̃. ");
INSERT INTO bus_vpl VALUES ("K18_40","012_8_40","1KI","8","40","40","Lɛn aↄ̃égↄ̃ vĩa kɛɛnnɛ lɛ ai ń wɛ̃̀ndi lɛ́n bùsu kɛ̀ ń kpà ń dezinↄa kɛ̀ guu. ");
INSERT INTO bus_vpl VALUES ("K18_41","012_8_41","1KI","8","41","42","Zaakɛ weé n tↄ́ bíta kↄ̃n n gã̀sã gbãaao kↄ̃n n ↄↄ kɛ̀ poronao baaru ma, tó gbɛ̃ zĩ̀tↄ kɛ̀ dɛ n gbɛ̃ Isaraili borii ũroo bↄ̀ bùsu zã̀azãn à mↄ̀ n tↄ́ yãnzi, tó à aɛ dↄ̀ kpɛ́ kɛ̀a à wɛ́ɛ kɛ̀mma, ");
INSERT INTO bus_vpl VALUES ("K18_43","012_8_43","1KI","8","43","43","zaa n kúkiia musu ǹgae zɛo ǹ yã kɛ̀ à wɛ́ɛ kɛ̀mmaa kɛnɛ, lɛ anduna bori píngi e à n tↄ́ dↄ̃, wà vĩa kɛnnɛ lán n gbɛ̃ Isarailinↄ è kɛnnɛ nà, aↄ̃égↄ̃ dↄ̃ kɛ̀ n tↄ́ kú kpɛ́ kɛ̀ má bò kɛ̀a. ");
INSERT INTO bus_vpl VALUES ("K18_44","012_8_44","1KI","8","44","44","Tó n gbɛ̃nↄ bↄ̀ɛ wà gàa zĩ̀ ká kↄ̃n ń ibɛɛnↄ, baa guu kɛ̀ n ń zĩn píngi, tó aↄ̃ aɛ dↄ̀ wɛ́tɛ kɛ̀ ń sɛ̀ kɛ̀a kↄ̃n kpɛ́ kɛ̀ má bònnɛɛ kɛ̀o, tó aↄ̃ wɛ́ɛ kɛ̀mma, ");
INSERT INTO bus_vpl VALUES ("K18_45","012_8_45","1KI","8","45","45","zaa n kúkiia musu ǹgae zɛńyo agbaa kɛ̀ aↄ̃ↄ kpànnɛ yãnzi, ǹ yã nnaa kpáḿma. ");
INSERT INTO bus_vpl VALUES ("K18_46","012_8_46","1KI","8","46","46","Zaakɛ gbɛ̃ke è gí durun kɛziro, tó aↄ̃ durun kɛ̀nnɛ, tó n pↄ fɛ̃̀ńzi n ń ná ń ibɛɛnↄnɛ ń ↄzĩ, tó aↄ̃ tàńyo ń bùsun zĩ̀zↄnↄ ũ bùsu zã̀azã ke à kĩin yoo, ");
INSERT INTO bus_vpl VALUES ("K18_47","012_8_47","1KI","8","47","47","tó aↄ̃ nↄ̀sɛ lìɛ bùsu kɛ̀ aↄ̃ↄe zↄ̀ bleen pì guu, tó aↄ̃ ɛ̀ara wà agbaa kpànnɛ gwe wà bè: Wa durun kɛ̀, wa taari kɛ̀, wa yã zaaa kɛ̀, ");
INSERT INTO bus_vpl VALUES ("K18_48","012_8_48","1KI","8","48","48","tó aↄ̃ aɛ dↄ̀mma kↄ̃n nↄ̀sɛo do kↄ̃n pↄyezinao píngi zaa bùsu kɛ̀ aↄ̃ↄe zↄ̀ bleen ń ibɛɛnↄnɛ pì guu, tó aↄ̃ aɛ dↄ̀ bùsu kɛ̀ ń kpà ń dezinↄa kↄ̃n wɛ́tɛ kɛ̀ ń sɛ̀o kↄ̃n kpɛ́ kɛ̀ má bònnɛɛ kɛ̀oa, tó aↄ̃ wɛ́ɛ kɛ̀mma, ");
INSERT INTO bus_vpl VALUES ("K18_49","012_8_49","1KI","8","49","49","zaa n kúkiia musu ǹgae zɛńyo agbaa kɛ̀ aↄ̃ↄ kpànnɛ yãnzi, ǹ yã nnaa kpáḿma. ");
INSERT INTO bus_vpl VALUES ("K18_50","012_8_50","1KI","8","50","50","Ǹgae sùu kɛ kↄ̃n n gbɛ̃ kɛ̀ aↄ̃ durun kɛ̀nnɛɛnↄ kↄ̃n taari kɛ̀ aↄ̃ↄ kɛ̀o, ǹ tó gbɛ̃ kɛ̀ aↄ̃ↄe zↄ̀ bleeńnɛnↄ ń wɛ̃nda gwa, ");
INSERT INTO bus_vpl VALUES ("K18_51","012_8_51","1KI","8","51","51","zaakɛ n pↄ́vĩnanↄmɛ, n gbɛ̃ kɛ̀ n ń bↄ́ɛ Igipitinↄ wɛ́ɛtãmma pãsĩ guunↄmɛ. ");
INSERT INTO bus_vpl VALUES ("K18_52","012_8_52","1KI","8","52","52","Ǹ tó n wɛ́ɛ gↄ̃ kú mapi n zↄ̀bleria, ǹ swã kpá agbaa kɛ̀ má kpànnɛɛzi kↄ̃n agbaa kɛ̀ n gbɛ̃ Isarailinↄ kpànnɛɛo. Ǹ swã kpáńzi gurↄↄ kɛ̀ aↄ̃ wii pɛ̀nzi píngi. ");
INSERT INTO bus_vpl VALUES ("K18_53","012_8_53","1KI","8","53","53","Dii Luda, zaakɛ anduna bori píngi guu aↄ̃pinↄn n ń sɛ́ n gbɛ̃nↄ ũ, lán ń ò n zↄ̀bleri Musa gãzĩ nà gurↄↄ kɛ̀ n wa dezinↄ bↄ̀ɛ Igipiti. ");
INSERT INTO bus_vpl VALUES ("K18_54","012_8_54","1KI","8","54","54","Gurↄↄ kɛ̀ Sulemanu e wɛ́ɛ kɛɛ Diia, à kuɛna a kosooamɛ kↄ̃n à ↄↄnↄo porona musu. Kɛ̀ à adua kɛ̀ à yã̀a, ben à fɛ̀ɛ à zɛ̀ Dii gbãgbãkiia gwe, ");
INSERT INTO bus_vpl VALUES ("K18_55","012_8_55","1KI","8","55","55","ben à sa maaa ò Isaraili kɛ̀ aↄ̃ↄ kú gweenↄnɛ ń píngi, à ò gbãngbãn à bè: ");
INSERT INTO bus_vpl VALUES ("K18_56","012_8_56","1KI","8","56","56","Wà Dii sáabu kpá, zaakɛ à wamↄwa a gbɛ̃ Isarailinↄ gbà ĩampakii lán à ò nà. Yã maaa kɛ̀ à à lɛ́ gbɛ̃̀ a zↄ̀bleri Musa gãzĩnↄ pàpa píngi, à kee e lɛ́ɛ pãro. ");
INSERT INTO bus_vpl VALUES ("K18_57","012_8_57","1KI","8","57","57","Dii wa Luda gↄ̃ kúwao, lán à kú kↄ̃n wa dezinↄo nà. Àton wa tónlo, àton pã kpáwaziro. ");
INSERT INTO bus_vpl VALUES ("K18_58","012_8_58","1KI","8","58","58","À tó wà swɛ̃̀ gↄ̃ kúawa wàgↄ̃ tɛ́ à zɛ́n, wàgↄ̃ à yãdiɛnanↄ kũna kↄ̃n yã kɛ̀ à dà wa dezinↄnɛnↄ, wàgↄ̃ à ↄdↄkii gwaa. ");
INSERT INTO bus_vpl VALUES ("K18_59","012_8_59","1KI","8","59","59","Adua kɛ̀ má kɛ̀ Dii wa Ludaa gↄ̃ dↄn fãantɛ̃ kↄ̃n gwãavĩo. Àgↄ̃ yã nnaa kpá mamↄma a zↄ̀bleria kↄ̃n a gbɛ̃ Isarailinↄ lán guu e dↄↄ nà, ");
INSERT INTO bus_vpl VALUES ("K18_60","012_8_60","1KI","8","60","60","anduna bori píngi é à dↄ̃ kɛ̀ Dii nɛ́ Ludamɛ, à pãndee kuuro. ");
INSERT INTO bus_vpl VALUES ("K18_61","012_8_61","1KI","8","61","61","À kũ̀ à a swɛ̃̀ kpá Dii wa Ludaa mámmam, àgↄ̃ à ↄdↄkii gwaa, àgↄ̃ à yãdiɛnanↄ kũna lán á kũna gbã̀a nà. ");
INSERT INTO bus_vpl VALUES ("K18_62","012_8_62","1KI","8","62","62","Ben kína kↄ̃n Isarailinↄ ń píngi saa ò Diia. ");
INSERT INTO bus_vpl VALUES ("K18_63","012_8_63","1KI","8","63","63","Sulemanu kɛnnakↄ̃o saa ò Diia kↄ̃n zùnↄ bↄrↄ baro awɛɛplaa kↄ̃n sãanↄ bↄrↄ baswɛɛdo. Lɛn kína kↄ̃n Isarailinↄ ń píngi Dii ua kya kɛ̀ lɛ. ");
INSERT INTO bus_vpl VALUES ("K18_64","012_8_64","1KI","8","64","64","Zĩ pìa kína gbãsĩ gò ua kɛ̀ kú Dii kpɛ́ aɛa, ben à sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ ò gwe kↄ̃n pↄ́wɛɛ gbaao kↄ̃n kɛnnakↄ̃o sa nↄ́sio, zaakɛ sa'okii kɛ̀ à kɛ̀ kↄ̃n mↄ̀gotɛ̃o kɛ̀ kú Dii kpɛ́ aɛ bítaro, èe fↄ̃ à sì píngiro. ");
INSERT INTO bus_vpl VALUES ("K18_65","012_8_65","1KI","8","65","65","Zĩ beeea Sulemanu kↄ̃n Isarailinↄ ń píngi zĩbaa kɛ̀ Dii ń Ludanɛ ai gurↄ swɛɛplaa, ben aↄ̃ Kutadↄna zĩbaa kɛ̀ gurↄ swɛɛplaa dↄ. À píngi kɛ̀ gurↄ gɛ̃ro dosai. Wà pari maamaa, wà bↄ̀ zaa Lebo Amata ai à gàa pɛ́ Igipiti gulɛzɛki swaaa. ");
INSERT INTO bus_vpl VALUES ("K18_66","012_8_66","1KI","8","66","66","À gurↄ sↄraagↄ̃dee zĩ à ń gbáɛ, ben aↄ̃ lɛ́ zàa aↄ̃ tà ń bɛ kↄ̃n pↄnnaao. Aↄ̃ pↄↄ kɛ̀ nna yã maaa kɛ̀ Dii kɛ̀ a zↄ̀bleri Dauda kↄ̃n a gbɛ̃ Isarailinↄnɛ píngi yãnzi. ");
INSERT INTO bus_vpl VALUES ("K19_1","012_9_1","1KI","9","1","1","Kɛ̀ Sulemanu Dii ua kàɛ à yã̀a kↄ̃n a uao kↄ̃n zĩi kɛ̀ à pↄↄ kúanↄ píngi, ");
INSERT INTO bus_vpl VALUES ("K19_2","012_9_2","1KI","9","2","2","ben Dii ɛ̀ara à bↄ̀ à mↄ̀zi à gɛ̃̀n plaadeeo lán à bↄ̀ à mↄ̀zi Gibiↄ̃ nà ");
INSERT INTO bus_vpl VALUES ("K19_3","012_9_3","1KI","9","3","3","à bènɛ: Ma adua kɛ̀ ń kɛ̀ kↄ̃n agbaa kɛ̀ ń kpàmɛɛo mà. Ma kpɛ́ kɛ̀ ń bò pì dìɛ ma pↄ́ ũ, ma tↄ́ égↄ̃ kúa yãana sai. Ma wɛ́ɛ égↄ̃ kúa, ma pↄↄ égↄ̃ kúa. ");
INSERT INTO bus_vpl VALUES ("K19_4","012_9_4","1KI","9","4","4","Mpi sↄ̃, tó ń tɛ́ ma zɛ́n súusu kↄ̃n nↄ̀sɛ puraao lán n de Dauda bà, tó ń yã kɛ̀ má dìɛnnɛɛnↄ kũna kↄ̃n ma yã'onnɛnanↄ, tó nɛ́ɛ ma ↄdↄkii gwaa, ");
INSERT INTO bus_vpl VALUES ("K19_5","012_9_5","1KI","9","5","5","mɛ́ n kpata kãsãa pɛ́ɛ Isarailinↄ tɛ́, eégↄ̃ yãana vĩro, lán ma à lɛ́ gbɛ̃̀ n de Daudanɛ nà, ma bè à boriinↄ égↄ̃ kú Isaraili kpatan gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("K19_6","012_9_6","1KI","9","6","6","Tó mpi ke n nɛ́nↄ kpɛɛ lìmɛ sↄ̃, tó á ma dokayãnↄ kↄ̃n yã kɛ̀ má dìɛareenↄ kũnaro, tó a gaa a dↄ tãanↄzi ai ée ń gbãgbãa, ");
INSERT INTO bus_vpl VALUES ("K19_7","012_9_7","1KI","9","7","7","mɛ́ Isarailinↄ bↄɛ bùsu kɛ̀ má kpàḿman, mɛ́ gí kpɛ́ kɛ̀ má dìɛ ma pↄ́ ũu pìzi, aↄ̃é gↄ̃ fabona pↄ́ ũ, pena pↄ́ ũ bori pínginɛ. ");
INSERT INTO bus_vpl VALUES ("K19_8","012_9_8","1KI","9","8","8","Baa kↄ̃n kpɛ́ pì naasikɛɛo, à yã é bↄ gbɛ̃ kɛ̀ aↄ̃ↄe gɛ̃tɛɛ à saɛnↄ saɛ. Aↄ̃é sio gá wà be: À kɛ̀ dia Dii kɛ̀ bùsu kɛ̀ kↄ̃n kpɛ́ kɛ̀onɛ lɛɛ? ");
INSERT INTO bus_vpl VALUES ("K19_9","012_9_9","1KI","9","9","9","Weé beńnɛ: Kɛ̀ aↄ̃ pã kpà Dii ń Luda kɛ̀ à ń dezinↄ bↄ̀ɛ Igipitizi yãnzimɛ. Aↄ̃ zɛ̀ kↄ̃n tãanↄ, aↄ̃ↄe ń gbãgbãa aↄ̃ↄe kuɛɛńnɛ. Beee yãnzin Dii mↄ́nzi beee kpàńzi píngizi. ");
INSERT INTO bus_vpl VALUES ("K19_10","012_9_10","1KI","9","10","10","Sulemanu ua mɛ̀n plaaa pìnↄ kàɛ wɛ̃̀ baromɛ, Dii ua kↄ̃n à zĩnda uao. Beee gbɛran ");
INSERT INTO bus_vpl VALUES ("K19_11","012_9_11","1KI","9","11","11","à Galili bùsu wɛ́tɛ kpà Taya kí Hiramua mɛ̀n baro, zaakɛ Hiramu sida lí kↄ̃n pini lío kↄ̃n vurao kpàa lán à yezi nà. ");
INSERT INTO bus_vpl VALUES ("K19_12","012_9_12","1KI","9","12","12","Kɛ̀ Hiramu bↄ̀ Taya à gàa à wɛ́tɛ kɛ̀ Sulemanu kpàawaanↄ gwà, èe kɛnɛro, ");
INSERT INTO bus_vpl VALUES ("K19_13","012_9_13","1KI","9","13","13","ben à bè: Ma gbɛ̃, wɛ́tɛ kparee takanↄn ń kpàma gwee? Ben wà tↄ́ kpà guu pìnɛ Kabulu ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("K19_14","012_9_14","1KI","9","14","14","Hiramu gĩakɛ à vura kpã̀sã Sulemanunɛ yã tↄn siigↄ̃. ");
INSERT INTO bus_vpl VALUES ("K19_15","012_9_15","1KI","9","15","15","Gbɛ̃ kɛ̀ Sulemanu ń dá zↄ̀zĩinnↄ yãn yɛ̀. Gbɛ̃ pìnↄ bé wà Dii ua kↄ̃n Sulemanu uao zĩi kɛ̀. Aↄ̃ Milo wɛ̀ɛ tàta kↄ̃n bùsuo, aↄ̃ Yerusalɛmu bĩi bò, aↄ̃ ɛ̀ara wà Azo kↄ̃n Mɛgidoo kↄ̃n Gɛzao kɛ̀kɛ wà kàɛ. ");
INSERT INTO bus_vpl VALUES ("K19_16","012_9_16","1KI","9","16","16","Igipiti kí Fili'auna lɛ̀ɛ Gɛza pìa yã, ben à sì à tɛ́ sↄ̃̀a à Kanaa kɛ̀ aↄ̃ↄ kú à guunↄ dɛ̀dɛ, ben à kpà a nɛ́nↄgbɛ̃a zãkɛna gbaa ũ gurↄↄ kɛ̀ à à kpã̀sã Sulemanua. ");
INSERT INTO bus_vpl VALUES ("K19_17","012_9_17","1KI","9","17","17","Ben Sulemanu ɛ̀ara à Gɛza pì kɛ̀kɛ à kàɛ kↄ̃n Bɛtoroni gĩzĩ pↄ́o ");
INSERT INTO bus_vpl VALUES ("K19_18","012_9_18","1KI","9","18","18","kↄ̃n Baalao kↄ̃n Tadamↄ kɛ̀ kú à bùsu gbáan-o ");
INSERT INTO bus_vpl VALUES ("K19_19","012_9_19","1KI","9","19","19","kↄ̃n wɛ́tɛ kɛ̀ à kũsãɛ kàɛnnↄ kↄ̃n wɛ́tɛ kɛ̀ à sↄ̃goronↄ kↄ̃n à sↄ̃nↄↄ kúnnↄ kↄ̃n kpɛ́ kɛ̀ à yezi à dↄ Yerusalɛmunↄ kↄ̃n Lɛbanↄo kↄ̃n bùsu kɛ̀ èe kí bleeanↄ píngi. ");
INSERT INTO bus_vpl VALUES ("K19_20","012_9_20","1KI","9","20","20","Borii kɛ̀ aↄ̃ↄ dɛ Isaraili ũroonↄ: Amↄrinↄ, Itinↄ, Pɛrizinↄ, Ivinↄ kↄ̃n Yebusi kɛ̀ aↄ̃ gↄ̃̀nↄ ń píngi, ");
INSERT INTO bus_vpl VALUES ("K19_21","012_9_21","1KI","9","21","21","gbɛ̃ kɛ̀ Isarailinↄↄ e fↄ̃ wà ń dɛdɛroonↄ, aↄ̃ borii kɛ̀ aↄ̃ gↄ̃̀ ń bùsu pìnnↄn Sulemanu ń dá zↄ̀zĩin, ben aↄ̃ègↄ̃ zĩi pì kɛɛ lɛ ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("K19_22","012_9_22","1KI","9","22","22","Èe Isarailinↄ da zↄ̀zĩinlo. Aↄ̃mbe à ń díɛ a zĩ̀kpɛɛnↄ ũ, a ìbanↄ, a kína daanↄ, a gbɛ̃nↄ dↄn'aɛdeenↄ, a sↄ̃gorodeenↄ, a sↄ̃deenↄ. ");
INSERT INTO bus_vpl VALUES ("K19_23","012_9_23","1KI","9","23","23","Aↄ̃mbe zĩi kɛ̀ wèe kɛɛ pì gbɛ̃nsinↄ ũ dↄ, aↄ̃ↄ gↄ̃ↄn wàa plaa kpɛ́ baswɛɛplaa akuri. ");
INSERT INTO bus_vpl VALUES ("K19_24","012_9_24","1KI","9","24","24","Kɛ̀ Fili'auna nɛ́nↄgbɛ̃ bↄ̀ Dauda wɛ́tɛ à tà a kpɛ́ kɛ̀ Sulemanu bònɛn, à gbɛran Sulemanu Milo wɛ̀ɛ tàta. ");
INSERT INTO bus_vpl VALUES ("K19_25","012_9_25","1KI","9","25","25","Wɛ̃̀ kↄ̃n wɛ̃̀o Sulemanu ègↄ̃ saa oo gɛ̃̀n aagↄ̃gↄ̃. È sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ kↄ̃n kɛnnakↄ̃o sa'opↄo o sa'okii kɛ̀ à bò Diinɛa, è tuaetiti kpata Dii aɛ gwe dↄ. Lɛn à Dii ua zĩinↄ kɛ̀ lɛ mámmam. ");
INSERT INTO bus_vpl VALUES ("K19_26","012_9_26","1KI","9","26","26","Kí Sulemanu góro'itɛnↄ kɛ̀ Ɛziↄ̃ Gɛba Elata saɛ Ɛdↄmunↄ bùsun Isia Tɛ̃a lɛ́a. ");
INSERT INTO bus_vpl VALUES ("K19_27","012_9_27","1KI","9","27","27","Hiramu a górodee kɛ̀ aↄ̃ ísiaa dↄ̃ↄnↄ zĩ̀, ben aↄ̃ dà ísiaala lɛdo kↄ̃n Sulemanu gbɛ̃nↄ. ");
INSERT INTO bus_vpl VALUES ("K19_28","012_9_28","1KI","9","28","28","Aↄ̃ gàa Ofi, aↄ̃ vura sɛ̀ɛ gwe tↄn gɛ̃ro aↄ̃ sùo kí Sulemanunɛ. ");
INSERT INTO bus_vpl VALUES ("K110_1","012_10_1","1KI","10","1","1","Kɛ̀ Seba bùsu kína kɛ̀ dɛ nↄgbɛ̃ ũu mà lán Sulemanu tↄ́ bↄ̀ nà Dii yã musu, ben à mↄ̀ à yↄ̃ à gwa kↄ̃n yãgbekana zĩ'ũuo. ");
INSERT INTO bus_vpl VALUES ("K110_2","012_10_2","1KI","10","2","2","À kà Yerusalɛmu kↄ̃n a ìbanↄ paripari kↄ̃n pↄ́ gũ nnannaanↄ kↄ̃n vura sà bítao kↄ̃n gbɛ̀ bɛ̀ɛdee kɛ̀ lakuminↄ sɛnanↄ, ben à gàa Sulemanu kiia à yã kɛ̀ kú a nↄ̀sɛ guu fàadi bòo píngi. ");
INSERT INTO bus_vpl VALUES ("K110_3","012_10_3","1KI","10","3","3","Ben Sulemanu yã kɛ̀ à làlaanↄ bↄ̀kↄ̃tɛnɛ píngi. À ke bↄkↄ̃tɛna e à furo. ");
INSERT INTO bus_vpl VALUES ("K110_4","012_10_4","1KI","10","4","4","Kɛ̀ nↄgbɛ̃ pì Sulemanu ↄ̃ndↄ̃yãnↄ mà píngi, bensↄ̃ à à bɛɛ kɛ̀ à bò è ");
INSERT INTO bus_vpl VALUES ("K110_5","012_10_5","1KI","10","5","5","kↄ̃n pↄ́blee kɛ̀ è bleenↄ kↄ̃n à ìbanↄ gwenao kↄ̃n à bɛ zĩkɛrinↄ kuunao kↄ̃n ń pↄ́kãsãanↄ kↄ̃n à wɛ̃kpaatɛrinↄ kↄ̃n sa'opↄ kɛ̀ wè ká tɛ́n à tɛ́ kũ kɛ̀ à ò Dii uanↄ, yã pì à kũ̀ gbãa, ben à lɛ́ àɛ. ");
INSERT INTO bus_vpl VALUES ("K110_6","012_10_6","1KI","10","6","6","Ben à bè kínanɛ: N yãkɛnanↄ kↄ̃n n ↄ̃ndↄ̃ baaru kɛ̀ má mà zaa ma bùsun-o nɛ́ yãpuramɛ. ");
INSERT INTO bus_vpl VALUES ("K110_7","012_10_7","1KI","10","7","7","Mɛ́ɛ yã pìnↄ síro ai ma gaa ma kao kɛ̀, ben ma wɛ́ɛ sìàlɛ sa. Wèe omɛ píngi sero fá! N ↄ̃ndↄ̃ kↄ̃n n auzikinↄↄ dɛ lán ma à baaru mà nàla zã̀. ");
INSERT INTO bus_vpl VALUES ("K110_8","012_10_8","1KI","10","8","8","Mìnnadeenↄn n gbɛ̃nↄ ũ kↄ̃n n ìba kɛ̀ aↄ̃ègↄ̃ kúnyo gurↄ píngi, aↄ̃gↄ̃ n ↄ̃ndↄ̃yã maanↄ! ");
INSERT INTO bus_vpl VALUES ("K110_9","012_10_9","1KI","10","9","9","Wà Dii n Luda sáabu kpá, zaakɛ n yã kànɛ, ben à n ka Isarailinↄ kín. Yenzi kɛ̀ Dii vĩ kↄ̃n Isarailinↄ gurↄ píngi bé à tò à n ka kí ũzi, lɛ ǹgↄ̃ yã gↄ̃gↄ̃ↄńnɛ a zɛ́a. ");
INSERT INTO bus_vpl VALUES ("K110_10","012_10_10","1KI","10","10","10","Ben nↄgbɛ̃ pì kína gbà vura tↄn siigↄ̃ kↄ̃n pↄ́ gũ nnannaanↄ paripari maamaa kↄ̃n gbɛ̀ bɛ̀ɛdeenↄ. Pↄ́ gũ nnannaa kɛ̀ à kí Sulemanu gbà pìnↄ bíta, gbɛ̃kee e mↄ́onɛ à kà lɛ ziki dↄro. ");
INSERT INTO bus_vpl VALUES ("K110_11","012_10_11","1KI","10","11","11","Hiramu góro'itɛ kɛ̀ aↄ̃ sù kↄ̃n Ofio kↄ̃n vuraonↄ sù kↄ̃n lí bɛ̀ɛdeenↄ maamaa kↄ̃n gbɛ̀ bɛ̀ɛdeenↄ dↄ. ");
INSERT INTO bus_vpl VALUES ("K110_12","012_10_12","1KI","10","12","12","Ben kína Dii ua pↄ́nↄ kɛ̀o kↄ̃n a zĩnda bɛ pↄ́nↄ, à mↄrↄnↄ kↄ̃n kúunↄ kɛ̀o lɛ̀sirinↄnɛ dↄ. Wèe mↄ́ kↄ̃n lí pì boriio à kà lɛ ziki dↄro, wèe wɛ́ɛ si à takalɛ dↄro ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("K110_13","012_10_13","1KI","10","13","13","Pↄ́ kɛ̀ Seba bùsu kína pì yezi píngi à gbèka kí Sulemanua, ben à à gbà, gbaa kɛ̀ à kɛ̀nɛ yↄ̃nkↄyↄ̃nkↄnↄ baasi. Ben à ɛ̀ara à tà a bùsun kↄ̃n a ìbanↄ. ");
INSERT INTO bus_vpl VALUES ("K110_14","012_10_14","1KI","10","14","14","Vura kɛ̀ è gɛ̃ Sulemanuzi wɛ̃̀ kↄ̃n wɛ̃̀o è ká tↄn baro awɛɛ'aagↄ̃, ");
INSERT INTO bus_vpl VALUES ("K110_15","012_10_15","1KI","10","15","15","tángba kɛ̀ táa'orinↄ kↄ̃n latarinↄ kↄ̃n Larubu kínanↄ kↄ̃n a bùsu gbɛ̃nsinↄ è mↄ́onɛ baasi. ");
INSERT INTO bus_vpl VALUES ("K110_16","012_10_16","1KI","10","16","16","À sɛngbango bítanↄ kɛ̀ kↄ̃n vura kɛ̀ wà gbɛ̃̀gbɛ̃o mɛ̀n wàa do, aↄ̃ baade tìisi kà kiloo aagↄ̃gↄ̃ kↄ̃n a kusuo. ");
INSERT INTO bus_vpl VALUES ("K110_17","012_10_17","1KI","10","17","17","À sɛngbango nɛ́ngonↄ kɛ̀o dↄ, aↄ̃ baade tìisi yezi à ká kiloo plaplaa. À sɛngbango pìnↄ kàɛ kpɛ́ kɛ̀ wè be Lɛbanↄ Líkpɛn. ");
INSERT INTO bus_vpl VALUES ("K110_18","012_10_18","1KI","10","18","18","Kína kíblekita bíta kɛ̀ kↄ̃n wesa swaao, ben à vura atɛ̃ɛ kùɛa. ");
INSERT INTO bus_vpl VALUES ("K110_19","012_10_19","1KI","10","19","19","Kìta pì didikii vĩ, à gbápɛɛkii mɛ̀n swɛɛdo. À kpɛɛnaki musu dɛ mↄ̀ↄↄ gooda sai. À gã̀sãdikiinↄ vĩ, músu taka kɛ̀ wà kɛ̀nↄↄ zɛzɛna gã̀sãdikii pìnↄ saɛ. ");
INSERT INTO bus_vpl VALUES ("K110_20","012_10_20","1KI","10","20","20","Músu pìnↄↄ zɛzɛna gbápɛɛkii pìnↄa kpa plaplaa, à píngi kà kuri awɛɛplaa. Wèe kìta pì taka kɛ bùsu ken zikiro. ");
INSERT INTO bus_vpl VALUES ("K110_21","012_10_21","1KI","10","21","21","Kí Sulemanu togoonↄ nɛ́ vuramɛ píngi. Kpɛ́ kɛ̀ wè be Lɛbanↄ Líkpɛ pↄ́nↄ píngi nɛ́ vuramɛ atɛ̃ɛ. Kondogi pↄ́kee kú gwero, zaakɛ wè kondogi diɛ pↄ́ke ũ Sulemanu gurↄↄaro. ");
INSERT INTO bus_vpl VALUES ("K110_22","012_10_22","1KI","10","22","22","Kína góro'itɛnↄ ègↄ̃ dana ísiaala kↄ̃n Hiramu góronↄ. Wɛ̃̀ aagↄ̃ píngi aↄ̃ègↄ̃ suu kↄ̃n vurao kↄ̃n kondogio kↄ̃n wesa swaao kↄ̃n gbakũnↄ kↄ̃n zã̀nↄ. ");
INSERT INTO bus_vpl VALUES ("K110_23","012_10_23","1KI","10","23","23","Kí Sulemanu auziki kↄ̃n à ↄ̃ndↄ̃ↄo bíta dɛ anduna kínanↄ pↄ́la ń píngi. ");
INSERT INTO bus_vpl VALUES ("K110_24","012_10_24","1KI","10","24","24","Baade píngi e zɛ́ wɛtɛɛ à wɛ́ɛ si Sulemanulɛ à à ↄ̃ndↄ̃yã kɛ̀ Ludaa dànɛ à swɛ̃̀n ma. ");
INSERT INTO bus_vpl VALUES ("K110_25","012_10_25","1KI","10","25","25","Wɛ̃̀ píngi baade ègↄ̃ mↄↄnɛ kↄ̃n a gbaao: Kondogi pↄ́nↄ, vura pↄ́nↄ, utanↄ, gↄ̃kɛbↄnↄ, pↄ́ gũ nnannaanↄ, sↄ̃nↄ kↄ̃n bãagãsↄ̃nↄ. ");
INSERT INTO bus_vpl VALUES ("K110_26","012_10_26","1KI","10","26","26","Sulemanu sↄ̃goronↄ kↄ̃n sↄ̃nↄ kàkↄ̃a. À sↄ̃goro pìnↄ kà wàa swɛɛplaa, à sↄ̃nↄ sↄ̃ bↄrↄ kuri awɛɛplaa. Wè à sↄ̃ pìnↄ gwa à sↄ̃goro wɛ́tɛnↄ guu kↄ̃n à bɛ Yerusalɛmuo. ");
INSERT INTO bus_vpl VALUES ("K110_27","012_10_27","1KI","10","27","27","Kína tò kondogi gↄ̃ di Yerusalɛmu lán gbɛ̀ bà, bensↄ̃ sida lí kɛ̀ wè kpɛ́ dↄo pari lán bɛ̀tɛ lí bà sɛ̃̀n. ");
INSERT INTO bus_vpl VALUES ("K110_28","012_10_28","1KI","10","28","28","Wè bↄ kↄ̃n Sulemanu sↄ̃ pìnↄ zaa Igipiti kↄ̃n Silisia bùsuomɛ. Kína latarinↄ bé wè gá lúlu gwe. ");
INSERT INTO bus_vpl VALUES ("K110_29","012_10_29","1KI","10","29","29","Aↄ̃è sↄ̃goronↄ lúlu Igipiti kondogi ↄↄ mɛ̀n wàa aagↄ̃mɛ, sↄ̃nↄ sↄ̃ mɛ̀n baswɛɛplaa akuri, ben è ɛara à sↄ̃ pìnↄ yá Iti kínanↄa kↄ̃n Sirianↄ kínanↄ. ");
INSERT INTO bus_vpl VALUES ("K111_1","012_11_1","1KI","11","1","1","Kí Sulemanu yè bori pãnde nↄgbɛ̃nↄzi pari. Fili'auna nɛ́nↄgbɛ̃ baasi, ben à Mↄabunↄ kↄ̃n Amↄninↄ kↄ̃n Ɛdↄmunↄ kↄ̃n Sidↄ̃deenↄ kↄ̃n Itinↄ sɛ̀sɛ nↄↄnↄ ũ. ");
INSERT INTO bus_vpl VALUES ("K111_2","012_11_2","1KI","11","2","2","Dii bè Isarailinↄnɛ aↄ̃ton borii pìnↄ sɛ́ro, zaakɛ aↄ̃é ń sãsãmɛ, lɛ aↄ̃ↄ tɛ́ ń tãanↄzi. Baa kↄ̃n beeeo aↄ̃ yenzi Sulemanu swɛ̃̀ blè. ");
INSERT INTO bus_vpl VALUES ("K111_3","012_11_3","1KI","11","3","3","À kínɛnↄ sɛ̀sɛ nↄↄnↄ ũ gↄ̃ↄn wàa aagↄ̃ kpɛ́ basↄↄro, bensↄ̃ à nↄ yìgisainↄ vĩ dↄ wàa do kpɛ́ basↄↄro. Ben à nↄↄ pìnↄ à sã̀sã. ");
INSERT INTO bus_vpl VALUES ("K111_4","012_11_4","1KI","11","4","4","Kɛ̀ zikũ e gɛ̃ɛn, à nↄↄnↄ tò à tɛ̀ tãanↄzi, èe a swɛ̃̀ kpá Dii a Ludaa mámmam lán a de Dauda bàro. ");
INSERT INTO bus_vpl VALUES ("K111_5","012_11_5","1KI","11","5","5","À tɛ̀ Sidↄ̃deenↄ tãa Asatorɛzi kↄ̃n Amↄninↄ tãa Mↄlɛki kɛ̀ Luda zàn-o. ");
INSERT INTO bus_vpl VALUES ("K111_6","012_11_6","1KI","11","6","6","À yã kɛ̀ Dii yeziroo kɛ̀, èe tɛ́zi kↄ̃n nↄ̀sɛo do lán a de Dauda bàro. ");
INSERT INTO bus_vpl VALUES ("K111_7","012_11_7","1KI","11","7","7","Ben à gàa à tãagbãgbãkii bò sĩ̀sĩ kɛ̀ kú Yerusalɛmu ↄfãntɛ̃bↄɛ kpaa musu Mↄabunↄ tãa gina Kɛmↄsinɛ kↄ̃n Amↄninↄ tãa gina Mↄlɛkio. ");
INSERT INTO bus_vpl VALUES ("K111_8","012_11_8","1KI","11","8","8","Lɛn à kɛ̀ lɛ a bori pãnde nↄↄnↄnɛ ń píngi, ben aↄ̃ tuaetiti kpàta ń tãanↄnɛ aↄ̃ saa òḿma. ");
INSERT INTO bus_vpl VALUES ("K111_9","012_11_9","1KI","11","9","9","Ben Dii Isarailinↄ Luda pↄ fɛ̃̀ Sulemanuzi, kɛ̀ à kpɛɛ lìnɛ à swɛ̃̀ kúa dↄro yãnzi, zaakɛ Dii bↄ̀ à mↄ̀zi yã gɛ̃̀n plaa. ");
INSERT INTO bus_vpl VALUES ("K111_10","012_11_10","1KI","11","10","10","Baa kɛ̀ Dii bènɛ, àton tɛ́ tãanↄziro, èe yã kɛ̀ Dii dìɛ pì maro. ");
INSERT INTO bus_vpl VALUES ("K111_11","012_11_11","1KI","11","11","11","Ben Dii bènɛ: Zaakɛ ń kɛ̀ lɛ, nɛ́ɛ zɛ kↄ̃n ma bà kuunanyo yã kɛ̀ má dìɛnnɛɛoro, mɛ́ kpata bↄ n ↄzĩ mà n zↄ̀bleri ke ká n gɛ̃ɛ ũ. ");
INSERT INTO bus_vpl VALUES ("K111_12","012_11_12","1KI","11","12","12","Mↄde n de Dauda yãnzi mɛ́ kɛ lɛ n gurↄↄaro, n nɛ́n mɛ́ kɛnɛ. ");
INSERT INTO bus_vpl VALUES ("K111_13","012_11_13","1KI","11","13","13","Baa kↄ̃n beeeo mɛ́ kpata bↄ à ↄzĩ mámmanlo. Bori lɛo doon mɛ́ tó n nɛ́ pìnɛ ma zↄ̀bleri Dauda kↄ̃n Yerusalɛmu kɛ̀ má sɛ̀ ma pↄ́ ũuo yãnzi. ");
INSERT INTO bus_vpl VALUES ("K111_14","012_11_14","1KI","11","14","14","Ben Dii tò Ɛdↄmu gbɛ̃ Adada kɛ̀ dɛ wɛ̃ɛnɛ ũ íbɛtɛ kpà kↄ̃n Sulemanuo. ");
INSERT INTO bus_vpl VALUES ("K111_15","012_11_15","1KI","11","15","15","Gurↄↄ kɛ̀ Dauda e zĩ̀ kaa kↄ̃n Ɛdↄmunↄ yã, à zĩ̀kpɛɛnↄ dↄn'aɛdee Yoabu gàa à Isarailinↄ gɛ̀nↄ vĩ̀i, ben à Ɛdↄmunↄ bùsu gↄ̃gbɛ̃nↄ dɛ̀dɛ gwe ń píngi. ");
INSERT INTO bus_vpl VALUES ("K111_16","012_11_16","1KI","11","16","16","Àpi kↄ̃n a gbɛ̃nↄↄ kú gwe ai mↄ swɛɛdo ai aↄ̃ gàa wà Ɛdↄmunↄ bùsu gↄ̃gbɛ̃ pìnↄ dɛ̀dɛo ń píngi. ");
INSERT INTO bus_vpl VALUES ("K111_17","012_11_17","1KI","11","17","17","Kɛ̀ Adada bàa sì, èe taa Igipiti kↄ̃n a de ìba kenↄ. Gurↄ beeea sↄ̃ Adada nɛ́ gↄ̃kparɛmɛ. ");
INSERT INTO bus_vpl VALUES ("K111_18","012_11_18","1KI","11","18","18","Aↄ̃ bↄ̀ Midiã aↄ̃ gàa Parani, ben aↄ̃ Paranide kenↄ sɛ̀ wà gàańyo Igipiti kí Fili'auna kiia. Fili'auna kpɛ́ kpàa kↄ̃n pↄ́bleeo kↄ̃n tↄↄtɛo. ");
INSERT INTO bus_vpl VALUES ("K111_19","012_11_19","1KI","11","19","19","Adada yã kà Fili'aunanɛ maamaa, ben à a naↄ̃ Tapɛnɛsi dãaro kpàa nↄↄ ũ. ");
INSERT INTO bus_vpl VALUES ("K111_20","012_11_20","1KI","11","20","20","Ben Tapɛnɛsi dãaro pì nɛ́ ì gↄ̃gbɛ̃ ũ, wè benɛ Genuba, ben Tapɛnɛsi nɛ́ pì gwà Fili'auna ua kↄ̃n Fili'auna nɛ́nↄo lɛdo. ");
INSERT INTO bus_vpl VALUES ("K111_21","012_11_21","1KI","11","21","21","Gurↄↄ kɛ̀ Adada kú Igipiti, à mà kɛ̀ Dauda gà bensↄ̃ à zĩ̀kpɛɛnↄ dↄn'aɛde Yoabu gà dↄ. Ben à bè Fili'aunanɛ: Ǹ ma gba zɛ́ mà tá ma bùsun. ");
INSERT INTO bus_vpl VALUES ("K111_22","012_11_22","1KI","11","22","22","Ben Fili'auna à là à bè: Bↄ́ bé èe kɛ̃sãamma ma kiia, kɛ̀ tò ń yezi ǹ tá n bùsun? À wèàla à bè: Pↄ́kee e kɛ̃sãamaro, ǹ ma gba zɛ́ dé! ");
INSERT INTO bus_vpl VALUES ("K111_23","012_11_23","1KI","11","23","23","Ben Ludaa tò dↄ Ɛliada nɛ́ Rɛzↄ̃ kɛ̀ bàa sì a dii Zoba kí Adadɛzanɛ yãa fɛ̀ɛ Sulemanuzi. ");
INSERT INTO bus_vpl VALUES ("K111_24","012_11_24","1KI","11","24","24","Kɛ̀ Dauda Adadɛza gbɛ̃nↄ dɛ̀dɛ, ben Rɛzↄ̃ gbɛ̃nↄ kàkↄ̃aazi aↄ̃ kɛ̀ gbãamↄnnɛrinↄ gãli ũ, ben à gↄ̃̀ ń dↄn'aɛdee ũ. Aↄ̃ gàa wà vɛ̃̀ɛ Damasiku, ben à gwee sì. ");
INSERT INTO bus_vpl VALUES ("K111_25","012_11_25","1KI","11","25","25","Rɛzↄ̃n Isarailinↄ ibɛɛ ũ ai Sulemanu wɛ̃̀ndi lɛ́n, yãkete kɛ̀ Adada fɛ̀ɛo baasi. À kpata blè Siria bùsun, à gì Isarailinↄ kãzi. ");
INSERT INTO bus_vpl VALUES ("K111_26","012_11_26","1KI","11","26","26","Nɛbati nɛ́ Yeroboamu nɛ́ Sulemanu ìba kemɛ. Ɛflaimu boriimɛ, kɛ̀ bↄ̀ Zɛrɛda, ben à bↄ̀ Sulemanu kpɛɛ. À da nɛ́ gyaanↄↄmɛ, à tↄ́n Zɛrua. ");
INSERT INTO bus_vpl VALUES ("K111_27","012_11_27","1KI","11","27","27","Lán à kɛ̀ nà à bↄ̀ kína kpɛɛn yɛ̀. Sulemanu wɛ̀ɛ kɛ̀ wè be Milo tàta bùsuo, ben à a de Dauda wɛ́tɛ bĩi bò à pɛ̀kↄ̃rɛ. ");
INSERT INTO bus_vpl VALUES ("K111_28","012_11_28","1KI","11","28","28","Yeroboamu nɛ́ nɛ́gↄ̃gbɛ̃ làakarideemɛ. Kɛ̀ Sulemanu è kɛ̀ ↄ̀wazi pì aĩa vĩ, ben à à dìɛ zĩ gbãaa kɛ̀ Yusufu boriinↄↄ e kɛɛ pì gbɛ̃nsi ũ. ");
INSERT INTO bus_vpl VALUES ("K111_29","012_11_29","1KI","11","29","29","Gurↄↄ beeean Yeroboamu bↄ̀ Yerusalɛmu, ben à dàkↄ̃rɛ kↄ̃n annabi Ahia, Silo gbɛ̃o zɛ́n, à uta dufu dana. Aↄ̃ↄ kú sɛ̃̀n gwe ń plaa. ");
INSERT INTO bus_vpl VALUES ("K111_30","012_11_30","1KI","11","30","30","Ben Ahia a uta dufu pì gà à kɛ̃̀ à pàrapara lɛo kuri awɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("K111_31","012_11_31","1KI","11","31","31","Ben à bè Yeroboamunɛ à à parana pì sɛ́ɛ mɛ̀n kuri, zaakɛ Dii Isarailinↄ Luda bè: Mɛ́ Sulemanu bↄ kpatammɛ mà Isaraili bori lɛo kuri kpámma. ");
INSERT INTO bus_vpl VALUES ("K111_32","012_11_32","1KI","11","32","32","Mɛ́ bori lɛo doo tónɛ ma zↄ̀bleri Dauda kↄ̃n Yerusalɛmu kɛ̀ má sɛ̀ Isaraili bori píngi wɛ́tɛnↄ tɛ́o yãnzi. ");
INSERT INTO bus_vpl VALUES ("K111_33","012_11_33","1KI","11","33","33","Mɛ́ kɛnɛ lɛ, kɛ̀ à ma zĩnna à gàa èe Sidↄ̃deenↄ tãa Asatorɛ kↄ̃n Mↄabunↄ tãa Kɛmↄsio kↄ̃n Amↄninↄ tãa Mↄlɛkio gbãgbãa yãnzi. Èe tɛ́maziro, èe yã kɛ̀ maamɛɛ kɛro, èe ma ↄdↄkii gwaro, à ma dokayãnↄ kũna lán a de Dauda bàro. ");
INSERT INTO bus_vpl VALUES ("K111_34","012_11_34","1KI","11","34","34","Baa kↄ̃n beeeo mɛ́ kpata bↄ à ↄzĩ mámmanlo, zaakɛ ma gĩakɛ ma à kɛ̀ kí ũ ai a wɛ̃̀ndi lɛ́mmɛ ma zↄ̀bleri Dauda kɛ̀ má sɛ̀ yãnzi, kɛ̀ à ma yãdiɛnanↄ kũna bensↄ̃ à ma ↄdↄkii gwà. ");
INSERT INTO bus_vpl VALUES ("K111_35","012_11_35","1KI","11","35","35","À nɛ́n mɛ́ kpata sí à ↄzĩ, mà Isaraili bori lɛo kurinↄ kpámma. ");
INSERT INTO bus_vpl VALUES ("K111_36","012_11_36","1KI","11","36","36","Isaraili bori lɛo doon mɛ́ tó à nɛ́ pìnɛ, lɛ ma zↄ̀bleri Dauda borii gↄ̃ kí bleemɛ Yerusalɛmu gurↄ píngi, wɛ́tɛ kɛ̀ má sɛ̀ ma tↄ́ gↄ̃ kúa pì. ");
INSERT INTO bus_vpl VALUES ("K111_37","012_11_37","1KI","11","37","37","Mpi sↄ̃, ma n sɛ Isarailinↄ kína ũ, lɛ ǹgↄ̃ kí blee pↄ́ kɛ̀ n pↄↄ yezia píngi. ");
INSERT INTO bus_vpl VALUES ("K111_38","012_11_38","1KI","11","38","38","Tó nɛ́ɛ yã kɛ̀ má dìɛnnɛɛ kɛɛ píngi, tó ń tɛ́mazi, nɛ́ɛ yã kɛ̀ maamɛɛ kɛɛ, tó nɛ́ɛ ma ↄdↄkii gwaa bensↄ̃ ń ma yãdiɛnanↄ kũna lán ma zↄ̀bleri Dauda bà, mɛ́gↄ̃ kúnyo, mɛ́gↄ̃ n boriinↄ kaa Isaraili kpatan gurↄ píngi, lán ma Dauda boriinↄ kàn nà. ");
INSERT INTO bus_vpl VALUES ("K111_39","012_11_39","1KI","11","39","39","Mɛ́ Dauda boriinↄ ɛara kpɛɛ yã kɛ̀ aↄ̃ↄ kɛ̀ pì yãnzi, mↄde èe kɛ ai gurↄ pínginlo. ");
INSERT INTO bus_vpl VALUES ("K111_40","012_11_40","1KI","11","40","40","Sulemanu zɛ́ wɛ̀tɛ à Yeroboamu dɛ, ben à fɛ̀ɛ à bàa sì à tà Igipiti kí Sisaki kiia, à gↄ̃̀ gwe ai Sulemanu gàa à gào. ");
INSERT INTO bus_vpl VALUES ("K111_41","012_11_41","1KI","11","41","41","Sulemanu yã kpaaanↄ kↄ̃n ↄ̃ndↄ̃yã kɛ̀ à kɛ̀nↄ píngi kú Sulemanu yãnↄ takadan. ");
INSERT INTO bus_vpl VALUES ("K111_42","012_11_42","1KI","11","42","42","Sulemanu kɛ̀ Isaraili bori píngi kína ũ Yerusalɛmu wɛ̃̀ baplaamɛ. ");
INSERT INTO bus_vpl VALUES ("K111_43","012_11_43","1KI","11","43","43","Kɛ̀ à gà, wà à vĩ̀i à de Dauda wɛ́tɛ, ben à nɛ́ Reoboamu vɛ̃̀ɛ à gbɛ̀n. ");
INSERT INTO bus_vpl VALUES ("K112_1","012_12_1","1KI","12","1","1","Reoboamu gàa Sɛkɛmu, zaakɛ gwen Isaraili bori píngi gàan lɛ wà à ká kí ũ. ");
INSERT INTO bus_vpl VALUES ("K112_2","012_12_2","1KI","12","2","2","Kɛ̀ Nɛbati nɛ́ Yeroboamu à baaru mà, ben à bↄ̀ Igipiti à sù, zaakɛ gwen à kún zaa gurↄↄ kɛ̀ à bàa sì Sulemanunɛ. ");
INSERT INTO bus_vpl VALUES ("K112_3","012_12_3","1KI","12","3","3","Ben Isaraili kɛ̀ aↄ̃ kↄ̃ kàkↄ̃a pìnↄ à sìsi, ben aↄ̃ gàa wà yã ò lɛdo kↄ̃n Reoboamuo wà bè: ");
INSERT INTO bus_vpl VALUES ("K112_4","012_12_4","1KI","12","4","4","N de zĩ gbãaa dàwe pãsĩpãsĩ. Mmↄn sↄ̃, ǹ zĩ gbãaa pì kↄ̃n aso tìisi kɛ̀ à dìweeo lago, wé mì siɛnnɛ. ");
INSERT INTO bus_vpl VALUES ("K112_5","012_12_5","1KI","12","5","5","Ben à wèńla à bè: À tá gĩa ai gurↄ aagↄ̃, gbasa à ɛara à mↄ́. Ben aↄ̃ tà. ");
INSERT INTO bus_vpl VALUES ("K112_6","012_12_6","1KI","12","6","6","Kí Reoboamu yã pì gbã̀ gbɛ̃nsi kɛ̀ aↄ̃ↄ dɛ a de Sulemanu ìba ũunↄnɛ à bè: Yã kpareen á è à maa mà sí gbɛ̃ pìnↄlaa? ");
INSERT INTO bus_vpl VALUES ("K112_7","012_12_7","1KI","12","7","7","Ben aↄ̃ wèàla wà bè: Tó n mì sìɛńnɛ gbã̀a, ben n yã maaa sìńla, aↄ̃égↄ̃ dɛ n zↄ̀blerinↄ ũ gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("K112_8","012_12_8","1KI","12","8","8","Ben Reoboamu gì gbɛ̃nsi pìnↄ lɛ́dammazi, à gàa à yã pì gbã̀ a ìba gↄ̃kparɛ kɛ̀ aↄ̃ nɛ́ blè lɛdoonↄnɛ. ");
INSERT INTO bus_vpl VALUES ("K112_9","012_12_9","1KI","12","9","9","À ń lá à bè: Gbɛ̃ kɛ̀ aↄ̃ bèmɛ mà zĩ gbãaa kɛ̀ ma dee dàńnɛ lagońnɛ pìnↄ, yã kpareen á è à maa wà síńlaa? ");
INSERT INTO bus_vpl VALUES ("K112_10","012_12_10","1KI","12","10","10","Ben gↄ̃kparɛ pìnↄ wèàla wà bè: Gbɛ̃ kɛ̀ aↄ̃ bènnɛ n de aso tìisi dìńnɛ ǹ lagońnɛ pìnↄ, ǹ ońnɛ n ↄnɛzãa gbère dɛ n de piila. ");
INSERT INTO bus_vpl VALUES ("K112_11","012_12_11","1KI","12","11","11","N de aso tìisi dìńnɛ, mmↄn sↄ̃, nɛ́ asoo pì kaarańnɛ. N de wɛ́ɛ tã̀ḿma kↄ̃n flã̀omɛ, mↄde flã̀ lɛ̀deen nɛ́ wɛ́ɛ tãoḿma. ");
INSERT INTO bus_vpl VALUES ("K112_12","012_12_12","1KI","12","12","12","À gurↄ aagↄ̃dee zĩ Yeroboamu kↄ̃n Isarailinↄ ɛ̀ara wà mↄ̀ wà Reoboamu lè ń píngi, lán à òńnɛ nà à bè, aↄ̃ ɛara wà mↄ́ gurↄ aagↄ̃ↄ gbɛra. ");
INSERT INTO bus_vpl VALUES ("K112_13","012_12_13","1KI","12","13","13","Ben kína gì gbɛ̃nsinↄ lɛ́dammazi à yã wèńla pãsĩpãsĩ. ");
INSERT INTO bus_vpl VALUES ("K112_14","012_12_14","1KI","12","14","14","À tɛ̀ gↄ̃kparɛnↄ lɛ́dammazi à bè: Aso tìisin ma dee dìare, mamↄma sↄ̃ mɛ́ asoo pì kaaraaremɛ. Flã̀n ma de wɛ́ɛ tã̀oawa, mapi sↄ̃, flã̀ lɛ̀deen mɛ́ wɛ́ɛ tãoawa. ");
INSERT INTO bus_vpl VALUES ("K112_15","012_12_15","1KI","12","15","15","Ben kína gì Isarailinↄ yã mazi, zaakɛ yã pì bↄ̀ Dii kiiamɛ, lɛ yã kɛ̀ à ò Nɛbati nɛ́ Yeroboamunɛ annabi Ahia, Silo gbɛ̃ gãzĩ e à kɛ yãnzi. ");
INSERT INTO bus_vpl VALUES ("K112_16","012_12_16","1KI","12","16","16","Kɛ̀ Isarailinↄↄ è kína gì ń yã mazi, aↄ̃ bènɛ: Wa bà kú kↄ̃n Daudaoro, wa lɛ́ kú Yɛsɛ nɛ́ yãnlo. Isarailinↄ, a baade tá a bɛ! Dauda bori, ǹ n zĩnda bɛ kũ! Ben Isarailinↄ tà ń bɛ. ");
INSERT INTO bus_vpl VALUES ("K112_17","012_12_17","1KI","12","17","17","Isaraili kɛ̀ aↄ̃ↄ kú Yuda boriinↄ wɛ́tɛ guunↄn Reoboamu gↄ̃̀ ń kína ũ ado. ");
INSERT INTO bus_vpl VALUES ("K112_18","012_12_18","1KI","12","18","18","Kí Reoboamu a zↄ̀zĩ gbɛ̃nsi Adoniramu zĩ̀ Isarailinↄa, ben aↄ̃ à pàpa gbɛ̀o wà à dɛ̀. Ben kí Reoboamu fɛ̀ɛ kↄ̃n wãaao à sì a sↄ̃goron à bàa sì à tà Yerusalɛmu. ");
INSERT INTO bus_vpl VALUES ("K112_19","012_12_19","1KI","12","19","19","Lɛn Isarailinↄ gì Dauda boriinↄzi lɛ ai kↄ̃n a gbã̀ao. ");
INSERT INTO bus_vpl VALUES ("K112_20","012_12_20","1KI","12","20","20","Kɛ̀ Isarailinↄↄ mà ń píngi kɛ̀ Yeroboamu sù, ben aↄ̃ à sìsi kakↄ̃ana guu, ben aↄ̃ à kà Isaraili boriinↄ kína ũ. Isaraili bori kee e zɛ kↄ̃n Dauda boriinↄo dↄro, tó èe kɛ Yuda boriinↄ baasiro. ");
INSERT INTO bus_vpl VALUES ("K112_21","012_12_21","1KI","12","21","21","Kɛ̀ Reoboamu kà Yerusalɛmu, à Yudanↄ kàkↄ̃a ń píngi kↄ̃n Bɛyãmi boriinↄ. Zĩ̀kari pìnↄ gↄ̃ↄn bↄrↄ bakɛ̃ndomɛ. Ben aↄ̃ↄe gaa zĩ̀ ká kↄ̃n Isarailinↄ, lɛ wà e wà Sulemanu nɛ́ Reoboamu kpata sínɛ wà kpáa dↄ. ");
INSERT INTO bus_vpl VALUES ("K112_22","012_12_22","1KI","12","22","22","Ben Luda yã sù Luda gbɛ̃ kɛ̀ wè be Semayaa à bè: ");
INSERT INTO bus_vpl VALUES ("K112_23","012_12_23","1KI","12","23","23","Ǹ o Yudanↄ kí Sulemanu nɛ́ Reoboamunɛ kↄ̃n Yudanↄ ń píngi kↄ̃n Bɛyãmi boriinↄ kↄ̃n gbɛ̃ kpaaanↄ, ");
INSERT INTO bus_vpl VALUES ("K112_24","012_12_24","1KI","12","24","24","mamↄma Dii ma bè, àton gá zĩ̀ ká kↄ̃n a Isaraili daanↄoro. A baade tá a bɛ, zaakɛ yã kɛ̀ kɛ̀ pì bↄ̀ ma kiiamɛ. Ben aↄ̃ yã kɛ̀ Dii òńnɛ mà aↄ̃ tà. ");
INSERT INTO bus_vpl VALUES ("K112_25","012_12_25","1KI","12","25","25","Yeroboamu Sɛkɛmu kɛ̀ kú Ɛflaimu gu kpiideen bĩi bò, ben à vɛ̃̀ɛn. Zaa gwen à gàa à Pɛniɛli kɛ̀kɛ à kàɛ. ");
INSERT INTO bus_vpl VALUES ("K112_26","012_12_26","1KI","12","26","26","Ben à laasuu lɛ̀ à bè: Weé ɛara wà Dauda borii sↄkpa kpatammɛ fá! ");
INSERT INTO bus_vpl VALUES ("K112_27","012_12_27","1KI","12","27","27","Tó Isarailinↄↄ e gaa saa o Dii ua Yerusalɛmu, aↄ̃é ɛara wà zɛ kↄ̃n ń dii Yudanↄ kí Reoboamuomɛ, aↄ̃é ma dɛ wà zɛo. ");
INSERT INTO bus_vpl VALUES ("K112_28","012_12_28","1KI","12","28","28","Kɛ̀ kína yã pì gwà, ben à vura zùswarenɛ bↄ̀rↄnↄ pì mɛ̀n plaa, ben à bè gbɛ̃nↄnɛ: Isarailinↄ, a gana Yerusalɛmu mↄ̀ lɛ. A dii kɛ̀ aↄ̃ a bↄɛ Igipitinↄn yɛ̀! ");
INSERT INTO bus_vpl VALUES ("K112_29","012_12_29","1KI","12","29","29","Ben à à doo dìɛ Bɛtɛli, à doo sↄ̃ ai Dani. ");
INSERT INTO bus_vpl VALUES ("K112_30","012_12_30","1KI","12","30","30","Ben yã pì gↄ̃̀ńnɛ durun ũ, aↄ̃è gá dↄnzi kɛ à doonɛ Bɛtɛli, à doo sↄ̃ ai Dani. ");
INSERT INTO bus_vpl VALUES ("K112_31","012_12_31","1KI","12","31","31","Yeroboamu kpɛ́ bò zù pìnↄnɛ tãagbãgbãkiinↄa, ben à gbɛ̃ dìɛ sa'orinↄ ũ, baa kↄ̃n gbɛ̃ kɛ̀ aↄ̃ↄ dɛ Levi borii ũroonↄ. ");
INSERT INTO bus_vpl VALUES ("K112_32","012_12_32","1KI","12","32","32","Ben à mↄ sↄraagↄ̃de gurↄ gɛ̃rodee dìɛ zĩbaa ũ lán Yudanↄ pↄ́ bà se, ben à saa ò tãagbãgbãkii kɛ̀ kú Bɛtɛli pìa. À saa ò zùswaree kɛ̀ à pì pìnↄa, ben à sa'orinↄ dìɛ gwe. ");
INSERT INTO bus_vpl VALUES ("K112_33","012_12_33","1KI","12","33","33","Ben à saa ò sa'okii kɛ̀ à kɛ̀ Bɛtɛli pìa mↄ sↄraagↄ̃de gurↄ gɛ̃rodee zĩ. Gurↄↄ pìn à dìɛ a zĩnda pↄyezia zĩbaa ũ Isarailinↄnɛ. ");
INSERT INTO bus_vpl VALUES ("K113_1","012_13_1","1KI","13","1","1","Luda gbɛ̃ke bↄ̀ Yudanↄ bùsun à mↄ̀ Bɛtɛli lán Dii dànɛ nà gurↄↄ kɛ̀ Yeroboamu zɛna sa'okii pì saɛ lɛ à saa o. ");
INSERT INTO bus_vpl VALUES ("K113_2","012_13_2","1KI","13","2","2","Ben à sa'okii pì kà à bè: Sa'oki, sa'oki, Dii bè weé nɛ́ i Dauda bɛ, weé tↄ́ kpánɛ Yosia. Àpi bé eé saa omma kↄ̃n tãagbãgbãkii sa'ori kɛ̀ aↄ̃ↄe zĩi kɛɛ kɛ̀nↄ, eé gbɛ̃ntee wánↄ kpátamma. ");
INSERT INTO bus_vpl VALUES ("K113_3","012_13_3","1KI","13","3","3","Gwe gↄ̃ↄ Luda gbɛ̃ pì yã pì kɛna sèeda òńnɛ à bè: Sèeda kɛ̀ Dii òn yɛ̀. Sa'okii pì é parakↄ̃rɛ à túbu é kwɛ́ɛ. ");
INSERT INTO bus_vpl VALUES ("K113_4","012_13_4","1KI","13","4","4","Kɛ̀ kí Yeroboamu lɛ́ kɛ̀ Luda gbɛ̃ pì kɛ̀ Bɛtɛli sa'okii pìnɛ mà, ben à ↄ̀dↄa zaa sa'okiia gwe à bè: À à kũ! Ben ↄↄ kɛ̀ à dↄ̀a pì gbã̀gbã, eé fↄ̃ à kòko dↄro. ");
INSERT INTO bus_vpl VALUES ("K113_5","012_13_5","1KI","13","5","5","Ben sa'okii pì pàrakↄ̃rɛ à túbu kwɛ̀ɛ lán Dii dà Luda gbɛ̃ pìnɛ à ò nà. ");
INSERT INTO bus_vpl VALUES ("K113_6","012_13_6","1KI","13","6","6","Ben kína bè Luda gbɛ̃ pìnɛ: Ǹ agbaa kpámɛ Dii n Ludanɛ. Ǹ wɛ́ɛ kɛamɛ lɛ ma ↄↄ e à su a gbɛ̀n. Ben Luda gbɛ̃ pì agbaa kpà Diinɛ, ben à ↄↄ sù a gbɛ̀n lán a zii bà. ");
INSERT INTO bus_vpl VALUES ("K113_7","012_13_7","1KI","13","7","7","Ben kína bè Luda gbɛ̃ pìnɛ: Ǹ mↄ́ wà gá ma bɛ wà pↄ́ ble, mɛ́ gba dannɛ. ");
INSERT INTO bus_vpl VALUES ("K113_8","012_13_8","1KI","13","8","8","Ben à bè kína pìnɛ: Baa tó n n auziki kpadoo kpàma, mɛ́ gányoro. Mɛ́ pↄ́ ble ke mà í mi guu kɛ̀ro, ");
INSERT INTO bus_vpl VALUES ("K113_9","012_13_9","1KI","13","9","9","zaakɛ Dii bèmɛ màton pↄ́ ble kɛ̀ro, màton í mi kɛ̀ro, màton sↄ̃ tá kↄ̃n zɛ́ kɛ̀ ma mↄooro. ");
INSERT INTO bus_vpl VALUES ("K113_10","012_13_10","1KI","13","10","10","Ben à zɛ́ pãnde sɛ̀, èe zɛ́ kɛ̀ à mↄ̀o Bɛtɛli sɛ́ dↄro. ");
INSERT INTO bus_vpl VALUES ("K113_11","012_13_11","1KI","13","11","11","Annabi zi kee kú Bɛtɛli gwe. Kɛ̀ à nɛ́nↄ sù, aↄ̃ yã kɛ̀ Luda gbɛ̃ pì kɛ̀ gwe zĩ beeea tↄ̃kɛ̃̀ ń denɛ kↄ̃n yã kɛ̀ à ò kínanɛo píngi. ");
INSERT INTO bus_vpl VALUES ("K113_12","012_13_12","1KI","13","12","12","Ben aↄ̃ de ń lá à bè: Zɛ́ kpareen à sɛ̀? Ben à nɛ́nↄ zɛ́ kɛ̀ Luda gbɛ̃ kɛ̀ bↄ̀ Yudanↄ bùsun pì sɛ̀ gↄ̃̀gↄ̃nɛ. ");
INSERT INTO bus_vpl VALUES ("K113_13","012_13_13","1KI","13","13","13","Ben à bèńnɛ: À gàari yimɛ zaakinɛ. Ben aↄ̃ↄ yìnɛ aↄ̃ à dì à kpɛɛ. ");
INSERT INTO bus_vpl VALUES ("K113_14","012_13_14","1KI","13","14","14","Kɛ̀ à pɛ̀ɛ Luda gbɛ̃ pìzi, ben à à lè vɛ̃ɛna gbíi lí gbáru. Ben à à là à bè: Luda gbɛ̃ kɛ̀ bↄ̀ Yudanↄ bùsumn n ũↄ́? À wèàla à bè: Mámbee! ");
INSERT INTO bus_vpl VALUES ("K113_15","012_13_15","1KI","13","15","15","Ben annabi zii pì bènɛ: Ǹ mↄ́ wà gá ma bɛ, ǹ pↄ́ ble. ");
INSERT INTO bus_vpl VALUES ("K113_16","012_13_16","1KI","13","16","16","À wèàla à bè: Mɛ́ fↄ̃ mà ɛara mà tányoro. Mɛ́ fↄ̃ mà pↄ́ ble ke mà í minyo guu kɛ̀ro, ");
INSERT INTO bus_vpl VALUES ("K113_17","012_13_17","1KI","13","17","17","zaakɛ Dii bèmɛ màton pↄ́ ble ke mà í mi kɛ̀ro, màton sↄ̃ tá kↄ̃n zɛ́ kɛ̀ ma mↄooro. ");
INSERT INTO bus_vpl VALUES ("K113_18","012_13_18","1KI","13","18","18","Ben annabi zii pì bènɛ: Annabin ma ũ lán n bà. Malaika ke bé à Dii yã òmɛ à bè mà pɛ́ɛnzi mà sunyo ma bɛ, lɛ ǹ pↄ́ ble ǹ í mi. Mↄde ɛgɛɛn annabi pì e too. ");
INSERT INTO bus_vpl VALUES ("K113_19","012_13_19","1KI","13","19","19","Ben Luda gbɛ̃ pì ɛ̀arao, à pↄ́ blè à bɛ à í mì. ");
INSERT INTO bus_vpl VALUES ("K113_20","012_13_20","1KI","13","20","20","Gurↄↄ kɛ̀ aↄ̃ↄ vɛ̃ɛna pↄ́bleezi, Dii yã sù annabi zii kɛ̀ sùo pìa, ");
INSERT INTO bus_vpl VALUES ("K113_21","012_13_21","1KI","13","21","21","ben à wii lɛ̀ Luda gbɛ̃ kɛ̀ bↄ̀ Yudanↄ bùsun pìa à bè: Dii n Luda bè, lán n gi a yã mazi nà, nɛ́ɛ yã kɛ̀ à ònnɛɛ maro, ");
INSERT INTO bus_vpl VALUES ("K113_22","012_13_22","1KI","13","22","22","n ɛara n mↄ n pↄ́ blè n í mì guu kɛ̀ à ònnɛ ǹton pↄ́ blenlo ǹton í minlo pì, weé n vĩi kↄ̃n n dezinↄoro. ");
INSERT INTO bus_vpl VALUES ("K113_23","012_13_23","1KI","13","23","23","À pↄ́blena kↄ̃n à íminao gbɛra, annabi kɛ̀ sùo pì gàari yìnɛ zaakia. ");
INSERT INTO bus_vpl VALUES ("K113_24","012_13_24","1KI","13","24","24","Kɛ̀ à dà zɛ́n, ben à kpàkũ kↄ̃n músuo, músu pì à dɛ̀. À gɛ̀ gↄ̃̀ diɛna zɛ́n, ben zaaki kↄ̃n músuo gↄ̃̀ zɛna à gɛ̀ pìzi. ");
INSERT INTO bus_vpl VALUES ("K113_25","012_13_25","1KI","13","25","25","Kɛ̀ gbɛ̃ kɛ̀ aↄ̃ↄe gɛ̃tɛɛnↄ à gɛ̀ è daɛna zɛ́n gwe kↄ̃n músu kɛ̀ zɛzio, ben aↄ̃ gàa wà à baaru kpà wɛ́tɛ kɛ̀ annabi zii pì kún guu. ");
INSERT INTO bus_vpl VALUES ("K113_26","012_13_26","1KI","13","26","26","Kɛ̀ annabi kɛ̀ sùo pì à baaru mà, à bè: Luda gbɛ̃ kɛ̀ gì Dii yã mazin gwe. Ben Dii à kpà músua, à à ɛ̀'ɛkↄ̃rɛ à dɛ̀ lán Dii ònɛ nà. ");
INSERT INTO bus_vpl VALUES ("K113_27","012_13_27","1KI","13","27","27","Ben à bè a nɛ́nↄnɛ: À gàari yimɛ zaakinɛ. Ben aↄ̃ↄ yìnɛ. ");
INSERT INTO bus_vpl VALUES ("K113_28","012_13_28","1KI","13","28","28","À dà zɛ́n, ben à gàa à à gɛ̀ lè daɛna, zaaki kↄ̃n músuo zɛzi. Músu pì e gɛ̀ pì sóro bensↄ̃ èe zaaki pì ɛ́'ɛkↄ̃rɛro. ");
INSERT INTO bus_vpl VALUES ("K113_29","012_13_29","1KI","13","29","29","Ben annabi pì Luda gbɛ̃ pì gɛ̀ sɛ̀ à dì zaaki musu à sùo a bɛ wɛ́tɛn, lɛ à gɛ̀ ↄ́ↄ dↄ à à vĩi. ");
INSERT INTO bus_vpl VALUES ("K113_30","012_13_30","1KI","13","30","30","Ben à à vĩ̀i a zĩnda mirawɛɛn, à ↄ́ↄ dↄ̀ à bè: Wãiyoo ma gbɛ̃! ");
INSERT INTO bus_vpl VALUES ("K113_31","012_13_31","1KI","13","31","31","Kɛ̀ à à vĩ̀i à yã̀a, à bè a nɛ́nↄnɛ: Tó ma ga, à ma vĩi mirawɛɛ kɛ̀ ma Luda gbɛ̃ pì vĩ̀in à wa gɛ̀ kpákↄ̃zi. ");
INSERT INTO bus_vpl VALUES ("K113_32","012_13_32","1KI","13","32","32","Zaakɛ yã kɛ̀ Dii dànɛ à ò Bɛtɛli sa'okii musu kↄ̃n tãakpɛ kɛ̀ kú Samaria bùsu wɛ́tɛ tãagbãgbãkiianↄ é kɛ yãpura. ");
INSERT INTO bus_vpl VALUES ("K113_33","012_13_33","1KI","13","33","33","Baa kↄ̃n beeeo Yeroboamu e kpɛɛ li a yãzaakɛnanɛro, à ɛ̀ara à Isaraili bori píngi dìɛ tãagbãgbãki sa'orinↄ ũ dↄ. Gbɛ̃ kɛ̀ aↄ̃ↄ yezi wà gↄ̃ tãagbãgbãki sa'orinↄ ũun à ń kɛ́ à ũ. ");
INSERT INTO bus_vpl VALUES ("K113_34","012_13_34","1KI","13","34","34","Durun kɛ̀ tò wà Yeroboamu boriinↄ dúgu zↄ̃̀ aↄ̃ yã̀a anduna guun gwe. ");
INSERT INTO bus_vpl VALUES ("K114_1","012_14_1","1KI","14","1","1","Gurↄ beeea gyãa Yeroboamu nɛ́gↄ̃gbɛ̃ Abia kũ̀. ");
INSERT INTO bus_vpl VALUES ("K114_2","012_14_2","1KI","14","2","2","Ben Yeroboamu bè a naↄ̃nɛ: Ǹ fɛɛ ǹ n zĩnda liɛ, lɛ wàton n dↄ̃ ma nↄↄ ũro, ǹ gá Silo. Annabi Ahia kú gwe. Àmbe à bèmɛ mɛ́gↄ̃ dɛ Isarailinↄ kína ũ. ");
INSERT INTO bus_vpl VALUES ("K114_3","012_14_3","1KI","14","3","3","Ǹ burɛdi sɛ́ mɛ̀n kuri kↄ̃n kàranↄ kↄ̃n zↄ́ tùuo, ǹ gáonɛ. Eé yã kɛ̀ eé nɛ́ pì lee onnɛ. ");
INSERT INTO bus_vpl VALUES ("K114_4","012_14_4","1KI","14","4","4","Ben Yeroboamu naↄ̃ↄ kɛ̀ lɛ, à fɛ̀ɛ à gàa Silo à gɛ̃̀ Ahia bɛ. Ahia wɛ́ɛ e guu e dↄro, zaakɛ à zi kũ à wɛ́ɛ gↄ̃̀ dãadãa. ");
INSERT INTO bus_vpl VALUES ("K114_5","012_14_5","1KI","14","5","5","Dii gĩakɛ à ò Ahianɛ kɛ̀ Yeroboamu naↄ̃ nɛ́ e gyãa kɛɛ, ben èe mↄↄ lɛ à yã gbekamma. Ǹ onɛ la, ǹ onɛ la, zaakɛ tó à mↄ̀, eé a zĩnda liɛnnɛ gbɛ̃ pãnde ũmɛ. ");
INSERT INTO bus_vpl VALUES ("K114_6","012_14_6","1KI","14","6","6","Kɛ̀ Ahia à kɛ̀sɛ kĩi mà, èe gɛ̃ɛ kpɛ́n, à bè: Ǹ gɛ̃ Yeroboamu naↄ̃! Bↄ́yãnzin n n zĩnda lìɛ lɛzi? Yã pãsĩn Luda bè mà onnɛ. ");
INSERT INTO bus_vpl VALUES ("K114_7","012_14_7","1KI","14","7","7","Ǹ gá ǹ o Yeroboamunɛ, Dii Isarailinↄ Luda bè, ámbe a n sɛ n gbɛ̃nↄ tɛ́, a n kɛ a gbɛ̃ Isarailinↄ dↄn'aɛdee ũ. ");
INSERT INTO bus_vpl VALUES ("K114_8","012_14_8","1KI","14","8","8","A kpata bↄ̀ Dauda boriinↄ ↄzĩ, ben a n kpan, mↄde ń dɛ lán à zↄ̀bleri Dauda bàro, kɛ̀ à a yãdiɛnanↄ kũna, à tɛ́zi kↄ̃n nↄ̀sɛo do à yã kɛ̀ á yezi kɛ̀. ");
INSERT INTO bus_vpl VALUES ("K114_9","012_14_9","1KI","14","9","9","N yã zaaa kɛ̀ dɛ gbɛ̃ kɛ̀ aↄ̃ dↄ̀nnɛ aɛnↄla, n gaa n tãanↄ kɛ̀ n zĩndanɛ, mↄ̀ kɛ̀ ń kàsa pìnↄ, ben n kpɛɛ lìare, n a pↄↄ fɛ̃̀. ");
INSERT INTO bus_vpl VALUES ("K114_10","012_14_10","1KI","14","10","10","Beee yãnzin é mↄ́nzi kpá n boriinↄzizi, é n gↄ̃gbɛ̃nↄ kaatɛ Isarailinↄ guu zↄ̀nↄ kↄ̃n wɛ̃ɛnɛnↄ ń píngi, é tɛ́ sↄ̃ n bɛɛa, lán wè tɛ́ sↄ̃ zùgbↄ̃a nà ai à tɛ́ kũ à yãa píngi. ");
INSERT INTO bus_vpl VALUES ("K114_11","012_14_11","1KI","14","11","11","Gbɛ̃ɛnↄ é n borii kɛ̀ aↄ̃é gaga wɛ́tɛnnↄ só, bãanↄ é n gbɛ̃ kɛ̀ aↄ̃é gaga sɛ̃̀nnↄ ble. Dii bé à ò lɛ. ");
INSERT INTO bus_vpl VALUES ("K114_12","012_14_12","1KI","14","12","12","Mmↄn sↄ̃ nↄgbɛ̃, ǹ fɛɛ ǹ tá bɛ. Tó n kɛ̀sɛ pɛ̀ɛ wɛ́tɛ guu gↄ̃ↄ, nɛ́ pì é ga. ");
INSERT INTO bus_vpl VALUES ("K114_13","012_14_13","1KI","14","13","13","Isarailinↄ é à gɛ̀ ↄ́ↄ dↄ wà à vĩi. Yeroboamu boriinↄ tɛ́ ń píngi, àmbe weé vĩi ado, zaakɛ àmbe ado kɛ̀ Dii Isarailinↄ Luda yã maaa èa Yeroboamu ua. ");
INSERT INTO bus_vpl VALUES ("K114_14","012_14_14","1KI","14","14","14","Dii é kína pãnde diɛ a gbɛ̃ Isarailinↄnɛ. Àmbe eé Yeroboamu boriinↄ dɛdɛ. Gbã̀a kɛ̀a! Bↄ́ↄↄ? Lɛmɛ, tiaaɛmɛ! ");
INSERT INTO bus_vpl VALUES ("K114_15","012_14_15","1KI","14","15","15","Dii é gò tↄ̃ Isarailinↄa, aↄ̃é gↄ̃ lán kàba kɛ̀ èe nigãa í guu bà. Eé Isarailinↄ bↄɛ bùsu maaa kɛ̀ à kpà ń dezinↄa kɛ̀n à ń fãakↄ̃a Yuflati baa kãa kpa, kɛ̀ aↄ̃ Asatorɛ lí pɛ̀ɛpɛɛ aↄ̃ Dii pↄↄ fɛ̃̀onɛ yãnzi. ");
INSERT INTO bus_vpl VALUES ("K114_16","012_14_16","1KI","14","16","16","Eé Isarailinↄ kpáḿma durun kɛ̀ Yeroboamu kɛ̀ à Isarailinↄ dà à kɛnan yãnzi. ");
INSERT INTO bus_vpl VALUES ("K114_17","012_14_17","1KI","14","17","17","Ben Yeroboamu naↄ̃ fɛ̀ɛ èe taa. Kɛ̀ à kà Tiza, kɛ̀ à kɛ̀sɛ zɛ̀ kpɛɛlɛa gↄ̃ↄ, ben nɛ́gↄ̃gbɛ̃ pì gà. ");
INSERT INTO bus_vpl VALUES ("K114_18","012_14_18","1KI","14","18","18","Wà à vĩ̀i, ben Isarailinↄ ↄ́ↄ dↄ̀ ń píngi lán Dii ò a zↄ̀bleri annabi Ahia gãzĩ nà. ");
INSERT INTO bus_vpl VALUES ("K114_19","012_14_19","1KI","14","19","19","Yeroboamu yã kpaaanↄↄ kú Isarailinↄ kínanↄ gĩayãkɛnanↄ takadan, zĩ̀ kɛ̀ à kànↄ kↄ̃n à kíkɛyãnↄ píngi. ");
INSERT INTO bus_vpl VALUES ("K114_20","012_14_20","1KI","14","20","20","Yeroboamu kí blè wɛ̃̀ baro awɛɛplaamɛ. Kɛ̀ à gà, ben à nɛ́ Nadabu vɛ̃̀ɛ à gbɛ̀n. ");
INSERT INTO bus_vpl VALUES ("K114_21","012_14_21","1KI","14","21","21","Sulemanu nɛ́ Reoboamun Yudanↄ kína ũ. À kí blè a wɛ̃̀ baplaa awɛɛdodeemmɛ, ben à kí blè Yerusalɛmu wɛ̃̀ gɛ̃ro awɛɛplaa, wɛ́tɛ kɛ̀ Dii sɛ̀ Isaraili bori píngi wɛ́tɛnↄ tɛ́ lɛ à tↄ́ gↄ̃ kúa. À da tↄ́n Naama, Amↄni boriimɛ. ");
INSERT INTO bus_vpl VALUES ("K114_22","012_14_22","1KI","14","22","22","Yudanↄ yã kɛ̀ Dii yeziroo kɛ̀, aↄ̃ à pↄↄ fɛ̃̀ dɛ ń dezinↄla ń píngi ń durun kɛ̀ aↄ̃ↄ kɛ̀ yãnzi. ");
INSERT INTO bus_vpl VALUES ("K114_23","012_14_23","1KI","14","23","23","Aↄ̃ tãagbãgbãkiinↄ bò ń zĩndanɛ sĩ̀sĩ lezĩ sãnda píngi musu kↄ̃n lí bíta sãnda píngi gbáruo, aↄ̃ gbɛ̀nↄ kↄ̃n línↄ pɛ̀ɛpɛɛn. ");
INSERT INTO bus_vpl VALUES ("K114_24","012_14_24","1KI","14","24","24","Baa se tãagbãgbãki kaaruanↄↄ kú Isarailinↄ bùsun gↄ̃gbɛ̃nↄ kↄ̃n nↄgbɛ̃nↄ. Lɛmɛ Isarailinↄ borii kɛ̀ Dii pɛ̀ḿmańnɛnↄ dà zaaanↄ sɛ̀ɛ lɛ píngi. ");
INSERT INTO bus_vpl VALUES ("K114_25","012_14_25","1KI","14","25","25","Kí Reoboamu kíblena wɛ̃̀ sↄↄrodee guun Igipiti kí Sisaki mↄ̀ à lɛ̀ɛ Yerusalɛmua. ");
INSERT INTO bus_vpl VALUES ("K114_26","012_14_26","1KI","14","26","26","À Dii ua auzikinↄ kↄ̃n kíbɛ pↄ́nↄ nàkↄ̃a à vura sɛngbango kɛ̀ Sulemanu pìnↄ sɛ̀ɛ píngi. ");
INSERT INTO bus_vpl VALUES ("K114_27","012_14_27","1KI","14","27","27","Ben kí Reoboamu sɛngbango pìnↄ gɛ̃ɛ pì kↄ̃n mↄ̀gotɛ̃o à nà a bɛ dogari dↄn'aɛdeenↄnɛ ń ↄzĩ a bɛ kpɛɛlɛ. ");
INSERT INTO bus_vpl VALUES ("K114_28","012_14_28","1KI","14","28","28","Tó kína e gaa Dii ua, dogari pìnↄ ègↄ̃ sɛngbango pìnↄ kũna. Tó aↄ̃ ɛ̀ara wà sù, aↄ̃è ɛara wà káɛ ń kpɛ́n. ");
INSERT INTO bus_vpl VALUES ("K114_29","012_14_29","1KI","14","29","29","Reoboamu yã kpaaanↄ kↄ̃n yã kɛ̀ à kɛ̀nↄ píngi kú Yudanↄ kínanↄ gĩayãkɛnanↄ takadan. ");
INSERT INTO bus_vpl VALUES ("K114_30","012_14_30","1KI","14","30","30","Reoboamu kↄ̃n Yeroboamuo ègↄ̃ zĩ̀ kaa kↄ̃o gurↄ píngi. ");
INSERT INTO bus_vpl VALUES ("K114_31","012_14_31","1KI","14","31","31","Kɛ̀ Reoboamu gà, wà à mira kpàkↄ̃zi kↄ̃n a dezinↄ pↄ́o Dauda wɛ́tɛ. À da tↄ́n Naama, Amↄni boriimɛ. Ben à nɛ́ Abia vɛ̃̀ɛ à gbɛ̀n. ");
INSERT INTO bus_vpl VALUES ("K115_1","012_15_1","1KI","15","1","1","Nɛbati nɛ́ Yeroboamu kíblena wɛ̃̀ baro plaasaidee guun Abia gↄ̃̀ Yudanↄ kína ũ ");
INSERT INTO bus_vpl VALUES ("K115_2","012_15_2","1KI","15","2","2","à kí blè Yerusalɛmu wɛ̃̀ aagↄ̃mɛ. À da tↄ́n Maaka, Abusalomu boriimɛ. ");
INSERT INTO bus_vpl VALUES ("K115_3","012_15_3","1KI","15","3","3","À durun kɛ̀ a dee kɛ̀nↄ kɛ̀ píngi, èe a zĩnda kpá Dii a Ludaa lán a dezi Dauda bàro. ");
INSERT INTO bus_vpl VALUES ("K115_4","012_15_4","1KI","15","4","4","Mↄde Dauda yãnzin Dii à Ludaa tò à bori kí blè Yerusalɛmu, à à borii pì dìɛ à gɛ̃ɛ ũ à tò Yerusalɛmu gbãaa è. ");
INSERT INTO bus_vpl VALUES ("K115_5","012_15_5","1KI","15","5","5","Zaakɛ Dauda yã kɛ̀ Dii yezi kɛ̀, èe gí yã kɛ̀ Dii dìɛnɛ maziro ai a wɛ̃̀ndi lɛ́n, tó èe kɛ yã kɛ̀ à kɛ̀ Iti bori Urianɛ baasiro. ");
INSERT INTO bus_vpl VALUES ("K115_6","012_15_6","1KI","15","6","6","Abia kↄ̃n Yeroboamuo ègↄ̃ zĩ̀ kaa kↄ̃o ai Abia wɛ̃̀ndi lɛ́n. ");
INSERT INTO bus_vpl VALUES ("K115_7","012_15_7","1KI","15","7","7","Abia yã kpaaanↄ kↄ̃n yã kɛ̀ à kɛ̀nↄ píngi kú Yudanↄ kínanↄ gĩayãkɛnanↄ takadan. ");
INSERT INTO bus_vpl VALUES ("K115_8","012_15_8","1KI","15","8","8","Kɛ̀ à gà, wà à vĩ̀ Dauda wɛ́tɛ, ben à nɛ́ Asa vɛ̃̀ɛ à gbɛ̀n. ");
INSERT INTO bus_vpl VALUES ("K115_9","012_15_9","1KI","15","9","9","Isarailinↄ kí Yeroboamu kíblena wɛ̃̀ barodee guun Asa gↄ̃̀ Yudanↄ kína ũ, ");
INSERT INTO bus_vpl VALUES ("K115_10","012_15_10","1KI","15","10","10","ben à kí blè Yerusalɛmu wɛ̃̀ baplaa awɛɛdo. À dazi tↄ́n Maaka, Abusalomu boriimɛ. ");
INSERT INTO bus_vpl VALUES ("K115_11","012_15_11","1KI","15","11","11","Kí Asa yã kɛ̀ Dii yezi kɛ̀ lán a dezi Dauda bà. ");
INSERT INTO bus_vpl VALUES ("K115_12","012_15_12","1KI","15","12","12","À pɛ̀ tãagbãgbãki kaaruanↄa a bùsun, ben à tãa kɛ̀ a dezinↄ kɛ̀nↄ kwɛ̀ píngi. ");
INSERT INTO bus_vpl VALUES ("K115_13","012_15_13","1KI","15","13","13","Baa se à a dazi Maaka bↄ̀ kpatan, kɛ̀ à Asatorɛ lí gina pɛ̀ɛ yãnzi. Kí Asa lí pì zↄ̃̀ à tɛ́ sↄ̃̀a Kidironu guzurɛn. ");
INSERT INTO bus_vpl VALUES ("K115_14","012_15_14","1KI","15","14","14","À a zĩnda kpà Diia ai a wɛ̃̀ndi lɛ́n, mↄde èe tãagbãgbãkii kɛ̀ wà bònↄ gbororo. ");
INSERT INTO bus_vpl VALUES ("K115_15","012_15_15","1KI","15","15","15","À vura kↄ̃n kondogio kↄ̃n pↄ́ pãnde kɛ̀ api kↄ̃n a deo dìɛ Dii pↄ́ ũunↄ sɛ̀ɛ à kàɛ Dii ua. ");
INSERT INTO bus_vpl VALUES ("K115_16","012_15_16","1KI","15","16","16","Asa kↄ̃n Isarailinↄ kí Baasao ègↄ̃ zĩ̀ kaa kↄ̃o ai ń kíblena gurↄlɛn. ");
INSERT INTO bus_vpl VALUES ("K115_17","012_15_17","1KI","15","17","17","Baasa bé à gàa à lɛ̀ɛ Yudanↄ bùsua, ben èe bĩi boo à liga Ramazi, lɛ gbɛ̃ke tón bↄ ke à gɛ̃ Yudanↄ kí Asa bùsunlo yãnzi. ");
INSERT INTO bus_vpl VALUES ("K115_18","012_15_18","1KI","15","18","18","Ben Asa kondogi kↄ̃n vura kɛ̀ gↄ̃̀ Dii ua làasinnↄ sɛ̀ɛ kↄ̃n pↄ́ kɛ̀ kú a bɛ làasinnↄ, à nà a ìbanↄnɛ ń ↄzĩ, ben à ń zĩ Damasiku, Siria bùsu kí Bɛnadada, Tabirimↄ nɛ́, Ɛziↄ̃ dio kiia à bè: ");
INSERT INTO bus_vpl VALUES ("K115_19","012_15_19","1KI","15","19","19","Wà lɛdolɛ kɛ lán ma de kↄ̃n n deo kɛ̀ nà yã. À kondogi kↄ̃n vuraon yɛ̀. Ǹ lɛdolɛ kɛ̀ ń vĩ kↄ̃n Isarailinↄ kí Baasao gboro, lɛ à gumala kↄ̃n a zĩ̀kpɛɛnↄ. ");
INSERT INTO bus_vpl VALUES ("K115_20","012_15_20","1KI","15","20","20","Ben Bɛnadada lɛdolɛ kɛ̀ kↄ̃n Asao à a zĩ̀kpɛɛnↄ gbàrɛ aↄ̃ gàa wà lɛ̀ɛ Isaraili wɛ́tɛnↄa. Aↄ̃ Iyona sì kↄ̃n Danio kↄ̃n Abɛli Bɛtɛmakao kↄ̃n Gɛnɛsarɛti guuo kↄ̃n Nafatali boriinↄ guuo dↄ píngi. ");
INSERT INTO bus_vpl VALUES ("K115_21","012_15_21","1KI","15","21","21","Kɛ̀ Baasa à baaru mà, ben à bĩibona Ramazi tò à tà Tiza. ");
INSERT INTO bus_vpl VALUES ("K115_22","012_15_22","1KI","15","22","22","Ben kí Asa kpàakpa kɛ̀ Yudanↄnɛ ń píngi, èe gbɛ̃ke tɛ̃̀ boro à bè, aↄ̃ Rama gbɛ̀nↄ kↄ̃n lí kɛ̀ Baasa e bĩi booonↄ sɛ́ɛ. Ben à bĩi bòo à lìga Gɛba kɛ̀ kú Bɛyãmi boriinↄ guuzi kↄ̃n Mizipao. ");
INSERT INTO bus_vpl VALUES ("K115_23","012_15_23","1KI","15","23","23","Kí Asa yã kpaaanↄↄ kú Yudanↄ kínanↄ gĩayãkɛnanↄ takadan, à nɛ́gↄ̃gbɛ̃kɛyãnↄ kↄ̃n yã kɛ̀ à kɛ̀nↄ píngi kↄ̃n wɛ́tɛ bĩi kɛ̀ à bònↄ. Kɛ̀ à zi kũ̀, gyãa à kũ̀ a gbálanↄa. ");
INSERT INTO bus_vpl VALUES ("K115_24","012_15_24","1KI","15","24","24","Kɛ̀ à gà, wà à mira kpàkↄ̃zi kↄ̃n a dezinↄ pↄ́o a dezi Dauda wɛ́tɛ, ben à nɛ́ Yosafata vɛ̃̀ɛ à gbɛ̀n. ");
INSERT INTO bus_vpl VALUES ("K115_25","012_15_25","1KI","15","25","25","Yudanↄ kí Asa kíblena wɛ̃̀ plaadee guun Yeroboamu nɛ́ Nadabu kɛ̀ Isarailinↄ kína ũ à kí blè wɛ̃̀ plaamɛ. ");
INSERT INTO bus_vpl VALUES ("K115_26","012_15_26","1KI","15","26","26","À yã kɛ̀ Dii yeziroo kɛ̀ kɛ̀ à zɛ̀ kↄ̃n yã kɛ̀ a dee kɛ̀ à Isarailinↄ dà durun guuo. ");
INSERT INTO bus_vpl VALUES ("K115_27","012_15_27","1KI","15","27","27","Ahia nɛ́ Baasa, Isaka bori lɛ́ kpàkↄ̃sↄ̃zi gurↄↄ kɛ̀ àpi kↄ̃n Isarailinↄↄ e ligaa Filisitini wɛ́tɛ Gibetↄ̃zi, ben à à dɛ̀ gwe. ");
INSERT INTO bus_vpl VALUES ("K115_28","012_15_28","1KI","15","28","28","À à dɛ̀ Yudanↄ kí Asa kíblena wɛ̃̀ aagↄ̃dee guumɛ, ben à vɛ̃̀ɛ à gbɛ̀n. ");
INSERT INTO bus_vpl VALUES ("K115_29","012_15_29","1KI","15","29","29","Kɛ̀ à nà kíblenaa, ben à Yeroboamu boriinↄ dɛ̀dɛ ń píngi, èe ń gbɛ̃ke tóro, à ń káatɛ lán Dii ò a zↄ̀bleri Ahia, Silo gbɛ̃ gãzĩ nà. ");
INSERT INTO bus_vpl VALUES ("K115_30","012_15_30","1KI","15","30","30","Yã pì kɛ̀ lɛ durun kɛ̀ Yeroboamu kɛ̀ yãnzi, kɛ̀ à Isarailinↄ dà à kɛnan à Dii Isarailinↄ Luda pↄↄ fɛ̃̀onɛ. ");
INSERT INTO bus_vpl VALUES ("K115_31","012_15_31","1KI","15","31","31","Nadabu yã kpaaanↄ kↄ̃n yã kɛ̀ à kɛ̀nↄ píngi kú Isarailinↄ kínanↄ gĩayãkɛnanↄ takadan. ");
INSERT INTO bus_vpl VALUES ("K115_32","012_15_32","1KI","15","32","32","Kí Asa kↄ̃n Isarailinↄ kí Baasao zĩ̀ kà kↄ̃o ai ń kíblena gurↄlɛmmɛ. ");
INSERT INTO bus_vpl VALUES ("K115_33","012_15_33","1KI","15","33","33","Yudanↄ kí Asa kíblena wɛ̃̀ aagↄ̃dee guun Ahia nɛ́ Baasa kɛ̀ Isarailinↄ kína ũ. À kí blè Tiza wɛ̃̀ baro awɛɛsiigↄ̃. ");
INSERT INTO bus_vpl VALUES ("K115_34","012_15_34","1KI","15","34","34","À yã kɛ̀ Dii yeziroo kɛ̀, kɛ̀ à zɛ̀ kↄ̃n Yeroboamu yãkɛnao kↄ̃n durun kɛ̀ à Isarailinↄ dà à kɛnan-o. ");
INSERT INTO bus_vpl VALUES ("K116_1","012_16_1","1KI","16","1","1","Dii yã sù Anani nɛ́ Yehua, ben à yã ò Baasanɛ à bè: ");
INSERT INTO bus_vpl VALUES ("K116_2","012_16_2","1KI","16","2","2","Ma n bↄ bùsutin, ma n kɛ ma gbɛ̃ Isarailinↄ dↄn'aɛdee ũ, ben n zɛ kↄ̃n Yeroboamu yãkɛnanↄo n ma gbɛ̃ Isarailinↄ dà durun guu, ben aↄ̃ durun pìnↄ ma pↄↄ fɛ̃̀. ");
INSERT INTO bus_vpl VALUES ("K116_3","012_16_3","1KI","16","3","3","Mmↄn kↄ̃n n boriinↄ, mɛ́ a dúgu zↄ̃mɛ sa. Mɛ́ kɛ n uanɛ lán má kɛ̀ Nɛbati nɛ́ Yeroboamu uanɛ nà. ");
INSERT INTO bus_vpl VALUES ("K116_4","012_16_4","1KI","16","4","4","Gbɛ̃ɛnↄ é n gbɛ̃ kɛ̀ aↄ̃é gaga wɛ́tɛ guunↄ só, bãanↄ é n gbɛ̃ kɛ̀ aↄ̃é gaga sɛ̃̀nnↄ ble. ");
INSERT INTO bus_vpl VALUES ("K116_5","012_16_5","1KI","16","5","5","Baasa yã kpaaanↄ, yã kɛ̀ à kɛ̀nↄ kↄ̃n à nɛ́gↄ̃gbɛ̃kɛyãnↄↄ kú Isarailinↄ kínanↄ gĩayãkɛnanↄ takadan. ");
INSERT INTO bus_vpl VALUES ("K116_6","012_16_6","1KI","16","6","6","Kɛ̀ Baasa gà, wà à vĩ̀i Tiza, ben à nɛ́ Ela vɛ̃̀ɛ à gbɛ̀n. ");
INSERT INTO bus_vpl VALUES ("K116_7","012_16_7","1KI","16","7","7","Dii yã pì ò Baasanɛ kↄ̃n a boriinↄ annabi Yehu, Anani nɛ́ gãzĩ, yã zaaa kɛ̀ à kɛ̀ à Dii pↄↄ fɛ̃̀onɛ lán Yeroboamu boriinↄↄ kɛ̀ nà yãnzi kↄ̃n Yeroboamu borii kɛ̀ à ń kaatɛnↄ yão dↄ. ");
INSERT INTO bus_vpl VALUES ("K116_8","012_16_8","1KI","16","8","8","Yudanↄ kí Asa kíblena wɛ̃̀ baaasↄↄro awɛɛdodee guun Baasa nɛ́ Ela kɛ̀ Isarailinↄ kína ũ à vɛ̃̀ɛ Tiza wɛ̃̀ plaa. ");
INSERT INTO bus_vpl VALUES ("K116_9","012_16_9","1KI","16","9","9","À ìbanↄ do Zimirin à sↄ̃goronↄ kpadoo gbɛ̃nsi ũ, ben à lɛ́ kpàkↄ̃sↄ̃zińyo. Gurↄↄ kɛ̀ í Ela kũ̀ a bɛgwari Aza kpɛ́n zaa Tiza, ");
INSERT INTO bus_vpl VALUES ("K116_10","012_16_10","1KI","16","10","10","ben Zimiri gɛ̃̀ à à dɛ̀ Asa kíblena wɛ̃̀ baaasↄↄro awɛɛplaadee guu, ben à vɛ̃̀ɛ à gbɛ̀n. ");
INSERT INTO bus_vpl VALUES ("K116_11","012_16_11","1KI","16","11","11","Kɛ̀ à kí blè gↄ̃ↄ, ben à Baasa boriinↄ dɛ̀dɛ ń píngi, èe gↄ̃gbɛ̃ ke tó à danɛnↄ ke à gbɛ̃nnanↄ tɛ́ro. ");
INSERT INTO bus_vpl VALUES ("K116_12","012_16_12","1KI","16","12","12","À Baasa borii pìnↄ kàatɛ ń píngimɛ, lán Dii ò annabi Yehu gãzĩ nà. ");
INSERT INTO bus_vpl VALUES ("K116_13","012_16_13","1KI","16","13","13","Baasa kↄ̃n a nɛ́ Elao Dii Isarailinↄ Luda pↄↄ fɛ̃̀nɛ durun kɛ̀ aↄ̃ↄ kɛ̀ tãa pãpãanↄ yã musu, ben dↄ aↄ̃ Isarailinↄ dà à kɛnan yãnzi. ");
INSERT INTO bus_vpl VALUES ("K116_14","012_16_14","1KI","16","14","14","Ela yã kpaaanↄ kↄ̃n yã kɛ̀ à kɛ̀nↄ píngi kú Isarailinↄ kínanↄ gĩayãkɛnanↄ takadan. ");
INSERT INTO bus_vpl VALUES ("K116_15","012_16_15","1KI","16","15","15","Yudanↄ kí Asa kíblena wɛ̃̀ baaasↄↄro awɛɛplaadee guun Zimiri kí blè Tiza gurↄ swɛɛplaa. Gurↄ beeea Isaraili zĩ̀kpɛɛnↄ bùra kú Filisitini wɛ́tɛ Gibetↄ̃ saɛ. ");
INSERT INTO bus_vpl VALUES ("K116_16","012_16_16","1KI","16","16","16","Kɛ̀ zĩ̀kpɛɛ pìnↄↄ mà Zimiri lɛ́ kpàkↄ̃sↄ̃ kↄ̃n gbɛ̃nↄ kínazi à à dɛ̀, ben aↄ̃ ń dↄn'aɛde Ɔmiri kà Isarailinↄ kína ũ ń bùran gwe gↄ̃ↄ. ");
INSERT INTO bus_vpl VALUES ("K116_17","012_16_17","1KI","16","17","17","Ben Ɔmiri kↄ̃n Isaraili zĩ̀kpɛɛnↄ fɛ̀ɛ Gibetↄ̃ aↄ̃ gàa wà lìga Tizazi. ");
INSERT INTO bus_vpl VALUES ("K116_18","012_16_18","1KI","16","18","18","Kɛ̀ Zimiri è aↄ̃ a wɛ́tɛ sìawa, ben à dìdi à gɛ̃̀ a bɛ kpɛ́didikↄ̃ana musun à tɛ́ sↄ̃̀a, ben à tɛ́ kũ̀, à gà ");
INSERT INTO bus_vpl VALUES ("K116_19","012_16_19","1KI","16","19","19","durun kɛ̀ à kɛ̀ yãnzi. À yã kɛ̀ Dii yeziroo kɛ̀ kɛ̀ à zɛ̀ kↄ̃n Yeroboamu yãkɛnao. À durun kɛ̀, ben dↄ à Isarailinↄ dà à kɛnan. ");
INSERT INTO bus_vpl VALUES ("K116_20","012_16_20","1KI","16","20","20","Zimiri yã kpaaanↄ kↄ̃n lɛ́ kɛ̀ à kpàkↄ̃sↄ̃ńyo Elazio kú Isarailinↄ kínanↄ gĩayãkɛnanↄ takadan. ");
INSERT INTO bus_vpl VALUES ("K116_21","012_16_21","1KI","16","21","21","Isarailinↄ kpàatɛ lɛo plaa. Aↄ̃ kpadoonↄↄ yezi wà Ginati nɛ́ Tibini ká kí ũ, ń kpadoonↄ sↄ̃ Ɔmiri. ");
INSERT INTO bus_vpl VALUES ("K116_22","012_16_22","1KI","16","22","22","Kɛ̀ gbɛ̃ kɛ̀ aↄ̃ zɛ̀ kↄ̃n Ɔmirionↄ gbãaa dɛ̀ gbɛ̃ kɛ̀ aↄ̃ zɛ̀ kↄ̃n Ginati nɛ́ Tibinionↄla, ben wà Tibini dɛ̀, Ɔmiri kí blè. ");
INSERT INTO bus_vpl VALUES ("K116_23","012_16_23","1KI","16","23","23","Yudanↄ kí Asa kíblena wɛ̃̀ baaakuri awɛɛdodee guun Ɔmiri kɛ̀ Isarailinↄ kína ũ, à kí blè wɛ̃̀ kuri awɛɛplaa. À kɛ̀ Tiza wɛ̃̀ swɛɛdo, ");
INSERT INTO bus_vpl VALUES ("K116_24","012_16_24","1KI","16","24","24","ben à Samaria sĩ̀sĩ lù Sɛmaa kↄ̃n kondogio kiloo baaagↄ̃ akuri, ben à wɛ́tɛ kàɛa à tↄ́ kpànɛ Samaria kɛ̀ Sɛma bé à sĩ̀sĩ pì vĩ yã yãnzi. ");
INSERT INTO bus_vpl VALUES ("K116_25","012_16_25","1KI","16","25","25","Ɔmiri yã kɛ̀ Dii yeziroo kɛ̀ à durun kɛ̀ dɛ gbɛ̃ kɛ̀ aↄ̃ dↄ̀nɛ aɛnↄ pↄ́la ń píngi. ");
INSERT INTO bus_vpl VALUES ("K116_26","012_16_26","1KI","16","26","26","À zɛ̀ kↄ̃n Nɛbati nɛ́ Yeroboamu yãkɛnao píngi. À Dii Isarailinↄ Luda pↄↄ fɛ̃̀nɛ kↄ̃n durun kɛ̀ à kɛ̀ tãa pãpãanↄ yã musuo à Isarailinↄ dà à kɛnan dↄ. ");
INSERT INTO bus_vpl VALUES ("K116_27","012_16_27","1KI","16","27","27","Ɔmiri yã kpaaanↄ kↄ̃n yã kɛ̀ à kɛ̀nↄ kↄ̃n à nɛ́gↄ̃gbɛ̃kɛyãnↄↄ kú Isarailinↄ kínanↄ gĩayãkɛnanↄ takadan. ");
INSERT INTO bus_vpl VALUES ("K116_28","012_16_28","1KI","16","28","28","Kɛ̀ à gà, wà à vĩ̀i Samaria, ben à nɛ́ Ahabu vɛ̃̀ɛ à gbɛ̀n. ");
INSERT INTO bus_vpl VALUES ("K116_29","012_16_29","1KI","16","29","29","Yudanↄ kí Asa kíblena wɛ̃̀ baplaa plaasaidee guun Ɔmiri nɛ́ Ahabu kɛ̀ Isarailinↄ kína ũ à kí blè Samaria wɛ̃̀ baro awɛɛplaamɛ. ");
INSERT INTO bus_vpl VALUES ("K116_30","012_16_30","1KI","16","30","30","À yã kɛ̀ Dii yeziroo kɛ̀ dɛ gbɛ̃ kɛ̀ aↄ̃ dↄ̀nɛ aɛnↄ pↄ́la ń píngi. ");
INSERT INTO bus_vpl VALUES ("K116_31","012_16_31","1KI","16","31","31","À zɛna kↄ̃n Nɛbati nɛ́ Yeroboamu durunkɛnao e kɛnɛ yãke ũro, ben à Sidↄ̃deenↄ kí Ɛtabaali nɛ́nↄgbɛ̃ Yɛzɛbɛli sɛ̀ nↄↄ ũ, ben à nà Baali tãagbãgbãnaa, ègↄ̃ kuɛɛnɛ. ");
INSERT INTO bus_vpl VALUES ("K116_32","012_16_32","1KI","16","32","32","À kpɛ́ bò Baalinɛ Samaria, ben à à gbãgbãkii pɛ̀ɛ kpɛ́ pì guu. ");
INSERT INTO bus_vpl VALUES ("K116_33","012_16_33","1KI","16","33","33","À Asɛra lí pɛ̀ɛn dↄ à ɛ̀ara à Dii Isarailinↄ Luda pↄↄ fɛ̃̀nɛ dɛ Isarailinↄ kína kɛ̀ aↄ̃ dↄ̀nɛ aɛnↄ pↄ́la ń píngi. ");
INSERT INTO bus_vpl VALUES ("K116_34","012_16_34","1KI","16","34","34","Ahabu gurↄↄan Bɛtɛli gbɛ̃ Iyɛli Yɛriko kɛ̀kɛ à kàɛ. Kɛ̀ à à bĩi ɛ̃ɛ dàɛ, ben à nɛ́gↄ̃gbɛ̃ káaku Abiramu gà. Kɛ̀ à à zɛ́ gbànↄ pɛ̀ɛ, ben à nɛ́ zãade Segubu gà lán Dii ò Nuni nɛ́ Yↄsua gãzĩ nà. ");
INSERT INTO bus_vpl VALUES ("K117_1","012_17_1","1KI","17","1","1","Tisibɛ gbɛ̃ Ilia bↄ̀ a bɛ Giliada bùsun à gàa à Ahabu lè à bè: Kↄ̃n Dii Isarailinↄ Luda kɛ̀ mɛ́ɛ dↄↄzi kuunao, zaa wɛ̃̀ kɛ̀a kpíi é kpáro, lou é maro, séde gurↄↄ kɛ̀ má ò baasiro. ");
INSERT INTO bus_vpl VALUES ("K117_2","012_17_2","1KI","17","2","2","Ben Dii yã sù Iliaa à bè: ");
INSERT INTO bus_vpl VALUES ("K117_3","012_17_3","1KI","17","3","3","Ǹ fɛɛ ǹ gá ↄfãntɛ̃bↄɛ kpa, ǹ utɛ Kɛriti swawɛɛn Yoda baa kãa kpa. ");
INSERT INTO bus_vpl VALUES ("K117_4","012_17_4","1KI","17","4","4","Nɛ́gↄ̃ swaa pì í mii. Má dìɛ gbáa kãnkãnanↄnɛ aↄ̃gↄ̃ n gwaa gwe. ");
INSERT INTO bus_vpl VALUES ("K117_5","012_17_5","1KI","17","5","5","Ben à gàa à kɛ̀ lán Dii ònɛ nà, à vɛ̃̀ɛ Kɛ riti swawɛɛn Yoda baa kãa kpa. ");
INSERT INTO bus_vpl VALUES ("K117_6","012_17_6","1KI","17","6","6","Gbáa kãnkãnanↄ ègↄ̃ mↄↄnɛ kↄ̃n burɛdio kↄ̃n nↄ̀bↄo kↄngↄ kↄ̃n uusiɛo, ben ègↄ̃ swaa pì í mii. ");
INSERT INTO bus_vpl VALUES ("K117_7","012_17_7","1KI","17","7","7","Gurↄ plaaa gbɛra swaa pì í bàba kɛ̀ lou e ma bùsu pìnlo yãnzi. ");
INSERT INTO bus_vpl VALUES ("K117_8","012_17_8","1KI","17","8","8","Ben Dii yã sùa à bè: ");
INSERT INTO bus_vpl VALUES ("K117_9","012_17_9","1KI","17","9","9","Ǹ fɛɛ ǹ gá Zarɛfa Sidↄ̃ bùsun, ǹgↄ̃ kú gwe. Ma gyaanↄ ke dìɛ àgↄ̃ n gwaa gwe. ");
INSERT INTO bus_vpl VALUES ("K117_10","012_17_10","1KI","17","10","10","Ben à fɛ̀ɛ èe gaa Zarɛfa. Kɛ̀ à kà wɛ́tɛ pì saɛ, à gyaanↄ ke lè, èe yàka wɛɛ gwe. Ben Ilia lɛ́ zù gyaanↄↄ pìzi à bè: Ǹ gá mↄ́mɛ kↄ̃n ío, baa féte, mà mi. ");
INSERT INTO bus_vpl VALUES ("K117_11","012_17_11","1KI","17","11","11","Kɛ̀ èe gaa tↄ́, Ilia ɛ̀ara à lɛ́ zùzi à bè: Ǹ mↄ́mɛ kↄ̃n burɛdi kusuo dↄ. ");
INSERT INTO bus_vpl VALUES ("K117_12","012_17_12","1KI","17","12","12","Ben nↄgbɛ̃ pì bènɛ: Kↄ̃n Dii n Luda kuunao, baa burɛdi má vĩro, séde wísiti ↄkũ doo kɛ̀ gↄ̃̀ gbaka guu kↄ̃n nↄ́sio féte tùu guu baasiro. À yàkan mɛ́ɛ wɛɛ kɛ̀, lɛ mà tá bɛ mà pↄ́blee kɛo, wà ble kↄ̃n ma nɛ́o wàgↄ̃ ga dãa. ");
INSERT INTO bus_vpl VALUES ("K117_13","012_17_13","1KI","17","13","13","Ben Ilia bènɛ: Ǹton tó vĩa n kũro. Ǹ gá kɛ lán ń ò nà, mↄde ǹ burɛdi kɛo féte ǹ mↄ́omɛ gĩa, nɛ́ gbasa ǹ n pↄ́ kɛ kↄ̃n n nɛ́o. ");
INSERT INTO bus_vpl VALUES ("K117_14","012_17_14","1KI","17","14","14","Zaakɛ Dii Isarailinↄ Luda bè, wísiti gbaka pì égↄ̃ da koriro, bensↄ̃ nↄ́si é yãa tùu pìnlo ai gurↄↄ kɛ̀ eé tó lou ma bùsu pìn. ");
INSERT INTO bus_vpl VALUES ("K117_15","012_17_15","1KI","17","15","15","Gyaanↄↄ pì gàa à kɛ̀ lán Ilia ònɛ nà, ben pↄ́blee mↄ̀ḿma ai gurↄ ũgbangba, àpi kↄ̃n a bɛdeenↄ kↄ̃n Iliao. ");
INSERT INTO bus_vpl VALUES ("K117_16","012_17_16","1KI","17","16","16","Wísiti e yãa gbaka pìnlo, bensↄ̃ nↄ́si e yãa tùu pìnlo, lán Dii ò Ilia gãzĩ nà. ");
INSERT INTO bus_vpl VALUES ("K117_17","012_17_17","1KI","17","17","17","Beee gbɛra nↄgbɛ̃ bɛdee pì nɛ́ e gyãa kɛɛ. Kɛ̀ gyãa gbãaa kpà maamaa, ben à wɛ̃̀ndi bↄ̀. ");
INSERT INTO bus_vpl VALUES ("K117_18","012_17_18","1KI","17","18","18","Ben nↄgbɛ̃ pì bè Ilianɛ: Luda gbɛ̃, bↄ́ bé à wa ka kɛ̀ n mↄmazii? N mↄ ma durun dↄ Ludan lɛ à ma nɛ́ dɛ yãnzin yↄ́? ");
INSERT INTO bus_vpl VALUES ("K117_19","012_17_19","1KI","17","19","19","Ben Ilia bènɛ: Ǹ n nɛ́ pì kpáma. Ben à nɛ́ pì sì nↄgbɛ̃ pì ↄzĩ à dìdio kpɛ́ musu guu kɛ̀ à pìtan. À à dàɛ a gádoa gwe, ");
INSERT INTO bus_vpl VALUES ("K117_20","012_17_20","1KI","17","20","20","ben à wii pɛ̀ Diizi à bè: Dii ma Luda, ḿbe ń tò gyaanↄↄ kɛ̀ ma pita à bɛ nɛ́ gà n pↄsiaa kpàziↄ́? ");
INSERT INTO bus_vpl VALUES ("K117_21","012_17_21","1KI","17","21","21","Ben à dàɛ à a zĩnda pòro nɛ́gↄ̃gbɛ̃ pìla gɛ̃̀n aagↄ̃ à wii pɛ̀ Diizi à bè: Dii ma Luda, ǹ tó à wɛ̃̀ndi ɛara à su à mɛ̀ guu. ");
INSERT INTO bus_vpl VALUES ("K117_22","012_17_22","1KI","17","22","22","Dii Ilia wiipɛna mà, ben wɛ̃̀ndi ɛ̀ara à sù nɛ́ pìa à fɛ̀ɛ. ");
INSERT INTO bus_vpl VALUES ("K117_23","012_17_23","1KI","17","23","23","Kɛ̀ Ilia nɛ́gↄ̃gbɛ̃ pì sɛ̀ à pìtao, à gɛ̃̀o kpɛ́n, ben à à kpà à daa à bè: Ǹ gwa, n nɛ́ pì wɛ̃̀ndi sù! ");
INSERT INTO bus_vpl VALUES ("K117_24","012_17_24","1KI","17","24","24","Ben nↄgbɛ̃ pì bè Ilianɛ: Má dↄ̃ sa kɛ̀ Luda gbɛ̃n n ũ. Dii yã kɛ̀ bↄ̀ n lɛ́n nɛ́ yãpuraamɛ. ");
INSERT INTO bus_vpl VALUES ("K118_1","012_18_1","1KI","18","1","1","À gurↄ plaaa kɛ̀, ben Dii yã sù Iliaa lousaiwɛ̃ aagↄ̃dee guu à bè: Ǹ gá ǹ n zĩnda ↄdↄa Ahabunɛ, mɛ́ tó lou ma à bùsun. ");
INSERT INTO bus_vpl VALUES ("K118_2","012_18_2","1KI","18","2","2","Ben Ilia fɛ̀ɛ èe gaa a zĩnda ↄdↄa Ahabunɛ. Kɛ̀ dekaa gbãaa kpà Samaria, ");
INSERT INTO bus_vpl VALUES ("K118_3","012_18_3","1KI","18","3","3","ben Ahabu a bɛgwari Obadia sìsi. Obadia pì sↄ̃ↄ Dii vĩa vĩ maamaa. ");
INSERT INTO bus_vpl VALUES ("K118_4","012_18_4","1KI","18","4","4","Kɛ̀ Yɛzɛbɛli e Dii annabinↄ dɛdɛ yã, ben Obadia ń gbɛ̃ kenↄ sɛ̀ɛ gↄ̃ↄn basↄↄro à ń útɛ gbɛ̀wɛɛnↄ guu gↄ̃ↄn baplaa akurikuri, ben à ń gwá kↄ̃n pↄ́bleeo kↄ̃n ío. ");
INSERT INTO bus_vpl VALUES ("K118_5","012_18_5","1KI","18","5","5","Ben Ahabu bè Obadianɛ: Wà dↄdↄ guuzi wà gá íbↄkiinↄ kↄ̃n swawɛɛnↄn píngi. Wègↄ̃ dↄ̃ro ke wé sɛ̃̀ e wà kpá wa sↄ̃nↄa kↄ̃n wa bãagãsↄ̃nↄ. ");
INSERT INTO bus_vpl VALUES ("K118_6","012_18_6","1KI","18","6","6","Ben aↄ̃ guu kpàatɛ, aↄ̃ baade a zɛ́ sɛ̀. ");
INSERT INTO bus_vpl VALUES ("K118_7","012_18_7","1KI","18","7","7","Kɛ̀ Obadia tɛna, ben aↄ̃ kpàkↄ̃a kↄ̃n Iliao. À à dↄ̃̀, ben à dàɛ a puua à bè: Ma dii Ilia, ḿbe gweↄ́? ");
INSERT INTO bus_vpl VALUES ("K118_8","012_18_8","1KI","18","8","8","Ilia wèàla à bè: Mámbee! Ǹ gá o n diinɛ má kú kɛ̀. ");
INSERT INTO bus_vpl VALUES ("K118_9","012_18_9","1KI","18","9","9","Ben Obadia bè: Bↄ́ taarin má kɛ̀, kɛ̀ nɛ́ɛ mamↄma n zↄ̀bleri naa Ahabunɛ a ↄzĩ à ma dɛɛ? ");
INSERT INTO bus_vpl VALUES ("K118_10","012_18_10","1KI","18","10","10","Má sì kↄ̃n Dii n Ludao bori ke bùsu kee kuu kɛ̀ ma dii gì gbɛ̃nↄ zĩḿma wà n wɛtɛnziro. Tó wà bè ń kú gwero, è tó aↄ̃ ladamɛ. ");
INSERT INTO bus_vpl VALUES ("K118_11","012_18_11","1KI","18","11","11","Ben nɛ́ɛ oomɛ dↄ mà gá mà o ma dii Ahabunɛ kɛ̀ ń kú kɛ̀ↄ́? ");
INSERT INTO bus_vpl VALUES ("K118_12","012_18_12","1KI","18","12","12","Tó ma da zɛ́n, mɛ́gↄ̃ dↄ̃ guu kɛ̀ Dii Nini é n sɛ́ à tányoro. Tó ma gaa má ò Ahabunɛ, tó à mↄ̀ èe n ero, eé ma dɛmɛ. Mamↄma n zↄ̀bleri sↄ̃ má Dii vĩa vĩ zaa ma ↄ̀wazikɛgurↄmɛ. ");
INSERT INTO bus_vpl VALUES ("K118_13","012_18_13","1KI","18","13","13","Ma dii Ilia, kɛ̀ Yɛzɛbɛli e Dii annabinↄ dɛdɛɛ, nɛ́ɛ yã kɛ̀ má kɛ̀ maroo? Mámbe ma ń gbɛ̃kenↄ sɛ̀ɛ gↄ̃ↄn basↄↄro, ma ń útɛ gbɛ̀wɛɛnↄ guu gↄ̃ↄn baplaa akurikuri, ma ń gwá kↄ̃n pↄ́bleeo kↄ̃n ío. ");
INSERT INTO bus_vpl VALUES ("K118_14","012_18_14","1KI","18","14","14","Ben n bèmɛ dↄ mà gá mà o ma dii Ahabunɛ ń kú kɛ̀ↄ́? Eé ma dɛee. ");
INSERT INTO bus_vpl VALUES ("K118_15","012_18_15","1KI","18","15","15","Ben Ilia bè: Má sì kↄ̃n Dii Zĩ̀kpɛde kɛ̀ mɛ́ɛ dↄↄzio, mɛ́ ma zĩnda ↄdↄanɛ gbã̀a sa. ");
INSERT INTO bus_vpl VALUES ("K118_16","012_18_16","1KI","18","16","16","Ben Obadia gàa à dà Ahabulɛ à yã pì ònɛ, ben Ahabu gàa da Ilialɛ. ");
INSERT INTO bus_vpl VALUES ("K118_17","012_18_17","1KI","18","17","17","Kɛ̀ Ahabu Ilia è, à bènɛ: Isarailinↄ bùsu dɛ̀ri, ḿbe gweↄ́? ");
INSERT INTO bus_vpl VALUES ("K118_18","012_18_18","1KI","18","18","18","Ben Ilia bè: Èe kɛ mámbe ma Isarailinↄ bùsu dɛ̀ro, ḿbe kↄ̃n n de bɛdeenↄ ámbe á dɛ̀, zaakɛ a pã kpà Dii yãdiɛnanↄzi a dↄ Baalizi. ");
INSERT INTO bus_vpl VALUES ("K118_19","012_18_19","1KI","18","19","19","Ǹ Isarailinↄ sísi ń píngi, wà dakↄ̃rɛ Kamɛli kpiii musu lɛdo kↄ̃n Baali tãagbãgbãri gↄ̃ↄn wàa plaa kpɛ́ baplaa akuri kↄ̃n Asɛra tãade gↄ̃ↄn wàa plaaa kɛ̀ aↄ̃è pↄ́ ble kↄ̃n Yɛzɛbɛlionↄ. ");
INSERT INTO bus_vpl VALUES ("K118_20","012_18_20","1KI","18","20","20","Ahabu Isarailinↄ sìsi ń píngi, ben à tãadee pìnↄ kàkↄ̃a Kamɛli kpiii musu. ");
INSERT INTO bus_vpl VALUES ("K118_21","012_18_21","1KI","18","21","21","Ben Ilia sↄ̃̀ gbɛ̃nↄzi à ń lá à bè: A laasuu égↄ̃ kpaatɛna ai bↄrɛmɛ? Tó Dii nɛ́ Ludamɛ, à tɛ́zi. Tó Baalimɛ sↄ̃, à tɛ́zi. Aↄ̃ↄe yãke siàlaro, ");
INSERT INTO bus_vpl VALUES ("K118_22","012_18_22","1KI","18","22","22","ben Ilia bèńnɛ: Dii annabinↄ tɛ́ mámbe ma gↄ̃ mado. Baali tãagbãgbãrinↄ sↄ̃, gↄ̃ↄn wàa plaa kpɛ́ baplaa akurimɛ. ");
INSERT INTO bus_vpl VALUES ("K118_23","012_18_23","1KI","18","23","23","À zùswareenↄ kpáwa mɛ̀n plaa, tãadee pìnↄ à mɛ̀n doo sɛ́ aↄ̃ zↄ̃zↄ̃kↄ̃rɛ wà ká yàkala, aↄ̃ton tɛ́ naaro. Mamↄma sↄ̃, mɛ́ à doo kɛkɛ mà ká yàkala, mɛ́ tɛ́ naa sero. ");
INSERT INTO bus_vpl VALUES ("K118_24","012_18_24","1KI","18","24","24","Aↄ̃mↄnnↄ é Baali sísi, mamↄma sↄ̃ mɛ́ Dii sísi. Aↄ̃ gbɛ̃ kɛ̀ mà, ben à sù tɛ́o, àmbe Luda ũ. Ben baade píngi bè: Yã maaamɛ! ");
INSERT INTO bus_vpl VALUES ("K118_25","012_18_25","1KI","18","25","25","Ben Ilia bè tãadee pìnↄnɛ: À zùsware mɛ̀n doo sɛ́ à kɛkɛ káaku, zaakɛ ámbe á pari. À a tãa sísi, mↄde àton tɛ́ naaro. ");
INSERT INTO bus_vpl VALUES ("K118_26","012_18_26","1KI","18","26","26","Ben aↄ̃ zùswaree kɛ̀ wà kpàḿma sì aↄ̃ kɛ̀kɛ, ben aↄ̃ↄe Baali sisii zaa kↄngↄ ai ↄfãntɛ̃ gàa káo mìdangura. Aↄ̃ↄe ↄ̃ wãa, aↄ̃ↄe ligaa sa'okii kɛ̀ wà bòzi, aↄ̃ↄe bee: Baali, nɛ́ yã mawaroo? Baa kↄ̃n beeeo aↄ̃ↄe yãke maro, èe yã maḿmaro. ");
INSERT INTO bus_vpl VALUES ("K118_27","012_18_27","1KI","18","27","27","Kɛ̀ ↄfãntɛ̃ kà mìdangura, ben Ilia e ń lalandi kɛɛ à bè: À wii lɛ́ gbãa à kaara, à dɛ diimɛ gwɛɛ! Ke à laasuu tà gu pãndeamɛ. Ke à gàa bĩikpɛɛ kɛmɛ. Ke à gàa wɛ́tɛamɛ. Ke èe ii oomɛ, ben ée à vuroo? ");
INSERT INTO bus_vpl VALUES ("K118_28","012_18_28","1KI","18","28","28","Ben aↄ̃ↄe wii lɛɛ kↄ̃n kòto gbãaao, aↄ̃ↄe ń zĩnda lilii kↄ̃n fɛ̃ɛdaao kↄ̃n sário lán aↄ̃ↄ kↄ̃ dↄ̃o nà, ai aru e plaa ń mɛ̀a. ");
INSERT INTO bus_vpl VALUES ("K118_29","012_18_29","1KI","18","29","29","Kɛ̀ ↄfãntɛ̃ gò mìa, ben aↄ̃ↄe yã yaa ai sa uusiɛ ogurↄↄ gàa à kào. Baa kↄ̃n beeeo èe yãke síńlaro, èe yã maḿmaro, èe swã kpáńziro. ");
INSERT INTO bus_vpl VALUES ("K118_30","012_18_30","1KI","18","30","30","Ben Ilia bè pariinɛ: À sↄ̃mazi kɛ̀! Kɛ̀ aↄ̃ sↄ̃̀zi ń píngi, ben à Dii gbãgbãkii kɛ̀ gbòro kɛ̀kɛ èe boo. ");
INSERT INTO bus_vpl VALUES ("K118_31","012_18_31","1KI","18","31","31","À gbɛ̀ sɛ̀sɛ mɛ̀n kuri awɛɛplaa Yakubu boriinↄ pari lɛ́n. Yakubun Dii yã ònɛ yã à bè wàgae benɛ sa Isaraili. ");
INSERT INTO bus_vpl VALUES ("K118_32","012_18_32","1KI","18","32","32","Kɛ̀ à Dii gbãgbãkii pì bò, ben à wɛ̀ɛ yↄ̃̀ à lìgazi. Wɛ̀ɛ pì kà à í sí lita gɛ̃ro. ");
INSERT INTO bus_vpl VALUES ("K118_33","012_18_33","1KI","18","33","33","À yàka kà sa'okii pìla, à zù pì zↄ̃̀zↄ̃kↄ̃rɛ à kà yàka pìa à bè: À í tↄ́ lo siigↄ̃, é ká sa'opↄ pìa kↄ̃n yàka pìo. ");
INSERT INTO bus_vpl VALUES ("K118_34","012_18_34","1KI","18","34","34","Kɛ̀ aↄ̃ↄ tↄ̀, ben à bè: À ɛara à tↄ́ dↄ. Kɛ̀ aↄ̃ↄ tↄ̀, ben à bè: À ɛara à tↄ́ à kɛ gɛ̃̀n aagↄ̃. Ben aↄ̃ↄ tↄ̀ ai gɛ̃̀n aagↄ̃. ");
INSERT INTO bus_vpl VALUES ("K118_35","012_18_35","1KI","18","35","35","Í pì bàa lɛ̀ à lìga sa'okii pìzi ai wɛ̀ɛ pì pà. ");
INSERT INTO bus_vpl VALUES ("K118_36","012_18_36","1KI","18","36","36","Sa uusiɛ ogurↄ ben annabi Ilia sↄ̃̀zi à bè: Dii, Ibraĩ kↄ̃n Isaakuo kↄ̃n Isarailio Luda, ǹ tó wà dↄ̃ gbã̀a kɛ̀ ḿbe Isarailinↄ Luda ũ bensↄ̃ n zↄ̀blerin ma ũ, mɛ́ɛ yã kɛ̀ kɛɛ kɛ̀ ḿbe n ma dan yãnzi. ");
INSERT INTO bus_vpl VALUES ("K118_37","012_18_37","1KI","18","37","37","Ǹ yã mama Dii! Ǹ yã mama, lɛ gbɛ̃ kɛ̀nↄ e wà dↄ̃ kɛ̀ Dii, ḿbe ń Luda ũ bensↄ̃ nɛ́ɛ ń nↄ̀sɛ liɛńnɛ lɛ aↄ̃ ɛara wà summa. ");
INSERT INTO bus_vpl VALUES ("K118_38","012_18_38","1KI","18","38","38","Ben Dii tɛ́ sù sa'obↄ pìa kↄ̃n yàkao kↄ̃n gbɛ̀nↄ kↄ̃n bùsuo, aↄ̃ tɛ́ kũ̀, ben í kɛ̀ kú wɛ̀ɛ pìn bàba. ");
INSERT INTO bus_vpl VALUES ("K118_39","012_18_39","1KI","18","39","39","Kɛ̀ gbɛ̃nↄↄ è, ben aↄ̃ dàɛ ń puua wà bè: Diimɛ Luda ũ! Diimɛ Luda ũ! ");
INSERT INTO bus_vpl VALUES ("K118_40","012_18_40","1KI","18","40","40","Ben Ilia dàńnɛ à bè: À Baali tãagbãgbãri pìnↄ kũkũ, aↄ̃ gbɛ̃ke tón pitiaguro. Kɛ̀ wà ń kũkũ, ben Ilia gàańyo Kisↄ̃ guzurɛn à ń dɛdɛ gwe. ");
INSERT INTO bus_vpl VALUES ("K118_41","012_18_41","1KI","18","41","41","Ilia bè Ahabunɛ: Ǹ gá pↄ́ ble ǹ í mi, zaakɛ ma lou kĩi mà dↄ. ");
INSERT INTO bus_vpl VALUES ("K118_42","012_18_42","1KI","18","42","42","Ben Ahabu gàa pↄ́ ble à í mi. Ben Ilia dìdi à gàa Kamɛli mìsↄ̃ntɛ̃a à vɛ̃̀ɛ à mì kà tú. ");
INSERT INTO bus_vpl VALUES ("K118_43","012_18_43","1KI","18","43","43","À bè a zĩkɛrinɛ: Ǹ gá guu gwa ísiaa kpa. Ben à gàa à gwà. Kɛ̀ à sù à bè: Pↄ́kee kú gwero. Ben Ilia bènɛ à ɛara à gá gwa dↄ, ben à gàa lɛ ai gɛ̃̀n swɛɛplaa. ");
INSERT INTO bus_vpl VALUES ("K118_44","012_18_44","1KI","18","44","44","À gɛ̃̀n swɛɛplaadeeo zĩkɛri pì bè: Ma lou sèeda è sɛtɛɛgɛ lán ↄla bà, èe fɛɛɛ ísiaala. Ben Ilia bènɛ: Ǹ gá ǹ o Ahabunɛ à sↄ̃goro dↄ sↄ̃nↄa à gɛ̃n à pita kpiiia ai lou gↄ̃ gá à dãdã. ");
INSERT INTO bus_vpl VALUES ("K118_45","012_18_45","1KI","18","45","45","Lou e sisii busɛbusɛ, zàga'ĩa fɛ̀ɛ, ben lou mà maamaa. Ahabu kú sↄ̃goron, èe taa Yɛzɛrili. ");
INSERT INTO bus_vpl VALUES ("K118_46","012_18_46","1KI","18","46","46","Dii gbãaa mↄ̀ Iliaa, ben à a utadaa kàkakↄ̃a à kũ̀, à bàa lɛ̀ à Ahabu kɛ̃̀ ai à gàa káo Yɛzɛrili. ");
INSERT INTO bus_vpl VALUES ("K119_1","012_19_1","1KI","19","1","1","Ben Ahabu yã kɛ̀ Ilia kɛ̀ tↄ̃kɛ̃̀ Yɛzɛbɛlinɛ píngi, lán à tãadee pìnↄ dɛ̀dɛ nà kↄ̃n fɛ̃ɛdaao ń píngi. ");
INSERT INTO bus_vpl VALUES ("K119_2","012_19_2","1KI","19","2","2","Ben Yɛzɛbɛli lɛ́kpãsã kɛ̀ Ilianɛ à bè: Ai zia mↄndaa'i, tó mɛ́ɛ kɛnnɛ lán ń kɛ̀ tãadeenↄnɛ nàro, tãanↄ yã kɛmɛ pãsĩpãsĩ! ");
INSERT INTO bus_vpl VALUES ("K119_3","012_19_3","1KI","19","3","3","Ben vĩa Ilia kũ̀, ben à fɛ̀ɛ à bàa sì à a zĩnda mìbↄkii wɛ̀tɛ. Kɛ̀ à kà Bɛsɛba, Yudanↄ bùsun, gwen à a zĩkɛri tòn, ");
INSERT INTO bus_vpl VALUES ("K119_4","012_19_4","1KI","19","4","4","ben à táa ò gbáan gurↄ do. À gàa à vɛ̃̀ɛ sɛ̃ lí gbáru, ben à adua kɛ̀ à e à ga à bè: Dii, yã kɛ̀kii mↄ̀ma lɛ. Ǹ ma wɛ̃̀ndi sɛ́ gↄ̃ↄ, zaakɛ má dɛ ma dezinↄlaro. ");
INSERT INTO bus_vpl VALUES ("K119_5","012_19_5","1KI","19","5","5","Ben à dàɛ èe ii oo sɛ̃ lí pì gbáru. Èe gì kɛro ben malaika mↄ̀ à ↄ kɛ̀a à bè: Ǹ fɛɛ ǹ pↄ́ ble. ");
INSERT INTO bus_vpl VALUES ("K119_6","012_19_6","1KI","19","6","6","Kɛ̀ Ilia guu gwà, ben à kàra aasana è kↄ̃n í tùuo kaɛna a mìzi. Ben à pↄ́ blè à í mì à ɛ̀ara à dàɛ. ");
INSERT INTO bus_vpl VALUES ("K119_7","012_19_7","1KI","19","7","7","Dii Malaika ɛ̀ara à mↄ̀ à gɛ̃̀n plaadeeo, à ↄ kɛ̀a à bè: Ǹ fɛɛ ǹ pↄ́ ble, zaakɛ tá gbã̀an nɛ́ɛ mↄↄ o. ");
INSERT INTO bus_vpl VALUES ("K119_8","012_19_8","1KI","19","8","8","Ben à fɛ̀ɛ à pↄ́ blè à í mì. Pↄ́blee pì tò à gbãaa è, ben à táa ò gurↄ baplaa fãantɛ̃ kↄ̃n gwãavĩo ai à gàa à kà Luda kpiii kɛ̀ wè be Orɛbua. ");
INSERT INTO bus_vpl VALUES ("K119_9","012_19_9","1KI","19","9","9","Ben à gɛ̃̀ gbɛ̀wɛɛn à ì gwe, ben Dii yã sùa à bè: Ilia, bↄ́n nɛ́ɛ kɛɛ kɛ̀? ");
INSERT INTO bus_vpl VALUES ("K119_10","012_19_10","1KI","19","10","10","À wèàla à bè: Dii Luda Zĩ̀kpɛde, ma làakari fɛ̀ɛ maamaa, zaakɛ Isarailinↄ pã kpà n bà kuunańyo yãzi, ben aↄ̃ n gbãgbãkiinↄ gbòro aↄ̃ n annabinↄ dɛ̀dɛ kↄ̃n fɛ̃ɛdaao. Mámbe ma gↄ̃ mado, ben aↄ̃ↄe ma wɛɛ se. ");
INSERT INTO bus_vpl VALUES ("K119_11","012_19_11","1KI","19","11","11","Ben Dii bè: Ǹ bↄ ǹ gá zɛ ma aɛ kpiii musu, mɛ́ gɛ̃tɛ n aɛ. Zàga'ĩa gbãaa fɛ̀ɛ, èe kpiii pìnↄ paraa èe gbɛ̀nↄ wiwii Dii aɛ, mↄde Dii kú ĩa pì guuro. Ĩa pì gbɛra tↄↄtɛ nìgãnigã, mↄde Dii kú tↄↄtɛ nigãnigãna pì guuro. ");
INSERT INTO bus_vpl VALUES ("K119_12","012_19_12","1KI","19","12","12","Tↄↄtɛ nigãna pì gbɛra ben tɛ́ bↄ̀, mↄde Dii kú tɛ́ pì guuro. Tɛ́ pì gbɛra ben kòto busɛ bↄ̀ tɛɛɛ. ");
INSERT INTO bus_vpl VALUES ("K119_13","012_19_13","1KI","19","13","13","Kɛ̀ Ilia kòto pì mà, à a utadaa kù a wɛ́ɛla. Ben à bↄ̀ à gàa à zɛ̀ gbɛ̀wɛɛ pì lɛ́a, à mà wà bèare: Ilia, bↄ́n nɛ́ɛ kɛɛ kɛ̀? ");
INSERT INTO bus_vpl VALUES ("K119_14","012_19_14","1KI","19","14","14","À wèàla à bè: Dii Luda Zĩ̀kpɛde, ma làakari fɛ̀ɛ maamaa, zaakɛ Isarailinↄ pã kpà n bà kuunańyo yãzi, ben aↄ̃ n gbãgbãkiinↄ gbòro aↄ̃ n annabinↄ dɛ̀dɛ kↄ̃n fɛ̃ɛdaao. Mámbe ma gↄ̃ mado, ben aↄ̃ↄe ma wɛɛ se. ");
INSERT INTO bus_vpl VALUES ("K119_15","012_19_15","1KI","19","15","15","Ben Dii bènɛ: Ǹ ɛara ǹ tá Damasiku gbáan. Tó n ka gwe, ǹ Azaili ká Sirianↄ kína ũ, ");
INSERT INTO bus_vpl VALUES ("K119_16","012_19_16","1KI","19","16","16","nɛ́ Nimisi dio Yehu ká Isarailinↄ kína ũ, nɛ́ Abɛli Mɛↄla gbɛ̃ Safata nɛ́ Ɛlisa kɛ n gɛ̃ɛ ũ annabi ũ. ");
INSERT INTO bus_vpl VALUES ("K119_17","012_19_17","1KI","19","17","17","Gbɛ̃ kɛ̀ bↄ̀ Azaili fɛ̃ɛdaa lɛ́zĩ, Yehu bé eé à dɛ. Tó à bↄ̀ Yehu fɛ̃ɛdaa lɛ́zĩ sↄ̃, Ɛlisa bé eé à dɛ. ");
INSERT INTO bus_vpl VALUES ("K119_18","012_19_18","1KI","19","18","18","Baa kↄ̃n beeeo má Isarailinↄ kũna gↄ̃ↄn bↄrↄ swɛɛplaa, kɛ̀ aↄ̃ gbɛ̃kee e kúɛ Baalinɛ à lɛ́ pɛ̀aro. ");
INSERT INTO bus_vpl VALUES ("K119_19","012_19_19","1KI","19","19","19","Ben Ilia fɛ̀ɛ à bↄ̀ gwe à gàa à Safata nɛ́ Ɛlisa lè, èe bú wii kↄ̃n zùnↄ swaaro kuri awɛɛplaa. Àmbe à tɛ́ zù swaaro kpɛɛdeezi. Ben Ilia sↄ̃̀zi à a gyaba gò à dààla. ");
INSERT INTO bus_vpl VALUES ("K119_20","012_19_20","1KI","19","20","20","Ben Ɛlisa a zùnↄ tò gwe à bàa lɛ̀ à bↄ̀ à tɛ́ Ilia kpɛɛ, ben à bènɛ: Ǹ tó mà gá lɛ́ za ma de kↄ̃n ma daoa gĩa, mɛ́ gbasa mà mↄ́ mà tɛ́nzi sa. Ben Ilia bènɛ: Ǹ gá ǹ ɛara ǹ su. Asa ń dↄ̃ yã kɛ̀ má kɛ̀nnɛ. ");
INSERT INTO bus_vpl VALUES ("K119_21","012_19_21","1KI","19","21","21","Ben Ɛlisa ɛ̀ara à gàa à a zùnↄ kòto kpà à tɛ́ lè kↄ̃n a zù swaaro gbóngoo, ben à zù pìnↄ nↄ̀bↄ fùfu kɛ̀ à kpà gbɛ̃nↄa aↄ̃ↄ sò. Ben à bↄ̀ à tɛ̀ Iliazi, à gↄ̃̀ à plaadee ũ. ");
INSERT INTO bus_vpl VALUES ("K120_1","012_20_1","1KI","20","1","1","Siria kí Bɛnadada a zĩ̀kpɛɛnↄ kàkↄ̃a ń píngi. Kí gↄ̃ↄn baaakuri awɛɛplaaanↄↄ kúo kↄ̃n ń sↄ̃nↄ kↄ̃n ń sↄ̃goronↄ. Ben aↄ̃ gàa wà lìga Samariazi aↄ̃ lɛ̀ɛa. ");
INSERT INTO bus_vpl VALUES ("K120_2","012_20_2","1KI","20","2","2","Ben à gbɛ̃nↄ zĩ̀ Ahabua wɛ́tɛ guu à bè: Ma Bɛnadada ma bè, ");
INSERT INTO bus_vpl VALUES ("K120_3","012_20_3","1KI","20","3","3","n kondogi kↄ̃n n vurao gↄ̃̀ ma pↄ́ ũ. N nↄ maaanↄ kↄ̃n n nɛ́ maaanↄ gↄ̃̀ ma pↄ́ ũ dↄ. ");
INSERT INTO bus_vpl VALUES ("K120_4","012_20_4","1KI","20","4","4","Ben Isarailinↄ kína bè: Ma dii kí, mapi kↄ̃n pↄ́ kɛ̀ má vĩinↄ gↄ̃̀ n pↄ́ ũ píngi lán ń ò nà. ");
INSERT INTO bus_vpl VALUES ("K120_5","012_20_5","1KI","20","5","5","Ben Bɛnadada ɛ̀ara à gbɛ̃nↄ zĩ̀a dↄ à bè: Ma Bɛnadada ma gbɛ̃nↄ zĩ̀ ma n kondogi kↄ̃n n vurao kↄ̃n n nↄↄnↄ kↄ̃n n nɛ́nↄ làmma. ");
INSERT INTO bus_vpl VALUES ("K120_6","012_20_6","1KI","20","6","6","Zia mↄndaa'i mɛ́ ma gbɛ̃nↄ zĩmma aↄ̃ n bɛɛ kpokɛ kↄ̃n n gbɛ̃nↄ bɛɛnↄ, aↄ̃é a pↄ́ bɛ̀ɛdeenↄ sɛ́ɛ wà suomɛ píngi. ");
INSERT INTO bus_vpl VALUES ("K120_