﻿USE sofia;
DROP TABLE IF EXISTS sofia.buk_vpl;
CREATE TABLE buk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES buk_vpl WRITE;
INSERT INTO buk_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yisu †Kilisi ndê apai si ŋadênaŋ dindec. Iŋ sa akêŋ Dawid ndê, ma Dawid sa akêŋ Abraham ndê. ");
INSERT INTO buk_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ndê atu iŋ Aisak. Ma Aisak ndê atu iŋ Jakob. Jakob ndê atui †Juda ti iŋ ndê asidôwai. ");
INSERT INTO buk_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda gêm Tama ma iŋlu sêkwê balê lu asê, naŋ Peres lu Sera. Peres ndê atu iŋ Hesron, ma Hesron ndê atu iŋ Ram. ");
INSERT INTO buk_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram ndê atu iŋ Aminadab. Aminadab ndê atu iŋ Nason, ma Nason ndê atu iŋ Salmon. ");
INSERT INTO buk_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon gêm Rahab, ma iŋlu sêkwê Boas asê. Boas gêm Rut, ma iŋlu sêkwê Obed asê. Ma Obed iŋ Jessi damba. ");
INSERT INTO buk_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ma Jessi ndê atu iŋ Kiŋ Dawid. Dawid gêm Betsiba, naŋ muŋŋga ti Uria ndê awhê, ma Dawid lu Betsiba sêkwê Solomon asê. ");
INSERT INTO buk_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ndê atu iŋ Rehoboam. Ma Rehoboam ndê atu iŋ Abaisa. Abaisa ndê atu iŋ Asa. ");
INSERT INTO buk_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ndê atu Yehosapat, ma Yehosapat ndê atu iŋ Yehoram. Yehoram ndê atu iŋ Usiah. ");
INSERT INTO buk_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiah ndê atu Yotam, ma Yotam ndê atu Ahas. Ahas ndê atu iŋ Hesekaya. ");
INSERT INTO buk_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaya ndê atu iŋ Manase, ma Manase ndê atu Amon. Amon ndê atu iŋ Josaya. ");
INSERT INTO buk_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ma Josaya ndê atui, naŋ Yekonaya ti ndê asii. Têŋ Josaya ndê têm lau Babilon-ŋga sêŋgaho lau †Israelŋga su, ma sêkôc ŋac sa si sêndöc gameŋ apa Babilon-ŋga gitôm lau gapocwalô-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Têŋ ndoc lau Israel-ŋga sêmbo gameŋ Babilon-ŋga, naŋ Yekonaya kwê Sealtial asê. Tiŋambu lau Israelŋga sêmbu akêŋ gameŋ Babilon-ŋga sêmeŋ, ma Sealtial kwê Serubabel asê. ");
INSERT INTO buk_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel ndê atu iŋ Abiud, ma Abiud ndê atu Eliakim. Eliakim ndê atu iŋ Aso. ");
INSERT INTO buk_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ma Aso ndê atu Sadok. Sadok ndê atu iŋ Akim, ma Akim ndê atu iŋ Eliud. ");
INSERT INTO buk_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ndê atu iŋ Eleasa, ma Eleasa ndê atu Matan. Matan ndê atu iŋ Jakob, ");
INSERT INTO buk_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ma Jakob ndê atu iŋ Josep. Josep gêm Maria naŋ kôc Yisu, ŋgac naŋ sêsam bu Kilisi. ");
INSERT INTO buk_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Bocdinaŋ, têŋ Abraham ndê têm ma meŋ têŋ Kiŋ Dawid ndê têm, Yisu ndê apaŋgaci 14 sêmbo. Ma têŋ Dawid ndê têm ma meŋ têŋ ndoc lau Israel-ŋga sêndöc Babilon, naŋ iŋ ndê apai 14 tiyham sêmbo. Ma têŋ ndoc lau Israel-ŋga sêndöc Babilon, e meŋ têŋ ndoc Maria kôc Kilisi, naŋ apai 14 tiyham sêmbo. ");
INSERT INTO buk_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yisu Kilisi dinda kôc iŋ ŋamiŋ dau dec. Ŋac sêhê iŋ dinda Maria têŋ Josep su, magoc iŋlu sêmbo sêwhiŋ dau dom, ma sêlic bu Maria daê. Iŋ daê akêŋ Ŋalau Dabuŋ ndê. ");
INSERT INTO buk_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josep, naŋ sêmasaŋ yom bu nem Maria, naŋ ŋgac gitêŋ, ma bu kôm iŋ maya sa dom, dec gauc gêm bu hu iŋ siŋ gelec. ");
INSERT INTO buk_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Iŋ kôc gauc dinaŋ su, goc Pômdau ndê aŋela daŋ hoc dau asê têŋ iŋ ŋa mbê, ma sôm, “Josep, Dawid ndê apaŋgac, töc daôm dom bu kôc Maria sa ti am nem awhê, bu Ŋalau Dabuŋ dau kêŋ balêkoc naŋ mbo iŋ ŋatac ŋalôm. ");
INSERT INTO buk_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Maria oc kôc balê daŋ, ma am oc sam iŋ ndê ŋaê bu †Yisu, ŋahu bu iŋ oc nem iŋ ndê lau si yêc ŋac si sac ŋagêyô.” ");
INSERT INTO buk_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Gêŋ hoŋ dinaŋ hôc asê ma bocdinaŋ Pômdau ndê yom naŋ propet Aisaya hoc asê muŋ su, naŋ ŋandô sa. Iŋ hoc yom dau asê bocdec bu: ");
INSERT INTO buk_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Alic su naŋ. Awhê akiŋ daŋ oc daê e kôc balêkoc ŋgac daŋ, ma ŋac oc sêsam iŋ ndê ŋaê bu Imanuel. (Ŋaê ‘Imanuel’ dau ŋahu bu ‘Anötö mbo whiŋ yac.’ ) ");
INSERT INTO buk_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Têŋ ndoc Josep tapo sa, naŋ iŋ kôm gitôm Pômdau ndê aŋela gic atu iŋ, ma kôc Maria sa meŋ mbo iŋ ndê andu ti iŋ ndê awhê. ");
INSERT INTO buk_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Iŋlu sêmbo sêwhiŋ dandi, magoc Josep gic ahê Maria mbo e gitôm iŋ kôc balêkoc dau su. Ma iŋ sam iŋ ndê ŋaê bu Yisu. ");
INSERT INTO buk_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yisu dinda kôc iŋ yêc malac Betlehem yêc gameŋ Judia-ŋga, têŋ têm Kiŋ †Herod gêm gôliŋ mbo. Tiŋambu lau apa ŋatô sêhôc asê Jerusalem. Ŋac lau tigauc tu sêŋyalê tata-ŋga, ma sêmeŋ akêŋ gameŋ ac pi-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Sêhôc asê ma sêndac, “Balêkoc naŋ bu ti lau Israel si kiŋ, naŋ dinda kôc iŋ yêc nde? Yac alic tata wakuc daŋ pô yac mba gameŋ dec kêŋ puc yac bu iŋ hôc asê su. Ma yac ameŋ bu atoc iŋ sa ti apôŋ haŋduc têŋ iŋ.” ");
INSERT INTO buk_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ŋac si yom dinaŋ kôm Kiŋ Herod sö ma gauc gêm yom daêsam. Ma lau Jerusalem-ŋga hoŋ boc-dinaŋ. ");
INSERT INTO buk_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Goc Herod kêgalêm lau Israel si †dabuŋsiga atu-tu ti lau naŋ sêndôhôŋ yomsu, naŋ sa sêpitigeŋ, ma ndac ŋac, “Mac nem †Mesaya dinda oc kôc iŋ yêc malac bocke?” ");
INSERT INTO buk_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ma sêô iŋ ndê yom ma sêsôm, “Iŋ dinda oc kôc iŋ yêc malac Betlehem yêc gameŋ Judia-ŋga. Propet akwa daŋ to yom pi iŋ muŋ su bocdec bu: ");
INSERT INTO buk_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","O malac Betlehem yêc gameŋ naŋ †Juda ndê toŋ sêwêkaiŋ. Malac atu-tu hoŋ naŋ sêyêc Juda ndê gameŋ, naŋ ŋadaŋ hôc gêlêc am su dom, ŋahu bu gôliŋwaga naŋ oc sa yêc am, naŋ oc ti ŋgac atu tu yob aneŋ lau Israel-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herod ŋgô yom hoŋ dinaŋ su, ma kêŋ ŋac sêsa si. Goc iŋ gic lau tigauc dinaŋ sa tiyham gelec, ma kip yom sa yêc ŋac, bu bêc bocke tata dau meŋ hôc asê ma ŋac sêlic. Ŋac sic miŋ yom hoŋ têŋ iŋ su, ");
INSERT INTO buk_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ma iŋ kêkiŋ ŋac bu sêtêŋ malac Betlehem sêndi, ma sôm têŋ ŋac, “Andi aŋsalê balêkoc dau, ma têŋ ndoc mac atap iŋ sa, naŋ goc ambu ameŋ akêŋ ŋawaê têŋ aö bu aö dauŋ waloc, ma watoc iŋ sa.” ");
INSERT INTO buk_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Lau dinaŋ sêŋgô Herod ndê yom su, ma sêsa si. Ma tata naŋ sêlic su yêc ŋac si gameŋ ac pi-ŋga, naŋ wê ŋac gi e kalhac andu naŋ balêkoc yêc, naŋ ŋahô solop. ");
INSERT INTO buk_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ŋac sêlic tata dau dec kôm ŋac atac ŋayham atu. ");
INSERT INTO buk_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Sêsôc andu dau si, ma sêlic balêkoc lu dinda Maria. Ma sêpôŋ haduc têŋ balêkoc dau ma sêtoc iŋ sa. Goc ŋac sêkac si talhi sa, ma sêkêŋ si awalauŋ naŋ ŋaôli atu-tu têŋ iŋ kaiŋ gitôm gol, ma a ŋakwi ŋamalu ti gêŋ ŋamalu ŋayham. ");
INSERT INTO buk_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Têŋ ndoc dinaŋ Anötö kêŋ puc ŋac ŋa mbê bu sêmbu sêtêŋ Herod sêndi dom. Bocdinaŋ sêlhö sêsa seŋ daŋ dau-ŋga daŋ, ma sêmbu sêtêŋ ŋac si gameŋ si. ");
INSERT INTO buk_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Têŋ têm lau tigauc dinaŋ sêhu ŋac siŋ su, Pômdau ndê aŋela daŋ suŋ mbê têŋ Josep ma sôm, “Herod kêsalê balê dau bu ndic iŋ ndu. Bocdinaŋ tisa, ma kôc balê lu dinda sa ma asip Isip andi. Ambo dinaŋ e tôm aö wakêŋ puc mac.” ");
INSERT INTO buk_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josep ŋgô aŋela ndê yom su, goc tisa têŋ ôbwêc dinaŋ ma kôc balê lu dinda sa, ma sêsip Isip si. ");
INSERT INTO buk_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ma ŋac sêmbo gameŋ dinaŋ, e Herod mbac ndu su. Ma ŋalêŋ dau dinaŋ dec Pômdau ndê yom naŋ propet daŋ hoc asê muŋ su, naŋ ŋandô sa. Yom dau bocdec bu: Aö kagalêm aneŋ atuŋgac sa akêŋ gameŋ Isip-ŋga meŋ. ");
INSERT INTO buk_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Têŋ ndoc Josep kôc Maria lu Yisu sa sêsip Isip si, naŋ Herod hôŋ lau tigauc bu sêkêŋ ŋawaê têŋ iŋ pi balê dau. Magoc ŋac sêmeŋ dom, dec iŋ kêyalê bu ŋac sêŋsau iŋ, ma iŋ tac ŋandê atu. Goc kêkiŋ iŋ ndê lau siŋ-ŋga sêtêŋ Betlehem si, ma sic balêkoc ŋgac dedec hoŋ ndu yêc malac Betlehem, ma yêc gameŋ ŋamakê-ŋga whiŋ. Iŋ tap ŋawaê sa su yêc lau tigauc, pi bêc naŋ tata hôc asê ŋac-ŋga, ma bocdinaŋ ŋac sic balêkoc ŋgac dedec e gi tap ŋac naŋ si yala tilu, naŋ hoŋ ndu. ");
INSERT INTO buk_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ma tu dinaŋ-ŋga yom naŋ propet Jeremaya to, naŋ ŋandô sa. Iŋ to yom bocdec bu: ");
INSERT INTO buk_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Lau sêtaŋ daŋgibo atu yêc malac Rama. Rakel ndê lau wakuc sêtaŋ ŋac si balêkoc naŋ siŋga su. Ma lau daŋ sêtôm bu sênem malô ŋac dom. ");
INSERT INTO buk_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tiŋambu Herod mbac ndu, ma yêc Isip, Pômdau ndê aŋela hoc dau asê têŋ Josep ŋa mbê, ");
INSERT INTO buk_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ma sôm têŋ iŋ, “Tisa ma kôc balê lu dinda sa, ma ambu atêŋ gameŋ Israel-ŋga andi. Lau naŋ sêkôm bu sêndic balê dau ndu, naŋ hoŋ sêmbac ndu su.” ");
INSERT INTO buk_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Goc Josep tisa, kôc balê lu dinda sa, ma ŋac sêmbu sêtêŋ Israel si. ");
INSERT INTO buk_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tigeŋ Josep ŋgô bu Akelaus gêm gôliŋ gameŋ Judia-ŋga ô damba Herod su, dec töc dau bu mbu têŋ gameŋ Judia-ŋga ndi. Ma Pômdau kêŋ puc iŋ ŋa mbê bu têŋ gameŋ Galili-ŋga ndi. ");
INSERT INTO buk_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Goc ŋac sêtêŋ Galili si, ma sêndöc malac daŋ ŋaê Nasaret. Ma bocdinaŋ yom naŋ propet akwa-kwa sêto muŋ su, naŋ ŋandô sa pi Yisu. Ŋac sêto yom yêc bocdec bu, “Lau oc sêsam iŋ bu ŋgac Nasaret-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tiŋambu Jon, Ŋgac Kêku Lau-ŋga hôc asê gameŋ Judia-ŋga, ma gêm mêtê mbo gameŋ sawa. ");
INSERT INTO buk_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Iŋ sôm têŋ lau, “Anötö ndê gôliŋ meŋ kêpiŋ su. Bocdinaŋ anem daôm kwi ma ahu mêtê sac siŋ.” ");
INSERT INTO buk_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Gêŋ dau kêkuc yom naŋ propet Aisaya hoc asê muŋ su bocdec bu: Ŋamalac daŋ ta yom mbo gameŋ sawa, bocdec bu, ‘Amasaŋ Pômdau ndê seŋ tisolop. Amasaŋ nem ŋalôm bu akôc iŋ sa.’ ");
INSERT INTO buk_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon sôc ŋakwê naŋ sêmasaŋ ŋa kamel ŋamliclhu, ma kic piŋkap yêc iŋ ŋampêbalê. Ma iŋ gêŋ gêŋ bambaliŋ gitôm wakô ma lêp. ");
INSERT INTO buk_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Lau daêsam sêsa sêtêŋ Jon si. Ŋac lau akêŋ malac atu Jerusalem ma malac hoŋ yêc gameŋ Judia-ŋga, ma lau naŋ sêndöc Bu Jordan ŋamakê. ");
INSERT INTO buk_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ŋac sêhoc si sac asê têŋ Jon, ma iŋ kêku ŋac yêc Bu Jordan. ");
INSERT INTO buk_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ma lau †Palêsai ti lau †Sadiusi daêsam sêsa sêtêŋ gameŋ naŋ Jon kêku lau mbo, naŋ si. Têŋ ndoc Jon gêlic ŋac iŋ sôm ŋac bocdec bu, “Mac mboc ŋatui mac! Tu sake-ŋga mac alhö ameŋ? Mac akôc gauc pi Anötö ndê tac ŋandê naŋ lau propet sêkêŋ puc yac bu oc meŋ sa, dec gauc gêm bu ameŋ ma aliŋ saŋgu ŋambwa, a? ");
INSERT INTO buk_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Aŋgô! Akôm mêtê ŋayham naŋ tôc asê bu mac am daôm kwi yomandô. ");
INSERT INTO buk_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma asôm têŋ daôm dom bu, ‘Abraham apai yac, ma tu dinaŋ-ŋga Anötö oc kôc yac sa.’ Aö wasôm têŋ mac bu Anötö gitôm bu nem hoc hoŋ dindec kwi sêti Abraham ndê atui sêô mac. ");
INSERT INTO buk_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","A hoŋ naŋ sem ŋandô ŋayham dom, naŋ kwahic dec Anötö kêŋ ki ŋamata têŋ ŋawakac, ma iŋ oc lêŋ su ma tuc pi ya ndi. ");
INSERT INTO buk_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Aö wasôm têŋ mac hoŋ bu ŋgac daŋ oc meŋ êŋkuc aö, naŋ ndê ŋaclai hôc gêlêc aneŋ su. Aö ŋgac ŋambwa, gitôm dom bu wati iŋ ndê ŋgac akiŋ tu wakeŋ iŋ ndê atapa-ŋga. Aö dec kaku mac ŋa bu ŋambwa, naŋ tôc asê bu mac am daôm kwi su. Tigeŋ iŋ ŋgac dau oc êŋku mac ŋa Ŋalau Dabuŋ ti ya. ");
INSERT INTO buk_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Iŋ meŋ bu êŋsahê lau, gitôm ŋgac naŋ whê wit ŋandô ti ŋapa kôc, goc gic ŋandô sa sôc andu gêŋ ŋandô-ŋga gi, ma tuc ŋapa sip ya naŋ sa ŋapaŋ, naŋ gi.” ");
INSERT INTO buk_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Têŋ dinaŋ Yisu meŋ akêŋ gameŋ Galili-ŋga ma hôc asê Jon yêc Bu Jordan. Iŋ tac whiŋ bu Jon êŋku iŋ. ");
INSERT INTO buk_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Magoc Jon gic yao dau têŋ iŋ ma sôm, “Am bu êmku aö, oc ŋayham. Bocke dec am sôm bu aö waŋku am?” ");
INSERT INTO buk_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tigeŋ Yisu ô Jon ndê yom ma sôm, “Am tec dom. Kwahic dec am êmku aö, bu taŋkuc lêŋ solop naŋ Anötö kêmasaŋ gwanaŋ su.” Yisu sôm su ma Jon gôlôc bu êŋku iŋ. ");
INSERT INTO buk_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yisu gêliŋ saŋgu su ma pi akêŋ bu meŋ. Ma undambê kac sa, ma iŋ gêlic Anötö ndê Ŋalau sip meŋ gitôm balusi ma sac iŋ ŋahô. ");
INSERT INTO buk_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma awha daŋ sa akêŋ undambê, naŋ sôm bu, “Aö Atuŋgac atac whiŋ-ŋga dau dindec. Aö gatisambuc iŋ ŋandô.” ");
INSERT INTO buk_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tiŋambu Ŋalau Dabuŋ wê Yisu sa gameŋ sawa gi, bu †Sadaŋ êntôm iŋ. ");
INSERT INTO buk_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yisu gêŋ gêŋ daŋ dom tôm acsalô 40 ma ôbwêc 40, ma tiŋambu gêŋ yô iŋ ŋandô. ");
INSERT INTO buk_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ma têŋ dinaŋ Sadaŋ hôc asê iŋ ma sôm têŋ iŋ, “Am Anötö ndê Atu, a? Bocdinaŋ sôm têŋ hoc dindec bu sênem dau kwi ti gêŋ daneŋ-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Magoc Yisu ô yom ma sôm, “Mba! Sêto Anötö ndê yom yêc bocdec bu, ‘Gêŋ daneŋ-ŋga ŋambwa kêŋ lau sêndöc tali dom. Ŋac daŋga wambu yom hoŋ naŋ Anötö sôm, dec ŋac oc sêndöc tali.’” ");
INSERT INTO buk_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Goc Sadaŋ kôc iŋ sa pi malac dabuŋ Jerusalem gi, ma kêŋ iŋ kalhac †lôm dabuŋ ŋapoc lôlôc. ");
INSERT INTO buk_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ma sôm têŋ iŋ, “Am Anötö ndê Atu, a? Bocdinaŋ pwê sip ndi. Am oc tisac dom, bu sêto yom yêc bocdec bu, ‘Pômdau oc êŋkiŋ ndê aŋela bu sêyob am, ma sêpê am sa lôlôc bu am tiŋ gahim pi hoc daŋ dom.’ ” ");
INSERT INTO buk_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Magoc Yisu sôm têŋ iŋ, “Mba! Sêto yom daŋ tiyham yêc bocdec bu, ‘Êmsahê Pômdau am nem Anötö dom.’” ");
INSERT INTO buk_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Goc Sadaŋ kôc iŋ sa, ma lu sêpi lôc baliŋ daŋ si. Ma gameŋ hoŋ naŋ kiŋ nom-ŋga sem gôliŋ, ma kiŋ dau si awa ti gêŋ ŋayham-ŋayham hoŋ, naŋ Sadaŋ tôc têŋ Yisu. ");
INSERT INTO buk_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ma sôm, “Am bu pôŋ hamduc têŋ aö ma nem akiŋ aö, goc wakêŋ gêŋ hoŋ dec sip am amam.” ");
INSERT INTO buk_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Magoc Yisu sôm têŋ iŋ, “Mba, Sadaŋ! Am kôc daôm sa ndi! Sêto yom yêc bocdec bu, ‘Pôŋ hamduc têŋ Pômdau am nem Anötö, ma nem akiŋ iŋ tawasê.’” ");
INSERT INTO buk_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Têŋ dinaŋ Sadaŋ hu iŋ siŋ, ma aŋela sêmeŋ ma sem akiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tiŋambu †Herod kêkiŋ ndê lau siŋ-ŋga si ma sêkôc Jon dôŋ, ma sêkêŋ iŋ ndöc gapocwalô. Ma têŋ ndoc Yisu ŋgô ŋawaê, goc iŋ mbu têŋ gameŋ Galili-ŋga gi. ");
INSERT INTO buk_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Iŋ gi ndöc malac Nasaret dom, magoc iŋ gi ndöc Kapenaom, malac naŋ yêc kêpiŋ Bugictoŋ Galili-ŋga. Muŋ-ŋga andô †Jakob ndê atu lu, Sebulun lu Naptali sêwêkaiŋ nom yêc gameŋ dinaŋ. ");
INSERT INTO buk_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ŋalêŋ dinaŋ yom naŋ propet Aisaya to muŋ su, naŋ ŋandô sa. Yom dau bocdec bu: ");
INSERT INTO buk_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","Ŋawê atu daŋ meŋ pô lau naŋ sêndöc Sebulun lu Naptali si gameŋ naŋ yêc kêpiŋ bugictoŋ, ma yêc Bu Jordan ŋamakê. Gameŋ Galili-ŋga dinaŋ sêsam bu lau apa si gameŋ, ma lau naŋ sêndöc dinaŋ, naŋ sêmbo tôm lau naŋ ŋasec atu kôm ŋac ahuc, ma tôm lau naŋ sêmpiŋ bu sêmbac ndu. Magoc kwahic dec sêlic ŋawê atu su. ");
INSERT INTO buk_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Têŋ ndoc dinaŋ Yisu gic hu ndê gweleŋ nem mêtê lau-ŋga, ma iŋ hoc yom asê têŋ lau bocdec bu, “Anötö ndê gôliŋ meŋ kêpiŋ su. Bocdinaŋ anem daôm kwi, ma ahu mêtê sac siŋ.” ");
INSERT INTO buk_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Têŋ bêc daŋ Yisu kêsêlêŋ mbo Bugictoŋ Galili-ŋga ŋamakê. Ma iŋ gêlic Saimon naŋ ndê ŋaê daŋ Pita, lu asi Andru. Iŋlu sêkêŋ wasaŋ sêmbo, bu iŋlu ŋgac sêkôc i-ŋga lu. ");
INSERT INTO buk_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Goc Yisu sôm têŋ iŋlu, “Amlu ameŋ aŋkuc aö, ma aö wakêŋ amlu ahê ŋamalac sêmeŋ sêŋkuc aö, tôm naŋ kwahic dec amlu ahê i.” ");
INSERT INTO buk_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ma ŋagahô iŋlu sêtec si wasaŋ yêc, ma sêŋkuc iŋ. ");
INSERT INTO buk_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sêŋsêlêŋ si, ma Yisu gêlic Sebedi ndê atu lu, naŋ Jems lu Jon. Sêndöc waŋ sêwhiŋ damba Sebedi, ma sêpô si wasaŋ kic sêmbo. Yisu mbwêc iŋlu bu sêmeŋ sêŋkuc iŋ, ");
INSERT INTO buk_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ma ŋagahô iŋlu sêhu damba ti waŋ siŋ, ma sêŋkuc Yisu. ");
INSERT INTO buk_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Dinaŋ su, goc Yisu kêsêlêŋ golom-golom malac yêc gameŋ Galili-ŋga. Iŋ kêdôhôŋ lau mbo †lôm wê-ŋga, ma gêm mêtê ŋawaê ŋayham pi Anötö ndê gôliŋ. Ma iŋ kôm lau ti gêmbac tidau-tidau hoŋ ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ŋawaê pi gêŋ dau gêm gameŋ Siria-ŋga hoŋ ahuc, ma tu dinaŋ-ŋga lau sêkôc ŋac si lau gêmbac hoŋ sêtêŋ Yisu si, ma iŋ kôm ŋac ŋayham sa. Lau naŋ sêhôc ŋandê atu, lau ti ŋalau sac, lau bôliŋ, ma lau deŋdeŋ ti mboloctê, lau ti ŋawapac hoŋ dinaŋ iŋ gêm ŋac sa. ");
INSERT INTO buk_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ma lau daêsam sêsa si ma sêŋkuc iŋ. Ŋatô sêmeŋ akêŋ gameŋ Galili-ŋga, ma ŋatô akêŋ gameŋ Dekapolis-ŋga. Ma ŋatô sêmeŋ akêŋ malac Jerusalem ma malac hoŋ yêc gameŋ Judia-ŋga, ma ŋatô sêmeŋ akêŋ Bu Jordan ŋadaŋga. ");
INSERT INTO buk_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Têŋ bêc daŋ Yisu gêlic bu lau daêsam sêŋkuc iŋ, goc pi lôc daŋ gi. Iŋ ndöc sic, ma iŋ ndê †sêŋomi sêtigasuc iŋ. ");
INSERT INTO buk_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ma iŋ gic hu kêdôhôŋ ŋac ma sôm, ");
INSERT INTO buk_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Anötö ndê mwasiŋ gic waê lau naŋ sêŋgwiniŋ dau yêc iŋ aŋgô-ŋga. Iŋ gêlic ŋayham bu kôc ŋac sa sêmbo iŋ ndê gôliŋ ŋapu. ");
INSERT INTO buk_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Anötö ndê mwasiŋ gic waê lau naŋ sêndöc ti ŋalôm ŋawapac. Iŋ oc kôm ŋac si ŋalôm timalô. ");
INSERT INTO buk_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Anötö ndê mwasiŋ gic waê lau ti lêŋ malô ma yom malô. Bu ŋac oc sêwêkaiŋ gameŋ nom-ŋga sambob. ");
INSERT INTO buk_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Anötö ndê mwasiŋ gic waê lau naŋ atac whiŋ ndu andô bu sêsa lêŋ gitêŋ eŋ. Iŋ oc nem ŋac sa sêti lau gitêŋ ŋandô. ");
INSERT INTO buk_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Anötö ndê mwasiŋ gic waê lau naŋ tawalô lau. Iŋ oc tawalô ŋac. ");
INSERT INTO buk_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Anötö ndê mwasiŋ gic waê lau ti ŋalôm ŋawasi. Ŋac oc sêlic Anötö. ");
INSERT INTO buk_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Anötö ndê mwasiŋ gic waê lau naŋ sêŋsalê lêŋ tu sêmbo ti yom malô-ŋga. Iŋ oc sam ŋac bu iŋ dau atui awhê ma ŋgac. ");
INSERT INTO buk_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Anötö ndê mwasiŋ gic waê lau naŋ sêtap kisa sa tu sêsa Anötö ndê lêŋ gitêŋ-ŋga. Iŋ gêlic ŋayham bu kôc ŋac sa sêmbo iŋ ndê gôliŋ ŋapu. ");
INSERT INTO buk_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Têŋ ndoc lau sêkêŋ kisa mac ma sêpu mac ti sêŋgôliŋ yom sac daêsam pi mac tu mac aŋkuc aö-ŋga, naŋ ahêgo daôm dom. Bu Anötö oc êmwasiŋ mac. ");
INSERT INTO buk_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Atac ŋayham ma atisambuc, bu Anötö oc kêŋ ŋaôli ŋayham têŋ mac yêc undambê. Ma gauc nem bu ŋalêŋ tigeŋ, lau sêkêŋ kisa Anötö ndê lau propet naŋ sêmbo muŋ su.” ");
INSERT INTO buk_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ma Yisu sôm, “Dakêŋ gwêc so sip gêŋ daneŋ-ŋga bu dakôm gêŋ dau ŋayham. Ma mac ambo lau nom-ŋga ŋalôm atôm gwêc so. Tigeŋ gwêc so bu ŋamakic niŋga, oc dakôm ŋamakic sa tiyham ŋalêŋ nde? Iŋ tisac su, ma tambaliŋ siŋ niŋga, ma lau sêkwê dôŋ. ");
INSERT INTO buk_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ma mac ambo nom atôm ŋawê bu pô gameŋ. Malac daŋ bu yêc lôc, oc tôm dom bu siŋ dau kwi. ");
INSERT INTO buk_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ma têŋ ndoc datuŋ lam asê, oc taŋgatöc ŋa suc ahuc dom. Taŋkiŋ sa bu ŋawê pô gameŋ hoŋ. ");
INSERT INTO buk_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bocdinaŋ, akôm mêtê ŋayham yêc lau hoŋ aŋgô-ŋga, naŋ gitôm mac nem ŋawê bu pô gameŋ. Ma lau oc sêlic mac nem mêtê ŋayham, ma sêmpiŋ Damam undambê-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Gauc nem dom bu aö gameŋ tu waseŋ Anötö ndê yom naŋ Moses ti lau propet sêto yêc, naŋ su-ŋga. Aö gameŋ tu waseŋ su-ŋga dom, tigeŋ tu wakôm yom dau ŋandô sa-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yomandô, aö wasôm têŋ mac bu undambê ti nom bu niŋga, magoc yom ŋalhô sauŋ daŋ oc niŋga yêc yomsu dom e aö dauŋ wandic dabiŋ gêŋ hoŋ. ");
INSERT INTO buk_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Asa naŋ kêgilì yomsu naŋ hêganôŋ gêŋ sauŋ andô daŋ, me kêdôhôŋ lau ŋatô bu sêkôm bocdinaŋ, naŋ ti ŋamalac waêmba yêc Anötö ndê gôliŋ ŋapu. Magoc asa naŋ daŋga wambu Anötö ndê yomsu, ma kêdôhôŋ lau ŋatô bu sêkôm bocdinaŋ, naŋ ti ŋamalac tiwaê yêc Anötö ndê gôliŋ ŋapu. ");
INSERT INTO buk_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Aŋgô! Lau Palêsai ti †kêdôhôŋ-waga yomsu-ŋga sêŋsahê ŋaŋga bu sêti lau gitêŋ, tigeŋ aö wasôm têŋ mac, bu mac bu ati lau gitêŋ ahôc gêlêc ŋac dom, dec oc tôm dom bu mac ambo Anötö ndê gôliŋ ŋapu.” ");
INSERT INTO buk_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ma Yisu sôm têŋ ŋac, “Mac aŋyalê yom naŋ Anötö kêŋ têŋ abaŋi bocdec bu, ‘Ndic ŋamalac ndu dom.’ Ma ‘Asa naŋ bu ndic ŋamalac ndu, naŋ oc tap ŋagêyô sa.’ ");
INSERT INTO buk_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tigeŋ kwahic dec aö wasôm têŋ mac, bu asa naŋ tac ŋandê têŋ ŋamalac daŋ, naŋ oc tap ŋagêyô sa gitôm iŋ naŋ gic ŋamalac ndu. Ma mac nem ŋagôliŋ daŋ sôm bu lau atu-tu sêmatôc ŋamalac naŋ sam ndê asidôwa bu ŋamalac gauc mbasi-ŋga. Magoc aö wasôm têŋ mac, bu asa naŋ sôm yom kaiŋ dinaŋ, naŋ gitôm bu tap ŋagêyô lambwam-ŋga sa. ");
INSERT INTO buk_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Bocdinaŋ têŋ ndoc am bu lic om ma bu kêŋ nem da têŋ Anötö, ma bu gauc nem yom daŋ yêc amlu ŋamalac daŋ ŋasawa, ");
INSERT INTO buk_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","naŋ goc hu nem da siŋ yêc alta ŋamakê ma sa ndi tap ŋamalac dau sa. Gêŋ ŋamata-ŋga amlu amasaŋ yom naŋ yêc amlu ŋasawa, goc mbu ndi ma kêŋ nem da têŋ Anötö. ");
INSERT INTO buk_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ma am nem tôp bu yêc ŋamalac daŋ, ma iŋ bu wê am têŋ ŋgac êmatôc yom-ŋga ndi, naŋ êmasaŋ yom têŋ iŋ ŋagahô, têŋ ndoc amlu aŋsêlêŋ ambo seŋ. Ma bocdinaŋ ŋgac dau oc kêŋ am têŋ ŋgac êmatôc yom-ŋga dom. Bu mba, mboe ŋgac êmatôc yom-ŋga oc kêŋ am têŋ ŋgac yob gapocwalô-ŋga, ma iŋ êmbaliŋ am sôc gapoc-walô ndi. ");
INSERT INTO buk_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Aö wasôm yom ŋandô têŋ am, am oc ndöc gapocwalô ŋapaŋ e am ndic nem tôp hoŋ pacndê.” ");
INSERT INTO buk_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ma mac aŋyalê yom naŋ Moses to bocdec bu, ‘Kôm gêŋ mockaiŋ-ŋga dom.’ ");
INSERT INTO buk_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tigeŋ kwahic dec aö wasôm têŋ mac, ŋgac daŋ bu tahê awhê daŋ e ŋalôm ŋagalac, naŋ gitôm iŋ kôm mêtê mockaiŋ-ŋga têŋ iŋ su, yêc iŋ ndê ŋalôm. ");
INSERT INTO buk_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Am tanôm daŋga bu hê am têŋ sac, goc kip tanôm dinaŋ sa ma êmbaliŋ niŋga. Am tanôm daŋ bu niŋga, naŋ hôc gêlêc am tanôm lu yêc ma hê am bu kôm sac, ma tiŋambu Anötö kêŋ am sip ya lambwam-ŋga ti ŋamlic sambuc ndi. ");
INSERT INTO buk_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma amam daŋga bu tim am, goc tim kic ma êmbaliŋ niŋga. Amam daŋ bu niŋga, naŋ hôc gêlêc am mbo ti amam lu-lu ma kôm sac su, ma tiŋambu sip ya lambwam-ŋga ti ŋamlic sambuc ndi.” ");
INSERT INTO buk_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ma Moses to yom daŋ bocdec bu, ‘Ŋgac daŋ naŋ gauc gêm bu hu nawhê siŋ, naŋ kêŋ bapia sêhu dau siŋ-ŋga têŋ nawhê, goc hu iŋ siŋ.’ ");
INSERT INTO buk_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tigeŋ aö wasôm têŋ mac, bu yom tigeŋ yêc bu ŋgac hu iŋ nawhê siŋ, naŋ awhê dau kôm mêtê mockaiŋ-ŋga whiŋ ŋgac daŋ. Ŋgac daŋ bu hu nawhê siŋ ŋambwa, naŋ kôm iŋ ti awhê mockaiŋ-ŋga. Ma ŋgac wakuc daŋ bu nem awhê dau, naŋ kôm mêtê mockaiŋ-ŋga whiŋ.” ");
INSERT INTO buk_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mac aŋyalê yom daŋ tiyham naŋ Anötö kêŋ têŋ abaŋi bocdec bu, ‘Yom bocke naŋ mac amatiŋ tidôŋ, naŋ akôm popoc dom,’ ma ‘Yom naŋ mac bu apuc dôŋ bu yomandô yêc Pômdau aŋgô-ŋga, naŋ akôm ŋandô sa.’ ");
INSERT INTO buk_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Magoc aö wasôm têŋ mac, bu asôm yom daŋ tu apuc nem yom dôŋ-ŋga dom. Asôm yom pi undambê me pi nom tu bu apuc nem yom dôŋ-ŋga dom, ŋahu bu Anötö iŋ undambê ti nom ŋadau. Ma asôm yom pi Jerusalem dom, bu Anötö kêyaliŋ malac dau sa ti iŋ ndê kiŋ atu ndê malac. ");
INSERT INTO buk_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma asôm yom pi nem ŋagôlôŋ dom, bu mac atôm dom bu akôm nem kêclauŋ daŋ tisêp me tiyec. ");
INSERT INTO buk_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Asa bu lôc bu kôm gêŋ daŋ, naŋ sôm ‘Aêc, aö wakôm,’ ma bu kôm dom goc sôm, ‘Mba, aö wakôm dom.’ Yom ŋatô bocke naŋ mac asôm tu apuc yom dau dôŋ-ŋga, naŋ meŋ akêŋ Sadaŋ ndê.” ");
INSERT INTO buk_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ma mac aŋyalê yom naŋ Moses to bocdec bu, ‘Ŋamalac daŋ bu ndic am tanôm tisac, naŋ ndic iŋ ndê ô. Ma asa naŋ tuc nem ŋalhôm daŋ dulu, naŋ tuc iŋ ndê dulu ô.’ ");
INSERT INTO buk_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tigeŋ aö wasôm têŋ mac bu akôm mêtê sac ô mêtê sac naŋ lau sêkôm têŋ mac, naŋ dom. Daŋ bu tap am sip alim andô daŋga, naŋ kêŋ daŋga bu iŋ ndic whiŋ. ");
INSERT INTO buk_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ma ŋgac daŋ bu wê am têŋ lau sêmatôc yom-ŋga, ma iŋ tac whiŋ bu am nemlhi iŋ ŋa am nem gêŋ sauŋ daŋ, goc kêŋ nem gêŋ atu têŋ iŋ whiŋ. ");
INSERT INTO buk_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ma lau †Rom-ŋga si ŋgac siŋ-ŋga daŋ bu kac yom am bu hoŋ iŋ ndê wapa seŋ ŋasawa apê, goc hoŋ wapa dau êmsêlêŋ seŋ ŋasawa baliŋ whiŋ iŋ ndi. ");
INSERT INTO buk_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Êmgamiŋ nem gêŋ têŋ lau naŋ sêteŋ gêŋ têŋ am, naŋ dom, ma daŋ bu ndac am bu nem iŋ sa ŋa gêŋ daŋ, naŋ puc dômwêm iŋ dom.” ");
INSERT INTO buk_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ma mac aŋyalê yom naŋ Moses to bocdec bu, ‘Atac whiŋ nem lau meŋpaŋ am-ŋga,’ ma yom naŋ lau sêsôm bocdec bu, ‘Atac tec nem ŋacyo.’ ");
INSERT INTO buk_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tigeŋ aö wasôm têŋ mac bu atac whiŋ nem ŋacyo, ma ateŋ mbec tu lau naŋ sêkêŋ kisa mac-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mac bu akôm boc-dinaŋ, goc Damam undambê-ŋga oc sam mac bu iŋ atui awhê ma ŋgac. Iŋ dau kêŋ ndê ac pi pô lau sac ti lau ŋayham, ma kêŋ u gic lau gitêŋ ti lau naŋ sêsa lêŋ giso. ");
INSERT INTO buk_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Lau sac ma lau naŋ sêkôc takis-ŋga atac whiŋ lau naŋ atac whiŋ ŋac, ma sêtec lau naŋ sêtec ŋac. Mac bu aŋkuc ŋac si mêtê, dec tu sake-ŋga Anötö oc lic mac ŋayham? ");
INSERT INTO buk_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Lau sambuc sêtoc dau si asidôwai sa, magoc sêtec lau ŋatô. Bocdinaŋ mac bu atoc nem asidôwai tawasê sa, dec tu sake-ŋga Anötö oc lic mac ŋayham hôc gêlêc lau sambuc? ");
INSERT INTO buk_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Akôc gauc pi yom hoŋ dinaŋ, ma akôm mêtê solop eŋ, tôm Damam undambê-ŋga ndê mêtê.” ");
INSERT INTO buk_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ma Yisu gic têku yom ma sôm, “Ayob daôm bu akôm nem sakiŋ anem akiŋ Anötö-ŋga tu bu lau sêlic e sêmpiŋ mac-ŋga dom. Mac bu akôm tu bu lau sêmpiŋ mac-ŋga, oc atap nem ŋaôli daŋ sa yêc Damam undambê-ŋga dom.” ");
INSERT INTO buk_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Bocdinaŋ têŋ ndoc am bu nem lau ŋalôm sawa sa, naŋ goc sêc gêŋ dau ahuc. Ndic dahuc taŋ bu kêŋ puc lau dom. †Lau sêtim yom lau-ŋga naŋ sêtoc dau sa, naŋ sêkôm bocdinaŋ yêc lôm wê-ŋga ti malac lôm, bu lau sêlic e sêmpiŋ ŋac. Yomandô aö wasôm têŋ mac bu lau si sêmpiŋ ŋac, dinaŋ ti ŋac si ŋaôli sambuc naŋ sêkôc sa su. ");
INSERT INTO buk_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tigeŋ têŋ ndoc am bu kêŋ gêŋ têŋ lau ŋalôm sawa, naŋ siŋ ma kêŋ gelec têŋ ŋac, ma yob bu lau daŋ sêŋgô ŋayom dom. ");
INSERT INTO buk_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Bocdinaŋ am nem mêtê kôm yác lau-ŋga oc yêc siŋ dau. Ma Damam naŋ gêlic gêŋ naŋ yêc siŋ, naŋ oc kêŋ ŋaôli têŋ am.” ");
INSERT INTO buk_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ma têŋ ndoc am bu teŋ mbec, naŋ teŋ tôm lau sêtim yom lau-ŋga dom. Ŋac atac whiŋ bu sêteŋ mbec sêlhac lôm wê-ŋga ti seŋ ŋamakê, tu bu lau sêlic ma sêmpiŋ ŋac-ŋga. Yomandô aö wasôm têŋ mac bu lau si sêmpiŋ ŋac, dinaŋ ti ŋac si ŋaôli sambuc naŋ sêkôc sa su. ");
INSERT INTO buk_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Têŋ têm am bu teŋ mbec, naŋ goc sôc nem andu ŋalôm ma sêc gatam ahuc, ma teŋ mbec têŋ Damam yêc malam naŋ lau daŋ sêlic dom. Ma Damam naŋ kêyalê gêŋ naŋ yêc siŋ dau, naŋ oc kêŋ ŋaôli têŋ am. ");
INSERT INTO buk_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ma têŋ têm mac bu ateŋ mbec, naŋ ateŋ mbec baliŋ tôm lau sambuc dom. Ŋac gauc gêm bu mbec dau oc ŋandô sa tu ŋac si yom ŋalhô daêsam-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Aŋkuc ŋac si gêbôm dom, bu Damam kêyalê gwanaŋ su, gêŋ naŋ mac apônda. ");
INSERT INTO buk_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Bocdinaŋ ateŋ mbec bocdec bu: Damaŋ, am naŋ mbo undambê. Am nem ŋaê lau sênem dabuŋ maŋ. ");
INSERT INTO buk_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mweŋ ti lau hoŋ si Pômdau. Kêŋ lau daŋga wambu nem yom ŋapep yêc nom, gitôm yêc undambê. ");
INSERT INTO buk_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kêŋ yac mba gö têŋ ac dindec. ");
INSERT INTO buk_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Suc yac mba sac ŋatôp kwi, tôm yac asuc lau naŋ sêkôm sac têŋ yac, naŋ si sac ŋatôp kwi. ");
INSERT INTO buk_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yob yac têŋ lêtôm bu tap yac sa dom, ma têŋ ŋgac sac Sadaŋ bu kôm yac ŋayom dom. ");
INSERT INTO buk_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mac bu asuc lau naŋ sêkôm sac têŋ mac, naŋ si sac kwi, goc Damam undambê-ŋga oc suc mac nem kwi bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Magoc mac bu asuc lau si sac kwi dom, dec Damam oc suc mac nem kwi dom bocdinaŋ.” ");
INSERT INTO buk_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ma têŋ têm mac bu ahu gêŋ daneŋ-ŋga siŋ tu anem akiŋ Anötö-ŋga, naŋ akôm aŋôm andô masiŋ-masiŋ tôm lau sêtim yom lau-ŋga sêkôm, naŋ dom. Lau dinaŋ sêkôm aŋgô andô tisac, bu lau sêlic ma sêŋyalê bu ŋac sêhu gêŋ daneŋ-ŋga siŋ ma tu dinaŋ-ŋga sêmpiŋ ŋac. Yomandô aö wasôm têŋ mac bu lau si sêmpiŋ ŋac, dinaŋ ti ŋac si ŋaôli sambuc naŋ sêkôc sa su. ");
INSERT INTO buk_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Bocdinaŋ têŋ têm mac ahu gêŋ daneŋ-ŋga siŋ tu anem akiŋ Anötö-ŋga, naŋ aliŋ bu ma amasaŋ daôm ŋapep. ");
INSERT INTO buk_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ma ŋalêŋ dinaŋ lau daŋ oc sêŋyalê dom bu mac ahu gêŋ daneŋ-ŋga siŋ. Tigeŋ mac nem Damam naŋ mbo siŋ dau, naŋ kêyalê gêŋ hoŋ naŋ yêc siŋ dau, ma bocdinaŋ oc kêŋ nem ŋaôli têŋ mac.” ");
INSERT INTO buk_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ma Yisu sôm, “Andic nem awa ti wapa sa lhac nom dom, bu sop oc neŋ, ma u oc nôm gêŋ dau tibalê, ma lau kaŋ oc sênem kaŋ sa. ");
INSERT INTO buk_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Apo gêŋ undambê-ŋga sa ti nem awa ŋandô, ma sop ti u oc seŋ su dom, ma gitôm dom bu lau kaŋ sêsôc sêndi bu sênem kaŋ. ");
INSERT INTO buk_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Aö gasôm yom dinaŋ, ŋahu bu gameŋ bocke naŋ mac nem awa yêc, naŋ mac nem ŋalôm ti gauc oc sap dôŋ ŋapaŋ.” ");
INSERT INTO buk_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ŋamalac si tandô gitôm ya ŋawê naŋ tôc seŋ têŋ ŋac. Bocdinaŋ mac nem tanôm bu wê mac asa lêŋ ŋayham, goc mac nem ŋamlic ŋagêŋ hoŋ oc yêc ŋawê ŋalôm eŋ. ");
INSERT INTO buk_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Magoc tanôm bu wê mac asa lêŋ sac-ŋga, goc mac gacgeŋ ambo ŋasec ŋalôm. Bocdinaŋ mac bu gauc nem bu ambo ŋawê ŋalôm, magoc asa lêŋ ŋasec-ŋga, naŋ dec ŋasec gêm mac ahuc sambuc.” ");
INSERT INTO buk_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ŋamalac daŋ gitôm dom bu nem akiŋ ŋadau lu, bu iŋ oc tec daŋ, ma atac whiŋ daŋ, me sap daŋ dôŋ ma pu daŋ. Ma mac bocdinaŋ, gitôm dom bu mac atoc Anötö ma awa nom-ŋga lu-lu sa ti mac nem ŋadau.” ");
INSERT INTO buk_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Tu dinaŋ-ŋga dec ahêgo daôm dom tu gêŋ aneŋ-ŋga ti anôm-ŋga, me tu ŋakwê asôc-ŋga. Anötö kêŋ mac ambo tamli, ma gêŋ dinaŋ iŋ gêŋ atu. Gêŋ daneŋ-ŋga iŋ gêŋ atu dom. Ma Anötö kêŋ mac nem ŋamlic ŋagêŋ hoŋ, ma gêŋ dinaŋ iŋ gêŋ atu. Ŋakwê asôc-ŋga iŋ gêŋ atu dom. ");
INSERT INTO buk_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","“Akôc gauc pi mbac. Ŋac sêsô gêŋ dom, sêhoŋ gêŋ ŋandô ma sic sa sôc andu gêŋ ŋandô-ŋga dom. Tigeŋ Damam undambê-ŋga gôlôm ŋac. Ma iŋ tac whiŋ mac ŋamalac hôc gêlêc mbac hoŋ su. ");
INSERT INTO buk_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ma mac nem asa bu hêgo dau, dec oc tôm bu ndic têku ndê têm mbo tali-ŋga? ");
INSERT INTO buk_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Tu sake-ŋga mac nem ŋalôm ŋawapac tu ŋakwê asôc-ŋga? Akôc gauc pi ŋaola ŋayham naŋ sêpo sêlhac kwaŋ ŋalôm, naŋ sêkôm gweleŋ ti sêmasaŋ ŋakwê dom. ");
INSERT INTO buk_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tigeŋ aö wasôm têŋ mac bu Kiŋ Solomon iŋ sôc ŋakwê ŋayham andô, magoc iŋ ndê gôlôŋ ti ŋawasi hôc gêlêc ŋaola dinaŋ daŋ su dom. ");
INSERT INTO buk_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","O mac lau naŋ akêŋ whiŋ gwalec, aŋgô! Kwaŋ ti ŋaola nom-ŋg a sêlhac bêc daêsam dom, ma lau oc sêkêŋ ya neŋ su. Magoc Anötö kêŋ gêŋ dau ti ŋadalô ŋayham, ma yob ŋapep. Ma bocdinaŋ aŋyalê bu yom ŋandô, iŋ oc yob mac, ma kêŋ ŋakwê têŋ mac whiŋ. ");
INSERT INTO buk_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Bocdinaŋ ahêgo daôm dom ma asôm bu ‘Daneŋ sake?’ me ‘Danôm sake?’ me ‘Dasôc ŋakwê bocke?’ lec dom. ");
INSERT INTO buk_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Lau sambuc naŋ sêŋyalê Anötö dom, naŋ sêhêgo dau tu gêŋ hoŋ dinaŋ-ŋga, tigeŋ Damam undambê-ŋga kêyalê su bu mac apônda gêŋ hoŋ dinaŋ. ");
INSERT INTO buk_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Gêŋ ŋamata-ŋga akôm ŋaŋga bu atap malam sa yêc Anötö ndê gôliŋ ŋapu, ma bu asa iŋ ndê lêŋ gitêŋ. Ma iŋ oc yob mac tu gêŋ nom-ŋga-ŋga whiŋ. ");
INSERT INTO buk_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Bocdinaŋ ambo ti nem ŋalôm ŋawapac tu gêŋ laŋsê-ŋga dom. Ahu siŋ yêc e laŋsê dau hôc asê. Ŋawapac bêc tigeŋ-ŋga naŋ gitôm bêc tigeŋ dinaŋ.” ");
INSERT INTO buk_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ma Yisu sôm, “Alic lau sac ŋambwa tu ŋac si lêŋ ti sakiŋ-ŋga dom, dec Anötö oc lic mac sac tu nem-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Bu Anötö oc êŋsahê mac tôm mac aŋsahê lau, ma nem dôhôŋ mac nem lêŋ ti sakiŋ tôm dôhôŋ naŋ mac am dôhôŋ lau si. ");
INSERT INTO buk_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Tu sake-ŋga am hêgo daôm tu gêŋ golop sauŋ naŋ yêc nem asidôwa tandô, tigeŋ gêŋ golop atu naŋ yêc am daôm tanôm, naŋ gêlic apu? ");
INSERT INTO buk_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ma bocke am sôm têŋ nem asidôwa, ‘Aö bu wakôc gêŋ golop naŋ yêc am tanôm, naŋ sa.’ Tigeŋ gêŋ golop atu pôc daôm nem tanôm ahuc? ");
INSERT INTO buk_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Am ŋgac tim yom lau-ŋga! Kôc gêŋ golop atu sa yêc daôm tanôm muŋ e tanôm ŋawa sa, naŋ goc kôc gêŋ golop sauŋ dinaŋ sa yêc nem asidôwa tandô.” ");
INSERT INTO buk_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Akêŋ gêŋ dabuŋ têŋ giam dom, b u oc sêkac dau kwi ma sêseŋ mac. Ma ambaliŋ nem gôlôŋ ŋayham têŋ bôc dom, bu oc sêkwê popoc.” ");
INSERT INTO buk_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ateŋ gêŋ têŋ Anötö, dec oc akôc ŋandô, aŋsalê iŋ ti ndê lêŋ, ma oc atap sa, ma bu amati gatam oc lêc su têŋ mac. ");
INSERT INTO buk_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Bu Anötö kêŋ gêŋ têŋ lau hoŋ naŋ sêndac iŋ, ma lau hoŋ naŋ sêŋsalê iŋ ti ndê lêŋ, naŋ oc sêtap sa, ma ŋac naŋ sêmati gatam naŋ oc lêc su têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Mac dambai aŋgô! Nem balê daŋ bu teŋ gö têŋ am, dec am oc kêŋ hoc têŋ iŋ, a? ");
INSERT INTO buk_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma bu teŋ i oc kêŋ mboc sac têŋ iŋ, a? ");
INSERT INTO buk_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mba! Mac lau sac, tigeŋ atoc nem balêkoc sa ŋa gêŋ ŋayham. Magoc Damam naŋ mbo undambê iŋ gitêŋ eŋ, ma oc kêŋ gêŋ ŋayham-ŋayham eŋ têŋ lau naŋ sêteŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Akôm mêtê ŋayham têŋ lau hoŋ, gitôm mêtê ŋayham naŋ mac atac whiŋ bu sêkôm têŋ mac. Yom hoŋ naŋ Moses ti lau propet sêto, naŋ hêganôŋ yac dakôm mêtê ŋayham bocdinaŋ.” ");
INSERT INTO buk_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Aŋsahê ŋaŋga bu atap gameŋ andöc tamli ŋapaŋ-ŋga sa, magoc aŋyalê bu gatam gameŋ dinaŋ-ŋga iŋ gatam sauŋ. Bu gameŋ andiŋam-ŋga dê yêc, ma seŋ têŋ gameŋ dau iŋ seŋ atu, ma ŋagatam atu bocdinaŋ. Lau daêsam sêsa seŋ atu dinaŋ, ma oc sêsôc gatam atu dau. ");
INSERT INTO buk_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Magoc gameŋ dandöc taŋli ŋapaŋ-ŋ ga ŋagatam iŋ gatam sauŋ, ma seŋ têŋ gameŋ dinaŋ iŋ seŋ atu dom, ma lau daêsam oc sêtap sa dom.” ");
INSERT INTO buk_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ayob daôm tu propet tasaŋ-ŋga. Ŋac sêtôm giam pôm naŋ sêmpaŋ dau ahuc ŋa domba ŋamlic, tu bu sêti gasuc domba-ŋga ma sêseŋ ŋac su. Ŋalêŋ tigeŋ propet tasaŋ oc sêtêŋ mac sêloc tu sêŋsau mac-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Aŋsahê ŋac si lêŋ dec tôm bu mac aŋyalê bu ŋac lau tasaŋ. Ŋalêŋ tigeŋ, yac dalic a ŋandô ma taŋyalê a dau bu ŋayham me sac. Oc tôm dom bu dahiŋ ŋandô ŋayham yêc a sac. ");
INSERT INTO buk_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yomandô! A ŋayham sem ŋandô ŋayham, ma a sac sem ŋandô sac. ");
INSERT INTO buk_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","A ŋayham daŋ gitôm dom bu nem ŋandô sac, ma a sac gitôm dom bu nem ŋandô ŋayham. ");
INSERT INTO buk_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ma a hoŋ naŋ sem ŋandô sac, naŋ oc sêlêŋ su ma sêtuc pi ya ndi, ma ya neŋ su. ");
INSERT INTO buk_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Bocdinaŋ aŋsahê propet si lêŋ, ma aŋyalê ŋac bu propet ŋayham me sac.” ");
INSERT INTO buk_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Lau daêsam sêsam aö bu, ‘Pômdau,’ tigeŋ ŋac hoŋ oc sêtap gameŋ undambê-ŋga sa dom. Mba! Lau naŋ daŋga wambu Damaŋ undambê-ŋga ŋapep, ma sêkôm mêtê tôm iŋ atac whiŋ, naŋ oc sêtap undambê sa. ");
INSERT INTO buk_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Têŋ Anötö ndê bêc êmatôc lau-ŋga, naŋ lau tasaŋ daêsam oc sêsôm têŋ aö bu, ‘Pômdau, Pômdau! Yac ahoc yom asê atôm propet, ma atiŋ ŋalau sac su ma akôm gêŋ dalô daêsam am am aŋôm. Bocdinaŋ kôc yac sa.’ ");
INSERT INTO buk_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tigeŋ aö wasôm têŋ ŋac bu, ‘Aö kayalê mac dom sambuc mac lau sac. Alhö su yêc aö!’” ");
INSERT INTO buk_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Lau naŋ sêŋgô aneŋ yom ma sêkôm ŋandô sa, naŋ sêtôm ŋgac tigauc naŋ kwê ndê andu kalhac nom ŋaŋga ma kêŋ hoc kêgapiŋ alhö dôŋ. ");
INSERT INTO buk_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Têŋ ndoc u gic e bu hêc, ma mbu puc ŋadinda hôc pi andu dau, naŋ andu dau ku sa dom bu hoc kêgapiŋ dôŋ. ");
INSERT INTO buk_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Magoc lau naŋ sêŋgô aneŋ yom ma sêkôm ŋandô sa dom, naŋ sêtôm ŋgac gauc mba naŋ kwê ndê andu kalhac nom babalê. ");
INSERT INTO buk_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ma u gic ti bu hêc, ma mbu puc ŋadinda hôc pi andu dau, goc ku sa ma tisac sambuc.” ");
INSERT INTO buk_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yisu gic bata ndê yom dinaŋ, ma lau hoŋ sêhêdaê tu iŋ ndê yom-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ŋahu bu yom naŋ iŋ kêdôhôŋ têŋ ŋac naŋ yom ti ŋaclai, hôc gêlêc lau Israel-ŋga si kêdôhôŋwaga yomsu-ŋga si yom hoŋ su. ");
INSERT INTO buk_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yisu sip akêŋ lôc meŋ, ma lau daêsam sêŋkuc iŋ. ");
INSERT INTO buk_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ma ŋgac daŋ ti gêmbac †leprasi têŋ iŋ gi, goc pôŋ haduc ma sôm, “Pômdau. Am bu tac whiŋ dec gitôm bu am oc kôm aö ŋamlic ŋawasi sa.” ");
INSERT INTO buk_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yisu kêmatôc amba sa gi ma kêmasec iŋ, ma sôm, “Aö atac whiŋ, dec wasôm têŋ am bu ŋamlic ŋawasi sa.” Ma ŋagahô eŋ gêmbac hu iŋ siŋ, ma iŋ ŋamlic ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ma Yisu sôm têŋ iŋ, “Am ŋgô! Gêŋ naŋ kwahic dec hôc asê am, naŋ sôm asê têŋ lau daŋ dom. Tigeŋ têŋ †dabuŋsiga ndi, tôc daôm têŋ iŋ bu lic bu am nem ŋamlic ŋawasi sa su. Ma kêŋ da tôm yomsu naŋ Moses kêŋ têŋ yac. Ma ŋalêŋ dinaŋ lau hoŋ oc sêŋyalê bu am ŋamlic ŋayham sa.” ");
INSERT INTO buk_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tiŋambu Yisu sôc malac Kapenaom gi. Ma ŋgac bata Rom-ŋga daŋ, naŋ gêm gôliŋ lau siŋ-ŋga 100, naŋ têŋ iŋ gi ma ndac iŋ bu nem iŋ sa. ");
INSERT INTO buk_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Iŋ sôm, “Pômdau, aneŋ ŋgac akiŋ daŋ ndöc bôliŋ. Iŋ yêc andu ŋapaŋ ma kêsahê ŋandê atu.” ");
INSERT INTO buk_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ma Yisu sôm têŋ iŋ, “Aö oc waloc ma wakôm iŋ ŋayham sa.” ");
INSERT INTO buk_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tigeŋ ŋgac bata dau ô yom ma sôm, “Pômdau, am ŋgac atu ma aö ŋgac apa, dec mayaŋ dauŋ bu am sôc aneŋ andu. Tigeŋ aö kayalê su bu am ŋgac ti ŋaclai atu, ma bocdinaŋ dec am bu ndic atu yom, goc aneŋ ŋgac akiŋ oc ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Bu aö dauŋ daŋaŋ wambu lau naŋ si ŋaclai hôc gêlêc aö neŋ, ma aneŋ lau siŋ-ŋga daŋga wambu aö. Aö bu wasôm têŋ daŋ, ‘Am ndi!’ goc iŋ oc ndi. Ma bu wasôm têŋ daŋ, ‘Am mweŋ,’ goc iŋ oc meŋ. Ma bu wasôm têŋ aneŋ ŋgac akiŋ bu kôm gêŋ daŋ, goc iŋ oc kôm.” ");
INSERT INTO buk_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yisu ŋgô ŋgac bata ndê yom ma hêdaê, ma sôm têŋ lau naŋ sêŋkuc iŋ bu, “Yomandô wasôm têŋ mac, bu yêc lau Israel hoŋ aö gatap ŋac si daŋ naŋ kêŋ whiŋ ŋaŋga gitôm ŋgac Rom-ŋga dindec, naŋ sa dom. ");
INSERT INTO buk_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Aŋgô! Lau daêsam naŋ lau Israel dom, naŋ oc sêmeŋ akêŋ nom ŋabatiŋ hoŋ, ma sêtap mwasiŋ atu sa yêc undambê sêwhiŋ Abraham, Aisak ma Jakob. ");
INSERT INTO buk_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tigeŋ lau Israel daêsam naŋ gauc gêm bu sic waê bu sêndöc undambê, naŋ Anötö oc êmasuc ŋac su sêndöc gameŋ ŋasec-ŋga, ma sêtaŋ ti lhö êŋsiŋ pi dau.” ");
INSERT INTO buk_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yisu sôm yom dinaŋ têŋ lau hoŋ su, goc sôm têŋ ŋgac bata, “Am lhö mbu ndi. Aö oc wakôm am nem ŋgac akiŋ dinaŋ ŋayham sa, tôm am kêŋ whiŋ.” Ma têŋ ndoc dau dinaŋ gêmbac hu ŋgac akiŋ dau siŋ, ma iŋ ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tiŋambu Yisu têŋ Pita ndê andu gi ma gêlic Pita lawawê gêmbac lic ŋandê atu ma yêc. ");
INSERT INTO buk_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yisu têŋ iŋ gi ma kêmasec iŋ amba, goc gêmbac hu iŋ siŋ. Ma iŋ tisa, ma ndê gêŋ daneŋ-ŋga ma kêŋ têŋ Yisu. ");
INSERT INTO buk_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Têŋ telha dinaŋ ac gi sip su, g oc lau malac-ŋga sêkôc lau daêsam naŋ ŋalau sac sêmbo ŋac si ŋalôm, naŋ sa sêtêŋ Yisu si. Ma iŋ gic atu yom, goc ŋalau sac sêhu lau dau siŋ, ma iŋ kôm lau gêmbac hoŋ ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ŋalêŋ dau dinaŋ yom naŋ propet Aisaya sôm su naŋ dec ŋandô sa. Muŋ-ŋga iŋ to yom pi Mesaya bocdec bu: Iŋ hôc yac neŋ ŋawapac tu nem yac sa-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Têŋ bêc daŋ Yisu gêlic lau daêsam sêŋgihi iŋ ahuc, goc sôm têŋ ndê †ŋgacsêŋomi bu sêlom bugictoŋ ma sêpi daŋga sêndi. ");
INSERT INTO buk_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","S êmasaŋ dau sêmbo ma kêdôhôŋ-waga yomsu-ŋga daŋ meŋ ma sôm têŋ iŋ, “Kêdôhôŋwaga, aö bu waŋkuc am, wawhiŋ am watêŋ gameŋ bocke naŋ am oc ndi.” ");
INSERT INTO buk_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ma Yisu ô iŋ ndê yom ma sôm, “Giam pôm si hocsuŋ yêc, ma mbac lôlôc-ŋga si ŋaic yêc, tigeŋ †Ŋamalac ndê Atu dau ndê mala yêc bêc-ŋga mba.” ");
INSERT INTO buk_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ma sêŋom daŋ sôm têŋ iŋ, “P ômdau, aö bu waŋkuc am, magoc gêŋ ŋamata-ŋga aö wandi wambo wawhiŋ aneŋ lau e aŋsuhuŋ damaŋ su naŋ.” ");
INSERT INTO buk_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tigeŋ Yisu sôm, “Mba! Am bu gauc nem bu êmkuc aö, naŋ gêŋ ŋamata-ŋga. Tec lau batê sêŋsuhuŋ lau batê.” ");
INSERT INTO buk_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yisu sôm yom dinaŋ su, goc pi waŋ daŋ gi. Ma iŋ ndê ŋgac-sêŋomi sêŋkuc iŋ ma sêpi waŋ sêwhiŋ. ");
INSERT INTO buk_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Sêlac si, ma mbu puc atu ma gêli bu ŋampoŋ sa gic sip waŋ, e kêpiŋ bu waŋ pac. Tigeŋ Yisu yêc bêc yêc waŋ. ");
INSERT INTO buk_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Dec sêtêŋ iŋ si, sêuŋ iŋ sa ma sêsôm, “Pômdau, nem yac sa, bu yac oc dapac dandiŋaŋ.” ");
INSERT INTO buk_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Magoc Yisu sôm têŋ ŋac, “O mac lau naŋ akêŋ whiŋ gwalec. Tu sake-ŋga mac atöc daôm?” Goc iŋ tisa ma sôm yom ŋaŋga têŋ mbu ti bu ŋampoŋ, ma gameŋ ŋaŋeŋ sa. ");
INSERT INTO buk_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ma ŋac hoŋ sêhêdaê ma sêsôm têŋ dandi, “Ei! Iŋ ŋgac kaiŋ bocke? Bu gêŋ hoŋ sêsôc iŋ ndê yom ŋapu, ma mbu ti bu sêwhiŋ.” ");
INSERT INTO buk_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ŋac sêhôc asê bugictoŋ ŋadaŋga ma sêsôc lau Gadala-ŋga si gameŋ si. Ma yêc dindê ŋgac lu sêsa akêŋ ôm sêhô-ŋga ma sêtêŋ Yisu si. Iŋlu ŋgac lu naŋ ŋalau sac sêmbo iŋlu ŋalôm, ma sêkôm iŋlu sêti ŋgac pôm. Ma bocdinaŋ lau hoŋ sêtöc iŋlu ma sêmbo ahê iŋlu, ma iŋlu sêndöc ôm sêhô-ŋga ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Têŋ ndoc iŋlu sêhôc asê Yisu, naŋ ŋalau sac naŋ sêmbo iŋlu ŋalôm, naŋ sêmbwêc bocdec bu, “O Anötö ndê Atu! Am bu kôm sake têŋ yac? Têm bu Anötö êmatôc yac-ŋga yêc dôŋ yêc. Ma bocke am kwahic dec mweŋ bu kôm yac ŋayom?” ");
INSERT INTO buk_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Bôc toŋ atu daŋ seŋ gêŋ sêmbo ahê gameŋ naŋ ŋac sêlhac. ");
INSERT INTO buk_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Goc ŋalau sac sêteŋ Yisu bu, “Am bu soc yac su, naŋ kêŋ yac asip bôc ŋalôm.” ");
INSERT INTO buk_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ma iŋ sôm têŋ ŋac, “Andi!” Goc sêhu ŋgac lu dinaŋ siŋ ma sêsôc bôc ŋalôm si. Ma bôc hoŋ sênti sêsip salic sac, sêsip bugictoŋ ŋalôm si, ma bu kô ŋac sêmbac ndu. ");
INSERT INTO buk_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Lau sêyob bôc-ŋga sêlic gêŋ dau, goc sêlhö sêsa malac si, ma sic miŋ têŋ lau malac-ŋga pi gêŋ hoŋ dinaŋ, ma pi gêŋ naŋ Yisu kôm têŋ ŋgac lu ti ŋalau sac. ");
INSERT INTO buk_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ma lau malac-ŋga hoŋ sêsa sêtêŋ Yisu si, ma têŋ ndoc sêlic iŋ, naŋ sêteŋ iŋ bu hu ŋac si gameŋ siŋ. ");
INSERT INTO buk_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Goc Yisu pi waŋ gi ma gic bugictoŋ kic, ma têŋ iŋ ndê malac Kapenaom gi. ");
INSERT INTO buk_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ma lau gameŋ dinaŋ-ŋga sêmbalaŋ ŋgac bôliŋ daŋ yêc sac daŋ ma sêtêŋ Yisu si. Iŋ gêlic bu ŋac sêkêŋ whiŋ iŋ, dec sôm têŋ ŋgac bôliŋ dau, “Aneŋ balê, atac ŋayham sa. Kwahic dec aö oc wasuc am nem sac kwi.” ");
INSERT INTO buk_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kêdôhôŋwaga yomsu-ŋga ŋatô s êŋgô Yisu ndê yom dau, goc sêsôm têŋ dandi, “Ŋgac dê ndê yom sac sambuc! Anötö tigeŋ gitôm bu suc sac kwi.” ");
INSERT INTO buk_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yisu kêyalê ŋac si gauc, goc ndac ŋac, “Tu sake-ŋga mac gauc gêm yom sac yêc nem ŋalôm? ");
INSERT INTO buk_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mac akêŋ whiŋ dom bu aneŋ ŋaclai yêc bu wasôm têŋ ŋgac dau bu, ‘Aö wasuc am nem sac kwi.’ Bocdinaŋ aö wasôm têŋ iŋ bu, ‘Tisa ma êmsêlêŋ.’ ");
INSERT INTO buk_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ma têŋ ndoc mac alic bu aneŋ yom dinaŋ ŋandô sa, goc aŋyalê bu Anötö kêŋ ŋaclai têŋ Ŋamalac ndê Atu yêc nom, bu suc ŋamalac si sac kwi whiŋ.” Goc Yisu sôm têŋ ŋgac bôliŋ bu, “Tisa ma hôc nem mbô sa, ma lhö têŋ nem andu ndi!” ");
INSERT INTO buk_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Goc ŋgac dau tisa ma kölhö têŋ ndê andu gi. ");
INSERT INTO buk_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ma lau daêsam naŋ sêlic gêŋ dau sêhêdaê ŋandô, ma sêmpiŋ Anötö naŋ kêŋ ŋaclai bocdinaŋ têŋ ŋamalac. ");
INSERT INTO buk_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yisu kêsêlêŋ gi ma gêlic ŋgac daŋ ŋaê Matyu naŋ ndöc ndê mala kôc takis-ŋga. Ma iŋ sôm têŋ iŋ, “Êmkuc aö!” Goc Matyu tisa ma kêkuc iŋ. ");
INSERT INTO buk_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tiŋambu Yisu gêŋ gêŋ ndöc Matyu ndê andu ŋalôm, ma lau daêsam sêmeŋ ma seŋ gêŋ sêndöc sêwhiŋ Yisu ti ndê ŋgacsêŋomi. Ŋac lau sêkôc takis-ŋga ti lau ŋatô naŋ lau Palêsai sêsam ŋac bu lau sac. ");
INSERT INTO buk_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ma lau Palêsai ŋatô sêlic gêŋ dinaŋ, goc sêndac iŋ ndê ŋgacsêŋomi bocdec bu, “Tu sake-ŋga mac nem kêdôhôŋwaga gêŋ gêŋ ndöc whiŋ lau sac dindê?” ");
INSERT INTO buk_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yisu ŋgô ŋac si yom dau ma sôm, “Lau naŋ sêlic dau bu gêmbac mba, naŋ oc sêŋsalê dokta dom, magoc lau ti gêmbac oc sêŋsalê dokta. ");
INSERT INTO buk_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gauc nem Anötö ndê yom naŋ propet akwa daŋ to yêc bocdec bu, ‘Gêŋ atu naŋ aö atac whiŋ, naŋ bu mac tamwalô lau, hôc gêlêc domba hoŋ naŋ mac bu andic ndu ma akêŋ ti da, naŋ su.’ Andi ma akôc gauc pi yom dau e aŋyalê ŋahu ŋapep. Bu aö gameŋ bu waŋgalêm lau naŋ sêlic dau bu lau gitêŋ, naŋ sa dom. Aö gameŋ bu waŋgalêm lau sac sa, bu sênem dau kwi ma sêsôc Anötö ndê gôliŋ ŋapu.” ");
INSERT INTO buk_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ma Jon, Ŋgac Kêku Lau-ŋga ndê sêŋomi ŋatô sêtêŋ Yisu si ma sêndac iŋ bu, “Bocke dec yac ti lau Palêsai akêŋ bêc ŋatô bu aneŋ gêŋ dom tu gauc nem Anötö-ŋga, tigeŋ am nem ŋgacsêŋomi seŋ gêŋ tôm bêc hoŋ?” ");
INSERT INTO buk_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ma Yisu sôm têŋ ŋac, “Ŋgac nem awhê-ŋga daŋ bu êŋgalêm lau sa sêmbo sêwhiŋ iŋ tu sêneŋ mwasiŋ nem awhê-ŋga, dec oc tôm dom bu sêhu gêŋ daneŋ-ŋga siŋ ma sêndöc ti ŋalôm ŋawapac têŋ ndoc ŋgac dau mbo whiŋ ŋac. Mba! Ma bocdinaŋ aneŋ ŋgacsêŋomi sêmbo sêwhiŋ aö ti atac ŋayham, ma sêhu gêŋ daneŋ-ŋga siŋ dom. Tigeŋ ndoc oc meŋ naŋ lau oc sêkôc aö su yêc ŋac, ma têŋ têm dinaŋ ŋac oc ŋalôm ŋawapac ma sêŋkuc lêŋ dahu gêŋ daneŋ-ŋga siŋ-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ma Yisu sôm, “Yac dasi po wakuc pi ŋakwê akwa naŋ kic, naŋ dom. Bu po wakuc oc hôc ŋakwê akwa kic e tisac sambuc. ");
INSERT INTO buk_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ma têŋ ndoc lau sêmasaŋ wain wakuc, naŋ sêkêc sip bôc ŋamlic wain-ŋga akwa dom. Mba! Ŋac bu sêkôm, goc wain wakuc oc hôc ŋamlic akwa kôc. Ma wain oc wê niŋga, ma ŋamlic dau oc tisac. Bocdinaŋ lau sêkêc wain wakuc sip bôc ŋamlic wakuc, ma lu-lu oc sêyêc ŋayham.” ");
INSERT INTO buk_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yisu sôm yom dinaŋ mbo, ma ŋgac bata daŋ meŋ pôŋ haduc têŋ iŋ ma sôm, “Aneŋ atuŋwê kwahic dec mbac ndu su, magoc am bu mweŋ ma kêŋ amam sac iŋ, dec iŋ oc mbo tali tiyham.” ");
INSERT INTO buk_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Goc Yisu tisa ma iŋ ti ndê ŋgacsêŋomi sêwhiŋ ŋgac dau si. ");
INSERT INTO buk_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Sêŋsêlêŋ sêmbo, ma awhê daŋ tigasuc iŋ kalhac iŋ dômbwê ma kêmasec iŋ ndê ŋakwê ŋadali. Awhê dau hôc ŋawapac gêm dac-ŋga ŋapaŋ gitôm yala 12 su, dec ");
INSERT INTO buk_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","gauc gêm yêc dau bu, “Aö bu wamasec iŋ ndê ŋakwê ŋambwa, dec oc kôm aö ŋayham sa tiyham.” ");
INSERT INTO buk_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yisu kac dau kwi e gêlic iŋ, goc sôm, “Aneŋ bawhê, atac pa su. Am ŋayham sa tiyham tu am nem kêŋ whiŋ aö-ŋga.” Ma têŋ ndoc dau dinaŋ awhê dau ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ma tiŋambu Yisu gi e hôc asê ŋgac bata dau ndê andu, ma gêlic bu lau toŋ atu sêmbo. Ŋatô sêyu gasuc ma ŋatô sêtaŋ ti ŋanta atu. ");
INSERT INTO buk_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Goc sôm, “Alhö su, bu bawhê dau mbac ndu dom. Iŋ yêc bêc naŋ yêc.” Magoc ŋac sêmbwac iŋ. ");
INSERT INTO buk_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Dec Yisu sôm bu sêsoc ŋac sêsa sêndi, goc sôc gi kêm bawhê sip amba, ma iŋ tisa. ");
INSERT INTO buk_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ma yom dau ŋawaê tiapa sambuc yêc gameŋ dinaŋ. ");
INSERT INTO buk_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Dinaŋ su, goc Yisu kêsêlêŋ gi. Ma ŋgac tapec lu sêŋkuc iŋ ma sêmbwêc, “O †Dawid ndê Atu, tamwalô alu!” ");
INSERT INTO buk_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Magoc Yisu kêsêlêŋ gi sôc andu daŋ, dec ŋgac lu dinaŋ sêtêŋ iŋ si, ma iŋ ndac, “Amlu akêŋ whiŋ bu aneŋ ŋaclai yêc bu wakôm amlu ŋayham sa, me mba?” Ma iŋlu sêsôm, “Aêc, Pômdau!” ");
INSERT INTO buk_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Goc Yisu kêmasec iŋlu tandô, ma sôm bu, “Tu amlu akêŋ whiŋ aö-ŋga, dec gêŋ naŋ amlu andac, naŋ oc ŋandô sa.” ");
INSERT INTO buk_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ma iŋlu tandô po asê. Goc Yisu gic yao iŋlu bu sêsôm gêŋ dau ŋayom asê têŋ lau daŋ dom. ");
INSERT INTO buk_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Magoc iŋlu sêsa si, ma sêkôm iŋ ndê waê sa e tiapa gêm gameŋ dinaŋ ahuc. ");
INSERT INTO buk_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ŋac sêsa si ma lau ŋatô sêtêŋ Yisu sêmeŋ. Ŋac sêkôc ŋgac daŋ, naŋ ŋalau sac kôm iŋ awha mba. ");
INSERT INTO buk_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yisu soc ŋalau sac sa awê gi su, goc awha mba dau sôm yom asê. Lau daêsam dinaŋ sêseŋ amba ma sêsôm bu, “Yac dalic gêŋ daŋ bocdec yêc Israel dom andô.” ");
INSERT INTO buk_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Magoc lau Palêsai sêsôm bu, “Iŋ kôc ŋaclai yêc ŋalau sac si ŋadau Sadaŋ, dec tiŋ ŋalau sac su.” ");
INSERT INTO buk_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ma Yisu kêsêlêŋ golom-golom malac atu ti sauŋ. Iŋ kêdôhôŋ lau mbo lôm wê-ŋga, ma hoc ŋawaê ŋayham pi Anötö ndê gôliŋ asê. Ma iŋ kôm lau ti gêmbac tidau-tidau hoŋ ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Magoc têŋ ndoc iŋ gêlic lau daêsam naŋ sêŋkuc iŋ, naŋ tawalô ŋac. Ŋahu bu iŋ gêlic ŋac sêtôm domba naŋ si ŋgac yob ŋac-ŋga mba, dec giam pôm sêtê ŋac saliŋ-saliŋ ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Goc iŋ sôm têŋ iŋ ndê ŋgacsêŋomi, “Gêŋ ŋandô daêsam yêc ôm, magoc lau sêndic ŋandô sa-ŋga daêsam dom. ");
INSERT INTO buk_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Bocdinaŋ ateŋ mbec têŋ ôm ŋadau bu êŋkiŋ lau gweleŋ-ŋga sêsôc iŋ ndê ôm ma sêndic gêŋ ŋandô sa.” ");
INSERT INTO buk_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yisu ta iŋ ndê ŋgac-sêŋomi 12 sêtêŋ iŋ si, ma kêŋ ŋaclai têŋ ŋac bu sêsoc ŋalau sac su yêc lau, ma bu sêkôm gêmbac hoŋ ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aposel 12 dau si ŋaê bocdec. Ŋgac ŋamata-ŋga iŋ Saimon naŋ sêsam bu Pita, lu iŋ asi Andru, ma Sebedi ndê atu lu Jems lu Jon, ");
INSERT INTO buk_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","P ilip ma Batolomeas, Tomas ma ŋgac kôc takis-ŋga Matyu, ma Alpayas ndê atu Jems, Tadaus, ");
INSERT INTO buk_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon naŋ sêsam bu ‘Ŋgac †Selot,’ ma Judas Iskeriot naŋ tiŋambu hoc Yisu asê. ");
INSERT INTO buk_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yisu kêkiŋ lau 12 dinaŋ sêsa si bu sênem mêtê, ma gic yomsu ŋac bocdec bu, “Asôc lau apa ti lau †Samaria-ŋga si malac daŋ dom, ");
INSERT INTO buk_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","tigeŋ gêŋ ŋamata-ŋga atêŋ domba Israel-ŋga naŋ siŋga su, naŋ andi. ");
INSERT INTO buk_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Anem mêtê ma asôm têŋ lau bu Anötö ndê gôliŋ meŋ kêpiŋ su. ");
INSERT INTO buk_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Akôm lau gêmbac ŋayham sa, ma akôm lau ti gêmbac leprasi ŋamlic ŋawasi sa. Auŋ lau batê sêtisa, ma asoc ŋalau sac su yêc lau. Anötö kêŋ ŋaclai têŋ mac ŋaôli mba, ma bocdinaŋ anem lau sa ŋambwa. ");
INSERT INTO buk_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Ma têŋ ndoc mac aŋsêlêŋ andi, naŋ gauc nem wapa seŋ-ŋga dom. Aŋsêlêŋ amam sawa, akôc mone dom, ampwic talhi dom, akôc ŋakwê aô daôm-ŋga ti atapa dom, ma ahôc tôc dom. Ŋalêŋ solop bu lau sêlôm lau naŋ sem gweleŋ mêtê-ŋga ma sêpuc ŋac dôŋ ŋa gêŋ dinaŋ, naŋ ti ŋac si ŋaôli ô gweleŋ. ");
INSERT INTO buk_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Malac bocke mac bu asôc andi, naŋ aŋsalê ŋamalac ŋayham naŋ toc Anötö sa ŋapep, bu ambo awhiŋ iŋ e mac ahu malac dau siŋ. ");
INSERT INTO buk_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Têŋ ndoc mac api iŋ ndê andu andi, naŋ anem mbec iŋ ndê lau ŋa mbec yom malô-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ma ŋac lau dau bu lau gitêŋ, goc yom malô oc yêc ŋac. Ma ŋac bu lau gitêŋ dom, goc mac nem mbec yom malô-ŋga oc gacgeŋ yêc mac-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ma lau malac daŋ bu sêkôc mac ti nem yom sa dom, goc ahu malac me andu dinaŋ siŋ ma atoŋ kop su yêc gahim. ");
INSERT INTO buk_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Aö wasôm têŋ mac bu têŋ Anötö ndê bêc êmatôc lau-ŋga, lau malac dinaŋ-ŋga oc sêtap ŋagêyô sac sambuc sa, hôc gêlêc ŋagêyô naŋ iŋ oc kêŋ têŋ lau Sodom ti Gomora-ŋga têŋ têm ŋambu-ŋga, naŋ su.” ");
INSERT INTO buk_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“A ŋgô su naŋ! Aö waŋkiŋ mac asa andi, atôm domba naŋ sêsip giam pôm si gameŋ. Bocdinaŋ akôc gauc ŋapep ma akôm nem gweleŋ, ma akôm mêtê ŋayham eŋ e lau daŋ gitôm dom bu sêpu mac. ");
INSERT INTO buk_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ayob daôm têŋ lau naŋ sêkêŋ whiŋ aö dom, bu ŋac oc sêkêŋ mac atêŋ lau sêmatôc yom-ŋga andi, ma sêhi mac ŋa sö yêc ŋac si lôm wê-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tu mac aŋkuc aö-ŋga dec ŋac oc sêkêŋ mac alhac gôliŋwaga ti kiŋ si aŋgô-ŋga. Ndoc dinaŋ ti mac nem ndoc bu awhê aneŋ yom sa têŋ lau atu-tu dinaŋ, ma têŋ lau akêŋ gameŋ hoŋ, naŋ whiŋ. ");
INSERT INTO buk_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ma têŋ ndoc sêkôc mac dôŋ, naŋ ahêgo daôm dom tu yom asôm-ŋga. Anötö oc nem mac sa tu asôm yom-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ma yom naŋ mac bu asôm, naŋ mac nem yom dom. Damam undambê-ŋga oc kêŋ iŋ ndê Ŋalau puc mac dôŋ, ma hôc nem awham sa. ");
INSERT INTO buk_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Têŋ ndoc ŋawapac-ŋga dinaŋ, lau naŋ sêkêŋ whiŋ dom oc sêhoc si asidôwai sêkêŋ whiŋ aö-ŋga asê bu sêndic ŋac ndu, ma dambai oc sêkôm têŋ atui boc-dinaŋ. Balêkoc oc sêli dau sa têŋ damba ti dindai, ma sêkêŋ ŋac sêtêŋ lau bu sêndic ŋac ndu. ");
INSERT INTO buk_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ma lau sambob oc atac tec mac tu aö-ŋga. Magoc asa naŋ bu lhac ŋaŋga ma hu aö siŋ dom, naŋ oc tap Anötö ndê mwasiŋ nem iŋ si-ŋga sa. ");
INSERT INTO buk_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ma lau bu sêkêŋ kisa mac, goc ahu ŋac si malac siŋ ma atêŋ malac daŋ andi. Yom ŋandô aö wasôm têŋ mac! Mac nem gweleŋ anem mêtê ŋawaê ŋayham-ŋga yêc malac Israel-ŋga hoŋ oc pacndê dom, e Ŋamalac ndê Atu meŋ sa tiawê.” ");
INSERT INTO buk_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Kwapuc daŋ oc hôc gêlêc gwalam akwa naŋ kêdôhôŋ iŋ, naŋ dom. Ma ŋgac akiŋ oc hôc gêlêc iŋ ndê ŋadau dom. ");
INSERT INTO buk_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kwapuc bu tôm ndê gwalam akwa ma ŋgac akiŋ bu tôm ndê ŋadau, goc tôm. Lau sêpu gôlôwac ŋadau aö ma sêsam aö bu †Belsebal, ma bocdinaŋ ŋac oc sêkôm têŋ ŋadau ndê lau mac, hôc gêlêc su.” ");
INSERT INTO buk_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Magoc atöc daôm tu lau naŋ sêkêŋ kisa mac-ŋga dom. Ŋahu bu gêŋ hoŋ naŋ lau sem ahuc, me yêc siŋ dau, naŋ oc meŋ sa tiawê. ");
INSERT INTO buk_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yom naŋ aö gasôm têŋ mac têŋ ôbwêc, naŋ asôm asê têŋ acsalô, ma yom naŋ aö gac yom sec têŋ mac, naŋ asôm tiatu alhac malac lôm. ");
INSERT INTO buk_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Atöc lau naŋ bu sêndic mac ndu-ŋga dom, bu ŋac gitôm dom bu sêseŋ mac gatôm su whiŋ. Atöc lau dom, magoc atöc Anötö ma asôc iŋ ŋapu. Bu mba, goc iŋ gitôm bu kêŋ mac ŋamlic ti gatôm lu-lu sêsip lambwam sêndi e sêniŋga gacgeŋ. ");
INSERT INTO buk_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Akôc gauc pi mbac kecsoc naŋ lau sêlic bu gêŋ ŋambwa. Tigeŋ Anötö gêlic gêŋ sauŋ dinaŋ bu gêŋ ŋambwa dom, ma iŋ bu lôc dom, dec daŋ oc niŋga dom. ");
INSERT INTO buk_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Bocdinaŋ ahêgo daôm dom, bu Anötö tac whiŋ mac hôc gêlêc mbac kecsoc daêsam su. Iŋ kêyalê mac e pi sa, gitôm iŋ sê mac nem kêclauŋ hoŋ sa timala.” ");
INSERT INTO buk_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Asa naŋ sôm asê yêc ŋamalac aŋgô-ŋga bu iŋ kêŋ whiŋ aö, naŋ aö wasôm iŋ ndê ŋaê asê yêc Damaŋ undambê-ŋga aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tigeŋ asa naŋ sêc iŋ ndê kêŋ whiŋ aö-ŋga ahuc yêc ŋamalac aŋgô-ŋga, naŋ wasêc iŋ ahuc yêc Damaŋ aŋgô-ŋga bocdinaŋ.” ");
INSERT INTO buk_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Gauc nem bu aö gameŋ bu wahê wamba lau dom. Mba! Tu aö-ŋga dec lau oc sêwhê dau kôc ma sêkêŋ kisa dau. ");
INSERT INTO buk_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tu aö-ŋga dec damba lu atuŋgac oc sêkêŋ kisa dau, ma dinda lu atuwê, ma lawawê akwa lu lawawê wakuc oc sêkêŋ kisa dau bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ŋgac daŋ oc tap iŋ ndê ŋacyo sa yêc iŋ dau ndê lau. ");
INSERT INTO buk_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Asa naŋ tac whiŋ damba me dinda me atuŋgac me atuwê hôc gêlêc iŋ ndê atac whiŋ aö su, naŋ oc tôm dom bu ti aneŋ daŋ. ");
INSERT INTO buk_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ma asa naŋ tec bu hôc iŋ ndê a gicso dau ma êŋkuc aö, naŋ tôm dom bu ti aneŋ daŋ bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Lau naŋ takwê gêŋ nom-ŋga ŋapaŋ tu puc ŋac si ŋamlic dôŋ-ŋga, naŋ oc sêniŋga. Magoc asa naŋ bu hu gêŋ nom-ŋga siŋ tu aö-ŋga, naŋ oc mbo tali ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Lau naŋ sêkôc mac sa, naŋ gitôm sêkôc aö dauŋ sa, ma ŋac naŋ sêkôc aö sa, naŋ sêkôc Anötö naŋ kêkiŋ aö gameŋ, naŋ sa. ");
INSERT INTO buk_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Asa naŋ toc aneŋ propet daŋ sa, ma kôc iŋ sa tu iŋ ti propet gêm aö aŋôŋ-ŋga, naŋ Anötö oc kêŋ ŋagêyô ŋayham têŋ iŋ gitôm iŋ kêŋ têŋ propet dau. Ma asa naŋ toc ŋamalac gitêŋ daŋ sa, ma kôc iŋ sa tu aneŋ ŋaê-ŋga, naŋ Anötö oc kêŋ ŋagêyô ŋayham têŋ iŋ gitôm iŋ kêŋ têŋ ŋgac gitêŋ dau. ");
INSERT INTO buk_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ma asa naŋ kôm gêŋ sauŋ bocke bu nem lau naŋ sêŋkuc aö, naŋ sa, tôm iŋ kêŋ bu ŋalhuc têŋ ŋac sênôm, naŋ Anötö oc êŋlhiŋ iŋ siŋ dom. Iŋ oc kêŋ ŋagêyô ŋayham têŋ iŋ yomandô.” ");
INSERT INTO buk_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yom hoŋ dinaŋ Yisu sôm têŋ iŋ ndê ŋgacsêŋomi 12 tu êndôhôŋ ŋac-ŋga. Iŋ gic bata yom dau, goc kêsêlêŋ golom-golom malac naŋ sêyêc gameŋ Galili-ŋga dinaŋ, ma gêm mêtê ti kêdôhôŋ lau. ");
INSERT INTO buk_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Têŋ ndoc dinaŋ Jon, Ŋgac Kêku Lau-ŋga ndöc gapocwalô, ma iŋ ŋgô ŋawaê pi gêŋ hoŋ naŋ Kilisi kôm. Bocdinaŋ iŋ kêkiŋ iŋ ndê sêŋomi ŋatô sêtêŋ Yisu si, ");
INSERT INTO buk_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ma sêndac iŋ bocdec bu, “Anötö gic bata têŋ yac bu oc êŋkiŋ Mesaya. Am daôm dinaŋ, me yac oc akêŋ bataŋ ŋgac daŋ tiyham?” ");
INSERT INTO buk_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yisu ô yom ma sôm, “Ambu andi ma asôm yom têŋ Jon pi mêtê naŋ mac aŋgô aö gahoc asê, ma pi gêŋ naŋ mac alic aö gakôm. ");
INSERT INTO buk_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Lau tapec sêlic gameŋ tiyham, lau bôliŋ sêŋsêlêŋ tiyham, lau ti gêmbac leprasi ŋamlic ŋawasi sa, lau daŋgasuŋ bic sêŋgô yom, lau batê sêtisa, ma lau ŋalôm sawa sêŋgô ŋawaê ŋayham. ");
INSERT INTO buk_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","A ŋgô! Lau naŋ atac lu-lu tu aö-ŋga dom, naŋ oc sêtap Anötö ndê mwasiŋ sa.” ");
INSERT INTO buk_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon ndê sêŋomi sêsa si, ma Yisu sôm yom pi Jon têŋ lau toŋ atu naŋ sêmbo sêwhiŋ iŋ. Iŋ ndac ŋac bocdec bu, “Têŋ ndoc mac asa atêŋ Jon yêc gameŋ sawa a, dec gauc gêm bu atap ŋamalac kaiŋ bocke sa? Mac bu alic ŋgac gauc babalê gitôm gakoc naŋ mbu kêwic, a? ");
INSERT INTO buk_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mac asa a bu alic ŋgac daŋ naŋ sôc ŋakwê ŋayham, a? Mba! Lau naŋ sêsôc ŋakwê ŋayham, naŋ sêmbo gameŋ ŋayham gitôm kiŋ si andu. ");
INSERT INTO buk_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Bocdinaŋ aö wandac mac, mac asa a bu alic sake? Bu alic propet daŋ? Yomandô! Iŋ propet daŋ, ma iŋ hôc gêlêc propet hoŋ su. ");
INSERT INTO buk_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Propet akwa daŋ to yom naŋ Anötö sôm têŋ Mesaya bocdec bu, ‘Aö waŋkiŋ aneŋ ŋgac aheŋ-ŋga muŋ am, bu êmasaŋ am nem seŋ.’ Y om pi ŋgac aheŋ-ŋga dau hêganôŋ Jon solop. ");
INSERT INTO buk_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yêc ŋamalac nom-ŋga, daŋ hôc gêlêc Jon, Ŋgac Kêku Lau-ŋga su dom. Tigeŋ aö wasôm yom ŋandô têŋ mac, bu lau hoŋ naŋ sêmbo Anötö ndê gôliŋ ŋapu, lau tiwaê, ma lau waêmba boc-dinaŋ, naŋ hoŋ sêhôc gêlêc Jon su yêc Anötö aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","“Muŋ-ŋga, Moses ti propet akwa-kwa sêhoc yom asê gwanaŋ pi Anötö ndê gôliŋ. Ma ŋac si yom ŋandô sa dom, e Jon meŋ ma gêm mêtê bu Anötö ndê gôliŋ meŋ kêpiŋ. Têŋ ndoc Jon gic hu yom dau e meŋ têŋ kwahic dec, Anötö ndê gôliŋ kêsôwec gi tiatu, ma lau daêsam sêkôm mwasac bu sêsôc Anötö ndê gôliŋ ŋapu. ");
INSERT INTO buk_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Anötö gic bata bu êŋkiŋ propet daŋ muŋ Mesaya, naŋ gitôm propet Elaija. Ma aö wasôm têŋ mac bu yomandô, Jon iŋ propet dau dinaŋ. Mac akêŋ whiŋ yom dinaŋ, me mba? ");
INSERT INTO buk_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mac bu daŋamsuŋ yêc, naŋ aŋgô aneŋ yom! ");
INSERT INTO buk_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Lau têm dindec-ŋga ŋac lau kaiŋ bocke? Ŋac sêtôm balêkoc naŋ sêkôc whê sêmbo malac lôm, naŋ sêtucdiŋ ŋac si silip ŋatô ma sêsôm, ");
INSERT INTO buk_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Têŋ ndoc naŋ yac ac oŋ bu datê wê, naŋ mac atec. Ma têŋ ndoc yac am wê daŋgibo-ŋga, naŋ mac atec bu ataŋ awhiŋ.’ ");
INSERT INTO buk_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ma lau têm dindec-ŋga bocdinaŋ. Jon meŋ ma gêŋ gêŋ ti nôm gêŋ ŋayham dom, ma sêsôm bu ŋalau sac mbo iŋ ndê ŋalôm. ");
INSERT INTO buk_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ma Ŋamalac ndê Atu meŋ nôm ti gêŋ gêŋ ŋayham, tigeŋ sêsôm bu iŋ ŋgac gêŋ gêŋ ti nôm wain ŋawahô-ŋga, ma bu iŋ hê silip têŋ lau sac ti lau sêkôc takis-ŋ ga. Bocdinaŋ, mac lau têm dindec-ŋga atôm balêkoc naŋ sêkôm tô aŋiŋ ŋapaŋ. Tigeŋ Anötö ndê gauc hôc gêlêc gêŋ hoŋ, ma iŋ ndê lau sêŋyalê bu iŋ ndê lêŋ iŋ lêŋ solop.” ");
INSERT INTO buk_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Têŋ dinaŋ Yisu gic hu pu lau naŋ sêndöc malac ŋatô. Ŋahu bu iŋ k ôm gêŋ dalô daêsam yêc ŋac aŋgô-ŋga, tigeŋ ŋac sem si ŋalôm kwi dom. ");
INSERT INTO buk_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Iŋ sôm, “Oyaê mac lau Korasin ti lau Betsaida-ŋga. Mac ac waê bu atap Anötö ndê atac ŋandê sa. Lau apa naŋ sêndöc Taya ma Saidon, naŋ bu sêlic gêŋ dalô naŋ aö gakôm yêc mac aŋôm-ŋga, dec oc tôm sênem dau kwi wandêc su, ma sêndöc ti sêtaŋ si sac. ");
INSERT INTO buk_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tigeŋ mac akôm dom, dec wasôm têŋ mac bu têŋ ndoc Anötö êmatôc lau-ŋga, naŋ iŋ oc kêŋ ŋagêyô sac sambuc têŋ mac, hôc gêlêc ŋagêyô naŋ iŋ oc kêŋ têŋ lau Taya ti Saidon-ŋga, naŋ su. ");
INSERT INTO buk_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Ma mac lau Kapenaom-ŋga. Mac gauc gêm bu Anötö oc kôc mac sa andöc undambê, a? Aö wasôm mba! Iŋ oc êmasuc mac su asip lambwam andi. Lau Sodom bu sêlic gêŋ dalô gitôm mac alic su, dec oc tôm sêhu si sac siŋ ma sêndöc ŋayham e kwahic dec. ");
INSERT INTO buk_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Aö wasôm têŋ mac bu Anötö oc kêŋ ŋagêyô sac têŋ mac, hôc gêlêc ŋagêyô naŋ iŋ oc kêŋ têŋ lau Sodom-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","T êŋ ndoc dinaŋ Yisu teŋ mbec ma sôm, “O Damaŋ, undambê ti nom ŋadau. Aö wampiŋ am bu am tôc nem yom ŋa-ŋandô asê têŋ lau naŋ sêŋgwiniŋ dau, ma siŋ kwi têŋ lau naŋ gauc gêm bu ŋac lau tigauc ma sêŋyalê gêŋ hoŋ. ");
INSERT INTO buk_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aêc, Damaŋ, am kôm bocdinaŋ kêkuc am daôm nem atac whiŋ.” ");
INSERT INTO buk_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Goc Yisu sôm, “Damaŋ kêŋ gêŋ hoŋ sip aö amaŋ. Lau daŋ sêŋyalê Atu dom, Damba tawasê kêyalê iŋ. Ma lau daŋ sêŋyalê Damba dom, tigeŋ iŋ ndê Atu kêyalê iŋ, ma lau naŋ Atu dau atac whiŋ bu tôc iŋ asê têŋ ŋac, naŋ sêŋyalê Damba.” ");
INSERT INTO buk_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Mac lau hoŋ naŋ ahôc ŋawapac ma kwampac, naŋ atêŋ aö ameŋ, ma aö wakêŋ mac asê awham su. ");
INSERT INTO buk_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ameŋ ma akôm aö neŋ gweleŋ awhiŋ aö, ma aö oc wandôhôŋ mac. Aö ŋgac malô ma gatoc dauŋ sa dom, ma mac oc atap malam aŋwhaŋ daôm-ŋga sa yêc aö. ");
INSERT INTO buk_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ŋahu bu gweleŋ naŋ mac akôm awhiŋ aö, naŋ ŋadehe dom, ma aö wakêŋ mac ahôc ŋawapac atu dom.” ");
INSERT INTO buk_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Têŋ têm dinaŋ ŋabêc †Sabat-ŋga daŋ, naŋ Yisu ti ndê ŋgacsêŋomi sêŋsêlêŋ sêmbo lôcwha naŋ gic ôm wit-ŋga daŋ kic. Ma gêŋ yô ŋgacsêŋomi, dec sêkôc wit ŋandô ma seŋ. ");
INSERT INTO buk_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Lau Palêsai ŋatô sêlic, goc sêsôm têŋ iŋ, “Lic su naŋ. Am nem ŋgacsêŋomi sêkôc wit ŋandô ma yomsu gic yao bu dakôm gweleŋ kaiŋ dinaŋ têŋ bêc Sabat-ŋga dom.” ");
INSERT INTO buk_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Goc Yisu ô ŋac si yom ma sôm, “Gauc nem yom naŋ sêto yêc, pi gêŋ naŋ Kiŋ Dawid ti ndê lau sêkôm têŋ ndoc gêŋ yô ŋac. Mac asam su, me? ");
INSERT INTO buk_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dawid sôc Anötö ndê andu gi, ma kôc bolom dabuŋ naŋ lau sêkêŋ ti da, naŋ Moses kêŋ yao bu dabuŋsiga tawasê sêneŋ, ma lau bambaliŋ sêneŋ dom. Ma Dawid ti ndê lau seŋ, magoc lau daŋ sêŋgôliŋ yom pi Dawid ma sêsôm bu iŋ kêgilì yomsu lec dom. ");
INSERT INTO buk_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Ma gêŋ daŋ tiyham, naŋ mac asam su yêc Moses ndê yomsu. Têŋ bêc Sabat-ŋga hoŋ dabuŋsiga sêkôm gweleŋ yêc lôm dabuŋ, ma gweleŋ dinaŋ kêgilì yomsu Sabat-ŋga. Magoc lau sêŋgôliŋ yom pi ŋac dom. ");
INSERT INTO buk_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“A ö wasôm têŋ mac, bu gweleŋ naŋ aö gameŋ tu wakôm-ŋga, naŋ hôc gêlêc sakiŋ lôm dabuŋ-ŋga hoŋ su. ");
INSERT INTO buk_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Sêto Anötö ndê yom yêc bocdec, ‘Gêŋ atu naŋ aö atac whiŋ, naŋ hôc gêlêc mac nem da hoŋ su, naŋ bu mac tamwalô lau.’ Mac aŋyalê yom dau ŋahu dom. Mac bu aŋyalê, dec gitôm dom bu mac aŋgôliŋ yom pi lau naŋ sêkôm gêŋ so daŋ dom. ");
INSERT INTO buk_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Bu Ŋamalac ndê Atu iŋ gêŋ hoŋ ŋadau, ma iŋ Pômdau bêc Sabat-ŋga whiŋ.” ");
INSERT INTO buk_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yisu kêsêlêŋ gi, ma sôc ŋac si lôm wê-ŋga gi. ");
INSERT INTO buk_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ma yêc dinaŋ, ŋgac amba tibalê daŋ ndöc. Lau Palêsai sêŋsalê yom tu sêŋgôliŋ pi Yisu-ŋga, goc sêndac iŋ, “Yac bu dakôm ŋamalac daŋ ŋamlic ŋayham sa têŋ bêc Sabat-ŋga, oc taŋgilì yomsu Sabat-ŋga, me mba?” ");
INSERT INTO buk_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ma Yisu sôm têŋ ŋac, “Mac nem domba daŋ, bu peŋ sip sê ŋalôm têŋ bêc Sabat-ŋga, naŋ mac oc akôm sake? Mac oc akôc sa. ");
INSERT INTO buk_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Aêc! Ma ŋamalac sêhôc gêlêc domba su! Bocdinaŋ yac bu dakôm ŋayham ma danem lau sa têŋ bêc Sabat-ŋga, oc daso yomsu Sabat-ŋga dom.” ");
INSERT INTO buk_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Goc Yisu sôm têŋ ŋgac dau, “Êmatôc amam!” Ma iŋ kêmatôc amba, ma amba dau ŋayham sa tiyham, gitôm iŋ amba daŋga. ");
INSERT INTO buk_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tigeŋ lau Palêsai sêsa si ma sem yomgalôm pi lêŋ sêndic Yisu ndu-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yisu kêyalê lau Palêsai si gauc, goc hu gameŋ dinaŋ siŋ. Lau daêsam sêŋkuc iŋ, ma iŋ kôm ŋac si gêmbac hoŋ ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tigeŋ iŋ gic yao bu sêsôm iŋ ŋahu asê dom. ");
INSERT INTO buk_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ŋalêŋ dinaŋ yom naŋ propet Aisaya sôm pi Mesaya muŋ su, naŋ ŋandô sa. Yom dau sêto yêc bocdec bu: ");
INSERT INTO buk_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Alic aneŋ ŋgac akiŋ dindec, naŋ aö kayaliŋ iŋ sa. Aö atac whiŋ iŋ kêlêc, ma aneŋ ŋalôm tisambuc iŋ. Wakêŋ aneŋ Ŋalau nem iŋ ahuc, ma iŋ oc hoc yom gitêŋ matôc-ŋga asê têŋ lau akêŋ gameŋ nom-ŋga hoŋ. ");
INSERT INTO buk_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Iŋ oc sôm yom tac ŋandê-ŋga me mbwêc ŋaŋga dom. Ma lau daŋ oc sêŋgô iŋ whasuŋ yêc malac lôm dom. ");
INSERT INTO buk_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Gakoc timdec iŋ oc pôŋ dulu dom, ma ya ŋawê naŋ tisauŋ, naŋ iŋ oc yu ndu dom. Ma iŋ oc kôm bocdinaŋ e nditôm iŋ ndê yom gitêŋ matôc-ŋga nem nom sambuc ahuc. ");
INSERT INTO buk_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ma lau akêŋ gameŋ nom-ŋga hoŋ oc sêkêŋ bata bu Anötö nem ŋac si tu iŋ ndê ŋaê-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Têŋ têm dinaŋ lau sêwê ŋgac daŋ naŋ ŋalau sac kôm iŋ tandô t ipec ma awha mba, naŋ sêtêŋ Yisu sêmeŋ. Yisu soc ŋalau sac dinaŋ su, goc kôm ŋgac dau ŋayham sa, ma iŋ gêlic gameŋ ma sôm yom asê. ");
INSERT INTO buk_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Lau hoŋ sêhêdaê tu Yisu-ŋga, ma sêsôm, “Mboe †Dawid ndê Atu iŋ ŋgac dau dec, me?” ");
INSERT INTO buk_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tigeŋ lau Palêsai sêŋgô ŋawaê, dec sêpu Yisu ma sêsôm, “Iŋ kôc ŋaclai yêc ŋalau sac si ŋadau †Belsebal, dec iŋ soc ŋalau sac su.” ");
INSERT INTO buk_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yisu kêyalê ŋac si gauc, ma sôm, “Lau gameŋ daŋ, me malac daŋ, me gôlôwac daŋ, bu sêwhê dau kôc, dec ŋac oc sêlhac ŋaŋga dom, ma ŋac si ŋacyo oc sêku ŋac dulu. ");
INSERT INTO buk_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ma Sadaŋ boc-dinaŋ. Iŋ bu soc dau ndê ŋalau sac su, dec iŋ kêŋ kisa dau, ma iŋ ndê ŋaclai oc niŋga. ");
INSERT INTO buk_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Mac asôm bu aö gakôc ŋaclai yêc Belsebal, dec gasoc ŋalau sac su. Ma bocke? Mac nem sêŋomi naŋ sêsoc ŋalau sac sêwhiŋ, naŋ mac aŋgôliŋ yom dau pi ŋac whiŋ, a? Ŋac oc sêlic mac nem yom bu so ma sêmatôc mac! ");
INSERT INTO buk_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tigeŋ aö gasoc ŋalau sac ŋa Ŋalau Dabuŋ ndê ŋaclai, dec aŋyalê bu Anötö ndê ŋaclai bu nem gôliŋ gêŋ hoŋ, naŋ hôc asê mac su. ");
INSERT INTO buk_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ŋgac daŋ oc sôc ŋgac ti licwalô atu daŋ ndê andu ma êŋgaho iŋ ndê wapa su ŋalêŋ bocke? Gêŋ ŋamata-ŋga iŋ sô ŋgac dau dôŋ, goc kôc iŋ ndê wapa su. Ma Sadaŋ iŋ gitôm ŋgac ti licwalô atu. ");
INSERT INTO buk_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Asa naŋ kalhac whiŋ aö dom, naŋ ti aneŋ ŋacyo. Ma asa naŋ gic lau sa sêtêŋ aö sêmeŋ dom, naŋ soc ŋac su yêc aö. ");
INSERT INTO buk_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tu dinaŋ-ŋga aö wasôm têŋ mac bu ŋamalac naŋ kac ndê ŋalôm kwi ma hu ndê sac siŋ, naŋ Anötö oc suc iŋ ndê sac ti yom sac-sac hoŋ kwi. Tigeŋ yom sac naŋ ŋamalac daŋ bu sôm pi Ŋalau Dabuŋ, naŋ Anötö oc suc kwi dom. ");
INSERT INTO buk_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Asa naŋ bu sôm yom sac pi Ŋamalac ndê Atu, tigeŋ tiŋambu kac ndê ŋalôm kwi, naŋ Anötö oc suc iŋ ndê sac kwi. Magoc asa naŋ bu sôm yom sac pi Ŋalau Dabuŋ, naŋ Anötö oc suc iŋ ndê sac kwi têŋ têm dindec-ŋga dom, ma têŋ têm ŋambu-ŋga dom bocdinaŋ.” ");
INSERT INTO buk_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ma Yisu sôm, “A ŋayham sem ŋandô ŋayham. Ma a sac sem ŋandô sac. Dalic a ŋandô, dec taŋyalê a bu ŋayham me sac. ");
INSERT INTO buk_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mac lau sac atôm mboc ŋatui! Mac atôm bu asôm yom ŋayham daŋ dom! Bu lau sêsôm yom kêkuc gauc ti mêtê naŋ hôc ŋac si ŋalôm ahuc. ");
INSERT INTO buk_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Gauc ti mêtê ŋayham hôc lau ŋayham si ŋalôm ahuc, dec sêsôm yom ŋayham. Ma gauc ti mêtê sac hôc lau sac si ŋalôm ahuc, dec sêsôm yom sac. ");
INSERT INTO buk_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Aö wasôm yom ŋandô têŋ mac. Tiŋambu Anötö oc êmatôc lau pi yom sac ti yom ŋambwa hoŋ naŋ ŋac sêsôm. ");
INSERT INTO buk_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Lau naŋ si yom ŋayham, naŋ iŋ oc sam ŋac bu lau gitêŋ, magoc ŋac naŋ si yom sac, naŋ oc sêtap iŋ ndê matôc sa.” ");
INSERT INTO buk_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Goc lau Palêsai ti kêdôhôŋ-waga yomsu-ŋga ŋatô sêsôm têŋ Yisu, “Kêdôhôŋwaga, yac bu alic am kôm gêŋ dalô atu bu whê nem ŋahu sa.” ");
INSERT INTO buk_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ma Yisu sôm, “Mac lau têm dindec-ŋga, mac lau sac naŋ apuc dômwêm Anötö, ma asa nem lêŋ bambaliŋ gitôm lau mockaiŋ-ŋga. Mac andac bu alic gêŋ dalô, magoc Anötö oc kêŋ gêŋ dalô tigeŋ têŋ mac alic, tôm gêŋ dalô naŋ iŋ kôm pi propet Jona. ");
INSERT INTO buk_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona mbo i atu ŋalôm gitôm acsalô tö ti ôbwêc tö. Ma bocdinaŋ Ŋamalac ndê Atu oc yêc nom ŋalôm nditôm acsalô tö ti ôbwêc tö. ");
INSERT INTO buk_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Têŋ ndoc Jona gêm mêtê lau Ninewa, naŋ sêkac si ŋalôm kwi. Ma ŋgac naŋ hôc gêlêc Jona su dec mbo, tigeŋ mac am daôm kwi dom. Tu dinaŋ-ŋga têŋ bêc matôc-ŋga, lau Ninewa oc sêtisa akêŋ lau batê sêwhiŋ mac lau têm dindec-ŋga, ma ŋac oc sêhoc mac nem sac asê. ");
INSERT INTO buk_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Muŋŋga, Kwin Siba-ŋga kêsêlêŋ seŋ baliŋ bu ŋgô Kiŋ Solomon ndê yom ti gauc atu. Ma kwahic dec ŋgac naŋ hôc gêlêc Solomon su, naŋ mbo dec. Magoc mac akêŋ daŋam iŋ dom. Tu dinaŋ-ŋga, têŋ bêc matôc-ŋga, Kwin dau oc tisa whiŋ mac lau têm dindec-ŋga, ma hoc mac nem sac asê.” ");
INSERT INTO buk_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Têŋ ndoc ŋalau sac daŋ sa yêc ŋamalac daŋ, naŋ gitôm iŋ kêgihi mbo gameŋ sawa ma kêsalê mala êŋwhaŋ dau-ŋga. Tigeŋ têŋ ndoc iŋ tap sa dom, ");
INSERT INTO buk_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","naŋ iŋ oc sôm têŋ dau, ‘Aö wambu wandi wasôc andu naŋ aö gahu siŋ su.’ Ma iŋ oc mbu ndi ma tap sa bu ŋamalac dau ndê ŋalôm yêc ŋambwa, gitôm andu naŋ sêmasaŋ ŋawasi sa. ");
INSERT INTO buk_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Dec iŋ oc sa ndi, wê ŋ alau 7 naŋ sac sambuc sêhôc gêlêc iŋ su, naŋ sêmeŋ, ma hoŋ sêsôc ŋamalac dau ndê ŋalôm sêndi, ma sêmbo dinaŋ. Bocdinaŋ ŋawapac naŋ tap ŋamalac dau sa, naŋ hôc gêlêc ŋawapac ŋamata-ŋga-ŋga su. Ma ŋalêŋ tigeŋ mac lau sac têm dindec-ŋga, oc atap ŋawapac atu sa têŋ têm ŋambu-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Lau daêsam sêmbo andu daŋ sêwhiŋ Yisu têŋ ndoc iŋ sôm yom dinaŋ mbo, ma iŋ dinda ti asii sêmeŋ sêlhac awê, ma bu sêsôm yom têŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Goc ŋamalac daŋ kêŋ ŋawaê têŋ iŋ ma sôm, “Am dinam ti asimi sêlhac awê ma bu sêsôm yom têŋ am.” ");
INSERT INTO buk_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Magoc Yisu ô yom ma sôm, “Aneŋ dinaŋ asa, ma asiŋi ŋac lau asa?” ");
INSERT INTO buk_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Goc iŋ tôc amba têŋ ndê ŋgacsêŋomi, ma sôm, “Aö dinaŋ ti asiŋi dau dindec. ");
INSERT INTO buk_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Bu lau naŋ daŋga wambu Damaŋ undambê-ŋga ndê yom, naŋ ŋac aö asiŋi ti lhuŋwêi ma dinaŋi.” ");
INSERT INTO buk_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Têŋ bêc dinaŋ Yisu hu andu siŋ ma sa gi ndöc Bugictoŋ Galili-ŋga ŋamakê. ");
INSERT INTO buk_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ma lau daêsam sêkac sa sêŋgihi iŋ ahuc e ŋasawa mbasi. Tu dinaŋ-ŋga dec iŋ pi gi ndöc waŋ daŋ naŋ poc kêpiŋ baö. Ma lau hoŋ dinaŋ sêlhac baö. ");
INSERT INTO buk_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Goc Yisu sôm yom gôliŋ daêsam têŋ ŋac. Iŋ sôm yom gôliŋ daŋ bocdec bu, “Ŋgac daŋ sa gi bu êmbalip wit ŋawhê yêc iŋ ndê ôm. ");
INSERT INTO buk_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ma têŋ ndoc iŋ kêbalip gêŋ dau, naŋ ŋatô sêpeŋ sêsip seŋ, dec mbac sêmeŋ ma seŋ su. ");
INSERT INTO buk_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ma ŋawhê ŋatô sêpeŋ sêsip gameŋ hoc-hoc, naŋ nom ŋagec sac hoc ŋahô ŋambwa. Ŋawhê dau sêsip nom ŋalôm gacgeŋ si dom, dec sêpo sêpi sêmeŋ ŋagahô. ");
INSERT INTO buk_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Magoc tiŋambu ac pec ŋagatôm ma gêm bôliŋ. Ŋahu bu nom ŋayham mba tu ŋawakac sip ndi-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ma wit ŋawhê ŋatô sêpeŋ sêsip kwaŋ ti ŋakwa ŋalôm, magoc têŋ ndoc sêpo sêpi sêmeŋ, naŋ kwaŋ pi whiŋ e yaŋ ndu. ");
INSERT INTO buk_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ma ŋatô sêpeŋ sêsip nom ŋayham ma sêpo sêpi ŋayham e sem ŋandô. Ŋatô sem ŋandô 30, ma ŋatô sem 60 ma ŋatô sem ŋandô 100. ");
INSERT INTO buk_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Asa bu daŋgasuŋ yêc, naŋ ŋgô aneŋ yom.” ");
INSERT INTO buk_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tiŋambu Yisu ndê ŋgac-sêŋomi sêtigasuc iŋ ma sêndac, “Tu sake-ŋga am sôm yom têŋ lau ŋa yom gôliŋ?” ");
INSERT INTO buk_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ma iŋ ô yom ma sôm, “Anötö ndê gôliŋ ŋalêŋ ŋahu sip ŋalôm gi. Iŋ kêyaliŋ mac sa bu aŋyalê ŋahu dau, magoc lau naŋ sêkêŋ whiŋ aö dom, naŋ oc tôm dom bu sêŋyalê. ");
INSERT INTO buk_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Asa naŋ kôc Anötö ndê yom sa sip ndê ŋalôm e tidôŋ, naŋ Anötö oc kêŋ gauc têŋ iŋ êŋlêc, e iŋ êŋyalê yom dau timala eŋ. Magoc asa naŋ yom dau tidôŋ iŋ dom, naŋ Anötö oc kôc gêŋ hoŋ su yêc iŋ. ");
INSERT INTO buk_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tu dinaŋ-ŋga aö wasôm yom têŋ lau ŋa yom gôliŋ. Ŋac sêlic gêŋ ŋapaŋ, tigeŋ ŋac si gauc sa dom, ma ŋac sêŋgô yom ŋapaŋ, tigeŋ ŋac sêŋyalê ŋahu dom. ");
INSERT INTO buk_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Yom naŋ propet Aisaya hoc asê muŋ su, naŋ dec ŋandô sa. Yom dau yêc bocdec bu: Ŋac sêŋgô aneŋ yom ŋapaŋ, magoc sêŋyalê ŋahu dom. Ma sêlic gêŋ naŋ aö gakôm naŋ ŋapaŋ, tigeŋ ŋac si gauc sa dom. ");
INSERT INTO buk_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Lau dau si ŋalôm ŋadandi. Ŋac si daŋgasuŋ hôc ahuc, ma ŋac sêpôc si tandô ahuc. Bu bocdinaŋ dom, dec oc tôm bu tandô sêlic ma daŋgasuŋ sêŋgô, ma sêŋyalê aö tidôŋ yêc ŋac si ŋalôm e sênem dau kwi, ma aö wakôm ŋac ŋayham sa.” ");
INSERT INTO buk_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ma Yisu sôm têŋ ŋgacsêŋomi, “Aö wampiŋ mac nem tanôm ti daŋamsuŋ, bu mac alic gêŋ atu-tu naŋ aö gakôm, ti aŋgô aneŋ yom. ");
INSERT INTO buk_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Aö wasôm yom ŋandô têŋ mac bu propet ti lau gitêŋ daêsam naŋ sêmbo muŋ su, naŋ sêkêŋ bata bu sêlic gêŋ naŋ mac alic su, magoc sêlic dom. Ma sêkêŋ bata bu sêŋgô yom naŋ mac aŋgô su, tigeŋ sêŋgô dom.” ");
INSERT INTO buk_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ma Yisu sôm, “Dec akêŋ daŋam ma wawhê yom gôliŋ ŋgac kêbalip wit ŋawhê-ŋga sa. ");
INSERT INTO buk_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Yom pi ŋawhê naŋ sêpeŋ sêsip seŋ, naŋ hêganôŋ lau naŋ sêŋgô yom pi Anötö ndê gôliŋ, magoc sêŋyalê ŋahu dom. Bocdinaŋ Sadaŋ dau meŋ kêgaho yom dau su yêc ŋac si ŋalôm. ");
INSERT INTO buk_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ma yom pi ŋawhê naŋ sêpeŋ sêsip gameŋ hoc-hoc, naŋ hêganôŋ lau naŋ sêŋgô Anötö ndê yom, ma sêkôc sa ŋagahô ma ti atac ŋayham. ");
INSERT INTO buk_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Magoc tôm ŋawhê dinaŋ ŋawakac sip gi dom, naŋ yom dau tidôŋ yêc lau dinaŋ si ŋalôm dom. Sêlhac ŋasawa sauŋ, tigeŋ têŋ ndoc sêtap ŋawapac sa me lau sêkêŋ kisa ŋac tu Anötö ndê yom-ŋga, naŋ sêhu si sêkêŋ whiŋ siŋ ŋagahô eŋ. ");
INSERT INTO buk_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ma yom pi ŋawhê naŋ sêpeŋ sêsip kwaŋ ti ŋakwa ŋalôm, naŋ hêganôŋ lau naŋ sêŋgô Anötö ndê yom, magoc yom dau gêm ŋandô yêc ŋac si ŋalôm dom. Ŋahu bu ŋac sêhêgo dau pi gêŋ nom-ŋga ŋapaŋ, ma sêsa lêŋ atac whiŋ mone-ŋga e gêŋ kaiŋ dinaŋ kôm Anötö ndê yom ahuc. ");
INSERT INTO buk_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma yom pi ŋawhê naŋ sêpeŋ sêsip nom ŋayham ma sem ŋandô 30, me 60, me 100, naŋ hêganôŋ lau naŋ sêŋgô yom ma sêŋyalê ŋahu, ma sem ŋandô daêsam.” ");
INSERT INTO buk_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yisu sôm yom gôliŋ daŋ tiyham bocdec bu, “Aö bu wawhê Anötö ndê gôliŋ sa ŋalêŋ bocdec. Ŋgac daŋ kêbalip wit ŋawhê ŋayham sip ndê ôm. ");
INSERT INTO buk_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Magoc têŋ ndoc lau sêyêc bêc, naŋ iŋ ndê ŋacyo meŋ, ma kêbalip wahô ŋawhê sip ôm dau whiŋ wit ŋawhê ŋayham, goc kölhö gi. ");
INSERT INTO buk_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tiŋambu wit ŋawhê po pi meŋ, ma têŋ ndoc ŋandô sa, naŋ lau sêlic bu wahô pi meŋ whiŋ. ");
INSERT INTO buk_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Goc ôm ŋadau ndê lau akiŋ sêtêŋ iŋ si ma sêsôm, ‘Ŋadau, yac alic bu am kêbalip ŋawhê ŋayham sip nem ôm. Magoc wahô dec meŋ akêŋ nde?’ ");
INSERT INTO buk_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ma iŋ ô yom ma sôm, ‘Ŋacyo daŋ kôm gêŋ dau.’ Ma sêndac iŋ, ‘Am tac whiŋ bu yac asa andi ayê wahô dau sa, me?’ ");
INSERT INTO buk_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ma iŋ sôm, ‘Mba! Bu mboe mac ayê wahô ma apuc wit sa whiŋ. ");
INSERT INTO buk_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Atec lu-lu sêlhac sêwhiŋ dau ma sêtiatu e ndoc sêndic gêŋ ŋandô sa-ŋga. Têŋ dinaŋ aö oc wasôm têŋ lau sêndic gêŋ ŋandô sa-ŋga bu sêndic wahô sa muŋ, goc sêkic dôŋ ma sêkêŋ pi ya ndi. Ma tiŋambu sêndic wit ŋandô sa pi aneŋ andu gêŋ ŋandô-ŋga.’” ");
INSERT INTO buk_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ma iŋ sôm yom gôliŋ daŋ têŋ ŋac bocdec, “Anötö ndê gôliŋ gitôm a soc ŋawhê, naŋ ŋgac daŋ sô sip iŋ ndê ôm. ");
INSERT INTO buk_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ŋawhê dau iŋ gêŋ sauŋ-têc, tigeŋ tiŋambu oc po pi meŋ e ti a atu hôc gêlêc gêŋ ôm-ŋga hoŋ, ma mbac lôlôc-ŋga oc sêmeŋ sêhê si ŋaic yêc ŋasaŋgac.” ");
INSERT INTO buk_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ma iŋ sôm yom gôliŋ daŋ tiyham bocdec, “Anötö ndê gôliŋ gitôm yist, naŋ awhê daŋ kêŋ sip plawa lôŋ atu daŋ ma kêgaluŋ e kôm plawa hoŋ suŋ.” ");
INSERT INTO buk_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yom hoŋ naŋ Yisu sôm têŋ lau toŋ atu dinaŋ, naŋ iŋ sôm ŋa yom gôliŋ ŋambwa. Ma iŋ sôm yom ŋalêŋ daŋ dom. ");
INSERT INTO buk_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ma boc-dinaŋ propet ndê yom bocdec ŋandô sa: Aö wasôm aneŋ yom ŋa yom gôliŋ, ma gêŋ naŋ yêc siŋ dau têŋ têm Anötö kêŋ undambê ti nom e meŋ, naŋ kwahic dec wasôm asê. ");
INSERT INTO buk_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Goc Yisu hu lau hoŋ siŋ ma sôc andu gi. Ma iŋ ndê ŋgacsêŋomi sêtêŋ iŋ si ma sêndac, “Gitôm bu am whê yom gôliŋ wahô-ŋga ŋahu sa têŋ yac?” ");
INSERT INTO buk_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ma Yisu sôm, “Ŋgac naŋ kêbalip ŋawhê ŋayham, naŋ Ŋamalac ndê Atu. ");
INSERT INTO buk_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ma iŋ ndê ôm, naŋ nom sambuc lec. Yom pi ŋawhê ŋayham hêganôŋ lau naŋ sêmbo Anötö ndê gôliŋ ŋapu, ma wahô hêganôŋ ŋalau sac si ŋadau ndê lau. ");
INSERT INTO buk_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ma ŋacyo naŋ kêbalip wahô ŋawhê, naŋ Sadaŋ dau. Ndoc sêndic gêŋ ŋandô sa-ŋga, naŋ tôm bêc ŋambu-ŋga, ma lau sêndic gêŋ ŋandô sa-ŋga, naŋ Anötö ndê aŋela. ");
INSERT INTO buk_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Têŋ bêc ŋambu-ŋga, lau sac oc sêsip ya atu ŋalôm sêndi, ŋalêŋ tigeŋ tôm wahô naŋ lau sic sa ma sêkêŋ pi ya gi. ");
INSERT INTO buk_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ŋamalac ndê Atu oc êŋkiŋ ndê aŋela, ma ŋac oc sêkôc gêŋ lêtôm-ŋga ti lau hoŋ naŋ sêkôm sac, naŋ su yêc Anötö ndê lau. ");
INSERT INTO buk_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ma ŋac oc sêmbaliŋ ŋac sêsip ya atu ŋalôm sêndi, ma ŋac oc sêtaŋ atu ti lhô êŋsiŋ pi dau. ");
INSERT INTO buk_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Têŋ dinaŋ lau gitêŋ si ŋawasi ti ŋawê oc pô gameŋ gitôm ac, yêc ŋac si Damba ndê gameŋ undambê-ŋga. Mac bu daŋamsuŋ yêc, naŋ aŋgô aneŋ yom.” ");
INSERT INTO buk_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Anötö ndê gôliŋ ŋamwasiŋ gitôm awa ŋayham andô daŋ naŋ yêc siŋ dau yêc nom daŋ ŋalôm. Ŋamalac naŋ tap awa dau sa, naŋ oc siŋ kwi tiyham, ma lhö ndi ti atac ŋayham atu ma kêŋ ndê gêŋ hoŋ têŋ lau sênemlhi, goc nemlhi nom dinaŋ bu kôc awa dau sa. ");
INSERT INTO buk_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","“Ma Anötö ndê gôliŋ ŋamwasiŋ gitôm yac ŋapa ŋaôli atu. Ŋgac tidulu gêŋ-ŋga naŋ kêsalê yac ŋapa ŋayham tu êmasaŋ gôlôŋ-ŋga, naŋ bu tap yac ŋapa ŋayham andô dau sa, dec iŋ oc lhö ndi ma kêŋ ndê gêŋ hoŋ têŋ lau sênemlhi, goc nemlhi yac ŋayham dau.” ");
INSERT INTO buk_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","48","“M a yom gôliŋ daŋ tiyham. Ŋalêŋ naŋ Anötö kêgalêm lau sa bu s êmbo iŋ ndê gôliŋ ŋapu, naŋ gitôm wasaŋ naŋ lau sêkêŋ sip gwêc, ma i tidau-tidau sêsip wasaŋ dau si e meŋhu. Goc lau sêhê sa pi baö gi. Ma sêndöc sic ma sêŋyaliŋ i ŋayham-ŋayham sa sip dalu, ma i sac-sac, naŋ sêmbaliŋ siŋga. ");
INSERT INTO buk_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ma ŋalêŋ tigeŋ têŋ bêc ŋambu-ŋga, aŋela oc sêmeŋ ma sêwhê lau sac ti lau gitêŋ kôc. ");
INSERT INTO buk_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ŋac oc sêmbaliŋ lau sac sêsip ya atu ŋalôm sêndi, ma ŋac oc sêtaŋ ti lhô êŋsiŋ pi dau.” ");
INSERT INTO buk_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yisu gic bata yom dinaŋ, goc ndac iŋ ndê ŋgacsêŋomi, “Mac aŋyalê aneŋ yom hoŋ dindec ŋahu, me mba?” Ma sêlôc, “Aêc.” ");
INSERT INTO buk_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Goc iŋ sôm têŋ ŋac, “Kêdôhôŋwaga yomsu-ŋga naŋ sêŋyalê Anötö ndê gôliŋ ŋahu tidôŋ whiŋ, naŋ sêtôm bu sêwhê yom akwa sa têŋ lau, ma yom wakuc whiŋ. Ma bocdinaŋ ŋac sêtôm andu ŋadau daŋ naŋ gic awa daêsam sa, dec tôc awa akwa ti awa wakuc asê têŋ lau.” ");
INSERT INTO buk_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yisu sôm yom gôliŋ hoŋ dinaŋ pacndê, goc hu gameŋ dinaŋ siŋ. ");
INSERT INTO buk_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Iŋ mbu têŋ iŋ ndê malachu gi, ma kêdôhôŋ lau mbo ŋac si lôm wê-ŋga. Dec ŋac sêhêdaê ma sêndac dandi, “Ei! Gauc ŋayham ti ŋaclai bu kôm gêŋ dalô atu-tu, naŋ ŋgac dec tap sa yêc nde? ");
INSERT INTO buk_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Iŋ k apenta ndê atu! Iŋ dinda iŋ Maria, ma iŋ asii Jems, Josep, Saimon, ma Judas. ");
INSERT INTO buk_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ma iŋ ndê lhuwêi sêmbo sêwhiŋ yac. Bocdinaŋ gêŋ hoŋ dindec iŋ kôc sa yêc nde?” ");
INSERT INTO buk_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ma ŋac atac lu-lu tu iŋ-ŋga. Magoc Yisu sôm têŋ ŋac, “Lau hoŋ sêtoc propet daŋ sa, tigeŋ yêc propet dau ndê malachu, iŋ dau ndê lau sêtoc iŋ sa dom.” ");
INSERT INTO buk_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ma tu ŋac sêkêŋ whiŋ iŋ dom-ŋga, dec iŋ kôm gêŋ dalô atu-tu daêsam yêc ŋac si gameŋ dom. ");
INSERT INTO buk_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Têŋ ndoc dinaŋ †Herod, naŋ gêm gôliŋ gameŋ Galili-ŋga, naŋ ŋgô ŋawaê pi Yisu. ");
INSERT INTO buk_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ma iŋ sôm têŋ iŋ ndê lau akiŋ bu, “Ŋgac dê mboe Jon, Ŋgac Kêku Lau-ŋga naŋ tisa akêŋ lau batê-ŋga. Ma tu dinaŋ-ŋga iŋ kôc ŋaclai bu kôm gêŋ dalô atu-tu dinaŋ.” ");
INSERT INTO buk_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Muŋ-ŋga, Herod gêm iŋ ndê asi Pilip ndê awhê Herodias ti ndê awhê, dec Jon sôm têŋ iŋ, “Am kôm gêŋ so sambuc.” Tu dinaŋ-ŋga Herod kêkiŋ ndê lau bu sêkôc Jon dôŋ ma sêkêŋ iŋ ndöc gapocwalô. ");
INSERT INTO buk_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod tac whiŋ bu ndic Jon ndu, tigeŋ iŋ töc lau daêsam naŋ sêlic Jon bu propet daŋ. ");
INSERT INTO buk_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Têŋ ndoc daŋ sêndê mwasiŋ tu Herod ndê bêc dinda kôc iŋ-ŋga, ma Herodias atuwê tê wê yêc mwasiŋ dau ŋalôm. Herod gêlic ma tac ŋayham atu, ");
INSERT INTO buk_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","dec iŋ kêmatiŋ yom têŋ iŋ ma sôm, “Yomandô aö wasôm têŋ am. Gêŋ bocke am bu tac whiŋ naŋ sôm, ma aö oc wakêŋ têŋ am.” ");
INSERT INTO buk_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Goc bawhê dau sa gi gêlic dinda Herodias. Iŋ dinda tec Jon, dec sôm têŋ bawhê bu ndac Herod bocdec bu, “Aö tac whiŋ bu am tim Jon, Ŋgac Kêku Lau-ŋga ndê kachu kic, ma kêŋ iŋ ndê ŋagôlôŋ sip pele daŋ ma kêŋ têŋ aö, bu walic pi tanôŋ bu iŋ mbac ndu ŋandô.” ");
INSERT INTO buk_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Têŋ ndoc Herod ŋgô yom dinaŋ, iŋ ndê ŋalôm ŋawapac atu. Tigeŋ tu iŋ kêmatiŋ yom yêc lau hoŋ aŋgô-ŋga, dec iŋ sôm têŋ iŋ ndê lau siŋ-ŋga bu sêkôm tôm bawhê dau teŋ. ");
INSERT INTO buk_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Iŋ kêkiŋ ŋac sêsôc gapoc-walô si, ma sêtim Jon ndê kachu kic. ");
INSERT INTO buk_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ma sêkêŋ ŋagôlôŋ sip pele daŋ, ma sêkôc sêmeŋ ma sêkêŋ têŋ bawhê. Goc bawhê dau kôc sa gi kêŋ têŋ dinda gêlic. ");
INSERT INTO buk_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tiŋambu Jon ndê sêŋomi sêmeŋ sêkôc iŋ ŋamlaŋ sa ma si sêŋsuhuŋ. Goc sêtêŋ Yisu si ma sic miŋ têŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Têŋ ndoc Yisu ŋgô ŋawaê pi Jon, naŋ iŋ pi waŋ daŋ gi bu pi bugictoŋ ŋadaŋga, ma lhö têŋ gameŋ sawa daŋ ndi ma mbo tawasê. Magoc lau malac-ŋga sêŋgô ŋawaê bu iŋ pi waŋ dau gi, ma daêsam sêwê sêmbo baö ma sêŋkuc iŋ. ");
INSERT INTO buk_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Têŋ ndoc Yisu sôc baö gi, naŋ gêlic lau daêsam dinaŋ ma tawalô ŋac. Ma iŋ kôm ŋac si gêmbac ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Têŋ telha, kêpiŋ bu ac ndi sip, goc ŋgacsêŋomi sêtêŋ iŋ sêmeŋ ma sêsôm, “Gameŋ dec gameŋ sawa, ma ac gi su. Kêŋ lau sêlhö sêtêŋ malac sêndi bu sênemlhi si gêŋ sêneŋ-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Magoc Yisu sôm, “Mba! Oc tôm bu sêneŋ gêŋ yêc dec. Mac daôm akêŋ gêŋ têŋ ŋac sêneŋ.” ");
INSERT INTO buk_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ma sêsôm, “Yac oc akôm ŋalêŋ nde, bu yac mba bolom amaŋdaŋ ma i lu solop dec yêc.” ");
INSERT INTO buk_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Goc iŋ sôm, “Akôc gêŋ dau sa ameŋ.” ");
INSERT INTO buk_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ma iŋ sôm têŋ lau bu sêndöc sic sêndöc kwaŋ. Iŋ kôc bolom amaŋdaŋ ma i lu, tatac undambê goc gêm mbec ma pô bolom kôc-kôc. Ma iŋ kêŋ têŋ ŋgacsêŋomi, ma sic sam têŋ lau. ");
INSERT INTO buk_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ŋac hoŋ seŋ gitôm, ma ŋgac-sêŋomi sic gêŋ ŋadêlê sa sip gatop 12 e meŋhu. ");
INSERT INTO buk_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Lau naŋ seŋ gêŋ dau, naŋ si lauŋgac ŋanamba gitôm 5,000. Ma lauwhê ti balêkoc daêsam sêmbo sêwhiŋ. ");
INSERT INTO buk_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Dinaŋ su, goc Yisu kêkiŋ ndê ŋgacsêŋomi sêpi waŋ bu sêmuŋ iŋ sêmbu sêpi bugictoŋ ŋadaŋga sêndi. Ma iŋ dau gacgeŋ mbo, bu kêŋ lau sêlhö sêndi. ");
INSERT INTO buk_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Sêlhö si su, goc iŋ pi lôc tawasê gi bu teŋ mbec. Ŋasec sa, ma iŋ tawasê mbo. ");
INSERT INTO buk_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Magoc waŋ dau sa awê tibaliŋ gi su, ma mbu ŋadinda gêli bu sa e gic sip waŋ. ");
INSERT INTO buk_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Têŋ ôbwêc lôm, Yisu kêsêlêŋ mbo bu ŋahô têŋ ŋac gi. ");
INSERT INTO buk_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Magoc têŋ ndoc ŋgacsêŋomi sêlic iŋ kêsêlêŋ mbo bu ŋahô, naŋ sêtöc dau ti sêmbwêc, ma sêsôm, “Êê! Ŋalau daŋ!” ");
INSERT INTO buk_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Goc Yisu sôm têŋ ŋac, “Atöc daôm dom! Ŋalôm pêŋ dôŋ, bu aö dauŋ dec.” ");
INSERT INTO buk_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Goc Pita sôm, “Pômdau, bu am daôm dinaŋ, naŋ goc sôm aö waŋsêlêŋ wambo bu ŋahô watêŋ am waloc.” ");
INSERT INTO buk_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ma Yisu sôm, “Mweŋ!” Goc Pita sip yêc waŋ, ma kêsêlêŋ mbo bu ŋahô têŋ iŋ gi. ");
INSERT INTO buk_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Magoc mbu ŋadinda kôm iŋ töc dau atu ma iŋ kwê bu soloŋ tigeŋ. Goc iŋ mbwêc, “Pômdau, nem aö sa!” ");
INSERT INTO buk_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ŋagahô Yisu kêmatôc amba gi, hê iŋ sa ma sôm, “O am ŋgac kêŋ whiŋ babalê-ŋga. Bocke ma am atac lu-lu tu aneŋ ŋaclai-ŋga?” ");
INSERT INTO buk_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Goc iŋlu sêpi waŋ si, ma mbu timalô. ");
INSERT INTO buk_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ma ŋgacsêŋomi naŋ sêndöc waŋ sêpôŋ haduc ma sêmpiŋ iŋ ma sêsôm, “Yomandô, am Anötö ndê Atu!” ");
INSERT INTO buk_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Sêlac waŋ si e sêsôc baö yêc malac Genesaret. ");
INSERT INTO buk_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma têŋ ndoc lau malac-ŋga sêlic bu Yisu meŋ, naŋ sêkêŋ ŋawaê têŋ gameŋ ŋamakê-ŋga hoŋ, ma lau sêkôc si lau gêmbac hoŋ sa sêtêŋ iŋ sêmeŋ. ");
INSERT INTO buk_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ŋac sêteŋ bu sêmasec iŋ ndê ŋakwê ŋadali ŋambwa, ma lau hoŋ naŋ sêmasec iŋ, naŋ ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Têŋ dinaŋ lau Palêsai ti kêdôhôŋwaga yomsu-ŋga ŋatô sêmeŋ akêŋ Jerusalem sêtêŋ Yisu si, ma sêndac iŋ, ");
INSERT INTO buk_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Tu sake-ŋga am nem ŋgacsêŋomi sêkôm ŋagôliŋ naŋ lau andô sic dulu têŋ yac, naŋ popoc? Têŋ ndoc sêneŋ gêŋ, naŋ sêŋgwasiŋ amba muŋ su dom.” ");
INSERT INTO buk_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ma Yisu ô ŋac si yom bocdec bu, “Ma bocke? Tu sake-ŋga mac atoc lau andô si ŋagôliŋ sa ma akôm Anötö ndê yomsu popoc? ");
INSERT INTO buk_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Anötö dau sôm, ‘Toc damam lu dinam sa,’ ma iŋ sôm tiyham bu, ‘Asa naŋ sôm yom sac pi iŋ damba me dinda, naŋ oc sêndic iŋ ndu.’ ");
INSERT INTO buk_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tigeŋ mac aŋkuc yomsu dau dom. Ŋgac daŋ ndê awa me gêŋ bu yêc bu nem damba lu dinda sa, magoc iŋ sôm têŋ iŋlu, ‘Oc tôm dom bu wanem amlu sa, bu gêŋ dindec aö wakêŋ ti da têŋ Anötö,’ ");
INSERT INTO buk_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","goc mac alic ŋayham bu iŋ toc damba sa dom. Bocdinaŋ mac aseŋ Anötö ndê yom naŋ sôm bu atoc damam lu dinam sa, naŋ popoc, tu bu aŋkuc lau andô si ŋagôliŋ. ");
INSERT INTO buk_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mac lau atim yom lau-ŋga! Yom naŋ propet Aisaya hoc asê muŋ su, naŋ hêganôŋ mac solop. Iŋ sôm bu, ");
INSERT INTO buk_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Lau dindec sêtoc aö sa ŋa whasuŋ ŋambwa, tigeŋ ŋac si ŋalôm yêc daŋ dau-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ŋac sem akiŋ aö ŋandô dom, ma yom naŋ sêndôhôŋ têŋ lau, naŋ ŋamalac si yomsu ŋambwa.’ ” ");
INSERT INTO buk_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Goc Yisu ta lau hoŋ ma sôm, “Aŋgô ma aŋyalê ŋapep. ");
INSERT INTO buk_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Gêŋ daneŋ-ŋga naŋ sip ŋamalac whasuŋ, naŋ kôm ŋac ŋadômbwi sa yêc Anötö aŋgô-ŋga dom. Tigeŋ yom naŋ sa akêŋ ŋamalac whasuŋ, naŋ kôm ŋac ŋadômbwi sa.” ");
INSERT INTO buk_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Têŋ dinaŋ Yisu ndê ŋgacsêŋomi sêtigasuc iŋ ma sêsôm têŋ iŋ, “Lau Palêsai sêŋgô am nem yom dinaŋ, dec kôm ŋac sêlic sac. Am kêyalê, me mba?” ");
INSERT INTO buk_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Goc iŋ sôm têŋ ŋac, “Ahêgo daôm tu ŋac-ŋga dom! Atec ŋac. Lau hoŋ naŋ daŋga wambu Damaŋ undambê-ŋga ndê yom dom, naŋ sêtôm wahô naŋ iŋ oc puc sa ti ŋawakac. Ŋac bu sêtôc seŋ têŋ lau ŋatô, magoc ŋac tandô pec. Ma ŋgac tapec daŋ bu wê tapec daŋ, iŋlu lu-lu oc sêpeŋ sêsip sê.” ");
INSERT INTO buk_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Dec Pita sôm, “Gitôm bu am whê yom gôliŋ dinaŋ ŋahu sa têŋ yac?” ");
INSERT INTO buk_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Goc Yisu ndac, “Ma bocke? Têŋ nde mac oc aŋyalê? ");
INSERT INTO buk_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Alic! Gêŋ naŋ sip ŋamalac whasuŋ, naŋ sip iŋ ŋatac ŋalôm gi, ma tiŋambu sa meŋ tiyham. ");
INSERT INTO buk_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tigeŋ yom sac naŋ sa ŋamalac whasuŋ, naŋ sa akêŋ iŋ ndê ŋalôm, ma sac naŋ yêc ŋamalac ŋalôm, dec kôm iŋ ŋadômbwi sa yêc Anötö aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Gauc sac, mêtê sêndic ŋamalac ndu-ŋga, mêtê mockaiŋ-ŋga naŋ lau naŋ sem dau sa su, ma lau naŋ sem dau sa su dom, naŋ sêkôm, mêtê sênem kaŋ gêŋ-ŋga, yom tasaŋ, ma yom sêpu lau-ŋga, ");
INSERT INTO buk_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","naŋ yêc ŋamalac ŋalôm, naŋ kôm ŋac ŋadômbwi sa. Tigeŋ yac bu taŋgwasiŋ amaŋ dom ma daneŋ gêŋ, dec oc kôm yac ŋadômbwi sa yêc Anötö aŋgô-ŋga dom.” ");
INSERT INTO buk_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yisu hu malac dinaŋ siŋ, ma iŋ ti ndê ŋgacsêŋomi sêtêŋ malac Taya ma Saidon ŋagameŋ ŋamakê-ŋga si. ");
INSERT INTO buk_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ma awhê Kanan-ŋga daŋ, naŋ ndöc gameŋ dinaŋ, naŋ têŋ iŋ meŋ ma mbwêc, “O Pômdau, †Dawid ndê Atu, tamwalô aö. Ŋalau sac kêŋ ŋawapac atu têŋ aö atuŋwê, ma kôm iŋ tisac.” ");
INSERT INTO buk_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yisu gêm dôŋ ma ô yom daŋ dom, goc ŋgacsêŋomi sêtigasuc iŋ ma sêsôm, “Kêŋ iŋ lhö ndi, bu iŋ kêkuc yac ma mbwêc yom ŋapaŋ.” ");
INSERT INTO buk_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ma iŋ sôm, “Awhê dau iŋ awhê Israel-ŋga dom. Anötö kêkiŋ aö bu wanem lau Israel-ŋga sa, bu ŋac sêtôm domba naŋ siŋga su.” ");
INSERT INTO buk_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Têŋ dinaŋ awhê dau meŋ pôŋ haduc têŋ iŋ ma ndac tiyham, “Pômdau, nem aö sa.” ");
INSERT INTO buk_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ma Yisu sôm, “Solop dom bu dakôc balêkoc si gêŋ daneŋ-ŋga su ma tambaliŋ têŋ giam sêneŋ.” ");
INSERT INTO buk_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Magoc awhê dau ô yom ma sôm, “Aêc Pômdau, tigeŋ giam naŋ sêndöc ŋadau ndê tebo ŋapu, naŋ seŋ gêŋ ŋapopoc naŋ peŋ yêc tebo.” ");
INSERT INTO buk_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yisu ŋgô yom dinaŋ ma sôm, “O awhê, am kêŋ whiŋ ŋaŋga. Aö oc wakôm tôm am ndac.” Ma têŋ acgatu ŋasawa dau dinaŋ, awhê dau ndê atuwê ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yisu kölhö gi ma kêsêlêŋ whiŋ ndê ŋgacsêŋomi mbo Bugictoŋ Galili-ŋga ŋamakê. Goc iŋ pi lôc daŋ gi ma ndöc sic. ");
INSERT INTO buk_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ma lau daêsam sêwê sêtêŋ iŋ sêmeŋ. Ŋac sêkôc lau gahi sac, lau tapec, l au bôliŋ, awha mba, ti lau gêmbac daêsam, ma sêkêŋ ŋac sêyêc Yisu aŋgô-ŋga. Ma iŋ kôm ŋac hoŋ ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Têŋ ndoc lau sêlic awha mba sêsôm yom asê, ma lau gahi sac ti lau bôliŋ sêŋsêlêŋ tiyham, ma tapec si tandô ŋawa sa, naŋ sêhêdaê ŋandô. Ma sêmpiŋ Anötö Israel-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yisu ta iŋ ndê ŋgacsêŋomi sêmeŋ, goc sôm têŋ ŋac, “Aö taŋwalô lau dindec, bu sêmbo sêwhiŋ aö gitôm bêc tö su. Ŋac si gêŋ daneŋ-ŋga pacndê, ma aö gatec bu wakêŋ ŋac sêlhö sêndi ti gêŋ yô ŋac, mbo ŋac tagôlô yêc seŋ.” ");
INSERT INTO buk_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Magoc ŋgac-sêŋomi sêsôm, “Bocke? Gameŋ dec gameŋ sawa, ma danemlhi bolom yêc nde, bu dakêŋ têŋ ŋac sêneŋ?” ");
INSERT INTO buk_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ma Yisu ndac, “Mac nem bolom hiŋga ndöc?” Ma sêsôm, “Bolom 7 ma i mwambwa ŋatô.” ");
INSERT INTO buk_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Goc Yisu sôm têŋ lau bu sêndöc sic. ");
INSERT INTO buk_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Dec iŋ k ôc bolom 7 ma i sa ma gêm daŋge, p ô kôc-kôc, ma kêŋ têŋ ŋgacsêŋomi, ma ŋac sic sam têŋ lau. ");
INSERT INTO buk_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ŋac hoŋ seŋ e gitôm, ma tiŋambu ŋgac-sêŋomi sic gêŋ ŋadêlê sa sip gatop 7 e meŋhu. ");
INSERT INTO buk_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Lau daêsam seŋ gêŋ dinaŋ e gitôm. Ŋac si lauŋgac ŋanamba gitôm 4,000, ma lauwhê ti balêkoc sêmbo sêwhiŋ. ");
INSERT INTO buk_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tiŋambu Yisu kêŋ lau hoŋ sêlhö si, goc iŋ ti ndê ŋgacsêŋomi sêpi waŋ daŋ ma sêtêŋ malac Magadan ŋagameŋ si. ");
INSERT INTO buk_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Lau Palêsai ti lau Sadiusi ŋatô sêtêŋ Yisu sêmeŋ bu sêŋsahê iŋ. Ŋac sêndac iŋ bu kôm gêŋ dalô bu tôc asê bu iŋ kôc ŋaclai yêc Anötö ndê. ");
INSERT INTO buk_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Dec iŋ sôm, “Mac bu alic umboŋ tikoc, goc mac asôm bu ‘Ac oc pi ŋayham.’ ");
INSERT INTO buk_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma mac bu alic umboŋ tiyec, goc mac asôm, ‘U oc ndic.’ Mac alic gêŋ dalô umboŋ-ŋga dinaŋ, ma aŋyalê ŋahu. Ma bocke dec mac aŋyalê gêŋ dalô daêsam naŋ aö gakôm têŋ ŋasawa dindec, naŋ ŋahu dom? ");
INSERT INTO buk_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mac lau sac naŋ apuc dômwêm Anötö, ma asa nem lêŋ bambaliŋ gitôm lau mockaiŋ-ŋga. Mac aŋsalê gêŋ dalô, tigeŋ Anötö oc kêŋ gêŋ dalô tigeŋ têŋ mac alic, gitôm gêŋ dalô naŋ iŋ kôm pi Jona.” Yisu sôm yom dinaŋ su, goc hu ŋac siŋ ma kölhö gi. ");
INSERT INTO buk_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Têŋ ndoc Yisu ti ŋgacsêŋomi sêmbu akêŋ bugictoŋ ŋadaŋga sêmeŋ, naŋ ŋgacsêŋomi sêkôc bolom dom, sêŋlhiŋ dau siŋ. ");
INSERT INTO buk_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ma Yisu sôm têŋ ŋac, “Ayob daôm ŋapep tu lau Palêsai ti lau Sadiusi si yist.” ");
INSERT INTO buk_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Goc ŋac sem yomgalôm sêwhiŋ dandi ma sêsôm, “Iŋ sôm yom dinaŋ ŋahu bu yac dakôc bolom dom.” ");
INSERT INTO buk_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Magoc Yisu kêyalê ŋac si yom dau, dec sôm, “O mac lau naŋ akêŋ whiŋ gwalec! Tu sake-ŋga mac am yomgalôm awhiŋ daôm, ma gauc gêm bu aö gasôm yom pi yist, ŋahu bu mac nem bolom mba? ");
INSERT INTO buk_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Bocke mac nem gauc sa pi gêŋ hoŋ naŋ aö gakôm, naŋ dom? Gauc nem bolom amaŋdaŋ naŋ gakêŋ têŋ lau 5,000 seŋ. Tiŋambu mac ahoŋ ŋadêlê sa sip gatop hiŋga? ");
INSERT INTO buk_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ma têŋ ndoc lau 4,000 seŋ bolom amaŋdaŋ ŋandôlu, naŋ ŋadêlê sip gatop hiŋga? ");
INSERT INTO buk_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Aö gasôm yom pi bolom kaiŋ dinaŋ dom, ma bocke dec mac aŋyalê aneŋ yom ŋahu dom? Ayob daôm ŋapep pi lau Sadiusi ti lau Palêsai si yist.” ");
INSERT INTO buk_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Têŋ dinaŋ ŋac si gauc sa. Ma sêŋyalê bu iŋ ndê yom hêganôŋ yist bolom-ŋga dom. Sêŋyalê bu iŋ kêŋ puc ŋac bu sêyob dau pi yom naŋ lau Sadiusi ti lau Palêsai sêndôhôŋ têŋ lau. ");
INSERT INTO buk_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yisu ti ndê ŋgacsêŋomi sêhôc asê gameŋ naŋ sêsam bu Sisaria Pilipai, ma iŋ ndac ŋac, “Lau sêsôm sake pi Ŋamalac ndê Atu? Sêsôm bu iŋ asa?” ");
INSERT INTO buk_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ma sêsôm, “Lau ŋatô sêsôm bu am Jon, Ŋgac Kêku Lau-ŋga, ma ŋatô sêsôm bu am Elaija, ma ŋatô sêsôm bu am Jeremaya me propet akwa-kwa si daŋ.” ");
INSERT INTO buk_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Goc Yisu ndac ŋac, “Ma mac daôm, mac asôm bu aö asa?” ");
INSERT INTO buk_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ma Saimon Pita ô yom ma sôm, “Am Mesaya, Anötö Tali Ŋadau ndê Atu am.” ");
INSERT INTO buk_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Dec Yisu sôm, “O Saimon, Jona ndê atu, aö awhaŋ hôc am, bu ŋamalac daŋ hoc yom dau asê têŋ am dom. Damaŋ undambê-ŋga kêŋ gauc dinaŋ têŋ am. ");
INSERT INTO buk_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Aö wasôm têŋ am, bu am Pita, ma aö wandic aneŋ gôlôwac dabuŋ sa sêlhac hoc dau ŋahô. Ma ŋaclai lambwam-ŋga gitôm dom bu ku ŋac dulu. ");
INSERT INTO buk_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ma aö wakêŋ ki têŋ am bu yob gatam lau sêsôc Anötö ndê gôliŋ ŋapu-ŋga. Ma gêŋ bocke naŋ am bu êmbwala su yêc nom, naŋ wambwala su yêc undambê. Ma gêŋ bocke naŋ am bu sô dôŋ yêc nom, naŋ wasô dôŋ yêc undambê bocdinaŋ.” ");
INSERT INTO buk_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yisu sôm yom dinaŋ su, goc gic yao iŋ ndê ŋgacsêŋomi ti ŋaŋga, bu sêsôm asê têŋ lau bu iŋ Mesaya dau dom. ");
INSERT INTO buk_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Têŋ têm dinaŋ Yisu gic hu sôm yom têŋ ndê ŋgacsêŋomi, pi gêŋ naŋ oc hôc asê iŋ. Iŋ whê sa bu iŋ gic waê bu têŋ Jerusalem ndi, ma lau bata Israel-ŋga ti dabuŋsiga atu-tu, ma kêdôhôŋwaga yomsu-ŋga oc sêkêŋ ŋawapac daêsam têŋ iŋ e lau sêndic iŋ ndu. Ma têŋ bêc titö-ŋga Anötö oc uŋ iŋ sa mbo tali tiyham. ");
INSERT INTO buk_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Goc Pita kôc iŋ sa ŋasawa sauŋ gi, ma sôm iŋ bocdec bu, “Pômdau, mba! Tu Anötö-ŋga, oc mba! Gêŋ dinaŋ oc tap am sa dom andô!” ");
INSERT INTO buk_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yisu kac dau kwi ma sôm têŋ Pita, “Sadaŋ, kôc daôm sa lhö su! Am gauc gêm bu lhac aö ahuc, a? Am kêyalê Anötö ndê lêŋ dom, am bu êmkuc ŋamalac si gauc ŋambwa.” ");
INSERT INTO buk_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Goc iŋ sôm têŋ iŋ ndê ŋgac-sêŋomi, “Asa naŋ tac whiŋ bu êŋkuc aö, naŋ êŋgwiniŋ dau ma hôc ndê a gicso dau sa, ma êŋkuc aö. ");
INSERT INTO buk_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Bu asa naŋ tac whiŋ bu sap gêŋ nom-ŋga dôŋ ŋapaŋ tu mbo tali-ŋga, naŋ oc niŋga. Magoc asa naŋ bu hu gêŋ nom-ŋga siŋ tu êŋkuc aö-ŋga, naŋ oc niŋga dom. ");
INSERT INTO buk_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ŋamalac daŋ bu po gêŋ nom-ŋga hoŋ sa, magoc iŋ dau gatu bu niŋga, dec gêŋ nom-ŋga hoŋ dinaŋ oc tôm dom bu nem iŋ sa. Gêŋ ŋayham bocke yêc, naŋ gitôm bu dakêŋ têŋ Anötö ô yac neŋ gatuŋ? ");
INSERT INTO buk_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tiŋambu Ŋamalac ndê Atu oc mbu meŋ ti Damba ndê ŋaclai ti ŋawasi undambê-ŋga, ma whiŋ aŋela hoŋ. Têŋ dinaŋ iŋ oc kêŋ ŋagêyô têŋ ŋamalac hoŋ tôm ndi, êŋkuc mêtê naŋ ŋac sêkôm. ");
INSERT INTO buk_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Aö wasôm yom ŋandô têŋ mac! Lau ŋatô naŋ sêlhac dec, naŋ oc gacgeŋ sêmbo tali e sêlic Ŋamalac ndê Atu meŋ ti ndê ŋaclai nem gôliŋ-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Bêc 6 giŋga su, goc Yisu kôc Pita, ma Jems lu asi Jon sêwhiŋ iŋ, ma ŋac tawasê sêpi lôc baliŋ daŋ si. ");
INSERT INTO buk_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yêc dindê sêlic Yisu ndê ŋamlic kaiŋ daŋ sa. Iŋ aŋgô andô ŋawê sa gitôm ac pô gameŋ, ma iŋ ndê ŋakwê ŋawasi sêp sambuc. ");
INSERT INTO buk_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ma sêlic Moses lu Elaija sêhoc dau asê ma iŋlu sem yomgalôm sêwhiŋ Yisu. ");
INSERT INTO buk_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Goc Pita sôm têŋ Yisu, “Pômdau, ŋayham kêlêc bu dambo dec. Am bu tac whiŋ, goc aö wakwê bac tö bu mac ambo-ŋga, am nem bac daŋ, Moses ndê daŋ, ma Elaija ndê bac daŋ.” ");
INSERT INTO buk_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Iŋ sôm yom dau mbo, ma dao ti ŋawê atu daŋ sip meŋ ma kêgatöc ŋac ahuc. Ma awha daŋ sa yêc dao ŋalôm, naŋ sôm, “Aö neŋ atuŋgac dau dindec. Aö gatisambuc iŋ, ma atac whiŋ iŋ ndu andô. Aŋgô iŋ ndê yom maŋ!” ");
INSERT INTO buk_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Têŋ ndoc ŋgac-sêŋomi tö sêŋgô awha dinaŋ, naŋ sêtöc dau ŋalêŋ sac, ma sêhu dau aŋgô andô sip nom. ");
INSERT INTO buk_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Magoc Yisu têŋ ŋac gi, kêmasec ŋac ma sôm, “Atisa ma atöc daôm dom.” ");
INSERT INTO buk_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ma sêhôc tandô sa ma sêlic bu Yisu tawasê mbo. ");
INSERT INTO buk_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tiŋambu ŋac sêsip akêŋ lôc dau sêmeŋ, ma Yisu kêŋ yao ŋac bocdec bu, “Andic miŋ pi gêŋ naŋ mac alic naŋ dom, e Ŋamalac ndê Atu tisa akêŋ lau batê-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ma ŋgacsêŋomi tö dinaŋ sêndac iŋ bocdec bu, “Lau †Skraib naŋ sêndôhôŋ yomsu, naŋ sêsôm bu Elaija oc meŋ hôc asê muŋ, ma tiŋambu Mesaya oc meŋ. Yom dau ŋahu bocke?” ");
INSERT INTO buk_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Goc Yisu ô yom ma sôm, “Elaija gic waê bu meŋ ma êmasaŋ gêŋ hoŋ tisolop. ");
INSERT INTO buk_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma aö wasôm têŋ mac, bu Elaija meŋ su, tigeŋ lau sêŋyalê iŋ dom. Ma sêkôm mêtê sac têŋ iŋ tôm ŋac atac whiŋ. Ma ŋalêŋ tigeŋ Ŋamalac ndê Atu oc sip ŋac si amba, ma sêkêŋ ŋandê atu têŋ iŋ.” ");
INSERT INTO buk_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Têŋ dinaŋ ŋac si gauc sa bu Yisu ndê yom pi Elaija hêganôŋ Jon, Ŋgac Kêku Lau-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Têŋ têm ŋac sêmbu sêmeŋ, naŋ sêtap lau toŋ atu sa, ma ŋgac daŋ têŋ Yisu gi ma pôŋ haduc. ");
INSERT INTO buk_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ma iŋ sôm, “Pômdau, tamwalô aneŋ balê ma nem iŋ sa. Iŋ hôc ŋawapac atu daŋ, ma ndoc daêsam kôm iŋ titoŋ e peŋ sip ya me bu. ");
INSERT INTO buk_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aö gakôc iŋ gatêŋ nem ŋgac-sêŋomi ga, magoc ŋac sêtôm dom bu sêkôm iŋ ŋayham sa.” ");
INSERT INTO buk_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ma Yisu sôm, “O mac lau sac! Aö gambo gawhiŋ mac ŋasawa hic baliŋ su, ma bocke mac atôm dom bu akôm gêŋ daŋ? Aö wambo wawhiŋ mac tu wanem mac sa-ŋga ŋapaŋ dom! Mac nem akêŋ whiŋ mbasi. Akôc balê dau sa ameŋ.” ");
INSERT INTO buk_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Goc Yisu hec yom ŋalau sac naŋ mbo balê dau ŋalôm, ma soc iŋ sa awê gi, ma ŋagahô eŋ balê dau ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tiŋambu ŋgacsêŋomi sêtêŋ Yisu si, ma sêndac iŋ gelec, “Tu sake-ŋga yac atôm dom bu aseŋ ŋalau sac dinaŋ su?” ");
INSERT INTO buk_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ma iŋ ô yom ma sôm, “Mac atôm dom, bu mac akêŋ whiŋ Anötö ndê ŋaclai gitôm dom. Yomandô aö wasôm têŋ mac, bu mac nem akêŋ whiŋ bu nditôm gêŋ sauŋ andô daŋ, tôm soc ŋamatu sauŋ, dec oc tôm bu mac asôm têŋ lôc daŋ bu puc dau sa ma têŋ gameŋ wakuc ndi, goc lôc dau oc ndi. Akêŋ whiŋ, ma mac oc atôm bu akôm gêŋ hoŋ.  ");
INSERT INTO buk_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Yac bu dasoc ŋalau sac kaiŋ dinaŋ su, goc gêŋ ŋamata-ŋga dahu gêŋ daneŋ-ŋga siŋ tu gauc nem Anötö-ŋga, ma dateŋ mbec ŋaŋga.” ");
INSERT INTO buk_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tiŋambu Yisu ndê ŋgac-sêŋomi sêkac dau sa yêc gameŋ Galili-ŋga, ma iŋ sôm têŋ ŋac, “Tiŋambu oc sêkêŋ Ŋamalac ndê Atu sip lau ŋatô amba. ");
INSERT INTO buk_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ŋac oc sêndic iŋ ndu, magoc têŋ bêc titö-ŋga Anötö oc uŋ iŋ sa mbo tali tiyham.” Yisu ndê yom dinaŋ kôm ŋgacsêŋomi si ŋalôm ŋawapac ŋandô. ");
INSERT INTO buk_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tiŋambu Yisu ti ndê ŋgac-sêŋomi sêhôc asê malac Kapenaom, ma lau naŋ sêkôc takis lôm dabuŋ-ŋga, naŋ sêtêŋ Pita si ma sêndac iŋ bocdec bu, “Bocke? Mac nem kêdôhôŋwaga oc kêŋ mone nemlhi takis lôm dabuŋ-ŋga, me mba?” ");
INSERT INTO buk_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ma Pita sôm, “Heceŋ, iŋ oc nemlhi.” Têŋ ndoc Pita sôc andu gi, naŋ iŋ gic miŋ yom dau têŋ Yisu dom, magoc Yisu dau ndac iŋ, “Saimon, am gauc gêm sake? Kiŋ nom-ŋga sêkôc takis yêc lau asa? Sêkôc yêc ŋac dau si atui, me sêkôc yêc lau ŋatô?” ");
INSERT INTO buk_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Goc Pita ô yom ma sôm, “Ŋac sêkôc takis yêc lau ŋatô.” Ma Yisu sôm, “Bocdinaŋ yomsu takis-ŋga hêganôŋ Kiŋ ndê atui dom. ");
INSERT INTO buk_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tigeŋ yham dom bu ŋac sêlic yac sac. Bocdinaŋ sa ndi ma kêŋ gam yêc bugictoŋ. Ma i ŋamata-ŋga naŋ am hê sa, naŋ kac i dau whasuŋ sa, ma am oc tap mone sa gitôm bu nemlhi hêclu neŋ takis lôm dabuŋ-ŋga. Kôc sa, ma kêŋ têŋ ŋac.” ");
INSERT INTO buk_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Têŋ ndoc dinaŋ ŋgac-sêŋomi sêtêŋ Yisu si, ma sêndac iŋ bocdec bu, “Lau naŋ sêmbo Anötö ndê gôliŋ ŋapu, naŋ si asa ti ŋamalac ŋamata-ŋga?” ");
INSERT INTO buk_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Goc Yisu ta balêkoc sauŋ daŋ meŋ, ma kêŋ iŋ kalhac ŋac ŋalhu. ");
INSERT INTO buk_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ma iŋ sôm, “Anem daôm kwi ma aŋgwiniŋ daôm e atôm balêkoc sauŋ. Bu mba, naŋ wasôm yom ŋandô têŋ mac bu mac atôm dom bu asôc Anötö ndê gôliŋ ŋapu. ");
INSERT INTO buk_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Asa naŋ bu êŋgwiniŋ dau nditôm balêkoc dindec, naŋ ti ŋamalac ŋamata-ŋga yêc Anötö ndê gôliŋ ŋapu. ");
INSERT INTO buk_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ma asa naŋ kôc balêkoc sauŋ daŋ gitôm iŋ dindec, naŋ sa tu aneŋ ŋaê-ŋga, naŋ gitôm iŋ kôc aö dauŋ sa.” ");
INSERT INTO buk_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ma Yisu sôm, “Ŋamalac daŋ bu tim balêkoc sauŋ dindec si daŋ naŋ kêŋ whiŋ aö bu kôm mêtê sac, naŋ kôm giso atu. Oc ŋayham bu dasô hoc atu daŋ pi iŋ kachu, ma tambaliŋ iŋ sip gwêc tim ndi, ma gwêc kô iŋ mbac ndu. Ma boc-dinaŋ oc tôm dom bu iŋ tim balêkoc dau, ma tiŋambu tap Anötö ndê matôc sa. ");
INSERT INTO buk_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Aö wasôm têŋ mac, bu gêŋ lêtôm-ŋga oc sêmeŋ, ma sêkêŋ ŋawapac têŋ lau nom-ŋga. Tigeŋ asa naŋ bu kôc gêŋ lêtôm-ŋga daŋ meŋ, naŋ oc tap Anötö ndê matôc sa. Oyaê! ");
INSERT INTO buk_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Bocdinaŋ am amam me gahim daŋ bu wê am bu kôm sac, goc tim kic. Oc ŋayham bu am sôc undambê ma ndöc tamli ti amam gatuc me gahim gatuc, hôc gêlêc naŋ am kôm sac ti lic sambuc e Anötö tuc am sip ya naŋ sa ŋapaŋ, naŋ ndi. ");
INSERT INTO buk_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ma am nem tanôm bu wê am bu kôm sac, goc kip sa ma êmbaliŋ niŋga. Am bu mbo tamli ndöc undambê ti tanôm tigeŋ, naŋ hôc gêlêc am mbo ti tanôm lu ma kôm sac, dec tiŋambu Anötö tuc am sip ya lambwam-ŋga ndi.” ");
INSERT INTO buk_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ma ayob daôm ŋapep bu alic lau sauŋ dindec gitôm gêŋ ŋambwa dom. Aö wasôm têŋ mac, bu ŋac si aŋela naŋ sêmbo undambê, naŋ sêlhac Damaŋ undambê-ŋga ndê aŋgô andô-ŋga.  ");
INSERT INTO buk_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ŋamalac ndê Atu meŋ bu nem lau naŋ siŋga su, naŋ si. ");
INSERT INTO buk_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Akôc gauc pi ŋgac daŋ naŋ yob domba 100. Têŋ ndoc domba daŋ bu êŋsêlêŋ bambaliŋ e ndi niŋga, naŋ iŋ oc kôm sake? Iŋ oc hu 99 siŋ sêmbo, ma sa ndi êŋsalê daŋ naŋ giŋga. ");
INSERT INTO buk_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Aö wasôm têŋ mac bu têŋ ndoc iŋ tap sa, naŋ iŋ ndê atac ŋayham tu domba tigeŋ dinaŋ-ŋga oc hôc gêlêc iŋ ndê atac ŋayham pi 99 naŋ sêmbo, naŋ su. ");
INSERT INTO buk_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ma bocdinaŋ, mac nem Damam undambê-ŋga tec bu lau sauŋ daŋ sêniŋga.” ");
INSERT INTO buk_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Am nem asidôwa daŋ bu kôm sac têŋ am, goc am tamwasêm têŋ iŋ ndi, ma sôm iŋ ndê giso asê têŋ iŋ. Iŋ bu ŋgô am nem yom ma kac ndê ŋalôm kwi, dec amlu apitigeŋ tiyham ma ambo ti yom malô. ");
INSERT INTO buk_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Magoc iŋ bu ŋgô dom, dec kôm tôm yac neŋ ŋagôliŋ, naŋ sôm bu yom naŋ lau lu me tö sêpuc dôŋ, naŋ dakôc sa ti yom ŋandô. Boc-dinaŋ kôc ŋamalac tigeŋ me lu sêwhiŋ am, tu bu sêpuc am nem yom dôŋ-ŋga, ma atêŋ nem asidôwa dau andi. ");
INSERT INTO buk_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ma asidôwa dau bu sôc lau dinaŋ si yom ŋapu dom, naŋ sôm yom dau asê têŋ gôlôwac dabuŋ hoŋ. Ma iŋ bu tec bu sôc gôlôwac dabuŋ si yom ŋapu, naŋ goc alic iŋ gitôm ŋgac sambuc me ŋgac kôc takis-ŋga naŋ kêyalê Anötö dom. ");
INSERT INTO buk_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Aö wasôm yom ŋandô têŋ mac. Gêŋ bocke naŋ mac ambwala su yêc nom, naŋ wambwala su yêc undambê. Ma gêŋ bocke naŋ mac asô dôŋ yêc nom, naŋ wasô dôŋ yêc undambê bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ma gêŋ daŋ tiyham. Mac nem ŋamalac lu me tö bu ŋalôm tigeŋ bu ateŋ gêŋ daŋ têŋ Damaŋ undambê-ŋga, naŋ iŋ oc kêŋ têŋ mac. ");
INSERT INTO buk_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ŋahu bu gameŋ bocke naŋ mac nem ŋamalac lu me tö akac daôm sa tu aneŋ ŋaê-ŋga, naŋ aö oc wambo wawhiŋ mac.” ");
INSERT INTO buk_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita têŋ Yisu gi, ma ndac iŋ bocdec bu, “Pômdau, sôm têŋ aö. Aneŋ asidôwa daŋ bu kôm sac têŋ aö ŋapaŋ, naŋ wasuc iŋ ndê sac kwi tidim hiŋga? Nditôm 7, me tidim hiŋga?” ");
INSERT INTO buk_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Goc Yisu sôm, “Aö wasôm têŋ am, bu tidim 7 dom. Suc iŋ ndê sac kwi tidim 77 ma hôc gêlêc. Sê sa dom! ");
INSERT INTO buk_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Aŋgô su naŋ! Aö bu wawhê sa têŋ mac, lêŋ dasuc sac kwi-ŋga naŋ gic waê lau naŋ sêmbo Anötö ndê gôliŋ ŋapu. Kiŋ daŋ mbo, ma iŋ tac whiŋ bu êmasaŋ yom whiŋ iŋ ndê lau akiŋ naŋ si tôp yêc iŋ. ");
INSERT INTO buk_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Iŋ gic hu gweleŋ dau, ma sêkêŋ ŋgac daŋ kalhac iŋ aŋgô-ŋga, naŋ ndê tôp atu andô, gitôm mone talent 10,000. ");
INSERT INTO buk_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ŋgac dinaŋ gitôm dom bu ô ndê tôp, goc Kiŋ dau sôm bu sêkêŋ iŋ ti iŋ ndê awhê ma balêkoc ma iŋ ndê gêŋ hoŋ bu lau sênemlhi ô tôp dau. ");
INSERT INTO buk_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Dec ŋgac akiŋ dau hu dau sip gi pôŋ haduc têŋ Kiŋ, ma teŋ iŋ bocdec bu, ‘Kêŋ ŋasawa têŋ aö, ma waô gêŋ hoŋ!’ ");
INSERT INTO buk_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Goc Kiŋ tawalô iŋ, ma hu yom tôp-ŋga siŋ, ma kêŋ iŋ sa gi. ");
INSERT INTO buk_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Tigeŋ tiŋambu ŋgac dau tap ŋgac akiŋ daŋ sa, naŋ ndê tôp sauŋ yêc iŋ, gitôm mone †denarii 100. Iŋ gôlô ŋgac dau dôŋ, hôc iŋ sip kachu, ma sôm, ‘Am ndic nem tôp têŋ aö!’ ");
INSERT INTO buk_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ma ŋgac dau hu dau sip gi pôŋ haduc ma teŋ iŋ bocdec bu, ‘Kêŋ ŋasawa têŋ aö ma waô neŋ tôp.’ ");
INSERT INTO buk_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tigeŋ iŋ tec, ma kêŋ ŋgac dau ndöc gapocwalô e iŋ ô tôp hoŋ pacndê. ");
INSERT INTO buk_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Lau akiŋ ŋatô sêlic gêŋ dinaŋ, dec ŋalôm ŋawapac ŋandô, ma sêtêŋ Kiŋ si ma sic miŋ gêŋ hoŋ têŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Goc iŋ ta ŋgac akiŋ dau ma sôm têŋ iŋ, ‘Am ŋgac sac! Am teŋ aö bu taŋwalô am, dec aö gahu am nem yom tôp-ŋga siŋ. ");
INSERT INTO buk_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tu sake-ŋga am tamwalô ŋgac dinaŋ dom, gitôm aö taŋwalô am?’ ");
INSERT INTO buk_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Goc iŋ tac ŋandê atu, ma kêŋ ŋgac akiŋ dau têŋ lau gapocwalô-ŋga, bu sêndic iŋ ŋamlic ŋandê ma ndöc gapocwalô e iŋ ndic ndê tôp sambuc su.” ");
INSERT INTO buk_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yisu gic bata yom gôliŋ dau, goc sôm, “Mac bocdinaŋ, asuc nem asidôwai si sac kwi ma gauc nem tiyham dom. Bu mba, dec aneŋ Damaŋ undambê-ŋga oc kôm têŋ mac gitôm Kiŋ dinaŋ kôm têŋ ndê ŋgac akiŋ.” ");
INSERT INTO buk_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yisu sôm yom dau su, goc hu gameŋ Galili-ŋga siŋ, ma têŋ gameŋ Judia-ŋga naŋ yêc Bu Jordan ŋadaŋga têŋ ac pi-ŋga, naŋ gi. ");
INSERT INTO buk_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Lau daêsam sêŋkuc iŋ, ma yêc gameŋ dinaŋ iŋ kôm ŋac si gêmbac ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ma lau Palêsai ŋatô sêtêŋ iŋ si bu sêtim iŋ, dec sêndac iŋ bocdec bu, “Yom daŋ yêc, naŋ tôm bu ŋgac daŋ hu ndê awhê siŋ, me mba? Iŋ oc êŋgilì yomsu, me mba?” ");
INSERT INTO buk_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Goc iŋ sôm, “Mac aŋyalê Anötö ndê yom naŋ sêto yêc, me mba? Yom dau sôm bu, ‘Têŋ têm ŋamata-ŋga Anötö kêmasaŋ ŋamalac awhê ma ŋgac.’ ");
INSERT INTO buk_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ma yom daŋ tiyham sôm, ‘Tu dinaŋ-ŋga ŋgac daŋ oc hu damba lu dinda siŋ, ma sap iŋ ndê awhê dôŋ. Ma iŋlu sêti gêŋ tigeŋ.’ ");
INSERT INTO buk_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yom dau whê sa bu iŋlu sêmbo sêtôm ŋamalac lu dom, iŋlu sêti gêŋ tigeŋ yêc Anötö aŋgô-ŋga. Bocdinaŋ yham dom andô bu ŋamalac sêkac gêŋ naŋ Anötö dau kêŋ pitigeŋ, naŋ su.” ");
INSERT INTO buk_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Goc sêndac iŋ, “Bocdinaŋ dec tu sake-ŋga Moses to yomsu daŋ, naŋ sôm bu ŋgac daŋ gitôm bu to bapia hu nawhê siŋ-ŋga, goc hu iŋ siŋ?” ");
INSERT INTO buk_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ma Yisu ô yom bocdec bu, “Moses kêyalê bu mac nem ŋalôm ŋadandi, dec sôm bu ŋgac daŋ gitôm bu hu ndê awhê siŋ. Tigeŋ têŋ têm ŋamata-ŋga Anötö kêmasaŋ ŋamalac awhê ma ŋgac tu bu sêhu dau siŋ-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Aö wasôm têŋ mac, bu yom tigeŋ yêc bu ŋgac daŋ hu ndê awhê siŋ, naŋ awhê dau kôm mêtê mockaiŋ-ŋga whiŋ ŋgac daŋ. Ma ŋgac daŋ bu hu ndê awhê siŋ tu gêŋ dau-ŋga daŋ-ŋga, ma nem awhê wakuc, naŋ kôm mêtê mockaiŋ-ŋga yêc Anötö aŋgô-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Têŋ dinaŋ Yisu ndê ŋgac-sêŋomi sêsôm têŋ iŋ, “Bu bocdinaŋ, dec mboe oc ŋayham bu lau sênem dau dom, a? Oc ŋawapac atu bu awhê lu ŋgac sêsôc yom dau ŋapu.” ");
INSERT INTO buk_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Magoc iŋ sôm, “Mba! Anötö kêmasaŋ awhê lu ŋgac bu sênem dau. Magoc lau tigeŋ-tigeŋ iŋ kêmasaŋ ŋac bu sênem awhê me ŋgac dom. ");
INSERT INTO buk_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Lauŋgac ŋatô dindai sêkôc ŋac, naŋ sêtôm dom bu sênem awhê. Ma lauŋgac ŋatô naŋ sêsê ŋac bu sênem awhê dom. Ma ŋatô sêkêŋ dau sambuc tu gweleŋ ŋawaê ŋayham-ŋga tu bu sêpo Anötö ndê gôliŋ sa, ma tu dinaŋ-ŋga dec sem awhê dom. Am asa naŋ gitôm bu kôc yom dindec sa ma sôc ŋapu, naŋ kôc sa.” ");
INSERT INTO buk_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Lau ŋatô sêkôc si balêkoc sêtêŋ Yisu si. Ŋac tac whiŋ bu iŋ kêŋ amba sac ŋac, ma teŋ mbec pi ŋac. Tigeŋ ŋgacsêŋomi sêsôm dinda ti dambai. ");
INSERT INTO buk_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Goc Yisu sôm, “Atec balêkoc sêtêŋ aö sêmeŋ. Alhac ŋac ahuc dom, bu Anötö ndê gôliŋ gic lau naŋ sêtôm balêkoc sauŋ dindec, naŋ ŋawaê.” ");
INSERT INTO buk_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ma iŋ kêŋ amba sac ŋac hoŋ ma gêm mbec ŋac, goc tisa ma kölhö gi. ");
INSERT INTO buk_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ma ŋgac daŋ têŋ Yisu gi, ma ndac iŋ bocdec bu, “Kêdôhôŋwaga, aö wakôm gêŋ ŋayham bocke, dec tiŋambu Anötö oc kôc aö sa wandöc taŋli yêc undambê?” ");
INSERT INTO buk_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yisu ô yom ma sôm, “Tu sake-ŋga am ndac aö bu gêŋ sake iŋ gêŋ ŋayham? Anötö tawasê iŋ ŋayham. Am bu ndöc tamli yêc undambê, naŋ daŋam wambu yomsu naŋ Anötö kêŋ têŋ Moses.” ");
INSERT INTO buk_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Goc ŋgac dau ndac, “Yomsu hoŋ, me yomsu bocke?” Ma Yisu sôm, “Yomsu bocdec bu, ‘Ndic ŋamalac ndu dom. Kôm gêŋ mockaiŋ-ŋga dom. Nem kaŋ gêŋ dom. Sôm yom tasaŋ pi lau dom. ");
INSERT INTO buk_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Toc damam lu dinam sa,’ ma ‘Tac whiŋ lau ŋatô gitôm am tac whiŋ daôm.’” ");
INSERT INTO buk_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Goc iŋ sôm, “Yomsu hoŋ dinaŋ aö kakuc gambo. Ma gêŋ sake yêc tu wakôm-ŋga?” ");
INSERT INTO buk_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ma Yisu sôm, “Am bu ti ŋgac gitêŋ, naŋ sa ndi ma kêŋ nem gêŋ hoŋ têŋ lau sênemlhi, ma kêŋ ŋa-awa têŋ lau ŋalôm sawa. Ma bocdinaŋ dec êmyalê bu am nem awa ŋandô yêc undambê. Ma tiŋambu mweŋ ma êmkuc aö.” ");
INSERT INTO buk_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ŋgac dau iŋ ndê yala daêsam dom, ma têŋ ndoc iŋ ŋgô Yisu ndê yom dinaŋ, goc iŋ kölhö ti ŋalôm ŋawapac gi. Ŋahu bu iŋ ŋgac ti lêlôm. ");
INSERT INTO buk_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Goc Yisu sôm têŋ ndê ŋgac-s êŋomi, “Yomandô wasôm têŋ mac, b u lau ti lêlôm oc tôm dom bu sêsôc Anötö ndê gôliŋ ŋapu ŋagahô, ŋahu bu ŋac si awa ti wapa hê ŋac kwi. ");
INSERT INTO buk_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Aŋgô! Bôc atu daŋ gitôm kamel, oc tôm bu sôc so ŋalasê ŋagahô hôc gêlêc ŋgac ti lêlôm daŋ, naŋ bu sôc Anötö ndê gôliŋ ŋapu.” ");
INSERT INTO buk_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Têŋ ndoc ŋgacsêŋomi sêŋgô yom dinaŋ dec sêhêdaê ŋandô, ma sêndac Yisu, “Bu bocdinaŋ dec asa oc tôm bu tap Anötö ndê mwasiŋ nem lau si-ŋga sa? Oc ŋawapac atu!” ");
INSERT INTO buk_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Magoc Yisu tahê ŋac ma sôm, “Gêŋ naŋ ŋamalac sêtôm dom bu sêkôm, naŋ Anötö gitôm bu kôm.” ");
INSERT INTO buk_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ma Pita ô yom ma sôm, “Yac ahu gêŋ hoŋ siŋ tu aŋkuc am-ŋga. Bocdinaŋ yac oc atap mwasiŋ bocke sa?” ");
INSERT INTO buk_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Dec Yisu sôm têŋ ŋac hoŋ, “Yomandô wasôm têŋ mac, bu têŋ ndoc ŋambu-ŋga naŋ gêŋ hoŋ sêtiwakuc, naŋ Ŋamalac ndê Atu oc ndöc iŋ ndê pôŋ Kiŋ-ŋga ti ŋaclai ma ŋawasi atu. Ma mac lau naŋ aŋkuc aö, naŋ oc andöc pôŋ 12, ma anem gôliŋ lau Israel-ŋga si toŋ 12. ");
INSERT INTO buk_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ma lau hoŋ naŋ sêhu andu me damba lu dinda, me asidôwai ma balêkoc, me nom siŋ tu aö-ŋga, naŋ Anötö oc kêŋ gêŋ kaiŋ dinaŋ daêsam têŋ ŋac ô. Ma tiŋambu iŋ oc kêŋ ŋac sêwêkaiŋ gameŋ sêndöc tali ŋapaŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","“Magoc lau daêsam naŋ sêti lau ŋamata-ŋga têŋ têm kwahic dec-ŋga, naŋ oc sêti lau ŋambu-ŋga, ma lau ŋambu-ŋga oc sêti lau ŋamata-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Goc Yisu sôm, “Aŋgô yom gôliŋ dindec pi Anötö ndê gôliŋ, oc whê aneŋ yom dinaŋ sa. Ŋgac daŋ mbo, naŋ wêkaiŋ ôm wain-ŋga atu daŋ. Iŋ tisa têŋ bêbêc ganduc ma sôc malac lôm gi, ma kêsalê lau tu sênem gweleŋ yêc iŋ ndê ôm-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Iŋ tap lau ŋatô sa, ma sôm bu iŋ oc nemlhi ŋac ŋa mone gitôm †denarias tigeŋ tu gweleŋ bêc tigeŋ-ŋga. Goc iŋ kêkiŋ ŋac sêsôc iŋ ndê ôm si. ");
INSERT INTO buk_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ma têŋ acgatu gitôm 9 kilok, iŋ sa gi gêlic lau ŋatô sêlhac ŋambwa sêlhac malac lôm. ");
INSERT INTO buk_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ma iŋ sôm têŋ ŋac, ‘Andi akôm gweleŋ yêc aneŋ ôm wain-ŋga, ma aö oc wakêŋ ŋaôli solop têŋ mac ô nem gweleŋ.’ ");
INSERT INTO buk_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Goc sêsôc ôm si ma sem gweleŋ. Ma iŋ kôm bocdinaŋ têŋ ac kalhac lhu ma têŋ 3 kilok telha-ŋga. Iŋ gi tap lau sa, ma kêkiŋ ŋac si sêkôm gweleŋ. ");
INSERT INTO buk_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ma têŋ 5 kilok telha-ŋga iŋ sa gi tap lau ŋatô sa, naŋ sêlhac ŋambwa. Ma iŋ sôm têŋ ŋac, ‘Tu sake-ŋga mac ambo ŋambwa têŋ acsalô sambuc dindec?’ ");
INSERT INTO buk_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ma sêsôm, ‘Lau daŋ sêmeŋ sêkêŋ gweleŋ têŋ yac tu akôm-ŋga dom.’ Goc iŋ sôm, ‘Mac andi anem gweleŋ yêc aneŋ ôm.’ ");
INSERT INTO buk_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Têŋ ac gi sip, goc ôm ŋadau sôm têŋ iŋ ndê ŋgac ŋamata-ŋga, ‘M bwêc lau naŋ sem gweleŋ sêmbo, naŋ sêmeŋ, ma kêŋ ŋac si ŋaôli têŋ ŋac. Nemlhi lau naŋ sêmeŋ têŋ 5 kilok telha-ŋga naŋ muŋ, goc tiŋambu nemlhi lau naŋ sêmeŋ têŋ bêbêc.’ ");
INSERT INTO buk_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ma lau naŋ ŋadau kôc ŋac sa têŋ 5 kilok, naŋ sêkôc denarias tigeŋ-tigeŋ ti ŋac si ŋaôli tôm gi. ");
INSERT INTO buk_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tu dinaŋ-ŋga dec lau naŋ sic hu gweleŋ têŋ bêbêc, sêkêŋ bata bu oc sêkôc ŋaôli hôc gêlêc denarias tigeŋ su. Magoc ŋac hoŋ sêkôc denarias tigeŋ. ");
INSERT INTO buk_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Têŋ dinaŋ ŋac sic hu sêtucdiŋ ŋadau, ");
INSERT INTO buk_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ma sêsôm, ‘Lau naŋ sêmeŋ tiŋambu, naŋ sem gweleŋ gitôm ŋasawa apê, ma yac am gweleŋ atu ma ac pec yac acsalô sambuc dindec. Magoc yac hoŋ akôc ŋaôli kaiŋ tigeŋ.’ ");
INSERT INTO buk_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Magoc ŋadau sôm têŋ ŋac si daŋ, ‘O aneŋ silip! Bocke dec am sôm bu aö gakôm gêŋ so têŋ am? Bêbêc lec am gôlôc bu kôc denarias tigeŋ ti am nem ŋaôli gweleŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Boc-dinaŋ kôc nem ŋaôli sa, ma lhö ndi. Aö tac whiŋ bu wakêŋ ŋaôli têŋ lau ŋambu-ŋga gitôm aö gakêŋ têŋ am. ");
INSERT INTO buk_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mone dindec aneŋ gêŋ, ma wakôm tôm aö atac whiŋ. Bocke dec am gêlic sac bu aö ŋgac wamwasiŋ lau-ŋga.’” ");
INSERT INTO buk_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Goc Yisu sôm têŋ ndê ŋgac-sêŋomi, “Bocdinaŋ, lau ŋambu-ŋga oc sêti lau ŋamata-ŋga, ma lau ŋ amata-ŋga oc sêti lau ŋambu-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tiŋambu Yisu ma lau naŋ sêŋkuc iŋ, sêŋsêlêŋ sêmbo seŋ bu sêpi malac Jerusalem sêndi. Ma Yisu wê ŋgacsêŋomi 12 sêsa si sêmbo dau-ŋga, ma sôm têŋ ŋac, ");
INSERT INTO buk_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kwahic dec yac oc dapi malac Jerusalem dandi, ma ŋgac daŋ oc kêŋ Ŋamalac ndê Atu sip dabuŋ-siga atu-tu ti kêdôhôŋwaga yomsu-ŋga amba. Ŋac oc sêkic yom bu sêndic iŋ ndu, ");
INSERT INTO buk_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ma sêkêŋ iŋ sip lau Rom-ŋga amba. Ma lau Rom-ŋga oc sêsu iŋ susu, ma sêndic iŋ ŋamlic ŋandê atu, goc sêndic iŋ ndu pi a gicso dau. Ma têŋ bêc titö-ŋga, Anötö oc uŋ iŋ sa mbo tali tiyham.” ");
INSERT INTO buk_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Têŋ ndoc dinaŋ Jems lu Jon dinda bu teŋ gêŋ daŋ têŋ Yisu nem iŋlu awha, goc kôc Sebedi ndê atu lu dinaŋ sa sêtêŋ Yisu si, ma pôŋ haduc yêc iŋ aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ma Yisu ndac, “Am tac whiŋ sake?” Goc awhê dau sôm, “Aö tac whiŋ bu am toc aneŋ atuŋ lu dindec sa, ma sôm bu iŋlu sêndöc sêwhiŋ am têŋ ndoc am ndöc nem pôŋ kiŋ-ŋga ma nem gôliŋ lau. Kêŋ daŋ ndöc amam andô-ŋga, ma daŋ ndöc gasê-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Dec Yisu sôm têŋ iŋlu, “Amlu aŋyalê gêŋ naŋ amlu andac, naŋ dom. Amlu atôm bu anôm gêŋ sip laclhu ŋawapac-ŋga naŋ aö wanôm, a?” Ma iŋlu sêsôm, “Aêc, alu atôm.” ");
INSERT INTO buk_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ma Yisu sôm, “Yomandô, amlu oc ahôc ŋawapac gitôm aö wahôc. Magoc aö dec oc waŋyaliŋ lau sa bu sêndöc aö amaŋ andô-ŋga me gasê-ŋga, naŋ dom. Aneŋ Damaŋ ti ŋadau bu êŋyaliŋ lau sa bu sêndöc dinaŋ.” ");
INSERT INTO buk_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Têŋ ndoc ŋgacsêŋomi amaŋlu sêŋgô yom dau ŋawaê, dec kôm ŋac atac ŋandê têŋ Jems lu Jon. ");
INSERT INTO buk_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Goc Yisu mbwêc ŋac sêtêŋ iŋ si, ma sôm, “Mac aŋyalê bu lau sambuc si gôliŋwaga sêtoc dau sa têŋ ŋac si lau, ma ŋac si lau bata sêŋgwiniŋ lau naŋ sêmbo ŋac ŋapu. ");
INSERT INTO buk_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tigeŋ mac aŋkuc ŋac si mêtê dau dom. Mba! Mac nem asa naŋ tac whiŋ bu ti ŋamalac tiwaê yêc Anötö aŋgô-ŋga, naŋ nem akiŋ mac. ");
INSERT INTO buk_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aêc! Asa naŋ bu ti mac nem ŋamalac ŋamata-ŋga, naŋ êŋgwiniŋ dau ma ti mac nem ŋgac akiŋ ŋambwa. ");
INSERT INTO buk_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ŋalêŋ tigeŋ Ŋamalac ndê Atu meŋ bu lau sênem akiŋ iŋ dom. Iŋ meŋ bu nem akiŋ lau, ma bu kêŋ dau ti da bu nemlhi lau daêsam si sac ŋatôp.” ");
INSERT INTO buk_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Têŋ ndoc Yisu ti iŋ ndê ŋgac-sêŋomi sêhu malac Jeriko siŋ, naŋ lau daêsam sêŋkuc iŋ. ");
INSERT INTO buk_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ŋgac tapec lu sêndöc seŋ ŋamakê, ma sêŋgô ŋawaê bu Yisu kêsêlêŋ meŋ, goc sêmbwêc, “Pômdau, Dawid ndê Atu, tamwalô alu.” ");
INSERT INTO buk_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Goc lau sêsôm iŋlu bu sênem dau dôŋ. Magoc iŋlu sêmbwêc ti ŋaŋga, “Pômdau, Dawid ndê Atu, tamwalô alu.” ");
INSERT INTO buk_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yisu kwê dôŋ kalhac ma ta iŋlu sêmeŋ. Ma iŋ ndac, “Amlu atac whiŋ bu wakôm sake têŋ amlu?” ");
INSERT INTO buk_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ma sêô yom ma sêsôm, “Pômdau, alu atac whiŋ bu tanôŋ ŋayham sa.” ");
INSERT INTO buk_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Dec Yisu tawalô iŋlu, ma kêmasec iŋlu tandô. Ma ŋagahô iŋlu tandô ŋayham sa, ma sêŋkuc iŋ. ");
INSERT INTO buk_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ŋac sêsuŋ sa Jerusalem ma sêhôc asê malac Betpagi yêc Lôc Olib. Ma Yisu kêkiŋ ndê ŋgacsêŋomi si ŋgac lu, ");
INSERT INTO buk_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ma sôm têŋ iŋlu, “Amlu asôc malac dindê andi, ma amlu oc atap doŋki dinda daŋ sa, naŋ sêsô dôŋ kalhac, whiŋ doŋki dau ŋatu. Aŋgapwêc su, ma akôc sa atêŋ aö ameŋ. ");
INSERT INTO buk_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ma ŋamalac daŋ bu ndac amlu pi gêŋ dau, naŋ asôm têŋ iŋ bu, ‘Pômdau tac whiŋ bu doŋki lu dindec sênem iŋ sa,’ ma ŋagahô iŋ oc kêŋ doŋki lu dau têŋ amlu.” ");
INSERT INTO buk_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ŋalêŋ dinaŋ dec yom naŋ propet akwa daŋ sôm, naŋ ŋandô sa. Yom dau sêto yêc bocdec: ");
INSERT INTO buk_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Asôm têŋ lau †Sayon-ŋga bu, “Alic su naŋ! Mac nem Kiŋ têŋ mac meŋ. Iŋ ŋgac malô, ma iŋ meŋ ndöc doŋki ŋatu daŋ ŋahô.” ");
INSERT INTO buk_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ŋgacsêŋom lu dinaŋ sêsôc malac si, ma sêkôm tôm Yisu sôm. ");
INSERT INTO buk_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Sêwê doŋki dinda lu ŋatu sêtêŋ Yisu si, ma sêkêŋ ŋac si ŋakwê awê-ŋga sac doŋki, ma Yisu pi gi ndöc ŋahô. ");
INSERT INTO buk_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ma lau daêsam sêhê si ŋakwê yêc seŋ, ma sêhêako a ŋalauŋ ma sêkêŋ yêc seŋ. ");
INSERT INTO buk_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ma lau toŋ atu naŋ sêŋsêlêŋ sêmuŋ Yisu, ti lau naŋ sêŋkuc iŋ, naŋ sêmbwêc, “Hosana têŋ Dawid ndê Atu. Anötö nem mbec iŋ naŋ meŋ gêm Pômdau aŋgô. Hosana têŋ Anötö lôlôc-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Têŋ ndoc Yisu sôc malac Jerusalem gi, naŋ lau malac-ŋga hoŋ gauc gêm yom daêsam ma sêndac, “Iŋ asa dê?” ");
INSERT INTO buk_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ma lau daêsam sêŋgô ŋac si yom ma sêsôm, “Iŋ Yisu, propet atu naŋ meŋ akêŋ malac Nasaret yêc gameŋ Galili-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yisu sôc lôm dabuŋ ŋabatêm-ndö gi, ma soc lau naŋ sic dulu gêŋ ti semlhi gêŋ, naŋ su. Ma iŋ tac lau naŋ sêô mone, naŋ si tebo sa, ma lau naŋ sêkêŋ balusi tu lau sênemlhi-ŋga, naŋ iŋ kêbalip ŋac si gêŋ hoŋ giŋga. ");
INSERT INTO buk_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma iŋ sôm, “Sêto Anötö ndê yom yêc, naŋ sôm, ‘Aneŋ andu gic waê bu lau sêteŋ mbec sêmbo-ŋga.’ Tigeŋ mac akôm Anötö ndê andu ti lau kaŋ si gameŋ.” ");
INSERT INTO buk_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Lau bôliŋ ti lau tapec sêtêŋ Yisu si yêc lôm dabuŋ ŋamakê, ma iŋ kôm ŋac ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ma balêkoc naŋ sêmbo gameŋ dinaŋ, n aŋ sêmbwêc yom bocdec, “Hosana têŋ Dawid ndê Atu!” Magoc têŋ ndoc dabuŋsiga atu-tu ma kêdôhôŋwaga yomsu-ŋga sêlic gêŋ dalô naŋ Yisu kôm, ma sêŋgô balêkoc dau si yom, dec kôm ŋac atac ŋandê atu. ");
INSERT INTO buk_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ma sêndac iŋ, “Am ŋgô balêkoc dindec sêmbwêc yom so, me?” Ma iŋ sôm, “Mba! Sêto yom yêc bocdec bu, ‘Anötö kêyaliŋ balêkoc ti lau sauŋ sa, tu bu sêhoc iŋ ndê waê asê-ŋga.’” ");
INSERT INTO buk_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tiŋambu Yisu hu ŋac siŋ ma sa yêc malac Jerusalem gi, ma têŋ ôbwêc dinaŋ iŋ yêc malac Betani. ");
INSERT INTO buk_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Têŋ bêbêc ganduc Yisu kêsêlêŋ bu mbu têŋ Jerusalem ndi, ma gêŋ yô iŋ. ");
INSERT INTO buk_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ma iŋ gêlic a kiŋ daŋ kalhac seŋ ŋamakê, goc têŋ a dau gi ma kêsalê a ŋandô. Tigeŋ a dau ŋandô mba, iŋ tap ŋalauŋ ŋambwa sa. Dec iŋ pucbo a dau ma sôm, “Am oc nem ŋandô tiyham dom!” Ma ŋagahô a dau mbac. ");
INSERT INTO buk_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Têŋ ndoc ŋgacsêŋomi sêlic gêŋ dau, dec sêhêdaê ma sêndac dandi, “Bocke dec a dindê mbac ŋagahô?” ");
INSERT INTO buk_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ma Yisu ô yom ma sôm, “Aö wasôm yom ŋandô têŋ mac. Akêŋ whiŋ, ma atac lu-lu pi Anötö ndê ŋaclai dom. Ma mac oc atôm bu akôm tôm naŋ aö gakôm têŋ a dindê. Ma mac oc atôm bu akôm gêŋ dalô atu-tu ŋatô whiŋ. Oc nditôm mac asôm têŋ lôc dindê bu, ‘Puc daôm sa, ma sip gwêc ŋalôm ndi,’ ma gêŋ dau oc ŋandô sa. ");
INSERT INTO buk_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mac bu akêŋ whiŋ, goc gêŋ naŋ mac ateŋ têŋ Anötö, naŋ iŋ oc kêŋ têŋ mac.” ");
INSERT INTO buk_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yisu têŋ lôm dabuŋ gi, ma kêdôhôŋ lau mbo lôm ŋamakê, ma dabuŋsiga atu-tu ti lau bata Israel-ŋga sêtêŋ iŋ si. Ma sêndac iŋ, “Am kôc ŋaclai yêc nde, bu kôm gêŋ hoŋ naŋ am kôm? Asa kêŋ têŋ am?” ");
INSERT INTO buk_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ma iŋ sôm, “Gêŋ ŋamata-ŋga aö wakêŋ gêndac daŋ têŋ mac. Mac aô aneŋ yom muŋ, goc wasôm aneŋ ŋaclai ŋahu asê têŋ mac. ");
INSERT INTO buk_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Mac asôm têŋ aö, asa kêŋ ŋaclai têŋ Jon, dec iŋ kêku lau? Anötö kêŋ ŋaclai têŋ iŋ, me mba?” Goc ŋac sem yomgalôm pi Yisu ndê gêndac, ma sêsôm têŋ dandi, “Yac bu dasôm bu Anötö kêŋ ŋaclai têŋ Jon, goc iŋ oc ndac yac, ‘Tu sake-ŋga mac akêŋ whiŋ Jon dom?’ ");
INSERT INTO buk_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Magoc yac bu dasôm bu Jon kêku lau kêkuc ŋamalac nom-ŋga si gauc ŋambwa, dec lau oc sêkôm yac ŋayom, ŋahu bu sêlic Jon bu Anötö ndê propet daŋ.” ");
INSERT INTO buk_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Bocdinaŋ sêsôm têŋ Yisu, “Yac aŋyalê dom.” Ma iŋ sôm têŋ ŋac, “Ma bocdinaŋ aö wasôm aneŋ ŋaclai ŋahu asê têŋ mac dom.” ");
INSERT INTO buk_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Goc Yisu sôm têŋ ŋac, “Akôc gauc pi yom dindec. Ŋgac daŋ ti iŋ ndê atu lu sêmbo. Têŋ bêc daŋ iŋ ndac balê daŋ bocdec bu, ‘Aneŋ balê, kwahic dec aö bu wandac am bu sôc ôm wain-ŋga ndi ma nem gweleŋ.’ ");
INSERT INTO buk_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ma balê dau sôm, ‘Mba, aö gatec!’ Tigeŋ tiŋambu iŋ kac ndê ŋalôm kwi, ma sôc ôm gi ma gêm gweleŋ. ");
INSERT INTO buk_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ma damba gi tap balê tilu-ŋga sa, ma ndac iŋ bu nem gweleŋ ôm-ŋga. Ma iŋ sôm, ‘Aêc, oc wandi.’ Tigeŋ tiŋambu iŋ tec ma gi dom.” ");
INSERT INTO buk_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Dec Yisu ndac ŋac, “Mac gauc gêm sake? Balê lu si asa kôm tôm damba tac whiŋ?” Ma sêsôm, “Balê ŋamata-ŋga.” Goc iŋ sôm têŋ ŋac, “Yomandô aö wasôm têŋ mac. Lau naŋ sêkôc takis ma lauwhê seŋ-ŋga sêsôc Anötö ndê gôliŋ ŋapu, sêhôc gêlêc mac lau dabuŋsiga ti lau bata su. ");
INSERT INTO buk_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bu Jon hôc asê mac bu tôc lêŋ gitêŋ têŋ mac, tigeŋ mac akêŋ whiŋ iŋ dom. Lau naŋ sêkôc takis ma lauwhê seŋ-ŋga sêkêŋ whiŋ iŋ ndê yom ma sem dau kwi. Ma têŋ têm mac alic gêŋ naŋ lau dau sêkôm, naŋ mac am daôm kwi dom, ma akêŋ whiŋ dom.” ");
INSERT INTO buk_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ma Yisu sôm, “Aŋgô yom gôliŋ daŋ tiyham. Ŋgac daŋ sô ôm wain-ŋga daŋ, sô tuŋ kêgihi, kêmasaŋ gameŋ sêmasaŋ wain ŋakwi-ŋga, ma kwê andu baliŋ daŋ, bu lau sêlhac ma sêtip lau kaŋ. Goc iŋ kêŋ ôm dau têŋ lau ŋatô sêyob, ma kölhö gi mbo gameŋ daŋ. ");
INSERT INTO buk_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Têŋ ndoc sêhoŋ ôm dau ŋandô sa-ŋga, naŋ iŋ kêkiŋ lau akiŋ ŋatô sêtêŋ lau sêyob ôm-ŋga si, bu sêkêŋ wain ŋandô ŋatô têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Magoc ŋac sêlô lau akiŋ dau dôŋ. Sic ŋgac akiŋ daŋ ŋamlic ŋandê, sic daŋ ndu, ma sêtuc daŋ ŋa hoc. ");
INSERT INTO buk_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ma tiŋambu ôm ŋadau kêkiŋ lau akiŋ toŋ hic atu tiyham, magoc lau naŋ sêyob iŋ ndê ôm, naŋ sêkôm mêtê kaiŋ tigeŋ têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tiŋambu iŋ kêkiŋ iŋ ndê atuŋgac têŋ ŋac gi, bu iŋ gauc gêm bu ŋac oc sêtoc iŋ ndê atu dau sa. ");
INSERT INTO buk_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tigeŋ têŋ têm lau sêyob ôm-ŋga sêlic ŋadau ndê atu dau kêsêlêŋ meŋ, naŋ sêsôm têŋ dandi, ‘Balê kêlê oc wêkaiŋ ôm dindec ti ndê gêŋ lêŋsêm. Bocdinaŋ dandic iŋ ndu, ma dakôc ôm dindec su ti yac neŋ.’ ");
INSERT INTO buk_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Goc sêlô iŋ dôŋ ma sêhê iŋ sa awê gi, ma sic iŋ ndu.” ");
INSERT INTO buk_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yisu gic bata yom gôliŋ dau, ma ndac, “Têŋ ndoc ôm ŋadau mbu meŋ, naŋ iŋ oc kôm sake?” ");
INSERT INTO buk_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ma sêsôm têŋ iŋ, “Ôm ŋadau oc ndic lau sac dinaŋ ndu, ma kêŋ ndê ôm têŋ lau ŋatô sêyob. Ma ŋac oc sêkêŋ ôm ŋandô têŋ iŋ têŋ ndoc sêhoŋ ŋandô sa-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Goc Yisu sôm têŋ ŋac, “Gauc nem yom naŋ sêto yêc bocdec bu, ‘Hoc naŋ lau sêkwê andu-ŋga sêtec, naŋ kwahic dec ti hoc ŋamata-ŋga yêc andu dau. Pômdau kôm gêŋ dau, ma yac alic ŋayham.’ Mac asam yom dau su, me mba? ");
INSERT INTO buk_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44"," Asa naŋ peŋ tu hoc dinaŋ-ŋga, naŋ oc niŋga, ma hoc dau bu peŋ pi ŋamalac, dec oc sec iŋ popoc. Bocdinaŋ aö wasôm têŋ mac, bu Anötö oc seŋ mac su bu ayob lau naŋ sêmbo iŋ ndê gôliŋ ŋapu, naŋ tiyham dom. Ma iŋ oc êŋyaliŋ lau ŋatô sa bu sêyob iŋ ndê lau, naŋ oc sêkôm gweleŋ ŋapep ma sênem ŋandô ŋayham.” ");
INSERT INTO buk_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Dabuŋsiga atu-tu ti lau Palêsai sêŋgô Yisu ndê yom gôliŋ dinaŋ, ma sêŋyalê bu yom dau hêganôŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Dec sêŋsalê lêŋ bu sêkôc iŋ dôŋ, magoc sêtöc lau, bu lau hoŋ sêlic iŋ bu propet daŋ. ");
INSERT INTO buk_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ma Yisu sôm yom gôliŋ daŋ tiyham têŋ ŋac bocdec bu, ");
INSERT INTO buk_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ŋalêŋ naŋ Anötö kêgalêm lau sa bu sêmbo iŋ ndê gôliŋ ŋapu, naŋ bocdec. Kiŋ daŋ kêmasaŋ mwasiŋ atu daŋ tu iŋ ndê atuŋgac naŋ bu nem awhê-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ma iŋ kêkiŋ iŋ ndê lau akiŋ bu sêkêŋ aheŋ lau naŋ sic waê bu sêneŋ mwasiŋ dau. Magoc ŋac hoŋ sêtec bu sêmeŋ. ");
INSERT INTO buk_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Goc iŋ kêkiŋ lau akiŋ ŋatô ma sôm, ‘Mac asa andi asôm têŋ lau naŋ aö kagalêm ŋac sa su, bu aö kamasaŋ gêŋ hoŋ pacndê su. Aneŋ lau sic makao tôp ŋayham ndu su, bocdinaŋ dec ameŋ aneŋ mwasiŋ dau.’ ");
INSERT INTO buk_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tigeŋ lau hoŋ sêtec iŋ ndê yom dau, ma sêmbo si gêŋ. Ŋatô sêsôc ôm si, ma ŋatô sem si gweleŋ awa-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ma ŋatô sêlô Kiŋ ndê lau akiŋ dôŋ, sêkôm ŋatô ŋayom, ma sic ŋatô ndu. ");
INSERT INTO buk_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Goc Kiŋ dau tac ŋandê atu. Ma iŋ kêkiŋ iŋ ndê lau siŋ-ŋga ma ŋac sic lau sac dinaŋ ndu. Ma sêkêŋ ya gêŋ ŋac si malac hoŋ su. ");
INSERT INTO buk_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Goc iŋ sôm têŋ ndê lau akiŋ, ‘Aö kamasaŋ gêŋ hoŋ su. Magoc aö galic lau naŋ aö kagalêm ŋac sa, naŋ gitôm dom bu sêneŋ mwasiŋ dau. ");
INSERT INTO buk_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Bocdinaŋ asa seŋ malac-ŋga andi, ma aŋgalêm lau bocke naŋ mac bu atap sa, naŋ sa sêmeŋ ma sêneŋ mwasiŋ dau.’ ");
INSERT INTO buk_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Goc ŋac sêsa seŋ si ma sêŋsalê lau, ma sêhoŋ lau daêsam sa, lau ŋayham ma lau sac sêwhiŋ sêmeŋ, e andu ŋalôm atu sêneŋ mwasiŋ-ŋga meŋhu. ");
INSERT INTO buk_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Têŋ ndoc Kiŋ meŋ bu lic iŋ ndê ŋacleŋ dinaŋ, dec iŋ gêlic ŋgac daŋ naŋ sôc ŋakwê mwasiŋ-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ma iŋ ndac, ‘Bocke dec am sôc mweŋ, magoc am sôc ŋakwê mwasiŋ-ŋga dom?’ Ma ŋgac dau ndê yom mba. ");
INSERT INTO buk_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Goc Kiŋ sôm têŋ iŋ ndê lau akiŋ, ‘Mac asô iŋ ndê amba ti gahi dôŋ, ma atuc iŋ sa awê ndi mbo gameŋ ŋasec-ŋga. Yêc dê lau oc sêtaŋ atu ti lhô êŋsiŋ pi dau.’” ");
INSERT INTO buk_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Goc Yisu gic bata yom dau ma sôm, “Anötö kêgalêm lau daêsam sa, magoc iŋ oc kôc ŋac hoŋ sa dom.” ");
INSERT INTO buk_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Têŋ dinaŋ lau Palêsai sêsa si, ma sêmasaŋ yom bu sêtim Yisu bu sôm yom so daŋ. ");
INSERT INTO buk_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Goc sêŋkiŋ ŋac si lau ŋatô sêwhiŋ lau Israel-ŋga ŋatô naŋ sêpuc Herod ma lau Rom-ŋga si gôliŋ dôŋ, naŋ sêtêŋ iŋ si, ma sêsôm têŋ iŋ, “Kêdôhôŋwaga, yac aŋyalê bu am ŋgac sôm yom ŋandô-ŋga, ma bu am whê Anötö ndê lêŋ sa ti yom ŋandô. Ma am gauc gêm lau si waê dom, magoc toc ŋac hoŋ sa ŋalêŋ tigeŋ. ");
INSERT INTO buk_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Boc-dinaŋ sôm asê têŋ yac. Solop bu dakêŋ takis têŋ †Sisa, me mba?” ");
INSERT INTO buk_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yisu kêyalê su bu ŋac bu sêtim iŋ, dec sôm, “Mac lau daêtim-ŋga! Tu sake-ŋga mac bu atim aö? ");
INSERT INTO buk_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Atôc mone anemlhi takis-ŋga daŋ têŋ aö.” Goc sêkêŋ denarias tigeŋ têŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ma iŋ ndac ŋac, “Asa ndê ŋagatu ti ŋaê yêc mone dindec?” ");
INSERT INTO buk_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ma sêsôm, “Sisa ndê.” Goc iŋ sôm, “Bocdinaŋ atoc Sisa sa ŋa gêŋ naŋ gic iŋ ŋawaê, ma atoc Anötö sa ŋa gêŋ naŋ gic iŋ ŋawaê.” ");
INSERT INTO buk_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Têŋ ndoc sêŋgô Yisu ndê yom dinaŋ, naŋ sêhêdaê tu iŋ ndê gauc-ŋga, ma sêhu iŋ siŋ ma sêlhö si. ");
INSERT INTO buk_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Têŋ bêc dinaŋ lau ŋatô akêŋ Sadiusi si toŋ sêtêŋ Yisu si bu sêkêŋ gêndac têŋ iŋ. Lau dau sêkêŋ whiŋ bu dom lau batê oc sêtisa tiyham. ");
INSERT INTO buk_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ma sêsôm têŋ iŋ, “Kêdôhôŋwaga, Moses to yom pi ŋgac naŋ gêm awhê sa su magoc mbac ndu ma iŋ ndê balêkoc mba. Moses ndê yom sôm têŋ yac bu ŋgac dau ndê asi nem awhê sawa dau, ma kwê balêkoc asê tu dôwa-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Têŋ ndoc daŋ, asidôwa 7 sêmbo sêwhiŋ yac. Ŋgac ŋamata-ŋga gêm awhê sa magoc iŋ mbac ndu ma balêkoc mba. Ma ŋgac tilu-ŋga gêm dôwa ndê awhê sawa. ");
INSERT INTO buk_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Magoc iŋ mbac ndu, ma ŋalêŋ tigeŋ ŋgac titö-ŋga sip e gi têŋ ŋgac ŋambu-ŋga ŋac sem awhê sawa, magoc sêmbac ndu ma balêkoc mba. ");
INSERT INTO buk_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ma tiŋambu awhê dau mbac ndu. ");
INSERT INTO buk_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kwahic dec yac bu andac am bocdec bu. Lau batê bu sêtisa tiyham tôm lau ŋatô sêsôm, goc awhê dau oc ti asidôwa 7 dinaŋ si asa nawhê? Bu ŋac hoŋ sem iŋ su têŋ ndoc sêmbo tali.” ");
INSERT INTO buk_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Goc Yisu ô yom ma sôm, “Mac akôc gauc so, bu mac aŋyalê Anötö ndê yom ti iŋ ndê ŋaclai dom. ");
INSERT INTO buk_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Têŋ têm ŋambu-ŋga naŋ lau batê sêtisa, naŋ lau oc sênem dau dom. Ŋac oc sêmbo sêtôm aŋela undambê-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ma yom daŋ tiyham tôc asê bu lau batê oc sêtisa. Gauc nem Anötö dau ndê yom, naŋ mac asam su. ");
INSERT INTO buk_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Iŋ sam dau bu Abraham, ma Aisak, ma Jakob si Anötö. Lau batê bu sêtisa dom, dec tu sake-ŋga Anötö sam dau bu lau tö dinaŋ si Anötö? Iŋ lau batê si Anötö dom, iŋ lau tali si Anötö.” ");
INSERT INTO buk_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ŋalêŋ dinaŋ Yisu kêdôhôŋ lau, ma lau hoŋ naŋ sêŋgô iŋ ndê yom dinaŋ sêhêdaê. ");
INSERT INTO buk_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Lau Sadiusi sêŋgô Yisu ndê yom dinaŋ ma ŋac si yom mba. Ma lau Palêsai sêŋgô gêŋ dau ŋawaê, goc ŋac si lau ŋatô sêtêŋ Yisu si. ");
INSERT INTO buk_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ŋac si daŋ iŋ gwalam akwa yomsu-ŋga ma iŋ bu êŋsahê Yisu dec ndac iŋ bocdec bu, ");
INSERT INTO buk_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Kêdôhôŋ-waga, yêc Moses ndê buku, yomsu bocke ti yomsu ŋamata-ŋga?” ");
INSERT INTO buk_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ma Yisu ô yom ma sôm, “Yomsu naŋ sôm, ‘Am atac whiŋ Pômdau am nem Anötö, ti nem ŋalôm sambuc, ma ti gatôm sambuc, ma ti nem gauc sambuc.’ ");
INSERT INTO buk_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yomsu dinaŋ tiŋamata ma hôc gêlêc yomsu ŋatô hoŋ su. ");
INSERT INTO buk_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma yomsu tilu-ŋga naŋ gitôm ŋamata-ŋga, naŋ sôm, ‘Atac whiŋ nem asidôwai gitôm am atac whiŋ daôm.’ ");
INSERT INTO buk_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Yomsu lu dinaŋ sêpiŋ yom hoŋ naŋ Moses ti lau propet sêto, naŋ dôŋ sêpitigeŋ.” ");
INSERT INTO buk_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Lau ŋatô akêŋ Palêsai si toŋ sêlhac dinaŋ, dec Yisu ndac ŋac, ");
INSERT INTO buk_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mac asôm sake pi Mesaya? Iŋ asa ndê atuŋgac?” Ma sêsôm têŋ iŋ bu, “Mesaya iŋ Dawid ndê Atu.” ");
INSERT INTO buk_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Goc Yisu sôm, “Ma bocke Dawid dau sam Mesaya bu iŋ dau ndê Pômdau? Ŋalau Dabuŋ puc Dawid dôŋ, dec iŋ to yom yêc bocdec bu, ");
INSERT INTO buk_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Anötö sôm têŋ aneŋ Pômdau, “Am ndöc aö amaŋ andô-ŋga e nditôm aö wakêŋ nem ŋacyo sêsôc am gahim ŋapu.” ’ ");
INSERT INTO buk_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Bocdinaŋ Dawid dau sam Mesaya bu Pômdau, ma bocke mac asam Mesaya bu Dawid ndê Atu?” ");
INSERT INTO buk_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma ŋac si daŋ gitôm dom bu ô iŋ ndê yom. Ma tiŋambu lau hoŋ sêtöc dau bu sêkêŋ gêndac têŋ iŋ tiyham. ");
INSERT INTO buk_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Goc Yisu sôm têŋ lau daêsam naŋ sêkac dau sa sêmbo, ma têŋ iŋ ndê ŋgacsêŋomi bu, ");
INSERT INTO buk_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Lau Palêsai ti lau †Skraib sêndôhôŋ Anötö ndê yomsu têŋ lau, tôm Moses kôm têŋ têm ŋamata-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Bocdinaŋ asôc ŋac ŋapu, ma aŋgô ŋac si yom. Magoc aŋkuc ŋac si mêtê dom, bu ŋac lau sêtim yom lau-ŋga. Sêsôm yom ŋayham-ŋayham, magoc ŋac dau sêŋkuc si yom dau dom. ");
INSERT INTO buk_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ma yomsu daêsam naŋ sêkêŋ têŋ lau, naŋ kêŋ ŋawapac atu têŋ ŋac, magoc ŋac dau sêkôm gêŋ daŋ tu sênem lau dau sa-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ma gêŋ hoŋ naŋ ŋac sêkôm, naŋ sêkôm yêc lau si aŋgô-ŋga tu sêtoc dau sa-ŋga. Yomsu ti apaŋ naŋ sêkic pi dau, naŋ sêmasaŋ atu-tu tu lau sêlic-ŋga, ma sêsôc ŋakwê ti ŋabala baliŋ. ");
INSERT INTO buk_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ŋac atac whiŋ bu sêndöc lau tiwaê si pôŋ yêc lau si mwasiŋ ŋalôm, ma yêc lôm wê-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ŋac tac whiŋ bu lau sêhê mwalêc ŋac yêc malac lôm, ma bu lau hoŋ sêtoc ŋac sa ma sêsam ŋac bu ‘Kêdôhôŋwaga.’ ");
INSERT INTO buk_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Magoc aŋkuc ŋac si mêtê dom. Mac hoŋ ambo nom atôm asidôwai, ma mac nem kêdôhôŋ-waga tigeŋ mbo. Tu dinaŋ-ŋga solop dom bu lau sêsam mac bu ‘Kêdôhôŋwaga.’ ");
INSERT INTO buk_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma asam lau nom-ŋga bu mac nem damami dom, bu mac nem Damam tigeŋ mbo undambê. ");
INSERT INTO buk_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ma mac nem ŋadau tigeŋ mbo, naŋ Mesaya, dec solop dom bu lau sêsam mac bu ŋac si ŋadau. ");
INSERT INTO buk_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Asa naŋ gêm akiŋ mac, naŋ ti ŋamalac ŋamata-ŋga yêc Anötö aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Bu asa naŋ toc dau sa, naŋ Anötö oc êŋgwiniŋ iŋ, ma asa naŋ kêgwiniŋ dau, naŋ Anötö oc toc iŋ sa. ");
INSERT INTO buk_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Oyaê mac lau Skraib ti Palêsai! Mac lau atim yom lau-ŋga! Mac nem lêŋ kalhac lau ahuc bu sêsôc Anötö ndê gôliŋ ŋapu dom. Mac daôm asôc iŋ ŋapu dom, ma lau naŋ tac whiŋ bu sêsôc iŋ ŋapu, naŋ mac alhac ŋac ahuc.  ");
INSERT INTO buk_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Oyaê mac lau Skraib ti lau Palêsai, mac lau atim yom lau-ŋga. Mac ateŋ mbec baliŋ bu atoc daôm sa yêc lau si aŋgô-ŋga, magoc têŋ ndoc lau sêlic mac dom, naŋ mac aŋsau lauwhê sawa bu aŋgaho ŋac si andu su. Tu dinaŋ-ŋga Anötö oc kêŋ ŋagêyô sac sambuc têŋ mac. ");
INSERT INTO buk_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Oyaê mac lau Skraib ti Palêsai! Mac lau atim yom lau-ŋga! Mac aŋsêlêŋ seŋ baliŋ yêc b aö ma yêc gwêc, bu atap sêŋom daŋ sa tu êŋkuc mac-ŋga. Mac Sadaŋ ndê lau mac! Ma têŋ ndoc mac ahê sêŋom daŋ kêkuc mac, naŋ mac akôm iŋ ti Sadaŋ ndê balêkoc daŋ, hôc gêlêc mac daôm su. ");
INSERT INTO buk_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Oyaê! Mac bu atôc seŋ têŋ lau ŋatô, magoc mac daôm tampec. Têŋ ndoc lau sêsôm yom pi lôm dabuŋ tu bu sêpuc si yom dôŋ-ŋga, naŋ mac asôm bu ŋac si yom iŋ yom ŋambwa. Magoc têŋ ndoc sêsôm yom pi gôlôŋ gol naŋ yêc lôm dabuŋ tu bu sêpuc si yom dôŋ-ŋga, naŋ mac asôm bu yom dau tidôŋ su, ma gitôm dom bu sêseŋ su. ");
INSERT INTO buk_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mac lau tampec, gauc mbasi. Gêŋ sake hôc gêlêc su? Gol, me lôm dabuŋ naŋ kôm gol dau ti gêŋ dabuŋ? ");
INSERT INTO buk_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ma lau bu sêsôm yom pi alta naŋ kalhac lôm dabuŋ tu bu sêpuc si yom dôŋ-ŋga, naŋ mac asôm bu ŋac si yom iŋ yom ŋambwa. Magoc ŋac bu sêsôm yom pi da naŋ kalhac alta ŋahô, naŋ mac asôm bu yom dau tidôŋ. ");
INSERT INTO buk_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mac lau tampec! Gêŋ sake ti gêŋ ŋamata-ŋga? Da, me alta naŋ kôm da dau ti dabuŋ? ");
INSERT INTO buk_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Asa naŋ sôm yom pi alta, naŋ sôm pi alta ma pi gêŋ hoŋ naŋ kalhac alta ŋahô whiŋ. ");
INSERT INTO buk_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma asa naŋ sôm yom pi lôm dabuŋ, naŋ sôm pi lôm dau, ma pi Anötö naŋ ti lôm dabuŋ ŋadau, naŋ whiŋ. ");
INSERT INTO buk_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma asa naŋ sôm yom pi undambê, naŋ sôm pi Anötö ndê pôŋ atu, ma pi Anötö naŋ ndöc pôŋ ŋahô, naŋ whiŋ. ");
INSERT INTO buk_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Oyaê mac lau Skraib ti Palêsai. Mac lau atim yom lau-ŋga! Mac awhê gêŋ sauŋ-sauŋ ôm-ŋga hoŋ kôc gi toŋ amaŋlu, ma akêŋ toŋ daŋ ti da. Magoc mac ahu mêtê ŋandô yomsu-ŋga siŋ. Mêtê atu hêganôŋ mac tamwalô lau, ma amatôc lau si yom ŋalêŋ gitêŋ, ma akôm nem yom ŋandô sa. Mêtê hoŋ dinaŋ iŋ gêŋ atu! Solop bu mac akôm gêŋ sauŋ-sauŋ tôm yomsu sôm, magoc akôm gêŋ atu-tu whiŋ. ");
INSERT INTO buk_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“Mac lau tampec naŋ akôm bu atôc seŋ têŋ lau ŋatô. Mac atôm lau naŋ sêhêgo dau bu sêŋgati gêŋ golop atêc naŋ poc bu ŋahô, naŋ sa, magoc gêŋ ŋadômbwi atu naŋ poc bu dau ŋalôm, naŋ sêlic apu. ");
INSERT INTO buk_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Oyaê mac lau Skraib ti Palêsai, mac lau atim yom lau-ŋga! Mêtê tamgatu gêŋ ti aneŋ gêŋ ŋawahô-ŋga hôc mac nem ŋalôm ahuc. Bocdinaŋ mac atôm laclhu ti pele naŋ sêŋgwasiŋ ŋadômbwê-ŋga ŋambwa ŋawasi sa. ");
INSERT INTO buk_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","O lau Palêsai, mac lau tampec! Gêŋ ŋamata-ŋga aŋgwasiŋ laclhu ti pele ŋalôm ŋawasi sa, goc gêŋ awê-ŋga oc ŋawasi sa bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Oyaê mac lau Skraib ti Palêsai, mac lau atim yom lau-ŋga! Mac atôm sêhô naŋ sêsê pen pi gi e ŋawasi sêp sambuc ma lau sêlic ŋayham. Magoc yêc sêhô dau ŋalôm lau batê si ŋakwa ti gêŋ mbôp meŋhu. ");
INSERT INTO buk_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ma mac lau daôm bocdinaŋ. Lau sêlic gêŋ awê-ŋga naŋ mac akôm, dec gauc gêm bu mac lau gitêŋ. Magoc yêc mac nem ŋalôm, mêtê tasaŋ ma mêtê aŋgilì yomsu-ŋga hôc mac ahuc. ");
INSERT INTO buk_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Oyaê mac lau Skraib ti Palêsai, mac lau atim yom-ŋga! Mac amasaŋ sêhô ti gôlôŋ atu, tu bu atoc lau propet ti lau gitêŋ naŋ mac apami sic ndu muŋ su, naŋ sa. ");
INSERT INTO buk_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ma mac asôm bu mac bu ambo têŋ apami si têm, dec mac oc aŋkuc ŋac si lêŋ sêkêc propet dau si dac siŋ-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mac nem yom dinaŋ tôc asê bu mac asa akêŋ lau Israel-ŋga naŋ sic lau propet ndu. ");
INSERT INTO buk_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Bocdinaŋ dec mac akôm mêtê sac tôm apami sêkôm. ");
INSERT INTO buk_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mac mboc, ma mboc ŋatui mac! Gitôm dom bu mac awê Anötö ndê matôc sa. Iŋ oc êŋkiŋ mac asip lambwam andi. ");
INSERT INTO buk_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Aŋgô! Aö waŋkiŋ lau propet ma lau tigauc, ma lau ŋatô bu sêndôhôŋ mac. Magoc mac oc andic ŋac lic ŋandê yêc mac nem lôm wê-ŋga, ma ambulu ŋac alom-alom malac. Ma ŋac si lau ŋatô mac oc andic ndu, ma andic ŋatô pi a gicso dau sêndi. ");
INSERT INTO buk_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Bocdinaŋ mac oc atap ŋagêyô sa tu lau gitêŋ hoŋ si dac, naŋ apami sêkêc siŋ-ŋga. Abel iŋ ŋgac ŋamata-ŋga, ma Berekaya ndê atu Sekaria iŋ ŋgac ŋambu-ŋga. Sekaria iŋ ŋgac naŋ sic ndu yêc lôm dabuŋ ma alta naŋ kalhac lôm dau ŋasactô, naŋ ŋalhu. ");
INSERT INTO buk_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yomandô wasôm têŋ mac. Mac lau têm dindec-ŋga oc atap matôc sa pi lau hoŋ dinaŋ si dac. ");
INSERT INTO buk_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O Jerusalem, Jerusalem. Mac ac Anötö ndê lau propet ndu, ma lau gitêŋ naŋ iŋ kêkiŋ têŋ mac, naŋ mac atuc ŋa hoc ndu. Ndoc daêsam aö tac whiŋ bu wandic mac sa asôc Anötö ndê gôliŋ ŋapu tiyham, gitôm mbac dalec dinda gic ŋatu sa sêsôc ŋamakê ŋapu. Tigeŋ mac atec. ");
INSERT INTO buk_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Bocdinaŋ Anötö oc hu mac ti mac nem andu siŋ. ");
INSERT INTO buk_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Aö wasôm têŋ mac, bu mac oc alic aö tiyham dom e mac asôm, ‘Tampiŋ Mesaya naŋ meŋ gêm Pômdau aŋgô.’” ");
INSERT INTO buk_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yisu hu lôm dabuŋ ŋagameŋ siŋ ma bu êŋsêlêŋ ndi, ma iŋ ndê ŋgacsêŋomi sêtêŋ iŋ si. Ma sêsôm yom pi lôm dabuŋ ma pi gêŋ ŋayham hoŋ naŋ lau sêkwê yêc gameŋ dinaŋ. ");
INSERT INTO buk_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Magoc iŋ sôm, “Mac alic gêŋ hoŋ dindec. Aö wasôm yom ŋandô têŋ mac, bu ŋacyo oc sêseŋ hoc hoŋ dindec su e hoc daŋ ndöc hoc daŋ ŋahô tiyham dom.” ");
INSERT INTO buk_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tiŋambu Yisu ndöc Lôc Olib, ma iŋ ndê ŋgacsêŋomi tawasê sêtêŋ iŋ si, ma sêndac, “Sôm têŋ yac, ŋawapac naŋ am sôm yom pi, naŋ oc hôc asê Jerusalem têŋ têm bocke? Ma gêŋ sake oc kêŋ puc yac bu am oc mbu mweŋ, ma bu bêc ŋambu-ŋga oc hôc asê?” ");
INSERT INTO buk_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Goc iŋ sôm, “Ayob daôm ŋapep bu lau daŋ sêŋsau mac dom. ");
INSERT INTO buk_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bu lau daêsam oc sêŋsau bu sênem aö aŋôŋ ma sêsôm, ‘Aö Mesaya dauŋ dec!’ Ma ŋac oc sêŋsau lau daêsam. ");
INSERT INTO buk_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ma têŋ ndoc mac aŋgô ŋawaê bu lau sic siŋ têŋ dau me sêmasaŋ dau tu sêndic siŋ-ŋga, naŋ asö dom. Bu gêŋ hoŋ dinaŋ gic waê bu meŋ hôc asê, magoc têm ŋambu-ŋga yêc dôŋ yêc. ");
INSERT INTO buk_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kiŋ nom-ŋga oc sêkêŋ kisa dau, ma lau gameŋ daŋ oc sêndic siŋ têŋ lau gameŋ daŋ. Ma tôbôm ti tiyhô atu oc sêkôm gameŋ ŋatô tisac. ");
INSERT INTO buk_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Gêŋ hoŋ dinaŋ oc ndic hu ŋawapac têm ŋambu-ŋga-ŋga gitôm awhê naŋ kêsahê balêkoc tuŋ iŋ ma gêŋ dau gic hu ŋandê atu naŋ iŋ oc hôc tu kôc balêkoc-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Têŋ ndoc dinaŋ lau oc sêkôc mac dôŋ ma sêkôm mac ŋayom, ma sêndic mac nem ŋatô ndu. Lau nom-ŋga hoŋ oc atac tec mac tu mac aŋkuc aö-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Têŋ têm dinaŋ lau daêsam oc sêhu si sêkêŋ whiŋ aö siŋ, ma ŋac oc sêhoc si lau ŋatô asê ma sêtec dandi. ");
INSERT INTO buk_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ma propet tasaŋ daêsam oc sêhôc asê ma sêŋsau lau daêsam. ");
INSERT INTO buk_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mêtê sac oc êŋsôwec tiatu e lau daêsam oc sêhu mêtê atac whiŋ asidôwai-ŋga siŋ. ");
INSERT INTO buk_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Magoc asa naŋ bu lhac ŋaŋga ma hu aö siŋ dom e ndê têm pacndê, naŋ oc tap Anötö ndê mwasiŋ nem iŋ si-ŋga sa. ");
INSERT INTO buk_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ma bêc ŋambu-ŋga oc hôc asê dom, e lau sêhoc ŋawaê ŋayham pi Anötö ndê gôliŋ asê, tôm nom ŋagameŋ sambob, ma lau hoŋ sêŋgô su.” ");
INSERT INTO buk_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ma Yisu gic têku yom ma sôm, “Propet Daniel hoc yom asê gwanaŋ su, pi gêŋ sac sambuc naŋ lau oc sêkêŋ lhac lôm dabuŋ, naŋ oc kôm gameŋ tisac.” (Asa naŋ sam yom dindec, naŋ kôc gauc pi ŋapep, bu ŋahu yêc siŋ dau.) ");
INSERT INTO buk_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Têŋ ndoc mac alic gêŋ sac dinaŋ, naŋ mac lau hoŋ naŋ ambo gameŋ Judia-ŋga alhö api gameŋ lôc-ŋga andi. ");
INSERT INTO buk_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Alhö ŋagahô, ma gauc nem mac nem gêŋ daŋ dom. Lau naŋ sêndöc andu ŋasactô, naŋ sêsôc andu ŋalôm bu sêkôc ŋac si gêŋ daŋ sa dom. ");
INSERT INTO buk_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma ŋac naŋ sêmbo ôm, naŋ bocdinaŋ. Sêkac dau kwi bu sêkôc si gêŋ ŋatô dom. ");
INSERT INTO buk_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Oyaê. Lauwhê tidaê, ma ŋac naŋ sêkêŋ su têŋ balêkoc, naŋ oc sêtap ŋawapac atu sa têŋ têm dinaŋ. ");
INSERT INTO buk_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ateŋ mbec bu têm ŋawapac-ŋga dinaŋ tap ma sa têŋ ndoc uhô-ŋga me têŋ bêc Sabat-ŋga daŋ dom. ");
INSERT INTO buk_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Bu ŋawapac têm dinaŋ-ŋga oc hôc gêlêc ŋawapac hoŋ su. Têŋ têm ŋamata-ŋga e meŋ têŋ kwahic dec, ŋawapac atu kaiŋ dinaŋ daŋ hôc asê su dom. Ma tiŋambu ŋawapac kaiŋ dinaŋ oc hôc asê tiyham dom. ");
INSERT INTO buk_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Anötö oc tawalô lau naŋ iŋ kêyaliŋ ŋac sa su, ma tu dinaŋ-ŋga iŋ oc kêŋ têm ŋawapac-ŋga dau tiapê. Bu mba, ma têm d au tibaliŋ, goc lau hoŋ oc sêniŋga. ");
INSERT INTO buk_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Têŋ têm dinaŋ, lau daŋ bu sêsôm têŋ mac bu, ‘Alic, Mesaya dec meŋ,’ me ‘Mesaya dau dê,’ naŋ akêŋ whiŋ ŋac dom. ");
INSERT INTO buk_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bu lau naŋ sêŋsau bu ŋac Mesaya, ma propet tasaŋ oc sêhôc asê sêmeŋ, ma sêkôm gêŋ dalô atu-tu bu sêŋsau lau. Ma ŋac oc sêŋsahê bu sêtim lau naŋ Anötö kêyaliŋ ŋac sa, naŋ sêwhiŋ. ");
INSERT INTO buk_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Aŋgô ŋapep, bu aö gasôm gêŋ hoŋ dindec têŋ mac gwanaŋ. ");
INSERT INTO buk_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Bocdinaŋ, lau bu sêsôm, ‘Mesaya kêlê mbo gameŋ sawa,’ naŋ asa andi dom. Ma bu sêsôm, ‘Mesaya kelec mbo andu daŋ ŋalôm,’ naŋ akêŋ whiŋ dom. ");
INSERT INTO buk_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ŋamalac ndê Atu oc mbu meŋ ŋagahô eŋ, gitôm sickac naŋ gic hep tigeŋ, ma umboŋ ŋasawa sambuc ŋawê sa. ");
INSERT INTO buk_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mac bu alic macmpoŋ sêŋgihi sêmbo, naŋ aŋyalê bu gêŋ daŋ mbac ndu yêc. Ma bocdinaŋ gêŋ hoŋ dindec kêŋ puc mac pi ndoc Ŋamalac ndê Atu mbu meŋ-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“T êŋ ndoc ŋawapac-ŋga dinaŋ pacndê, goc ac oc nem ganduc, ma ayô oc ŋawê sa dom. Gêŋ ti ŋaclai naŋ sêlhac umboŋ oc wiwic sa, ma tata oc sêpeŋ akêŋ umboŋ. ");
INSERT INTO buk_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Têŋ ndoc dinaŋ lau titoŋ-titoŋ nom-ŋga hoŋ oc sêlic gêŋ dalô yêc umboŋ, naŋ kêŋ puc ŋac bu Ŋamalac ndê Atu oc mbu meŋ, ma ŋac hoŋ oc sêtaŋ daŋgibo atu. Ma ŋac oc sêlic Ŋamalac ndê Atu dau meŋ ndöc dao ŋahô ti ŋawasi ma ŋaclai atu. ");
INSERT INTO buk_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Goc iŋ oc êŋkiŋ iŋ ndê aŋela sêndic dahuc taŋ atu, ma sêsa sêtêŋ nom ŋabatiŋ ti undambê ŋabatiŋ hoŋ, bu sêndic lau naŋ iŋ kêyaliŋ ŋac sa su, naŋ sa. ");
INSERT INTO buk_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Gauc nem a laŋ. Têŋ ndoc mac alic ŋalauŋ wakuc bu lêc, naŋ aŋyalê bu ndoc ac-ŋga meŋ kêpiŋ. ");
INSERT INTO buk_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ma bocdinaŋ têŋ ndoc mac alic gêŋ naŋ aö gasôm yom pi, naŋ aŋyalê bu Ŋamalac ndê Atu ndê bêc mbu meŋ-ŋga meŋ kêpiŋ su, gitôm iŋ meŋ kalhac gatam nem andu-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yomandô! Lau têm dinaŋ-ŋga oc sêmbac ndu dom e gêŋ hoŋ dinaŋ hôc asê. ");
INSERT INTO buk_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Undambê ti nom oc niŋga, magoc aneŋ yom daŋ oc niŋga dom. Gêŋ hoŋ oc ŋandô sa tôm aö gasôm.” ");
INSERT INTO buk_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ma Yisu sôm, “Ŋamalac daŋ kêyalê bêc me acgatu naŋ Ŋamalac ndê Atu oc mbu meŋ, naŋ dom. Aŋela undambê-ŋga sêŋyalê dom, ma Anötö ndê Atu kêyalê dom. Damba tawasê kêyalê. ");
INSERT INTO buk_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Têŋ ndoc Ŋamalac ndê Atu mbu meŋ, naŋ lau oc sêmbo tôm lau sêmbo têŋ Noa ndê têm. ");
INSERT INTO buk_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","Têŋ ndoc dinaŋ, lau sêŋlhiŋ dau siŋ ma seŋ ti sênôm gêŋ, ma sem dandi e Noa sôc waŋ gi, ma bu suŋ meŋ ma seŋ ŋac hoŋ su siŋga. Ma lau nom-ŋga oc sêmbo ŋalêŋ tigeŋ dinaŋ, têŋ Ŋamalac ndê Atu ndê bêc mbu meŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ŋgac lu oc sêkôm gweleŋ sêmbo ôm, ma Anötö oc kôc iŋlu si daŋ sa, ma hu daŋ siŋ. ");
INSERT INTO buk_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ma awhê lu oc sêndê gêŋ sêmbo, ma iŋ oc kôc daŋ sa, ma hu daŋ siŋ. ");
INSERT INTO buk_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Bocdinaŋ amasaŋ daôm ŋapep, bu mac am gauc bêc bocke mac nem Pômdau oc mbu meŋ. ");
INSERT INTO buk_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Gauc nem yom dindec. Andu ŋadau daŋ, bu êŋyalê ndoc naŋ ŋgac kaŋ daŋ oc meŋ, naŋ iŋ oc yob iŋ ndê andu bu ŋgac kaŋ dau sôc meŋ dom. ");
INSERT INTO buk_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ma bocdinaŋ, amasaŋ daôm tôm bêc hoŋ, bu Ŋamalac ndê Atu oc mbu meŋ têŋ ndoc naŋ mac akêŋ batam, naŋ dom.” ");
INSERT INTO buk_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ma Yisu sôm, “Ŋgac akiŋ ŋayham ma ti gauc, iŋ ŋgac kaiŋ bocdec. Iŋ ndê ŋadau bu lhö têŋ gameŋ daŋ ndi, goc iŋ oc kêŋ iŋ yob lau akiŋ ŋatô, ma kêŋ gêŋ daneŋ-ŋga têŋ ŋac tôm ŋandoc. ");
INSERT INTO buk_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ma têŋ ndoc ŋadau mbu meŋ, ma tap iŋ sa kôm iŋ ndê gweleŋ ŋapep mbo, naŋ iŋ oc lic iŋ ŋayham ma kôm ŋayham têŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yomandô! Ŋadau oc kêŋ iŋ yob iŋ ndê wapa hoŋ. ");
INSERT INTO buk_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Magoc ŋgac akiŋ sac oc sôm têŋ dau, ‘Aneŋ ŋadau oc mbu meŋ ŋagahô dom.’ ");
INSERT INTO buk_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Goc iŋ oc ndic lau akiŋ ŋatô, ma sa ndi nôm ti neŋ gêŋ whiŋ lau naŋ sênôm gêŋ êŋiŋ ŋac-ŋga ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ŋadau oc mbu meŋ hôc asê têŋ bêc ti acgatu naŋ ŋgac akiŋ dau kêŋ bata, naŋ dom. ");
INSERT INTO buk_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ma iŋ oc kêŋ ŋagêyô sac sambuc têŋ iŋ, ma soc iŋ su ndi mbo whiŋ lau sêtim yom lau-ŋga. Yêc dindê lau oc sêŋsahê ŋandê atu e sêtaŋ ma lhô êŋsiŋ pi dau ŋapaŋ.” ");
INSERT INTO buk_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ma Yisu sôm yom gôliŋ daŋ bocdec bu, “Têŋ ndoc Ŋamalac ndê Atu mbu meŋ bu nem gôliŋ gêŋ hoŋ, naŋ lau ŋatô oc sêmasaŋ dau ŋapep, ma lau ŋatô oc mba. Oc tôm lauwhê akiŋ amaŋlu naŋ sêkôc si lam ma sêsa si bu sêhôŋ ŋgac nem awhê-ŋga, naŋ sêkêŋ bata bu oc meŋ. ");
INSERT INTO buk_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ŋac si amaŋdaŋ ŋac lauwhê tigauc, ma amaŋdaŋ ŋac lauwhê gauc mbasi. ");
INSERT INTO buk_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Lauwhê gauc mbasi dinaŋ sêkôc si lam, magoc sêkôc buya ŋatô whiŋ dom. ");
INSERT INTO buk_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ma lauwhê tigauc sêkôc si lam, ma sêkôc buya ŋatô sip bu akôp tôhôŋ. ");
INSERT INTO buk_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ŋac sêhôŋ ŋgac nem awhê-ŋga sêmbo, magoc iŋ hôc asê ŋagahô dom e ŋac kwapac sa, ma sêyêc bêc. ");
INSERT INTO buk_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Timaniŋhu goc ŋgac aheŋ-ŋga daŋ ta yom bocdec bu, ‘Oê! Ŋgac dau meŋ! Asa andi ma akôc iŋ sa.’ ");
INSERT INTO buk_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Goc lauwhê akiŋ sêtisa, ma sêmasaŋ ŋac si lam. ");
INSERT INTO buk_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ma amaŋdaŋ gauc mbasi dinaŋ sêndac lauwhê tigauc bocdec, ‘Akêŋ buya ŋatô têŋ yac, bu yac mba lam sêmbac.’ ");
INSERT INTO buk_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Magoc ŋac sêô yom ma sêsôm, ‘Mba! Mboe buya oc tôm yac hoŋ dom. Magoc mac andi alic lau naŋ sêkêŋ buya tu lau sênemlhi-ŋga, ma anemlhi nem.’ ");
INSERT INTO buk_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Magoc têŋ ndoc sêlhö si bu sênemlhi buya, goc ŋgac nem awhê-ŋga meŋ hôc asê. Ma lauwhê akiŋ naŋ sêmasaŋ dau gwanaŋ, naŋ sêwhiŋ iŋ sêsôc iŋ ndê gameŋ si, bu sêneŋ mwasiŋ awhê-ŋga. Goc iŋ gic gatam ahuc. ");
INSERT INTO buk_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tiŋambu lauwhê akiŋ gauc mbasi dinaŋ sêmbu sêmeŋ ma sêmbwêc, ‘Ŋadau! Ŋadau! Lêc gatam su têŋ yac.’ ");
INSERT INTO buk_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Magoc ŋadau sôm, ‘Mba! Aö wasôm yomandô bu kayalê mac dom!’” ");
INSERT INTO buk_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yisu gic bata yom gôliŋ dinaŋ ma sôm, “Boc-dinaŋ anem ali ma ayob daôm ŋapep, bu mac aŋyalê bêc ti acgatu naŋ aö oc wambu wameŋ, naŋ dom.” ");
INSERT INTO buk_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ma Yisu sôm yom gôliŋ daŋ tiyham pi têm ŋambu-ŋga bocdec bu, “Ŋgac tiwaê daŋ bu sa têŋ gameŋ baliŋ daŋ ndi. Bocdinaŋ iŋ mbwêc iŋ ndê lau akiŋ, ma kêŋ ndê gêŋ ŋatô têŋ ŋac bu sêyob e iŋ mbu meŋ. ");
INSERT INTO buk_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Iŋ kêŋ mone gol naŋ sêsam bu talent têŋ ŋac, kêkuc ŋac si licwalô ti ŋac si gauc. Iŋ kêŋ talent amaŋdaŋ têŋ ŋgac daŋ, ma talent lu têŋ daŋ, ma talent tigeŋ têŋ daŋ. Goc iŋ hu ŋac siŋ ma kölhö gi. ");
INSERT INTO buk_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ma ŋgac akiŋ naŋ kôc mone amaŋdaŋ, naŋ gi kôm gweleŋ pi mone dau e t ap mone amaŋdaŋ tiyham sa. ");
INSERT INTO buk_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ma iŋ naŋ kôc mone lu naŋ kôm boc-dinaŋ, ma tap mone lu tiyham sa. ");
INSERT INTO buk_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Magoc ŋgac naŋ kôc mone tigeŋ, naŋ sa gi kwê sê daŋ ma siŋ ŋadau ndê mone kwi yêc sê dau ŋalôm. ");
INSERT INTO buk_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ŋasawa hic baliŋ gi su, goc lau akiŋ dinaŋ si ŋadau mbu meŋ, ma bu ŋgô ŋac si yom pi mone dau. ");
INSERT INTO buk_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ma ŋgac naŋ kôc mone amaŋdaŋ, naŋ kôc amaŋdaŋ naŋ iŋ tap sa, naŋ whiŋ ma sôm, ‘Pômdau, am kêŋ mone amaŋdaŋ têŋ aö gayob, ma lic, aö gakôc amaŋdaŋ tiyham.’ ");
INSERT INTO buk_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Goc ŋadau sôm, ‘O aneŋ ŋgac ŋayham, am kôm ŋayham. Am yob gêŋ amaŋdaŋ ŋapep, dec wakêŋ am yob gêŋ daêsam. Mweŋ ma mbo whiŋ aö ti atac ŋayham.’ ");
INSERT INTO buk_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ma ŋgac akiŋ naŋ kôc mone lu, naŋ meŋ ma sôm, ‘Pômdau, am kêŋ mone lu têŋ aö gayob, ma aö gakôc mone lu tiyham whiŋ.’ ");
INSERT INTO buk_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ma ŋadau sôm, ‘O aneŋ ŋgac akiŋ ŋayham, am kôm ŋayham. Am yob gêŋ lu ŋapep, dec wakêŋ am yob gêŋ daêsam. Mweŋ ma mbo whiŋ aö ti atac ŋayham.’ ");
INSERT INTO buk_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Têŋ dinaŋ ŋgac naŋ kôc mone tigeŋ, naŋ meŋ ma sôm, ‘Pômdau, aö kayalê bu am ŋgac lêlê-ŋga dom, ma bu am oc kêŋ batam bu ndic gêŋ ŋandô sa yêc gameŋ naŋ am daôm kêbalip gêŋ ŋawhê me sô gêŋ dom. ");
INSERT INTO buk_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Bocdinaŋ aö gatöc dauŋ ma kasalê lêŋ bu am nem mone niŋga dom, dec gasa ga gasiŋ kwi yêc nom ŋalôm. Lic, gêŋ dau kelec.’ ");
INSERT INTO buk_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Goc ŋadau ô yom ma sôm, ‘Am ŋgac sac solop! Am ŋgac oyom. Am kêyalê su bu aö oc wandic gêŋ ŋandô sa yêc gameŋ naŋ aö gasô gêŋ dom. ");
INSERT INTO buk_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Bocdinaŋ am gitôm bu kêŋ aneŋ mone têŋ lau sêyob mone-ŋga bu sêyob e aö wambu wameŋ, dec oc tôm bu sêkêŋ mone ŋagec sac mone dau ŋahô, ma aö wakôc hoŋ sa.’ ");
INSERT INTO buk_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Goc ŋadau sôm têŋ iŋ ndê lau ŋatô, ‘Akôc mone su yêc iŋ, ma akêŋ têŋ ŋgac naŋ kôc mone amaŋlu. ");
INSERT INTO buk_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","30","Ma atiŋ ŋgac akiŋ sac dindec sa awê ndi bu mbo gameŋ ŋasec-ŋga naŋ lau sêtaŋ, ma ŋalhô êŋsiŋ pi dau. Bu asa naŋ yob gêŋ naŋ gakêŋ sip iŋ amba, naŋ ŋapep, naŋ wakêŋ gêŋ ŋatô tiyham têŋ iŋ whiŋ, ma iŋ ndê gêŋ oc ti daêsam. Magoc asa naŋ yob ndê gêŋ ŋapep dom, naŋ wakôc iŋ ndê gêŋ hoŋ su.’” ");
INSERT INTO buk_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Goc Yisu sôm, “Têŋ ndoc Ŋamalac ndê Atu mbu meŋ whiŋ aŋela hoŋ, naŋ iŋ oc ndöc iŋ ndê pôŋ kiŋ-ŋga ti iŋ ndê ŋaclai ma ŋawasi atu undambê-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ŋac oc sêndic ŋamalac hoŋ sa sêlhac iŋ aŋgô-ŋga. Ma iŋ oc whê ŋac kôc gitôm ŋgac yob domba-ŋga, naŋ whê iŋ ndê domba ti naniŋ kôc. ");
INSERT INTO buk_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Iŋ oc kêŋ domba sêlhac iŋ amba andô-ŋga, ma naniŋ sêlhac gasê-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Dec Kiŋ atu dau oc sôm têŋ lau naŋ sêlhac iŋ amba andô-ŋga, ‘Ameŋ mac lau naŋ Damaŋ gêlic mac ŋayham. Ma andöc mac nem malam yêc gameŋ undambê-ŋga, naŋ Damaŋ kêmasaŋ tu mac-ŋga têŋ ndoc iŋ kêŋ undambê ma nom. Dinaŋ ti mac nem gêŋ lêŋsêm. ");
INSERT INTO buk_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yom dinaŋ ŋa-ŋandô iŋ bocdec. Têŋ ndoc aö gêŋ yô aö, naŋ mac akêŋ gêŋ aö gaŋ. Ma têŋ ndoc bu yô aö, naŋ mac akêŋ bu têŋ aö ganôm. Aö ŋgac apa, ma mac akôc aö sa ma ayob aö. ");
INSERT INTO buk_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Aneŋ ŋakwê mba, ma mac akêŋ têŋ aö. Aö gêmbac, ma mac am yaom aö. Aö gandöc gapocwalô, ma mac ameŋ ac aö kêsi.’ ");
INSERT INTO buk_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ma têŋ dinaŋ lau gitêŋ oc sêô yom ma sêndac, ‘Pômdau, bocke? Têŋ nde yac alic am gêŋ yô am me bu yô am, ma yac akêŋ gêŋ daneŋ-ŋga me bu têŋ am? ");
INSERT INTO buk_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ma têŋ nde yac alic am ŋgac apa, ma akôc am sa, me am pônda ŋakwê, ma akêŋ têŋ am? ");
INSERT INTO buk_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ma têŋ nde yac alic am gêmbac me am ndöc gapocwalô, dec yac ameŋ alic am?’ ");
INSERT INTO buk_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Goc Kiŋ atu dau oc ô yom ma sôm, ‘Alic lau sêkêŋ whiŋ-ŋga hoŋ naŋ sêti aneŋ asiŋi ti lhuŋwêi. Yomandô wasôm têŋ mac, bu gêŋ bocke naŋ mac akôm têŋ ŋac si ŋamalac tiwaê me ŋamalac waê-mba daŋ, naŋ gitôm mac akôm têŋ aö dauŋ.’ ");
INSERT INTO buk_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Goc iŋ oc sôm têŋ lau naŋ sêlhac iŋ amba gasê-ŋga, ‘Mac lau atap Anötö ndê atac ŋandê sa-ŋga! Alhö su yêc aö, asip ya naŋ sa ŋapaŋ andi. Ya dau, Anötö kêmasaŋ gic Sadaŋ ti iŋ ndê aŋela sac ŋawaê. ");
INSERT INTO buk_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yom dinaŋ ŋa-ŋandô iŋ bocdec. Aö gêŋ yô aö, magoc mac akêŋ gêŋ daneŋ-ŋga têŋ aö dom. Ma bu yô aö, magoc mac akêŋ têŋ aö dom. ");
INSERT INTO buk_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Aö ŋgac apa, magoc mac akôc aö sa dom. Aö gapônda ŋakwê, ma mac akêŋ têŋ aö dom. Aö gêmbac, ma gandöc gapocwalô, magoc mac ameŋ alic aö dom.’ ");
INSERT INTO buk_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ma ŋac oc sêndac, ‘Pômdau, bocke? Têŋ nde yac alic am gêŋ yô am, bu yô am, am ŋgac apa, am pônda ŋakwê, gêmbac kôm am, me am ndöc gapocwalô, ma yac am am sa dom?’ ");
INSERT INTO buk_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ma iŋ oc sôm, ‘Yomandô wasôm têŋ mac, bu têŋ ndoc mac alic aneŋ lau tiwaê me lau waêmba daŋ naŋ pônda dau, magoc am iŋ sa dom, naŋ gitôm mac am aö dauŋ sa dom.’ ");
INSERT INTO buk_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Têŋ dinaŋ iŋ oc êŋkiŋ ŋac sêtêŋ gameŋ sêhôc ŋandê-ŋga sêndi, bu sêmbo ŋapaŋ. Magoc lau gitêŋ iŋ oc kôc ŋac sa sêndöc tali ŋapaŋ.” ");
INSERT INTO buk_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yisu sôm yom hoŋ dinaŋ su, goc sôm têŋ iŋ ndê ŋgacsêŋomi, ");
INSERT INTO buk_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Bêc lu yêc dôŋ yêc tu lau Israel-ŋga sêlic om atu †Pasowa-ŋga. Ma lau oc sêkêŋ Ŋamalac ndê Atu sip lau amba, bu sêndic iŋ ndu pi a gicso dau.” ");
INSERT INTO buk_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Têŋ ndoc dinaŋ dabuŋsiga atu-tu ti lau bata Israel-ŋga sic dau sa sêmbo †dabuŋsiga ŋamata-ŋga Kayapas ndê andu. ");
INSERT INTO buk_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","M a ŋac sêŋsalê lêŋ bu sêkôc Yisu dôŋ gelec ma sêndic iŋ ndu. ");
INSERT INTO buk_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Magoc ŋac sêsôm, “Dakôm têŋ Mwasiŋ Pasowa-ŋga ŋandoc dom, mbo lau daêsam naŋ sêmbo Jerusalem tu Pasowa-ŋga, naŋ oc sêlic ma sêli dau sa.” ");
INSERT INTO buk_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tiŋambu Yisu mbo whiŋ ŋgac daŋ ŋaê Saimon yêc malac Betani. Muŋ-ŋga iŋ ŋgac ti gêmbac leprasi. ");
INSERT INTO buk_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yisu ndöc tebo, ma awhê daŋ meŋ kôc bu ŋamalu ŋayham naŋ ŋaôli atu sip kac daŋ, ma kêc pi iŋ ŋagôlôŋ. ");
INSERT INTO buk_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yisu ndê ŋgacsêŋomi sêlic gêŋ dinaŋ ma tac ŋandê. Ma sêsôm têŋ dandi, “Tu sake-ŋga iŋ kêyaiŋ gêŋ ŋamalu ŋayham dinaŋ? ");
INSERT INTO buk_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Gitôm bu dakêŋ têŋ lau sênemlhi ŋa-awa atu, goc dakêŋ têŋ lau ŋalôm sawa.” ");
INSERT INTO buk_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yi su kêyalê bu ŋac sêsôm yom dinaŋ, goc sôm, “Akêŋ ŋawapac têŋ iŋ dom! Iŋ kôm gêŋ ŋayham kêlêc têŋ aö. ");
INSERT INTO buk_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Lau ŋalôm sawa oc sêmbo sêwhiŋ mac ŋapaŋ. Tigeŋ aö oc wambo wawhiŋ mac ŋapaŋ dom. ");
INSERT INTO buk_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Iŋ kêc gêŋ ŋamalu dec pi aö, tôm iŋ kêmasaŋ aö neŋ ŋamlic gwanaŋ tu sêŋsuhuŋ aö-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yomandô aö wasôm têŋ mac, bu tiŋambu lau oc sêhoc ŋawaê ŋayham asê yêc gameŋ hoŋ, ma têŋ dinaŋ ŋac oc sêsôm yom pi gêŋ naŋ awhê dindec kôm, ma lau oc gauc nem iŋ.” ");
INSERT INTO buk_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Têŋ dinaŋ ŋgacsêŋomi 12 si daŋ, ŋgac naŋ sêsam bu Judas Iskeriot, naŋ têŋ dabuŋsiga atu-tu gi, ");
INSERT INTO buk_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ma ndac, “Aö bu wahoc Yisu asê têŋ mac, goc mac oc akêŋ sake têŋ aö?” Dec sêlic ŋayham ma semlhi iŋ ŋa mone silba 30. ");
INSERT INTO buk_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ma Judas gic hu kêsalê lêŋ tu bu hoc Yisu asê-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Têŋ †Mwasiŋ Bolom Yist Mba-ŋga ŋabêc ŋamata-ŋga, naŋ ŋgacsêŋomi sêtêŋ Yisu si, ma sêndac iŋ bocdec bu, “Am tac whiŋ bu yac amasaŋ gameŋ tu daneŋ Mwasiŋ Pasowa-ŋga yêc nde?” ");
INSERT INTO buk_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Goc iŋ sôm yom pi ŋgac malac Jerusalem-ŋga daŋ, ma kêkiŋ ŋac sêtêŋ iŋ si ma sôm, “Asôc malac ma atêŋ ŋgac dau andi, ma asôm têŋ iŋ, ‘Yac mba kêdôhôŋwaga sôm bu iŋ ndê têm meŋ kêpiŋ su. Ma iŋ bu neŋ Mwasiŋ Pasowa-ŋga whiŋ iŋ ndê ŋgacsêŋomi yêc am nem andu.’” ");
INSERT INTO buk_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Bocdinaŋ ŋgacsêŋomi sêkôm tôm iŋ sôm têŋ ŋac, ma sêmasaŋ Pasowa. ");
INSERT INTO buk_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Têŋ ôbwêc dinaŋ, Yisu ti ndê ŋgacsêŋomi 12 sêtêŋ andu dau si, ma sêndöc sêwhiŋ dau. ");
INSERT INTO buk_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ŋac seŋ gêŋ sêmbo, ma iŋ sôm, “Yomandô aö wasôm têŋ mac bu mac nem daŋ oc hoc aö asê.” ");
INSERT INTO buk_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yom dau kôm ŋac sêsö ma ŋalôm ŋawapac atu, ma ŋac tigeŋ-tigeŋ sêsôm têŋ iŋ, “Pômdau, mboe aö, a?” ");
INSERT INTO buk_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ma Yisu ô yom ma sôm, “Iŋ ŋgac naŋ alu aŋ gêŋ sip pele tigeŋ, naŋ oc hoc aö asê. ");
INSERT INTO buk_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Gêŋ dau oc ŋandô sa pi Ŋamalac ndê Atu, tôm yom naŋ sêto yêc. Tigeŋ ŋgac naŋ bu hoc aö asê, naŋ oc tap ŋawapac atu sa, ma tu dinaŋ-ŋga iŋ dinda bu kôc iŋ dom, dec oc ŋayham.” ");
INSERT INTO buk_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Goc Judas, naŋ oc hoc iŋ asê, naŋ sôm, “Kêdôhôŋ-waga, mboe aö, a?” Ma Yisu sôm, “Tôm naŋ am daôm sôm.” ");
INSERT INTO buk_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Têŋ ndoc ŋac seŋ gêŋ sêndöc, naŋ Yisu kôc bolom, gêm daŋge ma pô kôc-kôc. Goc iŋ kêŋ têŋ ŋgac-sêŋomi ma sôm, “Akôc loc ma aneŋ. Aö neŋ ŋandô dau dec.” ");
INSERT INTO buk_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Goc iŋ kôc laclhu wain-ŋga daŋ ma gêm daŋge, ma kêŋ têŋ ŋac ma sôm, “Mac hoŋ akôc loc anôm. ");
INSERT INTO buk_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Aneŋ dac wamatiŋ pwac-ŋga dau dec. Wakêc siŋ tu wasuc lau daêsam si sac kwi-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Aö wasôm têŋ mac bu aö oc wanôm wain tiyham dom e wanôm wawhiŋ mac têŋ ndoc Damaŋ ndê gôliŋ meŋ sa tiawê.” ");
INSERT INTO buk_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tiŋambu ŋac sem wê daŋ ma sêsa sêtêŋ Lôc Olib si. ");
INSERT INTO buk_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ma Yisu sôm têŋ ŋac, “Tu gêŋ naŋ oc hôc asê aö têŋ ôbwêc dindec-ŋga, dec mac hoŋ oc ahu aö siŋ, tôm yom naŋ sêto yêc bocdec bu, ‘Aö wandic ŋgac yob domba-ŋga, ma domba oc sêlhö babalip.’ ");
INSERT INTO buk_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Magoc tiŋambu aö oc watisa tiyham, ma wamuŋ mac watêŋ gameŋ Galili-ŋga wandi.” ");
INSERT INTO buk_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ma Pita ô yom ma sôm, “Lau hoŋ bu sêhu am siŋ, magoc aö oc wahu am siŋ dom.” ");
INSERT INTO buk_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Goc Yisu sôm, “Aö wasôm yom ŋandô têŋ am, têŋ ôbwêc dec am oc sêc aö ahuc tidim tö muŋ, naŋ goc dalec oc taŋ.” ");
INSERT INTO buk_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Magoc Pita sôm têŋ iŋ, “Mba! Gitôm sêndic aö ndu wawhiŋ am, aö oc wasêc am ahuc dom!” Ma ŋgacsêŋomi hoŋ sêsôm yom kaiŋ tigeŋ. ");
INSERT INTO buk_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Goc Yisu ti ndê ŋgacsêŋomi sêtêŋ gameŋ naŋ sêsam bu Getsemani, naŋ si. Ma iŋ sôm têŋ ŋac, “Andöc dec ma aö wasa dê wandi ma wateŋ mbec.” ");
INSERT INTO buk_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Goc iŋ kôc Pita, ma Sebedi ndê atu lu sêwhiŋ iŋ si. Têŋ ndoc dinaŋ iŋ ndê ŋalôm ŋawapac atu ma kedehe iŋ. ");
INSERT INTO buk_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ma iŋ sôm têŋ ŋac, “Aö neŋ ŋalôm kêsahê ŋawapac atu, kêpiŋ bu oc wambac ndu. Andöc dec ma anem ali awhiŋ aö.” ");
INSERT INTO buk_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Goc iŋ hu ŋac siŋ ma sa ahic gi, ma hu dau aŋgô andô têŋ nom, ma teŋ mbec bocdec bu, “Damaŋ, aö wandac am bu nditôm, naŋ goc kôc laclhu ŋawapac-ŋga dindec su yêc aö. Magoc êmkuc aö neŋ atac whiŋ dom, kôm tôm am daôm nem atac whiŋ bu kôm.” ");
INSERT INTO buk_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Iŋ teŋ mbec su, goc tisa ma mbu têŋ ŋgacsêŋomi tö dinaŋ gi, ma gêlic ŋac sêyêc bêc sêyêc. Iŋ uŋ ŋac sa, ma ndac Pita, “Bocke? Mac atôm dom bu anem ali awhiŋ aö gitôm acgatu ŋasawa daŋ, a? ");
INSERT INTO buk_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","A nem ali, ma ateŋ mbec bu lêtôm tap mac sa dom. Mac nem gatôm licbalê, tigeŋ ŋamlic kwapac.” ");
INSERT INTO buk_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Goc iŋ sa gi ma teŋ mbec tiyham ma sôm, “Damaŋ, am bu kôc ŋawapac dindec su yêc aö dom, naŋ aö wahôc, ma wakôm am nem yom ŋandô sa.” ");
INSERT INTO buk_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Iŋ teŋ mbec dau pacndê, ma mbu gi tiyham ma gêlic ŋac sêyêc bêc sêyêc. Ŋac tandô hê ŋac sa ŋandô. ");
INSERT INTO buk_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Dec iŋ hu ŋac siŋ ma sa gi teŋ mbec tidim tö-ŋga, ma sôm yom tigeŋ dinaŋ tiyham. ");
INSERT INTO buk_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pacndê, ma iŋ mbu têŋ ŋgac-sêŋomi gi, ma sôm têŋ ŋac, “Tu sake-ŋga mac ayêc bêc ma aŋwhaŋ daôm ŋapaŋ? Aŋgô su naŋ! Sêhoc Ŋamalac ndê Atu asê su, ma ndoc meŋ sa bu sêkêŋ iŋ sip lau sac amba. ");
INSERT INTO buk_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Atisa ma dandi, bu ŋgac naŋ hoc aö asê dec meŋ su.” ");
INSERT INTO buk_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yisu sôm yom dinaŋ mbo, ma Judas, ŋgacsêŋomi 12 si daŋ, meŋ hôc asê whiŋ lau daêsam naŋ sêkôc bieŋ baliŋ ti siŋ. Dabuŋsiga atu-tu ti lau bata Israel-ŋga sêŋkiŋ lau dau sêwhiŋ Judas. ");
INSERT INTO buk_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas kêŋ puc ŋac gwanaŋ su bocdec bu, “Ŋgac naŋ mac aŋsalê, naŋ aö waŋgutô iŋ tu bu watôc iŋ asê, ma mac akôc iŋ dôŋ.” ");
INSERT INTO buk_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Bocdinaŋ iŋ têŋ Yisu gi, ma sôm, “Ôbwêc, Kêdôhôŋwaga,” ma ŋgutô iŋ. ");
INSERT INTO buk_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ma Yisu sôm, “Aneŋ silip, gêŋ naŋ am gauc gêm bu kôm, naŋ kôm.” Têŋ dinaŋ lau naŋ sêwhiŋ Judas, naŋ sêtêŋ Yisu si ma sêkôc iŋ dôŋ. ");
INSERT INTO buk_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Goc Yisu ndê ŋgacsêŋom daŋ puc iŋ ndê bieŋ sa, ma pa dabuŋ-siga ŋamata-ŋga ndê ŋgac akiŋ ndê daŋgalauŋ daŋ su. ");
INSERT INTO buk_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Magoc Yisu sôm têŋ iŋ, “Kêŋ nem bieŋ mbu sip ŋapaŋ tiyham. Asa naŋ kôc bieŋ sa tu ndic lau-ŋga, naŋ oc sêndic iŋ ndu ŋa bieŋ. ");
INSERT INTO buk_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Aŋyalê ŋapep bu oc tôm bu aö wateŋ Damaŋ ma iŋ oc kêŋ aŋela tausen ma tausen sêmeŋ ŋagahô ma sênem aö sa. ");
INSERT INTO buk_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tigeŋ aö bu wateŋ bocdinaŋ, dec gêŋ naŋ sêto yêc muŋ su, naŋ oc ŋandô sa ŋalêŋ nde?” ");
INSERT INTO buk_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Goc Yisu sôm têŋ lau daêsam dinaŋ, “Bocke dec mac akôc bieŋ ti wapa siŋ-ŋga, ma asa ameŋ bu akôc aö dôŋ gitôm ŋgac kaŋ daŋ? T ôm bêc hoŋ aö gandöc ti kadôhôŋ lau gambo lôm dabuŋ ŋabatêmndö, magoc mac akôc aö dôŋ dom. ");
INSERT INTO buk_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tigeŋ gêŋ hoŋ dindec hôc asê bu kôm yom naŋ lau propet sêto pi aö muŋ su, naŋ ŋandô sa.” Têŋ dinaŋ Yisu ndê ŋgacsêŋomi hoŋ sêhu iŋ siŋ ma sêlhö si. ");
INSERT INTO buk_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Lau naŋ sêndôhôŋ yomsu ti lau bata Israel-ŋga sêkac dau sa su ma sêhôŋ sêmbo dabuŋsiga ŋamata-ŋga Kayapas ndê andu. Ma lau naŋ sêkôc Yisu dôŋ, naŋ sêwê iŋ sêtêŋ andu dau si. ");
INSERT INTO buk_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita kêsêlêŋ kêkuc Yisu mbo ahê e hôc asê dabuŋsiga ŋamata-ŋga ndê andu. Goc iŋ sôc gi ndöc andu ŋatuŋlôm whiŋ lau siŋ sêyob lôm dabuŋ-ŋga ŋatô, bu lic gêŋ bocke oc hôc asê Yisu. ");
INSERT INTO buk_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Dabuŋsiga atu-tu ma lau bata hoŋ naŋ sêndöc †Sanedrin si toŋ, naŋ sêŋsalê yom tu sêŋgôliŋ pi Yisu-ŋga ma sêkêŋ iŋ sip lau Rom-ŋga amba bu sêndic iŋ ndu. ");
INSERT INTO buk_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Lau tasaŋ daêsam sêtisa ma sêsôm yom tasaŋ pi iŋ, magoc yom ŋandô bu sêŋgôliŋ pi iŋ, naŋ sêtap daŋ sa dom. Tiŋambu ŋac si lu sêtisa, ");
INSERT INTO buk_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ma sêsôm, “Iŋ ŋgac dec sôm bu iŋ gitôm bu seŋ Anötö ndê lôm dabuŋ su, ma kwê sa tiyham tôm bêc tö.” ");
INSERT INTO buk_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Goc dabuŋsiga ŋamata-ŋga tisa ma sôm têŋ Yisu, “Am ŋgô yom dê sêŋgôliŋ pi am, me? Am bu ô yom, me mba?” ");
INSERT INTO buk_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Magoc Yisu gêm dôŋ. Ma dabuŋsiga dau sôm, “Sôm yom ŋandô yêc Anötö Tali aŋgô-ŋga! Sôm asê têŋ yac bu am Mesaya, Anötö ndê Atu, me mba?” ");
INSERT INTO buk_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ma Yisu ô yom ma sôm, “Tôm naŋ am sôm. Tigeŋ aö wasôm têŋ mac hoŋ, tiŋambu mac oc alic Ŋamalac ndê Atu ndöc Anötö Ŋaclai Ŋadau ndê andô-ŋga, ma sip meŋ ndöc dao ŋahô.” ");
INSERT INTO buk_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Têŋ ndoc dabuŋsiga ŋamata-ŋga ŋgô yom dinaŋ, naŋ tac ŋandê atu dec kêc dau ndê ŋakwê kic ma sôm, “Iŋ ndê yom pi dau dê sac sambuc. Mac hoŋ aŋgô su. Yac dapônda yom daŋ tu taŋgôliŋ pi iŋ-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mac gauc gêm sake?” Ma sêô yom ma sêsôm, “Iŋ mbac ndu maŋ.” ");
INSERT INTO buk_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ma sêhê gasôp p i iŋ aŋgô andô, ma sêŋguluŋ amba ma sêpêŋ iŋ. Ma lau ŋatô sêtap iŋ, ");
INSERT INTO buk_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ma sêsôm, “Am Mesaya, a? Am bu propet, dec sôm asê bu asa tap am?” ");
INSERT INTO buk_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Têŋ têm dinaŋ Pita ndöc andu dau ŋamakê, ma awhê akiŋ daŋ têŋ iŋ gi, ma sôm, “Am ŋgac naŋ kêkuc Yisu Galili-ŋga whiŋ.” ");
INSERT INTO buk_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Magoc iŋ pa dau yêc ŋac hoŋ aŋgô-ŋga ma sôm, “Mba! Aö kayalê am nem yom ŋahu dom.” ");
INSERT INTO buk_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Goc iŋ sa gi kalhac gatam. Ma bawhê daŋ gêlic iŋ ma sôm têŋ lau, “Iŋ ŋgac dê, iŋ ŋgac daŋ naŋ kêkuc Yisu Nasaret-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ma Pita pa dau tiyham ma sôm yom ŋaŋga, “Yom ŋandô! Aö kayalê iŋ dom!” ");
INSERT INTO buk_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ŋasawa sauŋ ma lau naŋ sêlhac dinaŋ, sêtêŋ Pita si ma sêsôm, “Lau naŋ sêŋkuc iŋ, naŋ si daŋ am! Yomandô! Am sôm yom ŋa awha naŋ gi tap lau Galili-ŋga dinaŋ si sa.” ");
INSERT INTO buk_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Goc iŋ sôm, “Mba! A ö bu wasôm yom tasaŋ, naŋ Anötö ndic aö. Aö kayalê iŋ dom andô!” Ma ŋagahô dalec taŋ. ");
INSERT INTO buk_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Dec Pita gauc gêm Yisu ndê yom bocdec, “Am oc sêc aö ahuc tidim tö, goc dalec oc taŋ.” Goc iŋ kölhö sa awê gi, ma taŋ dau ndu. ");
INSERT INTO buk_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Têŋ bêbêc ganduc dabuŋ-siga atu-tu ti lau bata Israel-ŋga hoŋ si ŋalôm pitigeŋ bu sêndic Yisu ndu. ");
INSERT INTO buk_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Goc sêsô iŋ amba dôŋ, ma sêwê iŋ gi ma sêkêŋ iŋ sip Pailot amba. Pailot iŋ Rom si gôliŋwaga naŋ gêm gôliŋ gameŋ Judia-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Têŋ ndoc Judas gêlic gêŋ dinaŋ, ma ŋgô bu sêsôm tidôŋ bu sêndic Yisu ndu, naŋ iŋ ŋalôm ŋawapac bu iŋ hoc iŋ asê. Goc iŋ kêŋ mone silba 30 dinaŋ mbu têŋ dabuŋsiga atu-tu ti lau bata gi. ");
INSERT INTO buk_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ma iŋ sôm, “Aö gakôm so, bu aö gahoc ŋgac gitêŋ daŋ asê, ma oc sêkêc iŋ ndê dac siŋ.” Ma ŋac sêô iŋ awha ma sêsôm, “Tu sake-ŋga am sôm têŋ yac? Am daôm nem ŋawapac!” ");
INSERT INTO buk_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Dec Judas kêbaliŋ mone dau yêc lôm dabuŋ ŋamakê, ma sa gi kiŋ dau ndu. ");
INSERT INTO buk_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ma lau dabuŋsiga dau sêsôm, “Dac hi mone dindec ahuc, ma yac bu dakêŋ sip apa da-ŋga yêc lôm dabuŋ, dec oc daso yomsu.” ");
INSERT INTO buk_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Goc sêsôm yom tidôŋ bu sêkôc mone dau ma sênemlhi ŋgac pec lôŋ-ŋga ndê nom daŋ, ma sêŋyaliŋ nom dau sa ti lau apa si ôm sêhô-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tu dinaŋ-ŋga lau têm dindec-ŋga sêsam gameŋ dau bu ‘Nom ti Dac.’ ");
INSERT INTO buk_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Bocdinaŋ yom naŋ propet Jeremaya sôm, naŋ dec ŋandô sa. Sêto yom dau yêc bocdec bu: Lau Israel-ŋga sêkôc mone silba 30 naŋ sêŋyaliŋ sa ti iŋ ndê ŋaôli, naŋ sa, ");
INSERT INTO buk_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ma semlhi ŋgac pec lôŋ-ŋga ndê nom, tôm Pômdau kêŋ yatu aö. ");
INSERT INTO buk_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Sêkêŋ Yisu kalhac gôliŋwaga Pailot aŋgô-ŋga, ma iŋ ndac Yisu, “Am lau Israel si Kiŋ, a?” Ma Yisu ô yom ma sôm, “Tôm naŋ am daôm sôm.” ");
INSERT INTO buk_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Têŋ dinaŋ dabuŋsiga atu-tu ma lau bata Israel-ŋga sêŋgôliŋ yom pi iŋ, magoc iŋ ô ŋac si yom dom. ");
INSERT INTO buk_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Goc Pailot ndac iŋ, “Am ŋgô yom naŋ sêŋgôliŋ pi am, me mba?” ");
INSERT INTO buk_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Magoc Yisu ô yom naŋ sêŋgôliŋ pi iŋ, naŋ daŋ dom. Ma tu dinaŋ-ŋga Pailot hêdaê ŋandô. ");
INSERT INTO buk_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tôm yala hoŋ, têŋ ndoc lau Israel sêndê Mwasiŋ Pasowa-ŋga, naŋ Pailot kêkuc lêŋ daŋ bocdec bu. Lau Israel-ŋga oc sêndac ŋgac gapocwalô-ŋga daŋ, dec iŋ oc êŋgapwêc iŋ su têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Têŋ ndoc dinaŋ ŋgac daŋ ndöc gapocwalô. Iŋ ndê ŋaê Barabas, ma lau hoŋ sêŋyalê bu iŋ ŋgac sac sambuc. ");
INSERT INTO buk_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Goc Pailot ndac lau daêsam dinaŋ bu, “Mac atac whiŋ bu wahu asa siŋ têŋ mac? Barabas, me Yisu naŋ sêsam bu Kilisi?” ");
INSERT INTO buk_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailot kêyalê bu lau dabuŋsiga dau sem lêmuŋ Yisu ŋambwa, ma tu dinaŋ-ŋga dec sêkêŋ Yisu têŋ iŋ. Bocdinaŋ iŋ gauc gêm bu êŋgapwêc Yisu su. ");
INSERT INTO buk_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ma gêŋ daŋ tiyham. Têŋ n doc Pailot ndöc iŋ ndê pôŋ êmatôc yom-ŋga, naŋ iŋ ndê awhê kêŋ yom têŋ iŋ bocdec bu, “Kôm gêŋ daŋ têŋ ŋgac gitêŋ dinaŋ dom, bu kwahic dec aö gayêc mbê pi iŋ, naŋ kôm aneŋ ŋalôm ŋawapac ŋandô.” ");
INSERT INTO buk_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Magoc dabuŋsiga atu-tu ti lau bata sêli lau ŋalôm sa, ma sêndac Pailot bu hu Barabas siŋ têŋ ŋac, ma ndic Yisu ndu. ");
INSERT INTO buk_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Dec Pailot ndac ŋac tiyham, “Mac atac whiŋ bu wahu ŋgac lu dec si asa siŋ têŋ mac?” Ma sêsôm, “Barabas!” ");
INSERT INTO buk_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Goc iŋ ndac, “Bocdinaŋ aö wakôm sake têŋ Yisu naŋ sêsam bu Kilisi?” Ma ŋac hoŋ sêsôm bu, “Ndic iŋ pi a gicso dau ndi.” ");
INSERT INTO buk_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Magoc Pailot ndac, “Tu sake-ŋga? Iŋ kôm giso bocke?” Tigeŋ ŋac sêmbwêc atu, “Ndic iŋ pi a gicso dau!” ");
INSERT INTO buk_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailot kêyalê bu ŋac oc sêsôc iŋ ndê yom ŋapu dom, ma ŋac sêli dau sa ŋandô. Bocdinaŋ iŋ kôc bu, ma kêgwasiŋ amba yêc ŋac hoŋ aŋgô-ŋga, ma sôm, “Gêŋ dec sip mac amam. Aö wawêkaiŋ ŋgac dindec ndê dac ŋagêyô wawhiŋ mac dom.” ");
INSERT INTO buk_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ma lau hoŋ sêsôm, “Iŋ ndê dac ŋagêyô meŋ pi yac ti yac mba balêkoc.” ");
INSERT INTO buk_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Goc Pailot kêgapwêc Barabas su têŋ ŋac, ma kêŋ Yisu têŋ iŋ ndê lau siŋ-ŋga bu sêhi iŋ ŋamlic ŋandê, ma sêndic iŋ ndu pi a gicso dau. ");
INSERT INTO buk_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pailot ndê lau siŋ-ŋga sêwê Yisu sêsa Pailot ndê andu ŋa-malac lôm si, goc sêta lau siŋ-ŋga hoŋ sêkac sa sêmeŋ, ma sêŋgihi iŋ ahuc. ");
INSERT INTO buk_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Sêkôc iŋ ndê ŋakwê baliŋ su, ma sêkêŋ iŋ sôc ŋakwê kokoc baliŋ tôm kiŋ sêsôc. ");
INSERT INTO buk_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ma sêwhê wac kêm ma sêkêŋ iŋ uŋ gitôm suŋsuŋ. Ma sêkêŋ a daŋ iŋ gêm kôm yêc amba andô-ŋga gitôm kiŋ si tôc. Goc sêpôŋ haduc têŋ iŋ, ma sêsu iŋ susu ma sêsôm, “Ei! Datoc lau Israel si kiŋ dindec sa maŋ!” ");
INSERT INTO buk_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Sêhê gasôp pi iŋ, ma sêkôc a dau su yêc iŋ, ma sic iŋ pi ŋagôlôŋ tidim daêsam. ");
INSERT INTO buk_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Sêsu iŋ susu pacndê, goc sêkac ŋakwê dinaŋ su, ma sêkêŋ iŋ sôc dau ndê ŋakwê sa tiyham. Goc sêwê iŋ sêsa malac Jerusalem ŋamakê si, bu sêndic iŋ ndu pi a gicso dau. ");
INSERT INTO buk_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Têŋ ndoc sêwê Yisu sêsa si, naŋ sêtap ŋgac apa daŋ sa, naŋ meŋ akêŋ malac Sairin. Iŋ ndê ŋaê Saimon. Ma sêkac iŋ bu êmbalaŋ Yisu ndê a gicso dau. ");
INSERT INTO buk_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ma ŋac si e sêhôc asê gameŋ naŋ sêsam bu Golgota. (Ŋaê dau danem kwi bu ‘Gameŋ Ŋakêcyha-ŋga.’ ) ");
INSERT INTO buk_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Lau siŋ-ŋga sêkêŋ bu ŋamakic sip laclhu daŋ whiŋ wain, ma sêkêŋ têŋ Yisu nôm. Iŋ kêsahê ma tec. ");
INSERT INTO buk_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Goc ŋac sic iŋ pi a gicso dau. Ma tiŋambu sêwhê iŋ ndê ŋakwê kôc, ma sêpuc gapoc bu sêlic asa oc kôc ŋakwê bocke. ");
INSERT INTO buk_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pacndê su, goc sêndöc sic ma tatiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ma yom naŋ lau bata Israel-ŋga sêŋgôliŋ pi iŋ, naŋ sêto ma sêkêŋ kalhac a gicso dau ŋahô. Yom dau sôm bu, “Ŋgac dindec iŋ Yisu, lau Israel-ŋga si Kiŋ.” ");
INSERT INTO buk_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Têŋ bêc dinaŋ ŋac sic ŋgac kaŋ lu sêpi a gicso dau sêwhiŋ Yisu, daŋ kêgalêŋ Yisu ndê andô-ŋga, ma daŋ kêgalêŋ gasê-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Lau naŋ sêŋsêlêŋ si sêmeŋ sêndahiŋ ŋasu ma sêtaŋ bôlê Yisu. ");
INSERT INTO buk_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ma sêsôm, “Am ŋgac naŋ sôm bu seŋ lôm dabuŋ su, ma kwê sa tiyham tôm bêc tö. Am bu Anötö ndê Atu, naŋ goc nem daôm si ma sip mweŋ!” ");
INSERT INTO buk_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ma ŋalêŋ tigeŋ dinaŋ dabuŋsiga atu-tu ti lau naŋ sêndôhôŋ yomsu ma lau bata seŋgec iŋ. ");
INSERT INTO buk_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ma sêsôm têŋ dau, “Iŋ gêm lau ŋatô sa, magoc gitôm dom bu nem dau sa! Iŋ lau Israel-ŋga si Kiŋ, a? Iŋ bu sip meŋ akêŋ a gicso dau meŋ, dec yac oc dakêŋ whiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Iŋ kêŋ whiŋ Anötö ma sam dau bu Anötö ndê Atu. Anötö bu tac whiŋ iŋ, dec oc nem iŋ si.” ");
INSERT INTO buk_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ma ŋgac kaŋ lu naŋ sic iŋlu sêpi a gicso, naŋ sêsôm yom kaiŋ tigeŋ dinaŋ pi Yisu. ");
INSERT INTO buk_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Têŋ ac kac lhu, ŋasec atu gêm gameŋ sambuc ahuc e acgatu gitôm 3 kilok telha-ŋga. ");
INSERT INTO buk_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ma têŋ 3 kilok Yisu mbwêc awha atu, “Eloi, Eloi, lama sabaktani?” (Yom dau danem kwi bu ‘Aneŋ Anötö, aneŋ Anötö, tu sake-ŋga am hu aö siŋ?’ ) ");
INSERT INTO buk_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Lau naŋ sêlhac sêmpiŋ, naŋ sêŋgô iŋ ŋapep dom ma sêsôm, “Iŋ ta Elaija.” ");
INSERT INTO buk_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ma ŋgac daŋ kêti gi ma kêŋ sôwam daŋ sip wain ŋamakic, goc sô dôŋ pi a baliŋ daŋ, ma puc pi Yisu whasuŋ bu iŋ nôm. ");
INSERT INTO buk_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma lau ŋatô sêsôm, “Hu iŋ siŋ ma dalic. Elaija oc meŋ nem iŋ sa, me mba?” ");
INSERT INTO buk_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Têŋ dinaŋ Yisu mbwêc awha atu tiyham, ma mbac ndu. ");
INSERT INTO buk_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Têŋ ndoc dinaŋ po baliŋ naŋ kêgalêŋ lôm dabuŋ ŋalôm, naŋ dau kic gi lu, kalhac ŋahô-ŋga e gi têŋ ŋapu-ŋga. Ma tiyhô gêm ma hoc atu-tu daêsam popoc. ");
INSERT INTO buk_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ma sêhô sêhôc kôc, ma lau dabuŋ daêsam naŋ sêmbac ndu su, naŋ sêtisa sêmbo tali tiyham. ");
INSERT INTO buk_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ŋac sêsa akêŋ sêhô sêmeŋ, ma tiŋambu têŋ ndoc Yisu tisa su, goc sêsôc malac dabuŋ Jerusalem si, ma sêhoc dau asê têŋ lau daêsam sêlic. ");
INSERT INTO buk_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Têŋ ndoc ŋgac bata siŋ-ŋga ti iŋ ndê lau naŋ sêyob Yisu sêmbo, naŋ sêlic tiyhô ti gêŋ hoŋ dinaŋ, dec sêtöc dau atu, ma sêsôm, “Yomandô! Ŋgac dec iŋ Anötö Atu!” ");
INSERT INTO buk_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ma lauwhê daêsam sêlhac ahê ma sêlic gêŋ hoŋ dinaŋ. Ŋac lauwhê naŋ sêŋkuc Yisu akêŋ gameŋ Galili-ŋga sêmeŋ, ma sem akiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Maria Magadala, ti Jems lu Joses dinda Maria, ma Sebedi nawhê (Jon lu Jems dinda) sêmbo sêwhiŋ lauwhê dinaŋ. ");
INSERT INTO buk_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Lau naŋ sêŋkuc Yisu, naŋ si daŋ iŋ ŋgac ti lêlôm naŋ ndê ŋaê Josep, ma iŋ meŋ akêŋ malac Arimatiya. Têŋ telha dinaŋ, ");
INSERT INTO buk_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","iŋ têŋ Pailot gi, ma ndac Yisu ndê ŋamlaŋ. Pailot gôlôc ma kêŋ yom têŋ iŋ ndê lau siŋ-ŋga bu sêhu Yisu ndê ŋamlaŋ siŋ têŋ Josep. ");
INSERT INTO buk_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Dec Josep sa gi, kôc Yisu ndê ŋamlaŋ ma kêpaŋ si ŋa po ŋawasi daŋ. ");
INSERT INTO buk_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ma iŋ kôc sa gi ma kêŋ yêc iŋ dau ndê sêhô, naŋ sêlêŋ gwanaŋ su yêc hoc ŋalôm. Ma Josep kêpi hoc atu daŋ gi ndöc sê awha ahuc, goc kölhö gi. ");
INSERT INTO buk_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Têŋ ndoc dinaŋ Maria Magadala lu awhê daŋ ŋaê Maria, sêndöc sêhô ŋamakê ma sêlic. ");
INSERT INTO buk_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sic Yisu pi a gicso dau têŋ bêc naŋ lau Israel sêmasaŋ dau tu Sabat-ŋga, ma têŋ ŋagalaŋsê dabuŋsiga atu-tu ti lau Palêsai sêtêŋ Pailot si. ");
INSERT INTO buk_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ma sêsôm, “Ŋgac atu. Yac gauc gêm yom daŋ naŋ ŋgac tasaŋ dau sôm têŋ ndoc iŋ mbo tali. Iŋ sôm bu mbac ndu ma tiŋambu bêc tö niŋga iŋ oc tisa tiyham. ");
INSERT INTO buk_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Bocdinaŋ ndic atu lau bu sêyob sêhô e bêc tö niŋga su. Mboe iŋ ndê ŋgacsêŋomi oc sêmeŋ ma sênem kaŋ iŋ ndê ŋamlaŋ, ma sêsôm têŋ lau bu iŋ tisa su. Iŋ kêsau lau ma sôm bu iŋ Mesaya dau, magoc ŋac bu sêkôm tasaŋ dau, oc hôc gêlêc tasaŋ naŋ iŋ kôm ŋamata-ŋga, naŋ su.” ");
INSERT INTO buk_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Goc Pailot sôm têŋ ŋac, “Akôc lau siŋ-ŋga sa andi, ma akêŋ ŋac sêyob sêhô ŋaŋga.” ");
INSERT INTO buk_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Goc sêsa si ma sêsap hoc naŋ ti gatam sêhô-ŋga, naŋ dôŋ ŋaŋga ŋa a ŋakwi bu lau daŋ sêkac sa dom. Ma sêkêŋ lau siŋ-ŋga sêyob. ");
INSERT INTO buk_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Bêc Sabat-ŋga meŋ gi su, ma têŋ wake ŋabêc ŋamata-ŋga, Maria Magadala lu awhê daŋ ŋaê Maria sêti têŋ bêbêc ganduc ma sêsa si bu sêlic sêhô dau. ");
INSERT INTO buk_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Têŋ ndoc dinaŋ tiyhô gêm atu, ma Pômdau ndê aŋela daŋ sip akêŋ undambê meŋ, ma kêpi hoc naŋ ndöc sê awha ahuc, naŋ su, goc pi gi ndöc ŋahô. ");
INSERT INTO buk_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Iŋ ndê ŋawasi pô gameŋ gitôm sickac, ma iŋ ndê ŋakwê sêp sambuc. ");
INSERT INTO buk_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Têŋ ndoc lau siŋ-ŋga sêlic iŋ, naŋ sêtöc dau atu ma sêntitec. Ma ŋac tagôlô ma sêhu dau sêyêc gitôm lau batê. ");
INSERT INTO buk_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ma aŋela dau sôm têŋ awhê lu, “Atöc daôm dom. Aö kayalê bu amlu aŋsalê Yisu naŋ sic iŋ ndu pi a gicso dau. ");
INSERT INTO buk_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Iŋ mbo lec dom. Iŋ tisa su tôm iŋ sôm gwanaŋ su. Ameŋ alic gameŋ naŋ sêkêŋ iŋ yêc naŋ. ");
INSERT INTO buk_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Goc ambu andi ŋagahô, ma asôm têŋ iŋ ndê ŋgacsêŋomi bu iŋ tisa akêŋ lau batê-ŋga su. Ma iŋ oc muŋ mac ndi mbo gameŋ Galili-ŋga. Yêc dindê mac oc alic iŋ. Kwahic dec aö gahoc yom dindec asê têŋ amlu, ma amlu aŋgô su.” ");
INSERT INTO buk_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Têŋ ndoc dinaŋ awhê lu dau sêlhö si bu sêkêŋ ŋawaê dau têŋ Yisu ndê ŋgacsêŋomi. Iŋlu si ti atac ŋayham atu, magoc ŋalôm lu-lu ma sêtöc dau. Sênti sêmbo seŋ, ");
INSERT INTO buk_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ma ŋagahô Yisu hoc dau asê têŋ iŋlu ma hê mwalêc iŋlu. Goc iŋlu sêtigasuc iŋ ma sêhu dau sêyêc nom. Ma sêkôc iŋ sip gahi ma sêmpiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Goc Yisu sôm têŋ iŋlu, “Atöc daôm dom. Andi ma asôm têŋ aneŋ asidôwai hoŋ bu sêtêŋ Galili sêndi, ma ŋac oc sêlic aö yêc dindê.” ");
INSERT INTO buk_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Têŋ ndoc naŋ awhê lu dinaŋ sêmbo seŋ, naŋ lau siŋ-ŋga ŋatô naŋ sêyob sêhô dau, naŋ sêmbu sêtêŋ Jerusalem si. Ma sêkêŋ ŋawaê têŋ dabuŋsiga atu-tu, pi gêŋ hoŋ naŋ sêlic. ");
INSERT INTO buk_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Goc lau dabuŋsiga dau sêkac lau bata sa, ma sêmasaŋ yom pi gêŋ dau. Ŋac semlhi lau siŋ-ŋga ŋa mone atu, ");
INSERT INTO buk_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ma sêsôm têŋ ŋac, “Mac asôm têŋ lau bu, ‘Têŋ ôbwêc yac ayêc bêc ayêc. Ma iŋ ndê ŋgacsêŋomi sêmeŋ, ma sem kaŋ iŋ ndê ŋamlaŋ.’ ");
INSERT INTO buk_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma Pailot bu ŋgô bu mac ayêc bêc, dec yac oc amasaŋ yom awhiŋ iŋ, bu mac atap matôc sa dom.” ");
INSERT INTO buk_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Bocdinaŋ lau siŋ-ŋga sêkôc mone dau sa, ma sêkôm tôm lau bata Israel-ŋga sêsôm têŋ ŋac. Ma yom dau tiapa yêc lau Israel-ŋga ŋalôm, ma lau ŋatô sêsôm e meŋ têŋ kwahic dec. ");
INSERT INTO buk_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Têŋ ndoc dinaŋ ŋgacsêŋomi 11 sêsa sêtêŋ lôc naŋ yêc gameŋ Galili-ŋga si, gitôm Yisu sôm têŋ ŋac muŋ su. ");
INSERT INTO buk_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Têŋ ndoc sêlic iŋ, naŋ sêpôŋ haduc ma sêmpiŋ iŋ. Magoc ŋac si lau ŋatô atac lu-lu. ");
INSERT INTO buk_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Goc Yisu tigasuc ŋac ma sôm, “Anötö kêŋ ŋaclai têŋ aö pi gêŋ undambê ti nom-ŋga hoŋ. ");
INSERT INTO buk_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Bocdinaŋ atêŋ gameŋ hoŋ andi ma andôhôŋ lau e sêŋyalê aö ma sêkêŋ whiŋ aö. Aŋku ŋac anem Damba, Atu, ma Ŋalau Dabuŋ aŋgô. ");
INSERT INTO buk_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma andôhôŋ ŋac bu daŋga wambu yom hoŋ naŋ aö gac atu mac. Ma aŋyalê pi ŋandô bu aö oc wambo wawhiŋ mac ŋapaŋ, e nom ŋatêm pacndê.” ");
INSERT INTO buk_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yom dindec gic hu ŋawaê ŋayham pi Anötö ndê Atu Yisu Kilisi. ");
INSERT INTO buk_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Muŋ-ŋga, propet daŋ to yom naŋ Anötö sôm têŋ iŋ ndê Atu bocdec bu: Aö wakêŋ aneŋ ŋgac aheŋ-ŋga muŋ am. Iŋ oc êmasaŋ am nem seŋ. Ma propet Aisaya to Anötö ndê yom pi ŋgac aheŋ-ŋga dau bocdec bu: ");
INSERT INTO buk_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ŋamalac daŋ ta yom mbo gameŋ sawa bocdec bu, ‘Amasaŋ Pômdau ndê seŋ tisolop. Amasaŋ nem ŋalôm bu akôc iŋ sa.’ ");
INSERT INTO buk_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yom dau ŋandô sa pi Jon, Ŋgac Kêku Lau-ŋga, naŋ tiŋambu hôc asê ma gêm mêtê mbo gameŋ sawa. Iŋ sôm têŋ lau bu sêliŋ saŋgu tu bu sêtôc asê bu sêkac si ŋalôm kwi ma sêhu mêtê sac siŋ, dec Anötö oc suc ŋac si sac kwi. ");
INSERT INTO buk_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Lau daêsam akêŋ malac Jerusalem, ma akêŋ malac hoŋ yêc gameŋ Judia-ŋga, sêsa sêtêŋ Jon si. Ŋac sêhoc si sac asê, ma iŋ kêku ŋac yêc Bu Jordan. ");
INSERT INTO buk_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon sôc ŋakwê naŋ sêmasaŋ ŋa kamel ŋamliclhu, ma kic piŋkap yêc iŋ ŋampêbalê. Ma iŋ gêŋ gêŋ bambaliŋ gitôm wakô ma lêp. ");
INSERT INTO buk_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Iŋ gêm mêtê ma sôm têŋ lau bocdec bu, “Ŋgac daŋ oc meŋ êŋkuc aö, naŋ ndê ŋaclai hôc gêlêc aö neŋ su. Aö ŋgac ŋambwa dec gitôm dom bu wati iŋ ndê ŋgac akiŋ naŋ pôŋ sic ma kêgapwêc iŋ ndê atapa ŋawalô. ");
INSERT INTO buk_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Aö kaku mac ŋa bu ŋambwa, tigeŋ iŋ oc êŋku mac ŋa Ŋalau Dabuŋ.” ");
INSERT INTO buk_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Têŋ têm dinaŋ Yisu meŋ akêŋ malac Nasaret yêc gameŋ Galili-ŋga, ma hôc asê Jon. Ma Jon kêku iŋ yêc Bu Jordan. ");
INSERT INTO buk_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Têŋ ndoc Yisu pi akêŋ bu meŋ, iŋ gêlic undambê kac sa, ma Ŋalau Dabuŋ gêm balusi aŋgô, ma sip têŋ iŋ meŋ. ");
INSERT INTO buk_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Goc awha daŋ sa akêŋ undambê, naŋ sôm, “Aö Atuŋgac atac whiŋ-ŋga am. Aö gatisambuc am ŋandô.” ");
INSERT INTO buk_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Dinaŋ su, goc Ŋalau wê Yisu sa gameŋ sawa gi, ma iŋ mbo tawasê. ");
INSERT INTO buk_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tôm bêc 40 iŋ mbo gameŋ sawa, ma Sadaŋ kêsahê bu êntôm iŋ. Iŋ mbo whiŋ bôc gameŋ sawa-ŋga, ma aŋela sem akiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tiŋambu †Herod kêkiŋ iŋ ndê lau siŋ-ŋga bu sêkôc Jon dôŋ, ma sêkêŋ iŋ ndöc gapocwalô. Têŋ têm dinaŋ Yisu gêm mêtê ma hoc Anötö ndê ŋawaê ŋayham asê têŋ lau yêc gameŋ Galili-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Iŋ sôm, “Têm naŋ Anötö kêyaliŋ sa, naŋ meŋ sa su. †Anötö ndê gôliŋ meŋ kêpiŋ su. Bocdinaŋ anem nem ŋalôm kwi, ma akêŋ whiŋ Anötö ndê ŋawaê ŋayham.” ");
INSERT INTO buk_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Têŋ bêc daŋ Yisu kêsêlêŋ mbo Bugictoŋ Galili ŋamakê, ma gêlic Saimon lu asi Andru. Iŋlu ŋgac lu sêkôc i-ŋga, ma sem gweleŋ sêkêŋ wasaŋ sip bu sêmbo. ");
INSERT INTO buk_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ma Yisu sôm têŋ iŋlu, “Amlu ameŋ aŋkuc aö, ma aö wakêŋ amlu ahê ŋamalac sêmeŋ sêŋkuc aö, tôm naŋ kwahic dec amlu ahê i.” ");
INSERT INTO buk_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ma ŋagahô iŋlu sêtec si wasaŋ yêc, ma sêŋkuc iŋ. ");
INSERT INTO buk_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Iŋ kêsêlêŋ ŋasawa sauŋ, ma gêlic Sebedi ndê atu lu, Jems lu Jon. Sêndöc waŋ daŋ ma sêmasaŋ si wasaŋ naŋ kic. ");
INSERT INTO buk_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yisu mbwêc iŋlu bu sêmeŋ sêŋkuc iŋ, goc sêhu damba Sebedi ti lau naŋ sêkôm gweleŋ sêwhiŋ iŋ, naŋ siŋ sêmbo waŋ, ma sêŋkuc Yisu. ");
INSERT INTO buk_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yisu kôc lau hale dinaŋ ma sêŋsêlêŋ sêtêŋ malac Kapenaom si. Sêhôc asê têŋ bêc Sabat-ŋga daŋ, ma Yisu sôc †lôm wê-ŋga gi, ma gic hu kêdôhôŋ lau. ");
INSERT INTO buk_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ma lau Kapenaom-ŋga sêhêdaê tu iŋ ndê yom-ŋga, bu iŋ kêdôhôŋ ŋac gitôm kêdôhôŋwaga ti ŋaclai atu, hôc gêlêc lau Israel si †kêdôhôŋwaga yomsu-ŋga hoŋ su. ");
INSERT INTO buk_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ŋgac daŋ ndöc lôm wê-ŋga dinaŋ, naŋ ŋalau sac mbo iŋ ndê ŋalôm. Iŋ ta yom bocdec bu, ");
INSERT INTO buk_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ei! Yisu Nasaret-ŋga. Aö kayalê am, am ŋgac dabuŋ naŋ Anötö kêkiŋ. Am bu kôm sake têŋ yac? Am mweŋ bu seŋ yac su, a?” ");
INSERT INTO buk_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Magoc Yisu hec yom ŋalau sac ma sôm, “Am mamaŋ ma hu iŋ siŋ!” ");
INSERT INTO buk_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Goc ŋalau sac kêmwanaŋ ŋgac dau ti ŋaŋga ma hu iŋ siŋ ti mbwêc atu. ");
INSERT INTO buk_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tu dinaŋ-ŋga lau hoŋ sêhêdaê ma sêndac dandi, “Gêŋ bocke dec? Iŋ kêdôhôŋ yac ŋa lêŋ wakuc ma ti ŋaclai atu. Ma iŋ kôc ŋaclai pi ŋalau sac whiŋ, bu iŋ kêŋ yatu ŋac, ma sêsôc iŋ ndê yom ŋapu.” ");
INSERT INTO buk_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ma tiŋambu lau sic miŋ yom pi gêŋ dau, e ŋagahô eŋ iŋ ndê waê gêm gameŋ Galili-ŋga hoŋ ahuc. ");
INSERT INTO buk_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ŋac sêhu lôm wê-ŋga dinaŋ siŋ, ma Saimon lu Andru sêkôc Yisu, Jems ma Jon ma sêtêŋ iŋlu si andu si. ");
INSERT INTO buk_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimon ndê lawawê gêmbac lic ŋandê ma yêc andu dau ŋalôm, ma lau sêkêŋ ŋawaê têŋ Yisu. ");
INSERT INTO buk_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Bocdinaŋ Yisu têŋ iŋ gi, kêm iŋ sip amba ma keŋ iŋ sa. Ma gêmbac hu awhê dau siŋ, ma iŋ gêm akiŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Têŋ telha dinaŋ têŋ ndoc ac gi sip, naŋ lau malac-ŋga sêhoŋ lau gêmbac daêsam ti lau naŋ ŋalau sac sêmbo si ŋalôm, ma sêkôc ŋac sêtêŋ Yisu sêmeŋ. ");
INSERT INTO buk_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Lau malac-ŋga hoŋ sêkac dau sa, sêmbo andu dau ŋamakê. ");
INSERT INTO buk_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ma Yisu gêm lau ti gêmbac tidau-tidau daêsam dinaŋ sa, ma soc ŋalau sac daêsam su yêc lau. Tigeŋ iŋ kêŋ yao ŋalau sac bu sêsôm iŋ asê dom, ŋahu bu ŋac sêŋyalê bu iŋ †Mesaya dau. ");
INSERT INTO buk_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Têŋ ŋagalaŋsê ac pi meŋ su dom ma Yisu tisa ma hu malac dau siŋ. Iŋ sa gi bu mbo tawasê ma teŋ mbec. ");
INSERT INTO buk_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimon ma lau ŋatô naŋ sêwhiŋ iŋ, naŋ sêsa si bu sêŋsalê iŋ. ");
INSERT INTO buk_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ma têŋ ndoc sêtap iŋ sa, naŋ sêsôm têŋ iŋ bu, “Lau hoŋ sêŋsalê am.” ");
INSERT INTO buk_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Magoc Yisu ô yom ma sôm, “Aö oc wambo malac tigeŋ dinaŋ dom. Dalhö datêŋ malac naŋ sêyêc gameŋ ŋamakê-ŋga dandi, bu wanem mêtê wambo dinaŋ. Tu gweleŋ dinaŋ-ŋga dec aö gameŋ.” ");
INSERT INTO buk_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ma tiŋambu iŋ kêsêlêŋ golom-golom malac hoŋ yêc gameŋ Galili-ŋga. Iŋ gêm mêtê mbo lau si lôm wê-ŋga, ma soc ŋalau sac daêsam su yêc lau. ");
INSERT INTO buk_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Têŋ bêc daŋ, ŋgac ti gêmbac †leprasi daŋ têŋ Yisu gi. Iŋ pôŋ haduc ma teŋ Yisu bu nem iŋ sa. Iŋ sôm, “Am bu tac whiŋ, dec gitôm bu am oc kôm aö ŋamlic ŋawasi sa.” ");
INSERT INTO buk_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yisu tawalô iŋ, dec kêmatôc amba sa gi ma kêmasec iŋ, ma sôm, “Aö atac whiŋ, dec wasôm têŋ am bu ŋamlic ŋawasi sa.” ");
INSERT INTO buk_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ma ŋagahô eŋ gêmbac dau hu iŋ siŋ, ma iŋ ndê ŋamlic ŋawasi sa. ");
INSERT INTO buk_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Goc Yisu kêkiŋ iŋ têŋ †dabuŋ-siga gi, ma sôm ti ŋaŋga têŋ iŋ, “Am ŋgô! Gêŋ naŋ kwahic dec hôc asê am, naŋ sôm asê têŋ lau daŋ dom. Tigeŋ têŋ dabuŋsiga ndi, ma tôc daôm têŋ iŋ bu lic bu am nem ŋamlic ŋawasi sa su. Ma kêŋ da tu am ŋamlic ŋawasi sa-ŋga tôm yomsu naŋ Moses kêŋ têŋ yac. Ma ŋalêŋ dinaŋ lau hoŋ oc sêŋyalê bu am ŋamlic ŋayham sa.” ");
INSERT INTO buk_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ma ŋgac dau sa gi ma gic miŋ pi gêŋ dau e yom dau tiapa. Tu dinaŋ-ŋga lau hoŋ takwê Yisu, dec iŋ tec bu sôc malac daŋ yêc lhu. Iŋ mbo gameŋ ŋamakê-ŋga, magoc lau akêŋ gameŋ hoŋ sêwê sêtêŋ iŋ si ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Bêc ŋatô giŋga su, goc Yisu sôc malac Kapenaom tiyham. Ma lau malac-ŋga sêŋgô ŋawaê bu iŋ mbu meŋ ndöc andu daŋ. ");
INSERT INTO buk_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Goc lau daêsam sêkac dau sa, ma Yisu gêm mêtê ŋac. Lau daêsam andô sêkac sa e ŋasawa mba yêc andu ŋalôm ma yêc ŋasactô bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ma lauŋgac hale sêmbalaŋ ŋgac bôliŋ daŋ yêc sac daŋ sêmeŋ, ma bu sêtêŋ Yisu sêndi. ");
INSERT INTO buk_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Magoc lau daêsam dinaŋ sem gameŋ ahuc, ma tu dinaŋ-ŋga dec ŋac sêpi andu ŋapoc lôlôc si, ma sêkac poc sa ma sêmasaŋ ŋalasê daŋ yêc gameŋ naŋ Yisu kalhac, naŋ ŋahô-ŋga. Goc sêŋwhaŋ sac ti ŋgac bôliŋ sip têŋ Yisu gi. ");
INSERT INTO buk_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yisu gêlic gêŋ dinaŋ ma kêyalê bu ŋac sêkêŋ whiŋ iŋ, goc sôm têŋ ŋgac bôliŋ, “Aneŋ balê, kwahic dec aö wasuc am nem sac kwi.” ");
INSERT INTO buk_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Têŋ ndoc dinaŋ kêdôhôŋwaga yomsu-ŋga ŋatô sêndöc andu dau. Sêŋgô Yisu ndê yom dau, ma gauc gêm yêc ŋac si ŋalôm, ");
INSERT INTO buk_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Anötö tigeŋ gitôm bu suc sac kwi. Ma bocke ŋgac dindê sôm yom kaiŋ dinaŋ? Iŋ ndê yom sac sambuc.” ");
INSERT INTO buk_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yisu kêyalê ŋagahô bu ŋac gauc gêm yom bocdinaŋ, dec iŋ sôm têŋ ŋac, “Tu sake-ŋga mac gauc gêm yom bocdinaŋ? ");
INSERT INTO buk_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mac akêŋ whiŋ dom bu aneŋ ŋaclai yêc bu wasôm têŋ ŋgac bôliŋ dindec bu wasuc iŋ ndê sac kwi. Bocdinaŋ aö wasôm têŋ iŋ, ‘Tisa, kôc nem mbô sa ma êmsêlêŋ.’ ");
INSERT INTO buk_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ma têŋ têm mac alic aneŋ yom dau ŋandô sa, dec aŋyalê bu Anötö kêŋ ŋaclai têŋ †Ŋamalac ndê Atu yêc nom, bu suc ŋamalac si sac kwi whiŋ.” Goc Yisu sôm têŋ ŋgac bôliŋ, ");
INSERT INTO buk_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Aö wasôm têŋ am bu tisa, kôc nem mbô sa, ma lhö têŋ nem andu ndi.” ");
INSERT INTO buk_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ma ŋgac dau tisa yêc lau hoŋ aŋgô-ŋga, kôc ndê mbô sa ma kölhö gi. Gêŋ dau kôm lau hoŋ sêhêdaê ŋandô. Sêmpiŋ Anötö ma sêsôm, “Gêŋ kaiŋ dindec, yac alic daŋ su dom.” ");
INSERT INTO buk_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tiŋambu Yisu sa gi mbo bugictoŋ ŋamakê tiyham. Lau daêsam sêsa si sêŋkuc iŋ, ma iŋ kêdôhôŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ma tiŋambu iŋ kêsêlêŋ gi e gêlic †Liwai, Alpayas ndê atuŋgac ndöc ndê mala kôc takis-ŋga. Goc Yisu sôm têŋ iŋ, “Êmkuc aö.” Ma Liwai tisa ma kêkuc iŋ. ");
INSERT INTO buk_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Têŋ bêc daŋ Yisu ti iŋ ndê ŋgacsêŋomi seŋ gêŋ sêndöc Liwai ndê andu. Ma lau sêkôc takis-ŋga ma lau daêsam naŋ lau bata Israel-ŋga sêsam bu lau sac naŋ sêndöc sêwhiŋ ŋac, bu lau kaiŋ dinaŋ sêŋkuc Yisu tôm bêc hoŋ. ");
INSERT INTO buk_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ma lau †Palêsai si kêdôhôŋwaga yomsu-ŋga ŋatô sêlic bu Yisu gêŋ gêŋ ndöc whiŋ lau takis-ŋga ti lau sac dinaŋ. Goc sêsôm têŋ iŋ ndê ŋgac-sêŋomi, “Tu sake-ŋga iŋ gêŋ gêŋ whiŋ lau takis-ŋga ti lau sac?” ");
INSERT INTO buk_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yisu ŋgô yom dau, ma sôm têŋ ŋac, “Lau naŋ sêlic dau bu gêmbac mba, naŋ oc sêŋsalê dokta dom, magoc lau ti gêmbac oc sêŋsalê dokta. Aö gameŋ bu waŋgalêm lau naŋ sêlic dau bu lau gitêŋ, naŋ sa dom, aö gameŋ bu waŋgalêm lau sac sa.” ");
INSERT INTO buk_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jon, Ŋgac Kêku Lau-ŋga ndê †sêŋomi ti lau Palêsai sêkêŋ bêc ŋatô bu sêneŋ gêŋ dom tu gauc nem Anötö-ŋga, magoc Yisu ndê ŋgacsêŋomi sêkôm dom. Ma lau ŋatô sêmeŋ ma sêndac Yisu bocdec bu, “Tu sake-ŋga Jon ndê sêŋomi ma lau Palêsai si sêŋomi sêhu gêŋ daneŋ-ŋga siŋ tu gauc nem Anötö-ŋga, magoc am nem ŋgacsêŋomi sêkôm dom?” ");
INSERT INTO buk_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Goc Yisu sôm têŋ ŋac, “Ŋgac nem awhê-ŋga daŋ bu êŋgalêm lau sa sêmbo sêwhiŋ iŋ bu sêneŋ mwasiŋ nem awhê-ŋga, dec oc tôm dom bu sêhu gêŋ daneŋ-ŋga siŋ têŋ ndoc ŋgac dau mbo whiŋ ŋac. Ŋalêŋ tigeŋ kwahic dec aö gambo gawhiŋ aneŋ ŋgacsêŋomi ma oc tôm dom bu sêhu gêŋ daneŋ-ŋga siŋ. ");
INSERT INTO buk_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tigeŋ ndoc oc meŋ naŋ lau oc sêkôc aö su yêc ŋac, ma têŋ ndoc dinaŋ ŋac oc ŋalôm ŋawapac, ma sêŋkuc lêŋ dahu gêŋ daneŋ-ŋga siŋ-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ma Yisu sôm, “Yac dasi po wakuc pi ŋakwê akwa naŋ kic, naŋ dom. Bu po wakuc oc hôc ŋakwê akwa kic, ma gêŋ dau oc tisac sambuc. ");
INSERT INTO buk_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma têŋ ndoc lau s êmasaŋ wain wakuc, naŋ sêkêc sip bôc ŋamlic wain-ŋga akwa dom. Mba! Ŋac bu sêkôm, goc wain wakuc oc hôc ŋamlic akwa kôc ma wê sa niŋga. Ma bôc ŋamlic oc tisac bocdinaŋ. Wain wakuc dakêc sip bôc ŋamlic wakuc.” ");
INSERT INTO buk_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Têŋ bêc Sabat-ŋga daŋ Yisu ti ndê †ŋgacsêŋomi sêŋsêlêŋ sêmbo lôcwha daŋ naŋ gic ôm wit-ŋga daŋ kic. Ma iŋ ndê ŋgacsêŋomi sêkôc wit ŋandô ŋatô bu sêneŋ. ");
INSERT INTO buk_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ma lau Palêsai ŋatô sêlic gêŋ dau ma sêsôm têŋ iŋ, “Lic gêŋ naŋ am nem ŋgacsêŋomi sêkôm. Tu sake-ŋga ŋac sêkôm gweleŋ naŋ yac neŋ yomsu gic yao bu dakôm têŋ bêc Sabat-ŋga dom?” ");
INSERT INTO buk_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Yisu ô ŋac si yom ma sôm, “Gauc nem yom naŋ sêto pi gêŋ naŋ Kiŋ Dawid kôm. Mac asam su, me? Têŋ ndoc naŋ Abiata iŋ †dabuŋsiga ŋamata-ŋga, naŋ Dawid ti lau naŋ sêwhiŋ iŋ, naŋ sêpônda dau ma gêŋ yô ŋac. Goc Dawid sôc Anötö ndê andu gi, ma gêŋ bolom dabuŋ naŋ lau sêkêŋ ti da, naŋ Moses kêŋ yao bu lau dabuŋsiga tawasê oc sêneŋ. Ma iŋ kêŋ têŋ lau naŋ sêmbo sêwhiŋ iŋ, ma ŋac seŋ. Magoc lau daŋ sêŋgôliŋ yom pi Dawid ma sêsôm bu iŋ kêgilì yomsu lec dom.” ");
INSERT INTO buk_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ma Yisu gic têku yom ma sôm, “Bocdinaŋ akôc gauc ŋapep pi yomsu. Anötö kêŋ bêc Sabat-ŋga bu nem ŋamalac sa. Iŋ kêŋ ŋamalac tu bêc Sabat-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ŋamalac ndê Atu iŋ gêŋ hoŋ ŋadau, ma iŋ Pômdau Sabat-ŋga whiŋ.” ");
INSERT INTO buk_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Têŋ bêc daŋ tiyham Yisu sôc lôm wê-ŋga gi. Ma ŋgac amba tibalê daŋ ndöc. ");
INSERT INTO buk_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Palêsai ŋatô sêŋsalê yom bu sêŋgôliŋ pi Yisu, dec sêtip iŋ ŋapep bu mboe iŋ oc kôm ŋgac dau ŋayham sa têŋ bêc Sabat-ŋga, dec ŋac oc sêsôm bu iŋ kêgilì yomsu Sabat-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yisu sôm têŋ ŋgac naŋ amba tibalê, “Tisa, ma lhac ŋalhu whiŋ aö.” ");
INSERT INTO buk_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Dec iŋ ndac lau hoŋ bocdec bu, “Gêŋ bocke oc êŋgilì yomsu Sabat-ŋga? Dakôm ŋayham têŋ lau, me dakôm sac têŋ lau? Danem ŋamalac sa, me datec ŋac sêmbac ndu?” Magoc ŋac hoŋ sem dôŋ. ");
INSERT INTO buk_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iŋ tahê ŋac ma tac ŋandê sa, ma ŋalôm ŋawapac tu ŋac si ŋalôm ŋadandi-ŋga. Goc iŋ sôm têŋ ŋgac dau, “Êmatôc amam.” Ma ŋgac dau kêmatôc amba, ma amba dau ŋayham sa tiyham. ");
INSERT INTO buk_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Têŋ dinaŋ lau Palêsai sêhu lôm wê-ŋga dau siŋ ma sêsa si. Ma ŋac sêndöc sêwhiŋ lau Israel-ŋga naŋ tac whiŋ Herod ma lau Rom-ŋga si gôliŋ, ma ŋac hoŋ sêkôc gauc pi lêŋ sêndic Yisu ndu-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yisu ti ndê ŋgacsêŋomi sêtêŋ bugictoŋ si, ma lau daêsam sêŋkuc ŋac. Ŋac lau akêŋ gameŋ Galili-ŋga ma gameŋ Judia-ŋga, ");
INSERT INTO buk_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ma akêŋ malac Jerusalem ma akêŋ gameŋ Judia ma Idumia-ŋga ma akêŋ Bu Jordan ŋadaŋga, ma akêŋ malac Taya ma Saidon ŋagameŋ. Lau daêsam dinaŋ sêŋgô ŋawaê pi gêŋ naŋ Yisu kôm, dec sêsa sêtêŋ iŋ si. ");
INSERT INTO buk_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yisu gêlic lau toŋ atu naŋ bu sêŋgapiŋ iŋ sa, dec sôm têŋ ndê ŋgacsêŋomi bu sêmasaŋ waŋ sauŋ daŋ tu iŋ pi ndi ndöc-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Iŋ sôm yom dinaŋ ŋahu bu iŋ kôm lau gêmbac daêsam ŋayham sa su e lau daêsam ti gêmbac sêkôm mwasac bu sêmasec iŋ. ");
INSERT INTO buk_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ma têŋ ndoc lau ti ŋalau sac sêlic iŋ, naŋ sêhu dau sêyêc iŋ aŋgô-ŋga, ma ŋalau dau sêmbwêc yom asê bocdec bu, “Am Anötö ndê Atu.” ");
INSERT INTO buk_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tigeŋ Yisu kêŋ gic yao ŋaŋga bu sêsôm iŋ ŋahu asê dom. ");
INSERT INTO buk_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tiŋambu Yisu pi lôc daŋ gi ma mbwêc lau naŋ iŋ atac whiŋ, naŋ sêtêŋ iŋ sêmeŋ. ");
INSERT INTO buk_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Goc iŋ kêyaliŋ ŋac si lau 12 sa, ma sam ŋac bu †Aposel, bu ŋac oc sêmbo sêwhiŋ iŋ, ma iŋ oc kêŋ ŋac sêsa sêndi bu sênem mêtê. ");
INSERT INTO buk_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma iŋ kêŋ ŋaclai têŋ ŋac bu sêsoc ŋalau sac su. ");
INSERT INTO buk_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Aposel 12 naŋ Yisu kêyaliŋ ŋac sa, naŋ bocdec: Saimon (naŋ iŋ sam bu Pita), ");
INSERT INTO buk_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jems lu Jon (Sebedi ndê atu lu naŋ Yisu sam bu ‘wapap atui’), ");
INSERT INTO buk_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Pilip, Batolomeas, Matyu, Tomas, Jems (Alpayas ndê atu), Tadaus, Saimon (naŋ sêsam bu ‘Ŋgac †Selot’), ");
INSERT INTO buk_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma Judas Iskeriot, ŋgac naŋ tiŋambu hoc Yisu asê. ");
INSERT INTO buk_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yisu sôc andu daŋ gi, magoc lau toŋ atu sêsap iŋ dôŋ ŋapaŋ e ŋasawa mba bu iŋ ti ndê ŋgac-sêŋomi sêneŋ gêŋ. ");
INSERT INTO buk_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Gêŋ dau ŋawaê tap Yisu dinda ti asii sa, dec ŋac sêsôm, “Iŋ ndê gauc tisac.” Bocdinaŋ dec sêtêŋ iŋ si bu sêkôc iŋ sa ndi. ");
INSERT INTO buk_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Têŋ têm dinaŋ kêdôhôŋwaga yomsu-ŋga ŋatô sêmeŋ akêŋ Jerusalem ma sêŋgôliŋ yom pi Yisu bocdec bu, “Ŋalau sac si ŋadau †Belsebal gêm gôliŋ iŋ, ma kêŋ ŋaclai têŋ iŋ bu soc ŋalau sac su.” ");
INSERT INTO buk_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Goc Yisu mbwêc ŋac sêtigasuc iŋ, ma ô ŋac si yom ŋa yom gôliŋ daŋ bocdec bu, “Bocke ma Sadaŋ oc soc Sadaŋ? ");
INSERT INTO buk_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Gôliŋwaga daŋ ndê lau bu sêkêŋ kisa dau, dec iŋ ndê gôliŋ oc pacndê. ");
INSERT INTO buk_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma gôlôwac daŋ bu sêwhê dau kôc, dec oc sêlhac ŋaŋga dom. ");
INSERT INTO buk_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ma Sadaŋ bu kêŋ kisa têŋ dau ma whê dau kôc, dec iŋ oc lhac ŋaŋga dom, iŋ ndê ŋaclai oc pacndê. ");
INSERT INTO buk_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Aŋgô! Sadaŋ iŋ gitôm ŋgac ti licwalô atu, ma yac bu dasôc ŋgac ti licwalô atu daŋ ndê andu bu taŋgaho iŋ ndê gêŋ, naŋ gêŋ ŋamata-ŋga dasô iŋ dôŋ, goc taŋgaho iŋ ndê gêŋ. ");
INSERT INTO buk_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Yomandô aö wasôm têŋ mac. Ŋamalac naŋ kac ndê ŋalôm kwi ma hu ndê sac siŋ, naŋ Anötö oc suc iŋ ndê sac ti yom sac-sac hoŋ kwi. ");
INSERT INTO buk_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tigeŋ ŋamalac daŋ bu sôm yom sac pi Ŋalau Dabuŋ, naŋ Anötö oc suc iŋ ndê sac kwi dom andô. Iŋ kôm gêŋ sac sambuc, ma iŋ ndê giso oc yêc ŋapaŋ.” ");
INSERT INTO buk_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yom hoŋ dinaŋ Yisu sôm, ŋahu bu ŋac sêsôm bu ŋalau sac daŋ mbo iŋ ŋalôm. ");
INSERT INTO buk_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Têŋ têm dinaŋ Yisu dinda ti ndê asii sêhôc asê andu dau. Sêlhac awê ma sêŋkiŋ ŋamalac daŋ sôc gi bu kôc iŋ sa sa meŋ. ");
INSERT INTO buk_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lau daêsam naŋ sêndöc sêŋgihi Yisu ahuc, naŋ sêsôm têŋ iŋ bu, “Am dinam ti nem asimi dec sêmeŋ sêlhac awê ma sêndac am.” ");
INSERT INTO buk_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Goc iŋ ndac ŋac, “Aneŋ dinaŋ ti asiŋi naŋ asa?” ");
INSERT INTO buk_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ma iŋ tahê lau naŋ sêndöc sêŋgihi iŋ ahuc, ma sôm, “Aneŋ dinaŋ ti asiŋi dau dindec. ");
INSERT INTO buk_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Bu lau naŋ daŋga wambu Anötö ndê yom, naŋ ŋac sêti aö asiŋi ti lhuŋwêi ma dinaŋi.” ");
INSERT INTO buk_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tiŋambu Yisu sa gi mbo bugictoŋ ŋamakê, ma gic hu kêdôhôŋ lau tiyham. Ma lau sêwê-sêwê sêmeŋ e ti toŋ atu andô. Tu dinaŋ-ŋga iŋ pi waŋ daŋ gi poc bugictoŋ kêpiŋ baö, ma lau daêsam dinaŋ sêlhac baö. ");
INSERT INTO buk_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yisu sôm yom gôliŋ daêsam bu êndôhôŋ lau dinaŋ. Iŋ sôm yom gôliŋ daŋ têŋ ŋac bocdec bu, ");
INSERT INTO buk_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Aŋgô! Ŋgac daŋ sa gi bu êmbalip wit ŋawhê yêc iŋ ndê ôm. ");
INSERT INTO buk_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Têŋ ndoc iŋ kêbalip gêŋ dau, naŋ ŋawhê ŋatô sêpeŋ sêsip seŋ, ma mbac sêsip sêmeŋ ma seŋ su. ");
INSERT INTO buk_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma ŋawhê ŋatô sêpeŋ sêsip gameŋ hoc-hoc, naŋ nom ŋagec sac hoc ŋahô ŋambwa. Ŋawhê dau sêsip nom ŋalôm gacgeŋ si dom, dec sêpo sêpi sêmeŋ ŋagahô. ");
INSERT INTO buk_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tigeŋ tiŋambu ac pec ŋagatôm ma gêm bôliŋ. Ŋahu bu nom ŋayham mba tu ŋawakac sip ndi-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ma wit ŋawhê ŋatô sêpeŋ sêsip kwaŋ ti ŋakwa ŋalôm, ma kwaŋ lu wit sêpi sêwhiŋ dau e kwaŋ yaŋ wit ndu ma gêm ŋandô daŋ dom. ");
INSERT INTO buk_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma wit ŋawhê ŋatô sêpeŋ sêsip nom ŋayham, ma tiŋambu sem ŋandô daêsam, ŋatô sem ŋandô 30, ŋatô sem ŋandô 60, ma ŋatô sem ŋandô 100.” ");
INSERT INTO buk_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Goc Yisu sôm, “Asa bu daŋga-suŋ yêc, naŋ ŋgô aneŋ yom.” ");
INSERT INTO buk_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tiŋambu lau daêsam sêmbo dom, ma lau naŋ sêmbo sêwhiŋ Yisu, ti ŋgacsêŋomi 12 sêndac Yisu pi yom gôliŋ dau ŋahu. ");
INSERT INTO buk_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ma iŋ whê sa têŋ ŋac bocdec bu, “Anötö ndê gôliŋ ŋalêŋ ŋahu sip ŋalôm gi. Iŋ kêyaliŋ mac sa bu aŋyalê ŋahu dau, magoc lau naŋ sêmbo Anötö ndê gôliŋ ŋalôm dom, naŋ wasôm yom têŋ ŋac ŋa yom gôliŋ ŋambwa. ");
INSERT INTO buk_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Aisaya to yom pi lau kaiŋ dinaŋ, naŋ yêc bocdec bu: Ŋac sêlic gêŋ naŋ aö gakôm, naŋ ŋapaŋ, magoc ŋac si gauc sa dom. Ma ŋac sêŋgô aneŋ yom ŋapaŋ, magoc sêŋyalê ŋahu dom. Ŋac bu sêŋyalê, dec oc tôm bu sênem dau kwi, ma Anötö oc suc ŋac si sac kwi.” ");
INSERT INTO buk_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Goc Yisu sôm têŋ ŋac, “Bocke dec mac aŋyalê yom gôliŋ dinaŋ ŋahu dom? Bocdinaŋ ŋalêŋ bocke mac oc aŋyalê yom gôliŋ ŋatô ŋahu? ");
INSERT INTO buk_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Aŋgô! Yom pi ŋgac naŋ kêbalip wit ŋawhê, naŋ hêganôŋ ŋgac naŋ hoc Anötö ndê yom asê. ");
INSERT INTO buk_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ma yom pi wit ŋawhê naŋ sêpeŋ sêsip seŋ, naŋ hêganôŋ lau naŋ sêŋgô Anötö ndê yom, magoc ŋagahô Sadaŋ meŋ ma kêgaho yom dau su yêc ŋac si ŋalôm. ");
INSERT INTO buk_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ma wit ŋawhê naŋ sêpeŋ sêsip gameŋ hoc-hoc, naŋ hêganôŋ lau naŋ sêŋgô A nötö ndê yom ma sêkôc sa ŋagahô ti atac ŋayham. ");
INSERT INTO buk_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tigeŋ tôm wit naŋ ŋawakac mbasi, naŋ lau dau sêlhac ŋasawa baliŋ dom. Têŋ ndoc sêtap ŋawapac sa, me lau sêkêŋ kisa ŋac tu Anötö ndê yom-ŋga, naŋ sêhu si sêkêŋ whiŋ siŋ ŋagahô eŋ. ");
INSERT INTO buk_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ma wit ŋawhê naŋ sêpeŋ sêsip kwaŋ ti ŋakwa ŋalôm, naŋ hêganôŋ lau naŋ sêŋgô Anötö ndê yom, ");
INSERT INTO buk_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","tigeŋ sêhêgo dau pi gêŋ nom-ŋga kêlêc, ma lêŋ atac whiŋ mone ti wapa nom-ŋga hê ŋac si gauc ŋapaŋ e kôm Anötö ndê yom ahuc, ma ŋandô mbasi. ");
INSERT INTO buk_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma wit ŋawhê naŋ sêpeŋ sêsip nom ŋayham, ma sem ŋandô 30, me 60, me 100, naŋ hêganôŋ lau naŋ sêŋgô Anötö ndê yom, sêkôc sa e tidôŋ, ma sem ŋandô daêsam.” ");
INSERT INTO buk_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ma Yisu sôm têŋ ŋac, “Lam iŋ gêŋ pô gameŋ-ŋga, ma bocdinaŋ yac taŋgatöc ŋa suc ahuc me dasiŋ kwi sôc sasac ŋapu dom. Mba! Taŋkiŋ êŋgalêŋ ŋalhu bu ŋawê pô gameŋ. ");
INSERT INTO buk_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ma ŋalêŋ tigeŋ, yom naŋ yêc siŋ dau me ŋahu sip ŋalôm gi, naŋ oc meŋ sa tiawê. ");
INSERT INTO buk_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Asa naŋ daŋgasuŋ bu yêc, naŋ ŋgô.” ");
INSERT INTO buk_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ma iŋ gic têku yom ma sôm, “Akôc gauc ŋapep pi Anötö ndê yom naŋ mac aŋgô. Mac bu atac whiŋ bu aŋyalê ŋahu, dec Anötö oc kêŋ gauc têŋ mac, ma iŋ oc kôm mac nem gauc êŋsôwec tiatu. ");
INSERT INTO buk_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bu asa naŋ kôc Anötö ndê yom sa sip ndê ŋalôm e tidôŋ, naŋ Anötö oc kêŋ gauc têŋ iŋ êŋlêc. Magoc asa naŋ kôc sa tidôŋ dom, naŋ Anötö oc kôc iŋ ndê yom hoŋ su yêc iŋ.” ");
INSERT INTO buk_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ma Yisu sôm, “Ŋalêŋ naŋ Anötö ndê gôliŋ kêsôwec, naŋ gitôm gêŋ ŋawhê naŋ ŋamalac daŋ sô sip ndê ôm. ");
INSERT INTO buk_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ma tiŋambu iŋ yêc bêc ôbwêc ma tisa têŋ acsalô, ma ŋawhê dau po pi meŋ. Magoc ŋamalac dau kêyalê ŋalêŋ dom. ");
INSERT INTO buk_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Têŋ ŋamata-ŋga ŋawhê dau hôc nom kôc ma ŋagatôm pi meŋ, malô goc ŋamlha sa ma tiŋambu gêm ŋandô. ");
INSERT INTO buk_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Magoc têŋ ndoc gêŋ ŋandô dau tilôwê iŋ oc ndic su, bu bêc sêhoŋ gêŋ ŋandô sa-ŋga meŋ sa.” ");
INSERT INTO buk_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ma Yisu sôm, “Aö wasôm yom gôliŋ bocke tu bu wawhê ŋalêŋ naŋ Anötö ndê gôliŋ kêsôwec, naŋ sa? Aö wanem dôhôŋ pi gêŋ sake bu wawhê sa? ");
INSERT INTO buk_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Anötö ndê gôliŋ gitôm gêŋ ŋawhê sauŋ andô daŋ naŋ dasô sip nom, gitôm a soc ŋawhê. ");
INSERT INTO buk_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Gêŋ dau gêŋ sauŋ andô, tigeŋ yac bu dasô sip nom ndi, dec oc po tiatu e hôc gêlêc gêŋ ôm-ŋga hoŋ su. Ma ŋasaŋgac oc sêhê baliŋ e mbac lôlôc-ŋga sêmeŋ sêhê si ŋaic yêc ayuŋ ŋayham dau.” ");
INSERT INTO buk_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yom gôliŋ kaiŋ dinaŋ Yisu sôm têŋ lau ŋapaŋ. Iŋ kêdôhôŋ ŋac tôm ŋac si gauc. ");
INSERT INTO buk_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yom hoŋ naŋ iŋ sôm têŋ ŋac, naŋ iŋ sôm ŋa yom gôliŋ. Ma têŋ têm naŋ iŋ ti ndê ŋgacsêŋomi sêmbo tawasê, naŋ iŋ whê gêŋ hoŋ sa têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Têŋ acsalô dinaŋ kêpiŋ bu ŋasec sa, naŋ Yisu sôm têŋ iŋ ndê ŋgacsêŋomi, “Yac dalhö, dapi bugictoŋ ŋadaŋga dandi.” ");
INSERT INTO buk_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Goc sêhu lau toŋ atu dinaŋ siŋ ma sêkôc Yisu whiŋ ŋac sêpi waŋ daŋ ma sêlhö si. Ma waŋ ŋatô sêlac sêwhiŋ. ");
INSERT INTO buk_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Sêlac si ma mbu puc atu ma gêli bu ŋampoŋ sa gic sip waŋ e kêpiŋ bu waŋ pac. ");
INSERT INTO buk_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Magoc Yisu teŋ gwalim ma yêc bêc yêc waŋku-ŋga. Ŋgacsêŋomi sêuŋ iŋ sa, ma sêsôm têŋ iŋ, “Kêdôhôŋwaga, bocke? Am hêgo daôm dom bu yac oc dandiŋaŋ, a?” ");
INSERT INTO buk_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Goc iŋ tisa, ma sôm yom ŋaŋga têŋ mbu ti bu ŋampoŋ bocdec bu, “Naŋ gitôm! Timalô!” Goc mbu timalô ma gameŋ ŋaŋeŋ sa. ");
INSERT INTO buk_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ma iŋ sôm têŋ ŋac bu, “Tu sake-ŋga mac atöc daôm kêlêc? Bocke? Mac akêŋ whiŋ aö dom, a?” ");
INSERT INTO buk_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Magoc ŋac sêsö ti sêtöc dau ŋandô ma sêndac dandi, “Iŋ asa dec? Gêŋ hoŋ sêsôc iŋ ndê yom ŋapu, ma mbu ti bu ŋampoŋ sêwhiŋ!” ");
INSERT INTO buk_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yisu ti ndê ŋgacsêŋomi sêhôc asê Bugictoŋ Galili-ŋga ŋadaŋga têŋ gameŋ ac pi-ŋga, ma sêsôc baö yêc lau Gerasa-ŋga si gameŋ. ");
INSERT INTO buk_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Sêpi baö si, ma ŋgac daŋ naŋ ŋalau sac mbo iŋ ndê ŋalôm, naŋ sa akêŋ ôm sêhô-ŋga ma têŋ Yisu gi. ");
INSERT INTO buk_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Iŋ ŋgac dau êlêmê ndöc ôm sêhô-ŋga, ma têm daêsam lau sêŋsahê bu sêsô iŋ dôŋ ŋa wac me ŋa sen, magoc gitôm dom. ");
INSERT INTO buk_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Têm daêsam sêsô iŋ amba ti gahi dôŋ ŋa sen, magoc iŋ hê sen kic ma seŋ gapocwalô gahi-ŋga su. Lau daŋ sêtôm dom bu sêkôm iŋ timalô. ");
INSERT INTO buk_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Têŋ acsalô ti ôbwêc, iŋ mbo ôm sêhô-ŋga ti gameŋ ŋabaö, ma taŋ asê ma kôc hoc ma tuc-tuc dau ŋamlic tisac. ");
INSERT INTO buk_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Têŋ têm dinaŋ iŋ gêlic Yisu kalhac ahê, goc kêti gi ma pôŋ haduc yêc iŋ aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ma Yisu sôm têŋ iŋ, “Ŋalau sac, am hu ŋgac dinaŋ siŋ.” Dec ŋalau dau mbwêc atu ma sôm, “Yisu, Anötö Ŋaclai ti Ŋawasi Ŋadau ndê Atu, am bu kôm sake têŋ aö? Tu Anötö ndê ŋaê-ŋga, aö wateŋ am bu kôm aö ŋayom dom.” ");
INSERT INTO buk_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Goc Yisu ndac iŋ, “Am nem ŋaê asa?” Ma ŋalau sac ô yom ma sôm, “Aneŋ ŋaê ‘Toŋ Atu,’ bu yac ŋalau daêsam.” ");
INSERT INTO buk_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma ŋalau dau teŋ Yisu tidim daêsam, bu soc ŋac su yêc gameŋ dinaŋ dom. ");
INSERT INTO buk_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Têŋ têm dinaŋ bôc toŋ atu seŋ gêŋ sêmbo lôc ŋapu yêc gameŋ dinaŋ. ");
INSERT INTO buk_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Goc ŋalau sac sêteŋ Yisu ma sêsôm, “Êmkiŋ yac atêŋ bôc dindê andi, bu yac asôc bôc si ŋalôm.” ");
INSERT INTO buk_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yisu gôlôc goc ŋalau sac sêhu ŋgac dinaŋ siŋ, ma sêsôc bôc ŋalôm si. Goc bôc hoŋ sênti si e sêsip salic sac, ma sêsip bugictoŋ e bu kô ŋac sêmbac ndu. Bôc dau toŋ atu, ŋanamba gitôm 2,000. ");
INSERT INTO buk_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Goc lau sêyob bôc-ŋga sênti si, ma sic miŋ yom dinaŋ têŋ lau naŋ sêmbo malac atu ti gameŋ ŋamakê-ŋga. Ma lau dau sêsa si bu sêlic gêŋ naŋ Yisu kôm. ");
INSERT INTO buk_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sêhôc asê iŋ ma sêlic ŋgac naŋ Yisu soc ŋalau sac toŋ atu dinaŋ su yêc iŋ, naŋ ndöc ti gauc ŋawa ma sôc ŋakwê, dec ŋac sêtöc dau. ");
INSERT INTO buk_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ma lau naŋ sêlic gêŋ dau, naŋ sic miŋ pi gêŋ naŋ Yisu kôm têŋ ŋgac ti ŋalau sac, ma têŋ bôc. ");
INSERT INTO buk_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Goc lau gameŋ dinaŋ-ŋga sêteŋ Yisu ŋaŋga bu hu ŋac si gameŋ siŋ. ");
INSERT INTO buk_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Têŋ ndoc Yisu bu pi waŋ ndi, naŋ ŋgac naŋ iŋ soc ŋalau sac su yêc iŋ, naŋ teŋ iŋ ŋaŋga bu whiŋ iŋ ndi. ");
INSERT INTO buk_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Magoc Yisu sôm, “Mba! Am mbu têŋ nem lau ndi, ma ndic miŋ têŋ ŋac pi ŋalêŋ naŋ Pômdau tawalô am, ma pi gêŋ hoŋ naŋ iŋ kôm têŋ am.” ");
INSERT INTO buk_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Goc ŋgac dau kölhö gi, ma kêgihi gameŋ naŋ sêsam bu Dekapolis, ma gic miŋ yom pi gêŋ atu naŋ Yisu kôm têŋ iŋ. Ma lau hoŋ sêhêdaê. ");
INSERT INTO buk_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yisu ti ndê ŋgacsêŋomi sêpi waŋ ma sêmbu sêpi bugictoŋ ŋadaŋga si. Ma têŋ ndoc iŋ sip baö gi, naŋ lau toŋ atu sêkac sa e sêŋgihi iŋ ahuc. ");
INSERT INTO buk_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ma ŋgac daŋ ŋaê Jairas, naŋ yob lau Israel-ŋga si lôm wê-ŋga yêc gameŋ dinaŋ, naŋ meŋ hôc asê. Iŋ gêlic Yisu goc hu dau sip nom yêc iŋ gahi-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ma iŋ teŋ iŋ ŋaŋga bocdec bu, “Aneŋ bawhê sauŋ gêmbac atu kêpiŋ bu oc mbac ndu. Aö tac whiŋ bu am mweŋ, kêŋ amam sac iŋ tu bu iŋ mbac ndu dom, ma ŋayham sa tiyham.” ");
INSERT INTO buk_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Goc Yisu whiŋ iŋ gi. Yisu kêsêlêŋ mbo, ma lau daêsam sêŋkuc iŋ ma sêŋgihi iŋ ahuc. ");
INSERT INTO buk_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Lau toŋ dinaŋ si daŋ iŋ awhê naŋ gêm dac ŋapaŋ tôm yala 12. ");
INSERT INTO buk_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Iŋ kêsalê dokta daêsam bu sênem iŋ sa, ma gêmlhi ŋac e iŋ ndê mone hoŋ pacndê. Magoc ŋac sêtôm dom bu sênem iŋ sa. Iŋ hôc ŋandê atu tu ŋac-ŋga, ma gêmbac dau hôc gêlêc su. ");
INSERT INTO buk_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Awhê dau ŋgô Yisu ŋawaê su, dec gauc gêm têŋ dau bu, “Aö bu wamasec iŋ ndê ŋakwê, dec oc kôm aö ŋayham sa.” Tu dinaŋ-ŋga iŋ kêsêlêŋ yêc lau toŋ atu ŋalôm kêkuc iŋ, ma kêmasec iŋ ndê ŋakwê. ");
INSERT INTO buk_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ma ŋagahô eŋ iŋ ndê dac sa tiyham dom, ma iŋ kêsahê bu iŋ ndê gêmbac pacndê su. ");
INSERT INTO buk_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yisu kêyalê bu ŋaclai sa yêc iŋ, goc ŋagahô iŋ kac dau kwi yêc lau toŋ atu ŋalôm ma ndac, “Asa kêmasec aö neŋ ŋakwê?” ");
INSERT INTO buk_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Magoc iŋ ndê ŋgacsêŋomi sêô yom ma sêsôm, “Lic lau daêsam dindec s êkôm am si. Bocke dec am ndac bu ŋac si asa kêmasec am?” ");
INSERT INTO buk_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Magoc Yisu taso lau hoŋ, ma kêsalê ŋamalac naŋ kôm gêŋ dau. ");
INSERT INTO buk_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Awhê dau kêyalê bu iŋ ŋayham sa su, dec têŋ Yisu gi ma pôŋ haduc yêc iŋ aŋgô-ŋga. Iŋ töc dau ti kêtitec mbo, ma hoc yom asê pi gêŋ naŋ iŋ kôm. ");
INSERT INTO buk_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Goc Yisu sôm teŋ iŋ, “O aneŋ bawhê, am nem kêŋ whiŋ aö dec kôm am ŋayham sa. Am ndi ti atac malô, kwahic dec am nem ŋawapac pacndê su.” ");
INSERT INTO buk_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yisu sôm yom dinaŋ mbo, ma lau ŋatô sêmeŋ akêŋ Jairas ndê andu, ma sêsôm têŋ iŋ, “Am atômwê mbac ndu su. Tu sake-ŋga am bu kêŋ ŋawapac têŋ Kêdôhôŋ-waga? Sôm têŋ iŋ bu meŋ dom.” ");
INSERT INTO buk_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tigeŋ Yisu hêgo dau tu ŋac si yom-ŋga dom, ma sôm têŋ Jairas, “Töc daôm dom, kêŋ whiŋ.” ");
INSERT INTO buk_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Goc Yisu kalhac lau hoŋ ahuc, ma kôc Pita, ma Jems lu ndê asidôwa Jon, ma sêwhiŋ Jairas si. ");
INSERT INTO buk_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Sêŋsêlêŋ si e sêhôc asê Jairas ndê andu, ma Yisu gêlic lau sêkôm ŋanta atu, ŋac sêhu daŋgibo asê ma sêtaŋ. ");
INSERT INTO buk_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Goc iŋ sôc gi ma ndac ŋac, “Mac akôm ŋanta ti daŋgibo atu dindec tu sake-ŋga? Bawhê dau mbac ndu dom, iŋ yêc bêc naŋ yêc.” ");
INSERT INTO buk_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Magoc ŋac sêmbwac iŋ. Yisu kêŋ ŋac sêsa awê si, ma kôc bawhê ŋadamba lu dinda ti ŋgacsêŋomi tö dinaŋ sêwhiŋ iŋ si, ma sêsôc ŋalôm naŋ bawhê yêc. ");
INSERT INTO buk_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Iŋ kêm bawhê dau sip amba ma sôm têŋ iŋ, “Talita, k umi.” (Yom Hibru dau danem kwi bu, ‘Bawhê sauŋ, am tisa.’ ) ");
INSERT INTO buk_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ma ŋagahô eŋ bawhê dau, naŋ ndê yala ti 12, naŋ tisa ma kêsêlêŋ. Ma lau hoŋ naŋ sêlic gêŋ dau, naŋ sêhêdaê ŋandô. ");
INSERT INTO buk_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Magoc Yisu kêŋ yao ŋaŋga bu sêsôm gêŋ dau asê têŋ lau ŋatô dom. Ma iŋ sôm bu sêkêŋ gêŋ daneŋ-ŋga têŋ bawhê dau neŋ. ");
INSERT INTO buk_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yisu mbu têŋ iŋ ndê malac-hu gi, ma iŋ ndê ŋgacsêŋomi sêŋkuc iŋ. ");
INSERT INTO buk_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Têŋ bêc Sabat-ŋga daŋ iŋ sôc lôm wê-ŋga gi, ma gic hu kêdôhôŋ lau. Ma lau daêsam naŋ sêŋgô iŋ ndê yom, naŋ sêhêdaê ma sêsôm têŋ dandi, “Aluê! Iŋ ŋgac dec tap gêŋ hoŋ dindec sa yêc nde? Asa kêŋ gauc atu-tu dinaŋ têŋ iŋ, ma ŋaclai tu kôm gêŋ dalô-ŋga? ");
INSERT INTO buk_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Iŋ yac neŋ ŋgac naŋ muŋ-ŋga kôm gweleŋ kapenta-ŋga. Iŋ Maria ndê atuŋgac, ma Jems, Josep, Judas ma Saimon dôwa! Ma iŋ ndê lhuwêi sêmbo sêwhiŋ yac.” Ma ŋac atac lu-lu tu iŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Goc Yisu sôm têŋ ŋac, “Lau hoŋ sêtoc propet daŋ sa, tigeŋ yêc iŋ ndê malachu, iŋ ndê asidôwai ma iŋ dau ndê lau sêtoc iŋ sa dom.” ");
INSERT INTO buk_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ma yêc gameŋ dinaŋ iŋ gitôm dom bu kôm gêŋ dalô daêsam. Iŋ kêŋ amba sac lau gêmbac tigeŋ-tigeŋ, ma kôm ŋac ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ma iŋ hêdaê bu ŋac sêkêŋ whiŋ iŋ dom. Tiŋambu iŋ kêsêlêŋ golom-golom malac, ma kêdôhôŋ lau. ");
INSERT INTO buk_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yisu mbwêc ndê ŋgacsêŋomi 12 sêtêŋ iŋ sêmeŋ, ma iŋ kêkiŋ ŋac lu-lu sêsa sêtêŋ malac ŋatô si, bu sênem mêtê lau. Ma iŋ kêŋ ŋaclai têŋ ŋac bu sêsoc ŋalau sac su yêc lau. ");
INSERT INTO buk_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Iŋ kêkiŋ ŋac ti sôm yom têŋ ŋac bocdec bu, “Aŋsêlêŋ andi, magoc akôc wapa daêsam dom. Asôc nem atapa ma akôc nem tôc, dec tôm. Ampwic hacgêlê dom, ma akôc gêŋ daneŋ-ŋga me awa me ŋakwê aô daôm-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Têŋ ndoc mac asôc malac daŋ andi, ma lau sêkôc mac sa asôc ŋac si andu, naŋ ambo whiŋ ŋac e mac ahu malac dau siŋ. ");
INSERT INTO buk_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma lau malac daŋ-ŋga bu sêkôc mac ti nem yom sa dom, goc atoŋ kop su yêc gahim têŋ ndoc mac ahu ŋac siŋ, bu atôc ŋac si giso asê.” ");
INSERT INTO buk_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Goc ŋac sêlhö si ma sem mêtê bu lau sênem si ŋalôm kwi ma sêhu mêtê sac siŋ. ");
INSERT INTO buk_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Sêsoc ŋalau sac daêsam su yêc lau, ma sêmbac olib ŋakwi pi lau gêmbac daêsam ma sêkôm ŋac ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Lau sic miŋ pi Yisu ŋapaŋ e iŋ ndê waê tiapa, ma Kiŋ Herod ŋgô ŋawaê pi iŋ whiŋ. Lau ŋatô sêsôm bu, “Yisu iŋ Jon, Ŋgac Kêku Lau-ŋga, naŋ tisa akêŋ lau batê-ŋga, ma bocdinaŋ iŋ kôc ŋaclai bu kôm gêŋ dalô.” ");
INSERT INTO buk_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ma ŋatô sêsôm, “Mba! Iŋ ŋgac dec iŋ propet Elaija naŋ tisa akêŋ lau batê-ŋga.” Ma ŋatô sêsôm, “Mba! Iŋ propet daŋ tôm propet akwa-kwa.” ");
INSERT INTO buk_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Magoc têŋ têm Herod ŋgô yom dinaŋ pi Yisu, naŋ iŋ sôm, “Ŋgac dê mboe Jon, ŋgac naŋ aö gatim iŋ kachu kic, naŋ tisa akêŋ lau batê-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Muŋ-ŋga, Herod kôc iŋ asi Pilip ndê awhê Herodias ma gêm ti ndê awhê. Dec Jon hoc Herod ndê giso asê ma sôm têŋ iŋ, “Am gêm nem asim ndê awhê, dec kôm gêŋ so sambuc.” Tu dinaŋ-ŋga Herod kêkiŋ ndê lau siŋ-ŋga bu sêkôc Jon dôŋ, ma sêkêŋ iŋ ndöc gapocwalô. ");
INSERT INTO buk_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tu Jon ndê yom-ŋga, Herodias êlêmê tac ŋandê têŋ iŋ ma tac whiŋ bu sêndic iŋ ndu. Magoc iŋ gitôm dom, ");
INSERT INTO buk_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","bu Herod kêyalê bu Jon iŋ ŋgac gitêŋ ti dabuŋ, dec töc Jon ma yob iŋ ŋapep. Herod tac whiŋ bu ŋgô Jon ndê yom, magoc Jon ndê yom kôm iŋ gauc gêm yom daêsam. ");
INSERT INTO buk_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tiŋambu Herodias tap lêŋ daŋ sa bu lau sêndic Jon ndu. Têŋ Herod ndê bêc dinda kôc iŋ-ŋga, naŋ Herod ndê mwasiŋ daŋ ma kêgalêm iŋ ndê lau atu-tu, ti lau bata siŋ-ŋga, ma lau bata Galili-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ŋac sêndöc mwasiŋ dau ŋalôm ma Herodias atuwê sôc meŋ ma tê wê. Gêŋ dau kôm Kiŋ Herod ti ndê ŋacleŋ hoŋ atac ŋayham kêlêc. Goc iŋ sôm têŋ bawhê dau, “Am ndac gêŋ bocke naŋ am atac whiŋ, ma wakêŋ têŋ am.” ");
INSERT INTO buk_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma iŋ kêmatiŋ yom têŋ iŋ bocdec bu, “Gêŋ naŋ am bu ndac, naŋ aö wakêŋ têŋ am, tôm aö wawhê neŋ wapa hoŋ kôc ndi toŋ lu ma wakêŋ toŋ daŋ têŋ am.” ");
INSERT INTO buk_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Goc bawhê dau sa gi ma ndac dinda, “Aö wandac gêŋ sake?” Ma dinda ô yom ma sôm, “Am ndac Jon, Ŋgac Kêku Lau-ŋga ndê ŋagôlôŋ.” ");
INSERT INTO buk_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Goc bawhê dau kac dau kwi ma kêti mbu têŋ Kiŋ Herod gi, ma sôm têŋ iŋ bu, “Aö tac whiŋ bu kwahic dec, am tim Jon, Ŋgac Kêku Lau-ŋga ndê kachu kic, goc kêŋ iŋ ndê ŋagôlôŋ sip pele daŋ ma kêŋ têŋ aö, bu walic pi tanôŋ bu iŋ mbac ndu ŋandô.” ");
INSERT INTO buk_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yom dau kôm Kiŋ Herod ŋalôm ŋawapac atu, tigeŋ tu iŋ kêmatiŋ yom yêc ŋacleŋ hoŋ aŋgô-ŋga, dec kôm tôm bawhê dau ndac. ");
INSERT INTO buk_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ma ŋagahô iŋ kêkiŋ ŋgac daŋ bu ndic Jon ndu ma kôc iŋ ŋagôlôŋ mbu meŋ. Ŋgac dau sôc gapocwalô gi, tim Jon ndê kachu kic, ");
INSERT INTO buk_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ma kêŋ ŋagôlôŋ sip pele daŋ. Goc kôc sa gi kêŋ têŋ bawhê, ma bawhê kêŋ têŋ dinda gêlic. ");
INSERT INTO buk_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Têŋ têm Jon ndê sêŋomi sêŋgô gêŋ dau ŋawaê, naŋ sêmeŋ ma sêkôc iŋ ndê ŋamlaŋ sa, ma si sêŋsuhuŋ. ");
INSERT INTO buk_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ŋgacsêŋomi naŋ Yisu kêkiŋ ŋac sêsa si, naŋ sêmbu sêtêŋ iŋ sêmeŋ, ma sic miŋ pi gêŋ hoŋ naŋ sêkôm, ma yom naŋ sêndôhôŋ têŋ lau. ");
INSERT INTO buk_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Têŋ têm dinaŋ lau daêsam sêwê sêtêŋ Yisu sêmeŋ ŋapaŋ, dec ŋasawa mba bu iŋ ti ndê lau sêneŋ gêŋ. Tu dinaŋ-ŋga dec iŋ sôm têŋ ŋac, “Mac tamwasêm awhiŋ aö, ma yac dasa gameŋ sawa daŋ dandi, ma taŋwhaŋ dauŋ.” ");
INSERT INTO buk_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bocdinaŋ ŋac sêpi waŋ daŋ bu sêlhö sêtêŋ gameŋ sawa daŋ sêndi. ");
INSERT INTO buk_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Magoc lau daêsam sêlic ŋac sêpi waŋ ma sêŋyalê bu Yisu ti ndê lau. Bocdinaŋ lau akêŋ malac hoŋ yêc gameŋ dinaŋ sêŋkuc ŋac, sênti sêmbo baö ma sêhôc gêlêc ŋac. ");
INSERT INTO buk_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Têŋ têm Yisu ti ndê ŋgac-sêŋomi sêsôc baö si, iŋ gêlic lau daêsam dinaŋ ma tawalô ŋac, bu ŋac sêtôm domba naŋ si ŋgac yob ŋac-ŋga mba. Dec iŋ gic hu kêdôhôŋ yom daêsam têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Sêmbo e telha sa, goc Yisu ndê ŋgacsêŋomi sêtêŋ iŋ si ma sêsôm, “Gameŋ dindec gameŋ sawa, ma ac pacndê. ");
INSERT INTO buk_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kêŋ lau dau sêlhö sêtêŋ malac ti gameŋ ŋamakê-ŋga sêndi, bu sênemlhi gêŋ sêneŋ-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Magoc Yisu sôm, “Mba! Mac daôm akêŋ gêŋ têŋ ŋac sêneŋ.” Ma ŋac sêô yom ma sêsôm, “Lau dindec ŋac lau daêsam andô! Yac bu anemlhi bolom ŋa mone atu gitôm †denarii 200, dec oc tôm bu ŋac hoŋ sêneŋ ŋagec-ŋagec. Yac akôm bocdinaŋ, a?” ");
INSERT INTO buk_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","M a iŋ ndac, “Mac nem bolom hiŋga ndöc? Andi alic.” Ma ŋac si sêlic goc sêmbu sêmeŋ ma sêsôm, “Yac mba bolom limdaŋ, ma i lu sêndöc.” ");
INSERT INTO buk_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Goc Yisu sôm têŋ ŋac bu sêkêŋ lau hoŋ sêndöc sic titoŋ-titoŋ sêndöc kwaŋ. ");
INSERT INTO buk_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ma lau hoŋ sêndöc sic titoŋ-titoŋ, toŋ ŋatô gitôm lau 100, ma ŋatô gitôm 50. ");
INSERT INTO buk_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Goc Yisu kôc bolom limdaŋ ma i lu sa, tatac undambê ma gêm mbec, goc pô bolom kôc-kôc, ma kêŋ têŋ ŋgacsêŋomi bu sêndic sam têŋ lau. Goc iŋ kôm bocdinaŋ pi i lu. ");
INSERT INTO buk_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Lau hoŋ seŋ gêŋ e hôc ŋac dôŋ. ");
INSERT INTO buk_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ma tiŋambu ŋgacsêŋomi sic bolom ti i ŋadêlê sa sip gatop 12 e meŋhu. ");
INSERT INTO buk_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Yisu gôlôm lau toŋ atu dinaŋ, ma lauŋgac naŋ sêmbo toŋ dau ŋalôm ma seŋ gêŋ, naŋ si namba gitôm 5,000. ");
INSERT INTO buk_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Têŋ têm dinaŋ Yisu kêŋ ndê ŋ gacsêŋomi sêpi waŋ daŋ si, ma kêkiŋ ŋac sêmuŋ iŋ sêpi bugictoŋ ŋadaŋga, bu sêtêŋ malac Betsaida sêndi. Ma iŋ dau mbo baö bu kêŋ lau toŋ atu dinaŋ sêlhö si. ");
INSERT INTO buk_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Iŋ hu ŋac siŋ su, goc pi lôc daŋ gi bu teŋ mbec. ");
INSERT INTO buk_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ŋasec sa su, ma waŋ dau sa bugictoŋ ŋalhu, ma Yisu tawasê mbo baö. ");
INSERT INTO buk_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Iŋ gêlic ndê ŋgac-sêŋomi sêhêc waŋ ŋaŋga, bu mbu atu kêsêlêŋ ma puc ŋac dôŋ. Têŋ ôbwêc lôm iŋ kêsêlêŋ mbo bu ŋahô, ma sa têŋ ŋac gi. Iŋ bu hôc gêlêc ŋac, ");
INSERT INTO buk_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","magoc têŋ ndoc sêlic iŋ kêsêlêŋ mbo bu ŋahô, ŋac gauc gêm bu sêlic ŋalau daŋ. Ŋac sêmbwêc atu, ");
INSERT INTO buk_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","bu ŋac hoŋ sêlic iŋ ma sêtöc dau. Magoc ŋagahô iŋ sôm yom têŋ ŋac bu, “Ŋalôm pêŋ dôŋ ma atöc daôm dom, bu aö dauŋ dindec!” ");
INSERT INTO buk_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Goc iŋ kêsêlêŋ têŋ ŋac ma pi waŋ gi. Ma mbu timalô ma binôŋ sip. Ŋac sêhêdaê ŋandô, ");
INSERT INTO buk_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ŋahu bu ŋac sêlic gêŋ naŋ iŋ kôm pi bolom ti i, magoc ŋac si gauc sa dom pi iŋ ndê ŋaclai. Ŋac si ŋalôm ŋadandi. ");
INSERT INTO buk_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ŋac sêhôc asê malac Genesaret yêc bugictoŋ ŋadaŋga, ma sêsô waŋ dôŋ. ");
INSERT INTO buk_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ŋac sêsip baö si ma ŋagahô lau sêŋyalê bu Yisu. ");
INSERT INTO buk_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Goc sênti sêtêŋ malac hoŋ yêc gameŋ dinaŋ, ma sêkêŋ Yisu ŋawaê. Ma tiŋambu lau sêmbalaŋ si lau gêmbac sêtêŋ malac bocke naŋ sêŋgô bu Yisu mbo. ");
INSERT INTO buk_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ma malac atu ti sauŋ, me gameŋ ŋamakê-ŋga bocke naŋ Yisu mbo, naŋ lau sêtoc si lau gêmbac sêyêc maket ŋamala, ma sêteŋ Yisu bu ŋac sêmasec iŋ me bu sêmasec iŋ ndê ŋakwê ŋambwa. Ma lau hoŋ naŋ sêmasec iŋ, naŋ ŋamlic ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Lau Palêsai ti kêdôhôŋwaga yomsu-ŋga ŋatô akêŋ Jerusalem sêtêŋ Yisu si. ");
INSERT INTO buk_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ma ŋac sêlic bu iŋ ndê ŋgacsêŋomi ŋatô sêŋgwasiŋ amba dom ma seŋ gêŋ. Bocdinaŋ ŋac gauc gêm bu ŋgac-sêŋomi si amba ŋadômbwi. ");
INSERT INTO buk_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ŋac gauc gêm yom dinaŋ, ŋahu bu lau Palêsai ti lau Israel-ŋga daêsam sêŋkuc mêtê naŋ lau andô sic dulu têŋ ŋac, bu sêŋgwasiŋ amba muŋ su, goc sêneŋ gêŋ. ");
INSERT INTO buk_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ma têŋ ndoc sêmbu akêŋ maket sêmeŋ, naŋ sêŋgwasiŋ amba muŋ, goc sêneŋ gêŋ. Ma ŋac sêŋgwasiŋ laclhu ti akôp ma suc, ma sêŋkuc mêtê kaiŋ dinaŋ daêsam, naŋ lau andô Israel-ŋga sic dulu têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Bocdinaŋ lau Palêsai ti kêdôhôŋ-waga yomsu-ŋga dinaŋ sêndac Yisu, “Tu sake-ŋga am nem ŋgac-sêŋomi sêŋkuc ŋagôliŋ naŋ lau andô sic dulu têŋ yac, naŋ dom, ma seŋ gêŋ ti amba ŋadômbwi?” ");
INSERT INTO buk_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ma Yisu ô yom ma sôm, “Propet Aisaya hoc yom asê muŋ su, naŋ hêganôŋ mac lau atim yom lau-ŋga solop. Yom dau sêto yêc bocdec bu: Lau dindec sêtoc aö sa ŋa whasuŋ ŋambwa, tigeŋ ŋac si ŋalôm yêc daŋ dau-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ŋac sem akiŋ aö ŋandô dom, ma yom naŋ sêndôhôŋ têŋ lau, naŋ ŋamalac si yomsu ŋambwa.” ");
INSERT INTO buk_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Goc Yisu gic têku yom ma sôm, “Mac ahu Anötö ndê yomsu siŋ, ma asap ŋamalac ŋambwa si ŋagôliŋ dôŋ. ");
INSERT INTO buk_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mac alic ŋayham bu asap mac daôm nem ŋagôliŋ dôŋ, magoc atec Anötö ndê yomsu, a? ");
INSERT INTO buk_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Bu Moses to Anötö ndê yomsu bocdec bu, ‘Toc damam lu dinam sa.’ Ma iŋ to yom daŋ whiŋ bocdec bu, ‘Ŋgac daŋ bu sôm yom sac pi iŋ damba lu dinda, naŋ lau sêndic iŋ ndu maŋ.’ ");
INSERT INTO buk_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Tigeŋ mac andôhôŋ lau bu sêŋgilì yomsu dinaŋ. Ŋamalac daŋ ndê awa me gêŋ bu yêc bu nem damba lu dinda sa, magoc iŋ bu ndic yao gêŋ dau ma sôm têŋ iŋlu, ‘Gêŋ naŋ bu nem amlu sa, naŋ gasam bu Koban.’ (Yom Koban dinaŋ ŋahu bu iŋ kêyaliŋ gêŋ dau sa bu kêŋ ti da têŋ Anötö.) ");
INSERT INTO buk_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tu dinaŋ-ŋga iŋ gêm iŋ damba lu dinda sa dom, ma mac alic ŋayham. ");
INSERT INTO buk_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ŋalêŋ dinaŋ mac aseŋ Anötö ndê yom popoc ma aŋkuc lau andô si ŋagôliŋ naŋ apami sic dulu têŋ mac. Mac akôm mêtê daêsam gitôm dinaŋ.” ");
INSERT INTO buk_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Goc Yisu ta lau hoŋ sêtêŋ iŋ sêmeŋ tiyham, ma sôm, “Mac lau hoŋ, aŋgô ma aŋyalê. ");
INSERT INTO buk_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Gêŋ hoŋ naŋ yêc awê ma sip ŋamalac ŋatac ŋalôm, naŋ ŋadaŋ kôm iŋ ŋadômbwi sa yêc Anötö aŋgô-ŋga dom. Magoc mêtê ti gauc sac naŋ meŋ akêŋ ŋamalac ŋalôm, naŋ kôm iŋ ŋadômbwi sa yêc Anötö aŋgô-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tiŋambu Yisu hu lau dinaŋ siŋ ma iŋ ti ndê ŋgacsêŋomi sêsôc andu daŋ si. Goc sêndac iŋ pi yom gôliŋ dinaŋ ŋahu. ");
INSERT INTO buk_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ma iŋ ndac ŋac, “Bocke dec mac atôm lau ŋatô naŋ si gauc sa dom? Alic bu gêŋ n aŋ yêc awê, ma sip ŋamalac ŋatac ŋalôm, naŋ oc kôm iŋ ŋadômbwi sa dom. ");
INSERT INTO buk_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ŋahu bu gêŋ dinaŋ sip iŋ ŋalôm ti gauc dom, magoc sip iŋ ŋatac ŋalôm goc tiŋambu sa meŋ tiyham.” (Yisu ndê yom dinaŋ tôc asê bu Anötö gic yao gêŋ daneŋ-ŋga daŋ bu gêŋ ŋadômbwi dom.) ");
INSERT INTO buk_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ma iŋ gic têku yom ma sôm, “Gêŋ sac bocke naŋ sa yêc ŋamalac si ŋalôm me whasuŋ, naŋ kôm iŋ ŋadômbwi sa yêc Anötö aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Mêtê sac daêsam ŋahu yêc ŋamalac si ŋalôm. Gauc sac, mêtê sênem kaŋ gêŋ-ŋga, sêndic ŋamalac ndu-ŋga, mêtê mockaiŋ-ŋga naŋ lau naŋ sem dau sa su, ma lau naŋ sem dau sa su dom naŋ sêkôm, lêŋ atac whiŋ awa ti wapa-ŋga, mêtê sêlic lau sac-ŋga ti sêŋsau lau-ŋga, mêtê sêneŋ gêŋ ŋawahô-ŋga, mêtê ŋalôm ŋagalac-ŋga ti mêtê lêmuŋ-ŋga, ma sêsôm yom sac-sac-ŋga, mêtê sêtoc dau sa-ŋga, ma lêŋ gauc mbasi-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mêtê sac kaiŋ dinaŋ hoŋ ŋahu yêc ŋamalac si ŋalôm, ma kôm ŋac ŋadômbwi sa yêc Anötö aŋgô-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yisu ti ndê ŋgacsêŋomi sêhu gameŋ dinaŋ siŋ, ma sêtêŋ gameŋ naŋ yêc kêpiŋ malac Taya ma sêsôc andu daŋ si. Iŋ tec bu lau daŋ sêŋyalê gameŋ naŋ iŋ mbo, magoc iŋ gitôm dom bu siŋ dau. ");
INSERT INTO buk_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Awhê daŋ mbo gameŋ dinaŋ, naŋ ŋalau sac daŋ mbo iŋ atuwê ŋalôm. Iŋ awhê Grik-ŋga naŋ dinda kôc iŋ yêc gameŋ Sairo-Pionisia-ŋga. Têŋ ndoc awhê dau ŋgô ŋawaê pi Yisu, naŋ têŋ iŋ gi, ma hu dau sip nom yêc iŋ gahi-ŋga. Ma iŋ teŋ Yisu ŋaŋga bu iŋ soc ŋalau sac dau su yêc iŋ atuwê. ");
INSERT INTO buk_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ma Yisu sôm têŋ iŋ, “Gêŋ ŋamata-ŋga dakêŋ gêŋ daneŋ-ŋga têŋ balêkoc bu sêneŋ e hôc ŋac dôŋ. Solop dom bu dakôc balêkoc si gêŋ daneŋ-ŋga, ma tambaliŋ têŋ giam sêneŋ.” ");
INSERT INTO buk_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Magoc awhê dau ô yom ma sôm, “Yomandô Pômdau, magoc giam naŋ sêndöc tebo ŋapu, naŋ seŋ gêŋ ŋapopoc naŋ balêkoc sêŋyaiŋ sip nom.” ");
INSERT INTO buk_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Goc Yisu sôm, “Tu am nem yom dinaŋ-ŋga dec aö wanem am sa. Am mbu ndi ma am oc lic bu ŋalau sac dau hu am atômwê siŋ su.” ");
INSERT INTO buk_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Goc awhê dau mbu têŋ ndê andu gi, ma tap sa bu ŋalau sac dau hu iŋ atuwê siŋ ma bawhê dau yêc bêc yêc ndê mbô. ");
INSERT INTO buk_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yisu ti ndê ŋgacsêŋomi sêhu malac Taya ŋagameŋ siŋ. Ŋac sêŋsêlêŋ sêmbo seŋ têŋ malac Saidon goc sêtêŋ bugictoŋ Galili-ŋga, ma sêpi bugictoŋ ŋadaŋga ma sêtêŋ gameŋ Dekapolis-ŋga si. ");
INSERT INTO buk_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Yêc gameŋ dinaŋ lau ŋatô sêkôc ŋgac daŋ daŋgasuŋ bic ma awha mba ma sêtêŋ Yisu si, ma sêteŋ iŋ bu kêŋ amba sac iŋ. ");
INSERT INTO buk_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Lau daêsam sêlhac dindê, goc Yisu kôc ŋgac dau ma iŋlu sêsa ŋasawa sauŋ si sêlhac dau-ŋga. Ma iŋ kêŋ amba-atu sôc ŋgac dau daŋgasuŋ, ma iŋ hu gasôp pi amba-atu ma kêŋ pi ŋgac dau êmbala. ");
INSERT INTO buk_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Goc iŋ tatac undambê, sê awha atu, ma sôm têŋ iŋ bu, “Epata.” (Yom dau danem kwi bu ‘Po asê.’ ) ");
INSERT INTO buk_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ma ŋagahô iŋ daŋgasuŋ po asê, êmbala tigoloŋ, ma iŋ sôm yom yêc awê. ");
INSERT INTO buk_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yisu gic yao lau bu sêndic miŋ pi gêŋ dinaŋ têŋ lau ŋatô dom, magoc sêsôc iŋ ndê yom ŋapu dom. Iŋ gic yao ŋac tidim daêsam, magoc ŋac sic miŋ pi iŋ hôc gêlêc su. ");
INSERT INTO buk_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ma lau hoŋ naŋ sêŋgô, naŋ sêhêdaê ŋandô ma sêsôm, “Iŋ kôm gêŋ hoŋ ŋapep eŋ, ma gitôm bu kôm lau daŋgasuŋ bic sêŋgô yom, ma lau awha mba sêsôm yom asê.” ");
INSERT INTO buk_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Têŋ têm dinaŋ lau daêsam sêkac sa tiyham e lau toŋ atu sêmbo sêwhiŋ Yisu. Iŋ gêlic bu ŋac si gêŋ sêneŋ-ŋga mba, goc ta ndê ŋgacsêŋomi sêtêŋ iŋ sêmeŋ, ma sôm têŋ ŋac bu, ");
INSERT INTO buk_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Aö taŋwalô lau dindec, bu sêmbo sêwhiŋ aö gitôm bêc tö su, ma ŋac si gêŋ sêneŋ-ŋga pacndê. ");
INSERT INTO buk_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ma aö bu wakêŋ ŋac sêlhö ti gêŋ yô ŋac, dec ŋac oc tagôlô yêc seŋ. Ŋac si lau ŋatô sêmeŋ akêŋ gameŋ baliŋ.” ");
INSERT INTO buk_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Magoc iŋ ndê ŋgacsêŋomi sêô iŋ ndê yom ma sêsôm, “Yac dambo gameŋ sawa, ma oc dakôc gêŋ daneŋ-ŋga y êc nde, naŋ tôm bu lau hoŋ dindec sêneŋ?” ");
INSERT INTO buk_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ma Yisu ndac ŋac, “Mac nem bolom hiŋga ndöc?” Ma ŋac sêsôm, “Yac mba bolom 7 sêndöc.” ");
INSERT INTO buk_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Goc Yisu sôm têŋ lau bu sêndöc sic sêndöc nom. Ma iŋ kôc bolom 7 dinaŋ ma gêm daŋge, pô kôc-kôc, ma kêŋ têŋ ndê ŋgac-sêŋomi bu sêndic sam têŋ lau, dec sic sam. ");
INSERT INTO buk_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ma ŋac si i mwambwa ŋatô sêndöc, naŋ Yisu gêm mbec whiŋ, ma sôm bu sêndic sam têŋ lau. ");
INSERT INTO buk_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ma lau hoŋ seŋ e hôc ŋac dôŋ, goc ŋgacsêŋomi sic ŋadêlê sa sip gatop 7 e meŋhu. ");
INSERT INTO buk_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Lauŋgac naŋ seŋ gêŋ dau, naŋ si namba gitôm 4,000. Tiŋambu Yisu kêŋ ŋac sêlhö si, ");
INSERT INTO buk_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ma iŋ ti ndê ŋgac-sêŋomi sêpi waŋ daŋ ma sêtêŋ gameŋ naŋ sêsam bu Dalmanuta, naŋ si. ");
INSERT INTO buk_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Lau Palêsai ŋatô sêtêŋ Yisu si, ma sic hu sêŋsu iŋ. Ŋac bu sêŋsahê iŋ, dec sêndac iŋ bu kôm gêŋ dalô daŋ bu tôc asê bu iŋ kôc ŋaclai yêc Anötö ndê. ");
INSERT INTO buk_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Magoc Yisu h ulai ma sôm têŋ ŋac, “Tu sake-ŋga mac lau têm dindec-ŋga aŋsalê gêŋ dalô? Yomandô wasôm t êŋ mac bu aö wakôm gêŋ dalô tôm mac andac, naŋ daŋ dom.” ");
INSERT INTO buk_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Goc iŋ hu ŋac siŋ ma pi waŋ tiyham whiŋ ndê ŋgac-sêŋomi ma sêlhö bu sêmbu sêpi bugictoŋ ŋadaŋga sêndi. ");
INSERT INTO buk_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Têŋ ndoc ŋgacsêŋomi sêpi waŋ dau si, naŋ sêŋlhiŋ dau siŋ bu sêkôc bolom ŋatô, ma ŋac si bolom tigeŋ yêc waŋ dau ŋalôm. ");
INSERT INTO buk_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ma Yisu sôm yom ti ŋaŋga têŋ ŋac bu, “Ayob daôm ŋapep pi lau Palêsai si yist ma Herod ndê yist.” ");
INSERT INTO buk_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ma ŋac sem yomgalôm sêwhiŋ dandi ma sêsôm, “Iŋ sôm yom dinaŋ ŋahu bu yac neŋ bolom mbasi.” ");
INSERT INTO buk_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yisu kêyalê yom naŋ ŋac sêsôm, dec sôm têŋ ŋac, “Tu sake-ŋga mac am yomgalôm ma gauc gêm bu yom naŋ aö gasôm pi yist, naŋ ŋahu bu mac nem bolom mba? Bocke mac nem gauc sa pi gêŋ hoŋ naŋ aö gakôm, naŋ dom? Mac nem ŋalôm ŋadandi sa, a? ");
INSERT INTO buk_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tanôm yêc, magoc mac alic gêŋ daŋ ŋapep dom. Daŋamsuŋ yêc, magoc mac aŋgô yom dom. Gauc nem gêŋ naŋ aö gakôm su. ");
INSERT INTO buk_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Têŋ têm naŋ aö gac sam bolom amaŋdaŋ têŋ lau 5,000, naŋ mac ahoŋ ŋadêlê sa sip gatop hiŋga?” Ma sêsôm, “Gatop 12.” ");
INSERT INTO buk_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Goc Yisu sôm, “Ma têŋ têm naŋ aö gac sam bolom 7 têŋ lau 4,000, naŋ mac ahoŋ ŋadêlê sa sip gatop hiŋga?” Ma sêsôm “Gatop 7.” ");
INSERT INTO buk_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Goc iŋ sôm têŋ ŋac, “Ma bocke dec mac nem gauc sa su dom?” ");
INSERT INTO buk_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ŋac sêlac waŋ si e sêhôc asê malac Betsaida. Ma lau ŋatô sêkôc ŋgac tapec daŋ sêtêŋ Yisu si, ma sêndac Yisu bu kêŋ amba sac iŋ. ");
INSERT INTO buk_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Goc Yisu kêm iŋ sip amba, ma wê iŋ sa malac ŋamakê gi. Iŋ hê gasôp pi iŋ tandô ma kêŋ amba sac iŋ, ma ndac, “Am gêlic gêŋ daŋ me mba?” ");
INSERT INTO buk_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ma ŋgac dau hôc tandô sa ma sôm, “Aêc, aö galic ŋamalac sêŋsêlêŋ sêmbo, magoc galic ŋac ŋadauŋ-dauŋ. Aö galic ŋac sêtôm a.” ");
INSERT INTO buk_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Goc Yisu kêŋ amba sac iŋ tandô tiyham, ma iŋ tandô po asê ma ŋayham sa. Ma iŋ gêlic gêŋ hoŋ ŋawa ŋayham. ");
INSERT INTO buk_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Goc Yisu kêŋ iŋ kölhö gi ma sôm, “Am lhö solop têŋ nem andu ndi. Mbu sôc malac dec ndi dom.” ");
INSERT INTO buk_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tiŋambu Yisu ti ndê ŋgac-sêŋomi sêlhö bu sêtêŋ malac ŋatô naŋ yêc kêpiŋ Sisaria-Pilipai sêndi. Sêŋsêlêŋ sêmbo seŋ ma Yisu ndac ŋac bocdec bu, “Lau sêsôm bu aö asa?” ");
INSERT INTO buk_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ma ŋac sêsôm têŋ iŋ, “Lau ŋatô sêsôm bu am Jon, Ŋgac Kêku Lau-ŋga, ma ŋatô sêsôm bu am Elaija, ma ŋatô sêsôm bu am propet akwa-kwa si daŋ.” ");
INSERT INTO buk_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Dec iŋ ndac ŋac, “Ma mac daôm, mac asôm bu aö asa?” Ma Pita ô iŋ awha ma sôm, “Am Mesaya dau.” ");
INSERT INTO buk_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Goc Yisu gic yao ŋac bu sêsôm iŋ asê têŋ lau daŋ dom. ");
INSERT INTO buk_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Têŋ têm dinaŋ Yisu gic hu kêdôhôŋ ŋac pi gêŋ naŋ oc hôc asê Ŋamalac ndê Atu. Iŋ oc hôc ŋawapac daêsam, ma lau bata Israel-ŋga ti †dabuŋsiga atu-tu ma lau naŋ sêndôhôŋ yomsu oc sêtec iŋ. Lau oc sêndic iŋ ndu, ma tiŋambu bêc tö niŋga su iŋ oc tisa tiyham. ");
INSERT INTO buk_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iŋ sôm yom dinaŋ yêc awê, dec Pita kôc iŋ sa ŋasawa sauŋ gi, ma sôm iŋ. ");
INSERT INTO buk_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Magoc Yisu kac dau kwi, tahê ndê ŋgacsêŋomi ma sôm Pita bocdec bu, “Sadaŋ, kôc daôm sa lhö su! Bu am kêyalê Anötö ndê lêŋ dom, am bu êmkuc ŋamalac si gauc ŋambwa.” ");
INSERT INTO buk_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Goc iŋ mbwêc ndê ŋgac-sêŋomi ti lau daêsam naŋ sêŋkuc iŋ, naŋ sêtêŋ iŋ sêmeŋ, ma sôm têŋ ŋac, “Asa naŋ tac whiŋ bu êŋkuc aö, naŋ êŋgwiniŋ dau ma hôc ndê a gicso dau sa, ma êŋkuc aö. ");
INSERT INTO buk_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Bu asa naŋ tac whiŋ bu sap gêŋ nom-ŋga dôŋ ŋapaŋ tu mbo tali-ŋga, naŋ oc niŋga. Magoc asa naŋ bu hu gêŋ nom-ŋga siŋ tu êŋkuc aö-ŋga ma tu ŋawaê ŋayham-ŋga, naŋ oc niŋga dom. ");
INSERT INTO buk_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ŋamalac daŋ bu po gêŋ nom-ŋga hoŋ sa, magoc iŋ dau gatu bu niŋga, dec gêŋ nom-ŋga hoŋ dinaŋ oc tôm dom bu nem iŋ sa. ");
INSERT INTO buk_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Bu gêŋ ŋayham bocke yêc, naŋ gitôm bu dakêŋ têŋ Anötö ô yac neŋ gatuŋ? ");
INSERT INTO buk_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Lau têm dindec-ŋga ŋac lau sac, ma sêpuc dômbwê Anötö ma sêsa si lêŋ bambaliŋ tôm lau mockaiŋ-ŋga. Asa naŋ kwahic dec maya tu aö ti aneŋ yom-ŋga, naŋ Ŋamalac ndê Atu oc maya tu iŋ-ŋga têŋ ndoc ŋambu-ŋga naŋ iŋ mbu meŋ ti Damba Anötö ndê ŋawasi, ma aŋela dabuŋ sêwhiŋ.” ");
INSERT INTO buk_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ma iŋ sôm têŋ ŋac, “Yomandô aö wasôm têŋ mac! Lau ŋatô kwahic dec sêmbo, naŋ oc gacgeŋ sêmbo tali e sêlic Anötö ndê gôliŋ meŋ sa tiawê ma ti ŋaclai atu.” ");
INSERT INTO buk_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Bêc 6 giŋga su goc Yisu kôc Pita, Jems ma Jon sêwhiŋ iŋ, ma ŋac tawasê sêpi lôc baliŋ daŋ si. Têŋ têm dinaŋ Yisu ndê ŋamlic kaiŋ daŋ sa, ma sêlic iŋ ndê ŋawasi. ");
INSERT INTO buk_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Iŋ ndê ŋakwê sêp sambuc ma ŋawasi atu, hôc gêlêc gêŋ sêsêp nom-ŋga hoŋ. ");
INSERT INTO buk_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma sêlic Elaija lu Moses sêhoc dau asê, ma iŋlu sem yomgalôm sêwhiŋ Yisu. ");
INSERT INTO buk_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Goc Pita sôm têŋ Yisu, “Kêdôhôŋwaga, ŋayham kêlêc bu yac dambo lec. Yac oc akwê bac tö tu mac ambo-ŋga, am nem bac daŋ, Moses nde daŋ, ma Elaija ndê bac daŋ.” ");
INSERT INTO buk_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ŋgacsêŋomi tö dinaŋ sêtöc dau atu, ma bocdinaŋ Pita gêm gauc yom tu sôm-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Têŋ dinaŋ dao daŋ meŋ kêgatöc ŋac ahuc, ma awha daŋ sa yêc dao ŋalôm, naŋ sôm, “Aö neŋ atuŋgac dau dindec, naŋ aö atac whiŋ ndu andô. Aŋgô iŋ ndê yom maŋ.” ");
INSERT INTO buk_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ma ŋagahô ŋac tahê gameŋ dau, ma sêlic bu Yisu tawasê mbo whiŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tiŋambu ŋac sêsip akêŋ lôc dau sêmeŋ, ma Yisu kêŋ yao bu sêsôm yom pi gêŋ naŋ sêlic yêc lôc, naŋ asê dom e tôm Ŋamalac ndê Atu tisa akêŋ lau batê-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tu dinaŋ-ŋga ŋac sem yom dinaŋ ahuc yêc ŋac dau, magoc sem yomgalôm sêwhiŋ dandi ŋapaŋ pi gêŋ dau. Ŋahu bu Yisu ndê yom pi iŋ tisa akêŋ lau batê-ŋga, naŋ sêŋyalê ŋahu dom. ");
INSERT INTO buk_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma sêndac Yisu, “Lau Skraib naŋ sêndôhôŋ yomsu, naŋ sêsôm bu Elaija oc meŋ hôc asê muŋ, ma tiŋambu Mesaya oc meŋ. Yom dau ŋahu bocke?” ");
INSERT INTO buk_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Ma Yisu sôm, “Elaija gic waê bu hôc asê muŋ Mesaya, bu êmasaŋ gêŋ hoŋ tisolop. Ma aö wasôm têŋ mac, bu Elaija meŋ hôc asê su. Ma lau sêkôm mêtê sac têŋ iŋ tôm ŋac atac whiŋ, tôm Anötö ndê yom naŋ sêto yêc gwanaŋ su. Ma yom naŋ sêto yêc pi Ŋamalac ndê Atu naŋ sôm bu iŋ gic waê bu hôc ŋandê atu, ma lau oc sêpu iŋ ma sêtec iŋ. Mac aŋyalê yom dau ŋahu, me mba?” ");
INSERT INTO buk_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yisu ma ŋgacsêŋomi tö dinaŋ sêsip akêŋ lôc dau sêmeŋ ma sêlic bu kêdôhôŋwaga yomsu-ŋga ŋatô ma Yisu ndê ŋgacsêŋomi ŋatô sêsôm dau sêmbo, ma lau toŋ atu sêŋgihi ŋac ahuc. ");
INSERT INTO buk_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Têŋ ndoc lau hoŋ dinaŋ sêlic Yisu naŋ sêhêdaê ŋandô, ma sênti sêtêŋ iŋ si ti sêhê mwalêc iŋ. ");
INSERT INTO buk_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ma Yisu ndac ŋac bu, “Mac asôm daôm pi yom bocke?” ");
INSERT INTO buk_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ma ŋamalac daŋ naŋ mbo lau toŋ atu ŋalôm, naŋ ô yom ma sôm, “Kêdôhôŋwaga, aö gakôc aneŋ balê dindec gameŋ, bu ŋalau sac daŋ mbo iŋ ŋalôm ma kôm iŋ awha mba. ");
INSERT INTO buk_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Têm ŋatô ŋalau sac dau kôc iŋ dôŋ ma tuc iŋ sip nom gi, kôm iŋ whapwic sa ma seŋ lhô, ma iŋ amba ti gahi ŋaŋga sa. Aö gandac am nem ŋgacsêŋomi bu sêsoc ŋalau dau su, magoc ŋac sêtôm dom.” ");
INSERT INTO buk_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yisu ŋgô yom dau ma sôm, “O mac lau, aö gambo gawhiŋ mac ŋasawa hic baliŋ su, ma bocke mac atôm dom bu akôm gêŋ daŋ? Aö wambo wawhiŋ mac ŋapaŋ dom! Mac nem akêŋ whiŋ mbasi. Akôc balê dau sa ameŋ.” ");
INSERT INTO buk_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dec sêkôc balê dau sêtêŋ Yisu sêmeŋ, ma têŋ têm ŋalau sac gêlic iŋ, naŋ ŋagahô iŋ kêmwanaŋ balê dau ti ŋaŋga, goc tuc iŋ sip nom gi, ma iŋ kêpi ti whapwic sa yêc nom. ");
INSERT INTO buk_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","G oc Yisu ndac balê dau ŋadamba, “Ŋalau sac kôm iŋ bocdinaŋ tôm yala hiŋga?” Ma damba sôm, “Iŋ mbo bocdinaŋ têŋ têm iŋ balêkoc sauŋ ŋapaŋ e kwahic dec. ");
INSERT INTO buk_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ma ndoc daêsam ŋalau sac dau tuc iŋ peŋ sip bu me sip ya, ma kôm bu ndic iŋ ndu niŋga. Tigeŋ am bu nditôm, dec tamwalô alu ma nem alu sa.” ");
INSERT INTO buk_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Goc Yisu sôm têŋ iŋ, “Bocke dec am sôm têŋ aö, ‘Am bu nditôm?’ Mac bu akêŋ whiŋ, dec gêŋ hoŋ oc nditôm.” ");
INSERT INTO buk_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ma ŋagahô balê ŋadamba ta yom ma sôm, “Aö gakêŋ whiŋ. Nem aö sa bu wakêŋ whiŋ ŋaŋga.” ");
INSERT INTO buk_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yisu gêlic bu lau daêsam sênti sêmeŋ, dec hec yom ŋalau sac ma sôm, “Am ŋalau daŋgasuŋ bic ma awha mba-ŋga, aö wandic atu am bu hu balê dindec siŋ, ma sôc iŋ ŋalôm tiyham dom!” ");
INSERT INTO buk_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Goc ŋalau sac dau mbwêc asê ma kêmwanaŋ balê dau ŋalêŋ sac, goc sa awê gi. Ma balê dau yêc gitôm ŋgac batê daŋ, dec lau daêsam sêsôm, “Iŋ mbac ndu su.” ");
INSERT INTO buk_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tigeŋ Yisu kêm iŋ sip amba, keŋ iŋ sa, ma iŋ tisa kalhac. ");
INSERT INTO buk_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tiŋambu Yisu sôc andu daŋ gi, ma iŋ ndê ŋgacsêŋomi sêndac iŋ gelec, “Bocke dec yac atôm dom bu asoc ŋalau dinaŋ su?” ");
INSERT INTO buk_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ma iŋ sôm, “Mac bu asoc ŋalau kaiŋ dinaŋ su, naŋ ateŋ mbec ŋaŋga. Ŋalêŋ daŋ mba.” ");
INSERT INTO buk_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Yisu ti ndê ŋgacsêŋomi sêhu gameŋ dinaŋ siŋ, ma sêŋsêlêŋ sêmbo gameŋ Galili-ŋga. Yisu bu êndôhôŋ ŋac têŋ têm dinaŋ, dec tec bu lau sêŋyalê gameŋ naŋ ŋac sêmbo. Iŋ sôm têŋ ŋac, “Tiŋambu oc sêkêŋ Ŋamalac ndê Atu sip lau ŋatô amba. Ŋac oc sêndic iŋ ndu, magoc têŋ bêc tö niŋga su, iŋ oc tisa tiyham.” ");
INSERT INTO buk_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Magoc ŋac si gauc sa pi iŋ ndê yom dom, ma sêtöc dau bu sêndac iŋ pi yom dau ŋahu. ");
INSERT INTO buk_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ŋac sêŋsêlêŋ e sêhôc asê malac Kapenaom, goc si sêndöc andu daŋ. Ma Yisu ndac ŋac, “Mac aseŋ daôm pi gêŋ sake yêc seŋ?” ");
INSERT INTO buk_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Magoc ŋac sem dôŋ, bu yêc seŋ ŋac sem yomgalôm sêwhiŋ dandi pi ŋac si asa iŋ ŋgac ŋamata-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yisu ndöc sic ma ta ŋgacsêŋomi 12 sêtêŋ iŋ si, ma sôm têŋ ŋac, “A sa naŋ bu ti ŋamalac ŋamata-ŋga yêc Anötö aŋgô-ŋga, naŋ êŋgwiniŋ dau ti ŋgac ŋambu-ŋga, ma nem akiŋ lau hoŋ.” ");
INSERT INTO buk_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Goc iŋ kôc balêkoc sauŋ daŋ ma kêŋ iŋ kalhac ŋac ŋalhu. Ma iŋ kêgape iŋ ma sôm, ");
INSERT INTO buk_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Asa naŋ bu kôc balêkoc sauŋ daŋ tôm iŋ dindec, naŋ sa tu aö neŋ ŋaê-ŋga, naŋ gitôm iŋ kôc aö dauŋ sa. Ma asa naŋ kôc aö sa, naŋ kôc aö taŋwasêŋ sa dom, magoc kôc Damaŋ naŋ kêkiŋ aö gameŋ, naŋ sa bocdinaŋ.” ");
INSERT INTO buk_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Têŋ bêc daŋ Jon sôm têŋ Yisu bu, “Kêdôhôŋwaga, yac alic ŋgac daŋ kôm gweleŋ ma soc ŋalau sac su yêc lau ŋa am nem ŋaê. Yac ac yao iŋ, bu iŋ kêkuc am whiŋ yac dom.” ");
INSERT INTO buk_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Magoc Yisu sôm, “Alhac iŋ ahuc dom, bu ŋamalac naŋ kôm gêŋ dalô ŋa aneŋ ŋaê, naŋ gitôm dom bu kac ndê awha kwi ŋagahô, ma sôm yom sac pi aö. ");
INSERT INTO buk_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Asa naŋ kêŋ kisa yac dom, naŋ yac neŋ daŋ. ");
INSERT INTO buk_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yomandô aö wasôm têŋ mac bu asa naŋ kôm gêŋ sauŋ daŋ bu nem mac sa tu mac aŋkuc aö Kilisi-ŋga, gitôm iŋ kêŋ bu laclhu daŋ têŋ mac anôm, naŋ Anötö oc êŋlhiŋ iŋ siŋ dom. Iŋ oc kêŋ ŋagêyô ŋayham têŋ iŋ.” ");
INSERT INTO buk_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ma Yisu sôm, “Ŋamalac daŋ bu tim balêkoc sauŋ daŋ naŋ kêŋ whiŋ aö bu kôm mêtê sac, naŋ kôm giso atu. Oc ŋayham bu dasô hoc atu daŋ pi iŋ kachu, ma tambaliŋ iŋ sip gwêc ndi niŋga. Ma bocdinaŋ oc tôm dom bu iŋ tim balêkoc dau, ma tiŋambu tap Anötö ndê matôc sa. ");
INSERT INTO buk_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“Am amam bu kôm sac, naŋ tim kic. Am bu tap undambê sa, ma ndöc tamli ti amam gatuc, naŋ ŋayham hôc gêlêc am kôm sac ŋa amam lu-lu e am sip ya lambwam-ŋga naŋ sa ŋapaŋ, naŋ ndi. ");
INSERT INTO buk_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ma gahim bu kôm sac, naŋ tim kic. A m bu tap undambê sa, ma ndöc tamli ti gahim gatuc, naŋ ŋayham hôc gêlêc am kôm sac ti gahim lu-lu e Anötö tuc am sip ya lambwam-ŋga naŋ sa ŋapaŋ, naŋ ndi. ");
INSERT INTO buk_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma am nem tanôm bu kôm sac, naŋ kip sa. Am bu ndöc Anötö ndê gameŋ undambê-ŋga ti tanôm tigeŋ, naŋ ŋayham hôc gêlêc am kôm sac ti tanôm lu-lu e Anötö tuc am sip lambwam ndi. ");
INSERT INTO buk_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Yêc gameŋ dinaŋ lau oc sêhôc ŋandê ŋapaŋ, tôm yom naŋ Aisaya to yêc bocdec bu, ‘Dombo oc mbac ndu dom, ma ya oc sa ŋapaŋ.’ ");
INSERT INTO buk_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Bocdinaŋ ayob daôm tu lêtôm-ŋga, bu Anötö oc kêŋ ya êmbô lau hoŋ, gitôm lau sêkêŋ gwêc so pi wata tu bu yêc ŋayham ŋasawa baliŋ. ");
INSERT INTO buk_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Gwêc so dau iŋ gêŋ ŋayham, magoc ŋamakic bu niŋga, oc dakôm ŋamakic sa tiyham ŋalêŋ nde? Bocdinaŋ ambo lau nom-ŋga ŋalôm atôm gwêc so, ma ambo awhiŋ daôm ti yom malô.” ");
INSERT INTO buk_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yisu ti ndê ŋgacsêŋomi sêhu gameŋ dinaŋ siŋ, ma sêtêŋ gameŋ Judia-ŋga si. Goc sêpi Bu Jordan ŋadaŋga naŋ yêc têŋ gameŋ ac pi-ŋga, naŋ si. Yêc gameŋ dinaŋ lau daêsam sêkac sa tiyham ma sêtêŋ iŋ si, ma iŋ kêkuc iŋ ndê mêtê ma kêdôhôŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ma lau Palêsai ŋatô sêmeŋ ma bu sêtim Yisu, dec sêndac iŋ bocdec bu, “Ŋgac daŋ bu hu ndê awhê siŋ, naŋ oc êŋgilì yomsu, me mba?” ");
INSERT INTO buk_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ma Yisu ndac ŋac ô, “Moses to yomsu bocke?” ");
INSERT INTO buk_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Goc sêsôm, “Moses sôm bu ŋgac daŋ gitôm bu to bapia hu nawhê siŋ-ŋga, goc hu ndê awhê siŋ.” ");
INSERT INTO buk_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ma Yisu sôm, “Aêc. Moses to yomsu dinaŋ tu mac nem ŋalôm ŋadandi-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Magoc têŋ têm Anötö kêŋ undambê ti nom, naŋ iŋ kêmasaŋ ŋamalac ŋgac ti awhê. ");
INSERT INTO buk_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ma tu dinaŋ-ŋga ‘ŋgac daŋ oc hu damba lu dinda siŋ, ma sap iŋ nawhê dôŋ, ");
INSERT INTO buk_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ma iŋlu sêti gêŋ tigeŋ.’ Yom dau whê sa bu iŋlu sêmbo sêtôm ŋamalac lu dom, iŋlu sêti gêŋ tigeŋ yêc Anötö aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Bocdinaŋ yham dom andô bu ŋamalac sêkac gêŋ naŋ Anötö dau kêŋ pitigeŋ, naŋ su.” ");
INSERT INTO buk_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tiŋambu Yisu ti ndê ŋgac-sêŋomi sêndöc andu daŋ, ma sêndac iŋ pi yom dinaŋ ŋahu. ");
INSERT INTO buk_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ma iŋ sôm, “Ŋgac naŋ hu iŋ ndê awhê siŋ ma gêm awhê wakuc, naŋ kôm gêŋ mockaiŋ-ŋga têŋ iŋ yêc Anötö aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma awhê naŋ hu nakweŋ siŋ ma gêm ŋgac wakuc, naŋ kôm gêŋ mockaiŋ-ŋga bocdinaŋ.” ");
INSERT INTO buk_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Têŋ bêc daŋ lau sêhoŋ si balêkoc sêtêŋ Yisu si, bu iŋ kêŋ amba sac ŋac. Magoc iŋ ndê ŋgac-sêŋomi sêsôm dinda ti dambai. ");
INSERT INTO buk_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Têŋ têm Yisu gêlic gêŋ dau iŋ tac ŋandê, ma sôm têŋ ŋac, “Atec balêkoc dinaŋ sêtêŋ aö sêmeŋ. Alhac ŋac ahuc dom, bu Anötö ndê gôliŋ gic lau naŋ sêtôm balêkoc sauŋ dindec, naŋ ŋawaê. ");
INSERT INTO buk_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Aö wasôm yomandô têŋ mac bu asa naŋ bu sôc Anötö ndê gôliŋ ŋapu gitôm balêkoc sauŋ daŋ dom, naŋ oc nditôm dom bu sôc ndi.” ");
INSERT INTO buk_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Goc iŋ kôc balêkoc dau sa ma kêgape ŋac. Ma iŋ kêŋ amba sac ŋac, ma gêm mbec ŋac. ");
INSERT INTO buk_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yisu ti ma kêsêlêŋ mbo seŋ whiŋ ndê ŋgacsêŋomi. Ma ŋgac daŋ kêti meŋ ma pôŋ haduc yêc iŋ aŋgô-ŋga, ma ndac iŋ bocdec bu, “K êdôhôŋwaga ŋayham, aö wakôm bocke dec tiŋambu Anötö oc kôc aö sa wandöc taŋli ŋapaŋ.” ");
INSERT INTO buk_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Goc Yisu sôm têŋ iŋ, “Tu sake-ŋga am sam aö bu ŋayham? Anötö tigeŋ iŋ ŋayham. ");
INSERT INTO buk_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Am kêyalê yomsu naŋ Anötö kêŋ têŋ Moses, ‘Ndic ŋamalac ndu dom. Kôm gêŋ mockaiŋ-ŋga dom. Nem kaŋ gêŋ dom. Sôm yom tasaŋ pi lau dom. Êmsau lau bu kôc ŋac si gêŋ dom,’ ma ‘Toc damam lu dinam sa.’” ");
INSERT INTO buk_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ma iŋ sôm, “Kêdôhôŋ-waga, aö kakuc yomsu hoŋ dinaŋ, têŋ ndoc aö gambo balê ŋapaŋ e kwahic dec.” ");
INSERT INTO buk_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yisu tahê iŋ ma tac whiŋ iŋ kêlêc. Ma iŋ sôm, “Gêŋ tigeŋ yêc tu am kôm-ŋga. Am ndi, kêŋ am nem gêŋ hoŋ têŋ lau sênemlhi, ma kêŋ ŋa-awa têŋ lau ŋalôm sawa. Ma bocdinaŋ am nem awa ŋandô oc yêc undambê. Ma tiŋambu am mweŋ ma êmkuc aö.” ");
INSERT INTO buk_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Magoc têŋ têm ŋgac dau ŋgô Yisu ndê yom dinaŋ iŋ wec, ma kölhö ti ŋalôm ŋawapac gi. Ŋahu bu iŋ ŋgac ti lêlôm. ");
INSERT INTO buk_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Goc Yisu tahê lau hoŋ, ma sôm têŋ iŋ ndê ŋgacsêŋomi, “Lau ti lêlôm si awa ti wapa kalhac ŋac ahuc e gitôm dom bu sêsôc Anötö ndê gôliŋ ŋapu ŋagahô.” ");
INSERT INTO buk_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ŋac sêŋgô iŋ ndê yom dinaŋ e sêhêdaê. Ma Yisu sôm têŋ ŋac tiyham, “O aneŋ balêkoc atac whiŋ-ŋga, ŋamalac bu sêsôc Anötö ndê gôliŋ ŋapu, naŋ gêŋ sauŋ dom. ");
INSERT INTO buk_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Bôc atu daŋ gitôm kamel, oc tôm bu sôc so ŋalasê ŋagahô, hôc gêlêc ŋgac ti lêlôm daŋ bu sôc Anötö ndê gôliŋ ŋapu.” ");
INSERT INTO buk_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yisu ndê ŋgac-sêŋomi sêŋgô yom dinaŋ ma sêhêdaê ŋandô. Ma sêsôm têŋ dandi, “Bu bocdinaŋ dec asa oc tôm bu tap Anötö ndê mwasiŋ nem lau si-ŋga sa? Oc ŋawapac atu!” ");
INSERT INTO buk_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yisu tahê ŋac ma sôm, “Gêŋ naŋ ŋamalac sêtôm dom bu sêkôm, naŋ Anötö gitôm bu kôm, bu Anötö gitôm bu kôm gêŋ hoŋ.” ");
INSERT INTO buk_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Goc Pita sôm têŋ iŋ, “Yac oc bocke? Yac ahu gêŋ hoŋ siŋ tu aŋkuc am-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ma Yisu ô yom ma sôm, “Aö wasôm yomandô têŋ mac. Asa naŋ bu hu andu, me asidôwai, me lhuwêi, me dinda lu damba, me balêkoc, me nom siŋ tu aö-ŋga ma tu gweleŋ ŋawaê ŋayham-ŋga, ");
INSERT INTO buk_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","naŋ Anötö oc kêŋ gêŋ kaiŋ dinaŋ daêsam têŋ iŋ ô, têŋ ndoc iŋ mbo nom. Ma iŋ oc tap kisa ti ŋawapac sa tu aö-ŋga whiŋ. Ma têŋ têm ŋambu-ŋga, Anötö oc kôc iŋ sa, ma kêŋ iŋ ndöc tali ŋapaŋ yêc undambê. ");
INSERT INTO buk_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tigeŋ lau daêsam naŋ kwahic dec sêti lau ŋamata-ŋga, naŋ oc sêti lau ŋambu-ŋga, ma lau ŋambu-ŋga oc sêti lau ŋamata-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yisu wê iŋ ndê ŋgacsêŋomi ma sêŋsêlêŋ sêmbo seŋ bu sêtêŋ Jerusalem sêndi. Iŋ ndê ŋgac-sêŋomi sêŋsêlêŋ ti sêhêdaê, ma lau ŋatô naŋ sêŋsêlêŋ sêwhiŋ ŋac, naŋ sêtöc dau. Bocdinaŋ Yisu kôc ŋgacsêŋomi 12 sêsa si sêlhac dau-ŋga, ma sôm yom tiyham pi gêŋ naŋ oc hôc asê iŋ. ");
INSERT INTO buk_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Iŋ sôm, “Kwahic dec yac bu dapi malac Jerusalem dandi, ma ŋgac daŋ oc hoc Ŋamalac ndê Atu asê ma kêŋ iŋ sip dabuŋsiga atu-tu ti kêdôhôŋ-waga yomsu-ŋga amba. Ŋac oc sêkic yom bu sêndic iŋ ndu, ma sêkêŋ iŋ sip lau Rom-ŋga amba. ");
INSERT INTO buk_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ŋac oc sêsu iŋ susu, sêhê gasôp pi iŋ, sêndic iŋ ŋamlic ŋandê ma sêndic iŋ ndu. Magoc tiŋambu bêc tö niŋga su, goc iŋ oc tisa tiyham.” ");
INSERT INTO buk_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jems lu Jon, Sebedi ndê atuŋgac lu, sêtêŋ Yisu si ma sêsôm, “Kêdôhôŋwaga, alu atac whiŋ gêŋ daŋ, ma bu andac am bu kôm gêŋ dau ŋandô sa.” ");
INSERT INTO buk_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Goc Yisu ndac, “Amlu atac whiŋ bu aö wakôm sake?” ");
INSERT INTO buk_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ma sêsôm, “Alu atac whiŋ bu têŋ ndoc am ndöc nem pôŋ kiŋ-ŋga ti ŋawasi atu, naŋ am kêŋ alu andöc awhiŋ am, daŋ ndöc amam andô-ŋga ma daŋ ndöc gasê-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Magoc Yisu ô yom ma sôm, “Amlu aŋyalê gêŋ naŋ amlu andac, naŋ dom. Amlu atôm bu anôm gêŋ sip laclhu ŋawapac-ŋga naŋ aö wanôm, a? Ma atôm bu aliŋ saŋgu naŋ aö oc waliŋ, a?” ");
INSERT INTO buk_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ma iŋlu sêsôm, “Aêc, alu atôm.” Goc Yisu sôm, “Yomandô! Amlu oc anôm gêŋ sip laclhu tôm aö wanôm, ma aliŋ saŋgu tôm naŋ aö waliŋ. ");
INSERT INTO buk_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Magoc aö dec oc waŋyaliŋ lau sa bu sêndöc aö amaŋ andô-ŋga ti amaŋ gasê-ŋga, naŋ dom. Anötö ti ŋadau bu êŋyaliŋ lau sa bu sêndöc dinaŋ.” ");
INSERT INTO buk_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Têŋ ndoc ŋgacsêŋomi 10 sêŋgô yom dau ŋawaê, naŋ ŋac tac ŋandê têŋ Jems lu Jon. ");
INSERT INTO buk_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Goc Yisu mbwêc ŋac sêtêŋ iŋ si, ma sôm, “Mac aŋyalê bu lau sambuc si gôliŋwaga sêtoc dau sa têŋ ŋac si lau, ma ŋac si lau bata sêŋgwiniŋ lau naŋ sêmbo ŋac ŋapu. ");
INSERT INTO buk_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tigeŋ mac aŋkuc ŋac si mêtê dau dom. Mba! Mac nem asa bu ti ŋamalac tiwaê yêc Anötö aŋgô-ŋga, naŋ nem akiŋ mac. ");
INSERT INTO buk_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aêc! Asa bu ti mac nem ŋamalac ŋamata-ŋga, naŋ êŋgwiniŋ dau ma ti mac hoŋ nem ŋgac akiŋ ŋambwa. ");
INSERT INTO buk_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ŋahu bu lêŋ dau ti aneŋ lêŋ. Ŋamalac ndê Atu meŋ tu bu lau sênem akiŋ iŋ-ŋga dom. Mba. Iŋ meŋ bu nem akiŋ lau, ma bu kêŋ dau ti da bu nemlhi lau daêsam si sac ŋatôp.” ");
INSERT INTO buk_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yisu ti ndê ŋgacsêŋomi sêŋsêlêŋ e sêhôc asê malac Jeriko, ma lau toŋ atu sêŋkuc ŋac. Têŋ ndoc ŋac bu sêhu Jeriko siŋ, naŋ sêtap ŋgac tapec daŋ sa, naŋ ndöc seŋ ŋamakê ma teŋ gêŋ. Iŋ Batimeas, ŋgac daŋ ŋaê Timeas ndê atuŋgac. ");
INSERT INTO buk_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Têŋ têm iŋ ŋgô bu Yisu Nasaret-ŋga kêsêlêŋ mbo seŋ, naŋ gic hu mbwêc yom asê bocdec bu, “Yisu, †Dawid ndê Atu, tamwalô aö!” ");
INSERT INTO buk_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Goc lau daêsam sêhec yom iŋ ma sêsôm bu iŋ nem dôŋ. Magoc iŋ mbwêc ti ŋaŋga, “Dawid ndê Atu, tamwalô aö.” ");
INSERT INTO buk_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yisu ŋgô ŋac si yom ma kwê dôŋ kalhac, goc sôm têŋ lau, “Mac asôm têŋ iŋ bu meŋ.” Goc sêta yom têŋ ŋgac tapec dau ma sêsôm, “Tisa ti atac ŋayham! Iŋ ta am bu mweŋ.” ");
INSERT INTO buk_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Goc ŋgac dau kac ndê ŋakwê andô-ŋga baliŋ su yêc nom, ma tisa ŋagahô ma têŋ Yisu gi. ");
INSERT INTO buk_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ma Yisu ndac iŋ, “Am tac whiŋ bu aö wakôm sake têŋ am?” Ma ŋgac tapec dau sôm, “Kêdôhôŋ-waga, aö tac whiŋ bu tanôŋ ŋayham sa.” ");
INSERT INTO buk_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Goc Yisu sôm, “Am ndi! Am nem kêŋ whiŋ aö dec kôm am ŋayham sa.” Ma ŋagahô iŋ tandô ŋawa sa, ma iŋ kêkuc Yisu mbo seŋ. ");
INSERT INTO buk_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yisu ti ndê sêŋomi sêŋsêlêŋ sêhêganôŋ Jerusalem e sêsuŋ sa malac Betani ma malac Betpagi yêc Lôc Olib. Goc Yisu kêkiŋ ndê ŋgacsêŋom lu, ");
INSERT INTO buk_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ma sôm têŋ iŋlu, “Asôc malac dindê andi, ma yêc dindê amlu oc atap doŋki daŋ sa, naŋ sêsô dôŋ kalhac. Iŋ doŋki ŋatu wakuc, naŋ ŋamalac daŋ ndöc ŋahô muŋ su dom. Aŋgapwêc su ma akôc sa ameŋ. ");
INSERT INTO buk_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ma lau bu sêndac amlu bu bocke ma amlu aŋgapwêc doŋki dau, naŋ asôm têŋ ŋac bu, ‘Pômdau tac whiŋ bu doŋki dindec nem iŋ sa ŋasawa sauŋ, goc iŋ oc kêŋ mbu meŋ.’” ");
INSERT INTO buk_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bocdinaŋ dec iŋlu sêsôc malac dau si ma sêtap doŋki daŋ sa, naŋ lau sêsô dôŋ kalhac seŋ ŋadali k êpiŋ andu daŋ. Iŋlu bu sêŋgapwêc su, ");
INSERT INTO buk_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ma lau ŋatô naŋ sêlhac sêmpiŋ, naŋ sêndac iŋlu, “Amlu akôm sake, dec bu aŋgapwêc doŋki dau su?” ");
INSERT INTO buk_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ma iŋlu sêô ŋac si yom tôm Yisu sôm têŋ iŋlu, dec sêhu doŋki dau siŋ têŋ iŋlu. ");
INSERT INTO buk_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Sêwê iŋ sa sêtêŋ Yisu si, ma sêhu si ŋakwê awê-ŋga sac doŋki, goc Yisu pi gi ndöc ŋahô. ");
INSERT INTO buk_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ma lau daêsam sêhê si ŋakwê yêc seŋ. Ma lau ŋatô sêhêako a ŋalauŋ yêc seŋ ŋamakê ma sêkêŋ yêc seŋ. ");
INSERT INTO buk_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Lau naŋ sêmuŋ Yisu ti lau naŋ sêŋkuc iŋ, naŋ sêmbwêc “Hosana! Anötö nem mbec ŋgac naŋ meŋ gêm Pômdau aŋgô. ");
INSERT INTO buk_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Anötö nem mbec iŋ naŋ meŋ bu puc abaŋ Dawid ndê gôliŋ dôŋ. Hosana têŋ Anötö lôlôc-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yisu hôc asê Jerusalem, goc sôc lôm dabuŋ ŋabatêmndö gi, ma gêlic gêŋ sambob naŋ yêc dindê. Magoc ac gi su dec iŋ ti ndê ŋgacsêŋomi 12 sêmbu sêsa malac Betani si bu sêyêc dindê. ");
INSERT INTO buk_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Têŋ bêbêc Yisu ti ndê ŋgac-s êŋomi sêhu Betani siŋ ma sêŋsêlêŋ sêmbo seŋ, ma gêŋ yô Yisu. ");
INSERT INTO buk_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Iŋ gêlic a kiŋ daŋ naŋ kalhac ahê, goc têŋ a dau gi. Têm dinaŋ iŋ têm naŋ a kiŋ sem ŋandô dom, magoc Yisu gêlic bu a dinaŋ ŋalauŋ kêsôlô su dec kêŋ bata bu mboe kiŋ ŋandô oc sêŋgalêŋ. Magoc ŋandô mbasi, iŋ tap ŋalauŋ ŋambwa sa. ");
INSERT INTO buk_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Goc iŋ pucbo a dau ma sôm, “Lau daŋ oc sêneŋ ŋandô yêc a dindec tiyham dom.” Ma iŋ ndê ŋgacsêŋomi sêŋgô yom dau. ");
INSERT INTO buk_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yisu ti ndê sêŋomi sêŋsêlêŋ si e sêhôc asê Jerusalem, ma sêtêŋ lôm dabuŋ si. Yêc lôm dabuŋ ŋabatêmndö lau sêtidulu gêŋ ti semlhi gêŋ sêmbo, ma Yisu gic hu soc ŋac sêsa awê. Iŋ kac lau sêô mone-ŋga si tebo sa, ma kac lau naŋ sêyob balusi bu lau sênemlhi, naŋ si pôŋ sa whiŋ. ");
INSERT INTO buk_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma iŋ gic yao lau bu sêkôc wapa sêtidulu-ŋga sôc lôm dabuŋ ŋagameŋ tiyham dom. ");
INSERT INTO buk_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ma iŋ kêdôhôŋ lau ma sôm, “Sêto Anötö ndê yom yêc bocdec bu, ‘Aö neŋ andu gic waê bu lau akêŋ gameŋ hoŋ sêteŋ mbec sêmbo-ŋga.’ Mac aŋyalê yom dau, ma bocke dec mac akôm Anötö ndê andu ti lau kaŋ si gameŋ?” ");
INSERT INTO buk_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tiŋambu dabuŋsiga atu-tu ma lau naŋ sêndôhôŋ yomsu, naŋ sêŋgô ŋawaê pi gêŋ naŋ Yisu kôm, ma sêŋyalê bu lau sambob sêhêdaê tu iŋ ndê yom-ŋga. Tu dinaŋ-ŋga dec sêtöc Yisu, ma sêŋsalê lêŋ bu sêndic iŋ ndu. ");
INSERT INTO buk_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yisu ti ndê ŋgac-sêŋomi sêmbo Jerusalem e ac gi sip, dec sêmbu sêsa si. ");
INSERT INTO buk_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ŋagalaŋsê bêbêc Yisu ti ndê ŋgacsêŋomi sêŋsêlêŋ bu sêmbu sêtêŋ Jerusalem sêndi, ma sêhôc asê a kiŋ naŋ Yisu pucbo. Ŋac sêlic bu a dau mbac, ŋasaŋgac ti ŋawakac hoŋ tibasô. ");
INSERT INTO buk_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ma Pita gauc gêm Yisu ndê yom, dec sôm têŋ iŋ, “Kêdôhôŋwaga, lic a kiŋ naŋ am pucbo, naŋ mbac su.” ");
INSERT INTO buk_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Goc Yisu ô yom ma sôm têŋ ŋac, “Akêŋ whiŋ Anötö. ");
INSERT INTO buk_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Aö wasôm yomandô têŋ mac, bu asa naŋ bu sôm têŋ lôc daŋ bu, ‘Puc daôm sa ma sip gwêc ŋalôm ndi,’ ma atac lu-lu dom magoc kêŋ whiŋ bu Anötö oc kôm yom dau ŋandô sa, dec gêŋ dau oc ŋandô sa. ");
INSERT INTO buk_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Boc-dinaŋ aö bu wasôm têŋ mac bu gêŋ bocke naŋ mac bu ateŋ Anötö bu kêŋ têŋ mac, naŋ akêŋ whiŋ bu mac akôc su, ma aö wasôm yom ŋandô, iŋ oc kêŋ têŋ mac. ");
INSERT INTO buk_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Ma têŋ ndoc mac bu ateŋ mbec, ma bu gauc nem lau naŋ sêkôm sac têŋ mac, naŋ goc asuc ŋac si sac kwi. Ma mac nem Damam naŋ mbo undambê, oc suc mac nem sac kwi bocdinaŋ.” ");
INSERT INTO buk_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yisu ti iŋ ndê ŋgacsêŋomi sêhôc asê malac Jerusalem tiyham ma sêtêŋ lôm dabuŋ si. Yisu kêsêlêŋ mbo lôm dabuŋ ŋabatêm-ndö, ma dabuŋsiga atu-tu ti kêdôhôŋwaga yomsu-ŋga ma lau bata sêtigasuc iŋ. ");
INSERT INTO buk_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ma sêndac iŋ, “Am kôc ŋaclai yêc nde, bu kôm gêŋ hoŋ naŋ am kôm? Asa kêŋ têŋ am?” ");
INSERT INTO buk_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Goc Yisu sôm têŋ ŋac, “Gêŋ ŋamata-ŋga aö wakêŋ gêndac daŋ têŋ mac. Mac bu aô aneŋ yom, dec wasôm aneŋ ŋaclai ŋahu asê têŋ mac. ");
INSERT INTO buk_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Asa kêŋ ŋaclai têŋ Jon dec iŋ kêku lau? Anötö kêŋ ŋaclai têŋ iŋ, me mba? Asôm têŋ aö.” ");
INSERT INTO buk_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ŋac sem yomgalôm pi Yisu ndê gêndac, ma sêsôm têŋ dau, “Yac bu dasôm bu Anötö kêŋ ŋaclai têŋ Jon, goc Yisu oc ndac yac, ‘Tu sake-ŋga mac akêŋ whiŋ Jon dom?’ ");
INSERT INTO buk_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Magoc yac bu dasôm bu Jon kêku lau kêkuc ŋamalac nom-ŋga si gauc ŋambwa, goc lau oc sêlic yac sac.” Ŋac sêŋyalê bu lau daêsam sêlic Jon bu propet daŋ, dec sêtöc dau. ");
INSERT INTO buk_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bocdinaŋ sêsôm têŋ Yisu, “Yac aŋyalê dom.” Ma iŋ sôm têŋ ŋac, “Bocdinaŋ aö wasôm aneŋ ŋaclai ŋahu asê têŋ mac dom.” ");
INSERT INTO buk_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ma iŋ gic hu yom gôliŋ daŋ ma sôm têŋ lau bata Israel-ŋga dinaŋ, “Ŋgac daŋ sô ôm wain-ŋga daŋ. Iŋ sô tuŋ sa, kêmasaŋ gameŋ tu lau sêmasaŋ wain ŋakwi-ŋga, ma kwê andu baliŋ daŋ bu lau sêlhac ma sêtip lau kaŋ. Tiŋambu iŋ kêŋ ôm dau têŋ lau ŋatô sêyob, ma kölhö gi mbo gameŋ daŋ. ");
INSERT INTO buk_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Têŋ têm sêndic wain ŋandô sa-ŋga, naŋ ŋadau kêkiŋ ŋgac akiŋ daŋ têŋ lau sêyob ôm-ŋga, tu bu sêkêŋ wain ŋandô ŋatô têŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tigeŋ ŋac sêlô iŋ dôŋ, sic iŋ ŋamlic ŋandê, ma sêkêŋ iŋ kölhö amba sawa gi. ");
INSERT INTO buk_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Goc ŋadau kêkiŋ ŋgac akiŋ daŋ tiyham, tigeŋ ŋac sic iŋ pi ŋagôlôŋ, ma sêkôm mêtê sac têŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tiŋambu ŋadau kêkiŋ ŋgac titö-ŋga, magoc ŋac sic iŋ ndu. Ma iŋ kêkiŋ lau daêsam tiyham, ma ŋac sic ŋatô ŋamlic ŋandê, ma sic ŋatô ndu. ");
INSERT INTO buk_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Tiŋambu ŋgac tigeŋ mbo, naŋ ŋadau ndê atuŋgac, naŋ iŋ tac whiŋ ndu andô. Goc ŋadau kêkiŋ ndê atu dau têŋ ŋac gi, ma gauc gêm têŋ dau, ‘Lau naŋ sêyob aneŋ ôm, naŋ oc sêtoc aneŋ atuŋgac dindec sa.’ ");
INSERT INTO buk_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tigeŋ têŋ têm ŋadau ndê atu hôc asê, naŋ lau sêyob ôm-ŋga sêsôm têŋ dau, ‘Ŋgac dinaŋ iŋ ŋadau ndê atuŋgac naŋ oc wêkaiŋ ôm dindec ti ndê gêŋ lêŋsêm. Bocdinaŋ dandic iŋ ndu ma dakôc ôm dindec su ti yac neŋ.’ ");
INSERT INTO buk_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ma sêkôc atuŋgac, sic iŋ ndu ma sêtuc iŋ sa awê gi.” ");
INSERT INTO buk_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Goc Yisu ndac, “Mac gauc gêm bu ôm ŋadau oc kôm sake têŋ lau naŋ sêyob iŋ ndê ôm? Iŋ oc meŋ ma ndic ŋac ndu, ma kêŋ ôm dau têŋ lau ŋatô sêyob. ");
INSERT INTO buk_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Gauc nem yom naŋ sêto yêc bocdec bu, ‘Hoc naŋ lau sêkwê andu-ŋga sêtec, naŋ kwahic ti hoc ŋamata-ŋga yêc andu dau. ");
INSERT INTO buk_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Pômdau kôm gêŋ dau, ma yac alic ŋayham.’ Mac asam yom dau su, me?” ");
INSERT INTO buk_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Têŋ dinaŋ lau bata Israel-ŋga sêŋyalê bu Yisu sôm yom gôliŋ dau hêganôŋ ŋac, dec sêŋsalê lêŋ bu sêkôc iŋ dôŋ. Magoc sêtöc lau toŋ atu naŋ sêmbo sêwhiŋ Yisu, ma tu dinaŋ-ŋga sêhu iŋ siŋ ma sêlhö si. ");
INSERT INTO buk_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tiŋambu lau bata dinaŋ sêŋsalê lêŋ bu sêtim Yisu bu sôm yom so daŋ. Ŋac sêŋkiŋ lau Palêsai ŋatô sêwhiŋ lau Israel-ŋga ŋatô naŋ sêpuc Herod ma lau Rom-ŋga si gôliŋ dôŋ, naŋ sêtêŋ Yisu si. ");
INSERT INTO buk_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ŋac sêhôc asê iŋ ma sêsôm, “Kêdôhôŋ-waga, yac aŋyalê bu am ŋgac sôm yom ŋandô-ŋga. Am gauc gêm lau si waê dom, ma toc ŋac hoŋ sa ŋalêŋ tigeŋ. Ma am kêdôhôŋ Anötö ndê lêŋ têŋ lau kêkuc yom ŋandô solop. Kwahic dec yac bu andac am bu iŋ solop bu yac dakêŋ takis t êŋ †Sisa, me mba? Yac oc danemlhi takis, me mba?” ");
INSERT INTO buk_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yisu ŋgô yom dau, tigeŋ iŋ kêyalê bu ŋac gauc gêm bu sêtim iŋ, dec sôm, “Tu sake-ŋga mac bu atim aö? Akôc mone silba daŋ ma atôc têŋ aö.” ");
INSERT INTO buk_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Goc sêkêŋ mone daŋ têŋ iŋ, ma iŋ ndac ŋac, “Asa ndê ŋagatu ti ŋaê yêc mone dindec?” Ma sêô yom ma sêsôm, “Sisa ndê.” ");
INSERT INTO buk_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Dec Yisu sôm, “Bocdinaŋ atoc Sisa sa ŋa gêŋ naŋ gic iŋ ŋawaê, ma atoc Anötö sa ŋa gêŋ naŋ gic iŋ ŋawaê.” Ŋac sêŋgô Yisu ndê yom dau, ma sêhêdaê tu iŋ ndê gauc-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ma lau †Sadiusi ŋatô sêtêŋ Yisu si, bu sêkêŋ gêndac daŋ têŋ iŋ. Ŋac lau Israel si toŋ daŋ, naŋ sêkêŋ whiŋ dom bu lau batê oc sêtisa tiyham. ");
INSERT INTO buk_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ma ŋac sêndac iŋ bocdec bu, “Kêdôhôŋwaga, Moses to yac neŋ yomsu daŋ bocdec bu. Ŋgac daŋ bu ndê dôwa nem awhê sa ma bu mbac ndu ma balêkoc mbasi, naŋ ŋgac dau oc nem dôwa ndê awhê sawa, ma kwê balêkoc asê tu dôwa-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Têŋ ndoc daŋ asidôwai 7 sêmbo. Ŋgac ŋamata-ŋga gêm awhê sa, magoc mbac ndu, ma balêkoc mba. ");
INSERT INTO buk_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Goc iŋ asi, ŋgac tilu-ŋga, gêm awhê sawa dau, magoc mbac ndu ma balêkoc mba. Ŋgac titö-ŋga bocdinaŋ, ");
INSERT INTO buk_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ma asidôwa hale bocdinaŋ, hoŋ sem awhê sawa dau sa, magoc sêmbac ndu, ma balêkoc mba. Ma tiŋambu awhê dau mbac ndu. ");
INSERT INTO buk_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kwahic dec yac bu andac am bocdec bu. Lau batê bu sêtisa tôm lau ŋatô sêsôm, dec awhê dau oc ti asidôwa asa ndê awhê? Bu asidôwai 7 dinaŋ hoŋ sem awhê tigeŋ dinaŋ su têŋ ndoc sêmbo tali.” ");
INSERT INTO buk_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ma Yisu sôm têŋ ŋac, “Mac akôc gauc so, bu mac aŋyalê Anötö ndê yom ti iŋ ndê ŋaclai dom. ");
INSERT INTO buk_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Têŋ têm lau batê sêtisa, naŋ lau oc sênem dau dom. Ŋac oc sêmbo sêtôm aŋela undambê-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ma yom daŋ tiyham tôc asê bu lau batê oc sêtisa. Mac asam su yêc Moses ndê buku. Têŋ ndoc Moses gêlic ya golom a daŋ, naŋ Anötö sôm têŋ iŋ bu, ‘Aö Abraham ndê Anötö, Aisak ndê Anötö ma Jakob ndê Anötö.’ ");
INSERT INTO buk_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Lau batê bu sêtisa dom, dec tu sake-ŋga Anötö sam dau bu lau tö dinaŋ si Anötö? Iŋ lau batê si Anötö dom, iŋ lau tali si Anötö. Mac nem gauc iŋ so sambuc.” ");
INSERT INTO buk_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kêdôhôŋwaga yomsu-ŋga daŋ kalhac whiŋ lau naŋ sêkêŋ daŋga Yisu ma lau Sadiusi si yom, ma iŋ gêlic bu Yisu ô lau Sadiusi si yom ŋapep. Bocdinaŋ iŋ ndac Yisu, “Anötö ndê yomsu bocke ti yomsu ŋamata-ŋga?” ");
INSERT INTO buk_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ma Yisu sôm, “Yomsu ŋamata-ŋga naŋ hôc gêlêc yomsu hoŋ naŋ bocdec, ‘Mac lau Israel-ŋga aŋgô! Pômdau yac neŋ Anötö iŋ Pômdau tigeŋ. ");
INSERT INTO buk_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Atac whiŋ Pômdau am nem Anötö ti am nem ŋalôm sambuc, ti gatôm sambuc, ti gauc sambuc, ma ti licwalô sambuc.’ ");
INSERT INTO buk_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma yomsu tilu-ŋga bocdec yêc, ‘Atac whiŋ lau meŋpaŋ am-ŋga, tôm am atac whiŋ am daôm.’ Yomsu lu dinaŋ sêhôc gêlêc yomsu hoŋ su.” ");
INSERT INTO buk_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Goc kêdôhôŋwaga yomsu-ŋga dau sôm têŋ Yisu, “Kêdôhôŋwaga, am sôm solop. Yomandô, Anötö tigeŋ mbo, ma anötö ŋandô daŋ mbo dom. ");
INSERT INTO buk_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ma yac bu atac whiŋ A nötö ti neŋ ŋalôm sambuc, ti gauc sambuc, ma ti licwalô sambuc, ma yac bu atac whiŋ lau meŋpaŋ yac-ŋga tôm yac atac whiŋ yac dauŋ, naŋ hôc gêlêc bu yac dakêŋ wata ti da pi ya ndi, me bu dakêŋ gêŋ ŋatô ti da.” ");
INSERT INTO buk_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yisu gêlic bu ŋgac dau ô yom ti gauc ŋayham, dec sôm têŋ iŋ, “Êmkuc gauc ŋayham dinaŋ dec am oc tôm bu mbo Anötö ndê gôliŋ ŋalôm.” Yisu sôm yom dinaŋ, ma tiŋambu lau sêtöc bu sêkêŋ gêndac têŋ iŋ tiyham. ");
INSERT INTO buk_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yisu kêdôhôŋ lau mbo lôm dabuŋ ŋamakê, ma ndac ŋac, “Bocke ma lau †Skraib sêsam Mesaya bu Dawid ndê Atu? ");
INSERT INTO buk_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawid dau hoc yom asê tôm Ŋalau Dabuŋ puc iŋ dôŋ, ma to yom pi Mesaya bocdec bu, ‘Anötö sôm têŋ aneŋ Pômdau, “Am ndöc aö amaŋ andô-ŋga e nditôm aö wakêŋ nem ŋacyo sêsôc am gahim ŋapu.” ’ ");
INSERT INTO buk_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawid dau sam Mesaya bu iŋ ndê Pômdau, ma bocke dec lau sêsam iŋ bu Dawid ndê Atu?” Ma lau hoŋ sêŋgô Yisu ndê yom ti atac ŋayham atu. ");
INSERT INTO buk_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ma Yisu kêdôhôŋ lau ma sôm, “Ayob daôm ŋapep bu aŋkuc lau Skraib si gêbôm dom. Ŋac sêsôc ŋakwê baliŋ ma sêŋsêlêŋ sêmbo malac lôm, bu ŋac atac whiŋ bu lau sêtoc ŋac sa ma sêhê mwalêc ŋac. ");
INSERT INTO buk_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ŋac atac whiŋ bu sêndöc mala ŋamata-ŋga yêc lôm wê-ŋga, ma sêndöc lau tiwaê si mala têŋ ndoc sêneŋ mwasiŋ. ");
INSERT INTO buk_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yêc lau hoŋ aŋgô-ŋga lau dau sêteŋ mbec baliŋ. Magoc têŋ ndoc lau sêlic ŋac dom, naŋ sêŋsau lauwhê sawa bu sêŋgaho ŋac si andu su. Anötö oc êmatôc ŋac, ma kêŋ ŋagêyô sac sambuc têŋ ŋac.” ");
INSERT INTO buk_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tiŋambu Yisu ndöc sic ndöc lôm dabuŋ ŋabatêmndö kêpiŋ apa naŋ lau sêkêŋ si da sip-ŋga, ma tahê lau hoŋ naŋ sêkêŋ si da sip apa dau. Lau ti lêlôm daêsam sêkêŋ awa atu. ");
INSERT INTO buk_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tigeŋ awhê tuc ŋalôm sawa daŋ meŋ ma kêŋ awa sauŋ lu gitôm wan toea lu sip apa da-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Goc Yisu ta ndê ŋgac-sêŋomi sêmeŋ ma sôm, “Yomandô, aö wasôm têŋ mac bu yêc Anötö aŋgô-ŋga awhê tuc ŋalôm sawa dindec kêŋ da naŋ hôc gêlêc lau hoŋ si da su. ");
INSERT INTO buk_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ŋahu bu lau ti lêlôm hoŋ sêkêŋ si da, magoc ŋac si awa daêsam gacgeŋ yêc ŋac-ŋga. Magoc awhê dindec iŋ awhê ŋalôm sawa, ma iŋ kêŋ ndê gêŋ hoŋ ti da.” ");
INSERT INTO buk_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Têŋ ndoc Yisu bu hu lôm dabuŋ ŋagameŋ siŋ, naŋ iŋ ndê ŋgacsêŋom daŋ sôm têŋ iŋ, “Kêdôhôŋwaga, lic hoc atu-tu ma andu ŋayham kêlêc naŋ sêkwê sa sêlhac dec.” ");
INSERT INTO buk_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Magoc Yisu ô yom ma sôm têŋ iŋ, “Am lic andu atu-tu ti lôm dabuŋ dindec! Aö wasôm têŋ am, bu tiŋambu ŋacyo oc sêseŋ hoc atu-tu hoŋ dindec su e hoc daŋ oc ndöc hoc daŋ ŋahô tiyham dom.” ");
INSERT INTO buk_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ŋac sêsa sêtêŋ Lôc Olib si, ma tiŋambu Pita, Jems, Jon ma Andru tawasê sêtêŋ Yisu si ma sêndöc aŋgô têŋ lôm dabuŋ yêc malac Jerusalem. Ma ŋac sêndac iŋ bocdec bu, ");
INSERT INTO buk_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Sôm têŋ yac bu ŋawapac naŋ am sôm yom pi, naŋ oc hôc asê Jerusalem têŋ têm bocke, ma gêŋ sake oc kêŋ puc yac bu têm dau meŋ kêpiŋ?” ");
INSERT INTO buk_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Goc Yisu sôm têŋ ŋac, “Ayob daôm ŋapep bu lau daŋ sêŋsau mac dom. ");
INSERT INTO buk_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bu lau daêsam oc sêmeŋ sênem aö aŋôŋ ma sêsôm, ‘Aö Mesaya dauŋ dec,’ ma oc sêŋsau lau daêsam. ");
INSERT INTO buk_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ma têŋ ndoc mac aŋgô ŋawaê bu lau sic siŋ têŋ dau me sêmasaŋ dau tu sêndic siŋ-ŋga, naŋ asö dom. Bu gêŋ hoŋ dinaŋ gic waê bu meŋ sa, m agoc têm ŋambu-ŋga yêc dôŋ yêc. ");
INSERT INTO buk_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kiŋ nom-ŋga oc sêkêŋ kisa dau, ma lau gameŋ daŋ oc sêndic siŋ têŋ lau gameŋ daŋ. Tiyhô oc nem yêc gameŋ hoŋ, ma tôbôm oc sa. Gêŋ hoŋ dinaŋ oc ndic hu ŋawapac têm ŋambu-ŋga-ŋga, gitôm awhê naŋ kêsahê balêkoc tuŋ iŋ ma gêŋ dau gic hu ŋandê atu naŋ iŋ oc hôc tu kôc balêkoc-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","10","“Gêŋ ŋamata-ŋga lau oc sêhoc ŋawaê ŋayham asê têŋ lau sambob, ma têŋ dinaŋ têm ŋambu-ŋga oc meŋ hôc asê. Ayob daôm ŋapep. Lau oc sêwê mac atêŋ lau sêmatôc yom-ŋga andi, ma sêhi mac ŋa sö yêc lôm wê-ŋga. Tu aö-ŋga dec lau oc sêkêŋ mac alhac gôliŋwaga ti kiŋ aŋgô-ŋga, magoc ndoc dinaŋ ti têm bu mac ahoc yom ŋandô asê têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Têŋ têm naŋ sêkôc mac dôŋ ma sêwê mac atêŋ lau sêmatôc mac-ŋga andi, naŋ ahêgo daôm tu yom asôm-ŋga dom. Asôm yom naŋ Anötö oc kêŋ têŋ mac têŋ ndoc dinaŋ, bu mac daôm oc asôm yom dom, Ŋalau Dabuŋ oc sôm. ");
INSERT INTO buk_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Têŋ ndoc ŋawapac-ŋga dinaŋ, lau naŋ sêkêŋ whiŋ dom oc sêhoc si asidôwai sêkêŋ whiŋ aö-ŋga asê bu sêndic ŋac ndu, ma dambai oc sêkôm têŋ atui boc-dinaŋ. Balêkoc oc sêli dau sa têŋ damba ti dindai, ma sêkêŋ ŋac sêtêŋ lau bu sêndic ŋac ndu. ");
INSERT INTO buk_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Lau hoŋ oc sêtec mac tu aö neŋ ŋaê-ŋga. Magoc asa naŋ bu lhac ŋaŋga ma hu aö siŋ dom e ndê têm pacndê, naŋ oc tap Anötö ndê mwasiŋ nem iŋ si-ŋga sa.” ");
INSERT INTO buk_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Gêŋ sac sambuc naŋ oc kôm gameŋ tisac, naŋ lau oc sêkêŋ lhac gameŋ naŋ gic iŋ ŋawaê dom. (Asa naŋ sam yom dindec, naŋ kôc gauc ŋapep, bu ŋahu yêc siŋ dau.) Mac lau asa naŋ ambo gameŋ Judia-ŋga ma alic gêŋ dau, naŋ hoŋ alhö api gameŋ lôc-ŋga andi. ");
INSERT INTO buk_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Alhö ŋagahô ma gauc nem mac nem gêŋ daŋ dom. Lau naŋ sêŋwhaŋ dau sêndöc andu ŋasactô, naŋ sêsôc andu ŋalôm bu sêkôc si gêŋ daŋ tôhôŋ dom. ");
INSERT INTO buk_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ma ŋac naŋ sêmbo ôm, naŋ bocdinaŋ. Sêkac dau kwi bu sêkôc si gêŋ ŋatô dom. ");
INSERT INTO buk_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Oyaê. Lauwhê tidaê, ma ŋac naŋ sêkêŋ su têŋ balêkoc, naŋ oc sêtap ŋawapac atu sa têŋ têm dinaŋ. ");
INSERT INTO buk_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ateŋ mbec bu gêŋ dinaŋ tap mac sa têŋ ndoc uhô-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ŋahu bu ŋawapac ŋandô naŋ bu sa têŋ têm dinaŋ, naŋ oc hôc gêlêc ŋawapac hoŋ naŋ sêhôc asê nom têŋ têm naŋ Anötö kêŋ undambê ti nom e kwahic dec, ma tiŋambu oc sa bocdinaŋ tiyham dom. ");
INSERT INTO buk_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Magoc Pômdau oc kêŋ ndoc dinaŋ tiapê tu bu nem lau naŋ iŋ kêyaliŋ sa su, naŋ sa-ŋga. Bu mba, goc lau hoŋ oc sêniŋga. ");
INSERT INTO buk_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Têŋ ndoc dinaŋ ŋgac daŋ bu sôm têŋ mac bu, ‘Alic, Mesaya dau dindec,’ me ‘Alic, Mesaya dau dindê,’ naŋ akêŋ whiŋ ŋac dom. ");
INSERT INTO buk_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Lau naŋ sêŋsau bu ŋac Mesaya, ma propet tasaŋ oc sêmeŋ ma sêkôm gêŋ dalô ti gêŋ atu-tu bu sêŋsau lau. Ma ŋac oc sêŋsahê bu sêtim lau naŋ Anötö kêyaliŋ ŋac sa, naŋ sêwhiŋ. ");
INSERT INTO buk_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Aö gakêŋ puc mac gwanaŋ, ma bocdinaŋ ayob daôm ŋapep.” ");
INSERT INTO buk_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ma Yisu sôm, “Ndoc ŋawapac-ŋga dinaŋ oc pacndê, ma tiŋambu lau oc sêlic gêŋ dalô atu-tu. Ac oc nem ganduc ma ayô oc ŋawê tiyham dom. ");
INSERT INTO buk_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ma tata oc sêpeŋ akêŋ umboŋ, ma gêŋ ti ŋaclai naŋ sêlhac umboŋ oc wiwic sa. ");
INSERT INTO buk_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ma tiŋambu lau oc sêlic Ŋamalac ndê Atu meŋ ndöc dao ŋahô ti ndê ŋaclai ma ŋawasi atu. ");
INSERT INTO buk_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma iŋ oc êŋkiŋ ndê aŋela sêsa sêtêŋ nom ŋabatiŋ ti undambê ŋabatiŋ hoŋ sêndi, bu sêndic lau naŋ iŋ kêyaliŋ ŋac sa su, naŋ sa. ");
INSERT INTO buk_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Gauc nem a laŋ. Têŋ ndoc mac alic ŋalauŋ wakuc bu lêc, naŋ mac aŋyalê bu ndoc ac-ŋga meŋ kêpiŋ. ");
INSERT INTO buk_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ma bocdinaŋ têŋ ndoc mac alic gêŋ naŋ aö gasôm yom pi, naŋ hôc asê, dec aŋyalê bu Ŋamalac ndê Atu ndê bêc mbu meŋ-ŋga meŋ kêpiŋ su, gitôm iŋ meŋ kalhac gatam. ");
INSERT INTO buk_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yomandô! Lau têm dinaŋ-ŋga oc sêniŋga dom e gêŋ hoŋ dinaŋ hôc asê. ");
INSERT INTO buk_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Undambê ti nom oc niŋga, magoc aneŋ yom oc niŋga dom. Gêŋ hoŋ oc ŋandô sa tôm aö gasôm.” ");
INSERT INTO buk_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ma Yisu sôm, “Lau daŋ sêŋyalê bêc me acgatu naŋ Ŋamalac ndê Atu oc mbu meŋ, naŋ dom. Aŋela undambê-ŋga sêŋyalê dom, Anötö ndê Atu kêyalê dom, Damaŋ tawasê kêyalê. ");
INSERT INTO buk_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Bocdinaŋ anem ali ma ayob daôm ŋapep! Mac am gauc têm naŋ bêc ŋambu-ŋga dau oc meŋ sa. ");
INSERT INTO buk_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Gitôm andu ŋadau daŋ naŋ bu sa ndi lic gameŋ ŋatô. Iŋ hu ndê andu siŋ ma kêŋ iŋ ndê lau akiŋ sêwêkaiŋ si gweleŋ têŋtêŋ. Ma iŋ oc sôm têŋ ŋgac yob gatam-ŋga, bu iŋ nem ali ma tatiŋ gameŋ ŋapep e iŋ mbu meŋ. ");
INSERT INTO buk_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Bocdinaŋ anem ali, bu mac aŋyalê ndoc naŋ andu ŋadau oc mbu meŋ, naŋ dom. Iŋ oc hôc asê têŋ telha me timaniŋhu, me dalec taŋ, me bêbêc ganduc, naŋ mac aŋyalê dom. ");
INSERT INTO buk_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ayob daôm ŋapep, mboe iŋ oc mbu meŋ ŋagahô, ma tap mac sa ayêc bêc ayêc. ");
INSERT INTO buk_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yom naŋ aö gasôm têŋ mac, naŋ dec wasôm têŋ lau hoŋ bocdinaŋ. Anem ali!” ");
INSERT INTO buk_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Lau Israel si †Mwasiŋ Pasowa ti †Mwasiŋ Bolom Yist Mba-ŋga ŋandoc meŋ kêpiŋ, ma bêc lu yêc dôŋ yêc. Ma dabuŋ-siga atu-tu ti lau naŋ sêndôhôŋ yomsu-ŋga sêŋsalê lêŋ daŋ bu sêkôc Yisu dôŋ gelec ma sêndic iŋ ndu. ");
INSERT INTO buk_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tigeŋ sêhêgo dau ma sêsôm, “Dakôm têŋ Mwasiŋ Pasowa-ŋga ŋandoc dom, mboe lau daêsam naŋ sêmbo Jerusalem tu om atu Pasowa-ŋga, naŋ oc sêlic ma sêli dau sa.” ");
INSERT INTO buk_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Têŋ têm dinaŋ Yisu mbo malac Betani, ma gêŋ gêŋ ndöc whiŋ ŋgac daŋ ŋaê Saimon. Muŋ-ŋga iŋ ŋgac ti gêmbac leprasi. Yisu ndöc tebo ma awhê daŋ meŋ, naŋ kôc bu ŋamalu ŋayham ŋaôli atu sip kac daŋ. Iŋ kac gêŋ dau sa, ma kêc gêŋ malu dau pi Yisu ndê ŋagôlôŋ. ");
INSERT INTO buk_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Lau ŋatô sêlic dec tac ŋandê têŋ awhê dau, ma sêsôm, “Tu sake-ŋga iŋ kêyaiŋ gêŋ ŋamalu dinaŋ? ");
INSERT INTO buk_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Gitôm bu dakêŋ têŋ lau sênemlhi ma datap awa atu sa, ma dakêŋ têŋ lau ŋalôm sawa. Ŋaôli dau oc hôc gêlêc ŋaôli tu gweleŋ yala sambuc-ŋga su.” Ma sêhec yom iŋ ŋalêŋ sac. ");
INSERT INTO buk_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Magoc Yisu sôm, “Ahu iŋ siŋ ma akêŋ ŋawapac têŋ iŋ dom. Iŋ kôm gêŋ ŋayham solop têŋ aö. ");
INSERT INTO buk_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Lau ŋalôm sawa oc sêmbo sêwhiŋ mac ŋapaŋ, ma bocdinaŋ dec têm bocke mac bu atac whiŋ, naŋ oc tôm bu mac anem ŋac sa. Tigeŋ aö oc wambo wawhiŋ mac ŋapaŋ dom. ");
INSERT INTO buk_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Awhê dindec gitôm bu êmwasiŋ aö ŋalêŋ dinaŋ, dec kôm. Iŋ kêc gêŋ ŋamalu pi aö, dec tôm iŋ kêmasaŋ aö neŋ ŋamlic gwanaŋ tu sêŋsuhuŋ aö-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yomandô aö wasôm têŋ mac, bu tiŋambu lau oc sêhoc ŋawaê ŋayham asê yêc gameŋ hoŋ, ma têŋ dinaŋ ŋac oc sêsôm yom pi awhê dindec ma lau oc gauc nem iŋ.” ");
INSERT INTO buk_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Têŋ ndoc dinaŋ Judas Iskeriot, ŋgacsêŋomi 12 si daŋ, têŋ dabuŋsiga atu-tu gi ma sôm bu iŋ oc hoc Yisu asê têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ŋac sêŋgô iŋ ndê yom ti atac ŋayham, ma sêsôm tidôŋ bu sênemlhi iŋ. Bocdinaŋ iŋ kêsalê lêŋ tu bu hoc Yisu asê-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Têŋ Mwasiŋ Bolom Yist Mba-ŋga ŋabêc ŋamata-ŋga, bêc naŋ lau Israel-ŋga sic domba Pasowa-ŋga ndu, naŋ ŋgacsêŋomi sêsôm têŋ Yisu bu, “Am tac whiŋ bu yac amasaŋ Mwasiŋ Pasowa bu am neŋ whiŋ yac-ŋga yêc nde?” ");
INSERT INTO buk_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dec Yisu kêkiŋ ndê ŋgacsêŋom lu ma sôm têŋ iŋlu, “Asôc malac Jerusalem andi, ma amlu oc atap ŋgac daŋ sa naŋ kêbalaŋ bu lôŋ daŋ. Awhiŋ iŋ atêŋ iŋ ndê ŋadau ndê andu andi. ");
INSERT INTO buk_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ma asôm têŋ andu ŋadau, ‘Alu mba kêdôhôŋwaga ndac am tu andu ŋalôm ŋacleŋ-ŋga, bu iŋ ti ndê ŋgacsêŋomi bu sêneŋ Mwasiŋ Pasowa-ŋga yêc am nem andu.’ ");
INSERT INTO buk_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ma iŋ oc tôc ŋalôm atu daŋ yêc andu dau ŋahô-ŋga têŋ amlu. Tebo ti gêŋ hoŋ tu yac daneŋ Mwasiŋ Pasowa-ŋga yêc ŋalôm dau, goc amasaŋ gêŋ yêc dinaŋ.” ");
INSERT INTO buk_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Goc sêŋom lu dinaŋ sêsôc malac si, ma sêtap gêŋ hoŋ sa tôm Yisu sôm su, ma sêmasaŋ Pasowa. ");
INSERT INTO buk_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Têŋ ac gi su Yisu ti ŋgacsêŋomi 12 sêtêŋ andu dau si. ");
INSERT INTO buk_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ŋac sêndöc ti seŋ gêŋ sêmbo, ma Yisu sôm, “Yomandô aö wasôm têŋ mac, bu mac nem daŋ oc hoc aö asê. Ŋgac dau kwahic dec ndöc ma gêŋ gêŋ whiŋ aö.” ");
INSERT INTO buk_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yom dau kôm ŋac sêsö, ma ŋalôm ŋawapac atu, ma ŋac tigeŋ-tigeŋ sêsôm têŋ iŋ, “Mboe aö, a? Mba!” ");
INSERT INTO buk_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Goc iŋ sôm têŋ ŋac, “Ŋgac dau iŋ mac lau 12 nem daŋ, ma kwahic dec alu aŋ gêŋ sip pele tigeŋ. ");
INSERT INTO buk_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Gêŋ dau oc ŋandô sa pi Ŋamalac ndê Atu, tôm yom naŋ sêto yêc. Tigeŋ ŋgac naŋ hoc aö asê, naŋ oc tap ŋawapac atu sa, ma tu dinaŋ-ŋga iŋ dinda bu kôc iŋ dom, dec oc ŋayham.” ");
INSERT INTO buk_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Têŋ têm ŋac seŋ gêŋ sêmbo, naŋ Yisu kôc bolom, gêm mbec, pô kôc-kôc, ma gic sam têŋ ŋac. Ma iŋ sôm, “Akôc sa loc, aö neŋ ŋandô dau dindec.” ");
INSERT INTO buk_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ma iŋ kôc laclhu wain-ŋga daŋ ma gêm daŋge, goc kêŋ têŋ ŋac ma ŋac hoŋ sênôm. ");
INSERT INTO buk_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Iŋ sôm têŋ ŋac, “Aö neŋ dac wamatiŋ pwac-ŋga dau dec, naŋ wakêc siŋ tu lau daêsam-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yomandô aö wasôm têŋ mac bu aö oc wanôm wain tiyham dom e Damaŋ ndê gôliŋ meŋ sa tiawê, ma têŋ ndoc dinaŋ aö wanôm tiyham.” ");
INSERT INTO buk_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tiŋambu ŋac sem wê daŋ, ma sêlhö sêsa sêtêŋ Lôc Olib si. ");
INSERT INTO buk_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ma Yisu sôm têŋ ŋac, “Mac hoŋ oc ahu aö siŋ, tôm yom naŋ sêto yêc bocdec bu, ‘Aö oc waseŋ ŋgac yob domba-ŋga, ma domba oc sêlhö babalip.’ ");
INSERT INTO buk_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Magoc tiŋambu aö watisa tiyham, ma wamuŋ mac watêŋ gameŋ Galili-ŋga wandi.” ");
INSERT INTO buk_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Dec Pita sôm têŋ iŋ, “Ŋac hoŋ bu sêhu am siŋ, tigeŋ aö wahu am siŋ dom.” ");
INSERT INTO buk_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ma Yisu ô yom ma sôm, “Aö wasôm yomandô bu ôbwêc dau dindec am oc sêc aö ahuc tidim tö su, goc dalec oc taŋ tidim lu-ŋga.” ");
INSERT INTO buk_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tigeŋ Pita sôm yom ti ŋaŋga, “Mba! Gitôm sêndic aö ndu wawhiŋ am, aö oc wasêc am ahuc dom.” Ma ŋac hoŋ sêsôm yom kaiŋ tigeŋ. ");
INSERT INTO buk_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ŋac sêsa si e sêhôc asê ôm †olib-ŋga daŋ, ôm naŋ sêsam bu Getsemani, ma Yisu sôm têŋ ndê ŋgacsêŋomi, “Andöc dec ma aö wateŋ mbec.” ");
INSERT INTO buk_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Goc iŋ kôc Pita, Jems ma Jon sêwhiŋ iŋ si, ma sêhu ŋgacsêŋomi ŋatô siŋ. Têŋ ndoc dinaŋ Yisu ndê ŋalôm ŋawapac atu ma iŋ pô sim dau ŋandô. ");
INSERT INTO buk_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Iŋ sôm têŋ ŋac, “Aö neŋ ŋalôm kêsahê ŋawapac atu, kêpiŋ bu oc wambac ndu. Mac andöc dec ma anem ali.” ");
INSERT INTO buk_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Goc iŋ hu ŋac siŋ ma sa ŋasawa sauŋ gi. Iŋ hu dau sip nom gi ma teŋ mbec, bu nditôm goc Anötö nem iŋ sa bu êŋlêc têm hôc ŋandê-ŋga naŋ oc hôc asê iŋ. ");
INSERT INTO buk_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Iŋ sôm, “Damaŋ, O Damaŋ, am gitôm bu kôm gêŋ hoŋ. Kôc laclhu ŋawapac-ŋ ga dindec su yêc aö. Magoc êmkuc aö neŋ atac whiŋ dom, kôm tôm am daôm nem atac whiŋ bu kôm.” ");
INSERT INTO buk_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Iŋ teŋ mbec su, dec mbu gi ma tap sa bu ŋgacsêŋomi sêyêc bêc sêyêc. Goc iŋ uŋ ŋac sa ma sôm têŋ Pita, “Saimon, bocke dec am yêc bêc? Am gitôm dom bu nem ali tôm acgatu ŋasawa tigeŋ, a? ");
INSERT INTO buk_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","A nem ali ma ateŋ mbec bu lêtôm tap mac sa dom. Mac nem gatôm licbalê, tigeŋ ŋamlic kwapac.” ");
INSERT INTO buk_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Goc Yisu sa gi, ma teŋ mbec tigeŋ dinaŋ tiyham. ");
INSERT INTO buk_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pacndê, goc iŋ mbu gi ma gêlic ŋac sêyêc bêc, bu ŋac tandô hê ŋac sa ŋandô. Ma ŋac sêpônda yom tu sêsôm têŋ iŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Goc iŋ gi ma teŋ mbec tidim tö-ŋga. Ma têŋ ndoc iŋ mbu têŋ ŋac tiyham, naŋ iŋ sôm, “Tu sake-ŋga mac ayêc bêc ti aŋwhaŋ daôm ŋapaŋ? Gitôm! Ndoc meŋ hôc asê su bu sêhoc Ŋamalac ndê Atu asê ma sêkêŋ iŋ sip lau sac amba. ");
INSERT INTO buk_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Atisa ma dandi! Alic ŋgac naŋ hoc aö asê dec meŋ su.” ");
INSERT INTO buk_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yisu sôm yom dinaŋ mbo, ma Judas, ŋgacsêŋomi 12 si daŋ hôc asê whiŋ lau daêsam naŋ sêhôc bieŋ ti síŋ. †Dabuŋsiga atu-tu ti kêdôhôŋwaga yomsu-ŋga ma lau bata sêŋkiŋ lau toŋ dinaŋ sêwhiŋ Judas sêmeŋ. ");
INSERT INTO buk_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas kêŋ puc lau d au gwanaŋ su, ma sôm, “Ŋgac naŋ mac aŋsalê, naŋ aö oc waŋgutô iŋ bu watôc iŋ asê têŋ mac. Akôc iŋ dôŋ ma akêŋ lau sêyob iŋ, goc awê iŋ sa andi.” ");
INSERT INTO buk_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Bocdinaŋ têŋ ndoc Judas hôc asê, naŋ iŋ têŋ Yisu solop gi ma sôm, “Kêdôhôŋwaga,” ma ŋgutô iŋ. ");
INSERT INTO buk_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dec lau naŋ sêwhiŋ Judas, naŋ sêkôc Yisu dôŋ. ");
INSERT INTO buk_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yisu ndê lau sêlhac sêmpiŋ iŋ, ma ŋac si daŋ puc ndê bieŋ sa ma pa dabuŋsiga atu ndê ŋgac akiŋ ndê daŋgalauŋ daŋ su. ");
INSERT INTO buk_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Goc Yisu sôm, “Bocke dec mac akôc bieŋ ti gêŋ siŋ-ŋga ma asa ameŋ bu akôc aö dôŋ gitôm ŋgac kaŋ daŋ? ");
INSERT INTO buk_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tôm bêc hoŋ aö gambo gawhiŋ mac ma kadôhôŋ lau yêc lôm dabuŋ ŋabatêmndö, magoc mac akôc aö dôŋ dom. Tigeŋ gêŋ naŋ mac akôm kwahic dec, naŋ kôm Anötö ndê yom naŋ sêto yêc, naŋ ŋandô sa.” ");
INSERT INTO buk_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Têŋ dinaŋ Yisu ndê lau hoŋ sêhu iŋ siŋ ma sêlhö si. ");
INSERT INTO buk_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ŋgac batac daŋ kêkuc Yisu ma mbo whiŋ iŋ ti ndê lau têŋ ôbwêc dinaŋ, ma iŋ puc po ŋambwa. Lau siŋ bu sêlô iŋ dôŋ, ");
INSERT INTO buk_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","tigeŋ iŋ hu ndê po siŋ yêc ŋac si amba, ma kölhö ŋamlic ŋambwa gi. ");
INSERT INTO buk_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Dabuŋsiga atu-tu Israel-ŋga, ti lau bata ma kêdôhôŋwaga yomsu-ŋga hoŋ sêkac sa sêmbo dabuŋsiga ŋamata-ŋga ndê andu. Ma lau naŋ sêkôc Yisu dôŋ sêwê iŋ sêtêŋ andu dau si. ");
INSERT INTO buk_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita kêsêlêŋ kêkuc Yisu mbo ahê, e gi sôc dabuŋsiga ŋamata-ŋga ndê andu ŋatuŋlôm gi. Ma iŋ ndöc sic whiŋ lau siŋ sêyob lôm dabuŋ-ŋga ŋatô ma kêsulu ya. ");
INSERT INTO buk_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Dabuŋsiga atu-tu ma lau bata hoŋ naŋ sêndöc Sanedrin si toŋ, naŋ sêŋsalê yom bu sêŋgôliŋ pi Yisu ma sêkêŋ iŋ sip lau Rom-ŋga amba bu sêndic iŋ ndu. Magoc sêtap yom daŋ sa dom. ");
INSERT INTO buk_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bu lau daêsam sêtisa bu sêhoc yom tasaŋ asê pi Yisu, magoc ŋac hoŋ si yom so dau. ");
INSERT INTO buk_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tiŋambu lau ŋatô sêtisa, ma sêkêŋ yom tasaŋ pi iŋ bocdec bu, ");
INSERT INTO buk_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Yac aŋgô ŋgac dau sôm, ‘Lôm dabuŋ naŋ ŋamalac sêkwê sa, naŋ aö oc waseŋ su. Ma têŋ bêc titö-ŋga aö oc wakwê andu wakuc daŋ sa, naŋ gitôm andu naŋ ŋamalac sêkwê, naŋ dom.’” ");
INSERT INTO buk_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Magoc ŋac tigeŋ-tigeŋ si yom so dau tiyham. ");
INSERT INTO buk_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Goc dabuŋsiga ŋamata-ŋga tisa kalhac ŋalhu, ma ndac Yisu, “Am ŋgô yom dê sêŋgôliŋ pi am, me? Am bu ô yom, me mba?” ");
INSERT INTO buk_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tigeŋ Yisu gêm dau dôŋ ma ô yom dom. Goc dabuŋsiga dau ndac iŋ tiyham, “Am Mesaya dau, Anötö Atuŋgac, me mba?” ");
INSERT INTO buk_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ma Yisu sôm, “Aêc, aö dauŋ dindec. Ma tiŋambu mac oc alic Ŋamalac ndê Atu ndöc Anötö Ŋaclai Ŋadau ndê amba andô-ŋga, ma sip meŋ ndöc dao ŋahô.” ");
INSERT INTO buk_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Têŋ ndoc dabuŋsiga ŋamata-ŋga ŋgô yom dinaŋ, naŋ tac ŋandê atu dec kêc dau ndê ŋakwê kic ma sôm, “Yac dapônda yom daŋ tu taŋgôliŋ pi iŋ-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yom naŋ iŋ sôm pi dau, naŋ sac sambuc! Mac aŋgô su, ma mac gauc gêm bocke?” Ma ŋac hoŋ sêsôm pitigeŋ bu iŋ mbac ndu. ");
INSERT INTO buk_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Lau ŋatô sêhu gasôp pi iŋ. Ŋac sêkic iŋ tandô ahuc ŋa po, goc sêtap iŋ ma sêsôm, “Am bu propet, naŋ sôm asê bu asa gic am.” Ma lau siŋ-ŋga sêkôc iŋ sêsa si, ma sêhi iŋ ŋa sö. ");
INSERT INTO buk_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Têŋ têm dinaŋ Pita mbo andu dau ŋamakê, ma dabuŋsiga ŋamata-ŋga ndê awhê akiŋ daŋ kêsêlêŋ meŋ. ");
INSERT INTO buk_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Iŋ gêlic Pita kêsulu ya mbo, goc tahê iŋ ma sôm, “Am ŋgac naŋ kêkuc Yisu Nasaret-ŋga whiŋ.” ");
INSERT INTO buk_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Magoc Pita pa dau ma sôm, “Mba, aö kayalê am nem yom ŋahu dom.” Dec iŋ tisa gi kalhac kêpiŋ tuŋlôm ŋagatam. ");
INSERT INTO buk_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Malô goc awhê akiŋ dau gêlic iŋ tiyham, ma sôm yom kaiŋ tigeŋ têŋ lau naŋ sêlhac sêmpiŋ, “Alic ŋgac kêlê. Iŋ Yisu ndê lau si daŋ.” ");
INSERT INTO buk_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Magoc Pita pa dau tiyham. Ŋasawa sauŋ ma lau naŋ sêlhac dindê, naŋ sêsôm, “Am ŋgac Galili-ŋga. Yomandô, am ŋac si daŋ.” ");
INSERT INTO buk_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Magoc Pita sôm ti ŋaŋga, “Mba! Aö bu wasôm yom tasaŋ, naŋ goc Anötö ndic aö. Aö kayalê ŋgac naŋ mac asôm yom pi iŋ, naŋ dom andô!” ");
INSERT INTO buk_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ma ŋagahô dalec taŋ tilu-ŋga, dec Pita gauc gêm Yisu ndê yom bu iŋ oc sêc iŋ ahuc tidim tö su, goc dalec oc taŋ tidim lu-ŋga. Ma iŋ taŋ dau ndu-ndu. ");
INSERT INTO buk_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Têŋ bêbêc ganduc, dabuŋsiga atu-tu ti lau bata ma lau naŋ sêndôhôŋ yomsu ti lau †Sanedrin-ŋga hoŋ si ŋalôm tigeŋ tu gêŋ bocke bu sêkôm têŋ Yisu-ŋga. Goc sêsô iŋ amba dôŋ ma sêwê iŋ sêtêŋ Pailot si. ");
INSERT INTO buk_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ma Pailot ndac iŋ, “Am lau Israel-ŋga si kiŋ, a?” Goc Yisu ô yom ma sôm, “Tôm naŋ am daôm sôm.” ");
INSERT INTO buk_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Têŋ dinaŋ dabuŋsiga atu-tu sêŋgôliŋ yom daêsam pi iŋ. ");
INSERT INTO buk_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Dec Pailot ndac iŋ tiyham, “Am oc ô ŋac si yom, me mba? Ŋac sêŋgôliŋ yom daêsam pi am.” ");
INSERT INTO buk_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tigeŋ Yisu ô yom dom, dec Pailot hêdaê. ");
INSERT INTO buk_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","7","Têŋ têm dinaŋ ŋgac daŋ ndöc gapocwalô, naŋ ndê ŋaê Barabas. Muŋ-ŋga lau ŋatô sêli dau sa têŋ lau Rom-ŋga naŋ sem gôliŋ lau Israel-ŋga, ma sic lau ŋatô ndu. Magoc lau Rom-ŋga sêkôc ŋac dôŋ ma sêkêŋ ŋac sêndöc gapocwalô. Ma Barabas iŋ ŋac si daŋ. Tôm yala hoŋ têŋ ndoc lau Israel-ŋga si om atu Mwasiŋ Pasowa-ŋga hôc asê, naŋ Pailot kêkuc lêŋ daŋ bocdec bu. Lau Israel-ŋga oc sêndac ŋgac gapocwalô-ŋga daŋ, dec iŋ oc êŋgapwêc iŋ su têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Lau daêsam naŋ sêkac dau sa têŋ ndoc Pailot kêsahê Yisu, naŋ sêndac iŋ bu êŋgapwêc ŋgac gapocwalô-ŋga daŋ su êŋkuc ŋagôliŋ dinaŋ. ");
INSERT INTO buk_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Pailot kêyalê bu dabuŋsiga atu-tu sem lêmuŋ Yisu ŋambwa, ma tu dinaŋ-ŋga dec sêwê Yisu sêtêŋ iŋ sêmeŋ. Bocdinaŋ iŋ gauc gêm bu êŋgapwêc Yisu su, dec ndac ŋac, “Mac atac whiŋ bu aö wahu Kiŋ Israel-ŋga siŋ têŋ mac, me mba?” ");
INSERT INTO buk_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tigeŋ dabuŋsiga atu-tu sêŋgalôm lau toŋ atu dinaŋ e sêndac Pailot bu hu Barabas siŋ têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Goc Pailot ndac ŋac, “Bocdinaŋ aö oc wakôm sake têŋ ŋgac dindec, naŋ mac asam bu lau Israel-ŋga si Kiŋ?” ");
INSERT INTO buk_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ma sêmbwêc, “Ndic iŋ pi a gicso dau!” ");
INSERT INTO buk_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Magoc Pailot ndac ŋac, “Tu sake-ŋga? Iŋ kôm giso bocke?” Magoc sêmbwêc ti ŋaŋga, “Ndic iŋ pi a!” ");
INSERT INTO buk_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","P ailot bu kôm lau atac ŋayham sa, dec gôlôc bu êŋgapwêc Barabas su têŋ ŋac. Ma iŋ kêkiŋ Yisu têŋ lau siŋ-ŋga bu sêhi iŋ ŋa sö, ma sêndic iŋ ndu pi a gicso dau. ");
INSERT INTO buk_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Lau siŋ-ŋga sêwê Yisu sêsa Pailot ndê andu ŋamalaclôm si, ma sêta yom bu lau siŋ-ŋga hoŋ sêkac sa. ");
INSERT INTO buk_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Goc sêkêŋ Yisu sôc ŋakwê kokoc baliŋ tôm kiŋ sêsôc, ma sêwhê wac kêm ma sêkêŋ iŋ uŋ gitôm suŋsuŋ. ");
INSERT INTO buk_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Goc ŋac sic hu sêmbwêc iŋ, “Ei! Datoc lau Israel-ŋga si kiŋ dindec sa maŋ!” ");
INSERT INTO buk_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ma ŋac sêkôc a daŋ ma sic iŋ pi ŋagôlôŋ tidim daêsam, ma sêhê gasôp pi iŋ. Sêpôŋ haduc têŋ iŋ, ma sêŋsau bu sêtoc iŋ sa. ");
INSERT INTO buk_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Sêsu iŋ susu pacndê, goc sêkôc ŋakwê baliŋ dinaŋ su, ma sêkêŋ iŋ sôc dau ndê ŋakwê sa tiyham. Ma sêwê iŋ sêsa malac Jerusalem ŋamakê si, bu sêndic iŋ ndu pi a gicso dau. ");
INSERT INTO buk_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Lau siŋ-ŋga sêwê Yisu sêmbo seŋ, ma ŋgac daŋ kêsêlêŋ mbo seŋ akêŋ gameŋ ŋamakê-ŋga meŋ. Ma sêkac iŋ bu hôc Yisu ndê a gicso dau. Ŋgac dau ndê ŋaê Saimon. Iŋ Aleksanda lu Rupas damba, ma iŋ ndê malachu Sairin. ");
INSERT INTO buk_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Sêwê Yisu sêsa si e sêhôc asê gameŋ naŋ sêsam bu Golgota. (Ŋaê dau danem kwi bu ‘Gameŋ Ŋakêcyha-ŋga.’ ) ");
INSERT INTO buk_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Lau siŋ-ŋga bu sêkêŋ wain ti bu ŋamakic têŋ Yisu nôm, magoc iŋ tec. ");
INSERT INTO buk_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bocdinaŋ sêhu siŋ, ma sic iŋ pi a gicso dau. Ma tiŋambu sêwhê iŋ ndê ŋakwê kôc ma sêpuc gapoc bu sêlic asa oc kôc ŋakwê bocke. ");
INSERT INTO buk_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ŋac sic iŋ pi a gicso têŋ bêbêc, acgatu gitôm 9 kilok. ");
INSERT INTO buk_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ma yom naŋ lau bata Israel-ŋga sêŋgôliŋ pi iŋ, naŋ sêto pi bapia daŋ, naŋ sôm, “Lau Israel-ŋga si Kiŋ.” ");
INSERT INTO buk_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ŋac sic ŋgac sac lu pi a gicso dau sêwhiŋ, daŋ kêgalêŋ Yisu amba andô-ŋga, ma daŋ kêgalêŋ gasê-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Lau naŋ sêŋsêlêŋ si sêmeŋ, naŋ sêndahiŋ ŋasu ma sêtaŋ bôlê Yisu. Sêsôm, “Ei. Am ŋgac naŋ sôm bu seŋ lôm dabuŋ su ma kwê sa tiyham tôm bêc tö. ");
INSERT INTO buk_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Dec sip akêŋ a gicso dau mweŋ, ma nem daôm sa!” ");
INSERT INTO buk_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ma dabuŋsiga atu-tu ti kêdôhôŋwaga yomsu-ŋga bocdinaŋ sêsu iŋ susu ma sêsôm têŋ dandi, “Iŋ gêm lau daêsam sa, tigeŋ gitôm dom bu nem dau sa. ");
INSERT INTO buk_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yac bu alic Mesaya, lau Israel si kiŋ dindec-ŋga, sip akêŋ a gicso dau meŋ, dec yac oc akêŋ whiŋ iŋ.” Ma ŋgac lu naŋ sic pi a gicso sêwhiŋ Yisu, naŋ sêsu iŋ susu bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Têŋ ac kalhac lhu, ŋasec atu gêm gameŋ sambuc ahuc e acgatu gitôm 3 kilok telha-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ma têŋ 3 kilok Yisu mbwêc awha atu, “Eloi, Eloi, lama sabaktani?” (Yom dau danem kwi bu, ‘Aö neŋ Anötö, aö neŋ Anötö, tu sake-ŋga am hu aö siŋ?’ ) ");
INSERT INTO buk_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Lau naŋ sêlhac sêmpiŋ, naŋ sêŋgô iŋ ŋapep dom ma sêsôm, “Aŋgô, iŋ ta propet Elaija.” ");
INSERT INTO buk_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ma ŋgac daŋ kêti gi kêŋ sôwam daŋ sip wain ŋamakic, ma sô dôŋ pi a baliŋ daŋ. Goc iŋ puc pi Yisu whasuŋ bu iŋ nôm ma sôm, “Dahu iŋ siŋ ma dalic, Elaija oc sip meŋ ma kôc iŋ su, me mba.” ");
INSERT INTO buk_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Têŋ têm dinaŋ Yisu mbwêc awha atu ma mbac ndu. ");
INSERT INTO buk_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ma têŋ dinaŋ po baliŋ naŋ kêgalêŋ lôm dabuŋ ŋalôm, naŋ dau kic gi lu, kalhac ŋahô ma gi têŋ ŋapu-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma ŋgac bata siŋ-ŋga naŋ kalhac Yisu aŋgô-ŋga, naŋ gêlic iŋ ndê mbac ndu ŋalêŋ, goc sôm, “Yomandô, ŋgac dindec iŋ Anötö ndê Atu.” ");
INSERT INTO buk_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Lauwhê ŋatô sêlhac ahê ma sêlic gêŋ hoŋ dinaŋ. Maria Magadala lu Maria naŋ Jems sauŋ lu Joses dinda, ma Salome sêmbo sêwhiŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Muŋ-ŋga, têŋ têm Yisu mbo gameŋ Galili-ŋga, naŋ lauwhê dinaŋ sêŋkuc iŋ, ma sem akiŋ iŋ. Ma lauwhê daêsam naŋ sêpi Jerusalem sêwhiŋ Yisu, naŋ sêlhac sêwhiŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Bêc naŋ sic Yisu ndu, naŋ lau Israel-ŋga si bêc sêmasaŋ dau tu Sabat-ŋga. Bocdinaŋ têŋ telha, ");
INSERT INTO buk_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ŋgac bata Israel-ŋga daŋ ŋaê Josep gauc gêm bu êŋsuhuŋ Yisu ŋamlaŋ. Josep iŋ ŋgac akêŋ malac Arimatiya-ŋga, ma iŋ lau Sanedrin-ŋga si ŋgac tiwaê daŋ naŋ kêŋ bata Anötö ndê gôliŋ bu meŋ sa tiawê. Iŋ ndê ŋalôm pêŋ dôŋ, dec têŋ Pailot gi ma ndac Yisu ndê ŋamlaŋ. ");
INSERT INTO buk_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yom dau kôm Pailot sö, ŋahu bu iŋ kêyalê dom bu Yisu mbac ndu su. Bocdinaŋ iŋ ta lau siŋ si ŋgac bata ma ndac iŋ bu Yisu mbac ndu su, me mba. ");
INSERT INTO buk_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Iŋ tap sa bu Yisu mbac ndu su, dec gôlôc têŋ Josep bu kôc Yisu ndê ŋamlaŋ sa ndi êŋsuhuŋ. ");
INSERT INTO buk_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josep kôc po ŋayham daŋ naŋ iŋ gêmlhi muŋ su, goc sa gi ma kôc Yisu su yêc a gicso dau, ma kêpaŋ iŋ ahuc ŋa po dau. Ma iŋ kôc iŋ sa gi ma kêŋ iŋ yêc sêhô naŋ lau sêlêŋ gwanaŋ su yêc hoc ŋalôm. Goc iŋ kêpi hoc daŋ gi ndöc sê awha dau ahuc. ");
INSERT INTO buk_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magadala lu Joses dinda Maria sêlic Josep kêŋ Yisu ndê ŋamlaŋ yêc hocsuŋ dinaŋ. ");
INSERT INTO buk_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Bêc Sabat-ŋga meŋ gi su, goc Maria Magadala lu Jems dinda Maria, ma Salome semlhi gêŋ malu bu sênem oso Yisu ndê ŋamlaŋ. ");
INSERT INTO buk_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Têŋ wake ŋabêc ŋamata-ŋga dinaŋ sêti têŋ bêbêc ganduc bu sêtêŋ sêhô sêndi. Ac pi meŋ su ma sêŋsêlêŋ sêmbo seŋ, ");
INSERT INTO buk_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ma sêndac dandi, “Asa oc nem yac sa ma êmpi hoc naŋ yêc sê awha, naŋ su?” ");
INSERT INTO buk_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tigeŋ sêhôc tandô sa, ma sêlic hoc atu dau yêc sê awha dom. ");
INSERT INTO buk_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bocdinaŋ dec sêsôc sêhô ŋalôm si. Sêlic ŋgac batac daŋ naŋ sôc ŋakwê sêsêp, ma ndöc andô-ŋga, dec sêsö ŋandô. ");
INSERT INTO buk_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Magoc ŋgac dau sôm, “Asö dom. Mac aŋsalê Yisu Nasaret-ŋga, naŋ sic iŋ ndu pi a gicso dau. Iŋ yêc dec dom, iŋ tisa su. Alic mala naŋ sêkêŋ iŋ yêc, naŋ sawa. ");
INSERT INTO buk_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Magoc andi ma asôm têŋ iŋ ndê sêŋomi ma têŋ Pita bu iŋ oc muŋ mac têŋ Galili ndi. Mac oc alic iŋ yêc dindê, tôm yom naŋ iŋ sôm têŋ mac muŋ su naŋ.” ");
INSERT INTO buk_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Yom dinaŋ kôm awhê lu dau sêntitec ti sêhêdaê ŋandô. Sêsa akêŋ sêhô, ma sêlhö sênti si. Magoc sêtöc dau dec sêsôm yom têŋ ŋamalac daŋ yêc seŋ dom. ");
INSERT INTO buk_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Têŋ têm Yisu tisa têŋ Sonda bêbêc, iŋ hoc dau asê ti-ŋamata-ŋga têŋ Maria Magadala, awhê naŋ muŋ-ŋga iŋ soc ŋalau sac 7 su yêc iŋ ŋalôm. ");
INSERT INTO buk_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ma Maria gi ma sôm asê têŋ lau naŋ sêŋkuc Yisu, naŋ sêkôm daŋgibo ti sêtaŋ sêmbo. ");
INSERT INTO buk_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Maria sôm têŋ ŋac bu iŋ gêlic Yisu ma iŋ mbo tali tiyham. Magoc ŋac sêkêŋ whiŋ dom. ");
INSERT INTO buk_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tiŋambu Yisu ndê ŋgac-sêŋom lu sêhu Jerusalem siŋ ma sêŋsêlêŋ sêmbo seŋ, ma Yisu hoc dau asê têŋ iŋlu gitôm ŋgac aŋgô batac daŋ. ");
INSERT INTO buk_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Dec iŋlu sêmbu si ma sic miŋ têŋ sêŋomi ŋatô, magoc ŋac sêkêŋ whiŋ iŋlu dom bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tiŋambu ŋgacsêŋomi 11 seŋ gêŋ sêmbo sêwhiŋ dau, ma Yisu hoc dau asê têŋ ŋac. Ma iŋ sôm ŋac tu ŋac si ŋalôm ŋadandi-ŋga, bu sêkêŋ whiŋ lau naŋ sêlic iŋ têŋ ndoc iŋ tisa su, naŋ dom. ");
INSERT INTO buk_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Goc iŋ sôm têŋ ŋac, “Atôm nom ŋagameŋ sambob andi, ma ahoc ŋawaê ŋayham asê têŋ lau hoŋ. ");
INSERT INTO buk_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Lau naŋ sêkêŋ whiŋ ma sêliŋ saŋgu, naŋ oc sêtap Anötö ndê mwasiŋ nem ŋac si-ŋga sa. Magoc lau naŋ sêkêŋ whiŋ dom, naŋ oc sêtap iŋ ndê matôc sa. ");
INSERT INTO buk_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ma Anötö oc kêŋ ŋaclai têŋ lau naŋ sêkêŋ whiŋ, dec oc tôm bu sêkôm gêŋ dalô bocdec bu. Ŋac oc sêkôm gweleŋ sênem aö aŋôŋ, ma sêsoc ŋalau sac su yêc lau. Ŋac oc sêsôm yom awha wakuc-ŋga naŋ sêndôhôŋ muŋ su dom. ");
INSERT INTO buk_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ŋac bu sêkôc mboc sac sip ŋac amba me sênôm bu ŋamalic, dec oc kôm ŋac sêtisac dom. Ma ŋac oc sêkêŋ amba sac lau gêmbac, ma sêkôm ŋac ŋayham sa.” ");
INSERT INTO buk_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yisu sôm yom dinaŋ têŋ ŋac su, goc Anötö kôc iŋ su yêc nom. Iŋ pi undambê gi, ma ndöc Anötö ndê amba andô-ŋga. ");
INSERT INTO buk_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ma iŋ ndê sêŋomi sêsa si, ma sêhoc ŋawaê ŋayham asê yêc gameŋ hoŋ. Ma Pômdau mbo whiŋ ŋac, ma kêŋ ŋaclai têŋ ŋac bu sêkôm gêŋ dalô atu-tu tu bu puc yom naŋ sêhoc asê, naŋ dôŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","O ŋgac atu Tiopilas. Lau daêsam sêŋsahê bu sêto yom pi gêŋ hoŋ naŋ ŋandô sa yêc yac mba gameŋ. ");
INSERT INTO buk_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ŋac sêto sêŋkuc yom naŋ lau naŋ sêmbo sêwhiŋ Yisu têŋ ndoc iŋ gic hu ndê gweleŋ, naŋ sic dulu têŋ yac. Lau dau sêlic gêŋ hoŋ naŋ Yisu kôm pi tandô, dec sêhoc ŋawaê ŋayham asê pi gêŋ dau. ");
INSERT INTO buk_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ma aö bocdinaŋ, gakip yom hoŋ sa pi gêŋ ŋamata-ŋga ma meŋ têŋ kwahic dec, ma galic ŋayham bu wato sip bapia dindec ma waŋkiŋ têŋ am. Aö gato yom kakuc ŋadênaŋ tôm gêŋ hoŋ naŋ hôc asê. Tu dinaŋ-ŋga O ŋgac atu Tiopilas, ");
INSERT INTO buk_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","am oc êmyalê bu yom hoŋ pi Yisu naŋ am ŋgô su, naŋ yom ŋandô. ");
INSERT INTO buk_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Têŋ têm Kiŋ †Herod gêm gôliŋ gameŋ Judia-ŋga, naŋ †dabuŋsiga daŋ mbo, iŋ ndê ŋaê Sekaria. Iŋ kôm ndê gweleŋ whiŋ dabuŋsiga naŋ sêmbo dabuŋsiga ŋamata-ŋga Abaisa ndê toŋ. Sekaria ndê awhê ndê ŋaê Elisabet, ma iŋ Aron ndê wakuc daŋ, gitôm Sekaria dau. ");
INSERT INTO buk_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Anötö gêlic iŋlu sêsa lêŋ gitêŋ yêc iŋ aŋgô-ŋga, sêŋsêlêŋ sêŋkuc Anötö ndê yomsu ti ŋagôliŋ ŋalêŋ ŋayham. ");
INSERT INTO buk_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Iŋlu sêti awhê andô ma ŋgac andô su, magoc balêkoc mba, bu Elisabet iŋ awhê gapoc. ");
INSERT INTO buk_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Têŋ têm daŋ Sekaria ndê toŋ si ndoc sênem akiŋ Anötö-ŋga hôc asê, ma iŋ gêm ndê gweleŋ dabuŋsiga-ŋga mbo Anötö ndê lôm dabuŋ yêc Jerusalem. ");
INSERT INTO buk_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ma gitôm dabuŋsiga si mêtê, sêpuc gapoc gi sip Sekaria, bu sôc lôm dabuŋ ŋalôm ndi, ma kêŋ da ŋamalu ŋayham. ");
INSERT INTO buk_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ma têŋ ndoc iŋ sôc gi bu kêŋ da ŋamalu ŋayham, naŋ lau Israel-ŋga hoŋ naŋ sêkac sa tu s êtoc Anötö sa-ŋga, naŋ sêteŋ mbec sêlhac awê. ");
INSERT INTO buk_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Têŋ ndoc dinaŋ Pômdau ndê aŋela daŋ hoc dau asê têŋ Sekaria, ma kalhac alta da ŋamalu-ŋga ŋa-ndö-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Têŋ ndoc Sekaria tandô pi aŋela dau, iŋ sö ti töc dau ŋandô. ");
INSERT INTO buk_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Magoc aŋela sôm têŋ iŋ, “Töc daôm dom Sekaria, bu Pômdau ŋgô mbec naŋ am teŋ. Am nem awhê Elisabet oc kôc atômŋgac daŋ, ma am oc sam iŋ ndê ŋaê bu Jon. ");
INSERT INTO buk_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Iŋ oc kôm am atac ŋayham atu, ma lau daêsam oc sêtisambuc tu dinda kôc iŋ-ŋga, ");
INSERT INTO buk_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","bu iŋ oc ti ŋgac tiwaê yêc Pômdau aŋgô-ŋga. Iŋ oc nôm wain me bu ŋaŋga dom, magoc têŋ têm iŋ yêc dinda atac ŋalôm eŋ, naŋ Ŋalau Dabuŋ oc nem iŋ ahuc, ma mbo whiŋ iŋ ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ma têŋ ndoc iŋ tiatu, naŋ iŋ oc nem lau Israel-ŋga daêsam kwi, sêmbu sêsôc Pômdau ŋac si Anötö ŋapu. ");
INSERT INTO buk_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Iŋ oc ti propet ŋaŋga ma ti ŋaclai gitôm propet ŋamata-ŋga Elaija. Ma iŋ oc muŋ Pômdau, bu nem lau daêsam si ŋalôm kwi. Dambai oc atac whiŋ atui, ma lau daŋgapêc oc sêti lau ti gauc naŋ sêsa si lêŋ gitêŋ. Ŋalêŋ dinaŋ iŋ oc êmasaŋ lau si ŋalôm bu sêkôc Pômdau sa.” ");
INSERT INTO buk_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekaria ŋgô aŋela ndê yom dinaŋ su, goc sôm têŋ iŋ, “Alu ati awhê andô ma ŋgac andô su. Boc-dinaŋ ŋalêŋ bocke dec aö waŋyalê bu am nem yom oc ŋandô sa?” ");
INSERT INTO buk_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Goc aŋela ô yom ma sôm, “Aö Gabriel naŋ galhac Pômdau aŋgô-ŋga, ma iŋ kêkiŋ aö bu wahoc ŋawaê ŋayham dindec asê têŋ am. ");
INSERT INTO buk_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Gêŋ naŋ aö gasôm yom pi, naŋ oc ŋandô sa tôm ŋandoc. Tigeŋ am kêŋ whiŋ aö dom, ma bocdinaŋ am oc awham mba sa, ma sôm yom dom e gêŋ hoŋ dindec hôc asê su.” ");
INSERT INTO buk_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Têŋ dinaŋ lau naŋ sêmbo awê, naŋ sêhôŋ Sekaria ma gauc gêm bu bocke ma iŋ mbo tiwandêc yêc lôm dabuŋ ŋalôm. ");
INSERT INTO buk_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ma têŋ ndoc Sekaria mbu sa awê gi, naŋ gitôm dom bu sôm yom, ma gic amba ŋambwa têŋ ŋac, dec ŋac si gauc sa bu iŋ gêlic gêŋ ŋagatu daŋ yêc lôm dabuŋ ŋalôm. ");
INSERT INTO buk_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tiŋambu iŋ ndê bêc gweleŋ-ŋga pacndê, ma iŋ kölhö mbu têŋ ndê malac gi. ");
INSERT INTO buk_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ma iŋ ndê awhê Elisabet daê, dec timêtê dau ŋapep, ma mbo teŋ mbo iŋlu si andu gitôm ayô amaŋdaŋ. Elisabet sôm, ");
INSERT INTO buk_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Pômdau kôm gêŋ dindec ma gêm aö sa. Ŋamata-ŋga aö gambo ti mayaŋ yêc lau aŋgô-ŋga, bu aö awhê gapoc, tigeŋ kwahic dec Pômdau tawalô aö, ma kôc aö mayaŋ su.” ");
INSERT INTO buk_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet daê gitôm ayô 6 su, goc Anötö kêkiŋ aŋela Gabriel têŋ malac Nasaret naŋ yêc gameŋ Galili-ŋga, ");
INSERT INTO buk_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","bu kêŋ aheŋ têŋ awhê akiŋ daŋ. Iŋ ndê ŋaê Maria, ma lau sêhoc yom asê su bu Maria oc nem ŋgac daŋ ŋaê Josep, naŋ Kiŋ Dawid ndê apaŋgac daŋ. ");
INSERT INTO buk_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aŋela dau têŋ Maria gi ma sôm, “O awhê naŋ Anötö tac whiŋ am ndu andô, Pômdau whiŋ am.” ");
INSERT INTO buk_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Yom dau kôm Maria sö ŋandô, ma iŋ gauc gêm têŋ dau bu, “Iŋ awha gic aö tu sake-ŋga?” ");
INSERT INTO buk_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Goc aŋela sôm têŋ iŋ, “Töc daôm dom Maria, bu Anötö gêlic am ŋayham kêlêc. ");
INSERT INTO buk_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Am oc daêm ma kôc balêkoc ŋgac daŋ, ma sam iŋ ndê ŋaê bu Yisu. ");
INSERT INTO buk_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Iŋ oc ti ŋgac tiwaê, ma lau oc sêsam iŋ bu Anötö Ŋaclai ti Ŋawasi Ŋadau ndê Atu. Pômdau Anötö oc kêŋ iŋ wêkaiŋ apaŋgac Dawid ndê pôŋ kiŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Iŋ oc nem gôliŋ †Jakob ndê wakuc lau Israel-ŋga, ma iŋ ndê gôliŋ oc pacndê dom.” ");
INSERT INTO buk_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Goc Maria ndac aŋela dau bu, “Aö gayêc gawhiŋ ŋgac daŋ dom, ma bocdinaŋ yom dau oc ŋandô sa ŋalêŋ bocke?” ");
INSERT INTO buk_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ma aŋela ô yom ma sôm, “Ŋalau Dabuŋ oc têŋ am meŋ, ma Anötö, Ŋaclai ti Ŋawasi Ŋadau ndê ŋaclai oc nem am ahuc. Tu dinaŋ-ŋga balêkoc dabuŋ naŋ am oc kôc, naŋ lau oc sêsam iŋ bu Anötö ndê Atu. ");
INSERT INTO buk_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ma am ŋgô! Elisabet, awhê andô naŋ yêc am apami si toŋ, naŋ daê ma oc kôc balêkoc daŋ. Sêsôm bu iŋ awhê gapoc, magoc kwahic iŋ daê tôm ayô 6 su. ");
INSERT INTO buk_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bu gêŋ daŋ yêc dom, naŋ Anötö gitôm dom bu kôm ŋandô sa.” ");
INSERT INTO buk_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ma Maria ô yom ma sôm, “Pômdau ndê awhê akiŋ aö. Bocdinaŋ, yom naŋ am sôm, naŋ ŋandô sa pi aö.” Maria sôm yom dinaŋ su, goc aŋela hu iŋ siŋ. ");
INSERT INTO buk_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Têŋ têm dinaŋ Maria kêmasaŋ dau, ma kêsêlêŋ ŋagahô têŋ malac daŋ yêc gameŋ ŋabaö Judia-ŋga gi. ");
INSERT INTO buk_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Iŋ hôc asê ma têŋ Sekaria ndê andu gi, ma ta Elisabet ndê ŋaê. ");
INSERT INTO buk_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Têŋ têm Elisabet ŋgô Maria ndê yom, naŋ balêkoc naŋ yêc iŋ ŋalôm kwê soc ti ŋaŋga, ma Ŋalau Dabuŋ gêm Elisabet ahuc. ");
INSERT INTO buk_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ma iŋ sôm yom awha atu, “Anötö toc am sa hôc gêlêc lauwhê sambob su, ma oc toc balêkoc naŋ am oc kôc, naŋ sa bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Aö awhê bocke, dec am, aneŋ Pômdau dinda mweŋ bu lic aö? ");
INSERT INTO buk_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Têŋ ndoc aö gaŋgô am mbwêc aö, naŋ balêkoc naŋ yêc aö ŋatac, naŋ kwê soc ti atac ŋayham. ");
INSERT INTO buk_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Am kêŋ whiŋ bu Pômdau ndê yom p i am oc ŋandô sa, ma tu dinaŋ-ŋga am tap iŋ ndê mwasiŋ sa!” ");
INSERT INTO buk_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Ma Maria sôm: “Aö wapo Pômdau ndê waê sa ti aneŋ ŋalôm sambuc, ma aö atac ŋayham kêlêc tu Anötö naŋ gêm aö si-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ŋahu bu iŋ kêlhiŋ iŋ ndê awhê akiŋ ŋambwa, aö dec siŋ dom. Têŋ kwahic dec ma ndi, lau hoŋ oc sêsam aö bu awhê naŋ Anötö kêmwasiŋ. ");
INSERT INTO buk_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Iŋ Ŋaŋga Ŋadau naŋ kôm gêŋ atu têŋ aö, ma iŋ ndê ŋaê dabuŋ. ");
INSERT INTO buk_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tôm têm sambob, iŋ tawalô lau hoŋ naŋ sêtöc iŋ ma sêtoc iŋ sa. ");
INSERT INTO buk_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Iŋ amba ŋaŋga kôm gêŋ atu, ma lau naŋ yom sêtoc dau sa-ŋga gêm ŋac si ŋalôm ahuc, naŋ iŋ soc ŋac su sêlhö têŋtêŋ. ");
INSERT INTO buk_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Iŋ kêmasuc kiŋ nom-ŋga su yêc ŋac si pôŋ kiŋ-ŋga, magoc lau naŋ sêŋgwiniŋ dau, naŋ iŋ toc ŋac sa. ");
INSERT INTO buk_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Iŋ kêmwasiŋ lau ŋalôm sawa ŋa gêŋ ŋayham-ŋayham, magoc iŋ kêkiŋ lau ti lêlôm sêsa amba sawa si. ");
INSERT INTO buk_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Iŋ gêm iŋ ndê lau akiŋ Israel-ŋga sa, ma tôm yom naŋ iŋ gic bata têŋ abaŋ Abraham, ma têŋ iŋ ndê wakuc hoŋ naŋ sêŋkuc iŋ, naŋ iŋ tawalô ŋac.” ");
INSERT INTO buk_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria kêpiŋ Anötö ma sôm yom dinaŋ su, goc mbo whiŋ Elisabet gitôm ayô tö, ma tiŋambu iŋ kölhö mbu têŋ ndê malac gi. ");
INSERT INTO buk_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet ndê ndoc meŋ sa dec iŋ kôc balêkoc ŋgac daŋ. ");
INSERT INTO buk_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ma iŋ ndê dawai ti lau meŋpaŋ iŋ-ŋga sêŋgô bu Pômdau tawalô iŋ ŋalêŋ dinaŋ, ma ŋac hoŋ atac ŋayham sêwhiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Têŋ balêkoc dau ndê bêc ti-8-ŋga, ŋac hoŋ sêmeŋ bu sêsê balê ndê ŋamlic ŋatô su sêŋkuc lau Israel-ŋga si †pwac, ma ŋac tac whiŋ bu sêkêŋ damba Sekaria ndê ŋaê pi iŋ. ");
INSERT INTO buk_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tigeŋ iŋ dinda sôm, “Mba! Dasam iŋ ndê ŋaê bu Jon.” ");
INSERT INTO buk_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ma sêsôm têŋ iŋ, “Yêc am nem dawam, ŋgac ŋaê Jon daŋ mbo dom.” ");
INSERT INTO buk_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ma ŋac sic amba têŋ damba bu sêŋyalê ŋaê bocke iŋ tac whiŋ. ");
INSERT INTO buk_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Iŋ kôm ŋa amba bu sêkêŋ tapele daŋ têŋ iŋ, dec sêkêŋ ma iŋ to, “Iŋ ndê ŋaê Jon,” goc lau hoŋ sêhêdaê. ");
INSERT INTO buk_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ma ŋagahô iŋ êmbala tigoloŋ, ma iŋ sôm yom asê ma kêpiŋ Anötö. ");
INSERT INTO buk_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Gêŋ dau kôm ŋac lau hoŋ sêsö, ma lau naŋ sêmbo Judia ŋagameŋ lôc-ŋga, naŋ sem yom-galôm ŋapaŋ pi gêŋ hoŋ dinaŋ. ");
INSERT INTO buk_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Lau hoŋ sêŋgô ŋawaê, ma ŋac gauc gêm yom dau ŋapaŋ yêc ŋac si ŋalôm. Ma ŋac sêlic bu Pômdau ndê ŋaclai tôc dau asê yêc balê dau, dec sêndac dandi, “Iŋ oc ti ŋamalac kaiŋ bocke?” ");
INSERT INTO buk_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Têŋ têm dinaŋ Ŋalau Dabuŋ gêm Jon ndê damba Sekaria ahuc, ma iŋ hoc yom asê gitôm propet daŋ ma sôm, ");
INSERT INTO buk_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Tampiŋ Pômdau, yac lau Israel-ŋga neŋ Anötö, bu iŋ meŋ bu nem iŋ ndê lau si. ");
INSERT INTO buk_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Iŋ po ŋgac ti ŋaclai daŋ sa yêc iŋ ndê ŋgac akiŋ Dawid ndê lau wakuc, naŋ gitôm bu nem yac si. ");
INSERT INTO buk_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Anötö ndê propet dabuŋ sêhoc yom asê pi gêŋ dau muŋ su, ma kwahic dec Anötö kôm yom dau ŋandô sa. ");
INSERT INTO buk_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Iŋ kêmasaŋ lêŋ dinaŋ, bu nem yac si yêc yac neŋ ŋacyo ti lau naŋ sêtec yac amba. ");
INSERT INTO buk_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Iŋ tawalô yac, tôm iŋ gic bata têŋ abaŋi, ma gauc gêm iŋ ndê pwac dabuŋ, ");
INSERT INTO buk_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","naŋ iŋ kêmatiŋ tidôŋ whiŋ abaŋ Abraham. ");
INSERT INTO buk_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Iŋ oc nem yac si yêc yac neŋ ŋacyo amba, tu bu yac danem akiŋ iŋ ti atac pa su, ");
INSERT INTO buk_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ma tu bu taŋsêlêŋ dasa lêŋ gitêŋ ti dabuŋ yêc iŋ aŋgô-ŋga tôm bêc hoŋ. ");
INSERT INTO buk_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ma Jon, aneŋ balê, lau oc sêsam am bu ‘Anötö, Ŋaclai ti Ŋawasi Ŋadau ndê propet,’ bu am oc muŋ Pômdau ma êmasaŋ lau si ŋalôm tu sêkôc iŋ sa-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ma am oc whê Anötö ndê lau si gauc sa pi lêŋ naŋ iŋ oc suc ŋac si sac kwi tu bu nem ŋac si-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Yac neŋ Anötö ndê lêŋ tawalô yac-ŋga, naŋ oc tôm ac naŋ pi ma kalhac umboŋ, ");
INSERT INTO buk_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ma pô lau naŋ sêndöc gameŋ ŋasec, ma lau naŋ sêmpiŋ bu sêmbac ndu. Iŋ oc wê yac dasa seŋ bu datap yom malô sa.” ");
INSERT INTO buk_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tiŋambu balê dau tiatu, ma kêŋ ndê ŋalôm sambuc tu nem akiŋ Anötö-ŋga. Ma iŋ mbo gameŋ sawa e tôm bêc naŋ iŋ gic hu ndê gweleŋ, dec gêm mêtê kalhac lau Israel aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Têŋ têm dinaŋ †Sisa Ogasta gic atu yom bu sêsê lau hoŋ naŋ sêmbo Rom si gôliŋ ŋapu, naŋ sa tu bu sênemlhi takis-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Têŋ ndoc dinaŋ Kirinios gêm gôliŋ gameŋ Siria-ŋga, ma gêŋ dinaŋ ti têm ŋamata-ŋga naŋ sêsê lau sa yêc iŋ ndê gôliŋ ŋapu.) ");
INSERT INTO buk_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Bocdinaŋ lau hoŋ sêtêŋ si malachu si, bu sêto si ŋaê sip bapia sêsê ŋac sa-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep iŋ Dawid ndê wakuc daŋ, ma bocdinaŋ iŋ hu malac Nasaret yêc gameŋ Galili-ŋga siŋ, ma sip têŋ Dawid ndê malac yêc gameŋ Judia-ŋga gi, malac naŋ sêsam bu Betlehem. ");
INSERT INTO buk_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josep lu Maria sêwhiŋ dau si bu sêkêŋ si ŋaê, bu sêhoc iŋlu si yom asê su bu oc sênem dau. Ma Maria daê mbo. ");
INSERT INTO buk_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Têŋ ndoc iŋlu sêmbo Betlehem, naŋ Maria ndê bêc bu kôc balêkoc-ŋga hôc asê. ");
INSERT INTO buk_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Josep lu Maria sêyêc bôc si mala, bu ŋasawa mbasi yêc andu ŋacleŋ-ŋga. Ma yêc dê, Maria kôc iŋ ndê balêkoc ŋgac ŋamata-ŋga. Ma iŋ kôm iŋ si ŋa po, ma kêŋ iŋ yêc bôc si apa sêneŋ gêŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Têŋ ôbwêc dinaŋ lau ŋatô sêyob si domba sêmbo malac dau ŋamakê. ");
INSERT INTO buk_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ma Anötö ndê aŋela daŋ hoc dau asê têŋ ŋac. Pômdau ndê ŋawê pô ŋac, ma sêtöc dau ŋandô. ");
INSERT INTO buk_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Goc aŋela dau sôm têŋ ŋac bu, “Atöc daôm dom! Aö bu wakêŋ ŋawaê ŋayham daŋ têŋ mac, naŋ oc kôm mac atac ŋayham atu. Ma ŋawaê dindec gic waê lau hoŋ. ");
INSERT INTO buk_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mac nem ŋgac nem mac si-ŋga hôc asê têŋ bêc dau dindec. Iŋ dinda kôc iŋ yêc Betlehem, malac naŋ sêsam bu Dawid ndê malac. Iŋ †Mesaya dau naŋ Anötö gic bata bu êŋkiŋ meŋ, ma mac nem Pômdau dau. ");
INSERT INTO buk_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Atêŋ Betlehem andi, ma mac oc aŋyalê balêkoc dau pi gêŋ bocdec bu. Sêkôm iŋ si ŋa po, ma sêkêŋ iŋ yêc bôc si apa sêneŋ gêŋ-ŋga.” ");
INSERT INTO buk_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ma ŋagahô aŋela undambê-ŋga daêsam sêhoc dau asê sêwhiŋ aŋela dinaŋ, ma sem wê sêmpiŋ Anötö bocdec bu, ");
INSERT INTO buk_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Anötö ndê waê sa yêc lôlôc. Ma yom malô yêc nom, têŋ lau naŋ Anötö gêlic ŋac ŋayham.” ");
INSERT INTO buk_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aŋela sem wê dinaŋ su, goc sêmbu sêpi undambê si. Ma lau sêyob domba-ŋga sêsôm têŋ dandi, “Ayôc! Datêŋ Betlehem dandi, ma dalic gêŋ atu naŋ Pômdau ndê aŋela sêhoc asê têŋ yac.” ");
INSERT INTO buk_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Goc sêŋsahic dau sêtêŋ Betlehem si, ma sêtap Maria lu Josep sa, ma sêlic balêkoc dau yêc bôc si apa sêneŋ gêŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Sêlic iŋ su goc sêsa si, ma sic miŋ yom naŋ aŋela hoc asê têŋ ŋac pi balêkoc dau. ");
INSERT INTO buk_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ma lau hoŋ naŋ sêŋgô ŋac si yom, naŋ sêhêdaê ŋandô. ");
INSERT INTO buk_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Magoc Maria gauc gêm yom hoŋ ŋapaŋ yêc ndê ŋalôm. ");
INSERT INTO buk_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ma lau sêyob domba-ŋga sêlhö sêmbu sêtêŋ gameŋ sêyob domba-ŋga si. Sêmpiŋ Anötö ma sêtoc iŋ ndê waê sa tu gêŋ hoŋ naŋ sêŋgô ti sêlic, naŋ gitôm aŋela sôm asê têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Têŋ bêc 8 giŋga su, sêsê balê ndê ŋamlic ŋatô su, kêkuc lau Israel-ŋga si pwac. Ma sêsam iŋ ndê ŋ aê Yisu, tôm aŋela sam iŋ têŋ ndoc iŋ kêŋ puc Maria bu iŋ oc daê. ");
INSERT INTO buk_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Muŋ-ŋga, Moses to yomsu daŋ pi lauwhê Israel-ŋga naŋ sêkôc balêkoc, naŋ yêc bocdec bu. Sêhôŋ e bêc 40 pacndê, goc ŋac oc ŋawasi sa tiyham yêc Anötö aŋgô-ŋga. Bocdinaŋ têŋ Maria ndê bêc 40 pacndê su, goc iŋlu Josep sêkôc Yisu sêtêŋ lôm dabuŋ yêc malac Jerusalem si, bu sêtôc iŋ yêc Pômdau aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Sêkôm bocdinaŋ kêkuc Pômdau ndê yomsu naŋ Moses to bocdec bu, “Asam balêkoc ŋgac mbêc hoŋ bu dabuŋ yêc Pômdau aŋgô-ŋga.” ");
INSERT INTO buk_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ma têŋ têm dinaŋ iŋlu sêkêŋ da bu Maria ŋawasi sa tiyham. Sêkêŋ da tôm Pômdau ndê yomsu, balusi lu me mbac sauŋ lu. ");
INSERT INTO buk_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Têŋ têm dinaŋ ŋgac daŋ ŋaê Simeon mbo Jerusalem. Iŋ ŋgac gitêŋ ti dabuŋ, ma iŋ hôŋ ndoc bu Anötö êŋkiŋ iŋ ndê Mesaya bu nem lau Israel-ŋga si. Ŋalau Dabuŋ whiŋ iŋ tôm bêc hoŋ, ");
INSERT INTO buk_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ma têŋ ndoc daŋ, kêŋ gauc têŋ iŋ bu iŋ oc mbo tali e lic Mesaya naŋ Pômdau gic bata. ");
INSERT INTO buk_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ma Ŋalau Dabuŋ wê Simeon têŋ lôm dabuŋ gi, têŋ bêc naŋ Yisu dinda lu damba sêkôc iŋ sêmeŋ bu sêkêŋ da sêŋkuc Moses ndê yomsu. ");
INSERT INTO buk_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Iŋ pê Yisu sa, goc kêpiŋ Anötö ma sôm, ");
INSERT INTO buk_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“O Pômdau atu, yom naŋ am gic bata su, naŋ kwahic dec ŋandô sa. Aö tanôŋ galic am nem †Ŋgac Nem Lau Si-ŋga su, ma bocdinaŋ dec oc tôm bu am nem ŋgac akiŋ aö dec wambac ndu ti atac malô. ");
INSERT INTO buk_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Am kêmasaŋ lêŋ dindec yêc lau hoŋ aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Am nem ŋawê oc pô lau hoŋ, bu tôc am asê têŋ lau gameŋ apa-ŋga, ma bu po am nem lau Israel-ŋga si waê sa.” ");
INSERT INTO buk_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeon sôm yom dinaŋ pi Yisu, dec kôm Yisu dinda lu damba sêhêdaê. ");
INSERT INTO buk_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Goc Simeon gêm mbec ŋac, ma sôm têŋ Yisu dinda Maria, “Anötö kêyaliŋ balê dindec sa, ma tu iŋ-ŋga lau Israel-ŋga daêsam oc sêpeŋ, magoc daêsam naŋ sêkêŋ whiŋ iŋ, naŋ oc sêtap Anötö ndê mwasiŋ sa. Iŋ meŋ bu tôc Anötö ndê lêŋ asê têŋ lau, magoc daêsam oc sêpu iŋ ti ndê yom, ");
INSERT INTO buk_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ma ŋalêŋ dinaŋ gauc naŋ yêc lau daêsam si ŋalôm, naŋ oc meŋ sa tiawê. Ma tu gêŋ naŋ oc hôc asê iŋ-ŋga, am daôm oc hôc ŋandê atu tôm bieŋ kuŋ am ŋatê.” ");
INSERT INTO buk_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Propet awhê daŋ mbo lôm dabuŋ ŋabatêmndö. Iŋ ndê ŋaê Ana, ma iŋ damba iŋ Panuel, naŋ yêc Aser ndê toŋ. Ana iŋ ti awhê andô su. Muŋ-ŋga iŋ gêm ŋgac su ma iŋlu nakweŋ sêmbo sêwhiŋ dau gitôm yala 7, ");
INSERT INTO buk_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","goc nakweŋ mbac ndu ma Ana ti awhê sawa ma mbo e iŋ ndê yala ti 84. Tôm acsalô ti ôbwêc hoŋ iŋ gêm akiŋ Anötö mbo lôm dabuŋ ŋabatêmndö, ma têm daêsam iŋ hu gêŋ daneŋ-ŋga siŋ tu nem dabuŋ dau ti teŋ mbec ŋaŋga-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Têŋ têm naŋ Simeon ndê yom pi Yisu pacndê, naŋ Ana têŋ ŋac gi, ma gêm daŋge Anötö. Ma iŋ gic hu sôm yom pi balêkoc têŋ lau hoŋ naŋ sêhôŋ ndoc naŋ Anötö oc nem lau Jerusalem ti Israel-ŋga si. ");
INSERT INTO buk_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josep lu Maria sêkôm gêŋ hoŋ tôm Pômdau ndê yomsu sôm, goc sêmbu sêtêŋ ŋac si malac Nasaret yêc gameŋ Galili-ŋga si. ");
INSERT INTO buk_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ma Yisu tiatu ma ti balê ti licwalô. Ma gauc ŋayham ma Anötö ndê mwasiŋ gêm iŋ ahuc. ");
INSERT INTO buk_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tôm yala hoŋ Maria lu Josep sêpi Jerusalem si, bu sêlic om atu †Pasowa-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Têŋ Yisu ndê yala ti 12, naŋ ŋac hoŋ sêpi si, tôm iŋlu si gêbôm. ");
INSERT INTO buk_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ma têŋ ndoc Mwasiŋ Pasowa-ŋga pacndê, goc Maria lu Josep sêhu Jerusalem siŋ bu sêmbu sêtêŋ iŋlu si malac sêndi. Yisu gacgeŋ mbo Jerusalem, magoc iŋlu sêŋyalê dom, ");
INSERT INTO buk_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","bu sêŋsêlêŋ sêmbo seŋ sêwhiŋ lau toŋ atu, dec sem gauc bu iŋ oc mbo lau toŋ atu dinaŋ ŋalôm. Sêhu Jerusalem siŋ sêsa si gitôm bêc daŋ, goc sêŋsalê iŋ yêc ŋac si lau. ");
INSERT INTO buk_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Sêtap iŋ sa dom, dec bêc tilu-ŋga iŋlu sêmbu sêtêŋ Je rusalem si, bu sêŋsalê iŋ. ");
INSERT INTO buk_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Sêhôc asê Jerusalem, ma ŋagalaŋsê sêtap iŋ sa yêc lôm dabuŋ. Iŋ ndöc whiŋ lau naŋ sêndôhôŋ mêtê, ma iŋ kêŋ daŋga ŋac si yom. Ma iŋ ndac ŋac pi gêŋ daêsam. ");
INSERT INTO buk_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Lau hoŋ naŋ sêŋgô iŋ, naŋ sêhêdaê tu iŋ ndê gauc-ŋga, ma tu yom hoŋ naŋ iŋ ô têŋ kêdôhôŋwaga-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Têŋ ndoc Maria lu Josep sêlic iŋ, naŋ sêhêdaê. Ma Maria ndac iŋ, “Aneŋ balê, tu sake-ŋga am kôm gêŋ dindec têŋ alu damam? Alu aŋsalê am ti ŋalôm ŋawapac.” ");
INSERT INTO buk_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ma Yisu ndac iŋlu, “Tu sake-ŋga amlu aŋsalê aö? Damaŋ ndê andu dindec, ma aö gac waê bu wambo dec.” ");
INSERT INTO buk_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tigeŋ ŋac sêŋyalê iŋ ndê yom ŋahu dom. ");
INSERT INTO buk_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Goc Yisu whiŋ iŋlu, ma sêmbu sêtêŋ malac Nasaret si, ma iŋ daŋga wambu têŋ iŋlu ŋapep. Ma iŋ dinda gauc gêm yom hoŋ dinaŋ ŋapaŋ yêc ndê ŋalôm. ");
INSERT INTO buk_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ma Yisu tiatu ma ti ŋgac tigauc, ma Anötö ma ŋamalac hoŋ sêlic iŋ ŋayham. ");
INSERT INTO buk_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiŋambu Taibirias ti lau Rom-ŋga si kiŋ atu, ma têŋ iŋ ndê yala ti-15-ŋga, naŋ iŋ ndê la u bata bocdec sem gôliŋ lau Rom-ŋga si gameŋ ŋatô. Pontias Pailot gêm gôliŋ gameŋ Judia-ŋga, †Herod Antipas gêm gôliŋ Galili, Herod ndê dôwa Pilip gêm gôliŋ Ituria ma Trakonitas, ma Lisanias gêm gôliŋ Abelin. ");
INSERT INTO buk_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ma Anas lu Kayapas sêti l au Israel-ŋga si †dabuŋsiga ŋamata-ŋga. Têŋ ndoc dinaŋ Anötö kêkiŋ iŋ ndê yom têŋ Jon, Sekaria ndê atuŋgac naŋ mbo gameŋ sawa. ");
INSERT INTO buk_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Bocdinaŋ Jon gic hu iŋ ndê gweleŋ. Iŋ golom-golom malac hoŋ naŋ yêc Bu Jordan ŋamakê, ma gêm mêtê bu lau sêliŋ saŋgu tu bu sêtôc asê bu sêkac si ŋalôm kwi ma sêhu mêtê sac siŋ, dec Anötö oc suc ŋac si sac kwi. ");
INSERT INTO buk_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Propet Aisaya hoc yom asê pi Jon muŋ su, tôm iŋ to yêc ndê buku bocdec bu: Ŋamalac daŋ ta yom yêc gameŋ sawa bocdec bu, ‘Amasaŋ Pômdau ndê seŋ. Amasaŋ nem ŋalôm bu akôc iŋ sa. ");
INSERT INTO buk_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Busuŋ hoŋ oc sêti gameŋ apa-pa, ma lôc ti ŋabaö hoŋ oc sêti gameŋ gapoŋ. Seŋ mbwê hoŋ oc sêtisolop, ma seŋ hoc-hoc oc sêti seŋ ŋayham. ");
INSERT INTO buk_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ma lau nom-ŋga hoŋ oc sêlic Anötö ndê lêŋ nem lau si-ŋga.’ ");
INSERT INTO buk_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ma tu dinaŋ-ŋga Jon sôm têŋ lau daêsam naŋ sêsa si bu iŋ êŋku ŋac, “Mac mboc ŋatui mac! Tu sake-ŋga mac alhö ameŋ? Mac akôc gauc pi Anötö ndê atac ŋandê naŋ lau propet sêkêŋ puc yac bu oc meŋ sa, dec gauc gêm bu ameŋ ma aliŋ busaŋgu ŋambwa, a? ");
INSERT INTO buk_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Aŋgô! Akôm mêtê ŋayham naŋ tôc asê bu mac am daôm kwi yomandô. Asôm têŋ daôm dom, bu ‘Abraham apai yac, ma tu dinaŋ-ŋga Anötö oc kôc yac sa.’ Aö wasôm têŋ mac bu Anötö gitôm bu nem hoc hoŋ dindec kwi sêti Abraham atui sêô mac. ");
INSERT INTO buk_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","A hoŋ naŋ sem ŋandô ŋayham dom, naŋ kwahic dec Anötö kêŋ ki ŋamata têŋ ŋawakac, ma iŋ oc lêŋ su ma tuc pi ya ndi.” ");
INSERT INTO buk_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Lau toŋ atu dinaŋ sêŋgô Jon ndê yom ma sêndac iŋ, “Bocdinaŋ yac oc akôm sake?” ");
INSERT INTO buk_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ma iŋ ô yom ma sôm, “Tamwalô lau ŋatô. Mac nem asa ndê ŋakwê ŋandô-ŋga lu bu sêyêc, naŋ kêŋ daŋ têŋ lau naŋ si ŋakwê mbasi. Ma asa ndê gêŋ daneŋ-ŋga yêc, naŋ nem lau naŋ sêpônda dau, naŋ sa bocdinaŋ.” ");
INSERT INTO buk_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Lau sêkôc takis-ŋga ŋatô sêsa si bu Jon êŋku ŋac, ma sêndac, “Kêdôhôŋwaga, yac oc akôm sake?” ");
INSERT INTO buk_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Goc Jon sôm têŋ ŋac, “Akôc takis ŋapep, ma ahôc gêlêc dôhôŋ naŋ lau Rom-ŋga sêkêŋ, naŋ dom!” ");
INSERT INTO buk_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ma lau siŋ-ŋga ŋatô sêndac iŋ, “Ma yac, oc akôm sake?” Ma iŋ sôm, “Aŋgôliŋ yom tasaŋ pi lau, me akôm gêŋ ti ŋaclai bu aŋgaho ŋac si mone me gêŋ dom. Akôc ŋaôli gweleŋ-ŋga naŋ lau Rom-ŋga sêkêŋ têŋ mac, ma tamgatu awa ŋatô dom.” ");
INSERT INTO buk_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Têŋ têm dinaŋ lau Israel-ŋga sêkêŋ bata bu Anötö oc êŋkiŋ iŋ ndê Mesaya, ma lau hoŋ naŋ sêŋgô Jon, naŋ sêhê gauc bu mboe iŋ Mesaya dau. ");
INSERT INTO buk_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Magoc Jon sôm têŋ lau hoŋ, “Ŋgac daŋ oc meŋ hôc asê. Iŋ ndê ŋaclai hôc gêlêc aö neŋ su. Aö ŋgac ŋambwa, gitôm dom bu wati iŋ ndê ŋgac akiŋ naŋ kêgapwêc iŋ ndê atapa ŋawalô. Aö dec kaku mac ŋa bu ŋambwa, tigeŋ iŋ oc êŋku mac ŋa Ŋalau Dabuŋ ti ya. ");
INSERT INTO buk_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Iŋ meŋ bu êŋsahê lau, gitôm ŋgac naŋ whê wit ŋandô ti ŋapa kôc, dec oc ndic ŋandô sa sôc andu gêŋ ŋandô-ŋga, ma tuc ŋapa sip ya naŋ sa ŋapaŋ ndi.” ");
INSERT INTO buk_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ŋalêŋ dinaŋ Jon hoc ŋawaê ŋayham asê têŋ lau, ma gêm la ŋac ŋa yom ŋaŋga daêsam. ");
INSERT INTO buk_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tiŋambu Jon puc Kiŋ Herod ndê giso asê, bu Herod gêm iŋ asi ndê awhê Herodias, ma kôm mêtê sac daêsam whiŋ. ");
INSERT INTO buk_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Dec Herod gêm dau si, ma kôm giso daŋ tiyham bocdec bu, iŋ kêŋ Jon ndöc gapocwalô. ");
INSERT INTO buk_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Têŋ têm naŋ Herod kêŋ Jon ndöc gapocwalô su dom, naŋ Yisu sa têŋ Jon gi, ma Jon kêku iŋ whiŋ. Tiŋambu Yisu kalhac ma teŋ mbec mbo, ma undambê kac sa, ");
INSERT INTO buk_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ma Ŋalau Dabuŋ gêm balusi aŋgô, ma sip meŋ sac Yisu ŋahô. Ma awha daŋ sa akêŋ undambê, naŋ sôm, “Aö neŋ Atuŋgac atac whiŋ-ŋga am. Aö gatisambuc am ŋandô.” ");
INSERT INTO buk_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yisu gic hu ndê gweleŋ têŋ iŋ ndê yala gitôm 30. Ma iŋ ndê apai bocdindec. Lau sêsam Yisu bu Josep atu. Ma Josep iŋ Eli atu, ");
INSERT INTO buk_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","naŋ Matat atu, naŋ Liwai atu, naŋ Melki atu, naŋ Yanai atu, naŋ Josep atu, ");
INSERT INTO buk_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","naŋ Matatias atu, naŋ Amos atu, naŋ Nahum atu, naŋ Esli atu, naŋ Nagai atu, ");
INSERT INTO buk_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","naŋ Mat atu, naŋ Matatias atu, naŋ Semin atu, naŋ Yosek atu, naŋ Yoda atu, ");
INSERT INTO buk_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","naŋ Yoanan atu, naŋ Resa atu, naŋ Serubabel atu, naŋ Siltiel atu, naŋ Neri atu, ");
INSERT INTO buk_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","naŋ Melki atu, naŋ Adi atu, naŋ Kosam atu, naŋ Elmadam atu, naŋ Er atu, ");
INSERT INTO buk_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","naŋ Josua atu, naŋ Eliesa atu, naŋ Yorim atu, naŋ Matat atu, naŋ Liwai atu, ");
INSERT INTO buk_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","naŋ Simeon atu, naŋ Juda atu, naŋ Josep atu, naŋ Yonam atu, naŋ Eliakim atu, naŋ Melea atu, ");
INSERT INTO buk_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","naŋ Mena atu, naŋ Matata atu, naŋ Natan atu, naŋ Dawid atu, ");
INSERT INTO buk_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","naŋ Jessi atu, naŋ Obed atu, naŋ Boas atu, naŋ Salmon atu, naŋ Nason atu, ");
INSERT INTO buk_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","naŋ Aminadab atu, naŋ Ram atu, naŋ Hesron atu, naŋ Peres atu, naŋ Juda atu, ");
INSERT INTO buk_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","naŋ Jakob atu, naŋ Aisak atu, naŋ Abraham atu, naŋ Tera atu, naŋ Naho atu, ");
INSERT INTO buk_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","naŋ Serug atu, naŋ Reu atu, naŋ Peleg atu, naŋ Eber atu, naŋ Sela atu, ");
INSERT INTO buk_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","naŋ Kenan atu, naŋ Apakad atu, naŋ Sem atu, naŋ Noa atu, naŋ Lamek atu, ");
INSERT INTO buk_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","naŋ Metusela atu, naŋ Inok atu, naŋ Yared atu, naŋ Mahalalel atu, naŋ Kenan atu, ");
INSERT INTO buk_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","naŋ Inos atu, naŋ Set atu, naŋ Adam atu, naŋ Anötö atu. ");
INSERT INTO buk_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ŋalau Dabuŋ gêm Yisu ahuc ma iŋ hu Bu Jordan siŋ. Ma Ŋalau wê iŋ bambaliŋ mbo gameŋ sawa ");
INSERT INTO buk_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","gitôm bêc 40. Yêc dindê Sadaŋ kêsahê bu êntôm iŋ. Tôm bêc hoŋ dinaŋ Yisu gêŋ gêŋ daŋ dom, ma tiŋambu gêŋ yô iŋ ŋandô. ");
INSERT INTO buk_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ma Sadaŋ sôm têŋ iŋ, “Am Anötö ndê Atu, a? Bocdinaŋ sôm têŋ hoc dindec bu nem dau kwi ti bolom.” ");
INSERT INTO buk_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Magoc Yisu ô yom ma sôm, “Mba! Sêto Anötö ndê yom yêc bocdec bu, ‘Gêŋ daneŋ-ŋga ŋambwa kêŋ lau sêndöc tali dom.’ ” ");
INSERT INTO buk_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Goc Sadaŋ kôc iŋ sa pi lôc baliŋ daŋ gi, ma ŋagahô iŋ tôc têŋ iŋ gameŋ hoŋ naŋ kiŋ nom-ŋga sem gôliŋ. ");
INSERT INTO buk_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Ma iŋ sôm, “Gêŋ hoŋ dindec yêc aneŋ gôliŋ ŋapu. Ma gitôm bu wakêŋ têŋ asa naŋ aö atac whiŋ naŋ. Am bu pôŋ hamduc têŋ aö, dec wakêŋ ŋaclai ti ŋawasi hoŋ dindec têŋ am.” ");
INSERT INTO buk_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ma Yisu ô iŋ ndê yom ma sôm, “Mba! Sêto yom yêc bocdec bu, ‘Pôŋ hamduc têŋ Pômdau am nem Anötö, ma nem akiŋ iŋ tigeŋ.’” ");
INSERT INTO buk_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Goc Sadaŋ wê iŋ pi malac Jerusalem gi, ma kêŋ iŋ kalhac lôm dabuŋ ŋapoc lôlôc, ma sôm têŋ iŋ, “Am Anötö ndê Atu, a? Dec pwê sip akêŋ dec ndi. ");
INSERT INTO buk_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Am oc tisac dom, bu sêto yom yêc bocdec bu, ‘Pômdau oc êŋkiŋ ndê aŋela bu sêyob am. ");
INSERT INTO buk_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ŋac oc sêpê am sa lôlôc bu am tiŋ gahim pi hoc daŋ dom.’” ");
INSERT INTO buk_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Magoc Yisu ô yom bocdec bu, “Sêto yom yêc bu, ‘Êmsahê Pômdau am nem Anötö dom.’” ");
INSERT INTO buk_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ŋalêŋ dinaŋ Sadaŋ kêsahê lêŋ daêsam tu êntôm Yisu-ŋga. Ma tiŋambu iŋ hu iŋ siŋ ma kölhö gi, bu hôŋ têm daŋ tiyham. ");
INSERT INTO buk_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ŋalau Dabuŋ ndê ŋaclai gêm Yisu ahuc, ma iŋ mbu têŋ gameŋ Galili-ŋga gi. Ma ŋawaê pi iŋ sa têŋ gameŋ ŋamakê-ŋga hoŋ gi. ");
INSERT INTO buk_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Iŋ kêdôhôŋ lau yêc ŋac si lôm wê-ŋga, ma lau hoŋ sêmpiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tiŋambu Yisu hôc asê iŋ ndê malachu Nasaret. Yêc dinaŋ iŋ kêkuc ndê gêbôm, ma têŋ bêc †Sabat-ŋga iŋ sôc lôm wê-ŋga gi. Iŋ tisa kalhac bu sam Anötö ndê mêtê, ");
INSERT INTO buk_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ma sêkêŋ propet Aisaya ndê bapia tilhuŋ têŋ iŋ. Yisu kac bapia dau sa, ma kêsalê yom naŋ sêto yêc bocdec bu: ");
INSERT INTO buk_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Pômdau kêŋ ndê Ŋalau gêm aö ahuc, dec kêyaliŋ aö sa bu wasôm ŋawaê ŋayham asê têŋ lau ŋalôm sawa. Iŋ kêkiŋ aö bu wasôm asê têŋ lau bu Anötö kêmasaŋ lêŋ bu êŋgapwêc ŋac su yêc gapocwalô, ma bu kôm lau tapec si tandô po asê, bu wanem lau naŋ si ŋacyo sêŋgwiniŋ ŋac, naŋ sa, ");
INSERT INTO buk_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ma bu wanem mêtê bu kwahic dec Pômdau kêyaliŋ têm wakuc sa bu êmwasiŋ lau. ");
INSERT INTO buk_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yisu sam yom dau su, goc kêlhuŋ bapia dau sa tiyham, kêŋ mbu têŋ dabuŋwaga, ma ndöc sic. Lau hoŋ naŋ sêndöc lôm, naŋ tahê iŋ, ");
INSERT INTO buk_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","dec iŋ gic hu ndê yom ma sôm, “Yom naŋ mac aŋgô, naŋ ŋandô sa têŋ acsalô dindec.” ");
INSERT INTO buk_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Lau hoŋ sem yomgalôm pi iŋ ti sêlic iŋ ŋayham, ma sêhêdaê tu iŋ ndê yom ŋayham-ŋga. Ma sêsôm têŋ dandi, “Iŋ Josep ndê atuŋgac. Bocke ma iŋ sôm yom kaiŋ dinaŋ?” ");
INSERT INTO buk_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ma Yisu sôm têŋ ŋac, “Aö kayalê mac nem gauc. Mboe mac oc asôm yom gôliŋ dindec têŋ aö, ‘Dokta, nem daôm sa.’ Gêŋ naŋ aö gakôm yêc malac Kapenaom, naŋ mac aŋgô ŋawaê su, dec mac atac whiŋ bu aö wakôm tiyham yêc dec, a?” ");
INSERT INTO buk_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ma iŋ sôm, “Yomandô! Yêc propet daŋ ndê malac, iŋ ndê lau oc sêkôc iŋ sa dom. ");
INSERT INTO buk_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Têŋ propet Elaija ndê têm, naŋ lauwhê sawa Israel-ŋga daêsam sêmbo. Têŋ ndoc dinaŋ u gic dom e tôm yala tö ma ayô 6, ma tôbôm atu gêm gameŋ ahuc. ");
INSERT INTO buk_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tigeŋ Anötö kêkiŋ Elaija têŋ awhê sawa Israel-ŋga daŋ dom, magoc kêkiŋ iŋ bu nem awhê sawa daŋ sa yêc Sarepet, malac naŋ yêc Saidon ŋagameŋ. ");
INSERT INTO buk_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma têŋ propet Elaisa ndê têm, naŋ lau ti gêmbac †leprasi daêsam sêmbo lau Israel-ŋga ŋalôm. Tigeŋ Elaisa kôm Israel si daŋ ŋayham sa dom. Iŋ gêm ŋgac Siria-ŋga Naman tawasê sa.” ");
INSERT INTO buk_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yisu ndê yom dinaŋ kôm lau naŋ sêndöc lôm wê-ŋga, atac ŋandê atu. ");
INSERT INTO buk_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Sêtisa ma sêsoc iŋ ma sêkôc iŋ sa sêtêŋ salic sac naŋ yêc malac dau ŋamakê, bu sêsuc iŋ sip ndi. ");
INSERT INTO buk_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tigeŋ iŋ kêsêlêŋ gic ŋac kôc, ma kölhö gi. ");
INSERT INTO buk_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tiŋambu iŋ mbu têŋ malac Kapenaom naŋ yêc gameŋ Galili-ŋga gi. Têŋ bêc Sabat-ŋga iŋ kêdôhôŋ lau. ");
INSERT INTO buk_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ŋac sêhêdaê tu iŋ ndê yom-ŋga, bu iŋ kêdôhôŋ lau ti ŋaclai atu. ");
INSERT INTO buk_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ma ŋgac daŋ naŋ ŋalau sac mbo iŋ ŋalôm, naŋ ndöc lôm wê-ŋga dinaŋ. Iŋ mbwêc awha atu, ");
INSERT INTO buk_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ei! Yisu Nasaret-ŋga. Aö kayalê am, am ŋgac dabuŋ naŋ Anötö kêkiŋ. Am bu kôm sake têŋ yac? Am mweŋ bu seŋ yac su, a?” ");
INSERT INTO buk_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Magoc Yisu hec yom ŋalau sac dau ma sôm, “Am mamaŋ ma hu iŋ siŋ!” Goc ŋalau sac kôm ŋgac dau peŋ sip nom gi yêc lau hoŋ aŋgô-ŋga, ma sa yêc iŋ, magoc kôm iŋ tisac dom. ");
INSERT INTO buk_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","L au hoŋ sêhêdaê tu gêŋ dinaŋ-ŋga, ma sêsôm têŋ dau, “Yom bocke naŋ iŋ kêdôhôŋ? Iŋ gic atu yom ŋaŋga ma ti ŋaclai têŋ ŋalau sac, ma soc ŋac su!” ");
INSERT INTO buk_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ma tiŋambu lau sic miŋ pi Yisu e iŋ ndê waê gêm gameŋ hoŋ dinaŋ ahuc. ");
INSERT INTO buk_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yisu tisa ma hu lôm wê-ŋga dau siŋ, ma têŋ Saimon ndê andu gi. Saimon ndê lawawê gêmbac lic ŋandê atu, dec sêndac Yisu bu nem iŋ sa. ");
INSERT INTO buk_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Goc Yisu têŋ iŋ gi, ma gic atu bu gêmbac dau hu iŋ siŋ. Ma ŋagahô awhê dau tisa ma gêm akiŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Têŋ telha dinaŋ ac gi sip su, goc lau sêkôc lau ti gêmbac hoŋ sa akêŋ ŋac si andu, ma sêtêŋ Yisu si. Iŋ kêŋ amba sac ŋac hoŋ, ma kôm ŋac ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ma iŋ soc ŋalau sac daêsam su, ma sêhu lau siŋ ti sêmbwêc, “Am Anötö ndê Atu.” Magoc iŋ hec yom ŋac, ma kêŋ yao bu ŋac sêsôm iŋ asê dom, ŋahu bu ŋac sêŋyalê bu iŋ Mesaya dau. ");
INSERT INTO buk_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Têŋ bêbêc ganduc Yisu hu malac dau siŋ, ma sa gi bu mbo tawasê. Ma lau malac-ŋga sêsa si bu sêŋsalê iŋ, ma têŋ ndoc sêtap iŋ s a, naŋ sêteŋ iŋ bu hu ŋac siŋ dom. ");
INSERT INTO buk_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Magoc iŋ sôm têŋ ŋac, “Mba! Aö gac waê bu wasôm ŋawaê ŋayham pi †Anötö ndê gôliŋ asê yêc malac ŋatô whiŋ. Anötö kêkiŋ aö tu gweleŋ dinaŋ-ŋga.” ");
INSERT INTO buk_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ma iŋ golom-golom malac naŋ sêyêc gameŋ Judia-ŋga, ma gêm mêtê tôm ŋac si lôm wê-ŋga hoŋ. ");
INSERT INTO buk_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Têŋ bêc daŋ Yisu kalhac Bugictoŋ Genesaret ŋamakê. Ma lau daêsam sêkac sa ma sêŋgihi iŋ ahuc tu bu sêŋgô Anötö ndê yom naŋ iŋ hoc asê. ");
INSERT INTO buk_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yisu gêlic lau sêkôc i-ŋga ŋatô sêŋgwasiŋ si wasaŋ sêmbo baö, ma ŋac si waŋ lu sêpoc suŋ sa têŋ baö. ");
INSERT INTO buk_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Dec iŋ pi waŋ daŋ gi, ma ndac waŋ ŋadau, ŋgac naŋ sêsam bu Saimon, bu hêc waŋ dau sa awê ŋagec. Goc iŋ ndöc sic ndöc waŋ, ma kêdôhôŋ lau naŋ sêlhac baö. ");
INSERT INTO buk_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Têŋ têm Yisu gic bata iŋ ndê yom, naŋ sôm têŋ Saimon, “Hêc waŋ sa bugictoŋ ŋagapoŋ ndi, ma kêŋ nem wasaŋ sip bu kôc i.” ");
INSERT INTO buk_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ma Saimon sôm, “O ŋgac atu, yac am gweleŋ atu ôbwêc baliŋ, magoc akôc i daŋ dom. Magoc tu am sôm-ŋga, dec aö wakêŋ wasaŋ sip ndi.” ");
INSERT INTO buk_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Goc Saimon ti ndê lau sêhêc waŋ sêsa si, ma sêkêŋ wasaŋ sip gi. Ma sêkôc i daêsam andô e wasaŋ meŋhu, kêpiŋ bu wasaŋ kic. ");
INSERT INTO buk_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bocdinaŋ ŋac sic gayo ŋac si silip ŋatô naŋ sêmbo waŋ tilu-ŋga bu sêmeŋ ma sênem ŋac sa. Goc ŋac sic dulu i sip waŋ lu-lu e meŋhu, ma kêpiŋ bu waŋ lu-lu sêpac. ");
INSERT INTO buk_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Têŋ ndoc Saimon Pita gêlic i daêsam dinaŋ, naŋ iŋ pôŋ haduc yêc Yisu gahi-ŋga ma sôm têŋ iŋ, “Pômdau, hu aö siŋ, bu aö ŋgac sac!” ");
INSERT INTO buk_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Iŋ sôm yom dinaŋ, ŋahu bu iŋ ti lau hoŋ naŋ sêmbo sêwhiŋ iŋ, naŋ sêhêdaê tu sêhê i daêsam dinaŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ma Jems lu Jon, Sebedi ndê atuŋgac lu naŋ sêmbo waŋ tilu-ŋga, naŋ sêhêdaê boc-d inaŋ. Magoc Yisu sôm têŋ Saimon, “Töc daôm dom. Am ŋgac kôc i-ŋga, magoc kwahic dec ma ndi, am oc kôm gweleŋ bu kôc ŋamalac sêmeŋ sêŋkuc aö.” ");
INSERT INTO buk_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ma tiŋambu sêsôc baö si goc sêhu gêŋ hoŋ siŋ, ma sêŋkuc Yisu. ");
INSERT INTO buk_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yisu mbo malac atu daŋ, ma ŋgac daŋ naŋ gêmbac leprasi gêm iŋ ndê ŋamlic sambuc ahuc, naŋ têŋ iŋ gi. Têŋ ndoc iŋ gêlic Yisu, naŋ iŋ hu dau aŋgô andô têŋ nom, ma teŋ iŋ, “Pômdau, am bu tac whiŋ, dec gitôm bu am oc kôm aö ŋamlic ŋawasi sa.” ");
INSERT INTO buk_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Goc Yisu kêmatôc amba ma kêmasec iŋ ma sôm, “Aö atac whiŋ, dec wasôm têŋ am bu ŋamlic ŋawasi sa.” Ma ŋagahô eŋ gêmbac leprasi hu iŋ siŋ. ");
INSERT INTO buk_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Goc Yisu kêŋ yao ma sôm, “Ndic miŋ têŋ ŋamalac daŋ dom, tigeŋ têŋ dabuŋsiga ndi, ma tôc daôm têŋ iŋ bu lic bu am nem ŋamlic ŋawasi sa su. Ma kêŋ da tu am ŋamlic ŋawasi sa-ŋga tôm yomsu naŋ Moses kêŋ têŋ yac. Ma ŋalêŋ dinaŋ lau hoŋ oc sêŋyalê bu am ŋamlic ŋayham sa.” ");
INSERT INTO buk_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yisu bu kêŋ yao ŋgac dau, magoc ŋawaê pi gêŋ naŋ Yisu kôm, naŋ gêm gameŋ sambuc ahuc. Bocdinaŋ lau daêsam sêtêŋ iŋ si ŋapaŋ, bu sêŋgô iŋ ndê yom, ma bu iŋ kôm ŋac si gêmbac ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tigeŋ têm ŋatô iŋ hu lau hoŋ siŋ, ma sa gameŋ sawa gi bu teŋ mbec. ");
INSERT INTO buk_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Têŋ bêc daŋ Yisu kêdôhôŋ lau mbo andu daŋ. Ma lau †Palêsai ti kêdôhôŋwaga yomsu-ŋga ŋatô naŋ sêmeŋ akêŋ malac Galili-ŋga ti Ju dia-ŋga hoŋ, ma akêŋ Jerusalem, naŋ sêndöc sêsuŋ sa têŋ iŋ. Ma Pômdau ndê ŋaclai gêm Yisu ahuc bu kôm lau gêmbac ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Têŋ têm dinaŋ lau ŋatô sêmeŋ sêmbalaŋ ŋgac bôliŋ daŋ yêc sac, ma bu sêsôc andu dau sêndi, tu bu sêkêŋ iŋ yêc Yisu aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Magoc lau daêsam sêŋgihi Yisu ahuc e ŋasawa mba. Bocdinaŋ ŋac sêpi andu ŋapoc lôlôc si, ma sêkac poc sa. Goc sêŋwhaŋ sac ti ŋgac bôliŋ dau sip lau daêsam ŋalhu, solop têŋ Yisu aŋgô-ŋga gi. ");
INSERT INTO buk_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yisu gêlic gêŋ dinaŋ dec kêyalê bu ŋac sêkêŋ whiŋ iŋ, ma sôm têŋ ŋgac bôliŋ, “O ŋgac daôm, kwahic dec aö wasuc am nem sac kwi.” ");
INSERT INTO buk_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Goc lau Palêsai ti lau naŋ sêndôhôŋ yomsu sic hu sem yom-galôm têŋ dau bocdec bu, “Ŋgac dindec iŋ asa? Iŋ ndê yom sac sambuc! Anötö tigeŋ gitôm bu suc sac kwi!” ");
INSERT INTO buk_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yisu kêyalê ŋac si gauc dinaŋ ma ndac ŋac, “Tu sake-ŋga mac gauc gêm yom bocdinaŋ? ");
INSERT INTO buk_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mac akêŋ whiŋ dom bu aneŋ ŋaclai yêc bu wasôm têŋ ŋgac dau bu, ‘Aö wasuc am nem sac kwi.’ Bocdinaŋ aö wasôm têŋ iŋ, ‘Tisa ma êmsêlêŋ.’ ");
INSERT INTO buk_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ma têŋ ndoc mac alic aneŋ yom dau ŋandô sa, naŋ aŋyalê bu Anötö kêŋ ŋaclai têŋ †Ŋamalac ndê Atu bu suc ŋamalac si sac kwi yêc nom whiŋ.” Goc Yisu sôm têŋ ŋgac bôliŋ dau, “Tisa, kôc nem mbô sa, ma lhö têŋ nem andu ndi.” ");
INSERT INTO buk_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ma ŋagahô ŋgac dau kalhac ŋac si aŋgô-ŋga, kôc iŋ ndê mbô sa, ma mbu têŋ ndê andu gi ti kêpiŋ Anötö. ");
INSERT INTO buk_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ma lau hoŋ sêhêdaê ŋandô. Sêmpiŋ Anötö ma sêsôm, “Acsalô lec yac dalic gêŋ kaiŋ daŋ solop!” ");
INSERT INTO buk_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tiŋambu Yisu sa awê gi ma gêlic ŋgac kôc takis-ŋga daŋ naŋ ndê ŋaê Liwai, ndöc ndê mala kôc takis-ŋga. Ma Yisu sôm têŋ iŋ, “Êmkuc aö!” ");
INSERT INTO buk_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Goc Liwai tisa, hu gêŋ hoŋ siŋ yêc, ma kêkuc Yisu. ");
INSERT INTO buk_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tiŋambu Liwai ndê mwasiŋ atu daŋ tu Yisu-ŋga yêc iŋ ndê andu. Ma lau sêkôc takis-ŋga daêsam, ma lau ŋatô sêndöc tebo ma seŋ gêŋ sêwhiŋ iŋlu Yisu. ");
INSERT INTO buk_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ma lau Palêsai ti lau †Skraib ŋatô naŋ sêmbo Palêsai si toŋ, naŋ sêlic gêŋ dau dec sêtucdiŋ ma sêsôm têŋ Yisu ndê ŋgacsêŋomi, “Tu sake-ŋga mac aŋ ti anôm gêŋ awhiŋ lau sêkôc takis-ŋga ti lau sac ŋatô?” ");
INSERT INTO buk_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ma Yisu dau ô ŋac si yom ma s ôm, “Lau naŋ sêlic dau bu gêmbac mba, naŋ oc sêŋsalê dokta dom, magoc lau ti gêmbac oc sêŋsalê dokta. ");
INSERT INTO buk_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Aö gameŋ bu waŋgalêm lau naŋ sêlic dau bu lau gitêŋ, naŋ sa dom, aö gameŋ bu waŋgalêm lau sac sa bu sênem dau kwi.” ");
INSERT INTO buk_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ma lau Palêsai ti lau Skraib dinaŋ sêsôm têŋ iŋ, “Ndoc daêsam Jon, Ŋgac Kêku Lau-ŋga ndê sêŋomi sêhu gêŋ daneŋ-ŋga siŋ ma sêteŋ mbec, ma Palêsai si sêŋomi sêkôm bocdinaŋ. Magoc tôm bêc hoŋ am nem ŋgacsêŋomi sênôm ti seŋ gêŋ sêmbo.” ");
INSERT INTO buk_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Goc Yisu sôm, “Ŋgac nem awhê-ŋga daŋ bu êŋgalêm lau sa sêmbo sêwhiŋ iŋ bu sêneŋ mwasiŋ nem awhê-ŋga, dec oc tôm dom bu dasôm têŋ ŋac bu sêhu gêŋ daneŋ-ŋga siŋ têŋ ndoc ŋgac dau mbo whiŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ŋalêŋ tigeŋ aö gambo gawhiŋ aneŋ ŋgacsêŋomi, ma tu dinaŋ-ŋga dec sêhu gêŋ daneŋ-ŋga siŋ dom. Tigeŋ ndoc oc meŋ, naŋ ŋacyo oc sêkôc aö su yêc ŋac, ma têŋ ndoc dinaŋ ŋac oc ŋalôm ŋawapac, ma sêŋkuc lêŋ dahu gêŋ daneŋ-ŋga siŋ-ŋga.” ");
INSERT INTO buk_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ma iŋ sôm yom gôliŋ daŋ têŋ ŋac bocdec bu, “Po akwa daŋ bu kic, dec yac dakêc po wakuc bu dasi pi po akwa dinaŋ dom. Bu dakôm, oc taŋyaiŋ po wakuc, ma po wakuc oc tôm po akwa dom. ");
INSERT INTO buk_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ma têŋ ndoc lau sêmasaŋ wain wakuc, naŋ sêkêc sip bôc ŋamlic wain-ŋga akwa dom. Mba. Ŋac bu sêkôm, goc wain wakuc oc hôc ŋamlic akwa kôc ma wê niŋga. Ma bôc ŋamlic oc tisac bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mba. Wain wakuc dakêc sip bôc ŋamlic wakuc. ");
INSERT INTO buk_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ma lau naŋ sênôm wain akwa su, naŋ sêtec bu sênôm wain wakuc, bu sêsôm, ‘Wain akwa, iŋ ŋayham.’” ");
INSERT INTO buk_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Têŋ bêc Sabat-ŋga daŋ, Yisu kêsêlêŋ mbo lôcwha naŋ gic ôm wit-ŋga daŋ kic, ma iŋ ndê ŋgacsêŋomi sêkôc wit ŋandô ma sêŋsê ŋapa goc seŋ ŋandô. ");
INSERT INTO buk_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ma Palêsai ŋatô sêlic gêŋ dau ma sêndac, “Tu sake-ŋga mac akôm gweleŋ naŋ yac neŋ yomsu gic yao bu dakôm têŋ bêc Sabat-ŋga dom?” ");
INSERT INTO buk_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ma Yisu ô yom ma sôm, “Gauc nem yom naŋ sêto yêc pi gêŋ naŋ Kiŋ Dawid kôm. Mac asam su, me? Têŋ ndoc daŋ gêŋ yô iŋ ma lau naŋ sêwhiŋ iŋ, ");
INSERT INTO buk_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","dec iŋ sôc Anötö ndê andu gi, ma gêŋ bolom dabuŋ naŋ lau sêkêŋ ti da, naŋ Moses kêŋ yao bu dabuŋsiga tawasê sêneŋ. Ma iŋ kêŋ têŋ lau naŋ sêmbo sêwhiŋ iŋ ma ŋac seŋ. Magoc lau daŋ sêŋgôliŋ yom pi Dawid me sêsôm bu iŋ kêgilì yomsu lec dom.” ");
INSERT INTO buk_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ma iŋ sôm têŋ ŋac, “Ŋamalac ndê Atu iŋ gêŋ hoŋ ŋadau, ma iŋ Pômdau bêc Sabat-ŋga whiŋ.” ");
INSERT INTO buk_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Têŋ bêc Sabat-ŋga daŋ iŋ sôc lôm wê-ŋga daŋ gi, ma kêdôhôŋ lau. Ma ŋgac daŋ naŋ ndê amba andô-ŋga tibalê naŋ ndöc. ");
INSERT INTO buk_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Lau Palêsai ti lau naŋ sêndôhôŋ yomsu naŋ sêŋsalê yom bu sêŋgôliŋ pi Yisu. Tu dinaŋ-ŋga dec ŋac tatiŋ iŋ ŋapep bu mboe iŋ oc kôm ŋgac dau ŋayham sa têŋ bêc Sabat-ŋga, dec ŋac oc sêsôm bu iŋ kêgilì yomsu Sabat-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yisu kêyalê ŋac si gauc, ma sôm têŋ ŋgac amba balê, “Tisa, ma lhac lau hoŋ aŋgô-ŋga.” Ma iŋ tisa kalhac. ");
INSERT INTO buk_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Goc Yisu sôm têŋ ŋac, “Aö bu wandac mac bu gêŋ bocke oc êŋgilì yomsu Sabat-ŋga? Dakôm ŋayham têŋ lau, me dakôm sac têŋ lau? Danem ŋamalac sa, me datec ŋac sêmbac ndu?” ");
INSERT INTO buk_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Iŋ tahê ŋac hoŋ, ma sôm têŋ ŋgac dau, “Êmatôc amam.” Goc ŋgac dau kêmatôc amba, ma amba dau ŋayham sa tiyham. ");
INSERT INTO buk_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Magoc gêŋ dau kôm lau Palêsai ti lau Skraib atac ŋandê atu, ma ŋac sem yomgalôm têŋ dau pi Yisu, ma pi gêŋ bocke bu sêkôm têŋ iŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Têŋ bêc daŋ Yisu pi lôc daŋ gi bu teŋ mbec, ma tôm ôbwêc baliŋ iŋ teŋ mbec mbo. ");
INSERT INTO buk_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Têŋ galaŋsê bêbêc iŋ kêgalêm lau naŋ sêŋkuc iŋ sêmeŋ, ma kêyaliŋ ŋac si lau 12 sa, ma sam ŋac bu lau †Aposel. ");
INSERT INTO buk_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Lau Aposel dau si ŋaê bocdec: Saimon, naŋ Yisu sam bu ‘Pita,’ lu asi Andru, ma Jems, Jon, Pilip, Batolomeas, ");
INSERT INTO buk_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu, Tomas, Jems (naŋ Alpayas ndê atu), Saimon (naŋ sêsam bu ‘Ŋgac †Selot’), ");
INSERT INTO buk_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas (naŋ ŋadamba iŋ ŋgac daŋ ŋaê Jems), ma Judas Iskeriot naŋ tiŋambu oc hoc Yisu asê. ");
INSERT INTO buk_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yisu ti ndê ŋgacsêŋomi sêsip akêŋ lôc sêmeŋ, ma Yisu kalhac gameŋ gapoŋ. Ma †sêŋomi daêsam naŋ sêŋkuc Yisu, naŋ sêkac sa su sêmbo dinaŋ. Ma lau toŋ atu akêŋ malac Jerusalem ti malac gameŋ Judia-ŋga hoŋ, ma lau akêŋ gameŋ gwêc-ŋga naŋ yêc kêpiŋ malac Taya ma Saidon, naŋ sêmeŋ bu sêŋgô iŋ ndê yom, ma bu iŋ kôm ŋac si gêmbac ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Lau naŋ ŋalau sac sêmbo ŋac si ŋalôm, naŋ Yisu kôm ŋac ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ma lau hoŋ sêhôc sôsôwec bu sêmasec iŋ, ŋahu bu ŋaclai sa yêc Yisu, ma kôm lau gêmbac hoŋ ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yisu tahê iŋ ndê ŋgacsêŋomi ma sôm, “Anötö ndê mwasiŋ gic waê mac lau ŋalôm sawa, bu iŋ gêlic ŋayham bu kôc mac sa andöc iŋ ndê gôliŋ ŋapu. ");
INSERT INTO buk_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Anötö ndê mwasiŋ gic waê mac lau naŋ kwahic dec gêŋ yô mac, bu iŋ oc kêŋ gêŋ hôc mac dôŋ-ŋga. Anötö ndê mwasiŋ gic waê mac lau naŋ kwahic dec andöc ti tamsulu, bu iŋ oc nem malô mac e ambwac. ");
INSERT INTO buk_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Anötö ndê mwasiŋ gic waê mac lau naŋ sêtec mac ma sêtiŋ mac, ma sêpu mac ti sêkôm nem waêm tisac tu mac aŋkuc Ŋamalac ndê Atu-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ahêgo daôm dom têŋ ndoc lau sêkôm bocdinaŋ, tigeŋ atê wê ti atac ŋayham, bu Anötö oc kêŋ ŋagêyô ŋayham têŋ mac yêc undambê. Ma gauc nem bu lau naŋ sêtec mac, naŋ si apai sêkôm ŋalêŋ tigeŋ dinaŋ têŋ Anötö ndê lau propet ŋamata-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Oyaê mac lau naŋ apo daôm sa ŋa awa ti wapa daêsam. Mac atap nem mwasiŋ ŋayham sa têŋ têm kwahic dec-ŋga, magoc gêŋ dau oc tôm dom bu nem mac sa têŋ têm ŋambu-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Oyaê mac lau naŋ aŋ gêŋ ŋawahô kwahic dec. Tiŋambu gêŋ oc yô mac. Oyaê mac lau naŋ ambwac kwahic dec. Tiŋambu mac oc ataŋ daŋgibo atu ma andöc ti tamsulu. ");
INSERT INTO buk_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Oyaê mac lau naŋ lau hoŋ sêmpiŋ mac. Atac ŋayham tu gêŋ dinaŋ-ŋga dom, bu ŋalêŋ tigeŋ lau Israel-ŋga si apai sêmpiŋ lau propet tasaŋ.” ");
INSERT INTO buk_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ma Yisu sôm têŋ lau dinaŋ, “Aŋgô aneŋ yom. Atac whiŋ mac nem ŋacyo, ma akôm ŋayham têŋ lau naŋ sêtec mac. ");
INSERT INTO buk_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Anem mbec lau naŋ sêpucbo mac, ma ateŋ mbec pi lau naŋ sêkôm sac têŋ mac. ");
INSERT INTO buk_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ŋgac daŋ bu tap am sip alim andô daŋga, naŋ kêŋ daŋga bu iŋ ndic whiŋ. Ŋgac daŋ bu kôc nem ŋakwê baliŋ su yêc am, naŋ êmgamiŋ nem ŋakwê ŋandô-ŋga dom magoc kêŋ têŋ iŋ whiŋ. ");
INSERT INTO buk_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ŋgac daŋ bu ndac gêŋ daŋ, naŋ kêŋ têŋ iŋ. Ma ŋgac daŋ bu kôc am nem gêŋ daŋ, naŋ ndac bu iŋ kêŋ mbu meŋ dom. ");
INSERT INTO buk_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mêtê ŋayham-ŋayham naŋ mac atac whiŋ bu lau sêkôm têŋ mac, naŋ mac daôm akôm têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Lau hoŋ atac whiŋ lau naŋ atac whiŋ ŋac ô. Bocdinaŋ mac bu atac whiŋ nem silip tawasê ma atac tec nem ŋacyo, dec mac nem mêtê hôc gêlêc lau sac si mêtê su dom. ");
INSERT INTO buk_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma lau hoŋ sêkôm ŋayham têŋ lau naŋ sêkôm ŋayham têŋ ŋac ô, ma mac bu akôm bocdinaŋ, dec mac nem mêtê hôc gêlêc lau sac si mêtê su dom. ");
INSERT INTO buk_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma mac bu akêŋ tôp têŋ mac nem silip, naŋ iŋ gêŋ atu dom. Mac aŋyalê su bu tiŋambu ŋac oc sêndic tôp dau. Lau sac sêkêŋ tôp têŋ si silip, ma takwê bu ŋac sêndic tôp hoŋ mbu meŋ. ");
INSERT INTO buk_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Bocdinaŋ ayob daôm bu aŋkuc lau sac si mêtê dom. Atac whiŋ nem ŋacyo, ma akôm ŋayham têŋ ŋac. Akêŋ gêŋ têŋ ŋac, ma ahêgo daôm dom pi ndoc bocke ŋac oc sêkêŋ gêŋ dau mbu meŋ-ŋga. Tu dinaŋ-ŋga Anötö, Ŋaclai ti Ŋawasi Ŋadau oc kêŋ ŋaôli ŋayham atu têŋ mac, ma sam mac bu iŋ ndê atui awhê ma ŋgac. Bu Anötö dau kêmwasiŋ lau sac ma lau naŋ sem daŋge iŋ dom, naŋ sêwhiŋ. ");
INSERT INTO buk_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Bocdinaŋ tamwalô lau hoŋ, tôm Damam undambê-ŋga tawalô lau.” ");
INSERT INTO buk_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ma Yisu sôm, “Anem dôhôŋ lau si lêŋ ti sakiŋ tu bu alic lau ŋatô sac ŋambwa, me tu bu apu ŋac-ŋga dom. Mac bu akôm, dec Anötö oc lic mac sac ma pu mac tu mac nem lêŋ ti sakiŋ-ŋga boc-dinaŋ. Asuc lau si sac kwi, ma Anötö oc suc mac nem kwi boc-dinaŋ. ");
INSERT INTO buk_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Têŋ ndoc mac bu anem lau ŋatô sa, naŋ akêŋ gêŋ têŋ ŋac ti nem ŋalôm sambuc, ma boc-dinaŋ Anötö oc kêŋ gêŋ hôc gêlêc su têŋ mac e meŋhu ma êŋsalê mac ahuc. Bu Anötö oc êmwasiŋ mac, gitôm mac amwasiŋ lau.” ");
INSERT INTO buk_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ma Yisu sôm yom gôliŋ daŋ bocdec, “Ŋgac tapec gitôm bu wê tapec daŋ dom. Mba! Iŋlu lu-lu oc sêpeŋ sêsip sê sêndi. ");
INSERT INTO buk_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ma kwapuc daŋ oc hôc gêlêc gwalam akwa naŋ kêdôhôŋ iŋ, naŋ dom. Magoc kwapuc hoŋ naŋ sêndôhôŋ gêŋ hoŋ e tidôŋ ŋac, naŋ oc sêtôm ŋac si kêdôhôŋwaga. ");
INSERT INTO buk_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Tu sake-ŋga am hêgo daôm tu gêŋ golop sauŋ naŋ yêc nem asidôwa tandô, tigeŋ gêŋ golop atu naŋ yêc am daôm tanôm, naŋ am gêlic apu? ");
INSERT INTO buk_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ma bocke am oc sôm têŋ nem asidôwa, ‘Aneŋ asidôwa, aö bu wakôc gêŋ golop naŋ yêc am tanôm, naŋ sa,’ magoc gêŋ golop atu naŋ pôc am daôm tanôm ahuc, naŋ am gêlic dom? Am ŋgac tim yom lau-ŋga! Gêŋ ŋamata-ŋga kôc gêŋ golop sa yêc daôm tanôm e tanôm ŋawa sa, goc tiŋambu kôc gêŋ golop sauŋ naŋ yêc nem asidôwa tandô, naŋ sa.” ");
INSERT INTO buk_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ma Yisu sôm, “A ŋayham daŋ oc nem ŋandô sac dom, ma a sac oc nem ŋandô ŋayham dom. ");
INSERT INTO buk_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Dalic ŋandô naŋ a tidau-tidau sem, ma bocdinaŋ yac taŋyalê bu a ŋayham me sac. Gitôm dom bu dahiŋ ŋandô ŋayham yêc a sac. ");
INSERT INTO buk_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ma ŋalêŋ tigeŋ, yom naŋ lau sêsôm, naŋ tôc gêŋ bocke naŋ hôc ŋac si ŋalôm ahuc, naŋ asê. Mêtê ti gauc ŋayham yêc lau ŋayham si ŋalôm, ma bocdinaŋ sêkôm mêtê ŋayham. Ma mêtê ti gauc sac yêc lau sac si ŋalôm, dec sêkôm sac.” ");
INSERT INTO buk_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Tu sake-ŋga mac asam aö bu, ‘Pômdau, Pômdau,’ tigeŋ mac daŋam wambu aneŋ yom dom? ");
INSERT INTO buk_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ŋamalac naŋ têŋ aö meŋ ma ŋgô aneŋ yom, ma daŋga wambu yom dau, naŋ aö bu wawhê iŋ sa têŋ mac. ");
INSERT INTO buk_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Iŋ gitôm ŋgac kwê andu-ŋga naŋ kwê sê baliŋ sip nom ŋaŋga, ma kêŋ hoc kêgapiŋ alhö dôŋ têŋ ndoc iŋ kêsuhuŋ sip sê baliŋ dinaŋ. Têŋ ndoc uhô-ŋga, bu hêc meŋ hôc pi andu dau, magoc andu dau kalhac ŋaŋga, bu iŋ kwê ŋapep. ");
INSERT INTO buk_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Magoc ŋamalac naŋ ŋgô aneŋ yom ma daŋga wambu dom, naŋ gitôm ŋgac naŋ kwê andu, magoc kêŋ alhö sip nom ŋalôm gi dom. Têŋ ndoc uhô-ŋga, bu hêc ma hôc pi ndê andu e ŋagahô eŋ andu dau ku sa ma tisac sambuc.” ");
INSERT INTO buk_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yisu gic bata yom naŋ iŋ kêdôhôŋ têŋ lau toŋ atu dinaŋ, goc sôc malac Kapenaom gi. ");
INSERT INTO buk_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ma ŋgac bata Rom-ŋga naŋ gêm gôliŋ lau siŋ-ŋga 100, naŋ mbo malac dau. Iŋ ndê ŋgac akiŋ daŋ naŋ iŋ tac whiŋ kêlêc, naŋ gêmbac e kêpiŋ bu mbac ndu. ");
INSERT INTO buk_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ma iŋ ŋgô Yisu ŋawaê, dec kêkiŋ lau bata Israel-ŋga ŋatô sêtêŋ iŋ si, bu sêndac iŋ bu meŋ ma kôm iŋ ndê ŋgac akiŋ ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Ŋac sêhôc asê têŋ Yisu, ma sêsôm têŋ iŋ bu, “Ŋgac bata siŋ-ŋga dinaŋ iŋ ŋgac ŋayham, ma iŋ tac whiŋ yac lau Israel-ŋga. Iŋ gêm yac sa tu akwê yac mba lôm wê-ŋga. Boc-dinaŋ yac ateŋ am bu nem iŋ sa.” ");
INSERT INTO buk_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Goc Yisu whiŋ ŋac gi. Iŋ meŋ suŋ sa têŋ andu, ma ŋgac bata siŋ-ŋga dau kêkiŋ ndê silip ŋatô bu sêsôm têŋ iŋ, “Pômdau, ŋgac bata siŋ-ŋga dau sôm bu iŋ tec bu kêŋ ŋawapac têŋ am. Iŋ sôm bu am ŋgac tiwaê naŋ hôc gêlêc iŋ su, dec iŋ maya bu am têŋ iŋ ndê andu ndi. ");
INSERT INTO buk_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Tu dinaŋ-ŋga iŋ dau têŋ am meŋ dom. Tigeŋ iŋ sôm bu iŋ kêyalê su bu am ŋgac ti ŋaclai atu, ma bocdinaŋ dec am gitôm bu sôm ŋa awham ŋambwa, dec iŋ ndê ŋgac akiŋ oc ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Bu iŋ dau daŋga wambu lau naŋ si ŋaclai hôc gêlêc iŋ ndê, ma iŋ ndê lau siŋ-ŋga daŋga wambu iŋ. Iŋ bu sôm têŋ daŋ, ‘Am ndi,’ dec iŋ oc ndi. Ma iŋ bu sôm têŋ daŋ, ‘Mweŋ!’ dec iŋ oc meŋ. Ma iŋ bu sôm têŋ ndê ŋgac akiŋ bu kôm gêŋ daŋ, dec iŋ oc kôm.” ");
INSERT INTO buk_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yisu ŋgô ŋgac bata siŋ-ŋga ndê yom dinaŋ e hêdaê. Iŋ kac dau kwi ma sôm têŋ lau toŋ atu naŋ sêŋkuc iŋ, “Aö wasôm têŋ mac bu yêc lau Israel-ŋga hoŋ aö gatap ŋac si daŋ naŋ kêŋ whiŋ ŋaŋga gitôm ŋgac Rom-ŋga dinaŋ, naŋ sa dom.” ");
INSERT INTO buk_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ma tiŋambu ŋgac bata siŋ-ŋga ndê lau sêmbu sêtêŋ iŋ ndê andu si, ma sêtap sa bu ŋgac akiŋ dau ŋayham sa su. ");
INSERT INTO buk_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Bêc ŋatô giŋga su, ma Yisu têŋ malac Nein gi, ma iŋ ndê ŋgac-sêŋomi ti lau daêsam sêwhiŋ iŋ si. ");
INSERT INTO buk_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Têŋ têm iŋ meŋ kêpiŋ malac dau ŋagatam, iŋ gêlic lau ŋatô sêsa sêmeŋ, sêmbalaŋ ŋgac batê daŋ bu sêŋsuhuŋ iŋ. Ŋgac batê dinaŋ dinda iŋ awhê sawa naŋ ndê balêkoc ŋatô mbasi. Ma lau malac-ŋga daêsam sêwhiŋ dinda sêsa sêmeŋ. ");
INSERT INTO buk_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pômdau gêlic dinda, ma tawalô iŋ ŋandô, goc sôm, “Am taŋ dom.” ");
INSERT INTO buk_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Goc iŋ têŋ ŋac gi, ma kêmasec sasac naŋ ŋgac batê yêc. Ma lau naŋ sêhôc sasac, naŋ sêlhac teŋ. Ma iŋ sôm, “Aneŋ balê, aö wasôm têŋ am bu tisa!” ");
INSERT INTO buk_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ma ŋgac dau tisa ndöc, ma gic hu sôm yom. Goc Yisu kêŋ iŋ mbu têŋ dinda gi. ");
INSERT INTO buk_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Gêŋ dinaŋ kôm lau hoŋ sêtöc dau atu, ma ŋac sic hu sêmpiŋ Anötö. Ŋatô sêsôm, “Propet atu daŋ hôc asê yac.” Ma ŋatô sêsôm, “Anötö kêlhiŋ iŋ ndê lau yac siŋ dom, iŋ gêm yac sa.” ");
INSERT INTO buk_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ma tiŋambu ŋawaê pi gêŋ naŋ Yisu kôm, naŋ gêm gameŋ Judia-ŋga ma gameŋ ŋamakê-ŋga hoŋ ahuc. ");
INSERT INTO buk_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Têŋ ndoc dinaŋ Jon, Ŋgac Kêku Lau-ŋga ndöc gapocwalô, ma iŋ ndê sêŋomi sic miŋ têŋ iŋ pi gêŋ hoŋ naŋ Yisu kôm. Goc Jon kêyaliŋ iŋ ndê sêŋomi lu sa, ");
INSERT INTO buk_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ma kêkiŋ iŋlu sêtêŋ Yisu si, bu sêndac iŋ, “Anötö gic bata têŋ yac bu oc êŋkiŋ Mesaya. Am daôm dinaŋ, me yac oc akêŋ bataŋ ŋgac daŋ tiyham?” ");
INSERT INTO buk_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Têŋ ndoc ŋgac lu dinaŋ sêhôc asê Yisu, iŋ gêm gweleŋ mbo, ma kôm lau daêsam ŋayham sa, lau gêmbac ma lau ti ŋalau sac. Ma iŋ kôm lau tapec daêsam si tandô po asê. Ma iŋlu sêsôm têŋ iŋ, “Jon, Ŋgac Kêku Lau-ŋga kêkiŋ alu atêŋ am ameŋ, bu andac am bu am Mesaya dau, me yac oc akêŋ bataŋ ŋgac daŋ tiyham?” ");
INSERT INTO buk_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Goc Yisu ô iŋlu si yom ma sôm, “Amlu ambu andi ma asôm yom têŋ Jon pi mêtê naŋ amlu aŋgô aö gahoc asê, ma pi gêŋ naŋ amlu alic aö gakôm. Lau tapec sêlic gameŋ tiyham, lau bôliŋ sêŋsêlêŋ tiyham, lau ti gêmbac leprasi si ŋamlic ŋawasi sa, lau daŋgasuŋ bic sêŋgô yom tiyham, lau batê sêtisa, ma lau ŋalôm sawa sêŋgô ŋawaê ŋayham. ");
INSERT INTO buk_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Aŋgô! Lau naŋ atac lu-lu tu aö-ŋga dom, naŋ oc sêtap Anötö ndê mwasiŋ sa.” ");
INSERT INTO buk_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ŋgac lu naŋ Jon kêkiŋ, naŋ sêhu Yisu siŋ ma sêmbu si, goc Yisu sôm yom pi Jon têŋ lau toŋ atu, ma ndac ŋac bocdec bu, “Têŋ ndoc mac asa atêŋ Jon yêc gameŋ sawa a, naŋ mac gauc gêm bu atap ŋamalac kaiŋ bocke sa? Mac bu alic ŋgac gauc babalê, gitôm gakoc naŋ mbu kêwic, a? ");
INSERT INTO buk_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mac asa a bu alic ŋgac naŋ sôc ŋakwê ŋayham, a? Mba! Lau naŋ sêsôc ŋakwê ŋayham ma seŋ gêŋ ŋayham, naŋ sêmbo gameŋ ŋayham gitôm kiŋ si andu. ");
INSERT INTO buk_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","B ocdinaŋ dec aö bu wandac mac, bu mac asa a bu alic sake? Bu alic propet daŋ? Yomandô! Iŋ propet daŋ, ma iŋ hôc gêlêc propet hoŋ su. ");
INSERT INTO buk_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Propet akwa daŋ to yom naŋ Anötö sôm têŋ Mesaya bocdec bu, ‘Aö waŋkiŋ aneŋ ŋgac aheŋ-ŋga muŋ am, bu êmasaŋ am nem seŋ.’ Y om pi ŋgac aheŋ-ŋga dau hêganôŋ Jon solop. ");
INSERT INTO buk_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ŋamalac naŋ dinda nom-ŋga sêkôc ŋac, naŋ si daŋ hôc gêlêc Jon su dom. Tigeŋ aö wasôm têŋ mac, bu lau hoŋ naŋ sêsôc Anötö ndê gôliŋ ŋapu su, lau tiwaê, ma lau waêmba bocdinaŋ, naŋ hoŋ sêhôc gêlêc Jon su yêc Anötö aŋgô-ŋga.” ");
INSERT INTO buk_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Lau daêsam naŋ sêŋgô Yisu ndê yom dinaŋ, ma lau sêkôc takis-ŋga sêwhiŋ, naŋ sêtôc asê bu sêlic Anötö ndê lêŋ bu lêŋ solop eŋ. Ŋahu bu muŋ-ŋga, têŋ ndoc Jon gêm mêtê ma kêku lau mbo, naŋ sêkôc iŋ ndê yom sa ma sêliŋ saŋgu. ");
INSERT INTO buk_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tigeŋ lau Palêsai ti gwalam akwa yomsu-ŋga sêkôc Jon ti iŋ ndê yom sa dom, ma sêliŋ iŋ ndê saŋgu dom, dec tôc asê bu sêtec Anötö ndê lêŋ naŋ Jon tôc têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ma Yisu gic têku yom ma sôm, “Lau têm dindec-ŋga ŋac lau kaiŋ bocke? Aö wanem dôhôŋ pi gêŋ sake tu bu wawhê ŋac si lêŋ sa-ŋga? ");
INSERT INTO buk_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ŋac sêtôm balêkoc naŋ sêkôc whê sêmbo malac lôm, naŋ sêtucdiŋ ŋac si silip ŋatô ma sêsôm, ‘Têŋ ndoc naŋ yac ac oŋ bu datê wê, naŋ mac atec. Ma têŋ ndoc yac am wê daŋgibo-ŋga, naŋ mac atec bu ataŋ awhiŋ.’ ");
INSERT INTO buk_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ma mac lau têm dindec-ŋga bocdinaŋ. Jon, Ŋgac Kêku Lau-ŋga meŋ ma gêŋ gêŋ ŋayham dom, ma nôm wain dom, ma mac asôm bu ŋalau sac daŋ mbo iŋ ndê ŋalôm. ");
INSERT INTO buk_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ma Ŋamalac ndê Atu meŋ hôc asê, ma gêŋ gêŋ ŋayham ti nôm wain, ma mac asôm bu iŋ ŋgac gêŋ gêŋ ti nôm wain ŋawahô-ŋga, ma iŋ hê silip têŋ lau sac ti lau sêkôc takis-ŋ ga. Bocdinaŋ, mac lau têm dindec-ŋga atôm balêkoc naŋ sêkôm tô aŋiŋ ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tigeŋ Anötö ndê gauc hôc gêlêc gêŋ hoŋ, ma iŋ ndê lau sêŋyalê bu iŋ ndê lêŋ iŋ lêŋ solop.” ");
INSERT INTO buk_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Palêsai daŋ ŋaê Saimon kêgalêm Yisu bu neŋ gêŋ whiŋ iŋ, dec Yisu sôc iŋ ndê andu gi, ma ndöc tebo bu neŋ gêŋ. ");
INSERT INTO buk_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Yêc malac dinaŋ, awhê sac daŋ mbo. Iŋ ŋgô ŋawaê bu Yisu ndöc Palêsai ndê andu dinaŋ, dec kôc bu ŋamalu ŋayham sip kac daŋ, ma têŋ andu dau gi. ");
INSERT INTO buk_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Iŋ pôŋ haduc yêc Yisu gahi-ŋga ma taŋ, ma iŋ ndê tasulu sip Yisu gahidômbwê. Goc iŋ puŋ Yisu gahi ŋa kêclauŋ, ŋgutô iŋ gahi, ma mbac gêŋ malu dau pi iŋ gahi. ");
INSERT INTO buk_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Saimon gêlic gêŋ dau, ma gauc gêm yêc dau, “Ŋgac dindec iŋ bu propet daŋ, dec iŋ oc êŋyalê bu awhê naŋ kêmasec iŋ, naŋ awhê sac daŋ.” ");
INSERT INTO buk_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yisu kêyalê yom naŋ Saimon gauc gêm, goc sôm, “Saimon, aö bu wasôm yom daŋ têŋ am.” Ma Saimon ô yom ma sôm, “Kêdôhôŋwaga, sôm.” ");
INSERT INTO buk_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Goc Yisu sôm yom gôliŋ daŋ bocdec bu, “Ŋgac lu sêkôc tôp yêc ŋgac ti lêlôm. Ŋgac daŋ ndê tôp gitôm †denarii 500 ma daŋ ndê tôp gitôm denarii 50. ");
INSERT INTO buk_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Iŋlu si mone sêndic tôp-ŋga mbasi, dec iŋ hu iŋlu si tôp ŋayom siŋ. Am gauc gêm bocke? Iŋlu si asa oc atac whiŋ ŋgac dau hôc gêlêc?” ");
INSERT INTO buk_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ma Saimon sôm, “Ŋgac naŋ kôc tôp atu, naŋ.” Ma Yisu sôm, “Am sôm solop.” ");
INSERT INTO buk_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Goc iŋ kac dau kwi, tahê awhê dinaŋ, ma sôm têŋ Saimon, “Aö gasôc am nem andu gameŋ, magoc am kêŋ bu têŋ aö bu waŋgwasiŋ gahiŋ-ŋga tôm lau Israel-ŋga si gêbôm dom. Tigeŋ lic awhê dec. Iŋ ndê tasulu kôm aö gahiŋ ŋamaim sa, ma iŋ puŋ aö gahiŋ ŋa kêclauŋ. ");
INSERT INTO buk_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Am ŋgutô aö dom, tigeŋ awhê dec ŋgutô aö gahiŋ ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Am kêc olib ŋakwi pi aö ŋagôlôŋ dom, tigeŋ iŋ kêc bu ŋamalu pi aö gahiŋ. ");
INSERT INTO buk_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Bocdinaŋ aö wasôm têŋ am bu awhê dindec kêyalê bu Anötö suc iŋ ndê sac daêsam kwi, ma bocdinaŋ iŋ atac whiŋ aö ŋandô. Tigeŋ lau naŋ gauc gêm bu ŋac si sac atu dom, naŋ oc atac whiŋ iŋ naŋ bu suc ŋac si sac kwi, naŋ ŋandô dom.” ");
INSERT INTO buk_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ma Yisu sôm têŋ awhê dau, “Aö gasuc am nem sac kwi su.” ");
INSERT INTO buk_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ma ŋacleŋ ŋatô naŋ sêndöc sêwhiŋ, naŋ sêsôm têŋ dandi, “Ŋgac dindec iŋ ŋgac kaiŋ bocke, dec iŋ suc sac kwi?” ");
INSERT INTO buk_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tigeŋ Yisu sôm têŋ awhê dau, “Am nem kêŋ whiŋ gêm am si. Lhö ti atac malô ndi.” ");
INSERT INTO buk_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tiŋambu Yisu golom malac atu-tu ti sauŋ-sauŋ, ma gêm mêtê ma hoc ŋawaê ŋayham asê pi Anötö ndê gôliŋ. Ma †ŋgacsêŋomi 12 ");
INSERT INTO buk_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ti lauwhê daêsam sêŋsêlêŋ sêwhiŋ iŋ. Lauwhê dinaŋ ŋatô Yisu soc ŋalau sac su yêc ŋac, ma ŋatô iŋ kôm ŋac si gêmbac ŋayham sa. Ŋac si daŋ iŋ Maria Magadala, naŋ Yisu soc ŋalau sac 7 su yêc iŋ. ");
INSERT INTO buk_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ma awhê daŋ iŋ Joana, naŋ ndê akweŋ Kusa yob Herod ndê andu. Maria lu Joana, ma Susana, ma lauwhê daêsam sêŋkuc Yisu ma sêkêŋ si awa ti wapa tu sênem iŋ ti ndê ŋgacsêŋomi sa-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Têŋ têm daŋ lau toŋ atu sêtêŋ Yisu sêmeŋ, ma lau akêŋ malac hoŋ yêc gameŋ Galili-ŋga sêmbo sêwhiŋ. Ma Yisu sôm yom gôliŋ daŋ bocdec bu, ");
INSERT INTO buk_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ŋgac daŋ sa gi bu êmbalip wit ŋawhê yêc ndê ôm, ma têŋ ndoc iŋ kêbalip gêŋ dau, naŋ ŋatô sêpeŋ sêsip seŋ, dec lau sêkwê dôŋ ma mbac lôlôc-ŋga sêsip sêmeŋ ma seŋ su. ");
INSERT INTO buk_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ma ŋawhê ŋatô sêpeŋ sêsip gameŋ hoc-hoc, ma têŋ têm sêpo sêpi sêmeŋ, naŋ sem bôliŋ, bu nom dau tibasô. ");
INSERT INTO buk_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ŋawhê ŋatô sêpeŋ sêsip kwaŋ ti ŋakwa ŋalôm, ma têŋ ndoc sêpo sêpi sêmeŋ, naŋ kwaŋ pi whiŋ e yaŋ gêŋ dau ndu. ");
INSERT INTO buk_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma ŋawhê ŋatô sêpeŋ sêsip nom ŋayham, ma sêpo sêpi sêmeŋ e sem ŋandô gitôm 100.” Yisu gic bata yom gôliŋ dau, goc sôm, “Asa bu daŋgasuŋ yêc, naŋ ŋgô aneŋ yom!” ");
INSERT INTO buk_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tiŋambu Yisu ndê ŋgacsêŋomi sêndac iŋ bu whê yom gôliŋ dinaŋ ŋahu sa. ");
INSERT INTO buk_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ma iŋ sôm, “Anötö ndê gôliŋ ŋalêŋ ŋahu sip ŋalôm gi. Iŋ kêyaliŋ mac sa bu aŋyalê ŋahu dau, magoc aö wasôm yom têŋ lau ŋatô ŋa yom gôliŋ ŋambwa. Tôm yom naŋ sêto yêc, naŋ sôm, ‘Ŋac sêlic gêŋ naŋ aö gakôm, naŋ ŋapaŋ, magoc ŋac si gauc sa dom. Ma ŋac sêŋgô aneŋ yom ŋapaŋ, tigeŋ ŋac sêŋyalê ŋahu dom.’” ");
INSERT INTO buk_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Goc Yisu sôm, “Yom gôliŋ dau ŋahu bocdec. Yom pi wit ŋawhê naŋ hêganôŋ Anötö ndê yom. ");
INSERT INTO buk_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Wit ŋawhê naŋ sêpeŋ sêsip seŋ, naŋ hêganôŋ lau naŋ sêŋgô Anötö ndê yom, magoc Sadaŋ meŋ ma kêgaho yom dau su yêc ŋac si ŋalôm, tu bu ŋac sêkêŋ whiŋ dom, ma sêtap Anötö ndê mwasiŋ nem ŋac si-ŋga sa dom. ");
INSERT INTO buk_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ma yom pi wit ŋawhê naŋ sêpeŋ sêsip gameŋ hoc-hoc, naŋ hêganôŋ lau naŋ sêŋgô Anötö ndê yom ma sêkôc sa ti atac ŋayham, tigeŋ gitôm gêŋ ŋawhê naŋ ŋawakac mba, dec lau dinaŋ sêkêŋ whiŋ ŋasawa sauŋ, magoc lêtôm meŋ ku ŋac dulu. ");
INSERT INTO buk_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ma yom pi wit ŋawhê naŋ sêpeŋ sêsip kwaŋ ti ŋakwa ŋalôm, naŋ hêganôŋ lau naŋ sêŋgô Anötö ndê yom, magoc ŋawapac ma mone ti gêŋ ŋayham-ŋayham nom-ŋga gêm ŋac si ŋalôm ahuc, ma ŋac si ŋandô mbasi. ");
INSERT INTO buk_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tigeŋ wit ŋawhê naŋ sêpeŋ sêsip nom ŋayham, naŋ hêganôŋ lau ti ŋalôm ŋawasi, naŋ sêŋgô Anötö ndê yom ma sêkôc sa tidôŋ yêc si ŋalôm, ma sêlhac ŋaŋga ŋapaŋ ma sem ŋandô daêsam.” ");
INSERT INTO buk_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ma Yisu sôm yom daŋ bocdec bu, “Yac datuŋ lam asê tu bu dasiŋ kwi sip lôŋ ŋalôm, me dakêŋ sôc sasac ŋapu dom. Mba! Taŋkiŋ êŋgalêŋ ŋalhu, bu lau naŋ sêsôc sêmeŋ, naŋ sêlic ŋawê. ");
INSERT INTO buk_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ma ŋalêŋ tigeŋ, yom naŋ yêc siŋ dau, ma yom naŋ ŋahu sip ŋalôm gi, naŋ oc meŋ sa tiawê. ");
INSERT INTO buk_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Bocdinaŋ akôc gauc ŋapep pi Anötö ndê yom naŋ mac aŋgô. Asa naŋ kôc Anötö ndê yom sa sip ndê ŋalôm e tidôŋ, naŋ Anötö oc kêŋ ŋagauc daêsam têŋ iŋ. Magoc asa naŋ gauc gêm bu iŋ kôc Anötö ndê yom sa su, tigeŋ iŋ kôc sa tidôŋ dom, naŋ Anötö oc kôc yom dau su yêc iŋ.” ");
INSERT INTO buk_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yisu ndöc andu daŋ, ma iŋ dinda ti asii sêmeŋ bu sêlic iŋ. Magoc lau daêsam sêmbo sêwhiŋ iŋ, ma gitôm dom bu sêtigasuc iŋ. ");
INSERT INTO buk_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ma ŋamalac daŋ sôm têŋ Yisu, “Am dinam ti asimi sêmbo awê, ma ŋac bu sêlic am.” ");
INSERT INTO buk_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Magoc Yisu ô yom ma sôm, “Lau naŋ sêŋgô Anötö ndê yom ma daŋga wambu ŋapep, naŋ sêti aö dinaŋi ti asiŋi.” ");
INSERT INTO buk_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Têŋ bêc daŋ Yisu sôm têŋ iŋ ndê ŋgacsêŋomi, “Dapi bugictoŋ ŋadaŋga dandi,” goc iŋ pi waŋ daŋ whiŋ ŋac, ma sêsa si. ");
INSERT INTO buk_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sêlac waŋ sêmbo, ma Yisu yêc bêc yêc. Ma mbu puc atu dec gêli bu sa ma ŋampoŋ gic sip waŋ e kêpiŋ bu waŋ pac. ");
INSERT INTO buk_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Dec sêtêŋ Yisu si, sêuŋ iŋ sa ma sêsôm, “Ŋadau, ŋadau, yac oc dandiŋaŋ!” Ma Yisu tisa ma sôm yom ŋaŋga têŋ mbu ti bu ŋampoŋ, dec ŋampoŋ dau timalô, ma gameŋ ŋaŋeŋ sa. ");
INSERT INTO buk_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ma Yisu sôm têŋ ŋac, “Tu sake-ŋga mac akêŋ whiŋ gwalec?” Ma ŋac sêtöc dau ti sêhêdaê, ma sêsôm têŋ dandi, “Ei! Iŋ ŋgac dec asa? Iŋ gitôm bu kêŋ yatu gêŋ hoŋ, ma mbu ti bu ŋampoŋ sêwhiŋ, ma sêsôc iŋ ndê yom ŋapu!” ");
INSERT INTO buk_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sêlac e sêhôc asê lau Gerasa-ŋga si gameŋ naŋ yêc Bugictoŋ Galili-ŋga ŋadaŋga mbu têŋ gameŋ ac pi-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yisu sip baö gi, ma ŋgac daŋ akêŋ malac atu naŋ yêc gameŋ dinaŋ, naŋ têŋ iŋ meŋ. Iŋ ŋgac naŋ ŋalau sac sêmbo iŋ ndê ŋalôm. Ŋasawa baliŋ su ŋgac dau sôc ŋakwê dom, ma ndöc andu dom, magoc mbo ôm sêhô-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ndoc daêsam ŋalau sac sêkôc iŋ dôŋ, ma lau sêŋsahê bu sêsô iŋ amba ti gahi dôŋ ŋa sen ŋaŋga ma sêyob iŋ. Magoc têm hoŋ iŋ hê sen kic, ma ŋalau sac sêwê iŋ sa gameŋ sawa gi. Têŋ ndoc iŋ gêlic Yisu meŋ, naŋ iŋ mbwêc ma hu dau sip nom yêc iŋ aŋgô-ŋga. Ma Yisu gic atu ŋalau sac bu sêhu ŋgac dau siŋ, goc ŋalau daŋ ta yom ti ŋaŋga, “Yisu, Anötö Ŋaclai ti Ŋawasi Ŋadau ndê Atu, am bu kôm sake têŋ aö? Aö wateŋ am bu kôm aö ŋayom dom!” ");
INSERT INTO buk_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Goc Yisu ndac ŋalau sac, “Am nem ŋaê asa?” Ŋalau sac daêsam sêmbo ŋgac dau ŋalôm, ma tu dinaŋ-ŋga ŋac si daŋ ô Yisu ndê yom ma sôm, “Aneŋ ŋaê ‘Toŋ Atu.’” ");
INSERT INTO buk_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ma ŋalau sac h oŋ dinaŋ sêteŋ Yisu tidim daêsam, bu êŋkiŋ ŋac sêsip suŋ baliŋ sac naŋ sêsam bu Abis, naŋ sêndi dom. ");
INSERT INTO buk_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Têŋ têm dinaŋ bôc toŋ atu seŋ gêŋ sêmbo lôc ŋapu yêc gameŋ dinaŋ, ma ŋalau dau sêteŋ Yisu bu êŋkiŋ ŋac sêsôc bôc dinaŋ si ŋalôm, ma Yisu gôlôc. ");
INSERT INTO buk_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Goc ŋalau sac sêhu ŋgac dinaŋ siŋ ma sêsôc bôc si ŋalôm si. Ma bôc hoŋ sênti sêsip salic sac ma sêsip bugictoŋ ŋalôm si, ma bu kô ŋac sêmbac ndu. ");
INSERT INTO buk_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Têŋ ndoc lau sêyob bôc-ŋga sêlic gêŋ dau, naŋ sêlhö si, ma sic miŋ pi gêŋ dau têŋ lau naŋ sêmbo malac atu ti gameŋ ŋamakê-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ma lau hoŋ sêsa si bu sêlic gêŋ naŋ Yisu kôm. Têŋ têm sêhôc asê iŋ, naŋ sêlic ŋgac naŋ iŋ soc ŋalau sac su yêc iŋ, naŋ ndöc Yisu gahi-ŋga. Sêlic bu iŋ ndê gauc ŋawa sa, ma iŋ sôc ŋakwê sa tiyham, dec sêtöc dandi. ");
INSERT INTO buk_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Lau naŋ sêlic gêŋ dau, naŋ sic miŋ têŋ ŋac pi ŋalêŋ naŋ Yisu kôm ŋgac ti ŋalau sac ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ma lau Gerasa-ŋga hoŋ sêndac Yisu bu hu ŋac siŋ, bu ŋac sêtöc dau atu. Goc Yisu pi waŋ ma bu lhö ndi. ");
INSERT INTO buk_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ma ŋgac naŋ ŋalau sac sêhu iŋ siŋ, naŋ teŋ Yisu ŋaŋga bu whiŋ iŋ ndi, magoc Yisu kêkiŋ iŋ sa gi ma sôm, ");
INSERT INTO buk_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Am mbu têŋ am nem andu ndi, ma ndic miŋ gêŋ hoŋ naŋ Anötö kôm têŋ am.” Goc ŋgac dau kölhö gi, ma gic miŋ têŋ lau hoŋ naŋ sêmbo malac atu dinaŋ, pi gêŋ atu naŋ Yisu kôm têŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Lau daêsam sêhôŋ Yisu sêmbo gameŋ Galili-ŋga, ma têŋ têm iŋ mbu akêŋ bugictoŋ ŋadaŋga meŋ, naŋ sêkôc iŋ sa ti atac ŋayham. ");
INSERT INTO buk_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ma ŋgac bata daŋ, naŋ yob lôm wê-ŋga yêc gameŋ dinaŋ, naŋ meŋ hôc asê Yisu. Iŋ ndê ŋaê Jairas, ma iŋ hu dau sip nom yêc Yisu aŋgô-ŋga, ma teŋ iŋ ŋaŋga bu têŋ iŋ ndê andu ndi, ma nem iŋ ndê atuwê sa. ");
INSERT INTO buk_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Bu iŋ ndê atuwê tigeŋ, naŋ ndê yala gitôm 12, naŋ gêmbac atu e kêpiŋ bu mbac ndu. Bocdinaŋ Yisu whiŋ iŋ gi. Iŋ kêsêlêŋ mbo seŋ, ma lau toŋ atu sêŋgihi iŋ ahuc. ");
INSERT INTO buk_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Lau toŋ dinaŋ si daŋ iŋ awhê naŋ gêm dac ŋapaŋ tôm yala 12 su, magoc ŋamalac daŋ gitôm bu nem iŋ sa dom. ");
INSERT INTO buk_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","A whê dau meŋ kêsêlêŋ mbo Yisu ŋambu-ŋga, ma kêmasec iŋ ndê ŋakwê sip ŋadali. Ma ŋagahô iŋ ndê dac sa tiyham dom. ");
INSERT INTO buk_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Têŋ dinaŋ Yisu ndac, “Asa kêmasec aö?” Lau daŋ sêsôm dau asê dom, ma Pita sôm, “Aneŋ ŋadau, lau toŋ dindec sêwhiŋ yac sêkôm am si.” ");
INSERT INTO buk_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Magoc Yisu sôm, “Ŋamalac daŋ kêmasec aö, bu aö kayalê bu aneŋ ŋaclai ŋatô sa gi.” ");
INSERT INTO buk_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Awhê dinaŋ kêyalê bu iŋ gitôm dom bu siŋ dau, dec tigasuc Yisu. Iŋ kêtitec, ma hu dau sip nom gi. Ma yêc lau hoŋ aŋgô-ŋga, iŋ whê sa bu iŋ kêmasec Yisu tu bu ŋayham sa-ŋga, ma bu têŋ ndoc iŋ kêmasec iŋ, naŋ ŋagahô iŋ ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ma Yisu sôm têŋ iŋ, “O aneŋ bawhê, am nem kêŋ whiŋ aö dec kôm am ŋayham sa. Am lhö ti atac malô ndi.” ");
INSERT INTO buk_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yisu sôm yom dinaŋ mbo, ma ŋgac daŋ meŋ akêŋ Jairas ndê andu, ma sôm têŋ Jairas, “Am atômwê mbac ndu su, dec kêŋ ŋawapac têŋ Kêdôhôŋwaga dau dom.” ");
INSERT INTO buk_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yisu ŋgô yom dinaŋ, magoc iŋ sôm têŋ Jairas, “Töc daôm dom. Kêŋ whiŋ, ma iŋ oc ŋayham sa.” ");
INSERT INTO buk_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Têŋ ndoc sêhôc asê Jairas ndê andu, naŋ sêlic lau daêsam sêhu daŋgibo asê ma sêtaŋ sêmbo. Goc Yisu sôm, “Mac ataŋ dom! Iŋ mbac ndu dom, iŋ yêc bêc yêc.” Magoc ŋac sêmbwac iŋ, bu sêŋyalê bu bawhê dau mbac ndu su. Tigeŋ Yisu kalhac lau hoŋ ahuc sêmbo awê, ma kôc Pita, Jems ma Jon, ma bawhê dau damba lu dinda, sêwhiŋ iŋ ma sêsôc andu si. ");
INSERT INTO buk_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ma iŋ kêm bawhê dau sip amba ma sôm, “Aneŋ bawhê, tisa!” ");
INSERT INTO buk_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Goc bawhê dau tali sa tiyham, ma ŋagahô iŋ tisa kalhac. Ma Yisu sôm bu sêkêŋ gêŋ daneŋ-ŋga têŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Iŋ damba lu dinda sêhêdaê, magoc Yisu gic yao bu sêndic miŋ pi gêŋ naŋ iŋ kôm, naŋ dom. ");
INSERT INTO buk_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yisu kêgalêm ŋgacsêŋomi 12 sa sêpitigeŋ, ma kêŋ ŋaclai ti licwalô têŋ ŋac gitôm bu sêsoc ŋalau sac su, ma sêkôm lau gêmbac ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ma iŋ kêkiŋ ŋac bu sêsa sêndi ma sênem mêtê pi Anötö ndê gôliŋ, ma bu sênem lau gêmbac sa. ");
INSERT INTO buk_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Iŋ sôm têŋ ŋac, “Aŋsêlêŋ amam sawa andi, akôc tôc dom, ma akôc talhi, me bolom, me mone, me ŋakwê aô daôm-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Têŋ têm mac asôc malac daŋ ma lau sêkôc mac sa asôc ŋac si andu, naŋ ambo whiŋ ŋac e mac ahu malac dau siŋ. ");
INSERT INTO buk_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ma lau malac daŋ-ŋga bu sêkôc mac sa dom, naŋ atoŋ kop su yêc gahim têŋ ndoc mac ahu ŋac siŋ, bu atôc ŋac si giso asê.” ");
INSERT INTO buk_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ŋgacsêŋomi sêŋgô yom dinaŋ, goc sêsa si. Ŋac sêŋsêlêŋ sêlom-sêlom malac ma sêhoc ŋawaê ŋayham asê, ma sêkôm lau ŋayham sa yêc gameŋ hoŋ. ");
INSERT INTO buk_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Têŋ ndoc dinaŋ gôliŋwaga Galili-ŋga Herod ŋgô yom pi gêŋ hoŋ naŋ Yisu kôm. Ma iŋ gauc gêm yom daêsam, bu lau ŋatô sêsôm bu Yisu iŋ Jon, Ŋgac Kêku Lau-ŋga naŋ tisa akêŋ lau batê-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ma lau ŋatô sêsôm bu iŋ propet akwa Elaija naŋ meŋ hoc dau asê, ma ŋatô sêsôm bu iŋ propet ŋamata-ŋga si daŋ, naŋ tisa akêŋ lau batê-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tigeŋ Herod sôm, “Aö gac atu, dec sêtim Jon ndê kachu kic su. Asa dec lau sic miŋ pi iŋ?” Ma iŋ tac whiŋ bu lic Yisu. ");
INSERT INTO buk_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Têŋ têm aposel 12 sêmbu sêmeŋ, naŋ sic miŋ têŋ Yisu pi gêŋ hoŋ naŋ sêkôm. Ma tiŋambu iŋ kôc ŋac sa sêwhiŋ iŋ, ma ŋac tawasê sêtêŋ malac Betsaida si. ");
INSERT INTO buk_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Magoc lau daêsam sêŋgô ŋawaê ma sêtêŋ Yisu si. Ma iŋ kôc ŋac sa, ma sôm y om têŋ ŋac pi Anötö ndê gôliŋ, ma kôm ŋac si lau gêmbac ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Sêmbo e kêpiŋ bu ac ndi sip, goc ŋgacsêŋomi 12 sêtêŋ iŋ si ma sêsôm, “Gameŋ dindec yac dambo, naŋ gameŋ sawa. Bocdinaŋ êmkiŋ lau toŋ dindec sêlhö sêtêŋ malac ti gameŋ ŋamakê-ŋga sêndi, bu sêŋsalê gêŋ sêneŋ-ŋga ma gameŋ sêyêc bêc-ŋga.” ");
INSERT INTO buk_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Magoc Yisu sôm, “Mac akêŋ gêŋ têŋ ŋac sêneŋ.” Ma ŋac sêô yom ma sêsôm, “Yac mba gêŋ daneŋ-ŋga daêsam dom. Bolom limdaŋ ma i lu sêndöc. Bocke? Yac andi anemlhi gêŋ bu lau hoŋ sêneŋ, a?” ");
INSERT INTO buk_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ŋac sêsôm yom dinaŋ ŋahu bu lau toŋ dinaŋ si lauŋgac ŋanamba gitôm 5,000. Magoc Yisu sôm têŋ iŋ ndê ŋgac-sêŋomi, “Akêŋ lau sêndöc sic titoŋ-titoŋ tôm 50.” ");
INSERT INTO buk_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Goc ŋac sêkôm gitôm iŋ sôm, ma lau hoŋ sêndöc sic. ");
INSERT INTO buk_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ma Yisu kôc bolom limdaŋ ma i lu sa, tatac undambê, ma gêm daŋge, goc pô kôc-kôc, ma kêŋ têŋ ŋgacsêŋomi bu sêndic sam têŋ lau. ");
INSERT INTO buk_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Lau hoŋ seŋ gêŋ e hôc ŋac dôŋ, ma tiŋambu ŋgacsêŋomi sic gêŋ ŋadêlê sa sip gatop 12 e meŋhu. ");
INSERT INTO buk_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Têŋ ndoc daŋ Yisu ti iŋ ndê ŋgacsêŋomi sêmbo tawasê, ma iŋ teŋ mbec mbo. Pacndê, goc iŋ ndac ŋac, “Lau sêsôm bu aö asa?” ");
INSERT INTO buk_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ma sêsôm, “Lau ŋatô sêsôm bu am Jon, Ŋgac Kêku Lau-ŋga, ma ŋatô sêsôm bu am Elaija, ma ŋatô sêsôm bu am propet ŋamata-ŋga si daŋ, naŋ tisa akêŋ lau batê-ŋga.” ");
INSERT INTO buk_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Goc Yisu ndac ŋac, “Ma mac daôm, mac asôm bu aö asa?” Ma Pita sôm, “Am Mesaya, naŋ Anötö gic bata bu êŋkiŋ meŋ.” ");
INSERT INTO buk_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yisu ŋgô yom dau ma gic yao ŋac bu sêsôm asê têŋ lau daŋ dom e tiŋambu. ");
INSERT INTO buk_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Iŋ sôm, “Ŋamalac ndê Atu gic waê bu hôc ŋawapac daêsam. Lau bata ti †dabuŋsiga atu-tu ma lau naŋ sêndôhôŋ yomsu oc sêtec iŋ ma lau oc sêndic iŋ ndu. Magoc têŋ bêc titö-ŋga Anötö oc uŋ iŋ sa tiyham.” ");
INSERT INTO buk_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ma iŋ sôm têŋ ŋac hoŋ, “Asa naŋ tac whiŋ bu êŋkuc aö naŋ êŋgwiniŋ dau, ma tôm bêc hoŋ hôc ndê a gicso dau sa, ma êŋkuc aö. ");
INSERT INTO buk_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Bu asa naŋ tac whiŋ bu sap gêŋ nom-ŋga dôŋ ŋapaŋ tu mbo tali-ŋga, naŋ oc niŋga. Magoc asa naŋ bu hu gêŋ nom-ŋga siŋ tu êŋkuc aö-ŋga, naŋ oc niŋga dom. ");
INSERT INTO buk_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ŋamalac daŋ bu po gêŋ nom-ŋga hoŋ sa, magoc iŋ dau gatu bu niŋga, dec gêŋ nom-ŋga hoŋ dinaŋ oc tôm dom bu nem iŋ sa. ");
INSERT INTO buk_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Asa naŋ bu maya tu aö ti aneŋ yom-ŋga, naŋ Ŋamalac ndê Atu oc maya tu iŋ-ŋga, têŋ ndoc iŋ mbu meŋ ti iŋ dau ndê ŋawasi, ma Damba ndê ŋawasi ma aŋela dabuŋ si ŋawasi whiŋ. ");
INSERT INTO buk_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","M a aö wasôm bu yomandô, lau ŋatô kwahic dec sêmbo, naŋ oc gacgeŋ sêmbo tali e sêlic Anötö ndê gôliŋ meŋ sa tiawê.” ");
INSERT INTO buk_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yisu sôm yom dinaŋ su, ma bêc ŋatô gitôm 8 meŋ gi su. Ma Yisu bu teŋ mbec, dec kôc Pita, Jon ma Jems sêwhiŋ iŋ ma sêpi lôc daŋ si. ");
INSERT INTO buk_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ma têŋ têm Yisu teŋ mbec mbo, naŋ iŋ ndê aŋgô andô kaiŋ daŋ sa, ma iŋ ndê ŋakwê ŋawasi sêp sambuc. ");
INSERT INTO buk_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ma ŋgac lu sêhôc asê ti ŋawasi atu, naŋ Moses lu Elaija, ma iŋlu sem yomgalôm sêwhiŋ Yisu. Sêsôm yom pi gêŋ naŋ oc hôc asê Yisu yêc malac Jerusalem têŋ ndoc meŋ sa bu iŋ hu nom dindec siŋ. ");
INSERT INTO buk_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Têŋ ndoc dinaŋ, Pita ma ŋgac lu naŋ sêwhiŋ iŋ, naŋ kwapac ma bêc yô ŋac, tigeŋ ŋac tali sa ma sêlic Yisu ndê ŋawasi ti ŋgac lu naŋ sêlhac sêwhiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Têŋ têm Moses lu Elaija bu sêhu Yisu siŋ, naŋ Pita sôm têŋ iŋ, “Ŋadau, ŋayham kêlêc bu yac dambo dec. Yac oc akwê bac tö, am nem daŋ, Moses ndê daŋ, ma Elaija ndê bac daŋ.” Iŋ sôm yom dinaŋ, magoc iŋ ndê gauc sa dom. ");
INSERT INTO buk_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Iŋ sôm yom dinaŋ mbo, ma dao daŋ meŋ ma kôm ŋac ahuc e ŋgacsêŋomi tö dinaŋ sêtöc dau atu. ");
INSERT INTO buk_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma awha daŋ sa yêc dao ŋalôm, naŋ sôm, “Aö neŋ atuŋgac dau dindec, naŋ aö kayaliŋ sa. Aŋgô iŋ ndê yom maŋ!” ");
INSERT INTO buk_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Sêŋgô su goc sêlic Yisu tawasê mbo. Tiŋambu ŋac sem yom dau ahuc yêc dau-ŋga, ma têŋ ndoc dinaŋ sêsôm yom asê pi gêŋ naŋ sêlic, naŋ dom. ");
INSERT INTO buk_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Têŋ galaŋsê ŋac sêsip akêŋ lôc dau sêmeŋ, ma lau toŋ atu sêkac sa sêtêŋ Yisu si. ");
INSERT INTO buk_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ŋac si daŋ ta yom bocdec bu, “Kêdôhôŋwaga, aö gakôc aneŋ atuŋgac tigeŋ dindec meŋ, ma wateŋ am bu nem iŋ sa. ");
INSERT INTO buk_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ŋalau sac daŋ mbo iŋ ŋalôm, ma têm daêsam kôc iŋ dôŋ, m a kêmwanaŋ iŋ ŋaŋga e iŋ mbwêc atu, ma whapwic sa. Ŋalau sac dau bu kôm iŋ tisac, ma tec bu hu iŋ siŋ. ");
INSERT INTO buk_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Aö gateŋ am nem ŋgac-sêŋomi bu sêsoc ŋalau dau su, magoc ŋac sêtôm dom.” ");
INSERT INTO buk_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Goc Yisu sôm, “O mac lau sac. Mac nem akêŋ whiŋ mbasi! Aö gambo gawhiŋ mac ŋasawa hic baliŋ su, ma bocke mac atôm dom bu akôm gêŋ daŋ? Aö oc wambo wawhiŋ mac tu wanem mac sa ŋapaŋ-ŋga dom!” Ma Yisu sôm têŋ balê dau ŋadamba, “Kôc nem balê sa mweŋ.” ");
INSERT INTO buk_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Têŋ têm balê dau kêsêlêŋ meŋ, naŋ ŋalau sac kôc iŋ dôŋ ma kêmwanaŋ iŋ. Tigeŋ Yisu hec yom ŋalau sac, ma kôm balê dau ŋayham sa, ma kêŋ iŋ mbu têŋ iŋ damba gi. ");
INSERT INTO buk_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ŋalêŋ dinaŋ Yisu tôc Anötö ndê ŋaclai ti ŋawasi atu asê, dec kôm lau hoŋ sêhêdaê. Lau hoŋ sêlhac ti sêhêdaê tu gêŋ hoŋ naŋ Yisu kôm-ŋga, ma iŋ sôm têŋ iŋ ndê ŋgacsêŋomi, ");
INSERT INTO buk_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Aŋgô aneŋ yom dindec ŋapep! Tiŋambu oc sêkêŋ Ŋamalac ndê Atu sip lau ŋatô amba.” ");
INSERT INTO buk_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Magoc ŋac sêŋyalê yom dau ŋahu dom. Yom dau ŋahu yêc siŋ dau têŋ ŋac, ma sêtöc bu sêndac Yisu bu whê sa têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tiŋambu Yisu ndê ŋgac-sêŋomi sêseŋ dau pi ŋac si asa iŋ ŋgac ŋamata-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yisu kêyalê ŋac si gauc, goc kôc balê sauŋ daŋ ma kêŋ iŋ kalhac kêpiŋ iŋ, ");
INSERT INTO buk_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ma sôm têŋ ŋac, “Asa naŋ kôc balê sauŋ daŋ tôm iŋ dindec sa tu aneŋ ŋaê-ŋga, naŋ kôc aö sa, ma asa naŋ kôc aö sa, naŋ kôc iŋ naŋ kêkiŋ aö gameŋ, naŋ sa. Mac nem asa naŋ kêgwiniŋ dau ma ti mac nem ŋgac akiŋ, naŋ ti ŋgac ŋamata-ŋga yêc Anötö aŋgô-ŋga.” ");
INSERT INTO buk_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ma Jon sôm, “Ŋadau, yac alic ŋgac daŋ kôm gweleŋ ma soc ŋalau sac su yêc lau ŋa am nem ŋaê. Iŋ kêkuc am whiŋ yac dom, ma boc-dinaŋ yac ac yao iŋ bu kôm gweleŋ dau dom.” ");
INSERT INTO buk_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tigeŋ Yisu sôm, “A lhac iŋ ahuc dom, bu asa naŋ kêŋ kisa mac dom, naŋ mac nem daŋ.” ");
INSERT INTO buk_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ndoc meŋ kêpiŋ bu Yisu mbu pi undambê ndi, dec iŋ kêmasaŋ dau bu pi malac Jerusalem ndi. ");
INSERT INTO buk_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Iŋ kêkiŋ lau aheŋ-ŋga sêmuŋ iŋ, sêsôc lau †Samaria-ŋga si malac daŋ si, bu sêmasaŋ gameŋ tu iŋ mbo-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Magoc lau Samaria-ŋga sêŋyalê bu iŋ kêsêlêŋ hêganôŋ malac Jerusalem, ma tu dinaŋ-ŋga dec sêkôc iŋ sa dom. ");
INSERT INTO buk_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jems lu Jon sêlic gêŋ dau, goc sêndac Yisu, “Pômdau, am bu sôm, dec yac oc aŋgalêm ya sip akêŋ undambê meŋ, ma seŋ ŋac su.” ");
INSERT INTO buk_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tigeŋ Yisu kac dau kwi, ma sôm iŋlu. ");
INSERT INTO buk_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ma ŋac hoŋ sêlom malac daŋ si. ");
INSERT INTO buk_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yisu ti ndê ŋgacsêŋomi sêŋsêlêŋ sêmbo seŋ ma ŋgac daŋ sôm têŋ Yisu, “Aö bu waŋkuc am, wawhiŋ am watêŋ gameŋ bocke naŋ am oc ndi.” ");
INSERT INTO buk_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ma Yisu ô iŋ ndê yom ma sôm, “Giam pôm si hocsuŋ yêc, ma mbac lôlôc-ŋga si ŋaic yêc, tigeŋ Ŋamalac ndê Atu ndê mala yêc bêc-ŋga mba.” ");
INSERT INTO buk_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ma iŋ sôm têŋ ŋgac daŋ, “Mweŋ êmkuc aö!” Magoc ŋgac dau sôm, “Pômdau, gêŋ ŋamata-ŋga aö wandi wambo wawhiŋ aneŋ lau e aŋsuhuŋ damaŋ su naŋ, ma tiŋambu wambu wameŋ waŋkuc am.” ");
INSERT INTO buk_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ma Yisu sôm têŋ iŋ, “Mba! Am êmkuc aö naŋ gêŋ ŋamata-ŋga. Tec lau batê sêŋsuhuŋ lau batê. Tigeŋ am ndi, ma hoc yom asê têŋ lau pi Anötö ndê gôliŋ.” ");
INSERT INTO buk_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ma ŋgac daŋ tiyham sôm, “Pômdau, aö bu waŋkuc am, tigeŋ gêŋ ŋamata-ŋga wambu watêŋ aneŋ andu, ma wakam aneŋ lau.” ");
INSERT INTO buk_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ma Yisu ô iŋ ndê yom ma sôm, “Asa naŋ gic hu gweleŋ daŋ, tigeŋ kac dau kwi ma hêgo gêŋ naŋ iŋ hu siŋ su, naŋ gitôm dom bu nem gweleŋ mbo Anötö ndê gôliŋ ŋapu.” ");
INSERT INTO buk_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tiŋambu Pômdau kêyaliŋ sêŋomi 72 tiyham sa, bu êŋkiŋ ŋac lu-lu sêsa sêndi sêmuŋ iŋ, sêtêŋ gameŋ ti malac hoŋ naŋ iŋ atac whiŋ bu ndic kêsi. ");
INSERT INTO buk_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ma iŋ sôm têŋ ŋac, “Gêŋ ŋandô daêsam yêc ôm, magoc lau sêndic gêŋ ŋandô sa-ŋga daêsam dom. Bocdinaŋ ateŋ mbec têŋ ôm ŋadau bu êŋkiŋ lau gweleŋ-ŋga sêsôc iŋ ndê ôm sêndi, ma sêndic gêŋ ŋandô sa. ");
INSERT INTO buk_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kwahic dec aö bu waŋkiŋ mac asa andi! Magoc ayob daôm ŋapep, bu aö kakiŋ mac bu asa andi atôm domba ŋatu, naŋ sêtêŋ giam pôm si gameŋ sêndi. ");
INSERT INTO buk_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Akôc talhi, me dalu, me atapa dom, ma aŋsêlêŋ ŋagahô andi. Ahê mwalêc lau yêc seŋ dom. ");
INSERT INTO buk_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Têŋ ndoc mac bu asôc andu daŋ, naŋ asôm bu, ‘Yom malô têŋ lau andu dindec-ŋga.’ ");
INSERT INTO buk_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Andu ŋadau bu ŋgac yom malô-ŋga dom, dec mac nem mbec yom malô-ŋga oc gacgeŋ yêc mac-ŋga. Ma andu ŋadau bu ŋgac yom malô-ŋga, dec iŋ oc kôc mbec yom malô-ŋga dinaŋ sa. ");
INSERT INTO buk_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ambo andu dinaŋ, ma alom-alom andu dom. Aneŋ ti anôm gêŋ bocke naŋ sêkêŋ têŋ mac, naŋ ti mac nem ŋaôli gweleŋ-ŋga. Mêtê solop bu lau g weleŋ-ŋga sêkôc ŋaôli gweleŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Têŋ têm mac asôc malac daŋ, ma lau sêkôc mac sa, naŋ aneŋ gêŋ daneŋ-ŋga naŋ sêkêŋ têŋ mac. ");
INSERT INTO buk_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Akôm ŋac si lau gêmbac ŋayham sa, ma asôm têŋ ŋac, ‘Anötö ndê gôliŋ meŋ kêpiŋ.’ ");
INSERT INTO buk_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tigeŋ mac bu asôc malac daŋ, ma sêkôc mac sa dom, naŋ goc alhac malac lôm ma asôm, ");
INSERT INTO buk_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Yac atoŋ kop mac nem malac-ŋga su yêc yac mba gahiŋ. Yac akêŋ kop dindec mbu têŋ mac bu atôc nem mêtê sac asê. Tigeŋ aŋyalê bu Anötö ndê gôliŋ meŋ kêpiŋ.’ ");
INSERT INTO buk_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yomandô aö wasôm têŋ mac bu têŋ bêc Anötö êmatôc lau-ŋga, naŋ lau malac dinaŋ-ŋga oc sêtap ŋagêyô sac andô sa, hôc gêlêc ŋagêyô naŋ Anötö oc kêŋ têŋ lau sac malac Sodom-ŋga.” ");
INSERT INTO buk_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yisu gic têku yom ma sôm, “Oyaê mac lau malac Korasin ma Betsaida-ŋga. Mac oc atap Anötö ndê atac ŋandê sa. †Lau apa naŋ sêndöc malac Taya ma Saidon, bu sêlic gêŋ dalô naŋ aö gakôm yêc mac aŋôm-ŋga, dec oc tôm sênem dau kwi wandêc su, ma sêndöc ti sêtaŋ si sac. ");
INSERT INTO buk_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tigeŋ mac akôm dom, dec wasôm têŋ mac bu têŋ ndoc Anötö êmatôc lau-ŋga, naŋ iŋ oc kêŋ ŋagêyô sac sambuc têŋ mac, hôc gêlêc ŋagêyô naŋ iŋ oc kêŋ têŋ lau Taya ti Saidon-ŋga, naŋ su. ");
INSERT INTO buk_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“Ma mac lau Kapenaom-ŋga, mac gauc gêm bu mboe Anötö oc kôc mac sa andöc undambê, a? Mba! Iŋ oc êmasuc mac su asip lambwam andi!” ");
INSERT INTO buk_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ma Yisu sôm têŋ sêŋomi 72 bu, “Asa naŋ kôc mac nem yom sa, naŋ gitôm iŋ kôc aneŋ yom sa. Ma asa naŋ tec mac, naŋ gitôm iŋ tec aö bocdinaŋ. Ma asa naŋ tec aö, naŋ tec Damaŋ naŋ kêkiŋ aö gameŋ.” Yisu sôm yom dinaŋ su, goc kêkiŋ sêŋomi 72 sêsa si. ");
INSERT INTO buk_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tiŋambu sêŋomi 72 dinaŋ sêmbu sêmeŋ ti atac ŋayham, ma sêsôm, “Pômdau, têŋ ndoc yac asôm am nem ŋaê asê, naŋ gêŋ hoŋ sêsôc yac mba yom ŋapu, ma ŋalau sac sêwhiŋ.” ");
INSERT INTO buk_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ma Yisu sôm, “Aö kayalê bu gêŋ naŋ mac akôm, naŋ ku Sadaŋ ndê ŋaclai dulu, e tôm iŋ peŋ akêŋ undambê ŋagahô ŋambwa, tôm sickac hep tigeŋ. ");
INSERT INTO buk_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Aö gakêŋ ŋaclai têŋ mac su, tôm bu akwê mboc ti gapiŋgap dôŋ, ma bu ahôc gêlêc mac nem ŋacyo Sadaŋ ndê ŋaclai hoŋ su. Gêŋ daŋ oc kôm mac atisac dom. ");
INSERT INTO buk_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kwahic dec mac atac ŋayham bu ŋalau sac sêsôc mac nem yom ŋapu. Tigeŋ atac ŋayham atu, bu Anötö to mac nem ŋaê sa yêc undambê.” ");
INSERT INTO buk_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Têŋ ndoc dinaŋ Ŋalau Dabuŋ gêm Yisu ahuc, ma iŋ tac ŋayham atu, ma sôm, “O Damaŋ, undambê ti nom ŋadau. Aö wampiŋ am bu am tôc nem yom ŋa-ŋandô asê têŋ lau naŋ sêŋgwiniŋ dau, ma siŋ kwi têŋ lau naŋ gauc gêm bu ŋac lau tigauc ma sêŋyalê gêŋ hoŋ. Aêc, Damaŋ, am kôm bocdinaŋ kêkuc am daôm nem atac whiŋ. ");
INSERT INTO buk_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Damaŋ kêŋ gêŋ hoŋ sip aö amaŋ. Lau daŋ sêŋyalê Atu dom, Damba tawasê kêyalê iŋ. Ma lau daŋ sêŋyalê Damba dom, tigeŋ iŋ ndê Atu kêyalê iŋ, ma lau naŋ Atu dau atac whiŋ bu tôc iŋ asê têŋ ŋac, naŋ sêŋyalê Damba.” ");
INSERT INTO buk_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ma iŋ kac dau kwi ma sôm têŋ iŋ ndê ŋgacsêŋomi tawasê, “Atac ŋayham tu mac alic gêŋ hoŋ dindec-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Aö wasôm têŋ mac bu propet ti kiŋ daêsam atac whiŋ bu sêlic gêŋ naŋ mac alic su, magoc sêlic dom. Ma ŋac atac whiŋ bu sêŋgô yom naŋ mac aŋgô su, magoc sêŋgô dom.” ");
INSERT INTO buk_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Têŋ ndoc daŋ gwalam akwa yomsu-ŋga daŋ tisa bu êŋsahê Yisu. Ma iŋ ndac Yisu bocdec bu, “Kêdôhôŋwaga, aö wakôm sake, dec Anötö oc kôc aö sa wambo taŋli ŋapaŋ yêc undambê?” ");
INSERT INTO buk_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ma Yisu sôm, “Am kêyalê yomsu hoŋ naŋ Anötö kêŋ têŋ Moses. Ma yomsu dau sôm bu am kôm sake?” ");
INSERT INTO buk_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Goc ŋgac dau sôm, “Yomsu daŋ sôm bu, ‘Atac whiŋ Pômdau, am nem Anötö, ti am nem ŋalôm sambuc, ti gatôm sambuc, ti licwalô sambuc ma ti am nem gauc sambuc.’ Ma yomsu daŋ tiyham sôm bu, ‘Atac whiŋ lau meŋpaŋ am, tôm am tac whiŋ am daôm.’” ");
INSERT INTO buk_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ma Yisu sôm, “Am sôm solop. Kôm bocdinaŋ, dec am oc ndöc tamli ŋapaŋ.” ");
INSERT INTO buk_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Magoc ŋgac dau gauc gêm bu tôc asê bu iŋ ŋgac gitêŋ, dec ndac Yisu, “Ma lau asa sêti aneŋ lau meŋpaŋ aö-ŋga?” ");
INSERT INTO buk_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yisu ô iŋ ndê yom ŋa yom gôliŋ daŋ bocdec bu, “Ŋgac Israel-ŋga daŋ kêsêlêŋ mbo seŋ akêŋ Jerusalem ma bu sip têŋ malac Jeriko ndi, ma lau kaŋ sêkôc iŋ dôŋ. Ŋac sêkôc iŋ ndê ŋakwê su, sic iŋ tisac e kêpiŋ bu mbac ndu, goc sêhu iŋ siŋ yêc ma sêlhö si. ");
INSERT INTO buk_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tiŋambu dabuŋsiga Israel-ŋga daŋ kêsêlêŋ mbo seŋ tigeŋ dinaŋ meŋ, ma têŋ ndoc iŋ gêlic ŋgac dau, naŋ kêlêc iŋ ma kölhö gi. ");
INSERT INTO buk_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Malô goc ŋgac Israel-ŋga daŋ akêŋ †Liwai ndê toŋ meŋ hôc asê, gêlic ŋgac dau, ma kêlêc iŋ ma kêsêlêŋ gi. ");
INSERT INTO buk_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tiŋambu ŋgac Samaria-ŋga daŋ kêsêlêŋ mbo seŋ dinaŋ, meŋ hôc asê, goc gêlic ŋgac dau ma tawalô iŋ. ");
INSERT INTO buk_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Iŋ têŋ iŋ gi, kêgwasiŋ iŋ ndê gamboc ŋa olib ŋakwi ti wain, goc kêpaŋ. Ma iŋ kêŋ iŋ ndöc iŋ ndê doŋki ŋahô, kôc iŋ sa gi sôc andu ŋacleŋ-ŋga daŋ, ma yob iŋ. ");
INSERT INTO buk_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Galaŋsê bêbêc iŋ kêŋ mone denarii lu têŋ andu ŋadau, ma sôm, ‘Nem yaom ŋgac dindec. Ma mone dindec bu nditôm dom, goc wakêŋ mone ŋatô tiyham têŋ ndoc aö wambu wameŋ.’” ");
INSERT INTO buk_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ma Yisu ndac, “Am gauc gêm bocke? Lau tö dinaŋ si asa iŋ ŋgac naŋ sip lau kaŋ si amba, naŋ ndê ŋgac meŋpaŋ iŋ-ŋga?” ");
INSERT INTO buk_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Goc ŋgac yomsu-ŋga sôm, “Ŋgac dê, naŋ tawalô iŋ.” Ma Yisu sôm, “Am ndi ma kôm bocdinaŋ. Tamwalô lau hoŋ ma nem ŋac sa.” ");
INSERT INTO buk_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yisu ti ndê ŋgacsêŋomi sêŋsêlêŋ si e sêhôc asê malac daŋ. Ma awhê daŋ, naŋ ndê ŋaê Mata, kêgalêm Yisu bu neŋ gêŋ yêc iŋ ndê andu. ");
INSERT INTO buk_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Têŋ ndoc Yisu sôc gi ndöc, naŋ Mata ndê asiwê Maria ndöc sic kêpiŋ Pômdau gahi-ŋga, bu ŋgô iŋ ndê yom. ");
INSERT INTO buk_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Tigeŋ Mata kôm gweleŋ atu tu ndê gêŋ-ŋga. Iŋ têŋ Yisu meŋ ma ndac, “Pômdau, aö taŋwasêŋ gakôm gweleŋ gambo! Aö asiŋwê lec gêm aö sa dom, ma am gêlic ŋayham, me? Sôm bu iŋ nem aö sa.” ");
INSERT INTO buk_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Magoc Yisu ô iŋ ndê yom ma sôm, “Mata, Mata, am hêgo daôm tu gêŋ daêsam-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Magoc lau hoŋ sêpônda gêŋ atu tigeŋ. Maria tac whiŋ gêŋ ŋayham dau, ma lau daŋ oc sêtôm dom bu sêkôc su yêc iŋ.” ");
INSERT INTO buk_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Têŋ bêc daŋ Yisu teŋ mbec mbo gameŋ daŋ. Iŋ teŋ mbec pacndê, ma iŋ ndê ŋgac-sêŋom daŋ sôm têŋ iŋ, “Pômdau, tôm Jon kêdôhôŋ iŋ ndê sêŋomi, dec êmdôhôŋ yac bu ateŋ mbec.” ");
INSERT INTO buk_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ma Yisu sôm, “Têŋ ndoc mac bu ateŋ mbec, naŋ ateŋ bocdec bu: Damaŋ, am nem ŋaê lau sênem dabuŋ maŋ. Mweŋ ti lau hoŋ si Pômdau. ");
INSERT INTO buk_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tôm bêc hoŋ kêŋ yac mba gö têŋ yac. ");
INSERT INTO buk_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Suc yac mba sac kwi, bu lau hoŋ naŋ sêkôm sac têŋ yac, naŋ asuc si sac ŋatôp kwi bocdinaŋ. Ma yob yac bu lêtôm tap yac sa dom.” ");
INSERT INTO buk_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Ma iŋ gic têku yom ma sôm, “Akôc gauc pi mac daôm nem lêŋ naŋ ateŋ gêŋ têŋ nem dawami. Mboe am nem ŋacleŋ seŋ baliŋ-ŋga daŋ meŋ hôc asê têŋ ôbwêc, ma am pônda gêŋ daneŋ-ŋga bu kêŋ têŋ iŋ. Ma têŋ timaniŋhu am bu têŋ am nem dawam daŋ ndi, ma sôm têŋ iŋ, ‘Oê dawaŋ, kêŋ gö ŋatô têŋ aö bu wakêŋ têŋ aö neŋ silip naŋ kwahic dec meŋ hôc asê.’ ");
INSERT INTO buk_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Am gauc gêm bocke? Am dawam dinaŋ oc ô nem yom yêc andu ŋalôm ma sôm, ‘Kêŋ ŋawapac têŋ aö dom! Aö gac gatam ahuc su, ma aneŋ balêkoc sêyêc bêc su. Gitôm dom bu watisa ma wakêŋ gêŋ daŋ têŋ am!’ Iŋ oc sôm bocdinaŋ, a? ");
INSERT INTO buk_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Aö wasôm têŋ am, bu am nem dawam oc tisa ma kêŋ gêŋ têŋ am, magoc iŋ oc kêŋ tu am dawam iŋ-ŋga dom. Iŋ oc kêŋ gêŋ têŋ am tôm am ndac, ŋahu bu am pônda daôm ma mayam pac tu ndac iŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Bocdinaŋ aö wasôm têŋ mac. Ateŋ gêŋ têŋ Anötö, dec oc akôc ŋandô, aŋsalê iŋ ti ndê lêŋ, ma oc atap sa, ma amati gatam, dec oc lêc su têŋ mac. ");
INSERT INTO buk_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bu Anötö kêŋ gêŋ têŋ lau hoŋ naŋ sêndac iŋ, ma lau hoŋ naŋ sêŋsalê iŋ ti ndê lêŋ, naŋ oc sêtap sa, ma ŋac naŋ sêmati gatam, naŋ oc lêc su têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Damba daŋ, bu atuŋgac teŋ i, dec oc kêŋ mboc wêm daŋ têŋ iŋ dom. ");
INSERT INTO buk_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ma atuŋgac bu ndac mbac ŋ agulu, goc damba oc kêŋ gapiŋgap têŋ iŋ dom. ");
INSERT INTO buk_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mac lau sac, tigeŋ atoc nem balêkoc sa ŋa gêŋ ŋayham-ŋayham. Magoc Damam naŋ mbo undambê iŋ gitêŋ eŋ, ma oc kêŋ Ŋalau Dabuŋ têŋ lau naŋ sêteŋ iŋ.” ");
INSERT INTO buk_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Têŋ ndoc daŋ Yisu soc ŋalau sac awha mba daŋ su yêc ŋgac daŋ. Têŋ têm ŋalau sac hu ŋgac awha mba dau siŋ, naŋ ŋgac dau gic hu sôm yom asê, ma lau toŋ atu naŋ sêlic, naŋ sêhêdaê. ");
INSERT INTO buk_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","16","Lau ŋatô bu sêŋsahê Yisu, dec sêndac iŋ bu kôm gêŋ dalô daŋ bu tôc asê bu iŋ kôc ŋaclai yêc Anötö ndê. Ma lau ŋatô sêsôm, “Ŋalau sac si ŋadau †Belsebal kêŋ ŋaclai têŋ Yisu, ma bocdinaŋ iŋ soc ŋalau sac su.” ");
INSERT INTO buk_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yisu kêyalê ŋac si gauc, ma sôm, “Lau gameŋ daŋ bu sêwhê dau kôc, dec ŋac si ŋacyo oc sêseŋ ŋac su. Ma gôlôwac daŋ bu sêwhê dau kôc, dec ŋac oc sêlhac ŋaŋga dom, ma ŋac si ŋacyo oc sêku ŋac dulu. ");
INSERT INTO buk_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ma Sadaŋ boc-dinaŋ. Iŋ bu kêŋ kisa iŋ ndê ŋalau sac, dec iŋ ndê gôliŋ oc niŋga. Bocke dec mac asôm bu aö gasoc ŋalau sac su ŋa Belsebal ndê ŋaclai. ");
INSERT INTO buk_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mac asôm bu aö gakôc ŋaclai yêc Belsebal, dec gasoc ŋalau sac su. Ma bocke? Mac nem sêŋomi naŋ sem gweleŋ sêsoc ŋalau sac-ŋga sêwhiŋ, naŋ mac aŋgôliŋ yom dau pi ŋac whiŋ, a? Ŋac oc sêlic mac nem yom bu so ma sêmatôc mac! ");
INSERT INTO buk_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Aö gasoc ŋalau sac ŋa Anötö ndê ŋaclai, bocdinaŋ aŋyalê bu Anötö ndê ŋaclai bu nem gôliŋ gêŋ hoŋ, naŋ hôc asê mac su. ");
INSERT INTO buk_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Sadaŋ iŋ gitôm ŋgac ti licwalô atu naŋ kôc iŋ ndê wapa siŋ-ŋga, ma yob iŋ ndê andu. Oc tôm dom bu lau sêŋgaho ŋgac kaiŋ dinaŋ ndê gêŋ daŋ. ");
INSERT INTO buk_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tigeŋ ŋgac ti licwalô atu naŋ hôc gêlêc iŋ ndê bu ndic siŋ têŋ iŋ ma ku iŋ dulu, dec iŋ oc kôc iŋ ndê wapa siŋ-ŋga su, ma whê iŋ ndê wapa hoŋ kôc. ");
INSERT INTO buk_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Asa naŋ kalhac whiŋ aö dom, naŋ ti aneŋ ŋacyo. Ma asa naŋ gic lau sa sêtêŋ aö sêmeŋ dom, naŋ soc ŋac su yêc aö.” ");
INSERT INTO buk_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Têŋ ndoc ŋalau sac daŋ sa yêc ŋamalac daŋ, naŋ gitôm iŋ kêgihi mbo gameŋ sawa ma kêsalê mala êŋwhaŋ dau-ŋga. Tigeŋ têŋ ndoc iŋ tap sa dom, naŋ iŋ oc sôm têŋ dau, ‘Aö wambu wandi wasôc andu naŋ aö gahu siŋ su.’ ");
INSERT INTO buk_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ma iŋ oc mbu ndi, ma tap sa bu ŋamalac dau ndê ŋalôm yêc ŋambwa, gitôm andu sawa naŋ sêmasaŋ ŋawasi sa. ");
INSERT INTO buk_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Dec iŋ oc sa ndi, kôc ŋalau sac 7 naŋ sac sambuc sêhôc gêlêc iŋ su, naŋ sêmeŋ, ma ŋac hoŋ oc sêsôc andu dinaŋ sêndi ma sêmbo dinaŋ. Bocdinaŋ ŋawapac naŋ tap ŋamalac dau sa, naŋ hôc gêlêc ŋawapac ŋamata-ŋga-ŋga su.” ");
INSERT INTO buk_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yisu sôm yom dinaŋ, ma awhê daŋ yêc lau toŋ atu ŋalôm ta yom ma sôm, “Am dinam naŋ kôc am ma kêŋ su am, naŋ tap Anötö ndê mwasiŋ sa su.” ");
INSERT INTO buk_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ma Yisu sôm, “Lau naŋ sêŋgô Anötö ndê yom ma sêkôc sa ti daŋga wambu, naŋ oc sêtap Anötö ndê mwasiŋ sa hôc gêlêc su.” ");
INSERT INTO buk_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Lau daêsam naŋ sêmbo sêwhiŋ Yisu, naŋ si toŋ kêsôwec ŋapaŋ. Ma iŋ sôm, “Lau têm dindec-ŋga ŋac lau sac. Sêndac gêŋ dalô, magoc Anötö oc tôc gêŋ dalô tigeŋ têŋ ŋac, tôm gêŋ dalô naŋ iŋ kôm pi Jona. ");
INSERT INTO buk_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Anötö kêkiŋ Jona têŋ lau Ninewa gitôm gêŋ dalô daŋ, ma ŋalêŋ tigeŋ gêŋ naŋ oc hôc asê Ŋamalac ndê Atu, naŋ oc ti lau têm dindec-ŋga si gêŋ dalô. ");
INSERT INTO buk_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Muŋ-ŋga, Kwin Siba-ŋga kêsêlêŋ seŋ baliŋ, bu ŋgô Kiŋ Solomon ndê yom ti gauc atu-tu. Ma kwahic dec ŋgac naŋ hôc gêlêc Solomon su mbo dec, tigeŋ lau têm dindec-ŋga sêpu iŋ ndê yom. Tu dinaŋ-ŋga, kwin dau oc tisa akêŋ lau batê têŋ ndoc Anötö oc êmatôc lau, ma iŋ oc hoc lau têm dindec-ŋga si sac asê. ");
INSERT INTO buk_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ma ŋalêŋ tigeŋ, têŋ bêc ŋambu-ŋga lau Ninewa oc sêtisa sêwhiŋ lau têm kwahic dec-ŋga, ma ŋac oc sêhoc lau dindec si sac asê. Ŋahu bu lau Ninewa sêŋgô Jona ndê yom ma sem si ŋalôm kwi. Ma kwahic dec, ŋgac naŋ hôc gêlêc Jona su mbo dec, tigeŋ lau kwahic dec-ŋga sem dau kwi dom.” ");
INSERT INTO buk_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Yac datuŋ lam asê tu bu dasiŋ kwi me taŋgatöc ŋa suc ahuc dom. Mba! Dakêŋ êŋgalêŋ lhu, bu lau naŋ sêsôc sêmeŋ naŋ sêlic ŋawê. ");
INSERT INTO buk_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Am nem tanôm gitôm ya ŋawê naŋ tôc seŋ têŋ am. Bocdinaŋ am nem tanôm bu wê am sa lêŋ ŋayham, dec am oc gacgeŋ mbo ŋawê ŋalôm. Magoc tanôm bu wê am sa lêŋ sac-ŋga, dec am gacgeŋ mbo ŋasec ŋalôm. ");
INSERT INTO buk_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tu dinaŋ-ŋga dec yob daôm ŋapep bu ŋawê naŋ yêc nem ŋalôm, naŋ mbac e ŋasec sa dom. ");
INSERT INTO buk_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ma am bu sap lêŋ ŋawê-ŋga dôŋ ŋapaŋ, ma ndic ahê lêŋ ŋasec-ŋga, dec ŋawê oc nem am nem ŋalôm sambuc ahuc, tôm lam daŋ pô am.” ");
INSERT INTO buk_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yisu gic bata yom dinaŋ su, goc Palêsai daŋ kêgalêm iŋ bu neŋ gêŋ whiŋ iŋ. Yisu sôc ŋgac dau ndê andu gi ma ndöc sic ndöc tebo. ");
INSERT INTO buk_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ma Palêsai dau hêdaê bu Yisu gêŋ gêŋ magoc kêgwasiŋ amba muŋ su dom. ");
INSERT INTO buk_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Goc Pômdau sôm têŋ iŋ, “Mac lau Palêsai atôm laclhu ti pele naŋ sêŋgwasiŋ ŋadômbwê-ŋga ŋawasi sa, magoc ŋalôm ŋadômbwi yêc dôŋ yêc. Bu mêtê tamgatu gêŋ ma mêtê sac hôc mac nem ŋalôm ahuc. ");
INSERT INTO buk_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mac lau gauc mbasi-ŋga. Anötö naŋ kêmasaŋ ŋamalac ŋamlic ti gêŋ awê-ŋga naŋ kêmasaŋ ŋalôm-ŋga whiŋ. ");
INSERT INTO buk_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tamwalô lau ŋalôm sawa, ma akêŋ nem ŋalôm sambuc tu anem ŋac sa-ŋga, ma bocdinaŋ dec mac nem ŋamlic ti ŋalôm whiŋ oc ŋawasi sa yêc Anötö aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Oyaê. Mac lau Palêsai awhê nem gêŋ ôm-ŋga sauŋ-sauŋ hoŋ kôc ti toŋ amaŋlu, ma akêŋ toŋ tigeŋ ti da têŋ Anötö. Mac akôm gêŋ sauŋ dinaŋ, tigeŋ mac ahu gêŋ atu siŋ. Mac amatôc lau si yom ŋapep dom, ma atac whiŋ Anötö su dom. Gêŋ sauŋ naŋ mac akôm, iŋ ŋayham, magoc akôm yêc gêŋ atu-tu whiŋ bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Oyaê. Mac lau Palêsai atac whiŋ bu andöc lau tiwaê si pôŋ yêc lôm wê-ŋga, ma atac whiŋ bu lau sêtoc mac sa atôm lau tiwaê yêc malac lôm. ");
INSERT INTO buk_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Oyaê. Tu mêtê sac naŋ hôc mac nem ŋalôm ahuc, dec mac atôm nom naŋ sêŋsuhuŋ ŋgac batê daŋ yêc ŋalôm, ma lau sêŋyalê dom ma sêŋsêlêŋ sêmbo ŋahô.” ");
INSERT INTO buk_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Gwalam akwa yomsu-ŋga daŋ ŋgô Yisu ndê yom dinaŋ ma sôm, “Kêdôhôŋwaga, am sôm yom dinaŋ pi lau Palêsai, ma am pu yac lau yomsu-ŋga whiŋ.” ");
INSERT INTO buk_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ma Yisu sôm, “Oyaê. Mac lau yomsu-ŋga akêŋ yomsu daêsam têŋ lau naŋ kêŋ wapac ŋac ŋandô, tigeŋ mac daôm akôm gêŋ daŋ bu anem ŋac sa tu sêhôc ŋawapac dinaŋ-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Oyaê. Mac amasaŋ sêhô bu atoc propet akwa-kwa sa, magoc mac daôm apami sic propet dau ndu. ");
INSERT INTO buk_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Bocdinaŋ mac atôc asê bu mac alic gêŋ naŋ apami sêkôm, naŋ bu ŋayham. ");
INSERT INTO buk_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Anötö kêyalê gêŋ hoŋ, dec hoc yom asê gwanaŋ pi mac apami bocdec bu, ‘Aö waŋkiŋ lau propet ma lau aposel sêtêŋ ŋac sêndi, magoc ŋac oc sêndic propet ŋatô ndu, ma sêkôm mêtê sac têŋ ŋatô.’ ");
INSERT INTO buk_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Bocdinaŋ mac lau têm dindec-ŋga oc awêkaiŋ ŋagêyô awhiŋ apami, tu propet hoŋ si dac naŋ sêkêc siŋ-ŋga, têŋ têm ŋamata-ŋga andô e meŋ. ");
INSERT INTO buk_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Aêc, Abel iŋ ŋgac ŋamata-ŋga, ma Sekaria iŋ ŋgac ŋambu-ŋga, propet naŋ ŋac sic ndu yêc lôm dabuŋ, ma alta naŋ kalhac lôm dabuŋ ŋasactô, naŋ ŋalhu. Aêc, aö wasôm têŋ mac, lau têm kwahic dec-ŋga oc sêtap matôc sa pi lau hoŋ dinaŋ si dac. ");
INSERT INTO buk_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Oyaê. Lau daêsam takwê mac gwalam akwa yomsu-ŋga bu awhê Anötö ti ndê lêŋ sa têŋ ŋac, magoc mac am ŋac sa ŋapep dom. Mac atôm lau naŋ sêyob ki gatam-ŋga, ma sêtec bu sêkac sa têŋ lau naŋ bu sêsôc sêndi. Mac daôm aŋyalê Anötö ti asôc iŋ ŋapu dom, ma mac alhac lau naŋ bu sêŋyalê iŋ ti sêsôc iŋ ŋapu, naŋ ahuc.” ");
INSERT INTO buk_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yisu gic bata yom dinaŋ ma hu andu dau siŋ. Ma lau Palêsai ti lau naŋ sêndôhôŋ yomsu, naŋ sic hu sêkêŋ kisa iŋ ŋandô. Ŋac sêndac iŋ pi gêŋ daêsam, ");
INSERT INTO buk_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","sêŋsahê bu sêtim iŋ bu sôm yom giso, dec oc tôm bu sêmatôc iŋ. ");
INSERT INTO buk_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Têŋ têm dinaŋ lau daêsam andô, tausen ma t ausen, sêkôm mwasac bu sêtigasuc Yisu e sêŋgapiŋ dau sa. Ma Yisu sôm yom têŋ iŋ ndê ŋgacsêŋomi bocdec bu, “Ayob daôm ŋapep bu lau Palêsai si mêtê sac lom mac dom. Ŋac sêsôm yom ŋayham magoc ŋac dau sêkôm ŋandô sa dom. Mêtê dau gitôm yist naŋ tôm bu nem bolom ahuc ŋagahô eŋ. ");
INSERT INTO buk_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Gêŋ hoŋ naŋ lau sem ahuc, ma gêŋ hoŋ naŋ yêc siŋ dau, naŋ oc meŋ sa tiawê. ");
INSERT INTO buk_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yom bocke naŋ mac asôm têŋ daôm têŋ ôbwêc, naŋ lau oc sêŋgô têŋ acsalô. Ma yom naŋ mac asôm malô têŋ daôm yêc andu ŋalôm, naŋ oc sêsôm asê yêc malac lôm. ");
INSERT INTO buk_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Aneŋ lau mac aŋgô. Atöc lau naŋ bu sêndic mac ndu-ŋga dom, bu tiŋambu ŋac sêtôm dom bu sêkôm gêŋ daŋ tiyham têŋ mac. ");
INSERT INTO buk_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tigeŋ aö wasôm têŋ mac bu atöc Anötö, ma asôc iŋ ŋapu. Bu têŋ ndoc mac ambac ndu su, iŋ ndê ŋaclai yêc bu tuc mac asip lambwam andi. Aêc, aö wasôm têŋ mac, atöc iŋ! ");
INSERT INTO buk_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Akôc gauc pi mbac kecsoc naŋ lau sêlic bu gêŋ ŋambwa. Tigeŋ Anötö oc êŋlhiŋ ŋac si daŋ siŋ dom. ");
INSERT INTO buk_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ma Anötö tac whiŋ mac hôc gêlêc mbac sauŋ-sauŋ daêsam su. Yomandô! Anötö kêyalê mac e pi sa, gitôm iŋ sê mac nem kêclauŋ hoŋ sa timala. Bocdinaŋ atöc daôm dom. ");
INSERT INTO buk_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Aö wasôm têŋ mac bu asa naŋ sôm asê yêc lau aŋgô-ŋga bu iŋ kêŋ whiŋ aö, naŋ Ŋamalac ndê Atu oc sôm ŋamalac dau ndê ŋaê asê yêc Anötö ndê aŋela aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tigeŋ asa naŋ sêc iŋ ndê kêŋ whiŋ aö-ŋga ahuc yêc lau aŋgô-ŋga, naŋ Ŋamalac ndê Atu oc sêc iŋ ahuc yêc Anötö ndê aŋela aŋgô-ŋga bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Asa naŋ bu sôm yom sac pi Ŋamalac ndê Atu, tigeŋ tiŋambu kac ndê ŋalôm kwi, naŋ Anötö oc suc iŋ ndê sac kwi. Tigeŋ asa naŋ sôm yom sac sambuc pi Ŋalau Dabuŋ, naŋ Anötö oc suc iŋ ndê sac kwi dom. ");
INSERT INTO buk_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Tiŋambu lau oc sêkôc mac dôŋ tu mac akêŋ whiŋ aö-ŋga. Ŋac oc sêwê mac atêŋ lau bata Israel-ŋga andi, bu sêmatôc mac yêc ŋac si lôm wê-ŋga. Ma ŋac oc sêkêŋ mac alhac gôliŋwaga ma lau ti ŋaclai aŋgô-ŋga bocdinaŋ. Têŋ ndoc dinaŋ, ahêgo daôm tu yom asôm ma aô têŋ ŋac-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Bu Ŋalau Dabuŋ oc êndôhôŋ mac ma kêŋ yom têŋ mac tu asôm-ŋga têŋ ndoc dinaŋ.” ");
INSERT INTO buk_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ŋgac daŋ yêc lau toŋ atu dinaŋ ŋalôm ndac Yisu bocdec bu, “Kêdôhôŋwaga, sôm têŋ aö dôwaŋ bu whê damaŋ ndê wapa lêŋsêm kôc ma kêŋ ŋatô têŋ aö.” ");
INSERT INTO buk_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Magoc Yisu sôm, “Am ŋgô su naŋ. Anötö kêyaliŋ aö sa ti am nem ŋgac êmatôc yom-ŋga me ŋgac whê wapa kôc-ŋga dom.” ");
INSERT INTO buk_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Goc iŋ sôm têŋ lau hoŋ, “Ayob daôm ŋapep bu tamgatu wapa nom-ŋga dom. Bu ŋamalac si ŋahu sêmbo tali-ŋga sip awa ti wapa daêsam naŋ sic sa-ŋga, naŋ dom.” ");
INSERT INTO buk_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ma iŋ sôm yom gôliŋ daŋ têŋ ŋac bocdec bu, “Ŋgac ti lêlôm daŋ mbo, ma gêŋ naŋ iŋ sô yêc ndê nom gêm ŋandô daêsam andô. ");
INSERT INTO buk_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Dec iŋ gauc gêm têŋ dau, ‘Aö wakôm sake? Aneŋ andu wakêŋ gêŋ ŋandô sôc-ŋga oc nditôm dom.’ ");
INSERT INTO buk_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Bocdinaŋ dec iŋ sôm, ‘Aö wakôm gêŋ bocdec. Aö waseŋ andu akwa-kwa hoŋ su, ma wakwê andu wakuc ŋatô naŋ atu andô. Ma yêc dinaŋ, aö wandic aneŋ gêŋ ŋandô ti wapa hoŋ sa. ");
INSERT INTO buk_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ma aö wasôm têŋ dauŋ, “Aö gac gêŋ ŋayham daêsam sa, gitôm bu oc wambo yala daêsam. Aö waŋwhaŋ dauŋ, ma waneŋ ti wanôm gêŋ ma watisambuc.” ’ ");
INSERT INTO buk_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Magoc Anötö sôm têŋ iŋ, ‘Am ŋgac gauc mbasi-ŋga! Ôbwêc dec am oc mbwac ndu. Ma wapa naŋ am gic sa tu daôm-ŋga, naŋ oc ti asa ndê?’” ");
INSERT INTO buk_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Goc Yisu sôm, “Lau hoŋ naŋ sic wapa daêsam sa tu dau-ŋga, magoc sêmbo sêtôm lau ŋalôm sawa tu sêŋyalê Anötö ti ndê mêtê dom-ŋga, naŋ lau gauc mbasi-ŋga bocdinaŋ.” ");
INSERT INTO buk_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ma Yisu sôm têŋ iŋ ndê ŋgacsêŋomi, “Bocdinaŋ dec aö wasôm têŋ mac, ahêgo daôm tu gêŋ aneŋ-ŋga, me tu ŋakwê asôc-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bu Anötö kêŋ mac ambo tamli, ma gêŋ dinaŋ iŋ gêŋ atu. Gêŋ daneŋ-ŋga iŋ gêŋ atu dom. Ma Anötö kêŋ mac nem ŋamlic ŋagêŋ hoŋ. Dinaŋ iŋ gêŋ atu, ma ŋakwê asôc-ŋga iŋ gêŋ atu dom. ");
INSERT INTO buk_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Akôc gauc pi mbac ko. Ŋac sêsô gêŋ dom, ma sic gêŋ ŋandô sa dom. Ŋac si andu gêŋ ŋandô-ŋga mbasi, tigeŋ Anötö gôlôm ŋac. Ma Anötö tac whiŋ mac ŋamalac hôc gêlêc mbac hoŋ su. ");
INSERT INTO buk_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ma mac nem asa, bu hêgo dau dec oc tôm bu ndic têku ndê têm mbo tali-ŋga? ");
INSERT INTO buk_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mac atôm dom bu akôm gêŋ sauŋ andô dinaŋ, bocdinaŋ tu sake-ŋga mac ahêgo daôm pi gêŋ ŋatô? ");
INSERT INTO buk_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ma akôc gauc pi ŋaola ŋayham naŋ sêpo sêlhac kwaŋ ŋalôm. Sêkôm gweleŋ dom, ma sêmasaŋ ŋakwê dom, tigeŋ aö wasôm têŋ mac, bu Kiŋ Solomon iŋ sôc ŋakwê ŋayham andô, magoc iŋ ndê gôlôŋ ti ŋawasi hôc gêlêc ŋaola dinaŋ daŋ su dom. ");
INSERT INTO buk_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","O mac lau naŋ akêŋ whiŋ gwalec, aŋgô! Kwaŋ ti ŋaola nom-ŋga sêlhac bêc daêsam dom, ma lau oc sêkêŋ ya neŋ su, magoc Anötö kêŋ gêŋ dau ti ŋadalô ŋayham ma yob ŋapep. Ma bocdinaŋ, aŋyalê bu yom ŋandô, Anötö oc yob mac ma kêŋ ŋakwê têŋ mac whiŋ. ");
INSERT INTO buk_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ahêgo daôm pi gêŋ aneŋ ti anôm-ŋga dom, ma ambo ti ŋalôm ŋawapac dom. ");
INSERT INTO buk_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Lau sambuc naŋ sêŋyalê Anötö dom, naŋ sêhêgo dau pi gêŋ kaiŋ dinaŋ ŋapaŋ, magoc Damam undambê-ŋga kêyalê su bu mac apônda gêŋ dau. ");
INSERT INTO buk_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ahêgo daôm tu gêŋ dinaŋ-ŋga dom, magoc akôm ŋaŋga bu atap malam sa yêc Anötö ndê gôliŋ ŋapu. Ma iŋ oc yob mac tu gêŋ nom-ŋga-ŋga whiŋ. ");
INSERT INTO buk_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","O aneŋ lau, atöc daôm dom. Bu mac nem Damam undambê-ŋga tac whiŋ bu ti mac nem Kiŋ ma kôc mac sa andöc iŋ ndê gôliŋ ŋapu.” ");
INSERT INTO buk_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","34","“Aö wasôm têŋ mac, bu gameŋ bocke naŋ mac nem awa yêc, naŋ mac oc ahê gauc pi ma atac whiŋ ŋapaŋ. Bocdinaŋ akêŋ nem wapa nom-ŋga têŋ lau sênemlhi, ma akêŋ nem awa tu anem lau ŋalôm sawa sa-ŋga. Ma apo gêŋ undambê-ŋga sa ti nem awa ŋandô, naŋ oc yêc ŋayham ŋapaŋ. Lau kaŋ oc sêtôm dom bu sênem kaŋ, ma gêŋ daŋ oc kôm tisac dom.” ");
INSERT INTO buk_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Amasaŋ daôm ŋapep. Ambo atôm lau akiŋ naŋ sêsôc ŋakwê gweleŋ-ŋga sa, ma sêtuŋ si lam asê ma sêhôŋ si ŋadau bu mbu meŋ akêŋ mwasiŋ nem awhê-ŋga. Têŋ ndoc ŋac si ŋadau mbu meŋ ma êmati gatam, naŋ ŋac oc sêkac gatam sa têŋ iŋ ŋagahô. ");
INSERT INTO buk_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ŋadau bu mbu meŋ ma tap lau akiŋ sa, naŋ sêmasaŋ dau gwanaŋ ma sêhôŋ iŋ sêmbo, dec ŋac oc sêtap mwasiŋ atu sa yêc iŋ. Aö wasôm yomandô, ŋadau dau oc meŋ, sôc ŋakwê tôm lau akiŋ sêsôc, kêŋ ŋac sêndöc tebo, ma nem akiŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ŋadau bu meŋ têŋ timaniŋhu me têŋ ôbwêc lôm, ma tap ŋac sa sem ali ma sêhôŋ iŋ sêmbo, dec iŋ oc êmwasiŋ ŋac êŋlêc. ");
INSERT INTO buk_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tigeŋ aŋgô su naŋ! Lau kaŋ sêkêŋ puc pi ndoc sêmeŋ-ŋga dom. Andu ŋadau daŋ, bu êŋyalê ndoc naŋ ŋgac kaŋ daŋ oc meŋ, dec iŋ oc yob iŋ ndê andu ŋapep bu ŋgac kaŋ dinaŋ sôc meŋ dom. ");
INSERT INTO buk_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ma mac bocdinaŋ, amasaŋ daôm ŋapep ma anem ali ŋapaŋ, bu Ŋamalac ndê Atu oc mbu meŋ têŋ ndoc naŋ mac akêŋ batam, naŋ dom.” ");
INSERT INTO buk_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Têŋ dinaŋ Pita sôm, “Pômdau, am sôm yom gôliŋ dinaŋ bu yac ŋgacsêŋomi aŋgô, me bu lau hoŋ sêŋgô?” ");
INSERT INTO buk_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ma Pômdau ô yom ma sôm, “Mac nem asa iŋ gitôm ŋgac akiŋ ŋayham ma ti gauc? Ŋgac akiŋ kaiŋ dinaŋ ndê ŋadau bu lhö têŋ gameŋ daŋ ndi, goc iŋ oc kêŋ iŋ yob lau akiŋ ŋatô ma kêŋ gêŋ daneŋ-ŋga têŋ ŋac tôm ŋandoc. ");
INSERT INTO buk_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ma têŋ ndoc ŋadau mbu meŋ ma tap iŋ sa kôm iŋ ndê gweleŋ ŋapep mbo, naŋ iŋ oc lic iŋ ŋayham ma kôm ŋayham têŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yomandô! Ŋadau oc kêŋ iŋ yob iŋ ndê wapa hoŋ. ");
INSERT INTO buk_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Magoc ŋgac akiŋ sac oc sôm têŋ dau, ‘Aneŋ ŋadau oc mbu meŋ ŋagahô dom.’ Goc iŋ oc ndic lau akiŋ ŋatô, ma neŋ gêŋ ŋawahô ti nôm wain e êŋiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ŋadau oc mbu meŋ hôc asê têŋ bêc ti acgatu naŋ ŋgac akiŋ dau kêŋ bata, naŋ dom. Ma iŋ oc kêŋ ŋagêyô sac sambuc têŋ iŋ, ma soc iŋ su ndi bu mbo whiŋ lau naŋ daŋgapêc ma sêkêŋ whiŋ dom. ");
INSERT INTO buk_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ŋgac akiŋ naŋ kêyalê gêŋ naŋ iŋ ndê ŋadau tac whiŋ bu iŋ kôm, tigeŋ tec bu kôm ma kêmasaŋ dau dom, naŋ oc tap ŋagêyô atu sa. ");
INSERT INTO buk_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Magoc ŋgac akiŋ naŋ kêyalê gêŋ naŋ ŋadau tac whiŋ bu iŋ kôm, naŋ dom, dec kôm mêtê sac naŋ gic waê bu iŋ tap ŋagêyô sa, naŋ oc kôc ŋagêyô sauŋ. Lau hoŋ naŋ sêtap mwasiŋ sa yêc Anötö, naŋ iŋ takwê ŋac bu sêkôm gweleŋ ŋa mwasiŋ dinaŋ e nem ŋandô. Ma ŋac naŋ sêtap mwasiŋ atu sa, naŋ iŋ takwê ŋandô daêsam.” ");
INSERT INTO buk_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ma Yisu gic têku yom ma sôm, “Aö gasip nom gameŋ bu wakêŋ ya êŋsahê lau nom-ŋga, ma aö atac whiŋ bu ya dau lom asê ŋagahô. ");
INSERT INTO buk_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Aö dauŋ oc wahôc ŋawapac ti ŋandê atu, naŋ gitôm busaŋgu kaiŋ daŋ tu waliŋ-ŋga. Ma aö wapô sim dauŋ ŋandô e gêŋ dau ŋandô sa. ");
INSERT INTO buk_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Gauc nem bu aö gameŋ bu wahê wamba lau dom. Mba! Tu aö-ŋga dec lau oc sêwhê dau kôc. ");
INSERT INTO buk_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Têŋ kwahic dec ma ndi, lau naŋ sêmbo andu daŋ, naŋ oc sêwhê dau kôc tu aö-ŋga. Lau amaŋdaŋ bu sêmbo, goc lu oc sêkêŋ kisa tö, ma tö oc sêkêŋ kisa lu. ");
INSERT INTO buk_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tu aö-ŋga dec ŋac oc sêwhê dau kôc. Damba lu atuŋgac oc sêkêŋ kisa dau, ma dinda lu atuwê oc sêkêŋ kisa dau. Ma lawawê akwa lu lawawê wakuc oc sêkêŋ kisa dau bocdinaŋ.” ");
INSERT INTO buk_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ma Yisu sôm têŋ lau toŋ atu, “Mac bu alic dao yec sambuc daŋ puc pi meŋ, dec mac asôm bu u oc ndic, ma u gic. ");
INSERT INTO buk_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma muasa bu êŋsêlêŋ, dec mac asôm bu gameŋ oc ŋandê sa, ma gameŋ ŋandê sa. ");
INSERT INTO buk_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mac lau atim yom lau-ŋga! Mac alic gêŋ dalô nom-ŋga ti umboŋ-ŋga ma mac atôm bu aŋyalê ndoc. Ma bocke dec mac alic gêŋ hoŋ naŋ aö gakôm yêc nom, magoc mac nem gauc sa pi aö neŋ ŋahu lec dom. ");
INSERT INTO buk_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Oc tôm bu mac aŋsahê gêŋ hoŋ tu bu aŋyalê lêŋ bocke iŋ lêŋ gitêŋ, magoc tu sake-ŋga mac akôm dom? ");
INSERT INTO buk_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Aŋgô! Am asa naŋ nem tôp bu yêc ŋamalac daŋ, ma iŋ bu wê am têŋ ŋgac êmatôc yom-ŋga, naŋ goc êmsahê bu êmasaŋ yom whiŋ iŋ têŋ ndoc amlu aŋsêlêŋ ambo seŋ. Ma bocdinaŋ ŋgac dau oc kêŋ am têŋ ŋgac êmatôc yom-ŋga dom. Bu mba, mboe ŋgac êmatôc yom-ŋga o c kêŋ am têŋ ŋgac yob gapocwalô-ŋga, ma iŋ oc kêŋ am sôc gapoc-walô ndi. ");
INSERT INTO buk_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Aö wasôm têŋ am bu am oc ndöc gapocwalô ŋapaŋ e am ndic nem tôp hoŋ pacndê.” ");
INSERT INTO buk_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Têŋ ndoc dinaŋ lau ŋatô sêmbo sêwhiŋ Yisu, ma ŋac sic miŋ yom pi lau Galili-ŋga ŋatô. Lau dinaŋ sic domba ndu bu sêkêŋ ti da, ma gôliŋwaga Pailot ndê lau sêmeŋ ma sic ŋac ndu ma sêŋgaluŋ ŋac si dac whiŋ domba si dac. ");
INSERT INTO buk_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yisu ŋgô ŋac si yom dau, goc ndac, “Mac gauc gêm bocke? Lau Galili-ŋga dinaŋ si sac hôc gêlêc lau Galili-ŋga ŋatô si sac su, ma bocdinaŋ ŋawapac dinaŋ hôc asê ŋac, a? ");
INSERT INTO buk_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aö wasôm, mba! Tigeŋ mac bu anem nem ŋalôm kwi dom, dec mac oc andiŋam. ");
INSERT INTO buk_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Gauc nem andu baliŋ naŋ lau sêkwê yêc Siloam, naŋ ku sa ma sec lau 18. M ac gauc gêm bocke? Lau 18 dinaŋ si sac hôc gêlêc lau Jerusalem-ŋga si sac, a? ");
INSERT INTO buk_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aö wasôm têŋ mac, mba! Tigeŋ mac bu anem nem ŋalôm kwi dom, dec mac hoŋ oc andiŋam.” ");
INSERT INTO buk_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Goc Yisu sôm yom gôliŋ daŋ bocdec bu, “Yêc ŋgac daŋ ndê ôm wain-ŋga, a kiŋ daŋ kalhac. Ma ŋgac dau gi kêsalê a kiŋ ŋandô, magoc tap sa dom. ");
INSERT INTO buk_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Dec iŋ sôm têŋ ŋgac naŋ yob iŋ ndê ôm, ‘Tôm yala tö aö gameŋ kasalê ŋandô yêc a kiŋ dindec, ma gatap sa dom. Lêŋ dulu, bu a dau pôc gameŋ ahuc ma gêm ŋandô dom.’ ");
INSERT INTO buk_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tigeŋ ŋgac yob ôm-ŋga sôm, ‘Aneŋ ŋadau, hu siŋ lhac yala daŋ tiyham. Aö wandic gwelec ma wahôc nom pi ŋahu. ");
INSERT INTO buk_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Iŋ bu nem ŋandô têŋ yala wakuc, dec oc ŋayham. Ma bu nem ŋandô dom, naŋ goc am lêŋ dulu.’” ");
INSERT INTO buk_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Têŋ bêc Sabat-ŋga daŋ, Yisu kêdôhôŋ lau mbo lôm wê-ŋga daŋ. ");
INSERT INTO buk_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ma awhê daŋ mbo, naŋ ŋalau sac kôm iŋ ndöc bôliŋ tôm yala 18. Iŋ kêsêlêŋ kêŋköŋ ma gitôm dom bu iŋ lhac solop. ");
INSERT INTO buk_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yisu gêlic iŋ ma ta iŋ meŋ, goc sôm, “O awhê daôm, aö bu waseŋ gêŋ naŋ sô am dôŋ, naŋ su.” ");
INSERT INTO buk_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Goc Yisu kêŋ amba sac iŋ, ma ŋagahô iŋ kalhac tisolop, ma kêpiŋ Anötö. ");
INSERT INTO buk_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tigeŋ ŋgac bata naŋ yob lôm wê-ŋga dinaŋ, iŋ tac ŋandê bu Yisu kôm awhê dinaŋ ŋayham sa têŋ bêc Sabat-ŋga. Dec iŋ sôm têŋ lau, “Bêc 6 yêc bu danem gweleŋ. Mac bu atac whiŋ bu ŋayham sa, dec ameŋ têŋ bêc Sabat-ŋga dom. Ameŋ têŋ bêc 6 dinaŋ ŋadaŋ.” ");
INSERT INTO buk_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Magoc Pômdau ô iŋ ndê yom ma sôm, “Mac lau atim yom lau-ŋga. Mac hoŋ akôm gweleŋ têŋ bêc Sabat-ŋga têŋ ndoc mac ambwala nem doŋki ti makao su, ma awê ŋac sêsa si bu sênôm bu. ");
INSERT INTO buk_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Awhê dindec iŋ Abraham ndê apawê daŋ, ma Sadaŋ sô iŋ dôŋ tôm yala 18 su. Tu sake-ŋga dec tambwala iŋ su têŋ bêc Sabat-ŋga dom?” ");
INSERT INTO buk_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yisu ndê yom dau kôm iŋ ndê ŋacyo hoŋ maya atu. Tigeŋ lau daêsam atac ŋayham pi gêŋ ŋayham hoŋ naŋ iŋ kôm. ");
INSERT INTO buk_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ma Yisu ndac lau dinaŋ, “Anötö ndê gôliŋ kêsôwec ŋalêŋ bocke? Aö wanem dôhôŋ pi gêŋ sake bu wawhê sa? ");
INSERT INTO buk_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Anötö ndê gôliŋ gitôm ŋawhê sauŋ andô daŋ, gitôm a soc ŋawhê. Ŋgac daŋ kôc sa gi ma sô yêc ndê ôm, ma tiŋambu gêŋ dau po ti a atu, ma mbac lôlôc-ŋga sêmeŋ sêhê si ŋaic yêc ŋasaŋgac.” ");
INSERT INTO buk_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ma iŋ sôm yom gôliŋ daŋ tiyham bocdec bu, “Aö wanem dôhôŋ Anötö ndê gôliŋ pi gêŋ sake bu wawhê sa? ");
INSERT INTO buk_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Aö wanem dôhôŋ pi yist, naŋ awhê daŋ kêŋ sip plawa lôŋ atu daŋ ma kêgaluŋ. Ma ŋasawa sauŋ eŋ yist dinaŋ kôm plawa hoŋ suŋ.” ");
INSERT INTO buk_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tiŋambu Yisu kêsêlêŋ hêganôŋ Jerusalem gi. Iŋ golom-golom malac atu-tu ti sauŋ-sauŋ hoŋ, ma kêdôhôŋ lau. ");
INSERT INTO buk_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ma ŋamalac daŋ ndac iŋ, “Pômdau, Anötö oc kôc lau tigeŋ-tigeŋ sa sêndöc undambê, me lau daêsam?” Ma Yisu ô yom ma sôm têŋ lau, ");
INSERT INTO buk_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Lau daêsam oc sêŋsahê bu sêsôc gatam sêndi, magoc ŋac oc sêtôm dom, bu gatam dau sauŋ andô. Bocdinaŋ akôm ŋaŋga bu asôc gatam dau andi. ");
INSERT INTO buk_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Andu ŋadau bu tisa ma ndic gatam ahuc, dec mac oc alhac awê, amati gatam ma asôm, ‘Pômdau, lêc gatam su têŋ yac.’ Magoc iŋ oc sôm têŋ mac bu, ‘Mac lau dinaŋ ameŋ akêŋ nde? Aö kayalê mac dom.’ ");
INSERT INTO buk_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ma mac oc asôm, ‘Yac aŋ gêŋ ti anôm gêŋ awhiŋ am, ma am kêdôhôŋ lau yêc yac mba malac lôm.’ ");
INSERT INTO buk_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Tigeŋ iŋ oc sôm, ‘Mac lau dinaŋ ameŋ akêŋ nde? Aö kayalê mac dom. Alhö su yêc aö, mac lau akôm sac-ŋga!’ ");
INSERT INTO buk_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","29","Têŋ têm ŋambu-ŋga, mac oc alic Abraham, Aisak ma Jakob ti p ropet akwa-kwa hoŋ sêndöc Anötö ndê gameŋ undambê-ŋga. Ma lau oc sêmeŋ akêŋ nom ŋabatiŋ hoŋ, ma sêneŋ mwasiŋ atu yêc undambê. Magoc Anötö oc êmasuc mac su andi ambo gameŋ ahôc ŋandê-ŋga, ma yêc dinaŋ mac oc ataŋ, ma mac nem lhôm êŋsiŋ pi dau. ");
INSERT INTO buk_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Aŋgô su naŋ! Lau ŋatô naŋ kwahic dec sêti lau ŋambu-ŋga, naŋ oc sêti lau ŋamata-ŋga, ma lau ŋamata-ŋga oc sêti lau ŋambu-ŋga.” ");
INSERT INTO buk_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Têŋ ndoc dinaŋ lau Palêsai ŋatô sêtêŋ Yisu sêmeŋ ma sêsôm, “Hu gameŋ dindec siŋ ma lhö ndi, bu Herod tac whiŋ bu ndic am ndu.” ");
INSERT INTO buk_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Magoc Yisu sôm têŋ ŋac, “Mac andi asôm têŋ Herod, giam pôm dinaŋ, ‘Acsalô lec ma laŋsê aö oc wasoc ŋalau sac su, ma wakôm lau gêmbac ŋayham sa. Ma têŋ bêc titö-ŋga aö oc wandic dabiŋ aneŋ gweleŋ.’ ");
INSERT INTO buk_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Aö oc wakôm aneŋ gweleŋ tôm bêc ŋatô, ma tiŋambu aö watêŋ Jerusalem wandi. Mac lau Israel-ŋga ac propet daêsam ndu su yêc Jerusalem, ma bocdinaŋ dec aö gac waê bu wapi wandi wawhiŋ. ");
INSERT INTO buk_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Jerusalem, Jerusalem. Mac ac Anötö ndê lau propet ndu, ma lau gitêŋ naŋ iŋ kêkiŋ têŋ mac, naŋ mac atuc ŋa hoc ndu. Ndoc daêsam aö tac whiŋ bu wandic mac lau sa asôc Anötö ndê gôliŋ ŋapu tiyham, gitôm mbac dalec dinda gic ŋatu sa sôc ŋamakê ŋapu. Tigeŋ mac atec. ");
INSERT INTO buk_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Bocdinaŋ Anötö oc hu mac ti nem andu siŋ. Ma aö wasôm têŋ mac bu mac oc alic aö tiyham dom e mac asôm, ‘Tampiŋ Mesaya naŋ meŋ gêm Pômdau aŋgô.’” ");
INSERT INTO buk_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Têŋ bêc Sabat-ŋga daŋ, Yisu sôc ŋgac bata daŋ ndê andu gi bu neŋ gêŋ. Ŋgac bata dau iŋ lau Palêsai si daŋ, ma ŋac si lau ŋatô tatiŋ Yisu sêmbo. ");
INSERT INTO buk_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yisu gêlic ŋgac gêmbac daŋ ndöc, naŋ amba ti gahi suŋ. ");
INSERT INTO buk_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Goc iŋ ndac lau Palêsai ti gwalam akwa yomsu-ŋga bocdec bu, “Yac bu dakôm lau ŋayham sa têŋ bêc Sabat-ŋga, dec oc taŋgilì yomsu Sabat-ŋga, me mba?” ");
INSERT INTO buk_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ŋac sem dôŋ ma sêô yom daŋ dom, goc iŋ kêmasec ŋgac ti gêmbac dinaŋ, kôm iŋ ŋayham sa, ma kêŋ iŋ kölhö gi. ");
INSERT INTO buk_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ma iŋ ndac ŋac, “Mac nem balê daŋ me doŋki daŋ bu peŋ sip sê ŋalôm têŋ bêc Sabat-ŋga, dec mac oc akôm sake? Mac oc ahê iŋ sa pi meŋ, me ahu iŋ siŋ yêc?” ");
INSERT INTO buk_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ma ŋac sêtôm dom bu sêô iŋ ndê yom. ");
INSERT INTO buk_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yisu gêlic bu lau naŋ ŋgac bata dau kêgalêm ŋac sa bu sêneŋ gêŋ sêwhiŋ iŋ, naŋ atac whiŋ bu sêndöc pôŋ naŋ gic lau tiwaê ŋawaê. Dec iŋ sôm yom gôliŋ daŋ têŋ ŋac bocdec bu, ");
INSERT INTO buk_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Lau bu sêkêŋ aheŋ am bu neŋ mwasiŋ nem awhê-ŋga, naŋ ndi ndöc lau tiwaê si pôŋ dom. Mboe mwasiŋ ŋadau kêgalêm ŋgac tiwaê daŋ naŋ hôc gêlêc am su. ");
INSERT INTO buk_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Bu bocdinaŋ dec iŋ oc têŋ am meŋ ma sôm, ‘Kêŋ pôŋ ŋayham dindec têŋ ŋgac atu dindec.’ Ma am oc tisa ti mayam, ma ndi ndöc pôŋ ŋambwa. ");
INSERT INTO buk_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Boc-dinaŋ lau bu sêkêŋ aheŋ am bu neŋ mwasiŋ, naŋ ndi ma ndöc pôŋ ŋambwa. Ma mboe ŋadau oc meŋ ma sôm têŋ am, ‘Aneŋ silip, tisa ma mweŋ ndöc pôŋ ŋayham.’ Ma bocdinaŋ iŋ oc po am nem waêm sa yêc ŋacleŋ hoŋ aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ŋalêŋ tigeŋ, lau naŋ sêtoc dau sa, naŋ Anötö oc êŋgwiniŋ ŋac. Ma lau naŋ sêŋgwiniŋ dau, naŋ Anötö oc toc ŋac sa.” ");
INSERT INTO buk_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ma Yisu sôm têŋ ŋgac bata dau, “Am bu ndê mwasiŋ bu lau sêneŋ sêwhiŋ am, naŋ kêŋ aheŋ nem silip ti asidôwai, me lau ti lêlôm naŋ sêndöc am nem malac, naŋ dom. Am bu kôm bocdinaŋ, dec tiŋambu ŋac oc sêkêŋ aheŋ am bu neŋ gêŋ whiŋ ŋac, ma mwasiŋ dau ti am nem ŋagêyô. ");
INSERT INTO buk_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Têŋ têm am ndê mwasiŋ daŋ, naŋ kêŋ aheŋ lau ŋalôm sawa ti lau bôliŋ ma lau tapec. ");
INSERT INTO buk_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ma bocdinaŋ am oc tap Anötö ndê mwasiŋ sa. Ŋahu bu lau dinaŋ sêtôm dom bu sêkêŋ gêŋ daŋ ô nem mwasiŋ têŋ kwahic dec. Magoc têŋ ndoc lau gitêŋ sêtisa akêŋ lau batê-ŋga, naŋ Anötö oc kêŋ ŋagêyô ŋayham têŋ am.” ");
INSERT INTO buk_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Lau naŋ seŋ gêŋ sêwhiŋ Yisu, naŋ si ŋgac daŋ ŋgô Yisu ndê yom dinaŋ ma sôm têŋ iŋ, “Lau naŋ bu sêneŋ mwasiŋ atu yêc Anötö ndê gameŋ undambê-ŋga, naŋ oc atac ŋayham hôc gêlêc.” ");
INSERT INTO buk_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ma Yisu ô yom ma sôm, “Ŋgac daŋ kêmasaŋ mwasiŋ atu daŋ, ma kêŋ aheŋ lau daêsam. ");
INSERT INTO buk_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Têŋ mwasiŋ dau ŋabêc iŋ kêkiŋ ŋgac akiŋ daŋ bu sôm têŋ lau naŋ iŋ kêgalêm ŋac sa bu, ‘Ameŋ, bu aö kamasaŋ gêŋ hoŋ su.’ ");
INSERT INTO buk_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tigeŋ ŋac hoŋ sêtec bu sêmeŋ, dec sêmasaŋ yom têŋ iŋ. Ŋgac daŋ sôm, ‘Aö waloc dom, bu aö gamlhi nom daŋ su, ma kwahic dec aö bu wasa wandi walic. Aö wateŋ am bu hu aö siŋ.’ ");
INSERT INTO buk_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ma daŋ sôm, ‘Aö waloc dom, bu aö gamlhi makao amaŋlu, ma kwahic dec aö bu wasa wandi ma waŋsahê ŋac tu sêkôm gweleŋ-ŋga. Wateŋ am bu hu aö siŋ.’ ");
INSERT INTO buk_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ma daŋ tiyham sôm, ‘Kwahic dec aö gam awhê sa, bocdinaŋ gitôm dom bu waloc.’ ");
INSERT INTO buk_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Bocdinaŋ ŋgac akiŋ dau mbu gi ma gic miŋ yom dinaŋ têŋ iŋ ndê ŋadau. Ma yom dau kôm ŋadau tac ŋandê, dec iŋ kêkiŋ ndê ŋgac akiŋ tiyham ma sôm, ‘Ŋagahô sôc malac atu ndi, ma kôc lau ŋalôm sawa ti lau bôliŋ ma lau tapec sa sêmeŋ bu sêneŋ aö neŋ mwasiŋ.’ ");
INSERT INTO buk_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ma ŋgac akiŋ kôm bocdinaŋ, goc mbu meŋ ma sôm, ‘Aneŋ ŋadau, aö gakôm gitôm am sôm, ma ŋasawa yêc dôŋ yêc.’ ");
INSERT INTO buk_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Dec ŋadau sôm têŋ iŋ, ‘Sa seŋ ma gameŋ ŋamakê-ŋga ndi, ma kac lau bu sêsôc sêmeŋ. Aö tac whiŋ bu aneŋ andu meŋhu. ");
INSERT INTO buk_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yomandô aö wasôm têŋ mac, bu lau naŋ aö gakêŋ aheŋ têŋ ŋamata-ŋga, naŋ si daŋ oc neŋ aneŋ mwasiŋ dom.’” ");
INSERT INTO buk_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Lau daêsam sêŋsêlêŋ sêwhiŋ Yisu, ma iŋ kac dau kwi ma sôm têŋ ŋac, ");
INSERT INTO buk_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Asa naŋ têŋ aö meŋ ma bu êŋkuc aö, naŋ atac whiŋ aö hôc gêlêc gêŋ hoŋ ndic ŋawaê. Iŋ bu atac whiŋ damba me dinda, me iŋ nawhê ma balêkoc, me asidôwai ti lhuwêi, me iŋ dau ndê lêŋ mbo-ŋga hôc gêlêc iŋ ndê atac whiŋ aö, dec oc tôm dom bu iŋ ti aneŋ daŋ ma êŋkuc aö. ");
INSERT INTO buk_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Asa naŋ bu êŋkuc aö, magoc tec bu hôc ndê a gicso dau, naŋ gitôm dom bu êŋkuc aö. ");
INSERT INTO buk_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Mac nem daŋ bu kwê andu atu daŋ, naŋ gêŋ ŋamata-ŋga iŋ oc ndöc sic ma kôc gauc pi iŋ ndê mone ti gêŋ bu oc nditôm bu kwê andu dau sa, me mba. ");
INSERT INTO buk_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Iŋ bu kêŋ alhö sip nom ndi, magoc ndic dabiŋ andu dom, dec lau naŋ sêlic, naŋ oc sêsu iŋ susu, ");
INSERT INTO buk_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ma sêsôm, ‘Ŋgac dindê gic hu kwê andu, magoc gitôm dom bu ndic dabiŋ.’ ");
INSERT INTO buk_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ma kiŋ daŋ bu sa ndi bu ndic siŋ têŋ kiŋ daŋ, dec gêŋ ŋamata-ŋga iŋ oc ndöc sic ma kôc gauc pi iŋ ndê lau siŋ-ŋga 10,000, bu oc sêtôm bu sêhôc gêlêc kiŋ dinaŋ ndê lau siŋ-ŋga 20,000, me mba. ");
INSERT INTO buk_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Iŋ bu lic bu ŋac sêtôm dom, dec iŋ oc êŋkiŋ lau wamba-ŋga sêtêŋ kiŋ dinaŋ têŋ ndoc iŋ mbo ahê, bu sêsôm yom wamba-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Bocdinaŋ akôc gauc ŋapep muŋ su, goc ameŋ aŋkuc aö. Asa naŋ tec bu hu iŋ ndê gêŋ hoŋ siŋ tu aö-ŋga, naŋ oc nditôm dom bu ti aö neŋ daŋ. ");
INSERT INTO buk_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Gwêc so iŋ gêŋ ŋayham, tigeŋ ŋamakic bu niŋga, oc dakôm ŋamakic sa tiyham ŋalêŋ nde? ");
INSERT INTO buk_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Gwêc so dau tisac su, ma boc-dinaŋ tambaliŋ siŋ niŋga. Mac daŋamsuŋ bu yêc, naŋ aŋgô aneŋ yom.” ");
INSERT INTO buk_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Lau sêkôc takis-ŋga ma lau ŋatô naŋ lau Palêsai sêsam ŋac bu lau sac, naŋ daêsam sêtêŋ Yisu si bu sêŋgô iŋ ndê yom. ");
INSERT INTO buk_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ma lau Palêsai ti lau naŋ sêndôhôŋ yomsu, naŋ sêtucdiŋ Yisu ma sêsôm, “Ŋgac dau kôc lau sac sa, ma gêŋ gêŋ whiŋ ŋac.” ");
INSERT INTO buk_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Dec Yisu sôm yom gôliŋ daŋ têŋ ŋac bocdec bu, ");
INSERT INTO buk_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Mac nem ŋgac daŋ bu yob domba 100, ma iŋ ndê domba daŋ bu niŋga, dec iŋ oc kôm sake? Iŋ oc hu 99 siŋ sêmbo gameŋ gapoŋ, ma êŋsalê domba naŋ giŋga su e iŋ tap sa. ");
INSERT INTO buk_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ma têŋ ndoc iŋ tap sa, naŋ iŋ oc hu sac bakêyac ti atac ŋayham atu. ");
INSERT INTO buk_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ma iŋ oc mbu têŋ ndê andu ndi, ma êŋgalêm iŋ ndê lau meŋpaŋ iŋ-ŋga ti ndê silip, ma sôm têŋ ŋac, ‘Mac atac ŋayham awhiŋ aö, bu aö gatap aneŋ domba naŋ giŋga su, naŋ sa.’ ");
INSERT INTO buk_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Aö wasôm têŋ mac, bu ŋalêŋ tigeŋ dinaŋ Anötö ti aŋela undambê-ŋga oc atac ŋayham atu tu ŋamalac sac daŋ naŋ gêm ndê ŋalôm kwi, hôc gêlêc atac ŋayham tu lau gitêŋ 99 naŋ si yom me giso tu sênem dau kwi pi-ŋga mbasi.” ");
INSERT INTO buk_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ma Yisu sôm, “Ma akôc gauc pi awhê daŋ, naŋ ndê mone silba amaŋlu sêndöc. Mone daŋ bu niŋga, dec iŋ oc tuŋ lam asê ma sê andu ŋa-basac sa, goc êŋsalê ŋapep e iŋ tap mone dau sa. ");
INSERT INTO buk_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Têŋ ndoc iŋ tap sa su, naŋ iŋ oc êŋgalêm iŋ ndê silip ti lau meŋpaŋ iŋ-ŋga sêmeŋ sêpitigeŋ ma sôm, ‘Mac atac ŋayham awhiŋ aö, bu aö gatap mone naŋ giŋga su, naŋ sa.’ ");
INSERT INTO buk_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Aö wasôm têŋ mac bu ŋalêŋ tigeŋ, Anötö ti aŋela undambê-ŋga oc atac ŋayham atu, têŋ ndoc ŋamalac kôm sac-ŋga daŋ gêm ndê ŋalôm kwi.” ");
INSERT INTO buk_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ma Yisu gic têku yom ma sôm, “Ŋgac daŋ mbo ma iŋ ndê atuŋgac lu. ");
INSERT INTO buk_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ma balê sauŋ sôm têŋ damba, ‘Damaŋ, wapa lêŋsêm naŋ gic aö ŋawaê, naŋ kêŋ têŋ aö.’ Goc damba whê ndê wapa ti gêŋ hoŋ kôc tu iŋlu-ŋga, ma kêŋ têŋ balê sauŋ tôm iŋ ndac. ");
INSERT INTO buk_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ŋasawa sauŋ ma balê sauŋ dau gic iŋ ndê gêŋ hoŋ sa, ma kölhö têŋ gameŋ baliŋ daŋ gi. Ma yêc dindê iŋ kôm gêŋ hoŋ tôm iŋ ndê atac whiŋ, ma kêyaiŋ ndê awa ti gêŋ hoŋ. ");
INSERT INTO buk_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Têŋ ndoc iŋ ndê mone hoŋ pacndê, naŋ tôbôm atu gêm gameŋ dinaŋ ahuc ma iŋ pônda dau. ");
INSERT INTO buk_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Goc iŋ têŋ ŋgac atu daŋ yêc gameŋ dinaŋ gi, ma kêsalê gweleŋ. Ma ŋgac dau kêŋ iŋ gôlôm iŋ ndê bôc. ");
INSERT INTO buk_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Gêŋ yô iŋ ŋandô, tigeŋ lau sêkêŋ gêŋ daŋ têŋ iŋ tu neŋ-ŋga dom, ma boc-dinaŋ iŋ gauc gêm bu neŋ gêŋ naŋ bôc seŋ. ");
INSERT INTO buk_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tiŋambu iŋ ndê gauc sa, ma iŋ sôm têŋ dau, ‘Damaŋ ndê lau akiŋ sêpônda gêŋ daneŋ-ŋga dom. Tigeŋ gêŋ yô aö ndu tôm bu wambac ndu-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Aö walhö wambu watêŋ damaŋ wandi, ma wasôm, “Damaŋ, aö gakôm mêtê sac têŋ Anötö ma têŋ am. ");
INSERT INTO buk_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Aö ŋgac sac, dec gitôm dom bu am sam aö bu am atômŋgac tiyham. Lic aö gitôm am nem ŋgac akiŋ daŋ.” ");
INSERT INTO buk_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Goc iŋ tisa ma mbu têŋ damba gi. “Iŋ kêsêlêŋ mbo seŋ, ma damba gêlic iŋ yêc ahê ma tawalô iŋ ŋandô, dec kêti têŋ iŋ gi, gôlô iŋ dôŋ ma ŋgutô iŋ. ");
INSERT INTO buk_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Magoc atuŋgac sôm têŋ iŋ, ‘Damaŋ, aö gakôm mêtê sac têŋ Anötö ma têŋ am. Aö ŋgac sac, dec gitôm dom bu am sam aö bu am atômŋgac tiyham.’ ");
INSERT INTO buk_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tigeŋ damba sôm têŋ iŋ ndê lau akiŋ, ‘Ŋagahô, akôc ŋakwê ŋayham ti atapa bu iŋ sôc, ma akêŋ gôlôŋ amaŋatu-ŋga sôc iŋ amba-atu. ");
INSERT INTO buk_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ma akôc makao ŋatu tôp ŋayham daŋ, ma andic ndu. Yac oc dandê mwasiŋ atu ti atac ŋayham, ");
INSERT INTO buk_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","bu yac gauc gêm bu aneŋ atuŋgac dindec mbac ndu su, magoc kwahic dec dalic bu iŋ mbo tali. Iŋ giŋga su, ma datap iŋ sa tiyham.’ Ma ŋac hoŋ atac ŋayham. ");
INSERT INTO buk_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Têŋ ndoc dinaŋ balê dau dôwa kôm gweleŋ mbo ôm, ma têŋ ndoc iŋ mbu meŋ suŋ sa andu, naŋ iŋ ŋgô lau sêtê wê ti sêkôm atac ŋayham atu. ");
INSERT INTO buk_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Goc iŋ mbwêc ŋgac akiŋ daŋ meŋ ma ndac iŋ bu, ‘Lau lê sêkôm ŋanta ti atac ŋayham tu sake-ŋga?’ ");
INSERT INTO buk_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ma iŋ sôm, ‘Am asim meŋ su ma iŋ mbo ŋayham, ma bocdinaŋ dec damam gic makao tôp ŋayham daŋ ndu, ma ndê mwasiŋ atu.’ ");
INSERT INTO buk_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Yom dau kôm dôwa tac ŋandê atu, ma iŋ tec bu sôc balaŋ ŋalôm ndi. Goc damba sa gi ma kêmwaŋeŋ iŋ bu sôc ndi. ");
INSERT INTO buk_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tigeŋ iŋ sôm têŋ damba, ‘Yala ŋeŋ su aö gam akiŋ ti daŋaŋ wambu am. Tigeŋ am kêŋ naniŋ ŋatu me gêŋ sauŋ daŋ têŋ aö bu wandê mwasiŋ tu aneŋ silip-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kwahic dec am nem atômŋgac dinaŋ, naŋ kêyaiŋ am nem awa ti wapa whiŋ lauwhê seŋ-ŋga, naŋ mbu meŋ ma am gic makao tu iŋ-ŋga.’ ");
INSERT INTO buk_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Magoc damba sôm, ‘Aneŋ balê, am mbo whiŋ aö ŋapaŋ, ma aneŋ gêŋ hoŋ ti am nem. ");
INSERT INTO buk_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tigeŋ am asim dindec naŋ yac gauc gêm bu iŋ mbac ndu su, naŋ mbo tali. Iŋ giŋga su, ma datap iŋ sa tiyham. Bocdinaŋ iŋ lêŋ solop bu yac atac ŋayham atu ma dandê mwasiŋ tu iŋ-ŋga.’” ");
INSERT INTO buk_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ma Yisu sôm yom gôliŋ daŋ têŋ ndê ŋgacsêŋomi bocdec bu, “Ŋgac ti lêlôm daŋ mbo, ma lau sic miŋ têŋ iŋ bu ŋgac naŋ yob iŋ ndê gêŋ, naŋ kêyaiŋ iŋ ndê wapa daêsam. ");
INSERT INTO buk_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Dec iŋ ta ŋgac dau meŋ, ma sôm têŋ iŋ, ‘Yom bocke dec gaŋgô pi am lec. Kwahic dec am sa ndi ma sê gêŋ hoŋ sa ma êmasaŋ bapia wapa-ŋga bu kêŋ têŋ aö. Bu aö oc watiŋ am su yêc gweleŋ yob aneŋ wapa-ŋga.’ ");
INSERT INTO buk_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Dec ŋgac yob wapa-ŋga sôm têŋ dau, ‘Aö wakôm bocke? Aö neŋ ŋadau oc soc aö su yêc aneŋ gweleŋ. Aneŋ licwalô gitôm dom bu wakôm gweleŋ ôm-ŋga, ma aö mayaŋ bu wateŋ gêŋ. ");
INSERT INTO buk_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aö kayalê gêŋ naŋ bu wakôm-ŋga, ma têŋ ndoc ŋadau tiŋ aö su yêc aneŋ gweleŋ, dec lau oc sêkôc aö sa ma sênem yaom aö yêc ŋac si andu.’ ");
INSERT INTO buk_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Bocdinaŋ iŋ mbwêc lau naŋ si tôp yêc iŋ ndê ŋadau, naŋ tigeŋ-tigeŋ sêtêŋ iŋ sêmeŋ. Goc iŋ ndac ŋgac ŋamata-ŋga bocdec bu, ‘Am nem tôp bocke yêc aö neŋ ŋadau?’ ");
INSERT INTO buk_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ma ŋgac dau sôm, ‘Aneŋ tôp gitôm olib ŋakwi sip lôŋ 100.’ Goc ŋgac yob wapa-ŋga sôm têŋ iŋ, ‘Am nem bapia tôp-ŋga kelec. Kôc sa, ndöc sic ŋagahô, ma to bu am nem tôp gitôm olib ŋakwi sip lôŋ 50.’ ");
INSERT INTO buk_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Goc iŋ sôm têŋ ŋgac tilu-ŋga, ‘Am nem tôp bocke yêc?’ Ma ŋgac dau sôm têŋ iŋ, ‘Aneŋ tôp gitôm bolom wit sip dalu atu-tu 100.’ Goc ŋgac yob wapa-ŋga sôm, ‘Kôc nem bapia tôp-ŋga, ma to bu am nem tôp gitôm dalu 80.’ ");
INSERT INTO buk_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Goc ŋadau kêpiŋ ŋgac yob wapa-ŋga sac dinaŋ, bu iŋ kôm gêŋ ti gauc. Lau sambuc sêkôc awa nom-ŋga ma sêhê silip ŋac si lau. Ŋalêŋ dinaŋ ŋac sêkôm gêŋ ti gauc sêhôc gêlêc Anötö ndê lau. ");
INSERT INTO buk_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Awa nom dindec-ŋga hê lau daêsam si gauc tu sêkôm mêtê sac-ŋga. Magoc aö wasôm têŋ mac bu akôc nem awa nom-ŋga ma anem lau sa, ma ŋalêŋ dinaŋ ahê silip têŋ daôm. Tiŋambu awa dau oc niŋga, magoc ŋac oc sêkôc mac sa ti atac ŋayham têŋ ndoc mac andöc undambê.” ");
INSERT INTO buk_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ma Yisu gic têku yom ma sôm, “Asa naŋ yob gêŋ sauŋ ŋapep, naŋ oc yob gêŋ atu ŋapep bocdinaŋ. Ma asa naŋ yob gêŋ sauŋ ŋapep dom, naŋ oc yob gêŋ atu ŋapep dom. ");
INSERT INTO buk_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Bocdinaŋ mac bu ayob awa nom-ŋga ŋapep dom, dec Anötö oc kêŋ awa ŋandô têŋ mac tu ayob-ŋga dom! ");
INSERT INTO buk_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ma mac bu ayob lau ŋatô si gêŋ ŋapep dom, dec Anötö oc kêŋ gêŋ daŋ ti mac nem gêŋ dom! ");
INSERT INTO buk_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ŋamalac daŋ gitôm dom bu nem akiŋ ŋadau lu, bu iŋ oc tec daŋ, ma atac whiŋ daŋ, me oc sap daŋ dôŋ ma pu daŋ. Ma mac boc-dinaŋ, gitôm dom bu atoc Anötö ma awa nom-ŋga lu-lu sa ti mac nem ŋadau.” ");
INSERT INTO buk_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yisu sôm yom dinaŋ, ma lau Palêsai ŋatô naŋ sêŋgô, naŋ sem tô iŋ. Ŋahu bu ŋac lau atac whiŋ mone-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tigeŋ Yisu sôm têŋ ŋac, “Yêc ŋamalac aŋgô-ŋga, mac lau dinaŋ atoc daôm sa bu mac lau gitêŋ, magoc Anötö kêyalê mac nem ŋalôm su. Gêŋ naŋ mac lau nom-ŋga atoc sa bu gêŋ ŋayham kêlêc, naŋ Anötö gêlic gitôm gêŋ sac sambuc.” ");
INSERT INTO buk_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ma Yisu sôm, “Anötö kêŋ Moses ndê yomsu ti propet si yom bu lau sêŋkuc e Jon, Ŋgac Kêku Lau-ŋga hôc asê. Têŋ Jon ndê têm ma meŋ, naŋ lau sêhoc ŋawaê asê pi Anötö ndê gôliŋ. Ma lau daêsam sêkôm mwasac bu sêsôc Anötö ndê gôliŋ ŋapu. ");
INSERT INTO buk_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Gitôm bu undambê ti nom oc niŋga, tigeŋ gitôm dom bu Moses ndê yomsu ŋalhô atêc daŋ niŋga. ");
INSERT INTO buk_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ŋgac daŋ bu hu nawhê siŋ ma nem awhê wakuc, naŋ kôm mêtê mockaiŋ-ŋga yêc Anötö aŋgô-ŋga. Ma ŋgac naŋ gêm awhê naŋ hu ndê akweŋ siŋ, naŋ kôm mêtê mockaiŋ-ŋga bocdinaŋ.” ");
INSERT INTO buk_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ma Yisu sôm, “Ŋgac ti lêlôm daŋ mbo, naŋ sôc ŋakwê ŋayham ma po dau sa ŋa gêŋ ŋayham-ŋayham tôm bêc hoŋ. ");
INSERT INTO buk_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ma yêc iŋ ndê andu ŋamakê, ŋgac ŋalôm sawa daŋ ndöc, naŋ ndê ŋaê Lasarus. Gamboc daêsam sem iŋ ŋamlic ahuc, ");
INSERT INTO buk_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ma giam sêmeŋ ma sêndambwê gamboc dau. Iŋ gêŋ yô iŋ, dec iŋ takwê bu neŋ gêŋ ŋapopoc naŋ peŋ akêŋ ŋgac ti lêlôm ndê tebo, magoc mba. ");
INSERT INTO buk_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Têŋ bêc daŋ ŋgac ŋalôm sawa dinaŋ mbac ndu, ma aŋela sêkôc iŋ sa gi ndöc undambê whiŋ Abraham. Ma ŋgac ti lêlôm mbac ndu bocdinaŋ, ma lau sêŋsuhuŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Iŋ sip lambwam gi ma kêsahê ŋandê atu, dec hôc tandô sa pi undambê, ma gêlic Abraham yêc ahê, ma Lasarus ndöc whiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Goc iŋ ta yom têŋ iŋ ma sôm, ‘Abaŋ Abraham, tamwalô aö! Êmkiŋ Lasarus bu kêŋ amba-atu sip bu ndi, ma meŋ kêŋ pi aö êmbalaŋ. Ya dindec kôm aö ŋamlic ŋandê atu.’ ");
INSERT INTO buk_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tigeŋ Abraham ô yom ma sôm, ‘Aneŋ balê, gauc nem ndoc am mbo tamli, naŋ am tap gêŋ ŋayham-ŋayham daêsam sa, magoc Lasarus mbo sac ŋapaŋ. Kwahic dec iŋ mbo ŋayham, ma am tap ŋandê atu sa. ");
INSERT INTO buk_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ma gêŋ daŋ tiyham. Yêc hêclu ŋalhu, Anötö kêŋ ŋasawa atu daŋ, dec oc tôm dom bu lau sêtêŋ am sêloc. Ma gitôm dom bu mac nem daŋ lom têŋ yac meŋ.’ ");
INSERT INTO buk_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Goc ŋgac dau sôm, ‘Bocdinaŋ aö wateŋ am abaŋ, êmkiŋ Lasarus têŋ aö damaŋ ndê andu ndi, ");
INSERT INTO buk_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ma kêŋ puc aneŋ asidôwai amaŋdaŋ, bu sênem dau kwi tu bu sêmeŋ ma sêhôc ŋandê yêc gameŋ dindec dom.’ ");
INSERT INTO buk_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Magoc Abraham sôm, ‘Moses ma Propet si yom yêc bu kêŋ puc ŋac. Am nem asidôwai bu sêkêŋ daŋga ŋac si yom, dec oc tôm bu sênem dau kwi.’ ");
INSERT INTO buk_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ma ŋgac dau sôm, ‘Mba, abaŋ Abraham! Lau batê si ŋgac daŋ bu mbu têŋ ŋac ndi, dec ŋac oc sêkac si ŋalôm kwi.’ ");
INSERT INTO buk_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ma Abraham sôm, ‘Ŋac bu sêkêŋ whiŋ yom naŋ Moses ma lau propet sêto, naŋ dom, dec ŋac oc sêkêŋ whiŋ ŋgac naŋ tisa akêŋ lau batê-ŋga, naŋ dom.’” ");
INSERT INTO buk_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yisu sôm têŋ iŋ ndê ŋgacsêŋomi, “Gêŋ lêtôm-ŋga oc sêmeŋ sêhôc asê. Tigeŋ ŋamalac asa naŋ bu kôc gêŋ lêtôm-ŋga daŋ meŋ, naŋ oc tap Anötö ndê matôc sa. Oyaê. ");
INSERT INTO buk_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Oc ŋayham bu dasô hoc atu daŋ pi iŋ kachu, ma tambaliŋ iŋ sip gwêc ndi. Ma bocdinaŋ oc tôm dom bu iŋ êntôm aneŋ lau sauŋ si daŋ bu kôm mêtê sac, ma tiŋambu tap Anötö ndê matôc sa. ");
INSERT INTO buk_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Bocdinaŋ ayob daôm ŋapep! Am nem asidôwa daŋ bu kôm sac, naŋ goc hec yom iŋ. Ma iŋ bu nem dau kwi, goc suc iŋ ndê sac kwi. ");
INSERT INTO buk_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Iŋ bu kôm sac têŋ am tidim 7 têŋ acsalô tigeŋ, magoc tiŋambu kac ndê ŋalôm kwi ma ndac am bu suc iŋ ndê sac kwi, naŋ dec am suc iŋ ndê sac kwi maŋ.” ");
INSERT INTO buk_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ma lau aposel sêsôm têŋ Pômdau, “Nem yac sa bu akêŋ whiŋ ŋaŋga.” ");
INSERT INTO buk_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Goc iŋ ô yom ma sôm, “Mac nem akêŋ whiŋ bu gêŋ sauŋ andô nditôm soc ŋamatu sauŋ daŋ, dec oc tôm bu mac asôm têŋ a atu dindec bu, ‘Puc daôm sa, ma sa ndi lhac gwêc ŋagapoŋ,’ ma a dau oc daŋga wambu mac.” ");
INSERT INTO buk_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ma Yisu sôm, “Akôc gauc pi ŋgac akiŋ naŋ gic nom me yob domba, ma mbu têŋ ŋadau ndê andu têŋ telha. Iŋ ndê ŋadau oc sôm têŋ iŋ bu, ‘Mweŋ ŋagahô, ndöc sic ma neŋ gêŋ,’ a? ");
INSERT INTO buk_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mba, iŋ oc sôm, ‘Sôc ŋakwê sakiŋ-ŋga sa, ma êmasaŋ gêŋ bu waneŋ, ma nem akiŋ aö e aö waneŋ ti wanôm gêŋ pacndê. Goc tiŋambu am daôm neŋ ti nôm gêŋ.’ ");
INSERT INTO buk_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ma ŋadau oc nem daŋge ŋgac akiŋ dau bu iŋ daŋga wambu iŋ ndê yom, a? Mba! ");
INSERT INTO buk_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ma mac bocdinaŋ, têŋ ndoc mac akôm gêŋ hoŋ naŋ Anötö gic atu mac, naŋ asôm, ‘Yac lau akiŋ ŋambwa. Yac akôm gêŋ naŋ gic yac ŋawaê eŋ.’” ");
INSERT INTO buk_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yisu kêsêlêŋ hêganôŋ malac Jerusalem gi, ma mbo seŋ naŋ yêc gameŋ Samaria ti Galili-ŋga ŋabatiŋ. ");
INSERT INTO buk_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Iŋ hôc asê malac daŋ, ma tap lauŋgac 10 ti gêmbac leprasi sa yêc malac dau ŋamakê. Ŋac sêlhac ahê, ");
INSERT INTO buk_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ma sêta iŋ ŋa awha atu bocdec bu, “Ŋadau Yisu, tamwalô yac!” ");
INSERT INTO buk_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yisu tahê ŋac ma sôm, “Andi, ma atôc daôm têŋ lau dabuŋsiga.” Ma têŋ ndoc ŋac sêlhö s i, naŋ sêlic bu ŋac si ŋamlic ŋawasi sa. ");
INSERT INTO buk_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ŋac si daŋ gêlic bu iŋ ŋayham sa su, dec gic hu kêpiŋ Anötö ŋa awha atu, ma kac dau kwi ma mbu têŋ Yisu gi. ");
INSERT INTO buk_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ŋgac dau iŋ ŋgac gameŋ Samaria-ŋga, ma iŋ hu dau sip nom yêc Yisu gahi-ŋga, ma gêm daŋge iŋ. ");
INSERT INTO buk_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ma Yisu sôm, “Bocke? Mac lau 10 hoŋ ŋamlic ŋayham sa, me? Bocdinaŋ dec lau 9 sêmbo nde? ");
INSERT INTO buk_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Am ŋgac Israel-ŋga dom, magoc am ŋgac tigeŋ dec mbu mweŋ ma kêpiŋ Anötö.” ");
INSERT INTO buk_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ma Yisu sôm têŋ iŋ, “Tisa, ma lhö ndi. Am nem kêŋ whiŋ kôm am ŋayham sa.” ");
INSERT INTO buk_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Têŋ bêc daŋ lau Palêsai sêndac Yisu pi ndoc bocke Anötö ndê gôliŋ oc meŋ sa tiawê yêc nom. Ma Yisu sôm, “Têŋ ndoc Anötö ndê gôliŋ meŋ sa tiawê, naŋ oc tôm dom bu mac alic gêŋ daŋ tu kêŋ puc mac-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma oc tôm dom bu lau sêsôm, ‘Alic gêŋ dau kelec,’ me ‘Gêŋ dau kêlê.’ Mba! Anötö ndê gôliŋ meŋ sa su, ma yêc mac ŋalôm.” ");
INSERT INTO buk_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ma iŋ sôm têŋ iŋ ndê ŋgac-sêŋomi, “Têm oc meŋ sa, naŋ mac tamkwê bu alic Ŋamalac ndê Atu mbu meŋ ma mbo whiŋ mac tiyham, magoc mac oc alic iŋ dom. ");
INSERT INTO buk_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Lau oc sêŋsau bu iŋ mbu meŋ su, ma sêsôm iŋ mbo gameŋ bocdê, me gameŋ bocdec. Magoc aŋgô ŋac si yom dau dom, ma aŋkuc ŋac dom. ");
INSERT INTO buk_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Bu têŋ ndoc Ŋamalac ndê Atu mbu meŋ, naŋ iŋ oc hôc asê ŋagahô gitôm sickac hep tigeŋ ma umboŋ ŋasawa sambuc ŋawê sa. ");
INSERT INTO buk_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tigeŋ gêŋ ŋamata-ŋga iŋ oc hôc ŋandê atu ma lau têm dindec-ŋga oc sêtec iŋ. ");
INSERT INTO buk_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Têm naŋ Ŋamalac ndê Atu oc mbu meŋ, naŋ lau oc sêmbo tôm sêmbo têŋ Noa ndê têm. ");
INSERT INTO buk_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Têŋ ndoc dinaŋ lau seŋ gêŋ ti sênôm gêŋ, ma lauŋgac ti lauwhê sem dau e Noa sôc waŋ gi. Goc bu atu suŋ ma seŋ ŋac hoŋ su siŋga. ");
INSERT INTO buk_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ma oc kaiŋ tigeŋ tôm Lot ndê têm, naŋ lau seŋ ti sênôm gêŋ, semlhi gêŋ ti sêkêŋ gêŋ bu lau semlhi, sêsô gêŋ ŋawhê ma sêkwê andu. ");
INSERT INTO buk_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Magoc têŋ bêc Lot hu malac Sodom siŋ, naŋ ya ti †solpa peŋ sip akêŋ undambê ma seŋ lau Sodom-ŋga hoŋ su. ");
INSERT INTO buk_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ma lau oc sêmbo ŋalêŋ tigeŋ dinaŋ têŋ bêc naŋ Ŋamalac ndê Atu mbu meŋ ma hoc dau asê. ");
INSERT INTO buk_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Têŋ bêc dinaŋ, oc tôm dom bu lau naŋ sêndöc andu ŋasactô, naŋ sêsôc andu ŋalôm sêndi bu sêkôc gêŋ daŋ. Ma ŋalêŋ tigeŋ, oc tôm dom bu lau naŋ sêmbo ôm, naŋ sêkac dau kwi bu sêkôc si gêŋ daŋ. ");
INSERT INTO buk_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Gauc nem gêŋ naŋ hôc asê Lot ndê awhê! ");
INSERT INTO buk_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Asa naŋ tac whiŋ bu sap gêŋ nom-ŋga dôŋ ŋapaŋ tu mbo tali-ŋga, naŋ oc niŋga. Magoc asa naŋ hu siŋ tu êŋkuc aö-ŋga, naŋ oc niŋga dom. ");
INSERT INTO buk_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Aö wasôm têŋ mac, têŋ bêc naŋ Ŋamalac ndê Atu mbu meŋ, naŋ ŋamalac lu oc sêyêc andu daŋ, ma Anötö oc kôc iŋlu si daŋ, ma hu daŋ siŋ. ");
INSERT INTO buk_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Ma awhê lu oc sêndê gêŋ sêmbo, ma Anötö oc kôc daŋ, ma hu daŋ siŋ.” ");
INSERT INTO buk_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yisu ndê ŋgacsêŋomi sêŋgô yom dau su, goc sêndac iŋ, “Pômdau, gêŋ dinaŋ oc hôc asê yêc nde?” Ma Yisu sôm, “Yac bu dalic macmpoŋ sêŋgihi sêmbo, naŋ taŋyalê bu gêŋ mbôp daŋ yêc.” ");
INSERT INTO buk_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ma Yisu sôm yom gôliŋ daŋ têŋ iŋ ndê ŋgac-sêŋomi, ma kêdôhôŋ ŋac bu sêteŋ mbec tôm bêc hoŋ, ma takwê bu sêtap ŋandô sa ma sêhu siŋ dom. ");
INSERT INTO buk_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Iŋ sôm, “Ŋgac êmatôc yom-ŋga daŋ mbo malac atu daŋ. Iŋ töc Anötö dom, ma toc ŋamalac daŋ sa dom. ");
INSERT INTO buk_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ma awhê sawa daŋ ndöc malac dinaŋ, ma iŋ têŋ ŋgac êmatôc yom-ŋga dau gi ŋapaŋ, ma sôm, ‘Ŋamalac daŋ kêŋ ŋawapac têŋ aö. Nem aö sa ma êmatôc alu mba yom.’ ");
INSERT INTO buk_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Iŋ ndac tidim daêsam magoc ŋgac dau tec bu nem iŋ sa e tiŋambu iŋ sôm têŋ dau, ‘Aö gatöc Anötö dom, ma gatoc ŋamalac sa dom, ");
INSERT INTO buk_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tigeŋ awhê sawa dindec ndac aö ŋapaŋ, ma bocdinaŋ aö wanem iŋ sa ma wamatôc iŋ ndê yom. Aö bu wakôm dom, dec iŋ oc meŋ ŋapaŋ e kôm aö lic kam sa.’” ");
INSERT INTO buk_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ma Pômdau sôm têŋ ndê ŋgac-sêŋomi, “Ŋgac êmatôc yom-ŋga dau iŋ ŋgac gitêŋ dom, magoc iŋ sôm bu nem awhê sawa dinaŋ sa. ");
INSERT INTO buk_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Mac lau naŋ Anötö kêyaliŋ mac sa ati iŋ ndê, naŋ ateŋ mbec têŋ iŋ acsalô ti ôbwêc, mac gauc gêm sake? Anötö oc tec bu ŋgô mac nem mbec ma nem mac sa, a? ");
INSERT INTO buk_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mba! Aö wasôm têŋ mac bu iŋ oc nem mac sa ŋagahô. Tigeŋ, têŋ ndoc Ŋamalac ndê Atu mbu meŋ, naŋ iŋ oc tap lau ŋatô sa, naŋ sêsap si sêkêŋ whiŋ iŋ-ŋga dôŋ sêmbo, me mba?” ");
INSERT INTO buk_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yisu kêyalê bu lau ŋatô naŋ sêkêŋ daŋga iŋ, naŋ sêtoc dau sa bu lau gitêŋ ma sêpu lau ŋatô. Bocdinaŋ iŋ sôm yom gôliŋ daŋ bocdec bu. ");
INSERT INTO buk_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ŋgac lu sêtêŋ lôm dabuŋ si, bu sêteŋ mbec. Iŋlu si daŋ iŋ Palêsai, ma ŋgac daŋ iŋ ŋgac kôc takis-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Palêsai dau tisa kalhac, ma teŋ mbec tu dau-ŋga bocdec bu, ‘Anötö, aö wanem daŋge am bu aö gatôm lau ŋatô naŋ lau sac, naŋ dom. Aö gatôm lau kaŋ dom, me lau naŋ sêkôm mêtê sac me mêtê mockaiŋ-ŋga dom. Ma yomandô, aö gatôm ŋgac kôc takis-ŋga dindê dom. ");
INSERT INTO buk_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yêc wake hoŋ ŋalôm aö gahu gêŋ daneŋ-ŋga siŋ tidim lu tu gauc nem am-ŋga. Aö gawhê neŋ awa ti wapa hoŋ kôc gi toŋ amaŋlu, ma gakêŋ toŋ daŋ ti da têŋ am.’ ");
INSERT INTO buk_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Palêsai teŋ mbec bocdinaŋ, tigeŋ ŋgac kôc takis-ŋga kalhac ahê. Iŋ hôc tandô sa têŋ undambê dom, magoc wec ti ŋalôm ŋawapac ma teŋ mbec bocdec bu, ‘Anötö, tamwalô aö ŋgac sac dec.’” ");
INSERT INTO buk_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Goc Yisu sôm, “Aö wasôm têŋ mac bu Anötö gêlic ŋgac kôc takis-ŋga dinaŋ ti ŋgac gitêŋ, ma Palêsai dinaŋ mba. Ŋahu bu asa naŋ po dau ndê waê sa, naŋ Anötö oc êŋgwiniŋ iŋ, ma asa naŋ kêgwiniŋ dau, naŋ Anötö oc toc iŋ sa.” ");
INSERT INTO buk_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Têŋ bêc daŋ lau sêkôc si balêkoc sauŋ sêtêŋ Yisu sêmeŋ, bu iŋ kêŋ amba sac ŋac. Iŋ ndê ŋgac-sêŋomi sêlic e sêsôm dinda ti dambai. ");
INSERT INTO buk_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tigeŋ Yisu mbwêc ŋac sêmeŋ ma sôm, “Atec balêkoc dinaŋ sêtêŋ aö sêmeŋ, ma alhac ŋac ahuc dom. Bu Anötö ndê gôliŋ gic lau naŋ sêtôm balêkoc sauŋ-sauŋ dindec, naŋ ŋawaê. ");
INSERT INTO buk_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Aö wasôm yom ŋandô têŋ mac, bu asa naŋ bu sôc Anötö ndê gôliŋ ŋapu nditôm balêkoc sauŋ daŋ dom, naŋ oc nditôm dom bu sôc ndi.” ");
INSERT INTO buk_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ma ŋgac bata Israel-ŋga daŋ ndac Yisu, “Kêdôhôŋwaga ŋayham, aö wakôm sake, dec tiŋambu Anötö oc kôc aö sa wambo taŋli yêc undambê?” ");
INSERT INTO buk_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ma Yisu sôm, “Tu sake-ŋga am sam aö bu ŋayham? Anötö tawasê iŋ ŋayham. ");
INSERT INTO buk_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Am kêyalê Moses ndê yomsu, ‘Kôm gêŋ mockaiŋ-ŋga dom. Ndic ŋamalac ndu dom. Nem kaŋ gêŋ dom. Sôm yom tasaŋ pi lau dom,’ ma ‘Toc damam lu dinam sa.’” ");
INSERT INTO buk_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ma ŋgac dau sôm, “Aö kakuc yomsu hoŋ dinaŋ têŋ ndoc aö gambo balê ŋapaŋ e kwahic dec.” ");
INSERT INTO buk_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yisu ŋgô yom dinaŋ ma sôm têŋ iŋ, “Am pônda gêŋ tigeŋ. Kêŋ am nem wapa hoŋ têŋ lau sênemlhi, ma ndic sam ŋa-awa têŋ lau ŋalôm sawa. Ma bocdinaŋ am nem awa ŋandô oc yêc undambê. Ma tiŋambu mweŋ ma êmkuc aö.” ");
INSERT INTO buk_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Magoc ŋgac dau ŋgô Yisu ndê yom e ŋalôm ŋawapac, ŋahu bu iŋ ŋgac ti wapa daêsam. ");
INSERT INTO buk_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yisu tahê iŋ ma sôm, “Lau ti lêlôm si awa ti wapa kalhac ŋac ahuc e gitôm dom bu sêsôc Anötö ndê gôliŋ ŋapu ŋagahô. ");
INSERT INTO buk_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Bôc atu daŋ gitôm kamel, oc tôm bu sôc so ŋalasê ŋagahô hôc gêlêc ŋgac ti lêlôm daŋ bu sôc Anötö ndê gôliŋ ŋapu su.” ");
INSERT INTO buk_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Lau naŋ sêŋgô yom dau sêsôm, “Bu bocdinaŋ dec asa oc tôm bu tap Anötö ndê mwasiŋ nem lau si-ŋga sa? Oc ŋawapac atu!” ");
INSERT INTO buk_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Magoc Yisu ô yom ma sôm, “Gêŋ naŋ ŋamalac sêtôm dom bu sêkôm, naŋ Anötö gitôm bu kôm.” ");
INSERT INTO buk_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ma Pita sôm têŋ iŋ, “Yac oc bocke? Yac ahu mba andu ti gêŋ hoŋ siŋ tu aŋkuc am-ŋga.” ");
INSERT INTO buk_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ma Yisu sôm têŋ iŋ, “Aö wasôm yom ŋandô têŋ mac bu asa naŋ bu hu andu, me awhê, me asidôwai, me damba lu dinda, me balêkoc siŋ tu êŋkuc aö-ŋga, ");
INSERT INTO buk_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","naŋ Anötö oc kêŋ gêŋ kaiŋ dinaŋ daêsam têŋ iŋ ô, têŋ têm iŋ mbo nom. Ma têŋ têm ŋambu-ŋga, Anötö oc kôc iŋ sa ma kêŋ iŋ ndöc tali ŋapaŋ yêc undambê.” ");
INSERT INTO buk_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yisu kôc ŋgacsêŋomi 12 sa sêsa si sêmbo dau-ŋga, ma sôm têŋ ŋac bu, “Kwahic dec yac bu dapi Jerusalem dandi, ma gêŋ hoŋ naŋ lau propet sêto pi Ŋamalac ndê Atu, naŋ oc ŋandô sa. ");
INSERT INTO buk_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Lau oc sêkêŋ iŋ sip lau Rom-ŋga amba, ma ŋac oc sêsu iŋ susu, sêkôm iŋ ŋayom, sêhê gasôp pi iŋ, sêtap iŋ, ma sêndic iŋ ndu. ");
INSERT INTO buk_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Magoc iŋ oc tisa tiyham têŋ bêc titö-ŋga.” ");
INSERT INTO buk_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tigeŋ ŋac sêŋyalê yom dau ŋahu dom. Ŋahu yêc siŋ dau têŋ ŋac, ma ŋac si gauc sa pi Yisu ndê yom dau dom. ");
INSERT INTO buk_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yisu ma lau naŋ sêŋkuc iŋ sêŋsêlêŋ e sêsuŋ sa malac Jeriko. Ma yêc seŋ ŋamakê ŋgac tapec daŋ ndöc ma teŋ gêŋ. ");
INSERT INTO buk_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ŋgac dau ŋgô bu lau daêsam sêŋsêlêŋ sêmbo seŋ, goc ndac gêŋ dau ŋahu. ");
INSERT INTO buk_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ma lau sêsôm têŋ iŋ bu Yisu Nasaret-ŋga kêsêlêŋ mbo seŋ meŋ. ");
INSERT INTO buk_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Goc iŋ mbwêc, “Yisu, †Dawid ndê Atu, tamwalô aö!” ");
INSERT INTO buk_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Lau naŋ sêŋsêlêŋ sêmuŋ Yisu sêhec yom ŋgac tapec dau, ma sêsôm têŋ iŋ bu nem dôŋ. Magoc iŋ mbwêc ti ŋaŋga, “Dawid ndê Atu, tamwalô aö!” ");
INSERT INTO buk_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yisu kwê dôŋ kalhac, ma sôm têŋ lau bu sêkôc ŋgac dau sêtêŋ iŋ sêmeŋ. Ma têŋ ndoc iŋ tigasuc Yisu, naŋ Yisu ndac iŋ, ");
INSERT INTO buk_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Am tac whiŋ bu aö wakôm sake têŋ am?” Ma iŋ sôm, “Pômdau, aö tac whiŋ bu tanôŋ ŋayham sa.” ");
INSERT INTO buk_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Goc Yisu sôm têŋ iŋ, “Tanôm ŋayham sa! Am nem kêŋ whiŋ kôm am ŋayham sa.” ");
INSERT INTO buk_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ma ŋagahô eŋ iŋ tandô ŋayham sa, ma iŋ kêkuc Yisu ma kêpiŋ Anötö. Ma lau hoŋ naŋ sêlic gêŋ dinaŋ, naŋ sêmpiŋ Anötö bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yisu sôc malac Jeriko gi, ma bu êŋsêlêŋ gacgeŋ sa ndi. ");
INSERT INTO buk_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ma ŋgac daŋ mbo, naŋ sêsam iŋ ndê ŋaê bu Sakias. Iŋ ŋgac bata kôc takis-ŋga, ma iŋ dau ndê mone daêsam. ");
INSERT INTO buk_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Iŋ tac whiŋ bu lic Yisu pi ŋandô, magoc iŋ gitôm dom, bu iŋ ŋgac apê, ma lau daêsam sêŋgihi Yisu ahuc. ");
INSERT INTO buk_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tu dinaŋ-ŋga iŋ kêti muŋ gi, ma pi a kiŋ daŋ, bu lic Yisu naŋ kêsêlêŋ mbo seŋ meŋ. ");
INSERT INTO buk_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Têŋ ndoc Yisu hôc asê a dinaŋ ŋapu, naŋ tatac ma sôm têŋ iŋ, “Sakias, sip mweŋ ŋagahô! Acsalô dec aö wambo am nem andu wawhiŋ am.” ");
INSERT INTO buk_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Goc ŋagahô Sakias sip nom ma kôc Yisu sa ti atac ŋayham, ma sêtêŋ iŋ ndê andu si. ");
INSERT INTO buk_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Magoc lau hoŋ naŋ sêlic gêŋ dau sêtucdiŋ ma sêsôm, “Yisu bu ndic ŋgac sac daŋ kêsi!” ");
INSERT INTO buk_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Têŋ ndoc sêmbo Sakias ndê andu, naŋ ŋgac dau tisa ma sôm têŋ Yisu, “Pômdau lic! Kwahic dec aö wawhê aneŋ wapa hoŋ kôc ndi toŋ lu, ma wakêŋ toŋ daŋ têŋ lau ŋalôm sawa. Ma lau naŋ aö kasau ŋac ma gakôc ŋac si mone, naŋ aö waô mone dau tidim hale têŋ ŋac.” ");
INSERT INTO buk_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Dec Yisu sôm, “Acsalô lec Anötö ndê mwasiŋ nem lau si-ŋga meŋ pi lau andu dindec-ŋga. Bu ŋgac dindec iŋ Abraham ndê apaŋgac daŋ whiŋ. ");
INSERT INTO buk_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ŋamalac ndê Atu meŋ bu êŋsalê lau naŋ siŋga su, ma bu nem ŋac si.” ");
INSERT INTO buk_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Lau naŋ sêŋgô Yisu ndê yom dinaŋ, naŋ sêlic bu iŋ suŋ sa têŋ Jerusalem, ma sêkêŋ bata bu têŋ ndoc iŋ hôc asê, naŋ Anötö ndê gôliŋ oc meŋ sa tiawê, ma Yisu oc ti lau Israel-ŋga si kiŋ. Bocdinaŋ Yisu gic hu sôm yom gôliŋ daŋ têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Iŋ sôm, “Ŋgac ti waê atu daŋ kêmasaŋ dau bu têŋ gameŋ baliŋ daŋ ndi, bu yêc dindê kiŋ atu oc kêŋ ŋaclai têŋ iŋ bu nem gôliŋ lau yêc iŋ dau ndê gameŋ. Ma tiŋambu iŋ oc mbu meŋ. ");
INSERT INTO buk_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Boc-dinaŋ iŋ kêgalêm iŋ ndê lau akiŋ amaŋlu sa, ma kêŋ mone gol daŋ naŋ sêsam bu ‘maina’ têŋ ŋac tôm gi. Ma iŋ sôm têŋ ŋac, ‘Akôc mone dec sa, ma akôm gweleŋ pi e nditôm aö wambu wameŋ.’ ");
INSERT INTO buk_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Magoc iŋ ndê lau sêtec iŋ, ma sêkêŋ lau aheŋ-ŋga ŋatô sêŋkuc iŋ bu sêsôm têŋ kiŋ atu bu, ‘Yac atec ŋgac dec bu nem gôliŋ yac.’ ");
INSERT INTO buk_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Magoc kiŋ atu ŋgô ŋac si yom dom ma kêŋ ŋaclai têŋ ŋgac dau bu nem gôliŋ lau, goc iŋ mbu têŋ iŋ ndê gameŋ gi. Iŋ hôc asê su, goc kêŋ yom bu iŋ ndê lau akiŋ naŋ iŋ kêŋ mone têŋ ŋac, naŋ sêtêŋ iŋ sêndi. Iŋ bu lic ŋac sêkôm gweleŋ bocke pi mone dau. ");
INSERT INTO buk_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Ŋgac akiŋ ŋamata-ŋga meŋ ma sôm, ‘Aneŋ ŋadau, aö gakôm gweleŋ pi am nem mone tigeŋ, ma gatap mone amaŋlu tiyham sa.’ ");
INSERT INTO buk_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ma ŋadau sôm, ‘Aneŋ ŋgac akiŋ, am kôm ŋayham! Am yob gêŋ sauŋ dindec ŋapep, ma kwahic dec aö wakêŋ am nem gôliŋ malac amaŋlu.’ ");
INSERT INTO buk_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ma ŋgac tilu-ŋga meŋ ma sôm, ‘Ŋadau, aö gakôm gweleŋ pi am nem mone tigeŋ, ma gatap mone amaŋdaŋ tiyham sa.’ ");
INSERT INTO buk_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ma ŋadau sôm têŋ iŋ, ‘Kwahic dec aö wakêŋ am nem gôliŋ malac amaŋdaŋ.’ ");
INSERT INTO buk_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ma lau akiŋ dau si daŋ meŋ ma sôm, ‘Ŋadau, am nem mone gol tigeŋ kelec. Aö kapaŋ si ŋapep. ");
INSERT INTO buk_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Aö gatöc am, bu am ŋgac lêlê-ŋga dom. Am kêŋ batam bu kôc gêŋ ŋandô yêc lau naŋ am kêŋ gêŋ têŋ ŋac dom. Ma am gic gêŋ ŋandô sa yêc gameŋ naŋ am sô gêŋ ŋawhê dom.’ ");
INSERT INTO buk_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Goc ŋadau sôm têŋ iŋ, ‘Am ŋgac akiŋ sac! Aö wamatôc am waŋkuc yom naŋ am daôm sôm. Am kêyalê bu aö ŋgac lêlê-ŋga dom, ma bu aö gakêŋ bataŋ bu wakôc gêŋ yêc lau naŋ aö gakêŋ gêŋ têŋ ŋac dom, ma bu wandic gêŋ ŋandô sa yêc gameŋ naŋ gasô gêŋ dom. ");
INSERT INTO buk_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tu sake-ŋga am kôm gweleŋ pi aneŋ mone dom? Oc tôm bu am kêŋ aneŋ mone têŋ lau sêyob mone-ŋga bu sêyob e aö wambu wameŋ, dec oc tôm bu sêkêŋ mone ŋagec sac mone dau ŋahô ma aö wakôc hoŋ sa.’ ");
INSERT INTO buk_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ma iŋ sôm têŋ lau naŋ sêlhac sêmpiŋ, ‘Akôc iŋ ndê mone tigeŋ dinaŋ su, ma akêŋ têŋ ŋgac akiŋ naŋ kôc mone amaŋlu.’ ");
INSERT INTO buk_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Magoc ŋac sêsôm, ‘Ŋadau, iŋ kôc mone amaŋlu su!’ ");
INSERT INTO buk_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Goc ŋadau sôm, ‘Aö wasôm têŋ mac bu asa naŋ yob gêŋ naŋ aö gakêŋ sip iŋ amba, naŋ ŋapep, naŋ wakêŋ gêŋ ŋatô tiyham têŋ iŋ whiŋ. Tigeŋ asa naŋ yob ndê gêŋ ŋapep dom, naŋ aö wakôc iŋ ndê gêŋ hoŋ su. ");
INSERT INTO buk_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ma aŋgô! Aneŋ ŋacyo naŋ sêtec bu aö wanem gôliŋ ŋac, naŋ akôc ŋac sêmeŋ, ma andic ŋac ndu yêc aö aŋôŋ-ŋga.’” ");
INSERT INTO buk_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yisu sôm yom dinaŋ su, ma kêsêlêŋ hêganôŋ Jerusalem gi, ma iŋ ndê sêŋomi sêŋkuc iŋ. ");
INSERT INTO buk_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Iŋ kêsêlêŋ gi e kêpiŋ malac lu naŋ sêsam bu Betpagi ma Betani, malac lu naŋ sêyêc Lôc Olib. Ma iŋ kêkiŋ ndê ŋgacsêŋom lu ");
INSERT INTO buk_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ma sôm têŋ iŋlu, “Asôc malac dindê andi, ma amlu oc atap doŋki daŋ sa, naŋ sêsô dôŋ kalhac. Iŋ doŋki ŋatu wakuc, naŋ ŋamalac daŋ ndöc ŋahô muŋ su dom. Aŋgapwêc su ma akôc sa ameŋ. ");
INSERT INTO buk_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ma lau bu sêndac amlu bu bocke ma amlu bu aŋgapwêc iŋ su, goc asôm têŋ ŋac bu, ‘Pômdau tac whiŋ bu doŋki dindec nem iŋ sa.’” ");
INSERT INTO buk_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Boc-dinaŋ ŋgac lu dinaŋ sêsôc malac dau si, ma sêtap doŋki dau sa tôm Yisu sôm. ");
INSERT INTO buk_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Sêŋgapwêc doŋki sêmbo, ma ŋadaui sêndac iŋlu bu, “Amlu aŋgapwêc iŋ tu sake-ŋga?” ");
INSERT INTO buk_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ma sêsôm, “Pômdau tac whiŋ bu doŋki dindec nem iŋ sa.” ");
INSERT INTO buk_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Iŋlu sêwê doŋki dau sêtêŋ Yisu si, ma sêkêŋ ŋac si ŋakwê awê-ŋga sac doŋki, ma sêkêŋ iŋ pi gi ndöc ŋahô. ");
INSERT INTO buk_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yisu ndöc doŋki ma kêsêlêŋ gi, ma lau sêhê si ŋakwê yêc seŋ. ");
INSERT INTO buk_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Iŋ kêsêlêŋ gi e hôc asê gameŋ naŋ seŋ sip akêŋ Lôc Olib, goc sêŋomi toŋ atu naŋ sêŋkuc iŋ, naŋ sêmbwêc ti atac ŋayham atu, ma sêmpiŋ Anötö pi gêŋ dalô naŋ sêlic. ");
INSERT INTO buk_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Sêsôm, “Anötö nem mbec kiŋ naŋ meŋ gêm Pômdau aŋgô. Yom malô yêc undambê, ma Anötö ndê waê sa yêc lôlôc!” ");
INSERT INTO buk_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Palêsai ŋatô sêmbo sêwhiŋ lau daêsam dinaŋ, ma sêsôm têŋ Yisu, “Kêdôhôŋwaga, hec yom am nem sêŋomi, bu ŋac si yom so.” ");
INSERT INTO buk_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ma Yisu sôm têŋ ŋac, “Aŋgô! Sêŋomi bu sênem dôŋ, goc hoc dindec oc sêmbwêc asê!” ");
INSERT INTO buk_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yisu kêsêlêŋ gi e hôc tandô sa pi malac atu Jerusalem, dec taŋ pi malac dau. ");
INSERT INTO buk_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Iŋ sôm, “Tôm ŋasawa baliŋ su e meŋ têŋ acsalô lec aö tac whiŋ bu mac lau Jerusalem-ŋga aŋyalê lêŋ naŋ oc tôm bu kêŋ mac ambo ti atac malô. Tigeŋ mac nem ŋalôm ŋadandi ma kwahic dec lêŋ dau yêc siŋ dau têŋ mac. ");
INSERT INTO buk_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Têm oc meŋ sa, naŋ nem ŋacyo oc sêŋgihi mac ahuc ma sêŋgilì tuŋbôm ma sêsôc nem malac sêloc. ");
INSERT INTO buk_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ŋac oc sêndic mac ti nem balêkoc hoŋ ndu, m a sêseŋ malac dindec su e hoc daŋ ndöc hoc daŋ ŋahô tiyham dom. Ŋac oc sêkôm bocdinaŋ, ŋahu bu Anötö têŋ mac meŋ bu nem mac sa, magoc mac aŋyalê dom.” ");
INSERT INTO buk_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Têŋ ndoc Yisu hôc asê Jerusalem, naŋ iŋ kêsêlêŋ gi e sôc lôm dabuŋ ŋabatêmndö gi. Ma iŋ soc lau naŋ sêkêŋ gêŋ bu lau sênemlhi, naŋ sêsa awê. ");
INSERT INTO buk_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Iŋ sôm têŋ ŋac, “Sêto Anötö ndê yom yêc bocdec bu, ‘Aneŋ andu gic waê bu lau sêteŋ mbec sêmbo-ŋga,’ magoc mac akôm Anötö ndê andu ti lau kaŋ si gameŋ.” ");
INSERT INTO buk_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Tôm bêc hoŋ iŋ kêdôhôŋ lau mbo lôm dabuŋ ŋabatêmndö. Ma dabuŋsiga atu-tu ti lau †Skraib naŋ sêndôhôŋ yomsu, ma lau bata Israel-ŋga sêŋsalê lêŋ bu sêndic iŋ ndu. ");
INSERT INTO buk_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Magoc sêtap lêŋ daŋ sa dom, bu lau hoŋ atac whiŋ bu sêŋgô iŋ ndê yom, ma sêsap iŋ dôŋ ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Têŋ têm dinaŋ Yisu kêdôhôŋ lau, ma gêm mêtê pi ŋawaê ŋayham mbo lôm dabuŋ. Ma dabuŋsiga atu-tu ti lau Skraib ma lau bata Israel-ŋga sêtêŋ iŋ si, ");
INSERT INTO buk_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ma sêsôm, “Sôm têŋ yac. Am kôc ŋaclai yêc nde, bu kôm gêŋ hoŋ naŋ am kôm? Asa kêŋ têŋ am?” ");
INSERT INTO buk_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ma iŋ sôm, “Gêŋ ŋamata-ŋga aö bu wakêŋ gêndac daŋ têŋ mac. Asôm têŋ aö, ");
INSERT INTO buk_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","asa kêŋ ŋaclai têŋ Jon dec iŋ kêku lau? Anötö kêŋ ŋaclai têŋ iŋ, me mba?” ");
INSERT INTO buk_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ŋac sem yomgalôm têŋ dau pi Yisu ndê gêndac ma sêsôm, “Yac bu dasôm bu, ‘Anötö kêŋ ŋaclai têŋ Jon,’ dec iŋ oc ndac yac, ‘Tu sake-ŋga mac akêŋ whiŋ Jon dom?’ ");
INSERT INTO buk_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Magoc yac bu dasôm bu Jon kêku lau kêkuc ŋamalac nom-ŋga si gauc ŋambwa, dec lau hoŋ oc sêtuc yac ŋa hoc dambac ndu, bu ŋac sêlic Jon bu Anötö ndê propet daŋ.” ");
INSERT INTO buk_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Bocdinaŋ sêsôm têŋ Yisu bu sêŋyalê Jon ndê ŋaclai ŋahu dom. ");
INSERT INTO buk_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ma Yisu sôm têŋ ŋac, “Ma bocdinaŋ aö wasôm aneŋ ŋaclai ŋahu asê têŋ mac dom.” ");
INSERT INTO buk_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ma Yisu sôm yom gôliŋ daŋ têŋ lau dau bocdec bu, “Ŋgac daŋ sô ôm wain-ŋga daŋ, ma kêŋ têŋ lau ŋatô bu sêyob. Goc iŋ têŋ gameŋ daŋ gi ma mbo ŋasawa baliŋ. ");
INSERT INTO buk_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Têŋ ndoc sêhoŋ wain ŋandô sa-ŋga, iŋ kêkiŋ ŋgac akiŋ daŋ têŋ lau naŋ sêyob iŋ ndê ôm, naŋ gi, bu sêkêŋ wain ŋandô ŋatô têŋ iŋ. Tigeŋ ŋac sic iŋ, ma sêkêŋ iŋ kölhö amba sawa gi. ");
INSERT INTO buk_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Goc ŋadau kêkiŋ ŋgac akiŋ daŋ tiyham, magoc ŋac sic iŋ ma sêkôm mêtê sac têŋ iŋ, ma sêkêŋ iŋ kölhö amba sawa gi. ");
INSERT INTO buk_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ma iŋ kêkiŋ ŋgac titö-ŋga têŋ ŋac gi, magoc ŋac sic iŋ basô, ma sêmasuc iŋ sa awê gi. ");
INSERT INTO buk_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Goc ôm wain-ŋga ŋadau sôm, ‘Aö wakôm sake? Aö waŋkiŋ aneŋ balê, naŋ aö atac whiŋ iŋ ndu andô. Mboe ŋac oc sêtoc iŋ sa.’ ");
INSERT INTO buk_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tigeŋ têŋ têm lau sêyob ôm-ŋga sêlic ŋadau ndê atu kêsêlêŋ meŋ, naŋ sêsôm têŋ dandi, ‘Ŋadau ndê atuŋgac dê oc wêkaiŋ ôm dindec. Dandic iŋ ndu ma dakôc ôm dindec su ti yac neŋ.’ ");
INSERT INTO buk_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ma sêmasuc iŋ yêc ôm wain-ŋga, ma sic iŋ ndu.” Ma Yisu ndac, “Mac gauc gêm bu ôm ŋadau oc kôm sake têŋ ŋac? ");
INSERT INTO buk_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Iŋ oc meŋ ma ndic lau sêyob ôm-ŋga ndu, ma kêŋ ndê ôm têŋ lau ŋatô sêyob.” Lau naŋ sêŋgô yom dinaŋ sêsôm, “Mba! Bocdinaŋ dom!” ");
INSERT INTO buk_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Magoc Yisu tahê ŋac ma sôm, “Gauc nem yom naŋ sêto yêc bocdec bu, ‘Hoc naŋ lau sêkwê andu-ŋga sêtec, naŋ kwahic ti hoc ŋamata-ŋga yêc andu dau.’ Mac aŋyalê yom dau ŋahu, me mba? ");
INSERT INTO buk_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Lau hoŋ naŋ sêtiŋ gahi pi hoc dinaŋ e sêpeŋ, naŋ oc sêniŋga, ma hoc dau bu peŋ pi ŋamalac daŋ, dec oc sec iŋ popoc.” ");
INSERT INTO buk_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Lau Skraib ti dabuŋsiga atu-tu sêŋyalê bu Yisu ndê yom gôliŋ dinaŋ hêganôŋ ŋac, dec ŋac atac whiŋ bu sêkôc iŋ dôŋ ŋagahô eŋ. Magoc ŋac sêtöc lau naŋ sêmbo sêwhiŋ iŋ, dec sêkôm dom. ");
INSERT INTO buk_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ma lau bata Israel-ŋga dinaŋ tatiŋ Yisu ŋapep, ma sêkêŋ lau ŋatô bu sêtip iŋ. Lau sêtip Yisu-ŋga dinaŋ sêŋsau bu ŋac tac whiŋ bu sêŋgô iŋ ndê yom. Tigeŋ sêkêŋ daŋga bu mboe sêŋgô iŋ sôm yom so daŋ, dec ŋac oc sêkêŋ iŋ sip gôliŋwaga Rom-ŋga ndê amba, bu êmatôc iŋ. ");
INSERT INTO buk_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ma ŋac sêsôm têŋ iŋ bu, “Kêdôhôŋwaga, yac aŋyalê bu am sôm yom ma kêdôhôŋ lau ŋalêŋ gitêŋ. Am toc lau hoŋ sa ŋalêŋ tigeŋ, ma kêdôhôŋ Anötö ndê lêŋ têŋ lau kêkuc yom ŋandô. ");
INSERT INTO buk_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kwahic dec yac bu andac am bu iŋ solop bu yac dakêŋ takis têŋ Sisa, me mba?” ");
INSERT INTO buk_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yisu kêyalê bu ŋac gauc gêm bu sêtim iŋ, dec sôm têŋ ŋac, ");
INSERT INTO buk_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Atôc mone silba daŋ têŋ aö.” Ma iŋ ndac, “Asa ndê ŋagatu ti ŋaê yêc mone dindec?” ");
INSERT INTO buk_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ma ŋac sêsôm, “Sisa ndê.” Goc Yisu sôm têŋ ŋac, “Bocdinaŋ atoc Sisa sa ŋa gêŋ naŋ gic iŋ ŋawaê, ma atoc Anötö sa ŋa gêŋ naŋ gic iŋ ŋawaê.” ");
INSERT INTO buk_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ŋalêŋ dinaŋ ŋac sêŋsahê bu sêtim iŋ bu sôm yom so daŋ yêc lau hoŋ aŋgô-ŋga, magoc sêtôm dom. Sêhêdaê tu iŋ ndê yom ti gauc-ŋga, ma ŋac si yom mba bu sêsôm ô. ");
INSERT INTO buk_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Têŋ dinaŋ lau †Sadiusi ŋatô sêtêŋ Yisu si. Ŋac lau Israel-ŋga si toŋ daŋ, naŋ sêkêŋ whiŋ bu lau batê oc sêtisa tiyham dom. Ma ŋac sêkêŋ gêndac daŋ têŋ Yisu bocdec bu, ");
INSERT INTO buk_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Kêdôhôŋwaga, Moses to yac neŋ yomsu daŋ bocdec bu. Ŋgac daŋ bu ndê dôwa nem awhê sa ma bu mbac ndu ma balêkoc mbasi, naŋ ŋgac dau oc nem dôwa ndê awhê sawa, ma kwê balêkoc asê tu dôwa-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Têŋ têm daŋ, asidôwai 7 sêmbo. Ŋgac ŋamata-ŋga gêm awhê sa, magoc iŋ mbac ndu ma iŋ ndê balêkoc mba. ");
INSERT INTO buk_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Ma ŋgac tilu-ŋga gêm awhê sawa dau, tigeŋ mbac ndu ma balêkoc mba. Ŋalêŋ tigeŋ ŋgac titö-ŋga e têŋ ŋgac ti-7-ŋga hoŋ sem awhê sawa dau magoc sêmbac ndu ma balêkoc mba. ");
INSERT INTO buk_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ma tiŋambu awhê dau mbac ndu. ");
INSERT INTO buk_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kwahic dec yac bu andac am bocdec bu. Lau batê bu sêtisa tôm lau ŋatô sêsôm, dec awhê dau oc ti asa ndê awhê? Bu asidôwai 7 dinaŋ hoŋ sem iŋ su têŋ ndoc sêmbo tali.” ");
INSERT INTO buk_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ma Yisu ô yom ma sôm têŋ ŋac, “Lau têm dindec-ŋga sem dau, ");
INSERT INTO buk_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","tigeŋ têŋ têm ŋambu-ŋga, lau naŋ Anötö oc lic bu lau gitêŋ ma uŋ ŋac sa bu sêndöc tali yêc undambê, naŋ oc sênem dau dom. ");
INSERT INTO buk_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ma oc tôm dom bu ŋac sêmbac ndu tiyham, bu ŋac oc sêmbo sêtôm aŋela. Lau naŋ Anötö uŋ sa sêndöc undambê, naŋ oc sêti iŋ ndê balêkoc. ");
INSERT INTO buk_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ma Moses dau tôc asê bu lau batê oc sêtisa. Gauc nem yom naŋ iŋ to pi ndoc iŋ gêlic ya golom sa a daŋ. Têŋ ndoc dinaŋ iŋ sam Pômdau bu Abraham ndê Anötö, Aisak ndê Anötö, ma Jakob ndê Anötö. ");
INSERT INTO buk_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Lau batê bu sêtisa dom, dec tu sake-ŋga Anötö sam dau bu lau tö dinaŋ si Anötö? Anötö iŋ lau batê si Anötö dom, iŋ lau tali si Anötö, bu lau hoŋ si ŋahu sêmbo tali-ŋga yêc Anötö.” ");
INSERT INTO buk_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Lau †Skraib ŋatô sêŋgô Yisu ndê yom dau ma sêsôm, “Kêdôhôŋ-waga, am nem yom ŋayham!” ");
INSERT INTO buk_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma tiŋambu lau sêtöc dau bu sêkêŋ gêndac têŋ Yisu tiyham. ");
INSERT INTO buk_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ma Yisu sôm têŋ ŋac, “Bocke ma lau sêsôm bu Mesaya iŋ Dawid ndê Atu? ");
INSERT INTO buk_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dawid dau to yom yêc Buku Wê-ŋga bocdec bu, ‘Anötö sôm têŋ aneŋ Pômdau, “Am ndöc aö amaŋ andô-ŋga, ");
INSERT INTO buk_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","e nditôm aö wakêŋ nem ŋacyo sêsôc am gahim ŋapu.” ’ ");
INSERT INTO buk_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Bocdinaŋ Dawid dau sam Mesaya bu Pômdau, ma bocke dec lau sêsôm bu Mesaya iŋ Dawid ndê Atu?” ");
INSERT INTO buk_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ma yêc lau hoŋ dinaŋ si aŋgô-ŋga, Yisu sôm têŋ iŋ ndê ŋgacsêŋomi, ");
INSERT INTO buk_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ayob daôm ŋapep bu aŋkuc lau Skraib si gêbôm dom. Ŋac sêsôc ŋakwê baliŋ ma sêŋsêlêŋ sêmbo malac lôm, bu ŋac atac whiŋ bu lau sêtoc ŋac sa ma sêhê mwalêc ŋac. Ŋac atac whiŋ bu sêndöc mala ŋamata-ŋga yêc lôm wê-ŋga, ma lau tiwaê si mala têŋ ndoc sêneŋ mwasiŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Yêc lau hoŋ aŋgô-ŋga, sêteŋ mbec baliŋ, magoc têŋ ndoc lau sêlic ŋac dom, naŋ sêŋsau lauwhê sawa bu sêŋgaho ŋac si andu su. Anötö oc êmatôc ŋac ma kêŋ ŋagêyô sac andô têŋ ŋac.” ");
INSERT INTO buk_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yisu hôc tandô sa ma gêlic lau ti lêlôm sêkêŋ si da sip apa da-ŋga naŋ kalhac lôm dabuŋ ŋamakê. ");
INSERT INTO buk_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ma iŋ gêlic awhê tuc ŋalôm sawa daŋ kêŋ awa sauŋ lu gitôm wan toea lu sip apa da-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ma iŋ sôm, “Aö wasôm yomandô têŋ mac, bu yêc Anötö aŋgô-ŋga awhê tuc ŋalôm sawa dindec kêŋ da hôc gêlêc lau hoŋ si da su. ");
INSERT INTO buk_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ŋahu bu lau ti lêlôm sêkêŋ si da, magoc ŋac si awa daêsam gacgeŋ yêc ŋac-ŋga. Tigeŋ awhê dindec iŋ awhê ŋalôm sawa, ma iŋ kêŋ iŋ ndê gêŋ hoŋ ti da.” ");
INSERT INTO buk_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yisu ndê ŋgacsêŋomi ŋatô sêsôm yom pi hoc ŋayham-ŋayham ma gôlôŋ ŋayham naŋ lau ŋatô sêkêŋ bu sêŋgôlôŋ lôm dabuŋ. Magoc Yisu sôm, ");
INSERT INTO buk_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ndoc oc meŋ sa, naŋ gêŋ ŋayham hoŋ naŋ kwahic dec mac alic yêc gameŋ dindec, naŋ oc niŋga. Ŋacyo oc sêseŋ hoc hoŋ su, ma hoc daŋ oc ndöc hoc daŋ ŋahô tiyham dom.” ");
INSERT INTO buk_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ma Yisu ndê ŋgacsêŋomi sêndac iŋ, “Kêdôhôŋwaga, ŋawapac naŋ am sôm yom pi, naŋ oc hôc asê Jerusalem têŋ têm bocke? Ma gêŋ sake oc kêŋ puc yac bu têm dau meŋ kêpiŋ?” ");
INSERT INTO buk_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ma Yisu sôm, “Ayob daôm ŋapep bu lau sêŋsau mac dom. Lau daêsam oc sêmeŋ sênem aö aŋôŋ ma sêsôm, ‘Aö Mesaya dau,’ ma ‘Têm dau meŋ kêpiŋ.’ Aŋkuc ŋac dom! ");
INSERT INTO buk_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ma têŋ têm mac aŋgô ŋawaê bu lau sic siŋ têŋ dau, me lau sêli dau sa, naŋ atöc daôm dom. Bu gêŋ hoŋ dinaŋ gic waê bu meŋ sa muŋ, magoc têm ŋambu-ŋga yêc dôŋ yêc.” ");
INSERT INTO buk_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ma Yisu gic têku yom ma sôm, “Kiŋ nom-ŋga oc sêkêŋ kisa dau, ma lau akêŋ gameŋ daŋ oc sêndic siŋ têŋ lau akêŋ gameŋ daŋ. ");
INSERT INTO buk_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tiyhô oc nem atu, ma tôbôm ti gêmbac atu-tu oc sêhôc asê gameŋ ŋatô. Lau oc sêlic gêŋ dalô atu-tu yêc umboŋ, ma gêŋ atu-tu naŋ oc kôm ŋac sêtöc dau atu. ");
INSERT INTO buk_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Gêŋ ŋamata-ŋga, lau oc sêkêŋ kisa mac, ma sêkôc mac dôŋ. Tu mac akêŋ whiŋ aö-ŋga, dec lau oc sêmatôc mac yêc lôm wê-ŋga, ma sêkêŋ mac andöc gapocwalô. Ma ŋac oc sêkêŋ mac alhac kiŋ ti gôliŋwaga aŋgô-ŋga bu sêmatôc mac. ");
INSERT INTO buk_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ndoc dinaŋ iŋ mac nem têm bu asôm yom asê pi aö. ");
INSERT INTO buk_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ahêgo daôm tu yom asôm-ŋga dom, ");
INSERT INTO buk_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","bu aö dauŋ oc wanem mac sa, ma wakêŋ yom ti gauc têŋ mac. Ma mac nem ŋacyo oc sêtôm dom bu sêô mac nem yom me sêseŋ mac nem yom. ");
INSERT INTO buk_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Dinami ti damami, ma asidôwai ma silip naŋ sêkêŋ whiŋ dom, naŋ oc sêhoc mac nem lau ŋatô asê, ma sêndic ŋatô ndu. ");
INSERT INTO buk_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tu aö-ŋga dec lau hoŋ oc sêtec mac. ");
INSERT INTO buk_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tigeŋ Anötö oc yob mac e nem kêclauŋ ŋandô daŋ niŋga dom. ");
INSERT INTO buk_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Magoc alhac ŋaŋga ma ahu aö siŋ dom, ma Anötö oc kôc mac sa andöc tamli ŋapaŋ yêc undambê.” ");
INSERT INTO buk_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Têŋ ndoc mac alic lau siŋ-ŋga sêŋgihi Jerusalem ahuc, naŋ dec aŋyalê bu ŋasawa sauŋ ma ŋac oc sêseŋ malac atu dau su. ");
INSERT INTO buk_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Têŋ ndoc dinaŋ, mac lau naŋ ambo gameŋ Judia-ŋga naŋ alhö ŋagahô api gameŋ lôc-ŋga andi. Lau naŋ sêmbo Jerusalem, naŋ sêhu malac dau siŋ, ma lau naŋ sêmbo gameŋ ŋamakê-ŋga naŋ sêsôc malac atu dau tiyham dom. ");
INSERT INTO buk_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Yom hoŋ naŋ lau propet sêhoc asê gwanaŋ pi ŋagêyô naŋ oc tap lau nom-ŋga sa, naŋ oc ŋandô sa têŋ têm dinaŋ. ");
INSERT INTO buk_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Oyaê. Lauwhê naŋ daê ma lauwhê naŋ sêkêŋ su têŋ balêkoc, naŋ oc sêtap ŋawapac atu sa têŋ têm dinaŋ. Ŋawapac atu oc hôc asê nom, ma lau Israel-ŋga oc sêŋsahê ŋacyo si atac ŋandê. ");
INSERT INTO buk_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Lau gameŋ apa-ŋga oc sêndic lau Israel-ŋga ŋatô ndu ŋa bieŋ baliŋ, ma sêŋgaho ŋatô su ma sêwê ŋac sêtêŋ lau apa si gameŋ sêndi sêtôm lau gapocwalô-ŋga. Anötö kêmatiŋ têm bu lau gameŋ apa-ŋga sêŋgwiniŋ lau Jerusalem-ŋga, ma ŋac oc sêkôm e têm dau pacndê.” ");
INSERT INTO buk_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Lau oc sêlic gêŋ dalô ac-ŋga ti ayô-ŋga ma tata-ŋga. Ma yêc nom, gwêc oc li dau sa atu, ma kôm lau si gauc êŋsôŋ ma ŋalôm ŋawapac atu. ");
INSERT INTO buk_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Gêŋ ti ŋaclai naŋ sêlhac umboŋ oc wiwic sa, ma tu dinaŋ-ŋga lau oc sêtöc dau e ŋac tagôlô ma sêhêgo dau tu gêŋ bocke naŋ oc hôc asê nom-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Têŋ ndoc dinaŋ lau oc sêlic Ŋamalac ndê Atu mbu meŋ ndöc dao ŋahô ti ŋaclai ma ŋawasi atu. ");
INSERT INTO buk_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Têŋ ndoc gêŋ kaiŋ dinaŋ bu meŋ sa, naŋ atisa ma tamtac, bu mac nem ndoc bu atap Anötö ndê mwasiŋ nem mac si-ŋga ŋa-ŋandô sa, naŋ meŋ kêpiŋ.” ");
INSERT INTO buk_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ma Yisu sôm yom gôliŋ daŋ bocdec, “Gauc nem a laŋ ma a ŋatô. ");
INSERT INTO buk_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Têŋ ndoc mac alic ŋalauŋ wakuc bu lêc, naŋ mac aŋyalê bu ndoc ac-ŋga meŋ kêpiŋ. ");
INSERT INTO buk_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ma bocdinaŋ têŋ ndoc mac alic gêŋ naŋ aö gasôm yom pi, naŋ hôc asê, dec aŋyalê bu ndoc meŋ kêpiŋ bu Anötö ndê gôliŋ meŋ sa tiawê. ");
INSERT INTO buk_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Yomandô! Lau têm dinaŋ-ŋga oc sêmbac ndu dom e gêŋ hoŋ dinaŋ hôc asê. ");
INSERT INTO buk_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Undambê ti nom oc niŋga, tigeŋ aneŋ yom daŋ oc niŋga dom.” ");
INSERT INTO buk_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Ma Yisu sôm, “Oc tôm dom bu ŋamalac daŋ êŋlêc bêc ŋambu-ŋga dau. Bocdinaŋ dec amasaŋ daôm ŋapep ma anem ali. Ayob bu anôm gêŋ êŋiŋ mac-ŋga ma aneŋ gêŋ ŋawahô me apô sim daôm tu ŋawapac nom-ŋga êŋlêc dom, bu mboe gêŋ dau oc hê nem gauc dôŋ têŋ têm bêc ŋambu-ŋga dau meŋ sa. Bu bêc dau oc hôc asê mac ŋagahô, tôm bôc daŋ sip akô sep eŋ. ");
INSERT INTO buk_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Anem ali ma ateŋ mbec bu Anötö kêŋ licwalô têŋ mac bu ŋawapac hoŋ naŋ oc sêhôc asê, naŋ ku mac dulu dom, ma bu mac oc atôm bu alhac Ŋamalac ndê Atu aŋgô-ŋga ti mayam pac.” ");
INSERT INTO buk_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Têŋ ŋasawa dinaŋ Yisu kêdôhôŋ lau mbo lôm dabuŋ ŋabatêmndö têŋ acsalô, ma iŋ sa gi yêc Lôc Olib têŋ ôbwêc. ");
INSERT INTO buk_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tôm bêc hoŋ lau daêsam sêtêŋ lôm dabuŋ si têŋ bêbêc ganduc, bu ŋac atac whiŋ bu sêŋgô Yisu ndê yom. ");
INSERT INTO buk_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lau Israel si †Mwasiŋ Bolom Yist Mba-ŋga naŋ lau sêsam bu Mwasiŋ Pasowa-ŋga, naŋ meŋ kêpiŋ. ");
INSERT INTO buk_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ma dabuŋsiga atu-tu ti kêdôhôŋwaga yomsu-ŋga sêŋsalê lêŋ bu sêndic Yisu ndu gelec, ŋahu bu sêtöc lau. ");
INSERT INTO buk_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Têŋ ndoc dinaŋ Sadaŋ sip Judas ndê ŋalôm. Iŋ ŋgac naŋ sêsam bu Iskeriot, ma iŋ ŋgacsêŋomi 12 si daŋ. ");
INSERT INTO buk_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Iŋ têŋ dabuŋsiga atu-tu ti lau siŋ-ŋga naŋ sêyob lôm dabuŋ, naŋ gi, ma ŋac sem yomgalôm pi lêŋ tu Judas hoc Yisu asê têŋ ŋac-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Goc ŋac atac ŋayham, ma sêsôm tidôŋ bu sênemlhi iŋ ŋa mone. ");
INSERT INTO buk_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas gôlôc ma kêsalê ndoc bocke naŋ lau daêsam oc sêmbo sêwhiŋ Yisu dom, dec oc tôm bu iŋ hoc Yisu asê. ");
INSERT INTO buk_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mwasiŋ Bolom Yist Mba-ŋga ŋabêc naŋ lau Israel sic domba Pasowa-ŋga ndu, naŋ meŋ hôc asê. ");
INSERT INTO buk_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ma Yisu kêkiŋ Pita lu Jon ma sôm, “Amlu andi ma amasaŋ Mwasiŋ Pasowa-ŋga bu daneŋ.” ");
INSERT INTO buk_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ma sêndac iŋ, “Am tac whiŋ bu alu amasaŋ Pasowa yêc nde?” ");
INSERT INTO buk_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ma Yisu sôm têŋ iŋlu, “Asôc Jerusalem andi, ma amlu oc atap ŋgac daŋ sa, naŋ hôc bu lôŋ daŋ. Aŋkuc iŋ atêŋ iŋ ndê ŋadau ndê andu andi, ");
INSERT INTO buk_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ma asôm têŋ andu ŋadau, ‘Alu mba kêdôhôŋwaga ndac am pi ŋalôm ŋacleŋ-ŋga, bu iŋ ti ndê ŋgacsêŋomi bu sêneŋ Mwasiŋ Pasowa-ŋga yêc am nem andu.’ ");
INSERT INTO buk_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ma iŋ oc tôc ŋalôm atu daŋ yêc andu dau ŋahô-ŋga têŋ amlu. Tebo ti gêŋ hoŋ tu yac daneŋ Mwasiŋ Pasowa-ŋga yêc ŋalôm dinaŋ, goc amlu amasaŋ gêŋ yêc ŋalôm dinaŋ.” ");
INSERT INTO buk_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Goc iŋlu sêsôc Jerusalem si ma sêtap gêŋ hoŋ sa gitôm Yisu sôm têŋ iŋlu, ma sêmasaŋ mwasiŋ Pasowa-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Têŋ ôbwêc dinaŋ, Yisu ndöc tebo whiŋ lau aposel bu sêneŋ Mwasiŋ Pasowa-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ma iŋ sôm têŋ ŋac, “Ŋasawa sauŋ aö oc wahôc ŋandê atu, magoc aö atac whiŋ bu waneŋ Mwasiŋ Pasowa-ŋga dindec wawhiŋ mac muŋ. ");
INSERT INTO buk_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Bu aö wasôm têŋ mac, aö waneŋ Mwasiŋ Pasowa-ŋga tiyham dom e Anötö ndê gôliŋ meŋ sa tiawê, ma Pasowa dau ŋa-ŋandô meŋ sa.” ");
INSERT INTO buk_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Goc iŋ kôc laclhu wain-ŋga daŋ, gêm daŋge ma sôm, “Akôc ma akêŋ lom têŋ daôm. ");
INSERT INTO buk_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Aö wasôm têŋ mac bu aö oc wanôm wain tiyham dom e Anötö ndê gôliŋ meŋ sa tiawê.” ");
INSERT INTO buk_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ma iŋ kôc bolom, gêm daŋge ma pô kôc, goc gic sam têŋ ŋac ma sôm, “Aö neŋ ŋandô dau dec, naŋ gakêŋ tu mac-ŋga. Aneŋ gêŋ dindec tu bu gauc nem aö-ŋga.” ");
INSERT INTO buk_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ŋac seŋ gêŋ pacndê, goc ŋalêŋ tigeŋ iŋ kôc laclhu wain-ŋga daŋ ma sôm, “Laclhu dindec ti dôhôŋ pwac wakuc aneŋ dac-ŋga, naŋ wakêc siŋ tu mac-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Tigeŋ aŋgô! Ŋgac naŋ bu hoc aö asê, naŋ gêŋ gêŋ ndöc tebo whiŋ aö. ");
INSERT INTO buk_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Bu gêŋ naŋ oc hôc asê Ŋamalac ndê Atu, naŋ kêkuc lêŋ naŋ Anötö kêmasaŋ gwanaŋ su, tigeŋ ŋgac naŋ hoc aö asê, naŋ oc tap ŋagêyô atu sa. Oyaê!” ");
INSERT INTO buk_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Goc ŋac hoŋ sêndac dandi pi ŋac si asa oc kôm gêŋ dau. ");
INSERT INTO buk_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ma têŋ ndoc dinaŋ ŋgac-sêŋomi sêseŋ dau bu ŋac si asa ti ŋgac ŋamata-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Goc Yisu sôm têŋ ŋac, “Lau sambuc si kiŋ sêtoc dau sa têŋ ŋac si lau, ma lau naŋ sem gôliŋ lau, naŋ sêsam dau bu lau ŋamata-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Magoc mac aŋkuc mêtê kaiŋ dinaŋ dom. Mac nem asa iŋ ŋgac tiwaê, naŋ êŋgwiniŋ dau ti ŋgac waêmba. Ma asa iŋ ŋgac ŋamata-ŋga, naŋ ti ŋgac akiŋ ŋambwa. ");
INSERT INTO buk_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mac gauc gêm bocke? Ŋgac naŋ ndöc tebo, ma ŋgac naŋ gêm akiŋ iŋ, naŋ iŋlu si asa ti ŋgac ŋamata-ŋga? Yêc ŋamalac aŋgô-ŋga, ŋgac naŋ ndöc tebo iŋ ŋgac ŋamata-ŋga. Tigeŋ aö gambo gawhiŋ mac gitôm ŋgac akiŋ. ");
INSERT INTO buk_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ndoc bocke naŋ ŋawapac me kisa tap aö sa su, naŋ mac ahu aö siŋ dom. ");
INSERT INTO buk_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Bocdinaŋ tiŋambu aö wakêŋ mac anem gôliŋ lau, gitôm Damaŋ kêŋ ŋaclai tu wanem gôliŋ-ŋga sip aö dauŋ amaŋ. ");
INSERT INTO buk_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ma mac oc aneŋ ti anôm gêŋ awhiŋ aö yêc gameŋ undambê-ŋga, ma mac oc andöc pôŋ atu ma amatôc Israel si lau ŋatoŋ 12.” ");
INSERT INTO buk_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ma Yisu gic têku yom ma sôm, “Saimon, Saimon, Sadaŋ ndac bu êŋsahê mac nem akêŋ whiŋ bu gêŋ ŋandô me mba, gitôm lau sêwhê wit ŋapa ti ŋandô kôc. ");
INSERT INTO buk_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tigeŋ aö gateŋ mbec tu am-ŋga Saimon, bu am oc hu nem kêŋ whiŋ siŋ dom. Ma tiŋambu têŋ têm am nem daôm kwi, naŋ puc nem asidôwai dôŋ.” ");
INSERT INTO buk_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Dec Pita sôm, “Pômdau, tôm ŋac sêkêŋ hêclu dasôc gapocwalô, me sêndic hêclu ndu, aö wahu am siŋ dom.” ");
INSERT INTO buk_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ma Yisu sôm, “Pita, aö wasôm têŋ am, ôbwêc dec am oc sêc aö ahuc tidim tö, ma tiŋambu dalec oc taŋ.” ");
INSERT INTO buk_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Goc Yisu ndac ŋac, “Têŋ ndoc aö kakiŋ mac asa a bu anem mêtê lau, naŋ mac akôc talhi mone-ŋga, ti gata, ma atapa dom. Têŋ ndoc dinaŋ mac apônda daôm, me mba?” Ma ŋac sêsôm, “Mba.” ");
INSERT INTO buk_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Goc Yisu sôm, “Kwahic dec ma ndi, mac nem talhi mone-ŋga me gata bu yêc, naŋ akôc sa. Ma mac nem bieŋ baliŋ bu mbasi, dec akêŋ nem ŋakwê awê-ŋga têŋ lau sênemlhi, goc akôc ŋa-awa ma anemlhi bieŋ baliŋ daŋ. ");
INSERT INTO buk_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Bu sêto yom daŋ yêc bocdec bu, ‘Sêlic iŋ gitôm lau sac si daŋ.’ Yom dau hêganôŋ aö, ma gic waê bu ŋandô sa. Yomandô, yom naŋ sêto pi aö, naŋ oc ŋandô sa.” ");
INSERT INTO buk_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ma ŋgacsêŋomi sêsôm, “Pômdau lic! Bieŋ baliŋ lu dec sêyêc.” Ma Yisu sôm, “Gitôm.” ");
INSERT INTO buk_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yisu ti ndê ŋgacsêŋomi sêhu malac Jerusalem siŋ, ma sêsa sêtêŋ Lôc Olib si. Têm daêsam su sêkac sa sêmbo gameŋ dinaŋ. ");
INSERT INTO buk_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Iŋ hôc asê ma sôm têŋ ŋac, “Ateŋ mbec bu lêtôm tap mac sa dom.” ");
INSERT INTO buk_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Goc iŋ hu ŋac siŋ ma sa ŋasawa sauŋ gi, pôŋ haduc ma teŋ mbec bocdec bu, ");
INSERT INTO buk_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Damaŋ, am bu tac whiŋ, dec kôc laclhu ŋawapac-ŋga dindec su yêc aö. Tigeŋ êmkuc aneŋ tac whiŋ dom, kôm tôm am daôm nem atac whiŋ bu kôm.” ");
INSERT INTO buk_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ma aŋela undambê-ŋga daŋ hoc dau asê têŋ iŋ, ma kôm iŋ licwalô sa. ");
INSERT INTO buk_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yisu pô sim dau ŋandô, ma teŋ mbec ŋaŋga, ma iŋ ndê waheŋ kêc sip nom gitôm dac. ");
INSERT INTO buk_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Iŋ teŋ mbec su, goc tisa ma mbu têŋ iŋ ndê ŋgacsêŋomi gi, ma gêlic bu ŋac sêyêc bêc sêyêc. Ŋac si ŋalôm ŋawapac kôm ŋac kwapac. ");
INSERT INTO buk_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ma iŋ uŋ ŋac sa goc ndac ŋac, “Tu sake-ŋga mac ayêc bêc ayêc? Atisa mac ateŋ mbec bu lêtôm tap mac sa dom.” ");
INSERT INTO buk_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yisu sôm yom dau mbo, ma ŋgacsêŋomi 12 si daŋ, naŋ sêsam bu Judas, naŋ hôc asê ma wê lau toŋ atu sêwhiŋ iŋ. Iŋ kêsêlêŋ têŋ Yisu bu ŋgutô iŋ, ");
INSERT INTO buk_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","magoc Yisu ndac iŋ, “Judas, bocke? Am bu ŋgutô Ŋamalac ndê Atu tu bu hoc iŋ asê, a?” ");
INSERT INTO buk_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Lau naŋ sêmbo sêwhiŋ Yisu, naŋ sêlic gêŋ naŋ bu hôc asê ma sêndac, “Pômdau, yac andic ŋac ŋa bieŋ, a?” ");
INSERT INTO buk_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ma ŋac si daŋ puc ndê bieŋ sa ma pa dabuŋ-siga ŋamata-ŋga ndê ŋgac akiŋ ndê daŋgalauŋ andô-ŋga su. ");
INSERT INTO buk_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Magoc Yisu sôm, “Akôm bocdinaŋ dom!” Ma iŋ kêmasec ŋgac dau ndê daŋgalauŋ, ma kôm iŋ ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Goc Yisu sôm têŋ dabuŋsiga atu-tu ti lau bata, ma lau siŋ sêyob lôm dabuŋ-ŋga, naŋ sêmeŋ bu sêkôc iŋ dôŋ, “Bocke dec mac akôc bieŋ ti gêŋ siŋ-ŋga ma asa ameŋ bu akôc aö dôŋ gitôm ŋgac kaŋ daŋ? ");
INSERT INTO buk_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tôm bêc hoŋ aö gambo gawhiŋ mac yêc lôm dabuŋ ŋagameŋ, ma mac akôc aö dôŋ dom. Tigeŋ kwahic dec ti mac nem ndoc, ma ŋaclai ŋasec-ŋga gêm gôliŋ mac.” ");
INSERT INTO buk_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ŋac sêkôc Yisu dôŋ, ma sêwê iŋ sêtêŋ dabuŋsiga ŋamata-ŋga ndê andu si. Ma Pita kêkuc ŋac mbo ahê. ");
INSERT INTO buk_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yêc dabuŋsiga dau ndê andu ŋatuŋlôm, lau ŋatô sêkôm ya golom asê, goc sêndöc sêwhiŋ dau ma sêŋsulu. Ma Pita gi ndöc sic whiŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Awhê akiŋ daŋ gêlic Pita ndöc ya ŋawê, goc tahê iŋ ma sôm, “Iŋ ŋgac dindec iŋ kêkuc Yisu whiŋ.” ");
INSERT INTO buk_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tig eŋ Pita pa dau ma sôm, “Awhê! Aö kayalê iŋ dom!” ");
INSERT INTO buk_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ŋasawa sauŋ ma ŋamalac daŋ gêlic iŋ ma sôm, “Am lau naŋ sêŋkuc iŋ, naŋ si ŋgac daŋ!” Ma Pita ô yom ma sôm, “Am ŋgac, mba!” ");
INSERT INTO buk_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Acgatu ŋasawa daŋ meŋ gi su, ma ŋamalac daŋ tiyham sôm ti ŋaŋga, “Ŋgac dindec iŋ kêkuc Yisu whiŋ! Yomandô! Bu iŋ ŋgac Galili-ŋga.” ");
INSERT INTO buk_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Magoc Pita sôm, “O ŋgac daôm! Aö kayalê yom naŋ am sôm, naŋ ŋahu dom!” Iŋ sôm yom dinaŋ mbo, ma mbac dalec taŋ. ");
INSERT INTO buk_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ma Pômdau kac dau kwi ma tahê Pita, ma Pita gauc gêm yom naŋ Pômdau sôm têŋ iŋ bocdec bu, “Ôbwêc dindec am oc sêc aö ahuc tidim tö, ma tiŋambu mbac dalec oc taŋ.” ");
INSERT INTO buk_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Goc iŋ sa awê gi, ma taŋ dau ndu. ");
INSERT INTO buk_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Lau siŋ-ŋga naŋ sêkôc Yisu dôŋ, naŋ sic hu sêsu iŋ susu. Sêkic iŋ tandô ahuc ŋa po, goc sêtap iŋ ma sêndac, “Am bu propet, dec sôm asê bu asa dec tap am?” ");
INSERT INTO buk_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ma sêpu iŋ ti sêŋgwiniŋ iŋ ŋa yom sac daêsam. ");
INSERT INTO buk_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Têŋ bêbêc ganduc lau bata Israel-ŋga, ma dabuŋsiga atu-tu ti lau Skraib sêkac sa sêpitigeŋ, ma sêkêŋ Yisu kalhac ŋac aŋgô-ŋga. Ŋac sêsôm têŋ iŋ, ");
INSERT INTO buk_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Am bu Mesaya dau, dec sôm têŋ yac!” Ma Yisu sôm têŋ ŋac, “Aö bu wasôm, dec mac oc akêŋ whiŋ aö dom, ");
INSERT INTO buk_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ma aö bu wakêŋ gêndac daŋ têŋ mac, dec mac oc aô aneŋ yom dom. ");
INSERT INTO buk_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tigeŋ, têŋ kwahic dec ma ndi, Ŋamalac ndê Atu oc ndöc Anötö Ŋaclai Ŋadau ndê amba andô-ŋga.” ");
INSERT INTO buk_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ma ŋac hoŋ sêsôm, “Bocdinaŋ, am sôm bu am Anötö ndê Atu, a?” Ma Yisu sôm, “Mac asôm solop bu aö dauŋ dindec.” ");
INSERT INTO buk_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Goc sêsôm têŋ dandi, “Yac daŋgô yom naŋ iŋ dau sôm su. Dapônda yom daŋ tu taŋgôliŋ pi iŋ-ŋga dom.” ");
INSERT INTO buk_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Goc lau hoŋ dinaŋ sêtisa ma sêwê Yisu sêtêŋ Pailot si. ");
INSERT INTO buk_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ma ŋac sêŋgôliŋ yom pi iŋ, ma sêsôm, “Ŋgac dindec gêli lau Israel-ŋga ŋalôm sa. Iŋ sôm bu lau sêkêŋ takis têŋ Sisa dom, ma iŋ toc dau sa ma sam dau bu Mesaya, kiŋ naŋ lau Israel-ŋga sêkêŋ bata.” ");
INSERT INTO buk_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Goc Pailot ndac Yisu bocdec bu, “Am lau Israel-ŋga si kiŋ, a?” Ma Yisu sôm, “Tôm naŋ am daôm sôm.” ");
INSERT INTO buk_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Dec Pailot sôm asê têŋ dabuŋsiga atu-tu ti lau hoŋ, “Aö gatap ŋgac dindec ndê giso daŋ sa dom, bu tamatôc iŋ pi-ŋga.” ");
INSERT INTO buk_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tigeŋ ŋac sêsôm ti ŋaŋga, “Iŋ kêdôhôŋ lau ma gêli ŋac si ŋalôm sa yêc gameŋ Judia-ŋga hoŋ. Iŋ gic hu yêc gameŋ Galili-ŋga ma kôm ŋapaŋ e meŋ têŋ gameŋ dindec.” ");
INSERT INTO buk_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Têŋ ndoc Pailot ŋgô yom dinaŋ, naŋ iŋ ndac ŋac bu Yisu iŋ ŋgac Galili-ŋga, me mba. ");
INSERT INTO buk_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ma iŋ tap sa bu iŋ ŋgac Galili-ŋga, dec kêkiŋ iŋ têŋ Herod gi. Herod iŋ ŋgac naŋ gêm gôliŋ gameŋ Galili-ŋga, ma iŋ mbo malac Jerusalem têŋ têm dinaŋ. ");
INSERT INTO buk_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Têŋ têm Herod gêlic Yisu, naŋ iŋ tac ŋayham atu, bu ŋasawa baliŋ su iŋ tac whiŋ bu lic iŋ. Iŋ ŋgô ŋawaê pi Yisu su, ma kêŋ bata bu lic iŋ kôm gêŋ dalô daŋ. ");
INSERT INTO buk_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Iŋ kêŋ gêndac daêsam têŋ Yisu, magoc Yisu ô yom dom. ");
INSERT INTO buk_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Têŋ dinaŋ dabuŋsiga atu-tu ti lau Skraib sêtisa ma sêŋgôliŋ yom pi iŋ ti ŋaŋga. ");
INSERT INTO buk_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Goc Herod ti lau siŋ-ŋga sêsu Yisu susu ma sêŋgwiniŋ iŋ. Sêkêŋ iŋ sôc ŋakwê baliŋ gitôm kiŋ sêsôc, ma sêŋkiŋ iŋ mbu têŋ Pailot gi. ");
INSERT INTO buk_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Muŋ-ŋga Herod lu Pailot sêkêŋ kisa dau, magoc acsalô dinaŋ iŋlu sêhê silip dandi. ");
INSERT INTO buk_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailot mbwêc dabuŋsiga atu-tu ti lau bata ma lau Israel-ŋga ŋatô sêpitigeŋ, ");
INSERT INTO buk_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ma sôm têŋ ŋac, “Mac akôc ŋgac dau atêŋ aö ameŋ, ma asôm bu iŋ gêli lau ŋalôm sa. Aö kasahê iŋ yêc mac aŋôm-ŋga, ma gatap sa bu yom naŋ mac aŋgôliŋ pi iŋ, naŋ ŋahu mba. ");
INSERT INTO buk_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ma Herod bocdinaŋ, bu iŋ kêkiŋ iŋ mbu têŋ yac meŋ. Bocdinaŋ wasôm têŋ mac bu ŋgac dau kôm giso daŋ dom bu dandic iŋ ndu. ");
INSERT INTO buk_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Tu dinaŋ-ŋga aö wakêŋ aneŋ lau sêhi iŋ ŋa sö, ma sêhu iŋ siŋ lhö ndi.” ");
INSERT INTO buk_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Magoc ŋac sêmbwêc atu sêwhiŋ dau bu, “Kôc iŋ sa ma ndic iŋ ndu! Ma hu Barabas siŋ têŋ yac.” ");
INSERT INTO buk_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas iŋ ŋgac naŋ ndöc gapocwalô têŋ ndoc dinaŋ, bu iŋ kêgilí lau bu sêndic siŋ, ma iŋ gic lau ŋatô ndu. ");
INSERT INTO buk_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Magoc Pailot tac whiŋ bu êŋgapwêc Yisu su, dec sôm yom ŋaŋga tiyham bu nem ŋac si ŋalôm kwi. ");
INSERT INTO buk_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Magoc ŋac sêmbwêc yom ŋapaŋ, “Ndic iŋ pi a gicso dau! Ndic iŋ pi a!” ");
INSERT INTO buk_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Goc Pailot sôm têŋ ŋac tidim tö-ŋga, “Tu sake-ŋga? Iŋ kôm giso bocke? Aö gatap yom daŋ sa pi iŋ dom, bu dandic iŋ ndu. Bocdinaŋ aö wakêŋ aneŋ lau siŋ-ŋga sêndic iŋ ŋamlic ŋandê, ma wahu iŋ siŋ.” ");
INSERT INTO buk_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tigeŋ ŋac sêmbwêc hôc ahuc ŋapaŋ, bu sêndic iŋ pi a gicso dau. Ma sêmbwêc yom dau e Pailot sôc ŋapu. ");
INSERT INTO buk_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Iŋ gôlôc ma sôm têŋ lau siŋ-ŋga bu sêkôm gitôm lau dau si yom. ");
INSERT INTO buk_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Barabas, ŋgac siŋsêlêc naŋ ndöc gapocwalô tu iŋ gic lau ndu-ŋga, naŋ sêŋgapwêc iŋ su tôm lau sêndac. Magoc Yisu, naŋ sêtec, naŋ Pailot kêkiŋ iŋ têŋ lau siŋ-ŋga bu sêndic iŋ ndu. ");
INSERT INTO buk_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ŋac sêwê Yisu sêsa si, ma yêc seŋ sêtap ŋgac daŋ ŋaê Saimon sa. Iŋ ŋgac malac Sairin-ŋga, ma iŋ kêsêlêŋ mbo seŋ akêŋ gameŋ ŋamakê-ŋga bu têŋ Jerusalem ndi. Lau siŋ-ŋga sêkôc Saimon ma sêkêŋ iŋ kêbalaŋ a gicso dau kêkuc Yisu. ");
INSERT INTO buk_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lau daêsam sêŋkuc Yisu si, ma lauwhê ŋatô sêwhiŋ ŋac, sêhu daŋgibo asê pi iŋ ma sêtaŋ. ");
INSERT INTO buk_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Goc Yisu kac dau kwi ma sôm têŋ ŋac, “Mac lauwhê Jerusalem-ŋga, ataŋ aö dom! Tigeŋ ataŋ tu daôm-ŋga, ma tu mac nem balêkoc-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bu ndoc ŋawapac-ŋga oc meŋ sa, naŋ mac oc asôm bu iŋ gêŋ ŋayham bu lauwhê ŋatô ŋac lauwhê gapoc ma sêkôc balêkoc me sêkêŋ su têŋ balêkoc dom. ");
INSERT INTO buk_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Têŋ ndoc dinaŋ, lau oc tac whiŋ bu lôc daŋ tip meŋ ma êŋgatöc ŋac si. ");
INSERT INTO buk_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Gêŋ naŋ kwahic dec sêkôm têŋ aö, naŋ gitôm sêkêŋ ya gêŋ a batac. Bocdinaŋ ahêgo daôm pi gêŋ ŋac oc sêkôm tiŋambu-ŋga, oc nditôm sêkêŋ ya neŋ a basô.” ");
INSERT INTO buk_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Lau siŋ-ŋga sêwê ŋgac sac lu sêwhiŋ Yisu, bu sêndic iŋlu ndu sêwhiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ŋac sêsa si e sêhôc asê gameŋ naŋ sêsam bu Ŋakêcyha, ma yêc dinde ŋac sic Yisu pi a gicso dau. Ma sic ŋgac sac lu sêpi a gicso sêwhiŋ Yisu, daŋ kêgalêŋ andô-ŋga, ma daŋ kêgalêŋ gasê-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Têŋ dinaŋ Yisu teŋ mbec ma sôm, “Damaŋ, suc aneŋ ŋacyo si sac kwi, bu ŋac sêŋyalê gêŋ naŋ sêkôm, naŋ dom.” Tiŋambu lau siŋ-ŋga sêpuc gapoc bu sêlic ŋac si asa oc kôc Yisu ndê ŋakwê. ");
INSERT INTO buk_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Lau daêsam sêlhac ma tahê Yisu, ma lau bata Israel-ŋga bocdinaŋ. Sêlhac ti sem tô iŋ ma sêsôm, “Iŋ gêm lau ŋatô sa. Iŋ bu Mesaya naŋ Anötö kêyaliŋ sa, naŋ nem dau si maŋ.” ");
INSERT INTO buk_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ma lau siŋ-ŋga sêtigasuc ma sêsu iŋ susu boc-dinaŋ. Sêkêŋ wain ŋamakic têŋ iŋ, ");
INSERT INTO buk_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ma sêsôm, “Am bu lau Israel-ŋga si kiŋ, naŋ goc nem daôm si.” ");
INSERT INTO buk_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ŋac sêto yom kalhac iŋ ndê a gicso dau ŋahô, naŋ sôm, ‘Lau Israel-ŋga si Kiŋ dindec.’ ");
INSERT INTO buk_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ŋgac sac daŋ naŋ kêgalêŋ a gicso dau kêpiŋ Yisu, naŋ su iŋ susu ma sôm, “Am Mesaya dau, a? Bocdinaŋ dec nem daôm si, ma nem alu si awhiŋ!” ");
INSERT INTO buk_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tigeŋ ŋgac sac tilu-ŋga hec yom iŋ, ma ndac, “Am töc Anötö, me mba? Yac lau tö dakôc ŋagêyô tigeŋ. ");
INSERT INTO buk_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Hêclu dakôc ŋagêyô solop, bu hêclu dakôm sac. Magoc ŋgac dindec kôm giso daŋ dom.” ");
INSERT INTO buk_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Goc iŋ sôm têŋ Yisu, “Yisu, têŋ ndoc am ndöc nem pôŋ kiŋ-ŋga, naŋ gauc nem aö.” ");
INSERT INTO buk_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ma Yisu ô yom ma sôm têŋ iŋ, “Aö wasôm yomandô têŋ am bu acsalô lec am oc ndöc †Paradais whiŋ aö.” ");
INSERT INTO buk_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Têŋ ac kalhac lhu, ŋasec gêm gameŋ sambuc ahuc e acgatu gitôm 3 kilok telha-ŋga, ");
INSERT INTO buk_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","bu ac gêm ganduc. Ma po baliŋ naŋ kêgalêŋ lôm dabuŋ ŋalôm, naŋ dau kic gi lu. ");
INSERT INTO buk_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Têŋ ndoc dinaŋ Yisu mbwêc awha atu ma sôm, “Damaŋ, aö gakêŋ aneŋ gatuŋ sip am amam!” Iŋ sôm yom dinaŋ su, goc mbac ndu. ");
INSERT INTO buk_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ŋgac bata siŋ-ŋga gêlic gêŋ hoŋ dinaŋ, ma kêpiŋ Anötö ma sôm, “Yomandô! Ŋgac dindec iŋ ŋgac gitêŋ!” ");
INSERT INTO buk_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ma lau daêsam naŋ sêkac sa su bu sêlic lau siŋ-ŋga sic Yisu pi a gicso dau, naŋ sêlic gêŋ hoŋ dinaŋ e kôm ŋac si ŋalôm ŋawapac, dec sêndahiŋ ŋasu ma sêlhö si. ");
INSERT INTO buk_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ma lau hoŋ naŋ sêŋyalê Yisu, ma lauwhê naŋ sêŋkuc iŋ akêŋ gameŋ Galili-ŋga, naŋ sêlhac ahê ma sêlic gêŋ dinaŋ. ");
INSERT INTO buk_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ŋgac daŋ mbo, naŋ ndê ŋaê Josep. Iŋ ndê malac Arimatiya yêc gameŋ Judia-ŋga, ma iŋ ŋgac ŋayham ma gitêŋ naŋ kêŋ bata Anötö ndê gôliŋ bu meŋ sa tiawê. Iŋ lau †Sanedrin-ŋga si daŋ, tigeŋ iŋ ŋalôm whiŋ yom naŋ ŋac sêkic pi Yisu bu sêndic iŋ ndu, ti gêŋ naŋ sêkôm têŋ iŋ, naŋ dom. ");
INSERT INTO buk_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Têŋ telha dinaŋ iŋ têŋ Pailot gi, ma ndac Yisu ndê ŋamlaŋ. ");
INSERT INTO buk_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Goc iŋ kôc iŋ su yêc a gicso dau, kêpaŋ iŋ ŋa po ŋayham daŋ, ma kêŋ iŋ yêc sêhô daŋ. Lau sêlêŋ sêhô dinaŋ gwanaŋ su yêc hoc daŋ ŋalôm, ma sêkêŋ ŋgac batê daŋ yêc sêhô dau muŋ su dom. ");
INSERT INTO buk_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","55","Lauwhê naŋ muŋ-ŋga sêŋsêlêŋ sêwhiŋ Yisu têŋ ndoc iŋ meŋ akêŋ gameŋ Galili-ŋga, naŋ sêŋkuc Josep si, ma sêlic sêhô dinaŋ ti gameŋ naŋ Josep kêŋ Yisu ndê ŋamlaŋ yêc naŋ. Tigeŋ bêc dinaŋ iŋ lau Israel si bêc sêmasaŋ dau tu sêlic om-ŋga, ma ndoc Sabat-ŋga meŋ kêpiŋ. ");
INSERT INTO buk_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bocdinaŋ lauwhê dinaŋ sêmbu sêtêŋ si andu si, ma sêmasaŋ bu ŋamalu ti gêŋ ŋatô bu sênem oso Yisu. Ma têŋ bêc Sabat-ŋga, ŋac sêŋwhaŋ dau tôm yomsu Sabat-ŋga sôm. ");
INSERT INTO buk_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sabat meŋ gi su, ma têŋ wake ŋabêc ŋamata-ŋga, goc lauwhê dinaŋ sêti têŋ bêbêc ganduc. Sêkôc gêŋ ŋamalu naŋ sêmasaŋ su, ma sêsa sêtêŋ sêhô dau si. ");
INSERT INTO buk_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ma sêlic bu hoc atu naŋ Josep kêpi gi tiŋ sê awha, naŋ ndöc ŋamala dom. ");
INSERT INTO buk_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Dec sêsôc si, magoc sêtap Pômdau Yisu ndê ŋamlaŋ sa dom. ");
INSERT INTO buk_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Sêlhac ma sêhêdaê, ma ŋgac lu ti ŋakwê ŋawasi atu, sêhoc dau asê ma sêlhac sêwhiŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Dec lauwhê sêtöc dau, ma sêwec aŋgô andô têŋ nom. Ma ŋgac lu sêsôm têŋ ŋac, “Tu sake-ŋga mac aŋsalê iŋ naŋ mbo tali, yêc lau batê si mala? ");
INSERT INTO buk_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Iŋ mbo lec dom, iŋ tisa su. Gauc nem yom naŋ iŋ sôm têŋ mac muŋ su, têŋ têm iŋ mbo gameŋ Galili-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Iŋ sôm bu lau oc sêhoc Ŋamalac ndê Atu asê ma sêkêŋ iŋ sip lau sac si amba, ma ŋac oc sêndic iŋ pi a gicso dau, ma têŋ bêc titö-ŋga iŋ oc tisa tiyham.” ");
INSERT INTO buk_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Goc lauwhê dinaŋ gauc gêm yom naŋ Yisu sôm muŋ su. ");
INSERT INTO buk_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ma ŋac sêhu sêhô dau siŋ ma sêmbu sêtêŋ Jerusalem si, ma sic miŋ yom hoŋ dinaŋ têŋ ŋgacsêŋomi 11, ma têŋ lau hoŋ naŋ muŋ-ŋga sêŋkuc Yisu. ");
INSERT INTO buk_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Lauwhê dau si ŋaê bocdec. Maria Magadala, Joana, ma Jems dinda Maria, ma lauwhê ŋatô sêwhiŋ. Ŋac sic miŋ têŋ lau aposel, ");
INSERT INTO buk_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","magoc aposel sêŋgô yom dau gitôm yom ŋambwa, ma sêkêŋ whiŋ dom. ");
INSERT INTO buk_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Goc Pita tisa ma kêti têŋ sêhô gi. Iŋ wec bu tôc gwaniŋ sêhô ŋalôm, dec iŋ gêlic po ŋambwa naŋ yêc. Goc iŋ kölhö gi ma gauc gêm yom daêsam pi gêŋ hoŋ dinaŋ. ");
INSERT INTO buk_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Têŋ bêc tigeŋ dinaŋ ŋgac-sêŋom lu sêŋsêlêŋ sêmbo seŋ bu sêtêŋ malac Emeyas sêndi. Seŋ akêŋ Jerusalem têŋ Emeyas, naŋ ŋasawa gitôm kilometa 11. ");
INSERT INTO buk_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Iŋlu sem yomgalôm têŋ dandi, pi gêŋ hoŋ naŋ hôc asê têŋ têm dinaŋ. ");
INSERT INTO buk_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Sêŋsêlêŋ ti sem yomgalôm sêmbo, ma Yisu dau meŋ kêsêlêŋ whiŋ iŋlu. ");
INSERT INTO buk_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tigeŋ Anötö kôm iŋlu tandô ŋalêŋ kaiŋ daŋ sa, dec sêŋyalê iŋ dom. ");
INSERT INTO buk_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ma iŋ sôm têŋ iŋlu, “Yom bocke dec amlu asôm têŋ daôm ma aŋsêlêŋ ambo seŋ?” Goc iŋlu sêkwê dôŋ sêlhac, ma sêwec. ");
INSERT INTO buk_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ma iŋlu si daŋ naŋ sêsam bu Kliopas ô yom ma sôm, “Ŋacleŋ hoŋ naŋ sêmbo Jerusalem têŋ têm dindec, naŋ sêŋyalê gêŋ naŋ hôc asê. Bocke dec am kêyalê dom?” ");
INSERT INTO buk_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ma Yisu ndac, “Gêŋ sake?” Ma sêsôm têŋ iŋ, “Gêŋ naŋ hôc asê Yisu Nasaret-ŋga. Ŋgac dau iŋ propet daŋ, ma iŋ kôm gêŋ ma sôm yom ti ŋaclai atu yêc Anötö ma ŋamalac hoŋ aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Ma yac akêŋ bataŋ su, bu mboe iŋ Mesaya naŋ Anötö oc êŋkiŋ bu êŋgaho lau Israel-ŋga su yêc lau Rom-ŋga amba. Tigeŋ yac mba dabuŋ-siga atu-tu ti lau bata Israel-ŋga sêkêŋ iŋ têŋ lau Rom-ŋga bu sêmatôc iŋ, ma ŋac sêkic yom bu iŋ mbac ndu, ma sic iŋ pi a gicso dau. Gêŋ hoŋ dinaŋ hôc asê iŋ, ma kwahic dec bêc tö giŋga su. ");
INSERT INTO buk_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ma bêbêc lec yac mba lauwhê ŋatô sêsôm yom naŋ kôm yac hoŋ asö. Têŋ bêbêc ganduc, ŋac sêtêŋ sêhô si, ");
INSERT INTO buk_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","magoc sêtap iŋ ndê ŋamlaŋ sa dom. Sêmbu sêmeŋ, ma sêsôm bu aŋela sêhoc dau asê têŋ ŋac, ma sêsôm têŋ ŋac bu Yisu mbo tali. ");
INSERT INTO buk_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Lau ŋatô naŋ sêmbo sêwhiŋ yac, naŋ sêsa sêtêŋ sêhô si, ma sêtap gêŋ hoŋ sa tôm lauwhê dau sêsôm, magoc sêlic Yisu dom.” ");
INSERT INTO buk_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Goc Yisu sôm têŋ iŋlu, “O mac lau! Mac nem gauc sa dom. Lau propet sêhoc yom asê pi gêŋ hoŋ dinaŋ gwanaŋ su, magoc mac akêŋ whiŋ gwalec! ");
INSERT INTO buk_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Sêhoc yom asê ma sêsôm bu Mesaya gic waê bu hôc ŋawapac hoŋ dinaŋ, ma tiŋambu tap iŋ ndê ŋawasi sa.” ");
INSERT INTO buk_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ma Yisu whê iŋlu si gauc sa pi yom hoŋ naŋ Moses ti lau propet sêto hêganôŋ iŋ, e iŋ whê Anötö ndê yom hoŋ naŋ sêto gwanaŋ pi iŋ, naŋ sa têŋ iŋlu. ");
INSERT INTO buk_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ŋac sêsuŋ sa malac Emeyas, ma Yisu kôm bu hu iŋlu siŋ, ma êŋsêlêŋ gacgeŋ ndi. ");
INSERT INTO buk_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Magoc sêteŋ iŋ ti ŋaŋga, ma sêsôm, “Mbo whiŋ alu, bu ac pacndê ma sauŋ oc ôbwêc sa.” ");
INSERT INTO buk_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Dec Yisu sôc malac dau gi, bu mbo whiŋ iŋlu. Ma têŋ ndoc sêndöc sic bu sêneŋ gêŋ, naŋ Yisu kôc bolom sa, gêm daŋge ma pô kôc, goc kêŋ têŋ iŋlu. ");
INSERT INTO buk_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ma iŋlu si tandô ŋawa sa, dec sêŋyalê iŋ. Ma ŋagahô eŋ Yisu aŋgô mba. ");
INSERT INTO buk_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ma iŋlu sêsôm têŋ dandi, “Yomandô. Têŋ ndoc iŋ sôm yom têŋ hêclu yêc seŋ, ma whê Anötö ndê yom naŋ sêto yêc, naŋ sa, dec kôm hêclu neŋ ŋalôm kac hêclu ŋandô.” ");
INSERT INTO buk_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Goc iŋlu sêtisa ŋagahô, ma sêlhö sêmbu sêtêŋ Jerusalem si. Ma sêtap ŋgacsêŋomi 11 sa, ti lau ŋatô naŋ sêmbo sêwhiŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ma ŋgacsêŋomi sêsôm têŋ iŋlu, “Pômdau tisa yomandô, ma iŋ hoc dau asê têŋ Saimon!” ");
INSERT INTO buk_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Goc iŋlu sic miŋ yom pi gêŋ naŋ hôc asê yêc seŋ, ma bu iŋlu sêŋyalê Yisu têŋ ndoc iŋ pô bolom kôc. ");
INSERT INTO buk_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sêsôm yom dinaŋ sêmbo, ma Yisu hoc dau asê ma kalhac ŋac aŋgô-ŋga, ma sôm têŋ ŋac, “Yom malô whiŋ mac.” ");
INSERT INTO buk_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ŋac sêsö ti sêtöc dandi ŋandô, bu ŋac gauc gêm bu sêlic ŋalau daŋ. ");
INSERT INTO buk_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ma iŋ sôm têŋ ŋac, “Tu sake-ŋga mac nem ŋalôm ŋawapac, ma gauc gêm yom daêsam? ");
INSERT INTO buk_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Alic amaŋ ti gahiŋapa, bu aö dauŋ dindec. Amasec aö, ma alic. Ŋalau si ŋamsôm ti ŋakwa mbasi, magoc alic aö neŋ.” ");
INSERT INTO buk_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Iŋ sôm yom dinaŋ, goc tôc amba ti gahiapa têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ŋac atac ŋayham babalec, magoc ŋac gauc gêm yom daêsam, ma atac lu-lu bu gêŋ naŋ hôc asê, naŋ gêŋ ŋandô, me mba. Goc iŋ ndac ŋac, “Mac nem gêŋ daneŋ-ŋga ndöc?” ");
INSERT INTO buk_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ma sêkêŋ i tô daŋ naŋ sêpec su, naŋ têŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ma iŋ kôc su, ma gêŋ yêc ŋac si aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Goc iŋ sôm têŋ ŋac, “Gauc nem bu aö gasôm yom têŋ mac muŋ su, pi gêŋ naŋ kwahic dec ŋandô sa. Têŋ ndoc aö gambo gawhiŋ mac, naŋ gawhê sa bu gêŋ hoŋ naŋ sêto pi aö yêc Moses ma lau propet si bapia tilhuŋ, ma yêc Buku Wê-ŋga, naŋ gic waê bu ŋandô sa.” ");
INSERT INTO buk_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ma iŋ whê ŋac si gauc sa pi Anötö ndê yom hoŋ naŋ sêto yêc. ");
INSERT INTO buk_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Iŋ sôm têŋ ŋac, “Sêto yom pi Mesaya bu iŋ oc hôc ŋandê atu ma mbac ndu, ma têŋ bêc titö-ŋga iŋ oc tisa ma mbo tali tiyham. ");
INSERT INTO buk_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ma sêto bu lau oc sênem mêtê tu iŋ ndê ŋaê-ŋga, ma sêsôm têŋ lau bu sêkac si ŋalôm kwi, dec Anötö oc suc ŋac si sac kwi. Ŋac oc sêndic hu sênem mêtê dau yêc malac Jerusalem, ma tiŋambu mêtê dau oc sa têŋ lau gameŋ apa-ŋga hoŋ. ");
INSERT INTO buk_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Gêŋ hoŋ dindec mac alic gatô su, dec oc ahoc yom ŋandô asê pi gêŋ dau awhiŋ. ");
INSERT INTO buk_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ma alic! Aö oc wakêŋ gêŋ naŋ aneŋ Damaŋ gic bata su, naŋ têŋ mac. Bocdinaŋ ambo malac dindec e Anötö kêŋ iŋ ndê ŋaclai nem mac ahuc.” ");
INSERT INTO buk_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tiŋambu Yisu wê ŋac sêsa sêtêŋ gameŋ naŋ yêc kêpiŋ malac Betani si. Yêc dinaŋ iŋ hôc amba sa, ma gêm mbec ŋac. ");
INSERT INTO buk_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ma têŋ têm iŋ gêm mbec ŋac mbo, naŋ iŋ hu ŋac siŋ, ma Anötö kôc iŋ sa pi undambê gi. ");
INSERT INTO buk_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Dec ŋac sêpôŋ haduc ma sêmpiŋ iŋ. Ma sêlhö sêmbu sêtêŋ Jerusalem si ti atac ŋayham atu. ");
INSERT INTO buk_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ma tôm bêc hoŋ, sêkac sa sêmbo lôm dabuŋ ŋabatêmndö, ma sêhoc Anötö ndê waê asê. ");
INSERT INTO buk_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Têŋ têm ŋamata-ŋga nom sambuc dindec mbasi, naŋ Yisu naŋ dasam bu Yom Dau, iŋ mbo. Iŋ mbo whiŋ Anötö, ma iŋ Anötö dau. ");
INSERT INTO buk_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Iŋ mbo whiŋ Anötö têŋ têm ŋamata-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Gêŋ hoŋ naŋ yêc, naŋ iŋ dau kêŋ, ma gêŋ daŋ hôc asê ŋa lêŋ daŋ dom. ");
INSERT INTO buk_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yac neŋ dambo taŋli ŋahu iŋ dau, ma iŋ dau ti ŋamalac nom-ŋga si Ŋawê. ");
INSERT INTO buk_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ŋawê dau pô gameŋ ŋasec, ma ŋasec gitôm dom bu kôm ŋawê dau ahuc. ");
INSERT INTO buk_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Anötö kêkiŋ ŋgac aheŋ-ŋga daŋ meŋ, naŋ ndê ŋaê Jon. ");
INSERT INTO buk_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Iŋ meŋ bu hoc yom ŋandô asê pi Ŋawê dau, tu bu lau hoŋ naŋ sêŋgô iŋ ndê yom, naŋ sêkêŋ whiŋ Ŋawê dau. ");
INSERT INTO buk_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","9","Jon iŋ Ŋawê dau dom, tigeŋ iŋ meŋ bu hoc yom asê pi Ŋawê ŋandô dau, naŋ oc meŋ êŋkuc iŋ bu pô ŋamalac hoŋ. ");
INSERT INTO buk_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nom sambuc dindec Anötö kêŋ ŋa iŋ, tigeŋ têŋ ndoc iŋ hôc asê, naŋ lau nom-ŋga sêŋyalê iŋ dom. ");
INSERT INTO buk_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Iŋ ti nom sambuc dindec ŋadau, magoc têŋ ndoc iŋ meŋ, naŋ iŋ ndê lau Israel-ŋga sêkôc iŋ sa dom. ");
INSERT INTO buk_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Magoc lau hoŋ naŋ sêkôc iŋ sa, ma sêkêŋ whiŋ iŋ, naŋ Anötö gêlic ŋayham ma kôc ŋac sa sêti iŋ ndê balêkoc. ");
INSERT INTO buk_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Sêti iŋ ndê balêkoc ŋa lêŋ tôm lau nom-ŋga si lêŋ sêkwê balêkoc asê-ŋga dom, me tu ŋamalac dau si gauc gêm me atac whiŋ-ŋga dom. Mba! Anötö dau kôm ŋac sêtiwakuc dec sêti iŋ ndê balêkoc. ");
INSERT INTO buk_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Iŋ naŋ dasam bu Yom Dau sip nom meŋ ti ŋamalac, ma mbo whiŋ yac. Iŋ meŋ akêŋ Damba Anötö, ma Damba ndê mwasiŋ ti yom ŋandô gêm iŋ ahuc. Iŋ Anötö ndê Atu tigeŋ, dec wêkaiŋ ŋaclai ti ŋawasi atu, ma yac alic iŋ ndê ŋaclai ti ŋawasi dau, naŋ su. ");
INSERT INTO buk_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon hoc yom asê pi iŋ gwanaŋ su bocdec bu, “Ŋgac daŋ oc êŋkuc aö, naŋ hôc gêlêc aö su, ŋahu bu iŋ mbo wandêc su mbo.” Ma têŋ ndoc iŋ hôc asê, naŋ Jon sôm bu, “Iŋ ŋgac dau dinaŋ dec gahoc yom asê pi iŋ gwanaŋ su.” ");
INSERT INTO buk_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","17","Muŋ-ŋga Anötö kêmwasiŋ lau Israel-ŋga ŋa yomsu naŋ iŋ kêŋ têŋ Moses. Magoc kwahic dec Yisu Kilisi meŋ, ma Anötö ndê mwasiŋ gêm iŋ ahuc sambuc, dec yac hoŋ datap mwasiŋ ti yom ŋandô sa hôc gêlêc su, yêc Yisu. ");
INSERT INTO buk_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ŋamalac daŋ gêlic Anötö su dom. Magoc iŋ ndê Atu tigeŋ Yisu †Kilisi, naŋ mbo kêpiŋ Anötö dau, iŋ dau iŋ Anötö, naŋ sip nom meŋ ti ŋamalac, ma whê Damba Anötö sa têŋ yac, dec taŋyalê iŋ. ");
INSERT INTO buk_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","Têŋ ndoc Jon kêku lau mbo, naŋ lau bata Israel-ŋga sêŋkiŋ †dabuŋsiga ŋatô ti lau †Liwai ŋatô akêŋ Jerusalem sêtêŋ iŋ si, ma sêndac iŋ bu, “Am asa?” Jon sêc yom daŋ ahuc dom, iŋ sôm yom yêc awê bu, “Aö †Mesaya dom.” ");
INSERT INTO buk_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Dec ŋac sêndac iŋ, “Bocdinaŋ dec am asa? Am Elaija, a?” Ma iŋ sôm, “Mba!” Goc sêndac, “Am propet gitôm Moses naŋ Anötö gic bata bu êŋkiŋ meŋ, a?” Ma iŋ sôm, “Mba!” ");
INSERT INTO buk_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Bocdinaŋ sêsôm têŋ iŋ, “Dec sôm daôm asê têŋ yac bu am asa. Yac bu akêŋ ŋawaê têŋ lau naŋ sêŋkiŋ yac ameŋ naŋ.” ");
INSERT INTO buk_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jon ô ŋac si gêndac ŋa propet Aisaya ndê yom daŋ, ma sôm, “Ŋamalac naŋ ta yom yêc gameŋ sawa bu, ‘Amasaŋ Pômdau ndê seŋ tisolop,’ naŋ aö dauŋ dec.” ");
INSERT INTO buk_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Lau Palêsai ŋatô sêmbo sêwhiŋ lau naŋ lau bata sêŋkiŋ sêtêŋ Jon si. ");
INSERT INTO buk_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Sêŋgô Jon ndê yom dau, dec sêndac iŋ bocdec bu, “Am daôm sôm bu am Mesaya dom, ma bu am Elaija dom, ma propet atu dau dom. Ma bocke dec am kêku lau mbo?” ");
INSERT INTO buk_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Ma Jon sôm, “Aö dec kaku lau ŋa bu, magoc ŋgac daŋ oc êŋkuc aö, naŋ hôc gêlêc aö su. Aö dec ŋgac ŋambwa, gitôm dom bu wati iŋ ndê ŋgac akiŋ bu waŋgapwêc iŋ ndê atapa ŋawalô. Ŋgac dau kwahic dec mbo mac ŋalhu, magoc mac aŋyalê iŋ dom.” ");
INSERT INTO buk_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jon kêku lau mbo malac daŋ ŋaê Betani, naŋ yêc Bu Jordan ŋadaŋga mbu têŋ ac pi-ŋga. Ma gêŋ hoŋ dinaŋ hôc asê yêc gameŋ dinaŋ. ");
INSERT INTO buk_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Bêc daŋ tiyham ma Jon gêlic Yisu kêsêlêŋ têŋ iŋ meŋ, ma sôm, “Alic ŋgac dê! Iŋ †Anötö ndê Domba, naŋ Anötö kêŋ bu kôc ŋamalac si sac su. ");
INSERT INTO buk_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iŋ ŋgac dau naŋ aö gasôm yom pi iŋ muŋ su, bu ŋgac daŋ oc êŋkuc aö meŋ, naŋ hôc gêlêc aö su, bu iŋ mbo wandêc su mbo. ");
INSERT INTO buk_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Muŋ-ŋga aö dauŋ neŋ gauc sa pi iŋ dom, tigeŋ kwahic dec aö gameŋ kaku lau ŋa bu, tu bu watôc iŋ asê têŋ lau Israel-ŋga.” ");
INSERT INTO buk_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Jon sôm yom dinaŋ su, goc gic têku yom ma whê yom sa bocdec bu, “Yomandô. Muŋ-ŋga aö dauŋ neŋ gauc sa pi iŋ dom, tigeŋ Anötö naŋ kêkiŋ aö bu waŋku lau ŋa bu, naŋ sôm têŋ aö bu, ‘Am oc lic Ŋalau Dabuŋ sip têŋ ŋgac daŋ meŋ. Ma ŋgac dau dinaŋ oc êŋku lau ŋa Ŋalau Dabuŋ.’ Tiŋambu aö galic Ŋalau Dabuŋ gêm balusi aŋgô ma sip akêŋ undambê têŋ ŋgac dindec meŋ ma mbo whiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Aö tanôŋ galic gêŋ dinaŋ hôc asê ŋgac dau su, ma tu dinaŋ-ŋga kwahic dec gahoc yom asê pi iŋ, ma gasôm asê têŋ mac bu iŋ Anötö ndê Atu.” ");
INSERT INTO buk_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ŋagalaŋsê Jon mbo bu dau ŋadali ma iŋ ndê †ŋgacsêŋom lu sêmbo sêwhiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yisu kêsêlêŋ meŋ, ma Jon tahê iŋ ma sôm, “Kec, Anötö ndê Domba dê.” ");
INSERT INTO buk_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Têŋ ndoc ŋgacsêŋom lu sêŋgô Jon ndê yom dinaŋ, naŋ sêhu iŋ siŋ ma sêŋkuc Yisu. ");
INSERT INTO buk_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yisu kac dau kwi ma gêlic bu iŋlu sêŋkuc iŋ, dec ndac, “Bocke dec amlu aŋkuc aö?” Goc iŋlu sêsôm, “Rabai, am yêc nde?” (Ŋaê †Rabai danem kwi bu ‘Kêdôhôŋ-waga.’ ) ");
INSERT INTO buk_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ma iŋ sôm, “Ameŋ ma alic.” Goc iŋlu sêŋsêlêŋ sêwhiŋ iŋ si, ma sêlic gameŋ naŋ iŋ yêc. Sêhôc asê têŋ telha, acgatu gitôm 4 kilok, ma bocdinaŋ dec sêmbo sêwhiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ŋgac lu naŋ sêŋgô Jon ndê yom ma sêŋkuc Yisu, naŋ si daŋ iŋ Andru, Saimon Pita ndê asi. ");
INSERT INTO buk_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ŋagahô iŋ gi tap dôwa Saimon sa, ma sôm têŋ iŋ, “Yac atap †Mesaya sa su.” (Yom Mesaya dau danem kwi bu Kilisi.) ");
INSERT INTO buk_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Goc iŋ wê Saimon s a têŋ Yisu gi. Yisu tahê iŋ ma sôm, “Am Saimon, Jon ndê atu. Kwahic dec aö wasam am bu Kepas.” (Ŋaê dau sem kwi sip Yom Grik bu Pita.) ");
INSERT INTO buk_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Têŋ ŋagalaŋsê Yisu tisa ma gi tap ŋgac daŋ ŋaê Pilip sa. Pilip iŋ ŋgac akêŋ malac Betsaida yêc gameŋ Galili-ŋga. Malac dau Pita lu Andru si malachu whiŋ. Yisu gauc gêm bu têŋ Galili ndi, dec sôm têŋ Pilip, “Mweŋ êmkuc aö.” ");
INSERT INTO buk_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Goc Pilip gi tap ŋgac daŋ ŋaê Natanael sa, ma sôm têŋ iŋ bu, “Mesaya naŋ Moses ti lau propet sêto yom pi iŋ muŋ su, naŋ yac atap iŋ sa su. Iŋ Josep ndê atu Yisu akêŋ malac Nasaret.” ");
INSERT INTO buk_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael ŋgô su goc ndac, “Nasaret? Gêŋ ŋayham bocke oc meŋ akêŋ malac ŋambwa dinaŋ?” Dec Pilip sôm, “Mweŋ ma lic.” ");
INSERT INTO buk_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yisu gêlic Natanael têŋ iŋ meŋ, ma sôm yom pi iŋ bocdec bu, “Yomandô! Iŋ ŋgac Israel-ŋga naŋ yom tasaŋ daŋ yêc iŋ ndê ŋalôm dom.” ");
INSERT INTO buk_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Dec Natanael ndac iŋ, “Am kêyalê aö ŋalêŋ bocke?” Ma Yisu sôm têŋ iŋ, “Pilip mbwêc am dom eŋ, ma aö galic am ndöc a atu daŋ ŋahu.” ");
INSERT INTO buk_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael ô yom ma sôm, “Kêdôhôŋwaga, am Anötö ndê Atu. Am yac lau Israel-ŋga mba Kiŋ.” ");
INSERT INTO buk_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ma Yisu ô yom ma sôm têŋ iŋ, “Aö gasôm bu galic am yêc a daŋ ŋahu ma tu dinaŋ-ŋga dec am kêŋ whiŋ. Am oc lic gêŋ atu-tu hôc gêlêc iŋ dinaŋ su.” ");
INSERT INTO buk_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ma iŋ gic têku yom ma sôm, “Yom ŋandô aö wasôm têŋ mac. Tiŋambu mac oc alic undambê kac sa, ma †Ŋamalac ndê Atu oc ti seŋ bu Anötö ndê aŋela sêsip sêpi-ŋga.” ");
INSERT INTO buk_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Bêc lu gi su ma lau yêc malac Kana naŋ yêc gameŋ Galili-ŋga sêndê mwasiŋ tu ŋgac daŋ bu nem awhê-ŋga. Yisu dinda mbo whiŋ ŋac, ma ");
INSERT INTO buk_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","sêkêŋ aheŋ Yisu ti ndê ŋgacsêŋomi bu sêneŋ mwasiŋ dau sêwhiŋ. ");
INSERT INTO buk_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ma lau seŋ ti sênôm gêŋ sêmbo e wain pacndê. Dec Yisu dinda sôm têŋ iŋ bu, “Ŋac si wain pacndê su.” ");
INSERT INTO buk_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Goc Yisu sôm têŋ iŋ, “O awhê! Tu sake-ŋga am sôm têŋ aö? Aneŋ ndoc meŋ sa su dom.” ");
INSERT INTO buk_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tigeŋ Yisu dinda sôm têŋ lau akiŋ bu, “Gêŋ bocke naŋ iŋ bu sôm têŋ mac, naŋ akôm.” ");
INSERT INTO buk_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yêc mwasiŋ dau ŋamala, lôŋ bu-ŋga 6 sêlhac. Lôŋ dinaŋ atu andô, tigeŋ-tigeŋ gitôm 100 lita, ma sic waê lau Israel-ŋga si mêtê sêŋgwasiŋ dau ŋawasi sa yêc Anötö aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ma Yisu sôm têŋ lau akiŋ, “Akêŋ bu sip lôŋ hoŋ dinaŋ e meŋhu.” ");
INSERT INTO buk_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Sêtac bu sip e meŋhu su, goc iŋ sôm têŋ ŋac, “Aŋgati sa ma akêŋ têŋ mwasiŋ ŋadau êŋsahê.” Ma sêkôm gitôm iŋ sôm. ");
INSERT INTO buk_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mwasiŋ ŋadau kêsahê bu naŋ Yisu gêm kwi ti wain, ma kêyalê dom bu meŋ akêŋ nde. Tigeŋ lau akiŋ naŋ sêtac bu sip lôŋ, naŋ dec sêŋyalê. Mwasiŋ ŋadau kêsahê su, goc mbwêc ŋgac gêm awhê-ŋga meŋ, ma sôm têŋ iŋ, ");
INSERT INTO buk_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Lau hoŋ sêkêŋ wain ŋayham têŋ lau sênôm muŋ e tac ŋayham sa, goc sêkêŋ wain ŋambwa kêkuc. Tu sake-ŋga am kêgamiŋ wain ŋayham kalhac e tiŋambu?” ");
INSERT INTO buk_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yisu kôm gêŋ dalô ŋamata-ŋga dinaŋ yêc malac Kana, naŋ yêc gameŋ Galili-ŋga. Gêŋ dau tôc iŋ ndê ŋawasi ti ŋaclai asê, ma iŋ ndê ŋgacsêŋomi sêkêŋ whiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ma tiŋambu Yisu lu dinda ma asii ti ŋgacsêŋomi sêsip malac Kapenaom si, ma sêmbo bêc ŋatô. ");
INSERT INTO buk_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Têŋ têm dinaŋ lau Israel-ŋga si om atu †Mwasiŋ Pasowa-ŋga meŋ kêpiŋ. Tu dinaŋ-ŋga Yisu pi Jerusalem gi. ");
INSERT INTO buk_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Iŋ hôc asê su, ma yêc lôm dabuŋ ŋabatêmndö, iŋ gêlic lau sêhoŋ makao ti domba ma balusi bu lau sênemlhi, ma lau ŋatô sêndöc tebo bu sêô lau apa si mone ŋa lau Israel-ŋga si mone. ");
INSERT INTO buk_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Dec iŋ gêm bocbiŋ wac ti po ma kêbulu ŋac sêsa awê si, ma kêbulu makao ti domba sêwhiŋ. Ma iŋ tac lau sêô mone-ŋga si tebo sa, ma kêbalip ŋac si mone babalip. ");
INSERT INTO buk_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Goc iŋ hec yom lau balusi-ŋga ma sôm têŋ ŋac, “Akôc nem balusi dinaŋ asa awê andi! Damaŋ ndê andu yêc bu lau sênemlhi gêŋ sêmbo-ŋga dom. Mac akôm sac sambuc!” ");
INSERT INTO buk_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Têŋ dinaŋ iŋ ndê ŋgacsêŋomi gauc gêm Anötö ndê yom daŋ naŋ sêto yêc bocdec bu: Aö neŋ atac whiŋ tu am nem andu-ŋga, mbô aö neŋ ŋalôm sa ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ma lau bata Israel-ŋga sêndac Yisu ma sêsôm, “Asa kêŋ ŋaclai têŋ am bu kôm gêŋ dinaŋ? Kôm gêŋ dalô daŋ bu tôc am nem ŋaclai ŋahu asê têŋ yac.” ");
INSERT INTO buk_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yisu ô ŋac si awha ma sôm, “Aseŋ lôm dabuŋ dindec su, ma aö oc wakwê sa tiyham nditôm bêc tö.” ");
INSERT INTO buk_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Goc sêsôm, “Muŋ-ŋga lau sêkôm gweleŋ sêkwê lôm dabuŋ dindec-ŋga gitôm yala 46. Ma bocke dec am gauc gêm bu am gitôm bu kwê sa tôm bêc tö?” ");
INSERT INTO buk_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Sêsôm yom dinaŋ bu ŋac sêŋyalê dom bu lôm dabuŋ naŋ iŋ sôm yom pi, naŋ iŋ dau. ");
INSERT INTO buk_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","T iŋambu, têŋ ndoc Yisu tisa akêŋ lau batê-ŋga, naŋ iŋ ndê sêŋomi gauc gêm iŋ ndê yom dinaŋ. Ma têŋ dinaŋ sêkêŋ whiŋ yom naŋ iŋ sôm, ma sêkêŋ whiŋ Anötö ndê yom naŋ sêto yêc muŋ su, pi iŋ ndê mbac ndu ma tisa-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yisu mbo Jerusalem têŋ Om Pasowa-ŋga, ma lau daêsam sêlic gêŋ dalô hoŋ naŋ iŋ kôm, dec sêkêŋ whiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Tigeŋ Yisu kêyalê ŋamalac si gauc ti yom hoŋ naŋ yêc ŋac si ŋalôm. Iŋ pônda ŋamalac si yom pi dau dom. Ma tu dinaŋ-ŋga iŋ whê dau sa sambuc têŋ ŋamalac daŋ dom. ");
INSERT INTO buk_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Lau Israel si ŋgac bata daŋ mbo Jerusalem, naŋ ndê ŋaê Nikodemas. Iŋ mbo lau †Palêsai si toŋ, ma iŋ lau bata †Sanedrin-ŋga si daŋ whiŋ. ");
INSERT INTO buk_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Têŋ ôbwêc daŋ, Nikodemas têŋ Yisu gi, ma sôm têŋ iŋ, “O Kêdôhôŋwaga. Yac alic gêŋ dalô hoŋ naŋ am kôm, dec aŋyalê bu am kêdôhôŋwaga daŋ naŋ Anötö kêkiŋ meŋ. Ŋahu bu Anötö bu mbo whiŋ ŋamalac daŋ dom, dec oc tôm dom bu ŋamalac dau kôm gêŋ dalô gitôm naŋ am kôm.” ");
INSERT INTO buk_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ma Yisu ô iŋ ndê yom ma sôm, “Yom ŋandô aö wasôm têŋ am. Ŋamalac daŋ bu tiwakuc tiyham dom, dec oc tôm dom bu iŋ mbo †Anötö ndê gôliŋ ŋapu.” ");
INSERT INTO buk_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Goc Nikodemas sôm têŋ iŋ, “Ŋamalac andô daŋ oc tiwakuc ŋalêŋ bocke? Oc tôm bu sip dinda atac ŋalôm ma dinda kôc iŋ tiyham, me?” ");
INSERT INTO buk_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ma Yisu sôm, “Aö wasôm yom ŋandô têŋ am. Ŋamalac daŋ bu tiwakuc ŋa bu ma ŋa Ŋalau Dabuŋ dom, dec oc nditôm dom bu mbo Anötö ndê gôliŋ ŋapu. ");
INSERT INTO buk_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ŋamalac sêkwê ŋamalac asê, magoc Ŋalau tigeŋ g itôm bu kôm ŋamalac daŋ tiwakuc ma kêŋ ŋalôm wakuc têŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Aö gasôm têŋ am bu mac atiwakuc tiyham ŋa ŋaclai undambê-ŋga maŋ. Am sö tu yom dinaŋ-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mbu kêsêlêŋ kêkuc Anötö ndê atac whiŋ. Am gitôm bu ŋgô ŋakêcsia, tigeŋ am kêyalê mbu ŋahu me mbu ŋapwê dom. Ma Ŋalau Dabuŋ ndê gweleŋ kôm lau sêtiwakuc-ŋga, naŋ kaiŋ tigeŋ.” ");
INSERT INTO buk_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemas ŋgô yom dinaŋ, dec ndac Yisu, “Aluê! Yom dinaŋ oc ŋandô sa ŋalêŋ bocke?” ");
INSERT INTO buk_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ma Yisu sôm, “Am lau Israel si kêdôhôŋ-waga mêtê-ŋga daŋ, ma bocke dec am kêyalê yom dindec ŋahu dom? ");
INSERT INTO buk_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Aö wasôm yom ŋandô têŋ am. Gêŋ naŋ aö ti lau naŋ sêŋkuc aö naŋ aŋyalê, dec yac asôm asê. Ma yac ahoc yom ŋandô asê pi gêŋ naŋ yac alic su. Magoc mac akôc yac mba yom sa dom. ");
INSERT INTO buk_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Aö gasôm yom têŋ mac pi gêŋ nom-ŋga, magoc mac akêŋ whiŋ dom. Ma aö bu wasôm yom têŋ mac pi gêŋ undambê-ŋga, dec oc akêŋ whiŋ ŋalêŋ bocke? ");
INSERT INTO buk_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ŋamalac daŋ pi undambê gi bu êŋyalê gêŋ undambê-ŋga dom, tigeŋ Ŋamalac ndê Atu, naŋ sip akêŋ undambê meŋ, naŋ kêyalê. ");
INSERT INTO buk_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Muŋ-ŋga, têŋ ndoc lau Israel-ŋga sêmbo gameŋ sawa, naŋ Moses gic mboc ŋagatu pi a, ma hôc sa pi lôlôc gi. Ma ŋalêŋ tigeŋ, lau oc sêndic Ŋamalac ndê Atu pi a, ma sêhôc iŋ sa pi lôlôc ndi. Lêŋ dinaŋ gic iŋ ŋawaê, ");
INSERT INTO buk_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tu bu lau hoŋ naŋ sêkêŋ whiŋ iŋ, naŋ oc sêtap seŋ sêndöc tali ŋapaŋ-ŋga sa. ");
INSERT INTO buk_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Bu Anötö atac whiŋ lau nom-ŋga ndu andô, dec kêŋ ndê Atu tigeŋ mbac ndu tu ŋac-ŋga, bu lau hoŋ naŋ sêkêŋ whiŋ iŋ, naŋ oc sêniŋga dom, magoc sêtap seŋ sêndöc tali-ŋga sa. ");
INSERT INTO buk_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Anötö kêŋ ndê Atu sip nom meŋ bu êmatôc lau dom, magoc kêŋ iŋ meŋ bu ti lêŋ nem lau si-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Lau naŋ sêkêŋ whiŋ iŋ, naŋ oc sêtap Anötö ndê matôc sa dom. Magoc lau naŋ sêkêŋ whiŋ dom, naŋ gitôm sêmatiŋ dau si yom tidôŋ su bu oc sêtap Anötö ndê matôc sa, ŋahu bu ŋac sêkêŋ whiŋ Anötö ndê Atu tigeŋ dom. ");
INSERT INTO buk_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ma ŋac si matôc dau ŋahu bocdec bu. Ŋawê ŋandô sip nom meŋ, tigeŋ sêtec ŋawê dau ma atac whiŋ lêŋ ŋasec-ŋga, ma sêsap mêtê sac dôŋ ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Lau hoŋ naŋ sêkôm mêtê sac, naŋ sêtec bu ŋawê dau pô ŋac si mêtê sac e yêc awê, ma tu dinaŋ-ŋga sêtigasuc ŋawê dau dom. ");
INSERT INTO buk_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Magoc lau naŋ sêŋkuc yom ŋandô, naŋ sêtêŋ ŋawê sêmeŋ ma gacgeŋ sêmbo dinaŋ. Ma tu dinaŋ-ŋga lau hoŋ sêlic yêc awê bu ŋac sêkôm mêtê ŋayham tôm Anötö kêŋ ŋaclai têŋ ŋac.” ");
INSERT INTO buk_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Dinaŋ su, goc Yisu ti iŋ ndê ŋgacsêŋomi sêhu Jerusalem siŋ, ma sêsa si sêmbo gameŋ ŋamakê-ŋga yêc gameŋ Judia-ŋga. Ma yêc dindê iŋ mbo whiŋ ŋac ma sêŋku lau. ");
INSERT INTO buk_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Têŋ ndoc dinaŋ Jon mbo malac Aenon, naŋ yêc suŋ sa têŋ Salim. Bu ŋagapoŋ ŋayham poc gameŋ dinaŋ, ma tu dinaŋ-ŋga Jon mbo dinaŋ, ma kêku lau naŋ sêtêŋ iŋ si. ");
INSERT INTO buk_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Têŋ ndoc dinaŋ Jon mbo awê, sêkêŋ iŋ ndöc gapocwalô su dom. ");
INSERT INTO buk_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ma Jon ndê sêŋomi ŋatô ma ŋgac bata Israel-ŋga daŋ sêseŋ dau pi lêŋ lau sêŋgwasiŋ dau ŋawasi sa yêc Anötö aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Dec sêtêŋ Jon si, ma sêsôm, “Kêdôhôŋwaga, muŋ-ŋga am hoc yom asê pi Yisu, têŋ ndoc iŋ hôc asê am yêc Bu Jordan ŋadaŋga. Kwahic dec yac aŋgô bu lau hoŋ sêtêŋ iŋ si, bu iŋ êŋku ŋac.” ");
INSERT INTO buk_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon ô ŋac si yom ma sôm, “Ahêgo daôm dom! Alu Yisu lu-lu akôm mba gweleŋ gitôm Anötö dau kêŋ sip alu amaŋ. ");
INSERT INTO buk_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mac aŋyalê yom hoŋ naŋ aö gasôm têŋ mac su. Aö gasôm bu aö dauŋ Mesaya dom, magoc Anötö kêkiŋ aö gamuŋ iŋ gameŋ. ");
INSERT INTO buk_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Lau hoŋ bu sêtêŋ Yisu sêndi, dec oc solop. Bu ŋac gitôm awhê naŋ sêmatiŋ iŋ ndê yom bu nem ŋgac, ma Yisu iŋ gitôm ŋgac nem awhê-ŋga dau. Aö gitôm ŋgac dau ndê silip, naŋ atac ŋayham kêlêc têŋ ndoc ŋgac nem awhê-ŋga hôc asê bu nem ndê awhê sa. Ma bocdinaŋ kwahic dec aö neŋ atac ŋayham tu Yisu-ŋga gêm aö ahuc sambuc. ");
INSERT INTO buk_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ma iŋ solop bu kwahic dec Yisu ndê waê tiatu, ma aneŋ waêŋ tisauŋ. ");
INSERT INTO buk_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Iŋ sip akêŋ undambê meŋ, dec hôc gêlêc lau hoŋ su. Aö dec, aö ŋamalac nom-ŋga ma aö neŋ ŋahu yêc nom, ma bocdinaŋ gasôm yom tôm ŋamalac nom-ŋga. Magoc iŋ sip akêŋ undambê meŋ, ");
INSERT INTO buk_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ma sôm yom ŋandô pi gêŋ naŋ iŋ gêlic ti ŋgô su yêc undambê. Magoc lau daêsam sêkôc iŋ ndê yom sa dom. ");
INSERT INTO buk_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ŋamalac bocke naŋ kôc iŋ ndê yom sa, naŋ tôc asê bu iŋ gêlic Anötö ndê yom bu yom ŋandô eŋ. ");
INSERT INTO buk_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ŋahu bu iŋ naŋ Anötö kêkiŋ sip nom meŋ, naŋ sôm Anötö dau ndê yom asê. Ma Anötö kêgamiŋ iŋ ndê Ŋalau têŋ iŋ dom. ");
INSERT INTO buk_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Damba tac whiŋ iŋ ndê Atu kêlêc, dec kêŋ gêŋ hoŋ sip iŋ amba. ");
INSERT INTO buk_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ma asa naŋ kêŋ whiŋ Atu, naŋ Anötö gic bata su, bu iŋ oc mbo tali ŋapaŋ. Tigeŋ asa naŋ kôc iŋ sa dom, naŋ Anötö ndê atac ŋandê yêc iŋ dôŋ yêc, dec iŋ oc lic undambê dom.” ");
INSERT INTO buk_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Têŋ ndoc dinaŋ Yisu mbo whiŋ iŋ ndê ŋgacsêŋomi, ma ŋac sêŋku lau. Iŋ dau kêku lau daŋ dom. Magoc lau Palêsai sêŋgô ŋawaê bu Yisu kêku lau daêsam, ma bu lau daêsam naŋ êlêmê sêŋkuc iŋ, naŋ sêhôc gêlêc Jon ndê sêŋomi su. Yisu kêyalê bu lau Palêsai sêŋgô ŋawaê dinaŋ, ma bu sêkêŋ kisa iŋ, ");
INSERT INTO buk_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ma bocdinaŋ dec iŋ hu gameŋ Judia-ŋga siŋ, bu mbu têŋ Galili ndi. ");
INSERT INTO buk_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yisu gauc gêm tidôŋ bu ho seŋ naŋ gic lau †Samaria-ŋga si gameŋ kôc, dec iŋ ti ndê ŋgac-sêŋomi sêŋsêlêŋ sêmbo seŋ dinaŋ. ");
INSERT INTO buk_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ŋac sêŋsêlêŋ e sêsuŋ sa lau Samaria si malac atu daŋ ŋaê Sika. Malac dau yêc kêpiŋ nom ŋasawa daŋ naŋ muŋ-ŋga andô, Jakob kêŋ têŋ iŋ ndê atu Josep. ");
INSERT INTO buk_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ma sê naŋ Jakob kwê tu sêtap bu sa-ŋga, naŋ yêc malac dau ŋamakê. Yisu ti ndê ŋgacsêŋomi sêhôc asê sê bu-ŋga dau têŋ ac kac lhu, ma sêŋsêlêŋ seŋ baliŋ su e Yisu kwapac sa, dec iŋ ndöc sic ndöc dinaŋ. ");
INSERT INTO buk_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ma iŋ ndê ŋgacsêŋomi sêhu iŋ siŋ ma sêsôc malac dau si, bu sêŋsalê gêŋ sêneŋ-ŋga. Malô goc awhê Samaria-ŋga daŋ sa meŋ bu tê bu. Ma Yisu sôm têŋ iŋ, “Gitôm bu am kêŋ bu têŋ aö wanôm?” ");
INSERT INTO buk_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Goc awhê dau ô yom bocdec bu, “Bocke dec am ŋgac Israel-ŋga ndac aö awhê Samaria-ŋga bu wakêŋ bu têŋ am nôm?” (Iŋ sôm yom dinaŋ, ŋahu bu lau Israel m a lau Samaria-ŋga sêtec dandi ma sêmbo ahê dau.) ");
INSERT INTO buk_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ma Yisu sôm, “Kwahic dec aö gandac bu têŋ am. Am bu êmyalê aö neŋ ŋahu, ma mwasiŋ naŋ Anötö kêŋ ŋambwa, dec am oc ndac bu têŋ aö, ma aö wakêŋ bu naŋ oc kêŋ ŋamalac sêndöc tali, naŋ têŋ am.” ");
INSERT INTO buk_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Awhê dau ŋgô yom dinaŋ, goc sôm, “O ŋadau. Bu tali-ŋga naŋ am sôm yom pi, naŋ am oc kôc yêc nde? Bu am nem laclhu êmgati bu sa-ŋga mba, ma sê bu-ŋga dindec baliŋ andô. ");
INSERT INTO buk_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Abaŋ Jakob ti ndê atui, ma iŋ ndê makao ti domba hoŋ sênôm bu yêc dec. Ma bocke? Am nem bu bocke yêc, naŋ hôc gêlêc iŋ dindec naŋ Jakob kêŋ têŋ yac, naŋ su?” ");
INSERT INTO buk_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Dec Yisu sôm têŋ iŋ, “Lau hoŋ naŋ sênôm bu nom-ŋga, naŋ bu oc yô ŋac tiyham. ");
INSERT INTO buk_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Magoc lau naŋ sênôm bu naŋ aö wakêŋ têŋ ŋac, naŋ bu oc yô ŋac tiyham dom. Mba. Bu naŋ aö wakêŋ têŋ ŋac, naŋ oc ti bubata naŋ êmbulup pi ŋac si ŋalôm, ma ŋac oc sêndöc tali ŋapaŋ.” ");
INSERT INTO buk_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Têŋ dinaŋ awhê dau sôm, “O ŋadau, kêŋ bu dinaŋ têŋ aö. Ma bocdinaŋ dec bu oc yô aö tiyham dom, ma wasa wameŋ tôm bêc hoŋ bu watê bu yêc sê bu-ŋga dindec tiyham dom.” ");
INSERT INTO buk_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Goc Yisu sôm têŋ iŋ, “Am mbu ndi ma ta nem akweŋ, ma amlu ambu ameŋ.” ");
INSERT INTO buk_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ma awhê dau sôm, “Aneŋ akweŋ mba.” Goc Yisu ô yom ma sôm, “Am sôm solop bu am nem akweŋ mba. ");
INSERT INTO buk_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Bu am gêm ŋgac amaŋdaŋ su, magoc sêhu am siŋ. Ma ŋgac naŋ kwahic dec am mbo whiŋ iŋ, naŋ ti am nem akweŋ dom. Am sôm yom ŋandô.” ");
INSERT INTO buk_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Têŋ dinaŋ awhê dau sôm, “Ŋadau, aö g alic bu am propet daŋ. ");
INSERT INTO buk_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Muŋ-ŋga yac lau Samaria-ŋga mba abaŋi sem akiŋ Anötö yêc lôc dindec. Tigeŋ mac lau Israel-ŋga asôm bu gameŋ tigeŋ yêc tu lau sênem akiŋ Anötö-ŋga, naŋ yêc Jerusalem.” ");
INSERT INTO buk_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Goc Yisu sôm, “O awhê! Aö wasôm yom ŋandô têŋ am. Ndoc oc meŋ sa, naŋ lau naŋ sem akiŋ Anötö oc sêhêgo dau dom bu sênem akiŋ iŋ sêmbo lôc dindec, me bu sêmbo Jerusalem. ");
INSERT INTO buk_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mac lau S amaria-ŋga am akiŋ Anötö, magoc mac aŋyalê iŋ dom. A nötö gic bata bu Mesaya oc sa yêc yac lau Israel-ŋga, ma tu dinaŋ-ŋga yac aŋyalê iŋ naŋ yac am akiŋ. ");
INSERT INTO buk_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Yomandô! Ndoc naŋ bu meŋ sa, naŋ kwahic dec meŋ su, dec lau naŋ sem akiŋ Anötö ŋalêŋ solop, naŋ oc sênem akiŋ iŋ ti Ŋalau Dabuŋ ndê ŋaclai, ma ti lêŋ yom ŋandô-ŋga. Damaŋ Anötö dau kêsalê lau naŋ sem akiŋ iŋ ŋalêŋ bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Iŋ dau iŋ ŋalau, dec ŋalêŋ tigeŋ yêc bu lau sênem akiŋ iŋ, naŋ sênem akiŋ iŋ ti Ŋalau Dabuŋ ndê ŋaclai, ma ti lêŋ yom ŋandô-ŋga.” ");
INSERT INTO buk_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Goc awhê dau sôm, “Aö kayalê bu Mesaya naŋ sêsam bu Kilisi oc meŋ. Ma têŋ ndoc iŋ meŋ, naŋ iŋ oc whê gêŋ hoŋ sa têŋ yac.” ");
INSERT INTO buk_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ma Yisu sôm, “Aö Mesaya dauŋ gasôm yom têŋ am.” ");
INSERT INTO buk_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Têŋ dinaŋ Yisu ndê ŋgac-sêŋomi sêmbu sêmeŋ, ma sêlic bu iŋ sôm yom whiŋ awhê daŋ, dec sêhê gauc ŋambwa. Magoc ŋac si daŋ sôm yom dom. Sêndac iŋ bu bocke ma iŋ sôm yom têŋ awhê dau lec dom. Ma sêndac awhê dau bu iŋ tac whiŋ gêŋ sake lec dom. ");
INSERT INTO buk_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Awhê dau hu iŋ ndê lôŋ bu-ŋga siŋ kalhac, ma mbu sôc malac gi. Ma iŋ sôm têŋ iŋ ndê lau, ");
INSERT INTO buk_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ameŋ ma alic ŋgac daŋ! Iŋ kêyalê gêŋ hoŋ naŋ aö gakôm, ma sôm asê têŋ aö. Oc mboe iŋ Mesaya dau?” ");
INSERT INTO buk_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Goc ŋac sêhu malac dau siŋ ma sêsa si bu sêlic Yisu. ");
INSERT INTO buk_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Têŋ ndoc awhê dau mbu sôc malac gi, naŋ ŋgacsêŋomi sêsôm têŋ Yisu, “Kêdôhôŋwaga, yac akôc gêŋ tu am neŋ-ŋga.” ");
INSERT INTO buk_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Magoc iŋ sôm têŋ ŋac, “Aö neŋ gêŋ daneŋ-ŋga yêc, naŋ mac aŋyalê dom.” ");
INSERT INTO buk_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Goc sêndac dandi bu, “Mboe lau daŋ sêkêŋ gêŋ daneŋ-ŋga têŋ iŋ su, me?” ");
INSERT INTO buk_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ma Yisu sôm têŋ ŋac, “Aö daŋaŋ wambu iŋ naŋ kêkiŋ aö gameŋ, ma wandic dabiŋ iŋ ndê gweleŋ. Aneŋ gêŋ daneŋ-ŋga dau dinaŋ. ");
INSERT INTO buk_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Aŋgô su naŋ. Têŋ ndoc mac asô gêŋ ŋawhê sip ôm, naŋ mac asôm bu, ‘Ayô hale su goc yac oc dandic gêŋ ŋandô sa.’ Tigeŋ aö wasôm têŋ mac, bu ahôc nem tanôm sa, ma alic bu gêŋ ŋandô ôm-ŋga mbêc su. ");
INSERT INTO buk_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ma kwahic dec ŋgac gic gêŋ ŋandô sa-ŋga kôm iŋ ndê gweleŋ mbo. Ma gêŋ ŋandô naŋ iŋ gic sa, naŋ lau naŋ sêkêŋ whiŋ ma sêtap seŋ sêmbo tali-ŋga sa. Tu dinaŋ-ŋga iŋ naŋ sô gêŋ ŋawhê, lu iŋ naŋ gic ŋandô sa, naŋ lu-lu atac ŋayham sa sêwhiŋ dau. ");
INSERT INTO buk_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Yom gôliŋ daŋ yêc bocdec, ‘Ŋamalac daŋ sô gêŋ ŋawhê, ma daŋ tiyham gic gêŋ ŋandô sa.’ Yom dau iŋ yom ŋandô, ma hêganôŋ gweleŋ ŋawaê ŋayham-ŋga whiŋ. ");
INSERT INTO buk_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Bu aö kakiŋ mac bu andic gêŋ ŋandô sa yêc ôm naŋ mac asô dom. Lau ŋatô sêkôm gweleŋ atu tu sêsô gêŋ-ŋga, dec mac atap ŋac si gweleŋ ŋa-ŋandô sa.” ");
INSERT INTO buk_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Têŋ ndoc awhê Samaria-ŋga dinaŋ sôm yom asê pi Yisu têŋ lau malac-ŋga bu, “Iŋ sôm gêŋ hoŋ naŋ aö gakôm su, naŋ asê têŋ aö,” naŋ lau Samaria-ŋga daêsam sêkêŋ whiŋ Yisu. ");
INSERT INTO buk_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ma têŋ ndoc sêsa sêtêŋ iŋ si, naŋ sêteŋ iŋ ŋapaŋ bu mbo whiŋ ŋac. Dec iŋ mbo whiŋ ŋac gitôm bêc lu. ");
INSERT INTO buk_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Iŋ sôm yom whiŋ lau malac-ŋga ma lau daêsam tiyham sêkêŋ whiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ma sêsôm têŋ awhê dinaŋ, “Têŋ ŋamata-ŋga yac aŋgô yom naŋ am sôm pi iŋ, dec akêŋ whiŋ iŋ. Magoc kwahic dec yac aŋgô iŋ dau ndê yom, ma yac aŋyalê pi ŋandô, bu iŋ ŋgac naŋ Anötö kêkiŋ bu nem lau nom-ŋga si.” ");
INSERT INTO buk_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Bêc lu dinaŋ pacndê su, goc Yisu tisa ma kêsêlêŋ gi e hôc asê gameŋ Galili-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Muŋ-ŋga iŋ sôm asê bu yêc propet daŋ ndê gameŋ, iŋ ndê lau oc sêtoc iŋ sa dom. ");
INSERT INTO buk_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Magoc têŋ ndoc iŋ hôc asê Galili, naŋ lau dinaŋ sêkôc iŋ sa ti atac ŋayham. Ŋahu bu ŋac sêmbo Jerusalem têŋ ndoc Pasowa-ŋga, ma sêlic gêŋ hoŋ naŋ iŋ kôm yêc dindê. ");
INSERT INTO buk_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Têŋ têm Yisu mbo gameŋ Galili-ŋga, naŋ iŋ sôc malac Kana gi tiyham, malac naŋ muŋ-ŋga iŋ gêm bu kwi ti wain. Têŋ ndoc dinaŋ ŋgac bata Rom-ŋga daŋ mbo malac Kapenaom, ma iŋ ndê atuŋgac gêmbac yêc. ");
INSERT INTO buk_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Balê dau gêmbac atu e kêpiŋ bu mbac ndu. Ma ŋgac bata dau ŋgô ŋawaê bu Yisu meŋ akêŋ gameŋ Judia-ŋga ma hôc asê Galili. Tu dinaŋ-ŋga dec iŋ têŋ iŋ gi, ma ndac iŋ bu têŋ malac Kapenaom ndi, ma kôm balê dau ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Dec Yisu sôm, “O mac lau! Mac bu alic gêŋ dalô atu-tu dom, dec oc akêŋ whiŋ dom.” ");
INSERT INTO buk_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Magoc ŋgac bata dau teŋ iŋ tiyham ma sôm, “O ŋadau, mweŋ ŋagahô! Bu mba, aneŋ balê oc mbac ndu.” ");
INSERT INTO buk_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Goc Yisu sôm têŋ iŋ, “Am ndi, am atôm oc mbo tali.” Ma ŋgac dau kêŋ whiŋ Yisu ndê yom, ma kölhö gi. ");
INSERT INTO buk_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Têŋ têm iŋ kêsêlêŋ mbo seŋ, naŋ iŋ ndê lau akiŋ ŋatô sêsa akêŋ Kapenaom sêmeŋ ma sêtap iŋ sa. Ma sêsôm têŋ iŋ bu, “Am nem balê ŋayham sa su.” ");
INSERT INTO buk_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Dec iŋ ndac ŋac bu, “Acgatu ŋasawa bocke ma balê dau ŋayham sa?” Ma ŋac sêsôm têŋ iŋ, “Alhabêc, têŋ ac ho dau, naŋ gêmbac hu iŋ siŋ ma iŋ ŋamlic ŋalhuc sa.” ");
INSERT INTO buk_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Têŋ dinaŋ damba ndê gauc sa bu acgatu ŋasawa dinaŋ eŋ, dec Yisu sôm têŋ iŋ bu, “Am atôm oc mbo tali.” Ma iŋ ti iŋ ndê lau hoŋ naŋ sêndöc sêwhiŋ iŋ, naŋ sêkêŋ whiŋ bu Yisu iŋ Mesaya dau. ");
INSERT INTO buk_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Gêŋ dalô tilu-ŋga naŋ Yisu kôm yêc malac Kana, naŋ ŋamiŋ dau dinaŋ. Yisu kôm gêŋ dau têŋ têm iŋ hu gameŋ Judia-ŋga siŋ, ma mbu têŋ gameŋ Galili-ŋga gi. ");
INSERT INTO buk_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tiŋambu lau Israel-ŋga si mwasiŋ atu daŋ ŋabêc hôc asê, ma Yisu mbu pi Jerusalem gi. ");
INSERT INTO buk_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yêc Jerusalem, bu ŋatoŋ atêc daŋ, naŋ sêwhê ŋa hoc ahuc, naŋ poc kêpiŋ malac dau ŋagatam naŋ sêsam bu Gatam Domba-ŋga. Sêsam bu ŋatoŋ dau ŋaê yêc Yom †Hibru bu Betesda, ma andu selep amaŋdaŋ sêlhac ŋamakê. ");
INSERT INTO buk_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ma yêc dinaŋ lau gêmbac daêsam sêyêc, lau tapec, lau bôliŋ ma lau ŋasac ŋatô.  ");
INSERT INTO buk_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tôm têm ŋatô Pômdau ndê aŋela daŋ oc sip meŋ ma kôm bu dau li sa. Lau gêmbac sêhôŋ têm dinaŋ, ma asa naŋ sip bu dau tiŋamata, naŋ oc ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ŋac si daŋ iŋ ŋgac bôliŋ naŋ gêmbac gitôm yala 38. ");
INSERT INTO buk_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Têŋ ndoc Yisu kêsêlêŋ mbo gameŋ dinaŋ, iŋ gêlic ŋgac bôliŋ dau, ma kêyalê bu iŋ gêmbac yêc ŋasawa hic baliŋ su, goc ndac iŋ, “Am tac whiŋ bu am ŋayham sa, me?” ");
INSERT INTO buk_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ma ŋgac bôliŋ dau sôm, “O ŋadau! Aö gahôŋ têm naŋ bu dindec ŋali sa, magoc ŋamalac daŋ mba bu nem aö sa. Ma aö bu wasip bu wandi, tigeŋ ŋamalac daŋ êlêmê hôc gêlêc aö su.” ");
INSERT INTO buk_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Goc Yisu sôm têŋ iŋ, “Tisa! Ma hôc nem mbô sa, ma êmsêlêŋ.” ");
INSERT INTO buk_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ma ŋagahô ŋgac dau ŋayham sa, goc hôc ndê mbô sa ma kêsêlêŋ gi. Yisu kôm gêŋ dinaŋ têŋ bêc †Sabat-ŋga daŋ. ");
INSERT INTO buk_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ma tu dinaŋ-ŋga lau bata Israel-ŋga sêsôm têŋ ŋgac naŋ Yisu kôm ŋayham sa bu, “Acsalô lec iŋ bêc Sabat-ŋga. Yac neŋ yomsu gic yao yac bu dakôm gweleŋ têŋ bêc Sabat-ŋga dom, ma bocke dec am kôc nem mbô ma kêsêlêŋ.” ");
INSERT INTO buk_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Magoc iŋ sôm, “Ŋgac naŋ kôm aö ŋayham sa, naŋ sôm têŋ aö bu, ‘Hôc nem mbô sa, ma êmsêlêŋ.’” ");
INSERT INTO buk_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ma sêndac iŋ, “Ŋgac naŋ sôm têŋ am bu am hôc nem mbô sa ma êmsêlêŋ, naŋ asa?” ");
INSERT INTO buk_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tigeŋ ŋgac dau kêyalê dom. Ŋahu bu têŋ ndoc Yisu kôm iŋ ŋayham sa, naŋ lau daêsam sêmbo, ma Yisu kêdahiŋ dau su sip ŋac ŋalôm ma kölhö gi. ");
INSERT INTO buk_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","T iŋambu Yisu tap iŋ sa tiyham mbo lôm dabuŋ, ma sôm têŋ iŋ, “Am ŋgô su naŋ! Am ŋayham sa su. Dec yob daôm bu kôm sac tiyham dom, mboe ŋawapac atu daŋ naŋ hôc gêlêc iŋ dinaŋ su, naŋ tap am sa tiŋambu.” ");
INSERT INTO buk_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ma têŋ dinaŋ ŋgac dau sa gi ma kêŋ ŋawaê têŋ lau bata Israel-ŋga, bu ŋgac naŋ kôm iŋ ŋayham sa, naŋ Yisu. ");
INSERT INTO buk_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Lau bata Israel-ŋga sêlic bu Yisu kôm gêŋ kaiŋ dinaŋ têŋ bêc Sabat-ŋga ŋatô, ma tu dinaŋ-ŋga sic hu sêkêŋ kisa iŋ. ");
INSERT INTO buk_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Dec iŋ sôm têŋ ŋac, “Damaŋ kôm iŋ ndê gweleŋ ŋapaŋ, têŋ têm ŋamata-ŋga e meŋ têŋ kwahic dec. Bocdinaŋ aö oc wanem gweleŋ.” ");
INSERT INTO buk_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Têŋ ŋamata-ŋga lau bata Israel-ŋga sêkêŋ kisa Yisu bu iŋ sôc yomsu Sabat-ŋga ŋapu dom. Ma têŋ ndoc sêŋgô iŋ ndê yom dinaŋ, naŋ sêkôm ŋaŋga bu sêndic iŋ ndu. Sêsôm, “Iŋ sam Anötö bu iŋ Damba ma bocdinaŋ iŋ bu po dau ndê waê sa nditôm Anötö dau.” ");
INSERT INTO buk_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Goc Yisu sôm têŋ ŋac, “Aö wasôm yom ŋandô têŋ mac. Oc tôm dom bu Anötö ndê Atu kôm gêŋ daŋ êŋkuc dau ndê atac whiŋ. Mba! Gêŋ bocke naŋ Atu gêlic Damba kôm, naŋ dec iŋ kôm. Bu Atu kôm gêŋ hoŋ gitôm Damba kôm. ");
INSERT INTO buk_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Damba atac whiŋ Atu kêlêc, ma tôc gêŋ hoŋ naŋ iŋ dau kôm, naŋ asê têŋ iŋ. Ma aö wasôm têŋ mac bu Damba oc hoc gêŋ atu-tu asê têŋ Atu bu kôm, naŋ hôc gêlêc gêŋ naŋ iŋ kôm, naŋ su. Ma têŋ têm mac alic gêŋ dau, naŋ mac oc asö. ");
INSERT INTO buk_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tôm Damba uŋ lau batê sa ma kêŋ ŋac sêmbo tali, naŋ iŋ ndê Atu dec kêŋ lau naŋ iŋ atac whiŋ ŋac, naŋ sêmbo tali boc-dinaŋ. ");
INSERT INTO buk_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ma gêŋ daŋ tiyham. Damba oc êŋsahê lau daŋ dom. Iŋ kêŋ ŋaclai têŋ iŋ ndê Atu bu êŋsahê lau pi ŋac si mêtê. ");
INSERT INTO buk_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ma tu dinaŋ-ŋga lau hoŋ naŋ sêtoc Atu ndê waê sa, naŋ sêtoc Damba ndê waê sa bocdinaŋ. Magoc asa naŋ toc Atu sa dom, naŋ toc Damba naŋ kêkiŋ iŋ meŋ, naŋ sa dom. ");
INSERT INTO buk_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Aö wasôm yom ŋandô têŋ mac, bu asa naŋ kôc aneŋ yom sa, ma kêŋ whiŋ iŋ naŋ kêkiŋ aö gameŋ, naŋ oc tap matôc sa dom. Iŋ hu seŋ mbac ndu-ŋga siŋ su, ma tap seŋ mbo tali ŋapaŋ-ŋga sa. ");
INSERT INTO buk_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Yomandô dec wasôm têŋ mac. Têm naŋ Anötö gic bata, naŋ kwahic dec meŋ su, dec lau naŋ sêmbo seŋ sêmbac ndu-ŋga, naŋ oc sêŋgô Anötö ndê Atu awha. Ma ŋac naŋ sêŋgô ma daŋga wambu, naŋ oc sêmbo tali. ");
INSERT INTO buk_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tali ŋahu yêc Damba dau, ma iŋ kêŋ tali ŋahu têŋ iŋ ndê Atu whiŋ. ");
INSERT INTO buk_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ma iŋ kêŋ ŋaclai têŋ iŋ bu êŋsahê ŋamalac, bu iŋ Ŋamalac ndê Atu. ");
INSERT INTO buk_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Asö tu yom dindec-ŋga dom. Ndoc oc meŋ, naŋ lau hoŋ naŋ sêmbac ndu su, naŋ oc sêŋgô Atu ndê awha, ");
INSERT INTO buk_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ma sêtisa akêŋ lau batê-ŋga. Lau naŋ sêkôm ŋayham, naŋ oc sêtisa ma sêtap Anötö ndê gameŋ sêndöc tali ŋapaŋ-ŋga sa. Magoc lau naŋ sêkôm sac, naŋ oc sêtisa ma sêtap matôc sa. ");
INSERT INTO buk_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Oc tôm dom bu aö wakôm gêŋ daŋ taŋwasêŋ. Ma aö oc waŋsahê ma wamatôc lau waŋkuc aö dauŋ neŋ gauc dom. Mba! Aö wamatôc lau waŋkuc yom naŋ Damaŋ, naŋ kêkiŋ aö gameŋ, naŋ sôm têŋ aö. Ma aö oc wakôm gêŋ dau waŋkuc lêŋ gitêŋ, ŋahu bu aö gakôm gêŋ daŋ tu aneŋ atac whiŋ-ŋga dom, aö gakôm gêŋ hoŋ kakuc Damaŋ ndê atac whiŋ.” ");
INSERT INTO buk_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Aö bu wahoc yom asê pi dauŋ, dec mac oc asôm bu aneŋ yom ŋandô mba, ma akêŋ whiŋ dom. ");
INSERT INTO buk_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Magoc Damaŋ hoc yom asê bu whê aneŋ ŋahu sa, ma aö kayalê bu iŋ ndê yom iŋ yom ŋandô. ");
INSERT INTO buk_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Jon, Ŋgac Kêku Lau-ŋga sôm yom ŋandô asê pi aö whiŋ, têŋ têm mac aŋkiŋ lau sêtêŋ iŋ si. ");
INSERT INTO buk_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Aö gapônda yom naŋ ŋamalac sêhoc asê pi aö, naŋ dom. Tigeŋ kwahic dec aö gasôm yom pi Jon, bu mboe mac akêŋ whiŋ yom naŋ iŋ sôm pi aö, dec atap Anötö ndê mwasiŋ nem mac si-ŋga sa. ");
INSERT INTO buk_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon mbo gitôm ya ŋawê naŋ pô gameŋ, ma gitôm ŋasawa apê mac atisambuc iŋ ndê ŋawê. ");
INSERT INTO buk_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Magoc gêŋ ŋatô sêpuŋ yom ŋandô pi aö dôŋ, naŋ hôc gêlêc Jon ndê yom pi aö. Alic gweleŋ naŋ aö gakôm gambo. Damaŋ dau kêŋ gweleŋ dinaŋ sip aö amaŋ tu bu wandic dabiŋ, ma gweleŋ dau tôc asê bu iŋ kêkiŋ aö gameŋ. ");
INSERT INTO buk_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ma Damaŋ dau, naŋ kêkiŋ aö gameŋ, naŋ hoc yom asê pi aö. Magoc mac lau daôm aŋgô iŋ ndê awha dom, ma mac alic iŋ aŋgô su dom. ");
INSERT INTO buk_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ma iŋ ndê yom yêc mac nem ŋalôm dom, ŋahu bu iŋ kêkiŋ aö gameŋ, magoc mac akêŋ whiŋ aö dom. ");
INSERT INTO buk_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mac asam Anötö ndê yom naŋ sêto yêc, naŋ ŋapaŋ, tu bu akip yom hoŋ ŋahu sa. Ŋahu bu mac gauc gêm bu mac oc atap seŋ andöc tamli-ŋga sa yêc yom dau ŋalôm. Yom dau dinaŋ hêganôŋ aö, ma whê aneŋ ŋahu sa, ");
INSERT INTO buk_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","tigeŋ mac atec bu atêŋ aö ameŋ, ma atap seŋ andöc tamli-ŋga dau sa. ");
INSERT INTO buk_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Aö gameŋ bu ŋamalac sêpo aö neŋ waêŋ sa dom. ");
INSERT INTO buk_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Magoc aö kayalê mac su, dec galic bu Anötö ndê atac whiŋ yêc mac nem ŋalôm dom. ");
INSERT INTO buk_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Aö gameŋ gam Damaŋ aŋgô, tigeŋ mac akôc aö sa dom. Magoc ŋamalac daŋ naŋ meŋ tu dau-ŋga, naŋ mac akôc iŋ sa ŋagahô eŋ. ");
INSERT INTO buk_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mac atac whiŋ bu atap waêm sa yêc mac daôm nem lau, magoc akôm bu atap waêm sa yêc Anötö tigeŋ ndê dom. Ma bocdinaŋ, mac oc akêŋ whiŋ aö ŋalêŋ bocke? ");
INSERT INTO buk_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Gauc nem bu aö dauŋ oc wasôm mac nem giso asê yêc Damaŋ aŋgô-ŋga dom. Mba! Mac akêŋ batam bu yomsu naŋ Moses to, naŋ oc ti mac nem seŋ andöc tamli ŋapaŋ-ŋga, tigeŋ yomsu dau oc tôc nem giso asê. ");
INSERT INTO buk_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ŋahu bu Moses dau to yom pi aö, ma mac bu akêŋ whiŋ iŋ, dec oc akêŋ whiŋ aö. ");
INSERT INTO buk_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tigeŋ mac akêŋ whiŋ yom naŋ iŋ to, naŋ dom, ma bocdinaŋ mac oc akêŋ whiŋ aneŋ yom ŋalêŋ nde? Oc tôm dom!” ");
INSERT INTO buk_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tiŋambu Yisu kôc ndê ŋgac-sêŋomi sa ma sic Bugictoŋ Galili-ŋga kic ma sêpi daŋga si. (Bugictoŋ dau sêsam ŋaê daŋ bu Taibirias.) ");
INSERT INTO buk_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ma lau daêsam sêŋkuc iŋ si, ŋahu bu ŋac sêlic gêŋ dalô naŋ iŋ kôm têŋ ndoc iŋ kôm lau gêmbac ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Têŋ têm dinaŋ lau Israel si om atu Mwasiŋ Pasowa-ŋga meŋ kêpiŋ tiyham. Yêc bugictoŋ ŋadaŋga, Yisu pi lôc daŋ gi ma ndöc sic whiŋ iŋ ndê ŋgacsêŋomi. ");
INSERT INTO buk_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ma iŋ hôc tandô sa ma gêlic lau daêsam naŋ sêwê sêmeŋ, goc sôm têŋ Pilip, “Danemlhi gêŋ daneŋ-ŋga yêc nde, bu dakêŋ têŋ lau daêsam dindec sêneŋ?” ");
INSERT INTO buk_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Iŋ dau kêyalê gêŋ naŋ iŋ bu kôm, naŋ su, magoc sôm yom dinaŋ bu êŋsahê Pilip. ");
INSERT INTO buk_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ma Pilip ô yom ma sôm, “Oc tôm dom andô! Mone atu gitôm †denarii 200 bu ndöc, ma dakôc mone dau ma danemlhi gêŋ daneŋ-ŋga, tigeŋ oc tôm dom bu lau daêsam dindec sêneŋ ŋagec-ŋagec.” ");
INSERT INTO buk_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Têŋ dinaŋ Yisu ndê ŋgacsêŋom daŋ, Saimon Pita ndê asi Andru, sôm têŋ Yisu, ");
INSERT INTO buk_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Balê daŋ mbo, naŋ kôc bolom amaŋdaŋ ma i lu. Tigeŋ gêŋ dinaŋ oc nditôm lau hoŋ dindec dom andô!” ");
INSERT INTO buk_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Goc Yisu sôm, “Mac asôm têŋ lau bu sêndöc sic.” Kwaŋ daêsam yêc gameŋ dinaŋ, ma lau hoŋ sêndöc sic sêndöc kwaŋ. Lau toŋ dinaŋ si lauŋgac gitôm 5,000. ");
INSERT INTO buk_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ma Yisu kôc bolom ma gêm daŋge, goc kêŋ têŋ lau naŋ sêndöc dinaŋ, bu sêndic sam têŋ dandi. Ma iŋ gêm mbec i lu ma kêŋ têŋ ŋac bocdinaŋ, ma ŋac seŋ tôm si atac whiŋ. ");
INSERT INTO buk_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ŋac seŋ e hôc ŋac dôŋ, goc iŋ sôm têŋ ŋgacsêŋomi, “Mac andic ŋadêlê hoŋ sa, bu taŋyaiŋ gêŋ daŋ dom.” ");
INSERT INTO buk_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bolom amaŋdaŋ ma i lu dinaŋ, lau seŋ e gitôm, ma ŋgacsêŋomi sic ŋadêlê sa sip gatop 12 e meŋhu. ");
INSERT INTO buk_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Lau sêlic gêŋ dalô atu naŋ Yisu kôm, goc sêsôm têŋ dau, “Yomandô! Propet atu naŋ dakêŋ bataŋ bu sip nom meŋ, naŋ ŋgac dau dindec, me?” ");
INSERT INTO buk_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Têŋ dinaŋ Yisu kêyalê bu ŋac gauc gêm bu sêkôm ŋaŋga bu sêkôc iŋ sa ma sêkêŋ iŋ ti ŋac si kiŋ. Dec iŋ kêdahiŋ dau su, ma kölhö tawasê pi lôc daŋ gi. ");
INSERT INTO buk_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Têŋ ac gi sip, Yisu ndê ŋgacsêŋomi sêmbu sêtêŋ bugictoŋ si. ");
INSERT INTO buk_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ŋac bu sêndic bu kic ma sêmbu sêtêŋ malac Kapenaom sêndi, dec sêpi waŋ daŋ ma sêsa si. Ŋasec sa su, magoc Yisu meŋ hôc asê ŋac su dom. ");
INSERT INTO buk_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","19","Ŋac sêhêc waŋ sêsa ŋasawa baliŋ gitôm 5 kilometa, ma mbu puc ŋadinda e gêli bu ŋampoŋ sa. Têŋ dinaŋ sêlic Yisu kêsêlêŋ mbo bu ŋahô meŋ kêpiŋ waŋ, dec sêtöc dau atu. ");
INSERT INTO buk_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Magoc iŋ sôm têŋ ŋac, “Atöc daôm dom! Bu aö dauŋ dindec.” ");
INSERT INTO buk_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Goc sêkôc iŋ pi waŋ ti atac ŋayham, ma ŋagahô sêhôc asê baö yêc Kapenaom. ");
INSERT INTO buk_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Têŋ ŋagalaŋsê, lau daêsam naŋ sêmbo sêwhiŋ Pômdau têŋ ndoc iŋ gêm daŋge bolom ma kêŋ têŋ ŋac seŋ, naŋ gacgeŋ sêmbo bugictoŋ ŋadaŋga. Ŋac sêŋyalê bu waŋ tigeŋ dinaŋ ŋgacsêŋomi sêpi ma sêlhö si, ma bu Yisu pi waŋ dau whiŋ ŋac dom. Malô goc waŋ ŋatô akêŋ malac Taibirias sêmeŋ sêsôc baö yêc dinaŋ. ");
INSERT INTO buk_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ŋac sêlic su bu Yisu ti iŋ ndê ŋgacsêŋomi sêmbo dom, dec sêpi waŋ dau, ma sêtêŋ malac Kapenaom si bu sêŋsalê Yisu. ");
INSERT INTO buk_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ŋac sic bugictoŋ kic, ma sêtap Yisu sa, goc sêsôm, “Kêdôhôŋwaga, am mweŋ têŋ nde?” ");
INSERT INTO buk_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ma Yisu ô yom ma sôm, “Yom ŋandô aö wasôm têŋ mac. Aö gakôm gêŋ dalô naŋ tôm bu whê mac nem gauc sa pi aö neŋ ŋahu. Magoc mac aŋsalê aö ma atac whiŋ bu ambo awhiŋ aö tu gêŋ dinaŋ-ŋga dom. Mba. Mac atac whiŋ bu ambo awhiŋ aö, ŋahu bu aö gakêŋ bolom têŋ mac aŋ e hôc mac dôŋ. ");
INSERT INTO buk_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Akôm mwasac bu atap gêŋ daneŋ-ŋga naŋ gic waê bu niŋga, naŋ sa lec dom. Mba! Akôm mwasac tu bu atap gêŋ daneŋ-ŋga naŋ oc kêŋ mac ambo tamli ŋapaŋ, naŋ sa. Ma gêŋ dau Ŋamalac ndê Atu oc kêŋ têŋ mac, bu Damba Anötö kêyaliŋ iŋ sa su, ma kêŋ ŋaclai têŋ iŋ bu kôm gêŋ dau.” ");
INSERT INTO buk_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Goc ŋac sêndac iŋ, “Gitôm bu am whê sa têŋ yac, gêŋ naŋ Anötö atac whiŋ bu yac akôm?” ");
INSERT INTO buk_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ma Yisu sôm, “Anötö ndê atac whiŋ ŋandô bu mac akôm gêŋ bocdec. Akêŋ whiŋ ŋgac naŋ iŋ kêkiŋ iŋ meŋ.” ");
INSERT INTO buk_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Goc ŋac sêsôm, “Muŋ-ŋga yac mba abaŋi sêmbo gameŋ sawa ma seŋ mana ti ŋac si gêŋ daneŋ-ŋga, tôm yom naŋ sêto yêc bocdec, ‘Iŋ kêŋ bolom undambê-ŋga têŋ ŋac seŋ.’ Kwahic dec yac bu andac am bu kôm gêŋ dalô kaiŋ tigeŋ. Yac bu alic, dec yac oc akêŋ whiŋ am.” ");
INSERT INTO buk_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Goc Yisu sôm, “Mac gauc gêm bu Moses kêŋ bolom undambê-ŋga têŋ mac. Magoc aö wasôm yom ŋandô têŋ mac bu aneŋ Damaŋ oc kêŋ bolom ŋandô undambê-ŋga têŋ mac. ");
INSERT INTO buk_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ma Anötö ndê bolom dau dec, iŋ naŋ sip akêŋ undambê meŋ ma kêŋ lau nom-ŋga sêndöc tali ŋapaŋ.” ");
INSERT INTO buk_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Lau sêŋgô Yisu ndê yom dau, goc sêsôm têŋ iŋ, “Pômdau, kwahic dec ma ndi, yac atac whiŋ bu am kêŋ bolom dau dinaŋ têŋ yac.” ");
INSERT INTO buk_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Goc Yisu sôm, “Bolom naŋ kêŋ ŋamalac sêndöc tali, naŋ aö dauŋ dec. Lau naŋ sêtêŋ aö sêmeŋ, naŋ gêŋ oc yô ŋac tiyham dom. Ma lau naŋ sêkêŋ whiŋ aö, naŋ bu oc yô ŋac tiyham dom. ");
INSERT INTO buk_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Tigeŋ tôm aö gasôm têŋ mac su, mac alic aö su, magoc akêŋ whiŋ aö dom. ");
INSERT INTO buk_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Lau bocke naŋ Damaŋ kêŋ têŋ aö, naŋ hoŋ oc sêtêŋ aö sêmeŋ. Ma lau naŋ sêtêŋ aö sêmeŋ, naŋ oc tôm dom bu wasoc ŋac si daŋ su. ");
INSERT INTO buk_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Aö gasip akêŋ undambê gameŋ, bu wakôm gêŋ tôm aö dauŋ neŋ atac whiŋ dom. Mba! Aö gasip gameŋ, bu wakôm gêŋ tôm Damaŋ naŋ kêkiŋ aö gameŋ, naŋ ndê atac whiŋ. ");
INSERT INTO buk_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ma Damaŋ atac whiŋ bu aö wayob ŋamalac hoŋ naŋ iŋ kêŋ têŋ aö, bu ŋac si daŋ niŋga dom. Aö wauŋ ŋac hoŋ sa têŋ bêc ŋambu-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Damaŋ ndê atac whiŋ bocdec bu, lau hoŋ naŋ sêŋyalê iŋ ndê Atu, ma sêkêŋ whiŋ iŋ, naŋ oc sêtap seŋ sêndöc tali-ŋga sa, ma aö wauŋ ŋac sa têŋ bêc ŋambu-ŋga.” ");
INSERT INTO buk_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Têŋ ndoc naŋ lau bata Israel-ŋga sêŋgô Yisu sôm bu iŋ bolom naŋ sip akêŋ undambê meŋ, naŋ sêli awha sa pi iŋ. ");
INSERT INTO buk_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ŋac sêsôm têŋ dandi, “Ŋgac dindec iŋ Yisu, Josep ndê atuŋgac. Yac taŋyalê iŋ dinda lu damba. Bocke ma kwahic dec iŋ sôm têŋ yac bu iŋ sip akêŋ undambê meŋ?” ");
INSERT INTO buk_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Dec Yisu sôm, “Ali awham sa têŋ daôm dom! ");
INSERT INTO buk_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Lau daŋ gitôm dom bu sêtêŋ aö sêmeŋ ŋambwa. Damaŋ naŋ kêkiŋ aö gameŋ, naŋ bu kac ŋac si gauc kwi, dec oc tôm bu sêtêŋ aö sêmeŋ. Ma aö oc wauŋ ŋac sêtisa têŋ bêc ŋambu-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Sêto propet akwa daŋ ndê yom yêc bocdec bu, ‘Anötö oc êndôhôŋ ŋamalac hoŋ.’ Bocdinaŋ dec aŋgô. Lau hoŋ naŋ sêkêŋ daŋga Damaŋ ndê yom ma iŋ kêdôhôŋ ŋac, naŋ oc sêtêŋ aö sêmeŋ. ");
INSERT INTO buk_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Yom dau sôm bu Anötö oc êndôhôŋ lau, magoc ŋamalac daŋ gêlic Damaŋ su dom. Anötö ndê Atu naŋ mbo whiŋ iŋ ma sip nom meŋ, iŋ tigeŋ gêlic iŋ. ");
INSERT INTO buk_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ma aö wasôm yom ŋandô. Asa naŋ kêŋ whiŋ Atu, naŋ tap seŋ ndöc tali ŋapaŋ-ŋga sa su. ");
INSERT INTO buk_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Bolom kêŋ ŋamalac sêndöc tali-ŋga, naŋ aö dauŋ dindec. ");
INSERT INTO buk_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mac nem apami seŋ mana yêc gameŋ sawa, magoc tiŋambu ŋac hoŋ sêmbac ndu. ");
INSERT INTO buk_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Tigeŋ bolom naŋ sip akêŋ undambê meŋ, iŋ bolom kaiŋ daŋ. Ŋamalac daŋ bu neŋ, dec oc niŋga dom. ");
INSERT INTO buk_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ma bolom tali-ŋga naŋ sip akêŋ undambê meŋ, naŋ aö dauŋ dec. Ŋamalac daŋ bu neŋ bolom dindec, dec oc ndöc tali ŋapaŋ. Ma bolom dau dinaŋ aö neŋ ŋamsôm, naŋ aö oc wakêŋ bu lau hoŋ naŋ sêkêŋ whiŋ aö, naŋ oc sêndöc tali ŋapaŋ.” ");
INSERT INTO buk_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Têŋ dinaŋ lau bata Israel-ŋga sêseŋ dandi ŋandô, ma sêsôm têŋ dau, “Bocke ma ŋgac dindec sôm bu kêŋ iŋ ndê ŋamsôm têŋ yac daneŋ?” ");
INSERT INTO buk_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ma Yisu sôm têŋ ŋac, “Yomandô aö wasôm têŋ mac. Mac bu aneŋ Ŋamalac ndê Atu ndê ŋamsôm ti anôm iŋ ndê dac dom, dec oc tôm dom bu mac atap seŋ andöc tamli-ŋga sa. ");
INSERT INTO buk_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Asa naŋ bu neŋ aö neŋ ŋamsôm, ma nôm aneŋ dac, naŋ tap seŋ ndöc tali ŋapaŋ-ŋga sa su. Ma aö oc wauŋ iŋ sa têŋ bêc ŋambu-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Bu aö neŋ ŋamsôm ti gêŋ aneŋ-ŋga ŋandô, ma aö neŋ dac ti gêŋ anôm-ŋga ŋandô. ");
INSERT INTO buk_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Asa naŋ bu neŋ aö neŋ ŋamsôm, ma nôm aö neŋ dac, naŋ gêŋ dau oc piŋ alu dôŋ anem damiŋ dauŋ. Iŋ oc mbo aö ŋalôm, ma aö wambo iŋ ndê ŋalôm. ");
INSERT INTO buk_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tali ŋahu yêc Damaŋ naŋ kêkiŋ aö gameŋ, ma aö dauŋ gambo taŋli tu iŋ-ŋga. Bocdinaŋ asa naŋ kôc aö sa ti iŋ ndê gêŋ daneŋ-ŋga ŋandô, naŋ oc mbo tali tu aö-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mac damami seŋ mana, magoc tiŋambu sêmbac ndu. Bolom naŋ sip akêŋ u ndambê meŋ, naŋ aö dauŋ dindec. Ma asa naŋ bu neŋ bolom dindec, naŋ oc mbo tali ŋapaŋ.” ");
INSERT INTO buk_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yisu sôm yom hoŋ dinaŋ têŋ ndoc iŋ kêdôhôŋ lau mbo lôm wê-ŋga yêc malac Kapenaom. ");
INSERT INTO buk_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Têŋ ndoc sêŋgô Yisu ndê yom dinaŋ, goc iŋ ndê †sêŋomi daêsam sêsôm, “Aluê! Yom dinaŋ ŋawapac ŋandô! Asa gitôm bu oc kôc sa ma êŋyalê?” ");
INSERT INTO buk_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yisu kêyalê bu iŋ ndê sêŋomi sêtucdiŋ tu iŋ ndê yom-ŋga, dec sôm, “Yom dindec kêŋ wapac mac, a? ");
INSERT INTO buk_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Bocdinaŋ, têŋ ndoc mac alic Ŋamalac ndê Atu mbu pi gameŋ naŋ iŋ mbo têŋ ŋamata-ŋga ndi, naŋ mac oc akêŋ whiŋ, me oc kêŋ wapac mac êŋlêc? ");
INSERT INTO buk_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ŋamalac si gauc me licwalô oc tôm dom bu kêŋ ŋac sêndöc tali. Ŋalau tigeŋ kêŋ ŋamalac sêndöc tali ŋapaŋ. Ma yom naŋ aö gasôm têŋ mac, naŋ Ŋalau tigeŋ oc whê mac nem gauc sa e aŋyalê, ma bocdinaŋ atap seŋ andöc tamli ŋapaŋ-ŋga sa. ");
INSERT INTO buk_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Magoc mac nem lau ŋatô sêkêŋ whiŋ aö dom.” (Yisu sôm yom dinaŋ bu iŋ kêyalê gwanaŋ lau ŋatô naŋ sêkêŋ whiŋ iŋ dom, ma ŋgac naŋ oc hoc iŋ asê.) ");
INSERT INTO buk_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ma iŋ gic têku yom ma sôm, “Tu dinaŋ-ŋga dec aö gasôm bu lau daŋ sêtôm dom bu sêtêŋ aö sêmeŋ ŋambwa. Damaŋ bu kêŋ ŋaclai têŋ ŋac, dec oc tôm.” ");
INSERT INTO buk_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Têŋ dinaŋ Yisu ndê sêŋomi daêsam sêhu iŋ siŋ ma sêŋkuc iŋ tiyham dom. ");
INSERT INTO buk_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Goc iŋ ndac iŋ ndê ŋ gacsêŋomi 12 bu, “Ma bocke? Mac bu ahu aö siŋ awhiŋ, a?” ");
INSERT INTO buk_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ma Saimon Pita sôm, “Pômdau, yac oc atêŋ asa andi? Am tamwasêm sôm yom naŋ tôm bu kêŋ yac andöc taŋli ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Yac aŋyalê ma akêŋ whiŋ bu am Anötö ndê ŋgac dabuŋ am.” ");
INSERT INTO buk_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Goc Yisu ô yom ma sôm, “Aö dauŋ kayaliŋ mac lau 12 sa. Magoc aö kayalê su bu mac nem ŋgac daŋ ti Sadaŋ ndê su.” ");
INSERT INTO buk_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iŋ sôm yom dinaŋ pi Judas, Saimon Iskeriot ndê atuŋgac. Bu Judas iŋ ŋgacsêŋomi 12 si daŋ, naŋ tiŋambu hoc Yisu asê. ");
INSERT INTO buk_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tiŋambu Yisu kêsêlêŋ golom-golom malac naŋ sêyêc gameŋ Galili-ŋga. Iŋ mbo ahê gameŋ Judia-ŋga, bu iŋ kêyalê bu lau bata Israel-ŋga naŋ sêmbo gameŋ dinaŋ, naŋ atac whiŋ bu sêndic iŋ ndu. ");
INSERT INTO buk_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Têŋ ndoc lau Israel si †Mwasiŋ atu Lôm Bac-ŋga meŋ kêpiŋ, naŋ ");
INSERT INTO buk_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yisu ndê asii sêsôm, “Yac gauc gêm bu ŋayham bu am sip têŋ gameŋ Judia-ŋga ndi. Bu am nem sêŋomi ŋatô sêmbo dindê, dec kôm gêŋ dalô bu ŋac sêlic. ");
INSERT INTO buk_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ŋamalac daŋ bu kôm dau ti ŋgac tiwaê, naŋ siŋ dau dom. Am kôm gêŋ dalô daêsam, bocdinaŋ tôc daôm asê têŋ ŋamalac hoŋ.” ");
INSERT INTO buk_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yisu ndê asii sêsôm yom dinaŋ, ŋahu bu sêkêŋ whiŋ iŋ dom. ");
INSERT INTO buk_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","8","Dec Yisu sôm têŋ iŋ ndê asii, “Aö oc wasip gameŋ Judia-ŋga wandi dom, bu aneŋ ndoc yêc dôŋ yêc. Lau sac nom-ŋga sêtec aö, bu aö êlêmê gahoc yom asê pi gêŋ giso hoŋ naŋ ŋac sêkôm. Magoc lau nom-ŋga sêtec mac dom, ma bocdinaŋ mac api Jerusalem andi, tu Mwasiŋ dinaŋ-ŋga. Mac atôm bu akôm gêŋ têŋ têm bocke naŋ mac atac whiŋ, magoc aneŋ têm hôc asê su dom.” ");
INSERT INTO buk_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yisu sôm yom dinaŋ su, ma gacgeŋ mbo Galili. ");
INSERT INTO buk_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Tigeŋ têŋ ndoc iŋ ndê asii sêpi Jerusalem si bu sêlic om atu Lôm Bac-ŋga, naŋ iŋ kêkuc ŋac gi. Magoc iŋ siŋ dau bu lau sêlic iŋ dom. ");
INSERT INTO buk_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Lau bata Israel-ŋga naŋ sêmbo Jerusalem tu Mwasiŋ dinaŋ-ŋga, naŋ taso iŋ ma sêndac, “Ŋgac dinaŋ mbo nde?” ");
INSERT INTO buk_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ma lau daêsam naŋ sêmbo malac dinaŋ, naŋ sic yom sec têŋ dandi pi Yisu. Ŋatô sêsôm, “Iŋ ŋgac ŋayham.” Ma ŋatô sêsôm, “Mba! Iŋ kêsau lau.” ");
INSERT INTO buk_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Magoc ŋamalac daŋ sôm yom pi Yisu yêc awê dom, bu sêtöc lau bata Israel-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Bêc ŋatô giŋga su ma Mwasiŋ Lôm Bac-ŋga gi sa ŋalhu. Ma têŋ dinaŋ, Yisu sôc lôm dabuŋ ŋabatêmndö gi, ma gic hu kêdôhôŋ lau. ");
INSERT INTO buk_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Iŋ ndê yom kôm lau bata Israel-ŋga sêhêdaê ma sêsôm, “Ŋgac dindec sôc lôm dom, ma bocke dec iŋ kêdôhôŋ lau ŋa yom ti gauc atu-tu?” ");
INSERT INTO buk_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ma Yisu sôm, “Aö kadôhôŋ aö dauŋ neŋ yom dom, magoc iŋ naŋ kêkiŋ aö gameŋ, naŋ ndê yom. ");
INSERT INTO buk_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Lau naŋ atac whiŋ bu daŋga wambu Anötö, naŋ oc sêŋyalê bu yom hoŋ naŋ aö kadôhôŋ, naŋ meŋ akêŋ Anötö ndê, ma aö neŋ yom dom. ");
INSERT INTO buk_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Asa naŋ sôm dau ndê yom, naŋ bu po dau ndê waê sa. Magoc aö bu wapo iŋ naŋ kêkiŋ aö gameŋ, naŋ ndê waê sa. Aö kasau dom, aö gasôm yom ŋandô. ");
INSERT INTO buk_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses kêŋ yomsu têŋ mac, magoc mac ne m daŋ daŋga wambu ŋapep dom. Tu sake-ŋga mac asôm bu aö kagilì yomsu, dec atac whiŋ bu andic aö ndu?” ");
INSERT INTO buk_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Goc lau ŋatô sêsôm, “Asa tac whiŋ bu ndic am ndu? Ŋalau sac daŋ oc sip am nem ŋalôm su!” ");
INSERT INTO buk_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ma Yisu sôm têŋ ŋac, “Aö gakôm gêŋ dalô daŋ têŋ bêc Sabat-ŋga, ma mac hoŋ asö. ");
INSERT INTO buk_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mac aŋgôliŋ yom pi aö ma asôm bu aö kagilì y omsu Sabat-ŋga, magoc mac daôm akôm gweleŋ têŋ bêc Sabat-ŋga. Mac aŋkuc †pwac asê balêi si ŋamlic ŋatô su-ŋga, tôm Moses to ma gic dulu têŋ mac. (Pwac dau Anötö kêŋ têŋ Moses dom, magoc kêmwatiŋ têŋ abaŋi muŋ su.) Mac asê balêi si ŋamlic têŋ ŋac si bêc ti-8-ŋga, ma bocdinaŋ balêi ŋatô mac asê ŋac têŋ bêc Sabat-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mac alic ŋayham bu akôm gêŋ dau têŋ Sabat tu bu aŋgilì Moses ndê yomsu dom. Aö dec gakôm ŋamalac daŋ ndê ŋamlic sambuc ŋayham sa têŋ bêc Sabat-ŋga, ma bocdinaŋ tu sake-ŋga mac atac ŋandê têŋ aö? ");
INSERT INTO buk_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Alic gêŋ awê-ŋga ŋambwa tu amatôc yom-ŋga dom! Akôc gauc ŋapep pi gêŋ ŋalôm-ŋga whiŋ.” ");
INSERT INTO buk_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","T êŋ ndoc dinaŋ lau Jerusalem-ŋga ŋatô sêsôm, “Ŋgac dindec iŋ ŋgac naŋ lau bata sêŋsalê lêŋ tu bu sêndic iŋ ndu-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tigeŋ alic! Iŋ sôm yom mbo awê, magoc lau bata sêsôm yom daŋ têŋ iŋ dom. Bocke? M boe ŋac sêkêŋ whiŋ bu iŋ Mesaya dau, me? ");
INSERT INTO buk_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Tigeŋ yac aŋyalê ŋgac dindec ndê malachu. Ma têŋ ndoc Mesaya oc meŋ, naŋ lau daŋ oc sêŋyalê gameŋ naŋ iŋ meŋ akêŋ, naŋ dom.” ");
INSERT INTO buk_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yisu kêdôhôŋ lau mbo lôm dabuŋ ŋabatêmndö têŋ têm dinaŋ, ma iŋ ta yom bocdec bu, “Mac lau dinaŋ gauc gêm bu mac aŋyalê aö, ma bu mac aŋyalê a ö neŋ malachu, a? Aö gameŋ ŋa aö dauŋ neŋ ŋaclai dom. Aö Damaŋ kêkiŋ aö gameŋ, ma iŋ Anötö ŋandô, magoc mac aŋyalê iŋ dom. ");
INSERT INTO buk_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Aö dec kayalê iŋ, bu muŋ-ŋga aö gambo gawhiŋ iŋ, ma kwahic dec iŋ kêkiŋ aö gameŋ.” ");
INSERT INTO buk_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Têŋ dinaŋ ŋac sêŋsahê bu sêkôc iŋ dôŋ, tigeŋ iŋ ndê ndoc yêc dôŋ yêc, dec lau daŋ gitôm dom bu sêkêŋ amba pi iŋ. ");
INSERT INTO buk_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Magoc lau daêsam yêc toŋ atu dinaŋ sêkêŋ whiŋ iŋ ma sêsôm, “Yac akêŋ bataŋ Mesaya, ma akêŋ whiŋ bu têŋ ndoc iŋ meŋ, naŋ iŋ oc kôm gêŋ dalô daêsam. Tigeŋ asa gitôm bu kôm gêŋ dalô atu-tu naŋ sêhôc gêlêc gêŋ dalô daêsam naŋ ŋgac dindec kôm, naŋ su?” ");
INSERT INTO buk_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Lau Palêsai sêŋgô bu lau sem yomgalôm pi Yisu ma sêkôc gauc kaiŋ dinaŋ pi iŋ. Goc †dabuŋsiga atu-tu ti lau Palêsai sêŋkiŋ lau siŋ-ŋga ŋatô naŋ sêyob lôm dabuŋ, bu sêkôc iŋ dôŋ. ");
INSERT INTO buk_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Têŋ dinaŋ Yisu sôm, “Aö wambo wawhiŋ mac ŋasawa sauŋ, goc walhö wambu watêŋ iŋ naŋ kêkiŋ aö gameŋ, naŋ wandi. ");
INSERT INTO buk_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mac oc aŋsalê aö, magoc oc atap aö sa dom, ma mac atôm dom bu aŋkuc aö atêŋ gameŋ naŋ aö oc wambo.” ");
INSERT INTO buk_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Goc lau Israel-ŋga sêsôm têŋ dandi, “Ŋgac dindec oc mbo nde, dec yac oc datôm dom b u datap iŋ sa? Mboe iŋ oc ndi mbo whiŋ yac neŋ lau Israel-ŋga ŋatô, naŋ sêndöc lau Grik si gameŋ ma êndôhôŋ lau Grik yêc dindê? ");
INSERT INTO buk_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Iŋ sôm bu yac oc taŋsalê iŋ, magoc oc datap iŋ sa dom, ma bu yac datôm dom bu datêŋ gameŋ naŋ iŋ oc mbo, naŋ dandi. Yom dau ŋahu bocke?” ");
INSERT INTO buk_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Têŋ Mwasiŋ Lôm Bac-ŋga ŋabêc atu ŋambu-ŋga, naŋ Yisu tisa kalhac ma mbwêc awha atu bocdec bu, “Am asa naŋ bu yô am, naŋ têŋ aö mweŋ, ma nôm. ");
INSERT INTO buk_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tôm Anötö ndê yom naŋ sêto yêc, naŋ sôm, asa naŋ kêŋ whiŋ aö, naŋ bu tali-ŋga oc êmbulup pi iŋ ndê ŋalôm.” ");
INSERT INTO buk_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yisu ndê yom dinaŋ hêganôŋ Ŋalau Dabuŋ, naŋ tiŋambu Anötö oc kêŋ têŋ lau naŋ sêkêŋ whiŋ Yisu. (Têŋ têm dinaŋ, Anötö kêŋ Ŋalau Dabuŋ têŋ lau su dom, ŋahu bu Yisu ndê têm tu tap iŋ ndê ŋawasi sa-ŋga yêc dôŋ yêc.) ");
INSERT INTO buk_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Têŋ ndoc Yisu sôm yom dau, naŋ lau ŋatô sêsôm, “Yomandô! Ŋgac dindec iŋ propet atu gitôm Moses, naŋ Anötö gic bata bu êŋkiŋ meŋ.” ");
INSERT INTO buk_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ma ŋatô sêsôm, “Mba! Iŋ Mesaya dau!” Magoc lau ŋatô sêsôm, “Mba! Bu Mesaya oc meŋ akêŋ gameŋ Galili-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Anötö ndê yom naŋ sêto yêc, naŋ sôm bu Mesaya oc meŋ sa yêc Kiŋ Dawid ndê wakuc, ma yêc Dawid ndê malac Betlehem.” ");
INSERT INTO buk_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Bocdinaŋ lau sêseŋ dau pi Yisu. ");
INSERT INTO buk_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Lau ŋatô tac whiŋ bu sêkôc iŋ dôŋ, magoc ŋamalac daŋ gitôm dom bu kêŋ amba pi iŋ. ");
INSERT INTO buk_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tiŋambu lau siŋ lôm dabuŋ-ŋga sêmbu sêtêŋ dabuŋsiga atu-tu ti lau Palêsai si. Ma ŋac sêndac lau siŋ-ŋga dau bocdec bu, “Bocke ma mac akôc Yisu dôŋ dom?” ");
INSERT INTO buk_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Goc lau siŋ-ŋga sêô yom ma sêsôm, “Ŋamalac naŋ sôm yom gitôm ŋgac dinaŋ, naŋ yac aŋgô daŋ su dom.” ");
INSERT INTO buk_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Goc lau Palêsai sêsôm, “Mboe iŋ kêsau mac awhiŋ, a? ");
INSERT INTO buk_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Alic bu yac lau Palêsai ma lau bata mba daŋ kêŋ whiŋ bu iŋ Mesaya dau dom. Mba andô! ");
INSERT INTO buk_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Tigeŋ lau ŋambwa-ŋambwa, naŋ si gauc sa dom pi Anötö ndê yom naŋ sêto yêc, naŋ sêkêŋ whiŋ iŋ. Anötö ndê atac ŋandê pi ŋac!” ");
INSERT INTO buk_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Lau bata dinaŋ si daŋ iŋ Nikodemas, ŋgac naŋ muŋ-ŋga gi gêlic Yisu. Têŋ ndoc iŋ ŋgô ŋac si yom dinaŋ, dec sôm têŋ ŋac bu, ");
INSERT INTO buk_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Yac neŋ yomsu gic yao bu dakic yom tu tamatôc ŋamalac daŋ-ŋga ŋambwa dom! Gêŋ ŋamata-ŋga daŋgô iŋ dau ndê yom, ma dakip yom sa pi gêŋ naŋ iŋ kôm.” ");
INSERT INTO buk_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Magoc ŋac sêsôm, “Mboe am bu ti iŋ ndê ŋgacsêŋom daŋ whiŋ ŋac lau Galili-ŋga dinaŋ, a? Am ndi ma kip ŋahu sa yêc Anötö ndê yom, ma am oc tap sa bu propet daŋ oc meŋ akêŋ gameŋ Galili-ŋga dom.” ");
INSERT INTO buk_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Dinaŋ su, ma lau hoŋ sêlhö têŋtêŋ ma sêmbu sêtêŋ ŋac si andu si. ");
INSERT INTO buk_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Goc Yisu hu malac Jerusalem siŋ ma sa gi mbo Lôc Olib. ");
INSERT INTO buk_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Têŋ ŋagalaŋsê bêbêc, iŋ mbu sôc Jerusalem gi, ma mbo lôm dabuŋ ŋabatêmndö. Ma lau daêsam sêwê sêtêŋ iŋ sêmeŋ, dec iŋ ndöc sic ma kêdôhôŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ma lau naŋ sêndôhôŋ yomsu ti lau Palêsai sêwê awhê daŋ sêtêŋ iŋ sêmeŋ, naŋ sêtap iŋ sa têŋ ndoc iŋ kôm mêtê mockaiŋ-ŋga. Ma sêkêŋ a whê dau kalhac lau hoŋ aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ma sêsôm têŋ Yisu, “Kêdôhôŋwaga, sêtap awhê dindec sa kôm mêtê mockaiŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moses to yomsu bu datuc lauwhê kaiŋ dindec ŋa hoc ndu. Bocdinaŋ sôm bu yac oc dakôm sake?” ");
INSERT INTO buk_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ŋac bu sêtim iŋ ŋa gêndac dinaŋ, sêŋsalê yom daŋ bu sêŋgôliŋ pi iŋ. Magoc Yisu pôŋ sic gi ndöc, ma gic hu to yom yêc nom ŋa amba-atu. ");
INSERT INTO buk_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Goc ŋac sêŋsu iŋ e iŋ tisa ma sôm têŋ ŋac, “Mac nem asa bu ndê sac mbasi, naŋ ti ŋgac ŋamata-ŋga bu kôc hoc ma tuc pi awhê dindec.” ");
INSERT INTO buk_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Goc iŋ pôŋ sic tiyham ma to yom yêc nom. ");
INSERT INTO buk_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Têŋ dinaŋ lau naŋ sêŋgô Yisu ndê yom sic hu sêlhö tigeŋ-tigeŋ. Lau atu-tu sêlhö sêmuŋ, goc lau ŋatô sêŋkuc e Yisu tawasê mbo, ma awhê dau kalhac iŋ aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Dec Yisu tisa ma ndac iŋ, “O awhê! Ma lau dau nde? Asa dec mbo bu êŋgôliŋ yom pi am ma êmatôc am?” ");
INSERT INTO buk_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ma iŋ sôm, “O ŋadau, lau mba!” Goc Yisu sôm, “Ma bocdinaŋ aö wamatôc am dom whiŋ. Magoc am lhö ndi, ma hu nem mêtê sac siŋ.” ");
INSERT INTO buk_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tiŋambu Yisu sôm yom têŋ lau bocdec bu, “Aö ŋawê nom-ŋga. Asa naŋ bu êŋkuc aö, naŋ oc sa seŋ ŋasec-ŋga tiyham dom. Iŋ oc êŋsêlêŋ mbo ŋawê naŋ tôc seŋ ndöc tali-ŋga asê.” ");
INSERT INTO buk_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Magoc lau Palêsai sêsôm têŋ iŋ, “Am tamwasêm hoc yom asê pi daôm. Tu dinaŋ-ŋga dec yac oc akôc am nem yom sa dom.” ");
INSERT INTO buk_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ma Yisu ô yom ma sôm, “Aö bu wahoc dauŋ neŋ yom asê, dec aneŋ yom dau iŋ yom ŋandô. Ŋahu bu aö kayalê gameŋ naŋ aö gameŋ akêŋ naŋ, ma gameŋ nde naŋ wambu wandi. Tigeŋ mac aŋyalê gameŋ dinaŋ dom. ");
INSERT INTO buk_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mac aŋsahê ti amatôc lau aŋkuc ŋamalac si gauc. Magoc aö dec wamatôc ŋamalac daŋ gitôm mac akôm, naŋ dom. ");
INSERT INTO buk_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Aö bu wamatôc lau, dec aneŋ yom hoŋ iŋ yom ŋandô, ŋahu bu aö taŋwasêŋ dom. Damaŋ naŋ kêkiŋ aö, naŋ mbo whiŋ aö. ");
INSERT INTO buk_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mac daôm nem yomsu sôm bu ŋgac lu bu sêpuc si yom dôŋ bu yom ŋandô, dec mac oc akôc yom dau sa. ");
INSERT INTO buk_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Kwahic dec aö gahoc yom asê tu dauŋ-ŋga, ma Damaŋ naŋ kêkiŋ aö, naŋ dec puc aneŋ yom dôŋ. Bocdinaŋ tu sake-ŋga mac akôc aneŋ yom sa dom?” ");
INSERT INTO buk_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Goc sêndac iŋ, “Am Damam nde?” Ma Yisu sôm, “Mac aŋyalê aö dom, ma mac aŋyalê Damaŋ dom bocdinaŋ. Mac bu aŋyalê aö, dec oc tôm bu mac aŋyalê Damaŋ whiŋ.” ");
INSERT INTO buk_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yisu sôm yom dinaŋ têŋ ndoc iŋ kêdôhôŋ lau mbo kêpiŋ apa naŋ lau sêkêŋ si da sip-ŋga yêc lôm dabuŋ ŋamakê. Magoc lau daŋ sêkôc iŋ dôŋ dom, bu iŋ ndê ndoc hôc asê su dom. ");
INSERT INTO buk_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ma Yisu sôm tiyham têŋ lau Palêsai, “Aö oc wahu mac siŋ, ma mac oc aŋsalê aö. Magoc gameŋ naŋ aö bu wandi, naŋ mac atôm dom bu andi. Mac oc ambac ndu ti nem sac tôhôŋ.” ");
INSERT INTO buk_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Goc lau bata dinaŋ sêsôm têŋ dandi, “Iŋ dau sôm bu gameŋ naŋ iŋ oc ndi, naŋ yac datôm dom bu dandi. Bocke? Iŋ oc ndic dau ndu, a?” ");
INSERT INTO buk_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ma Yisu gic têku yom ma sôm, “Aneŋ ŋahu yêc lôlôc. Mac lau nom dindec-ŋga, magoc aö neŋ ŋahu yêc nom dindec dom. ");
INSERT INTO buk_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Aö gasôm têŋ mac su, bu mac oc ambac ndu ti nem sac tôhôŋ. Aö wasôm yom ŋandô têŋ mac, bu mac bu akêŋ whiŋ yom naŋ aö gawhê sa pi dauŋ, naŋ dom, dec mac oc ambac ndu ti mac nem sac.” ");
INSERT INTO buk_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Goc ŋac sêndac, “Am asa?” Ma iŋ sôm, “Oc tôm bu mac aŋyalê su, bu têŋ ŋamata-ŋga e meŋ, aö gawhê dauŋ sa têŋ mac. ");
INSERT INTO buk_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yom daêsam yêc bu wasôm pi mac bu watôc nem giso asê. Magoc yom hoŋ naŋ aö gaŋgô yêc iŋ naŋ kêkiŋ aö gameŋ, naŋ dec wasôm asê têŋ lau nom-ŋga. Ma iŋ ndê yom iŋ yom ŋandô eŋ.” ");
INSERT INTO buk_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ŋac sêŋyalê dom bu iŋ sôm yom dau pi iŋ Damba. ");
INSERT INTO buk_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Goc iŋ sôm, “Têŋ ndoc mac asuŋ Ŋamalac ndê Atu sa yêc nom, naŋ mac oc aŋyalê bu aö dauŋ dec Mesaya dau, ma aö gakôm gêŋ daŋ kakuc aö taŋwasêŋ neŋ gauc dom. Mba. Yom hoŋ naŋ aö gasôm, naŋ Damaŋ dau kêŋ têŋ aö. ");
INSERT INTO buk_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Iŋ dau kêkiŋ aö gameŋ, ma iŋ oc tec aö bu wambo taŋwasêŋ dom. Iŋ mbo whiŋ aö ŋapaŋ. Ŋahu bu aö gakôm gêŋ hoŋ tôm iŋ atac whiŋ.” ");
INSERT INTO buk_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yisu sôm yom dinaŋ, ma lau daêsam naŋ sêŋgô, naŋ sêkêŋ whiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ma Yisu sôm têŋ lau Israel-ŋga naŋ sêkêŋ whiŋ iŋ, “Mac bu asap aneŋ yom dôŋ ma daŋam wambu, dec mac ati aneŋ sêŋomi ŋandô. ");
INSERT INTO buk_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ma mac oc aŋyalê yom ŋandô, ma yom ŋandô dau oc êŋgapwêc mac su bu ambo atôm lau akiŋ ŋambwa tiyham dom.” ");
INSERT INTO buk_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Goc ŋac sêsôm, “Abraham ndê wakuc yac. Ma yac am akiŋ lau daŋ dom. Bocdinaŋ am sôm bu êŋgapwêc yac su yêc sakiŋ bocke?” ");
INSERT INTO buk_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Goc Yisu ô yom bocdec bu, “Aö wasôm yom ŋandô. Asa naŋ sap mêtê sac dôŋ, naŋ ŋgac me awhê akiŋ mêtê sac-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ma ŋgac akiŋ ŋambwa oc wêkaiŋ ŋadau ndê gêŋ daŋ, me mbo iŋ ndê andu ŋapaŋ dom. Mba! Ŋadau ndê atu solop oc wêkaiŋ gêŋ ma mbo ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Magoc Anötö ndê Atu bu êŋgapwêc mac su, dec mac oc ambo atôm lau akiŋ ŋambwa tiyham dom andô. ");
INSERT INTO buk_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Aö kayalê su, bu Abraham ndê wakuc mac. Tigeŋ mac akôm bu andic aö ndu, ŋahu bu mac akôc aneŋ yom sa sip nem ŋalôm su dom. ");
INSERT INTO buk_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Aö gasôm yom asê pi gêŋ naŋ Damaŋ tôc asê têŋ aö, magoc mac akôm mêtê aŋkuc yom naŋ mac daôm damam sôm têŋ mac.” ");
INSERT INTO buk_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ma ŋac sêsôm tiyham, “Yac damaŋ iŋ Abraham.” Magoc Yisu sôm, “Mac bu Abraham atui mac, dec mac oc asa lêŋ gitêŋ gitôm iŋ dau ndê. ");
INSERT INTO buk_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Tigeŋ aö gasôm yom ŋandô gitôm aö gaŋgô yêc Anötö, ma mac akôm bu andic aö ndu. Abraham oc kôm gêŋ kaiŋ dinaŋ dom. ");
INSERT INTO buk_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mac aŋkuc Abraham ndê lêŋ dom, dec tôc asê bu mac nem damam iŋ ŋgac daŋ dau-ŋga daŋ.” Magoc ŋac sêsôm, “Yac lau ŋasawa-ŋga dom. Yac mba damaŋ tigeŋ iŋ Anötö dau.” ");
INSERT INTO buk_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Têŋ dinaŋ Yisu sôm, “Anötö bu ti mac nem damam, dec mac oc atac whiŋ aö. Ŋahu bu aö gameŋ akêŋ Anötö, dec gambo lec. Aö gameŋ tu dauŋ-ŋga dom, magoc Anötö dau kêkiŋ aö gameŋ. ");
INSERT INTO buk_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mac atôm dom bu aŋgô aneŋ yom, ma bocdinaŋ mac aŋyalê aneŋ yom ŋahu dom. ");
INSERT INTO buk_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mac nem damam iŋ Sadaŋ, ma mac akôm tôm iŋ atac whiŋ. Têŋ têm ŋamata-ŋga e meŋ, iŋ sa lêŋ ndic ŋamalac ndu-ŋga. Iŋ sap yom ŋandô dôŋ dom, bu yom ŋandô daŋ yêc iŋ ndê ŋalôm dom. Iŋ tasaŋ-nda, ma yom tasaŋ ŋadamba iŋ. Iŋ sôm yom kêkuc iŋ dau ndê awha solop, ma yom hoŋ naŋ iŋ sôm, naŋ yom tasaŋ. ");
INSERT INTO buk_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Tigeŋ aö dec gasôm yom ŋandô eŋ, ma tu dinaŋ-ŋga mac akêŋ whiŋ aneŋ yom dom. ");
INSERT INTO buk_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mac nem asa gitôm bu tôc aneŋ giso daŋ asê? Aö gasôm yom ŋandô, ma tu sake-ŋga mac akêŋ whiŋ aö dom? ");
INSERT INTO buk_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Anötö ndê atui ŋandô sêŋgô iŋ ndê yom ma daŋga wambu. Magoc mac aŋgô iŋ ndê yom dom, dec tôc asê bu mac ati iŋ ndê atui ŋandô dom.” ");
INSERT INTO buk_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Têŋ dinaŋ lau bata Israel-ŋga sêsôm, “Yac asôm solop bu am gitôm lau Samaria-ŋga naŋ si gauc sa pi Anötö dom, ma bu ŋalau sac daŋ mbo am nem ŋalôm.” ");
INSERT INTO buk_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Magoc Yisu sôm, “Mba! Ŋalau sac mbo aö neŋ ŋalôm dom. Mac atoc aneŋ waêŋ sa dom, magoc aö bu wapo Damaŋ ndê waê sa. ");
INSERT INTO buk_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Aö kasalê dauŋ neŋ waêŋ dom, magoc Anötö oc po aneŋ waêŋ sa. Ma iŋ oc êmatôc gêŋ hoŋ. ");
INSERT INTO buk_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Aö wasôm yom ŋandô têŋ mac, bu asa naŋ ŋgô aneŋ yom ma daŋga wambu, naŋ oc niŋga dom, magoc iŋ oc mbo tali ŋapaŋ.” ");
INSERT INTO buk_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Goc lau bata Israel-ŋga sêsôm têŋ iŋ, “Kwahic dec yac aŋyalê pi ŋandô bu ŋalau sac daŋ mbo am nem ŋalôm. Abraham ma lau propet sêmbac ndu, tigeŋ am sôm bu asa naŋ ŋgô am nem yom ma daŋga wambu, naŋ oc niŋga dom. ");
INSERT INTO buk_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Am asa dec toc daôm sa? Am gauc gêm bu am hôc gêlêc damaŋ Abraham su, a? Yac aŋyalê bu iŋ mbac ndu su, ma lau propet boc-dinaŋ.” ");
INSERT INTO buk_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ma Yisu ô yom ma sôm, “Aö dauŋ bu wapo dauŋ neŋ waêŋ sa, dec waêŋ dau ti gêŋ ŋambwa-ŋga. Magoc aö Damaŋ, naŋ mac asam bu mac nem Anötö, naŋ po aneŋ waêŋ sa. ");
INSERT INTO buk_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","M agoc mac aŋyalê iŋ dom. Aö dec kayalê iŋ, ma daŋaŋ wambu iŋ ndê yom. Aö bu wasôm bu kayalê iŋ dom, dec aö ŋgac tasaŋ gitôm mac lau tasaŋ. ");
INSERT INTO buk_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mac nem damam Abraham atac ŋayham sa kêlêc, bu iŋ kêŋ bata bu lic aneŋ bêc wahôc asê-ŋga. Ma iŋ gêlic su ma tisambuc.” ");
INSERT INTO buk_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Goc lau bata Israel-ŋga sêsôm têŋ iŋ, “Am nem yala tap 50 sa su dom. Ma bocke dec am sôm bu am gêlic Abraham su?” ");
INSERT INTO buk_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ma Yisu sôm, “Yomandô! Ndoc naŋ Abraham dinda kôc iŋ su dom, naŋ aö gambo.” ");
INSERT INTO buk_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Têŋ têm ŋac sêŋgô yom d inaŋ, goc sêkôc hoc sa bu sêtuc iŋ, magoc Yisu siŋ dau, ma kêdahiŋ dau su yêc lôm dabuŋ ŋagameŋ. ");
INSERT INTO buk_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yisu kêsêlêŋ gi, ma gêlic ŋgac tapec daŋ. Ŋgac dau iŋ tandô pec têŋ ndoc iŋ dinda kôc iŋ ma meŋ. ");
INSERT INTO buk_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ma Yisu ndê ŋgacsêŋomi sêndac iŋ bocdec bu, “Kêdôhôŋ-waga, ŋgac dinaŋ tapec tu iŋ dau ndê sac-ŋga, me tu dinda lu damba si sac-ŋga?” ");
INSERT INTO buk_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Goc Yisu sôm, “Iŋ tapec tu iŋ dau ndê sac-ŋga, me tu dinda lu damba si sac-ŋga dom. Magoc dinda kôc iŋ ti tapec tu bu kwahic dec lau sêlic Anötö ndê gweleŋ ti ŋaclai nem iŋ sa-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","5","Aö gambo nom gatôm lau nom-ŋga si ŋawê, ma kwahic dec ti têm ŋawê-ŋga. Ma bocdinaŋ kwahic dec yac oc dakôm Anötö naŋ kêkiŋ aö gameŋ, naŋ ndê gweleŋ. Têm ŋasec-ŋga oc meŋ hôc asê, ma têŋ dinaŋ lau daŋ oc sêtôm dom bu sêkôm gweleŋ.” ");
INSERT INTO buk_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Iŋ sôm yom dinaŋ su, goc hê gasôp sip nom, kêyaliŋ whiŋ nom, ma sê pi ŋgac tapec tandô. ");
INSERT INTO buk_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ma iŋ sôm têŋ iŋ, “Am ndi êmgwasiŋ aŋôm sip bu gapoŋ Siloam.” (Ŋaê Siloam dau danem kwi bu ‘Kêkiŋ.’ ) Goc iŋ kölhö gi kêgwasiŋ aŋgô, ma iŋ tandô ŋayham sa. Ma iŋ mbu têŋ ndê andu gi. ");
INSERT INTO buk_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ma iŋ ndê lau meŋpaŋ iŋ-ŋga, ti lau naŋ sêŋyalê bu muŋ-ŋga iŋ ŋgac teŋ gêŋ-ŋga, n aŋ sêsö ma sêndac dandi, “Iŋ ŋgac naŋ muŋ-ŋga ndöc ma teŋ gêŋ, a?” ");
INSERT INTO buk_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ma lau ŋatô sêsôm, “Iŋ ŋgac dau dinaŋ.” Magoc ŋatô sêsôm, “Mba! Iŋ ŋgac daŋ dau-ŋga, naŋ aŋgô gi tap ŋgac teŋ gêŋ-ŋga dinaŋ ndê aŋgô sa.” Magoc ŋgac dau sôm, “Aö ŋgac dauŋ dec.” ");
INSERT INTO buk_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Goc sêndac iŋ, “Ma bocke dec am nem tanôm ŋayham sa?” ");
INSERT INTO buk_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ma iŋ sôm, “Ŋgac naŋ sêsam iŋ bu Yisu, naŋ kêyaliŋ sacbalê, ma kêŋ pi aö tanôŋ, goc kêkiŋ aö bu waŋgwasiŋ aŋôŋ andô sip bu Siloam. Bocdinaŋ aö ga kagwasiŋ dauŋ, dec tanôŋ ŋayham sa.” ");
INSERT INTO buk_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ma sêndac, “Ŋgac dinaŋ mbo nde?” Goc iŋ sôm, “Aö kayalê dom.” ");
INSERT INTO buk_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Yisu kêyaliŋ sacbalê ma kôm ŋgac tapec dinaŋ tandô po asê têŋ bêc Sabat-ŋga daŋ. Ma tiŋambu l au sêwê ŋgac dau sêtêŋ lau Palêsai si. ");
INSERT INTO buk_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Têŋ ndoc lau Palêsai sêlic iŋ, naŋ sêndac iŋ bu, “Am tanôm po asê ŋalêŋ bocke?” Ma iŋ ô yom ma sôm, “Ŋgac dinaŋ kêŋ sacbalê pi aö tanôŋ, ma aö kagwasiŋ dec tanôŋ po asê.” ");
INSERT INTO buk_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Goc Palêsai ŋatô sêsôm yom pi Yisu bocdec bu, “Ŋgac dinaŋ kêgilì yomsu Sabat-ŋga, dec taŋyalê bu iŋ meŋ akêŋ Anötö dom.” Magoc Palêsai ŋatô sêsôm, “Ŋgac sac oc tôm dom bu kôm gêŋ dalô kaiŋ dinaŋ.” ");
INSERT INTO buk_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Boc-dinaŋ ŋac si yom so dau, ma sêndac ŋgac dau tiyham, “Am ŋgac daôm, am ŋgac naŋ iŋ kôm am nem tanôm po asê, ma bocdinaŋ am sôm sake pi iŋ?” Ma iŋ sôm, “Iŋ propet daŋ.” ");
INSERT INTO buk_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Magoc lau bata Israel-ŋga dinaŋ sêkêŋ whiŋ dom bu muŋ-ŋga iŋ tapec ma kwahic dec tandô ŋayham sa. Bocdinaŋ sêkêŋ yom têŋ iŋ dinda lu damba bu sêmeŋ. ");
INSERT INTO buk_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ma sêndac iŋlu, “Ŋgac dindec iŋ amlu atômŋgac naŋ amlu asôm bu dinda kôc iŋ ti tapec, a? Bocke ma kwahic dec iŋ tandô ŋayham sa?” ");
INSERT INTO buk_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ma iŋlu sêsôm, “Aêc! Alu aŋyalê bu iŋ alu mba balê, ma bu alu akôc iŋ ti tapec. ");
INSERT INTO buk_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Magoc iŋ tandô po asê ŋalêŋ bocke ma asa kôm iŋ tandô ŋayham sa, naŋ alu aŋyalê dom. Mac andac iŋ dau. Iŋ ti ŋgac atu su, ma gitôm bu sôm dau ndê yom.” ");
INSERT INTO buk_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Iŋlu sêŋyalê bu lau bata Israel-ŋga sêkic yom bu ŋac oc sêtiŋ lau naŋ sêkêŋ whiŋ bu Yisu iŋ Mesaya, naŋ su yêc gôlôwac Israel-ŋga, ma bocdinaŋ iŋlu sêtöc ŋac. ");
INSERT INTO buk_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tu dinaŋ-ŋga sêsôm yom bocdec, “Iŋ ti ŋgac atu su. Mac andac iŋ dau!” ");
INSERT INTO buk_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Goc ŋac sêmbwêc ŋgac dau tiyham, ma sêsôm, “Toc Anötö sa ma sôm yom ŋandô. Yac aŋyalê bu ŋgac dinaŋ iŋ ŋgac sac.” ");
INSERT INTO buk_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ma iŋ ô yom bocdec bu, “Iŋ bu ŋgac sac me iŋ ŋgac gitêŋ, aö kayalê dom. Gêŋ tigeŋ aö kayalê. Muŋ-ŋga aö ŋgac tapec, ma kwahic dec aö tanôŋ po asê.” ");
INSERT INTO buk_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Goc sêndac iŋ, “Iŋ kôm gêŋ sake têŋ am? Iŋ kôm am tanôm ŋayham sa ŋalêŋ bocke? Sôm asê têŋ yac.” ");
INSERT INTO buk_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ma iŋ sôm, “Aö gasôm têŋ mac su, magoc mac akôc aneŋ yom sa dom. Tu sake-ŋga mac bu aŋgô tiyham? Mboe mac atac whiŋ bu ati iŋ ndê sêŋomi awhiŋ, a?” ");
INSERT INTO buk_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Têŋ dinaŋ sêpu iŋ ma sêsôm, “Mba! Am daôm ti ŋgac dinaŋ ndê ŋgacsêŋom! Moses ndê sêŋomi yac. ");
INSERT INTO buk_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Yac aŋyalê bu Anötö kêŋ iŋ ndê yom têŋ Moses, magoc ŋgac dinaŋ ti iŋ ndê ŋahu, yac aŋyalê dom.” ");
INSERT INTO buk_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Goc ŋgac dau sôm, “Gêŋ kaiŋ daŋ solop! Mac asôm bu mac aŋyalê iŋ ndê ŋahu dom. Tigeŋ alic su naŋ! Iŋ kôm aö tanôŋ po asê. ");
INSERT INTO buk_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Yac taŋyalê bu Anötö oc kêŋ daŋga têŋ lau sac dom. Mba! Iŋ kêŋ daŋga lau gitêŋ naŋ sêŋkuc iŋ ndê yom. ");
INSERT INTO buk_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Yac daŋgô daŋ muŋ su dom, bu ŋamalac daŋ kôm ŋgac naŋ dinda kôc iŋ ti tapec, naŋ tandô po asê. Mba sambuc! ");
INSERT INTO buk_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ŋgac dinaŋ bu meŋ akêŋ Anötö dom, dec oc tôm dom bu iŋ kôm gêŋ daŋ.” ");
INSERT INTO buk_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ŋac sêŋgô iŋ ndê yom dinaŋ, dec gêli ŋac si ŋalôm sa ŋandô. Ma sêsôm, “Am bu êmdôhôŋ yac, a? Sac gêm am ahuc têŋ ndoc dinam kôc am!” Goc sêtiŋ iŋ sa awê gi. ");
INSERT INTO buk_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Têŋ ndoc Yisu ŋgô ŋawaê bu lau Palêsai sêtiŋ ŋgac dau su, naŋ iŋ kêsalê iŋ e tap iŋ sa, ma ndac iŋ, “Am kêŋ whiŋ Ŋamalac ndê Atu, me mba?” ");
INSERT INTO buk_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ma iŋ ô yom ma sôm, “O ŋadau! Ŋamalac ndê Atu iŋ asa? Sôm têŋ aö, goc aö wakêŋ whiŋ iŋ.” ");
INSERT INTO buk_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Goc Yisu sôm, “Am gêlic iŋ su. Aö ŋgac dauŋ dec, naŋ gasôm yom têŋ am.” ");
INSERT INTO buk_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ma iŋ sôm, “Pômdau, aö gakêŋ whiŋ am.” Goc iŋ pôŋ haduc têŋ Yisu. ");
INSERT INTO buk_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ma Yisu sôm, “Aö gasip nom gameŋ ma lau oc sêtap matôc sa tu aö-ŋga. Lau tapec oc sêti lau tandô ŋayham, ma lau naŋ gauc gêm bu ŋac lau tandô ŋayham, naŋ oc sêtôm lau tapec.” ");
INSERT INTO buk_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Lau Palêsai ŋatô sêmbo sêwhiŋ, ma sêŋgô Yisu ndê yom dinaŋ ma sêndac, “Bocke? Am sôm bu yac taŋpec awhiŋ, a?” ");
INSERT INTO buk_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ma iŋ sôm, “Mac bu lau tampec, dec mac nem giso mba. Mac asôm bu mac lau tanôm ŋayham, magoc mac akêŋ whiŋ aö dom. Tu dinaŋ-ŋga dec mac nem giso gacgeŋ yêc mac-ŋga.” ");
INSERT INTO buk_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ma Yisu sôm, “Yom ŋandô aö wasôm têŋ mac, bu ŋgac naŋ sôc domba si tuŋlôm yêc gatam dom, magoc kêgilì tuŋ bambaliŋ bu sôc ndi, naŋ ŋgac kaŋ-nda. ");
INSERT INTO buk_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Magoc ŋgac naŋ sôc domba si tuŋlôm yêc gatam solop, naŋ ŋgac yob domba-ŋga ŋandô. ");
INSERT INTO buk_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ŋgac naŋ yob gatam oc lêc gatam su têŋ iŋ, ma domba sêŋyalê iŋ awha. Iŋ oc ta domba tigeŋ-tigeŋ si ŋaê, ma wê ŋac sêsa sêndi. ");
INSERT INTO buk_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Têŋ ndoc iŋ kôc iŋ ndê domba hoŋ sêsa si, naŋ iŋ kêsêlêŋ muŋ ma ŋac sêŋkuc iŋ, bu ŋac sêŋyalê iŋ awha. ");
INSERT INTO buk_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tigeŋ ŋac oc sêŋkuc ŋgac apa daŋ dom. Mba! Ŋac oc sêlhö bambaliŋ yêc iŋ, bu sêŋyalê iŋ awha dom!” ");
INSERT INTO buk_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yisu sôm yom gôliŋ dinaŋ, magoc ŋac sêŋyalê iŋ ndê yom ŋahu dom. ");
INSERT INTO buk_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Bocdinaŋ Yisu sôm tiyham, “Yom ŋandô aö wasôm têŋ mac! Aö gatôm gatam tu domba sêsôc si tuŋlôm sêndi-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kêdôhôŋwaga tasaŋ hoŋ naŋ sêhôc asê sêmuŋ aö, naŋ lau kaŋ. Magoc domba sêkêŋ daŋga ŋac dom. ");
INSERT INTO buk_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Aö gatam, ma domba naŋ sêsôc yêc aö, naŋ oc sêtap Anötö ndê mwasiŋ nem ŋac si-ŋga sa. Ŋac oc sêsôc sêsa, ma sêtap gêŋ sêneŋ-ŋga ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ŋgac kaŋ meŋ bu nem kaŋ ti ndic ndu ma seŋ popoc. Iŋ ndê gweleŋ dau dinaŋ. Tigeŋ aö gameŋ bu wamasaŋ lêŋ bu lau sêtap Anötö ndê mwasiŋ sêndöc tali-ŋga sa, ma mwasiŋ dau oc êŋsalê ŋac ahuc.” ");
INSERT INTO buk_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Aö ŋgac wayob domba-ŋga ŋayham. Ŋgac yob domba-ŋga ŋayham oc kêŋ dau sambuc e nditôm iŋ mbac ndu bu nem iŋ ndê domba sa. ");
INSERT INTO buk_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Magoc ŋgac naŋ yob domba tu tap ŋaôli sa-ŋga, naŋ gitôm ŋgac naŋ yob dau ndê domba, naŋ dom. Iŋ bu lic giam sac daŋ meŋ, dec iŋ oc hu domba siŋ ma lhö ndi. Goc giam sac oc seŋ domba ma sêlhö bambaliŋ. ");
INSERT INTO buk_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ŋgac dinaŋ oc lhö ndi, bu iŋ gêm gweleŋ tu awa-ŋga ŋambwa, ma hêgo dau tu domba-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Aö ŋgac wayob domba-ŋga ŋayham. Gitôm Damaŋ kêyalê aö, ma aö kayalê Damaŋ, bocdinaŋ aö kayalê aneŋ domba, ma aneŋ domba sêŋyalê aö. Ma wakêŋ dauŋ sambuc e nditôm wambac ndu bu wanem ŋac sa. ");
INSERT INTO buk_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ma aneŋ domba ŋatô sêmbo, naŋ sêmbo sêwhiŋ domba toŋ dindec dom. Aö wandic ŋac sa sêmeŋ sêmbo sêwhiŋ domba dindec, ma ŋac oc sêti toŋ tigeŋ. Ŋac si ŋadau tigeŋ aö dec wayob ŋac, ma ŋac hoŋ oc sêkêŋ daŋga aö awhaŋ. ");
INSERT INTO buk_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Damaŋ tac whiŋ aö, bu aö wakêŋ dauŋ gacgeŋ wambac ndu, ma tiŋambu aö watisa tiyham. ");
INSERT INTO buk_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ŋamalac daŋ oc kôc taŋli ŋahu su yêc aö dom. Aö dauŋ oc wahu taŋli ŋahu siŋ tôm aö dauŋ atac whiŋ. Anötö kêŋ ŋaclai têŋ aö bu aö dauŋ wahu siŋ, ma bu aö dauŋ wakôc sa tiyham. Damaŋ gic atu yom dau dinaŋ.” ");
INSERT INTO buk_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Lau bata Israel-ŋga sêŋgô yom dinaŋ ma sêwhê dau kôc ti sêseŋ dandi tiyham. ");
INSERT INTO buk_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Lau daêsam sêsôm, “Ŋalau sac daŋ mbo iŋ ndê ŋalôm ma kôm iŋ ndê gauc timboloc. Aŋgô iŋ ndê yom dom!” ");
INSERT INTO buk_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Magoc lau ŋatô sêsôm, “Ŋgac ti ŋalau sac oc sôm yom kaiŋ dinaŋ dom. Ma ŋalau sac oc kôm ŋgac tapec tandô po asê dom!” ");
INSERT INTO buk_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Têŋ ndoc uhô-ŋga, lau Israel-ŋga si †Mwasiŋ Sic Gawi Lôm-ŋga hôc asê Jerusalem. ");
INSERT INTO buk_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yisu kêsêlêŋ mbo lôm dabuŋ ŋabatêmndö, mbo gameŋ naŋ sêsam bu Solomon ndê Batêm. ");
INSERT INTO buk_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ma lau bata Israel-ŋga sêkac sa sêŋgihi iŋ ahuc, ma sêsôm, “Ŋasawa baliŋ lec yac atac lu-lu tu am-ŋga. Bocdinaŋ dec sôm yom yêc awê têŋ yac. Am Mesaya dau, me mba?” ");
INSERT INTO buk_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ma Yisu sôm, “Aö gasôm têŋ mac su, magoc mac akêŋ whiŋ aö dom. Ma aö gakôm gêŋ dalô gam Damaŋ aŋgô. Gêŋ dau puŋ yom ŋandô pi aö dôŋ, ma whê aneŋ ŋahu sa tiawê. ");
INSERT INTO buk_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Magoc mac akêŋ whiŋ aö dom, ŋahu bu mac ati aö neŋ domba dom. ");
INSERT INTO buk_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Aneŋ domba sêkêŋ daŋga aö awhaŋ. Aö kayalê ŋac, ma ŋac sêŋkuc aö. ");
INSERT INTO buk_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Aö oc wakêŋ ŋac sêndöc tali ŋapaŋ ma oc tôm dom bu ŋac sêniŋga têŋ têm ŋambu-ŋga dom. Ma lau daŋ sêtôm dom bu sêŋgaho ŋac su yêc aö amaŋ. ");
INSERT INTO buk_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Damaŋ kêŋ aneŋ domba têŋ aö, ma gêŋ daŋ hôc gêlêc iŋ su dom. Bocdinaŋ lau daŋ sêtôm dom bu sêŋgaho ŋac su yêc Damaŋ amba. ");
INSERT INTO buk_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Alu Damaŋ ati gêŋ tigeŋ.” ");
INSERT INTO buk_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Têŋ dinaŋ lau bata sêkôc hoc sa tiyham bu sêtuc iŋ. ");
INSERT INTO buk_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Magoc iŋ sôm têŋ ŋac, “Mac bu atuc aö ŋa hoc tu gêŋ dalô bocke-ŋga? Bu aö gatôc gêŋ ŋayham daêsam têŋ mac, tôm naŋ Damaŋ kêŋ têŋ aö.” ");
INSERT INTO buk_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ma ŋac sêô yom ma sêsôm, “Yac bu atuc am tu gêŋ daŋ naŋ am kôm-ŋga dom. Mba! Am ŋamalac daŋ, magoc toc daôm sa bu nditôm Anötö dau. Am nem yom dinaŋ sac sambuc, ma tu dinaŋ-ŋga yac bu atuc am ŋa hoc.” ");
INSERT INTO buk_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Goc Yisu ô yom ma sôm, “Mac aŋyalê yom naŋ Anötö dau sôm pi lau bata Israel-ŋga ŋatô, naŋ sêto yêc mac nem Buku Yomsu-ŋga bocdec bu, ‘Aö gasam mac bu anötöi.’ ");
INSERT INTO buk_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Aŋgô su naŋ! Anötö kêŋ iŋ ndê yom têŋ lau nom-ŋga dinaŋ, ma sam ŋac bu anötöi. Ma gitôm dom bu daseŋ Anötö ndê yom daŋ su. ");
INSERT INTO buk_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ma aö bocke? Damaŋ dau kêyaliŋ aö sa ma kêkiŋ aö gasip nom gameŋ. Bocdinaŋ tu sake-ŋga mac asôm bu aneŋ yom sac sambuc, têŋ ndoc aö gasôm bu aö Anötö ndê Atu? ");
INSERT INTO buk_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Aö bu wakôm Damaŋ ndê gweleŋ naŋ kêŋ sip aö amaŋ, naŋ dom, naŋ akêŋ whiŋ aö dom. ");
INSERT INTO buk_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Tigeŋ aö gakôm Damaŋ ndê gweleŋ, ma bocdinaŋ dec mac bu akêŋ whiŋ aneŋ yom dom, tigeŋ akêŋ whiŋ tu gêŋ naŋ aö gakôm-ŋga. Ma bocdinaŋ mac oc aŋyalê pi ŋandô bu Damaŋ mbo aö ŋalôm, ma aö gambo iŋ ŋalôm.” ");
INSERT INTO buk_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Têŋ dinaŋ sêŋsahê tiyham bu sêkôc iŋ dôŋ, magoc ŋac gitôm dom, ma iŋ kölhö gi. ");
INSERT INTO buk_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ma iŋ pi Bu Jordan ŋadaŋga gi, ma mbo gameŋ naŋ muŋ-ŋga Jon kêku lau mbo. ");
INSERT INTO buk_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Lau daêsam sêsa sêtêŋ iŋ si, ma sêsôm têŋ dau, “Jon kôm gêŋ dalô daŋ dom. Magoc yom hoŋ naŋ iŋ sôm pi ŋgac dindec, naŋ yom ŋandô.” ");
INSERT INTO buk_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ma lau daêsam sêkêŋ whiŋ Yisu yêc gameŋ dinaŋ. ");
INSERT INTO buk_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Ŋgac daŋ ŋaê Lasarus mbo malac Betani. Ma iŋ ndê lhuwê lu sêmbo, daŋ ndê ŋaê Mata, ma daŋ ŋaê Maria, awhê naŋ tiŋambu tac bu ŋamalu ŋayham pi Pômdau gahi, ma puŋ ŋa iŋ kêclauŋ. Têŋ bêc daŋ Lasarus gêmbac. ");
INSERT INTO buk_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Goc Maria lu Mata sêkêŋ yom têŋ Yisu bocdec bu, “Pômdau, ŋgac naŋ am atac whiŋ dec gêmbac.” ");
INSERT INTO buk_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yisu ŋgô yom dau ma sôm, “Iŋ gêmbac tu bu mbac ndu ŋambwa-ŋga dom. Iŋ gêmbac bu tôc Anötö ndê ŋaclai ti waê asê, ma bu Anötö ndê Atu tap waê sa whiŋ.” ");
INSERT INTO buk_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yisu tac whiŋ Maria lu Mata ma Lasarus. ");
INSERT INTO buk_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Tigeŋ têŋ ndoc iŋ ŋgô ŋawaê bu Lasarus gêmbac, naŋ iŋ têŋ iŋ gi ŋagahô dom. Iŋ gacgeŋ mbo gameŋ dinaŋ gitôm bêc lu. ");
INSERT INTO buk_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Goc iŋ sôm têŋ iŋ ndê ŋgacsêŋomi, “Dalhö dambu datêŋ gameŋ Judia-ŋga dandi.” ");
INSERT INTO buk_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Magoc ŋac sêsôm, “Kêdôhôŋwaga, mba! Ŋasawa apê lec lau bata Israel-ŋga naŋ sêmbo dindê, naŋ tac whiŋ bu sêtuc am ŋa hoc. Bocke dec am bu mbu ndi tiyham?” ");
INSERT INTO buk_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ma Yisu ô yom ŋa yom gôliŋ daŋ, ma sôm, “Têŋ bêc hoŋ ac pô gameŋ gitôm acgatu ŋasawa 12, ma tiŋambu ŋasec sa. Ŋamalac daŋ bu êŋsêlêŋ têŋ ndoc ac-ŋga, dec iŋ oc tiŋ gahi dom, bu iŋ gêlic ŋawê nom dindec-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Magoc iŋ bu êŋsêlêŋ têŋ ôbwêc, dec iŋ oc tiŋ gahi, bu iŋ ndê ŋawê mba.” ");
INSERT INTO buk_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Goc Yisu gic têku yom ma sôm, “Yac neŋ silip Lasarus yêc bêc. Aö watêŋ iŋ wandi bu wauŋ iŋ sa.” ");
INSERT INTO buk_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ma ŋgacsêŋomi sêsôm, “Pômdau, iŋ bu yêc bêc yêc, dec iŋ dau oc ŋayham sa.” ");
INSERT INTO buk_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ŋac gauc gêm bu Yisu sôm bu Lasarus mbo tali ma yêc bêc, magoc iŋ ndê yom dau ŋahu bu Lasarus mbac ndu su. ");
INSERT INTO buk_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Goc Yisu sôm yom yêc awê têŋ ŋac bu, “Lasarus mbac ndu. ");
INSERT INTO buk_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Tu mac-ŋga dec aö atac ŋayham bu aö gambo g awhiŋ iŋ dom, bu kwahic dec mac oc akêŋ whiŋ tu gêŋ naŋ aö bu wakôm-ŋga. Bocdinaŋ yac datêŋ iŋ dandi.” ");
INSERT INTO buk_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ma Tomas, ŋgacsêŋom naŋ sêsam bu Lôcmpôŋ, naŋ sôm têŋ ŋgacsêŋomi ŋatô, “Ayôc! Dawhiŋ iŋ dandi, ma dambac ndu dawhiŋ iŋ.” ");
INSERT INTO buk_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yisu hôc asê gameŋ Judia-ŋga ma tap sa bu sêkêŋ Lasarus ndê ŋamlaŋ yêc hocsuŋ daŋ gitôm bêc hale su. ");
INSERT INTO buk_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Malac Betani yêc suŋ sa têŋ Jerusalem, seŋ ŋasawa gitôm kilometa tö. ");
INSERT INTO buk_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ma lau Israel-ŋga daêsam sêsa akêŋ Jerusalem sêmeŋ, ma sêndöc sêwhiŋ Mata lu Maria, bu sênem malô iŋlu tu lhuŋgac hu iŋlu siŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mata ŋgô bu Yisu kêsêlêŋ meŋ, goc sa gi bu lic iŋ, magoc Maria ndöc andu. ");
INSERT INTO buk_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Têŋ ndoc Mata hôc asê Yisu, naŋ iŋ sôm têŋ iŋ, “O Pômdau, am bu mbo, dec aö lhuŋgac oc mbac ndu dom. ");
INSERT INTO buk_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Magoc kwahic dec am mweŋ hôc asê su, ma aö kayalê bu gêŋ bocke naŋ am bu ndac têŋ Anötö, naŋ iŋ oc kôm.” ");
INSERT INTO buk_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ma Yisu sôm, “Am lhômŋgac oc tisa ma mbo tali tiyham.” ");
INSERT INTO buk_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Dec Mata ô yom ma sôm, “Aêc! Aö kayalê bu iŋ oc tisa têŋ bêc ŋambu-ŋga naŋ lau batê hoŋ oc sêtisa.” ");
INSERT INTO buk_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Goc Yisu sôm, “Ŋamalac si sêtisa ma sêmbo tali ŋahu, naŋ aö dauŋ. Asa naŋ kêŋ whiŋ aö ma mbac ndu su, naŋ oc mbo tali tiyham. ");
INSERT INTO buk_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ma asa naŋ mbo tali ma kêŋ whiŋ aö, naŋ oc niŋga têŋ têm ŋambu-ŋga dom, iŋ oc gacgeŋ mbo tali. Am kêŋ whiŋ yom dindec, me mba?” ");
INSERT INTO buk_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ma Mata sôm, “Aêc Pômdau! Aö gakêŋ whiŋ bu am Mesaya, ma Anötö ndê Atu naŋ iŋ gic bata bu êŋkiŋ sip nom meŋ.” ");
INSERT INTO buk_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata sôm yom dinaŋ su, goc mbu gi ma ta Maria têŋ iŋ meŋ. Ma iŋ sôm têŋ iŋ, “Kêdôhôŋwaga meŋ su, ma iŋ ndac am.” ");
INSERT INTO buk_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria ŋgô su, goc tisa ŋagahô bu sa têŋ Yisu ndi. ");
INSERT INTO buk_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Têŋ ndoc dinaŋ Yisu hôc asê Betani su dom, iŋ gacgeŋ mbo gameŋ naŋ Mata hôc pi iŋ. ");
INSERT INTO buk_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Lau Israel-ŋga naŋ sêmbo andu sêwhiŋ Maria tu bu sênem malô iŋ, naŋ sêlic iŋ tisa ŋagahô ma kölhö gi. Ŋac gauc gêm bu iŋ oc têŋ sêhô ndi bu taŋ lhuŋgac mbo dindê, ma bocdinaŋ sêsa si ma sêŋkuc iŋ. ");
INSERT INTO buk_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Têŋ ndoc Maria hôc asê gameŋ naŋ Yisu mbo ma gêlic iŋ, naŋ iŋ hu dau sip nom yêc iŋ gahi-ŋga, ma sôm, “O Pômdau, am bu mbo, dec aö lhuŋgac oc mbac ndu dom.” ");
INSERT INTO buk_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yisu gêlic Maria taŋ, ma gêlic lau Israel-ŋga naŋ sêwhiŋ iŋ, naŋ sêtaŋ bocdinaŋ, dec kêsahê ŋawapac atu yêc ndê ŋalôm. ");
INSERT INTO buk_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ma iŋ ndac, “Mac aŋsuhuŋ iŋ yêc nde?” Ma sêsôm, “Mweŋ Pômdau, ma lic.” ");
INSERT INTO buk_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Têŋ dinaŋ Yisu tasulu sa. ");
INSERT INTO buk_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ma lau Israel-ŋga dinaŋ sêsôm, “Alic, iŋ atac whiŋ Lasarus ndu andô.” ");
INSERT INTO buk_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Magoc ŋatô sêsôm, “Iŋ kôm ŋgac tapec tandô po asê. Bocke dec iŋ kôm Lasarus ŋayham sa dom, ma iŋ mbac ndu?” ");
INSERT INTO buk_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Têŋ dinaŋ Yisu ndê ŋalôm ŋawapac atu tiyham, ma iŋ kêsêlêŋ têŋ sêhô gi. Ŋac sêkêŋ ŋgac batê dau ndê ŋamlaŋ yêc hocsuŋ daŋ, ma sêmpi hoc daŋ gi ndöc sê awha ahuc. ");
INSERT INTO buk_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Têŋ ndoc Yisu hôc asê, naŋ iŋ sôm têŋ lau naŋ sêwhiŋ iŋ bu, “Mac ampi hoc dau sa.” Magoc ŋgac batê ndê lhuwê Mata sôm, “Pômdau! Iŋ yêc gitôm bêc hale su. Oc ŋamaniŋ sa su.” ");
INSERT INTO buk_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Dec Yisu sôm, “Aö gasôm têŋ am su, bu kêŋ whiŋ, dec am oc lic Anötö ndê ŋaclai ti ŋawasi.” ");
INSERT INTO buk_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Iŋ sôm yom dinaŋ su, goc lau sêmpi hoc dau sa. Ma Yisu tatac undambê ma sôm, “Damaŋ, aö wanem daŋge am, bu am ŋgô aneŋ yom. ");
INSERT INTO buk_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Aö kayalê bu am kêŋ daŋam aö ŋapaŋ, magoc kwahic dec aö bu wanem daŋge am, bu lau naŋ sêlhac dec oc sêŋgô aneŋ yom, ma sêkêŋ whiŋ bu am kêkiŋ aö gameŋ.” ");
INSERT INTO buk_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Goc iŋ mbwêc awha atu, “Lasarus! Sa mweŋ!” ");
INSERT INTO buk_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Dec Lasarus sa meŋ, ma po naŋ sêmpaŋ iŋ gahi ti amba, ma po daŋ naŋ sêhi pi iŋ ŋagôlôŋ, naŋ gacgeŋ sêyêc iŋ. Ma Yisu sôm têŋ ŋac, “Akôc po su yêc iŋ, ma akêŋ iŋ lhö ndi.” ");
INSERT INTO buk_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tu gêŋ atu dinaŋ-ŋga dec lau Israel-ŋga daêsam naŋ sêmbo sêwhiŋ Maria ma sêlic gêŋ naŋ Yisu kôm, naŋ sêkêŋ whiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Magoc ŋatô sêtêŋ lau Palêsai si, ma sic miŋ pi gêŋ naŋ Yisu kôm. ");
INSERT INTO buk_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Goc dabuŋsiga atu-tu ti lau Palêsai sêmbwêc lau †Sanedrin-ŋga sêpitigeŋ, ma sêndac ŋac, “Yac oc dakôm gêŋ sake? Ŋgac dinaŋ kôm gêŋ dalô daêsam. ");
INSERT INTO buk_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Yac bu dalhac iŋ ahuc dom, dec lau hoŋ oc sêkêŋ whiŋ bu iŋ Mesaya dau. Ma lau Rom-ŋga oc sêmeŋ ma sêseŋ yac neŋ gameŋ danem akiŋ Anötö-ŋga ti yac lau Israel-ŋga hoŋ su.” ");
INSERT INTO buk_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Têŋ yala dinaŋ Kayapas iŋ †dabuŋsiga ŋamata-ŋga. Ma iŋ sôm têŋ lau Sanedrin-ŋga, “Mac nem gauc sa dom! ");
INSERT INTO buk_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Iŋ mbac ndu maŋ! Yham dom bu lau Israel-ŋga hoŋ sêniŋga. Ŋgac tigeŋ bu mbac ndu ô lau hoŋ, naŋ oc ŋayham hôc gêlêc su.” ");
INSERT INTO buk_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayapas sôm yom dinaŋ ŋa iŋ dau ndê gauc dom. Magoc têŋ yala dinaŋ iŋ dabuŋsiga ŋamata-ŋga, dec iŋ sôm yom dau gitôm propet daŋ. Ma yom dau ŋahu bocdec bu. Yisu oc mbac ndu tu lau Israel-ŋga hoŋ. ");
INSERT INTO buk_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ma tu ŋac tawasê-ŋga dom. Iŋ oc mbac ndu tu Anötö ndê lau hoŋ naŋ sêmbo gameŋ nom-ŋga tidau-tidau, tu bu ndic ŋac hoŋ sa sêpitigeŋ. ");
INSERT INTO buk_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Bocdinaŋ têŋ bêc dinaŋ lau bata Israel-ŋga dinaŋ sic hu sêŋsalê lêŋ bu sêndic Yisu ndu. ");
INSERT INTO buk_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ma tu dinaŋ-ŋga Yisu kêsêlêŋ mbo awê yêc lau Israel-ŋga ŋalôm dom. Iŋ kölhö gi mbo malac Eprayim, naŋ yêc gameŋ sawa ŋamakê. Ma iŋ ndê ŋgacsêŋomi sêmbo gameŋ dinaŋ sêwhiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Têŋ ndoc lau Israel si om atu Mwasiŋ Pasowa-ŋga meŋ kêpiŋ, n aŋ lau daêsam yêc gameŋ ŋamakê-ŋga sêpi Jerusalem si. Ŋac bu sêŋkuc lau Israel si lêŋ sêmasaŋ dau ŋawasi sa yêc Anötö aŋgô-ŋga muŋ su naŋ goc Pasowa ŋabêc hôc asê. ");
INSERT INTO buk_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ma ŋac sêŋsalê Yisu ŋapaŋ. Têŋ ndoc sêkac sa sêmbo lôm dabuŋ, naŋ sêndac dandi, “Mac gauc gêm bocke? Iŋ oc meŋ tu Mwasiŋ Pasowa-ŋga, me mba?” ");
INSERT INTO buk_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tigeŋ dabuŋsiga atu-tu ti lau Palêsai sic atu lau bu asa bu tap gameŋ naŋ Yisu mbo, naŋ sa, naŋ kêŋ ŋawaê têŋ ŋac, ma ŋac oc sêkôc iŋ dôŋ. ");
INSERT INTO buk_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Bêc 6 yêc dôŋ yêc bu Mwasiŋ Pasowa-ŋga hôc asê, ma Yisu têŋ malac Betani gi. Lasarus, ŋgac naŋ iŋ uŋ sa akêŋ lau batê-ŋga, naŋ mbo malac dinaŋ. ");
INSERT INTO buk_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ma yêc Lasarus ndê andu, ŋac sêndê mwasiŋ tu Yisu-ŋga. Lasarus ti lau ŋatô seŋ gêŋ sêndöc sêwhiŋ iŋ, ma Mata gêm akiŋ ŋac mbo. ");
INSERT INTO buk_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Goc Maria meŋ, kôc a ŋakwi ŋamalu ŋayham naŋ ŋaôli atu sip kac daŋ, ma kêc pi Yisu gahi. Goc iŋ puŋ iŋ gahi ŋa iŋ dau kêclauŋ. Ma gêŋ dau ŋamalu hôŋ dau sa ma gêm andu ŋalôm ahuc. ");
INSERT INTO buk_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Têŋ dinaŋ Judas Iskeriot, ŋgacsêŋom naŋ tiŋambu hoc Yisu asê, naŋ sôm, ");
INSERT INTO buk_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Bu ŋamalu ŋayham dindec ŋaôli atu, gitôm denarii 300 naŋ dakôc ti ŋaôli tu gweleŋ yala sambuc-ŋga. Tu sake-ŋga awhê dec kêyaiŋ? Gitôm bu dakêŋ têŋ lau sênemlhi, ma dakêŋ ŋa-awa tu danem lau ŋalôm sawa sa-ŋga.” ");
INSERT INTO buk_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas sôm yom dinaŋ, magoc iŋ gauc gêm lau ŋalôm sawa dom. Iŋ sôm yom dinaŋ ŋahu bu iŋ ŋgac kaŋ-nda. Iŋ yob ŋgac-sêŋomi si talhi mone-ŋga, ma gêm kaŋ mone ŋatô bu nem dau sa. ");
INSERT INTO buk_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Magoc Yisu ô iŋ ndê yom ma sôm, “Mac alhac awhê dindec ahuc dom. Iŋ yob gêŋ dau ŋapaŋ e kwahic dec, gic waê bêc sêŋsuhuŋ aö-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Lau ŋalôm sawa oc sêmbo sêwhiŋ mac ŋapaŋ. Tigeŋ aö oc wambo wawhiŋ mac ŋapaŋ dom.” ");
INSERT INTO buk_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Têŋ ndoc dinaŋ lau Jerusalem-ŋga daêsam sêŋgô ŋawaê bu Yisu mbo malac Betani, dec sêsa si bu sêlic iŋ. Ma ŋac bu sêlic Lasarus, ŋgac naŋ Yisu uŋ sa yêc lau batê-ŋga, naŋ whiŋ. ");
INSERT INTO buk_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tu dinaŋ-ŋga dabuŋsiga atu-tu Israel-ŋga sêkic yom bu sêndic Lasarus ndu whiŋ. ");
INSERT INTO buk_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ŋahu bu lau Israel-ŋga daêsam sêhu ŋac siŋ ma sêkêŋ whiŋ Yisu tu Lasarus-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Têŋ ŋagalaŋsê lau daêsam naŋ sêmbo Jerusalem tu Mwasiŋ Pasowa-ŋga sêŋgô ŋawaê bu Yisu kêsêlêŋ mbo seŋ bu têŋ Jerusalem meŋ. ");
INSERT INTO buk_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Bocdinaŋ ŋac sêsa si bu sêkôc iŋ sa. Sêhôc tômtôm ŋalauŋ ma sêmbwêc, “Hosana! Tampiŋ iŋ naŋ meŋ gêm Pômdau aŋgô. Tampiŋ lau Israel-ŋga si Kiŋ.” ");
INSERT INTO buk_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yisu kêsêlêŋ meŋ ndöc doŋki ŋatu daŋ ŋahô, ma ŋalêŋ dinaŋ propet akwa daŋ ndê yom ŋandô sa. Yom dau yêc bocdec bu: ");
INSERT INTO buk_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","O mac lau †Sayon-ŋga, atöc daôm dom. Alic mac nem Kiŋ têŋ mac meŋ, ndöc doŋki ŋatu ŋahô. ");
INSERT INTO buk_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yisu ndê ŋgacsêŋomi sêlic gêŋ hoŋ dinaŋ, magoc ŋac sêŋyalê ŋahu dom. Tigeŋ tiŋambu, têŋ ndoc Yisu tisa ti ŋawasi atu, naŋ sêŋyalê bu yom dau, naŋ sêto muŋ su, naŋ hêganôŋ Yisu, ma tu dinaŋ-ŋga lau sêkôm gêŋ dinaŋ têŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","L au daêsam naŋ sêmbo sêwhiŋ Yisu têŋ ndoc iŋ mbwêc Lasarus ma uŋ iŋ sa akêŋ lau batê-ŋga, naŋ sic miŋ pi iŋ ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Bocdinaŋ lau daêsam sêŋgô ŋawaê bu Yisu kôm gêŋ dalô atu dinaŋ, ma sêsa si bu sêlic iŋ têŋ bêc dinaŋ. ");
INSERT INTO buk_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ma têŋ têm lau Palêsai sêlic gêŋ dau, naŋ sêsôm têŋ dandi, “Alic, yac neŋ yom hoŋ ŋandô mbasi. Yac oc dalhac iŋ ahuc ŋalêŋ bocke? Lau hoŋ oc sêŋkuc iŋ!” ");
INSERT INTO buk_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Lau Grik ŋatô sêmbo sêwhiŋ lau naŋ sêpi malac Jerusalem tu sênem akiŋ Anötö-ŋga têŋ om atu Pasowa-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Lau Grik dinaŋ sêtêŋ Pilip, ŋgacsêŋom naŋ meŋ akêŋ malac Betsaida yêc gameŋ Galili-ŋga, ma sêsôm têŋ iŋ bu, “O ŋgac atu, yac bu alic Yisu.” ");
INSERT INTO buk_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Dec Pilip gi sôm yom dau têŋ Andru, ma iŋlu si sêsôm têŋ Yisu. ");
INSERT INTO buk_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yisu ŋgô yom dau goc sôm yom gôliŋ daŋ bocdec bu, “Ndoc meŋ sa bu Ŋamalac ndê Atu tap iŋ ndê waê atu sa. ");
INSERT INTO buk_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Aö wasôm yomandô têŋ mac. Gêŋ ŋawhê daŋ bu sêsô sip nom ndi dom, dec gêŋ tigeŋ dau oc gacgeŋ yêc. Magoc gêŋ dau bu dasô sip nom ŋalôm ndi, dec oc tibalê ma niŋga, magoc tiŋambu oc po pi meŋ ma nem ŋandô daêsam tiyham. ");
INSERT INTO buk_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Asa naŋ tac whiŋ bu sap gêŋ nom-ŋga dôŋ ŋapaŋ tu mbo tali-ŋga, naŋ oc niŋga. Magoc asa naŋ bu hu gêŋ nom dindec-ŋga siŋ tu êŋkuc aö-ŋga, naŋ tap seŋ ndöc tali têŋ têm ŋambu-ŋga-ŋga sa. ");
INSERT INTO buk_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Asa naŋ gauc gêm bu nem akiŋ aö, naŋ meŋ êŋkuc aö. Ma gameŋ naŋ aö oc wambo, naŋ iŋ naŋ gêm akiŋ aö, naŋ oc mbo bocdinaŋ. Lau hoŋ naŋ sem akiŋ aö, naŋ Damaŋ oc toc ŋac sa. ");
INSERT INTO buk_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Kwahic dec aö neŋ ŋalôm kedehe aö ŋandô. Tigeŋ aö wandac Damaŋ bu êŋgaho aö su yêc ndoc ŋawapac-ŋga dindec dom. Mba! Tu gêŋ dau dindec-ŋga dec aö gameŋ. ");
INSERT INTO buk_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Damaŋ, aö wasa lêŋ dindec tu bu wapo nem waêm sa.” Yisu sôm yom dinaŋ, ma awha daŋ sa akêŋ undambê bocdec bu, “Aö gatap waêŋ sa tu am-ŋga su, ma watap sa tiyham.” ");
INSERT INTO buk_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Lau daêsam naŋ sêmbo gameŋ dinaŋ sêŋgô ŋakêcsia dau, ma ŋatô sêsôm bu wapap gic. Ma ŋatô sêsôm bu aŋela daŋ sôm yom têŋ Yisu. ");
INSERT INTO buk_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Magoc Yisu sôm, “Awha dinaŋ sa tu aö-ŋga dom, magoc sa tu mac-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kwahic dec ti ndoc Anötö êmatôc lau nom dindec-ŋga. Ma iŋ oc êmasuc nom dindec ŋadau su. ");
INSERT INTO buk_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Magoc têŋ ndoc sêndic aö pi a ma sêsuŋ aö sa yêc nom, naŋ aö oc wahê ŋamalac akêŋ gameŋ hoŋ sêtêŋ aö sêmeŋ.” ");
INSERT INTO buk_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yisu sôm yom dinaŋ bu tôc ŋalêŋ naŋ iŋ oc mbac ndu, naŋ asê. ");
INSERT INTO buk_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ma lau dinaŋ sêô iŋ awha ma sêsôm, “Sêto yom yêc buku yomsu-ŋga, naŋ sôm bu Mesaya oc mbo ŋapaŋ. Ma bocke dec am sôm bu ŋac oc sêsuŋ Ŋamalac ndê Atu sa? Ŋamalac ndê Atu dau iŋ asa?” ");
INSERT INTO buk_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Goc Yisu sôm, “Ya ŋawê oc mbo whiŋ mac ŋasawa sauŋ, ma boc-dinaŋ aŋsêlêŋ ambo ŋawê dau ŋalôm, bu ŋasec nem mac ahuc dom. Lau naŋ sêŋsêlêŋ sêmbo ŋasec ŋalôm, naŋ sem gauc gameŋ naŋ oc sêndi naŋ. ");
INSERT INTO buk_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Akêŋ whiŋ Ŋawê dau naŋ kwahic dec mbo whiŋ mac, ma mac oc ati lau ŋawê-ŋga.” Yisu sôm yom dau su, goc hu ŋac siŋ, ma siŋ dau têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yisu kôm gêŋ dalô daêsam yêc lau Israel aŋgô-ŋga, magoc daêsam sêkêŋ whiŋ dom bu iŋ Mesaya dau. ");
INSERT INTO buk_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ma bocdinaŋ yom naŋ propet Aisaya to muŋ su, naŋ ŋandô sa. Yom dau yêc bocdec: Pômdau, ŋac si asa kêŋ whiŋ yom naŋ yac ahoc asê? Ma ŋac si asa ndê gauc sa pi am nem ŋaclai atu, naŋ am tôc tiawê? ");
INSERT INTO buk_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Bocdinaŋ Anötö ndê propet Aisaya tôc asê gwanaŋ bu lau dinaŋ sêtôm dom bu sêkêŋ whiŋ. Ma iŋ to yom daŋ tiyham bocdec bu: ");
INSERT INTO buk_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Pômdau kôm ŋac si tandô tipec, ma ŋac si ŋalôm ŋadandi. Bocdinaŋ gitôm dom bu sêlic ŋa tandô, ma sêŋyalê yêc ŋac si ŋalôm. Ma gitôm dom bu ŋac sênem dau kwi, ma wakôm ŋac ŋayham sa tiyham. ");
INSERT INTO buk_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaya to yom dau, ŋahu bu iŋ gêlic Yisu ndê ŋawasi su, ma bocdinaŋ dec sôm yom asê pi iŋ. ");
INSERT INTO buk_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Yom dau yêc bocdinaŋ, magoc lau Israel-ŋga daêsam sêkêŋ whiŋ Yisu, ma ŋac si lau bata ŋatô sêwhiŋ. Tigeŋ ŋac sêtôc si sêkêŋ whiŋ iŋ tiawê dom, ŋahu bu ŋac sêtöc bu lau Palêsai oc sêtiŋ ŋac su yêc gôlôwac Israel-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ŋac atac whiŋ bu ŋamalac sêlic ŋac ŋayham ma sêkeŋ waê têŋ ŋac, hôc gêlêc bu sêtap waê sa yêc Anötö. ");
INSERT INTO buk_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ma Yisu sôm yom awha atu, “Asa naŋ kêŋ whiŋ aö, naŋ kêŋ whiŋ aö taŋwasêŋ dom. Iŋ kêŋ whiŋ iŋ naŋ kêkiŋ aö gameŋ, naŋ whiŋ. ");
INSERT INTO buk_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ma asa naŋ gêlic aö, naŋ gêlic iŋ naŋ kêkiŋ aö gameŋ, naŋ bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Aö gahôc asê nom gitôm ya ŋawê, bu lau hoŋ naŋ sêkêŋ whiŋ aö, naŋ oc sêmbo ŋasec dom. ");
INSERT INTO buk_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Asa naŋ ŋgô aneŋ yom magoc daŋga wambu dom, naŋ aö dauŋ oc wamatôc iŋ dom. Bu aö gameŋ bu wamatôc lau nom-ŋga dom, magoc bu wanem ŋac si. ");
INSERT INTO buk_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Lau hoŋ naŋ sêkôc aö ti aneŋ yom sa dom, naŋ oc sêtap matôc sa têŋ bêc ŋambu-ŋga. Ma ŋac si matôc ŋahu sip ŋac sêkôc aneŋ yom sa dom. ");
INSERT INTO buk_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Bu aö gasôm dauŋ neŋ yom dom. Damaŋ naŋ kêkiŋ aö gameŋ, naŋ gic atu yom hoŋ tu wasôm asê-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ma aö kayalê bu yom naŋ iŋ gic atu, naŋ ti ŋamalac si seŋ sêndöc tali ŋapaŋ-ŋga. Bocdinaŋ aŋyalê bu yom hoŋ naŋ aö gasôm, naŋ kêkuc yom naŋ Damaŋ dau kêŋ têŋ aö.” ");
INSERT INTO buk_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Lau Israel-ŋga si om atu mwasiŋ Pasowa-ŋga meŋ kêpiŋ, ma Yisu kêyalê bu ndoc meŋ hôc asê su, bu iŋ hu nom dindec siŋ ma mbu têŋ Damba ndi. Iŋ atac whiŋ iŋ dau ndê lau naŋ sêmbo nom, ma iŋ bu tôc asê tiawê, ŋalêŋ naŋ iŋ atac whiŋ ŋac ndu andô. ");
INSERT INTO buk_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Iŋ ti ndê ŋgacsêŋomi sêndöc sêwhiŋ dau bu sêneŋ gêŋ, ma Judas Iskeriot, Saimon ndê atuŋgac, mbo whiŋ ŋac. Sadaŋ sip iŋ ndê ŋalôm muŋ su, ma kêŋ gauc têŋ iŋ bu hoc Yisu asê. ");
INSERT INTO buk_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yisu kêyalê bu Damba kêŋ gêŋ hoŋ sip iŋ amba, ma bu iŋ meŋ akêŋ Anötö, ma oc mbu têŋ iŋ ndi. ");
INSERT INTO buk_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Bocdinaŋ iŋ tisa yêc tebo, kac iŋ ndê ŋakwê awê-ŋga su, ma kic po dapuŋ dauŋ-ŋga daŋ pi iŋ ŋampê. ");
INSERT INTO buk_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Goc iŋ tac bu sip suc daŋ, ma gic hu kêgwasiŋ ŋgacsêŋomi gahi, ma puŋ ŋa po naŋ iŋ kic pi ŋampêbalê. ");
INSERT INTO buk_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Iŋ têŋ Saimon Pita meŋ, ma Pita ndac, “Pômdau, am bu êmgwasiŋ aö gahiŋ whiŋ, a?” ");
INSERT INTO buk_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ma Yisu ô yom ma sôm, “Kwahic dec am nem gauc sa dom pi gêŋ naŋ aö gakôm gambo, tigeŋ tiŋambu am oc êmyalê.” ");
INSERT INTO buk_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Magoc Pita sôm, “Mba! Am êmgwasiŋ aö gahiŋ dom andô!” Ma Yisu ô yom ma sôm, “Aö bu waŋgwasiŋ am dom, dec am oc ti aneŋ daŋ dom.” ");
INSERT INTO buk_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Dec Pita sôm, “Bocdinaŋ Pômdau, êmgwasiŋ aö gahiŋ ŋambwa dom, magoc amaŋ ti ŋagôlôŋ whiŋ!” ");
INSERT INTO buk_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Magoc Yisu ô yom ma sôm, “Ŋamalac naŋ gêliŋ bu su, naŋ tiŋambu êŋgwasiŋ gahi ŋambwa, dec iŋ ndê ŋamlic sambuc ŋawasi sa. Aö wasôm têŋ mac lau dinaŋ bu mac ŋawasi sa su, magoc mac hoŋ dom.” ");
INSERT INTO buk_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yisu kêyalê ŋgac naŋ oc hoc iŋ asê, ma tu dinaŋ-ŋga sôm bu ŋac hoŋ ŋawasi dom. ");
INSERT INTO buk_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yisu kêgwasiŋ ŋac hoŋ gahi pacndê, dec sôc iŋ ndê ŋakwê awê-ŋga sa tiyham, ma mbu gi ndöc ndê mala. Ma iŋ ndac, “Mac aŋyalê gêŋ naŋ aö gakôm têŋ mac, naŋ ŋahu, me mba? ");
INSERT INTO buk_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Iŋ solop bu mac asam aö bu ‘Kêdôhôŋwaga,’ ma ‘Pômdau,’ bu aö dauŋ dindec. ");
INSERT INTO buk_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ma kwahic dec aö, mac nem kêdôhôŋwaga ma Pômdau, kagwasiŋ mac gahim. Ma aö wasôm têŋ mac, bu aŋgwasiŋ nem asidôwai si gahi bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Aö gatôc ŋadôŋ têŋ mac, bu mac alic ma akôm tôm aö gakôm têŋ mac. ");
INSERT INTO buk_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Aö wasôm yom ŋandô, bu ŋgac akiŋ daŋ hôc gêlêc iŋ ndê ŋadau dom, ma ŋgac aheŋ-ŋga hôc gêlêc iŋ naŋ kêkiŋ iŋ, naŋ dom. ");
INSERT INTO buk_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kwahic dec aö gawhê gêŋ dindec sa ma mac aŋyalê, ma mac bu akôm ŋandô sa, dec oc atap Anötö ndê mwasiŋ sa.” ");
INSERT INTO buk_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ma Yisu sôm, “Aö gasôm yom dindec pi mac hoŋ dom, bu aö kayalê lau naŋ aö kayaliŋ ŋac sa. Tigeŋ yom daŋ naŋ sêto yêc, naŋ oc ŋandô sa. Yom dau sêto yêc bocdec bu, ‘Ŋgac naŋ gêŋ gêŋ whiŋ aö, naŋ kêŋ kisa aö.’ ");
INSERT INTO buk_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Aö gasôm yom asê gwanaŋ pi gêŋ dau, bu têŋ têm gêŋ dau hôc asê, naŋ mac oc akêŋ whiŋ bu aö Mesaya dau. ");
INSERT INTO buk_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Aö wasôm yom ŋandô têŋ mac, bu asa naŋ kôc ŋamalac naŋ aö kakiŋ iŋ, naŋ sa, naŋ kôc aö dauŋ sa. Ma asa naŋ kôc aö sa, naŋ kôc iŋ naŋ kêkiŋ aö gameŋ, naŋ sa.” ");
INSERT INTO buk_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yisu sôm yom dinaŋ su, ma iŋ ndê ŋalôm ŋawapac ŋandô, dec sôm, “Yomandô aö wasôm têŋ mac, bu ŋgac daŋ mbo dec, naŋ oc hoc aö asê.” ");
INSERT INTO buk_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yisu ndê ŋgacsêŋomi sêŋgô yom dinaŋ ma tahê dandi, bu ŋac sem gauc bu ŋgac naŋ iŋ sôm yom pi, iŋ asa. ");
INSERT INTO buk_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ŋgacsêŋom naŋ Yisu tac whiŋ ndu andô, naŋ ndöc gi paŋ Yisu. ");
INSERT INTO buk_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Dec Saimon Pita gic amba têŋ iŋ, ma sôm, “Am ndac iŋ bu iŋ sôm yom pi asa.” ");
INSERT INTO buk_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Goc ŋgacsêŋom dau töŋ sac Yisu, ma ndac, “Pômdau, asa?” ");
INSERT INTO buk_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ma Yisu ô yom ma sôm, “Ŋgac naŋ aö wapuc bolom dindec sip sulu ma wakêŋ têŋ iŋ.” Goc iŋ puc bolom sip sulu ma kêŋ têŋ Judas Iskeriot, Saimon atuŋgac. ");
INSERT INTO buk_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas kôc bolom dau su, ma ŋagahô Sadaŋ sip iŋ ndê ŋalôm. Ma Yisu sôm têŋ iŋ, “Sa ndi, ma gêŋ naŋ am gauc gêm bu kôm, naŋ kôm ŋagahô.” ");
INSERT INTO buk_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Lau hoŋ naŋ sêndöc tebo, naŋ sêŋgô yom naŋ Yisu sôm têŋ Judas, magoc sêŋyalê ŋahu dom. ");
INSERT INTO buk_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas iŋ ŋgac naŋ yob ŋac si talhi mone-ŋga, ma bocdinaŋ dec ŋgacsêŋomi ŋatô gauc gêm bu Yisu kêkiŋ iŋ sa gi bu nemlhi gêŋ tu Mwasiŋ Pasowa-ŋga, me bu kêŋ gêŋ têŋ lau ŋalôm sawa. ");
INSERT INTO buk_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas gêŋ bolom naŋ Yisu kêŋ têŋ iŋ, ma sa awê gi. Ma gameŋ ŋasec sa. ");
INSERT INTO buk_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas sa gi su, ma Yisu sôm, “Kwahic dec Ŋamalac ndê Atu oc tap iŋ ndê waê sa, ma iŋ oc po Anötö ndê waê sa whiŋ. ");
INSERT INTO buk_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ma Anötö oc kêŋ dau ndê ŋawasi têŋ ndê Atuŋgac bu po Atu ndê waê sa. Ma iŋ oc po ndê waê sa ŋagahô eŋ. ");
INSERT INTO buk_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“O aneŋ lau hac. Aö wambo wawhiŋ mac ŋasawa sauŋ eŋ. Tiŋambu mac oc aŋsalê aö, tigeŋ tôm aö gasôm têŋ lau bata Israel-ŋga su, dec wasôm têŋ mac bu gameŋ naŋ aö bu wandi, naŋ mac atôm dom bu ameŋ. ");
INSERT INTO buk_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kwahic dec aö wakêŋ yomsu wakuc têŋ mac bocdec bu. Akêŋ nem atac whiŋ lom daôm. Tôm aö atac whiŋ mac, dec mac atac whiŋ nem asidôwai bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ma têŋ ndoc lau hoŋ sêlic mac nem mêtê atac whiŋ daôm-ŋga, dec ŋac oc sêŋyalê pi ŋandô bu aneŋ ŋgacsêŋomi mac.” ");
INSERT INTO buk_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Goc Saimon Pita ndac iŋ bu, “Pômdau, am oc mbo nde?” Ma Yisu ô yom ma sôm, “Gameŋ naŋ aö oc wandi, naŋ am gitôm dom bu êmkuc aö kwahic dec. Magoc tiŋambu am oc êmkuc aö mweŋ.” ");
INSERT INTO buk_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Goc Pita ndac, “Pômdau, tu sake-ŋga am sôm bu kwahic dec aö gatôm dom bu waŋkuc am? Aö wakêŋ dauŋ sambuc e nditôm wambac ndu tu am-ŋga.” ");
INSERT INTO buk_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ma Yisu ô yom ma sôm, “Am gauc gêm bu am gitôm bu mbwac ndu tu aö-ŋga, a? Aö wasôm yomandô têŋ am, bu ôbwêc dau dindec am oc sêc aö ahuc tidim tö muŋ, goc dalec oc taŋ.” ");
INSERT INTO buk_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ma Yisu sôm têŋ ndê ŋgacsêŋomi, “Ambo ti nem ŋalôm ŋawapac dom. Akêŋ whiŋ Anötö, ma akêŋ whiŋ aö bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ŋalôm daêsam yêc Damaŋ ndê andu. Bu mba, oc wasôm yom dindec asê têŋ mac dom. Aö watêŋ Damaŋ ndê andu dau wandi, bu wamasaŋ mac nem malam. ");
INSERT INTO buk_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aêc, aö oc wandi, ma wamasaŋ nem malam, ma tiŋambu aö wambu wameŋ ma wakôc mac sa bu ameŋ andöc gameŋ dinaŋ awhiŋ aö. ");
INSERT INTO buk_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mac aŋyalê seŋ têŋ gameŋ naŋ aö oc wandi.” ");
INSERT INTO buk_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Magoc Tomas sôm têŋ iŋ, “Pômdau, yac am gauc gameŋ naŋ am oc ndi, ma bocdinaŋ ŋalêŋ bocke dec yac oc aŋyalê seŋ bu atêŋ gameŋ dau andi?” ");
INSERT INTO buk_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ma Yisu sôm, “Aö dauŋ gati seŋ, ma yom ŋandô ti mac andöc tamli ŋahu yêc aö. Aö taŋwasêŋ gati seŋ bu ŋamalac sêtêŋ Damaŋ sêndi, ma seŋ daŋ yêc dom. ");
INSERT INTO buk_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mac bu aŋyalê aö ŋapep, dec oc aŋyalê Damaŋ whiŋ. Ma kwahic dec ma ndi, mac aŋyalê iŋ, ma mac alic iŋ su.” ");
INSERT INTO buk_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Goc Pilip sôm, “Pômdau, tôc Damam têŋ yac, naŋ goc nditôm.” ");
INSERT INTO buk_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ma Yisu ô iŋ ndê yom ma sôm, “O Pilip, aö gambo gawhiŋ mac ŋasawa baliŋ su, ma bocke am kêyalê aö dom? Tu sake-ŋga am sôm têŋ aö bu watôc Damaŋ têŋ mac? Aö wasôm têŋ am, bu asa naŋ gêlic aö su, naŋ gêlic Damaŋ su bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Aö gasôm su, bu aö gambo Damaŋ ŋalôm, ma iŋ mbo aö ŋalôm. Mac akêŋ whiŋ yom dau, me mba? Yom naŋ aö gasôm, naŋ aö taŋwasêŋ neŋ yom dom. Damaŋ naŋ mbo aö ŋalôm, naŋ kôm iŋ ndê gweleŋ ŋa aö. ");
INSERT INTO buk_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Aö gasôm bu aö gambo Damaŋ ŋalôm, ma iŋ mbo aö ŋalôm. Akêŋ whiŋ aneŋ yom dinaŋ. Magoc mac bu akêŋ whiŋ aneŋ yom dom, dec gauc nem gêŋ atu-tu naŋ aö gakôm ŋa Damaŋ ndê ŋaclai, ma akêŋ whiŋ tu gêŋ dinaŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Aö wasôm yom ŋandô têŋ mac, bu asa naŋ kêŋ whiŋ aö, naŋ oc kôm gêŋ atu-tu gitôm aö gakôm. Ma iŋ oc kôm gêŋ atu-tu naŋ hôc gêlêc iŋ dinaŋ su. Ŋahu bu kwahic dec aö watêŋ Damaŋ wandi. ");
INSERT INTO buk_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ma aö wakôm gêŋ bocke naŋ mac ateŋ tu aneŋ ŋaê-ŋga, ma ŋalêŋ dinaŋ aö wapo Damaŋ ndê waê sa. ");
INSERT INTO buk_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ateŋ gêŋ tu aneŋ ŋaê-ŋga, ma aö wakôm gêŋ dau ŋandô sa.” ");
INSERT INTO buk_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ma Yisu sôm, “Mac bu atac whiŋ aö, dec daŋam wambu aneŋ yom. ");
INSERT INTO buk_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Ma aö wandac Damaŋ, ma iŋ oc kêŋ Ŋalau Yom Ŋandô-ŋga bu meŋ mbo whiŋ mac ŋapaŋ eŋ. Iŋ oc puc mac dôŋ ti nem mac awham ô aö. Lau sac nom-ŋga oc sêkôc iŋ sa dom, bu ŋac sêtôm dom bu sêlic iŋ me sêŋyalê iŋ. Tigeŋ mac aŋyalê iŋ, bu iŋ mbo whiŋ mac, ma oc mbo mac nem ŋalôm. ");
INSERT INTO buk_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Aö wahu mac siŋ bu ambo atôm mosibu dom. Mba! Aö dauŋ watêŋ mac waloc. ");
INSERT INTO buk_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","“Ŋasawa sauŋ ma lau nom-ŋga oc sêlic aö tiyham dom, tigeŋ mac oc alic aö. Ŋahu bu aö oc watisa tiyham ma wambo taŋli, ma tu dinaŋ-ŋga dec oc nditôm bu mac ambo tamli ŋapaŋ awhiŋ. ");
INSERT INTO buk_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Têŋ têm dinaŋ, mac oc aŋyalê bu aö gambo Damaŋ ŋalôm, ma mac ambo aö ŋalôm, ma aö gambo mac ŋalôm. ");
INSERT INTO buk_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Asa naŋ kôc aneŋ yomsu sa yêc iŋ ndê ŋalôm ma daŋga wambu, naŋ tôc asê bu iŋ atac whiŋ aö ŋandô, ma Damaŋ oc atac whiŋ iŋ bocdinaŋ. Ma aö dauŋ oc atac whiŋ iŋ, ma watôc dauŋ asê têŋ iŋ.” ");
INSERT INTO buk_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Goc ŋgacsêŋom daŋ ŋaê Judas sôm, “Pômdau, tu sake-ŋga am sôm bu tôc daôm asê têŋ yac, magoc têŋ lau nom-ŋga hoŋ dom?” (Ŋgacsêŋom dinaŋ iŋ Judas Iskeriot dom.) ");
INSERT INTO buk_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ma Yisu ô yom ma sôm, “Asa naŋ atac whiŋ aö, naŋ oc daŋga wambu aneŋ yom. Ma Damaŋ oc atac whiŋ iŋ ma alu oc atêŋ iŋ aloc ma ambo awhiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yom naŋ aö gasôm asê têŋ mac, naŋ aö dauŋ neŋ yom dom. Damaŋ naŋ kêkiŋ aö gameŋ, naŋ ndê yom. Tigeŋ lau nom-ŋga naŋ atac whiŋ aö dom, naŋ daŋga wambu aneŋ yom dau dom. ");
INSERT INTO buk_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“K wahic dec aö gambo gawhiŋ mac ma gasôm yom hoŋ dindec têŋ mac. ");
INSERT INTO buk_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Magoc tiŋambu, Damaŋ oc êŋkiŋ Ŋalau Dabuŋ nem aö aŋôŋ têŋ mac loc bu nem mac sa. Iŋ oc êndôhôŋ mac pi gêŋ hoŋ, ma kêŋ mac gauc nem yom hoŋ naŋ aö gasôm têŋ mac su. ");
INSERT INTO buk_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Aö wakêŋ aneŋ yom malô têŋ mac bu yêc mac ŋapaŋ, dec ambo ti atac malô. Bu yom malô naŋ aö oc wakêŋ têŋ mac, naŋ hôc gêlêc lau nom-ŋga si su. Bocdinaŋ ahêgo daôm dom, ma atöc daôm dom. ");
INSERT INTO buk_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Aö gasôm têŋ mac bu aö oc wahu mac siŋ, ma tiŋambu oc wambu wameŋ tiyham. Ma mac bu atac whiŋ aö, dec mac oc atac ŋayham bu aö watêŋ Damaŋ wandi, bu Damaŋ hôc gêlêc aö su. ");
INSERT INTO buk_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kwahic dec aö gasôm yom dindec têŋ mac gwanaŋ, bu tiŋambu têŋ ndoc aneŋ yom dau ŋandô sa, naŋ goc mac oc akêŋ whiŋ aö. ");
INSERT INTO buk_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Ndoc tiapê, dec gitôm dom bu wasôm yom daêsam têŋ mac. Ŋahu bu nom dindec ŋadau kêpiŋ bu meŋ. Iŋ dau ndê ŋaclai mba bu kôm gêŋ daŋ têŋ aö. ");
INSERT INTO buk_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Magoc aö wakôm gêŋ hoŋ nditôm Damaŋ gic atu aö, ma ŋalêŋ dinaŋ dec lau nom-ŋga oc sêŋyalê bu aö atac whiŋ Damaŋ. Bocdinaŋ atisa ma dalhö.” ");
INSERT INTO buk_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ma Yisu sôm, “Aö a wain ŋandô, ma Damaŋ ti ôm wain-ŋga ŋadau. ");
INSERT INTO buk_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","A wain ŋasaŋgac hoŋ naŋ sêlhac wain ŋahu aö dauŋ ma sem ŋandô dom, naŋ Damaŋ oc so kic. Ma ŋasaŋgac naŋ sem ŋandô, naŋ iŋ oc ndic sêli bu kôm ŋawasi sa ma nem ŋandô daêsam. ");
INSERT INTO buk_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ma ŋalêŋ tigeŋ, yom naŋ aö gasôm têŋ mac su, naŋ kôm mac nem ŋalôm ŋawasi sa su. ");
INSERT INTO buk_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Asap aö dôŋ, ma aö wasap mac dôŋ bocdinaŋ. A wain ŋasaŋgac daŋ bu sap ŋahu dôŋ dom, dec oc tôm dom bu nem ŋandô yêc dau-ŋga. Ma mac bocdinaŋ. Mac bu asap aö dôŋ dom, dec oc tôm dom bu mac anem ŋandô. ");
INSERT INTO buk_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Aö gatôm a w ain ŋahu, ma mac atôm ŋasaŋgac. Asa naŋ sap aö dôŋ, ma aö wasap iŋ dôŋ, naŋ oc nem ŋandô daêsam. Mac bu asap aö dôŋ dom, dec oc atôm bu akôm gêŋ ŋayham daŋ dom. ");
INSERT INTO buk_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Asa naŋ sap aö dôŋ dom, naŋ gitôm ŋasaŋgac naŋ kegwelec sip nom ma tibasô. Ma ŋasaŋgac kaiŋ dinaŋ oc sêhoŋ sa ma sêkêŋ pi ya ndi ma ya neŋ su. ");
INSERT INTO buk_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Mac bu asap aö dôŋ, ma bu akôc aneŋ yom sa tidôŋ yêc nem ŋalôm, dec gêŋ bocke naŋ mac bu atac whiŋ, naŋ ateŋ têŋ Anötö, ma iŋ oc kêŋ têŋ mac. ");
INSERT INTO buk_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Asap aö dôŋ ma anem ŋandô daêsam, dec oc whê mac sa bu aneŋ ŋgacsêŋomi ŋandô, ma ŋalêŋ dinaŋ mac oc apo Damaŋ ndê waê sa. ");
INSERT INTO buk_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Aö atac whiŋ mac, gitôm Damaŋ atac whiŋ aö. Kwahic dec ambo aneŋ atac whiŋ ŋalôm. ");
INSERT INTO buk_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Aö daŋaŋ wambu yom hoŋ naŋ Damaŋ gic atu aö, ma aö gambo iŋ ndê atac whiŋ ŋalôm. Ma mac bu daŋam wambu yom naŋ aö gac atu mac, dec mac oc ambo aneŋ atac whiŋ ŋalôm. ");
INSERT INTO buk_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Aö gasôm yom dindec têŋ mac, tu bu aneŋ atac ŋayham nem mac nem ŋalôm ahuc. Ma aneŋ atac ŋayham oc êŋsalê mac ahuc. ");
INSERT INTO buk_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Aneŋ yomsu dau dec, bu mac atac whiŋ nem asidôwai, gitôm aö atac whiŋ mac. ");
INSERT INTO buk_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ŋamalac naŋ kêŋ dau sambuc ma mbac ndu ô iŋ ndê asidôwa, naŋ ndê mêtê atac whiŋ-ŋga hôc gêlêc lau hoŋ si su. ");
INSERT INTO buk_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","“Mac bu aŋkuc aö neŋ yomsu ma akêŋ nem atac whiŋ lom daôm, naŋ mac ati aneŋ lau atac whiŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ŋadau daŋ oc sôm gêŋ hoŋ asê têŋ iŋ ndê lau akiŋ dom. Magoc gêŋ hoŋ naŋ aö gaŋgô yêc Damaŋ, naŋ aö gawhê sa têŋ mac su. Tu dinaŋ-ŋga aö wasam mac bu lau akiŋ tiyham dom, magoc aö wasam mac bu aö neŋ lau atac whiŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mac aŋkuc aö tu daôm nem gauc-ŋga dom. Mba! Aö dauŋ kayaliŋ mac sa, ma kakiŋ mac bu asa andi ma anem ŋandô daêsam, naŋ oc yêc ŋapaŋ. Ma têŋ ndoc dinaŋ, gêŋ sake naŋ mac ateŋ têŋ Damaŋ anem aö aŋôŋ, naŋ iŋ oc kêŋ têŋ mac. ");
INSERT INTO buk_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Aö neŋ yomsu dau bocdec bu, atac whiŋ mac nem asidôwai andic ŋawaê.” ");
INSERT INTO buk_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ma Yisu sôm, “Têŋ ndoc lau sac nom-ŋga atac tec mac, naŋ gauc nem bu ŋac sêtec aö muŋ su. ");
INSERT INTO buk_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mac bu aŋkuc lau nom-ŋga si mêtê, dec lau nom-ŋga oc atac whiŋ mac, ŋahu bu ŋac atac whiŋ ŋac dau si lau. Magoc mac ambo atôm lau nom-ŋga dom, bu aö kayaliŋ mac sa su yêc ŋac, ma tu dinaŋ-ŋga dec ŋac oc sêtec mac. ");
INSERT INTO buk_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Gauc nem yom naŋ aö gasôm têŋ mac bocdec bu, ‘Ŋgac akiŋ daŋ oc hôc gêlêc iŋ ndê ŋadau dom.’ Lau nom-ŋga sêkêŋ kisa aö, ma oc sêkêŋ kisa mac bocdinaŋ. Ŋac sêkôc aneŋ yom sa dom, ma bocdinaŋ ŋac oc sêkôc mac nem yom sa dom. ");
INSERT INTO buk_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ŋac oc sêkôm gêŋ hoŋ dinaŋ têŋ mac tu mac akêŋ whiŋ aö-ŋga, ŋahu bu ŋac sêŋyalê iŋ naŋ kêkiŋ aö gameŋ, naŋ dom. ");
INSERT INTO buk_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Aö bu wameŋ ma wahoc neŋ yom asê têŋ ŋac dom, dec ŋac si giso mba. Magoc ŋac sêŋgô aneŋ yom hoŋ su ma sêkêŋ whiŋ dom, dec ŋalêŋ mba bu sêmasaŋ yom têŋ Anötö tu ŋac si giso-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Asa naŋ atac tec aö, naŋ atac tec Damaŋ whiŋ. ");
INSERT INTO buk_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Aö gakôm gêŋ dalô yêc ŋac si aŋgô-ŋga, naŋ ŋamalac daŋ gitôm dom bu kôm. Aö bu watôc têŋ ŋac dom, dec ŋac si giso mba. Magoc ŋac sêlic su, ma sêkêŋ whiŋ aö dom. Mba! Ŋac sêtec aö, ma sêtec Damaŋ whiŋ. ");
INSERT INTO buk_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ma bocdinaŋ Anötö ndê yom naŋ sêto yêc ŋac si buku yomsu-ŋga, naŋ dec ŋandô sa. Yom dau sôm bu, ‘Ŋac atac tec aö ŋambwa.’ ");
INSERT INTO buk_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Tiŋambu, aö waŋkiŋ Ŋalau meŋ bu puc mac dôŋ ma nem mac awham sa. Iŋ Ŋalau naŋ sa akêŋ Damaŋ, ma sôm yom ŋandô eŋ. Ma têŋ ndoc iŋ meŋ, naŋ iŋ oc hoc yom ŋandô asê pi aö. ");
INSERT INTO buk_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ma mac oc ahoc yom ŋandô asê pi aö bocdinaŋ, b u mac ambo awhiŋ aö têŋ ŋamata-ŋga e meŋ têŋ dec. ");
INSERT INTO buk_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Aö gasôm yom hoŋ dindec têŋ mac bu wapuc mac dôŋ, bu ahu nem akêŋ whiŋ aö siŋ dom têŋ ndoc mac atap kisa sa. ");
INSERT INTO buk_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Lau Israel-ŋga oc sêmasuc mac su yêc gôlôwac Israel-ŋga. Ndoc oc meŋ, naŋ lau oc sêndic mac nem lau ŋatô ndu, ma ŋac oc gauc nem bu sêkôm gêŋ ŋayham tu sênem akiŋ Anötö-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ŋac sêŋyalê Damaŋ dom, ma sêŋyalê aö dom, ma tu dinaŋ-ŋga dec ŋac oc sêkôm bocdinaŋ têŋ mac. ");
INSERT INTO buk_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Magoc kwahic dec aö gasôm yom dindec têŋ mac, bu têŋ ndoc gêŋ dau hôc asê mac, naŋ gauc nem bu aö gakêŋ puc mac gwanaŋ su.” “Aö gasôm yom dinaŋ asê têŋ mac muŋ su dom, ŋahu bu aö gambo gawhiŋ mac. ");
INSERT INTO buk_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Magoc kwahic dec aö oc wahu mac siŋ, ma wambu watêŋ iŋ naŋ kêkiŋ aö gameŋ, naŋ wandi. Ma bocke dec mac nem daŋ ndac aö pi gameŋ wandi-ŋga dom? ");
INSERT INTO buk_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Tigeŋ tu aö gasôm bu wahu mac siŋ-ŋga, dec kayalê bu mac nem ŋalôm ŋawapac ŋandô. ");
INSERT INTO buk_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Aö wasôm yom ŋandô têŋ mac, bu aö bu wahu mac siŋ dec oc wanem mac sa. Aö bu wahu mac siŋ dom, goc Ŋalau Nem Mac Sa-ŋga oc têŋ mac meŋ dom. Magoc aö bu wandi, dec aö waŋkiŋ iŋ têŋ mac meŋ. ");
INSERT INTO buk_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ma têŋ ndoc iŋ meŋ, naŋ iŋ oc tôc lau nom-ŋga si giso asê tiawê pi sac, ma pi lêŋ gitêŋ, ma pi Anötö ndê matôc. ");
INSERT INTO buk_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Iŋ oc tôc ŋac si sac ŋahu asê, naŋ sip ŋac sêkêŋ whiŋ aö dom. ");
INSERT INTO buk_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ma iŋ oc tôc asê bu lau nom-ŋga sêŋyalê Anötö ndê lêŋ gitêŋ dom, bu aö oc watêŋ Damaŋ wandi, ma mac oc alic aö tiyham dom. ");
INSERT INTO buk_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ma iŋ oc tôc asê bu Anötö oc êmatôc sac hoŋ, tôm kwahic dec iŋ oc êmatôc nom dindec ŋadau. ");
INSERT INTO buk_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Yom daêsam yêc bu wasôm têŋ mac, magoc mac atôm dom bu akôc sa. ");
INSERT INTO buk_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Magoc têŋ ndoc Ŋalau Yom Ŋandô-ŋga meŋ su, naŋ iŋ oc nem mac sa bu aŋyalê yom ŋandô hoŋ. Ŋahu bu iŋ oc sôm dau ndê yom asê dom, magoc yom hoŋ naŋ iŋ ŋgô yêc alu Damaŋ, naŋ dec iŋ oc hoc asê. Ma iŋ oc kêŋ puc mac pi gêŋ naŋ oc hôc asê tiŋambu. ");
INSERT INTO buk_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ŋalau Dabuŋ oc po aneŋ waêŋ sa, ŋahu bu iŋ oc kôc aö dauŋ neŋ yom, ma hoc asê têŋ mac. ");
INSERT INTO buk_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Damaŋ ndê gêŋ hoŋ ti aö neŋ, ma tu dinaŋ-ŋga dec gasôm têŋ mac bu gêŋ hoŋ naŋ Ŋalau oc hoc asê têŋ mac, naŋ meŋ akêŋ aö neŋ.” ");
INSERT INTO buk_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Goc Yisu sôm, “Ŋasawa sauŋ mac oc alic aö dom, ma ŋasawa sauŋ mac oc alic aö tiyham.” ");
INSERT INTO buk_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yisu sôm yom dinaŋ, goc iŋ ndê ŋgacsêŋomi sem yomgalôm, ma ŋatô sêsôm têŋ dandi, “Yom bocke dec iŋ sôm bu ŋasawa sauŋ yac oc dalic iŋ dom, ma ŋasawa sauŋ yac oc dalic iŋ tiyham? Ma iŋ sôm bu iŋ oc têŋ Damba ndi.” ");
INSERT INTO buk_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Goc sêndac dandi ŋapaŋ bu, “Iŋ ndê yom dinaŋ pi ŋasawa sauŋ, naŋ ŋahu bocke? Yac taŋyalê iŋ ndê yom ŋahu dom.” ");
INSERT INTO buk_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yisu kêyalê bu ŋac bu sêndac iŋ pi yom dau, dec sôm têŋ ŋac, “Aö gasôm bu ŋasawa sauŋ mac oc alic aö dom, ma ŋasawa sauŋ mac oc alic aö tiyham. Tu sake-ŋga mac am yomgalôm pi yom dau? ");
INSERT INTO buk_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yomandô aö wasôm têŋ mac, bu têŋ ndoc aö wahu mac siŋ, naŋ mac oc ahu daŋgibo asê ma ataŋ, magoc lau sac nom-ŋga oc atac ŋayham sa. Mac oc ambo ti nem ŋalôm ŋawapac, magoc tiŋambu mac nem ŋalôm ŋawapac oc nem dau kwi ti atac ŋayham. ");
INSERT INTO buk_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Oc nditôm awhê tidaê naŋ ndê ndoc meŋ sa bu kôc balêkoc-ŋga. Iŋ ŋalôm ŋawapac bu iŋ kêsahê ŋandê atu. Tigeŋ têŋ ndoc iŋ kôc balêkoc dau su, naŋ iŋ oc gauc nem ŋandê dau tiyham dom, bu iŋ atac ŋayham sa bu iŋ ndê balêkoc hôc asê su. ");
INSERT INTO buk_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ma mac bocdinaŋ, kwahic dec mac ambo ti ŋalôm ŋawapac, magoc tiŋambu aö walic mac tiyham, ma têŋ ndoc dinaŋ, mac oc atac ŋayham atu. Ma lau daŋ oc sêkôc atac ŋayham su yêc mac dom. ");
INSERT INTO buk_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Têŋ têm dinaŋ mac oc andac aö pi gêŋ daŋ tiyham dom. Yomandô aö wasôm têŋ mac, bu gêŋ sake naŋ mac ateŋ têŋ Damaŋ tu aneŋ ŋaê-ŋga, naŋ iŋ oc kêŋ têŋ mac. ");
INSERT INTO buk_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Têŋ ŋamata-ŋga e meŋ têŋ kwahic dec, mac ateŋ gêŋ daŋ tu aneŋ ŋaê-ŋga dom. Kwahic dec ma ndi, naŋ ateŋ gêŋ tu aneŋ ŋaê-ŋga. Ma Anötö oc kêŋ têŋ mac, ma mac oc atisambuc ŋandô.” ");
INSERT INTO buk_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Gêŋ hoŋ dinaŋ aö gasôm têŋ mac ŋa yom gôliŋ. Magoc têm oc meŋ sa, naŋ aö oc wasôm yom têŋ mac ŋa yom gôliŋ dom. Aö oc wasôm yom yêc awê têŋ mac pi Damaŋ. ");
INSERT INTO buk_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Têŋ ndoc dinaŋ mac oc ateŋ gêŋ tu aneŋ ŋaê-ŋga. Aö wasôm têŋ mac, bu aö dauŋ oc wanem mac awham têŋ Damaŋ lec dom. Mac daôm ateŋ nem mbec solop têŋ iŋ, ");
INSERT INTO buk_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","bu iŋ atac whiŋ mac. Aêc! Damaŋ Anötö atac whiŋ mac, ŋahu bu mac atac whiŋ aö, ma akêŋ whiŋ bu iŋ kêkiŋ aö gameŋ. ");
INSERT INTO buk_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Aö gambo gawhiŋ Damaŋ muŋ su, dec gasip nom gameŋ. Ma kwahic dec aö bu wahu nom siŋ ma wambu watêŋ iŋ wandi.” ");
INSERT INTO buk_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Têŋ dinaŋ Yisu ndê ŋgac-sêŋomi sêsôm têŋ iŋ, “Kwahic dec am sôm yom yêc awê, ma sôm ŋa yom gôliŋ dom. ");
INSERT INTO buk_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ma kwahic dec yac aŋyalê bu am kêyalê gêŋ hoŋ. Ma lau sêkêŋ gêndac têŋ am dom magoc am kêyalê ŋac si gauc ti yom hoŋ muŋ. Tu dinaŋ-ŋga dec yac akêŋ whiŋ bu am mweŋ akêŋ Anötö ndê.” ");
INSERT INTO buk_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Goc Yisu sôm têŋ ŋac, “Kwahic dec mac akêŋ whiŋ, a? ");
INSERT INTO buk_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Aö wasôm têŋ mac, bu ndoc oc meŋ sa, ma kwahic dec meŋ kêpiŋ su, naŋ mac hoŋ oc ahu aö siŋ ma alhö têŋtêŋ. Magoc aö oc wambo taŋwasêŋ dom, bu Damaŋ oc mbo whiŋ aö. ");
INSERT INTO buk_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Aö gasôm yom hoŋ dindec têŋ mac bu wapuc mac dôŋ bu ambo ti atac malô tu aö-ŋga. Yêc nom mac oc atap ŋawapac sa, magoc ambo ti nem ŋalôm pêŋ dôŋ, bu aö gaku ŋaclai nom-ŋga dulu su.” ");
INSERT INTO buk_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yisu sôm yom dinaŋ su, goc tatac undambê, ma teŋ mbec bocdec bu, “Damaŋ, aneŋ ndoc hôc asê su. Po am Atôm, aö dec neŋ waêŋ sa, ma ŋalêŋ dinaŋ aö oc wapo am nem waêm sa. ");
INSERT INTO buk_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Am kêŋ ŋaclai têŋ aö pi ŋamalac hoŋ, tu bu wakêŋ lau hoŋ naŋ am kêŋ têŋ aö, naŋ sêmbo tali ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ma ŋac si ŋahu sêmbo tali ŋapaŋ-ŋga dau bocdec bu, sêŋyalê am Anötö ŋandô tigeŋ, ma sêŋyalê aö, Yisu Kilisi naŋ am kêkiŋ aö gameŋ. ");
INSERT INTO buk_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Aö gac dabiŋ gweleŋ naŋ am kêŋ sip aö amaŋ, ma tu dinaŋ-ŋga dec aö gapo nem waêm sa yêc nom. ");
INSERT INTO buk_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Têŋ ŋamata-ŋga nom dindec mbasi, naŋ aö dec gambo gawhiŋ am ma hêclu dawêkaiŋ ŋawasi atu dawhiŋ dauŋ. Kwahic dec Damaŋ, aö wandac am bu kôc aö sa bu wambo wawhiŋ am tiyham ti ŋawasi atu dau.” ");
INSERT INTO buk_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ma Yisu sôm, “O Damaŋ, am kêyaliŋ am nem lau sa yêc nom, ma kêŋ ŋac sêsip aö amaŋ. Aö gatôc am asê têŋ ŋac su, ma ŋac daŋga wambu am nem yom. ");
INSERT INTO buk_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ma kwahic dec ŋac sêŋyalê bu gêŋ hoŋ naŋ aö gakôm, naŋ ŋahu am daôm, ma am kêŋ sip aö amaŋ bu wakôm-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Bu yom naŋ am kêŋ têŋ aö, naŋ aö gasôm asê têŋ ŋac, ma sêkôc sa. Ma ŋac sêŋyalê pi ŋandô bu muŋ-ŋga aö gambo gawhiŋ am, ma sêkêŋ whiŋ bu am daôm kêkiŋ aö gameŋ. ");
INSERT INTO buk_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Kwahic dec aö bu wateŋ mbec tu ŋac-ŋga. Aö wateŋ tu lau nom-ŋga hoŋ-ŋga dom, magoc aö wateŋ tu am nem lau hoŋ, naŋ am kêŋ sip aö amaŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Aneŋ lau hoŋ sêti am nem, ma am nem lau hoŋ sêti aö neŋ. Ma aö gatap waêŋ sa tu ŋac-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Aneŋ têm wambo nom-ŋga pacndê, ma malô aö oc watêŋ am waloc. Magoc ŋac oc gacgeŋ sêmbo nom. O Damaŋ dabuŋ, aö bu wateŋ am bu yob lau dinaŋ ŋa am nem ŋaê ŋa-ŋaclai atu naŋ am gêlic ŋayham bu kêŋ têŋ aö. Yob ŋac bu sêpiŋ dau dôŋ sêti gêŋ tigeŋ, gitôm hêclu dati gêŋ tigeŋ. ");
INSERT INTO buk_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Têŋ ndoc aö gambo gawhiŋ ŋac, naŋ aö gayob ŋ ac ŋapep ŋa am nem ŋaê ŋa-ŋaclai naŋ am kêŋ têŋ aö. Ma bocdinaŋ ŋac si daŋ giŋga dom. Ŋgac tigeŋ naŋ gic waê bu peŋ, naŋ tawasê oc niŋga, bu kôm yom naŋ sêto yêc, naŋ ŋandô sa. ");
INSERT INTO buk_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Malô aö oc watêŋ am waloc. Tigeŋ kwahic dec aö gambo nom ma gasôm yom hoŋ dinaŋ asê têŋ aneŋ lau, tu bu aneŋ atac ŋayham nem ŋac ahuc, ma kôm ŋac sêtisambuc. ");
INSERT INTO buk_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Aö gakêŋ am nem yom têŋ ŋac, ma lau sac nom-ŋga atac tec ŋac. Sêtec ŋac ŋahu bu ŋac si mala ŋandô yêc nom dom, gitôm aö dauŋ neŋ malaŋ ŋandô yêc nom dom. ");
INSERT INTO buk_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Aö wateŋ am bu kôc ŋac su yêc nom dom, magoc aö wateŋ am bu yob ŋac tu ŋgac sac Sadaŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ŋac si mala ŋandô yêc nom dom, gitôm aö neŋ malaŋ ŋandô yêc nom dom. ");
INSERT INTO buk_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Damaŋ, am nem yom iŋ yom ŋandô eŋ. Kêŋ nem yom ŋandô sip ŋac si ŋalôm bu kôm ŋac sêti lau dabuŋ ŋandô. ");
INSERT INTO buk_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tôm am kêkiŋ aö gasip nom gameŋ, dec aö waŋkiŋ ŋac sêsa sêndi sêmbo lau nom-ŋga ŋalôm. ");
INSERT INTO buk_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kwahic dec aö gam dabuŋ dauŋ bu wandic bata am nem lêŋ nem lau si-ŋga, ma ŋalêŋ dau dinaŋ dec oc tôm bu ŋac dau sêti am nem lau dabuŋ.” ");
INSERT INTO buk_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Aö wateŋ mbec tu lau naŋ kwahic dec sêŋyalê aö, naŋ tawasê-ŋga dom. Aö wateŋ mbec tu lau hoŋ naŋ sêŋgô yom naŋ ŋac oc sêhoc asê pi aö, ma sêkêŋ whiŋ aö-ŋga sêwhiŋ. ");
INSERT INTO buk_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Kêŋ ŋac hoŋ sêmbo ti ŋalôm ma gauc tigeŋ, gitôm hêclu dati gêŋ tigeŋ, am mbo aö ŋalôm, ma aö gambo am ŋalôm. Pwiŋ ŋac hoŋ dôŋ sênem damiŋ hêclu, ma bocdinaŋ têŋ ndoc lau nom-ŋga sêlic ŋac sêpiŋ dau dôŋ ti ŋalôm tigeŋ, dec ŋac hoŋ oc sêkêŋ whiŋ bu am kêkiŋ aö gameŋ. ");
INSERT INTO buk_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Am nem ŋaclai ti ŋawasi naŋ am kêŋ têŋ aö, naŋ dec aö gakêŋ têŋ ŋac, bu ŋac oc sêti gêŋ tigeŋ gitôm hêclu dati gêŋ tigeŋ. ");
INSERT INTO buk_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Am mbo aö ŋalôm, ma aö wambo ŋac ŋalôm, tu bu wapiŋ ŋac dôŋ bu sêmbo ti ŋalôm ma gauc tigeŋ. Ma bocdinaŋ lau nom-ŋga oc sêŋyalê bu am kêkiŋ aö gameŋ, ma bu am atac whiŋ ŋac gitôm am atac whiŋ aö. ");
INSERT INTO buk_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Damaŋ, aö tac whiŋ bu lau hoŋ naŋ am kêŋ ŋac sêsip aö amaŋ, naŋ sêwhiŋ aö sêmeŋ ma sêmbo gameŋ naŋ aö oc wambo. Dec ŋac oc sêlic ŋawasi atu naŋ am kêŋ têŋ aö. Bu muŋ-ŋga, nom dindec mbasi, naŋ am atac whiŋ aö ndu andô, dec kêŋ ŋawasi dau têŋ aö. ");
INSERT INTO buk_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O Damaŋ gitêŋ, lau nom-ŋga sêŋyalê am dom. Tigeŋ aö kayalê am, ma lau dindec sêŋyalê bu am kêkiŋ aö gameŋ. ");
INSERT INTO buk_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Aö gatôc am asê têŋ ŋac, ma watôc am asê ŋapaŋ. Ma tu dinaŋ-ŋga dec am nem atac whiŋ aö-ŋga oc yêc ŋac si ŋalôm. Ma aö dauŋ oc wambo ŋac si ŋalôm wawhiŋ.” ");
INSERT INTO buk_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yisu teŋ mbec dau pacndê, goc iŋ ti ndê ŋgacsêŋomi sêhu Jerusalem siŋ, ma sêpi Busuŋ Kidron-ŋga ŋadaŋga si. Ma sêsôc ôm †olib-ŋga daŋ naŋ yêc dinaŋ. ");
INSERT INTO buk_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, ŋgac naŋ hoc Yisu asê, naŋ kêyalê ôm dinaŋ, bu ndoc daêsam Yisu ti ŋgacsêŋomi sêkac sa sêmbo dindê. ");
INSERT INTO buk_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Bocdinaŋ têŋ ôbwêc dinaŋ iŋ kêkuc ŋac, ma sa têŋ ôm dau gi. Iŋ wê lau siŋ Rom-ŋga toŋ daŋ ma lau siŋ-ŋga lôm dabuŋ-ŋga ŋatô naŋ dabuŋsiga atu-tu ti lau Palêsai sêŋkiŋ. Ŋac sêŋsêlêŋ ti sêhôc daweŋ ti lam, ma wapa siŋ-ŋga, ma sêhôc asê ôm dinaŋ. ");
INSERT INTO buk_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yisu kêyalê gêŋ hoŋ naŋ oc hôc asê iŋ, goc sa gi ma ndac ŋac bu, “Mac aŋsalê asa?” ");
INSERT INTO buk_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ma ŋac sêsôm, “Yac aŋsalê Yisu Nasaret-ŋga.” Dec Yisu sôm, “Aö dauŋ dindec.” (Têŋ ndoc dinaŋ, Judas, ŋgac hoc iŋ asê-ŋga, kalhac whiŋ lau dinaŋ.) ");
INSERT INTO buk_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Têŋ ndoc ŋac sêŋgô Yisu ndê yom bu, “Aö dauŋ dindec,” goc ŋac hoŋ sêyu dau su ma sêpeŋ sêsip nom si. ");
INSERT INTO buk_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ma iŋ ndac tiyham, “Mac aŋsalê asa?” Ma sêsôm, “Yisu Nasaret-ŋga.” ");
INSERT INTO buk_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Goc iŋ ô yom ma sôm, “Aö gasôm su, bu aö dauŋ dindec. Mac asôm bu mac aŋsalê aö, ma bocdinaŋ atec aneŋ lau dindec sêlhö sêndi.” ");
INSERT INTO buk_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yisu sôm yom dau tu bu nem iŋ ndê ŋgacsêŋomi si-ŋga. Ma tu dinaŋ-ŋga yom naŋ iŋ sôm muŋ su bocdec bu, “Aö oc wayob ŋamalac hoŋ naŋ Damaŋ kêŋ têŋ aö, bu ŋac si daŋ niŋga dom,” naŋ dec ŋandô sa. ");
INSERT INTO buk_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Pita kôc iŋ ndê bieŋ baliŋ sa, ma pa dabuŋsiga ŋamata-ŋga ndê ŋgac akiŋ ndê daŋgalauŋ andô-ŋga su. Ŋgac akiŋ dau ndê ŋaê Malkus. ");
INSERT INTO buk_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Magoc Yisu sôm têŋ Pita, “Kêŋ nem bieŋ mbu sip ŋapaŋ ndi. Damaŋ kêŋ laclhu ŋawapac-ŋga dindec têŋ aö, ma aö gac waê bu wanôm.” ");
INSERT INTO buk_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Goc ŋgac bata siŋ-ŋga ti ndê lau siŋ, ma lau siŋ sêyob lôm dabuŋ-ŋga naŋ lau bata Israel-ŋga sêŋkiŋ, naŋ sêkôc Yisu ma sêsô iŋ amba dôŋ. ");
INSERT INTO buk_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Goc sêwê iŋ sêtêŋ Kayapas lawa Anas ndê andu si. Kayapas, iŋ lau Israel si dabuŋsiga ŋamata-ŋga têŋ têm dinaŋ. ");
INSERT INTO buk_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Iŋ ŋgac naŋ muŋ-ŋga sôm asê têŋ lau bata Israel-ŋga, bu oc ŋayham bu ŋgac tigeŋ mbac ndu ô lau hoŋ. ");
INSERT INTO buk_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Sêwê Yisu sêtêŋ dabuŋsiga ŋamata-ŋga ndê andu, ma sêsôc tuŋlôm naŋ kêgihi andu dau, naŋ si. Ma Saimon Pita lu ŋgacsêŋom daŋ sêŋkuc. Ŋgacsêŋom dau dabuŋsiga ŋamata-ŋga kêyalê iŋ tidôŋ, ma bocdinaŋ dec iŋ kêkuc Yisu ma gacgeŋ sôc tuŋlôm dau gi. ");
INSERT INTO buk_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Magoc Pita sôc gi dom, iŋ kalhac awê kêpiŋ gatam. Dec ŋgacsêŋom naŋ dabuŋsiga ŋamata-ŋga kêyalê, naŋ mbu gi ma sôm yom pi Pita whiŋ awhê akiŋ naŋ yob gatam, goc kôc Pita sôc gi. ");
INSERT INTO buk_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ma awhê akiŋ dinaŋ ndac Pita bocdec, “Ma bocke? Am Yisu ndê ŋgacsêŋom daŋ whiŋ, a?” Magoc Pita pa dau ma sôm, “Mba! Aö dom!” ");
INSERT INTO buk_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Têŋ ôbwêc dinaŋ gameŋ ŋalhuc sa, dec lau akiŋ ti lau siŋ lôm dabuŋ-ŋga sêkôm ya golom asê goc sêlhac sêŋgihi ma sêŋsulu. Ma Pita gi kalhac whiŋ ŋac ma kêsulu ya. ");
INSERT INTO buk_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","T êŋ dinaŋ, dabuŋsiga ŋamata-ŋga Anas kêsu Yisu pi iŋ ndê sêŋomi, ma pi yom naŋ iŋ kêdôhôŋ têŋ lau. ");
INSERT INTO buk_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ma Yisu sôm, “Aö gasôm aneŋ yom hoŋ yêc awê. Aö kadôhôŋ lau gambo ŋac si lôm wê-ŋga ma yêc lôm dabuŋ Jerusalem-ŋga, gameŋ naŋ lau Israel-ŋga hoŋ êlêmê sêkac dau sa sêmbo naŋ. Ma aö gasêc yom daŋ ahuc dom. ");
INSERT INTO buk_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Bocdinaŋ tu sake-ŋga am kêsu aö? Ndac lau naŋ sêŋgô aneŋ yom. Ŋac hoŋ sêŋyalê yom naŋ aö gasôm.” ");
INSERT INTO buk_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Têŋ ndoc Yisu sôm yom dinaŋ, goc ŋgac siŋ lôm dabuŋ-ŋga naŋ kalhac kêpiŋ iŋ, naŋ tap iŋ sip ali andô ma sôm, “Toc dabuŋsiga atu sa, ma ô iŋ ndê yom bocdinaŋ dom!” ");
INSERT INTO buk_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Dec Yisu sôm, “Yom naŋ aö gasôm, naŋ bu yom so, naŋ goc sôm têŋ aö. Magoc aö gasôm yom so daŋ dom, ma tu sake-ŋga dec am tap aö?” ");
INSERT INTO buk_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Têŋ dinaŋ Anas kêkiŋ Yisu têŋ dabuŋsiga ŋamata-ŋga Kayapas gi. Ma wac naŋ sêsô iŋ amba dôŋ, naŋ gacgeŋ yêc. ");
INSERT INTO buk_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita kêsulu ya mbo, ma ŋamalac daŋ ndac iŋ, “Am ŋgac dau ndê ŋgacsêŋom daŋ, me?” Ma Pita pa dau ma sôm, “Mba!” ");
INSERT INTO buk_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Dabuŋsiga ŋamata-ŋga ndê ŋgac akiŋ daŋ mbo gameŋ dinaŋ. Iŋ ŋgac naŋ Pita pa iŋ ndê daŋgalauŋ su, naŋ ndê têŋgac. Ma iŋ sôm têŋ Pita, “Ma bocke? Aö galic am kalhac whiŋ ŋgac dinaŋ yêc ôm olib-ŋga. Yomandô, me?” ");
INSERT INTO buk_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Magoc Pita pa dau tiyham, ma ŋagahô eŋ dalec daŋ gic hu taŋ. ");
INSERT INTO buk_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ôbwêc pacndê, ma têŋ bêbêc ganduc lau bata Israel-ŋga sêhu Kayapas ndê andu siŋ ma sêwê Yisu sêtêŋ gôliŋwaga Rom-ŋga ndê andu si. Lau bata Israel-ŋga dinaŋ sêsôc andu dau dom, sêtöc dau ma gauc gêm bu oc kôm ŋac ŋadômbwi sa yêc Anötö aŋgô-ŋga, dec oc tôm dom bu sêneŋ Mwasiŋ Pasowa-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Bocdinaŋ Pailot, ŋgac naŋ gêm gôliŋ gameŋ Judia-ŋga sa têŋ ŋac gi, ma ndac ŋac, “Mac asôm bu ŋgac dindec kôm giso bocke?” ");
INSERT INTO buk_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ma sêô yom ma sêsôm, “Iŋ bu ndê giso mbasi, dec yac oc akôc iŋ atêŋ am ameŋ lec dom.” ");
INSERT INTO buk_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Dec Pailot sôm, “Mac daôm akôc iŋ sa andi, ma amatôc iŋ êŋkuc mac daôm nem yomsu.” Magoc ŋac sêsôm, “Mba! Bu mac lau Rom-ŋga akêŋ yao bu yac lau Israel-ŋga andic ŋamalac daŋ ndu dom.” ");
INSERT INTO buk_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ŋalêŋ dinaŋ dec Yisu ndê yom pi lêŋ naŋ iŋ oc mbac ndu, naŋ ŋandô sa. ");
INSERT INTO buk_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Têŋ dinaŋ Pailot hu ŋac siŋ ma sôc andu gi, goc ta Yisu sôc gi ma ndac iŋ, “Am lau Israel-ŋga si Kiŋ, a?” ");
INSERT INTO buk_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ma Yisu ô yom bocdec bu, “Am sôm yom dinaŋ tôm am daôm nem gauc, me lau ŋatô sêsôm yom dau pi aö?” ");
INSERT INTO buk_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ma Pailot sôm, “Aö ŋgac Israel-ŋga dom! Am daôm nem lau ti dabuŋsiga atu-tu Israel-ŋga sêkêŋ am têŋ aö mweŋ. Am kôm gêŋ giso bocke?” ");
INSERT INTO buk_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Dec Yisu sôm, “Aneŋ gôliŋ kiŋ-ŋga gitôm kiŋ nom dindec-ŋga si gôliŋ dom. Aö bu wanem gôliŋ gameŋ nom-ŋga daŋ, dec oc tôm bu aneŋ lau akiŋ sêyob aö ma sêndic siŋ bu lau bata Israel-ŋga sêkôc aö dôŋ dom. Magoc aö neŋ gôliŋ ŋahu yêc nom dindec dom.” ");
INSERT INTO buk_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Goc Pailot sôm, “Bocdinaŋ, am sôm bu am kiŋ daŋ, a?” Ma Yisu sôm, “Am daôm sôm bu aö kiŋ daŋ. Aneŋ dinaŋ kôc aö, ma aö gahôc asê nom tu gêŋ tigeŋ-ŋga, naŋ tu wahoc yom ŋandô asê-ŋga. Ma lau hoŋ naŋ atac whiŋ yom ŋandô, naŋ sêkôc aneŋ yom sa.” ");
INSERT INTO buk_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailot ŋgô yom dau goc ndac, “Ma yom bocke iŋ yom ŋandô?” Iŋ sôm yom dinaŋ su, goc sa têŋ lau bata Israel-ŋga gi, ma sôm tiyham têŋ ŋac, “Aö gatap yom daŋ bu tamatôc iŋ pi-ŋga, naŋ sa dom. ");
INSERT INTO buk_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Magoc mac nem mêtê daŋ yêc, bu wahu gapocwalô daŋ siŋ têŋ mac têŋ Mwasiŋ Pasowa-ŋga ŋandoc. Mac atac whiŋ bu aö wahu ŋgac dindec, naŋ sêsam bu Kiŋ Israel-ŋga, naŋ siŋ têŋ mac, me mba?” ");
INSERT INTO buk_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Magoc sêmbwêc, “Mba! Iŋ dom! Hu Barabas siŋ têŋ yac.” Barabas iŋ lau naŋ sêŋgilí siŋ têŋ lau Rom-ŋga, naŋ si daŋ. ");
INSERT INTO buk_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Goc Pailot kêŋ Yisu têŋ lau siŋ-ŋga bu sêhi iŋ ŋa sö. ");
INSERT INTO buk_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ma sêŋsau bu sêtoc iŋ sa. Sêwhê wac kêm ma sêkêŋ iŋ uŋ gitôm suŋsuŋ, ma sêkêŋ iŋ sôc ŋakwê kokoc gitôm kiŋ si ŋakwê. ");
INSERT INTO buk_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Goc sêsôc sêsa sêlhac iŋ aŋgô-ŋga ma sêmbwêc, “Ei! Datoc lau Israel si Kiŋ dindec sa maŋ!” Ma sêtap iŋ sip ali andô. ");
INSERT INTO buk_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ma Pailot sa meŋ tiyham ma sôm têŋ lau bata bu, “Aŋgô su naŋ! Aö neŋ lau siŋ-ŋga oc sêkôc iŋ sa têŋ mac meŋ. Ma bocdinaŋ dec aŋyalê bu aö gatap yom daŋ sa pi iŋ dom.” ");
INSERT INTO buk_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Goc sêkôc Yisu sa meŋ, ti suŋsuŋ wac kêm ma ŋakwê kokoc. Ma Pailot sôm, “Alic ŋgac dau dec.” ");
INSERT INTO buk_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Têŋ ndoc dabuŋsiga atu-tu ma lau siŋ lôm dabuŋ-ŋga sêlic iŋ, naŋ sêmbwêc, “Ndic iŋ pi a gicso dau! Ndic iŋ pi a!” Magoc Pailot sôm, “Mba! Aö gatap yom daŋ sa pi iŋ dom. Mac daôm akôc iŋ sa andi ma andic iŋ pi a.” ");
INSERT INTO buk_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ma lau bata Israel-ŋga sêsôm, “Iŋ toc dau sa ma sam dau bu Anötö ndê Atu! Ma tu yom sac dinaŋ-ŋga, yac mba yomsu sôm bu iŋ mbac ndu maŋ.” ");
INSERT INTO buk_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailot ŋgô yom dinaŋ ma töc dau ŋandô. ");
INSERT INTO buk_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Goc iŋ kôc Yisu mbu sôc andu ŋalôm gi, ma ndac iŋ, “Am mweŋ akêŋ nde?” Magoc Yisu gêm dôŋ. ");
INSERT INTO buk_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ma Pailot sôm têŋ iŋ, “Bocke am ô aneŋ yom dom? Aneŋ ŋaclai yêc bu waŋgapwêc am su, me bu wandic am pi a gicso dau ndi. Am kêyalê, a?” ");
INSERT INTO buk_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Dec Yisu ô yom ma sôm, “Anötö bu kêŋ têŋ am dom, dec am oc tôm dom bu kôm gêŋ daŋ têŋ aö. Bocdinaŋ dabuŋsiga naŋ kêŋ aö gasip am amam, naŋ kôm giso hôc gêlêc am nem su.” ");
INSERT INTO buk_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailot ŋgô yom dinaŋ, dec kêsalê lêŋ bu hu Yisu siŋ. Magoc lau bata Israel-ŋga sêmbwêc ŋapaŋ ma sêsôm, “Asa naŋ toc dau sa bu iŋ kiŋ daŋ, naŋ kôm bu hôc gêlêc Sisa, lau Rom-ŋga si kiŋ. Bocdinaŋ am bu hu ŋgac dindec siŋ, naŋ am Sisa ndê silip dom.” ");
INSERT INTO buk_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","14","Bêc dinaŋ iŋ bêc lau Israel-ŋga sêmasaŋ Mwasiŋ Pasowa-ŋga, ma ac kalhac lhu su. Têŋ ndoc Pailot ŋgô lau bata Israel-ŋga si yom dinaŋ, naŋ dec iŋ kôc Yisu sa awê têŋ gameŋ naŋ sêsam bu Seŋ Hoc naŋ gi. (Yêc Yom †Hibru sêsam gameŋ dau bu Gabata.) Yêc dinaŋ, Pailot ndöc sic ndöc iŋ ndê pôŋ êmatôc yom-ŋga, ma sôm têŋ lau bata Israel-ŋga bu, “Alic mac nem kiŋ dindec!” ");
INSERT INTO buk_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tigeŋ ŋac sêmbwêc, “Kôc iŋ sa ndi! Kôc iŋ sa ndi! Ndic iŋ pi a gicso dau!” Dec Pailot ndac, “Mac atac whiŋ bu aö wandic nem Kiŋ pi a gicso dau ndi, a?” Ma dabuŋsiga atu-tu sêô yom ma sêsôm, “Iŋ yac mba kiŋ dom! Sisa tigeŋ iŋ yac mba kiŋ.” ");
INSERT INTO buk_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Têŋ dinaŋ Pailot sôc ŋac si yom ŋapu, ma kêŋ Yisu têŋ ŋac bu lau siŋ-ŋga sêndic iŋ pi a gicso dau ndi. ");
INSERT INTO buk_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Sêkêŋ Yisu hôc dau ndê a gicso dau, ma sêwê iŋ sêsa gameŋ naŋ sêsam bu Gameŋ Ŋakêcyha-ŋga si. Yêc Yom Hibru sêsam gameŋ dau bu Golgota. ");
INSERT INTO buk_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ma yêc dinaŋ, ŋac sic iŋ pi a gicso dau gi. Ma ŋac sic ŋgac lu sêpi a sêwhiŋ, daŋ kêgalêŋ andô-ŋga ma daŋ kêgalêŋ gasê-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailot sôm bu sêto yom pi bapia daŋ ma sêndic pi a gicso dau ŋahô-ŋga. Bapia dau sôm, “Yisu Nasaret-ŋga. Lau Israel-ŋga si Kiŋ.” ");
INSERT INTO buk_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Sêto yom dau ŋa lau Israel, ti lau Rom-ŋga ma lau Grik-ŋga si awha. Gameŋ dinaŋ yêc suŋ sa têŋ malac Jerusalem, dec lau Israel-ŋga daêsam sêlic bapia dau. ");
INSERT INTO buk_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Boc-dinaŋ dabuŋsiga atu-tu Israel-ŋga sêtucdiŋ ma sêsôm têŋ Pailot, “Am to, ‘Lau Israel-ŋga si Kiŋ,’ ma yac alic yham dom! Am bu to, ‘Ŋgac dindec sam dau bu lau Israel-ŋga si kiŋ,’ dec oc solop.” ");
INSERT INTO buk_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Magoc iŋ ô yom ma sôm, “Aö gato yom dinaŋ, ma oc yêc bocdinaŋ.” ");
INSERT INTO buk_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Têŋ ndoc lau siŋ-ŋga sic Yisu pi a gicso dau, naŋ sêkôc iŋ ndê ŋakwê su. Ŋac lau hale, ma sêwhê ŋakwê awê-ŋga kôc gi toŋ hale, ma sêkôc sa tôm gi. Magoc ŋac sic sam iŋ ndê ŋakwê ŋalôm-ŋga dom. Ŋakwê dau ŋayham andô, sêsê dom, sêwhê sambuc ti po baliŋ yêc ŋasu ma sip têŋ gahi. ");
INSERT INTO buk_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Bocdinaŋ lau siŋ-ŋga sêsôm têŋ dandi, “Dakêc po dau kic dom. Dapuc gapoc ma yac neŋ daŋ kôc po sambuc.” Ŋac sêkôm bocdinaŋ, dec yom daŋ naŋ sêto yêc, naŋ ŋandô sa. Yom dau bocdec bu: Ŋac sêwhê aneŋ ŋakwê kôc têŋ dandi, ma sêpuc gapoc tu aneŋ ŋakwê-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Têŋ ndoc dinaŋ Yisu dinda lu asiwê daŋ, ma Klopas ndê awhê Maria lu Maria Magadala sêlhac sêmpiŋ a gicso dau. ");
INSERT INTO buk_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ma Yisu gêlic iŋ dinda kalhac whiŋ ŋgac-sêŋom naŋ iŋ atac whiŋ ŋandô, dec iŋ sôm têŋ dinda, “O dinaŋ. Lic nem atômŋgac dinaŋ.” ");
INSERT INTO buk_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ma iŋ sôm têŋ ŋgacsêŋom dau bu, “Lic am dinam dinaŋ.” Ma têŋ bêc dinaŋ ma gi, ŋgacsêŋom dau kôc Yisu dinda sa ndöc iŋ ndê andu. ");
INSERT INTO buk_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yisu kêyalê bu iŋ gic dabiŋ gêŋ hoŋ su. Ma tu yom daŋ naŋ sêto yêc, naŋ ŋandô sa-ŋga, dec iŋ sôm, “Aö bu yô aö.” ");
INSERT INTO buk_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Lôŋ wain ŋamakic-ŋga daŋ kalhac gameŋ dinaŋ, ma ŋgac siŋ-ŋga daŋ kôc sôwam daŋ ma kêŋ sip wain. Goc iŋ sô pi a baliŋ daŋ, ma hôc sa pi têŋ Yisu whasuŋ gi. ");
INSERT INTO buk_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Iŋ nôm su ma sôm, “Aö neŋ gweleŋ hoŋ pacndê su.” Goc iŋ wec, ma mbac ndu. ");
INSERT INTO buk_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Têŋ bêc dinaŋ lau Israel-ŋga sêmasaŋ dau tu bêc Sabat-ŋga, ma Sabat laŋsê-ŋga iŋ ŋac si om atu daŋ. Ŋac sêtec bu lau batê sêŋgalêŋ a gicso dau têŋ bêc atu dinaŋ, boc-dinaŋ dec lau bata sêndac Pailot bu lau siŋ-ŋga sêtuc lau dau si gahi dulu tu bu sêmbac ndu ŋagahô-ŋga, goc sêkôc ŋac si ŋamlaŋ su ma sêŋsuhuŋ. ");
INSERT INTO buk_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pailot gôlôc su, dec lau siŋ-ŋga sêtêŋ ŋgac daŋ naŋ sic pi a gicso dau whiŋ Yisu naŋ si, ma sêtuc iŋ gahi dulu. Goc ŋac sêtuc ŋgac tilu-ŋga gahi dulu boc-dinaŋ. ");
INSERT INTO buk_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tigeŋ têŋ têm sêtêŋ Yisu si, naŋ sêlic bu iŋ mbac ndu su, dec sic iŋ gahi dulu dom. ");
INSERT INTO buk_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Magoc ŋgac siŋ-ŋga daŋ kôc iŋ ndê kêm ma kuŋ Yisu sip ŋabi, ma ŋagahô dac ti bu kêc sa meŋ. ");
INSERT INTO buk_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Ŋgac naŋ gêlic gêŋ hoŋ dinaŋ su, naŋ dec sôm asê, ma iŋ ndê yom iŋ yom ŋandô. Iŋ dau kêyalê bu iŋ ndê yom iŋ yom ŋandô, ma iŋ sôm asê bu mac akêŋ whiŋ bocdinaŋ.) ");
INSERT INTO buk_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Gêŋ dinaŋ hôc asê, dec yom lu naŋ sêto yêc, naŋ ŋandô sa. Yom daŋ yêc bocdec bu: Ŋac oc sêtuc iŋ ndê ŋakwa daŋ dulu dom. ");
INSERT INTO buk_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ma yom daŋ tiyham yêc bocdec: Ŋac oc sêlhac ma tahê ŋgac naŋ sêkuŋ iŋ naŋ. ");
INSERT INTO buk_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ŋgac daŋ mbo, naŋ sêsam bu Josep, ma iŋ meŋ akêŋ malac A rimatiya. Iŋ kêŋ whiŋ Yisu, magoc sêc dau ahuc, bu iŋ töc lau bata Israel-ŋga. Têŋ telha dinaŋ iŋ têŋ Pailot gi ma ndac Yisu ndê ŋamlaŋ. Pailot gôlôc, dec Josep sa gi ma kôc Yisu ndê ŋamlaŋ su yêc a gicso dau. ");
INSERT INTO buk_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ma Nikodemas gêm iŋ sa. Nikodemas iŋ ŋgac bata Israel-ŋga naŋ muŋ-ŋga gi gêlic Yisu têŋ ôbwêc daŋ. Iŋ kôc a ŋakwi ti gêŋ ŋamalu naŋ sêŋgaluŋ whiŋ dau su, naŋ gitôm 30 kilogram, ma whiŋ Josep gi. ");
INSERT INTO buk_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Iŋlu sêkôc Yisu ndê ŋamlaŋ, ma sem oso ŋa gêŋ ŋamalu, goc sêhi ahuc ŋa po ŋayham. Sêkôm gêŋ dau kêkuc lau Israel-ŋga si gêbôm sêŋsuhuŋ lau batê-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ôm daŋ yêc suŋ sa têŋ gameŋ naŋ lau siŋ-ŋga sic Yisu pi a gicso dau. Ma sêhô daŋ yêc ôm dau ŋalôm, naŋ lau sêlêŋ gwanaŋ su yêc hoc ŋalôm, ma sêkêŋ ŋgac batê daŋ yêc hoc ŋasuŋ dau muŋ su dom. ");
INSERT INTO buk_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Bocdinaŋ sêŋsuhuŋ Yisu ŋamlaŋ yêc hocsuŋ dinaŋ, ŋahu bu bêc dinaŋ iŋ bêc lau Israel-ŋga sêmasaŋ dau tu Sabat-ŋga, ma hocsuŋ dau yêc kêpiŋ. ");
INSERT INTO buk_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Bêc Sabat-ŋga meŋ gi su, ma têŋ wake ŋabêc ŋamata-ŋga Maria Magadala tisa têŋ bêbêc ganduc, ma sa têŋ sêhô gi. Iŋ gêlic bu hoc atu naŋ sêkêŋ ndöc sê awha, naŋ ndöc ŋamala dom. ");
INSERT INTO buk_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Goc iŋ kêti mbu têŋ Saimon Pita lu ŋgacsêŋom naŋ Yisu atac whiŋ ŋandô, naŋ gi, ma sôm têŋ iŋlu, “Oyaê! Ŋac sêkôc Pômdau ndê ŋamlaŋ su yêc sêhô, ma yac am gauc gameŋ naŋ sêkêŋ iŋ yêc.” ");
INSERT INTO buk_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Goc Pita lu ŋgacsêŋom dinaŋ sêti bu sêtêŋ sêhô sêndi. ");
INSERT INTO buk_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Iŋlu sênti si, ma ŋgacsêŋom dinaŋ hôc gêlêc Pita su ma hôc asê muŋ. ");
INSERT INTO buk_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Iŋ sôc gi dom, magoc iŋ wec ma tôc gwaniŋ, ma gêlic po naŋ sêhi pi Yisu ndê ŋamlaŋ, naŋ yêc ŋamala. ");
INSERT INTO buk_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimon Pita kêkuc meŋ hôc asê ma gacgeŋ sôc hocsuŋ dau ŋalôm gi. Iŋ gêlic po naŋ yêc, ");
INSERT INTO buk_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ma po naŋ sêhi pi Yisu ŋagôlôŋ. Po dinaŋ yêc dau-ŋga, magoc yêc bambaliŋ dom, yêc gitôm sêtip sa ŋapep. ");
INSERT INTO buk_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Goc ŋgac-sêŋom naŋ hôc asê sêhô muŋ, naŋ sôc gi whiŋ. Iŋ gêlic po ŋambwa, dec kêŋ whiŋ bu Yisu tisa su yomandô. ");
INSERT INTO buk_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Muŋ-ŋga e meŋ têŋ têm dinaŋ, naŋ ŋac si gauc sa dom pi yom hoŋ naŋ sêto yêc bu Yisu oc tisa akêŋ lau batê-ŋga.) ");
INSERT INTO buk_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Dinaŋ su ma ŋgacsêŋom lu dinaŋ sêlhö sêmbu sêtêŋ si andu si. ");
INSERT INTO buk_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Magoc Maria Magadala naŋ mbu meŋ su, naŋ gacgeŋ kalhac sêhô ŋamakê ma taŋ. Iŋ wec bu tôc gwaniŋ sêhô ŋalôm, ");
INSERT INTO buk_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ma iŋ gêlic aŋela lu ti ŋakwê sêsêp sêndöc gameŋ naŋ muŋ-ŋga Yisu yêc, daŋ ndöc ŋagôlôŋ-ŋga, ma daŋ ndöc gahi-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ma sêndac iŋ, “O awhê! Am taŋ tu sake-ŋga?” Ma iŋ ô yom ma sôm, “Lau sêkôc aneŋ Pômdau ndê ŋamlaŋ su, ma aö gam gauc gameŋ naŋ sêkêŋ iŋ yêc naŋ.” ");
INSERT INTO buk_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Iŋ sôm yom dinaŋ su, dec tagêlic ma gêlic Yisu, magoc kêyalê dom bu iŋ Yisu. ");
INSERT INTO buk_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ma Yisu sôm, “Awhê! Am taŋ tu sake-ŋga? Am kêsalê asa?” Maria gauc gêm bu iŋ ŋgac naŋ yob ôm dau, dec sôm, “O ŋadau, am bu kôc iŋ ndê ŋamlaŋ su, goc sôm asê têŋ aö bu am kêŋ iŋ yêc gameŋ bocke, ma yac oc andi akôc iŋ sa.” ");
INSERT INTO buk_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Têŋ dinaŋ Yisu sôm têŋ iŋ, “Maria.” Goc Maria kac dau kwi ma mbwêc ŋa Yom Hibru, “Raboni!” (Yom dau danem kwi bu ‘Kêdôhôŋwaga.’ ) ");
INSERT INTO buk_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iŋ kêgape Yisu dôŋ ŋaŋga, magoc iŋ sôm, “Am êmasec aö ŋapaŋ dom, bu aö gatêŋ Damaŋ ga su dom. Magoc am mbu ndi, ma sôm têŋ aneŋ asidôwai bu aö oc wambu watêŋ aneŋ Damaŋ, ma mac nem Damam. Iŋ aö neŋ Anötö, ma mac nem Anötö.” ");
INSERT INTO buk_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","G oc Maria Magadala kölhö têŋ Yisu ndê sêŋomi gi, ma sôm têŋ ŋac bu, “Pômdau tisa ma aö galic iŋ su!” Ma yom hoŋ naŋ Yisu sôm têŋ iŋ, naŋ iŋ gic miŋ têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Têŋ wake ŋabêc ŋamata-ŋga dinaŋ ŋaôbwêc, sêŋomi sêmbo andu daŋ ŋalôm sêwhiŋ dau. Ŋac sic gatam ahuc ŋaŋga, bu sêtöc lau bata Israel-ŋga. Sêmbo dinaŋ, ma Yisu hoc dau asê kalhac ŋac ŋalhu, ma sôm, “Yom malô whiŋ mac!” ");
INSERT INTO buk_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Iŋ sôm yom dinaŋ su, goc tôc iŋ amba ma ŋabi têŋ ŋac sêlic. Ma ŋac hoŋ atac ŋayham atu tu sêlic Pômdau-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ma iŋ sôm tiyham, “Yom malô whiŋ mac! Tôm Damaŋ kêkiŋ aö gasip nom gameŋ, naŋ kwahic dec waŋkiŋ mac asa andi.” ");
INSERT INTO buk_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Dec iŋ yu wayahô pi ŋac ma sôm, “Akôc Ŋalau Dabuŋ sa loc. ");
INSERT INTO buk_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Aö wakêŋ ŋaclai têŋ mac bu asuc ŋamalac si sac kwi. Ŋac naŋ mac asuc ŋac si sac kwi, naŋ Anötö suc ŋac si sac kwi bocdinaŋ. Ma ŋac naŋ mac asuc si sac kwi dom, naŋ si sac oc gacgeŋ yêc ŋac-ŋga.” ");
INSERT INTO buk_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Têŋ ndoc ŋamata-ŋga naŋ Yisu hoc dau asê têŋ iŋ ndê sêŋomi, naŋ Tomas mbo whiŋ ŋac dom. Iŋ ŋgacsêŋomi 12 si daŋ naŋ sêsam bu Lôcmpôŋ. ");
INSERT INTO buk_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tiŋambu sêŋomi ŋatô sêsôm têŋ iŋ bu, “Yac alic Pômdau su!” Magoc iŋ sôm, “Aö gakêŋ whiŋ dom! Aö bu walic bôlêm ŋamala yêc iŋ amba, ma wakêŋ aö amaŋatu sip ŋamala dau, ma sôc kêm ŋamala yêc iŋ ŋabi, dec aö oc wakêŋ whiŋ.” ");
INSERT INTO buk_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wake daŋ giŋga su, ma Yisu ndê sêŋomi sêmbo andu dau tiyham, ma Tomas mbo whiŋ ŋac. Ŋac sic gatam ahuc ŋaŋga sa, magoc Yisu meŋ kalhac ŋac ŋalhu. Ma iŋ sôm, “Yom malô whiŋ mac!” ");
INSERT INTO buk_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ma iŋ sôm têŋ Tomas, “Lic aö amaŋ, ma kêŋ amam-atu sip dec, ma kêŋ amam-atu sôc aneŋ ŋabi. Hu nem atac lu-lu siŋ, ma kêŋ whiŋ.” ");
INSERT INTO buk_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Dec Tomas sôm, “Aneŋ Pômdau, ma aneŋ Anötö am!” ");
INSERT INTO buk_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Goc Yisu sôm têŋ iŋ, “Am gêlic aö su, dec kêŋ whiŋ. Aö awhaŋ hôc lau naŋ sêlic pi tandô dom, magoc sêkêŋ whiŋ, bu ŋac oc sêtap Anötö ndê mwasiŋ sa.” ");
INSERT INTO buk_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yisu kôm gêŋ dalô daêsam yêc iŋ ndê sêŋomi aŋgô-ŋga, naŋ ŋamiŋ yêc bapia dindec dom. ");
INSERT INTO buk_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Magoc yom pi gêŋ dalô naŋ sêto sip bapia dindec, naŋ yêc tu bu mac asam ma akêŋ whiŋ bu Yisu iŋ Mesaya, Anötö ndê Atu. Ma tu mac akêŋ whiŋ iŋ ndê ŋaê-ŋga, dec mac oc atap seŋ ambo tamli-ŋga sa. ");
INSERT INTO buk_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tiŋambu Yisu hoc dau asê têŋ ŋgacsêŋomi tiyham, yêc Bugictoŋ Taibirias ŋamakê. Ma ŋamiŋ dau dindec. ");
INSERT INTO buk_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, ma Tomas naŋ sêsam bu Lôcmpôŋ, Natanael naŋ meŋ akêŋ malac Kana yêc Galili, Sebedi ndê atu lu, ma ŋgacsêŋom lu tiyham sêmbo sêwhiŋ dau. ");
INSERT INTO buk_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ma Pita sôm têŋ ŋac, “Aö bu wasa wandi wakôc i.” Ma ŋac sêsôm, “Ayôc, yac awhiŋ am daloc.” Bocdinaŋ ŋac hoŋ sêpi waŋ daŋ ma sêsa si bu sêkêŋ wasaŋ. Magoc têŋ ôbwêc dinaŋ, sêkôc i daŋ dom. ");
INSERT INTO buk_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Têŋ bêbêc ganduc Yisu kalhac baö, tigeŋ ŋac sêŋyalê dom bu iŋ Yisu. ");
INSERT INTO buk_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ma iŋ hê mwalêc ŋac ma sôm, “Aê mac lau. Mac akôc i ŋatô, me mba?” Ma sêsôm, “Mba!” ");
INSERT INTO buk_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Dec iŋ sôm têŋ ŋac, “Akêŋ wasaŋ sip andô-ŋga, ma mac oc atap i ŋatô sa.” Bocdinaŋ ŋac sêkêŋ wasaŋ sip gi ma sêkôc i daêsam andô, dec gitôm dom bu sêhê sa. ");
INSERT INTO buk_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Têŋ dinaŋ ŋgacsêŋom naŋ Yisu atac whiŋ kêlêc, naŋ sôm têŋ Pita bu, “Kec, Pômdau dau dê.” Saimon Pita ŋgô yom dau, goc ŋagahô iŋ kôc ndê ŋakwê awê-ŋga sa, hi pi dau, ma pwê sip bu gi, ma bu têŋ Yisu ndi. ");
INSERT INTO buk_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Waŋ dau poc kêpiŋ baö, ŋasawa gitôm 90 mita, ma ŋgacsêŋomi ŋatô sêhêc waŋ ma sêhê wasaŋ ti i sêŋkuc Pita. ");
INSERT INTO buk_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ŋac sêhôc asê baö, ma sêlic i sa ya ŋanda, ma bolom ŋatô. ");
INSERT INTO buk_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ma Yisu sôm têŋ ŋac, “Akôc i ŋatô sa yêc wasaŋ ameŋ.” ");
INSERT INTO buk_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Goc Saimon Pita têŋ waŋ gi, kêgapwêc wasaŋ su, goc sêhê pi baö gi. I atu-atu daêsam sêyêc wasaŋ, naŋ sêsê sa gitôm 153, magoc wasaŋ dau kic dom. ");
INSERT INTO buk_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ŋac hoŋ sêtöc bu sêndac iŋ bu, “Am asa?” Magoc yêc ŋac si ŋalôm sêŋyalê bu iŋ Pômdau. Ma Yisu sôm, “Ameŋ ma aneŋ gêŋ bêbêc-ŋga.” ");
INSERT INTO buk_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Dec iŋ kêsêlêŋ gi ma kôc i ti bolom sa, ma kêŋ têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Dinaŋ ti têm titö-ŋga naŋ Yisu hoc dau asê têŋ ndê ŋgacsêŋomi têŋ ndoc Anötö uŋ iŋ sa akêŋ lau batê-ŋga. ");
INSERT INTO buk_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ŋac seŋ gêŋ pacndê, goc Yisu sôm têŋ Saimon Pita, “Saimon, Jon ndê atu. Am tac whiŋ aö ŋandô, hôc gêlêc lau dindec si atac whiŋ aö su, me?” Ma iŋ sôm, “Aêc Pômdau! Am kêyalê bu aö atac whiŋ am.” Dec Yisu sôm, “Bocdinaŋ lôm aneŋ domba.” ");
INSERT INTO buk_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ma Yisu ndac iŋ tiyham bu, “Saimon, Jon ndê atu, am tac whiŋ aö ŋandô, me?” Ma iŋ ô yom ma sôm, “Aêc Pômdau, am kêyalê bu aö atac whiŋ am.” Dec Yisu sôm, “Yob aneŋ domba.” ");
INSERT INTO buk_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ma iŋ ndac tidim titö-ŋga, “Saimon, Jon ndê atu, am tac whiŋ aö ŋandô, me?” Pita ndê ŋalôm ŋawapac bu Yisu ndac yom tigeŋ dinaŋ têŋ iŋ tidim tö, ma iŋ sôm, “Pômdau, am kêyalê gêŋ hoŋ. Am kêyalê bu aö atac whiŋ am kêlêc.” Goc Yisu sôm, “Lôm aneŋ domba. ");
INSERT INTO buk_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Aö wasôm yom ŋandô têŋ am. Têŋ ndoc am mbo balê, naŋ am kêmasaŋ daôm, ma kêsêlêŋ têŋ gameŋ bocke naŋ am daôm atac whiŋ bu ndi. Tigeŋ tiŋambu, têŋ ndoc am ti ŋamalac andô, naŋ am oc êmatôc amam, ma lau daŋ oc sêsô am nem piŋkap dôŋ, ma sêwê am têŋ gameŋ naŋ am atac whiŋ dom bu ndi-ŋga naŋ.” ");
INSERT INTO buk_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yisu sôm yom dinaŋ gwanaŋ pi Pita ndê mbac ndu ŋalêŋ, naŋ oc po Anötö ndê waê sa. Ma Yisu gic têku yom ma sôm, “Êmkuc aö!” ");
INSERT INTO buk_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Têŋ dinaŋ Pita kac dau kwi ma gêlic ŋgacsêŋom naŋ Yisu atac whiŋ iŋ ŋandô, naŋ kêkuc iŋlu. (Iŋ ŋgac dinaŋ têŋ ndoc ŋac seŋ Pasowa, naŋ ndöc gi paŋ Pômdau, ma ndac iŋ bu asa oc hoc iŋ asê.) ");
INSERT INTO buk_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Têŋ ndoc Pita gêlic iŋ, naŋ goc iŋ ndac Yisu, “Pômdau, ŋgac dê oc bocke?” ");
INSERT INTO buk_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ma Yisu ô yom ma sôm, “Am êmkuc aö ma hêgo daôm pi iŋ dom. Aö bu wakêŋ iŋ mbo tali e wambu wameŋ, naŋ aö neŋ gêŋ.” ");
INSERT INTO buk_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tiŋambu sêŋomi ŋatô sêŋgô yom dau ŋawaê, ma ŋatô gauc gêm bu ŋgacsêŋom dinaŋ oc mbac ndu dom. Magoc Yisu ndê yom hêganôŋ ŋgacsêŋom dau mbo tali-ŋga lec dom. Iŋ sôm bu, “Aö bu wakêŋ iŋ mbo tali e wambu wameŋ, naŋ aö neŋ gêŋ.” ");
INSERT INTO buk_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Iŋ ŋgacsêŋom dau dinaŋ dec hoc yom hoŋ dindec asê, ma to sip bapia dindec. Ma yac aŋyalê bu iŋ ndê yom iŋ yom ŋandô eŋ. ");
INSERT INTO buk_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yisu kôm gêŋ daêsam ma daêsam andô naŋ ŋamiŋ yêc bapia dindec dom. Yac bu aŋsahê bu ato yom sip bapia, pi gêŋ hoŋ naŋ Yisu kôm, mboe yom dau oc nem bapia nom-ŋga hoŋ ahuc. ");
INSERT INTO buk_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O Tiopilas, yêc aneŋ buku ŋamata-ŋga aö gato yom pi gêŋ hoŋ naŋ Yisu gic hu bu kôm ti kêdôhôŋ têŋ lau. ");
INSERT INTO buk_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","Aneŋ yom naŋ gato, naŋ meŋ têŋ bêc naŋ Anötö kôc iŋ su pi undambê gi. Iŋ hôc ŋandê ma mbac ndu su, ma tiŋambu tisa ma hoc dau asê têŋ lau †aposel naŋ iŋ kêyaliŋ ŋac sa su. Tôm bêc 40 iŋ mbo whiŋ ŋac ma tôc dau têŋ ŋac sêlic, e sêŋyalê pi ŋandô bu iŋ tisa ma mbo tali tiyham yom ŋandô. Têŋ ŋasawa dinaŋ Yisu whê yom sa têŋ ŋac pi †Anötö ndê gôliŋ ma pi gweleŋ naŋ bu sêkôm-ŋga, ma Ŋalau Dabuŋ puŋ yom dau dôŋ yêc ŋac si ŋalôm. ");
INSERT INTO buk_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Têŋ bêc daŋ iŋ gêŋ gêŋ mbo whiŋ ŋac, ma iŋ kêŋ yatu ŋac bocdec bu, “Mac ahu Jerusalem siŋ dom, magoc ahôŋ e atap mwasiŋ naŋ Damaŋ gic bata bu kêŋ meŋ, naŋ sa. Aö gasôm yom pi mwasiŋ dau muŋ su. ");
INSERT INTO buk_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Muŋ-ŋga Jon kêku lau ŋa bu, magoc bêc meŋ kêpiŋ bu Anötö êŋku mac ŋa Ŋalau Dabuŋ.” ");
INSERT INTO buk_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Têŋ têm daŋ Yisu mbo whiŋ ndê aposel, ma sêndac iŋ bocdec bu, “Pômdau, bocke? Kwahic dec am oc êmgaho yac lau Israel-ŋga su yêc lau Rom-ŋga si gôliŋ ŋapu, ma ti kiŋ ma nem gôliŋ yac, me mba?” ");
INSERT INTO buk_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ma iŋ ô yom ma sôm, “Gêŋ bocke naŋ bu hôc asê lau Israel-ŋga, ma ŋatêm ti ŋabêc, naŋ Damaŋ Anötö ti ŋadau ma kêyaliŋ sa su, ma iŋ oc tôc asê têŋ mac dom. ");
INSERT INTO buk_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Magoc têŋ ndoc Ŋalau Dabuŋ meŋ ma nem mac ahuc, dec oc kêŋ ŋaclai têŋ mac, ma mac oc ahoc yom ŋandô asê pi aö yêc Jerusalem, ma yêc gameŋ Judia-ŋga ma gameŋ Samaria-ŋga, e yom dau tiapa nem nom ŋagameŋ hoŋ ahuc.” ");
INSERT INTO buk_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yisu sôm yom dinaŋ su, goc Anötö kôc iŋ sa pi lôlôc gi e sôc dao ŋalôm, dec sêlic iŋ apu. ");
INSERT INTO buk_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Iŋ pi gi ma ŋac tatac umboŋ sêlhac, ma sep eŋ ŋgac lu ti ŋakwê sêsêp sêmeŋ sêlhac sêwhiŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ma iŋlu sêsôm, “Mac lauŋgac Galili-ŋga. Tu ake-ŋga dec alhac tamtac undambê? Kwahic dec Anötö kôc Yisu su yêc mac, ma tiŋambu iŋ oc mbu meŋ tiyham ŋalêŋ tigeŋ tôm naŋ alic iŋ pi gi.” ");
INSERT INTO buk_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Dinaŋ su, goc sêhu Lôc Olib siŋ ma sêmbu sêtêŋ Jerusalem si. Lôc dau kalhac kêpiŋ Jerusalem, seŋ ŋasawa gitôm kilometa tigeŋ. ");
INSERT INTO buk_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Têŋ ndoc sêhôc asê su, naŋ sêtêŋ ŋac si andu sêmbo-ŋga si, ma sêpi ŋalôm ŋahô-ŋga si. Lau dau si ŋaê bocdec: Pita lu Jon, ma Jems lu Andru, Pilip lu Tomas, ma Batolomeas lu Matyu, Alpayas atuŋgac naŋ ndê ŋaê Jems, ma Saimon (naŋ sêsam bu ‘Ŋgac †Selot’), ma Jems atuŋgac Judas. ");
INSERT INTO buk_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yisu dinda Maria, ti iŋ ndê asii, ma lauwhê ŋatô sêmbo sêwhiŋ ŋac. Ŋac hoŋ sêpiŋ dau dôŋ ti ŋalôm tigeŋ, ma sêteŋ mbec sêwhiŋ dandi tôm bêc hoŋ. ");
INSERT INTO buk_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Têŋ bêc daŋ lau sêkêŋ whiŋ-ŋga gitôm lau 120 sêkac sa sêmbo sêwhiŋ dau. Ma Pita tisa kalhac ŋalhu, ma sôm, ");
INSERT INTO buk_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“O asidôwai hac. Mac aŋyalê Judas, ŋgac naŋ wê lau naŋ sêkôc Yisu dôŋ. Iŋ yac lau aposel 12 mba daŋ, ma wêkaiŋ gweleŋ whiŋ yac. Muŋ-ŋga andô, Ŋalau Dabuŋ hoc yom asê sa akêŋ Dawid whasuŋ, naŋ hêganôŋ Judas. Ma yom dau gic waê bu ŋandô sa.” ");
INSERT INTO buk_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Tu Judas ndê mêtê sac hoc Yisu asê-ŋga, dec lau semlhi iŋ, ma iŋ kôc ŋaôli dau ma gi gêmlhi nom daŋ. Yêc dinaŋ iŋ peŋ sip gi, e gambo hôc kôc ma ŋatac wê. ");
INSERT INTO buk_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Lau Jerusalem-ŋga sêŋgô ŋawaê, ma sêsam nom dau yêc si awha-ŋga bu Akeldama, naŋ danem kwi bu ‘Nom ti Dac.’ ) ");
INSERT INTO buk_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Yom naŋ Dawid hoc asê pi Judas, naŋ sêto yêc Buku Wê-ŋga bocdec bu, ‘Iŋ ndê gameŋ tigasaŋ maŋ, ma lau daŋ oc sêmbo dom.’ Ma sêto daŋ tiyham bocdec bu, ‘Ŋamalac daŋ oc ti ŋgac bata ma kôc iŋ ndê gweleŋ ô iŋ su.’ ");
INSERT INTO buk_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Sêto yom dau yêc bocdinaŋ, dec aö gauc gêm bu yac taŋyaliŋ ŋgac daŋ sa ô Judas su. Gauc nem lau hoŋ naŋ sêmbo sêwhiŋ yac tôm bêc hoŋ naŋ Pômdau Yisu mbo yac ŋasawa. ");
INSERT INTO buk_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Lau naŋ sêmbo têŋ Jon, Ŋgac Kêku Lau-ŋga ndê têm e meŋ têŋ ndoc Yisu pi undambê gi. Yac taŋyaliŋ ŋac si daŋ sa, bu hoc Yisu tisa ŋawaê asê whiŋ yac.” ");
INSERT INTO buk_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Goc sêŋyaliŋ ŋgac lu sa, daŋ ndê ŋaê Matias, ma daŋ ŋaê Josep, naŋ sêsam iŋ ndê ŋaê daŋ bu Basabas, ma iŋ ndê ŋaê daŋ tiyham bu Justus. ");
INSERT INTO buk_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ma sêteŋ mbec bocdec b u, “O Pômdau. Am kêyalê ŋamalac hoŋ si ŋalôm. Tôc ŋgac lu dau si asa naŋ am kêyaliŋ sa su, naŋ asê têŋ yac. ");
INSERT INTO buk_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Iŋ oc kôm gweleŋ naŋ am kêŋ sip lau aposel amba, naŋ Judas hu siŋ ma kölhö têŋ gameŋ naŋ gic iŋ ŋawaê, naŋ gi.” ");
INSERT INTO buk_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Goc sêpuc gapoc e gi sip Matias. Ma bocdinaŋ iŋ ti aposel daŋ whiŋ ŋac lau 11. ");
INSERT INTO buk_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Têŋ Om †Pentikos ŋac hoŋ sêmbo sêwhiŋ dau. ");
INSERT INTO buk_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ma ŋagahô eŋ ŋakêcsia gitôm mbu puc ŋadinda meŋ akêŋ undambê, ma gêm andu naŋ ŋac sêndöc, naŋ ahuc. ");
INSERT INTO buk_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ma sêlic gêŋ gitôm yawahô meŋ ma whê dau kôc-kôc, goc gi sac ŋac ŋagôlôŋ têŋtêŋ gitôm ya ŋa-êmbala. ");
INSERT INTO buk_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ma Ŋalau Dabuŋ gêm ŋac hoŋ ahuc e sêsôm lau apa awha naŋ sêŋyalê muŋ su dom, tôm Ŋalau Dabuŋ hôc ŋac awha sa. ");
INSERT INTO buk_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Têŋ têm dinaŋ lau daêsam sêmbo Jerusalem, naŋ sêmeŋ akêŋ nom ŋagameŋ hoŋ. Ŋac lau Israel-ŋga naŋ sem akiŋ Anötö ma sêtoc iŋ sa. ");
INSERT INTO buk_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ŋac sêŋgô lau naŋ Ŋalau Dabuŋ gêm ŋac ahuc, naŋ sêsôm ŋac awha têŋtêŋ, goc sêsö ŋandô ma sêkac sa sêtigasuc. ");
INSERT INTO buk_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ŋac sêhêdaê ŋandô, ma sêsôm têŋ dandi, “Aluê! Ŋac lau dê sêsôm yom sêmbo dê, naŋ lau Galili-ŋga me? ");
INSERT INTO buk_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ma bocke dec daŋgô ŋac sêsôm yac awhaŋ têŋtêŋ, tôm dinaŋi sêkôc yac ma dasôm? ");
INSERT INTO buk_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Yac lau naŋ dambo dec, naŋ ameŋ a kêŋ Pata, Midia ma Elam, ma akêŋ Mesopotemia, Judia, Kapadosia, Pontus ma Esia, ");
INSERT INTO buk_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","ma akêŋ Prigia ti Pampilia, Isip ma Libia kêpiŋ Sairin, ma akêŋ Krit ma Arabia ma akêŋ malac Rom. Yac lau Israel-ŋga, ma lau apa naŋ sêŋkuc lau Israel-ŋga si sakiŋ tu sênem akiŋ Anötö-ŋga. Bocke ma kwahic dec daŋgô lau Galili-ŋga dindê sêsôm yom asê yêc yac dauŋ awhaŋ têŋtêŋ, pi gêŋ dalô naŋ Anötö kôm!” ");
INSERT INTO buk_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Gêŋ dau kôm ŋac sêhêdaê ti gauc gêm yom daêsam, ma sêndac dandi, “Gêŋ dindec ŋahu bocke?” ");
INSERT INTO buk_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Magoc lau ŋatô sêsu lau aposel susu ma sêsôm, “Mboe sênôm wain ma kêŋiŋ ŋac.” ");
INSERT INTO buk_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Têŋ dinaŋ Pita ti aposel 11 sêtisa ma iŋ hôc awha sa ma sôm têŋ lau daêsam dinaŋ, “Mac lau Israel-ŋga ti mac hoŋ naŋ andöc Jerusalem. Akêŋ daŋam ŋapep ma aö wawhê gêŋ dindec ŋahu sa têŋ mac. ");
INSERT INTO buk_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mac lau ŋatô gauc gêm bu wain kêŋiŋ lau dindec, a? Aö wasôm têŋ mac bu mba! Bu ac kwahic pi meŋ. ");
INSERT INTO buk_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Magoc yom naŋ propet Joel to muŋ su, naŋ dec ŋandô sa. ");
INSERT INTO buk_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Joel to Anötö ndê yom dau bocdec bu: Tiŋambu aö wakêŋ aneŋ Ŋalau sip lau hoŋ si ŋalôm, e atômŋgaci ti atômwêi sêsôm yom asê sêtôm lau propet. Ŋalau oc kôm mac nem balêkoc wakuc tandô kaiŋ daŋ sa e sêlic gêŋ ŋagatu, ma Ŋalau dau oc suŋ mbê têŋ lau andô. ");
INSERT INTO buk_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Têŋ têm dinaŋ aö wakêŋ aneŋ Ŋalau têŋ aneŋ lau akiŋ awhê ma ŋgac hoŋ. Ma ŋac oc sêsôm yom asê sêtôm propet. ");
INSERT INTO buk_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Aö wakôm gêŋ dalô yêc umboŋ ma yêc nom bocdinaŋ, gêŋ dalô dac ti ya ma yawasu-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ac oc nem ganduc, ma ayô oc tikoc nditôm dac. Ma tiŋambu bêc atu oc meŋ sa, naŋ Pômdau mbu meŋ ti ŋawasi atu. ");
INSERT INTO buk_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ma têŋ dinaŋ lau hoŋ naŋ sêta Pômdau ndê ŋaê, naŋ Anötö oc nem ŋac si.” ");
INSERT INTO buk_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Goc Pita sôm, “Mac lau Israel-ŋga, aŋgô aneŋ yom dindec pi Yisu Nasaret-ŋga. Iŋ ŋgac naŋ Anötö whê sa têŋ mac ŋa gêŋ dalô tidau-tidau. Mac aŋyalê su, bu iŋ kôm gêŋ dau yêc mac aŋôm-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ma tu lêŋ naŋ Anötö gauc gêm tidôŋ gwanaŋ su-ŋga, dec Judas hoc Yisu asê ma kêŋ iŋ sip mac amam. Ma mac akêŋ iŋ têŋ lau Rom-ŋga naŋ sêsôc Anötö ndê yomsu ŋapu dom, bu sêndic iŋ pi a gicso dau, dec tôm mac daôm ac iŋ ndu. ");
INSERT INTO buk_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Tigeŋ gitôm dom bu ŋaclai dambac ndu-ŋga ku iŋ dulu. Anötö kôc iŋ ndê ŋandê mbac ndu-ŋga su yêc iŋ, ma uŋ iŋ sa akêŋ lau batê-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dawid to yom pi Yisu bocdec bu: Aö galic Pômdau kalhac aö aŋôŋ-ŋga ŋapaŋ. Aö oc wantitec dom, bu iŋ mbo aö amaŋ andô-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Tu dinaŋ-ŋga dec aö atac ŋayham sa, ma gasôm yom ŋayham-ŋayham. Aö gauc gêm aneŋ ŋamlic, ma gakêŋ bataŋ ");
INSERT INTO buk_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","bu am oc tec aö wayêc sêhô ŋapaŋ dom. Mba! Am oc tec am nem ŋgac dabuŋ e iŋ ŋamlic tibalê dom. ");
INSERT INTO buk_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Am tôc seŋ wandöc taŋli-ŋga asê têŋ aö, ma oc kêŋ aö walhac am aŋôm-ŋga ti atac ŋayham atu. ");
INSERT INTO buk_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","O asidôwai hac. Abaŋ Dawid sôm yom dinaŋ pi iŋ dau dom. Yac taŋyalê bu iŋ mbac ndu su ma sêŋsuhuŋ iŋ. Ma iŋ ndê sêhô yêc gameŋ dindec e meŋ têŋ kwahic dec. ");
INSERT INTO buk_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Magoc Anötö gic bata têŋ iŋ bu kêŋ iŋ ndê wakuc daŋ ndöc iŋ ndê pôŋ kiŋ-ŋga. Dawid dau kêyalê yom dinaŋ tidôŋ, ŋahu bu iŋ propet daŋ. ");
INSERT INTO buk_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ma gêŋ naŋ oc hôc asê tiŋambu-ŋga, naŋ iŋ kêyalê gwanaŋ su. Tu dinaŋ-ŋga iŋ sôm yom dinaŋ pi †Mesaya, ma sôm bu Anötö oc tec iŋ yêc sêhô dom, ma iŋ ndê ŋamlic oc tibalê dom. Mba! Mesaya tisa su. ");
INSERT INTO buk_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Anötö uŋ Yisu sa mbo tali tiyham, ma iŋ ndê lau yac alic su dec asôm asê. ");
INSERT INTO buk_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kwahic dec Anötö toc iŋ sa ndöc iŋ amba andô-ŋga, ma iŋ kêŋ Ŋalau Dabuŋ têŋ yac tôm Damba gic bata. Gêŋ naŋ mac alic ti aŋgô têŋ acsalô lec, naŋ Ŋalau dau ndê gweleŋ ŋa-ŋandô. ");
INSERT INTO buk_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","“Ma Dawid dau pi undambê gi dom, magoc iŋ to yom yêc bocdec bu, ‘Anötö sôm têŋ aneŋ Pômdau, “Am ndöc aö amaŋ andô-ŋga ");
INSERT INTO buk_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","e nditôm aö wakêŋ nem ŋacyo sêsôc am gahim ŋapu.” ’ ");
INSERT INTO buk_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Iŋ to yom dau hêganôŋ Yisu. Bocdinaŋ mac lau Israel-ŋga hoŋ aŋgô. Aŋyalê pi ŋandô, bu Yisu naŋ mac ac iŋ ndu pi a gicso dau gi, naŋ Anötö toc iŋ sa ti Pômdau, ma tôc asê bu iŋ Mesaya dau.” ");
INSERT INTO buk_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pita ndê yom hoŋ dinaŋ kuŋ lau dau si ŋalôm ŋandô, dec sêsôm têŋ iŋ ti lau aposel ŋatô bu, “O asidôwai, yac dec oc akôm bocke?” ");
INSERT INTO buk_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ma Pita ô yom ma sôm, “Mac hoŋ anem nem ŋalôm kwi ma aliŋ saŋgu tu Yisu Kilisi ndê ŋaê-ŋga, tu bu Anötö suc mac nem sac kwi-ŋga. Ma mac oc akôc mwasiŋ naŋ Anötö gic bata, naŋ Ŋalau Dabuŋ dau. ");
INSERT INTO buk_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Bu iŋ gic bata Ŋalau Dabuŋ gic waê lau hoŋ naŋ Pômdau yac neŋ Anötö kêgalêm ŋac sa. Gêŋ dau gic waê mac ti mac nem balêkoc, ma lau hoŋ naŋ kwahic dec sêmbo ahê ma tiŋambu oc sêkêŋ whiŋ Yisu naŋ.” ");
INSERT INTO buk_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Tiŋambu Pita sôm yom daêsam ti gêm la ŋac, ma kac ŋac bocdec bu, “Anem daôm kwi têŋ Anötö bu nem mac si, dec mac oc andiŋam awhiŋ lau sac naŋ kwahic dec sêmbo nom, naŋ dom.” ");
INSERT INTO buk_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ma têŋ bêc dau dinaŋ lau naŋ sêkêŋ whiŋ sêti daêsam, bu lau gitôm 3,000 sêkôc Pita ndê yom sa ma sêliŋ busaŋgu. ");
INSERT INTO buk_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tôm bêc hoŋ lau sêkêŋ whiŋ-ŋga sêpiŋ dau dôŋ ti sêkêŋ daŋga yom naŋ aposel sêndôhôŋ têŋ ŋac, ma ŋac sêteŋ mbec ti seŋ gêŋ sêwhiŋ dau. ");
INSERT INTO buk_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Aposel sêkôm gêŋ atu-tu ti gêŋ dalô daêsam, e lau Jerusalem-ŋga hoŋ sêhêdaê. ");
INSERT INTO buk_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Lau hoŋ naŋ sêkêŋ whiŋ, naŋ sêndöc tigeŋ ma sêyob si gêŋ hoŋ sêwhiŋ dau. ");
INSERT INTO buk_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ŋac si lau ŋatô bu sêpônda dau, dec asidôwai ŋatô oc sêkêŋ si wapa ŋatô ti gêŋ têŋ lau semlhi, goc sic sam ŋa-awa bu sênem lau naŋ sêpônda dau, naŋ sa. ");
INSERT INTO buk_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tôm bêc hoŋ sêkac dau sa sêmbo lôm dabuŋ ŋabatêmndö, ma yêc ŋac si andu ŋac seŋ gêŋ sêwhiŋ dau ti atac ŋayham, ma sêsôc Anötö ŋapu ti si ŋalôm sambuc. ");
INSERT INTO buk_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ŋac sêmpiŋ Anötö ma lau hoŋ sêlic ŋac ŋayham dec sêtoc ŋac sa. Ma tôm bêc hoŋ Pômdau kôm lau wakuc sêkêŋ whiŋ, dec kôm gôlôwac dabuŋ Jerusalem-ŋga kêsôwec tiatu. ");
INSERT INTO buk_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Têŋ bêc daŋ Pita lu Jon sêŋsêlêŋ bu sêtêŋ lôm dabuŋ sêndi, têŋ acgatu gitôm 3 kilok telha-ŋga, naŋ lau Israel si têm sêteŋ mbec-ŋga daŋ. ");
INSERT INTO buk_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ma ŋgac daŋ mbo, naŋ dinda kôc iŋ tigahi tigoloŋ. Tôm bêc hoŋ lau sêmbalaŋ iŋ si, sêkêŋ iŋ ndöc lôm dabuŋ ŋagameŋ kêpiŋ gatam daŋ naŋ sêsam bu Gatam Ŋayham, ma iŋ teŋ gêŋ têŋ lau naŋ sêsôc sêsa. ");
INSERT INTO buk_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Têŋ ndoc iŋ gêlic Pita lu Jon sêmeŋ bu sêsôc sêndi, naŋ iŋ teŋ mone têŋ iŋlu. ");
INSERT INTO buk_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pita lu Jon tahê iŋ, ma Pita sôm têŋ iŋ, “Tamhê alu.” ");
INSERT INTO buk_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Dec ŋgac dau tahê iŋlu, ma kêŋ bata bu oc sêkêŋ gêŋ têŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Goc Pita sôm têŋ iŋ, “Aö neŋ awa silba me gol bu wakêŋ têŋ am-ŋga mbasi, magoc gêŋ naŋ yêc aö, naŋ oc wakêŋ. Tu Yisu Kilisi Nasaret-ŋga ndê ŋaê-ŋga aö wasôm têŋ am bu êmsêlêŋ!” ");
INSERT INTO buk_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ma Pita kêm iŋ têŋ amba andô-ŋga, keŋ iŋ sa, ma ŋagahô ŋambwa iŋ ndê hapa ti hagwam ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Iŋ pwê gi kalhac e kêsêlêŋ, goc sôc lôm dabuŋ ŋabatêmndö whiŋ iŋlu gi. Ma iŋ kêsêlêŋ ti pwê-pwê ma kêpiŋ Anötö. ");
INSERT INTO buk_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Lau hoŋ naŋ sêlic iŋ kêsêlêŋ ti kêpiŋ Anötö, ");
INSERT INTO buk_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","naŋ sêŋyalê bu iŋ ŋgac teŋ gêŋ-ŋga naŋ muŋ-ŋga ndöc lôm dabuŋ ŋasactô yêc gatam naŋ sêsam bu Gatam Ŋayham. Ma sêhêdaê ti sêseŋ amba ŋandô tu iŋ ŋayham sa-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pita lu Jon sêlhac lôm dabuŋ ŋabatêmndö yêc gameŋ naŋ sêsam bu Solomon ndê Batêm, ma ŋgac teŋ gêŋ-ŋga dau sap iŋlu dôŋ ŋapaŋ. Ma lau hoŋ naŋ sêlic gêŋ dau sêsö, ma sênti sêtêŋ iŋlu si. ");
INSERT INTO buk_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita tahê ŋac ma sôm, “Mac lau Israel-ŋga! Tu sake-ŋga mac asö tu gêŋ dindec-ŋga ma tamhê alu ŋaŋga? Mac gauc gêm bocke? Alu mba ŋaclai ti mêtê gitêŋ dec kôm iŋ ŋgac dinaŋ ŋayham sa ma kêsêlêŋ, a? Wasôm têŋ mac, mba! ");
INSERT INTO buk_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham lu Aisak ma Jakob si Anötö, yac neŋ abaŋi si Anötö, kôm gêŋ dindec tu bu po iŋ ndê ŋgac akiŋ Yisu ndê waê sa. Mac daôm akêŋ iŋ sip lau Rom-ŋga amba bu sêndic iŋ ndu. Pailot dau gauc gêm tidôŋ bu êŋgapwêc Yisu su, magoc mac atôc asê têŋ Pailot bu mac atec Yisu. ");
INSERT INTO buk_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Iŋ ŋgac dabuŋ ti gitêŋ, magoc mac atec iŋ, ma ateŋ Pailot bu êŋgapwêc ŋgac naŋ gic ŋamalac ndu, naŋ su têŋ mac. ");
INSERT INTO buk_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Magoc ŋgac naŋ ti yac neŋ dandöc taŋli-ŋga ŋahu, naŋ mac ac iŋ ndu. Tigeŋ Anötö uŋ iŋ sa akêŋ lau batê-ŋga. Yac alic iŋ tisa su, dec asôm asê bu yomandô. ");
INSERT INTO buk_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Alic ŋgac dindec. Mac aŋyalê bu muŋ-ŋga iŋ ŋgac bôliŋ. Kwahic dec iŋ gahi ŋayham sa tu Yisu ndê ŋaê-ŋga, ŋaê naŋ yac akêŋ whiŋ. Yomandô! Iŋ ŋayham sa sambuc tu Yisu ndê ŋaê-ŋga ma tu yac akêŋ whiŋ Yisu-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“O asidôwai hac! Aö kayalê su bu mac ti nem lau bata Israel-ŋga nem gauc sa pi Yisu ndê ŋahu dom, dec mac ac iŋ ndu. ");
INSERT INTO buk_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Magoc lau propet hoŋ sêhoc Anötö ndê yom asê gwanaŋ su, bu iŋ ndê Mesaya oc hôc ŋandê. Ma kwahic dec ŋac si yom dau ŋandô sa pi gêŋ naŋ mac akôm. ");
INSERT INTO buk_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Tu dinaŋ-ŋga dec wasôm têŋ mac bu apu daôm ma anem daôm kwi. Ma bocdinaŋ dec Anötö oc suc mac nem sac kwi. ");
INSERT INTO buk_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ma Pômdau ndê mwasiŋ oc puc mac nem gatôm dôŋ. Ma Anötö oc kêŋ Mesaya naŋ iŋ kêyaliŋ sa gwanaŋ su, naŋ Yisu dau, naŋ mbu têŋ mac meŋ. ");
INSERT INTO buk_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Iŋ oc mbo undambê e tôm Anötö kôm gêŋ hoŋ tiwakuc tiyham, tôm iŋ hoc asê muŋ-ŋga ŋa iŋ ndê propet dabuŋ hoŋ whasuŋ. ");
INSERT INTO buk_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Bu Moses to yom bocdec bu, ‘Pômdau mac nem Anötö, oc êŋyaliŋ ŋgac daŋ sa yêc lau Israel-ŋga, bu ti mac nem propet nditôm aö dauŋ. Ma yom hoŋ naŋ iŋ sôm, naŋ mac asôc ŋapu maŋ. ");
INSERT INTO buk_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Lau naŋ sêkêŋ daŋga propet dinaŋ ndê yom dom, naŋ Anötö oc tiŋ ŋac su yêc iŋ ndê lau ŋatoŋ.’ ");
INSERT INTO buk_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Moses to yom dinaŋ, ma Samuel ti propet hoŋ naŋ sêŋkuc iŋ, naŋ sêhoc yom asê gwanaŋ su pi gêŋ naŋ hôc asê têŋ têm dindec. ");
INSERT INTO buk_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yom naŋ lau propet sêhoc asê têŋ abaŋi, naŋ mac atap ŋa-ŋandô sa su. Ma pwac naŋ Anötö kêmatiŋ whiŋ abaŋi, naŋ bocdinaŋ. Bu Anötö sôm têŋ Abraham bu, ‘Lau nom-ŋga hoŋ oc sêtap mbec ŋamwasiŋ sa yêc am nem wakuc.’ ");
INSERT INTO buk_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ma kwahic dec Anötö kêŋ ndê ŋgac akiŋ-ŋga meŋ. Iŋ têŋ mac lau Israel-ŋga muŋ, bu nem mac kwi ma ahu nem mêtê sac siŋ. Ma mac bu akôm bocdinaŋ, dec oc atap iŋ ndê mbec ŋamwasiŋ sa.” ");
INSERT INTO buk_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita lu Jon sêsôm yom têŋ lau sêmbo, ma lau †dabuŋ-siga ti lau siŋ sêyob lôm dabuŋ-ŋga si ŋgac bata, ma lau †Sadiusi ŋatô sêtêŋ iŋlu si. ");
INSERT INTO buk_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ŋac sêŋgô bu Pita lu Jon sêndôhôŋ lau ma sêsôm têŋ ŋac bu Yisu tisa su, ma bu iŋ ti lau si ŋahu sêtisa akêŋ lau batê-ŋga. Ma iŋlu si yom dau kôm ŋac atac ŋandê. ");
INSERT INTO buk_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tu dinaŋ-ŋga sêkôc iŋlu dôŋ, tigeŋ ŋasec sa su, dec sêŋlahi iŋlu ahuc bu sêndöc e bêbêc. ");
INSERT INTO buk_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Magoc lau daêsam naŋ sêŋgô yom naŋ Pita lu Jon sêsôm, naŋ sêkêŋ whiŋ yom dau. Ŋac lau dau si lauŋgac ŋambwa si namba gitôm 5,000. ");
INSERT INTO buk_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Galaŋsê bêbêc lau bata ma lau andô ti lau naŋ sêndôhôŋ yomsu sêkac sa yêc Jerusalem. ");
INSERT INTO buk_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ma †dabuŋsiga ŋamata-ŋga Anas, ma Kayapas lu Jon ma Aleksanda ti lau ŋatô yêc dabuŋsiga ŋamata-ŋga ndê gôlôwac, naŋ sêmbo sêwhiŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Sêkôc Pita lu Jon sêmeŋ sêlhac ŋac aŋgô-ŋga, goc sêŋsu iŋlu bocdec bu, “Amlu akôm gêŋ dindec am asa aŋgô, me akôc asa ndê ŋaclai dec akôm?” ");
INSERT INTO buk_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Têŋ dinaŋ Ŋalau Dabuŋ gêm Pita ahuc, dec sôm têŋ ŋac bu, “O mac lau bata ti lau andô Israel-ŋga! ");
INSERT INTO buk_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Kwahic dec mac bu aŋsu alu pi mwasiŋ naŋ akôm têŋ ŋgac bôliŋ dindec. Ma andac alu pi lêŋ iŋ ŋayham sa-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mac lau bata, ti mac lau Israel-ŋga hoŋ aŋgô! Ŋgac dindec kalhac mac aŋôm-ŋga, naŋ ŋamlic ŋayham sa su tu Yisu Kilisi ndê ŋaê-ŋga. Iŋ ŋgac Nasaret-ŋga naŋ mac ac iŋ ndu pi a gicso dau. Magoc Anötö uŋ iŋ sa akêŋ lau batê-ŋga ma mbo tali tiyham. ");
INSERT INTO buk_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Sêto yom pi Yisu naŋ yêc bocdec bu, ‘Hoc naŋ mac lau akwê andu-ŋga alic sac ma atec ndöc, naŋ kwahic dec ti hoc ŋamata-ŋga yêc andu dau.’ ");
INSERT INTO buk_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Aŋgô! Seŋ tigeŋ yêc bu yac lau nom-ŋga datap Anötö ndê mwasiŋ nem yac si-ŋga sa, naŋ datap sa tu Yisu ndê ŋaê-ŋ ga. Ŋaê daŋ yêc naŋ gitôm bu nem yac si-ŋga yêc dom. Mba andô!” ");
INSERT INTO buk_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Lau bata sêŋgô yom dinaŋ, ma sêŋyalê bu Pita lu Jon sêsôc lôm mêtê-ŋga daŋ dom, magoc sêŋyalê bu muŋ-ŋga iŋlu sêmbo sêwhiŋ Yisu ŋapaŋ. Ma ŋac sêhêdaê bu iŋlu sêô lau si yom ti atac pa su. ");
INSERT INTO buk_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Magoc ŋgac bôliŋ naŋ ŋamlic ŋayham sa, naŋ kalhac whiŋ iŋlu, ma tu dinaŋ-ŋga ŋac si yom mba bu sêsôm. ");
INSERT INTO buk_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bocdinaŋ sic atu iŋlu bu sêhu ŋac lau †Sanedrin-ŋga siŋ ma sêkêŋ ŋasawa têŋ ŋac bu sêsôm yom pi iŋlu. ");
INSERT INTO buk_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Goc sêsôm têŋ dau bu, “Yac oc dakôm sake têŋ ŋgac lu dindê? Lau Jerusalem-ŋga hoŋ sêlic gêŋ dalô atu naŋ iŋlu sêkôm su, ma yac oc dasêc ahuc nditôm dom. ");
INSERT INTO buk_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Lau hoŋ bu sêŋgô ŋawaê pi gêŋ dindec, dec oc yham dom. Bocdinaŋ dakêŋ yao ŋaŋga têŋ iŋlu, bu sêsôm yom pi Yisu ma sêsam iŋ ndê ŋaê têŋ lau tiyham dom.” ");
INSERT INTO buk_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Goc sêmbwêc iŋlu sêmbu sêmeŋ, ma sic yao iŋlu bu sêsôm yom ti sêndôhôŋ lau tu Yisu ndê ŋaê-ŋga tiyham dom. ");
INSERT INTO buk_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Magoc Pita lu Jon sêô ŋac awha bocdec bu, “Mac gauc gêm bocke? Oc solop yêc Anötö aŋgô-ŋga bu alu asôc mac nem yom ŋapu, ma daŋaŋ wambu Anötö dom, a? ");
INSERT INTO buk_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mba! Alu atôm dom bu aŋgapic whaŋsuŋ tu gêŋ naŋ alic ti aŋgô-ŋga.” ");
INSERT INTO buk_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Lau bata sic yomsu iŋlu tiyham, goc sêkêŋ iŋlu sêsa si. Ŋac sêtôm dom bu sêtap lêŋ sêmatôc iŋlu-ŋga daŋ sa. Ŋahu bu lau hoŋ sêmpiŋ Anötö tu iŋ kôm ŋgac naŋ ndöc bôliŋ yala daêsam su, naŋ ŋayham sa. Bu ŋgac dau ndöc bôliŋ ŋapaŋ e ndê yala gi tap 40 sa. ");
INSERT INTO buk_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Sêŋgapwêc Pita lu Jon su, ma iŋlu sêmbu sêtêŋ lau sêkêŋ whiŋ-ŋ ga si, ma sic miŋ yom naŋ †dabuŋ-siga atu-tu ti lau bata sêsôm têŋ iŋlu. ");
INSERT INTO buk_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Sêŋgô su, goc ŋac hoŋ sêteŋ mbec têŋ Anötö bocdec, “O Ŋaclai Ŋadau Pômdau, am naŋ kêŋ undambê ti nom ma gwêc ti gêŋ hoŋ naŋ sêmbo ŋalôm. ");
INSERT INTO buk_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Am daôm kêŋ Ŋalau Dabuŋ hôc abaŋ Dawid awha sa ma iŋ sôm, ‘Tu sake-ŋga lau nom-ŋga sêli dau sa ma sêkic yom naŋ ŋandô mba? ");
INSERT INTO buk_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ma kiŋ ti gôliŋwaga sêkac dau sa ma sêmatiŋ yom pitigeŋ bu sêseŋ Pômdau lu Mesaya naŋ iŋ kêyaliŋ sa, naŋ su.’ ");
INSERT INTO buk_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Dawid ndê yom dau ŋandô sa yêc malac atu dindec. Bu †Herod lu Pontias Pailot, ma lau siŋ gameŋ apa-ŋga, ma lau bata Israel-ŋga sêkêŋ si gauc pitigeŋ bu sêseŋ am nem ŋgac akiŋ-ŋga dabuŋ Yisu naŋ am kêyaliŋ iŋ sa ti Mesaya, naŋ su. ");
INSERT INTO buk_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Gêŋ naŋ am, Ŋaclai Ŋadau gauc gêm tidôŋ su, naŋ dec sêkôm ŋandô sa. ");
INSERT INTO buk_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","O Pômdau, lau dinaŋ sêsôm yom daêsam bu sêlhac yac ahuc. Magoc yac ateŋ am bu puc yac dôŋ bu ahoc am nem mêtê asê ti atac pa su. ");
INSERT INTO buk_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Kêŋ nem ŋaclai têŋ yac bu akôm am nem gweleŋ ma akôm lau gêmbac ŋayham sa, ma akôm gêŋ dalô tidau-tidau tu am nem ŋgac akiŋ-ŋga dabuŋ Yisu ndê ŋaê-ŋga.” ");
INSERT INTO buk_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Sêteŋ mbec dinaŋ su, goc gameŋ naŋ sêkac sa sêndöc naŋ kêwic dau. Ma Ŋalau Dabuŋ gêm ŋac hoŋ ahuc, ma ŋac sic hu sêsôm Anötö ndê mêtê asê ti atac pa su. ");
INSERT INTO buk_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Lau sêkêŋ whiŋ-ŋga hoŋ sêkêŋ si ŋalôm ti gauc pitigeŋ. Ma ŋac si daŋ gêlic ndê gêŋ tôm iŋ dau ndê dom. Hoŋ sêwêkaiŋ gêŋ toŋ tigeŋ. ");
INSERT INTO buk_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Lau aposel sêhoc Pômdau Yisu tisa ŋawaê asê ti ŋaclai eŋ, ma Anötö ndê mwasiŋ kêsalê ŋac hoŋ ahuc sambuc. ");
INSERT INTO buk_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ŋac si daŋ pônda dau tu gêŋ daŋ-ŋga dom. Ŋahu bu lau naŋ sêwêkaiŋ nom me andu, naŋ sêkêŋ si gêŋ têŋ lau semlhi. Goc sêkôc ŋa-awa sa si, ");
INSERT INTO buk_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ma sêkêŋ têŋ aposel sêyob. Ma lau aposel sic sam gêŋ dau têŋ lau sêpônda dau-ŋga tôm gi. ");
INSERT INTO buk_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ma ŋgac daŋ mbo, naŋ meŋ akêŋ nduc Saipras. Iŋ †Liwai ndê wakuc daŋ, ma iŋ ndê ŋaê Josep. Magoc aposel sêsam iŋ bu Banabas, naŋ danem kwi bu ŋgac puc lau dôŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ŋgac dau ndê nom daŋ y êc, dec kêŋ têŋ lau semlhi, ma kôc ŋa-awa meŋ kêŋ têŋ lau aposel. ");
INSERT INTO buk_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ŋgac daŋ ŋaê Ananias lu iŋ nawhê Sapaira sêmbo, ma iŋlu sêkêŋ si nom daŋ têŋ lau semlhi. ");
INSERT INTO buk_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nom dau ŋa-awa daŋga Ananias kêgamiŋ yêc iŋ-ŋga, ma iŋ nawhê Sapaira kêyalê. Ma ŋadaŋga naŋ Ananias kêŋ têŋ lau aposel, ma kêsau bu nom dau ŋaôli sambuc dinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Têŋ ndoc Pita gêlic awa dau, naŋ sôm têŋ iŋ bu, “Ananias, bocke dec Sadaŋ gêm am nem ŋalôm ahuc e am gauc gêm bu êŋsau Ŋalau Dabuŋ, ma kêgamiŋ nom ŋa-awa ŋatô yêc am-ŋga? ");
INSERT INTO buk_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Muŋ-ŋga am daôm ti ŋadau nem nom, ma têŋ ndoc am kêŋ têŋ lau semlhi su, naŋ am ti ŋadau ŋa-awa dau bocdinaŋ. Magoc am kêŋ ŋadaŋga têŋ yac ma kêsau bu nom dau ŋaôli sambuc dinaŋ. Bocke dec am gauc gêm bu kôm gêŋ boc-dinaŋ? Am kêsau ŋamalac dom, am kêsau Anötö goc.” ");
INSERT INTO buk_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Têŋ têm Ananias ŋgô yom dinaŋ, dec iŋ hu dau sip nom gi ma mbac ndu yêc. Ma lau hoŋ naŋ sêŋgô gêŋ dau ŋawaê, naŋ sêtöc dau ŋandô. ");
INSERT INTO buk_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Lau batac ŋatô sêtêŋ Ananias si, sêmpaŋ iŋ ndê ŋamlaŋ ahuc ma sêkôc sa si sêŋsuhuŋ. ");
INSERT INTO buk_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ŋasawa gitôm acgatu tö giŋga su, goc ŋgac dau nawhê meŋ ma gêm gauc gêŋ naŋ kôm iŋ nakweŋ. ");
INSERT INTO buk_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ma Pita tôc mone dau têŋ iŋ, goc ndac, “Lau semlhi amlu nam akweŋ nem nom daŋ, ma ŋaôli dau dindec, me?” Ma awhê dau sôm bu, “Aêc, gêŋ dau dindec.” ");
INSERT INTO buk_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Dec Pita sôm, “Bocke dec amlu nem ŋalôm pitigeŋ bu aŋsahê Pômdau ndê Ŋalau? Lic su naŋ, lau naŋ sêŋsuhuŋ nam akweŋ dec kwahic sêlhac andu ŋasactô, bu sêmbalaŋ am sa ndi whiŋ.” ");
INSERT INTO buk_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ma ŋagahô ŋambwa awhê dau ku sa yêc Pita gahi-ŋga ma mbac ndu. Ma lau batac sêsôc si ma sêlic bu iŋ mbac ndu su, dec sêkôc iŋ sa si ma sêŋsuhuŋ iŋ whiŋ nakweŋ. ");
INSERT INTO buk_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ma lau sêkêŋ whiŋ-ŋga hoŋ, ti lau ŋatô naŋ sêŋgô gêŋ dau ŋawaê, naŋ hoŋ sêsö ma sêtöc dau ŋandô. ");
INSERT INTO buk_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Têŋ ŋasawa dinaŋ lau aposel sêkôm gêŋ dalô ti gêŋ atu-tu daêsam yêc lau sêkêŋ whiŋ-ŋga si toŋ ŋalôm. Ma lau sêkêŋ whiŋ-ŋga êlêmê sêkac dau sa sêmbo lôm dabuŋ yêc gameŋ naŋ lau sêsam bu Solomon ndê Batêm. ");
INSERT INTO buk_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Lau hoŋ sêlic ŋac ŋayham ma sêtoc ŋac sa, tigeŋ tu lau bata Israel-ŋga dec sêtöc dau bu sêlhac sêwhiŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Magoc lauŋgac ti lauwhê daêsam sic hu sêkêŋ whiŋ Pômdau, dec lau sêkêŋ whiŋ-ŋga si namba kêsôwec tiatu ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tu gêŋ atu-tu naŋ lau aposel sêkôm-ŋga, dec lau sêhoŋ si lau gêmbac sêsa malac lôm sêmeŋ ma sêkêŋ ŋac sêyêc sac ti mbô. Ŋac sêkêŋ bata bu Pita oc êŋsêlêŋ meŋ ma êmasec lau gêmbac me mboe ac kêŋ iŋ ndê gatu nem ayuŋ lau gêmbac ma kôm ŋac ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ma lau daêsam akêŋ malac naŋ sêyêc Jerusalem ŋamakê, naŋ sêhoŋ lau gêmbac ti lau naŋ ŋalau sac sêkôm ŋac sêtisac, naŋ sêmeŋ ma lau aposel sêkôm ŋac hoŋ ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Têŋ dinaŋ dabuŋsiga ŋamata-ŋga ti iŋ ndê lau hoŋ akêŋ Sadiusi si toŋ sem lêmuŋ lau aposel ŋandô. ");
INSERT INTO buk_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Tu dinaŋ-ŋga dec sêkôc ŋac dôŋ ma sêkêŋ ŋac sêndöc gapocwalô. ");
INSERT INTO buk_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tigeŋ têŋ ôbwêc Pômdau ndê aŋela gêlêc andu gapocwalô-ŋga ŋagatam su ma wê ŋac sêsa si. ");
INSERT INTO buk_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Ma iŋ sôm têŋ ŋac bu, “Andi alhac lôm dabuŋ ŋabatêmndö, ma ahoc yom asê timala eŋ têŋ lau, pi lau sêkêŋ whiŋ-ŋga si lêŋ wakuc.” ");
INSERT INTO buk_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Sêŋgô aŋela ndê yom dinaŋ su, dec bêbêc ganduc sêtêŋ lôm dabuŋ si ma sic hu sêndôhôŋ lau. Têŋ ndoc dinaŋ dabuŋsiga ŋamata-ŋga ti iŋ ndê lau sêmbwêc lau bata Sanedrin-ŋga hoŋ sa sêpitigeŋ bu sêmatôc aposel si yom. Goc sêŋkiŋ lau ŋatô sêtêŋ gapocwalô si bu sêkôc lau aposel sa sêmeŋ. ");
INSERT INTO buk_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Magoc têŋ ndoc lau dau sêhôc asê gapocwalô, naŋ sêlic bu aposel aŋgô mba. Goc sêmbu si ma sêsôm bu, ");
INSERT INTO buk_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Yac a alic bu sêŋlahi gatam ahuc ŋapep ma lau sêyob gatam sêlhac. Dec yac alêc gatam su magoc alic bu ŋac sêndöc dom.” ");
INSERT INTO buk_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Lau siŋ sêyob lôm dabuŋ-ŋga si ŋgac bata, ma dabuŋsiga atu-tu sêŋgô yom dau e sêpônda gauc. ");
INSERT INTO buk_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Sêhê gauc sêmbo ma ŋgac daŋ meŋ ma sôm têŋ ŋac bu, “Alic su naŋ! Lauŋgac naŋ mac akêŋ ŋac sêndöc gapocwalô, naŋ kwahic dec sêlhac lôm dabuŋ ŋamakê ma sêndôhôŋ lau sêmbo.” ");
INSERT INTO buk_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Goc lau siŋ-ŋga naŋ sêyob lôm dabuŋ ti ŋac si ŋgac bata sêtêŋ lôm dabuŋ si, ma sêkôc aposel sa sêmeŋ. Ŋac sêwê ŋac malô ma sêŋsahic ŋac dom, ŋahu bu sêtöc dau bu lau naŋ sêtoc aposel sa, naŋ oc sêtuc ŋac ŋa hoc. ");
INSERT INTO buk_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Sêwê aposel sêmeŋ ma sêkêŋ ŋac sêlhac lau Sanedrin-ŋga aŋgô-ŋga bu dabuŋsiga ŋamata-ŋga êŋsu ŋac. ");
INSERT INTO buk_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Iŋ sôm têŋ ŋac bu, “Y ac ac yao mac ŋaŋga bu andôhôŋ lau pi ŋgac dinaŋ ma asôm iŋ ndê ŋaê asê tiyham dom. Magoc mac nem yom pi iŋ gêm Jerusalem ahuc su. Mac bu ahê ŋamalac dinaŋ ndê dac meŋ pi yac, a?” ");
INSERT INTO buk_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Dec Pita ti aposel sêô iŋ awha ma sêsôm bu, “Yac daŋaŋ wambu Anötö ndê yom hôc gêlêc ŋamalac si yom su, ac ŋawaê. ");
INSERT INTO buk_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mac daôm ac Yisu ndu pi a, tigeŋ abaŋi si Anötö uŋ iŋ sa mbo tali tiyham. ");
INSERT INTO buk_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ma Anötö toc iŋ sa ma kêŋ iŋ ndöc iŋ ndê andô-ŋga ti Kiŋ, ma ti Ŋadau Nem Lau Si-ŋga. Iŋ kôm bocdinaŋ, ŋahu bu iŋ bu kêŋ ŋasawa têŋ lau Israel-ŋga bu sêkac si ŋalôm kwi, dec iŋ oc suc ŋac si sac kwi. ");
INSERT INTO buk_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yom dinaŋ yac alic ŋandô su, dec asôm asê. Ma Ŋalau Dabuŋ puŋ yom dau dôŋ bocdinaŋ. Iŋ Ŋalau naŋ Anötö kêŋ têŋ lau naŋ daŋga wambu iŋ ŋapep.” ");
INSERT INTO buk_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Lau bata Israel-ŋga dinaŋ sêŋgô aposel si yom dau e gêli ŋac ŋalôm sa sac andô, ma ŋac tac whiŋ bu sêndic aposel ndu. ");
INSERT INTO buk_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Tigeŋ lau Sanedrin-ŋga si ŋgac bata daŋ tisa bu lhac ŋac ahuc. Iŋ Palêsai daŋ ŋaê Gamaliel, naŋ kêdôhôŋ yomsu, ma lau hoŋ sêtoc iŋ sa. Iŋ gic atu yom bu sêkêŋ aposel sêsa awê sêndi sêmbo ŋasawa sauŋ. ");
INSERT INTO buk_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Goc iŋ sôm têŋ lau bata hoŋ, “Mac lau Israel-ŋga, akôc gauc ŋapep pi gêŋ naŋ mac bu akôm têŋ lau dinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Gauc nem Teudas, ŋgac naŋ ŋasawa apê gi su toc dau sa bu ŋgac tiwaê. Magoc lau siŋ Rom-ŋga sic iŋ ndu, ma lau 400 naŋ sêmbo sêwhiŋ iŋ, naŋ sêmbulu ŋac sêlhö têŋtêŋ si. Ma iŋ ndê gweleŋ hoŋ hê su. ");
INSERT INTO buk_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ma têŋ têm sêsê lau sa tu bu sênemlhi takis-ŋga, naŋ ŋgac Galili-ŋga daŋ ŋaê Judas tisa. Iŋ gêli lau toŋ daŋ sa bu sêkêŋ kisa lau Rom-ŋga. Magoc iŋ giŋga bocdinaŋ, ma iŋ ndê lau hoŋ sêlhö têŋtêŋ. ");
INSERT INTO buk_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Bocdinaŋ kwahic dec aö b u wasôm aneŋ ŋalôm asê têŋ mac. Ahu lau aposel dindê siŋ ma akêŋ ŋac sêlhö sêndi. Ŋac si gweleŋ bu meŋ akêŋ ŋamalac ŋambwa si, gitôm Teudas lu Judas si gweleŋ, dec oc tôm dom bu nem ŋandô. ");
INSERT INTO buk_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Tigeŋ ŋac si gweleŋ bu meŋ akêŋ Anötö ndê, dec oc atôm dom bu alhac ŋac ahuc. Ma mac bu akêŋ kisa ŋac, dec mac oc akêŋ kisa Anötö dau.” ");
INSERT INTO buk_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Lau bata hoŋ sêŋgô iŋ ndê yom ma sêsôc ŋapu. Ŋac sêmbwêc aposel sêsôc sêmeŋ ma sêkêŋ lau siŋ-ŋga sêhi ŋac ŋa sö. Ma sêkêŋ yao bu sênem mêtê pi Yisu tiyham dom, goc sêkêŋ ŋac sêsa si. ");
INSERT INTO buk_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aposel sêhu lau bata Sanedrin-ŋga siŋ, ma sêsa si ti atac ŋayham atu. Ŋahu bu Anötö kêŋ ŋac sêhôc ŋawapac ti ŋandê tu Yisu ndê ŋaê-ŋga, dec toc ŋac sa. ");
INSERT INTO buk_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ma tôm bêc hoŋ sêndôhôŋ lau sêmbo lôm dabuŋ ŋabatêmndö, ma sêndôhôŋ lau sêlom-sêlom andu. Ma sêhoc ŋawaê ŋayham asê ŋapaŋ ma sêsôm bu Yisu iŋ Mesaya dau. ");
INSERT INTO buk_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Lau sêkêŋ whiŋ Yisu-ŋga si toŋ kêsôwec ŋapaŋ. Magoc têŋ têm dinaŋ ŋawapac daŋ hôc asê. Yêc toŋ dau ŋalôm lau Israel-ŋga naŋ sêsôm lau Grik awha, naŋ sêtucdiŋ lau Israel-ŋga naŋ sêsôm Yom †Hibru. Ŋahu bu tôm bêc hoŋ lau sic sam gêŋ daneŋ-ŋga têŋ lau naŋ sêpônda dau, magoc tandô toŋ lauwhê sawa naŋ sêsôm Yom Grik. ");
INSERT INTO buk_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tu dinaŋ-ŋga aposel 12 sêmbwêc lau sêkêŋ whiŋ-ŋga hoŋ sêpitigeŋ, ma sêsôm, “Yham dom bu yac ahu Anötö ndê gweleŋ ŋawaê ŋayham-ŋga siŋ tu ayob gweleŋ andic sam gêŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Bocdinaŋ asidôwai, aŋyaliŋ lauŋgac 7 sa yêc toŋ dindec ŋalôm, naŋ lau tigauc ma Ŋalau Dabuŋ gêm ŋac ahuc. Ma lau dinaŋ yac oc dakêŋ ŋac sêyob gweleŋ dindec. ");
INSERT INTO buk_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ma yac dauŋ oc akôm gweleŋ anem mêtê ti ateŋ mbec-ŋga ŋapaŋ.” ");
INSERT INTO buk_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Lau hoŋ sêŋgô ŋac si gauc dinaŋ ma sêlic ŋayham. Bocdinaŋ ŋac sêŋyaliŋ lau 7 sa, naŋ si ŋaê bocdec. Steven, iŋ ŋgac naŋ Ŋalau Dabuŋ gêm iŋ ahuc ma kêŋ whiŋ ŋaŋga, ma Pilip, Prokoras, Nikanor, Timon, Pamenas, ma Nikolas naŋ ndê malachu Antiok. Nikolas iŋ ŋgac Israel-ŋga dom, magoc muŋ-ŋga iŋ gêm dau kwi ma gêm akiŋ Anötö kêkuc lau Israel-ŋga si sakiŋ akwa. ");
INSERT INTO buk_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ŋac sêkêŋ lau 7 dau sêlhac aposel aŋgô-ŋga, ma aposel sêteŋ mbec ma sêkêŋ amba sac ŋac. ");
INSERT INTO buk_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Têŋ ŋasawa dinaŋ Anötö ndê mêtê tiapa, ma lau Jerusalem-ŋga daêsam sêkêŋ whiŋ Yisu. Ma dabuŋsiga Israel-ŋga daêsam sêkêŋ whiŋ bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Steven iŋ ŋgac naŋ Anötö ndê mwasiŋ ti ŋaclai gêm iŋ ahuc, ma kôm gêŋ atu-atu ti gêŋ dalô mbo lau ŋalôm. ");
INSERT INTO buk_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Magoc lau akêŋ lau Israel-ŋga si toŋ daŋ sic hu sêkêŋ kisa iŋ. Ŋac lau dinaŋ sêmeŋ akêŋ malac Sairin ti Aleksandria ma akêŋ gameŋ Silisia ti Esia-ŋga. Muŋ-ŋga ŋac lau akiŋ ŋambwa, magoc tiŋambu si ŋadaui sêhu ŋac siŋ yêc si sakiŋ, ma êlêmê sêkac sa sêmbo dau si lôm wê-ŋga daŋ. Ŋac sêpu Steven ti iŋ ndê yom. ");
INSERT INTO buk_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Magoc tu Steven ndê gauc ti yom naŋ Ŋalau Dabuŋ kêŋ têŋ iŋ-ŋga, dec ŋac sêtôm dom bu sêku iŋ ndê yom dulu. ");
INSERT INTO buk_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tu dinaŋ-ŋga ŋac sêkôc lau ŋatô ma sêkic yom gelec sêwhiŋ ŋac, bu ŋac oc sêtisa ma sêŋgôliŋ yom pi Steven bocdec bu, “Yac aŋgô Steven sôm yom sac-sac pi Moses ma pi Anötö.” ");
INSERT INTO buk_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Goc ŋac sêsôm yom dau e gêli lau hoŋ si ŋalôm sa, ma lau bata ti lau naŋ sêndôhôŋ yomsu-ŋga sêwhiŋ. Goc sêkôc iŋ dôŋ ma sêwê iŋ e sêkêŋ iŋ kalhac lau Sanedrin-ŋga si aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Goc sêkêŋ lau tasaŋ ŋatô sêtisa ma sêsôm, “Iŋ ŋgac dindec sôm yom ŋapaŋ bu êŋgwiniŋ yac neŋ lôm dabuŋ ma Anötö ndê yomsu. ");
INSERT INTO buk_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Yac aŋgô iŋ sôm bu Yisu Nasaret-ŋga oc seŋ gameŋ dindec su, ma kêŋ ŋagôliŋ wakuc ô mêtê naŋ Moses gic dulu têŋ yac.” ");
INSERT INTO buk_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Têŋ dinaŋ lau hoŋ naŋ sêndöc Sanedrin si toŋ, naŋ tahê Steven, ma sêlic bu iŋ ndê aŋgô andô ŋawasi gitôm aŋela daŋ ndê. ");
INSERT INTO buk_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ma dabuŋsiga ŋamata-ŋga ndac iŋ bu, “Yom dindec naŋ sêŋgôliŋ pi am, naŋ yom ŋandô, me mba?” ");
INSERT INTO buk_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ma Steven ô yom ma sôm, “Asidôwai ti damaŋi. Aŋgô su naŋ! Muŋ-ŋga lê abaŋ Abraham ndöc Mesopotemia, iŋ têŋ malac Haran gi su dom, ma Anötö Ŋawê Ŋadau hoc dau asê têŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ma sôm têŋ iŋ, ‘Hu nem gameŋ ti am nem lau siŋ, ma têŋ gameŋ daŋ naŋ aö bu watôc têŋ am, naŋ ndi.’ ");
INSERT INTO buk_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Bocdinaŋ iŋ hu lau Saldi si gameŋ siŋ, ma sa gi ndöc Haran. Tiŋambu iŋ damba mbac ndu su, goc Anötö kêkiŋ Abraham bu têŋ gameŋ dindec naŋ kwahic dec mac andöc, naŋ meŋ. ");
INSERT INTO buk_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Tigeŋ iŋ kêŋ nom têŋ Abraham wêkaiŋ yêc gameŋ dindec dom. Mba, Abraham dau tap nom sauŋ daŋ sa dom! Têŋ ndoc dinaŋ Abraham ndê balêkoc mba, magoc Anötö kêmatiŋ yom tidôŋ têŋ iŋ, bu iŋ ti iŋ ndê lau wakuc oc sêwêkaiŋ gameŋ dau. ");
INSERT INTO buk_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ma Anötö sôm têŋ iŋ bu, ‘Am nem wakuc oc sêhu gameŋ dindec siŋ ma sêndöc sêtôm lau apa yêc lau daŋ si gameŋ. Ma ŋac oc sênem akiŋ lau dau, ma lau dau oc sêkôm ŋac ŋayom nditôm yala 400. ");
INSERT INTO buk_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Magoc tiŋambu aö oc wakêŋ ŋagêyô têŋ lau gameŋ dinaŋ-ŋga naŋ sem akiŋ ŋac, ma am nem wakuc oc sêhu gameŋ dinaŋ siŋ ma sêmbu sêmeŋ sênem akiŋ aö yêc gameŋ dindec.’ ");
INSERT INTO buk_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ma Anötö kêŋ †pwac sêsê lauŋgac si ŋamlic ŋatô su-ŋga têŋ Abraham. Tiŋambu Abraham kwê ndê atuŋgac Aisak asê, ma sê iŋ ndê ŋamlic ŋatô su têŋ iŋ ndê bêc ti-8-ŋga. Aisak dau kwê Jakob asê, ma Jakob kwê yac neŋ abaŋi 12 asê, naŋ sêti yac neŋ gôlôwac Israel-ŋga toŋ 12 si ŋahu. ");
INSERT INTO buk_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Josep iŋ abaŋi 12 si daŋ, magoc dôwai sem lêmuŋ iŋ, dec sêkêŋ iŋ têŋ lau semlhi. Ma lau dau sêkôc iŋ sa sêsip gameŋ Isip-ŋga si, ma iŋ mbo gameŋ dinaŋ tôm ŋgac akiŋ ŋambwa daŋ. Magoc Anötö mbo whiŋ Josep, ");
INSERT INTO buk_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","dec gêm iŋ si yêc ŋawapac bocke naŋ tap iŋ sa. Iŋ kêŋ gauc ŋayham-ŋayham têŋ iŋ dec lau Isip-ŋga si kiŋ Parao gêlic iŋ ŋayham, ma kêŋ iŋ gêm gôliŋ gêŋ hoŋ yêc iŋ ndê andu kiŋ-ŋga, ma gameŋ Isip-ŋga sambuc. ");
INSERT INTO buk_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Tiŋambu tôbôm gêm Isip ma Kanan ahuc e lau sêhôc ŋawapac atu, ma abaŋi sêpônda gêŋ sêneŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jakob ŋgô ŋawaê bu gêŋ daneŋ-ŋga yêc Isip, dec kêkiŋ ndê atui sêsip Isip si. Têm ŋamata-ŋga dinaŋ sêsip si ma semlhi gêŋ daneŋ-ŋga, ma sêmbu sêmeŋ. ");
INSERT INTO buk_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Tiŋambu iŋ kêkiŋ ŋac sêsip Isip si tiyham, ma têŋ dinaŋ Josep sôm dau asê têŋ ndê asidôwai, ma Parao ŋgô ŋawaê pi Josep ndê gôlôwac. ");
INSERT INTO buk_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Goc Josep kêkiŋ yom têŋ iŋ damba Jakob ti iŋ ndê lau ŋatô, bu ŋac hoŋ sêsip Isip sêtêŋ iŋ sêndi. Ŋac lau dinaŋ lau 75. ");
INSERT INTO buk_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Bocdinaŋ Jakob ti yac neŋ abaŋi sêsip Isip si, ma sêndöc e sêmbac ndu sêyêc gameŋ dinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ma tiŋambu ŋac si lau wakuc sêkôc ŋac si ŋakwa su yêc Isip bu sêŋsuhuŋ ŋac yêc malac Sekem, sêyêc sêhô naŋ Abraham gêmlhi su yêc Hamo ndê atui. ");
INSERT INTO buk_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Tiŋambu, ndoc meŋ kêpiŋ bu yom naŋ Anötö gic bata têŋ Abraham, naŋ ŋandô sa. Têŋ têm dinaŋ lau Israel-ŋga naŋ sêndöc Isip, naŋ sêti daêsam ŋandô. ");
INSERT INTO buk_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Magoc kiŋ wakuc daŋ gêm gôliŋ Isip, naŋ kêyalê Josep dom. ");
INSERT INTO buk_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Iŋ yob yac neŋ abaŋi solop dom, ma kêŋ ŋawapac atu têŋ ŋac. Iŋ gic yomsu ŋac bu sêmbaliŋ balêkoc wakuc hoŋ siŋ sêniŋga. ");
INSERT INTO buk_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Têŋ ndoc dinaŋ Moses dinda kôc iŋ, ma Anötö gêlic iŋ ŋayham. Ŋac sêlôm iŋ sêmbo damba ndê andu gitôm ayô tö. ");
INSERT INTO buk_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Tiŋambu sêkôc iŋ sa si ma sêsiŋ iŋ, ma malô goc Parao ndê atuwê tap iŋ sa ma gôlôm iŋ ti ndê balêkoc. ");
INSERT INTO buk_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ma bocdinaŋ dec Moses sôc lôm bapia ma kêdôhôŋ lau Isip-ŋga si gauc hoŋ. Ma iŋ ti ŋgac ŋaŋga tu sôm yom ma kôm gweleŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Iŋ mbo e iŋ ndê yala ti 40 su, ma bêc daŋ iŋ gauc gêm bu sa ndi lic ndê asidôwai Israel-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Têŋ ndoc dinaŋ iŋ gêlic ŋgac Isip-ŋga daŋ kôm ŋgac Israel-ŋga daŋ ŋayom. Dec iŋ gic ŋgac Isip-ŋga dinaŋ ndu bu nem iŋ ndê asidôwa dinaŋ si. ");
INSERT INTO buk_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Iŋ gauc gêm bu mboe iŋ ndê asidôwai oc sêŋyalê bu Anötö kêyaliŋ iŋ sa bu nem ŋac sa, magoc mba. Ŋac sem gauc. ");
INSERT INTO buk_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ŋagalaŋsê iŋ sa gi tiyham ma gêlic Israel lu sic dau sêmbo. Iŋ bu nem malô iŋlu, dec sôm, ‘Amlu asidôwa, ma tu sake-ŋga dec akêŋ kisa daôm?’ ");
INSERT INTO buk_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Magoc ŋgac lu dau si daŋ, naŋ bu kôm ndê asidôwa tisac, naŋ suc Moses sa gi, ma sôm, ‘Asa kêŋ am bu nem gôliŋ ma êmatôc yac? ");
INSERT INTO buk_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Bocke? Am bu ndic aö ndu gitôm am gic ŋgac Isip-ŋga daŋ têŋ alhabêc, a?’ ");
INSERT INTO buk_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","“Têŋ ndoc Moses ŋgô yom dinaŋ, naŋ iŋ kölhö têŋ gameŋ Midian-ŋga gi, ma ndöc dinaŋ gitôm ŋgac apa. Ma yêc dinaŋ iŋ gêm awhê sa ma kwê balêkoc ŋgac lu asê. ");
INSERT INTO buk_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Yala 40 giŋga su, goc aŋela daŋ hoc dau asê têŋ iŋ ŋalêŋ bocdec. Moses mbo Lôc †Sainai yêc gameŋ sawa, ma gêlic ya ŋawahô golom sa a sauŋ daŋ. ");
INSERT INTO buk_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Gêŋ dau kôm iŋ sö ma gauc gêm yom daêsam. Iŋ tigasuc gi bu lic gêŋ dau, dec ŋgô Pômdau awha sa têŋ iŋ meŋ bocdec bu, ");
INSERT INTO buk_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Am apami Abraham lu Aisak ma Jakob si Anötö aö.’ Moses ŋgô yom dau e kêtitec ŋandô ma töc dau bu hôc tandô sa ma lic tiyham. ");
INSERT INTO buk_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Goc Pômdau sôm têŋ iŋ, ‘Kôc nem atapa su yêc gahim, bu gameŋ naŋ am kalhac, naŋ gameŋ dabuŋ. ");
INSERT INTO buk_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Aö galic su bu aö neŋ lau sêmbo sac yêc Isip. Aö gaŋgô ŋac si daŋgi, madec gasip gameŋ bu waŋgaho ŋac su yêc ŋawapac dau. Bocdinaŋ kwahic dec aö oc waŋkiŋ am mbu têŋ Isip ndi.’” ");
INSERT INTO buk_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Steven gic miŋ yom dinaŋ, goc sôm, “Aö wasôm têŋ mac, bu Moses iŋ ŋgac dau, naŋ muŋ-ŋga lau Israel-ŋga sêtec iŋ ti sêsôm iŋ bocdec bu, ‘Asa kêŋ am bu nem gôliŋ ti êmatôc yac?’ Tigeŋ Anötö dau ndê aŋela hoc dau asê têŋ iŋ yêc a sauŋ dinaŋ, ma kêkiŋ iŋ bu nem gôliŋ lau Israel-ŋga ma kôc ŋac su yêc gameŋ Isip-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Bocdinaŋ iŋ kôc ŋac sêsa akêŋ Isip sêmeŋ. Têŋ ndoc dinaŋ iŋ kôm gêŋ dalô ti gêŋ atu-tu daêsam yêc gameŋ Isip-ŋga, ma yêc gwêc naŋ sêsam bu Gwêc Koc. Ma iŋ kôm gêŋ dalô tidau-tidau yêc gameŋ sawa tôm yala 40. ");
INSERT INTO buk_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Iŋ Moses dau dinaŋ goc sôm têŋ lau Israel-ŋga bu, ‘Anötö oc tôc ŋgac daŋ yêc mac nem toŋ ŋalôm, ti propet nditôm aö dauŋ.’ ");
INSERT INTO buk_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moses mbo whiŋ lau Israel-ŋga têŋ ndoc sêmbo gameŋ sawa. Iŋ kalhac aŋela naŋ sôm yom têŋ iŋ yêc Lôc Sainai, ma yac neŋ abaŋi ŋalhu, bu kôc Pômdau ndê yom dandöc taŋli-ŋga ma kêŋ têŋ lau Israel-ŋga. Ma lau dau sic yom dau dulu e meŋ têŋ yac. ");
INSERT INTO buk_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Magoc yac neŋ abaŋi sêtec bu sêsôc iŋ ŋapu. Ŋac sêpu iŋ ma ŋac si ŋalôm gauc gêm gameŋ Isip-ŋga ŋapaŋ, e ŋac atac whiŋ bu sêmbu sêndi. ");
INSERT INTO buk_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Têŋ ndoc Moses mbo Lôc Sainai ŋasawa baliŋ, naŋ ŋac sêsôm têŋ Aron bu, ‘Iŋ ŋgac Moses dinaŋ, kôc yac sa asa yêc Isip ameŋ, ma kwahic dec yac am gauc gêŋ bocke hôc asê iŋ. Bocdinaŋ êmasaŋ anötöi gwam bu sêwê yac.’ ");
INSERT INTO buk_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Têŋ ndoc dinaŋ ŋac sêmasaŋ makao ŋagatu ti gwam, goc sêndê mwasiŋ atu daŋ tu bu sêtoc gêŋ dau sa-ŋga. Ŋac sêkêŋ da têŋ gwam dau, ma atac ŋayham kêlêc pi gêŋ naŋ ŋac dau amba sêmasaŋ. ");
INSERT INTO buk_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tu dinaŋ-ŋga dec Anötö puc dômbwê ŋac ma hu ŋac siŋ bu sênem akiŋ tata ti gêŋ umboŋ-ŋga. Lau propet sêto yom pi ŋac si mêtê dau bocdec bu: O mac lau Israel-ŋga. Yala 40 dinaŋ mac ambo gameŋ sawa, naŋ mac akêŋ nem gêŋ daŋ ti da têŋ aö dom. Mba! ");
INSERT INTO buk_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mac êlêmê ambalaŋ bac po daŋ tu anem akiŋ mac nem anötö tasaŋ Molek-ŋga. Ma mac am akiŋ tata daŋ ŋaê Repa ti mac nem anötö, ma apôŋ hamduc têŋ anötöi gwam daêsam naŋ mac amasaŋ. Tu dinaŋ-ŋga aö watiŋ mac su andi andöc gameŋ Babilon-ŋga ŋadaŋga tôm lau gapocwalô-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Yêc gameŋ sawa, Anötö whê sa ti tôc lêŋ têŋ Moses bu lau Israel-ŋga sêmasaŋ †bac dabuŋ daŋ ti ŋac si gameŋ sênem akiŋ iŋ-ŋga, naŋ sêkêŋ †apa yomsu-ŋga yêc ŋalôm. Iŋ kêmasaŋ gêŋ dau tôm Anötö tôc asê têŋ iŋ, ma abaŋi sêmbalaŋ gêŋ dau whiŋ ŋac, têŋ ndoc ŋac sêŋsêlêŋ si. ");
INSERT INTO buk_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ŋalêŋ dau dinaŋ Anötö kêŋ ndê bac dabuŋ têŋ lau Israel-ŋga yêc gameŋ sawa. Tiŋambu Anötö soc lau naŋ sêndöc gameŋ Kanan-ŋga su, bu kêŋ gameŋ dau têŋ ŋac. Ma têŋ ndoc Josua wê ŋac sêsôc gameŋ Kanan-ŋga si, naŋ sêmbalaŋ bac dabuŋ dau whiŋ ŋac. Ma bac dau kalhac whiŋ ŋac e Dawid ndê têm. ");
INSERT INTO buk_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Anötö gêlic Dawid ŋayham, ma Dawid tac whiŋ bu kwê lôm daŋ sa ti Jakob ndê Anötö ndê andu ŋandô. ");
INSERT INTO buk_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Magoc Dawid kwê andu dau dom, iŋ ndê atuŋgac Solomon kwê andu dau sa. ");
INSERT INTO buk_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Tigeŋ kwahic dec aö wasôm têŋ mac bu Anötö Ŋaclai ti Ŋawasi Ŋadau, iŋ ndöc andu naŋ ŋamalac sêkwê, naŋ dom. Tôm yom naŋ propet Aisaya to bocdec bu: ");
INSERT INTO buk_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Pômdau sôm, ‘Undambê ti aneŋ pôŋ kiŋ-ŋga, ma gameŋ nom-ŋga ti gameŋ gahiŋ lhac-ŋga. Bocdinaŋ mac oc akwê andu kaiŋ bocke tu bu wandöc-ŋga? Me amasaŋ gameŋ bocke tu waŋwhaŋ dauŋ-ŋga? ");
INSERT INTO buk_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Bu aö dauŋ gakêŋ gêŋ hoŋ dinaŋ.’” ");
INSERT INTO buk_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Têŋ dinaŋ Steven sôm têŋ ŋac lau Sanedrin-ŋga bu, “Mac lau ŋalôm ŋadandi-ŋga. Mac am daôm kwi dom, ma mac nem daŋamsuŋ kwa ŋaŋga. Mac nem mêtê gitôm apami si. Mac êlêmê atec Ŋalau Dabuŋ ndê gweleŋ. ");
INSERT INTO buk_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mac nem apami sêkêŋ kisa propet hoŋ naŋ Anötö kêkiŋ. Ma propet naŋ sêhoc yom asê pi ŋgac gitêŋ nem lau si-ŋga naŋ Anötö oc êŋkiŋ meŋ, naŋ apami sic ŋac ndu. Ŋgac gitêŋ dau meŋ su, magoc mac akêŋ iŋ sip lau Rom-ŋga amba ma ac iŋ ndu. ");
INSERT INTO buk_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","O mac lau daôm! Mac daôm akôc Anötö ndê yomsu naŋ aŋela sêkêŋ têŋ abaŋi, naŋ su, tigeŋ asôc ŋapu dom!” ");
INSERT INTO buk_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Têŋ ndoc lau Sanedrin-ŋga sêŋgô Steven ndê yom dinaŋ, naŋ ŋac atac ŋandê atu ma sêseŋ lhô tu iŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Magoc Ŋalau Dabuŋ gêm Steven dau ahuc, ma iŋ tatac undambê ma gêlic Anötö ndê ŋawasi, ma Yisu kalhac Anötö amba andô-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Dec iŋ sôm, “Alic su naŋ! Aö galic undambê kac sa ma †Ŋamalac ndê Atu kalhac Anötö ndê amba andô-ŋga.” ");
INSERT INTO buk_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ŋac sêŋgô yom dinaŋ goc sêpôc daŋgasuŋ ahuc, ma sêmbwêc atu pi gi. Ŋac sênti sêtêŋ iŋ si, ");
INSERT INTO buk_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ma sêtiŋ iŋ sa malac ŋamakê gi, ma sic hu sêtuc iŋ ŋa hoc. Lau naŋ sêŋgôliŋ yom pi Steven, naŋ sêkac si ŋakwê bambaliŋ su, ma sêkêŋ têŋ ŋgac wakuc daŋ ŋaê Saul bu yob. ");
INSERT INTO buk_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ŋac sêtuc hoc pi Steven sêmbo, ma iŋ teŋ mbec têŋ Pômdau bocdec, “O Pômdau Yisu, kôc aneŋ gatuŋ sa loc.” ");
INSERT INTO buk_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Goc iŋ peŋ ŋa haduc-ŋga sip gi ma mbwêc atu bu, “Pômdau, gauc nem sac naŋ lau sêkôm têŋ aö, naŋ dom.” Iŋ sôm su, goc mbac ndu. ");
INSERT INTO buk_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Saul gêlic Steven mbac ndu ma atac ŋayham tu gêŋ naŋ lau dau sêkôm têŋ iŋ-ŋga. Ma tiŋambu lau sêkêŋ whiŋ ŋaŋga-ŋga ŋatô sêŋsuhuŋ Steven ma sêtaŋ iŋ. Têŋ bêc dau dinaŋ lau sic hu sêkêŋ kisa ŋaŋga têŋ lau sêkêŋ whiŋ-ŋga naŋ sêmbo Jerusalem. Tu dinaŋ-ŋga ŋac si lau daêsam sêhu Jerusalem siŋ ma sêlhö têŋtêŋ sêtêŋ gameŋ Judia ti Samaria-ŋga si. Magoc lau aposel sêhu Jerusalem siŋ dom. ");
INSERT INTO buk_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ma Saul bocdinaŋ gic hu bu seŋ lau sêkêŋ whiŋ Yisu-ŋga. Iŋ kêsalê ŋac tôm andu, goc hê ŋac sêsa si ma kêŋ ŋac sêndöc gapocwalô, lauŋgac sêkêŋ whiŋ-ŋga, ma lauwhê bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Lau sêkêŋ whiŋ-ŋga naŋ sêhu Jerusalem siŋ ma sêlhö têŋtêŋ, naŋ sêhoc ŋawaê ŋayham pi Yisu asê, yêc malac hoŋ naŋ sêhôc asê naŋ. ");
INSERT INTO buk_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilip têŋ malac atu daŋ yêc gameŋ Samaria-ŋga gi, ma gêm mêtê yêc dindê ma whê sa bu Yisu iŋ Mesaya dau. ");
INSERT INTO buk_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Lau daêsam sêŋgô Pilip ndê yom ti sêlic gêŋ dalô naŋ iŋ kôm, dec sêkêŋ daŋga iŋ ndê yom ŋapep. ");
INSERT INTO buk_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pilip soc ŋalau sac daêsam su sêsa yêc lau ti sêmbwêc atu. Ma iŋ kôm lau bôliŋ daêsam ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tu dinaŋ-ŋga lau daêsam yêc malac atu dinaŋ atac ŋayham atu. ");
INSERT INTO buk_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ŋgac daŋ mbo malac dinaŋ, naŋ ndê ŋaê Saimon. Tôm ŋasawa baliŋ iŋ pec balö ti kôm gêŋ atu-tu e lau gameŋ Samaria-ŋga hoŋ sêhêdaê. Iŋ toc dau sa bu iŋ ŋgac tiwaê. ");
INSERT INTO buk_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","L au atu-tu ma lau ŋambwa hoŋ tatiŋ Saimon ŋapaŋ. Ŋac sêsôm, “Anötö ndê ŋaclai naŋ dasam bu Ŋaŋga Atu, naŋ puc ŋgac dindec dôŋ.” ");
INSERT INTO buk_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ma lau daêsam tatiŋ iŋ ŋapaŋ, bu sêhêdaê tu gêŋ atu-tu naŋ iŋ kôm ŋasawa hic su naŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Magoc sêhu siŋ têŋ ndoc sêŋgô ŋawaê ŋayham pi Anötö ndê gôliŋ ma pi Yisu Kilisi, naŋ Pilip hoc asê. Lauŋgac ti lauwhê daêsam sêkêŋ whiŋ iŋ ndê yom, ma sêliŋ saŋgu. ");
INSERT INTO buk_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ma Saimon dau kêŋ whiŋ ma gêliŋ saŋgu whiŋ. Iŋ gêlic gêŋ dalô ti gêŋ atu-tu naŋ Pilip kôm, dec hêdaê ŋandô ma kêkuc iŋ ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Têŋ ndoc lau aposel naŋ sêmbo Jerusalem sêŋgô ŋawaê bu lau Samaria-ŋga sêkôc Anötö ndê yom sa, naŋ sêŋkiŋ Pita lu Jon sêtêŋ ŋac si. ");
INSERT INTO buk_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Iŋlu sêhôc asê ŋac su, goc sêteŋ mbec bu Pômdau kêŋ ndê Ŋalau Dabuŋ pi ŋac hoŋ. ");
INSERT INTO buk_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Têŋ ndoc lau Samaria-ŋga dinaŋ sêkêŋ whiŋ, naŋ sêliŋ saŋgu tu Pômdau Yisu ndê ŋaê-ŋga, magoc Ŋalau Dabuŋ sip meŋ pi ŋac si daŋ dom. Tu dinaŋ-ŋga dec Pita lu Jon sêteŋ mbec pi ŋac. ");
INSERT INTO buk_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Sêteŋ mbec su ma sêkêŋ amba sac ŋac, goc Ŋalau Dabuŋ meŋ gêm ŋac ahuc. ");
INSERT INTO buk_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimon gêlic bu têŋ ndoc aposel lu sêkêŋ amba sac lau dau, naŋ Ŋalau Dabuŋ meŋ pi ŋac, dec gauc gêm bu nemlhi ŋaclai dau yêc iŋlu. ");
INSERT INTO buk_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Iŋ ndac iŋlu bocdec bu, “Akêŋ ŋaclai dinaŋ lom aö. Ma bocdinaŋ asa naŋ bu wakêŋ amaŋ sac iŋ, naŋ oc kôc Ŋalau Dabuŋ.” ");
INSERT INTO buk_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Magoc Pita ô yom ma sôm, “Bocke? Am gauc gêm bu nemlhi Anötö ndê mwasiŋ ŋa mone, a? Am oc niŋam, ti nem mone hoŋ! ");
INSERT INTO buk_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Am wêkaiŋ gweleŋ dindec whiŋ yac dom. Ŋahu bu gauc naŋ yêc am nem ŋalôm, naŋ Anötö gêlic bu solop dom. ");
INSERT INTO buk_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kac nem ŋalôm kwi ma hu mêtê sac dinaŋ siŋ. Ma teŋ mbec têŋ Pômdau bu suc am nem giso kwi pi gauc sac naŋ yêc nem ŋalôm. ");
INSERT INTO buk_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Aö galic su bu am gêm lêmuŋ Anötö ndê ŋaclai e am ŋalôm gêli sa, ma sac ŋa-ŋaclai sô am dôŋ ŋapaŋ.” ");
INSERT INTO buk_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Saimon ŋgô Pita ndê yom dinaŋ, goc sôm, “Gitôm bu am teŋ mbec têŋ Pômdau tu aö-ŋga, ma bocdinaŋ gêŋ naŋ am sôm yom pi, naŋ oc tap aö sa dom.” ");
INSERT INTO buk_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pita lu Jon sêhoc Pômdau ndê yom asê ti sem mêtê lau su, goc sêlhö bu sêmbu sêtêŋ Jerusalem sêndi. Ma yêc seŋ ŋasawa, naŋ sêsôm ŋawaê ŋayham asê yêc malac daêsam naŋ sêyêc gameŋ Samaria-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Têŋ ndoc dinaŋ Pômdau kêkiŋ ndê aŋela daŋ têŋ Pilip gi, ma sôm têŋ iŋ bu, “Êmasaŋ daôm, goc sa ndi ma êmsêlêŋ êmkuc seŋ akêŋ Jerusalem naŋ sip têŋ malac Gasa, seŋ naŋ gic gameŋ sawa kic.” ");
INSERT INTO buk_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Bocdinaŋ Pilip tisa ma kêsêlêŋ gi. Ma yêc seŋ dinaŋ iŋ tap ŋgac Itiopia-ŋga daŋ sa, naŋ bêc ŋatô su mbo Jerusalem bu lic om, ma bu mbu têŋ ndê gameŋ ndi. Iŋ ŋgac tiwaê naŋ yob lau Itiopia-ŋga si Kwin Kandis ndê awa hoŋ, naŋ muŋ-ŋga sêsip iŋ ndê ŋamatu sa. ");
INSERT INTO buk_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Têŋ ndoc Pilip tap iŋ sa yêc seŋ, naŋ ŋgac dau ndöc ndê kaleta, ma sam propet Aisaya ndê buku. ");
INSERT INTO buk_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Dec Ŋalau Dabuŋ sôm têŋ Pilip, “Am tigasuc kaleta ma êmkuc ŋgac dindê.” ");
INSERT INTO buk_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Goc Pilip kêti têŋ kaleta gi ma ŋgô bu ŋgac dau sam propet Aisaya ndê yom asê. Dec Pilip ndac iŋ, “Am sam yom dinaŋ ma kêyalê ŋahu, me mba?” ");
INSERT INTO buk_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ma iŋ sôm, “Ŋamalac daŋ bu whê sa têŋ aö dom, dec oc waŋyalê bocke?” Ma iŋ ndac Pilip bu pi kaleta ma ndöc whiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Iŋ ŋgô bu ŋgac dau sam Aisaya ndê yom bocdec bu: Ŋac sêwê iŋ bu sêndic iŋ ndu gitôm domba. Ma iŋ gêm dau dôŋ tôm domba naŋ sêŋgapiŋ ŋamliclhu, magoc taŋ dom. ");
INSERT INTO buk_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ŋac sêŋgwiniŋ iŋ, ma sêmatôc iŋ ndê yom gi solop dom. Ŋac sic iŋ ndu, ma bocdinaŋ iŋ ndê wakuc mba. ");
INSERT INTO buk_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ma ŋgac dau ndac Pilip, “Gitôm bu am whê sa têŋ aö bu propet sôm yom dinaŋ pi iŋ dau, me pi ŋamalac daŋ?” ");
INSERT INTO buk_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Goc Pilip whê yom hoŋ sa têŋ iŋ, gic hu yêc Aisaya ndê yom dinaŋ e sôm ŋawaê ŋayham pi Yisu têŋ iŋ. Ma ŋgac dau kêŋ whiŋ Yisu. ");
INSERT INTO buk_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Ŋac si e sêhôc asê bu daŋ poc seŋ ŋamakê. Ma ŋgac dau sôm, “Lic bu dê poc. Gitôm bu aö waliŋ busaŋgu, me mba?” ");
INSERT INTO buk_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Goc iŋ sôm têŋ ŋgac naŋ gêm gôliŋ kaleta bu kêŋ kaleta lhac. Ma iŋlu Pilip sêsip bu si ma Pilip kêku iŋ. ");
INSERT INTO buk_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Têŋ ndoc naŋ sêpi akêŋ bu sêmeŋ, naŋ Pômdau ndê Ŋalau kôc Pilip su sep tigeŋ. Ma ŋgac dau gêlic iŋ tiyham dom, magoc kölhö ti atac ŋayham gi. ");
INSERT INTO buk_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ma Ŋalau kôc Pilip sa gi kêŋ iŋ mbo malac Asotas. Ma iŋ kêsêlêŋ golom-golom malac, ma sôm ŋawaê ŋayham asê e hôc asê malac Sisaria. ");
INSERT INTO buk_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Têŋ ŋasawa dinaŋ Saul kêŋ kisa lau sêkêŋ whiŋ Pômdau-ŋga ŋapaŋ. Iŋ sôm ŋaŋga bu iŋ oc kôm ŋac ŋayom ma ndic ŋac ndu. Iŋ têŋ dabuŋsiga ŋamata-ŋga gi, ");
INSERT INTO buk_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ma ndac iŋ bu to bapia puc iŋ dôŋ-ŋga, bu tôc têŋ lau bata naŋ sêyob lau Israel si lôm wê-ŋga yêc malac Damaskas. Bapia dau kêŋ ŋaclai têŋ Saul bu kôc lauŋgac ti lauwhê Damaskas-ŋga naŋ sêkêŋ whiŋ Yisu, naŋ dôŋ, ma wê ŋac sa sêtêŋ Jerusalem sêndi bu sêmatôc ŋac. ");
INSERT INTO buk_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Iŋ kôc bapia dau su ma kêsêlêŋ e gi kêpiŋ Damaskas. Ma ŋagahô ŋambwa ŋawê atu daŋ akêŋ undambê meŋ pô gameŋ naŋ iŋ mbo. ");
INSERT INTO buk_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Iŋ peŋ sip nom ma ŋgô awha daŋ ta iŋ bocdec bu, “Saul, Saul, tu sake-ŋga am kêŋ kisa aö?” ");
INSERT INTO buk_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Goc Saul ô yom ma ndac, “O ŋadau, am asa?” Ma awha dau sôm, “Aö Yisu dauŋ, dec am kêŋ kisa. ");
INSERT INTO buk_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Am tisa ma sôc malac atu dê ndi. Ma gêŋ bocke naŋ aö tac whiŋ bu am kôm-ŋga, naŋ aö oc waŋkiŋ lau bu sêwhê sa têŋ am yêc dindê.” ");
INSERT INTO buk_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Lau naŋ sêmbo seŋ sêwhiŋ Saul, naŋ sêlhac ti sem dau dôŋ. Ŋac sêŋgô ŋakêcsia dau, magoc sêlic ŋamalac daŋ dom. ");
INSERT INTO buk_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Têŋ ndoc Saul tisa kalhac, naŋ kac tandô sa magoc gitôm dom bu lic gameŋ. Bocdinaŋ lau dinaŋ sêkêm iŋ sip amba, ma sêwê iŋ sêsôc malac Damaskas si. ");
INSERT INTO buk_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Gitôm bêc tö iŋ mbo tapec, ma gêŋ ti nôm gêŋ daŋ dom. ");
INSERT INTO buk_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ŋgac kêŋ whiŋ Yisu-ŋga daŋ mbo Damaskas, naŋ ndê ŋaê Ananias. Ma Pômdau hoc dau asê têŋ iŋ ŋa mbê, ma ta iŋ bu, “Ananias!” Ma iŋ ô yom ma sôm, “Aêc Pômdau, bocke?” ");
INSERT INTO buk_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Goc Pômdau sôm têŋ iŋ, “Am sa seŋ naŋ sêsam bu Seŋ Solop ma têŋ Judas ndê andu ndi, ma am oc tap ŋgac daŋ sa, naŋ ndê ŋaê Saul akêŋ malac Tasis. Ŋgac dau teŋ mbec mbo dinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Aö gatôc têŋ iŋ su ŋa mbê bu ŋamalac daŋ ŋaê Ananias oc têŋ iŋ ndi, kêŋ amba sac iŋ, ma kôm iŋ tandô po asê tiyham.” ");
INSERT INTO buk_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias ŋgô yom dinaŋ ma sôm, “Pômdau. Aö gaŋgô ŋgac dinaŋ ŋawaê su. Iŋ ŋgac naŋ kêŋ ŋawapac atu têŋ am nem lau dabuŋ naŋ sêmbo Jerusalem. ");
INSERT INTO buk_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ma dabuŋsiga atu-tu sêkêŋ ŋaclai têŋ iŋ bu têŋ malac dindec meŋ, ma kôc lau naŋ sêtoc am nem ŋaê sa, naŋ dôŋ.” ");
INSERT INTO buk_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Magoc Pômdau ô Ananias ndê yom ma sôm, “Am ndi, ma hêgo daôm dom! Aö kayaliŋ ŋgac dau sa su, bu hoc yom asê pi aneŋ ŋaê têŋ lau gameŋ apa-ŋga ti ŋac si kiŋ, ma têŋ lau Israel-ŋga sêwhiŋ. ");
INSERT INTO buk_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ma ŋawapac ti ŋandê naŋ iŋ oc hôc tu aneŋ ŋaê-ŋga, naŋ aö oc watôc têŋ iŋ.” ");
INSERT INTO buk_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Goc Ananias têŋ andu dau gi. Iŋ sôc gi, goc kêŋ amba sac Saul ma sôm, “Aneŋ asidôwa Saul. Pômdau Yisu naŋ hoc dau asê têŋ am yêc seŋ têŋ malac dindec, naŋ kêkiŋ aö gatêŋ am gameŋ. Iŋ kêkiŋ aö bu wakôm nem tanôm po asê, ma bu Ŋalau Dabuŋ nem am ahuc.” ");
INSERT INTO buk_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ma ŋagahô gêŋ gitôm i ŋagala peŋ akêŋ Saul tandô, ma iŋ gêlic gameŋ tiyham. Iŋ tisa ma Ananias kêku iŋ. ");
INSERT INTO buk_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ma tiŋambu iŋ gêŋ gêŋ e hôc iŋ dôŋ. Saul mbo Damaskas whiŋ lau sêkêŋ whiŋ-ŋga gitôm bêc ŋatô. ");
INSERT INTO buk_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ma têŋ têm dau dinaŋ iŋ gic hu gêm mêtê lau yêc lau Israel si lôm wê-ŋga, ma hoc asê têŋ ŋac bu Yisu iŋ Anötö Atu. ");
INSERT INTO buk_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ma lau hoŋ naŋ sêŋgô iŋ ndê yom, naŋ sêhêdaê ma sêndac dandi, “Ŋgac naŋ kêŋ kisa lau Jerusalem-ŋga naŋ sêtoc Yisu ndê ŋaê sa, iŋ ŋgac dau dindec me? Ma iŋ têŋ yac mba malac dec meŋ, bu kôc lau sêkêŋ whiŋ Yisu-ŋ ga dôŋ ma wê ŋac sêtêŋ dabuŋsiga atu-tu sêndi bu sêmatôc ŋac.” ");
INSERT INTO buk_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Tigeŋ Saul sôm yom ŋaŋga ma iŋ ndê ŋaclai kêsôwec. Iŋ tôc asê têŋ lau Israel-ŋga naŋ sêndöc Damaskas, bu yom andô, Yisu iŋ lau Israel si Mesaya dau. Ma lau naŋ sêkêŋ whiŋ Yisu dom, naŋ sêtôm dom bu sêô iŋ ndê yom. ");
INSERT INTO buk_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Saul mbo malac Damaskas e bêc daêsam giŋga su, ma lau Israel-ŋga ŋatô sêkic yom bu sêŋsalê lêŋ bu sêndic iŋ ndu. ");
INSERT INTO buk_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ma Saul ŋgô yom dau ŋawaê. Tôm acsalô ti ôbwêc ŋac sêkêŋ lau sêtip gatam malac-ŋga ŋapep bu sêkôc iŋ dôŋ ma sêndic iŋ ndu. ");
INSERT INTO buk_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Magoc lau naŋ s êlhac sêwhiŋ Saul ti sêŋkuc iŋ, naŋ sem iŋ sa bu lhö ndi. Têŋ ôbwêc daŋ sêkêŋ iŋ sip sambec atu daŋ, ma sêŋwhaŋ iŋ sip akêŋ gatam sauŋ daŋ yêc malac dau ŋatuŋbôm e gi sip nom ma kölhö gi. ");
INSERT INTO buk_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Tiŋambu Saul mbu têŋ Jerusalem gi, ma gauc gêm bu mbo whiŋ lau sêkêŋ whiŋ Yisu-ŋga naŋ sêmbo dinaŋ. Magoc ŋac sêkêŋ whiŋ dom bu iŋ gêm dau kwi su ma kêŋ whiŋ Yisu, dec ŋac hoŋ sêtöc iŋ. ");
INSERT INTO buk_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Magoc Banabas wê iŋ sôc gi kalhac aposel aŋgô-ŋga. Ma iŋ whê sa bu Pômdau hoc dau asê ma sôm yom têŋ Saul yêc seŋ, ma tiŋambu iŋ kalhac ŋaŋga ma gêm mêtê pi Yisu ti atac pa su yêc malac Damaskas. ");
INSERT INTO buk_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Banabas ndê yom gêm malô lau Jerusalem-ŋga si ŋalôm, dec Saul mbo whiŋ ŋac, ma sôc sa yêc lhu, ma hoc yom asê pi Pômdau Yisu ti atac pa su eŋ. ");
INSERT INTO buk_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Iŋ sôm yom whiŋ lau Israel-ŋga ŋatô naŋ sêsôm awha Grik, ma kêsahê bu whê ŋac si gauc sa pi Yisu. Magoc ŋac sêtec iŋ ndê yom, ma bu sêndic iŋ ndu. ");
INSERT INTO buk_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Yom dau ŋawaê tap lau sêkêŋ whiŋ-ŋga sa, dec sêkôc iŋ whiŋ ŋac sêsip malac Sisaria si, ma sêŋkiŋ iŋ têŋ malac Tasis gi. ");
INSERT INTO buk_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Têŋ ŋasawa dinaŋ lau sêhu si kisa têŋ lau sêkêŋ whiŋ-ŋga siŋ. Ma lau sêkêŋ whiŋ-ŋga yêc gameŋ Judia ti Galili ma Samaria-ŋga sêndöc ti yom malô. Anötö kêŋ Ŋalau Dabuŋ bu puc ŋac dôŋ ma nem ŋac sa. Ma sêsôc Pômdau ŋapu ti sêtoc iŋ sa, ma ŋac si toŋ kêsôwec tiatu ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Têŋ têm dinaŋ Pita kêsêlêŋ golom-golom malac ma gêm mêtê lau. Têŋ bêc daŋ iŋ sôc malac Lida gi, bu ndic lau sêkêŋ whiŋ Yisu-ŋga kêsi. ");
INSERT INTO buk_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Yêc malac dau iŋ tap ŋgac daŋ ŋaê Aenias sa. Iŋ ŋgac bôliŋ ma yêc mbô ŋapaŋ gitôm yala 8 su. ");
INSERT INTO buk_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ma Pita sôm têŋ iŋ, “Aenias. Yisu Kilisi kôm am ŋayham sa. Tisa ma tip nem mbô sa.” Ma ŋagahô Aenias tisa kalhac. ");
INSERT INTO buk_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ma têŋ ndoc lau naŋ sêndöc malac Lida ti malac Saron sêlic bu iŋ ŋayham sa, dec ŋac hoŋ sem si ŋalôm kwi ma sêkêŋ whiŋ Pômdau. ");
INSERT INTO buk_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Têŋ têm dinaŋ awhê kêŋ whiŋ-ŋga daŋ ndöc malac Jopa. Iŋ ndê ŋaê Tabita, naŋ yêc lau Grik awha bu Dokas. Iŋ awhê naŋ kôm mêtê ŋayham-ŋayham, ma gêm lau ŋalôm sawa sa ŋalêŋ daêsam. ");
INSERT INTO buk_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Magoc Dokas tap gêmbac atu sa e iŋ mbac ndu. Goc lau sêŋgwasiŋ iŋ ndê ŋamlaŋ ma sêkêŋ yêc andu ŋalôm ŋahô-ŋga daŋ. ");
INSERT INTO buk_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Malac Jopa dau yêc kêpiŋ malac Lida, ma têŋ têm lau sêkêŋ whiŋ-ŋga yêc malac Jopa sêŋgô bu Pita mbo Lida, naŋ sêŋkiŋ ŋgac lu sêtêŋ iŋ si, ma sêteŋ iŋ ŋaŋga bu mbu têŋ Jopa whiŋ iŋlu ndi. ");
INSERT INTO buk_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pita whiŋ iŋlu gi e hôc asê Jopa, ma sêwê iŋ pi andu ŋalôm ŋahô-ŋga dinaŋ gi. Lauwhê sawa daêsam sêmbo ti sêtaŋ Dokas. Ŋac sêŋgihi Pita ahuc ma sêtôc ŋakwê bambaliŋ ti ŋakwê ŋatô naŋ Dokas kêmasaŋ têŋ ndoc iŋ mbo tali, naŋ têŋ Pita. ");
INSERT INTO buk_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Goc iŋ kêŋ ŋac hoŋ sêsa awê si, ma pôŋ haduc ma teŋ mbec. Iŋ kac dau kwi bu lic awhê batê dinaŋ, ma sôm, “Tabita, am tisa!” Ma awhê dau tali sa e gêlic Pita, ma yêc dau sa meŋ ndöc. ");
INSERT INTO buk_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Goc Pita kêm iŋ sip amba ma keŋ iŋ sa kalhac. Ma iŋ mbwêc lauwhê sawa dinaŋ ti lau sêkêŋ whiŋ-ŋga ŋatô sêsôc sêmeŋ, ma tôc têŋ ŋac bu awhê dau mbo tali tiyham. ");
INSERT INTO buk_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ma gêŋ dau ŋawaê tiapa yêc malac Jopa, e lau daêsam sêkêŋ whiŋ Pômdau. ");
INSERT INTO buk_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ma Pita mbo Jopa bêc ŋatô, whiŋ ŋgac daŋ ŋaê Saimon. Iŋ ŋgac kôm gweleŋ kêmasaŋ bôc ŋamlic-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Yêc malac Sisaria ŋgac daŋ mbo, naŋ ndê ŋaê Konelias. Iŋ ŋgac bata siŋ-ŋga naŋ yob lau siŋ-ŋga toŋ daŋ yêc lau siŋ Rom-ŋga si toŋ atu naŋ sêsam bu Itali Ŋatoŋ. ");
INSERT INTO buk_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Iŋ ti ndê gôlôwac hoŋ sêtoc Anötö sa ma sêsôc iŋ ŋapu ŋapep. Iŋ teŋ mbec têŋ Anötö tôm bêc hoŋ, ma kêŋ ndê awa daêsam bu nem lau Israel-ŋga naŋ sêpônda dau, naŋ sa. ");
INSERT INTO buk_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Têŋ bêc daŋ, acgatu gitôm 3 kilok telha-ŋga, naŋ Anötö tôc gêŋ ŋagatu daŋ têŋ iŋ. Iŋ gatu gêlic Anötö ndê aŋela daŋ têŋ iŋ meŋ ma ta iŋ bu, “Konelias!” ");
INSERT INTO buk_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Goc Konelias tahê iŋ ti töc dau atu, ma ndac, “Pômdau, bocke?” Ma aŋela dau sôm, “Mbec hoŋ naŋ am teŋ, ti mwasiŋ naŋ am kêŋ têŋ lau ŋalôm sawa, naŋ Anötö gêlic gitôm da ŋayham naŋ iŋ gauc gêm ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kwahic dec iŋ kêŋ yom têŋ am bocdec bu. Êmkiŋ lau ŋatô sêtêŋ malac Jopa sêndi, bu sêkôc ŋgac daŋ ŋaê Saimon mbu têŋ am meŋ. Ŋgac dau ndê ŋaê daŋ sêsam bu Pita. ");
INSERT INTO buk_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Iŋ mbo whiŋ iŋ ndê wakaŋgac daŋ ŋaê Saimon, naŋ kôm gweleŋ bôc ŋamlic-ŋga, ma iŋ ndê andu kalhac gwêc dali.” ");
INSERT INTO buk_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Aŋela sôm yom dau pacndê su, goc hu iŋ siŋ. Dec Konelias ta iŋ ndê ŋgac akiŋ lu ma iŋ ndê ŋgac siŋ-ŋga daŋ sêmeŋ. Ŋgac siŋ-ŋga dau gêm iŋ sa tôm bêc hoŋ, ma iŋ toc Anötö sa. ");
INSERT INTO buk_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Konelias gic miŋ têŋ ŋac pi yom hoŋ naŋ aŋela sôm têŋ iŋ, goc kêkiŋ ŋac sêtêŋ malac Jopa si. ");
INSERT INTO buk_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Galaŋsê ŋac sêŋsêlêŋ sêmbo seŋ ma têŋ ac kalhac lhu, naŋ sêsuŋ sa malac atu Jopa. Têŋ têm dinaŋ, Pita pi andu gi bu teŋ mbec. ");
INSERT INTO buk_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Iŋ mbo e gêŋ yô iŋ dec tac whiŋ bu neŋ gêŋ. Lau sêmasaŋ iŋ ndê gêŋ sêmbo, ma Pita gatu kaiŋ daŋ sa. ");
INSERT INTO buk_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Iŋ gêlic undambê kac sa, ma gêŋ gitôm po atu daŋ naŋ sêsô wac sip ŋakêcsu hale, naŋ sêŋwhaŋ sip nom meŋ yêc iŋ aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ma iŋ gêlic bôc tidau-tidau ma gêŋ naŋ sêŋsêlêŋ ŋa ŋatac pu-ŋga, ti mbac lôlôc-ŋga sêmbo po dau ŋalôm. ");
INSERT INTO buk_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Goc awha daŋ sôm têŋ iŋ bocdec bu, “Pita, tisa ndic ma neŋ.” ");
INSERT INTO buk_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Magoc iŋ ô yom ma sôm, “Pômdau, mba andô! Moses ndê yomsu gic yao gêŋ dau ma sôm bu iŋ gêŋ ŋadômbwi, ma bocdinaŋ aö whaŋsuŋ gêm gauc sambuc.” ");
INSERT INTO buk_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Dec awha dau sôm tiyham, “Anötö bu sôm bu gêŋ daŋ iŋ ŋawasi, dec am sôm bu gêŋ ŋadômbwi dom.” ");
INSERT INTO buk_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Gêŋ hoŋ dinaŋ hôc asê iŋ tidim tö su, goc po dau pi undambê gi tiyham. ");
INSERT INTO buk_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Têŋ ndoc dinaŋ Pita ndê gauc sa bu iŋ gêlic gêŋ ŋagatu daŋ, goc iŋ ndöc ma kôc gauc pi gêŋ dau ŋahu. Têŋ ndoc dinaŋ, lau naŋ Konelias kêkiŋ, naŋ sêtap Saimon ndê andu sa, ma sêlhac andu dau ŋagatam. ");
INSERT INTO buk_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","M a sêta yom ma sêndac bu Saimon naŋ sêsam bu Pita, naŋ mbo andu dau, me mba. ");
INSERT INTO buk_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita hê gauc pi gêŋ naŋ iŋ gatu gêlic naŋ mbo, ma Ŋalau Dabuŋ sôm têŋ iŋ, “Saimon, lau tö sêŋsalê am. ");
INSERT INTO buk_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tisa ma sip nom ndi, ma whiŋ ŋac ndi. Hêgo daôm bu ŋac lau gameŋ apa-ŋga lec dom, bu aö dauŋ kakiŋ ŋac sêmeŋ.” ");
INSERT INTO buk_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Goc Pita sip gi ma sôm têŋ lau dinaŋ, “Ŋamalac naŋ mac aŋsalê ambo, naŋ aö dauŋ dec. Mac ameŋ tu sake-ŋga?” ");
INSERT INTO buk_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ma ŋac sêsôm, “Ŋgac bata siŋ-ŋga Konelias kêkiŋ yac ameŋ. Iŋ ŋgac gitêŋ toc Anötö sa-ŋga, ma lau Israel-ŋga hoŋ naŋ sêmbo malac Sisaria, naŋ sêlic iŋ ŋayham. Aŋela dabuŋ daŋ sôm têŋ iŋ bu êŋgalêm am sa têŋ iŋ ndê andu ndi, bu am sôm yom ŋatô têŋ iŋ.” ");
INSERT INTO buk_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pita ŋgô ŋac si yom dinaŋ su, goc kôc ŋac sêsôc andu dau si bu sêmbo sêwhiŋ iŋ têŋ ôbwêc dinaŋ. Têŋ galaŋsê Pita ti akêŋ malac Jopa whiŋ lau dau, ma lau sêkêŋ whiŋ-ŋga ŋatô akêŋ Jopa sêwhiŋ ŋac si. ");
INSERT INTO buk_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Bêc daŋ tiyham sêhôc asê Sisaria. Konelias kêŋ bata ŋac, dec mbwêc iŋ ndê dawai ti ndê silip hoŋ sêkac sa sêpitigeŋ. ");
INSERT INTO buk_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Têŋ ndoc Pita bu sôc iŋ ndê andu ndi, naŋ Konelias têŋ iŋ gi, ma hu dau yêc iŋ gahi-ŋga bu toc iŋ sa. ");
INSERT INTO buk_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Magoc Pita sôm, “Am kôm bocdinaŋ dom! Tisa, bu aö dauŋ ŋamalac ŋambwa.” ");
INSERT INTO buk_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Iŋlu sem yomgalôm ma sêsôc andu dau si, ma Pita gêlic lau toŋ atu sêndöc andu ŋalôm. ");
INSERT INTO buk_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Dec iŋ sôm têŋ ŋac, “Mac aŋyalê bu yac lau Israel-ŋga mba yomsu gic yao yac bu andic ahê lau naŋ lau Israel dom, ma ati ŋacleŋ ŋac d om. Tigeŋ Anötö tôc asê têŋ aö bu wapu ŋamalac daŋ bu ŋadômbwi me sac dom. ");
INSERT INTO buk_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Bocdinaŋ têŋ ndoc mac aŋkiŋ lau bu sêŋgalêm aö sa, naŋ aö gasôm yom daŋ dom, ma gawhiŋ ŋac gameŋ. Ma kwahic dec, gitôm bu mac asôm asê têŋ aö, ŋahu bocke dec mac aŋgalêm aö sa gameŋ?” ");
INSERT INTO buk_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Goc Konelias ô yom ma sôm, “Bêc hale su, aö gambo andu ti gateŋ mbec têŋ acgatu gitôm kwahic dec-ŋga, têŋ 3 kilok telha-ŋga. Ma ŋagahô ŋamalac daŋ ti ŋakwê ŋawasi atu hôc asê kalhac aö aŋôŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ma iŋ sôm têŋ aö bu, ‘Konelias, Anötö ŋgô am nem mbec, ma gauc gêm mwasiŋ naŋ am kêŋ têŋ lau ŋalôm sawa. ");
INSERT INTO buk_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kwahic dec êmkiŋ lau ŋatô sêtêŋ malac Jopa sêndi, ma sêkôc ŋgac daŋ ŋaê Saimon naŋ sêsam bu Pita, naŋ meŋ. Iŋ ti ŋacleŋ iŋ ndê wakaŋgac ŋaê Saimon ma ndöc whiŋ iŋ. Ŋgac kêmasaŋ bôc ŋamlic-ŋga dinaŋ ndê andu kalhac gwêc ŋadali.’ ");
INSERT INTO buk_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Aö gaŋgô su, goc ŋagahô kakiŋ lau ŋatô sêtêŋ am sêloc, ma ŋayham bu am mweŋ su. Kwahic dec yac hoŋ dambo Anötö aŋgô-ŋga, ma yac bu aŋgô yom bocke naŋ Pômdau gic atu am bu sôm têŋ yac.” ");
INSERT INTO buk_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Goc Pita gic hu yom ma sôm, “Kwahic dec aö kayalê pi ŋandô bu Anötö toc lau toŋ daŋ sa, hôc gêlêc toŋ ŋatô su dom. ");
INSERT INTO buk_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Yomandô! Lau akêŋ lau ŋatoŋ nom-ŋga hoŋ naŋ sêtöc iŋ ma sêkôm mêtê ŋayham ma solop, naŋ iŋ oc kôc ŋac sa. ");
INSERT INTO buk_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Anötö kêŋ ndê ŋawaê ŋayham têŋ lau Israel, ma yom dau hêganôŋ Yisu Kilisi, naŋ ti lau Israel ma lau gameŋ apa-ŋga hoŋ si Pômdau, ma whê lêŋ naŋ datap yom malô sa tu iŋ-ŋga, naŋ sa. Mac aŋgô ŋawaê dau su. ");
INSERT INTO buk_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mac aŋyalê gêŋ hoŋ naŋ hôc asê gameŋ Judia-ŋga, têŋ ndoc Jon gêm mêtê ma kêku lau mbo Galili e meŋ têŋ dec. ");
INSERT INTO buk_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Anötö kêŋ iŋ ndê ŋaclai atu ti Ŋalau Dabuŋ gêm Yisu Nasaret-ŋga ahuc, dec kêyaliŋ iŋ sa tu kôm gweleŋ-ŋga. Ma Anötö whiŋ iŋ, dec iŋ gêm lau sa yêc gameŋ daêsam, ma kôm lau hoŋ naŋ Sadaŋ ndê ŋaclai kêgwiniŋ ŋac dôŋ, naŋ ŋayham sa tiyham. ");
INSERT INTO buk_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Yac ambo awhiŋ iŋ, ma alic gêŋ hoŋ naŋ iŋ kôm yêc lau Israel si gameŋ ma yêc Jerusalem. Ŋac sic iŋ ndu pi a, ");
INSERT INTO buk_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","magoc têŋ bêc titö-ŋga Anötö uŋ iŋ sa akêŋ lau batê-ŋga, ma kôm bu lau daêsam sêlic iŋ. ");
INSERT INTO buk_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Lau hoŋ sêlic iŋ dom, magoc yac lau naŋ aŋ ti anôm gêŋ awhiŋ Yisu têŋ ndoc iŋ tisa ma mbo whiŋ yac tiyham, naŋ Anötö kêyaliŋ yac sa bu ahoc iŋ ndê tisa ŋawaê asê. ");
INSERT INTO buk_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ma Anötö gic atu yac bu anem mêtê lau, ma bu ahoc yom asê bu iŋ kêyaliŋ Yisu dau sa su, bu êŋsahê lau tali ti lau batê hoŋ têŋ bêc ŋambu-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ma propet akwa hoŋ bocdinaŋ sêhoc yom asê pi iŋ. Ŋac sêto bu lau hoŋ naŋ sêkêŋ whiŋ iŋ, naŋ Anötö oc suc ŋac si sac kwi tu iŋ ndê ŋaê-ŋga.” ");
INSERT INTO buk_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita sôm yom dau mbo, ma Ŋalau Dabuŋ gêm lau hoŋ naŋ sêŋgô iŋ ndê yom, naŋ ahuc. ");
INSERT INTO buk_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ma lau Israel-ŋga naŋ sêkêŋ whiŋ Yisu ma sêmbo sêwhiŋ Pita, naŋ sêhêdaê ŋandô bu sêlic Anötö kêmwasiŋ lau naŋ sêmbo lau Israel si toŋ dom, naŋ ŋa Ŋalau Dabuŋ. ");
INSERT INTO buk_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bu ŋac sêŋgô ŋac lau dau sêsôm yom awha wakuc-ŋga ti sêmpiŋ Anötö, tôm Ŋalau Dabuŋ hôc ŋac awha sa. Dec Pita sôm têŋ lau Israel-ŋga dinaŋ, ");
INSERT INTO buk_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Anötö kêŋ Ŋalau Dabuŋ têŋ lau gameŋ apa-ŋga dindec tôm iŋ kêŋ têŋ yac lau Israel-ŋga. Bocdinaŋ ŋayham bu ŋac sêliŋ busaŋgu.” ");
INSERT INTO buk_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Goc iŋ kêŋ yatu bu sêŋku ŋac tu Yisu Kilisi ndê ŋaê-ŋga. Ma tiŋambu lau dinaŋ sêndac Pita bu mbo whiŋ ŋac tôm bêc ŋatô. ");
INSERT INTO buk_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Lau aposel ti lau sêkêŋ whiŋ Yisu-ŋga naŋ sêmbo gameŋ Judia-ŋga, naŋ sêŋgô ŋawaê bu lau naŋ Israel dom, naŋ sêkôc Anötö ndê yom sa sêwhiŋ. ");
INSERT INTO buk_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Magoc têŋ ndoc Pita hu Sisaria siŋ ma mbu têŋ Jerusalem gi, naŋ lau ŋatô sêsôm iŋ. Ŋac lau Israel-ŋga naŋ sêkêŋ whiŋ Pômdau, ma sêsap lau Israel-ŋga si sakiŋ akwa ma pwac sêsê ŋamlic ŋatô su-ŋga dôŋ. Ma ŋac sêsôm Pita bocdec bu, ");
INSERT INTO buk_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Bocke am sôc lau naŋ sêŋkuc yac neŋ mêtê dasê ŋamlic-ŋga dom, naŋ si andu, ma gêŋ gêŋ whiŋ ŋac?” ");
INSERT INTO buk_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Dec Pita gic hu whê sa timala têŋ ŋac, gêŋ hoŋ naŋ hôc asê iŋ, ma sôm, ");
INSERT INTO buk_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Têŋ bêc daŋ aö gateŋ mbec gambo malac Jopa, e gatuŋ kaiŋ daŋ sa ma galic gêŋ ŋagatu daŋ. Galic gêŋ gitôm po atu daŋ, naŋ sêsô wac sip ŋakêcsu hale, ma sêŋwhaŋ sip akêŋ undambê têŋ aö meŋ. ");
INSERT INTO buk_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Aö gatôc gwaniŋ ma galic bôc nom-ŋga tidau-tidau, bôc saleŋ-ŋga ti gêŋ naŋ sêŋsêlêŋ ŋa ŋatac pu-ŋga, ma mbac lôlôc-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Dinaŋ su, goc gaŋgô awha daŋ sôm têŋ aö bocdec bu, ‘Pita! Tisa ndic ma neŋ.’ ");
INSERT INTO buk_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Magoc aö gaô yom ma gasôm, ‘Pômdau, mba andô! Moses ndê yomsu gic yao gêŋ dau ma sôm bu iŋ gêŋ ŋadômbwi, ma aö whaŋsuŋ gêm gauc sambuc.’ ");
INSERT INTO buk_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ma awha dau sa akêŋ undambê tiyham ma sôm, ‘Anötö bu sôm bu gêŋ daŋ iŋ gêŋ ŋawasi, dec am sôm bu ŋadômbwi dom.’ ");
INSERT INTO buk_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Gêŋ hoŋ dinaŋ hôc asê aö tidim tö su, goc Pômdau kôc mbu pi undambê gi tiyham. ");
INSERT INTO buk_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ma têŋ ndoc dinaŋ lauŋgac tö sêhôc asê andu naŋ aö gambo. Ŋamalac daŋ kêkiŋ ŋac sêtêŋ aö sêmeŋ akêŋ malac Sisaria. ");
INSERT INTO buk_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ŋalau Dabuŋ sôm têŋ aö bu wahêgo dauŋ tu ŋac lau gameŋ apa-ŋga lec dom, ma kac aö bu wawhiŋ ŋac wandi, dec aö gawhiŋ ŋac ga. Ma asidôwai 6 akêŋ Jopa sêwhiŋ yac si. Yac ahôc asê ma asôc ŋamalac dau ndê andu a. ");
INSERT INTO buk_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ma iŋ gic miŋ têŋ yac bu aŋela daŋ hoc dau asê têŋ iŋ yêc ndê andu, ma sôm yom têŋ iŋ bocdec bu, ‘Êmkiŋ lau sêtêŋ malac Jopa sêndi ma sêkôc Saimon naŋ sêsam bu Pita, naŋ meŋ. ");
INSERT INTO buk_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Iŋ oc whê yom sa têŋ mac, pi lêŋ naŋ am ti nem lau hoŋ atap Anötö ndê mwasiŋ nem mac si ambo tamli ŋapaŋ-ŋga sa.’ ");
INSERT INTO buk_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Bocdinaŋ aö gac hu bu wasôm yom têŋ ŋac, ma têŋ ndoc dau dinaŋ Ŋalau Dabuŋ gêm ŋac ahuc tôm iŋ meŋ pi yac têŋ ŋamata-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ma têŋ dinaŋ aö gauc gêm Pômdau ndê yom bocdec bu, ‘Jon kêku lau ŋa bu, tigeŋ Anötö oc êŋku mac ŋa Ŋalau Dabuŋ.’ ");
INSERT INTO buk_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Lau dinaŋ sêkêŋ whiŋ Pômdau Yisu Kilisi tôm yac lau Israel-ŋga dakêŋ whiŋ, ma bocdinaŋ dec Anötö kêmwasiŋ ŋac ŋa Ŋalau Dabuŋ tôm iŋ kôm têŋ yac. Anötö dau ndê lêŋ dinaŋ, ma aö asa dec bu walhac ahuc?” ");
INSERT INTO buk_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Lau Israel-ŋga dau sêŋgô Pita ndê yom dinaŋ e ŋac si yom mba, ma sêmpiŋ Anötö ma sêsôm, “Kwahic dec yac taŋyalê bu lau hoŋ naŋ sem dau kwi, naŋ oc sêtap Anötö ndê mwasiŋ sêndöc tali ŋapaŋ-ŋga sa. Yac lau Israel-ŋga, ma lau naŋ sêmbo Israel si toŋ dom, naŋ sêwhiŋ.” ");
INSERT INTO buk_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Têŋ ndoc lau Israel-ŋga sic Steven ndu, naŋ sic hu sêkêŋ kisa lau sêkêŋ whiŋ-ŋga e ŋac si daêsam sêhu Jerusalem siŋ ma sêlhö têŋtêŋ. Ŋatô sêtêŋ gameŋ Pionisia-ŋga ti nduc Saipras, ma ŋatô sêtêŋ malac Antiok si. Yêc gameŋ bocke naŋ sêhôc asê, naŋ sêhoc ŋawaê ŋayham asê, magoc sêsôm têŋ lau Israel-ŋga tawasê. ");
INSERT INTO buk_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Magoc lau ŋatô naŋ sêhu Jerusalem siŋ, naŋ si malachu Sairin ma nduc Saipras, naŋ sêtêŋ Antiok si, ma sic hu sêsôm ŋawaê ŋayham pi Pômdau Yisu têŋ lau Grik sêwhiŋ lau Israel-ŋga yêc malac dinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ma Pômdau gêm mbec gweleŋ dau e lau daêsam ŋandô sem dau kwi ma sêkêŋ whiŋ Pômdau. ");
INSERT INTO buk_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tiŋambu lau Jerusalem-ŋga naŋ sêkêŋ whiŋ Yisu, naŋ sêŋgô gêŋ dau ŋawaê, dec sêŋkiŋ Banabas têŋ Antiok gi. ");
INSERT INTO buk_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Banabas iŋ ŋgac ŋayham naŋ Ŋalau Dabuŋ gêm iŋ ahuc ma kêŋ whiŋ ŋaŋga. Têŋ ndoc iŋ hôc asê Antiok, naŋ gêlic bu lau daêsam sêtap Anötö ndê mwasiŋ sa ma sêkêŋ whiŋ Yisu. Dec iŋ tac ŋayham atu, ma kêgilí ŋac bu sêsap Pômdau dôŋ, ma sêkêŋ whiŋ iŋ ti si ŋalôm sambuc. Ma têŋ ndoc dinaŋ lau daêsam sêŋgô Banabas ndê yom ma sêkêŋ whiŋ Pômdau. ");
INSERT INTO buk_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Malô goc Banabas têŋ malac atu Tasis gi ma kêsalê Saul. ");
INSERT INTO buk_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Iŋ tap iŋ sa su, goc kôc iŋ sa, ma iŋlu sêmbu sêtêŋ Antiok si. Ma iŋlu sêkôm gweleŋ yêc gôlôwac dabuŋ ŋalôm, sêndôhôŋ lau daêsam gitôm yala sambuc daŋ. Malac Antiok ti malac ŋamata-ŋga naŋ lau sic hu sêsam lau sêkêŋ whiŋ-ŋga bu Kilisi ndê lau. ");
INSERT INTO buk_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Têŋ ŋasawa dinaŋ propet ŋatô akêŋ Jerusalem sêsip Antiok si. ");
INSERT INTO buk_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ma Ŋalau Dabuŋ kac ŋac si ŋgac daŋ ŋaê Agabus, dec tisa yêc lau sêkêŋ whiŋ-ŋga aŋgô-ŋga, ma hoc yom asê bu tiŋambu tôbôm atu oc nem gameŋ naŋ lau Rom sem gôliŋ, naŋ ahuc sambuc. (Ma iŋ ndê yom dau ŋandô sa têŋ ndoc Klaudias ti kiŋ Rom-ŋga.) ");
INSERT INTO buk_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tu dinaŋ-ŋga lau naŋ sêkêŋ whiŋ Yisu sêkôc gauc pi lêŋ bu sênem asidôwai naŋ sêndöc gameŋ Judia-ŋga, naŋ sa. Ŋac tigeŋ-tigeŋ sic awa sa tôm Anötö kêmwasiŋ ŋac, ");
INSERT INTO buk_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ma sêkêŋ têŋ Banabas lu Saul bu sêkôc sa sêndi, ma sêkêŋ têŋ lau sêkêŋ whiŋ-ŋga si lau bata naŋ sêmbo Jerusalem. ");
INSERT INTO buk_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Têŋ ndoc dinaŋ Kiŋ †Herod gauc gêm tidôŋ bu kêŋ kisa lau sêkêŋ whiŋ-ŋga, ma kôc ŋac si lau ŋatô dôŋ. ");
INSERT INTO buk_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Iŋ gic atu iŋ ndê lau siŋ, dec sic Jon ndê dôwa Jems ndu ŋa bieŋ baliŋ. ");
INSERT INTO buk_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Iŋ gêlic bu gêŋ dinaŋ kôm lau Israel-ŋga atac ŋayham sa, dec iŋ sôm bu iŋ ndê lau siŋ-ŋga sêkôc Pita dôŋ, têŋ têm lau Israel-ŋga sêlic om atu †Mwasiŋ Bolom Yist Mba-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bocdinaŋ lau siŋ-ŋga sêkôc Pita dôŋ ma sêkêŋ iŋ ndöc gapocwalô. Ma sêkêŋ lau siŋ-ŋga toŋ hale sêyob iŋ sêô dau sêô dau, ma ŋgac hale sêmbo toŋ tigeŋ-tigeŋ ŋalôm. Herod gauc gêm bu kêŋ iŋ ndöc dinaŋ e lau Israel si Mwasiŋ Bolom Yist Mba-ŋga ti †Pasowa-ŋga pacndê, goc kôc iŋ sa ma êmatôc iŋ yêc lau aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Bocdinaŋ Pita ndöc gapocwalô, magoc lau sêkêŋ whiŋ-ŋga hoŋ naŋ sêmbo Jerusalem, naŋ sêteŋ mbec ŋaŋga tu iŋ-ŋga têŋ Anötö. ");
INSERT INTO buk_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Têŋ ôbwêc daŋ Pita yêc bêc yêc gapocwalô, ma Herod kêmatiŋ yom tidôŋ su bu êmatôc iŋ têŋ laŋsê. Sêsô iŋ amba dôŋ ŋa sen lu, ma gi sêsô pi ŋgac siŋ-ŋga lu. Ma lau siŋ-ŋga ŋatô sêlhac sêyob gatam. ");
INSERT INTO buk_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ma ŋagahô ŋambwa Pômdau ndê aŋela daŋ hôc asê, ma ŋawê pô gapocwalô ŋalôm. Iŋ toŋ Pita sip ŋabi e tali sa, ma sôm têŋ iŋ, “Ŋagahô! Tisa!” Goc sen naŋ sêsô iŋ amba dôŋ, naŋ tigoloŋ ma peŋ sip gi. ");
INSERT INTO buk_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ma aŋela sôm, “Êmasaŋ daôm. Kic nem piŋkap dôŋ ma sôc nem atapa ti ŋakwê baliŋ sa, goc êmkuc aö.” Pita kôm gitôm iŋ sôm, ");
INSERT INTO buk_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ma kêkuc aŋela dau. Iŋ gauc gêm bu gêŋ naŋ aŋela kôm, naŋ gitôm mbê daŋ, ma kêyalê dom bu gêŋ dau iŋ gêŋ ŋandô. ");
INSERT INTO buk_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Iŋlu sêŋlêc ŋgac siŋ-ŋga lu naŋ sêyob andu dau e sêhôc asê gatam naŋ sa malac lôm. Gatam dau gêlêc dau su, ma sêsa awê si. Iŋlu sêŋsêlêŋ sêsa seŋ daŋ, ma sep tigeŋ aŋela hu iŋ siŋ. ");
INSERT INTO buk_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Têŋ dinaŋ Pita ndê gauc sa ma sôm têŋ dau, “Kwahic dec aö kayalê tidôŋ bu Pômdau kêkiŋ ndê aŋela bu êŋgaho aö su yêc Herod amba, bu gêŋ naŋ lau Israel-ŋga gauc gêm bu sêkôm têŋ aö, naŋ oc ŋandô sa dom.” ");
INSERT INTO buk_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Iŋ kêyalê gêŋ dau pi ŋandô, goc sa têŋ awhê daŋ ŋaê Maria ndê andu gi. Maria iŋ Jon, †ŋgacsêŋom naŋ sêsam bu Mak, naŋ dinda. Ma têŋ ôbwêc dinaŋ lau daêsam sêkac sa sêmbo Maria ndê andu bu sêteŋ mbec. ");
INSERT INTO buk_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita hôc asê ma kêmati gatam. Ma awhê akiŋ daŋ ŋaê Roda sa gi bu lic asa kêmati gatam. ");
INSERT INTO buk_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Iŋ ŋgô iŋ awha dec kêyalê bu Pita, dec tac ŋayham sa atu ma kêlhiŋ gatam siŋ kêti mbu gi ma sôm têŋ lau bu, “Pita dê kalhac gatam!” ");
INSERT INTO buk_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Magoc ŋac sêkêŋ whiŋ dom, ma sêsôm têŋ iŋ bu, “Am nem gauc kêŋsôŋ!” Goc iŋ sôm yom pi Pita ŋapaŋ e ŋac sêsôm, “Mboe iŋ ndê aŋela, me?” ");
INSERT INTO buk_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Sêkôc gauc dinaŋ sêmbo, ma Pita gacgeŋ kêmati gatam kalhac. Malô ma sêlêc gatam su têŋ iŋ e sêlic iŋ ma sêsö ŋandô. ");
INSERT INTO buk_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pita gic amba bu sênem dau dôŋ, goc gic miŋ yom pi ŋalêŋ naŋ Pômdau kôc iŋ su yêc gapocwalô. Ma iŋ sôm, “Mac andi ma asôm asê têŋ Jems ma asidôwai ŋatô.” Goc iŋ hu ŋac siŋ ma sa gi. ");
INSERT INTO buk_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Têŋ bêbêc lau siŋ-ŋga naŋ sêyob gapocwalô sêlic bu Pita aŋgô mba. Gêŋ dau gêli ŋac ŋalôm sa ŋandô, ma ŋac gauc gêm yom daêsam pi iŋ bu oc mbo nde. ");
INSERT INTO buk_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ma Herod ŋgô ŋawaê, dec kêŋ lau sêŋsalê iŋ e gimba. Goc iŋ kêsu lau siŋ-ŋga naŋ sêyob Pita, ma gic atu bu sêndic ŋac ndu. Tiŋambu Herod hu gameŋ Judia-ŋga siŋ ma sa têŋ malac Sisaria gi bu mbo bêc ŋatô. ");
INSERT INTO buk_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tôm ŋasawa hic baliŋ ŋagec gi su, naŋ yom ŋawapac ŋatô yêc Herod ma lau malac Taya ma Saidon-ŋga ŋalhu, dec iŋ gêlic ŋac sac. Magoc têŋ têm iŋ mbo malac Sisaria, naŋ lau dau ŋalôm tigeŋ ma gauc gêm bu sêhê wamba iŋ tiyham. Ŋahu bu ŋac sêmbo Herod ndê gôliŋ ŋapu ma lau gameŋ dinaŋ-ŋga takwê Herod tôm yala hoŋ, bu nem ŋac sa ŋa gêŋ daneŋ-ŋga ŋatô. Tu dinaŋ-ŋga sêmasaŋ yom whiŋ Blastus, ŋgac naŋ yob Herod ndê andu, ma semlhi iŋ bu nem ŋac awha têŋ Herod. Ma sic ndoc bu sêmasaŋ yom wamba-ŋga dau whiŋ Herod. ");
INSERT INTO buk_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Têŋ bêc dau Herod sôc ndê ŋakwê ti ŋawasi kiŋ-ŋga sa, goc ndöc ndê pôŋ ma sôm ndê yom daêsam asê têŋ lau malac lu dinaŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ŋac sêŋgô su ma sêmbwêc, “Kec! Awha dindec ŋamalac ŋambwa ndê awha dom, anötö daŋ ndê awha.” ");
INSERT INTO buk_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herod ŋgô ŋac si yom dinaŋ, dec toc dau sa kêlêc ma kêŋ waê têŋ Anötö dom. Ma tu dinaŋ-ŋga Pômdau ndê aŋela gic iŋ ma kôm iŋ gêmbac atu. Dombo sem iŋ ahuc ma seŋ iŋ e mbac ndu. ");
INSERT INTO buk_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Têŋ têm dinaŋ ma kêsêlêŋ meŋ, naŋ lau sem mêtê ŋapaŋ e Anötö ndê yom tiapa, ma lau daêsam sêkêŋ whiŋ. ");
INSERT INTO buk_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabas lu Saul sic bata si gweleŋ yêc malac Jerusalem, goc sêmbu sêtêŋ Antiok si. Ma sêkôc Jon, ŋgac naŋ sêsam iŋ ndê ŋaê daŋ bu Mak, naŋ whiŋ iŋlu gi. ");
INSERT INTO buk_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Lau propet ti kêdôhôŋ-waga bocdec sêmbo m alac Antiok ma sêkôm gweleŋ yêc gôlôwac dabuŋ ŋalôm. Banabas lu Saimon naŋ sêsam bu Naiga, Lusias akêŋ malac Sairin, Saul ma Manaen (naŋ tiatu whiŋ †Herod Antipas têŋ ndoc iŋlu sêmbo balê). ");
INSERT INTO buk_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Têŋ bêc daŋ ŋac lau dau sêmbo sêwhiŋ dau ma sêhu gêŋ daneŋ-ŋga siŋ tu sêtoc Pômdau sa-ŋga. Ma Ŋalau Dabuŋ sôm têŋ ŋac bu, “Aö kayaliŋ Banabas lu Saul sa bu sêkôm gweleŋ ŋawaê ŋayham-ŋga. Bocdinaŋ anem mbec iŋlu ma aŋkiŋ iŋlu sêsa sêndi ma sêkôm gweleŋ dau.” ");
INSERT INTO buk_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Lau dau sêŋgô su, goc sêhu gêŋ daneŋ-ŋga siŋ ti sêteŋ mbec ŋasawa daŋ tiyham, ma sêkêŋ amba sac Saul lu Banabas, ma sêŋkiŋ iŋlu sêsa si. ");
INSERT INTO buk_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ŋalêŋ dinaŋ Ŋalau Dabuŋ kêkiŋ Saul lu Banabas, dec iŋlu sêtêŋ malac Selusia si, ma sêpi waŋ daŋ ma sêsa nduc Saipras si. ");
INSERT INTO buk_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ŋac sêsôc baö yêc malac Salamis, ma sêsôc lau Israel si lôm wê-ŋga yêc dindê, ma sem mêtê lau ti sêhoc Anötö ndê yom asê. Ma Jon mbo whiŋ iŋlu bu nem iŋlu sa. ");
INSERT INTO buk_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tiŋambu sêŋsêlêŋ ma sêhoc ŋawaê ŋayham asê yêc nduc Saipras ŋagameŋ hoŋ e sêhôc asê malac Papos. Yêc dinaŋ sêtap propet tasaŋ daŋ sa naŋ kôm gweleŋ mbectoma-ŋga whiŋ. Iŋ ŋgac Israel-ŋga daŋ ma iŋ ndê ŋaê Ba-Jisas. ");
INSERT INTO buk_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Iŋ gêm akiŋ ŋgac Rom-ŋga naŋ gêm gôliŋ nduc Saipras, naŋ ndê ŋaê Segias Polas. Gôliŋwaga dau iŋ ŋgac tigauc, dec kêgalêm Banabas lu Saul sa, bu iŋ tac whiŋ bu sêwhê Anötö ndê yom sa têŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Magoc Ba-Jisas kôm bu êŋgwiniŋ ti kêŋ kisa iŋlu, ma tac whiŋ bu kac gôliŋwaga dau kwi bu kêŋ whiŋ Pômdau dom. (Ba-Jisas ndê ŋaê daŋ Elimas, naŋ danem kwi bu Mbectoma.) ");
INSERT INTO buk_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Têŋ ndoc dinaŋ Ŋalau Dabuŋ gêm Saul, naŋ sêsam bu Pol ahuc, ma iŋ tahê Elimas ma sôm, ");
INSERT INTO buk_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Am Sadaŋ atu am! Am kêŋ kisa lêŋ gitêŋ hoŋ, ma sac ti mêtê tasaŋ gêm am ahuc. Am bu kôm Pômdau ndê lêŋ solop êŋsôŋ. ");
INSERT INTO buk_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kwahic dec am oc êmsahê Pômdau ndê ŋaclai. Am oc tampec sa ma tôm bêc ŋatô am oc lic gameŋ ti ac ŋawê tiyham dom.” Ma ŋagahô ŋasec gêm ŋgac dau tandô ahuc, ma iŋ kêsêlêŋ kêsa ma kêsalê ŋamalac daŋ bu kêm iŋ amba ma wê iŋ. ");
INSERT INTO buk_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Segias Polas hêdaê tu Saul lu Banabas si yom pi Pômdau-ŋga, ma têŋ ndoc iŋ gêlic gêŋ naŋ hôc asê Elimas, naŋ iŋ kêŋ whiŋ Yisu. ");
INSERT INTO buk_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol lu Banabas ma Mak sêhu Papos siŋ ma sêpi waŋ daŋ, ma sêlac sêtêŋ malac Pega naŋ yêc gameŋ Pampilia-ŋga si. Yêc gameŋ dinaŋ Jon hu iŋlu siŋ ma mbu têŋ Jerusalem gi. ");
INSERT INTO buk_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Goc iŋlu sêhu Pega siŋ ma sêtêŋ malac Antiok naŋ yêc gameŋ Pisidia-ŋga, naŋ si. Têŋ bêc Sabat-ŋga sêsôc lau Israel si lôm wê-ŋga si, ma sêndöc sic. ");
INSERT INTO buk_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Sêŋgô Anötö ndê yom naŋ sêsam yêc Buku Yomsu-ŋga ti Propet si Buku, goc lau bata lôm wê-ŋga-ŋga sêkêŋ yom têŋ iŋlu ma sêsôm, “Asidôwa lu. Amlu nem yom bu yêc bu apuc lau dindec dôŋ, dec asôm asê têŋ yac.” ");
INSERT INTO buk_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Goc Pol tisa kalhac, ma gic amba têŋ lau bu sênem dau dôŋ, goc sôm, “Mac lau Israel-ŋga ti mac lau apa naŋ atoc Anötö sa. Aŋgô su naŋ! ");
INSERT INTO buk_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Yac lau Israel-ŋga mba Anötö kêyaliŋ yac mba abaŋi sa. Ma tiŋambu iŋ kôm ŋac si wakuc naŋ sêndöc gameŋ Isip-ŋga, n aŋ sêti lau toŋ atu. Ma têŋ ndoc iŋ kôc ŋac su yêc Isip, naŋ kôm gêŋ ti ŋaclai atu daêsam. ");
INSERT INTO buk_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Tiŋambu ŋac sêkôm mêtê wachuc daêsam tôm yala 40 naŋ sêmbo gameŋ sawa, magoc Anötö hu ŋac siŋ dom. ");
INSERT INTO buk_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","T iŋambu iŋ ku lau toŋ 7 dulu yêc gameŋ Kanan-ŋga, ma kêŋ ŋac si gameŋ têŋ lau Israel-ŋga sêwêkaiŋ. ");
INSERT INTO buk_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Gêŋ hoŋ dinaŋ hôc asê yêc yala 450 ŋalôm. Tiŋambu iŋ kêŋ lau sêmatôc yom-ŋga sêyob lau Israel-ŋga e meŋ têŋ propet Samuel ndê têm. ");
INSERT INTO buk_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Têŋ ndoc dinaŋ lau dau sêndac kiŋ daŋ bu nem gôliŋ ŋac, ma Anötö kêŋ Saul, naŋ ndê damba Kis akêŋ Benjamin ndê toŋ. Saul gêm gôliŋ tôm yala 40, ");
INSERT INTO buk_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","goc Anötö kôc iŋ su ma kêŋ Dawid ti kiŋ ô iŋ su. Ma iŋ sôm yom pi Dawid bocdec bu, ‘Aö galic Jessi ndê atu Dawid bu ŋgac naŋ ndê ŋalôm ti gauc tap aneŋ atac whiŋ sa, ma oc kôm gêŋ hoŋ tôm aö atac whiŋ.’ ");
INSERT INTO buk_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Anötö kêyaliŋ ŋgac nem lau si-ŋga Yisu sa yêc Dawid dau ndê wakuc, tôm iŋ gic bata muŋ su, ma kêŋ iŋ hôc asê Israel. ");
INSERT INTO buk_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yisu gic hu ndê gweleŋ su dom, ma Jon gêm mêtê têŋ lau Israel-ŋga hoŋ bu sênem si ŋalôm kwi ma sêliŋ busaŋgu. ");
INSERT INTO buk_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Têŋ ndoc Jon ndê gweleŋ kêpiŋ bu pacndê, naŋ iŋ sôm têŋ lau bu, ‘Mac gauc gêm bu aö asa? Ŋgac naŋ Anötö gic bata bu ti mac nem Mesaya, naŋ aö dom. Mba! Magoc iŋ oc meŋ êŋkuc aö. Iŋ ŋgac tiwaê ma aö ŋgac ŋambwa, gitôm dom bu wati iŋ ndê ŋgac akiŋ tu waŋgapwêc iŋ ndê atapa ŋawalô su-ŋga.’ ");
INSERT INTO buk_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“O asidôwai. Mac lau Israel-ŋga naŋ asa akêŋ abaŋ Abraham, ti mac lau naŋ ambo lau Israel si toŋ dom magoc atoc Anötö sa. Ŋawaê dindec pi Anötö ndê lêŋ nem lau si-ŋga, naŋ iŋ kêŋ gic waê yac hoŋ. ");
INSERT INTO buk_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Lau Israel Jerusalem-ŋga ti ŋac si lau bata sêsam propet akwa-kwa si yom asê yêc ŋac si lôm wê-ŋga tôm bêc Sabat-ŋga hoŋ. Magoc têŋ têm Yisu hôc asê, naŋ sêŋyalê dom bu iŋ Mesaya dau, ma sêkic yom bu sêndic iŋ ndu. Ŋac sêŋyalê dom bu lêŋ bocdinaŋ dec kôm yom naŋ lau propet dau sêhoc asê pi Mesaya, naŋ ŋandô sa. ");
INSERT INTO buk_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ŋac sêtap yom giso daŋ sa pi Yisu tu bu sêndic iŋ ndu-ŋga lec dom, magoc sêndac Pailot bu ndic iŋ ndu. ");
INSERT INTO buk_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ŋac si lêŋ dinaŋ dec kôm yom hoŋ naŋ sêto pi Yisu muŋ su, naŋ ŋandô sa. Pailot ndê lau sic Yisu ndu su, goc lau sêkôc iŋ su yêc a gicso ma sêkêŋ iŋ ndê ŋamlaŋ yêc sêhô. ");
INSERT INTO buk_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Magoc Anötö uŋ iŋ sa akêŋ lau batê-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ma tôm bêc daêsam iŋ mbo whiŋ lau naŋ sêŋsêlêŋ sêwhiŋ iŋ têŋ ndoc iŋ gic hu ndê gweleŋ yêc Galili e lau sic iŋ ndu yêc Jerusalem. Ŋac lau dau sêlic iŋ tisa su yomandô, madec sêsôm asê têŋ lau hoŋ. ");
INSERT INTO buk_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Kwahic dec yac asôm ŋawaê ŋayham asê têŋ mac bocdec bu, Anötö uŋ Yisu sa akêŋ lau batê-ŋga. Ma bocdinaŋ dec yom naŋ iŋ gic bata têŋ abaŋi, naŋ kwahic dec iŋ kôm ŋandô sa têŋ abaŋi si lau wakuc yac dec. Tôm yom naŋ sêto yêc Wê tilu-ŋga yêc Buku Wê-ŋga bocdec bu, ‘Acsalô lec am ti aö neŋ atuŋgac solop, ma aö gati am Damam.’ ");
INSERT INTO buk_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Anötö uŋ iŋ sa akêŋ lau batê-ŋga bu iŋ ŋamlic tibalê dom. Bu mba, dec oc tôm dom bu sêto yom bocdec bu, ‘Pwac dabuŋ naŋ aö kamatiŋ gawhiŋ Dawid, naŋ tidôŋ su, ma mac oc atap pwac dau ŋa-mwasiŋ sa.’ ");
INSERT INTO buk_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ma yom dau Dawid to yêc bocdec, ‘Am oc hu nem Ŋgac Dabuŋ siŋ bu tibalê dom.’ ");
INSERT INTO buk_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Aŋgô su naŋ! Dawid to yom dinaŋ hêganôŋ iŋ dau dom. Bu têŋ ndoc Dawid gic bata gweleŋ naŋ Anötö kêŋ sip iŋ amba, naŋ Dawid mbac ndu whiŋ lau têm dinaŋ-ŋga, ma sêŋsuhuŋ iŋ whiŋ ndê apai. Ma iŋ ndê ŋamlaŋ tibalê su. ");
INSERT INTO buk_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Tigeŋ Yisu, naŋ Anötö uŋ iŋ sa akêŋ lau batê-ŋga, naŋ ndê ŋamlaŋ tibalê dom. ");
INSERT INTO buk_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Bocdinaŋ aneŋ asidôwai hac, aŋgô. Aö tac whiŋ bu mac aŋyalê ŋapep bu yom naŋ yac ahoc asê têŋ mac, naŋ bu whê mac nem gauc sa pi lêŋ bu Anötö suc mac nem sac kwi tu Yisu-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mac nem daŋ gitôm dom bu êŋkuc yomsu hoŋ naŋ Moses to e Anötö lic iŋ bu ŋamalac gitêŋ. Mba andô! Tigeŋ kwahic dec lau naŋ sêkêŋ whiŋ Yisu, naŋ Anötö gêlic ŋac bu lau gitêŋ tu iŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ayob daôm bu atec ŋawaê ŋayham dindec dom, tu bu yom naŋ lau propet sêsôm, naŋ ŋandô sa pi mac dom. Yom dau bocdec: ");
INSERT INTO buk_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Alic su naŋ mac lau apu yom ti ataŋ bôlê-ŋga. Kwahic dec aö oc wakôm gêŋ atu daŋ, naŋ lau bu sêsôm asê têŋ mac, dec oc akêŋ whiŋ dom! Mac alic ti ahêdaêm, magoc oc andiŋam!” ");
INSERT INTO buk_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol gic bata iŋ ndê yom dinaŋ, ma iŋlu Banabas bu sêhu lôm wê-ŋga siŋ sêsa awê sêndi. Ma lau sêndac iŋlu bu sêmbu sêmeŋ têŋ Sabat ŋambu-ŋga, ma sêsôm yom tiyham pi gêŋ hoŋ dinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Lau bata lôm wê-ŋga sêkêŋ gôlôwac sêsa si su, ma lau daêsam sêŋkuc Pol lu Banabas. Lau ŋatô ŋac lau Israel-ŋga, ma lau ŋatô ŋac lau gameŋ apa-ŋga naŋ sêŋkuc lau Israel si sakiŋ sênem akiŋ Anötö-ŋga. Ma Pol lu Banabas sem yomgalôm sêwhiŋ ŋac, ma sem la ŋac bu takwê Anötö ndê mwasiŋ tu bu puc ŋac si sêkêŋ whiŋ dôŋ tôm bêc hoŋ. ");
INSERT INTO buk_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sabat daŋ tiyham hôc asê, ma lau daêsam andô sêkac dau sa bu sêŋgô Pômdau ndê yom. Kêpiŋ bu lau malac-ŋga hoŋ sêmeŋ sêpitigeŋ. ");
INSERT INTO buk_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Tigeŋ lau Israel-ŋga ŋatô sêlic toŋ atu dinaŋ ma sem lêmuŋ ŋandô. Bocdinaŋ ŋac atac ŋandê ma sêsôm yom sac-sac daêsam bu sêŋgwiniŋ Pol ti ndê yom. ");
INSERT INTO buk_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Magoc iŋlu Banabas sêlhac ti atac pa su ma sêô ŋac si yom ma sêsôm, “Anötö kêkiŋ alu bu asôm iŋ ndê yom asê têŋ mac lau Israel-ŋga muŋ. Magoc mac atec iŋ ndê yom. Mac atec bu atap seŋ andöc tamli-ŋga sa, a? Tu dinaŋ-ŋga dec alu oc ahu mac siŋ, ma atêŋ lau naŋ lau Israel dom, naŋ andi. ");
INSERT INTO buk_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Pômdau dau gic atu alu bu akôm bocdinaŋ, tôm yom naŋ Aisaya to pi Anötö ndê ŋgac akiŋ bocdec bu: Aö waŋkiŋ am gitôm ŋawê bu têŋ lau naŋ lau Israel dom, naŋ ndi. Ma am oc sôm ŋawaê ŋayham asê pi aneŋ lêŋ wanem lau si-ŋga e tiapa yêc gameŋ hoŋ.” ");
INSERT INTO buk_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Lau gameŋ apa-ŋga dinaŋ sêŋgô yom dau, ma ŋac atac ŋayham sa ma sêtoc Pômdau ndê yom sa. Ma lau hoŋ naŋ Pômdau kêyaliŋ ŋac sa su bu sêtap seŋ sêndöc tali-ŋga sa, naŋ sêkêŋ whiŋ. ");
INSERT INTO buk_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ma Pômdau ndê yom gi tiapa gêm gameŋ hoŋ dinaŋ ahuc. ");
INSERT INTO buk_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Magoc yêc malac dinaŋ lau Israel-ŋga ŋatô sêŋgilí lau bata ti lauwhê tiwaê naŋ sêmbo gôlôwac Israel-ŋga ŋalôm, ma sêkêŋ kisa Pol lu Banabas ma sêmasuc iŋlu su yêc ŋac si gameŋ. ");
INSERT INTO buk_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Bocdinaŋ iŋlu sêtoŋ kop su yêc si gahi bu tôc lau dau si giso asê, ma sêtêŋ malac Aikoniam si. ");
INSERT INTO buk_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ma Anötö kêŋ Ŋalau Dabuŋ gêm lau malac Antiok-ŋga naŋ sêkêŋ whiŋ Yisu, naŋ ahuc, ma sêmbo ti atac ŋayham ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pol lu Banabas sêhôc asê malac Aikoniam, ma sêŋkuc si gêbôm ma sêsôc lau Israel si lôm wê-ŋga si. Ma yêc dinaŋ iŋlu sem mêtê ŋalêŋ ŋayham e lau daêsam sêkêŋ whiŋ Yisu, lau Israel-ŋga ma lau gameŋ apa-ŋga sêwhiŋ. ");
INSERT INTO buk_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Magoc lau Israel-ŋga naŋ sêkôc iŋlu si yom sa ti sêkêŋ whiŋ dom, naŋ sêŋgilí lau gameŋ apa-ŋga e sêlic lau sêkêŋ whiŋ-ŋga sac. ");
INSERT INTO buk_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tu dinaŋ-ŋga Pol lu Banabas sêmbo malac Aikoniam ŋasawa hic baliŋ, ma sêlhac ŋaŋga tu bu sêwhê Pômdau ndê yom sa-ŋga. Ma Pômdau kêŋ ŋaclai têŋ iŋlu bu sêkôm gêŋ dalô ti gêŋ atu-tu, tu bu puŋ yom naŋ iŋlu sêhoc asê pi iŋ ndê mwasiŋ, naŋ dôŋ. ");
INSERT INTO buk_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Gêŋ dau kôm lau malac-ŋga sêwhê dau kôc, ŋatô sêlhac sêwhiŋ lau Israel-ŋga, ma ŋatô sêlhac sêwhiŋ aposel lu dinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Têŋ dinaŋ lau Israel-ŋga ma lau gameŋ apa-ŋga naŋ sêkêŋ kisa iŋlu, naŋ sêkic yom sêwhiŋ ŋac si lau bata bu sêkôm iŋlu ŋayom ma sêtuc iŋlu ŋa hoc ndu. ");
INSERT INTO buk_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Tigeŋ iŋlu sêŋgô ŋapuc, ma bocdinaŋ dec sêlhö sêtêŋ gameŋ Likonia-ŋga si. Ma yêc gameŋ dinaŋ, iŋlu sêkôm gweleŋ ŋawaê ŋayham-ŋga yêc malac Listra ma malac Derbi ma yêc ŋagameŋ ŋamakê-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Yêc malac Listra ŋgac bôliŋ daŋ mbo, naŋ gahi lu-lu tibalê. Dinda kôc iŋ bocdinaŋ, ma iŋ kêsêlêŋ daŋ dom. ");
INSERT INTO buk_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Têŋ bêc daŋ iŋ ndöc gameŋ naŋ Pol gêm mêtê mbo, ma ŋgô iŋ ndê yom. Pol tahê iŋ e kêyalê bu iŋ kêŋ whiŋ Pômdau ŋaŋga tôm bu kôm iŋ ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Dec Pol ta yom ŋa awha atu ma sôm, “Tisa lhac!” Ma ŋagahô ŋambwa ŋgac dau tisa ma kêsêlêŋ. ");
INSERT INTO buk_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Lau Likonia-ŋga sêlic gêŋ naŋ Pol kôm, dec sêmbwêc yêc dau awha-ŋga ma sêsôm, “Kec, anötöi sem ŋamalac aŋgô ma sêsip sêtêŋ yac sêmeŋ.” ");
INSERT INTO buk_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ma sêhê ŋaê Seus pi Banabas kêkuc ŋac si anötö ŋamata-ŋga ndê ŋaê. Ma sêsam Pol bu Hermes, kêkuc ŋac si anötö apa daŋ ŋaê, ŋahu bu iŋ ŋgac sôm yom-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Lau malac dinaŋ-ŋga si lôm tu sênem akiŋ ŋac si anötö apa Seus, naŋ kalhac kêpiŋ malac dau ŋagatam. Ma anötö apa Seus ndê dabuŋsiga daŋ, ti ŋac lau malac-ŋga atac whiŋ bu sêkêŋ gêŋ pi ya ti da têŋ Pol lu Banabas. Dec iŋ kôc makao gapoc ŋatô ma gêŋ ŋatô tu sêŋgôlôŋ makao ma sêkêŋ ti da-ŋga, ma ŋac hoŋ sêkac dau sa sêmbo malac dau ŋasactô. ");
INSERT INTO buk_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Magoc têŋ ndoc aposel lu sêŋgô gêŋ dinaŋ ŋawaê, naŋ sêkac si ŋakwê kic bu sêtôc asê bu sêlic gêŋ dau so sambuc. Ma sêsa ŋalhu si, ma sêmbwêc yom bocdec bu, ");
INSERT INTO buk_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Ei! Mac akôm iŋ dinaŋ tu ake-ŋga? Alu ŋamalac atôm mac, ma ameŋ bu asôm ŋawaê ŋayham asê têŋ mac. Alu bu asôm têŋ mac bu ahu nem anötöi tasaŋ hoŋ siŋ ma anem daôm kwi ma anem akiŋ Anötö Tali Ŋadau, naŋ kêmasaŋ undambê ti nom ma gwêc ti gêŋ hoŋ. ");
INSERT INTO buk_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Muŋ-ŋ ga iŋ kêŋ ŋasawa têŋ lau nom-ŋga hoŋ bu sêkôm gêŋ tôm si atac whiŋ. ");
INSERT INTO buk_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Magoc iŋ kêmwasiŋ lau nom-ŋga ŋapaŋ bu whê ŋac si gauc sa pi iŋ. Iŋ kêŋ u gic akêŋ umboŋ, dec mac nem ôm sem ŋandô daêsam. Iŋ kêŋ gêŋ daneŋ-ŋga daêsam têŋ mac, ti gêŋ ŋayham-ŋayham tu bu kôm mac atac ŋayham-ŋga.” ");
INSERT INTO buk_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Iŋlu sêwhê gêŋ hoŋ dinaŋ sa têŋ lau dau, magoc lau ŋatô si gauc sa dom, ma sêkôm ŋaŋga bu sêkêŋ da têŋ iŋlu. ");
INSERT INTO buk_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Têŋ dinaŋ lau Israel-ŋga ŋatô naŋ sêmeŋ akêŋ malac Antiok ma Aikoniam, naŋ sêsôm yom daêsam têŋ lau e sêkac si ŋalôm kwi ma sêlic Pol lu Banabas sac. Dec sêtuc Pol ŋa hoc e gauc gêm bu iŋ mbac ndu su, goc sêhê iŋ sa malac ŋamakê gi. ");
INSERT INTO buk_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Magoc lau sêkêŋ whiŋ Yisu-ŋga ŋatô sêsa si sêŋgihi iŋ a huc, dec iŋ tisa ma mbu sôc malac Listra gi. Ma ŋagalaŋsê iŋlu Banabas sêlhö sêtêŋ malac Derbi si. ");
INSERT INTO buk_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Iŋlu sêsôm ŋawaê ŋayham asê yêc malac atu Derbi, e lau daêsam sêkêŋ whiŋ Pômdau. Tiŋambu iŋlu sêmbu si, ma sic lau sêkêŋ whiŋ-ŋga kêsi yêc malac Listra, Aikoniam, ma Antiok yêc gameŋ Pisidia-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Sêpuc lau sêkêŋ whiŋ-ŋga dôŋ bu sêlhac ŋaŋga ma sêhu si sêkêŋ whiŋ siŋ dom. Sêsôm têŋ ŋac bu, “Yac bu dambo Anötö ndê gôliŋ ŋapu, naŋ iŋ gêŋ sauŋ dom. Dalhac ŋaŋga ma dahôc ŋawapac dandic ŋawaê.” ");
INSERT INTO buk_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ma yêc lau sêkêŋ whiŋ-ŋga ŋatoŋ hoŋ naŋ iŋlu sic kêsi, naŋ Pol lu Banabas sêŋyaliŋ lau bata sa bu sêyob toŋ tigeŋ-tigeŋ. Iŋlu sem mbec lau bata dau ma sêkêŋ ŋac sêsip Pômdau, naŋ ŋac hoŋ sêkêŋ whiŋ iŋ, naŋ amba. Ma ŋac hoŋ sêhu gêŋ daneŋ-ŋga siŋ tu bu sêteŋ mbec-ŋga, ma sêndac Pômdau bu puc lau bata dau dôŋ. ");
INSERT INTO buk_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Iŋlu sic gameŋ Pisidia-ŋga kêsi su, goc sêtêŋ gameŋ Pampilia-ŋga si. ");
INSERT INTO buk_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Yêc dinaŋ sêhoc ŋawaê ŋayham asê yêc malac Pega, ma tiŋambu sêsa malac Atalia si. ");
INSERT INTO buk_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ma yêc Atalia sêpi waŋ daŋ, ma sêmbu sêtêŋ malac Antiok naŋ yêc gameŋ Siria-ŋga si. Muŋ-ŋga lau yêc malac d au sêŋyaliŋ iŋlu sa ma sêteŋ Anötö bu êmwasiŋ iŋlu tu gweleŋ naŋ kwahic dec iŋlu sic bata su-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Sêhôc asê su goc sêkac lau sêkêŋ whiŋ-ŋga hoŋ sa, ma sic miŋ gêŋ hoŋ naŋ Anötö gêm iŋlu sa bu sêkôm. Ma sêsôm asê têŋ ŋac bu kwahic dec Anötö gêlêc gatam su têŋ lau naŋ lau Israel dom, dec ŋac si lau daêsam sêkêŋ whiŋ Yisu. ");
INSERT INTO buk_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ma iŋlu sêmbo sêwhiŋ lau sêkêŋ whiŋ-ŋga yêc malac Antiok ŋasawa baliŋ. ");
INSERT INTO buk_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Lau sêkêŋ whiŋ-ŋga ŋatô akêŋ gameŋ Judia-ŋ ga sêhôc asê Antiok, ma sêndôhôŋ yom têŋ lau sêkêŋ whiŋ-ŋga naŋ lau Israel dom, naŋ bocdec bu, “Mac bu asê nem lauŋgac si ŋamlic ŋatô su aŋkuc pwac naŋ Moses to yom pi, naŋ dom, dec oc tôm dom bu Anötö nem mac si.” ");
INSERT INTO buk_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Tu yom dinaŋ-ŋga dec kisa atu yêc Pol lu Banabas ma lau gameŋ Judia-ŋga dinaŋ ŋasawa, ma sêseŋ dau ŋapaŋ pi yom dau. Bocdinaŋ lau sêkêŋ whiŋ-ŋga sêŋyaliŋ Pol lu Banabas ma lau sêkêŋ whiŋ-ŋga ŋatô sa, ma sêŋkiŋ ŋac bu sêpi Jerusalem sêndi ma sêŋgô lau aposel ti lau bata si gauc pi yom dau. ");
INSERT INTO buk_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Sêŋkiŋ ŋac si su, ma têŋ ndoc Pol ti lau dau sêŋsêlêŋ sêmbo seŋ, naŋ sic miŋ têŋ lau sêkêŋ whiŋ-ŋga yêc gameŋ Pionisia ti Samaria-ŋga, pi ŋac si gweleŋ têŋ lau naŋ lau Israel dom. Sêwhê sa bu lau apa daêsam sêkac si ŋalôm kwi ma sêkêŋ whiŋ Pômdau. Ma yom dau kôm lau sêkêŋ whiŋ-ŋga hoŋ atac ŋayham atu. ");
INSERT INTO buk_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ma têŋ ndoc sêhôc asê Jerusalem, naŋ lau sêkêŋ whiŋ-ŋga ti aposel ma lau bata sêkôc ŋac sa. Ma iŋlu sic miŋ gêŋ hoŋ naŋ Anötö gêm iŋlu sa bu sêkôm. ");
INSERT INTO buk_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Têŋ dinaŋ lau Palêsai ŋatô naŋ sêkêŋ whiŋ Yisu, naŋ sêtisa ma sêsôm, “Yac gauc gêm tidôŋ bu dandic atu bu lau gameŋ apa-ŋga naŋ sêkêŋ whiŋ Yisu, naŋ sêsê lauŋgac si ŋamlic ŋatô su ma sêsôc Moses ndê yomsu ŋapu.” ");
INSERT INTO buk_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Goc sêkac lau aposel ti lau bata hoŋ sa sêpitigeŋ bu sêkôc gauc pi yom dau. ");
INSERT INTO buk_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Sêsôm yom ŋasawa baliŋ su, goc Pita tisa ma sôm, “Asidôwai, gauc nem gêŋ naŋ Anötö kôm têŋ lau gameŋ apa-ŋga ŋatô, têŋ têm dê gi su. Mac aŋyalê su bu iŋ gêlic ŋayham bu ŋac sêŋgô ŋawaê ŋayham sa aö dauŋ whaŋsuŋ, ma sêkêŋ whiŋ. ");
INSERT INTO buk_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Anötö naŋ kêyalê ŋamalac hoŋ si ŋalôm, naŋ kêŋ Ŋalau Dabuŋ têŋ ŋac tôm iŋ kêŋ têŋ yac, dec tôc asê bu iŋ ndê mwasiŋ gic ŋac ŋawaê whiŋ. ");
INSERT INTO buk_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Iŋ kêmasaŋ ŋac si ŋalôm ŋawasi sa tu ŋac si sêkêŋ whiŋ-ŋga, gitôm iŋ kôm têŋ yac. Gêŋ dau whê sa bu iŋ gêlic yac hoŋ bu lau kaiŋ tigeŋ. ");
INSERT INTO buk_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Magoc iŋ kôc ŋac sa tu sêŋkuc Moses ndê yomsu-ŋga dom. Yomsu dau kêŋ ŋawapac têŋ yac ti damaŋi, naŋ datôm dom bu dahôc. Bocke dec mac bu akêŋ ŋawapac dau sac lau gameŋ apa-ŋga naŋ sêkêŋ whiŋ, naŋ si bakêyac? Mac bu akôm bocdinaŋ dec oc aŋsahê Anötö, ma mboe oc kôm iŋ atac ŋandê. Ma mac oc alhac iŋ ndê lêŋ nem lau si-ŋga ahuc. ");
INSERT INTO buk_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Magoc yac dakêŋ whiŋ bu Anötö gêm yac lau Israel-ŋga si tu mwasiŋ naŋ datap sa ŋambwa yêc Pômdau Yisu-ŋga. Ma ŋac lau dindê bocdinaŋ.” ");
INSERT INTO buk_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ma têŋ dinaŋ Banabas lu Pol sic miŋ yom pi gêŋ dalô ti gêŋ atu-tu naŋ Anötö gêm iŋlu sa bu sêkôm yêc lau gameŋ apa-ŋga ŋalôm. Ma lau hoŋ naŋ sêkac sa sêndöc, naŋ sem dôŋ ma sêkêŋ daŋga iŋlu si yom. ");
INSERT INTO buk_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Iŋlu si yom pacndê, goc Jems sôm yom asê bocdec bu, “Asidôwai, aŋgô aneŋ yom. ");
INSERT INTO buk_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Pita whê sa têŋ yac su pi gêŋ naŋ Anötö kôm bu kôc lau gameŋ apa-ŋga ŋatô sa sêti iŋ ndê. ");
INSERT INTO buk_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Gêŋ dau kêkuc yom naŋ propet daŋ to muŋ su bocdec bu: ");
INSERT INTO buk_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Pômdau sôm, ‘Tiŋambu aö oc wambu wameŋ, ma wapuc Dawid ndê gôliŋ kiŋ-ŋga dôŋ tiyham. Dawid ndê gôliŋ dau kwahic dec tisac gitôm andu naŋ tiakwa su, magoc aö oc wakwê sa tiyham. ");
INSERT INTO buk_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ŋalêŋ dinaŋ dec wamasaŋ lêŋ bu lau sêŋsalê aö, ma sêtigasuc aö tiyham. Ma lau gameŋ apa-ŋga naŋ gahê aneŋ ŋ aê pi ŋac, naŋ sêwhiŋ.’ Pômdau, naŋ oc kôm gêŋ dau ŋandô sa, naŋ ndê yom dau dinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Iŋ kêmasaŋ lêŋ dau gwanaŋ su.” ");
INSERT INTO buk_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Goc Jems sôm, “Bocdinaŋ aö gauc gêm bu lau gameŋ apa-ŋga naŋ sêkac si ŋalôm kwi ma sêsôc Anötö ndê gôliŋ ŋapu, naŋ oc dakêŋ ŋawapac têŋ ŋac dom. ");
INSERT INTO buk_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Mba! Dato bapia têŋ ŋac, ma dakêŋ puc ŋac bu sêneŋ gêŋ daneŋ-ŋga naŋ lau sêkêŋ ti da têŋ anötöi gwam, naŋ dom, bu gêŋ dau ŋadômbwi yêc Anötö aŋgô-ŋga. Danem la ŋac bu sêkôm mêtê mockaiŋ-ŋga dom, ma sêneŋ bôc naŋ sêkiŋ ndu ma wata ti dac naŋ dom. ");
INSERT INTO buk_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Yom dau dinaŋ. Moses ndê yom, naŋ oc sêŋyalê su, ma bocdinaŋ dato yom pi dom. Bu lau sem mêtê pi Moses ndê yom yêc malac atu-tu hoŋ gitôm yala daêsam su, ma sêsam iŋ ndê buku yêc ŋac si lôm wê-ŋga tôm bêc Sabat-ŋga hoŋ.” ");
INSERT INTO buk_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Têŋ dinaŋ lau aposel ti lau bata, ma lau sêkêŋ whiŋ-ŋga hoŋ si ŋalôm tigeŋ, bu sêŋyaliŋ ŋac si lau ŋatô sa, bu sêtêŋ Antiok sêwhiŋ Pol lu Banabas sêndi. Ŋac s êŋyaliŋ lau sêkêŋ whiŋ-ŋga si ŋgac bata lu sa, naŋ Judas, naŋ sêsam iŋ ndê ŋaê daŋ bu Basabas, lu Sailas. ");
INSERT INTO buk_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ma sêto bapia daŋ bu iŋlu sêkôc tôhôŋ, naŋ sôm yom bocdec bu: Yac ato bapia dindec têŋ mac lau gameŋ apa-ŋga naŋ akêŋ whiŋ Pômdau, yêc malac Antiok ma gameŋ Siria-ŋga ti Silisia-ŋga. Mac nem asidôwai yac lau aposel ti lau bata lec, akôm acsalô ŋayham têŋ mac. ");
INSERT INTO buk_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Yac atap sa bu yac mba lau ŋatô sêhôc asê mac, ma sêkôm mac nem ŋalôm ŋawapac tu ŋac si yom pi mêtê dasê lauŋgac ŋamlic-ŋga. Yac aŋkiŋ lau dau sêtêŋ mac sêloc dom. ");
INSERT INTO buk_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Bocdinaŋ yac hoŋ gauc gêm tidôŋ bu aŋyaliŋ lau ŋatô sa ma aŋkiŋ ŋac sêtêŋ mac sêloc sêwhiŋ yac mba silip ŋayham lu, naŋ Pol lu Banabas. ");
INSERT INTO buk_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Iŋlu sêkêŋ dau sambuc bu sêhoc Pômdau Yisu Kilisi ndê ŋawaê ŋayham asê, ma sêtöc dau dom bu sêmbac ndu tu iŋ ndê ŋaê-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ma kwahic dec yac aŋkiŋ Judas lu Sailas sêwhiŋ iŋlu sêtêŋ mac sêloc, bu sêpuc yom bapia dindec-ŋga dôŋ. ");
INSERT INTO buk_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Yac bu akêŋ ŋawapac têŋ mac dom, tigeŋ bu anem la mac. Ma yac akêŋ whiŋ bu Ŋalau Dabuŋ oc puc yac mba yom dau dôŋ. Yom dau bocdec. ");
INSERT INTO buk_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Aneŋ gêŋ daneŋ-ŋga naŋ lau sêkêŋ ti da têŋ anötöi gwam, naŋ dom. Aneŋ bôc naŋ sêkiŋ ndu ma wata ti dac, naŋ dom. Ma akôm mêtê mockaiŋ-ŋga dom. Ayob daôm bu ambo ahê gêŋ dau, naŋ dec oc akôm mêtê ŋayham. Yom dau dinaŋ. Acsalô ŋayham têŋ mac hoŋ. ");
INSERT INTO buk_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Sêto bapia dau su, goc sêŋkiŋ lau dau sêtêŋ Antiok si. Ma yêc dindê, ŋac sêkac lau sêkêŋ whiŋ-ŋga sa, ma sêkêŋ bapia dau têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Lau sêkêŋ whiŋ-ŋga sêsam, dec puc ŋac dôŋ ma kôm ŋac atac ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas lu Sailas dau propet lu, ma sêsôm yom ti sêkêŋ gauc ŋayham daêsam têŋ lau sêkêŋ whiŋ-ŋga, bu sêpuc ŋac dôŋ. ");
INSERT INTO buk_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Sêmbo sêwhiŋ ŋac bêc ŋatô, goc lau sêkêŋ whiŋ-ŋga sem mbec iŋlu ŋa yom malô, ma sêŋkiŋ iŋlu sêmbu sêtêŋ gôlôwac dabuŋ Jerusalem-ŋga, naŋ sêŋkiŋ iŋlu sêmeŋ, naŋ si tiyham.  ");
INSERT INTO buk_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Magoc Sailas gauc gêm bu mbo malac Antiok. ");
INSERT INTO buk_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ma Pol lu Banabas sêmbo malac Antiok, ma iŋlu sêwhiŋ lau daêsam, sêmbo ti sêndôhôŋ lau ma sêhoc Pômdau ndê yom asê. ");
INSERT INTO buk_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Tiŋambu Pol sôm yom têŋ Banabas bocdec bu, “Aö gauc gêm bu hêclu dambu datêŋ malac hoŋ naŋ muŋ-ŋga dahoc Pômdau ndê yom asê dambo, naŋ dandi. Dandic lau kêsi yêc dindê, ma dalic bu ŋac sêmbo ŋalêŋ bocke.” ");
INSERT INTO buk_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabas tac whiŋ bu sêkôc Jon naŋ sêsam iŋ ndê ŋaê daŋ bu Mak, naŋ whiŋ iŋlu ndi. ");
INSERT INTO buk_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Magoc Pol gêlic gauc dau bu yham dom. Ŋahu bu muŋ-ŋga Jon hu iŋlu ma iŋlu si gweleŋ siŋ yêc gameŋ Pampilia-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Tu yom dinaŋ-ŋga Pol lu Banabas sêseŋ dau e sêhu dau siŋ. Banabas kôc Mak ma iŋlu sêpi waŋ daŋ ma sêtêŋ nduc Saipras si. ");
INSERT INTO buk_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Magoc Pol kêyaliŋ Sailas sa bu êŋsêlêŋ whiŋ iŋ ndi. Asidôwai Antiok-ŋga sem mbec iŋlu ma sêteŋ Pômdau bu puc iŋlu dôŋ ŋa iŋ ndê mwasiŋ, ma tiŋambu iŋlu sêlhö si. ");
INSERT INTO buk_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ma iŋlu sic gameŋ Siria ti Silisia-ŋga kêsi ma sêpuc lau sêkêŋ whiŋ-ŋga dôŋ yêc gameŋ dinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol lu Sailas sêhôc asê malac Derbi, ma tiŋambu sêtêŋ malac Listra si. Yêc malac dinaŋ ŋgac kêŋ whiŋ-ŋga daŋ ŋaê Timoti mbo. Iŋ dinda iŋ awhê Israel-ŋga daŋ naŋ kêŋ whiŋ Pômdau, ma Timoti damba iŋ ŋgac Grik-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lau sêkêŋ whiŋ-ŋga naŋ sêmbo malac Listra ma Aikoniam sêlic Timoti bu ŋgac ŋayham ma sêmpiŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol tac whiŋ bu Timoti êŋsêlêŋ ti kôm gweleŋ whiŋ iŋ. Tigeŋ iŋ kêyalê bu lau Israel-ŋga hoŋ naŋ sêmbo gameŋ dinaŋ, naŋ sêŋyalê bu Timoti damba iŋ ŋgac Grik-ŋga. Tu dinaŋ-ŋga iŋ sê Timoti ndê ŋamlic ŋatô su. ");
INSERT INTO buk_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tiŋambu sêŋsêlêŋ sêlom-sêlom malac, ma sêhoc yom naŋ lau bata ti lau aposel sêmatiŋ tidôŋ yêc Jerusalem, naŋ asê têŋ lau sêkêŋ whiŋ-ŋga bu sêŋkuc. ");
INSERT INTO buk_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ŋalêŋ dau dinaŋ Anötö puc lau si sêkêŋ whiŋ dôŋ yêc malac hoŋ dinaŋ, ma tôm bêc hoŋ lau sêkêŋ whiŋ-ŋga si toŋ kêsôwec tiatu. ");
INSERT INTO buk_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ŋalau Dabuŋ kalhac Pol ti lau naŋ sêwhiŋ iŋ ahuc, bu sênem mêtê yêc gameŋ Esia-ŋga têŋ ŋasawa dinaŋ dom. Bocdinaŋ dec ŋac gacgeŋ sêmbo gameŋ Prigia ti Galesia-ŋga, ma sêkôm gweleŋ sêmbo dinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Têŋ ndoc sêhôc asê gameŋ Misia-ŋga ŋabatiŋ, ma bu sêsôc malac Bitinia sêndi, naŋ Yisu ndê Ŋalau kalhac ŋac ahuc tiyham. ");
INSERT INTO buk_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Bocdinaŋ sêhôc gêlêc gameŋ Misia-ŋga ma sêsip malac Troas si. ");
INSERT INTO buk_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Têŋ ôbwêc dinaŋ Pol yêc mbê ma gêlic ŋgac daŋ akêŋ gameŋ Masedonia-ŋga meŋ kalhac iŋ aŋgô-ŋga, ma teŋ iŋ bocdec bu, “Têŋ Masedonia mweŋ ma nem yac sa.” ");
INSERT INTO buk_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol yêc mbê dau su ma whê sa têŋ yac e aŋyalê bu Anötö mbwêc yac bu anem mêtê têŋ lau Masedonia-ŋga. Bocdinaŋ dec yac aŋsahic dauŋ bu atêŋ lau dau andi. ");
INSERT INTO buk_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Yac api waŋ yêc Troas ma solop atêŋ nduc Samotres a, ma ŋagalaŋsê yac ahu nduc dau siŋ ma asôc baö yêc malac Niapolis. ");
INSERT INTO buk_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Goc yac aŋsêlêŋ atêŋ malac Pilipai a a mbo bêc ŋatô. Malac dau ti gameŋ Masedonia-ŋga ŋa-malac atu, ma lau Rom-ŋga naŋ sem gôliŋ gameŋ dau, naŋ sêndöc malac dinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Têŋ Sabat daŋ yac ahu malac dau siŋ, ma asa atêŋ bu daŋ yêc malac dau ŋamakê a. Yac gauc gêm bu mboe gameŋ dinaŋ, iŋ lau ŋatô si gameŋ sêteŋ mbec-ŋga. Ma yac atap lauwhê ŋatô sa, naŋ sêkac sa sêmbo dindê, dec andöc sic ma ac hu asôm yom têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Lauwhê naŋ sêŋgô yom dau, naŋ si daŋ iŋ Lidia. Iŋ awhê tidulu po ŋadalô-ŋga, naŋ meŋ akêŋ malac Tayatira, ma iŋ awhê toc Anötö sa-ŋga. Têŋ ndoc iŋ ŋgô Pol ndê yom, naŋ Pômdau kac iŋ ndê ŋalôm bu kôc yom dau sa ma kêŋ whiŋ Yisu. ");
INSERT INTO buk_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Dec Lidia ti lau hoŋ naŋ sêndöc iŋ ndê andu naŋ sêliŋ saŋgu. Ma tiŋambu iŋ sôm têŋ yac, “Mac bu alic aö gitôm awhê naŋ kêŋ whiŋ Pômdau, dec ameŋ ambo aneŋ andu.” Ma iŋ piŋkap yac ŋapaŋ e yac awhiŋ iŋ a. ");
INSERT INTO buk_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Têŋ ndoc daŋ yac bu atêŋ gameŋ naŋ lau sêteŋ mbec sêmbo, naŋ andi, ma awhê daŋ meŋ tap yac sa. Iŋ awhê akiŋ ŋambwa daŋ, ma ŋalau daŋ mbo whiŋ iŋ ma hoc yom asê pi gêŋ naŋ oc meŋ sa tiŋambu. Lau daêsam êlêmê sêtêŋ iŋ si, bu iŋ whê yom sa pi gêŋ naŋ oc hôc asê ŋac têŋ têm ŋambu-ŋga. Ma awhê dau ndê ŋadaui sêtap awa atu sa tu iŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Têŋ têm dinaŋ yac aŋsêlêŋ awhiŋ Pol, ma awhê dau kêkuc yac ma mbwêc bocdec bu, “Lau dindec sem akiŋ Anötö Ŋawasi ti Ŋaclai Ŋadau, ma sêwhê yom sa pi lêŋ Anötö nem mac si andöc tamli ŋapaŋ-ŋga.” ");
INSERT INTO buk_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Tôm bêc daêsam iŋ kôm boc-dinaŋ e mbô Pol ŋalôm sa. Goc iŋ kac dau kwi ma sôm têŋ ŋalau bu, “Tu Yisu Kilisi ndê ŋaê-ŋga, dec wandic atu am bu sa yêc awhê dinaŋ.” Ma ŋagahô eŋ ŋalau hu awhê dau siŋ. ");
INSERT INTO buk_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Têŋ ndoc dinaŋ awhê dau ndê ŋadaui sêŋyalê bu ŋac si lêŋ sêkôc awa-ŋga pacndê. Dec sêlô Pol lu Sailas dôŋ ma sêhê iŋlu sa sêsôc malac lôm sêtêŋ lau atu-tu si. ");
INSERT INTO buk_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Sêkêŋ iŋlu sêlhac lau sêmatôc yom-ŋga si aŋgô-ŋga, ma sêsôm, “Ŋgac lu dindec iŋlu ŋgac Israel-ŋga. Ma sêmeŋ bu sêli lau malac-ŋga si ŋalôm sa. ");
INSERT INTO buk_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bu iŋlu sêkac lau bu sêŋkuc mêtê ŋatô naŋ yac lau Rom-ŋga bu taŋkuc, dec oc so yac neŋ ŋagôliŋ.” ");
INSERT INTO buk_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Awhê akiŋ dau ndê ŋadaui sêŋgôliŋ yom dinaŋ pi Pol lu Sailas, ma lau malac-ŋga sêpuc yom dau dôŋ. Bocdinaŋ lau sêmatôc yom-ŋga sêkêŋ yatu bu sêkac iŋlu si ŋakwê su ma sêhi iŋlu ŋa sö. ");
INSERT INTO buk_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Sêhi iŋlu ŋa sö sac andô, goc sêkêŋ iŋlu sêndöc gapocwalô. Ma sêsôm yom ŋaŋga têŋ ŋgac naŋ yob gapocwalô bu yob iŋlu ŋapep. ");
INSERT INTO buk_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Iŋ ŋgô yom dau su dec kêŋ iŋlu sêndöc ŋalôm daŋ, naŋ yêc andu gapocwalô-ŋga dau ŋa-ŋalôm andô. Ma iŋ sô iŋlu gahi dôŋ gêm damiŋ a. ");
INSERT INTO buk_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Timaniŋhu Pol lu Sailas sêteŋ mbec ti sem wê sêmpiŋ Anötö, ma lau gapocwalô-ŋga ŋatô sêkêŋ daŋga iŋlu. ");
INSERT INTO buk_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Sem wê sêmbo ma t iyhô atu gêm dec andu gapocwalô-ŋga wiwic sa. Ma gatam gapocwalô-ŋga hoŋ sêlêc dau su, ma sen gapocwalô-ŋga suc yêc lau hoŋ. ");
INSERT INTO buk_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Têŋ têm dinaŋ ŋgac yob gapocwalô-ŋga tali sa ma gêlic bu gatam hoŋ kac sa su. Iŋ gauc gêm bu lau hoŋ oc sêlhö si su, dec púc iŋ ndê bieŋ baliŋ sa bu kuŋ dau ndu. ");
INSERT INTO buk_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Magoc Pol mbwêc, “Kôm daôm ŋayom dom. Yac hoŋ kelec ambo!” ");
INSERT INTO buk_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Goc ŋadau sôm bu lau sêtuŋ ya sa sêmeŋ, ma sôc gapocwalô gi. Iŋ hu dau sip nom yêc Pol lu Sailas gahi-ŋga, ma töc dau ti kêtitec ŋandô. ");
INSERT INTO buk_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Malô goc iŋ wê iŋlu sêsa awê si ma ndac iŋlu, “O ŋgac atu lu. Aö wakôm sake bu watap seŋ wandöc taŋli-ŋga sa?” ");
INSERT INTO buk_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ma iŋlu sêô yom ma sêsôm, “Kêŋ whiŋ Pômdau Yisu, dec am oc tap Anötö ndê mwasiŋ nem am si-ŋga sa. Am ti am nem lau hoŋ naŋ ambo nem andu, naŋ asa lêŋ tigeŋ dinaŋ.” ");
INSERT INTO buk_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","33","Têŋ ôbwêc dinaŋ ŋgac yob andu gapocwalô-ŋga kôc iŋlu ma kêgwasiŋ iŋlu gamboc. Ma iŋlu sêwhê Pômdau ndê yom sa têŋ iŋ ti lau hoŋ naŋ sêmbo iŋ ndê andu. Ma iŋ ti ndê lau hoŋ sêliŋ saŋgu. ");
INSERT INTO buk_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tiŋambu iŋ kôc iŋlu sêsôc iŋ ndê andu si ma kêŋ gêŋ daneŋ-ŋga iŋlu seŋ. Iŋ tac ŋayham atu bu iŋ ti ndê lau hoŋ kwahic dec sêkêŋ whiŋ Anötö. ");
INSERT INTO buk_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","T êŋ galaŋsê bêbêc lau sêmatôc yom-ŋga sêŋkiŋ lau siŋ-ŋga ŋatô sêtêŋ ŋgac yob gapocwalô-ŋga si, bu sêsôm têŋ iŋ bu êŋgapwêc Pol lu Sailas su. ");
INSERT INTO buk_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ŋgac naŋ yob andu gapocwalô-ŋga ŋgô yom dau, goc sôm têŋ Pol, “Lau sêmatôc yom-ŋga sêkêŋ yom meŋ bu waŋgapwêc amlu Sailas su yêc gapocwalô. Bocdinaŋ amlu alhö andi ti yom malô.” ");
INSERT INTO buk_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Magoc Pol sôm têŋ lau s iŋ-ŋga dinaŋ, “Alu ŋgac Israel-ŋga, magoc alu ŋgac Rom-ŋga awhiŋ. Sêmatôc alu mba yom ŋapep dom, ma sic alu yêc lau hoŋ aŋgô-ŋga e sêkêŋ alu andöc dec. Ma bocke dec ŋac bu sêhu alu siŋ gelec alhö andi? Mba! Ŋac dau sêmeŋ ma sêwê alu asa andi.” ");
INSERT INTO buk_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Lau siŋ-ŋga dinaŋ sêmbu si ma sic miŋ yom dau têŋ lau sêmatôc yom-ŋga. Ŋac sêŋgô bu Pol lu Sailas iŋlu ŋgac Rom-ŋga sêtôm ŋac, dec ŋac sêtöc dau atu. ");
INSERT INTO buk_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Goc ŋac sêtêŋ gapocwalô si ma sêkôm bu sênem malô iŋlu si ŋalôm. Sêkôc iŋlu su yêc andu gapocwalô-ŋga, ma sêwê iŋlu sêsa si. Ma sêndac iŋlu bu sêhu malac dau siŋ. ");
INSERT INTO buk_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Têŋ ndoc Pol lu Sailas sêhu gapocwalô siŋ, naŋ iŋlu sêtêŋ Lidia ndê andu si. Sêkac lau sêkêŋ whiŋ-ŋga hoŋ sa, ma sêsôm yom ŋayham daêsam tu sêpuc ŋac dôŋ-ŋga. Ma tiŋambu sêhu ŋac siŋ. ");
INSERT INTO buk_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Iŋlu sêŋsêlêŋ si sêsa seŋ têŋ malac Ampipolis ma Apolonia, ma gacgeŋ si e sêhôc asê Tesalonika. Yêc malac dinaŋ lau Israel si lôm wê-ŋga daŋ kalhac. ");
INSERT INTO buk_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pol kêkuc iŋ ndê mêtê, ma têŋ Sabat sôc lôm wê-ŋga dau gi. Ma gitôm Sabat tö iŋ gêm yomgalôm whiŋ lau yêc dindê, bu whê ŋac si gauc sa pi Anötö ndê yom daêsam naŋ sêto yêc muŋ su naŋ. ");
INSERT INTO buk_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Iŋ whê sa ma tôc asê bu Mesaya gic waê bu hôc ŋandê e mbac ndu, ma tisa akêŋ lau batê-ŋga ma mbo tali tiyham. Dec iŋ sôm têŋ ŋac, “Kwahic dec aö wasôm têŋ mac bu Yisu iŋ Mesaya dau. Yom ŋandô!” ");
INSERT INTO buk_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Lau Israel-ŋga ŋatô sêkêŋ whiŋ ma sêlhac sêwhiŋ Pol lu Sailas. Ma lau Grik-ŋga daêsam naŋ sêtoc Anötö sa, naŋ sêkêŋ whiŋ, ma lauwhê tiwaê daêsam bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Magoc lau Israel-ŋga ŋatô sem lêmuŋ Pol lu Sailas, dec sêsôc malac lôm si, ma sêkac lau sac ŋatô sa sêpitigeŋ, ma sêŋgilí ŋac tu bu sêndic hu kisa. Ŋac sêŋyalê bu Pol lu Sailas sêyêc Jason ndê andu, dec sênti sêtêŋ andu dau si, bu sêhê iŋlu sêsa sêmeŋ. ");
INSERT INTO buk_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Magoc sêtap iŋlu sa dom, ma bocdinaŋ sêkôc Jason ti lau sêkêŋ whiŋ-ŋga ŋatô ma sêkêŋ ŋac sêlhac lau bata malac-ŋga aŋgô-ŋga. Ma sêsôm ŋa awha atu, “Lau naŋ sêli lau ŋalôm sa yêc gameŋ hoŋ, naŋ kwahic dec sêmeŋ sêkôm yêc yac neŋ malac. ");
INSERT INTO buk_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ma Jason, ŋgac dindec, iŋ kôc ŋac sa sêmbo iŋ ndê andu. Ŋac sêsôc †Sisa ndê ŋagôliŋ ŋapu dom, ma ŋac hoŋ sêsôm bu kiŋ daŋ tiyham mbo, naŋ ndê ŋaê Yisu.” ");
INSERT INTO buk_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Lau bata ti lau toŋ dinaŋ ma lau malac-ŋga hoŋ sêŋgô yom dinaŋ e gêli ŋac si ŋalôm sa ŋandô. ");
INSERT INTO buk_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Goc sêsôm bu Jason ti iŋ ndê lau sênemlhi dau su yêc gapocwalô. Semlhi su goc sêkêŋ ŋac sêlhö si. ");
INSERT INTO buk_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Lau sêkêŋ whiŋ-ŋga yêc Tesalonika sêhôŋ e ŋasec sa su, goc sêŋkiŋ Pol lu Sailas sêlhö sêtêŋ malac Berea si. Sêhôc asê su sêmbo malac dinaŋ, ma sêsôc lau Israel si lôm wê-ŋga si ma sem mêtê. ");
INSERT INTO buk_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Lau Berea-ŋga ŋac lau si mêtê ŋayham hôc gêlêc lau Tesalonika-ŋga si mêtê. Sêkêŋ daŋga ŋapep têŋ Pol lu Sailas si yom pi Yisu, ma sêkôc sa ti atac whiŋ. Ma tôm bêc hoŋ sem dôhôŋ yom dau whiŋ Anötö ndê yom naŋ sêto muŋ su yêc naŋ. Ŋac bu sêŋyalê iŋlu si yom bu yom ŋandô me mba. ");
INSERT INTO buk_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ma lau Israel-ŋga daêsam sêkêŋ whiŋ Yisu, ma yêc lau Grik-ŋga, lauwhê tiwaê ma lauŋgac daêsam sêkêŋ whiŋ bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Malô goc lau Israel-ŋga yêc malac Tesalonika sêŋgô ŋawaê bu Pol gêm Anötö ndê mêtê têŋ lau mbo Berea. Dec ŋac sêtêŋ Berea si, bu sêli lau ŋalôm sa bu sêkêŋ kisa Pol lu Sailas. ");
INSERT INTO buk_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Tu dinaŋ-ŋga lau sêkêŋ whiŋ-ŋga sêŋkiŋ Pol kölhö têŋ malac daŋ yêc gameŋ gwêc-ŋga gi. Magoc Sailas lu Timoti gacgeŋ sêmbo malac Berea. ");
INSERT INTO buk_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Lau naŋ sêhoŋ Pol ma sêsa seŋ sêwhiŋ iŋ, naŋ sêkôc iŋ sêsip malac Atens si. Goc Pol kêkiŋ ŋac sêmbu si, ma sôm bu sêkêŋ yom têŋ Sailas lu Timoti bu sêtêŋ iŋ sêmeŋ ŋagahô. ");
INSERT INTO buk_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pol hôŋ iŋlu mbo Atens, ma gêlic anötöi gwam daêsam sêlhac malac lôm, dec kôm iŋ ŋalôm ŋawapac. ");
INSERT INTO buk_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Bocdinaŋ iŋ sôc lôm wê-ŋga gi ma gêm yomgalôm whiŋ lau Israel ti lau Grik-ŋga naŋ sêtoc Anötö sa. Ma tôm bêc hoŋ iŋ sôc malac lôm gi tap lau ŋatô sa, ma whê Anötö ndê yom sa têŋ ŋac bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Yêc Atens lau ŋatô sêmbo, naŋ êlêmê sem yomgalôm pi gêŋ hoŋ ŋahu sêwhiŋ dau. Sêsam ŋac bu lau Epikuria ma lau Stoik. Têŋ ndoc ŋac si lau ŋatô sêŋgô Pol sôm ŋawaê ŋayham asê pi Yisu, ma pi lêŋ datisa akêŋ lau batê-ŋga, naŋ ŋac sic hu sêseŋ iŋ ndê gauc ti yom ŋatô. Lau ŋatô sêsôm, “Ŋgac dindec sôm yom daêsam ŋapaŋ, ŋahu bocke?” Ma ŋatô sêsôm, “Mboe iŋ bu nem yac neŋ gauc kwi tu bu dakêŋ whiŋ anötöi apa-ŋga.” ");
INSERT INTO buk_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Bocdinaŋ dec sêwê iŋ sêtêŋ gameŋ naŋ sêsam bu Areopagas, gameŋ naŋ lau naŋ sêkip gêŋ ŋahu sa-ŋga êlêmê sêkac sa sêmbo. Ŋac sêkêŋ Pol kalhac lau Areopagas-ŋga aŋgô-ŋga, ma sêndac iŋ bocdec bu, “Gitôm bu am whê yom wakuc naŋ am kêdôhôŋ têŋ lau, naŋ sa têŋ yac? ");
INSERT INTO buk_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Yac aŋgô am nem yom tôm yom wakuc andô daŋ, ma yac bu aŋyalê yom dau ŋahu.” ");
INSERT INTO buk_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Lau Atens ti lau apa hoŋ naŋ sêndöc malac dinaŋ, naŋ sêmbo tu sêŋgô yom ti sênem yomgalôm ŋapaŋ pi gauc wakuc bocke naŋ hôc asê ŋac-ŋga. Ŋac si gweleŋ daŋ mba. Tu dinaŋ-ŋga dec ŋac bu sêŋgô Pol ndê yom. ");
INSERT INTO buk_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ma Pol tisa kalhac lau aŋgô-ŋga yêc Areopagas, ma sôm, “O mac lau Atens-ŋga. Aö kayalê bu mac akôm gêŋ daêsam tu bu anem akiŋ anötöi nom-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Bu aö kasêlêŋ ti gatôc gwaniŋ gêŋ hoŋ naŋ mac amasaŋ tu anem akiŋ mac nem anötöi-ŋga. Ma aö gatap alta daŋ sa, naŋ mac ato yom pi bocdec bu, ‘Anötö naŋ yac tam gauc, naŋ ndê alta.’ Anötö naŋ mac am akiŋ magoc am gauc iŋ, naŋ kwahic dec aö oc wawhê iŋ sa têŋ mac. ");
INSERT INTO buk_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Iŋ Anötö, naŋ kêŋ nom ti gêŋ hoŋ, ma iŋ undambê ti nom ŋadau. Ma bocdinaŋ iŋ ndöc lôm dabuŋ naŋ ŋamalac amba sêmasaŋ, naŋ dom. ");
INSERT INTO buk_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ma gêŋ naŋ ŋamalac sêmasaŋ, naŋ oc nem iŋ sa ŋalêŋ bocke? Bu iŋ pônda gêŋ daŋ dom. Ma iŋ dau kêŋ wayahô têŋ ŋamalac bu sêmbo tali ma kêŋ gêŋ hoŋ bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Iŋ kêŋ ŋamalac ŋamata-ŋga mbo nom e kwahic dec lau titoŋ-titoŋ hoŋ sêsa akêŋ ŋgac tigeŋ dinaŋ, ma sem nom ŋagameŋ sambob ahuc. Lau titoŋ-titoŋ hoŋ si gameŋ ŋabatiŋ, naŋ Anötö kêyaliŋ sa gwanaŋ su, ma têm bu lau toŋ tigeŋ-tigeŋ si ŋaclai tiatu ma tisauŋ, naŋ kêmatiŋ tidôŋ gwanaŋ su bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Anötö kôm gêŋ hoŋ dinaŋ tu bu lau sêlic, ma sêŋsalê iŋ e sêtap iŋ sa. Magoc iŋ mbo baliŋ têŋ yac lau tigeŋ-tigeŋ dom. ");
INSERT INTO buk_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Tôm yom ŋagauc daŋ naŋ mac daôm nem ŋgac daŋ to muŋ su, naŋ sôm, ‘Tu Anötö ndê ŋaclai-ŋga dec yac dambo taŋli ma taŋsêlêŋ, ma yac neŋ ŋahu yêc sip iŋ-ŋga.’ Ma mac nem ŋgac daŋ tiyham to yom ŋagauc daŋ bocdec bu, ‘Yac dati iŋ ndê balêkoc.’ ");
INSERT INTO buk_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Yac dati iŋ ndê balêkoc ma bocdinaŋ yac bu gauc nem bu iŋ gitôm gol me silba me hoc me ŋagatu daŋ, naŋ ŋamalac sêmasaŋ tôm ŋac si gauc, naŋ dec yac gauc gêm yom so pi iŋ. ");
INSERT INTO buk_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Muŋ-ŋga lau daêsam gauc gêm yom bocdinaŋ, bu sêŋyalê Anötö dom. Magoc iŋ kêŋ ŋagêyô têŋ ŋac dom. Tigeŋ kwahic dec iŋ gic atu bu lau hoŋ sênem dau kwi. ");
INSERT INTO buk_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Bu iŋ kêyaliŋ bêc daŋ sa bu êmatôc lau nom-ŋga hoŋ, ma iŋ oc kôm gêŋ dau êŋkuc iŋ ndê lêŋ gitêŋ. Ma iŋ k êyaliŋ ŋgac daŋ sa bu kôm gweleŋ dau. Iŋ uŋ ŋgac dau sa akêŋ lau batê-ŋga, dec tôc gêŋ dau tiawê têŋ lau hoŋ sêlic.” ");
INSERT INTO buk_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Têŋ ndoc sêŋgô Pol ndê yom pi lau sêtisa akêŋ lau batê-ŋga, naŋ lau ŋatô sêpu iŋ. Magoc lau ŋatô sêsôm, “Yac bu aŋgô am nem yom pi gêŋ dinaŋ tiyham.” ");
INSERT INTO buk_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ma têŋ dinaŋ Pol tisa ma hu lau naŋ sêndöc Areopagas, naŋ siŋ. ");
INSERT INTO buk_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Lau ŋatô sêŋkuc Pol ma sêkêŋ whiŋ Yisu. Ŋac si daŋ iŋ Dionisias, naŋ muŋ-ŋga ndöc whiŋ lau naŋ sêkac sa yêc Areopagas. Ma awhê daŋ ŋaê Damaris ma lau ŋatô sêkêŋ whiŋ bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Tiŋambu Pol hu Atens siŋ ma têŋ malac Korin gi. ");
INSERT INTO buk_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Yêc dinaŋ iŋ tap ŋgac Israel-ŋga daŋ sa, naŋ ndê ŋaê Akwila. Iŋ dinda kôc iŋ yêc gameŋ Pontus-ŋga, ma muŋ-ŋga iŋlu ndê awhê Prisila sêndöc malac Rom yêc gameŋ Itali-ŋga. Magoc tiŋambu Kiŋ Klaudias kêŋ yatu bu lau Israel-ŋga hoŋ sêhu malac Rom siŋ, dec iŋlu Prisila sêlhö si sêmbo malac Korin. Têŋ ndoc Pol hôc asê, naŋ gi gêlic iŋlu. ");
INSERT INTO buk_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Akwila lu Prisila i ŋlu awhê lu ŋgac sêkôc bôc ŋamlic ma po ma sêsi pitigeŋ tu sêmasaŋ bac-ŋga. Pol kêyalê gweleŋ dau tidôŋ whiŋ, bocdinaŋ dec mbo whiŋ iŋlu, ma sêkôm gweleŋ sêwhiŋ dau. ");
INSERT INTO buk_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pol tac whiŋ bu lau I srael ma lau Grik naŋ sêmbo Korin sêkêŋ whiŋ Pômdau, dec tôm bêc Sabat-ŋga hoŋ sôc lôm wê-ŋga gi, ma gêm yomgalôm whiŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Têŋ ndoc Sailas lu Timoti sêmeŋ akêŋ gameŋ Masedonia-ŋga, naŋ Pol kêŋ dau sambuc tu gweleŋ nem mêtê lau-ŋga. Iŋ hoc yom asê têŋ lau Israel-ŋga ma sôm têŋ ŋac bu Yisu iŋ Mesaya dau. ");
INSERT INTO buk_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Magoc lau Israel-ŋga sêkêŋ whiŋ Pol ndê yom dom, ma sêli awha sa têŋ iŋ. Bocdinaŋ iŋ kêgoloŋ kop su yêc ndê ŋakwê bu tôc ŋac si giso asê, ma sôm, “Mac atec Anötö ndê yom, dec awêkaiŋ daôm nem ŋagêyô. Aö dom. Kwahic dec wahu mac lau Israel-ŋga siŋ, ma wakôm gweleŋ têŋ lau naŋ lau Israel dom.” ");
INSERT INTO buk_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Goc Pol hu lôm wê-ŋga siŋ, ma sa gi mbo Titius Justus ndê andu. Iŋ ŋgac gameŋ apa-ŋga naŋ gêm akiŋ Anötö, ma iŋ ndê andu kalhac kêpiŋ lôm wê-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ma ŋgac bata lôm wê-ŋga daŋ ŋaê Krispas, ti lau hoŋ naŋ sêmbo iŋ ndê andu, naŋ sêkêŋ whiŋ Pômdau. Ma lau Korin-ŋga daêsam naŋ sêŋgô Pol ndê yom, naŋ sêkêŋ whiŋ Yisu ma sêliŋ saŋgu. ");
INSERT INTO buk_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Têŋ ôbwêc daŋ Pol yêc mbê, ma gêlic Pômdau sôm yom têŋ iŋ bocdec bu, “Töc daôm dom. Sôm aneŋ yom asê ŋapaŋ, ma nem daôm dôŋ dom. ");
INSERT INTO buk_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Bu aö gambo gawhiŋ am, ma oc tôm dom bu lau daŋ sêkêŋ sac am. Bu yêc malac dindec, aneŋ lau daêsam sêmbo.” ");
INSERT INTO buk_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Bocdinaŋ Pol mbo Korin tôm yala tigeŋ ma ayô 6, ma kêdôhôŋ Anötö ndê yom têŋ lau. ");
INSERT INTO buk_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Têŋ ndoc naŋ Galio gêm gôliŋ gameŋ Akaya-ŋga, naŋ lau Israel-ŋga naŋ sêndöc malac Korin, naŋ sêkêŋ si ŋalôm pitigeŋ bu sêkêŋ kisa Pol. Ma sêkêŋ iŋ kalhac Galio aŋgô-ŋga bu êmatôc iŋ ndê yom. ");
INSERT INTO buk_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ma ŋac sêsôm, “Ŋgac dindec kêdôhôŋ lau bu sênem akiŋ Anötö ŋa lêŋ naŋ so yac mba yomsu.” ");
INSERT INTO buk_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol kac awha sa bu sôm yom, m agoc Galio dau ô lau Israel si yom ma sôm, “O mac lau Israel-ŋga! Mac nem yom dec bu hêganôŋ sac atu daŋ, me gêŋ naŋ so ŋagôliŋ Rom-ŋga, dec waŋgô. ");
INSERT INTO buk_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Magoc yom naŋ mac asôm pi ŋgac dindec, naŋ hêganôŋ mac daôm nem yom ti ŋaê ŋatô ma yomsu Israel-ŋga. Bocdinaŋ mac daôm amasaŋ. Aö oc wamatôc yom kaiŋ dinaŋ dom.” ");
INSERT INTO buk_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Dec iŋ soc ŋac su yêc andu matôc-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ma lau hoŋ sêkôc Sostene, ŋgac bata naŋ yob lau Israel-ŋga si lôm wê-ŋga yêc malac Korin, naŋ dôŋ, ma sic iŋ yêc lau matôc-ŋga aŋgô-ŋga. Ma Galio gêlic, magoc kôm tôm gêm gauc. ");
INSERT INTO buk_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol mbo malac Korin têm baliŋ ŋagec, goc hu lau sêkêŋ whiŋ-ŋga siŋ ma têŋ malac Kenkria gi, bu kôc waŋ ma mbu têŋ gameŋ Siria-ŋga ndi. Ma Prisila lu Akwila sêwhiŋ iŋ si. Muŋ-ŋga Pol gic bata yom daŋ têŋ Anötö, ma tu dinaŋ-ŋ ga têŋ ndoc sêmbo malac Kenkria, naŋ kêŋ kêclauŋ sêŋgapiŋ tiapê. Pacndê su, goc ŋac sêpi waŋ ma sêlhö si. ");
INSERT INTO buk_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","20","Sêtêŋ malac Epesas si, ma Pol sôc lôm wê-ŋga gi, ma gêm yomgalôm whiŋ lau Israel-ŋga. Ma ŋac sêndac iŋ bu mbo whiŋ ŋac têm ŋatô tiyham, magoc iŋ gôlôc têŋ ŋac dom. Iŋ hu Prisila lu Akwila siŋ sêmbo sêwhiŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ma têŋ ndoc iŋ pi waŋ gi, naŋ kêmatiŋ yom têŋ lau Epesas-ŋga bocdec bu, “Anötö bu lic ŋayham, dec aö wambu watêŋ mac wameŋ tiyham.” Goc waŋ dau hu Epesas siŋ ma sa gi. ");
INSERT INTO buk_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Waŋ dau kêsêlêŋ e hôc asê malac Sisaria, goc Pol sip baö gi. Ma iŋ pi Jerusalem gi ma gic lau sêkêŋ whiŋ-ŋga kêsi yêc dinaŋ. Ma tiŋambu iŋ têŋ malac Antiok gi. ");
INSERT INTO buk_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Iŋ mbo Antiok ŋasawa sauŋ, goc kêsêlêŋ têŋ gameŋ Prigia ma Galesia-ŋga gi. Yêc dindê iŋ golom-golom malac ma puc lau sêkêŋ whiŋ-ŋga dôŋ bu sêlhac ŋaŋga. ");
INSERT INTO buk_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Têŋ ŋasawa dinaŋ ŋgac daŋ ŋaê Apolos hôc asê malac Epesas. I ŋ ŋgac Israel-ŋga naŋ ndê malachu Aleksandria, ma iŋ ŋgac tigauc ma kêyalê Anötö ndê yom naŋ sêto muŋ su yêc, naŋ tidôŋ. ");
INSERT INTO buk_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Lau ŋatô sêndôhôŋ iŋ pi Pômdau Yisu su, ma bocdinaŋ iŋ kêŋ ndê ŋalôm ti gauc sambuc bu êndôhôŋ lau pi Yisu ma whê iŋ ndê yom sa ŋapep. Magoc iŋ kêyalê busaŋgu ŋalêŋ tigeŋ, naŋ Jon ndê lêŋ êŋku lau tu sênem dau kwi-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Yêc Epesas Apolos sôc lôm wê-ŋga gi, ma gêm mêtê ti ŋaŋga. Prisila lu Akwila sêŋgô iŋ ndê yom, dec sêŋgalêm iŋ têŋ iŋlu si andu gi, ma sêwhê yom ŋatô sa têŋ iŋ e iŋ kêyalê Anötö ndê lêŋ nem lau si-ŋga ŋapep eŋ. ");
INSERT INTO buk_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Tiŋambu Apolos bu têŋ gameŋ Akaya-ŋga ndi, dec lau sêkêŋ whiŋ-ŋga yêc malac Epesas sêpuc iŋ ndê ŋalôm dôŋ. Ma sêto bapia têŋ lau Akaya-ŋga naŋ sêtap Anötö ndê mwasiŋ sa ma sêkêŋ whiŋ Yisu, ma sêteŋ ŋac bu sêkôc Apolos sa. Ma têŋ ndoc iŋ hôc asê, naŋ iŋ mbo whiŋ lau sêkêŋ whiŋ-ŋga dinaŋ, ma gêm ŋac sa ŋandô. ");
INSERT INTO buk_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Bu iŋ kalhac ŋaŋga ma ô lau Israel-ŋga si yom yêc lau hoŋ aŋgô-ŋga, ma whê Anötö ndê yom naŋ sêto yêc, naŋ sa, bu tôc asê bu Yisu iŋ Mesaya dau. ");
INSERT INTO buk_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Têŋ ndoc Apolos mbo Korin, naŋ Pol hu gameŋ Prigia ti Galesia-ŋga siŋ, ma kêsêlêŋ ho seŋ lôc-ŋga naŋ sa têŋ malac Epesas gi. Iŋ hôc asê Epesas, ma tap lau sêkêŋ whiŋ-ŋga ŋatô sa. ");
INSERT INTO buk_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ma iŋ ndac ŋac bocdec bu, “Têŋ ndoc mac akêŋ whiŋ tiwakuc, naŋ mac akôc Ŋalau Dabuŋ su, me mba?” Ma sêô yom ma sêsôm, “Mba. Yac akôc Ŋalau Dabuŋ su dom, ma aŋgô yom daŋ pi iŋ dom.” ");
INSERT INTO buk_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Dec Pol ndac, “Mac aliŋ busaŋgu kaiŋ bocke?” Ma sêsôm bu, “Yac aliŋ busaŋgu ŋalêŋ gitôm Jon, Ŋgac Kêku Lau-ŋga ndê.” ");
INSERT INTO buk_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Goc Pol sôm, “Jon kêku lau naŋ sem dau kwi, ma sôm têŋ ŋac bu sêkêŋ whiŋ ŋgac naŋ oc meŋ êŋkuc iŋ, naŋ Yisu.” ");
INSERT INTO buk_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ŋac sêŋgô Pol ndê yom dinaŋ goc sêliŋ busaŋgu tu Pômdau Yisu ndê ŋaê-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ma têŋ ndoc Pol hu amba sac ŋac, naŋ Ŋalau Dabuŋ gêm ŋac ahuc, dec sêsôm yom sem lau apa awha, ma sêhoc yom asê gitôm lau propet. ");
INSERT INTO buk_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Lau naŋ gêŋ dau hôc asê têŋ ŋac, naŋ lauŋgac 12. ");
INSERT INTO buk_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pol mbo malac Epesas ŋasawa gitôm ayô tö, ma sôc lôm wê-ŋga ŋapaŋ. Ma yêc dindê iŋ gêlêŋ yom dôŋ bu whê Anötö ndê gôliŋ ŋahu sa têŋ lau. ");
INSERT INTO buk_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Magoc lau ŋatô si ŋalôm ŋadandi ma sêkôc Pol ndê yom sa dom. Ma yêc lau hoŋ aŋgô-ŋga sêpu seŋ naŋ Pol whê sa têŋ ŋac. Goc Pol hu ŋac siŋ ma kôc lau sêkêŋ whiŋ-ŋga su yêc lôm wê-ŋga. Ma tôm bêc hoŋ iŋ gêm mêtê ŋac mbo Tiranus ndê andu lau sêkac sa-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Iŋ kôm bocdinaŋ tôm yala lu e lau Israel ti Grik-ŋga hoŋ naŋ sêmbo gameŋ Esia-ŋga, naŋ sêŋgô Pômdau ndê ŋawaê. ");
INSERT INTO buk_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Anötö kêŋ ŋaclai têŋ Pol ma kôm gêŋ dalô atu-tu daêsam. ");
INSERT INTO buk_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Iŋ kôc ŋaclai atu, gitôm iŋ bu êmasec po waheŋ-ŋga ti ŋakwê awê-ŋga ma ŋaclai dau oc lom ndi. Ma lau bu sêkôc po dau, ma sêkêŋ sac lau gêmbac ti lau naŋ ŋalau sac sêmbo ŋac si ŋalôm, dec oc kôm ŋac ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Lau Israel-ŋga ŋatô sêkôm gweleŋ sêsoc ŋalau sac yêc lau. Ma ŋac sic hu sêsôm Pômdau Yisu ndê ŋaê asê têŋ ndoc sêkôm gweleŋ dau. Ŋac sêkêŋ yatu ŋalau sac bocdec bu, “Am sa mweŋ, tu Yisu, naŋ Pol gêm mêtê pi iŋ, naŋ ndê ŋaê-ŋga.” ");
INSERT INTO buk_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ma Israel si dabuŋsiga a tu daŋ ŋaê Skiwa ndê atui 7 sêkôm gweleŋ dau sêwhiŋ. ");
INSERT INTO buk_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Magoc têŋ bêc daŋ ŋalau sac daŋ ô ŋac si yom ma sôm, “Yisu lu Pol aö kayalê iŋlu su, magoc mac lau dinaŋ aö kayalê mac dom!” ");
INSERT INTO buk_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Goc ŋgac ti ŋalau sac dinaŋ gic ŋac e ku ŋac dulu, ma gic ŋac basô-basô e sêliŋ dac sac andô ma sênti sêsa akêŋ andu dau ŋamlic ŋambwa-ŋambwa si. ");
INSERT INTO buk_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","T êŋ ndoc lau Israel ti lau Grik-ŋga naŋ sêndöc Epesas naŋ sêŋgô gêŋ dau ŋawaê, naŋ sêtöc dau atu, ma lau hoŋ sêtoc Pômdau Yisu ndê ŋaê sa. ");
INSERT INTO buk_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ma lau daêsam naŋ sic hu sêkêŋ whiŋ Yisu su, magoc sêsap si mêtê akwa dôŋ, naŋ sêtisa sêlhac lau hoŋ aŋgô-ŋga ma sêhoc si sac asê. ");
INSERT INTO buk_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Lau mbectoma-ŋga ŋatô sêkôc si bapia mbec-ŋga ma sêkêŋ pitigeŋ yêc lau aŋgô-ŋga, goc sêpec ya gêŋ. Bapia mbec-ŋga dinaŋ ŋaôli atu-tu. Ŋac bu sêkêŋ hoŋ têŋ lau sênemlhi, dec oc sêtap awa sa gitôm mone silba 50,000. ");
INSERT INTO buk_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ŋalêŋ dinaŋ dec Pômdau ndê yom tiapa, ma kôm gweleŋ ti ŋaclai yêc lau sêkêŋ whiŋ-ŋga si ŋalôm. ");
INSERT INTO buk_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Gêŋ hoŋ dinaŋ hôc asê su, goc Pol gauc gêm bu têŋ gameŋ Masedonia ti Akaya-ŋga ndi, ma tiŋambu mbu têŋ malac Jerusalem ndi. Iŋ sôm, “Aö watêŋ Jerusalem wandi, ma tiŋambu wandic malac Rom kêsi whiŋ.” ");
INSERT INTO buk_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ma iŋ kêkiŋ Timoti lu Erastas, ŋgac lu naŋ sêkôm gweleŋ sêwhiŋ iŋ, naŋ sêmuŋ iŋ sêtêŋ Masedonia si. Ma iŋ dau gacgeŋ mbo ŋasawa sauŋ mbo gameŋ Esia-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Têŋ ŋasawa dinaŋ lau sêli dau sa ŋandô pi seŋ naŋ lau sêkêŋ whiŋ-ŋga sêŋkuc. ");
INSERT INTO buk_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ŋgac naŋ gic hu gêŋ dau naŋ ndê ŋaê Dimitrias. Iŋ ŋgac naŋ pec silba ma kêmasaŋ ti alta me gêŋ ŋatô bu lau sêkêŋ lhac si andu bu sênem akiŋ anötö gwam awhê naŋ sêsam bu Atemis. Ma iŋ ti lau ŋatô sêtap awa daêsam sa yêc gweleŋ dinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Iŋ kêgalêm lau dau sa, sêwhiŋ lau ŋatô naŋ sêkôm gweleŋ kaiŋ tigeŋ, ma sôm têŋ ŋac, “Mac lau! Aŋgô su naŋ. Mac aŋyalê bu yac datap awa atu sa tu gweleŋ dindec-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Magoc mac alic ti aŋgô ŋawaê pi gêŋ naŋ Pol kôm. Iŋ ŋgac naŋ sôm têŋ lau bu gwam naŋ ŋamalac amba sêmasaŋ, naŋ anötö ŋandô dom. Ma iŋ gêm lau daêsam si ŋalôm kwi bu sêhu sakiŋ anötö gwam-ŋga siŋ. Iŋ kôm yêc malac Epesas ma sauŋ iŋ ndê yom oc nem gameŋ Esia-ŋga sambuc ahuc. ");
INSERT INTO buk_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Gêŋ dau oc kôm lau sêlic yac neŋ gweleŋ sac, ma lôm naŋ lau sem akiŋ Atemis sêmbo, naŋ oc sêlic tôm gêŋ ŋambwa. Ma anötö awhê dau, naŋ lau sem akiŋ yêc gameŋ Esia-ŋga ma tôm nom ŋagameŋ hoŋ, naŋ ndê waê oc niŋga.” ");
INSERT INTO buk_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Lau sêŋgô Dimitrias ndê yom ma gêli ŋac si ŋalôm sa e sic hu sêmbwêc, “Lau Epesas-ŋga si anötö Atemis, iŋ anötö tiwaê!” ");
INSERT INTO buk_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Malô goc lau malac-ŋga hoŋ naŋ sêkac sa, naŋ sêli dau sa. Ŋac sêkôc Gaius lu Aristakus, ŋgac lu akêŋ Masedonia naŋ êlêmê sêŋsêlêŋ sêwhiŋ Pol, naŋ dôŋ, ma ŋac hoŋ sênti sêtêŋ gameŋ lau sêkac dau sa-ŋga, naŋ si. ");
INSERT INTO buk_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol tac whiŋ bu sôm yom têŋ lau dau, magoc lau sêkêŋ whiŋ-ŋga sêlhac iŋ ahuc. ");
INSERT INTO buk_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ma lau bata Rom-ŋga ŋatô naŋ sêmbo gameŋ dinaŋ, naŋ Pol ndê silip, naŋ sêkêŋ yom têŋ iŋ, ma sêteŋ iŋ bu têŋ gameŋ dinaŋ ndi dom. ");
INSERT INTO buk_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Lau hoŋ naŋ sêkac dau sa sêmbo, naŋ si gauc kêŋsôŋ. Ŋac hoŋ sêmbwêc yom tidau-tidau. Ma ŋac si daêsam sem gauc ŋahu bocke dec sêkac sa sêmbo dinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Lau Israel-ŋga sêtiŋ ŋac si ŋgac bata daŋ ŋaê Aleksanda sa ŋalhu gi, bu sôm yom ma nem malô lau Epesas-ŋga ŋalôm tu ŋac lau Israel-ŋga. Lau daêsam sêmbwêc yom ŋagauc têŋ iŋ, dec iŋ gic amba bu sênem dau dôŋ ma sêŋgô iŋ ndê yom. ");
INSERT INTO buk_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Magoc lau sêlic bu iŋ ŋgac Israel-ŋga daŋ, dec hoŋ sêmbwêc ŋa awha atu tôm acgatu ŋasawa lu bu, “Lau Epesas-ŋga si anötö Atemis, iŋ anötö tiwaê! Iŋ anötö tiwaê!” ");
INSERT INTO buk_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Têŋ dinaŋ ŋgac bata Epesas-ŋga daŋ tisa ma sôm lau hoŋ mamaŋ. Iŋ ŋgac naŋ to yom naŋ lau bata malac dinaŋ-ŋga sêmatiŋ tidôŋ, ma yob ŋac si bapia. Ma iŋ sôm, “Mac lau Epesas-ŋga, bocke? Lau nom-ŋga hoŋ sêŋyalê bu mac ayob anötö awhê atu Atemis ndê lôm, ti hoc naŋ peŋ sip akêŋ umboŋ, naŋ lau sêtoc sa tôm Atemis ndê ŋagatu. ");
INSERT INTO buk_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Gêŋ hoŋ dinaŋ tôc dau yêc awê su, bocdinaŋ anem daôm dôŋ ma ayob daôm bu akôm gêŋ hoŋ ti gauc eŋ. ");
INSERT INTO buk_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Mac akôc ŋgac lu dinaŋ dôŋ, ma awê iŋlu sêsôc sêmeŋ, magoc sêsu yac neŋ anötö awhê susu dom, ma sem kaŋ gêŋ daŋ yêc iŋ ndê lôm dom. ");
INSERT INTO buk_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Yac neŋ andu sêmatôc yom-ŋga dê sêlhac, ma lau sêmatôc yom-ŋga sêmbo. Dimitrias ti lau sêpec silba-ŋga naŋ si yom bu yêc asa, naŋ dec sêkôc iŋ solop sêtêŋ lau dau sêndi. ");
INSERT INTO buk_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Kwahic dec mac nem yom ŋatô bu yêc, naŋ akêŋ têŋ lau sêmatôc yom-ŋga bu sêmatôc. ");
INSERT INTO buk_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ayob daôm ŋapep! Tu gêŋ naŋ mac akôm têŋ acsalô lec-ŋga, dec gitôm bu mac daôm alhac lau dau aŋgô-ŋga, ma oc atap matôc sa pi mêtê ali lau sa-ŋga. Gêŋ dau bu hôc asê, dec oc tôm dom bu mac amasaŋ yom têŋ ŋgac êmatôc yom-ŋga. Bu gêŋ naŋ mac akôm, naŋ ŋahu ŋayham mbasi.” ");
INSERT INTO buk_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Iŋ sôm yom dinaŋ su, goc kêkiŋ lau sêlhö têŋtêŋ. ");
INSERT INTO buk_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ŋantiŋ atu dau pacndê, goc Pol kêgalêm lau Epesas-ŋga naŋ sêkêŋ whiŋ Yisu, naŋ sa sêpitigeŋ. Iŋ sôm yom bu puc ŋac dôŋ ma êŋgilí ŋac bu sêlhac ŋaŋga, goc poŋ ŋac ma ti bu têŋ Masedonia ndi. ");
INSERT INTO buk_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Iŋ gi hôc asê su, ma kôm gweleŋ golom-golom malac. Iŋ gêm mêtê ti sôm yom daêsam tu bu puc lau si sêkêŋ whiŋ dôŋ-ŋga, ma iŋ kôm ŋapaŋ e hôc asê gameŋ Grik-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Iŋ mbo dindê gitôm ayô tö ma bu pi waŋ daŋ bu mbu têŋ gameŋ Siria-ŋga ndi. Magoc têŋ ndoc dinaŋ lau Israel-ŋga ŋatô sêkic yom bu sêpi waŋ sêwhiŋ sêndi, ma sêkôm iŋ ŋayom. Pol ŋgô ŋapuc, dec iŋ pi waŋ gi dom, magoc mbu sôc gameŋ Masedonia-ŋga gi tiyham. ");
INSERT INTO buk_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Lauŋgac naŋ sêkôm gweleŋ sêwhiŋ iŋ, naŋ si ŋaê bocdec. Sopate, iŋ Pirius atuŋgac akêŋ malac Berea, Aristakus lu Sekundus akêŋ malac Tesalonika, Gaius akêŋ Derbi, ma Tikikus lu Tropimus akêŋ gameŋ Esia-ŋga, ma Timoti. ");
INSERT INTO buk_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Lau hoŋ dinaŋ sêmuŋ si sêhôŋ yac sêmbo malac Troas. ");
INSERT INTO buk_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ma yac ambo malac Pilipai e lau Israel si Mwasiŋ Bolom Yist Mba-ŋga pacndê, goc akôc waŋ daŋ bu atêŋ Troas andi. Waŋ dau kêsêlêŋ mbo gwêc ŋasawa gitôm bêc amaŋdaŋ su, goc yac ahôc asê Troas ma atap lau dinaŋ sa. Ma yac ambo malac dinaŋ tôm wake sambuc daŋ. ");
INSERT INTO buk_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","9","Têŋ Sonda ôbwêc lau sêkêŋ whiŋ-ŋga sêpitigeŋ bu sêneŋ mwasiŋ dabuŋ. Yac akac sa ambo andu baliŋ daŋ, andöc ŋalôm ŋahô titö-ŋga ma lau sêkêŋ lam daêsam sêŋgalêŋ. Pol gauc gêm bu hu Troas siŋ têŋ laŋsê, ma bocdinaŋ gêm mêtê baliŋ e timaniŋhu. Balê wakuc daŋ ŋaê Yutikas ndöc gatam atú ma kêŋ daŋga Pol ndê yom e bêc ku iŋ dulu. Iŋ yêc bêc kêlhiŋ dau siŋ, ma gacgeŋ peŋ sip nom gi akêŋ ŋalôm ŋahô-ŋga dinaŋ. Lau sêsip si bu sêkôc iŋ sa, magoc sêlic bu iŋ mbac ndu su. ");
INSERT INTO buk_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Magoc Pol sip gi, hu dau sac balê dau ŋahô ma kêgape iŋ dôŋ. Ma iŋ sôm têŋ lau, “Mac ahêgo daôm dom. Iŋ tali.” ");
INSERT INTO buk_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Goc iŋ mbu pi andu ŋalôm ŋahô-ŋga tiyham gi. Ma iŋ pô bolom kôc ma ŋac seŋ mwasiŋ dabuŋ. Ma iŋ gic têku iŋ ndê yom tiyham e bêbêc, goc hu ŋac siŋ ma kölhö gi. ");
INSERT INTO buk_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ma balê naŋ Pol uŋ iŋ sa mbo tali tiyham, naŋ lau sêkôc iŋ mbu têŋ iŋ ndê andu gi ti atac ŋayham atu. ");
INSERT INTO buk_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pol gauc gêm bu êŋsêlêŋ ho seŋ têŋ malac Asos ndi, ma sôm têŋ yac bu api waŋ daŋ andi atap iŋ sa yêc dindê. ");
INSERT INTO buk_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Yac a ahôc asê ma iŋ tap yac sa yêc Asos. Ma yac akôc iŋ pi waŋ whiŋ yac, goc atêŋ malac Mitilene a. ");
INSERT INTO buk_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ŋagalaŋsê yac ahu malac dau siŋ ma alac e a gi apoc ampiŋ nduc Kios. Têŋ bêbêc yac alac atêŋ nduc Samos a, ma ŋagalaŋsê ahôc asê malac Miletus. ");
INSERT INTO buk_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","P ol tac whiŋ bu lic Om †Pentikos-ŋga yêc Jerusalem. Tu dinaŋ-ŋga iŋ gauc gêm bu yac andi ŋagahô, ahôc gêlêc malac Epesas, ma ambo gameŋ Esia-ŋga ŋasawa baliŋ dom. ");
INSERT INTO buk_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Têŋ ndoc yac ambo Miletus, naŋ Pol kêŋ yom têŋ lau sêkêŋ whiŋ-ŋga yêc malac Epesas, ma kêgalêm ŋac si lau bata sa sêtêŋ iŋ sêmeŋ. ");
INSERT INTO buk_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ŋac sêhôc asê ma iŋ sôm yom têŋ ŋac bocdec bu, “Mac aŋyalê aneŋ lêŋ hoŋ naŋ gakôm tôm bêc hoŋ naŋ gambo gawhiŋ mac, têŋ bêc ŋamata-ŋga naŋ gahôc asê gameŋ Esia-ŋga ŋapaŋ e meŋ têŋ kwahic dec. ");
INSERT INTO buk_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Lau Israel-ŋga sêkêŋ kisa aö ŋapaŋ dec sêkêŋ ŋawapac atu têŋ aö. Tigeŋ aö kagwiniŋ dauŋ ma gam akiŋ Pômdau ti taŋsulu tu mac-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mac aŋyalê bu yom bocke naŋ gitôm bu nem mac sa, naŋ aö gasêc ahuc têŋ mac dom. Aö gasôm yom hoŋ asê timala eŋ. Aö kadôhôŋ mac yêc lhu, ma kadôhôŋ mac yêc mac nem andu tôm gi. ");
INSERT INTO buk_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Aö gahoc yom asê têŋ lau Israel ti lau Grik su, bu sênem dau kwi ma sêsôc Anötö ŋapu, ma sêkêŋ whiŋ yac neŋ Pômdau Yisu. ");
INSERT INTO buk_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Kwahic dec Ŋalau Dabuŋ kac aö bu watêŋ Jerusalem wandi. Magoc aö kayalê gêŋ bocke naŋ oc hôc asê aö yêc dindê, naŋ dom. ");
INSERT INTO buk_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Gêŋ tigeŋ dec kayalê su, bu yêc malac hoŋ Ŋalau Dabuŋ kêŋ puc aö bu ŋawapac oc sêtap aö sa, ma aö oc wandöc gapocwalô. ");
INSERT INTO buk_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Tigeŋ aö gatöc ti gahêgo dauŋ pi gêŋ dau dom. Aö galic dauŋ ŋamlic gitôm gêŋ ŋambwa-ŋga. Aneŋ gauc atu bu walhac ŋaŋga e wandic dabiŋ gweleŋ naŋ Pômdau Yisu kêŋ têŋ aö. Ma gweleŋ dau bocdec bu, aö oc wahoc ŋawaê ŋayham asê pi Anötö ndê mwasiŋ. ");
INSERT INTO buk_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Mac lau hoŋ naŋ gahoc yom pi Anötö n dê gôliŋ asê têŋ mac su, naŋ aŋgô. Kwahic dec aö kayalê bu mac nem daŋ oc lic aö aŋôŋ tiyham dom. ");
INSERT INTO buk_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Boc-dinaŋ dec wasôm asê têŋ mac, bu ŋamalac asa naŋ tec Anötö ndê yom, naŋ aö oc wawêkaiŋ iŋ ndê ŋagêyô dom. ");
INSERT INTO buk_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Bu aö gawhê Anötö ndê lêŋ hoŋ sa têŋ mac su, yom daŋ siŋ dau yêc-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","“Mac lau dindec, ayob daôm ti lau sêkêŋ whiŋ-ŋga hoŋ ŋapep. Bu Anötö gêmlhi iŋ ndê lau hoŋ su ŋa iŋ dau ndê dac, ma Ŋalau Dabuŋ dau kêyaliŋ mac sa bu ayob ŋac. Bocdinaŋ ayob Anötö ndê domba ŋapep. ");
INSERT INTO buk_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Aö kayalê bu têŋ ndoc aö wahu mac siŋ, naŋ kêdôhôŋwaga tasaŋ oc sêmeŋ gitôm giam pôm naŋ sêsôc sêmeŋ bu sêseŋ domba. ");
INSERT INTO buk_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ma mac daôm nem lau ŋatô oc sêtisa, ma sênem yom ŋandô kwi ti yom tasaŋ, bu sêŋsôŋ lau ŋatô si gauc e sêhu mac ti yom ŋandô siŋ ma sêŋkuc ŋac. ");
INSERT INTO buk_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Bocdinaŋ anem ali ŋapaŋ. Gauc nem bu tôm yala sambuc tö aö gakêŋ puc mac tôm ac ma ôbwêc hoŋ ti taŋsulu eŋ. ");
INSERT INTO buk_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Kwahic dec aö wakêŋ mac asip Anötö amba. Asap yom pi iŋ ndê mwasiŋ atu dôŋ ŋapaŋ. Bu yom dau gitôm bu oc puc mac dôŋ alhac ŋaŋga e awêkaiŋ malam yêc undambê awhiŋ lau dabuŋ hoŋ. ");
INSERT INTO buk_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Aö taŋkwê lau daŋ bu sênem aö sa ŋa gol me silba me ŋakwê dom. ");
INSERT INTO buk_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mac aŋyalê bu aö dauŋ amaŋ gakôm gweleŋ tu watap gêŋ sa bu nem aö ti lau naŋ sêkôm gweleŋ sêwhiŋ aö, naŋ sa. ");
INSERT INTO buk_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Gweleŋ hoŋ naŋ aö gakôm naŋ tôc asê têŋ mac bu dakôm gweleŋ atu kaiŋ dinaŋ ŋapaŋ bu danem lau ŋasac sa dandic ŋawaê. Gauc nem yom naŋ Pômdau Yisu dau sôm bocdec bu, ‘Dakêŋ gêŋ têŋ lau oc êmwasiŋ yac hôc gêlêc lau sêkêŋ gêŋ têŋ yac, naŋ su.’” ");
INSERT INTO buk_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pol gic bata ndê yom goc pôŋ haduc whiŋ ŋac hoŋ, ma teŋ mbec. ");
INSERT INTO buk_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Goc ŋac hoŋ sêŋgape iŋ dôŋ ti sêŋgutô iŋ, ma sêtaŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Pacndê, goc sêhoŋ iŋ sêsa waŋ si. Ŋac si ŋalôm ŋawapac atu pi iŋ ndê yom naŋ sôm bu ŋac oc sêlic iŋ aŋgô tiyham dom. ");
INSERT INTO buk_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Yac ahu ŋac siŋ ma api waŋ a tiyham, ma waŋ dau sa hêganôŋ nduc daŋ ŋaê Kos, naŋ solop gi. Ŋagalaŋsê waŋ dau kôc yac atêŋ malac Rodes, ma a e waŋ sôc malac Patara. ");
INSERT INTO buk_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Yêc dindê yac atap waŋ daŋ sa, naŋ bu têŋ gameŋ Pionisia-ŋga ndi, dec apwê gi alom ma waŋ dau hu Patara siŋ. ");
INSERT INTO buk_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Yac alac e alic nduc Saipras poc ŋalôm-ŋga, ma aŋlêc ambo awê-ŋga ma anti e asôc malac Taya yêc gameŋ Siria-ŋga, ma asip baö a. Waŋ dau kôc wapa malac dinaŋ-ŋga ŋatô. ");
INSERT INTO buk_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Yêc malac Taya yac atap lau sêkêŋ whiŋ-ŋga sa, ma ambo awhiŋ ŋac tôm bêc 7. Ŋalau Dabuŋ kêŋ puc ŋac dec ŋac bu sêlhac Pol ahuc bu têŋ Jerusalem ndi dom. ");
INSERT INTO buk_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Magoc bêc 7 dinaŋ su, goc yac ahu ŋac siŋ bu api waŋ tiyham. Lau sêkêŋ whiŋ-ŋga ti ŋac si lauwhêi ma balêkoc hoŋ sêhoŋ yac asa gwêc a, ma yêc dindê yac apôŋ haŋduc ma ateŋ mbec awhiŋ dauŋ. ");
INSERT INTO buk_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Goc yac akam dauŋ ma ahu dauŋ siŋ. Yac api waŋ ma ŋac sêlhö sêmbu si. ");
INSERT INTO buk_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Waŋ dau sa akêŋ Taya ma kêti e hôc asê malac Tolemai. Yêc dindê yac atap lau sêkêŋ whiŋ-ŋga sa ma ambo awhiŋ ŋac tôm bêc tigeŋ. ");
INSERT INTO buk_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ŋagalaŋsê yac api waŋ tiyham ma alac e asôc malac Sisaria. Ma yac asip baö a ma ayêc awhiŋ ŋgac aheŋ-ŋga daŋ ŋaê Pilip. Muŋ-ŋga sêŋyaliŋ lau 7 sa bu sêndic sam gêŋ daneŋ-ŋga, ma Pilip iŋ ŋac si daŋ. ");
INSERT INTO buk_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Iŋ ndê atuwêi hale sêmbo, naŋ sem ŋgac sa su dom, ma Anötö kêmwasiŋ ŋac hoŋ bu sêhoc yom asê sêtôm propet. ");
INSERT INTO buk_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Yac ambo awhiŋ ŋac bêc ŋatô su, goc propet daŋ ŋaê Agabus sip akêŋ gameŋ Judia-ŋga meŋ. ");
INSERT INTO buk_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Iŋ têŋ yac meŋ, goc kôc Pol ndê piŋkap su, ma sô iŋ dau amba ti ga hi dôŋ. Ma iŋ sôm, “Ŋalau Dabuŋ sôm bu ŋalêŋ tigeŋ lau Israel-ŋga naŋ sêmbo malac Jerusalem, naŋ oc sêsô piŋkap dindec ŋadau dôŋ, ma sêkêŋ iŋ sip lau Rom-ŋga amba.” ");
INSERT INTO buk_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Têŋ ndoc yac aŋgô yom dau, naŋ yac ac yao Pol bu pi Jerusalem ndi dom. ");
INSERT INTO buk_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Magoc iŋ ô yom ma sôm, “Tu sake-ŋga dec mac ataŋ tu aö-ŋga, ma bu akôm aö ŋalôm ndi lu? Ŋac bu sêsô aö dôŋ me sêndic aö ndu yêc Jerusalem tu Pômdau Yisu ndê ŋaê-ŋga, naŋ gitôm.” ");
INSERT INTO buk_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Yac alic bu iŋ oc sôc yac mba yom ŋapu dom, dec ahu siŋ ma asôm, “Gêŋ naŋ Pômdau tac whiŋ bu hôc asê, naŋ ŋandô sa.” ");
INSERT INTO buk_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Dinaŋ su, goc yac amasaŋ dauŋ ma api Jerusalem a. ");
INSERT INTO buk_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Lau sêkêŋ whiŋ-ŋga ŋatô akêŋ Sisaria sêwhiŋ yac, ma sêwê yac atêŋ Nason ndê andu a, bu ambo dindê. Nason iŋ ŋgac akêŋ nduc Saipras, ma iŋ lau ŋamata-ŋga naŋ sêkêŋ whiŋ Yisu, naŋ si daŋ. ");
INSERT INTO buk_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Têŋ ndoc yac ahôc asê Jerusalem, naŋ asidôwai sêkôc yac sa ti atac ŋayham. ");
INSERT INTO buk_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ŋagalaŋsê dec Pol ti yac hoŋ a alic Jems, ma lau bata hoŋ sêkac dau sa sêmbo Jems ndê andu. ");
INSERT INTO buk_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pol kam ŋac, goc gic miŋ yom pi iŋ ndê gweleŋ yêc lau apa si gameŋ, ma pi gêŋ hoŋ naŋ Anötö kôm bu puc gweleŋ dau dôŋ. ");
INSERT INTO buk_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ŋac sêŋgô yom dau su ma sêmpiŋ Anötö. Magoc sêsôm têŋ Pol, “O asidôwa. Lic su naŋ. Yêc dec, lau Israel-ŋga daêsam andô sêkêŋ whiŋ Yisu, magoc sêsap Moses ndê yomsu hoŋ dôŋ ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ma ŋac sêŋgô ŋawaê bu am kêdôhôŋ lau Israel-ŋga naŋ sêndöc lau apa si gameŋ, bu sêhu Moses ndê yomsu siŋ. Sêŋgô bu am sôm têŋ ŋac bu sêhu yac neŋ mêtê dasê balêi si ŋamlic ŋatô su-ŋga, ti yac neŋ gêbôm ŋatô siŋ. ");
INSERT INTO buk_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Bocdinaŋ kwahic dec yac oc dakôm bocke? Ŋac oc sêŋgô ŋawaê bu am mweŋ su. ");
INSERT INTO buk_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","D ec yac gauc gêm bu am kôm b ocdec. Yac mba lau hale dec sêmbo, naŋ sêmatiŋ yom tu bu sênem dabuŋ dau-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Bocdinaŋ am kôc lau dau sa ma êmkuc yac lau Israel-ŋga neŋ lêŋ tamasaŋ dauŋ ŋawasi sa yêc Anötö aŋgô-ŋga, ma nem dabuŋ daôm whiŋ ŋac. Nem ŋac sa ma nemlhi gêŋ bocke naŋ sêpônda bu sêndic dabiŋ yom naŋ sêmatiŋ têŋ Anötö, ma sêŋgaliŋ ŋac kêclauŋ su. Kôm bocdinaŋ dec lau Jerusalem-ŋga oc sêŋyalê bu yom naŋ sêŋgô pi am, naŋ ŋahu mbasi. Ŋac oc sêlic bu am daôm sap yac neŋ yomsu dôŋ ma sa lêŋ hoŋ ŋapep. ");
INSERT INTO buk_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ma yom naŋ yac tamatiŋ pi lau gameŋ apa-ŋga naŋ sêkêŋ whiŋ Yisu, ma dato sip bapia ma dakêŋ têŋ ŋac su, naŋ dec yac oc daseŋ su dom. Yac dato têŋ ŋac bu sêneŋ gêŋ daneŋ-ŋga naŋ lau sêkêŋ ti da têŋ anötöi gwam naŋ dom, ma dac ma wata ti dac, naŋ sêneŋ daŋ dom bocdinaŋ. Ma dato bu sêkôm mêtê mockaiŋ-ŋga dom.” ");
INSERT INTO buk_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Têŋ galaŋsê Pol kôc lau hale dinaŋ sa, goc gic hu têm tu bu êmasaŋ dau ŋawasi sa yêc Anötö aŋgô-ŋga, ma kêkuc lêŋ sênem dabuŋ dau-ŋga whiŋ ŋac. Goc iŋ sôc lôm dabuŋ gi bu kêŋ ŋawaê têŋ dabuŋsiga pi bêc bocke ŋac si ndoc sênem dabuŋ dau-ŋga oc pacndê, ma ŋac tigeŋ-tigeŋ oc sêkêŋ si da. ");
INSERT INTO buk_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Pol ndê bêc 7 bu êmasaŋ dau ŋawasi sa-ŋga kêpiŋ bu pacndê, ma lau Israel-ŋga ŋatô akêŋ gameŋ Esia-ŋga sêlic iŋ yêc lôm dabuŋ. Goc sêli lau hoŋ ŋalôm sa bu sêkôc iŋ dôŋ. ");
INSERT INTO buk_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ŋac sêmbwêc, “Mac lau Israel-ŋga, ameŋ anem yac sa. Alic ŋgac dec. Iŋ ŋgac naŋ kêdôhôŋ lau tôm gameŋ hoŋ, ma pu yac lau Israel-ŋga ti yac neŋ yomsu, ma pu gameŋ dindec whiŋ. Ma gêŋ daŋ tiyham. Iŋ kôc lau Grik ŋatô sêsôc lôm dabuŋ ŋabatêmndö sêmeŋ, dec kôm gameŋ dabuŋ dindec ŋadômbwi sa.” ");
INSERT INTO buk_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ŋac sêsôm yom dinaŋ ŋahu bu muŋ-ŋga sêlic ŋgac Epesas-ŋga daŋ ŋaê Tropimus, mbo malac Jerusalem whiŋ Pol. Ma ŋac gauc gêm bu mboe Pol kôc iŋ têŋ lôm dabuŋ gi. ");
INSERT INTO buk_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Têŋ dinaŋ lau malac-ŋga hoŋ sêli dau sa ŋandô ma sic dau sa sêpitigeŋ yêc lôm dabuŋ ŋabatêmndö. Ŋac sêkôc Pol dôŋ ma sêhê iŋ sa awê gi, goc lau sic gameŋ dau ŋagatam ahuc. ");
INSERT INTO buk_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ŋac sêkôm bu sêndic iŋ ndu sêmbo, ma lau siŋ Rom-ŋga si ŋadau ŋgô ŋawaê bu lau malac Jerusalem-ŋga hoŋ sêli dau sa. ");
INSERT INTO buk_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Goc ŋagahô iŋ kôc lau siŋ-ŋga ti ŋac si lau bata ŋatô, ma sênti sêtêŋ lau toŋ dinaŋ si. Ma têŋ ndoc lau dau sêlic ŋgac bata ti iŋ ndê lau siŋ-ŋga, naŋ sic Pol tiyham dom. ");
INSERT INTO buk_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Goc lau siŋ si ŋadau kôc ndê lau ma sêkôc Pol dôŋ, ma iŋ gic atu bu sêsô iŋ dôŋ ŋa sen lu. Goc iŋ ndac lau bu iŋ asa, ma iŋ kôm sac bocke. ");
INSERT INTO buk_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Lau yêc toŋ atu ŋalôm sêmbwêc yom tidau-tidau, dec ŋgac dau kêyalê bu iŋ gitôm dom bu tap gêŋ dau ŋahu sa. Goc iŋ gic atu bu sêkôc Pol sêtêŋ lau siŋ-ŋga si gameŋ sêndi. ");
INSERT INTO buk_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Têŋ ndoc sêhôc asê tuŋbôm ŋa-têc naŋ yêc gameŋ dau ŋasactô, naŋ lau sêkôm mwasac ŋaŋga bu sêndic Pol ndu. Tu dinaŋ-ŋga lau siŋ-ŋga sêhôc iŋ sa lôlôc bu sêkôc iŋ sôc ŋac si gameŋ sêndi. ");
INSERT INTO buk_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ma lau toŋ atu naŋ sêŋkuc, naŋ sêmbwêc ŋapaŋ, “Ndic iŋ ndu! Ndic iŋ ndu!” ");
INSERT INTO buk_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Lau siŋ-ŋga bu sêkôc Pol sôc ŋac si gameŋ ŋalôm ndi, magoc iŋ ndac ŋac si ŋadau bocdec bu, “Gitôm bu wasôm yom daŋ têŋ am, me?” Ma ŋgac dau ndac, “Am kêyalê yom Grik, a? ");
INSERT INTO buk_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Aö gam gauc bu am ŋgac Isip-ŋga naŋ ndoc dê giŋga su, gic nem lau gitôm 4,000 sa yêc gameŋ sawa, ma kêgilí ŋac bu sêndic siŋ têŋ lau Rom-ŋga.” ");
INSERT INTO buk_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Magoc Pol sôm, “Mba! Aö ŋgac Israel-ŋga daŋ, ma aneŋ malac Tasis yêc gameŋ Silisia-ŋga. Iŋ malac ŋambwa dom, malac tiwaê. Kwahic dec aö bu wandac am gitôm bu wasôm yom têŋ lau dindec, me mba?” ");
INSERT INTO buk_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Lau siŋ-ŋga si ŋadau gôlôc, dec Pol kac dau kwi kalhac têc, ma gic amba têŋ lau bu sênem dau dôŋ. Ma têŋ ndoc gameŋ ŋaŋeŋ sa, naŋ gic hu sôm yom têŋ ŋac ŋa Yom †Hibru. ");
INSERT INTO buk_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Iŋ sôm, “O asidôwai ti damaŋi. Akêŋ daŋam ma aö waô yom naŋ lau sêŋgôliŋ pi aö.” ");
INSERT INTO buk_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ŋac sêŋgô iŋ sôm yom têŋ ŋac yêc ŋac dau si awha, naŋ Yom Hibru, dec lau hoŋ sem dau dôŋ ma sêhê daŋga iŋ. Goc iŋ sôm, ");
INSERT INTO buk_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Aö ŋgac Israel-ŋga. Dinaŋ kôc aö yêc gameŋ Silisia-ŋga, ma aneŋ malachu Tasis. Magoc aö gatiatu yêc malac atu dindec, ma kadôhôŋ abaŋi si yomsu hoŋ ŋapep eŋ gambo Gamaliel ŋapu. Aö gayêm dauŋ su ŋandô tu wanem akiŋ Anötö-ŋga tôm kwahic dec mac daôm gauc gêm bu akôm. ");
INSERT INTO buk_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Aö gakêŋ kisa lau naŋ sêŋkuc lêŋ wakuc dindec, ma gakêŋ lauwhê ma ŋgac sêkêŋ whiŋ Yisu-ŋga daêsam sêsôc gapocwalô, ma gac atu bu lau sêndic ŋatô ndu. ");
INSERT INTO buk_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Dabuŋsiga ŋamata-ŋga ti lau bata hoŋ sêŋyalê aneŋ gweleŋ dinaŋ. Ŋac lau dinaŋ sêto bapia puc aö dôŋ-ŋga têŋ lau bata Israel-ŋga naŋ sêmbo malac Damaskas. Têŋ bêc daŋ aö kasêlêŋ gambo seŋ bu wasip Damaskas wandi, bu wakôc lau sêkêŋ whiŋ Yisu-ŋga yêc dindê sa sêtêŋ Jerusalem sêmeŋ, bu sêkêŋ ŋandê têŋ ŋac. ");
INSERT INTO buk_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Aö kasêlêŋ e têŋ ac kac lhu gasuŋ sa Damaskas, ma sep tigeŋ ŋawê undambê-ŋga atu daŋ pô aö. ");
INSERT INTO buk_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Dec gapeŋ gasip nom ma gaŋgô awha daŋ sôm yom têŋ aö bu, ‘Saul, Saul, tu sake-ŋga am kêŋ kisa aö?’ ");
INSERT INTO buk_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ma aö gandac bu, ‘O ŋadau, am asa?’ Goc awha dau ô yom ma sôm, ‘Aö Yisu Nasaret-ŋga naŋ am kêŋ kisa.’ ");
INSERT INTO buk_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Lau naŋ sêwhiŋ aö naŋ sêlic ŋawê dau ma sêŋgô awha, magoc sêŋyalê yom naŋ Yisu sôm têŋ aö, naŋ dom. ");
INSERT INTO buk_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ma aö gandac, ‘Pômdau, aö wakôm sake?’ Ma iŋ sôm, ‘Tisa, ma sôc Damaskas ndi. Ma gêŋ bocke naŋ aö tac whiŋ bu am kôm-ŋga, naŋ aö oc waŋkiŋ lau bu sêwhê sa têŋ am yêc dindê.’ ");
INSERT INTO buk_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","“Ŋawê dau kôm aö tanôŋ tipec, bocdinaŋ dec lau naŋ sêwhiŋ aö sêhê aö amaŋ, ma sêwê aö gasôc Damaskas ga. ");
INSERT INTO buk_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Ma ŋgac daŋ ŋaê Ananias meŋ gêlic aö. Iŋ ŋgac naŋ sa ndê lêŋ hoŋ kêkuc yomsu Israel-ŋga ŋapep, ma lau Israel Damaskas-ŋga hoŋ sêtoc iŋ sa. ");
INSERT INTO buk_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Iŋ kalhac kêpiŋ aö ma sôm, ‘Asidôwa Saul, tanôm ŋawa sa!’ Ma têŋ ndoc dinaŋ eŋ aö tanôŋ ŋayham sa e galic iŋ. ");
INSERT INTO buk_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ma iŋ sôm, ‘Damaŋi si Anötö kêyaliŋ am sa bu êmyalê iŋ ndê atac whiŋ, ma bu lic ŋgac gitêŋ Yisu dau, ma bu ŋgô yom yêc iŋ dau whasuŋ. ");
INSERT INTO buk_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ma am oc hoc yom ŋandô pi iŋ asê têŋ lau hoŋ, ma sôm yom asê pi gêŋ hoŋ naŋ am gêlic ti ŋgô su. ");
INSERT INTO buk_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ma kwahic dec am hôŋ sake? Tisa ma liŋ busaŋgu tu Yisu ndê ŋaê-ŋga bu êŋgwasiŋ am nem sac hoŋ su.’ ");
INSERT INTO buk_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Têŋ ndoc aö gambu gatêŋ Jerusalem gameŋ, naŋ gateŋ mbec gambo lôm dabuŋ e gatuŋ kaiŋ daŋ sa. ");
INSERT INTO buk_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ma galic Pômdau Yisu sôm yom têŋ aö bocdec bu, ‘Ŋagahô, hu Jerusalem siŋ kwahic dec, bu lau dec oc sêkôc yom naŋ am hoc asê pi aö, naŋ sa dom.’ ");
INSERT INTO buk_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Dec aö gaô yom ma gasôm, ‘Pômdau, lau dindec sêŋyalê bu muŋ-ŋga aö kasalê lau sêkêŋ whiŋ am-ŋga tôm lôm wê-ŋga hoŋ, bu wandic ŋac ma wakêŋ ŋac sêndöc gapocwalô. ");
INSERT INTO buk_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ma têŋ ndoc naŋ lau sêkêc Steven ndê dac siŋ tu iŋ hoc yom asê pi am-ŋga, naŋ aö galhac ma galic ti atac ŋayham. Ma gayob lau naŋ sêtuc iŋ ŋa hoc, naŋ si ŋakwê.’ ");
INSERT INTO buk_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Goc Pômdau sôm têŋ aö, ‘Ndi! Aö oc waŋkiŋ am sa yêc lau Israel si gameŋ, bu têŋ lau apa si gameŋ ndi.’” ");
INSERT INTO buk_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Lau hoŋ sêŋgô Pol ndê yom ti sem dau dôŋ e iŋ sôm yom dinaŋ. Dec sêli awha sa ma sêmbwêc, “Iŋ gitôm bu mbo tali-ŋga dom. Ndic iŋ ndu niŋga!” ");
INSERT INTO buk_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ŋac sêmbwêc ti sêkac si ŋakwê andô-ŋga su ma sêmbalip kop pi lôlôc gi sêmbo. ");
INSERT INTO buk_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Dec lau siŋ-ŋga si ŋadau kêŋ yatu ŋac bu sêkôc Pol sôc ŋac si gameŋ ndi. Iŋ sôm bu sêhi iŋ ŋa sö, ma sêŋsu iŋ tu bu sêtap sa bu ŋahu bocke dec lau sêmbwêc iŋ ŋalêŋ bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Sêsô iŋ amba ti gahi dôŋ pi a bu sêhi iŋ, dec Pol sôm têŋ ŋgac bata naŋ yob lau siŋ-ŋga toŋ daŋ, naŋ bocdec bu, “Bocke? Mac bu ahi ŋgac Rom-ŋga daŋ, naŋ atap giso daŋ sa yêc iŋ dom, naŋ dec oc aŋgilì Rom si ŋagôliŋ, me mba?” ");
INSERT INTO buk_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ŋgac dau ŋgô Pol ndê yom, dec têŋ lau siŋ-ŋga si ŋadau gi ma sôm têŋ iŋ bu, “Am oc kôm sake, bu ŋgac dindê iŋ ŋgac Rom-ŋga?” ");
INSERT INTO buk_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Goc ŋgac dau têŋ Pol gi ma ndac iŋ, “Sôm asê têŋ aö. Am ŋgac Rom-ŋga, me mba?” Ma Pol sôm, “Aêc.” ");
INSERT INTO buk_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Dec lau siŋ-ŋga si ŋadau sôm, “Aö gahu awa atu siŋ dec gamlhi aneŋ bapia bu wati ŋgac Rom-ŋga.” Magoc Pol sôm, “Aö damaŋ iŋ ŋgac Rom-ŋga, ma bocdinaŋ dec aö ŋgac Rom-ŋga gawhiŋ.” ");
INSERT INTO buk_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Yom dau kôm ŋgac dau sö ŋandô, bu iŋ kôc Pol ma sô iŋ dôŋ, magoc kêyalê dom bu iŋ ŋgac Rom-ŋga. Ma lau naŋ bu sêŋsu Pol, naŋ ŋagahô sêkac dau su yêc iŋ. ");
INSERT INTO buk_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Lau siŋ-ŋga si ŋadau bu tap sa bu ŋahu bocke dec lau Israel-ŋga sêŋgôliŋ yom pi Pol. Bocdinaŋ ŋagalaŋsê bêbêc iŋ kêŋ yatu bu lau dabuŋsiga ti lau bata Sanedrin-ŋga hoŋ sêkac dau sa, goc kôc Pol su yêc lau siŋ-ŋga si gameŋ, ma kêŋ iŋ kalhac ŋac aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol tahê lau Sanedrin-ŋg a hoŋ ma sôm, “O aneŋ asidôwai. Aö neŋ atac pa su pi lêŋ hoŋ naŋ gasa tu wanem akiŋ Anötö-ŋga ŋapaŋ, e meŋ têŋ acsalô lec galhac mac aŋôm-ŋga.” ");
INSERT INTO buk_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Dabuŋsiga ŋamata-ŋga ŋaê Ananias ŋgô yom dinaŋ, dec sôm têŋ lau naŋ sêlhac sêmpiŋ Pol bu sêtap iŋ sôc tôkwa. ");
INSERT INTO buk_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Goc Pol sôm têŋ iŋ, “Anötö oc ndic am ô! Bocke dec am ndöc tu êmatôc aö êŋkuc yomsu Israel-ŋga, magoc am daôm sôm lau sêtap aö dec kêgilì yomsu dau? Am gitôm a naŋ ŋadômbwê-ŋga ŋawasi, magoc ŋalôm-ŋga sop weŋ sa.” ");
INSERT INTO buk_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Lau naŋ sêlhac sêmpiŋ Pol sêsôm têŋ iŋ bu, “Bocke dec am sôm yom sac-sac pi Anötö ndê dabuŋsiga ŋamata-ŋga?” ");
INSERT INTO buk_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ma Pol ô yom ma sôm, “Asidôwai. Aö kayalê dom bu iŋ dabuŋsiga ŋamata-ŋga. Bu sêto yom yêc bocdec bu, ‘Sôm yom sac pi ŋgac naŋ gêm gôliŋ nem lau, naŋ dom.’ ” ");
INSERT INTO buk_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pol kêyalê bu lau Sanedrin-ŋga ŋatô ŋac lau Palêsai, ma ŋatô ŋac lau Sadiusi. Tu dinaŋ-ŋga dec iŋ mbwêc yom têŋ ŋac bocdec bu, “Aneŋ asidôwai aŋgô. Aö damaŋ iŋ Palêsai daŋ, ma aö bocdinaŋ. Aö gakêŋ whiŋ bu yac oc datisa akêŋ lau batê-ŋga. Ma kwahic dec ŋac bu sêmatôc aö tu yom dinaŋ-ŋga.” ");
INSERT INTO buk_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Têŋ ndoc iŋ sôm yom dinaŋ, dec lau Sanedrin-ŋga sêwhê dau kôc, ma lau Sadiusi ti lau Palêsai sêseŋ dau. ");
INSERT INTO buk_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sêseŋ dau ŋahu bu lau Sadiusi sêkêŋ whiŋ dom bu lau batê oc sêtisa tiyham, ma sêsôm bu aŋela ma ŋalau daŋ sêmbo dom. Magoc lau Palêsai sêkêŋ whiŋ gêŋ hoŋ dinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Bocdinaŋ lau dau sêli dau sa ŋalêŋ sac. Ma Palêsai ŋatô naŋ sêndôhôŋ yomsu, naŋ sêtisa ma sêsôm yom ti ŋaŋga, “Yac atap giso daŋ sa yêc ŋgac dindec dom. Mboe aŋela me ŋalau daŋ kêŋ yom naŋ iŋ êlêmê hoc asê têŋ lau, naŋ têŋ iŋ.” ");
INSERT INTO buk_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kêpiŋ bu siŋ hôc asê, dec lau siŋ-ŋga si ŋadau töc bu mboe lau oc sêkac Pol kôc ndi lu. Bocdinaŋ iŋ kêkiŋ iŋ ndê lau siŋ-ŋga bu sêsa sêndi ti ŋaŋga ma sêŋgaho Pol su yêc lau dinaŋ, ma sêkôc iŋ mbu têŋ ŋac si gameŋ ndi tiyham. ");
INSERT INTO buk_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Têŋ ôbwêc Pômdau hoc dau asê têŋ Pol ma sôm, “Hêgo daôm dom, puc daôm dôŋ! Am hoc yom asê pi aö su yêc Jerusalem, ma am oc kôm bocdinaŋ yêc malac Rom whiŋ.” ");
INSERT INTO buk_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Galaŋsê bêbêc lau Israel-ŋga ŋatô sêkic yom bu sêndic Pol ndu. Ma sêmatiŋ pwac têŋ dau bu oc sêneŋ me sênôm gêŋ dom e iŋ mbac ndu su. ");
INSERT INTO buk_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Lauŋgac naŋ bu sêkôm gêŋ dau naŋ si namba hôc gêlêc 40 su. ");
INSERT INTO buk_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ŋac sêtêŋ dabuŋsiga atu-tu ti lau bata ŋatô si, ma sêsôm, “Yac amatiŋ pwac bu aneŋ gêŋ dom e andic Pol ndu su naŋ. ");
INSERT INTO buk_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Bocdinaŋ yac gauc gêm bu mac awhiŋ lau Sanedrin-ŋga andac lau siŋ si ŋadau bu hu Pol siŋ têŋ mac, bu andac iŋ pi gêŋ ŋatô tiyham. Ma yac oc asiŋ ambo seŋ bu têŋ ndoc sêwê iŋ sêsa sêmeŋ, naŋ yac andic iŋ ndu.” ");
INSERT INTO buk_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pol lhuwê atuŋgac ŋgô gêŋ dau ŋawaê, dec sôc lau siŋ-ŋga si gameŋ têŋ Pol gi ma sôm asê têŋ iŋ. ");
INSERT INTO buk_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pol ŋgô su dec ta ŋgac naŋ yob lau siŋ-ŋga toŋ daŋ ma sôm têŋ iŋ, “Kôc balê dindec têŋ mac nem ŋadau ndi. Iŋ kôc yom daŋ bu sôm têŋ iŋ.” ");
INSERT INTO buk_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Goc ŋgac siŋ-ŋga dinaŋ wê balê dau têŋ ŋac si ŋadau gi ma sôm, “Pol, ŋgac naŋ ndöc gapocwalô, naŋ ndac aö bu wakôc balê dindec têŋ am meŋ, bu iŋ kôc yom daŋ bu sôm têŋ am.” ");
INSERT INTO buk_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ŋgac dau kêm balê dau sa ma iŋlu sêsa ahic si, ma iŋ ndac iŋ bu, “Am kôc yom bocke bu sôm têŋ aö?” ");
INSERT INTO buk_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Goc balê dau sôm, “Lau Israel-ŋga sêkic yom bu sêndac am bu êmkiŋ Pol ndi lhac lau Sanedrin-ŋga aŋgô-ŋga têŋ laŋsê, bu ŋac tac whiŋ bu sêndac iŋ tu yom ŋatô-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ŋgô ŋac si yom dom, bu ŋac si lau hôc g êlêc 40 sem neneŋ sêhôŋ iŋ sêmbo seŋ. Lau dau sêsôm tidôŋ su bu sêneŋ ma sênôm gêŋ dom e sêndic iŋ ndu. Ŋac kwahic dec sêmasaŋ dau sêmbo, sêhôŋ bu am lôc têŋ ŋac si yom.” ");
INSERT INTO buk_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","L au siŋ-ŋga si ŋadau ŋ gô balê dau ndê yom su, goc kêkiŋ iŋ sa gi ma gic yomsu iŋ bocdec bu, “Sôm têŋ lau daŋ dom bu am mweŋ kêŋ ŋawaê dindec têŋ aö.” ");
INSERT INTO buk_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Goc iŋ ta ndê ŋgac lu naŋ sêyob lau siŋ-ŋga toŋ lu naŋ sêtêŋ iŋ sêmeŋ, ma sôm têŋ iŋlu bu, “Andic lau siŋ-ŋga tôm 200 sa, ma lau siŋ sêndöc hosi-ŋga 70, ma lau siŋ kêm-ŋga 200 sêwhiŋ. Asôm bu sêmasaŋ dau bu sêtêŋ malac Sisaria sêndi têŋ 9 kilok ôbwêc dindec. ");
INSERT INTO buk_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Amasaŋ hosi tu Pol ndöc ŋahô-ŋga, ma ayob iŋ ŋapep e akêŋ iŋ sip gôliŋwaga Rom-ŋga Filiks amba.” ");
INSERT INTO buk_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ma ŋgac atu dau to bapia daŋ bocdec: ");
INSERT INTO buk_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Aö Klaudias Lisias dec gato têŋ am ŋgac atu gôliŋwaga Filiks. Acsalô ŋayham am. ");
INSERT INTO buk_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Lau Israel-ŋga sêkôc ŋgac dindec dôŋ ma bu sêndic iŋ ndu. Magoc aö gatap sa bu iŋ ŋgac Rom-ŋga daŋ, dec aö ti neŋ lau siŋ-ŋga aŋgaho iŋ su yêc ŋac amba. ");
INSERT INTO buk_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Aö bu watap yom naŋ sêŋgôliŋ pi iŋ, naŋ ŋahu sa, dec gakêŋ iŋ kalhac lau Israel si lau bata Sanedrin-ŋga aŋgô-ŋga bu sêŋsahê iŋ. ");
INSERT INTO buk_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Aö gatap sa bu yom naŋ sêŋgôliŋ pi iŋ, naŋ hêganôŋ lau Israel-ŋga si yomsu. Magoc aö gatap yom daŋ sa gitôm bu yac andic iŋ ndu me akêŋ iŋ ndöc gapocwalô-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Malô aö gaŋgô ŋawaê bu lau ŋatô sêkic yom gelec bu sêndic iŋ ndu. Bocdinaŋ dec aö kakiŋ iŋ têŋ am goloc ŋagahô, bu am êmatôc iŋ ndê yom. Ma aö gac a tu lau naŋ sêŋgôliŋ yom pi iŋ, bu sêwhê yom dau sa têŋ am. ");
INSERT INTO buk_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Iŋ to yom dau su, goc kêŋ bapia sip iŋlu amba, ma iŋlu sic lau siŋ-ŋga sa ma sêkôm tôm iŋ gic atu ŋac. Têŋ ôbwêc dau dinaŋ sêkôc Pol whiŋ ŋac, ma sêsa sêtêŋ malac Antipatris si. ");
INSERT INTO buk_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Galaŋsê bêbêc lau siŋ-ŋga naŋ sêŋsêlêŋ sêmbo nom, naŋ sêlhö sêmbu sêtêŋ si gameŋ yêc Jerusalem si. Ma lau siŋ-ŋga naŋ sêndöc hosi sêhoŋ Pol sa si. ");
INSERT INTO buk_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Têŋ ndoc sêhôc asê Sisaria, naŋ sêkêŋ Pol ti bapia dau têŋ gôliŋwaga Filiks. ");
INSERT INTO buk_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ma iŋ sam bapia dau, goc ndac Pol bu iŋ ŋgac gameŋ bocke-ŋga. Ma tap sa bu iŋ ŋgac gameŋ Silisia-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Goc sôm, “Aö oc waŋgô am nem yom, têŋ ndoc lau naŋ sêŋgôliŋ yom pi am, naŋ sêhôc asê.” Goc iŋ kêŋ yatu iŋ ndê lau bu sêyob Pol yêc andu atu naŋ muŋ-ŋga Kiŋ Herod kwê sa naŋ. ");
INSERT INTO buk_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Bêc 5 giŋga su, goc dabuŋsiga ŋamata-ŋga Ananias ti lau bata Israel-ŋga ŋatô sêsip malac Sisaria si, bu sêkêŋ yom naŋ sêŋgôliŋ pi Pol, têŋ gôliŋwaga Filiks. Ma sêkôc ŋgac daŋ ŋaê Tetulus whiŋ ŋac, bu nem ŋac awha têŋ Filiks. ");
INSERT INTO buk_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","3","Lau sêkôc Pol sôc meŋ, goc Tetulus gic hu sôm ndê yom têŋ Filiks bocdec bu, “O ŋgac ŋayham kêlêc Filiks. Am gêm gôliŋ yac ŋapep, dec yac ambo ŋayham ma ti yom malô ŋasawa baliŋ su. Am ŋgac tigauc dec kêmasaŋ lêŋ wakuc ŋayham ŋatô, naŋ lau gameŋ dindec-ŋga kwahic dec sêŋkuc sêmbo. Yac ti mba lau hoŋ naŋ sêmbo am nem gôliŋ ŋapu, naŋ bu anem daŋge am ŋapaŋ. ");
INSERT INTO buk_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Aö bu waŋyaiŋ am nem têm dom, ma bu wakôm am lic ŋakam sa dom. Bocdinaŋ wandac am bu ŋgô yac mba yom apê lec. ");
INSERT INTO buk_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ŋgac dindec iŋ ŋgac êŋgilí lau-ŋga, ma gêli lau Israel-ŋga ŋalôm sa tôm gameŋ hoŋ. Iŋ lau toŋ naŋ sêŋkuc yom so pi ŋgac Nasaret-ŋga dinaŋ, naŋ si ŋgac ŋamata-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Ma gêŋ daŋ whiŋ. Iŋ bu kôm mêtê naŋ toc yac mba lôm dabuŋ sa bu gameŋ dabuŋ dom. Tu dinaŋ-ŋga dec yac akôc iŋ dôŋ. ");
INSERT INTO buk_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Am daôm bu kip iŋ sa, dec am oc tap sa bu yom hoŋ naŋ yac aŋgôliŋ pi iŋ, naŋ yomandô.” ");
INSERT INTO buk_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Tetulus sôm iŋ ndê yom dinaŋ, goc lau Israel-ŋga hoŋ naŋ sêwhiŋ iŋ, naŋ sêpuc iŋ ndê yom dôŋ ma sêsôm bu yomandô. ");
INSERT INTO buk_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Goc gôliŋwaga Filiks tôc amba têŋ Pol bu sôm ndê yom, dec Pol sôm, “Aö kayalê bu am gêm gôliŋ gameŋ dindec ma kêmatôc lau si yom tôm yala ŋatô su. Bocdinaŋ aö atac ŋayham bu wasôm aneŋ yom têŋ am ma waô yom naŋ sêŋgôliŋ pi aö. ");
INSERT INTO buk_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Am bu ndac lau ŋatô, dec am oc tap sa ŋagahô bu bêc 12 gi su, naŋ gapi Jerusalem ga, tu bu watoc Anötö sa-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Lau naŋ sêŋgôliŋ yom pi aö, naŋ sêŋyalê su bu aö gakôm mêtê sac daŋ dom. Aö gasôm ŋamalac daŋ yêc lôm dabuŋ dom, ma gali lau ŋalôm sa yêc lau Israel si lôm wê-ŋga me yêc malac Jerusalem ŋalôm dom. ");
INSERT INTO buk_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Bocdinaŋ yom naŋ sêŋgôliŋ pi aö, naŋ ŋac gitôm dom bu oc sêtôc asê bu yomandô. ");
INSERT INTO buk_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Magoc yom ŋandô tigeŋ dec wasôm asê têŋ am bocdec bu. Aö gam akiŋ damaŋi si Anötö kakuc lêŋ wakuc tôm lau sêkêŋ whiŋ Yisu-ŋga sêŋkuc. Lau dinaŋ sêlic lêŋ dau bu lêŋ so. Magoc aö gakêŋ whiŋ yom hoŋ naŋ kêkuc Moses ndê yomsu ti yom hoŋ naŋ lau propet sêto muŋ su. ");
INSERT INTO buk_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ma gakêŋ bataŋ bu Anötö oc uŋ lau gitêŋ ma lau sac hoŋ sa akêŋ lau batê-ŋga tôm ŋac lau dindê sêkêŋ whiŋ. ");
INSERT INTO buk_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ŋalêŋ dinaŋ dec aö kasahê bu wasa neŋ lêŋ hoŋ solop eŋ tu bu walhac ti neŋ atac pa su yêc Anötö ti ŋamalac aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Aö gahu Jerusalem siŋ yala ŋeŋ su, ma kwahic dec gambu gatêŋ Jerusalem ga, bu wanem aneŋ lau Israel-ŋga si lau ŋalôm sawa sa, ma bu wakêŋ da têŋ Anötö. ");
INSERT INTO buk_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Aö kakuc lau Israel-ŋga si lêŋ sêmasaŋ dau ŋawasi sa yêc Anötö aŋgô-ŋga muŋ su, goc gasôc lôm dabuŋ ga bu wakêŋ neŋ da. Ma têŋ ndoc dinaŋ lau Israel-ŋga ŋatô akêŋ gameŋ Esia-ŋga sêlic aö. Aö gac lau toŋ atu sa dom, ma gali lau ŋalôm sa bu sêkôm kisa dom. ");
INSERT INTO buk_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ŋac lau Esia-ŋga dau sic hu sêŋgôliŋ yom pi aö, ma bocdinaŋ ŋac bu gauc nem bu aö gakôm giso, dec ŋac dau sêmeŋ ma sêsôm asê têŋ am. ");
INSERT INTO buk_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Bu mba, goc sôm têŋ lau Israel-ŋga naŋ kwahic sêmbo dec, bu sêtôc asê têŋ am, giso bocke naŋ lau Israel si lau bata Sanedrin-ŋga sêtap sa yêc aö. ");
INSERT INTO buk_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Mboe ŋac sêlic aö sac ma sêkêŋ aö galhac am aŋôm-ŋga bu êmatôc aö, pi yom tigeŋ naŋ aö gambwêc têŋ ŋac bocdec bu, ‘Aö gakêŋ whiŋ bu yac oc datisa akêŋ lau batê-ŋga.’” ");
INSERT INTO buk_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Filiks ŋgô ti kêyalê yom daêsam su pi lau sêkêŋ whiŋ Yisu-ŋga si lêŋ wakuc. Bocdinaŋ dec iŋ gic bata yom, ma sôm têŋ lau Israel-ŋga naŋ sêmeŋ akêŋ Jerusalem, “Têŋ ndoc lau siŋ-ŋga si ŋadau Lisias meŋ akêŋ Jerusalem, naŋ aö oc wasôm aneŋ gauc asê pi mac nem yom.” ");
INSERT INTO buk_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Goc iŋ gic atu ŋgac naŋ yob lau siŋ-ŋga toŋ daŋ, bu sêyob Pol ŋapep, magoc sêsô iŋ dôŋ dom. Ma iŋ sôm têŋ iŋ bu kêŋ ŋasawa têŋ Pol ndê lau naŋ bu sêndic iŋ kêsi ti sênem iŋ sa, ma lhac ŋac ahuc dom. ");
INSERT INTO buk_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Bêc ŋatô giŋga su, dec Filiks lu nawhê Drusila, naŋ awhê Israel-ŋga daŋ, sêŋgalêm Pol bu sêŋgô iŋ whê yom sa pi lau sêkêŋ whiŋ Yisu Kilisi-ŋga si lêŋ. ");
INSERT INTO buk_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pol gêm yomgalôm whiŋ iŋlu ma sôm yom ŋasawa hic baliŋ, pi lêŋ naŋ lau sêti lau gitêŋ, ma sêtimêtê dau ŋapep, ma pi Anötö ndê bêc êmatôc lau-ŋga naŋ oc meŋ sa. Yom dau kôm Filiks töc dau sa, dec sôm, “Naŋ gitôm, am lhö mbu ndi. Têŋ ndoc aö bu walic ŋasawa ŋayham daŋ, naŋ wakêŋ yom am tiyham.” ");
INSERT INTO buk_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ma tiŋambu iŋ kêgalêm Pol ti gêm yomgalôm whiŋ iŋ tidim daêsam, bu iŋ kêŋ bata bu Pol oc kêŋ awa têŋ iŋ, bu nemlhi dau su yêc gapocwalô. ");
INSERT INTO buk_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Filiks bu kôm lau Israel-ŋga sêlic iŋ ŋayham, dec kêŋ Pol ndöc gapocwalô ŋapaŋ. Yala lu giŋga su, goc Pokias Festus ti gôliŋwaga ô Filiks su. ");
INSERT INTO buk_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Têŋ ndoc Festus hôc asê bu nem gôliŋ gameŋ dinaŋ, naŋ iŋ mbo malac Sisaria tôm bêc tö eŋ, goc pi Jerusalem gi. ");
INSERT INTO buk_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ma yêc dindê dabuŋsiga atu-tu ti lau bata Israel-ŋga sêpitigeŋ, ma yom naŋ sêŋgôliŋ pi Pol su, naŋ sêhoc asê têŋ Festus. ");
INSERT INTO buk_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Ŋac sêndac bu iŋ bu lic ŋac ŋayham, dec kêŋ Pol mbu pi Jerusalem ndi. Ŋac sêndac gêŋ dau, ŋahu bu ŋac sêmatiŋ yom tidôŋ su gelec, bu sêkêŋ lau ŋatô sêsiŋ sêmbo seŋ bu sêndic Pol ndu. ");
INSERT INTO buk_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Magoc Festus ô yom ma sôm, “Pol dê sêyob sêmbo Sisaria, ma malô goc aö dauŋ oc wambu watêŋ malac dinaŋ wandi. ");
INSERT INTO buk_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Mac asôm bu iŋ kôm giso, dec akêŋ nem lau bata ŋatô sêwhiŋ aö, bu sêsôm mac nem yom pi iŋ asê têŋ aö yêc dindê.” ");
INSERT INTO buk_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus mbo Jerusalem bêc 8 me 10 su, goc sip Sisaria gi. Ma têŋ ŋagalaŋsê iŋ gi ndöc iŋ ndê pôŋ êmatôc yom-ŋga, ma gic atu bu sêkôc Pol meŋ lhac iŋ aŋgô-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Têŋ ndoc Pol hôc asê, naŋ lau Israel-ŋga naŋ sêmeŋ akêŋ malac Jerusalem, naŋ sêlhac sêŋgihi iŋ ahuc, ma sêsôm bu iŋ kôm giso atu. Sêŋgôliŋ yom daêsam pi iŋ, magoc gitôm dom bu sêtôc ŋandô asê. ");
INSERT INTO buk_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Goc Pol sôm ndê yom asê bocdec bu, “Aö gakôm giso daŋ pi lôm dabuŋ dom, ma kagilì lau Israel si yomsu, me Sisa ndê ŋagôliŋ daŋ dom.” ");
INSERT INTO buk_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festus tac whiŋ bu lau Israel-ŋga sêlic iŋ ŋayham, dec ndac Pol, “Am gêlic ŋayham bu pwi Jerusalem ndi, ma aö waŋsahê ŋac si yom pi am yêc dindê, me mba?” ");
INSERT INTO buk_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ma Pol sôm, “Mba. Aö ŋgac Rom-ŋga, ma am ndöc nem pôŋ êmatôc yom-ŋga g êm Sisa aŋgô. Bocdinaŋ êmatôc yom naŋ sêŋgôliŋ pi aö yêc dindec maŋ. Am kêyalê tidôŋ su bu aö gakôm giso daŋ têŋ lau Israel-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Aö bu wakôm giso daŋ naŋ gic waê bu wambac ndu, naŋ dec ndic aö ndu. Magoc yom naŋ lau Israel-ŋga dindec sêŋgôliŋ pi aö, naŋ bu ŋandô mba, dec solop dom bu am kêŋ aö wasip ŋac amba. Sisa dau goc êmatôc aneŋ yom yêc malac Rom!” ");
INSERT INTO buk_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Têŋ dinaŋ Festus gêm yomgalôm whiŋ lau atu-tu naŋ sêmbo iŋ ndê gôliŋ ŋapu, goc sôm têŋ Pol, “Am ndac bu Sisa êmatôc nem yom. Bocdinaŋ dec am oc têŋ Sisa ndi.” ");
INSERT INTO buk_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Bêc ŋatô giŋga su, goc Kiŋ Agripa lu lhuwê Berenis sêhôc asê Sisaria bu sêti ŋacleŋ Festus. ");
INSERT INTO buk_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Iŋlu sêmbo sêwhiŋ iŋ bêc daêsam su, goc Festus gic miŋ pi Pol ma sôm t êŋ Kiŋ Agripa, “Ŋgac daŋ mbo dec, naŋ Filiks kêŋ ndöc gapocwalô ŋapaŋ e meŋ têŋ kwahic dec. ");
INSERT INTO buk_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Têŋ ndoc aö gapi Jerusalem ga, naŋ dabuŋsiga atu-tu ti lau bata Israel-ŋga sêŋgôliŋ yom pi iŋ, ma sêndac aö bu walôc bu iŋ mbac ndu. ");
INSERT INTO buk_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Aö gawhê sa têŋ ŋac bu yac lau Rom-ŋga neŋ mêtê bocdec bu. Dandic ŋamalac daŋ ndu dom e dakêŋ ŋasawa têŋ iŋ bu lhac lau naŋ sêŋgôliŋ yom pi iŋ, naŋ aŋgô-ŋga, ma iŋ ô ŋac si yom su naŋ. ");
INSERT INTO buk_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Têŋ ndoc ŋac si lau ŋatô sêsip akêŋ Jerusalem sêwhiŋ aö, naŋ gahôŋ bêc daêsam dom. Aö gahôc asê, ma galaŋsê bêbêc aö gac atu aneŋ lau bu sêkôc ŋgac dau sôc meŋ lhac aneŋ pôŋ wamatôc yom-ŋga ŋa-ndö-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Lau dau sêtisa bu sêŋgôliŋ yom pi iŋ, ma aö gauc gêm bu ŋac oc sêtôc iŋ ndê giso ŋandô daŋ asê. Magoc mba! ");
INSERT INTO buk_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ŋac sêsôm yom pi ŋac dau si mêtê sênem akiŋ si anötö-ŋga, naŋ ŋac gauc gêm bu Pol kêkuc dom. Ma sêlic iŋ sac pi ŋgac batê daŋ ŋaê Yisu, naŋ Pol sôm bu tisa akêŋ lau batê-ŋga ma mbo tali tiyham. ");
INSERT INTO buk_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Aö gapônda dauŋ tu lêŋ wamatôc yom kaiŋ dinaŋ-ŋga. Bocdinaŋ aö gasôm têŋ Pol bu iŋ bu tac whiŋ bu pi Jerusalem ndi, dec yac oc amatôc iŋ ndê yom yêc dindê. ");
INSERT INTO buk_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Magoc Pol tec ma ndac bu Sisa dau êmatôc iŋ ndê yom, dec aö gac atu bu aneŋ lau sêyob iŋ e waŋkiŋ iŋ têŋ Sisa ndi.” ");
INSERT INTO buk_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Goc Agripa sôm têŋ Festus, “Aö dauŋ atac whiŋ bu waŋgô ŋamalac dau ndê yom.” Ma Festus sôm, “Bocdinaŋ, laŋsê naŋ am ŋgô iŋ ndê yom.” ");
INSERT INTO buk_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Têŋ galaŋsê Agripa lu Berenis sêsôc si gôlôŋ kiŋ-ŋga sa, goc sêsôc andu sêŋgô yom-ŋga ŋalôm si sêndöc. Ma lau bata siŋ-ŋga ti lau bata malac-ŋga hoŋ sêwhiŋ iŋlu. Goc Festus kêŋ yatu bu sêkôc Pol sôc meŋ. ");
INSERT INTO buk_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ma iŋ sôm, “Kiŋ Agripa ti mac lau hoŋ naŋ ambo dindec. Alic iŋ ŋgac dec. Lau Israel-ŋga hoŋ sêteŋ aö yêc Jerusalem ma yêc malac Sisaria dindec, bu walôc bu iŋ mbac ndu. ");
INSERT INTO buk_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Magoc aö gatap iŋ ndê giso daŋ sa, naŋ gitôm bu dandic iŋ ndu-ŋga dom. Ma iŋ dau ndac bu Sisa êmatôc iŋ ndê yom, madec aö bu waŋkiŋ iŋ têŋ Rom ndi. ");
INSERT INTO buk_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ma kwahic dec aö bu wato bapia daŋ têŋ Sisa, magoc aö kayalê yom ŋandô daŋ bu wato pi ŋgac dindec-ŋga dom. Tu dinaŋ-ŋga Kiŋ Agripa, aö gakêŋ iŋ kalhac am ti mac lau hoŋ aŋôm-ŋga, bu dakip yom hoŋ sa, ma datap yom ŋandô daŋ sa, naŋ tôm bu wato têŋ Sisa. ");
INSERT INTO buk_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Yac bu taŋkiŋ ŋamalac g apocwalô-ŋga daŋ têŋ Sisa, magoc dawhê iŋ ndê giso ŋahu sa whiŋ dom, oc solop dom.” ");
INSERT INTO buk_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Têŋ dinaŋ Kiŋ Agripa sôm têŋ Pol, “Aö wakêŋ ŋasawa bu am sôm yom tu daôm-ŋga.” Goc Pol hôc amba sa têŋ lau, ma gic hu sôm iŋ ndê yom bocdec bu, ");
INSERT INTO buk_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Kiŋ Agripa, kwahic dec aö bu waô yom hoŋ naŋ lau Israel-ŋga sêŋgôliŋ pi aö. Ma aö atac ŋayham bu wasôm asê walhac am aŋôm-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Gêŋ atu daŋ whiŋ bocdec bu, lau Israel-ŋga si mêtê ti yom naŋ sêwhê dau kôc pi, naŋ am kêyalê tidôŋ su. Bocdinaŋ aö wandac am bu kêŋ ŋasawa hic baliŋ têŋ aö bu wasôm neŋ yom hoŋ asê. ");
INSERT INTO buk_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Lau Israel-ŋga hoŋ sêŋyalê aneŋ lêŋ têŋ ndoc gambo balê-ŋga yêc dauŋ neŋ gameŋ, ma lêŋ naŋ gasa têŋ ndoc gambo Jerusalem, naŋ bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Lau Palêsai ŋac lau naŋ sem akiŋ Anötö ŋaŋga sêhôc gêlêc lau Israel-ŋga ŋatô su. Ma oc tôm bu lau dinaŋ naŋ sêŋyalê aö têm baliŋ su, naŋ sêwhê sa bu aö kakuc lau Palêsai si lêŋ dinaŋ. Magoc sêsôm asê dom. ");
INSERT INTO buk_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Aö gakêŋ bataŋ gêŋ naŋ Anötö gic bata têŋ damaŋi, ma tu dinaŋ-ŋga kwahic dec sêkêŋ aö galhac am aŋôm-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Yac lau Israel-ŋga mba toŋ 12 sem akiŋ Anötö acsalô ti ôbwêc, ma sêkêŋ bata bu sêlic gêŋ naŋ Anötö gic bata, naŋ ŋandô sa. O kiŋ, aö wasôm têŋ am bu lau Israel-ŋga sêkêŋ kisa aö tu gêŋ dinaŋ-ŋga eŋ. ");
INSERT INTO buk_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Yac akêŋ bataŋ bu Anötö oc uŋ lau batê sa tiyham, ma bocke dec mac lau ŋatô asö ti gauc gêm bu gêŋ dau oc tôm dom bu ŋandô sa? ");
INSERT INTO buk_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Muŋ-ŋga lê aö dauŋ gauc gêm tidôŋ ma galic ŋayham bu wakôm gêŋ daêsam tu wakêŋ kisa lau naŋ sêkêŋ whiŋ Yisu Nasaret-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ma gêŋ dau dinaŋ dec gakôm yêc Jerusalem. Dabuŋsiga atu-tu sêlic ŋayham ma sêlôc têŋ aö bu wakôc lau sêkêŋ whiŋ-ŋga daêsam dôŋ, ma wakêŋ ŋac sêndöc gapocwalô. Ma têŋ ndoc sic ŋac si lau ŋatô ndu, naŋ aö galhac gawhiŋ ŋac ma galic ŋayham. ");
INSERT INTO buk_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Tôm têm daêsam aö galom-galom lôm wê-ŋga hoŋ ma kasalê lau sêkêŋ whiŋ Yisu-ŋga bu wakêŋ ŋagêyô têŋ ŋac. Aö gauc gêm bu wakêŋ ŋandê têŋ ŋac e sêsôm yom sac sambuc. Aö atac tec ŋac ŋandô, bocdinaŋ kasêlêŋ gatêŋ lau gameŋ apa-ŋga si malac atu-tu bu wakêŋ kisa têŋ Yisu ndê lau. ");
INSERT INTO buk_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","13","“O kiŋ, têŋ bêc daŋ dabuŋ-si ga atu-tu sêŋyaliŋ aö sa ma sêŋkiŋ aö bu wasip malac Damaskas wandi. Aö kasêlêŋ gambo seŋ, ma têŋ ac kalhac lhu ŋawê atu daŋ sip akêŋ undambê ma pô aö ti lau naŋ sêwhiŋ aö. ");
INSERT INTO buk_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Yac hoŋ apeŋ asip nom, ma aö gaŋgô awha daŋ sôm yom têŋ aö yêc Yom Hibru bocdec bu, ‘Saul, Saul, tu sake-ŋga am kêŋ kisa aö? Am gitôm bôc naŋ gêli dau sa têŋ ŋadau ndê gôliŋ dec tap ŋandê sa.’ ");
INSERT INTO buk_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Têŋ ndoc dinaŋ aö gandac, ‘O ŋadau, am asa?’ Ma iŋ ô yom ma sôm, ‘Aö Yisu, naŋ am kêŋ kisa. ");
INSERT INTO buk_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Kwahic dec tisa. Aö gahoc dauŋ asê têŋ am, ma kayaliŋ am sa bu nem akiŋ aö. Ma gêŋ naŋ am kêyalê pi aö, ti gêŋ naŋ watôc têŋ am, naŋ am oc hoc asê têŋ lau. ");
INSERT INTO buk_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Aö waŋgaho am su yêc lau Israel-ŋga amba, ma yêc lau naŋ lau Israel dom, naŋ si amba whiŋ. Kwahic dec waŋkiŋ am têŋ lau gameŋ apa-ŋga dinaŋ ndi. ");
INSERT INTO buk_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Am oc kôm ŋac tandô po asê e sêkac dau kwi ma sêhu seŋ ŋasec-ŋga ma Sadaŋ ndê gôliŋ siŋ, ma sêsa seŋ ŋawê-ŋga ma sêsôc Anötö ndê gôliŋ ŋapu. Ma lau naŋ sêkac si ŋalôm kwi, naŋ dec Anötö oc suc ŋac si sac kwi, ma kêŋ ŋac sêwêkaiŋ gameŋ sêndöc tali ŋapaŋ-ŋga sêwhiŋ lau naŋ sêti lau dabuŋ tu ŋac si sêkêŋ whiŋ aö-ŋga.’ ");
INSERT INTO buk_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“O kiŋ Agripa. Aö galic Yisu hoc dau asê akêŋ undambê, ma aö gaŋgô iŋ ndê yom dec gasôc ŋapu. ");
INSERT INTO buk_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Aö gam mêtê lau bu sênem dau kwi ma sêsôc Anötö ŋapu, ma sêkôm mêtê gitêŋ bu sêtôc asê bu ŋac sem dau kwi ŋandô. Aö gac hu yêc malac Damaskas, ma malô goc gam mêtê yêc Jerusalem, ma yêc gameŋ Judia-ŋga hoŋ e gatêŋ lau apa si gameŋ whiŋ. ");
INSERT INTO buk_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Tu dinaŋ-ŋga dec lau Israel-ŋga sêkôc aö dôŋ yêc lôm dabuŋ, ma bu sêndic aö ndu. ");
INSERT INTO buk_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Magoc Anötö yob aö ŋapep e meŋ têŋ acsalô dindec aö galhac am aŋôm-ŋga. Ma kwahic dec aö wasôm asê têŋ lau hoŋ, lau tiwaê ma lau waêmba sêwhiŋ, bu yom hoŋ naŋ aö gahoc asê pi Yisu, naŋ ŋadaŋ so yom naŋ Moses ma lau propet sêhoc asê gwanaŋ su pi gêŋ naŋ oc hôc asê, naŋ dom. ");
INSERT INTO buk_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ŋac sêsôm bu Mesaya oc hôc ŋandê e mbac ndu, ma tiŋambu iŋ oc ti ŋgac ŋamata-ŋga bu tisa akêŋ lau batê-ŋga, ma hoc yom asê pi Anötö ndê lêŋ nem lau si sêmbo tali-ŋga têŋ iŋ ndê lau Israel-ŋga, ma têŋ lau naŋ lau Israel dom, naŋ sêwhiŋ. Yom dau oc tôm ŋawê bu pô gameŋ ŋasec-ŋga.” ");
INSERT INTO buk_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pol whê ndê yom sa mbo, ma Festus mbwêc iŋ awha ahuc ma sôm, “Pol, am nem yom iŋ yom solop dom. Yom daêsam naŋ sêndôhôŋ têŋ am, naŋ kôm am nem gauc kêŋsôŋ.” ");
INSERT INTO buk_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Magoc Pol ô yom ma sôm, “O ŋgac atu Festus, aö neŋ gauc kêŋsôŋ dom. Aneŋ yom iŋ yom solop ma yom ŋandô. ");
INSERT INTO buk_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Gêŋ hoŋ dindec hôc asê yêc lhu, ma bocdinaŋ dec kiŋ Agripa gitôm dom bu nem gauc gêŋ dau. Yomandô! Iŋ kêyalê gêŋ hoŋ dindec su, ma bocdinaŋ aö gasôm neŋ yom asê têŋ iŋ yêc awê. ");
INSERT INTO buk_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kiŋ Agripa, am kêŋ whiŋ lau propet si yom pi Mesaya, me mba? Aö gauc gêm bu am oc kêŋ whiŋ su.” ");
INSERT INTO buk_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Dec Agripa sôm têŋ Pol, “Am gauc gêm bu ŋasawa apê lec am oc kac aneŋ ŋalôm kwi bu wakêŋ whiŋ Yisu, a?” ");
INSERT INTO buk_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Ma Pol ô yom ma sôm, “Aö bu wasôm yom ŋasawa apê me ŋasawa baliŋ, aö oc atac whiŋ gêŋ tigeŋ. Aö wateŋ mbec pi am ti mac lau hoŋ naŋ aŋgô aneŋ yom dindec, bu Anötö kôm mac hoŋ andi atôm aö ma akêŋ whiŋ Yisu, magoc bu kôm mac atôm aö tu gandöc gapocwalô-ŋga lec dom.” ");
INSERT INTO buk_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Pol sôm iŋ ndê yom meŋ têŋ dinaŋ, goc Kiŋ Agripa tisa, ma gôliŋwaga Festus ti Berenis ma lau hoŋ naŋ sêndöc sêwhiŋ iŋ, naŋ sêtisa bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ŋac sêhu andu dau siŋ, ma sem yomgalôm têŋ dau ma sêsôm, “Ŋgac dindec kôm giso daŋ naŋ tôm bu sêndic iŋ ndu me sêkêŋ iŋ ndöc gapocwalô-ŋga lec dom.” ");
INSERT INTO buk_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ma Agripa sôm têŋ Festus, “Oc tôm bu yac dahu ŋgac dindec siŋ lhö ndi, tigeŋ iŋ dau ndac bu Sisa êmatôc iŋ ndê yom.” ");
INSERT INTO buk_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ma tiŋambu sêsôm tidôŋ bu sêkêŋ Pol ti lau gapocwalô-ŋga ŋatô sêpi waŋ daŋ, ma sêŋkiŋ ŋac sêtêŋ malac Rom naŋ yêc gameŋ Itali-ŋga sêndi. Sêkêŋ ŋac sêsip ŋgac siŋ-ŋga daŋ amba, naŋ ndê ŋaê Julias, naŋ ti ŋgac bata siŋ-ŋga naŋ yob Sisa ndê lau siŋ-ŋga toŋ daŋ. ");
INSERT INTO buk_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Dec ŋac sêpi waŋ si, ma alu ŋgac daŋ ŋaê Aristakus akêŋ malac Tesalonika yêc gameŋ Masedonia-ŋga api awhiŋ, ma yac asa a. Waŋ dau meŋ akêŋ malac Adramitiam ma gic waê bu êŋsêlêŋ sôc malac ŋatô naŋ sêyêc gameŋ Esia-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ŋagalaŋsê waŋ dau sôc baö yêc malac Saidon. Julias tawalô Pol dec kêŋ iŋ sip baö gi bu ndic iŋ ndê silip kêsi tu bu sêpuc iŋ dôŋ ŋa gêŋ ŋatô-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Tiŋambu yac api waŋ dau ma asa a tiyham. Yac bu ahôc gêlêc nduc Saipras, tigeŋ mbu ŋadinda puc waŋ dôŋ, dec yac aŋgihi aho yêc nduc ŋadômbwê-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Goc waŋ dau kêsêlêŋ mbo gwêc sawa, ma gi e ahôc gêlêc gameŋ Silisia-ŋga ma gameŋ Pampilia-ŋga su, ma gacgeŋ a asôc malac Maira yêc gameŋ Lisia-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ma yêc dindê ŋgac bata siŋ-ŋga dau tap waŋ daŋ sa, naŋ meŋ akêŋ Aleksandria ma bu têŋ Itali ndi. Dec iŋ kêŋ yac a alom. ");
INSERT INTO buk_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Magoc waŋ dau kêti ŋagahô dom. Yac ambo gwêc ŋasawa bêc daêsam, e a ampiŋ malac Naidas. Mbu ŋadinda puc yac dôŋ ŋapaŋ, bocdinaŋ dec akac waŋ kwi aŋôŋ gêm nduc Krit ŋa-awê-ŋga, ma anti a e ampiŋ malac daŋ ŋaê Salmone. ");
INSERT INTO buk_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Waŋ kêsêlêŋ ti ŋawapac e ahôc asê söc naŋ sêsam bu Salaŋ Ŋayham, naŋ yêc kêpiŋ malac Lasea. ");
INSERT INTO buk_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Bêc daêsam giŋga su ma lau Israel si om atu naŋ sêhu gêŋ daneŋ-ŋga siŋ, naŋ pacndê su, dec yac aŋyalê bu oc asip têm sac tu dalac waŋ-ŋga ŋalôm. Bocdinaŋ Pol kêŋ puc lau waŋ-ŋga ma sôm, ");
INSERT INTO buk_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Mac lau, aö kayalê su bu oc dasip ŋasac ŋalôm e waŋ ti wapa hoŋ oc sêniŋga, ma mboe yac dauŋ dawhiŋ.” ");
INSERT INTO buk_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Magoc ŋgac bata siŋ-ŋga dau kêŋ daŋga Pol ndê yom dom. Iŋ sôc ŋgac nem gôliŋ waŋ-ŋga ti waŋ ŋadau si yom ŋapu. ");
INSERT INTO buk_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Söc dinaŋ gitôm dom bu waŋ poc ŋayham têŋ ndoc uhô-ŋga. Bocdinaŋ dec lau waŋ-ŋga daêsam sêsôm yom pitigeŋ bu sêsa tiyham ma sêŋsahê bu sêlac sêtêŋ malac Pioniks sêndi, ma waŋ poc dindê e têm ŋayham meŋ sa. Yêc malac Pioniks, nduc Krit pôc mbu ahuc, ma bocdinaŋ söc naŋ yêc malac dinaŋ iŋ söc ŋayham tu waŋ sêpoc-ŋga têŋ têm uhô-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Yac ahôŋ e bêc daŋ mbu lilic kêsêlêŋ ŋayham, ma bocdinaŋ ŋac gauc gêm bu sêtap têm ŋayham sa bu sêlom malac Pioniks. Ŋac sêhê aŋga sa ma sêlac sêŋkuc baö Krit-ŋga si. ");
INSERT INTO buk_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ŋasawa baliŋ dom ma mbu sac daŋ puc ŋaŋga akêŋ baö-ŋga mbu sa têŋ gwêc sawa-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Waŋ dau sip mbu dinda ŋalôm e tôm dom bu yac alac aŋkuc baö-ŋga. Bocdinaŋ yac am waŋ kwi kêsêlêŋ kêkuc mbu. ");
INSERT INTO buk_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Mbu soc yac e nduc sauŋ daŋ ŋaê Kauda pôc mbu ahuc ŋagec. Yac bu ahê waŋ ŋa-gômbwa pi lôlôc meŋ, magoc akôm wapac-wapac bu mbu puc ŋadinda sac andô. ");
INSERT INTO buk_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Lau sêhê gômbwa sa pi lôlôc meŋ su, goc sêkic po pi waŋ atu ŋampê bu suc dom. Ŋac sêtöc dau bu mbu oc soc yac ŋapaŋ e waŋ ndi lôc pi gaŋgac yêc Sirtis, dec sêlêc lac su ma sêkêŋ aŋga gwêc-ŋga sip gi bu teŋ waŋ dôŋ ênti timalô, ma sêkêŋ waŋ dau tam mbo. ");
INSERT INTO buk_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Têŋ bêc tilu-ŋga mbu ti gwêc gic pi waŋ sac andô, dec lau waŋ-ŋga sêtöc dau atu ma sic hu sêmbaliŋ wapa ŋatô siŋ sip gwêc. ");
INSERT INTO buk_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Bêc titö-ŋga sêhôc waŋ ŋalac ti po ma wapa waŋ-ŋga ŋatô sa ma sêmbaliŋ siŋ sip gwêc gi. ");
INSERT INTO buk_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Tigeŋ mbu dau timalô dom e bêc daêsam yac alic ac ti tata dom. Ma yac hoŋ mba gauc tigeŋ bu oc andiŋaŋ. ");
INSERT INTO buk_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Lau waŋ-ŋga seŋ gêŋ daŋ dom tôm bêc daêsam su, goc Pol tisa ma sôm, “Mac lau, aö gakêŋ puc mac muŋ su, bu ahu nduc Krit siŋ dom, magoc mac asôc aneŋ yom ŋapu dom. Mac bu aŋgô aneŋ yom dau, dec gitôm dom bu atap ŋawapac dindec sa, ma gêŋ daŋ oc niŋga dom. ");
INSERT INTO buk_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Magoc kwahic dec wasôm têŋ mac bu nem ŋalôm pêŋ dôŋ, bu mac nem daŋ oc niŋga dom. Waŋ tigeŋ dec oc niŋga. ");
INSERT INTO buk_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Aö Anötö ndê ŋgac daŋ, ma gam akiŋ iŋ ŋapaŋ. Alhabêc ôbwêc iŋ kêkiŋ ndê aŋela daŋ meŋ kalhac whiŋ aö. ");
INSERT INTO buk_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Ma sôm têŋ aö, ‘Pol, am töc daôm dom. Am oc lhac Sisa aŋgô-ŋga bu iŋ êmatôc nem yom. Ma tu am-ŋga, Anötö oc kêŋ lau hoŋ naŋ sêmbo waŋ sêwhiŋ am, naŋ sêmbo tali.’ ");
INSERT INTO buk_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Bocdinaŋ mac lau, nem ŋalôm pêŋ dôŋ, bu aö gakêŋ whiŋ Anötö bu yom dau oc ŋandô sa, tôm iŋ ndê aŋela sôm têŋ aö. ");
INSERT INTO buk_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Waŋ oc ndi lôc pi nduc daŋ, tigeŋ yac oc dandiŋaŋ dom.” ");
INSERT INTO buk_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Mbu tam yac ŋapaŋ ambo Gwêc Adria-ŋga. Têŋ bêc ti-14-ŋga ma timaniŋhu goc lau waŋ-ŋga sêŋsahê bu yac asuŋ sa baö. ");
INSERT INTO buk_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Sem dôhôŋ gwêc ŋagapoŋ ma sêtap sa b u ŋagapoŋ gitôm 37 mita. Ŋasawa sauŋ sem dôhôŋ tiyham ma sêtap sa bu ŋagapoŋ gitôm 27 mita. ");
INSERT INTO buk_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ŋac sêtöc bu waŋ oc popoc pi hoc, bocdinaŋ sêmbaliŋ aŋga hale sip waŋku-ŋga, ma sêkêŋ bata bu laŋsê ŋagahô. ");
INSERT INTO buk_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Lau sêyob waŋ-ŋga gauc gêm bu sêhu waŋ ti lau ŋatô siŋ, dec sêkôm bu sêkêŋ gômbwa sip gwêc ndi, sêŋsau bu oc sêkêŋ aŋga ŋatô sip yêc waŋ ŋampê-ŋga. ");
INSERT INTO buk_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Magoc Pol sôm têŋ ŋgac bata ti ndê lau siŋ-ŋga bu, “Lau dinaŋ bu sêhu waŋ siŋ, dec mac oc andiŋam.” ");
INSERT INTO buk_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Tu dinaŋ-ŋga lau siŋ-ŋga sêtim wac kic yêc g ômbwa, ma sêkêŋ peŋ sip gwêc gi. ");
INSERT INTO buk_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Têŋ bêbêc ganduc Pol sôm têŋ lau bu sêneŋ gêŋ. Iŋ sôm, “Bêc 14 giŋga su lec mac ayob waŋ ŋapaŋ e mac aŋ gêŋ daŋ dom. ");
INSERT INTO buk_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Kwahic dec aö wasôm têŋ mac bu gêŋ daŋ oc kôm mac ŋayom dom, mac hoŋ oc ambo tamli. Bocdinaŋ dec aneŋ gêŋ bu puc mac dôŋ.” ");
INSERT INTO buk_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Iŋ sôm yom dinaŋ su, goc kôc bolom ma gêm daŋge Anötö yêc ŋac hoŋ aŋgô-ŋga, goc pô kôc ma gêŋ. ");
INSERT INTO buk_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Dec lau hoŋ si ŋalôm timalô ma seŋ gêŋ sêwhiŋ. ");
INSERT INTO buk_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Yac lau naŋ ambo waŋ, naŋ mba namba gitôm 276. ");
INSERT INTO buk_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Lau hoŋ seŋ gêŋ hôc ŋac dôŋ, goc sêmbaliŋ bolom batac sip gwêc gi bu kôm waŋ tilo. ");
INSERT INTO buk_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Têŋ ndoc gameŋ ŋawê sa naŋ sêlic baö, tigeŋ sem gauc gameŋ dau. Sêlic söc ti gaŋgac apa ŋayham, dec gauc gêm bu sêkêŋ waŋ ndi pi baö yêc dindê. ");
INSERT INTO buk_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ŋac sêtim aŋga ŋawac kic sip gwêc giŋga, ma sêŋgapwêc wac naŋ sô gôliŋ dôŋ, naŋ su. Goc sêsö lac waŋ ŋatôkwa-ŋga sa, bu mbu peŋ lac ma kôc yac api baö andi. ");
INSERT INTO buk_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Magoc waŋ dau kêti gi gôlôc pi gaŋgac ŋabaö daŋ yêc gwêc lôm e gacgeŋ ŋaŋga sa. Ma gwêc dinda gic pi waŋ ŋambu-ŋga e kac popoc. ");
INSERT INTO buk_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Têŋ ndoc dinaŋ lau siŋ-ŋga sêkic yom bu sêndic lau gapocwalô-ŋga hoŋ ndu, bu sêsip gwêc ma sêlhö sêndi dom. ");
INSERT INTO buk_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Magoc ŋac si ŋgac bata bu nem Pol sa, dec kalhac ŋac ahuc bu sêkôm si yom ŋandô sa d om. Iŋ kêŋ yatu bu lau naŋ sêŋkôc tidôŋ naŋ sêpwê sêsip gwêc ma sêmuŋ sêsôc baö sêndi. ");
INSERT INTO buk_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ma iŋ kêŋ yatu bu lau ŋatô sêsac apa waŋ-ŋga ŋatô naŋ gwêc gic popoc. Ma ŋalêŋ dinaŋ dec lau hoŋ sêhôc asê baö ti lic sambuc. ");
INSERT INTO buk_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Yac hoŋ api baö ti lic sambuc, ma malô atap sa bu nduc dau ŋaê sêsam bu Malta. ");
INSERT INTO buk_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ma lau nduc-ŋga sêkôc yac hoŋ sa ma sêyob ti sêmwasiŋ yac ŋalêŋ ŋayham. Têŋ ndoc dinaŋ u gic ma gameŋ ŋalhuc atu, bocdinaŋ sêkôm ya golom bu yac aheŋ dauŋ. ");
INSERT INTO buk_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pol tap a basô ti gap bu kêŋ pi ya ndi, magoc mboc sac daŋ yêc gap ŋalôm, ma têŋ ndoc kêsahê ya ŋandê, dec sa bu lhö ndi ma seŋ Pol sip amba. ");
INSERT INTO buk_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Lau malachu sêlic mboc dau keseŋeŋ Pol amba dôŋ gacgeŋ kêgalêŋ, dec sêsôm têŋ dau bu, “Ŋgac dê mboe iŋ ŋgac gic ŋamalac ndu-ŋga, dec iŋ wêkaiŋ ŋagêyô atu. Gitôm bu gwêc kô iŋ ndu su, magoc kwahic dec iŋ oc wê sa dom.” ");
INSERT INTO buk_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Tigeŋ Pol kêbalip mboc dau sip ya gi, ma gêŋ daŋ kôm iŋ dom. ");
INSERT INTO buk_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Lau dau sêkêŋ bata bu iŋ amba oc suŋ me ŋagahô iŋ oc hudau sip ndi mbac ndu. Magoc sêhôŋ ŋasawa baliŋ e sêlic gêŋ daŋ hôc asê iŋ dom. Bocdinaŋ dec ŋac gauc gêm bu mboe iŋ oc anötö daŋ. ");
INSERT INTO buk_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ŋgac daŋ ŋaê Publias gêm gôliŋ nduc dinaŋ, ma iŋ wêkaiŋ ndê gameŋ daŋ yêc kêpiŋ baö naŋ waŋ popoc kalhac. Iŋ kôc yac sa a andöc iŋ ndê andu, ma yob yac ŋapep gitôm bêc tö. ");
INSERT INTO buk_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Têŋ ndoc dinaŋ Publias damba gêmbac yêc, ŋamlic ŋamahom ti kêc dau. Pol sôc gi gêlic iŋ, ma teŋ mbec ti kêŋ amba sac iŋ, ma kôm iŋ ŋayham sa. ");
INSERT INTO buk_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ma têŋ ndoc lau nduc-ŋga sêlic gêŋ dinaŋ, naŋ sêhoŋ si lau gêmbac hoŋ sêtêŋ Pol sêmeŋ, ma iŋ kôm ŋac ŋayham sa tiyham. ");
INSERT INTO buk_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ma ŋac sêtoc yac sa ŋalêŋ ŋayham daêsam. Ma têŋ ndoc yac bu api waŋ ma alhö andi, naŋ sêkêŋ gêŋ hoŋ bu puc yac dôŋ ambo gwêc ŋasawa-ŋga têŋ yac. ");
INSERT INTO buk_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Yac ambo nduc dau tôm ayô tö su, goc api lau malac Aleksandria-ŋga si waŋ daŋ. Waŋ dau poc nduc dinaŋ têŋ ndoc uhô-ŋga ma hôŋ têm ŋayham, ma yêc ŋatôkwa-ŋga sêlêŋ ŋac si anötö gwam lu si aŋgô, daŋ sêsam ŋaê Kasto, ma daŋ ŋaê Polaks. Yac ahu gameŋ dau siŋ, ");
INSERT INTO buk_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ma alac e ahôc asê malac Sairakyus ma ambo dinaŋ tôm bêc tö. ");
INSERT INTO buk_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Goc ahu malac dau siŋ ma alac tiyham e a asôc malac Regiam. Têŋ galaŋsê mbu ŋayham daŋ peŋ lac ŋapep, dec kêŋ yac alac bêc tigeŋ a asôc söc yêc malac Puteoli, ma asip baö a. ");
INSERT INTO buk_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Yêc dinaŋ yac atap lau sêkêŋ whiŋ Yisu-ŋga ŋatô sa, ma sêkôc yac sa a ambo awhiŋ ŋac gitôm bêc 7. Ma tiŋambu yac aŋsêlêŋ bu atêŋ malac Rom andi. ");
INSERT INTO buk_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Lau sêkêŋ whiŋ-ŋga yêc malac Rom sêŋgô ŋawaê bu yac aŋsêlêŋ ambo seŋ, dec sêsa sêmeŋ bu sêkôc yac sa. Ŋatô sêtap yac sa yêc Apias ndê gameŋ sêtidulu gêŋ-ŋga, ma ŋatô sêtap yac sa yêc gameŋ naŋ sêsam bu Andu Ŋacleŋ-ŋga Tö. Têŋ ndoc Pol gêlic lau sêkêŋ whiŋ-ŋga dinaŋ, naŋ iŋ atac pa su ma gêm daŋge Anötö. ");
INSERT INTO buk_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Yac hoŋ aŋsêlêŋ a, e ahôc asê Rom su, goc sêkêŋ ŋasawa têŋ Pol bu ndöc andu daŋ, ma sêkêŋ ŋgac siŋ-ŋga daŋ yob iŋ. ");
INSERT INTO buk_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Bêc tö giŋga su, goc Pol kêgalêm lau bata Israel-ŋga naŋ sêndöc Rom, naŋ sa sêpitigeŋ, ma sôm têŋ ŋac, “Aneŋ asidôwai Israel-ŋga, aö gakôm gêŋ so daŋ têŋ yac neŋ lau Israel-ŋga dom. Ma gakôm gêŋ daŋ naŋ so abaŋi si gêbôm, naŋ dom. Magoc sêkôc aö dôŋ yêc Jerusalem ma sêkêŋ aö gasip gôliŋwaga Rom-ŋga ti iŋ ndê lau siŋ-ŋga amba. ");
INSERT INTO buk_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ma lau Rom-ŋga dau sêŋsahê aö e sêtap sa bu aö gakôm gêŋ giso daŋ naŋ tôm bu sêndic aö ndu-ŋga, naŋ dom. Dec ŋac bu sêhu aö siŋ walhö wandi. ");
INSERT INTO buk_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Magoc lau Israel-ŋga sêtec, ma sêli awha sa e aneŋ lêŋ daŋ mbasi, dec aö gandac bu Sisa ŋgô aneŋ yom. Tigeŋ aö gakôm tu galic ŋac sac-ŋga dom, me tu bu waŋgôliŋ yom pi ŋac-ŋga dom. ");
INSERT INTO buk_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Acsalô lec aö kagalêm mac sa ameŋ, bu aŋgô aneŋ yom pi gêŋ hoŋ dinaŋ. Mac alic bu sêsô aö dôŋ ŋa sen dindec, magoc aö gakôm gêŋ sac daŋ dom. Gêŋ tigeŋ gakôm, naŋ gakêŋ bataŋ gêŋ naŋ lau Israel dau sêkêŋ bata.” ");
INSERT INTO buk_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Lau Israel-ŋga dinaŋ sêŋgô Pol ndê yom ma sêsôm, “Lau naŋ sêndöc gameŋ Judia-ŋga naŋ sêto bapia daŋ têŋ yac, naŋ hêganôŋ am dom. Ma asidôwai Israel-ŋga akêŋ gameŋ dinaŋ, naŋ sêtêŋ yac sêmeŋ, naŋ sêsôm yom sac daŋ pi am dom. ");
INSERT INTO buk_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Magoc yac aŋyalê bu yêc gameŋ hoŋ lau sêpu lêŋ naŋ lau sêkêŋ whiŋ Yisu-ŋga sêŋkuc. Bocdinaŋ yac bu aŋgô am nem gauc ti yom pi lêŋ dau.” ");
INSERT INTO buk_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Goc sêkêŋ bêc daŋ bu sêkac sa sêwhiŋ Pol tiyham. Ma têŋ bêc dau ŋac sêkac sa sêmbo andu naŋ Pol yêc naŋ, ma lau Israel-ŋga hic daêsam sêmeŋ sêwhiŋ, dec ti toŋ atu. Têŋ bêbêc ŋapaŋ e telha Pol sôm yom têŋ ŋac. Iŋ tôc Anötö ndê gôliŋ ŋahu asê têŋ ŋac. Ma iŋ whê Moses ti lau propet si yom sa bu kôm ŋac sêŋyalê bu Yisu iŋ Mesaya dau. ");
INSERT INTO buk_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Lau ŋatô sêŋgô iŋ ndê yom ma sêkêŋ whiŋ, magoc ŋatô sêkêŋ whiŋ dom. ");
INSERT INTO buk_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ŋac sêseŋ dau pi iŋ ndê yom, ma bocdinaŋ Pol sôm ndê yom ŋambu-ŋga têŋ ŋac, ma tiŋambu sêlhö têŋtêŋ. Ma yom ŋambu-ŋga naŋ iŋ sôm têŋ ŋac naŋ sôm bocdec bu, “Yom dindec naŋ Ŋalau Dabuŋ sôm têŋ mac apami, naŋ yom ŋandô ma hêganôŋ mac solop. Propet Aisaya hoc yom dau asê bocdec bu: ");
INSERT INTO buk_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Am têŋ lau dindê ndi ma sôm têŋ ŋac, ‘Mac aŋgô aneŋ yom ŋapaŋ, magoc aŋyalê ŋahu dom. Mac alic gêŋ naŋ aö gakôm, naŋ ŋapaŋ, tigeŋ mac nem gauc sa dom.’ ");
INSERT INTO buk_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Bu lau dau si ŋalôm ŋadandi sa. Ŋac si daŋgasuŋ hôc ahuc, ma sêpôc si tandô ahuc. Bu bocdinaŋ dom, dec oc tôm tandô sêlic, daŋgasuŋ sêŋgô, ma sêŋyalê aö tidôŋ yêc ŋac si ŋalôm e sênem dau kwi ma wakôm ŋac ŋayham sa.” ");
INSERT INTO buk_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Goc Pol sôm, “Bocdinaŋ aŋyalê bu Anötö kêkiŋ ŋawaê ŋayham pi iŋ ndê lêŋ nem lau si-ŋga naŋ mac atec, naŋ têŋ lau gameŋ apa-ŋga. Ma ŋac lau dau oc sêŋgô ti sêkôc sa.”  ");
INSERT INTO buk_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Iŋ sôm su goc lau Israel-ŋga sêlhö si, ma sêseŋ dau pi iŋ ndê yom. ");
INSERT INTO buk_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Tiŋambu Pol mbo malac Rom gitôm yala lu. Ma tôm ŋasawa dinaŋ, iŋ gêmlhi ŋamalac daŋ ndê andu daŋ tu ndöc-ŋga, ma iŋ kôc lau daêsam sa yêc andu dau, naŋ sêmeŋ bu sêndic iŋ kêsi. ");
INSERT INTO buk_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Iŋ gêm mêtê pi Anötö ndê gôliŋ ma kêdôhôŋ lau pi Pômdau Yisu Kilisi. Iŋ kôm gêŋ dau ti atac pa su, ma lau daŋ sêlhac iŋ ahuc dom. ");
INSERT INTO buk_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Aö Pol, Yisu Kilisi ndê ŋgac akiŋ, gato bapia dindec. Anötö kêgalêm aö sa gati iŋ ndê †aposel, ma kêyaliŋ aö sa bu wahoc iŋ ndê ŋawaê ŋayham asê. ");
INSERT INTO buk_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Ŋawaê ŋayham dau Anötö kêmatiŋ tidôŋ muŋ su, ma iŋ ndê propet sêhoc asê, ma sêto sip Buku Dabuŋ. ");
INSERT INTO buk_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","4","Ma yom dau hêganôŋ iŋ ndê Atu Yisu Kilisi, yac neŋ Pômdau. Iŋ ti ŋamalac naŋ sa akêŋ Kiŋ Dawid ndê toŋ. Ma tiŋambu Anötö uŋ iŋ sa akêŋ lau batê-ŋga ŋa Ŋalau Dabuŋ ndê ŋaclai, dec tôc asê tiawê bu iŋ Anötö Atu. ");
INSERT INTO buk_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ma Yisu Kilisi dau kêyaliŋ yac sa ma kêmwasiŋ yac bu ati aposel tu iŋ ndê ŋaê-ŋga, dec kêkiŋ yac bu aŋgalêm lau sa yêc gameŋ hoŋ bu s êkêŋ whiŋ iŋ, ma tu dinaŋ-ŋga dec daŋga wambu iŋ ndê yom. ");
INSERT INTO buk_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ma galem dau têŋ mac lau Rom-ŋga bu ati Yisu Kilisi ndê lau bocdinaŋ. ");
INSERT INTO buk_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Aö gato bapia dindec têŋ mac lau Rom-ŋga hoŋ naŋ Anötö tac whiŋ mac, ma kêgalêm mac sa ati iŋ ndê lau dabuŋ. Mwasiŋ ti yom malô têŋ mac hoŋ akêŋ Damaŋ Anötö, lu Pômdau Yisu Kilisi. ");
INSERT INTO buk_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Gêŋ ŋamata-ŋga aö wasôm têŋ mac bu tôm bêc hoŋ, aö gateŋ mbec tu Yisu Kilisi ndê ŋaê-ŋga, ma gam daŋge aneŋ Anötö tu mac hoŋ-ŋga. Ŋahu bu yêc gameŋ hoŋ lau sêŋgô mac nem akêŋ whiŋ ŋawaê. ");
INSERT INTO buk_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Ma Anötö naŋ aö gam akiŋ ti aneŋ ŋalôm sambuc, ma gahoc iŋ Atu ndê ŋawaê ŋayham asê, naŋ kêyalê bu yomandô aö gauc gêm mac ŋapaŋ, ");
INSERT INTO buk_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","têŋ têm hoŋ naŋ gateŋ mbec. Ŋasawa baliŋ su, aö atac whiŋ bu wandic mac kêsi, ma kwahic dec aö gateŋ mbec têŋ Anötö bu lic aö neŋ gauc dinaŋ ŋayham, ma lêc gatam su têŋ aö bu watêŋ mac waloc. ");
INSERT INTO buk_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Bu aö atac whiŋ ŋandô bu walic mac, tu bu wakêŋ Ŋalau Dabuŋ ndê mwasiŋ ŋatô lom mac bu puc mac dôŋ. ");
INSERT INTO buk_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Ma têŋ ndoc yac dambo dawhiŋ dauŋ, naŋ mac nem akêŋ whiŋ ma aö neŋ gakêŋ whiŋ, oc piŋ yac hoŋ dôŋ bu dalhac ŋaŋga. ");
INSERT INTO buk_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","O asidôwai, aö atac whiŋ bu mac aŋyalê bu têm daêsam aö gauc gêm bu watêŋ mac waloc, magoc gêŋ daêsam kalhac aö ahuc e meŋ têŋ kwahic dec. Aö gam mêtê yêc lau apa si gameŋ ŋatô, ma aneŋ gweleŋ dau gêm ŋandô su. Boc-dinaŋ aö gauc gêm bu wakôm gweleŋ kaiŋ tigeŋ wawhiŋ mac e gweleŋ dau ŋandô sa yêc mac-ŋga whiŋ. ");
INSERT INTO buk_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Gweleŋ dau gic aö ŋawaê bu wanem mêtê lau Grik ti lau naŋ lau Grik dom, ma lau ti gauc ma lau gauc mba sêwhiŋ. ");
INSERT INTO buk_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Tu dinaŋ-ŋga dec aö neŋ ŋalôm kac aö bu wanem mêtê mac lau Rom-ŋga awhiŋ. ");
INSERT INTO buk_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Bu aö mayaŋ tu Anötö ndê ŋawaê ŋayham-ŋga dom. Ŋahu bu Anötö ndê ŋaclai yêc yom dau, bu nem lau naŋ bu sêkêŋ whiŋ, naŋ si. Iŋ gic bata têŋ lau Israel-ŋga muŋ, ma têŋ lau naŋ lau Israel dom, naŋ tiŋambu. ");
INSERT INTO buk_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ŋawaê ŋayham dau ndê ŋaclai yêc bu nem lau si, ŋahu bu ŋawaê dau tôc lêŋ naŋ Anötö kêŋ bu ŋamalac sêti lau gitêŋ, naŋ asê. Lêŋ dau lêŋ dakêŋ whiŋ-ŋga, ma ŋalêŋ daŋ mba. Tôm yom naŋ propet akwa daŋ to yêc bocdec bu: Lau gitêŋ oc sêndöc tali tu si sêkêŋ whiŋ-ŋga. ");
INSERT INTO buk_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Anötö naŋ ndöc undambê, kwahic dec tôc iŋ ndê ŋalôm asê têŋ yac. Iŋ tac ŋandê têŋ lau naŋ sêpuc dômbwê iŋ, ma sêkôm mêtê sac. Ŋac si mêtê sac kêgwiniŋ yom ŋandô dôŋ. ");
INSERT INTO buk_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Gitôm bu lau nom-ŋga sêŋyalê yom ŋandô pi Anötö, bu gêŋ naŋ iŋ kôm, naŋ whê iŋ sa tiawê têŋ ŋac su. ");
INSERT INTO buk_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Lau daŋ sêlic Anötö su dom, yomandô! Tigeŋ têŋ ndoc iŋ kêŋ undambê ti nom e meŋ têŋ kwahic dec, naŋ sêlic gêŋ hoŋ naŋ iŋ kêŋ. Ma gêŋ dau whê iŋ ndê ŋahu sa ma tôc iŋ ndê ŋaclai atu naŋ yêc titêm-titêm, naŋ asê tiawê. Tu dinaŋ-ŋga dec ŋamalac daŋ oc tôm dom bu pa dau ma sôm bu iŋ gêm gauc Anötö. ");
INSERT INTO buk_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Lau nom-ŋga sêŋyalê bu Anötö dê mbo, magoc sêtoc iŋ sa ti ŋac si Anötö, ma sem daŋge iŋ tu gêŋ daŋ-ŋga dom. Ŋac sêhê gauc pi yom ŋambwa-ŋambwa daêsam e ŋasec kôm ŋac si ŋalôm ahuc. ");
INSERT INTO buk_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ŋac sêtoc dau sa bu ŋac lau ti gauc, magoc ŋac lau gauc mbasi. ");
INSERT INTO buk_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Ŋac sêtec bu sênem akiŋ Anötö naŋ mbo titêm-titêm, magoc sem akiŋ gêŋ naŋ gic waê bu niŋga. Ŋac sêhu Anötö ti ndê ŋawasi atu siŋ, ma sem akiŋ gwam naŋ ŋac dau sêmasaŋ sem ŋamalac aŋgô, mbac aŋgô, bôc aŋgô, ma mboc aŋgô. ");
INSERT INTO buk_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Tu dinaŋ-ŋga dec Anötö hu ŋac siŋ bu sêkôm mêtê ŋalôm ŋagalac-ŋga tôm si atac whiŋ. Ma sêkôm mêtê ŋadômbwi pi dau ŋamlic gitôm gêŋ ŋambwa-ŋga. ");
INSERT INTO buk_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ŋac sêpuc dômbwê Anötö ndê yom ŋandô, ma yom tasaŋ gêm ŋac si ŋalôm ahuc. Ŋac sêtec bu sênem akiŋ Anötö naŋ kêŋ gêŋ hoŋ, ma sêhu iŋ siŋ ma sem akiŋ gêŋ naŋ iŋ kêŋ. Magoc iŋ gêŋ hoŋ ŋadau, ma ŋayham bu yac tampiŋ iŋ tôm bêc hoŋ. Yomandô! ");
INSERT INTO buk_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Tu ŋamalac si giso-ŋga, dec Anötö hu ŋac siŋ bu sêkôm gêŋ mayaŋ-ŋga tôm ŋac si ŋalôm ŋagalac kêgilí ŋac. Ŋac si lauwhê sêhu lauwhê ti ŋgac si lêŋ solop sêmbo sêwhiŋ dauŋ-ŋga siŋ, ma sêsa lêŋ so. ");
INSERT INTO buk_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ma ŋalêŋ tigeŋ lauŋgac sêhu lauwhê ti ŋgac si lêŋ solop siŋ ma mêtê atac ŋagalac pi dandi-ŋga gêm ŋac ahuc sambuc. Lauŋgac sêkôm mêtê mayaŋ-ŋga sêwhiŋ lauŋgac, ma tu dinaŋ-ŋga sêtap ŋagêyô naŋ gic mêtê sac kaiŋ dinaŋ ŋawaê, naŋ sa yêc dau si ŋamlic. ");
INSERT INTO buk_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ŋamalac sêlic ŋayham bu s êpuc dômbwê Anötö, ma tu dinaŋ-ŋga iŋ hu ŋac siŋ e ŋac si gauc timboloc, ma sêkôm mêtê naŋ gic ŋamalac ŋawaê dom. ");
INSERT INTO buk_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Mêtê sac tidau-tidau gêm ŋac si ŋalôm ahuc. Ŋac sêkôm mêtê gitôm mêtê wec ma mêtê mayaŋ-ŋga, ŋac tagatu gêŋ, ŋac sêlic lau ŋatô sac, sic ŋamalac ndu, sêŋgalôm lau, sêkôm gêŋ daêsam bu sêtim lau ma sêŋsau ŋac, ma sêsec lau. ");
INSERT INTO buk_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Ŋac sêŋgôliŋ yom pi lau, atac tec Anötö, ma sêpu lau ŋatô. Sêpo dau ti sêtoc dau sa, sêkôc gauc pi lêŋ sac ŋapaŋ, ma ŋac daŋgapêc ŋawahô têŋ dinda ti dambai. ");
INSERT INTO buk_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Ŋac lau gauc mbasi-ŋga, ma yom bocke naŋ sê