﻿USE sofia;
DROP TABLE IF EXISTS sofia.bswl_vpl;
CREATE TABLE bswl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bswl_vpl WRITE;
INSERT INTO bswl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tadaawutena taɂabraame sannii kalleero kayesuusa Kiristoosa alattankkokki hididi haaya; ");
INSERT INTO bswl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraame Yissaak'a umule, Yissaak'a Yayik'ooba umule, Yayik'ooba Yihuudana abbilaal umule, ");
INSERT INTO bswl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yihuudana Tiɂimaarkko Faaresina Zaara umule, Faaresi Esiroomi umule, Esiroomina Araam umule, ");
INSERT INTO bswl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Araamina Aminadaabi umule, Aminadaabina Neɂasooni umule, Neɂasoonina Selemooni umule, ");
INSERT INTO bswl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Selmoonina Reɂaabkko Boɂeezi umule, Boɂeezina Ruutikko Iyobed umule, Iyobdina Isseyi umule, ");
INSERT INTO bswl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isseyi wono Daawute umule, Daawutenna taɂooryo oorikko Solomooni umule, ");
INSERT INTO bswl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoonina Robiɂami umule, Robiɂamina Abiya umule, Abiyanna Aasafi umule, ");
INSERT INTO bswl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aasafina Iyosafit'i umule, Iyosafit'ina Iyohorami umule, Iyohoramina Oziyaani umule, ");
INSERT INTO bswl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oziyaanina Iyoɂataami umule, Iyoɂataamina Akkaazi umule, Akkaazi Hizk'iyaasa umule, ");
INSERT INTO bswl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hizik'iyaasa Minaase umule, Minaase Amoos'i umule, Amoos'ina Iyosiyaasi umule, ");
INSERT INTO bswl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iyosiyaasi gosa kaɂisiraɂeel Baabloni tos kakkobojaamere goorata Ikkoniyaanina Abbilaal umule. ");
INSERT INTO bswl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kabbabilooni boojaamanokko abbaabatere Ikkoniyaan Selaatiyaali umule, Selaatiyaanina Zurbbaabeela umule, ");
INSERT INTO bswl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zurbbaabeela Abiyuudi umule, Abiyuudina Elyaak'emi umule, Elyaak'emina Azaari umule, ");
INSERT INTO bswl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azaari Sadook'i umule, Sadook'i Akiim umule, Akiimina Elyuud umule, ");
INSERT INTO bswl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elyuud Alaazari umule, Alaazari Maatani umule, Maatani Yayik'ooba umule, ");
INSERT INTO bswl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yayik'ooba Yoosefa umule, Yoosefana kafayyisaro Kiristoosa Yesuusakotti Aaye Mayiraame kaɂeerateroye. ");
INSERT INTO bswl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Goortta Abraamekko taa Daawute geeron alattaan tomonkko afartta, Daawutekko taa kabbaabilooni boojaamano geeron alattaan tomonkko afartta; kabbaabilooni boojaanokko taa takiristoosa alattaan geeron alattaan tomonkko afartta. ");
INSERT INTO bswl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Tayesuusa Kiristoosa alattankkotti jirtti hikkamaleetta, Aayetteessa Mayiraame Yoosefaan eeraanttegudde haɂeseloon Ayyaana K'ulluukkii fato tootaatte mutte. ");
INSERT INTO bswl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ese kaɂeeraatera Yoosefa k'ajeelakki ibaaddoti mankkolleero maraan Mayiraame ibaaddo horee fanchoyisiin mankkodooton maraan haɂaddeesisoon iisin murtteesse. ");
INSERT INTO bswl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Usu goɂameen hikka k'oppaa giraan kagootta erggichcha hisillooyi usuun mute, haanna ame, «Sannii tadaawute kalleetetta Yoosefa, taɂeerattetto Mayiraame atayi oori yelayiin arooɂabssatte aalanttina ese kakkottotaatetta k'ulluukki ayyaanakkoyya. ");
INSERT INTO bswl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Babbaartitinna umulnatta, megekkeessana Yesuusa ami uumnatta; aalanttina usu gosakkeessa c'ubbokkisookko mankkohaasinaro maraanya.» ");
INSERT INTO bswl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Goottaa gara kahegeroonne haa ame kaɂayeesera felooyi goggohayiroon amegure hikki dubba lee. ");
INSERT INTO bswl_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Hikkina, deeleeltiti fato tootaayinatta babbaartitina umulnatta megekkeessana amanuɂeeli amaminnara,» fureeninna «Waa noonne wota gira amanoyya.» ");
INSERT INTO bswl_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yoosefana huddurokko nabbaade, esekkona kagootta erggichcha goggosegeeroyi Mayiraame oori yelayiin minkkeessa tos atate seete. ");
INSERT INTO bswl_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Halleewo kuwaarre erekkisee taaɂumulttooyi esene wota lakkohuddurero kaɂalatero yiittitina Yesuusa ame uume. ");
INSERT INTO bswl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Wono Herodoosa reede kakkogire geesii; Yesuusa tabeteleemi katamaayi kayihuuda ulii kakkoɂalatare goorata barraajja ok'ok'k'orareen mina tabiyaankko Iyyerusaalemi tos emetengureen, ");
INSERT INTO bswl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Kayihuuda wono liin kaɂalatera yiittiti haggee gira? Mina tabiyaaninne bakkaala deennegunne usuun sagadin emeennenna ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Wono Herodoosa hikka ayees kakkomaalare goorata nee. Usumaleenna kaɂiyyerusaalemi ibaaddo dubba nee. ");
INSERT INTO bswl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Usu katuuk'aamol woyichchaalnna seera kaɂayihuudi oɂagaalssisaran dubba kukkuyisere Kiristoosa haggee alayinaro hoosate. ");
INSERT INTO bswl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Isona, «Kayihuuda ulii tagitto tabeteleemi katamaayiya;» kahegerooyi haa amame s'aafamera; ");
INSERT INTO bswl_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","« ‹Ul kayihudaayi tagitta ati Beteleemi! Kakkalee tayihuuda katamaalkko duuddo lakkoyeraatatto, Gosakkee Isiraɂeel kafoofinara mootii kukko binnara ameen.› » ");
INSERT INTO bswl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Esekkona Herodoosa barraajja ok'ok'k'orareen golise uumsegure ayeesisaa bakkaala kakkomutero likkiikki goorata hoosate maale. ");
INSERT INTO bswl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Barraajja ok'ok'k'orareenna Beteleemi tos faregure «Seeyenguddeen yiittiti malaa doota, aninna adi seeyigure usuun goggosagadiroon usu goggoheltteeni in tos abbaabayiddeen eetii giro iin segaa» ame. ");
INSERT INTO bswl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Barraajja ok'ok'k'orareenna wono kaɂamero maaleen abbaabatengureen sesseettan horeddeen. Hikkina mina tabiyaaninne kaddeeraan bakkaala raa k'ajeelisaa yiittiti mankkogiro banɂe geere aallee. ");
INSERT INTO bswl_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bakkaalana kakkodiyaaren goorata aaloo geggelaaten. ");
INSERT INTO bswl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Min orro kakkotabareen goorata yiittitina Aayetteessa Mayiraamene wota kagiro deen, gilbbisengureen sagadeen. Saat'inekisonna banatengureen work'k'ii, it'aanane, urit taɂidan kaɂabo k'ibaati siseen. ");
INSERT INTO bswl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Isona Herodoosa tos goggoɂabbaabanonkko Waa hisillooyi ataayise isoon mankkosegeero maraan raa iggilissateen ulkkisoo tos abbaabateen. ");
INSERT INTO bswl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Barraajja ok'ok'k'orareen seeteen kakkobuwaaren goorata erggichcha kawaa Yoosefaan mutegure ki ati takkoɂabbaabatto arri ani kuun taa segiroon yiittiti Aayetteessane wota aati Gibs's'i tos bak'agudde esee giri. «Herodoosa yiittiti lagadin dootara» ame. ");
INSERT INTO bswl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Haanssun usuna keegure yiittitina Aayetteessana aategure hemeen Gibs's'i tos seete. ");
INSERT INTO bswl_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Eseenna Herodoosa taaggooroo adallaate. Hikkaniinna «Erekkeena ul kagibs's'ikko uumaye» amaa Goottaa kahegerookotti hiɂii kaɂayeesera haafura feloo haye. ");
INSERT INTO bswl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodoosa barraajja ok'ok'k'orareen usu sobano addeesegure aaloo amaraate, barraajja ok'ok'k'orareen barraajja kakkomutero goorata goggosegeerankki malee gees lamana esekko hegelbbaan kalleero Beteleeminna usu gobobii kagiro maamanjolkokki babbaar yiis dubba kukkuyisere fare lagadisise. ");
INSERT INTO bswl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Hassu goorata kahegeroo Ermaasaa haa amame kasegaamera feloo haye. ");
INSERT INTO bswl_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Kaɂoottaneenna kaɂatii iyyakkotti yaaye Ramaayi malssantte. «Raheelinna Yiiskkisee maraan ootte, Goggoɂinna yelayin lakkodaanddeete, aalanttina Yiiskkise mankkogoye maraanya.» ");
INSERT INTO bswl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Goyi kaherodoosakko abbaabatere kagootta erggichcha Yoosefaan hisillooyi mutegure, ");
INSERT INTO bswl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«Kingudde yiittitina Aayetteessa aatigudde ul kaɂisiraɂeel abbaaba, yiittiti lagadin odootareen goyeeran» ame. ");
INSERT INTO bswl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yoosefana keegure yiittitina Aayetteessa aategure ul kaɂisraɂeel tos abbaabate. ");
INSERT INTO bswl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ayesuun goɂameen Arkkiloosa Aabbokkeessa Herodoosakkotti banɂee ul kayihudaa wono lee reedano kakkomaalare goorata Yoosefa eserraa seeyin abssate. Hisillooyi usuun kakkosegaamare goorata tagaliila awuraajjaa tos seete. ");
INSERT INTO bswl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Naazireti taɂamamatto katamaa tos seetegure hamas's'ee. Hikkaniinna kahegerooli, «Kanaazireti amaminnara» amameen osegaameraan hegero felooyi hayeen. ");
INSERT INTO bswl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Usu goorata kat'ammak'aara Yaannisa kayihuuda k'alullattokki ulii lallabaa emete. ");
INSERT INTO bswl_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Lallabaanokkeessana, «Wononnati kadaruure gabbalamera c'ubbokko gula gala» kaɂamaroya. ");
INSERT INTO bswl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kahegeroo Isiyaasayi haa amame kasegaamera usuya, «K'alullattokki ulii ‹Raa kawaanna ekkaasa bobbana tukkul umisa› amaa taɂokkaatto yaaye.» ");
INSERT INTO bswl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Kayaannisa sarssina ogorro ogaalakko kafelamero golleero mooɂootteesayina gii mowatare. Babokkeesana kenttefarrona kagaado malabye. ");
INSERT INTO bswl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Iyyerusaalemikko, kayihuuda ul dubbakkona laga kayorddaanosi gobobii kagiro ulkko ibaaddo dubba Yaannisa tos guuramare. ");
INSERT INTO bswl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","C'ubbokkisokkona gula galaa laga kayorddaanosii genetteessaayi t'ammak'amaa gireen. ");
INSERT INTO bswl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Farasaawilkkona Sodok'aawilkko kamooggan ibaaddo usu takkot'ammak'are banɂe kaɂemeetaro kakkodiyaare goorata haa ame, «Isin yiis kahabeessa taɂemaatto engge tawaakko goggohessaanun ayyoya isin kagorssee? ");
INSERT INTO bswl_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Goorttanun c'ubbokko gula galanokkisin otusaraan felo fela. ");
INSERT INTO bswl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","‹Abraame Aabbokkaaniya› taɂamattaan k'ofaayi isiɂoottisin aroosobatteen; Waa hikka eɂemoolkko Abraamen yiis keesin daanddaara. ");
INSERT INTO bswl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Goortta masaar kagaaddol hidiid goosin ekkaattetta, il taɂidan kadubamoon gaa dubba goosaminara; eleen orrona shafaminara. ");
INSERT INTO bswl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","«Ani isin c'ubbokko gula mankko galtteettaan maraan bekeeyi t'ammak'inara, ayesuun goɂameen keferro oottessana sidin ani kadootisoon, inkko karooraro hunna kaɂaba inkko haarre emeetara. Usuna k'ulluukki ayyaanayinna eleenii isin t'ammak'inara. ");
INSERT INTO bswl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kakkobbanp'araanna genetteessaayi gira, addummaa basamigudde banp'aaminatta, darggammaanna gootaraayi kibaminatta, galabaa adde tabaanon eleenii gubaminnatta.» ");
INSERT INTO bswl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Hassu goorata Yesuusa gene tayaannisaa t'ammak'amin Galiilakko laga kayorddaanosi tos emete. ");
INSERT INTO bswl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yaannisa goɂameen, «Hikki haa liin lakkodaanddaaro, ani genettaayi t'ammak'amin dootisaa giraan ati misii in tos emaatta?» ame isi tirate. ");
INSERT INTO bswl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesuusana, «Koonna lakkogiro ati ii ami, hikka felanooyi ok'ullumma felo dubba felano noon dootisara» ame. Yaannisana ayesuun ii ame. ");
INSERT INTO bswl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesuusana goorsewa t'ammak'ame bekekko goggobeeyi daruurnna bananttegudde Ayyaana kawaa arabe aani usu gutii dagaa giraan dee. ");
INSERT INTO bswl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Usu goorata, «Ani kakkogeggelayinara, ani kageelaatara erekki hikkaya» taɂamatta yaaye daruurkko maalssantte. ");
INSERT INTO bswl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Hikkakko abbaabatere Ayyaana k'ulluukki Yesuusa durrisaa goggoc'aafamiro k'alullattokki ul tos aate bee. ");
INSERT INTO bswl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Hemeen afarttamnna arri afarttam agabuukko abbaabatere uuɂee. ");
INSERT INTO bswl_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kac'aafarekkina Yesuusa tos gabbalamere «Ati ere kawaa golleete hikka eɂemool babo goggolleeroo ajajii» ame. ");
INSERT INTO bswl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesuusana, «Ibaaddo hiɂi tawaakko kabiyaaro haafura dubbaa kuwaarre babo kaalaalii lakkogiraro amame mas'aafaa k'ulluukkii s'aafamera» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Adena durrisa Yesuusa k'ulluutti katamaa Iyyerusaalemi tos aate seetegure k'ulluukki min kawaayi birt'ee aate beegure, ");
INSERT INTO bswl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","«Ati ere kawaa golleete» «hegelddee issii firimi, luk'aɂootta eɂemooyi goggohanduddufannonkko iso genettisooyi goggokeesinawun erggichchaal ku maraan ajajinara amame mas'aafa k'ulluukkii s'aafamera ame.» ");
INSERT INTO bswl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesuusana, abbaabere, «Goottaa Hedokkaa arooc'aafite amame ade mas'aafa k'ulluukkii s'aafamera» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Adena, durrisa Yesuusa aaloo t'ok'k'i taɂantte wodamii korisegure alamikokki wonolaal kabajjatisoonne wota usuun tusegure, ");
INSERT INTO bswl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","«Ati in horee iigudde gilbbisi gosagadde hikka dubba ani kuun sisinnara ame.» ");
INSERT INTO bswl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesuusana, «Ati s'alaye in horekko fakkiɂami! ‹Waa Hedokkaawun sagadi; usu kaalaalnna hedoyisa› amame mas'aafa k'ulluukkii s'aafamera» ame. ");
INSERT INTO bswl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Esekkona durrisa iise seete; erggichchaalnna emeetegure usuun handdaye. ");
INSERT INTO bswl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesuusa shaamano kayaannisa maalere ul kagaliila tos abbaabate seete. ");
INSERT INTO bswl_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tanaazireti katamaa iisegure; Zaabllooninna Nifittaaleemikotti awuraajjaayi tagaliila labu giridii tagitto tak'ifirenaahoomi katamaayi girano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Hikkaniinna kahegeroo Isiyaasayi haa amameen osegaameran hegero feloo hayeen. ");
INSERT INTO bswl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Ul kazaabllooninna ul kanifittaaleemi, Yorddaanoskko gama labu girii kagiro raa dollee kagaliila Ayizaab, ");
INSERT INTO bswl_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mugudii kagire gosa kaɂatii ifa dee; Hoos tagoyii kagire ibaaddoonna ifa bee.» ");
INSERT INTO bswl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Hassu gooratakko haggaɂabere Yesuusa, «Wononnati kadaruuree gabbalamera c'ubbokko gula gala» ame lallabaano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesuusa tagaliila labu girndde rooraa giraan abbilaal lama P'et'iroosa kaɂamamaro Simoonanne abbikkeessa Indiraasane dee. Kunɂub oɂabatareen mankkoleen maraan maarrabitisoo bekerro lugudataa gireen. ");
INSERT INTO bswl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesuusana «Koyeen indebee sesseeyeen» Ibaaddo wononnati kawaa tos goggokeenttanun ani isin yelnnara ame. ");
INSERT INTO bswl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Goorsewa maarrabitisoo iiseengureen usuu debee sesseeteen. ");
INSERT INTO bswl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Esekko goggorooreyi takkalee abbilaal lama ere kazabddoosa Yayik'oobana abbikkeessa Yaannisane dee. Aabbokkisoo Zabddoosane wota wolabo orroo maarrabitisoo ekkaasataa gireen; Yesuusana iso uume; ");
INSERT INTO bswl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Goorsewa iso wolabottisonna Aabbokkisoo iiseen Yesuusa debee sesseeteen. ");
INSERT INTO bswl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesuusana Ayihuudikokki min kaɂebii wononnati kawaakokki kageggeloo haafura agaalssisaanna lallabaa; gosa orroo kagiro maamisikki hawɂaamikkona maarii gutii tagitto rakkoo tamooggankko fayyiisaa kagaliila ul dubbaa maraamuraa gire. ");
INSERT INTO bswl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Hikkakko kakkeeyi ataankkeessa kasooriya ul dubbaa maalssame; gosana kalekaleekki hawɂaami hawɂaamaa kagirena; maar orrookki hawɂaami kameellanii abboosamaren; durrisa gutii kakkogirena kagaggadduu hawɂaami oɂabanaayen; naafaleessaal dubba usu tos keenen; usuna iso fayyiise. ");
INSERT INTO bswl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Hikkakko kakkeeyi; Galiilakkona, katamaa tomonkko Iyyerusaalemikko, Yihuudakona, laga kayorddaanosi gamakko kaɂemeetera kamooggan ibaaddo Yesuusaa debee sesseete. ");
INSERT INTO bswl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesuusa gosa kakkodiyaare goorata wodami tos beegure hamas's'ee; usukko oɂagaalssatareen usu tos emeten. ");
INSERT INTO bswl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Haa amaa agaalssisano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Ayyaanakkisooyi Waa odootataraan osommaasameenyan; wononnati kadaruure kakkisooyya. ");
INSERT INTO bswl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ogaddaaran osommaasameenyan; Waakko goggoɂinna helayinaraan. ");
INSERT INTO bswl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Fayyankkanɂi osommaasameenyan; ulnna eelinaran. ");
INSERT INTO bswl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","K'ullumma oɂuɂaaranna osugubaataraan osommaasameenyan bararraanwa. ");
INSERT INTO bswl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Shaaga oyelaraan osommaasameenyan; Waakko shaaga helayinnaraan. ");
INSERT INTO bswl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Wodana k'ulluu okkonlleetetta osommaasameenyan; Waa dinnaraan. ");
INSERT INTO bswl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Owogarisaraan osommaasameenyan yiis kawaa amami uumaminaraan. ");
INSERT INTO bswl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","K'ullumma maraan ameerene ohorooramaraan osommaasameenyan; Wononnati kadaruure kakkisooyya. ");
INSERT INTO bswl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«Ibaaddo aalantti teeyi isin gohabaare gohoroorena, meellane dubba isin gutii goɂayeese osommaasantteettan. ");
INSERT INTO bswl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Daruurii isin taɂatayinnattaan muraa taɂatii mankkolleete maraan geggelaayen; geggeloo tusa. Isinkko horeene ogireen ohegerool hikkamalee horooreraan.» ");
INSERT INTO bswl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Isin taɂulee essebottaan. Essebo taɂesseboo onɂomoonje gowaatte abbaabayi onɂomoonje yelayin daanddaata? Sar shafamidde luki taɂibaaddoyi daddaramin kuwaarre laɂo lakkoɂabtto. ");
INSERT INTO bswl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Isin kaɂalami ifattaan. Wodami gutii tagitta katamaa siyamin lakkodaanddeeto. ");
INSERT INTO bswl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Dab hank'k'ayisatere daachcho hegelii golssate kakaatara ibaaddo lakkogiro. Min orroo kagiro dubbaan goggohank'ayiro bollanssoo gutii kayin kuwaarre. ");
INSERT INTO bswl_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Hikkamaleenna ibaaddo oɂidan feloɂoottisin diigure daruurii kagiro Aabbokkisin goggokabajiron ifakkisin ibaaddo horee hahank'awo.» ");
INSERT INTO bswl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Ani seera kamusena kahegeroo iggilisin kaɂemeeyero aani isinuun aroolleeno; feloo hayisin kuwaarre iggilisin lakkoɂemeeyero. ");
INSERT INTO bswl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ani rumminaa isinuun amara, ulnna daruurinna taa roorraanii seera dubba feloo hayinara kuwaarre seerakko fidale too goorttun eeggano koo duuddo lakkoɂiggilssamiro. ");
INSERT INTO bswl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Haanssun maayyona hikka ajaja dubbakko kic'c'arkki gobbaase kakkaleenna goggobaasiro goɂagaalssise wononnati kadaruureyi dubbaankko kic'c'arkki amami uumaminara. Ayesuun goɂameen hikka ajajaal feloo hayisaa okkaleenna felooyi goggohayisinawun kaɂagaalssisara hassu wononnati kadaruureeti kanjiinkki amaminnara. ");
INSERT INTO bswl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","K'ullummattisin tafarasaawilkkonna seera kamuse oɂagaalssisaraankkotti k'ullummakko roori gomutoon wononnati kadaruure tos ijjii tabin lakkodaandaattan ani amara.» ");
INSERT INTO bswl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Kahoree ibaaddone ‹Ibaaddo aroolagaaddeen kaɂamamero isin maaltteettan; ibaaddo kalagadara firddaaminara kaɂamamero maaltteettan.› ");
INSERT INTO bswl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ani goɂameen haa amara; abbikkeessa raakkallii kaɂinggaamara dubba firddaaminara; goorttun abbikkeessa ‹Kamaaddinoon› kaɂamara taɂayihuudi shonggoyi hoosaminara; ‹Taatowaa› kaɂamara ade tagaannemi eleenkokki firdda usu ooratara. ");
INSERT INTO bswl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","«Haanssun jaarssokkaa banɂe tafalaa gutii kayitedde Waawun kakkosisato goorata abbikka ku kakkok'uk'amera ayees kuun k'alli goɂame, ");
INSERT INTO bswl_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Jaarssokkaa ese banɂe tafalaa horee isaagigudde horaarjje seegudde abbikkaanne wota wogari; Esekko abbaabadde jaarssokkaa Waawun sisi. ");
INSERT INTO bswl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Ku kamootara baragarakka ku goggofirddisonkko, daannanna kashaaron roorisi ku goggosisoonkkona min kashaano goggotabisoonkko raadii giraan saami baragaraakkaanne wota wogari. ");
INSERT INTO bswl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ani kuun rumminaa amara, usu ku gofirddise adi maragade dubba ati muri taagudissoo esekkona lakkobinnatto.» ");
INSERT INTO bswl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Aroosharmut'iteen kaɂamamero maaltteettan. ");
INSERT INTO bswl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ani goɂameen isinne haa amara; heleel tahalchcha ilii kadiyaara dubba wodanatteesayi esene wota sharmmut'eera amanoyya. ");
INSERT INTO bswl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Tamergge iltatta c'ubboon aalantti golleete goorsewa beesi shafi, maarkka dubba tagaannemi eleen tos shafamanakko maarkkaakko banɂe too waatanoya horekki. ");
INSERT INTO bswl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Gene tamerggetatta c'ubboon aalantti golleete goosigudde shafi! Maarkka dubba gaannemi tos shafamanakko; maarkkaakko banɂe too waatano horekki.» ");
INSERT INTO bswl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","« ‹Ooritteessa keelkki ame kabeesara dubba keelkki kakkoɂamero worak'ata eseen sisano dootisara amamera.› ");
INSERT INTO bswl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ani goɂameen isinne haa amara; ese kakkaleenne wota sharmmut'aa giraan gutii goɂabe kuwaarre; ooritteessa keelkki ame kabeesara dubba ese kakkaleenne wota goggoshaarmut'ito kayelaroya. Hikka garaayi keelkki amantte tabeetetto heleelttiti kaɂatatarana kasharmmut'aaro aani tootaamara.» ");
INSERT INTO bswl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Kahoree ibaaddon, «T'araa arooɂammatteen; ayesuun goɂameen Waayi horee kaɂammattetto oora» kaɂamamero maaltteettan. ");
INSERT INTO bswl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ani goɂameen isinne; «Suure arooɂammatteen» amara. Daruurii golleenna arooɂammatteen, korffinjje kawaatta. ");
INSERT INTO bswl_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ulii golleenna arooɂammatteen; luki tawaa takkofoolssaattoya; Iyyerusaalemiinna arooɂammatteen tanjiintti tawono katamaatta. ");
INSERT INTO bswl_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Isiɂoottayi golleenna arooɂammatte; metekaakki fiit'a koo gumaara goorttun gambballa yelin lakkodaanddaatto. ");
INSERT INTO bswl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Haanssun ayeesaa giraan ayeeskkisin goɂiimanaa «iɂii» ade gollaaɂamanaa «laa» halleewo. Hikkakko kakkalee dubba kameellankko kaɂemeetaroya. ");
INSERT INTO bswl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Il maraan il, ilkko maraan ilkkoo,» kaɂamamero isin maaltteettan. ");
INSERT INTO bswl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ani goɂameen isinne haa amara; tameellan kafelaro ibaaddoti arooneebatteen; ayesuun goɂameen hangorooc'c'akkaa kamerggee kabasaroon kakkalee hangorooc'c'a kabbete adi tusa. ");
INSERT INTO bswl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ibaaddoti koo k'olokkaa atayin ku gomootee sarssi kaabbaanne adigudde usuun sisi. ");
INSERT INTO bswl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ibaaddoti koo kuunne banɂe too seenna ami ku gutii gohunnoome usu raakokki ambba usune wota see. ");
INSERT INTO bswl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kukko kaɂebaataron sisi; amɂaayin kadootatarokkonna arootiratte. ");
INSERT INTO bswl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Ollaattaa geelaa diinakkaa diidi kaɂamamero maaltteettaan.» ");
INSERT INTO bswl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ani goɂameen diinajjoolkisinna geelayen, isin ohorooraraawunna ebaayen amara. ");
INSERT INTO bswl_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Hikkamalee mankko yelattaan marantinuun daruurii kagiro Aabbokkisinuun yiisaas linnattaan. Usu kaɂidanuunna kameellanuun dubbaan ariti beesara; idaamona c'ubbaalessaluunna k'ullooleewun ubsisara. ");
INSERT INTO bswl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kageelaataro kaalaal ogeelaatattaan golleeten me muraa helayinattaan? K'arat'a okukkuyisaraanna laa usumalee yelaa giraanna? ");
INSERT INTO bswl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Abbilaalttisin taalaalnne nogodda oɂaatattaan golleeten okkaleekko meyii iidattaan? Ayizaablnna la hikka yelaa giraanna? ");
INSERT INTO bswl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Haanssun kadaruure Aabbokkisin k'ulluukki goggolleeroyi isinna k'ulluunɂi laa. ");
INSERT INTO bswl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Ibaaddo isin goggoddeero amiddeen ‹Oɂidan felo oottisin› ibaaddo horee felatanakko isi oottisin oorayeen; usumalee gofeltteen kadaruure Aabbokkisinkko muraa lakkohelattaan. ");
INSERT INTO bswl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«Ifissaaddoleel ibaaddo horee kabajjaamin ameengureen raadiinna banɂe taɂebii goggosisanaankki malee ati hiyyeessan kooko kakkosisso goorata hamuto amidde arooɂawwaajjite; ani rumminaa amara; hikamalee ollaaran muraattisoo dubba atateeran. ");
INSERT INTO bswl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Isin goɂameen hiyyeessan sisaagiraan gene tamerggettisin kasisatto gene tabbete arooɂaddeeso. ");
INSERT INTO bswl_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Hiyyeessan sisaagiraan gollataa halleewo; gollataa kafelamero kadiyaara Aabbokkisin muraattisinna murrowa.» ");
INSERT INTO bswl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Ebaataa giraan ifissaaddolee aani aroolleeten; iso ibaaddon mutin ameengureen banɂe taɂebiinna raadii k'ark'aarayi aalli ebaatano geelaatanan. Ani rumminaa amara; muraattisoo dubbana atateeran. ");
INSERT INTO bswl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ati goɂameen ebaayin goɂantte; kifilii tos tabi, ufana c'ufagudde gollataa kagiro Aabbokkaa tos ebaa, gollataa kafelamero kadiyaara Aabbokka muraattaa gachchoomurra. ");
INSERT INTO bswl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Isin ebaataa giraan kamaaddinoon haafuraayi abbaab abbaab ebaatanoyi ebi kamaalssamaro aani kalaaro Ayizaab aani ayees jiinasataa arooɂeraasatten. ");
INSERT INTO bswl_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Iso aani aroolleeten, Aabbokkisin isin haɂebaannoon giraan horennewa isinuun me dootisaro kasowa. ");
INSERT INTO bswl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«Isin goɂameen haa ama ebaayen; «Daruurii kagitta Aabbokkaani! k'ulluukki megekka hakabajaame; ");
INSERT INTO bswl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Wononnatikka haɂemeeto; Feɂitta daruurii goggolleetettoyi Usumalee uliinna halleeto; ");
INSERT INTO bswl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kahittaaritee babokkaani hittaari noon sisi. ");
INSERT INTO bswl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Noonna no kamiirɂero haheso goggoɂamannoo; Baaskkaani haheso amina; ");
INSERT INTO bswl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kameellankko haasi kuwaarre; c'aafiti orro no arootabsse; Wononnati kakkaayya, hunnana kabajana Jiruu jiroomman kakkaayya; Hamiinɂi. ");
INSERT INTO bswl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Isin baas kaɂibaaddo haheso goɂantteen kadaruure Aabbokkisin ade isinuun haheso amirowa. ");
INSERT INTO bswl_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ayesuun goɂameen isin c'ubbo kaɂibaaddoo haheso kaɂamoon golleeten Aabbokkisinna c'ubbokkisin haheso lakkoɂamiro.» ");
INSERT INTO bswl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Ebi kaɂagaabuuyi ifissaaddolee ibaaddo aani aroohinggigiddeen; isona ebi kaɂagaabuuyi goggoɂaddeesamirowun ameengureen bebbeedtisooyi gutii gaddakokki maalaata tusataraan. Ani rumminaa amara, hikkamalee ollaaran muraattisoo dubba atateeran. ");
INSERT INTO bswl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ati goɂameen kakkoɂagabuuyite goorata; bebbeedttaa aali, metekkaanna shigida. ");
INSERT INTO bswl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Hikkaniinna agabuwanokkaa gollataa kagiro Aabbokkaa kaalaalya kakkasa, ibaaddokko goɂameen kagolate laara; gollataa kafelamero kadiyaara Aabbokka muraattaa kuun murrowa.» ");
INSERT INTO bswl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«K'ook'anna kaɂaamaron; marc'c'o taɂududootte aani kabaaron; hetona oshi hetin kadanddeeto, hikka ulii gutii isi oottisinuun durumma arookukkuyisatteen. ");
INSERT INTO bswl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ayesuun goɂameen k'ook'anna kaɂaamoon, marc'c'o taɂududootte aani kabbaannon, hetonna oshi hetin kadanddeenon, ele daruurii isi oottisinuun durumma kukkuɂisayeen. ");
INSERT INTO bswl_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Durummatta mankkogittoo wodanattana esee gitta.» ");
INSERT INTO bswl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Iilɂo maarun ifayyaan; haanssun Iilɂo fayyaaleessa golleen maarkka dubbana ifaayi kaɂammagame laara. ");
INSERT INTO bswl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Iilɂo ootta ohawɂaaran golleen ade maarkka dubbana mugud laara. Goorttanun ku orroo kagira ifa mugud gollee; mugud ade misimisii t'illinggakki mugud laara!» ");
INSERT INTO bswl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Ibaaddoti koo Goottaa lamaan handdayin lakkodaanddaaro, koo diidegure kakkalee geelaatara, goorttun koo kabajjeegure kakkalee tuffatara, Waawunna maragadeen raattoo handdayin lakkodaanddaamaro. ");
INSERT INTO bswl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Haanssun ani isinne haa amara; barsano oottisin maraan me aaminna? Me t'aminna? Me sarssayinanna? Amaa arooc'annak'antteen; neefo babokko, maar ade sarssikko lakkorooraroyya? ");
INSERT INTO bswl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Alla kimbir diyaa; lakkowut'atanaan, lakkokukkuyisataraan, gootarayinna lakkokibataraan, ayesuun goɂameen kadaruure Aabbokkisinna iso aamisara. Isin isokko aaloo lakkoroorattaanya? ");
INSERT INTO bswl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Golleenna isin orrokko c'annak'amegure geeskeessa gutii arri too adin kadaanddaara giro? ");
INSERT INTO bswl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«Adena sarssi maraan muun c'annak'aamattan? Alla tadiida daraara misimisii jiinatto diyaa; lakkodaafuranan, goorttun lakkosuk'k'aataran; ");
INSERT INTO bswl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ayesuun goɂameen ani isinne haa amara; hasse gitatti kabajja kaɂabanaaye wono Solomooni golleenna hitta daraaralkko too aani lakkosarssatero. ");
INSERT INTO bswl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Isin ammano okkoonhank'atera Waa hittaari mutegure geebbari eleen orro kashafamaro ees kadiida hikkamalee gosarssisiro isin ade misii roorisi sarssisana waatara? ");
INSERT INTO bswl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Haanssun ‹Me aaminna?› ‹Me t'aminna?› ‹Me sarssanna?› ami arooc'annak'antteen. ");
INSERT INTO bswl_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ayizaab hikka ayees dubba helayin c'annak'aamara; kadaruure Aabbokkisinna hikki dubba isinuun kadootisaro laano kasowa. ");
INSERT INTO bswl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kameen dubbakko t'aa wononnati kawaanna k'ullummateessa dootayeen; kahese dubbana gachchoo adamira. ");
INSERT INTO bswl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Haanssun geebbartun arooc'annak'antten; geebbartun c'annak'aamano geebbaritun habbaroo; arri metemeteeyi tattisee talleete rakkoo abtta.» ");
INSERT INTO bswl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Isini gutii goggofirddaamonkko maayyo gutiinna aroofirdditeen, ");
INSERT INTO bswl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Isin goggofirddaattaankki malee firddaaminara; kakkoɂekkaasattaan huuyi isinuun ekkaasaminara. ");
INSERT INTO bswl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","«Ilttaayi orroo kagiro gaa hadiyaannoni abbikkaa kotti il orroo kagiro huura muun diyaatta? ");
INSERT INTO bswl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ilttaayi gaa giraan abbikkaakotti il orroo kagiro huura kuun ani beesiro amin misii daanddaatta? ");
INSERT INTO bswl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ati ifissaaddaa t'ayi ilttaayi orroo kagiro gaa beesa, esekko abbikkaakotti ilii orroo kagiro huura beesin madaari din daanddaatta. ");
INSERT INTO bswl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Luk'k'a oottisooyi goggodaddaronkko abbaabayi ilkkoo abayi goggotatarshinnonkko kasommaasame kooko keroorun aroossisseen; awɂallokki kooko booyyee horee arooluguddeen.» ");
INSERT INTO bswl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Ebaayen sisamirowa, dootayeen helattaanwa, babbasayen ufana banamirowa; ");
INSERT INTO bswl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kaɂebaatara dubba atatara, kadootatarana helatara, kababbasataroonna ufa banamirowa. ");
INSERT INTO bswl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","«Isin orrokko erekkeessa babo goɂebaate eɂemo kasisira odo giro? ");
INSERT INTO bswl_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Goorttun kunɂub goɂebaate habeessa kasisara giro? ");
INSERT INTO bswl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Hayya isin omeellan leeteen giraan yiis kakkisinuun kaɂidan kooko sisano gomalabtteen kadaruure Aabbokkisin isin kaɂebaatattaan kooko kaɂidan misii roorisi isinuun sisanawaatara? ");
INSERT INTO bswl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kakkalee ibaaddo isinuun goggofelloon kadootattaan kooko isinna fela; seerana kahegeroolkokki agaalssisi hikkawaya.» ");
INSERT INTO bswl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Gooc'a kaɂuubaankkine taba; baas tos kageesara raa kanjiinkkinna gooc'ana kabalɂaanya, usuu otaberaanna omoogganyaan. ");
INSERT INTO bswl_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Giri kaneefoo tos kageesara raa goɂameen kac'imiinkki gooc'ana kaɂuubaanya; otabaraanna uc'c'arri olaalyaan.» ");
INSERT INTO bswl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«C'ala taɂidaad sarssate kaɂemeetaro orroɂootiso goɂameen hiyyeeyi aani basi aatin kaɂemeetaro kat'araa kahegeroolkko isi oorayeen. ");
INSERT INTO bswl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Felo oottisokko iso addeesin daanddaattan. Illanjjikko woyinii, k'iinc'c'okko bellesi taɂamamatto il abaabanan? ");
INSERT INTO bswl_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Usumaleenna gaa kaɂidan dubba il taɂidan, gaa kameellan ade il tameellan dubamara. ");
INSERT INTO bswl_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Gaa kaɂidan il tameellan, gaa kameellanna il taɂidan dubamin lakkodaanddaaro. ");
INSERT INTO bswl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Il taɂidan kadubamoon gaa dubbana goosamara, eleen orroddeenna shafamara. ");
INSERT INTO bswl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Haanssun kat'araa kahegerool felo oottisooyi addeesinattaan. ");
INSERT INTO bswl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Daruurii kagiro Aabbokkee kotti feɂi anfeloon giraan ‹Gootta, Goottaa› In kaɂamara dubba wononnati kadaruure lakkotabaro. ");
INSERT INTO bswl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kagachchoo firddakotti arrii omooggan ‹Gootta, Goottaa, megekkaayi hegero la ayeenssella?› Megekkaayi durrisa labbeenssella? Megekkaayi kamooggan baasa noo lafelnnella? Aminaraan. ");
INSERT INTO bswl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Hassu goorata ‹Ani duuddo isin laakkaso, isin tameellan ofelattaan inkko fakki ama› ami addeesisi seginara. ");
INSERT INTO bswl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Goorttanun hikka haafurakkee maalegure feloo kahayisara dubba; min eɂemo gutii kamadaaratero k'arookki ibaaddoti aani laara. ");
INSERT INTO bswl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Idaamo kaɂatiina ubate, daadnna dage, ambbalnna keetegudde usu min shafitte, eɂemo gutii mankko madaaramero maraantinu lakkoɂiyyero. ");
INSERT INTO bswl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Hikka haafurakkee maalegure feloo kahayisoon ade; c'eekalee gutii min kamadaaratero gowwakki ibbaaddoti aani laara. ");
INSERT INTO bswl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Idaamo kaɂatiinna ubate, daadnna dage, ambbalnna keetegudde usu min shafitte, minna iyye, iyaanona gomeellan lee.» ");
INSERT INTO bswl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesuusa hikka ayees ayeese kakkogudisare goorata gosana agaalssiskeessaa saade. ");
INSERT INTO bswl_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Aalanttina Ayihuudikokki seera kaɂagaalssisaro aani halleennoni giraan odonnati kaɂabo aani agaalssisaa mankkogire maraanya. ");
INSERT INTO bswl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesuusa wodamikko kakkodagare goorata gosa kamooggan usuu debee sesseete. ");
INSERT INTO bswl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Hassu goorata maarii bar kaɂabanaaye ibaaddoti koo Yesuusa tos emeetegure horee gilbbise sagadaa, «Goottaa! Feɂitaa golleete in muc'c'isin daanddaatta» ame. ");
INSERT INTO bswl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesuusana genetteessa diriirssategure dinddinaa, «Ani kuun feɂi sisera! Muc'c'imi!» ame. Ibaaddotina goorsewa barkko muc'c'ime. ");
INSERT INTO bswl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Esekkona Yesuusa, «Fayyaanokkaa maayyonna aroosegite; ayesuun goɂameen seegudde isiɂoottaa tuuk'aamon tusa, Muse kuun kaɂajajeero meebaa sisi hikkina isoon ato leera» ame. ");
INSERT INTO bswl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesuusa K'ifirenaahoomi tos goggotabee, kabooloo woyichchati kalleere koo usu tos gabbalamere; haa ame ebaate. ");
INSERT INTO bswl_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Goottaa, iin kahandaarekki naafaleessa leegure aaloo abboosa diyaa minkkeeyi huddure gira» ame. ");
INSERT INTO bswl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesuusana, «Ani emeeyigure usu fayyisinnara» ame. ");
INSERT INTO bswl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kabooloo woyichchatina abbaabere, «Goottaa, ati minkkee tos tabin ani lakkokadootisaroyyo; ayesuun goɂameen hittanii giraan haafura koo kaalaal ayeesina; iyyeen kahandaarekkina fayyirowa. ");
INSERT INTO bswl_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ani metekkeewun kakkaleetun kahandaaro woyichchaya, aninna inkko hegelle iyyeen ohandaaran aba; isokko koonne see ani goɂamiro seetara, kakkaleenna koyya goɂamiro emeetara, iin kahandaarone hikka feli goɂamiro felara.» ");
INSERT INTO bswl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesuusana abbaabkeessaa saadegure, debee sesseetaa ogireenne haa ame, «Ani rumminaa amara, ul kaɂisiraɂeel orrokko hikka aankikki ammano kaɂabo ibaaddo koonna ani lakkohelero. ");
INSERT INTO bswl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Omoogganna mina tabiyaankkona mina taɂiyaankko emeeyinnaran wononnati kadaruureyi babo aamin Abraamene, Yissaak'ane, Yayik'oobanee raattoo hamas'innaraan. ");
INSERT INTO bswl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Wononnati kadaruure ekkaate okkongire ade sarddi t'illinggakki mugud tos shafaminnaran, esee isoon oottanna ilkko fooc'ano leera.» ");
INSERT INTO bswl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesuusana kabooloo woyichchatine, «See ammanokkaa malee kuun halleewo» ame. Kahandaarekkeessana goorsewa fayyee. ");
INSERT INTO bswl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesuusa minkka P'et'iroosa tos kakkotabare goorata soddo tap'et'iroosa maar gube hawɂaamaa tahuddurttetto dee. ");
INSERT INTO bswl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Usuna genettisee kakkodinddinare goorata, maar kagubarena gafare; keetegudde usuun handdayite. ");
INSERT INTO bswl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Hemeen laa kakkoseetare goorata durrisaa kaɂabamero kamooggan ibaaddo Yesuusa tos keenen, usuna battiikki ayyaanajjol haafurakeessaa beese; dhukkubaleessaal dubbana fayyiise. ");
INSERT INTO bswl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Hikkaniinna kahegeroo Isiyaasa haa ame oɂayyeesere hegero, «Usu maar orrookki dhukkubakaani atate haranokaanina sidate» oɂamameeren hegero feloo hayeen. ");
INSERT INTO bswl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesuusa, kamooggan ibaaddo usu maraamure kukku kaɂamero kakkodiyaare goorata bekekko gama goggonak'inawun ajajee. ");
INSERT INTO bswl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hassu goorata seera kamuse kaɂagaalssisara usu tos emeetegure; «Kaɂagaalssisatto! Ati mankko siyaatto dubba ani ku debee sesseeyinara» ame. ");
INSERT INTO bswl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesuusana, «Geedalajjool gumbbi aba, kabuubara kimbbirna min aba, ere kaɂibaaddo ade isiɂoottessa takkofoolssisaro banɂe lakkoɂabo» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yesuusakko kaɂagaalsataro kalleera kakkalee ibaaddoti koo ade, «Goottaa! T'ayi seeyire ani Aabbokkee goggok'amalaron iin feɂi sisi» ame. ");
INSERT INTO bswl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesuusa ade, ogoyinaraan reeskkisoo hak'amaleen; «Ati goɂameen iin debee sessee» ame. ");
INSERT INTO bswl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Esekko Yesuusa wolabo orro tabe, usukko oɂagaalssatareenna usuu debee tabeen seeten. ");
INSERT INTO bswl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Derɂa kaɂatii irggado keegure gaashimallo wolabo taa lichisiroo shalagaame, hassu goorata Yesuusa ade huddure gire. ");
INSERT INTO bswl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Usukko oɂagaalssatareenna gabbalameen usu nabbaadisen gureen, «Goottaa! Baannewa, no haasi» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesuusana, «Isin ammano okkoonhank'atera! Muun hikkamalee abssaattaan?» ame. Esekko keegure irggadona gaashimallo hadise, goorsewa beke k'ooden. ");
INSERT INTO bswl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ibaaddona, «Hikki irggadona gaashimallona kakkoon ajajaamaraan misikki ibaaddotiyya?» amaa saaden. ");
INSERT INTO bswl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesuusa bekekko gama nak'egure, Gerggesino kaɂamaraan ul goggogeeyi battiikki ayyaanayi oɂabameeren ibaaddojja lama takkogireen banɂe tahiyyeelkko beengureen usune wota eseleen; ibaaddona usu raanne roorin taawaaroo giin aaloo omeellanyen. ");
INSERT INTO bswl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Isona, «Ati ere kawaa! Noonne wota haajaa tammee abtta? Goorata haggeennoni giraan no abboosisin emeette?» ameen okkeen. ");
INSERT INTO bswl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Isokko abaraan fakkintte tamooggan booyyee bobbayite gitte. ");
INSERT INTO bswl_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Durrisana Yesuusane; «No kabeesinatto golleete tamooggan booyyee orroddi goggotabnno no gafarina» ameen ebaaten. ");
INSERT INTO bswl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesuusana «Seyeen!» ame. Durrisana ibaaddojjakko beegure booyyee orroddee tabe, booyyeel dubbana laga k'ark'arakko hegelddeete ganggalatte beke orroddeete ubattedde ennegantte goote. ");
INSERT INTO bswl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Booyyeel ofoofareenna bak'ateen katamaa tos seeteengureen kalleero ayeenssa durrisaayi abameen ogireen ibaaddojjaa gutii kafelamero ayees dubba sessegeen. ");
INSERT INTO bswl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Hikka garaayinna kakkatamaa ibaaddo dubba Yesuusane wota eselin bee, usu kakkodiyaaren goorata ulkkisoo gafar goggobeeron ebaaten. ");
INSERT INTO bswl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Esekko abbaabatere Yesuusa wolabooyi tabe bekekko gama nak'e katamaatteessa tos emeete. ");
INSERT INTO bswl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Esekko ibaaddo naafaleessati koo alggaayi sideengureen usu tos aateen emeteen. Yesuusana ammanokkisoo deegure naafaleessatine «Ko allamandde! C'ubbokka haheso amamera» ame. ");
INSERT INTO bswl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Hassu goorata seera kamuse kaɂagaalssisara, «Hikki Waa habaaranoyya» amaa wodanattisooyi gumggumeen. ");
INSERT INTO bswl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesuusa k'ofattisoo addeesegure haa ame; «Kameellan ayees wodanattisinii muun k'oppaattan? ");
INSERT INTO bswl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Afo, ‹C'ubbokka haheso amamera amanokkona› ‹Kingudde sessee amanokko eekiya ene kallaara›? ");
INSERT INTO bswl_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ayesuun goɂameen ere kaɂibaaddo ul gutii c'ubbo haheso kakkoɂamiro odonnati kaɂabo laano goggoɂaddeessanunya» amegure; naafaleessatine «Ki alggaattaa sidadde min gali» ame. ");
INSERT INTO bswl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Naafaleesaatina keegure minkkeessa gale. ");
INSERT INTO bswl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Gosana hikka kakkodiyaare goorata saade, abssiinna ammagameengureen hikka aankkikki odonnati ibaaddon kasisero Waa galateen. ");
INSERT INTO bswl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesuusa esekko keegure seetaa giraan Matoosa kaɂamamare ibaaddoti koo k'arat'a takkomuraneen banɂee kahamas'eero deegure «In debee sessee» ame; usuna keegure Yesuusa debee sesseete. ");
INSERT INTO bswl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesuusa min kamatoosaa aamo gutii giraan omooggan k'arat'a okukkuyisareenna c'ubbaaleeyil emetengureen usune wotana usukko oɂagaalssataranne wota babo aamin hamas's'een. ");
INSERT INTO bswl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kafarasaawi ibaaddona hikka kakkodiyaaren goorata Yesuusakko oɂagaalssatareenne, «Isin kaɂagaalssisara k'arat'a okukkuyisaraanena c'ubbaaleyilnne wota misii aamara?» ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesuusana iso kaɂayeesaran maalegure haa ame, akimii kakkondootisara dhukkubaleessalunya kuwaarre fayyaaleessan lakkoyo. ");
INSERT INTO bswl_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Seeyenguddeen, «Ani jaarsokko roorise shaaga geelaatara kaɂamamero haafurakokki fureen agaalssayen. Ani kakkoonɂemeeyera c'ubbaalesalun kuwaarre k'ulluukki uumn lakkoɂemeeyero» amame mas'aafaa k'ulluukki mankkos'aafamero maraanya ame. ");
INSERT INTO bswl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Hassu goorata kat'ammak'aaro Yaannisakko oɂagaalssataran Yesuusa tos emetengureen «Noonna Farasaawiilnna arggetto goɂagabuyinno kukko oɂagaalssataran adeen muun agabuwana waataraan?» ameen Yesuusa hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesuusana, «Kamashaashee isone wota giraan haassinoon taɂemettetta martti misii gaddin daanddaatta? Kamashaashee isokko kakkoɂataminara goorata emeetara; hassu goorata agabuyinaraan ame. ");
INSERT INTO bswl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Sarssi kaddoɂan gutii taɂusubtti erbbe kakkaatara ibaaddo lakkogiro, kakkaate gollee adi taɂusubtti erbbe kaddoɂan sarssi guukko tattarshitegudde butto ittuu balɂatara. ");
INSERT INTO bswl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kaddoɂan dinbbitoo kaɂusub t'amo kawoyinii maayyona lakkokibataro, gokkibate ade dinbbito ebara, t'amo kawoyiniinna ubatara, dinbbitona laɂo lakkoɂabo, ayesuun goɂameen kaɂusub t'amo kawoyinii kaɂusub dinbbitoo yelamara, hikka garaayi t'amo kawoyiniinna dinbbitona goɂidan isiɂoore adallaatara.» ");
INSERT INTO bswl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesuusa ibaaddo ayeesisaa giraan, Ayihuudikokki woyichchati koo usu horee gilbbisegure, «Unnutti gidda gootetta neefone goggohessoo emeedde genettaa esee gutii kayi» ame. ");
INSERT INTO bswl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesuusana keegure woyichchatine wota seete, Yesuusakko oɂagaalssatareenna usu debee keen. ");
INSERT INTO bswl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Esekko gees tomonkko lama dubba iigi ubataa abboosa diyaa tagitte heleelttiti too haarre emeettegudde sarssikkeessa dintte. ");
INSERT INTO bswl_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Esena wodanattiseeyi, «Sarssikkeessa godine suure fayyinnara» amaa gitte. ");
INSERT INTO bswl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesuusana haar abbaabate heleelttiti deegure, «Allamandde unnutti! Ammanokka ku fayyiisera» ame. Heleelttitina goorsewa fayyiite. ");
INSERT INTO bswl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesuusana min woyichchati tos goggogeeyi malakata ufuufaa, ootaanna oyisaa kagire gosa deegure, ");
INSERT INTO bswl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","«Dubbana hittakko biyaa! Unnu huddurttetta kuwaarre lakkogootetto» ame. Iso goɂameen k'ac'c'ifataa osoleen. ");
INSERT INTO bswl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ibaaddo min orrokko kakkobiyaare goorata min orroddee tabegure genettisee abe, unnuna keete. ");
INSERT INTO bswl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Oduna usu ul dubbaa darɂaantte. ");
INSERT INTO bswl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesuusana esekko bee seetaa giraan iilɂo kadiyaannon ibaaddo lama, «Ere kadaawute! Maari» amaa iyyaa usuu debee sesseeteen. ");
INSERT INTO bswl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Iilɂo odiyaannonna Yesuusa katabero min tos debee tabeen; Yesuusana, «Ani iilɂoɂoottisin denddeesin kadaanddaaro laano ammanattaan?» ame iso hoosate. Isona «Iɂii Goottaa» ameen abbaabeen. ");
INSERT INTO bswl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Esekkona Yesuusa iilɂoɂoottisoo dinddinegure, «Ammanokkisinkki malee halleewo» ame. ");
INSERT INTO bswl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Iilɂoɂoottisona deenddeen; Yesuusana, «Hikka maayyona arooɂaddeeso» ame ataayise segee. ");
INSERT INTO bswl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Iso goɂameen esekko beengureen usu ulii kagiro ibaaddo dubbaan gara kayesuusa ayeeseen. ");
INSERT INTO bswl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Iilɂo okkonbanameeran ibaaddojja esekko biyaa giraan battiikki ayyaanaa kaɂabamere hiɂii kaɂayeeson ibaaddoti koo Yesuusa tos keenen. ");
INSERT INTO bswl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Battiikki ayyaanana kakkobiyaare goorata hiɂi kaɂayeeson ayeesano haggaɂabe; gosana saadegure, «Hikka aankkikki ayees ul kaɂisiraɂeel mute laakkaso» ame. ");
INSERT INTO bswl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kafarasaawil ibaaddo ade, «Usu durrisa kakkobeesara kaddurrisa woyichchaayiya» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesuusa kaɂayihuudi min kaɂebi agaalssisaa giraan, wononnati kawaakokki geggeloo lallabaa giraan, adena maar orrookki dhukkubaa kahawɂamaro dubba fayyiisaa, katamaaliinna maamanjoolii maraamure. ");
INSERT INTO bswl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Gosana kafoofiro kawaate idaad aani yaadaanna kaddeero kaliikki leen ogiraan kakkodiyaare goorata nenɂeyisate. ");
INSERT INTO bswl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yesuusana usukko oɂagaalssataranne haa ame, «Kakukkuɂaminara kaami kamoogganya, ofelinnaraan goɂameen uc'c'arriyaan, ");
INSERT INTO bswl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Haanssun kakukkuminnaro kaamikokki Goottaa ofelaraan kakukkuɂamaro kaami tos goggofarroon ebaayen» ame. ");
INSERT INTO bswl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesuusa usukko oɂagaalssataran isi tos uumegure battiikki ayyaanajjol goggobeesinawunna maar orrookki dhukkubana hawɂaami dubba goggofayyisinawun isoon odonnati sise. ");
INSERT INTO bswl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tomonkko lama ofarameeraankonɂi megekkiso hikkaya; isona P'et'iroosa kaɂamamero Simoonana abbikkeessa Indiraasa, yiis kazabddoosa Yayik'oobana abbikkeessa Yaannisa, ");
INSERT INTO bswl_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filp'oosana Berttelomeewosa, Toomaasana k'arat'a kakukkuyisare Matoosa, yiis kaɂilfoosa, Yayik'oobana Tadiyoosa kaɂamamaro Libdiyoosa, ");
INSERT INTO bswl_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ulkkeessan kawudittaamaro Simoona, haarre Yesuusa roorise kasisero kaɂask'orotu Yihuuda. ");
INSERT INTO bswl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesuusa hinɂa ofarameeraan tomonkko lama haa kaɂamaro handdaane wota iso fare, «Ayizaab tos arooseetteen; maaɂeeti tasamaarya katamaa tonssa arootabtteen; ");
INSERT INTO bswl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Seeto gohesoon idaad aani min kaɂisiraɂeelkko kabbayero gosa tos seeyen. ");
INSERT INTO bswl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Seeyenguddeen ‹Wononnati kadaruure gabbalamera› ama lallabaa. ");
INSERT INTO bswl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Dhukkubaaleessalnna fayyiisa, kagoyero ibaaddona keesa, maarii bar kaɂabona barkko muc'c'isa, durrisana beesa, adda kaɂatatteettaanna adda sisa. ");
INSERT INTO bswl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kiisiitisini work'k'ii leere bir taɂamamatto marc'c'okko goorttun medaabkko kafelamero maragade arooɂabatteen. ");
INSERT INTO bswl_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Raakkisinunna shile, k'olo lama, goorttun keferroo goorttun dama arooɂabatteen; aalanttina kafelaroon babo sisamin dootisara. ");
INSERT INTO bswl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Katamaa goorttun maaman koo tos gotabtteen isin k'op'ayin feɂi kaɂabo ibaaddoti dootaguddeen usu minii foolssayeen; taabeetaani esee adallaayen. ");
INSERT INTO bswl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Min kamaakkayyona gotabtteen nogodda aata. ");
INSERT INTO bswl_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Isin kak'op'ataraan gollee, nogoddatisin usu min halleeto, isin kak'op'annon gollee adi, nogoddatisin isinuun haɂabbaabatto. ");
INSERT INTO bswl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Maamisikki ibaaddotina isin k'op'atana gowaate goorttun isin kaɂayeesattaan maalana gowaate hassu minkko goorttun hasse katamaakko biyaa giraan isoon seerisano goggolleeroon luk'k'aɂoottisinkko gorra hurgufayenddeen biyaa. ");
INSERT INTO bswl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ani rumminaa amara, tafirdda arri hasse katamaayi taginnatto murrookko Sodoomina Gomoraayi taginnatta murroo tafuffudaatte leeta.» ");
INSERT INTO bswl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Idaad aani hiyyeeyi orroo ani isin farnnara, haanssun habeessa aani k'aroolee, arabe aani fayyankkanɂi laa.» ");
INSERT INTO bswl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","«Ibaaddona isin abigure firddaawun shonggoo tos geesinnaran; Ayihuudikokki min kaɂebinna isin boc'c'innaraan, haanssun isokko isiɂoorayeen. ");
INSERT INTO bswl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Aalantti teeyi mootijjol tonssa wonolaal tos firddaan isin geesinaran; iso horeenna Ayizaab horee iin ato linnattan. ");
INSERT INTO bswl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Firddaan shonggoo tos isin kakkogeeseen goorata memi ayeenssa? Me ami abbaabinna? Ami arooyyaddeen, hassu goorata taɂami ayeessaan isinuun sisanttowa. ");
INSERT INTO bswl_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Isinii kaɂayeesinnara kadaruure Aabbokkisinkki Ayyaana kawaayya kuwaarre lakkoɂisinttaan.» ");
INSERT INTO bswl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Abbi abbikkeessa goyin roorisi sisinnara, odona erekkeessa, yiinssa iso oɂumuleeraan gutii kiinnaraan, lagadisinnaraan. ");
INSERT INTO bswl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Aalantti teeyi ibaaddo dubba isin diidinara; ayesuun goɂameen taagachcho geeroo kaɂataate usu fayyinara. ");
INSERT INTO bswl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Banɂe tookko gohorooreen banɂe takkalee tos bak'ayeen; ani rumminaa amara, isin taɂisiraɂeeli katamaali feloɂoottisin feli angussannon giraan ere kaɂibaaddo emeeyinara.» ");
INSERT INTO bswl_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Kaɂagaalssatara, kaɂagaalssisarokko kahandaara goottakkeessakko lakkorooraro. ");
INSERT INTO bswl_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kaɂagaalsatara kaɂagaalssisaro aani, kahandaarana goottaakkeessa aani gollee leera. Odomineekkisoo ‹Biɂeelzebuli› ami goɂuume, kaminee ibaaddo hikkakko karoore kameellan megee misii uumin waataran?» ");
INSERT INTO bswl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Haanssun ibaaddo arooɂabssatteen, golate kagira diidaa habeenoni, siyame kagira hamutoni lakkohesiro. ");
INSERT INTO bswl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Haanssun ani isinuun mugudii kasegeero ifaayi ayeesa, nebettisinii kamaaltteettan diidaa beesa awwaajjaa. ");
INSERT INTO bswl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Soo lagadin kuwaarre neefo lagadin kadanddeennon ibaaddokko arooɂabssatteen; hassukko neefona soonna tabbaanon eleenii baasin kadaanddaaro Waa abssayeen. ");
INSERT INTO bswl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Dolchchii tooyi kadaddalamaro kimbir lamakko toonna kadaruure Aabbokkisinkkotti feɂi kallayi ulii ii lakkohesso. ");
INSERT INTO bswl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Metekkisinkki binaanakko duuddo koonna hahesooni dubba katootaameya. ");
INSERT INTO bswl_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Haanssun arooɂabssatteen, kamooggan kimbirjolkko muraattisin takabajaanttetta.» ");
INSERT INTO bswl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Ani kakiristoosayya ame garakkee ibaaddo horee kaɂatotaaron aninna daruurii kagiro Aabbokkee horee atotinara. ");
INSERT INTO bswl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ayesuun goɂameen ibaaddoyi horee in kakkakataroon aninna daruurii kagiro Aabbokkeeyi horee usu kakayinnara.» ");
INSERT INTO bswl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Ani kakkoonɂemeeyera uluun nogodda keenin lakkoyo; kalekalee beesin kuwarre nogodda keeniin kaɂemeeyero aani isinuun aroolleeno. ");
INSERT INTO bswl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ani kakkoonɂemeeyera, ere odokkeessakko, deeleeltiti Aayettiseekko, ooriɂerena soddotisekko iskko darɂiinya. ");
INSERT INTO bswl_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ibaaddoon diina kallaara kakkeessa kaminee ibaaddowayya.» ");
INSERT INTO bswl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Inkko roorise Aabokkeessa goorttun Aayetteessa kageelaatara kakkee liin lakkodootisaro, inkko roorise babbaartiti goorttun deeleeltiti kageelaatara kakkee liin lakkodootisaro. ");
INSERT INTO bswl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mask'alittessa sidayire taagooron iin debee kasessennon kakkee liin lakkodootisaro. ");
INSERT INTO bswl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Isiɂoottessa fayyiisayin kadootatara baasatara, Isiɂootteessa in maraan roorissayi sisayin kadootatara ade fayyisatara. ");
INSERT INTO bswl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Isin kaɂatatara in atatara, inna kaɂatatara ade in kafarero odo atatara. ");
INSERT INTO bswl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kahegeroonna kahegerookokki megeeyi kaɂatatara kahegerookotti muraa helatara, k'ulluukkina k'ullummakkokki megee kak'op'atara k'ullummakkotti muraa helatara. ");
INSERT INTO bswl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Haanssun ani rumminaa amara; maamisikki ibaaddona hinɂa otitiic'c'arkko koo inkko kaɂagaalssataron k'uldubbo too beke ambbalnɂi kasise usu muraa lakkowaaro.» ");
INSERT INTO bswl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesuusa usukko oɂagaalssataran tomonkko lamaan ajaja sise abbaabatere, agaalssisinna lallabin katamaalttisoo tos seete. ");
INSERT INTO bswl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kat'ammak'aare Yaannisa min kashaanoo giraan Kiristoosa felaa ogiro felo kakkomaalare goorata usukko oɂagaalssataran usu tos faregure, ");
INSERT INTO bswl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«Emeetara amamatte kaɂooramatte Kiristoosa atitta? Muu kakkalee ooranna?» ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesuusana abbaabere; «Seeyenguddeen kamaalattanna kadiyaattan Yaannisaan segaa. ");
INSERT INTO bswl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Iilɂo odiyaannonna dinnaraan, naafaleessalnna sesseeyinnara, maarii bar oɂabaanna muc'c'iɂaminaran, nebee omaaloonna maalinnaraan, ogoyeraanna kinnaraan, hiyyeessalunna kageggeloo wongala lallabaaminara; ");
INSERT INTO bswl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","In kahedannon kasommaasameya» ame. ");
INSERT INTO bswl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yaannisakko oɂagaalssataran seeten kakkobuwareen goorata; Yesuusa gara kayaannisa gosaan haa ame ayeese, k'alullattokki ul tos me din beeten? Ambbal kaɂaaɂisatto fiik'e diinyya? ");
INSERT INTO bswl_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Hayya me din beeten? Sarssi kaɂiidaro kasarsatero ibaaddoyya? Sarssi kaɂidan sarssateen oɂiidaraan min kawonolaali giraanwa. ");
INSERT INTO bswl_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Hayya me din beeten? Kahegeroo diinyya? Ii duuddowa kahegerookkona karooreya. ");
INSERT INTO bswl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Haa amame mas'aafaa k'ulluukkii kakkoons'aafamera usuya, ‹Raakkaa goggoɂekkaasiroon erggichcha kukko horene farnnara.› ");
INSERT INTO bswl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","«Ani rumminaa amara heleelkko kaɂalatero orrokko kat'ammak'aaro Yaannisa aankkikki lakkogiro. Ayesuun goɂame wononnati kadaruureyi dubbaankko kayeraatara usu jiinaatara. ");
INSERT INTO bswl_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yaannisa kakkot'ammak'are geeskko haggaɂabere hittaari taageeroo wononnati kadaruure kamooggani diidaminara, aaloo ataateen odootataraan helayinaraan, ");
INSERT INTO bswl_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Agaalssisi kahegerool dubbana seera kamuse taa kat'ammak'aare Yaannisa geeranii hegeroo ayeeseran. ");
INSERT INTO bswl_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Goortta iso kaɂayeesenan atayin godootatteen usuna emeeyinara kaɂamamere Eelaasa hikka Yaannisaya. ");
INSERT INTO bswl_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nebe kaɂaba hamaalo! ");
INSERT INTO bswl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Hitta alattaan menne wota herreegisira? Giyaayi hamas's'eengureen haa amaa isi isi kaɂuumataro yiis aani laaran.» ");
INSERT INTO bswl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","« ‹Sussullee ufuufinne lakkoduddurttettaan, boochcho bochchinnewa lakkoɂootteen› ");
INSERT INTO bswl_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yaannisa aamokkona t'amokko isiɂoorate mankkoɂemeete maraan ‹Usu battiikki ayyaanajjol aba!› ameen. ");
INSERT INTO bswl_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ere kaɂibaaddo aamaanna t'amaa emeete, isona usu ‹Kaɂaamarona kat'amaroya! Usumalee, k'arat'a okukkuyisaraanna «C'ubbaaleyijjool» › kageelaataroyya ameen. K'arumma goɂameen feloɂoottiseeyi addeesante.» ");
INSERT INTO bswl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Esekkona Yesuusa kamooggan baasa takkofelero katamaal c'ubbokko mankko gula galanawaaten maraan haa ame wok'asee, ");
INSERT INTO bswl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Aanne Koraazi! Aanne Beetesayida! Isinii kafelamera baasa T'iroosiinna Sidoonayi kafelamero lii girewa, horkkowa sarssi gambballakki sarssayi buluulo maarii kikibayi c'ubbokko gula gali girareenwa. ");
INSERT INTO bswl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Haanssun ani isinne haa amara, tafirdda arri isinkko roori T'iroosiwunna Sidoonawun murro suure fuffudaayinaraan. ");
INSERT INTO bswl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ati K'ifirenaahoomi daruur tos t'ok'k'i t'ok'k'i amiin dootatte? Ayesuun goɂameen bowwa orroddi innatta! Kuyee kafelamera baasa Sodomiinna felami girewa hittaari gin ese katamaa girattewa. ");
INSERT INTO bswl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Haanssun ani rumminaa kuun haa amara, tafirdda arri taginnatta murroo tattaakko roori Sodoomiin fuffudaayinnatta!» ");
INSERT INTO bswl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Hassu goorata Yesuusa, «Kadaruurenna kaɂulee Goottaa Aabbo! Hikka k'arooleelkona okasaankko goliisedde yiisun mankkotusse maraan ani ku galataara, ame. ");
INSERT INTO bswl_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ii Aabbokki! Hikki ku horee feɂi taɂidan leete kuun mutte. ");
INSERT INTO bswl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Aabbokki kameen dubba iin sisera, odokko kakkalee ere kakkasa maayyona lakkogiro. Usumaleenna erekko kakkalee odo kamalabira lakkogiro, ere ogeelaateron gotuse kuwaarre odo addeesin kadaanddaara maayyona laagiro. ");
INSERT INTO bswl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Isin sidane kakkoonɂisilaattetta! Ohartteettan dubba in tos koyeen! Aninna foolssi sisinara. ");
INSERT INTO bswl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Hark'k'ootakkeenna sidayeen, inkkona agaalssayeen, ani wodanatteeyi fayyankkana kaɂobssaroya, neefottisinunna foolssi helayinattaan. ");
INSERT INTO bswl_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Hark'k'ootakki kaɂisilaannoon sidanettina tafuffuditta.» ");
INSERT INTO bswl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Esekko abbaabatere Yesuusa tafoolssi arri wut'a orromare roore, usukko oɂagaalssataranna mankkoɂuɂeereen marantinuu shawuyeekko ebssateen aateen aamano haggaɂabeen. ");
INSERT INTO bswl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farasaawiilnna hikka deengureen; «Hikka dee! Kukko oɂagaalssataran tafoolssi arri felamiin odootison felo felaa giraan» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesuusana, «Daawutena usune wota kagire ibaaddo kakkoɂuɂeere goorata Daawute kayelero lakkonabbabteettanya? ");
INSERT INTO bswl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Min kawaa tabe, tuuk'aamolun kuwaarre usuumna leere wota ogireetun aamin feɂi kasisamoon giro kasommaasame babo aame. ");
INSERT INTO bswl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Adena tuuk'aamolun tafoolssi arri iggilisenguren k'ulluukki min kawaa orroo felo gofeleen c'ubbo laanawaatti seera kamuse lakkonabbabtteettanya? ");
INSERT INTO bswl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ayesuun goɂameen ani haa amara; k'ulluukki min kawaakko karoorara hittanii gira. ");
INSERT INTO bswl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ani ‹Jaarsokko suure shaaga geelaatara› kaɂamamaro haafura me amanoyyo oɂaddesattan leeteenwa k'ulluunɂi gutii lakkofirddaatteen. ");
INSERT INTO bswl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ere kaɂibaaddo tafoolssi arriwuun Goottayya.» ");
INSERT INTO bswl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesuusa ese banɂekko roore seetegure, Ayihuudikokki min kaɂebi tabe, ");
INSERT INTO bswl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Eseenna gene kakkonaafattette ibaaddoti koo gire; Yesuusa mootin dootengureen, «Ayihuudin tafoolssi arri ibaaddo fayyiisin feɂi sisanttetta?» ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesuusana, «Isin orrokko ibaaddoti kookkotti idaado Ayihuudin tafoolssi arri gumbbi orroddi goɂiite, idaado kakkoɂiitetto gumbbi orrokko natti isin lakkobeessanya? ");
INSERT INTO bswl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Hayya, ibaaddo idaadokko lakkorooraroya? Haanssun tafoolssi arri taɂidan felin feɂi sisanttetta» ame. ");
INSERT INTO bswl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Esekkona Yesuusa ibaaddotine, «Genettaa diriirssa» ame, ibaaddotina genetteessa diriirssate, aantti gene taɂidantti aani leete. ");
INSERT INTO bswl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farasaawiil goɂameen esekko beengureen Yesuusa misimisii lagadinaan malaɂoyeen. ");
INSERT INTO bswl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesuusa k'ofattisoo addeesere esekko fakki ame. Gosa kamoogganna usu debee sesseete, kahawɂamare dubba fayyiise. ");
INSERT INTO bswl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Isiɂoottessa maayyonna goggoseginonkko ataayise isoon segee; ");
INSERT INTO bswl_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Hikki kakkoonleera kahegeroo Isiyaasayi haa amameen oseegaameraan hegero feloo goggohayirawunya. ");
INSERT INTO bswl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Hikkima! Ani kaɂassaabayeerana ani kageelaatara usuya, usu ani kageelaatarona kakkogeggelaataroyya, ayyaanakkee usuu gutii kayinnara. usuna gosaan karrummii firdda awwaajinara. ");
INSERT INTO bswl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Usu lakkodogaminaro lakkonaɂokkinaro; raadiina yaayetteessa kamaalla lakkogiro. ");
INSERT INTO bswl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Karrummii firdda taaɂawoddon geegin; kac'anc'c'aname fiik'ena lakkoɂebisiro. Kaɂiiyyootaro kamuk'k'ade shalonna lakkobaasiro. ");
INSERT INTO bswl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ayizaabna megekkeessayi abddi yelarowa.» ");
INSERT INTO bswl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Esekko abbaabatere battiikki ayyaanayi abamanoyi iilɂoo diyaayinna hiɂi ayeesin kawaatero ibaaddoti koo Yesuusa tos aateen emeeten, Yesuusana usu fayyiise, ibaaddotina diinna ayeesin daanddee. ");
INSERT INTO bswl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Gosa dubba saadegure, «Hikki ibaaddoti ere kadaawute leewuna?» ame. ");
INSERT INTO bswl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ayesuun goɂameen Farasaawiil hikka kakkomaalare goorata «Hikki ibaaddoti durrisa kakkobeesara kaddurrisa woyichcha kalleero Biɂeelzebulikkokki hunnaayya» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesuusana k'ofattisoo addeesegure «Isiorroo kalekalee kabiyaara wononnati dubba iinnara. Isisiɂorroo kalekalee tabeete katamaa goorttun min ataayi girin lakkodaanddeero ame. ");
INSERT INTO bswl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","S'alayena s'alaye kabeesatto golleete; isisiɂorroo kalekalee beeran amanoyya; haa gollee ade wononnati misimisii ataayi aallin daanddaara? ");
INSERT INTO bswl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ani durrisa kakobeesara durrisakokki woyichchaa gollee; isin debee osessetaran ade meyii beesinnaran? Haanssun yiiskkisinwa isin gutii firddinara. ");
INSERT INTO bswl_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ani goɂameen durrisa kakkobeesara Ayyaana kawaayi gollee goortta wononnati kawaa isin tos emeetera amanoya. ");
INSERT INTO bswl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Goorttun ibaaddoti koo kaɂatii ibaaddotikokki min tabigure urrawoɂoottessa saamiin godoote, t'ayi hassu kaɂatii ibaaddoti anshiinnon giraan misii usuun ekkaatta? Usu shii goɂabbaabate urrawoɂoottessa saamiin daanddaara. ");
INSERT INTO bswl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","«Iinne wota kalleenoon dubba in kaneebaataroya, iinne wota kakukkuysannoon dubba darɂaatara. ");
INSERT INTO bswl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Haanssun ani haa amara, c'ubbo felanona ibaaddo habaarano dubba ibaaddon haheso amaminnara, ayesuun goɂameen Ayyaana K'ulluukki kahabaararoon ade c'ubbo haheso lakkoɂamamaro. ");
INSERT INTO bswl_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Maayyona ere kaɂibaaddo gutii ayees kameellan kaɂayeesaro dubbaan haheso amamara, Ayyaana K'ulluukki gutii ayees kameellan kaɂayeesaron ade hikka alamiinna leere kaɂemeetaro alamii c'ubbo suure haheso lakkoɂamamiro. ");
INSERT INTO bswl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Gaa dubba iltteessaa mankkoɂaddeesamaro maraan il taɂidan goggohelattaanun gaa kaɂidan isinuun hangire; gaa kameellan isinuun gogire ade il tameellan helayinattaan. ");
INSERT INTO bswl_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Isin yiis kahabeessa, isin omeellan golleetan kaɂidan ayees ayeesin misii daanddaattan? Ibaaddo wodanatteessaa orroo kaɂammagamero hiɂii ayeesara. ");
INSERT INTO bswl_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kaɂidankki ibaaddo wodanatteessayi kaɂamagamero kaɂidan ayeeskkeessakko taɂidan beesatara, kameellankki ibaaddona wodanatteessayi kaɂamagamero kameellan ayeeskko tameellan beesatara. ");
INSERT INTO bswl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ayesuun goɂameen ani haa amara; ibaaddo kaɂayeesaro kamaadinoon ayees dubba marantinuu tafirdda arri hoosaminara. ");
INSERT INTO bswl_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Aalanttina ayeeskkaakko kakkeeyi k'ulloyinnatta, ayeeskkaakko kakkeeyi ati firddaaminatta.» ");
INSERT INTO bswl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Esekkona seera kamuse oɂagaalssisaraankkona Farasaawilkko kookkoo Yesuusane, «Kaɂagaalssisatto! Noo kukko baasakki malaata diin dootanna» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Usu ade abbaabegure isone, «Tameellanna taɂammanoon alattaan malaata diin dootatta; ayesuun goɂameen kahegeroo kayoonasa malaata kuwaarre kakkalee malaata lakkosisaminaro. ");
INSERT INTO bswl_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yoonasa arri seendda hemeen seed kanjjiinkki kunɂubkokki bogi orroo goggoɂadallaateroyi, Ere kaɂibaaddo usumalee arri seendda hemeen seed erree orroo k'amalami adallayinnara. ");
INSERT INTO bswl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kanennewe ibaaddo tamurtti arri hitta alattaanne wota kiigureen usu gutii firddinara, kanennewe ibaaddo kayoonaasa lallabaano maaleengureen c'ubbokko ogula galeeran, gidda goɂameen Yoonasakko karoorara hittanii gira. ");
INSERT INTO bswl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tafirdda arri oori wono Saaba hitta alattaanne wota kiigudde usu gutii firddinatta, tasolomooni k'arumma maalin ulkotti gachchokko emeettetta, gidda goɂameen Solomoonikko karoorara hittanii gira» ame. ");
INSERT INTO bswl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Battiikki ayyaana ibaaddotikko kakkobiyaare goorata takkofoolssaro kallayi taɂangayidde banɂe beke dootataa kafafare, tadootatare foolssi ade lakkohelate. ");
INSERT INTO bswl_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Esekkona ‹Kakkogire min tos abbaabayi seewu› amara, abbaabayi kakkoseero goorata min halaal lee, shakaarame kamuc'c'imerona kaɂekkaatero helayinara. ");
INSERT INTO bswl_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Esekko seetegure usukko karoore kakkalee todoba battiikki ayyaanajjol kameellan atayire emeeyinara. Isona ibaaddoti orro tabigureen girnnaraan. Hassu ibaaddotiwunna giri kahoreekko giri kahaaree kameellan linnara. Hitta tameellan alattaan gutii hikkamalee linnara.» ");
INSERT INTO bswl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesuusa gosaan ayeesaa giraan; Aayetteessana abbilaaltteessa usune eselin dootengureen sarre aalleen gireen. ");
INSERT INTO bswl_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ibaaddoti koo Yesuusane, «Aayettanna abbilaaltta kuunne wota ayeesin dootengureen sarre aalleenan» ame. ");
INSERT INTO bswl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesuusana, «Aayetti ayyotta? Abbilaalttinna ayyoosyyaan?» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Genettessanna usukko oɂagaalssataran tos tusaa «Aayettina abbilaaltti hinɂayaan; ");
INSERT INTO bswl_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Daruurii kagiro Aabbokkeekkotti feɂi kafelara dubba, abbilaalttee abbalaaltteenna Aac'c'olaaltteenneyyaan.» ");
INSERT INTO bswl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ese arriiwa Yesuusa minkko beegure labu giridii hamas's'ee. ");
INSERT INTO bswl_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kamooggan gosana kukkuɂamanokko kakkeeyi usu mare mankkoɂabere maraan iso bagaa iisegure wolabooyi tabe hamas's'ee. ");
INSERT INTO bswl_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kamooggan ayeenssa masuussayi haa ame segeera, «Otate kabaraare ibaaddoti koo wut'a wut'ayin bee. ");
INSERT INTO bswl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wut'ataa giraanna wut'a gamisa raa giridii iyye, kimbirnna emeetegure abaabate aame. ");
INSERT INTO bswl_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Gamisa wut'a tafufudi shak'umooltti erree iyye, errena tafufudi mankkoleetette maraan wut'a saame alate. ");
INSERT INTO bswl_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ayesuun goɂameen ariti kakkobiyaatte goorata k'oore hidiid aaloo dagisanawattikko kakkeeyi angage. ");
INSERT INTO bswl_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Gamisa wut'ana eɂeen kaɂabo huura orroo iyye, eɂeeninna jiinaattegudde kaɂalatero wut'a marggisse orroo haasse. ");
INSERT INTO bswl_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kakkalee wut'a ade taɂidan erree gutii iyye, alategure il yelate, koo bool, koo lootam, koonna sonddom il sise. ");
INSERT INTO bswl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nebe kaɂaba hamaalo!» ");
INSERT INTO bswl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Esekko Yesuusakko oɂagaalssataranna usu tos gabbalameengureen, «Mewuun gosaan masuussa ayeesatta?» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesuusa abbaabere, «Isinuun wononnati kadaruurekkotti hool malabano sisamera, isoon goɂameen lakkosisamero. ");
INSERT INTO bswl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kakkogiroon adamara, mooggaatara, kallayikkikko goɂameen hassu kagirawa suure usukko atamara» ame. ");
INSERT INTO bswl_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Haanssun haa amaa ani masuussayi kakkoon segeera hikkanunya, diyaa giraan odeennon mankkolleen maraan, maalaa giraan omaaloon mankkoleen maraan, goorttun shaadana mankkowaateen maaranya. ");
INSERT INTO bswl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kahegeroo Isiyaasayi kasegaamera, «Maalano maalinnattan, ayesuun goɂameen lakkoshaadinnattan, Diyaanona dinnattaan, ayesuun goɂameen wodanaa lakkoɂabaattaan, haa amame kas'aafamera isoo gutii feloo hayinara; ");
INSERT INTO bswl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Hikka gosakotti wodanana duuddetta; nebetisona lakkomaalatto, goggodeenonkko iilɂoɂoottiso t'ip'imeeraan, haa lii waatewa iilɂoɂoottisooyi diigureen, nebetisooyi maaligureen, wodanattisooyinna shaadigureen, in tos abbaabatenwa ani iso fayyiisarewa.» ");
INSERT INTO bswl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Iilɂoɂoottisin mankkodiyaaran maraan, nebetisinna mankkomaalatto maraan ade osommaasantteettan. ");
INSERT INTO bswl_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ani rumminaa amara, ohegeroolnna kamooggan k'ulluukki ibaaddo, isin kadiyaattaan diin, isin kamaaltteettaan maalin halchchareen, ayesuun goɂameen isoon lakkoɂekkaatte. ");
INSERT INTO bswl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Goorttanun isin wut'a kawut'ataro ibaaddotikotti masuussa maala, ");
INSERT INTO bswl_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wononnati kawaakkokki haafura maalegure kashaadoon maattaayyotti wodana orrokko kameellan emeeyigure kawut'amero wut'a aatinara. Goortta hikki raa giridii kaɂiyyero wut'aya. ");
INSERT INTO bswl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Shak'umooltti erree gutii kaɂiyera ade; haafura maalegure goorsewa geggelooyi kaɂatataro ibaaddo aani laara. ");
INSERT INTO bswl_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ayesuun goɂameen hididi aaloo dagisin mankkowate tanjiin lakkoɂadallaataro; haafurakkokki aalanttii rakkoo goorttun bak'atano goɂemeero goorsewa saame handudufatara. ");
INSERT INTO bswl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Eɂeen huura orroo kaɂiyyera wut'a haafura maalegure hikka alamii yaadanoyinna durummakkotti k'ofaayi sobamaa marggate il kasisoon wut'a aani laara. ");
INSERT INTO bswl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Erre taɂidan gutii kawut'amera wut'a goɂameen haafura kawaa maalegure kashaadaro ibaaddo aani laara, hassuna il yelatara, koo bool, koo lootam, koonna sonddom sisinnara.» ");
INSERT INTO bswl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesuusa kakkalee masuussa haa ame segee, «Wononnati kadaruure iraayi wut'a kaɂidan kawut'atero ibaaddoti aani laara. ");
INSERT INTO bswl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ayesuun goɂameen ibaaddo dubba huddure giraan diinakkeessa emetegure darggamaatteessa orroo sharafa wut'e seete. ");
INSERT INTO bswl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Darggamaanna alattedde il yelatano kakkohaggaɂabatte goorata sharafana wota mute. ");
INSERT INTO bswl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","«Odo iraan ofelaraan usu tos emetengureen ‹Gootta! Iraa orroo laa wut'a kaɂidan wunt't'ennella? Hayya sharafa haggekko emete?› ameen. ");
INSERT INTO bswl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","« ‹Usuna, hinɂi felo odiinayaan› ame. «Ohandaareenna ‹Seeyigunne sharafa goggotattaginnon dootatta?› ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","« ‹Usu goɂameen laa› ame, ‹Aalanttina isin sharafa tataganna amaa darggammaa wota tatayiddaanwa; ");
INSERT INTO bswl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Isaaga, kaami kukku takkoɂamaro arri taageeron raattoo hajiinaate, eserri omat'aranaanne t'aa sharafa tataga, eleenii goggogubamiro kabal kabalii shaa, darggammaa goɂameen kukkuyisaguddeen gootaraatteeyi kiba ani aminara ame.› » ");
INSERT INTO bswl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesuusa kakkalee masuussa, «Wononnati kadaruure ibaaddoti koo aatere irakkeessayi tawut'atero tic'c'artti tasinafic'c'i il aani laatta. ");
INSERT INTO bswl_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Sinafic'c'ikotti il kakkalee wut'ajjool dubbakko tayeraatatto il golleetena, alayidde gojiinaatto adde gaajjol dubbakko muyitegudde, guuntte kabuubara kimbirjol emeetegure ballaal gutii min kakkomadaararo gaa aani laara» ame. ");
INSERT INTO bswl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Giddanna Yesuusa kakkalee masuussaa, «Wononnati kadaruure heleelttiti too t'aamme seed galtte ekkaasse aattedde rigidde talelleddetto irshoo aani laatta» ame. ");
INSERT INTO bswl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesuusa goɂameen hikka dubba gosaan masuussayi ayeese, masuussa kallayi kaɂayeesamera ayees koonna lakkogire. ");
INSERT INTO bswl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Hikkina kahegerooyi haa amame kaɂayeesamere feloo haye. Hikkina, «Hiɂittee masuussayi banayinnara; alami takkomet'amerokko haggaɂabere siyame kagiro ayeesinara.» ");
INSERT INTO bswl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Esekko Yesuusa gosa iisegure min tabe; usukko oɂagaalssatareenna usu tos gabbalamengureen «Iraa orroo kagiro sharafa maraan kaɂayeesetto masuussakkotti fureen noon segiina» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesuusana, «Kaɂidan wut'a kawut'atera ere kaɂibaaddoyya; ");
INSERT INTO bswl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Irana hikka alamiyya, kaɂidankki wut'ana wononnati kadaruurekokki ibaaddo tusara, sharafana kas'alaye ibaaddokokki gara tusara; ");
INSERT INTO bswl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Wut't'egudde taseettetta diina s'alayeetta; wut'a takkokukkuɂaminarana alamikkokki gachcho golleero omat'arinaraanna adeen erggichchalyyan. ");
INSERT INTO bswl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","«Sharafana tatagamegure eleenii goggogubamaroo alamikkotti gachcho hikkamalee linatta. ");
INSERT INTO bswl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ere kaɂibaaddo erggichchakkeessa farnnara, isona c'ubboon aalantti olleeraanna tameellan ofelaraan dubba abaabigure wononnatikkeessakko beesinnara. ");
INSERT INTO bswl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ottanna ilkko fooc'ano mankkogiro tabbeebatto eleenii orroddeesi iso lugudinnara. ");
INSERT INTO bswl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Hassu goorata k'ulloolee Aabbokkisookki wononnati ariti aani hank'k'ayinnaran. Nebe kaɂaba hamaalo. ");
INSERT INTO bswl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Wononnati kadaruure iraa orro osiyyaameeraan urrawo aani laara. Ibaaddoti koo ohelatero hinɂa urrawo abbaabe siyyanssate, geggelaatanokko kakkeeyi kaɂabo dubba daddalategure ese taɂira banɂe iminate. ");
INSERT INTO bswl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Usumaleenna wononnati kadaruure kaɂidankki ink'uu iminayin kadootataro nagaadeti aani laara. ");
INSERT INTO bswl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Aaloo awɂallokki ink'uu kakkohelatare goorata seetegure kaɂabo dubba daddalategure usu ink'uu iminate. ");
INSERT INTO bswl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Adena wononnati kadaruure beke orroo golugudiraan sannii kamooggan kunɂub taɂabatto maarrabi aani laara. ");
INSERT INTO bswl_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kunɂub oɂabataraanna kunɂub maarraabi kakkoɂamagamare goorata giiteen baga tos beesen, esekko hamas's'eengureen kaɂidan kaɂidan assaabeen daachchool orroddeeseen kibeen; kameellan kameellanna goɂameen beesen shafeen. ");
INSERT INTO bswl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kagachchoo geesnna hikkamalee linnara, irggichchana emeeyigure c'ubbaaleyi k'ullooleekko assaabigure; ");
INSERT INTO bswl_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Oottaninna ilkko fooc'ano mankkogiro tabaanoon eleen tos lugudaminnara.» ");
INSERT INTO bswl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesuusana, «Hikki dubba isinuun tabera?» ame. Isona «Ii» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesuusa haa ame abbaabe, «Hikki haa amano mete metee seera kamuse kaɂagaalssisara usuna wononnati kadaruure usukko kaɂagaalssataro kalleera kaɂusubkkina kaddoɂankki gootaraakko kabeesaro odo aani laara» ame. ");
INSERT INTO bswl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesuusa hinɂa masuussajjool ayeese goggogudiseeyi ese banɂekko keegure seete. ");
INSERT INTO bswl_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ulkkeessa tos emetegure Ayihuudikokki min kaɂebii orroo gosa agaalssisano haggaɂabe, isona mamaa haa ameen, «Hikki ibaaddoti hitta k'arummana hikka baasa kakkofello hunna hayekko helatera?» ");
INSERT INTO bswl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","«Hikki laɂere kaɂanaat'iitiyolla? Aayetteessakki mege la Mayiraame amaraanna? Abbilaaltteessa adde Yayik'ooba, Yoosefa, Simoonane Yihuudanneeyaanna? ");
INSERT INTO bswl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Abbalaalttessanna dubba la noonne wota giraanna? Hayya hikki ibaaddoti hikka dubba hayekko helate?» ");
INSERT INTO bswl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Haanssun usu haɂatannooni heseen. Yesuusa goɂameen «Kahegeroo kakkokabajaamon ulkkeessayinna minkkeessa kaalaaliya» ame. ");
INSERT INTO bswl_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Iso ammananawaattikkotti aalanttii kamooggan baasa esee lakkofele. ");
INSERT INTO bswl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Usu goorata kagaliila ul k'alaadakkeessaa kabariisare mooti Herodoosa, ataan kayesuusakokki gara maale, ");
INSERT INTO bswl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Usuun ohandaareenne; «Hikki haa gollee kat'ammak'aara Yaannisa goyikko keegure emeetera amanoyya, hikki kasaadamara baasa dubba kakkofelamera usuuyya» ame. ");
INSERT INTO bswl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","T'aye Herodoosa abbikkeessa Filp'oosakkotti oori Herodiyaadakotti aalanttii Yaannisa absisegure minkashaano tabsere. ");
INSERT INTO bswl_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Aalanttina Yaannisa Herodoosane; «Abbikkaatti oori goggoɂatattoo seera feɂi lakkosisaro amaa gire.» ");
INSERT INTO bswl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Haanssun Herodoosa Yaannisa lagadin dootegure gosana usu kahegeroo aani mankkodiyaaro maraantinuu abssate. ");
INSERT INTO bswl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herodoosa usu takkoɂalatero arri kabajaataa giraan taherodiyaada ere emeettedde martti horee madarri kaduddurooyi mankkogeggelaayisse maraan, ");
INSERT INTO bswl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ese kahoosatte dubba eseen sisin ammato tabe. ");
INSERT INTO bswl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Unnutina Aayettiseetti markka atattedde, «Kat'ammak'aaro Yaannisakokki mete yaalɂaayi gutii kayigudde iin sisi» antte. ");
INSERT INTO bswl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Hassu goorata wonona gaddee, halleewo kuwaarre ammatoɂoottessa maraanna usune wota tagitte martti maraan hoosinttisee goggoɂabbaabattoo ajajee. ");
INSERT INTO bswl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Minkashaano tos ibaaddo faregure kayaannisa mete margikko goosise. ");
INSERT INTO bswl_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kagoosamero metena yaalɂaayi kayegure unnutiin sise, unnutina aattegudde Aayettiseewun sise. ");
INSERT INTO bswl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yaannisakko oɂagaalssatareenna rees atateengureen k'amaleen; esekkona seetengureen kalleerona Yesuusaan segeen. ");
INSERT INTO bswl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesuusana kalleero ayees kakkomaalare goorata takkogirekko keegure kaletti banɂe too tos wolabooyi tabe seete. Gosana hikka maalegure katamaalkko lukii usu debee sesseeteen. ");
INSERT INTO bswl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesuusana wolabokko dagaagiran kamooggan gosa deegure nenɂeyisate; dhukkubaalkkisokkona fayyiise. ");
INSERT INTO bswl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ul hemeen laa kakkoseetare goorata Yesuusakko oɂagaalssatareenna usu tos gabbalameengureen «Hitti banɂe koonna takkoginnoon k'alullattokki ulya; gooratana hemeen mankkollaaro maraan; maamanjoolkko seeyigureen kaɂaamiraan babo goggoɂiminaraawun gosa gafarina» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesuusa goɂameen «Iso seeyin lakkodootisaro, iso kaɂaamiraan isinwa sisa» ame. ");
INSERT INTO bswl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Isona, «Noo hittanii kaɂabnna babo bit'e kenna kunɂub lama kaalaal abnna» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesuusana, «Alla kaɂabttaan in tos keena» ame. ");
INSERT INTO bswl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Esekkona gosa ees gutii goggohamas'iron ajaja sise; babo bit'e kenna kunɂub lamana aategure elddee daruurii tos diyaa galateere babokko ibise aategure usukko oɂagaalssatareenun sise, isona gosaan siseen. ");
INSERT INTO bswl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Dubbana aameen barareen, esekkona usukko oɂagaalssatareenna tahessetto hanbba dugud tomonkko lama mig keeseen. ");
INSERT INTO bswl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kaɂaamere ibaaddo heleelnna yiis kallayi kuma ken kalleero babbaarye. ");
INSERT INTO bswl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Goorsewa usukko oɂagaalssatareen wolabooyi korayigureen usukko t'ayi bekekko gama goggonak'inawun ajajeegure, ussun ade gosa galisin haar hese. ");
INSERT INTO bswl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yesuusa gosa galise abbaabatere ebaayin kee wodami tos bee. Ul taamugud leeron kalekalee esee gire. ");
INSERT INTO bswl_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Hassu goorata wolabona bagakko fakki antte goosse seetaa giraan ambbal keetegudde gaashimallona hore haar shafano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Hemeenkko saatii saagaalkko abbaabatere Yesuusa bekee gutii sesseetaa usukko oɂagaalssatareen tos emeete. ");
INSERT INTO bswl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Usukko oɂagaalssatareenna usu bekee gutii sesseetaa kaɂemeetaro kakkodiyaaren goorata absatenguren, «Hitti gaaritta» amaa okkeen. ");
INSERT INTO bswl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Goorsewa Yesuusa isone, «Allamandde! Aniyya. Arooɂabssatteen» ame. ");
INSERT INTO bswl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","P'et'iroosana, «Goottaa! Goɂatitto ani bekee gutii sesseetaa ku tos goggoɂemeeroon in ajajii» ame. ");
INSERT INTO bswl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Usuna, «Koyya» ame. P'et'iroosana wolabokko dagegure bekee gutii sesseetaa Yesuusa tos emeetano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ayesuun goɂameen ambbalkokki hunna kakkodiyaare goorata abssate; bekeeyi ennegamano kakkohaggaɂabare goorata «Goottaa! In haasi» ame okkee. ");
INSERT INTO bswl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesuusa saame genetteessa diriirssate usu abegure, «Ati ammano kakoonhank'atera! Muun hedatte?» ame. ");
INSERT INTO bswl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yesuusana P'et'iroosa wolaboo gutii korataawa ambbal c'alɂi antte. ");
INSERT INTO bswl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Wolabooyi orroo ogireen, «Rumminaa ati ere kawaatta» amengureen gilbbiseen usuun sagadeen. ");
INSERT INTO bswl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yesuusana usukko oɂagaalsatareen bekekko gama nak'eengureen Genssaaret'i taɂamamatto banɂe tos geen. ");
INSERT INTO bswl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Usu ulkki ibaaddo Yesuusa laano kakkoɂaddeesare goorata gobobii kagiro maamanjool dubbaan handdaa fareen; kahawɂamaro ibaaddo dubba usu tos keensiseen. ");
INSERT INTO bswl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ohawɂaamareenna sarssikkeessakkotti sharffi taalaal dinin feɂi goggosisiroon ebaaten. Usu odineen dubba duuddo fayyeen. ");
INSERT INTO bswl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Esekkona Iyyerusaalemikko oɂemeeteran Farasaawiilnna seera kamuse oɂagaalssisaran Yesuusa tos gabbalamengureen, ");
INSERT INTO bswl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Kukko oɂagaalssataran woga kaɂodolaal kakkoɂiggilissaraan mewuunya? Babo aamin genettisoo lakkoɂaalaran» ame. ");
INSERT INTO bswl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesuusana haa ame abbaabe; «Isinna wogakkisinuun antteengudden ajaja kawaa muun iggilissattaan? ");
INSERT INTO bswl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Waa, ‹Aabbokkaanna Aayettaa kabajii,› ‹Maayyona Aabbokkeessa goorttun Aayetteessa gutii kameellan haafura kaɂenggee kaɂayeesara hagoye ami ajaja gosisiro,› ");
INSERT INTO bswl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Isin goɂameen Aabbokkeessa goorttun Aayetteessa, ‹Ani isinuun sisin kadootisaro gargaarssa Waawun jaarsso yele ani sisera› goɂame, ");
INSERT INTO bswl_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","hassu ibaaddoti ‹Aabbokkeessa goorttun Aayetteessa kabajin lakkodootisaro› amattaan; haanssun wogakisinuun antteengudden haafura kawaa iggilissattaan. ");
INSERT INTO bswl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Isin ifissaaddolee Isiyaasa isin maraan hegero kaɂayeesera rummiya. ");
INSERT INTO bswl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","« ‹Hikki gosa in hiɂii kabajaara; Wodanattiso goɂameen inkko fakki taɂanttetta; ");
INSERT INTO bswl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Iso in adda hedooyisataran; Agaalssiskisona woga kaɂibaaddoo maleeya.› » ");
INSERT INTO bswl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesuusa gosa isi tos uumegure haa ame, «Maala! Shaada! ");
INSERT INTO bswl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ibaaddo kabbattoyisara hiɂikko kabeyaaro kuwaarre hiɂi orroddee katabaro lakkoyo!» ");
INSERT INTO bswl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Esekkona usukko oɂagaalssatareen usu tos gabbalameengureen «Farasaawiil ati kaɂanttetto maalengureen goggoɂamarateeran deete?» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesuusa goɂameen, «Kadaruure Aabbokki kaɂabbaroon alat dubba tagaminara. ");
INSERT INTO bswl_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Isaaga, iilɂo odiyaannon ok'ajeelisaraan iso ussun ilɂo odeyaannonyaan. Iilɂo kadiyaannon iilɂo kadiyaannon gogeggeesiro iso lama raattoo isi abateen laga orroddeen iyaaran.» ");
INSERT INTO bswl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","P'et'iroosana Yesuusane, «Masuussakotti fureen noon addeesisi» ame. ");
INSERT INTO bswl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesuusana haa ame, «Isin gidda gin lakkoshaaddeettan amanoyya?» ");
INSERT INTO bswl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","«Hiɂine katabara dubbana bogi orroddee tabegure esekkona sarddee kabeyaaro lakkokassaanya? ");
INSERT INTO bswl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Hiɂikko kabeyaara goɂameen wodanakko kabeyaaroyya, ibaaddona ‹kabbattoyisara› usuya. ");
INSERT INTO bswl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tameellan k'ofa, neefo lagadano, layimano, sharmmut'aano, hetano, t'ara atotaanona mege baasano hikki dubba wodanakko kiyaara. ");
INSERT INTO bswl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ibaaddo ‹kabbattoyisara› hikkaya kuwaarre genenno haɂaalooni babo aamano ibaaddo lakko battooyisaro.» ");
INSERT INTO bswl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesuusana esekko beegure T'iroosi tonssa Sidoona kaɂamamaro kakkatamaa gobob tos seete. ");
INSERT INTO bswl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kakkanaɂaan ulkkotti heleelttiti too usu maamankko beetegudde Yesuusa tos emeettedde «Goottaa! Ere kadaawute iin nenɂeyisana, eretti battiikki ayyaanayi abanttegudde aaloo abboosaatta antte okkiite.» ");
INSERT INTO bswl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesuusa goɂameen haafura koonna lakkoɂabbaabe, hassu goorata Yesuusakko oɂagaalssatareen usu tos emetengureen «Hitti heleelttiti noo debee sesseetaa iyyaatta ese galissewaɂiis?» ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesuusana abbaabere, «Ani kakkonfaramera min kaɂisiraɂeelkko kabayero idaadjjool kaalaalunyya» ame. ");
INSERT INTO bswl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Heleelttitina lukitteessa gutii iitegudde «Goottaa in gargaarna!» antte. ");
INSERT INTO bswl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesuusana abbaabere, «Babo kayiis aatigureen keroorun shafano lakko dootisaro» ame. ");
INSERT INTO bswl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Esena, «Ii Goottaa!» «Keroornna odokkeessati dugudkko taɂiitetto orroontti aamara» antte. ");
INSERT INTO bswl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Hassu goorata Yesuusa, «Ati heleelttiti ammanokka kaɂatiiya! Halchchakkaakki malee kuun halleewo» ame. Unnutina hassu gooratakko haggaɂabttedde fayyiite. ");
INSERT INTO bswl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesuusa esekko keegure tagaliila labu girii taggitto banɂe seetegure wodami tos bee esee hamas's'ee. ");
INSERT INTO bswl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tootooyi kamooggan kallee gosana kaɂeesare, iilɂo kadiyaannon, naafaleessaal, hiɂi oɂayyeesoon, usumaleenna kakkaleekki kamooggan dhukkubaleessaal abeen usu tos keenenguren luk'k'aɂoottessa hegelii hamas'iseen; usuna fayyiise. ");
INSERT INTO bswl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Gosana hiɂi kaɂayeesoonna ayeesano, naafaleessaalnna iidano, kaɂeesarena tukkul aalli sesseetano, ilɂo kadiyaannonna diyaano, kakkodeyaaren goorata, kaɂisiraɂeel Hedo galateen. ");
INSERT INTO bswl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesuusa usukko oɂagaalssataran uumegure «Gosa iinne wota arri seed mankkohayero maraan kaɂaamiraan mankkowaatenaan maraan ani isoon nenɂeyisatara, raadii uuɂigureen ul goggoɂiinnoonkko uɂine gafarin ani feɂi lakkosisinaro» ame. ");
INSERT INTO bswl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Usukko oɂagaalssatareenna «Hikka koonna kallayikki k'alullattokki uli, hikka gosa dubbaan kalleero babo aamisin no hayekko helnanna?» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesuusana, «Golleenna isin babo bit'e miyyaa abttaan?» ame hoosate. Isona; babo bit'e titiic'c'ar «Todobana» «kunɂubja otitiic'c'ar abnna» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Usuna gosa ul goggohamas'iroon feɂi sise; ");
INSERT INTO bswl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Babo bit'e todobanna kunɂubja abegure Waa sommaasate abbaabategure babo eɂebise usukko oɂagaalssatareenun sise, isona gosaan hedeeden. ");
INSERT INTO bswl_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Dubbana aameen barareen, usukko oɂagaalssatareenna tahessetto hanbba dugud todoba mig keeseen. ");
INSERT INTO bswl_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kaɂaamere ibaaddona heleelnna yiinssa antootamonii kuma afar babbaarye. ");
INSERT INTO bswl_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesuusa gosa galse abbaabatere wolabooyi tabere kamegedooli ul tos seete. ");
INSERT INTO bswl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farasaawiilnna Sodok'aawil Yesuusa tos gabbalameengureen c'aafin dootengureen, «Waakko malaata noon tusi» ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Usuna abbaabere, «Hemeen ‹Daruur heela golleeto c'aaminnara› amattaan. ");
INSERT INTO bswl_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Babbarnssa ‹Daruur gambballa leete isilaattetta, haanssun idaamo ubayinara› amattaan, tadaruure middi malabiin daanddaattan, ayesuun goɂameen geeskokki malaata addeesin lakkodaanddaattan. ");
INSERT INTO bswl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tameellanna tasharmut'aatta alattaan malaata dootatta, ayesuun goɂameen kayoonasa malaata kuwaarre kakkalee malaata lakkosisamaro» esekko Yesuusa iso iise seete. ");
INSERT INTO bswl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesuusakko oɂagaalssatareen bekekko gama kakkonak'areen goorata babo abatano illootereen. ");
INSERT INTO bswl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesuusana, «Isiɂoorayeen» «Tafarasaawilnna tasodok'aawilkkotti meellanekko isiɂoottisin oorayeen» ame. ");
INSERT INTO bswl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Isona isiɂisiɂorroo, «Noo babo haɂabannoonii mankkogginno maraan leera» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesuusana k'ofattisoo addeesere, «Isin ammano okkoonhank'atera! Isin isiɂisirroo babo abatanawaatti muun ayeesattan? ");
INSERT INTO bswl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Babo bit'e kenno kuma ken ibaaddon leegure dugud miyyaa falayite kakkeessettaan lakkoshaadattaanya? ");
INSERT INTO bswl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Usumaleenna babo bit'e todoba kuma afar ibaaddon leegure kafalayero dugud miyyaa horekko keessettaan wodanaayi lakkoɂabattettaan amanoyya? ");
INSERT INTO bswl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Hayya ani isinuun kasegeera gara kababoo laanawaatti misii shaadanawaattan? Giddanna tafarasaawilkkona tasodok'aawil meellanekko isiɂoorayeen.» ");
INSERT INTO bswl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Usu isone isiɂoorayeen kakkoonɂamera kaamii takibamatto irshoo anlleennon giraan; Farasaawilkkokkina Sodok'aawilkokki agaalssisikko isiɂooraayeen kaɂamaro laano isoon addeesame. ");
INSERT INTO bswl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesuusa ul kafilip'isiyoosa K'isaariya kaɂamamaro ul kakkogiyaare goorata usukko oɂagaalssatareenne, «Ibaaddo ere kaɂibaaddo ayyoyya amara?» ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Isona, «Kookkoo kat'ammak'aaro Yaannisayya, kakkalee ade Eelaasaya, kuukina ade Ermaasaya, goorttun kahegeroolkko kooyya» amaraan ameen. ");
INSERT INTO bswl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesuusana, «Isin addeen in ayyoyya amattaan?» ame. ");
INSERT INTO bswl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoona kaɂamamara P'et'iroosana, «Ati arddokki ere kawaa Kiristoosatta» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesuusana haa ame «Ere kayoona Simoona! Ati kasommaasanttetta, hikka kuun katusera daruurii kagiro Aabbokkee kuwaarre ibaaddo lakkoyo. ");
INSERT INTO bswl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ati P'et'iroosatta, hikka eɂemo gutii amaniil kakkokukkuɂamiro min ani madaarinnara, tabaanoon eleenkokki hunnana usu min lakkoɂawodiro. ");
INSERT INTO bswl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Wononnati kadaruure kakkobanaraan k'ulffi ani kuun sisinnara; ati ulii kashiite daruurii kashaame linnara; ati ulii kafurttena daruurii kafurame linnara.» ");
INSERT INTO bswl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Esekko abbaabatere usu Kiristoosa laanokkeessa maayyoonna goggoɂayeesonkko usukko oɂagaalssatareenun ataayise segee. ");
INSERT INTO bswl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Yesuusa hassu gooratakko haggaɂabegure «Iyyerusaalemi tos seeyigure eseenna gene tajaarssoleeyi, tuuk'aamolkokki woyichchaalnna seera kamuse oɂagaalssisaraankkotti geneyi rakkoo atayire kagoyinnarona arri taseedi goyikko kiyaano» kadootisaro laano usukko oɂagaalssatareenun segaano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","P'et'iroosana Yesuusa kale aate beegure; «Goottaa! Hikka aankkikki ayees ijjii ku aroogeenno» amaa hadisano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesuusana P'et'iroosa tos kambbal amere, «Ati s'alaye hittakko buuyi! K'ofa taɂibaaddo kuwaarre k'ofa tawaa addeesin mankkodaanddeenon maraan ati iin handuddufo laatta ame.» ");
INSERT INTO bswl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Esekkona Yesuusa usukko oɂagaalssatareenne, «Iin debee sesseyiin kageelaatara isiɂoottessa hakakato, rakkoowunna goyiin isiɂootteessa roorssayi sisayire iin debee hasesseeto ame. ");
INSERT INTO bswl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Neefotteessa haasayiin kadootatara dubba baasatara, ayesuun goɂameen neefotteessa in maraan kabaasatara dubba helatara. ");
INSERT INTO bswl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ibaaddo alami dubbakko worɂe gohelate, neefo goɂameen gowaate me laɂo helatara? Goorttun neefokkotti banɂee me mura helayinara? ");
INSERT INTO bswl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ere kaɂibaaddo Aabbokkeessakkotti kabajaayi erggichchane wota emeeyinnara; ibaaddoon metemeteeyi feloɂootteessakki malee muraa murinnara. ");
INSERT INTO bswl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ani rumminaa amara; hittanii kagiro ibaaddokko ere kaɂibaaddo wono lee emeetaa giraan taa deeroon kagoonoon ibaaddo gira.» ame. ");
INSERT INTO bswl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Arri lekko abbaabatere Yesuusa P'et'iroosanee, Yayik'oobanee, usumalee kayayik'ooba abbi Yaannisanee wodami too tanjiintti t'ok'k'i taɂantte tos kale aate bee. ");
INSERT INTO bswl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Esee isoo horee midditteessana iggilissantte, horetteessa ariti aani hank'k'ayite, sarssikkeessana ifa aani wola ame hank'k'aye. ");
INSERT INTO bswl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Esekkona Musena Eelaasana Yesuusane wota ayeesaa giraan muteen. ");
INSERT INTO bswl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","P'et'iroosana Yesuusane, «Goottaa! Noo hittanii girnnewa noyeen kaɂidanyya; feɂittaa golleete daase too kuyeen, too Museen, too Eelaasan daase seed ani madaarro» ame. ");
INSERT INTO bswl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Usuna ayeesaa giraan kahank'k'aara duumanchcha kagumaari iso hogoogisere duumanchchaayi orroo, «Ani usuuyi kakkogeggelaayinnarana ani kageelaatara erekki hikkaya, usuna maala» taɂamatta yaaye maalssantte. ");
INSERT INTO bswl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Usukko oɂagaalssatareenna hikka kakkomaalareen goorata neenguren hore hore ul iyyeen. ");
INSERT INTO bswl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesuusana iso tos gabbalamere dinddinegure, «Kiyaa, arooɂabssatteen» ame. ");
INSERT INTO bswl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Iso t'ok'k'i ami godeeran Yesuusa kuwaarre kakkalee maayyona lakkodeeran. ");
INSERT INTO bswl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Wodami guukko dagaagiran Yesuusa, «Ere kaɂibaaddo goyikko taakeeroo gin kaddeetettaan maayyonna arooɂayeesseen» ame ajajee. ");
INSERT INTO bswl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Usukko oɂagaalssatareenna, «Hayya seera kamuse oɂagaalssisaran Eelaasa t'ayi emeetano dootisara kakkoɂamaraan muunya?» ameen Yesuusa hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Usuna isoon abbaabere, «Ogiraan Eelaasa emeeyigure kaɂameen dubbana gachchooɂekkaasira; ");
INSERT INTO bswl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ayesuun goɂameen ani haa amara, Eelaasa t'aye emeetera, golleenna kadootateran ayees felateeran kuwaarre lakkoɂaddeeseran; usumaleenna ere kaɂibaaddo genetisooyi rakkoo atayinara.» ");
INSERT INTO bswl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Hassu goorata Yesuusakko oɂagaalssatareen usu kaɂayeesera ayees kat'ammak'aaro Yaannisakokki gara laano addeesen. ");
INSERT INTO bswl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesuusana seeddo usukko oɂagaalssatareen gosa tos kakkoɂabbaabateeren goorata ibaaddoti koo Yesuusa tos gabbalame horee gilbbisere haa ame; ");
INSERT INTO bswl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Goottaa! Maganne unnukkeewun nenɂeyisa,» usu «Kagaggadduu hawɂaamii abboosara; gama kahori eleen orroddee iyaanna beke orroddee tabara. ");
INSERT INTO bswl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kukko oɂagaalssataran tonssa ani keenera ayesuun goɂameen iso fayyiisin lakkodaanddeeran.» ");
INSERT INTO bswl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesuusana, «Isin oɂammanoonna tawoc'ac'c'aantte alattaan ani hagge taageeroon isinne wota girinnara? Hagge taageeroon obssinara? Unnu hittarraa in tos keena» ame. ");
INSERT INTO bswl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Esekkona Yesuusa battiikki ayyaana hadisegure beese. Unnuna hassu gooratakko haggaɂabere fayyee. ");
INSERT INTO bswl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Usukko oɂagaalssatareen kale been Yesuusa tos gabbalamengureen, «Noo battiikki ayyaana unnukko beesin kakkowannenna mewuunya?» ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesuusana, «Ammanokkisin mankkohank'k'atero maraanya. Ani rumminaa amara, tasinafic'c'i il gitakki ammano isinuun girewa, hitta wodami, ‹Hittakko kingudde toladdee see!› Goɂantteen seetattewa, isinuun kalleenon kooko lakkogiro.  ");
INSERT INTO bswl_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Hikka aankkikki goɂameen ebina kaɂagaabuuyi gollee kuwaarre lakkobeero ame.» ");
INSERT INTO bswl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ul kagaliilaayi usukko oɂagaalssataran kukkumeen giraan Yesuusa isone haa ame, «Ere kaɂibaaddo gene taɂibaaddoyi roori sisaminara; ");
INSERT INTO bswl_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Lagadinnaran, usuna taseedi arri goyikko kinnara» usukko oɂagaalssatareenna aaloo gaddeen. ");
INSERT INTO bswl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesuusana usukko oɂagaalssatareen K'ifirenaahoomi tos kakkogiyaaren goorata k'ulluukki min kawaakkokki giira oɂabaabareen P'et'iroosa tos gabbalameengureen, «Kaɂagaalssisarakkisin k'ulluukki min kawaakkokki giira lakkomuraroya?» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","P'et'iroosana, «Ii murara» ame. P'et'iroosa min orroddee goggotabeeyi, Yesuusa horaarjje, «Simoona! Kaɂulee wonojjoolkokki giira goorttun k'arat'a kakkoɂaatinnaraan kaɂulee ibaaddokkoya muu kakkaleekko aani laara?» ame. ");
INSERT INTO bswl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","P'et'iroosana, «Kakkaleekkoyya kakkoɂatamara» ame. Yesuusana, «Goorttanun yiisaaskkisin tagiira muraakko hesera. ");
INSERT INTO bswl_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","«Golleenna noo isoon handuddufo goggolleenoonkko labu tos dagiggudde mant'ak'k'oo luguda, horaarjje kaɂabato kunɂub aatigudde hiɂi goggobantteeyi maragade helnnatta, hassu aatigudde in marantinuuna megekkaa maraan muri» ame. ");
INSERT INTO bswl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Hassu goorata Yesuusakko oɂagaalssatareen Yesuusa tos gabbalameengureen, «Wononnati kadaruureyi dubbaankko karoorara ayyoyya?» ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesuusana yiittiti koo uumegure isoo t'eɂee aallisere, ");
INSERT INTO bswl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","«Ani rumminaa amara; goɂiggilssamoonna yiisaas aani golleennoon wononnati kadaruure tos suure lakkotabttaan. ");
INSERT INTO bswl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Haanssun wononnati kadaruureyi dubbaankko karoorara hikka yiittiti aani isiɂoottessa kahussisataroyya. ");
INSERT INTO bswl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","«Hikkamaleekki yiittiti megekkeeyi kaɂatatara inna atatera.» ");
INSERT INTO bswl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ayesuun goɂameen iyyee oɂammanaraan hinɂa otitic'c'arkko koo c'ubbo orddeese katabsara kanjiinkki eɂemo kariimee marggittessaa shaamigure beke badi t'eɂee shafami lichchi goɂame iidare. ");
INSERT INTO bswl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","«Hikki alami c'ubboon aalantti mankkolleero maraan aanne usuun! C'ubbo orddeese katabsara emeetano lakkohesiro; ayesuun goɂameen c'ubboon aalantti kalaaro ibaaddoon aanne! ");
INSERT INTO bswl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Genetta goorttun lukitta kuun c'ubboon aalantti golleete goosi shafi. Gene lama goorttun luk'k'a lama kuun girigureen jiruu jiroomman tabaanon tagaannemi eleen tos shafamanakko kaɂeesatto goorttun naafaleessa liigudde jiruu jiroommakki giri tos tabano kaɂidankkiya. ");
INSERT INTO bswl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Usumalee iltta c'ubboon aalantti golleete beesi shafi, ilɂo lama kuun girigureen tagaannemi eleen tos kashafamattokko il too kuun giridde jiruu jiroommakki giri tos tabano kaɂidankkiya.» ");
INSERT INTO bswl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Daruurii kagira erggichchalkkiso arggetto daruurii kagiro Aabbokkee horee mankkogiraan hinɂa kic'iic'c'akko koonna goggotuffannonkko isiɂoorayeen.  ");
INSERT INTO bswl_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ere kaɂibaaddo obbayeeraan haasin emeetera. ");
INSERT INTO bswl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Yesuusana ade, «Alla iin segaa; ibaaddoti koo idaad bool kaɂabo gollee, iso orrokko koo gobbaye saagaalttamkko saagaal wodamii gutii iisegure kabbayero koo dootayiin lakkoseetaroya? ");
INSERT INTO bswl_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ani rumminaa amara, kabbayero idaado gohelaro ogiraan saagaalttamkko saagaal idaadkko suure hassu kahelameroon geggelaatara. ");
INSERT INTO bswl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Usumaleenna hikka kic'iic'ar orrokko koo goggobaaron daruurii kagiro Aabbokkisintti feɂi lakkotto. ");
INSERT INTO bswl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Abbikka ku miirɂi gogire seegudde usune wota lamaa laaddeen baaskkeessa segii, ku gomaale abbaabattedde abbikkaa yelatta. ");
INSERT INTO bswl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Maalana gowaatte ade ibaaddo lama goorttun seed kaɂatoteera ayees dubba mankkoɂataataro maraan ibaaddo koo goorttun lama aati seegudde gaafachchisi. ");
INSERT INTO bswl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Isona maalana gowaate min kawaakki ibaaddon segii, min kawaakki ibaaddo kamaaloon gollee Ayizaab aaninna k'arat'a kakukkuyisaro aani tootii. ");
INSERT INTO bswl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Ani rumminaa amara, isin ul kashiiten dubba daruurii kashaame laara, isin ul kafurtteen dubba daruurnna kafurame laara. ");
INSERT INTO bswl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«Adena ani rumminaa amara, ul gutii lamaa liiddeen maamisikki ayeenssa wota isiɂaati Waa goɂebaatteen daruurii kagira Aabbokki maalire isoon fellowa. ");
INSERT INTO bswl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Lama goorttun seed liigureen megekkeeyi takkokukkuɂamaraan banɂeeyi ani isoo orroo mutinnara.» ");
INSERT INTO bswl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Hassu goorata P'et'iroosa Yesuusa tos gabbalamere «Goottaa! Abbikki in gomiirɂe miyyaa gali usuun haheso amira? Taa todoba geeroyiya?» ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesuusana, «Todobaatam gali todoba kuwaarre todoba gali kaalaal ani lakkoɂamaro» ame. ");
INSERT INTO bswl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«Haanssun wononnati kadaruuree usuun ohandaaraankotti genee kagiro maragade tooti din kadootataro wono aani laara. ");
INSERT INTO bswl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wonona maragadekkeessa tootaayin kakkohaggaɂabare goorata kuma kamoogganii katootamiro maragade anza kaɂabo ibaaddoti koo usu tos aateen emeeten. ");
INSERT INTO bswl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Hikki kahandaarekkina anza murin mankkowaatero maraan usunnee, ooritteessane, yiiskkeessaane, urrawoɂootteesane dubba daddalami anza goggomurantto goottaa ajajee. ");
INSERT INTO bswl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","«Hassu goorata kahandaarekkina goottakkessakkotti lukii iyyegure obssii; taɂabo anza dubba gachoo kuun ani murra ame ebaate. ");
INSERT INTO bswl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Goottakkeessana nenɂeyisategure usu gafare, anzattessana isaage. ");
INSERT INTO bswl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Hassu kahandaarekkina goottaa horekko goggobeeyi maragadekkeessa t'agaraa kaɂabo anza kaɂabanaaye usune wota kafelare unatteessa kalleera ibaaddoti koo helegure c'uulɂee abere taɂabtto anza hittanii iin muri!» ame. ");
INSERT INTO bswl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","«Hassu saatikkeessana usuu horee iyyegure, ‹Maganne obssi ani kuun murrowa› ame ebaate. ");
INSERT INTO bswl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","«Ayesuun goɂameen taɂabo anza usu muri taagudisirooyi obssaana waatere minkashaano usu tabise. ");
INSERT INTO bswl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kalleero ayees kaddeera kakkalee kafeloo ibaaddona nenɂeyisate, kalleero dubbana seeteengureen goottakkisowun segeen. ");
INSERT INTO bswl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","«Usu goorata goottanna hassu kahandaaro uumsisegure haa ame, ‹Ati kameellan kahandaatta!› ‹Ati iin mankkoɂebaattette maraan hasse anza dubba ani kuun iisere; ");
INSERT INTO bswl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ani kuun goggoɂiiseroo atina kageelaatattokkaawun nenɂeyisayin lakkodootisareye?› ");
INSERT INTO bswl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Iɂootere taɂabo anza dubba muri taagudisiroon kashaaronna kamurrisaroon roorise usu sise. ");
INSERT INTO bswl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«Haanssun isin mete metee abbilaalttisinuun wodanakko haheso goɂamoon kadaruure Aabbokkisin isinna hikkamalee yelinnara.» ");
INSERT INTO bswl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesuusa hikka ayeese gudisegure ul kagaliilakko keegure laga kayorddaanosikko gamaa kagiro ul kayihuuda seete. ");
INSERT INTO bswl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Gosa kamoogganna usuu debee sesseete, eseenna iso fayyiise. ");
INSERT INTO bswl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farasaawiilnna Yesuusa c'aafin dooteen usu tos gabbalameenreen, «Ibaaddoti koo maamisitti aalanttiinna ooritteessa keelkki ami beesin feɂi sisanttetta?» ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesuusana isoon abbaabere, «Iso kamet't'eera Waa horaarjje babbaarnna heleel yele kamet't'eero Lakkonabbabtteettanya? ");
INSERT INTO bswl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Haanssun, ‹Ibaaddo Aabbokkeessana Aayetteessa iisegure ooritteessane wota k'urannaamara, iso lamana maar koo laaran kaɂamamera la hikkakkotti aalanttiyyolla›? ");
INSERT INTO bswl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Goorttanu maar kooyyaan kuwaarre lakkolamayyaan. Haanssun Waa kak'uranneero ibaaddo lakkofurro.» ");
INSERT INTO bswl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farasaawiilnna, «Hayya Muse babbaartiti koo ooritteessa keelkki amanoon kalleero worak'ata sisi ooritteessa goggogafarroon ‹Muun ajajee?› ameen.» ");
INSERT INTO bswl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesuusana, «Muse wodanattisinkokki ataan deegure oorijoolkisin keelkki goggoɂanttaanun feɂi sisera kuwaarre t'aye lakkohaayye. ");
INSERT INTO bswl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ani goɂameen haa amara, entterkkise giraan kakkaleenne wota sharmmut'aa gomutte kuwaarre ooritteessa keelkki ame gafaregure takkalee heleelttiti oori kayelatara dubba kasharmmut'aaroya» ame. ");
INSERT INTO bswl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yesuusakko oɂagaalssatareenna; «Taɂenttereenna taɂoorii haajaa hikkamalee golleete oori atatano isaagano horekki» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesuusa goɂameen, «Hikki Waakko kasisame gollee kuwaarre hikka ayees maayyona atayin lakkodaanddaaro. ");
INSERT INTO bswl_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Aalanttina kookkoo alataa sangoome kaɂalatara gira, kakkalee gene taɂibaaddootii goosame kassangisamara gira, adena wononnati kadaruurewun ameengureen oori haɂatannoon ogiraan giraan, hikka atayin kadootatara haɂatato» ame. ");
INSERT INTO bswl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Esekkona genetteessa isoo gutii kayigure goggoɂebaaroon ibaaddo yiisaas Yesuusa tos keen; usukko oɂagaalssatareenna adeen yiisaas kakkeenaro ibaaddo hadiseen. ");
INSERT INTO bswl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesuusana, «Iisa yiis in tos haɂemeeto arootirtteen, wononnati kadaruure iso aankkikkinya.» ");
INSERT INTO bswl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Genettessanna iso gutii kaye abbaabatere ese banɂekko keegure seete. ");
INSERT INTO bswl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Esekkona ibaaddoti koo Yesuusa tos emeetegure, «Kaɂagaalssisatto! Jiruu jiroommakki giri helayiin me kaɂidankki ayees fella?» ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesuusana, «Kaɂidan ayeeskkokki gara in muun hoosatta? Kaɂidankki kalleera ayees koo kaalaalyya, jiruu jiroommakki giri tos tabin godootatte adi ajajakkee oora,» ame. ");
INSERT INTO bswl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Wodallaatina, «Eeki ajaja?» haa ame hoosate. Yesuusana, «Aroolagadde, aroosharmuut'ite, aroohette, t'ara arooɂatotiite, ame. ");
INSERT INTO bswl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Aabbokkaanna Aayettaa kabajiina, ollaattaanna isiɂoottaa aani geelaa» ame. ");
INSERT INTO bswl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Wodallaatina, «Hikka dubba oorayeera,» hikkakko kakkalee «Kahank'atera meyya kagira?» ame. ");
INSERT INTO bswl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesuusana, «K'ulluu liin godootatte seegudde oɂabtto urrawoɂoottaa dubba daddalidde maragade hiyyeessan sisi; daruurii urrawo helayinnatta. Esekkona emeegudde iin debee sessee» ame. ");
INSERT INTO bswl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hikki wodallaati hikka kakkomaalare goorata urrawo omooggan mankkoɂabo maraan yaadaa iise seete. ");
INSERT INTO bswl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesuusana usukko oɂagaalssatareenne, «Ani rumminaa amara; dureessa wononnati kadaruure tos tabano aaloo k'arrayya. ");
INSERT INTO bswl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Adena ani amara, dureessa wononnati kadaruure tabanokko gaala butto kamarffi tabanoyya ene kalleera» ame. ");
INSERT INTO bswl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yesuusakko oɂagaalssatareen hikka maaleengureen aaloo mamaa, «Hayya ayyoya fayyiin kadanddeera?» ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesuusana iso tos deyaa, «Hikki ibaaddo dollee lakkodaanddaamiro, Waayi dollee goɂameen ayees dubba daanddaamara ame.» ");
INSERT INTO bswl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","P'et'iroosana abbaabere, «Noo kameen dubba iinssegunne ku debee sesseetanna, hayya noo me helayinanna?» ame. ");
INSERT INTO bswl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesuusana, «Ani rumminaa amara; kaɂemeeyinaro kaɂusub alami ere kaɂibaaddo kakkabajaa korffinjjee gutii kakkohamas's'ee goorata iin odebee osesseyaattan isinna tomonkko lama korffinjjee gutii hamas's'iiguddeen tomonkko lama taɂisiraɂeeli aani gutii firddinattaan. ");
INSERT INTO bswl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Megekkee maraan amire minjjool, goorttun abbilaal, goorttun abbalaal, goorttun Aabbo, goorttun Aaye, goorttun yiis, goorttun ira kaɂiisara dubba boolkokki ambbaa atayinara, jiruu jiroommakki girina eelnnaran. ");
INSERT INTO bswl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ayesuun goɂameen kamooggan kahoree kahaaree linnaraan; kamooggan kahaareenna kahoree linnaraan» ame. ");
INSERT INTO bswl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Wononnati kadaruure woyinnikotti banɂee kafelaro kafeloo ibaaddoon felo sisin bari bullane kee kabeero kawoyinii akaakilttekkokki odo aani laara. ");
INSERT INTO bswl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Usuna ofelaraawun arri tooyi t'agaraa too too murin ekkaategure kafeloo ibaaddo tawoyinii banɂe tos tabse. ");
INSERT INTO bswl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","«Barkko saatii seeddinna beegure felo waateen taggiyyaa banɂee kaɂaalleero kakkalee ibaaddo helegure; ");
INSERT INTO bswl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Isinna ‹Seyeenguddeen kawoyinii irakkeeyi felo fela, tadootisatto muraa isinuun ani gachchoomurra› ame. ");
INSERT INTO bswl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Isona seeteen, «Arriikko saatii leyinna saatii saagaali emetere kakkalee felate kabbaraaro ibaaddon amalekkoonɂi felo sise. ");
INSERT INTO bswl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Meeriti saatii tomonkko kookki goorata beegure aallee kagiro kakkalee ibaaddo helegure ‹Arri duuddo felo kallayi hittanii muun aalliteettan?› ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","« ‹Isona, noon felo kasisiro ibaaddo mankkowaannenno maraanya› ameen. «Usuna ‹Isinna seyeenguddeen kawoyinii irakkeeyi fela› ame. ");
INSERT INTO bswl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Ul hemeen kakkolaare goorata kawoyinii akaakilttekkokki odo usuun ofelaraan odonnatii kaddeero ibaaddotin sisegure, ‹Danbbenne kaɂemeeterokko haggaɂabdde horaarjje kaɂemeetero taageeroo kagiro kafeloo ibaaddo dubba uumigudde daamoozakkisoo muri› ame. ");
INSERT INTO bswl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","«Saatii tomonkko kooyi feloon otabeeran emetengureen mete metee t'agaraa toottoo atateen. ");
INSERT INTO bswl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Horaarjje feloon otabeereen emetengureen t'agaraa onjii muraa ohelayinaraan aani isoon leere; ayesuun goɂameen isoonna mete metee t'agaraa toottoo murantte. ");
INSERT INTO bswl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Muraa atataagiraan kawoyinii akaakilttekokki odoo gutii gumggumeen. ");
INSERT INTO bswl_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Hinɂi danbbenne feloon otabeeren saatii too taalaal gofellaan; arri duuddo felooyi haraanna arritii gubataa ohayinenno noonne wota misii amalekkooyi muratta? Ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","«Usuna felate kabbaraaro koonne haa ame, ‹Kageelaatarokkee! Ani kuun miirɂa lakkogeegisero; t'agaraa tooyi felin ati iinne wota lakkoɂekkatteya? ");
INSERT INTO bswl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ku kageyaaro atagudde see, kuun kasisero gitakki danbbenne kaɂemeetero ibaaddotina sisin dootisara. ");
INSERT INTO bswl_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Hayya maragaddekkeeyi kageelaye felayin ani lakkodaanddaaroya? Goorttun ani kaɂidan mankkofelero maraan miigge tameellan ku abtte?› ");
INSERT INTO bswl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","«Haanssun Yesuusa, kahaaree kalleera kahoree, kahoreenna kahaaree linnara ame.» ");
INSERT INTO bswl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesuusa Iyyerusaalemi tos seetaa giraan, tomonkko lama usukko oɂagaalssatareen kale aate beegure, ");
INSERT INTO bswl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Goorttanu noon Iyyerusaalemi tos biyaanoya, ere kaɂibaaddo tuuk'aamolkokki woyichchaalunna seera kamuse oɂagaalssisaraanun roori sisaminara, isona usu goggogooron firddinnaraan. ");
INSERT INTO bswl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Goggok'ac'ifarawun, goggoboc'irawunna goggosuyiraawun Ayizaabwun roorisi sisinaraan, usuna taseedi arrii goyikko kiinnara» ame. ");
INSERT INTO bswl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Esekkona yiis kazabddoosakkotti Aawo yiiskkiseenne wota Yesuusa tos emeettedde horee gilbbiisse sagadaa ayees koo usu eseen goggofelloo ebaatte. ");
INSERT INTO bswl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesuusana esene, «Me dootaatta?» ame. Esena; «Hikka yiiskkee lama wononnatikkaayi koo merggettaayi, koo bettettaayi goggohamas'iirawun feɂi sisi» antte. ");
INSERT INTO bswl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesuusana, «Isin kaɂebaattan lakkokassaan,» «Ani tat'aminnaro tarrakkoo t'ugga isin t'amin daanddeetane?» Ame hoosate. Isona «Iɂii daanddeennowa!» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Usuna, «Tarrakkoo t'uggatteekko golleenna t'anttaanwa, ayesuun goɂameen merggetteeyinna betetteeyi hamas's'aano goɂameen Aabbokki kakkoonɂekkaseroonyya kuwaarre ani feɂi kasisaro ayees lakkoyo» ame. ");
INSERT INTO bswl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yesuusakko oɂagaalssatareen tomonnonna hikka kakkomaalaren goorata abbilaal lamaa gutii amaraateen. ");
INSERT INTO bswl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesuusana iso dubba uumegure, «Ayizaabkokki mootijjol gosakkisoo gutii mooti goggolleerawun odonnati obariisaraanna hunnaayi kabbarisaraan laano kassanwa. ");
INSERT INTO bswl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Isin orroo ade hikkamalee laano lakkodootisaro. Ayesuun goɂameen isinii orroo kanjiinkki liin kadootatara isinuun kahandaaro halleewo. ");
INSERT INTO bswl_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Isinkko mete liin kadootatarana isinuun diyyii halleewo. ");
INSERT INTO bswl_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ere kaɂibaaddo kakkoonɂemeetera noo usuun goggohanddayinnoon anlleennon giraan handdayinna neefotteessa kamoogganun wodoo yelayi sisayin emeetera» ame. ");
INSERT INTO bswl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesuusana usukko oɂagaalssatareen Iyaarkokko been seetaa giraan gosa kamooggan usuu debee sesseete. ");
INSERT INTO bswl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Eseenna ilɂo odeyaannon ibaaddojja lama raadii hamas's'een gireen, Yesuusa esene roorano kakkomaalareen goorata; «Goottaa! Ere kadaawute; noon nenɂeyisana» amaa iyyeen. ");
INSERT INTO bswl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Gosana iso c'alɂi goggoɂamirawun hadise, iso goɂameen, «Goottaa ere kadaawute maganne noon nenɂeyisana» amaa aaloo iyyeen. ");
INSERT INTO bswl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesuusana takki ame aallee iso uume «Ani isinuun me goggoyelloo dootaattan?» ame. ");
INSERT INTO bswl_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Isona «Goottaa!» «Noo Iilɂoɂoottaani goggodeerawun dootatanna ameen.» ");
INSERT INTO bswl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesuusana isoon nenɂeyisategure Iilɂoɂoottiso dinddinegure goorsewa Iilɂoɂoottiso deenddeen, isona usu debee sesseeteen. ");
INSERT INTO bswl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Iyyerusaalemi tos gabbalamaa zayitii kabeyaara gaa takkoɂalataro wodami gutii kagiro maaman kafaage taɂamamatto banɂe goggogeeyi Yesuusa usukko oɂagaalssatareenkko lama fare. ");
INSERT INTO bswl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Haanna ame, «Isin hore kagiro maaman tos seeyeen, goggogeeteeni demeertiti too darmmeenne wota tashaanttetto isin helnnattaan, furaddeene in tos aata koyeen. ");
INSERT INTO bswl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Maayyona isinne haa muun yelattaan goɂame, ‹Gootta dootatara› ama. Goorsewa gafarranwa.» ");
INSERT INTO bswl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Hikki kakkoonlleera kahegerooyi haa amame kasegaamera goggogudaroonya. ");
INSERT INTO bswl_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«S'iyooni taɂamamatto taɂiyyerusaalemi katamaawun haa ami, ‹hikkima wonokka fayyankka leegure, demeertitinna darmmeeti gutii hamas's'eegure ku tos emeetara› amaddeen eseen segaa.» ");
INSERT INTO bswl_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Usukko oɂagaalssatareenna seetengureen Yesuusa ajaja isoon goggosiserokki malee yeleen. ");
INSERT INTO bswl_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Demeertitinna darmmeeti keenenguren sarssikisoo kademeeree bagadi gutii kayeen; Yesuusana esee gutii hamas's'ee. ");
INSERT INTO bswl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Gosakkona gamisa sarssikkisoo raadii yayeen; kakkaleenna ade ballaal tattarsheen aateen raadii lullugudeen. ");
INSERT INTO bswl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Horehaye kasessetarena haarre usuu debee sesseetaa kagire gosana, «Hoosaɂina ere kadaawute!» «Mege kawaayi kaɂemeetara usu kasommaasameya,» «Hoosaɂina ele daruurii haa amaa iyyaaren.» ");
INSERT INTO bswl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Iyyerusaalemi tonssa kakkotabare goorata kakkatamaa ibaaddo dubba, «Hikki ayyoyya?» amaa shalagaame. ");
INSERT INTO bswl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Gosana, «Hikki Galiilaayi tagitto tanazireet katamaakko kaɂemeetero kahegeroo Yesuusaya» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Esekko Yesuusa k'ulluukki min kawaa tabegure k'ulluukki min kawaayi orroo iminataanna daddalataa ogireen beese horoore, maragade oɂiggilssatarenkkokki t'arap'eezzalnna arabe odaddalataren kakkohamas's'eeran borbboono mina mina abbaabe lugudere. ");
INSERT INTO bswl_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","«Min kakki kaɂebi min amamara amame mas'aafa k'ulluukkii s'aafamera, isin addeen kakkosamaraan laga kashittaa yelttettaan» ame. ");
INSERT INTO bswl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","K'ulluukki min kawaayi orroo Iilɂo odiyaannonna naafaleessaal usu tos emeeten, usuna fayyiise. ");
INSERT INTO bswl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ayesuun goɂameen tuuk'aamolkokki woyichchaalnna seera oɂagaalssisaran Yesuusaa kafelamero baasanna, «Hoosaɂina ere kadaawuteen» amaa k'ulluukki min kawaa orroo kaɂiyyaare yiis kakkodeyaaren goorata aaloo amaraateen. ");
INSERT INTO bswl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Isona Yesuusane «Hikki yiis taɂamaro maalatta?» ameen. Yesuusana: «Iɂii» maalara ame, « ‹Yiiskona naasi kaɂiilataro yiiskotti hiɂikko galata ekkaase kaɂamaro suure lakkonabbabtteettanya›?» ame. ");
INSERT INTO bswl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Katamaakko iise beegure Bitaanya kaɂamaraan maamanii seete esee baree. ");
INSERT INTO bswl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesuusa bari bullane katamaa tos abbaabate setaa giraan uuɂee; ");
INSERT INTO bswl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Raadii giridii kagire gaa kabalasi koo deegure kakkoseero goorata baalallo kuwaarre il toonna helayiin waategure; «Goortta jiroomman kuun il aroogginno!» ame. Gaa kabalasina goorsewa angage. ");
INSERT INTO bswl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Usukko oɂagaalssatareenna kalleero deeguren saadeen, «Gaa kabalasi misii kooyikkii angagin daanddee?» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesuusana, «Ani rumminaa amara; ammano isinuun girewa lakkohedatatteen; gaa kabalasi gutii kalleero aani felano kaalaal anlleennon giraan hitta wodami hittakko, ‹Tagamigudde beke orroddee tabi› goɂantteen isinuun laarewa. ");
INSERT INTO bswl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ammanatteeddeen ebii kaɂebaattan dubba atayinattaan.» ");
INSERT INTO bswl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesuusa k'ulluukki min kaɂebi tos tabegure agaalssisaa giraan tuuk'aamolkokki woyichchaalnna kagosa jaarsolee emetengureen, «Hikka ayees dubba kakkofelatta eeki odonnatiya? Odonnatina kuyeen kasisera ayyoyya?» ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesuusana, «Aninna hoosiin too isin hoosayinnara, abbaabi iin gosegiiteen aninna hikka ayees eeki odonnati ani felaro isinuun seginnara. ");
INSERT INTO bswl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kayaannisa t'ink'ata haggekko emeetera? Daruurkkoyya muu ibaaddokkoya?» ame hoosate. Isona isi isi orro ayeesaa, «Noo ‹Daruurkkoyya› goɂaminne hayya ‹Muun ammanana waattettaan?› aminara. ");
INSERT INTO bswl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","‹Ibaaddokkoyya› goɂaminne ade gosana Yaannisa kahegeroo ame mankkoɂammanaro maraan noo gosa abssatanna» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Haanssun «Noo lakkokansso» ameen Yesuusaan abbaabeen. Usuna, aninna hikka ayees eeki odonnati ani felaro lakkoseginaro ame. ");
INSERT INTO bswl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesuusana, «Me aani laara? Babbaar lama kaɂaba ibaaddoti koo gire; kahoree ere tos seetegure, ‹Unnukkee! Hittaari tawoyinii taɂakaakiltte banɂe tos seegudde felo felina ame.› ");
INSERT INTO bswl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","« ‹Unnuna, lakkodaginaro› ame. Baaskkeessa malabatere abbaabate seete. ");
INSERT INTO bswl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","«Ade kallamikki ere tos seetegure hikkamaleewa ame, unnukkeessana, ‹Ii Aabbokki! Seerowa› ame. Ayesuun goɂameen haseennooni hese. ");
INSERT INTO bswl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","«Iso lama orrokko taɂodoo feɂi kaɂammagera eekiya?» Isona «Kahoree unnuya» ameen. Yesuusana, «Ani rumminaa amara k'arat'a okukkuyisaraanna osharmut'araan wononnati kawaa tos tabin isinkko t'ayinaraan. ");
INSERT INTO bswl_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kat'ammak'aara Yaannisa k'ulluukki raa tusin isin tos emeetera. Isin addeen lakkoɂammantteettaan, k'arat'a okukkuyisareenna osharmut'araan goɂameen ammaneraan. Isin hikka deeten giraan duuddo c'ubbokko gula galtteen lakkoɂammantteettaan ame. ");
INSERT INTO bswl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Kakkalee masuussa maala; kawoyinii irakkokki odo koo gire, iraa maraamurise ooti kaate, woyinnii kakkomiic'iraan gumbbina oshate, woyinnii oɂoorarawuun deeri madaare, esekko irakkeessa otateen obaraarawun kirayii sisegure ul kakkalee iise seete. ");
INSERT INTO bswl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kaami takkokukkuyisataraan diginni kakkogiyaatte goorata tadubanttetto ilkko k'oobakkeessa atayin usuun ohandaareen otateen obaraaran tos fare. ");
INSERT INTO bswl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","«Otateen obaraaranna usuun ohandaaran abeenguren koo boc'een, koo lagadeen, koo adeen eɂemooyi eeggeen. ");
INSERT INTO bswl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Usuna ohoreekko tootooyi orooraraan okkalee ohandaaran fare, otateen obaraaranna giddana usumaleewwa yeleen. ");
INSERT INTO bswl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Goorttanu ‹Iso adi unnukkee lakabajiiranna,› amere danbbenne unnukkeessa fare. ");
INSERT INTO bswl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","«Ayesuun goɂameen otateen obaraaranna usu unnukkeessa kakkodiyaaren goorata hikki kaɂeelnaroya, koyeen lagadigunne rittiitteessa eelinna» ameen isiɂorroo ayeeseen. ");
INSERT INTO bswl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Abeenguren kawoyinii irakko sar beesengureen usu lagadeen. ");
INSERT INTO bswl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","«Hayya kawoyinii irakkokki odo kakkoɂemeete goorata hanɂu otateen obaraaran usu misi kayelnnaro aani isinuun laara?» ");
INSERT INTO bswl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Isona «Hanɂu omeellan akamalee lagadigure kawoyinii irakko tadootisatto ilkko k'ooba goorataayi oɂabbaabarawuun okkalee otateen obaraarawun kirayii sisinnara» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesuusana, «Oginbbaraan kattuffateen eɂemo, minuun mina afarruun kadootisaro lee, Hikkana kayelera Waayya, ilɂoɂoottaanuun baasaya; amame k'ulluukki mas'aafaali kas'aafamero lakkonabbabteettanya?» ame. ");
INSERT INTO bswl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«Haanssun ani haa amara; wononnati kawaa isinkko atamigure il kayelataro gosaan sisaminara. ");
INSERT INTO bswl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Hikka eɂemoo gutii kaɂiyaara eɂebara; eɂemona iso gutii kakkoɂiyaara ibaaddo ade bututinnara.» ");
INSERT INTO bswl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tuuk'aamolkokki woyichchaalnna Farasaawiil, hikka masuussajjool kakkomaalaren goorata Yesuusa kaɂayeesara garakkisoo laano addeesen. ");
INSERT INTO bswl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ayesuun goɂameen abi shiin godooteenna gosa ade Yesuusa kahegeroo aani mankkodiyaare maraan abssateen. ");
INSERT INTO bswl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesuusa ade masuussayi ibaaddon segaano haggaɂabe, ");
INSERT INTO bswl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Wononnati kadaruure erekkeessatti haassinoon aamo kaɂekkaasatero wono aani laara, ");
INSERT INTO bswl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Wonona haassinoon kakkoonsegaatero ibaaddo kekkeesiin ohandaareen handdaa farate, ibaaddo goɂameen lakkoɂemeeyinnanno ame. ");
INSERT INTO bswl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","«Adena okkalee ohandaaran faregure oɂuumameraanne goortta aaraarinna kak'aabaan ‹Giddikkee enɂaayegure ekkaasayera kameen dubba mankkoɂekkaatero maraan haassinoon koyeen, amara ama segaa.› ");
INSERT INTO bswl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","«Oɂuumameeran goɂameen uumit diidengureen; koo ira tos, kakkalee dookki daddalayin seete, ");
INSERT INTO bswl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Oheseeran adeen ohandaaran abeenguren abboosiseen lagadeen. ");
INSERT INTO bswl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Wonona amaraategure wotaadara faregure hanɂu olagadeeraan lagadssise; katamaattisoonna eleenii gube. ");
INSERT INTO bswl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","«Esekkona ohandaareenne haa ame, ‹Kahaassinoo aamo ekkaatera, ayesuun goɂameen oɂuumameeranna aamoon odootisaraan leen mankkomutanawaateran maraan; ");
INSERT INTO bswl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kakkosesseetaran raadii biyaagudden kaheltteen ibaaddo dubba kajila aamo tos uuma› ame. ");
INSERT INTO bswl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ohandaaranna raadii beengureen kaheleen ibaaddo kaɂidanna kameellan dubba kukkuyisenguren kahaassinoo min martti ammageen. ");
INSERT INTO bswl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Wonona taɂuumanttetto martti din min orddi gotabro ibaaddoti koo kahaassinoo sarssi hasarssannoni kagiro dee. ");
INSERT INTO bswl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Haanna ame; ‹Ani kageelaataro!› kahaassinoo sarssi hasarissannooni misii hittarraa tabin daanddeete? Ibaaddotina goɂameen taɂamiɂabbaabro waate. ");
INSERT INTO bswl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","«Wonona ohandaaranne; ‹Genena luk'k'ana shiyaagudden sarre kagiro t'illinggakki mugud tos beesaddeen usu shafa, eseenna ottanna ilkko fooc'ano linnara› ame. ");
INSERT INTO bswl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Esekko Yesuusa, «Oɂuumameeranna omoogganiyyaan, oɂassaabameeraan goɂameen huc'c'arriyyaan» ame. ");
INSERT INTO bswl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Esekko Farasaawiil been seetaa giraan misimisii Yesuusa ayeeskkessayi t'oyi taɂami abinaraan makkareen. ");
INSERT INTO bswl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Isokko oɂagaalssatareenna taherodoosa unane wota Yesuusa tos fareengureen, «Kaɂagaalssisatto!» «Ati karrummii laanona raa kawaa rummii kaɂagaalssisatto laano, ibaaddo abssataa kaɂululisoon dubbana il tooyi kadiyaatto laano noo kanssowa. ");
INSERT INTO bswl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Karoomi wonolaalkokki wonowuun giira murano dootisara muu lakkodootisaroya alla noon segii? Ameen hoosaten.» ");
INSERT INTO bswl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesuusana miiggettisoo addeesere, «Isin ifissaaddolee mewuun ayeesii in c'aafin dootaattan? ");
INSERT INTO bswl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Giira tamurattaan maragade alla iin tusa?» isona t'agaraa too keneen. ");
INSERT INTO bswl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Usuna, «Hitta maragadeeyi gutii tamutatta middi taayyotta? S'uufinna ade taayyotta?» ame. ");
INSERT INTO bswl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Isona abbaabeen «Karoomi wonoyya» ameen. Usuna abbaabere «Karoomi wonokokki karoomi wonoon, kawaanna Waawuun sisa» ame. ");
INSERT INTO bswl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Isona hikka maalengureen ayeeskkeessaa saadaa iiseen seeteen. ");
INSERT INTO bswl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ese arrii goyikko kiyaano laagiro ame kaɂammanara kasodok'awil ibaaddo Yesuusa tos emeetengure haa ame hoosate; ");
INSERT INTO bswl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Kaɂagaalssisatto!» Muse; «Ibaaddoti koo ooritteessakko yiis haɂumuloon goggoye, kagooyero abbikkeessakkotti oori abbikkeessa atayigure usuun sannii hakkaye amera. ");
INSERT INTO bswl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Abbilaal todoba no dollee gitta, kahoree oori atategure yiis haɂumuloon kakkogowaare goorata abbikkessana oori yelate; ");
INSERT INTO bswl_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Hikkamalee ade kaseedikko taa todoba geeroo hikkamalee goyeen. ");
INSERT INTO bswl_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Dubbaankko haarre heleelttitina goote. ");
INSERT INTO bswl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Haanssun ese dubbaan mankkokeesantetto maraan goyikko takkiyaano arri iso abbilaal todoba orrokko ekiin oori linnatta?» ");
INSERT INTO bswl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesuusana isoon abbaabere, «Isin k'ulluukki mas'aafajjolnna hunna kawaa mankkoɂaddeesanawattettan maraan shir amattaan. ");
INSERT INTO bswl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ogoyeraan goyikko kii goɂabbaabateen daruurii kagiro erggichchaal aani linnaraan kuwaarre lakkoɂatayinaraan; lakkonakeesaminaran. ");
INSERT INTO bswl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ogoyeraan goyikko kiyaanokkokki gara Waa isinuun kaɂayeesero lakkonabbabtteettanya? ");
INSERT INTO bswl_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‹Ani kaɂabraame Hedo, kayissaak'a Hedo, kayayik'ooba Hedoya,› Haanssun Waa arddokki Hedoya kuwaarre lakkokagoyi Hedoyyo.» ");
INSERT INTO bswl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Gosana hikka kakkomaalare goorata agaalssiskkeessaa saadeen. ");
INSERT INTO bswl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesuusa Sodok'aawil abbaab tiri c'alɂisano kakkomaalareen goorata Farasaawiil raattoo kukkuɂameen. ");
INSERT INTO bswl_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Isokko koo seera kamuse kaɂagaalssisare Yesuusa c'aafin dootegure haa ame: ");
INSERT INTO bswl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Kaɂagaalssisatto! Seeral kamuse dubbakko karoorara eeki ajajaya?» ");
INSERT INTO bswl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesuusana isoon abbaabere, « ‹Goottaa Hedokkaa migitti wodanaayi, migitti neefooyi, migitti k'ofaayi geelaa›. ");
INSERT INTO bswl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Hikki ajaja kahoraarjjeenna dubbaankko karooraro ajajaya. ");
INSERT INTO bswl_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kallami ajajana hikka aani laara; hikkina ‹Ollaattaa isiɂoottaa aani geelaa› kaɂamaroya. ");
INSERT INTO bswl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Seera kamusena kahegeroolkokki agaalssis dubba hikka ajaja lamaa gutii dhaabbateen giraan ame.» ");
INSERT INTO bswl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farasaawiil kukkuɂameengureen Yesuusa haa ame iso hoosate, ");
INSERT INTO bswl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Gara kakiristoosa me aani laara? Sannii taayyoya?» ame iso hoosate. «Isona sannii tadaawuteyya» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesuusana, «Hayya daawute Ayyaana K'ulluukkinna hunnaayi muun usu, ‹Goottaa!› amara? Ame. ");
INSERT INTO bswl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","« ‹Gootta Goottakkeewun! Diinakkaa lukittaa hegelii taadaddaramiroo; «Merggetteeyi hamas's'ii amera.» › ");
INSERT INTO bswl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Haannuun Daawute, ‹Goottaa!› Ami goɂuumiro hayya Kiristoosa misii sanniitteessa liin daanddaara?» ");
INSERT INTO bswl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Haafura koonna abbaabin kadanddeera goorttun ese arrikko haggaɂabere hoosayin kajabaate maayyona laagiro. ");
INSERT INTO bswl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Esekko Yesuusa gosanenna usukko oɂagaalssatareenne haa ame ayeese, ");
INSERT INTO bswl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Seera kamuse oɂagaalssisaranna Farasaawiil Muse aani seera goggoɂagaalssisirawun odonnati isoon sisamera. ");
INSERT INTO bswl_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Haannuun iso isinuun kasegaaran dubba fela, oorayeen, ayesuun goɂameen goggoɂayeesarankki malee lakkofelaraan, iso ofelaraan felo aroofeltteen. ");
INSERT INTO bswl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Adena sidamiin tadanddaamoon sidane taɂatii shiyeenguren haan kaɂibaaddoo gutii kaaran; iso goɂameen feriinna duuddo diniin lakkodootaran. ");
INSERT INTO bswl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","«Ibaaddon mutin ameengureen feloɂoottisoo ibaaddo horee tusayin ameereene, shaashii aani bebbeedttisooyi shaataraan, malddiya aani genettisooyi shaataraan, gashekotti sharffinna eeraasataran; ");
INSERT INTO bswl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Taɂaamo banɂe, takabajjaantte banɂe, Ayihuudikokki min kaɂebi kahoraarjjee barc'uma hamas's'iin geelataran. ");
INSERT INTO bswl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Usumaleenna giyaa orroo nogodda aatanona hiɂi taɂibaaddokko ‹Kaɂagaalssisatto!› amami uumamin dootataraan. ");
INSERT INTO bswl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«Isin goɂameen ‹Kaɂagaalssisatto!› Amami lakkoɂuumaminattan, isin kaɂagaalssisara koo kaalaalya, isin dubbana abbilaalttan. ");
INSERT INTO bswl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Daruurii kagiro Aabbo koo mankkoɂabttaan maraan ulii maayyona ‹Aabbo› ami arooɂuuntteen. ");
INSERT INTO bswl_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Isinuun baalliikkisin Kiristoosa mankkolleero maraan ‹Baallii› amami arooɂuumantteen. ");
INSERT INTO bswl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Isin orrokko dubbaankko kanjjinkki kalleera isinuun kahandaaro linnara. ");
INSERT INTO bswl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Isiɂootteessa t'ok'k'i t'ok'k'isatara yeraatara isiɂoottessa kayeraasatara ade kabajjaamara. ");
INSERT INTO bswl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Isin ifissaaddolee seera oɂagaalssisattaanna Farasaawiil wononnati kadaruure tos ibaaddo goggotaboonkko ufa mankkoc'ufattan maraan aanne isinuun! Isin metekkisinuun lakkotabttaan; tabin kadootatarona lakkotabsattaan.  ");
INSERT INTO bswl_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Isin ifissaaddolee seera oɂagaalssisattaanna Farasaawiil aanne isinuun! Min kagalttanttel hawɂayi yelaa, ibaaddon mutin ebi eeraassen mankkoɂebaattan maraan kameellan firdda isin atayinattaan. ");
INSERT INTO bswl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Isin ifissaaddolee seera kamuse oɂagaalssisattaanna Farasaawiil, isin ibaaddoti koo isinkko kaɂagaalssataro yelin bekeeyinna ul gutii mankkomaraamurattan maraan iso kakkotabsseen goorata isinkko ambbaa karoore tagaannemi eleenii goggoɂiiroon mankkoyelattan maraan aanne isinuun!. ");
INSERT INTO bswl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Isin jaamassi jaamassi hore hayiteen ogeggeesattan; aanne isinuun! ‹Maayyona k'ulluukki min kawaayi goɂammate koonna lakkoyo; ayesuun goɂameen k'ulluukki min kawaa orroo kagiro work'k'ii gutii goɂammatte ade ammato giyaaran› amattaan. ");
INSERT INTO bswl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Isin jaamassiilnna gowoolee work'k'iikona work'k'ii kak'ullooyisaro k'ulluukki minkkona eekiya karoorara? ");
INSERT INTO bswl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Usumaleenna tafala banɂee kaɂammataro ibaaddon koonna lakkogiro, ayesuun goɂameen tafala banɂee kagiro jaarssoyi gutii goɂammatiraan ammatto hanɂu giyaaran amattaan. ");
INSERT INTO bswl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Isin jaamaleessa falakkona tak'ullooyisatto tafala banɂekko eekiya karoorara? ");
INSERT INTO bswl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Haannuun tafala banɂeeyi kaɂammatera kakkofalatarani gutii kagiro dubbaayi ammatara. ");
INSERT INTO bswl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Usumaleenna k'ulluukki min kawaayi kaɂammate k'ulluukki min kawaayi orroo kagiroonna ammatara. ");
INSERT INTO bswl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Daruurii kaɂammate korffinjje kawaayi gutii kahamas'eeroyinna ammatara. ");
INSERT INTO bswl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Isin ifissaaddolee seera kamuse oɂagaalssisattaanna Farasaawiil aanne isinuun! Anuugakko, deebbokkona okashekko kahoraarjjee hora Waawuun sisattan, seera orroo kagiro metekki ayees kalleero; firdda karrummii, shaagana, abddamano addeen tuffattettaan. Aanɂi haɂiisooni hinɂana feltteenwa kaɂidanye. ");
INSERT INTO bswl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Isin jaamaleessa jaamaleessa hore hayiteen ogeggeesattan! Biinɂi aani kalaaro ayees assaabtteen shafattan; gaala aani kaleyaaro ayees addeen ennegattan. ");
INSERT INTO bswl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Isin ifissaaddolee seera oɂagaalssisattaanna Farasaawiil; aanne isinuun! Kafala yaalɂana kat'ugga huu mina tasaree taalaal shashakaarattan; orroɂoottiso goɂameen saamanoyinna isiɂawodayiwaattii ammagamera. ");
INSERT INTO bswl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ati jaamakki Farasaawiti t'ayi huu kafala yaalɂana kat'ugga huu orro muc'c'isi; esekko guutikkisona kamuc'c'ime leera. ");
INSERT INTO bswl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Isin ifissaaddolee seera oɂagaalssisattaanna Farasaawiil guutikkiso barssaa t'alalame kaɂiidaro, orroɂoottiso goɂameen kagoye ibaaddokokki lefaalinna battiikki ayees dubbaa kaɂammagame hiyyeel aani mankkolaattan maraan aanne isinuun. ");
INSERT INTO bswl_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Isinna sarre ibaaddon k'ulluukki aani laattan, orroɂoottisin goɂameen ifissaaddayinna meellaneeyi oɂammagameenyyaan. ");
INSERT INTO bswl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Isin ifissaaddolee, seera kamuse oɂagaalssisattaanna Farasaawiil aanne isinuun! Kahegeroolkokki k'amal gimbbaa kak'ulloolee k'amal issaadisaa, ");
INSERT INTO bswl_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","‹Kat'awoo Odolaalkkaanikki geesii kaginne leenewa, kahegeroolkokki iigi ubanooyi isone wota lakkolaanne› amattaan. ");
INSERT INTO bswl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Hikkaniinna kahegerool lagadeen ogireen odolaalkaaniwun sannii laanokisin isi oottisin gutii atotinattaan. ");
INSERT INTO bswl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Goorttanun odolaalkisin felin ohaggaɂabeeren felo gudisa. ");
INSERT INTO bswl_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","«Isin habeessal! Yiis kajaarɂa tabaanon tagaannemi eleenkotti murittikko misii hesiin daanddeetan? ");
INSERT INTO bswl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Haannuun kahegeroo, k'arooleelnna seera oɂagaalssisaran farnnara, hinɂakko kookkoo lagadinnattan, kookkoonna suyinnattaan, kakkaleenna Ayihuudikokki min kaɂebi orroo boc'c'innattaan. Katamaa tookko katamaa takkalee tos isin iso horoornnattan. ");
INSERT INTO bswl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Haannuun k'ulluukki kaɂaabeela iigikko haggaɂabere k'ulluukki miniinna fala mankkofelatarani t'eɂee kalagaddeettan ere kaberaakiyukko taa kazakkiraasa iigi geeroo ulii gutii kaɂubatero k'ulluukki iigi dubbaan isin ohoosamattanttaan. ");
INSERT INTO bswl_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ani rumminaa amara karoorero ayees dubbaan hitti alattaan hoosamatta. ");
INSERT INTO bswl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Ati Iyyerusaalemi, kahegeroo talagadatta, ku tos ofarameeraanna eɂemooyi taɂeeggatta ati Iyyerusaalemi lukkale c'uc'uutekkisee baalkkise hegelii goggokukkuyisattoyi, ibaaddokkaa kukkuyisin miyyaa gale ani doote, isin goɂameen ii lakkoɂanttettaan. ");
INSERT INTO bswl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Goortta k'ulluukki min kaɂebikakkisin ona lii hesinnara. ");
INSERT INTO bswl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Haanssun, ‹Kagootta megee kaɂemeetara kasommaasameya› taa anttaanii gin hikka gooratakko haggaɂabre isin kallami in lakkodeetan.» ");
INSERT INTO bswl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesuusa k'ulluukki min kawaakko beegure seetaa giraan usukko oɂagaalssatareen k'ulluukki minkkokki gimbbe tusin usu tos emeeten. ");
INSERT INTO bswl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Usu goɂameen, «Hikka dubba diyaattaan?» «Ani rumminaa amara eɂemo eɂemoo gutii kaginbamera goggodiyaattanii hadarɂaamooni hikkamalee goggogirooyi kahesira eɂemo koonna laagiro» ame. ");
INSERT INTO bswl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesuusa zayitii kabeyaara gaa takkoɂalataro wodami gutii hamas's'ee giraan; usukko oɂagaalssatareen kale been usu tos seeteengureen «Alla noon segiilla» «Hikki ati kaɂamatta dubbaa goree linnara? Emeetottana alamikkotti gachchoon malaata meyya?» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesuusana abbaabere haa ame; «Maayyoona isin goggosoboonkko isiɂoorayeen.» ");
INSERT INTO bswl_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kamoogganna ani Kiristoosaya amaa megekkeeyi emeeyinnara kamoogganna shirsinaraan. ");
INSERT INTO bswl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Jereenna gara kajereene taɂayeesamatto odu isin maalinnattan; hikki ayees laano kahesooniya, halleewo kuwaarre gachcho ganaa mankkolleete maraan hikkanii isin goggoneyinokko isiɂoorayeen. ");
INSERT INTO bswl_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Gosa gosaayi gutii, wononna wonoo gutii kiinnara, banɂe banɂeeyi uɂina ulkokki aaɂaano linnara. ");
INSERT INTO bswl_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Hikki dubba goɂameen k'aniin kaɂummullakkotti rakkookko tahoraarijjeetta. ");
INSERT INTO bswl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Hassu goorata ibaaddo isin rakkoowun roorisi sisinnara, lagadinnaran; megekkeekkotti aalanttii gosa dubbaa dollee odiidantteen linnattaan. ");
INSERT INTO bswl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Hassu goorata kamooggan ammanokkisoo iisinara, koo kakkalee roorisi sisinnara; isi isiɂorroonna kookkoo diidinnaraan. ");
INSERT INTO bswl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kamooggan kat'araa kahegerool kiinnara, kamoogganna sossoyisinaraan. ");
INSERT INTO bswl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tamooggan meellanekko kakkeeyi kamooggan ibaaddokkotti geelanjje ambbal linnatta. ");
INSERT INTO bswl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tagachchoo arri taageeroon kaɂataate hassu fayyinara. ");
INSERT INTO bswl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Gosa dubbaan ato goggolleeroon hikki wononnati kawaakokki wongala alami dubbaayi lallabaaminnara, esekkona tagachchoo arri emeeyinnatta. ");
INSERT INTO bswl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Goortanun kahegeroo Daanelan goggosegaamerokki malee, ‹Kabattoyisira kameellan ayees tak'ulloyitetto banɂee kaɂaalleero kakkodeeten goorata kannabbabara hashaado!› ");
INSERT INTO bswl_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Hassu goorata ul kayihuudayi kagirana wodami tos habak'ato, ");
INSERT INTO bswl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Minii fook'ii gutii kagira maamisikki ibaaddona huu minkko atayin arooddago, ");
INSERT INTO bswl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Iraa kagira ibaaddotina sarssikkeessa atayin arooɂabbaabanno. ");
INSERT INTO bswl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ese arri heleel kafatowunna kaɂiilisaroon rakkoo taɂatii leeta. ");
INSERT INTO bswl_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Goorttanu bak'atanokkisin bat't'eessayi goorttun Ayihuudin tafoolssi arri goggolleenoonkko ebaayen. ");
INSERT INTO bswl_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Hassu goorata alami takkomet'amero arrikko haggaɂabere taa hittaari geeroo lii kakkasoon esekkona horenbbaan ese rakkoonne wota kakkoɂekkaaro kallayitti rakkoo taɂatii linnatta. ");
INSERT INTO bswl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Hassu arriil gabaabbayi waatenna ibaaddo dubba lakkohesare. Kaɂassaabamero maraan goɂameen hanɂu arrija gabaabbateen. ");
INSERT INTO bswl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Hassu goorata maayyonna hikkima Kiristoosa hittanii gira goorttun hassee gira goɂameenna arooɂabddatteen. ");
INSERT INTO bswl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kat'araa Kiristoosalnna kat'araa hegerool kiinnaraan, isoon goɂekkaate kaɂassaabamerona shirsiin amireene kaɂatii baasakki malaataalnna tusinaraan. ");
INSERT INTO bswl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Goortta ani isinuun t'aye segaara: ");
INSERT INTO bswl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Haanssun ‹Aankkima gaa orroo gira,› goɂameenna eserraa aroobbeeten, Hikkima min orroo giridii gira goɂameen arooɂabddatteen. ");
INSERT INTO bswl_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Hank'k'a mina tabiyaankko beegure mina taɂiyaan tos taageero goggohank'aaroo ere kaɂibaaddokkotti emeeto hikkamalee linnatta. ");
INSERT INTO bswl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Rak'a takkogiro banɂe dubbaa allaattil kukkuɂamara. ");
INSERT INTO bswl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Hanɂu tarrakkoo arrijjakko abbaabayire goorsewa « ‹Arriti mugud linnatta, diginninna ifakkisee tiraynnatta, Barraajjana daruurkko ubayinara, kadaruuree hunnana shalagaaminara.› ");
INSERT INTO bswl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","«Hassu goorata ere kaɂibaaddoo malaata daruurii gutii mutinnara, hassu goorata ulii tagitta aani dubbana woo woo ami ooyinnara. Ere kaɂibaaddona kadaruure duumanchchaayi orroo hunnaayinna taɂatii kabajaayi emeetaa giraan dinnaraan. ");
INSERT INTO bswl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Erggichchalna taɂatii tamalakata yaayene wota faraminnara, isona oɂassabaameraan alamii mina afarkko daruurkkotti gachchokko taa daruurkkotti gachcho geeroo ibaaddo kukkuyisinaran. ");
INSERT INTO bswl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Kabalasi gaakko hikka agaalssis agaalssayeen, ballaal gohurisiro baalallo goc'ariidiraan hassu goorata bat't'eessa gabbalamano addeesattaan. ");
INSERT INTO bswl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Hikkamaleenna hikka dubba goddeeten ese arri goc'atii gabbalamano addeesa. ");
INSERT INTO bswl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ani rumminaa amara hikki dubba taagudaroo hitti alattaan lakkoroortto. ");
INSERT INTO bswl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ulnna daruurnna roorraanwa haafurakki goɂameen suure lakkoroorro. ");
INSERT INTO bswl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Hasse arrina hasse saatii goɂameen odo kuwaarre kadaruure erggichchaal golleenna, Ere golleenna koonna laakkaso. ");
INSERT INTO bswl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kanohe geesii goggolleeroyi Ere kaɂibaaddokkotti emeeto usumalee linnatta. ");
INSERT INTO bswl_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Usu geesii beke miirɂa geegisanakko horeene Nohe markkafa tos takkotabinaro arri taageeroon ibaaddo aamaanna t'amaanna, oori atataanna keesataa goggogireenkki malee, ");
INSERT INTO bswl_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Hasse arri taageeto me emeeyinnaro haɂaddeesooni miirɂa tabekeeyi goggoɂennegamerani ere kaɂibaaddokkotti emeeto usumalee linnatta. ");
INSERT INTO bswl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Usu goorata ibaaddojja lama iraa hayinnaraan, koo ataminara koo hesinnara, ");
INSERT INTO bswl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Heleel lama riim kooyi riitayinaraan too ataminatta, takkalee hesinnatta. ");
INSERT INTO bswl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","«Goorttanu Goottakkisin takkoɂemeeyinnaro arri isin mankkokasoon maraan nabbaada oorayeen, ");
INSERT INTO bswl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Hikka wodanaa abayeen, odo minee heto hemeen maagorata emeeyinnatto addeesi girewa nabbaadi min goggosaamamonkko ooratarewa. ");
INSERT INTO bswl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ere kaɂibaaddonna isin kakkoshaadon goorata mankoɂemeeyinnaro maraan, isinna isiɂekkaasayeen oora. ");
INSERT INTO bswl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Babokkisoo isoon kakkodootisaro goorata goggosisiroo goottaa minkkeessakki ibaaddo gutii kashuumatera kaɂabdamena k'arookki kahandaara ayyoyya? ");
INSERT INTO bswl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Goottaakkeessa abbaabayi kakkoɂemeero goorata tasisanttetto hadara fele gudise giraan kahelnnara hassu kahandaara kasommaasameya. ");
INSERT INTO bswl_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ani rumminaa amara ogiraan urrawo dubbaayi gutii usu shoomiinnara. ");
INSERT INTO bswl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ayesuun goɂameen kahandaara hassu ibaaddoti kameellan golleenna usu metekkeessan, ‹goottaa adallaayinara› amaa, ");
INSERT INTO bswl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kiigure kakkalee kahandaaro jaleettessa boc'aano gohaggaɂabe t'ameen osetaaraanne wota goɂaamenna got'ame, ");
INSERT INTO bswl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Hassu kahandaarokkokki goottaa usu taɂoorannon arriinna takkoshaadon saatii emeeyigure, ");
INSERT INTO bswl_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Hassu kahandaarokki goottaakkeessa murrisinnara, it'aattessana ifissaaddoleenne wota yelinnara, ese banɂee oottanna ilkko fooc'ano linnara. ");
INSERT INTO bswl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Hassu goorata wononnati kadaruure dab abateenguren mashaashe k'op'ayin obeeraan deeleeljja tomon aani laara. ");
INSERT INTO bswl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Iso orrokko deeleeljja kenno gowwaa, deeleeljja kenno adeen k'arooleeyyen. ");
INSERT INTO bswl_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Gowoolee dab abateenguren lanbbaa minjja lakkoɂabateeren, ");
INSERT INTO bswl_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","K'aroolee goɂameen dabkkisoonne wota lanbbaa minjja t'armmusiyi abateen gireen. ");
INSERT INTO bswl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kamashaashee kakkoɂadallaatere goorata dubbana hudduro kakkodutisatte goorata huddureen. ");
INSERT INTO bswl_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Ul hemeen t'eɂe kakkolaare goorata ‹Kamaashaashee emeetara biyaa k'op'ayeen taɂamatta uumit maalssantte.› ");
INSERT INTO bswl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","«Hassu goorata deeleeljja dubba keengureen dabkkisoo hank'k'ayisaten ekkaasateen. ");
INSERT INTO bswl_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Gowoolee k'arooleenne ‹Dabkkaani bayinara laanbbaatisinkko noon sisa,› ameen. ");
INSERT INTO bswl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","«K'arooleenɂi deeleeljja goɂameen abbaabenguren no taɂabnna laanbbaa ‹Noyeenna isinuunna laanawaayin daanddaatta, seyeenddeene laanbbaa kadaddalatarokko ussun iminayeen› ameen. ");
INSERT INTO bswl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","«Laanbbaa iminayin kakkobiyaaren goorata kamashaashee emeete, ekkaasateen ogireen deeleeljjana kahaassinoo aamo takkoɂekkaatero banɂe usune wota tabeen, ufana c'ufame. ");
INSERT INTO bswl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","«Adallaaten oɂemeeteran okkalee deeleeljja, ‹Goottaa! Goottaa!› maganne ‹Noon ufa banina› ameen. ");
INSERT INTO bswl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","«Usu goɂameen, ‹Ani rumminaa amara ani isin laakkaso› ame isoon abbaabe. ");
INSERT INTO bswl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","«Goorttanu isin arri goorttun saatii mankkokasoon maraan isiɂekkaasayeen oora. ");
INSERT INTO bswl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Wononnati kadaruuree ibaaddoti koo usuun ohandaareen isi tos uumegure oɂabo urrawoɂoottessa hadara sisegure ul kakkalee seeyin kakkeero ibaaddoti aani laara. ");
INSERT INTO bswl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Odo odoo feloɂoottisokki malee koowun t'agaraa ken, koowun lama, koowun ade t'agaraa too sisegure goorsewa ul kakkalee iise seete. ");
INSERT INTO bswl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","T'agaraa ken kaɂatatera ibaaddoti goorsewa daddalatano haggaɂabere takkalee t'agaraa ken worɂe helate. ");
INSERT INTO bswl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Usumaleenna t'agaraa lama kaɂataterena t'agaraa lama worɂe helate. ");
INSERT INTO bswl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","T'agaraa too kaɂatatera goɂameen ul oshegure maragade kagoottaa k'amale. ");
INSERT INTO bswl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Ohandaaraankokki goottaa mankkoseeteroo tanjjiin adallaate emetere tasisero t'agaraa tootaayi din haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","T'agaraa ken kaɂatatere takkalee t'agaraa ken worɂe helate aate emeetegure, ‹goottaa!› Ati iin t'agaraa ken sissette, hikkima takkalee t'agaraa ken worɂe helera ame. ");
INSERT INTO bswl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","«Goottakkeessana ‹Goɂidan felttetta, ati kaɂidankki kaɂabddantte, kic'c'arkki ayeesii kaɂabddantte mankkolleete maraan kamooggan ayeesii ani ku shuuminara, goottakkaanɂi geggeloo tos tabi› ame. ");
INSERT INTO bswl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«Usumaleenna t'agaraa lama kaɂatatera kahandaara emeetegure ‹goottaa!› ati iin t'agaraa lama sissette, hikkima t'agaraa lama daddalegure takkalee t'agaraa lama worɂe helera ame. ");
INSERT INTO bswl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","«Goottakkeessana ‹Goɂidan felttetta, ati kaɂidankkina kaɂabddantte kahandaatta kic'c'arkkiin kaɂabddantte mankkolleete maraan kamooggan ayees gutii ani ku shuuminara, goottakkaanɂi geggeloo tos tabi› ame. ");
INSERT INTO bswl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«T'agaraa too kaɂatatere kahandaarokkina emeetegure ‹gootta!› Ati kawut'annon gitto kamat'aratto, kadarɂinnon gitto kakukkuyisaatto bogikaɂatii ibaaddoti laano kasowa, ");
INSERT INTO bswl_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Haannuun abssayere, ‹T'agaraattaa erree k'amalera, hikkima maragadekka› ame. ");
INSERT INTO bswl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","«Goottakkeessana abbaabere, ‹Ati kameellankkina boozzakki kahandaatta, kawut'annon giro kamat'aratarona, kadarɂinnon giro kakukkuyisataro laanokkee kasso? ");
INSERT INTO bswl_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Hayya ani kakkoɂabbaabataro goorata t'agarattee worɂene wota goggoɂataroo odaddalatarawun sisano dootisare. ");
INSERT INTO bswl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","« ‹Goorittanuu t'agaraa aatagudden t'agaraa tomon kaɂaboon sisa, ");
INSERT INTO bswl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","kaɂaboon adamara, moggaatara, kallayiikkikko goɂameen hassu kagirawa atamara. ");
INSERT INTO bswl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Hikka laɂo kallayiikki kahandaaro oottanna ilkko fooc'ano mankkogiro sarre kagiro t'illinggakki mugud tos beesa shafa› ame. ");
INSERT INTO bswl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Ere kaɂibaaddo erggichchalkkeessa dubbane wota kabajaa goɂemeete kakkabajaa korffinjjeeyi gutii hamas'iinnara. ");
INSERT INTO bswl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Gosa dubba usuu horee kukkuminnara, usuna, kafoofee idaad oreenkko goggoɂassaabarooyi, gosa koo kakkaleekko assaabinara. ");
INSERT INTO bswl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Idaad mina tamerggenne oreen mina tabetene aalliisinnara. ");
INSERT INTO bswl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","«Hassu goorata wono mina tamerggenne ogiraanne haa aminara, ‹Isin Aabbokki osommaasatera koyeen alami takkomet'amerokko haggaɂabere isinuun kaɂekkaatero wononnati eela. ");
INSERT INTO bswl_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Aalanttina ani uuɂee aamisseettan, sugubaaye t'amissettan, ani martti lee goɂemeeye k'op'atteettan, ");
INSERT INTO bswl_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ani hawɂayi gollee sarssisseettan, ani hawɂaame deetettan, shaame gollee in tos emeetteen hoosattettaan.› ");
INSERT INTO bswl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«K'ullooleenna abbaabeen haa ameen, ‹Gootta! Ati uuɂite deenne goree no ku aaminsse? Goorttun sugubaatte deenne goree no ku t'aminsse? ");
INSERT INTO bswl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Martti leete deenne goree no ku k'op'anne? Goorttun hawɂayi leete deenne goree sarssinsse? ");
INSERT INTO bswl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Usumaleenna hawɂaantte goorttun shaantte goree seenne no ku hoosanne?› ");
INSERT INTO bswl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","«Wonona abbaabere, ‹Ani rumminaa amara hinɂa huc'c'arri olleeraan abbilaaltteekko koowun kayeltteettan iin feltteettaan aaniya› ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Esekkona mina tabetene ogiraanne ade haa aminara, ‹Isin ok'angaanttettaan, durrisanna erggichchakeessawun taɂekkaattetto jiruu jiroomman eleen tos inkko kale biyaadden seeyeen. ");
INSERT INTO bswl_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Aalanttina ani uuɂee lakkoɂaamisseettan, ani sugubaaye lakkot'amissettaan, ");
INSERT INTO bswl_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ani martti lee goɂemeeye lakkok'op'attettaan hawɂayi lee lakkosarssissettaan, ani hawɂaamena shaame gollee in tos emeetteen lakkohoosatteettan.› ");
INSERT INTO bswl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«Isona abbaabereen, ‹Gootta! Ati uuɂite goorttun sugubaatte, ati martti leete goorttun hawɂayi leete, hawɂaantte goorttun shaantte deennenne goree gargaarana waanne?› ");
INSERT INTO bswl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","«Hassu goorata wono abbaabere, ‹Ani rumminaa amara hinɂa huc'c'arri olleeraankko koowun felana waattii iinna lakkofelttettaan› aminara. ");
INSERT INTO bswl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","«Hinɂa Jiruu jiroommatti murro tos, k'ulloolee adeen jiruu jiroommakki giri tos seeyinnaraan.» ");
INSERT INTO bswl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesuusa hikka ayees dubba ayeese kakkogudisare goorata, usukko oɂagaalssatareenne, ");
INSERT INTO bswl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Arri lamakko abbaabayire kafaasikkaa baala kakkabajaaminaro laano kassaanwa, ere kaɂibaaddona suwaamiin roori sisaminara» ame. ");
INSERT INTO bswl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Esekko abbaabatere katuuk'aamol woyichchaalnna jaarssa kaɂulee K'eyaafa kaɂamamaro tuuk'aamolun odonnati kaɂabokkokki awudii orroo kukkuɂameenguren, ");
INSERT INTO bswl_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Miiggeeyi Yesuusa abiinna lagadisisin makkareen. ");
INSERT INTO bswl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","«Ayesuun goɂameen gosaa orroo shalago goggokeennoonkko tabaala arri aroolleeno» ameen hiɂi too leen. ");
INSERT INTO bswl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesuusa Bitaanyaayi maarii bar kaɂabo Simoonakokki minii giraan, ");
INSERT INTO bswl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Heleelttiti too dookki aaloo awɂallo talleetetto shittoo kaɂalbbast'iroosi bilk'aade kooyi aatte Yesuusa tos gabbalantte, babo aamaa hamas's'ee giraan metekkeessa gutii shittoo kikibtte. ");
INSERT INTO bswl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Usukko oɂagaalssatareen hikka kakkodiyaaren goorata amaraateen haa ameen, «Hikki dubba darɂaano muunya?» ");
INSERT INTO bswl_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","«Hitti shittoo kamooggan maragadeeyi daddalamigudde hiyyeessan sisamin dootisatte» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesuusana iso kaɂameeraan addeesere, «Hitta heleelttiti muun rakkisattan? Ese iin felo oɂidan felttetta ame. ");
INSERT INTO bswl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Hiyyeessal maagoreenna isinne wota giraan, ani goɂameen arggetto isinne wota lakkogirnnaro, ");
INSERT INTO bswl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ese hitta shittoo maarkkeeyi gutii kikibano in k'amalkkeewun ekkaasanoyya. ");
INSERT INTO bswl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ani rumminaa amara hikki wongala mankkolallabaamaro alami dubbaa, maraamuri maaɂeeti banɂeenna ese iin kafelttetta ese shaadano lii segaaminara» ame. ");
INSERT INTO bswl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Hassu goorata tomonkko lamakko koo kalleera kaɂask'orotu Yihuuda kaɂamamara katuuk'aamol woyichchaal tos seetegure, ");
INSERT INTO bswl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","«Ani Yesuusa isinuun roorisi gosise isin addeen iin me sisinnattaan?» ame, isona bir sonddom usuun tooteen siseen. ");
INSERT INTO bswl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Hassu gooratakko haggaɂabere Yihuuda Yesuusa roorisi kakkosisiro kaɂekkaaro goorata dootaa gire. ");
INSERT INTO bswl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kababoo baalan tahoraarjjee arri Yesuusakko oɂagaalssatareen usu tos emetengureen «Ati kafaasikkaa kita kahemeene goggoɂaanttoon eetii no goggoɂekkaansson dootaatta?» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Usuna, «Katamaa tos seeyenguddeen isinne kaɂesele ibaaddoti koonne, ‹Kaɂagaalssisara gooratakki gabbalamera inkko oɂagaalssataranne wota kafaasikkaa baala minkkaayi kabajaayinnara amara ama ame.› » ");
INSERT INTO bswl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yesuusakko oɂagaalssataranna usu goggoɂajajeerokki malee kafaasikkaa baalakkokki kita ekkaasen. ");
INSERT INTO bswl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ul hemeen kakkolaare goorata Yesuusa tomonkko lama ofarameeraanne wota babo aamin hamas's'ee. ");
INSERT INTO bswl_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Yesuusa aamo gutii giraan, «Ani rumminaa amara isin orrokko koo in roorisi sisinnara» ame. ");
INSERT INTO bswl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Isona aaloo yaadengureen toottoolli «Goottaa! Ani leewuna?» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesuusana abbaabere, «In roorisi kasisinara iinne wota yaalɂaayi gene kadagissateroya. ");
INSERT INTO bswl_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ere kaɂibaaddo usu maraan goggos'aafameroyi goyinara, ayesuun goɂameen ere kaɂibaaddo roorise kasisaroon hassu ibaaddotin aanne! Usu ibaaddoti haɂalannooni hesi girewa kaɂidanye» ame. ");
INSERT INTO bswl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Roorisi kasisinara Yihuudana, «Kaɂagaalssisatto! Ani leewuna?» ame, Yesuusana, «Ati kaɂamatta» ame. ");
INSERT INTO bswl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Iso aamaa giraanna Yesuusa babo keesegure sommaasate ibise aategure usukko oɂagaalssatarawun sisaa, «Ahɂaay atayeen aama, hinɂi sooɂootteyaan» ame. ");
INSERT INTO bswl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Esekko t'ugga keese Waa galategure, usukko oɂagaalssatareewun sisaa haa ame, «Isin dubbana hitta t'uggakko t'ama, ");
INSERT INTO bswl_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kamooggankokki c'ubboon shaaga maraan kaɂubayinara ammato oɂusubi kaɂaddeesisara iigikki hikkaya. ");
INSERT INTO bswl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ani goɂameen haa amara Aabbokkeekki wononnatii isinne wota hikka kaɂusub kawoyinii t'amo takkot'aminaro arri taageeroo hitta t'uggakko horenbbaan kawoyinii t'amo lakkot'aminaro.» ");
INSERT INTO bswl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mazamuri zammareen abbaabateenguren zayitii kabeyaara gaa takkoɂalataro wodami tos been. ");
INSERT INTO bswl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesuusa ade, «Hitta hemeen isin dubba in kakayinnattaan, ‹Ani kafoofee basinnara kafoofamara idaandda darɂaaminnara amame k'ulluukki mas'aafaa s'aafamera.› ");
INSERT INTO bswl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","«Ayesuun goɂameen ani goyikko kakkokkee goorata isinkko t'ayi Galiila tos seeyinnara.» ");
INSERT INTO bswl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","P'et'iroosana abbaabere, «Kakkalee dubba aalanttittaayi ku iisi goseetena ani goɂameen duuddo ku iisi lakkoseero» ame. ");
INSERT INTO bswl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesuusana P'et'iroosane, «Ani rumminaa amara hittameen lukkale haɂoyinon giraan ati in seed gali kakayinnatta» ame. ");
INSERT INTO bswl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","P'et'iroosa goɂameen «Ani kuunne wota goyin kadootisaro golleenna suure ani ku lakkokakayinaro» ame. Kuunɂi usukko oɂagaalssatareen dubbana usumaleewwa ameen. ");
INSERT INTO bswl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Esekko abbaabatere Yesuusa usukko oɂagaalssatareenne wota Geetesemanii taɂamamatto banɂe too seete, isone «Ani aarraa seeyigure taa ebaaroyi isin hittanii gira» ame. ");
INSERT INTO bswl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Seetaa giraan P'et'iroosana yiis kazabddoosa lama wota aate seete, gaddanna c'annak'aamano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Esekkona «Ani taaggooroo aaloo c'annak'aamera, inne wota nabbaada hittanii gira» ame. ");
INSERT INTO bswl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Abaraanttii ship'p'imegure hore hore bebbeedii ul oyere «Aabbokkee! Hitti tarrakkoo t'ugga inkko habuyito, ayesuun goɂameen feɂittee malee halleennoni giraan feɂittaa malee halleewo» ame ebaate. ");
INSERT INTO bswl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Esekko abbaabategure usukko oɂagaalssataran tos goɂemeero ohuddureeraan deegure P'et'iroosane, «Duuddo iinne wota saatii toonna nabbaadi girana waatteen?» ");
INSERT INTO bswl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","«C'aafiti orroddi goggotaboonkko nabbaada ebaayen, ayyaana ekkaate gira, soo goɂameen hararaan» ame. ");
INSERT INTO bswl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ade kallami seetegure «Aabbokkee! Hitti tarrakkoo t'ugga ani hat't'amoon giraan tarooron golleete feɂittaakki malee halleeto» ame ebaate. ");
INSERT INTO bswl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kallami abbaabayi kakkoɂemeero goorata hudduro mankkogeetette maraan huddureen ogiraan dee. ");
INSERT INTO bswl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Giddanna iso iisegure ade kaseedi seetegure hore kaɂebaatere ebi ade ebaate. ");
INSERT INTO bswl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Esekkona usukko oɂagaalssatareen tos abbaabate emetere, «Giddanna haraffintteen huddurtteettaan? Hittima saatii gabbalanttetta, ere kaɂibaaddo c'ubbaaleyikkotti geneyi roori sisaminara. ");
INSERT INTO bswl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kiyaa seenno, roorisi kasisinara emeetaa gira!» ame. ");
INSERT INTO bswl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesuusa ayeesaa giraan tomonkko lamakko koo kalleera Yihuuda katuuk'aamol woyichchaalnna taɂulee jaarsoleekko ofarameeraan shiifana duullaa kaɂabera ibaaddo kamoogganna wota gire. ");
INSERT INTO bswl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yesuusa roorise kasisera Yihuudana, «Ani kaɂangatara usuya aba» ame malaata sise mankkogire maraan, ");
INSERT INTO bswl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Goorsewa Yesuusa tos seetegure, «Kaɂagaalssisatto! Nogodda iiddegitto» ame usu angate. ");
INSERT INTO bswl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesuusana, «Ani kageelataro! Takkoonɂemettetto haajaa gussa» ame, hassu goorata ibaaddo gabbalamegure Yesuusa abe shiye. ");
INSERT INTO bswl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yesuusanne wota kagirekko koo gene keesegure shiifayi tuuk'aamolkokki woyichchatiin kahandaarekotti nebe goose. ");
INSERT INTO bswl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesuusana, «Shiifakkaa kofoo orro tabisi,» «Shiifa kamiɂatara shiifaayi gowaara, ");
INSERT INTO bswl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Godootise ani Aabbokkee goɂebaaye kuma kamooggani katootamiro erggichchaal iin kafaroon aani laara? ");
INSERT INTO bswl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Hikki haa gollee ade k'ulluukki mas'aafaa linnara amame kas'aafamera misii gudatara?» ame. ");
INSERT INTO bswl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Hassu goorata Yesuusa gosane, «Shittaa abin kaɂemeetaro ibaaddo aani shiifaalnna duullaal abtteendden in abin emeetteen? Arggetto k'ulluukki min kaɂebii hamas's'ee ani isin goɂagaalssisare lakkoɂabttetteen. ");
INSERT INTO bswl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ayesuun goɂameen hikki dubba kakkonlleera k'ulluukki kahegeroolkokki mas'aafayi kas'aafamera goggogudaroonya» hassu goorata usukko oɂagaalssatareen dubba usu iiseen bak'ateen. ");
INSERT INTO bswl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Hassu goorata Yesuusa kaɂabera ibaaddo seera kamuse oɂagaalssisaranna jaarssa kaɂulee kukkume takkogire tuuk'aamolkokki woyichchati K'eyaafa tos usu geesen. ");
INSERT INTO bswl_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ayesuun goɂameen P'et'iroosa fakkimegure katuuk'aamol woyichchaatikokki awud taageeroo usu debee sesseetaa gire, orroddee tabegure ayees talinnaro din oɂooraneenne wota hamas's'ee. ");
INSERT INTO bswl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Hassu goorata tuuk'aamolkokki woyichchatina kaɂayihuudi shonggoo dubba Yesuusa lagadisisin kat'araa ato dootaa gireen, ");
INSERT INTO bswl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kamooggan kat'araa atojool goɂemeetena ato kalleero lakkohelateeran, danbbenne goɂameen ibaaddo lama gabbalamere, ");
INSERT INTO bswl_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Hikki ibaaddoti k'ulluukki ‹Min kaɂebi basigure arri seed orroo abbaab madaarin daanddaara› amera» amaa ayeeseen. ");
INSERT INTO bswl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Hassu goorata tuuk'aamolkokki woyichchati kee aalleegure, «Hikki ibaaddo kaɂatoteero dubbaan koonna abbaab lakkoɂabbaabattoya?» ame. ");
INSERT INTO bswl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yesuusana goɂameen c'alɂi ame. Tuuk'aamolkokki woyichchati Yesuusane, «Ani ku Arddokki mege kawaayi abera, ati Kiristoosa ere kawaa golleete noon segii?» ame. ");
INSERT INTO bswl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesuusana, «Atiwa issii anttetta, ayesuun goɂameen isin dubbana segiiro hittakko horenbbaan ere kaɂibaaddo hunna kawaakkotti merggee hamas'iire kadaruure dumanchaayi orroo emeetaa giraan dinnattaan» ame. ");
INSERT INTO bswl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Hassu goorata tuuk'aamolkokki woyichchati sarssikkeessa fiilegure, «Hikki Waa habaarera; hikkakko kakkalee misikki ato dootisara? Usu Waa habaaraa ayeesano isinwa maaltteettan ame. ");
INSERT INTO bswl_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Me aani isinuun laara?» ame. «Isona goyin dootisara» ameen abbaabeen. ");
INSERT INTO bswl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hassu goorata bebbeedtteessaa hanc'c'ufe tufaa balabaanjjoo basaa, ");
INSERT INTO bswl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«Kiristoosa! Ayyoyya ku kabase? Alla hegero ayeesi» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Esekko abbaabatere P'et'iroosa katuuk'aamol woyichchaatikokki awudii orroo hamas's'ee giraan diyyiti too usu tos gabbalanttegudde «Ati kagaliila Yesuusane wota gittewa» antte. ");
INSERT INTO bswl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Usu goɂameen, «Ati maamme amatto ani laakkaso amaa dubbaayi horee kakate.» ");
INSERT INTO bswl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Awudkko kakkobeyaaran karrane bin seetaa giraan takkalee diyyiti P'et'iroosa deetegudde esee kagire ibaaddowun «Hikki ibaaddoti kanaazireti Yesuusane wota gire» antte. ");
INSERT INTO bswl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","P'et'iroosaan kaɂammatoo haafuraayi «Hikka ibaaddoti ani laakkaso» amaa kallami kakate. ");
INSERT INTO bswl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Abaraan gac'c'imegure esee aallee kagire ibaaddo P'et'iroosa tos gabbalameengureen, «Ayeeskkawa addeesisara, ogiraan atina isokko kootta» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Usuna ammataanna k'angaa «Ani usu ibaaddoti lakkokaso» ame. Hassu goorata lukkalena oye. ");
INSERT INTO bswl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Goorsewa, P'et'iroosa «Lukkale haɂoyinon giraan seed gali ati in kakayiinnatta» ame. Yesuusa kaɂayeesera haafura usuun k'alli ame. P'et'iroosana sarddee beegure yururu ame oote. ");
INSERT INTO bswl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Bari babbaris katuuk'aamol woyichchaalnna jaarssa kaɂulee dubba Yesuusa tayeli lagadiraan makkareen. ");
INSERT INTO bswl_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Yesuusa shiyeen geesenguren karoomi mooti P'ilaat'oosaan rooriseen siseen. ");
INSERT INTO bswl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Roorise kasisera Yihuudana Yesuusa goyin firddaamano kakkodiyaare goorata gaabbee. Bir sonddom katuuk'aamol woyichchaalunna taɂulee jaarsoleewun abbaabe sisegure, ");
INSERT INTO bswl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","«Ani k'ulluukki ibaaddoti goyiin roorise mankkosisero maraan baasera» ame. Isona «Hayya noo me katabisara, hassu yaadakkaayya» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Haannuun Yihuuda bir k'ulluukki min kaɂebii orroo shafe iise beegure isi sullaate goye. ");
INSERT INTO bswl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Katuuk'aamol woyichchaalnna ese bir aateenguren, «Hitti bir dookki kaɂiigeekkotti mankkoleetetto maraan min kawaawun lugudin seerakkaani feɂi lakkosisaro» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Makkarenguren martti takkok'amallaan tak'amal banɂe goggolleeton usu maragadee errekko huu kamet't'arokkotti banɂe imineen. ");
INSERT INTO bswl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Haannuun hasse banɂe hittaari taageetoyi, «Ul kaɂiigee» amamatte uumamatta. ");
INSERT INTO bswl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Hikka garaayi kahegeroo Ermaasayi, Yihuudaan muraa goggolleeto, Gosa kaɂisiraɂeel taherregero «Bir sonddom atateen. ");
INSERT INTO bswl_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Goottanna iin goggoɂajajeerokki malee errekko huu kamet't'arokkotti banɂeen mureen» amame kasegaamera gudate. ");
INSERT INTO bswl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Hassu goorata Yesuusa karoomi mooti P'ilaat'oosa horee aallee, karoomi mootinna «Ati kaɂayihuudi Wonotta?» ame hoosate, Yesuusana «Ati goggoɂamattooya» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Katuuk'aamol woyichchaalnna jaarsolee gomootenna usu ade koonna abbaab lakkosise. ");
INSERT INTO bswl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Hassu goorata P'ilaat'oosa «Miyyaa ato keenen atoteeran lakkomaalattoya?» ame. ");
INSERT INTO bswl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yesuusa goɂameen karoomi mootinna aaloo taa mamiron kamootamero mooton haafura koonna suure lakkoɂabbaabe. ");
INSERT INTO bswl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Karoomi mootinna gosa kafaasikkaa tabaala arrii goggofuramiroon kadootataro odo koo shaanokko kakkofuraro woga abanaaye. ");
INSERT INTO bswl_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Hassu goorata baasi felanooyi kaɂaddeesamere Barbaane kaɂamamara kashaamere koo gire. ");
INSERT INTO bswl_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Gosa kukku kakkoɂamare goorata P'ilaat'oosa, «Barbaanekkona, Kiristoosa kaɂamamaro Yesuusakko, ayyo ani goggofurroon dootaattan?» ame. ");
INSERT INTO bswl_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","P'ilaat'oosana hikka kakkoonɂamera iso k'anaateen rooriseen kasiseraan mankkoɂaddeesare maraanya. ");
INSERT INTO bswl_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","P'ilaat'oosa kafirdda arjjaata gutii hamas's'ee giraan ooritteessa, «Aalantti teessaa hemeenkka hisillooyi rakkoo tameellan ani mankkodeero maraan hassu k'ulluukki ibaaddoti gutii koonna ayees goggoyelonkko kaɂamaro handdaa usuun fartte.» ");
INSERT INTO bswl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ayesuun goɂameen katuuk'aamol woyichchaalnna taɂulee jaarsoleel Barbaane goggofuramiroo Yesuusa adi goggogooron gosa P'ilaat'oosa goggohoosaroon kekkeesaa gireen. ");
INSERT INTO bswl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Karoomi mootinna, «Iso lamakko ayyo ani goggofurroo dootaattan?» ame kallami hoosate. Isona, «Barbaane» ameen abbaabeen. ");
INSERT INTO bswl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","P'ilaat'oosana, «Hayya Kiristoosa kaɂamamaro Yesuusa misi yella?» ame. Iso dubbana «Hasuwaamo» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","P'ilaat'oosana, «Muun? Me tameellan felera?» ame hoosate. Isona adeen aaloo okkaa, «Hasuwaamo» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","P'ilaat'oosana okko adamano kuwaarre koonna ayees kagarggaaroon laano deegure «Ani hikka ibaaddotikkokki iigikko balchchaya,» isin isiɂoottisin oorayeen, «Goorttanu odonnati kakkisiniya» amegure beke keensisegure gosa horee genennoɂootteessa aale. ");
INSERT INTO bswl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Gosa dubbana, «Iigikkeessa noyenna yiiskkaani gutii halleewo» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hassu goorata Barbaane fure gafarere, Yesuusa ade boc'iisere goggosuwaamiro roorise sise. ");
INSERT INTO bswl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Esekko karoomi mootiikokki wotaadara Yesuusa kamootiti awud tos geesen, wotaadaral dubba Yesuusa maraamuri goggoɂaalliroon kukkuyise. ");
INSERT INTO bswl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Sarssikkeessana k'aarengureen heelatti kaabbaa sarssiseen, ");
INSERT INTO bswl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Eɂeen mammaren kallachcha feleengureen metekkeessayi gutii kayeen, taleemma dama gene tamerggeeyi absiseen horee gilbbisengureen «Ayihuudikokki Wono! Nogodda kuun halleeto» amaa k'ac'c'ifataren. ");
INSERT INTO bswl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Hanc'c'ufe usuu gutii tufaa talleemma dama genekko aatenguren talleemma damaayi metekkeessa abbaabeen abbaabeen baseen, ");
INSERT INTO bswl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","K'ac'c'ifateen abbaabateenguren heelatti kaabbaa k'aarengureen kahoree sarssikkeessa aateen sarssiseen, suyiinna abeen seeteen. ");
INSERT INTO bswl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Abeen seetaa giraan Simoona kaɂamamare kak'ereena ulkokki ibaaddoti heleengureen, masik'alii goggosidiroo hunnoomen. ");
INSERT INTO bswl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Fureenna, Buk'k'e tamete talleetetto Golggottaa taɂamantetto banɂe kakkogiyaaren goorata, ");
INSERT INTO bswl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kaɂokokootaro kookone wota kaledamero kawoyinii t'amo usu goggot'amiro siseen, usu goɂameen hiɂii abe deere t'amin lakkodoote. ");
INSERT INTO bswl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Yesuusa suyeen abbaabateenguren it'aa beesaten sarssilkkeessana hedeedameen, ");
INSERT INTO bswl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Eseenna hamas's'een ooraa gireen. ");
INSERT INTO bswl_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","«HIKKI KAɁAYIHUUDI WONO YESUUSAYA» taɂamatto tamooto s'uufii metekkeessakko guntte kayeen. ");
INSERT INTO bswl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Shittoolee lama koo mina tamerggenne, koo mina tabetene usune wota suyeen. ");
INSERT INTO bswl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Raanne karoorara ibaaddo aaloo usu habaaraa k'ac'c'ifataa, ");
INSERT INTO bswl_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","«K'ulluukki min kaɂebi basigudde arri seed orroo kamadaarinnatta, alla isiɂoottaa haasa? Ere kawaa golleete alla masik'alii guukko dagi» amaa gireen. ");
INSERT INTO bswl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Usumaleenna tuuk'aamolkokki woyichchaal, seera oɂagaalssisaranna jaarsoleenne wota leenguren k'ac'c'ifataa haa amaa gireen, ");
INSERT INTO bswl_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Kakkalee fayyisara» isiɂoottessa ade fayyiisayin lakkodaanddaaro, usu kaɂisiraɂeel wono gollee gidda mask'aliikko hadage, noonna ammaninanna. ");
INSERT INTO bswl_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Usu Waayi ammanatara ani ere kawaayya amaa mankkogire maraan, alla Waa usu kageelaataro gollee gidda hahaaso. ");
INSERT INTO bswl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Usune wota osuwaameereen shittooleenna usumaleewwa habaar kamooggan habaararen. ");
INSERT INTO bswl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Saatii lekko haggaɂabere taa saatii saagaal geeroo ul dubbaa gutii mugud lee. ");
INSERT INTO bswl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Saatii saagalli Yesuusa yaayetteessa t'ok'k'isere «Elohe Elohe laammasebek'etaani?» amaa okkee. Fureenna «Hedokkee! Hedokkee! In muun iisse?» amanoyya. ");
INSERT INTO bswl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Esee aalleen ogiraankko kookkoo maalengureen «Eelaasa uumara» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Goorsewa iso orrokko koo tiyaa emeetegure isfoonji aategure kaɂokokootaro t'amo kawoyinii orroddeese nakkaregure isfoonji leemma birt'ee kayegure Yesuusa goggot'amiro sise. ");
INSERT INTO bswl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Okkaleenna adeen «Isaaga alla Eelaasa emeeyigure usu gohaasinnaro dinnanna» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesuusa ade kallami yaaye t'ok'k'ise okkeegure neefo beete. ");
INSERT INTO bswl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hassu goorata k'ulluukki min kawaakkotti goggolo elekko taa hegel geeroo banɂe lama bee fiilame, ulnna shalagaame, eɂemoolnna bebelɂee, ");
INSERT INTO bswl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Hiyeelnna baname, goye kagire kamooggan k'ullooleenna keen, ");
INSERT INTO bswl_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Hiyeelkko beeguren goyikko kiyaano kayesuusakko abbaabatere k'ulluutti katamaa Iyyerusaalemi tos tabeenguren kamooggan ibaaddon muteen. ");
INSERT INTO bswl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kabooloo woyichchaalnna usune wota Yesuusa ooraa kagire wotaadaral ul shalagaamanona kalleero ayees dubba kakkodiyaaren goorata aaloo abssateenguren, «Hikki ogiraan ere kawaayye» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Galiilakko oɂemeeteraanna Yesuusaan kadootisaro ayees handdayin debee kasessetare heleel kamooggan ayees tallinnaro diyaa fakkimeen usu gobobii gireen. ");
INSERT INTO bswl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Iso orrokko kamegidella ulkotti Mayiraamene tayayik'oobanna tayoosefa Aaye Mayiraamenee gireen. Usumaleenna oori tazabddoosanneyeen. ");
INSERT INTO bswl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ul hemeen kakkolaare goorata Yoosefa kaɂamamara dureessati Armaatiyasi taɂamanaa katamaakko emeete, usuna ade Yesuusakko kaɂagaalsatareye, ");
INSERT INTO bswl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Usuna P'ilaat'oosa tos seetegure rees kayesuusa ebaate, P'ilaat'oosana usuun goggosisirawun ajajee. ");
INSERT INTO bswl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yoosefana rees aategure gashe taɂusubii mare iidise. ");
INSERT INTO bswl_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Eɂemokko k'orame kaɂoshamere gumbbi orroo k'amale, esekkona eɂemo kanjiinkki otottoolisegure kak'amal gumbbikkotti hiɂi duudise seete. ");
INSERT INTO bswl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Hassu goorata kamegidella ulkotti Mayiraamena takkalee Mayiraame k'amali horee hamas's'een gireen. ");
INSERT INTO bswl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tallami arri tayaasuma mankkolleete maraan katuuk'aamol woyichchaalnna Farasaawilne raattoo P'ilaat'oosa tos seetengureen haa ameen, ");
INSERT INTO bswl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","«Goottaa! Hassu kasossoyisara t'aye neefone giraan ‹Taseedi arri goyikko kiinnara› kaɂamara noon k'alli amera. ");
INSERT INTO bswl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Haannuun Yesuusakko oɂagaalssatareen rees heti aatiguren gosane, goyikko keera ami goggoɂayeesonko k'amalkkeessa taa arri seed geeroo goggoɂooramiro ajajii, goorttun kahaaree sossowaano kahoreekko karoore leera.» ");
INSERT INTO bswl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","P'ilaat'oosana, «Kaɂoorro isin abttaanwa seeyenguddeen kakkassaan raadii oorissisayeen» ame. ");
INSERT INTO bswl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Isona seetengureen k'amal gutii maatama kayeengureen kaɂoorro aalliseen. ");
INSERT INTO bswl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ayihuudin tafoolssi arrikko abbaabatere tawoggaa arri bari bullane kamegidella ulkotti Mayiraamena takkalee Mayiraame k'amal din seeteen. ");
INSERT INTO bswl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Derɂa kaɂatii ulkokki aaɂaano lee, kagootta erggichchatina daruurkko dagegure k'amal tos seete eɂemo otottoolisegure gutii hamas's'ee. ");
INSERT INTO bswl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Taɂerggichcha bebbeedtteessana hank'k'a aani tahank'aatto, sarssikkeessana beleetti aani gumaarakkiye. ");
INSERT INTO bswl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Oɂooraneenna erggichchati absatanakko kakkeeyi harɂeen kagoyero ibaaddo aani leen. ");
INSERT INTO bswl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Erggichchatina heleeljane haa ame, «Isin arooɂabsatteen isin kasuwamere Yesuusa kadootattaan ani kasowa, ");
INSERT INTO bswl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Haannuun hittanii lakkogiro, goggoɂayeeseroyi keera, koyeen usu takkok'amalamere banɂe diyaa. ");
INSERT INTO bswl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Gidda saama seeyenguddeen usukko oɂagaalssatareewun Yesuusa goyikko keera, isinkko t'ayi Galiila tos seeyinnara goorttanun ani segeera.» ");
INSERT INTO bswl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Heleeljana abssiinna geggelooyi ammagameengureen Yesuusakko oɂagaalssatarawun segin aaloo tiyaa tak'amal banɂekko iiseen seeteen. ");
INSERT INTO bswl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Goorsewa Yesuusa iso helegure, «Nogoddaa gittaane» ame. Isona Yesuusa tos gabbalameengureen lukitteessa abateen sagadeen. ");
INSERT INTO bswl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesuusana «Arooɂabsatteen seeyenguddeen Galiila tos goggoseerawun abbilaaltteewun segaa, esee in dinnattaan» ame. ");
INSERT INTO bswl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Heleeljana raadii seeto gutii giraan oɂooraneenkko kookkoo katamaa tos beengureen kalleero dubba katuuk'aamol woyichchaalun segeen. ");
INSERT INTO bswl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Katuuk'aamol woyichchaalnna jaarsoleenne wota kukkuɂameen makkarenguren wotaadaran maragade kamooggan isoo sisaa haa ameen; ");
INSERT INTO bswl_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","«Noo huddurnne giraan ‹Usukko oɂagaalssatareen hemeen emetengureen nookko heteen ama ameen.› ");
INSERT INTO bswl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Hitti odu mootii dollee gomaalssanttena suure noo gachoo addeesinssa, koonna kameellan ayees isin goggogeennonkko yelnnowa» ameen. ");
INSERT INTO bswl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Wotaadaralna maragade atateengureen goggoɂajajaameran malee yeleen, hitti jirtti hittaari gin Ayihuudi dollee gambbantte darɂaantte. ");
INSERT INTO bswl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Esekkona tomonkko koo Yesuusakko oɂagaalssatareen Galiilaayi taggitto Yesuusa isoon tatusero wodami tos seeteen. ");
INSERT INTO bswl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Usu kakkodiyaaren goorata sagadeen, kookkoo adeen hedateen. ");
INSERT INTO bswl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesuusana usukko oɂagaalssatareen mankkogireen tos emeetegure, «Odonnati dubba daruurnna ulii iin sisamera, ");
INSERT INTO bswl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Haannuun seeyeenddeen gosa dubba Odooyi, Ereyinna Ayyaana K'ulluukkokki megeeyi t'ammak'aa inkko oɂagaalssataran yela. ");
INSERT INTO bswl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ani isinuun kasisero ajaja dubba goggoɂooranawun agaalssisa, aninna alamikkotti gachcho taageeroo arggetto isinne wota gira» ame.");
INSERT INTO bswl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hikki ere kawaa kayesuusa Kiristoosakokki wongala kahoreeya. ");
INSERT INTO bswl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kahegeroo Isiyaasaa, «Raa kaɂekkaasiro kahandaarokakkee kukko t'ayi ani farrowa amame s'aafamera. ");
INSERT INTO bswl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","«Hikkina; ‹Raa kagootta ekkaasa, shakaara iidisa amaa gaadi taɂiyyaatte yaaye.› » ");
INSERT INTO bswl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Haanssun kat'ammak'aare Yaannisa k'alullattokki ulii t'ammak'aanna c'ubbokko haheso amamanoon gula galanokkokki t'ink'ata lallabaa emeete. ");
INSERT INTO bswl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yihuudakona kaɂiyyerusaalemi maaman dubbakko ibaaddo raattoo usu tos seetere c'ubbokkisookko gula galaa laga kayorddaanosi gene tayaannisa t'ammak'ameen. ");
INSERT INTO bswl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Sarssi kayaannisa ogorro ogaalakko kafelameroye; mooɂiina gii muwaatare, babokkeesana kenttefarrona malab kagaadoye. ");
INSERT INTO bswl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Lallabaanokkeessana, «Ani hussimi keferroɂoottessakokki shaano furin kakkodaanddenoon inkko karoorara inkko haarre emeetara. ");
INSERT INTO bswl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ani isin bekee t'ammak'inara, usu goɂameen Ayyaana K'ulluukkii t'ammak'inara kaɂamareya.» ");
INSERT INTO bswl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Usu goorata Yesuusa tagaliila katamaa talleetetto Naaziretikko emetere laga kayooriddanosi gene tayaannisa t'ammak'ame. ");
INSERT INTO bswl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Bekekko kakkobiyaare goorata daruur bananttedde Ayyaana K'ulluukki arabe aani usu gutii dagaa giraan dee. ");
INSERT INTO bswl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ani kageelaatara «Erekki atitta kuyee geggelaatara taɂamatte yaaye daruurkko maalssantte.» ");
INSERT INTO bswl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Goorsewa Ayyaana K'ulluukki gaa tos usu k'ajeelise. ");
INSERT INTO bswl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","S'alayeenna c'aafamaa arri afarttam gaadi adallaate sulaalene wota gire, erggichchaalnna usuun handdayeen. ");
INSERT INTO bswl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yaannisa minkashaano kakkotabare goorata Yesuusa wongala kawaa lallabaa ul kagaliila tos seetere, ");
INSERT INTO bswl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","«Goorata geera; wononnati kawaa gabbalamera; c'ubbokko gula gala; wongalaa ammana!» amaa lallabaa gire. ");
INSERT INTO bswl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesuusa labu tagaliila ene mare rooraa Simoonanna abbikkeessa Indiraasa kunɂub oɂabatareen mankkoleen maraan; maarrabi beke lugudataa giraan dee. ");
INSERT INTO bswl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesuusana «Indebee sesseeyeen; ibaaddo oɂabttaan yelnara» ame. ");
INSERT INTO bswl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Isona banneewa maarrabi tattisoo iiseen usu debee sesseeteen. ");
INSERT INTO bswl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Esekko abaraan ship'p'i goggoɂamee; kazabddoosa ere Yayik'oobana abbikkeessa Yaannisa wolabo hamas's'eereen maarrabitisoo ekkaasataa giraan deegure, ");
INSERT INTO bswl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Banneewa iso uume, isona Aabbokkisoo Zabddoosana maragadewun ofelareene wota wolabo gutii lugudeen iiseen usu debee sesseeteen. ");
INSERT INTO bswl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Esekkona kak'ifirenaahoomi maaman tos seeteen, Yesuusa banneewa Ayihuudin tafoolissi arri Ayihuudikokki min kaɂebi tabere agaalssisano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Seera kamuse oɂagaalssisaran aani halleenon giraan odonnati kaɂabo aani agaalssisanoyi gosana agaalssisanokkeessa saade. ");
INSERT INTO bswl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Usu goorata Ayihuudikokki min kaɂebi orroo kagire battiikki ayyaana kakkogire ibaaddoti koo haa amaa okkee. ");
INSERT INTO bswl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Kanaazireti Yesuusa, ati nookko me dootatta? No baasin emeetetta? Ati ayyotto ani ku kasowa, ati kawaa k'ulluukkitta.» ");
INSERT INTO bswl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesuusana, «C'alɂi amina, usukkona beena!» ame hadise. ");
INSERT INTO bswl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Battiikki ayyaana ibaaddoti aaloo ulle boc'ee abbaabatere esekko iyyaa bee. ");
INSERT INTO bswl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Gosa dubba saadanoyi, «Hikki ayees meya? Odonnati kaɂabo kaɂusub agaalssisano laanoya! Battiikki ayyaanajjol usu goɂajajiro isona biyaaran!» amaa isiɂorroo isiɂisi hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Banneewa ataankkeessa kagaliila gobobii kagiro ul dubbaa addeesame. ");
INSERT INTO bswl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Banneewa min kaɂebi kaɂayihuudi goggobeenii; Yayik'oobane Yaannisane wota min kasimoona kaɂindiraasa tabeen. ");
INSERT INTO bswl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tasimoona soddo maar kagubaro hawɂaami hawɂaamaa huddurtte gitte; garakkiseenna Yesuusaan segeen. ");
INSERT INTO bswl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Haanssun usuna ese mankkohuddurtette tos seetere genettisee abe keese; maar kagubarena iise; keetegudde handdaano haggaɂabtte. ");
INSERT INTO bswl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Arriti kakkoɂiyaatte goorata, hemeenkki ulii ibaaddo maamanjjoolkko kahawɂamarena s'alayee kaɂabamere ibaaddo dubba usu tos keene. ");
INSERT INTO bswl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Katamaakko gosa dubba min gooc'a horee kukku ameen gireen ");
INSERT INTO bswl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesuusa kalekaleekki hawɂaami kahawɂamare kamooggan ibaaddo fayyiise durrisana beese, ayesuun goɂameen durrisana kayesuusa ayyonati mankkokasanaaye maraan Yesuusa iso goggoɂayeesirawun feɂi lakkosisere. ");
INSERT INTO bswl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Babbaris bullane, Yesuusa keere minkko bee banɂe kaletti tos seetere ebi haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoonana unatteessana usu dootaa debee been. ");
INSERT INTO bswl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kakkohelareen goorata, «Ibaaddo dubba ku dootara» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesuusa, «Hittakko kiigunne dollee kagiro kakkalee maamanjool seenna eseenna lallabinna, ani kakkoonɂemeeyera hikkanunya» ame. ");
INSERT INTO bswl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Haanssun Ayihuudikokki min kaɂebi tos tabere lallabaanna durrisa beesa Galiilaa dubba maraamurano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Maarii bar kaɂabanaaye ibaaddoti koo Yesuusa tos emetere luki hegelii gilbbisere; «Feɂittaa golleete in muc'c'isin daanddaatta» ame ebaate. ");
INSERT INTO bswl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesuusana ibaaddotin nenɂeyisatere gene diriirssate abere «Feɂi sisera muc'c'imina» ame. ");
INSERT INTO bswl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ibaaddoti banneewa barkko muc'c'ime, fayyee. ");
INSERT INTO bswl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesuusana ibaaddotin ataayise segeere haa ame galise. ");
INSERT INTO bswl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Hikka ayees Maayyonna goggoseginnonkko isi oora, ayesuun goɂameen gosaan ato goggolleeroon seedde isiɂoottaa tuuk'aamon tusa; muc'c'i amanokkaawun Muse goggoɂajajeerokki malee jaarsso sisi» ame. ");
INSERT INTO bswl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ibaaddoti goɂameen mankkoseete dubbaa kalleeroo ayees sessegaa sesseete, oduna darɂee. Hitta aalantti Yesuusa maamisitti katamaa addeesami tabin lakkodaanddee; hikkakko kakkeey katamaakko sarre ibaaddo takkoginnon banɂe girano haggaɂabe; ibaaddo goɂameen banɂe banɂekko usu mankkogiro emeetaa gireen. ");
INSERT INTO bswl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yesuusa arri uc'c'arkko abbaabatere tak'ifirenaahoomi katamaa tos emeete; esenewa usu min tabano gosa maale; ");
INSERT INTO bswl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Haanssun min laanawaatere awundda taaɂunɂiroo geegin ibaaddo kamooggan kukkume, usuna haafura kawaa iso agaalssisaa gire. ");
INSERT INTO bswl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Hassu goorata ibaaddo afarro naafaleessakki ibaaddoti sideengureen usu tos keenen ");
INSERT INTO bswl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Gosa mooggankko kakkeey Yesuusa tos gabbaliin minkko waateen maraan taminee heelinchcho Yesuusa mankkogirone butto beesengureen naafaleessati takkohuddurere alggaanne wota dagiseen. ");
INSERT INTO bswl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesuusana ammanokkisoo deegure naafaleessatine «Ati hikki unnu c'ubbo kakka shaaga leera!» ame. ");
INSERT INTO bswl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Eseenna hamas's'een ogireen kookkoo seera kamuse oɂagaalssisareen wodanattisooyi haa ameen hedeen. ");
INSERT INTO bswl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Hikki ibaaddoti misii haa amara? Hedo gutii haafura kahabaari kahabaarara! Waa koo kuwaarre c'ubbo shaaga yelin kadaanddaara ayyoya?» ameen k'oppeen. ");
INSERT INTO bswl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesuusana banneewa wodanattisooyi kahedaran ayyaanakkeessayi addeesere; «Misii haa k'oppaattan? ");
INSERT INTO bswl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Naafaleessakki ibaaddotine ‹C'ubbokkakkaa shaaga leera› amanokkona, kingudde alggaattaa sidadde gali, amanokko eekiya enekki? ");
INSERT INTO bswl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ayesuun goɂameen ere kaɂibaaddo ul gutii c'ubbo shaaga yelin odonnati kaɂabo laano goggoɂaddeessawun» amere naafaleessatine, ");
INSERT INTO bswl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Kingudde alggaattaa sidadde minkaa gali» ame. ");
INSERT INTO bswl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Naafaleesatina goorsewa keegure alggaa sidatere ibaaddo dubba diyaagiraan bee. Haanssun ibaaddo saadere hikkamalekki ayees «Noo duuddo deenne laakkansso amaa Waa galateen.» ");
INSERT INTO bswl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesuusa kallami labu tagaliila tos seete, gosa kamooggan usu tos emeete, usuna iso agaalssise. ");
INSERT INTO bswl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Esene rooraa giraan kaɂilfoosa ere woyyutina k'arat'a takkoɂataraan banɂee hamas's'ee giraan deere; «Indebee sessee» ame. ");
INSERT INTO bswl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kawoyyuti minii babo aamin hamas's'ee giraan, omooggan k'arat'a okukkuyisareenena, c'ubbaalessaalnne, usu debee sesseetaa mankkogireen maraan, Yesuusana usukko oɂagaalssatareene wota babo aamaa gire. ");
INSERT INTO bswl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tafarasaawi unakko olleeren seera kamuse oɂagaalssisareen Yesuusa c'ubbaaleessalnnena k'arat'a okukkuyisaraanne wota aama giraan kakkodeyaaren goorata; usukko oɂagaalssataranne, «K'arat'a okukkuyisaraanena c'ubbaalessajjoolnne wota muun aamara?» amaa hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesuusana iso kaɂayyeeseren maaleere akimii kakkoondootisara «Kahawɂamaron kuwaarre fayyaaleessan lakkoyo; ani c'ubbaalessajjool kuwaarre k'ulloolee uumin lakkoɂemeeyero» ame. ");
INSERT INTO bswl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yaannisakko oɂagaalssataranna ibaaddo kafarasaawi agabuwɂa gireen. Ibaaddo kookkoo emeetegure Yesuusane; «Yaannisakko oɂagaalssataranna farasaawilkko oɂagaalssataran goɂagoboyiraan kukko oɂagaalssataran agabuwaana kakkoonwaataraan mewuunya?» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesuusana; «Kamashaashee wota giranttii saatilaal agabuyin daanddaatta? Kamashaashee isone wota giraan agabuyin lakkodaanddanan ame. ");
INSERT INTO bswl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ayesuun goɂameen kamashaashee isokko kakkoɂatamira goorata emeetara, usu goorata agabuyinawa. ");
INSERT INTO bswl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Kaddoɂan sarssi gutii taɂusubtti erbbe kakkaatara maayyonna laagiro, hikki gollee adi; taɂusubtti erbbe taddoɂan tatarshaatta, fiilamanona aaloo balɂaayinara. ");
INSERT INTO bswl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Adi kaɂusub kawoyinii t'amo kaddoɂan dinbbito kakkibatara laagiro, hikkamalee gollee kawoyinii t'amo dinbbito bereɂsara, t'amo kawoyiniinna ubatara dinbbitona laɂokko sarii biyaara. Haanssun kaɂusubikki t'amo kawoyiniwuun kaɂusubikki dinbbito dootisara.» ");
INSERT INTO bswl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tafoolissi arri Yesuusa ira orromare rooraa gire, usukko oɂagaalssatareen shawuyee ebisatano haggaɂabeen. ");
INSERT INTO bswl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farasaawiilnna tafoolssi arriwuun feɂi kasisamoon gitto ayees kukku oɂagaalsataran «Muun felaraan?» amaa hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesuusana abbaabere, «Daawute usuu debee osessetaraane wota kakkoɂuɂeerena kakkorakkatere goorata me yelero lakkonabbabtteettanya? ");
INSERT INTO bswl_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiyataari tuuk'aamolun woyichcha lee kakkogire geesii Daawute min kawaa tabere tuuk'aamolun kuwaarre okkalee aamin feɂi kakkonsisamoon giro, kak'ullooye babo kawaa aame, usu wota kagire ibaaddonna sise.» ");
INSERT INTO bswl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Adena Yesuusa, «Tafoolssi arri ere kaɂibaaddotun met't'aanttetta kuwaarre ibaaddo arri tafoolsiwun lakkomet't'aamero ame. ");
INSERT INTO bswl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Haanssun Ere kaɂibaaddo tafoolssi arriwuun Goottaya.» ");
INSERT INTO bswl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesuusa kallami abbaabate Ayihuudikokki min kaɂebi tos tabe, eseenna gene kanaafatere ibaaddoti koo gire. ");
INSERT INTO bswl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aalanttina Yesuusa mootin kaddootare ibaaddo tafoolssi arri gofayyisaro deenna, ameeren oora gireen. ");
INSERT INTO bswl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesuusana gene kanaafatere ibaaddotine «Kingudde iso t'eɂee aalliina» ame. ");
INSERT INTO bswl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Esekko abbaabatere «Afo tafoolssi arriwuun feɂi kakkosisanttetta taɂidan feliinya muu tameellan feliinya? Neefo fayyisanoya muu baasanoya?» Ame iso hoosate, isona adene c'alɂi ameen. ");
INSERT INTO bswl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesuusa wodanattiso duudaanon gaddeegure usu maraamurene oɂalleeraan iɂone deegure ibaaddotine, «Genettaa diriirssa!» ame, ibaaddotina gene diriirssate genettesana duuddo fayyiite. ");
INSERT INTO bswl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Goorsewa ibaaddo kafarasaawi beegure misi yeli Yesuusa baasinaraan una taherodoosane wota makkareen. ");
INSERT INTO bswl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesuusa usukko oɂagaalssataranne wota tagaliila labu tos dage, Galiilakko kaɂemeetera aaloo kamooggan gosa debee sesseete, ");
INSERT INTO bswl_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Usu kafelaro ayees kamaalera ibaaddo Galiilakko, Yihuudakko, Iyyerusaalemikko, Edomiyasikko, Yorddaanoskko gamaa kagiro maamankko, usumaleenna tat'iroosakkona tasidoona katamaalkko usu tos emeeten. ");
INSERT INTO bswl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kukkukaɂamere gosa goggoɂunɂinonkko tic'c'artti wolabo oyireen usuun goggoɂekkaasiranun Yesuusa usukko oɂagaalssataranun ajajee. ");
INSERT INTO bswl_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kamooggan ibaaddo fayyiise mankkogire maraan, dhukkubaa karrakkatare dubba genettisooyi usu dinin dootataa gireen. ");
INSERT INTO bswl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Battiikki ayyaanajjolna Yesuusa kakkodiyaaren goorata horee iyaa «Ati ere kawaatta,» amaa iyyaa gireen. ");
INSERT INTO bswl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yesuusa goɂameen ayyonnatikkeessa iso beesi goggoɂayeesonkko ataayise hadise. ");
INSERT INTO bswl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesuusa wodami tos beegure usu odootera usu tos goggoɂemeerawun uume, isona isone wota ogireen iiseengureen usu tos emeeten. ");
INSERT INTO bswl_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Usune wota goggogirrawunna, goggolallabnawun farin amere tomonkko lama shuume, ofarameeraan ame iso uume. ");
INSERT INTO bswl_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Durrisa goggobeesinawunna odonnati sise. ");
INSERT INTO bswl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Oshumameeran tomonkko lamana hinɂayaan, isona P'et'iroosa ame kaɂuumero Simoona, ");
INSERT INTO bswl_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Boɂanereges goorttun, kadiddideenna yiis ame mege kabeesero kazabddoosa yiis Yayik'ooba abbikkeessa Yaannisa, ");
INSERT INTO bswl_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Indiraasane, Filp'oosane, Berttelomeewosane, Matoosa, Toomaasa, kaɂilfoosa ere, Yayik'ooba, Taadiwosa, ulkkeessa kahaɂusataro Simoona, ");
INSERT INTO bswl_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","usumaleenna Yesuusa roorise kasisero kaɂask'orotu ulkokki Yihuuda. ");
INSERT INTO bswl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Esekkona Yesuusa abbaabate usu min tos tabe, Yesuusana usukko oɂagaalssatareene babo aamin taawaananii gosa ade mooggaate kukkume. ");
INSERT INTO bswl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","«Yesuusa wodana k'olamera» amamano kamaalera fallikkeessa usu atayiseeyin usu mankkogiro emeete. ");
INSERT INTO bswl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Iyyerusaalemikko oɂemeetereen seera kamuse oɂagaalssisareen, «Usu durrisakokki woyichcha aba! Durrisa kakkobeesarana kaddurrisa woyichchaaya» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesuusa gosa isi tos uumegure masuussa haa ame, s'alaye s'alaye misii beesin daanddaatta? ");
INSERT INTO bswl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Wono koo isiɂisi orroo kalekalee gobbee hassu wononnati ataayin lakkodaanddaaro. ");
INSERT INTO bswl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Usumaleenna min kookki ibaaddo isiɂisirroo kalekalee gobbee arɂayi aallin lakkodaanddaaro. ");
INSERT INTO bswl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Usumalee s'alaye isiɂisi orroo isikadiidattona kalekalee kabeyaatto golleete baatta kuwaarre ataayi aallin lakkodaanddaatto. ");
INSERT INTO bswl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Hassukko kakkeeyi ibaaddoti koo t'ayi hunnameessakki ibaaddoti hanshiinoni giraan hunnameessa ibaaddotikokki min tabire urrawo saamiin lakkodaanddaaro, minkkeessa saamiin kakkodaanddaara hunnameessakki ibaaddoti goshiiyye kaalaalya. ");
INSERT INTO bswl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«Ani rumminaa amara, ibaaddo kafelara c'ubbona kahabaarara habaar dubba shaaga leerowa, ");
INSERT INTO bswl_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ayesuun goɂameen Ayyaana K'ulluukki kahabaarara dubba jiruu jiroommatti anza aba kuwaarre usuun haheso lakkoɂamaminnaro.» ");
INSERT INTO bswl_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesuusa hikka kakkoon ayeesera «Battiikki ayyaana aba» mankkoɂameen maraanya. ");
INSERT INTO bswl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Esekko abbaabatere Aye tayesuusana abbilaaltteessa usu tos emeeten, sarre aalleerene ibaaddo usu tos fareen uumsiseen. ");
INSERT INTO bswl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Usu mareɂabe kahamas'eere kamooggan ibaaddona, «Hinɂima Aayettana abbilaalttana sarre aalleenen ku dootaraan ameen segeen.» ");
INSERT INTO bswl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Usuna, «Aayettina abbilaaltti ayyoosyyaan?» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Usu mareɂabe kahamas's'eere ibaaddo tos diyaa haa ame «Aayettina abbilaaltti hinɂayaan! ");
INSERT INTO bswl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Feɂi tawaa kafelara dubba usu abbikee, abbatteenna, Aayetteeyyan» ame. ");
INSERT INTO bswl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesuusa kakkalee goorata ade labu girddi agaalsisano haggaɂabe. Usu kakkogire gobobii aaloo kamooggan gosa mankkokukkuɂamere maraan, beke orroo tagitte wolaboo tabere hamas's'ee, gosa dubbana labu girdi kukkume gire. ");
INSERT INTO bswl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Usuna kamooggan ayees masuussaa agaalsise, agaalsisaanna haa ame, ");
INSERT INTO bswl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Maala! Goortta, ibaaddoti koo wut'a wut'ayiin bee. ");
INSERT INTO bswl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wut'a kakkowut'atare goorata kookkoo raadii iyye, kimbir emetere abaabate aame. ");
INSERT INTO bswl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kakkalee ade taɂidan erre mankkoginnooti shak'umooltti banɂee iyye, erre shak'umooltti mankkolleete maraan banneewa alate. ");
INSERT INTO bswl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Arriti kakkobiyaatte goorata ade k'oore, hididi hegelddi dagana mankkowaate maraan angage. ");
INSERT INTO bswl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kakkalee wut'a ade eɂeen t'eɂee iyye, eɂeenna wota jiinattedde kaɂalatere wut'a hurɂite mankkoɂabttette maraan il lakkoyelate. ");
INSERT INTO bswl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kakkalee wut'a ade taɂidantti erre gutii mankkoɂiyye maraan alate, jiinaate, ilnna sise, koo sonddom, koo lootam, kakkaleenna il bool dubame.» ");
INSERT INTO bswl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Adena Yesuusa «kamaalara nebe kaɂaba hamaalo!» ame. ");
INSERT INTO bswl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kale kakkohesare goorata, debee sesseetaa kagire ibaaddona tomonkko lama okkalee wota ogireen masuussajjool maraan fureen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Usuna, «Isinuun wononnati kawaakkotti hool malabano isinuun, sisamera, sarre ogiraawun goɂameen ayees dubba masuussaa isoon segaaminara. ");
INSERT INTO bswl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Hikkina kakkoonlinnara, « ‹Isona Waa tos abbaabayineene C'ubbokkiso haheso goggoɂamamoonko; Diyaano diyaagiraan wodanaa goggokokannonkko; maalano maalaa giraan lakkoshaadaran, hikkakko kakkeeyi c'ubbokkiso haheso lakkoɂamamaro ame.› » ");
INSERT INTO bswl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Esekko Yesuusa haa ame «Isin hitta masuussa lakkoɂaddessetanya? Hayya kaggarmman masuussajjool misii addeesin daanddinnattan? ");
INSERT INTO bswl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kawut'ara haafura kawaa wut'ara. ");
INSERT INTO bswl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ibaaddo kookkoo raadii gutii kaɂiyyero wut'a aani laara, haafura kakkomaallaan goorata s'alaye banneewa emeettegudde iso orroo kawut'amero haafura aatatta. ");
INSERT INTO bswl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Adena kakkalee shak'umooltti banɂe kawut'amero wut'a aani laaran, haafura kakkomaallaan goorata banneewa geggelooyi atataraan. ");
INSERT INTO bswl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ayesuun goɂameen hidiid hadagisoon mankkogire maraan kaɂadallatarana goorata kic'c'aar kaalaalya, haafurakokki aalanttii rakkoo goorttun horooramano kakkoɂemeete goorata banneewa handudufataran. ");
INSERT INTO bswl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kakkalee ade eɂeen orroo kawut'amero wut'a aani laaran, haafura maalano maalaraan, ");
INSERT INTO bswl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","halleewo kuwaarre hikka alamkokki yaada, durumakkotti geelanjjena kakkalee addakki halchcha wodanattiso orroo tabere haafura mankkohurɂaro maraanya. ");
INSERT INTO bswl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kakkaleenna erre taɂidanii gutii kawut'amero wut'a aani laaran, isona haafura maaleeren oɂoorataran koo sonddom, koo lootam, koo il bool, odubamaraaniyan.» ");
INSERT INTO bswl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesuusa «Isin ifa hank'k'ayisattedden daachcho hegelii goorttun alggaakko hegelihayisatteen kaatattan? Kakkokaattaan bollanssoo gutii lakkoyoya? ");
INSERT INTO bswl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Haanssun kasiyyame, kanmutoon, kagolatera, ifa tos kanbeenoon laagiro. ");
INSERT INTO bswl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kamaalara nebe kaɂaba hamaalo!» ame. ");
INSERT INTO bswl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Adena Yesuusa haa ame; «Kamaalattan ayeesi maraan isiiɂoorayeen,» kakkoɂekkaasattan huuyi abbaabayi ekkaasaminara usumalee usukkona karoore isinuun adaminara. ");
INSERT INTO bswl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kaɂaboon adaminara kallayikkikko adi hassu kagira kic'c'arkkiwa adi usukko ataminara ame. ");
INSERT INTO bswl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Esekkona Yesuusa, «Wononnati kawaa hikka aani laara, ibaaddoti koo erree wut'a wut'atara. ");
INSERT INTO bswl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ibaaddotina hemeen huddurara, arriinna nabbaadara ayesuun goɂameen usu haɂaddeeson giraan usu wut'a alate jiinatara, ");
INSERT INTO bswl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Errena isiɂoottiseeyi horaarjje buul, debeenna gabo, esekko gabo gutiinna kagomoraa il yelaata. ");
INSERT INTO bswl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Wut'ana kakkodubame goorata kaami kakkokukkuɂamaro goorata mankkollee maraan ibaaddoti tagayiin baac'aa saame ekkaasatara» ame. ");
INSERT INTO bswl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Adena Yesuusa, «Wononnati kawaa menne wota herreginssa? Misikki masuussa addeesinssaa? ");
INSERT INTO bswl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Sinafic'c'i kaɂamamaro gaakotti il aani laatta, ese il wut'amaa giranttii ul gutii kagiro wut'akko tic'c'arttitta. ");
INSERT INTO bswl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Alayidde kakkojiinatte goorata taɂakaakiltte banɂe kamutaro alat dubbakko rooratta, kimbirjoolnna kajiinjjiin ballaalkkotti hoos hegelii foolssatara» ame. ");
INSERT INTO bswl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesuusa ibaaddo addeesin kadanddeero jilbbakki malee hikkamaleenɂi omooggan masuussajjool isoon segee. ");
INSERT INTO bswl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ayees koonna masuussa kallayi lakkoɂayeesare usuna usukko oɂagaalssataran olaal kakkolleraan goorata ade ayees dubbana kalekalee beese isoon addeesise segaa gire. ");
INSERT INTO bswl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ese arri ul hemeen lee giraan Yesuusa usukko oɂagaalssataranne «Bekekko gama nak'inna» ame. ");
INSERT INTO bswl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Isona gosa iiserene wolabo orroo goggogireeni esennewa Yesuusa aateen seeteen, kakkalee wolaboolna wota gire. ");
INSERT INTO bswl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Usu goorata kaɂatii irggado kee, gaashimallonna beke wolabooyi taa ammagamiraani shalagaa gire. ");
INSERT INTO bswl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesuusa ade borkkaano borkatere wolabo orroo huddure gire. Isona nabbaadiseeren, «Kaɂagaalssisatto! Noo gogudanno ku lakkot'ibaroya?» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Usuna nabbaade keegure irggado hadise, bekena, «c'alɂi ameen!» anbbalnna c'aliɂantte, duuddo c'alɂeetti leete. ");
INSERT INTO bswl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesuusana, usukko oɂagaalssataranne, «Mewuun haa abssatteen? Misii ammano waattaan?» ame. ");
INSERT INTO bswl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Isona aaloo abisateen guuren isiɂisi orroo, «Afo, iriggadona gaashimallo c'alɂi kakkoonɂamaraan hikki ayyoya?» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Beke ogaliilakko gama nak'erene Gerggesinoon kaɂamamare maaman geen. ");
INSERT INTO bswl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesuusa wolabokko goggodagee, battiikki ayyaana kakkogire ibaaddoti tahiyyeel banɂekko beere usu tos emeete esele. ");
INSERT INTO bswl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Hikki ibaaddoti tahiyyeel banɂe gire, maayyona usu sanssalataayi shii kayin lakkodaanddeere. ");
INSERT INTO bswl_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Gooratta kamooggan talukee marc'c'ona sanssalataa kageneeyi shaamaa gire. Ayesuun goɂameen kagenee sanssalata goggosaanna talukee marc'c'o eɂebisaa gire. Maayyona usu abi adallaayisin kadanddeera lakkogire. ");
INSERT INTO bswl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Arggetto arriinne hemeenne hiyeelinna wodami gutii maraamurara iyyaa maarkkeessa eɂemo gogosataa gire. ");
INSERT INTO bswl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Hikki ibaaddoti Yesuusa ebbaa kakkodeyaare goorata usu tos tiyaa emeete horee gilbbisere sagade. ");
INSERT INTO bswl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Yaaye t'ok'k'isere iyyaa, «Ati dubbaankko kaɂatii ere kawaa Yesuusa, inne wota me abitta? Goggoɂabboosisonkko mege kawaayi ani ku ebaatara!» ame. ");
INSERT INTO bswl_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ibaaddotina hikka kakkonɂamere, «Ati battiikki ayyaana hikka ibaaddotikko beena!» ame ajaja sise mankkogire maaranya. ");
INSERT INTO bswl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Esekkona Yesuusa, «Megeka ayyoyya?» ame usu hoosate. «Omooggan mankkolleeren maraan megekkina Leegooniya» ame. ");
INSERT INTO bswl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ulkko iso goggohororoonkko ataayise ebaate. ");
INSERT INTO bswl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ese banɂe wodami laayuyi tammooggan booyyee bobbayite gitte. ");
INSERT INTO bswl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Battiikki ayyaanajjol Yesuusane, «Booyyeel tos goggotabinnoo noon feɂi sisi» ameen ebaaten. ");
INSERT INTO bswl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesuusana feɂi sise, battiikki ayyaanaajjol hassu ibaaddotikko beeren booyyeeli tabeen, kuma lama kalleera booyyeel laga hiɂii metegamatto hegelddeen dageen beke orroo lichchi ameen. ");
INSERT INTO bswl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Booyyeel ofofareenna bak'ateen seeteen, maamanina maamankko k'amane kagiro uli odu ayeeseen, gosana kalleero ayees din takkogiro banɂekko bee. ");
INSERT INTO bswl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Gosana Yesuusa tos emeetegure hassu battiikki ayyaana abamere kagire ibaaddotikko sammuu abbaabattedde, sarssi sarssate kahamas'eero kakkodiyaaren goorata neen. ");
INSERT INTO bswl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Hikka t'aye kaddeera ibaaddo battiikki ayyaana kakkobareero ibaaddotina booyyeel gutii kalleero ayeesi dubba gosaan segeen. ");
INSERT INTO bswl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hassu goorata gosa Yesuusa ulkkisookko gafari goggobeero ebaaten. ");
INSERT INTO bswl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Esekkona Yesuusa wolabooyi kakkotabare goorata, durrisa kakkogire ibaaddoti wota seeyin ebaate. ");
INSERT INTO bswl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesuusa usuun feɂi lakkosise, ayesuun goɂameen «Minkkaa seedde Goottaa eeggitakki kaɂatii ayees kuun felerona misii shaaga yelero gosakkaawun segaa» ame. ");
INSERT INTO bswl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ibaaddoti seetere, Yesuusa kafelero ayeesi dubba maaman tomon kaɂamamaro ul segaano haggaɂabe, kamaale dubba saade. ");
INSERT INTO bswl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesuusa ade kallami bekekko gama wolabooyi kakkonak'are goorata kamooggan gosa usu tos kukkume, hassu goorata usu labu giridii gire. ");
INSERT INTO bswl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ayihuudikokki min kaɂebiwuun woyichcha kallerokko koo Iyaaɂirosi kaɂamamare eserraa emetere Yesuusa kakkodeyaare goorata luk'k'aa gutii iyyere, ");
INSERT INTO bswl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","«Tic'c'artti unnutti goyi hiɂi gitta fayyidde neefone goggogirttoo emeedde genettaa ese gutii kayi» amaa ataayise ebaate. ");
INSERT INTO bswl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesuusana wota seete kamooggan gosana usu maraamure unɂee debee sesseeteen. ");
INSERT INTO bswl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Gees tomonkko lama iigi ubataa takkogire heleelttiti too esee gitte. ");
INSERT INTO bswl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Omooggan odo doobjjoolun dollee rakkataa tagitte kaɂabtto dubba goggussattena, dhukkuba haggaaɂataate kuwaarre lakkoɂiisere. ");
INSERT INTO bswl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Esena gara kayesuusa kakkomaalatte goorata haarre ibaaddo orromartte emeetedde sarssikkeessa dintte, ");
INSERT INTO bswl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Aalanttina «Mamisi ligure suure sarssikkeessa kaalaal godine fayyinnara» kaɂamaro ammano abanaayite. ");
INSERT INTO bswl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kaɂubatare iigi banneewa aallee, abboosakko hesano maarkkiseyi addeesame. ");
INSERT INTO bswl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesuusa banneewa hunna usukko biyaano addeesere, gosa tos kambbal amere, «Sarssikkee kadine ayyoyya?» ame. ");
INSERT INTO bswl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Usukko oɂagaalssatareen, «Gosa unɂaamere kashashafaro diyaagiraan, ‹Ayoyya in kadinera?› misiiɂamatta?» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesuusa ade hikka kafelera ayyoyo din haar abbaabate maraamurise wochchee. ");
INSERT INTO bswl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Heleelttitina eseen me felamero kakkoɂaddesatte goorata abssataanna harɂaa emeetedde usu horee iite rummi dubbana segiite. ");
INSERT INTO bswl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesuusana, «Unnuttee ammanokka ku fayyiisera nogoddaa gali, abboosakkaakko foolssa» ame. ");
INSERT INTO bswl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesuusa hikka ayeesa giraan, Ayihuudikokki min kaɂebiwuun woyichcha kalleero kaɂiyaaɂirosi minkko kaɂemeetere ibaaddo Iyaaɂirosine «unnutta gootetta, goorata kaɂagaalssisaro muun harisatta?» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesuusa ade hikka maalegure woyichchatine ammana kuwaarre «Arooɂabssatte!» ame. ");
INSERT INTO bswl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesuusa P'et'iroosane Yayik'oobane ade kayayik'ooba abbi Yaannisane kuwaarre maayyona debee goggoseero feɂi lakkosise. ");
INSERT INTO bswl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Min kawoyichchaati kakkogiyaaren goorata Yesuusa ibaaddo woo woo amaa yururu ame ootaa giraan dee. ");
INSERT INTO bswl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Min tos tabere, «Hikki dubba iyyana oottan metta? Unnuna huddurttetta kuwaarre lakkogootetto» ame. ");
INSERT INTO bswl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ibaaddo ade k'ac'c'ifataa usuun osolee. Yesuusa ade ibaaddo dubba minkko beesere unnukokki Odona Aanna usumalee usu wota oɂemeetereen usukko oɂagaalssatareen wota unnu mankkogitto tos tabe. ");
INSERT INTO bswl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Esekkona taɂunnu gene abere «T'aalta ki aallii!» ame. «Fureenna, teɂunnu ki amara» amanoya. ");
INSERT INTO bswl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Unnutina banneewa keete aallite hasserraa hittarraa sesseete. Geeskkisena tomonkko lamaye. Ibaaddona kalleero ayeesii aaloo saade. ");
INSERT INTO bswl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesuusa ade hikka ayees maayyonna goggoɂaddeesonkko ataayise segeegure, ese kaɂaantto kooko goggosisirawun segee. ");
INSERT INTO bswl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesuusa esekko beere ulkkeessa tos emeete, usukko oɂagaalssatareenna debee sesseeteen. ");
INSERT INTO bswl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tafoolssi arri Ayihuudikokki min kaɂebi agaalssisano haggaɂabe, kamaale ibaaddo kamooggan saade. Isona haa ameen, «Hikki ibaaddoti hikka ayees hayekko helera? Misitti k'arummatta usuun tasisanttetta? Hikki baasajjol genetteessa kakkofelamara misiiya?» amaa saadaa gireen. ");
INSERT INTO bswl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Debeenna «Hikki anaat'eti kamayiraame ere lakkoyoya? Kayayik'ooba, kayoosa, kayihuudana kasimoona abbi lakkoyoya? Abbalaaltteessana hittanii noonne wota giraanna?» hikkakko kakkeeyi usuu handudufaten. ");
INSERT INTO bswl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesuusa ade «Kahegeroo kakkokabajaamon ulkkeessaa, fallikkeessa orroonna kaminee ibaaddokkeessa dollee kuwaarre» hakabajaamooni lakkohesaro ame. ");
INSERT INTO bswl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Eseenna ohawɂaamareen uc'c'arri gutii gene kayere fayyiisano kuwaarre maamisikki baasa felin lakkodaanddee, ");
INSERT INTO bswl_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ammanatana waattitisoyi saade. Esekkona Yesuusa maaman orroo maraamuraa agaalssisaa gire. ");
INSERT INTO bswl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tomonkko lama isi tos uumere, lama lama yele fare, battiikki ayyaanajjol gutii odonnatina sise. ");
INSERT INTO bswl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","«Raakkisinun dama kuwaarre, babo goorttun k'arat'iti goorttun adi maragade kiisiyi arooɂabatteen, ");
INSERT INTO bswl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Keferro tabssayeen, ayesuun goɂameen k'olo lama arooɂabatteen.» ");
INSERT INTO bswl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","«Min koo tos kakkotabitteen goorata usu maamankko taabettani esee adallaayen. ");
INSERT INTO bswl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ibaaddo isin takkok'op'anoyinna takkomaaloni banɂe dubbaa luk'k'aɂoottisinkki gorra hurgufayendden esekko biyaaden seeyeen, hikki isoon seerisanokokki ato linnara» ame hikka ajaja sise. ");
INSERT INTO bswl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Isona esekko beeren, ibaaddo c'ubbokko gula goggogalloon lallabeen. ");
INSERT INTO bswl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kamooggan durrisa beesen, omooggan ohawɂaamaran gutii zayitii shigidaa fayyiisen. ");
INSERT INTO bswl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kayesuusa mege addeesamaa emeetano wono Herodoosa maale. Ibaaddo kookkoonna «Hikka aankkikki baasa usu kafelara kat'ammak'aare Yaannisa goyikko keera» amaa gire. ");
INSERT INTO bswl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kakkaleenna «Eelaasaya» ameen. Kuunɂi adeen, «Kat'awoo kahegeroolkko koo kahegeroo aaniya» amaa gireen. ");
INSERT INTO bswl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodoosa ayees kakkomaalare goorata ade, «Ani mete kakkogoosisera Yaannisa goyikko keera» ame. ");
INSERT INTO bswl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Hikki Herodoosa ussunwa abbikkesatti tafilp'oosa oori Herodiyaada atatanokotti aalanttii abami goggoshamiron ajajeere Yaannisa minkashaano tabise. ");
INSERT INTO bswl_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yaannisa Herodoosane, «Abbikkaatti oori goggoɂatannoonkko seera kamuse tirara» ame gire. ");
INSERT INTO bswl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodiyaadana ese k'uut't'e abattegude Yaannisa lagadisin dootaa gitte, ayesuun goɂameen eseen lakkoɂekkaate. ");
INSERT INTO bswl_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodoosa horaarjje Yaannisa k'ulluukkina Waawun kaɂassaabame ibaaddoti laano mankkokasanaaye maraan abssataanna oorataa gire. Herodoosa Yaannisa kaɂayeesaro takkomaale tootooyi abssataa gire, halleewo kuwaarre geggelooyi maalaa gire. ");
INSERT INTO bswl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodoosa takkoɂumulamero arri kabajjayiin min kawonooyi odonnati oɂabaan, kajereene shuumjjolna, kookkoo Galiilaayi addeesame kagiro ibaaddon aamo kaɂatii ekkaase. ");
INSERT INTO bswl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Taherodiyaada ere banɂe taɂaamo tabttedde kakkomadaaratte goorata Herodoosana kaɂuumamero ibaaddo geggelaayisse, wononna unnutine, «Ati kadootaatto dubba in hoosa; ani kuun sisirowa» ame. ");
INSERT INTO bswl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Adena «Wononnatikkeekotti mina golleetenna, ati kahoosatte dubba sisirowa!» amaa ammatto tabe. ");
INSERT INTO bswl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Esena Aayettisee tos seettedde «Me hoosara?» antte, Aawona «Kat'ammak'aaro kayaannisa mete sisi» ami hoosa antte. ");
INSERT INTO bswl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Unnutina goorsewa saantte wono tos abbaabattedde, «Kat'ammak'aaro kayaannisa mete gidda yaalɂaayi kayidde goggosissoo dootatara» antte. ");
INSERT INTO bswl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wonona hikka ayeesii aaloo yaade, halleewo kuwaarre taɂuumanttetto martti horee katabero kaɂammatoo haafura isaagin lakkodoote. ");
INSERT INTO bswl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Haanssun wotaadara koo saame farere, kayaannisa mete goosi goggokeennoo fare, usuna seetere minkashaano orroo tabe mete kayaannisa goose, ");
INSERT INTO bswl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","kagoosamero mete yaalɂaayi kayere unnutiin sise; unnutina Aayettiseewun sise. ");
INSERT INTO bswl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yaannisakko oɂagaalssatareen hikka kakkomaalareen goorata emeetenen, rees aateen k'amaleen. ");
INSERT INTO bswl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ofarameerenna mankkoseeterenkko Yesuusa tos kukkumeeren kafeleranna kaɂagaalssiseraan dubba usuun segeen. ");
INSERT INTO bswl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kamooggan ibaaddo emeettaanna setaa mankkogire maraan babona aamin goorata lakkogire, «Alla isin kaleti banɂe too tos seeyiddeene abaraan foolssayeen» ame. ");
INSERT INTO bswl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Haanssun kaletti banɂe too wolabooyi seeteen. ");
INSERT INTO bswl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Isona setaa giraan ibaaddo kamooggan deegure malabe, maamanjool dubbakko tiyaa usukko hore geen. ");
INSERT INTO bswl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesuusa wolabokko kakkodagare goorata gosa kamooggan kakukkumero dee, kafoofiro kallayikki idaad aani mankkogire maraan yaade, kamooggan ayees agaalssisano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Usu goorata ul hemeenllaa kakkosetare goorata usukko oɂagaalssatareen usu tos gabbalameeren, «Hitti banɂe k'alullattotta, ul hemeen leera. ");
INSERT INTO bswl_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ibaaddo kakkogiro maaman tos seeyigure kaɂaamiraan kooko iminayi goggoɂaminarawun gosa gafarina» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesuusa ade «Kaɂaamiraan isinwa sisa» ame abbaabe. Isona, «Seeyinne iso kaɂaamiraan lama boolee t'agaraayi babo imininne isoon sinissu?» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Usuna, «Babo miyyaa abittaan? Alla seyeenddeene diyaa» ame. Deengureen, babo kenna kunɂub lamana girowa ameen. ");
INSERT INTO bswl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Esekkona gosa eesii c'aree gutii una unaa goggohamas'iroon ajajee. ");
INSERT INTO bswl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Gosana bool booli konttom konttomi una unaa hamas's'ee. ");
INSERT INTO bswl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesuusa babo kenna kunɂub lamana abere daruurii tos diyaa sommaasate, babona ekkaɂebise usukko oɂagaalssatarawun sise; usumaleenna kunɂub lamana dubbaawun hedeede. ");
INSERT INTO bswl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Dubbana babo aameen barareen. ");
INSERT INTO bswl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Usukko oɂagaalssatareenna kaɂaamamero babokkona kunɂubkko tahessetto hanbba dugud tomonkko lama mig keeseen. ");
INSERT INTO bswl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Babo kaɂaamere babbaar kuma kenye. ");
INSERT INTO bswl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Banneewa Yesuusa gosa gafara giraan usukko oɂagaalssatareen Beetesayida tos hore t'ayi wolaboo goggonak'iranu ajajee, ");
INSERT INTO bswl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Esekko abbaabateren isokko kalebeere ebaayin wodami tos bee. ");
INSERT INTO bswl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ul hemeen kakkolaare goorata wolabo badi t'eɂe gitte, Yesuusa kale bagaa gire. ");
INSERT INTO bswl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Anbbalnna ataatte foffol kiyaa mankkogitte maraan, usukko oɂagaalssatareen duudaataa feriferattisone wota moɂabataa giraan dee, hemeenkko saatii saagaalkko taa tomonkko lama saatii geeroo kagiro goorata orroo bekee gutii sesseetaa iso tos emeete iso doolmari iisi roorin dootere, ");
INSERT INTO bswl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ayesuun goɂameen beke gutii sesseetaa giraan kakkodeyaaren goorata gaari aani lee kakkomutare goorata iyyeen. ");
INSERT INTO bswl_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Dubbana usu kakkodiyaaren goorata neen. Yesuusa ade banneewa, «Allamandde! Aniwayya arooɂabssatteen!» ame. ");
INSERT INTO bswl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Usuna wolabo gutii koratere isone wota hamas's'ee, anbbalnna iise, usukko oɂagaalssatareenna aaloo saadeen. ");
INSERT INTO bswl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Babo gutii kafelamero baasana lakkoshaaderen wodanattiso ataanii duudde gitte. ");
INSERT INTO bswl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bekekko gama kakkonak'areen goorata tagenssaaret'i katamaa tos geegeen wolabona baga tos gabbaleene shiiyeen. ");
INSERT INTO bswl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Banneewa wolabokko goggodagenii gosa Yesuusa malabe. ");
INSERT INTO bswl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Isona usu gobobi dubbaa tittiyeengureen dhukkubaaleessaal alggaayi sideen usu mankkogiro banɂe dubba tos keenaa gireen. ");
INSERT INTO bswl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Usu kakkogee maaman goorttun katamaa, katamaakko k'ama dubbaa kahawɂamaro raaraadii kaanna sarssikotti sharffi diniin ebaataa gireen; usu kadine dubbana fayyaa gire. ");
INSERT INTO bswl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farasaawiilnna Iyyerusaalemikko kaɂemeetere kookkoo seera kamuse kaɂagaalssisare Yesuusa tos emeetenguren maraamuren kukkumen. ");
INSERT INTO bswl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Usukko oɂagaalssatareen kookkoo taɂaaloon giraan genee goorttun tabattoyitee genee babo aamaa giraan deen. ");
INSERT INTO bswl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farasaawiilnna Ayihuudi dubba odolaalkkisookki woga oorayin amaa, seera malee genenno iidisayi haɂaalooni lakkoɂaamareen. ");
INSERT INTO bswl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Giyyakko gogamaraan aali isiɂoottisoo gomuc'c'isaten kuwaarre lakkoɂaamareen. Usumalee k'uldubbo, uulla, filɂena, alggaa aalisano aani kakkalee seera oorataa gireen. ");
INSERT INTO bswl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Farasaawiilnna seera kamuse oɂagaalssisaran Yesuusane, «kukko oɂagaalssataran ootta seera kaɂodolaali kagirraan iiseengureen taɂaaloon giraan genee muun babo aamaran?» ameen hoosateen. ");
INSERT INTO bswl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesuusana, «Kahegeroo Isiyaasaa isin ifissaaddoleekokki gara ‹likkii hegeroo ayeesera; garakkisoonna haa amame s'aafamera; « ‹Hikki gosa hiɂii in kabajjara wodanattiso adde inkko taffakkinttetta! ");
INSERT INTO bswl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Adda sagadaraan, agaalsisanokkisonna ibaaddo kafelaro seera kaalaalkoya.› ");
INSERT INTO bswl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ajaja kawaa iisseddeene woga kaɂibaaddo ataayisattaan.» ");
INSERT INTO bswl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ade haa ame «Wogakakkisin oorayin antteddeene ajaja kawaa kakkoɂissattaan mala abttaan. ");
INSERT INTO bswl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Muse ‹Aabbokkaanna Aayettaa kabajiina, Aabbokkeessa goorttun Aayetteessa kahabaarara duuddo hagowo› ame gire. ");
INSERT INTO bswl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Isin addeen ibaaddoti koo Aabbokkeessa goorttun Aayetteessa gargaarano iisire hikki ‹K'urbbani amanona ani Waawun kasisero ilaboya› goɂame, ");
INSERT INTO bswl_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Isinna hikki ibaaddoti Aabbokkeessa leere Aayetteessa goggogarggarinonkko yelattaan. ");
INSERT INTO bswl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Haanssun alattanun karorissattan wogaan haafura kawaa iggilisattan, hikka aankikki kamooggan ayeenssa felattaan.» ");
INSERT INTO bswl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Adena Yesuusa gosa isi tos uumere haa ame, «Dubbana in maala, shaada, ");
INSERT INTO bswl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Sarkko orddee tabere ibaaddo kabbattoyisara ayees koonna laagiro, hikkakko ibaaddo kabbattoyisara isiɂoottessakko sarddee kabiyaaro ayeesiya. ");
INSERT INTO bswl_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Goortta kamaalara nebe kaɂaba hamaalo!» ame. ");
INSERT INTO bswl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesuusa gosa iisere min kakkotabare goorata usukko oɂagaalssatareen masuussakokki gara hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Usuna, «Isinuun ayees lakkotabaroya?» Sarkko ibaaddo tos tabere battoyisin kadaanddaara ayees koonna laagiro, ");
INSERT INTO bswl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Wodana tos halleennoni bogi tos tabara, esekkona maarkko biyaara, Yesuusa hikka ame abbaabattere babo dubba kaɂidankki laano addeesise. ");
INSERT INTO bswl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Debeenna haa ame, «Ibaaddokko kabiyaara hassu ibaaddo battooyisara. ");
INSERT INTO bswl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Wodana taɂibaaddo orrokko kabiyaara kameellan yaada, hetano, ibaaddo lagadano, sharmmut'aano, ");
INSERT INTO bswl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","layimano, gap'igap'aano meellane, sobano, rarragatano, k'anaatano, mege baasano, koora, lafuummayyaan. ");
INSERT INTO bswl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Hikki kameellan ayees dubba ibaaddokko biyaara ibaaddona battoyisara.» ");
INSERT INTO bswl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesuusa esekko keere tat'iroosa katamaa dollee kagiro maaman seete, min koo tos tabere usu esee girano maayyona goggoɂaddeesonkko doote, golleenna eseenna siyami girin lakkodaanddee. ");
INSERT INTO bswl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Goorsewa ade unnu tic'c'artti battiikki ayyaana takkoon abantette heleelttiti too gara kaɂyesuusa maaltte emeettedde lukki gutii iite. ");
INSERT INTO bswl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Heleelttitina ul kagiriikkittitte, alattanttisenna ul kasirofinik'akotitte, esena Yesuusa durrisa unnukko goggobeesiron ebaatte. ");
INSERT INTO bswl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Usu ade, «Kayiis babo aatiguren keroorun sisin lakkodootisaro, horaarjje yiisaas barari haɂaamo» ame. ");
INSERT INTO bswl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Esena abbaabtede «Ii Goottakkee keroornna dugud tayiiskko taɂiyaatto hanbba aamara antte.» ");
INSERT INTO bswl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesuusana, «Haanssun hikka mankkoɂantte maraan see!» battiikki ayyaana unnuttaakko beera ame. ");
INSERT INTO bswl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Esena minkkisee kakkoɂabbaabatte goorata unnuna alggaayi gutii tahuddurttettona, battiikki ayyaana tagafarero diyaatte. ");
INSERT INTO bswl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesuusa tat'iroosa katamaakko keegure, mina tasidoona tonsse katamaa tomon taɂamamatte minane roore tagaliila labu tos emeete. ");
INSERT INTO bswl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Eseenna ibaaddo nebee kamaalonna hiɂi kaɂayeeson ibaaddoti koo usu tos keenen; genenna gutii goggokayiroo ebaaten. ");
INSERT INTO bswl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesuusana ibaaddoti gosakko kale beesegure, fererroɂoottessa nebebbo oɂibaaddotii orddeese tabise, esekkona hanc'c'ufe ferii tufegure ibaaddotikokki erreb dine. ");
INSERT INTO bswl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Daruuri tos t'ok'k'iɂame diyaa eerinnaa neefssategure, «Efittahi» ame, hikkina «Banami» amanoya. ");
INSERT INTO bswl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Banneewa nebebbo banameen, errebnna furamegure k'ulleessi ayeesano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesuusana hikka ayees maayyoonna iso goggoɂayeesonkko ajajee, halleewo kuwaarre usu ibaaddon goggoɂayeesonkko ataayise ajaja kakkosisare goorata iso adeen balɂayiseen ayeeseen. ");
INSERT INTO bswl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Gosana aaloo saadaa «Usu kafelera dubba kaɂidanyya, nebebboo omaaloonna goggomaallawun, hiɂi oɂayyeesoonna goggoɂayeesirawun yelara» ame. ");
INSERT INTO bswl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Hassu goorata abbaabate gosa kamooggan kukkume, iso kaɂaamiraan babo koonna mankkoginnoon maraan Yesuusa usukko oɂagaalssataran isi tos uumegure, haa ame. ");
INSERT INTO bswl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Hikki ibaaddo iinne wota arri seed mankkoɂadallaateran maraanna iso kaɂaamiraan babo mankkowattamero maraan in nenɂyisaraan, ");
INSERT INTO bswl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","hikkamalee iso uuɂeen giraan minkkiso gogafare kookkoo ibaaddo ul kaɂeerkko kaɂemeetero mankkollee maraan raadii harigureen iiraanwa ame.» ");
INSERT INTO bswl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Usukko oɂagaalssataren abbaabeen, «Hikka k'alullattokki ulii hikka ibaaddo dubba aamisin kalleero babo haggekko helaminnara?» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesuusana, «Babo miyyaa abttaan?» ame iso hoosatte. Isona «Babo todoba abnna» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Usuna gosa ulii goggohamas'iroon ajajee, babo todoba abere sommaasate abbaabatere babokko ekkaɂebisere ibaaddon goggohedeedinawun usukko oɂagaalssatarawun sise, isona gosaan hedeeden. ");
INSERT INTO bswl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Usumaleenna uc'c'ar kidiic'c'ar kunɂub abbanayeen, usuna hikka kunɂubbeelun Waa galateere gosaan goggohedeedirawun ajajee. ");
INSERT INTO bswl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Gosana aame barare, esekkona usukko oɂagaalssatareenna tahessetto hanbba dugud todoba mig ammageen keeseen. ");
INSERT INTO bswl_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kaɂaamerena kuma afar kalleero ibaaddoya, isona galise, ");
INSERT INTO bswl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Banneewa usukko oɂagaalssataranne wota wolabooyi tabere Dalmmanuta taɂamamatto banɂe tos seeteen. ");
INSERT INTO bswl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farasaawiil Yesuusa tos emeetegure usune wota dogamano haggaɂabeen, usu c'aafin dootereen Yesuusa daruurkko malaata goggotusiroon hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesuusa aaloo wodana mararere, «Hitti alattaan malaata kakkondootatta mewuunya? Ani rumminaa amara, hitta alattaanun maamisikki malaatanna lakkosisamiro!» ame. ");
INSERT INTO bswl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Esekkona iso iisere wolabo tabere bekekko gama nak'e. ");
INSERT INTO bswl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Usukko oɂagaalssatareen babo abatano mankkoɂillooteeren maraan, wolabo orroo babo koo kuwaarre koonna lakkoɂabanaayen. ");
INSERT INTO bswl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesuusana, «Tafarasaawilkkona taherodoosa meellanekko isiɂooraayen» ame ajajee. ");
INSERT INTO bswl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Isona isiɂisi orroo, «Usu haa kakkoon amara noo babo mankkowaannenno maraanya» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesuusana k'ofattisoo addeesere, «Babo mankkowaanenno maraanya amaa muun k'oppaattan? Giddanna lakkoshaadattanya? Wodanatisinii lakkoɂaddeesattaanya? Goorttun wodanattisin duuddetta? ");
INSERT INTO bswl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Iilɂo giranttii lakkodiyaattanya? Nebe giranttii lakkomaalattanya? Lakkoshaadattaanya? ");
INSERT INTO bswl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Babo ken ibaaddo kuma kennun ibise kakkosisere goorata hanbba dugud miyyaa mig keessen?» Isona, «Tomonkko lama migya ameen.» ");
INSERT INTO bswl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Usumaleenna babo todoba ibaaddo kuma afarruun ibise kakkosisere goorata dugud miyyaa mig hanbba keessen?» ame. Isona «dugud todoba mig» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yesuusana, «Isin gidda gin lakkoshaaddettaan amanoya» ame. ");
INSERT INTO bswl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Esekkona Beetesayida tos kakkogeyaaren goorata ibaaddo iilɂo kadiyaannon ibaaddoti koo Yesuusa tos keenen, goggodinddinnoon ebaaten. ");
INSERT INTO bswl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesuusana iilɂo kabayero ibaaddotikotti gene abere maamankko sar beese, iilɂo ootteessa gutii hanc'c'ufe tufere genetteessa gutii kayere, «Kuun kamutara meyya?» ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ibaaddotina t'ok'k'i ame deere, «Ibaaddo gaa aani lee kasesseetaro diyaara» ame. ");
INSERT INTO bswl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesuusana adena genennoɂootteessa iilɂo oɂibaaddoti gutii kaye, hassu goorata iilɂo tichchise dee, fayyeegure kaɂameen dubba madaare diyaano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Esekkona Yesuusa, «Maaman tos arootabtte!» «Hassu maamanii maayyoonna aroosegite» amere minkkeessa galise. ");
INSERT INTO bswl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesuusa usukko oɂagaalssatareene wota Filp'oosa K'isaariya kaɂamamaro maaman tos seetaa, raadii giraan Yesuusa usukko oɂagaalssatareene, «Ibaaddo in ayyo amara?» ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Isona, «Kat'ammak'aaro Yaannisa oɂamaraan giraan, okkaleenna Eelaasaya amaraan, okkaleenna adene kahegeroolkko kooyya amaraan» ameen segeen. ");
INSERT INTO bswl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Debeenna, «Isin adeen in ayyo amattaan?» ame hoosate. P'et'iroosana, «Ati Kiristoosatta» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesuusana, «Isiɂoottessa maayyoona iso goggoseginokko» ame ataayise iso seerise. ");
INSERT INTO bswl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Esekkona «Ere kaɂibaaddo rakkoo tamooggan atatanona, jaarsoleeyi, katuuk'aamol woyichchaalna seera kamuse oɂagaalssisaran horee kattuffaminaro, kagoyinaro, taseedi arrikko abbaabayire kakkinaro agaalssisano haggaɂabe.» ");
INSERT INTO bswl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Usuna hikka addeesise isoon segee, hassu goorata P'et'iroosa Yesuusa kale beesere hadisano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesuusa ade kambbal amere usukko oɂagaalssatareen tos diyaa P'et'iroosane, «Ati S'alaye, inkko fakkimi! Ati kaɂibaaddo kuwaarre ayees kawaa lakkok'oppaatto» ame hadise. ");
INSERT INTO bswl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Esekko abbaabatere Yesuusa gosa usukko oɂagaalssataranne wota isi tos uumere «Indebee sesseeyin, kageelaatara gogire isiɂootteessa hakakkate, mask'aliitatteessa sidayire indebee hasesseto. ");
INSERT INTO bswl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Neefotteessa haasayin kadootatara dubba baasatara, in maraanna wongala maraan neefotteessa roorisate kasisatara dubba ade isiɂootteessa fayyisatara. ");
INSERT INTO bswl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ibaaddoon alami dubba kakkeessa golee neefo gowaate meyii laɂo aba? ");
INSERT INTO bswl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Haa gollee ibaaddo neefotteessan me wodoo aba? ");
INSERT INTO bswl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Hitta talayimaattona c'ubbaalessatti alattaan horee iyyeenna haafurakkeeyi kamullaara dubba, ere kaɂibaaddo Aabbokkeessatti kabajaa, k'ulluukki erggichchaalnne wota kakkoɂemeete goorata usuu ani mullinara» ame. ");
INSERT INTO bswl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Adena Yesuusa, «Ani rumminaa amara hittanii oɂaalleeran orrokko wononnati kawaa hunnaa emeetaa giraan taa deerani ogoonooni giraan» ame. ");
INSERT INTO bswl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Arri talleyikko abbaabatere P'et'iroosa, Yayik'oobana Yaannisa abegure taɂeertti wodami too tos aate bee, kalenna gireen, isoo horeenna middittessa iggilissantte. ");
INSERT INTO bswl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Sarssikkeessana hikka ul gutii maayyona sarssi kaɂaalisara muc'c'isin kadanddeenoon gitakki aaloo gumaara lee. ");
INSERT INTO bswl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eelaasanna Musena Yesuusa wota ayeesaa giraan muteen. ");
INSERT INTO bswl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","P'et'iroosana Yesuusane; «Kaɂagaalssisatto! Hittanii girnnewa noyyeen kaɂidankkiye; too kuyeen, too Museen, too Eelaasan talleeto daase seed madaarnno» ame. ");
INSERT INTO bswl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Aaloo mankkoɂabssateraawun P'et'iroosa kaɂayeesarona lakkoɂaddeesare. ");
INSERT INTO bswl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Esekkona duumanchcha emeetegure hogoogise; duumanchcha orrokko, «Hikki ani kageelaataro erekkeeya; usu maala!» taɂamatta yaaye maalssantte. ");
INSERT INTO bswl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Goorsewa kambbal ami godeeran Yesuusa kuwaarre kakkalee maayyonna isone wota lakkogire. ");
INSERT INTO bswl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Wodami guukko kakkodagare goorata ere kaɂibaaddo goyikko taakeeroo gin kaddeeraan maayyoonna goggoseginonkko ajajee. ");
INSERT INTO bswl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Isona kaɂayeesamero haafura wodanattisooyi abbateen; ayesuun goɂameen, «Goyikko kiyaano» me amanoyo isiɂisirroo ayeesaa gireen. ");
INSERT INTO bswl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Esekkona, «Seera kamuse oɂagaalssisaran t'ayi emeeyin kaddootisara Eelaasaya muun amaraan? Amaa hoosaten.» ");
INSERT INTO bswl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesuusana, «Ogiraan Eelaasa emeeyigure ayees dubba ekkaasinara; hayya ere kaɂibaaddo tamooggan rakkoo atayiinna tuffamin dootisara amame kakkons'aafamera mewuunya? ");
INSERT INTO bswl_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ayesuun goɂameen, Eelaasa t'aye emeete gire; ibaaddo garakkeessa goggos'aafamero malee kaddootateeraan dubba feleen» amara. ");
INSERT INTO bswl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesuusana seeddo usukko oɂagaalssatareen oheseeran usukko oɂagaalssataran tos abbaabateen kakkoɂemeetareen goorata gosa kamooggan iso maraamure kukkume giraan dee, seera kamuse oɂagaalssisaran isone wota dogamaa gireen. ");
INSERT INTO bswl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Gosa dubba Yesuusa deegure goorsewa mamere usu tos tiiyye seetegure nogodda aate. ");
INSERT INTO bswl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesuusana, «Isone wota kakkondogamattaan eeti haajaayiya?» amaa hoosate. ");
INSERT INTO bswl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Gosa orrokko ibaaddoti koo haa ame: «Kaɂagaalssisatto; hiɂi kaduudisaro battiikki ayyaanayi kaɂabamero unnukkee ku tos keenayera; ");
INSERT INTO bswl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","kakkokeero goorata banɂe dubbaa lugudara, saanbbana gudisara, ilkkona fooc'ara, maarnna zorddoyisara; battiikki ayyaana usukko goggobeesinawun kukko oɂagaalssatarawun segaaye; isona beesin lakkodaanddeen.» ");
INSERT INTO bswl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesuusana abbaabere; «Isin taɂabddannon alattaan;» «hagge taageeroon isinne wota girnnara? Hagge taageeroon obssinara? Unnu in tos keena!» ");
INSERT INTO bswl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ibaaddona unnu Yesuusa tos keene; battiikki ayyaanana Yesuusa kakkodiyaare goorata unnu goorsewa harɂiisano, ul lugudano, ulle boc'c'aanona saanbba gudisano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesuusana kaɂunnuti odo uumere, «Hikki arooɂabekko gees miyyaaye?» ame hoosate. Usuna haa ame abbaabe; «Yiisummakko haggaɂabereya.» ");
INSERT INTO bswl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","«Lagadin dootegure arggetto eleen orronna beke orroddeese lugudara; kadanddeeto golleete nenɂeyisana; gargaarina.» ");
INSERT INTO bswl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesuusana, « ‹Kadanddeeto gollee› » antte? «Kaɂammanaro ibaaddon ayees dubba daanddaamara» ame. ");
INSERT INTO bswl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Goorsewa kaɂunnuti odo, «Abddatara; ayesuun goɂameen abddi takkowaataroo in gargaarina!» amaa okkee. ");
INSERT INTO bswl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesuusana, gosa eserraa tiittaa kaɂemeetaro kakkodiyaare goorata, «Ati hiɂi kaɂayeesoninna nebee kamaaloon ayyaana usukko beena! Kallami abbaabayi usu tos goggotaboonkko ajajaara!» ame battiikki ayyaana hadise. ");
INSERT INTO bswl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Battiikki ayyaanana okkee, unnu aaloo ulle boc'ee abbaabatere gafare bee; omoogganna, «Goyera» taaɂamiranii rees aani lee. ");
INSERT INTO bswl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yesuusa ade taɂunnu gene abe keese; unnutina kee aallee. ");
INSERT INTO bswl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesuusa min orroddee kakkotabare goorata usukko oɂagaalssatareen kale beeneen, «Noo beesin kakkowannenna muunya?» ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Usuna «Hikka aankkikki kakkobiin daanddaara ebiinna agabuuyi» kaalaalii kuwaarre maamesinna bin lakkodaanddaaro ame. ");
INSERT INTO bswl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Esekko keegure maaman kagaliilane roore; Yesuusana, maayyona usu takkogiro banɂe goggoɂaddeesiro lakkodootero; ");
INSERT INTO bswl_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Usukko oɂagaalssatarawun, «Ere kaɂibaaddo gene taɂibaaddoyi roorssami sisaminara; isona lagadinaran, arri seedkko danbbeebaan goyikko kinnara» amaa agaalssisaa gire. ");
INSERT INTO bswl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Isoon ade usu kaɂamara lakkotabere, hoosayinna abssateen. ");
INSERT INTO bswl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Esekko abbaabatere Yesuusana usukko oɂagaalssataran tak'ifirenaahoomi katamaa tos emeeten. Min orroddee tabegure «Raadii giraan kakkondogamatteen gara kammeeya?» ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Iso adeen raadii giraan kakkodogamareen dubbaankko kajiinaatara ayyoyya? Kaɂamaro mankkolee maraan c'alɂi ameen. ");
INSERT INTO bswl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesuusa hamas's'eegure iso orrokko tomonkko lama uumegure, «dubbaankko kahoree liin kaddootatara, dubbaankko harc'c'ana dubbaawun kahandaaro halleewo» ame. ");
INSERT INTO bswl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kic'c'arkki yiittiti keenegure iso t'eɂee aallise; kabalatere, ");
INSERT INTO bswl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Hikka yiisaaskko koo megekkeeyi kak'op'atara dubba in k'op'atara; inna kak'op'atara in haalleenooni in kafarero k'op'atara» ame. ");
INSERT INTO bswl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","«Yaannisana, kaɂagaalssisatto ibaaddoti koo megekkaayi durrisa beesaa giraan deenne, no wota mankkosessennowun maraan tirnnenna» ame. ");
INSERT INTO bswl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesuusa ade haa ame; «Arootirtteen; maayyonna megekkeeyi baasa feligure goorsewa in gutii tameellan ayeesin lakkodaanddaaro; ");
INSERT INTO bswl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Noo kadiidoon dubba noonne wota gira; ");
INSERT INTO bswl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ani rumminaa amara okiristoosa mankkoleeteen maraan megekkeeyi k'uldubbo too beke isin kat'amisara dubba laɂo lakkowaaro» ame. ");
INSERT INTO bswl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Maayyona iin oɂammanaraan hinɂa otitiic'c'arkko koo kahanduddufisara dubba kaɂatii eɂemo karriime marggii shiyaamigure beke orroddi shafamewa idankkiyya. ");
INSERT INTO bswl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Haanssun genetta ku gohanduddufise goosina; gene lama kuun girigudde gahaanname tabbaanon eleenii tos tabanokko, gene muddunane wota jiruu jiroommakki giri tos tabano kaɂidankkiya; ");
INSERT INTO bswl_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Gahaanname eleen tabaanoon; hiskkittisona lakkogooto eleenna lakkobaato. ");
INSERT INTO bswl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Luk'k'aɂootta ku gohanduddufisen goosina; luk'a lama kuun girigureen tabaanon eleen orroddi shafamanakko, kaɂeesatto liigudde jiruu jiroommakki giri tos tabano kaɂidankkiya; ");
INSERT INTO bswl_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tabaanon eleenii hiskkina lakkogooto eleenna lakkobbaato ");
INSERT INTO bswl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Iltta ku gohanduddufise tagi beesi; iilɂo lama girigureen gahaanname eleen tabbaanon orroddi tabanokko, il too girigudde wononnati kawaa tos tabano kaɂidankkiya; ");
INSERT INTO bswl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tabbaanon eleenii hiskkinna lakkogooto, eleenna lakkobbaato. ");
INSERT INTO bswl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«Jaarsso esseboo goggomuc'c'iɂamaroo ibaaddo dubbana eleenii muc'c'iɂamano dootisara. ");
INSERT INTO bswl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","«Essebo taɂidanttitta; ayesuun goɂameen essebo onɂomoonjettisee gowaatte meyii abbaabi onɂomoonjetise goggogirttoon yelnnattaan? Essebo isin orroo haggirtte; isi isiɂorroonna ekkaayen nogoddaa gira.» ");
INSERT INTO bswl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesuusa esekko keegure, ul kayihuuda tosna Yorddaanoskko gamanne kagiro gobob tos seete; aaloo kammooggan gosa ade usu tos kukkuɂamaa gire; hittakko horeene goggoyelaa gireeyi iso agaalssise. ");
INSERT INTO bswl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kafarasaawi ibaaddokko kookkoo Yesuusa tos emeetegure; usu c'aafin dootegure, «Ibaaddo ooritteessa keelkki ami gafarin dootisara?» ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Usuna abbaabere, «Muse me ame isin ajajeera?» ame. ");
INSERT INTO bswl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Isona, «Muse goɂameen keelkki kakkoɂamamero worak'ata s'aafire goggogafarroo ame feɂi sisera» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesuusana abbaabere; «Muse hikka ajaja kakkoons'aafera wodanattisin taduudde mankkolleete maaranya.» ");
INSERT INTO bswl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","«Ayesuun goɂameen Waa t'aye ibaaddo met't'aa ‹Babbaartitina heleelttiti yele met't'ee.› ");
INSERT INTO bswl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‹Haanssun ibaaddo Aabbokkeesana Aayetteessa iisaagara; ooritteessane wota k'urannaamara; ");
INSERT INTO bswl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Iso lamana maar koo laaran;› goorttanun maar koo laaran kuwaarre lama lakkoyaan; ");
INSERT INTO bswl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Haanssun Waa kak'uranneero maayyona furin lakkodaanddeero» ame. ");
INSERT INTO bswl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Adena min kakkotabareen goorata, usukko oɂagaalssatareen hitta haajaa keeseen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesuusana «Maayyonna ooritteessa keelkki amere takkalee kaɂatatara ooritteessa gutii sharmmut'aara; ");
INSERT INTO bswl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Esena entterkkiseekko keelkki amamidde kakkaleetun gokkeesantte sharmmut'itetta» ame. ");
INSERT INTO bswl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yesuusa goggodindinnon; ibaaddo yiisaas usu tos keenataa gire; Yesuusakko oɂagaalssatareen adeen hadiseen. ");
INSERT INTO bswl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesuusana hikka deegure amaraatere; «Yiisaas in tos haɂemeete, aroottirtteen; wononnati kawaa hinɂa aanɂinɂiiya ame. ");
INSERT INTO bswl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ani rumminaa amara; wononnati kawaa yiisaas aani kak'op'annon dubba suure lakkotabiro» ame. ");
INSERT INTO bswl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yiisasnna kabalate abatere; genetteessa iso gutii kayegure sommaasate. ");
INSERT INTO bswl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesuusa esekko beegure raadii bee sesseetaa giraan, ibaaddoti koo usu tos tiyaa emeete; usu horee gilbbisegure «kaɂidankki kaɂagaalssisatto; jiruu jiroommakki giri eelin me yelin dootisara?» ame. ");
INSERT INTO bswl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesuusana; «Muun in kaɂidankki amatta? Waa koo kuwaarre kaɂidankki lakkogiro; ");
INSERT INTO bswl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ajaja kaseera kassowa; aroolagadde, aroosharmuut'ite, aroohette, t'ara arooɂatotiite, aroosobtte, Aabbokkaanna Aayettaa kabajjiina» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ibaaddotina, «Kaɂagaalssisatto; hinɂa dubba yiisummakko haggaɂabere oorayeera» ame. ");
INSERT INTO bswl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesuusana deegure geelate; «Goorttanu ayees kooyya kuun kahank'atera; seegudde kaɂabtto dubba daddaligudde; hiyyeessalun sisi; daruurnna okukkuɂameraan urrawo helayinnatta; esekko danbbeebaan koyi iin debee sessee» ame. ");
INSERT INTO bswl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ibaaddotina hikka kakkomaalare goorata gomeellan yaade; usuun urrawo omooggan mankkoggireen maraan yaadaa seete. ");
INSERT INTO bswl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesuusa kambbal ame deegure usukko oɂagaalssataranne, «Dureessajjol wononnati kadaruure tabano misikki kaɂisilaaro ayeesya!» ame. ");
INSERT INTO bswl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Usukko oɂagaalssataran ayeeskkessayi mameen; Yesuusa ade abbaabate haa ame; «Yiiskkee; wononnati kawaa tabano misikki kaɂisilaaro ayeesya! ");
INSERT INTO bswl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Dureessan wononnati kawaa tos tabanokko suure gaala butto kamarffine orromari roorano ene leera» ame. ");
INSERT INTO bswl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Usukko oɂagaalssataranna aaloo mamanoyi, isiɂisi orroo «Hayya ayyoyya fayyiin kadaanddaara?» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesuusana iso tos diyaa, «Hikki ibaaddo dollee lakkodaanddaamaro; Waayi dollee goɂameen daanddaamara; waayi dollee kameen dubbana daanddaamara» ame. ");
INSERT INTO bswl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","P'et'iroosana, «Hikkima noonna kameen dubba iinsse ku debee sesseennenna» ame. ");
INSERT INTO bswl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesuusana abbaabe; «Ani rumminaa amara; in maraaninna wongala maraan amere minkkeessa goorttun abbilaaltteessa goorttun abbalaaltteessa goorttun Aayetteessa goorttun Aabbokkeessa goorttun yiiskkeessa goorttun irakkeessa kaɂiise dubba, ");
INSERT INTO bswl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Gidda hikka geesii bak'atanone wota minjjool, abbilaal, abbalaal, Aac'c'olaal, yiisaas, irana boolkokki ambbaa atayinara, kaɂemeetaro alamii jiruu jiroommakki giri kaɂeeloon lakkogiro. ");
INSERT INTO bswl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ayesuun goɂameen ohoree olleeraan omooggan oddanbbee linnaraan, oddanbbee olleeraanna ohoree liinaraan» ame. ");
INSERT INTO bswl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Iyyerusaalemi tos biyaa raadii giraan, Yesuusa horehayere sesseetaa gire; usukko oɂagaalssatareen mameen, okkalee debee osesseetareen adeen abssateen gineen adena tomonkko lama gosakko assaabere me usu ginnaro segee; ");
INSERT INTO bswl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Goortta noo Iyyerusaalemi tos binnanna, ere kaɂibaaddo tuuk'aamokokki woyichchaaluniinna seera kamuse oɂagaalssisaraawun roorissami sisaminara; isona goyikokki firdda firddinaraan; Ayizaabn roorisi sisinaran; ");
INSERT INTO bswl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ayizaablna k'ac'c'ifayinara; hanc'c'ufena tufinaraan, boc'c'innaraan, esekkona lagadinaran; usu adi arri seedkko danbbeebaan kiinnara.» ");
INSERT INTO bswl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Esekkona yiis kazabddoosa Yayik'oobana Yaannisa Yesuusa tos gabbalameengureen, «Kaɂagaalssisatto; noo kukko kaɂebaatanno dubba noon goggosissoo dootanna» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesuusana, «Me ani isinuun goggoyelloon dootaattan?» ame. ");
INSERT INTO bswl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Isona, «Kabajattaakki goorataayi nookko koo merggettaayi koo betettaayi goggohamas'iinnon noon feɂi sisi» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesuusana, «Isin kaɂebaatattaan lakkokassaan; ani tat'amaro tarrakkoo t'ugga t'amin, ani kat't'ammak'aamaro t'ink'ata t'ammak'amin daanddaattan?» ame. ");
INSERT INTO bswl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Isona; «Ii daanddaanna» ameen. Yesuusana; «ani tat'amaro t'ugga t'anttaanwa; ani kat'ammak'aamaro t'ink'atanna t'ammak'anttanwa; ");
INSERT INTO bswl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ayesuun goɂameen merggetteeyi goorttun betetteeyi hamas's'aano Waa kakkoonɂekkaaseron kuwaarre ani kasisinaro ayees lakkoyo» ame. ");
INSERT INTO bswl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Oheseeren tomonno hikka maaleengureen Yayik'oobana Yaannisa inggaamano haggaɂabeen. ");
INSERT INTO bswl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesuusana iso raattoo kukkuyisere haa ame; «Kaɂayizaab woyichchaal amameen ohedamaraan odonnati obariisinnaraan, shuumooleettisona iso gutii odonnati otusayinnaran isin kassanwa; ");
INSERT INTO bswl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Isinii dollee ade hikkamalee liin lakkodootisaro; isin orrokko kanjjinkki liin kaddootatara dubba isinuun kahandaaro halleewo; ");
INSERT INTO bswl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","kahoree liin kaddootatara dubba kadubbaa diyyii halleewo; ");
INSERT INTO bswl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ere kaɂibaaddo handdayinna neefotteessa kamoogganun wodoo yeli sisayin emeetera kuwaarre goggohanddayinawun lakkoɂemeetero.» ");
INSERT INTO bswl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Esekko abbaabateeren taɂiyyaarkko katamaa tos emeeten. Yesuusana usukko oɂagaalssatareen gosa kamoogganne wota Iyaarkokko biyaa giraan iilɂo kadiyaannon kat't'emewosa ere Bert'elomeewosa raa giridii hamas's'eere ebaataa gire. ");
INSERT INTO bswl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Usuna esene karoorara kanaazireti Yesuusa laano kakkomaalare goorata, «Ere kadaawute, Yesuusa; in maari!» amaa okkaano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kamoogganna usu c'alɂi goggoɂamiroo hadiseen; usu goɂameen, «Ere kadaawute; in maari!» amaa aaloo jiinase iyyee. ");
INSERT INTO bswl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesuusana aalleegure; «Uuma!» ame. Isona Iilɂo kabayerone; «Allamandde! Ki! Yesuusa uumara!» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Usuna sarssikkeessa shafegure fit'a ame kee aallee Yesuusa tos emeete. ");
INSERT INTO bswl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesuusana «Me goggoyelloo dootatta?» ame. Iilɂo kadiyaannonna «Kaɂagaalssisatto; din dootara» ame. ");
INSERT INTO bswl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesuusana; «See ammanokka ku fayyiisera» ame; goorsewa iilɂo deenddeen; usu raannewa Yesuusa debee sesseete. ");
INSERT INTO bswl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesuusana usukko oɂagaalssatareen Iyyerusaalemi kakkogabbalamereen goorata zayitii kabiyaara gaa takkoɂalataro wodami tonsse dollee kagiro kabeetefaagena kabitaanya maaman tos geegeen, Yesuusa usukko oɂagaalssatareenkko lama haa amaa fare; ");
INSERT INTO bswl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Isin horee kagiro «Maaman tos seeyeen; ibaaddo hamas's'i takkokasoon darmmee tademeer esee tashaanttetto helnattaan; furaddeene keena; ");
INSERT INTO bswl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Maayyona, isinne ‹Misi yelattaan?› goɂame; ‹Goottawun dootisara; banneewa abbaabi farnnara amaddeen segaa.› » ");
INSERT INTO bswl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Isona seeteen; min kooyi sarre tashaanttetto darmmee tademeer heleen; fureen. ");
INSERT INTO bswl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Esee aallee kagire ibaaddokko kookkoo, «darmmee kakkonfurattaan mewuunya?» ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Isona, Yesuusa kaɂamero ibaaddon kakkosegaaren goorata isona feɂi siseen. ");
INSERT INTO bswl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Darmmeenna Yesuusa tos keenenguren sarssikisoo kadarmme bagadi gutii yayeen; usuna gutii hamas's'ee. ");
INSERT INTO bswl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kamooggan ibaaddona sarssikisoo raadii yayeen; okkaleenna adeen kabarzafe gaakko ballaal tarshee aateen ul yaa gireen. ");
INSERT INTO bswl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yesuusakko horeene osesseetarenna haarre debee osesseetaren kaɂatii haafuraayi haa amaa gireen; «Hoosaɂina!» Mege kagoottayi kaɂemeetara kasommaasameya! ");
INSERT INTO bswl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","«Kaɂemeetara Aabbokkaani kadaawutekki wononnati kasommaasameya;» «Hoosaɂina aariyaami!» (dubbaankko t'ok'k' kaɂantte daruurii somma waawuun halleen!) amaa iyyaaren. ");
INSERT INTO bswl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesuusana Iyyerusaalemi geegee; esekkona k'ulluukki min kawaa tos tabe; usu maraamure kagiro dubba dee; ul hemeen kakkolaare goorata tomonkko lamane wota Bitaanya tos seete. ");
INSERT INTO bswl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tallami arri Yesuusa Bitaanyakko biyaa giraan uɂee. ");
INSERT INTO bswl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Usuna baalallo kaɂabo kabalesi gaa ebbaa dee; woddaasa il dubami girtto amaa usu gaa tos seete; ayesuun goɂameen usu gaa takkodubaamaro diginni lakkotte baalallo kuwaarre koonna lakkohelate. ");
INSERT INTO bswl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Esekkona Yesuusa kabalasi gaanne; «Giddakko haggaɂabire jiruu jiroomman maayyonna kukko il arooɂaamo» ame. Usukko oɂagaalssatareen usu hikka ayeesaa giraan maaleen. ");
INSERT INTO bswl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Iyyerusaalemi tosna seeteen; esekkona Yesuusa k'ulluukki min kawaa orroddee tabegure, oɂiminataraanna odaddalataran orrokko beesano haggaɂabe, maragade oɂiggilssataraankonɂi t'arap'eezzalnna arabe odaddalatarankokki arjaataal minaminaɂabbaabe; ");
INSERT INTO bswl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Maayyonna huu sidaayire k'ulluukki minkkotti ali orroo mari goggororoonkko tire. ");
INSERT INTO bswl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Agaalssisaanna haa ame; «Minkki gosa dubbaan min kaɂebiya amamara amame lakkos'aafameroya? Isin addeen kashittaa laga yeltteen!» ame. ");
INSERT INTO bswl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Katuuk'aamol woyichchaalnna seera kamuse oɂagaalssisaran hikka maaleengureen usu tayeli lagadinaan raa dootano haggaɂabeen; halleewo kuwaarre gosa dubba agaalssiskkeessaa mamaa mankkogire maraan usu abssatenan. ");
INSERT INTO bswl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ul hemeen kakkolaare goorata Yesuusana usukko oɂagaalssataran ese katamaakko beengureen seeteen. ");
INSERT INTO bswl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tallami arri bari raane rooraa giraan, gaa kabalasi hididinnee kaɂangagero deen. ");
INSERT INTO bswl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","P'et'iroosa ayees k'alli kakkoɂamare goorata Yesuusane, «Kaɂagaalssisatto; hikkima ati kak'anggitetta kabalasi gaa angagera» ame. ");
INSERT INTO bswl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesuusana abbaabere; «Waayi ammana.» ");
INSERT INTO bswl_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","«Ani rumminaa amara; maayyonna hitta wodamine, ‹Tagamidde beke orroddee ii› goɂame hikkana wodanatteessayi ahedannoonii goɂebaate leerowa. ");
INSERT INTO bswl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Haanssun ebii kaɂebaatattaan dubba kaɂatatteettaan aani yeli goɂammanatteen leerowa. ");
INSERT INTO bswl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Adena ebaayin kakkoɂaalliteen goorata; kadaruure Aabbokkisin c'ubbokkisin haheso goggoɂamiroo; isinna ibaaddo gutii taɂabttaan kajju dubba haheso ama. ");
INSERT INTO bswl_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Isin kakkaleekokki baas haheso goɂamoon ade kadaruure Aabbokkisin c'ubbokkisin haheso lakkoɂamiro.» ");
INSERT INTO bswl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Adeen Iyyerusaalemi tos seeteen; Yesuusa k'ulluukki min kawaa awudii orroo sesseetaa giraan katuuk'aamol woyichchaal, seera kamuse oɂagaalssisaranna jaarsolee usu tos gabbalameengureen, ");
INSERT INTO bswl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","«Hikka ayeesjjool kakkofelatta odonnati kaayyoya? Hikka goggofeltton kuun odonnati kasisera ayyoyya?» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesuusana abbaabere; «Alla ani hoosiin too isin hoosaro; abbaaba; aninna hikka ayeesijjool eeki odonnati ani felaro gachchoosegiira. ");
INSERT INTO bswl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kayaannisa t'ink'ata Waakkoya muu ibaaddokkoya? Abbaaba» ame. ");
INSERT INTO bswl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Isona isi isiiroo haa ameen; «Waakkoya goɂaminne, ‹Hayya muun ammanana waattettaan?› aminara; ");
INSERT INTO bswl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Hayya ibaaddokkoya aminno?» gosa dubba Yaannisa ogiraan kahegeroo laano abddateen mankkogireen maraan abssateen. ");
INSERT INTO bswl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Haanssun Yesuusaan «Noo lakkokansso» ameen abbaabeen. Yesuusana, «Goorttanun aninna hikka ayeesijjool eeki odonnati ani felaro lakkoseginaro» ame. ");
INSERT INTO bswl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Esekkona Yesuusa haa amaa masuussayi isoon segaano haggaɂabe; «Ibaaddoti koo kawoyinii akaakiltte abbarate; maraamurise ooti kaate; woyinii kakkomuulaaro gumbbina oshate; taɂoraroo tak'ena madaarate; esekko otateen obaraarawun kirayii sisegure ul kakkalee seete. ");
INSERT INTO bswl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kaami takkokukkuɂamaro diginni tadubanttetto tawoyinii ilkko goggokeennawun usuun kahandaarekeessa otateen obaraaran tos fare. ");
INSERT INTO bswl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Iso goɂameen abeen boc'c'een gene taalaalnna gafareen. ");
INSERT INTO bswl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Adena kakkalee kahandaaro fare; isona metekkeessa berɂeesen yeraaseen abbaabeen. ");
INSERT INTO bswl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Giddanna ade kakkalee fare; hikkana lagadeen; okkalee omooggan orrokko kookkoo boc'c'eeran; kookkoonna lagadeen. ");
INSERT INTO bswl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","«Giddanna kafaraminara kakkalee usuun gire; usuna usu kageelaataro erekkeessaye; ‹Erekkee kabajiinawa› amaa dubbaankko danbbenne fare. ");
INSERT INTO bswl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","«Otateen obaraaran goɂameen isiɂorroo; ‹Hikki waannaa kaɂeelaroya; koyeen laganddo; erretteessa tattaani leeta› ameen. ");
INSERT INTO bswl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Esekkona abeen lagadeen; tawoyinii banɂekko sar beesen shafeen. ");
INSERT INTO bswl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«Goorttanu gaa kawoyiniikokki odo me kayelnnaro aani laara? Emeeyinara; otateen obaraaran lagadinara; kawoyinii akaakiltte okkaleetun sisinara. ");
INSERT INTO bswl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Goorttun, « ‹Gimbbe oginbbaaraan kattuffateen eɂemo, usu mina afarruun mete lee; amame kas'aafamero haafura lakonabbabtteettaaniya? ");
INSERT INTO bswl_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Hikka kafelera Gottaaya; hikkina Iilɂoɂoottanii kasaadisiroyya.› » ");
INSERT INTO bswl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ayihuudikokki woyichchaal Yesuusa masuussayi kakkoɂayyesera garakisoo laano kakkoɂaddeesare goorata usu abin doote; ayesuun goɂameen gosa mankkoɂabssatare maraan iise seete. ");
INSERT INTO bswl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Esekkona ayees hegelkko aati abin kafarasaawi ibaaddokkona taherodoosa unakko ibaaddo Yesuusa tos fareen. ");
INSERT INTO bswl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Isona emetengureen; «Kaɂagaalssisatto; ati karrummii ibaaddoti laanokkaa kanssowa; bebbeed taɂibaaddo deete koo tos haɂululisooni kawaa raa kaalaal rummi agaalssisatta; golleenna k'eesarin giira murin dootisara muu lakkodootisaroya? Noo murnno muu lakkomurnoya? ");
INSERT INTO bswl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yesuusa goɂameen ifissaaddaa laanokkisoo malabere; muun inkko ayees hegelkko aatin dootaattan?» Alla dinnaari koo keena ani deero ame. ");
INSERT INTO bswl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Isona keneen, «Hitti middi taayyotta? S'aafano kaayyoya?» ame iso hoosate, «Isona tak'k'eesaritta» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesuusana; «Kak'eesari kalleero K'eesaariwun sisa kawaa kalleero Waawun sisa» ame. Isona usuu mameen. ");
INSERT INTO bswl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hittakko horenbbaan goyikko kiyaano lakkogiro oɂamaraan kasodek'awil ibaaddo Yesuusa tos emeetegure haa amaa hoosate; ");
INSERT INTO bswl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Kaɂagaalssisatto;» ibaaddoti kookokki abbi oori atayigure yiis haɂumuloon goggoye, «Hikki ibaaddoti hitta heleelttiti atayigure abbikkeessatti sannii goggokayiroo ame Muse s'aafera. ");
INSERT INTO bswl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Hayya abbilaal todoba gitte; kahoree atatere sannii hakkaannooni goye; ");
INSERT INTO bswl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kallamikkina hitta heleelttiti atate; usuna sannii hakkaannooni goye; kaseedina hikkamalee; ");
INSERT INTO bswl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Todoba dubbana atateen sannii goɂameen lakkokaateen; danbbene ade heleelttiti goote. ");
INSERT INTO bswl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Goorttanu todoba dubbana atateeran goyikko takkiyaano arri hinɂakko ese ayyoon oori linnatta?» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesuusana isoon haa ame abbaabera; «kakkoshiriɂamattaan k'ulloolee mas'aafaalnna hunna kawaa mankkokasanawaatten maaranya. ");
INSERT INTO bswl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ogoyeraan goyikko kakkokeeran goorata kadaruuree erggichchaal aani linnaraan kuwaarre lakkoɂatataraan lakkonakeesamaraan. ");
INSERT INTO bswl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Goyikko keyaanokokki gara goɂameen kamuse mas'aafayi hikkina gara kahuris taɂayeesero kifili Waa ‹Ani kaɂabraame Hedo, kayissaak'a Hedo, kayayik'ooba Hedoya kaɂamero lakkonabbabtteettanya?› ");
INSERT INTO bswl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Waa arddonɂikkokki Hedoya kuwaarre kagoyi Hedo lakkoyo; haanssun aaloo shirnttettan.» ");
INSERT INTO bswl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Seera kamuse oɂagaalssisaraankko koo emeetegure dogamaagiraan maale; Yesuusana usu tos taɂemeettette hoosiinun abbaab kaɂidan isoon abbaabano shaadere, «Amiinna; ajaja dubbakko karoorara eekiyya?» ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesuusana haa ame usuun abbaabe; «Dubbaankko kajiinaatara ajaja hikkaya ‹Isiraɂeel maali; Gootta Hedookkaani Goottaa kooyya; ");
INSERT INTO bswl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Atina Goottaa Hedokkaa duuddotti wodanattaayi, duuddotti neefottaayi, duuddokki yaadakkaayinna duuddokki hunnakkaayi geelaa.› ");
INSERT INTO bswl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kallamikki ajajana hikka aani kallaaroya; ‹Ollaattaa isiɂoottaa aani geelaa› kaɂamaroya. Hinɂa ajaja lamakko karoorara kakkalee ajaja laagiro.» ");
INSERT INTO bswl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Seera kamuse kaɂagaalssisaranna Yesuusana haa ame; «Kaɂagaalssisatto!» «Taɂidan anttetta; Waa kooyya; usukkona kakkalee giranawaatti ayeesanokka rummiya; ");
INSERT INTO bswl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Haanssun ibaaddo duuddotti wodanattaayi, duuddotti sammuuttaayi, duuddotti neefottaayi, duuddokki hunnakkaayi geelatano, usumaleenna ollaattaa isiɂoottaa aani geelatano, kagubamaro jaarsso dubbakkona kakkalee jaarsojjoolkko roorara.» ");
INSERT INTO bswl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesuusa seera kaɂagaalssisarekki k'arummaanna shaadkko abbaabano deegure, «Ati wononnati Waakko fakki kaɂantte lakkotto» ame. Hassekko abbaabatere hoosayin kajjabaate koonna lakkogiro. ");
INSERT INTO bswl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesuusa k'ulluukki min kawaakkokki awudii kakkoɂagaalssisare goorata haa amaa hoosiin hoosaten; «Seera kamuse oɂagaalssisaran Kiristoosa ere kadaawuteyya misii amaraan? ");
INSERT INTO bswl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daawutena metekkeessawun k'ulluukki ayyaanayi kekkeegure, « ‹Goottaa Goottakki, diinakkaa luk'k'aɂoottaa hegelii ani kuun «taa yelloo geegin merggetteeyi hamas's'ii ame amara.» › ");
INSERT INTO bswl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Hayya Daawute metekkeessan ‹Gootta› goɂamiro; misii abbaabate ere laara?» Gosa kamoogganinna geggelooyi maalaa gire. ");
INSERT INTO bswl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesuusa kakkoɂagaalssisare goorata haa ame; «Seera oɂagaalssisaraankko isiɂoottisin oorayeen; kaɂeer k'olo sarssateenguren maraamuri sesseeyin geelataran; giyaa orroonna takabajaantte nogodda atayin dootaraan. ");
INSERT INTO bswl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ayihuudikokki min kaɂebinna kakkabajaame barc'uma, banɂe taɂaamoyinna takabajaantte banɂe dootataraan; ");
INSERT INTO bswl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Eeraasi ebaatanokkiso aalantti yelaa galttaanttejjolkokki min hawɂayi yelaraan; hinɂi kaɂatii firdda atayinaraan.» ");
INSERT INTO bswl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesuusa mus'uwaata kakkoɂabaabaraan saat'ine dollee hamas's'eegure kamooggan ibaaddo ilabojoolkkeessa k'ulluukki min maragade kakkokaamaro saat'ine orroo lugudaa giraan diyaa gire. Kamooggan dureessalnna kamooggan maragade lugudeen; ");
INSERT INTO bswl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","hiyyeetti galttaantteti too adde maallak'a lama tanaasi maragade lugudde. ");
INSERT INTO bswl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesuusa usukko oɂagaalssataran «Uumegure, haa amera; ani rumminaa amara; hitti hiyyeetti galttaantteti saat'ine orroddeeseen olugudeeraan okkaleekko kajiinaaro luguddetta. ");
INSERT INTO bswl_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Hinɂi dubba kahelateeran worɂekko siseeraan; ese goɂameen hiyyummattiseekokki hunnakko dubba bariisanoowun eseen kalleero hahaasannooni goggogiroo sissetta» ame. ");
INSERT INTO bswl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesuusa k'ulluukki min kawaakko biyaa giraan usukko oɂagaalssatareenkko koo, «Kaɂagaalssisatto; eɂemojjol misii giro, kaginbbe min misii kaɂiidaroyo deena» ame. ");
INSERT INTO bswl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesuusana abbaabere, «Hikki kajiinjjiin gimbbeejjool diyaatta? Eɂemo koo kakkaleeyi gutii goggogiroo lakkohesnaro; dubbana kadiigamiroyya» ame. ");
INSERT INTO bswl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesuusa k'ulluukki min kawaa horee zayitii kabiyaara gaa takkoɂalataro wodami gutii hamas's'ee giraan P'et'iroosa, Yayik'ooba, Yaannisane Indiraasane kale usu tos gabbalameen haa amaa hoosaten; ");
INSERT INTO bswl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Hikki goree linnaro noon segii; hikki dubba gudayin kakko gabbalame goorata katusinara malaata meyya?» ");
INSERT INTO bswl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesuusana haa amano haggaɂabe; «maayona isin goggosoboonkko isiɂoottisin oorayeen; ");
INSERT INTO bswl_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Omoogganinna ‹Ani Kiristoosayya› amaa megekkeeyi emeeyinaran; kamooggan ibaaddona sobinaraan. ");
INSERT INTO bswl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Isin dollee jereen kiyaanona ebbaa jereenkkotti odu kakkomaaltteen goorata arooneyiteen; hikki liin dootisara gachcho adde ganaatta. ");
INSERT INTO bswl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Gosa gosaayi gutii, wono wonooyi gutii, kiinnara; banɂe tammooggani ulkokki aɂaanonna uɂi linnara; hikki dubba kaɂummullaa muddama kahoraarijeeya. ");
INSERT INTO bswl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Isin goɂameen isiɂoottisin oorayeen; isin shonggoowun roorisi sisinaran; kaɂayihuudikokki min kaɂebinna boc'c'innaraan; ato goggolleetanun aalantti teeyi mootijjolnna wonolaal horee aallinnattaan. ");
INSERT INTO bswl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Dubbaankko t'ayi ade wongala gosa dubbaan lallabaamano dootisara. ");
INSERT INTO bswl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Abamiddeen firddaan kakkosisanttaan goorata, ese saatii isinuun kasisamaro kaalaal ayeesa kuwaarre me ayeenssa amaa t'ayi arooc'annak'antteen; kaɂayeesara Ayyaana K'ulluukki kuwaarre lakkoɂisinttaan. ");
INSERT INTO bswl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Abbi abbikkeessa, odona erekkeessa goyin roorisi sisinara; yiisaas oɂummuleeraan gutii diina linnara; lagadinara. ");
INSERT INTO bswl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Aalantti teeyi ibaaddo dubbaa dollee odiidantteen linnattaan; ayesuun goɂameen taagachcho geeroo kaɂataate hassu fayyaara.» ");
INSERT INTO bswl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Baaskkokki battinnati mutin takkodootisoon banɂee aallee giraan kakkodeeteen goorata kanabbabera hashaado; ul kayihuudaayi ogiraanna wodami tos habak'ateen; ");
INSERT INTO bswl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Minkkeessatti heelinchchoo gutii kagira arooddago; huukkeessana beesayin min orroddi arootabo; ");
INSERT INTO bswl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Iraa kagirana sarssikkeessa atayin haar arooɂabbaabanno. ");
INSERT INTO bswl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ese arrii heleel kafatoowunna kaɂiilisarowun rakkoo taɂatii leeta! ");
INSERT INTO bswl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Hikkina bat't'eesayi goggolleenoonkko ebaayen; ");
INSERT INTO bswl_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Aalanttina horaarjje Waa met't'a takkomet'ero arrikko keesegure taa hittaari geeron, tallikkasoon rakkoo ibaaddon emeeyinatta, horenbbaawun talleennoon rakkoo taɂatii ibaaddo gutii emeeyinatta. ");
INSERT INTO bswl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Goottaa hanɂu arrijjool gabaabbisi waatewa maayyona lakkofayyinare; Waa oɂassaabameeraan maraan amegure ade arrijjool gabaabbisera. ");
INSERT INTO bswl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Hassu goorata maayyona; ‹Hikkima; Kiristoosa hassee gira,› Haa goɂameenna goorttun, ‹Hikkima; hittanii gira› goɂameen arooɂabddatteen. ");
INSERT INTO bswl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ot'araa Kiristoosajolnna ot'araa ohegerool kiinnaraan; baasana kasaadamiro felaa isoon godaanddaame oɂassaabameeraan duuddo shirsaraan. ");
INSERT INTO bswl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ayesuun goɂameen goorata hangeenooni ani isinuun segeera, haanssun isin isiɂoorayeen. ");
INSERT INTO bswl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Hassu goorata, rakkookko danbbenne « ‹Arriti mugud linnatta, diginnina ifakkisee lakkosisinnatto; ");
INSERT INTO bswl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Barraajjana daruurkko ubayinara; daruuri kagira hunnana shalagaaminara.› ");
INSERT INTO bswl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","«Hassu goorata ere kaɂibaaddo kaɂatii hunnaayinna kabajaa duumanchchaayi emeetaa giraan usu dinnaraan. ");
INSERT INTO bswl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Usuna erggichcha farigure mina afarkko; ulkotti gachchokko taa daruurkkotti gachcho geeroo Waayi oɂassaabameeran kukkuyisinara. ");
INSERT INTO bswl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Gaa kabalasikokki masuusa agaalssayeen; ballaal gohurisiro baalallona gooc'ariidinan bat't'eessa gabbalamano addeesattaan; ");
INSERT INTO bswl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Usumaleenna ade hikka ayeesjjolkkokki gudatano goddeeten ere kaɂibaaddokotti emeeto gooc'ayi gabbalamano addeesa. ");
INSERT INTO bswl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ani rumminaa amara, hikki ayeesjjool taagudaroo geegin hitti alattaan duuddo lakkoroortto; ");
INSERT INTO bswl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Daruurnna ulnna roorraanwa haafurakki goɂameen lakkoroorro. ");
INSERT INTO bswl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Ayesuun goɂameen ese arrina ese saatii odo kuwaarre, kakkalee gohesena kadaruure erggichchaalnna leereen, erekkeessa golleenna, maayyona lakkokaso. ");
INSERT INTO bswl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Haanssun goorata maaggoree linnaro lakkokassaan isiɂoorayeen; ataayeen. ");
INSERT INTO bswl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Hikkina minkkeessa oɂooraanawun sisegure, ohandaaraawun metemeteeyi feloo hedeede sisegure, kaɂoorara ataayi goggoɂoorroon ajajeere kaseetero ibaaddoti aani laara. ");
INSERT INTO bswl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","«Goorttanun odo minee ibitto goorttun hemeen t'eɂe, lukkale oɂwaa goorttun ul bulla oɂwaa emeeyinaro goorata lakkokassaan; haanssun ataayeen oorayeen. ");
INSERT INTO bswl_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Odo minee isin derɂa giraan goɂemeete huddurtteen ogittan arooddeenno! ");
INSERT INTO bswl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ani isinuun kasegeero ibaaddo dubbaan seginnara; atayeene, ame.» ");
INSERT INTO bswl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kafaasikkaanna kababoo baala kabajaamin arri lama hesse giraan katuuk'aamol woyichchaalnna seera kamuse oɂagaalssisaran Yesuusa miiggeeyi kakkoɂabraanna kakkolagadiraan raa dootaa gireen. ");
INSERT INTO bswl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ayesuun goɂameen; «Gosa okko goggokeesonkko kabbaala almmaayi laano lakkodootisaro» amaa gireen. ");
INSERT INTO bswl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesuusa kabitaaniya maamanii maarii bar kaɂabokokki kasimoona minii babo aamin hamas's'ee giraan, heleelttiti too dookki aaloo awɂallo talleetetto muc'c'i taɂantte narddoosa kaɂamamaro gaakko tafelanttetto shittooyi kaɂammagaamero kaɂalbbast'iroosi bilk'aadee abtte emeette, bilk'aadena ebissegude shittoo Yesuusaa gutii kikkibtte. ");
INSERT INTO bswl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Esee ogireenkko kookkoo feloɂoottiseeyi amaraatengureen isiɂorroo haa amaa gireen; «Hitti shittoo muun adda darɂaamatta? ");
INSERT INTO bswl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Hitti shittoo seed boolee dinnaarikko guuntte daddalamigudde, hikka maragade hiyyeessan siseenwa kaɂidankkiyye» heleelttitina tuffateen. ");
INSERT INTO bswl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesuusa goɂameen haa ame; «Iisa, ese muun rakkisattan? Ese felo oɂidan iin felttetta. ");
INSERT INTO bswl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Hiyyeessal maagoreenna isin wota giraan, kakkoddootten goorata isoon taɂidan felin daanddaattan; ani goɂameen arggetto isinne wota lakkogirnnaro; ");
INSERT INTO bswl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ese felin kadandeetetto gitakki felttetta; k'amalamanokkeewun goggolleeroon t'ayite maarkkeeyi shigidde. ");
INSERT INTO bswl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ani rumminaa amara; hikki wongala mankkosegaamaro alami dubbaa maamisitti banɂeeyinna hikki ese kafelttetta shaadano lii segaamira» ame. ");
INSERT INTO bswl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Hittakko abbaabatere tomonkko lamakko koo kalleera kaɂask'orotu Yihuuda Yesuusa roorisi sisin katuuk'aamol woyichchaal tos emeete. ");
INSERT INTO bswl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Isona hikka kakkomaalaren goorata geggelaaten; maragade sisin ekkaaten; haanssun Yesuusa roorisi sisin kaɂekkaaro goorata wochchaataa gire. ");
INSERT INTO bswl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kafaasikkaa idaado kakkoɂenɂaamaro kababoo baalawun tahoree arri, Yesuusakko oɂagaalssatareen usu tos gabbalameengureen, «Kafaasikkaa kita kahemeene haggee noo kuun goggoɂekkaanssoo dootatta?» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesuusa usukko oɂagaalssatarankko lama haa ame fare; «Katamaa tos seeyeen; uulla tabekee kasidatera ibaaddo raadii esellowa; ");
INSERT INTO bswl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Usu kakkotabaro min debee seyeen; odo mineenne, kaɂagaalssisara; ‹Inkko oɂagaalssataranne wota kafaasikkaa kita kahemeene kakkoɂaamira kamartti min eekiya?› amera ama. ");
INSERT INTO bswl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Usuna isigitto kagiro minkko kaguutee min yaamenna ekkaate kagiro min kabbalɂaan tusinara; eseenna ekkaasa.» ");
INSERT INTO bswl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Usukko oɂagaalssatareenna ese katamaa tos been; kameen dubba Yesuusa goggoɂameroo kalleero deen; faasikkaa kita kahemeenna ekkaasen. ");
INSERT INTO bswl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ul hemeen kakkolaare goorata Yesuusa tomonkko lamanne wota emeete. ");
INSERT INTO bswl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Aamo gutii giraan, «Ani rumminaa amara, isin orrokko koo, iine wota kaɂaamara usu in roorisi sisinnara» ame. ");
INSERT INTO bswl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Isona yaadeenen; isona metemeteeyi, «Ani leewuna?» amano haggaɂabeen. ");
INSERT INTO bswl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesuusana; isin tomonkko lama orrokko koo, iine wota gene yaalɂaayi kadagisaroyya. ");
INSERT INTO bswl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ere kaɂibaaddo garakkeessa goggos'aafameroyi goyinara; ere kaɂibaaddo roorise kasisaroon hassu ibaaddotin goɂameen aanne! Hassu ibaaddoti haɂumulamoon hesi girewa iidare. ");
INSERT INTO bswl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Aamaa giraan Yesuusa babo keesegure sommaasate; ekkaɂebisegure usukko oɂagaalssatarawun sisaa, «Ahɂaay; hinɂi sooɂootteeyan» amera. ");
INSERT INTO bswl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","T'uggana keesegure sommaasate isoon sise; dubbana esekko t'ameen. ");
INSERT INTO bswl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Adena haa ame; «Hikki omooggan maraan kaɂubataro kaɂammatoo iigikkeeyya; ");
INSERT INTO bswl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ani rumminaa amara; wononnati kawaayi kaɂusub kawoyinii t'amo takkot't'amiro ese arri taageegiiron duuddo lakkot'aminaro.» ");
INSERT INTO bswl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mazamuri zammareen abbaabateenguren debrezeyiti wodami tos been. ");
INSERT INTO bswl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesuusa usukko oɂagaalssataranne; «Kafoofee basinnara; idaadnna darɂaaminnara amame goggos'aafameroo isin dubba in kakayinnattaan. ");
INSERT INTO bswl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ayesuun goɂameen ani kakkokkee goorata adi, isinkko t'ayi Galiila tos seeyinnara.» ");
INSERT INTO bswl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","P'et'iroosana; «Dubba gohanduddufatena ani suure kuu lakkohanduddufayinaro» ame. ");
INSERT INTO bswl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesuusana; «Ani rumminaa amara; hitta hemeen lukkale lama gali haɂoyinon giraan, ati ini seed gali kakayinnatta» ame. ");
INSERT INTO bswl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","P'et'iroosana ade; «Kuunne wota kagooyiro golleenna suure lakkokakayinaro» amaa aaloo ataayise ayeese. Dubbana usumaleewwa ameen. ");
INSERT INTO bswl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Esekko abbaabateren Geetesemmani taɂamamatto banɂe tos seeteen; Yesuusana usukko oɂagaalssataranne, «Ani aantte seeyi ebaaro isin hittanii hamas's'aa» ame. ");
INSERT INTO bswl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","P'et'iroosane, Yayik'oobanee, Yaannisane wota aate seete; aaloo yaadanona c'annak'aamano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Adde; «Neefottina taa goyin geeto aaloo yaadde. Hittanii hesadden ataayeen oorayeen» ame. ");
INSERT INTO bswl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Isokko abaraan ship'p'i amere hore hore bebbeedii ul oyere kadaandame gollee hasse saatii goggoroortto ebaataa, ");
INSERT INTO bswl_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","«Aabbokkee! Kameen dubba kuyeen daanddaamara; hitta tarrakkoo t'ugga inkko keesi; ayesuun goɂameen feɂitte halleennoni giraan feɂittaakki malee halleewo» ame. ");
INSERT INTO bswl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Abbaabayi usu goɂemeero usukko oɂagaalssatareen huddureen ogiraan hele; P'et'iroosane haa ame, «Simoona, huddurttetta? Saatii toonna suure ataayi nabbaadi oorayin waatte? ");
INSERT INTO bswl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","C'aafitii orddi goggotaboonkko ataayeen ebaayen; ayyaana ekkaate gira, soo goɂameen ohararaanyan.» ");
INSERT INTO bswl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Adena seetegure horaarjje kaɂebaaterowa ade ebaate. ");
INSERT INTO bswl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kallami goɂabbaabaro ilɂoɂoottisooyi hudduro isilaattedde ohuddureeraan dee; usuun taɂami abbaabranna lakkokasanaayen. ");
INSERT INTO bswl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kaseedi gooratana emetere haa ame; «Gidda huddurtteen foolssayeen gittaan? Goortta leera! Saatinna geetetta; hikkima; ere kaɂibaaddo c'ubbaalessaalkotti genee roorssami sisaaminnara. ");
INSERT INTO bswl_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kiyaa; seenno; in roorisi kasisinara gabbalamera!» ");
INSERT INTO bswl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Goorsewa usu ayeesaa giraan tomonkko lamakko koo Yihuuda emeete; usune wota shiifana duullaa oɂabateeren, katuuk'aamol woyichchaalkko, seera kamuse oɂagaalssisaraankkona jaarsoleekko kafaramere ibaaddo gire. ");
INSERT INTO bswl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Roorisi kasisinara Yihuuda, «Ani kaɂangatara usuya aba; oora geesa» amaa t'aye malaata isoon sise gire. ");
INSERT INTO bswl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Goggogeeyi goorsewa Yesuusa tos gabbalamegure, «Kaɂagaalssisatto!» ame anggate; ");
INSERT INTO bswl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ibaaddona Yesuusa abeen shiyeen. ");
INSERT INTO bswl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Dollee aalleen ogireenkko koo katuuk'aamol woyichchatiin kahandaarekkotti nebe goose. ");
INSERT INTO bswl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesuusana haa ame, «Shittaa aani in abin shiifana duullaa abtteen emeetteen? ");
INSERT INTO bswl_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Arggetto k'ulluukki min orro isin agaalssisaa isinne wota takkogireeyi lakkoɂabtetteen, ayesuun goɂameen; mas'aafa gudayin hikki lee.» ");
INSERT INTO bswl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hassu goorata dubbana iiseen bak'ateen. ");
INSERT INTO bswl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Hawɂayitteessa gasheeyi kagolisere wodallaati koo Yesuusa debee sesseetaa gire. Ibaaddona hikka wodallaati kakkoɂabare goorata, ");
INSERT INTO bswl_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Usu ade gashetteessa shafegure hawɂayi bak'ate. ");
INSERT INTO bswl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yesuusana tuuk'aamon odonnati kaɂabokokki awud tos geesen; eseenna katuuk'aamol woyichchaal, jaarsoleenna seera kamuse oɂagaalssisaraanne dubba kukkuɂameen. ");
INSERT INTO bswl_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","P'et'iroosana fakkimere debee sesseetaa tuuk'aamolun odonnati kaɂabokkokki awud taageeroo seete, eseenna ohandaareenne wota eleen t'ant'amaa gire. ");
INSERT INTO bswl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Katuuk'aamol woyichchaalnna tashonggoo una dubba Yesuusa lagadin kaɂatotiiro dooteen; ayesuun goɂameen helin lakkodaanddeen. ");
INSERT INTO bswl_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Omoogganna t'ara goɂatoteenna, ayeeskkiso koo liin lakkodaanddee. ");
INSERT INTO bswl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kookkoonna keegureen haa amaa t'ara atoteen, ");
INSERT INTO bswl_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Hikki, gene taɂibaaddo kamadaarttetto k'ulluukki min basigure taseedi arri kakkalee gene taɂibaaddo kanmaddaaroon gitto ani madaarnnara, amaa noo maalnnenna.» ");
INSERT INTO bswl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Hikkina lee giraan atonnatikkiso suure koo lakkollee. ");
INSERT INTO bswl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Katuuk'aamol woyichchatina iso horee kee aalleegure, «Hinɂi kuyee gutii kaɂatotaaran meyya? Muun abbaabanawaatta?» amaa Yesuusa hoosate. ");
INSERT INTO bswl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesuusa goɂameen c'alɂi ame; koonna usu lakkoɂabbaabe, tuuk'aamolun odonnati kaɂaba gidda ade, kasommaasantte ere kawaa atitta? Amaa hoosate. ");
INSERT INTO bswl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesuusana, «Ii aniyya; ere kaɂibaaddo mergge tawaayi hamas's'ee giraan, kadaruure duumanchchal emeetaa dinnattaan» ame. ");
INSERT INTO bswl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Katuuk'aamol woyichchatina sarssikkeessa fiilaa, haa ame; «Kakkalee eeki ato dootisara?» ");
INSERT INTO bswl_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","«Habaarkkessa maaltteettan; hayya me aani laara?» Isona goyin dootisara amaa dubbana hiɂi too leen firddeen. ");
INSERT INTO bswl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hassu goorata kookkoo hanc'c'ufe tufano haggaɂabeen; bebbeedii hogoogisenguren tonttomooyi basaa, «Alla hegeroo ayeesi;» amaa gireen. Okkaleenna balabaanjjoo basaa geesen. ");
INSERT INTO bswl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","P'et'iroosa tuuk'aamolun odonnati kaɂabokkokki awudii orro mina tahegeleenne giraan isoon ohandaareenkko too emeettedde; ");
INSERT INTO bswl_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","P'et'iroosa eleen t'ant'amaa kahamas'eero tichchisse deetegudde, «Ati kanaazireti Yesuusane wota gitte» antte. ");
INSERT INTO bswl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","P'et'iroosa ade; «Ati kaɂamatto ani lakkokaso; goorttun lakkoshaadaro» amaa kakate. Esekko kakkotabaraan gooc'a tos sarddee bee; hassu goorata lukkale oye. ");
INSERT INTO bswl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Diyyitina P'et'iroosa kakkodiyaatte goorata esee oɂalleerenuun; «Hikki ibaaddoti unatisookko kooyya» antte adde ayeesse. ");
INSERT INTO bswl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Usu goɂameen ade giddanna kakate. Abaraan gac'c'ime giraan esee kaɂalleera ibaaddo P'et'iroosane, «Ati kagaliila ibaaddo laanokkaa addeesisara; ogiraan ati isokko kootta» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Usu goɂameen, «Isin kaɂamattan ibaaddoti ani lakkokaso» amaa k'angaanona ammatano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Goorsewa lukkale kallami oye. P'et'iroosana, «Lukkale lama gali owaanakko horene seed gali in kakayinnatta» kaɂamere kayesuusa haafura k'alli ame. Esekkona yururu ame oote. ");
INSERT INTO bswl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Bari bariinoo katuuk'aamol woyichchaal jaarsolee, seera kamuse oɂagaalssisaranna tashongoo unanne wota goorsewa t'oyeen abbaabateenguren Yesuusa shisheengureen P'ilaat'oosaan rooriseen siseen. ");
INSERT INTO bswl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","P'ilaat'oosana, «Ati kaɂayihuudi wonotta?» amaa hoosate; Yesuusana «Ati goggoɂanttettooya.» ");
INSERT INTO bswl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Katuuk'aamol woyichchaalnna Yesuusa kamooggan ayeesi mooteen. ");
INSERT INTO bswl_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","P'ilaat'oosana; «Muun abbaab sisanawaatta? Hikkima kamooggan ayeesii ku mooteran» amaa ade giddanna hoosate. ");
INSERT INTO bswl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesuusa ade koonna lakkoɂabbaabe; P'ilaat'oosana mame. ");
INSERT INTO bswl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tabaala arri kashaamero ibaaddo orrokko koo gosa kahoosatera ibaaddo goggofuramiroon kakkohoosatare seera gire. ");
INSERT INTO bswl_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Hassu goorata meellane kekkeesanoonna neefo lagadanooyi oshaameeraankko koo kalleera Barbaane kaɂamamara ibaaddoti koo gire. ");
INSERT INTO bswl_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Gosana P'ilaat'oosa tos emeetegure seerakisookki malee shaaga goggoyelloon ebaaten. ");
INSERT INTO bswl_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","P'ilaat'oosana, «Ayihuudikokki wono goggofuramiroon dootaattan?» ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Aalanttina katuuk'aamol woyichchaal Yesuusa miiggeeyi roorisi sisano addeesaa gire. ");
INSERT INTO bswl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Katuuk'aamol woyichchaal goɂameen banɂe tayesuusayi Barbaane goggofuramiroo gosa goggohoosaroyi gosa kekkeeseen. ");
INSERT INTO bswl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","P'ilaat'oosana ade giddana, «Goortta hikka kaɂayihuudi wono kaɂamattan misi goggoyelloon dootaattan?» ");
INSERT INTO bswl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Isona giddanna adeen «Suuyina» amaa okkeen. ");
INSERT INTO bswl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","P'ilaat'oosana, «Muun? Meya baas usu kafelera?» ame. Iso adeen, «Suuyina!» amaa kahoreekko ataayiseen okkeen. ");
INSERT INTO bswl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","P'ilaat'oosana gosa geggelaayisin dootere Barbaane fure; Yesuusa ade boc'c'iisegure goggosuwaamiron roorise sise. ");
INSERT INTO bswl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Wotaadaralnna Piraayitooryon kaɂamamero wonokokki min tos Yesuusa geesen; kahesero wotaadaral dubba raattoo kukkuyiseen. ");
INSERT INTO bswl_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Heelakki sarssina sarssiseen, kallachcha kaɂeɂeenee mammarenguren metekkeessaa gutii kayeen. ");
INSERT INTO bswl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Esekkona «Kaɂayihuudi wono; reedina!» amaa k'ac'c'ifataa sagadeen; ");
INSERT INTO bswl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Metekkeessana damaayi baseen; hanc'c'ufena usu gutii tufeen; gilbbiseen sagadeen. ");
INSERT INTO bswl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","K'ac'c'ifateen abbaabateenguren heelakki sarssi k'aarengureen kakkeessa sarssi sarssiseen; suyiinna geesen. ");
INSERT INTO bswl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kaɂalekisaandiroosina karrufoosi Aabbo Simoona kak'ereena ibaaddoti koo katamaakko k'amanne kagiro maamankko emeetaa giraan masik'alii sidisin usu hunnoomen. ");
INSERT INTO bswl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Esekkona Yesuusa, golggottaa taɂamamatto banɂe geesen; fureenna, «Buk'k'e tamete» amanoya. ");
INSERT INTO bswl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Fulfulisone wota kaledamero kawoyinii t'amo siseen; Yesuusa ade diide. ");
INSERT INTO bswl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Esekkona suyeen; sarssikkeessana iso metemeteeyi me ginnaro malabayin it'aa lugudateen sarssi hedeedameen. ");
INSERT INTO bswl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yesuusa kakkosuwaaren goorata barikko saatii seed leete gitte. ");
INSERT INTO bswl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tamooto s'uuffinna, «Kaɂayihuudi wono» taɂamattotte. ");
INSERT INTO bswl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yesuusane wota shittaa lama keenengurene koo merggene, koo betene suyeen. ");
INSERT INTO bswl_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","«Omeellanne wota tootaame» amame mas'aafa kas'aafamera haafura gudate. ");
INSERT INTO bswl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Usu raanne karoorara dubbana mete aaɂisaa c'ilooshakki habaar habaaraa haa amaa gire; «Tu, deetene! K'ulluukki min basidde taseedi arri madaarinnara kaɂamatte; ");
INSERT INTO bswl_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Alla mask'aliikko dagigudde isiɂoottaa haasa!» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Usumaleenna katuuk'aamol woyichchaalnna seera kamuse oɂagaalssisareen k'ac'c'ifataa isiɂisirroo haa ameen; «Okkalee fayyiise, isiɂoottessa fayyiisayin lakkodaanddee; ");
INSERT INTO bswl_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Diigunne goggoɂammannoon usu Kiristoosa kaɂisiraɂeel wono gollee alla mask'aliikko handdage.» Usune wota osuwaameereenna hikkamaleewa c'ilooshakki habaar habaarareen. ");
INSERT INTO bswl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Saatii lekko haggaɂabere taa saatii saagaal geetoo ul dubbaa gutii mugud lee. ");
INSERT INTO bswl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Saatii saagaallii Yesuusa, «Elohe, Elohe lama sebek'itaani?» ame iyyee; fureenna «Hedokkee, Hedokkee in muun iisse?» amanoyya. ");
INSERT INTO bswl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Esee ogireenkko kookkoo hikka maaleengureen, «Eelaasa uumara» ameen. ");
INSERT INTO bswl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Esekko ibaaddoti koo tiiyye seetere kaɂokokootaro kawoyinii t'amo isfoonjii c'uup'egure; fiik'e kayegure goggot'amiro Yesuusaan sisere, oorayeen; «Alla Eelaasa emeeyigure usu godagisirona alla deenno» ame. ");
INSERT INTO bswl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Esekkona Yesuusana iyyeere; neefo beete. ");
INSERT INTO bswl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","K'ulluukki minkkokki goggolo elekko taa hegel geeron fiilame banɂe lama bee. ");
INSERT INTO bswl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Yesuusa horee aallee kagire kaboolo woyichchati usu hikkamalee iyyeere neefoteessa biyaano kakkodiyaare goorata; «Hikki ibaaddoti rumminaa ere kawaayye» ame. ");
INSERT INTO bswl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Hassu goorata ebbaa aalleegure diyaa kagire kookkoo heleel; iso orrokko tamegidella ulkotti Mayiraame, kic'c'arkki tayayik'oobana tayoosa Aaye Mayiraame, usumaleenna Seloomenne gireen; ");
INSERT INTO bswl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Hikki heleel Yesuusa Galiilaayi takkogiree usu debee sesseetanna handdaa kagireya; adena isone wota Iyyerusaalemi tos kaɂemeetere kamooggan heleel kakkaleenna gire. ");
INSERT INTO bswl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Gooratana hemeen laa kakkoseetare goorata Ayihuudin tafoolssi arriin takkobaranaan hemeen hikkina takkoɂekkaasataraan arri leete; ");
INSERT INTO bswl_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Kakkabajaame tashonggoo una kalleerena wononnati kawaa oorataa kagire kaɂarmaatiyaas Yoosefa jabuuyi P'ilaat'oosa tos seetegure kayesuusa rees ebaate. ");
INSERT INTO bswl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","P'ilaat'oosana hikkamalee usu saami gowaanokkeessa maalegure mame; kabooloo woyichchana uumegure, goggoyekko adallaatera? Ame hoosate; ");
INSERT INTO bswl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Gowaanokkeessanna kabooloo woyichchakko k'ulleesseegure rees Yoosefaan sise. ");
INSERT INTO bswl_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yoosefana gashe iminegure rees dagisere gasheeyi ekkaase abbaabatere eɂemokko kaɂoshamero gumbbi orroo k'amale, tagumbbi hiɂinna eɂemo kaye duudise. ");
INSERT INTO bswl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Kamegidella ulkotti Mayiraamena tayoosa Aaye Mayiraamene Yesuusa eetii k'amalinnaraan diyaa gireen. ");
INSERT INTO bswl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ayihuudikkotti tafoolssi arri roortte giraan tamegidella Mayiraamene, tayayik'ooba Aaye Mayiraamene, Seloomene seetengureen rees kayesuusa shittoo kibiin iminateen. ");
INSERT INTO bswl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Almmakko tahoraarjjee tawoggaa arri bari bariinoo ganaa arriti kakkoɂalaatto goorata k'amal tos seetaa giraan, ");
INSERT INTO bswl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","«K'amal guukko eɂemo noon ayyoyya kaɂotottoolisira?» amaa isiɂorroo ayeesaa gireen. ");
INSERT INTO bswl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","T'ok'k'i ami godeeran k'amal gutii kagire kanjiinkki eɂemo k'amal guukko otottoolee kagiro deen. ");
INSERT INTO bswl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","K'amal tos goggogeenii kahank'k'aaro sarssi kasarsatero wodallaati mina tamerggene kahamas'eero deengureen aaloo abissateen. ");
INSERT INTO bswl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Usu ade; «Allamandde arooɂabssatteen; isin kadootattaan kasuwamero kanaazireti Yesuusaya; hittanii laagiro; usu takkok'amalamere banɂe hittima. ");
INSERT INTO bswl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ayesuun goɂameen seeyenguddeen usukko oɂagaalssataraawunna P'et'iroosaan; ‹Isinkko t'ayi Galiila tos seeyinara; isinuun goggosegeeroyi esee helinnattan amaddeen isoon segaa.› » ");
INSERT INTO bswl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Heleelnna harɂaanna geggelaataa k'amalkko been bak'ateen. Abssateen mankkogireen maraan maayyonna koonna lakkoɂayeeseeren. ");
INSERT INTO bswl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Almmakko tahoraarjjee arri tawoggaa bari goyikko kee abbaabatere durrisa todoba takkobeesere kamegidella ulkotti Mayiraamen horaarjje mute. ");
INSERT INTO bswl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Esena seettegudde, usune wota ogireen ootaanna gaddaayi ogireen deetegudde usu neefo giranona eseen mutano isoon segiite. ");
INSERT INTO bswl_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ese Yesuusa goyikko keera neefone gira goɂanttena iso adeen lakkoɂabddatenen. ");
INSERT INTO bswl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Hikkakko abbaabatere usukko oɂagaalssatareen lama gat'are tos biyaa giraan middi takkaleetii isoon mute. ");
INSERT INTO bswl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Isona abbaabateengureen hikkawa oheseeraawun segeen; halleewo kuwaarre isona lakkoɂabddateen. ");
INSERT INTO bswl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Esekkona tomonkko koo babo aamaa hamas's'een giraan Yesuusa isoon mute; kee abbaabate giraan kaddeera ibaaddo kasegeero ammanana mankkowaateran maraan abddiwaattittisoyinna wodanattisookki duudaano tuffate. ");
INSERT INTO bswl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Adena, «Alami dubba tos seeyin; wongalanna met't'a dubbaan lallabaa, ame. ");
INSERT INTO bswl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kaɂammanerana kat'ammak'aamera fayyinnara; kaɂammanon ade firddaaminara. ");
INSERT INTO bswl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Oɂammanaraanna hikka malaataal felinnaraan; megekkeeyi durrisa beesinnaran, taɂusub heɂiinna ayeesinaran, ");
INSERT INTO bswl_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Habeessal genetisooyi abnnaraan, talagado marzzii got'ameenna duuddo iso lakkomiirɂto, genetisonna dhukkubaaleessaal gutii kayinnaraan isona fayyinaraan.» ");
INSERT INTO bswl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Goottaa Yesuusa hikka dubba ayeese abbaabatere daruur tos bee, mergge tawaayi hamas's'ee. ");
INSERT INTO bswl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Esekko usukko oɂagaalssatareen emetengureen, maaman dubbaa haafurakkeessa lallabeen, Goottanna isone wota felaa gire; agaalssiskkisoonna baasakki malaataayi haafurakkeessa ataayisaa gire.");
INSERT INTO bswl_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kakkabajjaantte Tewofiloosa! Noo orroo ofelameraan felo tatusatto jirtti omooggan isoon kadanddaamero gitakki noon s'aafen kayeeran. ");
INSERT INTO bswl_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Hitta jirtti noon oroorseraan horkkooskko kayeerene ilii kaddeeraan oɂatotaarenna haafurakkeessa ohandaareenyan. ");
INSERT INTO bswl_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Usumalee aninna ade tatteekko horaarjjekko keesere kaɂameen dubba laalaan kakkok'ok'k'orro goorata, jirttina isidebee ani kuun goggos'aafiroon taɂidantti leete iin mutte. ");
INSERT INTO bswl_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Hikkana ani kakkonyelara ati kaɂagaalssattetta ayees karrummii laano goggoɂaddeessonya. ");
INSERT INTO bswl_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodoosa ul kayihudaayi wono kakkoleere geesii, taɂabya una kalleere Zakkiraasa kaɂamamara tuuk'aamoti koo gire. Ooritteessa Elssaabeet'ina gosa kaɂaaronikottitte. ");
INSERT INTO bswl_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Lama dubbana ajaja kagoottanna seera dubba ooratereen tuffi kallayi Waayi horee ogireen k'ulluunɂiyeen. ");
INSERT INTO bswl_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Halleewo kuwaarre Elssaabeet'i maseenttede yelo lakkoɂabanaayen; lama dubbana ojaarɂomerenyen. ");
INSERT INTO bswl_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Arri too Zakkiraasa jigikkeessayi, Waayi hore tuuk'aamo lee takkofelaree, ");
INSERT INTO bswl_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Woga katuuk'aamolkokki malee, kagootta k'ulluukki min kawaa tabire it'aana iyyoosiin hit'aayi assaabame. ");
INSERT INTO bswl_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","It'aana kakkoɂiyyooro goorata gosa dubba sarre ebaatare. ");
INSERT INTO bswl_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kagootta erggichcha taɂit'aana banɂee mina tamerggeenne aallee usuun mute. ");
INSERT INTO bswl_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakkiraasana kokkodiyare goorata nee; aaloonna abssate; ");
INSERT INTO bswl_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Erggichchana goɂameen usune, «Zakkiraasa! Arooɂabssatte! Ebikka maalssamera, ooritta Elssaabeet'i babbaartiti umulnatta, megekeessana ati Yaannisa aminatta. ");
INSERT INTO bswl_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ati usuu ekkaatanonna geggelaanjjee helayinatta, kamoogganna umulamanokkeessayi geggelaayinaran. ");
INSERT INTO bswl_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Goottaa horeenna usu kanjinkki linnara. T'amo kawoyiniinna leere kakkalee kasetiisiro t'amo lakkot'aminaro; Aayetteessatti gedeemi orroo giranttii Ayyaana K'ulluukki ammagaminara. ");
INSERT INTO bswl_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kaɂisiraɂeel yiiskko kamooggan Goottaa Hedokisoo tos abbaabinara. ");
INSERT INTO bswl_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Wodana taɂodolaalnna tayiis tos, kaɂajajaamon ibaaddokotti wodana k'ulluutti k'arumma tos abbaabinara. Kaɂemeetaro Goottawun gosa goggoɂekkaasiroo Eelaasa gutii kafelero Ayyaana K'ulluukkiinna hunnaayi Goottaa hore sesseeyinara» ame. ");
INSERT INTO bswl_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakkiraasana erggichchane, «Ani hikka meyii malabnnara? Ani jaarsaya, oorittina jaarttitta» ame. ");
INSERT INTO bswl_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Erggichchatina abbaabere, «Ani Waayi horee kaɂaallaaro Gabireelleya, hikka kageggelaayisaro haafura kuun segin ani Waakko faramera. ");
INSERT INTO bswl_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Hikkima gooratakkeessa ooratere kafelaminaro haafurakkee ati ammanatana mankkowaatte maraan, hikki ani kasegeera dubba taagudaroo ati hiɂi duudinatta, ayeesinna lakkodaanddinatto» ame. ");
INSERT INTO bswl_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Hassu goorata gosa Zakkiraasa k'ulluukki min kawaakko anbbeenoni mewuun adallaatero mameen oorataa gireen. ");
INSERT INTO bswl_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kakkobeyaare gooratana usu isone wota ayeesin lakkodaanddeere. Malaata tusano kuwaarre ayeesin daanddanawattikko kakkeeyi k'ulluukki min kawaa orroo raaga usu diyaano addeesen. ");
INSERT INTO bswl_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zakkiraasana kakkohanddaare almma kakkogudatare goorata minkkeessa abbaabate seete. ");
INSERT INTO bswl_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Esekko abbaabatere ooritteessa Elssaabeet'i fato tootaatte; diginni kennun minkiseeyi isiɂoottisee siyamisatte. ");
INSERT INTO bswl_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Esena, Goottaa shaagakkeessayi tuffamanokakkee ibaaddo orrokko tirin amere hikka bari hikka ayees iin felera» antte. ");
INSERT INTO bswl_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elssaabeet'i fato tootaattedde diginni talleyi, Waa erggichchati Gabireelle Galiilaa tagitte Naazireti katamaa tos fare. ");
INSERT INTO bswl_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kakkoonfaramerena sannii tadaawutekokki Yoosefa kaɂamaraan ibaaddotin taɂeeranttette muumetti deelelititi tosye; muumetti deeleeltitikkokki megena Mayiraameye. ");
INSERT INTO bswl_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Erggichchatina ese tagitto banɂe tos tabere, «Ati sino takkoɂammaganttetta, nogodda kuun halleeto! Goottaa kunne wota gira, atina aaloo tasommaasanttetta» ame. ");
INSERT INTO bswl_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mayiraamena ayeeskkeessaa aaloo neyitedde, hitti misitti nogoddatta? Amaa k'oppaano haggaɂabtte. ");
INSERT INTO bswl_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Erggichchatina esene haa ame, «Mayiraame! Ati Waayi dollee gaashana helattetta arooɂabssatte. ");
INSERT INTO bswl_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Hikkima, tootaayinatta; ere babbaartitina umulnatta; megena Yesuusa aminnatta. ");
INSERT INTO bswl_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Usuna kanjiinkki linnara, dubbaankko t'okk'i kaɂame ere kawaanna amaminnara; Goottaa Hedona Aabbokkeessakki kadaawute korffinjje usuun sisinnara. ");
INSERT INTO bswl_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Sannii tayayik'ooba gutii jiruu jiroommaan reedinnara; wononnatikkeessa gachcho lakkoɂabo.» ");
INSERT INTO bswl_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mayiraamena erggichchatine, «Ani muumetti deelelititiya hikki misii liin daanddaara?» antte. ");
INSERT INTO bswl_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Erggichchatina abbaabe esene haa ame; «Ayyaana K'ulluukki ku gutii daginara, dubbaankko t'okk'i kaɂame hunna kawaanna ku gutii girnnara; haanssun kaɂumulaminnara yiittiti k'ulluukki ere kawaa amaminnara. ");
INSERT INTO bswl_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Hikkima, fallitatta Elssaabeet'ina doɂummaɂorroyi ere babbaartiti tootaattetta. Maseena taɂamanttettena diginni talleyi abttetta; ");
INSERT INTO bswl_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Waawun kalleenon laagiro.» ");
INSERT INTO bswl_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mayiraamena, «Ani tagootta diyyiiyya;» «Haafurakkaakki malee halleewo» antte. Esekkona erggichchatina esekko kalebbee seete. ");
INSERT INTO bswl_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mayiraamena hassu goorata saantte keetedde wodamiilkki ul tayihuuda katamaa too tos seette. ");
INSERT INTO bswl_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Min kazakkiraasa tos tabttedde Elssaabeet'ine nogodda aatte. ");
INSERT INTO bswl_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elssaabeet'ina tamayiraame nogodda kakkomaalatte goorata, yiittitina gedeemi orroo aaɂee; Elssaabeet'ina Ayyaana K'ulluukki ammagantte. ");
INSERT INTO bswl_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Yaayettiseenna t'ok'k'issegudde haa antte; «Ati heleel orrokko tasommaasanttetta; gedeemittaakko kaɂumulaminara yiittitina kasommaasameya. ");
INSERT INTO bswl_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Afo goottakkeetti Aaye in tos emeeyinna ani ayyoyya? ");
INSERT INTO bswl_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Hikkima, nogoddattaatti yaaye nebeteeyi goggotabttee gedeemitteeyi orroo kagire yiittiti geggelooyi aaɂee. ");
INSERT INTO bswl_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Goottaa dollekko kafaramera haafura gudayinnara antte taɂammanatte ese tasommaasanttetta!» ");
INSERT INTO bswl_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mayiraamena haa antte; «Neefotti Goottanna t'ok'k'i t'ok'k'iɂisatta. ");
INSERT INTO bswl_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ayyaanakkina kafayyisaro Waakkeeyi geggelaatara. ");
INSERT INTO bswl_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Usu diyyii teessakki yeraan deera; Hitta arrikko haggaɂabere alattaan dubba in tasommaasantte aminnatta. ");
INSERT INTO bswl_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kaɂatii kalleera usu kanjinkki ayees iin felera megekkeessana k'ulluukkiya. ");
INSERT INTO bswl_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nenɂeyisatanokkeessa usu oɂabssataraanun, alattankko taa alattaan geeroo girnnara. ");
INSERT INTO bswl_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Hunnakakkessayi felo oɂatii felera; wodanatattisookotti k'ofaa okkooraranna darɂeera; ");
INSERT INTO bswl_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mootijjol korffinjjeelkko dagisera; isi oyeraasataraanna ade t'ok'k'iɂisera; ");
INSERT INTO bswl_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Oɂuuɂeeraanna kaɂidanee ayeesi bararisera; dureessaal goɂameen halaal gafarera; ");
INSERT INTO bswl_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Nenɂeyisatanokakkessa shaadaa, diyyiilkkeessa Isiraɂeel gargaarera; hikkina odolaalkkaani goggoɂayeeseroo Abraamenna sanniitattessaan kaɂamero jiruu jiroomman oorinya.» ");
INSERT INTO bswl_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mayiraamena diginni seed taalleetoo Elssaabeet'i dollee adallaattegudde minkakkisee abbaabatte. ");
INSERT INTO bswl_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elssaabeet'inna taɂumullaa arri geete; ere babbaartiti umultte. ");
INSERT INTO bswl_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ollaattisena fallikkise Goottaa eseen kaɂatii nenɂeyisatano kayelero maalengureen, geggeloɂoottisenna ese wota geggelaaten. ");
INSERT INTO bswl_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Yiittiti takkoɂumulamere arri tasiddeedi yiittiti hamas's'isiin emeeten; Aabbokkeessakki megee Zakkiraasa amin dooteen; ");
INSERT INTO bswl_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Aawottessa adde «Lakkohaayyo Yaannisa amamiin dootisara» antte. ");
INSERT INTO bswl_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Isona «Fallikakkakko hikka megee kaɂuumamara maayyona lakkogiro» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aabbokkeessa mege ayyo ami beesin dootaro malaataayi hoosaten. ");
INSERT INTO bswl_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Usuna kakkos'aafiraan saleedaa goggosisinawun ebaatere, «Megekkeessa Yaannisaya» ame s'aafe; dubbana hikka ayeenssa saade. ");
INSERT INTO bswl_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Goorsewa hiɂitteessa banantte; errebkeessana furame; Waanna galataa ayeesano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ollaattise dubbana abssii ammagantte; hikki ayees dubba wodamiilkki ul kayihudaa dubbaa ayeesame. ");
INSERT INTO bswl_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Hikka kamaale dubbana, «Hikki yiittiti misi liin leera?» amaa ayees wodanatattisooyi abateen. Gene tagootta ogiraan usu wota gitte. ");
INSERT INTO bswl_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Kayaannisa odo Zakkiraasa Ayyaana K'ulluukki ammagamere haa amaa hegero ayeese; ");
INSERT INTO bswl_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Kaɂisiraɂeel Hedo, Goottaa hasommaasame; usu kakkoonɂemeetera gosa gargaarinna fayyisiinya. ");
INSERT INTO bswl_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Diyyikkeessakki tadaawute sanniikko, kafayyisaro kaɂatii keesera; ");
INSERT INTO bswl_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Hikkina horkko k'ulluunɂi ohegeroolkotti hiɂii usu goggoɂayeeseroo, ");
INSERT INTO bswl_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Fayyinnana diinajjoolkkaanikkona, no kadidarokkotti genekko goggohenssonya; ");
INSERT INTO bswl_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Usu hikkana kakkoonyelera odolaalkkaanun abddii katabero shaaga tusiinna, k'ulluunɂi ammato shaadisiin, ");
INSERT INTO bswl_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Aabbokkaani Abraamenna otabero ammato shaadiin, ");
INSERT INTO bswl_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Diinajjolkkaanikkotti genekko beesire abssi kallayi usuun goggohanddayinnoon, ");
INSERT INTO bswl_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Geeskakkani dubbaa k'ullummanna rummii usu hore aalliisinya. ");
INSERT INTO bswl_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Adde ati yiittiti, dubbaankko t'ok'k'i kaɂame hegerooti kawaa amaminnatta; kagootta raa ekkaasin usu hore seeyinnatta; ");
INSERT INTO bswl_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","C'ubbokkisookko haheso amamano helatanakko kakkeeyi, gosaan kafayyinna malabano goggosisamiroo, ");
INSERT INTO bswl_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Hedokkaanikki kaɂidanee nenɂeyisatanakko kakkeeyi, tabbabarisee taffayyinna arri daruurkko noyyen beete; ");
INSERT INTO bswl_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Hikkina mugudii orroo ogiraawunna hoos tagoyi orroo ogiraawun goggohank'ayisironna, luk'k'aɂoottanina raa kanogoddaa tos goggok'ajeelisironya.» ");
INSERT INTO bswl_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yiittitina jiinate; Ayyaana K'ulluukkinna ataate; gosa kaɂisiraɂeeliin diidaa bee tamutere arrikko abbaabatere gaadi gire. ");
INSERT INTO bswl_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Hassu geesii, k'alaadakeessakki gosa dubba goggotootamironna megekiso goggomazagabamiroo karoomi wono Awugist'oosikko ajaja bee. ");
INSERT INTO bswl_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Hikkina K'ereneyoosi kasoorya ulkokki mooti lee takkogiree kahoraarjjee gosakokki tootaamano gire. ");
INSERT INTO bswl_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Haanssun ibaaddo dubba mazgabamiin katamaa tatteessatatteessa seete. ");
INSERT INTO bswl_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yoosefa Daawuten enekki falli mankkoleere maraan, Galiila awuraajjaayi tagitto Naazireti katamaakko keegure Daawute takkoɂumulamere katamaa Beteleemi taɂamaraan tayihuuda katamaa tos bee. ");
INSERT INTO bswl_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mazgabamiin eserraa seeteen; fato tootaatte tagitte Mayiraamena ese kaɂeeraterene wota seette. ");
INSERT INTO bswl_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Esee tabetelehemi katamaayi giranttiinna taɂumullaa arri geete; ");
INSERT INTO bswl_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ere barkki kalleero babbaartitina umultte; hoc'ooyinna mammarttedde, martti takkofolssatto banɂee helayiin mankkowaatene maranttuun awud kassaayeti orroo huddurisse. ");
INSERT INTO bswl_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Usu ulii hemeen giddi oorataa diidaa kabaraare kafoofel gire. ");
INSERT INTO bswl_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kagootta erggichchana derɂa emetere isoo dollee aallee; tagootta kabaja isoon maraamure hank'k'ayise; abssi taɂatii iso abtte. ");
INSERT INTO bswl_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Erggichcha ade isoon haa ame; «Arooɂabssatteen! Gosa dubbaan geggeloo oɂatii talleeto odu taɂidan ani aate emeeyera. ");
INSERT INTO bswl_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hittaari tadaawute katamaayi kafayyisira isinuun umulamera; usuna Goottaa Kiristoosaya. ");
INSERT INTO bswl_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Hikki isinuun malaata halleewo; kic'c'arkki yiittiti hoc'ooyi mammaramere awud kassaayee orroo huddure kagiro helnnatta.» ");
INSERT INTO bswl_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Derɂa erggichchatineta kamooggan kadaruure erggichchaalnna wota mute; Waanna galataa haa ameen; ");
INSERT INTO bswl_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Kabaja ele daruurii kagiro Waawun nogoddana usu kageelaataro ibaaddon ulii halleeto!» ");
INSERT INTO bswl_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Erggichchati isokko assaabame daruur tos kakkobeyaare goorata ofoofee, «Gootta noon katusero hikka haa kalleero ayees din Beteleemi tos seenna» isiɂisirroo haa ameen. ");
INSERT INTO bswl_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Isona saamen seeteen; Mayiraamena Yoosefa, yiittitina awud kassaayeti huddure kagiro heleen. ");
INSERT INTO bswl_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kakkodeyaareen gooratana, erggichcha gara kayittitikokki isoon kasegeero addeesisen segeen. ");
INSERT INTO bswl_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Hikkana kafoofee kasegeero ayees kamaale dubba saade. ");
INSERT INTO bswl_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mayiraame goɂameen hikka dubba wodanattiseeyi abattedde k'ofa geggeesatanna oorataa gitte. ");
INSERT INTO bswl_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ofoofee ayees dubbana erggichchati goggosegeerokki malee lee helanoyinna, kamaaleranna kaddeeran dubba marantuun Waa kabajaanna galataa abbaabateen. ");
INSERT INTO bswl_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Arri siddeed leetedde kakkohamas'isamira goorata goggogeeyi fato tootaamanakko horene erggichcha kabeesero megee «Yesuusa» amame uumame. ");
INSERT INTO bswl_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Seera kamuse malee kakkomuc'iɂamaraan almma kakkogudatare goorata, Yoosefana Mayiraame yiittiti Goottawun sisin Iyyerusaalemi tos aateen been; ");
INSERT INTO bswl_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Hikkina seera kagoottayi, «Babbaar kalleera barkki ere dubba Goottawun kak'ullooye linnara» amame goggos'aafameroo felohayisiinna, ");
INSERT INTO bswl_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Adena seera kagoottayi, «Waanos lama goorttun lama kaɂarabee c'uc'uutel jaarsso yeli sisiinye.» ");
INSERT INTO bswl_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Hassu goorata Waa kaɂabssatarena Waayi hore rummii kagire Simoona kaɂamamare ibaaddoti koo Iyyerusaalemii gire; usuna kaɂisiraɂeel fayyinna kaɂooratarena Ayyaana K'ulluukki usu gutii kakkobareere ibaaddotiye. ");
INSERT INTO bswl_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Adena kafayyisaro Kiristoosa Goottaayi kashigidamero anddeenon kagoonnon laano Ayyaana K'ulluukki usuun mute gire. ");
INSERT INTO bswl_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Usuna hassu goorata Ayyaana K'ullukkikokki geggeesanoyi k'ulluukki min kaɂebi tos tabe; Yoosefana Mayiraamena seerakki malee goggokasanayenii usuun kadootisaro felin yiittiti Yesuusa abeen kakkotabeeren goorata, ");
INSERT INTO bswl_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simoona yiittiti k'op'atere geegiyottessaa abate; waanna galataa haa ame; ");
INSERT INTO bswl_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Goottakkee; ammato goggogudissettokki malee gidda diyyikkaa nogoddaa galisi; ");
INSERT INTO bswl_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Fayyinnakkaa Ilɂo ootteyi deera; ");
INSERT INTO bswl_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Usuna ibaaddo dubbaa hore ati kaɂekkaasettoya; ");
INSERT INTO bswl_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ayihuudi kalleenootun rummi katusaroya; gosa kaɂisiraɂeelinna kabajaya.» ");
INSERT INTO bswl_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Aabbokkeessana Aayetteessana usu maraan kasegaamero ayeesi mameen. ");
INSERT INTO bswl_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simoonana iso sommaasate; Aayetteessa Mayiraaminee haa ame; «Hikki yiittiti Isiraɂeelii kamoogganun baanowunna fayyaanowun aalantti goggolleeroo, usu odidaraawun malaata goggolleeroo shuumamera; ");
INSERT INTO bswl_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kamooggankotti k'ofa tawodana goggotusiroonya; gadda shiifa aani neefottaa eegginara.» ");
INSERT INTO bswl_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Usumaleenna una taɂaseerkko talleetette tafanuɂeel ere, haanna taɂamamatte hegerooti esee gitte; esena aaloo jaarɂontte gitte; deelellummane kakkeesanttette entter wota gees todoba tahamas's'itettetta. ");
INSERT INTO bswl_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Geeskkisena siddootamkko afar taa leeroon galttaantte leete arriinne hemeenne k'ulluukki min kaɂebikko hahesooni agabuyinna ebii Waawun handdaa galtaantte leete adallaatte. ");
INSERT INTO bswl_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Hassu gooratana gabbalanttedde Waa galatiite; Iyyerusaalemikokki wodoo oɂooratareen dubbaan yiittitikokki ayeesse. ");
INSERT INTO bswl_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yoosefana Mayiraamena kagootta seeraayi ajaja kasisamero dubba kakkogudisareen goorata, Galiila awuraajjaayi taggitto Naazireti katamaa tos abbaabateen. ");
INSERT INTO bswl_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yiittitina jiinataanna ataataa seete; k'arumma ammagame; sino tawaa usu gutii gitte. ");
INSERT INTO bswl_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yesuusa oɂumuleeraanna gees gees faasikkaa baalawun Iyyerusaalemi tos biyaanen. ");
INSERT INTO bswl_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Unnuna gees tomonkko lama kakkolaare goorata, goggokasaanii baala kabajin been. ");
INSERT INTO bswl_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Baala gudiseen abbaabaterene, minkkiso abbaabataa giraan, yiittiti Yesuusa Iyyerusaalemi hese; oɂumuleeraanna hesanokkeessa adeen lakkoɂaddeeseren. ");
INSERT INTO bswl_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Isone wota kagiro aani leere, arri tookki raa sesseeteen abbaabateren adeen fallikkisookkona iso ogeelaatareen dollekkona dootano haggaɂabeen; ");
INSERT INTO bswl_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Dooteen kakkowaatareen goorata dootanna Iyyerusaalemi tos abbaabateen seeteen. ");
INSERT INTO bswl_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Arri seedkkona abbaabaterene oɂagaalssisareeni t'eɂe hamas's'eere iso maalaanna hoosin hoosataa giraan k'ulluukki min kaɂebi orroo usu heleen; ");
INSERT INTO bswl_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Omaaleeraan dubba shaadanokeessayinna abbaabikkeessayi saadaa gireen. ");
INSERT INTO bswl_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Oɂumuleeraanna kakkodeyaaren goorata mameen; Aayetteessana, «Unnukkee; mewuun no haa yelitte? Aabbokkaana aninna yaandde noo ku dootaa ginne» haa antte. ");
INSERT INTO bswl_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","«Usuna in muun dootatteen?» «Aabbokkeekki minii girin kadootisaro laano lakkokassaanya?» ame. ");
INSERT INTO bswl_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Isona usu kaɂayeesere ayees lakkoshaaderen. ");
INSERT INTO bswl_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Esekkona raattoo Naazireti tos dageen; isoonna ajajaamaa gire. Aayetteessana hikka ayees dubba wodanattiseeyi abatte gitte. ");
INSERT INTO bswl_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesuusana k'arummanna jifuu jiinataa gire; Waayinna ibaaddo hore usu gaashana abanaaye. ");
INSERT INTO bswl_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Karoomi wono T'ibaryoosa kakkoreedere gees katomonkko kenni, kap'ent't'iyoosa P'ilaat'oosa kayihuuda mooti Herodoosa kageelila mooti lee takkogiree, usumalee abbikkeessa Filp'oosa kaɂit'uriyaasina kat'irakondos mootii, Lisaniyosina kaɂabilanissa mootii lee giraan, ");
INSERT INTO bswl_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Haannana K'eyaafa tuuk'aamokokki woyichcha leen giranttii, ere kazakkiraasa Yaannisaan Waa k'alullattokki ulii ayeese. ");
INSERT INTO bswl_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Usuna c'ubbokkisin haheso goggoɂamamiroon c'ubbokko kakkogula gallaan t'ink'ata t'ammak'aa Yorddaanosii lagaa maamanii kagiro gosa dubbaan emeete. ");
INSERT INTO bswl_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Hikkina kahegeroo Isiyaasakokki mas'aafayi haa ame kas'aafamero maleeye; «Gaadi haa amaa kaɂiyyaaro ibaaddotikotti yaaye; ‹Kagootta raa ekkaasa sesseettaninna tukkul yela; ");
INSERT INTO bswl_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Laga dubba ammagaminara; wodamina gaagajjol dubba hussi aminara; kawoc'ac'aamera raa tukkul uminara, karshashi kaɂamera muc'c'i aminara; ");
INSERT INTO bswl_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Sannii taɂibaaddo dubba fayyinna kawaa dinnatta.› » ");
INSERT INTO bswl_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yaannisana genetteessaayi t'ammak'aamin kabeero ibaaddone haa amaa gire; «Isin yiis kahabeessa taɂemaatto engge tawaakko goggobak'attaanun ayyoyya isinuun raa katuse? ");
INSERT INTO bswl_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Goortta c'ubbokko gula gala, c'ubbokko gula galanokkisin otusaraan felo fela; adena wodanattisinii ‹Abraame Aabbokkaani girowa› amanona aroohaggaɂabtten; Waa hikka eɂemoolkko Abraamen sannii keesin kadaanddero laano ani isinuun segaara. ");
INSERT INTO bswl_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Gidda masaar gaa hegelkko goosi lugudin ekkaattetta; taɂidantti il kadubamoon gaa dubba goosamire eleenii shafaminara.» ");
INSERT INTO bswl_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Gosana, «Hayya no me yelnna?» ameen Yaannisa hoosaten. ");
INSERT INTO bswl_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yaannisana «Sarssi lama kaɂaba koonna kallikkin hasiso; babo kaɂabana usumalee hayele» ame isoon abbaabe. ");
INSERT INTO bswl_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","K'arat'a okukkuyisareenna t'ammak'amin usu tos emeeteren, «Kaɂagaalssisatto! Noo adi me yelnna?» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","«Usuna kaɂajajaantteettankko roorisi k'arat'a arookukkuyisseen» ame. ");
INSERT INTO bswl_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Wotaadaralnna «Noo adi me yelnna?» ameen hoosaten; usuna, «Maakkayokki maragadena hunnaa aroosaantteen; ibaaddona t'araayi aroomootiteen; daamoozakkisin isinuun halleewo ame.» ");
INSERT INTO bswl_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Hassu goorata gosa Kiristoosa abddii oorataa gire; haanssun Yaannisa «Hikki ibaaddoti Kiristoosa leewuna?» amaa dubba wodanattisooyi k'oppaa gireen. ");
INSERT INTO bswl_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yaannisa dubbaawun haa ame abbaabe; «Ani isin bekeeyi t'ammak'aara; ayesuun goɂameen inkko kaɂatii emeeyinara; aninna keferroɂoottessakokki shaano furin kadaanddero lakkoyo; usu Ayyaana K'ulluukkina eleenii isin t'ammak'inara; ");
INSERT INTO bswl_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Addummaal basin darggammaa gootaraayi orroo kibiin takkohark'k'isaraan dugud genetteessaa gitta; galabaa ade tabbaanon eleenii gubnnara.» ");
INSERT INTO bswl_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Usumaleenna Yaannisa raa kamoogganne gosa gorssaa odu taɂidan segee. ");
INSERT INTO bswl_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ayesuun goɂameen Yaannisa, kayihuuda mooti kalleere Herodoosa ade abbikkeessatti tafilp'oosa oori Herodiyaada atatanona kakkalee kameellan kamooggan ayeesi felanooyi usu hadise. ");
INSERT INTO bswl_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodoosa hikka dubba gutii adere, Yaannisa minkashaano tabise. ");
INSERT INTO bswl_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Gosa dubba kakkot'ammak'aamare goorata Yesuusana t'ammak'ame; ebaataa giranttiinna daruur bananttedde, ");
INSERT INTO bswl_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ayyaana K'ulluukkina arabe aani usu gutii dage; daruurkkona, «Ani kageelaatara erekki atitta; kuyeeyi geggelaatara» taɂamatta yaaye emeette. ");
INSERT INTO bswl_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesuusa handdaano gohaggaɂabare gees sonddomye; gosaan Yesuusa ere kayoosefa aani leere; usu Yoosefana kaɂeeli ere, ");
INSERT INTO bswl_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","kamati ere, kallewi ere, kamilikki ere, kayoona ere, kayoosefi ere, ");
INSERT INTO bswl_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Kamatatiyu ere, kaɂamoos'i ere, kanahomi ere, kaɂeesilimi ere, kannagge ere, ");
INSERT INTO bswl_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Kamaɂati ere, kamatattiyu ere, kassemmeyi ere, kayoosefa ere, kayooda ere, ");
INSERT INTO bswl_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Kayonani ere, karreesi ere, kazerubbabeli ere, kaseelatiyali ere, kanneri ere, ");
INSERT INTO bswl_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Kamilikki ere, kahaaddi ere, kayosaasi ere, kak'osaami ere, kaɂelimoodami ere, kaɂeeri ere, ");
INSERT INTO bswl_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","kayoseɂi ere, kaɂeeliɂazeri ere, kayoraami ere, kamat'ati ere, kallewi ere, ");
INSERT INTO bswl_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Kasimooni ere, kayihuuda ere, kayoosefi ere, kayonami ere, kaɂeliyak'emi ere, ");
INSERT INTO bswl_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","kameeliya ere, kamayinani ere, kamat'ati ere, kanatani ere, kadaawute ere, ");
INSERT INTO bswl_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Kaɂisseyi ere, kaɂiyoobedi ere, kaboɂezi ere, kaselmooni ere, kaneɂasooni ere, ");
INSERT INTO bswl_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Kaɂaminadabi ere kaɂarami ere, kaɂarooni ere, kaɂeseroomi ere, kafarees ere, kayihuuda ere, ");
INSERT INTO bswl_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","kayayik'ooba ere, kayissaak'a ere, kaɂabrahame ere, kataara ere, kanakkor ere, ");
INSERT INTO bswl_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","kasserogi ere, karagawu ere, kafallik'i ere, kaɂabber ere, kasala ere, ");
INSERT INTO bswl_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","kak'ayinimi ere, kaɂarfakisidi ere, kassemi ere, kanohe ere, kalamehi ere, ");
INSERT INTO bswl_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","kamatosaala ere, kahenokki ere, kayaaredi ere, kamelaliɂeeli ere, kak'ayinani ere, ");
INSERT INTO bswl_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","kahenokki ere, kasseti ere, kaɂaddame ere, kawaa ere. ");
INSERT INTO bswl_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesuusa Ayyaana K'ulluukki ammagamere kayorddanosi lagakko goggoɂabbaabatee Ayyaana K'ulluukki gaa tos usu k'ajeelise; ");
INSERT INTO bswl_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Esekkona arri afarttam durrisaa c'aafame; hinɂa arrijjool orroo koonna haɂamooni adallaatere tagachchoo arrii uuɂee. ");
INSERT INTO bswl_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Durrisana alla «Ere kawaa golleete hikka eɂemo babo goggolleeroo ajajii» ame. ");
INSERT INTO bswl_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesuusana, «Ibaaddo babo kaalaalii lakkogiraro; amame s'aafamera» ame usuun abbaabe. ");
INSERT INTO bswl_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Esekkona durrisa too t'ok'k'i taɂantte wodamii Yesuusa korisegure kaɂalami wonolaal dubbana kooyikkii tuse; ");
INSERT INTO bswl_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Esekko abbaabatere «Hikka wonolaalkokki odonnatina kabajja dubba iyyeen sisanttetta; aninna kageelaataroon mankkosisinaro maraan kuyeen sisinara; ");
INSERT INTO bswl_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Haanssun ati iyyeen gosagadde hikki dubba kakkaa leerowa» ame. ");
INSERT INTO bswl_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesuusana abbaabere, «Goottaa Hedo kaawun sagadi! Usu kaalaal hedoyisa» amame mas'aafa k'ulluukki s'aafamera ame. ");
INSERT INTO bswl_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Esekkona durrisa Yesuusa Iyyerusaalemi tos geesere k'ulluukki min kawaa gutii birt'ee aallisere, alla ere kawaa golleete issii hegelddee fir ami ii ame. ");
INSERT INTO bswl_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Aalanttina haa amame mas'aafa k'ulluukki s'aafamera; ku goggoɂoorrawun ade, « ‹Waa erggichchaal ku marantuun ajajaara; ");
INSERT INTO bswl_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Luk'k'aɂoottana eɂemooyi goggohanduddufannonkko genettisooyi ku abi keesiraanwa› » ame. ");
INSERT INTO bswl_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesuusana abbaabere, «Gootta Hedokkaa arooc'aafite amame mas'aafa k'ulluukkii s'aafamera» ame. ");
INSERT INTO bswl_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Durrisaa Yesuusa c'aafee gudise abbaabatere kakkalee kaɂekkaaro goorata taahelaroo usukko kalebbee. ");
INSERT INTO bswl_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesuusana Ayyaana K'ulluukkikokki hunnaayi Galiila tos abbaabate; ataankkeessana gobobii kagiro ul dubbaa maalssame. ");
INSERT INTO bswl_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Usuna Ayihuudikokki min kaɂebii agaalssisaa gire; ibaaddo dubbana usu galataa gire. ");
INSERT INTO bswl_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Esekkona takkojinatero katamaa Naazireti tos emeete; wogakisookki malee Ayihuudin tafoolissi arri min kaɂebikakkisoo tos tabe; k'ulluukki mas'aafa nabbabin kee aallee. ");
INSERT INTO bswl_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kahegeroo Isiyaasakokki kaduubamero mas'aafa usuun siseen; kaduubamero mas'aafana kakkofuffurro goorata haa amamitte tas'aafanttetto banɂe hele; ");
INSERT INTO bswl_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Kagootta Ayyaana iyyee gutii gira hiyyeessaalun wongala goggolallabiroon, usu in shigidera oshaameeraawun furamano, ilɂo odeyaannootun deyaano goggoɂawwaajiron, oyaadaranuun balchchumma goggobeesiron, ");
INSERT INTO bswl_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","usumaleenna Goottaa gosa kakkohaasiro kasinoo gees goggoɂaddeesisiroo in farera.» ");
INSERT INTO bswl_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Esekkona mas'aafa duubere kaɂayihuudi min kaɂebikokki woyichchatin abbaabe sisegure hamas's'ee; Ayihuudikokki min kaɂebii kagire ibaaddo dubbana tichchise diyaa gire. ");
INSERT INTO bswl_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Usuna, «Hikki nebetattisinii kamaalattan kamas's'aafa haafura hittaari gudate» amano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Dubbana garakkeessa taɂidaneeti ayeesaa gireen; adena hiɂittessakko kabiyaaro kaɂidan ayeesii mamaa, «Hikki la ere kayoosefayolla?» amaa gireen. ");
INSERT INTO bswl_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesuusana, «Odo doobee; alla ati isiɂoottaa fayyiisaa; ul kak'ifirenaahoomi kafelatte no kamaalnnenno ayees hitta katamaattaayinna adi feli' taɂamatto masuussa isin iin fer kamalaataattan hedatano lakkoɂabo» ame. ");
INSERT INTO bswl_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Adena usu haa ame; «Ani rumminaa isinuun haa amara;» Kahegeroo ulkkeessaayi lakkokabajaamaro. ");
INSERT INTO bswl_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","«Ayesuun goɂameen ani rumminaa isinuun haa amara;» daruur gees seendda minana idaamo waattamere kaɂisiraɂeel ul dubbaa gutii kaɂatii uɂi kakkogire kaɂeelasa geesii, kamooggan galttaanttejjool ul kaɂisiraɂeelii gire. ");
INSERT INTO bswl_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Eelaasa hinɂa galttaanttejja orrokko too tonssa lakkofaramere; ayesuun goɂameen kasidoona ulii Serap'ita kaɂamamaro maamanii tagitte galttaantte tos farame. ");
INSERT INTO bswl_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Usumalee kahegeroo kaɂelssayi geesiinna Isiraɂeelii kamooggan maarii bar kaɂabanaaye ibaaddo gire; ayesuun goɂameen kasooriya Niɂimaani kuwaarre hinɂa orrokko koonna lakkofayyeere. ");
INSERT INTO bswl_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ayihuudikokki min kaɂebi kagire ibaaddo dubba hikka kakkomaalaren goorata amaraate. ");
INSERT INTO bswl_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Takkohamas's'eerenkkona keengureen Yesuusa katamaakko sarii beesen; katamaattisooyi hegelddeedisi gumbbii lugudin tafelanttetto wodami k'ark'araa geesen; ");
INSERT INTO bswl_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Usu goɂameen isoo orromare seete. ");
INSERT INTO bswl_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Esekkona Yesuusa tagaliila awuraajjaayi tagitto katamaa tos K'ifirenaahoomi dage; eseenna Ayihuudin tafoolssii arri gosa agaalssisano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Odonnati haafura ayeesaa mankkogire maraan dubbana agaalssisanokkeessa saade. ");
INSERT INTO bswl_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ayihuudikokki min kaɂebinna battiikki ayyaanaa kaɂabamere ibaaddoti koo kagire; usuna t'ok'k'i taɂantte yaayee iyyeere, ");
INSERT INTO bswl_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Woo! Kanaazireti Yesuusa; me taɂeselsatto haajaa noonne abtta? Kakkoonɂemettetta noo baasinya? Ati ayyotto ani kasowa; ati kawaa k'ulluukkitta!» ame. ");
INSERT INTO bswl_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesuusana, «C'alɂi amidde hikka ibaaddotikko bee!» ame hadise; battiikki ayyaanana ibaaddoti gosa dubbaa hore lugudegure koonna miirɂa angeegison gafare bee. ");
INSERT INTO bswl_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ibaaddo dubbana mame; isi isiɂorroonna, «Hikki misikki ajajaya? Odonnatina hunnaayi battiikki ayyaanalnna goɂajajiro isona biyaaran» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yesuusakokki ataan usu ulkokki gobobii dubbaa maalssame. ");
INSERT INTO bswl_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Esekko abbaabatere Yesuusa Ayihuudikokki min kaɂebikko beegure min kasimoona tos tabe. Tasimoona soddo maar gube gomeellan hawɂaamaa gitte; ese goggofayyisiroo Yesuusa ebaaten. ");
INSERT INTO bswl_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesuusana ese tos hussi amere maar kagubare hadise; maar kagubarena gafare goorsewa keetedde marttiisse. ");
INSERT INTO bswl_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Arriti iyaa giraan, kalekaleekki hawɂaami kaɂabanaaye ibaaddo dubba Yesuusa tos keenen. Usuna isoo mete metee genetteessa gutii kayere fayyiise. ");
INSERT INTO bswl_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Durrisana ade, «Ati ere kawaatta!» amaanna iyyaa kamooggan ibaaddokko bee. Usu goɂameen iso hadise; usu Kiristoosa laano addeesen mankkogireen maraan garakkeessa koonna iso goggoɂayeesonkko tire. ");
INSERT INTO bswl_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ul kakkobaraare goorata Yesuusa too kaletti banɂee seete. Gosana usu dootaa gire; usu takkogiro banɂee emeeten; isokkona kalebiire goggoseennonkko tirin hedeen. ");
INSERT INTO bswl_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Usu goɂameen, «Kakkalee katamaal ani seeyigure wononnati kawaakokki wongala lallabin dootisara; ani kakkonfaramerana hikka halchchaaniya» ame. ");
INSERT INTO bswl_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kayihuuda maamanii kagiro min kaɂebii dubbaa lallabaano horeddee. ");
INSERT INTO bswl_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Gosa Yesuusa mareɂabere isiɂisi shashafataa usu kaɂagaalssisare haafura kawaa maala, tagenssaaret'i labuu girii aallee gire. ");
INSERT INTO bswl_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Usu goorata wolabo lama baga girii taɂaallitetto dee; kunɂub oɂabatareen adeen wolaboolkkona dageeren maarrabil aalisataa gireen. ");
INSERT INTO bswl_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Wolabool orrokko tasimoona talleetetto tos tabere, bagakko badi tos abaraanttii goggofakkisiroo hoosate; esekkona usu wolaboo gutii hamas's'eere gosana agaalssisano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ayees gudise abbaabatere Simoonane, «Badi tos fakki amidde kunɂub abayin maarrabjjoolkkisin lugudayeene» ame. ");
INSERT INTO bswl_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoonana Yesuusane abbaabere, «Kaɂagaalssisatto! Hemeen duuddo daafuraa barinenne koonna lakkoɂabanenno; ati goɂantte haafurakkaayi adi maarrabjjoolnna lugudaroowa» ame. ");
INSERT INTO bswl_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kakkolugudatareen goorata aaloo kajiinjjii kamooggan kunɂub abeen, maarrabijoolnna fiilamiin leete. ");
INSERT INTO bswl_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Wolabo takkaleetii tagitte una tattisoo emeeyidde iso goggogarggaarttoo malaataayi uumeen; isona emeeteren wolabo lama kunɂubi ammageen; wolabona lichchimiin leete. ");
INSERT INTO bswl_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoona P'et'iroosana hikka kakkodiyaare goorata Yesuusa hore gilbbisere, «Gootta; ani c'ubbaalessakki ibaaddotiya inkko kalebbee» ame. ");
INSERT INTO bswl_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Hikkana kakkonɂamera usuna usune wota ogireen dubba kaɂabeeraan kunɂubikokki moggaanii mankkosaaderen maraanye. ");
INSERT INTO bswl_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Usumaleenna saatilaal tasimoona kalleere yiis kazabddoosa, Yayik'oobana Yaannisana saadeen. Yesuusana Simoonane, «Arooɂabssatte! Goortta ibaaddo in tos kakkeentto leeta» ame. ");
INSERT INTO bswl_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Isona wolaboolkkisoo baga beeseren kaɂameen dubbana iiserene usu debee sesseeteen. ");
INSERT INTO bswl_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesuusa katamaalkko tooyi kakkogiree, koo maarii bar kakkonɂammagantttete ibaaddoti ese katamaayi gire; hikki ibaaddoti Yesuusa kakkodeyaare goorata bebbeedtteessaa ul oyeegure, «Goottaa, feɂittaa golleete in muc'c'isin daanddaatta» ame ebaate. ");
INSERT INTO bswl_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesuusana gene diriirssategure maar kaɂibaaddoti aɂabegure «Ani feɂi sisera» «Muc'c'iɂami!» ame. Goorsewa bar ibaaddotikko muc'c'iɂantte. ");
INSERT INTO bswl_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesuusa ade, «Hikka maayyonna aroosegite; ayesuun goɂameen seedde isiɂoottaa tuuk'aamon tusa; gosaan ato goggolleeronna muc'c'imanokkaa maraan Muse goggoɂajajeerokki malee jaarsso sisi» ame ajajee. ");
INSERT INTO bswl_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Halleewo kuwaarre garakkeessa taɂayeesamatte odu aaloo balɂaataa seette; aaloo kamooggan ibaaddona usu kaɂayeesaro maalinna kaɂabaan maarɂorrookki hawɂaamikko fayyiin kukkuɂamaa gire. ");
INSERT INTO bswl_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yesuusa goɂameen kamooggan goorata kaletti banɂee ebaataa gire. ");
INSERT INTO bswl_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Arri tooyi Yesuusa gosa agaalssisaa gire; esena Galiilakkona kayihuuda maaman dubbakko usumaleenna Iyyerusaalemikko kaɂemeetera ibaaddo kafarasaawinna seera kamuse kaɂagaalssisara hamas's'ee gire; fayyiisinna ade hunna kagootta usu wota gire. ");
INSERT INTO bswl_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Hassu gooratana ibaaddo naafaleessati koo alggaayi sideen aateen emeeten. Yesuusa horee kayin min orroo tabisin hedeen. ");
INSERT INTO bswl_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Gosa mooggankkona kakkeeyi min orro tabisin mankkowaaten maraan heelinchcho gutii korateenee heelinchcho butto beeseren kahawɂamaro alggaanne wota gosaa t'eɂee tukkulii Yesuusa hore dagiseen. ");
INSERT INTO bswl_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesuusa ammanokkisoo deegure, «Ati ibaaddoti c'ubbokka haheso amamera» ame. ");
INSERT INTO bswl_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Seera oɂagaalssisaranna kafarasaawi ibaaddo, hikki «Waa kaɂinggaamara ayyoyya? Waa koo kuwaarre c'ubbo haheso amin kadaanddaara ayyoyya?» ameen k'ofa geggeesatano haggaɂabeen. ");
INSERT INTO bswl_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesuusana k'ofattisoo mankkoɂaddeesere maraan haa ame; «Muun wodanattisinii haa k'oppaattan? ");
INSERT INTO bswl_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‹C'ubbokka haheso amamera› amanokkona ‹Kigudde gali› amanokko eekiya enekki? ");
INSERT INTO bswl_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ayesuun goɂameen hikka usu kakkoonɂamera ere kaɂibaaddo ul gutii c'ubbona haheso amin odonnati kaɂabo laano goggomalabtaanunya.» Naafaleessa lee kagire ibaaddotine, kigudde alggaattaa sidadde minkakkaa gali ame. ");
INSERT INTO bswl_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Usuna goorsewa keegure isoo hore aallee; huddure takkogire alggaa sidategure Waa galataa minkkeessa gale. ");
INSERT INTO bswl_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Esee kagire ibaaddo dubbana mamano haggaɂabe; Waanna galataa, «Hittaari kasaadisiro ayees deenne» amaa abissii ammagame. ");
INSERT INTO bswl_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Esekko abbaabatere Yesuusa esekko bee seete; woyyuu kaɂamamere koo k'arat'a kakukkuyisare k'arat'a takkoɂaatanaa banɂee kahamas'eero deegure, «Indebee sessee» ame. ");
INSERT INTO bswl_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Usuna kameen dubbana iise keegure usu debee sesseete. ");
INSERT INTO bswl_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Woyyutina Yesuusaan minkkeessayi aamo kaɂatii ekkaasate; kamooggan k'arat'a kakukkusarena kakkalee ibaaddo iso wota aamoon hamas's'ee gire. ");
INSERT INTO bswl_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kafarasaawi ibaaddona seera kaɂagaalssisare ibaaddo Yesuusane, «K'arat'a okukkuyisarannenna c'ubbaaliyeelnne wota kakkoonɂaamattaanna kakkoont'amattaan mewuunya?» amaa Yesuusakko oɂagaalssataran gutii gumggumeen. ");
INSERT INTO bswl_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesuusana abbaabere isone, «Ohawɂaamaraanun kuwaarre fayyaalessalun akimii lakkodootisaro; ");
INSERT INTO bswl_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Aninna c'ubbaaliyeel c'ubbokko gula galsin kuwaarre k'ulloolee uumn lakkoɂemeeyero» ame. ");
INSERT INTO bswl_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Isona, «Yaannisakko oɂagaalssatareen kamooggan goorata agabuyeen, ebaataran; ibaaddo kafarasaawikko oɂagaalssatareenna usumalee yelataraan; ootta goɂameen arggetto aamanan t'amanaan» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesuusana, abbaabere isone; «Kamashaashee isone wota giraan oɂuumameeran goggoɂagabuyirawun yelin lakkodaanddaamaro. ");
INSERT INTO bswl_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ayesuun goɂameen kamashaashee isokko takkoɂatamira arri emeeyinnatta; hassu goorata agabuyiranwa» ame. ");
INSERT INTO bswl_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Adena haa ame masuussee segee; «Kaɂusubkki sarssikko erbbe fiilere kaddoɂan sarssii gutii erbbe kakkaatara maayyona lakkogiro haa goyele kaɂusubkki sarssi fiilara; taɂusubtti erbbe kaddoɂankki sarssine wota isi lakkoɂaatatto. ");
INSERT INTO bswl_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kaɂusubkki kawoyinii t'amona kaddoɂankki dinbbitoo muulate kakkaatara maayyona lakkogiro; gomuulate adi kaɂusubkki kawoyinii t'amokokki dinbbito ebara; kawoyinii t'amona ubatara; dinbbitona laɂo lakkoɂabo. ");
INSERT INTO bswl_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Haanssun kaɂusubkki kawoyinii t'amo kaɂusubkki dinbbitoo kibamano dootisara; ");
INSERT INTO bswl_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Goortta, kaɂadallate kawoyinii t'amo kakkot'ame goorata, kaɂusubkki kadootatara maayyona laagiro; aalanttina, ‹kaɂadallate karooraniya mankkoɂamanan maraanya.› » ");
INSERT INTO bswl_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ayihuudin tafoolssi arri Yesuusa ira orromare rooraa gire; usukko oɂagaalssatareenna shawuyee ebiseen aatenee genee honk'ofeen aamaa gireen. ");
INSERT INTO bswl_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kafarasaawi ibaaddo orrokko kokkoo goɂameen, «Ayihuudin tafoolssi arri felamiin odootisoon felo muun felattaan?» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesuusana haa ame isoon abbaabe, «Daawute kakkoɂuɂeere goorata wota ogireene wota kayelero dubba lakkonabbabittetteeniya? ");
INSERT INTO bswl_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Usu min kawaa tabere Waawun kalekki kalleero tuuk'aamol kaalaalun feɂi kakkosisanttetto babo atate aame; usune wota ogireenunna sise.» ");
INSERT INTO bswl_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Adena, «Ere kaɂibaaddo tafoolssi arriin Goottaya» ame. ");
INSERT INTO bswl_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Takkalee Ayihuudikkotti tafoolssi arriinna Yesuusa kaɂayihuudi min kaɂebii tabere agaalssisaa gire; esena gene tamergge kakkonaafattette ibaaddoti koo gire. ");
INSERT INTO bswl_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Seera oɂagaalssisareenna kafarasaawi ibaaddo Yesuusa mootin aalantti dootaa, tafoolssi arrittisooyi usu gofayyisinarona din oora gireen. ");
INSERT INTO bswl_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesuusana k'ofattisoo addeesegure gene kakkonnafattette ibaaddotine, «Kigudde t'eɂee aallii» ame; ibaaddotina kee aallee. ");
INSERT INTO bswl_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Esekko Yesuusa, «Alla ayees koo ani isin hoosaro; tafoolssi arriin feɂi kakkonsisanttetta idane feliinya muu meellane feliinya? Neefo haasanoyya muu baasanoya?» ame. ");
INSERT INTO bswl_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesuusa ade usuu maraamure kagiro ibaaddo dubbana deegure ibaaddotine, genettaa diriirssa ame; ibaaddotina goggoɂamameroo yele; genena suure fayyiite. ");
INSERT INTO bswl_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ibaaddo goɂameen aaloo amaraate; Yesuusa gutii me yelin dootisaro isi isiorroo raattoo ayeeseen. ");
INSERT INTO bswl_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Hassu arriilkko tooyi Yesuusa ebaayin wodami tos bee; hemeen duuddo Waa tos ebaataa baree. ");
INSERT INTO bswl_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Babbaris usukko oɂagaalssataran uumegure isokko tomonkko lama assaabe; isona ofarameeraan ame mege beese; ");
INSERT INTO bswl_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Isona P'et'iroosa ame kaɂuumera Simoona abbikkeessa Endiraasa, Yayik'ooba, Yaannisa, Filp'oosa, Berttelomeewosa, ");
INSERT INTO bswl_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matoosa, Toomaasa, kaɂilfoosa ere Yayik'ooba, «Kahaɂusatare» kaɂamamere Simoona, ");
INSERT INTO bswl_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Kayayik'ooba ere Yihuudana Yesuusa roorise kasisere ul kaɂask'oortukki Yihuuda leen gireen. ");
INSERT INTO bswl_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesuusa isone wota raattoo wodamikko dagegure diidatti banɂee aallee; usukko ofarameeraanna aaloo kamooggan ibaaddo ese gire; Yihuuda maaman dubbakkona Iyyerusaalemikko usumalee T'irooskona kasidoona labugirkko kaɂemeetera kamooggan gosana esee gire. ");
INSERT INTO bswl_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Hinɂina kakkoonɂemeteeren usukko maalinna kaɂabanayeen maarɂorrookki hawɂaamikko fayyiinye. Battiikki ayyaanayi abboosaama ogireenna fayyeen. ");
INSERT INTO bswl_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Hunna usukko biyaa dubbana fayyiisaa mankkogire maraan, ibaaddo dubba usu diniin dootataa gire. ");
INSERT INTO bswl_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesuusa usukko oɂagaalssataran tos diyaa haa ame; Isin hiyyeessa osommaasantteettan wononnati kawaa kakkisinyya; ");
INSERT INTO bswl_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Isin gidda oɂuɂaattaan osommaasantteettan; haarre bararinnattaan; Isin gidda oɂootattaan osmmasanttettan; haarre osolinnattan! ");
INSERT INTO bswl_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ibaaddo ere kaɂibaaddo maraan godiide, isin orrokko goɂassaabeenna gotuffaten, kameellan mege gosisenna osommaasantteettan. ");
INSERT INTO bswl_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Hittima muraattisin daruurii taɂatiitta; hasse arri isinuun geggeloo halleen; burraak'a; kahorkkoo odojolaalkkiso kahegeroo gutii kayeleraan hikkawaye. ");
INSERT INTO bswl_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ayesuun goɂameen isin dureessajjol Aanne isinuun! Goggoɂinna giddawa atatteettan. ");
INSERT INTO bswl_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Isin gidda obbararttettan aanne isinuun! haarre uuɂinattan. Isin gidda oɂosolattan aanne isinuun! haarre gaddinnattaan; ooyinnattaan. ");
INSERT INTO bswl_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ibaaddo dubba idanettattisin goɂayeese aanne isinuun! kahoree odojolaalkkiso ot'araa hegerojoolun kayeleeren hikkawaye. ");
INSERT INTO bswl_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Ayesuun goɂameen isin omaalattanun ani haa amara; diinajjoolkkisin geelayen; isin odiidaraawunna idane fela; ");
INSERT INTO bswl_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Isin kak'anggaarona sommaasayeen; isin kamirɂaroonna ebaayen. ");
INSERT INTO bswl_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Uyyi koo kabbasaroon kakkalee uyyi adi tusi; gashe kukko kaɂataroon k'olo arootirtte. ");
INSERT INTO bswl_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kaɂebaataron dubbaan sisi; urrawoɂoottaa kaɂaataroon goggoɂabbaabron aroohoosatte. ");
INSERT INTO bswl_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ibaaddo goggofelloo kadootattaan isinna usumalee fela. ");
INSERT INTO bswl_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Isin kageelaataro goggeelatten me kaletti laɂo helayinattaan? ‹C'ubbaalessajjoolnna› goɂameen iso ogeelataraan geelataran. ");
INSERT INTO bswl_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Idane isinuun ofelaraawun idane gofeltteen me kaletti laɂo helayinattaan? C'ubbaalessajjoolnna goɂameen hikkamalee felataraan. ");
INSERT INTO bswl_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Amɂaa abbaabirowa antteen kakkohedattaan ibaaddon goɂamɂayisseen me kaletti laɂo helayinattaan? C'ubbaalessajjoolnna goɂameen kaɂamɂayiseraan gitakki abbaabayi atayin c'ubbaalessajjoolunna amɂayisaran. ");
INSERT INTO bswl_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ayesuun goɂameen diinajjoolkkisin geelayene; idanena fela; abbaabayi atayin abddi hayelannooni amɂayisa; hikkaniinna muraatattisin tanjiin leeta; dubbaankko t'ok'k'i kaɂame yiis kawaa linnattaan; usu galata kallikkiwunna kameellan ibaaddo dubbaan kaɂidankkiya. ");
INSERT INTO bswl_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kadaruure Aabbokkisin isinuun goggoneneɂyisatarokki malee isinna usumalee onenɂeeyisaattan laa. ");
INSERT INTO bswl_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Aroofirdditeen isinuun lakkofirddaamiro; aroobohitteen; lakkobohanttaan; haheso ama; Waa isinuun haheso amirowa; ");
INSERT INTO bswl_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Sisa Waa isinuun sisirowa; kakkoɂekkaasattan huuyi abbaabayi isinuun mankkoɂekkaasaminaro maraan, huc'c'imi aaɂi migllii taaɂubaroo kaɂidankki huuyi ekkaasami isinuun sisaminara.» ");
INSERT INTO bswl_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Adena Yesuusa hikka masuussa haa ame isoon segee; «Ilɂoo kadeyannon iilɂoo kandeyaannon abi geggeeyisin daanddaara? Lama isiɂabateeren gumbbii orroddeen lakkoɂiyaaraniya? ");
INSERT INTO bswl_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kaɂagaalssatara kaɂagaalssisarokko lakkorooraro; ayesuun goɂameen madaari kaɂagaalssate ibaaddo dubba kaɂagaalssisaro aani linnara. ");
INSERT INTO bswl_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Abbikkakkatti ilii orroo kagiro huura mewuun diyaatta? Ilttaayi orroo kageeddabamero gaa lakkodiyaattoya? ");
INSERT INTO bswl_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ilttaayi orroo kagiro gaa handeyaannooni abbikkaanne ‹Abbikkee; ilttaayi orroo kagiro huura kuun beesu› misii amin daanddaatta? Ati ifissaaddaa; horaarjje ilttaayi orroo kageeddabamero gaa beesa; esekko abbaabadde abbikkaatti ilii orroo kagiro huura beesin iidisi din daanddaatta. ");
INSERT INTO bswl_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Kaɂidankki gaa lee giranttii tameellantti il kadubamara gaa lakkogiro usumaleenna kameellankki gaa lee giraan taɂidantti il kadubamara gaa laagiro. ");
INSERT INTO bswl_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Gaa dubba takaataro ilii addeesamara; gaa kaɂeɂeenkkona belesi taɂamamatta il lakkoɂabaabamatto; usumaleenna moolaalkko woyinii taɂamamatta il lakkoɂabaabamatto. ");
INSERT INTO bswl_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kaɂidankki ibaaddo wodanatteessaa kaɂammagamero kaɂidan ayeeskko idane beesatara; kameellan ibaaddo wodanatteessaa kaɂammagamero kameellan ayeeskko meellane beesara; ibaaddo wodanatteessa ammagame karoorero hiɂitteessayi ayeesara. ");
INSERT INTO bswl_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Ani kaɂamaro lakkofelattaan hayya muun, ‹Gootta, Gootta› amattaan? ");
INSERT INTO bswl_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","In tos kaɂemeetara haafurakkee maalere felooyi kahayisara dubba ayyo aani laaro ani isinuun tusiro; ");
INSERT INTO bswl_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","min madaarayiin aaloo gumbbi yele kaɂosherona eɂemoo gutii ukum kaɂukumaatero ibaaddoti aani laara; daad ammagame emeetegure usu min shafe; ataate mankkomadaaramere maraan aaɂisinna lakkodaanddee. ");
INSERT INTO bswl_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Haafura kakkee maalere felooyi kahayisoon goɂameen minkakkeessa ukum kallii erree gutii kamadaaratero ibaaddoti aani laara; daad ammagamanokko kakkeeyi min kakkoshafare goorata goorsewa iyye; iyaanona gomeellan lee.» ");
INSERT INTO bswl_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesuusa hikka dubba gosaa hore ayeese gudisere K'ifirenaahoomi tos tabe. ");
INSERT INTO bswl_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Esena karoomi wotaadara booluun woyichcha kalleere gire; usu aaloo kageelaatare usuun kahandaarekki hawɂaamere goyin gabbalame gire. ");
INSERT INTO bswl_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Usuna Yesuusakokki gara kakkomaalare goorata usuun kahandaarekki goggofayyisiroo goggoɂebaanawun ul kaɂayihuudatti jaarsoleekko fare. ");
INSERT INTO bswl_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Handdaa ofarameerenna Yesuusa tos emetengureen haa ameen ataayiseen ebaaten; «Hikka ibaaddotin ati hikka felin dootisara; ");
INSERT INTO bswl_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Aalanttina hikki ibaaddoti gosakkaani geelaatara; min kaɂebikaani noon kamadaarsiserana usuya.» ");
INSERT INTO bswl_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesuusa isone wota seete. Usuna min tos kakkogabbalamare goorata, wotaadara boolkokki woyichchati ogeelaatare farere Yesuusane haa ame; «Goottaa; ati minkkee orddi tabin ani kadootisaro ibaaddoti lakkoyo aroohartte; ");
INSERT INTO bswl_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Hikkakko kakkeeyi ku hore gabbalamiin duuddo kadootisaro aani isiɂootte lakkotootataro; haafura koo kaalaal ayeesi; iin kahandaarekki fayyirowa. ");
INSERT INTO bswl_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ani metekkeewun kaguutee woyichcha aba inkko hegelle ade iin kahandaara wotaadara gira; koonne ati ‹See› goɂamiro seetara; kakkalennena, ‹Koyya› goɂamiro emeetara; iin kahandaarana, ‹Hikka feli› goɂamiro iin ajajaamara.» ");
INSERT INTO bswl_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesuusana hikka kakkomaalare goorata usuu saade; kambbal amerena debeesseeta kagire gosane, «Ani isinne haa amara; hitta aanttitti tanjiintti ammano Isiraɂeelii duuddo ani lakkohelero» ame. ");
INSERT INTO bswl_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Handdaa kaseetere ibaaddo min kakkoɂabbaabatare goorata, usuu kahandaarekkina kafayyeero deen. ");
INSERT INTO bswl_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Esekko abbaabatere Yesuusa tanjiin haɂadallaannooni, Naayin taɂamamatto katamaa tos seete; usukko oɂagaalssataranna kamooggan gosa usune wota seete. ");
INSERT INTO bswl_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Katamaa tos kakkotabaraan karra Yesuusa kakkogeyaare goorata, ibaaddoti kookokki rees sideengureen katamaakko been; kagoyerena Aayettessaawun koo kaalaalye; Aanna galttaanttette; kamooggan kakkatamaa gosana esene wota gire. ");
INSERT INTO bswl_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Goottanna ese kakkodeyaare goorata nenɂeyisategure, «Allamandde, arooɂootte!» ame. ");
INSERT INTO bswl_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Gabbalamere takkosideeraan raree dine; kasidere ibaaddona takki ame aallee; Yesuusana, «Ati wodallaati, ani kunne ki amara» ame. ");
INSERT INTO bswl_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kagoyere ibaaddotina neefo abbaabattedde fayyeere t'ok'k'i ame hamas's'ee; ayeesano haggaɂabe. Yesuusana aatere Aawun sise. ");
INSERT INTO bswl_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Dubbana abssatereen Waa galataa, «Kaɂatii kahegeroo no orrokko keera», «Waa gosakkeessa fayyiisin emeetera» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hikki Yesuusakokki ataan kayihuuda ul dubbaayinna usu maamanii kagiro ul dubbaa addeesame. ");
INSERT INTO bswl_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yaannisakko oɂagaalssatareen hikka dubba Yaannisaan segeen. Usuna iso orrokko lama uumere, ");
INSERT INTO bswl_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","«Emeetara kaɂamantette atitte? Muu kakkalee ooranna? Ama» ami goggohoosanawun Goottaa tos fare. ");
INSERT INTO bswl_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ibaaddojjana Yesuusa tos seeteerene, emeetara kaɂamantette atitte? Muu kakkalee ooranna? Ami no ku goggohoosannon «Kat'ammak'aara Yaannisa no ku tos farera» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Goorsewa Yesuusa kamooggan ibaaddo hawɂaamikko, maar orrookki hawɂaamikkona battiikki ayyaanalkko fayyiise; kamooggan ilɂo kandeyaannon ilɂoo denddeeyise. ");
INSERT INTO bswl_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yaannisaan handdaa oseeterenne Yesuusa haa ame; «Seenguddeen kaddeetettanna kamaaltteettaan Yaannisaan segaa; Iilɂoo kandiyaannon dinnara; oɂeesaraan tukkul sesseyinaraan; maarii bar oɂabana muc'c'iminaraan; nebee omaaloonna maalnnaraan; ogoyeraanna goyikko kinnaraan; hiyyessaalunna wongala lallabaaminara. ");
INSERT INTO bswl_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Iyyee abddatana waatti kahandudufannon ibaaddo dubba kasommaasameya.» ");
INSERT INTO bswl_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yaannisaan handdaa oɂemeetereen seeteen kakkobowaareen goorata, Yesuusa gara Yaannisakokki ayeesano haggaɂabe; haanna ame; Yaannisa tos gaa kakkoonbeeteetten me diinyye? Ambbal kawolliwollisatto fiik'eya? ");
INSERT INTO bswl_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Hayya me din beeten? Kaɂidan sarssi kasarsatero ibaaddoya? Kaɂiidaro sarssii oɂissaadaraanna giri kaɂekkaate ogiraan min kawonooyi giraanwa. ");
INSERT INTO bswl_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Hayya! Isin me din beeten? Kahegeroo din leewuna? Ii ani isinne haa amara; isin din kabeetetteen kahegerookkona karooraroya. ");
INSERT INTO bswl_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Haa amame kakkoons'aafamerena usuya; « ‹Raakkaanna ku horee kaɂekkaasiro, erggichchakkeenna kukko t'ayisi ani farnnara.› ");
INSERT INTO bswl_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ani isinne haa amara; heleelkko kaɂumulamero orrokko Yaannisakko karoorara laagiro; wononnati kawaayi goɂameen dubbaankkona kayeraatara usu roorara.» ");
INSERT INTO bswl_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","K'arat'a okukkuyisaraanna hahesooni, hikka omaaleen dubba kayaannisa t'ink'ata t'ammak'aamaa Waa k'ulluukkiya ameen atoteen. ");
INSERT INTO bswl_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ibaaddo kafarasaawilnna seera kamuse okasaan goɂameen tayaannisa genee t'ammak'amana waatti, Waa isoon kaɂabo halchcha neebateen. ");
INSERT INTO bswl_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesuusa ade, «Goortta hitta alattankkokki ibaaddo ani meyii masuussira? Me aani laaran? ");
INSERT INTO bswl_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Banɂe tagiyyaayi hamas's'eereen isi isirroo isi uɂuumataa haa kaɂamaro yiisaas aani laanan, ‹Noo sussullee isinuun ufuufinne, lakkoduddurtteen; boochcho isinuun beensse, lakkoɂootteen.› ");
INSERT INTO bswl_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Aalanttina kat'ammak'aara Yaannisa agabuuyi kaami haɂamoonna kawoyinii t'amo hant'amooni goɂemeete, ‹Battiikki ayyaana aba› antteen. ");
INSERT INTO bswl_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ere kaɂibaaddo adi aamaanna t'amaa goɂemeete ‹Aamoonna t'amoon kagap'igap'aaro, k'arat'a okukkuyisaraanna c'ubbaalessaal kageelaataro› antteen. ");
INSERT INTO bswl_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Goortta k'arummakokki likkii laano kaɂatatero ibaaddo dubbaa dollee addeesantte ame.» ");
INSERT INTO bswl_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Eseenna ibaaddo kafarasaawikko koonne wota babo goggoɂaamiroon Yesuusa uumate, usuna Farasaawitikokki min tos tabegure babo aamin hamas's'ee. ");
INSERT INTO bswl_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ese katamaayi tagitte too c'ubbaalettii heleelttiti, Yesuusa Farasaawitikokki minii babo aamin hamas's'aano kakkomaalatte goorata koo Alibast'iros kaɂamamaro eɂemokko k'orame kafelamero bilk'aade mig talleetetto shittoo aatte emeette; ");
INSERT INTO bswl_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mina tahaarenne luk'k'aa dollee aallitede ootaa ilmmi luk'k'aa gutii ubaa metekkiseyinna shakaarano haggaɂabtte, luk'k'aɂoottessana anggataa shittoo shigidde. ");
INSERT INTO bswl_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kaɂuumatere Farasaawitina hikka kakkodeyaare goorata, hikki ibaaddoti kahegeroo lii girewa usu tadintetta heleelttiti maayyotto, adde maamisitti ibaaddotitto addeesi girare; c'ubbaalettiitta ame wodanatteessa hede. ");
INSERT INTO bswl_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesuusana, «Simoona, ani kuun kaseginaro ayees aba» ame. «Usuna kaɂagaalssisatto! Iin segii» ame. ");
INSERT INTO bswl_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesuusana haa ame, koo kaɂamɂayisarokko maragade oɂamɂaateeren ibaaddojja lama gireen, koo ken boolee t'agaraa, kallamina ade t'agaraa konttom amɂaateren. ");
INSERT INTO bswl_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Abbaab kasisina kakkowaatareen goorata anzattisoo lama dubbaanna usu isaage. Goortta iso lama dubbakko kaɂamɂayisero roorssate kageelaatara eekiya? ");
INSERT INTO bswl_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoonana, «Tammooggan anza kakkoonhesetto aani laara» ame abbaabe. Yesuusana, «Likkii abbaabttetta» ame. ");
INSERT INTO bswl_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Heleelttiti tos kambbal amere Simoonane haa ame, «Ati hitta heleelttiti diyaatta? Ani minkaa gottabe, ati luk'k'aɂoottewun bekena lakkosissette, ese goɂameen luk'k'aɂoottee ilmmittiseeyi aalisedde metekakkiseyi shakaartte. ");
INSERT INTO bswl_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ati duuddo in anggatte nogodda lakkoɂaattetto, ese goɂameen ani gottabekko haggaɂabittedde luk'k'aɂoottee anggatana lakkoɂaallissetto. ");
INSERT INTO bswl_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ati metekakkeeyi zayitiinna lakkoshigiddetto; ese goɂameen luk'k'aɂootteyi shittoo shigidde. ");
INSERT INTO bswl_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Haanssun ani haa amara; ese aaloo in geelattetta kanjiin c'ubbo eseen shaaga leera; c'ubbo kic'c'arkki shaaga kakkoonleera goɂameen abaraanttii geelaatara.» ");
INSERT INTO bswl_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Esekko Yesuusa heleelttitine, «C'ubbokka haheso amamera» ame. ");
INSERT INTO bswl_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Usu wota babo aamin hamas's'ite tagitte marttina, «Hikki c'ubbo duuddo haheso kaɂamara usu ayyoyya?» ameen isi isiɂorroo ayeeseen. ");
INSERT INTO bswl_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesuusa heleelttitine «Ammanokka ku fayyiisera nogoddaa gali!» ame. ");
INSERT INTO bswl_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Esekko abbaabatere Yesuusa wononnati kawaa kageggelaayisiro haafura lallabaa katamaalnnena maamanjolaalnne roore, tomonkko lamana usu wota gireen. ");
INSERT INTO bswl_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Usumalee battiikki ayyaana kakkoonbeerana maar orrookki hawɂaamikkona kafayyeera kookkoo heleeljoolnna wota gire; isona durrisa todoba takkoberee ul kamegidellakotti Mayiraame, ");
INSERT INTO bswl_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Kaherodoosa minii odonnati kaɂabanaaye takuuza oori Yohaana, Soosinna, adena kamooggan kakkalee gire; hinɂina urrawoɂoottisooyi Yesuusana usukko oɂagaalssatarewuunna ohandaareenyen. ");
INSERT INTO bswl_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kamooggan gosa koollee kukku ame giranttii, adena ibaaddo kalekaleetti katamaalkko Yesuusa tos kakkokukkuɂamare goorata, hikka masuussa haa amaa isoon segee; ");
INSERT INTO bswl_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Koo otate kabaraare wut'a wut'ayiin bee; wut'ataa giranttii kookkoo wut'a raadii iyye; lukiinna daddarame; kimbirjolnna aame. ");
INSERT INTO bswl_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kookkoo wut'a taɂeɂemooltti erree iyye; goggoɂalatee unjjane giranamankkowaatte maraan angage. ");
INSERT INTO bswl_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kakkalee wut'ana ade eɂeen orroo iyye; eɂeen wota jiinatte marggisse haasse. ");
INSERT INTO bswl_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kakkalee wut'ana erre taɂidantti gutii iyye; kakkoɂalatare goorata kawut'amerokko bool ambbaanna dubame.» Hikka amere gudisaa yaaye t'ok'k'iɂisere, «Tamaalatto nebe kaɂaba hamaalo» ame. ");
INSERT INTO bswl_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesuusakko oɂagaalssatareen hitta masuussakotti fureen usu hoosaten. ");
INSERT INTO bswl_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Usuna haa ame; «Wononnati kawaakotti hool malabano isinuun sisamera okkaleetun goɂameen masuussayi ani ayeesinara; hikkina, diyaagiraan wodanaa goggokokannonkko, maalaa giraani goggoshaadonkoya.» ");
INSERT INTO bswl_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Goortta tamasuussa fureenna hittatta. Wut'a kaɂamamere haafura kawaayya. ");
INSERT INTO bswl_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Raadii kaɂiyyerena haafura ommaalaraan, ayesuun goɂameen ammanireen goggofayyinonkko durrisa emetere haafura wodanatatteessakko kakkoɂaataroyaan. ");
INSERT INTO bswl_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Eɂemooltti erree kaɂiyyere haafura gomaallan geggelooyi oɂatataraanyan. Hinɂi goorata kic'c'arun ammanaraan kuwaarre hidiid mankkowaatemaraan kac'aafitii goorata bannee okakataraanyan. ");
INSERT INTO bswl_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Eeɂeen t'eɂee kaɂiyyerena haafurakkeessa ommaalananyaan; hayeen bareenen giri kaɂuleekokki k'ofaa, durummayinna barsano oɂidaneeti geggelooyi marggisamene dubamin goggodootisaroo il lakkodubamaran. ");
INSERT INTO bswl_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Erre taɂidanii gutii kaɂiyyera haafurakkeessa taɂidanttinna tukkultti wodanaa maalereen oɂoorataran; obssaanna ataataa il odubamaraaniyan. ");
INSERT INTO bswl_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Korroontta hank'k'ayisatere toossa orroo goorttun alggaa hegelii kakkaatara maayyona lakkogiro, haa kayelarokko min orddee katabara ibaaddo ifa goggodiyaro bollanssoo gutii sowaatara. ");
INSERT INTO bswl_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kamutoon kasiyamera, kaɂaddeesamoon ifa tos kanbeenoon, kagolatera ayees lakkogiro. ");
INSERT INTO bswl_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Goortta isin maamisii maalnnattan isiiɂoorayeen; kakkogiroon adamara; kallikki dubbakko ade aankki kagiro aani kallaara duuddo ataminara.» ");
INSERT INTO bswl_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Esekko abbaabatere Aaye tayesuusana abbilaaltteessa Yesuusa mankkogiro emeeten; isona gosa mooggankko kakkeeyi usu tonssa gabbalamiin lakkodaanddeeren. ");
INSERT INTO bswl_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Hassu goorata, «Aayettana abbilaaltta ku din dootereen sarre aalleeran» ameen usuun segeen. ");
INSERT INTO bswl_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Usuna isoon abbaabere, «Aayettina abbilaalttina haafura kawaa maalereen felooyi ohayisataraayan» ame. ");
INSERT INTO bswl_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Arriilkko arri tooyi Yesuusa usukko oɂagaalssataranne wota wolabooyi koratere, «Bekekko gama nak'ina» ame; esekkona duudaatano horeddeen. ");
INSERT INTO bswl_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bekee orroo duudaataa giraanttini Yesuusa wolaboo orroo huddure; usu goorata beke gutii gaashimallo kaɂatii kee, bekena wolaboo k'amakko rooreene mankkotabeene maraan bayikkotti hiɂi geegeen. ");
INSERT INTO bswl_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yesuusakko oɂagaalssatareen usu tos gabbalameeren, «Goottaa, Goottaa! No lagudannella!» amaa huddurokko usu nabbaadiseen, usuna nabbaadere ambbalnna, bekekkokki shalagaamano hadise; usu goorata ambbalnna shalagaamano iisse c'alɂeetti leete. ");
INSERT INTO bswl_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Usuna usukko oɂagaalsatanaanne, «Ammanokkisin eeko hayya? Ame. Isona abssiinna saadanoyi, hikki ambbalnna bekena kakkon ajajaamaraan afo ayyoyya?» ameen isi isiɂorroo ayeeseen. ");
INSERT INTO bswl_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Esekko abbaabatere Galiilakko gamaa kagiro kagerggesennooni ul tos wolabooyi nak'een. ");
INSERT INTO bswl_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesuusa wolabokko deegere baga kakkobeyaare goorata, durrisa gutii kakkogire koo ese katamaakokki ibaaddoti esele; hikki ibaaddoti kamooggan goorata sarssi ansarssannonii, minna hanttabooni banɂe tahiyyeel min kayelatereya. ");
INSERT INTO bswl_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Yesuusa kakkodeyaare goorata okkaa usu horee iyye; taɂatii yaayee, «Dubbaankko kanjiinkki ere kawaa Yesuusa; ati inne wota tammee esella abtta? In goggoɂabboosisonkko ebaatara» ame. ");
INSERT INTO bswl_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Hikka kakkoonɂamere battiikki ayyaanajjol ibaaddotikko goggobeero Yesuusa ajaja sise mankkogire maraanya. Battiikki ayyaanajjol arggetto mankkokeyaaro marantuu ibaaddoti sanssalataanna marc'c'o talukeeti shaami goɂooramirona kakkoshaamero sanssalata goggoosa kaɂabere battiikki ayyaanajjol gaa tos aate biyaa gire. ");
INSERT INTO bswl_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesuusana, «Megekkaa ayyoyya?» ame usu hoosate. Usuna kamooggan durrisa tabe mankkogire maraan, «Megekkina Legeɂooniya» ame. ");
INSERT INTO bswl_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Durrisanena bowwa orro taba ami goggoɂajajiinoonkko ataayiseen usu ebaaten. ");
INSERT INTO bswl_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Usu maamanii wodami laayuyi jigi talleeta tammooggan booyyee ese foofamaa gitte. Durrisane tammooggan booyyee tos taba ami feɂi goggosisiroo ebaaten; usuna feɂi isoon sise. ");
INSERT INTO bswl_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Durrisana ibaaddotikko beegure booyyee tos tabeen; Booyyelnna bowwa hiɂi hegelddee otottoola beke orroddee tabe lichchi ame. ");
INSERT INTO bswl_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ofoofeenna kalleero ayees kakkodeyaaren goorata, tittiyeen seetereen katamaayinna gat'aree ayeeseen. ");
INSERT INTO bswl_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Gosa kalleero ayees din mankkogirokko beegure Yesuusa tos emeete. Durrisaal kakkobeere ibaaddoti sarssi sarssatere, wodanatteessa abbaabattedde, Yesuusaa lukii hegelii kahamas'eero kakkodeyaaren goorata abssateen. ");
INSERT INTO bswl_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Durrisaa kaɂabamere ibaaddoti fayyaa giranttii odeeraanna, misii fayyeero gosaan segeen. ");
INSERT INTO bswl_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Maaman kagerggesennoni ulkokki ibaaddo dubba tanjiin abssategure, esekko goggoseero Yesuusa ebaaten; usuna wolaboo tabere abbaabate seete. ");
INSERT INTO bswl_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Durrisaal kakkobeere ibaaddoti Yesuusa wota seeyin ebaate; usu goɂameen haa ame; ");
INSERT INTO bswl_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Minkaa abbaabadde, Waa kuun kafelero kanjiinkki ayees ayeesi.» Ibaaddotina Yesuusa usuun kafelero kaɂatii ayees katamaa dubbaa mute ayeesa seete. ");
INSERT INTO bswl_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Gosa dubba emetotteessa oorataa mankkogire maraan, Yesuusa kakkoɂabbaabatare goorata geggelooyi usu atateen. ");
INSERT INTO bswl_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Usu goorata Iyaɂirosi kaɂamamere kaɂayihuudi min ebikkokki woyichcha emetere, luki tayesuusa gutii iyyegure minkkeessa goggoseero ebaate; ");
INSERT INTO bswl_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Hikka ebi kakkoonɂebaatere gees tomonkko lama takkoleere too unnutti taalaal mankkogitte maraanye; esena hawɂaanttedde goyii hiɂi gutii gitte. Yesuusa eserraa seetaa giraan gosa isiɂisi shashafataa aaloo harisaa gire. ");
INSERT INTO bswl_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Gees tomonkko lama iigi ubataa takkogire heleelttiti too gitte; kaɂabtto dubba odo doobjjoolun gussattedde fayyiisinna kadanddeere maayyona lakkogire. ");
INSERT INTO bswl_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Esena mina tahaarenne gabbalanttedde sarssikotti birt'e dintte; ubataa kagire iigina goorsewa aallee. ");
INSERT INTO bswl_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesuusana, «In kadinera ayyoyya?» ame. Dubbana dinanawaattikisoo kakkokakatareen goorata P'et'iroosa Goottaa, gosa dubba maraamure ku harisara ame. ");
INSERT INTO bswl_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yesuusa ade ibaaddoti, «Koo in dinera; hunnana inkko biyaano kasa» ame. ");
INSERT INTO bswl_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Heleelttitina isi siyamissayi galin daanddaanawaatti kakkoɂaddeesatte goorata, harɂaa emeettedde usu hore iite; mewuun dinttettona misii goorsewa fayyitetto gosa dubbaa hore segaatte. ");
INSERT INTO bswl_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Usuna, «Unnuttee; ammanokka ku fayyiisera; nogoddaa gali» ame. ");
INSERT INTO bswl_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesuusa ganaa ayeesaa giranttii, ibaaddoti koo Ayihuudikokki min kaɂebii woyichcha kalleere kaɂiyaaɂiroosi minkko emetere, «Unnutatta gootetta; hittakko danbbeebaan kaɂagaalssisaro arooharisse» ame. ");
INSERT INTO bswl_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesuusana hikka maalere iyyaɂiroosine allamandde, «Aroo abssatte; amana kuwaarre unnutatta fayyinatta» ame. ");
INSERT INTO bswl_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Min kaɂiyaaɂiroosi tos gotabiro P'et'iroosa, Yaannisana Yayik'oobakko usumalee unnutikotti Aanna odona kuwaarre maayyona usu wota goggotabroo lakkodootero. ");
INSERT INTO bswl_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Hassu goorata ibaaddo dubba woo woo amaa eseen ootaa gire. Yesuusa ade, «Aroo ootteen; huddurttetta kuwaarre lakkogootetto» ame. ");
INSERT INTO bswl_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ibaaddona gowaanokkisee mankkokaso maraan usuun osole. ");
INSERT INTO bswl_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Usu goɂameen genettisee abere, «Teɂati unnu, ki» ame. ");
INSERT INTO bswl_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Neefo taɂunnutinna abbaabatte; goorsewa keete aallite, Yesuusana ese kaɂaantto kooko goggosisirawun segee. ");
INSERT INTO bswl_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Oɂumuleeraanna saadeen; usu goɂameen kalleero ayees maayyonna goggoɂayeesonkko segee. ");
INSERT INTO bswl_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesuusa tomonkko lama ofarameeraan raattoo uumere durrisa dubba goggobeesinawun maar orrookki hawɂamkkona goggofayyisinawun hunnana odonnati isoon sise. ");
INSERT INTO bswl_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Adena wononnati kawaa goggolallabirawunna kahawɂaamaro goggofayyisinawun iso fare; ");
INSERT INTO bswl_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Haanna ame; «Raakkisinuun dama golleete, shile golleenna, babona gollee, maragade gollee, kakkalee kaɂiggilssattan sarssi abatano lakkodootisaro. ");
INSERT INTO bswl_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Hassu maamankko taabetaan geegin horaarjje kakkotabtteettan kamaakkayyo miniinna adallaayen. ");
INSERT INTO bswl_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Hasse katamaakokki ibaaddona isin hak'op'annooni hesire katamaattisoo Iisseen takkobeyattaani, seerisano isinuun goggolleeroon kalukee gorra hurggufayendden biyaa.» ");
INSERT INTO bswl_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Isona usu malabeengureen wongala lallabaa banɂe dubbaa dhukkubaleessajjool fayyiisaa maaman maamanii rooraa gireen. ");
INSERT INTO bswl_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kagaliila ulkokki mooti Herodoosana, usu goorata kalleero ayees dubba maalere kalleero ayeesii girddiɂame; aalanttina ibaaddo kookkoo kat'ammak'aara Yaannisa goyikko keera amaa ayeesaa gire. ");
INSERT INTO bswl_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Okkaleenna Eelaasa goggomutero, okkalee adene ot'awoo hegeroolkko koo goyikko keera amaa ayeesaa gireen. ");
INSERT INTO bswl_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodoosana, «kat'ammak'aaro Yaannisa ani marggi goosisere goyera; hayya, usu garakkeessa haa ayeesamaa kamaalara hikki Ibaaddoti ayyoya?» ame, Yesuusa ilii din dootaa gire. ");
INSERT INTO bswl_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ofarameerenna abbaabateen kakkoɂemeteeren goorata kalleero dubba segeen, usuna iso aatere Beetesayida taɂamamatto katamaayi kaletti banɂe seete. ");
INSERT INTO bswl_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Gosana hikka addeesegure debeesseseeten, usuna k'op'atere wononnati kawaakokki gara isoon segaa gire, fayyinna kakkoondootisarona fayyiise. ");
INSERT INTO bswl_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ul hemeen liin laa giraan, tomonkko lama usu tos gabbalameeren, «Kakkogginna ul k'alullattokki mankkollee maraan, gosa usu gobobii k'amanne kagiro maaman tos seeyireen babo mankkoɂiminaranna tabariisanoo banɂe goggodootarawun gafari» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yesuusa ade, «Kaɂaamiraan isinwa isoon sisa ame. Isona, hikka gosa dubbaan kalleera babo seeyinne goɂiminne kuwaarre, noon kagira babo kenkkona kunɂub lamakko lakkorooraro» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kuma ken kalleera babbaar esee gire. Yesuusana usukko oɂagaalssataranne, «Gosa konttom konttomii beesa hamas'iisa» ame. ");
INSERT INTO bswl_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Usukko oɂagaalssatareenna goggosegaamero malee ibaaddo goggohamas'iroon yeleen. ");
INSERT INTO bswl_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesuusana babo kenna kunɂub lamana abere daruur tos eleddee diyaa Waa galateere, ebise aatere gosaawun horee goggoroorisirawun usukko oɂagaalssatarawun sise. ");
INSERT INTO bswl_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Dubbana aameen barareen; usukko oɂagaalssataranna isokko tahessetto hanbba dugud tomonkko lama mig keeseen. ");
INSERT INTO bswl_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Esekko abbaabatere Yesuusa kale ebaataa gire; usukko oɂagaalssatareenna usu tos emeeten; usuna, «Gosa in ayyoyya amara?» ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Isona, «Kookkoo kat'ammak'aaro Yaannisa, kakkalee Eelaasa, kuuki ade kahoree kahegeroolkko koo goyikko keera amaraan» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesuusana, «Isin addeen in ayyoyya amattaan?» ame. P'et'iroosana, «Ati Kiristoosa kafayyisatto Waayi kaɂassaabanttettotta» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesuusa hikka maayyoonna goggoɂayeesonkko ataayise segee. ");
INSERT INTO bswl_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Adena, «Ere kaɂibaaddo rakkoo tammooggan atayin dootisara; usumalee jaarsoleeyi, tuuk'aamokokki woyichchaalnna seera oɂagaalssisarani dollee diidaminnara goyinara, taseedi arrina goyikko kinnara» ame. ");
INSERT INTO bswl_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Esekkona dubbaawun; «Indebee sesseyiin kadootatara maayyona gogire isiɂoottessa hakakate; mask'aliitteessa arggetto sidayigure indebee hasesseto. ");
INSERT INTO bswl_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Muun goɂantteen neefoteessa fayyiisayin kadootatara dubba baasatara; neefoteessa iin amere kabbaasatara ade fayyisatara. ");
INSERT INTO bswl_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ibaaddo alami dubba worɂe gohelate neefo adi gobbaasate goorttun gohank'k'isate laɂo metta? ");
INSERT INTO bswl_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Maayyona iyyeenna haafurakkeeyi gommullee, ere kaɂibaaddo kabajateessaanna Aabbokeessatti kabajaa usumaleenna k'ulluukki erggichchakotti kabajaa kakkoɂemeete goorata mullinara. ");
INSERT INTO bswl_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ani rumminaa amara; hittanii oɂalleeraan orrokko wononnati kawaa handdeenoni kagoonnon ibaaddo gira» ame. ");
INSERT INTO bswl_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesuusa hikka takkoɂayesere arri siddeedkko abbaabatere P'et'iroosa, Yaannisana Yayik'ooba aatere ebaayin wodami tos bee. ");
INSERT INTO bswl_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ebii gutii giraan horetteessa iggilissantte; sarssina hank'k'a aani hank'k'aye gumaara lee. ");
INSERT INTO bswl_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Goorsewa ibaaddojja lama, isona Musena Eelaasa usune wota ayeesaa gireen; ");
INSERT INTO bswl_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Kabajaa muteeren, Iyyerusaalemii liin kagiro hikka alamikko goyikkeessakki gara ayeesaa gireen. ");
INSERT INTO bswl_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","P'et'iroosana wota ogireewun ade hudduro ilɂo isilaattedde huddureen gireen; kakkonnabbadareen goorata kabajatteessaa usune wota oɂaalleeran ibaaddojja lama deen. ");
INSERT INTO bswl_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ibaaddojjana Yesuusakko assaabameene seetaa giraan, P'et'iroosana, «Goottakkee, hittanii girnnewa noon kaɂidankkiye, haanssun daase seed madaarinna; too kuyeen, too Museen, toonna Eelaasan linnatta» ame; usu ussun kaɂayeesarena lakkoɂaddeesare. ");
INSERT INTO bswl_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Hikkana ayeesaa giraan duumanchcha emetere iso hogoogise; duumanchcha tos kakkotabareen goorata abssateen. ");
INSERT INTO bswl_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Duumanchcha orronna, «Ani kaɂassaabayera erekki hikkaya. Usuna maala» taɂamatta yaaye maalssantte. ");
INSERT INTO bswl_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Yaayena kakkomaalssanttette goorata Yesuusa kalebeere mute; usukko oɂagaalssatareenna ayees wodanatattisooyi abateen kuwaarre kaddeeran ayees usu almmaayi maayyonna lakkoɂayeeseeraan. ");
INSERT INTO bswl_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tallami arrii iso wodamikko kakkodagareen goorata, kamooggan gosa emetere Yesuusane wota esele. ");
INSERT INTO bswl_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hassu goorata gosa orrokko ibaaddoti koo yaaye t'ok'k'isere, «Kaɂagaalssisatto; iyyeen kagira ere usu kaalaal mankkollee maraan erekkee ati goggoddeeto ebaatara. ");
INSERT INTO bswl_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Battiikki ayyaana gokkeero derɂa okkaara; saanbba gudisaa ulle boc'aara; miirɂa kakkogeegisiro goorata rakkoo tanjjini isaagara; ");
INSERT INTO bswl_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kukko oɂagaalssataran battiikki ayyaana usukko goggobeesirawun ebaaye; ayesuun goɂameen lakkoɂiso daanddeeran» ame. ");
INSERT INTO bswl_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesuusana, «Ammano kallitti tawoc'ac'c'aantte alattaan, hagge taageeroon isinne wota ani girnnara? Hagge taageeroon obssinara?» esekko ibaaddotine «Alla erekkaa hittarraa keeni» ame. ");
INSERT INTO bswl_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Unnu emeeto gutii giranttii battiikki ayyaanana ul lugudere ulle boc'ee; Yesuusa goɂameen battiikki ayyaanana hadisere unnu fayyiise; Aabbokkeessaan abbaabe sise. ");
INSERT INTO bswl_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ibaaddo dubbana hunna kawaayi mame. Usu kafelero dubbana ibaaddo dubba mamaa giranttii, Yesuusa usukko oɂagaalssataranne, ");
INSERT INTO bswl_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Hikka ani kasegaaro ayees duuddo goggoɂillonnonkko; ere kaɂibaaddo roori gene taɂibaaddoyi sisaminara» ame. ");
INSERT INTO bswl_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Iso goɂameen hikka ayees lakkoɂaddeeseren; goggoshaadonkko ayees golate gire; usu abbaab hoosayinna abssateen. ");
INSERT INTO bswl_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Iso orrokko ayyo rooraro usukko oɂagaalssataran orroo dogamaa keete. ");
INSERT INTO bswl_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesuusa wodanatattisookki yaada addeesere, yiittiti abegure isiɂoottessa dollee aallise; ");
INSERT INTO bswl_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Haanna ame, «Hikka yiittiti megekkeeyi kak'obatara maayyona gogire in k'op'atara. In kak'op'atara ade in kafarerona k'op'atara. Isin orrokko kayeraatara usu dubbaankko roorara.» ");
INSERT INTO bswl_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yaannisana, «Goottakkee, Ibaaddoti koo megekkaayi durrisa beesa giranttii deenne; noonne wota lee debee mankkosessennon maraan tirin hendde» ame. ");
INSERT INTO bswl_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesuusana arootirtteen, isin dubba kadiidoon usu isinne wota gira ame. ");
INSERT INTO bswl_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesuusa daruur tos kakkobinnare goorata kakkogabbalamare goorata Iyyerusaalemi tos seeyin goosate kee. ");
INSERT INTO bswl_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Usukko t'ayise ohandaareen eserraa fare. Isona ekkaayin kadootisaro t'ayi usuun ekkaasin koo kasamaarya maaman tos tabeen. ");
INSERT INTO bswl_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Gosa ade Yesuusa Iyyerusaalemi tos seetano mankkoɂaddeesere maraan usu lakkok'op'ate. ");
INSERT INTO bswl_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yesuusakko oɂagaalssatareenna Yayik'oobana Yaannisana hikka kakkodeyaaren goorata, «Goottaa, Eelaasa goggoɂayeeseroo eleen daruurkko dagidde goggobaassoon noo goggoɂajajiinnoon feɂi sisinnatta?» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesuusa ade kambbal amere hadisere «Isin misikki ayyaanakkottaan lakkokassaan, ere kaɂibaaddo kakkoonɂemeetera neefo taɂibaaddo fayyisiinya kuwaarre baasin lakkoyo» ame. ");
INSERT INTO bswl_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Esekko keengurene maaman kakkaleenna seeteen. ");
INSERT INTO bswl_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Raadii seetaa giraan ibaaddoti koo gabbalamere, «Ati mankkoseyaatto dubba ani ku debee sesseeyinnara» ame. ");
INSERT INTO bswl_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesuusana, «Geedalaal gumbbi aba, kimbirjolnna min aba, ere kaɂibaaddo goɂameen mete kakkotabssaro duuddo lakkoɂabo» ame. ");
INSERT INTO bswl_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kakkalee ibaaddotine ade, «Indebee sessee» ame. Ibaaddotina, «Goottaa, t'ayi seeyire Aabbokkee k'amalaro» ame. ");
INSERT INTO bswl_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesuusana, «Kagoyinara kagoyero goggok'amalaroo isaaga; ati goɂameen seegudde wononnati kawaa lallabii» ame. ");
INSERT INTO bswl_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kakkalee ibaaddoti ade, «Goottaa, debee sesseettan sesseeyinara; ayesuun goɂameen abbaabayirena horaarjje minkkeekki ibaaddo nogoddaa gira goggoɂamiroo iin feɂi sisi» ame. ");
INSERT INTO bswl_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesuusa ade, «Ira otiin mat't'a abere haarddee kawochchaara ibaaddo wononnati kawaawun kadootisaro lakkoyo» ame. ");
INSERT INTO bswl_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Esekko abbaabatere Goottaa kakkalee todobaatamkko lama ibaaddo assaabegure shuume. Mankkoseetaro katamaanna banɂee dubbaa usukko goggohorehayinawun, lama lama yelere fare, ");
INSERT INTO bswl_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Haanna ame, «kafelamira kaami kamoogganya, ofelaraan adeen uc'c'arriyaan. Haanssun kaamikokki Goottaa ofelaraan takaami banɂe goggofarroon usu ebaayen. ");
INSERT INTO bswl_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Goortta seeyeen, idaad aani hiyyeeyi orro isin farnnara. ");
INSERT INTO bswl_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Korojjoo shile, goorttun keferroo arooɂabatteen; maayyonena raadii nogodda aataa arooɂadallaatteen. ");
INSERT INTO bswl_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Min kamaakkayona gottabtten t'aaddeen, nogodda hikka minuun halleeto ama. ");
INSERT INTO bswl_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nogoddaa kageelaatara ibaaddo hassee gogire, nogoddatattisin tabttowa. Goorttun nogoddatattisin isinuunwa abbaabayinatta. ");
INSERT INTO bswl_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Isinuun hore karoorsen dubba aamaanna t'amaanna usu minii hamas's'aa; kafelatara daamooza helayiin dootisara. Min kookkoo kakkalee tos aroomaramurtteen. ");
INSERT INTO bswl_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Maaɂeeti katamaa tos gotabtteenna ibaaddo isin gok'obate, kahore rooriseen aama. ");
INSERT INTO bswl_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ese hawɂaamaa ogiraan fayyiisaa, ‹Wononnati kawaa isin tos gabbalamera› ama. ");
INSERT INTO bswl_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ayesuun goɂameen katamaa too tos tabaddeene isin gok'obatanawaaten, raadii biyaddeene haa ama; ");
INSERT INTO bswl_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Luk'k'aɂoottani gutii kagiro katamaattisinkki gorra raadii binne isin seerin hurggufayinanna; ayesuun goɂameen wononnati kawaa gabbalamano hikkanii addeesa.› ");
INSERT INTO bswl_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Tamurtti arri ese katamaakko Sodoomiwuun murroo fuffudaattowa amara.» ");
INSERT INTO bswl_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Aanne kuun Koorazi! Aanne kuun Beetesayida! Isinii kafelamere baasa T'iroosnna Sidoona kafelamero lii girewa, higaanno kaganbballi sarssi sarssayireen, buluulo kakkabaayireen c'ubbokko gula gali giranewa. ");
INSERT INTO bswl_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ayesuun goɂameen Waa takkofirddiro arrii isinkko roori T'iroosnna Sidoonaan murroo isoon fuffudaattowa. ");
INSERT INTO bswl_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Teɂati K'ifirenaahoomi, daruur tos t'ok'k'i t'ok'k'i antte? Bowwa orddi innatta. ");
INSERT INTO bswl_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","«Yesuusana usukko oɂagaalssataranne isin kamaalara in maalara. Isin kak'op'annon in lakkok'op'ataro, inna kak'obannon in kafarerona lakkok'obataro.» ");
INSERT INTO bswl_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Todobaatamkko lamana geggelaataa abbaabateren, «Goottaa, megekkaayi durrisa duuddo noon ajajaame» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesuusa, «S'alaye hank'k'a aani daruurkko iyaa giraan ani dee. ");
INSERT INTO bswl_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Goortta habeessana c'ac'c'abo goggodaddarttawun, diinakkokki hunna dubbaa gutii odonnati ani isinuun sisera; isin kamirrɂa ayees koonna lakkogiro. ");
INSERT INTO bswl_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Halleewo kuwaarre kameellan ayyaanaa mankkoɂajajaamero maraan aroogeggelaatten; megekkisin daruurii mankkos'aafamero maraan usuu geggelaayen» ame. ");
INSERT INTO bswl_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Hassu goorata Yesuusa Ayyaana K'ulluukki geggelaatere, kadaruurenna kaɂulee Goottaa; Aabbokkee; hikka dubba k'arooleekkona okasaankko siyamisedde yiisun mankkotusse maraan ani ku galataara, Ii Aabbokki, hikka felin taɂidan feɂittaa leetetta. ");
INSERT INTO bswl_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«Kameen dubbaa gutii odonnati Aabbokkee dollekko iin sisamera. Adena ere ayyoyyo odo kuwaarre kamalabera kakkalee laagiro. Odo ayyoyyona ere kuwaarre, erena odo tusin feɂi kakkoonsisaro kuwaarre odo kamalabira laagiro.» ");
INSERT INTO bswl_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Usukko oɂagaalssataran tos kambbal amere isoon kale haa ame, «Isin kadeyaattan odeyaaran ilɂo osommaasameenyan. ");
INSERT INTO bswl_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kamooggan kahegeroolnna wonolaal isin kadeyaattan din dootereen lakkodeenan. Isin kamaaltteettaan maalin dootereen lakkomaaleran» ame. ");
INSERT INTO bswl_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Hikkima arri too, seera kamuse kakkasanaaye koo Yesuusa c'aafin dootere, «Kaɂagaalssisatto,» jiruu jiroommakki giri eelin «Me fella?» ame. ");
INSERT INTO bswl_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesuusana, «Seeraayi kas'aafamera meyya? Misii nabbabatta?» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ibaaddotina abbaabere, « ‹Goottaa Hedokkaa taɂammagantte wodanakko, taɂammagantte neefoo, kaɂammagame hunnakkona taɂammagantte k'ofakko geelaa, ollaattaa isiɂoottaa malee geelana› » amara ame. ");
INSERT INTO bswl_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesuusana, «Likkii abbaabttetta, atina usumalee feli, jiruu jiroommakki giri girnnatta» ame. ");
INSERT INTO bswl_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ibaaddotina isiɂootteessa k'ulluukki yelayiin dootatere, «Amiinna ollaatti ayyotta» ame. ");
INSERT INTO bswl_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesuusana usuun abbaabe, «Ibaaddoti koo Iyyerusaalemikko Iyyarkko tos dagaa giraan gene tashittaayi iyye. Sarssina k'aareen boc'c'een, goyi hiɂi gutii lugudeen seeteen. ");
INSERT INTO bswl_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tuuk'aamo koo derɂa hassu raandde metegamatto hegelddee dagaa deegure fakki ame roore. ");
INSERT INTO bswl_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Adena woyyuuti koo ese banɂe goggogeeyi deegure usuna fakki ame roore. ");
INSERT INTO bswl_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Koo samaraawiti goɂameen lukitarooraroo seetaa giraan ibaaddoti takkogiro banɂe gee. Kakkodeyaare goorata nenɂeyisate, ");
INSERT INTO bswl_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Gabbalamere meeggal gutii zayitiinna kawoyinii t'amo kibere shiye; tatteessa demeer gutii kayegure martti kakkobaraatto min geese. Eseenna karkkaree. ");
INSERT INTO bswl_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tallami arri t'agaraa lama beesere martti kakkobaraatto minkokki odomineetun sisegure, ‹Hikka ibaaddoti hadara deena. Hikkakko kanjiin ati kabbeesatto maragade ani abbaabataa kuun murrowa› ame. ");
INSERT INTO bswl_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","«Goortta, hinɂa seedkko shittoolee genee kaɂiyyero ibaaddotin ollaa kalleere eeki aani laara?» ame. ");
INSERT INTO bswl_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Seera kakkasanaayena «Kanenɂeeyisateroyolla» ame. Yesuusana, «Atina seedde usumalee feli» ame. ");
INSERT INTO bswl_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesuusana usukko oɂagaalssataranne wota raa sesseetaa giraan, maaman koo tabe. Maartta taɂamanttette too heleelttitina min kakkiseeyi usu k'op'atte; ");
INSERT INTO bswl_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","eseen Mayiraame taɂamatette abba gitte. Mayiraamena haafura maalaa tagoottaayi lukii hegelii hamas'ite gitte. ");
INSERT INTO bswl_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Maartta goɂameen felo jiinaanii goorata baasataa gitte, usu tos gabbalanttedde, «Goottaa, abbatti felo in kaalaalun lugudidde gohamas's'ito c'alɂintte diyaatta? In goggogarggaarttoo segitola» antte. ");
INSERT INTO bswl_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Goottaa goɂameen abbaabere, «Maartta, Maartta, ati kamooggan ayesuun c'annak'aamatta, jaraanjuratta. ");
INSERT INTO bswl_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kadootisara goɂameen ayees koo kaalaalya, Mayiraame taɂidan mina assaabattetta; hikkina esekko lakkoɂatamiro» ame. ");
INSERT INTO bswl_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Arri too Yesuusa banɂee tooyi ebaataa gire. Ebina goggogudisee, usukko oɂagaalssatareenkko koo, «Goottaa, Yaannisa, usukko oɂagaalssatareen ebi goggoɂagaalssisiroon atina ebi no agaalssisi» ame. ");
INSERT INTO bswl_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesuusana haa ame, «Isin goɂameen haa ama ebaayen, « ‹Aabbokkaani, K'ulluukki megekakka hakabajaame, Wononnatikka haɂemeeto. ");
INSERT INTO bswl_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kahittaaritee babokkaani hittaari noon sisi. ");
INSERT INTO bswl_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Baaskkakkani haheso ami nonna no kamiirɂero haheso goggoɂamannoo, ati baaskkaani haheso ami, c'aafiti orro no arootabsse, kameellankko no haasi kuwaarre.› » ");
INSERT INTO bswl_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Adena haa ame, «Isinkko koo kageelaatara gogire, hemeen t'eɂe usu tos seeyire kagelaatattokkee! Babo bit'e seed iin amɂayisi; ");
INSERT INTO bswl_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Saati koo raakko emetere usuu horee kakkayira babo koonna iin lakkogiro» ame ebaate goɂaminne, ");
INSERT INTO bswl_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","«Minii orro kagirona, ‹Aroorakkisse! Ufana c'ufamera, yiiskkina inne wota huddurera, goortta kiigure kuun sisin lakkodaanddaaro› ame abbaabara? ");
INSERT INTO bswl_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Usu kageelaataro laanoyi kiigure gosisanawaatena suure, ebaate mankkot'ibero maraan kadootisaro dubba sisara. ");
INSERT INTO bswl_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Haanssun ani isinne haa amara, ebaayen sisamirowa, dootayeen helattaanwa, ufana babbasayene banamirowa. ");
INSERT INTO bswl_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Aalanttina kaɂebaatara dubba atatara, kadootatarana helatara, ufa kababbasataroonna banamara. ");
INSERT INTO bswl_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Isin orro odo lee giraan ere kunɂubi goɂebaate habeessa kasisara girro? ");
INSERT INTO bswl_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Goorttun buup'p'a goɂebaate c'ac'c'abo sisara? ");
INSERT INTO bswl_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Isin ommeellan leeteen giraan yiiskisinuun kaɂidankki ilabo sisano gomalabtteen, kadaruure Aabbokkisin hayya oɂebaataraawuun Ayyaana K'ulluukkikko misii roorisi isinuun sisanawaatara!» ame. ");
INSERT INTO bswl_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Arri too Yesuusa ibaaddotikko hiɂi duudise kaɂabere battiikki ayyaana beesa gire. Battiikki ayyaana kakkobee biyaare goorata hiɂi kaduudere ibaaddoti ayeese, gosana mame. ");
INSERT INTO bswl_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kookkoo ade, «Durrisakokki woyichcha, kalleero Biɂeelzebulikkokki hunnaa durrisa beesara» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kookkoo ade c'aafin dootere daruurkko usu malaata goggotusiroo usukko dootaa gire. ");
INSERT INTO bswl_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesuusa goɂameen k'ofattisoo addeesere haa ame, «Isi isiorroo kalekalee kabeyaara wononnati dubba bayinara, isi isiɂorroo kalekalee kabeyaara min kookki ibaaddo darɂaaminara. ");
INSERT INTO bswl_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","S'alayena isi isiɂorroo kalekalee gobeete wononnatikisee misii ataara? Durrisa durrisakokki woyichcha beesara antteen ayeesattan. ");
INSERT INTO bswl_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Goortta ani durrisa kakkobeesara durrisakokki woyichchaayi gollee, yiiskisin adi ayyoo beesinnara? Haannuun iso isin gutii ofirddaaraan linnaraan. ");
INSERT INTO bswl_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ani goɂameen durrisa kakkoobeesara hunna kawaayi gollee, wononnati kawaa isin tos emeetano addeesa. ");
INSERT INTO bswl_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Kaɂatii ibaaddoti huu kajereene goggodootisaroo mowaatere minkkeessa goɂoorate, urrawo ootteessa nogoddaa ooramaraan. ");
INSERT INTO bswl_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ayesuun goɂameen kaɂatii usukko karoorara ibaaddoti emeeyire basire goɂawoode abddate kagire huu kajereenekokki mowaano furssisara. Obojaameren urrawo aatere kakkaleetun hedeedara. ");
INSERT INTO bswl_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Inneta kalleenon in diidara; inneta kakukkuyisannoonna darɂaatara. ");
INSERT INTO bswl_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Battiikki ayyaana ibaaddokko kakkobeero goorata foolssi dootataa beke kallitti banɂe kafafara; hahelannoni gohesiro, kakkobeero min tos abbaabayinara amara. ");
INSERT INTO bswl_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Goɂabbaabarona min shashshakarame kaɂekkaatero helatara. ");
INSERT INTO bswl_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Esekko abbaabate seetere kakkalee usukko aaloo kameellan durrisa todoba aate emeetara; tabere eseenna girara; hassu ibaaddotin tahoraarjjeekko roori kahaare ayees kameellan linnara.» ");
INSERT INTO bswl_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesuusa hikka ayeesaa giranttii, gosa orrokko heleelttiti too yaaye t'ok'k'issedde, «Ku tasiddetta gedeemina ati oɂiilattetta naasasso osommaasameenyan» antte. ");
INSERT INTO bswl_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Usu ade, «Osommaasameen haafura kawaa maalereen feloo ohaysaraanyaan» ame. ");
INSERT INTO bswl_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kamooggan gosa kukkumaa kakkoseetare goorata Yesuusa haa amano haggaɂabe. «Hitti alattaan tameellantta, baasakki malaata dootatta, ayesuun goɂameen kayoonasa malaata kuwaarre kakkalee malaata lakkosisaminaro. ");
INSERT INTO bswl_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Aalanttina Yoonasa kanennewe ibaaddon malaata goggolleeroon ere kaɂibaaddo hitta alattaanun malaata linnara. ");
INSERT INTO bswl_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ul kahegeletti oori wono tawaa tafirdda arri hitta alattaan wota kiidde firddinatta. Ese tasolomooni k'arumma maalin ulkotti gachokko emeettetta. Hikkima Solomoonikko karoorara hittanii gira. ");
INSERT INTO bswl_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kanennewe ibaaddo firddii tawaatti arri hitta alattaan wota kiigure iso gutii firddinnaraan. Isona kayoonasa lallabaano maaleeren c'ubbokko gula galeeran, hikkima, Yoonasakko karoorara hittanii gira. ");
INSERT INTO bswl_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Dab hank'k'ayisategure gollatatti banɂe goorttun daachcho girbbisate hegelii kakkaatara maayyona lakkogiro. Min katabara ibaaddo ifa goggoddeero bollanssoo gutii kaatara. ");
INSERT INTO bswl_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Maarkkaakki ifa ilttaatta, iltatta fayyaaleessa golleete maar dubba ifa laara, iltatta tahawɂaamatto golleete adde maarkka mugud laara. ");
INSERT INTO bswl_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Haanssun ku orroo kagira ifa mugud goggolleenoonkko isii oora. ");
INSERT INTO bswl_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Goortta maarkka dubba ifa golleenna mugud talleetetta tamaare banɂe gowaattantte, maar dubba dab waɂame kahank'k'ayisaro gitakki hank'k'aara.» ");
INSERT INTO bswl_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesuusa ayees goggogudisee, kafarasaawi ibaaddoti koo usu wota babo goggoɂaamiroo yesuusa uumate, usuna wota tabere babo aamin hamas's'ee. ");
INSERT INTO bswl_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kafarasaawi ibaaddotina Yesuusa babo aamaanokko horeene seerakisookki malee gene aalana waatti kakkodeyaare goorata saade. ");
INSERT INTO bswl_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Goottanna haa ame, gidda isin ibaaddo kafarasaawi kaburc'uk'k'onna kasaani gutii muc'c'isseen aalisattaan, orroɂoottisin goɂameen saamanonna meellaneeyi oɂammagameenyaan. ");
INSERT INTO bswl_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Isin gowoolee Kasaree kamet't'eera kaɂorronna lakkomet't'eeroya? ");
INSERT INTO bswl_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ayesuun goɂameen burc'uk'oo orronna yaalɂaayi orroo kagiro beesaddeen hiyyeessan sisa, usu goorata dubbana muc'c'i kaɂame leera. ");
INSERT INTO bswl_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Isin ibaaddo kafarasaawi adi aanne isinuun; anuugakkona t'alotekona usumalee akaakiltte dubbakkona barkkintte beesattan. Golleenna karrummii firddana Waa geelatano diidattaan. Ayesuun goɂameen aankki haɂiisooni hikka felin dootisare. ");
INSERT INTO bswl_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Isin Farasaawiil aanne isinuun Ayihuudikokki min kaɂebii kakkabajjaa barc'uma, giyaa orroo nogodda aatin dootaattan. ");
INSERT INTO bswl_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","«Ibaaddo hamalabooni gutii kakkosesseetaro kagolate k'amal aani mankkolaattan maraan, aanne isinuun.» ");
INSERT INTO bswl_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kamuse seera okasaankko koo Yesuusane, «Kaɂagaalssisatto, haa goɂayyesso noo inggamanoyya» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesuusana haa ame; «Isin seera oɂagaalsisattaanna aanne isinuun; ibaaddo sidin tadanddeennon taɂatii sidane sidisattan; isin metekkisinuun feriinna duuddo lakkodinnattaan. ");
INSERT INTO bswl_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","«Aabbojjolaalkkisin kalagadeeraan kahegerookokki k'amal mankkoɂekkaasattaan maraan, aanne isinuun. ");
INSERT INTO bswl_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Goortta abjjolaalkkisinɂi felo oɂataayisattaan atojjoolttaan. Iso kahegeroo lagadeen, isinna k'amalkisoo ekkaasattaan. ");
INSERT INTO bswl_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Haasuunna k'arumma tawaa haa antte, ‹kahegeroonna ofarameeraan isinuun farnnara, isona kookkoo lagadinanan, kakkaleenna horoorenaan,› ");
INSERT INTO bswl_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Haanssun hitta alattaan alami takkomet'amerokko haggaɂabere kaɂubatero, kahegerookokki iigi dubbaan tahoosaminnattotta. ");
INSERT INTO bswl_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kaɂaabeela Iigikko haggaɂabere, kajaarssona min kaɂebii orroo kaɂubatero kazakkiraasa iigi taageeroo dootamara, Ii amara, hitti alattaan hikkanuun tahoosamattotta. ");
INSERT INTO bswl_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Isin kamuse seera okassaan aanne isinuun, kamalabano ufa kakkobbanaraan k'ulffi basseen aattettan, isin metekkisinuun lakkotabtteettan, otabnnaraanna tirtteettaan.» ");
INSERT INTO bswl_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesuusa esekko kakkobeyaare goorata, seera kamuse oɂagaalssisareeninna Farasaawi gomeellan diidaanna hoosinii hoosataa jeejisano haggaɂabeen. ");
INSERT INTO bswl_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Hiɂitteessakko kabiyaaro haafuraa usu abin gaadaa gireen. ");
INSERT INTO bswl_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Hassu goorata kuma kamoogganii katootamira gosa isi isi taadaddararo geegin kukku ame giraan, Yesuusa usukko oɂagaalssataraawuun haa amano haggaɂabe; «Farasaawilkotti meellanekko isiɂoottisin oorayeen; hikkina ifissaaddannatiya. ");
INSERT INTO bswl_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kamutoon kagolatera, kaɂaddeesamoon kasiyamera koonna laagiro. ");
INSERT INTO bswl_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Haanssun isin mugud kaɂayeesattan dubba ifaa malssaminara. Ilffinnii orroo nebee markkaa kaɂayeessettaan diidaabi segaaminara. ");
INSERT INTO bswl_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Ogeelaataroɂootte, ani haa amara, soo kalagadaro esekko abbaabayi adi koonna yelin kadanddeenonkko arooɂabssatteen. ");
INSERT INTO bswl_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ayesuun goɂameen isin abssayin kadootisaro ani tusinara, kakkolagade goorata tabbaanon eleenii lugudin odonnati kaɂabo Waa abssayeen. Ii, usu abssayeen amara. ");
INSERT INTO bswl_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kimbirjjool kenno santtimii tooyi ladaddalamarolla? Halleewo kuwaarre esekko too duuddo Waayi dollee lakkoɂillottamatto. ");
INSERT INTO bswl_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mete kakkisinkokki fiit'a dubba katootameya, goortta arooɂabssatteen. Kamooggan kimbirjolkko isin tarooratto laɂo abttaan. ");
INSERT INTO bswl_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Yesuusana ani isinne haa amara, ibaaddo horee iin kaɂatotaaro dubbaan ere kaɂibaaddo ade erggichcha kawaa horee usuun atotinara. ");
INSERT INTO bswl_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ibaaddo horee in kakkakatarana erggichcha kawaa horee kakkaaminara. ");
INSERT INTO bswl_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ere kaɂibaaddo gutii kayeraasiro haafura kaɂayeesara dubba haheso amamara, Ayyaana K'ulluukki kahabaarara ade haheso lakkoɂamamaro. ");
INSERT INTO bswl_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Ibaaddo isin abire Ayihuudikokki min kaɂebii mooti tonssa odonnati kaɂabo tos isin kakkogeese goorata, misii goorttun me ami abbaabinattaan arooyaaddeen. ");
INSERT INTO bswl_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Hassu goorata Ayyaana K'ulluukki isin ayeesin kadootisaro agaalssisinara.» ");
INSERT INTO bswl_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Gosa orrokko ibaaddoti koo, «Kaɂagaalssisatto, abbikki iyyeen eella goggohedeediroo segii» ame. ");
INSERT INTO bswl_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesuusana, «Ati ibaaddoti, in isin gutii kafirddaarona eella kahedeedaro kayelera ayyoyya?» ame. ");
INSERT INTO bswl_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Adena, «Giri kaɂibaaddo durumma jiinaan kaɂukumamero mankkoleeno maraan, isiiɂoorayeen; gap'igap'aano dubbakko isiiɂoorayeen» ame. ");
INSERT INTO bswl_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Debeenna Yesuusa haa ame masuussayi segee, «iraa kaami aaloo kakkondubamere dureessati koo gire. ");
INSERT INTO bswl_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Hikki ibaaddotina, kaami takkokukkuyisara banɂe mankkoginnoon maraan ‹Ani misi yella? Ame wodanatteessaa hede.› ");
INSERT INTO bswl_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","«Haanna ame, ‹hikkamalee yelinnara kagiro gootaraal basigure kakkalee kabalɂaan gootaraal madaarnnara. Usuu gootaraalii kaamina urrawoɂootte dubba kukkuyisayinara. ");
INSERT INTO bswl_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Neefotteenne, neefottee, gees kamoogganun talleeto durumma kuun kukkuyisera, goortta foolssa, aami, t'ami, geggelaa› » aminara. ");
INSERT INTO bswl_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","«Waa ade, ‹Ati gowwaa! Neefotta hittameen ani kukko aatin dootara. Goortta ussun kakukkuyisattetta ayyoon leera?› » ame. ");
INSERT INTO bswl_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Haanssun Yesuusa, «Ussun durumma kakukkuysatara ayesuun goɂameen waayi dollee dureessa kalleenon ibaaddotikotti gachcho hikkamaleetta» ame. ");
INSERT INTO bswl_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Esekkona Yesuusa usukko oɂagaalssataranne haa ame, haanssun ani isinne haa amara, isin girikkisinun me aaminanna, goorttun maarkisinuun me sarssayinanna ami arooyaaddeen. ");
INSERT INTO bswl_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Giri babokko maarnna sarssikko roorara. ");
INSERT INTO bswl_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","K'uurrajjool diyaa lakkowut'atanaan, lakkotagataran, takkokukkuyisataraan goorttun gootaraa lakkoɂabaan, Waa goɂameen iso aamisara. Isinna addeen kimbirjolkko aaloo lakkoroorattaanya? ");
INSERT INTO bswl_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Golleenna isinkko yaadegure geeskakkessa gutii arri too adayin kadaanddaara ayyoyya? ");
INSERT INTO bswl_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Goortta hikka kic'c'arkki ayees duuddo felin kadanddeenoon golleeten ayees kakkaleetun muun yaadattaan? ");
INSERT INTO bswl_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","«Alla daraaral misii jiinataraan diyaa, lakkodaafuranan, lakkosuk'k'aataran, ayesuun goɂameen ani isinne haa amara, wono Solomooni duuddo hassu kabajaal dubbakko koo aani lakkosarssatero. ");
INSERT INTO bswl_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Goortta Waa hittaari mutere geebbari eleenii tos kashafaro kadiida eesii haa kasarsisaro gollee, isin ammano okkonhank'atera, isin goɂameen misii roorisi sarssisana waatara? ");
INSERT INTO bswl_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Haanssun me aaminanna me t'aminanna amaa dootataa wodanattisin arooyaado. ");
INSERT INTO bswl_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Hikka goɂameen kaɂayizaab gosa dubba dootatara. Kadaruure Aabbokkisin hikki dubba isinuun kadootisaro laano kasowa. ");
INSERT INTO bswl_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ayesuun goɂameen wononnati kawaa dootayeen, hikki dubbana isinuun adami sisaminara. ");
INSERT INTO bswl_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Isin gosa uc'c'ar olleetettaan wononnati isinuun sisin Aabbokkisintti taɂidanee feɂitta arooɂabssatteen. ");
INSERT INTO bswl_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Isinuun kagiro daddaladeen hiyyeessaalun sisa, heto takkohetooni, fiino takkoɂaamoni kaddoɂannon shile ogudannon urrawo daruurii kukkuyisayeen. ");
INSERT INTO bswl_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Wodanattisin, urrawo oottisin takkogiraan banɂee giratta. ");
INSERT INTO bswl_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Goortta mowayeeddeen ekkaasayen; dabkkisin kahank'aye halleewo. ");
INSERT INTO bswl_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Goottakiso min kahaassinokko taa abbaabaroon oɂoorataranna emeeyire ufa gobabbase goorsewa banin kaɂekkaasatero ibaaddo aani laa. ");
INSERT INTO bswl_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Goottakkiso kakkoɂemeetaro goorata nabbaaden giraan usu ohelara ohandaaran iso osommaasameenyan. Ani rumminaa amara, goottakkiso ekkaasate mowaatere, aamoonna hamas'isara, gabbalamena aamisara. ");
INSERT INTO bswl_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Hemeen t'eɂena leere lukkale kahoree owaa giraan emeeyire usumalee nabbaaden ogiraan usu ohelara, hanɂu ohandaaran iso osommaasameenyan. ");
INSERT INTO bswl_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Hikka ada addeesa; heto eeki goorata emeeyinnatto odomine addeesi girewa, minkkeessa oshamaa giraan c'alɂi ami lakkodiyaare. ");
INSERT INTO bswl_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Isinna ekkaasayendden oorayeen; ere kaɂibaaddo isin kakkoshaadongittaan goorataa emeeyinnara.» ");
INSERT INTO bswl_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","P'et'iroosana, «Goottaa! Hikka masuussa kakkoonɂayeesatta no oolaalunya muu dubbaawunna addeddeya?» ame. ");
INSERT INTO bswl_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Goottakeessana haa ame usuun abbaabe, «Goortta babokkisoo isoon kakkodootisaro goorataa goggosisiroo goottaa kaminee ibaaddo gutii kashuumera kaɂabddamenna k'arookki hadara kaɂaba ayyoyya? ");
INSERT INTO bswl_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Goottaa mankkoseeterokko abbaabayi kakkoɂemeero goorata goggoɂajajaamerokki malee felaa kamute usu misikki kasommaasameya! ");
INSERT INTO bswl_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ani rumminaa amara, goottaakkeessa hassu kahandaaro ogiraan urrawo dubbaa gutii usu shuuminara. ");
INSERT INTO bswl_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ayesuun goɂameen aankki kadaanddaara, ‹Goottakki saami lakkoɂemeeyinaro, adallaayinara› ami gohedenna babbaarnna heleelnna ohandaaran goboc'ee adena goggogeelatee aamano t'amanona setaano gohaggaɂabe, ");
INSERT INTO bswl_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Hassu kahandaarokokki goottaa takkoshaadamon arrina takkohedannon goorata derɂa emeeyinara. Aaloo usu murrisinara, hit'atteessana Waa kaɂammanon ibaaddone wota yelinnara. ");
INSERT INTO bswl_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Tagootta feɂi addeesa giraan kaɂekkaasannoonna feɂiteessana kafeloon hassu kahandaara usu gomeellan murrisaminara, ");
INSERT INTO bswl_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ayesuun goɂameen hikka kaɂaddeesoonna kamurrisisaro gitakki kaalaal goyele kahandaara usu abaraanttii murrisaminara. Kamooggan kasisamerokko kamooggan dootamara, tanjiin hadara kaɂataterokko tanjiin ooramatta. ");
INSERT INTO bswl_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Ani kakkoonɂemeeyera ulii gutii eleen absisiinya, giddawa gobeebete misimisii lakkogeelayinare! ");
INSERT INTO bswl_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ayesuun goɂameen ani kat'ammak'aaminaro kakkalee t'ink'ata karakkoo aba, taagudaroo geegin misii lakkoyaadere? ");
INSERT INTO bswl_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ulii gutii nogodda keeniin kaɂemeeyero aani laara? Lakkoyo. Ani kakkoonɂemeeyera kalekalee beesinya. ");
INSERT INTO bswl_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Giddakko haggaɂabere min koo orroo isi isiɂorroo kalekaleekki ibaaddo girnnara, lama seed gutii seendda lama gutii kiigureen kalekalee binnaraan. ");
INSERT INTO bswl_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Odona ere babbaartiti gutii ere babbaartitina odokkeessa gutii Aanna ere deeleeltiti gutii, ere deeleeltitina Aayettisee gutii, soddo ooriɂerettisee gutii ooriɂerena soddottisee gutii kiigureen kalekalee binnanaan.» ");
INSERT INTO bswl_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Adena gosane Yesuusa haa ame, «Duumanchcha mina taɂiyaankko biyaa godeetaan goorsewa, ‹Idaamo ubayinara amattaan,› usumaleenna laara. ");
INSERT INTO bswl_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Logodo gokkeero, ‹Ul fuurssaara amattaan,› usumaleenna laara. ");
INSERT INTO bswl_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Isin ifissaaddolee, tadaruurenna taɂulee middi addeesano kassaanwa, hayya hikka kagiddanee gees addeesano misii waatteen? ");
INSERT INTO bswl_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Isin metekisinii likkii kalleero muun firddaanawaattaan? ");
INSERT INTO bswl_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Baragaraakkaanneta daanna horee aallin goseette ganaa raadii giraan wogarin is's'aami, goorttun usu natteere daanna tos geesinara, daannanna Poolisiin ku sisara, poolisina minkashaano tabsinara. ");
INSERT INTO bswl_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Muraa muri taagudissoo esekko lakkobinnatto ame.» ");
INSERT INTO bswl_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Usu goorata ibaaddo Yesuusa tos emeetegure, P'ilaat'oosa Iigikisoo jaarssokisonne wota mankkolederaan maraan kagaliila ibaaddokokki gara kaɂayeesere ibaaddo esee gire. ");
INSERT INTO bswl_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesuusana haa ame isoon abbaabe, «Hayya hinɂi ogaliila ibaaddojja hikki abboosa iso kakkongeegera kakkalee kagaliila ibaaddokko rooreene c'ubbaaleessa mankkoleen maraan aani laara? ");
INSERT INTO bswl_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Lakkoyo ani isinuun haa amara, c'ubbokko gula galanagowaatten dubbana hikkamalee bayinattan. ");
INSERT INTO bswl_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Goorttun ade ul kaselihoomii gimbbe diigamere kagoyere ibaaddo tomonkko siddeed Iyyerusaalemi kagiro ibaaddo dubbaankko c'ubbaaleessa mankkoleen maraan aani laara? ");
INSERT INTO bswl_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Lakkoyo, ani isinuun haa amara, c'ubbokko gula galanagowaatten dubbana hikkamalee bayinattan.» ");
INSERT INTO bswl_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Adena Yesuusa haa amaa hikka masuussa ayeese, «Ibaaddoti koowun ira kawoyinikotti banɂee kaɂabbaramere koo kabalasi gaattiti gire. Usuna il usukko dootayiin emetere koonna lakkohelatere. ");
INSERT INTO bswl_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kawoyinii akaakiltte kafelarana, ‹Hikkima, il dootayi helayiin gees seed hikka gaa kabalasi tos ani emeeyere il lakkohelayero, haanssun goosi, mewuun errekko unjjane adda t'uuk'atta?› ame. ");
INSERT INTO bswl_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","‹Kafelarena ade; Goottaa! Maraamurisi taa k'ooshironna kosii taakibiroo hikka gees kaalaalun isaagi. ");
INSERT INTO bswl_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Gees kaɂemeetaro taageetoo godubantte kaɂidankkiya; goorttun goosinnatta› » ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesuusa Ayihuudin tafoolssi arri koo Ayihuudikokki min kaɂebii agaalssisa gire. ");
INSERT INTO bswl_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Eseenna battiikki ayyaanayi gees tomonkko siddeed dubba zuurɂo tabeessette heleelttiti too gitte. Eseenna zuurɂo beesanokko kakkeeyi duuddo t'ok'k'i amin lakkodaanddeetette. ");
INSERT INTO bswl_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesuusana ese kakkodeyaare goorata uumegure, «Abbattee, hawɂaamikaakko fayyiitetta» ame. ");
INSERT INTO bswl_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Genetteessa esee gutii kaye, esena goorsewa tukkul aallite, Waanna galatiite. ");
INSERT INTO bswl_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kaɂayihuudi min kaɂebikokki woyichcha goɂameen, Yesuusa Ayihuudin tafoossi arri ese mankkofayyiise maraan amaraatere gosane, «Felo felayin takkodootisara arri lewo gittowa. Haanssun iso arrijjoolii emeeyendden fayyaa kuwaarre tafoolssi arri lakkoyo» ame. ");
INSERT INTO bswl_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Goottanna abbaabere, «Isin ifissaaddolee, isin orrokko ibaaddoti koo aar goorttun demeer tafoolssi arri awudkko furatere beke t'amisayin lakkodagssataroya? ");
INSERT INTO bswl_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Hayya, hitti heleelttiti taɂabraame ere leete giraan gees tomonkko siddeed dubbaa s'alayee shishantte kakkogittekko hikka shaanokko tafoolssi arri furamiin lakkodootisattoya?» ame. ");
INSERT INTO bswl_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Hikka kakkoɂayeesare goorata usu odiidareen dubba mulleen, gosa dubbana ade usu ofelero osaadamiraan felo dubbana geggelaate. ");
INSERT INTO bswl_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Esekkona Yesuusa; «Wononnati kawaa me aani laara? Menne wota masuussira? ");
INSERT INTO bswl_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ibaaddoti koo geesere iraa orroo tawut'ero il tasinafic'c'i aani laatta; jiinatte gaa leete; guuntte kabuubara kimbirjoolnna ballaalkkise gutii hamas's'ee» ame. ");
INSERT INTO bswl_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Adena Yesuusa; «Wononnati kawaa menne wota masuussira? ");
INSERT INTO bswl_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Heleelttiti too aatede kaami raattoo taa mulaamiroo t'aamme tanjiinne wota talelleddetto irshoo aani laatta ame.» ");
INSERT INTO bswl_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Esekko abbaabatere Yesuusa Iyyerusaalemi seetaa giraan, orromare takkoroorare katamaaliinna maamanjool agaalssise rooraa gire. ");
INSERT INTO bswl_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ibaaddoti koo gabbalamere, «Goottaa; ofayyaraan ibaaddojja uc'c'arri oolaalyaan?» Ame. Usuna abbaabere haa ame; ");
INSERT INTO bswl_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Gooc'a kaɂuubaanne tabin is'aama; ani haa amara; kamooggan tabin dootatara; ayesuun goɂameen isoon lakkolleero; ");
INSERT INTO bswl_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Odomine kigure gooc'a kakkoc'ufate goorata sarre aalliddeene, ‹Goottaa; ufa noon banina› amaa babbasatano haggaɂabnnattaan. Usu goɂameen, ‹Isin ayyosttaan haggekko emetteettaan› ani isin lakkokaso! Ami isinuun abbaabinnara. ");
INSERT INTO bswl_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Isinna, ‹Noo ku wota raattoo aaminenna, t'aminenna, songooninna no agaalssisetta aminnattaan.› ");
INSERT INTO bswl_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","«Usuna, isin ayyosttaanna haggekko emetteettaan ‹Ani isin lakkokaso, isin omeellan dubba inkko fakkima› aminara. ");
INSERT INTO bswl_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Abraamene, Yissaak'ane Yayik'oobanee, kahegeroolnne dubba wononnati kawaa orroo goddeeten, isin adi sarddi shafamiddeen gohesseen hassu goorata oottanna ilkko fooc'ano isinuun leera. ");
INSERT INTO bswl_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ibaaddo mina tabiyaankko, mina taɂiyaankko, elekkona hegelkko emeeyigure wononnati kawaayi aamoon hamas'iinnara. ");
INSERT INTO bswl_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Haanssun, kahaare hore hayinara, kahoreenna, haar hayinara.» ");
INSERT INTO bswl_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Hassu goorata ibaaddo kafarasaawikko kookkoo emetere, «Herodoosa ku lagadin mankkodootaro maraan kigudde hittakko see» ame. ");
INSERT INTO bswl_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesuusa ade isone, «Seeyenguddeene hassu k'arumma tadaaɂeer kaɂabo geedalatiwuun, hikkima, ‹Ani hittarina geebbarina durrisa beesinnara, dhukkubaleessalna fayyisinara, arri taseedinna halchchakkee tos geeginara› amara ama segaa ame. ");
INSERT INTO bswl_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Halleewo kuwaarre kahegeroo Iyyerusaalemi orroo kuwaarre maaggeenna goyin lakkodootisaro hittaari, geebbarina gaabbaru eserraa tos sesseettan horeddinnara. ");
INSERT INTO bswl_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Iyyerusaalemi, Iyyerusaalemi, kahegeroo talagadatta, ku tos ofarameeraanna eɂemoo taɂeeggatta! Lukkale c'uc'utekkakkisee baalalloɂoottiseeyi hegelii goggokukkuyisattoo malee ani yiiskakkaa kukkuyisin miyyaa gale doote, isin addeene laa antteen. ");
INSERT INTO bswl_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Haanssun, minkkisin ona lee hesera. Ani haa amara, ‹Mege kagoottayi kaɂemeeyinara usu kasommaasameya haa taɂanttaan arri taageetoo hittakko horenbbaan goortta in lakkodinnattaan› » ame. ");
INSERT INTO bswl_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ayihuudin tafoolssi arri tooyi, Yesuusa babo aamin kafarasaawi woyichchaalkko koo kalleere ibaaddotikokki min tos kakkotabare goorata, ibaaddo usuu gutii maraamurisaa gire. ");
INSERT INTO bswl_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Eseenna maarkkokki duddubbeeli kaɂabbosamare ibaaddoti koo usu hore gire. ");
INSERT INTO bswl_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesuusana, seera oɂagaalsisarannena Farasaawilnne, «Ayihuudin tafoolssi arri dhukkubaleessaal fayyiisano dootisara muu lakkodootisaroya?» ame iso hoosate. ");
INSERT INTO bswl_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Isona adeen c'alɂi ameen. Usuna ibaaddoti abe fayyisere galise. ");
INSERT INTO bswl_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Adena, «Isinkko koo erekkeessa goorttun aarkkeessa tafoolssi arri gumbbi orroddi goɂiyye saami kabeesannon ayyoyya?» ame. ");
INSERT INTO bswl_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Isona hikkanun toonna taɂami abbaabraan waateen. ");
INSERT INTO bswl_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesuusa aamoon oɂuumameraan takabaja banɂe oɂassaabataraan deegure, haa ama hikka masuussaa isoon segee. ");
INSERT INTO bswl_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Ibaaddoti koo min kahaassinoo aamoon ku goɂuume, takabajaa banɂee aroohamas's'ite, kabajaayi kukko kanjiinkki ibaaddoti kaɂuumamero gollee, ");
INSERT INTO bswl_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Isin lama dubbana kaɂuumatere emeeyire, banɂee ‹Hikka ibaaddotin gafarina› aminara; atina mullidde hussi taɂantte banɂee dagi hamas's'inatta. ");
INSERT INTO bswl_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ayesuun goɂameen ati kakkoɂuumantte goorata hussi taɂantte banɂee diyaadde hamas's'ii, ku kaɂuumatera emeeyire, ‹Ani kageelaatarokkee, koyi hittanii t'ok'k'i ami hamas's'i aminara,› Atina hassu goorata raattoo aamoon kahamas'eero ibaaddo dubba hore kabajaminnatta. ");
INSERT INTO bswl_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Aalanttina isiɂootteessa kat'ok'k'i t'ok'k'iɂisatara dubba hussi aminara. Isiɂootteessa hussi hussisatara dubba t'ok'k'i amara.» ");
INSERT INTO bswl_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesuusana kaɂuumatero ibaaddotine ade, «Kita kaɂarri goorttun kita kahemeene aamo kakkoɂekkaasatto goorata ofelttetto goggomarttisonkona amɂaattaa kuun goggoɂabbaabonkko, ku kageelaatarokko goorttun abbilaalttaa fallikkaa goorttun dureessa ollaattaa arooɂuumatte. ");
INSERT INTO bswl_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ayesuun goɂameen marttina kakkoɂekkaasatte goorata hiyyeessal oɂeesaraan, naafaleessana ilɂo odeyaannon uumi. ");
INSERT INTO bswl_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ati sommaasanttowa, hinɂi amɂaa abbaabin odanddeenon mankkolleen maraan, k'ulloolekokki keyaanoyi amɂaattaa abbaabattowa» ame. ");
INSERT INTO bswl_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesuusane wota aamoon ohamas's'eeran orrokko koo hikka maalere «Wononnati kawaayi gabbalamere babokko kaɂaamara kasommaasameya» ame. ");
INSERT INTO bswl_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesuusa ade, «Ibaaddoti koo oɂatii marttina ekkaasatere kamooggan ibaaddo uume. ");
INSERT INTO bswl_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kaɂaamo gooratana kakkogeyaare goorata taɂuumanttetto marttijjoolnne, ‹Hikkima, kaɂameen dubbana ekkaatera koyeen› ami goggoɂuumiroon kahandaarokkeessa fare. ");
INSERT INTO bswl_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","«Ayesuun goɂameen dubbana tattisoo tattisoo aalantti met't'aano haggaɂabeen, kahoree ganaa gidda ‹Erre mankkoɂiminayero maraan seeyire diyaatano dootisara, maganne, iin shaaga yelina› ame. ");
INSERT INTO bswl_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","«Kakkaleenna, ‹Ani aarar kado ken iminayera; iso abi dinnara maganne shaaga iin yelina› ame. ");
INSERT INTO bswl_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","«Kakkaleenna ade, ‹Ani ganaa kamashaashee mankkollee maraan emeeyin lakkodaanddeero ame.› ");
INSERT INTO bswl_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«Kahandaarena abbaabate emetere woyichchakeessawun segee. Hassu goorata kaminee goottaa amaraatere kahandaarene, ‹Saamidde raa kabalɂaanii kagirona kaɂuubaan kagiro dubbaa bee, hiyyeessalnna naafaleessajjool, Iilɂo kadeyaannonna kaɂeesaro hittarraa tabsi› ame. ");
INSERT INTO bswl_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«Kahandaarena, ‹Goottakkee; ati kaɂajajiitette dubba gudisera, giddanna ade banɂe gittowa› ame. ");
INSERT INTO bswl_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","«Goottanna kahandaarene, raa kagosa tonssa raa kak'ama tos beena, ‹Minkkina goggoɂammagamiroon kaheltte dubba hunnaa keeni gudde tabssina. ");
INSERT INTO bswl_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Aankki uumame giraan kadiidero ibaaddokko aamokkee hiɂi kaɂabnara koonna lakkogiro!› ame.» ");
INSERT INTO bswl_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kamooggan gosa raattoo sesseetaa giraan, Yesuusa kambbal amere haa ame. ");
INSERT INTO bswl_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«In tos kaɂemeetara dubba Aabbokkeessana Aayetteessa ooritteessana yiiskkeessa, abbilaaltteessana abbalaaltteessa, girikkeessa duuddo hahesooni inkko roorisate kageelaatara, indebee kasessetaro liin lakkodaanddaaro. ");
INSERT INTO bswl_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mask'aliitteessa sidayire indebee kasessennon inkko kaɂagaalssataro liin lakkodaanddaaro. ");
INSERT INTO bswl_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«Isin orrokko ibaaddoti koo min kaginbbe madaarayin godootate, gudisiin daanddaanonna daanddiwaatti t'aye eeggitakki maragade dootisaro hamas's'iire dookki kahedannon ayyoya? ");
INSERT INTO bswl_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ukum lugudayigure gussayiin gowaate, kaddee dubba usu k'ac'c'ifatara. ");
INSERT INTO bswl_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Haanna amaraan, ‹Hikki ibaaddoti min madaarayiin abategure, gussayiin ade waate› amaraan. ");
INSERT INTO bswl_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«Goorttun wono koo wono kakkalee wota jereen shafayiin kakkokeero goorata, kuma tomon wotaadaral tabsisere kaɂemeetaro wono kakkalee kuma lamaattan wotaadara wota jereen shafayiin daanddaanokkokki hamas's'ire kamakkaroon ayyoyya? ");
INSERT INTO bswl_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Shafayiin kadaanddeenon gollee, kakkalee wono ganaa ebbaa giraan, handdaa ogeegiisaraan faregure wogarssi hoosatara. ");
INSERT INTO bswl_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Usumaleenna, isin orrokko maayyona kakkeessa kaɂabo dubba kaɂiisoon, inkko kaɂagaalssataro liin lakkodaanddaaro.» ");
INSERT INTO bswl_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Essebo taɂidanttitta, essebo onɂomoonje gowaattantte adi misii abbaabayi taɂesseboo onɂomoonje girin daanddaatta? ");
INSERT INTO bswl_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Uluun leere madabbarawuun laɂo tasisoon laanoyi sarddi shafaminatta. «Kamaalara nebe kaɂaba hamaalo.» ");
INSERT INTO bswl_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Arri too omooggan k'arat'a okukkuyisareenna c'ubbaaliyeel dubba Yesuusakko agaalssisikkeessa maalin usu tos kukkumeen. ");
INSERT INTO bswl_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ibaaddo kafarasaawinna seera kamuse oɂagaalssisaran, «Hikki ibaaddoti c'ubbaaliyeel k'op'atara, isonetana aamara» amaa gumggumeen. ");
INSERT INTO bswl_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesuusana haa amaa hikka masuussa isoon segee. ");
INSERT INTO bswl_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Isin orrokko koowun idaad bool gogire usukkona koo gobaye, saagaalttamikko saagaal diidaa lugudigure kabayero taahelaroo dootayiin kanbeenoon ayyoyya? ");
INSERT INTO bswl_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kakkohelate gooratana geggelaataa haankkeessayi sidatere, ");
INSERT INTO bswl_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Minkkeessa tos abbaabatara. Usu ogeelaatarona ollaatteessa raattoo uumegure, ‹Kabayero idaadokkee helayera inne wota geggelaayen› amara. ");
INSERT INTO bswl_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ani isinne haa amara, hikkamalee no c'ubbo lakkoɂabnno k'ullooleenna oɂamaraan saagalttamkko saagalkko c'ubbokko kagula galaro c'ubbaaleessa kooyi daruurii geggeloo oɂatii linnaraan.» ");
INSERT INTO bswl_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Debeenna t'agaraa tomon taɂabanayite heleelttiti t'agaraa tomonkko too kakkobaatte goorata, taa helattoo dab hank'k'ayisatedde, min shakaarattedde, aaloo tadooton heleelttiti ayyotta? ");
INSERT INTO bswl_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kakkohelatte goorata ese ogeelaataraanna ollaattisenee raattoo uumattedde, ‹Tabatette t'agaraa ani helayera iinne wota geggelaayen› amatta. ");
INSERT INTO bswl_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ani haa amara, usumalee c'ubbokko kagula galaro c'ubbaalessaati kooyi erggichcha kawaayi horee geggeloo linnaraan» ame. ");
INSERT INTO bswl_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Adena Yesuusa haa ame, «Ibaaddoti koowun yiis lama gire. ");
INSERT INTO bswl_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Isokkona ere kic'c'ar Aabbokkeessane, ‹Aabbokkee, durummattaakko k'ooba iin sisi› ame. Aabbokkeessana durummatteessakko yiiskkeessawun hedeede. ");
INSERT INTO bswl_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","«Arri tanjiin haɂadallaannooni, ere kic'c'ar k'oobakkeessa dubba kukkuyisatere ul kaɂeer seete, eseenna goggogeelatee urrawoɂoottessa adda darɂaate. ");
INSERT INTO bswl_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Usuna kaɂabo dubba kakkogussatare goorata, usu ul dubbaa kaɂatii uɂi lee, rakkatano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Haanssun hassu ulkokki ibaaddoti koo tos gabbalame, ibaaddotina booyyee usu goggofoofiroo ira fare. ");
INSERT INTO bswl_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Booyyeel kaɂaamaro dink'k'ena aamin halchchaa gire, ayesuun goɂameen hikka usuun kasisira ibaaddo koonna lakkogire. ");
INSERT INTO bswl_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","«Wodana usuun kakkoɂabbaabatte goorata ade haa ame, ‹Aabbokkeewuun kafelaro ibaaddo miyyaakko babo hese kamadarraamara? Ani ade hittanii uɂii goyin gabbalamera! ");
INSERT INTO bswl_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kiigure Aabbokkee, tos seeyire, haa aminara, Aabbokkee, Waayinna ku horee ani baasera. ");
INSERT INTO bswl_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Goortta erekkaa amami uumamin lakkodootisaro. Minii hamas's'eeren ofelaraankko koo aani in tootiina aminara.› ");
INSERT INTO bswl_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Haanssunna keegure Aabbokkeessa tos seete. «Ayesuun goɂameen usu ganaa ebbaa giraan, Aabbokkeessa usu deegure nenɂeyisate, usu tonssa tiyaa seetegure kabalate abate anggate. ");
INSERT INTO bswl_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","«Unnuna, ‹Aabbokkee, Waayinna ku horee ani baasera, goortta erekkaa amami uumamin lakkodootisaro ame.› ");
INSERT INTO bswl_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","«Aabbokkeessana goɂameen usuun ohandaareenne haa ame, ‹Saama dubbaankkona kaɂidan kalleero sarssi keenaddeen usu sarssisa, feruun firaantta, lukuun keferroo tabsa. ");
INSERT INTO bswl_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kak'aabaan kurkkuraa kor keenaddeene enɂaa, aamina, geggelaanna. ");
INSERT INTO bswl_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Hikki unnukki goyera ame ani gire, gidda goɂameen neefo helatera, baye gire, helamera.› Esekko geggelaatano haggaɂabeen. ");
INSERT INTO bswl_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Usu goorata ere kanjiin iraa gire, hassekkona abbaabate min tos kakkogabbalamare goorata, tadudduroonna tamadarri yaaye maale. ");
INSERT INTO bswl_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Usuna ohandaareenkko koo uumere meya kamisileera? Ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kahandaarena, ‹Abbikka gamatera,› nogoddanna fayyaaleessa lee mankkogamatero maraan ‹Aabbokka kurkkuraakki kor kak'aabaan usuun enɂeera› ame. ");
INSERT INTO bswl_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«Kanjiin abbikkeessa amaraatere, mininna tabin lakkodootero, Aabbokkeessana sar beegure usu min goggotabroo ebaate. ");
INSERT INTO bswl_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Usu goɂameen abbaabe Aabbokkeessane haa ame, ‹Hikka, gitakki gees diyyii aani ani kuun handdayera, ajajaakkaakko koonna ade lakkohank'isero, ati goɂameen ani kageelaataro wota goggogeggelaroo c'ibaare too suure lakkosissetto. ");
INSERT INTO bswl_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ayesuun goɂameen hikki unnu urrawoɂoottaa sharmmut'aalnne wota darɂaate baasategure goɂemeete, kak'aabaan kurkkuraa kor usuun enɂiite.› ");
INSERT INTO bswl_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","«Aabbokkeessana usuun haa ame, ‹Unnukkee,› ati arggetto inne wota gitta, kakkee kalleera dubba kakkaayya. ");
INSERT INTO bswl_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Hikki abbikkakka ade goyera ame gire, neefo helatera, baye gire helamera; haanssun aaloo geggelaayinna dootisara.» ");
INSERT INTO bswl_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesuusa usukko oɂagaalssataranne haa ame, «Dureessakki ibaaddoti koo hadara kaɂabo ibaaddoti koo abanaaye, hikki odo hadara dureessatikonɂi urrawo darɂaanokkokki odu hikka dureessati geete. ");
INSERT INTO bswl_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Haanssun dureessati odo hadaraa uumsisigure, ‹Hikki ani kamaalara meyya? Goortta ati iin odo hadaraa liin mankkodaanddeennon maraan, ati obariisatte urrawoɂootti kakkotootaminaraan mazggaba iin haggasisi› ame. ");
INSERT INTO bswl_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","«Hadara kaɂabanaayekkina wodanatteessa haa ame, ‹Goottakakki ani hadara mankkoɂabokko indagisinara amara, otayiin hunna lakkoɂabo; ebaatano ade in mulliisara, haanssun misi yella? ");
INSERT INTO bswl_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ani hadara mankkoɂabokko kaɂiggilssame gollee ibaaddo minkakkisooyi in goggok'op'aroo ani kayelnnaro kasowa.› ");
INSERT INTO bswl_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«Haanssun tagootta anza kaɂabo ibaaddo mete metee uumegure, kahoraarjjee ibaaddotina ‹Goottakkeetti anza eeggitatti abtta?› ame. ");
INSERT INTO bswl_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","« ‹Usuna, zayitii toossa bool aba ame.› Hadara kaɂabanaayekkina kawulii worak'atakkaa hikkima ata, saami hamas's'iidde ‹Toossa konttom ami s'aafi ame.› ");
INSERT INTO bswl_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","«Esekkona kakkaleenne, ‹Atidde miyyaa abtta?› ame. Usuna, ‹Guul konttom darggammaa aba ame.› Hadara kaɂabanaayekkina, ‹taɂamɂaaye dabdaabbettaa ahɂaay guul afarttam› ami s'aafi ame. ");
INSERT INTO bswl_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","«Goottakeessana ammano kakkoonhank'atero hadara kaɂabo k'arummatteessawun saadise, hikkina ibaaddo kawaakko rooreen hikka alamikokki ibaaddo barisano oɂalamii k'aroolee laano tusara. ");
INSERT INTO bswl_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Haanssun ani isinuun haa amara, hikka alamikokki maragade kakkogudate goorata jiruu jiroommakki min atamano goggogirroon, hikka maragadee isin ogeelataraan isiɂoottisinuun ekkaasayen. ");
INSERT INTO bswl_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","«Ayees kic'c'arikkiin kaɂabddame kallee kanjiinkkinna abddamara, ayees kic'c'arkki kaɂabddamoon kanjiinkkinna lakkoɂabddamaro. ");
INSERT INTO bswl_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Goortta, hikka alamikotti durummaa isin goɂammanamoon, tarummi durumma ayyoyya hadara ami isinuun kasisinara? ");
INSERT INTO bswl_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kakkalee ibaaddokotti durummaa isin oɂammanamoon golleeten, tattisin talleetetto durummaa ayyoyya isinuun kasisinara? ");
INSERT INTO bswl_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Kooyikkii Goottaa lama handdayin kadanddeera maayyona diyyii lakkogiro, koo diidegure kakkalee geelaatara, goorttun kooyi gabbalamara, kakkaleenna ade tuffatara. Kawaanna kamaragade diyyii liin lakkodootisaro.» ");
INSERT INTO bswl_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Maragade kageelaatare ibaaddo kafarasaawi hikka dubba maalere Yesuusaan k'ac'c'ifate. ");
INSERT INTO bswl_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Usuna isone haa ame, «Isin ibaaddo hore isiɂoottisin k'ulloolee oyelattaanttaan, Waa goɂameen wodanatattisin kasa. Ibaaddo dollee kakkabajaame, waayi hore kattuffameya. ");
INSERT INTO bswl_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Seera kamusenna kahegeroolkokki mas'aafanna taa Yaannisa geeroo segaamaa gire. Esekko abbaabatere ade wononnati kawaa kageggeloo lallabaaminara, ibaaddo dubba eserraa tabin lellaaminara. ");
INSERT INTO bswl_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ayesuun goɂameen seerakko eeggano koo iyaanokko daruurnna ulnna gorooreen ene leera. ");
INSERT INTO bswl_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Ooritteessa keelkki ame beesegure takkalee kaɂatatara dubba sharmmut'aara, entterkkona tabeetetto kaɂatatara sharmmut'aara.» ");
INSERT INTO bswl_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Adena Yesuusa haa ame, «Heela buraaburre awɂallokki sarssi kasarsatere arggetto barsano oɂidanɂiinna geggelooyi kagire dureessakki ibaaddoti koo gire. ");
INSERT INTO bswl_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Eseenna, meegga maar dubba kakkoɂeelttette Alaazari kaɂamamare hiyyeessati koo usu dureessakki ibaaddotikokki gooc'aa horee keenen kaaren. ");
INSERT INTO bswl_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Dureessakki ibaaddotikotti dugudkko taɂiyaatto orroontti aamin halchchaa gire, keroornna emeetegure meeggatatteessa hellefataa gire. ");
INSERT INTO bswl_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«Hikki hiyyeessati goye, erggichchaalnna Abraame tos geesen. Dureessakki ibaaddotina ade goye k'amalame. ");
INSERT INTO bswl_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Bowwa orroonna abboosaama giraan t'ok'k'i amere ebbaa Abraame dee, Alaazarina dollee kaɂabatero dee. ");
INSERT INTO bswl_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Usuna, ‹Aabbokki Abraame, nenɂeyisana, ani hikka lac'aa mankkoɂabboosamaro maraan, Alaazari fertteessatti birt'ee beke dinire errebkkee ambbal goggoyelloo maganne fari amaa iyyee.› ");
INSERT INTO bswl_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«Abraamena ade usune haa ame, ‹Unnukkee, ati girikkaa kaɂuleetii kaɂidan kooko goggoɂatattettoo, Alaazarina ade kameellan kooko kaɂatatero shaadi, gidda ade usu hittanii goggeelaaro ati adde abboosa gutii gitta. ");
INSERT INTO bswl_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hikka dubbakko hittakko isin tos roorin odootataran odanddeenon laano, aanttinne ogiraanna adeen no tos goggonak'oonkko, noyyenna isin t'eɂee laga kaɂatii gira.› ");
INSERT INTO bswl_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«Usuna haa ame, ‹Aabbokkee Abraame, goortta Alaazari Aabbokkeekki min goggofartton ani ku ebaatara. ");
INSERT INTO bswl_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Abbilaal kenno iin mankkogitto maraan, isona hitta taɂabboosa banɂe tos goggoɂemennoonkko seeyire iso haɂaddeesiso.› ");
INSERT INTO bswl_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","«Abraame ade, ‹Isoon kamusena kahegeroolkokki mas'aafajjol esee giraan isona hamaaleen› ame. ");
INSERT INTO bswl_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","« ‹Usuna, Aabbokki Abraame lakkohaayyo;› odo koo goyikko kiigure seetewa c'ubbokko gula galareenwa ame. ");
INSERT INTO bswl_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","«Abraamena ‹Kamusena kahegerookokki mas'aafajjol ommaaloon golleen, odo koo goyikko kiigure goseetena lakkoɂammannaan ame.› » ");
INSERT INTO bswl_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesuusa usukko oɂagaalssataranne haa ame, «Ibaaddo kahanddufisira haɂemennonii lakkohesnaro. Ayesuun goɂameen handdufo kallaroon hassu ibaaddotin aanne. ");
INSERT INTO bswl_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Hikki ibaaddoti hinɂa otitiic'c'arkko koo kahanduddufisarokko, riim kabadalaa marggitteessaa shaamigure beke orroo badii goshafame hore laare. ");
INSERT INTO bswl_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Haanssun isiɂoottisin oorayeen. «Abbikka ku gomiirɂe hadisi, ani baasera ami goggula gale haheso amina. ");
INSERT INTO bswl_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Arri tooyi todoba gali ku miirɂigure todoba gali ‹Ani ku miirɂera› amaa ku tos goɂemeete usuun haheso ami.» ");
INSERT INTO bswl_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ofarameeraanna Goottanne, «Ammanokkaani noon adina» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Goottanna, «Il tasinafic'c'i gitakki ammano isinuun girewa, hitta odaa, ‹Tagamigudde bekee orroo abbaramina› goɂantteen isinuun ajajaanttowa» ame. ");
INSERT INTO bswl_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Adena Yesuusa haa ame, «Isin orrokko ibaaddoti koo ira kaɂotaro goorttun idaad kafoofaro lee kahandaaro kaɂabo gollee, usu irakko kagamatero kahandaarokkine, ‹Saami babo tos gabbalami amattaan›? ");
INSERT INTO bswl_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Hikkakko suure, ‹Kahemeene kita kakkee ani goggoɂaamiroo ekkaasina, ani taa aamironna taa t'amiroo mowagudde iin handdayi, esekko abbaabayidde ati aaminatta, t'aminatta lakkoɂamaroya›? ");
INSERT INTO bswl_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Goortta hikki ibaaddoti, kahandaarekki usuun kaɂajajaamero mankkofele abbaabe maraan usu galataara? ");
INSERT INTO bswl_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Haanssun isinna hikkamalee kaɂajajaanttettaan dubba kakkofeltteen goorata, ‹Noo laɂo kallayinɂi ohandaannonna, felamiin kadootisarona felinne gudinssenna ama.› » ");
INSERT INTO bswl_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Esekko abbaabatere Yesuusa Iyyerusaalemi tos seetaa giraan mina tasemaryaannena tagaliila maamankokki meessane roore. ");
INSERT INTO bswl_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Maaman koo tos goggotabee maarii bar oɂabanaayen ibaaddojja tomonno Yesuusane wota esele, isona ebbaa aalleeren; ");
INSERT INTO bswl_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","taɂatii yaaye, «Goottaa Yesuusa, noon nenɂeyisa!» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Usuna iso kakkodeyaare goorata, «Seyeenddeen isiɂoottisin tuuk'aamolun tusayeen» ame. Isona eserraa seeto gutii giraan muc'c'imeen. ");
INSERT INTO bswl_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Isokkona koo fayyaanokkeessa kakkodeyaatare goorata yaaye t'ok'k'i taɂanttee Waa kabajaa abbaabate. ");
INSERT INTO bswl_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Luki tayesuusa gutii hore hore iyyegure galatee, hikki ibaaddotina samaraawitiyye. ");
INSERT INTO bswl_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesuusana haa ame usu hoosate; «Kamuc'c'imere ibaaddo latomonyella? Hayya, saagallo hagge seete? ");
INSERT INTO bswl_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hikka kasamaraawi allaggati kuwaarre abbaabateren Waa kagalatara kakkalee lakkogiro amanoya?» ");
INSERT INTO bswl_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ibaaddotinena, «Kiigudde gali, ammanokka ku fayyiisera» ame. ");
INSERT INTO bswl_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farasaawilkokki ibaaddo wononnati kawaa goree emeeyinaro Yesuusa kakkohoosatareen goorata haa ame isoon abbaabe, «Wononnati kawaa kamutaro raadii lakkoɂemeetaro. ");
INSERT INTO bswl_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ibaaddona, ‹Hittaniiya› goorttun ‹Aanttiiya› amin lakkodaanddeero, hikkima, wononnati kawaa isinii orroo gira.» ");
INSERT INTO bswl_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesuusa usukko oɂagaalssataranne haa ame, «Ere kaɂibaaddo kakkoɂemeyinaro arrijjoolkko too din kakkohalchchinattaan goorata emeeyinara. Adina lakkodinnattaan. ");
INSERT INTO bswl_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ibaaddo, ‹Aanttiiya› goorttun ‹Hittaniiya› aminara, debeenna arooseetteen. ");
INSERT INTO bswl_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Aalanttina hank'k'a hank'k'ayegure daruur k'amakko taa t'amo geeroo goggohank'ayisaro malee, ere kaɂibaaddonna takkoɂemetaro arri usumalee linnatta. ");
INSERT INTO bswl_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ayesuun goɂameen hikki laanakko horene ere kaɂibaaddo kanjiin abboosamanona hitta alattaanii tuffamano ginnara. ");
INSERT INTO bswl_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«Kannohe geesii goggolleerokki malee, ere kaɂibaaddo takkoɂemeyinaro arri usumalee linnara. ");
INSERT INTO bswl_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nohe markkafaa takkotabero arri taageero ibaaddo aamaanna t'amaa, oori atataanna keesataa gire. Obbaasaran beke emetengureen dubbana baaseen. ");
INSERT INTO bswl_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","«Kalloot'e geesnna usumaleeye, ibaaddo aamaanna t'amaa, iminataanna daddalataa, akaakiltte abbarataanna min madaarataa gire. ");
INSERT INTO bswl_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Loot'e Sodoomikko takkobeere arri goɂameen eleenna kagubara boolaalnna daruurkko ubatere iso dubba gubtte baasse. ");
INSERT INTO bswl_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","«Ere kaɂibaaddo takkoɂemeetaro arriinna usumalee linnara. ");
INSERT INTO bswl_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Hasse arri minkkeessatti heelinchchoo gutii kagira ibaaddo maayyona minkkeessa orroo ogiraan urrawo atayin arooddago. Usumaleenna iraa kagira ibaaddona haarddii arooɂabbaabanno. ");
INSERT INTO bswl_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Talloot'e oori shaada. ");
INSERT INTO bswl_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Neefotteessa haasayiin kadootatara dubba waatara; neefotteessa roorssate kasisatara goɂameen haasatara. ");
INSERT INTO bswl_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Hasse hemeenii ibaaddo lama alggaa tooyi huddurnaraan, koo ataminara, koo hesinara. ");
INSERT INTO bswl_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Heleel lama raattoo ritayinaraan, too ataminatta toonna hesinatta.» ");
INSERT INTO bswl_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ibaaddo lama iraa girnnaraan, koo ataminara koo hesinara. ");
INSERT INTO bswl_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Isona abbaabereen, «Goottaa, oɂatamaraan haggerraaya?» ameen. Usuna, «Rak'a mankkogiroo allaattil kukkuɂamara ame.» ");
INSERT INTO bswl_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesuusakko oɂagaalssatareen anshishaadoon arggetto ebaatano kadootisaro laano tusin Yesuusa hikka masuussa isoon segee. ");
INSERT INTO bswl_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Haanna ame, «Katamaa tooyi kagire Waa kaɂabssannonna ibaaddo kakkabajjinoon daanna koo gire. ");
INSERT INTO bswl_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ese katamaayi galttaantteti too gitte. Ese, ‹Baragarakkeenne wota taɂabo haajaa iin gaafana› amaa usu tos sesseetaa gitte. ");
INSERT INTO bswl_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","«Daannanna metekkahoree ese lakkok'op'atere, danbbenne ade wodanatteessaa haa ame, ‹Koonna Waa abssatano gowaayena, ibaaddona gokkabajaanawaaye, ");
INSERT INTO bswl_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Hitti galttaantteti in hamas's'i mankkotiratto maraan eseen firddinara. Goorttun adi arggetto sesseetaa in hifachchisinatta.› » ");
INSERT INTO bswl_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Goottanna, «kameellan daanna taɂamero maala. ");
INSERT INTO bswl_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Waa ade hemeenna arriinna usu tos oɂiyyaaraawuunna oɂassaabameeraawun lakkofirddaaroya? Allakko roore c'alɂi amara? ");
INSERT INTO bswl_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ani isinuun haa amaraan, saame isoon firddaara. Ayesuun goɂameen ere kaɂibaaddo kakkoɂemeetaro goorata ulii gutii ammano kahello leewuna?» ame. ");
INSERT INTO bswl_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Debeenna Yesuusa noo k'ulluunɂinna amaa isiɂoottisooyi odhadataraanna kakkalee ibaaddona otuffataraawun, hikka masuussa segee. ");
INSERT INTO bswl_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Ibaaddojja lama Waa ebaayin k'ulluukki min kawaa seeteen, koo Farasaawiti kakkalee k'arat'a kakukkuyisaroyeen. ");
INSERT INTO bswl_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farasaawiti kale aalleere isiɂoottessaawun haa amaa ebaataa gire. ‹Kawaaye, ani ibaaddo kakkalee dubba aani kasaamaro, kameellankki, kasharmmut'aaro, hassukona hikka k'arat'a kakukkuyisaro aani laana mankkowaaye maraan ani ku galataara; ");
INSERT INTO bswl_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Todoba tooyi lama gale agabuwara, kahelataro dubbakko gene tomonkko barkkintte beesara.› ");
INSERT INTO bswl_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«K'arat'a kakukkuyisare goɂameen ebbaa aalleegure, daruur tos t'ok'k'i ami din duuddo lakkodootero, ayesuun goɂameen geegiyo bobboc'aata, ‹Kawaaye, in c'ubbaaleessa maari› amare. ");
INSERT INTO bswl_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","«Ani isinne haa amara, Farasaawitikko roore hikkina Waayi dollee k'ulluukki aani lee tootaame minkkeessa abbaabate. Isiɂoottessa kat'ok'k'i t'ok'k'iɂisatara dubba hussi aminara, isiɂoottessa kahussi hussiɂisatara goɂameen t'ok'k'i aminara.» ");
INSERT INTO bswl_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yesuusa gene gutii kayi goggosommaasaroo ibaaddo yiis usu tos keenatare. Usukko oɂagaalssatareen hikka kakkodeyaaren goorata hadiseen. ");
INSERT INTO bswl_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yesuusa ade yiis isitoos uumegure haa ame, «Yiis in tos goggoɂemeeroo feɂi sisa, arootirtteen, wononnati kawaa hinɂa aanɂinɂiwunya. ");
INSERT INTO bswl_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ani rumminaa amara, wononnati kawaa yiis aani kaɂatannon dubba duuddo lakkotabnaro.» ");
INSERT INTO bswl_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ayihuudikokki woyichchaalkko koo, «Kaɂidankki kaɂagaalssisatto,» jiruu jiroommakki giri eelin ani me fella? Ame usu hoosate. ");
INSERT INTO bswl_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesuusa abbaabere, «Me maraan ati in kaɂidankki amatta? Waa koo kuwaarre kaɂidankki maayyona lakkogiro. ");
INSERT INTO bswl_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","‹Aroosharmmut'ite, aroolagadde, aroohette, t'araayi arooɂatotiite, Aabbokkaanna Aayettaa kabajii kaɂamaro ajaja ati kassowa ame.› » ");
INSERT INTO bswl_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ibaaddotina, «Hikka ajajaal ani yiisummakko haggaɂabere oorayeera» ame. ");
INSERT INTO bswl_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesuusa hikka kakkomaalare goorata, «Goortta kuun ayees koo kahesera, kaɂabtto dubba daddaligudde hiyyeessalun sisi, kadaruure mazggabaa ati girttowa. Esekko emeedde indebee sessee» ame. ");
INSERT INTO bswl_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ibaaddotina hikka kakkomaalare goorata, tanjiin durumma usuun mankkogitte maraan aaloo hawɂisate. ");
INSERT INTO bswl_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesuusana ibaaddoti deegure haa ame. «Tammooggan durumma kaɂaboowun wononnati kawaa tos tabano misikki daafurya? ");
INSERT INTO bswl_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Dureessa wononnati kawaa tos tabanokko gaala butto kamarffi orromari goroore ene leera.» ");
INSERT INTO bswl_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hikka kamaale ibaaddona, «Hayya, ayyoyya fayyiin kadaanddaara?» ame. ");
INSERT INTO bswl_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesuusana, «Ibaaddo dollee kadandaamoon Waayi dollee daandaamara» ame. ");
INSERT INTO bswl_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","P'et'iroosana, «Hikkima, noo kaɂabnno dubba iinssenne ku debee sesseennenna ame.» ");
INSERT INTO bswl_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesuusana isone, «Ani rumminaa amara,» wononnati kawaawuun amere «Minkkeessa goorttun ooritteessa goorttun abbilaaltteessa goorttun oɂumuleeraanna goorttun yiiskkeessa kaɂiise, ");
INSERT INTO bswl_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","hikka geesii kamooggan ambba, kaɂemeetaro geesii jiruu jiroommakkokki giri kaɂatannon maayyona lakkogiro.» ");
INSERT INTO bswl_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesuusana tomonkko lama usukko oɂagaalssataranne kale aate beegure haa ame, «Goortta no Iyyerusaalemi tos binnanna, ere kaɂibaaddo maraan ohegerooli kas'aafamera dubba gudayinara. ");
INSERT INTO bswl_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ayizaabn usu roorisi sisinaraan, isona k'ac'c'ifayinaraan, abi madarrinaraan, hanc'c'ufe tufinaraan. ");
INSERT INTO bswl_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Boc'c'inaraan, esekkona lagadinaran, usuna taseedi arri goyikkona kinnara.» ");
INSERT INTO bswl_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Usukko oɂagaalssataran goɂameen hikka dubbakko koonna iso kaɂaddeesereen ayees lakkogire, ayeenssa isokko siyame gire, me amanoyona lakkoɂaddeeseren. ");
INSERT INTO bswl_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesuusa taɂiyyaarkko katamaa tos kakkogabbalamare goorata, koo Iilɂo kabayere raagriidi hamas's'eere ebaataa gire. ");
INSERT INTO bswl_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Iilɂo kabayerena gosa esene rooraa giraan maalegure, hikki meyya? Ame iso hoosate. ");
INSERT INTO bswl_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Isona, «Kanaazireti Yesuusaya hittanne karoorara» ameen usuun segeen. ");
INSERT INTO bswl_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Usuna, «Ere kadaawute, Yesuusa, in maari!» amaa iyyee. ");
INSERT INTO bswl_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Horehaye kasessetare ibaaddona, c'alɂi usu goggoɂamiroo hadiseen, usu goɂameen, «Ere kadaawutee, in maari!» amaa jiinase iyyee. ");
INSERT INTO bswl_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesuusana aalleere ibaaddoti usu tos goggokeennawun ajajee. Usu tonssa kakkogabbalamare goorata, ");
INSERT INTO bswl_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Yesuusana «Ani kuun me goggoyelloo dootatta?» ame usu hoosate. Iilɂo kabayerekkina, «Goottaa, din dootatara» ame. ");
INSERT INTO bswl_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesuusana, «Deena, ammanokka ku fayyiisera» ame. ");
INSERT INTO bswl_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ibaaddotina goorsewa din daanddee. Waanna kabajaa Yesuusa debee sesseete. Gosa dubba hikka deegure Waa galatee. ");
INSERT INTO bswl_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesuusa taɂiyyaarkko katamaa tos tabere esene roore seetaa gire. ");
INSERT INTO bswl_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mege zakkoosa kaɂamamere ibaaddo koo ese gire, k'arat'a okukkuyisareewun woyichchana dureessanaye. ");
INSERT INTO bswl_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Usuna Yesuusa kaɂamamare eekiyo din dootaa gire, ayesuun goɂameen Jifu tagababbantti mankkolleete maraan, gosa moggankko kakkeeyi usu din lakkodaanddeere. ");
INSERT INTO bswl_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yesuusa hassu raanne rooraa mankkogire maraan, usu din horehaye tiiyyegure odaa tooyi gutii korate. ");
INSERT INTO bswl_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesuusana ese banɂe geegure, t'ok'k'i amere «Zakkoosa, hittaari ani minkkaayi hayin dootisara saami dagi» ame. ");
INSERT INTO bswl_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Usuna saame dagegure Yesuusa geggelooyi k'op'ate min geesate. ");
INSERT INTO bswl_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ese kagire ibaaddona hikka deegure, «Hikki ibaaddoti min kac'ubbaalessa tos marttina aamin tabe!» amaa dubbana gumggumaano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakkoosa ade kee aalleegure Goottanne «Goottaa, ani taɂabo durumma dubbakko mina hiyyeessawun sisinara. Maayyokona t'araayi kasaamero gollee, ambba afar yeli usuun abbaabinara» ame. ");
INSERT INTO bswl_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesuusana abbaabere, «Hikki ibaaddoti ade taɂabraame sannii mankkollee maraan, hittaari fayyinna usuna hikka minuun leera. ");
INSERT INTO bswl_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Aalanttina ere kaɂibaaddo kakkoonɂemeetera kabayero dootinna fayyisiinya» ame. ");
INSERT INTO bswl_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Gosana hikka maalaa giraan, Yesuusa masuussaa ayeesano horeddee, aalanttina Iyyerusaalemi tos gabbalamanona ibaaddoon wononnati kawaa kagabbalamero aani lee mankkomute maraanya. ");
INSERT INTO bswl_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yesuusana haa ame, «Shuumi koo mege kawononnati atayire abbaabayin ul kaɂeer seete. ");
INSERT INTO bswl_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ohandaareen orrokko tomon uumere t'agaraa tomon isoon sisegure, ‹Abbaabayi ani taaɂemeeroo hikka maragade daddalayen› » ame. ");
INSERT INTO bswl_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","«Ulkkeessakki ibaaddo goɂameen usu mankkodiide maraan, ‹Hikki ibaaddoti noo gutii goggoreediro lakkodootatanno› ameeren usu debee ohandaareen fareen. ");
INSERT INTO bswl_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Halleewo kuwaarre hikki shuumiti reede ulkkeessa abbaabate, aanɂi ohanddaareenɂi usu kasisero maragade daddaleeren eeggitakki worɂe helateeraan malabiin iso uumsise. ");
INSERT INTO bswl_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","«Ohandaareenkko kahoree gabbalamere ‹Goottakkee, ati iin tasissette t'agaraakko t'agaraa tomon worɂe helamissisera› » ame. ");
INSERT INTO bswl_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","«Goottanna, ‹Ati kaɂabddantte kahanddaattakki› Goɂidan felttetta, ‹Kooko kic'c'arkkii kaɂabddantte leete mankkomutte maraan, katamaal tomonnii gutii odonnati kuun sisamera› » ame. ");
INSERT INTO bswl_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","«Kallamikkina gabbalamegure, ‹Goottakkee, ati iin tasissette t'agaraakko t'agaraa ken worɂe helamissetta› ame. ");
INSERT INTO bswl_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","«Goottakkeessana ‹kuun ade katamaal kenni gutii odonnati sisamera› » ame. ");
INSERT INTO bswl_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«Kakkalee kahandaarena gabbalamere haa ame, ‹Goottakkee, hoc'ooyi mammare kaye ani kaɂadallayisera maragadekka hikkima. ");
INSERT INTO bswl_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ati kakkaannon gitto kaɂataatto, kawut'annon gitto kamat'araatto, kaɂantte kaɂiisoon ibaaddoti mankkolleete maraan ani ku abssayera.› ");
INSERT INTO bswl_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","«Goottanna haa ame, ‹Ati kameellan kahandaatta haafura kaayiwa ani ku firddinara. Kakkaannon giro kaɂatataro kawut'annon giro kamat'arataro kaɂame kaɂiisoon ibaaddoti laanokkee goɂaddeessette, ");
INSERT INTO bswl_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Emeeyire maragadekkee worɂene wota goggoɂataroon kafelataro ibaaddon muun sisiwaatte?› ");
INSERT INTO bswl_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","«Goottakeessana, esee oɂaalleraanne ‹T'agaraa usukko aataddene t'agaraa tomon kaɂaboon sisa ame.› ");
INSERT INTO bswl_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","«Isona ‹Gootta, usu t'agaraa tomon aba› ameen. ");
INSERT INTO bswl_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","«Yesuusa haa ame, ‹Ani isinuun haa amara, kaɂaboon dubba adamara. Kallikkikko goɂameen aankki kagirawa ataminara. ");
INSERT INTO bswl_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ayesuun goɂame ani isoo gutii goggoreedonkko odootateeran hassu diinajjoolkkee hittarraa keenadeene in hore enɂaa ame.› » ");
INSERT INTO bswl_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesuusa hikka ayeese abbaabatere Iyyerusaalemi tos bin horehaye sesseetaa gire. ");
INSERT INTO bswl_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Zayitii kabeyaara gaa takkoɂalataro wodamii ogiraan, Beetefaage tonssa kabittaaniya maaman tos kakkogabbalamare goorata, usukko oɂagaalssatareenkko lamanne haa ame fare. ");
INSERT INTO bswl_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«Isin horee kagiro maaman seeyeen, eserraanna tabaa giraan maayyona suure takkohamas'iinoon giro tademeeree darmmee shaantte tagitto helnnattaan, furaddeen hittarraa keena. ");
INSERT INTO bswl_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Maayyona ‹Muun furattaan?› Ami isin gohoosate ‹Goottawun dootisatta ama.› » ");
INSERT INTO bswl_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ofarameerenna seeteerene usu goggosegeerekki malee lee heleen. ");
INSERT INTO bswl_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kaminee ibaaddona darmmee tademeer isin furaa giranttii deengureen, isone «Darmmee muun furattaan?» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Isona «Goottawun dootisatta» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Esekkona darmmee tademeer Yesuusa tos keenen, sarssi kakkisoo gutii yayeengurene Yesuusana darmmeeyi gutii hamas's'iiseen. ");
INSERT INTO bswl_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ibaaddona usu kakkoseetaro raadii sarssikkisoo yaa gire. ");
INSERT INTO bswl_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Zayitii kabeyaara gaa takkoɂalataro wodamikko metegamatto kageesaro raa tos kakkogabbalamareen goorata tooto aaloo onjiin olleeren usukko oɂagaalssatareen kaddeeraan baasa dubbaa geggelaataa yaayetisoo t'ok'k'iseen haa amaa Waa galataano haggaɂabeen. ");
INSERT INTO bswl_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","«Mege kagoottayi kaɂemeetara wono kasommaasameya!» «Nogodda Daruurii, kabaja guuntte Waawuun halleeto!» ");
INSERT INTO bswl_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Gosa orroo kagire kookkoo ibaaddo kafarasaawi Yesuusane, «Kaɂagaalssisatto, kukko oɂagaalssataran c'alɂi goggoɂaminaawun lakkohadisattoya?» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesuusana, «Ani isinne haa amara» «Iso c'alɂi goɂameen eɂemoolnna iyyirowa» ame. ");
INSERT INTO bswl_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesuusana Iyyerusaalemi tos kakkogabbalamare goorata katamaa deegure oote. ");
INSERT INTO bswl_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Haa ame, «Kuun nogodda kalleero meyya ati hittaari addeesi gittewa! Gidda goɂameen ilttaakko golatera. ");
INSERT INTO bswl_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Diinajjolkka ku maraamure mina mina maraamurisi ooti kayigure tabanokkaanna biyaanokkaa tiri kakkoyaadisira goorata emeeyinara. ");
INSERT INTO bswl_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Te kunna ootittaayi orroo kagiro yiiskkaa errene wota lelledinaraan, eɂemokko kafelamera gimbbe dubba diigaminara, Waa ku fayyiisin kakkoɂemetero goorata ati lakkoɂaddeessetto.» ");
INSERT INTO bswl_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Esekko abbaabatere Yesuusa k'ulluukki min kaɂebi tabere odaddalatareen esekko beese. ");
INSERT INTO bswl_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Adena « ‹Min kakki k'ulluukki min kaɂebi linnara› amame mas'aafa k'ulluukkii s'aafamera isin goɂameen ‹Laga kashitta› yelatteen» ame. ");
INSERT INTO bswl_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesuusa arggetto k'ulluukki min kaɂebii agaalssisaa gire. Tuuk'aamokokki woyichchana kamuse seera oɂagaalssisareen, kakkaleenna Ayihuudin horehayeen ofelareen Yesuusa lagadin dootaa gireen. ");
INSERT INTO bswl_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ayesuun goɂameen gosa dubba agaalssisanokkeessayi boojaame mankkogire maraan felin amaa kaɂemeeteren isoon ekkaatana waate. ");
INSERT INTO bswl_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Arri tooyi Yesuusa gosa k'ulluukki min kawaayi agaalssisaanna odu taɂidan lallabaa giraan tuuk'aamolkokki woyichchaalna seera kamuse oɂagaalssisaranna jaarsolee kukkuɂameen usu tos emeeten. ");
INSERT INTO bswl_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Isona, «Hikka ayees kakkofelatta eeki odonnatiyo noon segii. Kuun odonnati kasisera usu ayyoyya?» ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesuusana, «Aninna hoosiin too isin hoosaro, alla iin abbaaba. ");
INSERT INTO bswl_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","T'ink'ata kayaannisa Waakkoya mu ibaaddokkoya?» ame. ");
INSERT INTO bswl_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Isona haa ameeren isi isiɂorroo makkareen; «Waakkoya goɂaminne, ‹Hayya Yaannisa kaɂamero muun isin ammanana waatteen?› aminara. ");
INSERT INTO bswl_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","‹Ibaaddokkoya› goɂaminne gosa dubba Yaannisa kahegeroo laanokkeessaa mankkoɂammanataraan maraan eɂemoo no eeggiranwa.» ");
INSERT INTO bswl_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Haanssun «Eetikkoyo noo laakansso» ameen abbaabeen. ");
INSERT INTO bswl_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesuusana, «Goortta aninna hikka ayees eeki odonnati ani felaro ani isinuun lakkoseginaro» ame. ");
INSERT INTO bswl_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Esekko abbaabatere Yesuusa haa ame hikka masuussa gosaawun segaano haggaɂabe. «Ibaaddoti koo akaakiltte kawoyinii abbarate, otateen obaraarewun kirayii sisegure ul kakkalee seetegure tanjjiin adallaate. ");
INSERT INTO bswl_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kaami takkokukkuɂamaro diginnii, tawoyinii ilkko usu tageyaatto mina goggofarrawun kahandaare otateen obaraareen tos fare, otateen obaraaren adeen kahandaaro boc'c'eeren gene taalaal gafareen. ");
INSERT INTO bswl_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Debeenna kakkalee kahandaaro fare, otateen obaraareen usuna adeen boc'een, yeraasenen gene taalaal gafareen. ");
INSERT INTO bswl_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Giddanna ade kaseedi kahandaarena fare, otateen obaraareen usuna addeen meeggayisen sarddeediseen shafeen. ");
INSERT INTO bswl_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«Kawoyinii akaakilttekkokki odona, ‹Goortta misi yella? Alla adi kageelaataro erekkee farnnara, woddaasa usu okabajiiraan leeraan› ame. ");
INSERT INTO bswl_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","«Otateen obaaraaren goɂameen erekkeessa kakkodeyaanne goorata ‹Hikki kaɂeelnaroya,› Koyeen ‹Usu lagandda hitti rittiinna tattaani leetowa› ameen malaateen. ");
INSERT INTO bswl_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kawoyinii akaakiltte banɂekko sar beeseren lagadeen. Yesuusana. «Goortta akaakilttekkokki odo misi yelinara? ");
INSERT INTO bswl_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Emeeyire hanɂu otateen obaraareen lagadinara. Kawoyinii akaakilttekkotti banɂe kakkalee otateen kabbaraaroon sisinara.» Gosana hikka kakkomaalare goorata, «Hikka aankkikki arookkeeno» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesuusana iso tos diyaa haa ame, « ‹Hayya gimbbe omadaarataran kattuffateraan eɂemo felo omineetun mete lee amame kas'aafamerokotti fureenna metta›? ");
INSERT INTO bswl_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Hikka eɂemoo gutii kaɂiyaara dubba eɂebinara, eɂemona usu gutii kakkoɂiyaara dubba shiiɂaminara» ame. ");
INSERT INTO bswl_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Seera kamuse oɂagaassisareenna tuuk'aamolkokki woyichchaalna hikka masuussa kakkoonɂayeesere isoon laano mankkoɂaddeeseen maraan, usu goratawa abin dootaa gireen. Ayesuun goɂameen gosa abssateen. ");
INSERT INTO bswl_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yesuusana karoomi mootiwun roorisi sisin hiɂikko kabiyaaro haafuraa usu abin dootaa gireen. Haanssun karrummii aani lii ogabbalamiraan kimbir kayeen. ");
INSERT INTO bswl_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kimbir leen oseeterenna haa ameen usu hoosaten. «Kaɂagaalssisatto, ati likkiikki ayees goggoɂayeesattona goggoɂagaalssisatto usumalee raa kawaa karrummii goggoɂagaalssisattona maayyoonna kaɂululisoon laano noo kanssowa. ");
INSERT INTO bswl_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Amiinna K'eesaariwun giira murano seerakkaani feɂi sisara mu lakkosisaroya?» ");
INSERT INTO bswl_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesuusa goɂameen meellanettisoo addeesere haa ame. ");
INSERT INTO bswl_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Alla dolchchii too iyyeen tusa, gutii tagitta taayyo middina mege kaayyoya?» Isona tak'eesaritta ameen abbaabeen. ");
INSERT INTO bswl_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesuusana, «Goortta kak'eesari K'eesaariwun, kawaanna Waawuun sisa» ame. ");
INSERT INTO bswl_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Haanssun usu kaɂayeesero haafuraa gosa horee usu abin lakkodaanddeen, abbaabikkeessaa mameengureen c'alɂi ameen. ");
INSERT INTO bswl_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Goyikko kiyaano laagiro oɂamaraan Sodok'aawilkko kookkoo Yesuusa tos emeetengurene hoosin hoosaten. ");
INSERT INTO bswl_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Haanna ameen, «Kaɂagaalssisatto,» Ibaaddoti koo oori atayigure yiis haɂumulooni goggoye, abbi ese galttaatteti atayire yiis umuli abbikkeessawun sannii banɂee goggokayiroo «Muse noon s'aafera. ");
INSERT INTO bswl_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Hayya, abbilaal todoba gitte. Kahoree oori atategure yiis haɂumulooni goye. ");
INSERT INTO bswl_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kallamin usumalee. ");
INSERT INTO bswl_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kaseedina ade atate, todoba dubba usumalee atatengureene yiis haɂumulooni goyeen. ");
INSERT INTO bswl_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Haarrena heleelttiti goote. ");
INSERT INTO bswl_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Goortta todoba ese mankkoɂatatere maraan, tagoyikko keyaano arri ese oori taayyo linnatta?» ");
INSERT INTO bswl_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesuusana abbaabere, «Hikka alamikokki ibaaddo atataraan, keesaran. ");
INSERT INTO bswl_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kaɂemeetaro alamiinna goyikko kiyaano okkoondootisara goɂameen lakkoɂatataraan, lakkonakeesamaraan. ");
INSERT INTO bswl_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Erggichcha aani mankkollinnaraan maraan esekko danbbeebaan lakkogoyinaraan, goyikko mankkokeen maraan yiis kawaayaan. ");
INSERT INTO bswl_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Muse gara kahurisekotti tas'aafanttetto jirtti orro Goottanne, kaɂabraame Hedo, kayissaak'a Hedo, kayayik'ooba Hedo amano ogoyeraan kakkinnaraan laano tusara. ");
INSERT INTO bswl_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dubbana usuun arddonɂi mankkoleen maraan, usu arddonɂikkokki Hedo kuwaarre goyikokki Hedo lakkoyo.» ");
INSERT INTO bswl_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kookkoo seera kamuse oɂagaalssisareenna «Kaɂagaalssisatto, taɂidan ayeesse, ameen.» ");
INSERT INTO bswl_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Esekko abbaabateren odo koonna duuddo usu hoosayin lakkodaanddee. ");
INSERT INTO bswl_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Esekko abbaabatere Yesuusa haa ame, «Ibaaddo Kiristoosa misii ere kadaawuteya amara? ");
INSERT INTO bswl_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Aalanttina daawute metekkeessan mazamurikokki mas'aafayi haa amera, « ‹Waa Goottakkeewun, diinakkaa lukittaayi ani taadaddarisiroo «Merggetteeyi hamas's'ii» › ame. ");
INSERT INTO bswl_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Goortta Daawute, ‹Goottaa› ami usu goɂuumiro misii erekkeessa laara?» ");
INSERT INTO bswl_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yesuusa gosa dubba maalaa giraan usukko oɂagaalssataranne haa ame. ");
INSERT INTO bswl_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Kaɂeerkki sarssi sarssateeren maraamurano ogeelaataran, taggiyyaa banɂee nogodda aatin odootataraanna, Ayihuudikokki min kaɂebii kakkabajaa barc'uma, banɂe taɂaamoyinna takabajaa banɂe, odootataraankko isiɂoottisin oorayeen. ");
INSERT INTO bswl_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Isona kagalttantteel min ohiyyumisaraanyan. Mutin ameeren ebikakkisoo eeraasataran, kameellan firdda iso ooratara.» ");
INSERT INTO bswl_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesuusa t'ok'k'i ami godeero dureessajjol k'ulluukki min kawaayi mus'uwaata kakkokukkuyisaraan huuyi orddeesen mus'waatakisoo lugudaa giraan dee. ");
INSERT INTO bswl_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Adena hiyyeetti galttaantteti too dolchii lama lugudaa dee. ");
INSERT INTO bswl_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Haanna ame, «Ani rumminaa amara, dubbaankkona roorsse hitti hiyyeetti galttaantteti sissetta. ");
INSERT INTO bswl_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Hinɂi ibaaddojja kakkosiseeran worɂekisokko golleero, ese goɂameen kasissetta hiyyummattiseekokki jilbbaa oɂabtto barisano dubba sissetta.» ");
INSERT INTO bswl_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Usukko oɂagaalssatarankko kookkoo k'ulluukki min kawaa eɂemo kaɂidankkina Waawun kasisamero ilabo iidanokokki ayeesaa giraan, ");
INSERT INTO bswl_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Yesuusana haa ame, «Hikki isin kadeyaattan dubba hadarɂaamooni eɂemo eɂemoo gutii goggokakkaameroo takkohesoon arri emeeyinatta.» ");
INSERT INTO bswl_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Isona, «Kaɂagaalssisatto,» goortta «Hikki dubba kakkollinnara goreeya? Adena hikki haa kakkolinnara malaata meyya?» ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesuusana haa ame abbaabe, «Goggosossoyinonkko isi oottisin oorayeen, kamooggan, ‹Ani Kiristoosayya› amaa, adena, ‹Goorata gabbalamera› amaa megekkeeyi emeeyinaran. Isin goɂameen iso debeenna arooseetteen. ");
INSERT INTO bswl_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Jereen keyaanokokkina gosakotti engge gomaaltteen arooneyiteen. Hikki t'ayi liin kadootisaroya, geeskotti gachcho ade goorsewa lakkolinnatto.» ");
INSERT INTO bswl_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Adena haa ame, gosa gosaa gutii, wono wonoo gutii kinnara. ");
INSERT INTO bswl_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kaɂatii ulkokki aaɂaano linnara, uɂina hinc'c'inne ul dubbaa linnatta. Kaɂabssisira kooko usumaleenna daruurkko kaɂatii malaata linnara. ");
INSERT INTO bswl_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Hikki dubba laanokko horene ibaaddo goɂameen isin abnnaraan. Horoornnara, firddiiwun Ayihuudikokki min kaɂebii tonssa geesinaran minkashaano tabsinaraan. Wonolaalnna mootijjol horee geesinnaran, hikki dubbana megekkeekotti aalanttii isin ginnara. ");
INSERT INTO bswl_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Hikkina megekkee atotiin taɂidantti it'aa isinuun linnatta. ");
INSERT INTO bswl_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Haanssun kamootaminattan mooton me abbaabiti sinssa amaa tarii goggoyaadonkko wodanaayi abayeen. ");
INSERT INTO bswl_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Diinakkisin isin awodiinna isin diidin kakkodaanddenoon haafurana k'arumma ani isinuun sisinara. ");
INSERT INTO bswl_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Isin oɂumuleeraan, abbilaalttisin, fallikkisinna saatijoolkisin duuddo hahesooni isin roorisi sisinaran. Isinkkona kookkoo lagadinaran, ");
INSERT INTO bswl_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Iyyeen mankkoɂammanattaan maraan ibaaddo dubbaa dollee kadidantteen leetaan. ");
INSERT INTO bswl_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ayesuun goɂameen metekisinkki fiit'a koonna lakkobaaro; ");
INSERT INTO bswl_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ataayi aallanoyi neefotatisin haasayinattaan. ");
INSERT INTO bswl_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Adena Yesuusa haa ame, «Iyyerusaalemi kajereene wotaadaral marantte taɂabanttetto kakkodeeten goorata, bayikkakkise gabbalamano addeesa. ");
INSERT INTO bswl_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Hassu goorata ul kayihudaayi ogiraan dubba wodamiil tos habak'ateen. Katamaayi ogiraanna esekko habeen. K'amanne ogiraanna katamaa orddi arootabo. ");
INSERT INTO bswl_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kas'aafamera dubba goggogudaroo hikki kamurroo goorataya. ");
INSERT INTO bswl_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ul gutii taɂatii rakkoo linnatta hikka gosa gutii engge emeeyinatta. Haanssun hassu almmaa heleel kafatowunna kaɂiilisaroon aanne isoon! ");
INSERT INTO bswl_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Shiifaayinna goyinaraan, Ayizaab dubba tos boojaami ataminaraan, Iyyerusaalemiinna Ayizaab odonnatii kakkobarisara gees taa gudaroon Ayizaabii odaddarameen linnaraan. ");
INSERT INTO bswl_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Arri, Diginninna barraajja gutii malaata linnara, tabekeenna tagaashimallo yaayekko kakkeeyi, ulii gutii kagira gosa yaadinara, shalagaaminara. ");
INSERT INTO bswl_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Hunna kadaruurenna mankkoɂaaɂinaro maraan, ibaaddo abssiinna alami gutii me kaɂemeeyinara amaa oorataa hashurukki aminara. ");
INSERT INTO bswl_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Hassu goorata ere kaɂibaaddo hunnaayinna taɂatii kabajaa duumanchchaayi emeetaa giraan dinnaraan. ");
INSERT INTO bswl_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Isinna hikki ayees gudatano kakkohaggaɂabro goorata, fayyinnakisin mankkogabbalamero maraan, tukkul uma aallaa, t'ok'k'i ama elddaa wochchaa» ame. ");
INSERT INTO bswl_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ade Yesuusa haa amaa hitta masuussa segee, «Gaa kabalasina kakkalee gaajjol dubba diyaa. ");
INSERT INTO bswl_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Baalalloɂottisoo hurisaa giraan godeetaan, hassu goorata bat't'eessa gabbalamano isin kassanwa. ");
INSERT INTO bswl_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Usumaleenna ade hikki ayees gudatano goddeeten, wononnati kawaa gabbalamano malaba. ");
INSERT INTO bswl_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","«Ani rumminaa amara; hikki dubba lii taaroorroo hitti alattaan lakkoroortto. ");
INSERT INTO bswl_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Daruurnna ulnna roornaraan, haafurakkaakki goɂameen lakkoroorro. ");
INSERT INTO bswl_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Goortta meessa kallikki giri, t'amokokki jiinaanii barsanokonɂi yaadaa wodanattisin goggodillafannonkkona hasse arri wot'amade aani derɂa goggogeenonkko isiɂoottisin oorayeen; ");
INSERT INTO bswl_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Hikki ulii kagiro ibaaddo dubbaa gutii derɂa ginnara. ");
INSERT INTO bswl_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Haanssun kaɂemeetaro dubbakkona isin milik'i goggohessanunna ere kaɂibaaddo horee aallin goggodanddeetanun arggetto ataayeen ebaayen.» ");
INSERT INTO bswl_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesuusana arri arrii k'ulluukki min kawaayi agaalssisaa, hemeen ade zayitii kabeyaara gaa takkoɂalataro wodamii bee barare. ");
INSERT INTO bswl_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Gosa dubbana Yesuusa maalin bullane k'ulluukki min kawaa tos emeetaa gire. ");
INSERT INTO bswl_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Hassu goorata faasikkaa kaɂamamare kababoo baala takkokabajaamira arri gabbalantte gitte. ");
INSERT INTO bswl_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Katuuk'aamol woyichchaalnna seera kamuse oɂagaalssisaran gosa absataa mankkogireen maraan, Yesuusa tayeli lagadiraan raa dootaa gireen. ");
INSERT INTO bswl_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tomonkko lama ofarameeraan wota katootamere kaɂask'orotu ulkokki Yihuudaa s'alaye tabtte. ");
INSERT INTO bswl_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Haanssun Yihuuda, katuuk'aamol woyichchaal tonssa k'ulluukki min kawaa oɂooraran kaɂajajaarokki tos seetegure Yesuusa misii roorisi sisanaro ayeese. ");
INSERT INTO bswl_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Isona hikka ayeesii geggelaateren maragade sisin ekkaaten. ");
INSERT INTO bswl_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Usuna usu ayeesi ekkaate, Yesuusa roorisi isoon sisin gosa takkoginnootii kaɂekkaaro goorata oorataa gire. ");
INSERT INTO bswl_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Esekko abbaabatere kafaasikkaa idaado kakkoɂenɂaamara kababoo baala gee. ");
INSERT INTO bswl_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesuusana, «Kafaasikkaa kita kahemeene noo goggoɂaaminnoo seyeenddeene ekkaasa» ame t'aye P'et'iroosana Yaannisana fare. ");
INSERT INTO bswl_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Isona, «Haggee no goggoɂekkaansson dootatta?» ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Usuna, hikkima, «Isin katamaa tos tabaa giraan uulla tabekee kasidatero ibaaddoti helnnattaan, usu kakkotabaro min taageetaanii debee seyeene. ");
INSERT INTO bswl_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Odo mineenne, ‹Kaɂagaalssisara, inkko oɂagaalssataranne wota kafaasikkaa kita kahemeenee ani takkoɂaamira tammartti banɂee eetitta? Haa amara› ama. ");
INSERT INTO bswl_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Usuna fook'ii gutii yaanttedde taɂekkaattetto taballɂaantti kifilii usu isinuun tusinara eseenna iin ekkaasa» ame. ");
INSERT INTO bswl_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Isona seeteerene usumalee Yesuusa isoon goggosegeerokki malee lee helereene, fasikkaanna esee ekkaasen. ");
INSERT INTO bswl_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Saatinna kakkogeetette goorata Yesuusa ofarameeraanne wota k'ulluukki babo aamin hamas's'ee. ");
INSERT INTO bswl_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Haanna ame, «Ani rakkoo atatanakko horene hikka kafaasikkaa k'ulluukki babo isin wota aamin aaloo halchchaa gire. ");
INSERT INTO bswl_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ani isinuun haa amara, wononnati kawaayi hikkakkotti fureen taagudattoo, hikka kafaasikkaa k'ulluukki babo kallami ani lakkoɂaaminaro.» ");
INSERT INTO bswl_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","T'ugga aate sommaasate abbaabatere haa ame, «Ahɂaay, dubba hikkakko hedeedama, ");
INSERT INTO bswl_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ani isinuun haa amara, giddakko haggaɂabere wononnati kawaa taa emeeroon, hitta tawoyinii ilkko kafelamero t'amo lakkot'aminaro.» ");
INSERT INTO bswl_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Babona keesere Waa sommaasate, ekkaɂebise sisegure, «Hinɂi isin maraan osisamaraan sooɂootteeyyan. Hikka in shaadiin yelayene» ame. ");
INSERT INTO bswl_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Usumaleenna kita kahemeene aameen abbaabaterene t'ugga keesegure haa ame, «Hitti t'ugga isin maraan kaɂubayinaro iigikkeeyi kallinaro ammato oɂusubyaan. ");
INSERT INTO bswl_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ayesuun goɂameen in roorisi kasisinarokotti genetteenne wota yaalɂa orroo gitta. ");
INSERT INTO bswl_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ere kaɂibaaddo t'aye Waa goggomurttessamerokki malee goyinara ayesuun goɂameen usu roorsi kasisinaro hassu ibaaddotin aanne.» ");
INSERT INTO bswl_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Isona, isoɂorrokko hikka haa kayelnnara ayyoyyo isiɂorroo hoosatano haggaɂabeen. ");
INSERT INTO bswl_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Adena iso, no orrokko kanjiinkki ayyoyya amaa usukko oɂagaalssatareen isiiɂorroo dogamaa keeseen. ");
INSERT INTO bswl_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesuusana haa ame, «Kaɂayizaab wonolaal gosakkisoo hunnaa bariisinaran, isoo gutii odonnati oɂabaan ‹Taɂidan ofelaraan amami uumaminaraan.› ");
INSERT INTO bswl_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Isin dollee adi haa aroolleeno. Gohesoon isinkko kanjinkki kalleera kic'c'aar aani, mooti kalleerana kahandaaro aani halleewo. ");
INSERT INTO bswl_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ayesuun goɂameen inne wota, aamoon kahamas'eerokkona aallee kaɂaamisarokko eekiya kajiinatara? Aamoon kahamas'eeroyolla? Ani goɂameen isin orroo kagiro kahandaarokko koo aaniya. ");
INSERT INTO bswl_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Isinna rakkootteekki goorataa inkko kale anbbeenoni iyyee dollee oɂaallitetteenttaan. ");
INSERT INTO bswl_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Aabbokki in goggoshuumeroo aninna ade wononnatikkeeyi isin shuuminara. ");
INSERT INTO bswl_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Hikkina wononnatikkeeyi aamokkeekko goggoɂaanttaanunna goggot'anttanun adena korffinjjee gutii hamass's'iiddeen tomonkko lama kaɂisiraɂeel gosa gutii goggofirdditanunya.» ");
INSERT INTO bswl_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Adena Yesuusa haa ame, «Simoona! Simoona! Gidda, s'alaye isin darggammaa aani baamp'iin Waa hoosatte. ");
INSERT INTO bswl_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ani ade ammanokka goggobaannonkko ku maraan ani Waa ebaaye, atina kakkoɂabbaabatte goorata abbilaalttaa ataayisa.» ");
INSERT INTO bswl_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simoona, «Goottakkee, ani kunne wota shaaminna, goyiin ekkaasayera» ame. ");
INSERT INTO bswl_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesuusana, «P'et'iroosa, hittaari lukkale haɂoyinon giraan, ani usu lakkokaso amidde seed gali in kakayinatta amara» ame. ");
INSERT INTO bswl_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Esekkona Yesuusa, usukko oɂagalssataraaninne «Koroojjoo kallii, shile kallii, keferroo kallii, isin kakkofarere goorata isinuun kahank'k'atere ayees gire?» ame hoosate. Isona «Koonna noon lakkohank'atero» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesuusana haa ame, «Gidda goɂameen korojjoonna, shilena kakkongira ibaaddo haɂabato, shiifa kallikkina sarssikkeessa daddalayire haɂiminato. ");
INSERT INTO bswl_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ani isinuun haa amara, ‹Ommeellanne wota tootaame› amame kas'aafamere iyyee gudayin dootisara, in maraan kas'aafamera kakkogudayinara goorata addeesame geera.» ");
INSERT INTO bswl_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yesuusakko oɂagaalssatareen, «Goottaa! Hikkima shiifa lama hittanii girowa» ameen. Usuna «Leeraan» ame. ");
INSERT INTO bswl_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesuusa goggokasanaaye zayitii kabeyaara gaa takkoɂalataro wodami tos seete, usukko oɂagaalssatareenna usu debee seeteen. ");
INSERT INTO bswl_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Eserraanna kakkogeyaanne goorata, Yesuusana, «Isin c'aafiti orroddi goggotaboonkko ebaayen» ame. ");
INSERT INTO bswl_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Isokkona eɂemo shafamere seete kakkoɂeyaaro gitakki fakki amere gilbbise ebaate, ");
INSERT INTO bswl_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Haanna ame, «Aabbokkee, feɂittaa golleete, hitta tarrakkoo t'ugga inkko aatina. Ayesuun goɂameen feɂittee halleenoon giraan feɂitta halleeto.» ");
INSERT INTO bswl_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Erggichcha daruurkko usuun mutegure usu ataayise. ");
INSERT INTO bswl_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Aaloo muddamere ataate ebaataa gire. Foggolo kaɂatii Iigikokki c'ac'c'ark'aatano aani ulii ubataa gire. ");
INSERT INTO bswl_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ebikkona keegure usukko oɂagaalssataran tos emeete, isona yaadakko kakkokkeeyi ohuddureeraan helere haa ame. ");
INSERT INTO bswl_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","«Muun huddurtteettaan?» C'aafiti orroddi goggotaboonkko «Kiyaaddeen ebaayen ame.» ");
INSERT INTO bswl_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Usuna ganaa ayeesaa giraan, kammooggan ibaaddo emeete. Tomonkko lamakko koo Yihuuda kaɂamamere ibaaddoti horehaye geggesaa gire, anggayiinna Yesuusa tos gabbalame. ");
INSERT INTO bswl_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yesuusana ade, «Yihuuda, Ere kaɂibaaddo anggatanoyi roorisi sisinatta?» ame. ");
INSERT INTO bswl_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesuusa maraamureen ogireen usukko oɂagaalssatareen ayees tallaaro deengureen «Goottaa, shiifayi goonssu?» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Isokkona koo katuuk'aamol woyichchaalun kahandaarokko basegure nebe tamergge goose. ");
INSERT INTO bswl_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesuusa ade, «Iisa! Hikka aankkikki ayees aroofeltteen ame.» Taɂibaaddotii nebena dinegure fayyiise. ");
INSERT INTO bswl_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Esekkona Yesuusa abin oɂemeteeren katuuk'aamol woyichchaal, k'ulluukki min kawaa oɂooraran kaɂajajaaronena jaarsoleenne haa ame. «Shittaa kaɂabinaro ibaaddo aani, shiifana duullaa abtteddeen emeetteen? ");
INSERT INTO bswl_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Arggetto k'ulluukki min kawaayi isin wota takkogiree in lakkoɂabtetteen. Hikki goɂameen mugud kakkoreedero goratakkisinya.» ");
INSERT INTO bswl_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Esekko abbaabateren Yesuusa abeen geesen. Tuuk'aamon odonnati kaɂabokokki min tos tabseen. P'et'iroosana fakkime usu debee sesseetaa gire. ");
INSERT INTO bswl_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ibaaddo katuuk'aamol woyichchaalkokki awud orroo eleen beebiseneen koolleen hamas's'eereen giraan, P'et'iroosana iso wota hamas's'ee gire. ");
INSERT INTO bswl_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Diyyiti too P'et'iroosa eleen dollee kahamas'eero tichchisse deetedde «Hikki ibaaddoti ade Yesuusa wota gire» antte. ");
INSERT INTO bswl_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","P'et'iroosa ade, «Ati heleelttiti, ani usu lakkokaso» ame kakate. ");
INSERT INTO bswl_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Abaraan gac'c'imere kakkalee ibaaddoti koo usu deere, «Atina adde isokko kootta» ame. P'et'iroosa goɂameen, «Ati ibaaddoti, lakkoɂaniyyo» ame. ");
INSERT INTO bswl_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Saatii too gita gac'c'imere kakkalee ibaaddoti ogiraan, «Hikki ibaaddoti kagaliila mankkollee maraan hedatano kallii Yesuusa wota gire» ame. ");
INSERT INTO bswl_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","P'et'iroosa ade, «Ati ibaaddoti ati kaɂayeesatto ayees ani lakkokaso» ame. Hikkana ayeesere ganaa hagudisoon giraan lukkale oye. ");
INSERT INTO bswl_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Goottaa Yesuusa kambbal amere P'et'iroosa dee; P'et'iroosana, «Hittaari lukkale haɂoyinon giraan seed gali in kakayinatta» ame, Goottaa usuun kaɂayeesero haafura k'alli ame. ");
INSERT INTO bswl_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","P'et'iroosana sar beegure yururu ame oote. ");
INSERT INTO bswl_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yesuusa abeen oora ogireen ibaaddojja k'ac'c'ifataanna usu basano haggaɂabeen. ");
INSERT INTO bswl_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Iilɂona golisereene, «Alla kahegeroo golleete, ku kabase ayyoyya noon segii?» amaa usu hoosataa gireen. ");
INSERT INTO bswl_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Usu habaaraanna yeraasaa gireen. ");
INSERT INTO bswl_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ul kakkobareere goorata, jaarssa kaɂulee, tuuk'aamokokki woyichchaalnna seera kamuse oɂagaalssisareen raattoo kukkuɂameen, Yesuusa taɂayihuudi shonggoo tos geesen. ");
INSERT INTO bswl_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Isona, «Ati kafayyisaro Kiristoosatta? Alla segin» ameen. Yesuusana haa ame. «Ani isinuun gosegeenna isin in lakkoɂammanayinattaan. ");
INSERT INTO bswl_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Isin gohoosayena iin lakkoɂabbaabinattaan. ");
INSERT INTO bswl_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ayesuun goɂameen hittakko haggaɂabere Ere kaɂibaaddo hunnaa kawaakotti merggee hamas's'inara.» ");
INSERT INTO bswl_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Hassu goorata dubbana, «Hayya, ati Ere kawaatta?» ameen. Yesuusana, «Laanokkee hikkima isinwa segaattaan» ame. ");
INSERT INTO bswl_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Isona, «Goortta kakkalee atonnati me dootisara? Noo metekkaanuun hiɂiteessakko maalnnenna!» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Esee kukkuɂamere kagire ibaaddo dubba keegure Yesuusa P'ilaat'oosa tos geesen. Haa amaanna mooto haggaɂabeen. ");
INSERT INTO bswl_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","«Hikki ibaaddoti gosakkaani sossoyisaa, K'eesaariwun giira goggomuramonkko tiraa, adena, ani Kiristoosa kafayyisaro wonoya amaa giraan helnnenna.» ");
INSERT INTO bswl_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","P'ilaat'oosa, «Ati kaɂayihuudi wonotta?» ame Yesuusa hoosate. Yesuusana ii «Ati goggoɂamattooya» ame. ");
INSERT INTO bswl_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Esekkona P'ilaat'oosa katuuk'aamol woyichchaalnena gosane, «Ani hikka ibaaddoti gutii baas koonna lakkohelero» ame. ");
INSERT INTO bswl_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Iso adeen, hikki ibaaddoti Galiilakko haggaɂabere hitta taageero ul kayihuuda dubba haheesooni gosa agaalssisaa shalagaara ameen ataayiseen ayeeseen. ");
INSERT INTO bswl_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","P'ilaat'oosana hikka kakkomaalare goorata, «Hikki kagaliila ibaaddotiya?» ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yesuusa kaheredoosa k'alaadakko kaɂemetero laano P'ilaat'oosa kakkoɂaddeesere goorata, Herodoosa hassu almmaa Iyyerusaalemii mankkogire maraan Yesuusa Herodoosa tos fare. ");
INSERT INTO bswl_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heredoosana Yesuusa din kamooggan goorata dootaa mankkogire maraan, Yesuusa kakkodeyaare goorata aaloo geggelaate. Garakkeessakki ayees maale mankkogire maraan usu baasa gofele din abddi yelataa gire. ");
INSERT INTO bswl_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodoosa hoosin tammooggan Yesuusa hoosate, usu goɂame toonna lakkoɂabbaabero. ");
INSERT INTO bswl_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tuuk'aamokokki woyichchaalnna seera kamuse oɂagaalssisaran esee aalleerene ataayiseen mootaa gireen. ");
INSERT INTO bswl_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodoosa wotaadaralkeessa wota usu tuffii k'ac'c'ifate, kakkabajaa sarssi sarssisegure P'ilaat'oosa tos fare. ");
INSERT INTO bswl_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Heredoosana P'ilaat'oosa eserri saatintte nak'ateen, t'aye goɂameen iso orroo k'uut't'e abanaayen. ");
INSERT INTO bswl_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","P'ilaat'oosana tuuk'aamokokki woyichchaal, kaɂayihuudi mootijjolnna gosana raattoo kukkuyisere, ");
INSERT INTO bswl_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Haa ame, «Hikki ibaaddoti gosa meellanewuun kekkeesara' antteddeen usu in tos keentteetten, aninna isin horee ayees k'ulleesseere, isin kakkeenttetteen mooton baas koonna lakkohelero. ");
INSERT INTO bswl_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ade Herodoosa usumalee koonna helano waatti noo tos usu abbaabera. Isin goggodiyaattanii hikki ibaaddoti goyin kageegisiro koonna ayees lakkofelero. ");
INSERT INTO bswl_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Haanssun ani usu boc'c'iire furnnara.» ");
INSERT INTO bswl_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Hikka usu kakkoonɂamere kafaasikkaa baalayi ibaaddoti koo shaanokko goggofuramiroo mankkodootisare maraanye. ");
INSERT INTO bswl_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Gosana dubba raattoo leere, «Hikka ibaaddoti lagadi! Barbaane noon furi!» amaa iyyeen. ");
INSERT INTO bswl_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barbaanena katamaa orroo gosa meellaneeyi kekkeesanoyinna neefo lagadanooyi kashaamere ibaaddotiye. ");
INSERT INTO bswl_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","P'ilaat'oosana Yesuusa furin mankkodootere maraan, ade abbaabe gosa ayeesise. ");
INSERT INTO bswl_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Gosa goɂameen, «Suyiina! Suyiina» amaa iyyaa gire. ");
INSERT INTO bswl_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","P'ilaat'oosana seed gale, «Mewuun? Hikki ibaaddoti kafelera baas meyya? Usu kallagassisiro baas koonna ani lakkohelero, haanssun boc'c'iire furnnara» ame. ");
INSERT INTO bswl_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Iso goɂameen yaayetisoo t'ok'k'iɂiseene Yesuusa goggosuwaamiro ataayiseen usu ebaaten, iyyakisona awodate. ");
INSERT INTO bswl_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Haanssun P'ilaat'oosa iso kahoosateran feloo goggohayiroon firddee. ");
INSERT INTO bswl_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Gosa meellaneeyi kekkeesaanna neefo lagadano shaame kagire, goggofuramiroo kaɂebaatenaan aankki Barbaane fure. Yesuusa ade iso tageelateen goggoyelarawun roorise sise. ");
INSERT INTO bswl_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yesuusa abeen geesa giraan, Simoona kaɂamamere kak'ereena ibaaddoti gat'arekko kaɂemeetaro heleengureene masik'alii sidiseeren Yesuusa debee goggoseero abeen hunnoomen. ");
INSERT INTO bswl_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kamooggan gosana geegiyotattisoo babbasataa kaɂootare heleelnna Yesuusakko haarre debee sesseetaa gireen. ");
INSERT INTO bswl_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesuusa ade iso tos kambbal amere haa ame, «Isin kaɂiyyerusaalemi heleel isiɂoottisinuunna yiiskkisinuun ooyeene kuwaarre iyyeen arooɂootteen. ");
INSERT INTO bswl_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","‹Hikkima maseenajjoolnna taɂumuloon gitta gedeemi, haɂiilisooni ogiraan naasasso osommaasameenyan› isin kakkoɂanttaan goorata emeeyinnara. ");
INSERT INTO bswl_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Hassu gooratana, iso ‹Wodamiilnne «No gutii iyaa» gaagajjolunna «No golisa aminnaraan.» › ");
INSERT INTO bswl_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Goortta gaa unjjanekki haa goyeleen, kaɂangage adi misi yelinnaren?» ");
INSERT INTO bswl_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Usune wota lagadin okkalee baas ofeleraan lama aateen seeteen. ");
INSERT INTO bswl_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","K'eraanyo taɂamanttette banɂee kakkogeyaaren goorata suyyeen, baas ofeleraanna koo mina tamerggenne koo mina tabetene suyyeen. ");
INSERT INTO bswl_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesuusana, «Aabbokkee! Iso kafelaraanna lakkokasaan isoon haheso amina» ame. Isona sarssikeessa it'aayi hedeedameen. ");
INSERT INTO bswl_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Gosana aalleere diyaa gire. Ayihuudikokki woyichchaalnna, «Kakkalee ibaaddo fayyiisera. Waayi kaɂassaabamero Kiristoosa gollee, alla usu isiɂoottessa hahasato» amaa k'ac'c'ifateen. ");
INSERT INTO bswl_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Wotaadaralnna gabbalamere kaɂokokootaro t'amo kawoyinii sisaanna k'ac'c'ifataa gire. ");
INSERT INTO bswl_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","«Ati kaɂayihuudi wono golleete, isiɂoottaa haasa amaa gireen.» ");
INSERT INTO bswl_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Metekkeessakko guuntte masik'alii gutii, «Hikki kayihuuda wonoya» taɂamatta s'uufi gitte. ");
INSERT INTO bswl_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Felo omeellan feleerene osuwaameereenkko koo, «Ati la kafayyisaro Kiristoosattolla? Alla, isiɂoottaanna nonna haasi» amaa habaaraa gire. ");
INSERT INTO bswl_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kallamikkina goɂameen haa ame usu hadise; «Noo amalekkookki firdda atataa giranttii, ati duuddo Waa lakkoɂabssaattoya? ");
INSERT INTO bswl_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","No ofelnnenno felooyi murroo oɂatatanno mankkolleenenno maraan, kadootisaro firdda gutii ginna. Hikki ibaaddoti goɂameen koonna kameellan ayees lakkofelero.» ");
INSERT INTO bswl_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Adena, «Yesuusaa, wononnatikkaayi kakkoɂemeette goorata in shaadina» ame. ");
INSERT INTO bswl_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesuusana, «Ani rumminaa amara, hittaari inne wota gannatee girnnatta!» ame. ");
INSERT INTO bswl_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Hassu gooratana saatii le kalleeroye, saatii saagaal taageetoo ul dubbaayi gutii mugud lee. ");
INSERT INTO bswl_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Arriti mugud leete, k'ulluukki min kawaakokki goggolo fiilame lama banɂe bee. ");
INSERT INTO bswl_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesuusana yaaye taɂatiiti iyyee, «Aabbokkee, ayyaanakkee ani genettaayi sisatara!» ame. Haanna amere goye. ");
INSERT INTO bswl_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Wotaadara booluun woyichchana kalleero ayees kakkodeyaare goorata, «Hikki ibaaddoti ogiraan k'ulluukkiye» amere Waa galatee. ");
INSERT INTO bswl_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Hikkana din ese banɂe kukkume kagire ibaaddo dubbana kalleero ayees kakkodeyaare goorata geegiyottiso bobboc'aata min abbaabateen. ");
INSERT INTO bswl_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ayesuun goɂameen Yesuusa aaloo okasanayeen dubba usumalee Galiilakko kayere debee kasessetare heleel hikka diyaa fakkime aallee gire. ");
INSERT INTO bswl_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ayihuudikkotti shonggoo una kalleere Yoosefa kaɂamamere kaɂidankkinna k'ulluukki ibaaddoti gire. ");
INSERT INTO bswl_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Hikki ibaaddoti tashonggoo markkaanna ofelareen felo wota lakkolleere. Usuna Armaatiyasi taɂamantette tayihuuda katamaakokki ibaaddoti golleero, wononnati kawaakotti emeeto oorataa gire. ");
INSERT INTO bswl_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Hikki ibaaddotina P'ilaat'oosa tos seetere rees kayesuusa ebaate. ");
INSERT INTO bswl_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Usuun feɂi kakkosisamatte gooratana rees dagisere tak'amal gashee iidisere, eɂemokko k'orame felame kaɂekkaatero duuddo maayona k'amalamooni takkogiro banɂee k'amale. ");
INSERT INTO bswl_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Arrina takkoɂekkaasatanan arrite. Ayihuudin tafoolssi arri haggaɂabiin laatte. ");
INSERT INTO bswl_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galiilakko kayere Yesuusa wota kaɂemetere heleelnna debee sesseetaa tak'amal banɂe dee. Reesinna misii k'amaleeran dee. ");
INSERT INTO bswl_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Esekko minkkisoo abbaabateren shittonna k'ibaati reesun ekkaasen, seera goggosegaarokki malee Ayihuudin tafoossi arri foolssateen. ");
INSERT INTO bswl_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Almmakko tahoree arrii heleel taɂekkaasateraan shittoo abere ul bullaɂowaa giraan k'amal tos seete. ");
INSERT INTO bswl_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","K'amal guukko kaɂotottoolero eɂemo deen. ");
INSERT INTO bswl_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Orroddeen kakkotabareen goorata ade Goottaa Yesuusakokki rees lakkoheleen. ");
INSERT INTO bswl_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Usu ayeesii girddi ameen giraan, aaloo kahank'aaro sarssi osarssateeraan ibaaddojja lama derɂa iso dollee aalleen. ");
INSERT INTO bswl_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Heleeljana abssikko kakkeeyi hussi ameen giraan, ibaaddojja haa ameen «Arddokki kalleero usu k'amal orrokko muun dootaattan? ");
INSERT INTO bswl_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Usu keera! Hittanii lakkogiro, adena Galiilaayi takkogiree me usu isinne amero shaada. ");
INSERT INTO bswl_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‹Ere kaɂibaaddo gene tac'ubbaalessaayi roori sisamin, suwaamiinna taseedi arri goyikko kiin dootisara› ame gire.» ");
INSERT INTO bswl_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Heleelnna hassu goorata haafura kayesuusa shaade. ");
INSERT INTO bswl_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Heleelnna banɂe tak'amalkko abbaabatere hikka ayees dubba tomonkko koowunna kakkalee ibaaddo dubbaan segeen. ");
INSERT INTO bswl_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Hikka ayees ofarameeraawun osegeeraanna, kamegidella ulkotti Mayiraame, Yohaana, Aaye tayayik'ooba Mayiraaminee isone wota kakkalee heleelnna gire. ");
INSERT INTO bswl_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Iso goɂameen heleel kaɂayeesere ayees kadanddowaraan aani isoon mankkollee maraan lakkoɂabddateren. ");
INSERT INTO bswl_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","P'et'iroosa goɂameen keegure k'amal tos tiiyye. Eserraa geegurena hussi amere orroddi gowochchiro gashe taalaal girano dee. Kalleero ayesuun mamaa minkkeessa abbaabate. ");
INSERT INTO bswl_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ese arri Yesuusakko oɂagaalssatareenkko lama, Iyyerusaalemikko kuma tomonkko koo tallabssi gitakki fakki kaɂame, Emahusi kaɂamamaro maaman tos seetaa gireen. ");
INSERT INTO bswl_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Isona kalleero ayees dubba isi isisiɂorroo ayeesaa gireen. ");
INSERT INTO bswl_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ayeesaanna sessettaan gutii giraan Yesuusana iso tos gabbalamere isoneta seetano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ayesuun goɂameen iso usu goggoɂaddeesonkko ilɂoɂoottiso abameen gireen. ");
INSERT INTO bswl_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesuusa, «Isin sesseetaa giraan, raadii isi isiɂorroo haa kaɂayeesatteen meyya?» ame. Isona aaloo yaada orro tabeen tollimeen aalleen. ");
INSERT INTO bswl_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Isokkona koo, K'eliyoop'a kaɂamamere, «Hinɂa arrijjoolii hittanii Iyyerusaalemii kalleero ayees kakkasoon, ati uluun marttitta?» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesuusa, «Kalleera ayees meyya?» ame. Isona haa ameen. Waayinna ibaaddo dubba hore felooyinna haafuraayi kaɂatii kahegeroo mankkolleere maraan, «Hikkina kanaazireti Yesuusa gutii kafelamero ayeesiya. ");
INSERT INTO bswl_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Usu tuuk'aamokokki woyichchaalnna mootijjolkaani goyikokki firddaan usu rooriseen siseen, suyeen. ");
INSERT INTO bswl_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","No andde kaɂisiraɂeel gosaawun wodoo leerowa aminne abddi kayelannenne usuye. Kakkaleekkona ade, hikki haa golleekko hittaari arri taseeditta. ");
INSERT INTO bswl_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Adena no orrokko heleel kookkoo no mamise, isona bullane k'amal tos seetereen. ");
INSERT INTO bswl_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Reesinna kakkowaatareen goorata emeeteren ‹Yesuusa neefone gira› oɂamaraan erggichchaal raaga deenne amaa abbaabateen emeeten noon segeen. ");
INSERT INTO bswl_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","No orrokko kookkoo k'amal tos seetere, likkii heleel goggoɂameroo kalleero deen. Yesuusa ade lakkodeeren.» ");
INSERT INTO bswl_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesuusa haa ame, «Isin gowoolee ibaaddo, wodanatisinna kahegerool kaɂayeesenaan dubba ammanatana waattii adallaatte, ");
INSERT INTO bswl_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kiristoosa hikka ayeesi hitta rakkoo atatanona kabaja tos tabano lakkodootisaroya?» ");
INSERT INTO bswl_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Musekkona kahegeroo dubbakko haggaɂabere k'ulluukki mas'aafajjool garakkeessa kas'aafamero tusaa fure segee. ");
INSERT INTO bswl_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kaseetaren maaman kakkogabbalamereen goorata, Yesuusa iisi karoorinaro aani lee. ");
INSERT INTO bswl_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Iso addeen, «Arriti iite buyitetta, ul hemeen laara, haanssun noonne wota hittanii bari!» ameeren ataayiseen ebaaten. Haanssun isoneta barin tabe. ");
INSERT INTO bswl_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Isoneta babo aamin kakkohamas's'eere goorata babo keesere Waa galateere ebise isoon sise. ");
INSERT INTO bswl_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Usu goorata Iilɂoɂoottiso banamereen Yesuusa laano addeesen, usuna isokko siyame. ");
INSERT INTO bswl_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Isona, «No raadii giraan, no ayeesisaa k'ulluukki mas'aafana bane agaalssisaa, wodanattaani gubataa lagittella?» ameen. ");
INSERT INTO bswl_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Usu goratawa keengureene Iyyerusaalemi abbaabateen seeteen. Tomonkko koo usukko oɂagaalssataranna okkalee isone wota koolleen kukkumeen ogiraan heleen. ");
INSERT INTO bswl_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Isona, «Goottaa Yesuusa ogiraan keera! Simoonanna mutera» amaa gireen. ");
INSERT INTO bswl_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Yesuusakko oɂagaalssatareen lama raadii kalleero ayeesina Yesuusa babo ebise kakkosisare goorata misii isoon addeesamero segeen. ");
INSERT INTO bswl_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Iso hikka ayeesaa giranttii, Yesuusa iso orroo aalleere, «Nogodda isinuun halleeto» ame. ");
INSERT INTO bswl_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Iso ade neengureene abssateen. Gaari kaddeeran aani isoon lee. ");
INSERT INTO bswl_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yesuusana haa ame, «Muun niyattaan? Wodanattisinii muun hedaattan? ");
INSERT INTO bswl_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Genennoɂootteenna luk'ak'k'oɂoottee diyaa, aniwayya. Ada in dina diyaa, in gutii goggodiyaattanii gaari soonna lefaalnna lakkoɂabtto.» ");
INSERT INTO bswl_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Hikka amegure genennona luk'k'ana isoon tusate. ");
INSERT INTO bswl_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Isona geggelokkona mamanokko kakkeeyi ganaa haɂabddannon giraan, «Hittanii kooko kaɂaamiraan abttaane?» ame. ");
INSERT INTO bswl_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Isona eleenii kadubamero kunɂubkko usuun siseen. ");
INSERT INTO bswl_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yesuusana atatere iso hore aame. ");
INSERT INTO bswl_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Usuna, «Ani isinneta takkogiree, seera kamuseeyi, kahegeroolnna mazamurikokki mas'aafayi in maraan kas'aafamere dubba gudayin dootisara ame ani isinuun kasegeere haafurakki hikkaya» ame. ");
INSERT INTO bswl_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Usu goorata k'ulluukki mas'aafajjolii goggoshaadinawun sammuutisoo bane. ");
INSERT INTO bswl_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Haanna ame, «Kiristoosa rakkoo atayinara. Taseedi arrina goyikko kinnara. Haa amame mas'aafa k'ulluukkii s'aafamera. ");
INSERT INTO bswl_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Iyyerusaalemikko haggaɂabere gosa dubbaan c'ubbokko gula galanona c'ubbo haheso amamano megekkeessayi lallabaaminara. ");
INSERT INTO bswl_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Isinna hikkanun atottaan. ");
INSERT INTO bswl_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Aninna Aabbokki tasisero abddi isinuun farnnara. Isin adi elekko hunna taaɂatattaanii Iyyerusaalemii gira.» ");
INSERT INTO bswl_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Esekko abbaabatere Yesuusa usukko oɂagaalssataran katamaakko beesere Bitaanya taageero aate bee. Genennoɂoottessana keesere iso sommaasate. ");
INSERT INTO bswl_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Iso galataa giraanna, isokko assaabame daruur tos bee. ");
INSERT INTO bswl_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Isona sagadeen, geggeloo oɂatiitinna Iyyerusaalemi tos abbaabateen. ");
INSERT INTO bswl_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Waa galataa arggetto k'ulluukki min kawaayi gireen.");
INSERT INTO bswl_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Horaarjje haafura gire, haafurana Waa dollee gire, haafurana Waayye. ");
INSERT INTO bswl_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Usuna horaarjje Waanneta gire. ");
INSERT INTO bswl_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kameen dubbana usu tonsse met't'aame, kamet't'aamero dubbakkona usu kallayii kamet't'taamera koonna laagiro. ");
INSERT INTO bswl_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Neefo usuu gitte, hitti neefona ibaaddoon ifatte. ");
INSERT INTO bswl_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ifana mugudii hank'k'aara, mugudnna lakkoɂawodaro. ");
INSERT INTO bswl_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Waakko kafaramera Yaannisa kaɂamamare ibaaddoti koo gire. ");
INSERT INTO bswl_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ibaaddo dubba atonnatikkeessa maalire garakkeessane goggoɂammaniroon, ifa maraan ato liin emeete. ");
INSERT INTO bswl_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ifa maraan ato liin emeetera kuwaarre usu ussun ifa lakkoye. ");
INSERT INTO bswl_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ibaaddo dubbaan ifa kasisaro kalleera karrummii ifa alami tos emeetaa gire. ");
INSERT INTO bswl_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Usu alami orroo gire, alami kakkomet't'aamera usuu golleenna, alami ade usu lakkoɂaddeesere. ");
INSERT INTO bswl_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Kakkeessa kalleero tos emeete. Fallikkeessana ade usu lakkoɂatatero. ");
INSERT INTO bswl_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Halleewo kuwaarre oɂatateeraawunna megekkeessaa oɂammanaran dubbaawun ade ere kawaa takkoleeran feɂi sisera. ");
INSERT INTO bswl_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Isona Waakko umulameenan kuwaarre, taɂiige goorttun tasooye feɂi goorttun tababbaar feɂikko lakkoɂumulameraan. ");
INSERT INTO bswl_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Haafurana ibaaddo lee; sinonna rummii ammagame noo orroo baree. Aabbokkeessa dollekko kaɂemeetero, ere kookkotti kabajja noo deenne. ");
INSERT INTO bswl_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yaannisana, «Inkko haarre kaɂemeetara inkko horeene mankkogire maraan inkko roorara ame ani kakkoonɂatotaare hikkanunya» amaa iyyee usu maraan atotee. ");
INSERT INTO bswl_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Sinottessa ammagamanokko kakkeeyi no dubbana sinoo gutii sino atannenna. ");
INSERT INTO bswl_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Waa seera gara kamusene sisere, sinona rummina adde gara kayesuusa Kiristoosane emeete. ");
INSERT INTO bswl_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Suurewana Waa kaddeera maayyona laagiro, ayesuun goɂameen Waa Odo dollee kagire ere koo kalleera Hedo usu noon addeesise. ");
INSERT INTO bswl_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ayihuudina, «Ati ayyotta?» ami goggohoosarawun tuuk'aamolnna woyyuul Iyyerusaalemikko usu tos kakkofaraneen, goorata Yaannisa kasisera atonnati hikkaye. ");
INSERT INTO bswl_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Atotaanokkona haar lakkogale; «Ani Kiristoosa lakkoyo» ame addeesise atotee. ");
INSERT INTO bswl_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Isona, «Hayya ati ayyotta? Eelaasatta?» ameen hoosaten. Usuna, «Lakkoyo» ame. Isona, «Hayya kahegerootta?» ameen. Usuna, «Lakkoyo» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Isona; «Hayya ati ayyotta? Ati kafarttette ibaaddoon abbaab noo goggosinssoo isi oottaawun mematta?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yaannisana kahegeroo Isiyaasaa goggosegameroo, «Goottawun raa ‹Ekkaasa amaa k'alullattokki ulii taɂiyyaatte yaaye aniyya› » ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Farasaawilkko ofarameeranna, ");
INSERT INTO bswl_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Haanna ameen; «Hayya Kiristoosa goorttun Eelaasa goorttun kahegeroo golleenon muun t'ammak'aatta?» ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yaannisana, «Ani bekee t'ammak'aara, isin kakkasoonna ade isin orroo aalleera ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Inkko danbbenne kaɂemeetara, ani keferro oottessakokki shaano furin kakkodaaddeennoon usuya.» ");
INSERT INTO bswl_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Hikki dubba kalleera Yaannisa t'ammak'aa takkogire Yorddaanoskko, gamaa tabittaaniya katamaayiyye. ");
INSERT INTO bswl_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Yaannisa tallami arri, Yesuusa usu tos kaɂemeetaro deere haa ame, «Hikkima! Alamikokki c'ubbo kabbaasara idaado kawaa, ");
INSERT INTO bswl_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","‹Inkko haarre kaɂemeetara inkko horeene mankkogire maraan inkko roorara› ani isinuun kaɂamare usuya. ");
INSERT INTO bswl_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ani metekkeewun lakkomalabere, bekee t'ammak'aa kaɂemeeyerana usu Isiraɂeel orroo goggomutiroonya» ame. ");
INSERT INTO bswl_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Esekkona Yaannisa, «Ayyaana arabe aani daruurkko dagere usu gutii hamas's'aa giraan dee. ");
INSERT INTO bswl_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ani metekkeewun lakkomalabere ayesuun goɂameen bekee goggot'ammak'iroo kafarerana, ‹Ayyaana K'ulluukki kat'ammak'aara, Ayyaana dagaanna usu gutii hamas's'aa kamutara usuya› ame. ");
INSERT INTO bswl_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Aninna hikka deera, usu Ere kawaa laano atotinara» ame atonnati sise. ");
INSERT INTO bswl_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tallami arri Yaannisa Yesuusakko oɂagaalssatareen lamane wota ese banɂee aallee gire, ");
INSERT INTO bswl_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yaannisa Yesuusa esene rooraa giraan deere, «Hikkima idaado kawaa!» ame. ");
INSERT INTO bswl_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Lama Yaannisakko oɂagaalssatareenna Yaannisa hikka ayeesaa giraan maaleeren Yesuusa debee sesseeten. ");
INSERT INTO bswl_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesuusana kamabbal amere usuu debee osesseetaran deere, «Me dootaattan?» ame hoosate. Isona, «Rabbi, haggee gitta?» Ameen, «Rabbi» amano kaɂagaalssisaro amanoya. ");
INSERT INTO bswl_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Usuna, «Koyeen diyaa» ame. «Haanssun seeterene usu mankkogiro deen,» eserrina usu wota hayeen, arriikkona saatii tomonkki goorata lee gire. ");
INSERT INTO bswl_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yaannisa kaɂayeesero maaleen; Yesuusa debee osesseetaren lamakko koo kasimoona P'et'iroosakokki abbi Indiraasa gire. ");
INSERT INTO bswl_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Indiraasa horaarjje abbikkeessa Simoona helere, «Noo mesihi helannenna» ame, «Mesihi» amano Kiristoosa amanoya. ");
INSERT INTO bswl_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Yesuusa tonssa keene. Yesuusana deegure, «Ati kayoona ere Simoonatta, kefa amami uumaminatta» ame, «Kefa» amanona P'et'iroosa goorttun «eɂemo» amanoya. ");
INSERT INTO bswl_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tallami arri, Yesuusa Galiila tos seeyin goosate, Filp'oosana helere, «Indebee sesseena» ame. ");
INSERT INTO bswl_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filp'oosana Indiraasa P'et'iroosa aani kabeetesayida katamaakokki ibaaddotiyye. ");
INSERT INTO bswl_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filp'oosa Naatinaɂeeli helere, «Musena kaseera mas'aafayi, kahegeroolnna usu maraan kakkoons'aafeeren kayoosefa ere kanaazireti Yesuusa helannenna» ame. ");
INSERT INTO bswl_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Naatinaɂeelina, «Naaziretikko kaɂidankki ayees helamin daanddaara?» ame. Filp'oosana, «Emeedde deena» ame. ");
INSERT INTO bswl_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesuusana Naatinaɂeeli usu tos kaɂemeetaro deere, «Hikkima, meellane kallayikki karrummii Isiraɂeeltti» amaa gara keessa ayeese. ");
INSERT INTO bswl_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Naatinaɂeelina «Ati in misii addeesse?» ame Yesuusa hoosate. Yesuusana, «Ati gaa kabalasi hegelii giraan, ganaa Filp'oosa ku haɂuumoon giraan ani ku deera» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Naatinaɂeelina abbaabere, «Kaɂagaalssisatto! Ati ere kawaatta, ati kaɂisiraɂeel wonotta» ame. ");
INSERT INTO bswl_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesuusana, «Ati Kaɂammanttetta, kabalasi gaa hegelii ani ku deera mankko amero maraanya? Ganaa hikkakko karoore ayees ati deeta» ame. ");
INSERT INTO bswl_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Adena, «Ani rumminaa rumminaa amara, daruur bananttedde, erggichcha kawaa Ere kaɂibaaddo gutii korataanna dagaa giraan dinnattaan» ame. ");
INSERT INTO bswl_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Taseedi arri tagaliila awuraajjaa, tak'aana katamaayi haassino gitte, Aaye tayesuusana esee gitte, ");
INSERT INTO bswl_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesuusana usukko oɂagaalssatareenna banɂe tahaasinoo uumameen gireen. ");
INSERT INTO bswl_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","T'amo kawoyinnii kakkogudatare goorata Aaye tayesuusa, «T'amo kawoyinnii gudatelle antte.» ");
INSERT INTO bswl_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesuusana, «Ati heleelttiti ani me goggoyelloo dootatta? Gooratakki ganaa lakkogeero» ame. ");
INSERT INTO bswl_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Aayetteessana esee ogireen ohandaaraawun, «Usu kaɂamaro dubba fela» antte. ");
INSERT INTO bswl_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kaɂayihuudi kahurufa seera malee, todobaatamkko kenkko taa boolnnee tomonkko ken liitiroo kaɂabara toossa lewo esee gire. ");
INSERT INTO bswl_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesuusa ohandaaranne «Toossaalii beke ammaga» ame. Isona toossaalii hiɂi geegiseen ammageen. ");
INSERT INTO bswl_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Usuna, «Guukko hummuusaddene min kahaasinokki aamoonna t'amoon odonnati kaɂaboon sisa» ame. Isona usu goggosegeerokki malee yeleen. ");
INSERT INTO bswl_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Odonnati kaɂabanaayekkina t'amo kawoyinii tos oɂiggilssameraan beke hummuge dee. Golleenna eetikko emeteeraan lakkoɂaddeesero, beke ohummuseraan ohandaareen adeen kasanayenwa; usuna kamashashee kale uumere, ");
INSERT INTO bswl_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","«Ibaaddo dubba horaarjje karoorisara kaɂidankki t'amo kawoyiniiyya, ibaaddona aaloo t'ame abbaabatere kadanbbee t'amo kawoyinnii roorisara ati adde kaɂidankki t'amo kawoyinnii gidda gin kayitetta» ame. ");
INSERT INTO bswl_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesuusana hikka baasakki malaataalkko kahoree tagaliila awuraajjaa K'aana katamaayi fele, kabajana tuse, usukko oɂagaalssatareenna usuu ammaneen. ");
INSERT INTO bswl_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Esekko abbaabatere Yesuusa Aayetteessanee, abbilaalteessanee, usukko oɂagaalssatarenne wota kak'ifirenaahoomi maaman tos dage, eseenna arri tic'c'ar hamas's'een. ");
INSERT INTO bswl_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kaɂayihuudi baala kafaasikkaa goggogabalamee, Yesuusa Iyyerusaalemi tos bee. ");
INSERT INTO bswl_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","K'ulluukki min kawaakkotti ali orroo giddijjool, idaadjjoolnna arabejjool odaddalatareen usumaleenna hamas's'een maragade iggilissataa kadaddalatare ibaaddo hele. ");
INSERT INTO bswl_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Hassu goorata t'ork'aaye harɂe ekkaasere idaadjjoolnna giddijjool dubba min kaɂebikkotti ali orrokko horoore, maragade oɂiggilissatanenna maragadekisoo darɂee, t'arap'eezzalnna keese lugude. ");
INSERT INTO bswl_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Arabe odaddalatareenenna, «Hittakko beesa; Aabbokkeekki min kaddookki min arooyeltteen!» ame. ");
INSERT INTO bswl_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yesuusakko oɂagaalssatareenna, «Min kaawun tagitta idane gubatta» amame kas'aafamera isoon shaadame. ");
INSERT INTO bswl_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ayihuudina, «Hikka dubba felanokaawun me malaata noon tusinatta?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesuusana «Hikka min kaɂebi basa, aninna arri seed orroo abbaabi keesinara» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ayihuudi, «Hikka k'ulluukki min kaɂebi madaarin gees afartamkko le gudisera, hayya ati misii arri seed orroo abbaabi madaarinnatta?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yesuusa k'ulluukki min kawaa goɂamiro ade isi ootteessakki maar ayeesanoye. ");
INSERT INTO bswl_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yesuusa goyikko kakko kee goorata, usukko oɂagaalssatareen usu me ayeesero shaaden, k'ulluukki mas'aafanna Yesuusa kaɂamero haafuraa ammaneen. ");
INSERT INTO bswl_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesuusa kafaasikkaa baala Iyyerusaalemi katamaayi giraan, ibaaddo kamooggan usu kafelero malaataal deere megekeessaa ammane. ");
INSERT INTO bswl_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yesuusa ade ibaaddo dubba mankkokaso maraan iso lakkoɂabddatere, ");
INSERT INTO bswl_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Usu wodana taɂibaaddoo orroo kagiro mankkokaso maraan, maayyona gara kaɂibaaddoo usuun goggoɂatotiroon lakkodootisero. ");
INSERT INTO bswl_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tafarasawi unana, kaɂayihuudi woyichchaalkko koo kalleera Nik'odimoosa kaɂamamare ibaaddoti gire. ");
INSERT INTO bswl_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Usu ibaaddotina hemeen Yesuusa tos emetere, «Kaɂagaalssisatto! Waa usune wota kallee ibaaddoti kuwaarre ati kafelatto baasakki malaata maayyona felin mankkodaanddeennon maraan, Waa dollekko kaɂemettettona kaɂagaalssisatto laano noo kanssowa» ame. ");
INSERT INTO bswl_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesuusana abbaabere, «Ani rumminaa rumminaa amara, maayyona kallami goɂumulame kuwaarre wononnati kawaa din lakkodaanddaaro» ame. ");
INSERT INTO bswl_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","«Nik'odimoosana ibaaddo doɂayire abbaabayi misii umulamin daanddaara? Kallami umulamin abbaabayi gedeemi taɂaawoo tos tabin daanddaara?» ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesuusana haa ame abbaabe; «Ani rumminaa rumminaa amara, maayyona bekekkona Ayyaanakko goɂumulame kuwaarre wononnati kawaa tos tabin lakkodaanddaaro. ");
INSERT INTO bswl_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ibaaddokko kaɂumulame ibaaddoya, Ayyaanakko kaɂumulamena ayyaanaya. ");
INSERT INTO bswl_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","‹Kallami umulamano dootisara ani mankko ame maraan aroosaadde.› ");
INSERT INTO bswl_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ambbal mankkogeelaatte kiyaatta, yaayena maalatta, ayesuun goɂameen eetikko emaatto, eetirraa seyattona laakkasso, Ayyaanakko kaɂumulame dubbana hikkamaleeya» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nik'odimoosana «Hikki misii liin daanddaara?» ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesuusana «Ati Isiraɂeel kaɂagaalssisatto» leete giraan hikka ayees laakkassoya? ");
INSERT INTO bswl_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ani rumminaa rumminaa amara, kakkansso ayeesinanna, kaddeenenno atotinanna, isin addeen atotaanokaanina lakkoɂataattaan. ");
INSERT INTO bswl_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Gara kaɂuleekki ayees ani isinuun gosegiro ammanatana kawattettaan, kadaruuree ayees gosegee misii ammanayinattaan? ");
INSERT INTO bswl_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Daruurkko kadagero Ere kaɂibaaddo kuwaarre, daruur tos kabbeera maayyona laagiro ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Muse k'alullattokki ulii habeessa goggosuyere malee, Ere kaɂibaaddona usumalee suwaamin dootisara. ");
INSERT INTO bswl_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Hikkina usuu kaɂammane dubba jiruu jiroommakki giri goggogirroonya. ");
INSERT INTO bswl_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","«Usuu kaɂammane dubba jiruu jiroommakki giri goggogirroon kuwaarre goggobaannonkko Waa Ere koo taasisiroo alami adda geelatera. ");
INSERT INTO bswl_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Waa Erekkeessa alami tos kakkoon farera alami gutii firddin halleennon giraan, alami usuuyi goggofayyironya. ");
INSERT INTO bswl_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Usuu kaɂammanara dubba lakkofirddaamaro, usuu kaɂammanoon ade koo Ere kawaakki megee mankko ammanoon giro maraan, t'ayewa firddaamera. ");
INSERT INTO bswl_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Firddana hikkaya, ifa alami tos emeete, ibaaddo ade feloɂoottiso omeellan mankkoleen maraan, ifakko roorisate mugud geelate. ");
INSERT INTO bswl_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tameellan kafelara dubba ifa diidara, felo omeellan ootteessa goggomutoonkko ifa tos lakkoɂemeetaro. ");
INSERT INTO bswl_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Rummii kasesseetara ade felo Waayi ofelameraan laano addeesami mutin ifa tos emeetara.» ");
INSERT INTO bswl_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Esekko abbaabatere Yesuusana usukko oɂagaalssatareenna ul kayihuuda seeteen, eseenna iso t'ammak'aa abaraan adallaate. ");
INSERT INTO bswl_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Hassu goorata Yaannisa Saalemi dollee Heenon taɂamamatto banɂee beke onjjiin mankkogireen maraan, t'ammak'aa gire, ibaaddona t'ammak'amin emeetaa gire. ");
INSERT INTO bswl_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Hikkina kalleera Yaannisa hashaamoon giraanye. ");
INSERT INTO bswl_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kookkoo Yaannisakko oɂagaalssatareenna Ayihuudi orroo hurufaamanokokki seeraa dogamaa keete. ");
INSERT INTO bswl_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Yaannisakko oɂagaalssatareen Yaannisa tonssa emeetenen, «Kaɂagaalssisatto, Yorddaanoskko gamaa kuunne wota kagire, garakkeessana ati kakkoonɂatotiitetta ibaaddoti, hikkima t'ammak'aara, ibaaddo dubba usu tos seetaa gira» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yaannisana, «Waakko gosisame kuwaarre maayyona koonna atayin lakkodaanddaaro ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‹Ani lakkokiristoosayyo, ayesuun goɂameen usukko horene faramera› kaɂamero isin metekisiniiwa atotinattaan. ");
INSERT INTO bswl_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mashaashe kakkongitta usu kamashaasheeya, yaaye maalin dollee kaɂaallaara saati ade, yaaye tamashaashee gomaallo aaloo geggelaatara, haanssun hasse geggelaanjjetti, gidda gudatetta. ");
INSERT INTO bswl_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Usu t'ok'k'i t'ok'k'i amin, ani ade yeraayin dootisara ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Elekko kaɂemeetara dubbaankko kanjjiinkiya, ulkko kalleera kaɂuleeya, taɂuleenna ayeesara, daruurkko kaɂemeetera dubbaankko kanjjiinkiya. ");
INSERT INTO bswl_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Usu kaddeerona kamaalero atotaara, ayesuun goɂameen atonnatikeessa maayyona lakkoɂatataro. ");
INSERT INTO bswl_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Atonnatikeessana kaɂatatere ibaaddo, Waa karrummii laano addeese. ");
INSERT INTO bswl_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Waa ayyaanakkeessa jiinase mankkosisaro maraan, Waa kafarera usu haafura kawaa ayeesara. ");
INSERT INTO bswl_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Odo Erekkeessa geelaatara, kameen dubbana genetteesaa sisera. ");
INSERT INTO bswl_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Erekkeessayi kaɂammanara dubba jiruu jiroommakki giri aba, Erekkeessaa kaɂammanoon ade engge tawaa usu gutii laatta kuwaarre giri lakkohelataro.» ");
INSERT INTO bswl_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Kafarasaawi ibaaddo Yaannisakko roore Yesuusa omooggan usukko oɂagaalssataran ekkasanona t'ammak'aano maaleen. ");
INSERT INTO bswl_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ayesuun goɂameen kat'ammak'eera Yesuusa halleennon giraan usukko oɂagaalssatarenyan. ");
INSERT INTO bswl_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesuusana hikka goggoɂaddeese ul kayihuuda iisere Galiila tos abbaabate seete. ");
INSERT INTO bswl_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Eserraa seetaa giraan Samaariya orrone roorano dootisare. ");
INSERT INTO bswl_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Haanssun Samaariyanne, Yayik'ooba ere keessa Yoosefaan takkosisero banɂe dollee tagitto Sikaari taɂamamatto katamaa tos emeete. ");
INSERT INTO bswl_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Eseenna kayayik'ooba gumbbi kabekee gire, Yesuusana sesseettaankko kakkeeyi hare mankkogire maraan gumbbi kabekee dollee hamas's'ee, gooratana arrikko saatii lekki goorataye. ");
INSERT INTO bswl_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Heleelttiti too tasamarawiti beke hummusayin kakkoɂemaatte goorata Yesuusa, «In beke t'amisina» ame. ");
INSERT INTO bswl_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Yesuusakko oɂagaalssatareen babo iminayin katamaa tos seeteen gireen. ");
INSERT INTO bswl_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ese Samaraawitina, «Ati Ayihuuditi leete giraan, in Samaraawi heleelttitine misii beke t'amisin amatta?» Antte, hikka amanona Ayihuudin Samarawijjoolnne wota esella mankkoginnoon maraanye. ");
INSERT INTO bswl_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesuusana abbaabere, «Ilabo kawaa addeessewa in beke t'amisi kaɂamara ayyoyo addeesi gittewa atiwa usukko hoosaattewa, usuna beke oggiri kuun sisarewa» ame. ");
INSERT INTO bswl_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Heleelttitina haa antte, «Goottakki, ati kakkohummusinaa lakkoɂabtto, gumbbina keelddokkiya, hayya hinɂa beke oggiri eetikko helnnatta? ");
INSERT INTO bswl_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ayesuun goɂameen, ati hikka gumbbi noon kasisero Aabbokaani Yayik'oobakko rooratta? Usuna Yiiskeessa, giddikeessana hikka gumbbikko t'ameenan,» antte. ");
INSERT INTO bswl_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesuusana «Hinɂa bekekko kat'amara danbbe sugubaayinara, ");
INSERT INTO bswl_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ani osisaro bekekko kat'amara ade suurewa lakkosugubaaro, ani osisaro beke kat'amara ibaaddo jiruu jiroommaan kafulttaaro kagiri bekekkokki fultto laara» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Heleelttitina, «Goottakki, ani goggosugubaanonkkona beke hummusayin goggosesseenoonkko, maganne hinɂa beke iin sisi» antte. ");
INSERT INTO bswl_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesuusana, «Seedde entterkkaa uumi koyi ame.» ");
INSERT INTO bswl_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Heleelttitina, «Ani entter lakkoɂabo» antte abbaabtte. Yesuusana, «Entter lakkoɂabo amano garaya. ");
INSERT INTO bswl_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ogiraan entter ken kuun kagire, gidda kunne wota kagirana entterkkaa mankkolleennoon maraan, kaɂayeesetta rummiya» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Heleelttitina, «Goottakki, ati kahegeroo laano gidda ani addeese. ");
INSERT INTO bswl_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Odolaalkkaani hitta wodami gutii sagadeen, isin Ayihuudi addeen ibaaddo sagadin kakkoondootisara Iyyerusaalemiya amattaan» antte. ");
INSERT INTO bswl_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesuusana, «Ati heleelttiti, hitta wodamii leere Iyyerusaalemiinna Odoon kakkosagadoon goorata emeetaa girano ammani. ");
INSERT INTO bswl_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Isin ibaaddo kasamaarya kakkasootun sagadattaan, noo andde fayyinna Ayihuudikko mankkoleero maraan noo kakkanssoon sagadanna. ");
INSERT INTO bswl_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Rummii osagadaraan; Odoon ayyaanaanna rummii kakkosagadiraan goorata emeetara, giddanna emeetera, Odona hikkamalee rummii osagadaraan dootara. ");
INSERT INTO bswl_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Waa ayyaanaya; osagadaraanna ayyaanaanna rummii sagadano dootisara» ame. ");
INSERT INTO bswl_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Heleelttitina, «Kiristoosa kaɂamamara kashigidame emeeyin girano kasowa, usu goɂemeete ayees dubba noon seginara» antte. ");
INSERT INTO bswl_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesuusana, «Kaɂayeesisara hayya ani usuyyo» ame addeesise garakkeessa eseen segee. ");
INSERT INTO bswl_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Usu goorata Yesuusakko oɂagaalssatareen abbaabateen emeeten, usu heleelttitine wota ayeesaa giraan deengureen saadeen, golleenna ade, «Me dootaatta?» goorttun, «Ese wota kakkoonɂayeesatta mewuunya?» ame usu kahoosatera maayyona laagire. ");
INSERT INTO bswl_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Heleelttitina uulla iissedde katamaa tos abbaabate, gosaanna, haa antte. ");
INSERT INTO bswl_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Ani kafelero dubba iin kasegeero ibaaddoti koyeen diyaa, usu Kiristoosa leewuna?» antte. ");
INSERT INTO bswl_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Isona katamaakko beeren usu mankkogiro tos seeteen. ");
INSERT INTO bswl_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Usu goorata Yesuusakko oɂagaalssatareen, «Kaɂagaalssisatto, babo aami» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Usu ade, «Isin kakkasoon ani kaɂaamaro babo aba» ame. ");
INSERT INTO bswl_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Usukko oɂagaalssatareenna, «Ibaaddo usuun babo keeni girro?» amaa isirroo ayeeseen. ");
INSERT INTO bswl_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesuusana, «Babo kakki in kafarerokotti feɂi felanona felo oottessa gudisanoya. ");
INSERT INTO bswl_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Isin, ‹Diginni afarkko haarre wut'a giyaara› laa amattaanna? Hikkima, wut'a kukkumin gabbalamano ‹t'ok'k'i maddeene ira diyaa› ame. ");
INSERT INTO bswl_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Katagatara giddanna gollee daamooza kaɂatateya, jiruu jiroommakki girin talleeto il kukkuyisatara, hikkina kawut'aterana katagatara wota goggogeggelaanawunya. ");
INSERT INTO bswl_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Haanssun, ‹Koo wut'atara, kakkalee ade tagatara› kaɂamamera masuussa rummiya. ");
INSERT INTO bswl_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kandaafuroon gittaan goggotagataawun farera, kakkalee felooyi hare, isin addeen daafurkkisootti il kukkuyisatteen» ame. ");
INSERT INTO bswl_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Heleelttiti, «Ani kafelero dubba iin segee» Antte mankko atotiite maraan ese katamaakko kamooggan kasamaraawi ibaaddo usuu ammane. ");
INSERT INTO bswl_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Haanssun, kasamaraawi ibaaddo Yesuusa tos takkoɂemeteree Yesuusana iso wota goggoɂadallaaron ataayiseen usu ebaaten, usuna arri lama esee adallaate. ");
INSERT INTO bswl_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Haafurakeessakkona kakkeeyi kakkalee kamooggan ibaaddo ammane. ");
INSERT INTO bswl_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Heleelttitinena, «Goortta noo usuu kakkoon ammananna ati noon mankko segite kaalaawun lakkoyo, noo issiiwa maalnenna, hikki ibaaddoti rumminaa alami kafayyiisaro laano kanssowa» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesuusa arri lamakko abbaabatere Galiila tos seete. ");
INSERT INTO bswl_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","«Kahegeroo ulkkeessaa lakkokabajaamaro» ame Yesuusa issiiwa ayeese gire. ");
INSERT INTO bswl_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galiila goggogeeyinna kagaliila ibaaddo geggelaanjjee usu atate, aalantina, iso kafaasikkaa baala Iyyerusaalemi mankkogire maraanna esee kafelero dubba mankko deeran maraanya. ");
INSERT INTO bswl_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesuusana beke t'amo kawoyinii tos takkoɂiggilsero, Galiilaa tagitto K'aana katamaa tos kallami emeete, K'ifirenaahoomina ere kakkoonhawɂaamere koo min kawonokokki shuumii gire. ");
INSERT INTO bswl_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Hikki ibaaddotina Yesuusa Yihuudakko Galiila tos emeetano kakkomaalare goorata, usu tos seetere hawɂaamere goyi hiɂi kagiro erekkeessa emeeyi goggofayyisiroo ebaate. ");
INSERT INTO bswl_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesuusana, «Maagoreenna isin malaatana baasakki ayees goddeennoon lakkoɂammanattaan» ame. ");
INSERT INTO bswl_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Shuumitina, «Goottakki, erekki gowaanokko horenne maganne geena» ame. ");
INSERT INTO bswl_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesuusana, «Erekka neefo gira see» ame, Ibaaddotina Yesuusa kaɂayeesero haafuraa ammane seete. ");
INSERT INTO bswl_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Raadii giranttuunna ohanddaaren usu heleeren, «Erekka fayyeera» ameen usuun segeen. ");
INSERT INTO bswl_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Usuna erekkeessa saatii miyyaayi iidero gohoosaro, «Maar gubanona usu kakkogafarera kele saatii todobaayiya» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kaɂunnuti odona Yesuusa, «Erekka neefone gira» takkoɂamero saatii laano addeese, usuna kaminee ibaaddo keessa dubba Yesuusaa ammaneen. ");
INSERT INTO bswl_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Hikkina, Yesuusa Yihuudakko Galiila tos emeete kafelero kallamikki baasakki malaataye. ");
INSERT INTO bswl_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Esekko abbaabatere kaɂayihuudi baala mankkogire maraan, Yesuusa Iyyerusaalemi tos bee. ");
INSERT INTO bswl_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Iyyerusaalemiinna, kaɂidaad ufa dollee, karra ken guuntte kasaarame kakkosesseetaran taɂabtta, heɂi taɂaramayikkii Beetesayida taɂamamatte banɂee kakkot'ammak'araan kafultto eela koo gire. ");
INSERT INTO bswl_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Hikka kakkosesseetaran raajjoolii kamooggan naafaleessaal, Iilɂoo kadiyannoon, oɂesaraanna naafaleessaal huddureen gireen. Bekekokki aɂaanona oorataa, ");
INSERT INTO bswl_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Roore roore erggichcha kawaa dage beke kakkoɂaaɂisaro goorata, t'aye eela tos katabe kaɂabo dhukuba maamisikikkona fayyaa gire. ");
INSERT INTO bswl_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Eseenna gees sonddomkko siddeedun dhukubaaleessa lee kagire ibaaddoti koo gire. ");
INSERT INTO bswl_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesuusana hikka ibaaddoti esee kahuddurero deegure, goorata kamoogganun hikkamalee girano addeesere «Fayyiin dootaatta?» ame. ");
INSERT INTO bswl_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Dhukubaaleessatinna abbaabere, «Goottaa! Beke kakkoɂaaɂiraan goorata eela tos in kadagisiro ibaaddo lakkoɂabo, ani tabin gohediro kakkalee horehaara» ame. ");
INSERT INTO bswl_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesuusana, «Ki! Takkohuddurttetto alggaattaa sidadde gali» ame. ");
INSERT INTO bswl_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ibaaddotina goorsewa fayyee, takkohudurere alggaana sidate gale. Hikkina kalleera Ayihuudin tafoolssi arriiyye, ");
INSERT INTO bswl_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ayihuudin odonnati oɂabaanna kafayyeero ibaaddotine, «Tafoolssii arri mankkolleete maraan takkohuddurttetto alggaattaa goggosidattoon seera kuun feɂi lakkosisaro ameen.» ");
INSERT INTO bswl_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Usu ade, «Aankki in kafayyisera ibaaddoti, ‹Takkohuddurttetto alggaattaa sidadde gali› amera» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Isona, «Takkohuddurttetto alggaattaa sidadde gali kaɂamera usu ayoyya?» ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Yesuusana fakkime seete gosa orroo tabe mankkogire maraan, ibaaddotina maayyo usu fayyisero lakkoɂaddeesero. ");
INSERT INTO bswl_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Esekko abbaabatere Yesuusa usu ibaaddoti min kaɂebi orroo helere, «Hikkima, fayyiitetta, hikkako karoore ayees ku goggogeennonkko hittakko danbbeebaan adi c'ubbo aroofeltte» ame. ");
INSERT INTO bswl_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ibaaddotina usu kafayyisera Yesuusa laano seete Ayihuudin segee. ");
INSERT INTO bswl_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ayihuudin odonnati oɂabaan, tafoolsii arrittisooyi hinɂi felo felamanooyi, Yesuusa horoorano haggaɂabeen. ");
INSERT INTO bswl_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesuusana, «Odokki gidda giin felaa gira, aninna adi felnara» ame. ");
INSERT INTO bswl_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Goortta Ayihuudin odonnati oɂabaan, Yesuusa tafoolsii arrittisoo mankkoɂiggilise kaalaawun halleennon giraan Waa Odo yelate, isiɂootteessa Waanneta ekka yelatanooyi, lagadin ataayiseen dootaa gireen. ");
INSERT INTO bswl_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesuusana; «Ani rumminaa rumminaa amara, Odo felaa giraan kaddeero kaalaal kuwaarre Ere kale iskko koonna felin lakkodaanddaaro, Odo kafelaro dubba Ere kawaa ade felara. ");
INSERT INTO bswl_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Odo Ere mankkogeelataro maraan usu issii kafelaro dubba tusara, goggosaadawunna hikkakko karoore ayees tusirowa. ");
INSERT INTO bswl_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Aalantina Odo kagoye goggokeesaro malee, neefona goggosisaroo malee, Ere kawaanna ade kadootate dubbaan giri sisara. ");
INSERT INTO bswl_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Odo maayyo gutiinna lakkofirddaaro, ayesuun goɂameen firdda dubba Erekkeessaan roorise sisera. ");
INSERT INTO bswl_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Hikkina, Odo goggokabajaana malee dubba Erekkeesaana goggokabajiinawunya, Ere kawaa kakkabajjiinoon, kafarero Odona lakkokabajaaro. ");
INSERT INTO bswl_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Ani rumminaa rumminaa amara, haafurakkee kamaalara, in kafareroonna kaɂammanara jiruu jiroommakki giri aba, goyikko giri tos nak'era kuwaarre firdda tos lakkoɂemeetaro. ");
INSERT INTO bswl_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ani rumminaa rumminaa amara, kagoyera ibaaddo Ere kawaakotti yaaye kakkomaallan goorata emeetara, gooratana giddaaya, ommaalaraanna neefo girinanaa. ");
INSERT INTO bswl_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Odo issiiwa kagiri fultto goggolleeroo usumalee, Erekkeessana metekkeesawun kagiri fultto goggolleeroon yelera. ");
INSERT INTO bswl_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Usuna Ere kaɂibaaddo mankkollee maraan firdda goggofirddiroon odonnati sisera. ");
INSERT INTO bswl_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","«Hikkanii aroosaaddeen, k'amalameen ogiraan dubba yaayetteessa kakkomaallaan goorata emeetara. ");
INSERT INTO bswl_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Taɂidan ofeleeran girkokki kiyaanoon, tameellan ofeleeran adeen kiirene firdda atayinaraan ame.» ");
INSERT INTO bswl_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«Ani kale iskko koonna felin lakkodaanddaaro, ani kafirddaara kamaalaro kaalaaya, in kafarerokotti feɂi kuwaarre feɂittee mankko dootannoon maraan firddakki garaya. ");
INSERT INTO bswl_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Ani isiɂootteewun goɂatotee, atonnatikki atamano lakkoɂabo. ");
INSERT INTO bswl_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","In maraan kaɂatotaara kakkalee gira, usu in maraan kasisinara atonnati rummi laano ani kasowa. ");
INSERT INTO bswl_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","«Isin Yaannisa tos fartteetten, usuna gara karrummii atoteera. ");
INSERT INTO bswl_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ani atotaano kaɂibaaddo kaɂatataro lakkoyo, ani hikka kakkoonɂayeesara ade isin goggofayyitawunya. ");
INSERT INTO bswl_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yaannisa beebaa ifa kasisaro korroontta aaniyye, isinna goorata kic'c'arun ifakkeessayi geggelaayin dootatteen. ");
INSERT INTO bswl_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","«Ani ade kayaannisa atonnatikko karoore atonnati aba, goggogudisiroon Odo osisera, aninna ofelara felo odo in farano atotaaran. ");
INSERT INTO bswl_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","In kafarera Odo usuwa garakkee atoteera; isin addeen yaayetteessa suure lakkomaalttettaan, midditteesana suure lakkodeeteettaan. ");
INSERT INTO bswl_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","In kafareroonna mankkoɂammanana waatteen maraan haafurakkeessa isinii lakkogiro. ");
INSERT INTO bswl_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Isin mas'aafa k'ulluukkiinna jiruu jiroommakki giri ohelayinnattaan aani mankkollaaro maraan mas'aafal k'ok'k'orattaan, hikki mas'aafana garakkee kaɂatotaaroya; ");
INSERT INTO bswl_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Isin addeen, neefo girin in tos emeeyin lakkodootattaan. ");
INSERT INTO bswl_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Ani ibaaddokko kabaja lakkodootataro; ");
INSERT INTO bswl_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ayesuun goɂameen ani isin kasowa; geelanjje tawaanna wodanattisinii orroo giriwaatti ani kasowa. ");
INSERT INTO bswl_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ani Aabbokkeekki megee emeeye isin goɂameen in lakkoɂatatteettaan; kakkalee megekkeessaa emetewa atatatteenwa. ");
INSERT INTO bswl_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Isin isiɂisiorroo kabaja osisattaan, ayesuun goɂameen Waa kookko taɂemaatto kabaja odootannoon golleeten, misii ammanin daanddaattan? ");
INSERT INTO bswl_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","«Kamootarakkisin abddi kakkoonlugudatteettan Muse kuwaarre, ani odo horee isin kamootaro aani aroolleenno; ");
INSERT INTO bswl_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Muse kaɂammanattaan leeteenwa, in ammanatteenwa; aalantina usu kas'aafera garakkeeya. ");
INSERT INTO bswl_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Usu kas'aafero goɂammanannoon, ani kaɂayeesaro haafurakkee misii ammaninnattaan?» ame. ");
INSERT INTO bswl_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Hittakko danbbenne Yesuusa T'ibraadoosi taɂamamatte tagaliila labukko gama nak'ere labu girnne seete. ");
INSERT INTO bswl_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ibaaddo kamoogganna dhukubaaleessaal fayyiisaa kafelero baasakki malaatajjool mankkodeeraan maraan debee sesseeteen. ");
INSERT INTO bswl_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Esekona Yesuusa wodami tos beere usukko oɂagaalsisaraane wota hamas's'ee. ");
INSERT INTO bswl_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Kaɂayihuudi faasikkaa baalana gabbalame gire. ");
INSERT INTO bswl_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesuusana t'ok'k'ime gosa kamooggan usu tos emeetaa kagiro deere; Filp'oosane, «Hikki ibaaddo goggoɂaamiroon babo eetikko iminna?» ame. ");
INSERT INTO bswl_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Hikka kakkonhoosatera usu c'aafinya kuwaarre usu ussun felin kahedere kasanaayewa. ");
INSERT INTO bswl_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filp'oosana, «Mete metee ibaaddo kic'c'ar kic'c'ar goggok'ammasiroon yelin, diinaara lama booleekki buddeena lakkolleero» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yesuusakko oɂagaalssatarenkko koo, kasimoona P'et'iroosakokki abbi Indiraasana haa ame; ");
INSERT INTO bswl_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Kahaɂuree babo kenna kunɂub lama kaɂabera unnu koo hittanii gira, hikki ade hikka gosa dubbaan misii geeginara?» ");
INSERT INTO bswl_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesuusana, «Ibaaddo goggohamas'iroon yela» ame, ese banɂee ees kamooggan gire, ibaaddona hamas's'ee tootoɂoottisona kuma ken kalleeroye. ");
INSERT INTO bswl_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesuusa babo ken keese galatee kakkoɂabbaabatare goorata, kahamas'eero gosaan hedeeden, kunɂubna usumaleewwa hedeeden dubbana kadootisaro gitakki helateen. ");
INSERT INTO bswl_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Dubba aame kakkobararare goorata, Yesuusa usukko oɂagaalssatarenne, «Tahessetto hanbbakko toonna goggodarɂaamonkko kukkuyisa» ame. ");
INSERT INTO bswl_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Isona, kaɂaamamero kahaɂuree babo kenkko tahessetto hanbba dugud tomonkko lama kukkuyiseen ammageen. ");
INSERT INTO bswl_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ibaaddo Yesuusa kafelero baasakki malaata kakkodiyaaren goorata, «Alami tos kaɂemeetara kahegeroo ogiraan hikkaya» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesuusana ibaaddo emeeyire hunnaa usu wono yelayin k'oppaanokisoo addeesere adena kalekalee wodami tos seete. ");
INSERT INTO bswl_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ul hemeen kakkollaare goorata usukko oɂagaalssatareen labu dageen. ");
INSERT INTO bswl_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Wolaboonna koratenee K'ifirenaahoomi tos nak'in keen. Gooratana hemeen leere, Yesuusana ganaa iso tos lakkoɂemetere. ");
INSERT INTO bswl_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ambbal taɂatii mankko kiyaa gitte maraan beke keen. ");
INSERT INTO bswl_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kilo metira ken goorttun le duudeen giraan, Yesuusa beke gutii sesseetaa wolabo tos kaɂemeetaro deenee abssateen. ");
INSERT INTO bswl_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yesuusa ade, «Aniya, arooɂabssatteen» ame. ");
INSERT INTO bswl_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Isona usu goggokoraroo dootateen, wolabona goorsewa mankko seetaraan geete baga abatte. ");
INSERT INTO bswl_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tallami arri bekekko gamanne kahesera ibaaddo esee wolabo too taalaal girano addeese, Yesuusa ade wolabooyi koratanawaattina usukko oɂagaalssatareen kale nak'anona addeese. ");
INSERT INTO bswl_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Esekko abbaabatere, kakkalee wolabool T'ibraadooskko, Goottaa kasommaasatero babo gosa mankko aamero banɂe tos emeete. ");
INSERT INTO bswl_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ibaaddona, Yesuusa goorttun usukko oɂagaalssatareen esee giranawaatti goggoɂaddeeseenii, Yesuusa dootaa wolaboolii tabeen K'ifirenaahoomi tos seeteen. ");
INSERT INTO bswl_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bekekko gamanne usu kakkohelareen goorata, «Kaɂagaalssisatto, ati hittarraa goree emeetetta?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesuusana, «Ani rumminaa rumminaa amara in kakkondootattaan babo mankkoɂaantteen maraanna mankkobarartteen kuwaarre, malaata mankkodeeten maraan lakkoyo. ");
INSERT INTO bswl_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kabbaaro baboon aroofeltteen, ayesuun goɂameen Ere kaɂibaaddo kasisaro jiruu jiroommakki giri kalleero baboon fela, hikkina Waa Odo kaɂaddeesisaro maatama usu gutii kayera.» ");
INSERT INTO bswl_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Isona, «Hayya felo owaa felin me yelano dootisara?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesuusana, «Usu kafareroyii goggoɂammanttaawun, hinɂi felo owaayyan» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Isona, «Noo diigunne ku goggoɂammannoon me malaata felnatta? Menna yelnnatta? Ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Goggoɂaaminawun daruurkko babo sisera amame goggos'aafameroo, odolaalkkaani k'alullattokki ulii babo kadaruure aameen.» ");
INSERT INTO bswl_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Haanssun Yesuusana, «Ani rumminaa rumminaa amara, daruurkko babo kasisara lakkomuseyo, karrummii babo daruurkko kasisara ade Odokkeeya. ");
INSERT INTO bswl_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Babo kawaa usu daruurkko kadagarona alamiin giri kasisaroya» ame. ");
INSERT INTO bswl_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Isona, «Goottaa, goorttanun hikka babo arri dubba noon sisi» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesuusana haa ame; «Kagiri babo aniya, in tos kaɂemeetara duuddo lakkoɂuɂiro, iyyeenna kaɂammane suure lakkosugubaaro. ");
INSERT INTO bswl_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ayesuun goɂameen ani isinuun goggosegeeroo, deetettan gidanna suure lakkoɂammanattaan. ");
INSERT INTO bswl_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Odo kasisara dubba in tos emeetara; in tos kaɂemeetarona suure saarddese lakkohorooraro. ");
INSERT INTO bswl_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Daruurkko ani kakkoondagera feɂittee felayin anlleennon giraan, kafarerokotti feɂi feli gudisinya. ");
INSERT INTO bswl_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","In kafarerokotti feɂi, kasisero dubbakko koonna habbaannon giraan tagachchoo arri goyikko goggokeesironya. ");
INSERT INTO bswl_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Aabbokkeetti feɂi Ere deere usuuyi kaɂammanara dubba jiruu jiroommakki giri goggogirroniya, aninna tagachchoo arri goyikko keesinnara.» ");
INSERT INTO bswl_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ayihuudina «Daruurkko kadagera babo aniya» amanokkeessaan gumggumaano haggaɂabeen. ");
INSERT INTO bswl_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Haanna ameen, «Hikki kayooseefa ere la Yesuusayyolla? Aabbokkeessana Aayetteessa la noo okanssoyaanna? Hayya gidda usu misii ‹Ani daruurkko dagera› amara» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesuusana abbaabe haa ame, «Isi isirroo aroo gumggumiteen. ");
INSERT INTO bswl_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","In kafarera Odo isi tos goɂabbaabe kuwaarre maayyona in tos emeeyin lakkodaanddaaro in tos kaɂemeetaro aninna tagachchoo arri goyikko keesinara. ");
INSERT INTO bswl_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kahegeroolnna, ‹dubba Waakko oɂagaalssateen leeraan› amame s'aafamera, Odo kamaalarana usukkona kaɂagaalssatera dubba in tos emeetara. ");
INSERT INTO bswl_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Waa dollekko kaɂemeetero kuwaarre Odo kaddeera koonna laagiro, Odo kaddeera usu kaalaalya. ");
INSERT INTO bswl_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ani rumminaa rumminaa amara, kaɂammanara dubba jiruu jiroommakki giri aba. ");
INSERT INTO bswl_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Kagiri babo aniya. ");
INSERT INTO bswl_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Odojjolaalkkisin k'alullattokki ulii babo kadaruure aameen halleewo kuwaarre goyeen. ");
INSERT INTO bswl_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ayesuun goɂameen ibbaaddo goggogoononkko goggoɂaamiroon daruurkko kadagera babo hikkaya. ");
INSERT INTO bswl_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Daruurkko kadagera arddokki babo aniya; hikka babokko kaɂaamara dubba jiruu jiroomman girara; alamiin giri goggolleeroon ani kasisara babo sooɂootteyaan ame.» ");
INSERT INTO bswl_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ayihuudina, «Goggoɂaaminnoon hikki ibaaddoti soo ootteessa misii sisin daanddaara?» amaa isi isirroo ataayiseen dogamano haggaɂabeen. ");
INSERT INTO bswl_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesuusana, «Ani rumminaa rumminaa amara, Ere kaɂibaaddonɂi soo goɂaamanawaatten iigina got'amanawaatten isiɂoottisinuun giri lakkoɂabttaan. ");
INSERT INTO bswl_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Sooɂoottee kaɂaamara, Iigikkeenna kat'amara jiruu jiroommakki giri aba, aninna tagachchoo arri usu goyikko keesinara. ");
INSERT INTO bswl_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Sooɂootti karrummii babo Iigikkina karrummii t'amoya. ");
INSERT INTO bswl_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Sooɂoottee kaɂaamara, Iigikkeenna kat'amara iyyee girara, aninna usu girnnara. ");
INSERT INTO bswl_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Arddokki Odo in goggofareroo, aninna usukko kakkeeyi giri goggogiro malee, kaɂaamarana hikkamalee inkko kakkeeyi giri girara. ");
INSERT INTO bswl_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Daruurkko kadagera babo hikkaya odolaalkkisin kaɂaameran babo aankikki lakkoyo, hassu babo oɂaamaraan adeen goyeeran, hikka babo kaɂaamara ade jiruu jiroomman girara.» ");
INSERT INTO bswl_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Hikka kakkoon ayeesera kak'ifirenaahoomi maamanii Ayihuudikokki min kaɂebii agaalssisaa giraanye. ");
INSERT INTO bswl_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Usukko oɂagaalssatarenkko omooggan hikka maaleen, «Hikki kac'c'annak'isiro haafuraya, ayoyya atayin kadaanddaara?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Usukko oɂagaalssatareenna hikka ayeesii gumggumaano Yesuusa issiiwa addeesere, «Hikki isinuun handuddufo leero maana? ");
INSERT INTO bswl_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Hayya, Ere kaɂibaaddo t'aye takkogire tos biyaa giraan goddeeten me aminye? ");
INSERT INTO bswl_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ayyaana kawaa giri sisara, soo adeen laɂo toonna lakkoɂabaan, ani isinuun kasegeera haafura ayyaanana girinnaya. ");
INSERT INTO bswl_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Halleewo kuwaarre isinkko kaɂammanoon kookkoo gira» ame. Hikkina, Yesuusa ayyoosi ammanoon giraanna ayyo usu roorisi sisinaro t'ayewa mankkokasanaaye maraanya. ");
INSERT INTO bswl_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Horeddeenna, «Odokko gosisame kuwaarre, maayyona in tos emeeyin lakkodaanddaaro ani kakkoon amera hikkanunya» ame. ");
INSERT INTO bswl_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Hikkakko kakkeeyi Yesuusakko oɂagaalssatareen omooggan haararttii abbaabateen, esekko abbaabatene debee lakkosesseeten. ");
INSERT INTO bswl_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesuusana tomonkko lamane, «Isinna addeen seeyin dootaattan?» ame. ");
INSERT INTO bswl_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoona P'et'iroosana, «Goottakki, ayyo tos seeyinanna? Ati jiruu jiroommakki kagiri haafura abtta. ");
INSERT INTO bswl_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ati koo kawaa k'ulluukki laano gidda ammanenna, addeenssenna» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesuusana abbaabere, «Isin tomonkko lamana kaɂassaabera la aniyolla? Ayesuun goɂameen isinkko koo durrisaya» ame. ");
INSERT INTO bswl_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Kaɂask'orotu Simoona ere kayihuuda, tomonkko lamakko koo goleenna, danbene roorisi mankkosisinaro maraan garakkeessa ayeesanoya. ");
INSERT INTO bswl_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Esekko abbaabatere Yesuusa, esee kagire Ayihuudil Yesuusa lagadin mankkodootare maraan, Yihuudakokki awuraajjaayi maraamurano isaagere Galiilaa maraamure. ");
INSERT INTO bswl_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kaɂayihuudi kadaasee baala kakkogabbalamare goorata ade, ");
INSERT INTO bswl_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Abbilaal tayesuusa, «Kukko oɂagaalssatareenna adeen ati ofelatto felo goggodeenawun, hittakko Yihuuda tos see ameen. ");
INSERT INTO bswl_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Isi tusayin dootataa giraan siyame kafelara maayyona laagiro. Atina hikka ayees kafelatto golleete, isiɂoottaa alamiin addeesisa» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Abbilaaltteessa suure lakkoɂammantette. ");
INSERT INTO bswl_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesuusana, «Iyyen likkiikki goorata ganaa lakkogeero, isinuun ade maagoreenna gooratana kaɂekkaateya. ");
INSERT INTO bswl_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Alami isin diidin lakkodaanddaaro, ani ade, feloɂootteessa omeellan laano mankkoɂatotaaro maraan in diidara. ");
INSERT INTO bswl_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Isin baala tos seyeen, iyyeen likkiikki goorata mankkogeennon giro maraan baala tos lakkoseeyinaro ame.» ");
INSERT INTO bswl_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Hikka isoon amere Galiilaa adallaate. ");
INSERT INTO bswl_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Halleewo kuwaarre, abbilaal baala tos kakkoseetatte goorata usuna mutaa halleenon giraan siyame baala tos seete. ");
INSERT INTO bswl_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Baala gutiinna Ayihuudi, «Usu ibaaddoti haggee gira?» amaa dootaa gireen. ");
INSERT INTO bswl_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Garakkeessa gosa orroo tanjjiin gumggumaano gire. Kookkoonna, «Usu kaɂidankki ibaaddotiya» ameen. Okkalee adeen, «Laa, gosa kashirsaroya» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Halleewo kuwaarre Ayihuudi absatanokko kakkeeyi garakkeessa futtise kaɂayeese maayyona laagire. ");
INSERT INTO bswl_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Baalana takkot'eɂellaa seetee Yesuusa k'ulluukki min kawaa tos beere agaalssisano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ayihuudina saadaa hikki ibaaddoti haɂagaalssannoonii hikka agaalssis misii addeesin daanddee? Ameen. ");
INSERT INTO bswl_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesuusana, «Ani kaɂagaalssisara agaalssisano inkko halleennon giraan in kafarerokko kaɂemeeteroya. ");
INSERT INTO bswl_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Maayyona feɂi tawaa felin godoote, hikki agaalssisi Waakko goorttun inkko kaɂemeetero laano kalebeese kasa. ");
INSERT INTO bswl_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Iskko kaɂayeesara, hassu kakkoonfelara ussun kabaja mankkodootataro maraanya, kafarerokotti kabajjaan kafelara ade usu karummiiya, t'arana lakkohelamatto. ");
INSERT INTO bswl_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Muse seera lakkosiseroya? Ayesuun goɂameen koonna seera lakkoɂooratteen. Isin mewuun in lagadin dootaattan?» ");
INSERT INTO bswl_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Gosana, «Ati durrisa kaɂabtta!» «Ku ade ayyoya lagadin kadootara?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesuusa abbaabere isone haa ame, «Ani baasa koo fele, isin dubbana saaddeen. ");
INSERT INTO bswl_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Hamas's'isamano kakkoɂemetera odolaalkko kuwaarre Musekko lakkoyo, golleenna Muse hamas's'isamano mankkosise maraan Ayihuudin tafoolssi arrina haɂiisoni yiis hamas'isattan. ");
INSERT INTO bswl_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Seera kamuse goggoɂiggilssamonkko yiis Ayihuudin tafoolssi arri kahamas'iisattan golleeten, taɂibaaddoo neefo tafoolssi arri goffayyise mewuun in gutii amaraattan? ");
INSERT INTO bswl_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Bebbeed taɂibaaddo diyaa firddaano isaagaddeen firdda karrummii firddaa» ame. ");
INSERT INTO bswl_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Usu goorata Iyyerusaalemi kagire kookkoo ibaaddo; «Lagadin kadootaran ibaaddoti la hikkayyolla? ");
INSERT INTO bswl_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hikkima usu diidaa beese ayeesara, iso ayees koonna lakkoɂayeesaran, hikki ibaaddoti Kiristoosa laano odonnati oɂabaan addeesi girraane? ");
INSERT INTO bswl_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Hikki ibaaddoti ade eetikko emeetero noo kanssowa, Kiristoosa emeetaa giraan eetikko emeeyinnaro maayyona laakkaso» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesuusa k'ulluukki min kawaa orroo agaalssisaa yaaye t'ok'k'isere, «Ii, in kassaanwa, eetikko emeeyerona kassaanwa, ani hittanii kakkongira isiɂootteeyi lakkoyo, ayesuun goɂameen in kafarera usu karrummiya, isin addeen lakkokassaan, ");
INSERT INTO bswl_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ani ade usu dollekko mankkoɂemeeyero maraanna usuna in mankkofarero maraan ani usu kasowa» ame. ");
INSERT INTO bswl_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Haanssun abin dooteen, ayesuun goɂameen goorata ganaa mankkogeenoon giro maraan maayyona gene gutii lakkokaye. ");
INSERT INTO bswl_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Golleenna gosakko kamooggan usuu ammanere, «Hayya, Kiristoosa emeetaa hikki ibaaddoti kafelaro malaatakko karoore fello?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farasaawiilnna, gosa garakkeessa gumggumaa kaɂayeesaro ayees malee, katuuk'aamol woyichchaalnna Farasaawiil goggoɂabinawun isoon k'ulluukki min kawaa oɂooraran fareen. ");
INSERT INTO bswl_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesuusana, «Ani isin wota kakkoɂadallaayinara goorata kic'c'arunya, esekko in kafarero tos seeyinara, ");
INSERT INTO bswl_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Isin in dootinattaan, ayesuun goɂameen lakkohelnnattaan, ani mankkogiro tos emeeyin lakkodaanddeetan» ame. ");
INSERT INTO bswl_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ayihuudin odonnati oɂabaan isi isirroo, «Hikka ibaaddoti, helin noo kakkowaayinanna eetirraa seeyin gohediroya? Giriikkijjool orro darɂaameen ogiraan unattaani tos seeyire Giriikkijjool agaalssisin dootereya? ");
INSERT INTO bswl_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‹In dootinattaan, addeen lakkohelnattaan adina, ani mankkogiro tos emeeyin lakkodaanddeetan› goɂamiro me amanoya?» ameen ayeeseen. ");
INSERT INTO bswl_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Baalan gudatano tallaatto tanjiinti arrii, Yesuusa aalleere yaaye t'ok'k'isere, «Maayyona kasugubaatera gogire in tos emeeyire hat't'ame ame. ");
INSERT INTO bswl_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Iyye kaɂammanara, mas'aafa k'ulluukki goggoɂamaroo ogiri bekekokki fultto orrokko biyaara» ame iyyee. ");
INSERT INTO bswl_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Hikka usu kakkoonɂamera usuu oɂammanaraan kaɂatayinaraan ayyaanakokki garaye, aalantina Yesuusa ganaa mankkokabajjaamoon gire maraan Ayyaana K'ulluukki lakkosisamere. ");
INSERT INTO bswl_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Gosakkona kookkoo hikka haafura kakkomaalare goorata, «Hikki ibaaddoti ogiraan kahegerooya» ame. ");
INSERT INTO bswl_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Okkalee, «Usu Kiristoosaya» Ameen. Kuukina ade haa ame, Kiristoosa Galiilakko «Misii emeeyin daanddaara? ");
INSERT INTO bswl_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mas'aafa k'ulluukki, Kiristoosa kadaawute hidiidikko, Daawutena takkogire Beteleemikko emeetano la ayeesarolla?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Haannunna Yesuusakotti aalanttii gosa orroo kalekalee biyaano lee, ");
INSERT INTO bswl_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Kookkoonna usu abin doote, ayesuun goɂameen maayyona gene gutii lakkokaye. ");
INSERT INTO bswl_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Esekko abbaabatere k'ulluukki min kawaa oɂoorareen tuuk'aamokokki woyichchaal tos abbaabateen emeeten, isona «Muun aati emeennoon isaayiddeettan?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","«Ohandaarenna, hikka ibaaddoti aani, maayyona suure ayeese laakkaso» ameen abbaabeen. ");
INSERT INTO bswl_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","«Farasaawiil ade, isinna sobantteettaan amanoya? ");
INSERT INTO bswl_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Golleenna odonnati oɂabankkona Farasaawilkko usuu kaɂammanera giro? ");
INSERT INTO bswl_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Seera kakkasoon hikki gosa ade kak'anggaameya» ameen abbaabeen. ");
INSERT INTO bswl_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Hittakko horene Yesuusa tos seete kagirena isokko koo kalleera Nik'odimoosa, ");
INSERT INTO bswl_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Seerakkaani, horaarjje ibaaddoti koo me felero hamaaloninna haɂaddeesooni firddaara?» ame. ");
INSERT INTO bswl_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Isona, «Atina adde Galiilakkotta? Kahegeroo Galiilakko kiwaatti k'ok'k'orina, gachchooggeeta» ameen abbaabeen. ");
INSERT INTO bswl_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Esekko danbbenne dubba min min seeteen. ");
INSERT INTO bswl_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesuusa ade zayitii kabiyaara gaa takkoɂalataro wodami tos bee. ");
INSERT INTO bswl_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tallami arri barbaariinoo k'ulluukki min kawaa orroo ade mute, gosana maraamure kukku ame; agaalssisinna hamas's'ee. ");
INSERT INTO bswl_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Seera kamuse oɂagaalssisaranna Farasaawiil sharmmut'umaa taɂabanttetto heleelttiti keneen gosa orroona aalliseen, ");
INSERT INTO bswl_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Yesuusane, «Kaɂagaalssisatto, hitti heleelttiti sharmmut'aa abbanttetta, ");
INSERT INTO bswl_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Musena, hitta heleelttiti aankkikki eɂemoo goggoɂeeggamiro seeraa ajajeera, ati adde me amatta?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Hitta hoosin usu kakkonhosateran, usu takkomootiran aalantti dootaa c'aafitiniye, Yesuusa ade hussi amere ferii ul gutii s'aafano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Hoosiinii kakkojjeerisaren goorata t'ok'k'i amere, «Isin orrokko c'ubbo kallayikki usu t'ayi eɂemoo haɂeegge» ame. ");
INSERT INTO bswl_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Adena hussimere ul gutii s'aafe. ");
INSERT INTO bswl_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Iso hikkana kakkomaalaren goorata, jaarsoleekko haggaɂabere toottoolli esekko iiseen seeteen, esee usu horee aalliite tagitte heleelttitine wota Yesuusa kale hese. ");
INSERT INTO bswl_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesuusana t'ok'k'i amere, «Te heleelttiti; ibaaddo haggerraa seete? Ku gutii kafirddeere laagiroya?» ame. ");
INSERT INTO bswl_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Esena, «Goottakki! Koonna laagiro» antte, Yesuusana, «Aninna lakkofirddinaro, see, goortta hittakko danbbeebaan adi c'ubbo aroofelte» ame. ");
INSERT INTO bswl_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Adena Yesuusa ibaaddoon, «Ani kaɂalami ifaya, indebee kasesseetarana kagiri ifa laara kuwaarre suure mugudii lakkosesseetaro» ame. ");
INSERT INTO bswl_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farasaawiilnna, «Ati isiɂoottaawun mankkoɂatotaatto maraan atonnatikka lakkoɂatamaro» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesuusa, «Ani garakkee goɂatotaayena ani eetikko emeeyerona eetirraa seeyinaro mankkokaso maraan atonnatikki rummiya, isin addeen eetikko emeeyero goorttun eetirraa seeyinaro kakkassaan ayees laagiro. ");
INSERT INTO bswl_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Isin yaada kaɂibaaddo aani firddaattan, ani maayyo gutiinna lakkofirddinaro. ");
INSERT INTO bswl_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Gofirddeenna, kafarero odo wota kuwaarre ani kale mankkoginnoon maraan firddakki garaya. ");
INSERT INTO bswl_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ibaaddo lamakki atotaano atamano goggoɂabo malee seerakkisinii s'aafamera. ");
INSERT INTO bswl_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Garakkee kaɂatotaatarokko koo aniya; kakkaleenna iin kaɂatotaara in kafarero Odokkeeya ame.» ");
INSERT INTO bswl_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Esekkona, «Aabbokka eetii gira?» ameen. Yesuusana, «Aabbokkeenna leere inna laakkassaan, in kakkassaan leeteenwa, Aabbokkeenna kasattenwa» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesuusa hikka kakkoonɂayeesera k'ulluukki min kawaa orroo, huu kakkokaamaro min dollee agaalssisaa giraanye, halleewo kuwaarre gooratakkeessa ganaa mankkogeennoon giro maraan maayyona usu lakkoɂabero. ");
INSERT INTO bswl_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesuusa adena, «Ani seeyinara, isinna in dootinattaan, c'ubbokkisiniinna goyinattan, ani mankkoseetaro tos adi emeeyin lakkodaanddeetan» ame. ");
INSERT INTO bswl_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ayihuudin odonnati oɂabanaayenna, «Ani mankkoseetaro isin emeeyin lakkodaanddeetan usu kakkoonɂamera isiɂootteessa lagadayinya?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesuusa ade, «Isin hegelkkottaan, ani elekkoya, isin hikka alamikkottan, ani lakkohikka alamikkoyo. ");
INSERT INTO bswl_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","C'ubbokkisinii gowaano segeera, ani usuya goɂamiro ani usu laano goɂammanatana waatteen, c'ubbokkisinii goyinattan» ame. ");
INSERT INTO bswl_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Isona «Ati ayyotta?» ameen. Yesuusana «Horaarjjewa, kaɂayeesare usu aniye. ");
INSERT INTO bswl_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ani isin gutii kaɂayeesirona kafirddinnaro kamooggan ayees aba, ayesuun goɂameen in kafarera kaɂabddameya, usukkona kamaalero alamiin ayeesinara.» ");
INSERT INTO bswl_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Isona gara kaɂodoo segaa girano lakkoɂaddeeseeran. ");
INSERT INTO bswl_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Haanssun Yesuusa, «Ere kaɂibaaddo t'ok'k'isi kakkosuyiteen goorata, aankki kaɂamera usu ani laano odo kaɂagaalssisero ayeesano, feɂitteeyi koonna feliwaatti kassaanwa. ");
INSERT INTO bswl_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","In kafarera usu inneta gira, maaɂeeki gooratana kageggelaayisiro felin kale in lakkoɂisaagero ame.» ");
INSERT INTO bswl_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesuusana hikka goggoɂayeese omooggan usu ammaneen. ");
INSERT INTO bswl_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesuusana usuuyi kaɂammanaro Ayihuudinne, «Isin agaalssisanokkeeyi goɂataatteen rumminaa inkko oɂagaalssaattanttaan ame. ");
INSERT INTO bswl_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Rummina kassanwa, rummina isin balchchumma beesinatta ame.» ");
INSERT INTO bswl_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Isona abbaabeen, «Noo yiis kaɂabraamenna, maayyoonna diyyii leene laakkansso, hayya noonne balchchumma binnattaan misii amatta?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesuusana «Ani rumminaa rumminaa amara c'ubbo kafelara kac'ubbo diyyiiya, ");
INSERT INTO bswl_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Diyyii eerinnawuna ibaaddo kaminee orroo lakkogiraro ere ade maagoreenna minii girara. ");
INSERT INTO bswl_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Goortta Ere kawaa balchchumma gobeese, rumminaa balchchumma binnattaan. ");
INSERT INTO bswl_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Isin yiis kaɂabraame laano ani kasowa ayesuun goɂameen haafurakkee atatana mankkowaattan maraan in lagadin goosatteen keeteettan. ");
INSERT INTO bswl_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ani Aabbokkee, dollee kaddeero ayeesara, isinna Aabbokkisinkko kamaaltteettaan felattaan ame.» ");
INSERT INTO bswl_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Isona, «Aabbokkaani Abraameya» ameen abbaabeen. Yesuusana «Isin yiis kaɂabraame leeteenwa,» Abraame «kafelero felatteenwa. ");
INSERT INTO bswl_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Waakko maalere rummi kasegeero in lagadin dootaattan Abraame ade hikkamalee lakkofelero. ");
INSERT INTO bswl_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Isin kafelattan Aabbokkisin kafelaroya.» Isona, «Noo sharmmut'ummaa oɂumulaminenno lakkonno,» «Aabbokkaanina koo Waa kaalaaya» ameen abbaabeen. ");
INSERT INTO bswl_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesuusana, «Waa Aabbokkisin lii girewa, ani Waa dollekko mankkoɂemeeyero maraan geelatattenwa usu in farera kuwaarre ani isiɂootteeyi lakkoɂemeeyero. ");
INSERT INTO bswl_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ani kaɂayeesaro mewuun shaadanawaattan? Aalanttina haafurakkee maalin mankkodootannon maraanya. ");
INSERT INTO bswl_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Isin Aabbokkisinkki kaddurrisa yiisttaan. Aabbokkisinkki halchcha felin dootaattan. Usu horaarjjewa neefo kalagadaroye, usu dollee rummi mankkoginnoon maraan rummii lakkoɂataatero; usu t'arana kat'araa odo mankkoleewun t'ara ayeesara kaɂayeesarana iskko met't'eereya. ");
INSERT INTO bswl_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ani ade rummi mankko ayeesaro maraan lakkoɂammanattaan. ");
INSERT INTO bswl_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Isinkko ati c'ubbaalessatta ami mootin kadaanddaara ayyoyya? Rummi kaɂayeesaro gollee, mewuun ammanana waattaan? ");
INSERT INTO bswl_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kawaa kallee haafura kawaa maalara, isin addeen Waakko mankkolleennon maraan lakkomaalattaan ame.» ");
INSERT INTO bswl_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ayihuudina abbaabere, «Ati Samaraawitta, adena durrisa ku gutii gira amanokkaan la garayyolla?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesuusana, «Ani Aabbokkee kabajjaara kuwaarre durrisa lakkoɂabo,» «Isin addeen in yeraasattaan. ");
INSERT INTO bswl_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ani kabajattee lakkodootataro, kabajattee kadootara ade girowa; kafirddaarana usuya. ");
INSERT INTO bswl_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ani rumminaa rumminaa amara, maayyona haafurakkee goɂoorate, goyi suure lakkodeero» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ayihuudina, «Durrisa girano giddaa addeensse, Abraame goyera, kahegeroolnna hikkamaleewa, ati adde maayyona haafurakkaa goɂoorate suure lakkogooro amatta. ");
INSERT INTO bswl_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ati Aabbokkaani Abraamekko rooratta? Usu goye, ohegeroolna usumaleewwa goyeen, hayya ati ayyoyya amin laatta ameen?» ");
INSERT INTO bswl_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesuusana «Ani isiɂoottee gokkabajaaye kabajatti laɂo kalliittitta, kakkabajinarana ade isinne wota, isin Hedokkaani kaɂamattan Aabbokkeeya. ");
INSERT INTO bswl_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Isin gokasanawaatenna ani kasowa laakkaso goɂame, ani ade isin aani kat'araa laara, ani ade kasowa haafurana oorayinara. ");
INSERT INTO bswl_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Aabbokkisin Abraamekokki halchcha arrittee dii geggelaayin dootere, deegurena geggelaate, kageggelaatena lee ame abbaabe.» ");
INSERT INTO bswl_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ayihuudina, «Ganaa gees konttom kakkoleeno,» «Ati Abraame deetetta!» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesuusana, «Ani rumminaa rumminaa amara» «Abraame umulamanakko horene ani aniya» ame. ");
INSERT INTO bswl_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Usu goorata usu eeggiin eɂemo aateen, Yesuusa ade golate, k'ulluukki min kawaakkona bee seete. ");
INSERT INTO bswl_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesuusa raanne rooraa giraan takkoɂumulamekko haggaɂabere Iilɂo kabbayere ibaaddoti dee. ");
INSERT INTO bswl_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Usukko oɂagaalssatareenna Yesuusane, «Kaɂagaalssisatto! Hikki ibaaddoti Iilɂo bayi goggoɂumulamiron c'ubbo kafelera ayyoyya? Usuya muu oɂumuleeraanyan?» ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesuusana, «Usu goorttun oɂumuleeraan c'ubbo lakkofeleeran,» «Hikki kakkoonleera ade felo owaa usuu goggomutinaawunya. ");
INSERT INTO bswl_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Arri giraan in kafarerokonɂi felo felano dootisara, maayyona felin takkodaanddenon hemeen emaatta, ");
INSERT INTO bswl_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Hikka alamii giraan alamikokki ifa aniya ame.» ");
INSERT INTO bswl_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Hikka ame abbaabatere ulii hanc'c'ufe tufere hanc'c'ufee erre c'awudisere Iilɂo oɂibaaddotii shigidere, ");
INSERT INTO bswl_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","«Seedde Selihoomi kaɂamamaro eelaa aalina» ame. (Selihoomi amano «Kafarame» amanoya.) Ibaaddotina seete aale. Deenddaanna abbaabate emeete. ");
INSERT INTO bswl_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ollaatteessana hittakko horeene usu ebaataa giraan kaddeera ibaaddo, «Hikki ibaaddoti la hamas's'ee kaɂebaatareyolla?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Kookkoona, «Ogiraan usuya» Ameen, kuukina usu aani laara kuwaarre lakkoɂusuyyo ameen, usu ade, «Aniwayya» amaa gire. ");
INSERT INTO bswl_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ibaaddona, «Hayya Iilɂoɂootta misii banameen?» ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Usuna, «Yesuusa kaɂamaraan ibaaddoti erre c'awudisere Iiilɂoɂootteeyi shigide, Selihoomi tos seeyire goggoɂaalloon segee, seeyeerena aale, diyaanona daanddee» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Isona, «Hayya, usu ibaaddoti eetii gira?» Ameen. Usuna, «Ani laakkaso» ame. ");
INSERT INTO bswl_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Isona Iilɂo baye kagire ibaaddoti Farasaawiil tos geesen. ");
INSERT INTO bswl_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesuusa c'awudo shigidere Iilɂo oɂibaaddoti kakkobanera Ayihuudin tafoolissi arrite. ");
INSERT INTO bswl_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Haanssun Farasaawiil misii diyaano daanddeero hoosaten. Ibaaddotina, «Usu Iilɂoɂootteeyi c'awudo shigide» aninna «Aale hikkima diyaa gira ame.» ");
INSERT INTO bswl_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farasaawilkko kookkoo, «Hikki ibaaddoti tafoolssi arri mankkokabajiinon maraan, Waakko lakkoyo» Ameen. Kuukina adeen, «C'ubbaaleessa, hikka aankkikki maalaata misii felin daanddaara?» ameen. Isiɂorroonna isiɂaatiwaatti met't'aantte. ");
INSERT INTO bswl_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Haanssun, Iilɂo baye kagire ibaaddoti tos abbaabatereen, «Iilɂoɂoottaa kabanero ibaaddotikokki gara ati me amatta?» ameen. Ibaaddotina, «Usu kahegerooya» ame. ");
INSERT INTO bswl_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ayihuudina usu oɂumuleeraan tos farigureen taaɂuumissisiraanii ibaaddoti Iilɂo baye kagire laanona adena diyaanokkeessana lakkoɂammanatereen. ");
INSERT INTO bswl_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Isona, «Iilɂo baye umulamera kaɂamattaan erekkisin hikkaya? Hayya gidda misii din daanddee?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Oɂumuleeraanna, «Erekkaani laanona Iilɂo bayi umulamano kanssowa.» ");
INSERT INTO bswl_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Gidda ade misii diyaano daanddeero Iilɂoɂootteessa maayyo banero noo laakkansso isi kadanddee ibaaddoti mankkollee maraan, isiɂoottessaawun ayeesin daanddaara usu hoosayen ameen abbaabeen. ");
INSERT INTO bswl_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yesuusa, Kiristoosaya ami kaɂatotee dubba min kaɂebi kaɂayihuudikko goggohororamiroo Ayihuudi t'ayeen murittesseen mankkogireen maraan, oɂumuleeraan hikka kakkoonɂameeren Ayihuudi abissateerenya. ");
INSERT INTO bswl_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Haanssun oɂumuleeraan usu isi kadaanddee ibaaddoti mankkolleero maraan usu hoosayen ameen. ");
INSERT INTO bswl_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Iilɂo kabayere ibaaddotina kallami uumeene, «Ati ibaaddoti, Waa kabajiina,» «Hikki ibaaddoti c'ubbaaleessa laano noo kanssowa» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Usuna «C'ubbaaleessa laano ani laakkaso ayesuun goɂameen ani Iilɂo baye kagire laanona gidda ade diyaanokkee hikka ayees koo kasa» ame. ");
INSERT INTO bswl_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Isona, «Usu kuun me felera? Iilɂoɂoottaanna misii banera?» ameen hoosateen. ");
INSERT INTO bswl_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Usuna, «Horaa ani isinuun segeera, lakkoc'ak'assettaan, mewuun adi maaln dootaattan? Isinna addeen usukko kaɂagaalssataro liin dootaattan?» ame. ");
INSERT INTO bswl_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Isona, «Ati hikka ibaaddotikko kaɂagaalssaattotta, noo Musekko oɂagaalssatannonna! ");
INSERT INTO bswl_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Waa Musene wota ayeesano noo kanssowa, hikki ibaaddoti ade eetikko emeetero suure laakkansso» ameen ayeeseen. ");
INSERT INTO bswl_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ibaaddotina, «Isin usu eetikko emeetero addeesiwatti kasaadisiroya, halleewo kuwaarre usu Iilɂo oottee banera. ");
INSERT INTO bswl_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Waa kamaalara, usu kaɂabissatarona feɂitteessa kafelaro kuwaarre, c'ubbaalessaal maaliwaatti noo kanssowa. ");
INSERT INTO bswl_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Iilɂo baye kaɂumulamero ibaaddoti Iilɂo kabanera girowa goɂameen, alami aroomet't'aamekko haggaɂabere maayyona maale laakaso. ");
INSERT INTO bswl_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Hikki ibaaddoti Waakko lii waatewa hikka felin lakkodaanddaare ame abbaabe.» ");
INSERT INTO bswl_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Isona, «Maar dubbaa c'ubbo baate kaɂumulantetta, ati noo agaalssisin misii jaabuu tusaatta?» ameen abbaabeen, horooren. ");
INSERT INTO bswl_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesuusana ibaaddoti horooramano maale, usu kakkohelare gooratana, «Ati ere kaɂibaaddoyi ammanatta?» ame. ");
INSERT INTO bswl_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ibaaddotina, «Goottakki ani usuu goggoɂammannoon usu ayyoyya?» ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesuusana, «Deetetta, giddana kunne wota kaɂayeesara usuya» ame. ");
INSERT INTO bswl_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ibaaddotina, «Goottakki ani ammaninnara» ame sagade. ");
INSERT INTO bswl_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesuusana, «Odiyaannon goggodeerawun, odiyaaranna goggodiyaannonkko, firddin hikka alami tos emeeyera» ame. ");
INSERT INTO bswl_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Yesuusa wota ogireen Farasaawilkko kookkoo hikka ayees maaleenguren, «Me amanoya? Hayya noonna Iilɂo odiyaannonna amanoya?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesuusana, «Odiyaannon lii gitteenwa isinuun c'ubbo lakkolaare, gidda ade diyaanna mankkoɂamattaan maraan, c'ubbokkisin goggogiroo girnnara» ame. ");
INSERT INTO bswl_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Esekkona Yesuusa «Ani rumminaa rumminaa amara, awud kaɂidaad tos ufane anleennon giraan banɂe takkaleenne firime katabara kahetarona kasaamaroya. ");
INSERT INTO bswl_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Karrane katabara ade usu idaad kafoofaroya. ");
INSERT INTO bswl_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Karra kaɂoorara karra banara, idaadkkeessana yaayetteessa maalara. Idaadkkeessana megekkisooyi uumaa beesinara. ");
INSERT INTO bswl_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ootteessa olleeran dubba kakkobeese goorata horehaye sesseetara idaandda yaayetteessa mankkokaso maraan debee sesseetara. ");
INSERT INTO bswl_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Martti kalleero goɂameen iso yaayetteessa mankkokasoon maraan usukko bak'ataran kuwaarre suure usuu debee lakkosesseetaran» ame. ");
INSERT INTO bswl_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesuusa hikka masuussa segee; iso adeen usu me segeero lakkoshaaderan. ");
INSERT INTO bswl_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Haanssun Yesuusa kallami, «Ani rumminaa rumminaa amara, kaɂidaadjjool karra aniya. ");
INSERT INTO bswl_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Inkko horeene oɂeemeteeren dubba hetona ossaamaraanyan, idaadjjoolnna adeen iso lakkomaaleen. ");
INSERT INTO bswl_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Karra aniya, in tosne katabara dubba fayyaara, tabara, biyaara, bobbana helatara. ");
INSERT INTO bswl_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Heto hetin, lagadin baasin kaalaawun emaatta, ani ade kakkoon emeeyera duuddotti neefo goggogirttonya ame.» ");
INSERT INTO bswl_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Adena «kaɂidankki kafoofee aniya, kaɂidankki kafoofee neefotteessa idaadjjool maraan roorise sisara. ");
INSERT INTO bswl_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Maragadeen kafoofara ade idaadjjool kakkeessa mankkolleenon maraan, hiyyeeyi goɂemeetto idaad iisere bak'atara, hiyyeeyina idaad abatta, darɂaatta. ");
INSERT INTO bswl_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kakkoonbak'atarana maragadeen kafoofaro mankkollee maraan idaaduun kanenɂeeyissannoniya. ");
INSERT INTO bswl_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Kaɂidankki kafoofee aniya, kakkee kalleero idaad ani kasowa, isona in kasaaniwa. ");
INSERT INTO bswl_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Hikkina odo in goggokaso malee aninna odo goggokaso maleeya, neefotteenna idaadkkee maraan roorisi sisinara. ");
INSERT INTO bswl_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Hikka awudkko kalleennoon kakkalee idaad gira, isona keenano dootisara, isona yaayettee maalaraan, maate toonna leeraan, kafoofenna kooyya. ");
INSERT INTO bswl_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","«Ani abbaabi atayin neefottee roorssayi mankkosisinaro maraan Aabbokki in geelaatara. ");
INSERT INTO bswl_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Neefottee feɂitteeyi roorisi sisinara kuwaarre inkko maayyona lakkoɂaatiro, roorisi sisininna leere keesin odonnati aba, hikka ajaja kakkoɂatayera Aabbokkeekkoya» ame. ");
INSERT INTO bswl_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Hikka haafurakko kakkeeyi Ayihuudi orroo adena isiɂaatanawaatti met't'aame. ");
INSERT INTO bswl_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Isokko omoogganna, «Usu durrisa aba, k'olamera, muun maalattan?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kakkalee ade, «Hikki ayees durrisa kakkogiro ibaaddotikokki ayees lakkoyo, durrisa ilɂo kabaye banin daanddaara?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Iyyerusaalemiinna k'ulluukki min kawaakki usubaatanokokki baala lee, gooratana bat't'eesaye, ");
INSERT INTO bswl_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesuusana k'ulluukki min kaɂebii Solomooni kakkosesseetarone rooraa gire. ");
INSERT INTO bswl_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ayihuudina maraamureene, «Hagge taa geetoon wodanattani rereesi kayinatta? Ati gokiristoosatto addeesisi noon segii» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesuusana, «Ani isinuun segeere, isin addeen lakkoɂammanattaan, Aabbokkeekki megee ani ofelara felo garakkee atotaaran. ");
INSERT INTO bswl_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Isin addeen idaadkkee mankko laanawaatteewun lakkoɂammanattaan. ");
INSERT INTO bswl_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Idaadkki yaayettee maalara, aninna kasowa, isona indebee sesseetanan. ");
INSERT INTO bswl_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ani isinuun jiruu jiroommakki giri sisinara, duuddo lakkobaataan, genetteekkona isin basi aatin kadaanddeera maayyona laagiro. ");
INSERT INTO bswl_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Iso iin kasisera Aabbokki dubbaankko roorara, Aabbokkeetti genekko maayyona basi aatin lakkodaanddeero. ");
INSERT INTO bswl_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Aninna Odokkina koonna ame.» ");
INSERT INTO bswl_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ayihuudi Yesuusa adeen eeggiin eɂemo keeseen. ");
INSERT INTO bswl_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesuusa ade, «Odo dollekko omooggan ojinjjiin felo oɂidan tusewwa, hayya hikkasikko eekun eegginattan?» ame. ");
INSERT INTO bswl_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ayihuudina, «No ku kakkoonɂeegginanna, gadeekki ibaaddoti leete giraan, isiɂoottaa Hedo yelattedde Waa mankkohabaartte maraanya kuwaarre oɂidanɂi feloɂoottaawun lakkoyo» ameen abbaabeen. ");
INSERT INTO bswl_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesuusana, «Seerakkisinii, ‹Isin waalttaan ame amame lakkos'aafameroya›? ");
INSERT INTO bswl_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Haafura kawaa okkoonɂemeetero ‹waalttaan› goɂame mas'aafa k'ulluukkina iggilissamin kadaanddaamon gollee. ");
INSERT INTO bswl_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Hayya, ‹Ani ere kawaayya› mankkoɂamero maraan, Odo ussun kale yelatere alami tos kafarero, ati Waa inggaamatta mewuun amattaan? ");
INSERT INTO bswl_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ani Aabbokkeenɂi felo kafelaro golleennoon arooɂammanatteen. ");
INSERT INTO bswl_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kafelaro gollee ade in goɂammanatana waatteenna, Odo iin girano aninna Odoon girano addeesinna shaadi goggolleetawun feloɂootteessaa ammana ame abbaabe.» ");
INSERT INTO bswl_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Adena abin dooteen, usu ade genekko beesate. ");
INSERT INTO bswl_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Esekko Yesuusa t'aye Yaannisa takkot'ammak'are, Yorddaanosi gama tos abbaabate, eseenna adallaate. ");
INSERT INTO bswl_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ibaaddo kamoogganna usu tos emeete, isona, «Yaannisa koonna malaata lakkofelero, ayesuun goɂameen hikka ibaaddotikki gara kaɂayeesera dubba rummiya» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ese banɂe omooggan Yesuusaa ammaneen. ");
INSERT INTO bswl_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kamayiraamena abbattiseekki kamaartta maamani Bitaanyaayi kagire Alaazari hawɂaamaa gire. ");
INSERT INTO bswl_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Hitti abbikkise Alaazari takkoon hawɂaamare Mayiraame, Goottaa gutii shittoo kibttedde lukkitteessa metekkiseeyi tashaakkaratetta. ");
INSERT INTO bswl_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Abbalaal lama, «Goottaa; ati kageelaatta ibaaddoti hawɂamara» ameen handdaa fareen. ");
INSERT INTO bswl_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesuusa hikka kakkomaalare goorata, «Hikki hawɂaami Ere kawaa usu goggokabajaamironna kabaja tawaawunya kuwaarre goyiin kageegisiro lakkoyo» ame. ");
INSERT INTO bswl_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesuusana Maartana, abbatisee Mayiraamena abbikkisoo Alaazari geelataa gire. ");
INSERT INTO bswl_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Golleenna kaɂalazaari hawɂaamano maale giraan takkogire banɂee arriti lama haye. ");
INSERT INTO bswl_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Esekko abbaabatere usukko oɂagaalssataranne «Ul kayihuuda tos abbaabana» ame. ");
INSERT INTO bswl_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Usukko oɂagaalssataranna, «Kaɂagaalssisatto, arri tic'c'arkko horeene Ayihuudi ku eɂemoo eeggiin dootaa gire, adena eserraa seeyinatta?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesuusana «Arri too la saatii tomonkko lammattola? Hikka alamikokki ifakko kakkeeyi mankkodiyaaro maraan arrii kasessetara lakkohanduddufataro. ");
INSERT INTO bswl_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kahanduddufatarana ade hemeen kasesseetaroya, aalanttina ifa lakkoɂabo ame abbaabe.» ");
INSERT INTO bswl_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Hikka segee abbaabatere, «Noo kageelaattanna Alaazari huddurera, aninna huddurokko usu keesin seeyinara» ame. ");
INSERT INTO bswl_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yesuusakko oɂagaalssatareen «Gootta! Gohudurero fayyirowa» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesuusa hikka kakkoseegera kaɂalazaari goyikokki garaye, usukko oɂagaalssatareen adeen hudduranokokki gara kaɂayeesero aani leera. ");
INSERT INTO bswl_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Haanssun Yesuusa addeesise, «Alaazari goyera. ");
INSERT INTO bswl_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Isin goggoɂammanttaanun, esee giriwaattikki isin maraan geggelaayisara, gidda adi usu tos seenna.» ");
INSERT INTO bswl_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Esekkona Didimoosa kaɂamamare Toomaasa okkalee Yesuusakko oɂagaalssatareen, «Noonna seeyinne usune wota goonna» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesuusa eserraa kakkogiyaare goorata Alaazari gok'amalamesikko arri afar leetette. ");
INSERT INTO bswl_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bitaanya Iyyerusaalemikko kilo metira seed gitakki fakkintte gitte. ");
INSERT INTO bswl_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Kamooggan Ayihuudina Maartana Mayiraamena abbikkisokki goyii goggoɂisin emeeten gireen. ");
INSERT INTO bswl_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Maartta Yesuusakokki emeetano maaltedde k'op'ayin beete, Mayiraame adde min hesse gitte. ");
INSERT INTO bswl_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maartana Yesuusane, «Gootta! Ati hittanii gittewa, abbikki lakkogowaare. ");
INSERT INTO bswl_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Gidda gollee kaɂebaatto dubba Waa sisano kasowa antte.» ");
INSERT INTO bswl_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesuusana, «Abbikka goyikko kinnara» ame. ");
INSERT INTO bswl_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maartana, «Tagachchoo arrii goyikko kakkinnara ani kasowa» antte. ");
INSERT INTO bswl_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesuusana; «Goyikko kiyaanona neefona aniya, iyyee kaɂammanara goggoyena neefo girara. ");
INSERT INTO bswl_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Iyyee kagira, kaɂammanarana suure lakkogooro, hikka ammanatta?» ame. ");
INSERT INTO bswl_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Esena, «Ii Goottakki, ati alami tos kaɂemaatto Kiristoosa Ere kawaa laano ammanara» antte. ");
INSERT INTO bswl_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maartta hikka antte abbaabattedde, abbatisee Mayiraame kale uunttede, «Kaɂagaalssisara emeetera, ku uumara» antte. ");
INSERT INTO bswl_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mayiraamena hikka goggomaalttee saantte keetedde Yesuusa tos seette. ");
INSERT INTO bswl_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Usu goorata Yesuusa, Maartta usu takkok'op'attetto banɂe gire kuwaarre, ganaa maaman tos lakkotabere. ");
INSERT INTO bswl_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mayiraame goggoɂisaa min orroo ogireen Ayihuudina, firimi biyaano deenee, k'amal tos seette kaɂowatto aani leere debee been. ");
INSERT INTO bswl_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mayiraamena Yesuusa mankkogiro banɂe tos geete goggodeeteenna, lukii hegelii iitedde, «Goottakki, ati hittanii kagitte leetewa, abbikki lakkogowaare» antte. ");
INSERT INTO bswl_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesuusana ese ootaa giraan, debee kaɂemeetera Ayihuudina ootaa giraan deegure ayyaana gaddaa shaalagamere, ");
INSERT INTO bswl_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","«Haggee k'amalitteettaan?» ame hoosate, isona, «Goottakki, koyi deena» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesuusana ilmmi beesate. ");
INSERT INTO bswl_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ayihuudina, «Misii usu geelataa gire deetene!» ame. ");
INSERT INTO bswl_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Isokko kookkoo ade, «Ilɂo kabayere ilɂo kabanara, hikki ibaaddoti goggogoononkko usu yelin lakkodaanddaareya?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesuusa wodanatteessa kallami gaddaa dinanttedde k'amali tos seete, k'amalkkeessana eɂemo kac'ufamero lagaye. ");
INSERT INTO bswl_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Usuna, «Eɂemo keesa» ame. Kagoyerekotti abba Maartta, «Gootta! Usu goyere arri afar mankkoɂadallaatero maraan gidda urmmaatara» antte. ");
INSERT INTO bswl_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesuusana, «Ati goɂammanatte kabajja tawaa gachoo deeta ame ani kuun lakkosegeereya?» ame. ");
INSERT INTO bswl_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Haanssun ibaaddo eɂemo keese, Yesuusana elddee deere, «Aabbokki, mankkomaaltte maraan ani ku galataara, ");
INSERT INTO bswl_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Arri dubba ati in maalano ani kasowa hikka ayeesano ade hittanii kaɂaalleera ibaaddona ati in farano goggoɂammannaawun amereya» ame. ");
INSERT INTO bswl_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesuusa hikka ame abbaabatere yaaye t'ok'k'iɂisere, «Alaazari, koyi been!» ame uume. ");
INSERT INTO bswl_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kagoyere Alaazarina genenna lukkiina tamammarantte gashenne wota, bebbeediinna hoc'c'oo goggomammaranttee bee. Yesuusana «Gashe tak'amal furaddeen isaaga haseete» ame. ");
INSERT INTO bswl_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Haanssun Mayiraame tos kaɂemeetere Ayihuudikko kamooggan ibaaddo, Yesuusa ofelero felo deegure usuu ammane. ");
INSERT INTO bswl_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kookkoona ade seeteerene Yesuusa kafelero Farasaawilun seegeen. ");
INSERT INTO bswl_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Esekko katuuk'aamol woyichchaalnna Farasaawiil taɂayihuudi songoonii kukkuyisenguren haa ameen, «Hikki ibaaddoti kamooggan malaata felaa mankkogiro maraan noo me goyelne iidira? ");
INSERT INTO bswl_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Adda no goɂiinsse ibaaddo dubba usu ammaninara, karoomi ibaaddona emeeyire ulkkaanina gosakkaani baasinara ameen.» ");
INSERT INTO bswl_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Isokkona koo usu geesii tuuk'aamon woyichcha kalleera K'eyaafa, «Isin koonna laakkasaan! ");
INSERT INTO bswl_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Gosa dubba kabaarokko gosa maraan odo koo goggoye isinuun kaɂidan laano lakkoshaadattaan? Ame.» ");
INSERT INTO bswl_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Hikka kaɂamera iskko lakkoye, ayesuun goɂameen usu geesii usu tuuk'aamon woyichcha mankkolleere maraan, Yesuusa gosaan kagoyinaro laano hinɂa hegero ayeesanoya. ");
INSERT INTO bswl_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Usu kakkoongowara gosa kaalaawun halleenon giraan kadarɂamero yiis kawaa raattoo kukkuyisinya. ");
INSERT INTO bswl_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ese arrikko haggaɂabereen Yesuusa lagadin makkareen. ");
INSERT INTO bswl_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Haanssun Yesuusa esekko abbaabatere Ayihuudi orroo diidaa bee lakkosesseetero, ayesuun goɂameen ul k'alullattokki dollee tagitto Efireemi kaɂamamaro maaman tos seetere eseenna usukko oɂagaalssatareene wota addallaate. ");
INSERT INTO bswl_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Kaɂayihuudi faasikkaa goggogabbalamee, baala giyaanokko horeene kamuc'c'imano seera felin omooggan ul ulkko Iyyerusaalemi tos been. ");
INSERT INTO bswl_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Yesuusana dootaa gireen, k'ulluukki min kawaayi aalleene, «Meɂaani laara? Baalan suure lakkoɂemeeroya?» amaa isiɂisi hoosaten. ");
INSERT INTO bswl_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Katuk'aamo woyichchaalnna Farasaawiil ade Yesuusa abin eetii giro kakkasa ibaaddo goggotusironna goggoɂabroon ajajeen gireen. ");
INSERT INTO bswl_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Kafaasikkaa baalawun arri lewo hesaa Yesuusa, goyikko kakkeesera Alaazari mankkogiro Bitaanya tos seete. ");
INSERT INTO bswl_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Eseenna Yesuusaan kita kahemeenee ekkaasen, Maartta gohandayito, Alaazari usune wota babo aamin kahamas'eerokko kooyye. ");
INSERT INTO bswl_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mayiraamena dookki awɂallo talleete liitiroo mina tamuc'c'intte tanardoosa shittoo keenttedde luki tayesuusaa gutii kibtte, lukkitteessana metekkiseeyi shakaartte, minna shittookotti urtii ammagame. ");
INSERT INTO bswl_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yesuusakko oɂagaalssatarankko koo danbbenne roorise kasisera kaɂask'orotu Yihuuda ade neebaataa, ");
INSERT INTO bswl_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Hitti shittoo seed boolee t'agaraawun daddalamidde maragadena hiyyeessan muun sisiwaatte?» ame. ");
INSERT INTO bswl_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Hikka kakkoonɂayyeesera kamaragade shile kaɂabare mankkollee maraan kakkaamaro maragadekko ussun atate kahaare heto mankkolleewun kuwaarre hiyyeessan mararere lakkoye. ");
INSERT INTO bswl_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesuusaan, «Hitti shittoo tak'amal arriwuun kayelttetto ekkaasano mankkollee maraan isaaga. ");
INSERT INTO bswl_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Hiyyeessal maagoreenna isin wota giraan, in addeen arri dubba lakkohelnnattaan,» ame. ");
INSERT INTO bswl_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Usu goorata kamooggan kaɂayihuudi ibaaddo Yesuusa esee girano addeeseren usu tos emeeten, oɂemeeteraanna Yesuusa kaalaa ameen halleenon giraan, usu goyikko kakkeesero Alaazarina diinyya. ");
INSERT INTO bswl_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Haanssun Tuuk'aamokokki woyichchaal adeen Alaazari lagadin makkareen. ");
INSERT INTO bswl_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Hikkina aalantti teessaa kamooggan kaɂayihuudi ibaaddo Yesuusa tos seeteere ammanaa mankkogire maraanya. ");
INSERT INTO bswl_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Babbarinssa baalan kaɂemeetara gosa kamooggan Yesuusa Iyyerusaalemi tos emeetaa girano maaleen, ");
INSERT INTO bswl_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","baalallo ozanbabaa abeen k'op'ayin been, Yaayettisona t'ok'k'iseene, «Hoosaɂina!» «Mege kagoottayi kaɂemeetara kasommaasameya!» «Wono kaɂisiraɂeel kasommaasameya!» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesuusana darmmee tademeer helatere hamas's'ee, haa amamena goggos'aafameroo, ");
INSERT INTO bswl_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Ere kas'iyoni arooɂabssatte! Hikkima wonokka darmmee tademeer hamas's'eere emeetara» Amameen os'aafameraan hegero goggogudarawunya. ");
INSERT INTO bswl_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yesuusakko oɂagaalssataranna hikka dubba horaarjje lakkoshaaderen, usu maraan kas'aafamerana usuna ofelamereen felo kakkoɂaddeeseraan Yesuusa kabajjaame kakkoɂabbaabatare goorataya. ");
INSERT INTO bswl_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yesuusa Alaazari gumbbikko uumegure goyikko kakkokeesere goorata, usune wota kagire ibaaddo dubba goyikko kiyaanokkeessa atotaa gire. ");
INSERT INTO bswl_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ibaaddo kamooggan usu hikka baasakki malaata felano mankkomaalere maraan k'op'ayin bee. ");
INSERT INTO bswl_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Haanssunna kafarasaawil ibaaddo isiɂisiɂorroo, «Goorta me yelano dootisara? Deetene! Alami dubba mina abbaabate usu debee sesseetera» isiɂorroo ameen. ");
INSERT INTO bswl_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Hedoyisayiin baala tos obeeraan orrokko kagirikki ibaaddona gire. ");
INSERT INTO bswl_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Isona Galiila tagitto Beetesayidakko kalleero ibaaddoti, Filp'oosa tos emeetene, «Gootta,» maganne, «Noo Yesuusa din dootanna» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filp'oosana, Indiraasaan segin seete, Indiraasana Filp'oosana seeterene Yesuusaan segeen. ");
INSERT INTO bswl_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesuusana, «Ere kaɂibaaddo takkokabajaaminara saatii geetetta. ");
INSERT INTO bswl_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ani rumminaa rumminaa amara, il taddargammaa erree gutii iide goggoonnon kale hesata, goggoote ade il tamooggan sisatta. ");
INSERT INTO bswl_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Neefotteessa kageelaatara waatara hikka alamiin neefotteessa kadiidara ade jiruu jiroommakki giri usu ooratara. ");
INSERT INTO bswl_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Iyyeen handayin kadootara gogire indebee hasesseete, aninna mankkogiroo iin kahandaarana esee girnnara iin kahandaarona Aabbokki kabajjirowa. ");
INSERT INTO bswl_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Gidda neefotti c'annak'aanttetta me amira? ‹Aabbokki hitta saatikko in haasi amu›? Halleewo kakkoonɂemeeyera hitta saatiiwunya. ");
INSERT INTO bswl_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aabbokki! Megekkaa kabajjii» ame. Esekko abbaabatere, «Megekkeenna kabajaayera, adina kabajinara» taɂamatta yaaye daruurkko emeette. ");
INSERT INTO bswl_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Esee aallee kagire kamooggan ibaaddo yaaye kakkomaalare goorata, «Huruuntta» ame; kakkalee ade, «Erggichchaya kaɂayeesara» ame. ");
INSERT INTO bswl_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesuusa, «Hitti yaaye kakkoonɂemeettetta in maraan halleenon giraan isin maraanya, ");
INSERT INTO bswl_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Hikki alami kakkofirddaaminara goorata giddaaya, hikka alamkokki mootii gidda sarddi shafaminara. ");
INSERT INTO bswl_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ani ade ulkko t'ok'k'i t'ok'k'i kakkoɂame goorata ibaaddo dubba in tos kukkuyisinara.» ame. ");
INSERT INTO bswl_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Hikka kakkoonɂayeesera misikki goyi goyinaro tusinye. ");
INSERT INTO bswl_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Gosana, «Noo Kiristoosa jiruu jiroommaan girano seerakko maalnenna, hayya, ‹Ere kaɂibaaddo t'ok'k'i t'ok'k'i amano dootisara misii amatta›? Hikki ‹Ere kaɂibaaddo ayyoyya›?» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesuusana, «Goortanu goorata kic'c'arun ifa abittaan, mugud haɂemennon giraan, ifa giraan sesseeyen, mugud kasesseetara eetirraa seetaro laakkaso. ");
INSERT INTO bswl_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yiis kaɂifa goggolleetawun ifa girantuun hikka ifaa ammana.» ame. Yesuusa hikka ayeese goggogudisee kale bee golate. ");
INSERT INTO bswl_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesuusa hikka malaata dubba iso horee gofelena suure giddana lakkoɂammanateraan. ");
INSERT INTO bswl_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Hikkina kahegeroo Isiyaasa, «Goottakki atonnatikkaani ayyoya kaɂammane? kagoottaa hunnana ayyoon mute?» kaɂamamera haafura goggogudaroonya. ");
INSERT INTO bswl_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Haanssun ammanin lakkodaanddeeran, hikkina Isiyaasa banɂe takkaleeyi haa ame goggoɂayeeseroya. ");
INSERT INTO bswl_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Ilɂoɂoottisooyi goggodiyaannonkko wodanattisooyinna goggoshaadonkko abbaabayinna goggofayyinonkko Waa Iilɂoɂoottisoo baasera, wodanattisoonna duudisera.» ");
INSERT INTO bswl_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isiyaasa hikka kakkoonɂamera kabajatteessa mankkodeero maraanya, garakkeessana ayeese. ");
INSERT INTO bswl_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Golleenna, kaɂayihuudi woyichchaalkkona kamooggan usuu ammane, halleewo kuwaarre Farasaawiil Ayihuudikokki min kaɂebikko iso goggobeesonkko abssateeren ammananokisoo beeseen lakkosegaateren. ");
INSERT INTO bswl_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Hikkina kakkonlleera Waakko taɂemaatto kabajakko roorssateen ibaaddo dollekko taɂemaatto kabaja mankkogeelaaten maraanya. ");
INSERT INTO bswl_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Esekkona Yesuusa yaaye t'ok'k'isere, «Maayyona iyyee goɂammane in kaalaalii halleennoon giraan in kafareroona ammanara. ");
INSERT INTO bswl_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","In kadiyaara in kafarero diyaara. ");
INSERT INTO bswl_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Iyyee kaɂammane mugudii goggogiroonkko ifallee alami tos emeeyera. ");
INSERT INTO bswl_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","«Haafurakkee maalire kaɂoorannoo gutii kafirddinara lakkoɂaniyyo, ani alami fayyiisin kuwaarre alami gutii firddin lakkoɂemeeyero. ");
INSERT INTO bswl_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","In kaɂatannoonna haafurakkee kayeraasaroo gutii ani kakkofirddinaro aba, ani kaɂayeesera haafura usuwa tagachchoo arri firddinara, aalantina ");
INSERT INTO bswl_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ani iskko lakkoɂayeesaro ayesuun goɂameen in kafarera Odo me ayeesinarona misii ayeesinaro ajajeera. ");
INSERT INTO bswl_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ajajakeessa jiruu jiroommakki giri laano kasowa, haanssun ani kaɂayeesara dubba Odo kasegeero kaalaaya ame abbaabe.» ");
INSERT INTO bswl_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Gooratana kafaasikkaa baalakko horenne gire, Yesuusana hikka alami iisere Odo tos kakkoseeyinara goorata giyaano addeesere, alami ogireen ootteessa olleeraan geelatera, taagachcho geeronna geelate. ");
INSERT INTO bswl_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kita kahemeene horee roore giraan, Yesuusa roorisi goggosisiroon daabloosa ere kasimoona kaɂask'orotu Yihuuda wodana kekkeese gire. ");
INSERT INTO bswl_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesuusana, Odo ayees dubba odonnatikkeesa hegelii goggoyeleroo, Waakko faramanona Waa tos abbaabatanokkeessa addeesere, ");
INSERT INTO bswl_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kita kahemeenekko kee, sarssi kayegure mooɂinna hoc'c'o mowaate. ");
INSERT INTO bswl_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Esekkona kakkoɂaalisaran huuyi beke kibere usukko oɂagaalssatareenkonɂi luk'k'a aalisaa tamuwaatero hoc'c'oo shakaarano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simoona P'et'iroosa tos emeete, P'et'iroosana, «Goottakki, ati lok'ak'k'oɂootte aalisinatta?» ame. ");
INSERT INTO bswl_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesuusana abbaabere, «Ani kafelaro ati gidda laakkasso, haarre adi shaaddowa» ame. ");
INSERT INTO bswl_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","P'et'iroosana, «Laa ati lok'k'aɂootte inkko suure lakkoɂaalisso ame. Yesuusana ani ku goɂaalisanawaaye ati inne wota esella lakkoɂabtto» ame. ");
INSERT INTO bswl_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoona P'et'iroosana, «Goottakki» goorttanun «Lok'ak'k'oɂootte oolaal anlleenon giraan genetteenna metekkeenna aalisina ame.» ");
INSERT INTO bswl_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesuusana, «Maar kaɂaalero ibaaddotiin kadootisara lok'ak'k'o oolaal aalanoya; kahesera maar ade kamuc'c'imeya. Dubbana gollaanawaatteenna isin omuc'intteenttan» ame. ");
INSERT INTO bswl_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Isin dubbana omuc'intteen lakkottan usu kakkonɂamera usu roorisi kasisinara ayyoyo mankkokaso maraanye. ");
INSERT INTO bswl_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Lok'ak'oɂoottisoo aalise abbaabatere, huu sarssate abbaabatere banɂee hamas's'eere, haanna ame, «Ani isinuun kafelero shaadattaan?» ");
INSERT INTO bswl_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","«Isin, in ‹Kaɂagaalssisarona› ‹Gootta› amattaan, garaya, goggoɂamattaani usumaleewwaya. ");
INSERT INTO bswl_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Goortta ani Goottakkisinna kaɂagaalssisaro lee giraan lok'ak'k'oɂoottisin goɂaalise, isinna hikkamalee isiɂisirroo lok'ak'k'oɂoottisin aalssayiin dootisara. ");
INSERT INTO bswl_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ani goggofelerokki malee isinna hikkamaleewa goggofelttaanun masuussaa segeera. ");
INSERT INTO bswl_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ani rumminaa rumminaa amara, kahandaara goottakko, kafaramerana kafarerokko lakkorooraro. ");
INSERT INTO bswl_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Goortta hikka ayees addeesiddeene felooyi gohayisseen osommaasantteenttan. ");
INSERT INTO bswl_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Isin dubbaan ayeesano lakkoyo, oɂassaabero kasowa, ayesuun goɂameen, ‹Babokkee iinne wota kaɂebsatera diina lee kee kaɂamara mas'aafa k'ulluukkikokki haafura goggogudaroonya.› ");
INSERT INTO bswl_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","«Kakkogudate goorata ani laano goggoɂammanttaanun, hikki laanokko horene gidda segeera. ");
INSERT INTO bswl_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ani rumminaa rumminaa amara, ani kafarero kaɂatatara in atatara, in kaɂatatena kafarero atatara.» ");
INSERT INTO bswl_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Hikka ame abbaabatere Yesuusa ayyaana shaalagamere, «Ani rumminaa rumminaa amara, isin orrokko koo in roorisi sisinara» ame addeesise segee. ");
INSERT INTO bswl_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yesuusakko oɂagaalssatareen usu ayyo amero girddi ameeren isiɂisirroo isiɂisii diyaaten. ");
INSERT INTO bswl_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Isokko koo, Yesuusa kageelaatare usukko kaɂagaalssatare Yesuusaa dollee gabbalame hamas's'ee gire. ");
INSERT INTO bswl_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoona P'et'iroosana hikka usukko kaɂagaalssataren malaata tusere «Maayyo amaro hoosa» ame. ");
INSERT INTO bswl_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Usuna geegiyo tayesuusaa gabbalamere, «Goottakki, ku roorisi kasisinara ayyoyya?» ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesuusana «Hikka babo tuwano koo kaneɂaamiraneta eeggere kakkoonsisara usuya» ame. Esekkona babo kaneɂaamiraneta eeggere ere kasimoona kaɂask'orotu Yihuuda tuyise. ");
INSERT INTO bswl_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yihuudana babo tuwano koo goggotuwatee goorsewa s'alaye tabtte. Yesuusana, «Kafelnnatto saami feli» ame. ");
INSERT INTO bswl_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Halleewo kuwaarre Yesuusa mewuun haa amero aamin ohamas's'eeraankko maayyona lakkoɂaddeesero. ");
INSERT INTO bswl_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yihuuda maragade kaɂabare mankkollee maraan baalan kadootisaro kooko goggoɂiminnoon goorttun hiyyeessaan goggosisiroo Yesuusa kaɂayeesero aani leera. ");
INSERT INTO bswl_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yihuudana usu babo tuwano koo goggotuwatee bee seete gooratana hemeenye. ");
INSERT INTO bswl_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yihuuda kakkobeeboware goorata, Yesuusa haa ame «Gidda Ere kaɂibaaddo kabajaamewa usuuyina Waa kabajaamewa. ");
INSERT INTO bswl_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Goortta Waa usuuyi gokabajaame, Waa Erekkeessa issii kabajaatara, goorsewa kabajinara. ");
INSERT INTO bswl_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","«Yiiskkee, isin wota kakkoɂadallaayinara goorata kic'c'arunya, isinna in dootinattaan, Ayihuudine, ani mankkoseetaro emeeyin lakkodaanddeetan isoon goggoɂameroo, giddana isinuun hikkawa amara. ");
INSERT INTO bswl_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","«Ajaja kaɂusub sisinara, hikkina isiɂisirroo goggogeelattawunya, goortta ani goggogeelayero malee isinna isiɂisirroo geelayene. ");
INSERT INTO bswl_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Isin isiɂisirroo isiɂisii gogeelatteen, ibaaddo dubba isin ootte inkko oɂagaalssattaan laano hikkanii addeesinara.» ");
INSERT INTO bswl_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoona P'et'iroosa, «Goottakki haggerraa seeyinatta?» ame. Yesuusana, «Ani mankkoseetaro gidda debee seeyin lakkodaanddeeto; haarre adi indebee sesseettowa ame abbaabe.» ");
INSERT INTO bswl_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","P'et'iroosana, «Goottakki, gidda ani ku debee sesseetana kakkoonwaatara mewuunya? Ku maraan neefottee golleetena roorssayi sisayinara» ame. ");
INSERT INTO bswl_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesuusana, «Ogiraan neefotta iyyeen roorisi sisinatta? Ani rumminaa rumminaa amara, lukkale haɂoyinnon giraan seed gali in kakayinatta.» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","«Wodanattisin arooc'annak'amo, Waayi ammana, iinna ada ammana. ");
INSERT INTO bswl_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Aabbokkeekki minii minjjool kamooggan kagira, hikki liwaatewa ani segarewa, kakkoonseeyinara banɂe ekkaasinya. ");
INSERT INTO bswl_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ani seeyirena banɂe kakkoɂekkaase goorata, ani mankkogiroo isinna inne wota goggogirttaawun isin aatin kallami emeeyinara. ");
INSERT INTO bswl_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ani kakkoseetara raa maaɂeekkiyo isin kassaanwa.» ");
INSERT INTO bswl_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toomaasana, «Goottakki, eetirraa siyaatto laakkansso, hayya, raa misii addeesin daanddaana?» ame. ");
INSERT INTO bswl_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesuusana, «Raa aniyya, rummina girina aniwayya, garakkeenne gollee kuwaarre Odo tos kaɂemeetara laagiro. ");
INSERT INTO bswl_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","In kakkassaan leeteenwa Aabbokkeenna addeesattenwa, giddakko haggaɂabiddeene adi addeessanwa, deetettaan.» ame. ");
INSERT INTO bswl_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filp'oosana, «Goottakki, Odo tusina noon leera» ame. ");
INSERT INTO bswl_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesuusana, «Filp'oosa! Gidda gin ani isinne wota gogirro in laakkassoya? In kaddee Odo deera, misii noon ‹Odo tusi amatta›? ");
INSERT INTO bswl_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ani Odoo goggogiro malee, Odona iyyee girano lakkoɂammanattoya? Ani isinuun kasegeera haafura iskko lakkoyo, ayesuun goɂameen felo kafelara iyyee kagiro Odoya. ");
INSERT INTO bswl_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ani Odoo goggogiro malee Odona iyyee goggogiro malee ani isinuun kasegaaro ammana, kakkalee gohesena felo ootteessaa ammana. ");
INSERT INTO bswl_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ani rumminaa rumminaa amara, iyyee kaɂammanara ani ofelaro felo felara, hikkina ade ani Odo tos mankkoseeyinaro maraan, hikkakko karoore felinnattaan. ");
INSERT INTO bswl_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Odo Eree goggokabajaamiro, megekkeeyi kaɂebaattan dubba felinara. ");
INSERT INTO bswl_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Maamisikki ayeesina megekkeeyi goɂebaatteen, ani felinara. ");
INSERT INTO bswl_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Gogeelatteen ajajakkee oorayinattan. ");
INSERT INTO bswl_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ani Odo ebaayinara, usuna isin wota jiruu jiroommaan kagirro kakkalee kagoggoɂisiro sisinara. ");
INSERT INTO bswl_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Usuna Ayyaana K'ulluukkiya, alami mankkodeennon maraaninna mankkokasoon maraan atayin lakkodaanddaaro, isin addeen, isin wota mankkogirnaro maraanna isin orroo mankkollinnaro maraan kassaanwa. ");
INSERT INTO bswl_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Odo kallayikki yiis aani ani isin lakkoɂiisinnaro, isin tos emeeyinara. ");
INSERT INTO bswl_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Goorata kic'c'arkko abbaabayi, alami suure in lakkodinnaro, isin addeen dinnattaan, ani arddokki mankkollee maraan isinna arddonɂi linnattaan. ");
INSERT INTO bswl_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ani Aabbokkeeyi goggogiro malee, isinna iyyee goggogittaan malee, aninna ade isinii goggogiro malee ese arri addeesinattaan. ");
INSERT INTO bswl_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","In kageelaatara ajajakkee kaɂoorataroya, kageelaatarona Aabbokki geelaatara, aninna geelaatara, isiɂootteenna tusinara.» ");
INSERT INTO bswl_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Esekkona kaɂask'orotu kalleenon Yihuuda, «Goottakki, hayya, alamiin halleennon giraan isiɂoottaa noyyeen kakkotusinatta misiiya?» ame. ");
INSERT INTO bswl_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesuusana, «Kageelaatara gogire haafurakkee ooratara, Aabbokkina geelaatara, usu tos emeeyinanna, usu wotana girinanna. ");
INSERT INTO bswl_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kageelaannon haafurakkee lakkoɂoorataro, hikki kamaalattan haafura in kafarero kaɂodoya kuwaarre kakkee lakkoyo. ");
INSERT INTO bswl_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«Gidda isinne wota giraan hikka dubba segeera. ");
INSERT INTO bswl_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Odo megekkeeyi kafarara kagoggoɂisara Ayyaana K'ulluukki ade ayees dubba agaalssisinara, ani kasegeerona dubba shaadisinara. ");
INSERT INTO bswl_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nogodda isinuun kayinnara, nogoddatteenna sisinara, ani tasisara alami tasisaro aanttitti lakkotto, wodanattisin arooc'annak'amo, aroonaɂabissano. ");
INSERT INTO bswl_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‹Ani seeyinara, abbaabayina isin tos emeeyinara› amanokkee maaltteettan, Aabbokki inkko mankkorooraro maraan in kageelaattan leeteenwa Odo tos biyaanokkeeyi geggelaattenwa. ");
INSERT INTO bswl_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ani kasegeera gogudate goggoɂammanttaanun, hikki laanokko horee t'aye segeera. ");
INSERT INTO bswl_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Hikka alamikotti mooti s'alaye mankkoɂemetatto maraan hittakko danbbeebaan isin wota tanjiin lakkoɂayeesinaro, usuna in gutii odonnati lakkoɂabo, ");
INSERT INTO bswl_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ayesuun goɂameen ani Odo goggogeelataro, malee Aabbokki kasisero ajaja goggofelaroo, alami goggoɂaddeesiroonya. Kiyaa, hittakko seenno» ame. ");
INSERT INTO bswl_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Karrummii gaa kawoyinii aniya, kaɂabbaraterana Aabbokkeeya. ");
INSERT INTO bswl_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Usuna in gutii tagitto il kadubamoon ballaal dubba Aabbokki goosi lugudinara, il kasisaro ballaal dubba adi aaloo il goggoɂdubanttoon iidisi k'ac'c'isinara. ");
INSERT INTO bswl_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kasegeero haafurakko kakkeeyi isin gidda omuc'c'intteenttan. ");
INSERT INTO bswl_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Iyyee gira, aninna isinii girnnara, ballaal gaa kawoyinii gutii goleenoon kale il sisin lakkodaanddaaro, isinna iyye goginnoon il sisin lakkodaanddaattan. ");
INSERT INTO bswl_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Ani gaa kawoyiniiyya, isinna ballaalttaan, maayyona iyyee gogire aninna usuu gogire usu il tamooggan sisara in kallayi koonna felin lakkodaanddeetan. ");
INSERT INTO bswl_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Iyyee kagginon ballaal shafame kaɂangagaro ballaal aankkikkiya, hikka aankkikki ballaal abaabami eleen tos shaafaminare, gubaminara. ");
INSERT INTO bswl_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Iyyee gogitteen haafurakkina isinii gogire, kadootattaan maamisikki kookona ebaayen sisamirowa. ");
INSERT INTO bswl_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Il tamooggan dubamanoo inkko oɂagaalssaattaan ootte laano gottusseen, hikkanii Aabbokki kabajaamara. ");
INSERT INTO bswl_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","«Odo in goggogeelateroo aninna isin geelayera, geelanjjetteeyi gira. ");
INSERT INTO bswl_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ani Aabbokkeekki ajaja oorayeere geelanjjetteessayi goggogiro malee isinna ajajakkee goɂooratteen geelanjjetteeyi girnattaan. ");
INSERT INTO bswl_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Geggeloɂootti isinii goggolleerawun geggeloɂoottisin oɂammagameen goggolleerawun hikka ani isinuun segeera. ");
INSERT INTO bswl_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ajajakki hikkaya, ani goggogeelayero malee isinna isiɂisi orroo geelayene. ");
INSERT INTO bswl_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ogeelaataro maraan neefo roorssayi sisatanakko taroortto geelanjje maayyona lakkoɂabo. ");
INSERT INTO bswl_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ani isin kaɂajajaaro felooyi gohayisseen ani ogeelaatarottaan. ");
INSERT INTO bswl_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Goortanu diyyijjoolkkee lakkoɂaminaro, diyyijjoolnna Goottaa kafelaro laakkaso, ayesuun goɂameen Aabbokkeekko kamaalero dubba mankkoɂaddeesisero maraan ogeelaataro amera. ");
INSERT INTO bswl_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Aniya isin kaɂassaabayera kuwaarre isin in lakkoɂassaabttettaan, seeyiddeene il goggoyelattaanun ilttisinna goggogirttoon ani isin shuumera, haanssun Odo megekkeeyi kaɂebaattan dubba sisara. ");
INSERT INTO bswl_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Isiɂisi orroo goggogeelattawun, ajajakki hikkaya. ");
INSERT INTO bswl_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Alami isin godiide, isinkko horeene in diidano addeesa. ");
INSERT INTO bswl_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Isin oɂalami lii gitteenwa, alami oottessa laano addeesire isin geelaatarewa, ani alamikko isin kale yele mankkoɂassaabero maraan oɂalami lakkottaan, alamina kakkondiidara haanssunya. ");
INSERT INTO bswl_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kahandaara goottakkeessakko lakkorooraro ame ani kasegeero haafura shaada. In horoora gogireen, isinna adi horoornnaran, haafurakkee kaɂoorateran golleen haafurakkisinna oorayinnaran. ");
INSERT INTO bswl_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","In kafarero mankkokasoon maraan, megekkeekkotti aalanttii hikka felinnaraan. ");
INSERT INTO bswl_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Emeeyi segiwayewa c'ubbo lakkollaare, gidda ade c'ubbokkisoowun ade aalantti lakkoɂabaan. ");
INSERT INTO bswl_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","In kadiidara, Aabbokkeena diidara. ");
INSERT INTO bswl_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kakkalee ibaaddo kafeloongiro isoo orroo feliwayewa, c'ubbo lakkollaare, gidda ade inna Aabbokkeenna deenan, gidda ade inna Aabbokkeenna diideraan. ");
INSERT INTO bswl_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Hikkina, ‹Aalanttikallayi diideen› amame seerakisooyi kas'aafamera haafura goggogudaroonya. ");
INSERT INTO bswl_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Ani Odo dollekko isinuun kafarnara, Odokko kabiyaaro kagoggoɂisiro karrummii Ayyaana kakkoɂemeete goorata, usu garakkee atotinara. ");
INSERT INTO bswl_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Isinna addeen, horaarjjewa inne wota mankkogitteen, maraan atotinattaan. ");
INSERT INTO bswl_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Hikka dubba kasegeera ammanokkisinkko goggoshiriɂamoonkoya. ");
INSERT INTO bswl_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ayihuudi kakkokukkuɂamarekkona, beesinaran suurewa kallagadinara dubba Waawun goggohandaye malee kakkotootamira goorata emeetara. ");
INSERT INTO bswl_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Hikka dubba kakkonyelnanaa, Odo goorttun in mankkokasoon maraanya. ");
INSERT INTO bswl_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Horeene hikka ani isinuun kakkonsegeera goorata gogee goggoshaaddanunya, isin wota mankkogire maraan, t'aye hikka lakkosegeero. ");
INSERT INTO bswl_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«Goortta in kafarero tos seeyinara, halleewo kuwaarre isinkko, ‹Haggerraa seeyinatta?› ami in kahosayinara laagiro. ");
INSERT INTO bswl_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Hikka ayeesanoonna wodanattisin gaddaa ammaganttetta. ");
INSERT INTO bswl_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ayesuun goɂameen ani rumminaa rumminaa amara seetanokki isinuun laɂo sisirowa, ani goseetanawaye kagoggoɂisara isin tos lakkoɂemeetaro, ani goseeye adi Ayyaana K'ulluukki isin tos farnnara. ");
INSERT INTO bswl_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kakkoɂemeete gooratana alami c'ubbo maraan, gara kak'ulluumaanna gara kafirdda addeesisi tusinara. ");
INSERT INTO bswl_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","C'ubbokkisoo addeesise kakkoontusara, ibaaddo iyyee mankko ammanoon maraanya. ");
INSERT INTO bswl_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Gara kak'ullummaa addeesise kakkontusara, Odo tos mankkoseeyinaronna hittakko danbbeebaan in isin mankkodeennon maraanya. ");
INSERT INTO bswl_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Gara kafirdda addeesise katusara hikka alamikokki mooti talleetetta s'alaye mankkofirddaanttetto maraanya. ");
INSERT INTO bswl_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Ganaa kamooggan ani isinuun kaseginara gira, gidda adi atayin lakkodaanddeetan. ");
INSERT INTO bswl_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Karrummii Ayyaana kakkoɂemeete goorata rummi dubba tos geegeesirowa, usu iskko lakkoɂayeesaro, kamaalero kaalaal ayeesara, usumaleenna horenbbaan kallinaro seginara. ");
INSERT INTO bswl_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Kakkee kalleerokko aatere goggoɂaddeesawun yelaa in kabajinara. ");
INSERT INTO bswl_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kaɂodo kalleera dubba kakkeeyya, goortta ‹Kakke kallerokko aatire goggoɂaddeesawun seginara› kakkoon amera haanssunya. ");
INSERT INTO bswl_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Arri uc'c'arkko abbaabayi lakkodinnattaan, halleewo kuwaarre arri uc'c'arkko abbaabayi adi dinnattaan.» ");
INSERT INTO bswl_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yesuusakko oɂagaalssatareenkko kookkoo, « ‹Goorata kic'c'arkko abbaabayi in lakkodinnattaan, halleewo kuwaarre goorata kic'c'arkko danbbenne adi dinattan usumaleenna, odo tos mankkoseeyinaro› maraan goɂamiro meɂamanoya?» isiɂisi orroo ameen. ");
INSERT INTO bswl_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","« ‹Goorata kic'c'ar amano me amanoya?› usu kaɂayeesara ayees lakkotabero» amaa isiɂisi orroo hoosataa gireen. ");
INSERT INTO bswl_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesuusana usu hoosayin dootano kakkoɂaddeese goorata, «Ani, goorata kic'c'arkko danbbenne in lakkodinnattaan, ‹Halleewo kuwaarre goorata kic'c'arkko danbbenena adi dinnattaan mankkoɂameroon, me amanoyyo isiɂisi orroo isiɂisi hoosattaan›? ");
INSERT INTO bswl_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ani rumminaa rumminaa amara, isin ooyinattaan, gaddinattan, alami adi geggelaayinara, halleewo kuwaarre gaddakkisin geggeloo tos iggilisaminara. ");
INSERT INTO bswl_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Heleelttiti arri giidde umulaagiraan c'annak'aamatta, kakkoɂumultte goorata adde ibaaddo alami tos mankkoɂemeetero maraan kac'c'annak'k'aamatte illowaatta. ");
INSERT INTO bswl_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Isinuunna hikkamalee gidda kagadda goorataya, golleenna adi ani isin mankkodinnaro maraan in geggelaayisara, geggeloɂoottisinna isinkko kaɂaatira laagiro. ");
INSERT INTO bswl_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Eserritti inkko koonna lakkoɂebaayinattaan, ani rumminaa rumminaa amara Odo megekkeeyi kaɂebaattan dubba sisinara. ");
INSERT INTO bswl_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Gidda gin megekkeeyi koonna lakkoɂebaatteettan, ebaayen atattaanwa, geggeloɂoottisinna oɂammagameen goggolleerawun ebaayen. ");
INSERT INTO bswl_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Gidda gin kasegeera masuussayi golleenna hitakko horenbbaan gara kaɂodoo masuussayi halleennoon giraan diidaabbeesi kakkoɂayeesira goorata emeetara. ");
INSERT INTO bswl_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Eserri megekkeeyi ebaayinattan, aninna Odo isin maraan lakkoɂebaayinaro. ");
INSERT INTO bswl_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Aalanttina odo metekkeessawa isin mankkogeelatero maraana Waa dollekko emeetanokkee mankkoɂammantteettaan maraanya. ");
INSERT INTO bswl_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Odokko beere alami tos emeeyera, gidda ade alami iisere Odo tos seeyinara» ame. ");
INSERT INTO bswl_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Esekkona Yesuusakko oɂagaalssataran haa ameen, «Goortta gidda ati masuussa kallaayi addeesise ayeesaa gitta. ");
INSERT INTO bswl_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Gidda ayees dubba goggoɂaddeesattona maayyona ku hoosayin dootisi waatti addeeseeran, hikkina Waa dollekko emeetano goggoɂammannoon yelera» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesuusana, «Gidda ammantteettaan amanoya?» ");
INSERT INTO bswl_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","«Hikkima isin dubbana rarraanne kakkodarɂaaminnattaan goorata emeetera, usu gooratana giddaaya, inna kale isaaginattaan, halleewo kuwaarre Aabbokki inneta mankkogiro maraan ani lakkokale giro. ");
INSERT INTO bswl_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","«Iyyee giriddeene nogoddaa goggogirttaanun, hikka segeera, alami girantuun rakkoo abttaan, ayesuun goɂameen allamandde, ani alami awodera» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesuusa hikka haafura ayeese abbaabatere, daruur tos t'ok'k'imere haa ame ebaate, «Aabbokki, goorata geera, Erekka ku goggokabajiroo Erekkaa kabajiina. ");
INSERT INTO bswl_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kakkonkabajaattana ati kasissetto dubbaan erkka jiruu jiroommakki giri goggosisiroon ibaaddo dubbaa gutii odonnati mankkosissetto maraanya. ");
INSERT INTO bswl_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Jiruu jiroommakki girina ati kaalaa karrummii Waa Hedona kafarttetto Yesuusa Kiristoosa addeesanoya. ");
INSERT INTO bswl_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ati iin osissette felo gudisegure ku ulii gutii kabajee. ");
INSERT INTO bswl_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Goortta Aabbokkee! Alami hamet't'aamoon kunne wota tagitte kabajaa ku dollee in kabajii.» ");
INSERT INTO bswl_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Hinɂa ati alamikko assaabttedde iin osissetto ibaaddojjaan megekkaa addeesisera. Oottayeen, iyyeen sise, isona haafurakkaa oorateen. ");
INSERT INTO bswl_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ati kasissetta dubba kukko laano iso giddaa addeeseeran. ");
INSERT INTO bswl_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Aalanttina ati iin kasissetto haafurakkaa ani isoon sise gollee atateeran, aninna ku dollekko bi emeetano ogiraan iso addeeseeran, ati in faranona iso ammaneraan. ");
INSERT INTO bswl_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Iso oottaa mankkolleeran maraan isoon ebaayinara, ati iin osissettoonna oottaa olleeraawun kuwaarre alamiin lakkoɂebaayinaro. ");
INSERT INTO bswl_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Kakkee kalleera dubba kakkaayya, kakka kalleerana dubba kakkeeyya, isoonna kabajaamera. ");
INSERT INTO bswl_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Goortta ani alami orroo lakkoɂadallaayinaro, iso adeen alami orro ginaan, ani ku tos emeetanoya, k'ulluukki Aabbokki, noo koo goggolleenennoo, isona koo goggolleenawun kasissetto megee oori. ");
INSERT INTO bswl_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ani isone wota takkogiree, ati kasissetto megekkaayi iso golisera, aninna oorera, kamas'aafa haafura goggogudaroo koo kabbayi ere kuwaarre isokko maayyona lakkobayero. ");
INSERT INTO bswl_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Gidda iin ku tos emeetanoya, ayesuun goɂameen geggeloɂootti isoo dollee oɂammagameen goggolleerawun, gidda alami giraan hikka ani ayeesara. ");
INSERT INTO bswl_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ani haafurakkaa isoon sisera, ani alamikko lakkoyo, isona alamikko lakkoyaan; haanssun alami iso diidera. ");
INSERT INTO bswl_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kakkoon ebaatarana kameellankko goggoɂoorttoon kuwaarre, alamikko goggobeesson lakkoyo. ");
INSERT INTO bswl_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ani alamikko goggolleennon giro malee, isona alamikko lakkoyyan. ");
INSERT INTO bswl_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Haafurakka rummiya, rummittaayi k'ullooyisina. ");
INSERT INTO bswl_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ati alami tos in goggofarttettoo aninna alami tos iso farera. ");
INSERT INTO bswl_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Iso rumminaa goggok'ullooyinawun, isiɂootte iso maraan k'ullooyisayera.» ");
INSERT INTO bswl_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Agaalssiskkisoo atateeren iyyee oɂammanaraawun adereya kuwaarre hinɂa oolaalun ani lakkoɂebaayinaro. ");
INSERT INTO bswl_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Hikkina, Aabbo! Ati iyyee goggogittoo, aninna kuyyee goggogiroo, dubbana koo goggolleenawun, usumaleenna ati in farano alami goggoɂammanoon, isona noyyee goggogirrawunya. ");
INSERT INTO bswl_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Noo koo goggolleenennoo isona koo goggolleenawun, tasissetto kabaja sisera. ");
INSERT INTO bswl_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Hikkina ani isoo, atina iyyee laanoya, ati in goggofartettona in goggogeelatetto gitakki isona goggogeelatetto alami goggoɂaddeesiroon, koonnatikkiso kaɂaddeesame halleewo.» ");
INSERT INTO bswl_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Aabbokkee! Hinɂi ati iin osissetta, ani mankkogiroo goggogirraawun alami hamet't'aamooni in mankkogeelaattetto maraan ati iin tasissetto kabajattee iso goggoddeerawun dootara.» ");
INSERT INTO bswl_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","«K'ulluukki Aabbokkee! Alami gokkasanawatena, ani kasowa, hinɂina ati in farano kasaanwa. ");
INSERT INTO bswl_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Iyyeen tagitta geelanjjetta isoon goggogirttoo, aninna isoo goggogirroo, megekka goggoɂaddeesinawun yelera, goggoɂaddeesinawuna yelinara.» ");
INSERT INTO bswl_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesuusa hikka ebi gudise abbaabatere usukko oɂagaalssatareene wota kak'edirooni laga nak'eene, t'ayeen takkogireen taɂakaakiltte banɂe tos tabeen. ");
INSERT INTO bswl_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Goorata kamooggan Yesuusa usukko oɂagaalssatareenne wota esee mankkoɂeselaro maraan, roorse kasisera Yihuudana banɂe kasanaayewa. ");
INSERT INTO bswl_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yihuudana wotaadaral usumaleenna katuuk'aamol woyichchaalkkona Farasaawilkko ofarameeraan k'ulluukki min kawaa oɂooraneenne wota k'ajeelisaa banɂe taɂakaakiltte tos emeete, isona dab, faanosina huu kajjereene abateen gireen. ");
INSERT INTO bswl_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesuusana usu kaginnaro dubba addeesere iso tos beere, «Isin kadootattaan ayyoyya?» ame. ");
INSERT INTO bswl_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Isona, «Kanaazireti Yesuusaya» ameen. Yesuusana, «Usu aniya» ame. Roorse kasiserana Yihuuda iso wota aallee gire. ");
INSERT INTO bswl_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesuusana, «Usu aniya» kakkoɂamare goorata haararttii gaggabeenguren ul iyyeen. ");
INSERT INTO bswl_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Adena «Isin kadootattaan ayyoyya?» Ame hoosate. Isona «Kanaazireti Yesuusaya ameen.» ");
INSERT INTO bswl_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesuusana abbaabere, «Usu aniya» amera hayya, «In kadootattaan gollee hinɂi haseeten isaaga ame.» ");
INSERT INTO bswl_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Hikki kakkoleera, «Ati iin osissetto hinɂakko koonna lakkobayero» ame kaɂayeesera haafura goggogudaroonya. ");
INSERT INTO bswl_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Shiifa abate kagire Simoona P'et'iroosa shiifa miɂate tuuk'aamokokki woyichchaan kahandaare basere nebe tamergge goose «Kahandaarekokki megena Malkkoosa amamare». ");
INSERT INTO bswl_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesuusana P'et'iroosane, «Shiifa kofoo tabisina! Odo iin tasisero tarrakkoo t'ugga kat'amoon aani laara?» ame. ");
INSERT INTO bswl_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Wotaadarana kaɂajajaaro kakkisone wota Ayihuudin ohandaareenna raattoo leene Yesuusa abeen, shiyeen, ");
INSERT INTO bswl_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Horaarjje, kak'eyaafa soddo kalleero Haanna tos geesen, K'eyaafa usu geesii tuuk'aamon odonnati kaɂaboye. ");
INSERT INTO bswl_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","K'eyaafa, gosa marantuun odo koo goggoye kaɂidankkiya amaa Ayihuudin markkasisaa kagire ibaaddotiye. ");
INSERT INTO bswl_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoona kaɂamamare P'et'iroosana kakkalee koo Yesuusakko kaɂagaalssatare Yesuusa debee seeteen, tuuk'aamon odonnati kaɂaboon mankkoɂaddeesamare maraan, Yesuusa wota tuuk'aamon odonnati kaɂabokokki awud tos tabe. ");
INSERT INTO bswl_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","P'et'iroosa ade karrakkoo sarre hese. Tuuk'aamokokki woyichchaneta kaɂaddeesamare kakkalee Yesuusakko kaɂagaalssatare abbaabatere karra taɂooratte ayeesisere P'et'iroosa aate tabe. ");
INSERT INTO bswl_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Karra taɂoorattena P'et'iroosane, «Ati hikka ibaaddotikko kaɂagaalssatarokko koo lakkottoya?» Antte. Usuna «Lakkoɂaniyyo» ame. ");
INSERT INTO bswl_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Gooratana kaɂanbboloolisare mankkollee maraan ohandaareenna eleen beebesateen maraamureen maar kolkkolisayin aalleen gineen, P'et'iroosana iso wota aalleere eleen t'ant'amaa gire. ");
INSERT INTO bswl_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Usu goorata tuuk'aamokokki woyichcha Yesuusa usukko oɂagaalssatareenkokki garana agaalssisanokkeesakokki gara hoosaten. ");
INSERT INTO bswl_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesuusana, «Ani alamiin addeesise ayeesera Ayihuudi takkokukkuɂamarena, k'ulluukki min kaɂebii arri dubba agaalssisera, siyame kaɂayeesera laagiro. ");
INSERT INTO bswl_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mewuun in hoosata? Ani isoon kasegeero omaaleeran hoosa, hikkima, hinɂi ani kaɂayeesero kasaanwa.» ");
INSERT INTO bswl_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesuusa hikka kakkoɂayeesare goorata dollee aalleen ogireen k'ulluukki min kawaa oɂoorareenkko koo, «Tuuk'aamokokki woyichchaan haa abbaabata?» amere balabaanjjoo usu base. ");
INSERT INTO bswl_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesuusana, «Tameellan kaɂayeese gollee» «Tameellan ayeesanokkee atotiin, rummi goɂayeese adde mewuun basatta?» ame. ");
INSERT INTO bswl_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Esekko Haanna Yesuusa shaame goggogiree tuuk'aamokokki woyichcha K'eyaafa tos fare. ");
INSERT INTO bswl_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simoona kaɂamamere P'et'iroosa aalleere eleen t'ant'amaa giraan; kakkalee ibaaddona «Usukko oɂagaalssatarankko koo la atittolla?» ame. Usuna, «Lakkoɂaniyyo» ame kakate. ");
INSERT INTO bswl_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tuuk'aamokokki woyichchaan ohandaareenkko koo P'et'iroosa nebe kagoosero ibaaddotin falli kalleere, «Taɂakaakiltte banɂee ani ku Yesuusane wota lakkodeeya?» ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","P'et'iroosana ade kakate, goorsewa lukkale oye. ");
INSERT INTO bswl_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ayihuudi Yesuusa min kak'eyaafakko karoomi mooti P'ilaat'oosakotti k'aye aateen seeteen, gooratana bariye, Ayihuudina kafaasikkaa baala mankkoɂaaminnare maraan battowanakko ameeren awud kamootiti tos lakkotabeeran. ");
INSERT INTO bswl_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Haanssun P'ilaat'oosa iso tos beere, «Hikka ibaaddoti gutii kamootattaan mooto meya?» ame iso hoosate. ");
INSERT INTO bswl_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Isona abbaabeen, «Hikki ibaaddoti felo omeellan feliwaatewa noo kuun roorisi lakkosisinanne» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","P'ilaat'oosana, «Isin issiiwa geesaddeen seerakkisin malee firddaa» ame. Ayihuudina, «Noo maayyona goggolaganddon feɂi lakkoɂabnno» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Hikkina kakkonleera Yesuusa misikki goyi goyinaro tusin amere kaɂayeesera haafura goggogudaroonya. ");
INSERT INTO bswl_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","P'ilaat'oosana awud tos abbaabatere Yesuusa uumsisere, «Ati kaɂayihuudi wonotta?» ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesuusana, «Hikki yaada kakkaayya?» «Goorttun kakkalee garakkee kasegenanya?» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","P'ilaat'oosana abbaabere, «Ani Ayihuudiya?» «Ku in tos kafarera gosakkaanna katuuk'aamol woyichchaalya; ayesuun ati me yelttedeya?» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesuusana, «Wononnatikki hikka alamikko lakkoyo, lii girewa Ayihuudi goggoɂaboonkko ohandaareen jereen shafataneewa, gidda ade wononnatikki hikka alamikko lakkoyo» ame. ");
INSERT INTO bswl_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","P'ilaat'oosana, «Hayya ati wonotta amanoyolla!» ame. Yesuusana, «Ani wono laano gara anttetta, ani kakkoonɂumulamerana hikka alami tonssa kakkoon emeeyera gara karrummii atotiinya, rummikko kallee dubba haafurakkee maalara» ame. ");
INSERT INTO bswl_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","P'ilaat'oosana, «Rummi metta?» ame. Hikka ayeese abbaabatere adena Ayihuudi tos beere haa ame; «Ani hikka ibaaddoti gutii kamootisiro baas koonna lakkohelero, ");
INSERT INTO bswl_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ayesuun goɂameen faasikkaayi kashaamerokko odo koo furanokokki woga abttaan, ‹Haanssun kaɂayihuudi wono goggofurroon dootaattan›?» ame. ");
INSERT INTO bswl_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Isona adeen iyyaa, «Laa lakkoɂusuyo! Barbaane furi!» ameen. Barbaane ade shittaayye. ");
INSERT INTO bswl_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","P'ilaat'oosa Yesuusa haggaɂaatere boc'c'iise. ");
INSERT INTO bswl_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Wotaadaralnna eɂeen mammaren kallachcha aani mete kayesuusaa gutii kayeen, heela buraaburrekki sarssi sarssiseen. ");
INSERT INTO bswl_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Maraamureen «Kaɂayihuudi wono geggelaana» amaa balabaanjjoo basa gineen. ");
INSERT INTO bswl_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","P'ilaat'oosana ade awud tos beere, koonna mooton ogeegisiraan felo omeellan heliwaatti goggoɂaddeessanun, «Goortta ani usu isin tos beesinara» ame. ");
INSERT INTO bswl_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesuusa kallachcha kaɂeɂeenee kaatere heela buraaburrekki sarssi sarssate bee, P'ilaat'oosana, «Hikkima, ibaaddoti!» ame. ");
INSERT INTO bswl_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Katuuk'aamol woyichchaalnna k'ulluukki min kawaa oɂooraneen Yesuusa kakkodiyaareen goorata, «Suuyina! Suuyina!» amaa okkeen. P'ilaat'oosana ade, «Isin geesayendden suwaayen, in tonsse mooton ogeegisiran felo omeellan ani lakkohelero» ame. ");
INSERT INTO bswl_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ayihuudina, «Noo seera abinna, isiɂootteessa Ere kawaa mankkoyele maraan seerakaani malee goyin dootisara» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","P'ilaat'oosa hikka kakkomaalare goorata aaloo abssate, ");
INSERT INTO bswl_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Awud tos abbaabatere Yesuusa, «Ati hayekko emeettetta?» Ame hoosate, Yesuusa ade koonna lakkoɂabbaabero. ");
INSERT INTO bswl_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","P'ilaat'oosana, «Lakkosegaattoya? Ani ku furin goorttun suyin odonnati abano laakkassoya?» ame. ");
INSERT INTO bswl_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesuusana, «Waakko sisamiwatewa in gutii odonnati lakkogirare, haanssun kuyeen roorse kasisera ibaaddoti c'ubbokko karoore c'ubbo aba» ame. ");
INSERT INTO bswl_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Esekko abbaabatere P'ilaat'oosa Yesuusa furin doote, Ayihuudi ade, «Hikka ibaaddoti gofurtte K'eesari kageelaatto lakkotto, isiɂoottessa wono kayelatara K'eesari kadiidaroya» amaa okkaano horeddeen. ");
INSERT INTO bswl_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","P'ilaat'oosa hikka maalere Yesuusa saarddese beese, eɂemokokki yaamano taɂamamatte banɂee kafirdda barc'umaa hamas's'ee, hitti banɂena taɂaramayikki heɂii Gebetaa amantte uumamatte. ");
INSERT INTO bswl_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Arri kafaasikkaa baala takkoɂekkaasanatte gooratana arrikko saatii lekki lee gire. P'ilaat'oosana Ayihuudine, «Hikkima wonokkisin» ame. ");
INSERT INTO bswl_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Iso adeen, «Baasina! Baasina! Suuyina!» amaa iyyeen. P'ilaat'oosana, «Wonokkisin suyuu?» ame. Katuk'aamo woyichchaalnna, «Karoomi wono K'eesari kuwaarre kakkalee wono noo lakkoɂabnno» ameen abbaabeen. ");
INSERT INTO bswl_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Gudisanonna P'ilaat'oosa Yesuusa goggosuyiraawun roorise sise. Wotaadaralna Yesuusa abeen geesen. ");
INSERT INTO bswl_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Usuna mask'aliitteessa sidatere taɂaramayikki heɂii «Golggottaa» amantte taɂuumamatto «Buk'k'e taɂmete» taɂamamatte banɂe bee. ");
INSERT INTO bswl_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Eseenna suyeen, usu wotana ibaaddo lama, koo mina tabetene, koonna mina tamerggeenne, Yesuusa t'eɂe yeleene suyeen. ");
INSERT INTO bswl_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","P'ilaat'oosana s'uufi s'aafere masik'alii gutii reerese; s'uufina, kanaazireti Yesuusa, kaɂayihuudi wono taɂamattotte. ");
INSERT INTO bswl_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yesuusa takkosuuwamere banɂe katamaa dollee mankkogitte maraan omooggan Ayihuudi s'uufi nabbabeen, s'uufinna, heɂi taɂibrayist'ii talaatininna, tagiriikkitte. ");
INSERT INTO bswl_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kaɂayihuudi tuuk'aamolkokki woyichchaalnna P'ilaat'oosa diidaa, «Usu, ‹kaɂayihuudi wonoya› amera ami s'aafi kuwaarre kaɂayihuudi wono ami aroos'aafitte» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","P'ilaat'oosana, «Ani kas'aafero s'aafera» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Wotaadaral Yesuusa suyeen abbaabateen, k'olokkeessa hesaa, huukkeessa aateeren metemetewun koo koo goggogeegeeron benɂe afar hedeedameen, elekko taa hegel geetoon amalekkoo leete haɂiriiramooni tafelanttetta. ");
INSERT INTO bswl_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Haanssun, «It'aa beesayinne kakkoonbeete hageete» kuwaarre «Lakkofiilnno» ameen. Hikkina kakkoonlleera «Huukkee hedeedameen, k'olona it'aa beesaten» kaɂamamera kamas'aafa haafura goggogudaroonya. Wotaadaralna kafeeleran hikkawaya. ");
INSERT INTO bswl_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tayesuusa masik'alii dollee Aayetteessana Aayetteessakotti abba, tak'elyoop'a oori Mayiraamena ul kamegidellakotti Mayiraame esee aalleen gireen. ");
INSERT INTO bswl_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Eseenna Yesuusa Aayetteessana kageelaatare usukko kaɂagaalssatare dollee aalleen giraan kakkodiyaare goorata Aayetteessane, «Ati heleelttiti, erekka hikkima» ame. ");
INSERT INTO bswl_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Usukko kaɂagaalssatarene, «Aayetta hittima» ame. Usu gooratakko haggaɂabere hikki usukko kaɂagaalssatare minkkeessa tos atate. ");
INSERT INTO bswl_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Esekko Yesuusa ayees dubba gudatano addeesere, kamas'aafa haafura goggogudaroo, «Ani sugubaayewa!» ame. ");
INSERT INTO bswl_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Eseenna taɂokokaatta woyinii hubuchcho mig leete gitte, isona isifooniji t'amo kawoyinniitii t'uuk'iseene, ogorro kaɂabo baalii hiɂi tos gabbaleen. ");
INSERT INTO bswl_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesuusana kaɂokokootaro kakkok'k'ammassare goorata «Gudatewa» ame. Metekkeessa hussisatere, neefotteessa roorse sise. ");
INSERT INTO bswl_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Esekko abbaabatere arri Ayihuudin tafoolissi arriwuun takkoɂekkaasatarantte. Ayihuudi, kasuwamero ibaaddokokki rees tafoolssii arri masik'alii gutii goggohayinonkko mankkodootateen maraaninna kaletti tafoolssii arri mankkolleete maraan, osuwaameeran ibaaddojja gilb ebisereen rees goggodagiroon P'ilaat'oosa ebaaten. ");
INSERT INTO bswl_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Haanssun wotaadaral emetere Kiristoosane wota suwaame kagire kahoraarjjee ibaaddotikokki gilb ebiseen, adeen kakkaleekokki gilb usumalee ebiseen. ");
INSERT INTO bswl_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Yesuusa tos kakkoɂemeeteren goorata kagoyero mankkodeeren maraan gilb lakkoɂebseeren. ");
INSERT INTO bswl_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ayesuun goɂameen wotaadaralkko koo aaranjja tayesuusa jereeni eegge, goorsewa iigina bekena ubate. ");
INSERT INTO bswl_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Hikka kaddeera ibaaddoti atonnati sisera, atonnatina rummiya, rummi ayeesanona kasowa, isinna goggoɂammanttaanun atotaara. ");
INSERT INTO bswl_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Hikkina kalleera, mas'aafa, «Lefaalkko koonna lakkoɂebiro» Kaɂamamera goggogudaroonya, ");
INSERT INTO bswl_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","kakkalee k'ulluukki mas'aafana, «Hassu kaɂeeggeran iso dinnaraan» amara. ");
INSERT INTO bswl_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Hittakko abbaabatere kaɂarmmatiyasi Yoosefa kayesuusa rees atayin P'ilaat'oosa ebaate, Yoosefana Ayihuudi mankkoɂabssatero maraan hetoo Yesuusakko kaɂagaalssataroye. Usuna P'ilaat'oosa feɂi kakkosisare goorata emeete rees atate. ");
INSERT INTO bswl_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Esekko horeene hemeen Yesuusa tos emeete kagire Nik'odimoosa koffichcha sonddom talleeto aaloo awɂallo pulipulisona kaɂokokootaro baac'u aate emeete. ");
INSERT INTO bswl_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Isona rees kaɂyesuusa aateeren kaɂayihuudi rees ekkaasanokokki seeraa shittoonne wota k'amaluun gashee mammareen. ");
INSERT INTO bswl_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesuusa takkosuwaamera banɂena taɂakaakiltte benɂette, taɂakaakiltte benɂe maayyona takkok'amalamoon giro kaɂusub k'amaliye. ");
INSERT INTO bswl_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ayihuudin tafoolssi arriwuun takkoɂekkaasataraan arri mankkoleetewun tak'amal banɂe ene mankkoleewun Yesuusa esee k'amaleen. ");
INSERT INTO bswl_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tawoggaa arri, bariinoo ganaa ul dimimmisane giraan, tamegidella Mayiraame k'amal tos seete, eɂemona k'amalkko kaɂotottoolero deete. ");
INSERT INTO bswl_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Haanssun Simoona P'et'iroosa tos Yesuusa geelataa kagire kakkalee usukko kaɂagaalssatare tos tiyaa emeetedde, «Gootta k'amalkko beesen aateena, eetii kayeeraan laakansso» antte. ");
INSERT INTO bswl_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Esekkona P'et'iroosana kakkalee Yesuusakko kaɂagaalssatarena beenee k'amal tos seeteen. ");
INSERT INTO bswl_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Lamaa tiyaa giraan, kakkalee Yesuusakko kaɂagaalssatarana P'et'iroosakko t'aye tak'amal banɂe gee. ");
INSERT INTO bswl_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Hussimere takkok'amalamero banɂe godeero gashe taalaal girano dee, k'amal tos ade lakkotabere. ");
INSERT INTO bswl_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Debeesseseeta kagire Simoona kaɂamamere P'et'iroosa geere k'amal tos tabe, usuna tannek'amalereen gashe taalaal dee. ");
INSERT INTO bswl_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Usumaleenna mete kayesuusa gutii tamamarantte gitte hoc'c'o dee, hitti hoc'c'ona tak'amal gashekko kale beete mamarantte gitte. ");
INSERT INTO bswl_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Esekkona t'aye k'amal tos kageera kakkalee Yesuusakko kaɂagaalssatare k'amal orroddee tabe, deerena ammane. ");
INSERT INTO bswl_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Hikkina Yesuusa goyikko kiyaano girano ganaa mas'aafakko lakkoɂaddeeseren. ");
INSERT INTO bswl_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Esekko abbaabatereen Yesuusakko oɂagaalssatareen lamana min minkkisoo galeen. ");
INSERT INTO bswl_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ul tamegiddellakotti Mayiraame adde k'amalkko sarre aalliitedde ootaa gitte, ootaanna k'amal din hussi antte. ");
INSERT INTO bswl_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Rees kayesuusa mankkogire banɂe, huu gumaara gumaarakki osarssateeraan erggichcha lama koo metene koo luk'k'ane ohamas's'eeran deete. ");
INSERT INTO bswl_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Isona Mayiraamine, «Ati heleelttiti, mewuun owaatta?» ameen hoosaten. Esena, «Goottakkee aateena, eetii kayeeraan laakkaso» antte. ");
INSERT INTO bswl_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Hikka anttedde haararttii gowochiito Yesuusa esee kaɂaalleero deete, Yesuusa laano ese adde lakkoɂaddeesetto. ");
INSERT INTO bswl_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesuusana, «Ati heleelttiti, mewuun owaatta? Ayyona dootatta?» ame. Esena taɂakaakiltte banɂe kaɂooraro aani leere, «Goottakki, ati goɂaattetto, maganne maaggee kayitetto segii ani ataro» antte. ");
INSERT INTO bswl_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesuusana, «Mayiraame!» ame. Esena, usu tos abbaabattedde taɂibrayist'i heɂii, «Rebuuni!» antte, fureenna «Kaɂagaalssisatto!» amanoya. ");
INSERT INTO bswl_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesuusana, «Ganaa Odo tos mankkobeennon giro maraan, aroodintte, halleewo kuwaarre abbilaalttee tos seedde, ‹Aabbokkee tosna Aabbokkisin tos, Hedokkee tonssa Hedokkisin tos binnara amera› amidde segii» ame. ");
INSERT INTO bswl_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kamegidella ulkotti Mayiraamena Yesuusakko oɂagaalssatareen tos seettedde, «Gootta deelle!» Antte usu kaɂamerona segite. ");
INSERT INTO bswl_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Usu almmaawa, tahoraarjjee arri tawoggaa hemeen, Yesuusakko oɂagaalssatareen Ayihuudi abisateneen ufa c'ufateen kukkuɂameen giraan, Yesuusa emetere iso t'eɂee aalleere, «Nogodda isinuun halleeto!» ame. ");
INSERT INTO bswl_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Hikkana amere genennona aaranjjana tusate, Yesuusakko oɂagaalssatareenna Goottaa kakkodiyaaren goorata aaloo geggelaaten. ");
INSERT INTO bswl_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesuusa adena, «Nogodda isinuun halleeto, Odo in goggofareroo, aninna isin farnara» ame. ");
INSERT INTO bswl_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Hikka ame abbaabatere, ufuu amere, «Ayyaana K'ulluukki atayeen. ");
INSERT INTO bswl_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Isin c'ubbo kaɂibaaddoo haheso goɂantteen, c'ubbokkisin haheso amamirowa, isin c'ubbokkisoo haheso goɂamoon, ade c'ubbokkiso isoon haheso lakkoɂamamiro» ame. ");
INSERT INTO bswl_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Hassu goorata tomonkko lamakko koo kalleera, Didimoosa kaɂamamare Toomaasa Yesuusa kakkoɂemeetare goorata usukko oɂagaalssatareene wota lakkogire. ");
INSERT INTO bswl_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Okkalee Yesuusakko oɂagaalssatareen Toomaasane, «Noo Goottaa deennelle!» ameen. Usu ade, «Misimaare oɂeeggameeran genennoɂoottessakki malaata goddeenoon, misimaareeli takkoɂeeggamero banɂee fer tabisi goddeenoon, aaranjjatteessaanna genettee gotabisoon lakkoɂammaninaro» ame. ");
INSERT INTO bswl_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Arri siddeedkko abbaabatere, Yesuusakko oɂagaalssatareen min orroo gineen, Toomaasana iso wota gire, ufaalnna c'ufame gire, Yesuusa ade emetere isoɂorroo aalleere, «Nogodda isinuun halleeto!» ame. ");
INSERT INTO bswl_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Esekkona Toomaasane, «Ferttaa hittarraa keeni, genennoɂootteenna deena, gene diriirssadde aaranjjatteyi tabisi, aroohedatte ammana» ame. ");
INSERT INTO bswl_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toomaasana, «Goottaa! Hedokkee!» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesuusana, «Ati in mankkodeete maraan ammanttetta in haddeennoon oɂammanataraan adeen osommaasameenyan» ame. ");
INSERT INTO bswl_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesuusa hikka mas'aafaa kas'aafamoon kakkalee kamooggan malaata usukko oɂagaalssataran horee felera, ");
INSERT INTO bswl_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ayesuun goɂameen Yesuusa usu Kiristoosa Ere kawaa laano goggoɂammanttaanunna, ammaniddeen megekkeessaa giri goggohelattaanun hikki s'aafamera. ");
INSERT INTO bswl_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Esekkona danbbene Yesuusa tat'ibraadosi labuu adena usukko oɂagaalssatareewun mute, hikkamaleena ade mute. ");
INSERT INTO bswl_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoona kaɂamamare P'et'iroosa, Didimoosa kaɂamamare Toomaasa, kak'aana Zegaliila Naatinaɂeeli, yiis kazabddoosana Yesuusakko oɂagaalssatareen okkalee lama raattoo gineen. ");
INSERT INTO bswl_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoona kaɂamamare P'et'iroosana, «Kunɂub abayin daganoya» ame. Isona, «Noo kunne wota daginanna» ameen. Emeetene wolabo oriddeen tabeen, ese hemeen adeen koonna lakkoɂabateen. ");
INSERT INTO bswl_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Bariinoo, Yesuusa labu girii aallee gire, usukko oɂagaalssatareen adeen Yesuusa laano lakkoɂaddeesen. ");
INSERT INTO bswl_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesuusana, «Yiiso, kunɂub abitaane?» ame. Isona, koonna «Lakkoɂabino» ameen. ");
INSERT INTO bswl_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Usuna, «Maarrabittisin wolabokko mina tamerggenne lugudayeen, kunɂub helattaanwa» ame. Isona kakkolugudatareen goorata kunɂub mooggankko kakkeeyi maarrabi nattin waateen. ");
INSERT INTO bswl_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Hassu goorata Yesuusa kageelaatare usukko kaɂagaalssatare, P'et'iroosane, «Goottayo!» ame. Simoona P'et'iroosana, «Goottayolla!» kaɂamaro haafura kakkomaalare goorata, beesate kagire sarssi tabsatere firime bekerro tabe. ");
INSERT INTO bswl_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Okkalee Yesuusakko oɂagaalssatareen adeen bagakko badi tos fakkikameeran hisil lama boolee kalleero kuwaarre aaloo lakkofakkimeenan, kunɂub takkoɂammagamere maarrabi nattaa baga emeeten. ");
INSERT INTO bswl_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bagana kakkogiyaanee goorata, boolaal kaɂeleenee gutii kagiro kunɂubnna babo deen. ");
INSERT INTO bswl_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesuusana, «Gidda kaɂabtteettan kunɂubkko alla keena» ame. ");
INSERT INTO bswl_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Haanssun Simoona kaɂamamere P'et'iroosa wolaboo tabere maarrabi baga tos nattee, 153 kajinjjiin kunɂub ammagame gire, hikka gitakki kunɂub goɂabttena maarrabi lakkofiilanttetto. ");
INSERT INTO bswl_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesuusana «Koyeen aama» ame. Isona usu Goottaa laano addeesen mankkogireen maraan usukko oɂagaalssatareenkko koonna «Ati ayyotta?» ami hoosayin kajabaate laagire. ");
INSERT INTO bswl_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesuusana emetere babona kunɂubna aate sise. ");
INSERT INTO bswl_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesuusa goyikko gokkeekko abbaabatere usukko oɂagaalsaataraawun mutano hikki kaseediye. ");
INSERT INTO bswl_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Wodana oɂwaaten kakkoɂabbaabatareen goorata, Yesuusa Simoona kaɂamamere P'et'iroosane, «Ere kayoona Simoona!, hinɂakko roorise in geelatta?» ame. Usuna «Ii Goottakki!, geelatanokkee atittakkassa» ame. Yesuusana «C'ibaarkkee foofi» ame. ");
INSERT INTO bswl_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesuusana kallami, «Ere kayoona, Simoona, rumminaa in geelatta?» ame. Usuna, «Ii, Goottakki, ani ku geelatano atitta kassa» ame. Yesuusana, «C'odeelkkee oori» ame. ");
INSERT INTO bswl_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Gooratta kaseedina, «Ere kayoona, Simoona; in geelatta?» ame. P'et'iroosana goorata kaseedi Yesuusa, «In geelatta?» ame mankkohoosatewun gaddaa tabere «Goottaa ati dubba kassowa goggogeelatarona kassowa» ame. Yesuusana, «Idaadkkee foofi ame. ");
INSERT INTO bswl_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ani rumminaa rumminaa amara, ati wodallumaa giraan sarssikkaa issii tabissattedde mankkogeelaatte seetaa gitte, gojaaroɂntte adi gene diriirssayinatta, ibaaddo kakkaleenna huukkaa tabisire seeyin mankkogeelaannoon geesinara.» ");
INSERT INTO bswl_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesuusa hikka kakkoon amera P'et'iroosa misikki goyii Waa kabajin dootisaro tusinya. Hittakko danbbeebaan P'et'iroosane, «Indebee sesseena» ame. ");
INSERT INTO bswl_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","P'et'iroosa haararttii gowochiro, Yesuusa geelataa kagire usukko kaɂagaalssatare iso debee kasessetaro dee, hikki usukko kaɂagaalssatare usu goorata kita kahemeene aamaa giraan geegiyo tayesuusa gabbalamere, «Gootta, ku roorisi kasisinara ayyoya?» amaa kagireya. ");
INSERT INTO bswl_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","P'et'iroosana usu kakkodiyaare goorata, «Gootta! Hikki ibaaddoti misi linnara?» ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesuusana, «ani taaɂabbaabarotii neefo goggogirroo godootate duuddo ku mekat'ibe? Ati metekkawun indebee sesseena» ame. ");
INSERT INTO bswl_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Hikkakkotti aalanttii hikki Yesuusakko kaɂagaalssatare lakkogooro taɂamatta odu amaniil orroo darɂaantte. Yesuusa ade, ani «Taaɂabbaabaro geegin neefo goggogirroo godootate ku mekat'ibe?» ame kuwaarre lakkogoyinaro ame lakkosegeero. ");
INSERT INTO bswl_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Hikkakokki gara kaɂatotaarana hikka kas'aafera hikka Yesuusakko kaɂagaalssataroya, atonnatina rummi laano noo kanssowa. ");
INSERT INTO bswl_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesuusa kafelera kakkalee kamooggan ayeesijjool kagira, ayees dubba gos'aafame, kas'aafamero mas'aafa dubbaan alami talleeto banɂe kaɂabo aani lakkollaaro.");
INSERT INTO bswl_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tewofiloosa! Kahoraarjje mas'aafakkeeyi Yesuusa kafelerona kaɂagaalssisero dubba ani kuun s'aafera; ani kakkoons'aaferana Yesuusa feloɂootteessa kakkohaggaɂabero gooratakko keesere ");
INSERT INTO bswl_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","daruur tabeero arri taageeroo kafeleroya; daruur kakkobeerana oɂassaabatero ofarameeraawun Ayyaana K'ulluukkikokki garane ajaja isoon sise abbaabatereya. ");
INSERT INTO bswl_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Rakkoo tammooggankkona abbaabatere usu issii gabbalamere arddokki laano, hinɂanuun kamooggan atoyii addeesisaa arri afarttam orroo roore roore mutaa wononnati kawaakokki gara isoon segee. ");
INSERT INTO bswl_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Iso wotana babo aamin hamas's'ee giraan haɂame iso ajajee; «Iyyerusaalemikko aroobbeeten; ayesuun goɂameen ani ayeesaa giraan kamaaltteettaan odo tasisero abddi oorayeen. ");
INSERT INTO bswl_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yaannisa bekeeyi t'ammak'aa gire; isin goɂameen arri uc'c'arkko abbaabayiddeen Ayyaana K'ulluukkii t'ammak'aaminattaan.» ");
INSERT INTO bswl_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Isona raattoo kukkumeen giraan, «Gootta! Wononnati Isiraɂeelwun abbaab ati kakkoɂusubaayisinatta goorata giddaaya?» ameen hoosaten. ");
INSERT INTO bswl_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesuusana haa ame isoon abbaabe; «Odo odonnatikkessayi kamurtteeseero goratajool goorttun almmaal malabiin isin lakkodaanddeetan. ");
INSERT INTO bswl_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ayesuun goɂameen Ayyaana K'ulluukki isin gutii kakkodage goorata hunna atayinattaan; Iyyerusaalemi, Yihuudaayinna Samaariyayi dubbaa, ulkotti gachcho taa geetanii atolkkee linnattan.» ");
INSERT INTO bswl_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Usu hikka ayeese abbaabatere iso diyaagiraan daruur bee; duumanchchana iltisookko golise. ");
INSERT INTO bswl_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Usu daruur tos biyaa giranttiin, isona tichchiseen diyaagiraan sarssi gumaarakki osarsatereen ibaaddojja lama derɂa isoo dollee aalleeren, ");
INSERT INTO bswl_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","haanna ameen; «Isin ibaaddo kagaliila,» «Daruur diyaa hittanii kakkoonɂaalliteettaan mewuunya? Hikki isin dollekko daruur biyaa giranttii isin kaddeetettaan Yesuusa, daruur tos biyaa goggoddeetettaankki malee usumaleewwa abbaabayi emeeyinara» ame. ");
INSERT INTO bswl_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Esekko abbaabatere zayitii kabiyaara gaa takkoɂalataro wodamikko Iyyerusaalemi abbaabateen seeteen, hitti wodami Iyyerusaalemikko tafoolssi arrii goggosesseerawun kasisamero raa gitakki fakki amatte. ");
INSERT INTO bswl_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Katamaa tos kakkotabeeren goorata kakkokukkuɂamareen fook'ii korateen; hinɂina P'et'iroosa, Yaannisa, Yayik'ooba, Indiraasa, Filp'oosa, Toomaasa, Berttelomeewosa, Matoosa, kaɂilfoosa ere Yayik'ooba ulkkeessawun kahaɂusataro Simoonana, ere kayayik'ooba Yihuudane gireen. ");
INSERT INTO bswl_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Hikki ibaaddo dubba heleel kookkoonne, Aaye tayesuusa Mayiraamenee, usumalee abbilaaltteessa wota wodana too leenguren ebi haɂiisooni arggetto ebaataa gireen. ");
INSERT INTO bswl_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Hassu goorata P'et'iroosa boolnna lamattan olleeraan abbilaal orroo kee aalleere, ");
INSERT INTO bswl_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Abbilaalttee! Yesuusa kaɂabero ibaaddoon horehaye kak'ajeelisaro kalleero Yihuudakokki gara, Ayyaana K'ulluukki t'aye hiɂi tadaawutee kaɂayeesera kamaas'aafa haafura gudayin mankkodootisaro maraanya. ");
INSERT INTO bswl_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Usu nookko koo aani tootaamere hikka handdaawun lelledamanokokki iddilii helate gire ame.» ");
INSERT INTO bswl_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Hikki ibaaddoti felo omeellankotti muraayi ul iminate; hore hore iyye bebbeed ul oyere, t'eɂekko bogi berɂee hubbo bee ubate; ");
INSERT INTO bswl_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","hikkina Iyyerusaalemi kagiro ibaaddo dubbaan maalssame; usu ulnna heɂittisooyi «Akeldaama» amame uumame, fureenna «Ul kaɂiigi» amanoya. ");
INSERT INTO bswl_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","P'et'iroosana debee, «Kamazamuri mas'aafayi haa ame, « ‹Usu takkogire banɂee halaal halleeto; Esee kagirra ibaaddona aroohelamo;› Adena « ‹Odonnatikkeessa kakkalee haɂatato› amame s'aafamera. ");
INSERT INTO bswl_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Haannuun Goottaa Yesuusa no orroo takkosesseetaree arggetto noonne wota kagire ibaaddokko odo koo assaabamiin dootisara; ");
INSERT INTO bswl_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","hikkina, kayaannisa t'ink'atakko haggaɂabere Goottaa Yesuusa daruur tabeero arri taageeroo noonne wota kagire hikka ibaaddokko koo noonne wota goyikko kiyaanokokki ato goggolleeroon dootisara.» ");
INSERT INTO bswl_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Haannuun Iyost'oosa goorttun Berssabaasi kaɂamamere Yoosefana Matiyaasane iso lama keenen; ");
INSERT INTO bswl_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Haa ameen ebaaten, «Gootta, ati ibaaddo dubbakotti wodana kassowa; hinɂa lama orrokko kaɂassaabattetto ibaaddo noon tusi. ");
INSERT INTO bswl_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Kakkoonɂebaatannana Yihuuda iise taseetero banɂetteessaa hikka handdaawunna ofarameeraankotti banɂe noon goggoshuumitonya.» ");
INSERT INTO bswl_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Esekkona it'aa beesen, it'aanna Matiyaasa beesse, usuna tomonkko koo ofarameeraane wota tootaame. ");
INSERT INTO bswl_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kap'ent't'ek'ost't'e baala kakkogeyaare goorata, Yesuusakko oɂagaalssatareen dubbana raattoo banɂe tooyi kukkumeen gireen; ");
INSERT INTO bswl_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Derɂana taɂatii huffo aanttitti yaaye daruurkko emeettedde kakkogireen min ammagantte. ");
INSERT INTO bswl_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Lac'a kaɂeleenee aani kallaaro kalekaleekki errebjjool deen; kalekalee beete mete metee ibaaddo gutii dayidde. ");
INSERT INTO bswl_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Dubbana Ayyaana K'ulluukki ammagameen, Ayyaanana goggoɂayeesinawun isoon kasiserokokki jilbbaa takkalee heɂii ayeesano haggaɂabeen. ");
INSERT INTO bswl_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Usu goorata alamii kagiro gosa dubbakko kaɂemetere Waa kaɂabssatare Ayihuudi Iyyerusaalemi gire. ");
INSERT INTO bswl_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Hitta yaaye kakkomaalaren goorata gosa kamooggan raattoo kukkume; kakukkuɂamera gosana, metemeteeyi kakukkuɂamero gosakotti heɂii iso ayeesaa giraan maalere saade. ");
INSERT INTO bswl_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Gosa mamaanna saadaa haa ame, «Hikki kaɂayeesara ibaaddo dubba la kagaliilayolla? ");
INSERT INTO bswl_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Hayya no mete metee kakkoɂalannenno ulkotti heɂitaani iso ayeesaa giraan kamaalanna hikki misiiya? ");
INSERT INTO bswl_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Noo ul kap'arttenayi, ul kameedi, ul kaɂilamiyayi, ul kamesip'et'oomiyayi, ul kayihudaayi, ul kak'ep'edok'iyayi, ul kap'ant't'oosi, ul kaɂisiyaayi, ");
INSERT INTO bswl_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ul Firggiyayi, ul kap'inifiliyayi, ul kagibis's'i, ul kak'ereenayi dollee kagiro taliibiya awuraajjaayi oginnonna; Roomikko oɂemennenno; ");
INSERT INTO bswl_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ayihuudina kaɂayihuudi ammano tos otabnnena noo, kak'ert't'esina kaɂarebi ibaaddo gollenno, ibaaddona oɂatii felo owaa heɂitttaani goɂayeesiro maalanna.» ");
INSERT INTO bswl_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Haanssun dubba mamaanna girddiɂamenen, «Hikki ayees misi linnara!» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kookkoo ibaaddo ade, «Habeenoni kagiro t'amo kawoyinii t'amereen seteeraan» amaa k'ac'c'ifate. ");
INSERT INTO bswl_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Hassu goorata P'et'iroosana tomonkko koonne wota kee aalleere, yaayee t'ok'k'ise haa ame gosaan ayeese, «Isin ibaaddo kayihuuda Iyyerusaalemii ogittan dubba hikka ayees koo addeesa, madaara c'ak'asa. ");
INSERT INTO bswl_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Goorata ganaa barikko saatii seed mankkollee maraan isin goggohedattan malee hikki ibaaddo lakkoseteero. ");
INSERT INTO bswl_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ayesuun goɂameen hikki kahegeroo Iyyuɂeelii haa amame goggoɂayeesameroya; ");
INSERT INTO bswl_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","« ‹Waa haa amara, kagachchoo arrijjoolii haa linnara, Ayyaanakkee soo kasarsatero ibaaddo dubbaa gutii dagisinara, Babbaar yiiskkisinna deeleel yiiskkisin hegero ayeesnaran; Wadallakkisinna raaga dinnara, Jaarsoleettisinna hisilloyinatta. ");
INSERT INTO bswl_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Usu goorata Iin ohanadaaraan babbaarnna heleelnna gutii Ayyaanakkee dagisinara, Isona hegero ayeesinaran. ");
INSERT INTO bswl_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Elenne daruurii kasaadisiro kooko tusinara, Hegelle ulnna baasana malaataal tusinara, Iigi, eleenna, iyyoottena linnara. ");
INSERT INTO bswl_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tanjiinttina takabajaantte tagootta arri emeetokko horene, Arriti mugud tos Diginninna iigi tos iggilissaminaran. ");
INSERT INTO bswl_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kagoottaa mege kaɂuumatara dubba fayyinara.› ");
INSERT INTO bswl_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Isin kaɂisiraɂeel ibaaddo! Hikka haafura maala; isin metekkisinuun goggokassaanii, Goottaa isin orroo baasana kasaadisiro kookona malaataal felanooyi gara kanaazireti Yesuusakokki ayyonnati addeesisera. ");
INSERT INTO bswl_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Usu metekkeessawun Waa t'aye ohederona omalabero felokokki malee isinuun roore sisame; isinna, ibaaddo kameellankotti genee goggosuwaamironna goggogooro yeltteen. ");
INSERT INTO bswl_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Waa ade goyikokki abboosa tiregure usu keese, aalanttina goyiinna usu abi haasin lakkodaanddee. ");
INSERT INTO bswl_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Daawutena garakkeessa haa amera, « ‹Gootta arggetto horetteeyi ani diyaara; Usuna merggetteeyi gira; duuddo ani lakkoshalagaminaro. ");
INSERT INTO bswl_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Haanssun wodanatti geggelaatte, Hiɂittina geggelaanjjee ammagantte Sooɂoottina abddii girnnaraan. ");
INSERT INTO bswl_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Neefotteenna kagoye ibaaddo takkogiro banɂee (Bowwaa) lakkoɂiisinatto, k'ulluukkikkaanna shami goggohesiroon lakkoyelatto. ");
INSERT INTO bswl_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Raa kaneefoo ani goggoɂaddeesiroon yelttetta; In ku hore geggelooyi ammaginatta.› ");
INSERT INTO bswl_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Abbilaalttee! Odolaal kat'awookko Daawute goye goggok'amalameroo, k'amalkkeessana hittaari taageeroon no orroo giranokokki jabuuyi ani ayeesin daanddaara. ");
INSERT INTO bswl_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Daawute hikka kakkoonɂayyeesera kahegeroo laanona Waa sanniitteessakko kaalaal korffinjjekkeessaa gutii goggohamas'iroon kaɂammatokokki haafura usuun katabero laano malabe. ");
INSERT INTO bswl_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Hitta aalanttii Kiristoosa goyigure kagoye ibaaddo takkogiro banɂee kahesoon laanona sooɂoottessana gumbbi orroo shami ohesoon laano Daawute t'aye deegure goyikko keyaanokkessakokki gara ayeese. ");
INSERT INTO bswl_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Hikka Yesuusa Waa goyikko keese, no dubbana hikka ayesuun atojjoolnna. ");
INSERT INTO bswl_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Haanssun usu mergge tawaayi hamas's'iin t'ok'k'i kakkoɂamare gooratana, Ayyaana K'ulluukkikotti abddi odokko atatere gidda kadeyaattaanna kamaalattan dagise. ");
INSERT INTO bswl_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Daawute daruur lakkobeero usuna metekkeesswun ade haa amera, «Gootta, Goottakkeewun «Ani diinakkaa lukittaayi taadaddarisiroo Merggetteeyi hamas's'ii» ame. ");
INSERT INTO bswl_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Goortta, Waa hikka isin kasuyitettan Yesuusa Goottanna Kiristoosa yelano Isiraɂeelkokki gosa dubba haɂaddeeso!» ");
INSERT INTO bswl_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Gosana hikka kakkomaalare goorata wodanattiso aaloo dinanttedde, P'et'iroosana okkalee ofarameeraawun, «Abbilaalttee, hayya me yelnna?» ame. ");
INSERT INTO bswl_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","P'et'iroosana isone, «C'ubbokko gula gala, c'ubbokkisinna haheso goggoɂamamiroon, mete metekkisinuun Yesuusa Kiristoosakokki megee t'ammak'ama; ilabo kawaa kalleero Ayyaana K'ulluukki atayinattaan. ");
INSERT INTO bswl_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kaɂabddii haafura isinuunna yiiskisinuun usumaleenna Goottaa Hedokkaani isiɂootteessa tos oɂuumaro, ebbaa ogiraan dubbaawunya» ame. ");
INSERT INTO bswl_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kakkalee kamooggan haafura isoon atotaa, «Hitta tawoc'ac'c'antte alattaan gutii kaɂemeetaro bayikko isiɂoottisin haasayeen!» amaa gorssee. ");
INSERT INTO bswl_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Haafura oɂatateeraanna t'ammak'ameen; eserri kuma seed kalleera ibaaddo tootoɂoottiso gutii adame. ");
INSERT INTO bswl_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Isona ofarameeraankokki agaalssisii isiɂaata, raattoo babo aamaanna ebii ataataa gireen. ");
INSERT INTO bswl_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ofarameeraankotti genee omooggan osaadamiraanna baasanɂi feloo felamaa mankkogireen maraan ibaaddo dubbaan abissi bariite. ");
INSERT INTO bswl_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Amaniil dubba raattoo koollee gire, kaɂabanaayen dubba rattookki yelateen. ");
INSERT INTO bswl_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Durummattisona urrawoɂoottiso daddalateen ibaaddon mete metee kadootisaro gitakki sisaa gireen. ");
INSERT INTO bswl_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Arggetto k'ulluukki min kawaayi raattoo eselaa, minjjolkkisooyinna babo aamaa geggelooyinna taɂidantti wodanaayi aamaa gireen, ");
INSERT INTO bswl_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Waa galataanna gosa dubbaayi horee gaashana abanaayen; Goottanna ofayyaraan arri arrii tootoɂoottisoo gutii adaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Arri too P'et'iroosana Yaannisana kaɂebi goorata arrikko saatii saagallii k'ulluukki min kawaa tos biyaa gireen. ");
INSERT INTO bswl_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","K'ulluukki min kawaa tos katabaro ibaaddokko kooko atayin goggoɂebaaroon, ibaaddo arggetto keenen «Taɂidantti» taɂamanaan k'ulluukki min kawaa kakkotabaraan gooc'a horee kakkaanen koo taɂumulame arrikko haggaɂabere naafaleessa kalleere ibaaddoti koo gire. ");
INSERT INTO bswl_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Usuna P'et'iroosana Yaannisa k'ulluukki min kawaa tabaa giraan deegure kooko atayin isokko ebaate. ");
INSERT INTO bswl_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","P'et'iroosana Yaannisa usu tos tichchiseen deengureen, P'et'iroosana usune, «Alla no tos dee!» ame. ");
INSERT INTO bswl_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ibaaddotina isokko kooko atayin hedere tichchise iso dee. ");
INSERT INTO bswl_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","P'et'iroosa ade, «Ani maragadena work'k'ii lakkoɂabo; ayesuun goɂameen ani kaɂabo kuun sisinara; kanaazireti Yesuusa Kiristoosakkokki megee kingudde sessee!» ame. ");
INSERT INTO bswl_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Gene tamerggetatteessa abe keese; goorsewa luk'k'ana mikitajjoolnna ataate; ");
INSERT INTO bswl_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Elddee firimere tukkul aallee; sesseetanona haggaɂabe, hittarraa hasserraa sessetanna firfir amaa Waa galataa isone wota k'ulluukki min kawaa tabe. ");
INSERT INTO bswl_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Gosa dubbana usu Waa galataa kasesseetaro kakkodeyaare goorata, ");
INSERT INTO bswl_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Hikki ibaaddoti «Taɂidantti» taɂamamatto banɂee k'ulluukki min kawaa kakkotabaraan gooc'aa hamas's'eere kooko ebaataa kagire usu laano malabe; usuun ofelameraan felokko kakkeeyi ibaaddo saadanonna mamanoyi ammaggame. ");
INSERT INTO bswl_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kafayyeera kaɂebaatare ibaaddoti P'et'iroosanena Yaannisane wota kutuutame giranttii gosa dubba mamanoyinna iso mankkogiraan Solomooni takkosesseetaro taɂamanttetto banɂe tos tiyaa emeeten. ");
INSERT INTO bswl_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","P'et'iroosana hikka kakkodeyaare goorata haa ame; «Isin gosa kaɂisiraɂeel! Hikka ayees muun saadattaan? Adena hunnakkaani goorttun k'ullummataani hikki ibaaddoti fayyiire goggosesseeroo no kayelnnenno aani yeltteeddeen muun no tichchisseen diyaattaan? ");
INSERT INTO bswl_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Odolaalkkaanikki Hedo kaɂabraame, kayissaak'ana kayayik'ooba Hedo erekkeessa Yesuusa kabajee; isin addeene usu goggogooro roorsseen sisseen; P'ilaat'oosa furin godootena isin addeen usu horee kakatteen. ");
INSERT INTO bswl_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Isin goɂameen karrummiinna k'ulluukki kakattenddeen neefo kalagadera isinuun goggofuramiroon ebaaten. ");
INSERT INTO bswl_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Giri kakkohelamaro lagadattaan; Waa ade usu goyikko keese; noonna hikkanuun atonna. ");
INSERT INTO bswl_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Hikki isin kadiyaattanna kakkassaan ibaaddoti kaɂataatera mege kayesuusa ammananooyiya; isin dubbana goggodiyaattanii duuddokki fayyinna goggohelaroo kayelara mege kayesuusaanna garakkeessane kahelamaro ammanooya. ");
INSERT INTO bswl_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Giddanna abbilaalttee! Isin hikka kakkoonyeltteettaan woyichchaalkisin aani malabanawaattiikko kakkeeyi kalleero laano ani kasowa. ");
INSERT INTO bswl_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Waa ade kakkeessa kalleero Kiristoosa rakkoo goggoɂataroo t'aye kahegerool dubbakkotti hiɂii kaɂayeesera hikkamalee goggogudaroo yele. ");
INSERT INTO bswl_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Goortta c'ubbokko gula galaddeen Goottaa tos abbaabayeen; ");
INSERT INTO bswl_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Hikkaniinna Waayi dollee kakkoɂusubaattan geesjjool isinuun emeeyinara; Waa t'aye kaɂassaabero Kiristoosa Yesuusa isinuun farnnara. ");
INSERT INTO bswl_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Usuna daruurii kakkoɂadallayinnara Waa t'aye k'ulluunɂi ohegeroolkotti hiɂi goggoɂayeeseroo alami dubba taaɂusubaaronya. ");
INSERT INTO bswl_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Muse haa amera, «Gootta Hedo in goggokeeseroo usumaleenna abbilaalttisin orrokko in aankkikki kahegeroo isinuun keesirowa; usu isinuun kasegaaro dubba maala. ");
INSERT INTO bswl_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Hassu kahegeroo kamaalon dubba gosa orrokko kale bire habbawo ame. ");
INSERT INTO bswl_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","«Ogiraan Saamelakko haggaɂabere kakkeera kahegerool dubba hikka goratajolkkokki ayeeseran. ");
INSERT INTO bswl_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Isin kahegeroolkokki yiisttaan; adena Waa Abraamene ‹Sanniittaayi gosa kaɂulee dubba sommaasaminara› amere odolaalkkisinun otabero ammato oɂeelinattanttan. ");
INSERT INTO bswl_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Waa erekkeessa assaabe kakkokkeesere goorata, isin mete metee meellanetisinkko abbaabigure goggosommaasaron t'aye usu isin tos fare.» ");
INSERT INTO bswl_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","P'et'iroosana Yaannisana gosaawun ayeesaa giraan tuuk'aamolnna k'ulluukki min kawaa kaɂooraron odonnati kaɂabanaaye usumaleenna ibbaaddo kasodok'aawiil derɂa iso tos emeete. ");
INSERT INTO bswl_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ofarameeraan lamana Yesuusakokki goyikko kiyaano gosa agaalssisanoyinna goyikko kiyaano girano iso lallaabaanoyi amaraateen. ");
INSERT INTO bswl_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","P'et'iroosana Yaannisana abeen; gooratana hemeen mankkoleere maraan ul taabarirooyi minkashaano bariiseen. ");
INSERT INTO bswl_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Halleewo kuwaarre haafura kamaalero ibaaddo orrokko kamooggan ibaaddo Waa ammane, tooto obabbaarenna kuma ken gitanɂi leen. ");
INSERT INTO bswl_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tallami arri woyichchaalkisona, jaarsoleettiso usumaleenna seera oɂagaalssisareen Iyyerusaalemii kukkuɂameen. ");
INSERT INTO bswl_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Tuuk'aamolun odonnati kaɂabanaaye Haanna, K'eyaafa, Yaannisa, Isikindirosana, katuk'aamool woyichchaatikokki kaminee ibaaddo dubba ese banɂe gire. ");
INSERT INTO bswl_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Isona P'et'iroosana Yaannisana t'eɂe aallisereene, «Hikkana kakkoyelttettaan eeki Hunnaayi goorttun mege kaayyoya?» ameen iso hoosaten. ");
INSERT INTO bswl_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Usu goorata P'et'iroosana Ayyaana K'ulluukki ammagamere haa ame; «Isin kagosa woyichchaalna jaarsolee! ");
INSERT INTO bswl_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Hittaari hikka naafaleessakki ibaaddotin felo oɂidan mankkofelameraan maraan misimisii fayyeero no kahoosattaan gollee, ");
INSERT INTO bswl_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","hikki ibaaddoti fayyeegure isin horee kaɂalleera kasuyitetteeninna Waa ade goyikko kakkeeseroo kanaazireti Yesuusa Kiristoosakkokki megee laano isin dubbana, kaɂisiraɂeel gosa dubbana kaɂaddeesame halleewo. ");
INSERT INTO bswl_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Usuna, « ‹Isin oginbbattan kattuffatteettaan eɂemo mina afarruun mete lee.› ");
INSERT INTO bswl_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Haanssun fayyinna usuu kuwaarre kakkalee maayyoonna laagiro; no goggofayyinnon ibaaddon kasisamera hikka megekko kakkalee mege daruurkko hegelle laagiro.» ");
INSERT INTO bswl_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ibaaddona P'et'iroosana Yaannisa haa jabuuyi ayeesaa giraan kakkodeyaaren goorata, kaɂagaalssannongiro ibaaddo laano addeeseren saadeen; iso Yesuusane wota girano addeesen. ");
INSERT INTO bswl_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kafayyeera ibaaddotina esee iso wota aallee giranttii mankkodeen maraan kaɂaalaraan waateen. ");
INSERT INTO bswl_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Haanssun iso shonggokko sarre bi goggogirraawun ajajeen; esekkona raattoo kukkumeen makkareen. ");
INSERT INTO bswl_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«Goortta hinɂa ibaaddojja misi yelnna? Hikki kaɂatii baasa genettisooyi felamano Iyyerusaalemi kagira ibaaddo dubba addeesera; haanssun kakayin lakkodaanddaano. ");
INSERT INTO bswl_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Halleewo kuwaarre hikki ayees goortta gosa orroo aaloo goggobalɂaannonkko, hinɂi ibaaddojja adi mege kayesuusa uumaa maayyoonna goggoɂayeesonkko seeriinna.» ");
INSERT INTO bswl_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Esekko iso uumengurene mege kayesuusa duuddo goggoɂayeesonkkona goggoɂagaalssisonkko ajajeen. ");
INSERT INTO bswl_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","P'et'iroosana Yaannisana addeen abbaabeen isone haa ameen. «Waakko roorinsse isinuun ajajaamano Waayi horee kadootisaro gollee alla isinwa metekkisinuun firddaa. ");
INSERT INTO bswl_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Noo kaddeenennona kamaalnnenno ayeesanakko haar lakkogalnno.» ");
INSERT INTO bswl_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Adena manddeen abbaabateenguren gafareen; aalanttina gosa dubba kalleero ayeesi Waa galatataa mankkogire maraan iso murrisin lakkodaanddeene. ");
INSERT INTO bswl_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Hikka baasa kafayyeera ibaaddoti gees afarttamkko karooreye. ");
INSERT INTO bswl_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","P'et'iroosana Yaannisa furameen amaniil tos abbaabateen seetereen tuuk'aamolkokki woyichchaalnna jaarsolee kaɂameeraan dubba segeen. ");
INSERT INTO bswl_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Isona hikka kakkomaalaren goorata yaayetiso raattoo Waa tos t'ok'k'iserene haa ameen; «Goottakkaani ati daruurnna ul, bekena beke orroo kagiro dubba ati met't'itetta. ");
INSERT INTO bswl_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ayyaana K'ulluukkikokki garane kuun kahandaaro Aabbokkaani Daawutekkotti hiɂii haa antte ati ayeesetta; « ‹Ayizaab enggee muun kekkee? Gosana muun t'oye? ");
INSERT INTO bswl_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kaɂulee wonolaal keegure, mootijjol raattoo kukkumeengurene, Goottayinna Kiristoosa gutii keen.› ");
INSERT INTO bswl_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«Ogiraan Herodoosana kap'ent't'iyoosa P'ilaat'oosa kaɂayizaabna kaɂisiraɂeel gosane wota hitta katamaayi ati kashigiddetto k'ulluukki kuun kahandaaro Yesuusa gutii c'aafin kukkumeen. ");
INSERT INTO bswl_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Hikkina kakkoonleera ati t'ayite hunnakkaayinna feɂittaayi kahalchchitetto feliinya. ");
INSERT INTO bswl_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Giddanna Goottakkee! Abssisatto ayeesanokisoo dee; diyyiilkkaa haafura duuddotti jabuuyi ayeesin goggodanddeerawun yeli. ");
INSERT INTO bswl_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Fayyiisin genettaa diriirssa, k'ulluukki kuun kahandaaro kayesuusa megee kasaadisirona baasa feli.» ");
INSERT INTO bswl_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ebaaten kakkoɂabbaabatareen goorata iso takkogireen banɂe shalagaantte, dubbana Ayyaana K'ulluukkii ammagameen; haafura kawaanna jabuuyi ayeeseen. ");
INSERT INTO bswl_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Amaniil dubbana Wodana tooyinna yaada kooyi isiɂaateen gireen; kaɂabanayeen dubba raattokkiye kuwaarre oottessa olleeraan urrawo iskkonɂi aani katootatera maayyona lakkogire. ");
INSERT INTO bswl_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ofarameeraanna Goottaa Yesuusa goyikko keyaanokokki gara kaɂatii hunnaayi atotaano horeddeen; iso dubbaa gutii taɂatii sino tawaa gitte. ");
INSERT INTO bswl_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Iso orroo rakkataa koonna lakkogire; aalanttina ulnna leere minii kaɂabanayeen dubba daddalereen maragade keenaren; ");
INSERT INTO bswl_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Maragade keenereen ofarameeraawun sisaa gireen; isona odo odoo goggodootisarokki jilbba malee hedeedaa gireen. ");
INSERT INTO bswl_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tak'op'irosa oddolaayi kagire Yoosefa kaɂamamare woyyuuti koo gire; ofarameeraanna usu, «Barnnabaasi» ameen uumeen; fureenna «Kagoggo isaro ere» amanoya. ");
INSERT INTO bswl_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Usuna erre daddalere, maragade geese ofarameeraawun sise. ");
INSERT INTO bswl_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Hanaaniya kaɂamamere ibaaddoti ooritteessa Sap'erane wota erre daddale, ");
INSERT INTO bswl_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ooritteessana madaartte addeesa giraan kadaddaleeraankko gamisa haasegure gamisa keene ofarameeraawun sise. ");
INSERT INTO bswl_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","P'et'iroosa ade haa ame, «Hanaaniya! Ayyaana k'ulluukki goggosobttonna erre takkodaddalanttetto maragadekko gamisa goggohaassoon s'alaye wodanattaayi muun tabtte? ");
INSERT INTO bswl_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ati daddalanokko horene erre lakkotattaatteya? Godaddalattena ade maragade lakkogenettaayi gireya? Hayya, hikka ayees misii wodanattaayi k'oppite? Ati kasobittetta Waayya kuwaarre ibaaddo lakkoyo» ame. ");
INSERT INTO bswl_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Hanaaniya hikka haafura goggomaalee ulii iyye goye; hikka kamaale ibaaddo dubba aaloo abssate. ");
INSERT INTO bswl_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Darggageessalnna keegure rees gashee mareenguren; geesen k'amaleen. ");
INSERT INTO bswl_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Saatii seed leete roortte giraan, ooritteessa kalleero ayees hamaalo giraan emeette tabtte. ");
INSERT INTO bswl_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","P'et'iroosana, «Erre kakkodaddaltteettan maragade hinɂayaan alla iin segii?» ame. Esena «Ii hinɂayaan» antte. ");
INSERT INTO bswl_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","P'et'iroosana, «Kagootta Ayyaana c'aafin misii hikkamalee hiɂi too leeteen? Hikkima entterkkaa kak'amalera ibaaddo abbaabatere gooc'a geera; kunna geesiren k'amalinnaraan» ame. ");
INSERT INTO bswl_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Esena goorsewa luk'k'aɂoottessa hegelii iite goote; darggageessalnna gotabiraan tagootetto deen; sideen geesenguren entterkisee dollee k'amaleen. ");
INSERT INTO bswl_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Min kawaakki ibaaddona hikka ayees kamaalera kakkalee ibaaddo dubba aaloo abssate. ");
INSERT INTO bswl_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ofarameeraankokki garane gosa orroo kamooggan baasakki malaataalnna osaadamiraan felo felameen; amaniil dubba Solomooni kakkosesseetaro gooc'aa kukkuɂamaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Iso wota lelledamiin kajabaate maayyona lakkogire; golleenna gosana iso aaloo kabajaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Waayi kaɂammanara babbaarnna heleelnna arri arrii tootoɂoottisona aaloo adamaa seeteen; ");
INSERT INTO bswl_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Hikkakko kakkeeyi P'et'iroosa esene rooraa, giraan abaraanttii hoosinddetteessa uc'c'arri gutii goggoɂaallitoo amaa kahawɂamaro ibaaddo sarddeediseen beesaa alggaayinna rareeyi raadii huddurisaa gireen. ");
INSERT INTO bswl_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kaɂiyyerusaalemi gobobii kagiro katamaalkko kahawɂaamarona battiikki ayyaana abamere kaɂabboosaro ibaaddo aate kaɂemeetara ibaaddo kamooggan usu gobob unɂaa gire; kaɂemeete dubbana fayyaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Hikkakko kakkeey tuuk'aamolkokki woyichchatina raattoo tagitte tasodok'aawil una dubba gaabbii ammagantte. ");
INSERT INTO bswl_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ofarameeraanna abeeren minkashaano tabiseen. ");
INSERT INTO bswl_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Halleewo kuwaarre erggichcha kawaa ade hemeen t'eɂe min kashaanokokki ufa bane beesere, ");
INSERT INTO bswl_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Seeyeen!, k'ulluukki min kawaakki awudii aallaa; hikka haafura kagiri gosa dubbaan segaa!» ame. ");
INSERT INTO bswl_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ul goggobareeyi isoon goggosegeerokki malee k'ulluukki min kawaa tabeeren gosa agaalssisano haggaɂabeen. Katuuk'aamol woyichchatina usune wota ogireen emeeteren taɂayihuudi shonggonna taɂisiraɂeeli jaarsolee dubba raattoo kukkuyiseen; ofarameeraanna iso tos goggokeennawun ibaaddo minkashaano fareen. ");
INSERT INTO bswl_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Handdaa oseeterenna minkashaano seetereen esee oshaameereen lakkohelereen; abbaabateen emeeteren haa ameen; ");
INSERT INTO bswl_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Minkashaano aaloo c'ufamere, oɂooraraanna gooc'a horee oɂaallereen deenne; noo ufa baninne gotabnno orroo maayyona lakkogire.» ");
INSERT INTO bswl_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","K'ulluukki min kawaa kaɂooraro kaɂajajaare tuuk'aamolkokki woyichchaalnna hikka kakkomaalaren goorata ayeesi mamaa girddi ameen. ");
INSERT INTO bswl_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Usu goorata ibaaddoti koo emeetegure, «Isin minkashaano otabissetteen ibaaddojja k'ulluukki min kawaayi aalleeren gosa agaalssisaa giraan» ame segee. ");
INSERT INTO bswl_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Goorsewa kaɂooraro kaɂajajaarekki wotaadaralkeessanne wota seetere abe keene; okeeneraan adeen gosa iso eɂemoo goggoɂeeggoonkko abssateenguren anhunnomoni keenen. ");
INSERT INTO bswl_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ofarameeraanna keenenguren shonggoo horee aalliseen; tuuk'aamolkokki woyichchatinna haa ame iso hoosate; ");
INSERT INTO bswl_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Hikka megee isin goggoɂagaalssisonkko no isinuun ataayinsse seginenne; isin goɂameen Iyyerusaalemi agaalssisikkisin gambbayisseen; adena hikka ibaaddotikokki iiguun noo goggohoosaminnoon yelin dootaattan.» ");
INSERT INTO bswl_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","P'et'iroosana okkalee ofarameeraan adeen haa ameen abbaabeen; «Ibaaddokko roorssayi Waawun ajajaamano dootisara! ");
INSERT INTO bswl_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Isinna gaa gutii suyiteen kalagaddeetteen Yesuusa, odolaaltisinkokki Hedo goyikko usu keesera; ");
INSERT INTO bswl_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Waa gosa kaɂisiraɂeelwun c'ubbokko gula galanona c'ubbokko shaaga goggoyelloon, Waa dubbaawun Yesuusa metena kafayyisaro yele merggettessayi kabajaayi goggohamas'iroon yele. ");
INSERT INTO bswl_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Noonna hikka ayesuun atonna; ade Waa usuun oɂajajaamaranun kasisera Ayyaana K'ulluukki atoyya.» ");
INSERT INTO bswl_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kashonggoo maganaalnna hikka kakkomaalareen goorata gomeellan amaraate lagadin dooteen. ");
INSERT INTO bswl_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ayesuun goɂameen gosa dubbaa horee kakkabajjaame koo seera kaɂagaalssisara, usuna Gemaalya kaɂamamara Farasaawiti shonggoo horee kee aalleegure ofarameeraan sar beesire goorata kic'c'aruun goggofakkisiranun ajajee. ");
INSERT INTO bswl_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Shonggoowunna haa ame; «Isin kaɂisiraɂeel ibaaddo! Hinɂa ibaaddojja gutii felin kaheddeettan ayees isin madaari addeesin dootisara. ");
INSERT INTO bswl_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Hittakko horene Tewodaasi isiɂoottessa kanjinkki yelatanokko kakkeeyi afar boolee kalleera ibaaddo usune wota lee. Ayesuun goɂameen usuna gene taɂibaaddoyi goye; usuu debee kasessetare ibaaddo dubba darɂaame k'ofattessana hesse. ");
INSERT INTO bswl_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Isokko haarre gosa kakkotootamaro almmaa Galiilati Yihuuda keegure kamooggan gosa aate bee; usu debee osesseetaranna helatere; usuna gene taɂibaaddotii goye; debee osesseetareenna darɂaameen. ");
INSERT INTO bswl_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Haanssun giddanna ani kaɂamara, hinɂa ibaaddojja isaaga aroodintteen; yaadakiso goorttun feloɂoottiso ibaaddokko golleen baanawa. ");
INSERT INTO bswl_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Waakko oɂemeeteran golleen isin iso baasin lakkodaanddeetan; suurewa Waanneta iinsseɂinggaamano leera.» ");
INSERT INTO bswl_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Isona gorssa kagemaaliya atateeren, ofarameeraan uumsiseenguren boc'iiseen; kallami mege kayesuusa goggoɂayeesonkko ajajeenguren gafareen. ");
INSERT INTO bswl_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ofarameerenna mege kayesuusa maraan yeraan atayin mankkodaanddeen maraan geggelaataa shonggookko been seeteen. ");
INSERT INTO bswl_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Arggetto k'ulluukki min kawaayinna leere min minii tageggeeloo odu kalleera Yesuusa usu Kiristoosa laano agaalssisanokkona lallabaanokko haar lakkogalereen. ");
INSERT INTO bswl_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Amaniilkonɂi tooto adamaa kakkoseetareen goorata tagiriikki heɂii kaɂayeesare Ayihuudil Yihuudaayi kagire kaɂayihuudi ibaaddo gutii gumggumee; kakkoongungumeerana arggetto garggaarssan kasisamare kaami hedeedanokonɂi felo gutii unattisookki galttaanttejjolun sisanokko mankkoshokkateen maraanya. ");
INSERT INTO bswl_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Haannuun ofarameeraan tomonkko lama kakkalee amaniil raattoo kukkuyisereen haa ameen; «No babo aamisanokokki handdaa handdayin amaa haafura kawaa handdaano iisin lakkodootisaro. ");
INSERT INTO bswl_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Haannuun abbilaalttee! Isin orrokko Ayyaana K'ulluukkinna k'arummaa kaɂammagamero ato kaɂidan kaɂabo ibaaddo todoba assaaba; hikka odonnati isoon sinssa; ");
INSERT INTO bswl_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","No goɂameen ebiinna haafurakkeessa handdaanoyi ataayinanna.» ");
INSERT INTO bswl_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Hikki ayeenssa iso dubba geggelaayise; ammanoonna Ayyaana K'ulluukki kaɂammagamero Isit'ifaanosa, usumaleenna Filp'oosa, P'irokoroosa, Nik'aroona, T'imoona, P'ermmenna kaɂayihuudi ammano kaɂatatere ul kaɂans'ookiyakki Nik'olawosa assaabeen. ");
INSERT INTO bswl_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Isona keenenguren ofarameeraan horee aalliseen; ofarameeraanna ebaaten keengureen genettisoo isoo gutii kayeen. ");
INSERT INTO bswl_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Haafura kawaanna balɂaataa seete; amaniilkonɂi tootona Iyyerusaalemii aaloo moggaataa seeteen; tuuk'aamolkona kamooggan ammane. ");
INSERT INTO bswl_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Hassu goorata Ist'ifaanosa sino tawaayinna hunnaayi ammagamere gosa orroo kasaadisiro ayeenssa baasakki malaataal felaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Usu goorata, «Balchchumma obeeraan Ayihuudikokki min kaɂebi» amame kaɂuumamaro kaɂayihuudi min kaɂebiwuun una olleeren k'ereenakkona Isikindirakko, usumaleenna Kilk'iyakona Taɂiisiya awuraajjaakko kaɂemeetera ibaaddo neebaategure Isit'ifaanosane wota dogamano haggaɂabeen; ");
INSERT INTO bswl_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ayesuun goɂameen Ist'ifaanosa kakkoɂayeesare k'arummana Ayyaana awodin lakkodaanddeen. ");
INSERT INTO bswl_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Haanssun, «Isit'ifaanosa Musena Waanna habaaraa giraan noo maalnnenna» kaɂamaro ibaaddo siyamiseen ekkaasen. ");
INSERT INTO bswl_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Hikkamalee gosane, jaarssa kaɂuleennee, seera oɂagaalssisaran kekkeesaa Ist'ifaanosa absiseen taɂayihuudi shonggoo horee aalliseen; ");
INSERT INTO bswl_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Hikkanunna t'araa oɂatotaaran atojjool keenenen, «Hikki ibaaddoti hitta k'ulluutti banɂeenna seera inggaamano duuddo lakkoɂiisero. ");
INSERT INTO bswl_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Adena hikki kanaazireti Yesuusa k'ulluukki min kawaa diiginara; noo Musekko kaɂatannenno wogana iggilisinara; ame usu ayeesaa giraan no maalnnenna» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Usu goorata shonggoyi hamas's'ee kagire ibaaddo dubba Ist'ifaanosa tichchisi godderaan bebbeedtteessa taɂerggichcha bebbeed aani leete isoon mutte. ");
INSERT INTO bswl_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tuuk'aamolkokki woyichchatina Isit'ifaanosine, «Hikki ani kamaalara ayees rummiya?» ame hoosate. ");
INSERT INTO bswl_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ist'ifaanosana haa ame abbaabe; «Abbilaalttina odolaalkki maala! Aabbokkaani Abraame ul kakaaraani hamas's'iin biyaanokko horene ganaa Mesop'et'oomiya giraan kakkabajaa Hedo usuun mutegure, ");
INSERT INTO bswl_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‹Ulkkaakko beegudde, fallikkaakko kalebeegudde,› ‹Ani kuun katusaro ul tos see› ame. ");
INSERT INTO bswl_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Hassu goorata ul kakkeledaawikko beegure ul kakaaraani hamas's'ee. Aabbokkeessa kakkogowaare goorata Waa kakaaraani ulkko beesegure hittaari isin kakkogittaan ul usu keene. ");
INSERT INTO bswl_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Halleewo kuwaarre luki takkokkaaro gitatti rittii usuun lakkosisere; ayesuun goɂameen hikka ul usuna usukko haarre sanniitteessaan rittii yeli kasisinaro Waa usuun abddi sise gire; hitta abddi kakkosiserena Abraame ganaa yiis haɂumuloon giraanye. ");
INSERT INTO bswl_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Adena Waa haa ame ayeese; «Sanniitta ul kanaap'ayi marttinaayi hamas's'iinatta; afar boolee geenssa diyyummaa orroo abboosaminatta. ");
INSERT INTO bswl_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Adena diyyii yele kaɂiminaro gosa ani goɂameen firddinara; esekkona balchchumma biireen hitta banɂee in hedoyisayinaraan» ame Waa ayeesera. ");
INSERT INTO bswl_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Esekkona hamas'isamanokkokki kaɂammatoo haafura sise; haannuun Abraame Yissaak'a umule; takkoɂumulamere tasiddeedi arri hamas'ise; usumaleenna Yissaak'a erekkeessa Yayik'ooba umule. Yayik'oobana kagosa odolaal kalleero yiis tomonkko lama umule. ");
INSERT INTO bswl_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Kayayik'ooba yiisna abbikkiso Yoosefa k'anaatengurene kadiyyummaa ul kagibs's'in daddaleen; Waa ade usune wota mankkogire maraan, ");
INSERT INTO bswl_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Rakkoo dubbakkona usu beese; kagibs's'i wono Fereɂooni horee gaashanana k'arumma usuun sise. Gibs's'iinna minkkeessa dubbaa gutii kaɂajajaaro yele. ");
INSERT INTO bswl_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","«Usu goorata Gibs's'ina kakkeneɂaani ul dubbaa gutii tanjjiin rakkoo kageegisera uɂina emeete; odolaalkkaani kaɂaamiro babo helayiin waate. ");
INSERT INTO bswl_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yayik'ooba kaami gibs's'ii girano kakkomaalare goorata, odolaalkkaani horaarjje ul kagibs's'i tos fare; ");
INSERT INTO bswl_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","kallami kakkoseeraan goorata ade Yoosefa ayyonnatikkeessa abbilaaltteessawun addeesisate; Fereɂoonina falli kayoosefakokki gara addeese. ");
INSERT INTO bswl_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Esekko abbaabategure Yoosefa Aabbokkeessa Yayik'oobana fallikkeessa dubba usu tos keenssise; isona raattoo ibaaddo todobaatamkko kenye. ");
INSERT INTO bswl_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Haanssun Yayik'ooba Gibs's'i seete; usuna odolaalkkaanina esee goyeen. ");
INSERT INTO bswl_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Lefaalkkisoonna ul kaseekkemi tos atamere, Abraame ul kaseekemii kaɂuumeri yiiskko maragadee kaɂiminero hiyeelii k'amaleen. ");
INSERT INTO bswl_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Waa Abraamen otabero ammato feloo kakkohayisinnara goorata kakkogabbalamare goorata Gibs's'ii kagiro gosakonɂi tooto adamaa seeteen. ");
INSERT INTO bswl_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Esekko abbaabatere Yoosefa kakkaasoon kakkalee wono Gibs's'ii reede. ");
INSERT INTO bswl_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Usuna gosakkaani miiggetteessayi c'annak'ise; yiis goggoɂumulamee goggogooronna sarbeesi goggoshafinaawun, odolaalkkaani gutii hunnoome. ");
INSERT INTO bswl_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","«Usu goorata Musena umulame; usuna Waayi horee kaɂidankki yiittiti lee, Aabbokkeessakki min diginni seed kokkobame jiinate, ");
INSERT INTO bswl_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","sarddee kakkoshafamere goorata ere taferiɂooni heltte aattegudde erekkakisee aani jiinasse. ");
INSERT INTO bswl_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musena tagibs's'i k'arumma dubba agaalssate; ayeesinna felooyi kaɂataate lee. ");
INSERT INTO bswl_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Museen geesii afarttam kakkolaare goorata, abbilaaltteessa kaɂisiraɂeel yiis din wodanatteessayi k'oppaate. ");
INSERT INTO bswl_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Gibs's'iti koo taɂisiraɂeeli unakko koo miirɂa geegisaa giraan Muse deegure usu Gibs's'iti lagade; tamirɂanttetto unatteessawun halo bee. ");
INSERT INTO bswl_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Taɂisiraɂeeli unatteessana Waa genetteessaa balchchumma kabeesinaro iso kashaadaran aani usuun leere; iso goɂameen hikka lakkoshaaderen. ");
INSERT INTO bswl_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tallami arri ade kaɂisiraɂeel ibaaddo lama iinsseɂinggaamaa giraan helegure; wogarsinna dootere, ibaaddo! ‹Isin la abbilaalttaanna muun isiɂisi mirɂaattan?› ame. ");
INSERT INTO bswl_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","«Unatteessa gutii miirɂa geegisaa kagire ibaaddoti goɂameen, Muse shafegure haa ame; ‹ku noo gutii mootina kafirddaatto yele kashuumera ayyoyya? ");
INSERT INTO bswl_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Muu kele Gibs'aawiti goggolagaddettoo inna lagadin dootatta?› ");
INSERT INTO bswl_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musena hikka goggomaalee bak'atere ul kamidiyami marttinaa hamas's'ee; eseenna babbaar yiis lama umule. ");
INSERT INTO bswl_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Gees afarttam ammagame kakkoroorare goorata, tasiina wodamikokki gobobii kagitto gaa orroo, kabeebaro hurisikokki lac'a orroo erggichcha usuun mute. ");
INSERT INTO bswl_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musena kaddeero ayeesi saade; ayees k'ulleessiin eserraa goggabbalamiro tagootta yaaye; ");
INSERT INTO bswl_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Ani odolaalkkaakki Hedo, kaɂabraame, kayissaak'a, kayayik'ooba Hedoya› amaa giraan maalere, Musena abssate; eserraa diinna lakkodaanddee. ");
INSERT INTO bswl_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","«Goottanna usune haa ame; ‹Luk'k'aɂoottaanɂi keferroo beesa; ati takkoɂaallitetta banɂe tak'ullooyitetta. ");
INSERT INTO bswl_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Gibs's'ii kagiro gosakkeekkotti rakkoo ogiraan ani deera; kaɂabboosa iyyakkisonna ani maalera; iso haasin dagera. Giddanna koyi; Gibs's'i tos abbaab ani ku farnnara.› ");
INSERT INTO bswl_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Goortta hanɂu, ‹Mootiinna kafirddaatto yele ku noo gutii kashuumera ayyoyya?› ameen kattuffateraan hikka Muse Waa huura orroo kamutero erggichchakokki garane mootiinna kahaasaro yele gosa kaɂisiraɂeel tos fare. ");
INSERT INTO bswl_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Usuna iso k'ajeelisaa gibs's'ikko beese; gibs's'ii, beke oheelinna k'alulattokki ulii gees afarttamuun kasaadisiro ayeenssa baasakki malaataal fele. ");
INSERT INTO bswl_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","«Gootta Hedokisin in goggokeeseroo usumaleewwa isin orrokko kahegeroo keesirowa amere gosa kaɂisiraɂeeliin kaɂayeesere hikka Museye. ");
INSERT INTO bswl_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Usuna tasiina wodamii kaɂayeesere erggichchanenna odolaalkkaanine wota k'alullattokki ulii tagosa haganaa orroo gire; handdaal kawaanna no tos roorisin atate. ");
INSERT INTO bswl_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«Odolaalttaanina adde neebaate kuwaarre usuun ajajaamin mankkodootannon maraan wodanattisooyi Gibs's'i tos abbaabateen. ");
INSERT INTO bswl_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aaroninenna, ‹Nookko horehayi kasessero waal noon ekkaasina; ul Gibs's'ikko k'ajeelise no kabeesero hassu Muse me usu geeroo no laakanso› ameen. ");
INSERT INTO bswl_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Usu goorata tayayido misilii feleengureen, tolchchaan jaarsso siseen; genetisonɂi felooyina geggelaaten; burraak'een. ");
INSERT INTO bswl_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Waa ade isokko fakkime kadaruure barraajjalun goggohedoyisanawunna roorise iso sise; hikkina kahegerool mas'aafayi haa amame goggos'aafamerokki malee gudate; « ‹Isin kaɂisiraɂeel ibaaddo olleeteettan gees afarttamuun k'alullattokki ulii takkoggitteenii jaarssona meebaa iin sisseetteen? ");
INSERT INTO bswl_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Suurewa hedoyisayiin kafelattettaan tamooloki daasena tolchchakisinkki kareenfu barraajja t'ok'k'i t'ok'k'iseen, Haanssun aninna isin goggobak'attawun yelinnara;› Baablonikko gama horoornnara. ");
INSERT INTO bswl_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Waa Museen goggotuserokki maleenna goggoɂajajeerokki malee tamadaaranttette taɂatoo daase, odolaalkkaanine wota k'alullattokki ulii gitte. ");
INSERT INTO bswl_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Waa iso horekko kahoroorero Ayizaabkokki ul kakkoɂeelareen goorata odolaalkkani hitta taɂatateeran daase Iyyaasune wota eserraa aateen tabeen; kadaawute gees taageeronna esee gitte. ");
INSERT INTO bswl_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daawutena Waayi horee gaashana helatanoyi kayayik'ooba Hedo kakkogirro min goggomadaarroo ebaate; ");
INSERT INTO bswl_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ayesuun goɂameen kakkogirro min usuun kamadaarere Solomooniye. ");
INSERT INTO bswl_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«Halleewo kuwaarre dubbaankko t'ok'k'i kaɂame Waa gene taɂibaaddo kamadaarameroo min orroo lakkobaraaro; hikkina kahegerooti haa goggoɂamero maleeya; ");
INSERT INTO bswl_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","« ‹Daruur korffinjjekkeetta; ulnna luk'k'aɂootti mankkofoolssataranyan; Hayya misikki min isin iin madaarnnattaan? Amara Goottaa; Goorttun iin foolssi tallinnatta eetii banɂetta? ");
INSERT INTO bswl_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Hikka dubba tafelttetta lagenetteettolla?› ");
INSERT INTO bswl_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Isin wodanattisin okkoonduddettana! Nebebboɂoottisin; okkoonmaaloon! Odolaalkkisin aani Ayyaana K'ulluukki arggetto neebaattan. ");
INSERT INTO bswl_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kahegerool orrokko odolaalkkisin kahororoon giraan ayyoya kagira? K'ulluukkikotti emeeto t'ayeen oɂayyeeseraanna lagadattaan; isin gidda usu roorsseen sisseen; lagadeen. ");
INSERT INTO bswl_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Erggichchakokki garane isinuun kasisamero seera atatteettan kuwaarre lakkoɂooratteettan.» ");
INSERT INTO bswl_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tashonggoo haganaa gutii kagire ibaaddo hikka kakkomaalaren goorata aaloo amaraateen; ilkko k'aniinssateen keen. ");
INSERT INTO bswl_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ist'ifaanosa goɂameen Ayyaana K'ulluukki ammagamere daruur tos tichchisi godeero, kabaja tawaa usumaleenna, Yesuusa mergge tawaayi aallee giraan deegure, ");
INSERT INTO bswl_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","«Hikkima diyaa» «Daruur banattedde, ere kaɂibaaddo mergge tawaayi aallee giraan ani diyaara» ame. ");
INSERT INTO bswl_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Usu goorata taɂatii yaaye okkaa nebebboɂoottiso huc'c'isateen abateeren usu mankkogiro tos raattoo tiiyyeen; ");
INSERT INTO bswl_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Usu abeeren katamaakko sar beesen shafeen; eɂemoonna eeggano haggaɂabeen. Hikki kakkolaare goorata esee ogireen atojjoolnna sarssikkisoo Saawula kaɂamamare darggageessatikkonɂi luk'k'a hegelii kayeen. ");
INSERT INTO bswl_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ist'ifaanosana eɂemo eeggamaa giraan, «Gootta Yesuusa neefottee ata» ame ebaate. ");
INSERT INTO bswl_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Esekkona gilbbisegure yaaye taɂatiiyi, «Gootta! Hikka c'ubbo isoon arootootite» ame okkee; hikka ame abbaabatere goye. ");
INSERT INTO bswl_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saawulana goyi kaɂisit'ifanosaa isiɂaate gire. Ese arri Iyyerusaalemi kagire amaniilun kaɂatii horooramano kee; ofarameeraan kuwaarre amaniil dubba Yihuudaanna Samaaryakotti awuraajjaa dubbaa daraɂmeen. ");
INSERT INTO bswl_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Waa kaɂabssatare ibaaddona Ist'ifaanosa k'amale; adena aaloo usuun oote. ");
INSERT INTO bswl_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saawulana ade amaniil baasin muwaate kee; minkko min maraamuraa babbaarnna heleel giite beese minkashaano tabisaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Kadarɂamere ibaaddona takkoseete banɂe dubbaa haafura kawaa lallabee; ");
INSERT INTO bswl_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filp'oosana too tasamaarya katamaa tos dagere gara kakiristoosa lallabee. ");
INSERT INTO bswl_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Gosa kamoogganna Filp'oosa kaɂayeesero maalanna usu kafelero malataal diyaa, wodana too lee c'ak'asaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Battiikki Ayyaanalnna iyyaa kamooggan ibaaddokko bee; kamooggan naafaleesalinna kaɂeesarena fayyee; ");
INSERT INTO bswl_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Hikkakko kakkeeyi ese katamaatinna oɂatii geggeloo leen. ");
INSERT INTO bswl_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ayesuun goɂameen hittakko horene katamaati orroo moraa kasamaarya ibaaddo dubba kamamisere Simoona kaɂamamare ibaaddoti koo gire; usuna isiɂoottessa kaɂatii ibaaddo aani yelate tootaatare. ");
INSERT INTO bswl_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kic'c'ar kanjiin ibaaddo dubba, «Hikki ibaaddoti kaɂatii amame kaɂaddeesamero hunna kawaayya» amaa wodanakko usu maalaa gireen. ");
INSERT INTO bswl_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Goorata kamooggankko haggaɂabere felo omoruu ootteessayi mankkomamisare maraan kinttibii abeen usu debee sesseetaa gireen. ");
INSERT INTO bswl_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ayesuun goɂameen Filp'oosa gara kawaakokki wononnatina gara kayesuusa Kiristoosakokki mege kalallabeero wongala maalereen atatanooyi babbaarnna heleelnna t'ammak'ame; ");
INSERT INTO bswl_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simoonana metekkeessawun anhesonii, t'ammak'ame; usuna Filp'oosa debee seete; kafelamaro malaataalnna kaɂatii baasa deengureen saadeen. ");
INSERT INTO bswl_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Iyyerusaalemii ogireen ofarameeraan tasamaarya katamaakki ibaaddo haafura kawaa atatano kakkomaalareen goorata, p'et'iroosana Yaannisa iso tos fareen. ");
INSERT INTO bswl_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Isona tasamaarya katamaa kakkogiyaaren goorata Ayyaana K'ulluukki goggoɂatanaawun kasamaarya ibaaddoon ebaaten; ");
INSERT INTO bswl_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Aalanttina usu goorata kagootta Yesuusakokki megee t'ammak'ame gire kuwaarre ganaa Ayyaana K'ulluukki maayyo gutiinna lakkodagere. ");
INSERT INTO bswl_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Haanssun P'et'iroosana Yaannisa genettisoo gutii kayeen; isona Ayyaana K'ulluukki atateen. ");
INSERT INTO bswl_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simoonana ofarameeraan genettisoo amaniil gutii kakkokkareen goorata Ayyaana K'ulluukki isoon sisamano deegure maragade keenere, isone haa ame; ");
INSERT INTO bswl_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«Genettee ani gutii gokkaye ibaaddo dubba Ayyaana K'ulluukki goggoɂataroo hikka odonnati iinna sisa» ame. ");
INSERT INTO bswl_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","P'et'iroosana ade haa ame, «Ilabo kawaa maragadeeyi iminin k'oppitetta; atina maragadekkana raattoo baa! ");
INSERT INTO bswl_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wodanatta Waayi hore tukkultti mankkolaanawaatte maraan ati hikka handdaanoyi k'ooba goorttun it'aa lakkoɂabtto. ");
INSERT INTO bswl_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Giddanna hitta meellane iisidde c'ubbokko gula galigudde Goottaa tonssa ebaa; woddaasa wodanattaakki yaada haheso kaɂamamiro leera; ");
INSERT INTO bswl_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","aalanttina ati ataabee ammaganttedde kameellanee sanssalataayi kaɂabantetto ku ani deyaara.» ");
INSERT INTO bswl_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoonana abbaabere, «Isin kaɂayeessettan ayeeskko koonna in goggogeennonkko Goottaa iin ebaayen» ame. ");
INSERT INTO bswl_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","P'et'iroosana Yaannisa kagootta haafura atoteereenna addeesisen segeen abbaabateren, kamooggan kasamaarya maamanii wongala lallabaa Iyyerusaalemi abbaabateen. ");
INSERT INTO bswl_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kagootta erggichcha Filp'oosane, «Kingudde mina tahegeleenne taɂiyyerusaalemi katamaakko tagaaza katamaa tos kadagisaro k'alullattokki raanne see» ame. ");
INSERT INTO bswl_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Usuna keegure seete. Tatop'iyaa oori wono Henddeekke taɂamamatteen urrawoɂoottiseewunna durummatisee dubbaan odonnati kaɂabanaayekki katop'iyaa mureessati hele. Hikki ibaaddotina sagadin taɂiyyerusaalemi katamaa tos seete gire. ");
INSERT INTO bswl_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Usu ulkkeessa abbaabate seetaa giraan gongge tafaradii hamas's'eegure kahegeroo kaɂisiyaasa mas'aafa nabbabaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ayyaana K'ulluukkina Filp'oosane, «See; hassu farad tos gabbalami» ame. ");
INSERT INTO bswl_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filp'oosana saame usu farad tos seete; mureessati kahegeroo kaɂisiyaasa mas'aafa nabbabaa giraan maalere, «Ati kanabbabatto malabatta?» ame. ");
INSERT INTO bswl_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mureessatina, «Iin furi kasegira ibaaddo haginnooni misii addeesin daanddaara?» ame; usuna farad tos emetere wota goggohamas'iroon Filp'oosa ebaate. ");
INSERT INTO bswl_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Mureessatina nabbabaa tagire haafura kawaakkotti banɂe hittatta; «Usuna enɂaamin kawodamaro idaad aaniya; Ogorro goosaa giraan c'alɂi kaɂamaro idaad aani, Usuna ayeesin hiɂi lakkobanatere. ");
INSERT INTO bswl_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Isiɂootteessa yeraasate; karrummii firddana usuun lakkosiseen; Neefotteessana ulkko baatetta, Saannitteessa maraan ayyoyya ayeesin kadaanddaara?» ");
INSERT INTO bswl_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mureessatina abbaabe Flip'oosane, «Kahegerooti hikka kakkoonɂayeesera ayyo maraanye? Isiɂoottessa maraanya, muu ibaaddo kakkalee maraanya? Maganne iin segiina» ame. ");
INSERT INTO bswl_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filp'oosa ayeese; hikka mas'aafakko banɂe too haggaɂabere kayesuusa wongala lallabee. ");
INSERT INTO bswl_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Iso seetaa giranttii beke mankkogiraan banɂe geen, mureessatina, «Hinɂiman bekee hittanii giraaniwa; hayya goggot'ammak'amoonkko in kattirara meyya?» ame. ");
INSERT INTO bswl_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filp'oosana, «Duuddotti wodanaa goɂammantte t'ammak'amin daanddaatta» ame. Mureessatina, «Yesuusa Kiristoosa ere kawaa laano ani ammanara» ame abbaabe. ");
INSERT INTO bswl_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Farandda goggoɂaalliroo ajajee; esekkona lamaa beke tos seeteen; Filp'oosana mureessati t'ammak'ee. ");
INSERT INTO bswl_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Bekekko kakkobeyaaren goorata, kagootta Ayyaana goorsewa Filp'oosa aate; mureessatina esekko abbaabatere lakkodeero; golleenna geggelaataa sesseettan horeddee. ");
INSERT INTO bswl_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Esekko abbaabatere Filp'oosana Azoot'osi kaɂamamaro ulii mute; tak'isaarya katamaa taageeroo, katamaal dubba seetaa wongala lallabaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saawula ade Goottakko oɂagaalssataran lagadin manddaa tuuk'aamolkokki woyichchati tos seete. ");
INSERT INTO bswl_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Kagootta raadii osessetareen babbaarnna leere heleel esee gohello shiyegure Iyyerusaalemi tos ati seeyin goggodanddeero, Demaask'oo kagiro Ayihuudikokki min kaɂebijjoolun dabddaabbee goggosisirawun tuuk'aamolkokki woyichchati ebaate. ");
INSERT INTO bswl_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Demaask'oo tos gin gabbalamaa giraan ifana daruurkko derɂa usu maraamure hank'k'aye. ");
INSERT INTO bswl_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Usuna ulii iyye; hassu goorata «Saawula; Saawula; mewuun in horooratta?» taɂamatto yaaye maale. ");
INSERT INTO bswl_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saawulana, «Goottakki, ati ayyotta?» ame. Usuna haa ame, «Aninna ati kahorooratto ani Yesuusaya. ");
INSERT INTO bswl_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Gidda kingudde katamaa tos tabi; ati felin kadootisara esee kuun ani segaamirowa» ame. ");
INSERT INTO bswl_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saawulane wota sesseetaa ogireen ibaaddojja yaayetisoo maalana kuwaarre, maayyona diyaanawaattikko kakkeeyi, iso hiɂittisoo abateen aalleen. ");
INSERT INTO bswl_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saawulana ulii mankkoɂiyyerekko keegure ilɂoo koonna din lakkodaanddee; haanssun ibaaddojja genetteessa abeen geggesaa Demaask'o geegiseen. ");
INSERT INTO bswl_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Arri seendda ilɂoo baye; babona bekena hiɂi lakkoɂabe. ");
INSERT INTO bswl_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Demaask'oo Hanaaniya kaɂamamare koo Yesuusakko kaɂagaalssatare gire; Goottaa raagayi, «Hanaaniya!» ame uume. Usuna «Yee Goottakkee;» ame. ");
INSERT INTO bswl_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Goottanna, «Kingudde tukkulkki raa kaɂamamaro raadii Yihuuda kaɂamamero ibaaddotikokki min see; eseenna Saawula kaɂamamara koo ul kat'erssesikki ibaaddoti Waa ebaataa gira dooti ame. ");
INSERT INTO bswl_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ayesuun goɂameen Hanaaniya kaɂamamare ibaaddoti usu mankkogiro tabre genetteessa usuu gutii kakkayinarona ilɂoɂootteessa banamano Saawula raagayi dee.» ");
INSERT INTO bswl_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Hanaaniya abbaabere, «Goottakkee;» «hikki ibaaddoti Iyyerusaalemi kagiro amaniil gutii eeggitatti miirɂa geegisero ibaaddo kamooggankko ani maalera; ");
INSERT INTO bswl_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Hittarranna kakkoonɂemeetera megekkaa oɂuumataraan dubba shiin katuuk'aamol woyichchaalkko odonnati atatereya» ame. ");
INSERT INTO bswl_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Goottanna, «See; hikki ibaaddoti Ayizaablnna wonolaal hore usumaleenna kaɂisiraɂeel gosa horee megekkee goggoɂaddeesisiroo ani kaɂassaabayero huukkeya; ");
INSERT INTO bswl_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Aninna megekkee maraan eeggitatti rakkoo atayin dootisaro ani usuun tusinara» ame. ");
INSERT INTO bswl_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hanaaniya seetegure, usuun kasegaamero min tabe; Saawula gutii genennoɂootteessa kayere, «Abbikkee Saawula, ati hittarraa emeetaa giraan raadii kuun kamutere Goottaa Yesuusa ilɂoɂootta goggodeenddenawunna, Ayyaana K'ulluukki goggoɂammaganttoo in ku tos farera» ame. ");
INSERT INTO bswl_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Goorsewa iɂo osaawolakko honk'ofi aankkikki kooko iyye; abbaabate diinna daanddee; keenna t'ammak'ame. ");
INSERT INTO bswl_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Babona aamegure ataate. Saawula Demaask'oo ogireen amaniilnne wota arri uc'c'ar adallaate. ");
INSERT INTO bswl_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Goorsewa Saawula Yesuusa ere kawaa laano Ayihuudikokki min kaɂebijjoolii lallabaano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kamaalera dubbana mamaa, hikki ibaaddoti «Iyyerusaalemi hikka mege kaɂuumaro dubba kabaasare lakkoyoya? Adena hittarraa kakkoonɂemeetera iso shiire tuuk'aamokokki woyichchaal tos geesin lakkoyoya?» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saawula goɂameen ataataa seete; Demaask'oo ogiraan Ayihuudin Yesuusa usu Kiristoosa laano ato sisaa hiɂi abssisaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Arri tanjiinkko abbaabatere, Ayihuudi Saawula lagadin t'oye; ");
INSERT INTO bswl_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","usu goɂameen halchchakkisoo addeese; isona usu lagadin kakkatamaa karraa oora gireen; ");
INSERT INTO bswl_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","usu debee osesseetareen goɂameen hemeen emeeteren takatamaa tagimbbe alikkotti maskotinne daachchooyi usu dagiseen. ");
INSERT INTO bswl_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saawula Iyyerusaalemi katamaa tos kokkoɂemetere goorata, amaniilnne wota lelledamiin hede; iso goɂameen rumminaa Waa kaɂammanaro laano mankkoɂabddatana waateen maraan dubbana abssateen. ");
INSERT INTO bswl_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Halleewo kuwaarre Barnnabaasi Saawula ofarameeraan tos geesere; Saawula seeto gutii giraan Goottaa misii deerona Goottaa usuun misii ayeeseroo usumaleenna, Demaask'ooyi mege kayesuusaa misii jabuuyi lallabeero isoon segee. ");
INSERT INTO bswl_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Haanssun Saawula iso wota hamas's'ee; Iyyerusaalemii maraamurara mege kagoottayi jabuuyi ayeesaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Heɂi tagiriikki kaɂayeesare Ayihuudi wota ayeesaanna dogamaa gire; iso goɂameen usu lagadin dootaa gireen. ");
INSERT INTO bswl_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Amaniilnna hikka kokkoɂaddeesareen goorata; K'isaariya tos dagiseeren T'ersesi tos usu fareen. ");
INSERT INTO bswl_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Usu goorata Yihuudaa, Galiilayinna Samaariyayi kagira amaniil dubba nogoddaa girano haggaɂabe; ataate. Adena Waa abssataa sesseetanna Ayyaana K'ulluukkii goggoɂaa tootooyina jiinataa seete. ");
INSERT INTO bswl_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","P'et'iroosana ulkko ul maraamuraa kakkogire goorata, ul kaliidatti katamaayi kagire amaniil din dage. ");
INSERT INTO bswl_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Eseenna eeniya kaɂamamare, geesii siddeedun alggaayi shiile kagire naafaleesakki ibaaddoti koo hele. ");
INSERT INTO bswl_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","P'et'iroosana, «Eeniya!» «Yesuusa Kiristoosa ku fayyisirowa; kingudde alggaattaa keesa» ame. Eeniyanna saame fit'a ame kee. ");
INSERT INTO bswl_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Taliida katamaayinna Saaronayi ogireen dubba usu deengureen Goottaayi ammaneen. ");
INSERT INTO bswl_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Taɂiyoop'e katamaayi T'aabta taɂamamatte Waa taɂammanatte heleettiti too gitte; heɂi tagirikkiinna «Dork'k'a» amano golleero fureenna «Siik'ee» amanoya. Esena arggetto felo oɂidan felaanna hiyyeessal gargaaraa gitte. ");
INSERT INTO bswl_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Usu gooratana ese hawɂaantte goote, ibaaddona reesikkise aalisere guuntte taggitto kifilii kayeen. ");
INSERT INTO bswl_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Taliida katamaa ul kaɂiyoop'en enee mankkogitte maraan amaniil P'et'iroosa katamaa taliidaa girano kakkomaalare goorata, ibaaddo lama handdaa fareengureen, «Maganne no tos saami koyya» ameen ebaaten. ");
INSERT INTO bswl_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","P'et'iroosana keegure iso wota seete; eserraanna kakkogiyaare goorata guuntte tagitto kifilii tos geesen. Galttaanttejjool dubba dork'k'a isone wota takkogittee, kafelttetto k'amisijolnna huujjol tuttusaa maraamureen ootaa gireen. ");
INSERT INTO bswl_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","P'et'iroosana dubba kifiliikko beesegure gilbbise ebaate, rees tos abbaabategure, «T'aabta! Ki!» ame. Esena ilɂoɂoottisee banatte; p'et'iroosana kakkodeyaatte goorata t'ok'k'iɂantte hamas's'iite. ");
INSERT INTO bswl_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Usuna genettisee abe keese; Waa oɂammanaraan galttaanttejjool uumegure neefone tagitto isoon abbaabe sise. ");
INSERT INTO bswl_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Hikki ayeesna Iyop'e dubbaa maalssame; kamooggan ibaaddona Goottaayi ammane. ");
INSERT INTO bswl_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","P'et'iroosana Simoona kaɂamamare koo galbba kahok'ook'arene wota Iyop'e arri tanjjiin hamas's'ee. ");
INSERT INTO bswl_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","K'isaariyayi kagire, It'aliyawuun taɂolamatto unakokki kabooloo woyichcha kalleera K'ornoloosa kaɂamamare ibaaddoti koo gire. ");
INSERT INTO bswl_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Usuna kaminee ibaaddokkeessa dubbane wota felo oɂayyaanayi kaɂataatarena Waa kaɂabssatare ibaaddotiyye; hiyyeessan kooko kasisarena arggetto Waa kaɂebaatareye. ");
INSERT INTO bswl_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Arri too, arriikko saatii saagalkokki gita erggichchati kawaa raagayi usu tos emetere, «K'ornoloosa!» amaa giraan tachchaa usuun mute. ");
INSERT INTO bswl_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","K'ornoloosana neeminne wota tichchise diyaagiraan «Gootta; meyya?» ame. Erggichchatina haa ame; «Ebina hiyyeessan ati kasisatta kookokka shaadamano lee Waa tos geera. ");
INSERT INTO bswl_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Giddanna ibaaddo Iyoop'e tos farigudde P'et'iroosa kaɂamamare Simoona keensisi; ");
INSERT INTO bswl_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Usuna labu girii kagiro galbba kahok'ook'aro min kasimoonaa marttinaa hamas's'eera.» ");
INSERT INTO bswl_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","K'ornoloosana, kaɂayeesisera erggichchati usukko kale bee kakkoseetare goorata, usuun ohandaareenkko lama, usumaleenna kaɂayyaana ayeesii kaɂataaterona usuun kaɂabddame kalleero wotaadarati koo uumsisere; ");
INSERT INTO bswl_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","kalleero ayees dubba segee abbaabatere Iyoop'e tos iso fare. ");
INSERT INTO bswl_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kafaramere ibaaddona tallami arri katamaati tos goggogabalameni, P'et'iroosa arrii asasa kakkollaare goorata, ebaayin guuntte kagiro fook'ii bee. ");
INSERT INTO bswl_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Hassu goorata P'et'iroosa mankkoɂuɂeere maraan, kaɂaamiro kooko dootate; babo ekkaataa giraan usu salallisere raaga dee; ");
INSERT INTO bswl_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Daruurnna banattedde too tanjiintti hoc'c'o aani kallaara mina afarinne abamere ulii dagaa giraan dee. ");
INSERT INTO bswl_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Hoc'c'o gutii luk'k'a afar kaɂabo kalekaleekki sulaale, ulii tagiitamatto met't'ana kabuubare kimbirjol gire. ");
INSERT INTO bswl_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Usu goorata, «P'et'iroosa! Ki; hinɂa enɂaa aami» taɂamatta yaaye usuun maalssantte. ");
INSERT INTO bswl_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","P'et'iroosana ade, «Goottakkee; hikki haa liin lakkodaanddaaro; ani k'ulluukki kalleenon goorttun battiikki ijjii aame laakkaso» ame. ");
INSERT INTO bswl_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Hasse yaaye ade kallami usuun maalssantteedde, «Waa kamuc'c'isero ati battiikki aani arootootite» ame. ");
INSERT INTO bswl_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Hikkina usuun seed gale segaame; hoc'c'ona goorsewa daruurii tos atantte. ");
INSERT INTO bswl_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","P'et'iroosana taddeero raagakotti fureenun aaloo c'annak'aamere ele hegel hedaa giraan, K'ornoloosa ofarere ibaaddojja min kasimoona dooteen kakkohelareen goorata ufa dollee aalleen; ");
INSERT INTO bswl_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Yaayettisona t'ok'k'iseenguren, P'et'iroosa kaɂamamare Simoona esee girano hoosaten. ");
INSERT INTO bswl_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","P'et'iroosa karaaga gara ele hegel hedaa giraan, Ayyaana K'ulluukki usuun haa ame; «Hinɂima; ibaaddojja seeddo ku dootaraan; ");
INSERT INTO bswl_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Haanssun kingudde dagi; iso kafarerana ani mankkollee maraan anhedannoonii isone wota see.» ");
INSERT INTO bswl_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","P'et'iroosana dagegure; «Hikkima; isin kadootattaan ibaaddoti aniyya; hayya isin takkonɂemetteettan haajaa metta?» ame. ");
INSERT INTO bswl_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ibaaddojjana; «Noo kakkoonɂemeennenna K'ornoloosa kaɂamamare kabooloo woyichchati dollekkoya; usuna k'ulluukkina Waa kaɂabssataro, gosa kaɂayihuudi dubba dollee kakkabajaame ibaaddotiya. Ku min tos goggokeenonna ati kaɂamatto goggomaallo k'ulluukki erggichcha usuun segeera» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","P'et'iroosana ibaaddo marttisayin minkkeessa tabssate. P'et'iroosa tallami arri keegure iso wota seete; ul kaɂiyop'ekko taɂemettette abbilaal toottoonna usune wota seette; ");
INSERT INTO bswl_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Arri tallamii tak'isaarya katamaa tabeen. K'ornoloosana fallikkeessana saatilaaltteessa kukkuyisere P'et'iroosas oora gire. ");
INSERT INTO bswl_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","P'et'iroosa min kakkotabare goorata K'ornoloosa usu k'op'ate; luk'k'aɂoottessaa gutii iyyere sagade. ");
INSERT INTO bswl_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","P'et'iroosa goɂameen, «Aninna ku aankikki ibaaddoya» «Ki aallii!» ame keese. ");
INSERT INTO bswl_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","P'et'iroosa ayeesisaa usune wota gotabro ibaaddo kamooggan kukkume giraan dee; ");
INSERT INTO bswl_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","haa ame; «Ayihuuditi koo takkalee una wota goggolleeroo goggogabalamiroo seerakkaani feɂi kasisoon laano isinwa kassaan; ayesuun goɂameen ani maayyona battiikki goorttun k'ulluukki kalleenonya ani goggoɂamoonkko Waa iin tusera; ");
INSERT INTO bswl_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Haanssun ani kokkoɂuumamere goorata, anhedannoonii emeeyera; goortta, mewuun isin in uumtteettaan addeesin dootara» ame. ");
INSERT INTO bswl_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","K'ornoloosana haa ame; «Arri afarkko horeene hikka goorata arriikko saatii saagallii minkkeeyi hamas's'eere Waa ebaataa gire; derɂana kahank'k'aaro sarssi kasarsatera ibaaddoti koo in horee aalleegure, ");
INSERT INTO bswl_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Iinne haa ame ‹K'ornoloosa! Ebikka malssamera; Waawun kasisatto shaadamanoon Waa tos geera. ");
INSERT INTO bswl_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ibaaddo ul kaɂiyop'e tos farigudde P'et'iroosa kaɂamamero Simoona keensisi; usuna labu giridii kagiro galbba kahok'ook'aro kasimoona minii marttinaa hamas's'eera.› ");
INSERT INTO bswl_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Aninna goorsewa handdaa ogeegisareen ku tos fare; atina emetanooyi taɂidan felttetta. Goortta no dubbana Goottaa ku kaɂajajeero ati noon gosegiite maalin Waayi horee ginna.» ");
INSERT INTO bswl_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","P'et'iroosana haa amaa ayeesano haggaɂabe; «Waa maayyoonna kaɂululisoon laano rumminaa ani addeesera; ");
INSERT INTO bswl_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ayesuun goɂameen Waa usu oɂabssataraawunna k'ullummaa ofelaraan dubba maaɂeeti unakko goleenna atatara. ");
INSERT INTO bswl_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Kadubbaa Goottaa kalleero Yesuusa Kiristoosaa nogodda lallabaa hikka haafura yiis kaɂisiraɂeel tos fare. ");
INSERT INTO bswl_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yaannisa kalallabeero t'ink'atakko abbaabatere ul kagalilakko haggaɂabere Yihuuda dubbaa kalleero isin kassaanwa; ");
INSERT INTO bswl_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Waa kanaazireti Yesuusa Ayyaana K'ulluukkiyinna hunnaa shigidde; usuna Waa usune wota mankkogire maraan mankkogee dubbaa taɂidan felaa kaddurrisa odonnatii hegelii ogireen dubba fayyiise. ");
INSERT INTO bswl_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«Usuna kaɂayihuudi uliinna Iyyerusaalemii kafeleroon noo atonna; adena ibaaddo gaa gutii usu suye lagade. ");
INSERT INTO bswl_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Waa goɂameen taseedi arrii goyikko usu keese; ibaaddon goggomutiroonna yele; ");
INSERT INTO bswl_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Usu kakkomuterana ibaaddo dubbaan anlleennon giraan goyikko kee abbaabatere no usune wota oɂaaminnennona ot'aminnenoon, Waanna t'aye oɂassaabatero usuun ato olleenenno noyeniya. ");
INSERT INTO bswl_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Gosaawun goggolallabinnoonna arddonɂinna ogoyeraan gutii goggofirddiroon Waa kashuumera Yesuusa laano goggoɂatotinnoon usu no ajajeera; ");
INSERT INTO bswl_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Usuu kaɂammanara dubba megekkeessayi c'ubbokkokki shaaga goggohelaroon kahegerool dubba usuun atotaara.» ");
INSERT INTO bswl_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","P'et'iroosa hikka ayeesaa giraan, haafurakkeessa omaaleeraan dubbaa gutii Ayyaana K'ulluukki dage. ");
INSERT INTO bswl_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","P'et'iroosane wota kaɂemeetere, kahamas'iisamero unakko kalleere amaniil, Ayyaana K'ulluukikkokki ilabool Ayizaab gutii dagano kakkodeyaare goorata mame. ");
INSERT INTO bswl_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Aalanttina heɂi taɂusubii ayeesaa giraanna Waa galataa giraan mankkomaaleen maraanya. Usu goorata P'et'iroosa haa ame; ");
INSERT INTO bswl_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Hinɂi ibaaddojja no aani Ayyaana K'ulluukki mankkoɂatateeran maraan goortta bekee goggot'ammak'amoonkko kattirra ayyoyya?» ");
INSERT INTO bswl_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Haanssun kayesuusa Kiristoosakokki megee goggot'ammak'amnawun ajajee. Esekko abbaabateren ot'ammak'ameerenna P'et'iroosa arri wuc'c'ar isone wota goggohamas'iroon ebaaten. ");
INSERT INTO bswl_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ofarameeraanna Yihuudaayi kagire amaniil, Ayizaab ade haafura kawaa atatano maaleen. ");
INSERT INTO bswl_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Haanssun P'et'iroosa Iyyerusaalemi tos kakkoseeteree, tahamas'isanttetto una olleeren usu tuffateen; ");
INSERT INTO bswl_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«Muun kahamas'iisamoon giro ibaaddo tos tabttedde isone wota aantte ameen usu wok'aseen.» ");
INSERT INTO bswl_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","P'et'iroosa ade isone haa ame ayees raaraadii addeesisano haggaɂabe; ");
INSERT INTO bswl_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Ani taɂiyoop'e katamaayi ebaataa giraan salallisere raaga dee; tanjiintti hoc'c'o aani kallaara kooko mina afarnne iinsse abatere daruurkko ani takkogiro banɂene dagaa giraan dee. ");
INSERT INTO bswl_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ani tichchisi hikka maammes kakkodeero goorata luk'k'a afar kaɂaba, sulaale kagaadoo, ulii tagiitamatto met't'aajjolnna kabuubaro kimbirjol dee. ");
INSERT INTO bswl_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Hassu goorata, inne ‹P'et'iroosa! Kingudde enɂaa aami› taɂamatto yaaye ani maale. ");
INSERT INTO bswl_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","«Aninna, ‹Goottakkee! Hikki haa liin lakkodaanddaaro ani battiikki goorttun k'ulluukki kalleenon giro kooko ijjii hiɂiitteeyi ani abe laakkaso› ame. ");
INSERT INTO bswl_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","«Hasse yaayena kallami, ‹Waa kamuc'c'isero ati battiikki aani arootootite› amaa daruurkko iin maalssantte. ");
INSERT INTO bswl_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Hikkina seed gale iin mute; esekko dubbana ade daruur tos atame. ");
INSERT INTO bswl_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","«Goorsewa, ibaaddojja seeddo K'isaariyakko in tos farameen emetengureen ani kakkogiro minii gooc'aa aalleen; ");
INSERT INTO bswl_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ayyaana K'ulluukkina koonna haggatola anlleennon ani isone wota goggoseero segee. Hitti abbilaal lewo inne wota seette; min kak'oronolewosana tabnne. ");
INSERT INTO bswl_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Usuna erggichchati minkkeessa orroo aallee kamuterona usuun kaɂamero noon segee; ‹Ul kaɂiyoop'e tos ibaaddo faridde P'et'iroosa kaɂamamero Simoona uumsisi; ");
INSERT INTO bswl_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Usuna atina minkaakki ibaaddo dubba kakkofayyitaan haafura kuun segirowa› usu kaɂamero noon segee. ");
INSERT INTO bswl_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","«Aninna ganaa ayeesano haggaɂabaa giraan, Ayyaana K'ulluukki, horaarjje no gutii goggodageree iso gutiinna dage. ");
INSERT INTO bswl_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Usu goorata, ‹Yaannisa bekee t'ammak'e; isin addeene Ayyaana K'ulluukki t'ammak'anttaawa› ame Goottaa kaɂayeesera haafura k'alli ame iin shaadame. ");
INSERT INTO bswl_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Goortta Waa Goottaa Yesuusa Kiristoosakokki garane no arooɂammannenne noon kasisero ilabo isoonna gosise, hayya, Waa neebaayin ani ayyoyya?» ");
INSERT INTO bswl_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Isona hikka kakkomaalareen goorata taɂamraan waatereene, «Hikki haa gollee, Ayizaabna giri tos goggoɂemeeroon, Waa c'ubbokko gula galano isoon sisera amanoyolla» amaa Waa galateen. ");
INSERT INTO bswl_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Isit'ifaanosa eɂemoo eegame takkogoyeree kakkeero horooramanokkotti aalanttii kadarɂaamera amaniil haafura kawaa Ayihuudi kaalaalun sessegaa Fink'k'ekkona, K'op'iroosakko taa Ans'ookiya geraawun seeteen. ");
INSERT INTO bswl_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","K'op'iroosikkona, K'ereenakko ibaaddo kookkoo ade Ans'ookiya tos seetereen tagiriikki heɂii kaɂayeesare ibaaddone adere haafura kawaa sessegaa kagootta Yesuusa wongala isoon lallabeen. ");
INSERT INTO bswl_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Hunna kawaanna isone wota gire; tootooyinna aaloo onjiin kalleere ibaaddo ammanere Goottaa tos emeete. ");
INSERT INTO bswl_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Oduna Iyyerusaalemi kagiro amaniilun geete; amaniilnna Barnnabaasi Ans'ookiya tos fare. ");
INSERT INTO bswl_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barnnabaasina eserraa geere Waa sinotteessaa kafelero kakkodeyaare goorata geggelaate; dubbana duuddotti wodanaa Goottaayi ataayi goggogirraawun iso gorssee. ");
INSERT INTO bswl_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Usuna Ayyaana K'ulluukkina ammanoo kaɂammagame kaɂidankki ibaaddotiye; tootooyi kamooggan kalleere gosana Goottaa tos emeete. ");
INSERT INTO bswl_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Esekko abbaabatere Barnnabaasi, Saawula dootiin T'ersesi tos seete; ");
INSERT INTO bswl_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kakkohelare goorata Anis'ookkiya tos aate emeete. Iso lama dubbana esee kagiro amaniilne wota leene gees koo muume aaloo kamooggan gosa agaalssiseen; Yesuusakko oɂagaalssatareenna horaarjje Ans'ookiyaayi «Amaniil» amameen uumameen. ");
INSERT INTO bswl_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Usu goorata kookkoo kahegerool Iyyerusaalemikko taɂans's'ookiya katamaa tos dageen; ");
INSERT INTO bswl_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Isokkona koo Agaaboosa kaɂamamare keegure alami dubbaa gutii kaɂatii uɂi kallinnaro Ayyaana K'ulluukkikokki kekkeesanooyi ayeese; hikkina karoomi wono K'elaawudoosakokki geesii gudate. ");
INSERT INTO bswl_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Amaniil mete metekkisooyi hunnakisookki jilbbaa maragade beeseren Yihuudaayi kagiro amaniil gargaarin hiɂi too leen; ");
INSERT INTO bswl_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","gargaarssana gene tabarinnabaasinna tasaawulaa min kawaakotti jaarsoleewun faranoyi, hikkawa feleen. ");
INSERT INTO bswl_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Usu geesii wono Herodoosa kookkoo min kawaakokki maganaal horooraanna c'annak'isaa gire; ");
INSERT INTO bswl_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Abbi kayaannisa Yayik'ooba shiifayi lagadississe. ");
INSERT INTO bswl_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Hinɂa feloɂoottessana Ayihuudi geggelaayisano kakkodiyaare goorata, P'et'iroosa ade absise; hikkina kakkoleera Ayihuudi babo aamaa kakkabajjare baalaye. ");
INSERT INTO bswl_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","P'et'iroosa minkashaano kakkotabisareen goorata wotaadaral afar afar liireen goggoɂoorrawun jigi afarruun kakkaamero wotaadaralun sise; hikkana kakkoonyelera kafaasikkaa baala kakkoroorare goorata gosa horee beesire murtteesiin hedereya. ");
INSERT INTO bswl_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","P'et'iroosana usumalee minkashaano tabe; amaniil ade usu maraan aaloo Waa tos ebaataa gire. ");
INSERT INTO bswl_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herodoosa P'et'iroosa gosa horee aalliisin hede giraan, p'et'iroosa ese hemeen sanssalata lamaa shaamere wotaadara lama t'eɂe huddure gire; minkashaano oɂooraran minkashaanokki gooc'aa aalleen gireen. ");
INSERT INTO bswl_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kagootta erggichchati derɂa isoon mute, kifilii orroonna ifa hank'k'aye; erggichchatina tap'et'iroosa aaranjja dine nabbaadisere, «Saami ki!» ame; usu goorata sanssalataal genetteessakko furame iyye. ");
INSERT INTO bswl_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Erggichchana, «Sarssikkaa sarssa; keferroɂoottana tabssa» ame. P'et'iroosana usuun goggosegame yele. Erggichchatina horeddeere, «Sarssi gutii kootii sarssadde indebee sessee» ame. ");
INSERT INTO bswl_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","P'et'iroosana debee sesseetaa min kashaanokko bee; ayesuun goɂameen usuun raaga kadiyaaro aani laare kuwaarre erggichcha kafelare ayees rummi laano lakkoɂaddeesere. ");
INSERT INTO bswl_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Kahoreenna kallami minkashaano kaɂoorare ibaaddokko roorere katamaa tos kageesaro raadine kagiro kamarc'c'oo ufa tos gee. Ufa issii isoon baname; isona been seeteen; t'urrekki raa koonne goggorooreni goorsewa erggichcha usukko kale bee. ");
INSERT INTO bswl_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","P'et'iroosaan wodana kakkoɂabbaabatte goorata, «Gootta erggichcha faregure gene taherodoosakkona Ayihuudi usu gutii kahedeeren dubbakko in beesano gidda ani hedatano kallayi addeesera» ame. ");
INSERT INTO bswl_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Hikka addeese abbaabatere, ibaaddo kamooggan kukkuɂamere raattoo Waa mankkoɂebaataree, Mark'oosa kaɂamamare Yaannisakotti Aaye kamayiraame min seette. ");
INSERT INTO bswl_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Eserraanna geegure kasaree karra kakkobabbasare goorata, Roodda taɂamamatte too minii tafelatte maayyoyo addeesin ufa tos seette. ");
INSERT INTO bswl_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Tap'et'iroosa yaaye laano kakkoɂaddeesatte goorata, aaloo geggelaatanokko kakkeeyi ufa habanooni tiite abbaabattedde, «P'et'iroosa ufa dollee aalli girano segiite.» ");
INSERT INTO bswl_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ibaaddona, «Te k'olanttetta!» ameen, ese adde hikka abbaabitte abbaabitte kakkosegaatte goorata, «Goortta hikki erggichchakkeessaya» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","P'et'iroosa ade ufa babbasano horeddee, iso adeen ufa baneen deengureen mameen. ");
INSERT INTO bswl_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Usuna iso c'alɂi goggoɂaminaawun genee malaata tusere, Goottanna usu min kashaanokko misii usu beesero isoon segee, «Kalleero ayeeskkokki garana Yayik'oobana kakkalee amaniluun segaa» ame; esekkona banɂettakkalee iise seete. ");
INSERT INTO bswl_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Tallami arri bari watadaraal, «P'et'iroosa hagge tabe?» amaa hittarraa hasserraa tiittaano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodoosana P'et'iroosa dootise kakkowaatare goorata minkashaano oɂooraneen aaloo k'ok'k'ore abbaabatere iso goggogoorawun ajajee. Esekkona Herodoosa Yihuudakko K'isaariya tos dagere esee hamas's'ee. ");
INSERT INTO bswl_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodoosa kat'iroosina kasidoona ibaaddone wota iinsseɂinggaame gire; ulkkisona babo kakkohelatareen k'alaada kawonokko mankkollee maraan, wonoon kahandaare kabilasit'oosa gargaarssa kakkohelatareen goorata raattoo leereen wononne wota wogarin hoosaten. ");
INSERT INTO bswl_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tak'at'aroo arrii Herodoosa kawono sarssi sarssate korffinjje gutii hamas's'eere gosaan ayeese. ");
INSERT INTO bswl_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Gosana, «Hitti yaaye tahedotta kuwaarre taɂibaaddo lakkotto!» ame okkee. ");
INSERT INTO bswl_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herodoosana Waawun kabaja sisana mankkowaatemaraan kagootta erggichcha goorsewa hawɂaami kameellan usuun lugude; hiskkiinna aamame goye. ");
INSERT INTO bswl_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Haafura kawaa ade jiinataanna balɂaataa seete. ");
INSERT INTO bswl_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnnabaasina Saawula handdaakkisoo gussateereen Iyyerusaalemikko abbaabataa giraan Mark'oosa kaɂamamare Yaannisa isone wota aateen emeeten. ");
INSERT INTO bswl_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ans'ookiyaayi kagiro min kawaayi ohegeroolnna oɂagaalssisareen gireen; isona, Barnnabaasi, gambballakki ibaaddoti kaɂamamare Simoona, kak'eerenna Lukkiwoosa, mooti kalleero Herodoosane wota kajiinatere Minahenna Saawula gireen. ");
INSERT INTO bswl_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Hinɂina Goottaa hedoyisatanna agabuwaa giraan, Ayyaana K'ulluukki, «Barnnabaasina Saawula ani okkoonɂuumero feloon iso iin kale beesa» ame. ");
INSERT INTO bswl_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Isona agabuuyen ebaatengureen genetisoo iso gutii kayeen ebaaten iso fareen. ");
INSERT INTO bswl_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnnabaasina Saawula Ayyaana K'ulluukki farameene Selewuk'iya dageen; esekkona wolaboo tak'op'iroosa oddola tos seeteen. ");
INSERT INTO bswl_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Silamisi katamaa tos kakkogiyaaren goorata Ayihuudikokki min kaɂebii haafura kawaanna lallabeen; Yaannisana isone wota leere gargaaraa gire. ");
INSERT INTO bswl_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tak'op'iroosa oddola k'amakko taak'ama geeranun goosen tap'aafa katamaa kakkogiyaare goorata, Beryesuus kaɂamamare Ayihuuditi koo kamorarena kat'araa hegerooti heleen; ");
INSERT INTO bswl_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Usuna Sergiyoosa P'awuloosa kaɂamamare wodanaamena ul kabariisare mootinne wota gire. Hikki ul kabariisare mootitinna, haafura kawaa maalin dootere Barnnabaasina Saawula uumsise. ");
INSERT INTO bswl_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Heɂi tagirikkii Elmmaasa amame kaɂuumamare moruuti Baryesuus ade, ul kabariisare mootiti goggoɂammanoonkko handdudufisiin mankkodootere maraan iso neebaate. ");
INSERT INTO bswl_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","P'awuloosa kaɂamamare Saawula Ayyaana K'ulluukkii ammagamere, tichchise ibaaddoti deegure haa ame; ");
INSERT INTO bswl_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«Ati k'ullumma dubbakokki diina, miiggena meellane dubba kakkoɂammaganttetta kaddurrisa ere! Kagootta tukkulkki raa woc'ac'aanakko lakkoɂabbaabattoya? ");
INSERT INTO bswl_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Giddanna tagootta gene ku bassowa; jaama linnatta; goortta kaɂaritii ifa goorata kic'c'aruun suure ati lakkodinnatto.» Goorsewa iyyoottena mugud usu gutii dage; gene abi kageggeyisiro ibaaddona dootataa hittarraa hasserraa amano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ul kabariisare mootitinna kalleero ayees kakkodeyaare goorata, agaalssisano kagoottaa saadaa Waa ammane. ");
INSERT INTO bswl_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","P'awuloosa saatilaaltteessane wota P'afakko wolabooyi keengureen, P'infiliya tagitto tap'erggeen katamaa tos seeteen; Mark'oosa kaɂamamare Yaannisana isokko kalebeere Iyyerusaalemi tos abbaabate seete. ");
INSERT INTO bswl_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Iso adeen tap'erggeeni katamaakko keengureen P'isidiya orroo tagitto Ans'ookiya tos seeteen; tafoolssii arrina Ayihuudikokki min kaɂebi tabeerene hamas's'een. ");
INSERT INTO bswl_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kaseerana kahegerool mas'aafajjol nabbabame kakkoɂabbaabatare goorata, kaɂayihuudi min kaɂebikokki woyichchaal, «Abbilaalttee; gosa kakkogorssitaan haafura goɂabttaan ayeesaa» ameen P'awuloosaas tos handdaa fareen. ");
INSERT INTO bswl_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","P'awuloosana keegure genee malaataa haa ame; «Isin kaɂisiraɂeel ibaaddo; adena isin Waa oɂabssaattaan Ayizaab dubba c'ak'asa. ");
INSERT INTO bswl_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Hikka kaɂisiraɂeel gosakokki Hedo odolaalkkani assaabe; kagibs's'i ulii giraan gosa kaɂatii yele; kaɂatii hunnakkeessaanna esekko iso beese. ");
INSERT INTO bswl_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Gees afarttamuun k'alullattokki ulii iso obssee; ");
INSERT INTO bswl_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ul kakkeneɂaanii kagire aaniil todoba baasere, ulkkisoo gosakkeessawun rittii yele iso eelise. ");
INSERT INTO bswl_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Hikki dubbana kakkogudatera gees 450 orrooya. «Esekko abbaabatere kahegeroo Saamelakokki gees taageeroo ul tabariisso daannolee isoon sise. ");
INSERT INTO bswl_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Esekkona kaɂisiraɂeel gosa wono isoon goggosisamiroon hoosaten; Waanna tabiinami unakko kak'iisi ere Saaɂola isoon sise; usuna gees afarttam bariise. ");
INSERT INTO bswl_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Saaɂola wononnatikko dagisegure, Daawute isoon reedise; Waanna garakkeessa, «Wodanattee aani kalleerona ani kadootataro dubba iin kafelaro kaɂisseyi ere Daawute helaye ame gara kadaawute atotee.» ");
INSERT INTO bswl_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","«Waa otabeero ammattokki haafura malee hikka ibaaddotikotti sanniikko kafayyisaro Yesuusa gosa kaɂisiraɂeeliin keese. ");
INSERT INTO bswl_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesuusa emeetanokko horene, Yaannisa kaɂisiraɂeel gosa dubba c'ubbokko gula galire goggot'ammak'amiroon lallabaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yaannisa fareentteessa gussataa giraan, ‹Isin in ayyoyya antteen k'oppaattan? Ani lakkoɂusuyo; ayesuun goɂameen luk'k'aɂoottessanɂi keferrokokki shaano ani furin kadaanddeenon inkko haarre emeeyinara› amaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Isin abbilaaltti; Abraamekko oɂumulanttettaan, addeene Waa oɂabssaattaan dubba hikki kafayyinna handdaa kakkonfaramera no dubbaanya. ");
INSERT INTO bswl_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Iyyerusaalemi kagire ibaaddona woyichchaalkiso Yesuusana, Ayihuudin tafoolissi arri kanabbabamaro kahegeroolkokki mas'aafa addeesana mankkowaatten maraan murttitisooyi hegero goggogudarawun yeleen. ");
INSERT INTO bswl_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Goyiin tageegisso aalantti gohelanawaateenna P'ilaat'oosa Yesuusa goggolagadisisiroon ebaaten. ");
INSERT INTO bswl_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Garakkeessa kas'aafamero dubba guddiseen abbaabateren kakkosuwaamero gaakko dagiseerene k'amaleen. ");
INSERT INTO bswl_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Waa ade usu goyikko keese. ");
INSERT INTO bswl_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Galiilakko haggaɂabere taa Iyyerusaalemi geeroon usune wota ogireewunna goorata kamooggan mute; isona gidda gosa horee usuun atoyyaan. ");
INSERT INTO bswl_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","«Noonna Waa odolaalkkaanun abddii kasisero kageggeloo haafura isinuun lallabaanna. ");
INSERT INTO bswl_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Waa Yesuusana goyikko keesin isoon otabeero ammato no yiiskisoowun felera; hikkana kamazamuri mas'aafayi foolssi lamaa, ‹Ati erekkeetta; ani hittaari ku umulera;› amame s'aafamera. ");
INSERT INTO bswl_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Adena, usu kashamoon girona, Waanna goyikko usu keesano addeesisin haa amera; ‹Kak'ullooyerona kaɂabddaamero, kadaawute uuso isinuun sisinara.› ");
INSERT INTO bswl_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Adena takkalee banɂee, « ‹K'ulluukkikkaanna shami goggohesiroon lakkoyelatto› ame. ");
INSERT INTO bswl_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","«Daawute geeskkeessa dubbaayi feɂi tawaa handdaaye abbaabatere goyera; odolaalkkessanne wota k'amalame; maarkkeessana shamera. ");
INSERT INTO bswl_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Goottaa goyikko kakkeesera Yesuusa ade lakkoshame. ");
INSERT INTO bswl_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","«Goortta abbilaalttee! C'ubbokkokki shaaga kakkohelamara gara kayesuusane laano isinuun kalallabaamero addeesa. Haanssun usuu kaɂammanara dubba seera kamuseeyi helayiin tadaanddeennon k'ullumma helatara. ");
INSERT INTO bswl_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Haanssun kahegerool haa ameen kaɂayeeseran isin goggogeenonkko isiɂoorayeen. ");
INSERT INTO bswl_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","« ‹Isin ok'ac'ifaattaan, deyaa! Saadaa! Baa! maayyona isinuun goɂayeese Isin oɂabddannoon felo ani geeskkisinii felinnara,› » ");
INSERT INTO bswl_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","P'awuloosana Barnnabaasi kaɂayihuudi min kaɂebikko biyaa giranttii, ibaaddona hikka ayees kaɂemeetaro almmaa goggosegiro ebaayen. ");
INSERT INTO bswl_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Haaganaanna kakkodarɂaamatte goorata, kamooggan Ayihuudilnna ammano kayihuuda tos tabeeren ayees kaɂayyaanaa oɂataateeraan ibaaddojja P'awuloosana Barnnabaasi debee sesseeteen; isona ayeesiseren sino tawaayi ataayi goggogirraawun gorsseen. ");
INSERT INTO bswl_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Taɂemaatto tafoolissi arrii kakkatamaa gosa, ibaaddo uc'c'ar oolaal gohesiraan gosa dubba haafura kawaa maalin kukkume. ");
INSERT INTO bswl_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ayihuudina gosa kamooggan kukkuɂamano kakkodeyaare goorata, k'anaate ammagameen; ayees kap'awuloosa neebaataa inggaamano haggaɂabeen. ");
INSERT INTO bswl_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","P'awuloosana Barnnabaasi jabuuyi haa ameen; «Horaarjje haafura kawaa isinuun segaamiin dootisara, isin addeen tuffatteen; hikkaniinna jiruu jiroommakki giri isinuun kadootisoon aani isiɂoottisinii gutii mankkomurtteesitteen maraan noonna Ayizaab tos abbaabayinanna. ");
INSERT INTO bswl_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Usumaleenna Goottaa, ‹Fayyinna ulkotti gachcho goggogeegissoo ani ku Ayizaabn ifa yelera› ame Goottaa no ajajeera» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ayizaabiilna hikka kakkomaalaren goorata geggelaaten, haafura kawaawunna kabaja sisa; jiruu jiroommakki giriiwun oɂassaabameeraan dubba ammaneen. ");
INSERT INTO bswl_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kagootta haafurana gobobii kagiro ul dubba gee. ");
INSERT INTO bswl_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Taɂayihuudi jaarsso lee ade kaɂayihuudi ammanoo kagiro ibaaddo dureessaal heleelnna kakkatamaa kajiinjji ibaaddo kakkeeseeren P'awuloosana Barnnabaasi gutii horooramano goggokeero yeleen; ulkkisookona iso beesen. ");
INSERT INTO bswl_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","P'awuloosana Barnnabaasi isoon seerisano goggolleeroon luk'k'aɂoottisookko gorra hurgufateren Ik'ooniyoni tos seeteen. ");
INSERT INTO bswl_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Waa oɂammanareenna geggelooyinna Ayyaana K'ulluukki ammagameen. ");
INSERT INTO bswl_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Katamaa taɂik'ooniyoni P'awuloosa Barnnabaasine wota Ayihuudikokki min kaɂebi tabeen; eseenna madaareen mankkoɂagaalssiseen maraan, Ayihuudikkona Giriikkikko aaloo kamooggan ibaaddo Waa ammane. ");
INSERT INTO bswl_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Haɂammanonii kahesere Ayihuudi ade Ayizaab kekkeesere amaniil goggodidiraawun yele. ");
INSERT INTO bswl_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","P'awuloosana Barnnabaasi gara kagootta jabuuyi ayeesaa tanjjiin esee adallaaten; Goottanna kaɂayeesaran kasinoo haafura baasakki malaataalnna osaadamiraan felo iso gargaaraa iso addeesisaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kakkatamaa gosana kalekalee bee; gamisa Ayihuudine wota, gamisa ade ofarameeraanne wota lee. ");
INSERT INTO bswl_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Hassu goorata Ayizaabna Ayihuudi woyichchaalkisoonne wota raattoo isiɂaateren P'awuloosana Barnnabaasina ele hegel jaraanjurisinna eɂemoo eeggiin dooteen. ");
INSERT INTO bswl_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Isona adeen hikka goggoɂaddeeseenii Lisit'irana Derbbee kaɂamamaro katamaal kalik'aaɂoniya gobobii kagiro ul tos bak'ateen; ");
INSERT INTO bswl_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","eseenna wongala lallabaano horeddeen. ");
INSERT INTO bswl_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Maaman kalisist'iraayi, luk'k'a kakkonaafateeren takoɂumulamero arrikko haggaɂabere duuddo luk'k'aa sesseeyi kakkasoon ibaaddoti koo hamas's'ee gire. ");
INSERT INTO bswl_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Hikki ibaaddotina P'awuloosa kaɂayeesaro maalaa gire. P'awuloosa usu tos tichchise deegure fayyiisin kadanddeera ammano usuun girano kakkodeyaare goorata, ");
INSERT INTO bswl_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","yaaye taɂatiiyi, «Tukkul umi aallii!» ame; hassu goorata firime keegure sesseetano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Gosana P'awuloosa kafelero kakkodeyaare goorata, talik'aɂooniya heɂii, «Waal ibaaddo aani lee noo tos dagera!» ameen okkeen. ");
INSERT INTO bswl_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barnnabaasina «Diyyaa» ameen; P'awuloosa kaɂayeesare mankkollee maraan «Hermmeeni» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Katamaalkko sarre kagire, k'ulluukki min kadiyyakokki tuuk'aamoti kormmolee taɂaarareenna daraara kakkatamaa karra tos keenegure gosane wota raattoo leegure P'awuloosanna Barnnabaasiin jaarsso sisin hede. ");
INSERT INTO bswl_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ofarameeraan Barnnabaasina P'awuloosa hikka kakkomaalaren goorata gaddaayi sarssikisoo fiilatengureen gosa orro tiyyeengureen, iyyaa haa ameen. ");
INSERT INTO bswl_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Ulee! Hikka muun felattaan? Noo andde isin aani ibaaddonna; isin addeen hikka kamaaddinoon ayees dubbakko fakkimaddeen daruurnna ulnna, bekena iso orroo kagiro dubba kamet't'eero arddokki Hedo tos goggoɂabbaabattawun wongala isinuun lallabiiniya. ");
INSERT INTO bswl_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Waa taroorttetto alattaanun, gosa dubba kageelaate raakkeessaa goggosesseeron isaage; ");
INSERT INTO bswl_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Halleewo kuwaarre daruurkko idaamo usumaleenna il kakkohelattaan goratajool isinuun, sisano adena wodanattisin aamoonna geggelooyi bararisanoyinna taɂidan felanooyi isiɂoottessa ato kallayi lakkoɂiisinaro» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hikka dubba iso ayeesaa giraan ade, gosa isoon jaarsso goggosisoonkko kattirsiseeran rakkoo tammoogganiya. ");
INSERT INTO bswl_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ayihuudi goɂameen Ans'ookiyakkona Ik'ooniyonikko emetere, gosa meellanee kakkeeseerene, P'awuloosana eɂemoo eeggeen; esekko abbaabaterene usu kagoyero aani kakkolaare goorata takkogireen katamaakko sarii beesen. ");
INSERT INTO bswl_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Goleenna amaniilnna usuu maraamureen kakkoɂaallaren goorata P'awuloosa keegure katamaa tabe; tallami arrii Barnnabaasine wota darbbee seeteen. ");
INSERT INTO bswl_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","P'awuloosana Barnnabaasi Darbbeeyi wongala lallabeeren, ibaaddo kamooggan Waa kakkoɂammanare goorata, Lisit'ira, Ik'ooniyonena P'isidiyayi tagitto Anis'ookkiya tos abbaabateen seeteen. ");
INSERT INTO bswl_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Usu uliinna amaniil ammanokkisooyi goggoɂataarawun isoon gorssa sisaa «Wononnati kawaa tos tabin rakkoo tammooggan atatano dootisinara» amaa agaalssiseen. ");
INSERT INTO bswl_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Esekkona kamooggan min kawaayi jaarsolee shuumeen kakkoɂabbaabateeren goorata, agabuyinna ebi iso kaɂammanareen Goottawun hadara sisateen. ");
INSERT INTO bswl_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","P'isidiyane rooreen P'infiliya tos emeeten; ");
INSERT INTO bswl_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","P'erigeninna haafura kawaa lallabeen abbaabateren, At'aaliya tos dageen. ");
INSERT INTO bswl_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Esekkona iso ofeleraan feloowun sino tawaawun hadara takkosisanttetto tasoorya katamaayi tagitto Ans'ookiya tos walaboo seeteen. ");
INSERT INTO bswl_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ans'ookiya tos kakkogeyaaren goorata, amaniil dubba raattoo kukkuyisereen, Waa garakkisoonne kafelero dubba, adena Ayizaabn misii kaɂammano raa isoon banero segeen. ");
INSERT INTO bswl_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Eseenna amaniilnne wota raattoo tanjjiin hamas's'een. ");
INSERT INTO bswl_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Kookkoo ibaaddo Yihuudakko Anis'ookkiya tos dagere, «Kamuse seerakki malee gohamas'isamoon fayyiin lakkodaanddaattan» amere amaniil agaalssisano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Hikkina P'awuloosana Barnnabaasina isone wota taɂatii enggenna dogamaa orro tabse. Haanssun P'awuloosana Barnnabaasi kakkalee amaniilnne wota Iyyerusaalemi tos beenne hitta haajaawun ofarameeraanna jaarsolee goggohoosaranun murtteessame. ");
INSERT INTO bswl_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Haanssun min kawaa iso fare; isona adeen Fenk'enena Samaariya tonsse rooraa giraanna Ayizaab Waa tos emeetanona ammananokisoo segeen; hitti odona amaniil dubba geggelaayisse. ");
INSERT INTO bswl_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Iyyerusaalemi kakkogeyaaren goorata min kawaakki ibaaddona ofarameeraan usumaleenna jaarsoleenne k'op'ateen; handdaa oseeterenna Waa isone wota leere kafelero dubba isoon segeen. ");
INSERT INTO bswl_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Tafarasaawi unakko kaɂammanera ibaaddo kookkoo keegure, «Ayizaab goggohamas'isamironna kamuse seera goggoɂooraroon yelano kadootisaroya» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ofarameeraanna jaarsolee hikka ayees k'ulleessiin kukkuɂameen. ");
INSERT INTO bswl_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Dogamaa tanjiinkko abbaabatere P'et'iroosa keegure isone haa ame; «Abbilaalttee; Waa goorata kic'c'arkko horeene isin orrokko in assaabatera; Ayizaab kawongala haafura hiɂitteekko maaliren goggoɂammannaawun kayelnnaro kassaanwa. ");
INSERT INTO bswl_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Wodana taɂibaaddo kakkasa Waa noon goggosiserokki malee, isoonna Ayyaana K'ulluukki sisanooyi iso kaɂatatero laano isoon atotee. ");
INSERT INTO bswl_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Wodanattisoo ammanooyi mankkomuc'c'isero maraan noonna isoo t'eɂee kaleenna lakkokaye. ");
INSERT INTO bswl_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Goortta, odolaalkkaanina leere noo sidin daandaana kawaannenno hark'k'oota kaɂamaniil haan gutii kaa gidda muun Waa c'aafattaan? ");
INSERT INTO bswl_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nonna kafayyinenna likkii iso aani Goottakkaani Yesuusakotti sinoo laano ammananna.» ");
INSERT INTO bswl_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kakukkuɂamere gosa dubba c'alɂi amere Barnnabaasina P'awuloosa Waa garakkisoonne Ayizaab orroo kafelero baasakki malaataalnna kasaadisiro ayees goɂayeesiro maalaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Isona ayeeseen kakkogussatareen goorata Yayik'ooba haa amaa ayeesano haggaɂabe; «Abbilaalttee! Maala; ");
INSERT INTO bswl_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Waa taɂayizaab unakko usuun kalleero gosa t'aye misii deero Simoona noon segeera. ");
INSERT INTO bswl_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Haa amame kas'aafamera kahegerool haafura hikkanne wota isiɂaatara. ");
INSERT INTO bswl_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","« ‹Hittakko horenbbaan ani abbaabayinara kadiigamero kadaawute min madaarinara. Kabututerona abbaab aalliisinara; Abbaab madaarinara; ");
INSERT INTO bswl_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Hikki kahesera ibaaddona, unattee kalleera Ayizaabin Waa goggodootironya; Hikka kafelera Goottaa haa amara;› ");
INSERT INTO bswl_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Isona horkkooskko haggaɂabereen oɂaddesameenyaan. ");
INSERT INTO bswl_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«Haanssun Waa tos kaɂabbaabatero Ayizaab noo goggoc'annak'isonkko hikki yaadakkeeya. ");
INSERT INTO bswl_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ayesuun goɂameen tolchchaayi kabattoyero ayeeskko, kasharmmut'umma battowanokko, c'uulɂeen kalagadeeraan giddi aamanokkona iigi t'amanokko fakki goggoɂamiraanun noo isoon s'aafiin dootisara. ");
INSERT INTO bswl_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Seera kamusena horkkooskko kayere Ayihuudin tafoolssii arri Ayihuudikokki min kaɂebii nabbabamaanna katamaali lallabaamaa adallaatera.» ");
INSERT INTO bswl_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Hassu goorata ofarameeraanna jaarsolee kamooggan min kawaanneta raattoo leereen iso orrokko ibaaddo assaabereen, P'awuloosanena Barnnabaasine wota Ans'ookiya tos farin murtteesseen; amaniil orrona oɂaddesameeran Berssabaasi kaɂamamaro Yihuudana Sillaase assaabeen. ");
INSERT INTO bswl_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Tas'aafanttetto dabddaabbee isoo gutii fareen; dabddaabbeenna haa taɂamattotte; noo ofaramnnennana jaarsolee olleenenna abbilaalttisin, una taɂayizaabkko ammantteedden Ans'ookiyaayi, Sooriyaayinna Kilk'iyayi ogittanun nogodda no farramanna. ");
INSERT INTO bswl_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kookkoo ibaaddo feɂittaan kallayi no orrokko beere ayeeskkisooyi wodanattisin haggatola yelanona shalagaano no maalnnenna. ");
INSERT INTO bswl_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Haanssun ibaaddojja uc'c'arri assaabinenne no ogeelaatanno Barnnabaasinena P'awuloosane wota iso isin tos farin no dubba isiɂaanttenna; ");
INSERT INTO bswl_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Barnnabaasina P'awuloosa Goottakkaani Yesuusa Kiristoosakkokki mege maraan neefotisoo roorssateen osisateraanyaan. ");
INSERT INTO bswl_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Haanssun noo kas'aafinnennona hiɂii segii goggoɂaddeesisiranun, hinɂima Yihuudana Sillaase no isin tos farnnenna. ");
INSERT INTO bswl_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Hikka kadootisaro ayees kuwaarre takkalee tagujjummaa sidane, no isinuun goggosidsoonkko, Ayyaana K'ulluukkiinna noon kaɂidankki lee mutera; hikkina, ");
INSERT INTO bswl_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Tolchchaan kaɂenɂaamero kooko, iigikko, c'uulɂaame kagoye giddikonɂi soo usumaleenna sharmmut'ummaa battowanokko fakki goggoɂanttaanunya. Hikka aankkikki ayeeskko gofakkintteen isinuun kaɂidaniya; nogoddaa gira. ");
INSERT INTO bswl_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Handdaa kafaramere ibaaddona nogoddaa gira ameeren Ans'ookiya tos dage; eseenna kaɂammanaro gosa raattoo kukkuyisereen dabddaabbee isoon siseen. ");
INSERT INTO bswl_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Gosana dabddaabbee nabbabe abbaabatere kaɂataayisaro ayeesii geggelaate. ");
INSERT INTO bswl_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yihuudana Sillaase iso metekkisoowun ohegerool mankkolleen maraan amaniil kanjiin haafuraa gorsseen; ataayiseen. ");
INSERT INTO bswl_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Eseenna abaraan adallaateren taɂammanatto abbilaalttisokko nogodda susukkaameeren iso kafarero ibaaddo tos abbaabateen seeteen.  ");
INSERT INTO bswl_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Sillaase ade esee hesiin goosate. ");
INSERT INTO bswl_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","P'awuloosana Barnnabaasi kakkalee kamooggan ibaaddoneta leereen kagootta haafura agaalssisaanna lallabaa Ans'ookiyaayi hamas's'een. ");
INSERT INTO bswl_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","P'awuloosa arri tic'c'arkko abbaabatere Barnnabaasine, «Kingudde kagootta haafura no kakkolallabinenno katamaal dubba seenno; esee kagira amaniil misimisii giro addeesin seeyi deenna» ame. ");
INSERT INTO bswl_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnnabaasina Mark'oosa kaɂamamera Yaannisa isone wota goggoseero doote; ");
INSERT INTO bswl_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","P'awuloosa ade usu aati seeyin lakkodootere; aalanttina, hittakko horene Mark'oosa isokko kalebeere kap'inifiliiya ulii mankkohesere maraanna isone wota feloon seetana mankkowaatere maraanye. ");
INSERT INTO bswl_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Hikka aankkikki isiɂaatanawaatti isoo orroo mankkomet't'aame maraan iskko darɂaameen; haanssun Barnnabaasi Mark'oosa aatere wolabooyi kak'op'iroosi ul seete. ");
INSERT INTO bswl_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","P'awuloosa ade Sillaase assaabate; amaniilnna P'awuloosa sino tagoottawun hadara siseenguren iiseen galeen. ");
INSERT INTO bswl_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Kamooggan min kawaa ataayisaa ul kasooriyannena kakilik'iya tonsse roore. ");
INSERT INTO bswl_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","P'awuloosa darbbeenna List'ira tos seete. Eseenna Aayetteessa Ayihuuditi Waa taɂammanatette; odokkeessa goɂameen kaɂayizaab ibaaddo kakkoonlleere T'imotoosa kaɂamamare Yesuusakko kaɂagaalssatare koo gire. ");
INSERT INTO bswl_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Usuna List'irayinna Ik'ooniyoyi kagiro amaniil dollee kaɂidan ato abanaaye. ");
INSERT INTO bswl_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","P'awuloosana hikki ibaaddoti usune wota goggoseeron doote; haanssun usu gobobii kagire Ayihuudikkotti aalanttii goggohamas'isamiroon yele; hikkana kakkonyelera kat'imatoosa odokkeessa kaɂayizaab ibaaddo laano mankkokasanaayeen maraan isoon amereya. ");
INSERT INTO bswl_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","P'awuloosas katamakatamaalnne rooraa giraan Iyyerusaalemii tagitto jaarsoleeyinna ofarameeraani kamurtteessamero woga amaniilun addeesisaa gire; feloo gutii goggohayisiraanunna shaadisaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kamooggan min kawaa ammanooyi ataate; tootoɂoottisona arri arrii adamaa seetaa gireen. ");
INSERT INTO bswl_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","P'awuloosana unatteessana haafura kawaa Isiyaayi goggolallabinoonkko Ayyaana K'ulluukki iso mankkotirere maraan ul kafirggiyanena kagalaatiyanne rooreen seeteen. ");
INSERT INTO bswl_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kamisiiyami ul tos kakkogabbalamareen goorata kabittaaniya ul tos seeyin hedeen; ayesuun goɂameen kayesuusa Ayyaana iso goggoseerawun feɂi lakkosise. ");
INSERT INTO bswl_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Haanssun mina tamisiiyanne T'iroɂaada tos dageen. ");
INSERT INTO bswl_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","P'awuloosana hemeen raagayi koo kamek'edooniya ibaaddoti aalleere, «Kamek'edooniya ul tos nak'idde no gargaarina» amaa ebaataa giraan dee. ");
INSERT INTO bswl_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","P'awuloosa hikka raaga kakkodeyaare goorata, Waa no wongala goggolallabinnon uumera aminenne mankkomurtteessannenno maraan goorsewa Mek'edooniya tos seeyin dootanne. ");
INSERT INTO bswl_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ul kat'iroɂaadakko markkafaa keennegunne tukkul duudaataa ul kasamutiraak'e geenne; tallami arri duudaataa Naap'ule seenne; ");
INSERT INTO bswl_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Esekkona keennenne Roomii hegelii tabaraatte ul kamek'edooniyakokki gobobii taggitte metetti tafilip'isiyoosa katamaayi teek'anne; eseenna arri tic'c'ar hamas's'ine. ");
INSERT INTO bswl_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Tafoolssii arri, taɂebi banɂe dootataa, ese katamaakki karakkoo beennenne laga koo tos dayinne; esee no hamas's'iinegunne kukkume kagire heleeluun haafura kawaa segaano haggaɂabnne. ");
INSERT INTO bswl_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Maalaa kagire heleel orrokko Liidiya taɂamamatte heleelttiti too gitte; esena Waa tahedoyisaattena tatiyaat'irooni katamaakko taɂemettetto kagashe ooga tadaddalaattette. Goottanna, P'awuloosa kaɂayeesero ayees shaadaa goggomaaltto Waa wodanattisee bane. ");
INSERT INTO bswl_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Esena kaminee ibaaddokise kakkot'ammak'amare goorata, «Ani Goottaayi ammananokkee ogiraan goɂaddeesseen» «Minkkee emeeyiddeen abaraanttii hamas's'aa» amaa ataayisse ese no ebaatte. ");
INSERT INTO bswl_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Arri too no banɂe taɂebi tos seetaa giraan, kamoruu Ayyaanayi hegero taɂayeesatte diyyiti heleelttiti too no heltte; esena hinɂa omoruu feloɂoottiseeyi ese kabariisaroon maragade kamooggan tattabsattetta. ");
INSERT INTO bswl_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Hitti diyyiti P'awuloosanna noo debee sesseetaa, «Hikki ibaaddo kafayyinna raa isinuun kasegaarona dubbaankko t'ok'k'i kaɂame Waawun ohandaaranyan!» amaa okkaa gitte. ");
INSERT INTO bswl_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Hikkana arri tamooggan abbaabtte abbaabtte amaa gitte; P'awuloosa goɂameen amaraatere kambbal ame hassu Ayyaana, «Kagootta Yesuusa Kiristoosakokki megee ati esekko goggobeeto ani ku ajajaara!» ame; usu Ayyaanana goorsewa esekko bee. ");
INSERT INTO bswl_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ese kabariisarena maragade kakkohelatareen abddi baa seetano kakkoɂaddeesareen goorata P'awuloosana Sillaasena abeen giitaa odonnati oɂabaan mankkogiraan songoon geesen. ");
INSERT INTO bswl_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Mootijjol horee aallisereene, «Hinɂi ibaaddojja Ayihuudi leen giraan katamaattaani shalageeraan; ");
INSERT INTO bswl_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","No taroomi katamaakki ibaaddo atayin goorttun felin kadootisoon woga gosa orroo ayeesaran» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Gosana raattoo isiɂaatere P'awuloosanna Sillaasee gutii kee; mootijjolnna sarssikisoo k'aarigureen damaayi goggoboc'irawun ajajeen. ");
INSERT INTO bswl_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Akamalee boc'een abbaabaterene minkashaano tabiseen; minkashaano kaɂoorarena ataayi goggoɂoorroo ajajeen. ");
INSERT INTO bswl_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Usuna hikka aankkikki ajaja atate abbaabatere, min kashaanoo taɂorroo kifilii tabisere luk'aɂoottisoo gaanne wota ataayise abe shiye. ");
INSERT INTO bswl_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Hemeen t'eɂe P'awuloosana Sillaase ebaataanna zammaraa Waa galataa gireen; oshaameeren kuunɂina adeen c'ak'asaa gireen. ");
INSERT INTO bswl_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Derɂa min kashaanokki ukum kaɂaaɂisiro kaɂatii ulkokki aaɂaano lee; goorsewa min kashaanokokki ufa baname; dubbakokki shaano furame. ");
INSERT INTO bswl_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Minkashaano kaɂoorare ibaaddotina huddurokko nabbaadere min kashaanokokki ufa banamano kakkodeyaare goorata, kashaamera ibaaddo iise kabeero aani usuun leere isiɂoottessa lagadayin shiifa miɂate. ");
INSERT INTO bswl_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","P'awuloosa ade yaaye t'ok'k'isere, «No dubba hittanii ginna; isiɂoottaa gutii tameellan aroogegisatte» ame okkeen. ");
INSERT INTO bswl_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Minkashaano kaɂoorare ibaaddotina dab ebaate atatere tiiyye orroddee tabe; harɂaa Op'awuloosaanna Osillaase luk'k'a hegelii iyye; ");
INSERT INTO bswl_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Iso sar aate beegure, «Goottolleettee! Ani fayyiin me fella?» ame. ");
INSERT INTO bswl_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Isona, «Gootta Yesuusayi ammani; atina kaminee ibaaddokkana fayyitaanwa» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Kagootta haafura usuna minkkeessaa kagiro ibaaddo dubbaawun segeen. ");
INSERT INTO bswl_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Minkashaano kaɂoorare ibaaddotina hemeen ese saatiiwa geesere meeggatisoo aalise; goorsewa usuna minkkeessakki ibaaddona t'ammak'ame. ");
INSERT INTO bswl_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Min kashaanoo kaɂoorare ibaaddotina minkkeessa aate seetere babo horee kaye; kaminee ibaaddokkeessane wota Waa ammananooyi aaloo geggelaate. ");
INSERT INTO bswl_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ul kakkobaraare goorata, mootijjolnna, «Hanɂu ibaaddojja furi gafari» ameeren foolisijool fareen. ");
INSERT INTO bswl_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Minkashaano kaɂoorarena, «Mootijjol isin goggofuranttanun ajajeeran; Haanssun biyaddeene nogoddaa gala» ame P'awuloosaan segee. ");
INSERT INTO bswl_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","P'awuloosa ade, «Noo karoomi ulkokki ibaaddo leene giraan, gosaa hore firdda kallayii boc'eerene minkashaano no tabiseen; hayya gidda siyamisi beesin dootaraan? Hikki haa liin lakkodaanddaaro; iso issii emeeyiren no habbeeseen!» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Foolisijjolnna hikka ayees mootijjolul segeen; isona P'awuloosana Sillaase karoomi ibaaddo laano kakkomaalareen goorata neen; ");
INSERT INTO bswl_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Iso isi emetengureen baanssenna ameengureen min kashaanokko beesen; isona ese katamaa gafari goggobeerawun ebaaten. ");
INSERT INTO bswl_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","P'awuloosana Sillaase min kashaanokko beengurene min kaliida seeteen; esena amaniil heleeren ataayisereen, esekko abbaabateen seeteen. ");
INSERT INTO bswl_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","P'awuloosana Sillaase Anfip'olinena Ap'olooniyane rooreneen tateselonk'k'e katamaa tos seeteen; eseenna Ayihuudikokki min kaɂebi gire. ");
INSERT INTO bswl_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","P'awuloosa goggokasanaaye Ayihuudikokki min kaɂebi tabe; Ayihuudin kafoolssii almma seed k'ulluukki mas'aafajjolkko banɂe tusaa agaalssisaa gire; ");
INSERT INTO bswl_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Kiristoosa rakkoo atayiinna goyikko kiin kadootisaro laano addeesise agaalssisaa gire; «Hikki ani isinuun kalallabaara haafura Yesuusa usu Kiristoosaya» ame. ");
INSERT INTO bswl_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ayihuudikkona kookkoo ibaaddo kamaalero haafura atatere P'awuloosanena Sillaasene wota koo leen; usumaleenna Waa kahedoyisatara aaloo kamooggan kagirikki ibaaddona katamaayi kaɂaddeesamera heleel haafura atatere isone wota koo lee; ");
INSERT INTO bswl_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ayihuudi ade gaabbeere felo kafelannon ibaaddo raa raakko kukkuyisereen kekkeeseen. Katamaa orroo shalago goggokeeroon yeleen; P'awuloosana Sillaase gosaan beesi sisin kaɂiyyaasooni minkokki ufa ebiseen tabeen. ");
INSERT INTO bswl_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ayesuun goɂameen iso helin waateengurene Iyyaasoninaa amaniil kookkoo katamaayi odonnati oɂabaawun roorisi sisin abeen giitaa aateen seeteen; haa amaa okkaa gireen; «Hinɂi ibaaddojja alami dubba oshalagaareen gidda adeen hittarraa emeteeraan; ");
INSERT INTO bswl_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Iyyaasonina minkkeessaa iso k'op'atera; hinɂi dubbana ‹Yesuusa kaɂamamara kakkalee wono girowa› amaa karoomi wono k'eesarikokki ajaja oneebaataraanyan.» ");
INSERT INTO bswl_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Gosana katamaayi odonnati oɂabanaayen hikka kakkomaalaren goorata shalagaameen. ");
INSERT INTO bswl_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Esekko Iyyaasoninaa kakkalee usune wota kagire ibaaddo waasi uumsiseeren gafareen. ");
INSERT INTO bswl_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Amaniilnna banneewa P'awuloosana Sillaase hemeen t'eɂe ul kabbeeriya ajajeere; isona eserraa kakkogeyaaren goorata; Ayihuudikokki min kaɂebi tos tabeen. ");
INSERT INTO bswl_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beeriyayi kagira ibaaddo Teselonk'eeyi kagiro ibaaddokko wodanaamekki mankkolleen maraan haafura kaɂatiitii halchchaayi atateen; haafurana rummi laano addeesin ameeren arggetto k'ulluukki mas'aafaal k'ok'k'oraa gireen. ");
INSERT INTO bswl_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Haanssun iso orrokko kamooggan ammane; ul kagirikkii durummaa kaɂaddeesamere kamooggan heleelnna babbaarnna ammane. ");
INSERT INTO bswl_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ayesuun goɂameen Teselonk'eeyi kagira Ayihuudina, P'awuloosa Beeryayina haafura kawaa lallabaano kakkoɂaddeesareen goorata eserraa seeteen gosa shalageen. ");
INSERT INTO bswl_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Usu goorata amaniil P'awuloosa banneewa labu tos fare; Sillaasena T'imotoosa adeen esee heseen. ");
INSERT INTO bswl_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","P'awuloosa osussukkareen ibaaddojja ul kaɂateena geegiseen; esekko «Sillaasena T'imotoosa haɂadallaannooni saami in tos haɂemeteen» kaɂamaro ajaja atateeren Beeriya tos abbaabateen seeteen. ");
INSERT INTO bswl_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","P'awuloosa taɂateena katamaayi hamas's'eere Sillaasena T'imotoosa ooraa giranttii katamaa orroo tolchchaal ammagamano deegure ayyaanakkeessa c'annak'ame. ");
INSERT INTO bswl_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Haanssun Ayihuudikokki min kaɂebii Ayihuudinena Waa kahedoyisataro Ayihuudine wota songoonii arggetto kaɂeselaro ibaaddone wota hoolttootaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Eppikkorosojjolnna Isttokkijjol oɂamamareen met't'een oɂayyeesareenna usu tos emeeten dogamaa gireen. Kookkoo ibaaddo, «Hikki henttefelleti me amin dootera?» goɂamiro, kakkaleenna ade «Kaɂusub waalkokki gara kaɂayeesaro aani laara» amaa gireen; hikkana kakkoonɂameeren aalantti P'awuloosa kayesuusa goyikko kiyaanokokki gara mankkolallabere maraanye. ");
INSERT INTO bswl_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Haanssun P'awuloosa abeeren Aryosffagosi taɂamamatto banɂee kukku kaɂamaro gosa tos keenenguren haa ameen; «Hikki ati kaɂagaalssisatta kaɂusubkki agaalssis meyyo addeesin daanddaanna? ");
INSERT INTO bswl_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kookkoo kaɂaddeesamoon ayees maalnnenna; Haanssun hikki ayees meyyo addeesin dootanna.» ");
INSERT INTO bswl_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Iso hikka kakkoonɂameeran kaɂateena ibaaddona sarkko emetere taɂateena katamaayi kahamas'eera ibaaddo dubba ayees kaɂusub ayeesanoyiinna maalanoyi goorata roorssayiin mankkodootatareen maraanya. ");
INSERT INTO bswl_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Haanssun P'awuloosa Aryosffagosikotti banɂee kakukkuɂamero gosaa hore aalleere haa ame; «Isin kaɂateena ibaaddo! Mina dubbane aaloo kahedoyisaattaan laano ani addeesera; ");
INSERT INTO bswl_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Katamattisinii ani haggatola sesseetaa takkohedoyisaattaan banɂejjool godeero ‹Kaɂaddeesamoon Hedoon› amantte tas'aafanttetto tafala banɂe hele; goortta ani isinuun kasegaara hikka haɂaddeesooni isin kahedoyisattaan Hedo maraanya. ");
INSERT INTO bswl_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","«Usu alamina alamii orroo kagiro dubba kamet't'eeroya; kadaruurenna kaɂulee Goottayya; usu gene taɂibaaddoyi kamadaarameroo minii lakkogiraro; ");
INSERT INTO bswl_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Girina neefona, kakkalee ayees dubba ibaaddoon kasisara usu mankkollee maraan koonna usuun lakkohank'k'ataro; gargaarssa kaɂibaaddonna usuun lakkodootisaro. ");
INSERT INTO bswl_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Usu sannii dubba ibaaddoti kookkoo met't'eera; ulii dubbaa gutiinna goggogirroon yele; gamisaan geesjjolnna takkogirraan banɂe isoon kaye. ");
INSERT INTO bswl_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Hikkana usu kakkoonyelera ibaaddo Hedo goggodootaronna k'ok'k'oratanoyinna usu dootayi helayiin goggodanddeeronya; golleenna usu mete metee nookko fakki kaɂameya amano lakkoyo. ");
INSERT INTO bswl_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‹Noo giri kakkohelatannana kakkoɂaaɂanna, kakkogirnnananna usuuya,› hikkina ayesuun obebbeeraan oottisin ‹Noo dubba yiiskkeessanna;› goggoɂameeraniya. ");
INSERT INTO bswl_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","«Goortta noo yiis kawaa golleene, Waa k'arumma taɂibaaddoyinna k'ofa taɂibaaddoyi work'k'iikko goorttun brrikko goorttun eɂemokko kafelamero aani laara ami k'oppiin noon lakkodootisaro. ");
INSERT INTO bswl_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Goortta ibaaddo horkko malabanawaattii kafelero Waa isaage roorera; gidda goɂameen ul ulii kagira ibaaddo dubba c'ubbokko goggogula galloon ajajeera. ");
INSERT INTO bswl_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Usu kaɂassaabatero ibaaddotikokki garane alami dubbaa gutii rummii takkofirddinaro arri murtteessaatera; hikkana dubbaawun kakkoɂaddeesisera hassu kaɂassaabatero ibaaddoti goyikko keesanoyiya.» ");
INSERT INTO bswl_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","«Goyikko keyaano» kaɂamaro haafura kakkomaalareen goorata gamisa k'ac'c'ifate; kakkalee ade «Hitta haajaakokki gara arri takkalee ati ayeesaa giraan no maalnanna» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Esekko P'awuloosa gosa orrokko bee seete; ");
INSERT INTO bswl_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ibaaddo kookkoo ade gara kap'awuloosa tos leere agaalssisikkeessa ammane; kaɂammanero ibaaddo orrokko kaɂaryofagosi haaganaawun una olleeren Diyonasiyosi kaɂamamere ibaaddotina Demaaresi taɂamanttette heleelttiti toonna, kakkalee ibaaddo isone wota gire. ");
INSERT INTO bswl_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Esekko abbaabatere P'awuloosa Ateenakko keere ul kak'orontoosa seete. ");
INSERT INTO bswl_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Esee ul kap'ent't'iyoosakki kalleere Ak'ila kaɂamamare koo kaɂayihuudi ibaaddoti hele; karoomi wonolaalkokki wono K'elaawudoosa Ayihuudi dubba Roomikko goggobeeranun ajajee mankkogire maraan Ak'ila ooritteessa P'irisk'k'illane wota It'aaliyakko ganaa emeetanoye; Haanssun P'awuloosa iso tos seetegure isone isiɂaddeesisateen; ");
INSERT INTO bswl_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Feloɂootteessa iso aani dunkkaanii iriirano mankkollee maraan isone wota hamas's'eere raattoo iriiraa gire. ");
INSERT INTO bswl_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ayihuudin tafoolssii arrii Ayihuudikokki min kaɂebii ayeesaa Ayihuudina Giriikki ammanchchisiin is's'aamaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sillaasena T'imotoosa Mek'edooniyakko kakkoɂemeetereen goorata P'awuloosa ataayise lallabaa «Yesuusa usu Kiristoosaya» amaa Ayihuudin atotaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ayesuun goɂameen Ayihuudi kakkoneebatareenna kakkohabaarareen goorata isoon seerisano goggolleeroon sarssikko gorra hurggufatere «Goortta isin gofirddaantteenna baaskkisiniiyya! Ani odonnati lakkoɂabo; goortta hittakko horenbbaan Ayizaab tos seeyinara!» ame. ");
INSERT INTO bswl_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Haanssun isokko kalebeere Tiitoosa Iyyost'oosa kaɂamamare ibaaddotikokki min seete; hikki ibaaddoti Waa kahedoyisatareyye; minkkeessana Ayihuudikokki min kaɂebi dollee gire; ");
INSERT INTO bswl_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","K'ersip'oosa kaɂamamare kaɂayihuudi min kaɂebikokki woyichchati kaminee ibaaddokkeessane wota Goottaayi ammane; kamooggan kak'orontoosa ibaaddona P'awuloosa ayeesaa giraan maalere ammane t'ammak'ame. ");
INSERT INTO bswl_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Goottanna P'awuloosane hemeen raagayi haa ame, «Arooɂabssatte; ayeesi; c'alɂi arooɂantte; ");
INSERT INTO bswl_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ani kuunne wota gira; hitta katamaayi ani ibaaddo kamooggan aba; ku gutii miirɂa kageegisira maayyona lakkogiro.» ");
INSERT INTO bswl_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Haanssun P'awuloosa haafura kawaa gosa agaalssisaa gees koonna minana isone wota esee adallaate. ");
INSERT INTO bswl_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galiyoosa ul kaɂakkaayakokki mooti lee takkoshuumameree Ayihuudi raattoo leere P'awuloosa gutii kee; tafirdda shonggoo tos geesenguren, ");
INSERT INTO bswl_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","«hikki ibaaddoti seera feɂi kakkosisoon raadii ibaaddo Waa goggohedoyisaroo yelara!» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","P'awuloosa abbaab sisin ekkaasate giraan Galiyoosa Ayihuudine haa ame; «Isin taɂayihuudi una! Baasi goorttun kaɂatii wonjjala isinii gutii kafelamero lii girewa mootokkisin obssii ani maalarewa; ");
INSERT INTO bswl_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ayesuun goɂameen haafura kaɂibaaddo maraan, megejjol maraanna seerakisinun kadogamattaan gollee haajaattisintta; ani hikka ayees gutii firddin lakkodootaro.» ");
INSERT INTO bswl_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Haa amerena tafirdda shonggookko iso beese. ");
INSERT INTO bswl_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Hassu goorata dubbana Ayihuudikokki woyichchati Sostteneesi abeenguren shonggoo hore boc'c'een; hikki dubba haa laa giranttii Galiyoosa hikka ayesuun kinttib lakkosisero. ");
INSERT INTO bswl_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","P'awuloosa amaniilnne wota tanjjiin arri K'orontoosaayi adallaatere isone nogoddaa gira amere esekko keere Sooriya tos seete; P'irisk'k'illana Ak'ila usune wota gireen; ayesuun goɂameen usu gefaa mankkoɂabanaaye maraan seetanakko horene Kinkkiriya taɂamamatto banɂee mete hoolate. ");
INSERT INTO bswl_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Taɂefesooni katamaa kakkogeyaaren goorata P'irisk'k'illana Ak'ila esee iise; usu goɂameen Ayihuudikokki min kaɂebi tabere Ayihuudin ayeesaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Usu isone wota tanjjiin goggoɂadallaaron goɂebaatenna isoon iin lakkoɂame. ");
INSERT INTO bswl_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ayesuun goɂameen, «Feɂi tawaa golleete arri takkalee isin tos abbaabayi emeeyinara» amegure Efesoonikko markkafaa koratere seete. ");
INSERT INTO bswl_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","K'isaariya tos kakkogiyaare goorata esekko Iyyerusaalemi seetere min kawaakki ibaaddone nogodda aate abbaabate Ans'ookiya dage. ");
INSERT INTO bswl_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Eseenna abaraan gac'c'ime; esekko abbaabatere ul kagalaatiyayinna kafirggiyayi ulkko ul tos maraamuraa amaniil ataayise. ");
INSERT INTO bswl_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Alattaanun ul kaɂisikkiddirakki kalleere Ap'iloosa kaɂamamare Ayihuuditi koo taɂefesooni katamaa emeete; usu k'ulluukki mas'aafaal madaare kaɂagaalssaterona ayeesi kakkaso ibaaddotiyye. ");
INSERT INTO bswl_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Usu raa kagootta kaɂagaalssaterona Ayyaanaa ammagamere gara kayesuusa likkii lallabaanna agaalssisaa gire; halleewo kuwaarre usu kakkasanaaye kayaannisa t'ink'ata kaalaalye. ");
INSERT INTO bswl_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Usu Ayihuudikokki min kaɂebii jabuuyi ayeesano haggaɂabe; ayesuun goɂameen P'irisk'k'illana Ak'ila kakkomaalareen goorata, minkkisoo geesenguren raa kawaa kahoreekko rooriseen likkii fureen usuun segeen. ");
INSERT INTO bswl_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ap'iloosa ul kaɂakkaaya tos seeyin kakkohedatare goorata amaniil k'ofatteessa gargaareen; Akkaayayi kagira amaniil goɂidan usu goggok'op'aroo dabddaabbee s'aafen. Eserraa kakkogeyaare goorata sino tawaakko kakkeeyi ammane ogireenun gargaarissa kaɂatii lee. ");
INSERT INTO bswl_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Yesuusa Kiristoosa laano k'ulluukki mas'aafaalkokki haafura agaalssiisaa dogamaa taɂatiiti Ayihuudi awodaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ap'iloosa K'orontoosaa takkogiree, P'awuloosa ul kaɂeleenne roorere ul kaɂefesooni gee; esee amaniil kookkoo helegure, ");
INSERT INTO bswl_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","«Waa kakkoɂammantteetten goorata Ayyaana K'ulluukki atatteetten?» ame. Isona, «Lakkoɂatanenne; suurewa Ayyaana K'ulluukki giranowa noo lakkomaalnenno» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","P'awuloosana «Hayya, meyii t'ammak'antteettaan?» ame. Isona «Kayaannisa t'ink'ataya» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","P'awuloosana, «Kayaannisa t'ink'ata goɂameen c'ubbokko gula galanokkokki t'ink'ataya; gosaawuunna usu kaɂayeesere ‹Inkko haarre kaɂemeetaroo ammana› amaa gire; usuna Yesuusaya» ame. ");
INSERT INTO bswl_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Isona hikka kakkomaalaren goorata mege kagootta Yesuusaa t'ammak'ameen. ");
INSERT INTO bswl_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","P'awuloosana genetteessa isoo gutii kakkokkaare goorata, Ayyaana K'ulluukki isoo gutii dage; heɂi takkaleetinna ayeeseen; hegero ayeesanona haggaɂabeen. ");
INSERT INTO bswl_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ibaaddona raattoo tomonkko lama kalleeroye. ");
INSERT INTO bswl_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","P'awuloosana Ayihuudikokki min kaɂebi tos tabere diginni seed wononnati kawaakokki gara dogamaanna gosa jabuuyi agaalssisaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Kookkoo too kayelate kagootta raa gosaa hore inggaamaa lakkoɂammaninanno kakkoɂamareen goorata isokko fakkime; amaniilnna kale beesere kat'iraanosi adaraasha arggetto agaalssisaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","P'awuloosa hikka kakkofelaagire gees lamawunye; usu goorata Isiyaayi kagire Ayihuudina Ayizaab dubba haafura kagootta maalin daanddeen. ");
INSERT INTO bswl_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Waa gene tap'awuloosa aaloo kasaadamiro baasa felaa gire; ");
INSERT INTO bswl_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","hikkakkotti aalanttii maar kap'awuloosa tadinte hoc'c'o leetette maarrabii kahawɂaamaro ibaaddo godinnaan hawɂaamikko fayyaa gire; battiikki ayyaanajjolnna isokko biyaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Durrisa ibaaddokko beesaa banɂe dubbaa kamaraamurare kookkoo Ayihuudi «P'awuloosa kakkolallabaaro Goottaa Yesuusakokki megee goggobeetanun no isin ajajaanna» amaa durrisa ibaaddokko beesin is's'aamaa gireen. ");
INSERT INTO bswl_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ayihuudin tuuk'aamokokki woyichchati kalleere yiis kaɂask'k'ewa babbaar todobana usumalee yelataa gire. ");
INSERT INTO bswl_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ayesuun goɂameen battiikki ayyaanajjol, «Yesuusa ani kasowa gara kap'awuloosana ani kasowa; ayesuun goɂameen isin ayyoosttaan?» ame. ");
INSERT INTO bswl_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Battiikki ayyaana kakkogire ibaaddoti koo firime kee iso abe; isoo gutiinna ataate; awode; meeggaaterene hawɂayii minkko bak'ateen been. ");
INSERT INTO bswl_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Hikkina Efesooni kagiro Ayihuudinna Ayizaab dubbaa dollee kakkoɂadesamare goorata, dubbana abisatteen; hikkaniinna kagootta Yesuusa mege kabajaame. ");
INSERT INTO bswl_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Waa kaɂammanero ibaaddokkona kamooggan felo omeellan oottisoo addeesisaten c'ubbokko gula galeen; ");
INSERT INTO bswl_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Moraa ogireenkkona omooggan mas'aafaalkkisoo kukkuyiseen keeneguren gosa horee gubeen; mas'aafakokki dookkina gohedamiro t'agaraa kuma konttom kalleeroye. ");
INSERT INTO bswl_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Hikka garaayi kagootta haafura aaloo hunnaa jiinataanna awodataa seete. ");
INSERT INTO bswl_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Hikki dubba kakkolaare goorata P'awuloosa, ul kamek'edooniyannena kaɂakkaayane roori Iyyerusaalemi tos seeyin ayyaanayi k'oppeere, «Eserraa kakkogee goorata adi Roomi tos seeyin iin dootisara» ame. ");
INSERT INTO bswl_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Haanssun usu kagarggaararo ibaaddokko lama, T'imotoosana Ersit'oosa, Mek'edooniya tos farere usu ade Taɂiisiya awuraajjaayi arri tic'c'ar adallaate. ");
INSERT INTO bswl_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Hassu goorata, raa kagootta maraan kaɂatii shaalago kee. ");
INSERT INTO bswl_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Dimet'iroosa kaɂamamare bir taɂamamatto marc'c'o katumare kaɂart't'emisi min katolchchakotti misiliil biri taɂamamatto marc'c'okko felaa otumananuun kanjjiin worɂe helamissisaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Haanssun hikki ibaaddoti bir taɂamamatto marc'c'o otumaraanna feloɂoottisoo aanɂinɂi kaɂabo kakkalee ibaaddona kukkuyisereen haa ameen; «Wo ibaaddo! Noo durumma kakkohelattanna hikka raadii laano isin kassaanwa. ");
INSERT INTO bswl_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Hikki P'awuloosa ‹gene taɂibaaddotii kafelamero misilijjool waal lakkoyaan› amaa ul kaɂefesooni kaalaali anleennon giraan ul gamisa hesaa Taɂiisiya awuraajjaa dubbaa kagiro gosa kamooggan eeki gitakki koo yelerona ammanchchisaro isin issii kaddeetettaanna kamaaltteettaanya. ");
INSERT INTO bswl_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Hikka gara felo oottaanun tuffamanoya; hikka kaalaal anlleennon giraan Isiyaayinna alami dubbaa ibaaddo tahedoyisataro tanjiintti hedo kaɂart't'emisi min katolchcha laɂo kallayikkiya ami ibaaddo hedinara; jiinaankisena iggilissaminara.» ");
INSERT INTO bswl_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ibaaddona hikka kakkomaalare goorata aaloo amaraatere, «Kaɂefesooni ibaaddokotti Art't'emisi tanjiinttitta!» amaa okkeen. ");
INSERT INTO bswl_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Goorsewa katamaa dubbaayi shalago kee; gosana raattoo keere alattaanun kamek'edooniya ibaaddo kalleerana P'awuloosa wota sesseetaa kagire saatilaalkkeessa, Gaayosana Arsit'irokoosa aaterene madarri takkotusaraan banɂe raattoo tiittaa tabeen. ");
INSERT INTO bswl_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","P'awuloosa gosa tos bin dootatere; amaniil goɂameen usu goggobeenonkko tireen. ");
INSERT INTO bswl_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Taɂiisiya awuraajjaayi odonnati oɂabaankko kookkoo P'awuloosa ogeelaatareen, madarri takkotusaraan banɂe tos jabuuyi usu goggotaboonkko ibaaddo fareengureene usu ebaaten. ");
INSERT INTO bswl_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Gosana shalagaamere, koo ayees koo goɂayeesiro kakkalee ade takkalee ayeesaa okkaa gireen; gama kahori ibaaddo mewuun eserraa kukkuɂamero duuddo lakkokasanaaye. ");
INSERT INTO bswl_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Kookkoo taɂayihuudi una kalleere Iskindiri kaɂamamare ibaaddoti gosa orrokko shafeen beesen gosa hore kakkoɂaallisaren goorata; kookkoo ibaaddo usu madaari goggodogamiroon gorssee; Iskindiri isone wota dogamin dootere gosa c'alɂi goggoɂamiroo malaata tuse. ");
INSERT INTO bswl_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ayesuun goɂameen usu Ayihuudi laano ibaaddo dubba kakkoɂaddesare goorata, «Kaɂefesooni ibaaddokotti Art't'emisi tajjintitta!» amaa saatii lamakki gita yaaye tooyi okkeen. ");
INSERT INTO bswl_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ese katamaatikokki Waanna s'aafiti gosa c'alɂisere haa ame; «Isin kaɂefesooni ibaaddo! Katamaa taɂefesoonikki ibaaddo kanjjiinkki kaɂart't'emisi min katolchchana daruurkko tadayiddetto misiliittisee kaɂoorataro laano dubbaa dollee kaɂaddeesameya. ");
INSERT INTO bswl_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Haanssun, hikka kakkakatara maayyona mankkogginno maraan c'alɂi goggoɂanttaanunna jejjeraa ayees kameellan felanakko isiɂooratano dootisara. ");
INSERT INTO bswl_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Min katolchchana ansaamoon ogiraanna hedokkaanina anhabaaroon ogiraan ibaaddojja hittarraa aatteen emetteettaan. ");
INSERT INTO bswl_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Goortta, Demet'iroosana usune wota ogiraan bir taɂamamatto marc'c'o otumaraan kamootaraan ibaaddo gogire min kafirdda gira; odonnati oɂabaanna giraan; esee hatamaaggateen. ");
INSERT INTO bswl_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Hikkakko kakkalee isin hoosayin kadootteettaan ayees gogire, taseera shonggoyi diyaaminara. ");
INSERT INTO bswl_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Goorttun hittaari kalleero ayesuun, ‹Shalago kekkeeseran› amaminne goggomootamonkko no abssisara; ‹Hikki shalago mekkotti aalanttii keera› amami gohoosamnne kasinsso abbaab lakkoɂabnno.» ");
INSERT INTO bswl_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Hikka ayeese abbaabatere gosa goggodarɂaamiroo yele. ");
INSERT INTO bswl_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Shalago c'alɂi kakkoɂamare goorata P'awuloosa amaniil uumegure gorssee; susukkaamere ul kamek'edooniya tos seeyin bee. ");
INSERT INTO bswl_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Usu tarooraro banɂe dubbaa haafura kamoogganii ibaaddo gorssaa ul kagiriikki gee; ");
INSERT INTO bswl_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","eseenna diginni seed hamas's'ee. Ul kasooriya seeyin ekkaasataa giraanna Ayihuudi daba usu gutii fele mankkogire maraan, ul kamek'edooniyane abbaabayin goosate. ");
INSERT INTO bswl_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Kap'ayirihusa ere Sop'at'irosa tabbeeriya katamaakko, Ast't'irokkosina Sikonddusa tateselonk'k'e katamaakko, ul kaderbbeekokki Gaayoosa, Tikik'oosana T'irofmoosa T'imotoosa Taɂiisiya awuraajjaakko usune wota seeteen. ");
INSERT INTO bswl_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Hinɂi ibaaddojja hore seeteerene T'iroɂaadayi no ooreen. ");
INSERT INTO bswl_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Noo goɂameen kababoo baala roore giraan kafilip'isiyoosa ulkko markkafaa keennenne arri ken iso takkogiraan banɂe T'iroɂaada tos geennenne esee iso wota eselnnenne arri todoba hamas's'iine. ");
INSERT INTO bswl_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Almmakko tahoraarjjee arrii babo aamin raattoo kukkuɂamnne giraan, P'awuloosa tallami arri seeyin mankkohedere maraan, isone wota ayeesaa gire; ayeenssa hemeen t'eɂe taageeroo eeraase. ");
INSERT INTO bswl_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Noo kakkokukkuɂamnnenne fook'ii gutii kamooggan korroontta gire. ");
INSERT INTO bswl_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Awut't'ekkiisi kaɂamamere wodallaati koo maskootii gutii hamas's'ee gire; P'awuloosa ayees kakkoɂeerasare goorata dutisegure gafarate huddure isaage; fook'ii kaseedikko hegelddee iyye; kakkokeesiraan goorata kagoyero deen. ");
INSERT INTO bswl_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ayesuun goɂameen P'awuloosana dagegure unnu tos hussi amere kabalate abategure, «Neefo lakkobeetetto arooshalagantten» ame. ");
INSERT INTO bswl_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Abbaabategure ade fook'ii tos bee; babona ebsate amaniilnne wota aame; ul taabariroo ibaaddone wota tanjjiin ayeese abbaabatere kee seete. ");
INSERT INTO bswl_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ibaaddona hassu wodallaati goyikko kahesero min geese; hikkaniinna aaloo goggoɂinna helateen. ");
INSERT INTO bswl_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","No andde P'awuloosa k'op'ayin t'ayine markkafa tos seenne; esekkona markkafaa taɂasoosi katamaa tos seenne; hikka noo kakkoonyelnnenna P'awuloosa bagane taɂasooni katamaa taageeroo lukii seeyin mankkok'oppeere maraanye. ");
INSERT INTO bswl_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Taɂasoosi katamaa usune wota kakkoɂeselanne goorata usu aanttegunne wota markkafaayi ul kamit'iliini seenne. ");
INSERT INTO bswl_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tallami arri esekko keennenne Kiyoosi horee tagitto oddola araanjjaa abanne. Geebbari keene ul kasaammosi nak'inne; tallami arri andde ul kamilit'ini geenne. ");
INSERT INTO bswl_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","P'awuloosa taɂiisiya awuraajjaayi goorata goggobaannonkko amere taɂefesooni katamaa anttabooni iisi roorin doote; usu hikka kakkoonyelera kap'ent't'ek'ost't'e baala Iyyerusaalemi mutin mankkok'oppeere maraanye. ");
INSERT INTO bswl_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","P'awuloosa kamiliit'i ulkko taɂefesooni katamaa tos ibaaddo farere min kawaatti jaarsolee uumsise; ");
INSERT INTO bswl_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Iso usu tos kakkoɂemeetareen goorata, «Taɂiisiya awuraajjaa ani takkotabe arrikko haggaɂabere arggetto isinne wota misii ani gire isin kassaanwa; ");
INSERT INTO bswl_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Kaɂayihuudi dabakko kakkeeyi rakkoo in gogeetena, taɂammagantte obssiinna aaloo ootaa Goottawun handdaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Agarii horeenna leere min minkkisinii isin agaalssisaa giraan kamaaddiro dubba ani isinuun segeere kuwaarre, ayees koonna lakkohaasero. ");
INSERT INTO bswl_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ayihuudina leere Giriikki c'ubbokko gula gali Waa tos goggoɂabbaabanawunna Goottakkaani Yesuusaa goggoɂammannaawun ani iso seerera. ");
INSERT INTO bswl_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Giddanna eserraa goggee in kaginnaro haɂaddeesoonii Ayyaana K'ulluukkii ajajaamere iin Iyyerusaalemi tos seetanoyya. ");
INSERT INTO bswl_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Halleewo kuwaarre takkoseeye katamaa dubbaa Ayyaana K'ulluukki inne wota seetara; shaanona rakkoo in kaginatto laano iin segeera. ");
INSERT INTO bswl_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Halleewo kuwaarre kawaa kasinoo wongala agaalssisin Goottaa Yesuusakko ani kaɂatayeero handdaa goggussaye girikkeewun ani lakkoyaadinaro; neefotteewunna ani lakkonenɂeyisayinaro» ame. ");
INSERT INTO bswl_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Gidda gin isin dubba orroo maraamurara wononnati kawaa lallabaa gire; goortta hittakko horenbbaan bebbeedttee kaddeennon laano ani addeesara. ");
INSERT INTO bswl_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Haanssun isinkko odo koo gobbayena ani odonnati kaɂaboon laano hittaari isinuun ani addeesisara. ");
INSERT INTO bswl_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","K'ofa tawaa dubba ani isinuun segeera kuwaarre koonna ani kahaasera ayees lakkogiro. ");
INSERT INTO bswl_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ayyaana K'ulluukki isin Ep'p'is k'op'p'oosi yele shuumera; goortta isiɂoottisinuunna maateewun isiɂoorayeen; Waa erekkeessakki iigi kawodaatero amaniil foofa. ");
INSERT INTO bswl_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ani kokkoseeye goorata maateewun kanenɂeeyisannon hiyyeeyi aani bogikaɂatii ibaaddo isin orro katabnnaran ani kasowa. ");
INSERT INTO bswl_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Usumalee ibaaddo kookkoo isin orrokko kiigure kawoc'ac'aame agaalssisi agaalssisanoyi amaniil kamooggan isi tos aatinara. ");
INSERT INTO bswl_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Haanssun isin mete metee gees seeddun arriinna hemeenna ani ootaa kagorsseero shaadaa isiɂoorayeen. ");
INSERT INTO bswl_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Giddanna isin t'aabbisinna k'ulloolee orroo rittii isinuun sisin kadaanddaro Waawunna sinotteessakki haafuraan ani hadara sisayera. ");
INSERT INTO bswl_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ani tamaattaayyotti birnna, work'k'ii goorttun sarssi lakkohalchcheero. ");
INSERT INTO bswl_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Genetteeyi felayinnara; isiɂootteenna leere saatilaalttee gargaaraa girano isin metekkisinuun kassaanwa. ");
INSERT INTO bswl_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","‹Atatanokko kasisara kasommaasameya› kaɂamaro kagootta Yesuusa haafura shaadaa, genettaani felataa kawaate gargaarin kadootisaro raa kamooggan ani isinuun tusera.» ");
INSERT INTO bswl_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Hikka ame abbaabatere P'awuloosa dubbane wota gilbbisere Waa ebaate. ");
INSERT INTO bswl_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Dubbana ooterene P'awuloosa kabalateen abateeren anggateen. ");
INSERT INTO bswl_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Kakkaleekkona aaloo kakkogaddeeran, «Hittakko horenbbaan bebbeedttee lakkodinnattaan» mankkoɂamere maraanye; markkafa takkogiro banɂe taageraaninna usu sussukkeen. ");
INSERT INTO bswl_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Noo isokko kale beennenne markkafaa koranne K'oosi taɂamamatto oddola tos abanne; tallami arrina taruudi oddola tos gene; esekkona tap'at'ira katamaa tos seenne. ");
INSERT INTO bswl_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Esee ul kafink'k'e kaseetaro markkafa helannenne usuu tabinne seeto horeddeene. ");
INSERT INTO bswl_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Tak'op'iroosi oddola mina tabete haanssenne ul kasooriya duudaannenne kat'iroosi markkafa takkoɂaallaro seenne; markkafa c'aana esee mankkodagisinare maraanye. ");
INSERT INTO bswl_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Esee amaniil dootanne helannenne isone wota arri todoba adallaanne. Isona Ayyaana K'ulluukkii k'ajeeleren P'awuloosane «Iyyerusaalemi arooseette» ameeren segeen. ");
INSERT INTO bswl_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Noo esee kakkoɂadallaayinanne goorata kakkogudatare goorata, iso iinssenne seetottaani horeddeene; dubbana oorijoolkisoonnena yiisaaskkisonne wota taa katamaakko sar beesinanii no sussukkeen; labugiridiinna gilbbinsse ebaanne; ");
INSERT INTO bswl_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Nogoddaa gira aminnenne noo markkafaa tabnne; isona minkkisoo abbaabateen. ");
INSERT INTO bswl_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","T'iroosko keennegunne P'et't'ellemayisi tos gene; esee amaniilnne wota eselnne nogodda aantte abbaabanenne isone wota arri too hayine. ");
INSERT INTO bswl_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Tallami arri esekko beennenne K'isaariya gene; daak'oni todobakko koo kalleere wongalaawi P'ilp'oosakokki minii tabinenne usune wota hamas's'ine. ");
INSERT INTO bswl_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Usuun hegero kaɂayeesare deelelumma kaɂabanaaye deeleel afarro gire. ");
INSERT INTO bswl_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Eseenna arri tammooggan kakkohamas's'aane goorata Agaaboosa kaɂamamare kahegeroo kayihuuda ulkko emeete. ");
INSERT INTO bswl_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Hikki kahegerooti noo tos gabbalame; kap'awuloosa mowaano aatere issii isiɂootteessa genennona luk'k'ana shaategure «Ayyaana K'ulluukki hikka mowaanokokki odo Iyyerusaalemi kagira Ayihuudi hikkamalee usu shiigureen Ayizaabn roorisi usu sisinaraan amara» ame. ");
INSERT INTO bswl_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Hikka kakkomaalanne goorata noonna esee kagire ibaaddona P'awuloosa Iyyerusaalemi tos goggoseenonkko ebaanne. ");
INSERT INTO bswl_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","P'awuloosa goɂameen, «Isin haa ootaa wadanattee muun c'ubuc'ubuɂisattan? Ani shaamano iisaddeene Goottaa Yesuusakokki megeen Iyyerusaalemi goyiinna kaɂekkaasayeroya» ame. ");
INSERT INTO bswl_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Gorssakakkaani ani lakkoɂatayinaro usu mankkoɂame maraan, «Goortta tagootta feɂi halleeto» aminenne isaayinne. ");
INSERT INTO bswl_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Esee arri tic'c'ar adallaanenne huukkaani ekkaasanenne Iyyerusaalemi tos seenne. ");
INSERT INTO bswl_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","K'isaariyayi kagire amaniil kookkoo noonne wota emeete; isona min kaminaasoni goggofoolssannon usu tos k'ajeeliseen; hikki ibaaddotina t'aye kaɂammanere, alattaanun ul kak'op'iroosikkiye. ");
INSERT INTO bswl_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Iyyerusaalemi kakkogiyaanne goorata amaniilnna geggelooyi no k'op'ate. ");
INSERT INTO bswl_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Talamii arri P'awuloosana noonne wota Yayik'ooba tos seete; min kawaatti jaarsolee dubbana esee gitte. ");
INSERT INTO bswl_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","P'awuloosa dubbane nogodda aate abbaabatere, Waa garakkeessane Ayizaab orroo kafelero dubba toottoolli isoon sessegee. ");
INSERT INTO bswl_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Isona hikka kakkomaalareen goorata, Waa galateen; P'awuloosanena haa ameen; «Abbikkaani! Kuma kamooggani katootamira amaniil Ayihuudi orroo ogiraan dubbana seeraan owudettaamaranyan. ");
INSERT INTO bswl_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ayizaab orroo kagira Ayihuudi dubba yiiskkisin aroohamas's'issen goorttun wogaal aroofeltteen antte ati agaalssisaa seera kamuse goggoɂiggilsiranun yelatta amaa kaɂayeesamaro maaleeraan. ");
INSERT INTO bswl_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Goortta misi goyeleen iidira? Emeetottaa isoon maalano kahesooniya; ");
INSERT INTO bswl_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Haanssun noo kuunne kaɂamanno feli; noo orroo gefaa kaɂaba ibaaddo afarro gira. ");
INSERT INTO bswl_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Iso aati seedde isone wota leedde isiɂoottaa muc'c'isa; metekkisoo goggohoolaranun k'ulluukki min kawaawuun kasisamaro maragadekko isoon muri; hikka gofeltte ku gutii kaɂayeesamera dubba laɂo kallayikki laanona atina isiɂoottaa seeraan kaɂajajaamatto laanokkaa dubba iso kasaanwa. ");
INSERT INTO bswl_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Taɂayizaab unakko oɂammaneeraan adeen, tolchchaan jaarssamegure kabattoyero babo arooɂaantteen; iigina arooɂaantteen; c'uulɂaame kagoyero giddikonɂi soo arooɂaantteen; sharmmut'ummakko fakkima; taɂamatto murtti taɂabttetto dabddaabbee s'aafinne isoon farnnenna.» ");
INSERT INTO bswl_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Esekko abbaabatere P'awuloosa tallami arri ibaaddojja aate seetere isone wota isiɂoottessa muc'c'isate; kakkomuc'c'imaraan arrijjool maagoreeyyona metemetekisookki jaarsso maagoree sisaminaro addeesisin k'ulluukki min kawaa tabe. ");
INSERT INTO bswl_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Arri todobana gudayin kakkogabbalamatte goorata, taɂiisiya awuraajjaakko kaɂemeetere kaɂayihuudi ibaaddo P'awuloosa k'ulluukki min kawaayi mankkodeen maraan, gosa dubba kekkeesengureen usu abeen; ");
INSERT INTO bswl_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","«Ibaaddo kaɂisiraɂeel no gargaaraa! Gosakkaanina seerakkaani usumaleenna hitta banɂe inggaamaa mankkoseete dubbaa kaɂeselaro ibaaddo dubba kaɂagaalssisara hikka ibaaddotiya; hikkakkona karoore Giriikkiil k'ulluukki min kawaa tabisaa hitta k'ulluutti banɂe kabattoyisara usuya» haa amaa okkeen. ");
INSERT INTO bswl_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Hikka kakkonɂamerana t'aye katamaa taɂefesoonikki ibaaddoti T'irofmoosa P'awuloosane wota katamaayi orroo mankkodeeraan maraan, P'awuloosa usuna k'ulluukki min kawaa aate katabero aani isoon mankkollee maraanya. ");
INSERT INTO bswl_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Katamaa dubbana shalagaantte; gosana Minaminakko tiittaa emetere, P'awuloosa abere nattaa k'ulluukki min kawaakokki awudkko beesen; k'ulluukki min kawaakki ufaalna goorsewa c'ufeen. ");
INSERT INTO bswl_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Iso P'awuloosa lagadin kakkodootareen goorata «Taɂiyyerusaalemi katamaa dubba shalagaantte» kaɂamara handdaa ul karoomikki wotaadara kajereene kaɂajajaaro ibaaddoti gee. ");
INSERT INTO bswl_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Haanssun kaɂajajaarekkina wotaadaralnna kabooloo woyichchaal debee abere banneewa tiyaa ibaaddo tos seete. Ibaaddona kaɂajajaarekkina wotaadaral kakkodeyaare goorata P'awuloosa boc'aano iiseen. ");
INSERT INTO bswl_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kaɂajajaarekkina gabbalame P'awuloosa abere sanssalata lamaa goggoshaamiro ajajee; esekko abbaabatere ayyo laanona usu me felero addeesin dootere hoosate. ");
INSERT INTO bswl_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Gosana gamisa ayees koo goɂayeesiro, gamisa ade takkalee ayeesare; kaɂajajaarekkina gosa iyyaanakko kakkeeyi kak'ulleesamero ayees addeesin mankkowaatemaraan P'awuloosa kawotaaddara kambbi goggogeesirawun ajajee. ");
INSERT INTO bswl_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","P'awuloosa gaagatti banɂe kakkogeyaare goorata gosa dubba amara tameellanii kekkeengureen danoo geegisin mankkodootene maraan wotaadaral usu side seete. ");
INSERT INTO bswl_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Debee kasessetare gosana, «Hagoye!» amaa okkaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kajereene wotaadaralkokki kambbi usu tabisin kakkogabbalamereen goorata P'awuloosa jereenun kaɂajajaarekkine «Ayees koo ani kuun goggosegiroon feɂi sisatta?» ame. Kaɂajajaarekkina, «Ati tagiriikki heɂi kasso?» ");
INSERT INTO bswl_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","«Hayya, gidda enee shalago keesisegure kuma afar neefo kalagadero ibaaddo aattedde gaa kabak'attette ati Gibs's'iti lakkotteya?» ame. ");
INSERT INTO bswl_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","P'awuloosana, «Ani goɂameen Kilk'iyaa tagitto taɂaddeesantte tat'ersesi katamaayi kaɂumulamero Ayihuuditiya; ani gosaan goggoɂayeesiroo maganne feɂi sisi» ame. ");
INSERT INTO bswl_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Goggoɂayeesiroon feɂi kakkosisare goorata P'awuloosa gaagatti banɂee gutii aalleere gosa c'alɂi goggoɂamiroo gene wolli wolli ise; gosana c'alɂi kakkoɂamare goorata taɂibrayist'i heɂii haa amaa ayeesano haggaɂabe: ");
INSERT INTO bswl_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Abbilaalna Aabbolaalkkee! Hikkima ani gidda isi guukko tirataa ani isinuun kaɂayeesaro ayees maala!» ");
INSERT INTO bswl_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Isona heɂi taɂibrayist'i usu ayeesa giranttii kakkomaalareen goorata aaloo c'alɂi ameen; P'awuloosana ayees horediyaa haa ame; ");
INSERT INTO bswl_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Ani Kilk'iyayi tagitto tat'ersesi katamaayi kaɂumulamero Ayihuuditiya; takkojiinayera ade hitta taɂiyyerusaalemi katamaayiya. In kaɂagaalssiserana Gemaaliyaye; seera kaɂodolaal madaare kaɂagaalssayerona hittaari isin goggofelattankki malee Waawun haɂusaye kahandaareya. ");
INSERT INTO bswl_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ani amaniil dubba taalagadiroo kahoroorare ibaaddotiyye; babbaarnna heleel shiyaa minkashaano goggotabranun yelaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Hikki rummi laano tuuk'aamokokki woyichchatina tajaarssolee shonggoo dubba iin atotaatta. Usumaleenna tademask'o katamaayi ogiraan hinɂa ibaaddojja shiire Iyyerusaalemi tos keeniinna murrisin kadaanddeyisiro Demaask'ooyi tagitto unattisoo tos tas'aaferan dabddaabbee kakkoɂaatera isokkoya. ");
INSERT INTO bswl_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Ani seeye tademask'o katamaa tos gabbalamaa giraan arrii asasa derɂa kaɂatii ifa daruurkko in maraamure hank'k'aye. ");
INSERT INTO bswl_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Hassu goorata ani ulii iyye; ‹Saawula! Saawula! In muun horooratta?› taɂamatto yaaye maale. ");
INSERT INTO bswl_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","«Aninna, ‹Gootta! Ati ayyotta?› ame. «Usuna ‹Ati kahorooratto ani kanaazireti Yesuusaya› ame. ");
INSERT INTO bswl_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Iinne wota kagire ibaaddo kaɂifa hank'k'a deeran kuwaarre usu inne wota ayeesaa giraan yaayetteessa lakkomaaleran. ");
INSERT INTO bswl_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","«Aninna, ‹Gootta! Ani me fella?› ame. «Goottanna, ‹Kingudde tademask'o katamaa see; ati kafelnnatto kooko dubba esee kuun gachchosegaamira› ame. ");
INSERT INTO bswl_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ifa kahank'ayerokko kakkeeyi ani din mankkowaayere maraan iinne wota kagire ibaaddo genettee abere geggesaa tademask'o katamaa tos geegiseen. ");
INSERT INTO bswl_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Eseenna Hanaaniya kaɂamamare ibaaddoti koo gire; hikki ibaaddotina tademask'o katamaayi kagiro Ayihuudi dubbaa orroo kakkabajaame, seera kakkabajjaarena kaɂayyaana ibaaddotiyye. ");
INSERT INTO bswl_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Usu in tos emeete dollee aalleere, ‹Abbikki Saawula! Ilɂoɂootta haddeen!› ame; goorsewa ilɂoɂootti deen; ani usuna dee. ");
INSERT INTO bswl_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","«Usuna iinne haa ame; ‹Ati odojolalkkaanikki Hedokotti feɂi goggoɂaddeesson k'ulluukkina goggodeetonna yaayetteessana ati goggomaaltton t'aye ku assaabatera. ");
INSERT INTO bswl_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Hikkana kayelero ati kaddeetettona kamaalttetto maraan ibaaddo dubbaa hore ati usuun atokkeessa goggolleetonya. ");
INSERT INTO bswl_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Hayya, gidda ati me ooraatta? Kingudde megekkeessa uumaa t'ammak'ami; c'ubbokkaakkona aalissami.› ");
INSERT INTO bswl_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Esekko abbaabaye Iyyerusaalemi tos seeyeere k'ulluukki min kawaayi ebaataa giraan in salallisere raaga dee. ");
INSERT INTO bswl_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Goottanna iin mutere ‹Ati in maraan kaɂatotiinnatto ato iso atatana mankkowaayinnaran maraan haggac'c'imooni saami Iyyerusaalemikko bee› ame; ");
INSERT INTO bswl_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","«Aninna haa ame; ‹Gootta!› ani Ayihuudikokki min kaɂebi dubba seeyeere kuyeeyi kaɂammanero ibaaddo dubba ani iso kashiyerona kaboc'eero kasaanwa. ");
INSERT INTO bswl_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Atokkaa kalleere Isit'ifaanosa kakkolagadareen goorata ani metekkeewun kalagadero ibaaddo dollee aalleere ayeeskkisooyi isi aate gire; ani sarssikisoonna ooraa gire; ");
INSERT INTO bswl_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","«Goottanna, ‹Ul kaɂeerii kagiro Ayizaab tos ani ku mankkofarnnaro maraan kingudde see!› ame.» ");
INSERT INTO bswl_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Hitta taageeroo gosa dubba kap'awuloosa ayees c'ak'asaa gire; «Hikka aankkikki ibaaddo ulkko habbawo! Hikka aankkikki ibaaddo neefone girin lakkodootisaro!» amaa okkeen. ");
INSERT INTO bswl_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Isona okkaanna sarssikisoo k'aareen shafaa gorra eleddeesen darɂaa gireen. ");
INSERT INTO bswl_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Iso kaɂajajaara hikka kakkodeyaare goorata P'awuloosa kambbi kawotaaddaraal goggogeesirawun ajajee; gosana usuu gutii muun hikkamalee okkaaro addeesin amere boc'aamaa goggok'ok'k'oramiroo ajajee. ");
INSERT INTO bswl_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ayesuun goɂameen giiyi shishiyeeren boc'iin iso ekkaasataa giraan P'awuloosa usu dollee kaɂaalleere kabooloo woyichchatine, «Alattaanun ul karoomikki kalleero ibaaddoti tasisanttetto murtti kallayi isin usu goggoboc'itawun feɂi sisanttetta?» ame. ");
INSERT INTO bswl_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Kabooloo woyichchatina hikka maalere, iso kaɂajajaare tos seetere «Misi yelinya?» «Hikki ibaaddoti la karoomi ulkokki ibaaddotiyolla!» ame. ");
INSERT INTO bswl_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Kaɂajajaarena P'awuloosa tos gabbalamere «Alla iin segii; ati ul karoomikki ibaaddotitta?» ame; usuna «Ii haayya;» ame. ");
INSERT INTO bswl_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kaɂajajaarekkina, «Ani hikka ul karoomikki ibaaddoti laano maragade kamoogganii iminayera» ame; P'awuloosana «Ani ade taroomi sanniikko alayera» ame. ");
INSERT INTO bswl_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Haanssun esee usu k'ok'k'orin ekkaasate kagire ibaaddo goorsewa usukko fakkime; kaɂajajaarekkina alattaanun ul karoomikki kalleero ibaaddoti sanssalataa shaamano kakkoɂaddeesare goorata abssate. ");
INSERT INTO bswl_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Arri tallami kaɂajajaarekkina Ayihuudi P'awuloosa kakkomootera tarummi aalantti metto addeesin doote; haanssun katuuk'aamol woyichchaalnna tashongoo una dubba goggokukkuyisiranun ajajee; P'awuloosana min kashaanokko beesere iso horee aallise. ");
INSERT INTO bswl_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","P'awuloosa shonggooyi kagiro ibaaddo tichchise deegure, «Abbilaalttee! Ani hitta arri taageero Waayi horee kakkogire sammuu taɂidanttiye» ame. ");
INSERT INTO bswl_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Tuuk'aamolkokki woyichchati Hanaaniya ade tap'awuloosa hiɂi goggobasinaawun usu dollee kaɂalleero ibaaddo ajajee. ");
INSERT INTO bswl_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Hassu goorata P'awuloosa Hanaaniyane, «Ati barssayi tashigidantte goda aani kallaatta! Waa ku basirowa! Seerakki malee haajaattee firddin hamas's'ite giraan seera kallayi in goggobasinaawun ajajaattola?» ame. ");
INSERT INTO bswl_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Esee kagire ibaaddo ade P'awuloosane, «Kawaa tuuk'aamolkokki woyichchati habaaratta?» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","P'awuloosana, «Abbilaalttee! Usu tuuk'aamolkokki woyichcha laano ani lakkoɂaddeesero; aalanttina ‹Kagosa woyichcha gutii tameellan arooɂayeesse› kaɂamara kaseera mas'aafaa s'aafamera» ame. ");
INSERT INTO bswl_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","P'awuloosa esee kagire ibaaddokko gamisa Sodok'aawiil gamisana ade Farasaawiil laano addeesere, «Abbilaalttee; ani Farasaawilkko kaɂalayero Farasaawitiya; hikkima! Gidda firddi horee kakkonɂaallera tasisanttetto abddiinna goyikko kiyaanokokki aalanttiiya» ama yaayettessa t'ok'k'iɂisere shonggoyi kakukkumero ibaaddo orroo ayeese. ");
INSERT INTO bswl_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","P'awuloosa hikka kakkoɂayeesare goorata, Farasaawiilnna Sodok'aawil t'eɂee engge keetedde shonggoonna banɂe lama beete. ");
INSERT INTO bswl_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sodok'aawilnna «Goyikko kiyaano laagiro; erggichchaalnna laagiro, ayyaanana laagiro» goɂamiran Farasaawiil ade «Hikki dubba gira» ameen ammanaraan. ");
INSERT INTO bswl_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Usu goorata kaɂatii shalago kee; tafarasaawi una kalleere kookkoo seera kamuse oɂagaalssisareen keengureen, «No hikka ibaaddoti gutii koonna baas lakkohelnenno; ayyaana goorttun erggichcha usuun ayeesi girra; no me kanssa?» amaa dogameen. ");
INSERT INTO bswl_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Engge ataataa mankkoseette maraan ibaaddo P'awuloosa goggotatarshinnonkko kaɂajajaarekki abssatere wotaadaralnne «Dagaddeene P'awuloosa ibaaddo orrokko beesaddeen kawotaaddaraal kambbi tos aata koyeen» ame ajajee. ");
INSERT INTO bswl_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Tallami hemeen Goottaa P'awuloosa dollee aalleere, «Allamandde Iyyerusaalemii garakkee goggoɂatotitettoo, usumaleenna taroomi katamaayi garakkee atotiin dootisara» ame. ");
INSERT INTO bswl_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ul kakkobaare goorata Ayihuudi kukkuɂamere, P'awuloosa noo anllagadoon giraan kaamina lakkoɂaaminanno; bekena lakkot'aminanno; ameen ammateen. ");
INSERT INTO bswl_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Hikka dabaa isi kaɂaatere ibaaddo tootooyi afarttamkko kanjjiinye. ");
INSERT INTO bswl_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Isona tuuk'aamokokki woyichchaal tonssa jaarsolee tos seeteengureen haa ameen isoon segeen; «noo P'awuloosa anllagadoon giraan kaami ilkkii lakkoɂabnno aminne ataayinsse ammanttenna. ");
INSERT INTO bswl_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Haanssun isin shonggooyi kagiro ibaaddone wota isiɂaatteddeene ataayisseen kak'ok'k'oraattan ayees kagiro aani masuussisaa P'awuloosa isinuun goggokeennon kaɂajajaarokki hoosayen; noonna hittarraa usu haggeennon giraan usu lagadin ekkaasannenna.» ");
INSERT INTO bswl_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ayesuun goɂameen tap'awuloosa abbakokki ere hikka daba mankkomaalere maraan kawotaddaraal kambbi tabere P'awuloosaan segee. ");
INSERT INTO bswl_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","P'awuloosana kabooloo woyichchaalko koo uumegure, «Hikki unnu jereenun kaɂajajaarokkiin ani kaseginnara ayees gira mankkoɂamaro maraan usu tos geesii» ame. ");
INSERT INTO bswl_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Kabooloo woyichchatina unnu kaɂajajaarekki tos aate tabere, «Kashaamere P'awuloosa in uumere hikki unnu kuun kaseginaro ayees mankkoɂabo maraan ani ku tos goggogeesiron in ebaate» ame. ");
INSERT INTO bswl_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kaɂajajaarekkina taɂunnuu gene abe aate seetere, «Ati iin kaseginatta ayees meya?» amaa usu kalebeese hoosate. ");
INSERT INTO bswl_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Unnuna, «Ayihuudi kap'awuloosa ayees aaloo kak'ok'k'orro aani ligure geebbari shonggoo tos goggogeesirawun ku hoosayin hiɂi too leera. ");
INSERT INTO bswl_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Haanssun ati isoon ii arooɂantte; ‹Noo usu anlagadoon giraan babo lakkoɂaaminanno; bekena lakkot'aminanno› ame kaɂammatera afarttamkko karoorara ibaaddo usu lagadin mowaatera; gidda iso kaɂoorataran abbaabikkakkaa kaalaalya» ame. ");
INSERT INTO bswl_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kaɂajajaarekkina, «Hikka ayees ati iin segaano maayyonna aroosegite» amere unnu gafare. ");
INSERT INTO bswl_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Esekko abbaabatere jereenun kaɂajajaarekki kabooloo woyichchaalkko lama uumegure, «Hemeenkko saatii seed golleete tak'isaarya katamaa tos kaseero lama boolee wotaadaralnna faraddeelii kaɂolamaro todobaatam, lama boolee jereen kashafaro ibaaddo ekkaasen. ");
INSERT INTO bswl_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","P'awuloosana farad ekkaasenguren kaɂulee mootii Filkkiisi tos nogoddaa goggogeeron yela» ame. ");
INSERT INTO bswl_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Haa taɂamatto dabddaabbeenna s'aafe: ");
INSERT INTO bswl_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","K'elaawudoosa Lusiyoosakko; Kakkabajaantte kaɂulee mootii Filkkiisi! Nogodda kuun halleeto! ");
INSERT INTO bswl_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Hikka ibaaddoti Ayihuudi abire lagadin dootere; ani ade usu taroomi alattaan laanokkeessa mankkokaso maraan wotaadaralne wota geere haase. ");
INSERT INTO bswl_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Iso usu takkomootaraan aalantti metto addeesin dootere shonggotisoo tos ani farere. ");
INSERT INTO bswl_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Iso kakkomooterenna seerakisookokki garaan laano ani addeesera; ayesuun goɂameen goyiin goorttun shaanoon usu kageegisira ayees koonna laagiro. ");
INSERT INTO bswl_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Hikka ibaaddoti lagadin kafelamero daba kakkomaalare goorata ani usu ku tos fare; usu omootareenna usuu gutii kaɂabaan mooto ku horee goggoɂayeesirawun isoon segee. ");
INSERT INTO bswl_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Haanssun wotaadaralnna goggoɂajajaamerankki malee P'awuloosa hemeen t'eɂe abeen taɂantip'at'iresi katamaa tos geesen. ");
INSERT INTO bswl_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Tallami arri wotaadaral kafaraddeel ibaaddo P'awuloosane wota goggoseenawun yeleengureen kajereenee kambbi abbaabateen seete. ");
INSERT INTO bswl_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Kafaraddeel ibaaddona tak'isaarya katamaa tos kakkogeyaaren goorata dabddaabbee kaɂulee mootiwun siseengureen P'awuloosa usuu horee aalliseen. ");
INSERT INTO bswl_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Kaɂulee mootinna dabddaabbee nabbabere P'awuloosane ati eetii awuraajjaakottitta? Amaa hoosate; kakiliik'iya ibaaddo laano kakkoɂaddeesare goorata, ");
INSERT INTO bswl_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","«Ku omootaran kakkoɂemeteen goorata hitta haajaatta ani maalinnara» ame. Kaherodoosa min kawonoo orroo usu goggoɂooramiron ajajee. ");
INSERT INTO bswl_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Takken arrikko abbaabatere, tuuk'aamokokki woyichchati Hanaaniya jaarsolee toottookkona T'ert'elusi kaɂamamare waabii wota tak'isaarya katamaa tos seete; isona mooti kaɂulee Filikiisi tos seetereen P'awuloosa mooteen. ");
INSERT INTO bswl_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","P'awuloosa uumame kakkoɂemetere goorata, T'ert'elusi haa amaa mooto haggaɂabe; «Kakkabajantte Filikiisi! Garakkaanne nogodda tanjjiin no helannenna; bariisanokkaa kaɂidankkii gosakkaanun iggilissamano helamera. ");
INSERT INTO bswl_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Aaloo kakkabajjaantte Filikiisi; hinɂa oɂidan feloɂoottaa banɂe dubbaa goorata goorata kakkoɂatatanna galata kaɂatiitiiya. ");
INSERT INTO bswl_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Gidda goɂameen gooratakkaa habbaasonii giraan gabaabbinnaa ani kuun kasegaaro idanee no goggomaaltton ani ku ebaatara. ");
INSERT INTO bswl_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","«Hikki ibaaddoti noon dhukkuba kameellan leera, alami kagiro Ayihuudi dubbaa gutii shalago keesara, Naazirawi kaɂamamaro ibaaddo kak'ajeelisaroya. ");
INSERT INTO bswl_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","K'ulluukki min kawaanna battoyisin usu hedaa giraan no abnnenna; seerakkaani malee no usu firddin henddenne; ");
INSERT INTO bswl_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ayesuun goɂameen jereenun kaɂajajaarekki Lusiyoosa emeetegure hunna kaɂatiitii genettaanikko beese aatere usu omootareenna ku tos goggoseenawun ajajee; ");
INSERT INTO bswl_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Hikka noo usu gutii kamootinenno mooto dubba rummi laano ati metekkaawun usu k'ok'k'origudde addeesin daanddaatta.» ");
INSERT INTO bswl_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ayihuudi «Hikki ayees dubba rummiya» ameen mootokkeessaa isiɂaateen. ");
INSERT INTO bswl_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ul kabariisare Filikiisi gene malaatere P'awuloosa goggoɂayeesiroon feɂi sise; P'awuloosana haa ame abbaabe; Gees kamoogganun ati hikka gosaan kafirddaatto laano ani mankkokkaso maraan kakkomootamero mooton abbaabkkee ku horee ani gosisiro aaloo geggelaataya; ");
INSERT INTO bswl_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Waa hedoyisayiin taɂiyyerusaalemi katamaa tos goseeyekko arri tomonkko lamakko roori waatti ati metekkaawun addeesin daanddaatta; ");
INSERT INTO bswl_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","K'ulluukki min kawaayinna leere Ayihuudikokki min kaɂebii goorttun katamaa orroo maayyo wotana dogamaagiraan goorttun gosa meellaneen kekkeesaa giraan in lakkoheleeran; ");
INSERT INTO bswl_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Gidda in kakkomooteeren mooto dubbaan ato koonna keeniin lakkodaanddaaran. ");
INSERT INTO bswl_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ayesuun goɂameen ani hikka kuun addeesisin dootara; iso raa kat'araa kaɂamaraan ammanokotti rummi kalleero odojolaalkkaanikokki Hedo ani hedoyisatara; kahegeroolnna seerakokki mas'aafajjolii kas'aafamero dubbana ani ammanara. ");
INSERT INTO bswl_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Isona abddi goggoyelatarankki malee aninna k'ullooleenna c'ubbaalessaal goyikko kakkinaraan laano ani Waayi abddi yelatara. ");
INSERT INTO bswl_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Haanssun Waayinna ibaaddo hore tamuc'c'intte sammuu iin goggogirttoon arggetto ani is's'aamara. ");
INSERT INTO bswl_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Taɂiyyerusaalemi katamaakko bee gees kamooggankko abbaabayere, unatteewun kalleero kagarggaarssa maragadena Waawun kasisamaro meebaa ani aate emeeyera. ");
INSERT INTO bswl_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","K'ulluukki min kawaayinna iso in kakkoheleraan hikkawa felaa giraanya; usu goorata kamuc'c'imano seera ani gussaye gire; inne wota gosa kamooggan lakkogire; shalagona lakkokeero. ");
INSERT INTO bswl_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ayesuun goɂameen ul kaɂisiyakko kaɂemeetera Ayihuudi esee gire; iso in takkomootiran aalantti goɂabaan ku horee emeeyiren haɂayyeseen. ");
INSERT INTO bswl_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Goorttun shonggoo tos takkoseyeree ani kabaasera baasi gogiro hinɂi hittanii ogiraan ibaaddojja haɂayyeseen. ");
INSERT INTO bswl_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ogiraan iso orroo ani aalleere, ‹Goyikko kiyaano girowa mankkoɂame maraan hittaari firddaan isin horee aalleera› amere yaayettee t'ok'k'ise ayeesera; hikka kuwaarre kakkalee ani kafelera ayees laagiro.» ");
INSERT INTO bswl_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Filikiisi ade ammanokokki gara aaloo mankkokasanaaye maraan «Jereenun kaɂajajaarekki Lusiyoosa kakkoɂemeete goorata; haajaatisinun murtti ani sisirowa» amere iso gafare. ");
INSERT INTO bswl_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","P'awuloosa ooraa kagire kabboolo woyichchatine, «Aaloonna balchchumma hattirooni madaari oori; usu ogeelaataranna usuun kadootisaro dubba aatkakkoɂemeteen goorata aroottirtte» ame. ");
INSERT INTO bswl_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Arri tic'c'arkko abbaabatere, Filikiisi Durssilla taɂamamatte Ayihuuditi ooritteessane wota emeete; usu P'awuloosana uumsisegure Yesuusa Kiristoosa ammananokokki gara usu ayeesaa giraan maale. ");
INSERT INTO bswl_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","P'awuloosa gara kak'ullummaanna isiɂawodatanokokki gara emeeyin kagiro firddakokki garana kakkoɂayeesare goorata Filikiisi absatere, «Gidda see; iin taɂekkaatte arri ani ku gachooɂuumisisira» ame. ");
INSERT INTO bswl_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Filikiisi P'awuloosa usuun gene goggoɂambbayiroon abddi yelataa gire; haanssun arggetto P'awuloosa uumsise ayeesisaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Gees lamakko danbbenne P'ork'k'iyosa Fist'oosa banɂe tafilikisii tabe; Filikiisi Ayihuudi geggelaayisin dootere P'awuloosa goggoshaamee iise. ");
INSERT INTO bswl_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fist'oosa awuraajaatteessa takkotabere arrii seedkko abbaabatere K'isaariyakko Iyyerusaalemi tos bee. ");
INSERT INTO bswl_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Eseenna katuuk'aamol woyichchaalnna kookkoo tajinjjiin una taɂayihuudi P'awuloosa mootite; esekko Ayihuudi Fist'oosane, ");
INSERT INTO bswl_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","«P'awuloosa Iyyerusaalemi tos keensisigudde ayees kaɂidan noon feli» ameen ebaaten; hikkana kakkonɂameeren P'awuloosa raadii ooriguren lagadin mankkodooten maraanye. ");
INSERT INTO bswl_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fist'oosa ade «P'awuloosa kak'k'iisaariya min kashaanoo ooramaa gira; aninna gidda saami eserraa abbaabayi seeyinara; ");
INSERT INTO bswl_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Isin obariisaraan inne wota K'isaariya tos haseeten; P'awuloosa kabaasera baasi gogire esee hamooteen» ame. ");
INSERT INTO bswl_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fist'oosa arri siddeed goorttun arri tomonkko karooron goorata iso wota adallaatere K'isaariya tos dage; eserraa kakkogeyaare goorata tallami arri kafirddii arjjaata hamas's'eere P'awuloosa goggokeennawun ajajee. ");
INSERT INTO bswl_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","P'awuloosa kakkoɂemeete goorata, Iyyerusaalemikko kaɂemetere Ayihuudi maraamureen aalleenguren iso ato yelayiin kakkodaanddenoon mooto kaɂatii usu mooteen; ");
INSERT INTO bswl_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","P'awuloosana, «Ani kaɂayihuudi seera gutiinna leere k'ulluukki min kawaayi goorttun karoomi kawonolaal wono gutii ani kageegisera baas lakkogiro» amaa abbaab usuun sise. ");
INSERT INTO bswl_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fist'oosa ade Ayihuudi geggelaayisin dootere P'awuloosane «Ati Iyyerusaalemi tos seeyidde hitta haajaa esee iin horee firddaamin dootatta?» ame. ");
INSERT INTO bswl_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","P'awuloosa ade haa amaa abbaab usuun sise, «Hikkima! Firdda tukkulkki helayiin iin takkodootisaroo karoomi wonolaalkokki wono kafirddii arjjaata horee ani aalleera; atina aaloo goggokassoo ani Ayihuudi gutii kafelara baas koonna laagiro; ");
INSERT INTO bswl_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ani kabaasero gollee goorttun goyiin kageegisiro baas feli gogire goyikko hesinnara lakkoɂamaro; ayesuun goɂameen mootokiso laɂo kalliikki gollee maayona in isoon roorisi sisin lakkodaanddaaro; ani karoomi wonolaalkokki wono tos abeet amera.» ");
INSERT INTO bswl_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Hassu goorata Fist'oosa usuun markka osisaraanne wota ayeesere, «Karoomi wonolaalkokki wono tos abeet goɂantte wonolaalkokki wono tos seeyinnatta» ame. ");
INSERT INTO bswl_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Arri tic'c'arkko abbaabatere, wono Agirip'ana Berneek'e Fesit'oosane haballe nogoddaa emeette amin K'isaariya tos seeteen. ");
INSERT INTO bswl_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Esee arri tammooggan mankkohamas's'ee maraan Fist'oosa tap'awuloosa haajaa haa amaa wono Agirip'ana segee; «Filikiisi shiye kaɂiisere ibaaddoti koo hittanii gira; ");
INSERT INTO bswl_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ani Iyyerusaalemi takkogiree katuuk'aamol woyichchaalnna kaɂayihuudi jaarsolee hikka ibaaddotikotti haajaa iin abeet ameen abbaabateren ani usuu gutii goggofirddiroon in hoosaten. ");
INSERT INTO bswl_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","«Ani goɂameen ‹kamootamara kamootaro horee aallire kakkomootamare ayesuun abbaab ansisoon giraan kamootaamarekki roorisi sisano karoomi woga lakkoyo› ame ani isoon abbaab sise. ");
INSERT INTO bswl_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Haanssun omootareen kukkumeen hittarraa kakkoɂemeetaren goorata haɂadallaannooni tallami arrii kafirddii arjjaataayi ani hamas's'eegure P'awuloosa iyye hore goggoɂaallisirawun ajajee; ");
INSERT INTO bswl_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Omootareenna ayeesin usuu dollee kakkoɂaalliraan goorata ani usu ayees kameellan felera ame goggohederee kamootisiro ayees koonna lakkokeenen. ");
INSERT INTO bswl_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ayesuun goɂameen iso usune wota dogamaa kakkogireen ammanokkisookokki garana kagoyere ibaaddoti ‹Arddokkiya› ame P'awuloosa kaɂayeesere Yesuusakokki garayiye. ");
INSERT INTO bswl_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Aninna hikka aankkikki ayees k'ok'k'orin in mankkot'ibaro maraan P'awuloosane ‹Iyyerusaalemi tos seeyidde esee hikka ayees firddaamin dootaatta?› ame. ");
INSERT INTO bswl_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Usu ade haajaattessa karoomi wonolaalkokki wono goggodiyanttoon dootatare wonolaalkokki wonoon abeet usu mankkoɂamere maraan eserraa taafarroon min kashaanoyi goggogirroon ani usu ajajee.» ");
INSERT INTO bswl_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agirip'ana Fist'oosane, «Aninna hikki ibaaddoti ayeesaa giraan maalin dootara» ame. Fist'oosana «Geebbari maalttuna» ame. ");
INSERT INTO bswl_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Haanssun tallami arri Agirip'anna Berneek'e kawonoo sarssikkisoo sarssateenguren taɂatii kabajjaayi kajereenee woyichchaalnena kakkatamaa ibaaddo kajinjjiinne wota abeen emetengureen kafirddii min tos tabeen; esekko abbaabatere Fist'oosa P'awuloosa uumsise. ");
INSERT INTO bswl_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Haanna ame; «Wono Agirip'a! Isin no wota ogittan ibaaddo dubba maala! Ayihuudi ‹Hikki ibaaddoti hittakko horenbbaan neefone girin lakkodootisaro› amaa iyyaa Iyyerusaalemiinna, hittanii usu goggofirddaamiron in kahoosatereen isin kadeyaattan hikka ibaaddotiyye. ");
INSERT INTO bswl_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ani goɂameen usu kakkogooro baas koonna lakkohelero; usu karoomi kawonolaalkokki wono tos abeet mankkoɂamere maraan eserraa farin ani murttessaye. ");
INSERT INTO bswl_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Halleewo kuwaarre garakkeessa Goottakkee tos ani kas'aafiro kaɂaddeesame ayees koonna lakkoɂabo; haanssun gok'ok'k'ore kas'aafiro ayees hellowa amere isin horee suurewa wono Agirip'a! Hikkima ani ku horee aallisera. ");
INSERT INTO bswl_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kashaamero ibaaddo kat'ok'k'ime odonnati kaɂabo tos faraa giraan usu takkomootamero aalantti segaanawaatti iin gowumma aani leete mutatta.» ");
INSERT INTO bswl_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agirip'a P'awuloosane, «Isiɂootta maraan goggoɂayeesson kuun feɂi sisanttetta» ame; P'awuloosana genetteessa diriirssatere haa amaa isi guukko tirataa abbaab sise. ");
INSERT INTO bswl_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Ati wono Agirip'a! Ayihuudi in kakkomooteeren ayees dubbaa hittaari ku hore isi guukko kattirataraan abbaab gosisiro in geggelaayisara. ");
INSERT INTO bswl_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Kakkaleekkona ati kaɂayihuudi wogana dogamaa dubba madaartte kassa; haanssun obssii goggoc'ak'assoo ani ku ebaatara. ");
INSERT INTO bswl_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Ani yiisummaa kaye misii gire Ayihuudi in kasowa; horaarjjekko keesere gosakkee orroonna Iyyerusaalemii kakkogire girikkee kasaanwa. ");
INSERT INTO bswl_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Adena goorata kanjiinkko haggaɂabere in mankkokasaan maraan ammanokkaanikokki woga taɂataayisatto una orroo leere Farasaawilkko koo aani lii giranokkee atotiin godooteen atotiin daanddaaran. ");
INSERT INTO bswl_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Gidda mootamere firddiiwun hittanii kakkoonɂaallera Waa odolaalkkaaniwun kasisero kaɂammatoo haafura abddi yelatanoyiyya. ");
INSERT INTO bswl_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Hitta abddi tos geegin aaniitattaani tomonkko lama Waa arggetto hedoyisataa oorataa gireen; ati wono! Aninna kakkonmootaamere hitta abddikkotti aalattiiya. ");
INSERT INTO bswl_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Waa ogoyeraan goyikko kakkeesinaro laano isin dollee muun kaɂabddamoon lee mute? ");
INSERT INTO bswl_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«Ani metekkeewun kanaazireti Yesuusakokki mege hegakkeeyi neebaatano dootisara ame hedaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Iyyerusaalemi ani kafelerana hikkawaya; katuuk'aamol woyichchaalkko kaɂatayeera odonnati amaniil kamooggan minkashaano goggotabroon yelera; aninna iso olagadaraane wota isiɂaate gire. ");
INSERT INTO bswl_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Kamooggan Ayihuudikokki min kaɂebii ani iso murriisaa Goottaa goggohabaarrawun isoo gutii hunnoomaa gire; iso gutii aaloo amaraayere kakkalee sarre kagiro katamaal tos beere iso horooraa gire. ");
INSERT INTO bswl_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Hitta haajaawun katuuk'aamol woyichchaalkko odonnatina ajaja dubba atayere ani Demaasik'o seetaa gire; ");
INSERT INTO bswl_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ati wono! Ani raadii giraan arrii asasa kakkolaare goorata kaɂaritii ifakko karooran ifa ani dee; hikki ifa iyyeenna inne wota kasessetaro ibaaddo daruurkko hank'k'aye. ");
INSERT INTO bswl_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Noo dubba ulii iinne giraan taɂibrayist'i heɂii ‹Saawula! Saawula! Muun in horooratta? Taɂeeggatto dukutto gutii goɂaallite isiɂoottaa miirɂaatta› taɂamatto yaaye ani maale. ");
INSERT INTO bswl_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","«Aninna, ‹Gootta! Ati ayyotta?› ame. « ‹Goottanna, ani ati kahorooratto Yesuusaya› ame. ");
INSERT INTO bswl_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","‹Gidda goɂameen ki aallii; ani kuun kakkoonmutera gidda in takkodeetettoonna horenbbaanna ani kuun katusinaro kooko kahandaayinattona ato iin goggolleeton ani ku shuumera. ");
INSERT INTO bswl_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Kaɂisiraɂeel gosakkaakona ani ku kakkonfararo taɂayizaab genekko ani ku haasirowa. ");
INSERT INTO bswl_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ati Iilɂoɂoottisoo goggobbanttoonna mugudikko ifa tos iso goggobeesson k'alaada kas'alayeekko Waa tos goggoɂabbaabttoo yelnnara; isona iyye ammananokotti aalanttii c'ubbokkisookko shaaga helayinnaraan; oɂassaabameeraan orroonna rittii helayinnaraan.› ");
INSERT INTO bswl_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Haanssun ati wono Agirip'a! Daruurkko iin kasisamero raaga ani lakkodiidero. ");
INSERT INTO bswl_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ayesuun goɂameen t'ayi Demaask'ooyi kagira ibaaddo, debeenna Iyyerusaalemiinna kayihuuda ul dubbaayi kagira usumaleenna Ayizaabne adire c'ubbokko gula galigureene Waa tos goggoɂabbaabaranun ani agaalssisera; c'ubbokko gula galanokkisoo otusaraan felo goggofellaawun agaalssisera. ");
INSERT INTO bswl_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Hikkakkotti aalanttii Ayihuudina k'ulluukki min kawaayi giraan abeeren in lagadin hedeen. ");
INSERT INTO bswl_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Hittaari gin gargaarssa kawaa inkko lakkofakkimere; haanssun kic'c'arkkiwunna kanjjiinkkiwun atotaa hittanii ani aalleera; kahegeroolnna Musena t'ayi haa linnara kaɂameeraan ani ayeesera kuwaarre kakkalee koonna ani lakkoɂayeesero. ");
INSERT INTO bswl_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Isona kaɂayeeseran ‹Kiristoosa rakkoo atayinara; goyikko keyaanoyinna kahoraarjjee lee kafayyinna ifa kaɂisiraɂeel gosaanna kaɂayizaab gosaan tusinara› amereya.» ");
INSERT INTO bswl_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","P'awuloosa hikka ayeesaa giraan Fist'oosa, «P'awuloosa! Giddaa k'olanttetta;» «Kamooggan agaalsatano k'olamano tos ku geegisera!» amaa okkee ayeese. ");
INSERT INTO bswl_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","P'awuloosa ade haa ame abbaabe «Kakabajjantte Fist'oosa! Karrummiinna garakki ayeesara kuwaarre ani lakkok'olamero.» ");
INSERT INTO bswl_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Addeesise usuu horee ani kakkoon ayeesera wono hikka ayees kasowa. Hikki hetoo kafelamero mankkolleenon maraan wono kaɂaddeesinaro ani kasowa. ");
INSERT INTO bswl_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Wono Agirip'a! Ati kahegerool la abddaattolla? Kaɂabddaatto ani kasowa. ");
INSERT INTO bswl_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agirip'ana P'awuloosane, «Ati hikka kagababbankki goorataa orroo in amanii yelisiisin laatto» ame. ");
INSERT INTO bswl_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","P'awuloosana, «Goorata kagababbanna leere goorata kaɂeerii ati kaalaa anlleennon giraan hittaari ayeeskkee kamaalera dubba hikka shaanokkee kuwaarre in aani goggolleerawun ani Waa ebaatara!» ame. ");
INSERT INTO bswl_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Esekko abbaabatere wono, mootinna Berinik'k'e, isone wota hamas's'ee kagire ibaaddo dubbana kee. ");
INSERT INTO bswl_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Esekko been seetaa giraan, «Hikka ibaaddoti goyin goorttun shiisisiin kageegisiro ayees koonna lakkofelero» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agirip'ana Fist'oosane, «Hikki ibaaddoti wonolaalkokki wonowuun abeet amiwaatewa adda kafuramihaayeyya» ame. ");
INSERT INTO bswl_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Noo It'aaliyaa tos goggoseennon kakkomurttessamere goorata P'awuloosana kakkalee min kashaanoo kagire ibaaddo kaɂawugist'osa kajereenee ibaaddo orroo kagire Yuulyoosa kaɂamamare kabooloo woyichchatiwun siseen. ");
INSERT INTO bswl_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Isiyaayi labu giri abe obaalnne kaseetaro kaɂadiraamit'iyoni markkafaa tabnenne duudaanne; Teselonk'ee kagire kamek'edooniya ibaaddoti Arst'irokoosina noonne wota gire. ");
INSERT INTO bswl_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Tallami arri Sidoona tos gene, Yuulyoosa P'awuloosaan kaɂidankki mankkolleere maraan usu ogeelataraan tos seetere kadootisaro gargaarssa goggoyellawun isoon feɂi sise. ");
INSERT INTO bswl_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Esekko keennenne irggado foffol mankkokeyaa gire maraan tak'op'irosi oddola eeloo tabnenne markafa duudaatano horeddenne. ");
INSERT INTO bswl_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kilik'iyana P'infiliya enemarnne duudaanne kakkorooranne goorata kaliik'iya ulii tagitto Mura taɂamamatto katamaa tos geenne. ");
INSERT INTO bswl_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Esee kabooloo woyichchati It'aaliyaa kaseeyinnare kaɂiskindira markafa helegure usu markafaa no goggotabnnon yele. ");
INSERT INTO bswl_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Arri tammooggan laalaan duudaattaa abboosa kaɂatiitii K'enddoosi taɂamamatto katamaa geenne; irggado no horddi goggoseennonkko mankkotire maraan tasilmoona katamaakotti bood enemarnne roornnenne tak'ert'eesi oddola eeloo yelanenne seenne. ");
INSERT INTO bswl_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Abboosa kaɂatiitii giri giri abnenne kakkorooranne goorata talaasiya katamaa dollee tagitto, «Taɂidantti obaa» taɂamamatto banɂe geenne. ");
INSERT INTO bswl_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Duudaataa arri tamooggan mankkorooritetto maraanna kaɂagabuu goorata mankkoroore maraan hassu goorata beke orroo duudaatano kameellan mankkollee maraan P'awuloosa ibaaddo haa amaa seerise; ");
INSERT INTO bswl_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Isin ibaaddo! Hittakko horenbbaan duudaatanokkaani danoo kaɂabo laano iin mutara; sidanee gutiinna markafaa gutii kaalaal anlleennon giraan neefo taɂibaaddoo gutii taɂatii danoonna bayi ginnara.» ");
INSERT INTO bswl_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Kabooloo woyichchati goɂame gorssa kap'awuloosakko suure markafa kaɂajajaarana odo markafa kaɂayeesaran ayees maalaa gire. ");
INSERT INTO bswl_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Hasse obaa bat't'eessa roorissayiin mankko ekkaatanawaatte maraan gama kahori ibaaddo «Horddi duudaayin kadanddeenno golleene mina taɂelee iyaannena mina tahegelee iyaanne tagitta obaa Fink'k'e taɂamamatto tak'ert'eesi obaa geennenne bat't'essa esee roorssanna» ameen k'ofa keenen. ");
INSERT INTO bswl_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Abaraanttii tallogodoo ambbal basaa giraan kakkodiyaaren goorata iso goggohedatereeni kalleero aani isoon leere marc'c'o keeseengureen duudaayin keen; markkafa takkoɂaallerokko keengureene tak'ert'eesi oddola tonsse giri giri abateen rooreen. ");
INSERT INTO bswl_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ayesuun goɂameen haɂadallaannooni, «Iyurakuloon kaɂamamare irggado» taɂatii ambbalne wota oddolaatikko keegure beke keesse emeete. ");
INSERT INTO bswl_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Markkafana ambbali foffol shafi seeyin mankkowaatemaraan c'alɂi aminnenne ambbalii shafamaa seenne. ");
INSERT INTO bswl_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","K'eda taɂamamatto tic'c'artti oddola eeloo yelanne seetaa giraan abboosa kaɂatiitii markkafane wota taggitte wolaboti abnenne haasin daanddeene. ");
INSERT INTO bswl_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Markkafa oduudaren wolabo markkafa tos giiteen koriseengurene markkafaa wodaro mareen; markkafa Surttisi taɂamamatto c'eekamasttotti banɂee goggoɂoyinonkko abssatereen sharaa dagiseerene ambbalii shafamaa seeteen. ");
INSERT INTO bswl_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Irggado ataataa mankkoseete maraan tallami arrii markkafaa kac'aanamero huu orrokko kookkoo beke orddeesen lugudano haggaɂabeen. ");
INSERT INTO bswl_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Taseedi arri huu kamarkkafa genettisooyi aateen beke orro shashafeen; ");
INSERT INTO bswl_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Arri tanjjiin aritina barraajja mankkomutanawaaten maraan ambbalnna ataataa mankkoseette maraan goortta hesiin noo lakkodaanddaanno aminnenne ajubbaanne. ");
INSERT INTO bswl_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ibaaddo babo koonna haɂaamoonii tanjjiin arri adallaate; haanssun P'awuloosa isoo orroo aalleere haa ame; «Isin ibaaddo! Ani isinuun kaɂamare isin maaligittenwa K'ert'eesikko kiiwaattenwa hitti miirɂana bayi dubba isin lakkogiyaare. ");
INSERT INTO bswl_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Giddanna markkafa kaalaalya kamiirɂaminara kuwaarre isinkko maayyo gutiinna miirɂa lakkogeeto; haanssun allamandde arooɂabssatteen ame ani isin gorssaara. ");
INSERT INTO bswl_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ani kakkeessa kakkonlleerana ani kahedoyisatara Hedo kafarera erggichchati hemeenkka iyyee dollee aalleere, ");
INSERT INTO bswl_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‹P'awuloosa! Arooɂabssatte! Karroomi wonolaalkokki wono horee ati aallin dootisara! Hikkima! Kuunne wota kasesseetaro dubba Waa kuun amire iso goyikko haasirowa› ame iin segeera. ");
INSERT INTO bswl_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Haanssun isin ibaaddo allamandde! Waa hikka iin kasegeero kafelnnaro laano ani ammanara. ");
INSERT INTO bswl_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Golleenna ambbal oddola too tos geesii no shafinatta.» ");
INSERT INTO bswl_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Hemeen tatomonkko afarrii beke oɂadiriyaayi giridii ambbalii shafamaa seetaa giraan hemeen t'eɂe markkafa oduudatareen baga kageeran aani lee. ");
INSERT INTO bswl_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Haanssun eɂemo wodaroo shiyeereen bekee lugudi kakkoderaan goorata hisil siddootam lee; abaraan gac'c'imeeren wodaro abbaab kakkolugudiraan goorata hisil lootam gumbbi laano deen. ");
INSERT INTO bswl_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Markkafakkaani bagaa girii kagiro eɂemoo goggobasamoonkko abssatereen markkafakko haarre markkafa kakkoɂaallisaraan marc'c'o afar beke orro lugudeen; esekko abbaabaterene ul goggobariroo ebaatano haggaɂabeen. ");
INSERT INTO bswl_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Markkafa oduudatareen markkafa lugudi iisi bin mankkodootereen maraan markkafaa mina tahoreenne marc'c'o kalugudaraan aani leereen markkafa gutii tagitte wolabo beke orroo lugudeen. ");
INSERT INTO bswl_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Hassu goorata P'awuloosa kabooloo woyichchatinena wotaadaralnne, «Hikki ibaaddo markafa kaduudatara markkafaa gutii adabayi gohamas's'inoon isin hesiin lakkodaanddeetan» ame. ");
INSERT INTO bswl_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Haanssun wotaadaral wolabo kaɂabero wodaro gooseren goggofelk'itoo iiseen. ");
INSERT INTO bswl_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ul barin kakkoɂabbaabatare goorata dubba babo goggoɂaamiroo P'awuloosa ebaate; «Isin koonna kaami ilkkii haɂabooni arooɂadallatteenkko hittaari arri tatomonkko afaritta. ");
INSERT INTO bswl_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Haannuun babo goggoɂaanttaanun ani ebaatara; hikkina isinuun hunna sisirowa; koonna miirɂa isin lakkogeeto» ame. ");
INSERT INTO bswl_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Hikkana ame abbaabatere babo keesere dubbaa hore Waa galateere ebisate aamano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Hassu goorata dubbana ataateeren babo aameen. ");
INSERT INTO bswl_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Markkafaa orroo oginne noo raattoo lama boolennee todobaatamkko lenne. ");
INSERT INTO bswl_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Dubbana aame kakkobararare goorata takkaantette darggammaa beke orro lugudeerene markkafa fuffudaayiseen. ");
INSERT INTO bswl_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ul kakkobaraare goorata takkogeeraan banɂe lakkoɂaddeeseeran; ayesuun goɂameen baga giridii c'eekamasttotti eeloo girano deen; isoon godaanddaame markkafa esene baga beesin hedeen. ");
INSERT INTO bswl_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Markkafa takkoɂaallisareen marc'c'o bekee orroo fureen gafareen; usu goratawa kashankkala wodarool fureen; sharaa mina taɂambbalee tos t'ok'k'iserene baga bin seeteen. ");
INSERT INTO bswl_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ayesuun goɂameen markkafa eɂemo wota basamere muki ame horekko hegelddee k'amalamere kaɂaaɂinoon lee; mina tahaarenne ade gaashimallokko kakkeeyi eɂebano haggaɂabe. ");
INSERT INTO bswl_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Oshaameeraankko koonna girisi bi goggobeenonkko wotaadaral iso dubba lagadin hede. ");
INSERT INTO bswl_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Kabooloo woyichchati goɂameen P'awuloosa haasin mankkodootere maraan k'ofattisoo lakkoɂatatere; duuddowa giriso kakkasa t'ayi markkafakko beke orro iɂigure girisi baga goggobeeron ajajee. ");
INSERT INTO bswl_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Oheseereen adeen kaɂeɂebero markkafaa gutii hamas's'ireen goggobeerawun ajajee; hikka garaayi dubbana nogoddaa baga been. ");
INSERT INTO bswl_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Noo nogoddaa baga kakkoɂabatanne goorata baga takkoɂabanenne oddola Maltta taɂamamatto laano addeensse. ");
INSERT INTO bswl_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ese oddolaa kagire ibaaddo tasaadantto idane noon fele; hassu goorata idaamo ubatere ambbal mankkogitte maraan eleen bebbeesen no k'op'ateen; ");
INSERT INTO bswl_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","P'awuloosa taɂoroo sharffi kukkuyisere eleenii kakkolugudare goorata hoɂo kaɂeleeneekko kakkeeyi habeessa koo beere genetteessa iddeere gutii reere; ");
INSERT INTO bswl_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Kamaltta ibaaddo habeessa gene tap'awuloosa iddeere gutii kareerero kakkodiyaare goorata «Ogiraan hikki ibaaddoti neefo kalagaderoyya! Gaashimallokko nogodda gobeenna firdda kawaakko fallaadayi hesiin lakkodaanddeero» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","P'awuloosa ade habeessa eleen orroddeese hurggufe lugudere danoo toonna usu haggeennoni hese. ");
INSERT INTO bswl_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ibaaddo ade «Usu giddaa maar duddubire, goorttun derɂa ulii ii goorowa» amaa wochchaa gire. Ayesuun goɂameen iso goorata kamooggan c'ak'asaa giraan danoo toonna usu haggeennon tagitto kakkodeyaaren goorata k'ofattisoo iggilissateenguren «Hikki waalkko kooyya!» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ese no takkoginne banɂee dollee ese oddolaatikokki mooti Pupiliyosaawun erre gitte; hikki ibaaddoti minkkeessa no k'op'atere arri seed no goɂidan marttise. ");
INSERT INTO bswl_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Hassu goorata kapupiliyosa odo maar gubaanna erjjeetaa hawɂaamaa huddure gire; P'awuloosa usu tos tabere Waa ebaate; gene usuu gutii kayere fayyiise. ");
INSERT INTO bswl_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Hikki kakkolaare goorata ese oddolaa kagire kakkalee dhukkubaleessaal emetere fayyee. ");
INSERT INTO bswl_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ibaaddona noon ilabo kamooggan keenen; kabajjana tuseen; markafayi tabnenne seeyin kakkokeyaanne goorata noon kadootisaro dubba markafa gutii kayeen. ");
INSERT INTO bswl_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Diginni seed malttaayi adallaannenne bat't'eessa ese oddolaatii kaɂadallaatere kaɂiskindira markkafaayi tabnenne duudaanne keene; usu markafanna Diyosik'orosi kaɂamamare lakkuu waal kaɂabo malaata abanaaye. ");
INSERT INTO bswl_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Noo Siraakusii taɂamamatto katamaa geennenne esee arri seed hayine. ");
INSERT INTO bswl_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Esekkona badine maraamurnne Regiyu taɂamamatto katamaa geenne; esee arri too hayinenne logodo mankkokeere maraan tallami arrii taputtiyolusi katamaa seenne. ");
INSERT INTO bswl_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Esee amaniil helannenna no isone wota arri todoba goggohamas'iinnon ebaaten; esekko abbaabanenne taroomi katamaa tos seenne. ");
INSERT INTO bswl_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Taroomi katamaayi kagire amaniil garakkaani kakkomaalaren goorata taɂafiyoosi giyya goorttun seed tabariisanoo taɂamamatto banɂe taa geeranii no k'op'ayin emeeten; P'awuloosa iso kakkodeyaare goorata Waa galategure goggoɂinna helate. ");
INSERT INTO bswl_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Taroomi katamaa kakkotabanne goorata P'awuloosa usu ooraa kagire wotaadarane wota kalekkalee esee goggogirroon feɂi siseen. ");
INSERT INTO bswl_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Arrii seedkko abbaabatere P'awuloosa taroomi katamaayi kagiro kajiinjjiin kaɂayihuudi ibaaddo uumsise; kakkokukkuɂamare goorata, «Abbilaalttee! Ani kaɂisiraɂeel gosaanna kaɂodolaal seera gutii ani tageegisera miirɂa laagitto; halleewo kuwaarre Iyyerusaalemi shaamegure karoomi ibaaddon roorssame sisame. ");
INSERT INTO bswl_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Karoomi ibaaddo in k'ok'k'oreen abbaabatereen goyiin kageegisiro baas helana mankkowaateen maraan in adda gafarin hedeen. ");
INSERT INTO bswl_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ayihuudi ade adda furamanokkee kakkoneebaataren goorata ani ade wonolaalkokki wono tos abeet amano iin kahesoon lee; golleenna ani gosakkee kakkomootira ayees iin laagire. ");
INSERT INTO bswl_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Giddanna ani isin kakkoɂuumssisera isin diinna isinuun segin amereyya; ani hikka sanssalataayi kakkoshaamera gosa kaɂisiraɂeeliin tasisanttetto abddikkotti aalanttiiya» ame. ");
INSERT INTO bswl_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Isona, «Kayihuuda ulii garakkaakotti haajaawun tas'aafanttetta dabddaabbee no lakkogeetetto; hittarraa kaɂemeetero ibaaddokko koonna garakkaa tameellan odu kaɂayeesera laagiro. ");
INSERT INTO bswl_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Hikka ati kahedoyisatto ammanokka banɂe dubbaayi ibaaddo kaneebaataro no kanssowa; haanssun k'ofatta metto noo maalin dootanna» ameen. ");
INSERT INTO bswl_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","K'at'aro abeen abbaabaterene raattoo leen minkkeessa tos emeeten; Usuna barikko haggaɂabere taa hemeen geeroo wononnati kawaa atotaa k'ofatteessa isoon segee; iso ammanchisiin kamuse seerakkona kahegerool mas'aafajjolkko beesi tusaa gara kayesuusa iso agaalssise. ");
INSERT INTO bswl_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Kookkoonna usu kaɂayeesero haafura ammaneen; kuuki ade lakkoɂammane. ");
INSERT INTO bswl_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Isona isiɂisirroo hiɂittoo anlleennon darɂaameen. Golleenna iso darɂaamanakko horene P'awuloosa ayeeskkotti yeepa goosaa, «Ayyaana K'ulluukki kahegeroo Isiyaasakokki garane odojolaalkkisinun kaɂayeesere rummiye! ");
INSERT INTO bswl_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","« ‹Usu kaɂayeesere haafurana hikkaya, Hikka gosa tos seegudde isin maalano maalattanwa, halleewo kuwaarre lakkoshaadattaan; diyaannonna deetaanwa, halleewo kuwaarre lakkokokaattan, ami isoon segii. ");
INSERT INTO bswl_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Hikka ibaaddokotti wodana dillaafattetta; nebettisona duuddetta, ilɂoɂoottisona t'ip'imeeraan, hikkamalee lii waatewa, Ilɂoɂoottisooyi diigureen, nebetisoyiinna maaligureen, wodanattisooyinna shaadigureen, Iso in tos abbaabayi gireenwa aninna iso fayyisi girare› » ame. ");
INSERT INTO bswl_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","«Goortta fayyinna kawaakokki handdaa Ayizaabn kafaramero laano isin goggoɂaddeessanun ani dootara; isona maalnnaraan» ");
INSERT INTO bswl_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","P'awuloosa hikka kakkoɂayyeesare goorata Ayihuudi aaloo dogamaa esekko been seeteen. ");
INSERT INTO bswl_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","P'awuloosa safo mure kakkohamas's'eere minii gees lama duuddo hamas's'ee; usu tos kaɂemeetaro ibaaddo dubbana k'op'atare; ");
INSERT INTO bswl_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Wononnati kawaa lallabaa gara kagootta Yesuusa Kiristoosa jabuuyinna balchchummaayi agaalssisaa gire.");
INSERT INTO bswl_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Kayesuusa Kiristoosa diyyiinna kafaramero liin kaɂuumamerokkona wongala kawaatun woyyuu kalleero P'awuloosakko kafaramero handdaaya. ");
INSERT INTO bswl_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Haanssun wongala kahegeroo tonsse k'ulluukki mas'aafayi t'ayite Waakko abddi sisanttetta. ");
INSERT INTO bswl_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Hikki wongalana ere maraan sooyi sannii tadaawutekko mankkolleewun, ");
INSERT INTO bswl_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","K'ulluukki Ayyaanakkeessayi ade goyikko kiyaanokokki kaɂatii hunnaayi ere kawaa lee mankkomute maraan Goottakkaani Yesuusa Kiristoosa maraanya. ");
INSERT INTO bswl_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Usu kakiristoosa megeeyi Ayizaab dubbaa goggoɂammannoonna goggoɂajajaamiroon yelin usukokki garane kafaramero tayelssisso sino no atannenna. ");
INSERT INTO bswl_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Isin metekisinuun oyesuusa Kiristoosa goggolleetawun Waa oɂuumero orrokkottan. ");
INSERT INTO bswl_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Waayi ogeelaantteettanna k'ulloolee liin oɂuumanttettan Roomii ogittan dubbaan, Waa Aabbokkaani, Goottaa Yesuusa Kiristoosa sinonna nogodda isinuun halleeto. ");
INSERT INTO bswl_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Dubbaankko t'aye, ammanokkisin alami dubbaa mankkomaalssamero maraan isin dubbaan ani Waa Hedokkee kayesuusa Kiristoosa garane galataara. ");
INSERT INTO bswl_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Arggetto ebikkeeyi ani isin goggoshaadaroo, kaɂere wongala lallabaanoo wodanakko ani kakkonhanddara Waa usu atokkeeya. ");
INSERT INTO bswl_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Arggetto ebikkeeyi ani isin shaadara, gidda ade feɂi tawaayi ani isin tos goggoɂemeeroon raa iin goggobanamiro ebaatara. ");
INSERT INTO bswl_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Goggoɂataattaanun isin kayello ayyaanakkokki ilabo belɂeesi sisininna din haalchara. ");
INSERT INTO bswl_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Hikkina isinna aninna metemetekaani ammanoo isiɂisiɂorroo goggoɂataannonya. ");
INSERT INTO bswl_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Abbilaalttee! Ayizaab orroo Waa kaɂammanaro ibaaddo goggohelayeroo, isin orroo usumalee Waa kaɂammanaro ibaaddo helayiin dootere, ayesuun goɂameen kamooggan goorata isin tos emeeyin k'oppee giraan, gidda gin geggaanawaattikkee goggoɂaddeessanun dootara. ");
INSERT INTO bswl_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Kagirikki ibaaddowunna leere koonna kakkasootun, k'arooleewunna leere oshaadootun wongala agaalssisin ani anza aba. ");
INSERT INTO bswl_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Roomii ogittaan isinuunna wongala lallabin ani kakkonhalchchaara haanssunya. ");
INSERT INTO bswl_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ani wongalaayi lakkomullaaro; hikkina horaarjje Ayihuudin debeenna Ayizaabn kaɂammanaro dubbaan hunna kawaayya. ");
INSERT INTO bswl_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Wongalaayi k'ullumma tawaa muttetta; k'ulluukki ammanoo girara amame goggos'aafamerooya; «k'ullummana horaarjjekko taagachcho geeto kakkohelamatta ammano kaalaaliya.» ");
INSERT INTO bswl_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Meellaneeyi rummi buk'een oɂaberaan, Waa abssiwaattitisoyinna meellanettiso dubbaa gutii engge tawaa daruurkko emeeyinatta. ");
INSERT INTO bswl_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Gara kawaa addeesano kadaanddamara isoo dollee kaɂaddeesameya; aalanttina Waa isoon addeesisera. ");
INSERT INTO bswl_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Alami aroomet't'aamekko haggaɂabegure tamutoon yadalii tawaa hikkina jiruu jiroommakki hunnana Hedo laanokkeessa usu tamet'eero met't'a dubbaa gutii mutara; haanssun ibaaddo kabbaasaro baasuun kakkoɂaalaro lakkoɂabo. ");
INSERT INTO bswl_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Iso Waa gomalabeenna duuddo Hedo laanokkeessa lakkokabajeen; galatana lakkosiseen; ayesuun goɂameen yaadakiso il kallayikkina tashaadon wodanattiso taduudde leete. ");
INSERT INTO bswl_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","K'aroonna goɂameenna gowoolee leen; ");
INSERT INTO bswl_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Arddokki Waakotti kabaja kagowaaro ibaaddonna kimbirijool, sulaalenna ulii tagitamatto met't'akotti middi aani kamet't'aameroon kabaja siseen. ");
INSERT INTO bswl_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Haanssun Waa c'ubboo taɂammaganttetto wodanattisookokki halchcha isi isirroo maarkkiso goggobattoyisarawun k'ullumma kallayitti esella tasooyetun roorise sise. ");
INSERT INTO bswl_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Hikkina kakkonlleera rummi tawaa t'araa mankkoɂiggilisseen maraan, kamet't'erokotti banɂee kamet't'amero mankkohedoyisateen maraanna mankkohanddayeen maraan, kamet't'eera jiruu jiroommaan kasommaasameya; hamiinɂi. ");
INSERT INTO bswl_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Hitta aalanttii Waa iso kamulliisiro halchchakkisoowun roorise sise, heleelkisona ade yadaliittisoowun tadootisatto esella yadaliittisoo talleennoon eseellaan iggiliseen. ");
INSERT INTO bswl_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Usumaleenna babbaar yadaliittisoowun kadootisaro heleelne wota eselano iiseengureen isi isirroo halchcha kasooyetii gubateen; babbaar babbaarnne wota huddure; omeellan feloɂoottisowun tadootisatto murro metekisooyi gutii keenateen. ");
INSERT INTO bswl_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Hikkakkona karoore yaadakisooyi Waa malabano laɂo lakkoɂabo amanokko kakkeeyi, felin kandootisoon goggofellaawun Waa laɂo kallayitti sammuuwun roorise iso sise. ");
INSERT INTO bswl_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Haanssun baasi, meellanee, gap'igap'aano, miigge, t'iibbe, neefo lagadano, enggee, sobano, kameellanee halchcha dubbaa oɂammagameeraan, usumaleenna ohamataraanyan; ");
INSERT INTO bswl_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Ibaaddo mege obaasaraan, Waa odiidaraan, ohabaararan, koorameessana ifissaaddoleyan; meellane kakkofelaraan raa odootaran, oɂumuleeraawun oɂajajaamoon, ");
INSERT INTO bswl_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Oshaadoon, taɂameen ofuraraan, geelanjje kallayinɂina shaaga kallayinɂiyan; ");
INSERT INTO bswl_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Hikka ofelaraan dubbaan goyi dootisara; kaɂamaro likkiikki kalleero seera kawaa addeesa giraan hikka ayees felano kaalaal anlleennon giraan hinɂa aanɂinɂi felo kafelaro ibaaddona ataayisaran. ");
INSERT INTO bswl_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Haanssun kakkalee ibaaddo gutii kafirddatta ati, kakkoɂaalatto lakkoɂabtto; kakkalee ibaaddo gutii firddaa isiɂoottaa gutii firddaatta; hassu ati kafirddiitetta ibaaddoti kafelero atina mankkofelatto maraanya. ");
INSERT INTO bswl_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Hikkamalee ofelaraan gutii firdda kawaa likkii laano kanssowa. ");
INSERT INTO bswl_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Goortta ati ibaaddoti kakkalee gutii firddaa, usuwa kafelatto golleete firdda kawaakko kahesso aani laara? ");
INSERT INTO bswl_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Muu anjjire tawaa c'ubbokko gula galano tos tageggeesatto laano anɂaaddeson idanena daanddaanona, obssikkotti durumma tuffaatta? ");
INSERT INTO bswl_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ayesuun goɂameen taduuddena c'ubbokko gula tagaloon wodanattaakotti aalanttii likkiikki firdda takkoɂemetaro taɂenggee arri tawaayi isiɂoottaayi gutii engge goggojiinaatto yelatta. ");
INSERT INTO bswl_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Waa ibaaddon mete metee feloɂootteessakki malee sisinara. ");
INSERT INTO bswl_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Kaɂidan kalleero ataayi felanoo kabajana, gaashana odootatarawun jiruu jiroommakki giri Waa sisinnara. ");
INSERT INTO bswl_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ayesuun goɂameen isi ogeelataraan rummi iiseen meellane felaa osesseetaran gutii firdda kawaanna engge ginnatta. ");
INSERT INTO bswl_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Meellane kafelero ibaaddo dubbaa gutii t'ayi Ayihuudin esekko Ayizaab gutii rakkoonna c'inik'k'ii leeta. ");
INSERT INTO bswl_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ayesuun goɂameen taɂidan kafelaro ibaaddo dubbaa gutii t'ayi Ayihuudin esekko Ayizaabn galata, kabajjana nogodda leeta. ");
INSERT INTO bswl_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Waa maayyoonna lakkoɂululisaro. ");
INSERT INTO bswl_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Seera kamuse kallayii c'ubbo kafele dubba seera kallayii bayinara, seera isoon giraan c'ubbo ofelaraan seeraayi firddaaminaran. ");
INSERT INTO bswl_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Aalanttina Waayi horee k'ulloolee oɂamamaraan seeraan oɂajajaamaraan kuwaarre seera omaalaraan lakkoyaan. ");
INSERT INTO bswl_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Seera kamuse kallayikki Ayizaabl goggokasanayenii seera kasegaaro ayees felaraan hitta aalanttii seera gowaattamena kakkiso kakkasanaayen seera mankkoɂabaan maraan felin kadootisaro kasaanwa. ");
INSERT INTO bswl_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Hikkina yadaliittisooyi seera kamuse kasegaaro ayees dubba wodanattisooyi kas'aafamero laano tusara; adena Samuuttiso isoon ato laatta; sammuutiso arri toottoo wok'asaatta; arttoottoonna gargaaratta. ");
INSERT INTO bswl_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Hikkina kakkolinnara ani kaɂagaalssisero kawongala haafura malee Waa Yesuusa Kiristoosa tonsse ibaaddo kafelero siyame kagiro ayees gutii takkofirddinaro arrii kaɂaddeesame leera. ");
INSERT INTO bswl_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ati ani Ayihuudiya goɂantte, seera kamuse kaɂammanattona Waanne wota tagitto esellaa kakkooraatta, ");
INSERT INTO bswl_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ati feɂi tawaa addeesatta; Seera mankkoɂagaalssattetto maraan taɂidan felano kassowa. ");
INSERT INTO bswl_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Ati ilɂo odeyaannotun horehayite kageggeesatto golleete, mugud ogiranunna ifa laanokkaa isiɂoottayi kaɂammanaatto golleete; ");
INSERT INTO bswl_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Seeraayi tahelattetto k'arummakkona rummikko kakkeeyi kakasootun gorssa sisaa, yiis Kaɂagaalssisatto golleete. ");
INSERT INTO bswl_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Goortta ati kakkalee kaɂagaalssisatta isiɂoottaa lakkoɂagaalsissaattoya? Aroohette antte kasegaatta ati metekkaawun hetatta. ");
INSERT INTO bswl_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ati ibaaddone sharmmut'aano lakkodootisaro kaɂamatta atiwa sharmmut'aatta; ati tolchcha kadiidatta min kaɂebi saamatta. ");
INSERT INTO bswl_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ati seeraayi kakkooraatta seera baasaa Waa yeraasatta. ");
INSERT INTO bswl_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Hikkina, «Aalantti tattisinii mege kawaa Ayizaab dollee habaaraminara» amame goggos'aafamerooya. ");
INSERT INTO bswl_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ati seera kamuse kaɂooraatto golleete hamas's'isamano laɂo abowa, seera kamuse kabbaasatto golleete ati adde kahamas'iisamoon giro aani laatta. ");
INSERT INTO bswl_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Anhamas'iissamooni ogiraan seera kamuse kaɂajajaaro kaɂoorataraan golleen, kahamas'iisamero aani lakkotootamaranya? ");
INSERT INTO bswl_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ati, kas'aafamera seera kamusee giraanna kahamas'iisanttetto leete giraan seera gobaasse sooyi kahamas'iisamoon giro leete seera taɂooraatta taɂayizaab una ku gutii firddinnatta. ");
INSERT INTO bswl_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Ibaaddoti koo oguute oolaali ani Ayihuudi leera goɂame Ayihuudi lakkollaaro, karrummii hamas's'isamano kasaree kasooye seera lakkoyo. ");
INSERT INTO bswl_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Ayesuun goɂameen ibaaddoti koo Ayihuudi kakkollaara kaɂorroo ayyonnati Ayihuudi lii gomuteya; hamas's'isamano karrummii hamas's'isamano kakkollaara kas'aafamero seera kamuseeyi anlleennon giraan ayyaanaa wodanakko hamas's'isamano golleeya, hikka aankkikki ibaaddokko galata kakkohelatara Waakkoya kuwaarre ibaaddokko lakkoyo. ");
INSERT INTO bswl_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Hayya Ayihuudi laanokkotti laɂo metta? Hamas'issamano me laɂo aba? ");
INSERT INTO bswl_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Maamisikki raadiinna Ayihuudi laano laɂo tammooggantta, dubbaankko t'aye haafura kawaa hadaraa kakkonsisamera isoonya. ");
INSERT INTO bswl_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ayihuudikko kookkoonna ammano gowaayigireen ammano waattikkiso abddamano kawaa laɂo kallayikki yelara? ");
INSERT INTO bswl_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Duuddo lakkoyello! Ibaaddo dubba t'araameessa golleenna, Waa goɂameen karrummiya; «Haafurakaakko kakkeey karrummii laatta; Diinakkaanna firddaa awodinatta» amame goggos'aafamerooya. ");
INSERT INTO bswl_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Meellanetaani k'ullumma tawaa aaloo tatusatto golleete me amin daanddaanna? Waa noo gutii enggetatteessa keenano rummi kafirddaro lakkoyo amanoya? Yaada kaɂibaaddo aani ayeesara amanoya. ");
INSERT INTO bswl_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Ogiraan haa liin lakkodaanddaaro; hikkamalee lii girewa Waa alamii gutii misii firddin daanddaara? ");
INSERT INTO bswl_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","«Ani t'araameessa laano Waakkotti rummi katusarona, kabaja kaɂadaro gollee, c'ubbaaleessa amame gidda gin misi firddaamara?» ");
INSERT INTO bswl_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","«Idane goggoɂemeettoon meellane felnna amaraan amaa ibaaddo kookkoo goggoɂayeesareeyya;» hinɂa ibaaddojja gutii kaginnara firdda likkiiya. ");
INSERT INTO bswl_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Goortta me aminanna noo isokko rooranna? Duuddo lakkorooranno; Ayihuudina leereen Ayizaab, c'ubbo orroo girano t'ayine addeesinsse seginenna. ");
INSERT INTO bswl_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Haa amame goggos'aafameroo, «Koonna duuddo k'ulluukki lakkogiro; ");
INSERT INTO bswl_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Kashaadara laagiro, Waa kadootara koonna laagiro. ");
INSERT INTO bswl_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Dubbana shirmeraan Raattoo laɂo kallayinɂi leeraan, Taɂidan kafelara maayona duuddo laagiro.» ");
INSERT INTO bswl_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Hiɂittisona kameellan ayees ayeesin kabbaaname gumbbi kak'amal aanitittitta; Errebkisona sobaanje jiinaatara, Hiɂitisookko kabeyaara ayees marzzii tahabeessa aankkikkiya; ");
INSERT INTO bswl_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Hiɂittiso k'anggoonna kaɂokokootaro ayeesii taɂammaganttetta; ");
INSERT INTO bswl_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Luk'k'aɂoottiso ibaaddo lagadin ojjeeraranyan; ");
INSERT INTO bswl_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Kakkoseetaraan raakkisoo dubbaa baanowunna rakkoowun aalanttiyaan. ");
INSERT INTO bswl_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Kanogoddaa raanna lakkokasaan. ");
INSERT INTO bswl_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","«Waa abissatano suure isoo dollee lakkomutaro.» ");
INSERT INTO bswl_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Kaseera ajaja kakkondootisara seera hegelii obaraarawun laano kanssowa; hitta aalanttii ibaaddo kaɂaalaro waatere c'alɂi amara; alami dubba firdda kawaayi kabbaasero linnara. ");
INSERT INTO bswl_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Haanssun seera kamuse ooratanooyi maayona Waayi horee k'ulluukkiya amamiin lakkodaanddaaro; seera ibaaddo dubba c'ubbaaleessa laano tusara. ");
INSERT INTO bswl_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Gidda goɂameen Waa ibaaddo kakkok'ullooyisara seera kamusekko kalekki raayi laano tusara; hikki Museyinna kahegerooyi atotaamera. ");
INSERT INTO bswl_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Hitti tawaa k'ullumma assaabnjje kallayi Yesuusa Kiristoosaa ammananooyi tahelamatto k'ullummatta. ");
INSERT INTO bswl_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Aalanttina ibaaddo dubba c'ubbo felera, isona kabaja tawaa waateraan. ");
INSERT INTO bswl_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Yesuusa Kiristoosaa talleete wodooyi adda sinotteessayi k'ulloyeeran, ");
INSERT INTO bswl_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Waa Yesuusa Kiristoosa jaarsso yele kakkoonkeenera usuu kaɂammanara dubba, iigikkeessaa c'ubbokko haheso amamano goggohelaronya; Waa hikka yelano obssitteessayi kat't'awwoo c'ubbokkisoo kaginnon aani yelere kakkeessa firdda tusinya. ");
INSERT INTO bswl_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Hikka geesii Waa metekkeessawun k'ulluukki laano katusara Yesuusayi kaɂammanaro dubba k'ulloyisanoyiya. ");
INSERT INTO bswl_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Hayya no kakkodhaadanna meya kagira? Maamesinna lakkodhaadatanno! Goggodhaadannon aalantti metta tagitta? Seera kamuse mankkoɂooratanno maaranya? Lakkoyo; ayesuun goɂameen nonna kakkodhaadatanna ammanoyiyya. ");
INSERT INTO bswl_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Haanssun Waa ibaaddo kakkok'ulloyisara, ibaaddo seera ooratano anlleennon giraan ammano laano kanssowa. ");
INSERT INTO bswl_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Waa kaɂayihuudi Hedo kaalaalya? La kaɂayizaab Hedoneeyolla? Ii Ayizaabwunna Hedoya. ");
INSERT INTO bswl_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Aalanttina kahamas'iisamenna kahamas'iisamoon giro ammanoo kak'ullooyisara Waa koo kaalaalya. ");
INSERT INTO bswl_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Hayya haa gollee ammanokko kakkeeyi seera laɂo kallayikki yelin daanddaanna? Ijjii lakkodaanddaanno, suurewa seera ataayisiin kuwaarre. ");
INSERT INTO bswl_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Goortta sooyi kahoree odokkaani kalleere Abraame hikka garane me helate? ");
INSERT INTO bswl_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Abraame felooyi kak'ullooye lii girewa, kakkodhaadara girewa; ayesuun goɂameen waayi hore dhaadayin lakkodaanddeero. ");
INSERT INTO bswl_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Mas'aafa k'ulluukki me amara? «Abraame waayi ammane, k'ulluukki lee tootaame» amara. ");
INSERT INTO bswl_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Ibaaddoti koo felo gofelate kafeloo daamooza ilabo aani anlleennon giraan feloɂoottessan kadotisaro aani tootaamara. ");
INSERT INTO bswl_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ibaaddo felo oɂidan felin gowaatena duuddo, c'ubbaaliyeel kak'ullooyisaro Waa goɂammane ammanokkeessa k'ulluukki lee tootaamara. ");
INSERT INTO bswl_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Daawutena k'ullumma felo kallayi kakkontootamatta ibaaddoti kasommaasame laano tusin, ");
INSERT INTO bswl_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«Baasikkiso haheso kakkonɂamamerana C'ubbokkisona haheso kakkonɂamamera ibaaddo kasommaasameya. ");
INSERT INTO bswl_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Goottaa c'ubbo, duuddo kakkoon tootinon ibaaddo kasommaasameya!» ame ayeesera. ");
INSERT INTO bswl_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Hinɂi somma ohamas'iisameeraan olaalunya muu ohamas'iisamotunneeya? Kaɂabraame ammano k'ulluukki lee tootaame aminenna. ");
INSERT INTO bswl_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Hayya misii tootaame? Hamas'isamanakko danbbenneya muu hamas'isamanakko horeneya? Usuun kakkotootamera hamas'isamanakko danbbenne anleennon giraan hamas'isamanakko horeneya. ");
INSERT INTO bswl_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Abraame ganaa hamas's'isamanokko horene ammanokkeessaa k'ulluukki lee goggotootameroo malaata usuun goggolleeroon hamas'isame; haanssun Abraame, hahamas'isamooni oɂammaneeraanunna ammanokkisoo k'ulluukki lee kakkoontootamaro dubbaan odoya. ");
INSERT INTO bswl_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Usu ohamas'iisameraanunna odoya; odo kakkonleerana hamas's'isamano kaalaal anlleennon, Aabbokkaani Abraame hamas's'isamanokko t'aye kagire ammanokokki raadii osesseetaraawunnee adere odoya. ");
INSERT INTO bswl_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Abraamena sannitteessa alami goggoɂeelttoon Waa abddi kakkosisera ammanoo tahelamatto k'ullummaaya kuwaarre seera ooratanooyi lakkoye. ");
INSERT INTO bswl_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Seera kamusee ogiraan abddi oɂeelaraan golleen, ammano laɂo kallayikki, abddina addatti lii giratte. ");
INSERT INTO bswl_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Seera kamuse engge tawaa keenara; seera kamuse giri waatewa adi baasi lakkogirare; ");
INSERT INTO bswl_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Haanssun abddi kakkodhaabbattetta ammanoo gutiiye; hitti abddi taɂabraame sannii talleetetto dubbaan Waakko sinooyi tasisanttetto laano hikkanii addeesamera. Hikki seera kamusee kasesseetaro ibaaddo dubbaan anlleennon giraan Abraame aani kaɂammanero dubbaaniya; hikkaniinna Abraame kadubbaa odoya. ");
INSERT INTO bswl_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Gara kaɂabraame, «Kamooggan gosaan ani ku odo yelera» amame goggos'aafamerooya; usuna kagoyero goyikko kakkeesaro, kaginnonna kagiro aani kayelaro, kaɂammanero Waayi horee usu odokkaaniya. ");
INSERT INTO bswl_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","«Sanniittana hikkamalee linnatta» amame usuun kasegaamerokki malee, koonna abddi mankkoginnooti, Abraame ammanere kamooggan gosaan odo lee. ");
INSERT INTO bswl_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Abraame gees boolkki jaarssa, maarkkeessa kawaatena, tasaara gedeemi taɂumuloon laano addeesaa giraan ammanokkeessaa lakkohare. ");
INSERT INTO bswl_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Golleenna ammanoo ataatere Waawun kabaja sise kuwaarre tawaa abddi lakkohedatere. ");
INSERT INTO bswl_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Waa usuun tasisero abddi kafelnnaro laano wodana taɂammaganttee abddataa gire. ");
INSERT INTO bswl_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Haanssun ammanokkeessa k'ulluukki lee tootaame. ");
INSERT INTO bswl_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","«K'ulluukki lee tootaame» kaɂamamera haafura kakkos'aafamere usu kaalaalun lakkoyo. ");
INSERT INTO bswl_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Ayesuun goɂameen Waa k'ulluukki yele no katootaaroon, Goottakkaani Yesuusa goyikko kakkeeserooyi usu oɂammananno noyyeenneya. ");
INSERT INTO bswl_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Usu c'ubbokkaan maraan goyiin roore kasisamerona nonna k'ulluunɂi yelin goyikko kee. ");
INSERT INTO bswl_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Goortta no ammanoo mankkok'ullooyine maraan Goottakkaani Yesuusa Kiristoosa tonsse Waanne wota nogodda abnna. ");
INSERT INTO bswl_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Usu tonsse gidda takkoɂallinnenno hitta sinoo ammano tos tabin daanddeenenna; kabajja tawaanna abddi yelataa geggelaatanna. ");
INSERT INTO bswl_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Hikka kaalaalii anlleennon giraan rakkoo obssi helamisano mankkokkansso maraan rakkoottaani orroo giraanna dhaadatanna. ");
INSERT INTO bswl_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Obssikkona c'aafitii ataatano, ataankkona abddi helamatta. ");
INSERT INTO bswl_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Kasisamero Ayyaana K'ulluukkikokki garane geelanjje tawaa wodanattaani mankkoɂammagantte maraan abdditteessa lakkomullisatto. ");
INSERT INTO bswl_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Ganaa laafanɂi leene giraan Kiristoosa geeskkeessa kakkogeyaare goorata c'ubbaaliyelun goyera. ");
INSERT INTO bswl_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","K'ulluukki ibaaddotikotti banɂee kagooro helano aaloo kat'ibroya; usumaleenna kaɂidankki ibaaddoti maraan goyin kadootara woddaasa kahelamiro leera. ");
INSERT INTO bswl_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ayesuun goɂameen no ganaa c'ubbaaleyi leene giraan Kiristoosa noo maraan goyera; hikkina Waa noon taɂabo geelanjjetteessa tusera. ");
INSERT INTO bswl_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Goortta no kakkok'ulloyinenna kayesuusa Kiristoosa iigii gollee duuddona no engge tawaakko kakkohesinanna usu tonsseya! ");
INSERT INTO bswl_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","No Waawun diina leenne giraan erekkeessakokki goyii Waanne wota wogarnnenna; gidda Waanneta wogari goɂabbaabanne erekkeessakki giri tonsse suure fayyinnanna. ");
INSERT INTO bswl_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Hikka kaalaal lakkoyo; Waanne wota wogarssi kakkohelannenno Goottakkaani Yesuusa Kiristoosakkotti minane Waa noon kafeleroon geggelaatanna. ");
INSERT INTO bswl_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Haanssun c'ubbo ibaaddoti kookkotti aalanttii alami tos tabe; c'ubbokotti aalanttii goyi emeete; usumaleenna ibaaddo dubba c'ubbo mankkofelero maraan goyi ibaaddo dubbaa gutii emeete. ");
INSERT INTO bswl_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Seera kamuse sisamanokko horeene c'ubbo alami gire; halleewo kuwaarre Seera mankkoginnooti c'ubbo issii c'ubbo aani lakkotootamare. ");
INSERT INTO bswl_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Halleewo kuwaarre Addaame aani seera kawaa baasi c'ubbo anfeloon ogiraan gutii ade goyi Addaamekko haggaɂabere taa Muse geeroo ibaaddo dubba gutii reede. Hikki Addaame horenbbaan kaɂemeeyinaro Kiristoosan masuussaye. ");
INSERT INTO bswl_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ayesuun goɂameen sino tawaakokki ilabo c'ubbo kaɂibaaddotikokki jilbba aani lakkoye; ibaaddoti koo kafelero c'ubbokotti aalanttii kamooggan ibaaddo goye; usumalee sino tawaayinna ibaaddoti koo Yesuusa Kiristoosakkotti aalanttii kahelamera kasinoo ilabo kamoogganun ammagame roore sisamera. ");
INSERT INTO bswl_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Usumaleenna dannabakki ilabo kawaa takeenera sinokotti laɂo, ibaaddoti kookokki c'ubbo takkeenaro laɂo aani lakkoyo. Ibaaddoti koo kafelero c'ubbokotti aalanttii kasisamera firdda murroo keene; kamooggan c'ubbokkokki aalanttii dannabaa kasisamera ilabo k'ullumma keene. ");
INSERT INTO bswl_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Ibaaddoti koo kafelero c'ubbokotti aalanttii goyi ibaaddo dubbaa gutii goreede taɂammagantte sino tawaanna dannabakki ilabo atatere kak'ullooye dubba ibaaddoti koo Yesuusa Kiristoosakokki garane kaɂameen dubba awode neefone girara. ");
INSERT INTO bswl_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Goortta Addaame kookki c'ubbo, kamurroo firdda ibaaddo dubbaa gutii goggokeeneroo, usumalee Kiristoosa koo konɂi k'ulluunɂi felo kammooggan ibaaddo murrookko balchchumma beeseren giri sisaraan. ");
INSERT INTO bswl_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Addaame ajaja diidanokokki aalanttii kamooggan ibaaddo c'ubbaaleessa goggolleeroo usumaleenna Kiristoosa ajajaamanokkotti aalanttii kamooggan k'ullowara. ");
INSERT INTO bswl_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Seera kamuse emeetanokko kakkeeyi baasi moggate; ayesuun goɂameen c'ubbo takkojiinatee, sino tawaa noon jiinatte. ");
INSERT INTO bswl_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Hikkina kakkoonlleera c'ubbokotti aalanttii goyi goggoreedero malee, Yesuusa Kiristoosakkokki garane jiruu jiroommakki giri goggohelamiroo sino tawaa k'ullooyisanoyi reedinatta. ");
INSERT INTO bswl_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Goortta me amina? Sino tawaa goggomoggaattoon c'ubbo felaa girinno? ");
INSERT INTO bswl_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Lakkohaayyo! No goonenne kale beenne owoyyuyinenno aani leene giraan, misii c'ubbooyi ataayi girnnanna? ");
INSERT INTO bswl_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Kiristoosane wota koo goggolleennon ot'ammak'aminennona, goyikkeessane wota koo liin kat'ammak'aaminenno lakkokassaanya? ");
INSERT INTO bswl_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Haanssun Kiristoosa taɂodoo kabajaa goyikko goggokeero noonna usumalee kaɂusubkki giri goggogirnnonya; goonenne usune wota k'amalaminnenna. ");
INSERT INTO bswl_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Goyikkeessaa usune wota koo golleene kiyaanokkeessana adi ogiraan usune wota koo linnanna. ");
INSERT INTO bswl_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","C'ubbaalessakki maarkkaani goggobaaronna c'ubbokkokki diyyiil laanokaani goggohesiroon taddoɂan yadaliittaani Kiristoosane wota suwaamano kanssowa. ");
INSERT INTO bswl_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Aalanttina kagoye ibaaddo c'ubbokko balchchumma beera. ");
INSERT INTO bswl_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","No Kiristoosane wota goggoonne usune wota kagirinanno ammanatanna. ");
INSERT INTO bswl_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Kiristoosa goyikko keera; kallami gowaanawatti goyi goortta usu gutii odonnati waatano kanssowa. ");
INSERT INTO bswl_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Usu kakkogowaare goorata, goyi koo kaalaal c'ubboon goyera; ayesuun goɂameen neefone gogirro Waawun girara. ");
INSERT INTO bswl_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Goortta isin kagootettan aani c'ubbokko fakki goggoɂanttettanna kayesuusa Kiristoosa garane ade Waawun neefone goggogittani heda. ");
INSERT INTO bswl_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Haanssun halchcha kameellan feliguddeen kagowaaro maarkkisin gutii c'ubbo goggoreediron arooyeltteen. ");
INSERT INTO bswl_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Maarkkisin kameellan massaara yelayi c'ubboon aroossisseen; hassukkona goyikko giri tos kanak'ero ibaaddo yelayenddeen isiɂoottisin Waawun sisa; maarkkisinna k'ulluukki huu yeladdeen Waawun sisa. ");
INSERT INTO bswl_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Gidda isin kakkogittaan sinokko hegelle kuwaarre seerakko hegelle mankkoleenon maraan c'ubbo isin iminin lakkodootisaro. ");
INSERT INTO bswl_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Goortta me aminna? Seera kamusekko hegelii anleennon giraan sinokko hegelle mankkoginno maraan c'ubbo felinno? Duuddo lakkodootisaro. ");
INSERT INTO bswl_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ibaaddoti koowun kahandaaro lii ajajaamin isiɂoottisin gosisattan hassu kakkoɂajajaamattan ibaaddotin diyyii laanokisin kassanwa; usumalee c'ubboon goɂajajaantteen goyi kakkeenaro c'ubboon diyyiil laattan; waawun goɂajajaantteen adi k'ullumma helayinattaan. ");
INSERT INTO bswl_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Isin t'ayteen kac'ubbo diyyitteen; gidda ade kaɂatatteettaan agaalssisii wodanakko ajajaamanoyi Waawun galata haggeewo. ");
INSERT INTO bswl_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","C'ubbokko balchchumma beetedden kak'ullummaa diyyiil leeteettan. ");
INSERT INTO bswl_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Ani hikkamalee ibaaddon tattabatto heɂii kakkonɂayyesara yaadakisookki laafummakko kakkeeyiyya. T'aye kamaaree mikitajjoolkisin kabbattiinna kameellanee diyyijjool yeltteeddeen goggokeentteetteen malee usumalee gidda kamaaree mikitajjolkisin goggok'ullooyiro k'ulluukki kahandaaro yeladdeen sisa. ");
INSERT INTO bswl_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","C'ubboon diyyii leeteen arooggitten k'ullummakko sarre gitteen. ");
INSERT INTO bswl_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Gidda isin kakkomullitettaan ayeeskko ese arrii me laɂo helatteetten? Hassu ayeeskkokki worɂe goyiya. ");
INSERT INTO bswl_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Gidda goɂameen c'ubbokko balchcha beeten diyyiil kawaa leeteettaan; hikka handdaanooyi k'ullumma helayinattaan; k'ullummakkotti gachcho jiruu jiroommakki giriya. ");
INSERT INTO bswl_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Kac'ubbo daamooza goyiya; kawaa ilabo ade Goottakkaani Yesuusa Kiristoosaa kahelamaro jiruu jiroommakki giriya. ");
INSERT INTO bswl_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Abbilaalttee! Seera kakkaso ibaaddon ayeesinara; seera ibaaddoti kooyi gutii odonnati kakkoɂaba ibaaddoti neefone giraan kaalaal laano lakkokassaanya? ");
INSERT INTO bswl_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Takeesanttetta heleelttiti too entterne wota seeraa tashaantte kakkolaatta usu neefone giraan kaalaalya; entter goggoye ade kakeessunee seerakko sarii biyaatta. ");
INSERT INTO bswl_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Ayesuun goɂameen entter neefone giraan kakkalee ibaaddoon gokkeesantte sharmmut'itetta amamatta entter goggoye adde kakkalee ibaaddoon gokkeesantte hassu seerakko tafurantte laatta; kakkalee babbaarun gokkeesantte sharmmut'aa lakkoɂamamatto. ");
INSERT INTO bswl_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Haanssun abbilaalttee! Isinna okiristoosa mankkolleeten maraan goyere kalekabbee aani seerakko fakkintteettan; hikkina kakkaleetun goyikko kakkeero usuu liiddeen Waawun il goggoyelannoonya. ");
INSERT INTO bswl_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Halchcha kasooyeti takkosessetannee seeraayi kakekkeesare kameellan halchcha tagoyi il goggoyelanno maarkkaanikokki mikitaal orroo felaa gire. ");
INSERT INTO bswl_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Gidda goɂameen t'aye k'ik'k'ise shiye kagireen goonenne seerakko balchcha beenenna. Hikkina kakkoonlleera kaddoɂankki kalleero kas'aafamero seera kamusen anlleennon giraan kaɂusubkki kaɂayyaana raadii goggohanddayinnonya. ");
INSERT INTO bswl_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Goortta me aminna? Seera metekkeessan c'ubboya? Duuddo lakkoc'ubboyyo! Ayesuun goɂameen seera tonsse liwaatewa, c'ubbo meyyo lakkoɂaddeesare; seera «Aroohalchchiite» amiwaatewa, halchcha meyyo ogiraan ani lakkomalabere. ");
INSERT INTO bswl_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","C'ubbo seerakko kaɂemeetero ajaja hit'aa helatere halchcha dubba iyyee orroo goggokekkeeroon yele. Seera gowaattame ade c'ubbo kagoye ayeesiya. ");
INSERT INTO bswl_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Seera anginnoon ani neefone gire; ajaja goɂemetekko abbaabatere ade c'ubbo arddokki lee; ani ade goye. ");
INSERT INTO bswl_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Giri sisirowa amamere kasisamere kaseera ajaja iyyee gutii goyi keenera. ");
INSERT INTO bswl_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","C'ubbo kaseera ajaja aalantti yelatere in sobera; ajajakkokki garanena in lagade. ");
INSERT INTO bswl_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Haanssun seera metekkeessan k'ulluuya; ajajana k'ulluukki karrummiinna kaɂidankkiya. ");
INSERT INTO bswl_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Hayya hikki kaɂidankki kalleere ayeesi iin goyi keenera amanoya? Duuddo lakkohaayyo; ayesuun goɂameen c'ubbo c'ubbo lii goggoɂaddeesamiroon kaɂidan kalleero ayeeskkokki garane goyi keene; hikkina c'ubbo ajajakkokki garane aaloo c'ubbaaleessa lee. ");
INSERT INTO bswl_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Seera kaɂaayyana laano kanssowa; ani goɂameen c'ubboon diyyii aani kadaddalamerona soo kasarsayeroya. ");
INSERT INTO bswl_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ani metekkeewun kafelaro lakkokaso; ani kadootamaro ayees felano iisegure katiramaro ayees felara. ");
INSERT INTO bswl_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Ani felin kadootoon kafelaro gollee seera kaɂidankki laano atotaara. ");
INSERT INTO bswl_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Haa gollee hikka kayelara ani ussun metekkeeyi anlleennon giraan iyyee orroo kagiro c'ubboya. ");
INSERT INTO bswl_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Iyyee goorttun c'ubbaaleessa talleetetto met't'a orroo koonna kaɂidankki ayees giranawaatti ani kasowa; kaɂidan kalleero felin halchcha aba; ayesuun goɂameen felin lakkodaanddaaro. ");
INSERT INTO bswl_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Ani gidda felaa kagira felin kadootisaro kaɂidankki ayees lakkoyo; ayesuun goɂameen ani felin kadootisoon kameellan felara. ");
INSERT INTO bswl_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ani felin kaddootisoon ayees kameellan kafelaro gollee hassu kafelara ani metekkeeyi anlleennon giraan iyyee orroo kagiro c'ubboya. ");
INSERT INTO bswl_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Haanssun ani hikka seera felaa kagiro laano addeesayera; hikkina ani kaɂidan ayees felin dootaa giraan meellane iyyee orroo gitta. ");
INSERT INTO bswl_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Orroɂootteyi seera kawaayi geggelaatara. ");
INSERT INTO bswl_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Ayesuun goɂameen maarkkeeyi orroo kafelara kac'ubbo seera in kashaame yelisise, sammuutteekki seerane wota kaɂolamara kakkalee seera maarkkeeyi orroo felaa giraan deyaara. ");
INSERT INTO bswl_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Ani misikki laafakki ibaaddotiya! Hikka goyin kasisamero maarkkeekko ayyoya in haasin kadaanddaara? ");
INSERT INTO bswl_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Goottakkaani Yesuusa Kiristoosakkotti minane galata Waawun haggeewo! Goortta ani sammuutteeyi seera kawaawun diyyii golleero tasooye yadaliitteeyi seera kac'ubboon diyyii leera. ");
INSERT INTO bswl_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Haanssun Yesuusa Kiristoosaa ogiraan gidda k'anggo lakkoɂabaan. ");
INSERT INTO bswl_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Aalanttina giri kasisaro Ayyaana K'ulluukkokki seeraayi Yesuusa Kiristoosa c'ubbokkona kagoyi seerakko balchchumma beesera. ");
INSERT INTO bswl_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Taɂibaaddo c'ubbaalessatti yadaliikko kakkeeyi seera kamuse felin kawaatere Waa felera; erekkeessa c'ubbaaleessa ibaaddokokki masuussayi c'ubbokotti aalanttii farere sooɂoottessaa c'ubbo firddeere baase. ");
INSERT INTO bswl_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Hikkana kakkonyelera feɂi tasooye anleennon giraan Ayyaana K'ulluukki osesseetanno noyyeen seera kamusekokki ajaja feloo goggohayirooya. ");
INSERT INTO bswl_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Soo kasarsatero ibaaddo orroo tagitto feɂi tameellan malee ogiraan wodanattisoo sookokki halchcha gutii kaataran; adeen Ayyaana K'ulluukki malee ogiraan wodanattiso Ayyaana K'ulluukki halchcha gutii kaataran. ");
INSERT INTO bswl_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Kameellan kasooye halchcha k'oppaano goyi keenara; kaɂayyaana ayees k'oppaano ade girina nogodda sisara. ");
INSERT INTO bswl_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","C'ubbo taɂiminamatta sammuu waanne wota diinatta, seera kawaatuunna lakkoɂiminatto iminamiinna lakkodaanddaatto. ");
INSERT INTO bswl_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Kameellan halchcha kasooyetii kaɂiminamara Waa geggelaayisin lakkodaanddaaro. ");
INSERT INTO bswl_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Isin addeen Ayyaana kawaa isin orroo kagiro gollee, kameellan halchcha kasooyetun anleennon giraan Ayyaana gittaan. Maayyona kakiristoosa ayyaanaa goginnoon usu kakiristoosa lakkoyo. ");
INSERT INTO bswl_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Ayesuun goɂameen Kiristoosa isin orroo gogire, maarkkisin c'ubbokko kakkeey kagoye golleenna, Ayyaanakkisin isin Waayi k'ulluukki laanokko kakkeey arddokkiya. ");
INSERT INTO bswl_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Yesuusa goyikko kakkeesera Ayyaanakkeessa isinii kagiro gollee, Kiristoosa goyikko kekkeesere isin orroo kagira ayyaanakkeessa kagowaaro maarkkisinunna giri sisinara. ");
INSERT INTO bswl_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Haanssun abbilaalttee! No anza abnna; hitti anza kameellan kasooye halchchakotti feɂi malee girin lakkoyo. ");
INSERT INTO bswl_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Kameellan halchcha kasooyekotti feɂii kagittaan golleeten goyin gittaan; omeellan felo osooye ayyaanayi gollagadeen adi neefone girinattaan. ");
INSERT INTO bswl_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Ayyaana kawaayi osesseetaran dubba yiis kawaayyaan. ");
INSERT INTO bswl_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Haanssun, «Aabbo! Aabbokkaani» ami kakkoɂuumanno kayiisummaa ayyaana atatteettan kuwaarre abssii girin addeen kallami kadiyyi ayyaana lakkoɂatatteettan. ");
INSERT INTO bswl_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ayyaana kawaa ayyaanakkaaninne wota leere yiis kawaa laanokkaani noon atotaara. ");
INSERT INTO bswl_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Goortta noo yiis kawaa golleene andde usu noon kaɂekkaasero atayinanna; Kiristoosane wotana atayinanna; gidda kiristoosane wota rakkoo oɂatatanno golleene abbaabayinne kabajatteessakko oɂatatanno linnanna. ");
INSERT INTO bswl_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Tagiddanee rakkoo horenbbaan noyyeen tamutinatto kabajane wota goherreginsso maamensse wotana beellamisiin kadaanddaamon yele tootaara. ");
INSERT INTO bswl_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Met't'a dubba yiis kawaakkotti mutano kaɂatii halchchanoyi ooratatta. ");
INSERT INTO bswl_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Met't'a dubba addatti goggolleeton firddaamera; hikkina feɂitteessa anlleennon giraan, abddii goggoɂoorannon kayelera feɂi tawaayiyya. ");
INSERT INTO bswl_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Abdditteessana met't'a issii kabbayi diyyinatikko balchchumma bidde yiis kawaanne wota balchchumana kabaja tahedeedamato goggolleetonya. ");
INSERT INTO bswl_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Gidda gin met't'a dubba kaɂummullaa goorataayi kagiro abboosa aani muddamaa gutii girano kanssowa. ");
INSERT INTO bswl_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Ayesuun goɂameen muddamaa gutii tagitta met't'a taalaal lakkotto; kahorarijjee, Ayyaana K'ullukkikokki ilabo oɂatannenna nonna maarkkaanikki wodoo kalleeroon yiis kawaa laanokoti abddi oorataa kaɂorroo maarkkaani muddam gutii ginna. ");
INSERT INTO bswl_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","No kafayyinenna hitta abddiiya. Ayesuun goɂameen no abddi kayelatanna kamutaro ayees gollee abddi lakkotto; kamutaroonna abddi kayelatara ayyoya? ");
INSERT INTO bswl_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ayesuun goɂameen ganaa anddeenon giraan abddi goyelanne andde obssii ooratanna. ");
INSERT INTO bswl_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Usumaleenna no misii ebaayin dootisaro mankkokasoon maraan Ayyaana K'ulluukki haranokkaani garggaarara; haafuraayi mutin kadaanddaamon muddama noon horehaye gargaarara. ");
INSERT INTO bswl_vpl VALUES ("R