﻿USE sofia;
DROP TABLE IF EXISTS sofia.bssNT_vpl;
CREATE TABLE bssNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bssNT_vpl WRITE;
INSERT INTO bssNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tóŋgé e betaa ábe Yesu Krǐstəə edíi nɛ́n. Yesuɛ ambíd á nchyáátɛ́n ḿme kə̂ŋ Dabidɛ, Dabidɛ mɔ́-ʼɛ abíd á nchyáátɛ́n ḿme Abrahamɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamɛ mɔ́ abédé sáá awě Aisigɛ. Aisigɛ-ʼɛ ambɛ́ sáá awě Jakɔbɛ, Jakɔbɛ-ʼɛ mɔ́ anchyáá Judaa bɔ́ɔbɛ baányaŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judaa bɔ́ mwaád Tamaa, bénchyāā Pɛrɛsɛ ne Zɛraa. Perɛɛ ambɛ́ sáá awě Hesɛrɔnɛ, Hesɛrɔnɛ-ʼɛ sáá awě Ramɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramɛ mɔ́ abédé sáá awě Aminadabɛ, Aminadabɛ-ʼɛ abédé sáá awě Nashɔnɛ. Nashɔnɛ ambɛ́ sáá awě Salmɔnɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmɔnɛ bɔ́ mwaád, Rahabɛ bɔ́-ʼaá bénchyāā Boasɛ. Boasɛ bɔ́ mwaád Rutɛ bénchyāā Obɛdɛ, Obɛdɛ-ʼɛ ambɛ́ sáá awě Jesɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesɛ ambɛ́ sáá awě kə̂ŋ Dabidɛ. Kə̂ŋ Dabidɛ bɔ́ Uria mwaád béchyāā Solomonɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomonɛ ambɛ́ sáá awě Rehoboamɛ, Rehoboamɛ-ʼɛ mɔ́ ambɛ́ sáá awě Abijaa, Abijaa ambɛ́ sáá awě Asaa. ");
INSERT INTO bssNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaa ambɛ́ sáá awě Jehosafadɛ, Jehosafadɛ mɔ́-ʼɛ ambɛ́ sáá awě Joramɛ, Joramɛ mɔ́-ʼɛ ambɛ́ sáá awě Uzzia. ");
INSERT INTO bssNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzzia abédé sáá awě Jotamɛ, Jotamɛ mɔ́-ʼɛ ambɛ́ sáá awě Ahasɛ. Ahasɛ mɔ́-ʼɛ ambɛ́ sáá awě Hezekaya. ");
INSERT INTO bssNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hɛzekaya-ʼɛ ambɛ́ sáá awě Manasɛ. Manasɛ-ʼɛ sáá awě Amɔsɛ. Amɔsɛ mɔ́ ambɛ́ sáá awě Josia. ");
INSERT INTO bssNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josia mɔ́ɔ anchyáá Jekonyasɛ bɔ́ɔbɛ baányaŋ, á póndé eche bad bé aloŋ á Israɛl bênkwɛɛ́ nzum boŋ bad bé Babilɔn béswɛ́ɛ́n bɔ́ áwāb aloŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Áde nɛ́n dêmmadté atóm, kə́ə́ŋ ne á póndé echě bénchyāāʼɛ́ Yesuɛ, betaa ábe Yesuɛ bébédɛ́ɛ; Jekonyasɛ mɔ́ɔ ambɛ́ sáá awě Sheltyɛlɛ, Sheltyɛlɛ-ʼɛ mɔ́ ambɛ́ sáá awě Zerubabɛlɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabɛlɛ ambɛ́ sáá awě Abutɛɛ, Abutɛɛ-ʼɛ sáá awě Elyakimɛ. Elyakimɛ-ʼɛ ambɛ́ sáá awě Azɔɔ. ");
INSERT INTO bssNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azɔɔ abédé sáá awě Zadogɛ, Zadogɛ mɔ́-ʼɛ ambɛ́ sáá awě Akimɛ, Akimɛ-ʼɛ sáá awě Eliudɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudɛ mɔ́ ambɛ́ sáá awě Elizaa. Elizaa-ʼɛ sáá awě Matanɛ. Matanɛ mɔ́-ʼɛ ambɛ́ sáá awě Jakɔbɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakɔbɛ mɔ́ abédé sáá awě Josɛbɛ. Josɛbɛ mɔ́ awóŋ Maria awě anchyáá Yesuɛ awě béchəgɛɛ́ bán Krǐstəə. ");
INSERT INTO bssNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Né-ɔɔ́, nyoŋgɛl ésyə̄ə̄l, mbooted ne Abrahamɛ âpɛ wɛ́ɛ Dabidɛ, édé dyôm-é-nyoŋgɛl ne éniin. Mbooted ne Dabidɛ âpɛ póndé eche béswɛ́ɛ́né bad bé Israɛl á Babilɔn áde bênkwɛɛ́ nzum, édé dyôm-é-nyoŋgɛl ne éniin. Bootya póndé eche bénswɛ̄ɛ̄nnɛ̄ bad bé Israɛl á Babilɔn áde bênkwɛɛ́ nzum, kə́ə́ŋne á póndé eche béchyáá Yesuɛ, ádé dyôm-é-nyoŋgɛl ne éniin. ");
INSERT INTO bssNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Echyáa éche Yesuɛ ébédé nɛ́n: Maria, nyaá awě Yesuɛ, ábédé ngɔn e mmwaád echě enkêmbíí mwɛnchóm. Bênkií mɔ́ mod nhɔ́g awě béchə́géʼáá bán Josɛbɛ. Boŋ byánán Maria ǎsū á eʼwóŋgé wɛ́ɛ Josɛbɛ, ényīnnēd nɛ́n bán adé nkog á ngíne e Edəə́dəŋ éche Ésáá. ");
INSERT INTO bssNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josɛbɛ-ʼɛ, ngáne ábédé mɔ́ mod a bwâm, enkêndəŋgé Maria eʼsôn awóged. Né-ɔɔ́, abɛléʼáá mboŋsɛ́n âchene mɔ́ á mesɔɔm-tê. ");
INSERT INTO bssNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Á póndé echě ḿmê mewêmtɛn médíí mɔ́ áte, ángɛl e Dyǒb empií mɔ́ áde ánáŋgé nló. Ángɛl ne enláá mɔ́ nɛ́n aá, “Á-Josɛb, mod á mbyaa ḿme Dabidɛ, weebááʼ Maria atéd nɛ́ɛ mmwaád awôŋ, áyə̄le Edəə́dəŋ éche Ésáá chɔ́ɔ épíídé mɔ́ boŋ abɛ́ nkog. ");
INSERT INTO bssNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ǎchyāā mwǎn a mwɛnchóm, échuu-ʼɛ mɔ́ dǐn wɛɛ́ Yesuɛ áyə̄le nɛ́n mɔ́ɔ̄hūd ábē bad á mbéb-te.” ");
INSERT INTO bssNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ḿmɛ́n mésyə̄ə̄l mêmbɛnléd âlóned eʼyale ábe Dyǒb dénlōmɛ̄nnē nkal éʼdəə́dəŋ aá, ");
INSERT INTO bssNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nyénɔneʼ, ngɔn e mmwaád echě eébíí mwɛnchóm ěbɛ̄ nkog, echyáá-ʼɛ mwǎn a mwɛnchóm, bɛ́chə̌g-kɛ mɔ́ bán Emmanuɛlɛ.” Ádɛ́n dǐn ádé nɛ́n bán, “Dyǒb ádé ne sé.” ");
INSERT INTO bssNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nɛ́ɛ Josɛbɛ ásyə́ŋgé ásē, ambɛ̌l ngáne ángɛl énlāāʼɛ́ mɔ́. Antéd Maria nɛ́ɛ awě mmwaád. ");
INSERT INTO bssNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Boŋ kə́ə́ŋ ne póndé eche Maria áchyáá mwǎn, Josɛbɛ enkêndyɛ̌nné mɔ́. Josɛbɛ anchuú-ʼɛ ane mwǎn dǐn aá Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bénchyāā Yesuɛ á dyad á Bɛtɛlhɛm á mbwɔ́g e Judeya á póndé eche Hɛrɔdɛ ábédé kə̂ŋ. Bad behɔ́g ábe bélááʼáá betintinɛ âbíi mekan, bémbīd á akuu, bépɛ̄ á Jerusalɛm. ");
INSERT INTO bssNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Áde bépédé á Jerusalɛm, bênsɛdéd bánken, “Héé kə̂ŋ e bad bé Israɛl, ane awě achyáádté wɛ́n ádíí? Sênyíné tintinɛ á akuu awě alûmte nɛ́n bán achyáádté. Nɛ̂ dɔ́ɔ ákə́ə́ boŋ sépag âbɛ mɔ́ edúbé.” ");
INSERT INTO bssNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ádě kə̂ŋ Hɛrɔdɛ áwógé nɛ̂, nɛ̂ dêntagéd mɔ́ á mewêmtɛn-tê bwâmbwam. Dêntagéd mɔ́, átāgēd-tɛ bad bé Jerusalɛm bésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Hɛrɔdɛ anlǎd ábe beprisɛ bémbáá ne bemeléede bé mbéndé bésyə̄ə̄l áte. Boŋ ásɛdté bɔ́ aáken, “Héé Ane awě Dyǒb Áwɔ́gté, awě bésinɛɛ́, áchyāādtē?” ");
INSERT INTO bssNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Dɔ́ɔ békwɛ́ntɛ́né mɔ́ bán, “Bɛ́chyāā mɔ́ á dyad á Bɛtɛlhɛm, á mbwɔ́g e Judeya. Nkal éʼdəə́dəŋ antěl aá, ");
INSERT INTO bssNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Á-bad bé Bɛtɛlhɛm á ndɔɔb e Juda, ádɛ̄n dyad ádé dyad ahɔ́g áde ádé etógnɛ́n bwâmbwam átîntê e myad mé aloŋ á Juda. Áyə̄le mod ǎbīd átîntê echɛ̂n, awě ǎlyə̄gēd ábêm bad bé aloŋ á Israɛl.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nɛ́ɛ Hɛrɔdɛ áwógé nɛ̂, anchɛ́lé ábê beláŋ-bé-betintinɛ á kun-tê, boŋ ásɛdté bɔ́ nyaa e póndé echě tintinɛ nɛ ámbīdtē. ");
INSERT INTO bssNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Dɔ́ɔ álómé bɔ́ á Bɛtɛlhɛm aá, “Nyékag, nyétôŋ anɔn. Nzé nyênyíné wɛ́ɛ ane mwǎn áchyáádté, nyétīm ámbīd nyéhyɛ nyêláá mɛ, âbɛl boŋ mɛ́mpē ńkɛ ḿbɛ mɔ́ edúbé.” ");
INSERT INTO bssNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Áde bémáá mekan ḿme kə̂ŋ áláŋgé bɔ́ awóg, bêmbootéd akɛ ámpē. Boŋ áde bénɔ́né ámīn, bényīn melemlem mé tintinɛ ḿme bényīnnē á akuu nɛ́ɛ ákagké bɔ́ áʼsō. Ane tintinɛ ankɛ̌ kə́ə́ŋ atyéém wɛ́ɛ ane mwǎn ánchyāādtē. ");
INSERT INTO bssNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Anyín áde bényíné ane tintinɛ, bénwōg menyiŋge bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bénsɔ̄l á ndáb-te. Nɛ́ɛ bésɔ́lé, bényīn ane mwǎn bɔ́ nyaŋ, Maria. Bémbwɔ̄gē ane mwǎn mebóbóŋ âbɛ mɔ́ edúbé. Bémbīdēd mendɛ áwed ḿme bénwánlédté mɔ́, bébɛ̄-ʼɛ mɔ́. Ḿmê mendɛ mébédé gôl, mɔ̌g mé eʼlod éʼ bwâm ḿme béchəgɛɛ́ bán frankinsɛn ne mía. ");
INSERT INTO bssNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nɛ́ɛ bémáá ane mwǎn edúbé abɛ, bémbwɔ̄gē esú áwāb aloŋ, boŋ bêmpǒŋ nzii empée, áyə̄le Dyǒb dénlāā bɔ́ á nló-te aá béetiméʼ ámbīd wɛ́ɛ Hɛrɔdɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Áde ábê beláŋ-bé-betintinɛ bémáá akɛ, ángɛl e Dyǒb enláá Josɛbɛ á nló-te aá, “Hidé ásē, étêd anɛ́n mwǎn bɔ́ nyaŋ ésobɛn bɔ́, étimɛn bɔ́ á Egipto. Nyédyɛ-ʼɛ áwed kə́ə́ŋ né nláŋgé nyé mɛɛ́ nyéhide, áyə̄le Hɛrɔdɛ ǎlōm bad âhɛd anɛ́n mwǎn, âwúu mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ḿmê nkuu děn, Josɛbɛ anhidé ásē, atéd mwǎn bɔ́ nyaŋ, ákɛ̄ɛ̄n bɔ́ nkuu ne nkuu, átimnád bɔ́ á Egipto. ");
INSERT INTO bssNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Áwed dɔ́ɔ bendyɛɛ́ʼɛ́ kə́ə́ŋ ne póndé eche Hɛrɔdɛ áwédé. Nɛ́n dêmbɛnléd âlóned eʼyale ábe Dyǒb dénlōmɛ̄nnē nkal éʼdəə́dəŋ aá, “Nlébpé awem Mwǎn mɛɛ́ ábîd á aloŋ á Egipto.” ");
INSERT INTO bssNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Áde Hɛrɔdɛ ásóŋtɛ́né nɛ́n aá beláŋ-bé-betintinɛ bɛ̂ bédógé mɔ́, anlǐŋ bwâmbwam. Anlóm éche sə́nze á Bɛtɛlhɛm ne ene pɛd e mbwɔ́g esyəə́l, aá béwúu bǎn bé baachóm bésyə̄ə̄l ábe béepede mwɛ̌ ńláán. Ambɛl nɛ̂ âtə́ŋgɛn ne póndé eche beláŋ-bé-betintinɛ bénlāā-ʼɛ́ mɔ́ bán bénkɔ̄lē tintinɛ awě anlúméd echyáa éche Yesuɛ anyín. ");
INSERT INTO bssNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nɛ́n dêmbɛnléd âlóned eʼyale ábe Dyǒb dénlōmɛ̄nnē nkal éʼdəə́dəŋ Jeremayaa. Jeremayaa anhɔ́b aá, ");
INSERT INTO bssNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Bad bénwōg eʼsaád ne awɛ́ á ngíne ádě ábídéʼáá á Rama, áde Rashɛlɛ áchyɛɛʼɛ́ ábe bǎn. Béléntéʼáá mɔ́ awɛ́, boŋ eékobpe aléned áyə̄le nɛ́n bǎn bémmad mɔ́ awɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ámbīd e kwééd eche Hɛrɔdɛ, ángɛl e Dyǒb empií Josɛbɛ á nló-te áde ámbɛ̄ɛ̄ abɛ́ á Egipto, élāŋgē mɔ́ nɛ́n aá, ");
INSERT INTO bssNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Téd awôŋ mmwaád bɔ́ mwǎn, nyétime ámbīd á aloŋ á Israɛl. Hɛrɔdɛ ne ábē bad ábe béhɛ́déʼáá ane mwǎn awúu bémáá awɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nɛ́ɛ Josɛbɛ áwógé nɛ̂, anlad yə̌l, atéd Maria bɔ́ mwǎn, bɔ́ɔ̄bɔ̄ɔ bétīm ámbīd á aloŋ á Israɛl. ");
INSERT INTO bssNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Boŋ áde Josɛbɛ áwógé bán Achelausɛ atédé atii dé nkamlɛn áde sáá, kə̂ŋ Hɛrɔdɛ á mbwɔ́g e Judeya, ambáŋ atim ámbīd áwed. Ángɛl e Dyǒb enhyɛ̌ mɔ́ mekan mémpēe aláa á nló-te. Nɛ̂ dêmbɛ̌l, á mbwɔ́g e Galilia dɔ́ɔ ântimmé akɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ankɛ̌ alóŋ á dyad ámbáá ahɔ́g áde béchə́géʼáá bán Nazarɛt. Nɛ́n dêmbɛnléd âlóned eʼyale ábe Dyǒb dénlōmɛ̄nnē bekal béʼdəə́dəŋ tə̂ŋgɛne Yesuɛ aá, “Ǎbyɛ̄ɛ̄n nɛ́ɛ Mod a Nazarɛt.” ");
INSERT INTO bssNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Etûn é póndé ámbīd enɛ̂, Jɔnɛ, Ndusɛnɛ ambíd nkal éʼdəə́dəŋ a Dyǒb. Akaléʼáá eyale é Dyǒb á ehyáŋge á Judeya, álāŋgē bad aá, ");
INSERT INTO bssNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Nyétɛde abɛl dé mbéb áyə̄le nɛ́n nkamlɛn ń Dyǒb ńdé bɛnbɛn.” ");
INSERT INTO bssNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jɔnɛ mɔ́ abédé mod awě nkal éʼdəə́dəŋ Yesayaa áhɔ́béʼáá, áde ánhɔ̄bpē aá, “Ehə́ŋgé ébídeʼ á ehyáŋge bán, ‘Nyéboŋsɛn epɛ éche Sáŋgwɛ́ɛ́. Nyétíi echě nzii.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jɔnɛ ahágéʼáá mbɔ́té éche bébɛ́nlé nyoŋ éche ébídé á yə̌l e kamɛ̂l. Awááʼáá ngə́ə́ a ngob e nyam. Eʼchuu ne bengómɛ́ɛ́ bɔ́ɔ bébédé ndyééd echê. ");
INSERT INTO bssNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bad bébídé-ʼáá á Jerusalɛm, ne ḿmíníí myad mé mbwɔ́g e Judeya esyəə́l ne á meloŋ mémpēe ḿme mébédé á nkəg mé edíb é mbáá é Jodan, békag wɛ́ɛ Jɔnɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nɛ́ɛ bêmpalɛ́ɛ́ ḿmāb mbéb áte, Jɔnɛ ádusɛ́n bɔ́ á edíb é Jodan. ");
INSERT INTO bssNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Boŋ áde Jɔnɛ ányíné nɛ́ɛ Befarisia ne Besadusia béhúɛʼɛ́ âbɛl boŋ ádusɛn bɔ́, anláá bɔ́ aá, “Píí é nyə̌ chɛ́n! Nzɛ́ɛ́ múmɔ́ aláŋgé nyé aá nkáásé ń Dyǒb ńhúɛʼ boŋ aléb-pɛ nyé aá nyékúme abáŋgé? ");
INSERT INTO bssNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nyékɛ nyébɛle mam ḿme mɛ́lūmēd nɛ́n bán nyêtɛ̌dté ádɛ̄n abɛ́ dé mbéb. ");
INSERT INTO bssNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nyéewémtán nɛ́n bán nzé nyêhɔ́bé bán, nyêdé bǎn ábe Abrahamɛ, nyéekudté nkɔ́gsɛn ń Dyǒb. Boŋ ńláa nyé nɛ́n mɛɛ́, Dyǒb áhɛle ábɛnléd ḿmɛ́n meláá átīmēd mɔ́ bǎn ábe Abrahamɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Bɔɔb-pɔɔ́ ehón émáá anaa á nkaŋ ḿ mɛl. Né-ɔɔ́, bwɛl ké éʼhéé ábe béēchyāāʼ eʼpum éʼ bwâm, bɛ́kwɛl bɔ́ bébwém-mɛ bɔ́ á muú-te. ");
INSERT INTO bssNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ndusan nyé bɔɔb ne mendíb âlúmed nɛ́n bán nyêhə̌ŋlɛ́né ádɛn abɛ́ dé mbéb. Boŋ mod ampée ahúɛʼ, awě atómé mɛ. Meékwognedɛɛ́ ké âpém ḿme metámbé. Ǎdusɛ́n nyé ne Edəə́dəŋ éche Ésáá, ádusɛ́n-nɛ nyé ne muú. ");
INSERT INTO bssNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Awánlé échē epebɛn á ekáá, âbɛl nɛ́n, ápeb ḿme menyán ámīn. Nzé amadé, ǎlǎd mbum é bwâm áte, ákōō chɔ́. Boŋ ǎlǎd eʼpəə́, ahyáád bɔ́ á ebonde é muú éche éēdīmēʼ.” ");
INSERT INTO bssNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Bɔɔb-pɔɔ́, Yesuɛ ambíd á mbwɔ́g e Galilia, ákɛ wɛ́ɛ Jɔnɛ á edíb é Jodan âbɛl nɛ́n Jɔnɛ ádusɛn mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Boŋ Jɔnɛ anwanɛ́n mɔ́ mewêmtɛn ahəŋlɛn, áhɔ̄bē nɛ́n aá, “Nɛ́ɛ édíí bán wɛ-ɛɛ́ wembɛ́ edusan mɛ, chán étímé abɛ́ éche wɛwɛ éhyagké áwêm wɛɛ́ ńdusɛn wɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Boŋ Yesuɛ ankwɛntɛ́n mɔ́ aá, “Mwɛ̌ ébɛ̂ nɛ̂ bɔɔb âbɛl nɛ́n débɛl mam mésyə̄ə̄l bwâm ngáne Dyǒb áhɛdɛɛ́.” Né-ɔɔ́, Jɔnɛ ankwɛntɛ́n mɔ́ adusɛn. ");
INSERT INTO bssNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Melemlem mé póndé ḿme Jɔnɛ ámáá Yesuɛ adusɛn, Yesuɛ ansyəə́ á mendíb-te. Dɔ́ɔ ngob e dyǒb énédnédé, boŋ ányīnē nɛ́ɛ Edəə́dəŋ é Dyǒb ébídé ádyōb ésudé ásē nɛ́ɛ élə̄ə̄, étyéém-mɛ mɔ́ á nló mîn. ");
INSERT INTO bssNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ehɔ́b chɔ́-ʼɛ ámpē ébīdē ádyōb nɛ́n, “Awem Mwǎn a nlém nɛ́n, awógte mɛ menyiŋge bwâmbwam.” ");
INSERT INTO bssNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ámbīd e póndé, Edəə́dəŋ é Dyǒb êntimɛ́n Yesuɛ á ehyáŋge âbɛl nɛ́n Satanɛ ákəg mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesuɛ andid yə̌l nzaa á mekáne-tê móom mé eʼpun méniin. Ámbīd e ene póndé nzaa ewagéʼáá mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Dɔ́ɔ Satanɛ ápédé boŋ áláŋgé mɔ́ aá, “Nzé Wɛ-ɛɛ́ edé Mwǎn a Dyǒb, kamlɛ́n ḿmɛ́n meláá métim eʼwɛle.” ");
INSERT INTO bssNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Boŋ Yesuɛ antimtɛ́n mɔ́ aá, “Éténlédé á kálag e Dyǒb nɛ́n bán, ‘Saké ndyééd chěmpɛn edide moonyoŋ á aloŋgé. Boŋ eyale tɛ́ɛ́ éche Dyǒb áhɔ́bé, chɔ́ɔ édídé moonyoŋ á aloŋgé.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Dɔ́ɔ Satanɛ ákɛ́ɛ́né Yesuɛ á Jerusalɛm, dyad áde ásáá boŋ átyēēmān mɔ́ á nzoŋgɛ e Ndáb-e-Dyǒb mîn, ");
INSERT INTO bssNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","álāŋgē mɔ́ aá, “Nzé wɛ-ɛɛ́ edé Mwǎn a Dyǒb, éheb á bwɛle-mîn hɛ́n éhûn á ndɔɔb, áyə̄le éténlédé á kálag e Dyǒb nɛ́n bán, ‘Dyǒb dɛ́kamlɛ́n éche ángɛl âsáb wɛ, épēm-mɛ wɛ ámīn âbɛl weébɔ̄mē ekuu á aláá.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesuɛ-ʼɛ antimtɛ́n mɔ́ aá, “Boŋ kálag e Dyǒb ehɔ́bé ámpē nɛ́n aá, ‘Weékə̄gē Sáŋgwɛ́ɛ́ ádoŋ Dyǒb áte.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Satanɛ antéd Yesuɛ ámpē, búmɔ̄ bétyéém á mbɔɔd mîn, boŋ álūmtē mɔ́ meloŋ mé nkǒŋsé mésyə̄ə̄l ne nhɔn ńsyə̄ə̄l ḿme ńdé áwēd-te. ");
INSERT INTO bssNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Dɔ́ɔ álâŋgɛɛ́ mɔ́ aá, “Mɛ̌bɛ̌ wɛ ábɛ́n bwěm éʼsyə̄ə̄l nzé ebwɔ́gké mɛ mebóbóŋ boŋ ébāg-kɛ mɛ edúbé.” ");
INSERT INTO bssNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ mɔ́ aá, “Syəə́ mɛ á dǐd-te, a-Satan! Éténlédé nɛ́n bán, ‘Ébwɔ́gkeʼ Sáŋgwɛ́ɛ́ ádoŋ Dyǒb mebóbóŋ, ébage-ʼɛ mɔ́ edúbé. Mwěnpɛn-naá étə́ŋgɛ́né abɛle.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Né-ɔɔ́, Satanɛ antɛdé Yesuɛ, ákɛ̄. Ángɛl êmpɛ̌, éwóŋgɛ́n Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ene póndé bénhɛ̄ Jɔnɛ, Ndusɛnɛ á mbwɔg. Áde Yesuɛ áwógé nɛ̂, antǐm ámbīd á mbwɔ́g e Galilia. ");
INSERT INTO bssNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Anhidé á dyad á Nazarɛt, ákɛ ádyɛ̄ɛ̄ á dyad á Kapenahum. Kapenahum abédé á nkəg mé edib-é-nzab é Galilia, á abwɔ́g á hǒm á túmbé e Zɛbulɔn ne e Naftali. ");
INSERT INTO bssNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yesuɛ ankɛ̌ á Kapenahum âlóned mekan ḿme nkal éʼdəə́dəŋ Yesayaa ánhōbpē aá, ");
INSERT INTO bssNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“A-mbwɔ́g e Zɛbulɔn, a-mbwɔ́g e Naftali, ntimned ne edíb é nkwɛ̌, á múde mé edíb ń Jodan, Galilia mbwɔ́g echě bad ábe béesɛ̌ bad bé Israɛl bédyɛɛʼɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bad ábe bébédé á ehíntɛ́n-tê békúdé eʼnyínɛn bé ekíde; Bad ábe bébédé á nsəl ń soŋ békúdé eʼsoósoŋ.” ");
INSERT INTO bssNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Bootya póndé echě Yesuɛ ánkɛɛ́ á Galilia ambootéd eyale é Dyǒb akal áhɔ̄bē nɛ́n aá, “Nyéhəŋlɛn abɛ́ dé mbéb, áyə̄le nkamlɛn ń Dyǒb ńdé bɛnbɛn.” ");
INSERT INTO bssNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Epun ehɔ́g Yesuɛ akagéʼáá á nkin mé edib-é-nzab é Galilia. Annyín bǎn bé baachóm bébɛ; Simɔnɛ awě béchə́géʼáá bán Petro, bɔ́ mwǎnyaŋ Andreya nɛ́ɛ bébwémɛɛ́ mbínzé. Bébédɛ́ɛ bekób-bé-súu. ");
INSERT INTO bssNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Dɔ́ɔ álâŋgɛɛ́ bɔ́ aá “Nyéhíde mɛ. Ngáne nyékóbɛɛ́ súu bɔɔb, mɛɛ́yə̄gēd nyé ngáne nyɛ́tēdtē bad nlém á abum âhíd mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ábwɔ̄g-ábwɔ̄g bêntɛdé échab mbínzé, béhīdē-ʼɛ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nɛ́ɛ bésídté áʼsō, Yesuɛ annyín bǎn bé baachóm bémpēe bébɛ; Jemsɛ bɔ́ mwǎnyaŋ Jɔnɛ, bǎn ábe Zɛbɛdiɛ. Bɔ́ɔbɛ sáá bémbɛ̄ á bɔ̌lɛ-tê, bébwéméʼáá échab mbínzé. Hɛ̂ dɔ́ɔ Yesuɛ áchɛ̂nlɛɛ́ bɔ́ bad bébɛ aá béhíde mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ábwɔ̄g-ábwɔ̄g bêntɛdé sáá ne bɔ̌lɛ, béhīdē-ʼɛ Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesuɛ akagéʼáá myad mésyə̄ə̄l á aloŋ á Galilia áyə̄gtē eyale é Dyǒb á ndáb é mekáne, ákalé-ʼɛ nkalaŋ ḿ bwâm mé nkamlɛn ń Dyǒb. Achǒŋtéʼáá bad bé nkole bésyə̄ə̄l ne nyaa e nkole tɛ́ɛ́ echě émbɛ̄ átîntê echâb. ");
INSERT INTO bssNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Né-ɔɔ́ mekan ḿme Yesuɛ ábɛ́léʼáá nwógnádtáá á mbwɔ́g e Siria esyəə́l. Nɛ̂ dênkə̌ŋ bad bépɛ́ɛ́néʼáá bad bé nkole bésyə̄ə̄l áwē. Bépɛ́ɛ́néʼáá bad áwē ábe békónléʼáá nkole ne mewɛ nyaa ne nyaa. Bad ábe eʼdəə́dəŋ bé mbéb bémbɛ̄ɛ̄ áte, bad ábe béhúne ekikíd, ne bad ábe béwédé epɛd, Yesuɛ áchoŋté ábê bad bésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nɛ̂ dênkə̌ŋ, ndun e mod ehídéʼáá Yesuɛ. Bad bébídéʼáá meloŋ bootya á Galilia ne mbwɔ́g e Myad Dyôm, Jerusalɛm, Judeya, ne pɛd echě edé á múde mé edíb é Jodan ḿmíníí. ");
INSERT INTO bssNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Áde Yesuɛ ányíné ene ndun e mod, anchə́gé é ekone mîn, ádyɛ̄ɛ̄ ásē. Áhed-taá ábē bembapɛɛ bétáné mɔ́ ");
INSERT INTO bssNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","boŋ ábootéd bɔ́ ayə́ged, áhɔ̄bē aá, ");
INSERT INTO bssNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nnam ḿbɛ̂ ne bad ábe bédé atóg á edəə́dəŋ-tê áyə̄le bédé ásē e nkamlɛn ḿ mín. ");
INSERT INTO bssNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nnam ne bad ábe bélebeʼ, áyə̄le Dyǒb dɛ́wōgēd bɔ́ menyiŋge ámpē. ");
INSERT INTO bssNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nnam ne bad ábe bépwíítédé, áyə̄le nkǒŋsé ńsyə̄ə̄l mɛ́bɛ̄ ḿmāb. ");
INSERT INTO bssNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nnam ḿbɛ̂ ne bad ábe bédé nzaa ne píd âbɛl mam ḿme Dyǒb áhɛdɛɛ́ aá mébɛnled, áyə̄le Dyǒb dɛ́kōdēd bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nnam ne bad ábe béwóge bad bémpēe ngɔl, áyə̄le Dyǒb dɔ́mpē dɛ́wōg bɔ́ ngɔl. ");
INSERT INTO bssNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nnam ne bad ábe békɛ́nlé nlém á abum, áyə̄le bɛ́nyīn Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nnam ne bad ábe békɔ́me nsaŋ, áyə̄le Dyǒb dɛ́chəg bɔ́ ábē bǎn. ");
INSERT INTO bssNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nnam ne bad ábe békude metake áyə̄le bébɛlɛɛ́ mam ḿme Dyǒb áhɛdɛɛ́. Bédé ásē e nkamlɛn ḿ mín. ");
INSERT INTO bssNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nnam ḿbɛ̂ ne nyé ábe bad bésyə́əʼɛ́, nyé ábe bétagtɛɛ́, bébānē nyé eʼbébtéd éʼ mam áyə̄l, bébīdē-ʼɛ nyé mbóŋ é metóm áyə̄l, á dǐn ádêm. ");
INSERT INTO bssNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nyéwóge bwâm, nyébɛ́-ʼɛ menyiŋge áyə̄le nsábe ḿme nyɛ́kudté ádyōb ńchábé ámīn. Nɛ́n dɔ́ɔ bad bétágtéʼáá bekal béʼdəə́dəŋ béʼ bɔɔ́d. ");
INSERT INTO bssNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nyêdé etógnɛ́n á aloŋgé á bad bé nkǒŋsé ngáne nkwɛ̌ ńdíí etógnɛ́n áyə̄le ndyééd. Boŋ nzé nkwɛ̌ ḿbɔ́dé alaŋ chán béhɛle-sɛ bényīnēd mɔ́ ámpē? Méesaá dyam dé abɛlɛn ámpē. Né-ɔɔ́, apim dɔ́ɔ bépimɛɛ́, bad békɔgtáád mɔ́ ámīn. ");
INSERT INTO bssNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nyɛ́ɛ̄ nyêdé nɛ̂ŋgáne etrúkáŋ âlúmed bad bé nkǒŋsé bésyə̄ə̄l nzii e Dyǒb. Dyad áde álóŋnédé á ekone mîn déesɔɔmɛ́ɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mod eémāā-ʼaá etrúkáŋ achod sɛ ákōō chɔ́ á ebwɔg-sɛ́, boŋ abɛlé ákɛ̄lē chɔ́ ámīn, âbɛl nɛ́n ényînte kénzɛ́ɛ́ awě adé á ndáb-te ekíde. ");
INSERT INTO bssNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nyémpē nyépɛneʼ, melemlem nɛ́ɛ etrúkáŋ. Nzé bad bényíné nsɔ́n ḿ bwâm ḿme nyébɛlɛɛ́, bɛ́kɛn Dyǒb, awɛ̂n Titɛ́ɛ awě adé ámīn. ");
INSERT INTO bssNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nyéewémtán nɛ́n bán mpedé á nkǒŋsé âbɔ́ded mbéndé éche Mosɛɛ ne mekan ḿme bekal béʼdəə́dəŋ béyə́gté nyé. Meépedɛɛ́ âbɔ́ded mɔ́, boŋ mpedé âlóned mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ne mbále nlâŋge nyé nɛ́n mɛɛ́, kə́ə́ŋ ne á asóg dé nkoŋ ń sé ne ḿ mín, ké mwǎmpīn mé eyale nhɔ́g awě atěnlédé á mbéndé e Dyǒb eéhidtɛ́ɛ́ ásē kə́ə́ŋ né mésyə̄ə̄l mélóné. ");
INSERT INTO bssNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Né-ɔɔ́, kénzɛ́ɛ́ awě abóó mbéndé pɔ́g átîntê échê mbéndé é Dyǒb, ké ene echě béwémtɛ́né bán eésaá etógnɛ́n, áyə̄gtē-ʼɛ bad bémpēe aá bébɛl melemlem, ene ndín e mod ěbɛ̄ ndimtɛne átîntê e bad ábe bédé ásē e nkamlɛn ḿ mín. Boŋ kénzɛ́ɛ́ awě abɛle ngáne mbéndé éhɔ́bé, áyə̄gtē-ʼɛ bad bémpēe âbɛl melemlem, ǎbɛ̄ etógnɛ́n bwâmbwam átîntê e bad ábe bédé ásē e nkamlɛn ḿ mín. ");
INSERT INTO bssNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Né-ɔɔ́, nlâŋge nyé nɛ́n mɛɛ́, ésebán abɛle á Dyǒb ádɛ̄n átómé áde Befarisia ne bemeléede bé mbéndé, né nyémpē nyéesɔ́nlé á nkamlɛn ḿ mín mbêd.” ");
INSERT INTO bssNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yesuɛ ambád ahɔ́b aá, “Nyêwógé nɛ́n bán bénlāā bad béʼ bɔɔ́d bán, ‘Mod eewúɛ́ mod. Kénzɛ́ɛ́ awě awúú mod, bétə́ŋgɛ́né mɔ́ akáad.’ ");
INSERT INTO bssNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Boŋ nlâŋge nyé nɛ́n mɛɛ́, kénzɛ́ɛ́ awě alǐŋné mwǎnyaŋ bétə́ŋgɛ́né mɔ́ akáad. Kénzɛ́ɛ́ awě ǎsyə̄ŋ mwǎnyaŋ bɛ́pɛɛ́n mɔ́ á kóte e bad bémbáá békáád mɔ́. Kénzɛ́ɛ́-ʼɛ awě ǎchəg mwǎnyaŋ aá, ‘Edimdim é chǒm chɛ́n’, béhɛle bébwém mɔ́ á dǔ-á-muú. ");
INSERT INTO bssNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Né-ɔɔ́, nzé ekag á menyán mé mendɛ âkɛ dé abɛ Dyǒb mendɛ, boŋ ekǎmtɛ́né nɛ́n wɛɛ́ nyé mod nyêwánlɛ́né kɔkɔɔ, ");
INSERT INTO bssNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ébānē ḿmōŋ mendɛ ásē áʼsō éʼ menyán mé mendɛ. Ésébe ékɛ ébɛ̄l nsaŋ ne ane mod boŋ étīm ámbīd ékɛ ébɛ mendɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nzé mod ahɛde wɛ akɛ dé asɔ́mɛn á kóte, bɛ̌l kə́ə́ŋ nyúmɔ̄ nyépɛ á nchemtɛn byánán nyɛ́ɛ̄pɛ̌ á kóte. Ésebɛ́ nɛ̂, ahɛlɛsɛ asɔ́mɛ́n wɛ á kóte. Kóte-ʼɛ ěbɛɛ́ wɛ á mekáá mé plûsɛ, plûsɛ chɔ́-ʼɛ éhɛ̄ wɛ á mbwɔg. ");
INSERT INTO bssNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ne mbále, nlâŋge wɛ mɛɛ́, weéhɛ̄lɛ̄ɛ̄-sɛ ebíd á ndáb e mbwɔg-tê wɛ̂ kə́ə́ŋ né etwedé ádōŋ alúm ásyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nyêwógé ngáne béhɔ́bé nɛ́n bán, ‘Nyéekábé mesón á ndáb eʼwóŋgé.’ ");
INSERT INTO bssNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Boŋ nlâŋge nyé mɛɛ́, kénzɛ́ɛ́ awě anɔné mmwaád boŋ awémtɛ́n aá né mɔ̂nnaŋnéd mɔ́, amaá asón akáb ne ane mmwaád áwe nlém-tê. ");
INSERT INTO bssNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nzé ádoŋ dǐd ábɛlte wɛ mbéb, ehúd dɔ́, épim. Édé mboŋ âbɔ́d dɔ́, tómaa bɔ́ âbwém echoŋ yə̌l esyəə́l á dǔ-á-muú. ");
INSERT INTO bssNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Melemlem nɛ̂, nzé échoŋ ekáá ébɛlte wɛ mbéb, esɛ́l chɔ́, épim chɔ́. Édé mboŋ âbɔ́d chɔ́ tómaa bɔ́ âbwém echoŋ yə̌l esyəə́l á dǔ-á-muú. ");
INSERT INTO bssNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Kálag e Dyǒb ehɔ́bé ámpē nɛ́n, ‘Kénzɛ́ɛ́ awě anané mwaád á eʼwóŋgé atə́ŋgɛ́né ábɛ mɔ́ apab áde álûmte nɛ́n bán anané mɔ́ á eʼwóŋgé.’ ");
INSERT INTO bssNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Boŋ nlâŋge nyé nɛ́n mɛɛ́, nzé mod anané mwaád á eʼwóŋgé ésebán ane mmwaád akábé asón, boŋ ane mmwaád akií mod ampée awóŋ, né nchóm awě anané mɔ́ á eʼwóŋgé mɔ́ atǐmté mɔ́ mmwaád awě akábeʼ mesón. Kénzɛ́ɛ́-ʼɛ awě awóó mmwaád awě bénáné á eʼwóŋgé né mɔ́mpē akábé asón. ");
INSERT INTO bssNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Nyêwógé nɛ́n bán bénlāā bad béʼ bɔɔ́d bán, ‘Mod eemwág melɛ̌ ngɛ̂n, boŋ nzé mod amwédé melɛ̌ atə́ŋgɛ́né ábɛ̄l dyam áde ámwɛ́ɛ́né melɛ̌ áʼsō é Dyǒb.’ ");
INSERT INTO bssNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Boŋ nlâŋge nyé nɛ́n mɛɛ́, nyéemwág melɛ̌ ké mehɔ́g. Nyéemwág melɛ̌ á dǐn dé nkamlɛn ḿ mín, áyə̄le áhed dɔ́ɔ Dyǒb áwóó eʼdii bé nkamlɛn. ");
INSERT INTO bssNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nyéemwág-kɛ á dǐn dé nkǒŋsé, áyə̄le áhed dɔ́ɔ Dyǒb ásúmé mekuu. Nyéēbɛnlád-tɛ ké dǐn á dyad á Jerusalɛm, áyə̄le ádíi dyad áde kə̂ŋ embáá. ");
INSERT INTO bssNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nyéemwág melɛ̌ ké á dǐn dé nló ḿmɛ̄n, áyə̄le nyéēhɛ̄lɛ̄ɛ̄ ké mbum e esid pɔ́g ahəŋlɛn áwɛn nló, âpúbed kéʼɛ âhíned chɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Boŋ nzé ehɔ́bé wɛɛ́ mɔ́bɛle dyam, ehɔ́b wɛɛ́, ‘Ɛɛ, mɛ̌bɛl dɔ́.’ Ké-ʼɛ wɛɛ́, ‘Aáy, méebɛnlé.’ Kéchéé éche ébádé áhed né ébídé wɛ́ɛ Satanɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nyêwógé ngáne béhɔ́bé nɛ́n bán, ‘Nzé mod atúbé mod dǐd, bétúb mɔ́mpē dǐd. Nzé mod ahúdé-ʼɛ mod asoŋ, béhúd mɔ́mpē asoŋ.’ ");
INSERT INTO bssNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Boŋ nlâŋge nyé nɛ́n mɛɛ́, nzé mod abɛlé wɛ mbéb, éched yə̌l. Nzé mod abɔmé wɛ abɛ́n á akəg ahɔ́g, ékunnéd mɔ́ ádíníí ámpē. ");
INSERT INTO bssNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nzé mod ahɛde wɛ asɔ́mɛn á kóte âkobɛn wɛ ḿmōŋ nkobe, ébag mɔ́ kə́ə́ŋ ne echoŋ sútɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nzé mod anyágté wɛ aá ékɛɛn mɔ́ máyl mehɔ́g, ékɛ̄ɛ̄n mɔ́ máyl mébɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kénzɛ́ɛ́ awě achɔ́mé wɛ chǒm, bɛɛ́ mɔ́. Nzé mod ahɔ́bé-ʼɛ aá, ébâl mɔ́ chǒm éche éwóó, ebál mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nyêwógé ngáne béhɔ́bé bán, ‘Édəŋ mwǎnyoŋ, ékɔɔ-ʼɛ mod awě akɔɔ́ wɛ.’ ");
INSERT INTO bssNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Boŋ nlâŋge nyé nɛ́n mɛɛ́, nyédəŋ bad ábe békɔ́ɔ́ nyé, nyékânnad-tɛ ábe bétagte nyé. ");
INSERT INTO bssNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nzé nyêbɛlé nɛ̂, né nyɛ́ɛ̄bɛ̄ bǎn ábe Titɛ́ɛ awɛ̂n awě adé ámīn. Alómeʼ enyɛn ne mbúú wɛ́ɛ bad bé mbéb ne bé bwâm nyaa pɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nzé edəə́ bad ábe bédə́ə́ wɛ běnpɛn, nɛ̂ déepiinédté wɛ nsábe ké nhɔ́g. Kə́ə́ŋne besaad-bé-táásɛ bɔ́mpē bébɛle melemlem. ");
INSERT INTO bssNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nzé elɛnteʼ ábōŋ bad běnpɛn né ebɛle melemlem ngáne kénzɛ́ɛ́ ampée ábɛlɛɛ́. Kə́ə́ŋne bad ábe béesɛ̌ bad bé Israɛl bébɛle nɛ̂. ");
INSERT INTO bssNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Né-ɔɔ́, mbɛltéd ḿmɛ̄n ńtə́ŋgɛ́né nɛ́ɛ ńtyéémé bwâm, nɛ̂ŋgáne mbɛltéd ḿme awɛ̂n Titɛ́ɛ awě adé ámīn. ");
INSERT INTO bssNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Nyétêd póndé! Nyéēbɛ̄lē nsɔ́n ń Dyǒb âbɛl boŋ bad bényîn nyé. Nzé nyêbɛle nɛ̂, né nyéekudté nsábe wɛ́ɛ awɛ̂n Titɛ́ɛ awě adé á nkamlɛn ḿ mín. ");
INSERT INTO bssNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Né-ɔɔ́, nzé ebage mod chǒm éche átógnɛ́né, weékūmē nkə́ŋ nɛ̂ŋgáne bad ábe bédoge yə̌l. Békume nkə́ŋ á ndáb é mekáne ne á dyad-tê wɛ́ɛ bad bédíí, âbɛl boŋ bényîn bɔ́. Ne mbále nlâŋge nyé mɛɛ́, bémáá ḿmab nsábe ńsyə̄ə̄l akud. ");
INSERT INTO bssNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Boŋ nzé ebage mod chǒm éche átógnɛ́né, weébɛ̄lēʼ-sɛ ké awoŋ wɛ̌n awě étómtɛ́né adəŋ abíí. ");
INSERT INTO bssNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nɛ̂ dɛ́bɛ̌l mod ké nhɔ́g éebííʼɛ́ chǒm éche ébágé mɔ́. Dyǒb, awoŋ Titɛ́ɛ awě anyíne mam ḿme mébɛnled á eʼkoŋnéd-te mɔ́ɔ̄sābē wɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nzé nyêkanneʼ, nyéekánnéʼ nɛ́ɛ bedog-badɛ́, ábe nzé békânneʼ bédəə atyéem á ndáb é mekáne ne á mbom, âbɛl boŋ bad bényîn bɔ́. Ne mbále nlâŋge nyé nɛ́n mɛɛ́, bémáá ḿmāb nsábe ńsyə̄ə̄l akud. ");
INSERT INTO bssNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Boŋ pɛn, nzé mod akânneʼ, asɔ́l áwē toŋ-tê, ádīb ekob, boŋ ákānnē wɛ́ɛ eche sáŋ Dyǒbɛ awě mod éēnyīnɛ̄ɛ̄. Ene póndé awôŋ Titɛ́ɛ awě anyíneʼ mam ḿme médé á eʼkoŋnéd-te ǎsābē wɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nzé nyêkánneʼ, nyéebádnán eʼyale mbád ne mbád, ngáne bad ábe béesɛ̌ bad bé Israɛl bébɛlɛɛ́. Bébɛlé béwēmtān bán Dyǒb dɛ́wōg bɔ́ mekáne áyə̄le bébúdé eʼyale áte. ");
INSERT INTO bssNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nyéebág nɛ́ɛ bɔ́, áyə̄le Dyǒb, awɛ̂n Titɛ́ɛ, amaá abíi chǒm éche nyétógnɛ́né byánán nyɛ́ɛ̄sɛdéd mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Né-ɔɔ́, enɛ́n nyaa e mekáne chɔ́ɔ nyétə́ŋgɛ́né akáne, Dyǒb, Titɛ́ɛ awɛ̂d, awě adé ámīn, edúbé ébɛ̂ ne ádoŋ dǐn. ");
INSERT INTO bssNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ḿmōŋ nkamlɛn ńhyɛ ńtêd etə́l. Bad bé nkǒŋsé bébɛl mekan ḿme éhɛdɛɛ́, ngáne ébɛnlaadté ámīn. ");
INSERT INTO bssNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Bag sé echɛd ndyééd e epun e bǐn êʼ chii. ");
INSERT INTO bssNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Lagsɛ́n sé ḿmɛd mbéb, ngáne sémpē sélagsanné mod tɛ́ɛ́ awě abɛlé sé mbéb. ");
INSERT INTO bssNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Weémwāg-sɛ sêhún á mekəgsɛn-tê, boŋ húd sé á mekáá mé Satan. ");
INSERT INTO bssNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nzé nyêlagsan bad mewusé ḿme bébɛ́nlé nyé, né Dyǒb Titɛ́ɛ awɛ̂n awě áde ámīn mɔ́mpē ǎlagsɛ́n nyé. ");
INSERT INTO bssNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Boŋ nzé nyéēlagsán bad, né ké Dyǒb awɛ̂n Titɛ́ɛ éelagsɛ́nné nyé. ");
INSERT INTO bssNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nzé edide yə̌l nzaa á mekáne-tê, weésudnéʼ ngáne bedog-badɛ́ bébɛlɛɛ́. Béchêmteʼ eʼsó á nló âbɛl boŋ bad béchem bán bédide yə̌l nzaa á mekáne-tê. Ne mbále, nlâŋge nyé nɛ́n mɛɛ́ bémáá ḿmāb nsábe ńsyə̄ə̄l akud. ");
INSERT INTO bssNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Boŋ nzé edide yə̌l nzaa á mekáne-tê, éwōbē eʼsó, ésɛ̄dɛ̄-ʼɛ nló áte. ");
INSERT INTO bssNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Bɛ̌l nɛ̂, âbɛl boŋ bad béechemé bán edide yə̌l nzaa á mekáne-tê, étōmɛɛ́ awôŋ Titɛ́ɛ awě mod éēnyīnɛ̄ɛ̄. Anyíneʼ mam ḿme médé á eʼkoŋnéd-te, mɔ́-ʼaá ǎsābē wɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Nyéēkoŋnád yə̌l nhɔn á nkǒŋsé wɛ́n, wɛ́ɛ síi ne ngag bɛ́bēbēdtē, bechîb-pɛ ámpē bébóó ndáb, béchíb. ");
INSERT INTO bssNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Boŋ nyékoo ḿmɛ̄n nhɔn wɛ́ɛ síi ne ngag béebébédté, bechîb-pɛ ámpē béebóóʼɛ́ ndáb se béchíb. ");
INSERT INTO bssNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nyêbíí bán wɛ́ɛ nhɔn ḿbágkē mod, áhed dɔ́ɔ nlém-mɛ ḿbágkē mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Dǐd dɔ́ɔ ádé ngáne etrúkáŋ é yə̌l e mod. Nzé dǐd ákɛ́nlé wɛ áte, echoŋ yə̌l esyəə́l chɔ́mpē ebɛlé ekɛ́lé. ");
INSERT INTO bssNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nzé déekɛ̂nle, yə̌l chɔ́mpē ělōn wɛ áte ne ehíntɛ́n. Né-ɔɔ́, nzé chǒm éche ényînte nyé ekíde étímé abɛ́ chǒm éche étímté nyé á ehíntɛ́n-tê, né échê ehíntɛ́n échě nyɛ́bɛ̄ɛ̄ áte étōmtɛ̄n ngíne abɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Modmod eéhɛ̄lɛ̄ɛ̄-sɛ abɛ́ mbəledɛ a bewóŋ bébɛ. Ǎlūmēd nhɔ́g edəŋge tómaa aníníí, kéʼɛ átīmɛ̄n nhɔ́g, abáŋ-ʼɛ aníníí áyə̄l. Weéhɛ̄lɛ̄ɛ̄-sɛ ebɛ́ mbəledɛ a bad bébɛ abɛ́ ahɔ́g. Weéhɛ̄lɛ̄ɛ̄-sɛ ebɛ́ mbəledɛ a Dyǒb se ebɛ́-ʼɛ mbəledɛ a mɔné. ");
INSERT INTO bssNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Né-ɔɔ́, nlâŋge nyé nɛ́n mɛɛ́ nyéētāgē áte á aloŋgé, se nyéhɔ̄bē nɛ́n bán cheé nyédyɛ̄ɛ̄, kéʼɛ nzé-chómé nyémwɛ̄ɛ̄, kéʼɛ cheé nyéwāāʼɛ̄ á yə̌l. Éesaá mbále bán aloŋgé átómé ndyééd-ɛ? Yə̌l-lɛ ámpē eésaá etógnɛ́n tómaa mbɔ́té-yɛ? ");
INSERT INTO bssNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nyénɔne menɔn, méēwēnɛ̄ɛ̄ bwěm, méēpādɛ̄ɛ̄, méēwóo-ʼáa hǒm ádě békoŋgɛɛ́ medyɛ́. Kénɛ̂, Dyǒb awɛ̂n Titɛ́ɛ awě adé ámīn adídte mɔ́! Nyéebíiʼɛ́ bán nyêdé etógnɛ́n bwâmbwam tómaa menɔn-ɛ? ");
INSERT INTO bssNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nzɛ́-módɛ́ áwɛn tîntê ahɛle átāg áte kə́ə́ŋ, abád ké epun ehɔ́g áwē aloŋgé? ");
INSERT INTO bssNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Cheé-ɔ̄ ékə́ə́ boŋ nyétagé áte áyə̄le mbɔ́té éche nyéwáaʼɛ́? Nyénɔneʼ mbonja éche édé á mehîn-te ngáne ékwogɛɛ́. Éebɛlɛ́ɛ́ ntǔ, éebaŋgɛ́ɛ́ mesaŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nlâŋge nyé nɛ́n mɛɛ́, ké kə̂ŋ Solomonɛ ne ḿmē nhɔn ńsyə̄ə̄l eewáaʼaá mbɔ́té éche épédé échɛ́n mbonja ké pɔ́g eʼboŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nzé Dyǒb áhɛlɛsɛ áwāādtē eʼsum ábě éʼbâg chii boŋ chǎn béhɛ́ bɔ́ á dǔ, né éetómmé nyé awáad né-yɛ? Chán adúbe ádíí nyé mwǎmpīn nɛ́n? ");
INSERT INTO bssNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Né-ɔɔ́ nyéētāgē áte bán, ‘Cheé sɛ́dyɛ̄ɛ̄? Cheé sɛ́mwɛ̄ɛ̄?’ Ké-ʼɛ bán, ‘Cheé sɛ́wāāʼɛ́?’ ");
INSERT INTO bssNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Bad ábe béesɛ̌ bad bé Israɛl bɔ́ɔ béchyɛɛʼ âkud échɛ́n ndín é bwěm. Awɛ̂n Titɛ́ɛ awě adé ámīn abíí aá nyêtógnɛ́né ábɛ́n bwěm éʼsyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Boŋ nyésébe nyé nyéhɛd mam mé nkamlɛn ń Dyǒb tómaa mam mésyə̄ə̄l, nyébɛle-ʼɛ ngáne Dyǒb áhɛdnɛɛ́ nyé. Nzé nyêbɛle nɛ̂, né Dyǒb dɛ́bɛ̌ nyé ábíníí bwěm éʼsyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Né-ɔɔ́ nyéētāgē áte áyə̄le epun êʼ chǎn. Epun êʼ chǎn chěn éwōŋ ḿmē metake ḿme mɛ́kwognéd chɔ́. Epun tɛ́ɛ́ éwóó ḿmē metake. ");
INSERT INTO bssNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mod eekáádté waáb. Nzé ekáádté wɛ̌n, né Dyǒb dɔ́mpē dɛ́kāād wɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nyaa echě ékáádté wɛ̌n, chɔ́ɔ Dyǒb dɔ́mpē dɛ́kāādtē wɛ. Melemlem mé nhəgtéd ḿme ébɛ́nlédé mɔ́ɔ Dyǒb dɔ́mpē dɛ́bɛnlédté. ");
INSERT INTO bssNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Cheé ékə́ə́ boŋ éwāmsān mwǎ púuted anyín á dǐd áwɛ̄n, ésebán ehɛle nkɔg ḿme ńdé mmǒŋ á dǐd anyín? ");
INSERT INTO bssNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Chán éhɛle-sɛ eláá mwǎnyoŋ wɛɛ́ ámwɛ mɔ́hūd mɔ́ púuted á dǐd, áde nkɔg ńdíí mmǒn á dǐd? ");
INSERT INTO bssNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Á-edog-bad! Sébé éhûd nkɔg ḿme ńdé mmǒn á dǐd, dɔ́ɔ wɛ́tōŋʼɛ́ púuted echě edé mwǎnyoŋ á dǐd anyín, boŋ ehúd-tɛ chɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Weetédé mam mé Dyǒb sɛ ébɛ̄ mbwɛ́, áyə̄le ěkunnéd wɛ yə̌l ékūm-mɛ wɛ. Weebwémmé nguu échōŋ ngɛse áyə̄le édyaŋtéd chɔ́ ámīn. ");
INSERT INTO bssNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Hɛdɛ́n Dyǒb, ǎbɛ̌ wɛ. Hɛ̌d, Dyǒb dɛ́bɛ̌l enyín, kǔm ekob, Dyǒb dɛ́dibnéd wɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Áyə̄le kénzɛ́ɛ́ awě ahɛ̌dné Dyǒb, ǎkǔd, awě ahɛdé-ʼɛ, ǎnyīn. Kénzɛ́ɛ́-ʼɛ awě akumé ekob, Dyǒb dɛ́dibnéd mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Sáá-a-mwǎn ahéé mwǎn áhɛdɛ́nné ewɛle, boŋ ábɛ mɔ́ aláá? ");
INSERT INTO bssNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ké-ʼɛ nyé ahéé mwǎn áhɛdɛ́nné súu, boŋ ábɛ mɔ́ nyə̌? ");
INSERT INTO bssNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nzé eʼbébtéd éʼ bad nɛ́ɛ nyé nyébage ábɛn bǎn kəse é bwěm, tɔ́gtɛ́n-naá echɛn Sáŋ awě adé ámīn? Chán-nɔ̄ éebaá bad ábe béhɛ́dné mɔ́ kəse é bwěm? ");
INSERT INTO bssNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Né-ɔɔ́, kéchéé éche édə́ə́ wɛɛ́ bad bébɛl áwôŋ, ébɛl chɔ́ áwāb. Nɛ́n dɔ́ɔ mbéndé e Dyǒb ne bekal-bé-eʼdəə́dəŋ ékooʼɛ́ ayə́ged.” ");
INSERT INTO bssNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yesuɛ ambád aá, “Bwɛɛ́ á ekob éche échíné áte, áyə̄le ekob éche ékag á dǔ-á-muú ékə́lé áte, nzii eched-tɛ etə́nlédé, bad ábe bébwag-kɛ áhed bébúú áte. ");
INSERT INTO bssNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Boŋ ekob é nzii e aloŋgé ádě déemaáʼ edé mwǎmpīn. Nzii-ʼɛ echě etime áwed elɛlé abwɛ áte. Nguse é bad chɔ́ɔ ébwag-kɛ áhed. ");
INSERT INTO bssNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Nyétêd póndé ne bekal-bé-eʼdəə́dəŋ bé metóm. Bélûmte byánán bépwéédtédé nɛ́ɛ ńdyɔŋ ḿ mbód, boŋ áwab nlém-tê bédé ebébtéd nɛ́ɛ ngə. ");
INSERT INTO bssNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nyɛ́ɛ̄chem bɔ́ á mbɛltéd ḿmāb. Mewáŋ méchyáa eʼpum éʼ besabé-yɛ? Ké-ʼɛ mekɔ̂d méchyáaʼ eʼpum éʼ máŋgəlɛ-yɛ? ");
INSERT INTO bssNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Melemlem-ʼaá bwɛl ké éʼhéé ábe éʼkwogeʼ bwâm, éʼchyáa-ʼɛ eʼpum éʼ bwâm. Boŋ ké éʼhéé ábe béekwɔgéʼ bwâm, béēchyāā-ʼɛ́ eʼpum éʼ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Bwɛl éʼ bwâm béehɛlɛ́ɛ́ eʼpum bé mbéb achyáa. Bwɛl bé mbéb-pɛ béehɛlɛ́ɛ́ eʼpum éʼ bwâm achyáa. ");
INSERT INTO bssNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Bwɛl ké éʼhéé ábe béēchyāāʼ eʼpum éʼ bwâm, nwóó-nzag ǎkwɛl bɔ́, abwém bɔ́ á dǔ. ");
INSERT INTO bssNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Né-ɔɔ́, nyɛ́ɛ̄bīī bekal-bé-eʼdəə́dəŋ bé metóm á mbɛltéd ḿmāb. ");
INSERT INTO bssNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Saké mod tɛ́ɛ́ awě achəgtaad mɛ aá, ‘A-Sáŋ, A-Sáŋ,’ ǎsɔ̄l á nkamlɛn ḿ mín. Bad ábe bébɛle ngáne echem Sáŋ awě adé ámīn áhɛdnɛɛ́ bɔ́, bɔ́ɔ bɛ́sɔ̄l. ");
INSERT INTO bssNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Áde epun é nkáásé mé asóg épɛɛ́, bad híin bɛ́pɛ̌ áwêm, bélāŋgē mɛ bán, ‘A-Sáŋ, A-Sáŋ, ngɔ́mē sêkǎnléʼáá bad mam ḿme Dyǒb álómnéʼáá sé aá mɛ́bɛnléd, á dǐn ádōŋ, sébɛnléd-tɛ ádoŋ dǐn âbíded bad eʼdəə́dəŋ bé mbéb áte, sébɛlé-ʼɛ menyáké híin!’ ");
INSERT INTO bssNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Hɛ́ɛ mɛ́lāāʼɛ́ bɔ́ mɛɛ́, ‘Meebíiʼɛ́ mɛ nyé. Nyésyəə mɛ á dǐd-te! Eʼbébtéd éʼ bad ngɛ̂n!’ ” ");
INSERT INTO bssNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yesuɛ ambád ámpē aá, “Né-ɔɔ́, mod tɛ́ɛ́ awě awógé ábêm eʼyale bɛ́n, boŋ ábɛlé-ʼɛ ngáne éʼhɔ́bɛɛ́, ádíi nɛ́ɛ mod a mekínzɛ́ awě alóó ndáb á ebɛ̂n é aláá mîn âbɛl boŋ éwúu ásē. ");
INSERT INTO bssNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ámbīd e nɛ̂, mbúú e ngíne enchə́, eʼdíb éʼlóne, ekukud-tɛ étóm wɛ́ɛ ene ndáb émbɛ̄ɛ̄, boŋ enkênkwɛɛ́, áyə̄le enlóŋnéd á aláá mîn. ");
INSERT INTO bssNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Boŋ kénzɛ́ɛ́ awě awógé ábêm eʼyale bɛ́n, boŋ eébɛle ngáne éʼhɔ́bɛɛ́, adíi nɛ̂ŋgáne eyɔ́kɛ́l é mod éche élóó eche ndáb á nsíí mîn. ");
INSERT INTO bssNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ámbīd e nɛ̂, mbúú e ngíne enchó, eʼdíb éʼlóne, ekukud-tɛ étóm wɛ́ɛ ene ndáb émbɛ̄ɛ̄. Ene ndáb enkwɛ̌. Enkúme émād-tɛ ahɛnted áte.” ");
INSERT INTO bssNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Áde Yesuɛ ámáá ḿmɛ́n mésyə̄ə̄l ahɔ́b, amute áde áwóglánnáá mɔ́ démbɛ̄ menyáké bwâmbwam áyə̄le nyaa echě áyə́gtéʼáá. ");
INSERT INTO bssNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ayə́gtéʼáá bɔ́ nɛ́ɛ mod awě nzé ahɔ́bé, né émáá. Eeyə́gtéʼaá, nɛ̂ŋgáne bemeléede bé mbéndé. ");
INSERT INTO bssNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesuɛ ansǔd á ekone sé. Áde ápédé é ekone sé ndun e mod ehídéʼáá mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Hɛ̂ dɔ́ɔ mod nhɔ́g awě meləŋ mékóbé ápédé áwē boŋ ábwɔ̄gē mebóbóŋ ne edúbé ésyə̄ə̄l, áhɔ̄bē nɛ́n aá, “A-Sáŋ, nzé edəə́ ehɛle ébɛ̄l mɛ nsáŋ.” ");
INSERT INTO bssNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Dɔ́ɔ Yesuɛ ábídté ekáá, ábānē mɔ́ á yə̌l boŋ álāŋgē mɔ́ aá, “Ndəə́, sáŋ!” Ábwɔ̄g-ábwɔ̄g ḿmê meləŋ mêmmaá ane mod á yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Dɔ́ɔ Yesuɛ áláŋgɛɛ́ mɔ́ aá, “Weeláŋgé modmod dyam áde ábɛ́nlédé, boŋ kɛ̌ élúmed yə̌l wɛ́ɛ prisɛ, ásimɛn wɛ. Ébag-kɛ mendɛ ngáne mbéndé e Mosɛɛ éhɛdɛɛ́, âlúmed bad wɛɛ́ mɔ́sāā.” ");
INSERT INTO bssNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ámbīd e nɛ̂, Yesuɛ ankɛ̌ á dyad á Kapenahum. Nɛ́ɛ ápédé áwed, mod ambáá a sə́nze é Roma ambɛ́ awě akamlaan mbwɔ́kɛl e sə́nze. Ane mod anhyɛ mɔ́ acháŋ, áhɔ̄bē ");
INSERT INTO bssNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","aá “A-Sáŋ, awêm mbəledɛ eédyɛʼɛ́ bwâm, adé á anoŋ de nkole á ndáb. Eéhɛ̄lɛ̄ɛ̄ ahide ásē. Atage bwâmbwam.” ");
INSERT INTO bssNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesuɛ anláá mɔ́ aá, “Mɛɛ́pɛ̌, ńchōōd-tɛ mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Dɔ́ɔ mod ambáá a sə́nze ne átimtanné Yesuɛ aá, “A-Sáŋ, mměn meékwognedɛɛ́ âkob wɛ nken áwêm ndáb, boŋ hɔ́b ké eyale, awêm mbəledɛ ǎdyɛɛ́ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mměn ndíi mod awě adé ásē e nkamlɛn, mměn-nɛ nwóó sə́nze éche ńkamlanné. Nlâŋge pɔ́g mɛɛ́, ‘Kǎg’, ékǎg-kɛ nê děn, empée mɛɛ́ ‘Hyǎg’, éhyǎg-kɛ né děn. Nzé nlâŋge awêm mbəledɛ mɛɛ́, ‘Bɛ̌l échɛ́n’, ábɛlé-ʼɛ né děn.” ");
INSERT INTO bssNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Áde Yesuɛ áwógé nɛ̂, yə̌l enkɔ́m mɔ́ áte. Dɔ́ɔ álâŋgɛɛ́ bad ábe béhídéʼáá mɔ́ aá, “Ne mbále, nlâŋge nyé mɛɛ́, meényīnɛ̄ɛ̄ mod a aloŋ á Israɛl ké nhɔ́g awě awóó nyaa e adúbe echě anɛ́n nken-e-mod áwóó. ");
INSERT INTO bssNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nlâŋge-ʼɛ nyé nɛ́n mɛɛ́ póndé echě ngande ébɛ̄ɛ̄ á nkamlɛn ń Dyǒb, bad híin ábe bénkêntə́ŋgɛ́n abɛ́ áhed bɛ́bīd á akuu ne á mbəŋ âbɛ́ á ngande nchoo ne betaa, Abrahamɛ, Aisigɛ ne Jakɔbɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Boŋ bɛ́bīdēd bad ábe béntə̄ŋgɛ̄n abɛ́ á nkamlɛn ń Dyǒb á ebwɔ́g-te, bébwém bɔ́ á ehíntɛ́n-tê. Áhed-taá béchyɛɛ́ʼɛ́ bédyāg-kɛ mesoŋ á nsəl.” ");
INSERT INTO bssNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ ane mod á sə́nze aá, “Súɛ́ʼ á ndáb, ébɛnled ngáne édúbpé.” Melemlem mé póndé mbəledɛ awě ane mod ambáá a sə́nze andyɛ̌ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ádě Yesuɛ ápédé á ndáb wɛ́ɛ Petro, antán Petro mwaád nyaá á anɔŋ dé nkole, ahéb dênsog mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nɛ́ɛ Yesuɛ áchə́ŋgé mɔ́ á ekáá, ahéb ámāā mɔ́. Anhidé ásē, ákōb-pɛ Yesuɛ nken. ");
INSERT INTO bssNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ene ngukɛ́l bad bêmpɛɛ́n bad híin wɛ́ɛ Yesuɛ, ábe eʼdəə́dəŋ bé mbéb bémbɛ̄ɛ̄ áte. Yesuɛ ambɛnléd ábē eʼyale bé nsəl abídéd ábɛ̂ eʼdəə́dəŋ bé mbéb, áchōōd-tɛ bad bésyə̄ə̄l ábe békónléʼáá. ");
INSERT INTO bssNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yesuɛ ambɛ̌l ḿmɛ́n mésyə̄ə̄l âlóned eʼyale ábe Dyǒb dénlōmēnnē nkal éʼdəə́dəŋ Yesayaa nɛ́n aá, “Ankobɛ́n syánē nkole ńsyə̄ə̄l ne ḿmɛ̄d metake.” ");
INSERT INTO bssNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Áde Yesuɛ ányíné ngáne ndun e mod élə́ŋnédé mɔ́, anláá ábē bembapɛɛ aá bɔ́bɔ̄ɔ bétime á pɛd e edib-é-nzab eníníí. ");
INSERT INTO bssNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hɛ̂ dɔ́ɔ meléede a mbéndé nhɔ́g ápédé áwē boŋ áhɔ̄bē aá, “A-meléed, mɛ̌hīd wɛ kéhéé áde ékagké.” ");
INSERT INTO bssNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesuɛ antimtɛ́n mɔ́ aá, “Eʼbubwóg éʼwóó ábab eʼlóm wɛ́ɛ bésɔ́lɛɛ́, menɔn-nɛ ámpē méwóó ḿmab mǔm, boŋ Mwǎn-a-Moonyoŋ eewóoʼɛ́ hǒm ádě ábánnɛɛ́ nló.” ");
INSERT INTO bssNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Dɔ́ɔ mod ampée awě mɔ́mpē ahídéʼáá Yesuɛ álâŋgɛɛ́ mɔ́ aá, “A-Sáŋ, mwɛ̌, ńsébe ńkɛ ńlíme echem sáŋ.” ");
INSERT INTO bssNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Dɔ́ɔ Yesuɛ átimtanné mɔ́ aá, “Hídé mɛ, chené ndim ḿ bad měn ńlîmme ḿmāb ndim.” ");
INSERT INTO bssNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ene póndé dɔ́ɔ Yesuɛ ásɔ́lé á bɔ̌lɛ-tê ne ábē bembapɛɛ boŋ bébwɔ̄gē ekɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ádě bépédé á edíb-te, dɔ́ɔ ekukud é ngíne ébóótédé atóm. Émbɛ̄ ngíne nyaa echě kə́ə́ŋne bɔ̌lɛ bêmponné asú ásē á mendíb-te. Á póndé eched Yesuɛ akúnéʼáá. ");
INSERT INTO bssNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Hɛ́-ʼaá bembapɛɛ bényemɛɛ́ mɔ́ ásē boŋ bélāŋgē mɔ́ bán, “A-Sáŋ, sôn, wóŋgɛ́n, pɔ́n syánē dewág-ōō!” ");
INSERT INTO bssNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesuɛ ankwɛntɛ́n bɔ́ aá, “Cheé ékə́ə́ boŋ nyéwōgē mbwɔ́g? Cheé ékə́ə́ boŋ ádɛ̄n adúbe ábɛ́ mwǎmpīn nɛ́n?” Dɔ́ɔ átyéémé ámīn, boŋ ákamlán ekukud éche étóméʼáá, ne edíb éche éhódéʼáá áte. Ábwɔ̄g-ábwɔ̄g ekukud énsɛ̄le, edíb ámpē éche éhódéʼáá áte énsōg ahod. ");
INSERT INTO bssNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Yə̌l enkɔ́m bembapɛɛ áte bwâmbwam áde bényíné nɛ̂, bésɛdté bánken, “Ebə́l é mod éhéé chɛ́n éche kə́ə́ŋ ne ekukud ne mendíb béwógnɛɛ́?” ");
INSERT INTO bssNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Áde Yesuɛ ne ábē bembapɛɛ bépédé á múde mé edib-é-nzab ḿmíníí, á mbwɔ́g e bad bé Gɛrasin, bad bébɛ ábe bémbīd á soóbadɛ bêmbomɛ́n mɔ́. Eʼdəə́dəŋ bé mbéb bémbɛ̄ ábê bad bébɛ áte. Ábê bad bémbɛ̄ ngaŋlɛn nyaa echě mod ké nhɔ́g éechuɛʼaá ene nzii abwɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Anyín áde bényíné Yesuɛ, bêmbootéd abón bán, “A-Mwǎn a Dyǒb, cheé syánē déwóŋné? Epedé hɛ́n âkɔ́gsɛn sé áde póndé éēpēdɛ̄ɛ̄-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Esɔg é nguu chɔ́-ʼɛ ébédé bɛnbɛn ne áhed, édyāg medyɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Hɛ́ɛ ábɛ̂ eʼdəə́dəŋ bé mbéb éʼcháa-ʼɛ Yesuɛ bán, “Sêbíí bán wɛ̌bīdēd sé, boŋ tɛdé sésɔ̂l á esɔg é nguu-tê éche édé híníí nɛ̂.” ");
INSERT INTO bssNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Dɔ́ɔ Yesuɛ ákamlanné ábê eʼdəə́dəŋ bé mbéb aá, “Nyébîd!” Abíd áde ábê eʼdəə́dəŋ bé mbéb éʼbídé ábê bad áte, bénsɔ̄l nguu chê áte. Ábwɔ̄g-ábwɔ̄g, échê esɔg é nguu émpādē ásē, ényəgtéʼ á eláá é nkin mé edib-é-nzab, éhún á edib-tê, éwɛ́-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Benɔn bé nguu béntōm mehélé á dyad-tê, békag békanlé bad dyam áde ábɛ́nlédé ne ábê bad ábe eʼdəə́dəŋ bé mbéb bémbɛ̄ɛ̄ áte. ");
INSERT INTO bssNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Awóg áde ábê bad bé dyad béwógé nɛ̂, bémpādē ásē âkɛ dé atán Yesuɛ. Nɛ́ɛ bényíné mɔ́, bénchāŋ mɔ́ bán, áhide áwab mbwɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ámbīd e ene póndé, Yesuɛ ansɔ́l á bɔ̌lɛ-tê ámpē, áchābē edib-é-nzab, átīm ámbīd áwē dyad wɛ́ɛ ádyɛ́ɛ́ʼáá. ");
INSERT INTO bssNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Apɛ áde Yesuɛ ápédé áwē dyad, bad behɔ́g bêmpɛɛ́n mod á mekále mîn awě awédé epɛd. Áde Yesuɛ ányíné adúbe áde ábê bad, anláá ane mod awě awédé epɛd aá, “A-mwǎn, weewógé mbwɔ́g, nlagsɛ́né wɛ mbéb.” ");
INSERT INTO bssNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Hɛ̂ dɔ́ɔ doŋge dé bemeléede bé mbéndé bényoŋgɛɛ́ áte bán, “Anɛ́n mod asyə́ə Dyǒb!” ");
INSERT INTO bssNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesuɛ anchěm bɔ́ mewêmtɛn áte. Hɛ́ɛ ásɛdtɛɛ́ bɔ́ aáken, “Cheé ékə́ə́ boŋ nyêwóŋ ḿmɛ́n mewêmtɛn mé mbéb áte? ");
INSERT INTO bssNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ahéé adé dyam ásad, âhɔ́b wɛɛ́, ‘Nlagsɛ́né wɛ mbéb,’ káa âhɔ́b wɛɛ́, ‘Syəə́ ásē, ébooted akɛ?’ ");
INSERT INTO bssNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Boŋ mɛ̌lūmēd nyé mɛɛ́ Mwǎn-a-Moonyoŋ awóó kunze á nkǒŋsé âlagsɛn mbéb.” Hɛ́ɛ álâŋgɛɛ́ ane mod awě awédé epɛd aá, “Syəə́ ásē, étêd ḿmôŋ mekále, ésúɛʼ á ndáb.” ");
INSERT INTO bssNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Dɔ́ɔ ane mod áhídté ásē boŋ ásūɛ̄-ʼɛ á ndáb. ");
INSERT INTO bssNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mbwɔ́g ménkōb bad ábe bényīn ngáne ádɛ́n akan ábɛ́nlédé. Bébootéd-tɛ Dyǒb akɛn áde ábágé baányoŋ kunze âbɛl échɛ́n ndín é mam. ");
INSERT INTO bssNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ámbīd enɛ̂ Yesuɛ ansyəə́ ádê abwɔ́g á hǒm. Áde ákagké nɛ̂, annyín mod awě béchə́géʼáá bán, Matyo. Matyo andyɛɛ́ ásē á ndáb eche ásáŋtéʼáá táásɛ áte. Hɛ́ɛ Yesuɛ álâŋgɛɛ́ mɔ́ nɛ́n aá, “Hídé mɛ.” Dɔ́ɔ Matyo átyéémé ámīn, boŋ áhīdē-ʼɛ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ámbīd e póndé Yesuɛ ankɛ̌ á ndáb wɛ́ɛ Matyo âdyɛ́ ndyééd. Ekud é besaad bé táásɛ né bad bé mbéb bémpēe bêmpɛ̌ bédyɛ̄ɛ̄n Yesuɛ ne ábē bembapɛɛ áhed. ");
INSERT INTO bssNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nɛ́ɛ doŋge dé Befarisia bényíné ngáne Yesuɛ ádyɛ́ɛ́né échê ndín é bad, bênsɛdéd ábē bembapɛɛ bánken, “Cheé ékə́ə́ boŋ awɛn meléede ádyāg ndyééd ne besaad bé táásɛ ne bebɛl bé mbéb bémpēe?” ");
INSERT INTO bssNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Dɔ́ɔ Yesuɛ ákwɛntanné bɔ́ aá, “Bad ábe bédyɛ́ɛ́ bwâm béetógnɛnɛɛ́ mod-a-bwɛl. Bad ábe békonleʼ bɔ́ɔ bétógnɛ́né mod-a-bwɛl. ");
INSERT INTO bssNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nyékɛ nyéhɛd áte âbɛl nyésôŋtɛn ábɛ́n eʼyale ábe éʼténlédé á kálag e Dyǒb nɛ́n bán, ‘Chǒm éche ńhɛdnɛɛ́ bad édíi nlém ń ngɔl, saké mendɛ.’ Meépedɛɛ́ á nkǒŋsé âchɛ́le bad ábe békóbnédé áʼsō éʼ Dyǒb, boŋ mpedé áyə̄le bad bé mbéb.” ");
INSERT INTO bssNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Hɛ̂ dɔ́ɔ bembapɛɛ ábe Jɔnɛ, Ndusɛnɛ bépédé wɛ́ɛ Yesuɛ boŋ bésɛdté mɔ́ bánken, “Cheé ékə́ə́ boŋ sé ne Befarisia sédidé yə̌l nzaa á mekáne-tê, boŋ ábōŋ bembapɛɛ pɛn béedidéʼ?” ");
INSERT INTO bssNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesuɛ ankwɛntɛ́n bɔ́ ne ngan aá, “Chán bad ábe bélébpé á ngande e eʼwóŋgé béhɛle bélebeʼ áde bédíí ne mod awě akudé sɔ́mbé? Béehɛlɛ́ɛ́. Boŋ epun épɛ̌ éche bɛ́kobɛ́nné bɔ́ mod awě akudé sɔ́mbé. Échê epun dɔ́ɔ bɛ́didté yə̌l nzaa á mekáne-tê. ");
INSERT INTO bssNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nyêbíí nɛ́n bán, nzé mod anabpeʼ mbɔ́té, eetédɛ́ɛ́ epɛd é abad ékɔ̄ɔ̄lē sɛ ánabnéd nchun ḿ mbɔ́té, áyə̄le nzé échê epɛd é abad ékɔ̄ɔ̄lē ébóótédé abób áte ébɛlé éhabnéd abad dé nchun. Nɛ̂ ábɛleʼ échê epɔn é mbɔ́té ékəleʼ áte tómaa ngáne énsēbɛ̄ɛ̄ abɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Melemlem nɛ̂ŋgáne mod éētēdɛ̄ɛ̄ mǐm mékɔ̄ɔ̄lē se ápen mɔ́ á nchun mé ntyə́g ń ngob e nyam. Áyə̄le nzé abɛlé nɛ̂, né mǐm mɛ́hǒd kə́ə́ŋ ntyə́g ń'yɛ́d? Mǐm mɛ́mād asyɔge, ntyə́g-kɛ ámpē ḿbéb. Boŋ bétédɛɛ́ mǐm mékɔ̄ɔ̄lē béhɛ́ á ntyə́g mékɔ̄ɔ̄lē-te. Nɛ̂ ábɛleʼ mǐm mébɛ́ bwâm, ntyə́g-kɛ ámpē ḿbɛ́ bwâm.” ");
INSERT INTO bssNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Áde Yesuɛ áláŋgɛɛ́ bad ḿmɛ́n mekan, mod a nkamlɛn nhɔ́g ampɛ̌ áwē abwɔ́g mebóbóŋ ne edúbé ésyə̄ə̄l, áhɔ̄bē nɛ́n aá, “Awem mwǎn a mmwaád awédé bɔɔb nɛ́n děn, hyǎg ébân mɔ́ ekáá á yə̌l âbɛl nɛ́n ápuu.” ");
INSERT INTO bssNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Né-ɔɔ́ Yesuɛ ampádé ásē ne ábē bembapɛɛ béhīdē ane mod. ");
INSERT INTO bssNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Áde békagké nɛ̂, mmwaád nhɔ́g ambɛ́ awě anwóŋ nkole ḿme mekií mébídéʼáá mɔ́ á yə̌l póndé ésyə̄ə̄l. Ḿmê nkole ḿbédé mɔ́ á yə̌l á etûn é dyôm-a-mwɛ́ ne ḿbɛ. Hɛ́ɛ ane mmwaád ábídé Yesuɛ á mbíd, ásitán mɔ́ mesó mé nkobe ḿme ánwāāʼɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ambɛl nɛ̂ áyə̄le ánwálé mewêmtɛn aá, nzé mɔ́sitɛ́né ḿmē nkobe, aá né mɔ́ɔdyɛɛ́ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Dɔ́ɔ Yesuɛ ákúnnédé boŋ anyín ane mmwaád. Anyín áde ányíné mɔ́ dɔ́ɔ álâŋgɛɛ́ mɔ́ aá, “A-mwǎn-a-mmwaád, adúbe ádōŋ ádídé wɛ bwâm.” Ábwɔ̄g-ábwɔ̄g ane mmwaád andyɛɛ́ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesuɛ ampɛ̌ á ndáb echě ane mod a nkamlɛn. Áde ásɔ́lé á ndáb-te, antán ndun e mod ebɛle ntɔgag ń ngíne ne bad ábɛ bétóo eʼlóŋ, békɔ̄nē-ʼɛ nkə́ŋgé ń kwééd. ");
INSERT INTO bssNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Dɔ́ɔ Yesuɛ áhɔ́bɛɛ́ aá, “Nyé moosyəə́l nyébîd á ebwɔ́g, áyə̄le anɛ́n mwǎn-a-mmwaád eewédɛ́ɛ́, akúne kúnɛ́n.” Hɛ́ɛ bɔ́ moosyəə́l bébóótédé mɔ́ awɔɔ. ");
INSERT INTO bssNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Boŋ áde ene ndun e mod émáá abíd á ebwɔ́g dɔ́ɔ Yesuɛ ásɔ́lé á toŋ echě bênnaádté ane mwǎn. Nɛ́ɛ Yesuɛ áchéŋgé mɔ́ á ekáá, apádé-ʼɛ ásē ábwɔ̄g-ábwɔ̄g. ");
INSERT INTO bssNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ádɛ́n akan dênkanléd ene pɛd e aloŋ esyəə́l. ");
INSERT INTO bssNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nɛ́ɛ Yesuɛ áhídté ádɛ̂ abwɔ́g á hǒm, bad bébɛ ábe bênkwɛ̌ ndím béhídéʼáá mɔ́ ámbīd, bélēbpē-ʼɛ eʼsaád bán, “A-Mwǎn a mbyaa ḿme Dabidɛ, wóg sé ngɔl.” ");
INSERT INTO bssNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Áde Yesuɛ ásɔ́lé á ndáb-te, ábê bad bébɛ ábe bênkwɛ̌ ndím béntān mɔ́. Dɔ́ɔ Yesuɛ ásɛdtɛɛ́ bɔ́ aá, “Nyêdúbpé nɛ́n bán nhɛle ḿbɛl nyênyínɛn-ɛ?” Bênkwɛntɛ́n mɔ́ bán, “Ɛɛ. A-Sáŋ, sêdúbpé.” ");
INSERT INTO bssNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dɔ́ɔ Yesuɛ ábáné bɔ́ mekáá á mǐd, boŋ áhɔ̄bē nɛ́n aá, “Nyêwóó adúbe bán nyɛ́ɛ̄nyīnɛ̄n, né-ɔɔ́ ébɛnled ngáne nyédúbpé.” ");
INSERT INTO bssNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ábwɔ̄g-ábwɔ̄g bébootéd-tɛ anyínɛn. Boŋ Yesuɛ asím bɔ́ etúu áte, álāŋgē bɔ́ aá, “Nyéeláŋgé mod ké nhɔ́g ádɛ́n dyam áde ábɛ́nlédé.” ");
INSERT INTO bssNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Boŋ ké nɛ̂, nɛ́ɛ bébídé áhed, bémbɛ̄ békɛ̄ɛ̄n nkalaŋ enɛ pɛd é aloŋ ésyə̄ə̄l ngáne Yesuɛ ábɛ́lé menyáké. ");
INSERT INTO bssNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nɛ́ɛ ábê bad bébɛ ábe bênkwɛ̌ ndím ábe Yesuɛ áchóŋté béhídté, bad bêmpɛɛ́n mod wɛ́ɛ Yesuɛ awě ankwɛ̌ ebóbé áyə̄le edəə́dəŋ é mbéb émbɛ̄ mɔ́ áte. ");
INSERT INTO bssNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Boŋ áde Yesuɛ ámáá ane mod échê edəə́dəŋ é mbéb abíded áte, ambootéd dyam ahɔ́b. Nɛ́n dénkōbēd ndun e mod echě ebédé áhed menyáké, béhɔ̄bē-ʼɛ bán, “Dyam nɛ́ɛ ádɛ́n déēbɛ̄nlēdɛ̄ɛ̄ á Israɛl mbêd.” ");
INSERT INTO bssNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Boŋ Befarisia pɛn béhɔ̄bē nɛ́n bán, ahɛle bad eʼdəə́dəŋ bé mbéb ahúd áte áyə̄le kə̂ŋ e eʼdəə́dəŋ bé mbéb chɔ́ɔ ebage mɔ́ ngíne âbɛl nɛ̂. ");
INSERT INTO bssNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Né-ɔɔ́ Yesuɛ akagéʼáá myad mésyə̄ə̄l, mémbáá ne mésad ene pɛd e aloŋ, áyə̄gtē eyale é Dyǒb á ndáb é mekáne, ákalé-ʼɛ nkalaŋ ḿ bwâm mé nkamlɛn ń Dyǒb. Yesuɛ achǒŋtéʼáá bad bé nkole bésyə̄ə̄l ne nyaa é nkole ésyə̄ə̄l éche émbɛ̄ átîntê echâb. ");
INSERT INTO bssNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Áde Yesuɛ ányíné ndun e mod, ngɔl enlɔ́g mɔ́ á nlém-tê bwâmbwam áyə̄le echâb. Ambɛ́ bɔ́ ngɔl áyə̄le bétágéʼáá áte, béēwóo-ʼɛ nwóŋgɛn. Bémbɛ̄ nɛ́ɛ ńdyɔŋ ḿ mbód ḿme méēwōo nnɔn. ");
INSERT INTO bssNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Dɔ́ɔ álâŋgɛɛ́ ábē bembapɛɛ aá, “Nzag echyáá bwâmbwam, bwěm éʼhɛdnaad apád, boŋ bepád béebuuʼɛ́ áte. ");
INSERT INTO bssNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Né-ɔɔ́, nyékânne nɛ́n bán nwóó-nzag álôm bepád.” ");
INSERT INTO bssNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ámbīd e nɛ̂ Yesuɛ anlǎd ábē bembapɛɛ dyôm ne bébɛ áte. Ambɛ bɔ́ kunze âbíded bad eʼdəə́dəŋ bé mbéb áte, âchood bad bé nkole ne nyaa é nkole ésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mǐn ḿme bembapɛɛ bé nlómag dyôm ne bébɛ ábe Yesuɛ mɔ̂mɛ́n: Aʼsó, Simɔnɛ awě béchə́géʼáá bán Petro ne mwǎnyaŋ Andreya. Jemsɛ bɔ́ mwǎnyaŋ Jɔnɛ, bǎn ábe Zɛbɛdiɛ, ");
INSERT INTO bssNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filibɛ ne Batolomyo, Tɔmasɛ ne Matyo nsaad-a-táásɛ, Jemsɛ mwǎn awě Alfɔsɛ, ne Tadiosɛ, ");
INSERT INTO bssNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simɔnɛ awě ambɛ́ á epepé é kə́n e aloŋ, ne Judas Iskariɔdɛ awě antǐm Yesuɛ asóm. ");
INSERT INTO bssNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ábɛ̂ bad dyôm ne bébɛ bɔ́ɔ Yesuɛ ánlōmmē. Anláá bɔ́ aá, “Nyéēkāg á myad ḿme méesɛ̌ myad mé aloŋ á Israɛl, nyéēkāg-kɛ dyad ké ahɔ́g á aloŋ á Samaria. ");
INSERT INTO bssNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Boŋ nyékag wɛ́ɛ bad bé Israɛl. Bédé nɛ́ɛ ńdyɔŋ ḿ mbód ḿme ḿbɔ́ɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nyékag, ngáne nyékagké, nyéhə̂ŋte nɛ́n bán, ‘Nkamlɛn ḿ mín ńdé bɛnbɛn.’ ");
INSERT INTO bssNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nyéchoŋte bad bé nkole, nyépuudte bad ábe béwédé, nyéchoŋte bad ábe békonle nkole mé meləŋ âbɛl bésâŋ, nyébídte-ʼɛ bad eʼdəə́dəŋ bé mbéb áte. Mbagé nyé ngíne âbɛl ḿmɛ́n mésyə̄ə̄l, meéhɛdnɛɛ́ nyé nsábe. Né-ɔɔ́ nyémpē nyékɛ nyébɛle melemlem nyéēhɛ̄dnē bad nsábe. ");
INSERT INTO bssNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nyéewánlé mɔné ké nhɔ́g áyə̄l. ");
INSERT INTO bssNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nyéewánlé ekwɛ, kéʼɛ mbɔ́té ébɛ áyə̄l. Nyéewánlé metámbé, kéʼɛ ntóŋ. Áyə̄le mod a nsɔ́n atə́ŋgɛ́né ndyééd akud wɛ́ɛ mod awě ábɛnlɛɛ́ nsɔ́n. ");
INSERT INTO bssNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nzé nyêsɔ́lé dyad ké ahéé, nyéhɛ̄d mod awě akwɛ̌ntɛ́né nyé nken akob, nyédyɛ̄ɛ̄ áwe ndáb kə́ə́ŋ ne póndé éche nyéhidtɛɛ́ ádê dyad. ");
INSERT INTO bssNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ndáb ké ehéé echě nyésɔ́lé áte, nyélɛ̄lēd bad ábe bédé áwēd-te nɛ́n bán, ‘Nsaŋ ḿbɛ̂ ne nyé.’ ");
INSERT INTO bssNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nzé bad ábe bédé áwēd-te békóbé nyé nken, ḿmɛ̄n melɛntɛn mé nsaŋ ń Dyǒb ḿbɛ̂ ne bɔ́. Boŋ nzé béekobe nyé nken, ḿmɛ̄n melɛntɛn ńsû ne nyé. ");
INSERT INTO bssNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Boŋ nzé nyêpedé ndáb kéʼɛ dyad ké áhéé, boŋ béekwɛntɛne nyé awóglɛn, nyékūd ebumbú á mekuu áde nyéhidtɛɛ́ áhed, âlúmed nɛ́n bán, Dyǒb déekobɛɛ́ bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ne mbále, nlâŋge nyé nɛ́n mɛɛ́ á Epun é Nkáásé, nkɔ́gsɛn ḿme myad mé Sodom ne Gomora bɛ́nyīnnē mɛ́bɛ̄ mwǎmpīn tómaa ḿme bad ábe bédé ádê dyad.” ");
INSERT INTO bssNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yesuɛ ambád aá, “Nyénɔneʼ, nlóme nyé nɛ́ɛ ńdyɔŋ ḿ mbód átîntê e ngə. Né-ɔɔ́ nyébɛ̂ mekínzɛ́ nɛ́ɛ nyə̌, nyépwiited-tɛ nɛ́ɛ élə̄ə̄. ");
INSERT INTO bssNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nyétêd póndé, áyə̄le bad bɛ́bē ábe bɛ́kɛɛ́n nyé á kóte, béswādtēd nyé eʼtaŋgú áwab ndáb é mekáne. ");
INSERT INTO bssNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Áyə̄l e echêm bɛ́pɛɛ́n nyé áʼsō éʼ benkamlɛnɛ ne éʼ kə̂ŋ. Bɛ́bɛ̌l nɛ̂ âbɛl nyékale bɔ́ nkalaŋ ḿ bwâm, nyékale-ʼɛ bad ábe béesɛ̌ bad bé Israɛl. ");
INSERT INTO bssNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nzé bépɛ́ɛ́né nyé ké ahéé ákáad nyé, mod eétāgēʼ áte áyə̄le chǒm-ɛ́ɛ áhɔ̄bpē kéʼɛ ngáne áhɔ̄bpē chɔ́. Áde póndé épɛɛ́, chǒm ébɛ̄ éche áhɔ̄bpē. ");
INSERT INTO bssNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Eʼyale ábe áhɔ̄bpē béebáá ábē, bɛ́hūū ne Edəə́dəŋ éche eche Sáŋ awě ǎhɔ̄bpē mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Mod ǎbɛ mwǎnyaŋ á mekáá mé bad bémpēe âbɛl béwúu mɔ́. Sɛ́ɛ mwǎn ámpē ǎbɛ̌l melemlem ne mwǎn. Mwǎn ǎkunnɛ́n sáá ne nyaŋ yə̌l ábɛ̄l béwúú-ʼɛ bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mod asyəə́l ǎkɔɔ́ nyé, áyə̄l echêm, boŋ kénzɛ́ɛ́ awě ǎkaán ḿmē metake nlém kə́ə́ŋ ne a asóg, ǎkǔd eʼsoósoŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nzé bétágté nyé á dyad ahɔ́g, nyényəged nyékɛ ádíníí. Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, nyéepaá nsɔ́n amad á myad mé aloŋ á Israɛl mésyə̄ə̄l, boŋ Mwǎn-a-Moonyoŋ ápag. ");
INSERT INTO bssNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mwǎn-a-ayə́ge eetómɛɛ́ mod awě ayə́gte mɔ́. Mbəledɛ-ʼɛ eetómɛɛ́ eche sáŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Né-ɔɔ́ mwǎn-a-ayə́ge eetə̂ŋgɛnɛɛ́ nɛ́ɛ áhɛdɛɛ́ edúbé éche étómé éche mod awě ayə́gte mɔ́. Mbəledɛ-ʼɛ ámpē eetə̂ŋgɛnɛɛ́ nɛ́ɛ áhɛdɛɛ́ edúbé éche étómé éche eche sáŋ. Nzé béchúúdé sáá-a-mbwɔ́g bán Bɛlzɛbulɛ, né bɛ́chuú bad ábe bédé áwe ndáb mǐn ḿme mébébé tómaa nɛ̂. ");
INSERT INTO bssNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Né-ɔɔ́ nyéebááʼ moonyoŋ. Áyə̄le dyamdyam déesaá á eʼkoŋnéd-te áde déebíd áwed. Ké ahɔ́g-kɛ déesaá, áde ásɔ́ɔ́mé boŋ bán déebyɛ́ɛ́nné. ");
INSERT INTO bssNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mam mésyə̄ə̄l ḿme ńlâŋgɛɛ́ nyé á ehíntɛ́n-tê, nyéhɔ̂b mɔ́ á eʼnyínɛn bé ekíde. Mésyə̄ə̄l-lɛ ḿme nyéwógé á kun-tê, nyékal mɔ́ á nhɛ́né. ");
INSERT INTO bssNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nyéewógé mbwɔ́g ne moonyoŋ awě ahɛle awúú ekob é yə̌l, boŋ eéhɛ̄lēʼ edəə́dəŋ awúu. Boŋ nyébáa Dyǒb áde áhɛle ábébéd ekob é yə̌l, abébéd-tɛ edəə́dəŋ á dǔ-á-muú. ");
INSERT INTO bssNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Éesaá mbále nɛ́n bán, bésómeʼ ndun ébɛ áyə̄le kábpe pɔ́g-ɛ? Ké nɛ̂, ké pɔ́g eehúnɛ́ɛ́ á ndɔɔb ésebɛ́ á nkwɛntɛn ḿme echɛn Sáŋ Dyǒbɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Boŋ ne nyé, Dyǒb ábíí kə́ə́ŋne mesoŋgé mé eʼsid ábe éʼdé nyé á nló. ");
INSERT INTO bssNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Né-ɔɔ́, nyéewógé mbwɔ́g, nyêdé etógnɛ́n tómaa ndun, ké êmbuú ké áte. ");
INSERT INTO bssNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Kénzɛ́ɛ́ awě ǎbīd mɛ mbóŋ áʼsō éʼ baányoŋ, mɛ-ʼɛ mɛ̌bīd mɔ́ mbóŋ áʼsō wɛ́ɛ echem Sáŋ awě adé ámīn. ");
INSERT INTO bssNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Boŋ kénzɛ́ɛ́-ʼɛ awě ǎbāŋ mɛ áyə̄l áʼsō éʼ baányoŋ, mɛ-ʼɛ mɛ̌bāŋ mɔ́ áyə̄l áʼsō wɛ́ɛ echem Sáŋ awě adé ámīn. ");
INSERT INTO bssNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Nyéewémtán nɛ́n bán, nhyedé á nkǒŋsé âpɛɛn nsaŋ. Aáy, meépedɛɛ́ âpɛɛn nsaŋ, boŋ ngabɛ́n. ");
INSERT INTO bssNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mpedé âkón mwǎn a mwɛnchóm âtə́ŋgɛn sáá, mwǎn a mmwaád âtə́ŋgɛn nyaá, mmwaád-tɛ âtə́ŋgɛn nyǎŋ-kə́lé. ");
INSERT INTO bssNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Bad bé ekoyí bé mod bɛ́bīd áwe ndáb-te děn. ");
INSERT INTO bssNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Kénzɛ́ɛ́ awě adəə́ nyaá kéʼɛ sáá tómaa mɛ eékwognedɛɛ́ awêm mbapɛɛ abɛ́. Kénzɛ́ɛ́-ʼɛ awě adəə́ awe mwǎn a mwɛnchóm kéʼɛ awe mwǎn a mmwaád tómaa mɛ, eékwognedɛɛ́ awêm mbapɛɛ abɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kénzɛ́ɛ́-ʼɛ awě éepém ádē awɔg se áhīdnē mɛ, eékwognedɛɛ́ âbɛ́ awêm mbapɛɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kénzɛ́ɛ́ awě ahɛde ádē aloŋgé asoŋ, ǎbɔ̄d dɔ́. Boŋ kénzɛ́ɛ́-ʼɛ awě ǎbɔ̄d ádē aloŋgé áyə̄le echêm, ǎkud aloŋgé áde déemaáʼ. ");
INSERT INTO bssNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Kénzɛ́ɛ́ awě akobé nyé nken, né mɛ-ɛɛ́ ákóbé nken. Kénzɛ́ɛ́-ʼɛ awě akobé mɛ nken né echem Sáŋ awě alómé mɛ mɔ́ɔ̄ ákóbé nken. ");
INSERT INTO bssNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kénzɛ́ɛ́ awě akobé nkal éʼdəə́dəŋ nken áyə̄le ádíí nkal éʼdəə́dəŋ, ǎkud nsábe mé nkal éʼdəə́dəŋ. Kénzɛ́ɛ́-ʼɛ awě akobé mod awě asáá nken áyə̄le ásáá, ǎkud nsábe ḿme mod awě asáá. ");
INSERT INTO bssNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, kénzɛ́ɛ́ awě abagé ké mendíb mámwɛ́ ngɛ̂n wɛ́ɛ anɛ́n nhɔ́g awě ahíde mɛ, ké ane awě eébude etógnɛ́n abɛ́, atə́ŋgɛ́né nɛ́ɛ ákúdé nsábe ń Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Áde Yesuɛ ámáá ábē bembapɛɛ dyôm ne bébɛ ḿmɛ́n mésyə̄ə̄l alyə́gtɛn, anhidé ádê abwɔ́g á hǒm âkɛ dɛ́yə́ged ne âkal eyale é Dyǒb á myad ḿme mébédé bɛnbɛn ne áhed. ");
INSERT INTO bssNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ene póndé Jɔnɛ, Ndusɛnɛ ambɛ́ á mbwɔg. Áde áwógé mam mésyə̄ə̄l ḿme Krǐstəə ábɛ́léʼáá, anlóm ábē bembapɛɛ áwē. ");
INSERT INTO bssNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Anhɔ́b aá bésɛded mɔ́ bánken, mɔ́ adé ane awě Dyǒb áhɔ́bé aá mɔ́ɔ̄lōm-ɛ, ngé bésineʼ mod ampée? ");
INSERT INTO bssNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Hɛ́ɛ Yesuɛ átimtanné bɔ́ aá, “Nyétimeʼ ámbīd, nyékɛ nyéláa Jɔnɛ mekan ḿme nyéwógé ne ḿme nyényínné dǐd. ");
INSERT INTO bssNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nyéláa mɔ́ bán, bad ábe bênkwɛ̌ ndím bényînneʼ, ábe bésyə́gtáá, békag bwâm, ábe meləŋ ménkōbpē, bésáá. Ábe bênkwɛ̌ ndɔ́g béwógneʼ, ábe bénwɛ̄, bépuudeʼ, nkalaŋ ḿ bwâm-mɛ ámpē ńkalteʼ wɛ́ɛ betóótōkɛ̄ bé bad. ");
INSERT INTO bssNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nnam ḿbɛ̂-ʼɛ ne kénzɛ́ɛ́ awě eéhəŋlɛne nlém á abum tə̂ŋgɛne mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Áde bembapɛɛ ábē Jɔnɛ bétimɛɛ́ ámbīd nɛ̂, dɔ́ɔ Yesuɛ ábóótédé ndun e mod echě embɛ́ áhed akale tə̂ŋgɛne Jɔnɛ. Ansɛdéd bɔ́ aáken, “Póndé echě nyémbīdtē âkɛ dɛ́tán Jɔnɛ á ehyáŋge, cheé nyéwēmtɛ̄nnē bán nyɛ́ɛ̄nyīn? Apab á chyaá áde epub éságtɛɛ́-yɛ? ");
INSERT INTO bssNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Cheé nyênkoŋgé abíd âkɛ dé anyín? Mod awě ahédé mbɔ́té echě ébóó bwâmbwam-ɛ? Bad ábe béhâg échê ndín é mbɔ́té bédyɛɛ dásɔ̄ á ndáb é kə̂ŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nyéláa mɛ, cheé nyémbīdtē âkɛ dɛ́nyín. Nkal éʼdəə́dəŋ mɔ́ɔ nyênkɛɛ́ anyín-ɛ? Nɛ̂ děn! Ne mbále nlâŋge nyé mɛɛ́, nyênyíné mod awě atómé nkal éʼdəə́dəŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jɔnɛ mɔ́ adé ane awě béhɔ́béʼáá áde bétélé eʼyale ábe Dyǒb áhɔ́bé aá, ‘Nɔnéʼ, nlóme ḿmêm mésɛ́nzɛ ḿme mɛ́sēbē wɛ áʼsō, âboŋsɛn wɛ nzii.’ ");
INSERT INTO bssNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, mod ké nhɔ́g awě abídé á abum dé mmwaád eetómɛɛ́ Jɔnɛ, Ndusɛnɛ. Boŋ ké nɛ̂, mod awě adé ndimtɛn áyə̄le bad ábe bédé á nkamlɛn ḿ mín, adé etógnɛ́n tómaa Jɔnɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Bootya ne póndé echě Jɔnɛ, Ndusɛnɛ ábóótédé nkalaŋ ń Dyǒb akal kə́ə́ŋ ne epun éʼchii, nkamlɛn ḿ mín ńkude metake híin á mekáá mé bad, eʼwaŋge éʼ bad-tɛ éʼkume ḿmê nkamlɛn nzum. ");
INSERT INTO bssNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mbéndé ne bekal béʼdəə́dəŋ béhɔ́bé tə̂ŋgɛne ḿmê nkamlɛn kə́ə́ŋ ne póndé echě Jɔnɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Né-ɔɔ́, nzé nyêbǒŋsɛ́né échab ehɔ́b adúbe, Jɔnɛ mɔ́ adé ane awě béhɔ́béʼáá áde bénhɔ̄pē bán, Elaijaa ahúɛʼ. ");
INSERT INTO bssNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kénzɛ́ɛ́ awě awóó metúu áwógeʼ. ");
INSERT INTO bssNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Boŋ cheé mɛ́həgtɛ́nné nyoŋgɛl eʼchii? Enɛ́n nyoŋgɛl edíi nɛ̂ŋgáne běndem ábe bédyɛ́ɛ́ á dyad-tê, boŋ bélēbpē nhɔ́g ne aníníí, ");
INSERT INTO bssNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","bán, ‘Sêtóŋgé nyé eʼloŋ, boŋ nyéeságɛɛ́. Sêkɔ́nné nyé nkə́ŋgé ń kwééd, boŋ ké nɛ̂ nyéēlēbɛ̄ɛ̄.’ ");
INSERT INTO bssNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Áyə̄le, Jɔnɛ abédé, eéyɔkeʼaá ndyééd adyɛ́, eemwágeʼaá-ʼɛ mǐm, béhɔ̄bē bán, ‘Edəə́dəŋ é mbéb édé mɔ́ áte.’ ");
INSERT INTO bssNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwǎn-a-Moonyoŋ apedé, ádyāg ndyééd, ámwāg-kɛ mǐm, béhɔ́be bán, ‘Nyénɔ́ne mɔ́, adəə́ ndyééd bwâmbwam. Mmwɛ́-mǐmɛ ngɛ̂n, awoŋne belad bé táásɛ ne bebɛl bé mbéb.’ Boŋ kə́ə́ŋ ne á asóg, mam ḿme mɛ́bɛnléd mɛ́lūmēd nɛ́n bán, debyɛ́ɛ́ á Dyǒb átə́ŋgɛ́né.” ");
INSERT INTO bssNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Bad ábe bébédé á myad ḿme Yesuɛ âmbɛnlé ekud é menyáké áte bénkênhəŋlɛ́nné ádab abɛ́ dé mbéb. Né-ɔɔ́ Yesuɛ ambootéd bɔ́ akáne áte, ");
INSERT INTO bssNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","áhɔ̄bē aá, “Á-bad bé Korazin, ébɛ̄ɛ̄n nyé ebébtéd! Ébɛ̄ɛ̄n nyémpē ebébtéd á-bad bé Betsaida! Áyə̄le nzé émbɛ̄ bán, ndəle é mekan éche Dyǒb ábɛ́lé áwɛ̄n myad, mêmbɛnléd nɛ̂ á dyad á Tirɛ ne dyad á Sidɔn, né bénwāā melebe se etûn, bémwagtéd-tɛ mbúmbú áyə̄l âlúmed nɛ́n bán, béhə́ŋlɛ́né ádab abɛ́ dé mbéb. ");
INSERT INTO bssNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mbále, nlâŋge nyé nɛ́n mɛɛ́, á mbwɛ mé nkáásé, nkáá ḿme bad bé Tirɛ ne bé Sidɔn mɛ́bɛ̄ mwǎmpīn tómaa ḿmɛ̄n. ");
INSERT INTO bssNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nyé bad bé Kapenahum ámpē, nyêwêmtan bán, nyêmaá apɛ ádyōb, boŋ bɛ́sudéd nyé kə́ə́ŋse ásē á dǔ-á-muú. Nzé menyáké ḿme Dyǒb ábɛ́lé áwɛ̄n dyad mêmbɛnléd á Sodom né ádê dyad ádíi ádé chii. ");
INSERT INTO bssNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Boŋ ne mbále nlâŋge nyé nɛ́n mɛɛ́ á mbwɛ mé nkáásé Dyǒb dɛ́lūmēd ngɔl ne bad bé Sodom tómaa ne nyé.” ");
INSERT INTO bssNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ene Póndé Yesuɛ anhɔ́b aá, “A-Tɛ̂, Sáŋgwɛ́ɛ́ a nkoŋ ḿ mín ne ń sé, nságnɛn ḿbɛ̂ ne wɛ, áyə̄le elúmté mpín ḿ běndem mam ḿme ébáŋné bad bé debyɛ́ɛ́ ne bad bé nsôŋtɛn. ");
INSERT INTO bssNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ɛɛ, A-Tɛ̂, nɛ̂ děn dɔ́ɔ édə́ə́ wɛɛ́ ébɛnled.” ");
INSERT INTO bssNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Dɔ́ɔ ábádɛɛ́ aá, “Echem Sáŋ ebagé mekan mésyə̄ə̄l áwem mekáá. Mod ké nhɔ́g eékoŋtɛɛ́ mwǎn abíi ésebɛ́ Dyǒb Titɛ́ɛ. Mod ké nhɔ́g-kɛ ámpē eebíiʼɛ́ ngáne Titɛ́ɛ ákóŋté abɛ́ ésebɛ́ mwǎn, ne kénzɛ́ɛ́ awě mwǎn ádə́ə́ aá mɔ́lúmed mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Nyéhyag áwêm, nyé bad bésyə̄ə̄l ábe nyékɔ́mé nted ḿme ńdélé apém, mɛ̌bɛ nyé nkɔ́me-áte. ");
INSERT INTO bssNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nyékwɛntɛn âhíd ḿmêm mekuu, nyéyə́gke-ʼɛ awêm, áyə̄le mpwiítédé, nchií-ʼɛ nlém á abum. Nyéhyag, nyɛ́ɛ̄kud nkɔ́me-áte. ");
INSERT INTO bssNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Áyə̄le ayə́ged ádêm déelɛlɛɛ́ áte, nted ḿmêm-mɛ méedelɛɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mwǎmpīn ḿ póndé ámbīd e nɛ̂, Yesuɛ ne ábē bembapɛɛ bétóméʼáá á nzag é ngun-tê. Nɛ́n ábédé á mbwɛ-mé-nkɔ́me-áte. Nzaa ewagáá ábē bembapɛɛ. Né-ɔɔ́ bêmbootéd eʼsɔ́g éʼ ngun apád, bépə̄keʼ, bédyâg. ");
INSERT INTO bssNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Befarisia bényīn nɛ̂, dɔ́ɔ béláŋgɛɛ́ Yesuɛ bán, “Nɔnéʼ, ábōŋ bembapɛɛ bébɛle dyam áde mbéndé éebagɛɛ́ kunze abɛl á mbwɛ-mé-nkɔ́me-áte.” ");
INSERT INTO bssNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Dɔ́ɔ Yesuɛ átimtanné bɔ́ aá, “Nɛ́dē nyéēlááʼɛ́ mbêd á kálag e Dyǒb dyam áde kə̂ŋ Dabidɛ âmbɛnlé áde nzaa ékóbé mɔ́ ne ábē bad-ɛ? ");
INSERT INTO bssNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Éténlédé nɛ́n bán, ansɔ́l á Ndáb-e-Dyǒb mɔ́ ne bad ábe bénwoón mɔ́, bédyɛ́ eʼwɛle ábe éʼbédé ndɛ e Dyǒb, ábe echɛd mbéndé eébagɛɛ́ mod ké nhɔ́g kunze âdyɛ́. Ké bad ábe bénwoón mɔ́ bénkêntə́ŋgɛ́nné adyɛ́. Beprisɛ běnpɛn bɔ́ɔ béntə̄ŋgɛ̄n adyɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Káa nyéēlááʼɛ́ á mbéndé eche Mosɛɛ nɛ́n bán, mbwɛ-mé-nkɔ́me-áte tɛ́ɛ́, beprisɛ bé Ndáb-e-Dyǒb békwag mbéndé e mbwɛ-mé-nkɔ́me-áte áyə̄le nsɔ́n ḿme bébɛlɛɛ́ boŋ ké nɛ̂, nɛ̂ déesaá mbéb áʼsō éʼ Dyǒb-ɛ? ");
INSERT INTO bssNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nlâŋge nyé nɛ́n mɛɛ́ dyam ádé hɛ́n bɔɔb áde ádé etógnɛ́n tómaa Ndáb-e-Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Éténlédé ngáne Dyǒb áhɔ́bé aá ‘Chǒm éche ńhɛdnɛɛ́ bad édíi nlém ń ngɔl saké abɛ dé mendɛ.’ Nzé nyênkoŋ ábɛ́n eʼyale asôŋtɛn né nyéēhɛ̄lɛ̄ɛ̄-sɛ nyéchəgé bad bán, bédé bebɛl bé mbéb áde béebɛlɛɛ́ mbéb. ");
INSERT INTO bssNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nyébíi-ɔɔ́ nɛ́n bán Mwǎn-a-Moonyoŋ awóó nkamlɛn kə́ə́ŋne ámīn e mbwɛ-mé-nkɔ́me-áte.” ");
INSERT INTO bssNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ámbīd e póndé, Yesuɛ anhidé hɛ̂, ákɛ asɔ́l á ndáb e mekáne. ");
INSERT INTO bssNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mod abédé áhed awě ekáá éwédé. Bad behɔ́g ábe béhɛ́déʼáá Yesuɛ awusé akóbɛn, bênsɛdéd mɔ́ bánken, “Echɛd mbéndé ebagé kunze âdid mod bwâm á mbwɛ-mé-nkɔ́me-áte-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Dɔ́ɔ ásɛdtɛɛ́ bɔ́ aáken, “Nyé ahéé ḿmē mpɔm ḿ mbód mɛ́hūnnē á echóg-te á mbwɛ-mé-nkɔ́me-áte boŋ eékag mɔ́ ahúd? ");
INSERT INTO bssNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nzé nyêhɛle-sɛ nyébɛl nɛ̂ ne mbód ngɛ̂n, tɔ́gtɛ́nnē moonyoŋ awě adé etógnɛ́n tómaa mbód. Né-ɔɔ́, mbéndé eésaá nɛ́n bán mod eébɛ̄lē bwâm á mbwɛ-mé-nkɔ́me-áte.” ");
INSERT INTO bssNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Dɔ́ɔ álâŋgɛɛ́ ane mod awě ekáá énwɛ̄ɛ̄ aá, “Sálé ekáá áte.” Asále áde ane mod ásánlé ekáá áte, ekáá êndyɛɛ́ mɔ́ bwâm ámpē nɛ́ɛ échíníí. ");
INSERT INTO bssNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Áde nɛ́n ábɛ́nlédé, Befarisia bémbīd á ndáb e mekáne, bébootéd Yesuɛ ahəge, âwúu mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesuɛ ambíí aá béhəgke mɔ́. Nɛ̂ dêmbɛ̌l anhidé ádê abwɔ́g á hǒm. Áde áhídté, ndun e mod enhíd mɔ́, anchoód-tɛ bad bé nkole bésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Boŋ ansím bɔ́ etúu áte aá béēlāŋgē bad nyaa e mod eche mɔ́díí. ");
INSERT INTO bssNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ambɛl nɛ́n âlóned eʼyale ábe Dyǒb dénlōmɛ̄nnē nkal éʼdəə́dəŋ Yesayaa aá, ");
INSERT INTO bssNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nyénɔneʼ, awêm mbəledɛ nɛ́n awě ḿpwɛ́dé, ndəə́ mɔ́ nwógne-ʼɛ mɔ́ menyiŋge. Mɛ̌lōm échêm edəə́dəŋ ébɛ̄ ne mɔ́. Ǎbīdēd mbakú echě etyéémé átîntê e bad ábe béesɛ̌ bad bé Israɛl. ");
INSERT INTO bssNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Éebɛlɛ́ɛ́ nswaŋ ne bad, éetɔgé-ʼaá. Béewóg-kaá mɔ́ ehɔ́b á dyad-tê. ");
INSERT INTO bssNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Éekɔ́gédté ngɛn echě enɔ̌gké, éedíméd-taá etrúkáŋ éche éhɛde adím. Ǎbɛl nɛ́n kə́ə́ŋ né mbɛltéd ḿ bwâm múmɔ́ ńtédé etə́l. ");
INSERT INTO bssNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Á dǐn ádē dɔ́ɔ bad ábe béesɛ̌ bad bé Israɛl bɛ́summé nlém.” ");
INSERT INTO bssNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Dɔ́ɔ bépɛ́ɛ́né mod wɛ́ɛ Yesuɛ, awě ankwɛ̌ ndím, ákwɛ̄-ʼɛ ebóbé áyə̄le edəə́dəŋ é mbéb émbɛ̄ mɔ́ áte. Yesuɛ anchoód mɔ́. Ambootéd anyínɛn, áhɔ̄bē-ʼɛ akan. ");
INSERT INTO bssNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Áde bad bésyə̄ə̄l bényíné nɛ̂, yə̌l enkɔ́m bɔ́ áte bwâmbwam. Běn ne běn bêmbootéd ahɔ́b nɛ́n bán, “Éhɛle-sɛ ébɛ́ né anɛ́n mod adíi mwǎn a mbyaa ḿme Dabidɛ awě bésinɛɛ́-yōō?” ");
INSERT INTO bssNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Boŋ áde Befarisia béwógé nɛ̂, bénhɔ̄b bán, “Saá ngíne eche Bɛlzɛbulɛ awě akamlan eʼdəə́dəŋ bé mbéb chɔ́ɔ ábɛnlaadté âbíded bad eʼdəə́dəŋ bé mbéb áte-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesuɛ ambíí ḿmāb mewêmtɛn, né-ɔɔ́, anláá bɔ́ aá, “Aloŋ ké ahéé áde ákábné áte, boŋ nchemtɛn méesɛ̌, dɛ́bēb. Dyad ké áhéé-ʼɛ, kéʼɛ abum á ndáb áde ákábné áte, boŋ nchemtɛn-nɛ méesɛ̌, déētyēēmɛ̄ɛ̄. ");
INSERT INTO bssNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Né-ɔɔ́, nzé Satanɛ awanne Satanɛ, né awanne eche yə̌l. Chán-nɔ̄ ḿmē nkamlɛn mɛ́hɛnlé atyéem? ");
INSERT INTO bssNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nzé ngíne eche Bɛlzɛbulɛ chɔ́ɔ ḿbɛnladté âbíded bad eʼdəə́dəŋ bé mbéb áte, né ngíne eche nzɛ́ɛ́-ʼɔ̄ ábɛ̄n bad ábe bébídte eʼdəə́dəŋ bé mbéb bébɛnladté? Běn bɔ́ɔ bɛ́kwid nyé nkáá. ");
INSERT INTO bssNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Boŋ ngáne édíí nɛ́n bán ngíne e Edəə́dəŋ é Dyǒb chɔ́ɔ ḿbɛnladté âbíded bad eʼdəə́dəŋ bé mbéb áte, nɛ̂ álûmte nɛ́n bán nkamlɛn ń Dyǒb ḿpédé átîntê echɛ̂n. ");
INSERT INTO bssNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Mod eéhɛ̄lɛ̄ɛ̄-sɛ asɔ́l á ndáb e mod a ngíne se ádūm ábē bwěm ésebán asébpé mɔ́ ahaŋ. Amaa-ʼáa mɔ́ ahaŋ boŋ atéd ábē bwěm éʼsyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Kénzɛ́ɛ́ awě éesɛ̌ ne mɛ, né atə̂ŋgan mɛ. Kénzɛ́ɛ́-ʼɛ awě eewóŋgán mɛ âlad, né apáa páán. ");
INSERT INTO bssNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Né-ɔɔ́, nlâŋge nyé mɛɛ́, Dyǒb dɛ́lagsɛ́n bad mbéb ké ńhéé ḿme bébɛ́lé ne nzyə́ŋ ké ehéé eche bésyə́ə́ Dyǒb. Boŋ kénzɛ́ɛ́ awě ahɔ́bé eʼbébtéd éʼ mekan tə̂ŋgɛne Edəə́dəŋ éche Ésáá éekudté alagsɛn. ");
INSERT INTO bssNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Dyǒb dɛ́lagsɛ́n kénzɛ́ɛ́ awě ahɔ́bé eyale é mbéb tə̂ŋgɛne Mwǎn-a-Moonyoŋ, boŋ déelagsɛ́nné kénzɛ́ɛ́ awě ahɔ́bé eyale é mbéb tə̂ŋgɛne Edəə́dəŋ éche Ésáá, ken bɔɔb kéʼɛ á póndé echě ehúɛʼ. ");
INSERT INTO bssNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nzé epum éʼ bwɛl ébóó, né bwɛl ábe éʼchyáá échê epum bɔ́mpē éʼbóó. Nzé epum é bwɛl ébébé, né bwɛl ábe éʼchyáá échê epum bɔ́mpē éʼbébé. Áyə̄le á epum dɔ́ɔ béchemɛɛ́ bwɛl. ");
INSERT INTO bssNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Píí e nyə̌ chɛ́n! Chán nyéhɛlɛɛ́-sɛ nyêhɔ́b mekan mé bwâm, áde nyé běn nyédíí mbéb? Mam ḿme ńlóné mod á nlém-tê, mɔ́-ʼaá mébíde mɔ́ á nsəl. ");
INSERT INTO bssNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mod a bwâm abɛle bwâm áyə̄le éʼbídé mɔ́ á nlém-tê wɛ́ɛ bwâm éʼkóŋnédé. Mod a mbéb-pɛ abɛle mbéb áyə̄le ḿbídé mɔ́ á nlém-tê wɛ́ɛ mbéb ńkóŋnédé. ");
INSERT INTO bssNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nlâŋge nyé nɛ́n mɛɛ́, á mbwɛ ḿme Dyǒb dɛ́kāādtē bad bé nkǒŋsé, mod tɛ́ɛ́ ǎbɛ̌ nzɔm echě enkə̌ŋ boŋ ahɔ́b ekúkú é eyale tɛ́ɛ́ échě ámbīdēdtē á nsəl. ");
INSERT INTO bssNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Né-ɔɔ́, kéchéé éche wénhɔ̄bpē chɔ́ɔ ékə̌ŋ boŋ ésūū nzɔm káa ékwɛ nkáá.” ");
INSERT INTO bssNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Dɔ́ɔ doŋge dé bemeléede bé mbéndé ne Befarisia bélâŋgɛɛ́ Yesuɛ nɛ́n bán “A-meléed, sêhɛde nɛ́n bán élúmed sé eʼchemléd ábe éʼlûmte nɛ́n bán echoŋ ngíne ehúú ne Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesuɛ antimtɛ́n bɔ́ aá, “Échɛ́n ebébtéd é nyoŋgɛl, nyéēhɛ̄dɛ̄ɛ̄ Dyǒb awógɛn, nyêhɛde-ʼɛ eʼchemléd bé menyáké! Boŋ nyéekudté nzése eʼchemléd bé menyáké ábe nkal éʼdəə́dəŋ Jonaa. ");
INSERT INTO bssNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonaa ambɛ́ eʼpun éʼláán á abum á súu e mbáá-tê. Melemlem dɔ́ɔ Mwǎn-a-Moonyoŋ ábɛ̄ɛ̄ á ndɔɔb-sɛ́ eʼpun éʼláán. ");
INSERT INTO bssNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Á mbwɛ mé nkáásé, bad bé Ninivɛ bɛ́nyemé á soŋ-tê nchoo ne enɛ́n nyoŋgɛl e bad. Bɛ́tyēēm mbóŋ echě ěkwīd enɛ́n nyoŋgɛl e bad nkáá, áyə̄le áde Jonaa ákánléʼáá bad bé Ninivɛ eyale é Dyǒb, bêntɛdé abɛl dé mbéb. Boŋ mod adé hɛ́n bɔɔb awě atómé Jonaa, boŋ nyéewóglánné mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Á mbwɛ mé nkáásé, mmwaád awě akamlánnáá aloŋ á Sɛba, ǎnyemé á soŋ-tê, nchoo ne nyoŋgɛl e bad béʼ chii, ǎtyēēm mbóŋ echě ěkwid bɔ́ nkáá. Bɛ́kwɛ̌ nkáá áyə̄le áde Solomonɛ áyə́gtéʼáá, ane mmwaád ambíd se nchabnede wɛ́ɛ nkǒŋsé ńsógé âhyɛ dé awóglɛn mam mé debyɛ́ɛ́ ḿme Solomonɛ áyə́gtéʼáá. Boŋ chii nɛ́n mod adé hɛ́n awě atómé Solomonɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yesuɛ ambád ahɔ́b aá, “Nzé edəə́dəŋ é mbéb ébídé mod áte, ébɛlé ébwāgē á ehyáŋge âhɛd abwɔ́g áde ékɔ̂mmɛɛ́ áte. Nzé éekude, ");
INSERT INTO bssNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ébɛlé éhɔ́b aá, ‘Mɛ̌tǐm ámbīd á ndáb eche mémbīdtē áte.’ Apɛ áde épagké ébɛlé étán nɛ́ɛ chǒmchǒm éesaá á ndáb-te, nɛ́ɛ ndáb ésáá áte ne nɛ́ɛ bénábpé-ʼɛ chɔ́ áte. ");
INSERT INTO bssNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Hɛ́ɛ ékagké bɔɔb, ékɛ épɛ̄ɛ̄n eʼdəə́dəŋ bé mbéb bémpēe saámbé ábe éʼdé ebébtéd tómaa mwěn, boŋ éʼhyɛ éʼsɔ́l ane mod áte, éʼbwóg-kɛ eʼdii áhed. Enɛ póndé, ane mod abâg ebébtéd tómaa ngáne ánsēbɛ̄ɛ̄ abɛ́. Né-ɔɔ́, nɛ̂ dɔ́ɔ ébɛnlédté ne nyoŋgɛl e ebébtéd eʼchii.” ");
INSERT INTO bssNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Áde Yesuɛ álâŋgɛɛ́ bad ḿmɛ́n mekan, nyaá ne Yesuɛ baányaŋ bêmpɛ̌ bétyéém á ebwɔ́g-te. Béhɛ́déʼáá Yesuɛ âbɛl boŋ bɔ́ɔ̄bɔ̄ɔ békal. ");
INSERT INTO bssNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Hɛ̂ dɔ́ɔ mod nhɔ́g álâŋgɛɛ́ Yesuɛ aá nyaá ne baányaŋ bépédé, bésine mɔ́ ebwɔ́g-te, âkalɛn mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Hɛ́ɛ átímtɛ́né ane mod aá, “Nzɛ́ɛ́ adé echěm nyaŋ, benzɛ́ɛ́-ʼɛ bédé bǎnned?” ");
INSERT INTO bssNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Hɛ̂ dɔ́ɔ Yesuɛ ányíitanné ábē bembapɛɛ ekáá boŋ áhɔ̄bē aá, “Echěm nyaŋ ne bǎnned bɔ́ɔ bɛ́n! ");
INSERT INTO bssNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kénzɛ́ɛ́ awě abɛle mam ḿme awêm Titɛ́ɛ awě adé ámīn áhɛdɛɛ́ adíi mwǎnned abɛ́-ʼɛ echěm nyaŋ.” ");
INSERT INTO bssNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ḿmê mbwɛ měn ámbīd e nɛ̂, Yesuɛ ambíd á ndáb-te wɛ́ɛ ámbɛ̄ɛ̄, ákɛ ádyɛ̄ɛ̄ ásē á nkin mé edib-é-nzab é Galilia, âyə́ged bad. ");
INSERT INTO bssNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bad ábe bêmpɛ̌ áhed béntōmtɛ̄n abuu áte. Nɛ̂ dênkə̌ŋ ansɔ́l á bɔ̌lɛ-tê, ádyɛ̄ɛ̄ ásē âyə́ged bɔ́. Ábê bad bésyə̄ə̄l bétyēēm á nkin béwōglān mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Abɛ̌nládtáá ngan âyə́ged bɔ́ mekan híin. Ankalé bɔ́ ngan aá, “Nkwɛl-é-nzag nhɔ́g ankɛ̌ mbə́l asob á nzag-tê. ");
INSERT INTO bssNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Áde ásobɛɛ́ mɔ́ nɛ̂, doŋge dénhūn á nzii-tê, menɔn mêmpɛ̌, mémad mɔ́ asɔ̂mted. ");
INSERT INTO bssNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Doŋge dénhūn á meláá-tê wɛ́ɛ ndɔɔb énkêmbuúʼɛ́ áte. Énwāmsɛ̄n abíd ásē ngáne ndɔɔb énkênchabpé ásē áhed. ");
INSERT INTO bssNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Boŋ nɛ́ɛ enyɛn é ngíne épédé, énhyāād ábê bwěm éʼwɛ́-ʼɛ, áyə̄le nkaŋ ménkênsɔ́nlé bɔ́ á ndɔɔb-tê bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mbə́l mémpēe ménhūn wɛ́ɛ mekɔ̂d médíí. Nɛ́ɛ mekɔ̂d mê mékwógé, mékáŋ akwog áde ábɛ̂ bwěm. ");
INSERT INTO bssNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Boŋ doŋge dé mbə́l démpēe dénhūn á ndɔɔb e bwâm. Ḿmɛ́n mbə́l mémbīd ásē bwâm, ńchyáá-ʼɛ bwâmbwam. Doŋge dé eʼsɔ́g dénwālē mbwɔ́kɛl é mbum, doŋge móom ntóób, ábíníí-ʼɛ móom méláán.” ");
INSERT INTO bssNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Áde Yesuɛ ámádé nɛ̂, ambád áte aá, “Kénzɛ́ɛ́ awě awóó metúu áwógeʼ.” ");
INSERT INTO bssNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ámbīd e nɛ̂, bembapɛɛ ábe Yesuɛ bêmpɛ̌ mɔ́ bɛnbɛn boŋ bésɛdté mɔ́ bánken, “Cheé ékə́ə́ boŋ ébɛnláád ngan âyə́ged bad?” ");
INSERT INTO bssNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesuɛ ankwɛntɛ́n bɔ́ aá, “Dyǒb ábágé nyé kunze âbíi kun é nkamlɛn ḿ mín, boŋ ene kunze eébagnedɛɛ́ ne bad bémpēe. ");
INSERT INTO bssNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kénzɛ́ɛ́ awě awóó nsôŋtɛn ń kun é nkamlɛn ḿ mín, Dyǒb dɛ́bād mɔ́ ḿmê nsôŋtɛn abɛ, âbɛl nɛ́n átômtɛn awóŋ. Boŋ kénzɛ́ɛ́ awě eewóo, Dyǒb dɛ́kobɛ́n mɔ́ ké mwǎ nsôŋtɛn awě áwóó. ");
INSERT INTO bssNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nzɔm echě ekəə́ boŋ ńkanlé bad ngan edíi áyə̄le bényíneʼ, boŋ béechemɛ́ɛ́, béwógeʼ, boŋ béēsōŋtānnē. ");
INSERT INTO bssNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nɛ́n álônte eʼyale ábe Dyǒb dénlōmɛ̄nnē nkal éʼdəə́dəŋ Yesayaa aá, ‘Nyɛ́ɛ̄wōg awóg-ne-awóg boŋ nyéesóŋtɛ́nné, nyɛ́ɛ̄nyīn, anyín ne anyín boŋ nyéechemmé. ");
INSERT INTO bssNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nhɔ́be nɛ́n áyə̄le ábɛ́n bad béehɛlɛ́ɛ́ dyam ayə́ge ámpē. Békɔ́lé metúu, béládé-ʼɛ mǐd. Béewógké, béenyín-naá dyamdyam. Nzé énkêmbɛ́ nɛ̂, né bɛ́nyīn, béchēm-ʼɛ. Né bɛ́wōgɛ̄n metúu, nlém ḿmāb-pɛ ńsôŋtɛn. Nzé bébɛ́lé-ʼɛ nɛ̂, né bɛ́timɛ́n mɛ, né mɛ̌choód-tɛ bɔ́.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Hɛ́ɛ Yesuɛ ábádɛɛ́ ábē bembapɛɛ aláa aá, “Nsimé ńdé ne nyé áyə̄le nyênyíneʼ mam ḿme nyényínɛɛ́, nyéwōgē-ʼɛ mam ḿme nyéwógɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, bekal-bé-eʼdəə́dəŋ ne bad bé Dyǒb híin bênwanɛ́n ânyín mekan ḿme nyényíné ne âwóg mekan ḿme nyéwógé boŋ bénkênyínné, bénkênwóg-kaá. ");
INSERT INTO bssNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Bɔɔb-pɔɔ́ nyésôŋtɛn ngáne enɛ́n ngan e nwén-é-mbə́l édíí. ");
INSERT INTO bssNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nzé mod awóge eyale tə̂ŋgɛne nkamlɛn ḿ mín, boŋ eesôŋtɛne chɔ́, Satanɛ abɛlé áhyɛ, ahúd mɔ́ chɔ́ á nlém-tê. Échɛ́n ndín é bad édíi nɛ̂ŋgáne mbə́l ḿme ńhúné á nzii-tê. ");
INSERT INTO bssNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mbə́l ḿme ménhūn á meláá-te ńlûmte bad ábe békobeʼ eyale é Dyǒb ne menyiŋge ábwɔ̄g-ábwɔ̄g áde béwógé chɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Boŋ échê eyale éēwēnnāādtē bɔ́ á nlém-tê. Bédúbpe chɔ́ á esóŋ é póndé boŋ nzé ndutul ne metake bépédé áyə̄le échê eyale, bédol yə̌l ámbīd. ");
INSERT INTO bssNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mbə́l ḿme ńhúné á mekɔ̂d-te ńlûmte bad ábe béwóge eyale é Dyǒb, boŋ kə́ə́ŋ ne á asóg, mpúlé mé nkǒŋsé ne adəŋ dé abud á bwěm awóŋ ákáŋ bɔ́ nlém áte. Nɛ̂ ábɛleʼ, béehɛlɛ́ɛ́ ahəŋlɛn âbɛl mam mé bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mbə́l ḿme mɔ́-ʼɛ méntān kəse e ndɔɔb ńlûmte bad ábe béwóge eyale é Dyǒb boŋ bésóŋtán-nɛ chɔ́. Ábɛ́n bad bébɛle kəse é mekan nɛ̂ŋgáne eʼsɔ́g éʼ ngun ábe éʼwánlé mesoŋgé mé mbum é ngun mbwɔ́kɛl móom ntóób, ne móom méláán.” ");
INSERT INTO bssNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesuɛ ankalé ene ndun e mod ngan empée aá, “Nkamlɛn ḿ mín ńdé nɛ̂ŋgáne mod awě awéné kunze é mbə́l áwē nzag-tê, ");
INSERT INTO bssNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","boŋ ámbīd e nɛ̂, nkuu nhɔ́g áde bad bémáá akún, mod a ekɔyí awě ane mod nhɔ́g, ankɛ̌ á nzag e ngun-tê wê, awén mbə́l mé mesisoŋ ");
INSERT INTO bssNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Áde ngun chê ébóótédé akwog, dɔ́ɔ bad bényíné bán mesisoŋ mɔ́mpē mékwogeʼ áwēd-te. ");
INSERT INTO bssNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Bembəledɛ ábe ane nwóó-nzag bêmpɛ̌ áwē, bésɛdté mɔ́ bánken, ‘A-Sáŋ, éesaá mbále bán, mbə́l ń ngun ḿ bwâm mɔ́ɔ wénwēnnē á nzag-tê-yɛ? Chán ébɛ́nlédé boŋ mesisoŋ mékwōg áwēd-te?’ ");
INSERT INTO bssNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Dɔ́ɔ ákwɛntanné bɔ́ aá, ‘Mod a ekɔyí awêm nhɔ́g mɔ́ awéné ḿmê mesisoŋ.’ Ábê bembəledɛ bênsɛdéd mɔ́ bánken, ‘Sékɛ séhub mesisoŋ mê ásē-yɛ?’ ");
INSERT INTO bssNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ankwɛntɛ́n bɔ́ ámpē aá, ‘Aáy. Nyéēhūbēʼ, áyə̄le nzé nyêhɔ́bé bán nyêhubeʼ, nyɛ́ɛ̄hubɛ́n bɔ́ɔbɛ ngun. ");
INSERT INTO bssNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nyémwɛ ngun bɔ́ɔbɛ mesisoŋ békwogeʼ kə́ə́ŋ ne áde póndé épɛɛ́ eche bépādtē chɔ́. Ene póndé dɔ́ɔ mɛ́lāāʼɛ́ bepád mɛɛ́, bésébe béhûd mesisoŋ, bélad mɔ́ áte boŋ béhyáád mɔ́. Ámbīd e nɛ̂, dɔ́ɔ bépādtē ngun, bébānē chɔ́ áwêm etág-te.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesuɛ ankalé ene ndun e mod ngan empée aá, “Nkamlɛn ḿ mín ńdé nɛ̂ŋgáne mbə́l-e-bǔ echě mod átédé boŋ awén áwē nzag-tê. ");
INSERT INTO bssNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mbə́l-e-bǔ edé mwǎmpīn bwâmbwam nzé béhə́gtɛ́né chɔ́ ne mbə́l mémpēe. Boŋ nzé ekwogé, ekəleʼ tómaa mɛl mésad mésyə̄ə̄l. Menɔn méhyag-kɛ mǔm alóŋ á ngɛn-tê.” ");
INSERT INTO bssNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesuɛ ambɛ́ ákālē bɔ́ ngan empée aá, “Nkamlɛn ḿ mín ńdé nɛ̂ŋgáne esultɛn éche mmwaád ámúúnédé asii á pân é mbumé ń ngun éláán kə́ə́ŋ ésule.” ");
INSERT INTO bssNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesuɛ abɛ̌nládtáá ngan âyə́ged bad. Eeyə́gteʼaá dyamdyam ésebán abɛ̌nlédé ngan. ");
INSERT INTO bssNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ambɛl nɛ́n âlóned eʼyale ábe nkal eʼdəə́dəŋ ánhɔ̄bpē nɛ́n aá, “Mɛ̌bɛnléd ngan nzé nhɔ́be wɛ́ɛ bad. Mɛ̌yə̄gēd bɔ́ mam ḿme bénkêmbííʼɛ́ bootya á mbooted mé nkǒŋsé.” ");
INSERT INTO bssNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesuɛ antɛdé ene ndun e mod, ákɛ asɔ́l á ndáb-te. Áhed dɔ́ɔ ábē bembapɛɛ bétáné mɔ́, boŋ bélāŋgē mɔ́ bán, “Tógnéd sé ngan e mesisoŋ.” ");
INSERT INTO bssNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesuɛ antimtɛ́n bɔ́ aá, “Mod awě anwén ḿmê mbə́l ḿ bwâm adíi Mwǎn-a-Moonyoŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nzag edíi nkǒŋsé. Mbə́l ḿ bwâm ńdíi bad ábe bédé ásē e nkamlɛn ń Dyǒb. Mesisoŋ médíi bad ábe Satanɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mod a ekɔyí awě ane nwóó-nzag-kɛ, awě anwén mesisoŋ áwē nzag-tê mɔ́ adé Satanɛ. Póndé eche bépádɛɛ́ ngun chɔ́ edé asóg dé nkǒŋsé. Bepád bé ngun-nɛ bédíi ángɛl. ");
INSERT INTO bssNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ngáne béladɛɛ́ mesisoŋ áte boŋ béhyáád mɔ́, melemlem nɛ̂ dɔ́ɔ ébɛ̄ɛ̄ ne bad ábe Satanɛ, nzé nkǒŋsé ḿpédé á asóg. ");
INSERT INTO bssNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwǎn-a-Moonyoŋ ǎlōm éche ángɛl âhúd bad ábe bébɛlte bad bémpēe mbéb, ne bad bésyə̄ə̄l ábe bébɛle mbéb. ");
INSERT INTO bssNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Bɛ́bwēm bɔ́ á dǔ-á-muú, áhed-taá béchyɛɛ́ʼɛ́, bédyāg-kɛ mesoŋ á nsəl. ");
INSERT INTO bssNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ene póndé bad ábe bêmbɛ̌l-lɛ ngáne Dyǒb áhɛdɛɛ́, bɛ́pɛnéʼ nɛ́ɛ enyɛn á nkamlɛn wɛ́ɛ echab Sáŋ. Mod ké ahéé awě awóó metúu, áwógeʼ.” ");
INSERT INTO bssNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesuɛ ambád ngan empée aá, “Nkamlɛn ḿ mín ńdé nɛ̂ŋgáne nhɔn ḿme mênkoŋnéd á nzag-tê, boŋ nɛ́ɛ mod nhɔ́g ádíbté mɔ́, akútɛ́n mɔ́. Menyiŋge ḿme ámbɛ̄ɛ̄ mênkə̌ŋ ankɛ bwěm éʼsyə̄ə̄l ábe ánwōŋgē asóm, âbɛl nɛ́n ákɛ áchan ene nzag. ");
INSERT INTO bssNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Nkamlɛn ḿ mín ńdé nhəgtɛ́n ámpē nɛ̂ŋgáne mod a nyoŋgé awě ahɛdéʼáá meláá mé etógnɛ́n ḿme ńdé nkun bwâmbwam ḿme áchanɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Anyín áde ányíné aláá áde átómtɛ́né aboŋ bwâmbwam, áde bésómɛɛ́, ankɛ̌ ábē bwěm éʼsyə̄ə̄l asóm, áchān-nɛ dɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesuɛ ankǎl ngan empée aá, “Nkamlɛn ḿ mín ńdé nɛ̂ŋgáne mbínzé eche bekób-bé-súu bébwémé á edíb-te boŋ békób nyaa é súu ésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Áde mbínzé émáá alón, bêndǒl chɔ́ á nkin, bédyɛ̄ɛ̄ ásē âbɔn súu áte. Éche êmboŋ adyɛ́ bénhɛ̄ chɔ́ á meloŋgé-te. Éche chɔ́-ʼɛ énkêmboŋ adyɛ́, bêmpǐm. ");
INSERT INTO bssNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Né-ɔɔ́ enɛ́n ngan elûmte ngáne asóg dé nkǒŋsé dɛ́bɛ̄ɛ̄. Dyǒb dɛ́lōm éche ángɛl âhúd bad bé mbéb átîntê e bad ábe bésáá. ");
INSERT INTO bssNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Bɛ́bwēm ábê bad á dǔ-á-muú. Áhed-taá béchyɛɛ́ʼɛ́ bédyāg-kɛ mesoŋ á nsəl.” ");
INSERT INTO bssNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesuɛ ansɛdéd ábē bembapɛɛ ké bésóŋtɛ́né ḿmɛ́n mam. Bênkwɛntɛ́n mɔ́ bán bésóŋtɛ́né. ");
INSERT INTO bssNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Né-ɔɔ́ Yesuɛ anláá bɔ́ aá, “Meléede a mbéndé ké ahéé awě ayə́gké tə̂ŋgɛne nkamlɛn ḿ mín adíi nɛ̂ŋgáne nwóó-ndáb awě abídte bwěm bé ekɔ́ɔ́lé ne bé nchun wɛ́ɛ ákoŋgɛɛ́ bwěm.” ");
INSERT INTO bssNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Áde Yesuɛ ámáá ayə́ged ne ngan, anhidé ádê abwɔ́g á hǒm, ");
INSERT INTO bssNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","asú ámbīd áwe dyad wɛ́ɛ ámbīdtē. Áwed ayə́gtéʼáá bad á ndáb e mekáne. Bad ábe bénwōg ngáne áyə́gtɛɛ́, yə̌l enkɔ́m bɔ́ áte bwâmbwam. Bésɛdté bánken, “Héé múmɔ́ ákúdé enɛ́n ndín e debyɛ́ɛ́? Chán múmɔ́ ámwagké-ʼɛ ḿmɛ́n menyáké mésyə̄ə̄l abɛl? ");
INSERT INTO bssNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kíné saá mwǎn a kápɛ́ntaa ádíí-yɛ? Saá Maria achyáá mɔ́-yɛ? Kíné saá Jemsɛ, Josɛbɛ, Simɔnɛ ne Judasɛ bɔ́ɔ bédé baányaŋ-ɛ? ");
INSERT INTO bssNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Baányaŋ bé bebaád bésyə̄ə̄l-lɛ ámpē béedyɛɛ́ʼɛ́ á dyad-tê hɛ́n ne syánē-yɛ? Héé ákúdé enɛ́n ndín e debyɛ́ɛ́? Héé ákúdé enɛ́n nyaa e ngíne échě ábɛnlɛɛ́ ḿmê menyáké?” ");
INSERT INTO bssNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Né-ɔɔ́, bênkɔɔ́ Yesuɛ. Anláá bɔ́ aá, “Nkal eʼdəə́dəŋ awóoʼ edúbé hǒm ásyə̄ə̄l étómɛɛ́ áwē dyad ne áwe túmbé.” ");
INSERT INTO bssNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ngáne bénkêndúbɛ́ɛ́ Yesuɛ, enkêmbɛnlé menyáké híin áhed. ");
INSERT INTO bssNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ene póndé Hɛrɔdɛ awě akamlánnáá aloŋ á Galilia anwóg mam ḿme Yesuɛ ábɛ́léʼáá. ");
INSERT INTO bssNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Dɔ́ɔ álâŋgɛɛ́ ábē bembəledɛ aá, “Anɛ́n mod, Yesuɛ, adíi Jɔnɛ, Ndusɛnɛ awě ammad awɛ́ boŋ apuúdé. Nɛ́ɛ ákə́ə́ boŋ awóŋ ngíne âbɛl ḿmɛ́n menyáké mésyə̄ə̄l.” ");
INSERT INTO bssNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Hɛrɔdɛ anhɔ́b nɛ̂ áyə̄le anlóm bad aá békôb Jɔnɛ, béhaŋ mɔ́, béhɛ́-ʼɛ mɔ́ á mbwɔg. Ambɛl nɛ́n áyə̄le mwaád, Hɛrodyasɛ, awě mwǎnyaŋ Filibɛ ánsēbɛ̄ɛ̄ awóŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Hɛrɔdɛ anhɛ́ Jɔnɛ, Ndusɛnɛ á mbwɔg áyə̄le Jɔnɛ anláá mɔ́ nɛ́n aá, “Weewóoʼɛ́ kunze âwóŋ Hɛrodyasɛ, mmwaád awě mwǎnyoŋ.” ");
INSERT INTO bssNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kénɛ́ɛ Hɛrɔdɛ áhɛ́déʼáá Jɔnɛ, Ndusɛnɛ awúu, abédé mbwɔ́g ne bad bé Israɛl. Bad bé Israɛl béndūbē bán Jɔnɛ adíi nkal éʼdəə́dəŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Boŋ Hɛrɔdɛ antǐm Jɔnɛ awúu. Nɛ́n dêmbɛnléd epun-ɛ́ɛ Hɛrɔdɛ ábɛ́léʼáá ngande âwêmtɛn epun-ɛ́ɛ áchyāādtē. Échê epun mwǎn-a-mmwaád awě Hɛrodyasɛ anság esáke áʼsō éʼ bad bésyə̄ə̄l. Nɛ́n dénwōgēd Hɛrɔdɛ menyiŋge bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nɛ́n dêmbɛ̌l ambɛ mɔ́ akag. Anhɔ́b nɛ́n aá, “Mmwâg melɛ̌ nɛ́n, mɛ̌bɛ̌ wɛ kéchéé éche éhɛdɛɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nyaá anláá mɔ́ chǒm éche átə́ŋgɛ́né sáá ahɛdɛn. Né-ɔɔ́ anláá Hɛrɔdɛ aá, “Bǎg mɛ nló ḿme Jɔnɛ, Ndusɛnɛ á taplêt-te hɛ́n bɔɔb.” ");
INSERT INTO bssNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nɛ́n dénwōgēd kə̂ŋ Hɛrɔdɛ ndutul boŋ ngáne âmmadté melɛ̌ amwɛ́ áʼsō wɛ́ɛ ábē beken, ambɛɛ́ kunze aá béhyɛne nló ḿme Jɔnɛ âbɛ ane mwǎn-a-mmwaád. ");
INSERT INTO bssNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Né-ɔɔ́ anlóm bad á ndáb e mbwɔg âsɛ́l Jɔnɛ nló. ");
INSERT INTO bssNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bêmpɛɛ́n nló ḿmed á taplêt-te, bébɛ̄ ane mwǎn-a-mmwaád, mɔ́-ʼɛ ábɛ nyaa. ");
INSERT INTO bssNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ámbīd e nɛ̂ bembapɛɛ ábe Jɔnɛ bênkɛ̌ á ndáb e mbwɔg bétéd mɔ́ ndim békɛ bélíme, boŋ békɛ bélāŋgē Yesuɛ dyam áde ábɛ́nlédé. ");
INSERT INTO bssNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Áde Yesuɛ áwógé dyam áde ábɛ́nlédé ne Jɔnɛ, ansɔ́l á bɔ̌lɛ-tê âkɛ á abwɔ́g á hǒm wɛ́ɛ ábédé mwěmpɛn. Boŋ áde bad béwógé bán Yesuɛ amaá akɛ á bɔ̌lɛ-tê, bênchené ḿmāb myad békɛ̄ɛ̄n mekuu âhíd mɔ́ ámbīd. ");
INSERT INTO bssNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Áde Yesuɛ ábídé á bɔ̌lɛ-tê, boŋ anyín ndun e mod, antómtɛ́n bɔ́ ngɔl abɛ́, ámād-tɛ bɔ́ nkole. ");
INSERT INTO bssNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Áde bǐn éʼbóótédé ahín, ábē bembapɛɛ bêmpɛ̌ áwē, béhɔ̄bē nɛ́n bán, “Hɛ́n ádé á etûn-tê, póndé emaá-ʼɛ atóm bwâmbwam. Láá ábɛ́n bad bétimeʼ á myad-tê ḿme médé bɛnbɛn, âbɛl béchan ndyééd eche bɛ́dyɛ̄ɛ̄.” ");
INSERT INTO bssNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Dɔ́ɔ Yesuɛ átimtanné bɔ́ aá, “Béētə̂ŋgenɛɛ́ akɛ. Nyébɔ́ nyébɛ bɔ́ chǒm éche bédyɛ̄ɛ̄.” ");
INSERT INTO bssNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Dɔ́ɔ béhɔ́bɛɛ́ bán, “Sêwóó eʼwɛle éʼtáan ne súu ébɛ chěmpɛn.” ");
INSERT INTO bssNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesuɛ aá, “Nyéhyɛɛneʼ.” ");
INSERT INTO bssNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Áde ábē bembapɛɛ bépɛ́ɛ́nédé mɔ́ chɔ́, anláá ene ndun e mod aá bédyɛɛ ásē á nkəə́kəə mîn. Hɛ̂ dɔ́ɔ Yesuɛ awánlé ábɛ̂ eʼwɛle éʼtáan ne échê súu ébɛ á mekáá boŋ ánɔné ámīn ásāgnān Dyǒb. Ankabtéd bɔ́ áte, boŋ ábagé ábē bembapɛɛ aá békabe ene ndun e mod. ");
INSERT INTO bssNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bad bésyə̄ə̄l béndyɛ̄ ene ndyééd békód, élyə̄g-kɛ ásē. Nɛ́ɛ béládé echě elyəgé ásē, enlón eʼlóŋ dyôm ne éʼbɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mesoŋgé mé bad ḿme méndyɛ̄ ene ndyééd mémbɛ̄ ké eʼkə́lé éʼtáan. Ḿmê mesoŋgé mé bad mébédé-ɛ baachóm. Bénkêntóŋgé bebaád ne běndem. ");
INSERT INTO bssNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ámbīd e nɛ̂, Yesuɛ anláá ábē bembapɛɛ aá, bésɔ̂l á bɔ̌lɛ-tê, békag áʼsō á múde mé edib-é-nzab ḿmíníí, boŋ álāŋgē-ʼɛ ene ndun e mod aá bésūɛ̄ʼ áwab mendáb. ");
INSERT INTO bssNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Áde moosyəə́l ámáá akɛ, Yesuɛ anchə́gé á ekone mîn âkáne. Áde ehíntɛ́n émáá akwɛ, ambɛ́ abɛ́ áhed mwěmpɛn. ");
INSERT INTO bssNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Enɛ́n póndé Yesuɛ ábē bembapɛɛ bênchab bɔ̌lɛ abɛ́ɛn átîntê e edib-é-nzab. Bɔ̌lɛ étágéʼáá, béehɛleʼaá akɛ áʼsō áyə̄le epub é ngíne émbīd bɔ́ áʼsō-te. ");
INSERT INTO bssNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Epɔg é mbwɛmbwɛ Yesuɛ ankɛ̌ á mendíb mîn atán bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Áde bembapɛɛ bényíné mod akag á mendíb mîn, bênəŋnéd, bélébé-ʼɛ esaád ne mbwɔ́g ń ngíne, béhɔ̄bē-ʼɛ nɛ́n bán, “Nwú mɔ́ɔ ńdé.” ");
INSERT INTO bssNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ábwɔ̄g-ábwɔ̄g Yesuɛ anláá bɔ́ aá, “Nlém méēhūnē nyé, mɛ-ɛɛ́ ndé. Nyéebááʼ.” ");
INSERT INTO bssNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Dɔ́ɔ Petro áláŋgɛɛ́ mɔ́ aá, “A-Sáŋ, nzé édé bán mmǒn-ɛɛ́ edé, láá mɛ ńkɛ á mendíb mîn ḿpɛ wɛ́ɛ édíí nɛ̂.” ");
INSERT INTO bssNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesuɛ anláá mɔ́ aá, “Hyǎg.” Dɔ́ɔ Petro ábídé á bɔ̌lɛ-tê ábootéd-tɛ akɛ á mendíb-mîn âpɛ wɛ́ɛ Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Boŋ áde ányíné ngáne epub é ngíne étómɛɛ́, mbwɔ́g ménkōb mɔ́, ábootéd-tɛ asú ásē á mendíb-te. Dɔ́ɔ álébpé esaád aá, “A-Sáŋ sôn, wóŋgɛ́n mɛ!” ");
INSERT INTO bssNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Melemlem mé póndé Yesuɛ ansǎd ekáá, achə́ə́-ʼɛ mɔ́, áhɔ̄bē aá, “Chán adúbe ádíí wɛ mwǎmpīn nɛ́n, cheé ékə́ə́ boŋ nlém ńhūnē wɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nɛ́ɛ Yesuɛ bɔ́ Petro bésɔ́lé á bɔ̌lɛ-tê, epub énsōg atóm. ");
INSERT INTO bssNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Áde nɛ́n ábɛ́nlédé, ábíníí bembapɛɛ ábe bémbɛ̄ á bɔ̌lɛ-tê bêmbɛɛ́ Yesuɛ edúbé, béhɔ̄bē-ʼɛ nɛ́n bán, “Ne mbále, edíi Mwǎn a Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nɛ́ɛ béchábpé edib-é-nzab, bêmpɛ̌ á múde ḿmíníí, á mbwɔ́g e Gɛnesarɛt. ");
INSERT INTO bssNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Áde bad ábe bémbɛ̄ ádê abwɔ́g á hǒm béchémé Yesuɛ, bénlōm bad bán bépɛɛn bad bé nkole bésyə̄ə̄l ábe bébédé ene pɛd e aloŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bad ábe bêmpɛɛ́n bad bé nkole wɛ́ɛ Yesuɛ béchāŋ mɔ́ bán ámwɛ bad bé nkole bésitɛn ké mesó mé mbɔ́té ḿmē. Né-ɔɔ́ bad bé nkole bésyə̄ə̄l ábe bênsitɛ́n ḿme mesó mé mbɔ́té béndyɛɛ́ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ámbīd e nɛ̂ Befarisia ne bemeléede bé mbéndé bémbīd á Jerusalɛm, bétān Yesuɛ, bésɛdté mɔ́ bánken, ");
INSERT INTO bssNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Cheé ékə́ə́ boŋ ábōŋ bembapɛɛ béēhīdēʼ ayə́ge áde ábɛ̄d betaa bétɛ́dnédé sé? Béewobpɛ́ɛ́ mekáá nyaa echě éhɛdnɛɛ́ boŋ bɛ́dyɛ̄ ndyééd.” ");
INSERT INTO bssNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesuɛ ankwɛntɛ́n bɔ́ aá, “Cheé ekə́ə́ boŋ nyémpē nyéehídéʼ ngáne mbéndé e Dyǒb éhɔ́bɛɛ́ aá débɛl, á etútú éche nyéhídɛɛ́ ayə́ge ádɛ̄n děn? ");
INSERT INTO bssNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dyǒb áhɔ́bé aá, ‘Bɛɛ́ sóó ne nyoŋ edúbé.’ Ahɔ́b-pɛ ámpē aá, ‘Kénzɛ́ɛ́ awě ahɔ́bé sáá kéʼɛ nyaá dyam dé mbéb áyə̄l bétə́ŋgɛ́né béwúú mɔ́.’ ");
INSERT INTO bssNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Boŋ nyé, nyêyə́gte nɛ́n bán, nzé mod awóó chǒm éche ántə̄ŋgɛ̄nē sáá kéʼɛ nyaá awôŋgɛn boŋ aláŋgé bɔ́ aá mɔ́ɔ̄bɛ Dyǒb chɔ́, ");
INSERT INTO bssNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","né éesaá nɛ́n bán atə́ŋgɛ́né sáá bɔ́ nyaŋ chɔ́ edúbé abɛɛn. Abɛl áde mod ábɛ́lé nɛ̂, né nyéetédɛɛ́ eyale é Dyǒb nɛ́ɛ dyam á etútú éche nyéhídɛɛ́ ayə́ge ádɛ̄n. ");
INSERT INTO bssNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nyé bedog-badɛ́! Nkal éʼdəə́dəŋ Yesayaa antə́ŋgɛ́n áde ánhɔ̄bpē ne eʼyale ábe Dyǒb dénlōmɛ̄nnē mɔ́ tə̂ŋgɛne nyé aá, ");
INSERT INTO bssNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ábɛ̄n bad bébage mɛ edúbé é nsəl ngɛ̂n, boŋ ḿmab nlém méesaá áwêm. ");
INSERT INTO bssNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Edúbé éche bébagɛɛ́ mɛ éesaá dyamdyam, áyə̄le béyə́gte bad âhíd mbéndé é baányoŋ byánán édíi mbéndé é Dyǒb.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Hɛ́ɛ Yesuɛ áchɛ̂nlɛɛ́ ene ndun e mod boŋ álāŋgē bɔ́ aá, “Nyéwóglɛn, nyésôŋtɛn-nɛ mɛ! ");
INSERT INTO bssNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Saké chǒm éche ékag mod á nsəl ébɛle boŋ mod eesááʼ áʼsō éʼ Dyǒb, boŋ chǒm éche ébíde mɔ́ á nsəl chɔ́ɔ ébɛleʼ boŋ eesáá.” ");
INSERT INTO bssNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Áde áhɔ́bé nɛ̂, dɔ́ɔ ábē bembapɛɛ bépédé mɔ́ bɛnbɛn boŋ bésɛdté mɔ́ bánken, “Ebíí nɛ́n wɛɛ́ dyam áde mɔ́hɔ́bé ábébté Befarisia nlém á abum-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesuɛ ankwɛntɛ́n bɔ́ aá, “Bwɛl tɛ́ɛ́ ábe awêm Titɛ́ɛ awě adé ámīn éewénɛɛ́, bɛ́hǔb bɔ́ ásē.” ");
INSERT INTO bssNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nyéchene bɔ́. Bédíi bad bé ndím ábe bélûmte bad bé ndím bémpēe nzii. Nzé mod awě akwedé ndím atômne mod a ndím ampée, búmɔ̄ bɛ́hūn á echóg-te. ");
INSERT INTO bssNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petro anláá mɔ́ aá, “Tógnéd sé enɛ́n ngan.” ");
INSERT INTO bssNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Kə́ə́ŋ neʼ bɔɔb, ké nyémpē nyéēsóŋtɛ́nɛ́ɛ́-yɛ? ");
INSERT INTO bssNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nyéenyínɛ́ɛ́ nɛ́n bán, chǒm ké ehéé éche mod ádyédé, ésɔ́lɛɛ́ mɔ́ á nsəl, étim á abum-tê, boŋ ébídte mɔ́ á yə̌l-ɛ? ");
INSERT INTO bssNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Boŋ mam ḿme mod áhɔ́bɛɛ́ ḿbíde mɔ́ se á nlém-tê. Ḿmɛ́n mam mɔ́-ʼaá mébɛle mod boŋ eesááʼ áʼsō éʼ Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Áyə̄le á nlém-tê dɔ́ɔ mewêmtɛn mé mbéb méhúɛʼɛ́ ḿme mékəə boŋ ábɛlé mam mé mbéb nɛ̂ŋgáne, ewúɛn, akáb dé mesón á ndáb e eʼwóŋgé, echîb, abíd á mbóŋ é metóm, ne mehɔ́bɛn á mbíd. ");
INSERT INTO bssNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ḿmɛ́n mam mɔ́ɔ mébɛle boŋ mod eesááʼ áʼsō Dyǒb. Boŋ saké adyɛ́ á ndyééd áde éewobpɛɛ́ mekáá ngáne béhɛdɛɛ́, dɛ́bɛ̌l boŋ eesáá.” ");
INSERT INTO bssNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ámbīd e póndé, Yesuɛ anhidé ádê abwɔ́g á hǒm átīm á pɛd e mbwɔ́g echě enchiitɛ́n myad mé Tirɛ ne Sidɔn. ");
INSERT INTO bssNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Hɛ̂ dɔ́ɔ mmwaád a Kana nhɔ́g awě adyɛɛ́ʼáá ádê abwɔ́g á hǒm ápɛ́ɛ́né awé áwē boŋ áhɔ̄bē nɛ́n aá “A-Sáŋ, Mwǎn a mbyaa ḿme Dabidɛ, sôn wóg mɛ ngɔl! Awem mwǎn a mmwaád atage bwâmbwam, áyə̄le edəə́dəŋ é mbéb édé mɔ́ áte.” ");
INSERT INTO bssNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Boŋ Yesuɛ ekêntimtɛ́nné mɔ́ dyamdyam. Hɛ̂ dɔ́ɔ ábē bembapɛɛ bétánɛɛ́ mɔ́, boŋ béchāā mɔ́ nɛ́n bán “Láá anɛ́n mmwaád wɛɛ́ ákag áyə̄le ahídne syánē ntɔgag ámbīd.” ");
INSERT INTO bssNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Dɔ́ɔ Yesuɛ ákwɛntanné bɔ́ aá, “Bad bé Israɛl ábe bédé nɛ́ɛ ńdyɔŋ ḿ mbód ḿme ḿbɔ́ɔ́ bɔ́ɔ Dyǒb álómé mɛ awôŋgɛn.” ");
INSERT INTO bssNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nɛ́ɛ ane mmwaád áwógé nɛ̂, ankwɛ̌ Yesuɛ á mekuu, boŋ áchāā mɔ́ aá, “A-Sáŋ, wóŋgɛ́n mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Dɔ́ɔ Yesuɛ ákwɛntanné aá, “Éesaá bwâm âtéd ndyééd e bǎnbǎn boŋ ebwémé mbwɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Dɔ́ɔ ane mmwaád átimtanné mɔ́ aá, “Nɛ̂ děn A-Sáŋ, boŋ kə́ə́ŋne mbwɛ́ édyâg púuted é medyɛ́ éche ábab bésáá béhúnté.” ");
INSERT INTO bssNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Hɛ̂ dɔ́ɔ Yesuɛ ákwɛntanné mɔ́ aá, “A-mwǎn-a-mmwaád, ewóó adúbe ámbáá. Ébɛnled ngáne éhɛdɛɛ́.” Melemlem mé póndé, ane mmwaád awe mwǎn-a-mmwaád andyɛɛ́ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesuɛ anhidé ádê abwɔ́g á hǒm, ápōŋ á nkəg mé edib-é-nzab é Galilia. Ankɛ̌ adyɛɛ ásē á ekone mîn. ");
INSERT INTO bssNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ndun e mod empɛ̌ áwē. Bépɛ́ɛ́néʼáá bad ábe bésyə́gtéʼáá, ábe bênkwɛ̌ ndím, ábe mekuu ménwɛ̄ɛ̄, eʼbóbé ne ekud é bad bé nkole bémpēe. Bébánnéʼáá ábê bad bésyə̄ə̄l áʼsō wɛ́ɛ Yesuɛ, áchōōd-tɛ bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Menyáké ménkōb ene ndun e mod áde bényíné nɛ́ɛ bad ábe béēhɔ̄beʼaá akan nɛ́ɛ béhɔ́bɛɛ́ akan. Ábe mekuu ménwɛ̄ɛ̄ béntyēēm bwâm, ábe bésyə́gtéʼáá békag bwâm. Ábe bênkwɛ̌ ndím bényînneʼ. Békɛné Dyǒb á bad bé Israɛl. ");
INSERT INTO bssNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesuɛ anchɛ́lé ábē bembapɛɛ, álāŋgē bɔ́ nɛ́n aá, “Ndé enɛ́n ndun e mod ngɔl áyə̄le békébɛ̄ ne mɛ eʼpun éʼláán, béēwóo-ʼáa chǒm éche bédyákē bɔɔb. Meéhɛ̄dɛ̄ɛ̄ mɛɛ́ béhide hɛ́n ne nzaa, áyə̄le béhɛle sɛ béhún ásē á nzii.” ");
INSERT INTO bssNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Dɔ́ɔ ábē bembapɛɛ bɛ̂ bésɛdtɛɛ́ mɔ́ nɛ́n bán, “Héé syánē dɛ́kudté ndyééd á ehyáŋge-tê hɛ́n echě ěkwǒg enɛ́n ndun e mod?” ");
INSERT INTO bssNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesuɛ ansɛdéd bɔ́ aáken, “Eʼwɛle éʼtə́ŋ nyéwóó?” Bênkwɛntɛ́n bán, “Eʼwɛle saámbé ne nguse é súu ésad.” ");
INSERT INTO bssNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Dɔ́ɔ Yesuɛ áláŋgé ene ndun e mod aá bédyɛɛ ásē á ndɔɔb-tê. ");
INSERT INTO bssNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Hɛ́ɛ átédé ábɛ̂ eʼwɛle saámbé ne échê súu, ásāgnān Dyǒb, ákabtáád bɔ́ áte, ábagé ábē bembapɛɛ, bɔ́-ʼɛ békabpé ene ndun e mod. ");
INSERT INTO bssNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bad bésyə̄ə̄l béndyɛ̄ ene ndyééd, békód-tɛ, kə́ə́ŋ élyə̄g-kɛ ásē. Echě enlyə̌g ásē enlón eʼlóŋ saámbé. ");
INSERT INTO bssNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mesoŋgé mé bad ḿme méndyɛ̄ ene ndyééd mébédé eʼkə́lé éʼniin. Ḿmê mesoŋgé mé bad mébédɛ́ɛ baachóm, bénkêntóŋgé bebaád ne běndem. ");
INSERT INTO bssNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ ene ndun e mod aá bésūɛ̄ʼ áwab mendáb. Áde ámáá bɔ́ aláa nɛ̂, ansɔ́l á bɔ̌lɛ-tê, ákɛ á mbwɔ́g e Magadan. ");
INSERT INTO bssNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ámbīd e nɛ̂, Befarisia ne Besadusia bênkɛ̌ wɛ́ɛ Yesuɛ âkəg mɔ́. Bénlāā mɔ́ bán álúmed bɔ́ eʼchemléd ábe éʼhúú ádyōb. ");
INSERT INTO bssNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Nzé ngukɛ́l epedé, nyêhɔ́be bán, ‘Abobe áyəge ámīn, nɛ̂ álûmte bán bǐn bɛ́boŋ chǎn.’ ");
INSERT INTO bssNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nzé bǐn éʼsáŋgé-ʼɛ, nyêhɔ́be bán, ‘Abobe áyəge ámīn, bǐn-nɛ éʼwábpé, nɛ̂ álûmte bán mbúú ěchə̄.’ Nyêbíɛʼ bǐn aláŋ ámīn, ngáne bɛ́bɛ̄ɛ̄, boŋ nyéēhɛ̄lɛ̄ɛ̄ mam ḿme mébɛnlad chii achem. ");
INSERT INTO bssNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Échɛ́n ebébtéd é nyoŋgɛl, nyéēhɛ̄dɛ̄ɛ̄ Dyǒb awógɛn, nyêhɛde-ʼɛ eʼchemléd bé menyáké! Boŋ nyéekudté nzése eʼchemléd bé menyáké ábe nkal éʼdəə́dəŋ Jonaa běnpɛn.” Dɔ́ɔ átɛ́dté bɔ́, boŋ ákag. ");
INSERT INTO bssNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesuɛ ne ábē bembapɛɛ bênchabé edib é nzab ámīn, boŋ bembapɛɛ bênchatɛ́n eʼwɛle awále áyə̄l. ");
INSERT INTO bssNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesuɛ anláá bɔ́ aá, “Nyétêd póndé ne esultɛn éche Befarisia ne Besadusia.” ");
INSERT INTO bssNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Hɛ́ɛ ábē bembapɛɛ běn ne běn bébóótédé ahɔ́b bán, “Ahɔ́bé nɛ̂ áyə̄le syáā deewânlɛɛ́ eʼwɛle áyə̄l.” ");
INSERT INTO bssNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesuɛ ambíí chǒm-ɛ́ɛ békálé. Dɔ́ɔ ásɛdtɛɛ́ bɔ́ aáken, “Cheé nyé běn ne běn nyéhɔ́bɛɛ́ áyə̄le eʼwɛle ábe nyéēwōoʼɛ́? Chán adúbe ádíí nyé mwǎmpīn nɛ́n? ");
INSERT INTO bssNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kə́ə́ŋ neʼ bɔɔb, nyéesóŋtɛ́né-ɛ? Nyêmaá achatɛn ngáne méndīdɛ̄ɛ̄ eʼkə́lé eʼ bad éʼtáan ne eʼwɛle éʼtáan. Ámbīd echě bémáá ene ndyééd adyɛ́, eʼlóŋ éʼtə́ŋ echě enlyəg ásē énlōnnē? ");
INSERT INTO bssNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nyêchǎtɛ́né kə́ə́ŋ ne adíde áde méndīdɛ̄ɛ̄ eʼkə́lé éʼ bad éʼniin ne eʼwɛle saámbé. Ámbīd echě bɔ́mpē bémáá adyɛ́, echě enlyə̌g ásē chɔ́-ʼɛ enlón eʼlóŋ éʼtə́ŋ? ");
INSERT INTO bssNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Áde ńláŋgé nyé mɛɛ́ nyétédɛn esultɛn póndé, saké ewɛle chěn chɔ́ɔ ńhɔ́béʼáá. Nyétêd póndé ne esultɛn é Befarisia ne Besadusia.” ");
INSERT INTO bssNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Dɔ́ɔ bembapɛɛ bétímé asôŋtɛn bán saké esultɛn éche bébɛnlɛɛ́ ewɛle chɔ́ɔ Yesuɛ ahɔ́béʼáá aá bétédɛn póndé boŋ ayə́ged áde Befarisia ne Besadusia béyə́gtéʼáá dɔ́ɔ ákóŋtéʼáá ahɔ́b. ");
INSERT INTO bssNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesuɛ ankɛ̌ á mbwɔ́g e Kaisaria Filipi. Áde ápédé áwed, dɔ́ɔ ásɛdtɛɛ́ ábē bembapɛɛ aáken, “Nzɛ́-módɛ́ bad bɔ́ béhɔ́bɛɛ́ bán Mwǎn-a-Moonyoŋ adé?” ");
INSERT INTO bssNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bêntimtɛ́n mɔ́ bán, “Doŋge á bad béhɔ́be bán edíi Jɔnɛ Ndusɛnɛ, bémpēe bán Elaijaa, ábíníí-ʼɛ bán Jeremayaa kéʼɛ nkal éʼdəə́dəŋ nhɔ́g ampée.” ");
INSERT INTO bssNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Hɛ́ɛ Yesuɛ ásɛdtɛɛ́ bɔ́ aáken, “Boŋ nyéběn-nɛ, nzɛ́-módɛ́ nyéhɔ́bɛɛ́ bán ndé?” ");
INSERT INTO bssNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simɔn Petro ankwɛntɛ́n aá, “Wɛ-ɛɛ́ edé Ane-awě-Béwɔ́gté, Mwǎn a Dyǒb áde ádé á aloŋgé.” ");
INSERT INTO bssNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesuɛ antimtɛ́n aá, “Nnam ndé ne wɛ, a-Simɔn, mwǎn awě Jonaa. Saké moonyoŋ áláŋgé wɛ nɛ̂, boŋ echem Sáŋ awě adé ámīn mɔ́ɔ ahɔ́bté wɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Né-ɔɔ́ a-Petro nlâŋge wɛ, wɛɛ́ edé ndim-e-aláá. Ámīn e ene ndim e aláá dɔ́ɔ mɛ́lōŋgē ḿmêm mwembé. Ké ngíne e kwééd éehɛnlé ḿmê mwembé ahɔ́bed ásē. ");
INSERT INTO bssNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Áwôŋ dɔ́ɔ mɛ́bɛɛ́ mekii mé nkamlɛn ḿ mín. Kéchéé éche ébéné á nkǒŋsé, né ébénnédé ámīn. Kéchéé-ʼɛ éche ébágé kunze a nkǒŋsé, né ébágnédé kunze ámīn.” ");
INSERT INTO bssNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Hɛ́ɛ Yesuɛ ásímɛɛ́ ábē bembapɛɛ etúu áte nɛ́n béēhɔ̄bē bán mɔ́ɔ mɔ́dē Ane-awě-Béwɔ́gté. ");
INSERT INTO bssNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Bootya ene póndé, Yesuɛ ambootéd ábē bembapɛɛ alúmed áte aá mɔ́tə̄ŋgɛ̄nē akɛ á Jerusalɛm. Áwed-taá mɔ́kudté metake híin á mekáá mé bad bémbáá, beprisɛ bémbáá ne bemeléede bé mbéndé. Aá bɛ́wūū mɔ́, boŋ eʼpun ábe éʼlóntɛ́né éʼláán mɔ́ɔ̄puú. ");
INSERT INTO bssNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Dɔ́ɔ Petro átímné Yesuɛ á nkəg boŋ ákəgé âtimed mɔ́ áte, áhɔ̄bē nɛ́n aá, “A-Sáŋ, Dyǒb déekwɛntɛ́nné mbêd aá nɛ́n ábɛnled ne wɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Hɛ́ɛ Yesuɛ ákúnnédé boŋ áhɔ̄bē wɛ́ɛ Petro aá “Hidé mɛ áʼsō-te, a-Satan! Cheé ékə́əʼɛ́ mɛ âbɛl mewêmtɛn mé Dyǒb? Ehɔ́be nɛ̂ ne mewêmtɛn mé moonyoŋ saké mé Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ ábē bembapɛɛ aá, “Kénzɛ́ɛ́ awě awémtɛ́né mɛ ahíd, atə́ŋgɛ́né ásob yə̌l mendíb, ápêm ádē awɔg, boŋ áhíde mɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Áyə̄le kénzɛ́ɛ́ awě ahɛde ádē aloŋgé asoŋ, ǎbɔ̄d dɔ́. Kénzɛ́ɛ́-ʼɛ awě ǎbɔ̄d ádē aloŋgé áyə̄l echêm, ǎkud dɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nsyə́ŋ ńhéé mod ákudté nzé akudé nkǒŋsé ńsyə̄ə̄l boŋ abɔ́dé ádē aloŋgé? Ké-ʼɛ, cheé mod áhɛlɛsɛ ábɛ âkɔde ádē aloŋgé? ");
INSERT INTO bssNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nlâŋge nyé ḿmɛ́n mekan áyə̄le Mwǎn-a-Moonyoŋ ǎpɛ̌ ne ehúmé éche eche Sáŋ nchoo ne éche ángɛl. Ene póndé dɔ́ɔ ákɔ̄gsɛ̄nnē kéʼɛ ánamédté kénzɛ́ɛ́ tə̂ŋgɛne chǒm éche âmbɛnlé. ");
INSERT INTO bssNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ne mbále nlâŋge nyé nɛ́n mɛɛ́ doŋge á bad átîntê echɛ̂n béenyínɛ́nné kwééd dǐd ésebán bényíne nɛ́ɛ Mwǎn-a-Moonyoŋ ápɛ́ɛ́né ḿmē nkamlɛn á nkǒŋsé.” ");
INSERT INTO bssNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ámbīd e epun ntóób Yesuɛ ankɛɛ́n Petro ne Jemsɛ bɔ́ mwǎnyaŋ Jɔnɛ á mbɔɔd echě echabé ámīn. Běnpɛn-ɛɛ́ bémbɛ̄ áhed. ");
INSERT INTO bssNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Dɔ́ɔ ábê bembapɛɛ bényíné nɛ́ɛ áhə́ŋlɛ́né, eʼsó éʼpɛné mɔ́ á nló nɛ̂ŋgáne enyɛn. Mbɔ́té chɔ́-ʼɛ épūbē mɔ́ féréd émwaá-ʼɛ áte. ");
INSERT INTO bssNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ábwɔ̄g-ábwɔ̄g, ábê bembapɛɛ bényīn nɛ́ɛ Mosɛɛ ne Elaijaa bébídé təléd, bɔ́ɔbɛ Yesuɛ békaleʼ. ");
INSERT INTO bssNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Dɔ́ɔ Petro álâŋgɛɛ́ Yesuɛ aá, “A-Sáŋ, ébóó ngáne syáā dédíí hɛ́n. Nzé edəə́, mɛ̌lōŋ eʼbem éʼláán, échōŋ, éche Mosɛɛ ne éche Elaijaa.” ");
INSERT INTO bssNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Eépedɛɛ́ ké amad á nsəl boŋ mbag echě ekine áte ékūtān bɔ́. Hɛ́ɛ béwógɛɛ́ ehɔ́b ébíde á mbag-tê nɛ́n, “Awem Mwǎn a nlém nɛ́n, awógte mɛ menyiŋge. Nyéwógne mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Áde ábē bembapɛɛ béwógé échê ehɔ́b, bémbwɔ̄g mebóbóŋ, bésōŋ-ʼɛ eʼsó ásē ne mbwɔ́g ń ngíne. ");
INSERT INTO bssNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Dɔ́ɔ Yesuɛ ápédé wɛ́ɛ bémbɛ̄ɛ̄ boŋ ábānē bɔ́ ekáá á yə̌l, áhɔ̄bē aá, “Nyéhide ásē, nyéebááʼ.” ");
INSERT INTO bssNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Áde bényéné nló ámīn, bényīn Yesuɛ mwěnpɛn. ");
INSERT INTO bssNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Áde bɔ́bɔ̄ɔ bésudɛɛ́ á mbɔɔd mîn nɛ̂, dɔ́ɔ Yesuɛ ásímɛɛ́ bɔ́ etúu áte áhɔ́beʼ aá, “Nyéeláŋgé modmod dyamdyam áde nyényíné kə́ə́ŋ ne á póndé echě Dyǒb dɛ́puúdté Mwǎn-a-Moonyoŋ á kwééd.” ");
INSERT INTO bssNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Hɛ́ɛ ábē bembapɛɛ bésɛdtɛɛ́ mɔ́ bánken, “Cheé ekə́ə́ boŋ bemeléede bé mbéndé béhɔ́bé nɛ́n bán Elaijaa atə́ŋgɛ́né asébe dé apɛ boŋ Ane-awě-Béwɔ́gté ǎpɛ̌?” ");
INSERT INTO bssNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesuɛ antimtɛ́n bɔ́ aá, “Ne mbále, Elaijaa atə́ŋgɛ́né asébe dé apɛ, atíí-ʼɛ mam mésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Boŋ nlâŋge nyé nɛ́n mɛɛ́ Elaijaa ammǎd apɛ, boŋ bad bénkênchemmé mɔ́, bêmbɛ̌l-lɛ mɔ́ ngáne bêndəŋgé. Melemlem né-ʼaá Mwǎn-a-Moonyoŋ átagké áwab mekáá.” ");
INSERT INTO bssNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Enɛ́n póndé dɔ́ɔ ábē bembapɛɛ bɛ́sōŋtɛ̄nnē nɛ́n bán Jɔnɛ, Ndusɛnɛ mɔ́ɔ áhɔ́bɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Áde Yesuɛ ne ábê bembapɛɛ bétímé ámbīd ámpē boŋ bétán ndun e mod, mod nhɔ́g ampɛ̌ áwē, akɔ́g mebóbóŋ, boŋ áhɔ̄bē nɛ́n aá, ");
INSERT INTO bssNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“A-Sáŋ sôn, wóg awem mwǎn ngɔl. Awem mwǎn a mwɛnchóm akonle nkole mé ekikíd, atage bwâmbwam. Ayɔ̌gké ahún kə́ə́ŋ ne á muú-te ne á mendíb-te. ");
INSERT INTO bssNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mempɛɛ́n mɔ́ wɛ́ɛ ábōŋ bembapɛɛ, boŋ béehɛlɛɛ́ mɔ́ achood.” ");
INSERT INTO bssNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Dɔ́ɔ Yesuɛ átimtanné aá, “Wáā! Nyé bad béʼ chii, mbɛltéd ḿmɛ̄n méētyéemɛɛ́, nyéewóo-ʼáa adúbe. Chán mɛ́pɛɛ́ nyé adyɛn hɛ́n-ēē? Chán mɛ́pɛɛ́ nyé awɛsɛn-ē? Hyɛnáád mɛ mwǎn awed hɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Dɔ́ɔ Yesuɛ ákamlanné edəə́dəŋ é mbéb éche étágtéʼáá ane mwǎn aá ébîd, boŋ ébíd-tɛ. Ábwɔ̄g-ábwɔ̄g ane mwǎn áchōŋ-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ámbīd e póndé bembapɛɛ ábe Yesuɛ béntān mɔ́, boŋ bésɛdté mɔ́ á kun-tê nɛ́n bánken, “Cheé ênkə̌ŋ boŋ sênkênhɛ̌l échê edəə́dəŋ é mbéb abíded?” ");
INSERT INTO bssNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Dɔ́ɔ Yesuɛ átimtanné bɔ́ aá, “Áyə̄le adúbe ádé nyé mwǎmpīn. Ne mbále nlâŋge nyé nɛ́n mɛɛ́, nzé nyêwóó adúbe áde ádé mwǎmpīn nɛ̂ŋgáne mbə́l-e-bǔ, né nyɛ́ɛ̄kamlɛ́n échɛ́n ekone bán éhide hɛ́n, étim híníí, étīm-mɛ nɛ̂ děn. Dyam ké ahɔ́g déetómmé nyé áte. ");
INSERT INTO bssNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nyêhɛle-sɛ nyêbídéd enɛ́n ndín e edəə́dəŋ é mbéb nzé nyêkânne, nyédidé-ʼɛ yə̌l nzaa á mekáne-tê.” ");
INSERT INTO bssNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesuɛ ne ábē bembapɛɛ bénladɛ́n áte hǒm ahɔ́g á mbwɔ́g e Galilia. Hɛ́ɛ álâŋgɛɛ́ bɔ́ aá, “Bɛ́bɛɛ́ Mwǎn-a-Moonyoŋ á mekáá mé baányoŋ. Bɔ́-ʼaá bɛ́wūū mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Boŋ Dyǒb dɛ́puúd mɔ́ ámbīd e eʼpun éʼláán.” Áde bembapɛɛ béwógé nɛ̂, bénwōg ndutul bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesuɛ ne ábē bembapɛɛ bêmpɛ̌ á dyad á Kapenahum. Áhed dɔ́ɔ bad ábe bésáŋtéʼáá táásɛ e Ndáb-e-Dyǒb bétáné Petro boŋ bésɛdté mɔ́ bánken, “Kíné awɛn meléede eésaŋgɛ́ɛ́ táásɛ e Ndáb-e-Dyǒb-e?” ");
INSERT INTO bssNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petro antimtɛ́n bɔ́ aá, “Asaŋgeʼ.” Áde Petro ásɔ́lé á ndáb sɔ́lɛ́n, eépedɛɛ́ dyam ahɔ́b boŋ Yesuɛ ásɛdté mɔ́ aá, “A-Simɔn, chán ényíné ádɛ́n akan? Benzébádé kə̂ŋ é nkǒŋsé ésaŋtɛɛ́ eʼsaŋgé kéʼɛ táásɛ? Bǎn bé aloŋ-ɛ, ngé beken?” ");
INSERT INTO bssNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petro ákwɛntɛ́n aá, “Beken.” Yesuɛ aá, “Nɛ̂ álûmte nɛ́n bán, bǎn bé aloŋ béetə̂ŋgɛnɛɛ́ asaa. ");
INSERT INTO bssNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Boŋ ké nɛ̂, âbɛl nɛ́n deéliŋsé ábê bad ábe bésaŋte táásɛ, kɛ̌ ébwêm eʼchɔ̂b á edib-é-nzab-tê. Súu eche wɛ́sēbɛ̄ɛ̄ akób, énede chɔ́ nsəl áte, wɛ̌tān mɔné ḿme mɛ́kwog sóo táásɛ asaŋned áwēd-te. Téd mɔ́, ésaŋned sóo.” ");
INSERT INTO bssNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Éebemɛɛ́ áte ámbīd e nɛ̂, bembapɛɛ ábe Yesuɛ bêmpɛ̌ áwē, bésɛ̄dēd mɔ́ bánken, “Nzɛ́-módɛ́-ʼɛ atómtɛ́né mod ambáá abɛ́ á nkamlɛn ḿ mín?” ");
INSERT INTO bssNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Hɛ̂ dɔ́ɔ Yesuɛ áchɛ́nlé mwěndem nhɔ́g, átīīdē mɔ́ áwab tîntê, ");
INSERT INTO bssNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","boŋ áhɔ̄b aá, “Ne mbále nlâŋge nyé nɛ́n mɛɛ́ ésebán mod ahə̌ŋlɛ́né ádē aloŋgé boŋ abɛ́ nɛ̂ŋgáne anɛ́n mwǎn, eéhɛ̄lɛ̄ɛ̄-sɛ asɔ́l á nkamlɛn ḿ mín. ");
INSERT INTO bssNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Né-ɔɔ́, kénzɛ́ɛ́ awě asǔdté yə̌l nɛ̂ŋgáne anɛ́n mwǎn né mɔ́ɔ atómtɛ́né mod ambáá abɛ́ átîntê e bad ábe bédé ásē e nkamlɛn ḿ mín. ");
INSERT INTO bssNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kénzɛ́ɛ́ awě akobé enɛ́n ndín e mwǎn á dǐn ádêm, né akobé mɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Boŋ kénzɛ́ɛ́ awě abɛ̌lté enɛ́n ndín e mwěndem awě adúbpé mɛ mbéb, émbɛ̄ mboŋ né bêntəə́ ene ndín e mod sáŋkalaa a aláá á nkə́ŋ, boŋ béhúnéd-tɛ mɔ́ wɛ́ɛ edíb é nkwɛ̌ étómtɛ́né achab ásē. ");
INSERT INTO bssNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Eʼbéb éʼ yə̌l áte ne nkǒŋsé áyə̄le mekəgsɛn ḿme mébɛlte bad mbéb. Mekəgsɛn métə́ŋgɛ́né apɛ, boŋ eʼbéb éʼ yə̌l áte ne mod awě abɛ̌lté mod ampée mbéb. ");
INSERT INTO bssNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nzé échoŋ ekáá kéʼɛ ekuu ébɛlte wɛ mbéb, esɛ́l chɔ́, épim. Édé mboŋ wɛ âkud aloŋgé ne epɛd é yə̌l tómaa wɛ âwóŋ mekáá mébɛ kéʼɛ mekuu mébɛ boŋ bébwém wɛ á muú ḿme méēdīmēʼ. ");
INSERT INTO bssNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Melemlem nzé ádoŋ dǐd ábɛlte wɛ mbéb, ehúd dɔ́, épim. Édé mboŋ wɛ âkud aloŋgé ne dǐd ahɔ́g tómaa wɛ âwóŋ mǐd mébɛ boŋ bébwém wɛ á dǔ-á-muú. ");
INSERT INTO bssNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Nyényîn nɛ́n bán nyéetédɛɛ́ ḿmɛ́n mpín ḿ bǎn ké nhɔ́g nkóŋtéd, bán méesaá etógnɛ́n. Nlâŋge nyé nɛ́n mɛɛ́ ángɛl éche énɔneʼ bɔ́ ébâg áʼsō ábe echem Sáŋ awě adé ámīn âhɔ́be bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Chán nyényíné ádɛ́n dyam? Nzé mod awóó mbwɔ́kɛl é ńdyɔŋ ḿ mbód, boŋ nhɔ́g ḿbɔ́ɔ́, ngɔ́mē ǎtɛdé ḿmíníí móom mé ńdyɔŋ ḿ mbód abog ne abog wɛ́ɛ bédyákē medyɛ́ á ekone mîn âkɛ dé ahɛd ḿmê nhɔ́g ḿme ḿbɔ́ɔ́? ");
INSERT INTO bssNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ne mbále nlâŋge nyé nɛ́n mɛɛ́, nzé adǐbté-ʼɛ mɔ́ abɛlé awógɛ́n mɔ́ menyiŋge tómaa ḿmíníí móom abog ne abog ḿme ménkêmbɔ́ɔ. ");
INSERT INTO bssNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Melemlem nɛ̂ dɔ́ɔ echɛn Sáŋ awě adé ámīn éehɛdɛ́ɛ́ aá ké mpín ḿ mwěndem nɛ́ɛ ḿmɛ́n ḿbɔ́ɔ. ");
INSERT INTO bssNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nzé mwǎnyoŋ abɛ̌nlé wɛ awusé, tán mɔ́ wɛ́ɛ nyúmɔ̄ bad bébɛ běnpɛn nyédíí, échu mɔ́ dɔ́ aláa. Nzé achemé ádē awusé, né nyé mwǎnyoŋ nyêtimé ásē. ");
INSERT INTO bssNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Boŋ nzé eékwɛntɛne aá mɔ́pǎnné wɛ, etéd mod ampée nhɔ́g kéʼɛ bébɛ ékɛ̄ɛ̄n áwē, âbɛl nɛ́n, ‘Mbéb ké ńhéé ḿme éhɔ́bé wɛɛ́ abɛlé wɛ ḿbyɛ̂n ne mbóŋ ébɛ kéʼɛ éláán.’ ");
INSERT INTO bssNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nzé eékobe kə́ə́ŋne chǒm-ɛ́ɛ échê mboŋ éhɔ́bé, épɛ̄ɛ̄n mɔ́ á mwembé. Nzé eékwɛntɛne ké bɔ́ awóglɛn, etéd mɔ́ nɛ́ɛ mod awě eedúbpe áyə̄l e ḿme nsôŋtɛn káa nɛ̂ŋgáne nsaad-a-táásɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, kéchéé éche nyébéné á nkǒŋsé ébénnédé ámīn. Kéchéé-ʼɛ éche nyébágé kunze á nkǒŋsé, ébágnédé kunze ámīn. ");
INSERT INTO bssNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nlâŋge nyé ámpē nɛ́n mɛɛ́, nzé nyé bad bébɛ nyêchěmtɛ́né áyə̄le kéchéé boŋ nyêhɛdé chɔ́ á mekáne-tê, echem Sáŋ awě adé ámīn ǎbɛ̌ nyé chɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Áyə̄le wɛ́ɛ bad bébɛ kéʼɛ béláán béládné áwêm dǐn, mɛ́mpē ndé áwab tîntê.” ");
INSERT INTO bssNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Hɛ̂ dɔ́ɔ Petro ápédé wɛ́ɛ Yesuɛ, boŋ ásɛdté mɔ́ aá “A-Sáŋ, nzé mwǎnned abɛnle mɛ awusé póndé tɛ́ɛ́, ngen étə́ŋ ńtə́ŋgɛ́né mɔ́ alagsɛn? Kə́ə́ŋse ngen saámbé-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Dɔ́ɔ Yesuɛ átimtanné mɔ́ aá, “Nlâŋge nyé nɛ́n mɛɛ́, saké ngen saámbé, boŋ móom mé ngen saámbé ne saámbé. ");
INSERT INTO bssNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nɛ̂ dɔ́ɔ édíí á nkamlɛn ḿ mín. Dyǒb ákamlanné nɛ̂ŋgáne kə̂ŋ pɔ́g echě echɛ́nlé bad ábe bébɛle nsɔ́n ásē echê, ânɔn mɔné ḿme bɔ́ ké ahéé béwánlé mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Abooted áde ábóótédé ânɔn mɔné ḿme ábê bad béwánlé mɔ́, dɔ́ɔ bad bépɛ́ɛ́nédé mɔ́ mod nhɔ́g awě anwálé mɔ́ nkúú ḿ mɔné. ");
INSERT INTO bssNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ane mod enkênhɛnlé ádē alúm atwɛ, né-ɔɔ́ kə̂ŋ enhɔ́b aá bésôm mɔ́ nchoo ne mwaád ne bǎn nɛ̂ŋgáne betâŋ, bésôm-mɛ bwěm éʼsyə̄ə̄l ábe áwóó. Ḿmê mɔné mɛ́bē âsábe áde alúm. ");
INSERT INTO bssNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ane mod ankwɛ̌ kə̂ŋ á mekuu, áchāā mɔ́ aá, ‘Bɛɛ́ mɛ póndé, mɛ̌twɛ̌ ádoŋ alúm ásyə̄ə̄l.’ ");
INSERT INTO bssNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kə̂ŋ enwóg mɔ́ ngɔl, anchené mɔ́ aá ákag, álagsɛ́n-nɛ ádê alúm. ");
INSERT INTO bssNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nɛ́ɛ ane mod áhídté hɛ̂, ambomɛ́n waáb awě mɔ́mpē abɛléʼáá nsɔ́n ásē e kə̂ŋ. Waáb ne anwálé mɔ́ mwǎ mɔné awě énkêmbuú áte. Dɔ́ɔ átɔ́lé waáb á mengɔgíd, aá ásábe mɔ́ ḿmê mɔné. ");
INSERT INTO bssNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Waáb ankwɛ mɔ́ á mekuu, áchāā mɔ́ aá, ábɛ mɔ́ póndé aá, mɔ́ɔ̄sābē mɔ́ ádē alúm. ");
INSERT INTO bssNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ane mod enkênlagsɛ́nné waáb, anhɛ́ mɔ́ á mbwɔg aá kə́ə́ŋ né asábpé áde alúm boŋ bɛ́bīdēd mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Áde bad ábe bébédé áhed ábe bɔ́mpē bébɛ́léʼáá nsɔ́n ásē e kə̂ŋ bényíné dyam áde ábɛ́nlédé, bénlǐŋ bwâmbwam. Bênkɛ̌ kə̂ŋ dyam ásyə̄ə̄l áde ábɛ́nlédé aláa. ");
INSERT INTO bssNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Né-ɔɔ́, kə̂ŋ enchɛ́lé ane mod, álāŋgē mɔ́ aá, ‘Ekúkú é ləə nɛ́n! Menlagsɛ́n wɛ alúm áde wénwālɛ̄ɛ̄ mɛ áyə̄le wɛncháŋ mɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Cheé ékə́ə́ boŋ weewóge wɛ̌n ngɔl melemlem nɛ̂ŋgáne mɛ-ʼɛ ménwōgkē wɛ ngɔl?’ ");
INSERT INTO bssNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kə̂ŋ ênlǐŋ bwâmbwam, né-ɔɔ́ anlóm ane mod á mbwɔg aá béwóged mɔ́ ndutul. Aá ábɛ́-ʼɛ á mbwɔg kə́ə́ŋ né asábpé áde alúm ásyə̄ə̄l.” ");
INSERT INTO bssNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Né-ɔɔ́, Yesuɛ ansógtɛ́n nɛ́n aá, “Nɛ̂ dɔ́ɔ Titɛ́ɛ Dyǒbɛ awě adé ámīn ábɛnlé. Nzé weélagsɛne mwǎnyoŋ ne ḿmôŋ nlém ńsyə̄ə̄l, né Dyǒb dɛ́kɔ̄gsɛ̄n wɛ ngáne ene kə̂ŋ énkɔ̄gsɛ̄nnē ane mod.” ");
INSERT INTO bssNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Áde Yesuɛ ámáá ḿmɛ́n mekan ahɔ́b, anhidé á Galilia ákɛ á mbwɔ́g e Judeya, áchābē á pɛd e edíb é Jodan eníníí. ");
INSERT INTO bssNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ndun e mod enhíd mɔ́ áwed, áchōōd-tɛ bad bé nkole. ");
INSERT INTO bssNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Doŋge á Befarisia bémpɛ̌ áwē âkəg mɔ́. Bênsɛdéd mɔ́ bánken, “Mbéndé echɛ̂d ebagé kunze nɛ́n bán, mod ánan awě mwaád áyə̄le nyaa e nzɔm ké ehéé-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesuɛ ankwɛntɛ́n bɔ́ aáken, “Nyéēlááʼɛ́ á kálag e Dyǒb nɛ́n bán á mbooted, Dyǒb dênhəg bɔ́ mmwaád ne mwɛnchóm-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Dyǒb á hɔ́bpe aá, “Áyə̄le né-ɔɔ́, mwɛnchóm ǎtɛdé sáá ne nyaŋ abɛ́ ne mwaád, boŋ búmɔ̄ bad bébɛ bétīm mod nhɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Né-ɔɔ́, búmɔ̄ béesaá ámpē bad bébɛ, boŋ bédíi mod nhɔ́g. Né-ɔɔ́, échě Dyǒb áládé, modmod eepááʼ.” ");
INSERT INTO bssNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Hɛ̂ dɔ́ɔ ábê Befarisia bésɛdtɛɛ́ mɔ́ bánken, “Nzé édé nɛ̂, cheé-ɔ̄ ênkə̌ŋ boŋ Mosɛɛ ábagé bad kunze aá, mod ábɛ mwaád kálag echě elûmte nɛ́n bán, eʼwóŋgé éʼmáá boŋ ǎnan mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Mosɛɛ ambǎg nyé enɛ́n kunze áyə̄le nyêlɛlé nlém á abum. Énkêmbáá nɛ̂ á mbooted mé nkǒŋsé. ");
INSERT INTO bssNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Né-ɔɔ́, nlâŋge nyé nɛ́n mɛɛ́, mod ké ahéé awě anané mwaád ésebán ane mmwaád akábé asón, nzé ene ndín e mod awóó mmwaád ampée, né akábé asón.” ");
INSERT INTO bssNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Hɛ̂ dɔ́ɔ ábē bembapɛɛ bélâŋgɛɛ́ mɔ́ bán, “Nzé nɛ́n dɔ́ɔ mekan mé mmwaád ne nchóm médíí, né éesaá nsyə́ŋ âwóŋ mmwaád.” ");
INSERT INTO bssNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesuɛ antimtɛ́n bɔ́ aá, “Saké mod asyəə́l ahɛle ákob ádɛ́n ayə́ged. Boŋ dɛ́kobnéd ne bad ábe Dyǒb ábágé dɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nyêbíí nɛ́n bán, nzɔm édé híin échě ékə́ə́ boŋ bad béēwōō bebaád. Behɔ́g bédé ábe béchyáátɛ́né nɛ̂. Bémpēe-ʼɛ bédé nɛ̂ áyə̄le bad bébɛ́lé bɔ́ nɛ̂. Ábíníí-ʼɛ, bébɛ́lé yə̌l nɛ̂ âbɛl boŋ bébɛl nsɔ́n mé nkamlɛn ń Dyǒb. Kénzɛ́ɛ́ awě ahɛlé ádɛ́n ayə́ge akob, ákob dɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Bad bêmpɛɛ́n běndem wɛ̂ Yesuɛ nɛ́n bán ábân bɔ́ ekáá á nló, ákânned-tɛ bɔ́. Ábē bembapɛɛ bénkānē ábe bad áte. ");
INSERT INTO bssNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Boŋ Yesuɛ anláá bɔ́ aá, “Nyétɛde běndem béhyag áwêm, nyéekə́ə́ bɔ́, áyə̄le nɛ́n, nyaa é bad nɛ́ɛ bɔ́ chɔ́ɔ éwóó nkamlɛn ḿ mín.” ");
INSERT INTO bssNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Né-ɔɔ́, Yesuɛ ambán ábê bǎn ekáá á nló. Ámbīd e nɛ̂, anhidé áhed. ");
INSERT INTO bssNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Póndé pɔ́g mod nhɔ́g ampɛ̌ wɛ́ɛ Yesuɛ, ásɛdté mɔ́ aáken, “A-meléed, dyam á bwâm áhéé ńtə́ŋgɛ́né abɛl, âbɛl nɛ́n ńkud aloŋgé áde déemaáʼ?” ");
INSERT INTO bssNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Hɛ́ɛ Yesuɛ ákwɛntanné mɔ́ aá, “Chán éhɛlɛɛ́ ésɛdté mɛ dyam áde ádé dyam á bwâm? Mod nhɔ́g mwěnpɛn mɔ́ adé awě adé mod a bwâm. Koŋgéʼ mbéndé é Dyǒb nzé ehɛde wɛ mɔ́kud aloŋgé áde déemaáʼ.” ");
INSERT INTO bssNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Dɔ́ɔ ane mod ásɛdtɛɛ́ mɔ́ aáken, “Mbéndé éhéé?” Yesuɛ ankwɛntɛ́n mɔ́ aá, “Weewúɛ́ʼ mod, weekábé asón á ndáb eʼwóŋgé, weechíbéʼ, weebídé mbóŋ e metóm, ");
INSERT INTO bssNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","bɛɛ́ sóó ne nyoŋ edúbé, édəŋ-ʼɛ mwǎnyoŋ nɛ̂ŋgáne echoŋ yə̌l.” ");
INSERT INTO bssNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Hɛ́ɛ ene kɔ́demod élâŋgɛɛ́ Yesuɛ aá, “Nhídé échɛ́n mbéndé ésyə̄ə̄l; cheé émpēe éhɛdne mɛ abɛl.” ");
INSERT INTO bssNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesuɛ antimtɛ́n mɔ́ aá, “Nzé ehɛde wɛɛ́ mɔ́ɔwóó awusé á yə̌l ké ahɔ́g, kǎg ésôm bwěm éʼsyə̄ə̄l ábe éwóó, étêd ḿmê mɔné ébɛ betóótōkɛ̄ bé bad. Nzé ebɛlé nɛ̂, wɛ̌kǔd nhɔn ádyōb. Ene póndé éhyɛ éhíde mɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Áde ene kɔ́demod áwógé nɛ̂, anwóg mbéb áte bwâmbwam áhīdē-ʼɛ áyə̄le ambɛ́ nhɔn bwâmbwam.” ");
INSERT INTO bssNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ ábē bembapɛɛ aá, “Ne mbále nlâŋge nyé nɛ́n mɛɛ́ élɛ̌l áte nhɔn ḿ mod âsɔ́l á nkamlɛn ń Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ńláa nyé ámpē nɛ́n mɛɛ́ édé mwǎn a akan sáŋkalaa a nyam nɛ́ɛ Kamɛ̂l âpoŋ á epɔn é ndɔnde tómaa nhɔn ḿ mod âsɔ́l á nkamlɛn ń Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Áde bembapɛɛ béwógé nɛ́n, yə̌l enkɔ́m bɔ́ áte bwâmbwam. Bênsɛdéd bánken, “Nzɛ́ɛ́-ʼɔ̄ ahɛle ákud eʼsoósoŋ?” ");
INSERT INTO bssNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Hɛ́ɛ Yesuɛ ánɔ́né bɔ́ chóóŋ boŋ áhɔ̄bē aá, “Ne baányoŋ nɛ́n déehɛlɛɛ́ sɛ ábɛnléd boŋ ne Dyǒb dyamdyam déelɛlɛɛ́ áte.” ");
INSERT INTO bssNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Hɛ́ɛ Petro áhɔ́bɛɛ́ aá, “Nɔnéʼ, sêtɛ̌dté chǒm ésyə̄ə̄l âhíd wɛ, cheé-ɔ̄ ébɛ̄ ḿmɛd nsyə́ŋ.” ");
INSERT INTO bssNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, póndé echě Mwǎn-a-Moonyoŋ ádyɛɛ́ʼɛ́ á atii dé nkamlɛn ne éche ehúmé ésyə̄ə̄l á nkǒŋsé ḿme ńhúɛʼ, nyé bad dyôm ne bébɛ ábe béhíde mɛ nyémpē nyɛ́ɛ̄dyɛɛ́ á metii mé nkamlɛn, nyékāādtē metúmbé mé Israɛl dyôm ne mébɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kénzɛ́ɛ́-ʼɛ awě atɛ̌dté éche ndáb, baányaŋ, sáá, nyaá, bǎn, ne eche mbwɔ́g áyə̄l echêm, ǎkud chɔ́ mbwɔ́kɛl e ngen, ákūd-tɛ aloŋgé áde déemaáʼ. ");
INSERT INTO bssNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Boŋ bad híin ábe bédé áʼsō bɔɔb bɛ́lyəg mbíd, híin-nɛ ábe bénlyəg mbíd bɛ́bē áʼsō.” ");
INSERT INTO bssNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Hɛ̂ dɔ́ɔ Yesuɛ ákalɛɛ́ ngan aá, “Nhɔ́be nɛ̂ áyə̄le nkamlɛn ḿ mín ńdé nhəgtɛ́n nɛ̂ŋgáne nwóó-nzag nhɔ́g awě ambíd á ndáb epɔg é mbwɛmbwɛ âkɛ dé ahɛd bad ábe ásābɛ̄ɛ̄, âbɛl nsɔ́n áwē nzag-tê. ");
INSERT INTO bssNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bɔ́ɔ̄bɔ̄ɔ bêmpɛ̌ á nchemtɛn áyə̄le nsábe mé epun é bǐn boŋ álómé bɔ́ áwē nzag-tê. ");
INSERT INTO bssNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ane nwóó-nzag antǐm ámbīd ámpē á dyad-tê á ngə́ŋ abog. Antán bad bé nsɔ́n bémpēe áhed. Béntyēēm ngɛ̂n, béebɛleʼaá chǒmchǒm. ");
INSERT INTO bssNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Hɛ́ɛ álâŋgɛɛ́ bɔ́ aá, ‘Nyémpē nyékɛ nyébɛl nsɔ́n áwêm nzag-tê, mɛ̌sābē nyé nsábe ḿme ńkwógnédé.’ ");
INSERT INTO bssNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Né-ɔɔ́, bênkɛ̌. Ambɛ̌l melemlem mé dyam á kəd, ne á ngə́ŋ éláán. ");
INSERT INTO bssNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Dyam ngə́ŋ étáan nɛ́ɛ ane mod átímé á dyad-tê ámpē, antán bad bé nsɔ́n ábe bɔ́mpē béntyēēm, béebɛleʼaá dyamdyam. Hɛ́ɛ ásɛdtɛɛ́ bɔ́ aá, ‘Cheé nyébébtɛɛ́ epun é bǐn ésyə̄ə̄l hɛ́n ngɛ̂n áde nyéebɛlɛ́ɛ́ dyamdyam.’ ");
INSERT INTO bssNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bênkwɛntɛ́n mɔ́ nɛ́n bán, ‘Modmod eetédɛɛ́ sé á nsɔ́n.’ Hɛ́ɛ ane mod álâŋgɛɛ́ bɔ́ aá, ‘Nyémpē nyékag-kɔɔ́ nyébɛl nsɔ́n áwêm nzag-tê.’ ");
INSERT INTO bssNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Áde ngukɛ́l épédé, ane nwóó-nzag anláá awě mod awě anɔne ábē bad bé nsɔ́n aá, álad bad bé nsɔ́n áte, ásábe bɔ́. Aá, ábooted ne bad ábe bédímtɛ́né apɛ, ásōg-kɛ ne ábe bésébpé apɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ambɛɛ́ bad ábe bêmbootéd nsɔ́n á ngə́ŋ étáan nsábe mé epun é bǐn ");
INSERT INTO bssNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Áde bad ábe bénsēbē nsɔ́n abooted bépédé âkob nsábe, bénwēmtɛ̄n bán, bɛ́kud nsábe ḿme ńtómé ḿ bad ábe bêmbootéd nsɔ́n á ngə́ŋ étáan. Boŋ bɔ́mpē bênkǔd melemlem mé nsábe. ");
INSERT INTO bssNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Áde békóbé mɔné ḿme bêmbɛɛ́ bɔ́, bêmbootéd anyoo áte. ");
INSERT INTO bssNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Béhɔ̄bē bán, ‘Ábɛ́n bad bébɛ́lé nsɔ́n háwa pɔ́g chěmpɛn, ké nɛ̂, esábpé bɔ́ melemlem nɛ́ɛ sé ábe sêbɛlé nsɔ́n epun é bǐn ésyə̄ə̄l ne enyɛn é ngíne.’ ");
INSERT INTO bssNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nwóó-nzag antimtɛ́n ábê bad nhɔ́g aá, ‘Amúɛ̄, meédogɛɛ́ nyé. Éesaá mbále bán dentíí bán mɛ̌bɛ nyé nsábe mé nsɔ́n mé epun é bǐn-ɛ? ");
INSERT INTO bssNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nyékob-pɔɔ́ ḿmɛ̄n mɔné, nyékag. Mměn-ɛɛ́ ntíídé mɛɛ́ mɛ̌sābē anɛ́n mod awě adǐmtɛ́né apɛ melemlem ngáne ńsábpéʼáá wɛ́mpē. ");
INSERT INTO bssNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Meewóoʼɛ́ kunze âbɛnled ḿmêm mɔné ngáne ńdə́ə́-yɛ? Cheé ékə́ə́ boŋ nyébēbtē nlém á abum áyə̄le ábêm eʼboŋ bé nlém?’ ” ");
INSERT INTO bssNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesuɛ ansógtɛ́n ene ngan aá, “Né-ɔɔ́, béʼsō bɛ́tǐm bé mbíd, bé mbíd-tɛ bɛ́tǐm bé eʼsó.” ");
INSERT INTO bssNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesuɛ ne ábē bembapɛɛ békágéʼáá á akuu á Jerusalɛm. Áde békagké nɛ̂ dɔ́ɔ áchə́gé bɔ́ á nkəg, boŋ álāŋgē bɔ́ á kun-tê aá, ");
INSERT INTO bssNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Pɔ́n nyébíi bán dekag á Jerusalɛm, áwed-taá bɛ́bɛɛ́ Mwǎn-a-Moonyoŋ á mekáá mé beprisɛ bémbáá ne bemeléede bé mbéndé. Bɔ́-ʼɛ bɛ́bɛɛ́ mbakú bán atə́ŋgɛ́né awɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Bɛ́bɛ mɔ́ á mekáá mé bad ábe béesɛ̌ bad bé Israɛl. Bɔ́-ʼɛ bɛ́wɔɔdé mɔ́, béswādtāād mɔ́ eʼtaŋgú, bébōmē-ʼɛ mɔ́ á awɔg. Boŋ ámbīd e eʼpun éʼláán Dyǒb dɛ́puúd mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ámbīd e póndé dɔ́ɔ Zɛbɛdiɛ mwaád ápédé wɛ́ɛ Yesuɛ ne ábē bǎn bé baachóm bébɛ, abwɔ́g mebóbóŋ, áchāā-ʼɛ Yesuɛ aá ábɛle mɔ́ dyam. ");
INSERT INTO bssNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesuɛ ansɛdéd mɔ́ aáken, “Cheé éhɛdɛɛ́?” Dɔ́ɔ ákwɛntanné mɔ́ aá, “Bǎg mɛ akag nɛ́n wɛɛ́, póndé eche wɛ́bɛ̄ɛ̄ á nkamlɛn, ábêm bǎn bɛ́n bébɛ bɛ́dyɛɛ́ wɛ á nkəg, nhɔ́g ekáá émbáá, aníníí-ʼɛ á ekáá é emwɛd.” ");
INSERT INTO bssNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Hɛ́ɛ Yesuɛ ákwɛntanné bɔ́ aá, “Nyéebíiʼɛ́ chǒm éche nyésɛdtɛɛ́. Nyɛ́ɛ̄hɛ̌l metuné ḿme mɛ́pēmmē apém-ɛ?” Bênkwɛntɛ́n bán béhɛ̌l. ");
INSERT INTO bssNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Ne mbále, nyɛ́ɛ̄pēm boŋ meewóoʼɛ́ kunze âpwɛd mod awě ǎdyɛɛ́ mɛ á ekáá é mbáá kéʼɛ á ekáá é emwɛd. Ábê eʼtə́l éʼdíi eʼtə́l ábe éʼbágnédé ne bad ábe echem Sáŋ ánábnédé bɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Áde ábíníí bembapɛɛ dyôm béwógé nɛ̂, bênliín ábê baányaŋ bébɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Né-ɔɔ́ Yesuɛ anlad bɔ́ áte, boŋ álāŋgē bɔ́ aá, “Nyêbíí nɛ́n bán, benkamlɛnɛ ne bad bémbáá bé nkǒŋsé bébɛnlad ngíne âkamlɛn bad ábe bédé ásē echâb. ");
INSERT INTO bssNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Boŋ éetə̂ŋgɛnɛɛ́ abɛ́ nɛ̂ átîntê echɛ̂n. Kénzɛ́ɛ́ awě ahɛde aá mɔ́bɛ̂ mod ambáá átîntê echɛ̂n, atə́ŋgɛ́né abɛ́ mbəledɛ awɛ̂n. ");
INSERT INTO bssNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kénzɛ́ɛ́-ʼɛ awě ǎbɛ̄ mod aʼsó átîntê echɛ̂n, atə́ŋgɛ́né abɛ́ awɛn ntâŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Melemlem nɛ́ɛ Mwǎn-a-Moonyoŋ eépedɛɛ́ aá bad bébɛnle mɔ́, boŋ apedé âbɛle bad, âbɛ-ʼɛ ádē aloŋgé âkɔde bad híin.” ");
INSERT INTO bssNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Áde Yesuɛ ne ábē bembapɛɛ béhidtɛɛ́ á Dyad á Jeriko, ndun e mod ehídéʼáá mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ene póndé-ʼɔɔ́ bad bébɛ ábe bênkwɛ̌ ndím bêndyɛɛ́ á nkəg ń nzii. Áde béwógé bán, Yesuɛ atómeʼ, bêmbootéd abón bán, “A-Mwǎn a mbyaa ḿme Dabidɛ, wóg sé ngɔl!” ");
INSERT INTO bssNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ndun e mod echě embɛ́ áhed enkáné bɔ́ áte bán bédib nsəl. Boŋ bɔ́-ʼɛ bémbādnɛ̄n abón ne ngíne bán, “A-Mwǎn a mbyaa ḿme Dabidɛ, a-Sáŋ, wóg sé ngɔl!” ");
INSERT INTO bssNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesuɛ antyéem, achɛ́lé bɔ́ boŋ ásɛdté bɔ́ aáken, “Cheé nyéhɛdɛɛ́ bán, ḿbɛle nyé?” ");
INSERT INTO bssNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bênkwɛntɛ́n bán, “A-Sáŋ, sêhɛde bán, ébɛl sényínɛn.” ");
INSERT INTO bssNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesuɛ anwóg bɔ́ ngɔl, né-ɔɔ́ ambán bɔ́ mekáá á mǐd. Ábwɔ̄g-ábwɔ̄g bêmbootéd anyínɛn, béhīdē-ʼɛ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Áde Yesuɛ ne ábē bembapɛɛ békwógé apɛ á Jerusalɛm, nɛ́ɛ bépédé á dyad á Bɛtpeg á ekone é menzab Yesuɛ anlóm bembapɛɛ bébɛ áʼsō. ");
INSERT INTO bssNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Anláá bɔ́ nɛ́n aá, “Nyékag á dyad áde ádé nyé áʼsō nɛ̂. Nzé nyêsɔ́lé sɔ́lɛ́n, nyɛ́ɛ̄tán nɛ́ɛ bétə́ŋgé ésɛl ne mwǎn ánkəg. Nyéhune bɔ́ nyéhyiinad mɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nzé mod asɛ̌dté nyé aáken, cheé ékə́ə́ boŋ nyéhunneʼ, nyêláá mɔ́ bán Sáŋgwɛ́ɛ́ atógnɛ́né bɔ́. Nzé nyêhɔ́bé nɛ̂, ábwɔ̄g-ábwɔ̄g ane mod ǎchennéd nyé.” ");
INSERT INTO bssNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nɛ́n dêmbɛnléd âlóned eʼyale ábe Dyǒb dénlōmɛ̄nnē nkal éʼdəə́dəŋ aá, ");
INSERT INTO bssNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Áláa dyad á Zayɔn aá, Nyénɔneʼ, echɛn kə̂ŋ ehyag áwɛ̄n, asǔdté yə̌l, adiídé ésɛl, etum é nchóm a ésɛl.” ");
INSERT INTO bssNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Né-ɔɔ́ ábê bembapɛɛ bênkɛ̌ bébɛ̄l-lɛ ngáne Yesuɛ ánlyə̄gtɛ̄nnē bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bêmpɛɛ́n échê ésɛl ne mwǎn, bétéd échab mbɔ́té, bétal chɔ́ ámīn, boŋ Yesuɛ ádiideʼ. ");
INSERT INTO bssNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ekud é bad bêntǎl échab mbɔ́té á nzii-tê, ábíníí-ʼɛ bésɛ̄lēʼ eʼkikag éʼ mií, bétaléʼ á nzii-tê. ");
INSERT INTO bssNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ndun e mod echě ekágéʼáá mɔ́ áʼsō ne echě ehídéʼáá mɔ́ ámbīd bêmbootéd abón bán, “Hosána, mekɛnag mébɛ̂ ne mwǎn a mbya ḿme Dabidɛ. Nnam ḿbɛ̂ ne ane awě apedé á dǐn áde Sáŋgwɛ́ɛ́. Hosána, mekɛnag ne Dyǒb áde ádé se ámīn!” ");
INSERT INTO bssNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nɛ́ɛ Yesuɛ ásɔ́lé á Jerusalɛm nɛ́n sɔ́lɛ́n, bad bésyə̄ə̄l bépuutéd, bésɛdté-ʼɛ bánken, “Nzɛ́ɛ́ ne?” ");
INSERT INTO bssNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Dɔ́ɔ ene ndun e mod ékwɛntanné bán, “Yesuɛ mɔ́ adé, nkal éʼdəə́dəŋ a dyad á Nazarɛt á mbwɔ́g e Galilia.” ");
INSERT INTO bssNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ámbīd e nɛ̂, Yesuɛ ankɛ asɔ́l á Ndáb-e-Dyǒb. Annǎn bad bésyə̄ə̄l ábe békábéʼáá dyɔn áwēd-te. Ankuné betébelɛ ábe bad bépɛ́nléʼáá mɔné ámīn mekuu ámīn, ákūnē-ʼɛ metii ḿmé bad ábe bésómméʼáá mbəŋgé mekuu ámīn. ");
INSERT INTO bssNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Anláá-ʼɛ bɔ́ aá, “Éténlédé nɛ́n bán, Dyǒb áhɔ́bé aá, ‘Echem ndáb etə́ŋgɛ́né achəgned bán ndáb e mekáne.’ Boŋ nyêtimté chɔ́, ‘mbwɔg mé bechîb!’ ” ");
INSERT INTO bssNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bad ábe bênkwɛ̌ ndím ne bad ábe mekuu ménwɛ̄ɛ̄ ábe bémbɛ̄ áhed bêmpɛ̌ áwē, ádīd-tɛ bɔ́ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Boŋ áde beprisɛ bémbáá ne bemeléede bé mbéndé bényíné menyáké ḿme Yesuɛ ábɛ́lé, boŋ béwóg-kɛ eʼsaád ábe běndem bébónɛɛ́ á Ndáb-e-Dyǒb bán, “Mekɛnag mébɛ̂ ne mwǎn a mbyaa ḿme Dabidɛ,” bênlǐŋ bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bênsɛdéd Yesuɛ bánken, “Ewóge chǒm-ɛ́ɛ ábê bǎn béhɔ́bɛɛ́-yɛ?” Yesuɛ ankwɛntɛ́n bɔ́ aá, “Ɛɛ, nwógeʼ. Nyéēlāāʼɛ́ mbêd á kálag e Dyǒb nɛ́n bán, Dyǒb ábóŋsɛ́né eʼchɛd éʼ běndem ne éʼ bǎn bé nkə́ə́l âbɛ mɔ́ mekɛnag mé bwâm-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ámbīd e nɛ̂ Yesuɛ antɛdé bɔ́ á Jerusalɛm ákɛ ánāā á dyad á Bɛtani. ");
INSERT INTO bssNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Epɔg é mbwɛmbwɛ áde átimɛɛ́ ámbīd á Jerusalɛm nzaa enkób mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Áde ákagké nê annyín alín á ngəl. Ankɛ̌ áhed, boŋ enkênyínné epum ké ehɔ́g áwedé-mîn étómɛɛ́ byaá. Hɛ́ɛ Yesuɛ álâŋgɛɛ́ ábê bwɛl aá, “Wéechyááʼɛ́ epum ámpē mbêd.” Ábwɔ̄g-ábwɔ̄g bwɛl bénhyɛ́le. ");
INSERT INTO bssNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Áde ábē bembapɛɛ bényíné nɛ̂, yə̌l enkɔ́m bɔ́ áte bwâmbwam. Hɛ́ɛ bésɛdtɛɛ́ bánken, “Chán ádɛ̄n alín á ngəl ámwédé ayɛ́le á mehélé-te nɛ́n-ē?” ");
INSERT INTO bssNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesuɛ ankwɛntɛ́n aá, “Ne mbále nlâŋge nyé nɛ́n mɛɛ́, nzé nyêdúbpé ne nlém ńsyə̄ə̄l, né saké dyam áde ḿbɛ́lé ábɛ́n bwɛl áyə̄l děmpɛn nyɛ́bɛnlé. Boŋ né nyêhɛle-sɛ nyêláá kə́ə́ŋne enɛ́n mbɔɔd nɛ́n bán, ‘Hidé hɛ́n, ékɛ ébwêm yə̌l á edíb é nkwɛ̌-te,’ ébɛnléd-tɛ nɛ̂ děn. ");
INSERT INTO bssNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nzé nyêwóó adúbe bán, kéchéé éche nyéhɛ́dné Dyǒb á mekáne-tê nyɛ́ɛ̄kǔd, né nzé nyêhɛdé nyɛ́ɛ̄kǔd.” ");
INSERT INTO bssNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesuɛ ansɔ́l á Ndáb-e-Dyǒb, áyə̄gtē bad. Áde áyə́gtɛɛ́ nɛ̂, dɔ́ɔ beprisɛ bémbáá ne bad bémbáá bé Israɛl bépédé áwē, bésɛdté mɔ́ bánken, “Kunze ehéé éwóó âbɛl ḿmɛ́n mekan? Nzɛ́-módɛ́ abagé-ʼɛ wɛ ene kunze?” ");
INSERT INTO bssNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesuɛ antimtɛ́n bɔ́ aá, “Mɛ ámpē mɛ̌sɛdéd nyé dyam ahɔ́g. Nzé nyêkwɛ̌ntɛ́né dɔ́ né mɛ-ʼɛ mɛ̌lāā nyé kunze echě ńwóó âbɛl ḿmɛ́n mekan. ");
INSERT INTO bssNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Edusɛn éche Jɔnɛ ádúsánnáá bad héé émbīdtē? Émbīd ne Dyǒb-ɛ ngé ne baányoŋ?” Běn ne běn bémbootéd apentɛn bán, “Nzé dehɔ́bé nɛ́n bán, ‘Jɔnɛ echě kunze enhúú ne Dyǒb,’ né ǎsɛdéd syánē aáken, ‘Cheé-ɔ̄ enkə̌ŋ boŋ nyénkêndúbé mɔ́?’ ");
INSERT INTO bssNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Boŋ nzé dehɔ́bé bán, ‘Echě kunze ehúú ne baányoŋ,’ né échɛ́n ekud é mod ébɛl syánē mbéb áyə̄le bad bésyə̄ə̄l béndūbē bán Jɔnɛ abédɛ́ɛ nkal éʼdəə́dəŋ.” ");
INSERT INTO bssNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Né-ɔɔ́ bênkwɛntɛ́n Yesuɛ bán, “Séebíiʼɛ́.” Mɔ́-ʼɛ antimtɛ́n bɔ́ aá, “Né ké mɛ-ʼɛ ámpē méelááʼɛ́ nyé kunze echě ńwóó âbɛl ḿmɛ́n mekan.” ");
INSERT INTO bssNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesuɛ ambɛ́ ásɛ̄dēd beprisɛ bémbáá ne bad bémbáá bé dyad aáken, “Chán nyényíné ádɛ́n akan tə̂ŋgɛne enɛ́n ngan? Mod nhɔ́g abédé awě anchyáá bǎn bé baachóm bébɛ. Hɛ́ɛ ákíí mwǎn ambáá aláa aá, ‘A-mwǎn, kɛ̌ ébɛl nsɔ́n á nzag-tê chii.’ ");
INSERT INTO bssNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mwǎn antimtɛ́n mɔ́ aá mɔ́ɔkaá. Boŋ ámbīd e póndé anhəŋlɛ́n mewêmtɛn, ákɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dɔ́ɔ ane mod ákíí wɛ́ɛ mwǎn asad, aláá-ʼɛ mɔ́mpē melemlem mé dyam. Anɛ́n mwǎn antimtɛ́n sáá aá, ‘A-Sáŋ, mɛ̌kɛ̌’ boŋ eékii.” ");
INSERT INTO bssNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Hɛ́ɛ Yesuɛ ásɛdtɛɛ́ beprisɛ bémbáá aáken, “Átîntê ábɛ́n bǎn bébɛ, ahéé ambɛ̌l ngáne sáá áhɛ́déʼáá?” Bênkwɛntɛ́n mɔ́ bán, “Ambáá.” Né-ɔɔ́, Yesuɛ anláá bɔ́ aá, “Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, besaad-bé-táásɛ ne bɛkwalɛɛ bédé asɔ́l á nkamlɛn ń Dyǒb tómaa nyé. ");
INSERT INTO bssNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nhɔ́be nɛ́n, áyə̄le Jɔnɛ, Ndusɛnɛ ampɛ̌, alúméd nyé nzii echě etyéémé, nyénkêndúbɛ́ɛ́ mɔ́, boŋ besaad-bé-táásɛ ne bɛkwalɛɛ béndūbē. Ké nɛ́ɛ nyénnyīn-naá nɛ̂, nyénkênhəŋlɛ́nné, nyênkêndúbé-ʼaá mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesuɛ anláá bɔ́ aá, “Nyéwóglɛn ngan empée. Nwóó-nzag nhɔ́g abédé awě ankwɛ̌l nzag e eʼpum éʼ mɛl ábe bébɛnlɛɛ́ mǐm. Ankág chɔ́, ábɛl bwǎl wɛ́ɛ béminɛɛ́ ábê eʼpum éʼ mɛl âbɛl mǐm, alóŋ-ʼɛ ebem áwēd-te wɛ́ɛ bédyɛɛʼɛ́ ânɔn nzag áte. Ambɛɛ́ ene nzag wɛ́ɛ bad ábe bɔ́ɔ̄bɔ̄ɔ bɛ́kǎb mbote áte, ákɛ̄ á aloŋ démpēe. ");
INSERT INTO bssNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ádě póndé épédé eche bépadɛɛ́ eʼpum, ane nwóó-nzag anlóm ábē bembəledɛ wɛ́ɛ ábê bebɛl-bé-nsɔ́n âkobe mɔ́ ádē asii dé eʼpum. ");
INSERT INTO bssNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Hɛ́ɛ ábê bebɛl-bé-nsɔ́n békóbé ábê bembəledɛ, béwannéʼ nhɔ́g, béwūɛ̄ʼ ampée, aníníí-ʼɛ béwūɛ̄nē meláá. ");
INSERT INTO bssNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ámbīd é póndé ane nwóó-nzag anlóm bembəledɛ bémpēe ábe bêmbuú áte tómaa ábíníí. Ábê bebɛl-bé-nsɔ́n bêmbɛ̌l ábê bembəledɛ melemlem ngáne bêmbɛnlé béʼsō. ");
INSERT INTO bssNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ámbīd e póndé anlóm awe mwǎn áwāb, ne mewêmtɛn nɛ́n bɛ́bɛɛ́ mɔ́ edúbé. ");
INSERT INTO bssNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Boŋ áde bebɛl-bé-nsɔ́n bényíné ane mwǎn nɛ́ɛ áhúɛʼɛ́, dɔ́ɔ bɔ́ běn ne běn béhɔ́bɛɛ́ nɛ́n bán, ‘Ndyɛ́-a-mbwɔ́g nɛ́n, nyéhyag! Déwúu mɔ́, âbɛl nɛ́n, eche mbwɔ́g ésuuned syánē.’ ");
INSERT INTO bssNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Hɛ̂ dɔ́ɔ békóbé mɔ́, bébīdɛ̄n mɔ́ á nzag-tê, boŋ béwúú-ʼɛ mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Hɛ́ɛ Yesuɛ ásɛdtɛɛ́ ábê bad bémbáá bé dyad ne beprisɛ bémbáá aá, “Bɔɔb-pɔɔ́, nzé nwóó-nzag ne apedé, cheé ábɛnlé ábê bebɛl-bé-nsɔ́n?” ");
INSERT INTO bssNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Hɛ̂ dɔ́ɔ békwɛntanné bán, “Ǎwūū ábê eʼbébtéd éʼ bad eʼbébtéd é kwééd, ábɛ̄-ʼɛ ene nzag wɛ́ɛ bebɛl-bé-nsɔ́n bémpēe ábe bɛ́bɛ mɔ́ ádē asii á mbote nzé póndé epedé eche bépádɛɛ́ eʼpum.” ");
INSERT INTO bssNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesuɛ anláá bɔ́ ámpē aá, “Nyéēlāā-ʼɛ́ mbêd wɛ́ɛ eyale é Dyǒb éhɔ́bé nɛ́n bán, ‘Aláá ádě belóŋ-bé-ndáb bênchenɛɛ́ dɔ́ɔ átímé aláá dé etógnɛ́n abɛ́. Sáŋgwɛ́ɛ́ mɔ̂ ambɛl nɛ́n, édé-ʼɛ syánē menyáké.’ ");
INSERT INTO bssNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Né-ɔɔ́ nlâŋge nyé nɛ́n mɛɛ́, bɛ́kobɛ́n nyé etə́l éche nyéwóó nɛ́ɛ bad bé nkamlɛn ń Dyǒb, bébɛ̄ wɛ́ɛ bad ábe bébɛleʼ ngáne Dyǒb áhɛdɛɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Áde beprisɛ bémbáá ne Befarisia béwógé échɛ́n ngan éche Yesuɛ ákálé, bênchem bán, bɔ́ɔ ákanlɛɛ́ chɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Né-ɔɔ́ béhɛ́déʼáá mɔ́ akób, boŋ bémbāŋ abɛl nɛ̂, áyə̄le bényīn bán, ene ndun e mod enyínéʼáá Yesuɛ nɛ́ɛ nkal éʼdəə́dəŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesuɛ ambɛ́ ábɛnléd ngan ámpē âkalɛn ábê bad. Anhɔ́b aá, ");
INSERT INTO bssNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Nkamlɛn ḿ mín ńdé nɛ̂ŋgáne kə̂ŋ pɔ́g echě enláá ábē bembəledɛ aá béboŋsɛn ngande e eʼwóŋgé ábe awé mwǎn a mwɛnchóm. ");
INSERT INTO bssNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ene kə̂ŋ-ʼɛ anlóm ábē bembəledɛ aá békɛ béchəg bad ábe álébpé áyə̄le ene ngande, boŋ ábê bad bénkênkwɛntɛ́nné apɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Hɛ́ɛ álómɛɛ́ bembəledɛ bémpēe aá béláa bad ábe mɔ́lébpé nɛ́n bán, ‘Nyêbíí nɛ́n bán, mmaá nyag ne eʼlem ábe éʼbóó yə̌l awúu. Chǒm ésyə̄ə̄l-lɛ édé mboŋsɛ́n, nyéhyag-kɔɔ́ á ngande.’ ");
INSERT INTO bssNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Boŋ ké nɛ̂ ábê bad ábe bénlēbɛ̄ɛ̄ bénkêntédté ḿmê nlébtéd nɛ́ɛ dyam. Mod tɛ́ɛ́ ahídéʼáá ḿmē ntíi ámbīd. Behɔ́g bênkɛ̌ áwāb nzag-tê, ábíníí béhīdē ḿmab nsɔ́n mémpēe ámbīd. ");
INSERT INTO bssNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ábíníí-ʼɛ bénkōb ábê bembəledɛ, bébɔm bɔ́, béwúú-ʼɛ bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ene kə̂ŋ enlǐŋ bwâmbwam. Né-ɔɔ́, anlóm éche sə́nze. Nɛ́ɛ épédé, éwūū bad ábe bénwūū ábê bembəledɛ, éhyāād-tɛ ábê bad dyad. ");
INSERT INTO bssNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Dɔ́ɔ álâŋgɛɛ́ ábē bembəledɛ bémpēe aá, ‘Ngande e eʼwóŋgé emaá mboŋsɛ́n abɛ́, boŋ bad ábe ńlébpé béekwognedɛɛ́ chɔ́ abɛ́ ásē. ");
INSERT INTO bssNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Bɔɔb-pɔɔ́, nyékag á mbom ń nzii á dyad-tê, nyéchɛ́le bad bésyə̄ə̄l ábe bényíné bán, béhyag á ngande.’ ");
INSERT INTO bssNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Né-ɔɔ́ ábê bembəledɛ bênkɛ̌ á dyad-tê, bélād bad bésyə̄ə̄l ábe bényīnnē, ken mod a bwâm kéʼɛ mod a mbéb, kə́ə́ŋ ndáb e ngande enlɔ́g áte. ");
INSERT INTO bssNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Kə̂ŋ empɛ̌ á ndáb-te ânɔn bad ábe bépédé á ngande. Áde ápédé anyín mod awě enkênhɛ́ asaŋ áde ántə̄ŋgɛ̄nnē ahɛ́ á ngande e eʼwóŋgé. ");
INSERT INTO bssNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Hɛ́ɛ ásɛdtɛɛ́ mɔ́ aá, ‘Amúɛ̄, chán émwédé apɛ hɛ́n áde wéēhēdɛɛ́ asaŋ á ngande e eʼwóŋgé.’ Boŋ ane mod enkênhɔ́bpé dyamdyam. ");
INSERT INTO bssNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Dɔ́ɔ kə̂ŋ élâŋgɛɛ́ ábē bembəledɛ ábe béchágtéʼáá beken aá, ‘Nyéhaŋ mɔ́ mekáá ne mekuu, nyébwêm mɔ́ á ebwɔ́g, á ehíntɛ́n-tê. Áhed-taá béchyɛɛ́ʼɛ́, bédyāg-kɛ mesoŋ á nsəl.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Hɛ́ɛ Yesuɛ ásógtɛɛ́ enɛ́n ngan ne eʼyale nɛ́n aá, “Dyǒb áchɛ̂nleʼ bad híin âbɛ́ ásē e nkamlɛn ḿmē, boŋ nguse chɔ́ɔ épwɛdnéd.” ");
INSERT INTO bssNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ébédé póndé pɔ́g echě Befarisia bênkɛɛ́ mbom, âhəge Yesuɛ, âbɛl békóbɛn mɔ́ awusé tɛ̂ŋgɛne eʼyale ábe bɛ́bīd mɔ́ á nsəl. ");
INSERT INTO bssNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bénlōm ábāb bembapɛɛ nchoo ne bad bé epepé éche Hɛrɔdɛ wɛ́ɛ Yesuɛ. Nɛ́ɛ bépédé áwē, bélāŋgē mɔ́ nɛ́n bán, “A-meléed, sêbíí nɛ́n bán, ekale mbále. Sêbíí-ʼɛ ámpē nɛ́n bán, ayə́ge ádōŋ tə̂ŋgɛne mbéndé e Dyǒb ádé mbále. Mewêmtɛn mé bad ne eʼsó éʼ mbɔm éʼ bad béehəŋlánné ádôŋ ayə́ged. ");
INSERT INTO bssNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Láá-ʼɛ sé ngáne ényíné ádɛ́n akan. Mbéndé eche syánē ehɔ́be nɛ́n bán désaŋgeʼ táásɛ wɛ́ɛ Kaisɛɛ, kə̂ŋ e Roma-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Boŋ Yesuɛ ambíí ḿmab mewêmtɛn mé mbéb. Né-ɔɔ́ ansɛdéd bɔ́ aáken, “Nyé bedog-badɛ́, cheé nyéhəgkɛɛ́ mɛ? ");
INSERT INTO bssNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nyélúmed mɛ mɔné ḿme bésaŋnadté táásɛ eched.” Bêmpiinéd mɔ́ mɔné mé ekii. ");
INSERT INTO bssNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Dɔ́ɔ ásɛ́dté bɔ́ aáken, “Ediídiŋgɛ éche nzɛ́ɛ́ chɛ́n? Dǐn áde nzɛ́ɛ́-ʼɛ dɛ́n?” ");
INSERT INTO bssNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bênkwɛntɛ́n mɔ́ bán, “Ábe Kaisɛɛ.” Dɔ́ɔ álâŋgɛɛ́ bɔ́ aá, “Nyébag-kɔɔ́ Kaisɛɛ éche édé éche Kaisɛɛ, nyébag-kɛ Dyǒb éche édé é Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Áde béwógé nɛ̂, yə̌l enkɔ́m bɔ́ áte. Né-ɔɔ́ bênhidé áhed, békɛ̄-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Échê epun chěn doŋge á Besadusia bêmpɛ̌ wɛ́ɛ Yesuɛ. Besadusia béndūbē bán mpuu méesaá ámbīd e kwééd. ");
INSERT INTO bssNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Dɔ́ɔ béhɔ́bɛɛ́ bán, “A-meléed, mbéndé e Mosɛɛ ehɔ́be nɛ́n bán, ‘Nzé mod awóó mmwaád boŋ awédé áde bɔ́ ane mmwaád béepedɛɛ́ mwǎn awále, mwǎnyaŋ a abum ahɔ́g atə́ŋgɛ́né ane nkúd awóŋ, âbɛl boŋ dǐn áde mwǎnyaŋ déēbɔ̄ɔ̄ʼ.’ ");
INSERT INTO bssNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bɔɔb-pɔɔ́, bad bébédé hɛ́n mod saámbé ábe bémbīd abum ahɔ́g. Mod aʼsó anwóŋ mmwaád, boŋ awɛ́ áde bɔ́ mmwaád ne béepedɛɛ́ bǎn awále, né-ɔɔ́ mwǎnyaŋ awě anhíd mɔ́ anlyəgnéd ane nkúd a mmwaád. ");
INSERT INTO bssNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ane mɔ́mpē anwɛ́ áde bɔ́ ane mmwaád béepedɛɛ́ bǎn awále. Melemlem mé dyam mêmbɛnléd ne awě alóntɛ́né béláán, kə́ə́ŋ bébōm bɔ́ mod saámbé. ");
INSERT INTO bssNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kə́ə́ŋne á asóg ane mmwaád mɔ́mpē anwɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Bɔɔb-pɔɔ́ á póndé e mpuu, mmwaád awě nzɛ́ɛ́ ane mmwaád áchəgnédté áyə̄le bɔ́ moosyəə́l saámbé bénwōŋ mɔ́?” ");
INSERT INTO bssNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesuɛ antimtɛ́n bɔ́ aá, “Nyêpaneʼ áyə̄le nyéesôŋtɛnɛɛ́ chǒm éche eyale é Dyǒb éhɔ́bɛɛ́, nyéesôŋtɛnɛɛ́-ʼɛ ngáne ngíne e Dyǒb ésógé abɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Áyə̄le póndé echě bad bɛ́puúʼɛ́ ámbīd e kwééd mewóŋgé méebáá ámpē. Bad bɛ́bē nɛ̂ŋgáne ángɛl éche édé ámīn, béewóŋnɛ́ɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nyéēlááʼɛ́ mbêd dyam áde Dyǒb ahɔ́bé áwɛ̄n tə̂ŋgɛne mpuu-yɛ? Dyǒb áhɔ́bé tə̂ŋgɛne ábɛ̄d betaa aá, ");
INSERT INTO bssNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Mɛ-ɛɛ́ ndé Dyǒb áde Abrahamɛ, Aisigɛ ne Jakɔbɛ.’ Dyǒb ádíi Dyǒb á bad ábe bédé á aloŋgé, saké Dyǒb á bad ábe béwédé.” ");
INSERT INTO bssNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Áde ene ndun e mod echě embɛ́ áhed éwógé nɛ̂, bémbɛ̄ menyáké bwâmbwam tə̂ŋgɛne ayə́ged áde Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Áde Befarisia béwógé bán nkwɛntɛn ḿme Yesuɛ âmbɛɛ́ Besadusia mêmbɛ̌l béehɛle dyamdyam ahɔ́b, bênladɛ́n áte. ");
INSERT INTO bssNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Hɛ̂ dɔ́ɔ bɔ́ mod nhɔ́g awě abédé meléede a mbéndé, áhyédé Yesuɛ akəg, ásɛdté mɔ́ aá, ");
INSERT INTO bssNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“A-meléed, átîntê mbéndé ésyə̄ə̄l, ehéé etómtɛ́né etógnɛ́n abɛ́?” ");
INSERT INTO bssNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesuɛ ankwɛntɛ́n bɔ́ aá, “Etə́ŋgɛ́né édəŋ Sáŋgwɛ́ɛ́ ádoŋ Dyǒb ne ḿmoŋ nlém ńsyə̄ə̄l, ne échoŋ edəə́dəŋ ésyə̄ə̄l, édə̄ŋ-ʼɛ mɔ́ ne ḿmôŋ mewêmtɛn mésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Enɛ́n mbéndé chɔ̂ etómtɛ́né etógnɛ́n abɛ́, ebɛ́-ʼɛ mbéndé eʼsó. ");
INSERT INTO bssNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mbéndé echě elóntɛ́né ébɛ echě chɔ́mpē edé etógnɛ́n melemlem nɛ̂ŋgáne eʼsó edíi nɛ́n ‘Édəŋ mwǎnyoŋ ngáne édə́ə́ echoŋ yə̌l.’ ");
INSERT INTO bssNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Échɛ́n mbéndé ébɛ chɔ́ɔ éwánlé mbéndé éche Mosɛɛ ésyə̄ə̄l ne mekan ḿme bekal-bé-eʼdəə́dəŋ béyə́gté.” ");
INSERT INTO bssNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Hɛ̂ dɔ́ɔ Yesuɛ ásɛdtɛɛ́ ábê Befarisia ábe bênladɛ́n áte aá, ");
INSERT INTO bssNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Chán nyéwêmtanné tə̂ŋgɛne Ane-awě-Béwɔ́gté? Á mbyaa ḿme nzɛ́ɛ́ áhúú?” Hɛ́ɛ békwɛ́ntɛ́né mɔ́ bán, “Abídé á mbyaa ḿme kə̂ŋ Dabidɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesuɛ ansɛdéd bɔ́ aá, “Cheé-ɔ̄ enkə̌ŋ boŋ Dabidɛ áde Edəə́dəŋ é Dyǒb élyə́gté mɔ́ ânchəgké mɔ́ aá, ‘A-Sáŋ,’ áde ahɔ́bé aá, ");
INSERT INTO bssNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Sáŋ Dyǒbɛ anláá awêm Sáŋgwɛ́ɛ́ aá, Dyɛɛ́ áwêm ekáá émbáá, kə́ə́ŋ ne á póndé echě mɛ́bɛnlé boŋ ékɔgtéd ábōŋ bad bé ekɔyí ámīn ne mekuu.’ ");
INSERT INTO bssNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nɛ́ɛ Dabidɛ mwěn ásébpé mɔ́ achəg aá, Sáŋgwɛ́ɛ́, chán-nɔ̄ Ane-awě-Béwɔ́gté áhɛlɛɛ́ abɛ́ awe mwǎn?” ");
INSERT INTO bssNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Bɔ́ modmod bénkênhɛnlé mɔ́ dyamdyam akwɛntɛn. Bootya échê epun bénkênchuʼɛ́ mɔ́ dyamdyam asɛded ámpē. ");
INSERT INTO bssNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ámbīd e nɛ̂, dɔ́ɔ Yesuɛ álâŋgɛɛ́ ene ndun e mod ne ábē bembapɛɛ aá, ");
INSERT INTO bssNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Bemeléede bé mbéndé ne Befarisia bɔ́ɔ bétédé etə́l éche Mosɛɛ bɔɔb âyə́ged bad. ");
INSERT INTO bssNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Né-ɔɔ́, nyêtə́ŋgɛ́né bɔ́ awóglɛn nyébɛlé-ʼɛ mekan mésyə̄ə̄l ḿme bélâŋgɛɛ́ nyé, boŋ nyéēbɛ̄lēʼ mekan ḿme bébɛlɛɛ́, áyə̄le béebɛlɛ́ɛ́ mekan ḿme béhɔ́bɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Békaaʼ eʼdeltéd bé nted, bépêmtad bad, boŋ béesaá mboŋsɛ́n âbán ké ekáá âwóŋgɛn bɔ́ âpém mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kéchéé éche bébɛlɛɛ́, bébɛle chɔ́ âbɛl boŋ bad bényîn bɔ́. Békəlteʼ bǎn bé ntyə́g ábe béhágkē nchoo mé eʼyale eʼ Dyǒb áte, boŋ bétə̄ə̄ á mbɔm ne á mekáá, béchabte eʼtûd ábe béwáaʼɛ́ á mengombe mîn bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bédəə eʼtə́l bé edúbé adyɛɛ á hǒm á ngande, bédə̄ŋ-ʼɛ metii mé edúbé adyɛɛ á ndáb é mekáne. ");
INSERT INTO bssNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bédəə bán, bad bélɛnte bɔ́ ne edúbé ésyə̄ə̄l á dyɔn-tê, bédə̄ŋ-ʼɛ bán, bad béchəge bɔ́ bán, ‘A-meléed.’ ");
INSERT INTO bssNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Boŋ nyé, nyéēmwāg-sɛ béchəgé nyé bán, ‘Meléede.’ Áyə̄le meléede nhɔ́g mɔ́ɔ nyéwóó, baányaŋ bɔ́-ʼaá nyédíí. ");
INSERT INTO bssNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nyéēchə̄gē-ʼɛ mod ké nhɔ́g á nkǒŋsé wɛ́n bán Titɛ́ɛ áyə̄le nyêwóó-ʼɛ Titɛ́ɛ nhɔ́g, awɛ̂n Titɛ́ɛ awě adé ámīn. ");
INSERT INTO bssNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nyéēmwāg-kɛ sɛ béchəgé nyé bán, ‘Sáŋgwɛ́ɛ́’ áyə̄le nyêwóó Sáŋgwɛ́ɛ́ nhɔ́g, Ane-awě-Béwɔ́gté. ");
INSERT INTO bssNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mod awě adé ambáá átîntê e echɛ̂n atə́ŋgɛ́né abɛ́ mbəledɛ awɛ̂n. ");
INSERT INTO bssNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kénzɛ́ɛ́ awě achə́gté yə̌l, Dyǒb dɛ́sudéd mɔ́, kénzɛ́ɛ́-ʼɛ awě asǔdté yə̌l, Dyǒb dɛ́chə̄gēd mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Dɔ́ɔ Yesuɛ áhɔ́bɛɛ́ aá, “Ébɛ̄ɛ̄n nyé bemeléede bé mbéndé ne Befarisia ebébtéd, nyé bad bé medogké! Nyêdibeʼ ekob é nkamlɛn ḿ mín âbɛl boŋ bad béēsɔ̄lēʼ. Nyé běn nyéesɔ́lɛ́ɛ́, nyéēmwāg-kaá bán bad bémpēe ábe béhɛde asɔ́l bésɔ̂l. ");
INSERT INTO bssNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ébɛ̄ɛ̄n nyé bemeléede bé mbéndé ne Befarisia ebébtéd, nyé bad bé medogké. Nyêkag meloŋ ne meloŋ âbɛl boŋ mod nhɔ́g átimɛn nyé. Boŋ nzé amaá nyé atimɛn, nyêbɛlé nyêbébéd mɔ́ nyaa echě ákwógnédé âkud nkɔ́gsɛn á dǔ-á-muú ḿme ńtómé ḿmɛ̄n ngen ébɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ébɛ̄ɛ̄n nyé ebébtéd nyé bad ábe békwédé ndím, boŋ bélyə̄gtē bad bémpēe. Nyêyə́gte bán, ‘Nzé mod amwédé melɛ̌ á dǐn á Ndáb-e-Dyǒb, né nɛ̂ déesaá dyam, boŋ nzé mod amwédé melɛ̌ á dǐn á bwěm éʼ gôl ábe éʼdé áwēd-te, átə́ŋgɛ́né abɛl dyam áde ámwɛ́ɛ́né melɛ̌.’ ");
INSERT INTO bssNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Eʼyɔ́kɛ́l éʼ bad bɛ́n, nyêkwedé ndím! Cheé étómtɛ́né etógnɛ́n abɛ́, gôl-lɛ, ngɛ́ Ndáb-e-Dyǒb echě ebɛlé boŋ gôl ebɛ́ chǒm éche ésáá áʼsō éʼ Dyǒb? ");
INSERT INTO bssNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nyêyə́gteʼ ámpē bán, ‘Nzé mod amwédé melɛ̌ á dǐn dé menyán mé mendɛ, né nɛ̂ déesaá dyam. Boŋ nzé mod amwédé melɛ̌ á dǐn dé mendɛ ḿme médé á menyán mîn, atə́ŋgɛ́né ábɛl dyam áde ámwɛ́ɛ́né melɛ̌.’ ");
INSERT INTO bssNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Bad bé ndím bɛ́n! Cheé étómtɛ́né etógnɛ́n abɛ́, mendɛ ngɛ́ menyán ḿme mébɛ́lé boŋ ḿmê mendɛ mébɛ́ chǒm éche ésáá áʼsō éʼ Dyǒb? ");
INSERT INTO bssNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Né-ɔɔ́ kénzɛ́ɛ́ awě amwédé melɛ̌ á dǐn dé menyán mé mendɛ, né amwédé ḿmê melɛ̌ á dǐn dé menyán ne mendɛ ké méhéé ḿme médé áwedé-mîn. ");
INSERT INTO bssNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kénzɛ́ɛ́-ʼɛ awě amwédé melɛ̌ á dǐn á Ndáb-e-Dyǒb, né amwédé ḿmê melɛ̌ a dǐn á Ndáb-e-Dyǒb ne á dǐn á Dyǒb áde ádyɛɛʼ áwēd-te. ");
INSERT INTO bssNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kénzɛ́ɛ́-ʼɛ ámpē awě amwédé melɛ̌ á dǐn dé nkoŋ ḿ mín né amwédé melɛ̌ á dǐn dé atii dé nkamlɛn ń Dyǒb ne á dǐn á Dyǒb áde ádíídé ádê atii. ");
INSERT INTO bssNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ébɛ̄ɛ̄n nyé bemeléede bé mbéndé ne Befarisia ebébtéd, nyé bad bé medogké! Nyêbage Dyǒb akab ahɔ́g átîntê e mekab dyôm, ké dé mekúle ḿme béchâmnɛɛ́ ndyééd nɛ́ɛ mînt, dîl ne kúmin. Boŋ nyéehédɛɛ́ nló áte âbɛl ndín é mekan éche mbéndé éhɔ́bé aá nyébɛleʼ. Nyéēsaá mbále ne Dyǒb, nyéewóoʼɛ́ nlém ń ngɔl, nyéedúbpe-ʼáa Dyǒb. Nyêntə́ŋgɛ́n ḿmɛ́n mésyə̄ə̄l abɛl, ésebán nyêchɔbteʼ ḿmíníí. ");
INSERT INTO bssNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nyé bad ábe békwédé ndím boŋ bélyə̄gtē bad bémpēe. Nyêbudeʼ mekan ḿme méesɛ̌ etógnɛ́n ahíd ámbīd. Nyêhúdeʼ púuted á mendíb ḿme nyémwāgkē-te, boŋ nyêtɛdte mbinde émbáá éche édé áwēd-te. ");
INSERT INTO bssNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ébɛ̄ɛ̄n nyé bemeléede bé mbéndé ne Befarisia ebébtéd, nyé bad bé medogké! Nyêwobpe mbwendé ne dǐsɛ ámbīd e ebwɔ́g, boŋ medyɛ́ ḿme médé áwēd-te médíi medyɛ́ ḿme nyékúdné ndumbán ne ngoód. ");
INSERT INTO bssNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nyé Befarisia, bad bé ndím bɛ́n! Nyésébe nyéwobe mbwendé ne dǐsɛ áte, kə́ə́ŋne mbíd e ebwɔ́g chɔ́mpē ěsāŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Medim ne nyé bemeléede bé mbéndé ne Befarisia, nyé bad bé medogké! Nyêdíi nɛ́ɛ soŋ éche bépúbté. Ékineʼ áte ámbīd e ebwɔ́g boŋ eʼhid ne eʼbɔɔ bé ndim ḿ bad bɔ́ɔ éʼlóné áwēd-te. ");
INSERT INTO bssNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Melemlem nɛ̂ dɔ́ɔ nyényînnadté áʼsō éʼ bad nɛ́ɛ bad ábe bésáá boŋ áte nyêlóné ne edogké ne mbéb. ");
INSERT INTO bssNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Medim ne nyé bemeléede bé mbéndé ne Befarisia, nyé bad bé medogké! Nyêlóoʼ soŋ é bekal-bé-eʼdəə́dəŋ bwâm, nyéloŋté-ʼɛ mebón ḿme bad ábe bésáá. ");
INSERT INTO bssNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nyêkag, nyêhɔ́be-ʼɛ bán, ‘Nzé sêmbɛ́ á póndé echě ábɛ̄d betaa, né sênkênlatɛ́nné bɔ́ áde bénwūūʼɛ́ bekal-bé-eʼdəə́dəŋ áte.’ ");
INSERT INTO bssNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nɛ̂ děn álûmte nɛ́n bán nyênkwɛntɛ́n nɛ́n bán nyêbídé á mbyaa ḿme bad ábe béwúɛʼ bekal-bé-eʼdəə́dəŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nyékag-kɔɔ́ áʼsō nyémad nsɔ́n ḿme ábɛ̄n betaa bêmbootédté. ");
INSERT INTO bssNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nyə̌ chɛ́n! Etɔd é píí ngɛ̂n. Chán nyɛ́mwɛɛ́ nkɔ́gsɛn ń dǔ-á-muú abame? ");
INSERT INTO bssNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Né-ɔɔ́, mɛ̌lōmē nyé bekal-bé-eʼdəə́dəŋ ne bad bé debyɛ́ɛ́ ne bemeléede. Nyɛ́ɛ̄wūū doŋge, nyébōmē-ʼɛ bɔ́ á awɔg. Nyɛ́swādtēd doŋge eʼtaŋgú á ndáb é mekáne. Ábíníí-ʼɛ nyénané myad ne myad. ");
INSERT INTO bssNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Awúu áde nyéwúɛʼɛ́ bɔ́ dɛ́bɛ̌l Dyǒb ákɔ́gsɛ́n nyé áyə̄le mekií mé bad ábe bésáá bésyə̄ə̄l ábe nyéwúú ebɛn á nkǒŋsé, bootya kwééd eche Abɛlɛ awě béwúú ngɛ̂n, âpɛ kwééd echě Zakariyaa, mwǎn awě Bɛrɛkayaa. Zakariyaa awě nyéwúú átîntê e Ndáb-e-Dyǒb ne hǒm áde bébagɛɛ́ mendɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ne mbále nlâŋge nyé nɛ́n mɛɛ́, enɛ́n nyoŋgɛl chɔ́ɔ ěkǔd nkɔ́gsɛn áyə̄le échɛ́n kwééd ésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Wóowóʼ! Á-bad bé Jerusalɛm, nyêwúɛ bekal-bé-eʼdəə́dəŋ, nyéwúɛ̄nē-ʼɛ bad meláá ábe Dyǒb álómé! Nkénwǎn áte ngen ne ngen âlad nyé áte nɛ̂ŋgáne nyaá-kúb ákútanné bǎn, boŋ nyéehédɛɛ́ etə́l! ");
INSERT INTO bssNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nyénɔneʼ, Dyǒb dɛ́tɛdé echɛn ndáb, modmod éebáá-ʼaá áwēd-te. ");
INSERT INTO bssNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Á mbále, nlâŋge nyé nɛ́n mɛɛ́, nyéenyínɛ́nné mɛ dǐd ámpē kə́ə́ŋ ne á póndé eche nyɛ́ɛ̄hɔ̄bpē bán, ‘Nnam ne ane awě apedé á dǐn á Sáŋgú.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ámbīd e nɛ̂, Yesuɛ anhidé á Ndáb-e-Dyǒb. Áde ákagké nɛ̂, dɔ́ɔ ábē bembapɛɛ bétáné mɔ́, boŋ bélāŋgē mɔ́ bán ánɔne nyaa eche bélóó Ndáb-e-Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Hɛ́ɛ Yesuɛ ákwɛntanné bɔ́ aá, “Ngáne nyényínɛɛ́ ábê bwěm éʼsyə̄ə̄l nɛ̂, ne mbále, nlâŋge nyé nɛ́n mɛɛ́ póndé ěpɛ̌ echě aláá ké ahɔ́g déelyəgké ámīn e waáb. Bɛ́pāŋtēd mésyə̄ə̄l áte.” ");
INSERT INTO bssNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ankɛ̌ á Ekone é Menzab ádyɛ̄ɛ̄ ásē. Hɛ́ɛ ábē bembapɛɛ bétáné mɔ́ wɛ́ɛ bébédé běnpɛn boŋ bésɛdté mɔ́ bán, “Láá sé póndé echě ḿmɛ́n mekan mésyə̄ə̄l mɛ́bɛnlédté. Eʼchemléd éʼhéé bɛ́lūmēd epɛ échōŋ ne asóg dé nkǒŋsé?” ");
INSERT INTO bssNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesuɛ antimtɛ́n bɔ́ nɛ́n aá, “Nyétêd póndé nɛ́n modmod eédōgē nyé. ");
INSERT INTO bssNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bad híin bɛ́pɛ̌ bán bɔ́ɔ bédé Ane-awě-Béwɔ́gté. Bɛ́dǒg-kɛ bad híin. ");
INSERT INTO bssNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nyɛ́ɛ̄wōgē ngáne nzum éwantɛɛ́, nyɛ́ɛ̄wōgē-ʼɛ nzunze é nzum. Boŋ nyé modmod nyéēnə̄ə̄ʼ. Ḿmɛ́n mekan mésyə̄ə̄l métə́ŋgɛ́né abɛnled, boŋ saké mɔ́ɔ mɛ́lūmēd bán asóg ámáá apɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Aloŋ ahɔ́g dɛ́tyēēmɛ̄n ádíníí nzum. Nkamlɛn nhɔ́g-kɛ ńtyēēmɛ̄n ḿmíníí. Nzaa ěbɛ̄, ndɔɔb-pɛ eénəŋnéd ásē mebwɔ́g ne mebwɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Échɛ́n ndutul ésyə̄ə̄l ébɛ̄ nɛ̂ŋgáne mewɛ méʼsō ḿme mmwaád áwógɛɛ́ nzé ahɛde achyáa. ");
INSERT INTO bssNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ene póndé bɛ́kōb nyé, bébɛ nyé á mekáá mé bad ábe bɛ́kɔ̄gsɛ̄n nyé, béwúú-ʼɛ nyé. Meloŋ mésyə̄ə̄l mɛ́kɔɔ́ nyé áyə̄le dǐn ádêm. ");
INSERT INTO bssNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","“Bad híin béewɔ́ŋgé adúbe ámpē. Bɛ́bɛɛ́ nhɔ́g ne aníníí á mekáá mé bad ábe békɔ́ɔ́ bɔ́. Bɔ́ běn-nɛ bɛ́kɔɔ́n. ");
INSERT INTO bssNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bekal béʼdəə́dəŋ bé metóm híin bɛ́bīd, bédōg-kɛ ekud é bad âhíd bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Eʼbéb bé nlém á abum bɛ́chə̄gē, né-ɔɔ́ edəŋge é bad híin ésǔd. ");
INSERT INTO bssNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Boŋ kénzɛ́ɛ́ awě ǎkaán ḿmē metake nlém kə́ə́ŋ ne á asóg, ǎkǔd eʼsoósoŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ḿmɛ́n nkalaŋ ḿ bwâm tə̂ŋgɛne nkamlɛn ń Dyǒb mɛ́kanléd nkǒŋsé áte ńsyə̄ə̄l âbɛl boŋ meloŋ mésyə̄ə̄l méwôg. Ene póndé dɔ́ɔ asóg dɛ́pɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Nyɛ́ɛ̄nyīn nɛ́ɛ ekúkú é akan éche épɛɛne eʼsôn áʼsō é Dyǒb ébɛ́nlédé á Ndáb-e-Dyǒb á hǒm áde ásáá ngáne nkal éʼdəə́dəŋ Daniɛlɛ ánhɔ̄bpē aá ébɛnléd. (Nyé ábe nyêláaʼ ḿmɛ́n mekan nyésôŋtɛn mɔ́ bwâm.) ");
INSERT INTO bssNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nzé nyênyíné nɛ̂, bad ábe bédé á Judeya bétôm mehélé, békɛ bésɔɔm á eʼkone mîn. ");
INSERT INTO bssNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mod awě adé á nnoŋ ń ndáb mîn eétɔgné asud âkɛ dɛ́téd chǒm éche édé mɔ́ á ndáb-te. ");
INSERT INTO bssNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mod awě mɔ́-ʼɛ ámpē adé á nzag-tê, eétīmē ámbīd á ndáb âkɛ dɛ́téd sɔ́te. ");
INSERT INTO bssNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ébɛ̄ ebébtéd ne bebaád ábe bɛ́bē nkog ne ábe bɛ́mwāŋtē ḿmê mesú. ");
INSERT INTO bssNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nyékânne nɛ́n bán ádɛ̂ abáŋgé détānē nyé á póndé e nkóg áde ahéb ádíí ngíne bwâmbwam, kéʼɛ á mbwɛ-mé-nkɔ́me-áte. ");
INSERT INTO bssNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Áyə̄le ndəŋge echě ěbɛ̄ ene póndé ěbɛ̄ ndín echě eébɛ́nlédé mbêd bootya nkǒŋsé ḿbootede kə́ə́ŋ ne epun éʼchii. Dyamdyam nɛ́ɛ ádê déebɛnléd-taá ámpē mbêd. ");
INSERT INTO bssNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Dyǒb ámáá ábê eʼpun éʼ metake asɛ́l áte. Nzé énkêmbɛ́ nɛ̂, né modmod éechoŋgé. Boŋ á etútú é bad ábe ápwɛ́dé, ǎsɛ̄l ábê eʼpun áte. ");
INSERT INTO bssNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ene póndé nzé mod aláŋgé nyé aá, ‘Nyénɔneʼ, Ane-awě-Béwɔ́gté mɔ́ nɛ́n’ káa aá, ‘Mɔ̂níníí,’ nyéedúbpéʼ. ");
INSERT INTO bssNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Áyə̄le bad híin bɛ́bīdēʼ ábe bɛ́kalé metóm nɛ́n bán, bɔ́ɔ bédé Ane awě Dyǒb Áwɔ́gté. Bekal béʼdəə́dəŋ bé metóm ámpē bɛ́bīd. Bɛ́bɛlé menyáké mé ngíne, bélūmtē-ʼɛ eʼchemléd híin. Bɛ́bɛl nɛ́n âbɛl boŋ bédog kə́ə́ŋne bad ábe Dyǒb ápwɛ́dé, nzé nzii edé âdog bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nyénɔneʼ, nlâŋge nyé ḿmɛ́n mekan áʼsō éʼ póndé. ");
INSERT INTO bssNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Né-ɔɔ́ nzé bad béláŋgé nyé nɛ́n bán, ‘Nyénɔneʼ adé á ehyáŋge,’ nyéēkāg áwed. Káa nzé béláŋgé nyé bán, ‘Nyénɔneʼ, adé á toŋ-tê hɛ́n,’ nyéedúbpéʼ. ");
INSERT INTO bssNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Epɛ éche Mwǎn-a-Moonyoŋ ébɛ̄ melemlem nɛ̂ŋgáne emwɛdmwɛd étómɛɛ́ á akuu ne á mbəŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ké héé wɛ́ɛ ndim ḿbāgkē dɔ́ɔ benhɔgnɔnɛ́ béladnɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Áde póndé e ndəŋge ne étōmmē tómɛ́n, etondɛɛ ǎkwɛ ehíntɛ́n, ngɔn-nɛ esóg apɛn. Betintinɛ bɛ́bīd ámīn, béhūn ásē, ngíne-ʼɛ éche édé ámīn énəŋnéd á eʼdii. ");
INSERT INTO bssNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ene póndé dɔ́ɔ nyɛ́nyīnnē nɛ́ɛ eʼchemléd éʼ Mwǎn-a-Moonyoŋ éʼbídé ámīn. Hɛ̂ dɔ́ɔ metúmbé mé nkǒŋsé mésyə̄ə̄l mɛ́bootédté achii ne mbwɔ́g. Bad bɛ́nyīn nɛ́ɛ Mwǎn-a-Moonyoŋ áhúɛʼɛ́ á mbag mîn, ne ngum, ne ehúmé ésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Esaád é eloŋ émbáá éwōgnēd. Ene póndé ǎlōm éche ángɛl á metóŋgé mé nkǒŋsé mésyə̄ə̄l méniin, âlad ábē bad áte ábe Dyǒb ápwɛ́dé, bootya atóŋgé dé nkǒŋsé ahɔ́g âpɛ ádíníí. ");
INSERT INTO bssNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nyétêd eláŋsɛ́n wɛ́ɛ alín á ngəl. Nzé ngɛn ébóótédé byaá békɔ̄ɔ̄lē abíded, nyêbɛle nyêbíí bán nchoŋ ńdé bɛnbɛn. ");
INSERT INTO bssNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Melemlem nzé nyênyíné ḿmɛ́n mekan mésyə̄ə̄l mébɛnlad, nyébíi nɛ́n bán, Mwǎn-a-Moonyoŋ akwogé apɛ, adé-ʼɛ bɛnbɛn. ");
INSERT INTO bssNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, enɛ́n nyoŋgɛl e bad éemaáʼɛ́ kə́ə́ŋ né ḿmɛ́n mekan mésyə̄ə̄l mébɛ́nlédé. ");
INSERT INTO bssNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nkoŋ ḿ mín ne nkǒŋsé bɛ́maá, boŋ ábêm eʼyale bɛ́bē abɛ́ ne abɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Modmod eebíiʼɛ́ epun pɛn kéʼɛ póndé echě ḿmɛ́n mam mɛ́bɛnlédté. Ké ángɛl éche édé ámīn éebíiʼɛ́, ké mwǎn ámpē eebíiʼɛ́. Titɛ́ɛ mwěmpɛn mɔ́ abíí póndé eche ḿmɛ́n mekan mɛ́bɛnlédté. ");
INSERT INTO bssNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Melemlem ngáne émbɛ̄ɛ̄ á póndé eche Noa, nɛ̂ dɔ́ɔ ébɛ̄ɛ̄ póndé echě Mwǎn-a-Moonyoŋ ápɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Áyə̄le á póndé eched, byánán mendíb mé mbúú mɛ́lōn á nkǒŋsé-te bad bédyágéʼáá bwěm, bémwāg-kɛ, bebaád ne baachóm béwôŋne, kə́ə́ŋ ne mbwɛ ḿme Noa ásɔ́lé á bɔ̌lɛ éʼmbáá-te. ");
INSERT INTO bssNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bénkêmbííʼɛ́ dyam áde ábɛnlad, kə́ə́ŋ ne póndé eche mendíb mé mbúú mélónné, méhóód-tɛ bɔ́. Melemlem nɛ̂ dɔ́ɔ ébɛnlédté á póndé echě Mwǎn-a-Moonyoŋ ápɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Bad bébɛ bɛ́bɛlé nsɔ́n á nzag-tê, Dyǒb átéd nhɔ́g, átɛ̄dē aníníí. ");
INSERT INTO bssNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Bebaád bébɛ bɛ́kɔgé medyɛ́, Dyǒb átéd nhɔ́g, áchēnē aníníí. ");
INSERT INTO bssNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Né-ɔɔ́ nyétêd póndé áyə̄le nyéebíiʼɛ́ epun éche awɛn Sáŋgwɛ́ɛ́ ápɛɛ́ ámpē. ");
INSERT INTO bssNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Boŋ nyébíi nɛ́n bán, nzé nwóó-ndáb abyɛ́ɛ́ʼáá póndé eche nchîb ápɛɛ́ nkuu, né ǎdyɛɛ́ epin ânɔn ndáb. Né enkêmmwaá aá nchîb ábóo mɔ́ ndáb. ");
INSERT INTO bssNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Né-ɔɔ́ nyémpē nyêtə́ŋgɛ́né mboŋsɛ́n abɛ́, áyə̄le Mwǎn-a-Moonyoŋ ǎpɛ̌ á póndé echě nyéekamtɛnɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Né-ɔɔ́, nyé mod tɛ́ ábɛ̂ nɛ́ɛ mbəledɛ awě awóó debyɛ́ɛ́, awě abɛle-ʼɛ mam ḿme eche sáŋ áláŋgé mɔ́ aá ábɛl. Mɔ́ adé mbəledɛ awě eche sáŋ ábánné aá ákamlɛn bembəledɛ ábíníí, anyín-nɛ nɛ́n aá békúdé echab ndyééd póndé echě etə́ŋgɛ́né. ");
INSERT INTO bssNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nnam mɛ́bɛ̄ ne ane mbəledɛ awě eche sáŋ áhūūʼɛ́, boŋ atán nɛ̂ŋgáne ábɛlɛɛ́ mam ḿme ánlyə̄gtɛ̄nnē mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ne mbále nlâŋge nyé nɛ́n mɛɛ́, ane mbəledɛ eche sáŋ ǎbané bwěm éʼsyə̄ə̄l ábe áwóó áwe mekáá aá ákamlan. ");
INSERT INTO bssNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Boŋ nzé ane mbəledɛ adé mbəledɛ a mbéb, boŋ ahɔ́bé áwe nlém-tê aá, ‘Éběm áte boŋ echem sáŋ ǎhūu.’ ");
INSERT INTO bssNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Né-ɔɔ́ aboótédé ábíníí bembəledɛ ábe bédé ásē echê awanɛn, ádyāg bwěm, ámwāg-kɛ mǐm ne be-mmwɛ́-mǐmɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Boŋ ane mbəledɛ eche sáŋ ǎhūu epun éche éewêmtɛnɛɛ́ ne á póndé echě énkêmbííʼɛ́ aá ǎhūu. ");
INSERT INTO bssNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ane mbəledɛ eche sáŋ ǎkɔ̄gsɛ̄n mɔ́ hɛɛ́n. Ǎkɔ̄gsɛ̄n mɔ́ melemlem ngáne ánkɔ̄gsɛ̄nnē bedog-badɛ́, áhed dɔ́-ʼaá áchyɛɛ́ʼɛ́ boŋ ádyāg-kɛ mesoŋ á nsəl.” ");
INSERT INTO bssNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesuɛ ambɛnléd ngan empée, áhɔ̄bē nɛ́n aá, “Póndé eche Mwǎn-a-Moonyoŋ ápɛɛ́, nkamlɛn ḿ mín mɛ́bɛ̄ɛ̄ nɛ̂ŋgáne ngɔndérɛ dyôm éche éntēd ábab eʼtrúkáŋ âkɛ dé asin mod awě akude sɔ́mbé âkɛ dɛ́lyə́ged mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Átîntê échê ngɔndérɛ dyôm, étáan émbɛ̄ eyɔ́kɛ́l, étáan-nɛ énwōŋ debyɛ́ɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ábe bémbɛ̄ eyɔ́kɛ́l bénwālē eʼtrúkáŋ boŋ bénkênwálɛ́ɛ́ dyɔ̌g dé etrúkáŋ áde ákwógnédé. ");
INSERT INTO bssNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Boŋ ábe bénwōŋ debyɛ́ɛ́ bénwalé ábab eʼtrúkáŋ ne dyɔ̌g démpēe á eʼpíd te. ");
INSERT INTO bssNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mod awě akudéʼáá sɔ́mbé enkênkobɛ́ɛ́ apɛ, né-ɔɔ́ eʼchə́ éʼtágtéʼáá bɔ́, békún-nɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Melúde mé nkuu dɔ́ɔ esaád ébídé bán, ‘Mod awě akude sɔ́mbé mɔ́ ahúɛʼ nɛ́n! Nyéhyag-kɔɔ́ nyétân mɔ́.’ ");
INSERT INTO bssNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Dɔ́ɔ échê ngɔndérɛ dyôm ésyə́ŋgé ásē, échə́géd ábab eʼtrúkáŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Hɛ́ɛ éche ébédé eyɔ́kɛ́l élâŋgɛɛ́ éche énwōŋ debyɛ́ɛ́ bán, ‘Nyéwôŋgɛn se ádɛ̄n dyɔ̌g dé etrúkáŋ áyə̄le eʼtrúkáŋ ábɛ̄d éʼdímmɛʼ.’ ");
INSERT INTO bssNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ngɔndérɛ éche énwōŋ debyɛ́ɛ́ entimtɛ́n bɔ́ nɛ́n bán, ‘Aáy! Dyɔ̌g áde séwóó déekwogké syánē moosyəə́l. Nyékɛ nyéchan ádɛ̄n wɛ́ɛ bésómɛɛ́.’ ");
INSERT INTO bssNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Né-ɔɔ́, ngɔndérɛ chê énkɛ̌ dyɔ̌g dé etrúkáŋ achan. Áde békíí nɛ̂, dɔ́ɔ mod awě akude sɔ́mbé ápédé. Échê ngɔndérɛ é debyɛ́ɛ́ étáan éche émbɛ̄ mboŋsɛ́n bɔ́ɔ̄bɔ̄ɔ bênkɛ̌ bésɔ́l á ndáb e ngande e eʼwóŋgé bédīb-pɛ ekob. ");
INSERT INTO bssNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ámbīd e póndé dɔ́ɔ échíníí ngɔndérɛ épédé boŋ bélébpé bán, ‘A-Sáŋ dibnéd sé ekob!’ ");
INSERT INTO bssNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Dɔ́ɔ mod awě akude sɔ́mbé átimtanné bɔ́ aá, ‘Ne mbále, nlâŋge nyé nɛ́n mɛɛ́ meebíiʼɛ́ nyé.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Hɛ́ɛ Yesuɛ ásógtɛɛ́ ene ngan nɛ́n aá, “Nyétêd póndé áyə̄le nyéebíiʼɛ́ póndé eche Mwǎn-a-Moonyoŋ ápɛɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesuɛ ambád ámpē aá, “Ene póndé nkamlɛn ḿmīn mɛ́bɛ̄ nɛ̂ŋgáne mod nhɔ́g awě anlédé ekɛ akɛ, boŋ achɛ́lé ábē bembəledɛ alyə́g eche ngáb áwāb mekáá. ");
INSERT INTO bssNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ambɛ bɔ́ mod tɛ́ tə̂ŋgɛne echě ngude. Ambɛ nhɔ́g eʼkə́lé éʼ kábpe éʼtáan, ábɛ aníníí eʼkə́lé éʼbɛ, ábɛ-ʼɛ aníníí ekə́lé ehɔ́g. Amaá-ʼaá bɔ́ abɛ boŋ ákag. ");
INSERT INTO bssNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mbəledɛ awě ankǔd eʼkə́lé éʼtáan antéd ḿmē melemlem mé póndé ákɛ akábɛ́n nyoŋgé, ákudéʼ eʼkə́lé éʼtáan bémpēe nɛ́ɛ nsyə́ŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Awě mɔ́mpē ankǔd eʼkə́lé éʼbɛ ambɛ̌l melemlem ákūd-tɛ eʼkə́lé bémpēe éʼbɛ nɛ́ɛ nsyə́ŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Boŋ mbəledɛ awě ankǔd ekə́lé ehɔ́g ankɛ̌ echóg alím, atéd ḿmē mɔné ḿme awě sáŋgwɛ́ɛ́ ámbɛɛ́ mɔ́, ákóó mɔ́ áwēd-te. ");
INSERT INTO bssNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Etûn é póndé ámbīd enɛ̂, sáŋgwɛ́ɛ́ awě ábê bembəledɛ anhúu, bɔ́ɔ̄bɔ̄ɔ bélúmtɛ́n áte ngáne bɔ́ mod tɛ́ɛ́ ábɛ́nlédé ḿmē mɔné. ");
INSERT INTO bssNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mbəledɛ awě âmbɛɛ́ eʼkə́lé éʼ kábpe éʼtáan ampɛ̌ wɛ́ɛ eche sáŋ, áhɔ̄bē nɛ́n aá, ‘A-Sáŋ, wembɛ̌ mɛ eʼkə́lé éʼtáan ábe ménkābɛ̄nnē nyoŋgé boŋ ńkud eʼkə́lé éʼtáan bémpēe nɛ́ɛ nsyə́ŋ, mɔ́ɔmɛ́n.’ ");
INSERT INTO bssNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Dɔ́ɔ eche sáŋ élâŋgɛɛ́ mɔ́ aá, ‘Nɛ̂ ábóó, edíī mbəledɛ a bwâm, edé mod a mbále, ebɛlé bwâm. Ngáne éhɛ́lé nsoŋgé ńsad alyə́ged, mɛ̌bɛ̌ wɛ nsoŋgé ḿbáá âlyə́ged. Hyǎg-kɔ́, déwôg menyiŋge.’ ");
INSERT INTO bssNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Mbəledɛ awě bêmbɛɛ́ eʼkə́lé éʼ kábpe éʼbɛ mɔ́-ʼɛ ampɛ̌, áhɔ̄bē nɛ́n aá, ‘A-Sáŋ, wembɛ̌ mɛ eʼkə́lé éʼbɛ ábē ménkābɛ̄nnē nyoŋgé boŋ ńkud eʼkə́lé éʼbɛ bémpēe nɛ́ɛ nsyə́ŋ, mɔ̂mɛ́n.’ ");
INSERT INTO bssNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Dɔ́ɔ echab sáŋ álâŋgɛɛ́ mɔ́mpē aá, ‘Ebɛlé dyam áde ábóó, edíi mbəledɛ a bwâm. Ngáne éhɛ́lé nsoŋgé ńsad alyə́ged, mɛ̌bɛ̌ wɛ nsoŋgé ḿbáá âlyə́ged. Hyǎg-kɔ́, déwôg menyiŋge.’ ");
INSERT INTO bssNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Dɔ́ɔ ane-ʼɛ awě bêmbɛɛ́ ekə́lé é kábpe ehɔ́g ápédé boŋ áhɔ̄bē nɛ́n aá, ‘A-Sáŋ, mbíí mɛɛ́ edíi mod awě alɛlé áte. Ehúdeʼ wɛ́ɛ wéēwénɛɛ́, épādē-ʼɛ wɛ́ɛ wéesobɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Menwóg mbwɔ́g, né-ɔɔ́, menkɛ̌ ḿmōŋ mɔné alíme á ndɔɔb-tê. Ḿmōŋ mɔné mɔ́ɔ ńdé, mɔ́-ʼɛ wɛ mɛ́n.’ ");
INSERT INTO bssNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Hɛ́ɛ echab sáŋ álâŋgɛɛ́ mɔ́ aá ‘A-ebébtéd ne ewɔmwɔm é mbəledɛ! Wembíi wɛɛ́ ndíi mod awě ahúdeʼ wɛ́ɛ éewénɛɛ́, wɛɛ́ mpáde-ʼɛ wɛ́ɛ méesobɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Cheé-ɔ̄ ênkə̌ŋ boŋ weehéde ḿmêm mɔné á ndáb eche békoŋgɛɛ́ mɔné âbɛl nɛ́n á ehúu échêm ńtân nɛ́ɛ ńchyáá mɔné mémpēe ámīn?’ ");
INSERT INTO bssNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Dɔ́ɔ ane mod álâŋgɛɛ́ bembəledɛ bémpēe aá, ‘Nyékobɛn mɔ́ ḿmê mɔné nyébɛ wɛ́ɛ mod awě awóó eʼkə́lé éʼ kábpe dyôm. ");
INSERT INTO bssNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kénzɛ́ɛ́ awě awóó, Dyǒb dɛ́bād mɔ́ abɛ, ǎbǔd-tɛ awóŋ bwâmbwam. Boŋ ane awě mɔ́-ʼɛ eewóo, Dyǒb dɛ́kobɛ́n mɔ́ kə́ə́ŋne mwǎmpīn awě awóó. ");
INSERT INTO bssNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Né-ɔɔ́ anɛ́n mbəledɛ awě eésɛ̌ dyam dé abɛnled, bébwêm mɔ́ á ebwɔ́g-te, á ehíntɛ́n-tê. Áhed-taá áchyɛɛ́ʼɛ́, ádyāg-kɛ mesoŋ á nsəl.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesuɛ ambád ahɔ́b ámpē aá, “Á póndé echě Mwǎn-a-Moonyoŋ ápɛɛ́ nɛ́ɛ kə̂ŋ ne ángɛl é Dyǒb ésyə̄ə̄l ǎdyɛɛ́ á atii dé nkamlɛn âkáad bad. ");
INSERT INTO bssNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bad bésyə̄ə̄l a nkǒŋsé bɛ́ladɛ́n áte áwē eʼsó. Ene póndé ǎkab bɔ́ áte moŋge mébɛ melemlem nɛ̂ŋgáne nnɔn-a-mbód ákabɛɛ́ éche mbód áte, ábānē ńdyɔŋ ḿ mbód pɛd pɔ́g, ábānē-ʼɛ tón é mbód échíníí epɛd. ");
INSERT INTO bssNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nɛ̂ dɔ́ɔ ene kə̂ŋ ébanɛ́ɛ́ bad ábe bésáá á ekáá émbáá, ábānē-ʼɛ bad ábe béesaá á ekáá é emwɛd. ");
INSERT INTO bssNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Áde nɛ́n dɛ́bɛnlédté, ǎlāā bad ábe bédé mɔ́ á ekáá émbáá aá, ‘Nyéhyag, nyé bad ábe echem Sáŋ ánámté! Nyéhyɛ nyékob nnam mé nkamlɛn ń Dyǒb ḿme ábóŋsɛ́né nyé bootya póndé eche áhə́gé nkǒŋsé. ");
INSERT INTO bssNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nyɛ́ɛ̄kǔd ḿmɛ́n nnam áyə̄le áde nzaa ékóbé mɛ, nyêmbɛɛ́ mɛ chǒm éche méndyɛ̄ɛ̄. Áde píd ékóbé mɛ nyênhɛ́ mɛ mendíb mɛ́mwɛ̄. Áde mpédé-ʼɛ nken, nyênkǒb mɛ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Áde ménkênwóŋʼɛ́ chǒm éche ńwáaʼɛ́, nyêmbɛ̌ mɛ mbɔ́té. Áde ménkêndyɛ̌ʼɛ́ bwâm, nyêntɔgɛ́n mɛ. Áde ḿbédé-ʼɛ á mbwɔg, nyênhyɛ̌ mɛ anɔn.’ ");
INSERT INTO bssNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Hɛ́ɛ bad ábe bésáá bɛ́kwɛntɛ́nné mɔ́ bán, ‘A-Sáŋ póndé ehéé sénnyīnnē wɛ ne nzaa boŋ sébɛ̄ wɛ ndyééd, káa áde píd ékóbé wɛ boŋ sébɛ̄ wɛ mendíb? ");
INSERT INTO bssNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Póndé ehéé-ʼaá sénnyīnnē wɛ boŋ sɛ́kōb wɛ nken áwɛd mendáb, kéʼɛ sébɛ̄ wɛ mbɔ́té ádě wéēwóoʼɛ́ chǒm éche éhāgkē? ");
INSERT INTO bssNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Póndé ehéé wénkêndyɛɛ́ʼɛ́ bwâm, boŋ sétɔ̄gɛ̄n wɛ, ké-ʼɛ séhyɛ̄ sénɔ̄n wɛ ádě édíí á mbwɔg?’ ");
INSERT INTO bssNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Hɛ́ɛ ene kə̂ŋ étimtanné bɔ́ aá, ‘Ne mbále, nlâŋge nyé mɛɛ́, póndé ké ehéé echě nyêmbɛnlé nɛ̂ ne mwǎnned ké ahéé, ké awě eésɛ̌ etógnɛ́n, né mɛɛ́ nyêmbɛlɛ́ɛ́.’ ");
INSERT INTO bssNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Hɛ́-ʼaá álāāʼɛ́ bad ábe bédé mɔ́ á ekáá é emwɛd aá, ‘Nyésyəə mɛ á dǐd-te, nyé ábe nyékudé nkɔ́gsɛn ń Dyǒb. Nyékag á dǔ-á-muú ḿme méēdīmēʼ, ḿme Dyǒb ábóŋsɛ́né áyə̄l e Devəlɛ ne éche ángɛl. ");
INSERT INTO bssNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nzaa ewagéʼáá mɛ boŋ nyênkêmbaá mɛ chǒm éche ńdyágkē. Áde píd énkōbpē mɛ, nyênkêháá mɛ mendíb. ");
INSERT INTO bssNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mbédé nken, boŋ nyênkênkobpé mɛ áwɛn mendáb. Áde ménkênwóŋgé chǒm éche ńwáaʼɛ́, nyênkêmbaá mɛ mbɔ́té. Áde ménkêndyɛɛ́ʼɛ́ bwâm, mbɛ́-ʼɛ á mbwɔg nyéētɔgneʼaá mɛ.’ ");
INSERT INTO bssNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Hɛ̂ dɔ́ɔ bɛ́kwɛntɛ́nné mɔ́ bán, ‘A-Sáŋ, póndé ehéé sénnyīnnē nɛ́ɛ nzaa, kéʼɛ píd ékóbé wɛ, kéʼɛ nɛ́ɛ édíí nken, kéʼɛ áde wéēwóoʼɛ́ chǒm éche éwáaʼɛ́, kéʼɛ ádě ékonlɛɛ́, kéʼɛ édíí á mbwɔg boŋ séewôŋgɛne wɛ?’ ");
INSERT INTO bssNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Hɛ́ɛ ene kə̂ŋ étimtanné bɔ́ aá, ‘Ne mbále, nlâŋge nyé mɛɛ́, póndé ké ehéé echě nyênkênwóŋgɛ́nné ábɛ́n bad ké ahéé awě eebéde etógnɛ́n, mɛ-ɛɛ́ nyénkênwóŋgɛ́nné.’ ");
INSERT INTO bssNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ábɛ́n bɔ́-aá bɛ́kɛ̌ âkud nkɔ́gsɛn ḿme méemaáʼ. Bad ábe bésáá-ʼɛ bɛ́kɛ̌ á aloŋgé ádě déemaáʼ.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Áde Yesuɛ ámáá ḿmê mam mésyə̄ə̄l ayə́ged, dɔ́ɔ álâŋgɛɛ́ ábē bembapɛɛ aá, ");
INSERT INTO bssNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nyêbíí nɛ́n bán, ámbīd e eʼpun éʼbɛ Ngande e Nnyíme-ámīn ěbɛ̄. Échê epun dɔ́ɔ bɛ́bɛɛ́ Mwǎn-a-Moonyoŋ á mekáá mé bad ábe bɛ́bomé mɔ́ á awɔg.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Beprisɛ bémbáá ne bad bémbáá bé dyad bêmbǒm á ndáb wɛ́ɛ Kaifasɛ, prisɛ ambáámbáa. ");
INSERT INTO bssNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Áhed dɔ́ɔ bébɛ́léʼáá ntíi âkób Yesuɛ á mesɔɔm-tê, âwúu mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Boŋ bénhɔ̄b bán, “Deébɛ̄lē nɛ̂ á mbwɛ ń ngande, áyə̄le nɛ́n bad bɛ́pɛɛ́n epuutéd.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesuɛ ambɛ́ á Bɛtani á ndáb wɛ́ɛ Simɔnɛ awě akɛ́kolé nkole mé meləŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Áde ádyágkɛ̄ ndyééd nɛ̂, dɔ́ɔ mmwaád nhɔ́g ápédé áwē ne apom á dyɔ̌g dé elod é bwâm áde dênlɛ̌l nkun, ásyɔg mɔ́ dɔ́ á nló. ");
INSERT INTO bssNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nɛ́ɛ ábē bembapɛɛ bényíné nɛ̂, bénlǐŋ, bésɛdté-ʼɛ bánken, “Cheé ékə́ə́ boŋ anɛ́n mmwaád ábēbtē, enɛ́n nyaa e dyɔ̌g? ");
INSERT INTO bssNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Béhɛ́léʼáá se bésóm ádɛ́n dyɔ̌g nkun mbáá, béwóŋgɛ́n betóótōkɛ̄ bé bad.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesuɛ ambíí mam ḿme ábê bembapɛɛ béhɔ́béʼáá. Né-ɔɔ́ anláá bɔ́ aá, “Cheé nyétagtɛɛ́ anɛ́n mmwaád? Dyam ádě ábɛ́nlé mɛ átómtɛ́né aboŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Betóótōkɛ̄ bé bad bɛ́bē ne nyé póndé ésyə̄ə̄l, boŋ mɛ pɛn méebáá ne nyé póndé ésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Asyɔgé mɛ ádɛ́n dyɔ̌g á nló âboŋsɛn mɛ áyə̄le nlíme ḿmêm. ");
INSERT INTO bssNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ne mbále, nlâŋge nyé nɛ́n mɛɛ́ kéhéé ádě ḿmɛ́n nkalaŋ ḿ bwâm mɛ́kanlédté nkǒŋsé áte ńsyə̄ə̄l, bɛ́hɔ̄b dyam ádě anɛ́n mmwaád ábɛ́lé, âkamtɛn mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ámbīd e nɛ̂, mbapɛɛ nhɔ́g átîntê e dyôm ne bébɛ ábe Yesuɛ, awě béchə́géʼáá bán, Judas Iskariɔdɛ ankɛ̌ beprisɛ bémbáá atán. ");
INSERT INTO bssNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Hɛ́ɛ ásɛdtɛɛ́ bɔ́ aá, “Cheé nyɛ́bɛɛ́ mɛ nzé mbagé Yesuɛ áwɛn mekáá âbɛl nyékób mɔ́?” Dɔ́ɔ bétóó móom mé kábpe méláán boŋ bébagé mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Bootya ene póndé dɔ́ɔ ábóótédé nzii ahɛd âsóm mɔ́ áwāb. ");
INSERT INTO bssNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bɔɔb-pɔɔ́, póndé e Ngande e Ewɛle-é-Ngɛ̂n empɛ̌. Á epun éʼsō é ngande, bembapɛɛ ábē Yesuɛ béntān mɔ́, bésɛdté mɔ́ bánken, “Héé wɛ́dəŋgé wɛɛ́ séboŋsɛn wɛ ndyééd e Nnyíme-ámīn?” ");
INSERT INTO bssNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Dɔ́ɔ Yesuɛ álómɛɛ́ bɔ́ á dyad-tê wɛ́ɛ mod nhɔ́g aá, béláa mɔ́ bán meléede ahɔ́bé nɛ́n aá, “Echem póndé emaá apɛ. Áwôŋ ndáb dɔ́ɔ syáābe ábêm bembapɛɛ sɛ́dyɛ̄ɛ̄ ndyééd e ngande e Nnyíme-ámīn.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Né-ɔɔ́ bembapɛɛ bêmbɛ̌l ngáne Yesuɛ ánlāāʼɛ́ bɔ́, bêmboŋsɛ́n-nɛ ndyééd e Ngande e Nnyíme-ámīn. ");
INSERT INTO bssNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ene ngukɛ́l Yesuɛ ne ábē bembapɛɛ bêndyɛɛ́ ásē, bédyāg ene ndyééd. ");
INSERT INTO bssNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Á ndyééd mîn wɛ̂, dɔ́ɔ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Ne mbále, nlâŋge nyé nɛ́n mɛɛ́ nyé mod nhɔ́g ǎbɛ̌ mɛ á mekáá mé bad bé ekɔyí.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nɛ́n dénwōgēd bembapɛɛ ndutul bwâmbwam. Bêmbootéd mɔ́ asɛded nhɔ́g ámbīd aníníí, bán, “A-Sáŋ, ndúbpé mɛɛ́ saké mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Dɔ́ɔ Yesuɛ átimtanné bɔ́ aá, “Mod awě súmɔ̄ sɛ́ɛ̄tɔdé ewɛle á dǐsɛ-tê atɔde ahɔ́g mɔ́ɔ̄sōm mɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwǎn-a-Moonyoŋ ǎwɛ̄ ngáne éténlédé, boŋ medim ne ane mod awě ǎsōm mɔ́. Ébágéʼáá bwâm ne ane mod nzé bénkêntɔgɛn mɔ́ achyáa.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Hɛ́ɛ Judasɛ awě ankwɛntɛ́n Yesuɛ asóm ásɛdtɛɛ́ mɔ́ aá, “A-meléed, mɛ-yɛ?” Hɛ́ɛ Yesuɛ átimtanné mɔ́ aá, “Ngáne éhɔ́bé.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Áde bédyákē ndyééd nɛ̂, dɔ́ɔ Yesuɛ átédé ewɛle, ásāgnān Dyǒb, boŋ ákabtáád áte, ábagé ábē bembapɛɛ áhɔ̄bē nɛ́n aá, “Nyékob, nyédyɛ̂, echem yə̌l nɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ámbīd e nɛ̂, antéd mbwendé ḿ mǐm, ásāgnān Dyǒb, ábagé bɔ́, boŋ áhɔ̄bē nɛ́n aá, “Nyé moosyəə́l nyémwɛ̂. ");
INSERT INTO bssNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ḿmêm mekií mɔ̂mɛ́n. Ḿmɛ́n mekií médíi melɛ̌ mékɔ̄ɔ̄lē. Ḿmɛ́n mekií mésyɔ́gké á nló ḿ bad híin, âbɛl nɛ́n Dyǒb álagsɛn bɔ́ mbéb. ");
INSERT INTO bssNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nlâŋge nyé nɛ́n mɛɛ́, méemwáá ḿmɛ́n mǐm ámpē kə́ə́ŋ ne epun éche mɛ́mwɛ̄ɛ̄ mɔ́ ekɔ́ɔ́lé ne nyé á nkamlɛn ḿmē echem Sáŋ.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Bénkɔ̄n nkə́ŋgé mé nságnɛn. Nɛ́ɛ bémáá akɔ́n, bênkɛ̌ á Ekone é menzab. ");
INSERT INTO bssNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Áde bépédé á ekone mîn, dɔ́ɔ Yesuɛ álâŋgɛɛ́ ábē bembapɛɛ aá, “Nkuu nɛ́n děn, nyé baásyə̄ə̄l nyɛ́ɛ̄nyəgéd, nyétɛ̄dē mɛ. Nyɛ́ɛ̄nyəgéd, áyə̄le dyam áde dɛ́bɛnléd ne mɛ. Éténlédé nɛ́n bán, ‘Mɛ̌wūū nnɔn-a-mbód, éche mbód ésyə̄ə̄l épáŋtéd áte. ");
INSERT INTO bssNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Boŋ ádě echem Sáŋ ápuúdté mɛ, mɛ̌kɛ̌ áʼsō á Galilia, áwed-taá nyɛ́tānnē mɛ.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Áde Yesuɛ ámáá ahɔ́b nɛ̂, dɔ́ɔ Petro áhɔ́bɛɛ́ aá, “Ké moosyəə́l ambáŋ wɛ áyə̄l, mɛ pɛn méetɛdɛ́ɛ́ wɛ mbêd.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Dɔ́ɔ Yesuɛ átimtanné mɔ́ aá, “A-Petro, ńláa wɛ mɛɛ́, nchóm-a-kúb adɛ̂hɔ́b aá mɔ́tōoʼ nkuu nɛ́n, wɛ̌bāŋ mɛ áyə̄l ngen éláán.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Dɔ́ɔ Petro ábádtɛɛ́ mɔ́ áte aá, “Ké nkə́ŋ mɔ́ɔ bésɛ̄lɛ̄ɛ̄ mɛ, méebáŋgé wɛ áyə̄l mbêd.” Ábíníí bembapɛɛ bésyə̄ə̄l bɔ́mpē bénhɔ̄b melemlem. ");
INSERT INTO bssNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ámbīd e nɛ̂, Yesuɛ ne ábē bembapɛɛ bênkɛ̌ á abwɔ́g á hǒm áde béchə́géʼáá bán Getsɛmani. Áde bépédé, Yesuɛ anláá bɔ́ aá bédyɛɛ áhed, aá mɔ́-ʼɛ mɔ́sīdteʼ áʼsō, âkáne. ");
INSERT INTO bssNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Áde ákagké, ankɛɛ́n Petro ne bǎn ábe Zɛbɛdiɛ bébɛ. Ndəŋge ne metake híin bébédé mɔ́ á nlém-tê. ");
INSERT INTO bssNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Dɔ́ɔ álâŋgɛɛ́ bɔ́ aá, “Ndəŋge echě edé mɛ á nlém ehɛle-sɛ ewúú mɛ. Nyélyəg hɛ́n, nyédyɛɛn mɛ epin.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Dɔ́ɔ Yesuɛ ásídté áʼsō ámpē boŋ ábwēmē yə̌l ásē. Ankúdɛ́n ásē, ákānnē aá, “A-Tɛ̂, nzé ébóŋnédé wɛ, ékóbɛ́n mɛ ḿmɛ́n metuné. Boŋ ké nɛ̂, bɛ̌l ngáne ébóŋnédé wɛ, saké ngáne ébóŋnédé mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Áde ámáá akáne, antǐm ámbīd wɛ́ɛ ábê bembapɛɛ béláán. Antán nɛ́ɛ békúnɛɛ́, boŋ álāŋgē Petro aá, “Cheé ékə́ə́ boŋ nyéēhɛle awɛsɛn âdyɛɛn mɛ epin ké háwa pɔ́g? ");
INSERT INTO bssNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nyédyɛɛ epin, nyékânne âbɛl nɛ́n Dyǒb déemwǎg-sɛ mekəgsɛn mépiinéd nyé. Nlém ńdə́ə́, boŋ ekob é yə̌l édé mbwɔ́g.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesuɛ ankɛ akáne ámpē, áhɔ̄bē nɛ́n, aá, “A-Tɛ̂, nzé édé nɛ́n bán, weéhɛ̄lɛ̄ɛ̄-sɛ ékōbɛ̄n mɛ ḿmɛ́n nted mé metuné, ésebán mpémé mɔ́, ébɛl ngáne ébóŋnédé wɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nɛ́ɛ átímé ámbīd ámpē, antán nɛ́ɛ ábê bembapɛɛ bédíi békúnɛɛ́ áyə̄le eʼchə́ bémbɛ̄ bɔ́ á dǐd bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesuɛ antǐm ámbīd á mekáne ámpē ngen éche élóntɛ́ne éláán, áhɔ̄bē melemlem mé eʼyale. ");
INSERT INTO bssNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Hɛ̂ dɔ́ɔ Yesuɛ átímé ámbīd ámpē wɛ́ɛ ábê bembapɛɛ, boŋ álāŋgē bɔ́ aá, “Nyêlyəgé nyêkúneʼ, nyêkɔ́mme-ʼɛ nyé áte-yɛ? Nyénɔneʼ, póndé-ʼaá epedé nɛ́n eche bɛ́bɛɛ́ Mwǎn-a-Moonyoŋ á mekáá mé bad bé mbéb. ");
INSERT INTO bssNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nyépáde ásē dékag. Nyénɔneʼ, mod awě akií mɛ ntúrɛ́ mɔ́ ahúɛʼ nɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ehɔ́b éepedɛɛ́ Yesuɛ amaa á nsəl boŋ Judasɛ ápag. Judasɛ, mbapɛɛ nhɔ́g átîntê e bembapɛɛ dyôm-ne-bébɛ ábe Yesuɛ, ampɛ̌ ne amute ádě dénwālē nkwáté ne mbid. Beprisɛ bémbáá ne bad bémbáá bé Israɛl bɔ́ɔ bénlōm ábê bad. ");
INSERT INTO bssNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ntúrɛ́ awě Yesuɛ amad bɔ́ eʼchemléd abɛ aá, “Kénzɛ́ɛ́ awě mɛ́hɛ̄ɛ̄ tə̂l, né mod awě nyéhɛdɛɛ́ mɔ̂ne, nyékôb mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nɛ́ɛ Judasɛ ápédé pɛɛ́n, atóm-mɛ wɛ́ɛ Yesuɛ, álɛ̄lēd mɔ́ aá, “A-meléed, nsaŋ ḿbɛ̂ ne wɛ.” Ahɛ́-ʼɛ mɔ́ tə̂l. ");
INSERT INTO bssNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesuɛ antimtɛ́n mɔ́ aá, “Amúɛ̄, wéebɛlɛ́ɛ́ chǒm éche éhyédé abɛl-ɛ?” Hɛ̂ dɔ́ɔ ábê bad bésídté áʼsō, boŋ békōbēʼ Yesuɛ, béwéd-tɛ mɔ́ achə́ə. ");
INSERT INTO bssNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Hɛ̂ dɔ́ɔ mod nhɔ́g átîntê e bad ábe bémbɛ̄ ne Yesuɛ ádólé nkwáté á abám, nɛ́ɛ átómté mɔ́ boŋ asɛ́l-lɛ ntâŋ awě prisɛ ambáámbáa etúu. ");
INSERT INTO bssNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ ane mod aá, “Timéd ḿmoŋ nkwáté á abám. Kénzɛ́ɛ́ awě awanne nkwáté, nkwáté mɔ́ɔ bɛ́wūɛ̄nnē mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Weebíiʼɛ́ nɛ́n wɛɛ́ nzé nhɛ̌dné echem Sáŋ nwôŋgɛn, wɛɛ́ né ábwɔ̄g-ábwɔ̄g, ǎlōmē mɛ eʼchoŋ ne eʼchoŋ é ángɛl âwóŋgɛn mɛ-yɛ? ");
INSERT INTO bssNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Boŋ nzé mbɛlé nɛ̂, né chán-nɔ̄ kálag e Dyǒb echě ehɔ́bé nɛ́n aá, nɛ́n átə́ŋgɛ́né abɛnled élōnnē?” ");
INSERT INTO bssNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ ádê amute aá, “Nchîb mɔ́ɔ ńdíí awě nyéhyédé akób ne mbid ne nkwáté-yɛ? Epun tɛ́ɛ́ mbédé á Ndáb-e-Dyǒb, ń'yə̄gtē bad, boŋ nyéekóbe mɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Boŋ ḿmɛ́n mésyə̄ə̄l mébɛ́nlédé âlóned mam ḿme bekal béʼdəə́dəŋ bétélé á kálag e Dyǒb.” Hɛ̂ dɔ́ɔ bembapɛɛ bésyə̄ə̄l bétɛ́dté mɔ́, boŋ bétómé mehélé. ");
INSERT INTO bssNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Hɛ̂ dɔ́ɔ bad ábe bénkōb Yesuɛ békɛ́ɛ́né mɔ́ á ndáb wɛ́ɛ Kaifasɛ awě ambɛ́ Prisɛ Ambáámbáa. Áhed dɔ́ɔ bemeléede bé mbéndé ne bad bémbáá bé Israɛl bémpēe bênladɛ́nné áte. ");
INSERT INTO bssNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Áde békɛɛnɛɛ́ Yesuɛ nɛ̂, Petro ahídéʼáá mɔ́ ámbīd mwǎ etûn kə́ə́ŋ bépɛ nchiitɛn ne eyáde éche Kaifasɛ. Nɛ́ɛ ápédé áhed ansɔ́l á eyáde-tê, ádyɛ̄ ásē ne benɔn bé Ndáb-e-Dyǒb, âbɛl nɛ́n ányîn ngáne nkáásé ḿme Yesuɛ mɛ́sōgkē. ");
INSERT INTO bssNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bɔɔb-pɔɔ́, beprisɛ bémbáá ne bad bé káánsɛl bésyə̄ə̄l béhɛ́déʼáá bad ábe bɛ́bīd mbóŋ é metóm á nló wɛ́ɛ Yesuɛ âbɛl nɛ́n béwúu mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ké nɛ̂ŋgáne ekud é bad ênhyɛ̌ mbóŋ é metóm abíd áwe nló, bénkênkóbɛ́nné mɔ́ awusé ké ahɔ́g. Kə́ə́ŋ ne á asóg, dɔ́ɔ mbóŋ ébɛ ébídé, éhɔ̄bē nɛ́n bán, ");
INSERT INTO bssNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Anɛ́n mod anhɔ́b aá, mɔ́hɛle mɔ́bōōtēd Ndáb-e-Dyǒb aá mɔ́lōŋ-ʼɛ chɔ́ ámbīd ámpē átîntê e eʼpun éʼláán.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Áde Prisɛ Ambáámbáa éwógé nɛ̂, dɔ́ɔ átyéémé ámīn boŋ ásɛdté Yesuɛ aáken, “Weewóoʼɛ́ dyamdyam âhɔ́b tə̂ŋgɛne dyam ádě ábén bad béhɔ́bé wɛ á yə̌l-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Boŋ Yesuɛ enkênkədɛ́nné mɔ́. Hɛ̂ dɔ́ɔ Prisɛ Ambáámbáa álâŋgɛɛ́ mɔ́ ámpē aá, “Ne melɛ̌ á dǐn á Dyǒb áde ádé á aloŋgé, láá sé mbále, wɛ-ɛɛ́ edé Ane-awě-Béwɔ́gté, Mwǎn a Dyǒb-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Hɛ̂ dɔ́ɔ Yesuɛ ákwɛntanné mɔ́ aá, “Ngáne éhɔ́bé.” Yesuɛ ambád-tɛ ámpē aá, “Á mbále, nlâŋge nyé nɛ́n mɛɛ́ bootya enɛ́n póndé, nyɛ́ɛ̄nyīn nɛ́ɛ Mwǎn-a-Moonyoŋ ádyɛ́ɛ́ á ekáá émbáá é Dyǒb a Ngum. Nyɛ́ɛ̄nyīn-nɛ nɛ́ɛ ádyɛ́ɛ́ á mbag mîn, ásudɛɛ́ á nkǒŋsé.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Dɔ́ɔ Prisɛ Ambáámbáa ányábé mbɔ́té âlúmed nɛ́n aá mɔ́lií, boŋ álāŋgē bad bé kóte aá, “Asyə́ə́ Dyǒb! Mbóŋ éhéé émpēe déhɛdɛɛ́? Nyé baásyə̄ə̄l nyêwógé bɔɔb ngáne ásyə́ə́ Dyǒb!” ");
INSERT INTO bssNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Dɔ́ɔ ásɛdtɛɛ́ bɔ́ aáken, “Chán nyéwémtɛ́né?” Hɛ́ɛ békwɛ́ntɛ́né bán, “Akwedé nkáá, atə́ŋgɛ́né-ʼɛ awɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Dɔ́ɔ doŋge á bad bébóótédé mɔ́ meléed asobted áʼsō, bébɔmé-ʼɛ mɔ́. Ábíníí-ʼɛ bébɔmé mɔ́ mebɛ́n, ");
INSERT INTO bssNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","béhɔ́bé-ʼɛ bán, “Á-mod awě ahɔ́bé aá mɔ́ɔ mɔ́dē Krǐstəə, láá-ʼɛ sé mod awě abɔmé wɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ene póndé Petro andyɛɛ́ ásē á eyáde é kóte-tê. Hɛ̂ dɔ́ɔ ngɔndérɛ e mbəledɛ pɔ́g épédé áwē, boŋ éhɔ̄bē aá, “Wɛ nɛ́n, edé nhɔ́g awě awǒŋnéʼáá Yesuɛ, ane mod awě abídé á mbwɔ́g e Galilia.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Boŋ Petro antáŋ áʼsō wɛ́ɛ ábê bad bésyə̄ə̄l, ákwɛntɛ́n aá, “Meebíiʼɛ́ dyam áde éhɔ́bɛɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Áde ámáá ahɔ́b nɛ̂, antǐm á mmwɛ mé eyáde é kóte. Áhed dɔ́ɔ mbəledɛ a ngɔndérɛ ampée ányíné mɔ́, boŋ álāŋgē bad ábe bébédé áhed aá, “Anɛ́n mod abédé ne Yesuɛ, mod a dyad á Nazarɛt.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Boŋ Petro antáŋ ámpē, áhɔ̄bē nɛ́n aá, “Mmwâg melɛ̌ nɛ́n mɛɛ́ meebíiʼɛ́ mɛ ane mod.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Éebemɛɛ́ áte, bad ábe béntyēēm áhed bêmpɛ̌ wɛ́ɛ Petro, boŋ béhɔ̄bē nɛ́n bán, “Etáa ngɛ̂n, edé nhɔ́g awě ahídéʼáá ane mod. Mbwɛ́d e ehɔ́b echôŋ epanle wɛ áte, nɛ́n ebídé á mbwɔ́g e Galilia.” ");
INSERT INTO bssNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Dɔ́ɔ Petro ámwākē melɛ̌ aá, “Dyǒb ákɔ́gsɛn mɛ nzé nkale metóm! Meebíiʼɛ́ ane mod!” Áde ámáá ahɔ́b nɛ̂ hɔ́bɛ́n, nchóm-a-kúb antóŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Dɔ́ɔ Petro ákámtɛ́né ehɔ́b éche Yesuɛ ánlāāʼɛ́ mɔ́ aá, “Nchóm-a-kúb adɛ̂hɔ́b aá mɔ́tōoʼ, wɛ̌bāŋ mɛ áyə̄l ngen éláán.” Dɔ́ɔ Petro ábídé á ebwɔ́g-te, boŋ ábə̄nlē awé. Anchií bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nɛ́ɛ bǐn éʼsáŋgé sáŋgɛ́n, beprisɛ bémbáá ne bad bémbáá bé Israɛl bésyə̄ə̄l bêmbootéd Yesuɛ ahəge ngáne bɛ́wūūʼɛ́ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bênhaŋ mɔ́, bébāg-kɛ mɔ́ á mekáá wɛ́ɛ Payledɛ awě kə̂ŋ e aloŋ á Roma êmbanɛ́ɛ́ aá ákamlan bad bé mbwɔ́g e Judeya á póndé eched. ");
INSERT INTO bssNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Áde Judasɛ, ntúrɛ́ awě Yesuɛ ányíné nɛ́n aá kóte ebagé mbakú nɛ́n bán béwúu Yesuɛ, ambɛ́ ngɔl ne awusé áde ábɛ́lé. Nɛ̂ dênkə̌ŋ, antéd móom mé kábpe méláán ḿme beprisɛ bémbáá ne bad bémbáá bé Israɛl bêmbɛɛ́ mɔ́, ákɛ átimtéd bɔ́ ámbīd. ");
INSERT INTO bssNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Anhɔ́b aá, “Mbɛlé mbéb âkɛ mod ntúrɛ́ awě eébɛle dyamdyam, awě bɛ́wūū-ʼaá bɔɔb ngɛ̂n.” Dɔ́ɔ bétimtanné mɔ́ bán, “Cheé séwóó abɛl ne nɛ̂? Nɛ̂ ánɔne wɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nɛ́ɛ Judasɛ áwógé nɛ̂, ambwémé bɔ́ ḿmê móom mé kábpe méláán ásē wɛ́ɛ bémbɛ̄ɛ̄ á Ndáb-e-Dyǒb. Nɛ́ɛ ámáá abwém, ambíd ákɛ ápan yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Beprisɛ bémbáá bênlǎd ḿmê mɔné áte, béhɔ̄bē nɛ́n bán, “Ḿmɛ́n mɔné ńdíi mɔné mé ebɛn. Né-ɔɔ́, mbéndé eébagɛɛ́ kunze nɛ́n bán déladtɛn ḿmɛ́n mɔné ne mɔné ń Ndáb-e-Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Áde bémáá ahəgtɛn tə̂ŋgɛne ḿmê mɔné, béntēd mɔ́, béchānɛ̄n etúú éche ébédé etúú é mod nhɔ́g awě atuméʼáá mbeé. Bênchan chɔ́, âlíme beken. ");
INSERT INTO bssNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nɛ̂ dɔ́ɔ ákə́ə́ boŋ kə́ə́ŋ neʼ chii, béchəgé échê etúú bán, Etúú é Mekií. ");
INSERT INTO bssNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nɛ́n, dêmbɛnléd âlóned eʼyale ábe nkal éʼdəə́dəŋ Jeremayaa ánhɔ̄bpē aá, “Bɛ́tēd móom mé kábpe méláán ḿme ńdé nsoŋgé ḿ mɔné ḿme doŋge á bad bé Israɛl bênkwɛntɛ́nné asábe áwe nló, ");
INSERT INTO bssNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","bébɛ̄nlēd âchanɛn etúú éche ntumé-mbeé. Nɛ́n dɔ́ɔ Dyǒb dénlāāʼɛ́ mɛ aá, ḿbɛl.” ");
INSERT INTO bssNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Enɛ́n póndé-ɔɔ́ Yesuɛ antyéém á nkáásé áʼsō wɛ́ɛ Payledɛ awě akǎmlánnáá mbwɔ́g e Juda. Payledɛ ansɛdéd mɔ́ aá, “Wɛ́ɛ edé kə̂ŋ e bad bé Israɛl-ɛ?” Yesuɛ antimtɛ́n mɔ́ aá, “Ngáne éhɔ́bé.” ");
INSERT INTO bssNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Boŋ áde beprisɛ bémbáá ne bad bémbáá bé Israɛl bénhɔ̄bpē mɔ́ mam áyə̄l, enkênhɔ́bpé dyamdyam. ");
INSERT INTO bssNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Né-ɔɔ́ Payledɛ ansɛdéd mɔ́ aáken, “Weewógɛ́ɛ́ ḿmɛ́n mam mésyə̄ə̄l ḿme ábɛ́n bad béhɔ́bɛɛ́ wɛ áyə̄l-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Boŋ ké nɛ̂, Yesuɛ enkênhɔ́bpé ké eyale, nɛ̂-ʼɛ dénkɔ̄mēd Payledɛ yə̌l áte bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bɔɔb-pɔɔ́, mwɛ̌ tɛ́ɛ́ nzé Ngande e Nnyíme-ámīn empɛ̌, Payledɛ ammɛntɛ́n mod a mbwɔg nhɔ́g abíded á mbwɔg. Ane mod abágéʼáá mod ké ahéé awě bad bé dyad bêmpwɛdté. ");
INSERT INTO bssNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ene póndé mod a mbwɔg nhɔ́g ambɛ́ awě béchə́géʼáá bán Barabasɛ. Ane mod ambyɛ́ɛ́n bwâmbwam áyə̄le eʼbébtéd éʼ mekan ábe ábɛ́léʼáá. ");
INSERT INTO bssNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Né-ɔɔ́ áde ndun e mod éládné áte á ndáb wɛ́ɛ Payledɛ, ansɛdéd bɔ́ aá, “Nzɛ́-módɛ́ nyéhɛdɛɛ́ bán ḿbíded, Barabasɛ kéʼɛ Yesuɛ awě béchəgɛɛ́ bán Krǐstəə?” ");
INSERT INTO bssNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ambɛl nɛ́n áyə̄le ambíi bwâm aá prisɛ ambáá ne baámbáá bébágé Yesuɛ áwe mekáá áyə̄le kɔ́njí embɛ́ bɔ́ áte. ");
INSERT INTO bssNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Áde Payledɛ ádyɛ́ɛ́ á atii wɛ́ɛ ákáádtéʼáá bad, mwaád anlómé mɔ́ nsəl aá, “Weewóó dyamdyam âbɛl ne mbakú eche ane mod awě eébɛle dyamdyam, áyə̄le nnǎŋgé mɔ́ nló nkuu ḿme ńtómé nɛ́n ḿme ńtágté mɛ bwâmbwam.” ");
INSERT INTO bssNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Beprisɛ bémbáá ne bad bémbáá bé Israɛl bénsɔ̄l ábê bad áte nɛ́n bán béláa Payledɛ ábíded dásɔ̄ Barabasɛ boŋ ábɛ mbakú nɛ́n béwúu Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Né-ɔɔ́, áde Payledɛ ásɛ́dté ábê bad aá, “Áyə̄le ábén bad bébɛ, ahéé nyéhɛdɛɛ́ bán, ḿbíded?” Bɔ́ moosyəə́l bênkwɛntɛ́n bán, “Barabasɛ!” ");
INSERT INTO bssNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Dɔ́ɔ Payledɛ ásɛdtɛɛ́ bɔ́ ámpē aá, “Chán-nɔ̄ nyéhɛdɛɛ́ bɔɔb bán ḿbɛl ne Yesuɛ awě béchəgɛɛ́ bán Krǐstəə?” Dɔ́ɔ békwɛntanné bán, “Bébome mɔ́ á awɔg!” ");
INSERT INTO bssNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Hɛ́ɛ Payledɛ ásɛdtɛɛ́ bɔ́ ámpē aá, “Áyə̄le chán? Ebébtéd éhéé ábɛ́lé?” Boŋ bênnabé abón bán, “Bomé mɔ́ á awɔg.” ");
INSERT INTO bssNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Áde Payledɛ ányíné aá mɔ́ɔ̄hɛ̄lɛ̄ɛ̄ se mɔ́həŋlɛ́n ábê bad mewêmtɛn tə̂ŋgɛne mbakú eche Yesuɛ, âbáŋ nɛ́n aá, ábê bad béepɛɛneʼ mpuutéd, dɔ́ɔ átédé mendíb boŋ áwobpé mekáá áwab eʼsó, áhɔ̄bē-ʼɛ aá, “Mekáá mésáá mɛ áyə̄le kwééd eche anɛ́n mod. Nɛ̂ ánɔne nyé běn.” ");
INSERT INTO bssNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Hɛ́ɛ ene ndun e mod ékwɛntanné bán, “Sêkwɛ̌ntɛ́né. Ḿmē mekií mébɛ̂ áwɛd nló, nchoo ne ḿmɛ̄d nchyáátɛ́n!” ");
INSERT INTO bssNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Né-ɔɔ́, Payledɛ ambídtéd bɔ́ Barabasɛ. Ambɛ̌ kunze aá, sə́nze ébɔm Yesuɛ, boŋ békɛ bébome-ʼɛ mɔ́ á awɔg. ");
INSERT INTO bssNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Sə́nze éche Payledɛ éntēd Yesuɛ, ékɛ̄ɛ̄n mɔ́ á eyáde é nkamlɛnɛ, bélād-tɛ baáb ábíníí bésyə̄ə̄l áte áhed. ");
INSERT INTO bssNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bénhūd mɔ́ mbɔ́té áyə̄l, béhɛ́ mɔ́ mengombe ḿme ń'yəgeʼ ḿme ńwágné mengombe mé kə̂ŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Béntēd ngɛn é mechə̌, bélóó mɔ́ ekóté éche émbɛ̄ nɛ́ɛ ekóté é kə̂ŋ, béhɛ́ mɔ́ chɔ́ á nló. Bénhɛ̄ mɔ́ ntóŋ á ekáá é mbáá te, bébwɔ̄gkē-ʼɛ mɔ́ mebóbóŋ âwɛl mɔ́. Béhɔ́béʼáá nɛ́n bán, “Edúbé ébɛ̂ ne wɛ, a-kə̂ŋ e bad bé Israɛl!” ");
INSERT INTO bssNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Dɔ́ɔ bébóótédé mɔ́ meléed asob á yə̌l, boŋ bétēdē ḿmê ntóŋ, bébɔmé mɔ́ á nló. ");
INSERT INTO bssNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Áde bémáá mɔ́ awɛl, bénhūd mɔ́ ḿmê mengombe á yə̌l, bétīmēd éche mbɔ́té. Nɛ́ɛ bémádé nɛ̂, bénkɛɛ́n mɔ́ âkɛ dé ábome mɔ́ á awɔg. ");
INSERT INTO bssNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Áde békagké nɛ̂, nɛ́ɛ échê sə́nze ébīdēnnē Yesuɛ á dyad-tê, dɔ́ɔ bébómné mod awě ambíd á dyad á Sirinɛ awě béchə́géʼáá bán Simɔnɛ. Hɛ́ɛ békóbé mɔ́, boŋ bépēmtē mɔ́ awɔg áde Yesuɛ bán áhídne mɔ́ dɔ́ ámbīd. ");
INSERT INTO bssNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Dɔ́ɔ bépédé hǒm áde béchə́géʼáá bán, Golgota, awě adé nɛ́n bán, “Hǒm dé Ebóŋgɛ́l é Nló.” ");
INSERT INTO bssNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Áhed, bêmbɛ̌ Yesuɛ mǐm ḿmē béhédé achəchəə áte. Boŋ ádě áwóglɛ́né mɔ́ á nsəl, enkênkwɛntɛ́nné amwɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Áde bémáá mɔ́ abome á awɔg bênsǐd mbambú âkab éche mbɔ́té. ");
INSERT INTO bssNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nɛ́ɛ bémáá mɔ́ mbɔ́té akab, béndyɛɛ́ áhed ânɔn mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Bêntěl echě nzɔm e kwééd á abámbé nɛ́n bán, “Yesuɛ mɔ́ɔ nɛ́n, kə̂ŋ e bad bé Israɛl.” Béntēd ádé abámbé, bébōmē áwe nló-mîn. ");
INSERT INTO bssNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bêmbomé bechîb bébɛ á awɔg nchoo ne Yesuɛ, nhɔ́g á pɛd e ekáá émbáá, aníníí-ʼɛ á pɛd e ekáá é emwɛd. ");
INSERT INTO bssNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bad ábe bétóméʼáá nzii bɛnbɛn ne áhed bébɔ́méʼáá nló bébwēmmē-ʼɛ mɔ́ nzyə́ŋ ");
INSERT INTO bssNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","bán, “Wenhɔ́b wɛɛ́ mɔ́ɔ̄bōōtēd Ndáb-e-Dyǒb, wɛɛ́ mɔ́lōŋ-ʼɛ chɔ́ ámpē átîntê e eʼpun éʼláán. Nzé wɛ-ɛɛ́ edé Mwǎn a Dyǒb, sǒŋ echoŋ yə̌l, ésud ásē á awɔg hɛ̂.” ");
INSERT INTO bssNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Beprisɛ bémbáá, bemeléede bé mbéndé ne bad bémbáá bé Israɛl bɔ́mpē béwɛ́léʼáá mɔ́, béhɔ̄bē bán, ");
INSERT INTO bssNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Achǒŋtéʼáá bad, bɔɔb eéhɛlɛɛ́ yə̌l awôŋgɛn. Nzé ne mbále mɔ̂dé kə̂ŋ e aloŋ á Israɛl, ásud-tɔɔ́ á awɔg hɛ̂ bɔɔb. Hɛ̂ dɔ́ɔ sɛ́dūbɛ̄ɛ̄ bán mɔ̂dé Ane-awě-Béwɔ́gté. ");
INSERT INTO bssNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Adúbpé aá Dyǒb ádé ne mɔ́, aá mɔ́dē-ʼɛ Mwǎn a Dyǒb. Ahâ! Dyǒb áwôŋgɛn-nɔɔ́ mɔ́ bɔɔb dényîn.” ");
INSERT INTO bssNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kə́ə́ŋ ne bechîb ábe bêmbomɛ́ɛ́ á awɔg nchoo ne Yesuɛ bɔ́mpē bésyə́ə́ʼáá Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Áde bǐn éʼpédé kəd, ehíntɛ́n ênkwɛ̌ hǒm ásyə̄ə̄l kə́ə́ŋ ne ngə́ŋ éláán. ");
INSERT INTO bssNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Dɔ́ɔ Yesuɛ álébpé esaád aá, “Elí, Elí, lámá sábátāni,” awě adé nɛ́n bán, “A-Dyǒb ádêm, a-Dyǒb ádêm, cheé ékə́ə́ boŋ étɛdté mɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nɛ́ɛ doŋge á bad ábe bémbɛ̄ bɛnbɛn béwógé nɛ̂, bénhɔ̄b bán, “Achɛ̂nle Elaijaa aá áhyɛ áwôŋgɛn mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ábwɔ̄g-ábwɔ̄g bɔ́ mod nhɔ́g annyəgéd, antéd kuchá, ásɔ̄m á ntóŋ, átɔ̄dē á ebɛ́ntéd é mǐm tê, boŋ áhāg mɔ́ á nsəl aá ámwɛ̂. ");
INSERT INTO bssNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ábíníí-ʼɛ béhɔ̄bē nɛ́n bán, “Nyémwɛ, dényîn nzé Elaijaa ǎhyɛ mɔ́ awôŋgɛn.” ");
INSERT INTO bssNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Hɛ̂ dɔ́ɔ Yesuɛ álébpé esaád ámpē boŋ ámyɛ̌-ʼɛ nlém. ");
INSERT INTO bssNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ene póndé chěn abad ádě dênkǎb Ndáb-e-Dyǒb áte, dênsalé áte eʼpɛd éʼbɛ bootya ámīn kə́ə́ŋ ne ásē. Ndɔɔb ennəŋnéd, meláá mésanlé áte, ");
INSERT INTO bssNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","soŋ énednad. Ekud é bad bé Dyǒb ábe bêmmad awɛ́ bêmpuú, ");
INSERT INTO bssNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","bébíd á soŋ-tê. Ámbīd e póndé áde Yesuɛ ámáá apuu, bênkɛ̌ á dyad tê á Jerusalɛm. Á dyad tê wɛ̂, ekud é bad énnyīn bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nɛ́ɛ mod ambáá a sə́nze ne sə́nze éche énɔ́néʼáá Yesuɛ bényíné nɛ́ɛ ndɔɔb énə́ŋnédé, bényín-nɛ mekan mésyə̄ə̄l ḿme mébɛ́nlédé, mbwɔ́g ménkōb bɔ́ bwâmbwam, béhɔ̄bē-ʼɛ nɛ́n bán, “Ne mbále, anɛ́n mod abédɛ́ɛ Mwǎn a Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ekud é bebaád éche êmbootéd Yesuɛ ahíd ámbīd se á Galilia, béwōŋgān-nɛ mɔ́, béntyēēm etûn, bénɔné mekan mésyə̄ə̄l ḿme mébɛnlad. ");
INSERT INTO bssNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Átîntê e ábê bebaád, Maria Magdalɛnɛ, Maria awě abédé nyaá awě Jemsɛ bɔ́ Josɛb, ne nyaá awě bǎn ábe Zɛbɛdiɛ bémbɛ̄ áhed. ");
INSERT INTO bssNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nɛ́ɛ ngukɛ́l épédé, nhɔn ḿ mod nhɔ́g ḿme béchə́géʼáá bán Josɛbɛ mêmpɛ̌. Ane mod abédɛ́ɛ mod a dyad á Arimatia. Mɔ́mpē abédé nhɔ́g awě ahídé-ʼáá Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ankɛ̌ wɛ́ɛ Payledɛ aá ábɛ mɔ́ kunze âtéd ndim ḿme Yesuɛ. Payledɛ ambɛ̌ kunze nɛ́n aá bébɛ mɔ́ ndim ḿme Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josɛbɛ antéd ndim ḿme Yesuɛ, ákāān mɔ́ mbɔ́m e ekɔ́ɔ́lé, ");
INSERT INTO bssNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","alímé mɔ́ á soŋ eche bépwɔ́gé á eláá-tê. Ene soŋ ebédé-ʼɛ soŋ e ekɔ́ɔ́lé echě Josɛbɛ mwěn ánwōŋgē. Ámbīd e nɛ̂, antínéd aláá ámbáá akɔ́lɛ́n nsəl ń soŋ, ákɛ̄-ʼɛ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdalɛnɛ ne Maria awě anchyáá Jemsɛ bɔ́ Josɛb, bênlyə̌g bédyɛ̄ɛ̄ á nkəg ń soŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nɛ́ɛ bǐn éʼsáŋgé, nɛ̂ démbɛ̄ á Mbwɛ-mé-nkɔ́me-áte, beprisɛ bémbáá ne Befarisia bénladɛ́n, békɛ bényín Payledɛ, ");
INSERT INTO bssNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","bélāŋgē mɔ́ nɛ́n bán, “A-sáŋ, sêkamtan nɛ́n bán ádě nkal a metómɛ ne ábédé ámīn, anhɔ́b aá mɔ́ɔ̄puú ámbīd e eʼpun éʼláán. ");
INSERT INTO bssNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Né-ɔɔ́ tóméd akale nɛ́n, wɛɛ́ bénɔneʼ echě soŋ bwâm, kə́ə́ŋ ne eʼpun éʼláán âbɛl nɛ́n boŋ ábē bembapɛɛ béehɛlé ḿmē ndim achíb se bélāŋgē bad bán apuúdé. Né nɛ́n dɛ́bɛ̄ metóm ḿme ńchábé ámīn tómaa ḿme ásébpé akal.” ");
INSERT INTO bssNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Dɔ́ɔ Payledɛ álâŋgɛɛ́ bɔ́ aá, “Nyétêd sə́nze ânɔn soŋ bwâm, âbɛl nɛ́n dyamdyam déebɛnlád.” ");
INSERT INTO bssNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Hɛ́ɛ békíí, boŋ béhāg eʼchem á aláá ádě démbɛ̄ á nsəl ń soŋ, âbɛl nɛ́n bébíi nzé mod anědté, bétɛ̄dē-ʼɛ sə́nze áhed âbɛl boŋ béēchībēʼ Yesuɛ ndim. ");
INSERT INTO bssNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ámbīd e mbwɛ-mé-nkɔ́me-áte, á epun éʼsō é sɔ̂ndɛ́, epɔg é mbwɛmbwɛ, Maria Magdalɛnɛ ne Maria awě anchyáá Jemsɛ bɔ́ Josɛb, bênkɛ̌ soŋ eche Yesuɛ anɔn. ");
INSERT INTO bssNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Esám-éēkɔ̄mtɛ̄nē, ndɔɔb ennəŋnéd, ángɛl e Dyǒb ebíd ámīn épɛ. Entínéd ádê aláá ádě démbɛ̄ á nsəl ń soŋ, édīī-ʼɛ dɔ́ ámīn. ");
INSERT INTO bssNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Eʼsó éʼpɛ́néʼáá ene ángɛl áte nɛ́ɛ emwɛdmwɛd, mbɔ́té-ʼɛ épūbē mɔ́ féréd. ");
INSERT INTO bssNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mbwɔ́g ménkōb sə́nze éche énɔ́néʼáá ene soŋ. Nɛ̂ dênkə̌ŋ bênnəŋnéd, békwɛ ásē, bébɛ́ nɛ́ɛ ndim ḿ bad. ");
INSERT INTO bssNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Hɛ́ɛ ángɛl élâŋgɛɛ́ ábê bebaád aá, “Nyéebááʼ. Mbíí mɛɛ́ Yesuɛ awě bêmbomɛ́ɛ́ á awɔg mɔ́ɔ nyéhyédé anɔn. ");
INSERT INTO bssNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Eésaá hɛ́n. Apuúdé ngáne ánlāāʼɛ́ nyé aá ébɛnléd. Nyéhyɛ nyénɔn wɛ́ɛ bênnaádté mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nyékag-kɔɔ́ mehélé bɔɔb, nyéláa ábē bembapɛɛ bán, apuúdé, amaá-ʼɛ akɛ áʼsō á Galilia, áwed-taá bɛ́nyīnē mɔ́. Nyéēchatán dyam áde ńláŋgé nyé.” ");
INSERT INTO bssNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Né-ɔɔ́, bênhidnéd mehélé áhed, ké nɛ́ɛ bébédé mbwɔ́g, menyiŋge mémbɛ̄ bɔ́ áte. Bênnyəgéd âkɛ dɛ́láa bembapɛɛ ábe Yesuɛ dyam áde ábɛ́nlédé. ");
INSERT INTO bssNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Áde ábê bebaád békagké nɛ̂, dɔ́ɔ Yesuɛ átáné bɔ́ təléd, boŋ áhɔ̄bē aá, “Nlɛ̌nté nyé.” Bêmpɛ̌ áwē, békóbɛ́n mɔ́ á mekuu âbɛ mɔ́ edúbé. ");
INSERT INTO bssNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Nyéebááʼ. Nyékɛ nyéláa ábêm bembapɛɛ ábe bédé nɛ́ɛ ábêm baányaŋ nɛ́n bán, békag á Galilia. Áwed dɔ́ɔ bényīnē mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ngáne ábê bebaád békagké âláa bembapɛɛ ábe Yesuɛ dyam ádě ábɛ́nlédé, doŋge á sə́nze ádě ánɔ́néʼáá soŋ eche Yesuɛ dênkɛ̌ á dyad-tê âkɛ dé aláa beprisɛ bémbáá chǒm ésyə̄ə̄l éche ébɛ́nlédé ádě ángɛl épédé. ");
INSERT INTO bssNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Beprisɛ bémbáá ne bad bémbáá bé Israɛl bêmbǒm âtíi ngáne bɛ́bɛnlé. Nɛ́ɛ bémáá atíi, bêmbɛ̌ échê sə́nze nsoŋgé ḿ mɔné ḿme ńchábé ámīn. ");
INSERT INTO bssNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Béláá-ʼɛ bɔ́ bán béhɔ̂b bán, “Yesuɛ ábē bembapɛɛ bénhyɛ mɔ́ ndim achíb nkuu ádě nyékúnɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nzé Payledɛ awógé, né sɛ́ɛ̄bɛ̌l adúbé nɛ́n aá awusé déesaá ádɛ̄n. Nɛ̂ dɛ́bɛ̌l nyéesɔ́nlé á ndutul-tê.” ");
INSERT INTO bssNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Né-ɔɔ́ éche sə́nze ênkǒb ḿmê mɔné, bébɛ̄l-lɛ ngáne bénlāāʼɛ́ bɔ́. Kə́ə́ŋ neʼ chii, bad bé Israɛl bédíi békale ḿmê nkalaŋ. ");
INSERT INTO bssNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Bɔɔb-pɔɔ́, bembapɛɛ dyôm-ne-nhɔ́g ábe Yesuɛ bênkɛ̌ á ekone-mîn á Galilia wɛ́ɛ ánlēbɛ̄ɛ̄ aá békɛ. ");
INSERT INTO bssNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Anyín ádě bényíné mɔ́, bêmbɛ mɔ́ edúbé, kénɛ́ɛ bɔ́ doŋge á bad bénkênkoŋgé adúbe nɛ́n bán Yesuɛ mwěn-ɛɛ́ akǒŋté abɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Hɛ́ɛ Yesuɛ ásídté bɔ́ bɛnbɛn, boŋ álāŋgē bɔ́ aá, “Kunze esyəə́l ebǎgnédé mɛ, ádyōb ne á nkǒŋ ńsé. ");
INSERT INTO bssNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nyékag meloŋ mé nkǒŋsé mésyə̄ə̄l, nyébɛle bad ábêm bembapɛɛ. Nyédusan-nɛ bɔ́ á dǐn ádě Titɛ́ɛ, á dǐn á Mwǎn ne á dǐn dé Edəə́dəŋ éche Ésáá. ");
INSERT INTO bssNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nyéyə́gte-ʼɛ bɔ́ âhíd mekan mésyə̄ə̄l ḿme ńsógtɛ́né nyé. Nyébíi nɛ́n bán mɛ̌bɛ̄-ʼɛ ne nyé kə́ə́ŋ ne á asóg dé nkǒŋsé.”");
INSERT INTO bssNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nkalaŋ ḿ bwâm ḿme Yesu Krǐstəə Mwǎn a Dyǒb mɔ̂mɛ́n. ");
INSERT INTO bssNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ḿbóótédé ngáne nkal éʼdəə́dəŋ Yesayaa ântenlé aá, “Dyǒb áhɔ́bé aá, ‘Nɔnéʼ, nlóme ḿmêm mésɛ́nzɛ ḿme mɛ́sēbē wɛ áʼsō, âboŋsɛn wɛ nzii.’ ");
INSERT INTO bssNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mɔ́bɛléʼ ehə́ŋgé á ehyáŋge nɛ́n, ‘Nyéboŋsɛn epɛ éche Sáŋgwɛ́ɛ́. Nyétíi echě nzii.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Né-ɔɔ́ Jɔnɛ ampɛ̌ á ehyáŋge, ádusɛ́n bad, ákalé-ʼɛ eyale é Dyǒb aá, “Nyétɛde abɛl dé mbéb, nyékud edusɛn âbɛl boŋ Dyǒb álagsɛn nyé mbéb.” ");
INSERT INTO bssNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bad bébídéʼáá á mbwɔ́g e Judeya esyəə́l ne á dyad á Jerusalɛm, békag áwē âwóglɛn mɔ́. Nɛ́ɛ bêmpalɛ́ɛ́ ḿmāb mbéb áte Jɔnɛ ádusɛ́n bɔ́ á edíb é Jodan. ");
INSERT INTO bssNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jɔnɛ ahágéʼáá mbɔ́té éche bébɛ́nlé nyoŋ éche ébídé á yə̌l e kamɛ̂l. Awááʼáá ngə́ə́ a ngob e nyam. Eʼchuu ne bengómɛ́ɛ́ bɔ́ɔ ádyágéʼáá. ");
INSERT INTO bssNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ahə́ŋtéʼáá aá, “Mod ǎpɛ̌ ámbīd echêm awě atómé mɛ. Meékwognedɛɛ́ ké âbwaam ásē âhune ḿmē nkɔɔd mé metámbé. ");
INSERT INTO bssNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ndusan nyé ne mendíb, boŋ ǎdusɛ́n nyé ne Edəə́dəŋ éche Ésáá.” ");
INSERT INTO bssNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ḿmê mesú Yesuɛ ambíd á dyad á Nazarɛt á mbwɔ́g e Galilia ápɛ wɛ́ɛ Jɔnɛ. Jɔnɛ andusɛ́n mɔ́ a edíb é Jodan. ");
INSERT INTO bssNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Áde Yesuɛ ábídɛɛ́ á edíb-te dɔ́ɔ ányíné nɛ́ɛ ngob e dyǒb énednadté. Edəə́dəŋ é Dyǒb émbīd ádyōb, ésud mɔ́ á nló mîn nɛ́ɛ élə̄ə̄. ");
INSERT INTO bssNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Hɛ́ɛ ehɔ́b ébídɛɛ́ ádyōb nɛ́n, “Edíi awem mwǎn a nlém awě ńdə́ə́ bwâmbwam. Ndé menyiŋge ne wɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ábwɔ̄g-ábwɔ̄g échê Edəə́dəŋ ênkid Yesuɛ á ehyáŋge. ");
INSERT INTO bssNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Andyɛɛ́ áwed móom mé eʼpun méniin, Satanɛ ákəgé mɔ́. Nyam échě ékaaʼ ébédé áwed, ángɛl-lɛ éwōŋgān mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ámbīd e póndé bénhɛ̄ Jɔnɛ á mbwɔg. Áde bémáá mɔ́ ahɛ́ á mbwɔg, Yesuɛ ampɛ̌ á mbwɔ́g e Galilia ákalé nkalaŋ ḿ bwâm ń Dyǒb, áhɔ̄bē nɛ́n, ");
INSERT INTO bssNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Póndé epedé, nkamlɛn ń Dyǒb ńdé bɛnbɛn. Nyé mod tɛ́ɛ́ áhəŋlɛn ádē abɛ́ dé mbéb, nyédúbe-ʼɛ nkalaŋ ḿ bwâm.” ");
INSERT INTO bssNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Áde Yesuɛ ábammɛɛ́ nkin mé edib-é-nzab é Galilia annyín Simɔnɛ bɔ́ mwǎnyaŋ Andreya, nɛ́ɛ bébwémɛɛ́ mbínzé. Bébédɛ́ɛ bekób-bé-súu. ");
INSERT INTO bssNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Nyéhíde mɛ. Ngáne nyékóbɛɛ́ súu bɔɔb, mɛɛ́yə̄gēd nyé ngáne nyɛ́tēdtē bad nlém á abum âhíd mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ábwɔ̄g-ábwɔ̄g bêntɛdé échab mbínzé, béhīdē-ʼɛ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nɛ́ɛ ákíí mwǎ etûn, annyín bǎn ábe Zɛbɛdiɛ, Jemsɛ bɔ́ mwǎnyaŋ Jɔnɛ á bɔ̌lɛ-tê nɛ́ɛ bébwémɛɛ́ mbínzé. ");
INSERT INTO bssNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Anyín ádě ányíné bɔ́, anchɛ́lé bɔ́. Bêntɛdé echab sáŋ Zɛbɛdiɛ ne bad bé nsɔ́n á bɔ̌lɛ-tê béhīdē Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesuɛ ne ábê bembapɛɛ béniin bênkɛ̌ á dyad á Kapenahum. Ádě mbwɛ-mé-nkɔ́me-áte ḿpédé, Yesuɛ ankɛ̌ asɔ́l á ndáb e mekáne, ábootéd bad ayə́ged. ");
INSERT INTO bssNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nyaa eche áyə́gtéʼáá enkɔ́méd bad yə̌l áte bwâmbwam áyə̄le ayə́gtéʼáá nɛ́ɛ mod awě nzé ahɔ́bé né émáá. Eeyə́gteʼaá nɛ̂ŋgáne bemeléede bé mbéndé. ");
INSERT INTO bssNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hɛ́ɛ mod nhɔ́g awě edəə́dəŋ é mbéb émbɛ̄ɛ̄ áte ápédé təléd, ábōnē aá, ");
INSERT INTO bssNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“A-Yesu, mod a Nazarɛt, cheé syánē déwóŋné? Ehyedé sé awúu-yɛ? Mbíí wɛ bwâm. Edíī mod awě Dyǒb álómé, awě asáá.” ");
INSERT INTO bssNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Hɛ́ɛ Yesuɛ ákânnɛɛ́ échê edəə́dəŋ é mbéb áte aá, “Lám, bíd ane mod áte!” ");
INSERT INTO bssNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Dɔ́ɔ échê edəə́dəŋ é mbéb éságté ane mod áte ngíne-ngíne, éhɛ́-ʼɛ esaád é ngíne, boŋ ébíd-tɛ mɔ́ áte. ");
INSERT INTO bssNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Menyáké ménkōb ábê bad bwâmbwam. Bésɛdté nhɔ́g ne aníníí bánken, “Nzé-dyámɛ́ dɛ́n! Ayə́ged dékɔ̄ɔ̄lē dɛ́n-ɛ? Anɛ́n mod awóó ngíne âkamlɛn eʼdəə́dəŋ bé mbéb, éʼwōgnē-ʼɛ mɔ́!” ");
INSERT INTO bssNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nɛ́n dêmbɛ̌l nkalaŋ ḿme Yesuɛ mênkanléd mbwɔ́g e Galilia esyəə́l. ");
INSERT INTO bssNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nɛ́ɛ béhídté á ndáb e mekáne hidtɛ́n, Yesuɛ nchoo ne Jemsɛ bɔ́ Jɔn bênkɛ̌ á ndáb eche Simɔnɛ bɔ́ Andreya. ");
INSERT INTO bssNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simɔnɛ mwaád nyaá ambɛ́ á anɔŋ dé nkole, ahéb dênsog mɔ́. Áde Yesuɛ ápédé pɛɛ́n, bénlāā mɔ́ tə̂ŋgɛne nkole ḿme ane mmwaád. ");
INSERT INTO bssNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Dɔ́ɔ ákíí wɛ́ɛ ane mmwaád ábédé, boŋ áchə̄ŋgē mɔ́ á ekáá, awóŋgɛ́n mɔ́ âsyə ásē. Ahéb dêmmaá mɔ́, ákōb-pɛ bɔ́ nken. ");
INSERT INTO bssNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ene ngukɛ́l áde enyɛn émáá asud, bad bêmpɛɛ́n bad bé nkole bésyə̄ə̄l ne bad bésyə̄ə̄l ábe eʼdəə́dəŋ bé mbéb bémbɛ̄ɛ̄ áte wɛ́ɛ Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bad bé dyad bésyə̄ə̄l bênkaŋnɛ́n mmwɛ ndáb ḿme Simɔnɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesuɛ anchoód bad híin ábe békónléʼáá nkole nyaa ne nyaa, abídéd-tɛ bad eʼdəə́dəŋ bé mbéb híin áte. Eémwageʼaá pɛn aá ábê eʼdəə́dəŋ bé mbéb éʼhɔ̂b dyamdyam áyə̄le bémbíi mod awě ádíí. ");
INSERT INTO bssNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Epɔg é mbwɛmbwɛ áde bǐn béēkɛ̄nlɛ̄ɛ̄, Yesuɛ anhidé ásē, áhīdē á dyad-tê, ákɛ á ahə́ŋgé á hǒm, ákānneʼ. ");
INSERT INTO bssNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simɔnɛ ne bad ábe bɔ́bɔ̄ɔ bémbɛ̄, bêmbootéd Yesuɛ ahɛd. ");
INSERT INTO bssNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bédíbté-ʼaá mɔ́, dɔ́ɔ bélâŋgɛɛ́ mɔ́ bán, “Moosyəə́l ahɛde wɛ!” ");
INSERT INTO bssNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesuɛ anláá bɔ́ aá, “Dékag hǒm démpēe. Dékag á myad ḿme ńdé bɛnbɛn âbɛl boŋ ńkal nkalaŋ ḿ bwâm áwed ámpē, áyə̄le ḿmê nkalaŋ mɔ́ɔ ńkə́ə́ boŋ ḿpɛ̄ á nkǒŋsé.” ");
INSERT INTO bssNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Né-ɔɔ́, ankɛ̌ mbwɔ́g e Galilia esyəə́l, ákalé nkalaŋ ḿ bwâm á ndáb é mekáne, ábīdtē-ʼɛ bad eʼdəə́dəŋ bé mbéb áte. ");
INSERT INTO bssNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mod nhɔ́g awě meləŋ mékóbé ampɛ̌ wɛ́ɛ Yesuɛ, abwɔ́g mebóbóŋ, áchāā mɔ́ aá áwôŋgɛn mɔ́. Anhɔ́b aá, “Nzé edəə́ ehɛle ébɛ̄l mɛ nsáŋ.” ");
INSERT INTO bssNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ngɔl enkonnéd Yesuɛ. Dɔ́ɔ ábídté ekáá, ábānē mɔ́ á yə̌l, boŋ álāŋgē mɔ́ aá, “Ndəə́, sáŋ!” ");
INSERT INTO bssNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ábwɔ̄g-ábwɔ̄g ḿme meləŋ mêmmaá ane mod á yə̌l, áchōŋ-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesuɛ anláá mɔ́ aá ákag, asím-mɛ mɔ́ etúu áte aá, ");
INSERT INTO bssNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Nɔnéʼ, weeláŋgé modmod dyam áde ábɛ́nlédé, boŋ kɛ̌ élúmed yə̌l wɛ́ɛ prisɛ, ásimɛn wɛ. Ébag-kɛ mendɛ ngáne mbéndé e Mosɛɛ éhɛdɛɛ́, âlúmed bad wɛɛ́ mɔ́sāā.” ");
INSERT INTO bssNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Boŋ ké nɛ̂, áde ane mod abídé, ankɛ̌, ákɛ ákalé mɔ́ ḿmê nkalaŋ hǒm ásyə̄ə̄l. Ankal mɔ́ bwâmbwam nyaa eche Yesuɛ éehɛleʼaá dyad ké ahɔ́g asɔ́l ámpē á ntə́lé. Antǐm ádyɛɛ́ʼ á mehə́ŋgé wɛ́ɛ bad béesaá. Ké nɛ̂, bad bébīdēʼ mebwɔ́g mésyə̄ə̄l béhyāg áwē. ");
INSERT INTO bssNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nɛ́ɛ nguse é eʼpun étómé, Yesuɛ ansú ámbīd á Kapenahum. Bad bénwōg bán ahúú. ");
INSERT INTO bssNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ekud é bad énkūmɛ̄n áwe ndáb nyaa echě etə́l éēbēdɛɛ́ á ndáb-te, ké á mmwɛ. Yesuɛ akǎnléʼáá bɔ́ eyale é Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Hɛ́ɛ dɔ́ɔ bad béniin bépɛ́ɛ́né mod awě awédé epɛd. ");
INSERT INTO bssNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Boŋ ngáne ndun e mod émbɛ̄ɛ̄ áhed, bénkênhɛnlé mɔ́ apɛɛn wɛ́ɛ Yesuɛ ábédé. Né-ɔɔ́, bénchə̄gē á ndáb mîn, bénēdē nnɔŋ ń ndáb á nló mîn wɛ́ɛ Yesuɛ ántyēēmmē. Áde bémáá nnɔŋ anede, bênsudtɛ́n ane mod ebúm éche ânnaáʼɛ́ ámīn wɛ́ɛ Yesuɛ ámbɛ̄ɛ̄. ");
INSERT INTO bssNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Áde Yesuɛ ányíné adúbe ádě ábe bad béwóó áte anláá ane mod awě awédé epɛd aá, “A-mwǎn, nlǎgsɛ́né wɛ mbéb.” ");
INSERT INTO bssNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Doŋge dé bemeléede bé mbéndé ábe bêndyɛɛ́ ásē áhed bêmbootéd anyoo áte á nlém-tê bán, ");
INSERT INTO bssNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Chán anɛ́n mod áhɛlɛɛ́ se áhɔ̄bēʼ enɛ́n ndín e akan? Asyə́ə Dyǒb. Nzɛ́ɛ́ ahɛlɛsɛ álagsɛ́n mbéb ésebán Dyǒb děmpɛn?” ");
INSERT INTO bssNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ábwɔ̄g-ábwɔ̄g Yesuɛ anchěm bɔ́ mewêmtɛn. Hɛ́ɛ ásɛdtɛɛ́ bɔ́ aáken, “Cheé ékə́ə́ boŋ nyéwōōʼ enɛ́n ndín e mewêmtɛn? ");
INSERT INTO bssNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ahéé ádé dyam ásad, naa âhɔ́b wɛɛ́ ‘Nlagsɛ́né wɛ mbéb,’ káa âhɔ́b wɛɛ́, ‘Syəə́ ásē, étêd échōŋ ebúm ébooted akɛ?’ ");
INSERT INTO bssNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Boŋ, mɛ̌lūmēd nyé nɛ́n mɛɛ́ Mwǎn-a-Moonyoŋ awóó kunze á nkǒŋsé âlagsɛn mbéb.” Dɔ́ɔ álâŋgɛɛ́ ane mod awě awédé epɛd aá, ");
INSERT INTO bssNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nlâŋge wɛ nɛ́n, syəə́ ásē, étêd échōŋ ebúm, ésúɛʼ á ndáb.” ");
INSERT INTO bssNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hɛ̂ děn wɛ́ɛ moosyəə́l ánɔnɛɛ́ mɔ́ nɛ̂, ane mod anhidé ásē, atéd éche ebúm ábootéd-tɛ akɛ. Yə̌l enkɔ́m bɔ́ áte bwâmbwam, békɛ̄nē Dyǒb, béhɔ̄bē bán, “Séēnyīnɛ̄ɛ̄ sé enɛ́n ndín e dyam mbêd!” ");
INSERT INTO bssNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ámbīd e nɛ̂, Yesuɛ antǐm ámbīd ámpē á nkin mé edib-é-nzab é Galilia. Ndun e mod empɛ̌ áwē, ábootéd-tɛ bɔ́ ayə́ged. ");
INSERT INTO bssNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Áde átómɛɛ́ á nzii, annyín nlad-é-táásɛ nhɔ́g awě béchə́géʼáá bán Leviɛ, mwǎn awě Alpasɛɛ. Leviɛ andyɛɛ́ ásē á ndáb echě ákóbéʼáá táásɛ áte. Hɛ́ɛ Yesuɛ álâŋgɛɛ́ mɔ́ aá, “Hídé mɛ.” Dɔ́ɔ Leviɛ átyéémé ámīn boŋ áhīdē-ʼɛ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ámbīd e póndé Yesuɛ adyágéʼáá ndyééd á ndáb wɛ́ɛ Leviɛ. Ekud é besaad bé táásɛ ne bad bé mbéb bémpēe béhídéʼáá mɔ́. Bɔ́bɔ̄ɔ bêndyɛɛ́ á tébelɛ ne ábē bembapɛɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Áde doŋge dé bemeléede bé mbéndé ábe bébédé Befarisia bényíné Yesuɛ ádyāg ndyééd ne ábê bad bé mbéb, ne besaad bé táásɛ, dɔ́ɔ bésɛdtɛɛ́ ábē bembapɛɛ bánken, “Cheé ékə́ə́ boŋ ádyāg ndyééd ne échê ndín é bad?” ");
INSERT INTO bssNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Áde Yesuɛ áwógé nɛ̂, anláá bɔ́ aá, “Bad ábe bédyɛ́ɛ́ bwâm béētógnɛnɛɛ́ mod-a-bwɛl. Bad ábe békonleʼ bɔ́ɔ bétógnɛ́né mod-a-bwɛl. Meépedɛɛ́ á nkǒŋsé âchɛ́le bad ábe békóbnédé áʼsō éʼ Dyǒb, boŋ mpedé áyə̄le bad bé mbéb.” ");
INSERT INTO bssNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Póndé pɔ́g ebédé, bembapɛɛ ábe Jɔnɛ, Ndusɛnɛ ne Befarisia bêndǐd yə̌l nzaa á mekáne-tê. Dɔ́ɔ bad behɔ́g bépédé wɛ́ɛ Yesuɛ boŋ bésɛdte mɔ́ bánken, “Cheé ékə́ə́ boŋ bembapɛɛ ábe Jɔnɛ, Ndusɛnɛ ne ábe Befarisia bédidé yə̌l nzaa á mekáne-tê boŋ ábōŋ pɛn béedidéʼ?” ");
INSERT INTO bssNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesuɛ ankwɛntɛ́n bɔ́ ne ngan aá, “Chán bad ábe bélébpé á ngande e eʼwóŋgé, béhɛle bédidé yə̌l nzaa á mekáne-tê áde mod awě akude sɔ́mbé ádíi adé ne bɔ́? Béedidɛ́ɛ́, béetə̂ŋgɛnɛɛ́ yə̌l nzaa adid á mekáne-tê póndé echě mod awě akude sɔ́mbé ádíi ne bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Boŋ epun épɛ̌ éche bɛ́kobɛ́nné bɔ́ mod awě akude sɔ́mbé. Échê epun dɔ́ɔ bédidté yə̌l nzaa á mekáne-tê. ");
INSERT INTO bssNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nyêbíí nɛ́n bán nzé mod anabpeʼ mbɔ́té, eetédɛ́ɛ́ epɛd é abad ékɔ̄ɔ̄lē sɛ ánabnéd nchun ḿ mbɔ́té. Áyə̄le nzé échê epɛd é abad ébóótédé abób áte ébɛlé éhabnéd abad dé nchun. Nɛ̂ ábɛleʼ, échê epɔn ékəleʼ áte tómaa ngáne énsēbɛ̄ɛ̄ abɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Melemlem nɛ̂ŋgáne mod éētēdɛ̄ɛ̄ mǐm mékɔ̄ɔ̄lē sɛ ahɛ́ mɔ́ á nchun mé ntyə́g, se ápen. Áyə̄le nzé abɛlé nɛ̂, né mǐm mɛ́hǒd kə́ə́ŋ ntyə́g ńyɛ́d, mǐm mɛ́mǎd asyɔge ntyə́g-kɛ ámpē ḿbéb. Boŋ bétédɛɛ́ mǐm mékɔ̄ɔ̄lē, béhɛ́ á ntyə́g mékɔ̄ɔ̄lē-te.” ");
INSERT INTO bssNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mbwɛ-mé-nkɔ́me-áte nhɔ́g Yesuɛ atóméʼáá á nzag e ngun-tê. Ambɛ́ ne ábē bembapɛɛ. Áde békagké nɛ̂, dɔ́ɔ ábē bembapɛɛ bébóótédé eʼsɔ́g éʼ ngun apád. ");
INSERT INTO bssNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Hɛ́ɛ Befarisia bélâŋgɛɛ́ Yesuɛ bán, “Nɔnéʼ, cheé ékə́ə́ boŋ ábōŋ bembapɛɛ bébɛle dyam áde mbéndé éebagɛɛ́ kunze âbɛl á mbwɛ-mé-nkɔ́me-áte?” ");
INSERT INTO bssNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesuɛ antimtɛ́n bɔ́ aá, “Nɛ́dē nyéēlāāʼɛ́ mbêd á kálag e Dyǒb dyam ádě kə̂ŋ Dabidɛ ámbɛnlé ádě bétógé chǒm éche bédyágkē ne ádě nzaa ékóbé mɔ́ ne ábē bad-ɛ? ");
INSERT INTO bssNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ansɔ́l á Ndáb-e-Dyǒb á póndé echě Abyataa ábédé prisɛ ambáámbáa. Andyɛ́ eʼwɛle ábe éʼbédé ndɛ e Dyǒb. Boŋ echɛd mbéndé eébagɛɛ́ mod ké nhɔ́g kunze ádyɛ̄ ábê eʼwɛle étōmɛɛ́ Prisɛ. Mwěn andyɛ́ ábɛ̄-ʼɛ kə́ə́ŋne bad ábe bênwoón mɔ́ doŋge.” ");
INSERT INTO bssNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Dɔ́ɔ Yesuɛ ásógtɛɛ́ aá, “Dyǒb dénsēbē moonyoŋ ahəg, boŋ átīīdē epun éche bɛ́kɔ̄mmɛ̄ɛ̄ áte. Enkênsébɛ́ɛ́ epun atíi boŋ áhəgé moonyoŋ aá ákɔ̂mme áte échê epun. ");
INSERT INTO bssNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Né-ɔɔ́, Mwǎn-a-Moonyoŋ awóó nkamlɛn kə́ə́ŋne ámīn e mbwɛ-mé-nkɔ́me-áte.” ");
INSERT INTO bssNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Hɛ́ɛ Yesuɛ átímé ámbīd á ndáb e mekáne. Mod abédé áhed awě ekáá éwédé. ");
INSERT INTO bssNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bad behɔ́g ábe bébédé áhed béhɛ́déʼáá Yesuɛ awusé akóbɛn. Né-ɔɔ́ bénɔ́néʼáá Yesuɛ chodchod, ânyín nzé ǎdǐd ane mod bwâm á mbwɛ-mé-nkɔ́me-áte. ");
INSERT INTO bssNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ ane mod aá, “Hyɛ̌ étyéem áʼsō hɛ́n!” ");
INSERT INTO bssNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Dɔ́ɔ Yesuɛ ásɛdtɛɛ́ ábê bad aáken, “Nyéláa mɛ ké édé mbéndé âbɛl mboŋ á mbwɛ-mé-nkɔ́me-áte, káa âbɛl mbéb. Édé mbéndé âsoŋ aloŋgé á mod, káa âwúu mɔ́?” Boŋ bénkênhɔ́bpé dyamdyam. ");
INSERT INTO bssNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Anwóg ndutul á nlém-tê bwâmbwam áyə̄le ábāb eʼlɛl bé nlém á abum. Hɛ́ɛ ánɔ́né bɔ́ ne meliŋgá, boŋ álāŋgē ane mod aá, “Sálé ekáá áte.” Asále áde ane mod ásánlé ekáá áte, ekáá êndyɛɛ́ mɔ́ bwâm ámpē. ");
INSERT INTO bssNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Hɛ́ɛ Befarisia bébídé á ndáb e mekáne, boŋ békɛ̄ bétānē bad bé epepé éche Hɛrɔdɛ, ábwɔ̄g-ábwɔ̄g bɔ́bɔ̄ɔ béhəgké Yesuɛ âwúu mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesuɛ ne ábê bembapɛɛ bênhidé békɛ̄ á edib é Galilia. Ndun e mod enhíd mɔ́ áwed. Ábê bad bémbīd á mbwɔ́g e Galilia, á Judeya, ");
INSERT INTO bssNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","á Jerusalɛm, á mbwɔ́g e Idumeya, á mbwɔ́g echě edé échíníí epɛd é Jodan, ne á myad ḿme médé bɛnbɛn ne myad mémbáá mé Tirɛ ne Sidɔn. Ábén bad bépágéʼáá wɛ́ɛ Yesuɛ áyə̄le bénwōg mam ḿme ábɛ́léʼáá. ");
INSERT INTO bssNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Bad bêmbuú áte nyaa echě echabé ámīn. Né-ɔɔ́, Yesuɛ anláá ábē bembapɛɛ aá béboŋsɛn bɔ̌lɛ âbɛl boŋ bad béekaŋnán mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ammǎd ekud é bad achood, né-ɔɔ́ bad bésyə̄ə̄l bémpēe ábe békónléʼáá bébuné apɛ wɛ́ɛ ádíí, âsitɛn mɔ́ âbɛl boŋ bédyɛɛ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Póndé tɛ́ɛ́ echě eʼdəə́dəŋ bé mbéb ábe éʼbédé bad áte bényīnnē mɔ́, éʼbɛ́léʼáá bad ábe éʼdíí áte béhūnē ásē, éʼbōnē-ʼɛ bán, “Wɛ-ɛɛ́ edé Mwǎn a Dyǒb!” ");
INSERT INTO bssNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yesuɛ ansím bɔ́ etúu áte aá bélāŋgē bad nyaa e mod eche mɔ́díí. ");
INSERT INTO bssNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Hɛ́ɛ Yesuɛ áchə́gké á ekone mîn, áchɛ̄nlē bad ábe áhɛ́déʼáá, boŋ bépǎg áwē. ");
INSERT INTO bssNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Dɔ́ɔ ápwɛ́dé bad dyôm ne bébɛ âbɛ́ ne mɔ́, áchəgé bɔ́ aá bembapɛɛ bé nlómag ábe álōmmē-ʼɛ âkal eyale é Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ambǎg-kɛ bɔ́ ngíne âbíded bad eʼdəə́dəŋ bé mbéb áte. ");
INSERT INTO bssNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ábê bad dyôm ne bébɛ bébédɛ́ɛ: Simɔnɛ awe Yesuɛ ânchuúʼɛ́ mbəŋ aá Petro; ");
INSERT INTO bssNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jemsɛ bɔ́ mwǎnyaŋ Jɔnɛ, bǎn ábe Zɛbɛdiɛ, (ábe Yesuɛ ânchuúʼɛ́ mbəŋ aá Bwanegɛsɛ, awě adé bán, Bǎn bé ngin.) ");
INSERT INTO bssNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andreya bɔ́ Filibɛ, Batolomyo, Matyo, Tɔmasɛ, Jemsɛ mwǎn awě Alfɔsɛ, Tadiosɛ, Simɔnɛ awě ambɛ́ á epepé é kə́n e aloŋ, ");
INSERT INTO bssNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ne Judas Iskariɔdɛ awě antǐm Yesuɛ asóm. ");
INSERT INTO bssNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Hɛ́ɛ Yesuɛ átímé á dyad. Ekud é bad ênkaán ámpē nyaa echě Yesuɛ ne ábē bembapɛɛ bénkênwóŋgé póndé âdyɛ́ ndyééd. ");
INSERT INTO bssNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Áde Yesuɛ baányaŋ béwógé nɛ̂, bênkɛ̌ mɔ́ ahɛd, âtéd mɔ́ âswɛ̂n mɔ́ á ndáb áyə̄le bad béhɔ́béʼáá nɛ́n bán, “Nló méēsáaʼɛ́ mɔ́ áte.” ");
INSERT INTO bssNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Doŋge dé bemeléede bé mbéndé ábe bémbīd á Jerusalɛm béhɔ́béʼáá bán, “Bɛlzɛbulɛ adé mɔ́ áte. Ene kə̂ŋ e eʼdəə́dəŋ bé mbéb chɔ̂ ebagé mɔ́ ngíne âbíded bad eʼdəə́dəŋ bé mbéb áte.” ");
INSERT INTO bssNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Hɛ́ɛ Yesuɛ áchɛ́nlé bɔ́ boŋ ákanlé bɔ́ ngan aáken, “Chán Satanɛ áhɛle se abídéd Satanɛ? ");
INSERT INTO bssNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nzé bad bé aloŋ ahɔ́g békábné áte, boŋ nchemtɛ́n méesɛ̌, ádê aloŋ déehɛlɛɛ́ atyéem. ");
INSERT INTO bssNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nzé abum á ndáb-pɛ ákábné áte, boŋ nchemtɛ́n méesɛ̌, ádê abum á ndáb déehɛlɛɛ́ atyéem. ");
INSERT INTO bssNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Né-ɔɔ́, nzé nkamlɛn ń Satan ńkábné áte, boŋ běn ne běn béwane, ḿmê nkamlɛn méebemmé, mɛ́kwɛ̌, ḿpɛ̄-ʼɛ ásōg. ");
INSERT INTO bssNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Né dɔ́ɔ mod eéhɛ̄lɛ̄ɛ̄ se asɔ́l á ndáb e ngíne-e-mod se ádūm ábē bwěm ésebán asébpé mɔ́ ahaŋ. Amaa-ʼáa mɔ́ ahaŋ, boŋ atéd ábē bwěm éʼsyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ne mbále nlâŋge nyé nɛ́n mɛɛ́ Dyǒb dɛ́lagsɛ́n bǎn bé baányoŋ mbéb ńsyə̄ə̄l ḿme bébɛ́lé kə́ə́ŋne nzyə́ŋ ké ehéé echě bébídté á nsəl. ");
INSERT INTO bssNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Boŋ kénzɛ́ɛ́ awě ahɔ́bé eʼbébtéd éʼ mekan tə̂ŋgɛne Edəə́dəŋ éche Ésáá, éekudté alagsɛn mbêd. Abɛlé mbéb ḿme méēwóo alagsɛn.” ");
INSERT INTO bssNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesuɛ anhɔ́b nɛ́n áyə̄le bad béhɔ́béʼáá bán, “Edəə́dəŋ é mbéb édé mɔ́ áte.” ");
INSERT INTO bssNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Hɛ́ɛ Yesuɛ nyaá ne Yesuɛ baányaŋ bépédé, bétyéém é ebwɔ́g-te, boŋ bélōmē mɔ́ achəg. ");
INSERT INTO bssNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ndun e mod enləŋnéd Yesuɛ. Bêndyɛɛ́ ásē. Dɔ́ɔ bélâŋgɛɛ́ mɔ́ bán, “Echǒŋ nyoŋ ne baányoŋ bédé á ebwɔ́g-te béhɛde wɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Hɛ́ɛ Yesuɛ ásɛdtɛɛ́ bɔ́ aáken, “Nzɛ́ɛ́ adé echěm nyaŋ, benzɛ́ɛ́-ʼɛ bédé bǎnned?” ");
INSERT INTO bssNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Dɔ́ɔ Yesuɛ ánɔnɛɛ́ bad ábe bélə́ŋnédé mɔ́ nɛ̂, boŋ áhɔ̄bēʼ aá, “Echěm nyaŋ ne bǎnned bɔ́ɔ bén! ");
INSERT INTO bssNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kénzɛ́ɛ́ awě abɛle mam ḿme Dyǒb áhɛdɛɛ́ adíi mwǎnned, abɛ́-ʼɛ echěm nyaŋ.” ");
INSERT INTO bssNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesuɛ ambootéd bad ayə́ged ámpē á nkəg mé edib é Galilia. Bad ábe bênləŋnéd mɔ́ béntōmtɛ̄n abuu áte, nɛ̂ dêmbɛ̌l asɔ́l á bɔ̌lɛ-tê ádyɛ̄ɛ̄ áwēd-te. Ábê bɔ̌lɛ bémbɛ̄ á edib-tê. Ene ndun e mod chɔ́-ʼɛ enlyə̌g á nkin mé edib. ");
INSERT INTO bssNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Abɛ̌nládtáá ngan âyə́ged bɔ́ mekan híin. Ankalé bɔ́ ngan aá, ");
INSERT INTO bssNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nyéwóglɛn! Nkwɛl-é-nzag nhɔ́g ankɛ̌ mbə́l asob á nzag-tê. ");
INSERT INTO bssNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Áde ásobɛɛ́ mɔ́ nɛ̂, doŋge dénhūn á nzii-tê, menɔn mêmpɛ̌ mémad mɔ́ asɔ̂mted. ");
INSERT INTO bssNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Doŋge dénhūn á meláá-tê wɛ́ɛ ndɔɔb énkêmbuúʼɛ́ áte. Énwāmsɛ̄n abíd ásē ngáne ndɔɔb énkênchabpé ásē. ");
INSERT INTO bssNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Boŋ nɛ́ɛ enyɛn é ngíne épédé énhyāād ábê bwěm éʼwɛ́-ʼɛ, áyə̄le nkaŋ ménkênsɔ́nlé bɔ́ á ndɔɔb-tê bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mbə́l mémpēe ménhūn wɛ́ɛ mekɔ̂d médíí. Nɛ́ɛ mekɔ̂d mê mékwógé, mékáŋ akwog áde ábɛ̂ bwěm, nɛ̂ ábɛl bénkênchyááʼɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Boŋ doŋge dé mbə́l dénhūn á ndɔɔb e bwâm. Ḿmɛ́n mbə́l mémbīd ásē bwâm, ńkwōg, ńchyáá-ʼɛ. Doŋge dé eʼsɔ́g dénwālē móom mé mbum méláán, doŋge móom ntóób, ábíníí-ʼɛ, mbwɔ́kɛl.” ");
INSERT INTO bssNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesuɛ ansógéd enɛ́n ngan aá, “Kénzɛ́ɛ́ awě awóó metúu, áwógeʼ.” ");
INSERT INTO bssNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Áde Yesuɛ ályə́gé mwěmpɛn, ábē bembapɛɛ dyôm ne bébɛ ne bad ábe bémbɛ̄ ne mɔ́, bénlāā mɔ́ bán átógned bɔ́ échê ngan. ");
INSERT INTO bssNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Dyǒb ábágé nyé kunze âbíi kun e nkamlɛn ḿmē, boŋ ne bad bémpēe abɛle aá béwógeʼ ḿmɛ́n mekan mésyə̄ə̄l dásɔ̄ á ngan-tê. ");
INSERT INTO bssNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Abɛlé nɛ̂, âbɛl boŋ, ké bényīnē ké nyínɛ́n, béechemé, ké béwōgē ké wógɛ́n béēsōŋtān áyə̄le nzé bésóŋtɛ́né né bɛ́timɛ́n Dyǒb, békūd-tɛ alagsɛn dé mbéb.” ");
INSERT INTO bssNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Dɔ́ɔ Yesuɛ ásɛdtɛɛ́ bɔ́ aáken, “Nɛ́dē nyéesôŋtɛnɛɛ́ enɛ́n ngan-ɛ? Nzé nyéesôŋtɛne chɔ́ chán-nɔ̄ nyɛ́mwɛɛ́ échíníí ngan asôŋtɛn? ");
INSERT INTO bssNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nsob-a-mbə́l awéne eyale é Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Doŋge á bad bédé nɛ̂ŋgáne mbə́l ḿme ńhúné á nzii-tê. Nzé béwógé eyale é Dyǒb ábwɔ̄g-ábwɔ̄g Satanɛ abɛlé áhyɛ ahúd bɔ́ chɔ́ á nlém-tê. ");
INSERT INTO bssNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ábíníí bédé nɛ̂ŋgáne mbə́l ḿme ńhúné á meláá-tê. Béwógeʼ eyale é Dyǒb, ábwɔ̄g-ábwɔ̄g békōb-pɛ chɔ́ ne menyiŋge. ");
INSERT INTO bssNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Boŋ échê eyale éēwēnnāādtē bɔ́ á nlém-tê, bédúbpe-ʼɛ chɔ́ dásɔ̄ á esóŋ é póndé. Né-ɔɔ́, nzé ndutul ne metake bépédé áyə̄le échê eyale bédol yə̌l ámbīd ábwɔ̄g-ábwɔ̄g. ");
INSERT INTO bssNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ábíníí-ʼɛ bédíí nɛ́ɛ mbə́l ḿme ńhúné á mekɔ̂d-te. Bédíi bad ábe béwóge eyale é Dyǒb, ");
INSERT INTO bssNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","boŋ mpúlé mé nkǒŋsé ne adəŋ dé abud á bwěm awóŋ, ne ahɛd á bwěm bémpēe ákáŋ bɔ́ nlém áte nyaa echě béehɛlɛ́ɛ́ eʼpum achyáa. ");
INSERT INTO bssNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Boŋ bad ábe bédé nɛ̂ŋgáne mbə́l ḿme ńhúné á ndɔɔb echě eboó yə̌l, bédíí bad ábe béwógeʼ eyale é Dyǒb, békōb-pɛ chɔ́, béchyāā-ʼɛ eʼsɔ́g ábɛ éʼwánlé mesoŋgé mé mbum móom méláán, móom ntóób ne mbwɔ́kɛl.” ");
INSERT INTO bssNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Hɛ́ɛ Yesuɛ ásɛdtɛɛ́ ene ndun e mod aáken, “Mod asɔ́nlɛɛ́ etrúkáŋ échě ámáá achod á ndáb-te, ábānē chɔ́ á ebwɔg-sɛ́ kéʼɛ á anoŋ sé-yɛ? Saá á atii dé etrúkáŋ mîn dɔ́ɔ ábɛlé ábānē chɔ́? ");
INSERT INTO bssNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Chǒm ké éhéé éche ékóŋnédé ébīd á enyɛn. Ké éhéé-ʼɛ éche békútɛ́né bɛ́dibé chɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kénzɛ́ɛ́ awě awóó metúu, áwógeʼ. ");
INSERT INTO bssNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Nyétôŋ chǒm-ɛ́ɛ nyéwógɛɛ́ anɔn áte bwâm! Melemlem mé nhəgtéd ḿme ébɛ́nlédé wɛ́ɛ wɛ̌n mɔ́ɔ Dyǒb dɔ́mpē dɛ́bɛnlédté, ǎbɛnléd-tɛ mɔ́ tómaa ngáne wêmbɛnlédté wɛ́ɛ wɛ̌n. ");
INSERT INTO bssNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kénzɛ́ɛ́ awě awóó nsôŋtɛn ń kun é nkamlɛn ḿ mín, Dyǒb dɛ́bād mɔ́ ḿmê nsôŋtɛn abɛ. Ane awě mɔ́-ʼɛ eewóo, Dyǒb dɛ́kobɛ́n mɔ́ kə́ə́ŋne mwǎmpīn awě awóó.” ");
INSERT INTO bssNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesuɛ ambɛ́ áhɔ́be aá, “Nkamlɛn ń Dyǒb ńdíi nɛ̂ŋgáne mod awě akií mbə́l-e-bǔ asob á nzag-tê, ");
INSERT INTO bssNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","átīm ámbīd á ndáb, nkuu ákūneʼ, mǔte ábɛlé ḿme nsɔ́n. Ene póndé esyəə́l, mbə́l ébíde ásē, ékwɔgeʼ ésebán abíɛʼ ngáne nɛ̂ ábɛnladté. ");
INSERT INTO bssNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ndɔɔb chěn-ɛɛ́ ebɛle boŋ bwěm éʼkwogéʼ, éʼchyāā-ʼɛ eʼpum. Nlɔ́m ḿ byaá mɔ́ɔ ńsēbpe abíd, ámbīd e póndé mbwéem kə́ə́ŋne ásōg, eʼsɔ́g bɔ́mpē éʼbíd. ");
INSERT INTO bssNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Boŋ nzé eʼsɔ́g éʼmáá awúu, ábwɔ̄g-ábwɔ̄g ane mod abɛlé atéd páá âkɛ dé apád áyə̄le póndé echě bépadɛɛ́ epedé.” ");
INSERT INTO bssNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Hɛ́ɛ Yesuɛ áhɔ́bɛɛ́ ámpē aáken, “Cheé déhɛlɛɛ́-sɛ déhəgtɛ́n nkamlɛn ń Dyǒb-ē? Ngan ehéé dɛ́bɛnlédté echě ělūmēd ngáne ḿmê nkamlɛn ńdíí-yɛ? ");
INSERT INTO bssNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ńdíi nɛ̂ŋgáne mbwɛ́ e mbə́l-e-bǔ echě mod átédé boŋ ásob á nzag-tê. Mbə́l-e-bǔ edé mwǎmpīn bwâmbwam nzé béhə́gtɛ́né chɔ́ ne mbə́l mémpēe ḿme ńdé á nkǒŋsé. ");
INSERT INTO bssNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Boŋ nzé ékwógé, ékəleʼ tómaa eʼsum éʼsyə̄ə̄l, éwóo-ʼɛ ngɛn éche menɔn méhyagké mǔm alóŋ áte.” ");
INSERT INTO bssNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesuɛ akǎnléʼáá bad eyale é Dyǒb, ábɛnláád ekud é ngan émpēe nɛ̂ŋgáne échɛ́n. Akǎnléʼáá bɔ́ nyaa echě bɛ́sōŋtɛ̄nnē. ");
INSERT INTO bssNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Eékanleʼaá bɔ́ áde éebɛnlédɛɛ́ ngan, boŋ nzé anlyə̌g mwěmpɛn ne ábe bembapɛɛ aláá bɔ́ mam mésyə̄ə̄l ḿme échê ngan éhɔ́bɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Échê epun děn ngukɛ́l, dɔ́ɔ Yesuɛ álâŋgɛɛ́ ábē bembapɛɛ aá, “Syáā déchabe pɛd e edib eníníí.” ");
INSERT INTO bssNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Hɛ́ɛ ábē bembapɛɛ béchénné ene ndun e mod boŋ bésɔ̄lē á bɔ̌lɛ-tê wɛ́ɛ Yesuɛ ámbɛ̄ɛ̄ boŋ békɛɛné mɔ́. Myɔ̌lɛ mémpēe mémbɛ̄ áhed. ");
INSERT INTO bssNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ábwɔ̄g-ábwɔ̄g dɔ́ɔ ekukud é ngíne ébóótédé atóm, boŋ mendíb mésɔ̄lē á bɔ̌lɛ-tê nyaa echě bɔ̌lɛ bêmponné asú á mendíb sɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesuɛ ambɛ́ á bɔ̌lɛ-tê á pɛd e mbíd. Annaá ásē ábānē nló á mbóŋgé mîn, ákūneʼ. Hɛ́ɛ bényemɛɛ́ mɔ́ ásē, boŋ bélāŋgē mɔ́ bánken, “A meléed, weewóoʼɛ́ wɛ póndé ɛ́ɛ syánē dédíí á kwééd-te-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Hɛ́ɛ Yesuɛ átyéémé ámīn boŋ ákānnē échê ekukud áte aá éhɔ́ɔ, aláá-ʼɛ mendíb aá mésud. Ekukud énsōg awan, ekíde-ʼɛ éhɔ́ɔ́téd áte. ");
INSERT INTO bssNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Hɛ́ɛ Yesuɛ ásɛdtɛɛ́ bɔ́ aáken, “Cheé ékə́ə́ boŋ nyéwōgē mbwɔ́g? Nyéewóoʼɛ́ adúbe kə́ə́ŋ ne bɔɔb-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Boŋ mbwɔ́g ménkōb bɔ́ bwâmbwam, bésɛdté nhɔ́g ne aníníí bánken, “Ebə́l e mod éhéé chɛ́n éche kə́ə́ŋne ekukud ne mendíb béwógnɛɛ́?” ");
INSERT INTO bssNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesuɛ ne ábē bembapɛɛ bêmpɛ̌ á pɛd e edib eníníí, á mbwɔ́g e Gɛrasin. ");
INSERT INTO bssNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Áde Yesuɛ ábídé á bɔ̌lɛ-tê bídɛ́n, ambomɛ́n mod awě abídé á soóbadɛ. Edəə́dəŋ é mbéb émbɛ̄ ane mod áte. ");
INSERT INTO bssNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Á soóbadɛ dɔ́ɔ ádyɛ́ɛ́ʼáá. Modmod enkênhɛnlé mɔ́ abane á mehaŋ ámpē, ké ne bengɔbéngɔ̄bē. ");
INSERT INTO bssNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Áyə̄le ngen ne ngen, béhááʼáá mɔ́ ne eʼpwɔg ne bengɔbéngɔ̄bē boŋ ké nɛ̂ asɛléʼáá bengɔbéngɔ̄bē áhɛntéd-tɛ eʼpwɔg bɛ̂ áte. Antómtɛ́n ngíne awóŋ nyaa echě modmod éehɛleʼaá mɔ́ abwɔge. ");
INSERT INTO bssNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Atamnádtáá á soóbadɛ ne á eʼkone-tê nkuu ne mǔte, ábōnē eʼsaád ákwɛltáád-tɛ yə̌l ne meláá. ");
INSERT INTO bssNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ane mod abédé mwǎ etûn áde ányíné Yesuɛ. Hɛ́ɛ ányə́gté mehélé, boŋ ábwɔ̄gē mebóbóŋ áwē eʼsó-te, ");
INSERT INTO bssNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ábōnē esaád é ngíne, áhɔ̄bē aá, “A-Yesu, Mwǎn a Dyǒb á Ngum, cheé sóo déwóŋné? Ncháa wɛ á dǐn á Dyǒb mɛɛ́ weekɔ́gsán mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ane mod anhɔ́b nɛ̂ áyə̄le Yesuɛ anláá edəə́dəŋ é mbéb aá, “Á-edəə́dəŋ é mbéb, bíd ane mod áte!” ");
INSERT INTO bssNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Dɔ́ɔ Yesuɛ ásɛdtɛɛ́ mɔ́ aáken, “Chán dǐn ádíí wɛ?” Ankwɛntɛ́n aá, “Dǐn ádíí mɛ bán Amudtɛɛ, áyə̄le sêbuú áte.” ");
INSERT INTO bssNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ambɛ́ áchāā Yesuɛ aá eénānēʼ ábê eʼdəə́dəŋ bé mbéb ene mbwɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Bɔɔb-pɔɔ́, sáŋkalaa a esɔg é nguu chɔ́-ʼɛ ébédé bɛnbɛn ne áhed, édyāg medyɛ́ á mbám mé ekone. ");
INSERT INTO bssNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Hɛ́ɛ ábê eʼdəə́dəŋ bé mbéb éʼcháaʼɛ́ Yesuɛ bán, “Lóm sé á nguu-tê wɛ̂, émwɛ sésɔ̂l chɔ́ áte.” ");
INSERT INTO bssNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Hɛ́ɛ Yesuɛ ábágé bɔ́ kunze boŋ éʼbīdē ane mod áte. Abíd áde éʼbídé ane mod áte éʼsɔ̄lē échê nguu áte. Échê esɔg ébédé dyam eʼkə́lé éʼ nguu éʼbɛ. Ábwɔ̄g-ábwɔ̄g échê esɔg émpādē ásē, ényəgtéʼ á eláá é nkin mé edib-é-nzab, éhún á edib-tê, éhó-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Benɔn bé nguu béntōm mehélé á dyad-tê ne á mebwɔ́g ḿme médé bɛnbɛn, âkale bad dyam áde ábɛ́nlédé. Ábê bad bémbīd âkɛ dɛ́nyīn. ");
INSERT INTO bssNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Áde bépédé wɛ́ɛ Yesuɛ boŋ bényīn ane mod awě ndun e eʼdəə́dəŋ bé mbéb émbɛ̄ɛ̄ áte, nɛ́ɛ ádyɛ́ɛ́ ásē, ahédé-ʼɛ bwěm á yə̌l bwâm, adyɛɛ́-ʼɛ sɛn, mbwɔ́g ménkōb bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bad ábe bényīn ádê dyam bénlāā ábê bad ngáne êmbɛnlédté ne ane mod awě eʼdəə́dəŋ bé mbéb bémbɛ̄ɛ̄ áte. Bénlāā-ʼɛ bɔ́ dyam áde ábɛ́nlédé ne échê esɔg é nguu. ");
INSERT INTO bssNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hɛ́ɛ ábê bad bébóótédé Yesuɛ acháŋ bán ásyəə áwab mbwɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Áde Yesuɛ ásɔ́lɛɛ́ á bɔ̌lɛ-tê, ane mod awě eʼdəə́dəŋ bé mbéb bémbɛ̄ɛ̄ áte nɛ̂ ancháŋ mɔ́ aá búmɔ̄ békag. ");
INSERT INTO bssNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Boŋ Yesuɛ enkênkwɛntɛ́nné. Anláá mɔ́ aá, “Súɛ́ʼ áwôŋ dyad, ékɛ éláa áboŋ bad ndəle e dyam eche Sáŋgwɛ́ɛ́ ábɛ́nlé wɛ ne ngáne ápédé wɛ ngɔl awóg.” ");
INSERT INTO bssNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Hɛ̂ dɔ́ɔ ane mod áhídté boŋ ákag á mbwɔ́g e Dekapolis. Ákanlé mod tɛ́ dyam áde Yesuɛ ábɛ́nlé mɔ́. Bad bésyə̄ə̄l ábe bénwōg, yə̌l enkɔ́m bé áte bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesuɛ antǐm ámbīd á pɛd e edib eníníí ne bɔ̌lɛ. Áde ápédé á nkin ḿmíníí, ndun e mod enkaŋnɛ́n áhed. ");
INSERT INTO bssNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Dɔ́ɔ mod nhɔ́g awě akamlan ndáb e mekáne awě béchə́géʼáá bán Jairusɛ ápédé áhed. Anyín áde anyíné Yesuɛ, ankwɛ̌ ásē áwe mekuu. ");
INSERT INTO bssNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ne mecháŋgé mé ngíne áhɔ̄bē aá, “Awem mwǎn a mmwaád awâg. Sôn, hyɛ̌ ébân mɔ́ ekáá á yə̌l, âbɛl nɛ́n ádyɛɛ bwâm, ábɛ́-ʼɛ á aloŋgé.” ");
INSERT INTO bssNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Hɛ́ɛ Yesuɛ áhídé mɔ́. Ekud é bad éhídéʼáá Yesuɛ nyaa echě bênkaŋnɛ́nné mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mmwaád nhɔ́g-kɛ ambɛ́ áhed awě anwóŋ nkole ḿme mekií mébídéʼáá mɔ́ á yə̌l póndé ésyə̄ə̄l. Ḿmê nkole ḿbédé mɔ́ á yə̌l á etûn é dyôm-a-mwɛ́ ne ḿbɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Atagé híin á mekáá mé bad bé eʼbó, abébéd-tɛ ngáb esyəə́l echě ánwōŋgē, boŋ ké nɛ̂ enkêndyɛ́ʼɛ́ bwâm, nkole ḿbādē bádɛ́n. ");
INSERT INTO bssNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Anɛ́n mmwaád anwóg mam ḿme Yesuɛ ábɛ́léʼáá, dɔ́ɔ ábídé mɔ́ ámbīd átîntê ene ndun e mod boŋ ásitán mɔ́ nkobe. ");
INSERT INTO bssNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Áyə̄le anhɔ́b áwe nlém-tê aá nzé mɔ́sitɛ́né ké ḿmē nkobe, né mɔ́ɔdyɛɛ́ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Asitɛn áde ane mmwaád ásítɛ́né Yesuɛ nkobe, mekií ḿme mébídéʼáá mɔ́ á yə̌l ménsɛ̄lē, awóg-kɛ á yə̌l aá mɔ́choó. ");
INSERT INTO bssNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ábwɔ̄g-ábwɔ̄g Yesuɛ ambíi aá ngíne ebídé mɔ́ á yə̌l. Hɛ̂ dɔ́ɔ ákúnnédé átîntê ene ndun e mod, boŋ ásɛdté aáken, “Nzɛ́ɛ́ asitɛ́né mɛ nkobe?” ");
INSERT INTO bssNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Dɔ́ɔ ábē bembapɛɛ békwɛntanné mɔ́ bánken, “Nɛ́ɛ ényínɛɛ́ bad békáŋné wɛ á yə̌l nɛ́n ésɛdtéʼ wɛɛ́ ken nzɛ́ɛ́ asitɛ́né wɛ-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ké nɛ̂, Yesuɛ ambɛ́ ánɔnéʼ ekíde ânyín mod awě asitɛ́né mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Hɛ́ɛ ane mmwaád ábóótédé anəŋ ne mbwɔ́g áde ányíné chǒm-ɛ́ɛ ébɛ́nlédé mɔ́. Dɔ́ɔ ápédé wɛ́ɛ Yesuɛ boŋ ákwag mɔ́ á mekuu, álāŋgē mɔ́ mbále esyəə́l. ");
INSERT INTO bssNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ mɔ́ aá, “A mwǎn-a-mmwaád, adúbe ádōŋ ádídé wɛ bwâm. Kǎg ne nsaŋ. Ndutul echôŋ chɔ́-ʼɛ émaa.” ");
INSERT INTO bssNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Áde Yesuɛ áhɔ́bɛɛ́ nɛ̂, dɔ́ɔ bad behɔ́g ábe bébídé á ndáb wɛ́ɛ Jairusɛ bélâŋgɛɛ́ Jairusɛ bán, “Awoŋ mwǎn amaá mɔ́ awɛ́. Cheé étɔgnɛɛ́ Meléede ataged?” ");
INSERT INTO bssNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Boŋ Yesuɛ enkêntédté dyam áde béhɔ́bé nɛ́ɛ dyam. Hɛ́ɛ álâŋgɛɛ́ ane mod a nkamlɛn aá, “Weewógé mbwɔ́g! Dúbé dúbpɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesuɛ enkêmmwɛɛ́ aá mod ampée âhíd mɔ́ étōmɛɛ́ Petro ne Jemsɛ bɔ́ mwǎnyaŋ Jɔnɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Áde bépédé á ndáb wɛ́ɛ Jairusɛ dɔ́ɔ ányíné mpuutéd, awóg-kɛ mewɛ́ mé ngíne ḿme bad béchyɛʼɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Hɛ́ɛ ásɔ́lé á ndáb-te boŋ ásɛdté bɔ́ aáken, “Cheé ékə́ə́ boŋ nyébɛléʼ ḿmɛ́n mpuutéd, nyéchyɛ̌-ʼɛ mewɛ́? Ane mwǎn eewédɛɛ́, akúne kúnɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Boŋ bêmbootéd mɔ́ awɔɔ. Ambídéd bɔ́ mod asyəə́l á ebwɔ́g-te. Antéd ane mwǎn sáá bɔ́ nyaŋ ne ábē bembapɛɛ béláán, bésɔ̄l á toŋ echě ane mwǎn ámbɛ̄ɛ̄ áte. ");
INSERT INTO bssNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Hɛ́ɛ Yesuɛ áchə́ŋgé ane mwǎn á ekáá, boŋ álāŋgē mɔ́ aá, “Talíta kûm,” (awě adé bán, “A-mwǎn a ngɔndérɛ, nlâŋge wɛ mɛɛ́, hidé ásē.”) ");
INSERT INTO bssNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ane mwǎn anhidé ásē ábwɔ̄g-ábwɔ̄g, ábootéd-tɛ akɛ. (Abédé dyôm á mwɛ̌ ne ḿbɛ.) Yə̌l enkɔ́m bɔ́ áte híin áde nɛ́n ábɛ́nlédé. ");
INSERT INTO bssNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Hɛ́ɛ Yesuɛ ásímɛɛ́ bɔ́ etúu áte aá béēlāŋgē modmod dyam áde ábɛ́nlédé, aláá-ʼɛ bɔ́ aá bébɛ ane mwǎn ndyééd. ");
INSERT INTO bssNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesuɛ anhidé ádé hǒm, asú áwē dyad nchoo ne ábɛ̄ bembapɛɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nɛ́ɛ mbwɛ-mé-nkɔ́me-áte ḿpédé, ambootéd ayə́ged á ndáb e mekáne. Bad híin bémbɛ̄ áhed. Áde béwógé áde ayə́ge yə̌l enkɔ́m bɔ́ áte. Bésɛdté bánken, “Héé mɔ́ ábídné ḿmɛ́n mésyə̄ə̄l-ē? Ndín e debyɛ́ɛ́ éhéé bébágé mɔ́ nɛ́n? Chán ámwagké ḿmɛ́n menyáké abɛl-é? ");
INSERT INTO bssNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kíné saá kápɛ́ntaa ádíí-yɛ? Saá mwǎn awě Maria nɛ́n-ɛ? Kíné saá Jemsɛ, Josɛbɛ, Judasɛ ne Simɔnɛ bɔ́ɔ bédé baányaŋ-ɛ? Baányaŋ bé bebaád bésyə̄ə̄l-lɛ ámpē béedyɛɛ́ʼɛ́ ádyad-tê hɛ́n ne syánē-yɛ?” Né-ɔɔ́, bênkɔɔ́ Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Dɔ́ɔ álâŋgɛɛ́ bɔ́ aá, “Nkal eʼdəə́dəŋ awóoʼ edúbé hǒm ásyə̄ə̄l étómɛɛ́ áwē dyad, áwē túmbé-te ne áwē abum á ndáb.” ");
INSERT INTO bssNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Eéhɛlɛɛ́ menyáké ké mehɔ́g abɛl áhed, étómɛɛ́ nguse é bad bé nkole ábe ábáné mekáá á yə̌l, bédyɛ̄ɛ̄-ʼɛ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yə̌l enkɔ́m mɔ́ áte bwâmbwam ne adúbe ádē bad bénkênwóŋgé. Dɔ́ɔ Yesuɛ ákíí á myad mésad ḿme médé bɛnbɛn, áyə̄gtē bad. ");
INSERT INTO bssNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Anchɛ́lé ábē bembapɛɛ dyôm ne bébɛ. Anlǎd bɔ́ áte, alóm bɔ́ bébɛ ne bébɛ. Ambɛ̌-ʼɛ bɔ́ kunze âbíded bad eʼdəə́dəŋ bé mbéb áte. ");
INSERT INTO bssNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Anlyə́gtɛ́n bɔ́ aá, “Nyéewánlé chǒmchǒm á ekɛ étōmɛɛ́ ntóŋ. Nyéewánlé ndyééd kéʼɛ ekwɛ, mod eesóó-ʼɛ mɔné á mesó mé abad. ");
INSERT INTO bssNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nyéhɛ̂ metámbé boŋ nyéewánlé mbɔ́té ébɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ambád aá, “Ndáb ké ehéé echě ekobé nyé nyédyɛ̄ɛ̄ áhed kə́ə́ŋ ne póndé echě nyéhidtɛɛ́ ádê dyad. ");
INSERT INTO bssNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nzé nyêpedé dyad áde béekobɛɛ́ nyé, káa béekwɛntɛnɛɛ́ nyé awóglɛn, nyétɛ̄dē dɔ́, nyékūd-tɛ ebumbú á mekuu, âlúmed nɛ́n bán échab ebébtéd énɔne běn.” ");
INSERT INTO bssNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Né-ɔɔ́, bênkɛ̌ békaléʼ eyale é Dyǒb bán bad bétɛde ádab abɛ́ dé mbéb. ");
INSERT INTO bssNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bémbīdēd bad eʼdəə́dəŋ bé mbéb híin áte, béwɔ̄gtē bad bé nkole híin ne dyɔ̌g dé menzab, béchōōd bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Bɔɔb-pɔɔ́, Hɛrɔdɛ anwóg mam mésyə̄ə̄l ḿme Yesuɛ ábɛ́léʼáá. Áyə̄le mam mé bwâm ḿme Yesuɛ ábɛ́léʼáá mêmbɛ̌l ambyɛ́ɛn hǒm ásyə̄ə̄l. Doŋge á bad béhɔ́béʼáá bán, “Jɔnɛ, Ndusɛnɛ apuúdé. Nɛ́ɛ ákə́ə́ boŋ awóŋ ngíne âbɛl ḿmɛ́n menyáké mésyə̄ə̄l.” ");
INSERT INTO bssNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bémpēe béhɔ̄bē bán, “Elaijaa mɔ́ɔdé.” Ábíníí-ʼɛ bán, “Adíi nkal eʼdəə́dəŋ nɛ̂ŋgáne nhɔ́g átîntê e bekal béʼdəə́dəŋ ábe bémbɛ̄ seʼ bɔɔ́d.” ");
INSERT INTO bssNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Áde Hɛrɔdɛ áwógé nɛ̂ anhɔ́b aá, “Jɔnɛ, Ndusɛnɛ awě mêmbɛnlé boŋ bésɛ̄l nló mɔ́ɔdé. Atimé ámbīd á aloŋgé.” ");
INSERT INTO bssNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Hɛrɔdɛ anhɔ́b nɛ̂ áyə̄le anlóm bad aá békôb Jɔnɛ, béhaŋ mɔ́, béhɛ́-ʼɛ mɔ́ á mbwɔg. Ambɛl nɛ́n áyə̄le Hɛrodyasɛ, mwaád awě mwǎnyaŋ, Filibɛ ánsēbɛ̄ɛ̄ awóŋ, anwóŋ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jɔnɛ aláŋgéʼáá Hɛrɔdɛ póndé tɛ́ɛ́ aá, “Weewóoʼɛ́ kunze âwóŋ Hɛrodyasɛ, mmwaád awě mwǎnyoŋ.” ");
INSERT INTO bssNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Né-ɔɔ́, Hɛrodyasɛ anhíí Jɔnɛ pél á nlém-tê, áhɛdé-ʼɛ aá mɔ́wúu mɔ́. Boŋ Hɛrɔdɛ ambɛ̌l enkênhɛnlé. ");
INSERT INTO bssNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hɛrɔdɛ ambɛ́ mbwɔ́g áte tə̂ŋgɛne Jɔnɛ áyə̄le ambíi aá adíi mod a bwâm awě asáá. Né-ɔɔ́ akə̌ŋgé mɔ́ bwâm, âbɛl boŋ dyam dé mbéb déebɛnlád mɔ́. Adəə́ʼáá mɔ́ awóglɛn kénɛ́ɛ édíí bán póndé tɛ́ɛ́ nzé anwóglɛ́n mɔ́, atagéʼáá áte á mewêmtɛn-tê bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kə́ə́ŋne á asóg, Hɛrodyasɛ ankǔd nzii echě áhɛ́déʼáá. Nɛ́n ábédé epun-ɛ́ɛ Hɛrɔdɛ ábɛ́léʼáá ngande âwêmtɛn epun-ɛ́ɛ ánchyāādtē. Á ngande wɛ̂, Hɛrodɛ anlébé ábē bad bémbáá bé ngɔ́menaa, bad bémbáá bé sə́nze, ne kəse é bad é mbwɔg á Galilia. ");
INSERT INTO bssNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Échê epun mwǎn a mmwaád awě Hɛrodyasɛ anhyɛ̌ aság esáke. Nɛ̂ dénwōgēd Hɛrɔdɛ ne ábē beken menyiŋge. Né-ɔɔ́, Kə̂ŋ Hɛrɔdɛ ansɛdéd ane mwǎn a mmwaád aáken, “Cheé édə́ə́ wɛɛ́ ḿbɛ wɛ? Mɛ̌bɛ̌ wɛ kéchéé échě éhɛdɛɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nɛ́n dêmbɛ̌l ammwɛ́ melɛ̌, álāŋgē mɔ́ aá, “Mmwâg melɛ̌ mɛɛ́, měbɛɛ́ wɛ kéchéé éche éhɛdɛɛ́. Ké epɛd é mbwɔ́g échêm échě ńkamlanné.” ");
INSERT INTO bssNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Né-ɔɔ́ ane mwǎn ankɛ̌ nyaá asɛded aáken, “Cheé méhɛdɛ́nné mɔ́?” Dɔ́ɔ nyaá átímtɛ́né mɔ́ aá, “Hɛdɛ́n mɔ́ nló ḿme Jɔnɛ, Ndusɛnɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hɛ́ɛ ane mwǎn átímé ámbīd ábwɔ̄g-ábwɔ̄g wɛ́ɛ kə̂ŋ, boŋ álāŋgē mɔ́ aá, “Bǎg mɛ nló ḿme Jɔnɛ, Ndusɛnɛ á taplêt-te hɛ́n bɔɔb.” ");
INSERT INTO bssNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nɛ́n dénwōgēd kə̂ŋ Hɛrɔdɛ ndutul bwâmbwam, boŋ ngáne âmmadté melɛ̌ amwɛ́ áʼsō wɛ́ɛ ábê beken, enkênhɛnlé mɔ́ nló ḿme Jɔnɛ abáan. ");
INSERT INTO bssNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hɛ́ɛ álómé sə́nze pɔ́g aá épɛɛn nló ḿme Jɔnɛ. Ene sə́nze enkɛ̌ á ndáb e mbwɔg, esɛ́l Jɔnɛ nló, ");
INSERT INTO bssNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","épɛ̄ɛ̄n ḿmê nló á taplêt-te, ábɛ̄ ane mwǎn a mmwaád. Ane mwǎn a mmwaád mɔ́-ʼɛ ábɛ nyaá. ");
INSERT INTO bssNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Áde Jɔnɛ ábe bembapɛɛ béwógé nɛ̂, bêmpɛ̌, bétéd mɔ́ ndim, békɛ bélíme. ");
INSERT INTO bssNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Bembapɛɛ bé nlómag ábe Yesuɛ ánlōmmē bénhūu bétán mɔ́ béláá-ʼɛ mɔ́ mekan mésyə̄ə̄l ḿme bébɛ́lé ne ḿme béyə́gté. ");
INSERT INTO bssNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ekud é bad épágéʼáá wɛ́ɛ Yesuɛ ne ábē bembapɛɛ bétimé-ʼɛ ámbīd nyaa echě Yesuɛ ne ábē bembapɛɛ benkênwóŋgé etə́l âdyɛ́ ké ndyééd. Dɔ́ɔ Yesuɛ álâŋgɛɛ́ ábē bembapɛɛ aá, “Syáā détim á ahə́ŋgé á hǒm. Boŋ nyékɔ́me áte mwǎmpīn.” ");
INSERT INTO bssNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Hɛ̂ dɔ́ɔ bésɔ́lé á bɔ̌lɛ-tê, boŋ bétiméʼ á ahə́ŋgé á hǒm. ");
INSERT INTO bssNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ekud é bad énnyīn áde békagké, bênchěm-mɛ bɔ́ ábwɔ̄g-ábwɔ̄g. Ábê bad bémbīd myad ne myad, békɛ̄ɛ̄n mekuu, bényə̄gēd áʼsō ne mekuu, bésébé apɛ wɛ́ɛ Yesuɛ ne ábē bembapɛɛ békágéʼáá. ");
INSERT INTO bssNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Áde Yesuɛ ábídé á bɔ̌lɛ-tê boŋ anyín ene ndun e mod, antómtɛ́n bɔ́ ngɔl abɛ́ áyə̄le bébédé nɛ́ɛ ńdyɔŋ ḿ mbód ḿme méēwōo nnɔn. Né-ɔɔ́ ambootéd bɔ́ ekud é mekan ayə́ged. ");
INSERT INTO bssNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Áde bǐn éʼbóótédé ahín, ábē bembapɛɛ bémpɛ̌ áwē, béhɔ̄bē nɛ́n bán, “Hɛ́n ádé á etûn-tê, póndé emaá-ʼɛ atóm bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Láá ábɛ́n bad bétimeʼ á myad-tê ḿme médé bɛnbɛn, âbɛl běn béchan medyɛ́ ḿme bɛ́dyɛ̄ɛ̄.” ");
INSERT INTO bssNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Boŋ Yesuɛ antimtɛ́n bɔ́ aá, “Nyé bɔ́ nyébɛ bɔ́ chǒm éche bɛ́dyɛ̄ɛ̄.” Hɛ́ɛ bésɛdtɛɛ́ mɔ́ bánken, “Ehɛde wɛɛ́ sékɛ séchan eʼwɛle éʼ mbwɔ́kɛl é kábpe ébɛ, sébɛ bɔ́, bédyɛ̂-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Hɛ́ɛ ásɛdtɛɛ́ bɔ́ aáken, “Eʼwɛle éʼtə́ŋ nyéwóó? Nyékɛ nyénɔn.” Áde bémáá anɔn dɔ́ɔ bélâŋgɛɛ́ mɔ́ bán, “Eʼwɛle éʼdé éʼtáan ne súu ébɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ ábē bembapɛɛ aá bébɛl bad, békabɛn áte moŋge ne moŋge bédyɛɛ á nkəə́kəə mîn. ");
INSERT INTO bssNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Né-ɔɔ́ ábe bad bêndyɛɛ́ ásē, doŋge á moŋge, mbwɔ́kɛl é bad, doŋge-ʼɛ móom mé bad métáan. ");
INSERT INTO bssNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Hɛ̂ dɔ́ɔ Yesuɛ átédé ábɛ̂ eʼwɛle éʼtáan ne échê súu ébɛ, ánɔné ámīn, ásāgnān Dyǒb, ákabtáád bɔ́ áte, boŋ ábagé ábē bembapɛɛ aá békabpe ene ndun e mod. Ankabé-ʼɛ ábê bad kə́ə́ŋne échê súu ébɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Moosyəə́l andyɛ́, akód-tɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bembapɛɛ bênlǎd eʼwɛle ne súu éche ênlyə̌g ásē, enlón eʼlóŋ dyôm ne éʼbɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mesoŋgé mé baachóm ábe béndyɛ̄ ene ndyééd mémbɛ̄ eʼkə́lé éʼtáan. ");
INSERT INTO bssNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Melemlem mé póndé Yesuɛ anláá ábē bembapɛɛ aá bésɔ̂l á bɔ̌lɛ-tê, békag áʼsō á Betsaida, á múde mé edib-é-nzab ḿmíníí. Áde békagkɛ́ nɛ̂, anláá ene ndun e mod aá bésūɛ̄ʼ áwab mendáb. ");
INSERT INTO bssNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Áde Yesuɛ ámáá bɔ́ alyə́gtɛn, anchə́gé á ekone mîn, âkáne. ");
INSERT INTO bssNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nɛ́ɛ ngukɛ́l épédé, Yesuɛ ábē bembapɛɛ bémbɛ̄ɛ̄n bɔ̌lɛ átîntê e edib, Yesuɛ-ʼɛ abɛ́ á nkin mwěnpɛn. ");
INSERT INTO bssNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Annyín aá ábē bembapɛɛ bétage âkɛɛn bɔ̌lɛ áyə̄le epub é ngíne émbīd bɔ́ áʼsō-te. Né-ɔɔ́, dyam-ɛ́ɛ ádé epɔg-ne-ngwa ankɛ̌ bɔ́ atán, ákag á mendíb mîn. Ahɛdéʼáá aá mɔ́tôm bɔ́ ámīn. ");
INSERT INTO bssNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Boŋ anyín áde bényíné akag á mendíb mîn, bénwēmtɛ̄n bán nwú mɔ́ɔ ńdé. Hɛ́ɛ bébóótédé abón. ");
INSERT INTO bssNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Bébónéʼáá áyə̄le áde bényíné mɔ́, mbwɔ́g ménkōb bɔ́ moosyəə́l bwâmbwam. Ábwɔ̄g-ábwɔ̄g Yesuɛ anláá bɔ́ aá, “Nlém méēhūnē nyé, mɛɛ́ ndé. Nyéebááʼ.” ");
INSERT INTO bssNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Hɛ́ɛ ásɔ́lé á bɔ̌lɛ-tê wɛ́ɛ bémbɛ̄ɛ̄, epub-pɛ énsōg atóm. Yə̌l enkɔ́m ábe bembapɛɛ áte bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Yə̌l enkɔ́m bɔ́ áte áyə̄le bénkênsóŋtɛ́nné chǒm-ɛ́ɛ menyáké ḿme âmbɛnlé âdíde eʼkə́lé éʼ bad éʼtáan ńlûmtɛɛ́. Bénkênhɛnlé-ʼɛ achem. ");
INSERT INTO bssNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nɛ́ɛ béchábpé edib-é-nzab, bêmpɛ̌ á múde ḿmíníí, á mbwɔ́g e Gɛnesarɛt. Áhed-taá bêntəə́-ʼɛ́ bɔ̌lɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bébídé-ʼaá á bɔ̌lɛ-tê bídɛ́n bad béchēm-mɛ Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Hɛ́ɛ bényə́gté mbwɔ́g áte esyəə́l bépēmē bad bé nkole á mekále mîn, békɛɛnéʼ hǒm tɛ́ɛ́ áde bénwōgkē bán Yesuɛ adé. ");
INSERT INTO bssNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Hǒm tɛ́ɛ́-ʼɛ áde Yesuɛ ánkɛɛ́, á myad mémbáá ne mésad, ne wɛ́ɛ bad bélóó á nzag-tê, bad bépɛ́ɛ́néʼáá bad bé nkole wɛ́ɛ bad bébúdé aladɛn á dyad-tê âkáb nyoŋgé. Nɛ́ɛ bêmpɛɛ́nné bɔ́, béchāā mɔ́ bán ámwɛ bad bé nkole bésitɛn ké mesó mé mbɔ́té ḿmē. Né-ɔɔ́ bad bé nkole bésyə̄ə̄l ábe bênsitɛ́n ḿme mesó mé mbɔ́té béndyɛɛ́ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Befarisia ne doŋge dé bemeléede bé mbéndé ábe bémbīd á Jerusalɛm bênləŋnéd Yesuɛ âwóglɛn mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bénnyīn bán doŋge dé bembapɛɛ ábe Yesuɛ bédyâg medyɛ́ ne mekáá mé mbinde, nɛ́dē béewobpeʼaá mekáá nyaa echě Befarisia béhɔ́bɛɛ́ bán bétə́ŋgɛ́né awobe. ");
INSERT INTO bssNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Befarisia ne bad bé Israɛl ábe bélyə́gé ásē bésyə̄ə̄l béhīdē ayə́ge áde bênkudté wɛ́ɛ ábāb betaa. Béēdyāgkē ndyééd ésebán béwóbpé mekáá nyaa echě etə́ŋgɛ́né. ");
INSERT INTO bssNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Póndé echě mod ábídɛɛ́ á dyɔn-tê, eedyágké chǒmchǒm ésebán asébpé yə̌l awobe. Mbéndé édé-ʼɛ ámpē híin échě béhídɛɛ́, nɛ̂ŋgáne awobe á bwěm bwâm. Bwěm nɛ̂ŋgáne kɔ̂b, mbeé, kúmbe é eʼkii, ne bwěm nɛ́ɛ mebendé. ");
INSERT INTO bssNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Hɛ́ɛ Befarisia ne bemeléede bé mbéndé bésɛdtɛɛ́ Yesuɛ bánken, “Cheé ékə́ə́ boŋ ábōŋ bembapɛɛ béēhīdēʼ ayə́ge áde ábɛ̄d betaa bétɛ́dnédé sé? Bédyâg ndyééd áde béewopɛɛ́ mekáá nyaa echě éhɛdnadté.” ");
INSERT INTO bssNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesuɛ antimtɛ́n bɔ́ aá, “Nkal éʼdəə́dəŋ Yesayaa antə́ŋgɛ́n áde ánhɔ̄bpē ne eʼyale ábe Dyǒb dénlōmɛ̄nnē mɔ́ tə̂ŋgɛne nyé bedog-badɛ́, ngáne éténlédé nɛ́n, ‘Ábɛ̄n bad bébage mɛ edúbé é nsəl ngɛ̂n, boŋ ḿmab nlém méesaá áwêm. ");
INSERT INTO bssNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Edúbé éche bébagɛɛ́ mɛ éesaá dyamdyam, áyə̄le béyə́gte bad âhíd mbéndé é baányoŋ byánán édíi mbéndé é Dyǒb.’ ");
INSERT INTO bssNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nyêtɛ̌dté mbéndé é Dyǒb boŋ pɛn nyêhíde ayə́ge á baányoŋ.” ");
INSERT INTO bssNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Hɛ́ɛ Yesuɛ ábádɛɛ́ aá, “Nyêbɛnlad mwane âtɛde mbéndé é Dyǒb âbɛl nɛ́n nyéhíde ayə́ge ádɛ̄n děn. ");
INSERT INTO bssNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosɛɛ ahɔ́bé aá, ‘Bɛɛ́ sóó ne nyoŋ edúbé.’ Ahɔ́b-pɛ ámpē aá, ‘Kénzɛ́ɛ́ awě ahɔ́bé sáá kéʼɛ nyaá dyam dé mbéb áyə̄l bétə́ŋgɛ́né béwúú mɔ́.’ ");
INSERT INTO bssNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Boŋ nyêyə́gte nɛ́n bán nzé mod awóó chǒm éche ántə̄ŋgɛ̄nnē sáá kéʼɛ nyaá awôŋgɛn boŋ ahɔ́bé aá, ‘Échɛ́n chǒm édé Kɔ́ban,’ (Nɛ̂ adé bán édíi chǒm é Dyǒb), ");
INSERT INTO bssNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","né eewóoʼɛ́ nzɔm âwóŋgɛn sáá kéʼɛ nyaá. ");
INSERT INTO bssNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Né-ɔɔ́, ádê ayə́ge áde nyébagɛɛ́ bad ábɛ́lé nyéetédɛɛ́ eyale é Dyǒb nɛ́ɛ dyam. Mam médé-ʼɛ ámpē híin nɛ́ɛ ḿmɛ́n ḿme nyébɛlɛɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Hɛ́ɛ Yesuɛ áchɛ̂nlɛɛ́ ene ndun e mod boŋ álāŋgē bɔ́ aá, “Nyéwóglɛn, nyésôŋtɛn-nɛ mɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Chǒmchǒm éesaá éche ébíde á ebwɔ́g boŋ nɛ́ɛ ésɔ́lé mod áte ébɛl mɔ́ abɛ́ mbinde áʼsō é Dyǒb. Boŋ chǒm échě ébíde mod áte chɔ́ɔ ébɛle boŋ abɛ́ mbinde áʼsō é Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesuɛ anchené ene ndun e mod, asɔ́l á ndáb-te. Dɔ́ɔ ábē bembapɛɛ bépédé boŋ bélāŋgē mɔ́ bán átə̂nled bɔ́ ene ngan. ");
INSERT INTO bssNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Hɛ́ɛ Yesuɛ ákwɛntanné bɔ́ aáken, “Nyémpē nyéesóŋtánné-yɛ? Nyéenyínɛ́ɛ́ nɛ́n bán kéchéé éche ésɔ́lé mod áte, éche ébídé á mbíd e ebwɔ́g, éebɛlɛ́ɛ́-sɛ mod abɛ́ mbinde áʼsō é Dyǒb-ɛ? ");
INSERT INTO bssNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ngáne ésɔ́lɛɛ́ mod áte, éepagké mɔ́ á nlém-tê. Ébɛlé ésud mɔ́ dásɔ̄ á abum-tê ébíd-tɛ.” (Yesuɛ anhɔ́b nɛ̂ âlúmed nɛ́n aá ndyééd ké ehéé eboó adyɛ́.) ");
INSERT INTO bssNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ambád aá, “Chǒm échě ébídé mod áte chɔ́ɔ ébɛle boŋ eesááʼ áʼsō é Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Áyə̄le, á nlém ḿ mod-tê dɔ́ɔ mewêmtɛn mé mbéb nɛ̂ŋgáne akáb dé mésón, echîb, ne ewúɛn bébídɛɛ́. Ḿmê mewêmtɛn mɔ́ɔ mébɛlte mod mbéb. ");
INSERT INTO bssNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Akáb dé mesón á ndáb eʼwóŋgé, abɛ́ dé metɔg, ne abɛl á mam mé mbéb mémpēe nɛ̂ŋgáne edogké, âbɛl mbinde é mekan, akɔ́n á bad, akal á bad metóm áyə̄l, abɛ́ á kúmbe ne abɛl dé eʼyɔ́kɛ́l éʼ mekan. ");
INSERT INTO bssNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ḿmɛ́n mam mé mbéb mésyə̄ə̄l mébíde mod á nlém-tê mébɛlé-ʼɛ mod eesááʼ áʼsō é Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Dɔ́ɔ Yesuɛ ásyə́ŋgé boŋ ákǎg á epɛd é mbwɔ́g echě enchiitɛ́n myad mé Tirɛ ne Sidɔn. Hɛ́ɛ ásɔ́lé ndáb pɔ́g, eéhɛdeʼaá-ʼɛ aá modmod ábíi aá mɔ́dē áwēd-te. Ké nɛ̂ bémbɛ̄ bébíi. ");
INSERT INTO bssNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nɛ́ɛ mmwaád nhɔ́g awě edəə́dəŋ é mbéb ébédé awe mwǎn a mmwaád áte áwógé bán Yesuɛ adé áhed, ampɛ̌ ákwɛ̄-ʼɛ mɔ́ á mekuu. ");
INSERT INTO bssNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ane mmwaád abédɛ́ɛ mmwaád a aloŋ á Grikia awě béchyáá á pɛd e mbwɔ́g e Siria echě béchə́gɛɛ́ bán Fonisia. Hɛ́ɛ ácháaʼɛ́ Yesuɛ aá ábíded mwǎn échê edəə́dəŋ é mbéb áte. ");
INSERT INTO bssNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Boŋ Yesuɛ ankwɛntɛ́n mɔ́ aá, “Sé sébe sédíde běndem. Éesaá bwâm âtéd ndyééd e bǎnbǎn ábwēme mbwɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ane mmwaád ankwɛntɛ́n aá, “Nɛ̂ děn a-Sáŋ, boŋ kə́ə́ŋne mbwɛ́ echě edyɛɛ́ á tébelɛ-sɛ́ ebɛlé edyɛ́ púuted é medyɛ́ éche běndem béhúnté.” ");
INSERT INTO bssNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ mɔ́ aá, “Áyə̄le échɛ́n ehɔ́b éche éhɔ́bé nɛ́n, ehɛle ésūɛ̄ wɛ á ndáb. Edəə́dəŋ é mbéb éche ébédé awoŋ mwǎn áte étɛ́dté mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Né-ɔɔ́, ane mmwaád ansú á ndáb, atán nɛ̂ŋgáne mwǎn ánáŋgé á anɔn mîn. Echê edəə́dəŋ é mbéb êmmǎd mɔ́ atɛde. ");
INSERT INTO bssNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Hɛ́ɛ Yesuɛ áhídté á mbwɔ́g e Tirɛ, átimé á Sidɔn á pɛd e edib é Galilia, átimnád á pɛd e mbwɔ́g e Myad Dyôm. ");
INSERT INTO bssNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bad behɔ́g bêmpɛɛ́n mod áwē awě eewógneʼaá, eehɔ́beʼaá-ʼɛ dyam bwâm. Ábê bad bénchāŋ Yesuɛ bán ábân ane mod ekáá á yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Hɛ́ɛ Yesuɛ áhídnédé mɔ́ wɛ́ɛ ene ndun e mod édíí boŋ átīmɛ̄n mɔ́ á ahə́ŋgé á hǒm. Ansɔ́léd memii á metúu ḿme ane mod, ásob meléed boŋ ásitɛ́n mɔ́ echém. ");
INSERT INTO bssNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Hɛ́ɛ Yesuɛ ánɔ́né ámīn, áheeméd áte, boŋ áhɔ̄bē aá, “Efáta,” nɛ̂ ádé nɛ́n bán, “Dibnéd.” ");
INSERT INTO bssNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ábwɔ̄g-ábwɔ̄g, ane mod ábootéd-tɛ awógɛn, echém étyéém mɔ́ á nsəl, ábootéd-tɛ dyam ahɔ́b bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Hɛ́ɛ Yesuɛ ásímɛɛ́ bɔ́ etúu áte aá béētúbpé modmod ádɛ́n akan dǐn. Boŋ póndé tɛ́ɛ́ echě áhɔ́bé aá béehɔ́béʼ, bɔ́-ʼɛ bénabpé bɔ́ ahɔ́b hɔ́bɛ́n. ");
INSERT INTO bssNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bad bésyə̄ə̄l ábe bénwōg, yə̌l enkɔ́m bɔ́ áte nyaa echě echabé ámīn bwâmbwam. Béhɔ́béʼáá bán, “Abɛleʼ mam mésyə̄ə̄l bwâm. Abɛle kə́ə́ŋne bad bé ndɔ́g béwógneʼ, ábɛlɛ-ʼɛ eʼbóbé éʼhɔ̄bē dyam.” ");
INSERT INTO bssNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ḿmê mesú měn ndun e mod empée empɛ̌ wɛ́ɛ Yesuɛ. Ngáne bénkênwóŋgé chǒm-ɛ́ɛ bédyágkē, Yesuɛ anchɛ́lé ábē bembapɛɛ, álāŋgē bɔ́ aá, ");
INSERT INTO bssNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ndé enɛ́n ndun e mod ngɔl áyə̄le békébɛ̄ ne mɛ eʼpun éʼláán, béēwóo-ʼáa chǒm éche bédyákē bɔɔb. ");
INSERT INTO bssNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nzé nsúútɛ́né bɔ́ nzaa bɔɔb, né bɛ́hūn ásē á nzii áyə̄le bɔ́ doŋge á bad béchábé abíd.” ");
INSERT INTO bssNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Hɛ́ɛ ábē bembapɛɛ bétimtanné mɔ́ bánken, “Héé mod áhɛle ákud ndyééd á ehyáŋge-tê hɛ́n echě ěkwǒg ábɛ̄n bad adyɛ́-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesuɛ ansɛdéd bɔ́ aáken, “Eʼwɛle éʼtə́ŋ nyéwóó?” Bênkwɛntɛ́n bán, “Eʼwɛle saámbé.” ");
INSERT INTO bssNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Dɔ́ɔ álâŋgɛɛ́ ene ndun e mod aá bédyɛɛ ásē á ndɔɔb-tê. Hɛ́ɛ átédé ábɛ̂ eʼwɛle saámbé, ásāgnān Dyǒb, ákabtád bɔ́ áte, ábagé ábē bembapɛɛ, bɔ́-ʼɛ békabpé ene ndun e mod. ");
INSERT INTO bssNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bénwōŋ-ʼɛ baá nguse bé súu ésad. Yesuɛ annaméd chɔ́mpē. Amaá-ʼaá chɔ́ anamed, ábagé bembapɛɛ aá békabe bad. ");
INSERT INTO bssNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Bad béndyɛ̄ ene ndyééd, békód-tɛ, kə́ə́ŋ élyə̄g-kɛ ásē. Echě enlyə̌g ásē enlón eʼlóŋ saámbé. ");
INSERT INTO bssNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mesoŋgé mé bad ḿme méndyɛ̄ ene ndyééd mébédé dyam eʼkə́lé éʼniin. Yesuɛ ansúúd ábê bad áwab mendáb. ");
INSERT INTO bssNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Asúúté-ʼaá bɔ́ súútɛ́n, asɔ́l-lɛ mɔ́ á bɔ̌lɛ-tê ne ábē bembapɛɛ, békɛ̄-ʼɛ á mbwɔ́g e Dalmanuta. ");
INSERT INTO bssNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Befarisia bêmpɛ̌ wɛ́ɛ Yesuɛ bébootéd mɔ́ apentɛn, béhɛdné mɔ́ eʼchemléd ábe éʼhúú ádyōb. Bébɛ́léʼáá nɛ̂ âkəg mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Hɛ́ɛ Yesuɛ áhéémédé áte, boŋ áhɔ̄bē aáken, “Cheé ékə́ə́ boŋ nyoŋgɛl eʼchii éhɛdé eʼchemléd? Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, nyoŋgɛl eʼchii éekudté eʼchemléd kéʼ ehɔ́g.” ");
INSERT INTO bssNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Hɛ́ɛ áchénné bɔ́, boŋ ásɔ̄lē á bɔ̌lɛ-tê, átimé á pɛd e edib eníníí. ");
INSERT INTO bssNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Bɔɔb-pɔɔ́, áde bembapɛɛ ábe Yesuɛ bésɔ́lé á bɔ̌lɛ-tê, bênchatɛ́n eʼwɛle awále áyə̄l. Ewɛle ehɔ́g chěmpɛn chɔ́ɔ bênlyəgnédté á bɔ̌lɛ-tê. ");
INSERT INTO bssNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Nyétêd póndé ne esultɛn é Befarisia ne éche Hɛrɔdɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Dɔ́ɔ békalɛɛ́ běn ne běn bán, “Ahɔ́bé nɛ̂ áyə̄le deewânlɛɛ́ eʼwɛle áyə̄l.” ");
INSERT INTO bssNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesuɛ ambíi chǒm éche béhɔ́bɛɛ́, hɛ́ɛ ásɛdtɛɛ́ bɔ́ aáken, “Cheé nyéhɔ́bɛɛ́ áyə̄le eʼwɛle ábe nyéēwōoʼɛ́? Kə́ə́ŋ neʼ bɔɔb nyéebíiʼɛ́ kéʼɛ nyéesôŋtɛnɛɛ́-yɛ? Chán nyélɛ́lé nlém á abum nɛ́n? ");
INSERT INTO bssNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nyêwóó mǐd, nyéenyínnɛ́ɛ́-yɛ? Nyêwóó-ʼɛ metúu nyéewógnɛ́ɛ́-yɛ? Kə́ə́ŋne bɔɔb nyéēkamtánné-yɛ? ");
INSERT INTO bssNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Áde mênkabpé eʼwɛle éʼtáan âdíde eʼkə́lé éʼ bad éʼtáan, eʼlóŋ éʼtə́ŋ eʼwɛle ábe bênlyəg ásē ábe nyênladté bénlōnnē?” Bênkwɛntɛ́n mɔ́ bán, “Dyôm ne éʼbɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ambád bɔ́ asɛded ámpē aá, “Áde mênkabpé-ʼɛ ewɛle saámbé âdíde eʼkə́lé éʼ bad éʼniin, eʼlóŋ éʼtə́ŋ eʼwɛle ábe bênlyəg ásē ábe nyênladté bénlōnnē?” Bênkwɛntɛ́n mɔ́ bán, “Eʼlóŋ saámbé.” ");
INSERT INTO bssNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ambád bɔ́ asɛded aáken, “Boŋ ké nɛ̂ nyéesôŋtɛnɛɛ́-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesuɛ ne ábē bembapɛɛ bêmpɛ̌ á Betsaida. Áhed dɔ́ɔ bad behɔ́g bépɛ́ɛ́né mod awě akwedé ndím áwē, boŋ béchāā mɔ́ bán ábân mɔ́ ekáá á yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesuɛ anchə́ə́ ane mod á ekáá, áhidnéd mɔ́ á dyad-tê wɛ̂. Ansob mɔ́ meléed á mǐd, abán mɔ́ mekáá á yə̌l, boŋ ásɛdté mɔ́ aáken, “Enyíne chǒmchǒm-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Hɛ́ɛ ane mod ánɔ́né ámīn boŋ áhɔ̄bē aá, “Nnyíne bad boŋ bényînnad nɛ̂ŋgáne mɛl ḿme mékag.” ");
INSERT INTO bssNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Hɛ́ɛ Yesuɛ ábáné mɔ́ mekáá á mǐd ámpē. Dɔ́ɔ ane mod ákídté anɔn, mǐd mêndibnéd mɔ́, ábootéd-tɛ anyínɛn bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesuɛ ansúúd mɔ́ á ndáb, áhɔ̄bē aá, “Wɛ̌tɔgné-ʼɛ asɔ́l ádyad-tê ámpē.” ");
INSERT INTO bssNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesuɛ ne ábē bembapɛɛ békágéʼáá á myad ḿme médé á mbwɔ́g e Kaisaria Filipi. Bépédé-ʼaá á nzii wê, dɔ́ɔ ásɛdtɛɛ́ bɔ́ aáken, “Nzɛ́-módɛ́ bad bɔ́ béhɔ́bɛɛ́ bán ndé?” ");
INSERT INTO bssNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Hɛ́ɛ békwɛntanné bán, “Doŋge á bad béhɔ́be bán edíi Jɔnɛ Ndusɛnɛ, bémpēe bán Elaijaa, ábíníí-ʼɛ bán nkal éʼdəə́dəŋ nhɔ́g.” ");
INSERT INTO bssNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Dɔ́ɔ ásɛdtɛɛ́ bɔ́ ámpē aáken, “Boŋ nyéběn-nɛ nzɛ́-módɛ́ nyéhɔ́bɛɛ́ bán ndé?” Hɛ́ɛ Petro ákwɛntanné mɔ́ aá, “Wɛɛ́ edé Ane-awě-Béwɔ́gté.” ");
INSERT INTO bssNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Áde Petro amaá-ʼaá ahɔ́b nɛ̂, Yesuɛ ansím bɔ́ etúu áte aá béēlāŋgē modmod nyaa e mod echě mɔ́díí. ");
INSERT INTO bssNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesuɛ ambootéd ábē bembapɛɛ ayə́ged, áhɔ̄bē aá, “Mwǎn-a-Moonyoŋ atə́ŋgɛ́né ákūd metake híin. Bad bémbáá bé dyad, beprisɛ bémbáá ne bemeléede bé mbéndé bɛ́bāŋ-ʼɛ mɔ́ á yə̌l. Bɛ́wūū mɔ́, boŋ eʼpun ábe éʼlóntɛ́né éʼláán, ǎpuú.” ");
INSERT INTO bssNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesuɛ anhɔ́b ádɛ́n dyam nyaa echě énkênkoŋnédtɛ́ bɔ́ mbále ké pɔ́g. Hɛ́ɛ Petro átímné Yesuɛ á nkəg, boŋ ákəgé âtimed mɔ́ áte. ");
INSERT INTO bssNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Boŋ Yesuɛ ankuné, ánɔ̄n ábē bembapɛɛ. Dɔ́ɔ ákánné Petro áte aá, “Hidé mɛ áʼsō-te, a-Satan! Ḿmoŋ mewêmtɛn méesaá mewêmtɛn mé Dyǒb, médíi mewêmtɛn mé moonyoŋ.” ");
INSERT INTO bssNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Dɔ́ɔ Yesuɛ áchɛ́nlé ene ndun e mod ne ábē bembapɛɛ, boŋ álāŋgē bɔ́ aá, “Kénzɛ́ɛ́ awě adəə́ mɛ ahíd, ásob yə̌l mendíb, ápêm-mɛ ádē awɔg áhíde mɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Áyə̄le kénzɛ́ɛ́ awě ahɛde ádē aloŋgé asoŋ ǎbɔ̄d dɔ́. Kénzɛ́ɛ́-ʼɛ awě abɔ́dé ádē aloŋgé áyə̄le echêm ne áyə̄le ḿmɛ́n nkalaŋ ḿ bwâm né ǎkud aloŋgé áde déemaáʼ. ");
INSERT INTO bssNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nsyə́ə́ŋ ńhéé mod ákudté nzé akudé nkǒŋsé ńsyə̄ə̄l boŋ abɔ́dé ádē aloŋgé. ");
INSERT INTO bssNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Cheé mod áhɛlɛsɛ ábɛ âkɔde ádē aloŋgé? ");
INSERT INTO bssNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kénzɛ́ɛ́ awě ǎkwāgɛ̄n mɛ ne ábêm eʼyale á nyoŋgɛl eʼchii echě ehídne Dyǒb nlém ḿbɛ, abɛ́-ʼɛ ebébtéd, Mwǎn-a-Moonyoŋ mɔ́ ámpē ǎkwāgɛ̄n mɔ́ á póndé echě ápɛɛ́ ne ángɛl échě ésáá ne ehúmé éche Sáá.” ");
INSERT INTO bssNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Hɛ́ɛ álâŋgɛɛ́ bɔ́ aá, “Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, doŋge á bad átîntê echɛ̂n béenyínɛ́nné kwééd dǐd áde bényínɛɛ́ nɛ́ɛ nkamlɛn ń Dyǒb ḿpédé ne ngíne.” ");
INSERT INTO bssNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ámbīd e epun ntóób Yesuɛ ankɛɛ́n Petro, Jemsɛ ne Jɔnɛ á mbɔɔd echě echabé ámīn. Běmpɛn-ɛɛ́ bémbɛ̄ áhed. Áwāb eʼsó-te hɛ̂ dɔ́ɔ ábē bembapɛɛ bényíné nɛ́ɛ Yesuɛ áhə́ŋlɛ́né. ");
INSERT INTO bssNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Mbɔ́té éche ánhɛ̄ɛ̄ épɛné áte, épūbē-ʼɛ féréd. Épúbéʼáá nyaa echě modmod á nkǒŋsé éehɛlɛ́ɛ́-sɛ apúbed. ");
INSERT INTO bssNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Hɛ́ɛ bényíné Mosɛɛ ne Elaijaa bébídé təléd, bɔ́ɔbɛ Yesuɛ békaleʼ. ");
INSERT INTO bssNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Dɔ́ɔ Petro álâŋgɛɛ́ Yesuɛ aá, “A meléed, ébóó ngáne syáā dédíí hɛ́n. Délôŋ eʼbem éʼláán, échôŋ, éche Mosɛɛ ne éche Elaijaa.” ");
INSERT INTO bssNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petro enkêmbííʼɛ́ chǒm éche áhɔ́bɛɛ́ áyə̄le mbwɔ́g ń ngíne ḿme mémbɛ̄ bɔ́ɔbɛ baáb á yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hɛ̂ dɔ́ɔ mbag ékútɛ́né bɔ́ boŋ ehɔ́b-pɛ ébīdēʼ á mbag-tê wɛ̂ nɛ́n, “Awem Mwǎn a nlém nɛ́n, nyéwógne mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ábwɔ̄g-ábwɔ̄g dɔ́ɔ bénɔ́né ekíde boŋ béenyíne modmod ampée nzése Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Áde bésudɛɛ́ á mbɔɔd mîn nɛ̂, Yesuɛ ansím bɔ́ etúu áte, álāŋgē bɔ́ aá, “Nyéeláŋgé modmod dyam áde nyényíné kə́ə́ŋ ne á póndé echě Mwǎn-a-Moonyoŋ ápuúʼɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Né-ɔɔ́, ábê bembapɛɛ bênkoó áde dyam ne běn, bésɛdté yə̌l chǒm-ɛ́ɛ mpuu ńdíí. ");
INSERT INTO bssNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Hɛ́ɛ bésɛdtɛɛ́ Yesuɛ bánken, “Cheé ékə́ə́ boŋ bemeléede bé mbéndé béhɔ́bé nɛ́n bán Elaijaa atə́ŋgɛ́né asébe dé apɛ boŋ Ane-awě-Béwɔ́gté ǎpɛ̌?” ");
INSERT INTO bssNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Dɔ́ɔ átimtanné bɔ́ aá, “Ne mbále Elaijaa atə́ŋgɛ́né asébe dé apɛ atíí-ʼɛ mam mésyə̄ə̄l. Cheé-ɔ̄ ékə́ə́ boŋ étenléd á kálag e Dyǒb nɛ́n bán Mwǎn-a-Moonyoŋ ǎkǔd metake híin, bad bébáŋ-ʼɛ mɔ́ á yə̌l? ");
INSERT INTO bssNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Boŋ nlâŋge nyé nɛ́n mɛɛ́ Elaijaa ammǎd apɛ, bêmbɛ̌l-lɛ mɔ́ ngáne bêndəŋgé. Nɛ̂ dénlōnēd mam ḿme mêntenléd áyə̄l e echê.” ");
INSERT INTO bssNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Áde bépédé wɛ́ɛ ábíníí bembapɛɛ bébédé, béntān nɛ́ɛ ndun e mod élə́ŋnédé bɔ́. Bemeléede bé mbéndé bépéntánnáá ne bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Anyín áde ábê bad bényíné Yesuɛ, menyáké ménkōb bɔ́ bwâmbwam. Bênnyəgéd áwē âlɛled mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Hɛ́ɛ Yesuɛ ásɛdtɛɛ́ ábɛ̄ bembapɛɛ aáken, “Cheé nyáābɔ̄ɔ nyépentanné?” ");
INSERT INTO bssNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dɔ́ɔ mod nhɔ́g átîntê e ene ndun e mod ákwɛntanné aá, “A-meléed, mpɛɛ́né awêm mwǎn a mwɛnchóm áwōŋ áyə̄le edəə́dəŋ é mbéb édé mɔ́ áte, ébɛ́lé eehɔ́bɛ́ɛ́-ʼɛ dyam. ");
INSERT INTO bssNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nzé ékóbé mɔ́, ébɛlé éhūnēd mɔ́ ásē, mehod-tɛ mébídé mɔ́ á nsəl. Ene póndé ádyāg mesoŋ á nsəl, anámɛ́n-nɛ. Nláŋgé-ʼɛ ábōŋ bembapɛɛ mɛɛ́ bébíded mɔ́ chɔ́ áte boŋ béehɛlɛɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Dɔ́ɔ Yesuɛ ákwɛntanné aá, “Wáā, nyé bad béʼ chii, nyéewóoʼɛ́ adúbé. Chán mɛ́pɛɛ́ nyé adyɛn hɛ́n-ēē? Chán mépɛɛ́ nyé awɛsɛ́n-é? Hyɛnáád mɛ mwǎn awed.” ");
INSERT INTO bssNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dɔ́ɔ bépíínédé mɔ́ ane mwǎn. Anyín ádě échê edəə́dəŋ é mbéb ényíné Yesuɛ, ênsǒg ane mwǎn, éhūnēd mɔ́ ásē, áhə̄ŋlād á ndɔɔb, mehod-tɛ mébīdē mɔ́ á nsəl. ");
INSERT INTO bssNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Hɛ́ɛ Yesuɛ ásɛdtɛɛ́ sáá aáken, “Á etûn é póndé éhéé ákɛ́tagké nɛ́n?” Dɔ́ɔ sáá ákwɛntanné aá, “Bootya se á mwěndemé. ");
INSERT INTO bssNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Éyɔ́gké mɔ́ ahúned á muú-te ne á mendíb-te âwúu mɔ́. Boŋ nzé dyam ádé áde éhɛlɛɛ́-sɛ ébɛl, ewóg sé ngɔl, ewóŋgɛ́n sé.” ");
INSERT INTO bssNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Hɛ́ɛ Yesuɛ átímtɛ́né mɔ́ aá, “Wɛɛ́ nzé dyam ádé ádě ńhɛlɛɛ́ se ḿbɛl-ɛ? Chǒm ésyə̄ə̄l éhɛle ébɛnled ne mod awě awóó adúbe.” ");
INSERT INTO bssNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ábwɔ̄g-ábwɔ̄g dɔ́ɔ ane mwǎn sáá ákánté ehɔ́b ámīn aá, “Ndúbpé, wóŋgɛ́n adúbe ádêm áde déekwognede.” ");
INSERT INTO bssNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ndun e mod enyə̌gtéʼáá âladɛn áte áhed. Áde Yesuɛ ányíné nɛ̂, ankáné échê edəə́dəŋ é mbéb áte aá, “Á-edəə́dəŋ é ndɔ́g ne é ebóbé, nkamlan wɛ mɛɛ́ ébîd mɔ́ áte, weesɔ́lé-ʼɛ mɔ́ áte ámpē.” ");
INSERT INTO bssNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Échê edəə́dəŋ élébpé-ʼaá esaád, éságéd ane mwǎn ne ngíne, ébíd-tɛ. Ane mwǎn antǐm nɛ́ɛ ndim ḿ mod kə́ə́ŋ doŋge á bad béhɔ̄bē bán, “Awédé.” ");
INSERT INTO bssNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Boŋ nɛ́ɛ Yesuɛ áchə́ŋgé mɔ́ á ekáá, átīīdē mɔ́ ámīn, ane mwǎn atyéém-mɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesuɛ ansɔ́l á ndáb-te. Hɛ́ɛ ábɛ̄ bembapɛɛ bésɛdtɛɛ́ mɔ́ á kun-tê, bánken, “Cheé ênkə̌ŋ boŋ sênkênhɛ̌l échê edəə́dəŋ é mbéb abíded?” ");
INSERT INTO bssNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ankwɛntɛ́n bɔ́ aá, “Mekáne mwěmpɛn mɔ́ɔ méhɛle mébídéd enɛ́n ndín e edəə́dəŋ.” ");
INSERT INTO bssNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesuɛ ne ábɛ̄ bembapɛɛ béhídté-ʼaá hɛ̂, bépōŋ á mbwɔ́g é Galilia. Enkênmwaá aá modmod ábíi wɛ́ɛ mɔ́díí, ");
INSERT INTO bssNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","áyə̄le ayə́gtéʼáá ábē bembapɛɛ aá, “Bɛ́bɛ̌ Mwǎn-a-Moonyoŋ á mekáá mé baányoŋ. Bɔ́-ʼaá bɛ́wūū mɔ́. Nzé bémáá-ʼɛ mɔ́ awúu ǎpuú ámbīd e epun éʼláán.” ");
INSERT INTO bssNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Boŋ ábɛ̄ bembapɛɛ béenkênsóŋtɛ́nné chǒm éche ánhɔ̄bpē, bébááʼáá-ʼɛ mɔ́ asɛded. ");
INSERT INTO bssNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesuɛ ne ábē bembapɛɛ bêmpɛ̌ á Kapenahum. Áde bépédé, bénsɔ̄l á ndáb-te. Dɔ́ɔ Yesuɛ ásɛdtɛɛ́ bɔ́ aáken, “Cheé nyéswáŋtánnáá á nzii bwéed?” ");
INSERT INTO bssNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Boŋ bénkênhɔ́bpé dyamdyam áyə̄le běn ne běn bépéntánnáá tə̂ŋgɛne mod awě atómtɛ́né mod ambáá abɛ́ átîntê echâb. ");
INSERT INTO bssNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Hɛ́ɛ Yesuɛ ádyɛ́ɛ́ ásē, áchəgé ábē bembapɛɛ dyôm ne bébɛ boŋ álāŋgē bɔ́ aá, “Kénzɛ́ɛ́ awě ahɛde mod a mbáá abɛ́, atə́ŋgɛ́né abɛ́ ndimtɛne, abɛ́-ʼɛ mbəledɛ a moosyəə́l.” ");
INSERT INTO bssNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Hɛ̂ dɔ́ɔ átédé mwɛ̌ndem boŋ átīīdē mɔ́ áwab tîntê. Dɔ́ɔ abwáádé ane mwǎn, boŋ áhɔ̄bē aá, ");
INSERT INTO bssNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kénzɛ́ɛ́ awě akobé enɛ́n ndín e mwǎn á dǐn ádêm, né akobé mɛ. Kénzɛ́ɛ́-ʼɛ awě akobé mɛ, eékobɛɛ́ mměn-pɛn. Akobé kə́ə́ŋne ane awě alómé mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jɔnɛ anláá Yesuɛ aá, “A meléed sênnyín mod abídte bad eʼdəə́dəŋ bé mbéb áte á dǐn ádōŋ, sênláá-ʼɛ mɔ́ bán ásôg abɛl nɛ̂, áyə̄le eésaá mod a echoŋ éche syánē.” ");
INSERT INTO bssNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Boŋ Yesuɛ anláá bɔ́ aá, “Nyéeláŋgé mɔ́ bán ásôg abɛl nɛ̂. Mod ké nhɔ́g eésaá awě ǎmad menyáké abɛl á dǐn ádêm, boŋ ámbīd e póndé áhɔ̄bē mɛ mam mé mbéb á yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Áyə̄le, kénzɛ́ɛ́ awě eetə́ŋgán syánē né adé ne syánē. ");
INSERT INTO bssNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, kénzɛ́ɛ́ awě abagé nyé ké kɔ̂b e mendíb âmwɛ́ á dǐn ádêm, áyə̄le nyédíí bad bé Krǐsto, atə́ŋgɛ́né ḿme nsábe akud. ");
INSERT INTO bssNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Kénzɛ́ɛ́ awě abɛ̌lté enɛ́n ndín e mwěndem echě edúbpé mɛ mbéb, ébɛ̄ mboŋ âtəə mɔ́ sáŋkalaa aláá á nkə́ŋ, béhúnéd-tɛ mɔ́ á edíb é nkwɛ̌. ");
INSERT INTO bssNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nzé échoŋ ekáá ébɛlte wɛ mbéb, esɛ́l chɔ́, épim. Édé mboŋ wɛ âkud aloŋgé áde déemaáʼ ne epɛd é yə̌l tómaa wɛ âwóŋ mekáá mébɛ boŋ bébwém wɛ á dǔ-á-muú. ");
INSERT INTO bssNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nzé échoŋ ekuu ébɛlte wɛ mbéb, esɛ́l chɔ́, épim. Édé wɛ mboŋ âkud aloŋgé áde déemaáʼ ne epɛd é yə̌l tómaa wɛ âwóŋ mekuu mébɛ, boŋ bébwém wɛ á dǔ-á-muú. ");
INSERT INTO bssNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nzé ádoŋ dǐd ábɛlte wɛ mbéb, ehúd dɔ́, épim. Édé mboŋ wɛ âsɔ́l á nkamlɛn ń Dyǒb ne dǐd ahɔ́g tómaa wɛ âwóŋ mǐd mébɛ boŋ bébwém wɛ á dǔ-á-muú. ");
INSERT INTO bssNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Áhed, ‘eʼkuu ábě éʼdyāg bad béēwāgkē, muú ḿmed-tɛ méēdīmɛ̄ɛ̄.’ ");
INSERT INTO bssNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Muú mɛ́nyə̄ə̄ mod ké ahéé á yə̌l ngáne nkwɛ̌ ńnyə̂ŋgɛɛ́ á ndyééd-te. ");
INSERT INTO bssNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nkwɛ̌ ḿbóó, boŋ nzé ḿbɔ́dé alaŋ, chán béhɛle-sɛ bényīnēd mɔ́ ámpē? Nyényineʼ nɛ́ɛ nkwɛ̌, nyédyɛɛ-ʼɛ ne nsaŋ ne nhɔ́g ne aníníí.” ");
INSERT INTO bssNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesuɛ anhidé ádê abwɔ́g á hǒm, ampǒŋ á mbwɔ́g e Judeya, áchābē á pɛd e edíb é Jodan eníníí. Ndun e mod epagéʼáá áwē, áyə̄gtē-ʼɛ bɔ́ ngáne âmɛntɛ́nné bɔ́ ayə́ged. ");
INSERT INTO bssNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Befarisia bémpɛ̌ áwē âkəg mɔ́. Bênsɛdéd mɔ́ bánken, “Echɛd mbéndé chɔ́chɔ́ ebagé kunze nɛ́n mod ánan mwaád á eʼwóŋgé-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Hɛ́ɛ Yesuɛ átimtanné bɔ́ aáken, “Chán mbéndé eche Mosɛɛ ékalɛɛ́?” ");
INSERT INTO bssNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bênkwɛntɛ́n bán, “Mbéndé echě Mosɛɛ ebagé kunze nɛ́n, mod ábɛ mwaád kálag echě elûmte nɛ́n bán, eʼwóŋgé éʼmáá boŋ ǎnan mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Eʼlɛl bé nlém á abum ábɛ̄n bɔ́ɔ bêmbɛ̌l boŋ Mosɛɛ ábɛ nyé échɛ́n mbéndé. ");
INSERT INTO bssNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Boŋ se á mbooted, áde Dyǒb áhə́gé bad, anhə̌g mmwaád bɔ́ mwɛnchóm. ");
INSERT INTO bssNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Né-ɔɔ́, mwɛnchóm ǎtɛdé sáá ne nyaŋ, abɛ́ ne mwaád. ");
INSERT INTO bssNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Búmɔ̄ bad bébɛ bétīm mod nhɔ́g.’ Né-ɔɔ́, béesaá ámpē bad bébɛ, boŋ bédíi mod nhɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Né-ɔɔ́, échě Dyǒb áládé, modmod eepááʼ.” ");
INSERT INTO bssNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Áde bétímé ámbīd á ndáb-te, Yesuɛ ábɛ̄ bembapɛɛ bênsɛdéd mɔ́ tə̂ŋgɛne dyam áde áhɔ́bé. ");
INSERT INTO bssNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Kénzɛ́ɛ́ awě anané mwaád boŋ awóŋ mmwaád ampée né akábé asón. ");
INSERT INTO bssNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nzé mmwaád-tɛ atɛ̌dté nchóm boŋ awóó mod ampée, né akábé asón.” ");
INSERT INTO bssNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bad bépɛ́ɛ́néʼáá běndem wɛ́ɛ Yesuɛ bán ábân bɔ́ ekáá á yə̌l ânamed bɔ́. Boŋ ábɛ̄ bembapɛɛ bénkānē ábê bad áte. ");
INSERT INTO bssNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Áde Yesuɛ ányíné nɛ̂, anlǐŋ, aláá-ʼɛ ábē bembapɛɛ aá, “Nyétɛde běndem béhyag áwêm. Nyéekə́ə́ bɔ́ áyə̄le nɛ́n nyaa e bad nɛ́ɛ bɔ́ chɔ́ɔ éwóó nkamlɛn ń Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ne mbále nlâŋge nyé nɛ́n mɛɛ́, kénzɛ́ɛ́ awě eékobe nkamlɛn ń Dyǒb nɛ̂ŋgáne mwěndem, éesɔ́nlé áwēd-te.” ");
INSERT INTO bssNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Hɛ́ɛ Yesuɛ áládé ábɛ̂ bǎn áte, ábānē bɔ́ mekáá á nló nhɔ́gē-nhɔ́gē, ánamté-ʼɛ bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Áde Yesuɛ ábwɔ́gké ekɛ ámpē, dɔ́ɔ mod nhɔ́g ányə́gté áwē, abwɔ́g mebóbóŋ áwē eʼsó-te, boŋ ásɛdté mɔ́ aá, “A-meléed a bwâm, dyam áhéé ntə́ŋgɛ́né abɛl, âbɛl nɛ́n ńkud aloŋgé áde déemaáʼ?” ");
INSERT INTO bssNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Hɛ́ɛ Yesuɛ ásɛdtɛɛ́ mɔ́ aáken, “Cheé ékə́ə́ boŋ échəgé mɛ meléede a bwâm? Mod ké nhɔ́g eésaá mod a bwâm étōmɛɛ́ Dyǒb děmpɛn. ");
INSERT INTO bssNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ebíí mbéndé éche éhɔ́be bán, ‘Weewúɛ́ʼ mod, weekábé asón á ndáb eʼwóŋgé, weechíbéʼ, weebídé mbóŋ e metóm, weédōgē bad, bɛɛ́ sóó ne nyoŋ edúbé.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Hɛ́ɛ ane mod áhɔ́bɛɛ́ aá, “A meléed, nhídé échɛ́n mbéndé ésyə̄ə̄l bootya se á mwěndemé.” ");
INSERT INTO bssNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Hɛ́ɛ Yesuɛ ánɔnɛɛ́ mɔ́ chóóŋ ne nlém mé edəŋge, boŋ álāŋgē mɔ́ aá, “Dyam ahɔ́g áhɛdne wɛ. Kǎg, ésôm bwěm éʼsyə̄ə̄l ábe éwóó, étêd ḿmé mɔné, ébɛ betóótōkɛ̄ bé bad. Nzé ebɛlé nɛ̂, wɛ̌kǔd nhɔn ádyōb. Ene póndé éhyɛ éhíde mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Áde ane mod áwógé nɛ̂ ansudɛ́n, asú-ʼɛ ne ndutul á nlém-tê áyə̄le ambɛ́ nhɔn bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Hɛ́ɛ Yesuɛ ákúnné mǐd wɛ́ɛ ábē bembapɛɛ boŋ álāŋgē bɔ́ aá, “Élɛ̌l áte bwâmbwam behɔn bé bad âsɔ́l á nkamlɛn ń Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Eʼyale ábɛ Yesuɛ bénkɔ̄mēd ábɛ̄ bembapɛɛ yə̌l áte. Ambád ahɔ́b ámpē aá, “A-baányaŋ élɛ́lé áte bwâmbwam âsɔ́l á nkamlɛn ń Dyǒb! ");
INSERT INTO bssNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Édé mwǎn e akan sáŋkalaa a nyam nɛ́ɛ Kamɛ̂l âpoŋ á epɔn é ndɔnde tómaa nhɔn ḿ mod âsɔ́l á nkamlɛn ń Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Áde bembapɛɛ béwógé nɛ̂ yə̌l enkɔ́m bɔ́ áte bwâmbwam. Hɛ́ɛ běn ne běn béhɔ́bɛɛ́ bánken, “Nzɛ́ɛ́-ʼɔ̄ ahɛle ákud eʼsoósoŋ?” ");
INSERT INTO bssNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Hɛ́ɛ Yesuɛ ánɔnɛɛ́ bɔ́ chóóŋ, boŋ áhɔ̄bē aá, “Ne baányoŋ nɛ́n déehɛlɛɛ́ se abɛnled, boŋ ne Dyǒb dyamdyam déelɛlɛɛ́ áte.” ");
INSERT INTO bssNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Hɛ́ɛ Petro áhɔ́bɛɛ́ aá, “Nɔnéʼ, sêtɛ̌dté chǒm ésyə̄ə̄l âhíd wɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Dɔ́ɔ Yesuɛ áhɔ́bɛɛ́ aá, “Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, kénzɛ́ɛ́ awě atɛ̌dté eche ndáb, baányaŋ, nyaá, sáá, bǎn ne eche mbwɔ́g áyə̄l echêm, ne áyə̄l e nkalaŋ ḿ bwâm, ");
INSERT INTO bssNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ǎkǔd tómaa ne nɛ̂ á aloŋgé déʼ chii. Ǎkǔd ndáb, baányaŋ, bǎn, ne mbwɔ́g mbwɔ́kɛl é ngen. Ǎkǔd-tɛ kə́ə́ŋne metake á dǐn ádêm. Ǎkud-tɛ aloŋgé áde déemaáʼ á póndé échě ehúɛʼ ");
INSERT INTO bssNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Boŋ bad híin ábe bédé áʼsō bɔɔb bɛ́lyəg mbíd, híin-nɛ ábe bénlyəg mbíd bɛ́bē áʼsō.” ");
INSERT INTO bssNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesuɛ ne ábɛ̄ bembapɛɛ békágéʼáá á akuu á Jerusalɛm, mɔ́-ʼaá antómɛ́n bɔ́. Yə̌l enkɔ́m ábē bembapɛɛ áte bwâmbwam, mbwɔ́g-kɛ ńkób bad ábe béhídéʼáá bɔ́. Áde békagkɛ́ nɛ̂, dɔ́ɔ Yesuɛ átímné ábē bembapɛɛ á nkəg ámpē boŋ álāŋgē bɔ́ mam ḿme mɛ́bɛnléd ne mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Hɛ́ɛ áhɔ́bɛɛ́ aá, “Pɔ́n nyébíi bán dekag á Jerusalɛm, áwed-taá bɛ́bɛɛ́ Mwǎn-a-Moonyoŋ á mekáá mé beprisɛ bémbáá ne bemeléede bé mbéndé. Bɔ́-ʼɛ bɛ́bɛ̌ mbakú bán atə́ŋgɛ́né awɛ́, bɛ́bɛ̌-ʼɛ mɔ́ á mekáá mé bad ábe béesɛ̌ bad bé aloŋ á Israɛl. ");
INSERT INTO bssNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Béwɛlé mɔ́, bésobtád mɔ́ meléed á yə̌l, béswādtāād mɔ́ eʼtaŋgú, béwúú-ʼɛ mɔ́. Boŋ ámbīd e eʼpun éʼláán ǎpuú.” ");
INSERT INTO bssNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ámbīd e nɛ̂ Jemsɛ bɔ́ Jɔn, bǎn ábɛ Zɛbɛdiɛ bêmpɛ̌ wɛ́ɛ Yesuɛ. Áde bépédé, bénlāā mɔ́ bán, “A meléed, dyam ádé áde séhɛdɛɛ́ bán ébɛle sé.” ");
INSERT INTO bssNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Hɛ́ɛ Yesuɛ ásɛdtɛɛ́ bɔ́ aáken, “Cheé nyéhɛdɛɛ́ bán ḿbɛle nyé.” ");
INSERT INTO bssNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Dɔ́ɔ béhɔ́bɛɛ́ bán, “Sêhɛde bán áde wɛ́dyɛɛ́ʼɛ́ ádōŋ atii dé nkamlɛn, émwɛ sédyɛɛ wɛ á nkəg, nhɔ́g á ekáá émbáá aníníí-ʼɛ á ekáá é emwɛd.” ");
INSERT INTO bssNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Hɛ́ɛ Yesuɛ ákwɛntanné bɔ́ aá, “Nyéebíiʼɛ́ chǒm éche nyésɛdtɛɛ́. Nyɛ́ɛ̄hɛ̌l metuné ḿme mɛ́pēmmē apém-ɛ? Nyɛ́ɛ̄hɛ̌l edusɛn é metuné éche mɛ́kudté akud-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Dɔ́ɔ békwɛntanné mɔ́ bán béhɛ̌l. Hɛ́ɛ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Nyɛ́ɛ̄pēm metuné ḿme mɛ́pēmmē, nyɛ́ɛ̄kǔd edusɛn é metuné échě mɛ́kudté, ");
INSERT INTO bssNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","boŋ meewóoʼɛ́ kunze âpwɛd mod awě ǎdyɛɛ́ mɛ á ekáá é mbáá kéʼɛ á ekáá é emwɛd. Dyǒb dɔ́ɔ dɛ́bɛ̌ ḿmê metii wɛ́ɛ bad ábe ánábnédé mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Áde ábíníí bembapɛɛ dyôm béwógé dyam áde Jemsɛ bɔ́ Jɔn bésɛ́dté, bênliín bɔ́ bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Hɛ́ɛ Yesuɛ áchəgɛɛ́ bɔ́ moosyəə́l bɛnbɛn boŋ álāŋgē bɔ́ aá, “Nyêbíí nɛ́n bán bad ábe bébyɛ́ɛ́né nɛ́ɛ benkamlɛnɛ bé nkǒŋsé ne bad bémbáá bé dyad, bébɛnlad ngíne âkamlɛn bad ábe bédé ásē echâb. ");
INSERT INTO bssNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Boŋ éetə̂ŋgɛnɛɛ́ abɛ́ nɛ̂ átîntê echɛ̂n. Kénzɛ́ɛ́ awě ahɛde aá mɔ́bɛ̂ mod ambáá átîntê echɛ̂n, atə́ŋgɛ́né abɛ́ mbəledɛ awɛ̂n. ");
INSERT INTO bssNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kénzɛ́ɛ́-ʼɛ awě ǎbɛ̄ mod aʼsó átîntê echɛ̂n, atə́ŋgɛ́né abɛ́ ntâŋ a moosyəə́l. ");
INSERT INTO bssNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Áyə̄le ké Mwǎn-a-Moonyoŋ eépedɛɛ́ aá bad bébɛnle mɔ́, boŋ apedé âbɛle bad, âbɛ-ʼɛ ádē aloŋgé âkɔde bad híin.” ");
INSERT INTO bssNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesuɛ ne ábē bembapɛɛ bêmpɛ̌ á dyad á Jeriko. Ndun e mod ehídéʼáá bɔ́. Áde bɛ́madté dyad áte nɛ̂, dɔ́ɔ bétáné mod nhɔ́g awě béchə́géʼáá bán Batimusɛ. Batimusɛ abédé-ʼɛɛ́ mwǎn awě Timausɛ. Ankwɛ ndím. Andyɛɛ́ á nkəg ń nzii, áchɔ̄mē bwěm. ");
INSERT INTO bssNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Áde áwógé bán Yesuɛ a dyad á Nazarɛt mɔ́ɔ atómeʼ nɛ̂, ambootéd abón, áhɔ̄bē aá, “A-Yesu, Mwǎn a mbyaa ḿme Dabidɛ, wóg mɛ ngɔl!” ");
INSERT INTO bssNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bad híin békánnéʼáá mɔ́ áte, bélāŋgē-ʼɛ mɔ́ bán ádib nsəl. Boŋ mɔ́-ʼɛ ambɛ́ ábōnē aá, “A-Mwǎn a Dabid, wóg mɛ ngɔl!” ");
INSERT INTO bssNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Hɛ́ɛ Yesuɛ átyéémé boŋ áhɔ̄bē aá, “Nyéchɛ́le mɔ́.” Dɔ́ɔ béchɛ́nlé, bélāŋgē mɔ́ bán, “Weétāgē áte. Tyéém ámīn achɛ̂nle wɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Hɛ́ɛ ane mod ábwémé kóte wíníí, apádé ásē, ápǎg-kɛ wɛ́ɛ Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Hɛ́ɛ Yesuɛ ásɛdtɛɛ́ mɔ́ aáken, “Cheé éhɛdɛɛ́ wɛɛ́ ḿbɛle wɛ?” Ane mod anhɔ́b aá, “A-meléed, nhɛde mɛɛ́ ńnyínɛn ámpē.” ");
INSERT INTO bssNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ mɔ́ aá, “Kǎg, adúbe ádôŋ ádídé wɛ bwâm.” Ábwɔ̄g-ábwɔ̄g ambootéd anyínɛn, áhīdē-ʼɛ Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Áde Yesuɛ ne ábē bembapɛɛ békwógé apɛ á Jerusalɛm, bɛnbɛn ne myad mé Bɛtpeg ne Bɛtani á Ekone é Menzab, anlóm ábē bembapɛɛ bébɛ áʼsō, ");
INSERT INTO bssNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","álāŋgē bɔ́ aá, “Nyékag á dyad áde ádé nyé áʼsō nɛ̂. Nzé nyêsɔ́lé sɔ́lɛ́n nyɛ́ɛ̄tán nɛ́ɛ bétə́ŋgé etum é nchóm a ésɛl awě mod éēdīīdɛ̄ɛ̄ mbêd. Nyéhune mɔ́, nyéhyɛɛneʼ. ");
INSERT INTO bssNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nzé mod asɛ̌dté nyé aáken, ‘Cheé ékə́ə́ boŋ nyébɛlé nɛ́n?’ Nyéláa mɔ́ bán, ‘Sáŋgwɛ́ɛ́ atógnɛ́né chɔ́, ǎlōm-mɛ chɔ́ ámbīd ábwɔ̄g-ábwɔ̄g.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Hɛ́ɛ békíí boŋ bétānēʼ etum é nchóm a ésɛl éche bétə́ŋgé á mmwɛ-ń-nzii boŋ béhunnéʼ. ");
INSERT INTO bssNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Hɛ́ɛ bad ábe béntyēēm bɛnbɛn ne áhed bésɛdtɛɛ́ bɔ́ bánken, “Cheé nyébɛlɛɛ́ nɛ̂, nyêhunne échê ésɛl-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bembapɛɛ bêntimtɛ́n bɔ́ ngáne Yesuɛ ánhɔ̄bpē aá béhɔ̂b. Dɔ́ɔ ábê bad-tɛ bɛ́tɛdté bɔ́ bán békag. ");
INSERT INTO bssNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bêmpɛɛ́n échê ésɛl wɛ́ɛ Yesuɛ, bétal chɔ́ échab mbɔ́té ámīn boŋ mɔ́-ʼɛ ádiidéʼ. ");
INSERT INTO bssNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bad híin bêntǎl échab mbɔ́té á nzii-tê âbɛ mɔ́ edúbé, ábíníí-ʼɛ bésɛ̄lēʼ eʼkikag éʼ mií, bétaléʼ á nzii-tê. ");
INSERT INTO bssNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bad ábɛ békágéʼáá mɔ́ áʼsō ne ábe béhídéʼáá mɔ́ ámbīd béhágéʼáá eʼsaád bán, “Hosána, Mekɛnag! Nnam ḿbɛ̂ ne ane awě apedé á dǐn áde Sáŋgwɛ́ɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nnam ḿbɛ̂ ne nkamlɛn ḿme echɛd sáŋ Dabidɛ, ḿme ńhúɛʼ. Hosána, Mekɛnag ne Dyǒb áde ádé se ámīn!” ");
INSERT INTO bssNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesuɛ apedé-ʼaá á Jerusalɛm, asɔ́l á Ndáb-e-Dyǒb. Ansimɛ́n ekíde ésyə̄ə̄l. Ngáne póndé êmmadté atóm, antǐm ámbīd á Bɛtani ne ábē bembapɛɛ dyôm ne bébɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Chǎn éʼbíníí áde béhúɛʼɛ́ á Bɛtani, nzaa enkób Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Annyín alín á ngəl nchabnede ne byaá ámīn. Dɔ́ɔ ákíí áhed ânyín nzé mɔ́hɛle se mɔ́kud eʼpum áwedé-mîn. Áde ápédé áhed enkêntánné epum ké ehɔ́g étōmɛɛ́ byaá áyə̄le enɛ́n póndé eebédɛɛ́ póndé echě ngəl échyáaʼɛ́ eʼpum. ");
INSERT INTO bssNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Hɛ́ɛ álâŋgɛɛ́ ábê bwɛl aá, “Wéechyááʼɛ́ epum ámpē mbêd.” Ábē bembapɛɛ bénwōg áde Yesuɛ áhɔ́bé nɛ̂. ");
INSERT INTO bssNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesuɛ ne ábē bembapɛɛ bêmpɛ̌ á Jerusalɛm. Áde bépédé, ansɔ́l á Ndáb-e-Dyǒb, ábootéd-tɛ bad ábe békábéʼáá dyɔn áwēd-te ananted. Ankuné betébelɛ ábe bad bépɛ́nléʼáá mɔné ámīn mekuu ámīn, ákūnē-ʼɛ metii ḿme bad ábe bésómméʼáá mbəŋgé mekuu ámīn. ");
INSERT INTO bssNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Enkêmmwaá-ʼɛ aá modmod átómɛn chǒm é nyoŋgé ké ehɔ́g á eyáde é Ndáb-e-Dyǒb-te. ");
INSERT INTO bssNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Hɛ́ɛ áyə́gtɛɛ́ bɔ́, áhɔ̄bē aá, “Éesaá mbále bán éténlédé nɛ́n bán, ‘Echem ndáb ěchəgnéd bán ndáb e mekáne e meloŋ mésyə̄ə̄l-ɛ?’ Boŋ nyêtimté chɔ́ mbwɔg mé bechîb!” ");
INSERT INTO bssNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Beprisɛ bémbáá ne bemeléede bé mbéndé bénwōg áde Yesuɛ áhɔ́bé nɛ̂, bébootéd-tɛ nzii ahɛd âwúu mɔ́. Boŋ bémbɛ̄ mbwɔ́g áyə̄le ndun e mod esyəə́l echě embɛ́ áhed émbɛ̄ menyáké ne mekan ḿme áyə́gtéʼáá. ");
INSERT INTO bssNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Áde ngukɛ́l épédé Yesuɛ ne ábɛ̄ bembapɛɛ bênhidé á dyad-tê wɛ̂. ");
INSERT INTO bssNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mbwɛmbwɛ, áde bétimɛɛ́ ámbīd, bényīn ádê alín á ngəl ngáne áwédé kə́ə́ŋne á nkaŋ. ");
INSERT INTO bssNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Hɛ́ɛ Petro ákámtɛ́né dyam áde Yesuɛ âmbɛnlé, boŋ álāŋgē mɔ́ aá, “A-Sáŋ, nɔnéʼ, alín á ngəl áde wɛ̂mbɛɛ́ ebómán áwédé.” ");
INSERT INTO bssNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Hɛ́ɛ Yesuɛ ákwɛntanné aá, “Nyédúbe Dyǒb ne nlém ńsyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, kénzɛ́ɛ́ awě ǎlāā enɛ́n mbɔɔd aá, ‘Hidé ásē, éhûn á edíb é nkwɛ̌-te’ boŋ adúbé ne nlém ńsyə̄ə̄l aá dyam áde mɔ́hɔ́bɛɛ́ dɛ́bɛnléd ésebán apideʼ, né dɛ́bɛnléd. ");
INSERT INTO bssNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Né-ɔɔ́, nlâŋge nyé mɛɛ́ kéchéé éche mod ásɛ́dté Dyǒb á mekáne-tê, boŋ ádúbe nɛ́n aá mɔ́ɔ̄kud chɔ́, ǎkǔd-tɛ chɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Póndé ké ehéé échě étyéémé wɛɛ́ mɔ́kannɛʼ, nzé ewánlɛ́né mod meliŋgá, élagsɛn mɔ́, âbɛl nɛ́n awôŋ Titɛ́ɛ awě adé ámīn mɔ́-ʼɛ ámpē alagsɛn wɛ ḿmoŋ mbéb.” ");
INSERT INTO bssNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesuɛ ne ábē bembapɛɛ bêmpɛ̌ á Jerusalɛm ámpē. Ahyɔ́mméʼáá á Ndáb-e-Dyǒb-te. Hɛ̂ dɔ́ɔ beprisɛ bémbáá, bemeléede bé mbéndé ne bad bémbáá bé dyad bépédé áwē. ");
INSERT INTO bssNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Dɔ́ɔ bésɛdtɛɛ́ mɔ́ bánken, “Kunze ehéé éwóó âbɛl ḿmɛ́n mekan? Nzɛ́-módɛ́ abagé-ʼɛ wɛ ene kunze?” ");
INSERT INTO bssNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesuɛ ankwɛntɛ́n bɔ́ aá, “Mɛɛ́sɛdéd nyé dyam ahɔ́g. Nzé nyêkwɛ̌ntɛ́né dɔ́, né mɛ-ʼɛ mɛ̌lāā nyé kunze echě ńwóó âbɛl ḿmɛ́n mekan. ");
INSERT INTO bssNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nzɛ́ɛ́ ambɛ̌ Jɔnɛ kunze âdusɛn bad? Dyǒb-ɛ ngɛ́ baányoŋ?” ");
INSERT INTO bssNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Běn ne běn bêmbootéd apentɛn bánken, “Nzé dehɔ́bé nɛ́n bán ‘Jɔnɛ echě kunze enhúú ne Dyǒb,’ né ǎsɛdéd syánē aáken, ‘Cheé-ɔ̄ enkə̌ŋ boŋ nyénkêndúbé mɔ́?’ ");
INSERT INTO bssNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Boŋ nzé dehɔ́bé bán, ‘Echě kunze ehúú ne baányoŋ?’ ” (Béwógéʼáá bad mbwɔ́g áyə̄le bad bésyə̄ə̄l bêndúbé bán Jɔnɛ abédɛ́ɛ nkal éʼdəə́dəŋ.) ");
INSERT INTO bssNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Né-ɔɔ́, bênkwɛntɛ́n Yesuɛ bán, “Séebíiʼɛ́.” Yesuɛ mɔ́-ʼɛ antimtɛ́n bɔ́ aá, “Né ké mɛ-ʼɛ ámpē méelááʼɛ́ nyé kunze echě ńwóó âbɛl ḿmɛ́n mekan.” ");
INSERT INTO bssNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Hɛ́ɛ Yesuɛ ábóótédé ngan abɛnled âkalɛn bɔ́. Anhɔ́b aá, “Mod nhɔ́g ankwɛ̌l nzag e eʼpum éʼ mɛl ábe bébɛnlɛɛ́ mǐm. Ankág chɔ́, ábɛl bwǎl wɛ́ɛ béminɛɛ́ ábê eʼpum éʼ mɛl âbɛl mǐm, alóŋ-ʼɛ ebem wɛ́ɛ bédyɛɛʼɛ́ áwēd-te ânan menɔn. Ambɛ̌ ene nzag wɛ́ɛ bad ábe bɔ́bɔ́ɔ bɛ́kǎb mbote áte, ákɛ̄ á aloŋ démpēe. ");
INSERT INTO bssNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nɛ́ɛ póndé épédé echě bépádɛɛ́ eʼpum, ane nwóó-nzag anlóm awě mbəledɛ wɛ́ɛ ábê bebɛl-bé-nsɔ́n âkobe mɔ́ ádē asii dé eʼpum. ");
INSERT INTO bssNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Hɛ́ɛ ábê bebɛl-bé-nsɔ́n békóbé ane mbəledɛ, béwānɛ̄n mɔ́, bésúúd-tɛ mɔ́ ámbīd ne mekáá mé ngɛ̂n. ");
INSERT INTO bssNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Dɔ́ɔ ane nwóó-nzag álómé mbəledɛ ampée. Bénlɔ̄gɛ̄n mɔ́ á nló, béwógéd-tɛ mɔ́ eʼsôn. ");
INSERT INTO bssNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nwóó-nzag ambɛ́ alóm mbəledɛ ampée, ábê bad bénwūū ane ámpē. Bêmbɛ̌l melemlem ne ekud émpēe, bébɔmé doŋge, béwūɛ̄-ʼɛ ábíníí. ");
INSERT INTO bssNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mod awě anlyəg mɔ́ alóm abédɛ́ɛ awe mwǎn-a-mwɛnchóm awě ândəŋgé bwâmbwam. Kə́ə́ŋne á asóg, dɔ́ɔ álómɛɛ́ ane mwǎn ne mewêmtɛn nɛ́n aá, ‘Ngáne ádíí awem mwǎn, bɛ́bē mɔ́ edúbé.’ ");
INSERT INTO bssNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Boŋ áde ábê bebɛl-bé-nsɔ́n bényíné nɛ́ɛ ane mwǎn áhúɛʼɛ́, dɔ́ɔ běn ne běn béhɔ́bɛɛ́ bán, ‘Ndyɛ́-a-mbwɔ́g nɛ́n, nyéhyag déwúu mɔ́ âbɛl nɛ́n eche mbwɔ́g ésuuned syánē.’ ");
INSERT INTO bssNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Hɛ́ɛ békóbé mɔ́, béwūɛ̄ʼ mɔ́, bébwém-mɛ mɔ́ ndim ámbīd e eʼkɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Hɛ́ɛ Yesuɛ ásɛdtɛɛ́ aáken, “Bɔɔb-pɔɔ́, cheé nwóó-nzag ábɛnlé ábɛ̂ bebɛl-bé-nsɔ́n? Ǎpɛ̌ awúú bɔ́, ábɛ̄-ʼɛ ene nzag wɛ́ɛ bebɛl-bé-nsɔ́n bémpēe. ");
INSERT INTO bssNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Eyale é Dyǒb éhɔ́be nɛ́n aá, ‘Aláá áde belóŋ-bé-ndáb bênchenɛɛ́, dɔ́ɔ átímé aláá dé etógnɛ́n abɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Sáŋgwɛ́ɛ́ mɔ́ abɛlé nɛ́n, édé-ʼɛ syánē menyáké á dǐd-te. Nyéēlááʼɛ́ nɛ̂-yɛ?’ ” ");
INSERT INTO bssNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Né-ɔɔ́, bad bémbáá bé Israɛl béhɛ́déʼáá Yesuɛ akób áyə̄le bémbíi bán áyə̄le echâb dɔ́ɔ ákálé enɛ́n ngan. Boŋ bémbɛ̄ mbwɔ́g áyə̄l e ene ndun e mod embɛ́ áhed. Né-ɔɔ́ bêntɛdé mɔ́ békɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bénlōm Befarisia ne bad bé epepé éche Hɛrɔdɛ âkɛ dé asɛded Yesuɛ dyam âbɛl nɛ́n békóbɛn mɔ́ awusé. ");
INSERT INTO bssNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Hɛ́ɛ bépédé áwē boŋ bélāŋgē mɔ́ nɛ́n bán, “A meléed, sêbíí nɛ́n bán ekale mbále. Weékwognádté modmod. Weebáá-ʼɛ bad mesó mé mbɔm. Boŋ ekoŋte bad mam mé Dyǒb ayə́ged. Mbéndé eche syánē ehɔ́be nɛ́n bán désaŋgeʼ táásɛ wɛ́ɛ Kaisɛɛ, kə̂ŋ e Roma-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Boŋ Yesuɛ anchěm ḿmāb medogké, hɛ́ɛ ásɛdtɛɛ́ aá, “Cheé nyékəgɛɛ́ mɛ. Nyéhyiined mɛ mɔné mé ekii ńnɔn mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Hɛ́ɛ bépɛ́ɛ́né mɔné ḿmed boŋ ásɛdté aáken, “Ediídiŋgɛ éche nzɛ́ɛ́ chɛ́n, dǐn áde nzɛ́ɛ́-ʼɛ dɛ́n?” Bênkwɛntɛ́n mɔ́ bán, “Ábe Kaisɛɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Dɔ́ɔ álâŋgɛɛ́ bɔ́ aá, “Nyébag-kɔɔ́ Kaisɛɛ éche édé éche Kaisɛɛ, nyébag-kɛ Dyǒb éche édé é Dyǒb.” Áde béwógé nɛ̂, yə̌l enkɔ́m bɔ́ áte. ");
INSERT INTO bssNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Besadusia bêmpɛ̌ wɛ́ɛ Yesuɛ. Béndūbē bán mpuu méesaá ámbīd e kwééd. Dɔ́ɔ béhɔ́bɛɛ́ bán, ");
INSERT INTO bssNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“A-meléed, mbéndé e Mosɛɛ ehɔ́be nɛ́n bán, ‘Nzé mod awóó mmwaád boŋ awédé áde bɔ́ ane mmwaád béepedɛɛ́ mwǎn awále, mwǎnyaŋ a abum ahɔ́g atə́ŋgɛ́né ane nkúd awóŋ âbɛl boŋ dǐn áde mwǎnyaŋ déēbɔ̄ɔ̄ʼ.’ ");
INSERT INTO bssNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bɔɔb-pɔɔ́, bad bébédé mod saámbé ábe bémbīd abum ahɔ́g. Mod aʼsó anwóŋ mmwaád boŋ awɛ́ áde bɔ́ mmwaád ne béepedɛɛ́ bán awále. ");
INSERT INTO bssNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mwǎnyaŋ awě anhíd mɔ́ anwóŋ ane nkúd a mmwaád. Mɔ́mpē awɛ́ áde bɔ́ ane mmwaád béepedɛɛ́ bǎn awále. Melemlem mé dyam mêmbɛnléd ne awě alóntɛ́né béláán. ");
INSERT INTO bssNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kə́ə́ŋ bɔ́ mod saámbé asyəə́l bénwōŋ ane mmwaád béwɛ́-ʼɛ, áde béepedɛɛ́ mwǎn awále. Kə́ə́ŋne á asóg ane mmwaád mɔ́mpē anwɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Bɔɔb-pɔɔ́ á póndé e mpuu, mmwaád awě nzɛ́ɛ́ ane mmwaád áchəgnédté áyə̄le bɔ́ moosyəə́l saámbé bénwōŋ mɔ́?” ");
INSERT INTO bssNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Hɛ́ɛ Yesuɛ átimtanné bɔ́ aá, “Nyépaneʼ áyə̄le nyéesôŋtɛnɛɛ́ chǒm éche eyale é Dyǒb éhɔ́bɛɛ́, nyéesôŋtɛnɛɛ́-ʼɛ ngáne ngíne e Dyǒb ésógé abɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Póndé echě bad bépuúʼɛ́ ámbīd e kwééd, mewóŋgé méebáá ámpē. Bad bɛ́bē nɛ̂ŋgáne ángɛl éche édé ámīn, béewóŋnɛ́ɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Bɔɔb-pɔɔ́, tə̂ŋgɛne mpuu, kíné nyéēlááʼɛ́ á kálag e Mosɛɛ á epɛd échě éhɔ́be áyə̄le mwǎ bwɛl awě ahyááʼáá-yɛ? Áhed, éténlédé bán áde Dyǒb álâŋgɛɛ́ Mosɛɛ tə̂ŋgɛne Abrahamɛ, Aisigɛ ne Jakɔbɛ ábe bêmmad awɛ́, Dyǒb dénhɔ̄b aá, ‘Mɛɛ́ ndé Dyǒb áde Abrahamɛ, Aisigɛ ne Jakɔbɛ.’ ");
INSERT INTO bssNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nɛ̂ álûmte nɛ́n bán bédé á aloŋgé. Dyǒb ádíi Dyǒb á bad ábe bédé á aloŋgé, saké Dyǒb á bad ábe béwédé. Nyêpaneʼ bwâmbwam.” ");
INSERT INTO bssNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Meléede a mbéndé nhɔ́g awě ambɛ́ áhed anwóg chǒm éche béhɔ́bɛɛ́. Ádě ányíné aá Yesuɛ abagé Besadusia nkwɛntɛn ḿ bwâm, ansɛdéd Yesuɛ aá, “A meléed, átîntê e mbéndé ésyə̄ə̄l, mbéndé ehéé etómtɛ́né etógnɛ́n abɛ́?” ");
INSERT INTO bssNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesuɛ ankwɛntɛ́n mɔ́ aá, “Mbéndé echě etómtɛ́né etógnɛ́n abɛ́ edíi mbéndé echě ehɔ́be nɛ́n aá, ‘Á-bad bé Israɛl nyéwóglɛn: Sáŋgwɛ́ɛ́ ádɛd Dyǒb, mwěmpɛn-ɛɛ́ adé Sáŋgwɛ́ɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Édəŋ Sáŋgwɛ́ɛ́ ádoŋ Dyǒb ne ḿmoŋ nlém ńsyə̄ə̄l, ne échoŋ edəə́dəŋ ésyə̄ə̄l, ne ḿmôŋ mewêmtɛn mésyə̄ə̄l, édəŋ-ʼɛ mɔ́ ne echoŋ ngíne esyəə́l.’ ");
INSERT INTO bssNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Echě elontɛ́né ébɛ echě chɔ́mpē edé etógnɛ́n, edíi echě ehɔ́be nɛ́n aá, ‘Édəŋ mwǎnyoŋ nɛ̂ŋgáne édə́ə́ echoŋ yə̌l.’ Mbéndé empée eésaá echě etómtɛ́né etógnɛ́n abɛ́ nɛ̂ŋgáne échɛ́n ébɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Hɛ́ɛ ane meléede a mbéndé álâŋgɛɛ́ Yesuɛ aá, “A-meléed etə́ŋgɛ́né. Ekalé mbále wɛɛ́ Dyǒb ádíi ahɔ́g, Dyǒb démpēe déesaá-ʼɛ étómɛɛ́ mwěmpɛn. ");
INSERT INTO bssNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mod âdəŋ-ʼɛ mɔ́ ne ḿmē nlém ńsyə̄ə̄l, ne ḿmē mewêmtɛn mésyə̄ə̄l, ne eche ngíne esyəə́l, âdəŋ-ʼɛ mwǎnyaŋ ngáne ádə́ə́ eche yə̌l, atómtɛ́né etógnɛ́n abɛ tómaa âbɛ Dyǒb mendɛ ḿme béhyâŋtɛɛ́ ne mendɛ mémpēe.” ");
INSERT INTO bssNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Áde Yesuɛ ányíné aá ane meléede a mbéndé ahɔ́bné debyɛ́ɛ́, anláá mɔ́ aá, “Nkamlɛn ń Dyǒb méechabnedɛɛ́ wɛ yə̌l.” Ámbīd enɛ̂ modmod enkênchǔʼɛ́ Yesuɛ dyamdyam asɛded ámpē. ");
INSERT INTO bssNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesuɛ ayə́gtéʼáá á Ndáb-e-Dyǒb. Áhed dɔ́ɔ áhɔ́bɛɛ́ aáken, “Chán bemeléede bé mbéndé béhɛle béhɔ̄bē bán Ane-awě-Béwɔ́gté abídé á mbyaa ḿme kə̂ŋ Dabidɛ? ");
INSERT INTO bssNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dabidɛ mwěn anhɔ́b áde Edəə́dəŋ éche Ésáá émbɛ̄ɛ̄ mɔ́ áte aá, ‘Sáŋ Dyǒbɛ anláá awêm Sáŋgwɛ́ɛ́ aá, Dyɛɛ́ áwêm ekáá émbáá kə́ə́ŋ ne á póndé echě mɛ́bɛnlé boŋ ékɔgtéd ábōŋ bad bé ekɔyí ámīn ne mekuu.’ ");
INSERT INTO bssNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nɛ́ɛ Dabidɛ mwěn ásébpé mɔ́ achəg aá Sáŋgwɛ́ɛ́, chán-nɔ̄ Ane-awě-Béwɔ́gté áhɛlɛɛ́ abɛ́ awe mwǎn?” Ndun e mod ewóglánnáá Yesuɛ áhed ne menyiŋge bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Áde áyə́gtɛɛ́ bɔ́ anhɔ́b aá, “Nyétêd póndé ne bemeléede bé mbéndé, bédəəʼ mengombe ḿme ńchábé ahyɔ́mɛn áte. Bédəə-ʼɛ bán bad bélɛnte bɔ́ ne edúbé ésyə̄ə̄l á mebwɔ́g nɛ́ɛ á dyɔn-tê nɛ̂. ");
INSERT INTO bssNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bédəə-ʼɛ metii mé edúbé adyɛɛ á ndáb é mekáne, bédə̄ŋ-ʼɛ eʼtə́l bé edúbé á hǒm á ngande. ");
INSERT INTO bssNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bédumeʼ mbwɔ́g é bekúd, bédogné-ʼɛ bad ntóŋ-ntóŋ mé mekáne. Bɛ́kǔd nkɔ́gsɛn ḿme ńchábé ámīn.” ");
INSERT INTO bssNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesuɛ andyɛɛ́ bɛnbɛn ne ntyə́g ḿme béhágéʼáá mɔné mé mendɛ áte á Ndáb-e-Dyǒb, ánɔnéʼ ngáne bad béhāgkē mɔné áwēd-te. Ekud é behɔn bé bad béhágéʼáá ekud é mɔné. ");
INSERT INTO bssNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Dɔ́ɔ ntógétōke a nkúd a mmwaád ápédé, boŋ áhāg mɔné mé ekii ḿme ndé ké bedə́lɛɛ bébɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Hɛ́ɛ Yesuɛ áchə́gé ábē bembapɛɛ bɛnbɛn boŋ álāŋgē bɔ́ aá, “Ne mbále, nlâŋge nyé mɛɛ́, ḿmɛ́n ntógétōke mé mmwaád ńhédé mɔné tómaa ábɛ́n behɔn bé bad bésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mɔné ḿme ábɛ̂ bad béhédé, ndíi mɔné ḿme ńchɔ́bé bɔ́ ásē, boŋ anɛ́n mmwaád ne atóg áde ádíí, ahédé mɔné ńsyə̄ə̄l ḿme áwóó, ńsyə̄ə̄l ḿme ámbɛ̄ɛ̄ atɔgnan yə̌l.” ");
INSERT INTO bssNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesuɛ ambíd á Ndáb-e-Dyǒb. Áde ábídɛɛ́ nɛ̂ dɔ́ɔ awě mbapɛɛ nhɔ́g álâŋgɛɛ́ mɔ́ aá, “A-meléed nɔnéʼ, meláá ne nlóŋtéd ń Ndáb-e-Dyǒb mɛ́n ḿbóó bwâmbwam.” ");
INSERT INTO bssNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesuɛ ankwɛntɛ́n mɔ́ aá, “Enyíneʼ échɛ́n ngíne é nlóŋtéd-ɛ? Aláá ké ahɔ́g déelyəgké ámīn e waáb, bɛ́pāŋtēd mɔ́ áte mésyə̄ə̄l.” ");
INSERT INTO bssNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesuɛ ankɛ̌ adyɛɛ á ekone é Menzab mîn. Échê Ekone ébédé á mǔdɛ ń Ndáb-e-Dyǒb. Áhed dɔ́ɔ Petro, Jemsɛ, Jɔnɛ ne Andreya bépédé boŋ bélāŋgē mɔ́ wɛ́ɛ bɔ́bɔ̄ɔ běnpɛn bébédé bán, ");
INSERT INTO bssNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Láá sé póndé echě ḿmɛ́n mam mɛ́bɛnlédté, éláa-ʼɛ sé eʼchemléd ábe bɛ́lūmēd bán póndé echě mɛ́bɛnlédté epedé.” ");
INSERT INTO bssNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesuɛ anláá bɔ́ aá, “Nyétêd póndé nyéēmwāg-kɛ se modmod ádog nyé. ");
INSERT INTO bssNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bad híin bɛ́pɛ̌ á dǐn ádêm béhɔ̄bē bán, ‘Mɛ-ɛɛ́ ndé Ane-awě-Béwɔ́gté.’ Bɛ́dǒg-kɛ bad híin. ");
INSERT INTO bssNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nzé nyêwógé bán nzum éwanteʼ kéʼɛ nyêwógé nzunze é nzum, nyéētāgē áte. Nɛ́n átə́ŋgɛ́né abɛnled, boŋ nɛ̂ déēlūmtɛ̄ɛ̄ nɛ́n bán asóg ámáá apɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Aloŋ ahɔ́g dɛ́tyēēmɛ̄n ádíníí nzum. Nkamlɛn nhɔ́g-kɛ ńtyēēmɛ̄n ḿmíníí. Ndɔɔb eénəŋnéd mebwɔ́g ne mebwɔ́g, nzaa-ʼɛ ěbɛ̄. Nɛ́n dɛ́bɛ̄ nɛ̂ŋgáne mewɛ méʼsō ḿme mmwaád áwógɛɛ́ nzé ahɛde achyáa. ");
INSERT INTO bssNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nzé ḿmɛ́n mam mébóótédé-ʼɛ abɛnled, nyétédɛn yə̌l póndé áyə̄le bɛ́kōb nyé, bébɛ nyé á mekáá mé bad bé kóte. Bɛ́wanɛ́n nyé á ndáb é mekáne, nyêtyéém-mɛ á nkáásé áʼsō éʼ benkamlɛnɛ ne kə̂ŋ é bad á yə̌l echêm. Nɛ́n dɛ́bɛnléd âbɛl nyékale bɔ́ nkalaŋ ḿ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bétə́ŋgɛ́né nɛ́ɛ bésébpé nkalaŋ ḿ bwâm akal meloŋ mé nkǒŋsé áte mésyə̄ə̄l, boŋ asóg dɛ́pɛ̌. ");
INSERT INTO bssNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nzé békóbé-ʼɛ nyé boŋ bépɛ́ɛ́né nyé á kóte, nyéētāgē áte, áyə̄le dyam áde nyéhɔ̄bpē. Nzé ene póndé epedé, nyéhɔ̂b kéchéé echě ébagnéd nyé, áyə̄le dyam áde nyɛ́hɔ̄bpē dɛ́bīd ne Edəə́dəŋ éche Ésáá saké ne nyé. ");
INSERT INTO bssNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Bad bɛ́bagé baányaŋ á mekáá mé bad bémpēe âwúu bɔ́. Besáá-bé-bǎn bɛ́bɛ̌l melemlem ne ábab bǎn. Bǎn-nɛ ámpē bɛ́kunnɛ́n besáá bɔ́ɔbɛ benyaá yə̌l âbɛl béwúu bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Moosyəə́l ǎkɔɔ́ nyé áyə̄l e dǐn ádêm. Boŋ kénzɛ́ɛ́ awě ǎkaán ḿmê metake nlém kə́ə́ŋ ne á asóg, ǎkǔd eʼsoósoŋ.” ");
INSERT INTO bssNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nyɛ́ɛ̄nyīn nɛ́ɛ ekúkú é akan éche épɛɛne eʼsôn áʼsō éʼ Dyǒb édíí wɛ́ɛ énkêntə́ŋgɛ́nné abɛ́.” (Nyé ábe nyêláaʼ ḿmɛ́n mekan nyésôŋtɛn mɔ́ bwâm.) “Nzé nyênyíné nɛ̂, bad ábɛ̄ bédé á Judeya bétôm mehélé, békɛ bésɔɔm á eʼkone mîn. ");
INSERT INTO bssNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mod awě adé á nnoŋ ń ndáb mîn eétɔgné akɛ á ndáb-te âtéd chǒmchǒm. ");
INSERT INTO bssNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mod awě mɔ́-ʼɛ adé á nzag-tê, eétīmē ámbīd âtéd eche sɔ́te. ");
INSERT INTO bssNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ébɛ̄ ebébtéd ne bebaád ábe bɛ́bē nkog ne ábe bɛ́mwāŋtē ḿmê mesú. ");
INSERT INTO bssNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nyékânne nɛ́n bán, nɛ́n déebɛnlád ne nyé á póndé e nkóg áde ahéb ádíí ngíne bwâmbwam, ");
INSERT INTO bssNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","áyə̄le ndəŋge echě ěbɛ̄ ábê eʼpun, ěbɛ̄ ndín echě eébédé mbêd bootya Dyǒb áhəge nkǒŋsé apɛ epun éʼchii. Dyamdyam nɛ́ɛ ádê déebɛnléd-taá ámpē mbêd. ");
INSERT INTO bssNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Boŋ Sáŋgwɛ́ɛ́ amaá ábê eʼpun éʼ metake asɛ́l áte. Nzé énkêmbɛ́ nɛ̂, né modmod éechoŋgé. Boŋ á etútú é bad ábe ápwɛ́dé, asɛ́lé ábɛ̂ eʼpun áte. ");
INSERT INTO bssNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ene póndé nzé mod aláŋgé nyé aá, ‘Nyénɔneʼ, Ane-awě-Béwɔ́gté mɔ̂nɛ́n’ káa, ‘Nɔnéʼ mɔ̂níníí,’ nyéedúbpéʼ. ");
INSERT INTO bssNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bad híin bɛ́bīd, bɔ́ mod tɛ́ ákalé metóm aá mɔ́ɔ mɔ́dē Ane-awě-Béwɔ́gté. Bekal béʼdəə́dəŋ bé metóm ámpē bɛ́bīd. Bɛ́bɛlé menyáké, bélūmtē-ʼɛ eʼchemléd híin. Bɛ́bɛl nɛ́n âbɛl boŋ bédog bad ábe Dyǒb ápwɛ́dé, nzé nzii edé âdog bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nyétêd póndé. Nláŋgé nyé ḿmɛ́n mam mésyə̄ə̄l áʼsō éʼ póndé. ");
INSERT INTO bssNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ábê eʼpun-nɛ, áde póndé e ndəŋge ne étómmé tómɛ́n ‘etondɛɛ ǎkwɛ ehíntɛ́n, ngɔn-nɛ esóg apɛn, ");
INSERT INTO bssNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","betintinɛ bɛ́bīd ámīn béhūn ásē, ngíne-ʼɛ éche édé ámīn énəŋnéd á eʼdii.’ ");
INSERT INTO bssNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ene póndé dɔ́ɔ bɛ́nyīnnē nɛ́ɛ Mwǎn-a-Moonyoŋ áhúɛʼɛ́ á mbag-tê ne ngum ne ehúmé é ngíne. ");
INSERT INTO bssNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ǎlōm éche ángɛl á metóŋgé mé nkǒŋsé mésyə̄ə̄l méniin, âlad bad ábe Dyǒb ápwɛ́dé áte, bootya atóŋgé dé nkǒŋsé ahɔ́g âpɛ ádíníí. ");
INSERT INTO bssNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Nyétêd eláŋsɛ́n ne alín á ngəl. Nzé ngɛn ébóótédé byaá békɔ̄ɔ̄lē abíded, nyêbɛle nyêbíí bán nchoŋ ńdé bɛnbɛn. ");
INSERT INTO bssNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Melemlem nzé nyênyíné ḿmɛ́n mekan mésyə̄ə̄l mébɛnlad, nyébíi nɛ́n bán, Mwǎn-a-Moonyoŋ akwogé apɛ, adé-ʼɛ bɛnbɛn. ");
INSERT INTO bssNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, enɛ́n nyoŋgɛl e bad ědīi ebɛ́ ámīn boŋ ḿmɛ́n mekan mésyə̄ə̄l mébɛnlád. ");
INSERT INTO bssNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nkoŋ ḿ mín ne nkǒŋsé bɛ́maá boŋ ábêm eʼyale bɛ́bē abɛ́ ne abɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Modmod eebíiʼɛ́ epun pɛn kéʼɛ póndé echě ḿmɛ́n mam mɛ́bɛnlédté. Ké ángɛl éche édé ámīn éebíiʼɛ́, ké Mwǎn ámpē eebíiʼɛ́. Titɛ́ɛ mwěmpɛn mɔ́ abíí póndé eche ḿmɛ́n mekan mɛ́bɛnlédté. ");
INSERT INTO bssNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nyétêd póndé, nyéboŋsɛn, áyə̄le nyéebíiʼɛ́ áde ene póndé épɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ébɛ̄ nɛ̂ŋgáne mod awě anlédé ekɛ akɛ, boŋ alyə́gnéd ábē bembəledɛ ndáb, ábɛ nhɔ́g-tɛ́ɛ́ ḿme nsɔ́n, aláá-ʼɛ mod awě anɔneʼ mmwɛ mé eʼkɛ́ aá ábɛle nsɔ́n bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Né-ɔɔ́, nyétêd póndé áyə̄le nyéebíiʼɛ́ pondé echě Sáŋgwɛ́ɛ́ a ndáb ápɛɛ́. Ahɛle ápɛ̄ ngukɛ́l, kéʼɛ melúde, kéʼɛ epɔg é mbwɛmbwɛ, kéʼɛ mbwɛmbwɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nzé apedé təléd eetə́ŋgɛnɛɛ́ nɛ́ɛ átáné nɛ́ɛ nyékúnɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Né-ɔɔ́, saké nyé běnpɛn ńlâŋgɛɛ́ ádɛ́n dyam boŋ nlâŋge moosyəə́l mɛɛ́, ‘Nyétêd póndé.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ênlyə̌g eʼpun éʼbɛ, Ngande e Nnyíme-ámīn ne e Ewɛle-é-Ngɛ̂n âpɛ áte. Beprisɛ bémbáá ne bemeléede bé mbéndé béhə́géʼáá mwane âkób Yesuɛ á mesɔɔm-tê, âwúu mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Boŋ bénhɔ̄b bán, “Deébɛ̄lē nɛ̂ á mbwɛ ń ngande áyə̄le né bad bɛ́pɛɛ́n epuutéd.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesuɛ ambɛ́ á Bɛtani á ndáb wɛ́ɛ Simɔnɛ awě ankwɛ̌ nkole mé meləŋ. Áde ádyágkē ndyééd nɛ̂, dɔ́ɔ mmwaád nhɔ́g ápédé ne apom á dyɔ̌g dé elod é bwâm áde dênlɛ̌l nkun bwâmbwam. Ádê dyɔ̌g bébɛ́nlé dɔ́ nâd. Hɛ̂ dɔ́ɔ ákɔ́gté nló mé epom boŋ ásyɔgé Yesuɛ ádê dyɔ̌g á nló. ");
INSERT INTO bssNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Boŋ doŋge á bad ábe bébédé áhed bênlǐŋ bwâmbwam, bésɛdté nhɔ́g ne aníníí bánken, “Cheé ékə́ə́ boŋ anɛ́n mmwaád ábēbtēʼ enɛ́n ndín e dyɔ̌g? ");
INSERT INTO bssNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Béhɛ́léʼáá-sɛ bésóm ádɛ́n dyɔ̌g nkun ḿme ńchábé ámīn, bétéd ḿmê mɔné bébɛ̄ betóótōkɛ̄ bé bad.” Né-ɔɔ́, bénhɔ̄bɛ̄n ane mmwaád bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Boŋ Yesuɛ anláá bɔ́ aá, “Nyéchene mɔ́. Cheé nyétagtɛɛ́ mɔ́? Abɛ̌nlé mɛ kəse e dyam echě eboó bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Betóótōkɛ̄ bé bad bɛ́bē ne nyé póndé ésyə̄ə̄l, póndé ké ehéé echě nyédə́ə́-ʼɛ bɔ́ awôŋgɛn nyêhɛle nyêwóŋgɛ́n bɔ́, mɛ pɛn méebáá ne nyé póndé ésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Abɛlé wɛ́ɛ mekáá mépédé mɔ́. Asyɔgé mɛ dyɔ̌g á nló âboŋsɛn nlíme ḿmêm áʼsō éʼ póndé. ");
INSERT INTO bssNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, kéhéé áde nkalaŋ ḿ bwâm mɛ́kanlédté nkǒŋsé áte ńsyə̄ə̄l, bɛ́hɔ̄b dyam áde anɛ́n mmwaád ábɛ́lé âkamtɛn mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ámbīd e nɛ̂, mbapɛɛ nhɔ́g átîntê e bembapɛɛ dyôm ne bébɛ awě béchə́géʼáá bán Judas Iskariɔdɛ ankɛ̌ beprisɛ bémbáá atán âbɛl boŋ ásôm Yesuɛ áwāb. ");
INSERT INTO bssNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Beprisɛ bémbáá bémbɛ̄ menyiŋge ne dyam áde Judasɛ ánlāāʼɛ́ bɔ́, béhɔ́b-pɛ bán bɛ́bɛ̌ mɔ́ mɔné. Né-ɔɔ́, Judasɛ ambootéd nzii ahɛd âsóm Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bɔɔb-pɔɔ́ póndé e ngande e Ewɛle-é-Ngɛ̂n empɛ̌. Mbwɛ méʼsō áde béwúɛ̄ʼáá bǎn bé ńdyɔŋ ḿ mbód âboŋsɛn ndyééd e Nnyíme-ámīn, bembapɛɛ ábe Yesuɛ béntān Yesuɛ, bésɛdté mɔ́ bánken, “Héé wɛ́dəŋgé wɛɛ́ séboŋsɛn wɛ ndyééd e Nnyíme-ámīn?” ");
INSERT INTO bssNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dɔ́ɔ Yesuɛ álómɛɛ́ bembapɛɛ bébɛ ne nlyə́gtɛ́n nɛ́n aá, “Nyékag á dyad-tê, mod ǎbomɛ́n nyé awě apémé apom dé mendíb, nyéhíde mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nzé nyêpedé, nyéláa nwóó-ndáb bán, ‘Meléede ahɔ́bé aáken, Héé toŋ e beken édíí echě mɔ́dyɛ̄ɛ̄ ndyééd e Nnyíme-ámīn áte ne ábɛ̄ bembapɛɛ?’ ");
INSERT INTO bssNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ǎlūmēd nyé toŋ echě ekəlé áte echě bémáá aboŋsɛn, bénábpé-ʼɛ áte. Ene toŋ edé ámīn á ndáb-te. Nyéboŋsɛn syáā ndyééd áhed.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Hɛ́ɛ ábɛ̂ bembapɛɛ béhídté boŋ békǎg á dyad-tê. Béntān mekan mésyə̄ə̄l ngáne Yesuɛ ánlāāʼɛ́ bɔ́, bêmboŋsɛ́n-nɛ ndyééd e ngande e Nnyíme-ámīn. ");
INSERT INTO bssNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nɛ́ɛ ngukɛ́l épédé Yesuɛ ne ábē bembapɛɛ dyôm ne bébɛ bêmpɛ̌ áhed. ");
INSERT INTO bssNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bédyágéʼáá ndyééd á tébelɛ. Póndé echě bédyákē ndyééd nɛ̂, dɔ́ɔ Yesuɛ áhɔ́bɛɛ́ aá, “Nlâŋge nyé nɛ́n mɛɛ́, nyé mod nhɔ́g ǎbɛ̌ mɛ á mekáá mé bad bé ekɔyí, nyé nhɔ́g awě adyâg ndyééd ne mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nɛ́n dêmbɛ̌l bembapɛɛ bênsudɛ́n bwâmbwam. Bêmbootéd mɔ́ asɛded nhɔ́g ámbīd e aníníí bán, “Ndúbpé mɛɛ́ saké mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Dɔ́ɔ átimtanné bɔ́ aá, “Mod nhɔ́g átîntê nyé bad dyôm-ne-bébɛ, mod awě súmɔ̄ sɛ́ɛ̄tɔdé ewɛle á dǐsɛ-tê atɔde ahɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mwǎn-a-Moonyoŋ ǎwɛ̄ ngáne éténlédé boŋ medim ne ane mod awě ǎsōm mɔ́. Ébágáá bwâm ne ane mod nzé bénkêntɔgɛn mɔ́ achyáa.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Áde Yesuɛ ne ábē bembapɛɛ bédyákē ndyééd nɛ̂, dɔ́ɔ átédé ewɛle, ásāgnān Dyǒb, boŋ ákabtáád áte, ábagé ábē bembapɛɛ áhɔ̄bē aá, “Nyékob nɛ́n, yə̌l echêm nɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ámbīd e nɛ̂, antéd mbwendé ḿ mǐm, ásāgnān Dyǒb, ábagé bɔ́. Bɔ́ moosyəə́l-lɛ bémwâg. ");
INSERT INTO bssNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Ḿmêm mekií mɔ̂mɛ́n ḿme ńsyɔ́gké á nló ḿ bad híin. Ḿmɛ́n mekií médíi mekií mé melɛ̌ mékɔ̄ɔ̄lē. ");
INSERT INTO bssNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, méemwáá ḿmɛ́n mǐm ámpē kə́ə́ŋ ne epun éche mɛ́mwɛ̄ɛ̄ mɔ́ ekɔ́ɔ́lé á nkamlɛn ń Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bénkɔ̄n nkə́ŋgé mé nságnɛn. Nɛ́ɛ bémáá akɔ́n, bênkɛ̌ á Ekone é Menzab. ");
INSERT INTO bssNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesuɛ anláá ábē bembapɛɛ aá, “Nyé baásyə̄ə̄l nyɛ́ɛ̄nyəgéd, nyétɛ̄dē mɛ. Áyə̄le éténlédé á kálag e Dyǒb nɛ́n bán, ‘Mɛ̌wūū nnɔn-a-mbód, mbód ésyə̄ə̄l épáŋtéd áte.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Dɔ́ɔ Yesuɛ áhɔ́bɛɛ́ aá, “Boŋ áde ápuúdté mɛ, mɛ̌kɛ̌ áʼsō á Galilia áwed-taá nyɛ́tānnē mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Dɔ́ɔ Petro áhɔ́bɛɛ́ aá, “Ké moosyəə́l annyəgéd átɛ̄dē wɛ, mɛ pɛn méetɛdɛ́ɛ́ wɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ Petro aá, “Ne mbále, nlâŋge wɛ mɛɛ́, nkuu nɛ́n děn, nchóm-a-kúb adɛ̂hɔ́b aá mɔ́tōoʼ ngen ébɛ wɛ̌bāŋ mɛ á yə̌l ngen éláán.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Hɛ́ɛ Petro ábádtɛɛ́ mɔ́ áte aá, “Ké nkə́ŋ mɔ́ɔ bésɛ̄lɛ̄ɛ̄ mɛ, méebáŋgé wɛ áyə̄l mbêd.” Bembapɛɛ ábíníí bésyə̄ə̄l bɔ́mpē bénhɔ̄b melemlem. ");
INSERT INTO bssNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ámbīd e nɛ̂ Yesuɛ ne ábē bembapɛɛ bênkɛ̌ á abwɔ́g á hǒm áde béchə́géʼáá bán Getsɛmani. Áde bépédé Yesuɛ anláá bɔ́ aá, “Nyédyɛɛ hɛ́n, mɛ-ʼɛ ńkɛ ńkáne.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ankɛɛ́n Petro, Jemsɛ ne Jɔnɛ âkáne. Ndəŋge ne metake híin bêmpií mɔ́ á nlém-tê. ");
INSERT INTO bssNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Dɔ́ɔ álâŋgɛɛ́ bɔ́ aá, “Ndəŋge echě edé mɛ á nlém, ehɛle-sɛ ewúú mɛ. Nyélyəg hɛ́n, nyédyɛɛn mɛ epin.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ansídé áʼsō, abwém yə̌l ásē, boŋ ákânneʼ aá nzé nzii edé echě ene póndé e metake éhɛlɛɛ́ se ébāmē mɔ́, ébame. ");
INSERT INTO bssNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Anhɔ́b aá, “A-Tɛ̂, Titɛ́ɛ, ehɛle ébɛl kéchéé. Kobɛ́n mɛ ḿmɛ́n metuné. Boŋ ké nɛ̂, bɛ̌l ngáne ébóŋnédé wɛ, saké ngáne ébóŋnédé mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Áde ámáá akáne, antǐm ámbīd wɛ́ɛ ábê bembapɛɛ béláán. Antán nɛ́ɛ békúnɛɛ́. Dɔ́ɔ álâŋgɛɛ́ Petro aá, “A-Simɔn, ekúneʼ-ɛ? Cheé ékə́ə́ boŋ weéhɛle awɛsɛn âdyɛɛn mɛ epin ké háwa pɔ́g? ");
INSERT INTO bssNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nyédyɛɛ epin, nyékânne-ʼɛ âbɛl nɛ́n Dyǒb déemwǎg-sɛ mekəgsɛn mépiinéd nyé. Nlém ńdə́ə́ abɛl boŋ ekob é yə̌l édé mbwɔ́g.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Antǐm ámbīd ámpē, ákɛ akáné melemlem ngáne ánsēbɛ̄ɛ̄ akáne. ");
INSERT INTO bssNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Áde átímé ámbīd ámpē, antán nɛ́ɛ békúnɛɛ́ áyə̄le eʼchó bémbɛ̄ bɔ́ á dǐd bwâmbwam. Né-ɔɔ́ bénkêmbííʼɛ́ chǒm éche bélâŋgɛɛ́ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Áde átímé ámbīd ngen éche élóntɛ́né éláán dɔ́ɔ álâŋgɛɛ́ bɔ́ aá, “Nyêlyəgé nyêkúneʼ nyêkɔ́mme-ʼɛ nyé áte-yɛ? Nɛ̂ ákwógé! Póndé epedé echě bɛ́bɛɛ́ Mwǎn-a-Moonyoŋ á mekáá mé bad bé mbéb. ");
INSERT INTO bssNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nyépáde ásē dékag. Nyénɔneʼ, mod awě akií mɛ ntúrɛ́ mɔ́ ahúɛʼ nɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ehɔ́b éepedɛɛ́ Yesuɛ amaa á nsəl boŋ Judasɛ ápag. Judasɛ abédɛ́ɛ mbapɛɛ nhɔ́g átîntê e bembapɛɛ dyôm-ne-bébɛ ábe Yesuɛ. Ampɛ̌ ne ndun e mod. Ábê bad bénwālē nkwáté ne mbid. Beprisɛ bémbáá, bemeléede bé mbéndé ne bad bémbáá bé Israɛl bɔ́ɔ bénlōm bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Bɔɔb-pɔɔ́, ntúrɛ́ awe Yesuɛ ammǎd bɔ́ eʼchemléd abɛ aá, “Kénzɛ́ɛ́ awě mɛ́hɛ̄ɛ̄ tə̂l, né mod awě nyéhɛdɛɛ́ mɔ̂ne. Nyékôb mɔ́, nyéchə́ə-ʼɛ mɔ́ bwâm boŋ nyékɛɛne mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judasɛ apedé-ʼaá pɛɛ́n, átōmē-ʼɛ wɛ́ɛ Yesuɛ. Anhɔ́b aá, “A-meléed.” Ahɛ́-ʼɛ mɔ́ tə̂l. ");
INSERT INTO bssNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Hɛ́ɛ ábê bad békóbé Yesuɛ, béwéd-tɛ mɔ́ achə́ə. ");
INSERT INTO bssNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Dɔ́ɔ mod nhɔ́g átîntê e bad ábe bémbɛ̄ ne Yesuɛ ádólé nkwáté á abám, nɛ́ɛ átómté mɔ́, asɛ́l-lɛ ntâŋ awě prisɛ ambáámbáa etúu. ");
INSERT INTO bssNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Hɛ́ɛ Yesuɛ ásɛdtɛɛ́ bɔ́ aá, “Nchîb mɔ́ɔ ńdíi awě nyépɛ́ɛ́né nkwáté ne mbid ahyɛ dé akób-ɛ? ");
INSERT INTO bssNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Epun tɛ́ɛ́ mbédé á Ndáb-e-Dyǒb ne nyé, ń'yə̄gtē bad, nyéekóbe mɛ. Boŋ eʼyale éʼ kálag e Dyǒb éʼtə́ŋgɛ́né alón.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hɛ̂ dɔ́ɔ bembapɛɛ bésyə̄ə̄l bétɛ́dté mɔ́, boŋ bétómé mehélé. ");
INSERT INTO bssNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kɔ́demod pɔ́g ebédé áhed, éhīdē Yesuɛ ámbīd. Anwáá dásɔ̄ esóŋ é abad chěmpɛn. Ábê bad bênkə̌g bán békôb mɔ́, ");
INSERT INTO bssNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","boŋ antóm mehélé ne nsôb, áchennéd-tɛ bɔ́ échê esóŋ é abad. ");
INSERT INTO bssNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bad ábe bénkōb Yesuɛ bênkɛɛ́n mɔ́ wɛ́ɛ Prisɛ Ambáámbáa. Beprisɛ bémbáá, bad bémbáá bé Israɛl ne bemeléede bé mbéndé bêmpɛ̌ bélādɛ̄n áhed. ");
INSERT INTO bssNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Áde békɛɛnɛɛ́ Yesuɛ nɛ̂, Petro ahídéʼáá mɔ́ ámbīd mwǎ etûn kə́ə́ŋ asɔ́l á eyáde éche prisɛ ambáámbáa. Andyɛɛ́ áhed ne benɔn bé Ndáb-e-Dyǒb, áwālē muú. ");
INSERT INTO bssNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bɔɔb-pɔɔ́, beprisɛ bémbáá ne bad bé káánsɛl bésyə̄ə̄l béhɛ́déʼáá bad ábe bɛ́bīd mbóŋ é metóm á nló wɛ́ɛ Yesuɛ âbɛl nɛ́n béwúu mɔ́, boŋ bénkênkudté ké nhɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ekud é bad émbīd mɔ́ mbóŋ é metóm á yə̌l, boŋ béēbédɛɛ́ nsəl nhɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Hɛ́ɛ doŋge á bad bétyéémé ámīn, boŋ bébīdē mɔ́ mbóŋ é metóm bán, ");
INSERT INTO bssNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Sênwóg nɛ́ɛ áhɔ́bé aá, ‘Mɛ̌bootéd enɛ́n Ndáb-e-Dyǒb echě baányoŋ bélóó, nlóŋ empée, átîntê e eʼpun éʼláán echě béēlôŋnɛɛ́ mekáá.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Boŋ ké nɛ̂, échab mbóŋ é metóm énkêmbáá nsəl nhɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Dɔ́ɔ prisɛ ambáámbáa átyéémé ámīn átîntê e bad bé káánsɛl, boŋ ásɛdté Yesuɛ aáken, “Weewóoʼɛ́ dyamdyam ahɔ́b tə̂ŋgɛne dyam ádě ábɛ́n bad béhɔ́bé wɛ á yə̌l-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Boŋ Yesuɛ andyɛɛ́ mɔ́ ngɛ̂n, enkênkobɛ́ɛ́ dyamdyam. Dɔ́ɔ ene prisɛ ambáámbáa ésɛdtɛɛ́ mɔ́ ámpē aá, “Wɛ-ɛɛ́ edé Ane-awě-Béwɔ́gté, Mwǎn awě Dyǒb áde bad bébagɛɛ́ edúbé-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Hɛ́ɛ Yesuɛ ákwɛntanné aá, “Mɛɛ́ ndé, nyɛ́ɛ̄nyīn-nɛ ngáne Mwǎn-a-Moonyoŋ ádyɛ́ɛ́ á ekáá émbáá é Dyǒb a Ngum. Nyɛ́ɛ̄nyīn-nɛ nɛ́ɛ áhúɛʼɛ́ á mbag-tê ámīn.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Hɛ́ɛ prisɛ ambáámbáa ányábé mbɔ́té âlúmed nɛ́n aá mɔ́lií, boŋ áhɔ̄bē aá, “Mbóŋ éhéé émpēe déhɛdɛɛ́? ");
INSERT INTO bssNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nyêwógé nɛ́ɛ ásyə́əʼɛ́ Dyǒb. Cheé nyéhɔ́bé á yə̌l echê?” Hɛ́ɛ bɔ́ moosyəə́l béhɔ́bɛɛ́ bán atə́ŋgɛ́né awɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Doŋge á bad bêmbootéd mɔ́ meléed asob á yə̌l, békūtān mɔ́ mǐd, bébɔmé mɔ́, bélāŋgē-ʼɛ mɔ́ bán, “Láá-ʼɛ sé mod awě abɔmé wɛ.” Dɔ́ɔ bembəledɛ bétédé mɔ́, boŋ bébootéd-tɛ mɔ́ abɔmted. ");
INSERT INTO bssNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Wɛ́ɛ Petro ádyɛ́ɛ́ ásē nɛ̂ á eyáde-tê, dɔ́ɔ mbəledɛ nhɔ́g a mmwaád awě prisɛ ambáámbáa ápédé. ");
INSERT INTO bssNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Annyín Petro awále muú. Dɔ́ɔ ásímné mɔ́ boŋ álāŋgē mɔ́ aá, “Wɛ́mpē wembɛ́ ne Yesuɛ awě abídé á Nazarɛt.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Boŋ Petro ambáŋ échê ehɔ́b á yə̌l, aá, “Meebíiʼɛ́, meesóŋtán-naá chǒm éche éhɔ́bɛɛ́.” Amaá-aá ahɔ́b nɛ̂ abíd-tɛ á mmwɛ. Ene póndé chěn nchóm-a-kúb antóŋ. ");
INSERT INTO bssNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Dɔ́ɔ ane mbəledɛ ányíné mɔ́ ámpē boŋ ábootéd bad ábe bébédé bɛnbɛn aláa aá, “Anɛ́n mod adé nhɔ́g awě mɔ́mpē ahídéʼáá Yesuɛ.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Boŋ Petro ambáŋ á yə̌l ámpē. Éebemɛɛ́ áte ámpē dɔ́ɔ bad ábe béntyēēm áhed bélâŋgɛɛ́ Petro bán, “Mbále chɔ́ edé. Edé nhɔ́g awě ahídéʼáá Yesuɛ, áyə̄le ebídé á Galilia.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Boŋ Petro ambootéd yə̌l ebómán abɛ ámwāg-kɛ melɛ̌ aá, “Meebíiʼɛ́ anɛ́n mod awě nyétúbɛɛ́ dǐn nɛ̂.” ");
INSERT INTO bssNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Melemlem mé póndé nchóm-a-kúb antóŋ ngen échě élóntɛ́né ébɛ. Hɛ́ɛ Petro ákámtɛ́né chǒm éche Yesuɛ ánlāāʼɛ́ mɔ́ aá, “Nchóm-a-kúb adɛ̂hɔ́b aá mɔ́tōoʼ ngen ébɛ wɛ̌bāŋ mɛ á yə̌l ngen éláán.” Hɛ́ɛ Petro ábə́nlé awɛ́, ábooted-tɛ achii. ");
INSERT INTO bssNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Bǐn éʼsáŋgé-ʼaá sáŋgɛ́n, beprisɛ bémbáá, bad bémbáá bé Israɛl, bemeléede bé mbéndé ne bad bé káánsɛl embáá e bad bé Israɛl békób mbom. Bênhǎŋ Yesuɛ, bébāg-kɛ mɔ́ á mekáá wɛ́ɛ Payledɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Hɛ́ɛ Payledɛ ásɛdtɛɛ́ mɔ́ aáken, “Wɛ-ɛɛ́ edé kə̂ŋ e bad bé Israɛl-ɛ?” Yesuɛ ankwɛntɛ́n mɔ́ aá, “Ngáne éhɔ́bé.” ");
INSERT INTO bssNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Beprisɛ bémbáá bémbān mɔ́ ekud é mekan á yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Hɛ́ɛ Payledɛ ásɛdtɛɛ́ mɔ́ ámpē aá, “Weewóoʼɛ́ dyamdyam âhɔ́b-ɛ? Mmǒn wógéʼ ekud é mekan échě béhɔ́bɛɛ́ wɛ á yə̌l.” ");
INSERT INTO bssNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Boŋ Yesuɛ enkênhɔ́bpé dyamdyam. Nɛ̂ dénkɔ̄mēd Payledɛ yə̌l áte. ");
INSERT INTO bssNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bɔɔb-pɔɔ́, émbɛ̄ nɛ́n bán á Ngande e Nnyíme-ámīn, Payledɛ ammɛntɛ́n mod a mbwɔg nhɔ́g abíded á mbwɔg. Ane mod abágéʼáá mod ké ahéé awě bad bênhɛdɛ́nné mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ene póndé mod nhɔ́g ambɛ́ á mbwɔg awě béchə́géʼáá bán Barabasɛ. Abédé ne bad ábe béntyēēmɛ̄n nkamlɛn ń Roma. ");
INSERT INTO bssNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Dɔ́ɔ ndun e mod épédé wɛ́ɛ Payledɛ, boŋ bélāŋgē mɔ́ bán ábɛl ngáne ámɛ́ntɛ́né bɔ́ abɛle. ");
INSERT INTO bssNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Hɛ́ɛ ásɛdtɛɛ́ bɔ́ aáken, “Nyêhɛdeʼ bán, ḿbídted nyé kə̂ŋ e bad bé Israɛl-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Abíi áde ámbīīʼɛ́ aá kɔ́njí edé beprisɛ bémbáá áte á yə̌l wɛ́ɛ Yesuɛ, dɔ́ɔ dênkə̌ŋ boŋ ásɛ̄dēd bɔ́ nɛ̂. ");
INSERT INTO bssNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Boŋ beprisɛ bémbáá békónéʼáá ábê bad bán béláa Payledɛ bán ábídted bɔ́ dásɔ̄ Barabasɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Payledɛ ansɛdéd bɔ́ ámpē aá, “Chán-nɔ̄ nyéhɛdɛɛ́ bán ḿbɛl ne mod awě nyéchəgɛɛ́ bán kə̂ŋ e bad bé Israɛl?” ");
INSERT INTO bssNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Dɔ́ɔ bélébpɛɛ́ eʼsaád bán, “Bomé mɔ́ á awɔg.” ");
INSERT INTO bssNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Hɛ́ɛ Payledɛ ásɛdtɛɛ́ bɔ́ aáken, “Áyə̄le chán? Ebébtéd éhéé ábɛ́lé?” Boŋ bênnabé abón bán, “Bomé mɔ́ á awɔg.” ");
INSERT INTO bssNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Né-ɔɔ́, ngáne Payledɛ áhɛ́déʼáá aá mɔ́kódɛd ábê bad mewêmtɛn, ambídtéd bɔ́ Barabasɛ. Ambɛ̌ kunze aá, sə́nze ébɔm Yesuɛ, boŋ békɛ bébome-ʼɛ mɔ́ á awɔg. ");
INSERT INTO bssNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sə́nze éntēd Yesuɛ, békɛ̄ɛ̄n mɔ́ á eyáde é nkamlɛnɛ, bélād-tɛ baáb ábíníí áte áhed. ");
INSERT INTO bssNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bénwāād mɔ́ mengombe ḿme méyəgeʼ ḿme méwágné mengombe mé kə̂ŋ, bélóŋ-ʼɛ ekóté é mechə̌, béhɛ́ mɔ́ á nló. ");
INSERT INTO bssNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Dɔ́ɔ bébóótédé mɔ́ awɛl, bélɛnté mɔ́ bán, “A-kə̂ŋ e bad bé Israɛl, edúbé ébɛ̂ ne wɛ!” ");
INSERT INTO bssNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bébɔ́méʼáá mɔ́ ntóŋ á nló, bésobtád mɔ́ meléed á yə̌l, bébwɔ̄gkē-ʼɛ mɔ́ mebóbóŋ âwɛl mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Áde bémáá mɔ́ awɛl, bénhūd mɔ́ ḿmê mengombe á yə̌l, bétīmēd mɔ́ éche mbɔ́té chěn á yə̌l. Nɛ́ɛ bémádé nɛ̂, bênkɛɛ́n mɔ́ âkɛ dɛ̂bome mɔ́ á awɔg. ");
INSERT INTO bssNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Áde békagkɛ́ nɛ̂, dɔ́ɔ bébómné mod awě ambíd á dyad á Sirinɛ. Dǐn démbɛ̄ mɔ́ bán Simɔnɛ. Simɔnɛ abédɛ́ɛ sáá awě Alɛsandaa bɔ́ Refusɛ. Simɔnɛ atóméʼáá âsɔ́l á dyad-tê. Dɔ́ɔ békóbé mɔ́ boŋ bényāgtē mɔ́ bán ápêm awɔg áde Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Dɔ́ɔ bépédé hǒm áde béchə́géʼáá bán, Golgota, awě adé nɛ́n bán, “Hǒm dé Ebóŋgɛ́l é Nló.” ");
INSERT INTO bssNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Áhed bêmbɛ̌ Yesuɛ mǐm ḿme béládtɛ́né ne bwɛl ábe béchəgɛɛ́ bán mía bán ámwɛ̂, boŋ enkênkwɛntɛ́nné amwɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bêmbomé Yesuɛ á awɔg. Bênsǐd mbambú âkab éche mbɔ́té. ");
INSERT INTO bssNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mbwɛmbwɛ á ngə́ŋ abog dɔ́ɔ bébómmé mɔ́ á awɔg. ");
INSERT INTO bssNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Chǒm éche bêntenlé á awɔg áwe nló mîn âlúmed nzɔm echě bébómnédé mɔ́ á awɔg émbɛ̄ nɛ́n bán, “Kə̂ŋ e bad bé Israɛl.” ");
INSERT INTO bssNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bêmbomé-ʼɛ bechîb bébɛ bɔ́mpē á awɔg, nhɔ́g á pɛd e ekáá émbáá eche Yesuɛ, aníníí-ʼɛ á pɛd e ekáá é emwɛd. ");
INSERT INTO bssNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bad ábe bétóméʼáá nzii bɛnbɛn ne áhed bébɔ́méʼáá nló, bébwēmmē-ʼɛ mɔ́ nzyə́ŋ bán, “Ahâ! Wenhɔ́b wɛɛ́ mɔ́ɔ̄bōōtēd Ndáb-e-Dyǒb, wɛɛ́ mɔ́lōŋ-ʼɛ chɔ́ ámpē átîntê e eʼpun éʼláán. ");
INSERT INTO bssNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Sǒŋ-ɔ̄ echoŋ yə̌l bɔɔb, ésud ásē á awɔg.” ");
INSERT INTO bssNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Melemlem nɛ̂ dɔ́ɔ beprisɛ bémbáá ne bemeléede bé mbéndé béwɛ́léʼáá mɔ́. Běn ne běn béhɔ́béʼáá bán, “Achǒŋtéʼáá bad, bɔɔb eéhɛlɛɛ́ eche yə̌l awôŋgɛn. ");
INSERT INTO bssNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mɔ́ awě ahɔ́bé aá mɔ́ɔ mɔ́dē Ane-awě-Béwɔ́gté, aá mɔ́ɔ mɔ́dē-ʼɛ kə̂ŋ e bad bé Israɛl ásud-tɔɔ́ ásē á awɔg hɛ̂ bɔɔb, dényîn âbɛl dédúbe.” Ábê bechîb ábe bêmbomɛ́ɛ́ á awɔg nchoo ne Yesuɛ bɔ́mpē bésyə́ə́ʼáá mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Áde kəd épédé, ehíntɛ́n ênkwɛ̌ hǒm ásyə̄ə̄l, kə́ə́ŋ ne á ngə́ŋ éláán. ");
INSERT INTO bssNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Áde ngə́ŋ éláán épédé, Yesuɛ anlébé esaád aá, “Elí, Elí, lámá sábátāni.” Nɛ́n adé nɛ́n bán, “A-Dyǒb ádêm, a-Dyǒb ádêm, cheé ékə́ə́ boŋ étɛdté mɛ?” ");
INSERT INTO bssNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nɛ́ɛ doŋge á bad ábe bémbɛ̄ bɛnbɛn béwógé nɛ̂, bénhɔ̄b bán, “Nyéwógeʼ, achɛ̂nle Elaijaa aá áhyɛ áwôŋgɛn mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Hɛ́ɛ mod nhɔ́g ányə́gté boŋ átédé kuchá, átɔdtéʼ á ebɛ́ntéd é mǐm-tê, ásɔméʼ á ntóŋ boŋ áhāg mɔ́ á nsəl aá ámwɛ̂. Anhɔ́b aá, “Nyémwɛ dényîn nzé Elaijaa ǎhyɛ mɔ́ asuded á awɔg.” ");
INSERT INTO bssNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Hɛ́ɛ Yesuɛ álébpé esaád boŋ ámīɛ̄-ʼɛ nlém. ");
INSERT INTO bssNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ene póndé chěn abad áde dênkǎb Ndáb é Dyǒb áte, dênsalé áte eʼpɛd éʼbɛ bootya ámīn kə́ə́ŋ ápɛ̄-ʼɛ ásē. ");
INSERT INTO bssNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ádě mod ambáá a sə́nze awě antyéém Yesuɛ áʼsō-te ânɔn mɔ́ ányíné ngáne Yesuɛ áwédé, anhɔ́b aá, “Ne mbále, anɛ́n mod abédɛ́ɛ Mwǎn a Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bebaád behɔ́g bɔ́mpē bémbɛ̄ nchabnede bénɔneʼ mekan mésyə̄ə̄l ḿme mébɛnlad. Átîntê e ábê bebaád, Maria Magdalɛnɛ, Salomɛ ne Maria awě achyáá Jemsɛ asad bɔ́ Josɛb, bémbɛ̄ áhed. ");
INSERT INTO bssNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ábɛ́n bebaád béhídéʼáá Yesuɛ áde ámbɛ̄ɛ̄ á Galilia, béwōŋgān-nɛ mɔ́. Ekud é bebaád émpēe éche bɔ́bɔ̄ɔ bêmpɛ̌ á Jerusalɛm chɔ́mpē êmpɛ̌ áhed. ");
INSERT INTO bssNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Mod nhɔ́g abédé awě béchə́géʼáá bán Josɛbɛ. Ambíd á dyad á Arimatia. Anɛ́n mod abédɛ́ɛ mod e edúbé a káánsɛl embáá e bad bé Israɛl. Mɔ́mpē asinéʼáá póndé echě nkamlɛn ń Dyǒb mɛ́pɛɛ́. Ngáne émbɛ̄ɛ̄ mbwɛ mé mboŋsɛ́n (nɛ́dē áde mbwɛ-mé-nkɔ́me-áte ńlyə́gé nɛ́ɛ chǎn), hɛ́ɛ ákáá nlém, boŋ ápag wɛ́ɛ Payledɛ bɛnbɛn ne ngukɛ́l, álāŋgē mɔ́ aá ábɛ mɔ́ ndim ḿme Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Áde Payledɛ áwógé bán Yesuɛ amaá awɛ́, yə̌l enkɔ́m mɔ́ áte. Hɛ́ɛ álómé ane mod a mbáá a sə́nze achəg boŋ ásɛdté mɔ́ ké Yesuɛ amaá awɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Áde ene sə́nze élāŋgē mɔ́ aá Yesuɛ awédé, dɔ́ɔ ákwɛ́ntɛ́né aá Josɛbɛ átêd ḿme ndím. ");
INSERT INTO bssNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josɛbɛ anchǎn mbɔ́m. Antéd Yesuɛ ndim, ákāān mɔ́ ene mbɔ́m, alímé-ʼɛ mɔ́ á soŋ-tê echě bépwɔ́gé aláá áte. Ámbīd ene, antínéd aláá á mbáá ákɔ́lɛn nsəl ń soŋ. ");
INSERT INTO bssNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdalɛnɛ ne Maria awě anchyáá Josɛɛ bénɔ́néʼáá wɛ́ɛ bélîmmɛɛ́ Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ámbīd e mbwɛ-mé-nkɔ́me-áte Maria Magdalɛnɛ, Maria awě achyáá Jemsɛ ne Salomɛ, bênchǎn dyɔ̌g dé elod é bwâm âkɛ dé awɔ́ged ndim ḿme Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mbwɛmbwɛ mé epun éʼsō é Sɔ̂ndɛ́ áde enyɛn étúbɛɛ́ dɔ́ɔ békíí á soŋ. ");
INSERT INTO bssNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Áde békagkɛ́, dɔ́ɔ bésɛdtɛɛ́ nhɔ́g ne aníníí bánken, “Nzɛ́ɛ́ ǎhūdē syánē aláá á nsəl ń soŋ?” ");
INSERT INTO bssNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Dɔ́ɔ bésádé dǐd, boŋ bényīnē bán bémáá ádê aláá ahúd. Aláá áded dênkəl bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Hɛ́ɛ bésɔ́lé á soŋ-tê, boŋ bényīnē kɔ́demod edyɛɛ́ á nkəg á pɛd e ekáá émbáá. Anhɛ́ megombe ḿme mépúbeʼ. Nɛ́n dénkōbēd bɔ́ mbwɔ́g bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Hɛ́ɛ ene kɔ́demod élâŋgɛɛ́ bɔ́ aá, “Nyéebááʼ, mbíí mɛɛ́ nyêhɛdeʼ Yesuɛ, mod a Nazarɛt awě bêmbomɛ́ɛ́ á awɔg. Apuúdé, eésaá hɛ́n. Nyénɔne wɛ́ɛ bênnaádté mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nyékag-kɔɔ́ bɔɔb nyéláa ábē bembapɛɛ, taŋge Petro, bán Yesuɛ apuúdé, ‘Akag-kɛ áʼsō á Galilia. Áwed-taá nyɛ́nyīnnē mɔ́ ngáne ánlāāʼɛ́ nyé.’ ” ");
INSERT INTO bssNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Hɛ́ɛ bébóótédé anəŋ ne menyáké ḿme bényíné. Bémbīd á soŋ-tê bébootéd-tɛ anyəged. Béēlâŋge-ʼáa modmod dyamdyam áyə̄le mbwɔ́g ménkōb bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Áde Yesuɛ ámáá apuu, epɔg é mbwɛmbwɛ é epun éʼsō é Sɔ̂ndɛ́, Maria Magdalɛnɛ mɔ́ɔ ánsēbɛ̄ɛ̄ yə̌l alúmed. Anɛ́n mmwaád mɔ́ɔ Yesuɛ ámbīdēdtē eʼdəə́dəŋ bé mbéb saámbé áte. ");
INSERT INTO bssNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Hɛ́ɛ ane mmwaád ákíí boŋ álāŋgē bad ábe bɔ́ɔbɛ Yesuɛ bébágéʼáá. Antán nɛ́ɛ béchyɛʼɛ́ kwééd eche Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Boŋ áde béwógé bán Yesuɛ adé á aloŋgé, bán ane mmwaád anyíné-ʼɛ mɔ́, bénkêndúbɛ́ɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ámbīd e póndé Yesuɛ anlúméd yə̌l wɛ́ɛ ábē bad bémpēe bébɛ áde bébídɛɛ́ á dyad-tê. Boŋ enɛ́n ngen anlúméd yə̌l nyaa émpēe. ");
INSERT INTO bssNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Hɛ́ɛ ábɛ̂ bad bétímé ámbīd, békɛ béláá baáb ábíníí. Boŋ ké nɛ̂, baáb bɛ̂ bénkêndúbɛ́ɛ́. ");
INSERT INTO bssNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ámbīd e póndé Yesuɛ anlúméd yə̌l wɛ́ɛ ábē bembapɛɛ dyôm-ne-nhɔ́g áde bédyágkē ndyééd. Bénkêndúbɛ́ɛ́ bad ábe bénhɔ̄b bán bényíné mɔ́ áde ámáá apuu. Né-ɔɔ́, ankáné bɔ́ áte aá béēwóoʼɛ́ adúbe, aá bélɛ́lé-ʼɛ nlém á abum. ");
INSERT INTO bssNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Anláá bɔ́ aá, “Nyékag nkǒŋsé áte ńsyə̄ə̄l, nyékanle bad bésyə̄ə̄l nkalaŋ ḿ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kénzɛ́ɛ́ awě adúbpé boŋ bédusɛ́n-nɛ mɔ́ ǎkǔd eʼchoóchoŋ, boŋ kénzɛ́ɛ́ awě eedúbpe ǎkūd nkɔ́gsɛn. ");
INSERT INTO bssNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bad ábe bédúbpé bɛ́wōŋ ngíne âbɛl mam mé menyáké: bɛ́bīdtē bad eʼdəə́dəŋ bé mbéb áte á dǐn ádêm; bɛ́hɔ̄bē-ʼɛ mehɔ́b mékɔ̄ɔ̄lē. ");
INSERT INTO bssNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bɛ́kōbɛ̄n nyə̌ mekáá, éebɛnlé bɔ́ dyamdyam. Ké bémmwɛ̄-ʼɛ ké eʼwɛ, ábê eʼwɛ béebɛnlé bɔ́ dyamdyam. Bɛ́bān bad bé nkole mekáá á yə̌l, bad bé nkole bɛ̂ bédyɛ̄ɛ̄-ʼɛ bwâm.” ");
INSERT INTO bssNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Áde Sáŋgú Yesuɛ ámáá bɔ́ ḿmɛ́n mekan aláa, dɔ́ɔ Dyǒb ábɛ́lé boŋ ápūmē ámīn. Andyɛɛ́ Dyǒb á ekáá émbáá. ");
INSERT INTO bssNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Hɛ́ɛ bembapɛɛ bébídé, boŋ békɛ békalé Eyale é Dyǒb hǒm tɛ́ɛ́. Sáŋgwɛ́ɛ́ ambɛ́ ne bɔ́, ábɛ̄-ʼɛ bɔ́ ngíne âbɛl mekan mé menyáké, âlúmed nɛ́n aá chǒm éche béhɔ́bɛɛ́ édé mbále. Nyaa empée echě kálag e Makɔsɛ ésógé 16.9-10 (9) Hɛ́ɛ ábê bebaád békíí, boŋ bélāŋgē Petro ne bad ábe bémbɛ̄ ne mɔ́ mekan mésyə̄ə̄l ḿme bénlyə̄gtɛ̄nnē bɔ́, bésɛ̄lē mɔ́ esóŋ-esóŋ. (10) Nɛ́ɛ nɛ̂ átómé, Yesuɛ mwěn anlóm bad nkǒŋsé áte ńsyə̄ə̄l âkal nkalaŋ ḿ bwâm. Ḿmɛ̂ nkalaŋ ḿ bwâm ḿme ńsáá, méehəŋlánné. Ḿmê nkalaŋ ńdíi nkalaŋ tə̂ŋgɛne aloŋgé áde dɛ́bɛ̄ á ngíndé ne á ngíndé.");
INSERT INTO bssNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Á-Tiofilos, mod a edúbé, ekud é bad ékétēd póndé âtel mekan ásē, ḿme mébɛ́nlédé átîntê eʼ syánē. ");
INSERT INTO bssNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bétélé melemlem ngáne dénwōgkē wɛ́ɛ bad ábe bénnyīnɛ̄n mɔ́ dǐd se á mbooted, békalé-ʼɛ Eyale é Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Né-ɔɔ́, ntóó ḿmɛ́n mekan ahɛd áte se á mbooted, nnyíné-ʼɛ nɛ́n mɛɛ́ ébóó mɛ́mpē ńtēd póndé, ńtele wɛ mekan ásē ahɔ́g-ahɔ́gɛ̄. ");
INSERT INTO bssNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nɛ́n dɛ́bɛ̌l wɛɛ́chem mbále tə̂ŋgɛne mekan ḿme émáá abíi. ");
INSERT INTO bssNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Á póndé eche Hɛrɔdɛ ábédé kə̂ŋ e Judeya, mod nhɔ́g ambɛ́ bán Sakaria. Sakaria abédɛ́ɛ prisɛ á nchoo ḿme Abiyaa. Mwaád ambɛ́ dǐn bán Elisabɛtɛ. Mɔ́ ámpē abédɛ́ɛ ngɔn e túmbé eche Arɔnɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Aloŋgé áde bɔ́ mwaád dēmbɛ̄ bwâm áʼsō éʼ Dyǒb. Béhídéʼáá mbéndé éche Sáŋgwɛ́ɛ́ ésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Boŋ bénkênwálɛ́ɛ́ mwǎn ké nhɔ́g áyə̄le Elisabɛtɛ abédé ekɔm. Bɔ́ bad bébɛ bêmmǎd-tɛ achun. ");
INSERT INTO bssNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Bɔɔb-pɔɔ́, áde póndé e nsɔ́n e nchoo ḿme beprisɛ ḿme Sakaria bɔ́ épédé áte, ankɛ̌ nsɔ́n ḿme prisɛ abɛl á Ndáb-e-Dyǒb epun ehɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Mɔ́-ʼaá bêmpwɛdté âsɔ̄l á Ndáb-e-Dyǒb âbɛle Sáŋgwɛ́ɛ́, âhyáad eʼtwɛ́, ngáne nsɔ́n ḿme prisɛ ńhɛ́dnádtáá. ");
INSERT INTO bssNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Áde áhyâŋtɛɛ́ eʼtwɛ́, ndun e mod embɛ́ ámbīd e ebwɔ́g, békânneʼ. ");
INSERT INTO bssNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Hɛ̂ dɔ́ɔ ángɛl e Sáŋgú épíídé mɔ́, etyéém mɔ́ á pɛd e ekáá émbáá bɛnbɛn ne menyán mé eʼtwɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Anyín áde Sakaria ányíné ángɛl, yə̌l enkɔ́m mɔ́ áte, mbwɔ́g ménkōb-pɛ mɔ́ bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Dɔ́ɔ ángɛl élâŋgɛɛ́ mɔ́ aá, “Á-Sakaria, weebááʼ. Dyǒb áwógé wɛ mekáne. Né-ɔɔ́, awǒŋ mwaád Elisabɛtɛ, ǎchyāā mwǎn. Échuu ane mwǎn dǐn wɛɛ́ Jɔnɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Anɛ́n mwǎn ǎwōgēd wɛ menyiŋge. Ndun e mod ámpē ěwōg menyiŋge é echyáa échē. ");
INSERT INTO bssNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ébɛ̄ nɛ̂ áyə̄le ane mwǎn ǎbɛ̄ ndəle a mod áʼsō éʼ Sáŋgú. Eetə̂ŋgɛnɛɛ́ nɛ́ɛ ámwágkē mǐm ḿme méwag, káa chǒm ké échě éwúú áte. Edəə́dəŋ éche Ésáá élōn mɔ́ áte se á ncháátɛ́n. ");
INSERT INTO bssNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ǎtiméd bad bé Israɛl nlém ámbīd wɛ́ɛ Sáŋgwɛ́ɛ́ awě adé ádab Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ǎbɛ̄ áʼsō boŋ Sáŋgwɛ́ɛ́ ápag. Ǎwōŋ-ʼɛ edəə́dəŋ ne ngíne melemlem ngáne nkal éʼdəə́dəŋ Elaijaa aʼbɔɔ́d ánwōŋgē. Ǎchěd bad nlém á abum, âbɛl bad bɔ́ɔbɛ bǎn bétim ásē. Ǎbɛ̌l bad ábe béwúɛ́né Dyǒb nló áte, béhəŋlɛ́n, béwóŋ debyɛ́ɛ́ nɛ́ɛ bad ábe bétyéeme áʼsō éʼ Dyǒb. Né-ʼaá áboŋsɛ́nné epɛ éche Sáŋgwɛ́ɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaria ansɛdéd ángɛl aá, “Cheé élûmte mɛ nɛ́n bán ádɛ́n akan áde éhɔ́bé dɛ́bɛnléd? Mměn mmaá achun. Awêm mwaád-tɛ ámpē amaá kɔ̂d atóm.” ");
INSERT INTO bssNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Dɔ́ɔ ángɛl étimtanné mɔ́ aá, “Ndíī Gabriɛlɛ, mésɛ́nzɛ ḿme mébɛnle Dyǒb nsɔ́n. Dyǒb álómé mɛ áwōŋ, âláa wɛ ḿmɛ́n nlébtéd ḿ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Bɔɔb-pɔɔ́, ngáne wéēdūbpɛɛ́ dyam áde ńhɔ́bé, wɛ̌kwɛ̌ ebóbé kə́ə́ŋ ne póndé echě mam mésyə̄ə̄l ḿme ńláŋgé wɛ mɛ́lōnnē. Mekan mésyə̄ə̄l mɛ́bɛnléd-tɛ á póndé echě métə́ŋgɛ́né abɛnled.” ");
INSERT INTO bssNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ene póndé esyəə́l bad bésínéʼáá Sakaria ámbīd ebwɔ́g, bényāgēʼ chǒm éche ékə́ə́ boŋ ápɛ̄ abem á Ndáb-e-Dyǒb-te nɛ̂. ");
INSERT INTO bssNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Áde ábídé áwed, eéhɛleʼaá dyamdyam ahɔ́b áwāb. Dɔ́ɔ béchémé nɛ́n bán, anyíné ndɔ́g á Ndáb-e-Dyǒb. Mekáá mɔ́ɔ álúmtánnáá bɔ́, ésebán ahɛle dyam ahɔ́b. ");
INSERT INTO bssNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Póndé e nsɔ́n echě Sakaria emaá-ʼaá áte, asú á ndáb. ");
INSERT INTO bssNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ámbīd e póndé mwaád ambɛ́ nkog. Ankoó yə̌l á ndáb-te á etûn é ngɔn étáan. ");
INSERT INTO bssNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Anhɔ́b aá “Kə́ə́ŋ ne á asóg Sáŋgwɛ́ɛ́ abɛ̌nlé mɛ ádɛ́n. Awógé mɛ ngɔl, ahúdé-ʼɛ mɛ eʼsôn áyə̄l átîntê e ábêm bad.” ");
INSERT INTO bssNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Ádě dyěm áde Elisabɛtɛ ádíí ngɔn ntóób, Dyǒb dénlōm ángɛl Gabriɛlɛ á dyad á Nazarɛt, á aloŋ á Galilia, wɛ́ɛ ngɔndérɛ pɔ́g bán Maria. Maria enkêmbííʼɛ́ mwɛnchóm. Mod ankií mɔ́ awe béchə́géʼáá bán Josɛbɛ. Josɛbɛ ambíd á túmbé echě Kə̂ŋ Dabidɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Áde ángɛl étáné Maria enhɔ́b aá, “Á-Maria, nsaŋ ḿbɛ̂ ne wɛ! Edíī mmwaád awě akudé mendɛ ne Dyǒb. Titɛ́ɛ Dyǒbɛ adé ne wɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nɛ́n dêntagéd Maria á mewêmtɛn-tê bwâmbwam. Akɔ̌gláádtáá á nlém-tê âbíi chǒm éche ene nyaa e melɛntɛn éhɛle élûmteʼ. ");
INSERT INTO bssNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Dɔ́ɔ ene ángɛl élâŋgɛɛ́ mɔ́ aá, “Á-Maria! Weebááʼ, nsimé ń Dyǒb ńdé ne wɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ébíi wɛɛ́, mɔ́ɔ̄bɛ̄ nkog. Wɛ̌chyāā mwǎn a mwɛnchóm. Échuu mɔ́ dǐn wɛɛ́ Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ane mwǎn ǎbɛ̄ ndəle a mod. Bɛ́chə̌g mɔ́ bán, Mwǎn a Dyǒb á Ngum. Titɛ́ɛ Dyǒbɛ mwěn ǎbɛ̌ mɔ́ atii dé nkamlɛn áde sáá ambáá Dabidɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mɔ́ ǎkamlɛ́n abum á ndáb áde Jakɔbɛ á ngíndé ne á ngíndé. Nkamlɛn ḿme méewóŋgé asóg.” ");
INSERT INTO bssNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Hɛ́ɛ Maria ásɛdtɛɛ́ ángɛl nɛ aáken, “Chán ńhɛle nchyáá mwǎn áde méēbīīʼɛ́ mwɛnchóm?” ");
INSERT INTO bssNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ene ángɛl enkwɛntɛ́n mɔ́ aá, “Edəə́dəŋ éche Ésáá épií wɛ. Ngum e Dyǒb ěkūdtɛ̄n wɛ. Né-ɔɔ́, mwǎn awě asáá, awě wɛ́chyāāʼɛ́, ǎchəgnéd bán Mwǎn a Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Bíí wɛɛ́, Elisabɛtɛ, mwǎnyoŋ a túmbé pɔ́g, mɔ́mpē adé nkog á eʼchun-tê. Mɔ́ awě bénhɔ̄bpē bán adé ekɔm, adé dyěm bɔɔb ngɔn ntóób. ");
INSERT INTO bssNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Édé nɛ̂ áyə̄le dyamdyam déesaá áde átómé Dyǒb áte.” ");
INSERT INTO bssNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Hɛ́ɛ Maria áhɔ́bɛɛ́ aá, “Ndíī mbəledɛ awe Sáŋgwɛ́ɛ́. Ébɛ̂ ne mɛ ngáne éhɔ́bé.” Dɔ́ɔ ene ángɛl étɛ́dté mɔ́ boŋ ékag. ");
INSERT INTO bssNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ḿmê mesú měn, Maria anlǎd yə̌l ne mehɛ́l mésyə̄ə̄l, ákɛ̄ á dyad á Juda ahɔ́g áde ádé á eʼkone-tê. ");
INSERT INTO bssNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Áde ápédé áwed, ansɔ́l á ndáb echě Sakaria, álɛ̄lēd Elisabɛtɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Awóg áde Elisabɛtɛ áwógé Maria ḿme melɛntɛn, mwǎn anhɔ́bnéd Elisabɛtɛ á abum-tê. Edəə́dəŋ éche Ésáá êmpií mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Dɔ́-ʼaá álâŋgɛɛ́ Maria ne esaád é ngíne nɛ́n aá, “Nnam ḿbɛ̂ ne wɛ átîntê bebaád bésyə̄ə̄l. Nnam ḿbɛ̂ ne mwǎn awe wɛ́chyāāʼɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Chán ébɛ́nlédé éche mɛmɛ ńkúdé échɛ́n edúbé? Chán nyaá awe Sáŋgwɛ́ɛ́ áhɛle áhyɛ áwêm-é? ");
INSERT INTO bssNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Awóg áde ńwógé ḿmôŋ melɛntɛn, mwǎn ahɔ́bté mɛ yə̌l á abum-tê ne menyiŋge. ");
INSERT INTO bssNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Dyǒb ánámté wɛ áyə̄le edúbpé nɛ́n wɛɛ́, dyam áde Sáŋgwɛ́ɛ́ áláŋgé wɛ dɛ́bɛnléd.” ");
INSERT INTO bssNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Hɛ́ɛ Maria áhɔ́bɛɛ́ aá, “Nkêmte Sáŋgwɛ́ɛ́ ne nlém ḿmêm ńsyə̄ə̄l, ");
INSERT INTO bssNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","edəə́dəŋ échêm ámpē éwógne Dyǒb menyiŋge. Mɔ́ adé awêm mod a eʼsoósoŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Áyə̄le achemé mɛ awě ndé awe mwǎ mbəledɛ ngɛ̂n. Bootya bɔɔb, âkɛ áʼsō, nyoŋgɛl e bad tɛ́ɛ́ ěhɔ̄b bán, ńdé mmwaád awě Dyǒb ánámté. ");
INSERT INTO bssNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Dyǒb á Ngum abɛ̌nlé mɛ ndəle a akan. Mɔ́ adé ane awě asáá. ");
INSERT INTO bssNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ngɔl echê ěbɛ̄ nyongɛl ne nyongɛl e bad tɛ́ɛ́, ámīn e kénzɛ́ɛ́ awě abage mɔ́ edúbé. ");
INSERT INTO bssNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Abɛlé ndəle a akan ne éche ekáá chěn. Apuúdtédé bad ábe bédé kúmbe mewêmtɛn áte. ");
INSERT INTO bssNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ahúdé benkamlɛnɛ áwāb metii mé nkamlɛn, boŋ achə́gté bad ábe bésúdté yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Akódté bad ábe bétagne nzaa ne kəse é bwěm, boŋ anané bad ábe bébúdé awóŋ aá bésūɛʼ ne mekáá mé ngɛ̂n. ");
INSERT INTO bssNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Akǎmtɛ́né âlóned akag áde ámbɛɛ́ ábɛ̄d betaa, bootya Abrahamɛ ne ḿmē mbyaa ńsyə̄ə̄l kə́ə́ŋ ne á ngíndé. Né-ɔɔ́, awóŋgɛ́né ábē bembəledɛ, bad bé Israɛl.” ");
INSERT INTO bssNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ámbīd e nɛ̂, Maria andyɛɛ́n Elisabɛtɛ ngɔn éláán, boŋ ásūɛ̄ʼ ámbīd. ");
INSERT INTO bssNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ámbīd e póndé, eʼwɛ éʼ mwǎn bénkōb Elisabɛtɛ. Anchyáá mwǎn a mwɛnchóm. ");
INSERT INTO bssNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Túmbé echê ne bad ábe bɔ́bɔ̄ɔ bédyɛ́ɛ́ʼáá abwɔ́g ahɔ́g, bénsōŋtɛ̄n nɛ́n bán Sáŋgwɛ́ɛ́ ábagé mɔ́ sáŋkalaa a nsimé, bɔ́mpē béwóg menyiŋge. ");
INSERT INTO bssNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mbwɛ mé asóŋ-á-yə̌l (ámbīd e eʼpun waam) áde béhyédé mwǎn ayag, béhɛ́déʼáá mɔ́ dǐn áde sáá achuu bán Sakaria. ");
INSERT INTO bssNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Dɔ́ɔ nyaá áhɔ́bɛɛ́ aá, “Aáy! Dǐn dɛ́bɛ̄ɛ̄ mɔ́ bán Jɔnɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Hɛ́ɛ bétimtanné mɔ́ bán, “Modmod eésaá áwoŋ túmbé-te awě awóó ádé dǐn.” ");
INSERT INTO bssNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Né-ɔɔ́ bênhəgtɛ́n Sakaria á mekáá mîn âhɛd áte ngáne ádə́ə́ mwǎn dǐn achuu. ");
INSERT INTO bssNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Hɛ́ɛ áhə́gtɛ́né ne mekáá aá bépiined mɔ́ abámbé. Antěl áhed aá, “Dǐn ádíī mɔ́ bán Jɔnɛ.” Anyín áde bad bényíné nɛ̂, menyáké mékōb bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ábwɔ̄g-ábwɔ̄g, ehɔ́b énsālē mɔ́ á nsəl, ábootéd-tɛ dyam ahɔ́b ámpē, ákēmtē-ʼɛ Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nɛ́n dénkōbēd bad bésyə̄ə̄l ábe bébédé áhed mbwɔ́g, békɛɛné nkalaŋ hǒm ásyə̄ə̄l á myad mé eʼkone á aloŋ á Judeya. ");
INSERT INTO bssNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mod tɛ́ɛ́ awě anwóg ádɛ́n akan, ankoó dɔ́ á nlém-tê. Bésɛdté bánken, “Ebə́l é mod éhéé anɛ́n mwǎn ábɛ̄ɛ̄-yēē?” Bésɛ́dtéʼáá nɛ̂ áyə̄le bémbīī nɛ́n bán Dyǒb ádé ne ane mwǎn. ");
INSERT INTO bssNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Bɔɔb-pɔɔ́, Edəə́dəŋ éche Ésáá émpií sɛ́ɛ mwǎn, Sakaria. Hɛ́ɛ ábóótédé mam ahɔ́bted, ahɔ́bé aá, ");
INSERT INTO bssNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Mekɛnag mébɛ̂ ne Sáŋgwɛ́ɛ́, Dyǒb á bad bé Israɛl. Békɛn Dyǒb áyə̄le ahyedé ábē bad anyen ásē, akɔ̌dté-ʼɛ bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Akwǒgté ngum a mod á abum á ndáb áde awě mbəledɛ Dabidɛ, mɔ́ɔchoód syánē. ");
INSERT INTO bssNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Seʼ bɔɔ́d ansɔ́n bekal béʼdəə́dəŋ, alóm bɔ́ aá béhɔ́b bán, ");
INSERT INTO bssNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Mɔ́ɔ̄soŋ syánē á mekáá mé bad bé ekɔyí ábe syánē, ne bad ábe békɔ́ɔ́ syánē. ");
INSERT INTO bssNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nɛ̂ dɔ́ɔ Dyǒb álûmtɛɛ́ ngɔl eche ánhīīʼɛ́ ábɛ̄d betaa akag. Né-ʼaá ákámtɛ́né ḿmē melɛ̌, ");
INSERT INTO bssNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","nɛ́dē melɛ̌ ḿme ámmwɛ̄ɛ̄ ne awɛd sáá ambáá Abrahamɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Anhɔ́b aá mɔ́ɔ̄madté syánē asoŋ á mekáá mé bad bé ekɔyí ábe syánē, boŋ déhɛl mɔ́ abɛle ésebán debáaʼ. ");
INSERT INTO bssNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Dɛɛ́bɛnlé mɔ́ póndé eched ne nlém ḿme ńsáá ne mbɛltéd ḿme ńdé ngáne Dyǒb áhɛdɛɛ́, á aloŋgé ádɛ̄d ásyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Wɛ-ɔɔ́, a-mwǎn, bɛ́chə̌g wɛ bán nkal éʼdəə́dəŋ awě Dyǒb á Ngum. Wɛ-ʼaá wɛ̌sēbē Sáŋgwɛ́ɛ́ áʼsō, âboŋsɛn mɔ́ nzii echě ábwɛɛ́ áte. ");
INSERT INTO bssNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Wɛ̌bɛ̌l ábē bad bébíí nɛ́n bán, Dyǒb áchóŋté bɔ́ áyə̄le álágsɛ́né bɔ́ ḿmab mbéb. ");
INSERT INTO bssNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nɛ́n dɛ́bɛnléd áyə̄le ngɔl e Dyǒb ne ábē eʼboŋ bé nlém. Ene ngɔl chɔ́-ʼaá ěkə̌ŋ eʼnyínɛn bé ekíde ábě éʼbídé ámīn éʼpiinéd syánē eʼsoósoŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Né-ɔɔ́ bad ábe bédé á ehíntɛ́n-tê, ne á nsəl ń soŋ, bɛ́kǔd eʼnyínɛn bé eʼkíde. Syánē-ʼɛ dɛɛ́kǔd debyɛ́ɛ́ áde álûmte syánē nzii echě epɛɛne aloŋgé dé nsaŋ.” ");
INSERT INTO bssNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Jɔnɛ ankwǒg, edəə́dəŋ é Dyǒb ébɛ̄-ʼɛ mɔ́ ngíne. Andyɛ̌ é ehyáŋge kə́ə́ŋ ne á póndé eche ábóódtédé eyale é Dyǒb akal á ntə́lé wɛ́ɛ bad bé Israɛl. ");
INSERT INTO bssNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ḿmê mesú-ɔɔ́ Agɔstusɛ, Kaisɛɛ a Roma antóméd mbéndé aá, moosyəə́l awě adé ásē e ḿmē nkamlɛn, ákɛ átelɛn dǐn. ");
INSERT INTO bssNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nɛ́n démbɛ̄ tóŋgé e bad eʼsó. Á póndé eched Kirinusɛ mɔ́ ambɛ́ nló mé aloŋ á Siria. ");
INSERT INTO bssNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mod tɛ́ɛ́ ankɛ̌ áwē dyad âbɛl boŋ bétel mɔ́ dǐn ásē. ");
INSERT INTO bssNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Né-ɔɔ́ Josɛbɛ mɔ́mpē anhidé á dyad á Nazarɛt á Galilia, achə́gé á Betɛlhɛm, dyad áde Kə̂ŋ Dabidɛ á Judeya, áyə̄le ambíd á mbyaa ḿme Dabidɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ankɛ̌ nɛ̂ âbɛl bétôŋ bɔ́ Maria, ngɔndérɛ eche ânkiíʼɛ́. Maria mɔ́-ʼɛ ambɛ́ nkog. ");
INSERT INTO bssNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Á Betɛlhɛm wɛ̂ dɔ́-ʼaá achád ákóbé Maria. ");
INSERT INTO bssNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Anchyáá mwǎn a mwɛnchóm awě átúbné abum. Ankaán mɔ́ eʼpɛd bé mebad, ánāād-tɛ mɔ́ á ebwɔg éche bédídtɛɛ́ eʼlém áte, ngáne etə́l éebédɛɛ́ á ndáb e beken. ");
INSERT INTO bssNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ápɛd eched, benɔn bé mbód bénɔ́néʼáá échāb echoŋ éʼ mbód á hǒm dé medyɛ́ nkuu. ");
INSERT INTO bssNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ángɛl e Sáŋgú empií bɔ́ təléd, ehúmé é Sáŋgú éləŋnéd bɔ́. Mbwɔ́g ménkōb bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Hɛ́ɛ ángɛl élâŋgɛɛ́ bɔ́ aá, “Nyéebááʼ, mpiínédé nyé kəse e nkalaŋ echě ěwōgēd bad bésyə̄ə̄l menyiŋge bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nyébíi bán, epun éʼchii, Nsoodɛ awɛ̂n achyáádté á dyad áde Kə̂ŋ Dabidɛ. Mɔ́ adé Ane awě Dyǒb Áwɔ́gté. Mɔ́ adé Sáŋgwɛ́ɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Eʼchemléd ábe ḿbagɛɛ́ nyé éʼdíi bán, nyɛ́ɛ̄tān mwǎn awe békáŋné eʼpɛd bé mebad ngáne ánáŋgé á ebwɔg éche bédídtɛɛ́ eʼlém áte.” ");
INSERT INTO bssNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Melemlem mé póndé echoŋ é ángɛl émbīd eníníí ángɛl á nkəg təléd, ékɛné Dyǒb bán, ");
INSERT INTO bssNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ehúmé ébɛ̂ ne Dyǒb áde ádé se ámīn, nsaŋ-ʼɛ ḿbɛ̂ ne baányoŋ ábe ábágé nsimé á nkǒŋsé!” ");
INSERT INTO bssNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ámbīd e nɛ̂, échê ángɛl énsū ámīn. Hɛ́ɛ benɔn bé mbód bélâŋgɛɛ́ nhɔ́g ne aníníí bán, “Syáā dékag á Betɛlhɛm, dékɛ dényîn ádê akan áde Dyǒb á Ngum álúmté syánē áte aá ábɛ́nlédé.” ");
INSERT INTO bssNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Dɔ́-ʼaá békíí á mehélé-te, boŋ bédibté Maria bɔ́ Josɛb ne nkə́ə́l ḿ mwǎn nɛ́ɛ ńnáŋgé á ebwɔg éche bédídtɛɛ́ eʼlém áte. ");
INSERT INTO bssNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bémáá-ʼaá anyín nɛ̂, dɔ́ɔ bébóótédé nkalaŋ akal ngáne ángɛl énlāāʼɛ́ bɔ́ tə̂ŋgɛne ane mwǎn. ");
INSERT INTO bssNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bad bésyə̄ə̄l ábe bénwōg nɛ̂, menyáké ménkōb bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria ankoó ḿmɛ́n mam mésyə̄ə̄l á nlém-tê, ádolé mɔ́ áte. ");
INSERT INTO bssNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Hɛ́ɛ benɔn bé mbód bétímé ámbīd, békēmtē Dyǒb, békɛné-ʼɛ mɔ́ áyə̄le mam mésyə̄ə̄l ḿme béwógé, boŋ bényínɛ́n-nɛ dǐd nɛ̂ŋgáne bénlāāʼɛ́ bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ámbīd e eʼpun waam, mbwɛ ḿme béyagɛɛ́ mwǎn, bênchuú mɔ́ dǐn bán Yesuɛ. Ádê dǐn dɔ́ɔ ángɛl êmmadté mɔ́ achəg boŋ nyaá ǎbɛ̄ dyěm. ");
INSERT INTO bssNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Bɔɔb-pɔɔ́, mbéndé e Mosɛɛ ehɛdáá bán, ámbīd e echyáa bébɛ mendɛ âwobe nyɛ̌ mwǎn bɔ́ sɛ́ɛ mwǎn. Áde bémádé nɛ̂, Maria bɔ́ Josɛb bênkɛɛ́n mwǎn á Jerusalɛm âlúmed mɔ́ áʼsō éʼ Sáŋgú. ");
INSERT INTO bssNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bênkɛ̌ nɛ̂ nchoo ne ngáne éténlédé á mbéndé e Sáŋgú bán, Mwǎn a mwɛnchóm tɛ́ɛ́ awě bétúbné abum, bɛ́bɛ mɔ́ á mekáá mé Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bênkɛ̌ nɛ̂ kə́ə́ŋne âbɛ mendɛ ne âlóned mbéndé e Sáŋgú echě ehɔ́bé bán mod ábɛ bé élə̄ə̄ bébɛ káa mbəŋgé ésad ébɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Á Jerusalɛm wê, mod ambɛ́ bán Simionɛ. Ane mod anwóŋ abɛ́ áde atə́ŋgɛ́né áʼsō éʼ Dyǒb, ákoŋgé-ʼɛ mbéndé é Dyǒb. Edəə́dəŋ éche Ésáá émbɛ̄ ne mɔ́. Asinéʼáá póndé echě Dyǒb dɛ́soŋgé aloŋgé á bad bé Israɛl. ");
INSERT INTO bssNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Edəə́dəŋ éche Ésáá êmmǎd-tɛ mɔ́ alúmed nɛ́n aá, éewáá ésebán ányíné Ane awě Sáŋgwɛ́ɛ́ Áwɔ́gté. ");
INSERT INTO bssNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Edəə́dəŋ éche Ésáá êmbɛ̌l Simionɛ ankɛ̌ á Ndáb-e-Dyǒb. Dɔ́ɔ Maria ne Josɛb bépɛ́ɛ́né awab mwǎn Yesuɛ áhed, ngáne mbéndé éhɛ́déʼáá. ");
INSERT INTO bssNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simionɛ ankobɛ́n bɔ́ mwǎn, abwáá mɔ́, boŋ ákēmtē Dyǒb nɛ́n aá, ");
INSERT INTO bssNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“A-Sáŋgú, ngáne élónté ádōŋ akag, téd-tɔ̄ mɛ, ńkag ne nsaŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Áyə̄le mǐd ḿmêm ńnyíné awôŋ mod a eʼsoósoŋ awe ébóŋsɛ́né wɛɛ́ moosyəə́l ányîn. ");
INSERT INTO bssNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ǎbɛ̄ eʼnyínɛn bé ekíde ábe bɛ́bɛ̌l bad ábe béesɛ̌ bad bé Israɛl âbíi wɛ, ǎpɛɛ́n-nɛ edúbé wɛ́ɛ ábôŋ bad bé Israɛl.” ");
INSERT INTO bssNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Josɛbɛ ne Maria bémbɛ̄ menyáké âwóg mam ḿme béhɔ́bé tə̂ŋgɛne awab mwǎn. ");
INSERT INTO bssNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Hɛ́ɛ Simionɛ ánámté bɔ́, boŋ álāŋgē Maria aá, “Nɔnéʼ, anɛ́n mwǎn awě nyényínɛɛ́ nɛ́n, Dyǒb dɔ́ɔ álómé mɔ́. Ǎbɛ̌l bad behɔ́g békud ebébtéd, ábíníí-ʼɛ békūd eʼsoósoŋ á aloŋ á Israɛl. Ǎbɛ̄ nɛ̂ŋgáne eʼchemléd éʼ Dyǒb, boŋ ekud é bad étīī mɔ́ ámīn, bétə̄ŋgān mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Á póndé eched mod tɛ́ɛ́ ḿme mbɛltéd měn mɛ́bīdēd ḿme mewêmtɛn áwed. Hɛ́ɛ ndutul ésoŋgé wɛ á nlém nɛ́ɛ nkwáté.” ");
INSERT INTO bssNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Nkal éʼdəə́dəŋ a mmwaád nhɔ́g abédé, dǐn démbɛ̄ mɔ́ bán Anaa, mwǎn awe Panuɛlɛ awě abíde á túmbé e Asɛɛ. Anaa anchǔn bwâmbwam. Bɔ́ nchóm bêndyɛɛ́ mwɛ̌ saámbé á eʼwóŋgé, boŋ ályə̄gē mɔ́ akúd kə́ə́ŋ ne á móom mé mwɛ́ waam ne mwɛ̌ ńniin. Eésyəŋgeʼaá á Ndáb-e-Dyǒb. Akánnéʼáá nkuu ne mǔte, ádidé-ʼɛ yə̌l nzaa á mekáne-tê. ");
INSERT INTO bssNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Áde Maria bɔ́ Josɛb bépɛ́ɛ́né Yesuɛ á Ndáb-e-Dyǒb pɛɛnɛ́n, Anaa ambɛ́ áhed. Hɛ́ɛ ábóótédé Dyǒb akɛn, ákanlé-ʼɛ bad nkalaŋ tə̂ŋgɛne ane mwǎn. Ábê bad bébédɛ́ɛ bad ábe bésínéʼáá póndé eche Dyǒb dɛ́wɔbɛ́ɛ́ dyad á Jerusalɛm. Anláá bɔ́ nyaa e mod echě ane mwǎn ábɛ̄ɛ̄. ");
INSERT INTO bssNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Áde Maria bɔ́ Josɛb bémádné mam mésyə̄ə̄l ngáne mbéndé e Sáŋgú éhɛ́déʼáá, bêntǐm áwāb dyad á Nazarɛt á aloŋ á Galilia. ");
INSERT INTO bssNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ene póndé mwǎn mɔ́-ʼɛ ákwogéʼ, áwūɛ̄ʼ áte, debyɛ́ɛ́ ákwogé mɔ́, nsimé ń Dyǒb mɔ́-ʼɛ ńhīdē mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bɔɔb-pɔɔ́, émbɛ̄ bán, mwɛ̌ tɛ́ɛ́ Yesuɛ sáá bɔ́ nyaŋ békágéʼáá á Jerusalɛm áyə̄le Ngande e Nnyíme-ámīn. ");
INSERT INTO bssNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Áde Yesuɛ ápédé dyôm á mwɛ́ ne ḿbɛ, bɔ́bɔ̄ɔ bênkɛ̌ á ngande ngáne êmmɛntɛ́nné abɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ngande emaá-ʼaá boŋ nyaá bɔ́ sáŋ bésūɛ̄ʼ á dyad. Yesuɛ anlyə̌g ámbīd á Jerusalɛm ésebán bébíí. ");
INSERT INTO bssNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mewêmtɛn mémbɛ̄ bɔ́ nɛ́n bán, adé á echoŋ éche ésúɛ́ʼáá. Boŋ áde békékɛɛ́ bootya mbwɛmbwɛ kə́ə́ŋ ne ngukɛ́l, dɔ́ɔ bébóótédé mɔ́ ahɛd, bésɛ̄dtē mɔ́ wɛ́ɛ bad bé túmbé ne bad ábe bɔ́bɔ̄ɔ bébyɛ́ɛ́né. ");
INSERT INTO bssNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Anyín áde béenyínɛɛ́ mɔ́, bêntǐm ámbīd á Jerusalɛm âhɛd mɔ́ áwed. ");
INSERT INTO bssNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Âlôntɛn eʼpun éʼláán dɔ́ɔ bétímé mɔ́ adibed á Ndáb-e-Dyǒb. Andyɛɛ́ átîntê e bemeléede, áwōglān bɔ́, ásɛdté-ʼɛ bɔ́ mam. ");
INSERT INTO bssNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mod tɛ́ɛ́ awě anwóg mam ḿme Yesuɛ áhɔ́béʼáá, ambɛ́ menyáké áyə̄le nsôŋtɛn ḿme ánwōŋgē ne nyaa echě ákwɛ́ntánnáá bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Áde nyaá bɔ́ sáŋ bényíné mɔ́, yə̌l enkɔ́m bɔ́ áte. Dɔ́ɔ nyaá ásɛdtɛɛ́ mɔ́ aá, “A-mwǎn, chán-nɔ̄ ébɛ́lé sé nɛ́n? Sé sóŋ sêkɔ́mé wɛ ahɛd, sétagé-ʼɛ áte.” ");
INSERT INTO bssNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Boŋ Yesuɛ ankwɛntɛ́n bɔ́ aá, “Cheé ékə́ə́ boŋ nyéhɛdé mɛ? Nyénkêmbííʼɛ́ bán, ntə́ŋgɛ́né abɛ́ á ndáb echě echem Sáŋ-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bénkênhɛnlé dyam áde áhɔ́bé asôŋtɛn. ");
INSERT INTO bssNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ámbīd e nɛ̂, dɔ́ɔ Yesuɛ áhídé nyaá bɔ́ sáŋ, boŋ bɔ́bɔ̄ɔ bésūɛ̄ʼ á Nazarɛt. Enkênwúɛ́nné bɔ́ nló áte. Nyaá-ʼɛ ankoó ḿmɛ́n mekan mésyə̄ə̄l á nlém-tê. ");
INSERT INTO bssNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ngáne Yesuɛ ákwógéʼáá, debyɛ́ɛ́ dɔ́mpē ákwógéʼáá mɔ́. Nsimé ń Dyǒb ne ḿ baányoŋ ńhīdē mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Á póndé echě nkamlɛnɛ Tibɛriosɛ, ákēbɛ̄ɛ̄ Kaisɛɛ a Roma áyə̄le dyôm á mwɛ̌ ne ńtáan, Dyǒb dénlōm Jɔnɛ mwǎn awe Sakaria ne nlébtéd á ehyáŋge wɛ́ɛ ábédé. Ene póndé-ʼɛ dɔ́ɔ Pontus Payledɛ mɔ́-ʼɛ ábédé Nkamlɛnɛ á Judeya, Hɛrɔdɛ ákamlán aloŋ á Galilia, mwǎnyaŋ Filibɛ-ʼɛ ákamlán aloŋ á Ituria ne aloŋ á Trakoniti. Boŋ Lisania mɔ́-ʼɛ akamlánnáá aloŋ á Abilɛnɛ. Ḿmê mesú měn-naá Anasɛ bɔ́ Kaifasɛ bébédé beprisɛ bémbáámbáa. ");
INSERT INTO bssNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jɔnɛ abwágéʼáá mebwɔ́g mésyə̄ə̄l ḿme mélə́ŋnédé edíb é Jodan. Ákag ákalé eyale é Dyǒb nɛ́n aá, “Nyétɛde abɛl dé mbéb, nyékud edusɛn âbɛl boŋ Dyǒb álagsɛn nyé mbéb.” ");
INSERT INTO bssNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nɛ́n dénlōnēd chǒm-ɛ́ɛ éténlédé á kálag echě nkal éʼdəə́dəŋ Yesayaa bán, “Ehə́ŋgé ébídé á ehyáŋge bán, nyéboŋsɛn epɛ éche Sáŋgwɛ́ɛ́. Nyétíi echě nzii. ");
INSERT INTO bssNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nyélóned nhog tɛ́. Nyésuded mbɔɔd ne ekone tɛ́. Nyétíi mebwɔ́g ḿme méhyɔ́mé. Nyétaled mebwɔ́g ḿme médé pwɔgléd pwɔgled. ");
INSERT INTO bssNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Âbɛl boŋ moonyoŋ asyəə́l ányîn ngáne Dyǒb ásooʼɛ́ aloŋgé á bad.” ");
INSERT INTO bssNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ndun e mod empɛ̌ wɛ́ɛ Jɔnɛ béhɛdé bán, ádusɛn bɔ́. Mɔ́-ʼɛ ásɛ́dté bɔ́ aáken, “Píí é nyə̌ chɛ́n! Nzɛ́ɛ́ múmɔ́ aláŋgé nyé aá nkáásé ń Dyǒb ńhúɛʼ boŋ aléb-pɛ nyé aá nyékúme abáŋgé? ");
INSERT INTO bssNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nyéchyáa eʼpum ábe éʼlûmte bán nyêtɛdté abɛl dé mbéb, tómaa âhɔ́b áwɛn nlém-tê bán, ‘nyêdé bǎn ábe Abrahamɛ, nyéekudté nkɔ́gsɛn ń Dyǒb.’ Boŋ ńláa nyé nɛ́n mɛɛ́, Dyǒb áhɛle ábɛnléd ḿmɛ́n meláá átīmēd mɔ́ bǎn ábe Abrahamɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Bɔɔb-pɔɔ́, ehón émáá anaa á nkaŋ ḿ mɛl. Né-ɔɔ́, bwɛl ké éʼhéé ábe béēchyāāʼ eʼpum éʼ bwâm, békwɛl bɔ́, bébwém-mɛ bɔ́ á muú-te.” ");
INSERT INTO bssNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Hɛ̂ dɔ́ɔ, bad bésɛdtɛɛ́ mɔ́ bánken, “Chán-nɔ̄ sɛ́bɛnlé bɔɔb?” ");
INSERT INTO bssNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jɔnɛ antimtɛ́n bɔ́ aá, “Mod awě awóó mbɔ́té ébɛ, ábɛ pɔ́g wɛ́ɛ ane awě eewóo chǒmchǒm. Ane awě mɔ́-ʼɛ awóó ndyééd, ákabe bad ábe béewóo.” ");
INSERT INTO bssNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Belad bé táásɛ ábe bɔ́mpē bênhyɛ̌ edusɛn akud bênsɛdéd mɔ́ bán, “A-meléed, cheé sɛ́bɛnlé?” ");
INSERT INTO bssNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Antimtɛ́n bɔ́ aá, “Nyéēsaŋté táásɛ tómaa ngáne bétíídé.” ");
INSERT INTO bssNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nguse é sə́nze chɔ́-ʼɛ ênsɛdéd mɔ́ bánken, “Chán-náa sé, sébɛl chán?” Jɔnɛ ankwɛntɛ́n aá, “Nyéēkobné bad mɔné. Nyéebáné-ʼɛ bad mekan áyə̄l ngɛ̂n, boŋ nyébɛ̂ menyiŋge ne chǒm-ɛ́ɛ nyékudɛɛ́ nɛ́ɛ nsábe.” ");
INSERT INTO bssNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Bɔɔb-pɔɔ́, bad ábe bébédé áhed, ḿmab mewêmtɛn mêmbootéd achə́ge ne eʼlyə́g bé nlém, békɔglád á nlém-tê nzé édé bán Jɔnɛ mɔ́ adé Ane-awě-Béwɔ́gté. ");
INSERT INTO bssNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Hɛ́ɛ Jɔnɛ átimtanné bɔ́ moosyəə́l aá, “Ndusan nyé bɔɔb ne mendíb, boŋ mod ahúɛʼ awě atómé mɛ. Meékwognedɛɛ́ âhune ké ḿmē nkɔɔd mé metámbé. Ǎdusɛ́n nyé ne Edəə́dəŋ éche Ésáá, ádusɛ́n-nɛ nyé ne muú. ");
INSERT INTO bssNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Awánlé échē epebɛn á ekáá, âbɛl nɛ́n, ápeb ḿme menyán ámīn. Nzé amadé, ǎlǎd mbum é bwâm áte, ákōō chɔ́. Boŋ ǎlǎd eʼpəə́, ahyáád bɔ́ á ebonde é muú éche éēdīmēʼ.” ");
INSERT INTO bssNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Né-ɔɔ́ Jɔnɛ alébéʼáá bad ne ekud é pɔ́le émpēe, ákanlé-ʼɛ bɔ́ nkalaŋ ḿ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jɔnɛ anhɔ́b kə́ə́ŋne wɛ́ɛ nkamlɛnɛ Hɛrɔdɛ aá, abɛlé mbéb ngáne áwóó Hɛrodyasɛ, mwaád awě mwǎnyaŋ, nchoo ne eʼbébtéd bé mekan bémpēe ábe âmbɛnlé. ");
INSERT INTO bssNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Âbád-tɛ áyə̄le ḿmê mbéb ńsyə̄ə̄l Hɛrɔdɛ anhɛ́ Jɔnɛ á mbwɔg. ");
INSERT INTO bssNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bɔɔb-pɔɔ́, áde Jɔnɛ ámáá ekud é bad adusɛn, Yesuɛ mɔ́ ámpē ampɛ̌ aá ádusɛn mɔ́. Áde ámáá mɔ́ adusɛn, ábwɔ̄g-ábwɔ̄g ankáné. Áde ákânnɛɛ́ nɛ̂ dɔ́ɔ ngob e dyǒb énédnédé. ");
INSERT INTO bssNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Hɛ́-ʼaá Edəə́dəŋ éche Ésáá ébídé ngáne élə̄ə̄, boŋ ésudé mɔ́ á nló mîn. Ehɔ́b chɔ́mpē émbīd ádyōb nɛ́n, “Edíi awem mwǎn a nlém awě ńdə́ə́ bwâmbwam. Ndé menyiŋge ne wɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesuɛ ambɛ́ dyam móom mé mwɛ̌ méláán boŋ ábootád ḿme nsɔ́n. Bad bényínéʼáá mɔ́ nɛ́ɛ mwǎn awě Josɛbɛ. Josɛbɛ ambɛ́ mwǎn awe Eliɛ. Eliɛ ambɛ́ ");
INSERT INTO bssNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","mwǎn awe Matatɛ. Matatɛ ambɛ́ mwǎn awe Leviɛ. Leviɛ abédé mwǎn awe Melekyɛ. Melekyɛ ambɛ́ mwǎn awe Jannɛ. Jannɛ ambɛ́ mwǎn awe Josɛbɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josɛbɛ abédé mwǎn awe Matatya. Matatya ambɛ́ mwǎn awe Amɔsɛ. Amɔsɛ abédé mwǎn awe Nahumɛ. Nahumɛ ambɛ́ mwǎn awe Esilyɛ. Esilyɛ ambɛ́ mwǎn awe Nagaya. ");
INSERT INTO bssNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaya abédé mwǎn awe Maatɛ. Maatɛ ambɛ́ mwǎn awe Matatya. Matatya ambɛ́ mwǎn awe Simɛnɛ. Simɛnɛ ambɛ́ mwǎn awe Josɛkɛ. Josɛkɛ ambɛ́ mwǎn awe Jodaa. ");
INSERT INTO bssNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jodaa abédé mwǎn awe Joananɛ. Joananɛ ambɛ́ mwǎn awe Resa. Resa ambɛ́ mwǎn awe Serubabɛlɛ. Serubabɛlɛ ambɛ́ mwǎn awe Salatyɛ. Salatyɛ ambɛ́ mwǎn awe Neriɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neriɛ ambɛ́ mwǎn awe Mɛlki. Mɛlki ambɛ́ mwǎn awe Adiɛ. Adiɛ ambɛ́ mwǎn awe Kosamɛ. Kosamɛ ambɛ́ mwǎn awe Elamadamɛ. Elamadamɛ ambɛ́ mwǎn awe Erɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erɛ ambɛ́ mwǎn awe Josua. Josua ambɛ́ mwǎn awe Elesaa. Elesaa ambɛ́ mwǎn awe Jorimɛ. Jorimɛ ambɛ́ mwǎn awe Matatɛ. Matatɛ ambɛ́ mwǎn awe Leviɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leviɛ ambɛ́ mwǎn awe Simionɛ. Simionɛ ambɛ́ mwǎn awe Judaa. Judaa ambɛ́ mwǎn awe Josɛbɛ. Josɛbɛ ambɛ́ mwǎn awe Jonamɛ. Jonamɛ ambɛ́ mwǎn awe Elyakimɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakimɛ ambɛ́ mwǎn awe Meleya. Meleya ambɛ́ mwǎn awe Mena. Mena ambɛ́ mwǎn awe Matatɛ. Matatɛ ambɛ́ mwǎn awe Natanɛ. Natanɛ ambɛ́ mwǎn awe Dabidɛ. Dabidɛ ");
INSERT INTO bssNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","mwǎn awe Jesɛ. Jesɛ mwǎn awe Obɛdɛ. Obɛdɛ ambɛ́ mwǎn awe Boasɛ. Boasɛ ambɛ́ mwǎn awe Salmonɛ. Salmɔnɛ ambɛ́ mwǎn awe Nasonɛ. Nasonɛ ");
INSERT INTO bssNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ambɛ́ mwǎn awe Aminadabɛ. Aminadabɛ ambɛ́ mwǎn awe Ademinɛ. Ademinɛ ambɛ́ mwǎn awe Areniɛ. Areniɛ ambɛ́ mwǎn awe Hesɛrɔnɛ. Hesɛrɔnɛ ambɛ́ mwǎn awe Pɛresɛ. Pɛresɛ ambɛ́ mwǎn awe Judaa. ");
INSERT INTO bssNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judaa ambɛ́ mwǎn awe Jakɔbɛ. Jakɔbɛ ambɛ́ mwǎn awe Aisigɛ. Aisigɛ ambɛ́ mwǎn awe Abrahamɛ. Abrahamɛ ambɛ́ mwǎn awe Tɛra. Tɛra ambɛ́ mwǎn awe Nahɔ. Nahɔ ");
INSERT INTO bssNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ambɛ́ mwǎn awe Sɛrugɛ. Sɛrugɛ ambɛ́ mwǎn awe Rewɛɛ. Rewɛɛ ambɛ́ mwǎn awe Pelɛgɛ. Pelɛgɛ ambɛ́ mwǎn awe Ebɛɛ. Ebɛɛ ambɛ́ mwǎn awe Sela. Sela ");
INSERT INTO bssNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ambɛ́ mwǎn awe Kananɛ. Kananɛ ambɛ́ mwǎn awe Apasadɛ. Apasadɛ ambɛ́ mwǎn awe Semɛ. Semɛ ambɛ́ mwǎn awe Noa. Noa ambɛ́ mwǎn awe Lamekɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamekɛ ambɛ́ mwǎn awe Metusɛla. Metusɛla ambɛ́ mwǎn awe Hɛnɔkɛ. Hɛnɔkɛ ambɛ́ mwǎn awe Jarɛdɛ. Jarɛdɛ ambɛ́ mwǎn awe Mehalɛlɛ. Mehalɛlɛ ambɛ́ mwǎn awe Kenanɛ. Kenanɛ ");
INSERT INTO bssNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ambɛ́ mwǎn awe Enosɛ. Enosɛ ambɛ́ mwǎn awe Sɛta. Sɛta abédé mwǎn awe Adamɛ. Adamɛ-ʼɛ abédé mwǎn a Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Bɔɔb-pɔɔ́, áde Yesuɛ abídé á edíb é Jodan, anlón ne Edəə́dəŋ éche Ésáá. Êntimɛ́n mɔ́ á ehyáŋge. ");
INSERT INTO bssNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Andyɛɛ́ áwed móom mé eʼpun méniin, Devəlɛ ákəgé mɔ́. Ḿmé mesú mésyə̄ə̄l enkêndyáá chǒmchǒm. Ámbīd e né-ɔɔ́ nzaa ewagáá mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Dɔ́ɔ Devəlɛ álâŋgɛɛ́ mɔ́ aá, “Nzé wɛ-ɛɛ́ edé Mwǎn a Dyǒb, kamlɛ́n ádɛ́n aláá wɛɛ́, átim ewɛle.” ");
INSERT INTO bssNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesuɛ antimtɛ́n mɔ́ aá, “Éténlédé á kálag e Dyǒb nɛ́n bán, ‘Saké ndyééd chěmpɛn edide moonyoŋ á aloŋgé.’ ” ");
INSERT INTO bssNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Hɛ́ɛ Devəlɛ ákɛ́ɛ́né mɔ́ á ekone mîn, álūmtē mɔ́ meloŋ mé nkǒŋsé mésyə̄ə̄l áyə̄le mwǎ esóŋ é póndé. ");
INSERT INTO bssNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Dɔ́ɔ álâŋgɛɛ́ mɔ́ aá, “Nɔnéʼ, bébágé mɛ nkamlɛn ámīn e ábɛ́n bwěm éʼsyə̄ə̄l. Nwóó-ʼɛ kunze âbɛ mod ké ahéé awe ńdə́ə́ abɛ. Mɛ̌bɛ̌ wɛ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Né-ɔɔ́ nzé ebagé mɛ edúbé, né wɛ́ɛ ewóó ábén bwěm éʼsyə̄ə̄l.” ");
INSERT INTO bssNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesuɛ antimtɛ́n mɔ́ aá “Éténlédé nɛ́n bán, ‘Ébwógkeʼ Sáŋgwɛ́ɛ́ ádoŋ Dyǒb mebóbóŋ, ébage-ʼɛ mɔ́ edúbé. Mwěnpɛn-naá étə́ŋgɛ́né abɛle.’ ” ");
INSERT INTO bssNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Hɛ́ɛ Satanɛ ákɛ́ɛ́né Yesuɛ á Jerusalɛm. Átyēēmān mɔ́ á nzoŋgɛ e Ndáb-e-Dyǒb mîn, boŋ álāŋgē mɔ́ aá, “Nzé wɛ-ɛɛ́ edé mwǎn a Dyǒb, éheb á bwɛle-mîn hɛ́n, éhûn á ndɔɔb. ");
INSERT INTO bssNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Éténlédé á kálag e Dyǒb nɛ́n bán, ‘Dyǒb dɛ́kamlɛ́n éche ángɛl âsáb wɛ,’ ");
INSERT INTO bssNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","‘épēm-mɛ wɛ ámīn, âbɛl nɛ́n weébɔ̄mē ekuu á aláá.’ ” ");
INSERT INTO bssNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesuɛ-ʼɛ antimtɛ́n mɔ́ aá, “Kálag e Dyǒb ehɔ́be nɛ́n aá, ‘Weékə̄gē Sáŋgwɛ́ɛ́, ádoŋ Dyǒb áte.’ ” ");
INSERT INTO bssNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Devəlɛ amaá-ʼaá mɔ́ akəg áte menzii mésyə̄ə̄l, boŋ áhidteʼ, áhāg mɔ́ mwǎ etə́l. ");
INSERT INTO bssNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesuɛ antǐm ámbīd á Galilia. Edəə́dəŋ éche Ésáá émbɛ̄ ne mɔ́, dǐn dɔ́-ʼɛ ákanlád mɔ́ mbwɔ́g áte ésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ayə́gtéʼáá bad áwab ndáb é mekáne, moosyəə́l ákēmtē mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Áde ápédé á Nazarɛt wɛ́ɛ ákwógé, ansɔ́l á ndáb e mekáne á Mbwɛ-mé-nkɔ́me-áte, ngáne âmmɛntɛ́nné abɛl. Dɔ́ɔ átyéémé ámīn, âláŋ epɛd. ");
INSERT INTO bssNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bémbɛ̌ mɔ́ nhíbe ń kálag é metelag ḿme nkal éʼdəə́dəŋ Yesayaa. Anhuné chɔ́ áte, ákūnē epɛd éche éhɔ́be nɛ́n bán, ");
INSERT INTO bssNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Edəə́dəŋ éche Sáŋgwɛ́ɛ́ édé ne mɛ, áyə̄le Dyǒb ápwɛ́dé mɛ aá, ḿbɛl ehə́ŋgé é nkalaŋ ḿ bwâm wɛ́ɛ betóótōkɛ̄ bé bad. Alómné mɛ ehə́ŋgé aá, bad ábe bédé á mehaŋgé, béhide á mehaŋgé, aá, bad ábe békwédé ndím, bɛ́nyīnɛ̄n aá, bad ábē békude metuné á mekáá mé baáb, nhúd bɔ́ á metuné-te ");
INSERT INTO bssNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","aá ḿbɛl-lɛ ehə́ŋgé nɛ́n mɛɛ́ póndé epedé echě Dyǒb álûmtɛɛ́ bad ngɔl.” ");
INSERT INTO bssNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Amaá-aá aláŋ, ádib kálag áte, ábag chɔ́ ámbīd wɛ́ɛ mod awě anɔne ndáb e mekáne. Ankɛ̌ ádyɛ̄ɛ̄ ásē, mǐd mésyə̄ə̄l ménɔné mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Dɔ́ɔ álâŋgɛɛ́ bɔ́ aá, “Échɛ́n epɛd éche nyéwógé, élóné epun éʼchii.” ");
INSERT INTO bssNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Moosyəə́l ankéméd mɔ́, menyáké mékób bɔ́ áyə̄le kəse e pɔ́le echě ebídáá mɔ́ á nsəl, bésɛdtéʼ bánken, “Kíné saá mwǎn awě Josɛbɛ mɔ́ nɛ́n-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesuɛ ambád bɔ́ aláa aá, “Mbíí mɛɛ́, nyɛ́ɛ̄kalé mɛ ngan bán, ‘Á mod a bwɛl, choód yə̌l.’ Nyɛ́ɛ̄lāā-ʼɛ mɛ bán, mekan ḿme nyéwógé bán mbɛlé á dyad á Kapenahum bán, ḿbɛl-láa mɔ́ áwêm dyad-tê hɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Ńláa nyé nɛ́n mɛɛ́, nkal éʼdəə́dəŋ eewóoʼɛ́ edúbé áwē dyad. ");
INSERT INTO bssNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nyébíi-ɔɔ́ nɛ́n bán, á póndé eche Elaijaa, mbúú eechódɛɛ́ áyə̄le mwɛ̌ ńláán ne epɛd. Nɛ̂ dêmbɛ̌l sáŋkalaa a nzaa ambɛ́ aloŋ áte ásyə̄ə̄l. Bekúd híin bémbɛ̄ á mbwɔ́g e Israɛl hɛ́n ene póndé. ");
INSERT INTO bssNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Boŋ Dyǒb dénkênlómmé Elaijaa áwāb. Anlóm mɔ́ dásɔ̄ á aloŋ á Sidɔn á dyad á Sarefa wɛ́ɛ nkúd a mmwaád ampée. ");
INSERT INTO bssNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Á póndé echě nkal éʼdəə́dəŋ Elisha ámpē ndun e mod e meləŋ embɛ́ á Israɛl. Boŋ Elisha enkênsáádté mod a meləŋ ké nhɔ́g awě ambíd á aloŋ á Israɛl. Namanɛ, mod awě ambíd á aloŋ á Siria mɔ́ɔ ánsāādtē.” ");
INSERT INTO bssNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Áde bad ábe bémbɛ̄ á ndáb e mekáne béwógé-ʼɛ nɛ̂, ekaŋ énkōb bɔ́ áte. ");
INSERT INTO bssNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Hɛ́ɛ bépádté ásē, béhɛ́ mɔ́ abum ámīn, békɛ̄ɛ̄n mɔ́ á asóg á dyad. Ngáne bénlōŋgē á ekone mîn, bêntimɛ́n mɔ́ á mbám mé ekone âbɛl bétíned mɔ́ á ekone sé. ");
INSERT INTO bssNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Boŋ ansam bɔ́ átîntê, ákɛ̄-ʼɛ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesuɛ ansyɔgé á dyad á Kapenahum á mbwɔ́g e Galilia, ábootéd ayə́ged á mbwɛ-mé-nkɔ́me-áte. ");
INSERT INTO bssNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nyaa eche áyə́gtéʼáá enkɔ́méd bad yə̌l áte bwâmbwam áyə̄le ábē eʼyale bémbɛ̄ ngíne. ");
INSERT INTO bssNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Á ndáb e mekáne wɛ́ɛ áyə́gtéʼáá, mod ambɛ́ awě edəə́dəŋ é mbéb ékámlánnáá. Hɛ́ɛ ábóótédé abón aá, ");
INSERT INTO bssNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Bɔ́b! A-Yesu, mod a Nazarɛt, cheé syánē déwóŋné? Ehyedé sé awúu-yɛ? Mbíí wɛ bwâm. Edíī mod awě Dyǒb álómé, awě asáá.” ");
INSERT INTO bssNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Dɔ́ɔ Yesuɛ ákánné échê edəə́dəŋ é mbéb áte aá, “Lám, bíd ane mod áte!” Hɛ́ɛ ébɔ́mé ane mod ásē átîntê bad, boŋ ébīdē mɔ́ á yə̌l, ésebán élɔ́gné mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Menyáké ménkōb moosyəə́l, bésɛ̄dtē nhɔ́g ne aníníí bánken, “Nyaa e nhɔ́btéd ehéé nɛ́n-ē? Chán mod ákamlánné eʼdəə́dəŋ bé mbéb ne kúmbe esyəə́l, éʼwōgnē-ʼɛ mɔ́?” ");
INSERT INTO bssNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Dǐn dênkɛ̌ mɔ́ mbwɔ́g áte esyəə́l áyə̄le mekan ḿme ábɛ́léʼáá. ");
INSERT INTO bssNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Áde Yesuɛ áhídté á ndáb e mekáne, ankɛ̌ á ndáb wɛ́ɛ Simɔnɛ. Antán nɛ́ɛ Simɔnɛ mwaád nyaá ákonlɛɛ́, ahéb ámbáá dênsog mɔ́. Bénchāŋ Yesuɛ bán, ádid mɔ́ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Dɔ́ɔ Yesuɛ ásídté mɔ́ á nkəg, awúlɛ́n ásē, aláá ahéb áded aá, átɛde mɔ́. Ábwɔ̄g-ábwɔ̄g ahéb dêmmaá mɔ́ á yə̌l, ásyə̄ə̄ ásē, ákōb-pɛ bɔ́ nken. ");
INSERT INTO bssNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Bɔɔb-pɔɔ́, áde enyɛn ébóótédé asud, bad bésyə̄ə̄l ábe bénwōŋ bad bé nkole ábe békónléʼáá nkole nyaa ne nyaa bêmpɛɛ́n bɔ́ áwē. Ambán nhɔ́g tɛ́ɛ́ ekáá ámīn, ádidé bɔ́ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Eʼdəə́dəŋ bé mbéb bɔ́mpē éʼbīdē ekud é bad á yə̌l, éʼbōnēʼ bán, “Edíi mwǎn a Dyǒb!” Ankáné bɔ́ áte, eémwageʼaá-ʼɛ aá béhɔ̂b akan, áyə̄le bémbíi bán, adíi Ane awě Dyǒb Áwɔ́gté. ");
INSERT INTO bssNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mbwɛmbwɛ píríb, Yesuɛ ansyəə́ á dyad-tê, ákɛ̄ á ahə́ŋgé á hǒm. Bad bêmbootéd mɔ́ ahɛd. Áde bédíbté mɔ́, bénkênháá mɔ́ etə́l âkɛ hǒm. ");
INSERT INTO bssNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Dɔ́ɔ álâŋgɛɛ́ bɔ́ aá, “Ntə́ŋgɛ́né akɛ á myad mémpēe, âbɛl nɛ́n ńláa bɔ́mpē nkalaŋ ḿ bwâm tə̂ŋgɛne nkamlɛn ń Dyǒb. Ḿmɛ́n nkalaŋ mɔ́ɔ̄ ńkə́ə́ boŋ Dyǒb álōmē mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Né-ɔɔ́ akaléʼáá nkalaŋ ḿ bwâm á ndáb é mekáne é mbwɔ́g é Judeya. ");
INSERT INTO bssNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Mbwɛ nhɔ́g Yesuɛ antyéém á nkin mé edib é Gɛnesarɛt. Bad bênləŋnéd mɔ́ âwóg eyale é Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Hɛ́ɛ ányíné bétə́ŋgé myɔ̌lɛ mébɛ á nkin. Bekób-bé-súu bénkêmbáá áwēd-te. Béwópéʼáá échab mbínzé. ");
INSERT INTO bssNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Dɔ́ɔ ásɔ́lé á bɔ̌lɛ ábe Simɔnɛ, aláá mɔ́ aá, ásyəŋned mɔ́ á nkin. Adyɛɛ́-ʼaá á bɔ̌lɛ-tê, boŋ ábootéd bad ayə́ged. ");
INSERT INTO bssNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Áde ámádé nɛ̂, anláá Simɔnɛ aá, “Kɛɛ́n bɔ̌lɛ wɛ́ɛ ndib édíí, boŋ nyébwêm mbínzé.” ");
INSERT INTO bssNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simɔnɛ antimtɛ́n mɔ́ aá, “A-Sáŋ, sêkébwēm mbínzé nkuu ńsyə̄ə̄l, séēkōbɛ̄ɛ̄ chǒmchǒm! Boŋ mɛ̌bɛ̌l ngáne éhɔ́bé.” ");
INSERT INTO bssNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Dɔ́ɔ bébwémé mbínzé. Bénkōb ndun e súu kə́ə́ŋ mbínzé éhapeʼ. ");
INSERT INTO bssNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bénlēbē baáb ábe bébédé á bɔ̌lɛ ábíníí bán béhyɛ béwôŋgɛn bɔ́. Áde baáb bépédé, myɔ̌lɛ mésyə̄ə̄l mébɛ ménlōn ne súu kə́ə́ŋ mébootéd asú ásē. ");
INSERT INTO bssNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Áde Simɔnɛ Petro ányíné nɛ̂, ankwɛ Yesuɛ á mekuu, áhɔ̄bē aá, “A Sáŋgú, sôn! Syəə́ wɛ́ɛ ńdíí áyə̄le ndíi mbɛlé-mbéb.” ");
INSERT INTO bssNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simɔnɛ anhɔ́b nɛ̂ áyə̄le émbɛ̄ bɔ́ɔbɛ baáb menyáké bwâmbwam ânyín ndun e súu eche békóbé. ");
INSERT INTO bssNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Menyáké ménkōb kə́ə́ŋne Jemsɛ bɔ́ Jɔn, bǎn ábe Zɛbɛdiɛ, ábe bémbɛ̄ á echoŋ é akób á súu. Hɛ́ɛ Yesuɛ álâŋgɛɛ́ Simɔnɛ aá, “Weebááʼ. Bootya chii nyɛ́ɛ̄tēdē bad nlém á abum âhíd mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Áde bépɛ́ɛ́né ḿmab myɔ̌lɛ á nkin, bêntɛdé chǒm ésyə̄ə̄l áhed, bébootéd-tɛ Yesuɛ ahíd. ");
INSERT INTO bssNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Mbwɛ nhɔ́g Yesuɛ abédé dyad ahɔ́g. Mod awě meləŋ mékóbé yə̌l esyəə́l ampɛ̌ áwē. Anyín áde ányíné Yesuɛ, ankwɛ mɔ́ á mekuu, áchāā mɔ́ aá, “A-Sáŋ, nzé edəə́ ehɛle ébɛ̄l mɛ nsáŋ.” ");
INSERT INTO bssNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Dɔ́ɔ Yesuɛ ábídté ekáá, ábānē mɔ́ á yə̌l boŋ álāŋgē mɔ́ aá, “Ndəə́, sáŋ!” Ábwɔ̄g-ábwɔ̄g ḿmê meləŋ mêmmaá ane mod á yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesuɛ anláá mɔ́ aá, eeláŋgé modmod, aláá-ʼɛ mɔ́ aá, “Kǎg élúmed yə̌l wɛ́ɛ prisɛ, ásimɛn wɛ. Ébag-kɛ mendɛ ngáne mbéndé e Mosɛɛ éhɛdɛɛ́ âlúmed bad wɛɛ́ mɔ́sāā.” ");
INSERT INTO bssNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ké nɛ̂ŋgáne Yesuɛ ánkə̄ŋgē mɔ́ aá eeláŋgé mod, dǐn démbɛ̄ ákag mɔ́ mbwɔ́g áte esyəə́l áyə̄le ḿmē mbɛltéd. Nɛ̂ dêmbɛ̌l ndun e mod éladné mɔ́ á nkəg, âwóg chǒm éche áhɔ́bɛɛ́, ne âbɛl ádid bɔ́ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Boŋ nzé póndé empɛ̌ mɔ́, ayɔ̌gkéʼáá atim á ahə́ŋgé, âkáne. ");
INSERT INTO bssNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mbwɛ nhɔ́g ámpē Yesuɛ ayə́gtéʼáá bad. Befarisia ne bemeléede bé mbéndé bémbɛ̄ áhed. Bémbīd dyad ne dyad tɛ́ɛ́ á mbwɔ́g é Galilia ne Judeya, kə́ə́ŋne á Jerusalɛm. Ngum e Dyǒb empií mɔ́, âdid bad bé nkole bwâm. ");
INSERT INTO bssNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Dɔ́-ʼaá bad behɔ́g bépɛɛnɛɛ́ mod á mekále mîn awě awédé epɛd. Béhɛ́déʼáá nzii echě bésɔ̂nlɛɛ́ mɔ́ á ndáb-te, ânaad mɔ́ áʼsō-te wɛ́ɛ Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bénkênkudté etə́l áyə̄le ndun e mod enlón áhed. Dɔ́ɔ béchə́gké á ndáb mîn. Dɔ́ɔ bénédté nnɔŋ, bésudéd ane mod bɔ́ɔbɛ mekále á etə́le-tê áʼsō-te wɛ́ɛ Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Áde Yesuɛ ányíné adúbe ádě ábe bad béwóó áte anláá ane mod awě awédé epɛd aá, “Amúɛ̄, nlagsɛ́né wɛ mbéb.” ");
INSERT INTO bssNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Dɔ́ɔ bemeléede bé mbéndé ne Befarisia bébóótédé anyoo áte bánken, “Ebə́l é mod éhéé ésyə́ə Dyǒb nɛ́n? Nzɛ́ɛ́ ahɛle se álagsɛ́n mbéb ésebán Dyǒb děmpɛn?” ");
INSERT INTO bssNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesuɛ anchem bɔ́ mewêmtɛn áte. Hɛ́ɛ ásɛdtɛɛ́ bɔ́ aáken, “Cheé ékə́ə́ boŋ nyéwōōʼ enɛ́n ndín e mewêmtɛn? ");
INSERT INTO bssNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ahéé adé dyam ásad, âhɔ́b wɛɛ́, ‘Nlagsɛ́né wɛ mbéb,’ káa âhɔ́b wɛɛ́, ‘Syəə́ ásē, ébooted akɛ?’ ");
INSERT INTO bssNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Boŋ mɛ̌lūmēd nyé mɛɛ́, Mwǎn-a-Moonyoŋ awóó kunze âlagsɛn mbéb á nkǒŋsé.” Hɛ́ɛ álâŋgɛɛ́ ane mod awě awédé epɛd aá, “Nlâŋge wɛ nɛ́n mɛɛ́, syəə́ ásē, étêd ḿmôŋ mekále, ésúɛʼ á ndáb.” ");
INSERT INTO bssNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ábwɔ̄g-ábwɔ̄g ane mod anhidé ásē átîntê e bad, atéd ḿmē mekále, ásūɛ̄-ʼɛ mɔ́ á ndáb, ákag ákēmtē Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Menyáké ménkōb moosyəə́l awě ambɛ́ áhed. Hɛ́ɛ bébóótédé Dyǒb akɛn ne mbwɔ́g áte bán, “Sênyíné akan dé menyáké chii nɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ámbīd e nɛ̂ Yesuɛ ansyəə́ áhed. Áde ákagké nɛ̂, annyín nsaad-a-táásɛ nhɔ́g bán Leviɛ. Leviɛ andyɛɛ́ ásē á ndáb echě ákóbáá táásɛ áte. Hɛ́ɛ Yesuɛ álâŋgɛɛ́ mɔ́ nɛ́n aá, “Hídé mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Dɔ́ɔ Leviɛ átyéémé ámīn, áchēnē chǒm ésyə̄ə̄l áhīdē-ʼɛ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Bɔɔb-pɔɔ́, Leviɛ anchǎg sáŋkalaa a ngande áwe ndáb á dǐn áde Yesuɛ. Besaad bé táásɛ híin ne bad bémpēe bémbɛ̄ áhed. ");
INSERT INTO bssNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Hɛ́ɛ Befarisia ne ábāb bemeléede bé mbéndé bényoŋgɛɛ́ áte wɛ́ɛ Yesuɛ ábē bembapɛɛ, bésɛ̄dtē bɔ́ bánken, “Cheé ékə́ə́ boŋ nyáābe besaad bé táásɛ ne bebɛl bé mbéb bémpēe nyédyāg ndyééd, nyé mwāg-kɛ mǐm hǒm ahɔ́g?” ");
INSERT INTO bssNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesuɛ antimtɛ́n bɔ́ ne ngan aá, “Bad ábe bédyɛ́ɛ́ bwâm béetógnɛnɛɛ́ mod-a-bwɛl. Bad ábe békonleʼ bɔ́ɔ bétógnɛ́né mod a bwɛl. ");
INSERT INTO bssNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nyébíi nɛ́n bán, meépedɛɛ́ âchɛ́le bad ábe békóbnédé áʼsō éʼ Dyǒb, boŋ mpedé âchɛ́le bebɛl bé mbéb mɛɛ́ bésôg mbéb abɛl.” ");
INSERT INTO bssNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Befarisia bémbād ahɔ́b bán, “Bembapɛɛ ábe Jɔnɛ bémɛ́ntɛ́né yə̌l nzaa adid á mekáne-tê. Melemlem né-ʼaá Befarisia ábāb bembapɛɛ bɔ́mpē bébɛlɛɛ́. Cheé ékə́ə́ boŋ ábōŋ bédyâg ndyééd, bémwâg-kɛ mǐm?” ");
INSERT INTO bssNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesuɛ ankwɛntɛ́n bɔ́ ne ngan aá, “Chán bad ábe bélébpé á ngande e eʼwóŋgé béhɛle bédidé yə̌l nzaa á mekáne-tê áde mod awě akude sɔ́mbé ádíi adé ne bɔ́? ");
INSERT INTO bssNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Boŋ epun épɛ̌ éche bɛ́kobɛ́nné bɔ́ mod awě akude sɔ́mbé. Échê epun dɔ́ɔ bédidté yə̌l nzaa á mekáne-tê.” ");
INSERT INTO bssNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesuɛ anláá bɔ́ ngan aá, nzé mod ahɔ́be aá, mɔ́nabpeʼ mbɔ́té, eesɛ́lɛ́ɛ́ epɛd é abad áyə̄le mbɔ́té ekɔ́ɔ́lé boŋ ánabnáád mbɔ́té e nchun. Nzé abɛlé nɛ̂, né asalé mbɔ́té ekɔ́ɔ́lé. Ké epɛd ékɔ̄ɔ̄lē-ʼɛ éetə́ŋgánné ne mbɔ́té e nchun. ");
INSERT INTO bssNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Melemlem nɛ̂ŋgáne mod éētēdɛ̄ɛ̄ mǐm mékɔ̄ɔ̄lē se ahɛ́ mɔ́ á nchun mé ntyə́g, se ápen. Áyə̄le nzé abɛlé nɛ̂, né mǐm mɛ́hǒd kə́ə́ŋ ntyə́g ńyɛ́d, mǐm mémǎd asyɔge, ntyə́g-kɛ ámpē ḿbéb. ");
INSERT INTO bssNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Bétə́ŋgɛ́né béhɛ́ mǐm mékɔ̄ɔ̄lē á apom dékɔ̄ɔ̄lē. ");
INSERT INTO bssNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Bad ábe bɔ́-ʼɛ bémwâg mǐm, béemaáʼɛ́ mǐm mé nchun amwɛ́ se béhɛdé mékɔ̄ɔ̄lē. Bébɛle béhɔ́b bán, “Saá mé nchun mɔ́ɔ mébóó-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mbwɛ nhɔ́g Yesuɛ ne ábē bembapɛɛ bétóméʼáá á nzag e ngun-tê. Nɛ́n démbɛ̄ á mbwɛ-mé-nkɔ́me-áte. Ábē bembapɛɛ bêmbootéd eʼsɔ́g éʼ ngun apád, bépə̄gkeʼ, bédyâg. ");
INSERT INTO bssNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nguse é Befarisia bényíné-ʼaá nɛ̂, boŋ bésɛdté bɔ́ bánken, “Cheé ékə́ə́ boŋ nyébɛlé akan áde mbéndé éebagɛɛ́ kunze âbɛl á mbwɛ-mé-nkɔ́me-áte?” ");
INSERT INTO bssNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Hɛ́ɛ Yesuɛ mɔ́-ʼɛ ásɛdtɛɛ́ bɔ́ aáken, “Nɛ́dē nyéēlááʼɛ́ á kálag e Dyǒb dyam áde kə̂ŋ Dabidɛ âmbɛnlé áde nzaa ékóbé mɔ́ ne ábē bad-ɛ? ");
INSERT INTO bssNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ansɔ́l á Ndáb-e-Dyǒb mɔ́ ne bad ábe bénwoón mɔ́, atéd eʼwɛle ábe éʼbédé ndɛ e Dyǒb, adyɛ́. Boŋ echɛd mbéndé eébagɛɛ́ mod ké nhɔ́g kunze ádyɛ̄ ábê eʼwɛle étōmɛɛ́ prisɛ. Mwěn andyɛ́, ábɛ̄-ʼɛ kə́ə́ŋne bad ábe bénwoón mɔ́ doŋge.” ");
INSERT INTO bssNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesuɛ ambádé bɔ́ áte aá, “Mwǎn-a-Moonyoŋ awóó nkamlɛn kə́ə́ŋne ámīn e mbwɛ-mé-nkɔ́me-áte.” ");
INSERT INTO bssNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Epun émpēe Yesuɛ ankɛ̌ á ndáb e mekáne. Ambootéd bad ayə́ged. Nɛ́n ámpē démbɛ̄ á mbwɛ-mé-nkɔ́me-áte. Mod nhɔ́g-kɛ ambɛ́ áhed awě ekáá émbáá éwédé. ");
INSERT INTO bssNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Bemeléede bé mbéndé ne Befarisia bénɔ́néʼáá mɔ́ chodchod, ânyín nzé ǎdǐd ane mod bwâm á mbwɛ-mé-nkɔ́me-áte, âbɛl nɛ́n békóbɛn mɔ́ awusé. ");
INSERT INTO bssNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesuɛ mɔ́-ʼɛ anchěm bɔ́ mewêmtɛn áte. Hɛ́ɛ Yesuɛ álâŋgɛɛ́ ane mod aá, “Hyɛ̌ étyéem átîntê hɛ́n.” Ane mod anwógɛ́n mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Dɔ́ɔ Yesuɛ ásɛdtɛɛ́ bad aá, “Nyéláa mɛ ké édé mbéndé âbɛl mboŋ á mbwɛ-mé-nkɔ́me-áte, káa âbɛl mbéb. Édé mbéndé âsoŋ aloŋgé á mod, káa âwúu mɔ́?” ");
INSERT INTO bssNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ahɔ́be nɛ̂, anɔne-ʼɛ bad á mesó. Dɔ́ɔ álâŋgɛɛ́ ane mod aá, “Sálé ekáá áte.” Asále áde ane mod ásánlé ekáá áte, ekáá éndyɛɛ́ mɔ́ bwâm ámpē. ");
INSERT INTO bssNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nɛ́n dénkōbēd Befarisia ne bemeléede bé mbéndé ekaŋ áte, béhəgké mɔ́ âpid mɔ́ mekáá. ");
INSERT INTO bssNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ámbīd e póndé Yesuɛ ankɛ̌ á ekone mîn âkáne. Ankáné nkuu ńsyə̄ə̄l kə́ə́ŋ ne mbwɛmbwɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Boŋ áde bǐn éʼkɛ́nlé, anchɛ́lé ábē bembapɛɛ, ápwɛdé dyôm ne bébɛ áwab tîntê, áchəgé bɔ́ aá, bembapɛɛ bé nlómag. Ábê bembapɛɛ bé nlómag bébédɛ́ɛ, ");
INSERT INTO bssNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simɔnɛ awe âmbagké dǐn aá, Petro, bɔ́ mwǎnyaŋ Andreya, Simɔnɛ, Jakɔbɛ, Jɔnɛ, Filibɛ, Batolomyo, ");
INSERT INTO bssNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyo, Tɔmasɛ, Jemsɛ mwǎn awě Alfɔsɛ, Simɔnɛ mod a kə́n, ");
INSERT INTO bssNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judasɛ, mwǎn awě Jemsɛ ne Judas Iskariɔdɛ awě antǐm Yesuɛ asóm. ");
INSERT INTO bssNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Dɔ́ɔ bɔ́ɔbɛ bembapɛɛ bésyɔ́gké á ekone sé, bépag á hǒm áde átánlé. Béntān bembapɛɛ bémpēe híin ne ndun e mod áhed. Ene ndun e mod embíd á mbwɔ́g e Judeya-tê esyəə́l, á Jerusalɛm, kə́ŋne á myad mé Tirɛ ne Sidɔn á nkin mé edíb é nkwɛ̌. ");
INSERT INTO bssNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bêmpɛ̌ nɛ̂ âwóg Yesuɛ eche pɔ́le, ne âbɛl nɛ́n ádid bad ábe békonle bwâm. Adidéʼáá bad ábe edəə́dəŋ bé mbéb éʼtágtéʼáá bɔ́mpē bwâm. ");
INSERT INTO bssNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mod tɛ́ɛ́ ahɛdáá aá mɔ́ nsidtɛ́n mɔ́ ngáne émbɛ̄ɛ̄ bán, ngíne ebídéʼáá mɔ́ á yə̌l echě edidéʼáá bad bwâm. ");
INSERT INTO bssNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Hɛ́ɛ ábóótédé ábē bembapɛɛ akalɛn aá, “Nnam ḿbɛ̂ ne nyé betóótōkɛ̄ bé bad áyə̄le nyêdé ásē e nkamlɛn ń Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nnam ḿbɛ̂ ne nyé ábe nyêdé nzaa bɔɔb, áyə̄le Dyǒb dɛ́kōdēd nyé. Nnam ḿbɛ̂ ne nyé ábe nyélebe bɔɔb áyə̄le nyɛ́ɛ̄wɔɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nnam ḿbɛ̂ ne nyé nzé édé bán ngáne nyéhídɛɛ́ Mwǎn-a-Moonyoŋ, bad békɔ́ɔ́ nyé, bébáa nyé á yə̌l, bésyə́ə nyé, béchəge-ʼɛ nyé mǐn mé mbéb. ");
INSERT INTO bssNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nyéwóge bwâm, nyébwɛɛn ámīn ḿmê mbwɛ, áyə̄le nsábe ḿme nyɛ́kudté ádyōb ńchábé ámīn. Melemlem nɛ̂ dɔ́ɔ besáá bêʼ bɔɔ́d bɔ́mpē bésyə́ə́ʼáá bekal béʼdəə́dəŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Boŋ édé ngɔl ne nyé ábe nyêdé nhɔn, áyə̄le nyêmaá echɛ̂n ndɛ akud. ");
INSERT INTO bssNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Édé ngɔl ne nyé ábe nyêkódé bɔɔb, áyə̄le póndé ěpɛ̌ echě nyɛ́také nzaa. Édé ngɔl ne nyé ábe nyêwɔɔ bɔɔb, áyə̄le nyɛ́ɛ̄lěb, nyéchīī-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Édé ngɔl ne nyé nzé moosyəə́l ákêmte nyé. Nɛ̂ dɔ́ɔ ábāb besáá békémtáá bekal béʼdəə́dəŋ bé metóm. ");
INSERT INTO bssNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Boŋ nlâŋge nyé ábe nyêwóglan mɛ hɛ́n bɔɔb mɛɛ́, nyédəŋ bad ábe béhɛde nyé kɔkɔɔ, nyébɛnle-ʼɛ bad ábe békɔ́ɔ́ nyé mboŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nyénamed bad ábe bésyə̂ŋtad nyé, nyékânnad-tɛ bad ábe bébɛle nyé nhel mé mekan. ");
INSERT INTO bssNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nzé mod abɔmé wɛ abɛ́n á akəg, ékunnéd mɔ́ ádíníí ámpē. Nzé mod akǒbné wɛ ḿmôŋ nkobe, weebáŋné mɔ́ ké echoŋ sɔ́te. ");
INSERT INTO bssNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kénzɛ́ɛ́ awě achɔ́mé wɛ chǒm, bɛɛ́ mɔ́. Mod ké ahéé-ʼɛ awě adumné wɛ bwěm, weéhɛdné mɔ́ bɔ́ ámbīd. ");
INSERT INTO bssNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kéchéé éche édə́ə́ wɛɛ́ bad bébɛl áwôŋ, ébɛl chɔ́ áwāb. ");
INSERT INTO bssNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nzé nyêdəə́ bad ábe bédə́ə́ nyé běnpɛn, né mekɛnag méhéé nyɛ́kudté ne nɛ̂? Kə́ə́ŋne bebɛl bé mbéb bɔ́mpē bédəə bad ábe bédə́ə́ bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nzé nyêbɛle mboŋ dásɔ̄ wɛ́ɛ bad ábe bébɛnle nyé mboŋ běnpɛn, né nsyə́ŋ ńhéé nyɛ́kudté ne nɛ̂? Kə́ə́ŋne bebɛl bé mbéb bɔ́mpē bébɛle nɛ̂. ");
INSERT INTO bssNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nzé édé nɛ́n bán bad ábe nyélyə́gé nlém bán bɔ́mpē bɛ́bāl nyé bwěm běnpɛn bɔ́ɔ nyébálɛɛ́ bwěm, né nsyə́ə́ŋ ńhéé nyɛ́kudté ne nɛ̂. Ké bebɛl bé mbéb bébále baáb ngáne bébíí bán bɔ́mpē bɛ́bāl bɔ́ melemlem. ");
INSERT INTO bssNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Boŋ nyédəŋ bad ábe béhɛde nyé kɔkɔɔ, nyébɛnle-ʼɛ bɔ́ mboŋ. Nyébále-ʼɛ bad bwěm ésebán nyésine dyamdyam ámbīd e nɛ̂. Nɛ̂ dɛ́bɛ̌l Dyǒb ábɛ nyé nsábe ḿme ńchábé á mîn, nyéchəgnéd-tɛ bán, bǎn bé Dyǒb á Ngum. Nyébíi-ʼɛ bán, Dyǒb ádé ngɔl ne bad ábe béēsāgnān Dyǒb, ne ábe bébébé nlém. ");
INSERT INTO bssNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nyéwôŋ nlém ń ngɔl melemlem ngáne awɛ̂n Titɛ́ɛ áwóó nlém ń ngɔl. ");
INSERT INTO bssNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Nyéekáádté bad, boŋ Dyǒb dɔ́mpē déēkāādtē nyé. Nyéehɔ́bé bad, boŋ Dyǒb dɔ́mpē déēhɔ̄bē nyé. Nyélagsan bad boŋ Dyǒb dɔ́mpē álagsan nyé. ");
INSERT INTO bssNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nyébage bad, boŋ Dyǒb dɔ́mpē ábage nyé. Akab áde nyɛ́kudté, bɛ́kīn dɔ́, bépuméd-tɛ dɔ́ ámīn, kə́ə́ŋ ásyɔgke, boŋ bépémtéd nyé. Melemlem mé nhəgtéd ḿme ébɛ́nlédé mɔ́ɔ Dyǒb dɔ́mpē dɛ́bɛnlédté.” ");
INSERT INTO bssNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesuɛ ankalé bɔ́ ngan aáken, “Mod awě akwedé ndím ahɛle alyə́géd waáb mod a ndím-ɛ? Bɔ́ bad bébɛ béehúnné ebíí-yɛ? ");
INSERT INTO bssNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mwǎn-a-ayə́ge eetómɛ́ɛ́ mod awě ayə́gte mɔ́, boŋ kénzɛ́ɛ́ awě amadé ayə́ge áte, abɛlé abɛ́ ndə́gke eche awe meléede. ");
INSERT INTO bssNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Cheé ékə́ə́ boŋ éwāmsān mwǎ púuted anyín á dǐd á wɛ̌n, ésebán ehɛle nkɔg ḿme ńdé emǒŋ á dǐd anyín? ");
INSERT INTO bssNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Chán éhɛle-sɛ eláá mwǎnyoŋ wɛɛ́, ‘Amúɛ̄, mwɛ̌, ńhûd wɛ mwǎ púuted á dǐd’, áde wéēnyīnɛ̄ɛ̄ nkɔg ḿme ńdé mmǒn á dǐd? Á-bedog-bad! Sébé éhûd nkɔg ḿme ńdé mmǒn á dǐd, dɔ́ɔ wɛ́tōŋʼɛ́ púuted echě edé mwǎnyoŋ á dǐd anyín, boŋ ehúd-tɛ chɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Alín á bwɛl á bwâm déebɛlɛ́ɛ́-sɛ áchyáá eʼpum bé mbéb. Alín á bwɛl dé mbéb-pɛ déēchyāāʼɛ́ eʼpum éʼ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Á epum é bwɛl dɔ́ɔ béchemɛɛ́ alín á bwɛl. Ébyɛ́ɛ́né bwâm bán, béēpādɛ̄ɛ̄ ngun á yə̌l e mbísaŋ káa besabé á yə̌l e mewáŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mod a bwâm abɛle bwâm áyə̄le éʼbíde mɔ́ á nlém-tê wɛ́ɛ bwâm ékóŋnédé. Mod a mbéb-pɛ abɛle mbéb áyə̄le ḿbídé mɔ́ á nlém-tê wɛ́ɛ mbéb nkóŋnédé. Édé nɛ̂ áyə̄le, mam ḿme ńlóné mod á nlém-tê, mɔ́-ʼaá mébíde mɔ́ á nsəl. ");
INSERT INTO bssNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Chán nyɛ́chəgɛ́ɛ́ mɛ póndé tɛ́ɛ́ bán, ‘A-Sáŋ, A-Sáŋ,’ boŋ nyéēbɛ̄lē dyam áde ńlâŋgɛɛ́ nyé? ");
INSERT INTO bssNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mod tɛ́ɛ́ awě apedé áwem, awě awógé ábêm eʼyale, boŋ ábɛlé-ʼɛ ngáne ńhɔ́bɛɛ́, mɛ̌həgtɛ́n nyé nyaa e mod echě ákóó abɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Adé nɛ́ɛ nlóŋ-a-ndáb, awě anlímé mekon mé ndáb se ásē, ásūmē ene ndáb eláá mîn. Edíb énlōnē, éból mɔ́ á ndáb-te ne ngíne, boŋ énkênhɛnlé chɔ́ apáŋ, áyə̄le ambíí chɔ́ alóŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Boŋ kénzɛ́ɛ́ awě awóge ábêm eʼyale boŋ eébɛle ngáne éʼhɔ́bɛɛ́ adíi nɛ̂ŋgáne mod awě anlóŋ ndáb ésebán asumme chɔ́. Áde edíb ébólé mɔ́ á ndáb-te, ene ndáb enkwɛ̌ melemlem mé póndé, epáá-ʼɛ nyaa eche ekamé ahəgtɛn.” ");
INSERT INTO bssNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Bad bésyə̄ə̄l bénwōg ḿmɛ́n mekan ḿme Yesuɛ áhɔ́béʼáá. Áde ámáá mɔ́ ahɔ́b, ankɛ̌ á dyad á Kapenahum. ");
INSERT INTO bssNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Á dyad-tê wê, mod ambáá a sə́nze é Roma ambɛ́ awě akamlan mbwɔ́kɛl e sə́nze. Awě mbəledɛ nhɔ́g awě ândəŋgé ákónléʼáá kə́ə́ŋ áhɛdé awɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nɛ́ɛ ane mod ambáá a sə́nze áwógé Yesuɛ dúu, anlóm belyə́ged bé dyad aá béchɛ̂nled mɔ́ Yesuɛ, áhyɛ áchood awě mbəledɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bépédé-ʼaá wɛ́ɛ Yesuɛ, boŋ béchāā mɔ́ ne nlém nhɔ́g bán, “Hyɛ̌ éhébe ane mod. Adíi mod awě atə́ŋgɛ́né ḿmoŋ nhébe akud. ");
INSERT INTO bssNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Adəə́ ádɛ̄d aloŋ á bad, alóŋgé-ʼɛ syánē ndáb e mékáne.” ");
INSERT INTO bssNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesuɛ anwoón bɔ́. Boŋ áde ákwógé apɛ á ndáb wɛ́ɛ ane mod ambáá a sə́nze, dɔ́ɔ mod ambáá a sə́nze ne álómɛɛ́ baáb wɛ́ɛ Yesuɛ ámpē aá, béláa mɔ́ bán, “A-Sáŋ, weétagté wɛ yə̌l, mměn meékwognedɛɛ́ âkob wɛ nken áwêm ndáb. ");
INSERT INTO bssNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nɛ́n ábɛ́lé menkênhɛnlé ké apɛ áwoŋ eʼsó. Boŋ ké eyale chɔ́ɔ wénhɔ̄bpē, awêm mbəledɛ ǎdyɛɛ́ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mměn ndíi mod awě adé ásē e nkamlɛn, mměn-nɛ nwóó sə́nze éche ńkamlanné. Nlâŋge pɔ́g mɛɛ́, ‘Kǎg’, ékǎg-kɛ nê děn. Nlâŋge empée mɛɛ́ ‘Hyǎg’, éhyǎg-kɛ nê děn. Nzé nlâŋge awêm mbəledɛ mɛɛ́, ‘Bɛ̌l échɛ́n’, ábɛlé-ʼɛ nê děn.” ");
INSERT INTO bssNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Áde Yesuɛ áwógé nɛ̂, yə̌l enkɔ́m mɔ́ áte. Hɛ́ɛ ákúnné eʼsó wɛ́ɛ echoŋ é bad éche éhídéʼáá mɔ́, áláŋgé bɔ́ aá, “Ne mbále, nlâŋge nyé mɛɛ́, meényīnɛ̄ɛ̄ mod á aloŋ á Israɛl ké nhɔ́g awě awóó nyaa e adúbe echě anɛ́n nken-e-mod áwóó.” ");
INSERT INTO bssNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Atim áde bad ábe bénlōmmē bétímé ámbīd á ndáb, béntān nɛ̂ŋgáne ane mbəledɛ ámáá bwâm adyɛɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Éebemɛɛ́ áte Yesuɛ ankɛ̌ á dyad áde béchəgɛɛ́ bán Nain. Ábē bembapɛɛ bémbɛ̄ ne mɔ́ ne echoŋ é bad. ");
INSERT INTO bssNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Áde ápédé bɛnbɛn ne mmwɛ ń dyad, bad bémbīdɛ̄n ndim ḿ mod ḿme mémbɛ̄ mpɔm ḿ mwǎn ḿme nyaá. Nyaá abédé nkúd a mmwaád. Ndun e mod echě embíd á dyad-tê, embɛ́ ne mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Áde Sáŋgú Yesuɛ ányíné ane mmwaád, ankóbtɛ́n mɔ́ etyəg. Dɔ́ɔ álâŋgɛɛ́ mɔ́ aá, “Lénéd awɛ́!” ");
INSERT INTO bssNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ansídé áʼsō, ásitɛ́n mekále ḿme bêmpēmmē ndim ḿ mod ámīn. Bepém béntyéem. Hɛ́ɛ áhɔ́bɛɛ́ aá, “A-kɔ́demod, nlâŋge wɛ nɛ́n mɛɛ́, syəə́ ásē.” ");
INSERT INTO bssNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Dɔ́ɔ ane kɔ́demod echě anwɛ́ ésyə́ŋgé ásē, boŋ ébootáád dyam ahɔ́b. Hɛ́ɛ Yesuɛ ábágé mɔ́ wɛ́ɛ nyaá. ");
INSERT INTO bssNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mbwɔ́g ménkōb moosyəə́l, békēmtē Dyǒb bán, “Nkal éʼdəə́dəŋ ambáá abídé áwɛd tîntê,” béhɔ̄bē-ʼɛ bán “Dyǒb ápíídé ábē bad!” ");
INSERT INTO bssNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ḿmɛ́n nkalaŋ tə̂ŋgɛne Yesuɛ ménwōgnēd mbwɔ́g e Judeya áte esyəə́l ne meloŋ ḿme médé bɛnbɛn. ");
INSERT INTO bssNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Bembapɛɛ ábe Jɔnɛ bɔ́mpē bénwōg ḿmɛ́n mam. Hɛ́ɛ békíí mɔ́ aláa. ");
INSERT INTO bssNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Dɔ́ɔ átédé bébɛ, álómé bɔ́ wɛ́ɛ Yesuɛ, aá bésɛded mɔ́ nɛ́n bán, “Wɛ-ɛɛ́ edé ane awě Dyǒb áhɔ́bé aá mɔ́ɔ̄lōm-ɛ, ngɛ́ sébɛ̂ sésineʼ mod ampée?” ");
INSERT INTO bssNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ábê bad bépédé-ʼaá wɛ́ɛ Yesuɛ, bélāŋgē mɔ́ bán, “Jɔnɛ, Ndusɛnɛ alómé sé áwôŋ aáken, ‘Wɛ-ɛɛ́ edé ane awě Dyǒb áhɔ́bé aá mɔ́ɔ̄lōm-ɛ, ngɛ́ sébɛ̂ sésineʼ mod ampée?’ ” ");
INSERT INTO bssNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Póndé eche bépédé áhed nɛ̂, adidéʼáá ekud é bad bwâm ábe bétágnáá nkole nyaa ne nyaa, ábe bênkǔd medim ne bad ábe eʼdəə́dəŋ bé mbéb éʼbédé áte. Ambɛ̌l bad híin ábe bênkwɛ̌ ndím bényînneʼ. ");
INSERT INTO bssNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Hɛ́ɛ átimtanné Jɔnɛ ábē bembapɛɛ aá, “Nyétimeʼ ámbīd, nyékɛ nyéláa Jɔnɛ mekan ḿme nyényínné dǐd ne ḿme nyéwógé. Nyéláa mɔ́ bán, bad ábe bênkwɛ̌ ndím bényînneʼ, ábe bésyə́gtéʼáá békag bwâm, ábe meləŋ ménkōbpē bésáá. Ábe bênkwɛ̌ ndɔ́g béwógneʼ, ábe bénwɛ̄, bépuudeʼ, nkalaŋ ḿ bwâm-mɛ ámpē ńkalteʼ wɛ́ɛ betóótōkɛ̄ bé bad. ");
INSERT INTO bssNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nnam ḿbɛ̂-ʼɛ ne kénzɛ́ɛ́ awě eéhəŋlɛne nlém á abum tə̂ŋgɛne mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Áde mésɛ́nzɛ ḿme Jɔnɛ ḿmáá atim ámbīd, Yesuɛ ambootéd ndun e mod echě embɛ́ áhed akale tə̂ŋgɛne Jɔnɛ. Ansɛdéd bɔ́ aáken “Póndé echě nyémbīdtē âkɛ dé atán Jɔnɛ á ehyáŋge, cheé nyéwēmtɛ̄nnē bán nyɛ́ɛ̄nyīn? Apab á chyaá áde epub éságtɛɛ́-yɛ? ");
INSERT INTO bssNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Cheé nyênkɛɛ́ anɔn? Mod awě ahédé kəse é mesaŋ-ɛ? Nyébíi nɛ́n bán, bad ábe béwáaʼ kəse é mesaŋ, boŋ bétɔgné-ʼɛ yə̌l, bédyɛɛ dásɔ̄ á ndáb é kə̂ŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Cheé-ɔ̄ nyênkɛɛ́ anyín? Nkal éʼdəə́dəŋ mɔ́ɔ nyênkɛɛ́ anyín-ɛ? Nɛ̂ děn! Ne mbále, nlâŋge nyé mɛɛ́, nyênyíné mod awě atómé nkal éʼdəə́dəŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jɔnɛ mɔ́ adé ane awě béhɔ́béʼáá áde bétélé eʼyale ábe Dyǒb áhɔ́bé aá, ‘Nɔnéʼ, nlóme ḿmêm mésɛ́nzɛ ḿme mɛ́sēbē wɛ áʼsō, âboŋsɛn wɛ nzii.’ ");
INSERT INTO bssNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Á mbále mod ké nhɔ́g awě abídé á abum dé mmwaád eetómɛɛ́ Jɔnɛ. Boŋ ké nɛ̂, mod awě adé ndimtɛn átîntê e bad ábe bédé á nkamlɛn ń Dyǒb, adé etógnɛ́n tómaa Jɔnɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Bad bésyə̄ə̄l ábe bénwōg chǒm éche Yesuɛ áhɔ́bé, kə́ŋne besaad bé táásɛ bênkwɛntɛ́n bán ntíi ń Dyǒb ńtə́ŋgɛ́né, áyə̄le bênkǔd edusɛn éche Jɔnɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Boŋ Befarisia ne bemeléede bé mbéndé bénchīm yə̌l kə́ŋne ntíi ń Dyǒb áyə̄le bémbāŋ edusɛn éche Jɔnɛ akob.) ");
INSERT INTO bssNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesuɛ ambád ahɔ́b aáken, “Cheé mɛ́həgtɛ́nné nyoŋgɛl é bad eʼchii? Chán běn békóó abɛ́? ");
INSERT INTO bssNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bédíi nɛ̂ŋgáne běndem ábe bédyɛ́ɛ́ á dyad-tê, boŋ bélēbpē nhɔ́g ne aníníí bán, ‘Sêtóŋgé nyé eʼloŋ, boŋ nyéeságɛ́ɛ́. Sêkɔ́nné nyé nkə́ŋgé ń kwééd, boŋ ké nɛ̂ nyéēchyɛ̄ʼɛ́ awɛ́.’ ");
INSERT INTO bssNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Áde Jɔnɛ, Ndusɛnɛ ápédé, eéyɔkeʼaá ndyééd adyɛ́, eemwágeʼaá-ʼɛ mǐm. Nyébootéd ahɔ́b bán, ‘Edəə́dəŋ é mbéb édé mɔ́ áte!’ ");
INSERT INTO bssNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwǎn-a-Moonyoŋ apedé, ádyāg ndyééd, á mwāg-kɛ mǐm, nyéhɔ̄bē bán, ‘Nyénɔ́ne mɔ́, adəə́ ndyééd bwâmbwam. Mmwɛ́ mǐmɛ ngɛ̂n, awoŋne belad bé táásɛ ne bebɛl bé mbéb.’ ");
INSERT INTO bssNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Boŋ kə́ə́ŋ ne á asóg, mod tɛ́ɛ́ awě abíí dyam abɛlé ahɔ́b aá, nzii e Dyǒb etə́ŋgɛ́né.” ");
INSERT INTO bssNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisia nhɔ́g anlébé Yesuɛ aá ahyɛ ádyɛ̂ ndyééd áwe ndáb. Áde ápédé áwed, andyɛɛ́ ásē, âdyɛ́ ndyééd. ");
INSERT INTO bssNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mmwaád nhɔ́g mɔ́-ʼɛ abédé á dyad-tê wê, awě abédé mbɛlé-mbéb. Awóg áde áwógé bán Yesuɛ adyâg ndyééd á ndáb e Farisia, ampɛɛ́n apom á dyɔ̌g dé elod é bwâm áhed. ");
INSERT INTO bssNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Anyogɛ́n ásē bɛnbɛn ne mekuu ḿme Yesuɛ, ábootéd achii, ásɔbtéʼ mɔ́ mekuu ne mésɔd. Ampíné mɔ́ mekuu ne échē esid é nló, ámwāā mɔ́ mekuu âlúmed edúbé, anyɔ̌nlé-ʼɛ mɔ́ mekuu ne ádê dyɔ̌g dé elod é bwâm. ");
INSERT INTO bssNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Anyín áde ane Farisia ányíné nɛ̂, anhɔ́b áwe nlém-tê aá, “Nzé nkal éʼdəə́dəŋ mɔ́ɔ̄ anɛ́n mod ânkoŋgé abɛ́, né abágéʼáá abíɛʼ nyaa e mmwaád eche anɛ́n mmwaád awě akidtan mɔ́ ádíí ne abɛ́ áde áwóó, né abíí-ʼɛ nɛ́n aá anɛ́n mmwaád adíi mbɛlé-mbéb.” ");
INSERT INTO bssNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ mɔ́ nɛ́n aá, “A-Simɔn ndəə́ wɛ mwǎ pɔ́le aláa.” Farisia ne ankwɛntɛ́n aá, “A-meléed, cheé édé? Kǎg áʼsō, éláa mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Dɔ́ɔ Yesuɛ áhɔ́bɛɛ́ aá, “Mod nhɔ́g abédé awě abáléʼáá bad ngáb. Ane mod akáléʼáá bad bébɛ melúm. Akáléʼáá nhɔ́g móom mé eʼkə́lé métáan, aníníí-ʼɛ eʼkə́lé étáan. ");
INSERT INTO bssNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bɔ́ modmod bénkênhɛnlé atuɛ. Né-ɔɔ́ anlagsɛ́n bɔ́ mod tɛ́ɛ́ áde alúm. Bɔɔb-pɔɔ́, áyə̄le bɔ́ bad bébɛ, nzɛ́-módɛ́ édúbpé wɛɛ́ ǎtōmtɛ̄n mɔ́ adəŋ?” ");
INSERT INTO bssNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simɔnɛ antimtɛ́n mɔ́ aá, “Ndúbpé mɛɛ́, ane awě alúm déntōmtɛ̄nnē achab ámīn.” Dɔ́ɔ Yesuɛ áhɔ́bɛɛ́ aá, “Etə́ŋgɛ́né.” ");
INSERT INTO bssNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Dɔ́ɔ ákunnɛɛ́ wɛ́ɛ ane mmwaád, boŋ álāŋgē Simɔnɛ aá, “Enyíne anɛ́n mmwaád-ɛ? Áde ńsɔ́lé áwôŋ ndáb, wenkêmbaá mɛ mendíb wɛɛ́ ńwobned mekuu. Boŋ anɛ́n mmwaád asáŋté mɛ mekuu ne ḿmē mésɔd, apíné-ʼɛ mɔ́ ne échē esid. ");
INSERT INTO bssNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wenkênháá mɛ tə̂l, boŋ taa mensɔ́l hɛ́n, eésógɛ́ɛ́ mɛ mekuu anyɔle. ");
INSERT INTO bssNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wenkênwɔ́gédté mɛ dyɔ̌g á nló âkob mɛ nken, boŋ awɔ́gté mɛ dyɔ̌g dé elod é bwâm á mekuu. ");
INSERT INTO bssNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Edəŋge é ngíne éche anɛ́n mmwaád álúmté, édé nhəgtɛ́n ne alagsɛn áde ákúdé áyə̄le ekud é mekan mé mbéb éche ábɛ́lé. Mod-tɛ awě béebudɛɛ́ mbéb alagsɛn, eébūdɛ̄ɛ̄ edəŋge alúmed.” ");
INSERT INTO bssNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ mmwaád ne aá, “Ekudé alagsɛn dé mbéb áyə̄le mbéb ḿmôŋ ńsyə̄ə̄l.” ");
INSERT INTO bssNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bad ábe bɔ́bɔ̄ɔ bédyágéʼáá ndyééd bênsɛdéd yə̌l bánken, “Ebə́l é mod éhéé chɛ́n éche éwóó kə́ŋne kunze âlagsɛn mbéb?” ");
INSERT INTO bssNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesuɛ anláá mmwaád ne aá, “Adúbe áde éwóó áchóŋté wɛ, kǎg ne nsaŋ.” ");
INSERT INTO bssNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ámbīd e nɛ̂ Yesuɛ ambootéd akɛ myad ne myad, mémbáá ne mésad. Akagéʼáá, ákaléʼ nkalaŋ ḿ bwâm mé nkamlɛn ń Dyǒb. Akɛɛ́néʼáá ábē bembapɛɛ dyôm-ne-bébɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Bebaád ábe eʼdəə́dəŋ bé mbéb bémbɛ̄ɛ̄ áte ne ábe békónléʼáá nkole mémpēe, boŋ áchōōd bɔ́, bɔ́mpē bémbɛ̄ á echoŋ. Ábê bebaád bébédɛ́ɛ, Maria mmwaád a dyad á Matala awě ánhūdtē eʼdəə́dəŋ bé mbéb saámbé á yə̌l, ");
INSERT INTO bssNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joanaa, mmwaád awe Kusa, mod awě abédé nló áyə̄le bembəledɛ ábe Hɛrɔdɛ, Susanaa ne ekud é bebaád bémpēe. Ábê bebaád bébɛ́nládtáá ábab bwěm běn, bétɔgnán Yesuɛ ne ábē bembapɛɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ekud é bad émbīd dyad ne dyad tɛ́ɛ́ âhyɛ dé anyín Yesuɛ. Áde béládné áte nɛ̂ bɔɔb, ankalé bɔ́ ngan nɛ́n aá, ");
INSERT INTO bssNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Nkwɛl-é-nzag nhɔ́g ankɛ̌ mbə́l asob á nzag-tê. Áde ásobɛɛ́ mɔ́ nɛ̂, doŋge dénhūn á nzii-tê, betóm bé nzii bémad mɔ́ akɔgted ámīn, menɔn mɔ́mpē mémad mɔ́ asɔ̂mted. ");
INSERT INTO bssNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Doŋge dé mbə́l dénhūn á eláá mîn. Ḿmê ménkōb, boŋ ménhyɛ̄lē áde méepedɛɛ́ akwog, ngáne édíí bán ndɔɔb e eláá mîn eékoŋgɛ́ɛ́ mendíb. ");
INSERT INTO bssNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Doŋge ámpē dénhūn wɛ́ɛ mekɔ̂d médíí. Nɛ́ɛ bɔ́ɔ̄bɔ̄ɔ békwōgē, mekɔ̂d ménkāŋ ábɛ̂ bwěm. ");
INSERT INTO bssNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mbə́l mémpēe méntān ndɔɔb e bwâm. Mênkwǒg, ńchyáá-ʼɛ bwâmbwam. Doŋge dé eʼsɔ́g dénwālē mbwɔ́kɛl é mbum.” Áde Yesuɛ ámádé nɛ̂, ambád áte aá, “Kénzɛ́ɛ́ awě awóó metúu áwógeʼ.” ");
INSERT INTO bssNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ámbīd e póndé, Yesuɛ ábē bembapɛɛ bénlāā mɔ́ bán, átógned bɔ́ ene ngan. ");
INSERT INTO bssNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Hɛ́ɛ álâŋgɛɛ́ bɔ́ nɛ́n aá, “Dyǒb ábágé nyé kunze âbíi kun é nkamlɛn ń Dyǒb. Boŋ bad ábe bélyə́gé ásē, bɛ́wōg chɔ́ nɛ́ɛ ngan âbɛl nɛ́n, bényíneʼ, boŋ béechemɛ́ɛ́, béwógeʼ, boŋ béēsōŋtānnē. ");
INSERT INTO bssNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Bɔɔb-pɔɔ́, ńtógned nyé ene ngan. Mbə́l ńdíi Eyale é Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mbə́l ḿme ménhūn á nzii-tê ńlûmte bad ábe béwóge eyale é Dyǒb, boŋ ámbīd e póndé Devəlɛ áhyɛ ahúd bɔ́ chɔ́ á nlém-tê, âbɛl nɛ́n béēdūbpē Dyǒb se békūd eʼsoósoŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mbə́l ḿme ńhúné á meláá-tê ńlûmte bad ábe, nzé béwógé Eyale é Dyǒb, békobe chɔ́ ne menyiŋge, boŋ échê eyale éēwēnnādtē bɔ́ á nlém-tê. Bédúbpe Dyǒb á esóŋ é póndé boŋ á póndé e mekəgsɛn bédol yə̌l ámbīd. ");
INSERT INTO bssNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mbə́l ḿme ńhúné á mekɔ̂d-te, ńlûmte bad ábe béwóge Eyale é Dyǒb, boŋ kə́ə́ŋ ne á asóg, mpúlé mé nkǒŋsé, abud á bwěm awóŋ, ne menyiŋge mé nkǒŋsé ńkáŋ bɔ́ nlém áte. Nɛ̂ ákəəʼ, béehɛlɛ́ɛ́ kəse é eʼpum achyáa. ");
INSERT INTO bssNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mbə́l ḿme mɔ́-ʼɛ méntān kəse e ndɔɔb, ńlûmte bad ábe béwóge Eyale é Dyǒb ne nlém ńsyə̄ə̄l, békōō-ʼɛ chɔ́ á nlém-tê. Nɛ̂ ábɛleʼ béwɛsan kə́ə́ŋ béchyáá eʼpum. ");
INSERT INTO bssNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Modmod eémāāʼɛ́ etrúkáŋ achod se ákōō chɔ́ á ebwɔg-sɛ́, káa atíbéd chɔ́ á anɔŋ sé. Abɛlé ákɛ̄lē chɔ́ dásɔ̄ ámīn, âbɛl boŋ kénzɛ́ɛ́ awě asɔ́le á ndáb, ányíne ekíde. ");
INSERT INTO bssNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Dyam tɛ́ɛ́ áde ádé á eʼkoŋnéd-te dɛ́bīd á nhɛ́né. Kéchéé-ʼɛ éche ênsɔɔ́m á eʼkoŋnéd ébyɛ̄ɛn, ébíd-tɛ á enyɛn. ");
INSERT INTO bssNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Né-ɔɔ́, nyétêd póndé ngáne nyéwóglanné. Kénzɛ́ɛ́ awě awóó nsôŋtɛn ń kun é nkamlɛn ḿ mín, Dyǒb dɛ́bād mɔ́ ḿmê nsôŋtɛn abɛ. Ane awě mɔ́-ʼɛ eewóo, ǎbɔ̄d ké éche áwémtɛ́né aá mɔ́wōō.” ");
INSERT INTO bssNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Bɔɔb-pɔɔ́, áde Yesuɛ nyaá ne baányaŋ béhyédé mɔ́ anyín, bénkênhɛnlé mɔ́ apɛ bɛnbɛn, áyə̄le etə́l éēbēdɛɛ́ ngáne ndun e mod ênləŋnédté mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Dɔ́ɔ bad bélâŋgɛɛ́ mɔ́ bán, “Pɔ́n nyoó bɔ́ɔbɛ baányoŋ bétyéémé á ebwɔ́g, béhɛde-ʼɛ wɛ anyín.” ");
INSERT INTO bssNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Hɛ́ɛ Yesuɛ átimtanné bɔ́ nɛ́n aá, “Bad ábe béwóge eyale é Dyǒb, bébɛlé-ʼɛ ngáne échê eyale éhɔ́bɛɛ́, bɔ́ɔ̄ bédé awem nyaá ne ábêm baányaŋ.” ");
INSERT INTO bssNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mbwɛ nhɔ́g Yesuɛ ansɔ́l á bɔ̌lɛ-tê ne ábē bembapɛɛ, aláá bɔ́ aá, “Syáā déchabe pɛd e edib eníníí.” Dɔ́ɔ bébwɔ́gké ekɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Á ekɛ-tê wɛ̂, eʼchó bénkōb Yesuɛ. Hɛ̂ dɔ́ɔ ekukud étáné bɔ́ átîntê e edib. Mendíb ménsɔ̄l bɔ́ á bɔ̌lɛ-tê kə́ə́ŋ, mam mébɛ́ɛ́n bɔ́ ebébtéd. ");
INSERT INTO bssNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Hɛ́ɛ békíí Yesuɛ anyem ásē boŋ bélāŋgē mɔ́ bán, “A-Sáŋ, a-Sáŋ, pɔ́n syánē dewág-ōō!” Dɔ́ɔ ányémmé ásē, ákānnē ekukud éched áte, éhɔ́ɔ́-ʼɛ. Edíb éche éhódéʼáá áte chɔ́mpē énsōg ahod. ");
INSERT INTO bssNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Dɔ́ɔ ásɛdtɛɛ́ bɔ́ aáken, “Nɛ́dē nyéedúbpɛ́ɛ́ mɛ-yɛ?” Nɛ́n dénkōbēd bɔ́ mbwɔ́g, yə̌l-lɛ enkɔ́m bɔ́ áte bwâmbwam bésɛdté nhɔ́g ne aníníí bánken, “Ebə́l é mod éhéé chɛ́n, éche ékamlan kə́ə́ŋne ekukud ne mendíb, kə́ə́ŋ béwōgnē-ʼɛ mɔ́?” ");
INSERT INTO bssNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesuɛ ne ábē bembapɛɛ bênchabé edib, bootya á Galilia, bépɛ̄ á múde ḿmíníí, á mbwɔ́g e Gɛrasin. ");
INSERT INTO bssNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Áde ábídé á nkin ambomɛ́n mod a dyad nhɔ́g awě eʼdəə́dəŋ bé mbéb bémbɛ̄ɛ̄ áte. Ébédé etûn é póndé áde ane mod éēhágeʼaá mbɔ́té. Eédyɛɛʼaá ké á ndáb-te, nzése á soóbadɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Anyín áde ányíné Yesuɛ, ankwɛ̌ mɔ́ á mekuu ne esaád á nsəl, ábōnē aá, “A-Yesu, Mwǎn a Dyǒb á Ngum, cheé sóo déwóŋné? Sôn, weekɔ́gsán mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nɛ̂ démbɛ̄ áde Yesuɛ ámáá eʼdəə́dəŋ bé mbéb akamlɛn aá, éʼbîd mɔ́ áte. Ngen ne ngen, nzé eʼdəə́dəŋ bé mbéb bénsɔ̄l mɔ́ áte, ké á mehaŋgé dɔ́ɔ ámbɛ̄ɛ̄, apádtádtáá bengɔbéngɔ̄bē ábe béhédé mɔ́ á mekuu ne mekáá, boŋ edəə́dəŋ é mbéb ékɛɛné mɔ́ á ehyáŋge. ");
INSERT INTO bssNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesuɛ ansɛdéd mɔ́ aáken, “Chán dǐn ádíí wɛ?” Ankwɛntɛ́n aá, “Amutɛɛ.” Anhɔ́b nɛ̂ŋgáne eʼdəə́dəŋ bé mbéb híin bénsɔ̄nlē mɔ́ áte. ");
INSERT INTO bssNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Eʼdəə́dəŋ bé mbéb ábed éʼchááʼáá Yesuɛ bán, eehúnté bɔ́ á echóg échě éewóo asóg, ");
INSERT INTO bssNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Esɔg é nguu ébédé áhed édyāg medyɛ́ á mbám mé ekone. Dɔ́ɔ ábê eʼdəə́dəŋ éʼcháaʼɛ́ Yesuɛ bán átɛde bésɔ̂l ké á esɔg é nguu-tê. Dɔ́ɔ Yesuɛ ábágé bɔ́ kunze. ");
INSERT INTO bssNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Abíd áde eʼdəə́dəŋ bé mbéb bɛ̂ éʼbídé ane mod áte, bénsɔ̄l échê nguu áte. Dɔ́ɔ nguu éwúbpé ásē, ényəgtéʼ á eʼláá bé nkin mé edib, éhún á edib-tê, éhó-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Áde benɔn bé nguu bényíné nɛ̂, béntōm mehélé, békag békanlé bad nkalaŋ á dyad-tê ne á mebwɔ́g ḿme médé bɛnbɛn. ");
INSERT INTO bssNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Awóg áde bad béwógé-ʼaá nɛ̂, bébwɔ́gé-ʼɛ ásē âkɛ dɛ́nyīn dyam áde ábɛ́nlédé. Bépédé-ʼaá wɛ́ɛ Yesuɛ ámbɛ̄ɛ̄, bényín ane mod awě ánhūdtē eʼdəə́dəŋ bé mbéb áte ngáne ádyɛ́ɛ́ mɔ́ á akéb, ahédé mbɔ́té á yə̌l, ádyɛ̄ɛ̄-ʼɛ bwâm. Dɔ́ɔ mbwɔ́g ńkóbé bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bad ábe bénnyīnɛ̄n dǐd bênkalé bɔ́ ngáne Yesuɛ áchóŋté ane mod. ");
INSERT INTO bssNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Hɛ́ɛ bad bé mbwɔ́g e Gerasin béláŋgé Yesuɛ bán ásyəə áwāb ndɔɔb, áyə̄le mbwɔ́g ń ngíne ménkōb bɔ́. Dɔ́ɔ ásɔ́lé mɔ́ á bɔ̌lɛ-tê, boŋ ásūɛ̄ʼ. ");
INSERT INTO bssNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mod awě bénhūdtē eʼdəə́dəŋ bé mbéb áte ancháŋ mɔ́ aá búmɔ̄ békag, boŋ Yesuɛ antiméd mɔ́ ámbīd aá, ");
INSERT INTO bssNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Timɛ́ʼ áwôŋ dyad, ékɛ ékanle bad ndəle a dyam echě Dyǒb ábɛ́nlé wɛ.” Ane mod ansú á dyad, ákag, ákanle mod tɛ́ɛ́ dyam áde Yesuɛ ábɛ́nlé mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Áde Yesuɛ áhúú, ndun e mod enhyɛ̌ mɔ́ aságnɛn ne menyiŋge ngáne émbɛ̄ɛ̄ bán bésínéʼáá mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Hɛ́ɛ mod nhɔ́g awě béchə́géʼáá bán Jairusɛ ápédé áwē. Jairusɛ abédé nhɔ́g átîntê benkamlɛnɛ á ndáb e mekáne. Ankwɛ Yesuɛ á mekuu, áchāā mɔ́ aá, áhyɛ áwe ndáb. Aá ");
INSERT INTO bssNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ḿmē mpɔm ḿ mwǎn a mmwaád ńhɛde awɛ́. Áde Yesuɛ ákagké áwed, bad bênləŋnéd mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mmwaád nhɔ́g ambɛ́ áhed awě akǒnléʼáá nkole ḿme mekií mébídéʼáá mɔ́ á yə̌l póndé ésyə̄ə̄l. Ḿmê nkole ḿbédé mɔ́ á yə̌l á etûn é dyôm-a-mwɛ́ ne ḿbɛ ésebán modmod ahɛle mɔ́ bwâm adid. ");
INSERT INTO bssNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Hɛ́ɛ ábídé Yesuɛ ámbīd, boŋ ásitɛ́n Yesuɛ mesó mé nkobe ḿme ánwāāʼɛ́. Ábwɔ̄g-ábwɔ̄g mekií ménsōg mɔ́ abíd á yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Dɔ́ɔ Yesuɛ ásɛdtɛɛ́ aáken, “Nzɛ́-módɛ́ asidtɛ́né mɛ?” Modmod enkênkwɛntɛ́nné. Dɔ́ɔ Petro áhɔ́bɛɛ́ aá, “A-Sáŋ, ngɔ́mē ndun e mod elə̌ŋnédé wɛ, kə́ə́ŋ békáŋnɛ́né-ʼɛ wɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Boŋ ké nɛ̂ Yesuɛ anhɔ́b aá, “Mod akidtɛ́né mɛ, áyə̄le nwógé ngáne ngíne ebídé mɛ á yə̌l.” ");
INSERT INTO bssNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Áde ane mmwaád ányíné nɛ̂ bɔɔb aá mɔ́ɔ̄hɛlɛɛ́ yə̌l akoo, ambíd Yesuɛ áʼsō. Anəə́ʼáá ne mbwɔ́g. Ankwɛ mɔ́ á mekuu. Hɛ́ɛ áhɔ́bɛɛ́ áʼsō wɛ́ɛ bad bésyə̄ə̄l chǒm éche ékə́ə́ boŋ ásitɛ́n mɔ́, ne ngáne mɔ́dyɛ́ɛ́ bwâm melemlem mé póndé. ");
INSERT INTO bssNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Dɔ́ɔ Yesuɛ áhɔ́bɛɛ́ aá, “A-mwǎn-a-mmwaád, adúbe ádōŋ ádídé wɛ bwâm. Kǎg ne nsaŋ.” ");
INSERT INTO bssNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Á póndé eche Yesuɛ áhɔ́bɛɛ́ nɛ̂, dɔ́ɔ mod awě bélómé wɛ́ɛ Jairusɛ ápédé boŋ áhɔ̄bē nɛ́n aá, “Weétɔgné wɛ Meléede ataged. Awoŋ mwǎn amaá mɔ́ awɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesuɛ awógé-ʼaá nɛ̂, boŋ álāŋgē Jairusɛ aá, “Weewógé mbwɔ́g! Dúbé dúbpɛ́n, né mwǎn ǎdyɛɛ́ wɛ bwâm.” ");
INSERT INTO bssNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Áde Yesuɛ ápédé wɛ́ɛ Jairusɛ áwe ndáb, enkênháá etə́l aá, mod ampée áhîd mɔ́ á ndáb-te éetómɛɛ́ Petro, Jɔnɛ ne Jemsɛ, nchoo ne ane mwǎn sáá bɔ́ nyaŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bad béchyɛ́ʼáá, bélebé-ʼɛ. Yesuɛ anláá bɔ́ nɛ́n aá, “Nyéēchyɛ̄ɛ̄ʼ. Ane mwǎn eewédɛɛ́, akúne kúnɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bad bêmbootéd mɔ́ awɔɔ, ngáne bémbīīʼɛ́ bán amaá awɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Hɛ́ɛ Yesuɛ áchə́ŋgé mɔ́ ekáá, boŋ áchəgé mɔ́ aá, “A-mwǎn, pádé ásē.” ");
INSERT INTO bssNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Dɔ́ɔ edəə́dəŋ étímé mɔ́ á yə̌l, apádé-ʼɛ ásē ábwɔ̄g-ábwɔ̄g. Yesuɛ anláá bɔ́ aá, bébɛ mɔ́ ndyééd, ádyɛ̂. ");
INSERT INTO bssNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yə̌l enkɔ́m nyaá bɔ́ sáŋ áte bwâmbwam, boŋ Yesuɛ anláá bɔ́ aá, béekanlé modmod dyam áde ábɛ́nlédé. ");
INSERT INTO bssNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesuɛ anchɛ́lé ábē bembapɛɛ dyôm ne bébɛ abwɔ́g ahɔ́g. Ambag bɔ́ ngíne ne kunze âhúd bad eʼdəə́dəŋ bé mbéb áte, ne âmad nkole nyaa ne nyaa. ");
INSERT INTO bssNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Anlóm bɔ́ aá, békɛ békale nkalaŋ mé nkamlɛn ń Dyǒb, béchoŋte-ʼɛ bad. ");
INSERT INTO bssNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Dɔ́ɔ álâŋgɛɛ́ bɔ́ nɛ́n aá, “Nyéewánlé chǒmchǒm á ekɛ, ké ntóŋ, ké ekwɛ, ké ndyééd káa ngáb, modmod eewánlé-ʼɛ mbɔ́té ébɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ndáb ké ehéé echě nyésɔ́lé áte, nyédyɛɛ áwēd-te kə́ə́ŋ ne mbwɛ ḿme nyésyəŋgɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Dyad ké áhéé-ʼɛ áde béekobɛɛ́ nyé nken, nyétɛ̄dē dɔ́, nyékūd-tɛ ebumbú á mekuu âlúmed nɛ́n bán échab ebébtéd énɔne běn.” ");
INSERT INTO bssNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Hɛ́ɛ bembapɛɛ bébwɔ́gké ásē, békǎg dyad ne dyad tɛ́ɛ́, békalé nkalaŋ ḿ bwâm, bédidé-ʼɛ bad bwâm hǒm ne hǒm tɛ́ɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Bɔɔb-pɔɔ́ Hɛrɔdɛ awě akamlánnáá aloŋ á Galilia anwóg mam mésyə̄ə̄l ḿme mêmbɛnléd. Mewêmtɛn métágéʼáá mɔ́ áte áyə̄le bad behɔ́g béhɔ́béʼáá bán, Jɔnɛ apuúdé, ");
INSERT INTO bssNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ábíníí bán, Elaijaa atimé ámbīd á nkǒŋsé, bémpēe-ʼɛ bán, nkal éʼdəə́dəŋ nhɔ́g aʼbɔɔ́d mɔ́ atimé ámbīd á aloŋgé. ");
INSERT INTO bssNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hɛrɔdɛ anhɔ́b aá, “Mêmbɛl bésɛ̄l Jɔnɛ nló. Nzɛ́ɛ́ ampée ńwógɛɛ́ bán abɛle ḿmɛ́n mekan?” Nɛ̂ dêmbɛ̌l ádə̄ŋ aá mɔ́nyîn ane Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Áde bembapɛɛ bé nlómag béhúú ámbīd, bénlāā Yesuɛ mam ḿme bébɛ́lé. Hɛ́ɛ átédé bɔ́ boŋ átimné bɔ́ á ahə́ŋgé á hǒm á dyad á Betsaida. ");
INSERT INTO bssNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Áde amute á bad áwógé nɛ̂, dénhīd mɔ́ áwed, kə́ə́ŋ bétán mɔ́. Ankob bɔ́ bwâm, ákanlé bɔ́ pɔ́le e nkamlɛn ń Dyǒb, áchoŋté-ʼɛ bad ábe béhɛ́déʼáá bwâm adyɛɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Áde ngukɛ́l épédé dɔ́ɔ bembapɛɛ bélâŋge Yesuɛ bán, “Chené ábɛ́n bad, bétimeʼ á myad-tê ḿme médé bɛnbɛn, âbɛl béhɛd ndyééd ne hǒm áde bɛ́naáʼɛ́. Ndyééd eésaá hɛ́n, eʼnoŋ-ʼɛ béesaá wɛ́ɛ dédíí nɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ bembapɛɛ aá, “Nyé bɔ́ nyébɛ bɔ́ chǒm éche bɛ́dyɛ̄ɛ̄.” Dɔ́ɔ béhɔ́bɛɛ́ bán, “Sêwóó eʼwɛle éʼtáan ne súu ébɛ. Ene ndyééd eéhɛ̄lɛ̄ɛ̄ bad bésyə̄ə̄l akwog.” ");
INSERT INTO bssNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Mesoŋgé mé bad ábe bébédé áhed mémbɛ̄ eʼkə́lé éʼtáan. Boŋ Yesuɛ anláá ábē bembapɛɛ aá, “Nyélad bad áte, nyékab bɔ́ boŋ akab tɛ́ɛ́ ábɛ̂ móom mé bad métáan.” ");
INSERT INTO bssNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bênkǎb bad áte ngáne ánhɔ̄bpē. ");
INSERT INTO bssNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Hɛ́ɛ Yesuɛ átédé ábê eʼwɛle éʼtáan ne échê súu ébɛ, ákabé áte, ásāgnān Dyǒb boŋ ábagé bembapɛɛ aá békabpe bad. ");
INSERT INTO bssNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bad bésyə̄ə̄l béndyɛ̄, békód-tɛ kə́ə́ŋ ene ndyééd élyə̄g ásē, eche béládé áte eʼlóŋ dyôm ne éʼbɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Mbwɛ nhɔ́g Yesuɛ anchíb yə̌l âkɛ dé akáne. Bembapɛɛ běnpɛn bɔ́ɔ bémbɛ̄ áhed. Ansɛdéd bɔ́ aáken, “Nzɛ́-módɛ́ bad bɔ́ béhɔ́bɛɛ́ bán ndé?” ");
INSERT INTO bssNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bêntimtɛ́n mɔ́ bán, “Doŋge á bad béhɔ́be bán, edíi Jɔnɛ Ndusɛnɛ. Doŋge áhɔ̄bē bán, Elaijaa, bémpēe bán, nkal éʼdəə́dəŋ aʼbɔɔ́d atimé ámbīd á aloŋgé.” ");
INSERT INTO bssNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Dɔ́ɔ Yesuɛ áhɔ́bɛɛ́ aá, “Boŋ nyéběn-nɛ, nzɛ́-módɛ́ nyéhɔ́bɛɛ́ bán ndé?” Dɔ́ɔ Petro áhɔ́bɛɛ́ aá, “Edíi Ane Awě Dyǒb Áwɔ́gté.” ");
INSERT INTO bssNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Hɛ́ɛ ásímɛɛ́ bɔ́ etúu áte, álāŋgē-ʼɛ bɔ́ aá béepanlé áte. ");
INSERT INTO bssNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ambád aá, “Mwǎn-a-Moonyoŋ atə́ŋgɛ́né ákūd metake híin, bad bémbáá bɔ́ɔbɛ beprisɛ bémbáá ne bemeléede bé mbéndé bɛ́bāŋ-ʼɛ mɔ́ á yə̌l. Bɛ́wūū mɔ́, boŋ eʼpun ábe éʼlóntɛ́né éʼláán, ǎpuú.” ");
INSERT INTO bssNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Anláá moosyəə́l áhed aá, “Kénzɛ́ɛ́ awě adəə́ mɛ ahíd ásob yə̌l mendíb, ápêm ádē awɔg mbwɛ tɛ́ɛ́, boŋ áhíde mɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Áyə̄le kénzɛ́ɛ́ awě ahɛde ádē aloŋgé asoŋ, ǎbɔ̄d dɔ́. Kénzɛ́ɛ́-ʼɛ awě abɔ́dé ádē aloŋgé áyə̄l echêm, ǎkǔd aloŋgé áde déemaáʼ. ");
INSERT INTO bssNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nsyə́ə́ŋ ńhéé mod ákudté nzé akudé nkǒŋsé ńsyə̄ə̄l boŋ abɔ́ɔ́, kéʼɛ abɔ́dé échē edəə́dəŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kénzɛ́ɛ́ awě ǎkwāgɛ̄n mɛ ne ábêm eʼyale, Mwǎn-a-Moonyoŋ mɔ́mpē ǎkwāgɛ̄n mɔ́ á póndé echě ápɛɛ́ ne ehúmé échē, nɛ́dē ehúmé é Sáŋ ne ángɛl éche ésáá. ");
INSERT INTO bssNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Boŋ á mbále, baahɔ́g bédé nló ámīn bɔɔb, béenyínɛ́nné kwééd dǐd, áde béēsēbpɛɛ́ nkamlɛn ń Dyǒb anyín.” ");
INSERT INTO bssNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nɛ́ɛ émádé ké eʼpun waam, áde Yesuɛ ámáá ahɔ́b nɛ̂, ankɛɛ́n Petro bɔ́ Jɔn ne Jemsɛ á ekone mîn âkáne. ");
INSERT INTO bssNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Áde ákânnɛɛ́ nɛ̂, eʼsó bênhəŋlɛ́n mɔ́ á nló, nkobe ḿmē mɔ́-ʼɛ ḿpúbé féréd, ḿmwaá-ʼɛ áte. ");
INSERT INTO bssNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ábwɔ̄g-ábwɔ̄g bad bébɛ, Mosɛɛ ne Elaijaa, bémbīdɛ̄n ehúmé é ngum, bébootéd mɔ́ akalɛn. Békáléʼáá ngáne álōnēdtē ntíi ń Dyǒb tə̂ŋgɛne kwééd eche áwɛ̄ɛ̄ á Jerusalɛm. ");
INSERT INTO bssNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Eʼchó bénlōn Petro ne baáb á dǐd. Áde békábnédé bényīn ehúmé échē ne bad bébɛ áhed. ");
INSERT INTO bssNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Áde ábê bad bébɛ bétɛdtɛɛ́ Yesuɛ, dɔ́ɔ Petro álâŋgɛɛ́ mɔ́ aá, “A-Sáŋ, ébóó ngáne syáā dédíí hén. Délôŋ eʼbem éʼláán, échôŋ, éche Mosɛɛ ne éche Elaijaa.” Anhɔ́b nɛ̂ ésebán abíí chǒm éche áhɔ́bɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Eépedɛɛ́ ké amad á nsəl, boŋ mbag ébíd, ékúdtɛ́n bɔ́. Nɛ́n dénkōbēd bɔ́ mbwɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Hɛ́ɛ béwógé ehɔ́b ébíde á mbag-tê nɛ́n, “Mwǎn awêm mɔ́ nɛ́n. Mɔ́ɔ ḿpwɛ́dé. Nyéwógne mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Émáá-ʼaá ahɔ́b nɛ̂ dɔ́ɔ bényíné Yesuɛ mwěnpɛn. Bénkoó ádɛ́n akan ésebán békanle modmod dɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Áde bǐn éʼsáŋgé, Yesuɛ bɔ́ɔbɛ bembapɛɛ bênsǔd á ekone-sɛ́. Ndun e mod ehyɛ mɔ́ abomɛn. ");
INSERT INTO bssNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hɛ́ɛ mod nhɔ́g á echoŋ é bad-tê wê álébpɛɛ́ mɔ́ aá, “A-meléed, sôn, ncháaʼ wɛ mɛɛ́, énɔn awem mwǎn á dǐd. Adíi mɛ mpɔm ḿ mwǎn. ");
INSERT INTO bssNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Edəə́dəŋ é mbéb étagte mɔ́. Nzé échə́ŋgé-ʼɛ mɔ́, abɛlé abón esaád, ahún ásē, ánúadé kə́ə́ŋ mehod mébīdē mɔ́ á nsəl. Élédte mɔ́ achene, né émáá mɔ́ yə̌l ached áte. ");
INSERT INTO bssNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mempɛɛ́n mɔ́ wɛ́ɛ ábōŋ bembapɛɛ, ncháŋ bɔ́ mɛɛ́, bébíded mɔ́ edəə́dəŋ é mbéb chê áte, boŋ béehɛlɛɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Dɔ́ɔ Yesuɛ átimtanné aá, “Wáā, nyé bad bêʼ chii, mbɛltéd ḿmɛ̄n méētyéemɛɛ́, nyéewóo-ʼáa adúbe. Chán mápɛɛ́ nyé adyɛɛn boŋ nyêdúbé mɛ? Hyɛɛné awoŋ mwǎn hɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Áde ane mwǎn áhúɛʼɛ́ nɛ̂, edəə́dəŋ é mbéb éched émpií ane mwǎn, ébɔm mɔ́ ásē, ánúadé. Dɔ́ɔ Yesuɛ ákánné échê edəə́dəŋ é mbéb áte, ádīd ane mwǎn bwâm, ábāg-kɛ mɔ́ wɛ́ɛ sáá. ");
INSERT INTO bssNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Menyáké ménkōb moosyəə́l, ânyín ndəle a akan awě Dyǒb ábɛ́lé. Áde bad bélyə́gé bényágɛɛ́ nɛ̂, áyə̄le chǒm éche ébɛ́nlédé, Yesuɛ anláá bembapɛɛ nɛ́n aá, ");
INSERT INTO bssNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nyésôŋgtɛn dyam áde ńhɛdɛɛ́ nyé aláa bwâm. Bɛ́bɛ̌ Mwǎn-a-Moonyoŋ á mekáá mé baányoŋ.” ");
INSERT INTO bssNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Boŋ ábɛ̄ bembapɛɛ béenkênsóŋtɛ́nné chǒm éche ánhɔ̄bpē. Émbɛ̄ nɛ́ɛ ngan echě elɛlé bɔ́ atóge, bébááʼáá-ʼɛ mɔ́ asɛded. ");
INSERT INTO bssNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Bembapɛɛ bêmbootéd aswaŋtɛn tə̂ŋgɛne mod awě atómtɛ́né mod ambáá abɛ́ áwab tîntê. ");
INSERT INTO bssNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesuɛ anchěm bɔ́ mewêmtɛn áte. Antéd mwǎmpīn ḿ mwɛ̌ndem, ápɛ̄ɛ̄n mɔ́ áwe akéb. ");
INSERT INTO bssNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Dɔ́ɔ álâŋgɛɛ́ bɔ́ nɛ́n aá, “Kénzɛ́ɛ́ awě akobé anɛ́n mwǎn á dǐn ádêm, né akobé mɛ. Kénzɛ́ɛ́-ʼɛ awě akobé mɛ, né akobé ane awě alómé mɛ. Né-ɔɔ́, ane awě adé mwǎmpīn áwɛn tîntê, né mɔ́ atómé mod ambáá abɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jɔnɛ anhɔ́b aá, “A-Sáŋ, sênnyín mod abídte bad eʼdəə́dəŋ bé mbéb áte á dǐn ádōŋ, sênláá-ʼɛ mɔ́ bán ásôg abɛl nɛ̂, áyə̄le eésaá ne syánē.” ");
INSERT INTO bssNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Nyéeláŋgé mɔ́ bán ásôg abɛl nɛ̂. Kénzɛ́ɛ́ awě eetə́ŋgán syánē né adé ne syánē.” ");
INSERT INTO bssNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Bɔɔb-pɔɔ́, póndé eche Yesuɛ ántə̄ŋgɛ̄nnē akɛ ádyōb embootéd apɛ. Né-ɔɔ́, ammǎd atíi aá, mɔ́tə̄ŋgɛ̄nē akɛ á Jerusalɛm. ");
INSERT INTO bssNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Hɛ́-ʼaá álómé mésɛ́nzɛ áʼsō. Mênkɛ̌ á mwǎ dyad a Samaria nhɔ́g, âbɛle mɔ́ mboŋsɛ́n. ");
INSERT INTO bssNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Boŋ áde ápédé áwed bad bé dyad bénkênkobpé mɔ́ nken áyə̄le á Jerusalɛm dɔ́ɔ ákágéʼáá. ");
INSERT INTO bssNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Áde bembapɛɛ, Jemsɛ bɔ́ Jɔn bényíné nɛ̂, dɔ́ɔ bésɛ́dté Yesuɛ bánken, “A-Sáŋ, edəə́ wɛɛ́ séchɛ́le muú ádyōb, ńhyɛ ńhyáad bɔ́-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Boŋ Yesuɛ ankuné áwāb, ákānnē bɔ́ áte. ");
INSERT INTO bssNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Hɛ́ɛ bɔ́bɔ̄ɔ békíí á dyad démpēe. ");
INSERT INTO bssNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Áde békagkɛ́ nɛ̂, mod nhɔ́g anláá Yesuɛ aá, “Mɛ̌hīd wɛ kéhéé áde ékagké.” ");
INSERT INTO bssNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Dɔ́ɔ Yesuɛ átimtanné mɔ́ aá, “Eʼbubwóg éʼwóó ábab eʼlóm wɛ́ɛ bésɔ́lɛɛ́, menɔn-nɛ ámpē méwóó ḿmab mǔm, boŋ Mwǎn-a-Moonyoŋ eewóoʼɛ́ hǒm áde ábannɛɛ́ nló.” ");
INSERT INTO bssNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesuɛ anláá mod ampée aá, “Hyǎg, éhíde mɛ.” Boŋ ane mod antimtɛ́n mɔ́ aá, “A-Sáŋ, mwɛ̌, ńsébe ńkɛ ńlíme echem sáŋ.” ");
INSERT INTO bssNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesuɛ anláá mɔ́ aá, “Mwɛ̌ ndim ńlîmme ḿmāb ndim ḿ bad. Boŋ wɛ, éhɛdne bán, ékɛ ékanle bad nkalaŋ mé nkamlɛn ń Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mod ampée anláá Yesuɛ aá, “A Sáŋgú, mɛ̌hīd wɛ, boŋ mwɛ̌, ńsébe ńkɛ ńlyə́gtɛn echem ndáb.” ");
INSERT INTO bssNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Boŋ Yesuɛ anláá mɔ́ aá, “Kénzɛ́ɛ́ awě aboótédé hǒm alíi, boŋ ánɔnéʼ ámbīd, eékwognedɛɛ́ âbɛl nsɔ́n ásē e nkamlɛn ń Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ámbīd e nɛ̂, Sáŋgwɛ́ɛ́ ampwɛ̌d bembapɛɛ bémpēe móom saámbé ne bébɛ. Anlóm bɔ́ áʼsō bébɛ bébɛ dyad tɛ́ɛ́ ne hǒm tɛ́ɛ́ áde ámbīīʼɛ́ aá mɔ́ɔ̄pɛ̌. ");
INSERT INTO bssNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Anláá bɔ́ aá, “Nzag echyáá bwâmbwam, bwěm éʼhɛdnad apád, boŋ bepád béebuuʼɛ́ áte. Né-ɔɔ́, nyékânne nɛ́n bán, nwóó-nzag álôm bepád. ");
INSERT INTO bssNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nyékag-kɔɔ́, boŋ nyébíi bán nlóme nyé nɛ́ɛ ńdyɔŋ ḿ mbód átîntê e ngə. ");
INSERT INTO bssNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nyéewánlé ekwɛ é ngáb á yə̌l, ké ekwɛ empée, káa metámbé. Nyéēbwāg-kɛ mod alɛled á nzii. ");
INSERT INTO bssNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ndáb ké ehéé eche nyɛ́sɔ̄nlē, nyélɛled bɔ́ nɛ́n bán, ‘Nsaŋ ḿbɛ̂ ne nyé.’ ");
INSERT INTO bssNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nzé mod a nsaŋ adé áhed, né ḿmɛ̄n nsaŋ mɛ́bɛ̄ ne mɔ́. Nzé eésɛ̌, né mɛ́timɛ́n nyé běn. ");
INSERT INTO bssNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ndáb ké ehéé eche nyésɔ́lé, nyédyɛ̄ɛ̄ áhed. Nyéēpɛnlád ndáb áte. Nyékob-pɛ kéchéé éche bébagɛɛ́ nyé âdyɛ́ káa âmwɛ́, áyə̄le mod a nsɔ́n atə́ŋgɛ́né nɛ́ɛ ákudɛɛ́ ḿme nsábe. ");
INSERT INTO bssNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Dyad ké ahéé áde nyépédé áte, boŋ békob nyé nken, nyédyɛ̂ kéchéé éche bébágé nyé. ");
INSERT INTO bssNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nyédide bad bé nkole bwâm, nyéláa-ʼɛ bɔ́ nɛ́n bán, ‘Nkamlɛn ń Dyǒb ḿpédé nyé bɛnbɛn.’ ");
INSERT INTO bssNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Boŋ dyad ké ahéé áde béekobɛɛ́ nyé nken, nyékɛ á ntém nzii, nyéhɔ̂b nɛ́n bán, ");
INSERT INTO bssNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ké échɛ́n ebumbú éche émbɛ̄ sé á mekuu, sêkudté nyé chɔ́, boŋ ké nɛ̂ nyébíi bán nkamlɛn ń Dyǒb ńdé bɛnbɛn.’ ");
INSERT INTO bssNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nlâŋge nyé mɛɛ́, á epun é nkáásé, nkɔ́gsɛn ḿme dyad á Sodom dɛ́nyīnnē mɛ́bɛ̄ mwǎmpīn tómaa ḿme bad ábe bédé ádê dyad áte békudté. ");
INSERT INTO bssNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Á-bad bé Korazin, ébɛ̄ɛ̄n nyé ebébtéd! Ébɛ̄ɛ̄n nyémpē ebébtéd á-bad bé Betsaida! Áyə̄le nzé émbɛ̄ bán, ndəle é mekan éche Dyǒb ábɛ́lé áwɛ̄n myad, êmbɛnléd nɛ̂ á dyad á Tirɛ ne dyad á Sidɔn, né bénwāā melebe se etûn, bémwagtéd-tɛ mbúmbú áyə̄l âlúmed nɛ́n bán, béhə́ŋlɛ́né ádab abɛ́ dé mbéb. ");
INSERT INTO bssNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Boŋ mbwɛ mé nkáásé, nkáá ḿme bad bé Tirɛ ne bé Sidɔn mɛ́bɛ̄ mwǎmpīn tómaa ḿmɛ̄n. ");
INSERT INTO bssNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nyé bad bé Kapenahum ámpē, nyêwêmtan bán, nyêmaá apɛ ádyōb, boŋ bɛ́sudéd nyé kə́ŋ se ásē á dǔ-á-muú.” ");
INSERT INTO bssNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Hɛ́ɛ álâŋgɛɛ́ bembapɛɛ nɛ́n aá, “Kénzɛ́ɛ́ awě awógné nyé, né awógné mɛ, boŋ kénzɛ́ɛ́ awě abáá nyé á yə̌l, né abáá kə́ŋne mɛ. Kénzɛ́ɛ́-ʼɛ awě abáá mɛ á yə̌l, né abáá kə́ŋne ane awě alómé mɛ á yə̌l.” ");
INSERT INTO bssNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Áde bembapɛɛ móom saámbé ne bébɛ ábe Yesuɛ ánlōmmē béhúú ámbīd, bénlāā mɔ́ ne menyiŋge mésyə̄ə̄l bán, “A-Sáŋ, kə́ŋne eʼdəə́dəŋ bé mbéb bênsudéd yə̌l áwɛd eʼsó, atúb áde sétúbé wɛ dǐn.” ");
INSERT INTO bssNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Dɔ́ɔ Yesuɛ áhɔ́bɛɛ́ aá, “Nnyíné Satanɛ ahúné ádyōb nɛ̂ŋgáne emwɛdmwɛd. ");
INSERT INTO bssNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mbagé nyé kunze âdyaa nyə̌ bɔ́ɔbɛ bengaabobɛ bé mpwɛn ámīn, ne âtóm ngíne esyəə́l eche Satanɛ áte, Satanɛ ne ane awě akɔɔ́ syánē. Dyamdyam déebɛnlé nyé. ");
INSERT INTO bssNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Boŋ ké nɛ̂ ámpē, menyiŋge ḿme nyéwógɛɛ́ méēbāg nɛ́n bán, áyə̄le eʼdəə́dəŋ éwógné nyé, boŋ pɛn nyéwôg menyiŋge dásɔ̄ nɛ́n bán, mǐn méténlédé nyé ádyōb.” ");
INSERT INTO bssNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ábwɔ̄g-ábwɔ̄g Edəə́dəŋ éche Ésáá énwōgēd mɔ́ menyiŋge bwâmbwam, ahɔ́b aá, “A-Tɛ̂, Sáŋgwɛ́ɛ́ a nkoŋ ń sé ne ḿ mín, nságnɛn ḿbɛ̂ ne wɛ áyə̄le elúmté mpín ḿ běndem mam ḿme ébáŋné bad bé debyɛ́ɛ́ ne bad bé nsôŋtɛn. Ɛɛ, a-Tɛ̂, nɛ̂ děn dɔ́ɔ édə́ə́ wɛɛ́, ébɛnled. ");
INSERT INTO bssNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ńláa nyé mɛɛ́, Echem Sáŋ ebagé mekan mésyə̄ə̄l áwêm mekáá. Mod ké nhɔ́g eékoŋtɛɛ́ mwǎn abíi ésebɛ́ Dyǒb Titɛ́ɛ. Mod ké nhɔ́g-kɛ ámpē eebíiʼɛ́ ngáne Titɛ́ɛ ákóŋté abɛ́ ésebɛ́ mwǎn, ne kénzɛ́ɛ́ awě mwǎn ádə́ə́ aá mɔ́lúmed mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Hɛ́ɛ ákúnné wɛ́ɛ bembapɛɛ, boŋ álāŋgē bɔ́ á kun-tê nɛ́n aá, “Nsimé ne bad ábe bényíneʼ mekan ḿme nyényínɛɛ́ nɛ́n! ");
INSERT INTO bssNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Á mbále nlâŋge nyé nɛ́n mɛɛ́, bekal-bé-eʼdəə́dəŋ híin ne kə̂ŋ é bad híin bênwanɛ́n ânyín mekan ḿme nyényíné ne âwóg mekan ḿme nyéwógé boŋ bénkênyínné, bénkênwóg-kaá.” ");
INSERT INTO bssNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Bɔɔb-pɔɔ́ meléede a mbéndé anhyɛ̌ Yesuɛ akəg áte aá, “A-meléed, cheé mɛ́bɛnlé boŋ ńkūd aloŋgé áde déemaáʼ?” ");
INSERT INTO bssNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesuɛ antimtɛ́n mɔ́ aá, “Chán éténlédé á kálag e mbéndé. Cheé éláá áwēd-te?” ");
INSERT INTO bssNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Meléede a mbéndé ankwɛntɛ́n aá, “ ‘Étə́ŋgɛ́né bán édəŋ Sáŋgwɛ́ɛ́ ádôŋ Dyǒb ne nlém ńsyə̄ə̄l, ne edəə́dəŋ ésyə̄ə̄l, ne ngíne esyəə́l, ne mewêmtɛn mésyə̄ə̄l.’ ‘Édəŋ-ʼɛ mwǎnyoŋ nɛ̂ŋgáne echoŋ yə̌l.’ ” ");
INSERT INTO bssNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesuɛ anláá mɔ́ aá, “Ebíí akwɛntɛn. Nzé ebɛlé áned, né wɛ̌kǔd aloŋgé áde déemaáʼ” ");
INSERT INTO bssNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ngáne ane mod áhɛ́déʼáá aá mɔ́suud yə̌l nzɔm, ansɛdéd aáken, “Nzé béchəgɛɛ́ wɛ̌n nɛ̂?” ");
INSERT INTO bssNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Âtimtɛn mɔ́, Yesuɛ ankǎl ngan aá, “Mod a Israɛl nhɔ́g akagéʼáá ekɛ, ambíd á Jerusalɛm, átimé á Jeriko. Áde ápédé á etûn-tê, bechîb bénkōb mɔ́, békōbɛ̄n mɔ́ chǒm ésyə̄ə̄l éche ánwālɛ̄ɛ̄. Bêmbɔmtéd mɔ́ kə́ə́ŋ áhɛdé awɛ́. Dɔ́ɔ béchénné mɔ́ á nkəg ń nzii. ");
INSERT INTO bssNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Prisɛ pɔ́g chɔ́mpē esyɔ̌gkéʼáá melemlem mé nzii. Dɔ́ɔ átáné ane mod. Ambamé nkəg ń nzii ḿmíníí. ");
INSERT INTO bssNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mod a túmbé e Levi awě abɛléʼáá nsɔ́n á Ndáb-e-Dyǒb awě mɔ́mpē ampɛ̌ áhed, boŋ anyín mɔ́, ambamé melemlem. ");
INSERT INTO bssNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Boŋ mod a Samaria nhɔ́g awe atóméʼáá ene nzii, ampɛ̌ áhed. (Bad bé Samaria bɔ́ɔbɛ bad bé Israɛl béechemtannaá.) Áde ányíné mɔ́, anwóg mɔ́ ngɔl, ");
INSERT INTO bssNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ákɛ̄ áhed, ahɛ́ mɔ́ mɛl á sii-tê, ákaŋ chɔ́, boŋ ápēmē mɔ́ á ésɛl mîn. Apɛɛ́né-ʼaá mɔ́ á dyad-tê, boŋ ásɔ̄nlē mɔ́ á ndáb e beken, ábōŋgē mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nɛ́ɛ bǐn éʼsáŋgé ahúd eʼkə́lé éʼtáan, ábag nwóó ndáb aá, ‘Téd nɛ́n, étɔgnan anɛ́n mod, kéchéé émpēe éche wɛ́bēbēdtē, mɛ̌timtéd wɛ ámbīd á ehúu.’ ” ");
INSERT INTO bssNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Hɛ́ɛ Yesuɛ ásɛdtɛɛ́ ane meléede a mbéndé aáken, “Átîntê e ábɛ̂ bad béláán ábe béntān ane mod awě bechîb bénlɔ̄gɛ̄nnē, ahéé anlúméd aá mɔ́dē waáb?” ");
INSERT INTO bssNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Meléede a mbéndé ankwɛntɛ́n aá, “Ane awě anwóg mɔ́ ngɔl.” Hɛ́ɛ Yesuɛ álâŋgɛɛ́ mɔ́ aá, “Kǎg-kɔ̄, wɛ́mpē ébɛleʼ melemlem.” ");
INSERT INTO bssNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesuɛ ne ábē bembapɛɛ bêmpɛ̌ mwǎ dyad nhɔ́g. Mmwaád nhɔ́g awe béchə́géʼáá bán Mataa ankǒb bɔ́ nken. ");
INSERT INTO bssNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ane mmwaád mwǎnyaŋ abédé dǐn bán Maria. Maria anhyɛ̌ Yesuɛ adyɛɛ á nkəg, âwóg mekan ḿme áyə́gtéʼáá. ");
INSERT INTO bssNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Boŋ Mataa anhágɛ́n áte ne nsɔ́n ń ndáb-te. Dɔ́ɔ áhyédé Yesuɛ aláa aá, “A-Sáŋgú, weenyínɛ́ɛ́ nɛ́n wɛɛ́, awem mwǎnyaŋ atɛ̌dnédé mměmpɛn nsɔ́n ńsyə̄ə̄l-ɛ? Láá mɔ́ wɛɛ́, áhyɛ áwôŋgɛn mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Boŋ Yesuɛ antimtɛ́n mɔ́ aá “Á-Mata, nlém ńtage wɛ áte áyə̄le ekud é mekan. ");
INSERT INTO bssNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Boŋ dyam ádé ahɔ́g áde ákóó etógnɛ́n abɛ́. Maria apwɛdé dɔ́, ádɛ́-ʼɛ bwâm. Meéhɛ̄lɛ̄ɛ̄-ʼaá se ḿbɛl se békōbɛ̄n mɔ́ dɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mbwɛ nhɔ́g Yesuɛ ambɛ́ hǒm, ákânneʼ. Áde ámáá akáne awě mbapɛɛ nhɔ́g anláá mɔ́ aá, “A-Sáŋ, yə́géd sé ngáne békânnɛɛ́ ngáne Jɔnɛ án'yə̄gēdtē ábē bembapɛɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesuɛ anláá bɔ́ aá, “Nzé nyêhɛde akáne, nyéhɔ̂b bán, ‘A-Tɛ̂, edúbé ébɛ̂ ne ádoŋ dǐn. Ḿmoŋ nkamlɛn ńhyɛ ńtêd etə́l. ");
INSERT INTO bssNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Bǎg sé echɛd ndyééd e epun é bǐn mbwɛ tɛ́ɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Lagsɛ́n sé ḿmɛd mbéb, áyə̄le sémpē sêlagsan mod tɛ́ɛ́ awě apǎnné sé, weémwāg se sêhún á mekəgsɛn-tê.’ ” ");
INSERT INTO bssNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Dɔ́ɔ áhɔ́bɛɛ́ aá, “Nzé ewóó wɛ̌n, boŋ ekií áwē melúde wɛɛ́, ‘Amúɛ̄, bál mɛ eʼwɛle éʼláán hɛ̂, ");
INSERT INTO bssNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","sôn, nkúdé nken awě achabé abíd, awem nsón-a-echoŋ apedé áwêm. Meewóo-ʼáa chǒm-ɛ́ɛ ńchágtanné mɔ́.’ ");
INSERT INTO bssNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Boŋ ane wɛ̌n mɔ́-ʼɛ atǐmtɛ́né wɛ á ndáb-te aá, ‘Weétagté mɛ. Mmaá mɛ ekob adib, syáābe ábêm bǎn sêmaá anaa ásē. Méehɛnlé apáde ásē âbɛ wɛ chǒmchǒm.’ ");
INSERT INTO bssNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ńláa nyé á mbále mɛɛ́, saké ké echoŋ éche nyédíí, chɔ́ɔ épād mɔ́ ásē. Boŋ abádnɛn áde wɛ́bādnɛ̄nnē wɛ̌n, dɔ́ɔ dɛ́kə̌ŋ boŋ apádé ásē, ábɛ̄ wɛ kéchéé éche éhɛdɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nlâŋge nyé nɛ́n mɛɛ́, hɛdɛ́n Dyǒb, ǎbɛ̌ wɛ. Hɛ̌d, Dyǒb dɛ́bɛ̌l enyín, kǔm ekob, Dyǒb dɛ́dibnéd wɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Áyə̄le kénzɛ́ɛ́ awě ahɛ̌dné Dyǒb, ǎkǔd, awě ahɛdé-ʼɛ, ǎnyīn. Kénzɛ́ɛ́-ʼɛ awě akumé ekob, Dyǒb dɛ́dibnéd mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nyé besáá bé bǎn, nyé ahéé mwǎn áhɛdɛ́nné súu, boŋ mɔ́-ʼɛ átimé ébagé mɔ́ nyə̌? ");
INSERT INTO bssNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Káa nzé ahɛ̌dné wɛ akii á kúb, boŋ wɛ-ʼɛ étimé ébagé mɔ́ ngabobɛ a mpwɛn? ");
INSERT INTO bssNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nzé eʼbébtéd éʼ bad nɛ́ɛ nyé nyébage ábɛn bǎn kəse é bwěm, tɔ́gtɛ́n-naá echɛn Sáŋ awě adé ámīn? Chán-nɔ̄ éebaá bad Edəə́dəŋ éche Ésáá ábe béhɛ́dné mɔ́ chɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Epun ehɔ́g, Yesuɛ abídtéʼáá mod edəə́dəŋ é mbéb áte éche ênkwǐd ane mod ebóbé. Áde émáá mɔ́ abíd áte, ane mod ambootéd dyam ahɔ́b. Nɛ́n, dénkōbēd ndun e mod echě ebédé áhed menyáké bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Boŋ nguse é bad énhɔ̄b bán “Bɛlzɛbulɛ, kə̂ŋ e eʼdəə́dəŋ bé mbéb mɔ́ɔ abage mɔ́ ngíne âbíded bad eʼdəə́dəŋ bé mbéb áte.” ");
INSERT INTO bssNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bémpēe ábe béhɛ́déʼáá mɔ́ akəg áte bénhɔ̄b bán, álúmed bɔ́ eʼchemléd ábe éʼhúú ádyōb. ");
INSERT INTO bssNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mɔ́-ʼɛ ambíí ḿmāb mewêmtɛn, né-ɔɔ́, anláá bɔ́ aá, “Aloŋ ké ahéé áde ákábné áte, boŋ nchemtɛn méesɛ̌, dɛ́bēb. Abum á ndáb áde nchemtɛ́n-nɛ méesɛ̌, dɔ́mpē dɛ́pāŋtēd áte. ");
INSERT INTO bssNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nzé édé bán, nkamlɛn ḿme Satanɛ ńkábné áte, chán-nɔ̄ mɛ́hɛnlé atyéem? Nhɔ́be nɛ̂ áyə̄le nyêhɔ́bé bán, mbídteʼ bad eʼdəə́dəŋ bé mbéb áte ne ngíne echě Bɛlzɛbulɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nzé ngíne eche Bɛlzɛbulɛ chɔ́ɔ ḿbɛnladté âbíded bad eʼdəə́dəŋ bé mbéb áte, né ngíne eche nzɛ́ɛ́-ʼɔ̄ ábɛ̄n bad ábe bébídte eʼdəə́dəŋ bé mbéb bébɛnladté? Běn bɔ́ɔ bɛ́kwid nyé nkáá. ");
INSERT INTO bssNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Boŋ ngáne édíí nɛ́n bán ngíne e Dyǒb chɔ́ɔ ḿbɛnladté âbíded bad eʼdəə́dəŋ bé mbéb áte, nɛ̂ álûmte nɛ́n bán nkamlɛn ń Dyǒb ḿpédé átîntê echɛ̂n. ");
INSERT INTO bssNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nzé ngíne e mod ebǒŋsɛ́né yə̌l, enɔne ádē dyad, échē chǒm ké ehɔ́g éekagké hǒm. ");
INSERT INTO bssNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Boŋ nzé mod awě atómé mɔ́ ngíne, abúlé mɔ́ áte, abwɔ̌gké-ʼɛ mɔ́, abɛlé ákōbɛ̄n bwěm ábe áwannɛɛ́ nzum, ákabtéd-tɛ bwěm ábe ákóbné mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Né-ɔɔ́, kénzɛ́ɛ́ awě eésɛ̌ ne mɛ, né atə̂ŋgan mɛ. Ane awě eewóŋgán mɛ âlad, apáa páán. ");
INSERT INTO bssNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Nzé edəə́dəŋ é mbéb ébídé mod áte, ébɛlé ébwāgē á ehyáŋge âhɛd abwɔ́g áde ákɔ̂mmɛɛ́ áte. Nzé éekude, ébɛlé éhɔ́b aá, ‘Mɛ̌tǐm ámbīd á ndáb eche mémbīdtē áte.’ ");
INSERT INTO bssNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Apɛ áde épagké-ʼɛ, ébɛlé étán nɛ́ɛ ndáb ésáá áte, bénábpé-ʼɛ chɔ́ áte. ");
INSERT INTO bssNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Hɛ́ɛ ékagké bɔɔb, ékɛ épɛ̄ɛ̄n eʼdəə́dəŋ bé mbéb bémpēe saámbé ábe éʼdé ebébtéd tómaa mwěn, boŋ éʼhyɛ éʼsɔ́l ane mod áte, éʼbwóg-kɛ eʼdii áhed. Ákên eched, ane mod abâg ebébtéd tómaa ngáne ánsēbɛ̄ɛ̄ abɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Bɔɔb-pɔɔ́ áde Yesuɛ áhɔ́bé nɛ̂, mmwaád nhɔ́g átîntê e bad, ankánéd ehɔ́b ámīn aá, “Nnam ḿbɛ̂ ne abum áde áchyáá wɛ, ne abíi áde ámwáŋté wɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesuɛ anhɔ́b aá, “Nnam mɛ́bɛ̄ dásɔ̄ né bad ábe béwógeʼ Eyale é Dyǒb, bébɛlé-ʼɛ ngáne éhɔ́bɛɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Amute á bad dêmbootéd akəl. Hɛ́ɛ Yesuɛ áhɔ́bɛɛ́ nɛ́n aá, “Nyoŋgɛl eʼchii edíi nyoŋgɛl e eʼbébtéd éʼ bad. Béhɛde eʼchemléd bé menyáké anyín, boŋ béekudté, nzése eʼchemléd bé menyáké ábě Jonaa. ");
INSERT INTO bssNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nyaa eche Jonaa ámbɛ̄ɛ̄ nɛ́ɛ eʼchemléd wɛ́ɛ bad bé Ninivɛ, chɔ́ɔ Mwǎn-a-Moonyoŋ ábɛ̄ɛ̄ wɛ́ɛ enɛ́n nyoŋgɛl e bad. ");
INSERT INTO bssNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Á Mbwɛ mé Nkáásé, mmwaád awě akamlánnáá aloŋ á Sɛba, ǎnyemé á soŋ-tê, nchoo ne nyoŋgɛl e bad bé eʼchii. Ǎbīd mbóŋ echě ěkwid bɔ́ nkáá. Bɛ́kwɛ̌ nkáá áyə̄le ambíd se nchabnede wɛ́ɛ nkǒŋsé ńsógé, âhyɛ dɛ́wóglɛn mam mé debyɛ́ɛ́ ḿme Solomonɛ áyə́gtéʼáá. Boŋ chii nɛ́n mod adé hɛ́n awě átómé Solomonɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Á Mbwɛ mé Nkáásé bad bé Ninivɛ bɛ́nyemé á soŋ-tê nchoo ne enɛ́n nyoŋgɛl e bad. Bɛ́bīd mbóŋ echě ěkwīd enɛ́n nyoŋgɛl e bad nkáá, áyə̄le bad bé Ninivɛ bêntɛdé ḿmab mbéb áde Jonaa ânkalɛ́ɛ́ bɔ́ Eyale é Dyǒb. Boŋ chii nɛ́n mod adé hɛ́n awě atómé Jonaa. ");
INSERT INTO bssNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Modmod eémāāʼɛ́ etrúkáŋ achod se ákōō chɔ́ káa akúdtɛ́n chɔ́ á ebwɔg-sɛ́. Boŋ abɛlé ákɛ̄lē chɔ́ dásɔ̄ ámīn, âbɛl boŋ kénzɛ́ɛ́ awě asɔ́le á ndáb, ányínne ekíde. ");
INSERT INTO bssNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Dǐd dɔ́ɔ ádé ngáne etrúkáŋ é yə̌l e mod. Nzé dǐd ákɛ́nlé wɛ áte, echoŋ yə̌l esyəə́l chɔ́mpē ebɛlé ekɛ́lé. Boŋ nzé déēkɛ̂nle, yə̌l chɔ́mpē ebɛlé elón wɛ ne ehíntɛ́n. ");
INSERT INTO bssNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Né-ɔɔ́, nyêtóo, âbɛl chǒm éche ényînte nyé ekíde, éetimé abɛ́ chǒm éche étimteʼ nyé á ehíntɛ́n-tê. ");
INSERT INTO bssNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nzé édé bán echoŋ yə̌l esyəə́l elóné ne eʼnyínɛn bé ekíde, ésebán ehíntɛ́n édé abwɔ́g ké ahɔ́g, né yə̌l ěmwaá áte, melemlem ngáne etrúkáŋ épɛntɛɛ́ ekíde.” ");
INSERT INTO bssNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Á póndé eche Yesuɛ áhɔ́bɛɛ́ nɛ̂, Farisia nhɔ́g, anchɛ́lé mɔ́ aá, áhyɛ búmɔ̄ bédyɛ̂ ndyééd áwe ndáb. ");
INSERT INTO bssNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Né-ɔɔ́ ankɛ̌, asɔ́l á ndáb-te, búmɔ̄ bédyɛ̄ɛ̄ á tébelɛ. Ane Farisia ambɛ́ menyáké ânyín bán Yesuɛ eéwopɛɛ́ mekáá ngáne éhɛ́dnádtáá, boŋ ábootéd ndyééd adyɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Dɔ́ɔ Sáŋgwɛ́ɛ́ álâŋgɛɛ́ mɔ́ aá, “Nɔnéʼ, nyé Befarisia, nyêwobpe mbwendé ne dǐsɛ ámbīd e ebwɔ́g, boŋ adum á bwěm ne ebébtéd bɔ́ɔ bélóné áwɛn nlém-tê. ");
INSERT INTO bssNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Eʼdimdim éʼ bad ngɛ̂n! Mod awě ahəgé ámbīd e ebwɔ́g, saá mɔ́ ahəgé kə́ə́ŋne áte-yɛ? ");
INSERT INTO bssNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Boŋ nyétêd bwěm ábe éʼdé áwēd-te, nyébageʼ betóótōkɛ̄ bé bad. Né chǒm ésyə̄ə̄l áyə̄l echɛ̂n ésāŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Medim ne nyé, Befarisia! Nyêtéde ké meseb ne nduu ne byaá ábíníí éʼsyə̄ə̄l bémpēe, nyêbage Dyǒb doŋge nhɔ́g átîntê e moŋge dyôm. Boŋ nyéēhɛ̄dɛ̄ɛ̄ eʼboŋ bé nlém ne edəŋge é Dyǒb alúmed. Nyêntə́ŋgɛ́né ḿmɛ́n mésyə̄ə̄l abɛl, ésebán nyêchɔbteʼ ḿmíníí. ");
INSERT INTO bssNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Medim ne nyé Befarisia! Nyêdəə metii mémbáá adyɛɛ á ndáb é mekáne, nyêdəə-ʼɛ melɛntɛn mé edúbé akud á dyɔn-tê. ");
INSERT INTO bssNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Medim ne nyé! Nyêdíi nɛ́ɛ soŋ éche ésɔ́ɔ́mé, éche bad bétómɛɛ́ ámīn, ésebán bébíí.” ");
INSERT INTO bssNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Dɔ́ɔ meléede a mbéndé nhɔ́g álâŋgɛɛ́ mɔ́ aá, “A-meléed, nzé ehɔ́be nɛ̂ nɛ́dē né esyə́əʼ sémpē.” ");
INSERT INTO bssNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesuɛ ankwɛntɛ́n mɔ́ aá, “Medim ne nyémpē bemeléede bé mbéndé! Nyêpêmtad bad nted ḿme ńlɛ́lé apém, boŋ nyéběn nyéebanɛ́ɛ́ ké ekáá âpémed bɔ́ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Medim ne nyé! Áyə̄le nɛ́n, bekal béʼdəə́dəŋ ábe besóó bénwūūʼɛ́, nyêlóŋgé bɔ́ soŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Né-ɔɔ́ nyêbídeʼ mbóŋ, nyêlûmte-ʼɛ bán, besóó bêmbɛl bwâm ngáne bénwūūʼɛ́ bekal béʼdəə́dəŋ. Nyé-ʼaá nyêlóŋgé bɔ́ soŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Áyə̄le nɛ̂, Dyǒb ne ádē debyɛ́ɛ́ anhɔ́b nɛ́n aá, ‘Mɛ̌lōmē bɔ́ ábêm bekal béʼdəə́dəŋ ne bembapɛɛ bé nlómag, bɛ́wūū behɔ́g, béhəgké-ʼɛ ábíníí.’ ");
INSERT INTO bssNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Né-ɔɔ́, enɛ́n nyoŋgɛl e bad chɔ́ɔ ěkǔd nkɔ́gsɛn áyə̄le bekal béʼdəə́dəŋ bésyə̄ə̄l ábe ḿmāb mekií mésyɔ́gké se á mbooted mé nkǒŋsé, ");
INSERT INTO bssNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","mbooted ne mekií ḿme Abɛlɛ átiméʼ wɛ́ɛ Sakaria, awě bénwūūʼɛ́ átîntê e menyán mé mendɛ ne hǒm áde ásáá. Á mbále, enɛ́n nyoŋgɛl e bad ěkǔd nkɔ́gsɛn áyə̄le ḿmê mekan mésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Medim ne nyé bemeléede bé mbéndé! Nyêkáá eʼkii bé ekob é debyɛ́ɛ́. Nyéběn nyéesaá asɔ́l, nyêkə́ə-ʼɛ bad bémpēe ábe béhɛde asɔ́l.” ");
INSERT INTO bssNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Áde Yesuɛ ásyəŋgɛɛ́ áhed âkɛ, bemeléede bé mbéndé ne Befarisia bêmbootéd mɔ́ ahɔ́b bwâmbwam, bésɛdté-ʼɛ ekud e mekan. ");
INSERT INTO bssNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Bébɛ́léʼáá ḿmɛ́n mésyə̄ə̄l âhíined mɔ́ melám âbɛl békóbɛn mɔ́ awusé. ");
INSERT INTO bssNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ámbīd e póndé ndun e mod enladɛ́n áte, kə́ə́ŋ etə́l éebédɛɛ́. Dɔ́ɔ Yesuɛ ábóótédé bɔ́ akalɛn, mbooted ne bembapɛɛ álāŋgē bɔ́ nɛ́n aá, “Nyétêd póndé ne elaŋgé éche Befarisia, édé nɛ̂ŋgáne esultɛn. ");
INSERT INTO bssNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Dyamdyam déesaá á eʼkoŋnéd-te áde déebíd áwed. Ké ahɔ́g-kɛ déesaá, áde ásɔ́ɔ́mé boŋ bán déebyɛ́ɛ́nné. ");
INSERT INTO bssNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Dyam ké áhéé-ʼɛ áde nyéhɔ́bé á ehíntɛ́n-tê, dɛ́wōgnēd á eʼnyínɛn bé ekíde. Dyam áde nyékálé-ʼaá á kun-tê ámbīd e ekob, dɛ́kanléd á nhɛ́né. ");
INSERT INTO bssNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Amúɛ̄, á mbále, nyéewógé mbwɔ́g ne moonyoŋ awě ahɛle awúu ekob é yə̌l ésebán ahɛle dyam démpēe abɛl. Awǎb eetómɛɛ́ nɛ̂. ");
INSERT INTO bssNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ńláa nyé mɛɛ́, mod awe nyétə́ŋgɛ́né abáŋ, adíī ane awě nɛ́ɛ ámáá wɛ pemɛ e aloŋgé akobɛn, awóŋ-ʼɛ ngíne echě ábwémɛɛ́ wɛ á dǔ-á-muú. Ne mbále ane mɔ́ɔ nyétə́ŋgɛ́né abáŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Éesaá mbále nɛ́n bán, kábpe ébɛ ngɛ̂n, chɔ́ɔ béchannɛɛ́ ndun étáan-nɛ? Boŋ ké nɛ̂ Dyǒb déechatánné ké pɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Dyǒb ábíí kə́ə́ŋne mesoŋgé mé eʼsid ábe éʼdé nyé á nló. Né-ɔɔ́, nyéewógé mbwɔ́g, nyêdé etógnɛ́n tómaa ndun, ké êmbuú ké áte. ");
INSERT INTO bssNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Á mbále, kénzɛ́ɛ́ awě ǎbīd mɛ mbóŋ áʼsō éʼ baányoŋ, Mwǎn-a-Moonyoŋ mɔ́mpē ǎbīd mɔ́ mbóŋ áʼsō éʼ ángɛl é Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Boŋ mod awě abáá mɛ áyə̄l áʼsō éʼ baányoŋ, mɛ-ʼɛ mɛ̌bāŋ mɔ́ áyə̄l áʼsō éʼ ángɛl é Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kénzɛ́ɛ́-ʼɛ awě ahɔ́bé eyale é mbéb tə̂ŋgɛne Mwǎn-a-Moonyoŋ, ǎkūd alagsɛn, boŋ kénzɛ́ɛ́ awě ahɔ́bé eʼbébtéd éʼ mekan tə̂ŋgɛne Edəə́dəŋ éche Ésáá éekudté alagsɛn. ");
INSERT INTO bssNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nzé édé bán bésɔ́mné nyé wɛ́ɛ belyə́ged bé dyad ne benkamlɛnɛ, nyéētāgē áte, ngáne nyɛ́kāāʼɛ́ káa dyam áde nyɛ́hɔ̄bpē, ");
INSERT INTO bssNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","áyə̄le nzé póndé epedé, Edəə́dəŋ éche Ésáá éyə̄gēd nyé chǒm éche nyétə́ŋgɛ́né ahɔ́b.” ");
INSERT INTO bssNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Átîntê e ene ndun e mod, nhɔ́g anláá Yesuɛ aá, “A-meléed, láá mwǎnned wɛɛ́ ákabe súmɔ̄ mbwɔ́g áte.” ");
INSERT INTO bssNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Boŋ Yesuɛ antimtɛ́n mɔ́ nɛ́n aá, “Nzɛ́-módɛ́ abǎnné mɛ nɛ́ɛ mod awě akáadteʼ bad, âkabe nyé mbwɔ́g áte?” ");
INSERT INTO bssNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Dɔ́ɔ álâŋgɛɛ́ bɔ́ moosyəə́l aá, “Nyêtóo, nyéēbanné nlém áyə̄le awóŋ á bwěm, áyə̄le saké nhɔn mɔ́ɔ̄ ńdide moonyoŋ á aloŋgé.” ");
INSERT INTO bssNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ankalé-ʼɛ bɔ́ ngan aá, “Nhɔn ḿ mod nhɔ́g mémbɛ̄. Anwóŋ nzag. Áde ene nzag échyáá, embídéd medyɛ́ nkute ne nkute. ");
INSERT INTO bssNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nhɔn ḿ mod mê ménhɔb áwe nlém tê aá, ‘Chán mɛ́bɛnlé bɔɔb áde etə́l éelyəgɛɛ́ wɛ́ɛ ńkoŋgɛɛ́ medyɛ́?’ ");
INSERT INTO bssNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Dɔ́ɔ ádólé áte chóóŋ boŋ áhɔ̄bē aá, ‘Nɛ́n dɔ́ɔ mɛ́bɛnlé. Mɛ̌pāŋ échem ndáb é eʼkoŋnéd, nlóŋ émpēe éche ékə́lé áte, boŋ nkúm medyɛ́ áwēd-te, ne nhɔn ḿmêm ńsyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Á póndé eched-taá mɛ́lāāʼɛ́ échêm edəə́dəŋ mɛɛ́, nlǎdté yə̌l nhɔn ḿme mɛ́dyɛɛ́ mwɛ́ ne mwɛ́. Bɔɔb-pɔɔ́ mɛ̌ched yə̌l, ńdyâg, ḿmwâg, ńchogé-ʼɛ aloŋgé.’ ");
INSERT INTO bssNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Boŋ Dyǒb dénlāā mɔ́ nɛ́n, aá ‘Edimdim é chǒm chɛ́n. Nkuu nɛ́n děn mɛ̌kobɛ́n wɛ pemɛ e aloŋgé. Ábê bwěm éʼsyə̄ə̄l ábe émáá-ʼaá alad áte, nzɛ́-módɛ́ wɛ́lyə̄gnēdtē bɔ́?’ ");
INSERT INTO bssNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nɛ̂ dɔ́ɔ édíí ne ké nzɛ́-módɛ́ awě akúmmé yə̌l nhɔn, boŋ eésɛ̄ nhɔn áʼsō éʼ Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ ábē bembapɛɛ nɛ́n aá, “Né-ɔɔ́ nyéētāgē áte á aloŋgé se nyéhɔ̄bē nɛ́n bán cheé nyɛ́dyɛ̄ɛ̄, kéʼɛ cheé nyéwāāʼɛ̄ á yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Aloŋgé átómé ndyééd, échɛn yə̌l-lɛ ámpē edé etógnɛ́n tómaa mbɔ́té. ");
INSERT INTO bssNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nyénɔneʼ, nkɔnékɔn. Méēwēnɛ̄ɛ̄ bwěm, méēpādɛ̄ɛ̄, méēwóo-ʼáa hǒm áde békoŋgɛɛ́ medyɛ́. Kénɛ̂, Dyǒb adídte mɔ́! Nyéebíiʼɛ́ bán nyêdé etógnɛ́n bwâmbwam tómaa menɔn-ɛ? ");
INSERT INTO bssNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nzɛ́-módɛ́ áwɛn tîntê ahɛle átāg áte kə́ə́ŋ, abád ké epun ehɔ́g áwē aloŋgé áyə̄le átagɛɛ́ áte? ");
INSERT INTO bssNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nɛ́ɛ nyé modmod nyéehɛlɛ́ɛ́ mpín mé akan nɛ́ɛ ḿmê abɛl, cheé ékə́ə́ boŋ nyétagé áte áyə̄le mam ḿme mélyə́gé ásē? ");
INSERT INTO bssNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Nyénɔneʼ mbonja ngáne ékwogɛɛ́. Éebɛlɛ́ɛ́ ntǔ, éebaŋgɛ́ɛ́ mesaŋ. Nlâŋge nyé nɛ́n mɛɛ́, ké kə̂ŋ Solomonɛ ne ḿmē nhɔn ńsyə̄ə̄l eewáaʼaá mbɔ́té éche épédé échɛ́n mbonja ké pɔ́g eʼboŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nzé Dyǒb áhɛlɛsɛ áwāādtē eʼsum ábě éʼbâg chii boŋ chǎn béhɛ́ bɔ́ á dǔ, né éetómmé nyé awáad né-yɛ? Chán adúbe ádíí nyé mwǎmpīn nɛ́n? ");
INSERT INTO bssNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Nyéēbanné nlém bán, cheé nyédyɛ̄ɛ̄ káa cheé nyémwɛ̄ɛ̄. Nɛ̂ déetagté nyé. ");
INSERT INTO bssNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Échê nyaa é bwěm chɔ́ɔ bad bé nkǒŋsé béchyɛɛʼɛ́ akud. Awɛ̂n Titɛ́ɛ mwěn abíí aá nyêtógnɛ́né ábɛ́n bwěm. ");
INSERT INTO bssNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Né-ɔɔ́, nyésébe nyéhɛd mam mé nkamlɛn ń Dyǒb, dɔ́ɔ Dyǒb dɛ́bɛɛ́ nyé ábíníí bwěm. ");
INSERT INTO bssNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“A-bǎnbān, nyéewógé mbwɔg. Echɛn Sáŋ awóó mewêmtɛn ḿme mésáá âbɛ nyé ngíne e nkamlɛn. ");
INSERT INTO bssNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nyésôm ábɛn bwěm, nyébag betóótōkɛ̄ bé bad mɔné. Nyéhɛd ekwɛ é ngáb éche éehɛlé amaa ásē. Nyéhɛ̂ nhɔn ḿmɛ̄n á eʼkoŋnéd ábe éʼdé ádyōb, wɛ́ɛ dyamdyam déebɛnlé mɔ́, wɛ́ɛ bechîb béehɛnlé mɔ́ achíb, síi-ʼɛ éehɛnlé mɔ́ adyɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nyêbíí bán wɛ́ɛ nhɔn ḿbágkē mod, áhed dɔ́ɔ nlém-mɛ ḿbágkē mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Nyépûd abad, nyéchod-tɛ etrúkáŋ, ");
INSERT INTO bssNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","nɛ̂ŋgáne bad ábe bésineʼ echab sáŋ awě akií á ngande e eʼwóŋgé âbɛl boŋ nzé ahúú húɛ́n, boŋ akumé ekob, bénednéd mɔ́ ábwɔ̄g-ábwɔ̄g. ");
INSERT INTO bssNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Eʼboŋ éʼ yə̌l áte ne bembəledɛ ábe echab sáŋ épɛɛ́, boŋ atán ngáne bédyɛ́ɛ́ epin, bésinɛɛ́ mɔ́. Á mbále ǎboŋsɛ́n, ádīd bɔ́ ásē, atómtéd-tɛ bɔ́ ndyééd. ");
INSERT INTO bssNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ké melúde dɔ́ɔ âmpɛɛ́, káa epɔg é mbwɛmbwɛ, boŋ atán bɔ́ melemlem, eʼboŋ éʼ yə̌l áte bɛ́lyə̄g éʼtán bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nyébíi-ʼɛ bán, nzé nwóó-ndáb abyɛ́ɛ́ʼáá póndé eche nchîb ápɛɛ́, né ǎdyɛɛ́ epin, ésebán atɛdte aá, bésal mɔ́ ndáb. ");
INSERT INTO bssNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nyémpē nyêtə́ŋgɛ́né mboŋsɛ́n abɛ́, áyə̄le Mwǎn-a-Moonyoŋ ǎpɛ̌ á póndé eche nyéēwêmtɛnɛɛ́ bán ǎpɛ̌.” ");
INSERT INTO bssNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petro ansɛdéd aáken, “A-Sáŋ, sé běn pɛn-ɛɛ́ ékanlɛɛ́ enɛ́n ngan-ɛ, káa bad bésyə̄ə̄l?” ");
INSERT INTO bssNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Sáŋgwɛ́ɛ́ ankwɛntɛ́n aá, “Né-ɔɔ́, nyé mod tɛ́ ábɛ̂ nɛ́ɛ mbəledɛ awě awóó debyɛ́ɛ́, awě abɛle-ʼɛ mam ḿme eche sáŋ áláŋgé mɔ́ aá ábɛl. Mɔ́ adé mbəledɛ awě eche sáŋ ábánné aá ákamlɛn bembəledɛ ábíníí, ányîn-nɛ nɛ́n aá békúdé ádāb akab á ndyééd póndé echě etə́ŋgɛ́né. ");
INSERT INTO bssNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nnam mɛ́bɛ̄ ne ane mbəledɛ awě eche sáŋ áhūūʼɛ́, boŋ atán nɛ̂ŋgáne ábɛlɛɛ́ mam ḿme ánlyə̄gtɛ̄nnē mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, ane mbəledɛ eche sáŋ ǎbané bwěm éʼsyə̄ə̄l ábe áwóó áwe mekáá aá ákamlan. ");
INSERT INTO bssNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Boŋ nzé ane mbəledɛ adé mbəledɛ a mbéb, boŋ ahɔ́bé áwe nlém-tê aá, ‘Éběm áte boŋ echem sáŋ ǎhūu á ekɛ-tɛ̂.’ Né-ɔɔ́ aboótédé ábíníí bembəledɛ bé bebaád ne bé baachóm ábe bédé ásē echê awanɛn, ádyâg bwěm, ámwāg-kɛ mǐm mékóbe mɔ́, ");
INSERT INTO bssNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ane mbəledɛ eche sáŋ ǎhūu epun éche éēwêmtɛnɛɛ́ ne á póndé echě énkêmbííʼɛ́ aá ǎhūu. Né bɛ́bwēm mɔ́ á ebwɔ́g, békɔ́gsɛ́n-nɛ mɔ́ ne nhel melemlem ne bad ábe béwúú nló áte. ");
INSERT INTO bssNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ane mbəledɛ awě abíí ntíi mé nsɔ́n ḿme sáá-a-ndáb, boŋ eéboŋsɛne, káa eehíde ḿmê ntíi ámbīd, ǎkud mbɛ́te e ngíne. ");
INSERT INTO bssNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Boŋ ane awě enkêmbíí ntíi, boŋ ábɛlé epandé, bɛ́kūdē mɔ́ kúdtɛ́n. Mod ké ahéé awě bébúdé abɛ, né-ʼaá bɛ́budté mɔ́ ahɛdɛn. Ane-ʼɛ awe bétómtɛ́né abud dé abɛ, né-ʼaá bɛ́tōmɛ̄nnē mɔ́ abud dé ahɛdɛn. ");
INSERT INTO bssNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Muú mɔ́ɔ ńhyédé akwɛ́d á nkǒŋsé. Mendə̌ŋ-ʼɛ mɛɛ́, né mêmmad akóbɛn. ");
INSERT INTO bssNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Boŋ ntə́ŋgɛ́né nsébé ńkud edusɛn é metuné, mɛ̌mǎd-tɛ chɔ́ akud boŋ nlém mɛ́pwiitéd mɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nyêwêmtan bán, nsaŋ mɔ́ɔ̄ ńhyédé apɛɛn á nkǒŋsé-yɛ? Aáy, saké nsaŋ, nkabɛ́n mɔ́ɔ̄ ḿpɛ́ɛ́né. ");
INSERT INTO bssNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Bootya bɔɔb âkɛ áʼsō, ndáb echě ewóó bad bétáan ěkabɛ́n áte, béláán bétə́ŋgɛ́n bébɛ, bébɛ-ʼɛ bétə́ŋgɛ́n béláán. ");
INSERT INTO bssNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Kɔkɔɔ ěbɛ̄. Sáá ǎtə̄ŋgɛ̄n mwǎn a mwɛnchóm, mwǎn a mwɛnchóm ǎtə̄ŋgɛ̄n sáá. Nyaá ǎtə̄ŋgɛ̄n mwǎn a mmwaád, mwǎn a mmwaád ǎtə̄ŋgɛ̄n nyaá. Nyǎŋkə́lé ǎtə̄ŋgɛ̄n mwǎn a mmwaád, mod mwǎn a mmwaád ǎtə̄ŋgɛ̄n nyǎŋkə́lé.” ");
INSERT INTO bssNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesuɛ anláá amute aá, “Nzé nyênyíné mbag ébíde á mbəŋ, nyêbɛlé nyêhɔ́b bán, ‘Mbúú ěchə̄ bɔɔb’, ébɛnléd-tɛ áned. ");
INSERT INTO bssNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nyênyíne-ʼáa epub éhúɛʼ á pɛd e mbəŋ, nyéhɔ̄bēʼ bán, ‘Enyɛn ébɛ̄nēd mod bɔɔb,’ ébɛ́-ʼɛ áned. ");
INSERT INTO bssNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Á-bad bé elaŋgé. Nɛ́ɛ nyépédé abíi ngáne béláaʼɛ́ bǐn nɛ́n, cheé ékə́ə́ boŋ nyéēhɛ̄lē mam ḿme mébɛnlad nyé áʼsō-te chii nɛ́n achem? ");
INSERT INTO bssNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Cheé ékə́ə́ boŋ nyéběn nyéēhɛ̄lē adol áte nɛ́n bán, kəse e akan nɛ́n echě ehɛdnad abɛl? ");
INSERT INTO bssNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nzé mod ahɔ́bé aá, mɔ́kɛɛne wɛ á kóte, hɛ̌d nzii kə́ə́ŋ nyúmɔ̄ bétim ásē á nzii. Ésebɛ́ nɛ̂, nzé ahédé wɛ á kóte, kóte chɔ́-ʼɛ ěbɛɛ́ wɛ á mekáá mé plûsɛ, plûsɛ chɔ́-ʼɛ éhɛ̄ wɛ á mbwɔg. ");
INSERT INTO bssNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Á mbále, nlâŋge wɛ mɛɛ́, weéhɛ̄lɛ̄ɛ̄-sɛ ebíd á ndáb e mbwɔg-tê wɛ̂ kə́ə́ŋ né etwedé ádōŋ alúm ásyə̄ə̄l.” ");
INSERT INTO bssNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Áde Yesuɛ ádíi áhɔ́bɛɛ́ nɛ̂, dɔ́ɔ nguse é bad éche émbɛ̄ áhed élâŋgɛɛ́ mɔ́ ngáne Payledɛ ánwūūʼɛ́ bad bé Galilia áde bébágéʼáá Dyǒb mendɛ mé eʼlém. ");
INSERT INTO bssNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesuɛ antimtɛ́n bɔ́ aá, “Nɛ́dē mewêmtɛn médé nyé bán, ábê bad bé Galilia ábe bênkǔd échê ebɛn, bétómé ábíníí bésyə̄ə̄l ebébtéd abɛ́ áyə̄le bénwɛ̄ɛ̄ ene ndín e kwééd-ɛ? ");
INSERT INTO bssNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aáy! Á mbále, nzé nyéētɛdte ḿmɛn mbéb se nyétīmɛ̄n Dyǒb, né nyé moosyəə́l nyɛ́ɛ̄wɛ́, nyêbɔ́ɔ́-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Chán-náa ábíníí dyôm á mod ne waam ábe ntóŋ-ntóŋ ń ndáb ménkūmtēdtē ámīn á dyad é Silom, boŋ béwɛ́? Nɛ́dē mewêmtɛn médé nyé bán, béntōmtɛ̄n ebébtéd abɛ́ tómaa bad bésyə̄ə̄l ábe bénlōŋ á Jerusalɛm-ɛ? ");
INSERT INTO bssNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aáy! Á mbále, nzé nyéētɛdte ḿmɛn mbéb se nyétīmɛ̄n Dyǒb, né nyé moosyəə́l nyɛ́ɛ̄wɛ̄, nyêbɔ́ɔ́-ʼɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Hɛ́ɛ Yesuɛ ákálé ngan aá, “Mod anwóŋ alín á bwɛl á nzag-tê. Ankɛ̌ epum é bwɛl ahɛd áwedé-mîn ngen ne ngen, boŋ enkênnyínné ké ehɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Hɛ́ɛ álâŋgɛɛ́ nnɔn-a-nzag aá, ‘Édé bɔɔb mwɛ̌ ńláán áde ḿpagké á bwɛl-sɛ́ hɛ́n mwɛ̌ tɛ́ɛ́, boŋ meenyínɛ́ɛ́ epum ké ehɔ́g. Kwɛl bɔ́. Chán éʼhɛle éʼmadé ahóŋ á ndɔɔb-tê ngɛ̂n?’ ");
INSERT INTO bssNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Hɛ́ɛ nnɔn-a-nzag átimtanné mɔ́ aá ‘A-sáŋ, tɛdé bɔ́ ké mwɛ̌ nhɔ́g ámpē. Mɛ̌nabé bɔ́ ásē, nhíí-ʼɛ bɔ́ nkúmbág. ");
INSERT INTO bssNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nzé éʼchyáá eʼpum mwɛ̌ ḿme ńhúɛʼ, né édé bwâm. Nzé-ʼɛ béechyáa, né bɛ́kwɛ̌l bɔ́.’ ” ");
INSERT INTO bssNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mbwɛ-mé-nkɔ́me-áte nhɔ́g, Yesuɛ ayə́gtéʼáá bad á ndáb e mekáne pɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mmwaád ambɛ́ áhed awě edəə́dəŋ é mbéb émbɛ̄ɛ̄ áte á etûn é dyôm á mwɛ̌ ne waam. Êmbɛ̌l mbíd enwúmɛ́n mɔ́ nyaa echě éehɛlaá yə̌l asále áte bwâm. ");
INSERT INTO bssNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Áde Yesuɛ ányíné mɔ́, anchɛ́lé mɔ́, aláá mɔ́ aá, “Á-nyaŋ, nkole ḿme ékonlɛɛ́ ḿmáá.” ");
INSERT INTO bssNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Áde ábáné mɔ́ mekáá á nló, ane mmwaád ansálé yə̌l áte ábwɔ̄g-ábwɔ̄g, ábootéd-tɛ Dyǒb akɛn. ");
INSERT INTO bssNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Hɛ́ɛ mod awě abédé nló á ndáb e mekáne, álíí áyə̄le adid áde Yesuɛ ádídé ane mmwaád bwâm á mbwɛ-mé-nkɔ́me-áte. Álāŋgē bad aá, “Eʼpun éʼdé ntóób ábe mod átə́ŋgɛ́né nsɔ́n abɛl. Nzé nyêdəə́ bwâm adyɛɛ nyépɛ̄ ábê eʼpun, saké á mbwɛ-mé-nkɔ́me-áte.” ");
INSERT INTO bssNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Hɛ́ɛ Sáŋgwɛ́ɛ́ ákwɛntanné aá, “Nyêdoge bad. Nyé ahéé eéhunné nyag káa ésɛl á ebem-tê se ákɛ̄ɛ̄n chɔ́ á edíb á mbwɛ-mé-nkɔ́me-áte? ");
INSERT INTO bssNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Anɛ́n mmwaád adíī mwǎn awe Abrahamɛ. Satanɛ anhaŋ mɔ́ ne nkole á etûn é dyôm á mwɛ̌ ne waam. Nyéláa mɛ ké mbéb mɔ́ɔ ńdé, âhúd mɔ́ á mehaŋgé á mbwɛ-mé-nkɔ́me-áte?” ");
INSERT INTO bssNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Chǒm éche ánhɔ̄bpē énwōgēd bad ábe bétə́ŋgánnáá mɔ́ eʼsôn. Moosyəə́l anwóg menyiŋge áyə̄le mam mé ményáké ḿme Yesuɛ âmbɛnlé. ");
INSERT INTO bssNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesuɛ anhɔ́b aá, “Chán nkamlɛn ń Dyǒb ńkóó abɛ́? Cheé ńhɛle ńhəgtɛ́n mɔ́-yēē? ");
INSERT INTO bssNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ńdíi nɛ̂ŋgáne mbwɛ́ e mbə́l-e-bǔ echě mod átédé boŋ ásob á nzag-tê. Áde ékwógé, étīm bwɛl běn, menɔn mɛ́hyɛ̌ mélōŋ á ngɛn-tê.” ");
INSERT INTO bssNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesuɛ ansɛdéd aáken, “Cheé ńhɛle ńhəgtɛ́n nkamlɛn ń Dyǒb-é? ");
INSERT INTO bssNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ńdíi nɛ̂ŋgáne esultɛn éche mmwaád ámúúnédé asii á pân é mbumé ń ngun éláán kə́ə́ŋ ésule.” ");
INSERT INTO bssNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesuɛ andíi ambɛ́ á ekɛ-tê éche ákágéʼáá á Jerusalɛm. Dyad tɛ́ɛ́ áde átóméʼáá, ámbáá ne ásad, ayə́gtéʼáá bad. ");
INSERT INTO bssNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mod nhɔ́g ansɛdéd mɔ́ aáken, “A-Sáŋgú, mesoŋgé mé bad ḿme Dyǒb dɛ́soŋgé aloŋgé, mɛ́buú áte káa méebuúʼɛ́?” Yesuɛ anláá bad áhed aá, ");
INSERT INTO bssNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nyéwanɛn kə́ə́ŋ nyésɔ̂l á ekob éche échíné áte, áyə̄le, á mbále, ekud á bad éwanɛ́n asɔ́l, boŋ béehɛnlé. ");
INSERT INTO bssNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Póndé ěpɛ̌ echě nwóó-ndáb áhidɛ́ɛ́ ásē, boŋ ápēn ekob. Ene póndé dɔ́ɔ nyɛ́bootédté atyéem á ebwɔ́g, boŋ nyékuméʼ ekob nyéhɔ̄bē bán, ‘A-Sáŋ, dibnéd sé ekob.’ Mɔ́-ʼɛ ǎtimtɛ́n nyé aá, ‘Meebíiʼɛ́ wɛ́ɛ nyébídé.’ ");
INSERT INTO bssNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nyé-ʼɛ nyɛ́ɛ̄hɔ̄b bán, ‘Syánē dendyɛ́ ndyééd, demmwɛ́-ʼɛ mǐm hǒm ahɔ́g, eyə́gtéʼáá-ʼɛ áwɛ̄d myad.’ ");
INSERT INTO bssNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ǎtimtɛ́n nyé aá, ‘Syánē deewôŋnɛɛ́ dyamdyam. Nyésyəə mɛ á dǐd-te. Eʼbébtéd éʼ bad ngɛ̂n!’ ");
INSERT INTO bssNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Áde nyɛ́nyīnnē Abrahamɛ, Aisigɛ ne Jakɔbɛ bɔ́ɔbɛ bekal béʼdəə́dəŋ bédé á nkamlɛn ń Dyǒb-te, boŋ nyé pɛn nyêchág á ebwɔ́g, achii dé awɛ́ ne adyɛ́ dé mesoŋ á nsəl, dɔ́ɔ dɛ́tēd etə́l póndé eched. ");
INSERT INTO bssNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bad bɛ́bīd á akuu ne á mbəŋ, á mekonekone ne á mehúléhúlé, bétéd medii á ngande e nkamlɛn ń Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Á póndé eched, bad ábe bênlyəg mbíd bɔ́ɔ bɛ́tǐm áʼsō, béʼsō-ʼɛ bɛ́lyəg mbíd.” ");
INSERT INTO bssNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Melemlem mé póndé nguse é Befarisia êmpɛ̌ wɛ́ɛ Yesuɛ, bélāŋgē mɔ́ bán, “Syəə́ hɛ́n, ékag hǒm démpēe, áyə̄le kə̂ŋ Hɛrɔdɛ ahɛde wɛ awúu.” ");
INSERT INTO bssNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesuɛ ankwɛntɛ́n bɔ́ aá, “Nyékɛ nyéláa échê esɔb bán, ‘Chii ne chǎn mɛ̌hūd bad eʼdəə́dəŋ bé mbéb áte, ńchōōd-tɛ bad, boŋ súú ébɛ mɛ̌mǎd ḿmêm nsɔ́n.’ ");
INSERT INTO bssNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Boŋ ké chán ébɛ̄ɛ̄, ntə́ŋgɛ́né abɛ́ á nzii chii, chǎn, ne sú ébɛ, áyə̄le éebooʼɛ́ bán, nkal éʼdəə́dəŋ áwɛ̂ hǒm démpēe ésebán á Jerusalɛm. ");
INSERT INTO bssNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Wóowóʼ! Á-bad bé Jerusalɛm, nyêwúɛ bekal-bé-eʼdəə́dəŋ nyéwúɛ̄nnē-ʼɛ bad meláá ábe Dyǒb álómé! Nkénwǎn áte ngen ne ngen âlad nyé áte nɛ̂ŋgáne nyaá-kúb ákútanné bǎn, boŋ nyéehédɛɛ́ etə́l! ");
INSERT INTO bssNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nyénɔneʼ, Dyǒb dɛ́tɛdé echɛn ndáb. Á mbále, nlâŋge nyé nɛ́n mɛɛ́, nyéenyínɛ́nné mɛ dǐd ámpē kə́ə́ŋ ne á póndé eche nyɛ́ɛ̄hɔ̄bpē bán, ‘Nnam ne ane awě apedé á dǐn á Sáŋgú.’ ” ");
INSERT INTO bssNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Mbwɛ nhɔ́g Yesuɛ ankɛ̌ ndyééd adyɛ́ wɛ́ɛ ndəle a Farisia pɔ́g. Nɛ́n démbɛ̄ a mbwɛ-mé-nkɔ́me-áte. Áde ápédé áwed, bénɔ́néʼáá mɔ́ chodchod. ");
INSERT INTO bssNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mod mɔ́-ʼɛ ambɛ̌ áhed awě melɔ́g mémbīdtē á yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Hɛ́ɛ Yesuɛ ásɛdtɛɛ́ bemeléede bé mbéndé ne Befarisia aáken, “Édé kunze âdid mod bwâm á mbwɛ-mé-nkɔ́me-áte, ngɛ́ éesaá?” ");
INSERT INTO bssNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Boŋ bénkênhɔ́bpé dyamdyam. Dɔ́ɔ ákóbé ane mod awe melɔ́g mébídé á yə̌l á ekáá, ádidé mɔ́ bwâm, asúúd-tɛ mɔ́ á ndáb. ");
INSERT INTO bssNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ámbīd e nɛ̂ dɔ́ɔ ásɛdtɛɛ́ bɔ́ aáken, “Nyé ahéé adé awě mwǎn káa nyag éhūnnē echóg, boŋ eékag chɔ́ abíded ábwɔ̄g-ábwɔ̄g, ké émbɛ̄ bán á mbwɛ-mé-nkɔ́me-áte?” ");
INSERT INTO bssNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Boŋ bénkênwóŋgé dyamdyam âhɔ́b. ");
INSERT INTO bssNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Áde Yesuɛ ányíné bad ábe bénlēbɛ̄ɛ̄ âdyɛ́ ndyééd bésyə̄ə̄l ábe bépédé bébóótédé medii mémbáá apwɛd, ankalé bɔ́ enɛ́n ngan aá, ");
INSERT INTO bssNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nzé mod alébpé wɛ ngande, weépāg-sɛ éhɛdé eʼdii éʼmbáá, áyə̄le éhɛle ébɛ́ né bélébpé mod ampée awě adelé áte tómaa wɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nzé ene nyaa e mod epedé-ʼɛ, mod awě alébpé nyé moosyəə́l ǎlāā wɛ aá, ‘Bɛɛ́ anɛ́n mod atii.’ Á póndé eched dɔ́ɔ étimɛɛ́ atii asad atéd ne akwáké. ");
INSERT INTO bssNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Boŋ nzé epedé ene ndín e hǒm, etédɛɛ́ eʼdii ábe éʼdé á ahə́ŋgé, âbɛl nɛ́n nzé nwóó-ngande anyíné wɛ, mɔ́ɔ̄ ǎlāā wɛ aá, ‘Amúɛ̄, kɛ̌ édyɛɛ á atii ámbáá híníí.’ Á póndé eched dɔ́ɔ ékudɛɛ́ edúbé átîntê e bad ábe nyáābɔ̄ɔ nyêtɛ́dé tébelɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Né-ɔɔ́, nyébíi bán, kénzɛ́ɛ́ awě achə́gté yə̌l, Dyǒb dɛ́sudéd mɔ́. Kénzɛ́ɛ́-ʼɛ awě asǔdté yə̌l Dyǒb dɛ́chə̄gēd mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Hɛ́-ʼaá álâŋgɛɛ́ mod awě anlébé mɔ́ nɛ́n aá, “Nzé ehɔ́bé wɛɛ́, mɔ́chageʼ ngande, weehɔ́bé wɛɛ́ mɔ́lébpe áboŋ bɛ̌n, káa áboŋ baányaŋ, káa echoŋ túmbé, káa bewóŋ bé ngáb ábe nyáābɔ̄ɔ nyêbyɛ́ɛ́né. Nzé ehídé nɛ̂, né bɔ́mpē bɛ́lēbē wɛ. Nɛ̂ ábɛle átim ehɛ́ɛn ne metuutɛn. ");
INSERT INTO bssNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Boŋ nzé echagé ngande, elébé dásɔ̄ betóótōkɛ̄ bé bad, ne bad ábe béhúné epɛd, bɔ́ɔbɛ bad ábe békwédé ndím. ");
INSERT INTO bssNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nzé ebɛlé nɛ̂, né wɛ̌kǔd nsimé áyə̄le béehɛnlé wɛ asábe ámbīd. Dyǒb dɛ́sābē wɛ áde bad bé bwâm bɛ́puúʼɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Áde mod nhɔ́g awě bɔ́ɔbɛ Yesuɛ béntɛ̄d tébelɛ áwógé nɛ̂, dɔ́ɔ álâŋgɛɛ́ Yesuɛ aá, “Nsimé ne bad ábe bɛ́dyɛ̄ ndyééd á ngande e nkamlɛn ń Dyǒb!” ");
INSERT INTO bssNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Mod nhɔ́g anchǎg sáŋkalaa a ngande, ábūd-tɛ bad alébe. ");
INSERT INTO bssNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Áde póndé e ngande épédé, anlóm awe mbəledɛ wɛ́ɛ beken ábe ánlēbɛ̄ɛ̄ aá, ‘Nyéhyag, mboŋsɛ́n ńsyə̄ə̄l ḿmáá abɛ́.’ ");
INSERT INTO bssNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Boŋ bɔ́ moosyəə́l, bêmbootéd mecháŋgé abɛ nhɔ́gē-nhɔ́gē. Nhɔ́g anhɔ́b aá, ‘Nchané etúú, ntə́ŋgɛ́né chɔ́ akɛ dé anyín. Ncháa wɛ, méehɛnlé ahyɛ.’ ");
INSERT INTO bssNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ampée anhɔ́b aá, ‘Bɔɔb nɛ́n děn, dɔ́ɔ ncháné nlád ń nyag ńtáan éche élíɛʼ nzag. Chɔ́ɔ ńkagké ahəgtɛn nɛ́n. Sôn, méehɛnlé apɛ!’ ");
INSERT INTO bssNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ampée-ʼɛ anhɔ́b aá, ‘Nkudé sɔ́mbé ekɔ́ɔ́lé-ekɔ́ɔ́lé. Né-ɔɔ́, méehɛnlé apɛ!’ ");
INSERT INTO bssNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ane mbəledɛ antǐm ámbīd, ákɛ áláá eche sáŋ mam mésyə̄ə̄l. Dɔ́ɔ ekaŋ ékóbé eche sáŋ áte, boŋ álōmē ane mbəledɛ. Anhɔ́b aá, ‘Kǎg mehélé, ékag á ntém ń nzii, kə́ə́ŋne á mɛ̌tɛ mé nzii mé dyad-tê, éhúɛn betóótōkɛ̄ bé bad, ne ábe béhúné epɛd, ne ábe békwédé ndím, ne ábe béehɛlé akɛ.’ ");
INSERT INTO bssNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Éebemɛɛ́ áte ane mbəledɛ anhúú ámbīd, aláá sáá-a-ndáb aá, ‘A-sáŋ, mbɛlé ngáne wénhɔ̄bpē, boŋ ké nɛ̂, etə́l élyə́gé édé.’ ");
INSERT INTO bssNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Dɔ́ɔ Sáá-a-ndáb áhɔ́bɛɛ́ aá, ‘Kǎg á nzii émbáá ne nzii é mehín, échɛ́le kénzɛ́ɛ́ wɛɛ́ áhyag âbɛl boŋ ndáb élôn. ");
INSERT INTO bssNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Á mbále, mod ké nhɔ́g awě ménsēbɛ̄ɛ̄ alébe, éewógké chǒm ké ehɔ́g á nsəl á ngande-tê hɛ́n!’ ” ");
INSERT INTO bssNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mbwɛ nhɔ́g ndun e mod éhídéʼáá Yesuɛ ámbīd. Hɛ́ɛ ábóótédé bɔ́ aláa nɛ́n aá, ");
INSERT INTO bssNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nzé mod ahɔ́bé aá, mɔ́hīde mɛ, ésebán achǎdtɛ́né nyaá, sáá, mwaád, bǎn, baányaŋ, kə́ə́ŋne ádē aloŋgé děn, ene ndín e mod eékwognedɛɛ́ âbɛ́ awêm mbapɛɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kénzɛ́ɛ́ awě eepéme ádē awɔg, boŋ áhīdnē mɛ, eékwognedɛɛ́ ábɛ̄ awêm mbapɛɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Nzɛ́-módɛ́ ǎbɛ̄ awě ǎwōŋ mewêmtɛn âlóŋ sáŋkalaa a ndáb, boŋ eesébpé adyɛɛ ásē, âhəgtɛn nkun ḿme ene ndáb étēdtē mɔ́, âbíi ké mɔ́ɔ̄hɛ̌l chɔ́ amad, káa mɔ́ɔhɛnlé? ");
INSERT INTO bssNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nzé amaá-ʼɛ ndáb asume, boŋ eéhɛle chɔ́ amad, moosyəə́l awě anyíné abɛlé ábootéd mɔ́ awɛl, béhɔ̄bē ");
INSERT INTO bssNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","bán, ‘Mod nhɔ́g ansáá ndáb, boŋ eéhɛlɛɛ́ chɔ́ amad.’ ");
INSERT INTO bssNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Nzé kə̂ŋ pɔ́g ewémtɛ́né waáb kə̂ŋ bel akum, abɛ́lé asébé yə̌l ahəg á ekáá ké mesoŋgé mé sə́nze ḿme áwóó dyam dyôm dé ekə́lé, bɛ́hɛ̌l ábe waáb awě awóó sə́nze dyam móom mé ekə́lé mébɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nzé anyíné aá mɔ́ɔ̄kwognedɛɛ́, abɛlé alóm belyə́ged bé dyad áʼsō wɛ́ɛ waáb, waáb adêpɛ mɔ́ bɛnbɛn, âbɛl nɛ́n békɔ̂m nsaŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Melemlem nɛ̂ dɔ́ɔ édíí né ké nzɛ́ɛ́ awě eehúde chǒm ásyə̄ə̄l nlém. Ene ndín e mod eékwognedɛɛ́ awêm mbapɛɛ âbɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Nyébíi bán nkwɛ̌ ńdé chǒm é bwâm. Boŋ nzé ḿbɔ́dé alaŋ, chán béhɛle-sɛ bényīnēd mɔ́ ámpē? ");
INSERT INTO bssNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Méesaá dyam dé abɛlɛn ámpē. Apim dɔ́ɔ bépimɛɛ́ mɔ́. Bad ábe béwóó metúu, bésôŋtɛn bwâm.” ");
INSERT INTO bssNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mbwɛ nhɔ́g belad bé táásɛ ne bebɛl bé mbéb bémpēe, bémpɛ̌ wɛ́ɛ Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Dɔ́ɔ Befarisia ne bemeléede bé mbéndé bényoŋgɛɛ́ áte bán, “Nɛ́dē anɛ́n mod awoŋne bebɛl bé mbéb, bɔ́bɔ̄ɔ bédyag-kɛ ndyééd hǒm ahɔ́g.” ");
INSERT INTO bssNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Hɛ́ɛ Yesuɛ ákánlé bɔ́ ngan nɛ́n aá, ");
INSERT INTO bssNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nzɛ́-módɛ́ adé awě ǎwōŋ mbwɔ́kɛl é ńdyɔŋ ḿ mbód, boŋ nhɔ́g ḿbɔ́ɔ, boŋ eétɛdté ḿmíníí móom mé ńdyɔŋ ḿ mbód abog ne abog á etûn-tê, âkɛ dé ahɛd ḿmê nhɔ́g ḿme ḿbɔ́ɔ́ kə́ə́ŋ né adǐbté mɔ́? ");
INSERT INTO bssNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Adibed áde ádibte-ʼáa mɔ́, áhāg mɔ́ á abɔl ne menyiŋge mésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Boŋ nɛ́ɛ ápédé á dyad-tê álad besón bé echoŋ ne baányaŋ áte, aláá bɔ́ aá, ‘Syánē déwôg menyiŋge áyə̄le ndǐbté ḿmêm ńdyɔŋ ḿ mbód ḿme mémbɔ̄ɔ?’ ” ");
INSERT INTO bssNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yesuɛ ambád ámpē aá, “melemlem-ʼaá ńlâŋgɛɛ́ nyé mɛɛ́, menyiŋge mɛ́tōm abɛ́ nɛ̂ ádyōb ámīn e mbɛlé-mbéb nhɔ́g awě atɛ̌dé abɛl dé mbéb boŋ atǐmné Dyǒb tómaa ámīn e móom mé bad abog ne abog ábe bésáá, ábe béehɛdnád ahəŋlɛn. ");
INSERT INTO bssNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Káa, mmwaád ahéé adé awě ǎwōŋ kábpe dyôm, boŋ nɛ́ɛ pɔ́g ébɔ́ɔ́, eéchōdēʼ ekag, boŋ áhɛdé ndáb áte, atóŋ ahɛd kə́ə́ŋ né adǐbté chɔ́? ");
INSERT INTO bssNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Adibed áde ádibte-ʼáa chɔ́, alade baáb ne baányaŋ áte, aláá bɔ́ aá, ‘Nyéwógɛn mɛ menyiŋge áyə̄le ndǐbté ene kábpe echě embɔ́ɔ́ mɛ.’ ");
INSERT INTO bssNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Melemlem-ʼaá ńlâŋgɛɛ́ nyé nɛ́n mɛɛ́, menyiŋge mɛ́tōm abɛ́ nɛ̂ ádyōb ámīn e mbɛlé-mbéb nhɔ́g awě atɛ̌dté abɛl dé mbéb boŋ átīmɛ̄n Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesuɛ ambád ahɔ́b aá, “Mod nhɔ́g ambɛ́, anchyáá bǎn bé baachóm bébɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Dɔ́ɔ epun ehɔ́g, mwǎn asad álāŋgē sáá nɛ́n aá, ‘A-sáŋ, bɛɛ́ mɛ ádêm akab á mbwɔ́g áde ńtə́ŋgɛ́né akud.’ Hɛ́ɛ sáá átédé chǒm ésyə̄ə̄l éche ánwōŋgē, boŋ ákabpé bɔ́ áte. ");
INSERT INTO bssNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nguse é eʼpun étómé-ʼaá, boŋ mwǎn asad áladé ḿmē nted ńsyə̄ə̄l, ákǎg á aloŋ démpēe áde áchábnédé. Áwed-taá ápédé boŋ ábootéd aloŋgé á mbaambaa achog, ábēbtē ngáb esyəə́l echě ánwōŋgē. ");
INSERT INTO bssNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Áde chǒm ésyə̄ə̄l émáá mɔ́ áyə̄l né bɔɔb, sáŋkalaa a nzaa anhún á aloŋ-tê wê. Atóg dɔ́-ʼɛ ábóótédé mɔ́ asɔ́l áyə̄l ngíne-ngíne. ");
INSERT INTO bssNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Hɛ́ɛ ákíí kunze e mod pɔ́g atán á dyad-tê wê, âchɔ́m mwǎ nsɔ́n. Ane mod mɔ́-ʼɛ alóm mɔ́ aá, ákɛ ádídtad mɔ́ esɔg é nguu. ");
INSERT INTO bssNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Anwóŋ á mewêmtɛn aá, mɔ́ɔ̄lōntē abum ké ne medyɛ́ mé nguu, boŋ modmod enkêmbaá mɔ́ chǒmchǒm éche áhɛlɛsɛ adyɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Dɔ́ɔ ádyɛ́ɛ́ chóóŋ, boŋ ákwanlád, áhɔ̄bē aá, ‘Nɔnéʼ ngáne bembəledɛ bélóné echem sáŋ á ndáb-te, boŋ ké nɛ̂ bédyâg medyɛ́ méchɔbe ásē, boŋ mɛ-ʼɛ ńwâg nzaa hɛ́n! ");
INSERT INTO bssNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mɛ̌syəə́, ńkɛ ntán echem sáŋ, nláá mɔ́ mɛɛ́, A-sáŋ, mbɛlé mbéb áʼsō éʼ Dyǒb ne áʼsō éʼbôŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mměn meékwognedɛɛ́ âchəgned nɛ́ɛ awoŋ mwǎn ámpē. Téd mɛ ké nɛ̂ŋgáne awôŋ mbəledɛ nhɔ́g.’ ");
INSERT INTO bssNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Hɛ̂ dɔ́ɔ ápádté ásē, boŋ ásūɛ̄ʼ á dyad wɛ́ɛ sáá. Boŋ áde ákwógé apɛ á ndáb nɛ̂, sáá annyín mɔ́ mwǎ etûn. Ankóbtɛ́n sáá ngɔl. Sáá annyəgéd, alúm mwǎn ámīn, ahɛ́ mɔ́ tə̂l. ");
INSERT INTO bssNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Dɔ́ɔ mwǎn álāŋgē mɔ́ nɛ́n aá, ‘A-sáŋ, mbɛlé mbéb áʼsō éʼ Dyǒb ne áʼsō éʼbôŋ. Meékwognedɛɛ́ âchəgned nɛ́ɛ mwǎn awôŋ ámpē.’ ");
INSERT INTO bssNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Hɛ́ɛ sáá mɔ́-ʼɛ áchɛ́nlé ábē bembəledɛ, álāŋgē bɔ́ nɛ́n aá, ‘Nyéhyiinad mɛ nsob ḿme ńtómtɛ́né adəŋ nɛ̂, á mehélé-te. Nyéwáad mɔ́ mɔ́ á yə̌l. Nyéhɛ̂-ʼɛ mɔ́ ebóŋ á ekáá, nyéhɛ̂-ʼɛ mɔ́ metámbé a ékuu. ");
INSERT INTO bssNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nyétêd nchóm-é-nyag awě dékə́lté nɛ̂, nyékwɛl mɔ́, âbɛl nɛ́n, syánē moosyəə́l dédyɛ̂ débɛl-lɛ apaté. ");
INSERT INTO bssNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nyêbíí bán, awem mwǎn nɛ́n ammǎd awɛ́, boŋ atimé ámbīd á aloŋgé. Ambɔ́ɔ, boŋ abídé áwed.’ Hɛ́-ʼaá bébóótédé ngande achog. ");
INSERT INTO bssNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ḿmɛ́n mésyə̄ə̄l mêmbɛnléd áde mwǎnyaŋ ambáá adíí á nzag-tê. Áde áhúú, dɔ́ɔ áwógɛɛ́ bad békɔ́ne, béságe-ʼɛ bwěm á ndáb-te. ");
INSERT INTO bssNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Dɔ́ɔ áchɛ́nlé mbəledɛ nhɔ́g, boŋ ásɛdté mɔ́ dyam áde ábɛnlaad. ");
INSERT INTO bssNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Dɔ́ɔ mbəledɛ nɛ álûmtɛɛ́ mɔ́ áte nɛ́n aá, ‘Pɔ́n mwǎnyoŋ ahúú ámbīd-óó. Sóó akwɛ̌nlé mɔ́ nchóm-é-nyag ne, áyə̄le anyínɛn áde ányínné mɔ́ dǐd ámpē, ésebán dyamdyam ábɛ́lé mɔ́.’ ");
INSERT INTO bssNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","29","“Awóg áde áwógé nɛ̂, anlǐŋ, eékwɛntɛne asɔ́l á ndáb-te. Hɛ́ɛ sáá ábídé á ebwɔ́g, boŋ áhyɛ acháŋ mɔ́. Dɔ́ɔ mɔ́-ʼɛ átimtanné sáá nɛ́n aá, ‘Nɔnéʼ, mɛɛ́ nkéndyɛɛ́n wɛ hɛ́n mwɛ̌ ne mwɛ̌ áde ḿbɛnlɛɛ́ wɛ ntǔ mé nsɔ́n, ésebán nwúɛne wɛ nló áte. Boŋ ké echɛd é mbód weébāgɛ̄ɛ̄ mɛ wɛɛ́, ḿbɛl apaté ne ábêm bɛ̌d. ");
INSERT INTO bssNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Boŋ ngáne awoŋ mwǎn a nlém ápédé ámbīd, mɔ́ awě amaá echoŋ ngáb esyəə́l abébed ne bɛkwalɛɛ, ewúúdé mɔ́ nyag echě etómtɛ́né akəl.’ ");
INSERT INTO bssNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Hɛ́ɛ sáá álâŋgɛɛ́ mɔ́ nɛ́n, ‘A-mwǎn, wɛ-ɛɛ́ edé ne mɛ hɛ́n póndé ésyə̄ə̄l. Kéchéé éche ńwóó-ʼɛ édíi échôŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Émbɛ̄ bwâm syánē âchog ngande, âwóg menyiŋge. Nɛ́n, mwǎnyoŋ ammǎd awɛ́, boŋ atimé ámbīd á aloŋgé. Ambɔ́ɔ, boŋ abídé áwed.’ ” ");
INSERT INTO bssNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesuɛ anláá ábē bembapɛɛ ámpē aá, “Nhɔn ḿ mod nhɔ́g mémbɛ̄. Bad bénhyɛ mɔ́ aláa bán awě mbəledɛ ambáá abébte mɔ́ ngáb. ");
INSERT INTO bssNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hɛ́ɛ ḿmê nhɔn ḿ mod ńlómé mbəledɛ awed achəg, boŋ ásɛdté mɔ́ aá, ‘Ebə́l é pɔ́le éhéé ńwógɛɛ́ áyə̄l echôŋ nɛ́n? Lúméd mɛ áte ngáne mesoŋgé mé bwěm ḿme mêmbanɛ́ɛ́ ásē echôŋ médíí, áyə̄le échê etə́l é nsɔ́n émááné wɛ áte.’ ");
INSERT INTO bssNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Dɔ́ɔ mbəledɛ ádólé áte chóóŋ boŋ áhɔ̄bē aá, ‘Chán-nɔ̄ mɛ́bɛnlé bɔɔb áde echem sáŋ áhɛdɛɛ́ mɛ ahúd á nsɔ́n? Ngíne eésaá mɛ echě ńkwɛnlɛɛ́ nzag. Nzé ntimé-ʼɛ á nchɔ́mbé, né nɛ̂ dɛ́piinéd mɛ akwágké á ngíne. ");
INSERT INTO bssNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ahâ, nkudé debyɛ́ɛ́ áde mɛ́həgké, âbɛl boŋ ké á nsɔ́n dɔ́ɔ bénhūdtē mɛ, bad bɛ́lyə̌g békōb mɛ nken áwab mendáb.’ ");
INSERT INTO bssNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Hɛ́ɛ áchɛ́nlé mod tɛ́ɛ́ awě anwálé sáá alúm, áchəgé bɔ́ nhɔ́gē-nhɔ́gē. Áde mod eʼsó ápédé, ansɛdéd mɔ́ aáken, ‘Mesoŋgé métə́ŋ echem sáŋ ékálɛɛ́ wɛ?’ ");
INSERT INTO bssNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ane mod aá, ‘Mbwɔ́kɛl é eʼkwém éʼ mǒl waam.’ Ane mbəledɛ anláá mɔ́ aá, ‘Nɔnéʼ, echoŋ kálag e melúm chɔ́ nɛ́n. Dyɛɛ́ ásē, étel á mehélé-te wɛɛ́, mbwɔ́kɛl é eʼkwém éʼniin.’ ");
INSERT INTO bssNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ansɛdéd mod awě alóntɛ́né bébɛ aá, ‘Alúm ádé wɛ mesoŋgé métə́ŋ?’ Ane anhɔ́b aá, ‘Mbwɔ́kɛl é nkute ń ngun éláán.’ Ane mbəledɛ anláá mɔ́ aá, ‘Kǒb echoŋ kálag, étel wɛɛ́, mbwɔ́kɛl é nkute ébɛ.’ ");
INSERT INTO bssNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Áde ḿmê nhɔn ḿ mod ńwógé nɛ̂, ménkēmēd échê ekúkú é mbəledɛ aá, ‘Abɛ̌nlédé debyɛ́ɛ́ á bwâm.’ ” Yesuɛ ambád áte nɛ́n aá, “Nɛ̂ dɔ́ɔ bad ábe béhíde mekan mé nkǒŋsé bédíí. Bédé mehɛ́l âhəgɛn échāb nyaa é bad debyɛ́ɛ́, tómaa bad ábe béhíde eʼnyínɛn bé ekíde éʼ Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesuɛ ambád aá, “Ńláa-ʼɛ nyé mɛɛ́, nyébɛnled nhɔn mé nkǒŋsé, âkób eʼchoŋ, áyə̄le á póndé eche mɛ́maáʼɛ́ áte, bɛ́kob nyé nken wɛ́ɛ bad bédyɛɛʼɛ́ á ngíndé ne á ngíndé. ");
INSERT INTO bssNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ké nzɛ́-módɛ́ awě awánlé mpín mé akan bwâm, né ǎwālē ámbáá bwâm. Kénzɛ́ɛ́-ʼɛ awě eéhɛle mpín mé akan awále, né éehɛnlé ké ámbáá awále. ");
INSERT INTO bssNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nzé édé-ʼɛ bán, weewánlɛɛ́ ngáb e nkǒŋsé ngáne étə́ŋgɛ́né awále, nzɛ́-módɛ́ ǎbɛ̌ wɛ nhɔn ḿ mbále. ");
INSERT INTO bssNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nɛ́ɛ wéewânlɛɛ́ nhɔn ḿme méesɛ̌ ḿmôŋ bwâm, nzɛ́-módɛ́ ǎbǎg wɛ nhɔn ḿmoŋ mwěn? ");
INSERT INTO bssNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Modmod eéhɛ̄lɛ̄ɛ̄-sɛ abɛ́ mbəledɛ a bewóŋ bébɛ. Ǎlūmēd nhɔ́g edəŋge tómaa aníníí, kéʼɛ átīmɛ̄n nhɔ́g, abáŋge aníníí áyə̄l. Weéhɛ̄lɛ̄ɛ̄-sɛ ebɛ́ mbəledɛ a bad bébɛ abɛ́ ahɔ́g. Weéhɛ̄lɛ̄ɛ̄-sɛ ebɛ́ mbəledɛ a Dyǒb se ebɛ́-ʼɛ mbəledɛ a mɔné.” ");
INSERT INTO bssNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Befarisia bénwōg ḿmɛ́n mésyə̄ə̄l, boŋ ngáne bémbɛ̄ɛ̄ bedəŋ bé ngáb, bénswɛ̄dē mɔ́ swɛ́dtɛ́n. ");
INSERT INTO bssNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesuɛ anláá bɔ́ aá, “Nyêdíi bad ábe bélûmte bán bésáá áʼsō éʼ bad, boŋ Dyǒb ábíí nyé nlém áte. Kéchéé éche baányoŋ békêmtɛɛ́, édíi abúú ngɛ̂n áʼsō éʼ Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yesuɛ ambád bɔ́ aláa aá, “Mam ḿme mêntenléd á kálag é mbéndé é Dyǒb, bekal béʼdəə́dəŋ bɔ́mpē bénhɔ̄b mɔ́ kə́ə́ŋne á póndé eche Jɔnɛ. Taasɛ nɛ̂, nkalaŋ ḿ bwâm mé nkamlɛn ń Dyǒb ńkanlad, mod tɛ́ɛ́-ʼɛ abune ḿmê nkamlɛn abɛ́ áte. ");
INSERT INTO bssNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Ké nɛ̂ŋgáne nkoŋ ńsé ne ḿ mín béhɛle bémaa, atɔte ké ahɔ́g á mbéndé e Dyǒb déekwaá. ");
INSERT INTO bssNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Kénzɛ́ɛ́ awě anané mwaád, boŋ awóŋ mmwaád ampée, né akábé asón. Ké nzɛ́-módɛ-ʼɛ́ awě awóó mmwaád awě bénáné á ndáb eʼwóŋgé, né akábé asón. ");
INSERT INTO bssNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Nhɔn ḿ mod nhɔ́g mémbɛ̄, kəse é mebad chɔ́ɔ áwááʼáá á yə̌l. Mwɛnze ne mwɛnze mɔ́ɔ ádyágáá mbwɛ tɛ́ɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ntógétōke ḿ mod nhɔ́g mɔ́-ʼɛ ńnáŋgéʼáá áwē mmwɛ mé eʼkɛ́ bán Lazarɔsɛ. Eʼkwɛsɛ bénlōn mɔ́ á yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Mewêmtɛn mémbɛ̄ mɔ́ aá, bɛ́bɛ mɔ́ púuted é medyɛ́ éche éhúnéʼáá á tébelɛ a nhɔn ḿ mod. Mbwɛ́ chɔ́ɔ épágéʼáá áhed, boŋ ényāŋgē mɔ́ eʼkwɛsɛ áte. ");
INSERT INTO bssNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Áde ntógétōke ḿ mod mê ńwédé, ángɛl éntēd mɔ́, ékɛ̄ɛ̄n mɔ́ á akéb áde Abrahamɛ. Ḿmê nhɔn ḿ mod mɔ́mpē ménwɛ̄, bélíme-ʼɛ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Á mbwɔ́g e kwééd wê, nhɔn ḿ mod ḿbédé á metuné-te. Hɛ́ɛ ányéné nló ámīn boŋ anyín Abrahamɛ se wíníí, ne Lazarɔsɛ áwe akéb. ");
INSERT INTO bssNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Dɔ́ɔ álébpɛɛ́ nɛ́n aá, ‘A-Tɛ̂ Abraham, sôn, wóg mɛ ngɔl, élôm Lazarɔsɛ átɔde dúu dé eʼmii á mendíb-te, áhyɛ áhɔ́ded mɛ echém, áyə̄le meewógɛ́ɛ́ bu á dǔ-á-muú hɛ́n.’ ");
INSERT INTO bssNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abrahamɛ anláá mɔ́ aá, ‘A-mwǎn, ewêmtan á póndé eche wémbɛ̄ɛ̄ á nkǒŋsé ngáne wênkudté bwěm éʼ bwâm, boŋ Lazarɔsɛ mɔ́-ʼɛ ákūd bwěm bé mbéb-ɛ? Bɔɔb-pɔɔ́ awóge ḿmê menyiŋge hɛ́n, wɛ́mpē edé á metuné-te. ");
INSERT INTO bssNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nɛ́ɛ éhúdé nɛ̂ áte, wɛ́ɛ sédíí ne wɛ́ɛ édíí, sáŋkalaa a mbə́ŋ akabé syánē áte, âbɛl nɛ́n mod eéhɛ̄lē asyəə wɛ́n se ápɛ wɛ̂. Modmod eéhɛ̄lē-ʼaá ásyə̄ə̄ wɛ̂, se ápɛ̄ áwɛ̄d.’ ");
INSERT INTO bssNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Nhɔn ḿ mod ménhɔ̄b aá, ‘Ncháa-ɔɔ́, a-Tɛ̂ mɛɛ́, élôm Lazarɔsɛ á ndáb echě echem sáŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nlyə́gé bǎnned bétáan. Ákɛ álêb bɔ́ âbɛl nɛ́n, bɔ́mpē béepǎg á hǒm dé metuné hɛ́n.’ ");
INSERT INTO bssNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahamɛ anhɔ́b aá, ‘Béwóó metelag ḿme Mosɛɛ ne ḿme bekal béʼdəə́dəŋ. Béwógɛn chǒm-ɛ́ɛ bétélé ásē.’ ");
INSERT INTO bssNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nhɔn ḿ mod ménhɔ̄b aá, ‘Aáy, a-Tɛ̂ Abraham. Nzé mod akií bɔ́ atán awě abídé á mbwɔ́g é kwééd, né bɛ́tɛdé abɛl dé mbéb bétīmɛ̄n Dyǒb.’ ");
INSERT INTO bssNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Hɛ́ɛ Abrahamɛ áhɔ́bɛɛ́ aá, ‘Nzé béekwɛntɛne Mosɛɛ ne bekal béʼdəə́dəŋ awógɛn, né béewógɛ́nné ké mod awě apuúdé á mbwɔ́g e kwééd boŋ aláá bɔ́.’ ” ");
INSERT INTO bssNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesuɛ anláá ábē bembapɛɛ aá, “Nyébíi bán mekəgsɛn ḿme mébɛlte bad mbéb métə́ŋgɛ́né nyé apii. Boŋ édé ngɔl ne kénzɛ́ɛ́ awě ǎpɛɛ́n mɔ́! ");
INSERT INTO bssNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Émbɛ̄ mboŋ né bêntəə́ ene ndín e mod sáŋkalaa a aláá á nkə́ŋ, bébwém mɔ́ á edíb-te, tómaa mɔ́ âbɛled ábɛ́n běndem mbéb. ");
INSERT INTO bssNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nyétédɛn yə̌l póndé. “Nzé mwǎnyoŋ abɛlé wɛ dyam dé mbéb, échu mɔ́ aláa wɛɛ́ nɛ̂ déebooʼɛ́. Nzé achemé-ʼɛ ádē awusé boŋ ahə̌ŋlɛ́né, élagsɛ́n mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nzé apǎnné wɛ ngen saámbé áyə̄le epun é bǐn, boŋ apedé-ʼɛ áwōŋ ngen saámbé âchɔ́m alagsɛn aá, ‘Nhə̌ŋlɛ́né’, etə́ŋgɛ́né mɔ́ alagsɛn.” ");
INSERT INTO bssNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Bembapɛɛ bé nlómag bénlāā Sáŋgwɛ́ɛ́ bán, “Wéd sé adúbe áte.” ");
INSERT INTO bssNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Sáŋgwɛ́ɛ́ anhɔ́b aá, “Nzé nyênwóŋ adúbe áde ádé mwǎmpīn nɛ̂ŋgáne mbə́l-e-bǔ, né nyɛ́ɛ̄kamlɛ́n ádɛ́n alín dé eʼsáá bán, ‘Á-bwɛl, wubé ásē, ékɛ ésumɛn á edíb é nkwɛ̌-te’, éʼwógɛ́n-nɛ nyé. ");
INSERT INTO bssNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Détêd bán, nyé mod nhɔ́g nyêwóó mbəledɛ awě akií nzag alíi, káa akií ânɔn ńdyɔŋ ḿ mbód. Nzé ahúú á nsɔ́n, chán wɛ́lāāʼɛ́ mɔ́? Wɛ̌lāā mɔ́ wɛɛ́, ‘Hyɛ̌ édyɛɛ ásē hɛ́n, édyɛ̂ ndyééd,’ ");
INSERT INTO bssNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","káa wɛɛ́, ‘Bɛlé mɛ ndyééd étômted mɛ, étyéem-mɛ á nkəg, kə́ə́ŋ ḿmad adyɛ́, boŋ ámbīd é póndé, wɛ-ʼɛ édyâg?’ ");
INSERT INTO bssNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nyéláa mɛ ké wɛ̌sāgnɛ̄n ane mbəledɛ áyə̄le ábɛ́lé ḿme nsɔ́n? ");
INSERT INTO bssNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Né-ɔɔ́ nyémpē, nzé nyêmaá chǒm ésyə̄ə̄l éche bétíínédé nyé abɛl, nyéhɔ̂b bán, ‘Sêdíi bembəledɛ ngɛ̂n, ḿmɛd nsɔ́n-naá sébɛ́lé sé ngáne.’ ” ");
INSERT INTO bssNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Áde Yesuɛ ákagké á Jerusalɛm, atóméʼáá á nchii ń nzii mé aloŋ á Samaria ne aloŋ á Galilia. ");
INSERT INTO bssNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Asɔ́l áde ásɔ́lé mwǎ dyad nhɔ́g, antán bad dyôm ábe meləŋ mékóbé. Béntyēēm nchabnede, ");
INSERT INTO bssNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","bélēbpē mɔ́ ne esaád bán, “A-Yesu, a-Sáŋ, sôn, wóg sé ngɔl!” ");
INSERT INTO bssNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Áde ányíné bɔ́, anláá bɔ́ aá, “Nyékag wɛ́ɛ beprisɛ, nyélúmed bɔ́ yə̌l.” Áde békagkɛ́ nɛ̂, yə̌l é nsáŋ bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Bɔ́ mod nhɔ́g, annyín nɛ́n aá mɔ́dyɛɛ́ bwâm. Hɛ́ɛ átímé ámbīd, ákɛné Dyǒb ne ehɔ́b éche échə́gké. ");
INSERT INTO bssNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ankwɛ Yesuɛ á mekuu, ásāgnān mɔ́. Anɛ́n mod abédɛ́ɛ mod a Samaria. ");
INSERT INTO bssNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesuɛ ansɛdéd mɔ́ aáken, “Éesaá mbále bán nsáŋté nyé bad dyôm-ɛ? Héé ábíníí abog bédíí? ");
INSERT INTO bssNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nɛ́dē mod ké nhɔ́g ampée eétimɛɛ́ ámbīd âhyɛ dé abɛ Dyǒb mekɛnag, éetómɛɛ́ anɛ́n mod a nken-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Hɛ́ɛ álâŋgɛɛ́ mɔ́ aá, “Tyéém ámīn, ékag. Ádôŋ adúbe ádídé wɛ bwâm.” ");
INSERT INTO bssNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Befarisia bênsɛdéd Yesuɛ bánken, “Póndé ehéé nkamlɛn ń Dyǒb mɛ́pɛɛ́?” Yesuɛ anláá bɔ́ aá, “Nkamlɛn ń Dyǒb méesaá dyam áde mod ányînnɛɛ́ dǐd, ");
INSERT INTO bssNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","káa dyam áde mod áhɔ̄bpē aá, ‘Nɔnéʼ, mɔ̂mɛ́n,’ káa ‘mɔ̂míníí.’ Aáy, nkamlɛn ń Dyǒb ḿmáá abɛ́ átîntê echɛ̂n.” ");
INSERT INTO bssNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Hɛ́ɛ álâŋgɛɛ́ bembapɛɛ nɛ́n aá, “Eʼpun éʼ bǐn éʼhúɛ áʼsō ábe nyɛ́dəŋgé bán né nyênyín ké mbwɛ nhɔ́g ḿme Mwǎn-a-Moonyoŋ álūmēdtē nyé yə̌l, boŋ nyéenyínné. ");
INSERT INTO bssNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bɛ́lāā nyé á póndé eched bán, ‘Mɔ̂nɛ́n,’ káa ‘Mɔ̂níníí,’ boŋ nyéeháŋtán bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Áyə̄le, ngáne emwɛdmwɛd étómɛɛ́, boŋ épɛnté ngob e Dyǒb pɛd pɔ́g ne eníníí, nɛ̂ dɔ́ɔ epun éche Mwǎn-a-Moonyoŋ ápɛɛ́ ébɛ̄ɛ̄. ");
INSERT INTO bssNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Boŋ édɛ̂bɛ́ nɛ̂, atə́ŋgɛ́né metuné híin akud. Kə́ŋne enɛ́n nyoŋgɛl e bad eébāŋ mɔ́ áyə̄l. ");
INSERT INTO bssNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ngáne émbɛ̄ɛ̄ á póndé eche Noa, nɛ̂ dɔ́ɔ ébɛ̄ɛ̄ á póndé echě Mwǎn-a-Moonyoŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bad bédyágéʼáá medyɛ́, bémwāg mǐm, baachóm béwóóʼáá bebaád, bebaád-tɛ békǎg á mewóŋgé kə́ə́ŋ ne mbwɛ ḿme Noa ásɔ́lé á bɔ̌lɛ éʼmbáá-te boŋ mbúú echó, mesɛ́n mélóne, méhōōd ábê bad bésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Melemlem nɛ̂ dɔ́ɔ émbɛ̄ɛ̄ á póndé eche Lɔtɛ. Bad bédyágéʼáá medyɛ́, bémwāg mǐm, békābē dyɔn, béwēnē bwěm, bélōō-ʼɛ mendáb. ");
INSERT INTO bssNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Boŋ mbwɛ ḿme Lɔtɛ ásyə́ŋgé á dyad á Sodom, ḿmê mbwɛ děn muú ne meláá ḿme méhyâŋtan, mémbīd ádyōb nɛ́ɛ mbúú, ńwúú ábê bad bésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Melemlem nɛ̂ dɔ́ɔ ébɛ̄ɛ̄ ḿmê mbwɛ ḿme Mwǎn-a-Moonyoŋ ányīnnēdtē. ");
INSERT INTO bssNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Échê epun, mod awě adé á nnoŋ ń ndáb mîn áde nhɔn ńdíí mɔ́ á ndáb-te, eétɔgné asud ásē âhyɛ dé atéd mɔ́. Melemlem-ʼaá mod awě adé á nzag-tê, eétɔgné atim ámbīd á ndáb. ");
INSERT INTO bssNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nyéwêmtɛn dyam áde dêmbɛnléd ne Lɔtɛ mwaád. ");
INSERT INTO bssNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kénzɛ́ɛ́ awě awóó mewêmtɛn âsoŋ ádē aloŋgé, ǎbɔ̄d dɔ́. Kénzɛ́ɛ́-ʼɛ awě abɔ́dé ádē aloŋgé, né asoó dɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Á mbále, bad bébɛ bɛ́naá anɔŋ ahɔ́g nkuu, bétéd nhɔ́g, bétɛ̄dē aníníí. ");
INSERT INTO bssNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Bebaád bébɛ bɛ́kɔgé medyɛ́, bétéd nhɔ́g, bétɛ̄dē aníníí.” ");
INSERT INTO bssNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Dɔ́ɔ bembapɛɛ bésɛdtɛɛ́ mɔ́ bán “A-Sáŋ, héé nɛ̂ dɛ́bɛnlédté?” Yesuɛ antimtɛ́n bɔ́ aá, “Wɛ́ɛ ndim ḿbāgkē, áhed dɔ́ɔ benhɔgnɔnɛ́ béladnɛɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesuɛ ankalé ábē bembapɛɛ ngan âlúmed bɔ́ áte nɛ́n aá, bétə́ŋgɛ́né békānnē póndé tɛ́ɛ́ ésebán béhûnte nlém á abum. ");
INSERT INTO bssNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Anhɔ́b aá, “Mod abédé dyad ahɔ́g, awě akáadteʼ bad. Ane mod eebáaʼaá Dyǒb, eébageʼaá-ʼɛ modmod edúbé. ");
INSERT INTO bssNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nkúd é mmwaád-tɛ abédé melemlem mé dyad, eémaaʼaáʼ wɛ́ɛ ane mod. Póndé tɛ́ɛ́ álāŋgē mɔ́ aá, ‘Sé mod sêwóŋné mehɔ́b. Káád sé ésuud mɛ nzɔm.’ ");
INSERT INTO bssNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Á mbooted ane mod enkênháá mɔ́ dúu. Boŋ ámbīd é póndé anláá yə̌l aá, ‘Ké nɛ̂ŋgáne méebagɛ́ɛ́ Dyǒb edúbé, méēbāā-ʼaá modmod, ");
INSERT INTO bssNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ngáne édíí bán anɛ́n nkúd a mmwaád ahédé mɛ nló, mɛ̌kāā ḿme nkáá âbɛl ńsud mɔ́ nzɔm. Ésebɛ́ nɛ̂, né kə́ə́ŋ ne á asóg éemwaá aá ńkûn ne epɛ éche ápagké nɛ́n póndé ésyə̄ə̄l.’ ” ");
INSERT INTO bssNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Hɛ́ɛ Sáŋgwɛ́ɛ́ áhɔ́bɛɛ́ aá, “Nyêwógé chǒm-ɛ́ɛ ekúkú é mod awě akáadteʼ bad awě eebíi Dyǒb éhɔ́bé-yɛ? ");
INSERT INTO bssNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nɛ́dē Dyǒb déekunné ábē bad ábe ápwɛ́dé-yɛ? Béchyɛɛneʼ mɔ́ nwôŋgɛn nkuu ne mǔte, nɛ́dē ǎkɔ̄lɛ̄n bɔ́ metúu póndé tɛ́-yɛ? ");
INSERT INTO bssNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ńláa nyé mɛɛ́ ǎkun bɔ́ mehélé mehélé. Boŋ nyêdúbpé bán Mwǎn-a-Moonyoŋ ǎtān adúbe á nkǒŋsé-te á póndé echě ápɛɛ́-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesuɛ ankǎl ngan empée tə̂ŋgɛne bad ábe bényínéʼáá yə̌l nɛ́ɛ bad ábe bésáá, bényīnē-ʼɛ bad bémpēe nkóŋtéd. ");
INSERT INTO bssNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Anláá bɔ́ aá, “Bad bébɛ bênkɛ̌ á Ndáb-e-Dyǒb âkáne. Nhɔ́g abédé Farisia, aníníí-ʼɛ abɛ́ nlad-é-táásɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Ane Farisia antyéém á ámīn, ákânneʼ, áhɔ̄bē á nlém-tê aá ‘A-Dyǒb, nságnɛ́né wɛ. Áyə̄le nɛ́n, meésaá nɛ̂ŋgáne bad bémpēe, ábe bédume bwěm éʼ bad, ábe bébébé nlém ábum, ábe békábe mesón á ndáb e eʼwóŋgé. Nságnɛ́né wɛ áyə̄le meésáa nɛ̂ŋgáne anɛ́n nlad-é-táásɛ hɛ́n. ");
INSERT INTO bssNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ndé nɛ́n, ndideʼ yə̌l nzaa á mekáne-tê ngen ébɛ sɔ̂ndɛ́ tɛ́ɛ́. Chǒm tɛ́ɛ́ éche ńkudɛɛ́-ʼɛ nkabe chɔ́ áte moŋge dyôm, ḿbagé wɛ akab nhɔ́g.’ ");
INSERT INTO bssNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Nlad-é-táásɛ pɛn antyéém nchabnede, eéhɛle ké mǐd anyen ádyōb. Ambán ekáá á nlém, ákânne aá, ‘A Dyǒb, wóg mɛ ngɔl. Ndíi mbɛlé-mbéb.’ ” ");
INSERT INTO bssNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Hɛ́ɛ Yesuɛ ábádé aá, “Ńláa nyé nɛ́n mɛɛ́, anɛ́n mod awě ńdímtɛ́né nyé aláa, ansú áwe ndáb nɛ́ɛ mod awě asáá áʼsō éʼ Dyǒb. Áyə̄le mod ké ahéé awě achə́gté yə̌l, bɛ́sudéd mɔ́. Boŋ ane awě asǔdté eche yə̌l, bɛ́chə̄gēd mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bɔɔb-pɔɔ́ bad bépɛ́ɛ́néʼáá běndem wɛ́ɛ Yesuɛ nɛ́n bán ábân bɔ́ ekáá á yə̌l ânamed bɔ́. Áde bembapɛɛ bényíné nɛ̂, bénkānē ábê bad áte. ");
INSERT INTO bssNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Boŋ Yesuɛ anchɛ́lé ábê bǎn, áhɔ̄bē aá “Nyétɛde bǎnbǎn béhyag áwêm. Nyéekə́ə́ bɔ́ áyə̄le nɛ́n, nyaa e bad nɛ́ɛ bɔ́ chɔ́ɔ éwóó nkamlɛn ń Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, kénzɛ́ɛ́ awě eékobe nkamlɛn ń Dyǒb nɛ̂ŋgáne mwěndem, éesɔ́nlé áwēd-te.” ");
INSERT INTO bssNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nkamlɛnɛ nhɔ́g ansɛdéd Yesuɛ aá, “A-meléed a bwâm, cheé mɛ́bɛnlé âbɛl nɛ́n ńkud aloŋgé áde déemaáʼ?” ");
INSERT INTO bssNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Dɔ́ɔ Yesuɛ ásɛdtɛɛ́ mɔ́ aáken, “Cheé ékə́ə́ boŋ échəgé mɛ meléede a bwâm? Mod ké nhɔ́g eésaá mod a bwâm étómɛɛ́ Dyǒb děmpɛn. ");
INSERT INTO bssNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ebíí mbéndé éche éhɔ́be bán, weekábé asón á ndáb e eʼwóŋgé, weewúɛ́ mod, weechíbéʼ, weebídé mbóŋ e metóm, bɛɛ́ sóó ne nyoŋ edúbé.” ");
INSERT INTO bssNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ane mod a nkamlɛn antimtɛ́n aá, “A meléed, nhídé échɛ́n mbéndé ésyə̄ə̄l bootya se á mwɛ̌ndemé.” ");
INSERT INTO bssNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesuɛ awógé-ʼaá nɛ̂, boŋ álāŋgē mɔ́ aá, “Dyam ahɔ́g éhɛdne wɛ. Sóm bwěm éʼsyə̄ə̄l ábe éwóó, étêd ḿmê mɔné, ékabe betóótōkɛ̄ bé bad. Nzé ebɛlé nɛ̂, wɛ̌kǔd nhɔn ádyōb. Ene póndé éhyɛ éhíde mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Awóg áde ane mod a nkamlɛn áwógé nɛ̂, anwóg ndutul bwâmbwam, áyə̄le ambɛ́ nhɔn bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesuɛ anyíné-ʼaá ngáne ásúdné boŋ áhɔ̄bē aá, “Élɛ̌l áte bwâmbwam behɔn bé bad âsɔ́l á nkamlɛn ń Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Édé mwǎn e akan sáŋkalaa a nyam nɛ́ɛ kamɛ̂l âpoŋ á epɔn é ndɔnde, tómaa nhɔn ḿ mod âsɔ́l á nkamlɛn ń Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bad ábe bénwōg chǒm echě Yesuɛ ánhɔ̄bpē, bénhɔ̄b bán nzé nɛ́ɛ édíí, né nzɛ́ɛ́-ʼɔ̄ ahɛle ákud eʼsoósoŋ?” ");
INSERT INTO bssNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Dɔ́ɔ Yesuɛ áhɔ́bɛɛ́ aá, “Dyam áde baányoŋ bényínɛɛ́ bán álɛ́lé áte, déelɛnledɛɛ́ Dyǒb áte.” ");
INSERT INTO bssNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Hɛ́ɛ Petro áhɔ́bé aá, “Nɔnéʼ, sêtɛ̌dté ábɛd bwěm éʼsyə̄ə̄l âhíd wɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Á mbále, nlâŋge nyé mɛɛ́, kénzɛ́ɛ́ awě atɛ̌dté eche ndáb káa mwaád, káa baányaŋ, káa sáá ne nyaŋ káa bǎn, áyə̄le nkamlɛn ń Dyǒb, ");
INSERT INTO bssNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ǎkǔd nsyə́ŋ ámbīd mbád ne mbád enɛ́n póndé. Ǎkud-tɛ aloŋgé áde déemaáʼ á póndé échě ehúɛʼ.” ");
INSERT INTO bssNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Hɛ́ɛ Yesuɛ átímné ábē bembapɛɛ dyôm ne bébɛ kun boŋ, álāŋgē bɔ́ aá, “Pɔ́n nyébíi bán dekag á Jerusalɛm. Mam mésyə̄ə̄l-lɛ ḿme bekal béʼdəə́dəŋ bétélé ásē tə̂ŋgɛne Mwǎn-a-Moonyoŋ mɛ́bɛnléd áned. ");
INSERT INTO bssNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Éténlédé nɛ́n bán bɛ́bɛ̌ mɔ́ á mekáá mé bad ábe béesɛ̌ bad bé Israɛl. Bɔ́-ʼɛ béwɛlé mɔ́, bésyə̄ə̄ mɔ́, bésobé-ʼɛ mɔ́ meléed á yə̌l. Bɛ́bɔmtéd mɔ́, béwúú-ʼɛ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Boŋ ámbīd e eʼpun éʼláán ǎpuú.” ");
INSERT INTO bssNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Boŋ bembapɛɛ bɔ́-ʼɛ bénkênsóŋtɛ́nné dyamdyam áyə̄le ḿmɛ́n mam mésyə̄ə̄l. Enɛ́n ngan entóm bɔ́ debyɛ́ɛ́ áte. Bénkênchemmé chǒm éche Yesuɛ áhɔ́béʼáá. ");
INSERT INTO bssNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Bɔɔb-pɔɔ́ áde Yesuɛ ákwógé apɛ á dyad á Jeriko, mod a ndím nhɔ́g andyɛɛ́ á nkəg ń nzii, áchɔ̄mē bwěm. ");
INSERT INTO bssNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Awógé-ʼaá ndun e mod etóme, boŋ ásɛdté bad dyam áde ádé. ");
INSERT INTO bssNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Dɔ́ɔ bélāŋgē mɔ́ bán, “Yesuɛ, mod a Nazarɛt mɔ́ atóme nɛ̂.” ");
INSERT INTO bssNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Hɛ́ɛ ábóné aá, “A-Yesu, Mwǎn a mbyaa ḿme Dabidɛ, wóg mɛ ngɔl!” ");
INSERT INTO bssNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bad ábe bémbɛ̄ áʼsō bénkānē mɔ́ áte, bélāā mɔ́ bán ádib nsəl. Boŋ mɔ́-ʼɛ ambɛ́ ábōnē aá, “A-Mwǎn a Dabid, wóg mɛ ngɔl!” ");
INSERT INTO bssNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Dɔ́ɔ Yesuɛ átyéémé, boŋ áhɔ̄bē aá béhyɛɛne ane mod. Ane mod apedé-ʼaá mɔ́ bɛnbɛn, Yesuɛ ásɛdté mɔ́ aá, ");
INSERT INTO bssNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Cheé éhɛdɛɛ́ wɛɛ́, ḿbɛle wɛ?” Mɔ́-ʼɛ anhɔ́b aá, “A-Sáŋ, bɛ̌l ńnyínɛn ámpē.” ");
INSERT INTO bssNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Dɔ́ɔ Yesuɛ-ʼɛ álāŋgē mɔ́ aá, “Nyínɛ́n-nɔ̄! Adúbe ádôŋ ádídé wɛ bwâm.” ");
INSERT INTO bssNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ábwɔ̄g-ábwɔ̄g ambootéd anyínɛn, áhīdē-ʼɛ mɔ́, ábagé Dyǒb mekɛnag. Áde ene ndun e mod ényíné nɛ̂, bɔ́mpē bêmbootéd Dyǒb akémed. ");
INSERT INTO bssNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesuɛ ampǒŋ á dyad á Jeriko, boŋ atóméʼáá tómɛ́n. ");
INSERT INTO bssNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mod nhɔ́g-kɛ abédé áwed bán Sakio, abédé-ɛɛ́ nlad-é-táásɛ ambáá, abɛ́-ʼɛ nhɔn ḿ mod. ");
INSERT INTO bssNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ahɛdéʼáá aá mɔ́nyîn ane mod awe béchəgɛɛ́ Yesuɛ, boŋ nzii enkêmbagnédté mɔ́, ngáne amute démbɛ̄ɛ̄ áhed, mɔ́-ʼɛ ambɛ́ esóŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hɛ́ɛ ányə́gté áʼsō boŋ áchə̄gkē bwɛl éʼ sikamɔ âbɛl boŋ ányîn Yesuɛ. Yesuɛ ahúɛ́ʼáá ene pɛd. ");
INSERT INTO bssNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Apedé-ʼaá áhed, boŋ aá mɔ́sad dǐd ámīn, ányīnē Sakiosɛ. Dɔ́ɔ álâŋgɛɛ́ mɔ́ aá, “Á-Sakios, sǔd ásē á mehélé-te. Ntə́ŋgɛ́né nken abɛ́ áwôŋ ndáb chii.” ");
INSERT INTO bssNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Hɛ̂ dɔ́ɔ Sakiosɛ ásúdé ásē ésebán abébte póndé, boŋ ákobé Yesuɛ nken ne menyiŋge mésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bad bésyə̄ə̄l ábe bényīn nɛ̂, bényóŋgéʼáá áte bán, “Akií nken abɛ á ndáb wɛ́ɛ mod awe adé mbɛlé-mbéb.” ");
INSERT INTO bssNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakiosɛ antyéém ámīn, álāŋgē Sáŋgwɛ́ɛ́ aá, “Nɔnéʼ, a-Sáŋ, mɛ̌tēd nhɔn ḿmêm, ńkab mɔ́ áte eʼpɛd éʼbɛ, ḿbɛ́ epɛd ehɔ́g wɛ́ɛ betóótōkɛ̄ bé bad. Nzé édé-ʼɛ bán nkǒbné mod kéchéé á edoké-te, mɛ̌timtéd mɔ́ chɔ́ ámbīd ngen éniin.” ");
INSERT INTO bssNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Boŋ Yesuɛ mɔ́-ʼɛ anláá mɔ́ nɛ́n aá “Á epun é bǐn éʼ chii, eʼsoósoŋ éʼbágnédé ne enɛ́n ndáb. Anɛ́n mod mɔ́mpē adíī mwǎn a Abraham. ");
INSERT INTO bssNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mwǎn-a-Moonyoŋ apedé âbɛl boŋ âhɛd bad ábe bébɔ́ɔ́, âchood-tɛ bɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bad béwóglánnáá chǒm-ɛ́ɛ Yesuɛ áhɔ́béʼáá. Yesuɛ ammǎd apɛ bɛnbɛn ne dyad á Jerusalɛm. Né-ɔɔ́ béwēmtān bán nkamlɛn ń Dyǒb mɛ́pɛ̌ ábwɔ̄g-ábwɔ̄g. ");
INSERT INTO bssNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hɛ́-ʼaá áhɔ́bɛɛ́ aá, “Kunze e mod pɔ́g eladéʼáá yə̌l âkɛ ekɛ á aloŋ áde áchábnédé âbɛl nɛ́n béwɔ́ged mɔ́ kə̂ŋ, boŋ ásūɛʼ. ");
INSERT INTO bssNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Áde ákagké, anchɛ́lé ábē bembəledɛ dyôm, ábagé nhɔ́g tɛ́ɛ́ ekə́lé é kábpe dyôm aá, ‘Nyétêd nɛ́n, nyékábe nyoŋgé kə́ə́ŋ ne á póndé echě mɛ́hūūʼɛ́.’ ");
INSERT INTO bssNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Boŋ ádē aloŋ á bad dénkêndəŋgé mɔ́. Bénlōm mésɛ́nzɛ âhíd mɔ́ âláa ngɔ́menaa bán, ‘Séēkobɛɛ́ bán anɛ́n mod ábɛ̂ echɛd kə̂ŋ.’ ");
INSERT INTO bssNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ké nɛ̂ bêmbɛl mɔ́ kə̂ŋ, átīm-mɛ ámbīd áwē dyad. Áde áhúú, ábwɔ̄g-ábwɔ̄g anlóm ábē bembəledɛ ábe âmbagké ngáb achəg âbɛl boŋ ábíi nsyə́ŋ ḿme békúdé á nyoŋgé-te. ");
INSERT INTO bssNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Aʼsó ampɛ̌ ahɔ́b aá, ‘A-Sáŋ, échoŋ ekə́lé dyôm échyáá nsyə́ŋ ḿme ńdé ngen dyôm.’ ");
INSERT INTO bssNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ane mod anláá mɔ́ aá, ‘Nɛ̂ ábóó, edíī mbəledɛ a bwâm! Ngáne éhɛ́lé mekan mésad alyə́ged ngáne éhɛdnadté, mbage wɛ ngíne âkamlɛn myad dyôm.’ ");
INSERT INTO bssNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mbəledɛ awě alóntɛ́né bébɛ mɔ́mpē ampɛ̌ ahɔ́b aá, ‘A-Sáŋ, échoŋ ekə́lé dyôm échyáá nsyə́ŋ ḿme ńdé ngen éʼtáan.’ ");
INSERT INTO bssNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ane mod anláá ane ámpē aá, ‘Wɛ̌kamlɛ́n myad métáan.’ ");
INSERT INTO bssNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Dɔ́ɔ mbəledɛ ampée ápédé boŋ áhɔ̄bē aá, ‘A-Sáŋ, áboŋ eʼkə́lé dyôm wɛ bɛ́n. Menkaŋ bɔ́ á wáŋgesɛ-tê, ńkoo. ");
INSERT INTO bssNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mbááʼáá mɛ ngɛ́, ngáne mbíí bwâm mɛɛ́, échoŋ chǒm éhūnɛ̄ɛ̄ á ndɔɔb. Weébɛ̄lɛ̄ɛ̄ boŋ edyâg, ehúde-ʼɛ wɛ́ɛ wéēwēnɛɛ́.’ ");
INSERT INTO bssNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Hɛ́ɛ ane mod átimtanné ane mbəledɛ aá, ‘Ḿmōŋ nsəl měn mɔ́ɔ̄ mɛ́wūū wɛ. Ebébtéd é mbəledɛ nɛ́ɛ wɛ. Nɛ́ɛ emǒŋ émáá abíi wɛɛ́, échêm chǒm éēhūnɛ̄ɛ̄ á ndɔɔb, ebíí-ʼɛ wɛɛ́, meébɛ̄lɛ̄ɛ̄ boŋ ńdyâg. Nɛ́ɛ ébíí wɛɛ́ nhúde-ʼɛ wɛ́ɛ méēwēnɛ̄ɛ̄, ");
INSERT INTO bssNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","cheé-ɔ̄ ênkə̌ŋ boŋ weehéde echem ngáb á ndáb echě bad békoŋgɛɛ́ ngáb, âbɛl boŋ nzé ńhúú ńkob chɔ́ ne nsyə́ŋ ámīn?’ ");
INSERT INTO bssNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Hɛ́ɛ álâŋgɛɛ́ bad ábe béntyēēm á nkəg áhed aá, ‘Nyékobɛn mɔ́ ábê eʼkə́lé dyôm, nyébag bɔ́ wɛ́ɛ mod awě awóó mbwɔ́kɛl e ekə́lé.’ ");
INSERT INTO bssNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ábê bad bɔ́-ʼɛ bénlāā mɔ́ bán, ‘A-Sáŋ, ane mod amaá mbwɔ́kɛl e ekə́lé awóŋ!’ ");
INSERT INTO bssNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Hɛ́ɛ ane mod átimtanné bɔ́ aá ‘Ńláa nyé mɛɛ́, kénzɛ́ɛ́ awě awóó, Dyǒb dɛ́bād mɔ́ abɛ. Boŋ ane awě mɔ́-ʼɛ eewóo, Dyǒb dɛ́kobɛ́n mɔ́ kə́ə́ŋne mwǎmpīn awě awóó. ");
INSERT INTO bssNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Boŋ bad ábe békɔ́ɔ́ mɛ, ábe béehɛdeʼaá bán ḿbɛ̂ echab kə̂ŋ, nyéhyɛɛne bɔ́ hɛ́n. Béwúu bɔ́ áwem eʼsó hɛ́n.’ ” ");
INSERT INTO bssNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesuɛ amaá-ʼaá enɛ́n pɔ́le akal, abwɔ́gé ásē ámpē, âkɛ á Jerusalɛm. ");
INSERT INTO bssNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Áde ákwógé apɛ á myad mé Bɛtpeg ne Bɛtani á Ekone é Menzab, anlóm bembapɛɛ bébɛ aá, ");
INSERT INTO bssNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Nyékɛ á dyad áde ádé á mǔdɛ ḿmíníí. Nzé nyêpedé á nló ń dyad nyɛ́ɛ̄nyīn ngáne bétə́ŋgé mwǎn a ésɛl awě mod éēdīīdɛ̄ɛ̄ mbêd. Nyéhune mɔ́, nyéhyɛɛne hɛ́n. ");
INSERT INTO bssNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nzé mod asɛ̌dté nyé aáken, cheé ékə́ə́ boŋ nyéhunné chɔ́, nyéláa mɔ́ nɛ́n bán, ‘Sáŋgwɛ́ɛ́ atógnɛ́né chɔ́.’ ” ");
INSERT INTO bssNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bad ábe ánlōmmē békíí-ʼaá, bétān-nɛ chɔ́ melemlem ngáne ánlāāʼɛ́ bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Áde béhunnɛɛ́ ésɛl, bewóŋ bênsɛdéd bɔ́ bánken, “Cheé ékə́ə́ boŋ nyéhunné échê ésɛl?” ");
INSERT INTO bssNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bɔ́-ʼɛ bénhɔ̄b bán, “Sáŋgwɛ́ɛ́ atógnɛ́né chɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Hɛ́ɛ bépɛ́ɛ́né chɔ́ wɛ́ɛ Yesuɛ. Bêntǎl échab mbɔ́té áwedé-mîn, boŋ béchə̄gtē Yesuɛ áwedé-mîn. ");
INSERT INTO bssNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Áde ábóótédé akɛ, bad bétánléʼáá mɔ́ échab mbɔ́té á nzii-tê. ");
INSERT INTO bssNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Áde ábóótédé Ekone é Menzab asyɔge âsɔ́l á Jerusalɛm, ndun e bembapɛɛ embootéd abwɛɛn ámīn ne menyiŋge, békɛné Dyǒb ne esaád áyə̄le ndəle é mekan ésyə̄ə̄l éche bényíné, ");
INSERT INTO bssNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Béhɔ̄bē bán, “Nnam ne kə̂ŋ echě epag á dǐn áde Sáŋgwɛ́ɛ́! Nsaŋ ḿbɛ̂ ádyōb, Ehúmé ébɛ̂-ʼɛ ne Dyǒb áde ádé sɛ ámīn!” ");
INSERT INTO bssNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nguse é Befarisia éche énsɔ̄blɛ̄n amute á bad áte bénlāā Yesuɛ bán, “A-meléed, láá ábôŋ bembapɛɛ bélâm!” ");
INSERT INTO bssNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mɔ́-ʼɛ antimtɛ́n bɔ́ aá, “Ne mbále, nzé ábén bad bédíbé nsəl, né meláá múmɔ́ mɛ́bootéd abón.” ");
INSERT INTO bssNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Áde Yesuɛ ápédé á nkəg ń dyad á Jerusalɛm, annyín dyad áʼsō. Dɔ́ɔ mésɔd mébóótédé mɔ́ abíd á mǐd, áchyɛɛ́ʼ Jerusalɛm ");
INSERT INTO bssNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","aá, “Êmbǒŋ bán nyébíi mekan ḿme mépɛɛne nsaŋ. Boŋ bɔɔb, nyéēhɛ̄lɛ̄ɛ̄ mɔ́ anyín. ");
INSERT INTO bssNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Eʼpun éʼ bǐn éʼhúɛ nyé áʼsō á póndé echě bad ábe békɔ́ɔ́ nyé bɛ́ləŋnédté nyé nkúmbág nɛ́ɛ eʼkɛ́, bébentɛ́n-nɛ nyé pɛd ésyə̄ə̄l, ");
INSERT INTO bssNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","boŋ bémad nyé, nyáābe ábɛn bǎn moosyəə́l. Aláá ké ahɔ́g déelyəgké ásē áyə̄le nyênkênchemmé póndé echě Dyǒb ápédé âsoŋ ádɛ́n aloŋgé.” ");
INSERT INTO bssNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesuɛ ansɔ́l á Ndáb-e-Dyǒb, ábootéd bad ábe bésóméʼáá bwěm áwēd-te ananted, ");
INSERT INTO bssNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","álāŋgē bɔ́ aá, “Éténlédé á kálag e Dyǒb nɛ́n bán Dyǒb áhɔ́bé aá ‘Echem ndáb ěbɛ̄ ndáb e mekáne.’ Boŋ nyêtimté chɔ́ mbwɔg mé bechîb.” ");
INSERT INTO bssNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Bootya nɛ̂, Yesuɛ ayə́gtéʼáá bad á Ndáb-e-Dyǒb. Beprisɛ bémbáá ne bemeléede bé mbéndé bɔ́ɔbɛ belyə́ged bé dyad, bɔ́-ʼɛ béhɛdé nzii eche béwúɛʼɛ́ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nzii-ʼɛ eebédɛɛ́ bɔ́ âbɛl dyam ádíi dyam, áyə̄le moosyəə́l andə̌ŋ eʼyale ábe Yesuɛ awóg ne kə́n esyəə́l. ");
INSERT INTO bssNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mbwɛ nhɔ́g Yesuɛ ambɛ́ á Ndáb-e-Dyǒb áyə̄gtē bad, ákanlé-ʼɛ bɔ́ nkalaŋ ḿ bwâm. Hɛ́ɛ beprisɛ bémbáá, bemeléede bé mbéndé ne bad bémbáá bé dyad, bépédé áwē, ");
INSERT INTO bssNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","boŋ bésɛdté mɔ́ bánken, “Láá sé, kunze ehéé éwóó âbɛl ḿmɛ́n mekan? Nzɛ́-módɛ́ abagé-ʼɛ wɛ enɛ́n kunze?” ");
INSERT INTO bssNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Dɔ́ɔ Yesuɛ átimtanné bɔ́ aá, “Mɛ́mpē mɛɛ́sɛdéd nyé dyam ahɔ́g; nyéláa mɛ ");
INSERT INTO bssNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","wɛ́ɛ kunze echě Jɔnɛ ádúsánnáá bad émbīdtē, wɛ́ɛ Dyǒb, káa wɛ́ɛ moonyoŋ?” ");
INSERT INTO bssNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Běn ne běn bêmbootéd atâŋtɛn bán, “Nzé dehɔ́bé bán, ‘Jɔnɛ echě kunze enhúú ne Dyǒb,’ né ǎsɛdéd syánē aáken, ‘Cheé-ɔ̄ enkə̌ŋ boŋ nyénkêndúbé mɔ́?’ ");
INSERT INTO bssNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Boŋ nzé dehɔ́bé bán, ‘Echě kunze ehúú ne baányoŋ,’ né ábén bad bésyə̄ə̄l bɛ́lūm syánē meláá, áyə̄le béndūbē bán, Jɔnɛ abédɛ́ɛ nkal éʼdəə́dəŋ.” ");
INSERT INTO bssNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Hɛ̂ dɔ́ɔ bétímtɛ́né mɔ́ bán, “Séebíiʼɛ́ wɛ́ɛ ene kunze émbīdtē.” ");
INSERT INTO bssNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Né ké mɛ-ʼɛ ámpē méelááʼɛ́ nyé kunze echě ńwóó âbɛl ḿmɛ́n mekan.” ");
INSERT INTO bssNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Hɛ́ɛ Yesuɛ ákanlɛɛ́ bad ngan nɛ́n aá, “Mod nhɔ́g ambɛ́, ankwɛ̌l nzag e eʼpum é mɛl ábe bébɛnlɛɛ́ mǐm. Ambɛ̌ ene nzag wɛ́ɛ bad ábe bɔ́bɔ̄ɔ bɛ́kǎb mbote áte, ákɛ̄ ekɛ á aloŋ démpēe, ábēm-mɛ áwed. ");
INSERT INTO bssNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Póndé epedé-ʼaá eche bépádɛɛ́ eʼpum, boŋ álōmē mbəledɛ wɛ́ɛ bebɛl-bé-nsɔ́n, âkobe mɔ́ ádē asii dé eʼpum. Hɛ́ɛ ábê bebɛl-bé-nsɔ́n béwānnē ane mbəledɛ, bésúúd-tɛ mɔ́ ámbīd ne mekáá mé ngɛ̂n. ");
INSERT INTO bssNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Anlóm mbəledɛ ampée, boŋ bêmbɔ̌m ane mɔ́mpē, béwōgēd mɔ́ eʼsôn bwâmbwam, bésúúd-tɛ mɔ́mpē ámbīd ne mekáá mé ngɛ̂n. ");
INSERT INTO bssNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ambɛ́ alóm awě alóntɛ́né béláán. Awed bénlɔ̄gɛ̄n, bébwém-mɛ mɔ́ ámbīd e eʼkɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Hɛ́ɛ nwóó-nzag ádolé áte chóóŋ, boŋ áhɔ̄bē aá, ‘Chán-nɔ̄ mɛ́bɛnlé bɔɔb? Mɛ̌lōm awem mwǎn awě ńdə́ə́ bwâmbwam. Kapɔ́g bɛ́bɛ mɔ́ edúbé.’ ");
INSERT INTO bssNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Boŋ áde bebɛl-bé-nsɔ́n bényíné mɔ́, bênnɔnɛ́n á mesó, béhɔ́b bán, ‘Ndyɛ́-a-mbwɔ́g mwěn nɛ́n. Déwúu mɔ́, âbɛl eche mbwɔ́g ésuuned syánē?’ ");
INSERT INTO bssNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Dɔ́ɔ bébídné mɔ́ á nzag-tê, boŋ béwūɛ̄-ʼɛ mɔ́.” Hɛ́ɛ Yesuɛ ásɛdtɛɛ́ aáken, “Bɔɔb-pɔɔ́, cheé nwóó-nzag ábɛnlé bɔ́? ");
INSERT INTO bssNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ǎpɛ̌ awúú bɔ́, ábɛ̄-ʼɛ ene nzag wɛ́ɛ bebɛl-bé-nsɔ́n bémpēe.” Awóg áde bad béwógé nɛ̂, bénhɔ̄b bán, “Ene ndín e dyam eébɛnlád mbéb!” ");
INSERT INTO bssNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesuɛ annɔn bɔ́ á mesó, ásɛdté bɔ́ aáken, “Chán nyésóŋtɛ́né eyale é Dyǒb éche éténlédé bán, ‘Aláá ádě belóŋ-bé-ndáb bênchenɛɛ́ dɔ́ɔ átímé aláá dé etógnɛ́n abɛ́.’ ");
INSERT INTO bssNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mod ké ahéé awě ǎlūm ádê aláá ámīn ǎbōgtēd áte. Boŋ mod awě dɛ́hūntēdtē ámīn, ǎnyogtéd áte átīm mbúmbú.” ");
INSERT INTO bssNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bemeléede bé mbéndé ne beprisɛ bémbáá bénhɛ̌d nzii eche békóbɛɛ́ Yesuɛ ábwɔ̄g-ábwɔ̄g, ngáne bênchemmé bán áyə̄le echâb dɔ́ɔ ákálé enɛ́n ngan. Boŋ bémbāŋ bad ábe bébédé áhed. ");
INSERT INTO bssNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Né-ɔɔ́, bemeléede bé mbéndé ne beprisɛ bémbáá béhɛ́déʼáá kəse e etə́l, âkób mɔ́. Bêmpwɛ̌d bad, bésábé bɔ́, bélóm bɔ́ âhíd mɔ́. Ábê bad béntə̄ŋgɛ̄n ábântɛn nɛ́n bán, béhíde mɔ́ ne nlém nhɔ́g, âbɛl boŋ békób mɔ́ awusé á nsəl, boŋ ene póndé bébɛ́ mɔ́ á mekáá mé ngɔ́menaa a Roma awě adé á nkamlɛn. ");
INSERT INTO bssNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Hɛ́ɛ bad ábe bénlōmmē nɛ̂ bélâŋgɛɛ́ Yesuɛ bán, “A-meléed, sêbíí bán ehɔ́beʼ, eyə́gte-ʼɛ mam ḿme métə́ŋgɛ́né. Weékwognádté modmod. Eyə́gte-ʼɛ bad mekan mé Dyǒb á nyaa echě etə́ŋgɛ́né bwâm. ");
INSERT INTO bssNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Mbéndé eche syánē ehɔ́be nɛ́n bán désaŋgeʼ táásɛ wɛ́ɛ Kaisɛɛ, kə̂ŋ e Roma-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Boŋ Yesuɛ anchem bɔ́ akwâb. Hɛ́ɛ álâŋgɛɛ́ bɔ́ aá, ");
INSERT INTO bssNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nyélúmed mɛ mɔné mé ekii. Ediídiŋgɛ éche nzɛ́ɛ́ chɛ́n, dǐn áde nzɛ́ɛ́-ʼɛ dɛ́n?” Bêntimtɛ́n mɔ́ bán, “Dǐn ne eʼsó ábe Kaisɛɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Dɔ́ɔ Yesuɛ áhɔ́bɛɛ́ aá, “Nyébag-kɔɔ́ Kaisɛɛ éche édé éche Kaisɛɛ, nyébag-kɛ Dyǒb éche édé é Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bɔɔb-pɔɔ́, nzii ké pɔ́g enkêmbáá eche bɛ́kōbɛ̄nnē mɔ́ pɔ́le e awusé á nsəl. Né-ɔɔ́, béndǐb ḿmāb nsəl ngáne dyam dénkêmboŋgé bɔ́ ahɔ́b. Nyaa eche Yesuɛ ántimtɛ́nné bɔ́ enkɔ́méd bɔ́ yə̌l áte. ");
INSERT INTO bssNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Doŋge á Besadusia bêmpɛ̌ wɛ́ɛ Yesuɛ. Besadusia béndūbē bán mpuu méesaá ámbīd e kwééd. ");
INSERT INTO bssNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Dɔ́ɔ béhɔ́bɛɛ́ bán, “A-meléed, mbéndé e Mosɛɛ ehɔ́be nɛ́n bán, ‘Nzé mod awóó mmwaád, boŋ awédé áde bɔ́ ane mmwaád béepedɛɛ́ mwǎn awále, mwǎnyaŋ a abum ahɔ́g atə́ŋgɛ́né ane nkúd awóŋ, âbɛl boŋ dǐn áde mwǎnyaŋ déēbɔ̄ɔ̄ʼ.’ ");
INSERT INTO bssNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bɔɔb-pɔɔ́, bad bébédé mod saámbé ábe bémbīd abum ahɔ́g. Mod aʼsó anwóŋ mmwaád boŋ awɛ́ áde bɔ́ mmwaád ne béepedɛɛ́ bán awále. ");
INSERT INTO bssNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mod awě anlóntɛ́n bébɛ anwóŋ ane mmwaád. Mɔ́mpē awɛ́ ésebán achyáá mwǎn. ");
INSERT INTO bssNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ámbīd é póndé awě anlóntɛ́n béláán mɔ́mpē anwóŋ mɔ́, kə́ə́ŋ bɔ́ mod saámbé bébom mɔ́ awóŋ, nhɔ́g ámbīd a aníníí. Boŋ bɔ́ mod ké nhɔ́g bénkênchyáá mwǎn ne ane mmwaád, kə́ə́ŋ bɔ́ moosyəə́l béwɛ́-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kə́ə́ŋne á asóg ane mmwaád mɔ́mpē anwɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Bɔɔb-pɔɔ́ á póndé e mpuu, mmwaád awě nzɛ́ɛ́ ane mmwaád áchəgnédté áyə̄le bɔ́ moosyəə́l saámbé bénwōŋ mɔ́?” ");
INSERT INTO bssNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Dɔ́ɔ Yesuɛ átimtanné bɔ́ aá “Á póndé eche dédíí áte nɛ́n chii, bebaád ne baachóm béwôŋneʼ. ");
INSERT INTO bssNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Boŋ bad ábe békwógnédé âbɛ́ á mpuu á kwééd boŋ bésɔ́n-lɛ á aloŋgé dékɔ̄ɔ̄lē béēwōŋnɛ̄ɛ̄. ");
INSERT INTO bssNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bɛ́bɛ̄ɛ̄ nɛ́ɛ ángɛl, béewág-kaá ámpē. Apuu áde bɛ́puúʼɛ́, bǎn bé Dyǒb bɔ́ɔ bɛ́bɛ̄ɛ̄. ");
INSERT INTO bssNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mosɛɛ mwěn ámpē alúmté áte aá, bad bépuudeʼ. Wɛ́ɛ Mosɛɛ átélé á Kálag e Dyǒb aá, mwǎ bwɛl akóbé muú, achəgé Sáŋgwɛ́ɛ́ áhed aá, Dyǒb áde Abrahamɛ, Dyǒb áde Aisigɛ ne Dyǒb áde Jakɔbɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dyǒb ádíi Dyǒb á bad ábe bédé á aloŋgé, saké Dyǒb á bad ábe béwédé. Nɛ̂ děn álûmte bán ne Dyǒb, bɔ́ moosyəə́l bédé á aloŋgé.” ");
INSERT INTO bssNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Doŋge dé bemeléede bé mbéndé bénhɔ̄b bán, “A-meléed, chǒm éche éhɔ́bé étə́ŋgɛ́né.” ");
INSERT INTO bssNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Né-ɔɔ́ modmod enkênchuʼɛ́ mɔ́ dyamdyam asɛded ámpē. ");
INSERT INTO bssNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Hɛ́ɛ Yesuɛ ásɛdtɛɛ́ bɔ́ aáken, “Cheé ékə́ə́ boŋ bad béhɔ̄bē bán Ane-awě-Béwɔ́gté abídé á mbyaa ḿme kə̂ŋ Dabidɛ?” ");
INSERT INTO bssNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ngɔ́mē Dabidɛ mwěn ahɔ́bé á Kálag e Ngəse aá, “Sáŋ Dyǒbɛ anláá awêm Sáŋgwɛ́ɛ́ aá, ‘Dyɛɛ́ áwêm ekáá émbáá, ");
INSERT INTO bssNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kə́ə́ŋ ne á póndé echě mɛ́bɛnlé boŋ ékɔgtéd ábōŋ bad bé ekɔyí ámīn ne mekuu.’ ");
INSERT INTO bssNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nɛ́ɛ Dabidɛ mwěn ásébpé mɔ́ achəg aá Sáŋgwɛ́ɛ́, chán-nɔ̄ Ane-awě-Béwɔ́gté áhɛlɛɛ́ abɛ́ awe mwǎn?” ");
INSERT INTO bssNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bad bésyə̄ə̄l béwógéʼáá chǒm éche Yesuɛ áhɔ́bɛɛ́. Hɛ́ɛ álâŋgɛɛ́ bembapɛɛ, aá, ");
INSERT INTO bssNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Nyétédɛn bemeléede bé mbéndé póndé. Bédəə mengombe ahyɔ́mɛn áte, bédəə-ʼɛ bán bad bélɛnte bɔ́ á dyɔn-tê ne edúbé. Bédəə metii mé edúbé adyɛ́ á ndáb e mekáne ne á hǒm á ngande. ");
INSERT INTO bssNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Boŋ bɔ́ɔ bédumeʼ mbwɔ́g é bekúd, bédogé-ʼɛ bad ne ntóŋ-ntóŋ mé mékáne. Échê nyaa é bad ékǔd nkɔ́gsɛn ḿme ńchábé ámīn.” ");
INSERT INTO bssNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Áde Yesuɛ ásádé dǐd, anyín nɛ́ɛ behɔn bé bad béhāgkē mɔné á ntyə́g mé mendɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Annyín-nɛ ntógétōke a nkúd a mmwaád nhɔ́g ahâg bedə́lɛɛ bébɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Hɛ́ɛ áhɔ́bɛɛ́ aá, “Á mbále, nlâŋge nyé mɛɛ́, ḿmɛ́n ntógétōke mé mmwaád ńhédé mendɛ á ntyə́g-te tómaa bɔ́ moosyəə́l. ");
INSERT INTO bssNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Mɔné ḿme ábɛ̂ bad béhédé, ndíi mɔné ḿme ńchɔ́bé bɔ́ ásē, boŋ anɛ́n mmwaád ne atóg áde ádíí ahédé mɔné ńsyə̄ə̄l ḿme áwóó, ńsyə̄ə̄l ḿme ámbɛ̄ɛ̄ atɔgnan yə̌l.” ");
INSERT INTO bssNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bembapɛɛ behɔ́g békáléʼáá ngáne Ndáb-e-Dyǒb ébóó, ngáne bélóŋné chɔ́ kəse é meláá, boŋ bénābē-ʼɛ chɔ́ áte ne mendɛ ḿme bad bésáŋgé. Hɛ́ɛ Yesuɛ áhɔ́bɛɛ́ aá, ");
INSERT INTO bssNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ábɛ́n bwěm ábe nyényínɛɛ́ nɛ́n, póndé ěpɛ̌ echě aláá ké ahɔ́g déelyəgké ámīn e waáb. Bɛ́pāŋtēd mɔ́ áte mésyə̄ə̄l.” ");
INSERT INTO bssNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bênsɛdéd mɔ́ bán, “A-meléed, súútə́ŋ nɛ́n dɛ́bɛnlédté? Eʼchemléd éʼhéé bɛ́lūmēd bán nɛ́n áhɛde abɛnled?” ");
INSERT INTO bssNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesuɛ antimtɛ́n bɔ́ aá, “Nyétêd póndé nɛ́n mod eépuutád nyé. Ekud é bad épɛ̌, á dǐn ádêm, bédogé nyé, mod tɛ́ɛ́ aá mɔ́ɔ mɔ́dē Ane-awě-Béwɔ́gté, béhɔ̄bē bán eʼpun bé asóg éʼpédé áte. Boŋ nyéehídé bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nzé nyêwógé-ʼɛ bán bel éʼwantɛʼ, káa bán ekíde épáŋgé áte, modmod eebááʼ. Ḿmɛ́n mekan mésyə̄ə̄l métə́ŋgɛ́né abɛnled, boŋ saké mɔ́ mɛ́lūmēd bán, asóg ámáá apɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Hɛ́ɛ álâŋgɛɛ́ bɔ́ aá, “Aloŋ ahɔ́g dɛ́tyēēmɛ̄n ádíníí nzum. Nkamlɛn nhɔ́g-kɛ ńtyēēmɛ̄n ḿmíníí. ");
INSERT INTO bssNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ndɔɔb eénəŋnéd ásē ngíne-ngíne. Nzaa ne nkole bɛ́bē hǒm ásyə̄ə̄l. Mekan ḿme mébâŋte bad mɛ́bɛ̄. Eʼchemléd éʼmbáámbāa bɔ́mpē bɛ́bīd ádyōb. ");
INSERT INTO bssNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ḿmɛ́n mésyə̄ə̄l médɛ̂bɛnléd, bɛ́hɛ̄ nyé abum ámīn, bétagté nyé. Bɛ́kɛɛ́n nyé á ndáb é mekáne, békáád nyé áwed, béhɛ́-ʼɛ nyé á mbwɔg. Nyébíi-ʼɛ bán, bɛ́pɛɛ́n nyé áʼsō éʼ kə̂ŋ é bad ne benkamlɛnɛ áyə̄l e dǐn ádêm. ");
INSERT INTO bssNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nɛ̂ dɛ́bɛ nyé etə́l póndé eched, âláa bɔ́ mekan mésyə̄ə̄l ḿme nyésóŋtɛ́né á yə̌l echêm. ");
INSERT INTO bssNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Né-ɔɔ́, nyémad á nlém tê ngen pɔ́g bán nyéetə̂ŋgɛnɛɛ́ atag áte ngáne nyɛ́kāāʼɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mměn mɛ̌bɛ nyé dyam áde nyɛ́hɔ̄bpē ne debyɛ́ɛ́ áde nyɛ́hɔ̄bɛ̄nnē dɔ́, nyaa echě ábɛ̄n bad bé ekɔyí béehɛnlé nyé atyéemɛn. Béehɛ̌l-laá ahɔ́b bán dyam áde nyéhɔ́bɛɛ́ déetə̂ŋgɛnɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kə́ŋne besóó ne benyoó, bɔ́ɔbɛ ábɛn baányaŋ ne bɛ̌n, běn bɛ́palé nyé áte, béwúú-ʼɛ nyé nguse é bad. ");
INSERT INTO bssNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bad bésyə̄ə̄l bɛ́kɔɔ́ nyé áyə̄le dǐn ádêm. ");
INSERT INTO bssNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ké nɛ̂, dyamdyam déebɛnlé nyé, ké mbum e esid pɔ́g éebɔ́ɔ́ʼɛ́ nyé á nló. ");
INSERT INTO bssNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nyékaŋ nlém âbɛl nyékud eʼsoósoŋ.” ");
INSERT INTO bssNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesuɛ anláá bembapɛɛ aá, “Á póndé eche nyɛ́nyīnnē sə́nze élə́ŋnédé dyad á Jerusalɛm, dɔ́ɔ nyɛ́bīīʼɛ́ bán ekíde éhɛde apâŋted áte. ");
INSERT INTO bssNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nzé nyênyíné nɛ̂, bad ábē bédé á Judeya bétôm mehélé békɛ bésɔɔm á eʼkone mîn. Ane awě adé á dyad-tê wê, ábôl. Awě mɔ́-ʼɛ adé ámbīd e ebwɔ́g eétɔgné mɔ́ asɔ́l á dyad á Jerusalɛm. ");
INSERT INTO bssNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Áyə̄le nɛ́n, ḿmê mesú ḿme ńhɔ́bɛɛ́ nɛ̂, médíi eʼpun bé nkɔ́gsɛn. Póndé eched dɔ́ɔ mekan ḿme méténlédé ásē mɛ́lōnnē. ");
INSERT INTO bssNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ébɛ̄ ebébtéd ne bebaád ábe bɛ́bē nkog ne ábe bɛ́mwāŋtē ḿmê mesú. Áyə̄le nɛ́n, metake híin mɛ́bɛ̄ á nkǒŋsé-te, enɛ́n nyoŋgɛl e bad ěkǔd-tɛ metuné bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ádɛ́n aloŋ á bad dɛ́wɛ̄ á bel-tê. Bɛ́kōb nguse é bad nɛ́ɛ betâŋ, békɛ̄ɛ̄n bɔ́ á meloŋ mémpēe. Bad ábe béesɛ̌ bad bé Israɛl bɛ́kɔgtéd dyad á Jerusalɛm áte, kə́ə́ŋ né póndé echě Dyǒb átíínédé bɔ́ émaá áte. ");
INSERT INTO bssNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Etondɛɛ bɔ́ɔbɛ ngɔn ne betintinɛ bɛ́lūmēd eʼchemléd. Edíb é nkwɛ̌ édǔm áte, étɔg nɛ́ɛ ahóbpɛ dé edíb. Nɛ́n dɛ́kōbēd bad bé meloŋ mé nkǒŋsé mbwɔ́g kə́ə́ŋ béēbyɛ̄ʼ nɛ́ɛ bébɛlɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bad bépimɛ́n ne mbwɔ́g ń ngíne áyə̄le ebébtéd éche éhúɛ á nkǒŋsé, ngíne-ʼɛ éche édé ámīn énəŋnéd á eʼdii. ");
INSERT INTO bssNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ene póndé dɔ́ɔ bɛ́nyīnnē nɛ́ɛ Mwǎn-a-Moonyoŋ áhúɛʼɛ́ á mbag-tê ne ngum ne ehúmé é ngíne. ");
INSERT INTO bssNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Á póndé eche nyɛ́nyīnnē nɛ́ɛ ḿmɛ́n mekan mébóótédé abɛnled, nyétyéem ámīn, nyésād dǐd, áyə̄le nɛ́n póndé e eʼsoósoŋ emaá nyé apɛ áte.” ");
INSERT INTO bssNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ bɔ́ ene ngan, aá, “Nyênɔn alín á ngəl bwâm, káa bwɛl ké éʼhéé bémpēe. ");
INSERT INTO bssNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Abíd áde byaá éʼbootadté bɔ́ abíd, nyéběn nyêbɛle nyêbíí bán nchoŋ ḿmáá abɛ́ bɛnbɛn. ");
INSERT INTO bssNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Melemlem nzé nyênyíné ḿmɛ́n mekan mésyə̄ə̄l mébɛnlad, nyébíi nɛ́n bán, nkamlɛn ń Dyǒb ńkwógé apɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, enɛ́n nyongɛl e bad éemaáʼɛ́ kə́ə́ŋne ḿmɛ́n mekan mésyə̄ə̄l mémáá abɛnled. ");
INSERT INTO bssNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nkoŋ ḿ mín ne nkǒŋ ńsé bɛ́maá boŋ ábêm eʼyale bɛ́bē abɛ́ ne abɛ́. ");
INSERT INTO bssNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Nyêtóo nɛ́n nyéetómté echɛn póndé esyəə́l âdyɛ́ ndyééd ne âmwɛ́ mǐm bwâmbwam. Nyéēbūdē-ʼɛ atag áte áyə̄le mekan mé aloŋgé. Nzé nyêbɛle nɛ̂, né échê epun étān nyé təléd nɛ́ɛ melám. ");
INSERT INTO bssNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Epun éched épií moonyoŋ asyəə́l awě adé á nkǒŋsé. ");
INSERT INTO bssNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nyétêd póndé, póndé ésyə̄ə̄l. Nyékânne bán nyéwôŋ ngíne âtóm ḿmɛ́n mekan ḿme mɛ́bɛnléd áte, âbɛl nɛ́n nyéhɛl atyéem áʼsō wɛ́ɛ Mwǎn-a-Moonyoŋ.” ");
INSERT INTO bssNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ḿmê mesú mésyə̄ə̄l Yesuɛ ayə́gtéʼáá bad á Ndáb-e-Dyǒb. Nzé ngukɛ́l empɛ̌, ákɛ ánāā á ekone é Menzab. ");
INSERT INTO bssNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nzé bǐn bénsāā sáŋgɛ́n, ekud é bad éhyágáá mɔ́ atán á Ndáb-e-Dyǒb âwóglɛn mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Bɔɔb-pɔɔ́, Ngande e Ewɛle-é-Ngɛ̂n emmad abɛ́ bɛnbɛn. Enɛ́n ngande ebédɛ́ɛ dǐn bán Nnyíme-ámīn. ");
INSERT INTO bssNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Beprisɛ bémbáá ne bemeléede bé mbéndé béhɛ́déʼáá nzii echě béwúɛʼɛ́ Yesuɛ á mesɔɔm-tê. Bébááʼáá pɛn bán bad bɛ́sōŋtɛ̄n. ");
INSERT INTO bssNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Satanɛ ansɔ́l mbapɛɛ awe Yesuɛ nhɔ́g áte, awě béchəgɛɛ́ bán Judasɛ. Dǐn démpēe démbɛ̄ mɔ́ bán Iskariɔdɛ. Ambɛ́ nhɔ́g átîntê bembapɛɛ dyôm ne bébɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Hɛ́ɛ ásyə́ŋgé boŋ, ákɛ atán beprisɛ bémbáá bɔ́ɔbɛ bekamlɛn bé Ndáb-e-Dyǒb, âbɛl ntíi âsóm Yesuɛ áwāb. ");
INSERT INTO bssNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nɛ́n dénwōgēd bɔ́ menyiŋge bwâmbwam. Bɔ́bɔ̄ɔ bémpɛ̌ á nchemtɛn. Bénlāā mɔ́ bán bɛ́sābē mɔ́ mɔné. ");
INSERT INTO bssNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Mɔ́-ʼɛ ankwɛntɛ́n. Dɔ́ɔ ábóótédé nzii ahɛd âsóm Yesuɛ áwāb ésebán bad bébíí. ");
INSERT INTO bssNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bɔɔb-pɔɔ́, epun é ngande e Ewɛle-é-Ngɛ̂n áde béwúɛʼɛ́ ńdyɔŋ ḿ mbód mé Nnyíme-ámīn êmpɛ̌ áte. ");
INSERT INTO bssNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Dɔ́ɔ Yesuɛ álómɛɛ́ Petro bɔ́ Jɔn aá, “Nyékɛ nyéboŋsɛn syánē ndyééd e Ngande e Nnyíme-ámīn.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bênsɛdéd mɔ́ bánken, “Héé wɛ́dəŋgé wɛɛ́ sékɛ séboŋsɛn âdyɛ́ chɔ́?” ");
INSERT INTO bssNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Dɔ́ɔ ákwɛntanné aá, “Nyénɔneʼ. Nzé nyêpédé á dyad-tê, mod ǎbomɛ́n nyé awě apémé apom dé mendíb. Nyéhîd mɔ́ á ndáb ké ehéé eche ásɔ̄nlē. ");
INSERT INTO bssNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Nyéláa nwóó-ndáb bán, ‘Awɛd meléede aáken, héé toŋ e beken édíí echě mɔ́dyɛ̄ɛ̄ ndyééd e Nnyíme-ámīn áte ne ábē bembapɛɛ?’ ");
INSERT INTO bssNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Bɛ́lūmēd nyé toŋ echě ekəlé áte eche bénábpé áte. Ene toŋ edé ámīn á ndáb-te. Nyébɛle syánē mboŋsɛ́n ń ndyééd áhed.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Dɔ́ɔ békíí, bétán-nɛ mekan melemlem ngáne ánlēbɛ̄ɛ̄ bɔ́, bêmboŋsɛ́n-nɛ ndyééd e Ngande e Nnyíme-ámīn. ");
INSERT INTO bssNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Áde póndé e ndyééd épédé áte, Yesuɛ andyɛɛ́ á tébelɛ ne bembapɛɛ bé nlómag. ");
INSERT INTO bssNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Hɛ́ɛ álâŋgɛɛ́ bɔ́ aá, “Mendə̌ŋ bwâmbwam mɛɛ́ ńdyɛ̂ enɛ́n ndyééd e Nnyíme-ámīn ne nyé boŋ ńkude metuné. ");
INSERT INTO bssNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Á mbále nlâŋge nyé mɛɛ́ méedyáá chɔ́ ámpē kə́ə́ŋ ne á póndé echě Dyǒb dɛ́lōnēdtē chɔ́ mbon á póndé echě ḿmē nkamlɛn mɛ́pɛɛ́ áte.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Dɔ́ɔ átédé mbwendé, boŋ ábagé Dyǒb mekɛnag, álāŋgē-ʼɛ bɔ́ aá, “Nyékob nɛ́n, nyémwɛ̂, nyétômted nhɔ́g ne aníníí. ");
INSERT INTO bssNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Á mbále, nlâŋge nyé mɛɛ́ bootya bɔɔb âkɛ áʼsō, méemwáá ḿmɛ́n mǐm ámpē kə́ə́ŋ né nkamlɛn ń Dyǒb ḿpédé áte.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Antéd kə́ŋne ewɛle, ábɛ Dyǒb mekɛnag, ákabtéd chɔ́ áte, ábɛ̄-ʼɛ bɔ́ chɔ́ aá, “Echem yə̌l nɛ́n, ebǎgnédé áyə̄l echɛ̂n. Nyébɛle nɛ́n âkamtɛn mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Áde bémáá ndyééd adyɛ́ ambɛ̌l melemlem ne mbwendé ḿ mǐm. Anhɔ́b aá, “Ḿmɛ́n mbwendé ndíi melɛ̌ mékɔ̄ɔ̄lē ḿme nsógtɛ́né ne mekií ḿmêm, ḿme mɛ́syɔgé áyə̄l echɛ̂n. ");
INSERT INTO bssNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Boŋ nyénɔneʼ, mod awě akií mɛ ntúrɛ́, adyâg ndyééd ne mɛ hɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mwǎn-a-Moonyoŋ ǎwɛ̄ ngáne éténlédé, boŋ medim ne ane mod awě ǎsōm mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Hɛ́ɛ bembapɛɛ běn ne běn bébóótédé nhɔ́g ne aníníí asɛ́ded, âbíi bɔ́ mod awě ǎbɛ̌l enɛ́n ndín e dyam. ");
INSERT INTO bssNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Bembapɛɛ běn ne běn bêmbootéd asɛlɛn, béhɛdé âbíi bɔ́ mod awě adé mod ambáá áwab tîntê. ");
INSERT INTO bssNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Kə̂ŋ é meloŋ élûmte ngaŋlɛn ámīn e bad ábe békamlanné. Benkamlɛnɛ béchəge yə̌l bán, ‘Eboŋ-nlémɛ.’ ");
INSERT INTO bssNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Boŋ éetə̂ŋgɛnɛɛ́ abɛ́ nɛ̂ átîntê echɛ̂n. Êmboŋ bán ane awě adé mod ambáá átîntê echɛ̂n, átim nɛ́ɛ ane awě atómtɛ́né mpín abɛ́. Ane awě mɔ́-ʼɛ alyə́gteʼ, átim nɛ́ɛ mbəledɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nzé bad bédé bébɛ, nhɔ́g adyɛɛ́ á tébelɛ, aníníí-ʼɛ abɛnle mɔ́, ahéé atóme waáb eʼdel áte? Saá ane awě adyɛɛ́ á tébelɛ-yɛ? Boŋ mɛ, ndé áwɛn tîntê nɛ́ɛ ane awě abɛnle nyé. ");
INSERT INTO bssNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nyɛ́ɛ̄ nyêdé bad ábe béwɛ́sɛ́né mɛ á póndé eche ńkúdé metuné. ");
INSERT INTO bssNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ngáne Titɛ́ɛ ábágé mɛ kunze âkamlɛn, né-ʼaá mɛ́mpē mɛ́bɛɛ́ nyé. ");
INSERT INTO bssNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nɛ́n dɛ́bɛ̌l nyêdyɛ́ ndyééd, nyêmwɛ́-ʼɛ mǐm hǒm ahɔ́g ne mɛ áwem nkamlɛn-tê. Nyé mod tɛ́ ǎdyɛɛ́-ʼɛ á atii dé nkamlɛn, nyékāādtē metúmbé mé Israɛl dyôm ne mébɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“A-Simɔn, Nɔnéʼ! Satanɛ akudé kunze âkəg nyé moosyəə́l, âkab-pɛ nyé áte. Âbane bé bwâm ne bé mbéb nɛ̂ŋgáne mod apebe kón éche bésə́lté. ");
INSERT INTO bssNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Boŋ nkánnédé wɛ mɛɛ́ adúbe áde éwóó déesudéʼ. Á póndé echě wɛ́timɛ́nné mɛ ámpē, éwêd baányoŋ áte.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petro anhɔ́b aá, “A-Sáŋ, ké á mbwɔg dɔ́ɔ bétimnɛ́ɛ́ wɛ káa á kwééd, mbǒŋsɛ́né wɛ ahíd.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ mɔ́ aá, “Ńláa wɛ, a-Petro, nchóm-a-kúb adɛ̂hɔ́b aá mɔ́tōoʼ nkuu nɛ́n, wɛ̌bāŋ mɛ áyə̄l ngen éláán.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Dɔ́ɔ Yesuɛ ásɛdtɛɛ́ ábē bembapɛɛ aá, “Á póndé eche ménlōmmē nyé ésebán nyéewánlé ekwɛ é ngáb, káa ekwɛ, káa metámbé, nzé-chómé nyéntōgkē?” Bembapɛɛ bênkwɛntɛ́n bán, “Chǒmchǒm.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Bɔɔb-pɔɔ́, mod awě awóó ekwɛ é ngáb kéʼɛ ekwɛ, áwále áyə̄l. Ane awě mɔ́-ʼɛ eewóo nkwáté, ásôm ḿmē nkobe, áchan nkwáté. ");
INSERT INTO bssNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nlâŋge nyé mɛɛ́ kálag e Dyǒb ehɔ́bé aá, ‘Bébánné mɔ́ nchoo nhɔ́g ne bechîb.’ Né-ʼaá ébɛnlédté áyə̄l echêm. Étə́ŋgɛ́né ébɛnléd áned.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bembapɛɛ bénlāā mɔ́ bán, “A-Sáŋ, nɔnéʼ, sêwánlé nkwáté ḿbɛ hɛ́n.” Mɔ́-ʼɛ antimtɛ́n bɔ́ aá, “Désob nɛ̂ bɔɔb.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Hɛ̂ dɔ́ɔ ábídé á ebwɔ́g, áhīdē á dyad-tê, ákɛ̄ á ekone é Menzab ngáne âmmɛntɛ́nné abɛl. Bembapɛɛ bɔ́-ʼɛ bénhīd mɔ́ ámbīd. ");
INSERT INTO bssNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Áde bépédé áwed anláá bɔ́ aá, “Nyékânneʼ bán mekəgsɛn méepiidé nyé.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ansyəə́ bɔ́ á nkəg, asídé mwǎ nchabnede, akɔ́g mebóbóŋ, ákānnē nɛ́n aá, ");
INSERT INTO bssNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“A-Tɛ̂, nzé ébóŋnédé wɛ, ékōbɛ̄n mɛ ḿmɛ́n metuné. Boŋ ké nɛ̂, saké ngáne ébóŋnédé mɛ, boŋ bɛ̌l ngáne ébóŋnédé wɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Áde Yesuɛ ákânnɛɛ́ nɛ̂, ángɛl embíd ádyōb, éhyɛ ewéd mɔ́ áte. ");
INSERT INTO bssNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Anwéd mekáne áte ngáne ámbɛ̄ɛ̄ á ndutul-tê. Ebábé éche ébídé mɔ́ á yə̌l émbɛ̄ ngáne metɔ́té mé mekií, étɛ̄nēʼ á ndɔɔb taáb, taáb. ");
INSERT INTO bssNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Áde ámáá akáne, antyéém ámīn, ákɛ wɛ́ɛ bembapɛɛ bébédé. Antán nɛ́ɛ békúnɛɛ́ áyə̄le ndutul e ngíne. ");
INSERT INTO bssNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Dɔ́ɔ ásɛdtɛɛ́ bɔ́ aáken, “Cheé nyékúnɛɛ́? Nyépáde ásē, nyékânne nɛ́n mekəgsɛn méepiidé nyé.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesuɛ eépedɛɛ́ ké amad á nsəl dɔ́ɔ amute á bad ápédé. Mod awě antómɛ́n bɔ́ abédɛ́ɛ Judasɛ, mbapɛɛ nhɔ́g átîntê e bembapɛɛ dyôm ne bébɛ ábe Yesuɛ. Apedé-ʼaá Yesuɛ á nkəg ahɛ́ mɔ́ tə̂l. ");
INSERT INTO bssNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Boŋ Yesuɛ ansɛdéd mɔ́ aá, “A-Judas, nɛ́dē ahɛ́ áde éhédé Mwǎn-a-Moonyoŋ tə̂l ádíi âsóm mɔ́-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Áde bembapɛɛ ábe bɔ́ɔbɛ Yesuɛ bébédé áhed bényíné dyam áde áhɛde abɛnled, bênsɛdéd mɔ́ bánken, “A-Sáŋgú, sêhɛle séwān ne ḿmɛd nkwáté-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Hɛ́ɛ mbapɛɛ nhɔ́g átómté nkwáté, ásɛ̄lē ntâŋ awě prisɛ ambáá etúu é ekáá émbáá. ");
INSERT INTO bssNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Boŋ Yesuɛ anláá bɔ́ aá, “Nyésob nɛ̂ bɔɔb!” Ansidtɛ́n mɔ́ ene pɛd e etúu, ádid mɔ́ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Hɛ́ɛ álâŋgɛɛ́ beprisɛ bémbáá bɔ́ɔbɛ benkamlɛnɛ bé mésɛ́nzɛ mé Ndáb-e-Dyǒb ne belyə́ged bé dyad, bad ábe bênhyɛ mɔ́ akób aá, “Nchîb mɔ́ɔ nyéhyédé akób, boŋ nyêwálé nkwáté ne mbid-ɛ? ");
INSERT INTO bssNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mbwɛ tɛ́ɛ́ syánē debágáá á Ndáb-e-Dyǒb, nyênkêmbánné mɛ ké ekáá á yə̌l. Boŋ echɛn póndé epedé bɔɔb. Ehíntɛ́n chɔ́ɔ édé á nkamlɛn bɔɔb.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Hɛ́ɛ békóbé Yesuɛ, boŋ békɛɛné mɔ́, bétīmɛ̄n mɔ́ á ndáb wɛ́ɛ Prisɛ Ambáámbáa. Petro mɔ́-ʼɛ ahídéʼáá bɔ́ ámbīd mwǎ etûn. ");
INSERT INTO bssNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bênkonéd muú átîntê e dyad, bad bélādɛ̄n áhed. Petro mɔ́mpē anhyɛ̌ adyɛɛ áhed. ");
INSERT INTO bssNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mbəledɛ a mmwaád nhɔ́g annyín nɛ́ɛ Petro ádyɛ́ɛ́ á nkəg ń dǔ. Dɔ́ɔ ánɔ́né mɔ́ chóóŋ, boŋ áhɔ̄bēʼ aá, “Anɛ́n mod mɔ́mpē ambɛ́ ne Yesuɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Boŋ Petro antáŋ aá, “A-mwǎn-a-mmwaád, meebíiʼɛ́ mɛ mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Éebemɛɛ́ áte, mod ampée anchem mɔ́. Anhɔ́b aá, “Wɛ́mpē edé nhɔ́g áwāb echoŋ.” Boŋ Petro anhɔ́b aá, “Amúɛ̄, weéhyāg mɛ ngáne áyə̄l.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ámbīd e háwa pɔ́g mod ampée ambádnɛ́n aá, “Ntâŋtɛn ké nhɔ́g méesaá. Anɛ́n mod abédé ne Yesuɛ, áyə̄le adíi mod a Galilia.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Boŋ Petro anhɔ́b aá, “Á-mod-e-ngɛ́, meebíiʼɛ́ chǒm éche mmǒŋ ékooʼɛ́ ahɔ́b.” Ábwɔ̄g-ábwɔ̄g áde áhɔ́bé nɛ̂, nchóm a kúb antóŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Hɛ́ɛ Sáŋgwɛ́ɛ́ ákúnné boŋ mǐd mébomé bɔ́ Petro. Dɔ́ɔ Petro áwémtɛ́né eʼyale ábe Sáŋgwɛ́ɛ́ ánlāāʼɛ́ mɔ́ aá, “Nchóm-a-kúb adɛ̂hɔ́b aá mɔ́tōoʼ chii nɛ́n, wɛ̌bāŋ mɛ á yə̌l ngen éláán.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Hɛ́ɛ ábídé á ebwɔ́g, abə́lé-ʼɛ awɛ́. Anchií bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bɔɔb-pɔɔ́, bad ábe bénɔ́néʼáá Yesuɛ bêmbootéd mɔ́ awɛl, bébɔmtád mɔ́, ");
INSERT INTO bssNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","békaŋ mɔ́ mǐd, bésɛ̄dtē mɔ́ bán, “Láá sé, nzɛ́-módɛ́ abɔmé wɛ?” ");
INSERT INTO bssNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bésyə́ə́ʼáá mɔ́ nzyə́ŋ nyaa ne nyaa. ");
INSERT INTO bssNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nɛ́ɛ bǐn éʼsáŋgé, bad bémbáá bé Israɛl, beprisɛ bémbáá ne bemeléede bé mbéndé bénkōb mbom, bépɛ̄ɛ̄n Yesuɛ áwab káánsɛl. ");
INSERT INTO bssNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Hɛ́ɛ bésɛdtɛɛ́ mɔ́ bán, “Láá sé nzé wɛ-ɛɛ́ edé Ane-awě-Béwɔ́gté?” Dɔ́ɔ Yesuɛ áhɔ́bɛɛ́ aá, “Ké menláá nyé, nyéedúbɛ́ɛ́ mɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ké mensɛ́ded-tɛ nyé akan, nyéekwɛntɛ́nné mɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Boŋ bootya bɔɔb, Mwǎn-a-Moonyoŋ ǎdyɛɛ́ á ekáá émbáá é Dyǒb á Ngum.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bɔ́ moosyəə́l bênsɛdéd bánken, “Nɛ́dē wɛ-ɛɛ́ edé Mwǎn a Dyǒb-ɛ?” Ankwɛntɛ́n aá, “Nyé běn-ɛɛ́ nyêhɔ́bé bán nɛ́ɛ édíí.” ");
INSERT INTO bssNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Dɔ́ɔ béhɔ́bɛɛ́ bán, “Nzɔm ehéé empée déhɛdɛɛ́? Syánē běn dewógé áwē nsəl.” ");
INSERT INTO bssNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Hɛ́ɛ belyə́ged bé dyad bésyə̄ə̄l bétyéémé ámīn, boŋ békɛɛné mɔ́ wɛ́ɛ Payledɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Áwed-taá bébóótédé mɔ́ mekan abán áyə̄l bán, “Sêkóbé anɛ́n mod ngáne ápuutadté sé aloŋ áte. Áhɔ́bé nɛ́n aá, séēsaŋnád Kaisɛɛ táásɛ, áhɔ̄bē-ʼɛ nɛ́n aá, mɔ́ mwěn mɔ́ɔ̄ mɔ́dē Ane-awě-Béwɔ́gté, nɛ́dē ahɔ́beʼ aá mɔ́dē kə̂ŋ.” ");
INSERT INTO bssNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Dɔ́ɔ Payledɛ ásɛdtɛɛ́ Yesuɛ aáken, “Wɛ-ɛɛ́ edé kə̂ŋ e bad bé Israɛl-lɛ?” Yesuɛ ankwɛntɛ́n mɔ́ aá, “Ngáne éhɔ́bé.” ");
INSERT INTO bssNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Boŋ Payledɛ álāŋgē beprisɛ bémbáá ne amute á bad nɛ́n aá, “Meenyínɛɛ́ atɔte ké ahɔ́g áde anɛ́n mod ákwɛ́ɛ́né.” ");
INSERT INTO bssNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Boŋ bémbɛ̄ békag áʼsō, béhɔ̄bē bán, “Anɛ́n mod akóne bad ne mam ḿme áyə́gtɛɛ́ á mbwɔ́g e Judeya esyəə́l. Ambootéd á Galilia, apedé-ʼɛ hɛ́n bɔɔb.” ");
INSERT INTO bssNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nɛ́ɛ Payledɛ áwógé nɛ̂, ansɛdéd ké Yesuɛ adíī mod a Galilia. ");
INSERT INTO bssNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Bénlūmēd mɔ́ áte bán, nɛ̂ děn dɔ́ɔ édíí. Ngáne aloŋ á Galilia abédé ásē e nkamlɛn ḿme Hɛrɔdɛ, Payledɛ anlóm Yesuɛ áwē. Hɛrɔdɛ mwěn ámpē ambɛ́ á Jerusalɛm ene póndé. ");
INSERT INTO bssNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ayɔ̌gké mewêmtɛn awóŋ ânyín Yesuɛ áyə̄le awógéʼáá mɔ́ dúu. Ahɛdéʼáá aá mɔ́nyîn menyáké ḿme ábɛlɛɛ́. Né-ɔɔ́ anwóg menyiŋge áde bépɛ́ɛ́né Yesuɛ áwē. ");
INSERT INTO bssNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ansɛdéd Yesuɛ ekud é mekan, boŋ Yesuɛ enkêntimtɛ́nné mɔ́ dyamdyam. ");
INSERT INTO bssNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Beprisɛ bémbáá ne bemeléede bé mbéndé béntyēēm ámīn, bébāntād Yesuɛ mekan áyə̄l. ");
INSERT INTO bssNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hɛ́ɛ Hɛrɔdɛ, bɔ́ɔbɛ éche sə́nze bébóótédé mɔ́ awɔɔ, béwɛlé-ʼɛ mɔ́. Dɔ́ɔ béwāādtē mɔ́ kəse é bwěm, boŋ álōmē mɔ́ ámbīd wɛ́ɛ Payledɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nɛ́n dênkə̌ŋ Hɛrɔdɛ bɔ́ Payledɛ bêntǐm ásē échê epun; édé apɛ nɛ̂, búmɔ̄ bénsēbē ekɔyí awoŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Hɛ̂ dɔ́ɔ Payledɛ áládé beprisɛ bémbáá áte nchoo ne belyə́ged, ne bad bémpēe, ");
INSERT INTO bssNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","boŋ álāŋgē bɔ́ aá, “Nyênsébé anɛ́n mod apɛɛn áwêm. Nyé bán apuutad bad nló áte. Bɔɔb-pɔɔ́ nhɛdé áte áyə̄l échê wɛ́ɛ nyéběn nyédíí, boŋ meekóbnɛɛ́ mɔ́ dyam dé mbéb ké ahɔ́g áde nyéhɔ́bé bán abɛlé. ");
INSERT INTO bssNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ké Hɛrɔdɛ ámpē eekóbnɛɛ́ mɔ́ awusé ké ahɔ́g, né-ʼaá ákə́ə́ boŋ álōmē mɔ́ ámbīd. Bɔɔb-pɔɔ́ dyam dé mbéb ké ahɔ́g déesaá áde ábɛ́lé áde álûmte bán atə́ŋgɛ́né kwééd. ");
INSERT INTO bssNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Né-ɔɔ́ mɛ̌hɔ̄b békúdé mɔ́, ńtɛ̄dē mɔ́, ákag.” ");
INSERT INTO bssNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Dɔ́ɔ amute ásyə̄ə̄l ábónɛɛ́ bán, “Téd anɛ́n mod, éwúu mɔ́! Bídtéd sé Barabasɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabasɛ abédɛ́ɛ mod awě bénhɛ̄ɛ̄ á mbwɔg áyə̄le bel ábe âmbootédté á dyad-tê ne awúu áde áwúɛ́ʼáá bad.) ");
INSERT INTO bssNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ngáne Payledɛ ánwōŋgē mewêmtɛn âtɛde Yesuɛ, ambɛ́ aláá bɔ́ nɛ̂ ámpē. ");
INSERT INTO bssNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Boŋ bémbɛ̄ bébōnēʼ bán, “Bomé mɔ́ á awɔg! Bomé mɔ́ á awɔg!” ");
INSERT INTO bssNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Anláá bɔ́mpē ngen éche élóntɛ́né éláán aá, “Áyə̄le chán? Ebébtéd éhéé ábɛ́lé? Meekóbnɛɛ́ mɔ́ awusé ké ahɔ́g áde átə́ŋgɛ́né kwééd. Né-ɔɔ́, mɛ̌kūdē mɔ́, ńtɛ̄dē-ʼɛ mɔ́, ákag.” ");
INSERT INTO bssNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ké nɛ̂ bémbɛ̄ bébōnēʼ bán ábome mɔ́ á awɔg. Kə́ə́ŋ ne á asóg, échab ehɔ́b ênkobnéd. ");
INSERT INTO bssNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Payledɛ ambídéd mbakú aá, mɔ́ɔ̄bɛ̌l nɛ̂ŋgáne béhɔ́bé. ");
INSERT INTO bssNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Antɛdé mod awě bénhɔ̄bpē, awě ambɛ́ á mbwɔg áyə̄le bel ne awúu áde áwúɛ́ʼáá bad, boŋ ábagé bɔ́ Yesuɛ aá, bétiméd mɔ́ ngáne bédə́ə́. ");
INSERT INTO bssNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Áde sə́nze ékɛɛnɛɛ́ Yesuɛ á hǒm dé mpanag, êmbomɛ́n Simɔnɛ, mod a dyad á Sirinɛ. Anɛ́n mod ambíd á mwǎ dyad awě adé á ahə́ŋgé. Hɛ́ɛ békóbé mɔ́, bépémtéd mɔ́ awɔg áde Yesuɛ bán áhídne mɔ́ dɔ́ ámbīd. ");
INSERT INTO bssNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Átîntê e ndun e mod echě enanáá Yesuɛ ámbīd, bebaád bémbɛ̄ áwed, béchyɛ́ʼáá, bélebe-ʼɛ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Dɔ́ɔ Yesuɛ ánɔ́né ámbīd, álāŋgē bɔ́ nɛ́n aá, “A-bǎn bé bebaád bé Jerusalɛm, nyéēchyɛ̄ɛ̄ʼ mɛ, nyéchyɛʼ échɛn yə̌l ne ábɛn bǎn. ");
INSERT INTO bssNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nhɔ́be nɛ̂ áyə̄le nɛ́n eʼpun éʼ bǐn éʼhúɛ, áde bad bɛ́hɔ̄bpē bán, ‘Nnam ne ábê ábe bédé ekɔm, ne ábê ábe béēchyāāʼ, ne ábê ábe béēmwāŋtē mbêd!’ ");
INSERT INTO bssNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Á póndé eched dɔ́ɔ bad bɛ́lāŋgɛ̄ɛ̄ mbɔɔd bán, ‘kúmtéd sé ámīn,’ káa eʼkone bán, ‘kútɛ́n sé.’ ");
INSERT INTO bssNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nzé bébɛleʼ ḿmɛ́n mésyə̄ə̄l bɔɔb, áde bwɛl éʼlyə́gé éʼdíí mendíb áte, chán-náa bɛ́bɛnlé áde bwɛl bɛ́kīnnē-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Bɔɔb-pɔɔ́ bênkɛɛ́n eʼbébtéd éʼ bad éʼbɛ, âpan bɔ́ nchoo ne Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Áde bépédé hǒm áde béchəgɛɛ́ bán Ebóŋgɛ́l é Nló, bêmbomé Yesuɛ á awɔg, ne ábê eʼbébtéd éʼ bad éʼbɛ. Bêmbomé nhɔ́g á ekáá é emwɛd, aníníí-ʼɛ á ekáá émbáá. ");
INSERT INTO bssNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Hɛ́ɛ Yesuɛ ákânnɛɛ́ nɛ́n aá, “A-Sáŋ, lagsɛ́n bɔ́ áyə̄le béēbíiʼɛ́ chǒm éche bébɛlɛɛ́.” Sə́nze ênsǐd mbambú, âkab mbɔ́té éche Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ndun e mod entyéém á nkəg, bénɔnéʼ chǒm éche ébɛnlad. Boŋ benkamlɛnɛ bé Israɛl béwɛ́láá mɔ́, béhɔ̄bē bán, “Achǒŋtéʼáá bad bémpēe, áchood-tɔɔ́ eche yə̌l, nzé ne mbále mɔ́ adé Ane awě Dyǒb Ápwɛ́dé, boŋ Áwɔ́géd-tɛ.” ");
INSERT INTO bssNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sə́nze chɔ́mpē éwɛ́láá mɔ́. Êmpiinéd mɔ́ ebɛ́ntéd é mǐm, ");
INSERT INTO bssNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","élāŋgē mɔ́ bán, “Nzé wɛ́ɛ edé kə̂ŋ e bad bé Israɛl, ésōŋ echoŋ yə̌l!” ");
INSERT INTO bssNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bêntěl áwe nló ámīn nɛ́n bán, “Kə̂ŋ e bad bé Israɛl chɔ́ɔ nɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Átîntê e ábɛ̂ eʼbébtéd éʼ bad éʼbɛ ábe bêmbomɛ́ɛ́ bɔ́ɔbɛ Yesuɛ á awɔg, nhɔ́g ansyə́ŋ mɔ́ aá, “Saá wɛ edé Ane awě Dyǒb Áwɔ́gté-yɛ? Sǒŋ-ɔ̄ échoŋ yə̌l, ésoŋ-ʼɛ sémpē!” ");
INSERT INTO bssNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Boŋ aníníí mod ankáné waáb áte aáken, “Weebááʼɛ́ Dyǒb-ɛ? Sóo bad bébɛ dekudé melemlem mé nkɔ́gsɛn ḿme mɔ́mpē ákúdé. ");
INSERT INTO bssNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Boŋ pɛn, nkɔ́gsɛn ḿme dékúdé, ńtə́ŋgɛ́né ne ḿme sóo mbéb. Boŋ anɛ́n mod eébɛlɛɛ́ dyam dé mbéb ké ahɔ́g.” ");
INSERT INTO bssNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Hɛ́ɛ ane mod ábádɛɛ́ ahɔ́b aá, “A-Yesu, sôn, weéchatán mɛ á póndé eche wɛ́sɔ̄nlɛ̄ á nkamlɛn.” ");
INSERT INTO bssNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ mɔ́ aá, “Á mbále, nlâŋge wɛ mɛɛ́, chii nɛ́n děn wɛ̌bɛ̄ ne mɛ á Paradis.” ");
INSERT INTO bssNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Bɔɔb-pɔɔ́ bǐn bémbɛ̄ dyam kəd. Etondɛɛ andím, ehíntɛ́n ékwɛ̄-ʼɛ ekíde áte ésyə̄ə̄l kə́ə́ŋ ne á ngə́ŋ éláán. Abad áde dênkǎb Ndáb-e-Dyǒb áte dênsalé áte eʼpɛd éʼbɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Hɛ̂ dɔ́ɔ Yesuɛ álébpé esaád aá, “A-Tɛ̂, áwôŋ mekáá dɔ́ɔ ńlyə́gé échem edəə́dəŋ!” Amaá-ʼaá ahɔ́b nɛ̂, ámīī-ʼɛ nlém, awɛ́-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Áde mod ambáá a sə́nze ányíné nɛ̂, ankéméd Dyǒb nɛ́n aá, “Á mbále, anɛ́n mod abédé-ʼɛ mod a bwâm.” ");
INSERT INTO bssNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nɛ́ɛ ndun e mod echě enhyɛ̌ anɔn, ényíné mekan mé ményáké ḿme mébɛ́nlédé, mod tɛ́ɛ́ ambán ekáá á nlém, ásūɛ̄ʼ á ndáb. ");
INSERT INTO bssNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesuɛ ábe besón bésyə̄ə̄l ne bebaád ábe bêmbootéd mɔ́ anan ámbīd se á Galilia, béntyēēm etûn, bénɔné ḿmɛ́n mekan mésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Bɔɔb-pɔɔ́ mod ambɛ́ awě abédé dǐn bán Josɛbɛ. Anɛ́n mod ambíd á dyad á bad bé Israɛl áde béchəgɛɛ́ bán Arimatia. Abédé mod a edúbé. Abédɛ́ɛ mod a bwâm, asáŋ-ʼɛ. Kénɛ́ɛ ábédé mod a káánsɛl enkênkwɛntɛ́nné mbakú echě ábíníí belyə́ged bé dyad bémbīdēdtē âwúu Yesuɛ. Abédé mod nhɔ́g awě anlyə́g nlém nɛ́n aá epun épɛ̌ éche Dyǒb dɛ́kobpé nkamlɛn. ");
INSERT INTO bssNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ankɛ̌ Payledɛ acháŋ aá, ábɛ mɔ́ ndim ḿme Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nɛ́ɛ ákúdé kunze, anhúd mɔ́ á awɔg, ákāān mɔ́ kəse e mbɔ́m, ákɛ alímé mɔ́ á soŋ echě bépwɔ́gé á eláá-tê, éche béēsēbpɛɛ́ mod alíme áte. ");
INSERT INTO bssNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nɛ́n démbɛ̄ á Mbwɛ mé mboŋsɛ́n, áde mbwɛ-mé-nkɔ́me-áte ńhɛ́déʼáá abooted. ");
INSERT INTO bssNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Bebaád ábe bêmbootéd Yesuɛ anan ámbīd se á Galilia, bénhīd Josɛbɛ, bényín soŋ, bényín-nɛ ngáne bénáŋté mɔ́ ndim á soŋ-tê. ");
INSERT INTO bssNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Dɔ́ɔ bétímé ámbīd á dyad-tê, béboŋsán mɔ̌g ne mekún ḿme bénabnadté ndim. Á mbwɛ-mé-nkɔ́me-áte bénkɔ̄mē áte ngáne mbéndé e bad bé Israɛl étíídé. ");
INSERT INTO bssNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Á epun éʼsō, nɛ́dē á Sɔ̂ndé mbwɛmbwɛ píríb, ábê bebaád bênkɛ̌ á soŋ. Bénwālē mekún mé ndim ḿme bêmboŋsɛ́nné. ");
INSERT INTO bssNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Béntān nɛ́ɛ aláá áde bénkɔ̄lɛ̄nnē nsəl ń soŋ ásyə́ŋgé á eʼdii. ");
INSERT INTO bssNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bénsɔ̄l á soŋ-tê, boŋ bénkêntánné ndim ḿme Yesuɛ áwēd-te. ");
INSERT INTO bssNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nɛ́n dêmbootéd bɔ́ ataged á mewêmtɛn. Dɔ́ɔ bad bébɛ bébídé təléd, bétyéém bɔ́ á nkəg ne mesaŋ ḿme mékineʼ áte. ");
INSERT INTO bssNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ne mbwɔ́g bwâmbwam bênsǒŋ mǐd ásē. Hɛ́ɛ ábê bad bébɛ bélâŋgɛɛ́ bɔ́ bán, “Cheé ékə́ə́ boŋ nyéhɛdé mod awě adé á aloŋgé átîntê e bad ábe béwédé? ");
INSERT INTO bssNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Eésaá hɛ́n, apuúdé. Nyékamtɛn ngáne ánlāāʼɛ́ nyé, áde ábédé á Galilia, ");
INSERT INTO bssNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","aá bétə́ŋgɛ́né Mwǎn-a-Moonyoŋ abɛ á mekáá mé bebɛl bé mbéb, bébōmē mɔ́ á awɔg. Boŋ ǎpuú á eʼpun ábe éʼlóntɛ́né éʼláán.” ");
INSERT INTO bssNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Hɛ̂ dɔ́ɔ ábê bebaád békámtɛ́né ábē eʼyale. ");
INSERT INTO bssNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Áde béhúú á soŋ, bênkalé bembapɛɛ dyôm ne nhɔ́g ne ábíníí bémpēe mam mésyə̄ə̄l ḿme bényíné. ");
INSERT INTO bssNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Bebaád ábe bênkalé bembapɛɛ bé nlómag ḿmɛ́n nkalaŋ, bébédɛ́ɛ Maria Magdalɛnɛ, Joanaa, ne Maria, nyaá awe Jemsɛ, nchoo ne bebaád bémpēe. ");
INSERT INTO bssNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Boŋ bembapɛɛ bé nlómag bénwēmtɛ̄n bán ene pɔ́le edíī ngwɛl. Bénkêndúbɛ́ɛ́ chɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Hɛ̂ dɔ́ɔ Petro ápádté ásē, boŋ ányəgté á soŋ. Áde ápédé áwed anwúlɛ́n ásē, ánɔ̄n soŋ áte. Anyín dásɔ̄ mbɔ́m chěmpɛn. Dɔ́ɔ ásúú á ndáb. Mewêmtɛn mékɔ́gládtáá mɔ́ áte tə̂ŋgɛne dyam áde ábɛ́nlédé. ");
INSERT INTO bssNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Bɔɔb-pɔɔ́, échê epun děn, bembapɛɛ ábe Yesuɛ bébɛ békágéʼáá á dyad áde béchəgɛɛ́ bán Emɔs. Âbíd á Jerusalɛm âpɛ á Emɔs ábédé etûn dyam máyl saámbé. ");
INSERT INTO bssNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ábê bembapɛɛ békágéʼáá békalé ḿmɛ́n mekan mésyə̄ə̄l ḿme mékébɛnléd. ");
INSERT INTO bssNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Áde békékanlé kə́ə́ŋ, dɔ́ɔ Yesuɛ mwěn áhyédé bɔ́ atán, boŋ áwoŋné bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Boŋ pɛn mǐd mênkênnédnédté bɔ́, âchem mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Hɛ́ɛ Yesuɛ ásɛdtɛɛ́ bɔ́ aáken, “Pɔ́le ehéé nyépagké akal á ekɛ-tê nɛ́n?” Hɛ̂ dɔ́ɔ bétyéémé ne ngɔl esyəə́l. ");
INSERT INTO bssNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Dɔ́ɔ bɔ́ mod nhɔ́g awe béchəgɛɛ́ bán Klopasɛ, átimtanné mɔ́ aáken, “Emǒŋ pɛn-ɛɛ́ edé nken a mod á Jerusalɛm, áde wéēbíi mekan ḿme ńkébɛnléd ḿmɛ́n mesú-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Dɔ́ɔ Yesuɛ ásɛdtɛɛ́ bɔ́ aáken, “Mekan méhéé mɛ̂?” Boŋ bélāŋgē mɔ́ bán, “Mekan ḿme mébɛ́nlédé tə̂ŋgɛne Yesuɛ, mod a Nazarɛt. Ambɛ́ nkal éʼdəə́dəŋ awě ahɔ́béʼáá, ábɛlé-ʼɛ ndəle é mekan áʼsō éʼ Dyǒb ne áʼsō éʼ baányoŋ. ");
INSERT INTO bssNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ábɛd beprisɛ bémbáá ne belyə́ged bé dyad bêmbɛ mɔ́ á mekáá mé nkamlɛnɛ, âbíded mbakú bán béwúu mɔ́. Dɔ́ɔ bébómmé mɔ́ á awɔg. ");
INSERT INTO bssNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Boŋ sênlyə́g nlém bán, mɔ́ adé ane awě ǎwɔbé bad bé Israɛl. Nɛ́ɛ éhúdé nɛ̂ áte, chii dɔ́ɔ álôntan eʼpun éʼláán taa nɛ̂ ábɛnlede. ");
INSERT INTO bssNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ámīn e nɛ̂ ámpē, nguse é bebaád átîntê echɛ̂d bépɛ́ɛ́nédé sé menyáké mé pɔ́le. Bênkɛ̌ á soŋ epɔg é mbwɛmbwɛ, ");
INSERT INTO bssNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","boŋ béētānɛɛ́ ndim ḿme Yesuɛ. Bénhūū ámbīd, béhɔ̄bē bán, ángɛl épíídé bɔ́ á ndɔ́g-te, élāŋgē bɔ́ nɛ́n bán, Yesuɛ adé á aloŋgé. ");
INSERT INTO bssNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nguse é bad átîntê echɛ̂d énkɛ̌ á soŋ, bétán chɔ́ melemlem nɛ̂ŋgáne bebaád bénhɔ̄bpē, boŋ béēnyīnɛɛ́ mwěn.” ");
INSERT INTO bssNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Dɔ́ɔ Yesuɛ áláŋgɛɛ́ bɔ́ aá, “Eʼyɔ́kɛ́l éʼ bad bɔ́ɔ nyédíí. Nyéewámsánné mam mésyə̄ə̄l ḿme bekal béʼdəə́dəŋ béhɔ́bé adúbe! ");
INSERT INTO bssNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ngɔ́mē éhɛ́dnádtáá bán, Ane-awě-Béwɔ́gté ákud ḿmɛ́n metake mésyə̄ə̄l, boŋ ákud éche ehúmé.” ");
INSERT INTO bssNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yesuɛ antógnéd bɔ́ mam mésyə̄ə̄l tə̂ŋgɛne eche yə̌l, ngáne méténlédé á Kálag e Dyǒb-te, mbooted ne kálag éche Mosɛɛ ne kálag éche bekal béʼdəə́dəŋ bésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Áde bépédé bɛnbɛn ne dyad áde békágéʼáá, Yesuɛ anlúméd byánán ekɛ élyə́gé édé mɔ́ áʼsō. ");
INSERT INTO bssNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Boŋ bénkə̄ŋ mɔ́ bán, “Hyɛ̌ édyɛɛ áwɛ̄d ngáne bǐn éʼmáá ahín, póndé-ʼɛ emaá atóm.” Dɔ́ɔ áhídé bɔ́ âdyɛɛ áwāb. ");
INSERT INTO bssNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Áde bɔ́bɔ̄ɔ bédyɛ́ɛ́ ásē á tébelɛ âdyɛ́ ndyééd, antéd ewɛle, ánāmēd chɔ́, ásāl chɔ́ áte, boŋ ábagé bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hɛ̂ dɔ́ɔ mǐd métə́nlédé bɔ́, boŋ béchemé mɔ́. Dɔ́ɔ ányóó bɔ́ á dǐd-te. ");
INSERT INTO bssNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bénlāā nhɔ́g ne aníníí bán, “Ngɔ́mē nlém ńhógkáá syánē á abum áde ákánléʼáá syánē á nzii, boŋ átə̄nlād syánē Kálag e Dyǒb?” ");
INSERT INTO bssNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ábwɔ̄g-ábwɔ̄g dɔ́ɔ bésyə́ŋgé ásē, boŋ bétīm-mɛ ámbīd á Jerusalɛm. Dɔ́ɔ bétáné bembapɛɛ dyôm ne nhɔ́g ngáne béládné áte hǒm ahɔ́g bɔ́ɔbɛ bembapɛɛ bémpēe. ");
INSERT INTO bssNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Hɛ́ɛ bembapɛɛ ábe bétáné á ndáb-te béláŋgé bɔ́ bán, “Sáŋgwɛ́ɛ́ apuúdé ne mbáá, apiídé-ʼɛ Simɔnɛ!” ");
INSERT INTO bssNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dɔ́ɔ bɔ́ bad bébɛ bɔ́mpē béhɔ́bé dyam áde ábɛ́nlédé bɔ́ á nzii, béhɔ̄bē-ʼɛ ngáne béchémé mɔ́ áde ásalɛɛ́ ewɛle áte. ");
INSERT INTO bssNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Á póndé eche békalɛɛ́ nɛ̂, dɔ́ɔ Yesuɛ mwěn ábídé bɔ́ átîntê, boŋ álɛnté bɔ́ aá, “Nsaŋ ḿbɛ̂ ne nyé!” ");
INSERT INTO bssNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mbwɔ́g ménkōb bɔ́ bwâmbwam, béwēmtān bán, bényíné nwú. ");
INSERT INTO bssNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Dɔ́ɔ álâŋgɛɛ́ bɔ́ aá, “Cheé nyétagɛɛ́ áte? Cheé nyényágɛɛ́ á nlém-tê. ");
INSERT INTO bssNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nyénɔn mɛ mekáá nyénɔn-nɛ mɛ mekuu, boŋ nyébíi bán mměn-ɛɛ́ ndé. Nyékitɛn mɛ yə̌l, nyényîn nzé nwú ńwóó nson ne eʼhid ngáne nyényínɛɛ́ nwóó nɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Áde ámáá ahɔ́b nɛ̂, anlúméd bɔ́ ḿme mekáá ne mekuu. ");
INSERT INTO bssNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Áde bélyə́gé bényágɛɛ́ nɛ̂ ne menyiŋge mésyə̄ə̄l, békɔglad-táa á nlém-tê, dɔ́ɔ ásɛdtɛɛ́ bɔ́ aáken, “Nyêwóó chǒm éche bédyágkē hɛ́n-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Dɔ́ɔ bébágé mɔ́ esóŋ é súu echě bétúmé. ");
INSERT INTO bssNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Boŋ ákobéʼ, ádyāg-kɛ chɔ́ áwab eʼsó-te. ");
INSERT INTO bssNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Hɛ́ɛ álâŋgɛɛ́ bɔ́ aá, “Ḿmɛ́n mam mɔ́ɔ ńláŋgéʼáá nyé áde ńlyə́gé ndé ne nyé mɛɛ́, dyam tɛ́ɛ́ átə́ŋgɛ́né alón ngáne éténlédé áyə̄l echêm á kálag é mbéndé éche Mosɛɛ ne á kálag é bekal béʼdəə́dəŋ, ne á Kálag e Ngəse-tê.” ");
INSERT INTO bssNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dɔ́ɔ ánédté bɔ́ debyɛ́ɛ́ áte, âbɛl nɛ́n bésôŋtɛn Kálag e Dyǒb, ");
INSERT INTO bssNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","boŋ álāŋgē-ʼɛ bɔ́ aá, “Bétélé á Kálag e Dyǒb nɛ́n bán, Ane-awě-Béwɔ́gté atə́ŋgɛ́né metake akud, awɛ́, boŋ eʼpun ábe éʼlóntɛ́né éʼláán, ápuu. ");
INSERT INTO bssNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Bétélé bán, bad bɛ́kalé meloŋ mé bad mésyə̄ə̄l nɛ́n bán, bad bétɛde abɛl dé mbéb á dǐn á Yesu, âbɛl boŋ Dyǒb álagsɛn bɔ́ mbéb. Bɛ́bootéd bad ḿmê nkalaŋ akale á Jerusalɛm. ");
INSERT INTO bssNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nyé-ʼaá, nyêdé bad ábe bényínné ḿmɛ́n mekan dǐd. ");
INSERT INTO bssNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mměn mɛ̌lōmē nyé chǒm éche Titɛ́ɛ ánhɔ̄bpē aá mɔ́ɔ̄lōmē nyé. Boŋ nyélyəg nyédyɛɛ á dyad-tê kə́ə́ŋ né nyêkudé ene ngíne echě ebíde ámīn.” ");
INSERT INTO bssNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Dɔ́ɔ Yesuɛ ásyə́ŋnédé bɔ́ á dyad-tê, ápɛɛné bɔ́ bɛnbɛn ne dyad á Bɛtani. Hɛ́ɛ ányéné mekáá ámīn, boŋ ánámté bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Áde ánamtɛɛ́ bɔ́ nɛ̂, dɔ́ɔ áchēnnē bɔ́, boŋ ápummé ádyōb. ");
INSERT INTO bssNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ábē bembapɛɛ bémbwɔ̄gē mɔ́ mebóbóŋ. Bêntǐm ámbīd á Jerusalɛm ne menyiŋge mésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Békǎg-kɛ á Ndáb-e-Dyǒb póndé ésyə̄ə̄l, âkémed Dyǒb.");
INSERT INTO bssNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Á mbooted, byánán Dyǒb dɛ́hə̌g nkǒŋsé Eyale êmmad abɛ́. Eyale émbɛ̄ ne Dyǒb. Échê Eyale ébédɛ́ɛ Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kə́ə́ŋse á mbooted Eyale émbɛ̄ hǒm ahɔ́g ne Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Dyǒb dêmbɛnléd échê Eyale âhəg bwěm éʼsyə̄ə̄l. Chǒm ké ehɔ́g éesaá éche Dyǒb dênhəgké ésebɛ́ ne Eyale. ");
INSERT INTO bssNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Aloŋgé ásyə̄ə̄l dénhūū ne Eyale, ádê aloŋgé dɔ́-ʼaá ápíínédé baányoŋ eʼnyínɛn bé ekíde. ");
INSERT INTO bssNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ábɛ̂ eʼnyínɛn bé ekíde éʼpɛneʼ á ehíntɛ́n-tê, ehíntɛ́n éēhɛ̄lɛ̄ɛ̄ bɔ́ abɔ́ded. ");
INSERT INTO bssNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mod nhɔ́g ampɛ̌ awě Dyǒb dénlōmmē. Dǐn démbɛ̄ mɔ́ bán Jɔnɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jɔnɛ ampɛ̌ âláa bad tə̂ŋgɛne ábê eʼnyínɛn bé ekíde, âbɛl nɛ́n bad bésyə̄ə̄l béwôg, bédúbe-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Saké mwěn abédé ábê eʼnyínɛn bé ekíde. Ampɛ̌ âbíd mbóŋ tə̂ŋgɛne ábê eʼnyínɛn bé ekíde. ");
INSERT INTO bssNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Eyale chɔ́ɔ ébédé eʼnyínɛn bé ekíde éʼ mbále ábe éʼnyînteʼ moonyoŋ asyəə́l ekíde. Mɔ́-ʼaá apagéʼáá á nkǒŋsé-te. ");
INSERT INTO bssNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Abédé á nkǒŋsé-te, boŋ kénɛ́ɛ Dyǒb dênhəgké nkǒŋsé ne mɔ́, nkǒŋsé ménkênchemmé mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ampɛ̌ áwē dyad boŋ ábē bad bénkênkobpé mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ké nɛ̂, ambɛ̌ doŋge á bad kunze âbɛ́ bǎn bé Dyǒb. Ábé bad bébédɛ́ɛ bad ábe bênkob mɔ́ ne adúbe áde béndūbɛ̄ɛ̄ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Béesaá bǎn bé Dyǒb nyaa echě moonyoŋ áchyáaʼɛ́ mwǎn. Bénkêmbáá bǎn bé Dyǒb byánán moonyoŋ mɔ́ achyáá bɔ́. Dyǒb děn dɔ́ɔ ádé awâb Titɛ́ɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Eyale êntǐm moonyoŋ, édyɛ̄ɛ̄ átîntê echɛ̂d. Anlón ne nsimé, anlúméd-tɛ syánē ngáne mbále e Dyǒb ékóó abɛ́. Dennyín échē ehúmé, ehúmé éche sáá ábágé mɔ́ nɛ́ɛ ḿmē mpɔm ḿ mwǎn. ");
INSERT INTO bssNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jɔnɛ anhɔ́b mam áyə̄l echê, anhə́ə́d aá, “Anɛ́n mod mɔ́ɔ ńláŋgéʼáá nyé mɛɛ́, ‘Mod ahúɛʼ ámbīd echêm awě atómé mɛ, áyə̄le bédɛ̂chyáá mɛ, né adé ámīn.’ ” ");
INSERT INTO bssNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Alón áde álóné ne nsimé ábɛ́lé syáā moosyəə́l dekudé nnam ámbīd e nnam. ");
INSERT INTO bssNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Wɛ́ɛ Mosɛɛ dɔ́ɔ Dyǒb dêmpoódté mbéndé. Boŋ nsimé ne mbále béhúú ne Yesu Krǐstəə. ");
INSERT INTO bssNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Modmod eényīnɛ̄ɛ̄ Dyǒb mbêd, éetómɛɛ́ ḿmē mpɔm ḿ mwǎn awě adé Dyǒb abɛ́-ʼɛ mɔ́ á akéb. Mwěmpɛn mɔ́ akidényīn mɔ́. Mɔ́ abɛlé boŋ Titɛ̂ Dyǒbɛ abyɛ́ɛn. ");
INSERT INTO bssNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Baámbáá bé Israɛl bé dyad á Jerusalɛm bénlōm beprisɛ ne bad bémpēe bé túmbé e Levi wɛ́ɛ Jɔnɛ, bán békɛ bésɛded mɔ́ bánken nzɛ́-módɛ́ ádíí. ");
INSERT INTO bssNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Enkêmbaŋgé ahɔ́b, boŋ ampanléd bɔ́ áte aá, “Saké mɛ ndé Ane-awě-Béwɔ́gté.” ");
INSERT INTO bssNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Hɛ́ɛ bésɛdtɛɛ́ mɔ́ bánken, “Nzé-ɔ̄ édíí? Wɛ-ɛɛ́ edé Elaijaa?” Ankwɛntɛ́n aá, “Aáy, meésaá mɔ́.” Bênsɛdéd mɔ́ ámpē bánken, “Wɛ-ɛɛ́ edé nkal éʼdəə́dəŋ awe bésinɛɛ́-yɛ?” Antimtɛ́n bɔ́ aá, “Aáy.” ");
INSERT INTO bssNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kə́ə́ŋne á asog dɔ́ɔ bésɛdtɛɛ́ mɔ́ bánken, “Nzé-ɔ̄ édíí? Láá sé âbɛl sétim ámbīd âláa bad ábe bélómé sé. Nzɛ́-módɛ́ wɛwɛ ehɔ́bé wɛɛ́ mɔ́dé?” ");
INSERT INTO bssNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Hɛ́ɛ Jɔnɛ átimtanné bɔ́ ne eʼyale ábe nkal éʼdəə́dəŋ Yesayaa ánhɔ̄bpē aá, “Mɛ́ɛ ndé ehɔ́b éche mod awě ahə̂ŋteʼ á ehyáŋge aá, ‘Nyétíi nzii eche Sáŋgwɛ́ɛ́.’ ” ");
INSERT INTO bssNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bɔɔb-pɔɔ́ Befarisia bɔ́ɔ bénlōm ábê bad ábe bémpɛ̌ wɛ́ɛ Jɔnɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Bênsɛdéd mɔ́ ámpē bánken, “Nzé weésɛ̌ Ane-awě-Béwɔ́gté, weésɛ̌-ʼɛ Elaijaa káa Nkal éʼdəə́dəŋ awe bésinɛɛ́, cheé-ɔ̄ édusanné bad?” ");
INSERT INTO bssNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Hɛ́ɛ Jɔnɛ átimtanné bɔ́ aá, “Ndusan ne mendíb, boŋ mod adé átîntê echɛ̂n awě nyéēbíiʼɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mɔ́ adé ane awě ǎpɛ̌ ámbīd echêm. Meékwognedɛɛ́ âhune ké ḿmē nkɔɔd mé metámbé.” ");
INSERT INTO bssNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ḿmɛ́n mésyə̄ə̄l mêmbɛnléd á dyad á Bɛtani á múde mé edíb é Jodan ḿmíníí wɛ́ɛ Jɔnɛ ádúsánnáá bad. ");
INSERT INTO bssNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nɛ́ɛ bǐn éʼsáŋgé, Jɔnɛ anyín nɛ́ɛ Yesuɛ áhúɛʼɛ́ níníí. Hɛ́ɛ áhɔ́bɛɛ́ aá, “Nyénɔneʼ, Mwǎn-a-Ńdyɔŋ ḿ mbód a Dyǒb mɔ̂nɛ. Mɔ́ ahúdeʼ mbéb ḿ bad bé nkǒŋsé. ");
INSERT INTO bssNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Anɛ́n mod mɔ́ɔ ńláŋgéʼáá nyé áde ménhɔ̄bpē mɛɛ́ ‘Mod ǎpɛ̌ ámbīd echêm awě atómé mɛ, áyə̄le bédɛ̂chyáá mɛ, né adé ámīn.’ ");
INSERT INTO bssNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ké mměn menkêmbííʼɛ́ mɔ́, boŋ mempɛ̌ ńdusán bad ne mendíb âbɛl bad bé Israɛl bébíi mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Hɛ́ɛ Jɔnɛ ábídɛɛ́ mbóŋ nɛ́n aá, “Menyín nɛ̂ŋgáne Edəə́dəŋ é Dyǒb ébídé ádyōb nɛ́ɛ élə̄ə̄, ésud mɔ́ á nló mîn, ébɛ́-ʼɛ ne mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ké nɛ̂, menkênsóŋtɛ́nné mɛɛ́ mɔ̂ nɛ. Boŋ Dyǒb áde dénlōm mɛ aá ńdusan bad ne mendíb dêmmǎd mɛ aláa aá, ‘Mod awě wɛ́nyīnnē nɛ́ɛ edəə́dəŋ é Dyǒb ésúdé á nló mîn, boŋ étyéém áhed, mɔ́ɔ̄dusɛ́n bad ne Edəə́dəŋ éche Ésáá.’ ");
INSERT INTO bssNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nnyíné ḿmɛ́n mekan mésyə̄ə̄l, mbíde-ʼɛ mbóŋ nɛ́n mɛɛ́ mɔ́ adé Mwǎn a Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nɛ́ɛ bǐn éʼsáŋgé ámpē, Jɔnɛ ambɛ́ áhed ne ábē bembapɛɛ bébɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Annyín nɛ́ɛ Yesuɛ átómɛɛ́. Ádě ányíné mɔ́, anhɔ́b aá, “Nyénɔneʼ, Mwǎn-a-Ńdyɔŋ ḿ mbód a Dyǒb mɔ̂ nɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ádě ábê bembapɛɛ bébɛ béwógé nɛ̂, bêmbootéd Yesuɛ ahíd. ");
INSERT INTO bssNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Áde Yesuɛ ánɔ́né ámbīd boŋ anyín nɛ̂ŋgáne béhídɛɛ́ mɔ́ ansɛdéd bɔ́ aáken, “Cheé nyéhɛdɛɛ́?” Bêntimtɛ́n mɔ́ bán, “Rabai” (awě adé bán meléede) “Héé édyɛʼɛ́?” ");
INSERT INTO bssNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Anláá bɔ́ aá, “Nyéhyag, nyényîn wɛ́ɛ ńdyɛɛʼɛ́.” Né-ɔɔ́, bênkɛ̌ anyín wɛ́ɛ ádyɛɛʼɛ́. Áde bépédé áhed ébédé dyam ngə́ŋ éniin é ngukɛ́l. Bêndyɛɛ́-ʼɛ áhed kə́ə́ŋ bǐn éʼhíntɛ́n bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Átîntê e ábê bembapɛɛ bébɛ ábe bénwōg dyam áde Jɔnɛ ánhɔ̄bpē boŋ béhíd-tɛ Yesuɛ, nhɔ́g abédé dǐn bán Andreya. Andreya abédɛ́ɛ Simɔn Petro mwǎnyaŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Né-ɔɔ́ dyam déʼsō, ankɛ̌ mwǎnyaŋ Simɔnɛ ahɛd. Anyíné-ʼaá mɔ́ boŋ álāŋgē mɔ́ aá, “Sênyíné Ane-awě-Béwɔ́gté” (nɛ́dē Krǐstəə). ");
INSERT INTO bssNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Dɔ́ɔ Andreya ápɛ́ɛ́né Simɔnɛ wɛ́ɛ Yesuɛ. Yesuɛ anɔné-ʼaá Simɔnɛ chóóŋ, boŋ áhɔ̄bē aá, “Edíi Simɔnɛ, mwǎn awě Jɔnɛ. Bɛ́chəgé wɛ bɔɔb bán Sɛpasɛ.” (Ádɛ́n dǐn ádíi melemlem nɛ́ɛ Petro, nɛ̂ ádé ndim e aláá.) ");
INSERT INTO bssNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nɛ́ɛ bǐn éʼsáŋgé, Yesuɛ ammǎd aá mɔ́kag á mbwɔ́g e Galilia. Dɔ́ɔ ákíí Filibɛ atán boŋ álāŋgē mɔ́ aá, “Hídé mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filibɛ abédɛ́ɛ mod a dyad á Betsaida, melemlem mé dyad ádě Andreya bɔ́ Petro bémbīdtē. ");
INSERT INTO bssNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filibɛ anyín Nataniɛlɛ. Hɛ́ɛ álâŋgɛɛ́ mɔ́ nɛ́n aá, “Sênyíné ane mod awě Mosɛɛ ântenlé mam áyə̄l echê áwe mbéndé-te. Mɔ́ɔ kə́ə́ŋne bekal-bé-eʼdəə́dəŋ bêntenlé mam á yə̌l. Adíi Yesuɛ mod a dyad á Nazarɛt, mwǎn awě Josɛbɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Hɛ́ɛ Nataniɛlɛ ásɛdtɛɛ́ mɔ́ aáken, “Dyam á bwâm áhéé áhɛle ábíd á Nazarɛt?” Dɔ́ɔ Filibɛ álâŋgɛɛ́ mɔ́ aá, “Hyɛ̌ ényîn.” ");
INSERT INTO bssNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Áde Yesuɛ ányíné Nataniɛlɛ ahúɛʼ, dɔ́ɔ áhɔ́bɛɛ́ áyə̄l echê aá, “Nyénɔne, mwǎn a Israɛl nɛ́n sóm-sóm, awě mbɛltéd ńtyéémé!” ");
INSERT INTO bssNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Hɛ́ɛ Nataniɛlɛ ásɛdtɛɛ́ mɔ́ aáken, “Chán émwédé mɛ abíi?” Hɛ́ɛ Yesuɛ ákwɛntanné aá, “Filibɛ adɛ̂hɔ́b aá mɔ́chəge wɛ, nnyíné wɛ á alín á ngəl sé.” ");
INSERT INTO bssNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Hɛ́ɛ Nataniɛlɛ áhɔ́bɛɛ́ aá, “A meléed, edíi Mwǎn a Dyǒb. Wɛ-ɛɛ́ edé kə̂ŋ e bad bé Israɛl.” ");
INSERT INTO bssNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesuɛ antimtɛ́n mɔ́ aá, “Edúbpé áyə̄le ńláŋgé wɛ mɛɛ́ nnyíné wɛ á alín á ngəl sé. Wɛɛ́nyīn mam ḿmě métómé nɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Hɛ́ɛ ábádɛɛ́ aá, “Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, nyɛ́ɛ̄nyīn nɛ́ɛ dyǒb ánédnédé nyênyín-nɛ nɛ́ɛ ángɛl é Dyǒb échə́gkɛɛ́ ésudé-ʼɛ Mwǎn-a-Moonyoŋ ámīn.” ");
INSERT INTO bssNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ámbīd e eʼpun éʼbɛ, eʼwóŋgé bémbɛ̄ á dyad á Kana á mbwɔ́g e Galilia. Yesuɛ nyaá ambɛ́ áhed. ");
INSERT INTO bssNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Bénlēbē Yesuɛ ne ábē bembapɛɛ bɔ́mpē á eʼwóŋgé wɛ̂. ");
INSERT INTO bssNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mǐm mêmmaá áte. Hɛ̂ dɔ́ɔ Yesuɛ nyaá ápédé áwē boŋ álāŋgē mɔ́ aá, “Mǐm mémáá bɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ mɔ́ aá, “Á-nyaŋ, weetə̂ŋgɛnɛɛ́ mɛ dyam áde ńtə́ŋgɛ́né abɛl aláa. Echem póndé eépédɛ́ɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Hɛ́ɛ nyaá ákíí bembəledɛ bé ngande bɛ̂ aláa aá, “Nyébɛl kéchéé éche áláŋgé nyé aá nyébɛl.” ");
INSERT INTO bssNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Bɔɔb-pɔɔ́, mbeé é meláá ébédé bɛnbɛn ne áhed. Échê ndín é mbeé chɔ́ɔ bad bé Israɛl bébɛ́nládtáá âhɛ́ mendíb áte á nwobe ń yə̌l á póndé e mekáne echâb. Ké ehéé etedéʼáá dyam mbwɔ́kɛl e líta e mendíb. ");
INSERT INTO bssNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ bembəledɛ bé ngande bɛ̂ aá, “Nyélóned mbeé chê ne mendíb.” Né-ɔɔ́, bénlōnēd échê mbeé hɔɔd ne mendíb. ");
INSERT INTO bssNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Dɔ́ɔ álâŋgɛɛ́ bɔ́ aá, “Nyékɔbe-ɔɔ́ mendíb bɔɔb, nyékɛɛn wɛ́ɛ mod awě alyə́gteʼ mekan mé ncháged.” Né-ɔɔ́, bêmbɛ̌l áned. ");
INSERT INTO bssNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Áde ane mod áwóglɛ́né ḿmê mendíb ḿme mémáá mǐm atim, enkêmbííʼɛ́ wɛ́ɛ mébídé, (boŋ bembəledɛ ábe bênkɛ̌ ḿmê mendíb akɔbe bémbíi). Dɔ́ɔ áchə́gé mod awě akude sɔ́mbé, ");
INSERT INTO bssNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","boŋ álāŋgē mɔ́ aá, “Mod tɛ́ɛ́ abɛlé asébe achágtɛ́n bad mǐm ḿmě mébóó. Bad bémaa-ʼáa mɔ́ amwɛ́ bwâmbwam, boŋ ábagé bɔ́ ḿmě méeboo. Boŋ wɛ, etimé ekǒŋgé ḿme mébóó kə́ə́ŋ ne bɔɔb.” ");
INSERT INTO bssNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ḿmɛ́n menyáké ḿmě Yesuɛ ábɛ́lé á Kana á mbwɔ́g e Galilia mɔ́ɔ mébédé ábē eʼchemléd éʼsō. Hɛ̂ dɔ́-ʼaá álúmté échē ehúmé, ábē bembapɛɛ bênsǔm-mɛ ḿmab nlém áwē. ");
INSERT INTO bssNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nɛ́ɛ nɛ́n ámáá atóm, Yesuɛ ansyɔgé á dyad á Kapenahum nchoo ne nyaá, baányaŋ ne ábē bembapɛɛ. Bêndyɛɛ́-ʼɛ áwed nguse é eʼpun. ");
INSERT INTO bssNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ádě póndé e Ngande e Nnyíme-ámīn ékwógé bad bé Israɛl apɛ, Yesuɛ ankɛ̌ á dyad á Jerusalɛm. ");
INSERT INTO bssNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ádě ápédé áwed, ankɛ̌ á Ndáb-e-Dyǒb. Antán nɛ́ɛ bad békábɛɛ́ dyɔn. Bésóméʼ-ʼáá nyag, mbód ne mbəŋgé, bepɛle-bé-mɔné-ʼɛ bépɛnlé mɔné. ");
INSERT INTO bssNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Hɛ́ɛ átédé nkɔɔd, ámané etaŋgú ánanné bɔ́ nchoo ne échab mbód ne nyag á Ndáb-e-Dyǒb wɛ̂. Ampáŋtéd mɔné ḿmě bad bépɛ́nléʼáá áte, ákūnē-ʼɛ betébelɛ ábe bépɛ́nléʼáá ḿmê mɔné ámīn mekuu ámīn. ");
INSERT INTO bssNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Anláá bad ábe bésóméʼáá mbəŋgé aá, “Nyébídɛn beləə bén á ebwɔ́g. Nyéētimté ndáb echě echem Sáŋ ndáb e dyɔn.” ");
INSERT INTO bssNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ádě ábē bembapɛɛ bényíné nɛ̂, dɔ́ɔ békámtɛ́né epɛd é kálag e Dyǒb éche éhɔ́be nɛ́n bán “A-Sáŋ, kə́n echě ńwóó áyə̄le echoŋ ndáb ěwūū mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Hɛ́ɛ benkamlɛnɛ bé bad bé Israɛl bétímé ámbīd, bésɛdté mɔ́ bánken, “Eʼchemléd éʼhéé éhɛle elúméd sé âbɛl sébíi bán ewóó kunze âbɛl enɛ́n ndín e dyam?” ");
INSERT INTO bssNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesuɛ antimtɛ́n bɔ́ aá, “Nyépâŋ enɛ́n Ndáb-e-Dyǒb, mɛ̌lōŋ chɔ́ ámpē áyə̄le eʼpun éʼláán.” ");
INSERT INTO bssNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Dɔ́ɔ ábê bad béhɔ́bɛɛ́ bánken, “Enɛ́n ndáb echě bétédé móom mé mwɛ̌ méniin ne mwɛ̌ ntóób chɔ́ɔ éhɔ́bɛɛ́ wɛɛ́ mɔ́ɔ̄lōŋ áyə̄le eʼpun éʼláán-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Boŋ ndáb echě Yesuɛ áhɔ́béʼáá ebédɛ́ɛ dásɔ̄ eche yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Né-ɔɔ́ ámbīd eche Yesuɛ áwédé boŋ Dyǒb ápūūd mɔ́, dɔ́ɔ ábē bembapɛɛ békámtɛ́né dyam ádě ánlāāʼɛ́ bɔ́. Béndūbē mam ḿmě méténlédé á kálag e Dyǒb, bédúbé-ʼɛ eʼyale ábe Yesuɛ ánhɔ̄bpē. ");
INSERT INTO bssNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Á póndé e Ngande e Nnyíme-ámīn, áde Yesuɛ ámbɛ̄ɛ̄ á dyad á Jerusalɛm, bad híin béndūbē mɔ́ ngáne bényīnnē menyáké ḿmě ábɛlɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Boŋ ké nɛ̂, Yesuɛ enkênsummé nlém áwāb, áyə̄le ambíí moosyəə́l áte. ");
INSERT INTO bssNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Modmod enkêntə́ŋgɛ́nné mɔ́ dyam aláa tə̂ŋgɛne mod ampée áyə̄le mwěn ammǎd moonyoŋ asyəə́l nlém abíi áte. ");
INSERT INTO bssNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mod nhɔ́g abédé bán Nikodemusɛ. Abédɛ́ɛ nhɔ́g awě alyə́gtéʼáá bad bé Israɛl abɛ́-ʼɛ epepé é bad bé Farisia. ");
INSERT INTO bssNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mbwɛ nhɔ́g ampɛ̌ wɛ́ɛ Yesuɛ nkuu, álāŋgē mɔ́ aá, “A-meléed, sêchemé nɛ́n bán, edíi meléede awě Dyǒb álómé. Áyə̄le nzé Dyǒb déesɛ̌ ne mod, eéhɛ̄lɛ̄ɛ̄-sɛ ábɛlé mekan mé menyáké ḿmě ébɛlɛɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesuɛ ankwɛntɛ́n mɔ́ aá, “Ne mbále, modmod eéhɛ̄lɛ̄ɛ̄-sɛ asɔ́l á nkamlɛn ń Dyǒb ésebán achyáádté ámpē.” ");
INSERT INTO bssNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemusɛ-ʼɛ ansɛdéd mɔ́ aáken, “Chán mod awě amaá akwog áhɛle se achyáád ekɔ́ɔ́lé-ekɔ́ɔ́lé? Éesaá mbále nɛ́n bán eéhɛ̄lɛ̄ɛ̄-sɛ asɔ́l á abum ádē nyaá ngen échě élóntɛ́né ébɛ âbɛl béchyáa mɔ́ ámpē-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Dɔ́ɔ Yesuɛ átimtanné mɔ́ aá, “Ne mbále, nlâŋge wɛ mɛɛ́, nzé béēchyáa mod ne mendíb ne Edəə́dəŋ éēhɛ̄lɛ̄ɛ̄-sɛ asɔ́l á nkamlɛn ń Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ane awě achyáádté ne moonyoŋ a ekob, adíí moonyoŋ. Awě mɔ́-ʼɛ achyáádté ne Edəə́dəŋ é Dyǒb adíí Edəə́dəŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Weebág menyáké ngáne ńhɔ́bé mɛɛ́ ‘Mod atə́ŋgɛ́né achyáád ekɔ́ɔ́lé.’ ");
INSERT INTO bssNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nzé epub éhɔ́bé bán chɔ́ étómeʼ, pɛd echě édə́ə́ akɛ chɔ́ɔ ékagké. Ewógeʼ ntɔgag ḿme ébɛlɛɛ́ boŋ weebíɛ́ʼɛ́ wɛ́ɛ ébídɛɛ́ kéʼɛ wɛ́ɛ ékagké. Melemlem nɛ̂ dɔ́ɔ édíí ne mod ké ahéé awě achyáádté ne Edəə́dəŋ é Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Hɛ́ɛ Nikodemusɛ ásɛdtɛɛ́ mɔ́ aáken, “Chán nɛ́n áhɛlɛsɛ ábɛnled?” ");
INSERT INTO bssNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesuɛ ankwɛntɛ́n mɔ́ aá, “Nɛ́ɛ édíí meléede ambáá a bad bé Israɛl weéhɛ̄lēʼ ḿmɛ́n mekan asôŋtɛn-nɛ? ");
INSERT INTO bssNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ne mbále, nlâŋge wɛ mɛɛ́, dyam áde sébíí dɔ́ɔ séhɔ́bɛɛ́. Sébīde-ʼɛ mbóŋ ne dyam ádě sényíné. Boŋ nyé modmod nyéēkwɛntɛnɛɛ́ chǒm éche séhɔ́bɛɛ́ adúbe. ");
INSERT INTO bssNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nɛ́ɛ ńlâŋgɛɛ́ nyé mekan ḿme médé mekan mé nkǒŋsé, nyéedúbpe, chán-nɔ̄ nyɛ́mwɛɛ́ adúbe nzé nláŋgé nyé mekan ḿmě médé mekan mɛ nkoŋ ḿ mîn? ");
INSERT INTO bssNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Modmod eékīīʼɛ́ á nkoŋ ḿ mîn étōmɛɛ́ Mwǎn-a-Moonyoŋ awě abídé áwed boŋ ápɛ á nkǒŋsé.” ");
INSERT INTO bssNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ngáne Mosɛɛ âmbomɛ́ɛ́ nyə̌ á akon boŋ atíí dɔ́ ámīn á ehyáŋge, melemlem nɛ̂ dɔ́ɔ bɛ́tīīʼɛ́ Mwǎn-a-Moonyoŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Nɛ́n dɛ́bɛnléd âbɛl boŋ kénzɛ́ɛ́ awě adúbpé mɔ́ ákud aloŋgé áde déemaáʼ. ");
INSERT INTO bssNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Dyǒb átómtɛ́né bad bé nkǒŋsé adəŋ. Né-ɔɔ́ anlóm ḿmē mpɔm ḿ Mwǎn âbɛl kénzɛ́ɛ́ awě adúbpé mɔ́ eewág boŋ ákud aloŋgé áde déemaáʼ. ");
INSERT INTO bssNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dyǒb dénkênlómmé awe Mwǎn á nkǒŋsé âkáad bad. Aloŋgé á bad dɔ́ɔ ánlōmmē mɔ́ âsoŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kénzɛ́ɛ́ awě adúbpé mɔ́ eékwaá nkáásé, boŋ kénzɛ́ɛ́ awě eedúbpe mɔ́, amaá nkáásé akwɛ áyə̄le eedúbpɛɛ́ mpɔm ḿ Mwǎn ń Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nɛ́n dɔ́ɔ mbakú e Dyǒb édíí: Eʼnyínɛn bé ekíde éʼpédé á nkǒŋsé, boŋ baányoŋ bédə́ə́ ehíntɛ́n tómaa eʼnyínɛn bé ekíde áyə̄le ḿmāb mbɛltéd ńdé mbéb. ");
INSERT INTO bssNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kénzɛ́ɛ́ awě abɛle mbéb, akɔɔ́ ábê eʼnyínɛn bé ekíde, éepaá-ʼaá á eʼnyínɛn bé ekíde-tê âbáŋ nɛ́n ḿmē mbɛltéd mé mbéb méēbīdē áwed. ");
INSERT INTO bssNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Boŋ kénzɛ́ɛ́ awě abɛle mam mé mbále, abídeʼ á eʼnyínɛn bé ekíde âbɛl nɛ́n bad bényîn bán kéchéé échě ábɛlɛɛ́ awógne Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ámbīd e nɛ̂, Yesuɛ ne ábē bembapɛɛ bênkɛ̌ á mbwɔ́g e Judeya. Bɔ́bɔ̄ɔ bêndyɛɛ́ áwed nguse é eʼpun, ádusán-nɛ bad. ");
INSERT INTO bssNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jɔnɛ mɔ́mpē adusánáá bad á dyad á Anɔn bɛnbɛn ne á dyad á Salim áyə̄le mendíb mémbɛ áhed bwâmbwam. Bad békágéʼáá áwē, ádusán-nɛ bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nɛ́n ábédé byánán bɛ́hɛ̄ Jɔnɛ á mbwɔg. ");
INSERT INTO bssNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Bɔɔb-pɔɔ́, doŋge dé bembapɛɛ ábe Jɔnɛ bépéntánnáá ne mod a Israɛl tə̂ŋgɛne nwobe ń yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Dɔ́ɔ bépédé wɛ́ɛ Jɔnɛ boŋ bélāŋgē mɔ́ bán, “A-meléed, ekamtan mod awě nyúmɔ̄ nyêbédé á pɛd e edíb é Jodan eníníí? Mod awě éhɔ́béʼáá mam á yə̌l echê. Nɔnéʼ! Mɔ́ɔ adusan bad níníí! Bad híin békagke áwē.” ");
INSERT INTO bssNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jɔnɛ ankwɛntɛ́n aá, “Modmod eéhɛ̄lɛ̄ɛ̄-sɛ ákud chǒm, ésebán Dyǒb ábágé mɔ́ chɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nyéběn nyêdé mɛ mbóŋ nɛ́n bán menhɔ́b mɛɛ́ saké mɛ ndé Ane-awě-Béwɔ́gté. Dyǒb dénlōm mɛ áʼsō âboŋsɛn bad áyə̄le epɛ éche Ane-awě-Béwɔ́gté. ");
INSERT INTO bssNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mod awě akude sɔ́mbé mɔ́ɔ awóó sɔ́mbé. Boŋ nsón-a-echoŋ a mod awě akude sɔ́mbé, awě atyéeme mɔ́ á nkəg áwōglān mɔ́, abâg menyiŋge nzé awóge mɔ́ ehɔ́b. Né-ɔɔ́, nɛ́n dɔ́ɔ ákə́ə́ boŋ nlón ne menyiŋge. ");
INSERT INTO bssNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Edúbé échē étə́ŋgɛ́né nɛ́ɛ échə́gkɛɛ́, échêm-mɛ ésudeʼ.” ");
INSERT INTO bssNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ane awě abídé ádyōb atómé moosyəə́l. Ane awě mɔ́-ʼɛ achyáádté á nkǒŋsé adíi mod a nkǒŋsé, áhɔ̄bē-ʼɛ mam mé nkǒŋsé, boŋ ane awě abídé ádyōb adé ámīn e moosyəə́l. ");
INSERT INTO bssNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Chǒm éche ányíné ne éche áwógé chɔ́ɔ áhɔ́bɛɛ́ boŋ ké nɛ̂, modmod eedúbpɛ́ɛ́ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Boŋ kénzɛ́ɛ́ awě akobé chǒm échě áhɔ́bé, né akwɛntɛ́né ne nlém ńsyə̄ə̄l aá Dyǒb ádé mbále. ");
INSERT INTO bssNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Pɔ́le e Dyǒb chɔ́ɔ mod awě Dyǒb álómé áhɔ́bɛɛ́ áyə̄le Dyǒb déenɔnɛ́ɛ́ ámbīd nzé abageʼ mod échē Edəə́dəŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Titɛ́ɛ adəə́ awe Mwǎn, abagé-ʼɛ mekan mésyə̄ə̄l áwē mekáá. ");
INSERT INTO bssNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kénzɛ́ɛ́ awě asumé nlém wɛ́ɛ ane Mwǎn, akudé aloŋgé ádě déemaáʼ. Boŋ kénzɛ́ɛ́ awě eébɛ̄lēʼ ngáne áhɔ́bé éekudté aloŋgé áde déemaáʼ, ǎbɛ̄ akud nkɔ́gsɛn ń Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesuɛ ambíí aá Befarisia béwógé nɛ́n bán mɔ́kude ekud é bembapɛɛ tómaa ne Jɔnɛ, mɔ́dusan-nɛ bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Kénɛ́ɛ Yesuɛ mwěn éedusannaá bad, ábē bembapɛɛ bɔ́ɔ bédúsánnáá bad). ");
INSERT INTO bssNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Awóg áde Befarisia bénwōgkē nɛ̂ dêmbɛ̌l Yesuɛ anhidé á mbwɔ́g e Judeya átim ámbīd á mbwɔ́g e Galilia. ");
INSERT INTO bssNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Byánán ǎpɛ á Galilia antə́ŋgɛ́n nɛ́ɛ ápóó a mbwɔ́g e Samaria. ");
INSERT INTO bssNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Á mbwɔ́g e Samaria wɛ̂ ampɛ̌ á dyad áde béchəgɛɛ́ bán Sika. Ádɛ́n dyad démbɛ̄ bɛnbɛn ne ndɔɔb echě Jakɔbɛ ámbɛɛ́ mwǎn Josɛbɛ se eʼbɔɔ́d. ");
INSERT INTO bssNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Áyə̄le ene ndɔɔb echóg éche bélímé éche bébwɛ́léʼáá mendíb áte émbɛ̄ áhed. Échɛ́n echóg é mendíb ébédɛ́ɛ éche Jakɔbɛ. Ngáne ekɛ énkɔ̄mēdtē Yesuɛ andyɛɛ́ á nkəg mé échê echóg é mendíb. Nɛ́n ábédé dyam-ɛ́ɛ ádé kəd. ");
INSERT INTO bssNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Hɛ́ɛ mmwaád a Samaria nhɔ́g áhyédé mendíb abwɛl. Yesuɛ anláá mɔ́ aá, “Hɛ́ mɛ mwǎ mendíb mé amwɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Enɛ́n póndé Yesuɛ ábɛ̄ bembapɛɛ bênkɛ̌ á dyad-tê âchan ndyééd. ");
INSERT INTO bssNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Hɛ́ɛ ane mmwaád átimtanné mɔ́ aá “Ebɛ́ mod a Israɛl, mɛ-ʼɛ mbɛ́ mmwaád a Samaria, échɔ̄mē mɛ mendíb-ɛ?” (áyə̄le bad bé Israɛl ne bad bé Samaria béechemtannaá.) ");
INSERT INTO bssNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Hɛ́ɛ Yesuɛ ákwɛntanné mɔ́ aá, “Nzé wembíí mendɛ mé Dyǒb, ebíí-ʼɛ mod awě ahɛdne wɛ mendíb, né ehɛ̌dné mɛ mendíb. Né mbagé-ʼɛ wɛ mendíb ḿme mébage aloŋgé.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ane mmwaád ankwɛntɛ́n mɔ́ aá, “A-Sáŋ, ké chǒm éche bébwɛnlɛɛ́ mendíb weewóoʼɛ́, echóg é mendíb-pɛ échábé ásē, hɛ́ɛ wɛ́tēdtē ḿmê mendíb ḿmē mébage aloŋgé. ");
INSERT INTO bssNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Echɛd sáá ambáá Jakɔbɛ mɔ̂nlyə́gnéd sé échɛ́n echóg é mendíb. Mwěn, ábē bǎn ne ábē eʼlém éʼsyə̄ə̄l, hɛ́n-ɛɛ́ bémwágéʼáá mendíb. Nɛ́dē ehɔ́be bɔɔb wɛɛ́ mɔ́tōmē Jakɔbɛ-yɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesuɛ ankwɛntɛ́n aá, “Kénzɛ́ɛ́ awě amwédé ḿmɛ́n mendíb, píd ěbɛ̄ ekób mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Boŋ kénzɛ́ɛ́ awě ǎmwɛ̄ mendíb ḿme mɛ́bɛɛ́ mɔ́ píd éekóbpé mɔ́ mbêd. Mendíb ḿme mɛ́bɛɛ́ mɔ́, mɛ́bɛ̄ mɔ́ áte nɛ́ɛ n'yɛ́lɛ́ ḿme méēlēnɛ̄ʼ. Ḿmê mendíb mɛ́bɛ̌ mɔ́ aloŋgé áde déemaáʼ.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Hɛ́ɛ ane mmwaád álâŋgɛɛ́ mɔ́ aá, “A-Sáŋ, bɛɛ́ mɛ ḿmê mendíb âbɛl nɛ́n píd eekóbé mémpē, meépāg-kɛ hɛ́n âbwɛl mendíb ámpē.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ mɔ́ aá, “Kǎg, ékɛ échəg awoŋ nchóm, boŋ étim ámbīd hɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ane mmwaád antimtɛ́n Yesuɛ aá, “Mewóoʼɛ́ nchóm.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Dɔ́ɔ Yesuɛ áhɔ́bɛɛ́ aá, “Ekalé mbále wɛɛ́ mɔ́ɔwóoʼɛ́ nchóm. Áyə̄le ekéwōŋ bechóm bétáan, ké ane mod-tɛ awě nyúmɔ̄ nyêdé bɔɔb eésaá awoŋ nchóm. Dyam áde éhɔ́bé ádé mbále.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Awóg áde ane mmwaád áwógé nɛ̂ dɔ́ɔ álâŋgɛɛ́ Yesuɛ aá, “A-Sáŋ, nnyíne nɛ́n mɛɛ́ edíi nkal éʼdəə́dəŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Á mbɔɔd-mîn hɛ́n dɔ́ɔ ábɛ̄d besáá bébágéʼáá Dyǒb edúbé, boŋ nyé bad bé Israɛl nyêhɔ́be bán á Jerusalɛm dɔ́ɔ bétə́ŋgɛ́né Dyǒb edúbé abɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ mɔ́ aá, “Á-mmwaád nɛ́n, sóŋtɛ́n chǒm éche ńlâŋgɛɛ́ wɛ. Póndé ehúɛʼ echě nyéebaá Titɛ́ɛ edúbé á mbɔɔd-mîn hɛ́n kéʼɛ á Jerusalɛm. ");
INSERT INTO bssNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nyé bad bé Samaria nyêbage chǒm éche nyéebíiʼɛ́ edúbé. Boŋ sé bad bé Israɛl sêbage mɔ́ edúbé ngáne sébíí mɔ́ áyə̄le nɛ́n eʼsoósoŋ éʼhúú dásɔ̄ ne bad bé Israɛl. ");
INSERT INTO bssNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Boŋ póndé ehúɛʼ, emaá-ʼɛ ne apɛ, echě bad ábe bébage Titɛ́ɛ edúbé ne nlém nhɔ́g bɛ́bɛɛ́ mɔ́ échê edúbé á Edəə́dəŋ ne á mbále-tê. Échê ndín é bad chɔ́ɔ Titɛ́ɛ áhɛdɛɛ́ aá bébage mɔ́ edúbé. ");
INSERT INTO bssNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dyǒb ádíi Edəə́dəŋ, bad-tɛ ábe bébage mɔ́ edúbé bétə́ŋgɛ́né mɔ́ chɔ́ abɛ á Edəə́dəŋ ne á mbále-tê.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Hɛ́ɛ ane mmwaád álâŋgɛɛ́ Yesuɛ aá, “Mbíí mɛɛ́ Ane-awě-Béwɔ́gté ǎpɛ̌. Póndé echě ápɛɛ́, ǎtə̄nlēd sé mekan mésyə̄ə̄l áte.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ mɔ́ aá, “Mɛ awě sóo dekaleʼ mɛ-ɛɛ́ ndé mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ene póndé chěn dɔ́ɔ ábē bembapɛɛ bépédé. Yə̌l enkɔ́m bɔ́ áte ânyín nɛ́ɛ ákanlɛɛ́ mmwaád. Boŋ bɔ́ modmod eésɛdtɛɛ́ mɔ́ aáken, “Cheé éhɛdɛɛ́?” Ké-ʼɛ “Cheé nyé ane mmwaád nyékalɛɛ́?” ");
INSERT INTO bssNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ane mmwaád antɛdé apom dé mendíb, átim ámbīd á dyad-tê, ákɛ aláá bad aá, ");
INSERT INTO bssNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Nyéhyag, nyényîn mod awě áláŋgé mɛ mam mésyə̄ə̄l ḿme ńkémbɛnlé. Nyé bán, saké Ane-awě-Béwɔ́gté awě bésinɛɛ́ nɛ́n-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Dɔ́ɔ ábê bad béhídté á dyad-tê âkɛ dé atán Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ene póndé, bembapɛɛ ábe Yesuɛ béchááʼáá mɔ́ bán, “A-meléed dyɛ́ ndyééd.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Boŋ Yesuɛ ankwɛntɛ́n bɔ́ aá, “Nwóó ndyééd e adyɛ́ echě nyéēbíiʼɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Hɛ́ɛ ábē bembapɛɛ bésɛdtɛɛ́ nhɔ́g ne aníníí bánken, “mod múmɔ́ apiínédé mɔ́ ndyééd-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Echem ndyééd edíi âbɛl nsɔ́n ḿme mod awě alómé mɛ, áhɔ́bé aá ḿbɛl, âmad-tɛ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ngɔ́mē nyêyɔ̌gké ahɔ́b bán ámbíd e ngɔn éniin, né póndé e mbote epedéʼ? Nyénɔneʼ, nlâŋge nyé nɛ́n mɛ́ɛ nyékɛ́led dǐd áte, nyényîn ngáne mbote émáá mboŋsɛ́n abɛ́, âpád á nzag-tê. ");
INSERT INTO bssNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ké bɔɔb mod awě apáde adé ḿme nsábe akud, alade mbote é aloŋgé áde déemaáʼ, âbɛl nɛ́n mod awě awéne bɔ́ mod awě apáde bɔ́ moosyəə́l bébɛ̂ menyiŋge. ");
INSERT INTO bssNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Né-ɔɔ́ ngan echě békalɛɛ́ nɛ́n bán, ‘mod nhɔ́g awénɛɛ́, aníníí-ʼɛ ahúd edé mbále.’ ");
INSERT INTO bssNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mɛ-ɛɛ́ nlómé nyé mbote âkɛ dé apád éche nyéēwénɛɛ́. Bad bémpēe bébɛ́lé nsɔ́n, nyé-ʼɛ nyêtombwan bɔ́ nsɔ́n.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bad bé Samaria híin ábe bémbīd ádê dyad béndūbē Yesuɛ áyə̄le mam ḿmē ane mmwaád ánlāāʼɛ́ bɔ́. Ane mmwaád anláá bɔ́ aá, “Aláŋgé mɛ mekan mésyə̄ə̄l ḿme ńkémbɛnlé.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Né-ɔɔ́, áde bad bé Samaria bépédé áwē, bénchāŋ mɔ́ bán ádyɛɛ áwāb dyad. Né-ɔɔ́, andyɛɛ́ áwed eʼpun éʼbɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bad híin bémpēe béndūbē mɔ́ áyə̄le áde ayə́ge. ");
INSERT INTO bssNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bénlāā ane mmwaád bán, “Saké dyam áde élāŋgē sé děmpɛn dɔ́ɔ ákə́ə́ boŋ sêdúbé Yesuɛ, boŋ séběn sêwógné etúu, sêbíí-ʼɛ bán mwěn-ɛɛ́ akǒŋté Nsoodɛ a nkǒŋsé abɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ámbīd e eʼpun éʼbɛ Yesuɛ anhidé á mbwɔ́g e Samaria, ákɛ á mbwɔg e Galilia. ");
INSERT INTO bssNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesuɛ mwěn anhɔ́b aá, nkal éʼdəə́dəŋ eewóóʼɛ́ edúbé áwē dyad. ");
INSERT INTO bssNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Áde ápédé á mbwɔ́g e Galilia, bad bênkob mɔ́. Bênkob mɔ́ áyə̄le bémbɛ̄ á Ngande e Nnyíme ámīn á Jerusalɛm, bényín-nɛ mam mésyə̄ə̄l ḿme ámbɛnlé. ");
INSERT INTO bssNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Hɛ́ɛ Yesuɛ átímé ámbīd á Kana, wɛ́ɛ ântimédté mendíb mǐm. Áhed-tɛ dɔ́ɔ mod ambáá a ngɔ́menaa ábédé awě mwǎn ákónléʼáá á dyad á Kapenahum. ");
INSERT INTO bssNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Áde ane mod áwógé bán Yesuɛ ábídé á mbwɔ́g e Judeya apedé á mbwɔ́g e Galilia, ampɛ̌ áwē, acháŋ mɔ́ aá áchood mwǎn, awě ambɛ́ bɛnbɛn ne kwééd. ");
INSERT INTO bssNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesuɛ anláá mɔ́ aá, “Nyé modmod nyéedúbpɛ́ɛ́ kə́ə́ŋ né nyênyíné eʼchemléd ne menyáké.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ane mod ambáá a ngɔ́menaa anláá mɔ́ aá, “A-Sáŋ, hyǎg, dékag kwééd edé ehɔ́b bán chɔ́ ekóbe awem mwǎn.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesuɛ antimtɛ́n mɔ́ aá, “Kǎg, awoŋ mwǎn ǎbɛ̄ á aloŋgé.” Ane mod andúbé eʼyale ábe Yesuɛ, ákɛ̄-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Áde ane mod ádíí adé á nzii e esú dɔ́ɔ ábē bembəledɛ bébómné mɔ́, boŋ bélāŋgē mɔ́ bán, “awoŋ mwǎn ǎbɛ̄ á aloŋgé.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Dɔ́ɔ ásɛ́dté bɔ́ póndé echě ane mwǎn âmbootédté bwâm abɛ́. Bénlāā mɔ́ bán, “Ahéb dêntɛdé mɔ́ chǎn á ngə́ŋ pɔ́g.” ");
INSERT INTO bssNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Dɔ́ɔ ane mod ákámtɛ́né aá ḿmê melemlem mé póndé mɔ́ɔ Yesuɛ ánlāāʼɛ́ mɔ́ aá, “Awoŋ mwǎn ǎbɛ̄ á aloŋgé.” Né-ɔɔ́, bɔ́ɔbɛ eche ndáb béndūbē Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ábɛ́n eʼchemléd bɔ́ɔ bémbɛ̄ eʼchemléd ábe éʼlóntɛ́né éʼbɛ ábe Yesuɛ ámbɛnlé áde ábídé á mbwɔ́g e Judeya boŋ ápɛ̄ á mbwɔ́g e Galilia. ");
INSERT INTO bssNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ámbīd e ḿmɛ́n mésyə̄ə̄l, Yesuɛ ankɛ̌ á Jerusalɛm á ngande e bad bé Israɛl. ");
INSERT INTO bssNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Á Jerusalɛm wɛ̂, bɛnbɛn ne Nsəl mé Eʼkɛ́ mé Ńdyɔŋ ḿ mbód, etoŋ ébédé áhed. Échɛ́n etoŋ béchə́géʼáá chɔ́ á ehɔ́b é bad bé Israɛl bán Bɛtzata. Énwōŋ mebepé métáan. ");
INSERT INTO bssNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Á mebepé-te wɛ̂, bad bé nkole bénkūmɛ̄n áhed, ábe békwédé ndím, ábe bédé eʼpɛd éʼ bad ne ábe béwédé epɛd. ");
INSERT INTO bssNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mod nhɔ́g abédé áhed awě akékolé á etûn é móom mé mwɛ̌ méláán ne mwɛ̌ waam. ");
INSERT INTO bssNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Áde Yesuɛ ápédé áhed annyín ngáne ane mod ánáŋgé ásē, abíí-ʼɛ aá nkole ḿbémé mɔ́ á yə̌l. Dɔ́ɔ ásɛ́dté mɔ́ aáken, “Edəə́ bwâm adyɛɛ-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ane mod antimtɛ́n mɔ́ aá, “A-sáŋ, meewóoʼɛ́ mod awe ǎsɔ̄lēd mɛ á etoŋ-tê nzé mendíb mépúútédé áte. Nlédte ahɔ́b mɛɛ́ ńsɔ̂l, né mod ampée amaá asɔ́l.” ");
INSERT INTO bssNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ mɔ́ aá, “Syəə́ ásē, étêd échoŋ ebúm, ékag.” ");
INSERT INTO bssNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ábwɔ̄g-ábwɔ̄g ane mod andyɛ̌ bwâm, ányə̄g échē ebúm áte, ábootéd-tɛ akɛ. Epun éche nɛ́n dêmbɛnlédté ébédɛ́ɛ á mbwɛ-mé-nkɔ́me-áte. ");
INSERT INTO bssNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Né-ɔɔ́, anyín áde bad bémbáá bé Israɛl bényíné ane mod awě Yesuɛ ândidté bwâm, bênsɛdéd mɔ́ bánken, “Chii ádé mbwɛ-mé-nkɔ́me-áte, nzé dehídé-ʼɛ mbéndé echɛ̂d, weetə̂ŋgɛnɛɛ́ ebúm apém se ébwāgneʼ.” ");
INSERT INTO bssNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Boŋ ankwɛntɛ́n aá, “Mod awě adidé mɛ bwâm anláá mɛ aá, ‘Téd échoŋ ebúm, ékag?’ ” ");
INSERT INTO bssNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Hɛ́ɛ bésɛdtɛɛ́ mɔ́ bán, “Nzɛ́ adé ane mod awě áláŋgé wɛ aá, étêd échoŋ ebúm ékag?” ");
INSERT INTO bssNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Boŋ ane mod mwěn enkênkoŋgé Yesuɛ abíi, ngáne Yesuɛ âmmadté asɔ́l á amute-tê áde démbɛ̄ áhed. ");
INSERT INTO bssNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ámbīd enɛ̂ Yesuɛ annyín ane mod á Ndáb-e-Dyǒb. Áde ányíné mɔ́, anláá mɔ́ aá, “Nɔnéʼ, emaá bwâm adyɛɛ. Weébɛ̄lē mbéb ámpē ésebɛ́ nɛ̂, né wɛ̌tōm atag ngáne étágéʼáá nɛ̂.” ");
INSERT INTO bssNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Hɛ̂ dɔ́ɔ ane mod áhídté, boŋ ákɛ álāŋgē bad bémbáá bé Israɛl aá Yesuɛ mɔ́ɔ adidé mɔ́ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Né-ɔɔ́, bad bémbáá bé Israɛl bêmbootéd Yesuɛ mekuu ahíd áyə̄le achǒŋté mod á mbwɛ-mé-nkɔ́me-áte. ");
INSERT INTO bssNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesuɛ antimtɛ́n bɔ́ aá, “Echem Sáŋ ayɔ̌gké nsɔ́n abɛl, mɛ-ʼɛ ámpē ntə́ŋgɛ́né nsɔ́n abɛl.” ");
INSERT INTO bssNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Enɛ́n pɔ́le echě Yesuɛ ánhɔ̄bpē, embɛ̌l yə̌l ennabé bad bé Israɛl atod áte âwúu mɔ́, áyə̄le saké mbéndé e mbwɛ-mé-nkɔ́me-áte, chěmpɛn ábóó boŋ achəgé Dyǒb aá Sáá, nɛ́dē alûmteʼ aá bɔ́ Dyǒb bétə́ə́. ");
INSERT INTO bssNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Né-ɔɔ́, Yesuɛ antimtɛ́n ábê bad bémbáá bé Israɛl aá, “Á mbále, nlâŋge nyé nɛ́n mɛɛ́, Mwǎn a Dyǒb eébɛ̄lɛ̄ɛ̄ dyam ké ahɔ́g ne mɔ́ mwěn. Mekan ḿme ányínɛɛ́ Sáá abɛleʼ mɔ́ɔ mɔ́mpē ábɛlɛɛ́. Kéchéé éche Sáá ábɛlɛɛ́ chɔ́ɔ mɔ́mpē ábɛlɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ngáne édíí nɛ́n bán Sáá adəə́ Mwǎn, alûmte mɔ́ chǒm tɛ́ɛ́ éche ábɛlɛɛ́. Ǎlūmēd-tɛ mɔ́ ndəle é mekan éche étómé ḿmɛ́n, âbɛl ékɔ́med nyé yə̌l áte. ");
INSERT INTO bssNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ngáne Sáá ápuudtɛɛ́ bad boŋ ábagé-ʼɛ bɔ́ aloŋgé, melemlem nɛ̂ dɔ́ɔ Mwǎn mɔ́mpē ábagɛɛ́ aloŋgé wɛ́ɛ kénzɛ́ɛ́ awě ádə́ə́ aloŋgé abɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Melemlem-ʼaá Sáá éēkāādtɛ̄ɛ̄ modmod. Abagé Mwǎn ngíne esyəə́l âkáad bad. ");
INSERT INTO bssNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Abɛlé nɛ̂ âbɛl boŋ bébage Mwǎn edúbé melemlem ngáne bébagɛɛ́ Sáá. Kénzɛ́ɛ́ awě eébage Mwǎn edúbé, né eébagɛɛ́ ké Sáá awě alómé Mwǎn edúbé. ");
INSERT INTO bssNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, kénzɛ́ɛ́ awě awógé ábêm eʼyale boŋ adúbé mod awě alómé mɛ, akudé aloŋgé áde déemaáʼ, béekáád-taá mɔ́. Amaá atóm á kwééd, asɔ́lé á aloŋgé. ");
INSERT INTO bssNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ne mbále, nlâŋge nyé mɛɛ́, póndé ehúɛʼ, emaá-ʼɛ apɛ, echě bad ábe béwédé bɛ́wōgkē ehɔ́b e Mwǎn a Dyǒb, bad ábe bɛ́wōg-kɛ chɔ́ bɛ́bē á aloŋgé. ");
INSERT INTO bssNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ngáne aloŋgé áhúú ne Sáá, melemlem nɛ̂ dɔ́ɔ ábɛ́lé aá aloŋgé áhúu ne Mwǎn ámpē. ");
INSERT INTO bssNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Abagé-ʼɛ Mwǎn ngíne âkáad bad áyə̄le Mwǎn adíi ane awě béchəgɛɛ́ bán Mwǎn-a-Moonyoŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nɛ́n déēkɔ̄mtē nyé yə̌l áte; póndé ehúɛʼ echě bad bésyə̄ə̄l ábe béwédé bɛ́wɔ̄gkē échē ehɔ́b, ");
INSERT INTO bssNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","bébíd-tɛ á soŋ-tê: Bad ábe bébɛ́lé mboŋ, bɛ́puú âbɛ́ á aloŋgé, ábe bɔ́-ʼɛ bébɛ́lé mbéb bɛ́puú békud nkɔ́gsɛn. ");
INSERT INTO bssNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Dyamdyam déesaá áde ńhɛle ḿbɛ̄l ne mměn. Ngáne echem Sáŋ áláŋgé mɛ aá ńkáad nɛ̂ dɔ́ɔ ńkáadtɛɛ́, né-ɔɔ́ mbakú echêm etyéémé. Etyéémé áyə̄le meekáádtɛ́ɛ́ ngáne mměn ńdə́ə́, boŋ nkáadteʼ ngáne mod awě alómé mɛ áhɛdɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nzé mbídé echem yə̌l mbóŋ né ene mbóŋ echě ḿbídɛɛ́ eékobnedɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Boŋ mod ampée adé awě abíde mɛ mbóŋ, mbíí-ʼɛ nɛ́n mɛɛ́, mbóŋ echě ábídɛɛ́ mɛ ekǒbnédé. ");
INSERT INTO bssNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nyênlóm bad wɛ́ɛ Jɔnɛ, mɔ́-aá abídé mbóŋ tə̂ŋgɛne mbále. ");
INSERT INTO bssNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Éesaá nɛ́n bán, moonyoŋ atə́ŋgɛ́né mɛ mbóŋ abíd. Boŋ nláŋgé nyé tə̂ŋgɛne mbóŋ eche Jɔnɛ, âbɛl nyédúbe mɛ, nyékud eʼsoósoŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jɔnɛ abédɛ́ɛ nɛ́ɛ etrúkáŋ éche échodneʼ, épɛnté-ʼɛ ekíde. Nyêmbɛ́ menyiŋge âhíd ábɛ̂ eʼnyínɛn bé ekíde áyə̄le esóŋ é póndé. ");
INSERT INTO bssNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Boŋ nwóó mbóŋ echě etómé ké mbóŋ echě Jɔnɛ ámbīdtē. Nsɔ́n ḿme echem Sáŋ ábágé mɛ aá ḿbɛl ḿmad, mměn ḿbíde mbóŋ nɛ́n bán echem Sáŋ mɔ́ɔ alómé mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Echem Sáŋ awě alómé mɛ mwěn ámpē abíde mɛ mbóŋ. Nyéēwógɛ́ɛ́ mɔ́ ehɔ́b, nyéēnyíné-ʼaá mɔ́ mbêd. ");
INSERT INTO bssNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nyéedúbpɛɛ́ ane awě álómé, né-ɔɔ́ nyéēmwagké bán échē eyale édyɛɛ nyé á nlém-tê. ");
INSERT INTO bssNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nyêkídteʼ Eyale é Dyǒb ahɛd áte áyə̄le nyêwêmtan bán nyɛ́ɛ̄kǔd aloŋgé áde déemaáʼ áwēd-te. Échɛ́n Eyale chěn-ɛ́ɛ éhɔ́be áyə̄l echêm. ");
INSERT INTO bssNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ké nɛ̂, nyéēhɛ̄dɛ̄ɛ̄ apɛ áwêm âbɛl boŋ nyékud aloŋgé áde déemaáʼ. ");
INSERT INTO bssNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Saké edúbé é baányoŋ ńhɛdɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Boŋ mbíí nyaa é bad éche nyédíí, mbíí-ʼɛ mɛɛ́ nyéewôŋnɛɛ́ Dyǒb edəŋge á nlém-tê. ");
INSERT INTO bssNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mpedé á dǐn áde echem Sáŋ, nyéēkobɛɛ́ mɛ, boŋ nzé mod ampée apedé á dǐn ádē děn, nyɛ́ɛ̄kob mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nzé nyêkɛneʼ nhɔ́g ne aníníí, nyéwōgē bwâm, boŋ nyéēbɛ̄lɛ̄ɛ̄ ngáne Dyǒb děn dɛ́kɛnné nyé. Chán-nɔ̄ nyɛ́dūbɛ̄ɛ̄ mɛ? ");
INSERT INTO bssNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ké nɛ́ɛ nyéekobɛɛ́ mɛ, nyéewémtán bán, mɛ-ɛɛ́ mɛ̌lāā echem Sáŋ mɛɛ́ nyéēkobɛɛ́ mɛ. Mosɛɛ awě nyélyə́gé nlém áwē mwěn-nɛɛ́ akǒŋté ane abɛ́ awě ǎhɔ̄b aá, nyêbɛlé mbéb. ");
INSERT INTO bssNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nzé nyênkǒŋ Mosɛɛ adúbe né nyêdúbpé mɛ, áyə̄le nɛ́n, áyə̄l echêm dɔ́ɔ ântenlé mam ḿme átélé. ");
INSERT INTO bssNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Boŋ nɛ́ɛ nyéedúbpɛɛ́ mekan ḿme átélé, chán nyɛ́dūbɛ̄ɛ̄ ábêm eʼyale?” ");
INSERT INTO bssNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ámbīd e ḿmɛ́n mésyə̄ə̄l, Yesuɛ ne ábē bembapɛɛ bênchabé edib é Galilia éche béchəgɛɛ́ bán edib é Tiberia. ");
INSERT INTO bssNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ndun e mod ehídéʼáá mɔ́ áyə̄le bényínéʼáá menyáké ḿme ábɛ́léʼáá ngáne áchóóŋtéʼáá bad bé nkole. ");
INSERT INTO bssNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Hɛ́ɛ Yesuɛ ne ábē bembapɛɛ békíí á ekone-mîn boŋ bédyɛ̄ɛ̄ ásē. ");
INSERT INTO bssNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Póndé e Ngande e Nnyíme-ámīn e bad bé Israɛl embɛ́ bɛnbɛn. ");
INSERT INTO bssNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Asad áde Yesuɛ ásádé dǐd annyín ngáne ndun e mod éhúɛʼɛ́ mɔ́ bɛnbɛn. Dɔ́ɔ ásɛdtɛɛ́ Filibɛ aáken, “Hɛ́ɛ dɛ́channé ndyééd echě dɛ́bɛɛ́ ábɛ́n bad âdyɛ́?” ");
INSERT INTO bssNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ansɛdéd mɔ́ nɛ̂ âkəg mɔ́ áyə̄le mwěn ammad abíi chǒm éche ábɛnlé. ");
INSERT INTO bssNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filibɛ ankwɛntɛ́n aá, “Étēd tómaa ne mbwɔ́kɛl é kábpe ébɛ âchan ndyééd éche ěkwognéd ábɛ́n bad bésyə̄ə̄l adyɛ́ âbɛl boŋ mod tɛ́ɛ́ ádyɛ̂ mwǎtiíd.” ");
INSERT INTO bssNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Dɔ́ɔ Yesuɛ awě mbapɛɛ ampée, Andreya, Simɔn Petro mwǎnyaŋ áhɔ́bɛɛ́ aá, ");
INSERT INTO bssNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Mwǎ kódemod adé hɛ́n awě awánlé eʼwɛle éʼtáan ábe bébɛ́nlé ngun é báli, awánlé-ʼɛ súu ébɛ, boŋ chán enɛ́n ndyééd éhɛlɛɛ́-sɛ ékwɔ̄g enɛ́n ndun e mod?” ");
INSERT INTO bssNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ ábe bembapɛɛ aá, “Nyéláa ábê bad, bédyɛɛ ásē.” Nkəə́kəə ambud abɛ́ á pɛd e ádê abwɔ́g a hǒm. Né-ɔɔ́, ábê bad bésyə̄ə̄l bêndyɛɛ́ ásē. Á amute-tê wê, baachóm bébédé dyam eʼkə́lé éʼtáan. ");
INSERT INTO bssNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Hɛ́ɛ Yesuɛ átédé ábê eʼwɛle, ásāgnān Dyǒb, boŋ ábē bembapɛɛ békabpé bad. Ambɛ̌l melemlem ne échê súu. Mod-tɛ́ɛ́ andyɛ́ ngáne áhɛ́déʼáá. ");
INSERT INTO bssNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Áde bɔ́ moosyəə́l bémáá akód, Yesuɛ anláá ábē bembapɛɛ aá, “Nyélad ndyééd echě elyəgé ásē. Ndyééd ké pɔ́g eebébéʼ.” ");
INSERT INTO bssNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Né-ɔɔ́, áde bémáá adyɛ́ bênlǎd ndyééd echě enlyə̌g ásē, enlón eʼlóŋ dyôm ne éʼbɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Anyín áde ábē bad bényíné ḿmɛ́n menyáké ḿme Yesuɛ ábɛ́lé bénhɔ̄b bán “Ne mbále, nkal eʼdəə́dəŋ awě bénhɔ̄bpē bán ǎpɛ̄ á nkǒŋsé mɔ́ nɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesuɛ ambíí aá béhɛde mɔ́ akób ânyáged mɔ́ âbɛ́ kə̂ŋ. Né-ɔɔ́, antǐm ámbīd á ekone-mîn. ");
INSERT INTO bssNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ngukɛ́l, bembapɛɛ ábe Yesuɛ bênkɛ̌ á edib. ");
INSERT INTO bssNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bênsɔ́l á bɔ̌lɛ-tê, béchabpé edib, bétimnád á Kapenahum. Ehíntɛ́n êmmǎd apɛ áde Yesuɛ éēpédɛ́ɛ́ wɛ́ɛ bédíí. ");
INSERT INTO bssNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Enɛ́n póndé epub é ngíne étóméʼáá, épuutád-tɛ mendíb áte. ");
INSERT INTO bssNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bɔɔb-pɔɔ́ bembapɛɛ bêmmǎd akɛ ké máyl méláán kéʼɛ méniin, dɔ́ɔ bényíné Yesuɛ akag á mendíb mîn, átimnád bɛnbɛn ne ábab bɔ̌lɛ. Mbwɔ́g ń ngíne ménkōb bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Boŋ anláá bɔ́ aá, “Mɛ-ɛɛ́ ndé, nyéebááʼ.” ");
INSERT INTO bssNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Hɛ́ɛ bétédé mɔ́ á bɔ̌lɛ-tê ne menyiŋge, ábwɔ̄g-ábwɔ̄g bépɛ̄ɛ̄n-nɛ bɔ̌lɛ á nkin wɛ́ɛ békágéʼáá. ");
INSERT INTO bssNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nɛ́ɛ bǐn éʼsáŋgé, ndun e mod echě enlyə̌g á múde mé edib ḿmíníí wɛ́ɛ Yesuɛ ne ábē bembapɛɛ bémbīdtē, bênchem bán, ngukɛ́l echě entóm, bɔ̌lɛ eʼhɔ́g běnpɛn bɔ́ɔ bémbɛ̄ áhed. Bémbīī-ʼɛ bán Yesuɛ enkênsɔ́nlé áwēd-te ne ábē bembapɛɛ. Bémbīī bán ábē bembapɛɛ běnpɛn bɔ́ɔ bênkɛ̌. ");
INSERT INTO bssNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Myɔ̌lɛ mémpēe ḿme mémbīd á dyad á Tiberia mêmpɛ̌ á nkin mé edib bɛnbɛn ne hǒm áde ene ndun e mod éndyɛ̄ɛ̄ eʼwɛle ámbīd echě Sáŋgwɛ́ɛ́ ámáá Dyǒb aságnɛn. ");
INSERT INTO bssNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Áde ene ndun e mod ényíné nɛ́n bán, Yesuɛ ne ábē bembapɛɛ béesaá áhed, bénsɔ̄l á myɔ̌lɛ-tê wɛ̂, békɛ̄ á Kapenahum, âkɛ dé ahɛd Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Áde ábê bad bépédé á pɛd e edib eníníí, bényīn Yesuɛ. Bênsɛdéd mɔ́ bán, “A-meléed, póndé ehéé épédé hɛ́n?” ");
INSERT INTO bssNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesuɛ ankwɛntɛ́n bɔ́ aá, “Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, saké menyáké ḿmě ḿbɛ́lé ńkə́ə́ boŋ nyéhɛdé mɛ. Nyêhɛde mɛ áyə̄le eʼwɛle ábe nyédyédé boŋ nyêkód-tɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nyéewág ntǔ áyə̄le ndyééd echě ebɔɔdeʼ, boŋ nyéwâg ntǔ áyə̄le ndyééd echě ebâg abɛ́ ne abɛ́ á aloŋgé áde déemaáʼ, chɔ́-ʼaá ebage aloŋgé áde déemaáʼ. Ene ndyééd chɔ́ɔ Mwǎn-a-Moonyoŋ ábɛɛ́. Mɔ́ɔ Dyǒb Titɛ́ɛ áhédé eʼchem aá ábɛl nɛ̂.” ");
INSERT INTO bssNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Dɔ́ɔ ábê bad bênsɛdéd Yesuɛ bánken, “Cheé sétə́ŋgɛ́né abɛl, âbɛl boŋ sébɛl mekan ḿme Dyǒb áhɛdɛɛ́ aá, sébɛl?” ");
INSERT INTO bssNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesuɛ ankwɛntɛ́n aá, “Dyam áde Dyǒb áhɛdɛɛ́ aá nyébɛl ádíi âdúbe mɛ awě álómé.” ");
INSERT INTO bssNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bêntimtɛ́n Yesuɛ bán, “Menyáké méhéé wɛ́bɛnlé ḿme sɛ́nyīnnē boŋ sêdúbé wɛ. Cheé mmǒn wɛ́koŋgé abɛl? ");
INSERT INTO bssNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ábɛ̄d betaa béndyɛ̄ mána á ehyáŋge ngáne éténlédé á kálag e Dyǒb nɛ́n bán, ‘Ambag bɔ́ eʼwɛle ábe éʼbídé ádyōb aá bédyɛ̂.’ ” ");
INSERT INTO bssNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesuɛ anhɔ́b aá, “Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, saké Mosɛɛ mɔ́ɔmbɛ̌ nyé ewɛle éche ehúú ádyōb, boŋ echem Sáŋ mɔ́ɔmbɛ̌ nyé ewɛle éche ehúú ádyōb. ");
INSERT INTO bssNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Áyə̄le mɛ-ɛɛ́ ndé échê ewɛle éche Dyǒb ábágé, échě éhúú ádyōb, echě ábagɛɛ́ baányoŋ bé nkǒŋsé aloŋgé áde déemaáʼ.” ");
INSERT INTO bssNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Dɔ́ɔ bélâŋgɛɛ́ Yesuɛ bán, “A-Sáŋ, bagé sé échɛ́n ewɛle póndé ésyə̄ə̄l.” ");
INSERT INTO bssNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesuɛ anláá bɔ́ aá, “Mɛ-ɛɛ́ ndé ewɛle éche ébage aloŋgé áde déemaáʼ. Kénzɛ́ɛ́ awě apedé áwêm, nzaa éekóbpé mɔ́ ámpē. Kénzɛ́ɛ́ awě adúbpé mɛ, píd éekóbpé mɔ́ ámpē. ");
INSERT INTO bssNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nláŋgé nyé nɛ́n mɛɛ́ nyênyíné mɛ boŋ nyéedúbpɛɛ́ mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bad bésyə̄ə̄l ábe echem Sáŋ ábágé mɛ, bɛ́pɛ̌ áwêm. Kénzɛ́ɛ́ awě apedé áwêm, méebáŋgé mɔ́ akob. ");
INSERT INTO bssNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Áyə̄le meebídɛɛ́ ádyōb âbɛl ngáne ébóŋnédé mɛ. Mpedé âbɛl ngáne ébóŋnédé echem Sáŋ awě alómé mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Boŋ nɛ́n ádíi mewêmtɛn ḿme ane awě alómé mɛ, aá átîntê bad bésyə̄ə̄l ábe ábágé mɛ, meebɔ́dé ké nhɔ́g, boŋ aá ḿpuud bɔ́ moosyəə́l á epun é asóg. ");
INSERT INTO bssNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Echem Sáŋ ahɛde aá moosyəə́l awě anyíné mwǎn, adúbé-ʼɛ mɔ́, ákud aloŋgé áde déemaáʼ. Mɛ̌puúd-tɛ bɔ́ á epun é asóg.” ");
INSERT INTO bssNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ábê bad bé Israɛl bêmbootéd anyoo áte tə̂ŋgɛne Yesuɛ, ahɔ́b áde áhɔ́bé aá, “Mɛɛ́ ndé ewɛle éche ébídé ádyōb.” ");
INSERT INTO bssNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Hɛ̂ dɔ́ɔ béhɔ́bɛɛ́ bánken, “Saá Yesuɛ, mwǎn awě Josɛbɛ nɛ́n-ɛ? Ngɔ́mē debíí sáá ne nyaŋ? Chán-nɔ̄ áhɛlɛsɛ áhɔ̄bē aá mɔ́bīdē ádyōb?” ");
INSERT INTO bssNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesuɛ anláá bɔ́ aá, “Nyésôg anyoo áte. ");
INSERT INTO bssNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Modmod éēhɛ̄lɛ̄ɛ̄-sɛ ápɛ áwêm, ésebán Titɛ́ɛ awě alómé mɛ apɛɛ́né mɔ́ áwêm. Mɛ̌puúd-tɛ mɔ́ á epun é asóg. ");
INSERT INTO bssNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Éténlédé ngáne bekal béʼdəə́dəŋ béhɔ́bé nɛ́n bán ‘Dyǒb dɛ́yə̄gēd bɔ́ moosyəə́l.’ Kénzɛ́ɛ́ awě awógeʼ, áyə̄gkē-ʼɛ wɛ́ɛ Titɛ́ɛ, apag áwêm. ");
INSERT INTO bssNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Éesaá nɛ́n bán, mod ké nhɔ́g akɛ́nyīn Titɛ́ɛ. Ane awě abídé wɛ́ɛ Dyǒb mwěmpɛn mɔ́ɔ akɛ́nyīn Titɛ́ɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, kénzɛ́ɛ́ awě adúbpé mɛ ǎkǔd aloŋgé áde déemaáʼ. ");
INSERT INTO bssNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mɛ-ɛɛ́ ndé ewɛle éche ébage aloŋgé. ");
INSERT INTO bssNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ábɛ̄n betaa béndyɛ̄ mána á ehyáŋge, boŋ ké nɛ̂, bénwɛ̄. ");
INSERT INTO bssNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Boŋ ewɛle éche ébídé ádyōb édé nyaa echě kénzɛ́ɛ́ awě adyédé chɔ́ éewáá. ");
INSERT INTO bssNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mɛ-ɛɛ́ ndé ewɛle éche ébage aloŋgé éche ébídé ádyōb. Kénzɛ́ɛ́ awě adyédé échê ewɛle, ǎbɛ̄ á aloŋgé á ngíndé ne á ngíndé. Échɛ́n ewɛle éche mɛ́bɛɛ́ nyé édíi echem yə̌l echě mɛ́bɛ̌ âbɛl boŋ ńkɔde aloŋgé dé nkǒŋsé.” ");
INSERT INTO bssNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Áde ábê bad béwógé nɛ̂, bênlǐŋ, běn ne běn bébootéd-tɛ mpentɛn ń ngíne, bésɛdté bánken, “Chán anɛ́n mod áhɛle atéd eche yə̌l, ábɛ syánē aá dédyâg?” ");
INSERT INTO bssNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesuɛ anláá bɔ́ aá, “Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, nzé nyéedyéde yə̌l e Mwǎn-a-Moonyoŋ nyêmwɛ́-ʼɛ ḿmē mekií, nyéekudté aloŋgé áde déemaáʼ. ");
INSERT INTO bssNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kénzɛ́ɛ́ awě adyédé echem yə̌l, amwɛ́-ʼɛ ḿmêm mekií, ǎkǔd aloŋgé áde déemaáʼ, mɛ̌puúd-tɛ mɔ́ á epun é asóg. ");
INSERT INTO bssNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Áyə̄le echem yə̌l chɔ̂ ekǒŋté ndyééd abɛ́, ḿmêm mekií-ʼɛ mékoŋ mmíítéd abɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kénzɛ́ɛ́ awě adyédé echem yə̌l, amwɛ́-ʼɛ ḿmêm mekií, alyəgé adé ne mɛ, mɛ-ʼɛ nlyəgé ndé ne mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Titɛ́ɛ awě akəə boŋ bad bébɛ́ á aloŋgé, mɔ́ alómé mɛ, mɔ́ akəə́-ʼɛ boŋ mbɛ́ á aloŋgé. Melemlem nɛ́ɛ kénzɛ́ɛ́ awě adyédé echem yə̌l, mɛ́bɛnlé abɛ́ á aloŋgé. ");
INSERT INTO bssNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Né-ɔɔ́, mɛ-ɛɛ́ ndé ewɛle eche ébídé ádyōb. Meésaá nɛ̂ŋgáne ewɛle éche ábɛ̄n betaa béndyɛ̄ɛ̄, boŋ ké nɛ̂ béwɛ́. Boŋ kénzɛ́ɛ́ awě ǎdyɛ̄ echem yə̌l ǎbɛ̄ á aloŋgé á ngíndé ne ngíndé.” ");
INSERT INTO bssNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesuɛ anhɔ́b ḿmɛ́n mésyə̄ə̄l áde áyə́gtéʼáá á ndáb e mekáne e bad bé Israɛl á Kapenahum. ");
INSERT INTO bssNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Áde bad híin ábe béhídéʼáá Yesuɛ béwógé ḿmɛ́n mekan bénhɔ̄b bán, “Ádɛ́n ayə́ge álɛ́lé ahíd. Nzɛ́ɛ́ ahɛle ákob ene ndín e dyam?” ");
INSERT INTO bssNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesuɛ ambíí aá, bényoŋge áte áyə̄l echê, né-ɔɔ́ anláá bɔ́ aá, “Nɛ̂ áwag nyé á yə̌l-ɛ? ");
INSERT INTO bssNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Chán-nɔ̄ nyɛ́hɔ̄bpē áde nyɛ́nyīnnē Mwǎn-a-Moonyoŋ apummeʼ ámbīd ámīn wɛ́ɛ ámbīdtē! ");
INSERT INTO bssNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Edəə́dəŋ é Dyǒb chɔ́ɔ ébageʼ aloŋgé. Ekob é yə̌l éesaá dyamdyam. Eʼyale ábe ńláŋgé nyé éʼdíi edəə́dəŋ ne aloŋgé. ");
INSERT INTO bssNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Boŋ ké nɛ̂, nyé doŋge á bad nyéedúbpɛɛ́.” (Bootya á póndé éche Yesuɛ ábóótédé ayə́ged, ambíí bad ábe béedúbé, abíí-ʼɛ mod awě ǎsōm mɔ́.) ");
INSERT INTO bssNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ambád ahɔ́b aá, “Nɛ́n dɔ́ɔ ákə́ə́ boŋ nláá nyé mɛɛ́ modmod eéhɛ̄lɛ̄ɛ̄-sɛ ápɛ awêm kə́ə́ŋ né echem Sáŋ abɛlé boŋ ápɛ̄ áwêm.” ");
INSERT INTO bssNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Bootya enɛ póndé nɛ̂ dênkə̌ŋ bad ábe béhídéʼáá Yesuɛ bésóg mɔ́ ahíd, bétīm-mɛ ámbīd. ");
INSERT INTO bssNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Hɛ́ɛ Yesuɛ ásɛdtɛɛ́ ábē bembapɛɛ dyôm ne bébɛ aá, “Nyémpē nyêhɛde atim ámbīd-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simɔn Petro ankwɛntɛ́n mɔ́ aá, “A-Sáŋ, wɛ́ɛ nzɛ́ɛ́ sɛ́kɛɛ́? Wɛ-ɛɛ́ ewóó eʼyale ábe éʼkəəʼ boŋ mod ákūd aloŋgé áde déemaáʼ. ");
INSERT INTO bssNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Sêdúbpé sêbíí-ʼɛ bán, wɛ-ɛɛ́ edé Ane-awě-Asáá awě abídé wɛ́ɛ Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Hɛ́ɛ Yesuɛ ákwɛntanné bɔ́ aá, “Éesaá mbále bán mpwɛdé nyé bad dyôm ne bébɛ-yɛ? Boŋ ké nɛ̂, nyé mod nhɔ́g adíi mod a Satan.” ");
INSERT INTO bssNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judasɛ, mwǎn a Simɔn Iskariɔdɛ mɔ́ɔ Yesuɛ áhɔ́béʼáá. Kénɛ́ɛ ámbɛ̄ɛ̄ mbapɛɛ nhɔ́g átîntê e bembapɛɛ dyôm ne bébɛ, mɔ́ ankɛ̌ Yesuɛ ntúrɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ámbīd e ḿmɛ́n mésyə̄ə̄l, Yesuɛ akagéʼáá mebwɔ́g ne mebwɔ́g á mbwɔ́g e Galilia. Enkêndəŋgé akɛ á mbwɔ́g e Judeya áyə̄le bad bé Israɛl béhɛ́déʼáá mɔ́ awúu. ");
INSERT INTO bssNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Bɔɔb-pɔɔ́, Ngande e Eʼbem e bad bé Israɛl embɛ́ bɛnbɛn. ");
INSERT INTO bssNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Hɛ́ɛ Yesuɛ baányaŋ bélâŋgɛɛ́ mɔ́ bán, “Etə́ŋgɛ́né ádɛ́n abwɔ́g á hǒm ahide, ékɛ á mbwɔ́g e Judeya âbɛl bad ábe béhíde wɛ bényîn menyáké ḿme ébɛlɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mod eébɛ̄lɛ̄ɛ̄ nsɔ́n á eʼkoŋnéd-te, nzé ahɛde aá mɔ́byɛ́ɛn. Ngáne ébɛlɛɛ́ ḿmɛ́n mekan mésyə̄ə̄l ébɛl nkǒŋsé ńsyə̄ə̄l ḿbíi wɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Ké Yesuɛ baányaŋ bénkêndúbɛ́ɛ́ mɔ́.) ");
INSERT INTO bssNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Echem póndé eépédɛ́ɛ́. Boŋ ne nyé, echɛn póndé edé póndé ésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nkǒŋsé méehɛlɛ́ɛ́-sɛ ńkɔ̄ɔ̄ nyé. Boŋ ńkɔ́ɔ́ mɛ áyə̄le mpanlad bɔ́ ḿmāb mewusé áte. ");
INSERT INTO bssNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nyébɔ́ nyékag á ngande. Méekaá áwed áyə̄le echem póndé eépédɛ́ɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesuɛ amaá-ʼaá ahɔ́b nɛ̂, abɛ́ abɛ́ á Galilia. ");
INSERT INTO bssNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ámbīd e póndé áde Yesuɛ baányaŋ bémáá akɛ á Ngande e Eʼbem, mɔ́mpē ankɛ̌ áwed. Boŋ enkênlúmédté yə̌l. Ankɛ̌ nyaa echě bad bénkêmbííʼɛ́ ndín e mod echě ádíí. ");
INSERT INTO bssNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Benkamlɛnɛ bé Israɛl béhɛ́déʼáá mɔ́ á ngande-tê, bésɛdté bánken, “Héé múmɔ́ ádíí?” ");
INSERT INTO bssNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Átîntê e ndun e mod echě embɛ́ á ngande-tê wɛ̂, doŋge á bad béhɔ́béʼáá bán, “Adíi mod a bwâm,” ábíníí-ʼɛ bán, “Aáy, adoge bad dogɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Boŋ bɔ́ modmod bénkêmbídédté yə̌l áwed áyə̄le bébááʼáá bad bémbáá bé Israɛl. ");
INSERT INTO bssNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Áde ngande ékwógé apɛ átîntê, Yesuɛ ankɛ̌ asɔ́l á Ndáb-e-Dyǒb, ábootéd ayə́ged. ");
INSERT INTO bssNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yə̌l enkɔ́m benkamlɛnɛ áte bwâmbwam tə̂ŋgɛne ádē ayə́ge. Né-ɔɔ́, bênsɛdéd bánken, “Chán anɛ́n mod ámwédé ḿmɛ́n mam mésyə̄ə̄l abíi áde éekiiʼɛ́ á esukɛ́lɛ é mbéndé?” ");
INSERT INTO bssNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Hɛ́ɛ Yesuɛ ákwɛntanné bɔ́ aá, “Ayə́ged áde ń'yə́gtɛɛ́ déesaá ádêm. Ádíi áde mod awě alómé mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kénzɛ́ɛ́ awě awémtɛ́né abɛl ngáne Dyǒb áhɛdɛɛ́, ǎbīī ké ádêm ayə́ge ahúú ne Dyǒb kéʼɛ áhúú ne mměn. ");
INSERT INTO bssNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kénzɛ́ɛ́ awě ahɔ́bne echě kunze, abɛle nɛ̂ âhɛde eche yə̌l edúbé. Boŋ mod awě ahɛdteʼ mod awě alómé mɔ́ edúbé, asáá nlém á abum, eésaá mod a metóm. ");
INSERT INTO bssNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Éesaá mbále nɛ́n bán, Mosɛɛ abagé nyé mbéndé-yɛ? Ké nɛ̂, nyé modmod eehídɛ́ɛ́ mbéndé éched. Cheé ékə́ə́ boŋ nyéhɛdé mɛ awúu?” ");
INSERT INTO bssNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Dɔ́ɔ ene ndun e mod ékwɛntanné mɔ́ bán, “Edəə́dəŋ é mbéb édé wɛ áte. Benzébádé béhɛde wɛ awúu?” ");
INSERT INTO bssNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesuɛ ankwɛntɛ́n bɔ́ aá, “Nsɔ́n nhɔ́g ḿme ḿbɛ́lé, ńkɔ́mté nyé moosyəə́l yə̌l áte. ");
INSERT INTO bssNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosɛɛ ambɛ̌ nyé mbéndé aá, nyéyage ábɛn bǎn (kénɛ́ɛ édíí bán, saké Mosɛɛ mɔ́ɔmbootéd. Ábɛ̄n betaa bɔ́ɔ bêmbootéd). Né-ɔɔ́, nyêyage bad á Mbwɛ-mé-nkɔ́me-áte. ");
INSERT INTO bssNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nzé béyágé mod á mbwɛ-mé-nkɔ́me-áte, âbɛl béēbōōʼ mbéndé e Mosɛɛ, cheé ékə́ə́ boŋ nyéliŋné mɛ áyə̄le ńdídé mod bwâm á mbwɛ-mé-nkɔ́me-áte. ");
INSERT INTO bssNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nyéekáádté dyam áde ḿbɛ́lé ngáne nyényíné, nyékáad ngáne éhɛdnadté.” ");
INSERT INTO bssNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Hɛ́ɛ dɔ́ɔ doŋge á bad bé Jerusalɛm béhɔ́bɛɛ́ bánken, “Saá mod awě béhɛdɛɛ́ awúu mɔ̂ nɛ́n-ɛ? ");
INSERT INTO bssNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nyénɔnéʼ, akanle bad á tə̂l e ékwɛ́ɛ, bad bémbáá béesaá-ʼaá mɔ́ dyamdyam aláa. Kapɔ́g bébíí bán ne mbále, mɔ̂dé Ane-awě-Béwɔ́gté-yōō! ");
INSERT INTO bssNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Boŋ éehɛlɛ́ɛ́-sɛ ébɛ́ nɛ̂, áyə̄le debíí bán póndé echě Ane-awě-Béwɔ́gté ápɛɛ́, modmod éebííʼɛ́ wɛ́ɛ ábídé. Debíí wɛ́ɛ anɛ́n mod ábídé.” ");
INSERT INTO bssNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesuɛ ambɛ́ áyə̄gtēʼ á Ndáb-e-Dyǒb. Áde áyə́gtɛɛ́ dɔ́ɔ áchə́gté ehɔ́b ámīn aá, “Ɛɛ, nyêbíí mɛ bwâm, nyêbíí-ʼɛ wɛ́ɛ ḿbídé. Meépedɛɛ́ hɛ́n ne mměn. Ane awě alómé mɛ adé mbále. Nyéebíiʼɛ́ mɔ́, ");
INSERT INTO bssNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","boŋ mɛ pɛn mbíí mɔ́ áyə̄le áwē dɔ́ɔ mbídé, mɔ́-ʼaá alómé me.” ");
INSERT INTO bssNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Áde áhɔ́bé nɛ̂, béhɛ́déʼáá mɔ́ akób, boŋ modmod enkêmbánné mɔ́ ké ekáá á yə̌l, áyə̄le eche póndé enkêmpaá. ");
INSERT INTO bssNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ké nɛ̂ bad híin átîntê ene ndun e mod béndūbē mɔ́. Béhɔ́béʼáá bánken, “Áde Ane-awě-Béwɔ́gté ápɛɛ́, ǎbɛ̌l eʼchemléd bé menyáké, ḿme ńtómé ḿme anɛ́n mod ábɛ́lé-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Befarisia bénwōg nɛ́ɛ bad bényoŋgɛɛ́ áte, béhɔ́bɛɛ́ ḿmɛ́n mekan tə̂ŋgɛne Yesuɛ. Né-ɔɔ́ bɔ́ɔbɛ beprisɛ bémbáá bénlōm bembəledɛ âkób mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Hɛ́ɛ Yesuɛ áhɔ́bɛɛ́ aá, “Ndíi ndé ne nyé, boŋ mwǎmpīn ḿ póndé mɛ̌sū ámbīd wɛ́ɛ ane awě alómé mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ámbīd enɛ̂, nyɛ́ɛ̄hɛ̌d mɛ, boŋ nyéenyínné, wɛ́ɛ mɛ́bɛ̄ɛ̄-ʼɛ nyéehɛnlé apɛ áhed.” ");
INSERT INTO bssNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nɛ̂ dêmbɛ̌l benkamlɛnɛ bésɛdté nhɔ́g ne aníníí bánken, “Héé anɛ́n mod múmɔ́ áhɛdɛɛ́ akɛ, wɛ́ɛ syánē déehɛnlé mɔ́ anyín? Ahɛde akɛ á aloŋ á Grikia wɛ́ɛ ábɛ̄d bad bédíí á ebwɔ́g âyə́ged bad bé Grikia-yɛ? ");
INSERT INTO bssNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ahɔ́beʼ aá dɛɛ́hɛ̌d mɔ́ boŋ déenyínné mɔ́. Aá déehɛnlé-ʼɛ apɛ wɛ́ɛ mɔ́bɛ̄ɛ̄. Cheé nɛ̂ álûmtɛɛ́?” ");
INSERT INTO bssNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Epun é asóg é ngande éche éntōmtɛ̄n etógnɛ́n abɛ́ áyə̄le ene ngande émpɛ̌. Yesuɛ antyéém ámīn, dɔ́ɔ áchə́gté ehɔ́b ámīn, áhɔ̄bē aá, “kénzɛ́ɛ́ awě píd ékóbé áhyag áwêm áhyɛ ámwɛ̂ mendíb. ");
INSERT INTO bssNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kénzɛ́ɛ́ awě adúbpé mɛ, Kálag e Dyǒb ehɔ́be aá, ‘eʼdíb bé mendíb mé aloŋgé bɛ́bīdē mɔ́ áte éʼsobpe.’ ” ");
INSERT INTO bssNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Edəə́dəŋ éche Ésáá chɔ́ɔ Yesuɛ áhɔ́béʼáá. Chɔ́ɔ bad ábe béndūbē mɔ́ béntə̄ŋgɛ̄nnē akud. Ene póndé né Edəə́dəŋ éche Ésáá éēpēdɛ̄ɛ̄ wɛ́ɛ ábê bad áyə̄le ene póndé ne Dyǒb déēlūmtɛ̄ɛ̄ ehúmé éche Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Doŋge á bad átîntê ene ndun e mod ábe bénwōg nɛ́ɛ Yesuɛ áhɔ́bɛɛ́ ḿmɛ́n mekan bénhɔ̄b bán, “Ne mbále, anɛ́n mod adíi nkal éʼdəə́dəŋ awě ǎpɛ̌.” ");
INSERT INTO bssNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bad bémpēe béhɔ́béʼáá bán, “Mɔ̂dé Ane-awě-Béwɔ́gté awě ǎpɛ̌.” Ké nɛ̂, bémpēe béhɔ́béʼáá bán, “Ane-awě-Béwɔ́gté eéhɛ̄lɛ̄ɛ̄-sɛ abíd á Galilia. ");
INSERT INTO bssNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Éténlédé á Kálag e Dyǒb nɛ́n bán, Ane-awě-Béwɔ́gté ǎbīd á túmbé e Dabid á dyad á Bɛtɛlhɛm wɛ́ɛ Dabidɛ ámbīdtē.” ");
INSERT INTO bssNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Né-ɔɔ́, bad bênkabɛ́n áte á atɔ́n áde Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Doŋge á bad béhɛ́déʼáá mɔ́ akób boŋ modmod enkêmbánné mɔ́ ké ekáá á yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kə́ə́ŋne ásɔ̄g bembəledɛ bé Ndáb-e-Dyǒb bêntǐm wɛ́ɛ beprisɛ bémbáá ne Befarisia. Hɛ́ɛ beprisɛ bémbáá ne Befarisia bésɛdtɛɛ́ bɔ́ bánken, “Cheé ékə́ə́ boŋ nyéepɛɛne mɔ́ hɛ́n?” ");
INSERT INTO bssNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Hɛ́ɛ ábê bembəledɛ béhɔ́bɛɛ́ bán, “Modmod eéhɔ́bɛ́ɛ́ ndín é mam éche anɛ́n mod áhɔ́bɛɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Dɔ́ɔ Befarisia bésɛdtɛɛ́ bɔ́ bánken, “Nɛ́dē ane mod adogé kə́ə́ŋne nyémpē-yɛ? ");
INSERT INTO bssNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nyêkényīn nɛ́ɛ mod ambáá kéʼɛ Farisia nhɔ́g ádúbpé mɔ̂? Ké nhɔ́g eédúbpɛ́ɛ́ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Enɛ́n ndun e mod eebíiʼɛ́ mbéndé e Mosɛ. Né-ɔɔ́ ebómán édé ne bɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Farisia nhɔ́g awě béchə́géʼáá bán Nikodemusɛ awě ansébé Yesuɛ akɛ dé anyín, anláá bɔ́ aá, ");
INSERT INTO bssNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Eche syánē mbéndé eébagɛɛ́ kunze nɛ́n dékɔ́gsɛn mod áde déekáadtɛɛ́ mɔ́, âwóglɛn dyam áde ábɛ́lé.” ");
INSERT INTO bssNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Áde áhɔ́bé nɛ̂, bêntimtɛ́n mɔ́ bánken, “We ámpē ebídé á Galilia-yɛ? Hɛ̌d áte á Kálag e Dyǒb, wɛ̌nyīn nɛ́n wɛ̌ nkal éʼdəə́dəŋ eebídɛ́ɛ́ á Galilia.” ");
INSERT INTO bssNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ámbīd enɛ̂ moosyəə́l ansú áwe ndáb. ");
INSERT INTO bssNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesuɛ pɛn ankɛ̌ á Ekone é Menzab. ");
INSERT INTO bssNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nɛ́ɛ bǐn éʼsáŋgé mbwɛmbwɛ, antǐm ámbīd á Ndáb-e-Dyǒb. Ndun e mod empɛ̌ áwē. Andyɛɛ́ ásē ábootéd bɔ́ ayə́ged. ");
INSERT INTO bssNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Bemeléede bé mbéndé ne Befarisia bêmpɛɛ́n mmwaád nhɔ́g áwē, awě békóbé nɛ́ɛ ákábɛɛ́ asón á ndáb e eʼwóŋgé. Béntīī ane mmwaád átîntê echâb, ");
INSERT INTO bssNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","boŋ bélāŋgē Yesuɛ bán, “A-meléed, békóbé anɛ́n mmwaád nɛ́ɛ ákábɛɛ́ asón á ndáb e eʼwóŋgé. ");
INSERT INTO bssNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Á mbéndé eche syánē, Mosɛɛ anhɔ́b aá, enɛ́n ndín e mmwaád bélûm chɔ́ meláá kə́ə́ŋ áwɛ̂, chán-nɔ̄ wɛ-ʼɛ éhɔ́bé?” ");
INSERT INTO bssNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bênsɛdéd mɔ́ nɛ̂ âhíi mɔ́ melám, âbɛl nɛ́n békóbɛn mɔ́ awusé. Boŋ Yesuɛ anwúlɛ́n ásē, ábootéd bwěm atel á ndɔɔb-tê ne ábē eʼmii. ");
INSERT INTO bssNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Áde bébádnɛ́né mɔ́ asɛded, antíí yə̌l ámīn, aláá bɔ́ aá, “Nyé ké ahéé awě eébɛ́lé mbéb ábɛ̂ mod aʼsó âlúm mɔ́ meláá.” ");
INSERT INTO bssNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Anwúlɛ́n mɔ́ ásē ámpē áteléʼ ábē bwɛ̌m á ndɔɔb-tê. ");
INSERT INTO bssNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Áde ábɛ̂ bad béwógé nɛ̂ bêmbootéd ahide nhɔ́gē-nhɔ́gē. Bad bémbáá bɔ́ɔ bénsēbē akɛ, boŋ bésad béhīdēʼ. Kə́ə́ŋ ne á asóg Yesuɛ mwěmpɛn anlyə̌g, ane mmwaád-tɛ abɛ́ atyéém áhed. ");
INSERT INTO bssNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Áde Yesuɛ átíídé yə̌l ámīn, dɔ́ɔ ásɛdtɛɛ́ ane mmwaád aá, “Á-mmwaád nɛ́n, héé bad ábe bépɛ́ɛ́né wɛ hɛ́n bédíí? Modmod eélyəgɛɛ́ hɛ́n awě ahɔ́bé aá béwúu wɛ-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ane mmwaád ankwɛntɛ́n aá, “A Sáŋ modmod.” Hɛ́ɛ Yesuɛ álâŋgɛɛ́ mɔ́ aá, “Né mɛ̌mpē méehɔ́bpé mɛɛ́ béwúu wɛ. Kǎg wɛ, boŋ weébɛ̄lē mbéb ámpē.” ");
INSERT INTO bssNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesuɛ anláá ábê bad ámpē aá, “Mɛɛ́ ndé eʼnyínɛn bé ekíde éʼ bad bé nkǒŋsé. Kénzɛ́ɛ́ awě ahíde mɛ, éekaá á ehíntɛ́n-tê, boŋ ǎkǔd eʼnyínɛn bé ekíde ábe éʼbageʼ aloŋgé.” ");
INSERT INTO bssNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Dɔ́ɔ Befarisia bélâŋgɛɛ́ mɔ́ bán, “Ebíde echoŋ yə̌l mbóŋ, né-ɔɔ́ mbóŋ echôŋ eékobnedɛɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesuɛ ankwɛntɛ́n aá, “Kénɛ́ɛ mměn ḿbídɛɛ́ echem yə̌l mbóŋ, echem mbóŋ edé mbále, áyə̄le mbíí wɛ́ɛ ḿbídé, mbíí-ʼɛ wɛ́ɛ ńkagké, boŋ nyé, nyéebíiʼɛ́ wɛ́ɛ mbídé, nyéebíi-ʼáa wɛ́ɛ ńkagké. ");
INSERT INTO bssNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nyêkáadte bad á nyaa e moonyoŋ. Meekáádtɛ́ɛ́ modmod. ");
INSERT INTO bssNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ké menkáád-tɛ ké káádtɛ́n, echêm mbakú edé mbále, áyə̄le meekáádtɛ́ɛ́ ne mměn, boŋ nkáadte, ne ane awě alómé mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nɛ́ɛ béhúde ké nɛ̂ áte, á mbéndé echɛ̂n, éténlédé nɛ́n bán nzé bad bébɛ bébídé dyam mbóŋ, boŋ béhɔ́bé melemlem mé dyam, né ene mbóŋ edé mbóŋ e mbále. ");
INSERT INTO bssNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nyébíi-ɔɔ́ nɛ́n bán nwóó mbóŋ ébɛ, mměn ne mod awě alómé mɛ, awě adé echem Sáŋ.” ");
INSERT INTO bssNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Hɛ́ɛ dɔ́ɔ Befarisia bésɛdtɛɛ́ mɔ́ bán, “Héé sóó ádíí?” Ankwɛntɛ́n bɔ́ aá, “Nyéebíiʼɛ́ mɛ, nyéebíi-ʼáa ké echem Sáŋ. Nzé nyêmbíí mɛ, né nyêbíí kə́ə́ŋne echem Sáŋ.” ");
INSERT INTO bssNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesuɛ anhɔ́b ábɛ́n eʼyale áde áyə́gtɛɛ́ á Ndáb-e-Dyǒb-te, bɛnbɛn ne wɛ́ɛ békoŋgɛɛ́ mɔné. Boŋ modmod enkênkóbpé mɔ́, áyə̄le eche póndé echě békóbɛɛ́ mɔ́ enkêmpaá. ");
INSERT INTO bssNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesuɛ anláá ábê bad ámpē aá, “Mɛ̌kɛ̌, nzé mmaá-ʼɛ akɛ, nyɛ́ɛ̄hɛ̌d mɛ, boŋ nyéenyínné, né-ɔɔ́ nyɛ́ɛ̄wɛ̄ áwɛn mbéb-te. Wɛ́ɛ mɛ́bɛ̄ɛ̄, nyéehɛnlé apɛ áhed.” ");
INSERT INTO bssNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Hɛ́ɛ bad bémbáá bé Israɛl bésɛdtɛɛ́ bán, “Ahɔ́beʼ aá, wɛ́ɛ mɔ́kɛɛ́ aá syánē déehɛnlé apɛ áhed, múmɔ́ ahɛde yə̌l awúu-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Anláá bɔ́ aá, “Nyêdíi bad ábe bébídé ásē wɛ́n, boŋ mɛ pɛn, mbídé ámīn. Nyêbídé á nkǒŋsé wɛ́n, mɛ pɛn, meebídɛɛ́ á nkǒŋsé wɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nɛ̂ dɔ́ɔ ákə́ə́ boŋ ńlāŋgē nyé mɛɛ́, “Nyɛ́ɛ̄wɛ̄ áwɛn mbéb-te. Nzé nyéedúbpe bán, ‘Ndíi Mod Awě Ńdíí,’ né nyɛ́ɛ̄wɛ̄-ʼɛ áwɛn mbéb-te.” ");
INSERT INTO bssNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Hɛ́ɛ bésɛdtɛɛ́ mɔ́ bánken, “Nzɛ́-módɛ́ édíí?” Dɔ́ɔ ákwɛntanné bɔ́ aá, “Nyaa e mod echě ńláŋgé nyé se á mbooted mɛɛ́ ndé chɔ́ɔ ńdíí. ");
INSERT INTO bssNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nwóó mam híin ahɔ́b tə̂ŋgɛne nyé, ne ákáad nyé. Boŋ mod awě alómé mɛ adíí mod a mbále, mekan ḿmě ńlâŋge-ʼáa nyé hɛ́n á nkǒŋsé médíi mekan ḿmě ńwógé áwē.” ");
INSERT INTO bssNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Áde Yesuɛ áhɔ́bé nɛ̂, bénkênsóŋtɛ́nné bán Sáá awě adé ámīn mɔ́ɔ áhɔ́bɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Póndé echě nyɛ́madté Mwǎn-a-Moonyoŋ abane ámīn, dɔ́ɔ nyɛ́bīīʼɛ́ bán, ‘Ndé mod awě ńhɔ́bé mɛɛ́ ndé.’ Nyêbíí-ʼɛ bán, meébɛ̄lɛ̄ɛ̄ dyamdyam ne kunze echêm, boŋ dyam áde ńhɔ́bɛɛ́ ádíi dyam áde echem Sáŋ áyə́gté mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ane awě alómé mɛ, adé-ʼɛ ne mɛ, eétɛdtɛɛ́ mměmpɛn, áyə̄le mbɛleʼ mekan ḿmě mébóŋnédé mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Bad híin ábe bénwōg nɛ́ɛ Yesuɛ áhɔ́bɛɛ́ ḿmɛ́n mekan, béndūbē mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ bad bé Israɛl ábe béndūbē mɔ́ aá, “Nzé nyêdíi nyêhídeʼ ádêm ayə́ge, né nyêkǒŋté ábêm bembapɛɛ abɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Né nyɛ́ɛ̄bīī mbále, né ene mbále ěhūd-tɛ nyé á mehaŋ-tê.” ");
INSERT INTO bssNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bênkwɛntɛ́n bán, “Sêdíi nchyáátɛ́n ḿme Abrahamɛ. Séēbédɛ́ɛ́-ʼáa ntâŋ a mod mbêd. Chán-nɔ̄ éhɛle éhɔ̄bē wɛɛ́ séebáá á mehaŋ-tê?” ");
INSERT INTO bssNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesuɛ ankwɛntɛ́n bɔ́ aá, “Ne mbále, nlâŋge nyé mɛɛ́, kénzɛ́ɛ́ awě abɛle mbéb adíi ntâŋ a mbéb. ");
INSERT INTO bssNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ntâŋ eebágké á túmbé-te abɛ́ ne abɛ́, boŋ mwǎn a túmbé, adíi mwǎn a túmbé póndé ésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Né-ɔɔ́, nzé Mwǎn ahúdé nyé á mehaŋ-tê, né dyamdyam déetédté nyé ntâŋ ámpē. ");
INSERT INTO bssNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mbíí mɛɛ́ nyêdíi nchyáátɛ́n ḿme Abrahamɛ, boŋ ké nɛ̂, nyêhɛde mɛ awúu, áyə̄le nyéēhɛ̄dɛ̄ɛ̄ ádêm ayə́ge ahíd. ");
INSERT INTO bssNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nlâŋge nyé mekan ḿme echem Sáŋ álúmté mɛ. Nyé-ʼɛ nyêbɛle mekan ḿme echɛn sáŋ áláŋgé nyé.” ");
INSERT INTO bssNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bênkwɛntɛ́n mɔ́ bán, “Abrahamɛ adíi echɛd sáŋ.” Yesuɛ anláá bɔ́ aá, “Nzé nyênkǒŋ bǎn ábe Abrahamɛ abɛ́, né nyêbɛleʼ mekan ḿme Abrahamɛ ábɛ́léʼáá. ");
INSERT INTO bssNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mekan mésyə̄ə̄l ḿme ńkémbɛnlé ńdíi âláa nyé mbále echě ńwógé wɛ́ɛ Dyǒb. Kénɛ̂, nyêhɛde mɛ awúu. Abrahamɛ eébɛleʼaá, enɛ́n ndín e dyam. ");
INSERT INTO bssNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nyêbɛle mekan ḿme echɛn sáŋ ábɛlɛɛ́.” Bênkwɛntɛ́n mɔ́ bán, “Dyǒb děmpɛn-ɛɛ́ séwóó nɛ́ɛ echɛd Sáŋ, béēchyáa-ʼáa sé á asón.” ");
INSERT INTO bssNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Nzé Dyǒb dênkǒŋ echɛn Sáŋ abɛ́, né nyêdəə́ mɛ, áyə̄le ḿbídé wɛ́ɛ Dyǒb ndé-ʼɛ hɛ́n bɔɔb. Meépedɛɛ́ ne mměn, boŋ mɔ́ alómé mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nzɔm echě ekəə́ boŋ nyéēhɛ̄dēʼ mɛ ehɔ́b awóg, edíi nyéēhɛ̄dɛ̄ɛ̄ ábêm eʼyale awóg. ");
INSERT INTO bssNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nyêdíi bǎn ábe echɛn sáŋ, Satanɛ, ḿme mewêmtɛn mɔ́-ʼaá nyédə́ə́ ahíd. Se á mbooted, adíi ane awě awúɛʼ bad, eékwógnédɛ́ɛ́ mbále mbêd, áyə̄le mbále eésaá mɔ́ áte. Nzé akale metóm, né abɛle ḿme nsɔ́n áyə̄le adíi nkal a metóm, abɛ́-ʼɛ sáá a metóm. ");
INSERT INTO bssNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nyéedúbpɛ́ɛ́ mɛ, áyə̄le nkanle nyé mbále. ");
INSERT INTO bssNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nyé ahéé ahɛle alúméd aá, mbɛlé mbéb? Nzé nkanle nyé mbále, cheé-ɔ̄ ékə́ə́ boŋ nyéedúbpé mɛ? ");
INSERT INTO bssNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kénzɛ́ɛ́ awě ahúú ne Dyǒb, awóge eyale é Dyǒb. Nzɔm echě ekəə́ boŋ nyéewóglán edíi, nyéesaá bǎn bé Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Hɛ́ɛ ábê bad bé Israɛl bétimtanné Yesuɛ bánken, “Éesaá mbále bán, sênkǎl mbále áde séhɔ́bé bán, edíi mod a Samaria, edəə́dəŋ é mbéb édé-ʼɛ wɛ áte-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ankwɛntɛ́n bɔ́ aá, “Edəə́dəŋ é mbéb eésaá mɛ áte. Mbage echem Sáŋ edúbé, boŋ nyépɛn nyéēbāgɛ̄ɛ̄ mɛ edúbé. ");
INSERT INTO bssNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mměn meéhɛ̄dtɛ̄ɛ̄ yə̌l edúbé, boŋ mod adé awě ahɛdeʼ aá ńkud edúbé, mɔ́-ʼaá, abage mbakú echě etə́ŋgɛ́né. ");
INSERT INTO bssNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ne mbále, nlâŋge nyé mɛɛ́, kénzɛ́ɛ́ awě abɛleʼ chǒm-ɛ́ɛ ń'yə́gtɛɛ́, éewáá mbêd.” ");
INSERT INTO bssNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Dɔ́ɔ ábê bad bélâŋgɛɛ́ mɔ́ bán, “Bɔɔb dɔ́ɔ sébíí bán, edəə́dəŋ é mbéb édé wɛ áte. Abrahamɛ anwɛ́, bekal béʼdəə́dəŋ bɔ́mpē bénwɛ̄. Boŋ bɔɔb éhɔ̄bē wɛɛ́ mod awě adúbpé wɛ, éewáá mbêd. ");
INSERT INTO bssNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Echɛd sáŋ Abrahamɛ anwɛ́. Ewémtɛ́né wɛɛ́ mɔ́tōmē mɔ́-yɛ? Bekal-bé-eʼdəə́dəŋ bɔ́mpē bénwɛ̄. Nzɛ́-módɛ́ wɛwɛ éwêmtanné wɛɛ́ mɔ́dē?” ");
INSERT INTO bssNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Hɛ́ɛ Yesuɛ ákwɛntanné bɔ́ aá, “Nzé nhɛdte echem yə̌l edúbé, né échê edúbé éesaá dyamdyam. Echem Sáŋ awě nyéhɔ́bɛɛ́ bán mɔ́ adé nyé sáá, mɔ́ abage mɛ edúbé. ");
INSERT INTO bssNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nyéēbīīʼɛ́ mɔ́ mbêd, boŋ mbíí mɔ́. Nzé nhɔ́bé mɛɛ́ meebíiʼɛ́ mɔ́, né ndé nkal a metóm nɛ́ɛ nyé. Boŋ mbíí mɔ́, mbɛle-ʼɛ mam ḿme áhɔ́bɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Echɛn sáŋ Abrahamɛ ambɛ́ menyiŋge aá, mɔ́ɔ̄nyīn epun éche mɛ́pɛɛ́, annyín-nɛ chɔ́, abɛ́-ʼɛ menyiŋge bwâmbwam.” ");
INSERT INTO bssNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Dɔ́ɔ bésɛdtɛɛ́ mɔ́ bán, “Áde wéēpēdɛ̄ɛ̄ móom mé mwɛ́ métáan, wɛɛ́ mɔ́nyīnē Abrahamɛ-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesuɛ ankwɛntɛ́n bɔ́ aá, “Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, byánán bɛ́chyāā Abrahamɛ, ‘Ndé.’ ” ");
INSERT INTO bssNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Áde ábê bad béwógé nɛ̂, dɔ́ɔ bébóótédé meláá ahɛd, âlúm mɔ́. Boŋ Yesuɛ ansɔɔ́m, abíd-tɛ á Ndáb-e-Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Áde Yesuɛ átómɛɛ́, dɔ́ɔ ányíné mod awě béchyááné ndím. ");
INSERT INTO bssNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Dɔ́ɔ ábē bembapɛɛ bésɛdtɛɛ́ mɔ́ bán, “A-meléed, mbéb ḿme nzɛ́ɛ́ ńkə́ə́ boŋ béchyáá anɛ́n mod ne ndím? Mbéb ḿmē mwěn-ɛ, káa ḿme sáá bɔ́ nyaŋ?” ");
INSERT INTO bssNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesuɛ ankwɛntɛ́n bɔ́ aá, “Saké ḿme mbéb ńkə́ə́, saá-kaá ḿme sáá bɔ́ nyaŋ. Boŋ nɛ́n ábɛ́nlédé âbɛl ngíne e Dyǒb ébîd áwed áwē yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ngáne bǐn éʼdíi ényînnɛɛ́ ámīn, detə́ŋgɛ́né débɛl nsɔ́n ḿme ane awě álómé mɛ. Ehíntɛ́n ékwógé apɛ áde mod éehɛnlé nsɔ́n abɛl. ");
INSERT INTO bssNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Bɔɔb áde ńdíí á nkǒŋsé, mɛ-ɛɛ́ ndé eʼnyínɛn bé ekíde bé nkǒŋsé.” ");
INSERT INTO bssNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Áde Yesuɛ ámáá ahɔ́b nɛ̂, ansob aléed á ndɔɔb, atɔ́b dɔ́ boŋ áwɔ̄gtē ane mod a ndím á mǐd, ");
INSERT INTO bssNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","álāŋgē mɔ́ aá, “Kǎg, éwobe eʼsó á etoŋ é Silom” (ádê dǐn ádé nɛ́n bán, “Bélómé”). Né-ɔɔ́, ane mod ankɛ̌, áwōbē-ʼɛ mǐd. Antǐm ámbīd, ányînneʼ. ");
INSERT INTO bssNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hɛ́ɛ bad ábe bémbīī mɔ́ ne bad ábe bényínáá ngáne áchɔ́mɛɛ́ bwěm, bésɛdtɛɛ́ bán, “Saá anɛ́n mod ayɔ̌gké adyɛɛ ásē, áchɔ̄mē bwěm-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Doŋge dénhɔ̄b bán, “Mɔ̂dé,” ábíníí-ʼɛ bán, “Aáy! Awágne mɔ́ wágnɛ́n.” Boŋ ane mod mwěn anhɔ́b aá, “Mměn-ɛɛ́ ndé.” ");
INSERT INTO bssNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Dɔ́ɔ bésɛdtɛɛ́ mɔ́ bán, “Chán-nɔ̄ émwédé abooted dé anyínɛn?” ");
INSERT INTO bssNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ankwɛntɛ́n bɔ́ aá, “Mod awě béchəgɛɛ́ bán, Yesuɛ, antɔ́b elɔɔb, awɔ́géd mɛ chɔ́ á mǐd, aláá-ʼɛ mɛ aá ńkɛ á etoŋ é Silom, ńkɛ ńwobe mǐd. Né-ɔɔ́, menkɛ̌. Awobe áde ńwóbpé mǐd, ḿbootéd-tɛ anyínɛn.” ");
INSERT INTO bssNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bênsɛdéd mɔ́ bán, “Héé ane mod adíí?” Ankwɛntɛ́n bɔ́ aá, “Meebíiʼɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Bênkɛɛ́n ane mod awě ankwɛ̌ ndím wɛ́ɛ Befarisia. ");
INSERT INTO bssNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Epun éche Yesuɛ ántɔ̄bpē elɔɔb ánēdē-ʼɛ ane mod mǐd áte, ébédɛ́ɛ Mbwɛ-mé-nkɔ́me-áte. ");
INSERT INTO bssNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Befarisia bênsɛdéd ane mod awě ankwɛ̌ ndím ámpē bánken, “Chán émwédé abootéd dé anyínɛn.” Hɛ́ɛ álâŋgɛɛ́ bɔ́ aá, “Antɔ́b elɔɔb awɔ́géd mɛ á mǐd. Áde ńwóbpé eʼsó, ḿbootéd-tɛ anyínɛn.” ");
INSERT INTO bssNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Hɛ̂ dɔ́ɔ doŋge á Befarisia béhɔ́bɛɛ́ nɛ́n bán, “Anɛ́n mod awě abɛlé ádɛ́n dyam, eéhɛ̄lɛ̄ɛ̄-sɛ abɛ́ mod awě Dyǒb álómé, áyə̄le eékoŋgɛɛ́ mbéndé e Mbwɛ-mé-nkɔ́me-áte.” Boŋ ábíníí-ʼɛ béhɔ́béʼáá bánken, “Chán mod a mbéb áhɛlɛsɛ ábɛléʼ échɛ́n ndín e menyáké?” Nɛ́n dêmpɛɛ́n nkabɛ́n átîntê echâb. ");
INSERT INTO bssNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Né-ɔɔ́, Befarisia bênsɛdéd ane mod ámpē bánken, “Ngáne éhɔ́bé wɛɛ́ mɔ̂bɛlé boŋ ényînneʼ, cheé éwóó ahɔ́b á yə̌l echê?” Hɛ́ɛ ane mod ákwɛntanné bɔ́ aá, “Adíi nkal éʼdəə́dəŋ.” ");
INSERT INTO bssNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ké nɛ̂, bad bé Israɛl bénkêndúbɛ́ɛ́ bán, ane mod ansébé ndím akwɛ. Nɛ̂ dêmbɛ̌l bénchɛ̄lē sáá bɔ́ nyaŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bênsɛdéd bɔ́ bánken, “Nyɛ́ɛ̄ nyêchyáá anɛ́n mod awě nyéhɔ́bé bán, béchyáá ne ndím-ɛ? Chán-nɔ̄ ébɛ́nlédé boŋ ányīnnē bɔɔb?” ");
INSERT INTO bssNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Dɔ́ɔ sáá bɔ́ nyaŋ békwɛntanné bán, “Sêbíí bán awɛd mwǎn mɔ̂dé, sêbíí-ʼɛ bán bénchyāā mɔ́ ne ndím. ");
INSERT INTO bssNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Boŋ séēkooʼɛ́ abíi ngáne ámwédé anyínɛn, séebíi-ʼáa mod awě abɛlé boŋ ányīnneʼ. Nyésɛdte mɔ́, eésaá mwěndem, mwěn áhɔ̂b.” ");
INSERT INTO bssNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Bénhɔ̄b nɛ̂ áyə̄le bébááʼáá bad bé Israɛl. Bad bé Israɛl bénhɔ̄b bán, kénzɛ́ɛ́ awě adúbpé aá Yesuɛ mɔ̂dé Ane-awě-Béwɔ́gté, bɛ́nan mɔ́ á ndáb e mekáne. ");
INSERT INTO bssNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nɛ̂ dɔ́ɔ dênkə̌ŋ boŋ sáá bɔ́ nyaŋ béhɔ́b bán, “Nyésɛdte mɔ́, eésaá mwěndem, mwěn áhɔ̂b.” ");
INSERT INTO bssNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Hɛ́ɛ ábê bad bé Israɛl béchɛ̂nlɛɛ́ ane mod awě Yesuɛ ândidté bwâm ngen échě élóntɛ́né ébɛ, boŋ bélāŋgē mɔ́ bán, “Kǎl echoŋ mbále á dǐn á Dyǒb. Sêbíí bán anɛ́n mod awě achǒŋté wɛ adíi mod a mbéb.” ");
INSERT INTO bssNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Dɔ́ɔ ane mod átimtanné bɔ́ aá, “Meebíiʼɛ́ mɛ ké adé mod a mbéb kéʼɛ eésaá. Dyam ahɔ́g áde ḿbíí, ádé nɛ́n, menkwɛ̌ ndím boŋ bɔɔb nnyînneʼ.” ");
INSERT INTO bssNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Hɛ́ɛ bésɛdtɛɛ́ mɔ́ bánken, “Cheé âmbɛnlé boŋ ébootéd anyínɛn?” ");
INSERT INTO bssNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ankwɛntɛ́n bɔ́ aá, “Mmaá nyé aláa boŋ kénɛ̂, nyéedúbpɛ́ɛ́ mɛ. Cheé nyéhɛdɛɛ́ bán ńláa nyé ámpē? Nyémpē nyêhɛdeʼ ábē bembapɛɛ abɛ́-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Hɛ́ɛ bésyə́əʼɛ́ mɔ́, béhɔ̄bē bán, “Wɛ-ɛɛ́ edé mbapɛɛ awě ane mod. Sêdíi bembapɛɛ ábe Mosɛɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Sêbíí bán, Dyǒb dénhɔ̄b wɛ́ɛ Mosɛɛ, boŋ séebíiʼɛ́ wɛ́ɛ anɛ́n mod pɛn ábídé.” ");
INSERT INTO bssNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ane mod ankwɛntɛ́n aá, “Nɛ́n ádé nkɔ̂mtɛn ń yə̌l áte. Nyéebíiʼɛ́ wɛ́ɛ ábídé, boŋ kénɛ̂ abɛlé nnyînneʼ. ");
INSERT INTO bssNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Debíí bán, Dyǒb déekwɛntánné mekáne mé bad bé mbéb, boŋ akwɛntan mekáne ḿme bad ábe bébage mɔ́ edúbé, bébɛlé-ʼɛ mam ḿme áhɛdɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Taasɛ nkǒŋsé ḿbootad mod eéwōgɛ̄ɛ̄ mbêd, bán mod abɛlé mod awě béchyááné ndím anyînneʼ. ");
INSERT INTO bssNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nzé anɛ́n mod awě achǒŋté mɛ enkêmbɛ́ mod a Dyǒb, né eéhɛleʼaá-sɛ ábɛl enɛ́n ndín e dyam.” ");
INSERT INTO bssNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Dɔ́ɔ ábê bad békwɛntanné mɔ́ bán, “Béchyáá wɛ á mbéb-te, ékwōg-kɛ á mbéb-te, boŋ bɔɔb éhɛdé sé ayə́ged-ɛ?” Hɛ́ɛ dɔ́ɔ bébídté mɔ́ á ndáb e mekáne. ");
INSERT INTO bssNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Áde Yesuɛ áwógé bán bébídté ane mod awě ânchoódté á ndáb e mekáne, anhɛd mɔ́. Áde ányíné mɔ́, ansɛdéd mɔ́ aáken, “Edúbpé Mwǎn-a-Moonyoŋ-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ane mod antimtɛ́n mɔ́ aá, “A-Sáŋ nzɛ́ɛ́ adé Mwǎn-a-Moonyoŋ, láá mé âbɛl nɛ́n ńdúbe mɔ́?” ");
INSERT INTO bssNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesuɛ anláá mɔ́ aá, “Emaá mɔ́ anyín, nyúmɔ̄-ʼaá nyêkaleʼ nɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Hɛ́ɛ ane mod áhɔ́bɛɛ́ aá, “A-sáŋ, ndúbpé!” Abwɔ́g-kɛ mebóbóŋ âbɛ mɔ́ edúbé. ");
INSERT INTO bssNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesuɛ anhɔ́b aá, “Mpedé á nkǒŋsé wɛ́n, âkáad bad âbɛl nɛ́n bad ábe békwédé ndím bényínɛn, ábe bɔ́-ʼɛ bényînneʼ, békwɛ ndím.” ");
INSERT INTO bssNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Áde doŋge á Befarisia ábe bɔ́ɔbɛ Yesuɛ bémbɛ̄ áhed béwógé nɛ̂, bênsɛdéd mɔ́ bánken, “Sêdúbpé bán, weehɔ́bɛ́ɛ́ wɛɛ́ sémpē sêkwedé ndím?” ");
INSERT INTO bssNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesuɛ anláá bɔ́ aá, “Nzé nyênkwɛ ndím, né mbéb méesaá nyé á yə̌l. Boŋ bɔɔb áde nyéhɔ́bɛɛ́ bán nyênyínneʼ, mbéb ńdíí ńdé nyé á yə̌l.” ");
INSERT INTO bssNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesuɛ anhɔ́b aá, “Ne mbále, nlâŋge nyé mɛɛ́, kénzɛ́ɛ́ awě eépoo á mmwɛ mé abem á mbód, boŋ átim achə́gé pɛd empée, adíi nchîb, abɛ́-ʼɛ mod e ewúɛn. ");
INSERT INTO bssNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Mod awě apooʼ á mmwɛ mé abem mɔ̂dé Nnɔn a ńdyɔŋ ḿ mbód. ");
INSERT INTO bssNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mod awě anɔne abem adibnad mɔ́ ekob. Achəge mbód tɛ́ɛ́ ne dǐn, ábīdnē-ʼɛ chɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Abídné-ʼaá chɔ́, atómɛ́n chɔ́, chɔ́-ʼɛ éhīdē mɔ́, áyə̄le ébíí éche ehɔ́b. ");
INSERT INTO bssNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Boŋ échê mbód éehídɛ́ɛ́ nken mbêd. Ébɛléʼ ébāāʼ mɔ́ á yə̌l báán, áyə̄le éechemɛ́ɛ́ éche ehɔ́b.” ");
INSERT INTO bssNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesuɛ ankalé bɔ́ enɛ́n ngan boŋ bénkênsóŋtɛ́nné. ");
INSERT INTO bssNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Né-ɔɔ́, Yesuɛ ambád ámpē aá, “Ne mbále, nlâŋge nyé nɛ́n mɛ-ɛɛ́, mɛ́ɛ ndé mmwɛ mé ekob wɛ́ɛ mbód épooʼɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Byánán mɛ̌pɛ̌, bad bésyə̄ə̄l ábe bésébpé apɛ bébédɛ́ɛ bechîb ne bad bé ewúɛn, boŋ mbód éekênwógɛ́nné bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mɛ-ɛɛ́ ndé ekob. Kénzɛ́ɛ́ awě apoó áwêm, ǎkǔd eʼsoósoŋ. Ǎsɔ̄l, abíd-tɛ ésebán mod atagte mɔ́. Ǎkud-tɛ kéchéé éche áhɛdɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Nchîb apag dásɔ̄ âchíb, âwúu ne âbébed. Mpedé âbɛl boŋ békud aloŋgé áde álóné mbon. ");
INSERT INTO bssNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Mɛ-ɛɛ́ ndé nnɔn-a-mbód a bwâm. Nnɔn-a-mbód a bwâm adé mboŋsɛ́n âwɛ́ á nló ḿme éche mbód. ");
INSERT INTO bssNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mod awě bétédé á nsɔ́n tédɛ́n, ânɔn mbód, áde mwěn éesaá nnɔn-a-mbód, áde éesaá-ʼaá nwóó-mbód, ányínɛɛ́ nyínɛ́n nɛ́ɛ ngə ehúɛʼɛ́, áchēnē mbód, atóm mehélé. Ene póndé dɔ́ɔ ngə ésogɛɛ́ mbód, échíníí-ʼɛ épáŋtéd áte. ");
INSERT INTO bssNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ane mod atóme mehélé áyə̄le adíi mod awě bétédé á nsɔ́n tédɛ́n, eewôŋnɛɛ́ échê mbód póndé. ");
INSERT INTO bssNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Mɛ́ɛ ndé nnɔn-a-mbód a bwâm. Mbíí échem mbód, échem mbód-tɛ ébíí mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Melemlem nɛ̂ dɔ́ɔ Titɛ́ɛ ábíí mɛ, mɛ-ʼɛ mbíí mɔ́. Mbǒŋsɛ́né-ʼɛ âwɛ́ á nló ḿme échem mbód. ");
INSERT INTO bssNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nwóó-ʼɛ mbód émpēe éche éesɛ̌ á abem-tê wɛ́n, ntə́ŋgɛ́né chɔ́mpē apɛɛn, chɔ́mpē éwōg échem ehɔ́b, né-ɔɔ́, abem dɛ́bɛ̄ ahɔ́g, nnɔn-a-mbód-tɛ nhɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Titɛ́ɛ adəə́ mɛ, áyə̄le mbǒŋsɛ́né âwɛ́ âbɛl ńkud ádêm aloŋgé ámbīd ámpē. ");
INSERT INTO bssNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Modmod eékobnɛ́ɛ́ mɛ ádêm aloŋgé, boŋ mbage dɔ́ ne mměn. Nwóó ngíne âbɛ ádêm aloŋgé, nwóó-ʼɛ ngíne âtéd dɔ́ ámpē. Nɛ́n dɔ́ɔ Titɛ́ɛ áláŋgé mɛ aá ḿbɛl.” ");
INSERT INTO bssNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ábɛ́n eʼyale ábe Yesuɛ bêmpɛɛ́n nkabɛ́n átîntê e bad bé Israɛl ámpē. ");
INSERT INTO bssNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bɔ́ bad híin béhɔ́béʼáá nɛ́n bán, “Edəə́dəŋ é mbéb édé mɔ́ áte, apedé mǐn. Chán nyéhɛle nyéwōglān mɔ́?” ");
INSERT INTO bssNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Boŋ bémpēe béhɔ́béʼáá bán, “Mod awě edəə́dəŋ é mbéb édíí áte eehɔ́bɛ́ɛ́ échɛ́n ndín e mekan. Edəə́dəŋ é mbéb éhɛle ébɛ̄l mod awě akwedé ndím anyínɛn-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ngande e Nnamed ń Ndáb-e-Dyǒb ékóbtéʼáá á Jerusalɛm. Nɛ́n ábédé á pondé éche ahéb ábágkē bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesuɛ ahyɔ́mméʼáá á abepé á Ndáb-e-Dyǒb áde béchə́géʼáá bán Abepé áde Solomonɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Bad bé Israɛl bênləŋnéd mɔ́, bésɛdté mɔ́ bán, “Póndé ehéé wɛwɛ wɛ́sōgkē sé abane á edibelónɛ́ɛ́-te? Nzé wɛ-ɛɛ́ edé Ane-awě-Béwɔ́gté, épanléd sé áte.” ");
INSERT INTO bssNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesuɛ ankwɛntɛ́n aá, “Mmaá nyé aláa, boŋ nyéedúbpɛɛ́. Nsɔ́n ḿme ḿbɛlɛɛ́ á dǐn áde awêm Titɛ́ɛ, měn ḿbíde mɛ mbóŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Boŋ nyéedúbpɛ́ɛ́ áyə̄le nyéesaá échêm mbód. ");
INSERT INTO bssNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Échem mbód éwóge échêm ehɔ́b. Mbíí chɔ́, chɔ́-ʼaá éhíde mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mbage bɔ́ aloŋgé áde déemaáʼ, béewáá-ʼaá mbêd. Modmod eéhɛ̄lɛ̄ɛ̄-sɛ ásog bɔ́ áwêm mekáá. ");
INSERT INTO bssNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Chǒm echě awêm Titɛ́ɛ ábágé mɛ étómé chǒm ésyə̄ə̄l, modmod eéhɛ̄lɛ̄ɛ̄-sɛ ásog bɔ́ á mekáá ḿme Titɛ́ɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Sé Titɛ̂ sêdíi mod nhɔ́g.” ");
INSERT INTO bssNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bad bé Israɛl béntēd meláá ámpē âlúm Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Boŋ anláá bɔ́ aá, “Nlúmté nyé ekud é nsɔ́n ḿ bwâm éche ébídé ne echem Sáŋ. Nyêhɛde me meláá alúm, âwúu mɛ. Ḿmê nsɔ́n ńhéé nyéhɛdɛɛ́ mɛ meláá alúmɛn.” ");
INSERT INTO bssNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Dɔ́ɔ békwɛntanné bán, “Séēhɛ̄dɛ̄ɛ̄ wɛ meláá alúm áyə̄le nsɔ́n ḿ bwâm ḿme ébɛ́lé. Boŋ sêlúme wɛ meláá áyə̄le esyə́ə́ Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesuɛ anláá bɔ́ aá, “Ngɔ́mē éténlédé áwɛn Kálag e Mbéndé nɛ́n bán, Dyǒb áhɔ́bé aá, ‘Nyêdíi myǒb.’ ");
INSERT INTO bssNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Debíí nɛ́n bán, eyale é Dyǒb éekwagké. Dyǒb dênchə̌g bad ábe ánlōmɛ̄nnē échē eyale aá bédíi myǒb. ");
INSERT INTO bssNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Mɛ-ɛɛ́ Dyǒb ánámté boŋ alóm-mɛ á nkǒŋsé, chán-nɔ̄ nyéhɛle nyéhɔ̄bē bán, nsyə́ə́ Dyǒb áyə̄le ńtúmé ahɔ́b mɛɛ́ ndíi Mwǎn a Dyǒb? ");
INSERT INTO bssNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nzé meébɛ̄lē nsɔ́n ḿme Titɛ́ɛ, nyéedúbpé mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Boŋ nzé édé nɛ́n bán mbɛle mɔ́, nyêdúbé ḿmê nsɔ́n ké nyéedúbpe mměn, âbɛl nɛ́n nyébíi nyésôŋtɛn-nɛ ngen pɔ́g ne ésyə̄ə̄l nɛ́n bán, Titɛ́ɛ adé mɛ áte, mɛ-ʼɛ mbɛ́ mɔ́ áte ngen pɔ́g ne ngen ésyə̄ə̄l.” ");
INSERT INTO bssNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ḿmɛ́n mam ḿme ánhɔ̄bpē mêmbɛ̌l bênwanɛ́n mɔ́ akób ámpē, boŋ ambíd bɔ́ á mekáá. ");
INSERT INTO bssNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ámbīd enɛ̂, Yesuɛ antǐm ámbīd á pɛd e edíb é Jodan eníníí, á abwɔ́g á hǒm wɛ́ɛ Jɔnɛ, Ndusɛnɛ ádúsánnáá bad, ádyɛ̄ɛ̄ áhed. ");
INSERT INTO bssNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ndun e mod epagéʼáá áwē. Ábê bad béhɔ́béʼáá bán, “Jɔnɛ, Ndusɛnɛ eébɛleʼaá menyáké boŋ kéchéé éche áhɔ́bé tə̂ŋgɛne anɛ́n mod édé mbále.” ");
INSERT INTO bssNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Né-ɔɔ́, ndun e mod echě embɛ́ áhed, endúbé Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mod nhɔ́g ambɛ́ awě béchə́géʼáá bán Lazarɔsɛ, akǒnléʼáá. Lazarɔsɛ ne baányaŋ bé bebaád, Maria ne Mataa bédyɛ́ɛ́ʼáá á dyad á Bɛtani. ");
INSERT INTO bssNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Anɛ́n Maria awě mwǎnyaŋ Lazarɔsɛ ákónléʼáá, mɔ̂ anwɔ́géd Yesuɛ dyɔ̌g dé elod é bwâm á mekuu, boŋ apínnéd échē esid. ");
INSERT INTO bssNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Né-ɔɔ́, Maria bɔ́ Mataa bɔ́ bénlōm nsəl wɛ́ɛ Yesuɛ bán, “A-Sáŋ, awoŋ nsón a nlém akonleʼ.” ");
INSERT INTO bssNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Áde Yesuɛ áwógé ḿmɛ́n nlébtéd anhɔ́b aá, “Ḿmɛ́n nkole méesógké ne kwééd. Nɛ́n ábɛ́nlédé âbɛ Dyǒb ehúmé, âbɛl boŋ Mwǎn a Dyǒb ákud edúbé.” ");
INSERT INTO bssNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesuɛ andə̌ŋ Mataa, Maria ne Lazarɔsɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ké nɛ̂, áde áwógé bán, Lazarɔsɛ akonle andíi ambɛ́ wɛ́ɛ ámbɛ̄ɛ̄ eʼpun éʼbɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Hɛ́ɛ álâŋgɛɛ́ ábē bembapɛɛ aá, “Détim ámbīd á Judeya.” ");
INSERT INTO bssNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Dɔ́ɔ ábe bembapɛɛ bélâŋgɛɛ́ mɔ́ bán “A-meléed, kíné saá áwed dɔ́ɔ bad béhɛ́déʼáá wɛ meláá awúɛn súútə́ŋʼɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesuɛ ankwɛntɛ́n bɔ́ aá, “Éesaá mbále bán mǔte ńwóó dyôm á háwa ne ébɛ-yɛ? Bad ábe békag mǔte béekwagké áyə̄le bédé ne ane awě adé eʼnyínɛn bé ekíde bé nkǒŋsé. ");
INSERT INTO bssNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Boŋ nzé békag nkuu, dɔ́ɔ békwagké áyə̄le eʼnyínɛn bé ekíde béesaá.” ");
INSERT INTO bssNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Áde Yesuɛ ámáá ahɔ́b nɛ́n ambád ámpē aá, “Awɛd nsón Lazarɔsɛ akúne, boŋ nkag mɔ́ anyem ásē.” ");
INSERT INTO bssNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ábē bembapɛɛ bénlāā mɔ́ bán, “A-Sáŋ, nzé akúne né ǎdyɛɛ́ bwâm.” ");
INSERT INTO bssNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesuɛ ahɔ́béʼáá nɛ́n áyə̄le ambíí aá, Lazarɔsɛ awédé, boŋ ábē bembapɛɛ bénwēmtɛ̄n bán, ahɔ́be aá, akúne kúnɛ́n. ");
INSERT INTO bssNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Né-ɔɔ́, Yesuɛ ampanléd bɔ́ áte aá, “Lazarɔsɛ awédé, ");
INSERT INTO bssNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","boŋ á yə̌l echɛ̂n, ndé menyiŋge nɛ́n mɛɛ́ meebédɛɛ́ áhed âbɛl boŋ nyédúbe. Syánē dékag-kɔɔ́ áwed bɔɔb.” ");
INSERT INTO bssNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Hɛ̂ dɔ́ɔ Tɔmasɛ (awě bênchuúʼɛ́ bán, Nhɛ́d) álâŋgɛɛ́ baáb bembapɛɛ aá, “Syánē ámpē dékag áwed âbɛl boŋ nzé kwééd chɔ́ edé déwɛ̂ ne Meléede.” ");
INSERT INTO bssNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Bɔɔb-pɔɔ́, áde Yesuɛ ápédé á Bɛtani, antán nɛ́ɛ bémáá Lazarɔsɛ alíme. Ene póndé né ḿmê ndim ńkébɛ̄ á soŋ-tê eʼpun éʼniin. ");
INSERT INTO bssNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bootya á Bɛtani âpɛ á Jerusalɛm ábédé dyam máyl mébɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ekud é bad bé Israɛl ênhyɛ̌ wɛ́ɛ Mataa bɔ́ Maria âwenned bɔ́ áyə̄le kwééd eche awab mwǎnyaŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Áde Mataa áwógé bán, Yesuɛ ahúɛʼ, ankɛ̌ mɔ́ abomɛn á nzii, boŋ Maria anlyə̌g á ndáb. ");
INSERT INTO bssNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Dɔ́ɔ Mataa álâŋgɛɛ́ Yesuɛ aá, “A-Sáŋ, nzé wembɛ́ hɛ́n né mwǎnned eewédɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Boŋ ké nɛ̂, mbíí mɛɛ́ ké bɔɔb kéchéé éche ésɛ́dté Dyǒb, Dyǒb dɛ́bɛ̌ wɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesuɛ anláá mɔ́ aá, “Mwǎnyoŋ ǎbɛ̄ á aloŋgé ámpē.” ");
INSERT INTO bssNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mataa antimtɛ́n mɔ́ aá, “Mbíí mɛɛ́ ǎpuú á póndé e mpuu mbwɛ mé asóg.” ");
INSERT INTO bssNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Dɔ́ɔ Yesuɛ aláŋgé mɔ́ aá, “Mɛ-ɛɛ́ ndé mpuu né aloŋgé. Nzé mod adúbpé mɛ, ké anwɛ́, ǎbɛ̄ abɛ́ á aloŋgé. ");
INSERT INTO bssNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kénzɛ́ɛ́ awě adé á aloŋgé boŋ adúbé-ʼɛ mɛ, éewáá mbêd. Edúbpé né-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Hɛ́ɛ Mataa ákwɛntanné aá, “Ɛɛ, A-Sáŋ, ndúbpé mɛɛ́ wɛ-ɛɛ́ edé Ane-awě-Béwɔ́gté, Mwǎn a Dyǒb awě Dyǒb áhɔ́bé aá, ǎpɛ̄ á nkǒŋsé.” ");
INSERT INTO bssNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Áde Mataa áhɔ́bé nɛ̂, antǐm ámbīd, ákɛ̄ áchəg mwǎnyaŋ Maria kun, aláá mɔ́ aá, “Meléede adé hɛ́n, asɛdte-ʼɛ wɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Áde Maria áwógé nɛ̂, anhidé ásē mehélé, ákɛ atán Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Bɔɔb-pɔɔ́, Yesuɛ enkêmpaá asɔ́l á dyad-tê, andíi ambɛ́ wɛ́ɛ Mataa ántānnē mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Áde bad bé Israɛl ábe bébédé á ndáb-te ne Maria âwenned mɔ́, bényíné nɛ́ɛ ábídé á ndáb-te ne mehélé, anyəgte á soŋ, bénwēmtɛ̄n bán, akag achii. Né-ɔɔ́, bénhīd mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Áde Maria ápédé wɛ́ɛ Yesuɛ ámbɛ̄ɛ̄ boŋ anyín mɔ́, ankwɛ̌ mɔ́ á mekuu, ahɔ́b aá, “A-Sáŋ, nzé wembɛ́ hɛ́n, né mwǎnned eewédɛɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Anyín áde Yesuɛ ányíné nɛ́ɛ Maria áchyɛɛʼɛ́, anyín-nɛ nɛ́ɛ bad ábe bénhīd mɔ́ béchyɛɛʼɛ́, ngɔl enkonnéd mɔ́, átāg-kɛ áte á nlém-tê bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ansɛdéd aáken, “Héé nyélímmé mɔ́?” Bênkwɛntɛ́n bán, “A-Sáŋ, hyɛ̌ ényîn.” ");
INSERT INTO bssNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesuɛ anchií. ");
INSERT INTO bssNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Hɛ́ɛ bad bé Israɛl béhɔ́bɛɛ́ bán, “Nɛ́dē ankǒŋ mɔ́ adəŋ-óó!” ");
INSERT INTO bssNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Boŋ bɔ́ doŋge á bad bénhɔ̄b bán, “Ngɔ́mē ambɛ̌l mod awě ankwɛ ndím ányīnne. Eéhɛleʼaá-sɛ ábɛl Lazarɔsɛ eewág-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ngɔl enkonnéd Yesuɛ á nlém ámpē. Né-ɔɔ́, ankɛ̌ á soŋ. Ene soŋ ebédɛ́ɛ soŋ echě bépwɔ́gé aláá áte, boŋ békútɛ́n chɔ́ nsəl ne aláá. ");
INSERT INTO bssNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ ábê bad aá, “Nyéhûd ádê aláá.” Dɔ́ɔ Mataa, mod awě awédé mwǎnyaŋ áhɔ́bɛɛ́ aá, “A-Sáŋ, ndim mɛ́mǎd abooted dé achum bɔɔb áyə̄le ńkídémbɛ́ á soŋ-tê bɔɔb eʼpun éʼniin.” ");
INSERT INTO bssNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ mɔ́ aá “Meelâŋgɛɛ́ wɛ mɛɛ́ nzé edúbpé né wɛ̌nyīn Ngum e Dyǒb-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Né-ɔɔ́, ábê bad bénhūd ádê aláá á nsəl ń soŋ. Dɔ́ɔ Yesuɛ ánɔ́né ámīn boŋ áhɔ̄bē aá, “A-Tɛ̂, nságnɛ́né wɛ áyə̄le éwógé mɛ mekáne. ");
INSERT INTO bssNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mbíí mɛɛ́ eyɔ̌gké mɛ mekáne awóg, boŋ nhɔ́be nɛ́n âbɛl boŋ ábɛ́n bad ábe bédé hɛ́n bédúbe bán, wɛ-ɛɛ́ elómé mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Áde ámáá ahɔ́b nɛ̂ dɔ́ɔ áchə́gté ehɔ́b ámīn boŋ áchɛ̄nlē Lazarɔsɛ aá, “A-Lazarɔs, bíd áwed!” ");
INSERT INTO bssNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ane mod awě ammǎd awɛ́ abíd-tɛ áwed. Mbɔ́m éche bênkaánné mɔ́ mekuu ne mekáá ne tumbe echě bênkaánné mɔ́ eʼsó, émbɛ̄ ébɛ̄ mɔ́ á yə̌l. Yesuɛ anláá bɔ́ aá, “Nyéhune mɔ́ ábê bwěm á yə̌l, ákag.” ");
INSERT INTO bssNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bad bé Israɛl ábe bênkɛ̌ Maria á mewenned bényīn mekan ḿme Yesuɛ âmbɛnlé, béndūbē-ʼɛ Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Boŋ bɔ́ doŋge á bad bênkɛ̌ Befarisia atán, béláá bɔ́ mam ḿme Yesuɛ ábɛ́lé. ");
INSERT INTO bssNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Hɛ́ɛ beprisɛ bémbáá ne Befarisia béchɛ́nlé mbom ń káánsɛl. Bénhɔ̄b bán, “Cheé dɛ́bɛnlé bɔɔb? Detə́ŋgɛ́né dyam abɛl áyə̄le anɛ́n mod abɛle menyáké bwâmbwam! ");
INSERT INTO bssNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nzé detɛ̌dté bán, ákɛɛne ḿmɛ́n mekan áʼsō né moosyəə́l ǎdūbē mɔ́. Nzé moosyəə́l adúbpé-ʼɛ mɔ́, né bad bé Roma bɛ́pɛ̌, békōbɛ̄n-nɛ syánē echɛd Ndáb-e-Dyǒb, békōbɛ̄n-nɛ syánē ádɛ̄d aloŋ.” ");
INSERT INTO bssNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Dɔ́ɔ mod nhɔ́g átîntê echâb awě béchə́géʼáá bán Kaifasɛ, awě abédé prisɛ ambáámbáa ḿmê mwɛ̌, áhɔ́bɛɛ́ aá, “Nyéebíiʼɛ́ dyamdyam. ");
INSERT INTO bssNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nyéenyínɛ́ɛ́ nɛ́n bán ébóó bán, mod nhɔ́g áwɛ̂ á nló ḿ moosyəə́l tómaa aloŋ ásyə̄ə̄l ábɔ́ɔ?” ");
INSERT INTO bssNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kénɛ́ɛ áhɔ́béʼáá nɛ̂, saké ḿmē mewêmtɛn měn mɔ́ɔ áhɔ́bnéʼáá nɛ̂. Ngáne ábédé prisɛ ambáámbáa ḿmê mwɛ̌, ahɔ́béʼáá dyam áde dɛ́bɛnléd, áʼsō éʼ póndé, aá Yesuɛ ǎwɛ̄ á nló ḿ bad bé Israɛl. ");
INSERT INTO bssNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Saá-kaá á nló ḿ bad bé Israɛl bénpɛn, boŋ kə́ŋne âlad bad bé Dyǒb bésyə̄ə̄l ábe bémáá ahɛnted áte hǒm ahɔ́g, âbɛl bébɛ̂ mod nhɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Bootya échê epun bad bémbáá bé Israɛl bêmbootéd Yesuɛ ahəge, âwúu mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nɛ́n dêmbɛ̌l Yesuɛ eebídeʼaá á nhɛ́né ámpē átîntê e bad bé Israɛl. Bɔ́ɔbɛ ábē bembapɛɛ bênhidé békɛ̄ á dyad áde béchəgɛɛ́ bán Efrem, bédyɛ̄ɛ̄-ʼɛ áwed. Ádê dyad ábédé bɛnbɛn ne ehyáŋge. ");
INSERT INTO bssNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Póndé e ngande e Nnyíme-ámīn embɛ́ bɛnbɛn. Né-ɔɔ́, bad híin bémbīd myad ne myad, békɛ̄ á akuu á Jerusalɛm âwobe échab yə̌l ngáne mbéndé e Mosɛɛ éhɛ́déʼáá, âboŋsɛn ngande e Nnyíme-ámīn. ");
INSERT INTO bssNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ábê bad bé Israɛl bémbɛ̄ béhɛdé Yesuɛ. Áde béládné á Ndáb-e-Dyǒb bésɛ́dtéʼáá, nhɔ́g ne aníníí bánken, “Chán nyéwémtɛ́né, nyêdúbpé bán, ǎhyɛ ngande-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Beprisɛ bémbáá ne Befarisia béntōmēd ehə́ŋgé bán, kénzɛ́ɛ́ awě anyíné Yesuɛ áhyɛ áláa bɔ́, âbɛl boŋ békōb mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Áde ngande e Nnyíme-ámīn élyə́gé eʼpun ntóób, Yesuɛ ankɛ̌ á Bɛtani wɛ́ɛ Lazarɔsɛ awě âmpuúdté ádyɛ́ɛ́ʼáá. ");
INSERT INTO bssNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Bêmbɛlé Yesuɛ ndyééd áhed. Mataa mɔ́ antómēd ene ndyééd. Lazarɔsɛ ambɛ́ nhɔ́g átîntê e bad ábe bɔ́ɔbɛ Yesuɛ bébédé á tébelɛ âdyɛ́ ndyééd. ");
INSERT INTO bssNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Hɛ́ɛ Maria átédé epom é dyɔ̌g dé elod á bwâm áde álɛ́lé nkun bwâmbwam. Ádê dyɔ̌g bébɛ́nlé dɔ́ nâd. Anwɔ́géd Yesuɛ á mekuu, apíné-ʼɛ mɔ́ mekuu ne échē esid é nló. Elod é bwâm énlɔ̄g ndáb áte esyəə́l. ");
INSERT INTO bssNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Dɔ́ɔ Judas Iskariɔdɛ, mbapɛɛ nhɔ́g awě émbɛ̄ɛ̄ bán mɔ́ ǎsōm Yesuɛ áhɔ́bɛɛ́ aá, ");
INSERT INTO bssNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Cheé bénkênsómmé ádɛ́n dyɔ̌g, bétéd ḿmɛ́n mɔné békɛ̄ bébɛ̄ betóótōkɛ̄ bé bad? Béhɛ́léʼáá-sɛ bésóm ádê dyɔ̌g dyam-ɛ́ɛ áde nsábe ḿ mwɛ̌ nhɔ́g.” ");
INSERT INTO bssNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judasɛ anhɔ́b nɛ̂, saké áyə̄le abédé betóótōkɛ̄ bé bad ngɔl, boŋ áyə̄le abédɛ́ɛ nchîb. Ngáne ábédé mod awě awánládtáá bɔ́bɔ̄ɔ ekwɛ é mɔné, ayɔ̌gkéʼáá mɔné atéd ámbīd. ");
INSERT INTO bssNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Boŋ Yesuɛ anhɔ́b aá, “Tɛdé mɔ́, ákoo áde ályə́gé ásē âbɛl boŋ ábɛnled dɔ́ mbwɛ ḿme bɛ́līmɛ̄ɛ̄ mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Betóótōkɛ̄ bé bad bédé ne nyé póndé tɛ́ɛ́ boŋ mɛ pɛn méebáá ne nyé póndé ésyə̄ə̄l.” ");
INSERT INTO bssNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ene póndé-ɔɔ́, bad bé Israɛl híin bénwōg bán, Yesuɛ adé á Bɛtani. Né-ɔɔ́, bênkɛ̌ áwed. Saké Yesuɛ mwěmpɛn mɔ́ ankə̌ŋ boŋ békɛ̄ áwed, boŋ bênkɛ̌ Lazarɔsɛ anyín awě Yesuɛ âmpuúdté. ");
INSERT INTO bssNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Né-ɔɔ́, Beprisɛ bémbáá béhə́gkéʼáá kə́ə́ŋne Lazarɔsɛ âwúu mɔ́, ");
INSERT INTO bssNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","áyə̄le bad bé Israɛl bétɛ́dtéʼáá bɔ́, bédūbpē Yesuɛ. Béndūbē Yesuɛ áyə̄le dyam áde dêmbɛnléd ne Lazarɔsɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nɛ́ɛ bǐn éʼsáŋgé, ndun e mod echě enhyɛ̌ á Ngande e Nnyíme-ámīn bénwōg bán Yesuɛ apag á Jerusalɛm. ");
INSERT INTO bssNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Hɛ̂ dɔ́ɔ bésɛ́lé eʼkikag éʼ mií boŋ békǎg mɔ́ abomɛn á nzii. Béhágéʼáá eʼsaád bán, “Hosána! Nnam ḿbɛ̂ ne ane awě apedé á dǐn áde Sáŋgwɛ́ɛ́. Nnam ḿbɛ̂ ne kə̂ŋ e bad bé Israɛl!” ");
INSERT INTO bssNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesuɛ ankǔd etum é ésɛl, ádīī-ʼɛ chɔ́. Nɛ́n dêmbɛnléd ngáne éténlédé á kálag e Dyǒb nɛ́n bán, ");
INSERT INTO bssNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Á-bad bé Zayɔn, nyéebááʼ, nyénɔneʼ echɛn kə̂ŋ ehúɛʼ, ediídé-ʼɛ etum é ésɛl.” ");
INSERT INTO bssNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Á póndé echě ḿmɛ́n mekan mébɛ́nlédé, bembapɛɛ ábe Yesuɛ bénkênsóŋtɛ́nné. Boŋ áde Yesuɛ âmpuúʼɛ́ ne ehúmé é Dyǒb, dɔ́ɔ bênchemmé bán mam ḿme mébɛ́nlédé tə̂ŋgɛne Yesuɛ mɔ́ɔ mêntenléd, á yə̌l echê. ");
INSERT INTO bssNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ndun e mod echě embɛ́ ne Yesuɛ áde áchɛ́nlé Lazarɔsɛ á soŋ-tê boŋ ápuudté mɔ́, embɛ́ ékaléʼ ḿmê nkalaŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Né-ɔɔ́ ndun e mod enkɛ̌ Yesuɛ abomɛn áyə̄le ábɛ́n eʼchemléd bé menyáké ábe âmbɛnlé. ");
INSERT INTO bssNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Hɛ́ɛ Befarisia bélâŋgɛɛ́ nhɔ́g ne aníníí bán, “Nyénɔneʼ! Kə́ŋne bɔɔb deéhɛ́lɛ́ɛ́ dyamdyam abɛl. Nkǒŋsé ńsyə̄ə̄l ńhide mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Doŋge á bad bé Grikia bémbɛ̄ átîntê e bad ábe bênkɛ̌ ngande e Nnyíme-ámīn á Jerusalɛm, âkɛ dé abɛ Dyǒb edúbé. ");
INSERT INTO bssNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bêmpɛ̌ wɛ́ɛ Filibɛ. Filibɛ awě ambíd á dyad á Betsaida á mbwɔ́g e Galilia. Bénlāā mɔ́ bán, “A-Sáŋ, sêdəə́ Yesuɛ anyín.” ");
INSERT INTO bssNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filibɛ ankɛ̌ Andreya aláa. Dɔ́ɔ bɔ́ bad bébɛ békíí Yesuɛ aláa. ");
INSERT INTO bssNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesuɛ ankwɛntɛ́n bɔ́ aá, “Póndé epedé echě ehúmé e Mwǎn-a-Moonyoŋ énnyīnēdtē. ");
INSERT INTO bssNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, mbum e ngun pɔ́g edíi mbum e ngun pɔ́g, kə́ə́ŋ né béwéné chɔ́ á ndɔɔb-tê boŋ ewɛ́. Ewâg-káa, boŋ echyáá mbum é ngun émpēe éche ébúú áte. ");
INSERT INTO bssNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mod awě adəə́ ádē aloŋgé, ǎbɔ̄d dɔ́. Mod awě mɔ́-ʼɛ akɔɔ́ ádē aloŋgé, á nkǒŋsé-te wɛ́n, ǎkəə́ dɔ́ á aloŋgé áde déemaáʼ. ");
INSERT INTO bssNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kénzɛ́ɛ́ awě abɛnle mɛ, atə́ŋgɛ́né awêm mbəledɛ abɛ́. Ké héé-ʼɛ wɛ́ɛ ńdíí, awêm mbəledɛ atə́ŋgɛ́né abɛ́ áhed. Echem Sáŋ ǎbɛ̌-ʼɛ kénzɛ́ɛ́ awě abɛnle mɛ edúbé. ");
INSERT INTO bssNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Bɔɔb-pɔɔ́, nlém ńtage mɛ áte. Cheé-ɔ̄ mɛ́hɔ̄bpē? Ńhɔ̂b mɛɛ́, ‘A-Tɛ̂, weémwāg-sɛ metake ḿme méhúɛʼ métán mɛ-yɛ?’ Aáy, méehɔ́bpé nɛ̂, áyə̄le enɛ́n póndé e metake chɔ̂ ekəə́ boŋ ḿpag wɛ́n. ");
INSERT INTO bssNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","A-Tɛ̂, lúméd echôŋ ngum.” Hɛ́ɛ ehɔ́b ébídɛɛ́ á Dyǒb nɛ́n bán, “Nlúmté echêm ngum, mɛ̌lūmēd-tɛ chɔ́ ámpē.” ");
INSERT INTO bssNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ene ndun e mod echě embɛ́ áhed enwóg échê ehɔ́b. Bénhɔ̄b bán dyǒb dɔ́ɔ ákúmé áte. Bad bémpēe bénhɔ̄b bán, ángɛl chɔ́ ehɔ́bé áwē. ");
INSERT INTO bssNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesuɛ anláá bɔ́ aá, “Áyə̄le echɛ̂n dɔ́ɔ échɛ́n ehɔ́b ébídé, saké áyə̄l echêm. ");
INSERT INTO bssNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Póndé epedé echě Dyǒb dɛ́kāādtē ḿmɛ́n nkǒŋsé. Nkamlɛn ḿme nkamlɛnɛ á nkǒŋsé mɛ́kwɛ̌ bɔɔb. ");
INSERT INTO bssNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Boŋ áde bɛ́madté mɛ anyen ámīn, mɛ̌dǒl bad bésyə̄ə̄l áwêm.” ");
INSERT INTO bssNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Yesuɛ anhɔ́b nɛ̂ âlúmed ndín e kwééd echě áwɛ̄ɛ̄.) ");
INSERT INTO bssNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ndun e mod echě embɛ́ áhed enkwɛntɛ́n mɔ́ bán, “Sêwógé á mbéndé-te bán Ane-awě-Béwɔ́gté ǎbɛ̄ á ngíndé ne á ngíndé. Chán-nɔ̄ éhɔ́bɛɛ́ wɛɛ́ ‘Bétə́ŋgɛ́né bényēn Mwǎn-a-Moonyoŋ ámīn.’ Nzɛ́ɛ́ adé anɛ́n ‘Mwǎn-a-Moonyoŋ?’ ” ");
INSERT INTO bssNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ bɔ́ aá, “Eʼnyínɛn bé ekíde bɛ́bē ne nyé á esóŋ e póndé ngɛ̂n. Nyékag bɔɔb áde eʼnyínɛn bé ekíde éʼdíi éʼdíí, âbɛl boŋ ehíntɛ́n éēkōbē nyé. Mod awě akag á ehíntɛ́n-tê eebyɛ́ɛ́ʼɛ́ wɛ́ɛ ákagké. ");
INSERT INTO bssNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nyédúbe eʼnyínɛn bé ekíde bɔɔb áde éʼdíí ne nyé, âbɛl nɛ́n nyébɛ̂ bǎn bé eʼnyínɛn bé ekíde.” Áde Yesuɛ ámáá ḿmɛ́n mekan mésyə̄ə̄l ahɔ́b, antɛdé bɔ́, ákɛ ásɔ̄ɔ̄m wɛ́ɛ béenyínné mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kénɛ́ɛ ene ndun e mod énnyīnnē ábɛ́n eʼchemléd bé menyáké éʼsyə̄ə̄l ábe Yesuɛ âmbɛnlé, bénkêndúbɛ́ɛ́ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nɛ́n dêmbɛnléd âlóned eʼyale ábe nkal éʼdəə́dəŋ Yesayaa ánhɔ̄bpē aá, “A-Sáŋ, nzɛ́ɛ́ adúbpé eyale éche sékálé, nzɛ́-módɛ́ akidényīn ngum echôŋ áchēm-mɛ chɔ́?” ");
INSERT INTO bssNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Né-ɔɔ́, béehɛleʼaá-sɛ bédúbe. Yesayaa ahɔ́bé hǒm démpēe aá, ");
INSERT INTO bssNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Dyǒb ákwídé bɔ́ ndím, ábɛ̄-ʼɛ bɔ́ nlém mé aláá, âbɛl nɛ́n ḿmab mǐd méēnyīnnēʼ, béēsóŋtánne. Nzé bébɛ́lé-ʼɛ nɛ̂, né bɛ́timɛ́n mɛ, né mɛ̌choód-tɛ bɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesayaa anhɔ́b nɛ́n áyə̄le annyín ehúmé éche Yesuɛ, anhɔ́b-pɛ áyə̄l echê. ");
INSERT INTO bssNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ké nɛ̂, bad híin béndūbē Yesuɛ, kə́ə́ŋne doŋge á bad bémbáá. Boŋ ngáne bébááʼáá Befarisia, bénkênlúmédté yə̌l, âbáŋ nɛ́n bán béēbídté bɔ́ á ndáb é mekáne. ");
INSERT INTO bssNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bébɛ́léʼáá nɛ̂ áyə̄le bêndə̌ŋ mekɛnag mé baányoŋ tómaa mé Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Hɛ́ɛ Yesuɛ áchə́gté ehɔ́b ámīn áhɔ̄bē aá, “Kénzɛ́ɛ́ awě adúbpé mɛ, eedúbpɛɛ́ mměmpɛn, adúbpé kə́ə́ŋne ane awě alómé mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kénzɛ́ɛ́-ʼɛ awě anyíné mɛ, anyíné ane awě alómé mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mpedé á nkǒŋsé nɛ́ɛ eʼnyínɛn bé ekíde, âbɛl boŋ kénzɛ́ɛ́ awě adúbpé mɛ, eélyə̄gē á ehíntɛ́n-tê. ");
INSERT INTO bssNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kénzɛ́ɛ́ awě awógé ábêm eʼyale, boŋ eékoŋge bɔ́, saké mɛ nkáadte mɔ́. Meekáádtɛ́ɛ́ mɔ́ áyə̄le meépedɛɛ́ âkaad nkǒŋsé boŋ mpedé âsoŋ bad bé nkǒŋsé. ");
INSERT INTO bssNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kénzɛ́ɛ́ awě abáá mɛ á yə̌l boŋ eékobe-ʼɛ ábêm eʼyale, awóó mod awě ǎkāād mɔ́. Ábêm eʼyale běn bɔ́ɔ bɛ́kāād mɔ́ á mbwɛ mé asóg. ");
INSERT INTO bssNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ébɛ̂ nɛ̂, áyə̄le meehɔ́bɛɛ́ ḿmɛ́n mésyə̄ə̄l ne echêm kunze. Boŋ Titɛ́ɛ awě alómé mɛ, áláŋgé mɛ chǒm éche ńtə́ŋgɛ́né ahɔ́b. ");
INSERT INTO bssNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mbíí mɛɛ́ kéchéé éché áláŋgé mɛ aá ńhɔ̂b épɛɛne aloŋgé áde déemaáʼ. Né-ɔɔ́, kéchéé éche ńhɔ́bɛɛ́, nhɔ́beʼ chɔ́ ngáne Titɛ́ɛ áláŋgé mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Epun é ngande e Nnyíme-ámīn ênlyə̌g nɛ́ɛ chǎn. Yesuɛ ambíí aá eche póndé emaá apɛ echě mɔ́tə́ŋgɛ́né nkǒŋsé atɛde, âkɛ wɛ́ɛ eche Sáŋ. Andə̌ŋ bad bé nkǒŋsé ábe béndūbē mɔ́, alúméd-tɛ échê edəŋge kə́ə́ŋne á asóg. ");
INSERT INTO bssNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesuɛ ne ábē bembapɛɛ bédyágéʼáá ndyééd ngukɛ́l, Satanɛ-ʼɛ ammǎd Judas Iskariɔdɛ mwǎn awě Simɔnɛ mewêmtɛn mé mbéb ásɔ́led áte âsóm Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesuɛ ambíí aá eche Sáŋ abagé mekan mésyə̄ə̄l áwe mekáá. Ambíí-ʼɛ aá mɔ́hūū wɛ́ɛ Dyǒb mɔ́time-ʼɛ ámbīd wɛ́ɛ Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Áde bédyágkē ndyééd nɛ̂, Yesuɛ anhidé ásē, ahúd nkob á yə̌l, atád tábɛlɛ á nkog. ");
INSERT INTO bssNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Hɛ́ɛ áhédé mendíb á kúmbe-tê, boŋ ábootéd ábē bembapɛɛ mekuu awobe, ápīnnād tábɛlɛ awě ánwāāʼɛ́ á nkog. ");
INSERT INTO bssNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Áde ápédé wɛ́ɛ Simɔn Petro dɔ́ɔ Simɔnɛ ásɛdtɛɛ́ mɔ́ aá, “A-Sáŋ, ehɛde mɛ mekuu awobe-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesuɛ ankwɛntɛ́n mɔ́ aá, “Weéhɛ̄lɛ̄ɛ̄-sɛ esóŋtɛ́n dyam áde ḿbɛlɛɛ́ bɔɔb, boŋ ámbīd e ḿmɛ́n mésyə̄ə̄l dɔ́ɔ wɛ́sōŋtɛ̄nnē.” ");
INSERT INTO bssNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Hɛ́ɛ Petro áhɔ́bɛɛ́ aá, “Aáy, weéwóbpɛ́ɛ́ mɛ mekuu mbêd.” Yesuɛ antimtɛ́n mɔ́ aá, “Nzé meéwobpe wɛ mekuu né wéewóŋgé dyamdyam abɛlɛn ne mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simɔn Petro anláá mɔ́ aá, “A-Sáŋ, né saké mekuu měmpɛn-ɛɛ́ wɛ́wobɛ́ɛ́ mɛ. Wɛ̌wobé mɛ kə́ə́ŋne mekáá ne nló!” ");
INSERT INTO bssNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesuɛ ankwɛntɛ́n aá, “Mod awě amaá mendíb awɔg, yə̌l esyəə́l emaá mɔ́ asáŋ, eetə̂ŋgɛnɛɛ́ mendíb awɔ́g ámpē, étōmɛɛ́ âwobe mekuu. Nyêmaá asáŋ, boŋ saké nyé moosyəə́l nyêsáá.” ");
INSERT INTO bssNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesuɛ ammǎd abíi mod awě ǎsōm mɔ́. Nɛ́ɛ dênkə̌ŋ boŋ ahɔ́b aá saké moosyəə́l asáá. ");
INSERT INTO bssNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Áde ámáá bɔ́ mekuu awobe, anhɛ́ ḿmē nkob á yə̌l, átīm ámbīd áwē eʼdii. Hɛ́ɛ ásɛdtɛɛ́ bɔ́ aáken, “Nyêsóŋtɛ́né dyam áde ḿbɛ́nlé nyé-yɛ? ");
INSERT INTO bssNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nyêchəge mɛ Meléede, nyêchəge-ʼɛ mɛ Sáŋgwɛ́ɛ́. Nyêtə́ŋgɛ́né, áyə̄le nɛ̂ děn dɔ́ɔ ńdíí. ");
INSERT INTO bssNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Né-ɔɔ́, nzé mɛ awě ndé nyé Sáŋgwɛ́ɛ́ mbɛ́-ʼɛ nyé Meléede nwǒbpé nyé mekuu, né nyémpē nyêtə́ŋgɛ́né nhɔ́g ne aníníí mekuu awobe. ");
INSERT INTO bssNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nlúmté nyé eláŋsɛ́n éche nyétə́ŋgɛ́né ahíd âbɛl nɛ́n nyémpē nyébɛl ngáne ḿbɛ́nlé nyé. ");
INSERT INTO bssNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ne mbále nlâŋge nyé nɛ́n mɛɛ́, mbəledɛ eetómɛ́ɛ́ eche sáŋ, mod awě bélómé-ʼɛ eetómɛ́ɛ́ mod awě alómé mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Bɔɔb áde nyébíí ḿmɛ́n mam, nnam mɛ́bɛ̄ ne nyé nzé nyêbɛle mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Meehɔ́bɛ́ɛ́ nyé moosyəə́l. Mbíí bad ábe ḿpwɛ́dé. Boŋ eʼyale ábe éʼténlédé á Kálag e Dyǒb éʼtə́ŋgɛ́né alón. Éténlédé nɛ́n bán, ‘Mod awě súmɔ̄ sêdyâg ndyééd akǔnnɛ́né mɛ yə̌l.’ ");
INSERT INTO bssNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nlâŋge nyé nɛ́n bɔɔb, áde éēbɛ̄nlēdɛ̄ɛ̄ âbɛl nɛ́n nzé ébɛ́nlédé, nyédúbe nɛ́n bán, ‘Ndíi mɔ́ Awě Ńdíí.’ ");
INSERT INTO bssNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, kénzɛ́ɛ́ awě akobé mod awě ńlómé, akobé mɛ. Kénzɛ́ɛ́-ʼɛ awě akobé mɛ né akobé ane awě alómé mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Áde Yesuɛ ámáá ḿmɛ́n mekan ahɔ́b ndutul enlɔ́g mɔ́ á nlém-tê, ápanléd-tɛ ábē bembapɛɛ áte aá, “Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, nyé mod nhɔ́g ǎbɛ̌ mɛ á mekáá mé bad bé ekɔyí.” ");
INSERT INTO bssNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Hɛ́ɛ ábē bembapɛɛ bénɔ́nné á mesó, áyə̄le bénkêmbííʼɛ́ mod awě áhɔ́bɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mbapɛɛ nhɔ́g, awě Yesuɛ ândəŋgé, andyɛ̌ mɔ́ á akéb. ");
INSERT INTO bssNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Dɔ́ɔ Simɔn Petro ápebtanné ane mbapɛɛ mǐd, áhɔ̄bē aá, “Sɛdéd mɔ́ mod awě áhɔ́bɛɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Dɔ́ɔ ane mbapɛɛ ásídté Yesuɛ á yə̌l-tê, ásɛdté mɔ́ aáken, “A-Sáŋ, nzɛ́ɛ́ éhɔ́bɛɛ́?” ");
INSERT INTO bssNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesuɛ ankwɛntɛ́n mɔ́ aá, “Mod awě mɛ́tɔdɛ́ɛ́ ewɛle á dǐsɛ-tê boŋ ḿbɛ mɔ́, mɔ́ adé ane mod.” Hɛ́ɛ átédé ewɛle, átɔdté á dǐsɛ-tê, ábagé Judasɛ, mwǎn awě Simɔn Iskariɔdɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Akob áde Judasɛ ákóbé échê ewɛle, Satanɛ ansɔ́l mɔ́ áte. Dɔ́ɔ Yesuɛ álâŋgɛɛ́ mɔ́ aá, “Dyam áde éhɛdɛɛ́ abɛl bɛ̌l dɔ́ á mehélé-te.” ");
INSERT INTO bssNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Boŋ mod ké nhɔ́g awě bɔ́bɔ̄ɔ bédyágéʼáá ndyééd enkênsóŋtɛ́nné chǒm-ɛ́ɛ ékə́ə́ boŋ Yesuɛ aláá Judasɛ nɛ̂. ");
INSERT INTO bssNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ngáne édíí bán Judasɛ mɔ̂ akǒŋgéʼáá ekwɛ é mɔné, doŋge á bembapɛɛ bénwēmtɛ̄n bán Yesuɛ alâŋge mɔ́ aá ákɛ áchan bwěm ábe bɛ́bɛnlédté á ngande, kéʼɛ chǒm éche bɛ́bɛɛ́ betóótōkɛ̄ bé bad. ");
INSERT INTO bssNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Áde Judasɛ ákóbé ewɛle éche Yesuɛ ábágé mɔ́ kobɛ́n, ambíd ebwɔ́g. Ehíntɛ́n ênkwɛ̌. ");
INSERT INTO bssNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Áde Judasɛ ámáá abíd dɔ́ɔ Yesuɛ áhɔ́bɛɛ́ aá, “Bɔɔb-pɔɔ́ ehúmé e Mwǎn-a-Moonyoŋ ényínnédé. Ehúmé é Dyǒb-pɛ ámpē ényīnnēd mbwiined ne mwǎn. ");
INSERT INTO bssNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nzé Dyǒb ákúdé ehúmé ámbīd e Mwǎn, né Dyǒb děn ámpē dɛ́bɛ̌l ehúmé é Mwǎn ényînned. Ǎbɛ̌l-lɛ nɛ̂ ábwɔ̄g-ábwɔ̄g. ");
INSERT INTO bssNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","A-baányaŋ, echem póndé âbɛ́ ne nyé, edé esóŋ. Nyɛ́ɛ̄hɛ̌d mɛ, boŋ ngáne ménlāāʼɛ́ bad bé Israɛl, melemlem nɛ̂ dɔ́ɔ ńlâŋgɛɛ́ nyé bɔɔb, mɛɛ́, ‘Wɛ́ɛ ńkagké, nyéehɛnlé apɛ áhed.’ ");
INSERT INTO bssNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mbage nyé mbéndé ekɔ́ɔ́lé bɔɔb, nɛ́n nyédəŋ nhɔ́g ne aníníí. Ngáne ńdə́ə́ nyé, nyémpē nyédəŋ nhɔ́g ne aníníí. ");
INSERT INTO bssNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nzé nyêdəə́ nhɔ́g ne aníníí, né mod tɛ́ɛ́ ǎbīī aá nyêdíi ábêm bembapɛɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simɔn Petro ansɛdéd Yesuɛ aáken, “A-Sáŋ, héé éhɛdɛɛ́ akɛ?” Yesuɛ antimtɛ́n mɔ́ aá, “Weéhɛ̄lɛ̄ɛ̄-sɛ ehíd mɛ bɔɔb wɛ́ɛ ńkagké, boŋ ámbīd e póndé wɛ̌hīd mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petro ansɛdéd mɔ́ aá, “A-Sáŋ, cheé ékə́ə́ boŋ meéhɛ̄lē se nhíd wɛ bɔɔb? Mbǒŋsɛ́né âwɛ́ á nló ḿmôŋ.” ");
INSERT INTO bssNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Hɛ́ɛ Yesuɛ ákwɛntanné mɔ́ aá, “Ekoó aboŋsɛn dé awɛ́ á nló ḿmêm-ɛ? Ne mbále, nlâŋge wɛ mɛɛ́, nchóm-a-kúb adɛ̂hɔ́b aá mɔ́tōoʼ, wɛ̌bāŋ mɛ á yə̌l ngen éláán.” ");
INSERT INTO bssNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Dɔ́ɔ Yesuɛ ábádɛɛ́ ábē bembapɛɛ aláa aá, “Nyéētagté nlém á abum. Nyésum nlém wɛ́ɛ Dyǒb, nyésum-mɛ kə́ə́ŋne áwêm. ");
INSERT INTO bssNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Toŋ ébúú áte á ndáb echě echem Sáŋ. Nkag-kɛ áwed âboŋsɛn nyé hǒm. Nzé énkêmbɛ́ nɛ̂, né menkênlááʼɛ́ nyé mɛɛ́ nkag nyé hǒm aboŋsɛn. ");
INSERT INTO bssNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nzé nkií-ʼɛ nyé hǒm aboŋsɛn, mɛ̌tǐm ámbīd, ńhyɛ ntéd nyé âbɛ́ ne mɛ, âbɛl nyémpē nyébɛ̂ hǒm áde ńdíí. ");
INSERT INTO bssNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nyêbíí nzii echě etimeʼ wɛ́ɛ ńkagké.” ");
INSERT INTO bssNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Hɛ́ɛ Tɔmasɛ álâŋgɛɛ́ mɔ́ aá, “A-Sáŋ, séebíiʼɛ́ wɛ́ɛ ékagké. Chán-nɔ̄ sɛ́bwɛɛ́ nzii abíi echě etime áwed?” ");
INSERT INTO bssNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesuɛ ankwɛntɛ́n mɔ́ aá, “Mɛ́ɛ ndé nzii eché ekag wɛ́ɛ echem Sáŋ, mbále ehúɛʼ ne mɛ, mɛ-ʼaá mbage aloŋgé. Modmod eéhɛ̄lɛ̄ɛ̄-sɛ ápɛ wɛ́ɛ echem Sáŋ, ésebán abwedé áwêm.” ");
INSERT INTO bssNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Hɛ́ɛ Yesuɛ álâŋgɛɛ́ ábē bembapɛɛ aá, “Bɔɔb áde nyébíí mɛ, nyɛ́ɛ̄bīī kə́ə́ŋne echem Sáŋ. Bootya bɔɔb nyênyíné mɔ́, nyêbíí-ʼɛ mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filibɛ anláá mɔ́ aá, “A-Sáŋ, lúméd-tɛ sé Titɛ́ɛ. Chǒm ésyə̄ə̄l éche séhɛdɛɛ́ éetómɛɛ́ nɛ̂.” ");
INSERT INTO bssNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesuɛ ankwɛntɛ́n aá, “A-Filib, nkémbɛ̄ ne nyé á etûn é póndé, chán-nɔ̄ éhɛlɛɛ́-sɛ ehɔ́b wɛɛ́ mɔ̂bííʼɛ́ mɛ? Kénzɛ́ɛ́ awě anyíné mɛ né anyíné Titɛ́ɛ. Chán-nɔ̄ éhɛlɛɛ́-sɛ ehɔ́b wɛɛ́ ‘Lúméd sé Titɛ́ɛ?’ ");
INSERT INTO bssNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Weedúbpɛɛ́ wɛɛ́ echem Sáŋ adíī mɛ áte, mɛ-ʼɛ mbɛ́ mɔ́ áte-yɛ?” Hɛ́ɛ Yesuɛ álâŋgɛɛ́ ábē bembapɛɛ aá, “Mam ḿme ńlâŋgɛɛ́ nyé méebídɛɛ́ áwêm děn. Boŋ echem Sáŋ awě adé mɛ áte mɔ̂ abɛle ḿmê nsɔ́n. ");
INSERT INTO bssNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nyédúbe mɛ ngáne ńhɔ́bé mɛɛ́ echem Sáŋ adíi mɛ áte, mɛ-ʼɛ mbɛ́ mɔ́ áte. Nzé nyéedúbpe nɛ̂, nyêdúbé ké áyə̄le mam mé menyáké ḿme ḿbɛlɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, kénzɛ́ɛ́ awě adúbpé mɛ, ǎbɛ̌l mam ḿmě ḿbɛlɛɛ́. Ǎbɛ̌l-lɛ kə́ə́ŋne mekan ḿme métómé ḿmɛ́n áyə̄le nkag wɛ́ɛ Titɛ́ɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Mɛ̌bɛ̌l-lɛ kéchéé éche nyésɛ́dté á dǐn ádêm âbɛl nɛ́n ngum echě Titɛ́ɛ ényînned ámbīd e Mwǎn. ");
INSERT INTO bssNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nzé nyêsɛdté mɛ kéchéé á dǐn ádêm, mɛ̌bɛl chɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesuɛ ambád ahɔ́b aá, “Nzé nyêdəə́ mɛ, né nyɛ́ɛ̄hīd échem mbéndé. ");
INSERT INTO bssNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Mɛ̌lāā Titɛ́ɛ, ǎbɛ̌-ʼɛ nyé Nwôŋgɛne ampée, awě ǎbɛ̄ ne nyé á ngíndé ne á ngíndé. ");
INSERT INTO bssNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ane Nwôŋgɛne mɔ̂ adé Edəə́dəŋ échě ébídteʼ mbále áwed tə̂ŋgɛne Dyǒb. Bad bé nkǒŋsé béehɛlɛ́ɛ́-sɛ békob mɔ́, áyə̄le béēnyīnɛ̄ɛ̄ mɔ́, béēbíi-ʼaá mɔ́. Boŋ nyêbíí mɔ́ áyə̄le adé ne nyé, ǎbɛ̄-ʼɛ nyé áte. ");
INSERT INTO bssNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nzé nkií, méetɛdɛ́ɛ́ nyé menyuu. Mɛ̌tǐm ámbīd áwɛ̄n. ");
INSERT INTO bssNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mwǎmpīn ḿ póndé, nkǒŋsé méenyínné mɛ ámpē. Boŋ nyépɛn nyɛ́ɛ̄nyīn mɛ. Ngáne mɛ́bɛ̄ɛ̄ á aloŋgé, nyémpē nyɛ́ɛ̄bɛ̄. ");
INSERT INTO bssNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nzé échê epun épédé, nyɛ́ɛ̄bīī bán ndé echem Sáŋ áte, nyé-ʼɛ nyêbɛ́ mɛ áte, melemlem ngáne mɛ-ʼɛ ńdíí nyé áte. ");
INSERT INTO bssNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kénzɛ́ɛ́ awě akobé échem mbéndé, áhīdē-ʼɛ chɔ́, mɔ̂ adé mod awě adəə́ mɛ. Kénzɛ́ɛ́ awě adəə́-ʼɛ mɛ, echem Sáŋ mɔ́-ʼɛ ǎdəŋ mɔ́. Mɛ́mpē mɛ̌dəŋ mɔ́ nlúméd-tɛ mɔ́ yə̌l.” ");
INSERT INTO bssNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Dɔ́ɔ Judasɛ (saké Judas Iskariɔdɛ) áhɔ́bɛɛ́ aá, “Boŋ A-Sáŋ, chán wɛ́lūmēdtē sé yə̌l boŋ weelúmté nkǒŋsé pɛn?” ");
INSERT INTO bssNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesuɛ ankwɛntɛ́n aá, “Nzé mod adəə́ mɛ, ǎhīd ábêm eʼyale. Echem Sáŋ ǎdəŋ mɔ́, sé echem Sáŋ-ʼɛ sɛ́ɛ̄pɛ̌ áwē, sédyɛ̄ɛ̄-ʼɛ ne mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nzé mod eédəə mɛ, eehídɛ́ɛ́ ádêm ayə́ge. Ádɛ́n ayə́ge áde nyéwógé déesaá ádêm. Ádíi áde Titɛ́ɛ awě alómé mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nláŋgé nyé ḿmɛ́n mésyə̄ə̄l áde ńdíí ndé ne nyé. ");
INSERT INTO bssNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nwôŋgɛne, Edəə́dəŋ éche Ésáá awě Titɛ́ɛ álōmmē á dǐn ádêm, ǎyə̄gēd nyé mekan mésyə̄ə̄l ǎbɛ̌l-lɛ nyékamtán mekan mésyə̄ə̄l ḿme ńláŋgé nyé. ");
INSERT INTO bssNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nsaŋ mɔ́ɔ ńlyə́gnédé nyé. Ḿmêm nsaŋ mɔ́ɔ ḿbagɛɛ́ nyé. Meébāgɛ̄ɛ̄ nyé mɔ́ ngáne nkǒŋsé ḿbagɛɛ́. Nyéētagté nlém á abum, nyéewógé mbwɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nyênwóg nɛ́ɛ ńhɔ́bé mɛɛ́ ‘Mɛ̌tɛdé nyé boŋ mɛ̌tǐm ámbīd áwɛ̄n.’ Nzé nyêndə̌ŋ mɛ né nyɛ́ɛ̄wóg menyiŋge bán nkag wɛ́ɛ Titɛ́ɛ áyə̄le Titɛ́ɛ atómé mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nláŋgé nyé nɛ́n bɔɔb áde éēbɛ̄nlēdɛ̄ɛ̄, âbɛl nɛ́n nzé ébɛ́nlédé, nyédúbe. ");
INSERT INTO bssNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Syánē déebudté póndé awóŋ âkal ámpē, áyə̄le nkamlɛnɛ a nkǒŋsé ahúɛʼ. Eewóoʼɛ́ ngíne ké pɔ́g ámīn echêm. ");
INSERT INTO bssNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Boŋ kénɛ̂ mɛ̌chennéd mɔ́ yə̌l ḿbɛ̄l ngáne echem Sáŋ áhɔ́bé aá ḿbɛl, âbɛl boŋ nkǒŋsé ḿbíi nɛ́n bán, ndəə́ echem Sáŋ. Né-ʼaá ákə́ə́ boŋ ḿbɛlé kéchéé éche áhɔ́bé aá ḿbɛl. “Nyéhyag syánē déhide hɛ́n. ");
INSERT INTO bssNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Mɛ-ɛɛ́ ndé alín dé epum é bwɛl, alín dé epum é bwɛl děn děn. Echem Sáŋ-ʼɛ abɛ́ mbɛlé-nzag. ");
INSERT INTO bssNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ahúdeʼ ngɛn ké ehéé echě edé mɛ á yə̌l, echě eechyááʼ eʼpum, ápagké-ʼɛ ké ehéé echě echyáaʼ eʼpum, âbɛl boŋ éboŋ yə̌l ébude-ʼɛ achyáa. ");
INSERT INTO bssNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ayə́ge áde ń'yə́gté nyé ábɛ́lé nyêmaá asáŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nyélyəg nyébɛ̂ ne mɛ, mɛ́mpē mɛ̌lyə̌g mbɛ́ ne nyé. Ngɛn chěn eéhɛ̄lɛ̄ɛ̄-sɛ echyáá eʼpum áde éesaá á alín á bwɛl. Melemlem nɛ́ɛ nyémpē nyéehɛlɛ́ɛ́-sɛ nyêchyáá eʼpum ésebán nyêdé ne mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Mɛ-ɛɛ́ ndé alín dé epum é bwɛl, nyé-ʼɛ nyêbɛ́ ngɛn. Nzé mod adíí adé ne mɛ boŋ mɛ-ʼɛ ndé ne mɔ́ ǎchyāā eʼpum bwâmbwam. Nyéēhɛ̄lɛ̄ɛ̄-sɛ nyébɛ̄l dyamdyam ésebɛ́ ne mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nzé mod eésɛ̄ ne mɛ, bɛ́hūd mɔ́ nɛ́ɛ ngɛn. Ene ngɛn ebɛlé ekíntéd. Béladɛɛ́ échê ndín é ngɛn áte, bébwém chɔ́ á muú-te, éhyáŋ-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nzé nyêdíi nyêdé ne mɛ, boŋ ádêm ayə́ge-ʼɛ ádíi ádé nyé áte, kéchéé éche nyésɛ́dté, nyɛ́ɛ̄kǔd. ");
INSERT INTO bssNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Edúbé éche echem Sáŋ ényînnad nzé nyêbudé eʼpum achyáa, nɛ̂-ʼaá dɛ́bɛ̌l nyêbɛ́ ábêm bembapɛɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ngáne echem Sáŋ ádə́ə́ mɛ, melemlem nɛ́ɛ mɛ́mpē ńdə́ə́ nyé. Né-ɔɔ́ nyédíi nyébɛ̂ ne mɛ âbɛl boŋ ḿbɛ̂ ńdəŋ nyé. ");
INSERT INTO bssNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nzé nyêhídé échêm mbéndé, né mɛ̌bɛ̄ ńdəŋ nyé. Melemlem nɛ̂ dɔ́ɔ ńhídɛɛ́ mbéndé échě echem Sáŋ, adíi adəə́-ʼɛ mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nlâŋge nyé ḿmɛ́n mésyə̄ə̄l âbɛl nɛ́n nyémpē nyéwôg nyaa e menyiŋge echě ńwogɛɛ́, ḿmɛ̄n menyiŋge mélôn-nɛ mbon. ");
INSERT INTO bssNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Echem mbéndé edíi nɛ́n, nyédəŋ nhɔ́g ne aníníí melemlem nɛ̂ŋgáne ńdə́ə́ nyé. ");
INSERT INTO bssNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nzé mod awédé á nló ḿ baáb, né alúmté edəŋge éche étómtɛ́né achab ámīn. ");
INSERT INTO bssNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nzé nyêbɛleʼ mekan ḿme ńláŋgé nyé mɛɛ́ nyébɛl né nyêdíi ábêm besón. ");
INSERT INTO bssNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Meéchə̄gɛ̄ɛ̄ nyé bembəledɛ ámpē, áyə̄le bembəledɛ béēbyɛ̄ɛ̄ʼɛ́ mam ḿme echab sáŋ ábɛlɛɛ́. Boŋ ńchəgɛɛ́ nyé mɛɛ́ ábêm besón áyə̄le nláŋgé nyé mam mésyə̄ə̄l ḿme echem Sáŋ áláŋgé mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nyéēpwɛdɛɛ́ mɛ, boŋ mɛ-ɛɛ́ mpwɛdé nyé, nlóm-mɛ nyé âbɛl mekan ḿme méchyáa eʼpum éʼ bwâm. Nyaa é mekan échě ébɛ̄ abɛ́ ne abɛ́. Nzé nyêbɛlé-ʼɛ nɛ̂, echem Sáŋ ǎbɛ̌ nyé kéchéé éche nyésɛ́dté á dǐn ádêm. ");
INSERT INTO bssNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ḿmɛ́n mam mésyə̄ə̄l ḿme ńlâŋgɛɛ́ nyé-ɔɔ́, médíi nɛ́n mɛɛ́, nyédəŋ nhɔ́g ne aníníí.” ");
INSERT INTO bssNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesuɛ ambád ábē bembapɛɛ aláa aá, “Nzé nkǒŋsé ńkɔ́ɔ́ nyé, nyébíi nɛ́n bán mɛɛ́ bésébpé akɔɔ. ");
INSERT INTO bssNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nzé nyêmbɛ́ nɛ̂ŋgáne bad bé nkǒŋsé, né nkǒŋsé mɛ́tēd nyé nɛ̂ŋgáne ábē bad. Boŋ mpwɛdé nyé átîntê e bad bé nkǒŋsé. Nyéēsaá bad bé nkǒŋsé. Né-ʼaá ákə́ə́ boŋ nkǒŋsé ńkɔ̄ɔ̄ nyé. ");
INSERT INTO bssNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nyéwêmtɛn ehɔ́b éche ménlāāʼɛ́ nyé mɛɛ́ ‘Mbəledɛ eetómɛ́ɛ́ eche sáŋ.’ Nzé bêmbané mɛ á metake-tê né bɛ́bané nyémpē á metake-tê. Nzé bénhīd ádêm ayə́ge né bɛ́hīd-tɛ ádɛ̄n ámpē. ");
INSERT INTO bssNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Bɛ́bɛl nyé ḿmɛ́n mekan mésyə̄ə̄l á yə̌l á dǐn ádêm, áyə̄le béēbíiʼɛ́ ane awě alómé mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nzé menkêmpɛ̌ boŋ nláá bɔ́ ḿmɛ́n mam, né ḿmab mbéb méenyînnedɛɛ́. Boŋ bɔɔb, béewóoʼɛ́ nzɔm ké pɔ́g áyə̄le ḿmab mbéb. ");
INSERT INTO bssNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kénzɛ́ɛ́ awě akɔɔ́ mɛ, akɔɔ́ kə́ə́ŋne echem Sáŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nzé menkêmbɛl ndín é mam átîntê echâb éche mod ampée éēbɛ̄lɛ̄ɛ̄ mbêd, né ḿmab mbéb méenyînnedɛɛ́. Boŋ bɔɔb bényíné mekan mésyə̄ə̄l ḿme ḿbɛ́lé, ké nɛ̂ bédíi békɔ́ɔ́ mɛ, békɔ̄ɔ̄-ʼɛ echem Sáŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nɛ́n ádé âlóned eʼyale ábe éʼténlédé á mbéndé echâb bán, ‘Nzɔm ké pɔ́g enkêmbáá eche békɔ́ɔ́né mɛ.’ ");
INSERT INTO bssNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Nwôŋgɛne ǎbīd wɛ́ɛ Titɛ́ɛ. Adíi Edəə́dəŋ éche ébɛleʼ boŋ bad bésóŋtɛ́n mbále. Ádě mɛ́bɛ̄ɛ̄ ne Titɛ́ɛ mɛ̌lōmē nyé mɔ́, mɔ́-ʼaá ǎlāā nyé mam tə̂ŋgɛne mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nyémpē nyɛ́ɛ̄hɔ̄b mam tə̂ŋgɛne mɛ áyə̄le nyêdé ne mɛ se á mbooted. ");
INSERT INTO bssNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nlâŋge nyé ḿmɛ́n mésyə̄ə̄l âbɛl boŋ nyéētimné mbíd. ");
INSERT INTO bssNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bɛ́bīdēd nyé á ndáb é mekáne. A mbále póndé ehúɛʼ eche kénzɛ́ɛ́ awě ǎwūū nyé áwēmtɛ̄nnē aá mɔ́bɛnle Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bɛ́bɛ̌l ḿmɛ́n mam áyə̄le béēbíiʼɛ́ echem Sáŋ béēbíi-ʼaá mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nláŋgé nyé ḿmɛ́n mam mésyə̄ə̄l âbɛl boŋ nzé póndé epedé echě ḿmɛ́n mekan mébɛnladté, nyɛ́ɛ̄kamtɛ́n bán menlááʼ nyé. “Menkênlááʼɛ́ nyé ḿmɛ́n mekan á mbooted, áyə̄le membɛ́ ne nyé. ");
INSERT INTO bssNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Boŋ bɔɔb, nkag wɛ́ɛ mod awě alómé mɛ. Ké nɛ̂, nyé modmod nyéesɛdtɛɛ́ mɛ bánken ‘Héé ékagké?’ ");
INSERT INTO bssNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Aláa ádé ńláŋgé nyé ḿmɛ́n mekan ábɛ́lé ndutul elɔ́gé nyé á nlém-tê. ");
INSERT INTO bssNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ne mbále, nlâŋge nyé nɛ́n mɛɛ́, édé mboŋ nɛ́n bán ńkɛ. Áyə̄le nzé meékii, né Nwôŋgɛne éepaá áwɛ̄n. Boŋ nzé nkií, mɛ̌lōmē nyé mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Áde ápɛɛ́, álūmēd bad bé nkǒŋsé nɛ́n aá ḿmab nsôŋtɛn ḿme béwánlé tə̂ŋgɛne abɛl dé mbéb ne âbɛl mekan ḿme mésáá méetə̂ŋgɛnɛɛ́. Béēsôŋtɛnɛɛ́-ʼɛ nyaa echě Dyǒb ákáadtɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ḿmab nsôŋtɛn méetə̂ŋgɛnɛɛ́ tə̂ŋgɛne mbéb, áyə̄le béedúbpɛɛ́ mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Méetə̂ŋgɛnɛɛ́ tə̂ŋgɛne abɛl dé mekan ḿme mésáá, áyə̄le nkag wɛ́ɛ Titɛ́ɛ, nyéenyín-naá mɛ ámpē. ");
INSERT INTO bssNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Méetə̂ŋgɛnɛɛ́ tə̂ŋgɛne nyaa echě Dyǒb ákáadtɛɛ́, áyə̄le amaá nkamlɛnɛ a nkǒŋsé akáad. ");
INSERT INTO bssNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ndíi nwóó ekud é mekan âláa nyé boŋ ḿmê mekan mɛ́tom nyé áte. ");
INSERT INTO bssNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Boŋ áde Edəə́dəŋ é mbále épɛɛ́, ǎbɛ̌l nyêbíí mbále esyəə́l. Éehɔ́bénné echě kunze chěn. Dyam áde bɛ́lāāʼɛ́ mɔ́ dɔ́ɔ áhɔ̄bpē, ǎlāā-ʼɛ nyé mam ḿme mɛ́bɛnléd póndé echě ehúɛʼ áʼsō. ");
INSERT INTO bssNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ǎchə̄gēd échêm edúbé ámīn áyə̄le kéchéé éche áwógé áwêm chɔ́ɔ mɔ́-ʼɛ álāāʼɛ́ nyé. ");
INSERT INTO bssNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kéchéé éche echem Sáŋ áwóó édíi échêm. Nɛ̂ dɔ́ɔ ákə́ə́ boŋ ńhɔ̄bē mɛɛ́ Edəə́dəŋ étēd kéchéé éche ńhɔ́bé, éláá nyé.” ");
INSERT INTO bssNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Hɛ́ɛ Yesuɛ ábádɛɛ́ aá, “Mwǎmpīn ḿ póndé nyéenyínné mɛ ámpē, mwǎmpīn ḿ póndé-ʼɛ ámbīd enɛ̂ nyɛ́ɛ̄nyīn mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Dɔ́ɔ doŋge dé bembapɛɛ bésɛdtɛɛ́ nhɔ́g ne aníníí bánken, “Cheé áwémtɛ́né ahɔ́b, âláa syánē aá, ‘Mwǎmpīn ḿ póndé nyéenyínné mɛ ámpē, mwǎmpīn ḿ póndé-ʼɛ ámbīd e nɛ̂ nyɛ́ɛ̄nyīn mɛ?’ Ahɔ́b-pɛ ámpē aá, ‘Áyə̄le nkag wɛ́ɛ Titɛ́ɛ.’ ” ");
INSERT INTO bssNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Bémbɛ̄ bésɛdté bánken, “Cheé áwémtɛ́né ahɔ́b, âhɔ́b aá, ‘Mwǎmpīn ḿ póndé?’ Séesôŋtɛnɛɛ́ dyam áde áhɔ́bɛɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesuɛ ammǎd abíi aá, béhɛde mɔ́ dyam asɛded. Né-ɔɔ́, anláá bɔ́ aá, “Dyam áde ńhɔ́bé mɛɛ́, ‘Mwǎmpīn ḿ póndé nyéenyínné mɛ ámpē, mwǎmpīn ḿ póndé-ʼɛ ámbīd e nɛ̂, nyɛ́ɛ̄nyīn mɛ,’ dɔ́ɔ nyésɛdtɛɛ́ nhɔ́g ne aníníí-yɛ? ");
INSERT INTO bssNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ne mbále, nlâŋge nyé mɛɛ́, nyɛ́ɛ̄chií, nyélēb-pɛ, boŋ nkǒŋsé mɛ́wōg menyiŋge. Nyɛ́ɛ̄sudɛ́n, boŋ ḿmê nsudɛn mɛ́tǐm menyiŋge. ");
INSERT INTO bssNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mmwaád awě ahɛde achyáá abɛlé ásudɛn áyə̄le eche póndé e metake epedé. Boŋ nzé amaá achyáa abɛlé awóg menyiŋge, áyə̄le moonyoŋ achyáádté á nkǒŋsé. ");
INSERT INTO bssNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nɛ̂ dɔ́ɔ édíí ne nyé. Nyêsǔdné bɔɔb, boŋ mɛ̌nyīn nyémpē. Ene póndé ḿmɛn nlém mɛ́lōn ne menyiŋge, modmod éehɛnlé-ʼaá nyé ḿmê menyiŋge akobɛn. ");
INSERT INTO bssNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Áde échê epun épɛɛ́, nyéesɛdédté mɛ dyamdyam. Ne mbále, nlâŋge nyé nɛ́n mɛɛ́ Titɛ́ɛ ǎbɛ̌ nyé kéchéé échě nyésɛ́dté á dǐn ádêm. ");
INSERT INTO bssNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kə́ə́ŋne bɔɔb nyéēhɛ̄dnɛ̄ɛ̄ mɔ́ chǒmchǒm á dǐn ádêm. Nyéhɛdɛn mɔ́, nyɛ́ɛ̄kǔd âbɛl nɛ́n ḿmɛ̄n menyiŋge mélɔ̂g mbon.” ");
INSERT INTO bssNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yesuɛ ambád ábē bembapɛɛ aláa aá, “Mbɛ̌nlédé ngan âláa nyé ekud é mekan. Póndé ehúɛʼ echě méebɛnlédté ngan. Mɛ́lāā-ʼɛ nyé mekan tə̂ŋgɛne Titɛ́ɛ, nyaa echě nyɛ́sōŋtɛ̄nnē. ");
INSERT INTO bssNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Échê epun, nyɛ́ɛ̄hɛdɛ́n mɔ́ kéchéé á dǐn ádêm. Méetɔgɛ́n-naá mɔ́ aláa mɛɛ́ áwôŋgɛn nyé, ");
INSERT INTO bssNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","áyə̄le Titɛ́ɛ mwěn adəə́ nyé. Adəə́ nyé áyə̄le nyêdəə́ mɛ, nyêdúbpé-ʼɛ bán mbídé áwē. ");
INSERT INTO bssNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Membíd wɛ́ɛ Titɛ́ɛ, ḿpɛ̄ á nkǒŋsé-te, bɔɔb-pɛ ntɛdte nkǒŋsé, ntime ámbīd wɛ́ɛ Titɛ́ɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Hɛ́ɛ ábē bembapɛɛ béhɔ́bɛɛ́ bán, “Ehɔ́be bɔɔb ngáne sɛ́sōŋtɛ̄nnē, weébɛnládté ngan. ");
INSERT INTO bssNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sêbíí bɔɔb bán ebíí mekan mésyə̄ə̄l, éehɛdnád-taá bán modmod ásɛded wɛ dyamdyam. Nɛ́n ábɛ́lé sêdúbpé bán ebídé wɛ́ɛ Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Dɔ́ɔ Yesuɛ ákwɛntanné bɔ́ aá, “Nyêdúbpé bɔɔb-ɛ? ");
INSERT INTO bssNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nyénɔneʼ! Póndé ehúɛʼ, emaá-ʼɛ apɛ, áde nyɛ́pāŋtēdtē áte. Mod tɛ́ɛ́ atóm mehélé wɛ́ɛ ábídé, nyétɛ̄dē mměmpɛn. Boŋ ké nɛ̂, meésaá mměmpɛn, Titɛ́ɛ adé ne mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nlâŋge nyé ḿmɛ́n mekan âbɛl nɛ́n nyébɛ̂ nsaŋ abɛ́ ádě nyédíí ne mɛ. Nyɛ́ɛ̄kǔd metake á nkǒŋsé-te boŋ nyéwêd nlém á abum. Ntómé nkǒŋsé áte.” ");
INSERT INTO bssNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Áde Yesuɛ ámáá ḿmɛ́n mekan mésyə̄ə̄l ahɔ́b, dɔ́ɔ ánɔ́né ámīn boŋ áhɔ̄bē aá, “A-Tɛ̂, póndé emaá apɛ. Lúméd bad ehúmé échě awoŋ Mwǎn, âbɛl nɛ́n awoŋ Mwǎn mɔ́mpē álúmed ehúmé échôŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ebágé mɔ́ kunze âkamlɛn moosyəə́l, âbɛl nɛ́n ábɛ bad bésyə̄ə̄l ábe ébágé mɔ́ aloŋgé áde déemaáʼ. ");
INSERT INTO bssNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Aloŋgé áde déemaáʼ ádíi nɛ́n bébíi wɛ, mmǒn awě edé Dyǒb á mbále, ne âbíi Yesu Krǐstəə, awě élómé. ");
INSERT INTO bssNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mbídté échoŋ ehúmé áwed á nkǒŋsé amad ádé ḿmádé nsɔ́n ḿme ébágé mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Bɔɔb-pɔɔ́ a-Sáŋ, bídéd échêm ehúmé áwed, wɛ́ɛ mmǒŋ édíí. Melemlem mé edúbé ḿme ménwōŋgē ne wɛ, nkǒŋsé ńdé ahɔ́b bán ḿbootad. ");
INSERT INTO bssNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Mbɛlé bad bé nkǒŋsé ábe ébágé mɛ bébíí wɛ. Bébédɛ́ɛ ábôŋ, wembɛ̌ mɛ bɔ́, bébɛ́lé-ʼɛ ngáne ehɔ́bé wɛɛ́ bébɛl. ");
INSERT INTO bssNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Bébíí bɔɔb bán kéchéé éche ébágé mɛ, ébídé áwôŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nláŋgé bɔ́ mam mésyə̄ə̄l ḿme éláŋgé mɛ wɛɛ́ ńláa bɔ́, bédúbpé-ʼɛ ḿmê mam. Bébíí ne mbále bán áwôŋ dɔ́ɔ ḿbídé, bédúbpé-ʼɛ bán wɛ-ɛɛ́ elómé mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nkânnad bɔ́. Meekánnádté bad bé nkǒŋsé. Boŋ nkânnad bad ábe ébágé mɛ, áyə̄le bédíi ábôŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Bad bésyə̄ə̄l ábe bédé ábêm bédíi ábôŋ, ábôŋ-ʼɛ bésyə̄ə̄l bédíi ábêm, bébídté-ʼɛ échêm ehúmé áwed. ");
INSERT INTO bssNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Bɔɔb-pɔɔ́, mwǎmpīn ḿ póndé méebáá á nkǒŋsé-te ámpē. Boŋ bédíi bédé á nkǒŋsé-te. Nhyag áwôŋ. Titɛ́ɛ awě Asáá, kəə́ bɔ́ á ngíne e dǐn ádôŋ, dǐn áde ébágé mé. Ngíne echě ébágé mɛ âbɛl nɛ́n bébɛ̂ mod nhɔ́g, melemlem ngáne sóo-ʼɛ ámpē dédíí mod nhɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Áde ḿbédé ne bɔ́, menkəə́ bɔ́ á ngíne e dǐn ádôŋ, dǐn áde wêmbɛɛ́ mɛ. Nkə̌ŋgé bɔ́, bɔ́ mod ké nhɔ́g-kɛ eebɔ́ɔʼɛ́ étōmɛɛ́ mod awě êmmadté abɛ́ bán ǎbɔ̄ɔ âbɛl boŋ ébɛnled ngáne éténlédé á kálag e Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Bɔɔb-pɔɔ́, nhyag áwôŋ. Nhɔ́be-ʼɛ ḿmɛ́n mekan ngáne ndíi ńdé á nkǒŋsé âbɛl boŋ ḿmāb menyiŋge mélôn mbon, melemlem ngáne ḿmêm-mɛ mélóné mbon. ");
INSERT INTO bssNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nláŋgé bɔ́ mam mésyə̄ə̄l ḿme éláŋgé mɛ wɛɛ́ ńláa bɔ́. Bɔɔb-pɔɔ́ bad bé nkǒŋsé békɔ́ɔ́ bɔ́ áyə̄le béesaá bad bé nkǒŋsé ámpē, melemlem ngáne mɛ ámpē méesaá mod a nkǒŋsé. ");
INSERT INTO bssNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Meehɔ́bɛ́ɛ́ mɛɛ́ éhûd bɔ́ á nkǒŋsé-te, boŋ nhɔ́beʼ mɛɛ́ ékəəʼ bɔ́ âbɛl boŋ Mod e Ebébtéd eébɛ̄lēʼ bɔ́ mbéb. ");
INSERT INTO bssNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Béesaá bad bé nkǒŋsé melemlem nɛ̂ŋgáne méesaá mod a nkǒŋsé. ");
INSERT INTO bssNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Bɛnléd echoŋ mbále âbɛl boŋ béhɛl wɛ abɛle. Échôŋ eyale édé mbále. ");
INSERT INTO bssNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nlómé bɔ́ á nkǒŋsé-te melemlem nɛ̂ŋgáne wɛ́mpē wénlōmmē mɛ á nkǒŋsé-te. ");
INSERT INTO bssNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Á etútú échâb membɛ̌ echem yə̌l âbɛle wɛ âbɛl boŋ bɔ́mpē bébɛ échab yə̌l âbɛl boŋ békoŋ wɛ abɛle. ");
INSERT INTO bssNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Meekánnádté ábêm bembapɛɛ běnpɛn boŋ nkânnad kə́ə́ŋne bad ábe bédúbpé mɛ áyə̄le mam ḿme béwógé áwāb. ");
INSERT INTO bssNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nkânneʼ mɛɛ́ bɔ́ moosyəə́l bébɛ̂ mod nhɔ́g. A-Tɛ̂, bɔ́ moosyəə́l bébɛ̂ mod nhɔ́g ne sóo, melemlem nɛ̂ŋgáne édíí ne mɛ, mɛ-ʼɛ mbɛ́ ne wɛ. Bébɛ̂ mod nhɔ́g âbɛl nɛ́n nkǒŋsé ńdúbe bán wɛ-ɛɛ́ elómé mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ehúmé éche ébágé mɛ, mɛ-ʼɛ mbagé bɔ́. Mbagé bɔ́ âbɛl boŋ bébɛ̂ mod nhɔ́g melemlem nɛ̂ŋgáne sóo dédíí mod nhɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ńdé mod nhɔ́g ne bɔ́, wɛ-ʼɛ edé mod nhɔ́g ne mɛ. Nɛ́n dɛ́bɛ̌l békōŋ mod nhɔ́g abɛ́. Békoŋ mod nhɔ́g abɛ́ âbɛl boŋ nkǒŋsé ḿbíi bán wɛ-ɛɛ́ elómé mɛ, bébíi-ʼɛ bán edəə́ bɔ́ melemlem nɛ̂ŋgáne édə́ə́ mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","A-Tɛ̂, ebagé mɛ bɔ́, bébɛ̂ wɛ́ɛ ńdíí, âbɛl boŋ bényîn echêm ehúmé. Wembɛ̌ mɛ ehúmé áyə̄le wendə̌ŋ mɛ se á mbooted mé nkǒŋsé. ");
INSERT INTO bssNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","A-Tɛ̂, wɛ-ɛɛ́ ebɛle mam ḿmě mésáá. Nkǒŋsé méebíiʼɛ́ wɛ, boŋ mbíí wɛ, ábɛ́n-nɛ ámpē bébíí bán wɛ-ɛɛ́ elómé mɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mbɛlé bébíí wɛ, mɛ̌bɛ̌l-lɛ ámpē âbɛl nɛ́n edəŋge échě édə́ə́ mɛ ébɛ̂ bɔ́ áte, mɛ-ʼɛ ámpē ḿbɛ̂ ne bɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Áde Yesuɛ amáá akáne, bɔ́ɔbɛ ábē bembapɛɛ bênhidé, béchābē mwǎ edíb a Kidrɔn ámīn. Nzag embɛ́ áhed, bénsɔ̄l áwēd-te. ");
INSERT INTO bssNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judasɛ, ntúrɛ́ awě Yesuɛ ambíí ádê abwɔ́g á hǒm, áyə̄le Yesuɛ ne ábē bembapɛɛ bêmmɛntɛ́n aladɛn áhed. ");
INSERT INTO bssNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Né-ɔɔ́, Judasɛ antómɛ́n echoŋ é sə́nze ne bembəledɛ bé Ndáb-e-Dyǒb ábe beprisɛ bémbáá ne Befarisia bénlōmmē, békɛ̄ wɛ́ɛ Yesuɛ ábédé. Ábê bad bênchǒd eʼkag, béwálé eʼtrúkáŋ ne bwěm éʼ nzum. ");
INSERT INTO bssNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesuɛ ammǎd mam mésyə̄ə̄l ḿme mɛ́bɛnléd ne mɔ́ abíi, ké nɛ̂, ambídéd yə̌l áwed, ásɛ̄dēd bɔ́ aáken, “Nzɛ́ nyéhɛdɛɛ́?” ");
INSERT INTO bssNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bênkwɛntɛ́n mɔ́ bán, “sêhɛde Yesuɛ, mod a dyad á Nazarɛt.” Yesuɛ ankwɛntɛ́n bɔ́ aá, “Mɛ-ɛɛ́ ndé mɔ́.” Judasɛ ntúrɛ́ awě Yesuɛ ambɛ́ áhed ne ábê bad. ");
INSERT INTO bssNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Áde Yesuɛ áhɔ́bé aá, “Mɛ-ɛɛ́ ndé mɔ́,” bêntimɛ́n mbíd, békwɛ̄ ásē. ");
INSERT INTO bssNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Hɛ̂ dɔ́ɔ Yesuɛ ásɛdtɛɛ́ bɔ́ ámpē aáken, “Nzɛ́ nyéhɛdɛɛ́?” Bênkwɛntɛ́n bán, “Yesuɛ a dyad á Nazarɛt.” ");
INSERT INTO bssNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Hɛ́ɛ Yesuɛ ákwɛntanné bɔ́ aá, “Nláŋgé nyé mɛɛ́, mɛ-ɛɛ́ ndé mɔ́. Né-ɔɔ́, nzé nyêhɛde mɛ, nyétɛ̄dē ábén bad ábe bédé ne mɛ, békag.” ");
INSERT INTO bssNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nɛ́n dêmbɛnléd âlóned eʼyale ábe ánhɔ̄bpē aá, “A-Sáŋ, átîntê e bad ábe wêmbɛɛ́ mɛ, meebɔ́dɛɛ́ ké nhɔ́g.” ");
INSERT INTO bssNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simɔn Petro anwálé nkwáté. Hɛ́ɛ ádólé ḿmê nkwáté boŋ átōmtēʼ, ásɛ̄lē etúu é ekáá é mbáá é mbəledɛ awě prisɛ ambáámbáa. Ane mbəledɛ abédé dǐn bán, Malkusɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesuɛ anláá Petro aá, “Timéd nkwáté á abám. Nɛ́dē, meetêŋgɛnɛɛ́ metuné ḿme echem Sáŋ átíínédé mɛ akud-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Hɛ́ɛ échê echoŋ é sə́nze ne awâb mod ambáá nchoo ne bembəledɛ bé bad bé Israɛl békóbé Yesuɛ béhaŋ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bénsēbē mɔ́ akɛɛn wɛ́ɛ Anasɛ. Anasɛ abédɛ́ɛ sáŋ-kə́lé awě Kaifasɛ awě abédé prisɛ ambáámbáa ḿmê mwɛ̌. ");
INSERT INTO bssNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaifasɛ ne, mɔ́ ambɛ̌ bad bémbáá bé Israɛl elébé aá ébóó bán mod nhɔ́g áwɛ̂ á nló ḿ bad bésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simɔn Petro ne mbapɛɛ ampée béhídéʼáá Yesuɛ. Prisɛ ambáámbáa ambíí ane mbapɛɛ, né-ɔɔ́ ane mbapɛɛ ansɔ́l eyáde éche prisɛ ambáámbáa wɛ́ɛ bénsɔ̄lɛ̄nnē Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Petro pɛn anlyə̌g á mmwɛ mé eʼkɛ́. Dɔ́ɔ ane mbapɛɛ awě prisɛ ambáámbáa ámbīīʼɛ́ átímé ámbīd á mmwɛ, ákālɛ̄n ngɔndérɛ echě enɔnéʼáá mmwɛ boŋ ásɔ̄ltē Petro á eyáde-tê. ");
INSERT INTO bssNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ene ngɔndérɛ ansɛdéd Petro aáken “Kíné wɛ́mpē weésaá mbapɛɛ nhɔ́g awě ane mod-ɛ?” Petro ankwɛntɛ́n mɔ́ aá, “Aáy, meésaá.” ");
INSERT INTO bssNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Bɔɔb-pɔɔ́, ahéb démbɛ̄. Né-ɔɔ́, bembəledɛ ábe prisɛ ambáámbáa ne bembəledɛ bé Ndáb-e-Dyǒb bênkonéd muú bétyéém áhed béwāleʼ. Petro mɔ́mpē ambɛ́ áhed, atyéém áwālē muú. ");
INSERT INTO bssNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Prisɛ ambáámbáa esɛ̌dtéʼáá Yesuɛ tə̂ŋgɛne ábē bembapɛɛ ne ádē ayə́ge. ");
INSERT INTO bssNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesuɛ ankwɛntɛ́n mɔ́ aá, “Mam mésyə̄ə̄l ḿme ńláŋgéʼáá bad nhɔ́béʼáá mɔ́ á nhɛ́né. Ayə́ged ádêm ásyə̄ə̄l-ʼɛ, ábédé á Ndáb é mekáne ne á Ndáb-e-Dyǒb wɛ́ɛ bad bé Israɛl bésyə̄ə̄l béladnɛɛ́. Meéhɔ́bɛ́ɛ́-ʼɛ dyamdyam á kun-tê. ");
INSERT INTO bssNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Cheé-ɔ̄ ésɛdtɛɛ́ mɛ ámpē. Sɛdéd bad ábe bénwōg mam ḿme ńláŋgé bɔ́. Bébíí mam ḿme ńhɔ́bé.” ");
INSERT INTO bssNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Áde Yesuɛ áhɔ́bé nɛ̂, mbəledɛ nhɔ́g ambɔ̌m mɔ́ abɛ́n ahɔ́b aá, “Chán éhɛle éhɔ̄bēʼ nɛ̂ wɛ́ɛ prisɛ ambáámbáa?” ");
INSERT INTO bssNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesuɛ antimtɛ́n mɔ́ aá, “Nzé nhɔ́bé dyam áde déetə̂ŋgɛne, ehɔ́b dɔ́ moosyəə́l áwôg. Boŋ nzé édé bán nhɔ́bé dyam áde átə́ŋgɛ́né, cheé ékə́ə́ boŋ ébɔmé mɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Dɔ́ɔ Anasɛ áhɔ́bé aá, békɛɛn Yesuɛ wɛ́ɛ Kaifasɛ, prisɛ ambáámbáa. Yesuɛ ambɛ́ abɛ́ á mehaŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Bɔɔb-pɔɔ́, Simɔn Petro ambɛ́ atyéém áhed áwālē muú. Hɛ́ɛ bad ábe bémbɛ̄ áhed bésɛdtɛɛ́ mɔ́ bán, “Kíné wɛ́mpē weésaá mbapɛɛ nhɔ́g awě ane mod-ɛ?” Petro antáŋ aá, “Aáy, meésaá.” ");
INSERT INTO bssNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mbəledɛ awě prisɛ ambáámbáa nhɔ́g, mwǎnyaŋ mɔ́ɔ Petro ánsɛ̄nlē etúu, anchə́géd ehɔ́b ámīn, aláá Petro aá, “Kíné meenyínɛɛ́ nyúmɔ̄ á nzag-tê-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petro antáŋ ámpē. Ábwɔ̄g-ábwɔ̄g, nchóm a kúb antóŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Bad bé Israɛl bênhidnéd Yesuɛ á ndáb wɛ́ɛ Kaifasɛ békɛ̄ɛ̄n mɔ́ á eyáde e nkamlɛnɛ ambáá. Nɛ́n ábédé epɔg é mbwɛmbwɛ. Běn bénkênsɔ́nlé á ndáb-te âbáŋ nɛ́n béenyínnád mbinde áʼsō éʼ Dyǒb âbɛl bédyɛ̂ Ngande e Nnyíme-ámīn. ");
INSERT INTO bssNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Né-ɔɔ́, Payledɛ nkamlɛnɛ ambáá a bad bé Roma, ambíd e ebwɔ́g ákɛ atán bɔ́, ásɛdté bɔ́ aáken, “Awusé áhéé nyéhɔ́bé bán anɛ́n mod abɛlé?” ");
INSERT INTO bssNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bênkwɛntɛ́n mɔ́ bán, “Nzé anɛ́n mod enkêmbɛ́ ebébtéd é mod, né séēbagɛɛ́ mɔ́ áwôŋ mekáá.” ");
INSERT INTO bssNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Payledɛ anláá bɔ́ aá, “Nyé běn nyétêd mɔ́, nyébɛnled mbéndé echɛ̂n nyékáad mɔ́.” Hɛ́ɛ bad bé Israɛl bélâŋgɛɛ́ mɔ́ bán, “Séewóoʼɛ́ kunze âwúu mod.” ");
INSERT INTO bssNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nɛ́n dêmbɛnléd âlóned eʼyale ábe Yesuɛ ánhɔ̄bpē âlúmed nyaa e kwééd eche áwɛ̄ɛ̄. ");
INSERT INTO bssNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Payledɛ ansɔ́l á ndáb-te ámpē, áchə̄g Yesuɛ, ásɛ̄dēd mɔ́ aá, “Wɛ-ɛɛ́ edé kə̂ŋ e bad bé Israɛl-lɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesuɛ ankwɛntɛ́n aá, “Mmǒn-ɛɛ́ ehɔ́be nɛ̂ ngé bad bémpēe bɔ́ɔ bélāŋgē wɛ mam á yə̌l echêm?” ");
INSERT INTO bssNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Payledɛ ankwɛntɛ́n aá, “Ndé mod a Israɛl-lɛ? Ábôŋ bad ne beprisɛ bémbáá bɔ́ɔ bébágé wɛ áwêm mekáá. Cheé ébɛ́lé?” ");
INSERT INTO bssNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesuɛ ankwɛntɛ́n aá, “Ḿmêm nkamlɛn méesaá á nkǒŋsé wɛ́n. Nzé ḿmêm nkamlɛn mémbɛ̄ á nkǒŋsé wɛ́n, né ábêm bembəledɛ bɛ́wǎn, âbɛl nɛ́n bad béebagé mɛ á mekáá mé bad bé Israɛl. Boŋ ḿmêm nkamlɛn méesaá mé nkǒŋsé.” ");
INSERT INTO bssNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Dɔ́ɔ Payledɛ ásɛdtɛɛ́ mɔ́ aá, “Nɛ́dē edé kə̂ŋ-ɛ?” Yesuɛ ankwɛntɛ́n aá, “Wɛ-ɛɛ́ ehɔ́bé wɛɛ́ ndé kə̂ŋ. Nzɔm echě ekəə́ boŋ béchyáá mɛ, ḿpɛ̄ á nkǒŋsé wɛ́n, edíi âbíd mbóŋ e mbále. Mod ké ahéé awě adé mod a mbále awóglan mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Payledɛ ansɛdéd mɔ́ aá, “Cheé édé mbále?” Áde Payledɛ amáá mɔ́ asɛded nɛ́n, ambíd á ebwɔ́g ámpē akɛ atán bad bé Israɛl, anláá bɔ́ aá, “Meekóbnɛɛ́ anɛ́n mod awusé ké ahɔ́g áde mɛ́hɔ̄bpē mɛɛ́ béwúu mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Boŋ nyêwóó elem nɛ́n bán, ntə́ŋgɛ́né nyé mod a mbwɔg nhɔ́g abídted á póndé e Ngande e Nnyíme-ámīn. Nyêdəə́ bán ḿbídted nyé kə̂ŋ e bad bé Israɛl-lɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Bênkwɛntɛ́n mɔ́ ne eʼsaád bán, “Aáy! Séēhɛ̄dɛ̄ɛ̄ mɔ́. Bídtéd sé Barabasɛ.” (Barabasɛ abédé-ʼɛ nchîb ambáá.) ");
INSERT INTO bssNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Dɔ́ɔ Payledɛ áhɔ́bé aá békɛ bébɔm Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sə́nze éntēd ngɛn é mechə̌ bélóŋ ekóté éche émbɛ̄ nɛ́ɛ ekóté é kə̂ŋ, béhɛ̄ mɔ́ chɔ́ á nló, béhɛ́-ʼɛ mɔ́ mengombe ḿme méyəgeʼ á yə̌l, ḿmě méwágné mengombe mé kə̂ŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bésídtéʼáá mɔ́ bɛnbɛn, béhɔ̄bē bán, “A kə̂ŋ e bad bé Israɛl, edúbé ébɛ̂ ne wɛ.” Bébɔ́méʼáá mɔ́ kə́ə́ŋne mebɛ́n. ");
INSERT INTO bssNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Payledɛ ambíd á ebwɔ́g ámpē, aláá ábê bad aá, “Nyénɔneʼ, mbídtaad nyé mɔ́ á ebwɔ́g, âbɛl nɛ́n nyébíi bán, meekóbnɛɛ́ mɔ́ awusé ké ahɔ́g.” ");
INSERT INTO bssNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Né-ɔɔ́, Yesuɛ ambíd á ebwɔ́g ne ekóté e mechə̌ á nló, megombe ḿmě méyəgeʼ mɔ́-ʼɛ mébɛ́ mɔ́ á yə̌l. Hɛ́ɛ Payledɛ álâŋgɛɛ́ bɔ́ aá, “Nyénɔneʼ awedé mod-e nɛ́n!” ");
INSERT INTO bssNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Áde beprisɛ bémbáá ne bembəledɛ bé Ndáb-e-Dyǒb bényíné mɔ́, bêmbootéd abón bán, “Bomé mɔ́ á awɔg! Bomé mɔ́ á awɔg!” Payledɛ anláá bɔ́ aá, “Nyé běn nyétêd mɔ́, nyébome mɔ́ á awɔg, áyə̄le meekóbnɛɛ́ mɔ́ awusé ké ahɔ́g.” ");
INSERT INTO bssNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ábê bad bêntimtɛ́n Payledɛ bán, “Sêwóó mbéndé echě ehɔ́be nɛ́n bán atə́ŋgɛ́né awɛ́ áyə̄le ahɔ́bé aá mɔ́díi Mwǎn a Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Áde Payledɛ áwógé nɛ́n, mbwɔ́g mênnabé mɔ́ akób. ");
INSERT INTO bssNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Antǐm ámbīd á eyáde-tê ámpē, ásɛ̄dēd Yesuɛ aá, “Héé ébídé?” Boŋ Yesuɛ enkênkədɛ́nné mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Né-ɔɔ́, Payledɛ anláá mɔ́ aá, “Weéhɛ̄dɛ̄ɛ̄ mɛ akwɛntɛn-ɛ? Weebíiʼɛ́ nɛ́n wɛɛ́ nwóó kunze âhɔ́b mɛɛ́ béchene wɛ, nwóŋ-ʼɛ kunze âhɔ́b mɛɛ́ bébome wɛ á awɔg-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesuɛ ankwɛntɛ́n mɔ́ aá, “Weewóoʼɛ́ kunze ké pɔ́g ámīn echêm ésebán Dyǒb ábágé wɛ ene kunze. Né-ɔɔ́, mod awě abagé mɛ áwōŋ mekáá abɛlé mbéb ḿme ńtómtɛ́né achab ámīn.” ");
INSERT INTO bssNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Áde Payledɛ áwógé nɛ̂ anhɛ̌d nzii âtɛde Yesuɛ, boŋ ábê bad bénhɛ̄ eʼsaád bán, “Nzé etɛ̌dté anɛ́n mod né weésaá nsón awě Kaisɛɛ. Kénzɛ́ɛ́ awě ahɔ́bé aá, mɔ́dē kə̂ŋ né atə̂ŋgan Kaisɛɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Áde Payledɛ áwógé nɛ́n, ambídɛ́n Yesuɛ á ebwɔ́g, ádyɛ̄ɛ̄ atii dé nkamlɛn. Ádê hǒm wɛ́ɛ ândyɛɛ́ʼɛ́ béchə́géʼáá dɔ́ bán, Eyáde éche bénábnédé Meláá. Á ehɔ́b é Hibru béchəge bán, Gabata. ");
INSERT INTO bssNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Bɔɔb-pɔɔ́, nɛ́n ábédé á epun é mboŋsɛ́n é Ngande e Nnyíme-ámīn, dyam kəd. Payledɛ anláá ábê bad bé Israɛl aá, “Echɛn kə̂ŋ chɔ̂ nɛ́n!” ");
INSERT INTO bssNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ábê bad bénhɛ̄ eʼsaád bán, “Wúú mɔ́! Wúú mɔ́! Bomé mɔ́ á awɔg!” Hɛ́ɛ Payledɛ ásɛdtɛɛ́ bɔ́ aá, “Ḿbome echɛn kə̂ŋ á awɔg-ɛ?” Beprisɛ bémbáá bênkwɛntɛ́n mɔ́ bán, “Séewóoʼɛ́ kə̂ŋ empée étōmɛɛ́ Kaisɛɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Dɔ́ɔ Payledɛ ábágé Yesuɛ áwab mekáá âbome mɔ́ á awɔg. Né-ɔɔ́, bênhidnéd Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesuɛ mwěn ampém ádē awɔg bootya á dyad-tê ákɛ̄ɛ̄n dɔ́ hǒm áde béchəgɛɛ́ bán, “Hǒm dé Ebóŋgɛ́l é Nló,” áde béchəgɛɛ́ á ehɔ́b é Hibru bán Golgota. ");
INSERT INTO bssNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Áhed-taá bêmbomɛ́ɛ́ mɔ́ á awɔg. Bêmbomé bad bébɛ bémpēe á awɔg áhed, nhɔ́g pɛd pɔ́g, aníníí-ʼɛ pɛd eníníí, Yesuɛ abɛ́ átîntê. ");
INSERT INTO bssNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Payledɛ antěl á abámbé aá, “Yesuɛ, mod a dyad á Nazarɛt, kə̂ŋ e bad bé Israɛl,” abádé á awɔg á nló-mîn wɛ́ɛ Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Wɛ́ɛ bêmbomɛ́ɛ́ Yesuɛ á awɔg démbɛ̄ bɛnbɛn ne Jerusalɛm. Né-ɔɔ́, bad híin bénlāŋ chǒm éche bêntenlé. Chǒm éche ântenlé, antel chɔ́ á ehɔ́b é Hibru, átēl é ehɔ́b é Latin, ne é ehɔ́b é Grikia. ");
INSERT INTO bssNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Beprisɛ bémbáá bénlāā Payledɛ bán, “Wɛɛ́tēlē wɛɛ́ ‘Kə̂ŋ e bad bé Israɛl,’ těl wɛɛ́, ‘Anɛ́n mod ahɔ́bé aá, mɛ-ɛɛ́ ndé kə̂ŋ e bad bé Israɛl.’ ” ");
INSERT INTO bssNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Payledɛ anláá bɔ́ aá, “Chǒm éche ńtélé mmaá atel.” ");
INSERT INTO bssNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Áde sə́nze émáá Yesuɛ abome á awɔg, béntēd éche mbɔ́té, békabtéd chɔ́ áte moŋge méniin, bɔ́ mod tɛ́ atéd akab ahɔ́g. Béntēd kə́ə́ŋne mbɔ́té eche béhágkē áte. Ene mbɔ́té bénkêmbaáʼɛ́ chɔ́ hǒmhǒm. Embɛ́ bootya ámīn âpɛ ásē enkênwóŋgé mbom. ");
INSERT INTO bssNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Hɛ́ɛ bélâŋgɛɛ́ nhɔ́g ne aníníí bán, “Syánē deésālē chɔ́. Désid mbambú ânyín mod awě ǎtēd chɔ́.” Nɛ́n dêmbɛnléd âlóned eʼyale ábe éʼténlédé á Kálag e Dyǒb nɛ́n bán, “Běn ne běn bênkǎb échêm mbɔ́té. Bênsǐd-tɛ mbambú âkab ḿmêm nsob.” Né-ɔɔ́, nɛ̂ dɔ́ɔ échê sə́nze êmbɛnlé. ");
INSERT INTO bssNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesuɛ nyaá, nyaá mwǎnyaŋ, Maria awě abédé Klopasɛ mwaád ne Maria Magdalɛnɛ béntyēēm bɛnbɛn ne á awɔg áde Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Áde Yesuɛ ányíné nyaá ne mbapɛɛ awě ádə́ə́ bétyéémé áhed, anláá nyaá aá, “Á-nyaŋ, mwǎn wɛ nɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Hɛ́ɛ álâŋgɛɛ́ ane mbapɛɛ mɔ́mpē aá, “Nyoó ne.” Bootya ene póndé ane mbapɛɛ antéd Yesuɛ nyaá, átīmɛ̄n mɔ́ áwē ndáb. ");
INSERT INTO bssNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ámbīd e nɛ̂, Yesuɛ annyín aá mekan mésyə̄ə̄l mémáá. Âlóned-tɛ ngáne éténlédé á Kálag e Dyǒb anhɔ́b aá“Píd ekóbé mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kúmbe embɛ́ áhed, ebɛ́ntéd é mǐm énlɔ̄g áwēd-te. Né-ɔɔ́ bêntɔdé kuchá á ebɛ́ntéd é mǐm-tê wɛ̂, bésɔ̄m á ntóŋ ń ngɛn e hísɔb, béhɛ̄ mɔ́ á nsəl. ");
INSERT INTO bssNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Áde Yesuɛ ámwédé ebɛ́ntéd é mǐm chê, anhɔ́b aá, “Émáá.” Hɛ́ɛ ámɔ́gé nló, awɛ́-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Bɔɔb-pɔɔ́, échê epun ébédé Mbwɛ mé mboŋsɛ́n mé mbwɛ-mé-nkɔ́me-áte. Bad bé Israɛl-lɛ béehɛdeʼaá bán ndim ḿbɛ́ ḿbɛ̂ á awɔg á mbwɛ-mé-nkɔ́me-áte, taŋge ngáne échê epun é nkɔ́me áte étōmtɛ̄nnē edúbé abɛ́. Né-ɔɔ́ béntān Payledɛ bán, ábɛ bɔ́ kunze âbóg bad ábɛ bébómmé á awɔg mekuu ne âhúd bɔ́ á awɔg. ");
INSERT INTO bssNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Né-ɔɔ́, échê sə́nze ênkɛ̌ ébóg mekuu ḿme bad ábe bêmbomɛ́ɛ́ bɔ́ɔbɛ Yesuɛ á awɔg. Bénsēbē ḿme nhɔ́g abóg, bébóg-kɛ ḿme aníníí. ");
INSERT INTO bssNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Boŋ áde bépédé wɛ́ɛ Yesuɛ béntān nɛ́ɛ ámáá awɛ́. Né-ɔɔ́, bénkêntɔgɛ́nné mɔ́ mekuu abóg. ");
INSERT INTO bssNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ké nɛ̂, sə́nze pɔ́g ensoŋ mɔ́ akoŋ á aheb. Ábwɔ̄g-ábwɔ̄g mekií ne mendíb bémbīd. ");
INSERT INTO bssNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mod awě annyín nɛ́ɛ ḿmɛ́n mekan mébɛ́nlédé, abídé mbóŋ, eche mbóŋ edé-ʼɛ mbále. Abíí nɛ́n aá, mɔ́kaleʼ mbále, ahɔ́be-ʼɛ ḿmɛ́n mam âbɛl nɛ́n nyémpē nyédúbe. ");
INSERT INTO bssNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ḿmɛ́n mam mébɛ́nlédé âlóned eʼyale ábɛ éʼténlédé á Kálag e Dyǒb nɛ́n bán, “Béebógké ehid échē ké ehɔ́g.” ");
INSERT INTO bssNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Éténlédé á kálag e Dyǒb ámpē nɛ́n bán, “Bɛ́nɔ̌n ane awě bésóó akoŋ.” ");
INSERT INTO bssNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ámbīd enɛ̂, Josɛbɛ awě ambíd á dyad á Arimatia, anláá Payledɛ aá, ábɛ mɔ́ kunze âted ndim ḿme Yesuɛ. Josɛbɛ abédɛ́ɛ mbapɛɛ awě Yesuɛ, boŋ énkêmbídédté yə̌l áwed áyə̄le abááʼáá bad bé Israɛl. Payledɛ ambɛ̌ mɔ́ kunze âtéd ndim ḿme Yesuɛ. Né-ɔɔ́, ankɛ̌ Yesuɛ ndim atéd. ");
INSERT INTO bssNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemusɛ awě ansébé Yesuɛ akɛ dé anyín nkuu, bɔ́ Josɛb bênkɛ̌. Bédɛ̂kɛ̌ anwálé mekúle ḿme bénabnadté ndim ḿmé bébɛ́nlé Mía ne Álɔs. Ádê dyɔ̌g ábédé dyam móom mé kílo meláán ne kílo étáan. ");
INSERT INTO bssNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Béntēd ndim ḿme Yesuɛ, békāān mɔ́ mbɔ́m ne ḿme mekúle. Nɛ́n dɔ́ɔ elem é bad bé Israɛl âboŋsɛn ndim émbɛ̄ɛ̄. ");
INSERT INTO bssNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Bɔɔb-pɔɔ́, nzag embɛ́ wɛ́ɛ bénwūūʼɛ́ Yesuɛ. Soŋ e ekɔ́ɔ́lé ebédé á nzag-tê wɛ̂, echě bénkêmpaá ndim ké nhɔ́g abane áte. ");
INSERT INTO bssNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Né-ɔɔ́, ngáne échê epun ebédé mbwɛ mé mboŋsɛ́n mé mbwɛ-mé-nkɔ́me áte, ene soŋ-ʼɛ ebɛ́ bɛnbɛn, bêmbané Yesuɛ ndim áwēd-te. ");
INSERT INTO bssNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Á Sɔ̂ndɛ́, epɔg é mbwɛmbwɛ, áde ehíntɛ́n émbɛ̄ɛ̄ ébɛ́, Maria Magdalɛnɛ ankɛ̌ á soŋ wɛ́ɛ bénlīmɛ̄ɛ̄ Yesuɛ. Áde ápédé áhed, antán nɛ́ɛ béhúdé aláá áde bénkɔ̄lɛ̄nnē nsəl ń soŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Hɛ́ɛ átómé mehélé, boŋ ákɛ atán Simɔn Petro ne mbapɛɛ ampée awě búmɔ̄ bébédé. Ane mbapɛɛ abédɛ́ɛ mbapɛɛ awě Yesuɛ ândəŋgé. Dɔ́ɔ Maria álâŋgɛɛ́ bɔ́ aá, “Béhúdé Sáŋgwɛ́ɛ́ ndim á soŋ-tê, séebíi-ʼáa wɛ́ɛ bébánné mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Dɔ́ɔ Petro bɔ́ ane mbapɛɛ béhídté boŋ békǎg á soŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bɔ́ moosyəə́l bényə́gtéʼáá, boŋ mbapɛɛ aníníí anyə̌gtéʼáá tómaa Petro. Né-ɔɔ́, ansébé apɛ á soŋ. ");
INSERT INTO bssNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Anwúlɛ́n ásē ásad dǐd á soŋ-tê, anyín mbɔ́m éche bênkaánné Yesuɛ, boŋ enkênsɔ́nlé á soŋ-tê. ");
INSERT INTO bssNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simɔnɛ ahúɛ́ʼáá mɔ́ ámbīd, apedé-ʼaá pɛɛ́n asɔ́l-lɛ á soŋ-tê. Antán mbɔ́m éche bênkaánné Yesuɛ áhed. ");
INSERT INTO bssNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Antán-nɛ abad áde bênkaánné Yesuɛ nló. Ádê abad déēbédɛɛ́ hǒm ahɔ́g ne mbɔ́m, déndə̄ə̄n áte pɛd pɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Hɛ́ɛ aníníí mbapɛɛ awě ansébé apɛ á soŋ mɔ́mpē ásɔ́lé áwēd-te. Annyín ábê bwěm, adúbé-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ké nɛ̂, bénkênsóŋtɛ́nné chǒm éche éténlédé á Kálag e Dyǒb nɛ́n bán Yesuɛ atə́ŋgɛ́né apuu. ");
INSERT INTO bssNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ámbīd é nɛ̂, ábê bembapɛɛ bêntǐm ámbīd á ndáb. ");
INSERT INTO bssNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Bɔɔb-pɔɔ́ Maria anlyə̌g á nsəl ń soŋ, áchyɛɛ́ʼ. Áde áchyɛɛʼɛ́ nɛ̂ dɔ́ɔ áwúnlé ásē, boŋ ásadé dǐd á soŋ-tê. ");
INSERT INTO bssNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Asad áde ásádé dǐd, annyín ángɛl ébɛ. Échê ángɛl énhɛ̄ eʼpúpe éʼ mbɔ́té, édyɛ̄ɛ̄ wɛ́ɛ bênnaádté ndim ḿme Yesuɛ. Nhɔ́g andyɛɛ́ á pɛd e nló, aníníí-ʼɛ á pɛd e mekuu. ");
INSERT INTO bssNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Échê ángɛl ênsɛdéd Maria bán, “Á-mmwaád, cheé échyɛʼɛ́?” Anláá bɔ́ aá, “Nchyɛʼ áyə̄le bétédé ndim ḿme awem Sáŋgwɛ́ɛ́, meebíi-ʼáa wɛ́ɛ bébánné mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Áde ámáá ahɔ́b nɛ̂, ankunnéd, anyín nɛ́ɛ mod átyéémé áhed. Ane mod abédɛ́ɛ Yesuɛ boŋ enkêmbííʼɛ́ aá Yesuɛ mɔ́ adé. ");
INSERT INTO bssNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesuɛ asɛdéd mɔ́ aá, “Á-mmwaád, cheé échyɛʼɛ́? Nzɛ́ɛ́ éhɛdɛɛ́?” Maria anwémtɛ́n aá mod awě abɛle nsɔ́n á nzag-tê wɛ̂ mɔ́ adé. Né-ɔɔ́, anláá mɔ́ aá, “A-sáŋ, nzé wɛ-ɛɛ́ etédé mɔ́ ndim, eláá mɛ wɛ́ɛ ébánné, âbɛl boŋ ńkɛ ńtêd mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Hɛ́ɛ Yesuɛ áchəgɛɛ́ mɔ́ aá, “Á-Maria!” Dɔ́ɔ Maria ákúnné yə̌l áwē boŋ áhɔ́bé á ehɔ́b é Hibru aá, “Rabɔ́ni!” (awě adé nɛ́n bán, “Meléede”). ");
INSERT INTO bssNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesuɛ anláá mɔ́ aá, “Weésitán mɛ, áyə̄le meétímɛ́ɛ́ ámbīd wɛ́ɛ Titɛ́ɛ. Boŋ kǎg wɛ́ɛ ábêm bembapɛɛ, ábêm baányaŋ, éláa bɔ́ wɛɛ́, ntimeʼ ámbīd wɛ́ɛ echem Sáŋ, awě adé kə́ə́ŋne echɛn Sáŋ. Mɔ́ adé Dyǒb ádêm, abɛ́-ʼɛ ádɛ̄n.” ");
INSERT INTO bssNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Né-ɔɔ́, Maria Magdalɛnɛ ankɛ̌, aláá bembapɛɛ aá, mɔ́nyīnē Sáŋgwɛ́ɛ́. Anláá-ʼɛ bɔ́ mam mésyə̄ə̄l ḿme áláŋgé mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Échê epun é Sɔ̂ndɛ́ chěn, ngukɛ́l, bembapɛɛ ábe Yesuɛ bênladɛ́n áte á ndáb-te bépēn-nɛ ekob áyə̄le bébááʼáá bad bé Israɛl. Yesuɛ ampɛ̌, atyéém átîntê echâb, aláá bɔ́ aá, “Nsaŋ ḿbɛ̂ ne nyé.” ");
INSERT INTO bssNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Áde ámáá ahɔ́b nɛ̂, anlúméd bɔ́ ḿmē mekáá, alúméd-tɛ bɔ́ aheb. Bembapɛɛ bébédé menyiŋge bwâmbwam ânyín Sáŋgwɛ́ɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Dɔ́ɔ Yesuɛ álâŋgɛɛ́ bɔ́ ámpē aá, “Nsaŋ ḿbɛ̂ ne nyé. Ngáne Titɛ́ɛ álómé mɛ, melemlem nɛ̂ dɔ́ɔ mɛ́mpē ńlómɛɛ́ nyé.” ");
INSERT INTO bssNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Áde ámáá ahɔ́b nɛ̂, anhébé bɔ́ pemɛ, aláá-ʼɛ bɔ́ aá, “Nyékob Edəə́dəŋ éche Ésáá. ");
INSERT INTO bssNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kénzɛ́ɛ́ awě nyélágsɛ́né mbéb, né ḿme mbéb ńkúdé alagsɛn. Kénzɛ́ɛ́-ʼɛ awě nyéelagsɛ́nɛɛ́ ḿmē mbéb, né méekudɛɛ́ alagsɛn.” ");
INSERT INTO bssNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tɔmasɛ mbapɛɛ nhɔ́g átîntê e bembapɛɛ dyôm ne bébɛ ábe Yesuɛ, awě béchə́géʼáá bán Nhɛ́d, enkêmbáá ne baáb áde Yesuɛ ápédé. ");
INSERT INTO bssNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Né-ɔɔ́, áde ahúú baáb bénlāā mɔ́ bán, “Sênyíné Sáŋgwɛ́ɛ́.” Boŋ anláá bɔ́ aá, “Ésebán ńnyíné mebaŋ ḿme bêmbomɛ́ɛ́ mɔ́ tɔnɛ á mekáá boŋ ńsɔ̄m-mɛ eʼmii á mebaŋ-tê áwed, ḿbīd-tɛ ekáá áwē aheb, méedúbɛ́ɛ́ mbêd.” ");
INSERT INTO bssNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ámbīd e eʼpun waam, bembapɛɛ bênladɛ́n áte á ndáb-te ámpē. Tɔmasɛ mɔ́mpē ambɛ́ áhed. Bêmpěn eʼkob, boŋ Yesuɛ ampɛ̌, atyéém átîntê echâb. Anláá bɔ́ aá, “Nsaŋ ḿbɛ̂ ne nyé.” ");
INSERT INTO bssNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Hɛ́ɛ álâŋgɛɛ́ Tɔmasɛ aá, “Sɔ̌m eʼmii á mebaŋ hɛ́n. Nɔnéʼ mɛ mekáá, éhyɛne-ʼɛ ekáá, ébid mɛ chɔ́ á aheb. Sóg mod abɛ́ awě eedúbpéʼ, dúbé!” ");
INSERT INTO bssNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tɔmasɛ ankwɛntɛ́n mɔ́ aá, “A-Sáá awêm, a-Dyǒb ádêm.” ");
INSERT INTO bssNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesuɛ anláá mɔ́ aá, “Saá áyə̄le ényíné mɛ dɔ́ɔ édúbpé-yɛ? Nnam ne bad ábe béenyíne boŋ kénɛ̂, bédúbe.” ");
INSERT INTO bssNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesuɛ ambɛ̌l ekud é menyáké émpēe éche ábē bembapɛɛ bémbɛ̄ɛ̄ ásē éche béetelɛɛ́ á kálag-tê wɛ́n. ");
INSERT INTO bssNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Boŋ ḿmɛ́n mésyə̄ə̄l méténlédé âbɛl nɛ́n nyédúbe bán, Yesuɛ mɔ́ adé Ane-awě-Béwɔ́gté, Mwǎn a Dyǒb. Nzé nyêdúbpé-ʼɛ mɔ́, né nyêkudé aloŋgé áde déemaáʼ á dǐn ádē. ");
INSERT INTO bssNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ámbīd e ḿmɛ́n mésyə̄ə̄l, anlúméd ábē bembapɛɛ yə̌l ámpē á nkin mé edib é Tiberia. Nyaa echě ánlūmēdtē bɔ́ yə̌l ebédɛ́ɛ nɛ́n, ");
INSERT INTO bssNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","epun ehɔ́g Simɔn Petro, Tɔmasɛ (awě béchə́géʼáá Nhɛ́d), Nataniɛlɛ (awě ambíd á dyad á Kana á mbwɔ́g e Galilia), bǎn ábe Zɛbɛdiɛ, ne bembapɛɛ ábe Yesuɛ bémpēe bébɛ, bênladɛ́n hǒm ahɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Hɛ́ɛ Simɔn Petro álâŋgɛɛ́ bɔ́ aá, “Nkag súu akób.” Bêntimtɛ́n mɔ́ bán, “Sémpē sɛ́ɛ̄hīd wɛ.” Né-ɔɔ́, bênhidé békɛ bésɔ́l á bɔ̌lɛ-tê. Boŋ ḿmê nkuu ńsyə̄ə̄l bénkênkóbpé chǒmchǒm. ");
INSERT INTO bssNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Áde bǐn éʼbóótédé akɛ́le, Yesuɛ antyéém á nkin mé edib. Boŋ ábê bembapɛɛ bénkêmbííʼɛ́ bán mɔ́ adé. ");
INSERT INTO bssNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Dɔ́ɔ Yesuɛ ásɛdtɛɛ́ bɔ́ aá, “A-bɛ̌d, nyéēkōbɛ̄ɛ̄ chǒmchǒm-ɛ?” Bênkwɛntɛ́n mɔ́ bán, “Aáy, séēkōbɛ̄ɛ̄.” ");
INSERT INTO bssNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Anláá bɔ́ aá, “Nyébwêm mbínzé á pɛd e ekáá é mbáá é bɔ̌lɛ, nyɛ́ɛ̄kɔ̄b.” Né-ɔɔ́, bémbwēm mbínzé ene pɛd. Bénkênhɛnlé ene mbínzé adol áyə̄le súu émbɛ̄ áwēd-te bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Dɔ́ɔ mbapɛɛ awě Yesuɛ ândəŋgé áhɔ́bɛɛ́ aá, “Sáŋgwɛ́ɛ́ mɔ́ adé!” Awóg áde Simɔn Petro áwógé bán, Sáŋgwɛ́ɛ́ mɔ́ adé, anhɛ́ megombe á yə̌l (áyə̄le anhūd bwěm á yə̌l). Dɔ́ɔ áhébé á edíb-te. ");
INSERT INTO bssNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Boŋ ábíníí bembapɛɛ bêmpɛ̌ á nkin á bɔ̌lɛ-tê, bédolé mbínzé. Ene mbínzé enlón ne súu. Wɛ́ɛ bémbīdɛ̄nnē bɔ̌lɛ âpɛ á nkin dénkênchabpé, ábédé dyam mbwɔ́kɛl e méta pɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Áde bépédé á nkin béntān muú mé mekâŋled. Súu ébédé áwed ámīn ne ewɛle. ");
INSERT INTO bssNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesuɛ anláá bɔ́ aá, “Nyéhyɛɛneʼ doŋge á súu áde nyékóbé bɔɔb.” ");
INSERT INTO bssNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Né-ɔɔ́, Simɔn Petro ansɔ́l á bɔ̌lɛ-tê, âdol ene mbínzé á nkin. Súu émbáá énlōn ene mbínzé áte. Ébédé mbwɔ́kɛl móom métáan ne éláán. Kénɛ́ɛ échê súu êmbuúʼɛ́ áte, ene mbínzé enkênsalɛ́ɛ́. ");
INSERT INTO bssNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesuɛ anláá bɔ́ aá, “Nyéhyɛ nyédyɛ̂ ndyééd.” Ábê bembapɛɛ bɔ́ modmod enkênchuʼɛ́ mɔ́ asɛded aáken, “Nzɛ́-módɛ́ édíí?” Bémbīī bán, Sáŋgwɛ́ɛ́ mɔ́ adé. ");
INSERT INTO bssNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Dɔ́ɔ Yesuɛ átédé ewɛle boŋ ábagé bɔ́. Ambɛ̌l melemlem ne súu. ");
INSERT INTO bssNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nɛ́n ábédé ngen echě élóntɛ́né éláán, echě Yesuɛ álúmté ábē bembapɛɛ yə̌l á póndé echě ámáá apuu. ");
INSERT INTO bssNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Áde bémáá ndyééd adyɛ́, Yesuɛ asɛdéd Simɔn Petro aá, “A-Simɔn, mwǎn a Jɔn, edəə́ mɛ tómaa ábén bembapɛɛ-yɛ?” Simɔnɛ ankwɛntɛ́n aá, “Ɛɛ, a-Sáŋ, ebíí wɛɛ́ ndəə́ wɛ.” Yesuɛ anláá mɔ́ aá, “Tɔgɛ́n ábêm bǎn bé ńdyɔŋ ḿ mbód.” ");
INSERT INTO bssNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesuɛ ansɛdéd mɔ́ ngen éche élóntɛ́né ébɛ aá, “A-Simɔn, mwǎn a Jɔn, edəə́ mɛ-yɛ?” Petro antimtɛ́n mɔ́ aá, “Ɛɛ, a-Sáŋ, ebíí wɛ̌ ndəə́ wɛ.” Yesuɛ anláá mɔ́ aá, “Tɔgɛ́n ḿmêm ńdyɔŋ ḿ mbód.” ");
INSERT INTO bssNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesuɛ asɛdéd mɔ́ ngen échě élóntɛ́né éláán aá, “A-Simɔn, Mwǎn é Jɔn edəə́ mɛ-yɛ?” Yə̌l enhɔ́ɔ́ Petro áte áde Yesuɛ ásɛ́dté mɔ́ ngen échě élóntɛ́né éláán aáken, “Edəə́ mɛ-yɛ?” Né-ɔɔ́, anláá Yesuɛ aá, “A-Sáŋ, ebíí mam mésyə̄ə̄l. Ebíí wɛɛ́ ndəə́ wɛ.” Yesuɛ anláá mɔ́ aá “Tɔgɛ́n ḿmêm ńdyɔŋ ḿ mbód. ");
INSERT INTO bssNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ne mbále, nlâŋge wɛ nɛ́n mɛɛ́, áde ébédé etum, mmǒn epúdéʼáá abad, ékǎg-kɛ kéhéé wɛ́ɛ édə́ə́. Boŋ áde wɛ́chunné wɛ̌sǎd mekáá, mod ampée awáád wɛ abad, ákɛ̄ɛ̄n-nɛ wɛ wɛ́ɛ wéedəəʼɛ́ akɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Yesuɛ anhɔ́b nɛ̂ âlúmed nyaa e kwééd echě Petro áwɛ̄ɛ̄, âlúmed ehúmé é Dyǒb.) Ámbīd e nɛ̂ dɔ́ɔ Yesuɛ álâŋgɛɛ́ mɔ́ aá, “Hídé mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Dɔ́ɔ Petro ánɔ́né ámbīd boŋ ányīnēʼ nɛ́ɛ mbapɛɛ ampée áhídɛɛ́ bɔ́. Ane mbapɛɛ abédɛ́ɛ mbapɛɛ awě Yesuɛ ândəŋgé. Mɔ́ɔ andyɛɛ́ Yesuɛ á akéb á póndé éche bédyágéʼáá ndyééd ngukɛ́l, boŋ ásɛ̄dēd Yesuɛ aá ken, nzɛ́-módɛ́ ǎsōm mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Anyín áde Petro ányíné-ʼaá mɔ́, anhɔ́b aá, “A-Sáŋ, chán-náa anɛ́n mod?” ");
INSERT INTO bssNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesuɛ ankwɛntɛ́n mɔ́ aá, “Nzé nhɛde mɛɛ́ ábɛ̂ á aloŋgé kə́ə́ŋne póndé echě mɛ́pɛɛ́, chán nɛ̂ ánɔ́né wɛ? Hídé mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Né-ɔɔ́, énkanléd átîntê e bad ábe béhídéʼáá Yesuɛ hǒm ásyə̄ə̄l nɛ́n bán ane mbapɛɛ éewáá, kénɛ́ɛ Yesuɛ énkênhɔ́bpé aá, éewáá. Anhɔ́b dásɔ̄ aá, “Nzé nhɛde mɛɛ́ ábɛ̂ á aloŋgé kə́ə́ŋne póndé echě mɛ́pɛɛ́, chán nɛ̂ ánɔ́né wɛ?” ");
INSERT INTO bssNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ane mbapɛɛ mɔ́ abíde mbóŋ áyə̄l e ḿmɛ́n mekan, mɔ́-ʼaá atelé mɔ́ ásē. Debíí-ʼɛ bán, kéchéé echě áhɔ́bé édé mbále. ");
INSERT INTO bssNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ekud é mam émpēe édé éche Yesuɛ ábɛ́lé. Nzé bénhɔ̄b bán bételeʼ mésyə̄ə̄l ásē, ahɔ́g ámbīd e ádíníí, nwêmtan mɛɛ́ né nkǒŋsé méekwogké échê kálag ahɛ́ áte.");
INSERT INTO bssNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Á-Tiofilos, mod a edúbé, á kálag echě ńsébpé atel, mentěl mekan ásē ḿme Yesuɛ âmbɛnlé ne ḿme áyə́gtéʼáá bad. Ambɛ̌l ḿmɛ́n mekan bootya á póndé echě âmbootédté ḿme nsɔ́n, ");
INSERT INTO bssNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kə́ə́ŋne, á póndé eche Dyǒb dêmbɛnlé boŋ ápūmē. Byánán ǎpumé, ambɛnléd ngíne e Edəə́dəŋ éche Ésáá, âláa bad ábe âmpwɛdté nɛ̂ŋgáne ábē bembapɛɛ bé nlómag mekan ḿme bétə́ŋgɛ́né abɛl. ");
INSERT INTO bssNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Bootya áde Yesuɛ áwédé, âpɛ móom mé eʼpun méniin, anlúméd ábē bembapɛɛ bé nlómag yə̌l ngen ne ngen, âlúmed nɛ́n aá ne mbále mɔ́dē á aloŋgé. Bényínnáá mɔ́ dǐd ákanlé-ʼɛ bɔ́ tə̂ŋgɛne nkamlɛn ń Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Póndé pɔ́g áde bɔ́ɔ̄bɔ̄ɔ bédyágkē ndyééd, ansím bɔ́ etúu áte aláá bɔ́ aá, “Nyéēhīdtē á dyad á Jerusalɛm. Nyésineʼ ndɛ echě Titɛ́ɛ awêm áláŋgé nyé aá mɔ́hɔ̄bē aá mɔ́ɔ̄bɛ̌ nyé. Ene ndɛ chɔ́ɔ ménlāāʼɛ́ nyé. ");
INSERT INTO bssNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jɔnɛ adǔsánnáá bad ne mendíb, boŋ ámbīd e nguse e eʼpun bɔɔb, bɛ́dusɛ́n nyé ne Edəə́dəŋ éche Ésáá.” ");
INSERT INTO bssNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Póndé pɔ́g bembapɛɛ bé nlómag bɔ́ɔbɛ Yesuɛ bênladɛ́n hǒm ahɔ́g. Hɛ́ɛ bésɛdtɛɛ́ mɔ́ bánken, “A-Sáŋ, láá sé. Ḿmɛ́n mesú dɔ́ɔ wɛ́bɛnlé boŋ bad bé Israɛl béwóŋ ngíne ámpē âkamlɛn echab yə̌l-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Hɛ́ɛ Yesuɛ átimtanné bɔ́ aá, “Titɛ́ɛ mɔ́ abɛnlad eche ngíne âtíi póndé ne mekag ḿme kéchéé ébɛnlédté. Nyéewóoʼɛ́ kunze âbíi póndé eche ḿmɛ́n mekan mɛ́bɛnlédté. ");
INSERT INTO bssNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Boŋ áde Edəə́dəŋ éche Ésáá épiíʼɛ́ nyé nyɛ́ɛ̄kǔd ngíne, hɛ́-ʼaá nyɛ́kanlɛ́ɛ́ bad mekan ḿme nyényíné tə̂ŋgɛne mɛ á dyad á Jerusalɛm, á mbwɔ́g é Judeya, ne e Samaria ésyə̄ə̄l kə́ə́ŋ nyépɛ̄ á metóŋgé mé nkǒŋsé mésyə̄ə̄l.” ");
INSERT INTO bssNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesuɛ amaá-ʼaá bɔ́ aláa nɛ̂, dɔ́ɔ Dyǒb ábɛ́lé boŋ ápūmē ámīn. Áde bédíi bénɔnɛɛ́ mɔ́ nɛ̂, mbag énkūtɛ̄n mɔ́, bénkênnyín-naá mɔ́ ámpē. ");
INSERT INTO bssNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bembapɛɛ bémbɛ̄ bétānē mǐd áte bénɔnéʼ ngáne Yesuɛ ákagké ámīn, dɔ́ɔ bad bébɛ ábe béhédé mbɔ́té éche épúbeʼ bébídé təléd, bétyéém bɔ́ á nkəg. ");
INSERT INTO bssNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Hɛ́ɛ ábê bad bébɛ bésɛdtɛɛ́ bɔ́ bánken “Á-bad bé Galilia, cheé nyétyéémé hɛ́n, nyénɔnɛɛ́ ámīn? Anɛ́n Yesuɛ awě Dyǒb ábɛ́lé boŋ áhīdē átîntê echɛ̂n, ápūmē ámīn, ǎtǐm ámbīd melemlem ngáne nyényíné akag ámīn.” ");
INSERT INTO bssNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Hɛ́ɛ bembapɛɛ bé nlómag béhídté á Ekone é Menzab, bétím ámbīd á Jerusalɛm. Échê ekɛ ébédé dyam epɛd é Máyl ehɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Áde bésɔ́lé á dyad-tê, bênkɛ̌ bésɔ́l á toŋ eche bédyɛ́ɛ́ʼáá áte. Ene toŋ ebédé á esóŋ é ndáb éche édé ámīn. Ábê bembapɛɛ bé nlómag bébédɛ́ɛ Petro, Jɔnɛ, Jemsɛ ne Andreya, Filibɛ ne Tɔmasɛ, Batolomyo ne Matyo, Jemsɛ, mwǎn awe Alfɔsɛ ne Simɔnɛ awě anwóŋ kə́n e aloŋ, ne Judasɛ mwǎn awě Jemsɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ábɛ́n bembapɛɛ béyɔ́gkéʼáá aladɛn áte hǒm ahɔ́g âkáne nchoo ne bebaád, Maria, Yesuɛ nyaa, ne Yesuɛ baányaŋ. ");
INSERT INTO bssNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ḿmê mesú měn, bad ábe béndūbē Yesuɛ bênladɛ́n áte. Bébédé dyam mbwɔ́kɛl ne móom mé bad mébɛ. Hɛ́ɛ Petro átyéémé ámīn átîntê echâb boŋ áhɔ̄bē aá, ");
INSERT INTO bssNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“A-baányaŋ, mekan ḿme méténlédé á kálag e Dyǒb métə́ŋgɛ́né alón. Edəə́dəŋ éche Ésáá énhɔ̄b áʼsō é póndé á nsəl ḿme Dabidɛ tə̂ŋgɛne Judasɛ awě antómɛ́n bad ábɛ bênkɛ̌ Yesuɛ akób. ");
INSERT INTO bssNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judasɛ abédé nhɔ́g átîntê e syánē. Yesuɛ ampwɛ̌d mɔ́ âbɛl ḿmɛ́n nsɔ́n melemlem nɛ̂ŋgáne âmpwɛdté syánē. ");
INSERT INTO bssNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Mɔné ḿme ânkudté áyə̄le ebébtéd éche âmbɛnlé, anchanɛ́n mɔ́ etúú. Á etúú-te wɛ̂ děn-naá ânsoŋgé dúu, awɛ́-ʼɛ, abum ákán mɔ́, mmii ḿbíd-tɛ mɔ́ áwed. ");
INSERT INTO bssNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bad bésyə̄ə̄l á Jerusalɛm bénwōg ádɛ́n akan, né-ɔɔ́ bênchə̌g ádê hǒm áwab ehɔ́b-te bán Akɛldama, nɛ́dē, ‘Ndɔɔb e mekií.’) ” ");
INSERT INTO bssNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Petro ambád ahɔ́b aá, “Nɛ́n ábɛ́nlédé ngáne éténlédé a kálag e ngəse é Dyǒb nɛ́n bán, ‘Áde hǒm átim eʼbwɔ́gɛn modmod eelóóʼ áhed.’ Éténlédé-ʼɛ nɛ́n bán, ‘Mod ampée átêd eche etə́l é nsɔ́n.’ ");
INSERT INTO bssNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Né-ɔɔ́, éhɛdneʼ nɛ́n bán dépwɛd mod nhɔ́g. Ane mod atə́ŋgɛ́né abɛ́ mod awě abágáá ne syánē póndé esyəə́l eche echɛd Sáŋ Yesuɛ ne syánē dékágéʼáá mebwɔ́g ne mebwɔ́g, ");
INSERT INTO bssNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","bootyaa á póndé echě Jɔnɛ ádúsánnáá bad âpɛ á póndé echě Dyǒb dêmbɛnlé boŋ Yesuɛ ápūmē. Mɔ́mpē atə́ŋgɛ́né abɛ́ mod awě ambɛ́ mbóŋ áde Yesuɛ âmpuúʼɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Hɛ̂ dɔ́ɔ bépwɛ́dé bad bébɛ, Josɛbɛ awě bépwáŋtánnáá bán Basabasɛ (béchə́géʼáá mɔ́mpē bán Justusɛ) bɔ́ Matiasɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Dɔ́ɔ békânnɛɛ́ bán, “A-Sáŋ ebíí mod asyəə́l nlém áte. Lúméd sé mod awě épwɛ́dé átîntê e ábɛ́n bad bébɛ, ");
INSERT INTO bssNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","âtéd etə́l nɛ́ɛ mod a nlómag, éche Judasɛ átɛ́dté boŋ mwěn átiméʼ éche epɛd éche éboŋnédé mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Né-ɔɔ́, bênsǐd mbambú âlúmed bɔ́ mod awě bɛ́pwɛdté. Dɔ́ɔ mbambú élúmté bɔ́ âpwɛd Matiasɛ. Né-ɔɔ́, bémbād Matiasɛ á mesoŋgé mé bembapɛɛ bé nlómag ábíníí dyôm ne nhɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Áde ngande e Pɛntekɔs épédé, bad ábe bédúbpé Krǐstəə bésyə̄ə̄l bênladɛ́n áte hǒm ahɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ábwɔ̄g-ábwɔ̄g esaád émbīd ámīn. Ébédé nɛ́ɛ ekukud é ngíne éche étómeʼ. Échê esaád énlōn ene ndáb esyəə́l áte echě ábê bad ábe bédúbpé bémbɛ̄ɛ̄ áte. ");
INSERT INTO bssNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Hɛ̂ dɔ́ɔ bényíné bwěm nɛ̂ŋgáne muú ḿmě nwágné nɛ́ɛ eʼchém ńtyéémé mod-tɛ́ɛ́ á nló-mîn. ");
INSERT INTO bssNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Edəə́dəŋ éche Ésáá êmpií bɔ́ moosyəə́l, mod-tɛ́ɛ́ ábootéd mehɔ́b mé bad bémpēe ahɔ́b ḿmě béesebpɛɛ́ ayə́ge. Edəə́dəŋ chɔ́ɔ élyə́gtéʼáá bɔ́ âhɔ́b kéchéé éche béhɔ́béʼáá. ");
INSERT INTO bssNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Enɛ́n póndé bad bé Israɛl ábe békánnáá Dyǒb bébédé á Jerusalɛm. Ábén bad bémbīd mebwɔ́g ne mebwɔ́g á nkǒŋsé. ");
INSERT INTO bssNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Awóg áde béwógé échɛ́n esaád, ndun e mod enladɛ́n áte wɛ́ɛ ábê bad ábe bédúbpé bébédé. Yə̌l enkɔ́m bɔ́ áte bwâmbwam áyə̄le ngáne bad ábe bédúbpé béhɔ́béʼáá ábíníí bad bɔ́ mod-tɛ́ɛ́ áchemeʼ échē ehɔ́b. ");
INSERT INTO bssNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ne nkɔ̂mtɛn ń yə̌l áte, bênsɛdéd bán, “Kíné saá á mbwɔ́g e Galilia ábɛ́n bad bésyə̄ə̄l bébídé-yɛ? ");
INSERT INTO bssNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Chán-nɔ̄ ébɛ́nlédé boŋ syáā mod-tɛ́ áwōgēʼ ngáne béhɔ́bɛɛ́ éche ehɔ́b. ");
INSERT INTO bssNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Átîntê e syánē, baahɔ́g bébídé á meloŋ mé Patia, Mɛdia ne Elam; meloŋ mé Mɛsopotemia, Judeya ne Kapadosia; meloŋ mé Ponto ne mé Esia, ");
INSERT INTO bssNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","meloŋ mé Frigia ne Pamfilia, aloŋ á Egipto ne mebwɔ́g mé aloŋ á Libia, bɛnbɛn ne Sirinɛ syánē bad behɔ́g debídé á dyad á Roma. ");
INSERT INTO bssNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Átîntê e ábɛ́n bad bésyə̄ə̄l doŋge achyáádté ne bad bé Israɛl, ábíníí-ʼɛ bad ábe béesɛ̌ bad bé Israɛl ábe béhídeʼ adúbe á bad bé Israɛl. Syánē bad behɔ́g debídé á aloŋ á Krɛt ne á aloŋ dé Arebia boŋ kénɛ̂, syánē mod tɛ́ɛ́ awóge ngáne béhɔ́bɛɛ́ áwe ehɔ́b-te ndəle é mekan éche Dyǒb ábɛ́lé.” ");
INSERT INTO bssNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Yə̌l enkɔ́m bɔ́ áte bényāg-kɛ bwâmbwam, bésɛdté nhɔ́g ne aníníí bánken, “Chán nɛ́n ádíí-yē?” ");
INSERT INTO bssNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kénɛ̂, doŋge á bad béwɛ́léʼáá bad ábe bédúbpé, béhɔ̄bē bán bémáá mǐm amwɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Hɛ́ɛ Petro átyéémé ámīn átîntê e ábíníí bembapɛɛ bé nlómag dyôm ne nhɔ́g, áchə̄gtē ehɔ́b, álāŋgē ndun e mod echě embɛ́ áhed aá, “A-baányaŋ bé Israɛl ne nyé baásyə̄ə̄l ábe nyêdyɛɛ á Jerusalɛm, nyélâm metúu ńláa nyé ngáne nɛ́n ádíí. ");
INSERT INTO bssNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ábén bad béemwédɛɛ́ mǐm ngáne nyéwêmtanné. Bǐn éʼdíi bɔɔb ngə́ŋ abog é mbwɛmbwɛ ngɛ̂n. ");
INSERT INTO bssNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Boŋ nɛ́n ábɛ́nlédé ntíined ne eʼyale ábe nkal é edəə́dəŋ Joɛl ánhɔ̄bpē aá, ");
INSERT INTO bssNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Dyǒb áhɔ́bé nɛ́n aá, ‘Á eʼpun bé asóg, mɛ̌lōm échêm Edəə́dəŋ éche Ésáá épīī moosyəə́l. Ábén bǎn bé bebaád ne bé baachóm bɛ́hɔ̄bē mam ḿme mɛ́bɛnléd áʼsō é póndé. Échɛ́n kɔ́débad ényīnē ndɔ́g éche éhúú ne mɛ, ábɛ̄n bechun bé bad-tɛ bɛ́naŋgé nló. ");
INSERT INTO bssNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nɛ̂ děn-ɛɛ́ mɛ́bɛnlé. Mɛ̌lōm échêm Edəə́dəŋ ḿmê mesú, épií ké ábêm bembəledɛ, bebaád ne baachóm, boŋ béhɔ̄bē mam ḿme ńhúú ne mɛ, ḿme mɛ́bɛnléd áʼsō éʼ póndé. ");
INSERT INTO bssNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mɛ̌lūmēd menyáké ádyōb nlúmed-tɛ eʼchemléd á nkǒŋsé. Mekií mɛ́syɔgé, muú ńchodɛn, mwɛ̌ntud-tɛ ḿbídeʼ. ");
INSERT INTO bssNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Etondɛɛ ǎkwɛ ehíntɛ́n, ngɔn-nɛ éyəg nɛ́ɛ mekií. Ḿmɛ́n mekan mɛ́bɛnléd epun embáá é ehúmé é Sáŋgú édɛ̂hɔ́b bán épag. ");
INSERT INTO bssNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ene póndé kénzɛ́ɛ́ awě akwɛntɛ́né aá Yesuɛ adé mɔ́ Sáŋgwɛ́ɛ́ ǎkǔd eʼsoósoŋ.’ ” ");
INSERT INTO bssNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Petro ambád ámpē aá, “Á-bad bé Israɛl, nyélâm metúu nyéwôglɛn chǒm éche ńhɛdɛɛ́ ahɔ́b. Dyǒb dêmbɛ̌l Yesuɛ mod a Nazarɛt ábɛ̄l ndəle é mekan mé menyáké ne eʼchemléd âlúmed nyé nɛ́n aá mɔ́ mwěn-nɛɛ́ mɔ́lōmē mɔ́. Nyéběn nyêbíí nɛ̂ bwâm áyə̄le nɛ́n átîntê echɛ̂n dɔ́ɔ nɛ̂ dêmbɛnlédté. ");
INSERT INTO bssNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Dyǒb dêmmad abíi, ámād-tɛ atíi nɛ́n aá nyɛ́ɛ̄wūū Yesuɛ abɛ áde nyêmbɛ mɔ́ á mekáá mé bad bé ekɔyí, boŋ bébōmē-ʼɛ mɔ́ á awɔg. ");
INSERT INTO bssNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Boŋ kénɛ̂, Dyǒb dêmpuúd mɔ́, ahúd mɔ́ á metuné mé kwééd, áyə̄le kwééd eéhɛleʼaá-sɛ éhaŋ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dabidɛ anhɔ́b tə̂ŋgɛne mɔ́ aá, ‘Nnyínéʼáá Sáŋgwɛ́ɛ́ áwêm áʼsō-te póndé ésyə̄ə̄l. Adé mé á ekáá émbáá, né-ɔɔ́, meétāgɛ̄ɛ̄ áte. ");
INSERT INTO bssNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nɛ̂ ábɛ́lé nlóné ne menyiŋge nkale-ʼɛ pɔ́le ne menyiŋge mésyə̄ə̄l. Echem yə̌l-lɛ ámpē ěwālē eʼlyə́g bé nlém abɛ́ áde ńdíí á aloŋgé. ");
INSERT INTO bssNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Áyə̄le wéemwaá-sɛ edəə́dəŋ échêm émāānēd á mbwɔ́g e kwééd, wéemwaá-ʼɛ wɛ̌ ndim ḿme awôŋ mbəledɛ ḿbɔɔ á soŋ-tê. ");
INSERT INTO bssNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Elúmté mɛ menzii ḿme ḿpɛɛneʼ aloŋgé, abɛ́ áde wɛ́bɛ̄ɛ̄-ʼɛ mɛ á akéb mɛ̌bɛ̄ menyiŋge.’ ” ");
INSERT INTO bssNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Petro ambád ámpē aá, “A-baányaŋ, nlâŋge nyé ne aláa děn nɛ́n mɛɛ́ Dabidɛ awesyánē sáá ambáá, anwɛ́. Bénlīmē mɔ́, echě soŋ edé-ʼɛ hɛ́n kə́ə́ŋne chii. ");
INSERT INTO bssNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dabidɛ abédɛ́ɛ nkal éʼdəə́dəŋ, ambíí-ʼɛ chǒm éche Dyǒb dénhɔ̄bpē aá mɔ́ɔ̄bɛ mɔ́. Dyǒb démmwɛ̄ melɛ̌ nɛ́n aá mɔ́ɔ̄tēd mwǎn á mbyaa ḿme Dabidɛ mɔ́bɛl mɔ́ kə̂ŋ melemlem nɛ̂ŋgáne Dabidɛ ámbɛ̄ɛ̄ kə̂ŋ. ");
INSERT INTO bssNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dabidɛ ammǎd anyín áʼsō éʼ póndé, dyam áde Dyǒb dɛ́bɛnlé, né-ɔɔ́, anhɔ́b mam tə̂ŋgɛne mpuu ḿme Ane-awě-Béwɔ́gté. Anhɔ́b aá, ‘Dyǒb dénkêmmwaá aá ámaaned á mbwɔ́g e kwééd, ndim ménkêmbɔɔ́-aá mɔ́ á soŋ-tê.’ ");
INSERT INTO bssNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ane Yesuɛ mɔ́-ʼaá Dyǒb ápúúdté, sé moosyəə́l sêdé-ʼɛ mbóŋ bán apuúdé. ");
INSERT INTO bssNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Dyǒb ábágé mɔ́ atíi dé edúbé áwe ekáá émbáá. Abagé-ʼɛ mɔ́ Edəə́dəŋ éche Ésáá éche ánhɔ̄bpē aá mɔ́ɔ̄bɛ̌ mɔ́. Yesuɛ mɔ́-ʼɛ ábagé sé échê Edəə́dəŋ, chɔ́-ʼaá ékə́ə́ boŋ nyényīnēʼ, nyéwōgē-ʼɛ kéchéé échě ébɛnlad chii. ");
INSERT INTO bssNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Debíí nɛ́n bán Dabidɛ enkêmpumɛ́ɛ́, boŋ kénɛ̂ anhɔ́b aá, ‘Sáŋ Dyǒbɛ anláá awem Sáŋgwɛ́ɛ́ aá, Dyɛɛ́ áwêm ekáá embáá, ");
INSERT INTO bssNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kə́ə́ŋne á póndé echě mɛ́bɛnlé boŋ ékɔgtéd ábōŋ bad bé ekɔyí ámīn ne mekuu.’ ” ");
INSERT INTO bssNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Petro ambád ahɔ́b aá, “Né-ɔɔ́, nyé bad bé Israɛl bésyə̄ə̄l nyékoŋ abíi nɛ́n bán anɛ́n Yesuɛ awě nyébómmé á awɔg mwěn-naá Dyǒb dêmbɛnlé âbɛ́ Sáŋgwɛ́ɛ́ mɔ́-ʼaá adé Ane-awě-Béwɔ́gté.” ");
INSERT INTO bssNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Awóg áde ábê bad béwógé pɔ́le eche Petro, entagéd bɔ́ á mewêmtɛn-tê bwâmbwam. Hɛ́ɛ bésɛdtɛɛ́ Petro ne abíníí bembapɛɛ bé nlómag bánken, “A-baányaŋ, cheé-ɔ̄ sétə́ŋgɛ́né abɛl?” ");
INSERT INTO bssNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petro antimɛ́n bɔ́ aá, “Nyémod-tɛ́ɛ́ nyétimɛn Dyǒb, nyétɛde aloŋgé dé mbéb boŋ nyékud edusɛn á dǐn áde Yesu Krǐstəə, âbɛl nɛ́n Dyǒb álagsɛn nyé mbéb Dyǒb dɛ́bɛ̌-ʼɛ nyé echě ndɛ, Edəə́dəŋ éche Ésáá. ");
INSERT INTO bssNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nyébíi nɛ́n bán chǒm eche Dyǒb áhɔ́bé aá mɔ́ɔ̄bɛ nyé édíi áyə̄l echɛ̂n ne ábɛn bǎn ébɛ́-ʼɛ ké áyə̄l e bad ábe bédé nchabnede. Édé ne moosyəə́l awě Sáŋgwɛ́ɛ́ ádɛd Dyǒb, áchɛ́nlé âbɛ́ ne mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petro anléb bɔ́, aláá-ʼɛ bɔ́ mekan mémpēe híin. Ansím bɔ́ etúu áte ahɔ́b aá, “Mod-tɛ́ɛ́ ásoŋ ádē aloŋgé, ésebɛ́ nɛ̂, né Dyǒb dɛ́kɔ̄gsɛ̄n nyé melemlem ngáne ákɔ̄gsɛ̄nnē enɛ́n nyoŋgɛl e ebébted.” ");
INSERT INTO bssNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bad híin béndūbē dyam áde Petro ánhɔ̄bpē bédusɛ́n-nɛ bɔ́. Ḿmê mbwɛ mesoŋgé mé bad ḿme mémbād ámīn e bad ábe béndūbē, mébédé dyam eʼkə́lé éʼláán. ");
INSERT INTO bssNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bêmbané nlém âyə́ge mekan ḿme bembapɛɛ bé nlómag béyə́gtéʼáá bɔ́, bébɛ́-ʼɛ nlatɛ́n ne bad ábe bédúbpé Krǐstəə. Bɔ́ɔ̄bɔ̄ɔ békānnēʼ, bédyāg-kɛ ndyééd hǒm ahɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Bembapɛɛ bé nlómag bébɛ́léʼáá menyáké, bélūmtē-ʼɛ eʼchemléd híin. Kénzɛ́ɛ́ awě annyín antágé nsəl áte. ");
INSERT INTO bssNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bad bésyə̄ə̄l ábe béndūbē Yesuɛ bémbɛ̄ békɛɛneʼ nlatɛ́n áʼsō. Chǒm-tɛ́-ʼɛ éche mod ánwōŋgē ébédé é moosyəə́l. ");
INSERT INTO bssNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bésómáá-ʼáá bwěm, békāb ne mod-tɛ́ ngáne ántōgnɛ̄nnē. ");
INSERT INTO bssNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Béyɔ́gkéʼáá aladɛn hǒm ahɔ́g epun-tɛ́ á Ndáb-e-Dyǒb âkáne. Bédyágéʼáá ndyééd hǒm ahɔ́g áwāb mendáb ne nlém nhɔ́g ne menyiŋge mésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Békɛ́néʼáá Dyǒb, bad bésyə̄ə̄l béwóón-nɛ bɔ́ nlém ḿ bwâm. Epun-tɛ́-ʼɛ Dyǒb ábádáá bad ábe békúdé eʼsoósoŋ ámīn e mesoŋgé mé bad ábe bédúbpé. ");
INSERT INTO bssNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Mbwɛ nhɔ́g Petro bɔ́ Jɔn békágéʼáá á Ndáb-e-Dyǒb. Nɛ́n ábédé á ngə́ŋ éláán é mǔte, póndé echě bad béyɔ́gkéʼáá akɛ á mekáne. ");
INSERT INTO bssNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mod nhɔ́g mɔ́-ʼɛ ambɛ́ á mmwɛ mé eyáde é Ndáb-e-Dyǒb. Béchə́géʼáá ḿmê mmwɛ bán, Mmwɛ ḿme Ḿbóó. Ane mod anwɛ́ epɛd se áde béchyáá mɔ́. Epun-tɛ́ bépéméʼáá mɔ́, bébānē mɔ́ á mmwɛ hɛ̂, áchɔ̄mē mɔné wɛ́ɛ bad ábe békágéʼáá á Ndáb-e-Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Anyín áde ányíné Petro bɔ́ Jɔn bésɔ́leʼ á Ndáb-e-Dyǒb-te, anchɔ́m bɔ́ ndɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Dɔ́ɔ bénɔnɛɛ́ mɔ́ chóóŋ, boŋ Petro áhɔ̄bē aá, “Nɔnéʼ sé!” ");
INSERT INTO bssNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Hɛ́ɛ ane mod ánɔ́né bɔ́ ne mewêmtɛn nɛ́n aá mɔ́ɔkǔd chǒm áwāb. ");
INSERT INTO bssNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Dɔ́ɔ Petro áhɔ́bɛɛ́ aá, “Meewóoʼɛ́ mɔné ké nhɔ́g boŋ chǒm éche ńwóó chɔ́ɔ mɛ́bɛɛ́ wɛ. Á dǐn áde Yesu Krǐstəə a Nazarɛt, hidé ásē, ékag!” ");
INSERT INTO bssNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Dɔ́ɔ Petro áchə́ŋgé ane mod ekáá émbáá, boŋ áwōŋgān mɔ́ âtyéem ámīn. Ábwɔ̄g-ábwɔ̄g mekuu ne mekɔ́ge ḿmē ane mod ménwēdned. ");
INSERT INTO bssNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Anhěb, atyéém ámīn, ábootéd-tɛ akɛ. Ansɔ́l á Ndáb-e-Dyǒb ne Petro bɔ́ Jɔn, ákag, áhebéʼ ámīn, ábagé-ʼɛ Dyǒb mekɛnag. ");
INSERT INTO bssNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bad bésyə̄ə̄l ábe bébédé áhed bényīn nɛ́ɛ ákagké ákēmtē-ʼɛ Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Bênchem mɔ́ bán mɔ́ abédé mod awě adyɛɛ́ʼáá á Mmwɛ ḿme Ḿbóó ń Ndáb-e-Dyǒb áchɔ̄mē bwěm. Yə̌l enkɔ́m bɔ́ áte, bébɛ́-ʼɛ menyáké ne dyam áde ábɛ́nlédé ne mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Yə̌l enkɔ́m bad bésyə̄ə̄l áte ábe bémbɛ̄ á Ndáb-e-Dyǒb. Né-ɔɔ́ bênnyəgéd békɛ bétán Petro bɔ́ Jɔn á abebpé á Ndáb-e-Dyǒb áde béchə́géʼáá bán Abebpé áde Solomonɛ. Ene póndé ane mod awě Petro bɔ́ Jɔn bênchoódté, ambɛ́ áhídé bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Áde Petro ányíné ábê bad, anláá bɔ́ aá, “A-bǎnned bé Israɛl, cheé ékə́ə́ boŋ nɛ́n ákɔ̄mtēʼ nyé yə̌l áte? Chán-nɔ̄ nyénɔnɛɛ́ sé nɛ̂? Nyêwêmtan nɛ́n bán échɛd ngíne chěn, kéʼɛ asáŋ ádě sésáá áʼsō éʼ Dyǒb dɔ́ɔ ákə́ə́ boŋ sébɛl anɛ́n mod ábootéd akɛ-yɛ? ");
INSERT INTO bssNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Dyǒb áde Abrahamɛ, Aisigɛ ne Jakɔbɛ bébɛnlɛɛ́, nɛ́dē Dyǒb ádé ábɛ̄d betaa, álúmté ehúmé éche awe mbəledɛ Yesuɛ. Nyêmbɛ mɔ́ á mekáá mé benkamlɛnɛ, nyêbáŋ-ʼɛ mɔ́ áyə̄l áʼsō wɛ́ɛ Payledɛ. Ké áde Payledɛ ánwēmtɛ̄nnē mɔ́ atɛde, nyêmbɛ́ nyêbáŋ mɔ́ áyə̄l. ");
INSERT INTO bssNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Abédé mod awě asáá, abɛ́-ʼɛ ane awě abɛle mekan ḿme métə́ŋgɛ́né, boŋ nyêmbáŋ mɔ́ áyə̄l. Nyêntǐm nyéchāāʼ Payledɛ bán áchenned nyé mod awě awúɛʼ bad. ");
INSERT INTO bssNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Né-ɔɔ́ nyênkə̌ŋ béwúú mod awě apiinad bad aloŋgé á mbále, boŋ Dyǒb dêmpuúd mɔ́. Séběn sênyínné ḿmê mekan dǐd. ");
INSERT INTO bssNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Anɛ́n mod awě nyényínɛɛ́ nɛ́n, awě nyébíí-ʼɛ bwâm, ngíne echě dǐn áde Yesuɛ áwóó ne adúbe áde áwóó ne adúbe áde áwánlé áyə̄le ádê dǐn, dɔ́ɔ ábágé anɛ́n mod awě anwɛ́ epɛd ngíne, ádīd-tɛ mɔ́ bwâm. Nyé běn nyênyíné-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Bɔɔb-pɔɔ́, a-baányaŋ mbíí nɛ́n mɛɛ́, kéchéé éche nyáābe ábɛn belyə́ged nyêmbɛnlé Yesuɛ, nyêmbɛ̌l chɔ́ áyə̄le nyênkêmbííʼɛ́ chǒm éche nyébɛlɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kénɛ́ɛ ébɛ́nlédé-ʼaá nɛ̂, Dyǒb děn dɔ́ɔ álónté ábē eʼyale seʼ bɔɔ́d áde ánlāāʼɛ́ bekal béʼdəə́dəŋ bésyə̄ə̄l aá béhɔ̂b bán Ane-awě-Béwɔ́gté ǎkǔd metake. ");
INSERT INTO bssNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Né-ɔɔ́, nyétɛde ádɛn abɛ́ dé mbéb, nyétimɛn Dyǒb âbɛl boŋ ábɔ́ded nyé mbéb. ");
INSERT INTO bssNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nzé nyêbɛlé nɛ̂, né póndé ěpɛ̌ echě Sáŋgwɛ́ɛ́ áhɔ́ɔ́dté nyé nlém. Ene póndé-ʼaá álōmɛ̄ɛ̄ nyé Ane-awě-Béwɔ́gté, nɛ́dē Yesuɛ, awě ápwɛ́dté nyé. ");
INSERT INTO bssNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yesuɛ atə́ŋgɛ́né asébe dé adyɛɛ ádyōb kə́ə́ŋ póndé épɛ echě Dyǒb dɛ́həŋlɛ́nné mekan mésyə̄ə̄l boŋ métim ekɔ́ɔ́lé. Nɛ́n dɔ́ɔ Dyǒb dêmbɛnlé seʼ bɔɔ́d aá bekal béʼdəə́dəŋ ábe bésáá béláa bad. ");
INSERT INTO bssNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mosɛɛ mwěn anhɔ́b aá, ‘Sáŋgwɛ́ɛ́ awě adé ádɛn Dyǒb ǎpwɛdé nyé nkal éʼdəə́dəŋ átîntê e ábɛ̄n bad melemlem nɛ́ɛ mɛ. Nyébɛl chǒm ésyə̄ə̄l éche áláŋgé nyé aá nyébɛl. ");
INSERT INTO bssNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kénzɛ́ɛ́ awě eewógne ane nkal éʼdəə́dəŋ, Dyǒb dɛ́hūd mɔ́ átîntê e bad bé Dyǒb abɔ́déd-tɛ mɔ́.’ ");
INSERT INTO bssNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Bekal béʼdəə́dəŋ ábíníí ámpē bootya Samwɛlɛ ne ábe bêmpɛ̌ ámbīd echê, bɔ́ moosyəə́l bénwālē nlébtéd, béhɔ́b-pɛ mekan ḿme mɛ́bɛnléd ḿmɛ́n mesú. ");
INSERT INTO bssNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Dyam áde Dyǒb dénhɔ̄bpē mbwiined ne bekal béʼdəə́dəŋ ábédɛ́ɛ áyə̄l echɛ̂n, nyémpē nyêwóó-ʼɛ akab áyə̄le melɛ̌ ḿme Dyǒb démmwɛ̄ɛ̄ ne ábɛ̄n betaa. Dyǒb dénlāā Abrahamɛ aá, ‘Mɛ̌naméd moonyoŋ asyəə́l á nkǒŋsé mbwiined ne ḿmôŋ nchyáátɛ́n.’ ");
INSERT INTO bssNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Né-ɔɔ́, Dyǒb dêmpwɛ̌d awě mbəledɛ. Áde ápwɛ́dé mɔ́, áwɛ̄n dɔ́ɔ ánsēbɛ̄ɛ̄ mɔ́ alóm ânamed nyé abɛl áde ábɛnlé boŋ nyétɛ̄dē ḿmɛ̄n mbeltéd mé mbéb.” ");
INSERT INTO bssNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petro bɔ́ Jɔn bédíi békánléʼáá bad mekan, dɔ́ɔ nguse é beprisɛ ne mod ambáá a plûsɛ a Ndáb-e-Dyǒb, ne nguse e Besadusia bépédé wɛ́ɛ bémbɛ̄ɛ̄. ");
INSERT INTO bssNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bênlǐŋ áyə̄le ábɛ̂ bembapɛɛ bé nlómag bébɛ béyə́gtéʼáá bad bán Yesuɛ apuúdé, éche élûmte nɛ́n bán bad ábe béwédé bɛ́bē á aloŋgé ámpē. ");
INSERT INTO bssNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bénkōb Petro bɔ́ Jɔnɛ béhɛ́ bɔ́ á mbwɔg. Ngáne bǐn bêmmadté ahín, bémbɛ̄ áhed kə́ə́ŋ ne mbwɛmbwɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kénɛ́ɛ bénkōbpē Petro bɔ́ Jɔnɛ, ndun e mod eche enwóg mam ḿme békánléʼáá bɔ́, endúbe. Mesoŋgé mé bad ábe bédúbpé ménchə̄gē mépɛ̄ dyam eʼkə́lé éʼ bad éʼtáan. ");
INSERT INTO bssNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nɛ́ɛ bǐn éʼsáŋgé, benkamlɛnɛ bé Israɛl, bad bémbáá bé dyad ne bemeléede bé mbéndé bênladɛ́n áte á Jerusalɛm. ");
INSERT INTO bssNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anasɛ awě abédé prisɛ ambáámbáa ambɛ́ áhed, ne Kaifasɛ, Jɔnɛ, Alɛsandaa ne bad bémpēe ábe bédé á túmbé echě Prisɛ Ambáámbáa. ");
INSERT INTO bssNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Béntīī Petro bɔ́ Jɔnɛ áwab eʼsó-te, boŋ bésɛdté bɔ́ bánken “Chán nyémwédé anɛ́n mod awě anwɛ́ epɛd bwâm adid? Ngíne ne dǐn áde nzɛ́ɛ́ nyébɛ́nlédé?” ");
INSERT INTO bssNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Hɛ́ɛ Edəə́dəŋ éche Ésáá épíídé Petro, élón-nɛ mɔ́ áte. Dɔ́ɔ áhɔ́bɛɛ́ aá, “Á-benkamlɛnɛ ne bad bémbáá bé dyad, ");
INSERT INTO bssNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","nyêchəgé sé hɛ́n chii âkáad sé áyə̄le mboŋ ḿme sébɛ́nlé anɛ́n mod awě anwɛ́ epɛd ne ngáne ámwédé bwâm adyɛɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nyé bad bé Israɛl nyébíi-ɔɔ́ nɛ́n bán anɛ́n mod awě atyéémé nyé áʼsō-te adyɛɛ́ bwâm á ngíne e dǐn áde Yesu Krǐstəə, mod a Nazarɛt. Nyêmbomé mɔ́ á awɔg boŋ Dyǒb dêmpuúd mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Mɔ́ adé ane awě éténlédé á kálag e Dyǒb áyə̄l echê nɛ́n bán, ‘Aláá áde belóŋ bé ndáb bênchenɛ́ɛ́ dɔ́ɔ átímé aláá dé etógnɛ́n.’ ");
INSERT INTO bssNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Eʼsoósoŋ béesaá ne mod ampée éetómɛɛ́ Yesuɛ, áyə̄le dǐn démpēe déesaá á nkǒŋsé-te wɛ́n áde Dyǒb ábágé moonyoŋ áde átə́ŋgɛ́né syánē asoŋ.” ");
INSERT INTO bssNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bɔɔb-pɔɔ́, yə̌l enkɔ́m bad bé kóte áte ânyín nɛ́n bán Petro bɔ́ Jɔnɛ béhɔ́bé ésebán mbwɔ́g ké nhɔ́g ńdé bɔ́ áte. Bénsōŋtɛ̄n-nɛ nɛ́n bán bédíi bad bé ngɛ̂n ábe béeyə́gké kálag embáá. Dɔ́ɔ béchémé nɛ́n bán bɔ́ɔ bébágéʼáá póndé ésyə̄ə̄l ne Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Boŋ ngáne bénnyīnnē nɛ́ɛ mod awě Petro bɔ́ Jɔnɛ bênchoódté átyéémé áhed ne bɔ́, dyam dénkêmboŋgé bɔ́ ahɔ́b. ");
INSERT INTO bssNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Né-ɔɔ́, bénlāā bɔ́ bán bébîd á ndáb e kóte. Bébídé-ʼaá bɔ́, běn ne běn bébootéd akal, ");
INSERT INTO bssNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","bésɛdté bánken, “Chán dɛ́bɛnlé ábɛ́n bad? Moosyəə́l á Jerusalɛm abíí aá bɔ́ɔ bébɛ́lé enɛ́n ndəle e menyáké. Deéhɛ̄lɛ̄ɛ̄-sɛ dehɔ́b bán béebɛlɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Boŋ detə́ŋgɛ́né ábɛ́n bad etúu asím áte nɛ́n bán bésôg bad akale tə̂ŋgɛne Yesuɛ, âbɛl boŋ ḿmɛ́n nkalaŋ méekanlád se nkag áʼsō.” ");
INSERT INTO bssNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Dɔ́ɔ béchɛ́nlé bɔ́ ámbīd ámpē boŋ bésīmē bɔ́ etúu áte bán béehɛdɛ́ɛ́ awóg ámpē mbêd nɛ́ɛ béhɔ́bɛɛ́ kéʼɛ béyə́gtɛɛ́ á dǐn áde Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Boŋ Petro bɔ́ Jɔn bêntimtɛ́n bɔ́ bán, “Nyé běn nyéhɔ̂b chǒm-ɛ́ɛ étə́ŋgɛ́né áʼsō éʼ Dyǒb. Âwógɛn nyé káa âwógɛn Dyǒb? ");
INSERT INTO bssNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Áyə̄le sé pɛn séēhɛ̄lɛ̄ɛ̄-sɛ sédīb nsəl bán séekanlé mam ḿme sé běn sényínné dǐd sêwógɛ́n-nɛ etúu.” ");
INSERT INTO bssNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bad bé kóte bênlyə̌g bésím bɔ́ etúu áte ngíne ngíne. Ámbīd enɛ̂ bênchené bɔ́, áyə̄le bénkênyínné nzii echě béhɛle békɔ́gsɛ́n bɔ́ áyə̄le bad bésyə̄ə̄l békémtéʼáá Dyǒb tə̂ŋgɛne dyam áde ábɛ́nlédé. ");
INSERT INTO bssNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mod awě menyáké mêmbɛnlédté áyə̄l boŋ ádyɛ̄ɛ̄ bwâm antóm móom mé mwɛ̌ méniin. ");
INSERT INTO bssNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Áde bad bé kóte bétɛ́dté Petro bɔ́ Jɔnɛ, bênkɛ̌ echoŋ é bad bé Krǐsto atán, béláá bɔ́ mam ḿme beprisɛ bémbáá ne bad bémbáá bé kóte béláŋgé bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Áde ábê bad bé Krǐsto béwógé nɛ̂, bênlǎd nsəl âkáne. Bénlāā Dyǒb bán, “Titɛ́ɛ, wɛ awě ehəgé nkoŋ ḿ mín ne ń sé, edíb é nkwɛ̌ ne bwěm éʼsyə̄ə̄l ábe éʼdé bɔ́ áte, ");
INSERT INTO bssNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","wenlóm Edəə́dəŋ éche Ésáá wɛ́ɛ echɛd sáŋ ambáá Dabidɛ, awôŋ mbəledɛ wɛɛ́ ébɛl áhɔ̂b ábɛ́n eʼyale nɛ́n aá, ‘Cheé ékə́ə́ boŋ bad ábe béesɛ̌ bad bé Israɛl béliɛʼ bwâmbwam? Cheé ékə́ə́-ʼɛ boŋ bad bébɛlé eʼhəké ngɛ̂n? ");
INSERT INTO bssNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kə̂ŋ é nkǒŋsé élade yə̌l, benkamlɛnɛ-ʼɛ ámpē békóbe mbom âtə́ŋgɛn Sáŋ Dyǒbɛ ne Ane-awě-Áwɔ́gté.’ ");
INSERT INTO bssNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ébɛ́nlédé nɛ̂ děn. Hɛrɔdɛ bɔ́ Pontus Payledɛ bénkōb mbom á dyad-tê hɛ́n ne bad ábe béesɛ̌ bad bé Israɛl ne belyə́ged bé bad bé Israɛl. Bêmbɛl nɛ̂ âhəge Yesuɛ awôŋ mbəledɛ awě Asáá awě Éwɔ́gté. ");
INSERT INTO bssNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bénkōb mbom âbɛl mam ḿme mmǒŋ wɛ̂mmadté atíi ne echoŋ ngíne áʼsō éʼ póndé mɛ́bɛnléd. ");
INSERT INTO bssNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","A-Sáŋ, bɔɔb-pɔɔ́, mmǒn énɔn akím áde békímɛɛ́, ébɛ sé ábôŋ bembəledɛ nlém âkal échôŋ eyale ésebán sêwóge mbwɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Lúméd echoŋ ngíne édide bad bwâm. Ébɛl-lɛ séhɛl eʼchemléd ne menyáké abɛl á dǐn áde Yesuɛ, awôŋ mbəledɛ awě asáá.” ");
INSERT INTO bssNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bémáá-ʼaá akáne, hǒm áde bênladɛ́nné áte ánəŋned. Bɔ́ moosyəə́l bénlōn ne Edəə́dəŋ éche Ésáá bébootéd-tɛ eyale é Dyǒb akal ésebán mbwɔ́g ńdé bɔ́ áte. ");
INSERT INTO bssNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Bad bésyə̄ə̄l ábe bédúbpé bénwōŋ nlém nhɔ́g ne mewêmtɛn mehɔ́g. Modmod eehɔ́beʼaá aá mɔ́ɔ mɔ́wōō échɛ́n kéʼɛ échíníí boŋ bwěm éʼsyə̄ə̄l bémbɛ̄ bɔ́ ntɛ́d. ");
INSERT INTO bssNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Bembapɛɛ bé nlómag bémbɛ̄ békaléʼ ne ngíne esyəə́l nɛ́n bán bédé mbóŋ nɛ́n bán Dyǒb ápúúdté Sáŋgú Yesuɛ. Dyǒb-pɛ démbād bɔ́ nsimé abɛ ámīn e nsimé. ");
INSERT INTO bssNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Modmod eetógeʼaá chǒm átîntê echâb. Póndé ne póndé tɛ́ bad ábɛ̌ bénwōŋ eʼtúú kéʼɛ ndáb bésóméʼáá chɔ́, bépɛ̄ɛ̄n ḿmê mɔné, ");
INSERT INTO bssNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","bébɛ̄ bembapɛɛ bé nlómag, bɔ́-ʼɛ bétédéʼáá békāb ne mod-tɛ́ɛ́ ngáne ántōgnɛ̄nnē. ");
INSERT INTO bssNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nê dɔ́ɔ Josɛbɛ, mod a túmbé e Levi awě béchyáá á aloŋ á Sayprus âmbɛnlé. Bembapɛɛ bé nlómag béchə́géʼáá mɔ́ bán Banabasɛ, (nɛ́dē mod awě awéde bad nlém á abum.) ");
INSERT INTO bssNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ansóm etúú, atéd ḿmê mɔné, ábɛ wɛ́ɛ bembapɛɛ bé nlómag. ");
INSERT INTO bssNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mod nhɔ́g abédé bán Ananiasɛ, mwaád-tɛ bán Safiraa. Bɔ́mpē bénsōm doŋge á bwěm ádāb. ");
INSERT INTO bssNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Boŋ ankoó doŋge á mɔné ámbīd, mwaád-tɛ ámpē ambíi. Ananiasɛ ampɛɛ́n mɔné ḿme mênlyə̌g ásē wɛ́ɛ bembapɛɛ bé nlómag. ");
INSERT INTO bssNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Hɛ́ɛ Petro álâŋgɛɛ́ mɔ́ nɛ́n aá, “Á-Ananias, cheé ékə́ə́ boŋ ehɛ́ Satanɛ etə́l wɛɛ́ ásɔl wɛ á nlém-tê. Bɔɔb-pɔɔ́, abɛlé wɛ ekǎnlé Edəə́dəŋ éche Ésáá metóm akoo áde ékóŋgé epɛd é mɔné ḿme ésómné bwěm. ");
INSERT INTO bssNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Edɛ̂hɔ́b wɛ̌ mɔ́sōmeʼ etúú ébédɛ́ɛ échoŋ, áde émáá-ʼɛ chɔ́ asóm ámpē, mɔné ḿmed ḿbédɛ́ɛ ḿmôŋ. Cheé ékə́ə́ boŋ etíí áwôŋ nlém-tê wɛɛ́ mɔ́bɛl enɛ́n ndín e akan? Saké moonyoŋ ékánlé metóm boŋ Dyǒb dɔ́ɔ ékánlé metóm!” ");
INSERT INTO bssNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Awóg áde Ananiasɛ áwógé nɛ́n, anhún ásē, awɛ́-ʼɛ. Mbwɔ́g ń ngíne ménkōb bad bésyə̄ə̄l ábe bénwōg ádɛ́n dyam. ");
INSERT INTO bssNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Kɔ́débad êmpɛ̌ áhed, bétéd mɔ́ ndim, békaŋ mɔ́ békɛ bélīme. ");
INSERT INTO bssNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Dyam háwa éláán ámbīd enɛ̂, Ananiasɛ mwaád ampɛ̌, enkêmbííʼɛ́ pɛn dyam áde ábɛ́nlédé. ");
INSERT INTO bssNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petro ansɛdéd mɔ́ aá, “Láá mɛ, mɔné ńsyə̄ə̄l mɛ́n ḿme nyékúdé áyə̄l e etúú éche nyé awoŋ nchóm nyénsōmmē-yɛ?” Safiraa ankwɛntɛ́n mɔ́ aá, “Ɛɛ, ńsyə̄ə̄l mɛ̂.” ");
INSERT INTO bssNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Dɔ́ɔ Petro álâŋgɛɛ́ mɔ́ aá, “Cheé ékə́ə́ boŋ nyékəgéʼ Edəə́dəŋ éche Sáŋgwɛ́ɛ́? Nɔnéʼ, bad ábe bélímmé awoŋ nchóm bɔ́ɔ̄ bédé á mmwɛ níníí, bɛ́tēd-tɛ wɛ́mpē ndim hɛ̂ bɔɔb.” ");
INSERT INTO bssNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ábwɔ̄g-ábwɔ̄g ane mmwaád anhún ásē áʼsō-te wɛ́ɛ Petro, awɛ́-ʼɛ. Échê kɔ́débad énsɔ̄l á ndáb-te bényín bán amaá awɛ́. Dɔ́ɔ bébídné mɔ́ ndim á ebwɔ́g békɛ bélímé á nkəg ń soŋ wɛ́ɛ nchóm. ");
INSERT INTO bssNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Mbwɔ́g ń ngíne ménkōb mwembé ńsyə̄ə̄l ne bad bésyə̄ə̄l ábe bénwōg ádɛ́n dyam. ");
INSERT INTO bssNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Bembapɛɛ bé nlómag bébɛ́léʼáá eʼchemléd ne menyáké híin átîntê e bad. Bad ábe bédúbpé-ʼɛ béyɔ́gkéʼáá abom nɛ́ɛ mod nhɔ́g á Abepé á Solomonɛ á Ndáb-e-Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kénɛ́ɛ bad béchə́géʼáá bɔ́ dǐn á bwâm, bédíi bébááʼáá bɔ́ alatɛn. ");
INSERT INTO bssNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Boŋ kénɛ̂, ekud é bebaád ne baachóm ábe bédúbpé Sáŋgú Yesuɛ, bésɔ́léʼáá áwāb nlatɛ́n, mesoŋgé mé bad ábe bédúbpé ńchə́gkeʼ. ");
INSERT INTO bssNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Mekan ḿme bembapɛɛ bé nlómag bébɛ́léʼáá mênkə̌ŋ bad bépēmē bad bé nkole bébannéʼ bɔ́ á nkəg ń nzii á menɔŋ ne á eʼbúm mîn. Bébéléʼáá nɛ̂ ne mewêmtɛn nɛ́n bán, nzé Petro atómeʼ ké tómɛ́n échē edəə́dəŋ éhūn bɔ́ á yə̌l bédyɛ̄ɛ̄ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ekud é bad émbīd kə́ə́ŋne á myad ḿme médé bɛnbɛn ne dyad á Jerusalɛm. Bénwālē ábāb bad bé nkole áyə̄l ne bad ábe eʼdəə́dəŋ bé mbéb éʼtágtéʼáá. Bembapɛɛ bé nlómag bêndǐd moosyəə́l bwâm. ");
INSERT INTO bssNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ene póndé-ʼɔɔ́ prisɛ ambáámbáa ne échē echoŋ é bad nɛ́dē, bad bé epepé é Besadusia bémbɛ̄ kɔ́njí bwâmbwam ne bembapɛɛ bé nlómag. ");
INSERT INTO bssNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bénkōb bembapɛɛ bé nlómag, béhɛ́ bɔ́ á ndáb e mbwɔg ḿme ńdé á dyad tê. ");
INSERT INTO bssNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Boŋ ḿmê nkuu, ángɛl e Sáŋgú enhyɛ̌ ekob é mbwɔg adibe ebídéd-tɛ bɔ́. Enláá bɔ́ aá, ");
INSERT INTO bssNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Nyékag á ndáb e Dyǒb, nyélâŋgeʼ bad mam mésyə̄ə̄l tə̂ŋgɛne ádɛ́n aloŋgé dékɔ̄ɔ̄lē.” ");
INSERT INTO bssNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Bembapɛɛ bé nlómag bénwōgɛ̄n ene ángɛl. Bǐn éʼsáŋgé-ʼaá, békɛ bésɔ́l á Ndáb-e-Dyǒb, bébootéd bad ayə́ged. Ene póndé-ʼáá prisɛ ambáámbáa ne échē echoŋ é bad, bénchɛ̄lē mbom ḿ mbwɔ́g ḿme ménlǎd belyə́ged bé Israɛl bésyə̄ə̄l. Á mbom hɛ̂ dɔ́ɔ bélómé nlébtéd á mbwɔg nɛ́n bán bépɛɛn bembapɛɛ bé nlómag áwāb. ");
INSERT INTO bssNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Boŋ áde sə́nze épédé á ndáb e mbwɔg, bénkêntánné bembapɛɛ bé nlómag áwēd-te. Né-ɔɔ́ bêntǐm ámbīd, békɛ béláá ábê bad á mbom bán, ");
INSERT INTO bssNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Sêpedé á ndáb e mbwɔg, sêtáné ngáne bépéné chɔ́ hǒm ásyə̄ə̄l. Bad ábe bénɔneʼ mbwɔg-kɛ bɔ́ moosyəə́l bédé wɛ́ɛ mod-tɛ́ ánɔnɛɛ́ mmwɛ mé eʼkɛ́. Boŋ ádě sédíbpé ekob, séetánɛɛ́ mod ké nhɔ́g áwēd-te.” ");
INSERT INTO bssNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Áde mod ambáá a plûsɛ é ndáb e Dyǒb ne beprisɛ bémbáá béwógé nɛ̂, bényāg, bánken “Chán nɛ́n ádíí?” ");
INSERT INTO bssNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Hɛ̂ dɔ́ɔ mod nhɔ́g ápédé áhed boŋ álāŋgē bɔ́ aá, “Nyébíi nɛ́n bán bad ábe nyénhɛ̄ɛ̄ á mbwɔg, bédé á Ndáb-e-Dyǒb béyə́gteʼ bad.” ");
INSERT INTO bssNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Dɔ́ɔ mod ambáá a plǔsɛ é Ndáb-e-Dyǒb ábídé ne ábē bad, boŋ békɛ békōbēʼ bembapɛɛ bé nlómag, bépɛɛnéʼ bɔ́. Boŋ pɛn bénkênkóbɛ́nné bɔ́ ewaŋge áyə̄le bébááʼáá bán bad ábe bémbɛ̄ áhed bɛ́lūm bɔ́ meláá. ");
INSERT INTO bssNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bénsɔ̄lɛ̄n bɔ́ á ndáb-te, bétíí bɔ́ áʼsō éʼ mbwɔ́g. Hɛ̂ dɔ́ɔ prisɛ ambáámbáa ábóótédé bɔ́ akáad, áláŋgé bɔ́ nɛ́n aá, ");
INSERT INTO bssNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Sênsím nyé etúu áte nɛ́n bán nyéēkɛɛnéʼ ayə́ge áde anɛ́n mod áʼsō ámpē. Bɔɔb-pɔɔ́, Nyénɔneʼ chǒm-ɛ́ɛ nyébɛ́lé. Nyêbɛlé moosyəə́l á Jerusalɛm awógé ádɛ́n ayə́ge. Nyêhɛde-ʼɛ kwééd echê abán áwɛd nló.” ");
INSERT INTO bssNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Hɛ́ɛ Petro ne ábíníí bembapɛɛ bé nlómag bétimtanné bɔ́ bán “Dyǒb dɔ́ɔ sétə́ŋgɛ́né awógɛn, saké baányoŋ. ");
INSERT INTO bssNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Áde nyémáá Yesuɛ abome á awɔg, nyêwúú-ʼɛ mɔ́, Dyǒb áde ábɛ̄d betaa, dêmpuúd mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dyǒb dénchə̄gēd mɔ́, ábānē-ʼɛ mɔ́ á ekáá é mbáá nɛ́ɛ Nlyə́ged ne Nsoodɛ. Ambɛ̌l nɛ̂ âbɛl boŋ álúmed bad bé Israɛl nzii eche bɛ́chenɛ́ɛ́ ádab abɛ́ dé mbéb boŋ Dyǒb álagsɛ́n bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Séběn sênyínné ḿmɛ́n mekan dǐd. Edəə́dəŋ éche Ésáá chɔ́mpē ébídeʼ mbóŋ. Chɔ́-ʼaá édé ndɛ echě Dyǒb ábagɛɛ́ bad ábe béwógne mɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Áde mbwɔ́g eche endyɛɛ́ ásē éwógé nɛ̂, bênliŋ bwâmbwam kə́ə́ŋ béhɛdé-ʼɛ bán béwúu bembapɛɛ bé nlómag. ");
INSERT INTO bssNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Boŋ mod a mbwɔ́g nhɔ́g átîntê echâb, awě béchə́géʼáá bán Gamaliɛlɛ antyéém ámīn. Anɛ́n mod abédɛ́ɛ Farisia, abɛ́-ʼɛ meléede a mbéndé awě bad bésyə̄ə̄l bébágéʼáá edúbé bwâmbwam. Anhɔ́b aá bésébe bébídɛn ábɛ̂ bembapɛɛ bé nlómag á ebwɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Dɔ́ɔ álâŋgɛɛ́ bad bé mbwɔ́g aá, “A-baányaŋ bé Israɛl, nyétêd póndé ne chǒm-ɛ́ɛ nyéhɛdɛɛ́ ábén bad abɛl. ");
INSERT INTO bssNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Éēchābɛ̄ɛ̄ áte áde mod awě béchə́géʼáá bán Tiodasɛ ábídáá dúu, ákuméʼ ekáá á tə̂l aá mɔ́dē mod. Bad ábe bénhīd mɔ́ ámbīd bébédé dyam mbwɔ́kɛl éniin. Boŋ kə́ə́ŋ ne á asóg bénwūū mɔ́, ábê bad-tɛ bépáŋtéd áte, échê epepé chɔ́-ʼɛ ébɔ́ɔ. ");
INSERT INTO bssNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ámbīd e póndé, mod awe béchə́géʼáá bán Judasɛ mod a Galilia mɔ́mpē ámbīd á póndé e tóŋgé. Ambɛ̌l ndun e mod enhíd mɔ́mpē boŋ kə́ə́ŋne á asóg bénwūū mɔ́, ábē bad-tɛ bépáŋtéd áte. ");
INSERT INTO bssNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Bɔɔb-pɔɔ́, áyə̄le ádɛ́n dyam, nlâŋge nyé nɛ́n mɛɛ́ nyétɛde ábɛ́n bad békag, nyéēbɛ̄lē bɔ́ dyam. Áyə̄le nzé édé nɛ́n bán ḿmɛ́n ntíi kéʼɛ ádɛ́n dyam áhúú ne moonyoŋ, né děn dɛ́kwɛ̌. ");
INSERT INTO bssNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Boŋ nzé édé bán áhúú ne Dyǒb, né nyéehɛnlé bɔ́ dyam abɛl, né kə́ə́ŋne á ásóg nyɛ́ɛ̄nyīn bán Dyǒb dɔ́ɔ nyétə̂ŋganné.” Bad bé mbwɔ́g bênkǒb elébé éche Gamaliɛlɛ ");
INSERT INTO bssNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Hɛ́ɛ béchɛ́nlé bembapɛɛ bé nlómag bán bésɔ̂l á ndáb. Bénkūdē bɔ́, bésím-mɛ bɔ́ etúu áte bán béehɛdɛɛ́ awóg ámpē nɛ́ɛ bétúbɛɛ́ dǐn áde Yesuɛ. Dɔ́ɔ bétɛ́dté bɔ́ bán békag. ");
INSERT INTO bssNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bembapɛɛ bé nlómag bênysəə́ áʼsō éʼ mbwɔ́g. Bémbɛ̄ menyiŋge ânyín nɛ́n Dyǒb ányíné aá békwógnédé âkud akwáké á dǐn áde Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Epun ne epun-tɛ́ békágéʼáá á ndáb e Dyǒb ne á ndáb é bad, béyə̄gtē bad, békale-ʼɛ nkalaŋ ḿme Yesuɛ, Ane-awě-Béwɔ́gté. ");
INSERT INTO bssNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Bɔɔb-pɔɔ́, ngáne mesoŋgé mé bad ábe bédúbpé méchə́gkéʼáá achə́ge ne achə́ge, nswaŋtɛn mémbīd átîntê e bad bé Israɛl ábe béhɔ́béʼáá ehɔ́b é Grikia ne ábe béhɔ́béʼáá ehɔ́b é dyad. Bad ábe béhɔ́béʼáá ehɔ́b é Grikia béhɔ́béʼáá bán ábāb bekúd béekudɛ́ɛ́ akab á mɔné áde békábpáá bekúd epun-tɛ́ɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Hɛ́ɛ bembapɛɛ bé nlómag dyôm ne bébɛ béladɛɛ́ bad ábe bédúbpé bésyə̄ə̄l áte boŋ bélāŋgē bɔ́ bán, “Éebooʼɛ́ nɛ́n bán sétɛde akal dé eyale é Dyǒb âbɛl boŋ séhíde nkabtéd ḿ mɔné ámbīd. ");
INSERT INTO bssNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Né-ɔɔ́, a-baányaŋ nyépwɛd bad saámbé átîntê echɛ̂n, ábe béwóó edúbé, ábe Edəə́dəŋ éche Ésáá élyə́gtɛɛ́, bébíi-ʼɛ akan, âbɛl nɛ́n sébane ḿmɛ́n ntíi áwab mekáá. ");
INSERT INTO bssNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ene póndé sɛ́ɛ̄bɛ̌ echɛd yə̌l esyəə́l âkáne ne âkal nkalaŋ ḿ bwâm.” ");
INSERT INTO bssNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Moosyəə́l anwóg menyiŋge ne dyam áde bembapɛɛ bé nlómag bénhɔ̄bpē. Né-ɔɔ́, bêmpwɛ̌d Stefanusɛ. Abédɛ́ɛ mod awě andúbé bwâmbwam. Edəə́dəŋ éche Ésáá-ʼɛ élyə̄gtē mɔ́. Bêmpwɛ̌d kə́ə́ŋne Filibɛ, Prokorosɛ, Nikanɔɔ, Timɔnɛ, Pamɛnasɛ ne Nikolausɛ. Nikolausɛ abédɛ́ɛ mod awě ambíd á dyad á Antyɔg, eebédɛɛ́ mod a Israɛl boŋ antimɛ́n adúbe á bad bé Israɛl. ");
INSERT INTO bssNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bêmpɛɛ́n ábén bad áʼsō wɛ́ɛ bembapɛɛ bé nlómag. Bembapɛɛ bé nlómag bénkānnēd bɔ́ bébán-nɛ bɔ́ mekáá á nló. ");
INSERT INTO bssNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Né-ɔɔ́, eyale e Dyǒb émbɛ̄ ékanlád mbwɔ́g áte esyəə́l ékǎg áʼsō. Mesoŋgé mé bad ábe béndūbē á Jerusalɛm méchə́gkéʼáá achə́ge ne achə́ge. Ekud é beprisɛ chɔ́mpē êmbootéd nkalaŋ ḿ bwâm ahíd. ");
INSERT INTO bssNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Bɔɔb-pɔɔ́ Stefanusɛ abédé-ɛɛ́ mod awě ádē aloŋgé álúmtéʼáá nsimé ń Dyǒb bwâmbwam. Awóŋ ngíne âbɛl ndəle é mekan é menyáké átîntê e bad. ");
INSERT INTO bssNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Boŋ baahɔ́g bêmbootéd mɔ́ apɛntɛn. Ábê bad bébédɛ́ɛ bad ábe bémbīd á echoŋ é bad éche êmmɛntɛ́n akɛ á ndáb e mekáne eche béchə́géʼáá bán ndáb e mekáne e betâŋ ábe bénkêmbɛ́ betâŋ ámpē. Ábé bad bébédé bad bé Israɛl ábe bémbīd á myad mé Sirinɛ ne Alɛsandria. Bɔ́ɔbɛ bad bé Israɛl bémpēe ábe bémbīd á mbwɔ́g e Silisia ne e Esia, bêmbootéd aswaŋtɛn ne Stefanusɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Boŋ Edəə́dəŋ éche Ésáá êmbɛ̌ mɔ́ nyaa e debyɛ́ɛ́ eche nzé anhɔ́b dyam, béehɛleʼaá dɔ́ apɛle. ");
INSERT INTO bssNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Né-ɔɔ́ bénsɔ̄l baahɔ́g áte bán béhɔ̂b nɛ́n bán “Sêwógé nɛ́ɛ Stefanusɛ ásyə́əʼɛ́ Mosɛɛ, ásyə̄ə̄-ʼɛ Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Né-ʼaá bêmbɛnlé boŋ békón bad bé dyad, békón bad bémbáá bé dyad ne bemeléede bé mbéndé. Hɛ́ɛ békóbé Stefanusɛ boŋ békɛɛné mɔ́ áʼsō éʼ bad bé mbwɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Hɛ́-ʼaá bépɛ́ɛ́né bad âbíd mɔ́ mbóŋ é metóm. Ábê bad bénhɔ̄b nɛ́n bán, “Anɛ́n mod ahɔ́beʼ mekan mé mbéb póndé ésyə̄ə̄l tə̂ŋgɛne Ndáb-e-Dyǒb echě esáá ne tə̂ŋgɛne mbéndé eche Dyǒb ábágé syánē. ");
INSERT INTO bssNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Sêwógé nɛ́ɛ áhɔ́bɛɛ́ aá ane Yesuɛ, mod a Nazarɛt, ǎpāŋ Ndáb-e-Dyǒb áhəŋlɛ́n-nɛ eʼlem ábe Mosɛɛ ályə́gnédé syánē.” ");
INSERT INTO bssNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bad bésyə̄ə̄l ábê bébédé á ndáb e mbom bênsǔm mǐd wɛ́ɛ Stefanusɛ. Bénnyīn nɛ́ɛ eʼsó éʼpɛnɛɛ́ mɔ́ nɛ́ɛ eʼsó éʼ ángɛl. ");
INSERT INTO bssNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Prisɛ ambáámbáa ansɛdéd Stefanusɛ aáken, “Ḿmɛ́n mekan mésyə̄ə̄l ḿme ábɛ́n bad béhɔ́bé wɛ áyə̄l, médé mbále-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Dɔ́ɔ Stefanusɛ ábóótédé bad bé káánsɛl pɔ́le akale. Anhɔ́b aá, “A-baányaŋ ne besáá ábêm, nyélâm metúu. Dyǒb dé ehúmé dêmpií echɛd sáŋ Abrahamɛ áde ábédé á mbwɔ́g e Mɛsopotemia, adɛ̂hɔ́b aá mɔ́kag adyɛɛ á dyad á Haran. ");
INSERT INTO bssNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Dyǒb dénlāā mɔ́ aá ‘Tɛdé echoŋ túmbé, étɛde-ʼɛ ádōŋ aloŋ ékag á ndɔɔb eche mɛ́lūmēdtē wɛ.’ ");
INSERT INTO bssNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Né-ɔɔ́, Abrahamɛ antɛdé ndɔɔb e Kaldeya áhyɛ ádyɛ̄ á dyad á Haran. Ámbīd e kwééd eche Abrahamɛ sáá, Dyǒb dêmbɛ̌l Abrahamɛ ákɛ ádyɛ̄ á ndɔɔb eche nyédíí áhed nɛ́n bɔɔb. ");
INSERT INTO bssNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ene póndé Dyǒb dénkêmbaá Abrahamɛ ké abɛ̂n á ndɔɔb eche ándāāsɛ̄nnē mɔ́. Boŋ pɛn Dyǒb dênhɔ́b nɛ́n aá ene ndɔɔb ěsuunéd bɔ́ ḿme mbyaa. Póndé eche Dyǒb dénláá-ʼɛ́ Abrahamɛ nɛ̂, eenkênwálɛ́ɛ́ mwǎn ké nhɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Dyǒb dénlāā mɔ́ nɛ́n aá, ‘Ḿmôŋ mbyaa mɛ́bɛ̄ beken á aloŋ á bad bémpēe. Áwed-taá bɛ́bɛ̄ɛ̄ betâŋ, békūd-tɛ metuné etûn é póndé éche édé dyam mbwɔ́kɛl é mwɛ̌ éniin. ");
INSERT INTO bssNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Boŋ mɛ̌kɔ̄gsɛ̄n ádê aloŋ á bad áde bɛ́bɛnlɛ́ɛ́ nɛ́ɛ betâŋ. Ámbīd enɛ̂, ḿmôŋ mbyaa mɛ́bīd á aloŋ-tê wɛ̂, bétīm áyə̄l e ádɛ́n abwɔ́g á hǒm, békānnē á dǐn ádêm áhed.’ ");
INSERT INTO bssNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Hɛ́ɛ Dyǒb ábɛ́lé boŋ Abrahamɛ ápɛ̄ á nchemtɛn ne mɔ́ tə̂ŋgɛne ngáne béyagɛɛ́ bad, nɛ̂ŋgáne eʼchemléd bé melɛ̌ ḿme Dyǒb ámwédé ne ábē bad. Né-ɔɔ́, Abrahamɛ an'yǎg awe mwǎn Aisigɛ ámbīd e eʼpun saámbé áde béchyáá mɔ́. Aisigɛ mɔ́-ʼɛ an'yǎg awe mwǎn Jakɔbɛ, Jakɔbɛ mɔ́-ʼɛ áyāg ábe bǎn dyôm ne bébɛ ábe bédé ábɛ̄d betaa. ");
INSERT INTO bssNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ábê betaa bénwōōn mwǎnyaŋ nhɔ́g, Josɛbɛ kɔ́njí á nlém-tê. Né-ɔɔ́, bénsōm mɔ́ nɛ̂ŋgáne ntâŋ. Bad ábe bénsōmmē mɔ́ áwāb, bênkɛɛ́n mɔ́ á aloŋ á Egipto. Boŋ Dyǒb démbɛ̄ mɔ́ ámbīd, ");
INSERT INTO bssNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ábɛ̄l-lɛ atóm metake mésyə̄ə̄l áte. Dyǒb dêmbɛ̌l Farao kə̂ŋ e Egipto anwógɛ́n Josɛbɛ menyiŋge ábɛ̄-ʼɛ Josɛbɛ debyɛ́ɛ́, áde ápédé áwe áʼsō. Nɛ́n dêmbɛ̌l Farao ambɛ̌ Josɛbɛ atii á ngɔ́menaa ámīn e aloŋ ne ámīn e ábē bwěm éʼsyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ámbīd enɛ̂, nzaa e ngíne empɛ̌ á aloŋ á Egipto ne á aloŋ á Kanahan. Ene nzaa empɛɛ́n metake mé ngíne, ábɛ̄d betaa bénkênwóŋ-ʼaá ndyééd eche bédyágkē. ");
INSERT INTO bssNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Né-ɔɔ́, áde Jakɔbɛ áwógé bán ndyééd edé á Egipto, anlóm ábe bǎn áwed. Nɛ́dē ábɛ̄d betaa. Nɛ̂ dɔ́ɔ ábédé bɔ́ ngen eʼsó âkɛ áwed. ");
INSERT INTO bssNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Áde bǎn ábe Jakɔbɛ békíí á Egipto ngen éche élóntɛ́né ébɛ, Josɛbɛ ampalé yə̌l áte wɛ́ɛ baányaŋ. Hɛ̂ dɔ́ɔ Farao ásóŋtɛ́né tə̂ŋgɛne túmbé echě Josɛbɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Né-ɔɔ́, Josɛbɛ anlyə́gtɛ́n baányaŋ aá béláa sáá Jakɔbɛ, áhyag ne eche túmbé esyəə́l á Egipto. Bɔ́ moosyəə́l bébédé móom mé mod saámbé ne bétáan. ");
INSERT INTO bssNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Dɔ́ɔ Jakɔbɛ bɔ́ moosyəə́l békíí á Egipto. Áwed-taá mɔ́ ne ábe bǎn, betaa ábe syánē bêndyɛɛ́ʼɛ́ kə́ə́ŋ béwɛ́-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ámbīd e nɛ̂, béntēd bɔ́ ndim bésūɛ̄n ámbīd á dyad á Shekɛm, bélímé mɔ́ áwed á ndɔɔb echě Abrahamɛ ánchanɛ́nné mɔné wɛ́ɛ bǎn bé túmbé e Hamɔ. ");
INSERT INTO bssNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Áde póndé ékwógé apɛ echě Dyǒb dɛ́lōnēdtē dyam áde ánlāāʼɛ́ Abrahamɛ aá mɔ́ɔ̄bɛ̌l, mesoŋgé ḿme ábɛ̄d bad ábe bébédé á Egipto mêmmǎd achə́ge bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kə́ə́ŋne á asóg, kə̂ŋ empée echě enkêmbíí myaŋgó ḿme Josɛbɛ, empɛ̌ á nkamlɛn. ");
INSERT INTO bssNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Anwóŋ akwâb tə̂ŋgɛne ábɛ̄d betaa átagté-ʼɛ bɔ́. Ankə̌ŋ bétɛ̄dē ábab bǎn á ebwɔ́g, âbɛl boŋ béwɛ̂. ");
INSERT INTO bssNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ḿmê mesú dɔ́ɔ béchyáá Mosɛɛ. Abédɛ́ɛ mwǎn awě ambǒŋ bwâmbwam. Bêntɔgɛ́n mɔ́ á ndáb wɛ́ɛ sáá á etûn é ngɔn éláán. ");
INSERT INTO bssNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ámbīd enɛ̂ dɔ́ɔ bétɛ́dté mɔ́ á ebwɔ́g-te. Hɛ́ɛ mwǎn a mmwaád awě Farao ádíbté mɔ́, átēdē mɔ́ ngáne awě mwǎn, átɔgné-ʼɛ mɔ́ kə́ə́ŋ ákwogéʼ. ");
INSERT INTO bssNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Bén'yə̄gēd Mosɛɛ debyɛ́ɛ́ á bad bé Egipto ásyə̄ə̄l kə́ə́ŋ abɛ́ ndəle e mod á nhɔ́btéd ne á mbɛltéd. ");
INSERT INTO bssNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Áde Mosɛɛ ápédé móom mé mwɛ̌ méniin, mewêmtɛn mêmpií mɔ́ âkɛ dɛ́nyīn baányaŋ bé Israɛl. ");
INSERT INTO bssNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Antán ngáne mod a Egipto átagtɛɛ́ mwǎnyaŋ nhɔ́g. Dɔ́ɔ ákíí áhed âtimtɛn. Anwóŋgɛ́n mɔ́ áwúɛ́-ʼɛ ane mod a Egipto. ");
INSERT INTO bssNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosɛɛ anwémtɛ́n aá ábē bad béchem nɛ́n bán Dyǒb áhɛde mɔ́ abɛnled âhúd bɔ́ á mekáá mé bad bé Egipto, boŋ bénkênnyínné nɛ̂. ");
INSERT INTO bssNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Epun éche ébádtɛ́né, antán ábē bad bé Israɛl bébɛ běn ne běn béwaneʼ. Anhɛ̌d nzii eche áyālɛ̄ɛ̄ bɔ́ âkɔ́m nsaŋ. Dɔ́ɔ álâŋgɛɛ́ bɔ́ aá, ‘Éesaá mbále bán baányaŋ bɔ́ɔ nyédíí-yɛ? Chán-nɔ̄ nyé mod-tɛ́ áhɛdɛɛ́ waáb alɔ́gɛn?’ ");
INSERT INTO bssNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Boŋ ane mod awě ahɛdéʼáá waáb alɔ́gɛn nɛ̂, antínéd Mosɛɛ á nkəg ásɛdté mɔ́ aáken, ‘Nzɛ́-módɛ́ abagé kunze aá ékamlan ne âkáad sé? ");
INSERT INTO bssNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ehɛde mɛ́mpē awúu ngáne éwúú mod a Egipto chǎn-ɛ?’ ");
INSERT INTO bssNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Awóg áde Mosɛɛ áwógé nɛ̂, ansǒb ákɛ̄ á mbwɔ́g e bad bé Midian. Áwed-taá ádyɛ́ɛ́ kə́ə́ŋ boŋ áchyāā ábe bǎn bé baachóm bébɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ámbīd e móom mé mwɛ̌ méniin dɔ́ɔ ángɛl épíídé Mosɛɛ á ehyáŋge. Empií mɔ́ a muú-te, ḿmé ménkōbɛ̄n mwǎ bwɛl. Nɛ́n ábédé bɛnbɛn ne mbɔɔd e Sinai. ");
INSERT INTO bssNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Áde Mosɛɛ ányíné ádɛ́n akan, menyáké ménkōb mɔ́. Ansídé bɛnbɛn aá mɔ́tôŋ anɔn bwâm, dɔ́ɔ áwógé ehɔ́b éche Sáŋgwɛ́ɛ́ nɛ́n aá, ");
INSERT INTO bssNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Mɛ́ɛ ndé Dyǒb áde ábôŋ betaa, Dyǒb áde Abrahamɛ, Aisigɛ ne Jakɔbɛ bébɛ́nléʼáá.’ Ne mbwɔ́g ń ngíne Mosɛɛ enkênchuʼɛ́ anɔn áhed. ");
INSERT INTO bssNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Hɛ́ɛ Sáŋgwɛ́ɛ́ álâŋgɛɛ́ mɔ́ aá ‘Húd metámbé á mekuu áyə̄le abwɔ́g á hǒm áde étyéémé nɛ́n ádíi hǒm áde ásáá. ");
INSERT INTO bssNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nnyíné ngáne ábêm bad ábe bédé á aloŋ á Egipto békudɛɛ́ metake bwâmbwam. Nwógé ngáne béwennadté dɔ́ɔ nhyédé bɔ́ awôŋgɛn. Bɔɔb-pɔɔ́ hyǎg, mɛ̌lōm wɛ á Egipto.’ ");
INSERT INTO bssNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Anɛ́n Mosɛɛ mɔ́ɔ bad bé Israɛl bémbāŋgē á yə̌l boŋ bésɛdté mɔ́ bánken, ‘Nzɛ́-módɛ́ abagé wɛ kunze âkamlɛn ne âkáad sé?’ Mɔ́-ʼaá Dyǒb dénlōmmē âkamlɛn ne âsoŋ ábē bad. Nɛ́n dêmbenléd áde ángɛl êmpiíʼɛ́ mɔ́ áde bwɛl bénkōbpē muú. ");
INSERT INTO bssNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mosɛɛ awed mɔ́ɔ ambídɛ́n bad bé Israɛl á Egipto. Ambɛ̌l ne eʼchemléd áwed ne á Eyəke é edíb é nkwɛ̌. Ambɛ̌l-lɛ menyáké ne eʼchemléd áde bébédé á ehyáŋge á etûn é móom mé mwɛ̌ méniin. ");
INSERT INTO bssNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Anɛ́n Mosɛɛ mɔ́ɔ anláá bad bé Israɛl aá, ‘Dyǒb dɛ́lōmē nyé nkal éʼdəə́dəŋ awě ǎbīd átîntê echɛ̂n melemlem nɛ̂ŋgáne álómé me.’ ");
INSERT INTO bssNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Melemlem mé Mosɛɛ mɔ́ɔbédé nlatɛ́n ne ábɛ̄d bad á ehyáŋge. Abédé áwed ne ábɛ̄d betaa áde ángɛl eche Dyǒb dénlōmɛ̄nnē nlébtéd á Mbɔɔd e Sinai énhɔ̄bpē áwāb. Ḿmɛ́n nlébtéd ḿme Mosɛɛ ânkudté wɛ́ɛ ángɛl mɔ́ɔ syánē dédíí déhídɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ábɛ̄d betaa bénkênwógɛ́nné Mosɛɛ, boŋ bémbāŋ mɔ́ á yə̌l, bétimé béwēmtān âtim ámbīd á Egipto. ");
INSERT INTO bssNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Áde Mosɛɛ ályə́gé adé á mbɔɔd e Sinai dɔ́ɔ bad bé Israɛl bélâŋgɛɛ́ mwǎnyaŋ Arɔnɛ bán, ‘Bɛlé sé bwěm ábe bɛ́bē nɛ̂ŋgáne myǒb ábe bɛ́lyə̄gēd sé áyə̄le séebíiʼɛ́ dyam áde ábɛ́nlédé ne Mosɛɛ awě ambídéd sé á Egipto.’ ");
INSERT INTO bssNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Hɛ́ɛ bébɛ́lé chǒm éche éwágné mwǎn a nyag boŋ bébootéd eʼlém awúu âbɛ chɔ́ mendɛ. Bêmbɛl kə́ə́ŋne ngande, âwóg menyiŋge ne chǒm éche bébɛ́nlé ḿmab mekáá. ");
INSERT INTO bssNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Dɔ́ɔ Dyǒb ákúnnédé bɔ́ mbíd boŋ áchennéʼ bɔ́ âkânned ngumɛ éche édé ámīn. Ébɛ́nlédé ngáne éténlédé á kálag e bekal béʼdəə́dəŋ nɛ́n bán, ‘Á-bad bé Israɛl, áde nyémbɛ̄ɛ̄ á ehyáŋge á etûn é móom mé mwɛ́ méniin saké mɛɛ́ nyékwɛ́nléʼáá káa nyétúmméʼáá eʼlém âbɛ mendɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tɛ́ndɛ echě dyǒb áde béchəgɛɛ́ bán Molɛk mɔ́ɔ nyémpēmmē. Ediídiŋgɛ-ʼɛ éche tintinɛ a dyǒb áde béchəgɛɛ́ bán Rɛfan chɔ́ɔ̄ nyéhyɔ́mnáá. Ḿmɛ́n myǒb mɔ́ɔ̄ nyébɛ́nlé mekáá boŋ nyébwɔ̄gkē mebóbóŋ. Né-ɔɔ́, mɛ̌běn nyé, nlóm nyé hǒm áde áchábnédé tómaa aloŋ á Babilɔn.’ ” ");
INSERT INTO bssNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Stefanusɛ ambɛ́ abád ámpē aá, “Áde ábɛ̄d betaa bébédé á ehyáŋge bénwōŋ Ebem é Dyǒb échě élûmte nɛ́n bán Dyǒb ádé ne bɔ́. Bénlōŋ chɔ́ nyaa echě Dyǒb dénlāāʼɛ́ Mosɛɛ aá álôŋ chɔ́. Nsáaned ḿme Dyǒb délūmēdtē Mosɛɛ mɔ́ɔ ánhīdtē. ");
INSERT INTO bssNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ámbīd e póndé ábɛ̄d betaa bênkǒb ene tɛ́ndɛ á mekáá ḿme ábab besáá. Bénwālē chɔ́ áyə̄l áde bɔ́ɔbɛ Josua békóbné meloŋ ndɔɔb echě Dyǒb dênnanɛ́ɛ́ bɔ́ bad áte. Ene tɛ́ndɛ embɛ́ ebɛ́ áhed kə́ə́ŋne á póndé eché Dabidɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nsimé ń Dyǒb ńhídéʼáá Dabidɛ. Né-ɔɔ́, ancháŋ Dyǒb aá ábɛ mɔ́ kunze mɔ́lōo Dyǒb áde Jakɔbɛ ábɛ́nléʼáá ndáb. ");
INSERT INTO bssNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Boŋ Solomonɛ, Dabidɛ mwǎn, mɔ́ɔ̄ antǐm Dyǒb ene ndáb alóo. ");
INSERT INTO bssNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Boŋ kénɛ̂ Dyǒb á Ngum éēdyɛ̄ɛ̄ʼɛ́ á ndáb eché baányoŋ bélóŋné mekáá. Édé nɛ́n ngáne nkal éʼdəə́dəŋ nhɔ́g ahɔ́bé aá Dyǒb áhɔ́bé aá, ");
INSERT INTO bssNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Nkoŋ ḿmīn mɔ́ɔ̄ ńdé ádêm atii dé nkamlɛn, nkǒŋsé-ʼɛ ḿbɛ́ wɛ́ɛ ḿbannɛɛ́ mekuu. Nyaa e ndáb ehéé nyéhɛle-sɛ nyêlóó mɛ? Kéʼɛ héé mɛ́kɔ̄mmɛ̄ɛ̄ áte? ");
INSERT INTO bssNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Mměn meémaaʼɛ́ ábɛ́n bwěm abɛl-ɛ?’ ” ");
INSERT INTO bssNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stefanusɛ ambád ahɔ́b aá, “Nyêdíi bad ábe béwúú nló áte. Nyêlɛlé nlém á abum. Nyêkɔ́lé metúu áyə̄l e eyale é Dyǒb. Nyêdíi melemlem nɛ̂ŋgáne ábɛ̄n betaa, nyêtə̂ŋgan Edəə́dəŋ éche Ésáá. ");
INSERT INTO bssNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nkal éʼdəə́dəŋ ké nhɔ́g alyəgé áse awě enkênkǔd metake á mekáá ḿme ábɛn betaa-yɛ? Bénwūū mésɛ́nzɛ mé Dyǒb mésyə̄ə̄l ḿme seʼ bɔɔ́d mêmbɛ̌l ehə́ŋgé áyə̄l e epɛ éche Ane awě abɛle mekan ḿme métə́ŋgɛ́né. Nyé-ʼɛ bɔɔb nyêsómé mɔ́, nyêwúú-ʼɛ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nyé běn-naá nyêkudé mbéndé éche Dyǒb álómé mbwiined ne éche ángɛl boŋ kénɛ̂ nyéehídɛɛ́ chɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Áde bad bé mbwɔ́g béwógé mekan ḿme Stefanusɛ áhɔ́bé, bênlǐŋ bwâmbwam kə́ə́ŋ yə̌l ésōgē bɔ́ áte. ");
INSERT INTO bssNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Stefanusɛ-ʼɛ Edəə́dəŋ éche Ésáá énlōn mɔ́ áte. Nɛ́ɛ ánɔ́né ámīn ányīnēʼ ehúmé é Dyǒb, ányīnēʼ Yesuɛ ngáne átyéémé Dyǒb á ekáá émbáá. ");
INSERT INTO bssNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Dɔ́ɔ áhɔ́bɛɛ́ aá, “Nyénɔneʼ, nnyíneʼ nɛ́ɛ dyǒb ánédnédé, Mwǎn-a-Moonyoŋ átyéémé Dyǒb é ekáá émbáá.” ");
INSERT INTO bssNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Hɛ́ɛ bad bé mbwɔ́g béhédé esaád é ngíne békútɛ́n-nɛ metúu ne mekáá boŋ bɔ́ moosyəə́l bébōnlād mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Bêndol mɔ́ bésyəŋnéd mɔ́ á dyad-tê, bébootéd mɔ́ meláá alúm. Bad ábe béntyēēm mbóŋ âkɔ́gsɛn Stefanusɛ bénhūd ḿmāb nkob áyə̄l békɛ bébānē áʼsō-te wɛ́ɛ kɔ́demod pɔ́g bán Sɔɔlɛ ánɔne bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Áde bélúmɛɛ́ Stefanusɛ meláá nɛ̂, ankáné aá, “A-Sáŋgú Yesu, mmǒŋ kǒb échêm edəə́dəŋ.” ");
INSERT INTO bssNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Dɔ́ɔ ábwɔ́gé mebóbóŋ boŋ ákāntē ehɔ́b ámīn aá, “A-Sáŋ, lagsɛ́n bɔ́ ḿmɛ́n mbéb ḿme bébɛlɛɛ́.” Amaá-aá ahɔ́b nɛ̂, awɛ́-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sɔɔlɛ abédé ásē ákwɛntɛ́n-nɛ aá béwúu Stefanusɛ. Échê epun chěn mwembé mé Jerusalɛm mêmbootéd metake mé ngíne akud á mekáá mé bad bé Israɛl. Bad ábe bédúbpé bésyə̄ə̄l bémpāŋtēd áte á mbwɔ́g e Judeya né e Samaria ésyə̄ə̄l. Boŋ bembapɛɛ bé nlómag běnpɛn-ɛ́ɛ bênlyə̌g. ");
INSERT INTO bssNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nguse é bad ábe bêmbané ḿmab nlém ńsyə̄ə̄l âbɛle Dyǒb bénlīmē Stefanusɛ. Béchyɛɛʼ, bélebé-ʼɛ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Boŋ Sɔɔlɛ mɔ́-ʼɛ ahɛdáá mwembé abɔ́ded. Ahúɛ́ʼáá enɛ́n ndáb átimé eníníí, ábīdtē bɔ́ á ebwɔ́g, bebaád ne baachóm, ahág-kɛ bɔ́ á mbwɔg. ");
INSERT INTO bssNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bad ábe bédúbpé bémpáŋtéd áte, békag békalé nkalaŋ ḿ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filibɛ mɔ́ ankɛ̌ á dyad ambáá á mbwɔ́g e Samaria ákanlé bad tə̂ŋgɛne Ane-awě-Béwɔ́gté. ");
INSERT INTO bssNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Áde ndun e mod éwógé mam ḿme Filibɛ áhɔ́bɛɛ́ bényín-nɛ eʼchemléd bé menyáké ábe ábɛ́lé, béntōŋ metúu atə́le áte âwóg dyam áde áhɔ́bɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Filibɛ ambɛ̌l eʼdəə́dəŋ bé mbéb éʼsyə́ŋgéʼáá ekud é bad áte ne eʼsaád éʼ ngíne, ekud é bad-tɛ ábe yə̌l énwɛ̄ɛ̄ epɛd ne ábe bésyə́gtéʼáá bêndyɛɛ́ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nɛ́n dêmbɛ̌l bad bésyə̄ə̄l á dyad-tê wɛ̂ béwóg menyiŋge bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Bɔɔb-pɔɔ́, mod nhɔ́g abédé ádê dyad áte bán Simɔnɛ, akuméʼáá ngaŋ eche ekɔ́mtéʼáá bad bé Samaria yə̌l áte bwâmbwam. Akuméʼáá ekáá á tə̂l aá modmod eépedɛɛ́ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Bad bésyə̄ə̄l á dyad, ndəle é bad ne bekwɛ̌kwɛ̌ bé bad bêmbané nlém áwē, béhɔ̄bē-ʼɛ bán, “Anɛ́n mod adíi ngumɛ e Dyǒb echě béchə́gɛɛ́ bán, Ngum embáá.” ");
INSERT INTO bssNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bêmbané nlém áwē áyə̄le á etûn é póndé ankǒŋ bad yə̌l akɔ́med áte ne echě ngaŋ echě ákúméʼáá. ");
INSERT INTO bssNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Boŋ áde bédúbpé nkalaŋ ḿme Filibɛ ânkalɛ́ɛ́ bɔ́ tə̂ŋgɛne nkalaŋ ḿ bwâm mé nkamlɛn ń Dyǒb ne tə̂ŋgɛne Yesu Krǐstəə, bênkǔd edusɛn, bebaád ne baachóm. ");
INSERT INTO bssNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simɔnɛ mwěn ámpē andúbé, ákūd-tɛ edusɛn. Ambootéd Filibɛ ahíd kéhéé áde ákágéʼáá. Yə̌l enkɔ́m mɔ́ áte áde ányíné mbɛltéd mmé menyáké ḿme Filibɛ ábɛ́léʼáá. ");
INSERT INTO bssNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bembapɛɛ bé nlómag bénwōg á Jerusalɛm bán bad bé Samaria békóbé eyale é Dyǒb, hɛ́ɛ bélómé Petro bɔ́ Jɔnɛ áwed. ");
INSERT INTO bssNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Áde bépédé áwed bénkānnēd bad ábe bédúbpé nɛ́n bán békud Edəə́dəŋ éche Ésáá. ");
INSERT INTO bssNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Bénkānnēd bɔ́ áyə̄le bénkêmpaá Edəə́dəŋ éche Ésáá akud. Bêndusɛ́n bɔ́ dásɔ̄ á dǐn áde Sáŋgú Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Dɔ́ɔ Petro bɔ́ Jɔnɛ bébáné bɔ́ mekáá á nló bɔ́-ʼɛ békudéʼ Edəə́dəŋ éche Ésáá. ");
INSERT INTO bssNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Áde Simɔnɛ ányíné aá nzé bembapɛɛ bé nlómag bébáné mod ekáá á nló akudeʼ Edəə́dəŋ éche Ésáá, ambídéd mɔné âbɛ Petro bɔ́ Jɔn, ");
INSERT INTO bssNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","áhɔ̄bē aá, “Nyébag mɛ́mpē enɛ́n ngíne âbɛl boŋ kénzɛ́ɛ́ awě ḿbáné ekáá á nló ákud Edəə́dəŋ éche Ésáá.” ");
INSERT INTO bssNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Petro antimtɛ́n mɔ́ aá, “Nzé ewémtɛ́né wɛɛ́ mɔ́hɛle-sɛ mɔ́chānɛ̄n ndɛ e Dyǒb mɔné, nyáābe ḿmôŋ mɔné nyékag á dǔ-á-muú. ");
INSERT INTO bssNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Weewóoʼɛ́ akab ké ahɔ́g áyə̄l e ḿmɛd nsɔ́n áyə̄le ḿmôŋ nlém méebooʼɛ́ áte áʼsō éʼ Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kunnéd-tɛ mbíd étimɛn Dyǒb, áyə̄le ḿmɛ́n mewêmtɛn mé mbéb ḿme éwóó áte, ékáneʼ wɛɛ́ Sáŋgwɛ́ɛ́ álagsɛn wɛ áyə̄le awêmtɛn áde éwémtɛ́né enɛ́n ndín e akan. ");
INSERT INTO bssNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mmaá anyín nɛ́n mɛɛ́, kə́n emaá wɛ akób áte, mbéb-pɛ ńhédé wɛ á mehaŋgé-te.” ");
INSERT INTO bssNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Hɛ́ɛ Simɔnɛ álâŋgɛɛ́ Petro bɔ́ Jɔn aá, “Sôn, nyékânned mɛ wɛ́ɛ Sáŋgwɛ́ɛ́, âbɛl boŋ ḿmɛ́n mésyə̄ə̄l ḿme nyéhɔ́bé ké ahɔ́g déebɛnlád ne mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Áde Petro bɔ́ Jɔn bémáá mam mésyə̄ə̄l ahɔ́b tə̂ŋgɛne Yesuɛ, bémād-tɛ nkalaŋ ḿme Sáŋgwɛ́ɛ́ akal, bêntǐm ámbīd á Jerusalɛm. Á nzii á esú békáléʼáá nkalaŋ ḿ bwâm ḿme Yesuɛ á myad mé mbwɔ́g e Samaria híin. ");
INSERT INTO bssNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ḿmíníí mbwɛ ángɛl e Sáŋgú enláá Filibɛ aá, “Ladé yə̌l, ékag á pɛd e mbəŋ wɛ́ɛ nzii echě ebíde á Jerusalɛm âkɛ á Gaza étómɛɛ́” Béebɛnládté enɛ́n nzii ámpē. ");
INSERT INTO bssNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filibɛ abǒŋsɛ́né-ʼaá ákǎg-kɛ. Hɛ́ɛ ábomné soŋ e mod á nzii ngáne ásúɛʼɛ́ áwē aloŋ. Anɛ́n mod abédɛ́ɛ ndəle e mod awě akamlánnáá, ánɔné-ʼɛ́ ngáb eche Kandɛsɛ, mmwaád awe akamlánnáá aloŋ dé Etoopia. Ane mod ankɛ̌ á Jerusalɛm. ");
INSERT INTO bssNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Á ehúu ámbīd échê, andyɛɛ́ á ebambam. Ngáne ákágéʼáá, álááʼáá kálag echě nkal éʼdəə́dəŋ Yesayaa. ");
INSERT INTO bssNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Hɛ́ɛ Edəə́dəŋ éche Ésáá éláŋgɛɛ́ Filibɛ aá, “Kǎg á ebambam hɛ̂, ébɛ̂ chɔ́ bɛnbɛn.” ");
INSERT INTO bssNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filibɛ annyəgéd áhed, dɔ́ɔ áwógé ngáne ane mod áláaʼɛ́ kálag e nkal éʼdəə́dəŋ Yesayaa. Dɔ́ɔ ásɛdtɛɛ́ mɔ́ aáken “Esôŋtan chǒm éche éláaʼɛ́-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ane mod antimɛ́n mɔ́ aá “Chán mɛ́mwɛɛ́ asôŋtɛn áde mod éētə̂nledɛɛ́ mɛ áte?” Né-ɔɔ́, anchɛ́lé Filibɛ aá áchə́ge á ebambam, bɔ́mɔ̄ bédyɛ̄ɛ̄ áhed. ");
INSERT INTO bssNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Epɛd éche ane mod ákóóʼáá aláŋ ébédɛ́ɛ nɛ́n, “Abédɛ́ɛ nɛ̂ŋgáne ńdyɔŋ ḿ mbód ḿme békagkɛ́ awúu, ambɛ́-ʼɛ ngáne mwǎn a ńdyɔŋ ḿ mbód awě bésɛlɛɛ́ nyoŋ boŋ eéchyɛ̄ɛ̄ʼ, enkênhɔ́bpé dyamdyam. ");
INSERT INTO bssNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","“Bênsudéd mɔ́ edúbé, békōbɛ̄n-nɛ mɔ́ kunze. Nzɛ́-módɛ́ ǎtūb ḿme nchyáátɛ́n dǐn áde édíí bán bénhūd mɔ́ ámīn á nkǒŋsé.” ");
INSERT INTO bssNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ane mod ansɛdéd Filibɛ aáken, “Nzɛ́-módɛ́ ane nkal éʼdəə́dəŋ áhɔ́bɛɛ́, eche yə̌l chěnɛ kéʼɛ mod ampée?” ");
INSERT INTO bssNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Hɛ́ɛ Filibɛ álâŋgɛɛ́ mɔ́ nkalaŋ ḿ bwâm ḿme Yesuɛ, átə̄nlād mɔ́ mekan áte, mbooted ne échɛ́n epɛd. ");
INSERT INTO bssNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Áde békagkɛ́ nɛ̂, bêmpɛ̌ hǒm áde mendíb médíí. Hɛ́ɛ ane mod áhɔ́bɛɛ́ aá, “Mendíb mɔ́ɔ̄ mɛ́n. Weédūsānnē mɛ ngen pɔ́g-ɛ?” ");
INSERT INTO bssNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ane mod anhɔ́b aá bétíi ebambam. Dɔ́ɔ bɔ́ Filibɛ bésúdé ásē bésɔ́l á mendíb-te boŋ Filibɛ ádusán mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Bébídé-ʼaá á mendíb-te bídɛ́n, Edəə́dəŋ é Sáŋgú ékɛ̄ɛ̄n-nɛ Filibɛ. Ane mod eenyíneʼaá mɔ́ ámpē boŋ ambɛ́ ákǎg, alón-nɛ ne menyiŋge. ");
INSERT INTO bssNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filibɛ annyín yə̌l á dyad á Azotus ábooted-tɛ akɛ dyad ne dyad tɛ́, ákaléʼ nkalaŋ ḿ bwâm, kə́ə́ŋ ápɛ á dyad á Kaisaria. ");
INSERT INTO bssNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Bɔɔb-pɔɔ́ Sɔɔlɛ ambɛ́ ákīmēʼ âwúu bembapɛɛ ábe Sáŋgwɛ́ɛ́. Ankɛ̌ wɛ́ɛ prisɛ ambáámbáa, ");
INSERT INTO bssNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","aláá mɔ́ aá átel kálag échě ábɛɛ́ belyə́ged bé ndáb é mekáne é Damaskɔs, âbɛl nɛ́n áwôŋ kunze echě nzé anyíné bad ké béhéé ábe béhídeʼ nzii e Yesuɛ áwed, áhaŋ bɔ́, ken bebaád-ʼɛ kéʼɛ baachóm, akób bɔ́, ákɛ̄ɛ̄n bɔ́ á Jerusalɛm. ");
INSERT INTO bssNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Dɔ́ɔ Sɔɔlɛ áhídté boŋ ákag. Á nzii e Damaskɔs wɛ̂, áde ádíí bɛnbɛn ne dyad, emwɛdmwɛd émbīd ádyōb, épɛn mɔ́ yə̌l esyəə́l. ");
INSERT INTO bssNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Anhún á ndɔɔb. Dɔ́ɔ áwógé ehɔ́b élāŋgē mɔ́ aá, “Á-Sɔɔl, á-Sɔɔl, cheé ékə́ə́ boŋ étagté mɛ?” ");
INSERT INTO bssNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sɔɔlɛ ansɛdéd aáken, “A-Sáŋ, nzɛ́-módɛ́ ne?” Dɔ́ɔ échê ehɔ́b étimtanné mɔ́ aá, “Mɛ-ɛɛ́ ndé Yesuɛ awě étagtɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Bɔɔb-pɔɔ́, hidé ásē, ékag á dyad-tê, áhed dɔ́ɔ bɛ́lāā-ʼɛ́ wɛ chǒm éche étə́ŋgɛ́né abɛl.” ");
INSERT INTO bssNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bad ábe bɔ́ɔbɛ Sɔɔlɛ bênwǒŋ bêntyéem, dyam déeboo bɔ́ ahɔ́b. Bénwōg ehɔ́b boŋ bénkênnyínné mod awě ahɔ́beʼ. ");
INSERT INTO bssNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sɔɔlɛ anhidé ásē, ánēdē mǐd áte, boŋ eenyíneʼaá ekíde. Né-ɔɔ́, bénchə̄ə̄ mɔ́ é ekáá, békɛ̄ɛ̄n mɔ́ á dyad-tê á Damaskɔs. ");
INSERT INTO bssNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Andyɛɛ́ eʼpun éʼláán ádé eenyínɛɛ́ ekíde. Ene póndé esyəə́l-lɛ eemwédɛɛ́, eedyéde-ʼáa chǒmchǒm. ");
INSERT INTO bssNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Á Damaskɔs mod abédé awě andúbé Yesuɛ, béchə́géʼáá mɔ́ bán, Ananiasɛ. Annyín ndɔ́g. Á ndɔ́g-te wɛ̂, Sáŋgú Yesuɛ anchəg mɔ́ aá, “Á-Ananias.” Ananiasɛ ankwɛntɛ́n aá “Mɛ nɛ́n, a-Sáŋ.” ");
INSERT INTO bssNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Dɔ́ɔ Sáŋgwɛ́ɛ́ álâŋgɛɛ́ mɔ́ aá, “Boŋsɛ́n, ékɛ á nkoŋ ń nzii ḿme béchəgɛɛ́ bán Ntyéémé. Wɛ̌pɛ̌ á ndáb wɛ́ɛ Judasɛ. Nzé epedé áhed, ésɛ̄dēd mod awě abídé á dyad á Tasus, béchəge mɔ́ bán Sɔɔlɛ. Adé áhed bɔɔb akânneʼ, ");
INSERT INTO bssNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","anyíné-ʼɛ ndɔ́g. Á ndɔ́g-te wɛ̂, anyíné mod awě béchəgɛɛ́ bán Ananiasɛ, abáné mɔ́ mekáá á nló âbɛl boŋ ányínɛn ámpē.” ");
INSERT INTO bssNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiasɛ antimtɛ́n mɔ́ aá “A-Sáŋ, nkénwōg ane mod dúu bwâmbwam ne nhel ḿ mekan ḿme ákébɛnlé ábōŋ bad áyə̄l á Jerusalɛm. ");
INSERT INTO bssNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Apedé-ʼɛ á Damaskɔs hɛ́n ne ngíne echě beprisɛ bémbáá bébágé mɔ́ âkób bad bésyə̄ə̄l ábe békânneʼ á dǐn ádōŋ.” ");
INSERT INTO bssNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Boŋ Sáŋgwɛ́ɛ́ anláá Ananiasɛ aá, “Kǎg, áyə̄le nɛ́n mpwɛdé anɛ́n mod âbɛle mɛ. Mɔ́ ǎbɛ̌l bad ábe béesɛ̌ bad bé Israɛl, échab kə̂ŋ é bad, ne bad bé Israɛl bébíí mɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mměn mɛ́lūmēd-tɛ mɔ́ metake ḿme ákudté áyə̄l echêm.” ");
INSERT INTO bssNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Né-ɔɔ́, Ananiasɛ ankɛ̌, asɔ́l a ndáb echě Sɔɔlɛ ámbɛ̄ɛ̄ áte, abán mɔ́ mekáá á nló, álāŋgē mɔ́ aá, “A-mwǎnned Sɔɔl, Sáŋgwɛ́ɛ́ mɔ́ alómé mɛ, nɛ́dē, Yesuɛ mwěn awě ampií wɛ á póndé eche éhyagké wɛ́n. Alómé mɛ áwôŋ âbɛl nɛ́n ényínɛn ámpē élôn-nɛ ne Edəə́dəŋ éche Ésáá.” ");
INSERT INTO bssNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ábwɔ̄g-ábwɔ̄g bwěm bémbīd Sɔɔlɛ á mǐd ábe bédé nɛ̂ŋgáne eʼkíd éʼ súu, ábooted-tɛ anyínɛn. Hɛ́ɛ ápádté ásē boŋ bédusán-nɛ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Andyɛ́ ndyééd, amaá-ʼaá ndyééd adyɛ́ boŋ yə̌l étimé mɔ́ áte. Sɔɔlɛ andyɛɛ́ á Damaskɔs nguse é eʼpun ne bad ábe béndūbē Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ankɛ̌ á ndáb é mekáne ésebán abébte póndé ákanle bad tə̂ŋgɛne Yesuɛ, aá mɔ́ adé Mwǎn a Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Yə̌l enkɔ́m mod tɛ́ɛ́ áte awě anwóg mɔ́ pɔ́le á nsəl. Bésɛdté bánken, “Saá anɛ́n mod mɔ́ awúɛ̄ʼáá bad ábe bétúbéʼáá dǐn áde Yesuɛ á Jerusalɛm-ɛ? Éesaá mbále nɛ́n nzɔm echě ápɛ́ɛ́né hɛ́n edíi âkób bɔ́ âtimɛn-nɛ bɔ́ ámbīd wɛ́ɛ beprisɛ bémbáá-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Boŋ Sɔɔlɛ ambɛ́ ákaléʼ ḿmê nkalaŋ ákǎg áʼsō ngíne ngíne. Metɔte ḿme âmbɛɛ́ âlúmed nɛ́n bán Yesuɛ mɔ́ adé Ane-awě-Béwɔ́gté, méntə̄ŋgɛ̄n nyaa echě bad bé Israɛl ábe bébédé á Damaskɔs bénkênwóŋgé dyamdyam ahɔ́b. ");
INSERT INTO bssNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ámbīd e eʼpun híin bad bé Israɛl bênladɛ́n áte âhə́ge Sɔɔlɛ ngáne bɛ́wūū-ʼɛ́ mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Boŋ Sɔɔlɛ anwóg ntíi ḿme bébɛ́lé. Bénɔ́néʼáá mmwɛ mé eʼkɛ́ ń dyad nkuu ne mǔte âbɛl béwúu mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Boŋ nkuu nhɔ́g Sɔɔlɛ ábē bembapɛɛ béntēd mɔ́, béhɛ́ mɔ́ á elóŋ-tê, bébídéd mɔ́ á epɔn é esɛ́d bé eʼkɛ́ ábe bênləŋned dyad, boŋ bésūdēd mɔ́ ámbīd e ebwɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sɔɔlɛ ankɛ̌ á Jerusalɛm. Áde ápédé áwed, anwanɛ́n aá mɔ́bɛ̂ ne bad ábe bédúbpé Yesuɛ boŋ ábɛ̂ bad bébááʼáá mɔ́ áyə̄le bénkêndúbɛ́ɛ́ bán mɔ́mpē adúbpé Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Hɛ́ɛ Banabasɛ áchə̄ŋgē mɔ́ á ekáá boŋ ákɛɛné mɔ́ wɛ́ɛ bembapɛɛ bé nlómag. Anchemtéd bɔ́ áte ngáne Sɔɔlɛ ányíné Sáŋgwɛ́ɛ́ á ndɔ́g-te á nzii ne chǒm éche Sáŋgwɛ́ɛ́ áláŋgé mɔ́. Anláá-ʼɛ bɔ́ ngáne Sɔɔlɛ áláŋgéʼáá bad mam tə̂ŋgɛne Yesuɛ á Damaskɔs ésebán abáaʼ dyamdyam. ");
INSERT INTO bssNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Né-ɔɔ́, Sɔɔlɛ ambɛ́ ne bɔ́, ákag mebwɔ́g mésyə̄ə̄l á Jerusalɛm ákaléʼ nkalaŋ ḿ bwâm á dǐn áde Sáŋgwɛ́ɛ́ ésebán abáaʼ dyamdyam. ");
INSERT INTO bssNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Akǎnléʼáá kə́ə́ŋne bad bé Israɛl ábe béhɔ́béʼáá ehɔ́b é Grikia áswaŋtán-nɛ ne bɔ́. Dɔ́ɔ bébóótédé nzii ahɛd âwúu mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Áde bad ábe bédúbpé Yesuɛ bésóŋtɛ́né bán béhɛde Sɔɔlɛ awúu, béntēd mɔ́ bésyɔgnéd mɔ́ á dyad á Kaisaria boŋ bélōmē mɔ́ á dyad á Tasus. ");
INSERT INTO bssNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Né-ɔɔ́, ene póndé esyəə́l bad ábe béndūbē Yesuɛ á mbwɔ́g e Judeya esyəə́l, á Galilia ne á Samaria bémbɛ̄ ne nsaŋ, béwóŋ-ʼɛ mbwɔ́g ń Dyǒb áte nɛ̂ ábɛ̄l béwúú áte, Edəə́dəŋ éche Ésáá éwōŋgān-nɛ bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petro akagéʼáá mbwɔ́g áte esyəə́l. Ébédé póndé pɔ́g eche ákíí bad bé Dyǒb ábe bébédé á dyad á Lida alɛled. ");
INSERT INTO bssNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Áde ápédé áwed, antán mod awě béchəgɛɛ́ bán Aniɛsɛ. Esóŋ é mekuu énwɛ̄ mɔ́, átīmɛ̄n ndáb mwɛ̌ waam. ");
INSERT INTO bssNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petro anláá mɔ́ aá, “A-Aniɛs, Yesu Krǐstəə ǎdǐd wɛ bwâm hɛ́n bɔɔb. Pádé ásē énabe ádoŋ anɔn.” Ábwɔ̄g-ábwɔ̄g Aniɛsɛ ampádé ásē. ");
INSERT INTO bssNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Áde bad bésyə̄ə̄l ábe bédyɛ́ɛ́ʼáá á Lida ne Sharɔn bényíné nɛ́ɛ ane mod ádyɛ́ɛ́ bwâm, bêmbootéd Sáŋgú Yesuɛ adúbe. ");
INSERT INTO bssNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mwaád nhɔ́g abédé á dyad á Jopa awě béchə́géʼáá bán Tabitaa, andúbé Yesuɛ. (Dǐn á Tabitaa á ehɔ́b é Grikia ádíi bán Dɔkasɛ nɛ́dē eʼsɛ́l.) Á aloŋgé ádē ásyə̄ə̄l mboŋ mɔ́ ne mɔ́ɔ̄ ábɛ́láá áwōŋgān-nɛ betóótōkɛ̄ bé bad. ");
INSERT INTO bssNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ḿmê mesú-ʼɔɔ́, ankwɛ̌ nkole awɛ́-ʼɛ. Bênwobé mɔ́ ndim bétéd mɔ́ bébānē á toŋ e ndáb echě ebédé ámīn. ");
INSERT INTO bssNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Bɔɔb-pɔɔ́ dyad á Jopa dénkênchabnédté dyad á Lida áyə̄l. Né-ɔɔ́, áde bad ábe bédúbpé Yesuɛ béwógé bán Petro adé á Lida, bénlōm bad bébɛ áwē, ne mecháŋgé nɛ́n bán, “Sôn hyǎg á mehélé-te.” ");
INSERT INTO bssNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Né-ɔɔ́ Petro amboŋsɛ́n, bɔ́ɔ̄bɔ̄ɔ békɛ̄-ʼɛ. Áde ápédé áwed, bénchə̄gnēd mɔ́ á toŋ e ndáb eche ebédé ámīn. Bekúd bé bebaád bênləŋnéd mɔ́, béchyɛɛ́ʼ, bélūmtē-ʼɛ mɔ́ mbɔ́té ne nkobe ḿme Dɔkasɛ âmbaŋnédté bɔ́ áde ábédé á aloŋgé. ");
INSERT INTO bssNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petro ambídéd bɔ́ moosyəə́l á ebwɔ́g, akɔ́g mebóbóŋ ábootéd-tɛ akáne. Dɔ́ɔ ákúnné yə̌l á ndim boŋ áhɔ́bé aá, “Á-Tabita, pádé ásē!” Tabitaa andibé mǐd áte. Anyín áde anyíné Petro, ampádé ásē. ");
INSERT INTO bssNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petro ansǎd ekáá, awóŋgɛ́n ânyen mɔ́ ásē. Dɔ́ɔ áchɛ́nlé bad ábe béndūbē Yesuɛ, ne bekúd bé bebaád ábe bémbɛ̄ áhed, boŋ álūmtē bɔ́ Tabitaa áde ádíí á aloŋgé. ");
INSERT INTO bssNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ḿmɛ́n nkalaŋ mênkanléd á dyad á Jopa áte ásyə̄ə̄l a etûn é póndé, ekud é bad édúbé-ʼɛ Sáŋgú Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petro andyɛɛ́ á Jopa nguse é eʼpun. Andyɛɛ́ á ndáb e mod awě abɛléʼáá nsɔ́n mé eʼkob éʼ nyam, awě béchə́géʼáá bán Simɔnɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mod a Roma nhɔ́g abédé á dyad a Kaisaria bán Kɔnɛliɔsɛ. Akǎmlánnáá echoŋ é mbwɔ́kɛl e sə́nze échě béchə́géʼáá bán, “Echoŋ é mbwɔ́kɛl e sə́nze é Italia.” ");
INSERT INTO bssNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kɔnɛliɔsɛ abédé mod awě ahídéʼáá mekan mé Dyǒb ámbīd. Mwěn ne eche ndáb esyəə́l bébɛ́nléʼáá Dyǒb. Ansálé ekáá áte, áwōŋgān betóótōkɛ̄ bé bad bé Israɛl, ákānnē-ʼɛ póndé ésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ebédé dyam ngə́ŋ éláán mǔte nhɔ́g, anyín ndɔ́g. Á ndɔ́g-te wɛ̂ ankǒŋ ángɛl e Dyǒb anyín. Enchəg mɔ́ aá, “Á-Kɔnɛliɔs.” ");
INSERT INTO bssNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Annɔn ángɛl ne chóóŋ, ne mbwɔ́g, boŋ ásɛdté nɛ́n aá, “A-Sáŋ, cheé édé?” Ángɛl enkwɛntɛ́n mɔ́ aá “Dyǒb áwógé ḿmôŋ mekáne, anyíné-ʼɛ ábôŋ eʼboŋ bé nlém. Adé-ʼɛ mboŋsɛ́n âkwɛntɛn wɛ mekáne. ");
INSERT INTO bssNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Bɔɔb-pɔɔ́, lóm bad á Jopa, békɛ̄ béchɛ́le mod nhɔ́g awě dǐn ádíí mɔ́ bán Simɔn awě béchəgɛɛ́ bán Petro. ");
INSERT INTO bssNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Adé nken á ndáb e mod nhɔ́g awě akînteʼ eʼkob éʼ nyam awe béchəgɛɛ́ bán, Simɔnɛ. Simɔnɛ ne adyɛɛʼ á nkəg mé edíb é nkwɛ̌.” ");
INSERT INTO bssNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Dɔ́ɔ ángɛl eched éhídté, boŋ Kɔnɛliɔsɛ áchɛ̄nlē ábē bembəledɛ bé ndáb bébɛ, ne sə́nze pɔ́g echě chɔ́mpē ehídéʼáá mekan mé Dyǒb ámbīd, ebɛ́-ʼɛ sə́nze echě enɔnéʼáá Kɔnɛliɔsɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Aláŋgé-ʼaá bɔ́ dyam ádě ábɛ́nlédé, alóm-mɛ bɔ́ á Jopa. ");
INSERT INTO bssNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Áde békagké, nɛ́ɛ bǐn éʼsáŋgé, áde békwógé apɛ á Jopa, Petro anchə́gé á ndáb mîn âkáne. Nɛ̂ ábédé dyam kəd. ");
INSERT INTO bssNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nzaa enkób mɔ́, ádə̄ŋ-ʼɛ ndyééd adyɛ́. Áde béboŋsanné ndyééd, anyín ndɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Anyín ngáne ngob e dyǒb énédnédé. Chǒm émbīd nɛ̂ŋgáne sáŋkalaa a abad, ébɛ́ nɛ́ɛ béchə́ŋgé dɔ́ mekéb méniin, bésudté dɔ́ ásē. ");
INSERT INTO bssNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Á abad-tê wɛ̂, ndín é nyam ésyə̄ə̄l émbɛ̄ áwēd-te; éche ékɛɛneʼ mekuu méniin, éche édole abum ásē ne menɔn mé ahín. ");
INSERT INTO bssNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Hɛ́ɛ áwógé ehɔ́b élâŋge mɔ́ nɛ́n “A-Petro, syəə́ ásē, éwúu échɛ́n nyam, édyâg.” ");
INSERT INTO bssNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Boŋ Petro anhɔ́b aá, “A-Sáŋ, meéhɛ̄lɛ̄ɛ̄ se ḿbɛ̄l ene ndín e dyam. Meédyédɛ́ɛ́ chǒmchǒm mbêd éche mbéndé éhɔ́bé aá béēdyāg, kéʼɛ éche éesáa áʼsō éʼ Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Échê ehɔ́b émbād mɔ́ aláa nɛ́n aá, “Weetédé chǒm ké ehɔ́g éche Dyǒb áhɔ́bé aá ésáá, wɛɛ́ éesáaʼɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Nɛ́n dêmbɛnléd ngen éláán. Dɔ́ɔ bétímné ádê abad ámbīd ádyōb. ");
INSERT INTO bssNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petro adoléʼáá áte âbíi chǒm éche ene ndɔ́g élûmtɛɛ́. Ene póndé dɔ́ɔ bad ábe Kɔnɛliɔsɛ ánlōmmē bédíbté wɛ́ɛ ndáb eche Simɔnɛ édíí. Béntyēēm á mmwɛ mé eʼkɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Hɛ́ɛ bélébpɛɛ́ ehɔ́b bánken, “Nken adé áte wɛ̂ awě béchəgɛɛ́ Simɔn Petro-yɛ?” ");
INSERT INTO bssNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Áde Petro ádíi ádólé áte âsôŋtɛn chǒm éche ndɔ́g élûmtɛɛ́ dɔ́ɔ Edəə́dəŋ éche Ésáá elâŋgɛɛ́ mɔ́ aá, “Wóglɛ́n! Bad béláán bépédé, béhɛde wɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Né-ɔɔ́ lǎd yə̌l, ésud á ndáb mîn, weebáá bɔ́ ahíd áyə̄le mɛɛ́ nlómé bɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Né-ɔɔ́, Petro ansǔd ásē, ákɛ atán ábê bad, álāŋgē bɔ́ aá, “Mɛɛ́ ndé ane mod awě nyéhɛdɛɛ́. Cheé épídé nyé hɛ́n?” ");
INSERT INTO bssNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bêntimtɛ́n mɔ́ bán, “Mod ambáá a sə́nze, Kɔnɛliɔsɛ mɔ́ɔ alómé sé. Adíi mod a bwâm awě abɛnle Dyǒb. Bad bé Israɛl bésyə̄ə̄l-lɛ bébage mɔ́ edúbé éche échábé ámīn. Ángɛl e Dyǒb eláŋgé mɔ́ nɛ́n aá álébe wɛ áwē ndáb, âbɛl nɛ́n áwôg dyam ádě étə́ŋgɛ́né mɔ́ aláa.” ");
INSERT INTO bssNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petro awógé-ʼaá nɛ̂, asɔ́léd bɔ́ á ndáb, ábɛ̄-ʼɛ bɔ́ eʼnoŋ. Boŋ Petro ansɔ́léd ábê bad á ndáb kénɛ́ɛ béēbédɛɛ́ bad bé Israɛl. Nɛ́ɛ bǐn éʼsáŋgé, Petro anlǎd yə̌l, ahíd ábê bad. Nguse é bad ábe bédúbpé Yesuɛ á Jopa bɔ́mpē bênwoón bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Epun ehɔ́g ámbīd e nɛ̂, Petro bémpɛ̌ á Kaisaria. Kɔnɛliɔsɛ mwěn, ádē abum á ndáb, ne ábē besón bé echoŋ ábe ánlēbɛ̄ɛ̄, bésínéʼáá Petro bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Áde Petro áhɛdɛɛ́ asɔ́l á ndáb, Kɔnɛliɔsɛ ankɛ̌ mɔ́ atán, ákwɛ mɔ́ á mekuu, ábwāām-mɛ ásē âbɛ mɔ́ edúbé. ");
INSERT INTO bssNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Boŋ Petro annyen mɔ́ ásē ahɔ́b aá, “Tyéém ámīn. Mɛ́mpē ndíi moonyoŋ ngɛ̂n.” ");
INSERT INTO bssNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petro ambɛ́ ákanlé Kɔnɛliɔsɛ ádě bésɔ́lɛɛ́ á ndáb-te. Antán nɛ́ɛ ndun e mod éládné á ndáb-te. ");
INSERT INTO bssNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Hɛ́ɛ álâŋgɛɛ́ bɔ́ nɛ́n aá, “Nyé běn nyêbíí bwâm nɛ́n bán edé mod a Israɛl mbéndé âwoon mod awě eésɛ̌ mod a Israɛl kéʼɛ âsɔ́l áwe ndáb. Boŋ Dyǒb álúmté mɛ nɛ́n aá meéchə̄gē modmod mɛɛ́ adé mod awě eesáa kéʼɛ nɛ́ɛ mod awě adé mbinde áʼsō éʼ Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Né-ɔɔ́, áde élómé mɛ achəg mempádé ásē ábwɔ̄g-ábwɔ̄g, menkênhɔ́bpé mɛɛ́ méehyaá. Bɔɔb-pɔɔ́, nsɛdte wɛ, cheé ékə́ə́ boŋ élōmē mɛ achəg?” ");
INSERT INTO bssNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Hɛ́ɛ Kɔnɛliɔsɛ ákwɛntanné mɔ́ aá, “Sú éláán chii, nɛ́ɛ bɔɔb, nkánnéʼáá áwêm ndáb-te á ngə́ŋ éláán éʼ mǔte. Dɔ́ɔ mod awě awáá mesaŋ ḿmě mémwaaʼ áte átyéémé mɛ áʼsō-te təléd. ");
INSERT INTO bssNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Boŋ áhɔ̄bē aá, ‘Á-Kɔnɛliɔs, Dyǒb áwógé wɛ mekáne, ányíné-ʼɛ ábōŋ eʼboŋ bé nlém. ");
INSERT INTO bssNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Lóm mod á Jopa, ákɛ áchɛ́le Simɔnɛ awě béchəgɛɛ́ bán Petro. Adé nken á ndáb wɛ́ɛ mod nhɔ́g awě akînteʼ eʼkob éʼ nyam awě béchəgɛɛ́ bán Simɔnɛ. Simɔnɛ nɛ adyɛɛʼ á nkəg mé edíb é nkwɛ̌.’ ");
INSERT INTO bssNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Né-ɔɔ́ menlóm wɛ atéd ábwɔ̄g-ábwɔ̄g. Ebɛlé-ʼɛ bwâm ngáne épédé. Bɔɔb-pɔɔ́ sé moosyəə́l sêdé hɛ́n, Dyǒb ádé-ʼɛ ne syánē. Sêsineʼ âwóg dyam ké ahéé áde Sáŋ Dyǒbɛ áláŋgé wɛ aá éláa sé.” ");
INSERT INTO bssNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Dɔ́ɔ Petro áhédé pɔ́le á nsəl aá, “Bɔɔb dɔ́ɔ ḿbíí mɛɛ́ Dyǒb átédé moosyəə́l nyaa pɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Akobe kénzɛ́ɛ́ awě abage mɔ́ edúbé awě abɛle-ʼɛ mekan ḿme métə́ŋgɛ́né, ké aloŋ áhéé ane mod ábídté. ");
INSERT INTO bssNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nyêbíí nkalaŋ ḿme Dyǒb dénlōmɛ̄ɛ̄ bad bé Israɛl. Ḿmê nkalaŋ ḿbédɛ́ɛ tə̂ŋgɛne âkal nkalaŋ ḿ bwâm mé nsaŋ ḿme ḿpédé mbwiined ne Yesu Krǐstəə. Mɔ́ adé Sáŋgwɛ́ɛ́ á moosyəə́l. ");
INSERT INTO bssNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nyêbíí-ʼɛ dyam áde dêmbɛnléd mbwɔ́g e Judeya áte esyəə́l mbooted ne á Galilia. Nɛ́n démbɛ̄ áde Jɔnɛ ámáá bad aláa tə̂ŋgɛne edusɛn. ");
INSERT INTO bssNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nyêbíí nɛ́n bán Dyǒb dénwɔ̄gēd Yesuɛ, mod a Nazarɛt, ábɛ mɔ́ Edəə́dəŋ éche Ésáá ábɛ̄-ʼɛ mɔ́ ngíne. Yesuɛ akagéʼáá hǒm tɛ́ɛ́ ábɛlé mboŋ. Ngáne Dyǒb démbɛ̄ɛ̄-ʼaá ne mɔ́, adidéʼáá bad bésyə̄ə̄l ábe bémbɛ̄ ásē e ngíne e Satan bwâm. ");
INSERT INTO bssNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Sé běn sênyínné mekan mésyə̄ə̄l ḿme âmbɛnlé á aloŋ á bad bé Israɛl ne á Jerusalɛm dǐd. Bénwūū mɔ́, abome áde bêmbomɛɛ́ mɔ́ á awɔg. ");
INSERT INTO bssNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Boŋ Dyǒb dêmpuúd mɔ́ ámbīd e eʼpun éʼláán, ábɛl-lɛ bad bényín mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Saké bad bésyə̄ə̄l bénnyīn-nɛ mɔ́. Bad ábe Dyǒb dêmmadté apwɛd, bɔ́ɔ̄ bényīn mɔ́. Nɛ́dē sé ábe sêndyɛ́ ndyééd sêmwɛ́-ʼɛ mmíítéd ne mɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Anlyə́gtɛ́n sé aá sékanle bad nkalaŋ ḿ bwâm, sébīde-ʼɛ mbóŋ nɛ́n bán mɔ́ɔ mɔ́dē Ane awě Dyǒb ápwɛ́dé, âkaad bad ábe bédé á aloŋgé ne ábe béwédé. ");
INSERT INTO bssNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Bekal béʼdəə́dəŋ bésyə̄ə̄l bénhɔ̄b tə̂ŋgɛne mɔ́ bán, mod ké ahéé awě adúbpé mɔ́, Dyǒb dɛ́lagsɛ́n mɔ́ mbéb. Nɛ́n dɛ́bɛnléd á ngíne e ádē dǐn.” ");
INSERT INTO bssNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Áde Petro ádíi áhɔ́bɛɛ́ nɛ̂, Edəə́dəŋ éche Ésáá ênsǔd ásē, épīī moosyəə́l awě áwóglánnáá ḿmê nkalaŋ. ");
INSERT INTO bssNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Bad bé Israɛl ábe béndūbē Yesuɛ, ábe bɔ́ɔbɛ Petro bémbīd á Jopa bémbɛ̄ menyáké bwâmbwam ânyín nɛ́n bán Dyǒb ábágé echě ndɛ e Edəə́dəŋ éche Ésáá kə́ə́ŋne wɛ́ɛ bad ábe béesɛ̌ bad bé Israɛl. ");
INSERT INTO bssNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bénwōg ngáne béhɔ́bɛɛ́ mehɔ́b mémpēe, bébagé-ʼɛ Dyǒb ehúmé. Dɔ́ɔ Petro áhɔ́bɛɛ́ aá, ");
INSERT INTO bssNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ábɛ́n bad békúdé Edəə́dəŋ éche Ésáá melemlem ngáne sɛ́mpē sênkudté. Né-ɔɔ́, nzɛ́-módɛ́ ahɛle-sɛ ahɔ́b aá béedusán bɔ́ ne mendíb?” ");
INSERT INTO bssNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Hɛ́-ʼaá áhɔ́bé aá bédusɛn bɔ́ á dǐn á Yesu Krǐstəə. Dɔ́ɔ ábê bad béláŋgé mɔ́ bán ádyɛɛ ne bɔ́ nguse é eʼpun. ");
INSERT INTO bssNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bembapɛɛ bé nlómag ne bad bémpēe ábe bédúbpé Yesuɛ á mbwɔ́g e Judeya-tê esyəə́l, bénwōg bán bad ábe béesɛ̌ bad bé Israɛl bɔ́mpē békóbé eyale é Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Áde Petro átímé ámbīd á Jerusalɛm, bad ábe béhɔ́béʼáá bán bétə́ŋgɛ́né bad ábe béesɛ̌ bad bé Israɛl ayag, bêmbootéd mɔ́ ahɔ́b bán, ");
INSERT INTO bssNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Cheé ékə́ə́ boŋ ékǎg wɛ́ɛ bad ábe béesɛ̌ bad bé Israɛl, bad ábe béeyagɛɛ́ boŋ nyáābɔ̄ɔ nyédyāg-kɛ kə́ə́ŋne ndyééd hǒm ahɔ́g?” ");
INSERT INTO bssNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Hɛ́-ʼaá Petro áhédé nkalaŋ á nsəl, aláá bɔ́ mekan mésyə̄ə̄l ngáne mêmbɛnlédté se á mbooted. ");
INSERT INTO bssNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Mbédé á mekáne á dyad á Jopa boŋ ńnyīnē ndɔ́g. Chǒm émbīd á ádyōb nɛ̂ŋgáne sáŋkalaa a abad, ébɛ́ nɛ́ɛ béchə́ŋgé dɔ́ mekéb méniin, bésudté dɔ́ ásē. Bênsudéd dɔ́ áwêm eʼsó-te. ");
INSERT INTO bssNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Áde ńnɔ́né áwēd-te menyín nyam éche édé á abad-tê, nyam é mehín, nyam éche édole abum, ne menɔn mé ahín. ");
INSERT INTO bssNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Hɛ́ɛ ńwógé ehɔ́b élâŋge mɛ nɛ́n aá, ‘A-Petro, syəə́ ásē, éwúɛʼ échɛ́n nyam, édyâg.’ ");
INSERT INTO bssNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Boŋ mɛ-ʼɛ menhɔ́b mɛɛ́, ‘A-Sáŋ meéhɛ̄lɛ̄ɛ̄-sɛ ḿbɛ̄l ene ndín e dyam. Chǒmchǒm éche mbéndé éhɔ́bé aá béēdyāg kéʼɛ éche éesáa áʼsō éʼ Dyǒb éēsɔ̄lɛ̄ɛ̄ mɛ á nsəl mbêd.’ ");
INSERT INTO bssNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ehɔ́b émbīd ádyōb ámpē nɛ́n ‘Weetédéʼ chǒm ké ehɔ́g éche Dyǒb áhɔ́bé aá ésáá, wɛɛ́ éēsāaʼɛ́.’ ");
INSERT INTO bssNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Nɛ́n dêmbɛnléd ngen éláán. Dɔ́ɔ bétímné chǒm ésyə̄ə̄l ádyōb. ");
INSERT INTO bssNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ene póndé chěn dɔ́ɔ bad béláán ábe bébídé á dyad á Kaisaria ábe bélómé áwêm, bépédé á ndáb echě ńdyɛ́ɛ́ʼáá áte. ");
INSERT INTO bssNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Edəə́dəŋ éche Ésáá énlāā mɛ aá syáābɔ̄ɔ sékag, aá meebáá bɔ́ ahíd. Ábê bad ntóób ábe bédúbpé Krǐstəə ábe bébídé á Jopa bɔ́mpē bénhīd mɛ á Kaisaria. Syáābɔ̄ɔ moosyəə́l sênkɛ̌ sêsɔ́l á ndáb wɛ́ɛ Kɔnɛliɔsɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kɔnɛliɔsɛ anláá sé ngáne anyíné ángɛl etyéémé áwe ndáb boŋ ene ángɛl eláá mɔ́ aá, ‘Lóm mod á Jopa ákɛ áchəg mod awě mǐn mésyə̄ə̄l médíí bán Simɔn Petro. ");
INSERT INTO bssNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nzé apedé ǎlāā nyé pɔ́le eche ěbɛ̌l boŋ Dyǒb ásōŋ ádōŋ aloŋgé, ásōŋ-ʼɛ ádōŋ abum á ndáb.’ ");
INSERT INTO bssNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ámbīd enɛ̂, mboótédé-ʼaá dyam ahɔ́b, Edəə́dəŋ éche Ésáá épiidé bɔ́ melemlem nɛ̂ŋgáne êmpiíʼɛ́ sé á mbooted. ");
INSERT INTO bssNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Dɔ́ɔ ńkámtɛ́né dyam áde Sáŋgwɛ́ɛ́ ánhɔ̄bpē. Anhɔ́b aá, ‘Jɔnɛ adǔsánnáá bad ne mendíb boŋ bɛ́dusɛ́n nyé ne Edəə́dəŋ éche Ésáá.’ ");
INSERT INTO bssNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Enyînnad nɛ́n bán Dyǒb ábágé ábɛ́n bad ábe béesɛ̌ bad bé Israɛl melemlem mɛ ndɛ ḿme âmbɛɛ́ syánē áde dédúbpé Sáŋgú Yesu Krǐstəə. Nzɛ́ɛ́-ɔ̄ ńdíí âkə́ŋ ntíi ń Dyǒb?” ");
INSERT INTO bssNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Áde béwógé nɛ̂, bénsōg Petro mekan ahɔ́b áyə̄l, bébootéd Dyǒb akɛn. Béhɔ́béʼáá bán, “Dyǒb ábágé kə́ə́ŋne bad ábe béesɛ̌ bad bé Israɛl etə́l âtɛde ḿmab mbéb âtimɛn Dyǒb, âkud-tɛ aloŋgé áde déemaáʼ.” ");
INSERT INTO bssNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Bɔɔb-pɔɔ́, áde béwúú Stefanusɛ, bad ábe bémpāŋtēd áte áyə̄le metake ḿme békúdáá, bɔ́ doŋge á bad bênkɛ̌ kə́ə́ŋse á Fonisia, doŋge ákɛ̄ á Saiprus, ábíníí-ʼɛ békɛ̄ á Antyɔg. Békágéʼáá, békanlé dásɔ̄ bad bé Israɛl běnpɛn nkalaŋ ḿ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Boŋ bad bémpēe ábe béndūbē Yesuɛ ábe bémbīd á myad mé Saiprus ne Sirinɛ, bênkɛ̌ á Antyɔg, békanlé kə́ə́ŋne bad bé Grikia, bélāŋgē-ʼɛ bɔ́ nkalaŋ ḿ bwâm tə̂ŋgɛne Sáŋgú Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ngíne e Sáŋgú embɛ́ ne bɔ́. Ndun e mod endúbe, étīmɛ̄n-nɛ Sáŋgwɛ́ɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ḿmê myaŋgó mêmpɛ̌ á metúu mé bad bé mwembé ń Jerusalɛm. Né-ɔɔ́, bénlōm Banabasɛ á dyad á Antyɔg âkɛ dɛ́nyīn bɔ́ áwed. ");
INSERT INTO bssNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Áde ápédé áwed boŋ anyín ngáne Dyǒb ánámté bad, anwóg menyiŋge, ambɛ̌-ʼɛ bɔ́ elébé aá béhídeʼ Sáŋgwɛ́ɛ́ ne nlém nhɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabasɛ abédɛ́ɛ mod a bwâm, Edəə́dəŋ éche Ésáá émbɛ̄ ne mɔ́, adúbe dénwūū-ʼɛ mɔ́ áte bwâmbwam, ekud é bad-tɛ éndūbē. ");
INSERT INTO bssNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Dɔ́ɔ Banabasɛ ákíí á dyad á Tasus âhɛd Sɔɔlɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Áde ányíné mɔ́, ampɛɛ́n mɔ́ á Antyɔg. Né-ɔɔ́ á etûn é mwɛ̌ nhɔ́g, bɔ́ bad bébɛ bébóméʼáá ne bad bé mwembé. Bén'yə̄gēd-tɛ ndun e mod. Á Antyɔg wɛ̂ dɔ́ɔ bésébpé bad ábe bédúbpé Yesuɛ dǐn achuu bán Bad bé Krǐsto. ");
INSERT INTO bssNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ḿmê mesú děn, doŋge á bekal béʼdəə́dəŋ bênhidé á Jerusalɛm békɛ á Antyɔg. ");
INSERT INTO bssNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Bɔ́ mod nhɔ́g awě béchə́géʼáá bán Agabusɛ antyéém ámīn. Á ngíne e Edəə́dəŋ échě Ésáá, anhɔ́b aá, “Nzaa e ngíne ekwógé apɛ, ěbɛ̄-ʼɛ nkǒŋsé-te ńsyə̄ə̄l.” Nɛ́n dêmbɛnléd-tɛ á póndé eche Kladios ábédé á nkamlɛn. ");
INSERT INTO bssNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Bembapɛɛ béntīī nɛ́n bán bɔ́ mod tɛ́ɛ́ bɛ́lōmē nwôŋgɛn wɛ́ɛ bad ábe bédúbpé Yesuɛ á mbwɔ́g e Judeya ngáne bɔ́ mod tɛ́ɛ́ áhɛnlé akud. ");
INSERT INTO bssNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nɛ̂ děn-naá bêmbɛnlé. Bênlǎd mɔné, bélómɛ́n Banabasɛ bɔ́ Sɔɔl âbɛ wɛ́ɛ belyə́ged bé mwembé. ");
INSERT INTO bssNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Bɛnbɛn ne ene póndé chěn, kə̂ŋ Hɛrɔdɛ ambootéd doŋge á bad bé mwembé ahɛ́ á meséb. ");
INSERT INTO bssNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ambɛ̌l bénkōb Jemsɛ, Jɔnɛ mwǎnyaŋ, béwúɛ́n mɔ́ nkwáté. ");
INSERT INTO bssNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Áde ányíné nɛ́n aá nɛ̂ áwógté bad bé Israɛl menyiŋge, ankɛ̌ áʼsō, ábɛl békób Petro. Nɛ́n dêmbɛnléd á póndé e Ngande e Ewɛle é Ngɛ̂n. ");
INSERT INTO bssNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Áde bémáá Petro akób, anlóm mɔ́ á mbwɔg. Bêmbané eʼchoŋ éʼ sə́nze éʼniin ânɔn mɔ́. Echoŋ tɛ́ɛ́ énwōŋ sə́nze éniin. Hɛrɔdɛ anwóŋ mewêmtɛn âkáad mɔ́ áʼsō éʼ mbwɔ́g nzé Ngande e Nnyíme ámīn etómé. ");
INSERT INTO bssNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Né-ɔɔ́ bémbane Petro á mbwɔg. Boŋ bad békánnéʼáá Dyǒb ngíne ngíne áyə̄l echê. ");
INSERT INTO bssNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Hɛrɔdɛ ahɛdéʼáá Petro apɛɛn áʼsō éʼ bad mbwɛmbwɛ. Ḿmê nkuu měn ḿme Hɛrɔdɛ ánwōŋgē mewêmtɛn âpɛɛn Petro áʼsō éʼ bad chǎn ábíníí, Petro akúnéʼáá átîntê e sə́nze ébɛ. Bénhɛ̄ mɔ́ bengɔbéngɔ̄bē pɛd ébɛ, sə́nze émpēe ébɛ énɔné mmwɛ ń ndáb e mbwɔg. ");
INSERT INTO bssNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Dɔ́ɔ ángɛl e Sáŋgú ébídé təléd, ndáb e mbwɔg épɛné áte. Ángɛl ne enságéd Petro á ekəgɛ́l, ényem mɔ́ ásē, élāŋgē mɔ́ aá, “Pádé ásē á mehélé-te.” Ábwɔ̄g-ábwɔ̄g bengɔbéngɔ̄bē bênhunnéd mɔ́ á mekáá. ");
INSERT INTO bssNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Dɔ́ɔ ángɛl élâŋgɛɛ́ mɔ́ aá, “Wéd ngə́ə́ atád, étâd-tɛ nkɔɔd mé metámbé.” Petro ambɛ̌l áned. Dɔ́ɔ ángɛl élâŋgɛɛ́ mɔ́ aá, “Hɛ́ mbɔ́té á yə̌l, éhíde mɛ.” ");
INSERT INTO bssNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petro anhíd chɔ́, bébíd á ndáb e mbwɔg. Boŋ kénɛ̂ enkêmbííʼɛ́ ké dyam áde ángɛl ébɛlɛɛ́ děn ákoo abɛnled. Anwémtɛ́n aá mɔ́nyīneʼ ndɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Béntōm echoŋ e sə́nze éʼsó ámīn, bétōm-mɛ éche élóntɛ́né éʼbɛ kə́ə́ŋ ne á asóg bêmpɛ̌ á mmwɛ mé eʼkɛ́ bé eʼkii ḿmě ḿbídéʼáá á dyad-tê. Nsəl mé eʼkɛ́ méndibnéd ne mɔ́ mwěn. Hɛ́ɛ bébídé boŋ béhīdē nzii. Áde békagké nɛ̂ děn dɔ́ɔ ángɛl ne étɛ́dté Petro ábwɔ̄g-ábwɔ̄g. ");
INSERT INTO bssNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Hɛ́ɛ debyɛ́ɛ́ ápédé Petro boŋ áhɔ̄bē aá, “Bɔɔb dɔ́ɔ ḿbíí mɛɛ́ dyam děn dɔ́ɔ ákooʼ abɛnled. Sáŋgwɛ́ɛ́ alómé eche ángɛl, asoó-ʼɛ mɛ á mekáá ḿme Hɛrɔdɛ, abɛlé-ʼɛ mbídé mekan mésyə̄ə̄l áte ḿme bad bé Israɛl bénwēmtɛ̄nnē mɛ abɛl.” ");
INSERT INTO bssNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Acheméʼáá dyam áde ábɛnlad ne mɔ́, dɔ́ɔ ákíí á ndáb wɛ́ɛ Maria, awě achyáá Jɔn Makɔsɛ. Ndun e mod enladɛ́n áhed békânneʼ. ");
INSERT INTO bssNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Áde Petro ápédé ankǔm ekob éche édé á ebwɔ́g-te boŋ mbəledɛ a mmwaád nhɔ́g bán Rodaa, áhyɛ ánɔné mod awě akume ekob. ");
INSERT INTO bssNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Anchem Petro ehɔ́b. Dɔ́-ʼaá ne menyiŋge mésyə̄ə̄l áchādtɛ̄nē ekob adibe, atóm mehélé ámbīd á ndáb-te boŋ ákɛ aláá bad aá, “Petro atyéémé á ebwɔ́g-te.” ");
INSERT INTO bssNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bénlāā mɔ́ bán, “Epag mǐn!” Boŋ ambɛ́ álāŋgē bɔ́ aá chǒm éche mɔ́hɔ́bɛɛ́ édé mbále. Dɔ́ɔ béhɔ́bɛɛ́ bán, “Né eche ángɛl chɔ́ edé.” ");
INSERT INTO bssNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Áde ḿmɛ́n mésyə̄ə̄l mébɛnladté Petro ambɛ́ ákuméʼ ekob. Kə́ə́ŋne á asóg bêndibé ekob. Bényíné-ʼaá mɔ́, yə̌l ekɔ́m bɔ́ áte bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ampebtɛ́n bɔ́ ekáá aá bélâm ehɔ́b, boŋ álūmtē bɔ́ áte ngáne Sáŋgwɛ́ɛ́ ábídté mɔ́ á mbwɔg. Anláá bɔ́ aá, “Nyéláa Jemsɛ ne bad ábíníí ábe bɔ́mpē bédúbpé Yesuɛ ḿmɛ́n mekan.” Dɔ́ɔ átɛ́dté bɔ́ boŋ ákag hǒm démpēe. ");
INSERT INTO bssNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Áde bǐn éʼsáŋgé, sə́nze éche énɔ́néʼáá Petro êmpuutéd á mewêmtɛn bwâmbwam áyə̄le bénkêmbííʼɛ́ chǒm éche ébɛ́nlédé Petro. ");
INSERT INTO bssNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Hɛrɔdɛ anlóm bad aá béhɛd mɔ́ boŋ bénkênhɛnlé mɔ́ anyín. Hɛ́ɛ ákáádté échê sə́nze boŋ ábagé mbakú aá béwúu bɔ́. Áde ḿmɛ́n mésyə̄ə̄l métómé Hɛrɔdɛ ansyəə́ á Judeya ákɛ ádyɛ̄ɛ̄ á Kaisaria á esóŋ é póndé. ");
INSERT INTO bssNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ene póndé Hɛrɔdɛ anwóón bad bé myad mé Tirɛ ne Sidɔn meliŋgá ḿme méchábé ámīn. Né-ɔɔ́, bad bémbīd ḿmê myad mébɛ âkɛ dɛ́nyīn mɔ́. Mod awě bénsēbɛ̄ɛ̄ akɛ dɛ́tán âbɛl bɔ́ɔbɛ kə̂ŋ bétim ásē abédɛ́ɛ Blastusɛ. Blastusɛ abédɛ́ɛ mbəledɛ á ndáb e kə̂ŋ. Bêmbɛl nɛ̂ áyə̄le á aloŋ wɛ́ɛ Hɛrɔdɛ dɔ́ɔ ḿmab medyɛ́ mébídéʼáá. ");
INSERT INTO bssNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Epun éche Hɛrɔdɛ ántīīʼɛ́ épédé-ʼaá áte, awáá megombe mé kə̂ŋ, ádyɛ̄ɛ̄ atii dé nkamlɛn boŋ ábootéd bɔ́ mam aláa. ");
INSERT INTO bssNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Áde ámáá ahɔ́b, ábê bad bêmbootéd abón bán, “Dyǒb děn dɔ́ɔ áhɔ́beʼ saké moonyoŋ.” ");
INSERT INTO bssNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ábwɔ̄g-ábwɔ̄g ángɛl e Sáŋgú embɛ̌l Hɛrɔdɛ ankwɛ̌ nkole áyə̄le enkêmbaá Dyǒb edúbé. Eʼkɛn bé abum béndyɛ̄ mɔ́ áte, awɛ́-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Eyale é Dyǒb chɔ́-ʼɛ émbɛ̄ ékanláád ékag áʼsō. ");
INSERT INTO bssNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabasɛ bɔ́ Sɔɔl bêmmǎd ḿmab nsɔ́n béhīdē-ʼɛ á Jerusalɛm. Áde béhidtɛɛ́, bénwālē Jɔn Makɔsɛ áyə̄l. ");
INSERT INTO bssNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Á mwembé mé Antyɔg, doŋge dé bekal béʼdəə́dəŋ ne bemeléede bébédé áwed. Ábê bad bébédɛ́ɛ Banabasɛ, Simionɛ (awe béchə́géʼáá bán Ehíndɛɛ), Lusiɔsɛ (awe ambíd á Sirinɛ), Manahɛnɛ (awe bɔ́ Ngɔ́menaa Hɛrɔdɛ békwógé hǒm ahɔ́g) ne Sɔɔlɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Á póndé echě bébɛnlɛɛ́ Sáŋgwɛ́ɛ́ bédidé-ʼɛ yə̌l nzaa á mekáne-tê, dɔ́ɔ Edəə́dəŋ éche Ésáá élâŋgɛɛ́ bɔ́ nɛ́n aá, “Nyébanned mɛ Banabasɛ bɔ́ Sɔɔl âbɛl boŋ bébɛle mɛ nsɔ́n ḿme ḿpwɛ́dé bɔ́ mɛɛ́ bébɛl.” ");
INSERT INTO bssNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ábê bekal béʼdəə́dəŋ ne bemeléede bénkānē, bédīd-tɛ yə̌l nzaa á mekáne-tê, bébán Banabasɛ bɔ́ Sɔɔl mekáá á nló boŋ bélōmē bɔ́ bán békag. ");
INSERT INTO bssNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Né-ɔɔ́, Edəə́dəŋ éche Ésáá énlōm Banabasɛ bɔ́ Paalɛ. Dɔ́ɔ békíí á dyad á Selusia. Áhed-taá bésyə́ŋgé boŋ békǎg á mbwɔ́g e Saiprus eche mendíb mélə́ŋnédé. ");
INSERT INTO bssNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Áde bépédé á dyad á Salamis, békáléʼáá eyale é Dyǒb á ndáb é mekáne. Bénwálé Jɔn Makɔsɛ áyə̄l âwóŋgɛn bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bênkɛ̌ ádê aloŋ áte áde mendíb mélə́ŋnédé kə́ə́ŋ bépɛ̄ á dyad á Pafɔs. Áde bépédé áhed, béntān mod a ngaŋ nhɔ́g awě béchə́géʼáá bán Báá Yesu. Abédɛ́ɛ mod a Israɛl awě anchəg yə̌l aá mɔ́díi nkal éʼdəə́dəŋ a Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Báá Yesuɛ abédɛ́ɛ nsón a echoŋ awě Sɛgyus Paolusɛ. Sɛgyus Paolusɛ mɔ́ abédé nkamlɛnɛ a ene mbwɔ́g echě mendíb mênləŋnédté. Abédɛ́ɛ mod awě anwóŋ debyɛ́ɛ́ bwâmbwam. Ane ngɔ́menaa anchɛ́lé Banabasɛ bɔ́ Sɔɔl áyə̄le ahɛdéʼáá eyale é Dyǒb awóg. ");
INSERT INTO bssNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Boŋ anɛ́n mod awě dǐn démbɛ̄ɛ̄ á ehɔ́b é Grikia bán Elimasɛ enkênháá bɔ́ etə́l. Ahɛdéʼáá aá nkamlɛnɛ a mbwɔ́g eedúbpé nkalaŋ ḿ bwâm. ");
INSERT INTO bssNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Dɔ́ɔ Sɔɔlɛ awě béchə́géʼáá ámpē bán Paalɛ, ngáne ánlōnnē ne Edəə́dəŋ éche Ésáá, ánɔ́né ane mod a ngaŋ á mǐd-te, ");
INSERT INTO bssNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","boŋ áhɔ̄bē aá, “A-mwǎn a Satan! Ekɔɔ́ dyam ké ahéé áde ádé bwâm. Mwane mé mbéb mwěn ne mwěn-ɛɛ́ ńlóné wɛ áte. Póndé ésyə̄ə̄l ebɛlé éhɛdé wɛ́ɛ mɔ́həŋlɛn mbále eche Sáŋgwɛ́ɛ́ mɔ́timed chɔ́ metóm. ");
INSERT INTO bssNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Sáŋgú Dyǒbɛ ǎkɔ̄gsɛ̄n wɛ bɔɔb nɛ́n děn. Wɛ̌kwɛ̌ ndím, wéenyínɛ́nné-ʼɛ á esóŋ é póndé.” Ábwɔ̄g-ábwɔ̄g Elimasɛ anwóg nɛ̂ŋgáne mbag ékwédé mɔ́ á mǐd-te, ábootéd-tɛ ahyɔ́m âhɛd mod awe ǎchə̄ə̄ mɔ́ á ekáá. ");
INSERT INTO bssNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Áde ngɔ́menaa ányíné dyam áde ábɛ́nlédé, andúbé Yesuɛ. Yə̌l enkɔ́m mɔ́ áte bwâmbwam áyə̄l e ayə́ge áde Paalɛ bɔ́ Banabasɛ béyə́gtéʼáá tə̂ŋgɛne Sáŋgú Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paalɛ bɔ́ɔbɛ baáb bénsɔ̄l a Stíma a Pafɔs békɛ kə́ə́ŋ bépɛ̄ á dyad á Pɛga á mbwɔ́g e Pamfilia. Boŋ Jɔn Makɔsɛ anlyə́g bɔ́ áwed asú mɔ́ ámbīd á Jerusalɛm. ");
INSERT INTO bssNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bênsyəə́ á Pɛga bépɛ̄ á dyad á Antyɔg á aloŋ á Pisidia. Á mbwɛ-mé-nkɔ́me-áte, bênkɛ̌ á ndáb e mekáne bédyɛ̄ɛ̄ ásē. ");
INSERT INTO bssNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bénwōg nɛ́ɛ béláá epɛd á kálag e mbéndé eche Mosɛɛ ne á kálag e metelag mé bekal béʼdəə́dəŋ. Áde bémáá aláŋ dɔ́ɔ belyə́ged bé ndáb e mekáne bélébpɛɛ́ Paalɛ bɔ́ Banabasɛ nɛ́n bán, “A-baányaŋ, nzé nyêwóó pɔ́le echě eéwēd bad nlém á abum, nyêhɔ́b chɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Dɔ́ɔ Paalɛ átyéémé ámīn, apebtán bɔ́ ekáá aá bélâm ehɔ́b, boŋ abootéd dyam ahɔ́b. Anhɔ́b aá, “A-baányaŋ bé Israɛl ne bad bémpēe ábe nyêdé hɛ́n bɔɔb ábe nyêbɛnle Dyǒb, nyéwóglɛn me. ");
INSERT INTO bssNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Dyǒb á bad bé Israɛl dêmpwɛ̌d ábɛ̄d betaa ábɛ̄l-lɛ ábē bad bébūū áte á póndé eche bébédé nɛ́ɛ beken á aloŋ á Egipto. Ámbīd enɛ̂, ambɛnléd eche ngíne echě echabé ámīn âbíded bɔ́ a Egipto. ");
INSERT INTO bssNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Á etûn é móom mé mwɛ̌ méniin, anwɛsɛ́n bɔ́ á ehyáŋge. ");
INSERT INTO bssNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Dyǒb démbēbɛ̄d meloŋ saámbé á ndɔɔb e Kanahan, ábɛ̄-ʼɛ echǎb ndɔɔb wɛ́ɛ ábē bad. ");
INSERT INTO bssNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ḿmɛ́n mésyə̄ə̄l mêmbɛnléd á etûn é dyam mbwɔ́kɛl e mwɛ̌ éniin ne móom mé mwɛ̌ métáan. Ámbīd enɛ́n, Dyǒb dêmbɛ̌ bɔ́ bad ábe bɛ́kāādtē kə́ə́ŋne á póndé echě nkal éʼdəə́dəŋ Samwɛlɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Áde béhɛ́dé kə̂ŋ, Dyǒb dêmbɛ̌ bɔ́ Sɔɔlɛ, mwǎn awe Kishɛ. Ambíd á túmbé e Bɛnjamin, abédɛ́ɛ kə̂ŋ á etûn e móom mé mwɛ̌ méniin. ");
INSERT INTO bssNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Dɔ́ɔ Dyǒb áhúdé Sɔɔlɛ á atii. Ahúdé-ʼaá mɔ́, átīmēd Dabidɛ. Anhɔ́b tə̂ŋgɛne Dabidɛ aá, ‘Nkudé nyaa e mod eche ńdə́ə́, Dabidɛ, mwǎn awe Jesɛ. Adíi mod awě ǎbɛ̌l mam mésyə̄ə̄l ḿme ńhɛdɛɛ́ mɛɛ́ ábɛl.’ ");
INSERT INTO bssNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Yesuɛ mɔ́-ʼɛ awě abídé á nchyáátɛ́n ḿme Dabidɛ mɔ́ɔ̄ Dyǒb dêmbɛnlé Nsoodɛ a bad bé Israɛl, ngáne ánhɔ̄bpē aá mɔ́ɔ̄bɛ̌l. ");
INSERT INTO bssNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Byánán Yesuɛ ǎbootéd ḿme nsɔ́n, Jɔnɛ áláŋgéʼáá bad bé Israɛl aá békunned mbíd, bétɛde ḿmab mbéb, békud-tɛ edusɛn. ");
INSERT INTO bssNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Áde Jɔnɛ ákwɔ́gé ḿme nsɔ́n amad, ansɛdéd bad aáken, ‘Nzɛ́-módɛ́ nyéwémtɛ́né bán ndé. Saké mɛ ndé ane awě nyésinɛɛ́. Nyénɔneʼ, Ahúɛʼ ámbīd echêm, mměn meékwognedɛɛ́ âhune mɔ́ metámbé á mekuu.’ ” ");
INSERT INTO bssNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Paalɛ ambád ahɔ́b aá, “A-baányaŋ bé mbyaa ḿme Abrahamɛ ne bad ábe bébɛnle Dyǒb hɛ́n bɔɔb, syánē-ɛɛ́ bélómmé ḿmɛ́n nkalaŋ mé eʼsoósoŋ. ");
INSERT INTO bssNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Bad ábe bédyɛ́ɛ́ʼáá á Jerusalɛm ne ábab belyə́ged bénkêmbííʼɛ́ bán Yesuɛ mɔ́ɔ adé Nsoodɛ. Bénkênsóŋtɛ́n-naá metelag mé bekal béʼdəə́dəŋ ḿme bélááʼáá á mbwɛ-mé-nkɔ́me-áte tɛ́ɛ́. Kénɛ̂ bêmbɛ̌l mekan ḿme bekal bé edəə́dəŋ bénhɔ̄bpē ménlōn, ahɔ́b áde bénhɔ̄bpē bán béwúu Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Kénɛ́ɛ bénkênkudté nzɔm echě bɛ́tōmēdtē mbakú nɛ́n bán atə́ŋgɛ́né awɛ́, bénlāā Payledɛ bán ábɛl béwúu Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Áde bémáá mekan mésyə̄ə̄l abɛl ngáne méténlédé á kálag e Dyǒb tə̂ŋgɛne mɔ́, bênsudéd mɔ́ á awɔg, bébānē mɔ́ á soŋ-tê. ");
INSERT INTO bssNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Boŋ Dyǒb dêmpuúd mɔ́. Ámbīd e nɛ̂, ");
INSERT INTO bssNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","anlúméd yə̌l ngen ne ngen wɛ́ɛ bad ábe bɔ́ɔ̄bɔ̄ɔ bênwǒŋ bootya á Galilia âpɛ á Jerusalɛm. Bɔɔb ábê bad bɔ́ɔ békanleʼ bad bé Israɛl dyam áde bényīnnē. ");
INSERT INTO bssNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Bɔɔb-pɔɔ́ ḿmɛ́n nkalaŋ ḿ bwâm mɔ́ɔ sépíínédé nyé. Ḿmê nkalaŋ ńdíi nɛ́n bán dyam áde Dyǒb dénhɔ̄bpē aá mɔ́ɔ̄bɛ̌ ábɛ̄d betaa alónté dɔ́ ne syánē. ");
INSERT INTO bssNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Alónté dyam áde ánhɔ̄bpē ne syánē awě dedé nchyáátɛ́n ḿmāb, apuud áde ápúúdté Yesuɛ. Né-ʼaá éténlédé á kálag e Ngəse e Dyǒb echě elóntɛ́né ébɛ bán, ‘Edíi awem mwǎn, chii ndíi Sóó.’ ");
INSERT INTO bssNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Dyǒb dêmpuúd mɔ́ ésebán atime ámbīd á ndɔɔb se ábɔɔ. Dyǒb dénhɔ̄b tə̂ŋgɛne nɛ̂ aá, ‘Mɛ̌bɛ̌ wɛ nnam ń ngəŋgú, ḿme méehidté ásē, ḿme ménhɔ̄bpē mɛɛ́ mɛ̌bɛ̌ kə̂ŋ Dabidɛ.’ ");
INSERT INTO bssNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Né-ʼaá áhɔ́bé pɛd empée wɛ́ɛ éténlédé bán, ‘Wéekwɛntɛ́nné wɛɛ́ awôŋ mbəledɛ awě abɛnle wɛ ne nlém nhɔ́g ábɔɔ á soŋ-tê.’ ");
INSERT INTO bssNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Debíí nɛ́n bán áde kə̂ŋ Dabidɛ ábédé á aloŋgé, abɛ̌nléʼáá Dyǒb ngáne Dyǒb áhɛ́déʼáá. Ámbīd e nɛ̂, anwɛ́, bélímé mɔ́ wɛ́ɛ bénlīmɛ̄ɛ̄ ábē betaa, ábɔ̄ɔ̄-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Boŋ ane awě Dyǒb dêmpuúdté, enkêmbɔɔ́-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Bɔɔb-pɔɔ́, a-baányaŋ, nyêtə́ŋgɛ́né abíi bwâm nɛ́n bán, Yesuɛ mɔ́ akəə́ boŋ békanlé nyé bán Dyǒb álagsan bad mbéb. ");
INSERT INTO bssNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Nyébíi-ʼɛ nɛ́n bán kénzɛ́ɛ́ awě adúbpé mɔ́ akǒbnédé áʼsō éʼ Dyǒb nɛ́ɛ mod awě atə́ŋgɛ́né. Mbéndé e Mosɛ eéhɛleʼaá-sɛ ébɛl ákobnéd. ");
INSERT INTO bssNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Né-ɔɔ́, nyétêd póndé âbɛl boŋ dyam dé ebébtéd áde bekal béʼdəə́dəŋ bénhɔ̄bpē déebɛnláád ne nyé. Bénhɔ̄b bán, ");
INSERT INTO bssNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Nɔnéʼ, nyé bad ábe nyêwɛle Dyǒb! Yə̌l ěkɔ̄m nyé áte, nyɛ́ɛ̄wɛ̄-ʼɛ, áyə̄le nɛ́n, dyam áde mɛ́bɛnlé ḿmɛ́n mesú, ádíi dyam ádé nyéedúbɛ́ɛ́ ké mod anlúméd nyé áte.’ ” ");
INSERT INTO bssNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Póndé echě Paalɛ bɔ́ Banabasɛ bébídɛɛ́ á ndáb e mekáne, bad bénlāā bɔ́ bán bépɛ ámpē á mbwɛ-mé-nkɔ́me-áte ḿme ńhúɛʼ âhyɛ dɛ́láa bɔ́ ḿmê mekan ámpē. ");
INSERT INTO bssNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Áde bad bémáá ahide á mekáne, bad bé Israɛl híin ne bad híin bémpēe ábe bénwōŋ adúbe á bad bé Israɛl bénhīd Paalɛ bɔ́ Banabasɛ. Paalɛ bɔ́ Banabasɛ bênkalɛ́n ábê bad, béwéd-tɛ bɔ́ nlém á abum bán bébɛ̂ békude ḿmɛ́n nsimé ḿme Dyǒb ábágé bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Á mbwɛ-mé-nkɔ́me-áte ḿme mémbādtɛ̄n, bɛnbɛn ne baásyə̄ə̄l ábe bébédé á dyad-tê wɛ̂, bêmmaá ámbīd, âhyɛ dɛ́wóg eyale éche Sáŋgwɛ́ɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Áde bad bé Israɛl bényíné ene ndun e mod, kɔ́njí embɛ́ bɔ́ áte bwâmbwam. Dyam tɛ́ɛ́ áde Paalɛ áhɔ́béʼáá, béhɔ́béʼáá bán ádíi metóm, béhɔ̄bē-ʼɛ mɔ́ mekan mé mbéb á yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Paalɛ bɔ́ Banabasɛ bémbɛ̄ béhɔ̄bē bɔɔb ésebán bébáaʼ dyamdyam. Béhɔ́béʼáá nɛ́n bán, “Nyé bad bé Israɛl nyɛ́ɛ séntə̄ŋgɛ̄nnē eyale é Dyǒb asébe dé akale. Boŋ ngáne nyébáá chɔ́ áyə̄l, nyéētéde-ʼáa yə̌l nɛ́ɛ bad ábe békwógnédé âkud aloŋgé áde déemaáʼ, né-ɔɔ́, sɛ́ɛ̄tɛdé nyé, sékɛ wɛ́ɛ bad ábe béesɛ̌ bad bé Israɛl. ");
INSERT INTO bssNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Dyam áde Dyǒb áhɔ́bé aá débɛl ádíi, nɛ́n, ‘Mbǎnné wɛ nɛ́ɛ eʼnyínɛn bé ekíde éʼ bad ábe béesɛ̌ bad bé Israɛl âbɛl boŋ bad bé nkǒŋsé bésyə̄ə̄l békud eʼsoósoŋ áwoŋ mbíd.’ ” ");
INSERT INTO bssNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Áde bad ábe béēbéde bad bé Israɛl béwógé nɛ̂, bémbɛ̄ menyiŋge, békɛné-ʼɛ nkalaŋ ḿme Sáŋgwɛ́ɛ́. Bad ábe bépwɛ́dnédé nɛ́n bán bɛ́kǔd aloŋgé ádě déemaáʼ béndūbē Sáŋgú Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Moosyəə́l awě ambɛ́ ene pɛd e mbwɔ́g anwóg nkalaŋ ḿme Sáŋgwɛ́ɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Boŋ bad bé Israɛl bénkōn baámbáá bé dyad ne bebaád bémbáá ábe bébɛ́nléʼáá Dyǒb. Béchódé-ʼaá Paalɛ bɔ́ Banabasɛ yə̌l áte, bénān-nɛ bɔ́ áwab mbwɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Áde béhɛdɛɛ́ akɛ, bênkǔd ebumbú á mekuu âlúmed ábê bad nɛ́n bán nkɔ́gsɛn ne bɔ́. Áde bémáá abɛl nɛ̂ bênkɛ̌ á dyad á Ekɔniɔm. ");
INSERT INTO bssNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Bad ábe béndūbē Yesuɛ á dyad á Antyɔg bénlōn ne menyiŋge bélón-nɛ ne Edəə́dəŋ éche Ésáá. ");
INSERT INTO bssNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Áde Paalɛ bɔ́ Banabasɛ bépédé á Ekɔniɔm, bênkɛ̌ á ndáb e mekáne. Bênkǎl nkalaŋ ḿme Yesuɛ áwed, nyaa echě bad híin bé Israɛl ne ábe béebéde bad bé Israɛl béndūbɛ̄ɛ̄ Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Boŋ bad bé Israɛl ábe bénkênkobé adúbe, bénkōn bad ábe béesɛ̌ bad bé Israɛl, béhɛ́ bɔ́ mewêmtɛn mé mbéb áte tə̂ŋgɛne bad ábe béndūbē Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Paalɛ bɔ́ Banabasɛ bêmběm áhed, békalé nkalaŋ tə̂ŋgɛne dyam á bwâm áde Dyǒb ábɛ́nlé bad ésebán bébáaʼ dyamdyam. Sáŋgú Yesuɛ ambɛ̌l bénlūmēd eʼchemléd, bébɛ̄l-lɛ menyáké híin, âlúmed nɛ́n bán mam ḿmě ábê bembapɛɛ békáléʼáá tə̂ŋgɛne ḿmē nsimé médé mbále. ");
INSERT INTO bssNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Nkabɛ́n mémbɛ̄ átîntê e bad bé dyad. Doŋge á bad bêntimɛ́n bad bé Israɛl ábíníí-ʼɛ bétīmɛ̄n bembapɛɛ bé nlómag. ");
INSERT INTO bssNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Dɔ́ɔ bad ábe béesɛ̌ bad bé Israɛl ne bad bé Israɛl nchoo ne ábāb benkamlɛnɛ bétíídé bán bɛ́tagéd Paalɛ bɔ́ Banabasɛ bán bɛ́lūm-mɛ bɔ́ meláá. ");
INSERT INTO bssNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Áde Paalɛ bésóŋtɛ́né nɛ̂, bênsǒb békɛ̄ á mbwɔ́g e Likonia bésɔ́l á myad mé Listra ne Debɛ ne abwɔ́g áde ábédé bɛnbɛn. ");
INSERT INTO bssNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Békáléʼáá nkalaŋ ḿ bwâm ḿmɛ̂ mebwɔ́g mésyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Mod abédé á dyad á Listra, mekuu ménwɛ̄ mɔ́. Nê dɔ́ɔ bénchyāāʼɛ́ mɔ́, eékíi-ʼáa mbêd. ");
INSERT INTO bssNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Áde Paalɛ ákalɛɛ́ nkalaŋ ḿ bwâm, ambɛ́ áhed áwōglān. Paalɛ annyín aá awóó adúbe aá mɔ́hɛle mɔ́dyɛ̄ɛ̄ bwâm, dɔ́ɔ Paalɛ ánɔ́né mɔ́ chóóŋ, ");
INSERT INTO bssNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","boŋ áchə̄gtē ehɔ́b ámīn aá “Syəə́ ásē, étyéem ámīn.” Ane mod ahebé-ʼaá ámīn, ábootéd-tɛ akɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Áde ndun e mod echě ebédé áhed ényíné dyam áde Paalɛ ábɛ́lé, bénhɛ̄ eʼsaád á ehɔ́b é Likonia bán, “Myǒb mésúdé ásē métímé baányoŋ, âhyɛ dé awôŋgɛn sé.” ");
INSERT INTO bssNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bênchə̌g Banabasɛ bán mɔ́ adé dyǒb áde béchəgɛɛ́ bán Zɛusɛ béchə̄g-kɛ Paalɛ bán mɔ́ adé dyǒb áde béchəgɛɛ́ bán Hɛmɛsɛ áyə̄le mɔ́ ahɔ́bpéʼáá búmɔ̄. ");
INSERT INTO bssNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Abón áde bébɛ́nléʼáá dyǒb áde béchəgɛɛ́ bán Zɛusɛ áte ábédé ámbīd e dyad. Né-ɔɔ́, prisɛ awě Zɛusɛ ampɛɛ́n nyag ne mbonja á mmwɛ mé eʼkɛ́ éʼ dyad. Ambɛl nɛ̂, áyə̄le bɔ́ɔbɛ ene ndun e mod béhɛ́déʼáá Paalɛ bɔ́ Banabasɛ mendɛ abɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Áde Banabasɛ bɔ́ Paalɛ béwógé dyam áde ábê bad béhɛdɛɛ́ abɛl, bênsalted mbɔ́té á yə̌l, bényə̄gēd bésɔ́l átîntê e ene ndun e mod bébōnē béhɔ̄bē bán, ");
INSERT INTO bssNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Cheé ékə́ə́ boŋ nyébɛlé nɛ́n? Sémpē sêdíi baányoŋ melemlem ngáne nyɛ́ɛ̄ nyédíí. Sêpedé hɛ́n, âkale nyé nkalaŋ ḿ bwâm ḿme Yesuɛ, âbɛl boŋ nyéchene ábɛ́n bwěm ábe béesě dyam dé abɛlɛn, nyéhíde Dyǒb dé aloŋgé áde áhə́gé nkoŋ ḿ mín, ń sé ne edíb e nkwɛ̌ ne bwěm éʼsyə̄ə̄l ábe éʼdé áwēd-te. ");
INSERT INTO bssNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Bɔɔ́d Dyǒb dêntɛdé bad bésyə̄ə̄l âbɛl kéchéé éche bédə́ə́. ");
INSERT INTO bssNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Boŋ kénɛ̂, alûmte eʼchemléd nɛ́n aá mɔ́dē, abɛl áde ábɛlɛɛ́ mekan mé bwâm. Alômme nyé mbúú echě ebídé ádyōb, ábagé-ʼɛ nyé mbote á póndé eche etə́ŋgɛ́né. Abage nyé medyɛ́, áwōgtē-ʼɛ nyé menyiŋge.” ");
INSERT INTO bssNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ké nɛ̂ŋgáne Paalɛ bɔ́ Banabasɛ bénhɔ̄bpē ḿmɛ́n mekan mésyə̄ə̄l, éebédɛɛ́ bɔ́ mwǎn e akan âkə́ŋ bad âbɛ mendɛ ḿme béhɛ́déʼáá abɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Doŋge á bad bé Israɛl bémbīd á dyad á Antyɔg á mbwɔ́g e Pisidia, bébíd-tɛ á dyad á Ekɔniɔm bépɛ̄ á Listra. Béntēd ene ndun e mod nlém á abum, bɔ́ɔ̄bɔ̄ɔ bélúm Paalɛ meláá, bédol mɔ́ ásē, bébíded mɔ́ á dyad-tê ne mewêmtɛn nɛ́n bán awédé. ");
INSERT INTO bssNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Boŋ ádé bad ábe bédúbpé bépédé boŋ béləŋnéd mɔ́, anhidé ásē átīm ámbīd á dyad-tê. Nɛ́ɛ bǐn éʼsáŋgé, dɔ́ɔ bɔ́ Banabasɛ békíí á dyad á Debɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paalɛ bɔ́ Banabasɛ bênkǎl nkalaŋ ḿ bwâm á dyad á Debɛ, bêmbɛ̌l bad híin bétīm bébɛ́ bembapɛɛ ábe Yesuɛ. Ámbīd enɛ̂, bêntǐm ámbīd á myad mé Listra, Ekɔniɔm ne Antyɔg á mbwɔg e Pisidia. ");
INSERT INTO bssNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Hǒm ké áhéé áde bêmpɛɛ́, béyə́gtéʼáá bad ábe bédúbpé Yesuɛ béwéde-ʼɛ bɔ́ nlém á abum, âbɛl bétyéem á adúbe-tê. Béyə́gtéʼáá bɔ́ bán “Detə́ŋgɛ́né metake akud boŋ dɛɛ́sɔ̄l á nkamlɛn ń Dyǒb.” ");
INSERT INTO bssNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Mwembé ké ńhéé ḿme bêmpɛɛ́, bépwɛ́dáá bad ábe bélyə́gteʼ ḿme mwembé. Nzé bénkānē, bédīd-tɛ yə̌l nzaa á mekáne-tê, bébɛ̄ belyə́ged á mekáá ḿme Sáŋgwɛ́ɛ́ awě bésúmé nlém á yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Áde bémádé mbwɔ́g e Pisidia áte, bêmpɛ̌ á mbwɔ́g e Pamfilia. ");
INSERT INTO bssNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bênkǎl eyale é Dyǒb á dyad á Pɛga, boŋ bésyɔgké á dyad á Atalia. ");
INSERT INTO bssNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Áhed-taá bésyə́ŋgé boŋ béchabpé edib, betimé ámbīd á Antyɔg, wɛ́ɛ bénkānnēdtē bɔ́ bán nsimé ń Dyǒb ńlyə́ged bɔ́ áyə̄le nsɔ́n ḿme bémádé bɔɔb. ");
INSERT INTO bssNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Áde bépédé á Antyɔg, bênlǎd bad bé mwembé áte, béláá bɔ́ mekan mésyə̄ə̄l ḿme Dyǒb ábɛ́lé mbwiined ne bɔ́. Bénlāā-ʼɛ bɔ́ ngáne Dyǒb ánédté nzii echě bad ábe béesɛ̌ bad bé Israɛl bédúbpɛɛ́ Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Bênkoód-tɛ mwǎ adyɛɛ áwed ne bad ábe bédúbpé Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bad behɔ́g bémbīd á mbwɔ́g e Judeya bépɛ̄ á Antyɔg. Bêmbootéd bad ayə́ged nɛ́n bán, “Nzé béeyage mod ngáne mbéndé e Mosɛ éhɛdɛɛ́, né éekudté eʼsoósoŋ.” ");
INSERT INTO bssNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Nɛ́n dêmbɛ̌l Paalɛ bɔ́ Banabasɛ béswáŋtánnáá ngíne ngíne kə́ə́ŋ bɔ́ɔ̄bɔ̄ɔ bétíí bán Paalɛ bɔ́ Banabasɛ ne nguse é bad émpēe békɛ á Jerusalɛm, békɛ bényîn bembapɛɛ bé nlómag ne belyə́ged bé mwembé tə̂ŋgɛne ádê atɔ́n. ");
INSERT INTO bssNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Bad bé mwembé bénlyə̄gēd bɔ́ á nzii. Bêmbwɛ̌ á mbwɔ́g é Fonisia ne Samaria béláŋgé bad ngáne bad ábe béesɛ̌ bad bé Israɛl bédúbpé Dyǒb. Ḿmɛ́n nkalaŋ ménwōgēd bad ábe bédúbpé Yesuɛ menyiŋge. ");
INSERT INTO bssNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Áde Paalɛ bɔ́ Banabasɛ bépédé á Jerusalɛm, mwembé ḿme médé áwed, bembapɛɛ bé nlómag ne belyə́ged bé mwembé bênkob bɔ́ nken. Paalɛ bɔ́ Banabasɛ bénlāā bɔ́ mekan ḿme Dyǒb ábɛ́lé mbwiined ne bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Boŋ doŋge á bad ábe bédúbpé Yesuɛ ábe bémbē epepé éche Befarisia béntyēēm ámīn, béhɔ́b bán, “Bétə́ŋgɛ́né bad ábe béesɛ̌ bad bé Israɛl ábɛ bédúbpé Yesuɛ ayag, béláá-ʼɛ bɔ́ bán bétə́ŋgɛ́né mbéndé éche Mosɛɛ ahíd.” ");
INSERT INTO bssNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Dɔ́ɔ bembapɛɛ bé nlómag ne belyə́ged bé mwembé békóbé mbom ânɔn ádê akan áte. ");
INSERT INTO bssNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Áde bélébé aswaŋtɛn dɔ́ɔ Petro átyéémé ámīn boŋ áhɔ̄bē aá, “A-baányaŋ, édé etûn é póndé bɔɔb áde Dyǒb ápwɛ́dé mɛ átîntê echɛ̂n, âkale bad ábe béesɛ̌ bad bé Israɛl nkalaŋ ḿ bwâm âbɛl nɛ́n béwôg mɔ́ bédúbe-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Dyǒb áde ábíí-ʼɛ moosyəə́l nlém áte, álúmté aá mɔ́bagé bad ábe béesɛ̌ bad bé Israɛl kunze âdúbe, abɛ áde ábágé bɔ́ Edəə́dəŋ éche Ésáá melemlem ngáne ábágé syánē ámpē. ");
INSERT INTO bssNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Dyǒb dénkêntédté bɔ́ aá bédé nhəŋlɛ́n ne syánē ké mwǎmpīn. Anlagsɛ́n bɔ́ mbéb áyə̄le adúbe áde bénwālɛ̄ɛ̄. ");
INSERT INTO bssNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Bɔɔb-pɔɔ́, cheé ékə́ə́ boŋ nyéhɛdéʼ Dyǒb akəg, âpémed bad ábe bédúbpé Yesuɛ nted ḿme ábɛ̄d betaa bénkênhɛnlé apém ḿme ké syánē déehɛlɛɛ́ apém? ");
INSERT INTO bssNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Éebooʼɛ́ nɛ̂! Dedúbpé dekudé-ʼɛ eʼsoósoŋ mbwiined ne nsimé ḿme Sáŋgú Yesuɛ, melemlem ngáne bɔ́mpē békúdé.” ");
INSERT INTO bssNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Moosyəə́l anlám ehɔ́b béwōglān Banabasɛ bɔ́ Paal. Banabasɛ bɔ́ Paal békánléʼáá bɔ́ eʼchemléd ne menyáké ḿme Dyǒb ábɛ́lé mbwiined ne bɔ́ átîntê e bad ábe béesɛ̌ bad bé Israɛl. ");
INSERT INTO bssNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Áde bémádné, dɔ́ɔ Jemsɛ áhɔ́bɛɛ́ aá, “A-baányaŋ, nyéwóglɛn mɛ! ");
INSERT INTO bssNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simɔnɛ alúmté syánē áte hɛ́n bɔɔb ngáne Dyǒb ábootédé ábē eʼboŋ bé nlém alúmed wɛ́ɛ bad ábe béesɛ̌ bad bé Israɛl, átéd áde átédé bad átîntê echâb âbɛ́ ábē bad. ");
INSERT INTO bssNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nɛ́n děn ábɛ́lé eʼyale ábê nkal éʼdəə́dəŋ éʼlóné. Éténlédé nɛ́n bán, ");
INSERT INTO bssNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Mɛ Sáŋgwɛ́ɛ́ nhɔ́bé mɛɛ́, nzé nɛ́n ámáá atóm, mɛ̌pɛ̌ ámpē, mɛ̌lōŋ ndáb echě Dabidɛ ámpē echě empáa. Mɛ̌lōŋ chǒm ésyə̄ə̄l éche émpāŋtēd áte ńtīmēd-tɛ chɔ́ ngáne énsēbɛ̄ɛ̄ abɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Nɛ̂ dɛ́bɛ̌l bad bé nkǒŋsé bésyə̄ə̄l bɛ́pɛ̌ áwêm, ḿpwɛdé bad ábe béesɛ̌ bad bé Israɛl âbɛ́ ábêm bad. Mɛ Sáŋgwɛ́ɛ́ mɛɛ́ nhɔ́be. ");
INSERT INTO bssNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Mɛ́ɛ mbɛlé boŋ ḿmɛ́n mekan mébyɛ́ɛ́n seʼ bɔɔ́d.’ ” ");
INSERT INTO bssNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Dɔ́ɔ Jemsɛ ákagké áʼsō aá, “Ne mɛ, ḿmêm mewêmtɛn médé nɛ́n mɛɛ́ deétagté bad ábe béesɛ̌ bad bé Israɛl ábe bétímné Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Chǒm éche détə́ŋgɛ́né abɛl édíi âtele bɔ́ kálag nɛ́n bán béēdyāg medyɛ́ ḿmě bébágé myǒb mémpēe nɛ́ɛ mendɛ, áyə̄le ḿmê medyɛ́ méēsáaʼɛ́, béēkābē mesón, béēdyāg nyam echě béēsɛ̄lɛ̄ɛ̄ nkə́ŋ, béēdyāg-kɛ mekií. ");
INSERT INTO bssNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Debíí nɛ́n bán seʼ bɔɔ́d bélááʼáá mbéndé éche Mosɛɛ á ndáb é mekáne á mbwɛ-mé-nkɔ́me-áte. Békale-ʼɛ ábē eʼyale dyad ne dyad tɛ́ɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Dɔ́ɔ bembapɛɛ bé nlómag ne belyə́ged bé mwembé, ne bad bé mwembé bésyə̄ə̄l bényíné nɛ́n bán ébóó bán bépwɛd bad átîntê echâb, bélôm bɔ́ á Antyɔg nchoo ne Paalɛ bɔ́ Banabasɛ. Bêmpwɛ̌d Judasɛ awě béchə́géʼáá bán Basabasɛ bɔ́ Sailas, bɔ́ bad bébɛ ábe bélyə́gtéʼáá átîntê echâb. ");
INSERT INTO bssNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Kálag eche bénlōmɛ̄nnē bɔ́ á Antyɔg, ebédé nɛ́n, “Sé bembapɛɛ bé nlómag, ne belyə́ged bé mwembé, ábɛn baányaŋ, sêlômme nyé melɛntɛn. Nyé ábe nyêdé bǎnned ábe nyéēsɛ̌ bad bé Israɛl. Nyé ábe nyêdyɛɛ á dyad á Antyɔg ne á mbwɔ́g é Siria ne Silisia. ");
INSERT INTO bssNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Sêsóŋtɛ́né nɛ́n bán bad behɔ́g ábe bébídé áwɛ̄d, bêmpɛ̌ áwɛ̄n, bépuutád nyé nló áte ne mam ḿme béhɔ́béʼáá. Boŋ nyébíi nɛ́n bán sênkêmbagké bɔ́ kunze âbɛl nɛ̂. ");
INSERT INTO bssNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Né-ɔɔ́, sêdyɛɛ́ ásē moosyəə́l sêtíídé nɛ́n bán ébóó sépwɛd doŋge á bad âlóm bɔ́ áwɛ̄n. Bɛ́woón Paalɛ bɔ́ Banabasɛ ábe sédə́ə́ bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Bɔ́ bad bébɛ bébagé yə̌l âbɛle echɛd Sáŋ Yesu Krǐstəə ésebán bébáaʼ kwééd. ");
INSERT INTO bssNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Né-ɔɔ́, sêlômme nyé Judasɛ bɔ́ Sailas, bɛ́lāā nyé melemlem mé mekan ḿme séténlé nyé. ");
INSERT INTO bssNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Edəə́dəŋ éche Ésáá élyə́gté sé âtíi nɛ́n séetagté nyé ne mekan mémpēe étōmɛɛ́ ḿmɛ́n mekan ḿme médé etognɛ́n. ");
INSERT INTO bssNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Nyéedyág medyɛ́ ḿme bébágé myǒb mémpēe nɛ́ɛ mendɛ, nyéedyág mekií, nyéedyág nyam ké pɔ́g echě béēsɛ̄lɛɛ́ nkə́ŋ, nyéēkābē-ʼɛ mesón. Nzé nyéēbɛ̄lē ḿmɛ́n mekan né ébǒŋ. Dényînneʼ ámpē.” ");
INSERT INTO bssNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Áde bémáá ene kálag atel, bénlyə̄gēd ábê bad á nzii, békɛ-ʼɛ á Antyɔg. Áde bépédé áwed, bênlǎd bad ábe bédúbpé Yesuɛ bésyə̄ə̄l áte boŋ bébɛ bɔ́ kálag. ");
INSERT INTO bssNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Áde ábê bad béláá ene kálag, bémbɛ̄ menyiŋge bwâmbwam áyə̄le nkalaŋ mé eʼwéd bé nlém ḿme ḿbédé áwēd-te. ");
INSERT INTO bssNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judasɛ bɔ́ Sailas bébédɛ́ɛ bekal béʼdəə́dəŋ, bênkalɛ́n-nɛ bɔ́ áyə̄le e etûn é póndé, bénhɔ̄dēd bɔ́ mewêmtɛn béwéd-tɛ bɔ́ nlém á abum. ");
INSERT INTO bssNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Áde bélébé mwǎ adyɛɛ áwed, bad ábe bédúbpé Yesuɛ bénlyə̄gēd bɔ́ ne nsaŋ boŋ bétīm ámbīd wɛ́ɛ bad ábe bénlōm bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paalɛ bɔ́ Banabasɛ bêndyɛɛ́ á Antyɔg mwǎ etûn é póndé. Béyə̄gtē, békalé-ʼɛ eyale éche Sáŋgwɛ́ɛ́ nlatɛ́n ne ekud é bad émpēe. ");
INSERT INTO bssNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Éebemɛɛ́ áte ámbīd enɛ̂, dɔ́ɔ Paalɛ álâŋgɛɛ́ Banabasɛ aá, “Détim ámbīd, dékɛ dénɔn ábɛ̄d baányaŋ bé Krǐsto dyad-tɛ́ áde dékálé nkalaŋ ḿme Sáŋgwɛ́ɛ́, boŋ déhɛd-tɛ áte ngáne mekan mékɛɛ́nɛɛ́ bɔ́.” ");
INSERT INTO bssNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabasɛ anwóŋ mewêmtɛn âwále Jɔn Makɔsɛ áyə̄l, ");
INSERT INTO bssNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","boŋ Paalɛ annyín aá éetə̂ŋgɛnɛɛ́, áyə̄le Jɔn Makɔsɛ ansébé bɔ́ achene á nzii áde béēpīdɛ̄ɛ̄ nsɔ́n á asóg. Antɛdé bɔ́ á dyad á Pamfilia átīm ámbīd. ");
INSERT INTO bssNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mpentɛn ń ngíne mêmpɛ̌ átîntê echâb kə́ə́ŋ békābɛ̄n áte. Banabasɛ antéd Makɔsɛ béchābē edib békɛ̄ á aloŋ a Saiprus. ");
INSERT INTO bssNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paalɛ ámpē ampwɛ̌d Sailasɛ. Baányaŋ bé Krǐsto bénkānnēd bɔ́ bán nsimé ḿme Sáŋgwɛ́ɛ́ ńlyə́gte bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Paalɛ ambwɛɛ́n Sailasɛ á mbwɔ́g e Siria ne Silisia békag béwēdē mwembé áte. ");
INSERT INTO bssNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paalɛ bênkɛ̌ á myad mé Debɛ ne Listra. Mod nhɔ́g abédé áwed awě béchə́géʼáá bán Timotiɛ. Nyaá abédɛ́ɛ mmwaád a Israɛl, mɔ́mpē andúbé Yesuɛ, boŋ sáá abédɛ́ɛ mod a Grikia. ");
INSERT INTO bssNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Bad ábe bédúbpé Krǐstəə á myad mé Listra ne Ekɔniɔm bésyə̄ə̄l bénhɔ̄b mam mé bwâm tə̂ŋgɛne Timotiɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ngáne Paalɛ áhɛ́déʼáá Timotiɛ awále áyə̄l, an'yag mɔ́. Ambɛl nɛ̂ áyə̄le bad bé Israɛl ábe bébédé ḿme mebwɔ́g bémbīī bán Timotiɛ sáá adíi mod a Grikia. ");
INSERT INTO bssNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Paalɛ bɔ́ Timoti békágéʼáá myad ne myad bélāŋgē bad ábe bédúbpé Krǐstəə mekan ḿme bembapɛɛ bé nlómag ne belyə́ged bé mwembé bé Jerusalɛm bétíídé, bélāŋgē-ʼɛ bɔ́ bán béhíde ḿmê mekan. ");
INSERT INTO bssNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Né-ɔɔ́, mwembé ńsyə̄ə̄l mêmbootéd awúu áte á adúbe-tê mesoŋgé mé bad-tɛ méchə̄gkē epun-tɛ́ɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paalɛ bɔ́ɔbɛ baáb bêmbwɛ̌ á mbwɔ́g e Frigia ne Galesia áyə̄le Edəə́dəŋ éche Ésáá énkênkwɛntɛ́nné aá békal nkalaŋ ḿ bwâm á mbwɔ́g e Esia. ");
INSERT INTO bssNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Áde bépédé á nchii ḿ mbwɔ́g e Misia bênwanɛ́n asɔ́l á mbwɔ́g e Bitinia, boŋ Edəə́dəŋ éche Yesuɛ énkêmmwaá aá bésɔ̂l. ");
INSERT INTO bssNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Né-ɔɔ́, béntōm á Misia, bésyɔ̄gē kə́ə́ŋ bépɛ̄ á dyad á Troas. ");
INSERT INTO bssNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ḿmê nkuu Paalɛ annyín ndɔ́g. Á ndɔ́g-te wɛ̂, mod a mbwɔ́g e Masɛdonia antyéém áchāā mɔ́ aá, “Hyǎg, á Masɛdonia, éhyɛ éwôŋgɛn sé.” ");
INSERT INTO bssNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paalɛ amaá-ʼaá ndɔ́g anyín, dɔ́ɔ séládé yə̌l âkɛ á Masɛdonia áyə̄le sêndǒl áte nɛ́n bán Dyǒb áchɛ́nlé sé âkal nkalaŋ ḿ bwâm áwāb. ");
INSERT INTO bssNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Sênsɔ́l á Stíma á Troas, sékɛ̄ á Samotras ésebán sêtyéeme á nzii. Nɛ́ɛ bǐn éʼsáŋgé sétiméʼ á Niopoli. ");
INSERT INTO bssNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Sêbídé-ʼaá áhed, sékɛ a Filipi. Filipi adíi dyad ámbáá á mbwɔ́g e Masɛdonia. Ábédé kə́ə́ŋne dyad áde mbéndé é Roma chěmpɛn chɔ́ɔ bébɛ́nládtáá. Sêdyɛɛ́ áhed nguse é eʼpun. ");
INSERT INTO bssNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Á Mbwɛ-mé-nkɔ́me-áte, sênsyəə́ á dyad-tê sékɛ̄ á nkin mé edíb. Sênwémtɛ́n bán sɛ́ɛ̄tān abwɔ́g á hǒm áhed wɛ́ɛ bad bé Israɛl békânnɛɛ́. Sêndyɛɛ́ áhed ne bebaád ábe séntānnē nɛ́ɛ béládné áhed, syáābɔ̄ɔ sékaleʼ. ");
INSERT INTO bssNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Átîntê e ábê bebaád mmwaád nhɔ́g abédé áhed awě béchə́géʼáá bán Lidia awě ambíd á dyad á Tiatira. Akábéʼáá nyoŋgé, ásōmēʼ mebad ḿme méyəgeʼ ḿme mélɛ́lé nkun. Ane mmwaád abɛ̌nléʼáá Dyǒb. Sáŋgwɛ́ɛ́ ankɛ́léd-tɛ mɔ́ nlém á abum âwóglɛn chǒm éche Paalɛ áhɔ́bɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Bêndusɛ́n mwěn ne eche ndáb esyəə́l. Ámbīd enɛ̂, anlébé sé áwe ndáb. Anhɔ́b aá, “Nzé édé bán nyêtédé mɛ nɛ̂ŋgáne mod awě akoó Yesuɛ adúbe, nyéhyɛ nyédyɛ̄ɛ̄ áwêm ndáb.” Ambádnɛ́n sé kə́ə́ŋ sékɛ̄-ʼɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Epun ehɔ́g-kɔɔ́, sênkɛ̌ á abwɔ́g dé mekáne, dɔ́ɔ ngɔndérɛ e ntâŋ pɔ́g étáné sé. Edəə́dəŋ é mbéb émbɛ̄ mɔ́ áte, ébɛ́léʼáá álāŋgē bad mam ḿme mɛ́bɛnléd áʼsō é póndé. Ene ngaŋ échě ákúméʼáá embɛ̌l bad ábe bênchan mɔ́ ntâŋ békudé ndun e mɔné. ");
INSERT INTO bssNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Hɛ́ɛ ábóótédé syáābe Paalɛ ahíd, ábōnē aá, “Ábɛ́n bad bédíi bembəledɛ ábe Dyǒb á Ngum. Béhyédé nyé aláa ngáne nyɛ́mwɛɛ́ eʼsoósoŋ akud.” ");
INSERT INTO bssNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ene ngɔndérɛ elébé abɛl nɛ̂, epun ne epun-tɛ́. Kə́ə́ŋne á asóg Paalɛ anlǐŋ, dɔ́ɔ ákúnnédé boŋ álāŋgēʼ échê edəə́dəŋ éche émbɛ̄ ene ngɔndérɛ aá, “Á dǐn á Yesu Krǐstəə, nkamlan we nɛ́n mɛɛ́, bíd enɛ́n ngɔndérɛ áte!” Ábwɔ̄g-ábwɔ̄g échê edəə́dəŋ émbīd mɔ́ áte. ");
INSERT INTO bssNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Áde bad ábe bênchǎn ene ngɔndérɛ ntâŋ, bényíné bán nzii e ngáb ekɔ́nlédé bɔ́, bêntɔ̌l Paalɛ bɔ́ Sailas bédolé bɔ́, békɛ̄ɛ̄n bɔ́ wɛ́ɛ benkamlɛnɛ ábe bébédé átîntê e dyad. ");
INSERT INTO bssNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bêmpɛɛ́n bɔ́ wɛ́ɛ benkamlɛnɛ bé Roma, bélāŋgē bɔ́ bán, “Ábɛ́n bad bédíi bad bé Israɛl, boŋ bépédé áwɛ̄d hɛ́n, bépɛ́ɛ́né mpoŋgé. ");
INSERT INTO bssNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Béyə́gte bad eʼlem bé mbéb ábe mbéndé éche syánē éehɛdɛɛ́. Syánē běn dedíi bad bé Roma, né-ɔɔ́, deéhɛ̄lɛ̄ɛ̄-sɛ dékob nɛ̂, deéhɛ̄lɛ̄ɛ̄-ʼɛ-sɛ dehíd nɛ̂.” ");
INSERT INTO bssNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Amute dɔ́mpē dénsɔ̄l áte ábónléd Paalɛ bɔ́ Sailas. Dɔ́ɔ benkamlɛnɛ bé Roma bésáltédé bɔ́ mbɔ́té béhúd-tɛ bɔ́ chɔ́ á yə̌l. Dɔ́ɔ bélómé bad bán béswâdted bɔ́ eʼtaŋgú. ");
INSERT INTO bssNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bémáá-ʼaá bɔ́ awanɛn bwâm boŋ béhāg bɔ́ á mbwɔg, béláá-ʼɛ nnɔné mbwɔg bán eehúdé bɔ́ dǐd á yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Béláŋgé-ʼaá nnɔné mbwɔg nɛ̂, ahɛ́ bɔ́ á toŋ e ndáb e meláá echě edé áte. Anhɛ́ bɔ́ eʼpwɔg á mekuu. ");
INSERT INTO bssNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Dyam melúde mé nkuu, Paalɛ bɔ́ Sailas békánnéʼáá békɔ̄nnē-ʼɛ Dyǒb ngəse. Bad bé mbwɔg ábíníí bésyə̄ə̄l béwóglánnáá bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ábwɔ̄g-ábwɔ̄g dɔ́ɔ ndɔɔb énə́ŋnédé ásē ngíne-ngíne. Ndáb e mbwɔg énə́ŋnéd se á mekon. Melemlem mé póndé eʼkob éʼsyə̄ə̄l bêndibnéd, bengɔbéngɔ̄bē ábe bémbɛ̄ bad bésyə̄ə̄l áyə̄l bénhunnéd. ");
INSERT INTO bssNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Áde nnɔné mbwɔg ápádté ásē boŋ anyín ngáne eʼkob éʼsyə̄ə̄l éʼnédnédé, anwémtɛ́n aá bad bé mbwɔg bésyə̄ə̄l bémáá asob. Hɛ́ɛ átédé páá aá mɔ́sooʼ yə̌l. ");
INSERT INTO bssNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Dɔ́ɔ Paalɛ áchə́gté ehɔ́b ámīn boŋ álēbpē aá, “Weewúɛ́ yə̌l! Sé moosyəə́l sêdé hɛ́n!” ");
INSERT INTO bssNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Hɛ́ɛ nnɔné mbwɔg áhɔ́bé aá bépiined mɔ́ etrúkáŋ, asɔ́l á ndáb-te, ákwɛ̄ Paalɛ bɔ́ Sailas á mekuu ánəəʼ ne mbwɔ́g ń ngíne. ");
INSERT INTO bssNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Dɔ́ɔ ábídné bɔ́ á ebwɔ́g boŋ ásɛdté bɔ́ aáken, “A besáŋ, cheé ńtə́ŋgɛ́né abɛl âkud eʼsoósoŋ?” ");
INSERT INTO bssNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bénlāā mɔ́ bán “Dúbé Sáŋgú Yesuɛ, boŋ ékud eʼsoósoŋ, ádôŋ abum á ndáb dɔ́mpē dɛ́kǔd.” ");
INSERT INTO bssNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Bênkalé mɔ́ ne moosyəə́l awě ambɛ́ mɔ́ á ndáb nkalaŋ ḿ bwâm ḿme Sáŋgwɛ́ɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ene póndé chěn, ḿmê nkuu, ane nnɔné mbwɔg antéd bɔ́, áwōbē bɔ́ síi áte. Hɛ̂ děn bêndusɛ́n mɔ́ ne eche ndáb esyəə́l. ");
INSERT INTO bssNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Dɔ́ɔ ásɔ́nlé Paalɛ bɔ́ Banabasɛ á ndáb-te boŋ ábagé bɔ́ ndyééd. Mwěn ne ádē abum á ndáb bémbɛ̄ menyiŋge áyə̄le adúbe. ");
INSERT INTO bssNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Nɛ́ɛ bǐn éʼsáŋgé, benkamlɛnɛ bénlōm plûsɛ ne nlébtéd nɛ́n bán, “Nyéchene ábê bad békag.” ");
INSERT INTO bssNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Hɛ́ɛ nnɔné mbwɔg álâŋgɛɛ́ Paalɛ aá, “Benkamlɛnɛ bélómé nlébted nɛ́n bán béchene nyé Sailas. Né-ɔɔ́, nyébîd nyékag ne nsaŋ.” ");
INSERT INTO bssNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Dɔ́ɔ Paalɛ álâŋgɛɛ́ échê plǔsɛ nɛ́n aá, “Béswádtédé sé eʼtaŋgu á nhɛ́né áde séebɛlɛɛ́ dyamdyam, áde sédíí-ʼaá bad bé aloŋ á Roma, béhɛ́-ʼɛ sé á mbwɔg. Boŋ bɔɔb béhɛdé sé abíded á mesɔɔm-tê-yɛ? Éehɛlɛ́ɛ́-sɛ ébé nɛ̂. Ábê benkamlɛnɛ bé Roma běn bétə́ŋgɛ́né apɛ béhyɛ bébídéd sé.” ");
INSERT INTO bssNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Plǔsɛ ênkɛ̌ benkamlɛnɛ bé Roma aláa ngáne Paalɛ áhɔ́bé. Áde ábê benkamlɛnɛ béwógé bán Paalɛ bɔ́ Sailas bédíi bad bé Roma, mbwɔ́g menkób bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Né-ɔɔ́, bênkɛ̌ Paalɛ bɔ́ Sailas acháŋ, bébídéd bɔ́ á mbwɔg béláá-ʼɛ bɔ́ bán éboŋ bán bésyəə áwāb dyad. ");
INSERT INTO bssNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paalɛ bɔ́ Sailas bémbīd á ndáb e mbwɔg, békɛ̄ á ndáb wɛ́ɛ Lidia. Áde bépédé áhed, béntān bad ábe bédúbpé Krǐstəə. Paalɛ bɔ́ Sailas bénlāā ábê bad eʼyale ábe éʼwéde bɔ́ nlém á abum. Bémáá-ʼaá bɔ́ aláa boŋ bésyəŋgé. ");
INSERT INTO bssNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paalɛ bɔ́ Sailas bêmpǒŋ á myad mé Amfipolis ne Apolonia, bépɛ̄ á dyad á Tɛsalonika. Ndáb e mekáne e bad bé Israɛl embɛ́ áhed. ");
INSERT INTO bssNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paalɛ ammɛntɛ́n akɛ á ndáb e mekáne, né-ɔɔ́ ankɛ̌ áwed. Andyɛɛ́ áwed sɔ̂ndɛ́ éláán. Á Mbwɛ mé Nkɔ́me áte tɛ́ɛ́, akǎnléʼáá bad nkalaŋ ngáne ḿbídé á kálag e Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Atógnádtáá bɔ́ mam ḿme ákánléʼáá bɔ́, álūmtē-ʼɛ bɔ́ áte nɛ́n aá Ane-awě-Béwɔ́gté atə́ŋgɛ́né nɛ́ɛ ákúdé metake ápūū-ʼɛ ámbīd e kwééd. Aláŋgéʼáá bɔ́ aá “Anɛ́n Yesuɛ awě ńlâŋgɛɛ́ nyé nɛ́n, mɔ́ adé Ane-awě-Béwɔ́gté.” ");
INSERT INTO bssNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Doŋge á bad béndūbē bán chǒm éche Paalɛ áhɔ́bɛɛ́ édé mbále, né-ɔɔ́, bêntimɛ́n Paalɛ bɔ́ Sailas. Bad bé Grikia híin ábe béndūbē Dyǒb ne ndəle é bebaád bé dyad híin bɔ́mpē bêntimɛ́n Paalɛ bɔ́ Sailas. ");
INSERT INTO bssNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Boŋ doŋge á bad bé Israɛl bésíídéʼáá Paalɛ bɔ́ Sailas. Né-ɔɔ́, bênlǎd doŋge á bad bé mpoŋgé áte, ábe bébédé á dyad-tê. Bêmbuú áte bépɛ̄ɛ̄n-nɛ etɔgké é ngíne. Bêmpɛɛ́n epuutéd dyad áte ásyə̄ə̄l, béból á ndáb wɛ́ɛ Jasɛnɛ âbɛl boŋ békôb Paalɛ bɔ́ Sailas bébídɛ́n bɔ́ á tə̂l e ékwɛ́ɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Boŋ áde bénɔné Paalɛ bɔ́ Sailas boŋ béenyíne bɔ́, bêndǒl Jasɛnɛ ne bad bémpēe ábe bédúbpé Yesuɛ, bépɛ̄ɛ̄n bɔ́ áʼsō é benkamlɛnɛ bé dyad. Bébónéʼáá bán, “Ábɛ́n bad bépɛ́ɛ́né epuutéd hǒm ásyə̄ə̄l. Bɔɔb-pɔɔ́, bépédé kə́ə́ŋne áwe syánē dyad. ");
INSERT INTO bssNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasɛnɛ ákōō-ʼɛ bɔ́ áwe ndáb. Bébóoʼ mbéndé eche Kaisɛɛ. Béhɔ́be nɛ́n bán kə̂ŋ empée edé eché béchəgɛɛ́ bán Yesuɛ.” ");
INSERT INTO bssNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ḿmɛ́n mekan ḿme bénhɔ̄bpē mêmbɛ̌l ene ndun e mod ne benkamlɛnɛ bé dyad bépuuted. ");
INSERT INTO bssNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Benkamlɛnɛ bé dyad bêmbɛ̌l Jasɛnɛ ne bad ábe bédúbpé ábe bénkōbpē, bɔ́ɔ̄bɔ̄ɔ bésábé mɔné âbɛl bétɛde bɔ́, boŋ bétɛdté bɔ́. ");
INSERT INTO bssNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Bǐn éʼhíné-ʼaá hínɛ́n, bad ábe bédúbpé Yesuɛ bélóm Paalɛ bɔ́ Sailas á Bɛria. Áde bépédé áwed bênkɛ̌ á ndáb e mekáne. ");
INSERT INTO bssNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bad bé Bɛria bénwōŋ nlém âwóglɛn eyale é Dyǒb tómaa bad bé Tɛsalonika. Epun-tɛ́, bélááʼáá kálag e Dyǒb âsóŋtɛn ânyín ké mekan ḿme Paalɛ bɔ́ Sailas béhɔ́béʼáá médé mbále. ");
INSERT INTO bssNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ekud é bad éndūbē. Ndəle é bebaád bé Grikia híin ne baachóm bé Grikia híin bɔ́mpē béndūbē. ");
INSERT INTO bssNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Boŋ áde bad bé Israɛl bé Tɛsalonika béwógé bán Paalɛ akalé eyale é Dyǒb kə́ə́ŋne á Bɛria, bêmpɛ̌ áwed, bébōōtēd ekud é bad asɔ́l áte âpɛɛn epuutéd. ");
INSERT INTO bssNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ábwɔ̄g-ábwɔ̄g dɔ́ɔ bad ábe bédúbpé Yesuɛ bélómé Paalɛ á nkin mé edíb é nkwɛ̌, boŋ Sailas bɔ́ Timoti pɛn bênlyə̌g á Bɛria. ");
INSERT INTO bssNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bad ábe bênkɛ̌ Paalɛ alyə́ged, bênkɛɛ́n mɔ́ kə́ə́ŋ bépɛ̄ɛ̄n mɔ́ á dyad á Atɛns boŋ bétimé ámbīd á Bɛria. Áde bétimɛɛ́ ámbīd, Paalɛ anlyə́gtɛ́n bɔ́ aá béláa Sailasɛ bɔ́ Timoti nɛ́n bán béhyɛ bétân mɔ́ á Atɛns ésebán bébébte póndé. ");
INSERT INTO bssNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paalɛ andyɛ̌ á Atɛns ásinéʼ Sailasɛ bɔ́ Timoti. Ngáne ásínéʼáá bɔ́, nlém mémbēb mɔ́ á abum bwâmbwam áyə̄le annyín nɛ́n aá myǒb mémpēe ḿme bébagɛɛ́ edúbé mélóné dyad áte ásyə̄ə̄l. ");
INSERT INTO bssNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Né-ɔɔ́ ankɛ̌ á ndáb é mekáne ákanlé bad bé Israɛl ne bad ábe béesɛ̌ bad bé Israɛl ábe bébage Dyǒb edúbé. Akagéʼáá kə́ə́ŋne átîntê e dyad epun tɛ́ɛ́ ákanlé kénzɛ́ɛ́ awě ampɛ̌ áhed. ");
INSERT INTO bssNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bɔ́ɔbɛ bad ábe bébédé á eʼpepé ábe béchə́géʼáá bán Epikurian ne Stɔik bɔ́mpē bépéntánnáá. Doŋge ásɛ́dtéʼáá bán, “Cheé anɛ́n mod awě abíde dúu múmɔ́ áhɔ́bɛɛ́ áde éebíiʼɛ́ dyamdyam?” Bémpēe béhɔ́béʼáá bán “Édé kabyánán ahɔ́be tə̂ŋgɛne myǒb mémpēe.” Béhɔ́béʼáá nɛ̂, áyə̄le áláŋgéʼáá bɔ́ tə̂ŋgɛne Yesuɛ ne mpuu. ");
INSERT INTO bssNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Dɔ́ɔ bétédé Paalɛ békɛ̄ɛ̄n mɔ́ á káánsɛl e mbwɔ́g eche béchə́géʼáá bán Ariopagus. Bénhɔ̄b bán “Sêdəə́ ádɛ́n ayə́ge dékɔ̄ɔ̄lē áde élâŋgɛɛ́ bad asôŋtɛn. ");
INSERT INTO bssNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Doŋge á mam áde éhɔ́bɛɛ́ ádé sé nken á etúu, sɛ́ɛ̄də̌ŋ-ʼɛ mɔ́ asôŋtɛn.” ");
INSERT INTO bssNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Bad bé Atɛns bésyə̄ə̄l ne beken ábe bébédé áwed, bébébtéʼáá echab póndé esyəə́l âkal ne âwóglɛn nkalaŋ tə̂ŋgɛne dyam dékɔ̄ɔ̄lē-tɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Dɔ́ɔ Paalɛ átyéémé ámīn áʼsō é káánsɛl é Ariopagus boŋ áhɔ́bé nɛ́n aá, “Á-bad bé Atɛns nnyíneʼ nɛ́n mɛɛ́, nyêbage myǒb edúbé bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nhɔ́be nɛ́n áyə̄le áde ńtómɛɛ́ nyé á dyad-tê, nnɔné mebón ḿme nyébagɛɛ́ myǒb edúbé. Nnyíné abwɔ́g ahɔ́g áde nyétélé áhed nɛ́n bán, ‘Hǒm áde dyǒb áde déebyɛ́ɛne.’ Ádê dyǒb áde nyébagɛɛ́ edúbé kénɛ́ɛ nyéēbíiʼɛ́ dɔ́, dɔ́ɔ ńlâŋgɛɛ́ nyé bɔɔb. ");
INSERT INTO bssNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Dyǒb áde áhə́gé nkǒŋsé ne chǒm ésyə̄ə̄l éche édé áwēd-te, mɔ́ adé Sáŋgwɛ́ɛ́ a nkoŋ ḿ mín ne ńsé. Eédyɛ̄ɛ̄ʼɛ́ á ndáb é myǒb éche baányoŋ bélóŋné mekáá, ");
INSERT INTO bssNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","eéhɛ̄dē-ʼaá chǒmchǒm éche déhɛle débɛ mɔ́ abɛle áde débɛnlɛɛ́ mɔ́. Ngáne édíí nɛ́n bán mwěn-ɛɛ́ abage aloŋgé, ábagé pemɛ ne kéchéé éche déhɛdɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Mod nhɔ́g mɔ́ɔ̄ ánsēbɛ̄ɛ̄ ahəg boŋ metúmbé mé nkǒŋsé mésyə̄ə̄l mébíd mbwiined ne ane mod nhɔ́g. Abɛlé bédyɛɛ-ʼɛ nkǒŋsé áte ńsyə̄ə̄l. Adêhɔ́b aá mɔ́həge bɔ́ ammad póndé atíi ne mebwɔ́g wɛ́ɛ bɛ́dyɛɛ́-ʼɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ambɛl nɛ́n, âbɛl boŋ béhɛd mɔ́, nzé béhɛ́dé-ʼɛ mɔ́ béhɛle-sɛ bényín mɔ́ awóg áde béwógé mɔ́ áyə̄l. Kénɛ̂, Dyǒb déechabnedɛɛ́ syánē modmod áyə̄l. ");
INSERT INTO bssNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Édé nɛ̂ŋgáne mod nhɔ́g áhɔ́bé aá, ‘Abɛ́ áde dédíí ne mɔ́, dedé á aloŋgé, dekag, dedé-ʼɛ chǒm éche dédíí.’ Édé-ʼɛ ámpē ngáne bekal bé ngan béhɔ́bé bán, ‘Syánē ámpē dedíi ábe bǎn.’ ");
INSERT INTO bssNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ngáne dédíí-ʼaá bǎn bé Dyǒb, deetə̂ŋgɛnɛɛ́ nɛ́ɛ dékamtanné nɛ́n bán Dyǒb ádíi nɛ̂ŋgáne chǒm éche bébɛ́nlé gôl, sílva kéʼɛ aláá áde baányoŋ bébɛ́nlédé ádab debyɛ́ɛ́ boŋ bélóón mekáá. ");
INSERT INTO bssNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Á póndé eche bad bénkêmbííʼɛ́ Dyǒb, Dyǒb dénkêntédté mbéb ḿmab nɛ̂ŋgáne dyam. Boŋ bɔɔb alâŋgeʼ moosyəə́l hǒm-tɛ́ aá bétɛde ḿmāb mbeltéd mé mbéb. ");
INSERT INTO bssNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Amaá-ʼɛ epun é bǐn atíi, éche ákāādtē mod-tɛ́ɛ́ nkǒŋsé áte ńsyə̄ə̄l nyaa echě etə́ŋgɛ́né. Apwɛdé mod awě ǎkāād ḿmê nkáá. Alúmté-ʼɛ moosyəə́l aá ane mod akwɔ̌gnédé, apuud áde apúúdté mɔ́ á kwééd.” ");
INSERT INTO bssNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Áde ábê bad béwógé Paalɛ ahɔ́bé tə̂ŋgɛne mpuu, doŋge á bad béwɛ́láá mɔ́ boŋ bɔ́ doŋge á bad bénhɔ̄b bán, “Sêhɛde bán ékale sé ḿmê nkalaŋ ámpē.” ");
INSERT INTO bssNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ámbīd e nɛ̂, Paalɛ anhidé átîntê echâb. ");
INSERT INTO bssNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Kə́ə́ŋ ne á asóg, nguse é bad êntimɛ́n Paalɛ bédúbé-ʼɛ Yesuɛ. Átîntê e ábê bad, mod abédé áhed awě béchə́géʼáá bán Diɔnesiɔsɛ. Abédɛ́ɛ mod a káánsɛl e Ariopagus. Mmwaád ámpē abédé áhed awě béchə́géʼáá bán Damarisɛ ne bad bémpēe. ");
INSERT INTO bssNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ámbīd enɛ̂, Paalɛ anhidé á dyad á Atɛns ákɛ̄ á dyad á Kɔrinto. ");
INSERT INTO bssNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Áde ápédé áwed antán mod a Israɛl nhɔ́g awě béchə́géʼáá bán Akwilaa. Bénchyāā mɔ́ á Pontus. Ḿmê mesú měn dɔ́ɔ bɔ́ mwaád, Prisilia bémbīdtē á Italia. Bémbīd á Italia áyə̄le Kaisɛɛ a Roma, Kladiosɛ antóméd ehə́ŋgé aá bad bé Israɛl bésyə̄ə̄l bésyəə á dyad á Roma. Paalɛ ankɛ̌ Akwilaa bɔ́ mwaád anyín. ");
INSERT INTO bssNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Andyɛɛ́n bɔ́ bɔ́ɔ̄bɔ̄ɔ bébɛle nsɔ́n. Bɔ́mpē, bélóóʼáá tɛ́ndɛ âkud mɔné ḿmê bétɔgnanné yə̌l melemlem nɛ̂ŋgáne mɔ́mpē ábɛ́léʼáá. ");
INSERT INTO bssNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Mbwɛ mé Nkɔ́me áte tɛ́ɛ́, Paalɛ akagéʼáá á ndáb e mekáne, ákanlé bad bé Israɛl ne bad bé Grikia âbɛl bédúbe mam ḿme áhɔ́bɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Áde Sailasɛ bɔ́ Timoti bébídé á Masɛdonia boŋ bétán Paalɛ, ambɛ̌ eche yə̌l esyəə́l âkal nkalaŋ ḿ bwâm. Alúmtéʼáá bad bé Israɛl áte aá Yesuɛ mɔ́ adé Ane-awě-Béwɔ́gté. ");
INSERT INTO bssNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Boŋ bépéntánnáá mɔ́, béhɔ̄bē-ʼɛ mɔ́ mekan mé mbéb áyə̄l. Nɛ̂ dêmbɛ̌l Paalɛ ankǔd ebumbú á yə̌l âlúmed bɔ́ nɛ́n aá nkɔ́gsɛn ń Dyǒb ńsineʼ bɔ́, aláá-ʼɛ bɔ́ aá, “Nzé nyêbɔ́ɔ́, né nyéběn-ɛɛ́ nyêbɛlé. Meésaá mɛ áte. Bootya bɔɔb, nkag nkalaŋ ḿ bwâm akal wɛ́ɛ bad ábe béesɛ̌ bad bé Israɛl.” ");
INSERT INTO bssNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Né-ɔɔ́ Paalɛ antɛdé bɔ́ ákɛ ádyɛɛ́ʼ wɛ́ɛ mod nhɔ́g awě béchə́géʼáá bán Titus Justusɛ. Titusɛ abágéʼáá Dyǒb edúbé, ndáb embɛ́-ʼɛ mɔ́ bɛnbɛn ne ndáb e mekáne e bad bé Israɛl. ");
INSERT INTO bssNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispusɛ awě alyə́gtéʼáá ndáb e mekáne mɔ́mpē andúbé Sáŋgwɛ́ɛ́ nchoo ne ádē abum á ndáb ásyə̄ə̄l. Bad híin-nɛ ábe bémbɛ̄ á dyad á Kɔrinto, bénwōg ḿmê nkalaŋ, bédúbe, békūd-tɛ edusɛn. ");
INSERT INTO bssNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ébédé nkuu nhɔ́g Paalɛ annyín ndɔ́g. Á ndɔ́g-te wɛ̂, Sáŋgwɛ́ɛ́ anláá mɔ́ aá “Weebááʼ, kanlé bɔ́ ékag áʼsō, weétimné mbíd. ");
INSERT INTO bssNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Bíí nɛ́n wɛɛ́ ndé ne wɛ, modmod éēhɛ̄lɛ̄ɛ̄ wɛ dyamdyam abɛl, áyə̄le ábêm bad híin bédé á dyad-tê hɛ́n.” ");
INSERT INTO bssNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Né-ɔɔ́, Paalɛ andyɛɛ́ áwed mwɛ̌ nhɔ́g ne epɛd, áyə̄gtē bad eyale é Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Áde Kaisɛɛ ábɛ́lé Galio nkamlɛnɛ ambáá á mbwɔ́g e Akaya, bad bé Israɛl ábe bémbɛ̄ áwed bênladɛ́n, békób Paalɛ, békɛ̄ɛ̄n mɔ́ á kóte. ");
INSERT INTO bssNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Bénhɔ̄b nɛ́n bán “Anɛ́n mod atéde bad nlém á abum aá bébɛnle Dyǒb, nyaa echě eetə̂ŋgɛne ngáne mbéndé éhɔ́bɛɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Áde Paalɛ áhɔ́bé aá mɔ́hɔ̂b dyam, dɔ́ɔ nkamlɛnɛ Galio álâŋgɛɛ́ bad bé Israɛl aá, “Nzé ádɛ́n akan démbɛ̄ nɛ́ɛ awusé kéʼɛ dyam dé ebébtéd áde mod ábɛ́lé, né nwóó nzɔm âwóglɛn nyé bad bé Israɛl. ");
INSERT INTO bssNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Boŋ ngáne édíí bán ádíi dyam dé mpentɛn tə̂ŋgɛne eʼyale, mǐn ne échɛn mbéndé, nyéběn nyémad dɔ́. Meekáádtɛ́ɛ́ échê ndín é mehɔ́b.” ");
INSERT INTO bssNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Nɛ́n dêmbɛ̌l Galio anan bɔ́ á ndáb e kóte. ");
INSERT INTO bssNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Hɛ́ɛ bɔ́ moosyəə́l bétɔ́lé mod awě alyə́gtéʼáá ndáb e mekáne awě béchə́géʼáá bán Sɔstɛnɛ, boŋ bébɔmé mɔ́ áʼsō éʼ kóte. Boŋ nɛ́n dénkêmbɛnlé Galio dyamdyam. ");
INSERT INTO bssNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paalɛ ankoód mwǎ adyɛɛ á Kɔrinto ne bad ábe bédúbpé Krǐstəə. Dɔ́ɔ átɛ́dté bɔ́, boŋ asɔ́l á stíma, áchabpé edíb é nkwɛ̌ ákǎg á mbwɔ́g e Siria. Adɛ̂kɛ̌, ankɛ̌ ne Prisilia bɔ́ Akwilaa. Adɛ̂hidé á dyad á Sɛnkria, ankəə́n nló áyə̄le melɛ̌ ḿme ámmwɛ̄ɛ̄. ");
INSERT INTO bssNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Bêmpɛ̌ á Efɛsus. Áde bépédé áwed, Paalɛ antɛdé Prisilia bɔ́ Akwilaa, ákɛ̄ á ndáb e mekáne bɔ́ɔbɛ bad bé Israɛl békaleʼ. ");
INSERT INTO bssNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ábê bad bénlāā mɔ́ bán bɔ́ɔ̄bɔ̄ɔ békood mwǎ adyɛɛ ámpē, boŋ enkênkwɛntɛ́nné. ");
INSERT INTO bssNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Boŋ adé áhídté, anláá bɔ́ aá “Nzé ntíi ń Dyǒb mɔ́ɔ̄ ndé, né mɛ̌tǐm ámbīd áwɛ̄n.” Né-ɔɔ́, ansɔ́l á stíma áhīdē-ʼɛ á Efɛsus. ");
INSERT INTO bssNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Áde ápédé á dyad á Kaisaria, ankɛ̌ á Jerusalɛm, ákɛ álɛ̄lēd bad bé mwembé, boŋ ákǎg á Antyɔg. ");
INSERT INTO bssNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Áde ákɛ̄lēbpē mwǎ adyɛɛ áwed, anhidé, ákɛ̄ á mbwɔ́g e Galesia ne Frigia ábagé bad ábe bédúbpé Yesuɛ bésyə̄ə̄l elébé âwéd bɔ́ nlém á abum. ");
INSERT INTO bssNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ámbīd enɛ̂, mod a Israɛl nhɔ́g awé béchə́géʼáá bán Apolosɛ awě bénchyāāʼɛ́ á dyad dé Alɛsandria ampɛ̌ á Efɛsus. Anɛ́n mod abyɛ́ɛ́ʼáá dyam ahɔ́b bwâmbwam, ansóŋtɛ́n-nɛ kálag e Dyǒb bwâm. ");
INSERT INTO bssNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","An'yə́gé mekan mé nzii e Sáŋgú. Akaléʼáá, áyə̄gtē-ʼɛ bad mekan ḿme Yesuɛ nyaa eche etə́ŋgɛ́né ne kə́n esyəə́l. Boŋ pɛn edusɛn éche Jɔnɛ chěmpɛn chɔ́ɔ ámbīīʼɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ambootéd pɔ́le akal á ndáb e mekáne ésebán abáaʼ dyamdyam. Áde Prisilia bɔ́ Akwilaa béwógé mekan ḿme áhɔ́bɛɛ́, béntēd mɔ́, békɛ̄ɛ̄n mɔ́ wɛ́ɛ bédyɛ́ɛ́ʼáá. Hɛ́-ʼaá bélúmté mɔ́ mekan mé nzii e Dyǒb áte nyaa eché etə́ŋgɛ́né. ");
INSERT INTO bssNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolosɛ antíí aá mɔ́kag á aloŋ á Akaya. Né-ɔɔ́, bad ábe béndūbē á Efɛsus bénwōŋgɛ̄n mɔ́. Bêntelé bad ábe bédúbpé Yesuɛ a Akaya nɛ́n bán nzé apedé, békob mɔ́ nken. Áde ápédé áwed, anwóŋgɛ́n bad bwâmbwam ábe béndūbē Yesuɛ áyə̄le nsimé ń Dyǒb ḿme békúdé. ");
INSERT INTO bssNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ne mpentɛn ngíne, antóm bad bé Israɛl áte átîntê e bad. Ábɛnlád metɔ́n ḿme mébídé á kálag e Dyǒb âlúmed nɛ́n bán Yesuɛ mɔ́ adé Ane-awě-Béwɔ́gté. ");
INSERT INTO bssNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolosɛ ambɛ́ abɛ́ á Kɔrinto, dɔ́ɔ Paalɛ ápóó ene pɛd e mbwɔ́g áte boŋ ápag á Efɛsus. Antán nguse é bad áwed ábe bédúbpé Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Dɔ́ɔ ásɛdtɛɛ́ bɔ́ aá “Áde nyéndūbɛ̄ɛ̄ nyênkǔd Edəə́dəŋ eche Ésáá-yɛ?” Bêntimtɛ́n mɔ́ bán, “Aáy, séēwōgɛ̄ɛ̄ ké wógɛ́n bán chǒm édé éche béchəgɛɛ́ bán Edəə́dəŋ éche Ésáá.” ");
INSERT INTO bssNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paalɛ ansɛdéd bɔ́ aáken, “Nyaa e edusɛn ehéé-ʼɔ̄ nyênkudté?” Bênkwɛntɛ́n bán, “Nyaa e edusɛn echě Jɔnɛ áhɔ́béʼáá.” ");
INSERT INTO bssNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paalɛ anláá bɔ́ aá, “Nyaa edusɛn echě Jɔnɛ áhɔ́béʼáá ebédɛ́ɛ áyə̄le bad ábe bétɛ́dté abɛl dé mbéb, Jɔnɛ álāŋgē-ʼɛ bad bé Israɛl aá bédúbe ane awě ǎpɛ̌ ámbīd echê, nɛ́dē Yesuɛ.” ");
INSERT INTO bssNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Áde ábɛ̂ bad béwógé chǒm éche Paalɛ áhɔ́bé, bêndusɛ́n bɔ́ á dǐn áde Sáŋgú Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paalɛ ambán bɔ́ mekáá á nló, Edəə́dəŋ éche Ésáá épīī-ʼɛ bɔ́. Dɔ́ɔ bébóótédé mehɔ́b mémpēe ahɔ́b ḿme bad béesóŋtánne, békalé-ʼɛ nkalaŋ ń Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ábê bad bébédé dyam dyôm ne bébɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paalɛ andyɛ̌ áwed dyam ngɔn éláán. Póndé-tɛ́ akagéʼáá á ndáb e mekáne, ákanlé bɔ́ ésebán abáaʼ dyamdyam. Bɔ́ɔ̄bɔ̄ɔ bépéntánnáá, áwané-ʼɛ áte âbɛl bédúbe nɛ́n bán chǒm éche áhɔ́bɛɛ́ tə̂ŋgɛne nkamlɛn ń Dyǒb édé mbále. ");
INSERT INTO bssNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Boŋ bɔ́ doŋge á bad bénwūū nló áte, béekobpe adúbe, béhɔ̄bē-ʼɛ mekan mé mbéb tə̂ŋgɛne Nzii e Sáŋgú áʼsō é bad bésyə̄ə̄l. Né-ɔɔ́, Paalɛ antɛdé bɔ́, ákɛ̄ɛ̄n bad ábe bédúbpé. Epun-tɛ́ bɔ́ɔ̄bɔ̄ɔ bépéntánnáá á ndáb e ayə́ge echě meléede Tiranusɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Paalɛ ambɛl nɛ́n á etûn é mwɛ̌ ḿbɛ. Nɛ̂ dêmbɛ̌l bad bé Israɛl ne bad ábe béesɛ̌ bad bé Israɛl ábe bédyɛ́ɛ́ʼáá á mbwɔ́g e Esia bénwōg eyale é Dyǒb. ");
INSERT INTO bssNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Dyǒb dêmbɛ̌l Paalɛ ábɛlé mam mé menyáké ḿme bad bénkêmmɛntɛ́nné anyín. ");
INSERT INTO bssNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Bad bétédéʼáá ké betumbɛ kéʼɛ bewáŋgɛsɛ ábe Paalɛ ábɛ́nlédé, békɛ̄ɛ̄n wɛ́ɛ bad bé nkole, bébɛnlád bɔ́ âmad bɔ́ nkole, bébīdtē-ʼɛ bɔ́ eʼdəə́dəŋ bé mbéb áte. ");
INSERT INTO bssNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Doŋge á bad bé Israɛl ábe bɔ́mpē békágéʼáá mebwɔ́g ne mebwɔ́g bébídté bad eʼdəə́dəŋ bé mbéb áte, bɔ́mpē bênwanɛ́n âbɛnled dǐn áde Sáŋgú Yesuɛ âbɛl ḿmɛ́n nsɔ́n. Béláŋgéʼáá eʼdəə́dəŋ bé mbéb bán, “Nkamlan nyé á dǐn áde Yesuɛ awě Paalɛ ákanlɛɛ́ bad, nɛ́n mɛɛ́ nyébîd ane mod áte.” ");
INSERT INTO bssNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Prisɛ ambáámbáa a bad bé Israɛl nhɔ́g abédé awě béchə́géʼáá bán Skeva. Anchyáá bǎn bé baachóm saámbé. Ábê bǎn bɔ́ɔ̄ bébɛ́léʼáá nɛ̂. ");
INSERT INTO bssNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Boŋ póndé pɔ́g, edəə́dəŋ é mbéb énlāā bɔ́ nɛ́n aá “Mbíí Yesuɛ, mbíí-ʼɛ Paalɛ, benzɛ́ɛ́ nyé-ʼɛ nyédíí?” ");
INSERT INTO bssNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Hɛ́ɛ ane mod awě edəə́dəŋ é mbéb ébédé áte, ábónlédé bɔ́ ne ngíne esyəə́l, atóm-mɛ bɔ́ áte. Bédɛ̂hɔ́b bán bétóme mehélé né amaá bɔ́ alɔ́gɛn, ámād-tɛ bɔ́ mbɔ́té anyabted. ");
INSERT INTO bssNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Bad bé Israɛl ne bad ábe béesɛ̌ bad bé Israɛl ábe bédyɛ́ɛ́ʼáá á Efɛsus bénwōg ádɛ́n dyam. Áde béwógé dɔ́, mbwɔ́g ménkōb bɔ́ bwâmbwam. Dǐn áde Sáŋgú Yesuɛ dɔ́-ʼɛ dênkǔd edúbé éche échábé ámīn. ");
INSERT INTO bssNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bad híin ábe béndūbē, bêmpɛ̌ á nhɛ́né, bépanlé yə̌l áte, béhɔ̄bēʼ mekan mé mbéb ḿme békɛ̄bɛnlé. ");
INSERT INTO bssNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bad híin ábe békúméʼáá ngaŋ béntēd échab kálag éche bébɛ́nládtáá âkum ngaŋ, bépɛ̄ɛ̄n chɔ́, béhyáád chɔ́ á nhɛ́né. Kálag ésyə̄ə̄l éche bénhyāādtē éhɛ́láá-sɛ ébɛ nkun dyam móom mé míliɔn métáan. ");
INSERT INTO bssNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ḿmɛ́n mekan mésyə̄ə̄l ḿme mébɛnládtáá mênkə̌ŋ bad híin béndūbē eyale éche Sáŋgwɛ́ɛ́, ḿmē nkalaŋ ńkanlád-tɛ ngíne ngíne. ");
INSERT INTO bssNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Áde ḿmɛ́n mekan mémáá abɛnled, Paalɛ ammǎd áwē nlém-tê aá mɔ́ɔ̄pǒŋ á mbwɔ́g é Masɛdonia ne á Akaya boŋ ákag a Jerusalɛm. Dɔ́ɔ áhɔ́bɛɛ́ aá, “Nzé mbídé á Jerusalɛm ntə́ŋgɛ́né akɛ á Roma.” ");
INSERT INTO bssNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Né-ɔɔ́, anlóm bad bébɛ ábe béwóŋgánnáá mɔ́, Timotiɛ bɔ́ Erastus á Masɛdonia, mwěn-nɛ ályə̄g á mbwɔ́g e Esia, ádyɛ̄ɛ̄ ámpē mwǎ esóŋ é póndé. ");
INSERT INTO bssNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Enɛ́n póndé chěn dɔ́ɔ̄ mpuutéd ń ngíne ḿbédé á Efɛsus tə̂ŋgɛne Nzii e Sáŋgú echě bad béhídéʼáá. ");
INSERT INTO bssNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Mod nhɔ́g abédé bán Demɛtrusɛ. Alúɛ́ʼáá bwěm bé eʼkii. Abɛléʼáá bwěm ábe bénwāgɛ̄n bwěm éʼ ndáb e dyǒb áde béchə́géʼáá bán Atɛmisɛ. Ḿmɛ́n nsɔ́n ḿpíínádtáá ábe bad bé nsɔ́n nsyə́ŋ ḿme ńchábé ámīn. ");
INSERT INTO bssNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Anlǎd ábē bad bé nsɔ́n áte ne bad ábe bɔ́mpē bébɛ́léʼáá ene ndín e nsɔ́n, álāŋgē bɔ́ aá, “Amúɛ̄, nyêbíí nɛ́n bán ḿme syánē nhɔn ńsyə̄ə̄l ńhúú ne ḿmɛ́n nsɔ́n ḿme débɛlɛɛ́ nɛ́n. ");
INSERT INTO bssNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Bɔɔb-pɔɔ́, nyéběn nyênyíneʼ, nyêwóge-ʼɛ chǒm éche anɛ́n Paalɛ ábɛlɛɛ́. Ahɔ́be nɛ́n aá myǒb ḿme bébɛ́nlé mekáá méesaá myǒb ne abɛ́ děn. Abɛlé-ʼɛ bad híin ábe bédé á Efɛsus ne á mbwɔ́g esyəə́l e Esia, bédúbpé bán mam ḿme áhɔ́bɛɛ́ médé mbále. ");
INSERT INTO bssNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Né-ɔɔ́ mbáaʼ nɛ́n mɛɛ́, nyoŋgé eche syánē ěbēb dǐn. Saá-kaá nɛ̂ děmpɛn, mbáaʼ mɛɛ́ kə́ə́ŋne ndáb e ndəle e dyǒb, Atɛmisɛ chɔ́mpē éebáá dyam dé abɛlɛn ámpē. Bad béenyínné mɔ́ ámpē nɛ́ɛ dyam, áde édíí-ʼaá bán adíi dyǒb áde bad bé Esia bésyə̄ə̄l ne bad bé nkǒŋsé bésyə̄ə̄l bébɛnlɛɛ́.” ");
INSERT INTO bssNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Áde ene ndun e mod éwógé nɛ̂ bênliŋ bwâmbwam, bébootéd-tɛ abón bán, “Atɛmisɛ, dyǒb dé Efɛsus adé ngum tómaa myǒb mésyə̄ə̄l.” ");
INSERT INTO bssNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ḿmê mpuutéd mênkonnéd dyad áte ásyə̄ə̄l. Ene ndun e mod entɔ̌l Gayɔsɛ bɔ́ Aristakusɛ ábe bémbīd á Masɛdonia ábe bɔ́ɔbɛ Paalɛ bênwǒŋ. Béntōmɛ̄n bɔ́ mehélé, békɛ̄ɛ̄n bɔ́ á ndáb e mbom e bad bé dyad. ");
INSERT INTO bssNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paalɛ mwěn amboŋsɛ́n âbíd ene ndun e mod áʼsō, boŋ bad ábe bédúbpé Yesuɛ bénkênkwɛntɛ́nné. ");
INSERT INTO bssNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Nguse é bad ábe béhɔ́bpáá mbwɔ́g ábe bɔ́ɔbɛ Paalɛ béwóóʼáá, bɔ́mpē bénlōmē mɔ́ nlébtéd, ne mecháŋgé nɛ́n bán eékə̄gēʼ aá mɔ́kag bad atyéem áʼsō wɛ́ɛ béládné. ");
INSERT INTO bssNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ene póndé, epuutéd êmpɛ̌ á mbom-tê. Doŋge á bad bébōnēʼ áyə̄le dyam ahɔ́g, ábíníí-ʼɛ bébōnē áyə̄le ádíníí, áyə̄le bɔ́ bad híin bénkêmbííʼɛ́ ké atɔ́n áde áládé bɔ́ áhed. ");
INSERT INTO bssNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ngáne édíí nɛ́n bán Alɛsandaa mɔ́ɔ bad bé Israɛl béntōmēdtē áʼsō, bad behɔ́g béláŋgéʼáá mɔ́ bán mɔ́ atə́ŋgɛ́né bad mekan alúmed áte. Hɛ́ɛ Alɛsandaa álúmté ekáá aá bad bélâm ehɔ́b. Ahɛdéʼáá bad alúmed áte nɛ́n aá saké bɔ́ɔbɛ ábê bad békə́ə́ boŋ mpuuted ḿbɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Boŋ áde bad béchémé nɛ́n bán Alɛsandaa adíi mod a Israɛl, bɔ́ moosyəə́l bêmbootéd abón bán, “Atɛmisɛ, dyǒb dé Efɛsus adé ngum tómaa myǒb mésyə̄ə̄l.” Bémbōn nɛ́n áyə̄le háwa ébɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Kə́ə́ŋ ne á asóg, mod a mbwɔ́g nhɔ́g mɔ́ amběd bad áte. Anhɔ́b aá, “A-baányaŋ bé Efɛsus, moosyəə́l abíí aá dyad dé Efɛsus dɔ́ɔ ánɔne ndáb e mekáne eche Atɛmisɛ, eche syánē ndəle e dyǒb. Moosyəə́l abíí-ʼɛ aá ádɛ́n dyad dɔ́ anɔ́ne kə́ə́ŋne aláá á ngəŋgú áde ábídé ámīn. ");
INSERT INTO bssNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ngáne nyé moosyəə́l nyébíí-ʼaá nɛ́n bán modmod eéhɛ̄lɛ̄ɛ̄-sɛ ahɛ́ ḿmɛ́n mekan nswaŋ, éebooʼɛ́ bán nyépɛɛn mpoŋgé ké nhɔ́g. ");
INSERT INTO bssNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ké nɛ̂ŋgáne nyépɛ́ɛ́né ábɛ́n bad hɛ́n, béēchíbɛɛ́ chǒmchǒm á ndáb é myǒb, béēhɔ́bɛɛ́-ʼɛ ádɛd dyǒb mekan mé mbéb áyə̄l. ");
INSERT INTO bssNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Né-ɔɔ́, nzé Demɛtrusɛ ne ábē bad bé nsɔ́n béwóŋné mod mehɔ́b, bébíi nɛ́n bán eʼpun éʼ kóte éʼdé, bad bé mbwɔ́g-kɛ bédé ábe békáadte. Béhɛle-sɛ bésɔ́mɛ́n ane mod áhed. ");
INSERT INTO bssNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nzé-ʼɛ chǒm émpēe édé éche nyékooʼɛ́ ahɛd né mbom ḿ bad bé dyad, mɔ́ɔ̄ mɛ̄yālē, ngáne mbéndé ékalɛɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Nhɔ́be nɛ́n áyə̄le dyam áde ábɛ́nlédé chii, ngɔ́menaa a Roma ǎhɔ̄b aá syánē depɛɛ́né mpoŋgé. Nzɔm ké pɔ́g eésaá echě débɛlɛɛ́ ḿmɛ́n mpuuted ńsyə̄ə̄l. Nzɔm e bwâm ké pɔ́g-kɛ eésaá echě dehɛle débɛ bɔ́ áyə̄le ḿmɛ́n mpuutéd.” ");
INSERT INTO bssNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Áde ámáá ahɔ́b nɛ̂ anláá bad aá mod tɛ́ɛ́ asúɛʼ áwe ndáb. ");
INSERT INTO bssNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Áde mpuutéd ḿmáá boŋ ekíde émad ahɔ́ɔ áte, Paalɛ anlǎd bad ábe bédúbpé Yesuɛ áte, ályə̄gtān bɔ́ ne eʼyale ábe éʼwéde bɔ́ nlém á abum. Áde ámáá bɔ́ alyə́gtɛn dɔ́ɔ áhídté, boŋ ákǎg á Masɛdonia. ");
INSERT INTO bssNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Akagéʼáá échê mbwɔ́g, álāŋgē bad nkalaŋ híin ḿme ńwéde bɔ́ nlém á abum. Dɔ́ɔ ápédé á Akaya. ");
INSERT INTO bssNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Andyɛɛ́-ʼɛ áhed á etûn e ngɔn éláán. Abǒŋsánnáá âkɛ á aloŋ á Siria, dɔ́ɔ ásóŋtɛ́né aá bad bé Israɛl béhəgke mɔ́ âwúu mɔ́. Hɛ́ɛ átíídé aá mɔ́ɔ̄tǐm ámbīd mɔ́bwɛ̄ á Masɛdonia. ");
INSERT INTO bssNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Bad híin bênwoón mɔ́. Bébédɛ́ɛ Sopataa, mwǎn awe Piirusɛ awě ambíd á Bɛria, Aristakusɛ bɔ́ Sekundus ábe bémbīd á dyad a Tɛsalonika. Gayɔsɛ awě ambíd á dyad a Debɛ, Timotiɛ, ne Tikikusɛ bɔ́ Trofimus ábe bémbīd á mbwɔ́g e Esia. ");
INSERT INTO bssNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ábɛ́n bad bênkɛ̌ áʼsō, bésinéʼ sé a dyad á Troas. ");
INSERT INTO bssNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Áde Ngande e Ewɛle é Ngɛ̂n étómé, sênsɔ́l bɔ̌lɛ á dyad á Filipi, boŋ ámbīd e eʼpun étáan sêntán bɔ́ a Troas. ");
INSERT INTO bssNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Á Sátedɛ́ ngukɛ́l, sênladɛ́n áte hǒm ahɔ́g âdyɛ́ ndyééd âlúmed edəŋge é Sáŋgú. Paalɛ akǎnléʼáá bɔ́ pɔ́le. Akaláá akal ne akal, kə́ə́ŋne melúde mé nkuu, ngáne édíí nɛ́n bán antə́ŋgɛ́n akɛ nɛ́ɛ bǐn éʼsáŋgé. ");
INSERT INTO bssNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Bênchǒd eʼtrúkáŋ híin á toŋ ámīn wɛ́ɛ sênladɛ́nné. ");
INSERT INTO bssNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Kɔ́demod pɔ́g ébédé echě béchə́géʼáá bán Yutikusɛ andyɛɛ́ á wíndɛ, eʼchə́ éʼkɛ́ɛ́néʼáá mɔ́ mwǎtiíd tiíd ngáne eʼchə́ bémbɛ̄ɛ̄ mɔ́ á dǐd. Achabed áde Paalɛ ânchabédté pɔ́le áte, dênkə̌ŋ ansɔ́l á eʼchó-te bwâmbwam. Dɔ́ɔ ápɔ́dté á toŋ ámīn á ndə́gke eláán, ahún á ndɔɔb. Békíí-ʼaá mɔ́ atéd, bétānē amaá awɛ́. ");
INSERT INTO bssNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paalɛ ansǔd á ndáb mîn wɛ̂, akúdɛ́n mɔ́ ámīn boŋ áseb mɔ́. Dɔ́ɔ álâŋgɛɛ́ bad aá “Nyéētāgē áte, eewédɛɛ́, adíi adé á aloŋgé.” ");
INSERT INTO bssNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Dɔ́ɔ Paalɛ átímé ámbīd á ndáb mîn, ásāl ewɛle áte boŋ bɔ́ɔbɛ bad ábe bédúbpé Krǐstəə bédyāg. Bɔ́ɔ̄bɔ̄ɔ bênkoód adyɛɛ, békaléʼ pɔ́le kə́ə́ŋ bǐn éʼsáa, boŋ ákag. ");
INSERT INTO bssNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bénlyə̄gēd ene kɔ́demod á ndáb áde mwěn ádíí aloŋgé. Ábê bad bémbɛ̄ menyiŋge bwâmbwam. ");
INSERT INTO bssNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Sêmbɛ́ áʼsō sêsɔ́l á stíma-tê, sépōŋ á edíb é nkwɛ̌, sékɛ̄ á dyad á Asɔs. Áwed dɔ́ɔ séntə̄ŋgɛ̄nnē Paalɛ apém. Anhɔ́b aá sébɛ̂ áʼsō áyə̄le nzii e dyad-tê chɔ́ɔ ânkɛɛ́nné. ");
INSERT INTO bssNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Áde átáné sé á dyad á Asɔs, sêmpém mɔ́ á stíma-tê boŋ syáābɔ̄ɔ sékǎg á dyad á Mitilɛnɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Sêhǐdté-ʼaá hɛ̂ boŋ nɛ́ɛ bǐn éʼsáŋgé sékag kə́ə́ŋ sépǎg á nkin ń dyad á Kiɔs. Bǐn bán bɛ́sāā ámpē éʼsáŋnéd sé á nkin ń dyad á Samɔs, epun éche émbātɛ̄n sépǎg á nkin ń dyad á Milɛtus. ");
INSERT INTO bssNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paalɛ antíí nɛ́n aá sétôm dyad dé Efɛsus ámīn âbɛl boŋ séebébté póndé á mbwɔ́g e Esia. Ahɛdéʼáá aá mɔ́wâmsɛn apɛ á Jerusalɛm epun é Pɛntekɔs édɛ̂hɔ́b bán chɔ́ épag áte. ");
INSERT INTO bssNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Áde sépédé á dyad á Milɛtus, Paalɛ anlóm nsəl wɛ́ɛ belyə́ged bé mwembé bé Efɛsus, aá bétân mɔ́ á Milɛtus. ");
INSERT INTO bssNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Bépédé-ʼaá boŋ álāŋgē bɔ́ nɛ́n aá “Nyéběn nyêbíí ngáne ḿbédé ne nyé bootya epun éʼsō áde ńsúmé mekuu á mbwɔ́g e Esia. ");
INSERT INTO bssNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mbɛ̌nléʼáá Sáŋgwɛ́ɛ́ ne asuded á yə̌l ásyə̄ə̄l, ńkudé ndutul ne mekəgsɛn áyə̄le ahəge áde bad bé Israɛl béhə́gkéʼáá me. ");
INSERT INTO bssNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Nyéběn nyêbíí bán áde ńkánléʼáá nyé nkalaŋ ḿ bwâm, ń'yə̄gtē-ʼɛ nyé á nhɛ́né, ne áwɛn mendáb, menkênkoŋnédté nyé dyamdyam áde déntə̄ŋgɛ̄n nyé awôŋgɛn. ");
INSERT INTO bssNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Melemlem nɛ̂ŋgáne ménsīmmē bad bé Israɛl etúu áte nê dɔ́-ʼaá ménsīmmē bad ábe béesɛ̌ bad bé Israɛl mɛɛ́ bétɛde ádāb abɛl dé mbéb, bétimɛn Dyǒb, bédúbé-ʼɛ awɛd Sáŋgwɛ́ɛ́, Yesuɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Bɔɔb-pɔɔ́, Edəə́dəŋ éche Ésáá élûmte mɛ áte aá ntə́ŋgɛ́né akɛ á Jerusalɛm, meebíi-ʼáa chǒm éche ébɛnléd ne mɛ áwed. ");
INSERT INTO bssNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Mbíí pɛn nɛ́n mɛɛ́ dyad-tɛ́ áde ńkagké Edəə́dəŋ éche Ésáá émáá mɛ etúu asím áte nɛ́n aá mbwɔg ne ndutul bɔ́ɔ bésine mɛ. ");
INSERT INTO bssNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Boŋ meetédɛɛ́ ádêm aloŋgé nɛ́ɛ dyam, nhɛde mɛɛ́ ḿpid ḿmêm nsɔ́n á asóg, ḿmad-tɛ nsɔ́n ḿme Sáŋgú Yesuɛ ábágé mɛ áte. Ḿmêm nsɔ́n ńdíi âkal nkalaŋ ḿ bwâm tə̂ŋgɛne nsimé ḿme Dyǒb álûmtɛɛ́ baányoŋ